﻿USE sofia;
DROP TABLE IF EXISTS sofia.gai_vpl;
CREATE TABLE gai_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES gai_vpl WRITE;
INSERT INTO gai_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Na ganna ande, Iesus Karaisna nicar ŋgamrirta wiwit. Na Iesus Karaisa ma Dewitna wiwitnan, na Dewitta ma Abraamna wiwitnan. ");
INSERT INTO gai_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Na Abraamma ma Aisakna aet, na Aisaka ma Iakopna aet, na Iakopa ma Iudaapa mana laiplacarta aet. ");
INSERT INTO gai_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Na Iudana nuocniŋa Peresapa Sera, na maniŋna aemma Tamar. Na Peresa ma Esronna aet, na Esron ma Ramna aet. ");
INSERT INTO gai_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Na Ramma ma Aminadapna aet, na Aminadap ma Nasonna aet, na Nason ma Salmonna aet. ");
INSERT INTO gai_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Na Salmon ma Boasna aet, na mana aemma Reap, na Boasa ma Obetna aet, na mana aemma Rut, na Obet ma Iesina aet, ");
INSERT INTO gai_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","na Iesi tikca ma gagrirta ramoot paŋan Dewitna aet. Na Dewitta ma Solomonna aet, na Solomonna aemma, outta ma Uraia laŋgoca eacrina. ");
INSERT INTO gai_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Na Solomonna ma Reaboamna aet, na Reaboamma ma Abiana aet, na Abia ma Asana aet. ");
INSERT INTO gai_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Na Asa ma Iosapatna aet, na Iosapatta ma Ioramna aet, na Ioramma ma Usiana aet. ");
INSERT INTO gai_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Na Usia ma Iotamna aet, na Iotam ma Acasna aet, na Acas ma Aesekaina aet. ");
INSERT INTO gai_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Na Aesekaia ma Manasana aet, na Manasa ma Emonna aet, na Emon ma Iosaiana aet. ");
INSERT INTO gai_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Na Iosaia ma Iekoiakinapa mana laiplacarta aet, na an kɨdrɨkca Babilonnanda, Israelnanap ruŋga minmo tuomb naaŋgɨca Babilonna tɨkrina. ");
INSERT INTO gai_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Karica mina taŋga Babilonna inikca mbukca, anna eacatna nicarta wiwitta, gade, Iekoiakina ma Sialtielna aet, na Sialtiel ma Serubabelna aet. ");
INSERT INTO gai_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Na Serubabela ma Abiutna aet, na Abiut ma Eliakimna aet, na Eliakimma ma Asorna aet. ");
INSERT INTO gai_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Na Asora ma Sadokna aet, na Sadokca ma Akimna aet, na Akimma ma Eliutna aet. ");
INSERT INTO gai_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Na Eliuta ma Eleasarna aet, na Eleasar ma Matanna aet, na Matan ma Iakopna aet. ");
INSERT INTO gai_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Na Iakopa ma Iosepna aet, na Iosepa ma Mariana kaŋgait. Na Maria ma Iesusa mɨratna meac, na Iesusa ma Karais. ");
INSERT INTO gai_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ainda moca an Abraamna wiwitta muruŋa kɨpca Dewitna wiwitna mɨnna tɨkatnanna, anna parniŋapa mbutremb paurna mɨn, na Dewitna mɨnna tɨkca kɨpca Babilonnanda, minmo tuomb naaŋgɨatna mɨnna, an toco parniŋapa mbutremb paurna mɨn, na Babilonnanda minmo tuomb naaŋgɨa kɨpca Karaisna mɨn toco, anna parniŋapa mbutremb paurna mɨn. ");
INSERT INTO gai_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Na Iesus Karaisa mɨratna nininia gaind, mana aemma Maria, mina manmo Iosep laŋgona moca mababuat. Na an mɨnna maniŋa laŋgo ŋgocor ndeacri, mina wattatnanna Maria, Raraŋ Aetaniacna Ŋeroŋ Ratna gargar mbuŋa ma niktan. ");
INSERT INTO gai_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ri, mana kaŋgait Iosep, ma ramoot wandoŋ laŋ tik, ma Mariamo numbir neaŋ narica, mana tɨki mona iroarta moca ma gaind mamoat, ma manmo laŋanna tɨkcarina moca ma ndona iro mamoat. ");
INSERT INTO gai_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ainda moca Iosepa an iroap eacri, Kacoot Raraŋ Aetaniacna mbaiŋna aiŋa morena ŋeroŋa manmo tamram mbuŋ nakɨpca manmo gaind mambopat, “Iosep, Dewitna ŋgamaɨr, u ndona meac aŋgɨca laŋgona kai nanambi teac, u warac, an mooŋnuoca mana nikinik ndeacrenanna, anna Raraŋ Aetaniacna Ŋeroŋ Rat neaŋrina. ");
INSERT INTO gai_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Na ma Nuocna mooŋnuoca mɨrnande, te, u mana imo Iesus ŋgacnande, na an ina mɨnɨŋa gaind, ma ndona meikramtaɨrta tɨpemb ŋgorikta makukara mo kecarica, minmo mac nda aŋgɨnande.” ");
INSERT INTO gai_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Aintik an kirarira larurinanna, anna Kacootta ndona ramma morina ramootna kamma moi mɨnna tɨkna moca. Na mana ramma morina ramootta gaindopatna, ");
INSERT INTO gai_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Meac ianna ma ramootap ŋgoŋgortanna, ma nik tɨkca nuocna mooŋnuoc ianna mɨrnande. Te, mina manmo Emanuel ŋgacnandet.” Na an ina mɨnɨŋa gaind, “Raraŋ Aetaniaca aiap eacnandet.” ");
INSERT INTO gai_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ri, Iosepa ma ŋgoca maica ŋgepatke, ma an Kacoot Raraŋ Aetaniacna mbaiŋna aiŋa morena ŋeroŋa mbopatna iroa, ma ndona baburina meacmo malaŋgoat. ");
INSERT INTO gai_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ainda moca ma ndona meacapa mba ŋgori, taŋca an mɨn, mana meaca mooŋnuoca mɨratke, Iosepa manmo an i Iesus matɨkat. ");
INSERT INTO gai_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Na Maria ma Iesusmo, Iudiana pitrik inikna auŋ Betlemma tɨkca manmo mamɨrat, na an mɨnna gagrirta ramoot paŋan Erotta ma anna ramoot paŋan ndeacri. Na Maria Iesusmo mɨratke, ra gagana ramtaɨra mina guiar puŋga landamŋi aŋgɨrena ramtaɨr ndeida kɨpca Ierusalem ndaruca aind madigiat, ");
INSERT INTO gai_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“An mandeba mɨrapekna mooŋnuoca ma Iudananta gagrirta ramoot paŋan ndarunanna, ma ten ndeacrena? Na aia mana ŋgagatracna guia ra gagambaica watca, aia manmo tutpemb rɨmbɨtna kɨprina.” ");
INSERT INTO gai_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ri, gagrirta ramoot paŋan Erotta an kamma waraca, ma iroar wɨt aŋgɨca ma tamtam malamŋiat. Na Ierusalem auŋ aniac inikna meikramtaɨr toco, muruŋa an kamna moca tamtam malamŋiat. ");
INSERT INTO gai_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Karica Erotta taup ndamtaɨr paŋaindapa Israelna tɨpemb wandik tamŋirena ramtaɨrmo muruŋa aca kɨpca punica, ma minmo gainda digiatna, “An ramootta Raraŋ Aetaniaca babuca mbagɨrica kɨpca aimo mac nda aŋgɨna ramootta, mana aemma manmo tenna tɨkca mɨrrina?” ");
INSERT INTO gai_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ri, mina mana kam rutica aindopatna, “Ma Iudia inikna pitrikna auŋ teker Betlem ndiŋ nakɨpnandet, atua ramma morina ramootna timbigta kapca gainda tirca eacrina, ");
INSERT INTO gai_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Na u Betlemma, u Iudiana tiacarpaiknan, u an inikna auŋembmo mba iŋ ŋgoinna mba taŋrena, wanaiŋ ŋgoin. Un mbuŋ tik, aukna Israelna meikramtaɨrmo raupŋina ramoot paŋan ianna larunande.’” ");
INSERT INTO gai_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ainda moca Erotta an ra gagana ramtaɨra, mina guiar puŋga landamŋi aŋgɨrena ramtaɨrmo aca kɨpca minmo laŋanna iŋgoroca minmo madigiat, “Tumbuit ŋgoinna an guia gacatna?” ");
INSERT INTO gai_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ri, ma minmo mandaca mina Betlem mataŋgat. Na ma minmo gaindopatna, “Ne taŋca an mooŋnuocna matau ore wat, na ne wat te, ne tawi nda kɨpca aukmo mbop te, auk toco taŋca manmo tutupniŋ rɨmbɨtna.” ");
INSERT INTO gai_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Karica mina gagrirta ramoot paŋan Erot mbopatna kamma waraca, mina ŋgepca mataŋgat. Mina taŋri, mina ŋgaua ra gaga tɨkca watatna guia minmo outmbai mataŋri, na ma taŋga an mooŋnuoca eacrinanmo mawɨtɨkat. ");
INSERT INTO gai_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ri, an landamŋina ramtaɨra an guia watca mina iroar inkara toŋtoŋgar anik koindap. ");
INSERT INTO gai_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Karica mina kac inikca mbukca wattatnanna, an mooŋnuocapa mana aemma, eacri. Na mina tutpemb rɨmbɨtca mamo torica mbendeica, mina ndorita lacruarta rambaɨr gootca, mina mamo gol ŋgacrina wautapa, iŋpai laŋapna tabaɨr laŋnanapa, tac mbuŋa mitpaca iŋpai laŋna tactuorta awirpaik laŋapmo, manmo malatuocat. ");
INSERT INTO gai_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ri, Raraŋ Aetaniaca minmo tamram mbuŋa aindopatna, “Ne an gagrirta ramoot paŋan Erot ndambuŋa kai mac nda taŋ teac.” Aintik mina kabena taup ndiŋa ndorita pitrikca mataŋgat. ");
INSERT INTO gai_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Karica an ramtaɨra taŋgatna mbatta. Iŋmbaia Kacoot Raraŋ Aetaniacna mbaiŋna aiŋa morena ŋeroŋ ianna kɨpca Iosepmo tamram mbuŋa aindopatna, “Gagrirta ramoot paŋan Erotta an mooŋnuoca mo menacna moca orenande. Na u ŋgepca mooŋnuocapa mana aemmo aŋgɨca kɨpcarica, Isipa taŋca an ndeac taŋca aku unmo tumbuitta tik te, aku unmo mac mbopnandet.” ");
INSERT INTO gai_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Aindopatke, ma ŋgepca ndona mooŋnuocapa mana aem aŋgɨca mina mouŋ nakɨpcarica Isipna pitrik waŋ mataŋgat. ");
INSERT INTO gai_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Na mina taŋga an ndeaca taŋga gagrirta ramoot paŋan Erotta menacri. Na an kammo, moi mɨnna tɨknanna, anna gaind, atua Kacoot Raraŋ Aetaniaca ndona ramma morina ramootna up mbuŋa aindopatna, “Aku ndona nuocmo Isipa tɨkca aca ma laruca kɨpnande.” ");
INSERT INTO gai_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Karica Erotta watta garacatke, an ra gagambaina landamŋina ramtaɨr, mina guiar puŋga landamŋi aŋgɨrena ramtaɨra manmo maparuri, na ma nikca kocnaia makatat, ri, ma ramtaɨr ndeidmo mbagɨrica mina Betlemapa an auŋembca rambuŋnan mataŋri, mina taŋga an auŋembta nuikpitik tekirnoikca mina iarira mbuniŋapa anna kaŋgauknanmo, muruŋa mina minmo laptikia mamenacat. Na ma ainda morinanna, ma an ra gagana ramtaɨr, mina guiar puŋga landamŋi aŋgɨrenan, ma minmo matau ŋgoinna digiri, tumbuit ŋgoinna an guia garina. Na ma ainda digirinanna, ma an nuikta mombonikca mina aemera an kɨdrɨkca mɨrrinanmo, ma mo menacna iroap tik. ");
INSERT INTO gai_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","18","Na an reikta kambca Raraŋ Aetaniaca ndona ramma morina ramoot Ieremaina upa tɨkatnanna, anna moa mɨn matɨkri. Na ma aindopatna, “Mɨtmɨt ianna Ramma auŋ inik ndiŋa larunande, na an mɨtmɨtta, anna memenacna kakadmaina nananae bagaraniac. Na anna ande, Reselna mombonik ŋgamrira ndorita mombonikta moca aerina. Na minmo nikemb iroar laiŋga mona kambca mina mba waracitndai, anna mina kakadmai bagaraniac ŋgoinap, ndorita mombonik menacrinanna moca.” ");
INSERT INTO gai_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Karica an gagrirta ramoot paŋan Erotta menacatke, Kacoot Raraŋ Aetaniacna mbaiŋna aiŋa morena ŋeroŋa Iosepmo Isipa tɨkca tamram mbuŋa mac makɨpat. ");
INSERT INTO gai_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Ri, ma mamo aindopatna, “Ŋgepca mooŋnuocapa mana aemmo aŋgɨca Israelna pitrikca mac nda taŋ. An mooŋnuoca mo menacna ramtaɨra mina mamenacri.” ");
INSERT INTO gai_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ainda moca ma ŋgepca mooŋnuocapa mana aemmo aŋgɨca mina Israela mac nda taŋgatna. ");
INSERT INTO gai_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ri, Iosepa waracatnanna, Akeleasa ma ndona aet Erotna taup aŋgɨca ma Iudiana gagrirta ramoot paŋan malaruat, ri, ma an mac taŋna mananambiat. Karica Raraŋ Aetaniaca mamo tamram mbuŋa mbopa, ma Galilina pitrik waŋ mataŋgat. ");
INSERT INTO gai_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ainda moca mana aemmapa aetta mamo aŋgɨca Nasaret auŋa taŋga an maeacat. Ri, an Raraŋ Aetaniacna rambca morina ramtaɨra mboprina kamma, moa mɨnna tɨkrina. Na mina manmo, “Nasaretnan ŋgacnande.” ");
INSERT INTO gai_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Karica an mɨnna kɨtac puk neaŋrena ramoot Ion, ma an Iudiana ramtaɨr kocorta taupca tɨkca kam laŋ mawiwitiri. ");
INSERT INTO gai_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Na ma gaindoprina, “Ne ndorita iroar inkar ŋgetriki, tamuŋna auŋna bubuoca kɨpca marambuŋairi!” ");
INSERT INTO gai_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Na Ionna ma ande an ramoot, Raraŋ Aetaniacna ramma morina ramoot Aisaiana up ndiŋa mboprina, na ma gaindopatna, “Ramoot ianna ande ramtaɨr kocorta taupca kam keca gaind mambopreke, ‘Kacootna taup kocro, na mana taup wandoŋai.’” ");
INSERT INTO gai_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Na Ion tikca mana tik ŋgapaoca, mina kamel ŋgacrena amna ŋgoaemna rɨkar puŋga moatna, na mana rɨktacniŋa ma wauk tɨkrena, mina amna ŋgoaemna iŋit mbuŋa moca ma an tɨkrena, na mana gagamna reikca raŋna kaborborarapa manoŋnoŋar ambrena. ");
INSERT INTO gai_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Na meikramtaɨr wɨt aniac ŋgoinna man ndambuŋa taŋgatnanna, mina Ierusalem ndiŋa kɨprinan, na Iudiana pitrik waŋnandap kɨprinan, na Iodan oc roumbna auŋemb toco makɨpat. ");
INSERT INTO gai_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ri, mina kɨpca ndorita tɨpemb ŋgorikta makukarmo mbopca laruri, ma minmo Iodan oca tɨkca kɨtac puk neaŋri. ");
INSERT INTO gai_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Na ma wattatnanna Parisiarapa Sadisiara wɨt aniaca man ndambuŋa kɨpca kɨtac puk aŋgɨna moca, ri, ma minmo aindopatna, “Ne nduop ŋgoreacna mombonik, Raraŋ Aetaniaca nenmo nikkakatap, na ma nenmo mo ŋgocrainandet. Na mandaia nemo mbopa ne kɨpcarina moek? Ne an nikkakatta iukaiit, co wanaiŋ? Ma nemo larunande. ");
INSERT INTO gai_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ainda moca ne ndorita iroar inkarmo gidik ŋgoinna ŋgetriki, te, nena tɨpembca ndori nenmo wandacnande, ne ndorita iroar inkar maŋgetrikiri. ");
INSERT INTO gai_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Na ne ainda kai lamŋi teac, ne tɨp ŋgoreacna moca kɨpcarica gaindopna, ‘Abraamma ma aina aet nicau.’ Na aku nemo aindopnandet, Raraŋ Aetaniac ma gan watur puŋga ma Abraamna nicar ŋgamrirta mombonikca mo laruna mɨn. ");
INSERT INTO gai_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Aintik oteaca ande ikirta mɨnɨŋa kocroca maeacreke, na ikira lour laiŋga gɨwac er ŋgocortanmo, anna muruŋa kocnaii waci irikca kataci aŋgɨri tac nake mbuknande. ");
INSERT INTO gai_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Aku nemo puk mbuŋa kɨtac puk neaŋrena, na an ŋgagatracna kirar mbuŋa nenmo wandacri, ne iroar inkara ŋgetrikirina. Na aukna iŋmbai nakɨpekna ramoot, mana gargara aukna gargarmo kundrina, ainda moca aku mana orgapaokniŋ aŋgɨna ramoot laŋa wanaiŋ. Na ma nemo Ŋeroŋ Ratapa, tac mbuŋa kɨtac puk neaŋnandet. Na ma nen motocmo kɨtac pukca neaŋnandet. ");
INSERT INTO gai_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ainda moca ma ndona witna dedeknampaikna kirar tocna reac utiŋa kɨpca witna ŋaŋawirmo aŋgɨca damma tɨk te, na wit laiŋmo damma ndona kaca tɨkna. Na an witna ŋaŋawirmo ma aŋgɨca an menac ŋgocorta taca ke mbukca mawɨrnandet.” ");
INSERT INTO gai_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Karica an mɨnna Iesusa Galili pitrik tɨkcarica ma Iodan oc mataŋgat. Na ma Ion ndambuŋa taŋga mana par mbuŋa kɨtac puk aŋgɨna mori. ");
INSERT INTO gai_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Na ma Iesusmo kɨraca mamo aindopatna, “U ndo aukmo kɨtac pukca neaŋna mɨn ŋgoin, na kaica u auk ndambuŋa kɨprina?” ");
INSERT INTO gai_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ainda moca Iesusa mana kam rutica aindopca, “Watcari, u an aku mboprina kirara mo te, aŋga an tɨpemb kirarir wandoikmo muruŋa Raraŋ Aetaniaca mo ndoprinanna, moca mɨnna tɨkna.” Ri, Ionna mana iro maraŋgaiat. ");
INSERT INTO gai_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Karica Iesusa kɨtac puk aŋgɨatke, ma anduna puk tɨkcarica, magatke, tamuŋna auŋa gootca, ma watri, Raraŋ Aetaniacna Ŋeroŋa ŋgorac riŋnai toc ŋgirikca manap maeacat. ");
INSERT INTO gai_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ri, tamuŋna auŋa kam ianna gaindopatna, “Ganna ande aukna nuoc kabe ŋgoin, na aku manmo toŋtoŋ ŋgoin, aukna iro inikca manmo matŋirena.” ");
INSERT INTO gai_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Karica an mɨnna Ŋeroŋ Ratta Iesusmo aŋgɨca ramtaɨr kocorta taupca taŋgat ke. Paparuna Ramootta manmo totowaiara mona mori. ");
INSERT INTO gai_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Na rai 40na mɨnapa mouŋemb 40na mɨnna Iesusa wariraca ma Raraŋ Aetaniaca mbendeiri. Ainda moca ma amna reaca ianna am ŋgocor, aintik ma nik watairina. ");
INSERT INTO gai_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ri, mana totowaina ramootta kɨpca man ndambuŋ ndaruca manmo aind mambopat, “Na u Raraŋ Aetaniacna Nuoc gidik ŋgoin ecte, u gan waturmo mbopca mina tapac tɨpemb uriracna.” ");
INSERT INTO gai_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ri, Iesusa mana kam rutica aindopatna, “Raraŋ Aetaniacna Timbigta Kapca tirca eacrena kamma aindopatna, ‘Meikramtaɨra amna reac niŋgik mbuŋa mba eacrenanna, wanaiŋ ŋgoin. Mina Raraŋ Aetaniacna kambmo muruŋ ŋgoinna raŋgairenan, na mina eteac laŋ ndeacnandet.’” ");
INSERT INTO gai_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Karica ma aindopatna mbatta, Paparuna Ramootta manmo aŋgɨca Raraŋ Aetaniacna auŋ aniac Ierusalem mataŋgat. Na manmo Raraŋ Aetaniacna Kacmo, mon tamuŋ ŋgoinna matɨkat. ");
INSERT INTO gai_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ri, ma manmo aind mac mbopat, “U gidik ŋgoinna Raraŋ Aetaniacna Nuoc ecte, u gan tamuŋa tɨkca putriki irik, Raraŋ Aetaniacna timbigta kapca gan kam tɨpap aindoprina, ‘Raraŋ Aetaniaca ma ndona mbaiŋna aiŋa morena ŋerŋgaurmo mbopca mina una ŋginaŋa monande.’ Na, ‘Mina unmo ndorita paɨrpaik puŋga utiŋ te, una orniŋa watura mba rɨŋitndait.’” ");
INSERT INTO gai_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Karica Iesusa manmo gaind mac mbopatna, “Raraŋ Aetaniacna timbigta kapca ma gan kam tɨp toco mboprina, ‘U ndona Raraŋ Aetaniac, una Kacootmo kai towai teac.’” ");
INSERT INTO gai_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ri, Paparuna Ramootta Iesusmo mac aŋgɨca takur ianmo tamuŋ ŋgoin matɨkat, na manmo gan tiacarpaikna pitrik waŋgorta auŋembta gagrar anikapa, an pitrikarta auŋembta inik ndeacrena reik laiŋ, laiŋ koind mawandacri. ");
INSERT INTO gai_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Na ma Iesusmo gaindoprina, “U aukmo tutupniŋ rɨmbɨtca aukmo mbendei te, aku umo an reikca muruŋa neaŋnande.” ");
INSERT INTO gai_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Karica Iesusa manmo gaindopatna, “Ramoot Mbɨk u waeke, Raraŋ Aetaniacna timbigta kapca aindoprina, ‘U Raraŋ Aetaniac Kacoot niŋgikmo tutupniŋ rɨmbɨtca, manmo mbendei. Na u mana aiŋ niŋgikca mo.’” ");
INSERT INTO gai_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ainda moca Paparuna Ramootta manmo tɨkcarica taŋgatke, Raraŋ Aetaniacna mbaiŋna aiŋa morena ŋerŋgaura kɨpca manmo maotacat. ");
INSERT INTO gai_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Na an mɨnna Iesusa waracatnanna mina Ionmo kac ŋgoreaca tɨkri, na ma ŋgepca Galili mataŋgat. ");
INSERT INTO gai_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ri, ma Nasaret auŋ tɨkcarica ma taŋga Kapaneam auŋ maeacat, na an auŋa ma Galilina mɨar roumb ndeacrena, na ma Sebulunapa Naptalina barna pitriknan. ");
INSERT INTO gai_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Na an tɨpna kirara, Iesusa moatna reaca, ma Raraŋ Aetaniacna ramma morina ramoot Aisaiana mbopatna kam ianna moca mɨnna tɨkrina, ");
INSERT INTO gai_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Na ma mbopatna kamma gaind, an Sebulunna barna meikramtaɨrapa, Naptalina barna meikramtaɨra, mina pitrikca maŋar aniacna roumbna taup ndeacrenanapa, an pitrikca Iodan ocmo monmbai waŋ ndeacrenan, mina Galilina pitrik waŋ ndeacrena. Na an pitrik waŋa ma Iudana meikramtaɨr wanaiŋna wɨt aniacap eacrenan. ");
INSERT INTO gai_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","An meikramtaɨra neaupdiriŋ aniac ndeacrinan, mina memetac aniaca mawatri. Na an meikramtaɨra memenacna kirar toc neaup ndeacrenanna, memetaca min ndambuŋa larurina.” ");
INSERT INTO gai_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ainda moca an mɨnna Iesusa meikramtaɨrmo ndona aiŋna kam wembaŋ wiwitica mo ŋgepri. Na ma gaindopatna, “Ne ndorita iroar inkarmo ŋgetriki, tamuŋna auŋna bubuoca kɨpca marambuŋairi.” ");
INSERT INTO gai_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Karica ma an Galilina mɨar roumb ndiŋa raŋgaia taŋgatnanna, ma kalapeniŋmo mawattat, maniŋa weaŋmo mɨar inik nakerena. Na maniŋna aiŋa ŋgoaem aŋgɨca kituknduk aŋgɨrena. Na maniŋna iniŋa, Saimonap Andru. Na Saimonna mana i ianna Pita. ");
INSERT INTO gai_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ri, ma maniŋmo aindopatna, “Oŋgo kɨpca aukmo raŋgai te, an oŋgo ŋgoaeb aŋgɨrena kirara, aku oŋmo meikramtaɨr aŋgɨrena kirar riptinande.” ");
INSERT INTO gai_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ainda moca tawi ŋgoin motemma maniŋa ndoniŋna weaŋgaɨr tɨkcarica man maraŋgaiat. ");
INSERT INTO gai_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ri, ma mac taŋga mandaca, ma wattatnanna kabena kalapeniŋ tuk mawatri. Anna Iemisapa Ion, maniŋa Sebedina nuocniŋ. Na maniŋa, ndoniŋna aet Sebediap kor inikca mbiraca eacri, weaŋgaɨrta urpembmo iukca laiŋ mamori. Na ma maniŋmo maacat. ");
INSERT INTO gai_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Na tawi ŋgoin motemma maniŋa ndoniŋna aetapa mina kor tɨkcarica, gaca Iesusmo maraŋgaiat. ");
INSERT INTO gai_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Karica Iesusa an Galilina auŋembmo muruŋa taŋri, ma mina Iudana mimitpac aŋgɨrena kaikca mbukca ma anna tɨkca minmo riptiri, na ma tamuŋna auŋna bubuocna kam wembaŋ laŋ tocmo anna tɨkca wiwitiri, na ma mina roumbbebta meikramtaɨra moa laiŋga mori, na ma mina tikembca ŋgocraica eacrinanmo moa wandoŋairi. ");
INSERT INTO gai_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Na mina mana nininia moca taŋga, an Siriana pitrikca tɨkca maniniri, na an nanrirta roumbbebta meikramtaɨra gɨrgɨrap eacrenan, na an ŋerŋgaur ŋgoriktan, na an roumbca ramootmo moca irikca nekrenanapa, an meikramtaɨra gagrir menacrinanmo aŋgɨca taŋca ma minmo moa laiŋga morina. ");
INSERT INTO gai_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Na meikramtaɨr wɨt aniaca an Galilina pitriknan, na Dekapolisna pitrikapa Ierusalem auŋ aniacnanapa, Iudiana pitriknan, na Iodan ocmo monmbai waŋnanda, manmo maraŋgaiat. ");
INSERT INTO gai_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Na ma wattatnanna mina wɨt aniaca kɨpri, aintik ma taŋga takur ian nagaca mbiraca, mana iŋa raŋgairena ramtaɨra taŋga man ndambuŋa puniri. ");
INSERT INTO gai_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Karica Iesusa mana iŋa raŋgairena ramtaɨrmo ma gainda riptirina, ");
INSERT INTO gai_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Na meikramtaɨra lamŋirena mina Raraŋ Aetaniacna reik kocortanpembca, mina toŋtoŋgarap eacnande. Tamuŋna auŋna bubuoca anna minan. ");
INSERT INTO gai_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Na meikramtaɨra mandeaca aerenanna, mina toŋtoŋgarap eac, Raraŋ Aetaniaca mina kakadmaica wandoŋainande. ");
INSERT INTO gai_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Na meikramtaɨra ndorita irembca aŋgɨ ŋgep ŋgocortan, mitoco toŋtoŋgarap eac. Raraŋ Aetaniaca minmo gan tiacarpaikca muruŋa neaŋnande. ");
INSERT INTO gai_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Na meikramtaɨra tɨp kirar wandoŋa mona toŋtoŋ aniacapnan, mina Raraŋ Aetaniacmo mataua raŋgairenan. Raraŋ Aetaniaca minmo toŋgorina reikca neaŋi mɨnna tɨknande. ");
INSERT INTO gai_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Na meikramtaɨra kabena meikramtaɨrmo kadmaica otacrenan, mitoco toŋgonande, Raraŋ Aetaniaca minmo kadmaica otacnande. ");
INSERT INTO gai_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Na meikramtaɨra nikinik iroar ratarapnan, mitoco toŋtoŋgarap eac. Mina Raraŋ Aetaniacmo watnande. ");
INSERT INTO gai_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Na meikramtaɨra kagrembca moa irikrenan, mitoco toŋtoŋgarap eac. Te, mina minmo Raraŋ Aetaniacna mombonik ndopnandet. ");
INSERT INTO gai_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Na meikramtaɨra tɨpemb kirarir wandoikca raŋgaica anna gɨgɨrar aŋgɨrenanna, mitoco toŋtoŋgarap eac. Tamuŋna auŋna bubuoca, anna minan. ");
INSERT INTO gai_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Na mina watrenanna, ne aukna tumbunna eac te, mina nenmo paparuna tɨpembca monandet, na mina nemo kam ŋgoreac ndop te, na mina nemo tɨp ŋgoreaca mo te. Ne toco toŋtoŋgarap eac. ");
INSERT INTO gai_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Na ne toŋtoŋgar anikca moca werei. An opoik bagaraniaca Raraŋ Aetaniacna tamuŋna auŋ malambireke. Na an tɨpna kirara mina atua rambca morina ramtaɨrmo ainda morina.” ");
INSERT INTO gai_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Karica Iesusa gaind mac mbopatna, “Ne gan tiacarpaikna mindaŋ toc. Na mindaŋa ndona tarar kecari te, aia mamo kaia moit? Ainta mindaŋa ma aiŋir kocor, na meikramtaɨra manmo aŋgɨra kecarica, mina man nambatta wɨtɨkca taŋrena. ");
INSERT INTO gai_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Na ne gan tiacarpaikna tacna memetac toc, na ne gaind ndamŋi, auŋ aniac ianna takurmo tamuŋ ndeac te, ma iŋgorocna mɨnna wanaiŋ. ");
INSERT INTO gai_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Na tacna memetac toco, mina wɨn aŋgɨca tacmo mba aŋgɨri taurkitndait, wanaiŋ ŋgoin. Mina gainda morena, tacmo tacna taupca tɨk te, ma an kac inik ndeacrena meikramtaɨrmo memetac neaŋnandet. ");
INSERT INTO gai_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ainda moca an tɨpna kirar mbuŋa nena memetaca kabena meikramtaɨrta lamnɨac ŋgoutmo metac te, nena morena tɨpemb kirarirta aiŋir laiŋmo mina watnandet. Na mina nena tamuŋna auŋna Aetna imo aŋgɨ ŋgepnande.” ");
INSERT INTO gai_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Karica Iesusa gaind mac mbopatna, “Ne gainda kai lamŋi teac, aku kɨprinanna Tɨp Wandɨkapa Raraŋ Aetaniacna rambca morina ramtaɨrta kambca mo kecarina mba kɨpri, wanaiŋ ŋgoin. Aku anna mo kecarina mba kɨpri, aku mana moi mɨnna tɨkna kɨprina. ");
INSERT INTO gai_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Na aku nemo gidik ŋgoin aindopnandet, riac tamuŋapa gan tiacarpaikca eacraŋ te, Tɨp Wandɨkca tirca eacrinanna, ma mba iŋgorocitndai, wanaiŋ ŋgoin. An titrirpaikna emtemma mba maiitndai, mina muruŋ ŋgoinna eacnandet. Na an Tɨp Wandɨkca ma aind ndeac taŋca an reikca larui mainandet. ");
INSERT INTO gai_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ainda moca ramoot ianna an Raraŋ Aetaniaca Mosesmo neaŋrina Tɨp Wandɨkna kam teker emtemma, watca anmo reac kamaind ndopca ma raŋgai ŋgocor, na ma kabena meikramtaɨr motocmo mbopca mina ainda raŋgai te, an ramootta mana ia tamuŋna auŋna bubuocmo ma teker ŋgoin ndeacnande. Na ramootta ma an Raraŋ Aetaniac Mosesmo neaŋrina Tɨp Wandɨkca matau raŋgairaŋ te, kabena meikramtaɨrmo an kirara ripti te, an ramootta tamuŋna auŋna bubuocmo, ma i aniac aŋgɨnande. ");
INSERT INTO gai_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Na aku nemo gaindopnande, ne Raraŋ Aetaniacna toŋtoŋa raŋgai ŋgocor, na nena tɨpemb kirarir wandoikca Parisiarapa tɨpemb wandik tamŋirena ramtaɨrta kirarirmo kun ŋgocor, ne tamuŋna auŋna bubuoca mba mac mbukitndai.” ");
INSERT INTO gai_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Karica Iesusa gaind mac mboprina, “Nena nicar ŋgamrira atua Raraŋ Aetaniac ndambuŋnan aŋgɨrina kamma, ne waracrinanna gaind, ‘Ne kabena meacramootmo kai mo menac teac. Na ramootta kabena ramootta mo menac te, ma ritri waparacna taupca taŋca mina manmo anna tɨkca ritri waparaca monande.’ ");
INSERT INTO gai_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Na aku nemo aindopnande, ramootta ndona laiplacarmo ŋateca kaega mo te, ma ritri waparacna outta wɨtɨknande. Na ramootta ndona laiplacarmo kam ŋgoreac ndop te, ma ninik waŋna paŋan aniacna outta wɨtɨknande. Na ramootta ndona laiplacarmo aindop te, ‘U ŋaŋaŋaona ramoot ŋgoin.’ An ramoot, ma an menac ŋgocorta iarwara wɨrrena taca mbuknande. ");
INSERT INTO gai_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Ainda moca u ndona gɨmbamba mona reikmo aŋgɨca, an gɨmbamba morena taup naaŋgɨ kɨp te, na u lamŋirina, una laiplacarta ianna ma unmo makukap te, ");
INSERT INTO gai_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","u ndona gɨmbamba mo ndoprina reikmo, an gɨmbamba morena taupca tɨkcarica, taŋca ndona an laiplacara mandaia unmo makukapnanmo watca oŋgo an wandoŋaica iro wetwet aŋgɨ te, u mac nda taŋca Raraŋ Aetaniacmo gɨmbamba moca neaŋ. ");
INSERT INTO gai_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Na ramoot ianna umo ritri waparaca mona mo te, na oŋgo taupca mandeba taŋraŋ te, u tawi ŋgoin motemma manapmo kam ndopi wandoŋai, moca ma unmo an ritri waparacna ramootna para tɨknandet, na ma umo kac ŋgoreacna ŋginaŋna aiŋa morena ramootna para tɨknande, na mina unmo kac ŋgoreaca tɨknande. ");
INSERT INTO gai_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Aintik aku umo gidik ŋgoinna aindopnande, u an kac ŋgoreac ndeaci taŋi mina umo mboprina opoik aniacna mɨn ŋgoinna oik te, mina umo watcarica u an kac ŋgoreac tɨkcarica larunandet.” ");
INSERT INTO gai_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Karica Iesusa gaind mac mambopat, “Nena nicar ŋgamrira atua Raraŋ Aetaniac ndambuŋnan aŋgɨrina kamma, ne waracrinanna gaind, ‘Atua mina mboprina kamma ne waracrinan, na ma gaindoprina, “Ne meikramtaɨra tɨpemb ŋgadudukara morena tɨpemb kirarira kai mo teac.”’ ");
INSERT INTO gai_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Na aku nemo gaindopnande, ramoot ianna meac ianmo watca ndona iro nikinik mbuŋa mana mona iro ŋgoreac aŋgɨ te, an ramootta ma meacramootna tɨp ŋgadudukca morena tɨp kirarmo ndona iro nikinik mbuŋa mamori. ");
INSERT INTO gai_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","“Ainda moca una lamnɨac umbaia umo moca u tɨp ŋgoreacna makukca mo te, u mamo tarkica kecari. Na una tik umbum emtemma mo kecari te, na u tɨp ŋgoreacna makukca mo ŋgocor, anna laŋ, moca Raraŋ Aetaniaca una tik umbumma muruŋa menac ŋgocorta iarwara wɨrrena taca ke mbuk nari. ");
INSERT INTO gai_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ainda moca una par umbaia unmo moca u tɨp ŋgoreacna makukna ŋgirik te, u man kataca kecari. Na u ndona tik umbum emtemma mo kecari te, na u tɨp ŋgoreaca mo ŋgocor, anna laŋ, moca Raraŋ Aetaniaca una tik umbumma muruŋa, menac ŋgocorta iarwara wɨrrena taca ke mbuk nari.” ");
INSERT INTO gai_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Karica Iesusa gaind mac mambopat, “Nena nicar ŋgamrira ŋgaua Raraŋ Aetaniac ndambuŋnan aŋgɨrina kamma, ne waracrinanna gaind, ‘Ramoot ianna ndona meacmo oot mandacna mo te, ma manmo laŋtaŋgo kakatacna timbiŋ rapara moca manmo neaŋ!’ ");
INSERT INTO gai_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Na mandeaca aku nemo gaindopnandet, ramootta mana meaca, meacramootna tɨp ŋgadudukca morena tɨp kirara mo ŋgocora oot mandac te, ma laŋtaŋgona tɨpca mba raŋgairi. Aintik iŋmbaia an meaca kabena ramoot laŋgo te, an meaca ma meacramootna tɨp ŋgadudukna tɨp kirar mamori. Na ramootta, meac ianna ŋgaua mana kaŋgaitta mamo ootta mandaca eacrinanna laŋgo te, ma toco an laŋtaŋgona tɨpca mba raŋgairi, na an ramoot toco, an meacramootna tɨp ŋgadudukna tɨp kirar mamori.” ");
INSERT INTO gai_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Karica Iesusa gaind mac mboprina, “Nena nicar ŋgamrira ŋgaua Raraŋ Aetaniac ndambuŋnan aŋgɨrina kamma, ne waracrinanna gaind, ‘U kammo u gidik ŋgoinna leac te, u an leacrina kammo gidik ŋgoinna raŋgai. Na reac ianna moca u kammo gidik ŋgoinna leac te, u anna raŋgaica Kacootna lamnɨacmo, u anmo wandoŋa mo.’ ");
INSERT INTO gai_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Na aku nemo aindopnande, ne reac ianna moca ne kammo gidik ŋgoinna mo gagrana mo te, ne tamuŋna auŋna ia kai aca nena kammo moi gagrana mo teac. An tamuŋna auŋa anna Raraŋ Aetaniacna gagrirta ramoot paŋan mbiracrena taup. ");
INSERT INTO gai_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Na ne tiacarpaikna ia wanaiŋa kai aca nena kammo, moi gagrana mo teac. An tiacarpaikca anna Raraŋ Aetaniaca ndona ormo, an nambatta tɨkca wɨk aŋgɨrena. Na ne toco Ierusalemna ia wanaiŋa kai aca, nena kammo moi gagrana mo teac, Ierusalemma ma Gagrirta Ramoot Paŋan aniacna auŋ. ");
INSERT INTO gai_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Na ne ndorita paŋanna ia wanaiŋa kai aca nena kammo, moi gagrana mo teac, anna nena paŋanna lakoarmo, ne mana moi mbɨkit, co, gogokca mona mɨnna wanaiŋ. ");
INSERT INTO gai_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Aintik ne gaind niŋgik ndop, anna laŋ, aku monandet, co, wanaiŋ, aku mba moit. Na kabena kamma an nambatta mbop te, anna Ramoot Ŋgoreaca ndo moa larurina kam.” ");
INSERT INTO gai_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Karica Iesusa gaind mac mboprina, “Nena nicar ŋgamrira ŋgaua Raraŋ Aetaniac ndambuŋnan aŋgɨrina kamma, ne waracrinanna gaind, ‘Ramoot ianna ramoot ianna lamnɨaca mo ŋgocrai te, ne toco rutica mana lamnɨaca mo ŋgocrai. Na ramoot ianna kabena ramootna ndar ianna pica witki te, ne toco rutica manan motoco pi witki.’ ");
INSERT INTO gai_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Na aku nemo gaindopnande, ramootta nemo tɨp ŋgoreaca morinanna, ne mamo kai ruti teac, kari ŋgoin. Ainda moca ramoot ianna nemo kapgɨn waŋembai ŋgap te, ne waŋembaina kapgɨn mac tɨk te, ma anmo mac apna. ");
INSERT INTO gai_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Na ramoot ianna nena tik ŋgapaoc teker aŋgɨna moca, ma nenmo ritri waparaca tɨk te, ne an tik ŋgapaoc tekera neaŋ, na nena tik ŋgapaoc aniac motocmo neaŋ. ");
INSERT INTO gai_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Na ramoot ianna nemo gagraca ndona reacmo warkica tawanna taŋ ndop te, ne tawan acait motemma taŋ mandac. ");
INSERT INTO gai_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Na ramoot ianna, nenmo reac ianna digi te, ne manmo neaŋ. Na ramootta nenmo digica iŋmbai nena reacmo nda rutina digi te, ne manmo neaŋ, kai wawɨri teac.” ");
INSERT INTO gai_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Karica Iesusa gaind mac mbopatna, “Nena nicar ŋgamrira ŋgaua Raraŋ Aetaniac ndambuŋnan aŋgɨrina kamma, ne waracrinanna gaind, ‘Nena kamkabearmo matŋi te, nena puŋnaŋgepmo kai matŋi teac.’ ");
INSERT INTO gai_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Aintik aku nemo gaindopnande, ne ndorita puŋnaŋgeptanmo, ne minmo matŋi, na ne Raraŋ Aetaniacmo mbendeica ma nemo tɨp ŋgoreaca morena meikramtaɨrmo, ma mina moca kadmaina. ");
INSERT INTO gai_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ainda mo te, ne tamuŋna auŋna Raraŋ Aetaniacna mombonik koind teacnande. Na ma ramo moca, ra gaca meikramtaɨr laiŋapa meikramtaɨr ŋgorik tambat ndeacrena. Na ma riacna rapacrena puk motocmo moca an meikramtaɨr ŋgorikca tɨpemb wandoikca mba morinanapa meikramtaɨra tɨpemb wandoikca morenanmo irikrena. ");
INSERT INTO gai_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Na meikramtaɨra nenmo matŋirenanna, ne min tiŋgikca matŋiraŋ te, Raraŋ Aetaniaca nemo opoikca mba neaŋitndait. Na kitcartukar iurena ramtaɨr toco meikramtaɨra minmo matŋirenanna, mina min tiŋgikca matŋiraŋ te, Raraŋ Aetaniaca minmo opoikca mba neaŋitndait. ");
INSERT INTO gai_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Na ne ndorita, kamkabear tiŋgikmo ra laŋ neaŋ te, Raraŋ Aetaniacna lamnɨaca watrenanna, anna ne Iudana meikramtaɨr wanaiŋnanta kirarir toc. Na Raraŋ Aetaniacna Iudana meikramtaɨr wanaiŋ toco, mina ainda morena. ");
INSERT INTO gai_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Aintik ne meikramtaɨr wandoik laiŋ koind teac. Nena an tamuŋna auŋna Aet eacrena kirar wandoŋ laŋanna, ne toco aind ŋgoin ndeac.” ");
INSERT INTO gai_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Karica Iesusa gaind mac mbopatna, “Ne ndoritake, matau wat. Nena tɨpemb kirarir wandoik laiŋmo, meikramtaɨrta outta kai tɨkca moca mina wat teac. Na ne ainda mo te, ne anna opoikca nena auŋ tamuŋna Aetnanna mba aŋgɨitndai. ");
INSERT INTO gai_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Na u reik ŋgocorta meikramtaɨrmo reac neaŋna mo te, u an taurap taŋrena ramootmo, kai mandaca taura wica una outta kammap taŋraŋ teac, an tɨpna kirara ramtaɨr ndeid toco nena Iudana mimitpac aŋgɨrena kaikapa taupca tɨkca morenan. Na ainta meikramtaɨr, mina meikramtaɨrmo paparuna meikramtaɨr. Mina ainda mo te, meikramtaɨra minmo i aniac neaŋnandet. Aku nenmo gidik ŋgoinna aindopnandet, an meikramtaɨra mina ndorita opoikca aŋgɨrina. ");
INSERT INTO gai_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Na u reik kocorta meikramtaɨrmo, otacna mo te, una par umbaia morina reaca una par aeŋmbaia kai garac teac. ");
INSERT INTO gai_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Aintik an kakadmaina aiŋa u morinanna, ma iŋgoroca eacnandet. Na una Aetta an iŋgoroca eacrena reikmo ma waekeke raekca watrena, na ma unmo opoikca neaŋnande.” ");
INSERT INTO gai_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Karica Iesusa gaind mac mbopatna, “An kɨdrɨkca ne mbembendeia monamo te, an parurena ramtaɨra morena tɨpna kirara kai mo teac. An ramtaɨrta toŋtoŋgar koinda mina ndorimo, an Iudana mimitpac aŋgɨrena kaikapa taupembta roumbbebca wɨtɨkca mbendei te, meikramtaɨrmo ndorica watna morenan. Na aku nemo gidik ŋgoin ndoprena, mina ndorita opoikca maaŋgɨat. ");
INSERT INTO gai_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","An kɨdrɨkca u mbendeina ndop te, u ndona kac inikca mbukca tɨŋ kaptikica, u ndona Aetmo mbendei, na una Aetta ma toco an ŋaia ma eacrena, na kaina kambca u mbendeica digirenanna, ma waracrena, na ma nemo opotaca neaŋnandet. ");
INSERT INTO gai_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Na nena mbembendeina inikca, ne kamb wɨt aniaca kai mbop teac, anna Iudana meikramtaɨr wanaiŋa morena tɨpna kirar. Na mina ndorimo ainda lamŋirena, mina kamb wɨt aniac ndop te, Raraŋ Aetaniaca minmo waracnande. ");
INSERT INTO gai_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Na ne min morena tɨpna kirara kai raŋgai teac. Na ne Raraŋ Aetaniacmo reikta moca digdigia mo ŋgocora eacraŋ te, ma nena toŋgorina reikca ma atuna lamŋirena. ");
INSERT INTO gai_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Na ne mbendeina mo te, ne gainda mbendei, ‘Aina Raraŋ Aetaniac, u tamuŋna auŋ ndeacrena, na i unanna memetmbaca wandoŋ rat ndeacrena. ");
INSERT INTO gai_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Na aia toŋgorinanna, una bubuocmo watcaria ma kɨp. Na aia memetmbaca una toŋtoŋa raŋgaica gan tiacarpaikca tɨkca, an mina tamuŋna auŋa tɨkca raŋgairina kirara, aia ainda morena. ");
INSERT INTO gai_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Na mandeaca u aina gan rana amna reikna mɨnna neaŋ. ");
INSERT INTO gai_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Na u aina tɨpemb ŋgorikta makukarmo mo kecari, an kabena meikramtaɨra aimo morena tɨpemb ŋgorikca aia minanmo moa kecarirena. ");
INSERT INTO gai_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Na u aimo totowaira kai watcarica, aimo laru teac, na aimo reik ŋgorik ndambuŋa kai aŋgɨ taŋ teac.’ ");
INSERT INTO gai_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Na ne warac, ne kabena meikramtaɨra nemo morina tɨpemb ŋgorikta makukarmo moi kecari te, nena tamuŋna auŋna Aetta ma nena tɨpemb ŋgorikta makukar motocmo ma moi kecarinande. ");
INSERT INTO gai_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Na ne kabena meikramtaɨrta tɨpemb ŋgorikta makukara moi kecari ŋgocor te, nena Aet toco, nena tɨpemb ŋgorikta makukara mba mac moi kecariitndai.” ");
INSERT INTO gai_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Karica Iesusa gaind mac mbopatna, “Ne Raraŋ Aetaniacna ndamŋina mo te, ne amna reaca warirac te, ne kakadmaina inpaŋanna kai wandac teac. An tɨpna kirara paparuna ramtaɨra morenan. Na mina ainda mo te, meikramtaɨra watta aindopna, mina wariraca taŋrina. Aintik aku nemo gidik ŋgoinna aindopnandet. An ramtaɨra mina ndorita opoikca muruŋ ŋgoin maaŋgɨat. ");
INSERT INTO gai_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Na ne wariraca taŋraŋ te, ne ndorita indepaŋaindmo tukica, na ndorita paŋaindmo tabaɨr ndikca eacraŋ. ");
INSERT INTO gai_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ainda mo te, meikramtaɨra mba mac lamŋitndai, u amna reacmo wariraca eacrenan. Na nena Aetta ma eacrenan, ma ndo kabe, ma lamŋirena. Aintik nena Aetta ma iŋgoroca eacrena reikca watrena, ma nenanmo rutinande.” ");
INSERT INTO gai_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Karica Iesusa gaind mac mbopatna, “Ainda moca ne gan tiacarpaikca tɨkca laimnembca kai aŋgɨca wembac teac. Na gan tiacarpaikca, bobodirapa kawɨrirca reikca moa ŋgocrairena, na macmakɨmna ramootta kaik titaca mbukca reik makɨmnande. ");
INSERT INTO gai_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Aintik ne ndorita laimnembmo, mon tamuŋna auŋ naaŋgɨca wembac. Na tamuŋna auŋa bobodirapa, kawɨrirca reikca mba mo ŋgocraiitndai, na macmakɨmna ramootta kaik titaca mba mbukca mba makɨmitndai. ");
INSERT INTO gai_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Aintik u ndona laimnemb aŋgɨca wembacekna auŋa wembac te, an auŋa una toŋtoŋ toca an auŋ ndeacnande.” ");
INSERT INTO gai_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Karica Iesusa gaind mac mbopatna, “Una lamnɨaca anna una tikna tacna kirar. Na una lamnɨaca laŋ ecte, una tikca tacna memetaca muruŋa metacnande. ");
INSERT INTO gai_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Na una lamnɨaca laŋa wanaiŋ te, una tikca neaup ndeacnande. Na an tacna memetaca una tikca eacrenanna ma neaupna kirar toc, te, an neaupa ma bagaraniac ŋgoin ndeacraŋnande.” ");
INSERT INTO gai_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Karica Iesusa gaind mac mbopatna, “Tuomna aiŋ kamainda morena ramootta, ma mba kacoot mbuniŋna aiŋa mba moitndai. Ma mo te, ma ianmo ŋate te, ma ian niŋgikca matŋinande. Na ma ianna kamma warac te, ma ianmo iŋ neaŋca wɨtɨknande. Aintik ne Raraŋ Aetaniacna aiŋapa kitukndukna aiŋmo, mba aŋgɨri tumbunna mba tɨkca aiŋa mba moitndai.” ");
INSERT INTO gai_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Karica Iesusa gaind mac mboprina, “Aintik aku nemo aindopnande, ne ndorita eteacna watna moca gainda kai mbop teac, ‘Aia kaina amna reaca ammit, na aia kaina pukca ammit?’ Aintik nena eteacna watta ma amna reacmo tamuŋmbai, na nena tikembca ma tik ŋgapaocna reikmo tamuŋmbai. ");
INSERT INTO gai_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Na ne ŋgorikmo wat, mina amta reikca mba mutocrenanna, na mina amta reikca mba aŋgɨca kaikmo tumbunna mba tɨkrena. Ainda moca ne wat, nena tamuŋna Aetta, ma minmo amta reik neaŋrena. Na ne gaind ndamŋi, Raraŋ Aetaniacna lamnɨacmo, ne ŋgorikmo kunda tamuŋmbai. ");
INSERT INTO gai_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Na nena ianna ndona iro mbuŋa, ndona eteacna watna moca tamtam ndamŋirenanna, an eteacna watna moca tamtam ndamŋina iroa, mana eteacna watmo moca ma kɨdrɨk rocotta eacit ki? An toco mɨnna wanaiŋ ŋgoin. ");
INSERT INTO gai_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Na ne kaina moca tik ŋgapaocna moca iroar wɨt aŋgɨrenan? Na ne kokocarmo matau wat, mina titoca gacrenan. Na mina aiŋ aniaca mba morenanapa mina tik ŋgapaoca mba morena. ");
INSERT INTO gai_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Aintik aku nemo aindopnande, ŋgaua gagrirta ramoot paŋan Solomon, ma ndona lamboir laiŋ, laiŋ koind aocrenanna, an lamboir laiŋ mananna gan kokocarmo kun ŋgocor. ");
INSERT INTO gai_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Na katgarca mandeaca tamtam ndeacrenanna, ŋorapa mina minmo kataca tac nake mbukca mina wɨrcarinande. Na ainta katgar ŋgorik toco Raraŋ Aetaniaca mina lamboir aocrena. Aintik ne meikramtaɨra nena rɨtɨpaikca tekir koind, na ne gaind ŋgoin ndamŋi, Raraŋ Aetaniaca nemo toco lamboir neaŋnande. ");
INSERT INTO gai_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ainda moca ne tamtamma kai lamŋica, gainda kai mbop teac, ‘Aia kai ammit?’ Co, ‘Aia kaina puk ammit?’ Na, ‘Aia kaia aocit?’ ");
INSERT INTO gai_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Aintik Iudana meikramtaɨr wanaiŋa, mina an reikta moca mina kadmairena. Na nena auŋ tamuŋna auŋna Aetta ma lamŋirena, kainta reikca ne matpirenanna. ");
INSERT INTO gai_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ainda moca ne out ŋgoinna gainda mo, ne Raraŋ Aetaniacmo wattacarica ma nena gagrirta ramoot paŋan ndeac, na mana tɨp kirar wandoŋa aŋgɨ te, ma nenmo an kabena reik muruŋa ma nemo neaŋnande. ");
INSERT INTO gai_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Aintik ne ŋorapna moca kai tamtamma lamŋiraŋ teac, na ŋorapna ra, ma ndona reikta moca ma ndo lamŋinande. Na ra kabena makukca ma an ra niŋgiknan.” ");
INSERT INTO gai_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Karica Iesusa gaind mac mbopatna, “Ne kabena meikramtaɨrta tɨpemb kirarirmo kai watca ritrica mimo gainda kai mbop teac, ‘Mina meikramtaɨr ŋgorik.’ Moca Raraŋ Aetaniaca nemo an tɨp kirar kabea nemo toco mo nari. ");
INSERT INTO gai_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Na ne kabena meikramtaɨrmo morena tɨpemb kirarirmo, Raraŋ Aetaniaca an tɨpembta kirara ma nemo ainda monande. Aintik ne kabena meikramtaɨrmo biŋairina reikta mɨnna, an biŋna mɨnna, Raraŋ Aetaniac ma an nena biŋna mɨnna, ma an mɨn mac nda ruti neaŋnande. ");
INSERT INTO gai_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Na kaina moca u ndona kakana lamnɨacna gigiratta watapeke, u ndona lamnɨacna inikca wawaraca eacrena ik tɨp aniaca mba lamŋiapeke? ");
INSERT INTO gai_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Na u ndona lamnɨac ndeacrena ik tɨp aniacmo, u wat ŋgocor. U tida watca u ndona kakamo aindopnande, ‘Kaka, aku una lamnɨacna gigiratta mo kecarina?’ ");
INSERT INTO gai_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","U paparuna ramoot ŋgoin. Outta u ndona lamnɨac ndeacrena ik tɨp aniaca mo kecarica, una lamnɨaca matau wat te, iŋmbaia u ndona kakana lamnɨac ndeacrena gigiratta watca mo kecarinande. ");
INSERT INTO gai_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Na reikca mina Raraŋ Aetaniacmo baburinanmo, ne kai aŋgɨca piriŋmo neaŋ teac, moca mina uriraca nemo wi nari. Na ne ndorita karorelour laiŋmo markɨmbca kai ke teac, moca mina nenanmo ndorita our puŋga kɨtac wɨtɨknande.” ");
INSERT INTO gai_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Karica Iesusa minmo gaind mac mbopatna, “Ne Raraŋ Aetaniacmo ndorimo otacna mbendeica digi te, ma nenmo otacnande. Na ne ore te, ne watnande. Na ne manmo ac te, ma nemo waraca ruti te, ne man ndambuŋ nakɨpnande. ");
INSERT INTO gai_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Aintik mandaia digiraŋ te, Raraŋ Aetaniaca manmo memetmbaca neaŋnande. Na mandaia oreraŋ te, ma memetmbaca watnande. Na mandaia acraŋ te, Raraŋ Aetaniaca mamo waraca rutica man ndambuŋ nakɨpnande. ");
INSERT INTO gai_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Na ne atera tida moit? Nena ianna mooŋnuoc ian, ma unmo tapac neaŋna digi te, ne manmo waut ian neaŋit ki, co wanaiŋ. ");
INSERT INTO gai_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Co, mooŋnuoca nemo ŋgoaem ianna digi te, ne mamo nduop ŋgoreac ian aŋgɨ neaŋit ki, a? An toco wanaiŋ! ");
INSERT INTO gai_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Na ne ater, ne tɨpemb ŋgorik wɨt anikca morena ramtaɨr, na ne ndorita mombonikta ndamŋireke, ne mimo mataua moreke, na mimo reik laiŋ neaŋrena. Ainda moca anna gidik ecte, ne gaind ŋgoin ndamŋi. Nena tamuŋna Aet, nemo mandaibinna mbendei digi te, ma nenmo reik laiŋ neaŋnandet! ");
INSERT INTO gai_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Na an tɨpemb kirarir muruŋa ne toŋgorenanna, kabena meikramtaɨra nenmo morenanna, an tɨpemb kirarir koinda ne min motocmo mo. Na anna ande Tɨp Wandɨkna kamna mɨnɨŋ, na an toco rambca morina ramtaɨrta kamna mɨnɨŋ.” ");
INSERT INTO gai_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Karica Iesusa gaind mac mbopatna, “Ne an tɨŋ tekera mbukna towai paŋpaiŋi. Na menac ŋgocorta taca taŋrena taupna tɨŋa, ma bagaraniac ŋgoin, na mana raŋgairena taupca gogoot ŋgoin, na ma wetwet ŋgoinna taŋrena. Aintik meikramtaɨr wɨt aniaca an taupca raŋgairena. ");
INSERT INTO gai_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Na iarwar ndeteacna wat aŋgɨna tɨŋa tekernoc ŋgoin, na mana raŋgairena taupca owai ŋgoin. Aintik meikramtaɨr, kabe, kabe, niŋgikca an taupca watta anna raŋgairena.” ");
INSERT INTO gai_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Karica Iesusa gaind mac mbopatna, “Ne an paparuna rambca morena ramtaɨrtake, matau wat. Na mina nemo kamb laiŋga mbop te, ne mimo toŋgonandet, na anna mina nemo wai aoca, nena iroara paru te, nemo mo ŋgocraina. Ainda moca mina ande raŋna piriŋ kunnarta kirar, mina ndorimo sipsiparta iŋir puŋga ŋgagoca, mina sipsipar tambuŋa taŋi rambuŋai te, mimo winandet. ");
INSERT INTO gai_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Na ne minmo titoca tɨki wat garacit, mina morena tɨpemb kirarirmo, mina rambca morina ramtaɨr gidkar ki, wanaiŋ? Na ramtaɨra wainna loor aŋgɨna mo te, mina lacarta ŋgatɨkca mba taŋca wain loor aŋgɨit, na mina ŋgaŋɨnna loor aŋgɨna mo te, mina lacapna katgara mba taŋca ŋgaŋɨn loor aŋgɨit, wanaiŋ ŋgoin. ");
INSERT INTO gai_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Aintik ikir laiŋga mina gagaimb laiŋ ŋgerrena, na ikir ŋgorikca, mina gagaimb ŋgorikca ŋgerrena. ");
INSERT INTO gai_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ainda moca ikir laiŋga mina gagaimb ŋgorikca mba eritndai, na ikir ŋgorikca gagaimb laiŋga mba eritndai. ");
INSERT INTO gai_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Aintik ikira gagaimb laiŋga er kocortan, mina minmo waca tac nake mbuknande. ");
INSERT INTO gai_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ainda moca ne mina tɨpemb kirarira watca, ne lamŋinande, mina Raraŋ Aetaniacna rambca morena ramtaɨr gidkara wanaiŋ.” ");
INSERT INTO gai_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Karica ma minmo gaind mac mbopatna, “Ne gainda kai lamŋi teac, meikramtaɨra aukmo, ‘Kacoot, Kacoot,’ ŋgacrenanna, tamuŋna auŋna bubuocmo mbukit, co wanaiŋ. Na ramootta aukna tamuŋna auŋna Aetna toŋtoŋa raŋgairenan, ma ndo tamuŋna auŋna bubuoca mbuknande. ");
INSERT INTO gai_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Na ritri waparacna ra, meikramtaɨr wɨt aniaca aukmo gaindopnande, ‘Kacoot, Kacoot, aia una i mbuŋa aia ramma morena aiŋa morina, na una i mbuŋa aia ŋerŋgaur ŋgorikca moca kecaririna. Na una i mbuŋa aia ŋgagatracar wɨtta morinan.’ ");
INSERT INTO gai_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Te, an mɨnna aku mimo gaind ŋgoinna aindopnande, ‘Aku nemo lamŋi ŋgocor, ne tɨp wandɨkmo nda ipuŋrena meikramtaɨr, auk ndambuŋa kai kɨp teac.’” ");
INSERT INTO gai_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Karica Iesusa gaind mac mbopatna, “Mandaia aukna gan kamma waraca raŋgairenan, ma an ramootta iro laŋapna kirar, ma ndona kaca waturapna taupca tɨkca morina. ");
INSERT INTO gai_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Na laemba kɨp te, pukapa laclaocap wat aniaca kɨpca rapac te, ma witki irikna towanaiŋ, mana gaoura waut nambatta mori tik, ma paŋpaiŋ ŋgoin. ");
INSERT INTO gai_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Na mandaia aukna kamma waraca raŋgai ŋgocor, ma an ŋaŋaona ramootna kirar, ma ndona kacmo timgunmo mbatta iaca kaca morina. ");
INSERT INTO gai_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Iŋmbai laemba kɨp te, pukap laclaocap wat aniac kɨpca rapac te, ma tawina witki irikca, ma kocnai ŋgocrainande.” ");
INSERT INTO gai_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ri, ma mimo an kamma riptirinanna mbopa mairi, an meikramtaɨra anna waraca ŋgep ŋgoreac naŋgepri. ");
INSERT INTO gai_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Na mana riptirina kirara ma an mina tɨpemb wandik tamŋirena ramtaɨra riptirina kirara wanaiŋ, mananna an irembapna ramoot riptirinan toc. ");
INSERT INTO gai_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Karica Iesusa an takur tɨkcarica irikatke, meikramtaɨr wɨt aniac ŋgoinna mamo maraŋgaiat. ");
INSERT INTO gai_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ri, roumb lepaapna ramoot ianna man ndambuŋa kɨpca tutupniŋ rɨmbɨtca manmo gaindopatna, “Kacoot u toŋgo te, u aukmo Raraŋ Aetaniacna lamnɨac ŋgoutmo mo laŋa moca rat ndaru.” ");
INSERT INTO gai_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Karica ma ndona parmo an ramootmo utiŋga ma aindopatna, “Aku toŋgorena, u rat laŋa mo.” Na tawi ŋgoinna mana lepana roumbca maica, mana tikca rat laŋ mamoat. ");
INSERT INTO gai_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Na ma an ramootmo gaind mac mbopatna, “U matau wat, u ramoot ianmo kai mbop teac, an reaca umo laruapeknanna. Na u taŋca ndona tikmo taup ndamootta taŋi wandac te, an Mosesa mboprina kirarmo, gɨmbamba mo te, meikramtaɨra watca lamŋinande, una roumbca mamairi.” ");
INSERT INTO gai_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Karica Iesusa taŋga Kapaneam auŋ tekera mbukatke, Romna lapoca ruŋrena ramoot paŋan ianna ma an ndeacrina. Na an lapoc ruŋrena ramoot paŋanna runduikta ramtaɨr mananna 100na mɨn, na ma kɨpca manmo ndo ŋgopotacna moca gagraca madigiat, ");
INSERT INTO gai_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Kacoot aukna mbaiŋna aiŋa morena ramootta, orpar menacrina roumbap tik, ma kac maeacreke, na ma gɨrgɨr aniacap.” ");
INSERT INTO gai_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ri, Iesusa rutica gaindopatna, “Aku taŋca manmo mo laŋa monande.” ");
INSERT INTO gai_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ri, lapoca ruŋrena ramoot paŋanna rutica gaindopatna, “Kacoot, aku irembta ramootta wanaiŋ, aintik u aukna kaca kɨpna mɨnna wanaiŋ. U kam niŋgik ndop te, aukna mbaiŋna aiŋa morena ramootta laŋa mona. ");
INSERT INTO gai_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Na aku aindoprinanna, auk toco, aku iapna ramootna kaŋgauk ndeacrena. Ma ndo aukmo aiŋ neaŋ te, aku monande. Ainda moca aku ndona lapoca ruŋrena ramoot ianmo aindop te, ‘U taŋ,’ aindop te, ma taŋnande, na ian motoco aku aindop te, ‘U kɨp,’ aindop te, ma kɨpnande. Na aku ndona tuomna aiŋ kamaindna ramootmo aindop te, ‘U gan aiŋa mo!’ aindop te, ma taŋca an aiŋa monande.” ");
INSERT INTO gai_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ri, Iesusa an kamma waraca, mana iro inikca tamtam ŋgoin ndamŋica. Karica ma an mana raŋgairena meikramtaɨrmo gaindopatna, “Aku nemo gidik ŋgoin aindopnande, aku an Israelna wiwitna meacramootna, ianmo ainta rɨtɨpac gargar ianna wat ŋgocor. ");
INSERT INTO gai_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","“Aintik aku nemo aindopek, meikramtaɨr wɨt aniaca an ra gagambaiapa ra itirikmbaina pitrik waŋ ndiŋ nakɨpca tamuŋna auŋna bubuoca mbukca, mina Abraamapa Aisakapa Iakopap mbiraca amnande. ");
INSERT INTO gai_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Na an meikramtaɨra Raraŋ Aetaniaca mimo ŋgaua babuca mana bubuoc ndeacrenanna, Raraŋ Aetaniaca minmo oot mandaca, neaup diriŋna ke laruca, mina ae ŋgoreac ŋgoin ŋgaeraŋ te, ndorita ndaɨrmo wiraŋnande.” ");
INSERT INTO gai_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Karica Iesusa an lapoca ruŋrena ramoot paŋanmo aindopatna, “U taŋ, an reikca u rɨpacrina kirar ndarunande.” Na an kɨdrɨk ŋgoinna an lapoca ruŋrena ramoot paŋanna mbaiŋna aiŋa morena ramootta, laŋ mamoat. ");
INSERT INTO gai_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Karica Iesusa Pitana kaca mbukca wattatnanna, mana meacna aemma, tik owaina roumbca moca bara meraca eacri. ");
INSERT INTO gai_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ri, ma, mana parmo pipikatke, mana roumbca laŋa moatna mbatca, ma ŋgepca Iesusna amna reac makocroat. ");
INSERT INTO gai_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Karica an wigwac ŋgoin mbuŋa mina an ŋerŋgaur ŋgorikca, minmo mbukca eacrina meikramtaɨrmo aŋgɨa Iesus ndambuŋ mataŋri. Na ma ndona up mbuŋa mbopri, an ŋerŋgaur ŋgorikca minmo tɨkcariri, na an roumbbebtanda ma minmo moca laiŋ mamori. ");
INSERT INTO gai_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Na an tɨpna kirara Raraŋ Aetaniac mbopatna kamma ma moa mɨnna tɨkca ma ndona ramma morina ramoot Aisaiana upa tɨkca aindopatna, “Ma ndo ŋgoin mbuŋa aina roumbbebca ma aŋgɨca moa kecaririna.” ");
INSERT INTO gai_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Karica Iesusa wattatnanna meikramtaɨr wɨt aniaca manmo, punica korereri, na ma ndona raŋgairena ramtaɨrmo aindopatna, “Aia mɨarmo monmbai waŋ nagana.” ");
INSERT INTO gai_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ainda mori, tɨpemb wandik tamŋirena ramoot ianna kɨpca manmo aindopatna, “Riripti, u tenna taŋ te, aku una raŋgaica unap taŋraŋnande.” ");
INSERT INTO gai_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ri, ma, manmo aindopatna, “Raŋna piriŋ kunnara minanna ŋgorena tiacarpaikna aurembap, na ŋgorikca mitoco minanna ŋgorena timbap, na Ramootna Nuoca ma meraca ŋgogona taupemb kocor.” ");
INSERT INTO gai_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Karica mana iŋa raŋgairena ramoot ianna manmo gaindopatna, “Kacoot, u aukmo pac watcarica, aku ndona aetna waɨr pac mutocarica.” ");
INSERT INTO gai_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Aindopatke, Iesusa manmo gaindopatna, “Meikramtaɨra rɨtɨpaik kocorta meikramtaɨrta kirarirmo watcarica, mina ndorimo ndorita waɨrmo ndori mutoc te, u kɨpca aukmo raŋgai.” ");
INSERT INTO gai_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Karica Iesusa embatta kor ian naŋgabukatke, mana iŋa raŋgairena ramtaɨra manmo maraŋgaiat. ");
INSERT INTO gai_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Na mina taŋri, Iesusa ma an korna inik maŋgori, na an mɨarna rɨkca tɨkatke, watapa, murmurapa macait aniaca ŋgepca, mina kormo pi bururuna tekemmotem. ");
INSERT INTO gai_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Aintik mina taŋga manmo omboŋga ŋgepca, manmo aindoprina, “Kacoot aimo otac! Aia maica ŋgocraina mamoek!” ");
INSERT INTO gai_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ri, ma mina kam rutica aindopatna, “Ne kaina moca nanambirena? Nena rɨtɨpaikca tekir koind.” Karica ma ŋgepca watapa, murmurapa macaitmo kaega moca kɨracrina, mbatca mina anduna menaca tɨkca, pukca nuknukir kocor koind. ");
INSERT INTO gai_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ainda moca mina tamtamma ndamŋica aindopatna, “Anna titocna ramoot? Na ma watapa, murmurapa macaitmo kaega moca mina mana kamb mbaraca mamairi.” ");
INSERT INTO gai_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Aintik Iesusa kor mbuŋa taŋga Galili mɨarmo waŋembai magacat, na anmbai waŋa anna Gadarana pitrik. Anna tɨkatke, ŋerŋgaur ŋgorikca mbukca eacrina ramootniŋa an warir mutocrina taup ndeacrinanna maniŋa man ndambuŋ makɨpat. Na an ramootniŋa, maniŋa kocnaia rorecarica meikramtaɨra an taupca mba taŋrenanna. ");
INSERT INTO gai_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Karica maniŋa manmo aca aindopatna, “U Raraŋ Aetaniacna Nuoc, u aŋmo kaia mona moek? U gade kɨpca aŋmo gɨrgɨr neaŋna moekca? Mana ra mba larureke.” ");
INSERT INTO gai_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Na mimo tawancait motemma wanaiŋa, markɨmta tumbun ianna ambri eacri. ");
INSERT INTO gai_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Na an ŋerŋgaur ŋgorikca manmo kamb anik keca gaindopatna, “U aimo mo kecarina mo te, u aimo mandaca aia an markɨmbca mbukna.” ");
INSERT INTO gai_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Karica ma minmo aindopatna, “Ne taŋ.” Na mina an ramootniŋ tɨkcarica an markɨmta tumbunna mbukatke, an markɨmta tumbunna muruŋ ŋgoinna ootta taŋga mɨar roumbna pacwɨkɨnna taup ŋgoreac ianna pukca, pukca mamenacat. ");
INSERT INTO gai_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Na an markɨmb raupŋirena ramtaɨra kɨpcarica, mina taŋga an auŋ ndaruca, minmo an ramootniŋapa an reik larurinan maniniat. ");
INSERT INTO gai_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ri, an auŋna meikramtaɨra muruŋa Iesus ndambuŋ nakɨpca, mina mana watca, mina mamo aemaŋmaŋap mbopca, ma mina pitrik waŋ tɨkcarica taŋ. ");
INSERT INTO gai_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Karica Iesusa kor ian mac ŋgabukca, mɨarmo monmbai waŋ mac nda magari. Na ma taŋga ndona auŋ malaruat. ");
INSERT INTO gai_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ri, ramtaɨr ndeida mamo orapa parniŋ menacrina roumbapna ramoot ianmo aŋgɨca makɨpat, na ma ndopna bara meraca eacrina. Ainda moca Iesusa watrinanna, mina manmo rɨtɨpacap tik, na ma an roumbapna ramootmo aindopatna, “Mooŋnuoc, u iro wetwet laŋ ndeac, aku una tɨpemb ŋgorikta makukara moa kecamacariri.” ");
INSERT INTO gai_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Aindopatke, tɨpemb wandik tamŋirena ramtaɨr ndeida ndorimo gaind mambopat, “Gan ramootta Raraŋ Aetaniacna taup aŋgɨna morena.” ");
INSERT INTO gai_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ri, ma mina iroar inkarmo atuna ndamŋiri, aintik ma minmo aindopatna, “Ne kaina moca ndorita iroar inkar puŋga ainta iroar ŋgorik aŋgɨcapekna? ");
INSERT INTO gai_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Na titocna kamma aukmo owai ndopit? Gan kam ki? ‘Aku una tɨpemb ŋgorikta makukara moa kecamacariri,’ co, ‘U ŋgepca taŋ.’ ");
INSERT INTO gai_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ainda moca aku nemo lamŋi garacna moca aindopnande, Ramootna Nuoc, ma gan tiacarpaikmo ma gargarap, na ma tɨpemb ŋgorikta makukara moi kecarina mɨn.” Aintik ma an gagrira menaca eacrena ramootmo aindoprina, “U ŋgepca ndona bar aŋgɨca ndona kaca taŋ.” ");
INSERT INTO gai_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ri, an ramootta ŋgepca ma ndona bar aŋgɨca ndona kaca mataŋgat. ");
INSERT INTO gai_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ainda moatke, meikramtaɨra anna watca, mina mananambiat. Aintik mina Raraŋ Aetaniacna imo aŋgɨca maŋgepri, ma ndo ŋgoinna ainta gargarmo meikramtaɨrmo neaŋrina. ");
INSERT INTO gai_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Karica Iesusa an tɨkcarica, ma taŋrenan mbuŋa ma ramoot ian mawatat, na an ramootna ia Matiu, ma ndona kitcartukar iurena aiŋna taupca mbiraca eacri. Na ma manmo aca aindopatna, “U ŋgepca aukmo raŋgai.” Ainda moca ma ŋgepca manmo maraŋgaiat. ");
INSERT INTO gai_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ainda mori, Iesusa taŋga Matiuna kacna gaca, ma anna tɨkca an kitcartukar iurena ramtaɨrapa tɨpemb ŋgorikca morena ramtaɨrapa mana iŋa raŋgairena ramtaɨrap ma minap mbiraca amna reac maamri. ");
INSERT INTO gai_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Karica Parisina ramtaɨra anna watca, mina mana iŋa raŋgairena ramtaɨrmo madigiat, “Kaina moca nena ririptia an kitcartukar iurena ramtaɨrapa tɨpemb ŋgorikta makukara morina ramtaɨrap ambrina?” ");
INSERT INTO gai_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ri, ma an kamma waraca, ma gaindoprina, “Roumbbeb kocorta meikramtaɨra mina pitir gagamna ramoot ndambuŋa mba taŋrenanna, wanaiŋ ŋgoin, an roumbbebta meikramtaɨra ndori tiŋgikca man ndambuŋa taŋrena. ");
INSERT INTO gai_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Na ne taŋca Raraŋ Aetaniacna timbigta kapna kambta moca ripti mac aŋgɨ, ‘Aku gɨmbamba mba toŋgorenan, aku kakadmaina opotacna tɨpna kirara toŋgorena.’” Ainda moca Iesusa aindopatna, “Aku meikramtaɨr wandoikta ŋgacna mba kɨpri. Wanaiŋ. Aku tɨpemb ŋgorikta meikramtaɨr ŋgacna kɨprina.” ");
INSERT INTO gai_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Karica an mɨnna Ionna iŋa raŋgairena ramtaɨra, Iesus ndambuŋ nakɨpca manmo gaindopatna, “Kaina moca aiapa Parisinandapa aia amna reacmo wariracrena, na una iŋa raŋgairena ramtaɨra, amna reacmo mba wariracrenan?” ");
INSERT INTO gai_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ri, Iesusa rutica minmo aindoprina, ramootta laŋgona babuca ndona kam kamkabeap eac te, mina aeit ki? Wanaiŋ. Na iŋmbaia mina manmo aŋgɨ taŋ te, an ra ande mina mana ŋgae te, amna reacmo wariraca monande. ");
INSERT INTO gai_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ainda moca ramoot ianna raraŋit ŋgamna waŋa mba aŋgɨca, tik ŋgapaoc bagarna urupa mba iukrena. Na ma ainda mo te, mina an tik ŋgapaocmo tuki te, an raraŋit ŋgamna waŋ anna, ma taŋca tekerai te, ma an tik ŋgapaocmo mo titacnandet. Te, an iukrena raraŋit ŋgam anna ma an tik ŋgapaocna urupa moca acnainandet. ");
INSERT INTO gai_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Na ramoot ianna memena iŋit bagar mbuŋa wain ŋgamma mba ruitndai. Ma ainda mo te, an meme iŋit bagar toco putu taŋca titaca pukca ruŋki taŋcarinande. Aintik mina wain puk ŋgammo meme iŋit ŋgam mbuŋa runande. Te, maniŋa muruŋniŋa laŋ ndeacraŋna. ");
INSERT INTO gai_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Karica Iesusa Ionna iŋa raŋgairena ramtaɨrap mbopre mbuŋa, ramoot paŋan ianna kɨpca mana outmo tutupniŋ rɨmbɨtca mamo gaindoprina, “Aukna mooŋmbitaca gade mandeba menacpekna. Aintik u kɨpca ndona parmo man nambatta tɨk te, ma ndona wat mac nda aŋgɨna.” ");
INSERT INTO gai_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Na ma ŋgepca mana iŋa taŋgatke, mana iŋa raŋgairena ramtaɨra manap mataŋgat. ");
INSERT INTO gai_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ri, meac ianna ma eacrinan, memetmbaca ma meikta roumb aŋgɨca racaind taŋrena, na an roumbca manmo iarira parniŋapa mbut mbuniŋ mamoat. Karica an meaca ma taŋga mana iŋmbai ndiŋa mana tik ŋgapaoc rocotna mamamaina tɨpmo mapipikat. ");
INSERT INTO gai_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Na an meaca ma ndona iro mbuŋa ma gaind ndamŋiatna, “Aku ndona parmo Iesusna tik ŋgapaoca pipik te, aukna roumbca ma laŋa monande.” ");
INSERT INTO gai_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ri, Iesusa uriraca manmo watca, ma manmo aindopatna, “Mooŋmbitac u nikinik iro wetwet ndeac, u aukmo rɨpacat tik, u laŋ mac mamori.” Ainda moca an meacna roumbca an mɨn ŋgoinna laŋ mamoat. ");
INSERT INTO gai_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Karica ma taŋga an ramoot paŋanna kac ndaruca wattatnanna, meikramtaɨra aea eacri. Na ramtaɨra tiamba wiri, meikramtaɨra gararara mori. ");
INSERT INTO gai_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Na ma minmo aindopatna, “Ne kacrepca ŋgepca taŋ, mooŋmbitaca mba menacri, ma anna meraca eacrena.” Na mina manmo malaroŋri. ");
INSERT INTO gai_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ainda moca mina an meikramtaɨrmo moca waekeca laruatke, ma mbukca an mooŋna par ŋgutiŋgatke, ma mac nda maŋgepat. ");
INSERT INTO gai_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ri, an reacna nininia an auŋembca muruŋa tamtam mataŋgat. ");
INSERT INTO gai_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Karica Iesusa an auŋ tɨkcarica taŋgatke, lamnɨac ŋgoreacapna ramootniŋa mana iŋa taŋga manmo aca aindopatna, “U Dewitna ŋgamaɨr, u aŋna moca kadmaica aŋmo otac.” ");
INSERT INTO gai_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ri, ma kac inikca mbukatke, an lamnɨac ŋgoreacna ramootniŋa man ndambuŋ nakɨpca ma maniŋmo aindopatna, “Oŋgo rɨpacrinan, aku gan reaca moit ki?” Ri, maniŋa aindopatna, “Ore, Kacoot.” ");
INSERT INTO gai_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ainda moca ma ndona parmo maniŋna lamnɨacniŋa tɨkca ma aindoprina, “Oŋgo aukmo rɨpacat tik, an reaca oŋmo malaruri.” ");
INSERT INTO gai_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Na maniŋna lamnɨacniŋa watukca watatke, ma maniŋmo kam gargar mbuŋa aindoprina, “Oŋgo kabena ramootmo, an oŋmo laruapekna reacmo, lamŋi garac nari.” ");
INSERT INTO gai_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Aindopatke, maniŋa taŋga an pitrikna auŋembta meikramtaɨrmo, muruŋa an Iesusa moatna aiŋir laiŋta ninini mamoat. ");
INSERT INTO gai_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Karica an ramootniŋa man tɨkcarica taŋgatke, meikramtaɨra kam ndop ŋgocorta ramoot ianmo, man ndambuŋa aŋgɨca makɨpat. Na ma ŋeroŋ ŋgoreacap. ");
INSERT INTO gai_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ri, ma an ŋeroŋ ŋgoreacmo moca kecarica, an ramootta kam mambopri. Ainda moca meikramtaɨra tamtam ndamŋia aindopatna, “Ŋgaua ainta reac ianna Israelmo mba larurinanna.” ");
INSERT INTO gai_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Karica Parisiara gaindopatna, “Ma ŋerŋgaur ŋgorikta ramoot paŋanna gargar mbuŋa ŋerŋgaur ŋgorikmo ootta mandacrena.” ");
INSERT INTO gai_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Karica Iesusa taŋga an auŋemb anikapa auŋemb tekirmo muruŋa taŋga, ma mina Iudana mimitpac aŋgɨrena kaikca tɨkca minmo Raraŋ Aetaniacna kambmo riptiri, minmo mana bubuocna kam wembaŋ laŋa wiwitirina. Na an meikramtaɨra kaina roumbbebtanmo, ma moca laiŋga morina. ");
INSERT INTO gai_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ri, ma an meikramtaɨr wɨt aniaca watca, mana iro inikca minmo kakadmaiap. An meikramtaɨrta iroara roreri, na mina wapatta laiŋga wanaiŋ, mina an sipsiparta kirar toc, min raupŋina ramtaɨr kocor. ");
INSERT INTO gai_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ainda moca ma ndona iŋa raŋgairena ramtaɨrmo aindopatna, “Warɨŋembta amta reik wɨt anikca maica kocroca eacrena, na aiŋa mona meikramtaɨra wɨtta wanaiŋ. ");
INSERT INTO gai_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Aintik ne an warɨŋna Aetmo mbendeica, ma an warɨŋna aiŋa mona meikramtaɨrmo mbagɨrica taŋca mina warɨŋna amta reik aŋgɨ punina.” ");
INSERT INTO gai_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Karica Iesusa ndona iŋa raŋgairena ramtaɨr parniŋapa mbut mbuniŋmo aca kɨpca, ma minmo ŋerŋgaur ŋgorikca mo kecarinanapa, minmo titocna roumbbebca moi laiŋga mona gagrar neaŋrina. ");
INSERT INTO gai_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Na an ramtaɨr parniŋapa mbuniŋa anna mina mana up aŋgɨrena ramtaɨr. Na mina irembca gade, out ŋgoinna ramootta Saimon, na mana i ianna anna Pita, na ianna Pitana lap Andru. Na ianna Iemis, ma Sebedina nuoc, na Iemisna lappa Ion. ");
INSERT INTO gai_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Na ianna Pilip, na ianna Batolomiu, na ianna Tomas, na ianna Matiu, ma kitcartukar iurena ramoot, na ianna Iemis, ma Alpiusna nuoc, na ianna Tadias. ");
INSERT INTO gai_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Na ianna Saimon, ma Selotna wiwitnan, na ianna Iudas Iskariot, ma ande an ramoot, iŋmbaia ma Iesusmo puŋnaŋgepta para tɨkca mina mamo mo ŋgocrainande. ");
INSERT INTO gai_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Karica Iesusa ndona parniŋapa mbut mbuniŋna up aŋgɨrena ramtaɨrpaikmo mbagɨrica taŋga, minmo aindopatna, “Ne Iudana meikramtaɨr wanaiŋ ndambuŋa kai taŋ teac, na Samariana auŋemb toco kai taŋca mbuk teac. ");
INSERT INTO gai_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Na ne Israelna meikramtaɨr tambuŋa taŋ, mina an sipsipara ŋaŋaoca taŋrena kirar. ");
INSERT INTO gai_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Na ne taŋ te, minmo gan kammo wiwiti, ‘Tamuŋna auŋna bubuoca kɨpca marambuŋairi.’ ");
INSERT INTO gai_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Na ne taŋ te, an roumbbebta meikramtaɨrmo, moi laiŋga mo, na menacrinanmo, mac moca ŋgepna, na roumb lepananmo moi laiŋga mo te, an ŋerŋgaur ŋgorikcaptanmo, moi laiŋga mo. Na an reaca ne aŋgɨrinanna, ne mba oikri, ne wanaiŋ ŋgoin naaŋgɨrina. Aintik ne meikramtaɨrmo wanaiŋa neaŋ, na ne mimo kituknduk aŋgɨnake, kai digi teac. ");
INSERT INTO gai_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“Na ne kitukndukca kai aŋgɨca kituknduk apaocna reikca kai tɨkca aŋgɨca taŋ teac. ");
INSERT INTO gai_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Na ne taŋraŋ te, ne reik apaocna rambca kai aŋgɨ teac, na tik ŋgapaoc kai aŋgɨ teac, co, or ŋgapaoca kai aŋgɨ teac, na nena utiŋga dɨpaca taŋrena komborap kai aŋgɨ taŋ teac. Na ramootta aiŋa mo te, mina manmo amta reikmo neaŋnandet. ");
INSERT INTO gai_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Na ne taŋca auŋ aniac, co auŋ teker ian ndaru te, ne an auŋna ramoot wandoŋ ianna ore wat te, ne taŋca manap eaca taŋca ne an auŋa tɨkcarica taŋ. ");
INSERT INTO gai_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Na ne kac ianna mbuk te, ne an kacna meikramtaɨrmo aindop, ‘Raraŋ Aetaniaca nemo moi laŋa mo.’ ");
INSERT INTO gai_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Na an kacna meikramtaɨra nemo toŋgoca nemo actɨk te, nena kam laŋa minap eac. Na mina nemo actɨkca ndiarna tɨpca mo ŋgocor te, ne Raraŋ Aetaniacmo mbendeica digica, ma minmo kai otac teac. ");
INSERT INTO gai_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","“Ainda moca ramoot ianna nemo ndona kac naaŋgɨca taŋca ndiarna tɨpca mo ŋgocor, na nena kamma waracna ŋate te, ne taŋna mo te, ne an kac, co, auŋ tɨkcarina mo te, ne ndorita orniŋna tiacar kacopca taŋ. ");
INSERT INTO gai_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Na aku nemo gidik ŋgoinna aindopnande, Raraŋ Aetaniacna ritri waparacna ra laru te, gan auŋna meikramtaɨrta makukar minanna Sodom auŋapa Gomora auŋmo kunda tamuŋ ŋgoin.” ");
INSERT INTO gai_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Karica Iesusa minmo gaind mac mbopatna, ne warac, aku nenmo sipsiparta kirara mandaca ne raŋna piriŋta rɨkna inik mataŋgek. Aintik ne nduopna tɨpna kirara raŋgai, nena momona reikca matau lamŋica ne mo. Na ne an ŋgorikca, mina riŋnai ŋgacrenanna kirara raŋgaica, ne tɨp ŋgoreac ianna mona iroa kai aŋgɨ teac. ");
INSERT INTO gai_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Te, ne matau wat, ramtaɨra nemo, mina ninik waŋgorta out naaŋgɨ taŋca mina nemo ritri waparaca moca, mina nemo mina Iudana mimitpac aŋgɨrena kaikta inikca tɨkca nemo pi ŋgoreac ŋgoinna pinande. ");
INSERT INTO gai_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Na mina aukmo, mo irikna iroar, aŋgɨ te, mina nenmo, ninik waŋgor anikapa gagrirta ramtaɨr paŋaind tambuŋ naaŋgɨ taŋnande. Ainda moca ramtaɨr paŋaindapa Iudana meikramtaɨr wanaiŋmo, kam wembaŋ laŋmo minmo wiwitina. ");
INSERT INTO gai_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Na mina nemo aŋgɨca ritri waparacna ramtaɨrta outta tik te, ne kai nanambi gainda kai lamŋi teac, aia titocna kam ndopit? Na aia kaina kam ndopit? An mbopna kɨdrɨk laru te, Raraŋ Aetaniaca ma nemo an mbopna kamma ma nemo wandacnande. ");
INSERT INTO gai_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Na an kamma nen ŋgoinna mba mbopit, nena Raraŋ Aetaniacna Ŋeroŋa ma ndo nena upa tɨkca, an kamb topnande. ");
INSERT INTO gai_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Na ramootta ndona lap, co, lacaumo ritri waparaca tɨkca, manmo mo menacna kammo mbopnandet. Na aetera mina ndorita mombonikmo, an tɨpembta kirar kabea monandet. Na mombonikca ndorita ameraetermo puŋnaŋgepca moca, ramtaɨrmo mbopca minmo mo menacna kamb topnandet. ");
INSERT INTO gai_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Na meikramtaɨra muruŋa nemo nikkatacrinandet, na anna gaind, aukna ia nenap eacrenan. Na meikramtaɨra gagraca eaca taŋca gan tiacarpaikna mamamaina ra, Raraŋ Aetaniaca minmo mac nda aŋgɨnandet.” ");
INSERT INTO gai_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Na mina nemo auŋ ianna tɨkca tɨp ŋgoreaca mo te, ne ŋgepca kɨpcarica kabena auŋa taŋ. Aku nemo gidik ŋgoinna aindopnande, ne Israelna auŋembta aiŋa kocnai mai ŋgocor te, Ramootna Nuoca ma kɨpnande. ");
INSERT INTO gai_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Na riripti aŋgɨrena ramootta, ma ndona riripti neaŋrena ramootmo, ma tamuŋmbaia wanaiŋ, na mbaiŋa morena ramootta, ma ndona kacootmo tamuŋmbaia mba eacitndai. ");
INSERT INTO gai_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Na riripti aŋgɨrena ramootta ma taŋca ndona riripti aŋgɨrena ramootna kirara tɨk te, ma mɨn. Na mbaiŋa morena ramoot toco, ma ndona kacootna kirara tɨk te, ma toco, ma mɨn. Aintik mina an kacna aetmo an i Belsebul tɨk te, aia lamŋinande, mina Belsebulna wiwitnanmo mina minmo, an iremb ŋgorik koinda tɨknandet.” ");
INSERT INTO gai_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Karica Iesusa gaind mac mbopatna, “Ramtaɨra nemo tɨpemb kirarir ŋgorikca morenanmo, ne rugutta kai mo teac. An tamaia moca eacrena reikca muruŋa larui raekca tɨk te. An iŋgoroca eacrena kamb toco muruŋa larui raekca tɨkca meikramtaɨra muruŋa waraci lamŋi garacnande. ");
INSERT INTO gai_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Na kaina kamma aku nemo neaupa tɨkca mboprinanna, an kamma ne ra tɨki mbopnandet. Na kamma ne laŋanna ndorita kour puŋga waracrinanna, anna ne kaik tamuŋa wɨtɨkca aca mbopca meikramtaɨra waracnande. ");
INSERT INTO gai_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Na ne an tikembca moa menacrena ramtaɨrtarica kai rugut mo teac, mina nena ŋerŋgaura mba mo menacitndai, wanaiŋ, ne Raraŋ Aetaniac niŋgikmo nanambi. Ma ndo nena tikembapa nena ŋerŋgaurmo menac ŋgocorta iarwara wɨrrena tac nakena mɨn. ");
INSERT INTO gai_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Na ne lamŋirena, meikramtaɨra ŋgorac teker mbuniŋmo, mina kituknduk teker mbuŋa oikrena. Nena Aetta ma an ŋgorikmo ma mataua raupŋirena. Na ma toŋgo ŋgocor te, an ŋgorikta ianna pitrikca mba irikca menacitndai. ");
INSERT INTO gai_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Na Raraŋ Aetaniaca nena paŋaindta lakoarta kirir motoco ma nduca maica, ma mina ŋgaŋganŋgɨarmo ma lamŋireke, na ma nemo mataua lamŋirena. ");
INSERT INTO gai_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ainda moca ne kai rugut mo teac, ne an ŋgorik noikmo tamuŋ ŋgoin maeacreke.” ");
INSERT INTO gai_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Karica Iesusa gaind mac mbopatna, “Ramootta meikramtaɨrmo aindoprena, ma aukna wiwitta eacrenanna, auk toco ndona tamuŋna Aetmo aindopnande, an ramootta ma auknan. ");
INSERT INTO gai_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Na ramootta meikramtaɨrmo aindoprena, ma aukna wiwitnanna wanaiŋ. Auk toco, ndona tamuŋna Aetmo aindopnande, an ramootta ma auknanna wanaiŋ.” ");
INSERT INTO gai_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Karica Iesusa gaind mac mbopatna, “Ne gainda kai lamŋi teac, aku gan tiacarpaikna runduikca mo menacna nakɨprina. Wanaiŋ. Aku runduikca mo menacna mba kɨpri, aku runduŋna bugrim aŋgɨ kɨpca runduikca mo ŋgepna. ");
INSERT INTO gai_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Na aku kɨprinanna, aku runduik warkica kɨprina. Ramootta ndona aetmo ruŋnande, na mooŋa ndona aemmo ruŋnande, na tamooŋa ndona kaŋgaitna aemmap ruŋnande. ");
INSERT INTO gai_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Na ramootna laiplacarapa mana aemmapa aetta, manmo puŋnaŋgepca monande. ");
INSERT INTO gai_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Na ramootta ndona aemmapa aetmo matau ŋgoinna matŋirenanna, na aukmo matau ŋgoinna mba matŋirenanna, ma aukna iŋa raŋgairena ramootta mba eacitndai. Na ramootta ndona nuoc, co mooŋa matau ŋgoinna matŋirenanna, na aukmo matŋi ŋgocor, ma aukna iŋa raŋgairena ramootta mba eacnandet. ");
INSERT INTO gai_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Na ramootta ndona kekeracna ikca mbuk ŋgocor, na ma aukmo raŋgai ŋgocor, ma aukna iŋa raŋgairena ramootta mba eacitndait. ");
INSERT INTO gai_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Na ramootta ndona eteacna watmo, ma laŋa mo ndop te, ma ndona an iarwarna eteacna wat mananna ma mo kecarinandet. Na ramootta aukna moca ndona wat kecari te, ma an iarwar eteacna wat aŋgɨnande.” ");
INSERT INTO gai_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Karica Iesusa gaind mac mbopatna, “Ramootta nemo aŋgɨca ndiarna tɨpca mo te, ma aukmo aŋgɨca ndiarna tɨp mamori. Na ramootta aukmo actɨk te, ma Raraŋ Aetaniacmo aca tɨkrina, ma ndo aukmo mandaca aku kɨprina. ");
INSERT INTO gai_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Na ramoot ianna gaind ndamŋi te, ‘Ma ramma morena ramootmo otacna mo te, na ma ianmo ndona kac naaŋgɨ taŋca mamo raupŋi te,’ Raraŋ Aetaniaca ma an ramootmo, an rambca morena ramtaɨra aŋgɨrena reik laiŋga ma aŋgɨnande. Na ramoot ianna gainda ndamŋi te, ‘Ma ramoot wandoŋ ianna raupŋi te, ma ndona kac naaŋgɨ taŋca mamo raupŋi te,’ an ramootta Raraŋ Aetaniaca manmo an ramoot wandoŋ aŋgɨrena reik laiŋga neaŋnandet. ");
INSERT INTO gai_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Na ramoot ianna gaind ndamŋi te, ‘Aku Iesusna iŋa raŋgairena ramoot ian.’ Te, ma an meikramtaɨra iremb kocortanmo, puk kaba wanaiŋa neaŋ te, aku nemo gidik ŋgoinna aindopnande, an ramootta Raraŋ Aetaniaca manmo reac laŋ ŋgoinna neaŋnandet.” ");
INSERT INTO gai_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Karica Iesusa ndona iŋa raŋgairena ramtaɨr parniŋapa mbut mbuniŋna mɨnna ramtaɨrmo ririptina kamb ndopca maica, ma ŋgepca an auŋ tɨkcarica, ma an waŋna auŋemb tekira mbukca ndona meikramtaɨrmo wiwitirina. ");
INSERT INTO gai_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Na Ionna ma kac ŋgoreac ndeacrina, na ma anna tɨkca waracrinanna, mina Karaisa morina reikca muruŋa ninirena. Ri, ma ndona iŋa raŋgairena ramtaɨrmo man ndambuŋa mandaca mataŋri. ");
INSERT INTO gai_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ri, mina taŋga mamo aindopatna, “U gade Raraŋ Aetaniac babuca mbagɨrica kɨprina ramoot ki? Co, aia kabena ramootna mac lambiit?” ");
INSERT INTO gai_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Aindopatke, ma mina kam rutica aindopatna, “Ne taŋca Ionmo nini mbop, an reikca ne waracrinan, na ne watrinan. ");
INSERT INTO gai_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","An lamnik ŋgoriktan, mina lamnikca laŋa moca mina mac watrena, na our ŋgoriktanna mina oura laŋa moca, mina mataŋreke. Na ramtaɨra mina tikembca roumb lepaapnanda, mina tikembca mataua laŋ macariri. Na koura rɨkdaca eacrenanna mina koura laiŋga moca mina kambca mawaracreke. Na menaca eacrenanmo, ma mac nda moa mina maŋgepri, na reik kocorta meikramtaɨr ndaekpemb, mina kam wembaŋ laŋ maaŋgɨri.” ");
INSERT INTO gai_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Aintik meikramtaɨra auk morina reik mbatca, mina rɨtɨpaikca mba irikitndai, ainda moca mina toŋtoŋgar koindap. ");
INSERT INTO gai_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Karica Ionna iŋa raŋgairena ramtaɨra mac nda taŋgatke, Iesusa meikramtaɨrmo Ionna nininia moca gaindopatna, “Ne ramtaɨr kocorta taupca taŋca, ne kaina reac mbatna taŋrena? Ne anna taŋca tukara watta moca numairenanna watna taŋre ki? Ainda wanaiŋ. ");
INSERT INTO gai_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Na ne kaina watna taŋrena? Ne ramootta lamboi laŋ, laŋ tɨkreke anna watna taŋre ki? Ainda wanaiŋ. Ainta meikramtaɨra lamboir laiŋga aocrenanna mina gagrirta ramtaɨr paŋaindta kaiknimbca eacrena. ");
INSERT INTO gai_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Na ne, kai ŋgoin mbatna taŋre? Ne ramma morena ramoot ianna mbatna taŋre ki, a? Ore, man niŋgik, na aku nemo gaindopnande. An ramma morena ramoot an, ma rambca morina ramtaɨr ndeidta aiŋirmo, ma minmo tamuŋmbai ŋgoin. ");
INSERT INTO gai_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ri, an ramoot anmo, Raraŋ Aetaniacna timbigta kapca mana nininia morina, ‘Ne warac. Aku ramoot ianmo mbagɨrica ma outta taŋca aukna kam ndop te. Ma una taupembca ma outta kocronande.’ ");
INSERT INTO gai_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Na aku nemo gidik ŋgoinna aindopnandet, kɨtac puk neaŋrena ramoot Ion, ma gan tiacarpaikna meikramtaɨrmo tamuŋmbai ŋgoin. Na ramootta tamuŋna auŋna bubuocna kaŋgaukca mooŋnuoc teker toc ndeacrenan, ma Ionmo tamuŋmbai ŋgoin ndeacrena. ");
INSERT INTO gai_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“An mɨnna kɨtac puk neaŋrena ramoot Ionna ŋgepca ndona aiŋa moca kɨpca gan mɨn, na runduikta ramtaɨr anikca, aiŋir anikca moca tamuŋna auŋna bubuoc aŋgɨna morena, na mina runduik anikca moca rɨtɨpaikta meikramtaɨrmo makukar anik neaŋrena. ");
INSERT INTO gai_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Na Tɨp Wandɨkapa rambca morina ramtaɨr toco, mina Raraŋ Aetaniacna kamma wiwitica kɨpca Ionna kɨpatna mɨn. ");
INSERT INTO gai_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Na ne waracna toŋgo te, ne warac. Raraŋ Aetaniacna timbigta kapca aindoprena, ramma morina ramoot Elaia ma kɨpnande. Anna ma kɨtac puk neaŋrena ramoot Ionna kam ndoprina. ");
INSERT INTO gai_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Na u ramootta koarap, u gan kam mbarac! ");
INSERT INTO gai_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Aintik aku mandeaca gan mɨnna meikramtaɨr morena tɨpembta kirarira, anna kam roora aku titna keit? Mina mombonik morina tɨpna kirara, meikramtaɨr punirena taupca tɨkca, mombonik ndeidmo aca aindopca, ");
INSERT INTO gai_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Aia nemo toŋtoŋgarta ŋapar kumbri, ne mba weri. Na aia nemo kakadmaina ŋapar kumbri, ne mba aeri.’” ");
INSERT INTO gai_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Karica Iesusa gaind mac mboprina, “Kɨtac puk neaŋrena ramoot Ion, ma kɨpca, ma mba tapaca mba ambrenanna, na ma mba wain pukca mba ambrenanna. Na ne mamo gaind mambopat, ‘Ŋeroŋ ŋgoreaca manap maeacreke.’ ");
INSERT INTO gai_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Na Ramootna Nuoca kɨpri, ma wainapa tapacap ambapeke, ne mamo aindopapekna, ‘Watwa, ma amta reik anikapa, wain puk aniac ambrena ramoot. Na ma kitcartukar iurena ramtaɨrapa, tɨpemb ŋgorikta makukara morena ramtaɨrta aikndamoot.’ Na Raraŋ Aetaniacna iro, landamŋi laŋna kam mbaracrina meikramtaɨr, mina ndori aimo wandacrena, Raraŋ Aetaniacna landamŋi, anna reac gidik ŋgoin.” ");
INSERT INTO gai_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Na auŋemb anikca Iesusa ŋgagatracara morinanna, mina iroar inkara mba ŋgetrikiri. Na Iesusa nikcatca mimo kaega morina. ");
INSERT INTO gai_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Karica ma gaindopatna, “Ne Korasinna meikramtaɨrapa Betsaidana meikramtaɨr, nen pembta kadmai, ne makukara aŋgɨnandet. Na ramoot ianna atua Tairap Saidonna taŋga, aku nena rɨkca tɨkca morina ŋgagatraca anna tɨkca mori co, an Tairapa Saidonnannda mina atuna iroar inkar ŋgetrikica ndori morina tɨpemb ŋgorikta kakadmaia moca, kakadmaina lamboi aŋgɨca kotir aoca eac mbe, mina ndorimo an tɨpemb ŋgorikca mina morinanna laŋa wanaiŋ. Aind co, mina ndorita tɨpemb ŋgorikta kakadmai wandac mbe. ");
INSERT INTO gai_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Aintik aku nenmo aindopnande, Raraŋ Aetaniaca meikramtaɨrta makukara ritri waparacna ra laru te, nena moa larurina makukara, Tairapa Saidonna makukarmo kunnandet. ");
INSERT INTO gai_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Na ne Kapaneamnanda, ne ndorimo Raraŋ Aetaniacna tamuŋna auŋ naaŋgɨri ga ndopat, ki? Wanaiŋ ŋgoin. Nenmo mac nda aŋgɨri iriki memenacna taup ŋgoinna tɨknande. Na ramoot ianna Sodoma taŋga, aku nena rɨkca tɨkca morina ŋgagatraca anna tɨkca moco, Sodoma mandeaca ma eacraŋ mbe. ");
INSERT INTO gai_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Aintik aku nemo aindopnande, Raraŋ Aetaniacna meikramtaɨrta makukara ritri waparacna ra laru te, an makukara nemo larurinanna, Sodomna makukarmo kocnaia kundrinan.” ");
INSERT INTO gai_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Karica an mɨnna Iesusa gaindoprina, “Raraŋ Aetaniac, u tamuŋna auŋapa gan tiacarpaikna Kacoot. Aintik aku umo toŋtoŋ ŋgoin, na u landamŋina ramtaɨrapa iroar laiŋta ramtaɨrmo an reik aŋgɨra iŋgorocatke. U ramtaɨra mombonik tekirta kirar ndeacrenanmo, u an reikca minmo wandacrena. ");
INSERT INTO gai_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Na anna laŋ, Ate, u ndona toŋtoŋa raŋgaica u ainda morina.” ");
INSERT INTO gai_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Karica ma gaind mac mbopatna, “Aukna Aetta, ma an reikca muruŋa aukna para tɨkrina. Na ramoot ianna ma mba Nuocmo mba lamŋireke. Raraŋ Aetaniaca ma ndo kabe manmo lamŋirena. Na ramoot ianna ma mba Raraŋ Aetaniacmo mba lamŋireke. Nuoca ma ndo kabe niŋgik ndamŋirena, na Nuoca ndo toŋgorina ramtaɨrmo Raraŋ Aetaniaca wandacrena, na min niŋgikca ndori Raraŋ Aetaniac ndamŋinande. ");
INSERT INTO gai_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Na ne meikramtaɨra aiŋir anik koinda morenan, na ne makukar anikmo mbukrenan, ne auk ndambuŋ nakɨp te, aku nemo wɨktɨtɨkca neaŋnande. ");
INSERT INTO gai_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ne auk ndambuŋna landamŋi aŋgɨca, aukna roumbca eac. Te, ne an bulmakaona kirara mina an ik tɨpca mina bulmakaona logotta tɨkca mina reik wɨŋrena kirar toc. Na ne auk ndambuŋna landamŋi aŋgɨ, aku tɨp kirar wetwet laŋapa meikramtaɨrmo ndona imo mba aŋgɨca ŋgeprena. Te, reikca nemo makukca mba neaŋitndai, na ne wɨk aŋgɨnande. ");
INSERT INTO gai_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Na an ik tɨpca aku nena logotta tɨkrenanna, ma makukar kocor, na reaca aku nemo neaŋrenanna, ne mbuknanna, anna ma gobik ŋgoin.” ");
INSERT INTO gai_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Iŋmbaina Wɨktɨtɨkna Ra ianna Iesusapa mana iŋa raŋgairena ramtaɨra mina witna warɨŋembta inikca anna mbukca taŋrina. Na mana iŋa raŋgairena ramtaɨra nikembwataica mina wittarta lour aŋgɨca maammbat. ");
INSERT INTO gai_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ri, Parisina ramtaɨra an mbatca, mina mamo aindopatna, “Watwa, una iŋa raŋgairena ramtaɨra, an Wɨktɨtɨkna Ra moapekna tɨpna kirara anna wandɨk.” ");
INSERT INTO gai_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Karica ma mina kammo rutica aindopatna, “Eee, Dewitta morina reacna nininia ne Raraŋ Aetaniacna timbigta kapna inikca mba tikca watri, a? Manapa mana ramtaɨra nikembwataica, mina morina reac. ");
INSERT INTO gai_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Dewitta Raraŋ Aetaniacna Ndamma mbukca, ma Raraŋ Aetaniacna outta tɨkca gɨmbamba moatna tapac aŋgɨca ndona ramtaɨrap ambrina. Na an tapaca wandɨkapnan, na taup ndamtaɨra ndori tiŋgikca man ambrenan. Na ne an kamma mba watre ki, a? ");
INSERT INTO gai_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Na ne mba an Tɨp Wandɨkna timbigta kapna inikna kamma ne an toco mba watri, a? Na an kamma ma aindoprina, taup ndamtaɨra an Wɨktɨtɨkna Ra mina Raraŋ Aetaniacna Ndammo aiŋa mori, na mina an ramo aiŋa moreke, mina Tɨp Wandɨkca mo ŋgocrairina, na mina makukar kocor. ");
INSERT INTO gai_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ainda moca aku nemo aindopnande, an reaca ma Raraŋ Aetaniacna Ndammo ma kunda tamuŋmbai ndeacrenanna, mandeaca ma gan maeacreke. ");
INSERT INTO gai_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Na ne an Raraŋ Aetaniacna timbigta kap ndeacrina kamna mɨnɨŋmo matau lamŋi te, ma aindoprina, ‘Aku gɨmbamba mba toŋgorenanna, aku kakadmaina opotacna tɨpna kirara toŋgorena.’ Te, ne an makukar ŋgocorta meikramtaɨrmo, ne minmo makukara moraŋna kambca mba mbopitndai. ");
INSERT INTO gai_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Aintik Ramootna Nuoca ma Wɨktɨtɨkna Rana Kacoot.” ");
INSERT INTO gai_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Karica Iesusa an taup tɨkcarica ma taŋga mina Iudananta mimitpac aŋgɨrena kac mambukat. ");
INSERT INTO gai_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ri, par memenacna ramoot ianna ma anna inik ndeacrina. Na ramtaɨr ndeida, mina mamo ritri waparaca mona moca, mina manmo gainda digiatna, “Aia roumbbebta meikramtaɨrmo Wɨktɨtɨkna Ra mbuŋa moi laŋa moit ki? Wanaiŋ?” ");
INSERT INTO gai_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Karica ma minmo rutica aindopatna, “Na nena rɨkna ramoot ianna mana sipsip ianna Wɨktɨtɨkna Ra au ŋgirik te, ne lamŋinande, an ramootta ma an sipsipmo au inikca tɨkca aŋgɨca gacnande. ");
INSERT INTO gai_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Na ramootta ma sipsipmo tamuŋmbai, aintik aia tɨp kirar laŋmo Wɨktɨtɨkna Ra aia monande.” ");
INSERT INTO gai_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Karica ma an ramootmo aindopatna, “U ndona parmo lotai.” Ri, ma ndona parmo lotaia, an para laŋ mamori, an mana par waŋembaina kirar toc. ");
INSERT INTO gai_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ri, Parisina ramtaɨra ŋgepca an kac tɨkcarica, mina taŋga punica Iesusa mo menacna kam maleacat. ");
INSERT INTO gai_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Na Iesusa ma an Parisina ramtaɨra mana mona ndopatna reaca, ma lamŋire tik, ma an auŋ tɨkcarica mataŋgat, na meikramtaɨr wɨt aniaca mana raŋgaica, ma an roumbbebtanmo, mina roumbbebca muruŋa moa laiŋ mamori. ");
INSERT INTO gai_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ri, ma minmo wandɨk tɨkca, minmo ndoa moi raekca kai mo laru teac, ma mandai ŋgoin. ");
INSERT INTO gai_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ma ainda mori tik, an Raraŋ Aetaniacna ramma morina ramoot Aisaia mbopatna reaca malaruri. ");
INSERT INTO gai_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Na ma aindoprina, “Ganna aukna aiŋna ramoot, aku ndo mamo babuatna. Na aku mamo mamatŋi aniacap, na aukna nikinik iro toco mamo toŋtoŋ ŋgoin, na aku mamo ndona Ŋeroŋ neaŋca ma Iudana meikramtaɨr wanaiŋnanmo tɨpemb kirarir wandoik laiŋta kamb topna. ");
INSERT INTO gai_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Na ma mba kaega moitndai, co, kam aniaca keca mbopitndai, na meikramtaɨrmo taupca punica kamb anik keca minmo mba mbopitndai. ");
INSERT INTO gai_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Na tukunna rɨmbɨtta koaca eacrenanna, an ramootta ma an tukunmo mba rɨmbɨtitndai, na tac memetaca matau wɨr kocortanna an ramootta ma an tac memetacmo mba mo pikitndai. Na an ramootta ma aiŋa mo taŋca Raraŋ Aetaniacna tɨp kirara mo te, meikramtaɨra anna watca raŋgaina. ");
INSERT INTO gai_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Te, rɨtɨpac mbuŋa Iudana meikramtaɨr wanaiŋa mina Iesusna i mbuŋa ndorimo otacna lambinande.” ");
INSERT INTO gai_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Karica an mɨnna mina Iesusmo ŋeroŋ ŋgoreacap eacrina ramoot ianmo, mina aŋgɨca man ndambuŋ makɨpat. Na an ŋeroŋ ŋgoreacapna ramootta mana kamma ŋeroŋ ŋgoreaca leaca, ma kam ndop ŋgocor, na mana lamnɨaca ŋgoreac tɨk ma mba watrenanna. Ri, ma mana ŋeroŋ ŋgoreaca moa kecariri, ma kam ndopri, na ma mawatri. ");
INSERT INTO gai_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Karica meikramtaɨra muruŋa an mbatca ŋgep ŋgoreac naŋgepca tamtam ndamŋica, aindopatna, “Gan ramootta ma Dewitna ŋgamaɨr ki?” ");
INSERT INTO gai_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ri, Parisina ramtaɨra an mbaraca mina aindoprina, “Gan ramootta ma Belsebulna gargar mbuŋa ŋerŋgaur ŋgorikca moa kecarirena. Na Belsebula ma ŋerŋgaur ŋgorikta gagrirta ramoot paŋan.” ");
INSERT INTO gai_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ainda moatke, ma mina landamŋia ma atuna malamŋiri, na ma minmo gaindopatna, “Pitrik ianna meikramtaɨr, mina ndorimo rɨkca titaca tumbun mbuniŋ ndaruca ndorica ruŋ te, mina ndorimo mo ŋgocrainande. Na auŋ aniac ian, co, kamin kabena meikramtaɨr, mina ndorita kɨdrɨkca tumbun mbuniŋa titaca ndorica ruŋ te, mina ndorita kaminna moa maŋgocraica. ");
INSERT INTO gai_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Na Ramoot Mbɨkca, ma Ramoot Mbɨkmo mo kecari te, aia lamŋinande, ma ndomo moa matitacri. Na titocna gargar mbuŋa ma ndona reikmo raupŋit? ");
INSERT INTO gai_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Na Belsebula aukmo otaca aku an ŋerŋgaur ŋgorikmo moa kecarirenanna, anna gidik co, na mandai ndo nena wiwitmo otacreke, mina an ŋerŋgaur ŋgorikca moa kecaririna? Na nena wiwitnanna ndori nenmo wandoŋa aindopnandet, an kamma ne mbopapeknanna anna gidikca wanaiŋ. ");
INSERT INTO gai_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Na Raraŋ Aetaniacna Ŋeroŋa aukmo otaca, aku ŋerŋgaur ŋgorikca mo kecari te, ne lamŋi, Raraŋ Aetaniacna bubuoca nen ndambuŋ nakɨpca malaruri. ");
INSERT INTO gai_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Na titoca tɨk te, ramoot ianna kabena ramoot gargarna kaca mbukca mana reik aŋgɨit? Outta ma an ramoot gargarmo ŋgatɨk gargar mbuŋa leacnande. Na ma ainda mo te, ma an ramootna kacna reikca ma aŋgɨnande. ");
INSERT INTO gai_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Na ramootta, aukna aikndamootta wanaiŋ, ma aukmo ndona puŋndamootta monande. Na ramootta aukmo otaca meikramtaɨrmo aŋgɨri puni ŋgocor, ma ndo mimo aŋgɨri ootca mina tamtamma taŋ mainande. ");
INSERT INTO gai_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“Aintik aku nemo aindopnande, Raraŋ Aetaniaca ma peperena kam ŋgorikcapa, tɨpemb ŋgorikta makukara ma muruŋa mo kecarinandet. Na ramootta Ŋeroŋ Ratmo peperena kam ŋgoreac ndop te, Raraŋ Aetaniaca an ramootna tɨp ŋgoreacna makukca mba mac mo kecariitndait. ");
INSERT INTO gai_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Na ramootta Ramootna Nuocmo kam ŋgoreac ndop te, Raraŋ Aetaniaca mana an tɨp ŋgoreacna makukca ma mo kecarinande. Na ramootta Ŋeroŋ Ratmo kam ŋgoreac ndop te, Raraŋ Aetaniaca mana an tɨp ŋgoreacna makukmo ma mandeac, co, iŋmbaia ma mba mac mo kecariitndai.” ");
INSERT INTO gai_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Karica Iesusa gaind mac mbopatna, “Ikca laŋ te, mana gagamma laŋ. Na ikca ŋgoreac te, mana gagam toca laŋa wanaiŋ. Meikramtaɨra mana errena gagamma wat te, mina aindopnande, anna ik laŋ, co, anna ik ŋgoreac. ");
INSERT INTO gai_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ne ramtaɨr ŋgorik, ne nduip ŋgorikta kirar. Na ne titoca tɨkca kamb laiŋ topit, a? Ramootta mana nikinik iro ndeacrena kambca ma ndona up mbuŋ ndoprena. ");
INSERT INTO gai_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Na ramoot laŋ, mana nikinik iroa iroar laiŋ wɨtap eacrena. Aintik ma tɨpemb kirarir laiŋga morena. Na ramootta iro ŋgoreacap, mana nikinik iroa, iroar ŋgorikca mɨnna tɨkca eacrena. Aintik ma tɨpemb ŋgorikca morena. ");
INSERT INTO gai_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Na aku nemo aindopnande, Raraŋ Aetaniacna ritri waparacna ra, ma an kambca meikramtaɨra ndorimo tamtam ndoprinanna, ma anmo ŋganŋgɨnande. ");
INSERT INTO gai_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Na una kam mbuŋa ma umo ŋganŋgɨca aindopnande, u ramoot wandoŋ, co, una kam mbuŋa ma umo aindopnande, u ramoot ŋgoreac.” ");
INSERT INTO gai_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Karica tɨpemb wandik tamŋirena ramtaɨr ndeidapa Parisina ramtaɨra Iesusmo aindopatna, “Riripti, aia ŋgagatrac ian mbat te, aia lamŋinande, u, Raraŋ Aetaniacna aiŋa morena.” ");
INSERT INTO gai_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ri, ma mina kammo rutica aindoprina, “Gan mɨnna meikramtaɨr, mina meikramtaɨr ŋgorik koind, na mina Raraŋ Aetaniacmo nikinik iro kabeapa wanaiŋ. Memetmbaca mina ŋgagatraca watna digirena. Na mina ŋgagatrac ianna mba watitndai, wanaiŋ ŋgoin. Mina ŋgagatrac kabe niŋgik mbatnande, na an ŋgagatraca ramma morina ramoot, Iounanan. ");
INSERT INTO gai_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Mana ŋgagatraca ma ŋgoaem aniacna nikinik inikmo rai mbonkacapa mouŋemb mbonkacna mɨn ndeacrina, na Ramootna Nuoc toco, ma muk inikmo rai mbonkacapa mouŋemb mbonkacna mɨn ndeacnandet. ");
INSERT INTO gai_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Na Raraŋ Aetaniacna ritri waparacna ra laru te, Niniwana ramtaɨra ŋgep wɨtɨkca gan mɨnna meikramtaɨrta tɨpemb ŋgorikmo ritri waparaca monande. Aintik mina Iounana neaŋgatna mimitpacna kamma waraca mina iroar inkara ŋgetrikirina. Na nena rɨk ndeacrena ramoot ian, ma Iounnamo, kunda tamuŋ ŋgoin. ");
INSERT INTO gai_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Na Raraŋ Aetaniacna meikramtaɨrta makukara ritri waparacna ra laru te, mon tawan ŋgoinna raŋmbaina pitrikna auŋna gagrirta meac paŋan ianna ndo kɨpca gan mɨnna meikramtaɨr morena tɨpemb ŋgorikta tɨpembta ritri waparaca monande. Aintik an gagrirta meac paŋanna, ma ŋgaua mon tiacarpaikna mamaina auŋ ndeacrinanna, ma ndomo kɨpca Solomonna, ndona landamŋiar laiŋta kamb top te, ma ndomo anna waracna moca anna nakɨpatna. Na ramoot ianna gan ndeacrenanna, ma Solomonmo kunda tamuŋ ŋgoin.” ");
INSERT INTO gai_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Karica Iesusa gaind mac mbopatna, “Moca ŋeroŋ ŋgoreaca ramoot ian tɨkcarica, ma puik kocorta taupca ndo mbukca mbiraca wɨktɨkca eacna taupembta korena. Na ma taup ianna wat ŋgocor te, ");
INSERT INTO gai_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ma aindopnande, ‘Aku mac nda taŋca ndona atu ndeacrina kac mac nda taŋna.’ Na ma taŋca an kaca wattatnanna anna meikramtaɨr kocor ndeacrenan, anna mina mataua maica laŋ ŋgoin ndeacrena. ");
INSERT INTO gai_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ainda moca ma nda taŋga kabena tɨpemb ŋgorik koindara morena ŋerŋgaur parmbaiapa mbut mbuniŋna mɨn naaŋgɨca kɨpca mina an kac ndeacnande. An ŋerŋgaura mina tɨpemb ŋgorikca mana tɨpemb ŋgorikmo minanna kunda tamuŋ ŋgoin ndeacrenan aŋgɨca kɨpca mina an kacna inik ndeac te, an ramootta ma ŋgaua laŋmbai ndeacrenanna, mandeaca ma kocnai ŋgocrainande. Na an tɨpna kirar kabea gan mɨnna meikramtaɨr ŋgorikmo larunande.” ");
INSERT INTO gai_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Karica Iesusa meikramtaɨrmo kam ndopri mbuŋa, mana aemmapa laipitikca kɨpca raekmbaia wɨtɨkca, na mina manap mbopna moca. ");
INSERT INTO gai_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ri, ramoot ianna manmo aindopatna, “U warac, una aemmapa laipitikca raekca wɨtɨkca eacrenanna, anna mina unap mbopna moca.” ");
INSERT INTO gai_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ainda moca ma mana kammo rutica aindoprina, “Mandaia aukna aem, na mandaia aukna laipitik, a?” ");
INSERT INTO gai_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Karica ma ndona iŋa raŋgairena ramtaɨrapa meikramtaɨrmo par mbuŋa wandaca aindopatna, “Wat, anna aukna aemmapa laipitikca gade. ");
INSERT INTO gai_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Na mandaibinna aukna tamuŋna Aetna toŋtoŋa raŋgairenanna, anna mina aukna laipitikapa, mbiarpaikapa aukna amer.” ");
INSERT INTO gai_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Na an ra mbuŋa Iesusa an kac tɨkcarica laruca, ma taŋga mɨar roumb mambiracat. ");
INSERT INTO gai_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ri, meikramtaɨr wɨt aniac ŋgoinna man ndambuŋ nakɨpri, aintik ma kor ian naŋgabukca mbiracatke, meikramtaɨra mina maŋarmbaia wɨtɨkca eacri. ");
INSERT INTO gai_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ainda moca ma mimo kam roor wɨt makeat, na ma gaindopatna, “Ne warac, ramoot ianna ma witna lourmo aŋgɨra taŋga warɨŋna inikca mbukca, ma an witna lourmo an nakeca taŋrina. ");
INSERT INTO gai_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Na ma keca taŋri, witna lour ndeida taup ndiŋ ŋgirikrinan, na ŋgorikca kɨpca maambri. ");
INSERT INTO gai_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Na witna lour ndeida tiacarpaikca watur tambat ndeacrenanna, an nambatta irikat tik, mina tawina gacatna. ");
INSERT INTO gai_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Na ra aŋgɨatke, mana otanna minmo rotaca mina marereca kocnaia gururina. Mina kacrira tiacarpaikmo mba irikri, aintik mina menacrina. ");
INSERT INTO gai_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Na witna lour ndeida lacarta ŋgaɨrta kɨdrɨk ŋgirikca, na an lacarta ŋgaɨra ŋgepca minmo wɨŋga makɨtacat. ");
INSERT INTO gai_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Na witna lour ndeida tiacar laiŋpaik nambat ŋgirikca, an nambat nagacrinanna, mina ŋgepca amta reikca kootrina. Ri, ndeida 100na mɨnna kootrina, na ndeida 60na mɨnna kootrina, na ndeida 30na mɨnna kootrina. ");
INSERT INTO gai_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Na u ramootta koarap, u gan kam mbarac.” ");
INSERT INTO gai_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Karica Iesusna iŋa raŋgairena ramtaɨra kɨpca mamo, mana kecapekna kam roorna mɨnɨŋna nda digica, mina aindopatna, “Kaina moca u meikramtaɨrmo kam roor mbuŋa kerena?” ");
INSERT INTO gai_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ri, ma mina kammo gainda rutica aindopatna, “Tamuŋna auŋna bubuocna kamma tamaia iŋgoroca eacrena mɨnɨŋa, ma nemo wattacarica, ne lamŋia garacrina. Na gan meikramtaɨrmo ma mba wandacri. ");
INSERT INTO gai_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Na ramoot ianna ma reikap eacrinanna, Raraŋ Aetaniaca mamo reik ndeida mamo mac neaŋnande, te, ma reik wɨt aniacap. Na ramootta reikca wɨtta wanaiŋ, Raraŋ Aetaniaca mana an reik mbatepmo mo kecarinande. ");
INSERT INTO gai_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Aintik anna mɨnɨŋna moca, aku minmo kam roor mbuŋa mimo kam roor kerenan. Na mina lamnik puŋga wat te, mina reikca mba watitndai, na mina kour tɨk te, mina kambca waraca landamiŋa mba aŋgɨitndai. ");
INSERT INTO gai_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Na an meikramtaɨr puŋga ramma morina ramoot Aisaiana kamma gidik ndarurina. Na ma gaindoprina, ‘Ne kammo memetmbaca waracraŋ, na ne mana mɨnɨŋa mba garacitndai. Na ne memetmbaca watraŋ, na ne reac ianna mba wati garacitndai. ");
INSERT INTO gai_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ainda moca gan meikramtaɨrta nikinik iroar minanna kocnaia mboraca iroar laiŋ kocor, na mina koura kambca waracna ŋaterenanna, mina ndorita lamnikmo purocrinan, moca mina lamnikca reac ianna wat nari, na moca mina koura kamb mbarac nari, na mina nikinik iroara kambta mɨnɨŋa garac nari. Te, mina nikinik iroar uriraca auk ndambuŋ mac nda kɨpca, aku minmo moi laiŋga monandet.’ ");
INSERT INTO gai_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Aintik ne toŋgo, nena lamnikca reikca watrinan, na nena koura kambca waracrenan. ");
INSERT INTO gai_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Na aku nemo gidik ŋgoinna aindopnandet, atua rambca morina ramtaɨr wɨtapa ramtaɨr wandoik laiŋga, an reikca ne mandeaca watrenan, mina an reikca watna toŋtoŋgar anikap, na mina mba watri. Na mina an nena waracrena kambta kambma waracna toŋtoŋgar anikap, na mina mba waracri.” ");
INSERT INTO gai_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Karica Iesusa gaind mac mbopatna, “Mandeaca, ne an ramootta witna lourmo warɨŋ inik nakerinanna kam roorna mɨnɨŋa waracnande. ");
INSERT INTO gai_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Na mandaia Raraŋ Aetaniacna bubuocna kam wembaŋa waraca, mana mɨnɨŋa garac ŋgocor, ma ande an witna loura taup ndiŋ ŋgirikrinanna kirar. Iŋmbaia Ramoot Ŋgoreaca kɨpca, Raraŋ Aetaniacna kamma mana iro inik ndeacrenanna tɨki mo kecarinande. ");
INSERT INTO gai_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Na witna loura watur tambatna tiacarpaik ŋgirikrinanna, mana mɨnɨŋa gaind, ramootta Raraŋ Aetaniacna kam mbaraca tawi ŋgoinna aŋgɨca toŋtoŋ ŋgoin. ");
INSERT INTO gai_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Na mina iacndukar kocor, aintik mina rocotta mba eacrenanna, na meikramtaɨra Raraŋ Aetaniacna kammo, mo irik te, na mina an ramootmo, makukca neaŋnande, co mamo tɨp ŋgoreaca mo te, mana rɨtɨpaca tawi ŋgoinna iriknande. ");
INSERT INTO gai_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Na witna loura lacarta ŋgaɨrta kɨdrɨk ŋgirikrinanna, anna mɨnɨŋa gaind, ramootta ma kam mbaracrenan, na mana iroa gan tiacarpaikna reikta tamtam ŋgoin ndamŋirena, na ma kituknduk wɨt aniac aŋgɨ wembacna kadmairena. Na an reikca Raraŋ Aetaniacna kammo kɨtac irikca ma gagaimb kocor. ");
INSERT INTO gai_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Na an witna loura tiacar laiŋpaik ŋgirikrinanna, anna mɨnɨŋa gaind, anna meikramtaɨra Raraŋ Aetaniacna kamma waraca mina mana mɨnɨŋa mataua lamŋirenanna. Mina gagaimbca 100na mɨn, na 60na mɨn, na 30na mɨn.” ");
INSERT INTO gai_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Karica Iesusa mimo kabena kam roor ian mac makeat, na ma aindopatna, “Tamuŋna auŋna bubuoca, ma ramootta witna lour laiŋmo ndona warɨŋ nakerina kirar. ");
INSERT INTO gai_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Na mouŋa meikramtaɨra ŋgori, mana puŋnaŋgepta ianna kɨpca mana warɨŋmo katgɨn ŋgorikmo mana witna lourta warɨŋ inikca keca mataŋri, na an maica ma mataŋgat. ");
INSERT INTO gai_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ainda moca iŋmbaia an witta gaca amta reik makootri, mina wattatnanna ma katgɨn ŋgorikap kurica eacri. ");
INSERT INTO gai_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Aintik mana mbaiŋna aiŋa morena ramtaɨra taŋga manmo watca aindopatna, ‘Kacoot, aia lamŋirena, u ndona warɨŋmo u witna lour laiŋ tiŋgikna kerinan. Na titoca moca katgar ŋgorikca anap gacre?’ ");
INSERT INTO gai_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Ri, ma mimo aindopatna, ‘Aukna puŋnaŋgepta ianna ndo ainda morina.’ Karica mana mbaiŋna aiŋa morena ramtaɨra aindopatna, ‘Aia taŋca an katgar ŋgorikmo wɨŋi aŋgɨca tumbunna tɨkna, na u toŋgori ki, wanaiŋ?’ ");
INSERT INTO gai_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Karica ma mina kamb rutica aindopatna, ‘Kari, moca ne katgar ŋgorik tarki te, ne witna lourap tarkinande. ");
INSERT INTO gai_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Aintik ne watcarica, maniŋa tumbunniŋa ga taŋca amna mɨnna tɨk te, an mɨn mbuŋa aku an aiŋa mona ramtaɨrmo mbopnande, “Ne outta ne an katgar ŋgorikmo tarkica tumbunna tɨkca, kaipa leaca taca rotac. Te, ne witna lourmo aŋgɨ punica aukna amta reik tɨkrena kaca tɨkna.”’” ");
INSERT INTO gai_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Karica Iesusa mimo kabena kam roor ian mac makeat, na ma aindopatna, “Tamuŋna auŋna bubuoca ma ik mastetna loorna kirar. Na ramoot ianna an ikna loormo ndona warɨŋa mutocatna. ");
INSERT INTO gai_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Na ik mastetna loura ma an kabena ikirta lourta kirara wanaiŋ. Mana loura tekirnoik koind, na ma ŋgepi acnai te, ma an warɨŋna ambrena ikirta uprirmo ma gaci kunda ikca monande. Te, raŋna ŋgocraikca mana ŋaikmo kaikca moraŋnande.” ");
INSERT INTO gai_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Karica Iesusa mimo kabena kam roor ian mac makeri, na ma mimo aindopatna, “Tamuŋna auŋna bubuoca ma isna kirar. Na meac ianna an is teker emtem aŋgɨca witna kapɨrta kɨndɨb mbonkacmo aŋgɨ tuoŋ aniaca tɨki kuri te, iŋmbaia ma uri gaca bagaraniaca monande.” ");
INSERT INTO gai_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Na an kambca Iesusa meikramtaɨrmo muruŋa minmo keca mboprinanna, ma minmo kam roor mbuŋ ndoprina. Na ma minmo kam ian ndop te, mina garacna mɨnna wanaiŋ, ma minmo kam roor niŋgik mbuŋa keca minmo mboprenan. ");
INSERT INTO gai_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ainda moca an kirar mbuŋa ma an ramma morina ramoot ianna atua mboprina kam ndiŋa mbopca larurinanna moca mɨnna tɨknandet. Na ma aindoprina, “Aku nemo kam roor mbuŋa keca mbopraŋnande. Na aku nemo atu ŋgoinna iŋgoroca eacrina reikmo nininande, an mɨnna tiacarpaikca ŋgepca kɨpca gan mɨn.” ");
INSERT INTO gai_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Karica Iesusa meikramtaɨrmo tɨkcarica ma kaca mbukri, mana iŋa raŋgairena ramtaɨra kɨpca mamo aindopatna, “U aimo an katgɨn ŋgoreaca warɨŋ inikca garina kam roorna mɨnɨŋa aimo mbopna toc ki?” ");
INSERT INTO gai_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ri, ma mina kammo gainda rutica aindoprina, “Ramootta witna lour laiŋmo warɨŋna inik nakerinan, anna ande, Ramootna Nuoc. ");
INSERT INTO gai_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Na warɨŋa ma gade gan tiacarpaik. Na an witna lour laiŋga, anna tamuŋna auŋna bubuocna meikramtaɨr. Na an katgɨn ŋgoreaca anna Ramoot Ŋgoreacna meikramtaɨr. ");
INSERT INTO gai_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Aintik an puŋndamootta, katgar lourmo warɨŋa kerinan, anna Paparuna Ramoot. Na amna reac aŋgɨna ra, anna Raraŋ Aetaniacna ritri waparacna ra. Na aiŋa morena ramtaɨr, anna Raraŋ Aetaniacna mbaiŋna aiŋa morena ŋerŋgaur. ");
INSERT INTO gai_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Na ramtaɨra katgɨn ŋgoreac aŋgɨca kapca tɨkca, tac nake mbukca wɨrrenan, an kirar kabea mina gan tiacarpaikna mamai mbuŋa monande. ");
INSERT INTO gai_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ainda moca Ramootna Nuoca ma ndona mbaiŋna aiŋa morena ŋerŋgaurmo mbagɨrinandet, mina an tamuŋna auŋna bubuocna reik ŋgorikmo mo kecarina, an reikca ramootna rɨtɨpaca mo ŋgocrairena, na tɨp wandɨkmo nda ipuŋrena meikramtaɨr toco, mina mimo mo kecarinandet. ");
INSERT INTO gai_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Te, mbaiŋna aiŋa morena ŋerŋgaura minmo tac aniac nake mbuknandet, na an tacna inikca mina ndorita ndaɨrmo iriki ikca aeraŋnandet. ");
INSERT INTO gai_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Na an mɨnna meikramtaɨr wandoikca mina wapatta rana memetac toc watnande, an mina Aetna bubuocna inikmo metacnande. Na u ramootta koarap, u gan kam mbarac.” ");
INSERT INTO gai_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Karica Iesusa kam roor ian mac makeat, na ma aindopatna, “Tamuŋna auŋna bubuoca ma gaind tocna kirar, kitukndukca mina warɨŋna inikca au iaca aŋgɨca iŋgorocrina kirar. Na ramoot ianna anna watri, aintik ma an kituknduk aŋgɨna toŋtoŋ ŋgoinna moca, ma an kitukndukmo aŋgɨca an warɨŋmo kabena taup mac taŋga kabena au iaca aŋgɨca iŋgorocatna. Na ma ndona reikmo muruŋa mbik tɨkca mina oikatke, ma an kitukndukmo aŋgɨa ma taŋga an warɨŋmo maoikat.” ");
INSERT INTO gai_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Karica Iesusa gaind mac mbopatna, “Kabena kam roor ianna aku gaind mac kenandet, tamuŋna auŋna bubuoca ma kituknduk aniac mbuŋa mina logotta wiracrena karorelour laiŋ, laiŋga oikrena ramoot ianna kirar. ");
INSERT INTO gai_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Na ma orea watta taŋga ma logotta wiracrena karoretloor laŋ ian ŋgoinna wat te, ma taŋca ndona reikmo mbik tɨkca mina oik te, ma kituknduk aŋgɨca taŋca an kituknduk aniac mbuŋa logotta wiracrena karoretloor kabe an oiknande.” ");
INSERT INTO gai_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Karica Iesusa gaind mac mbopatna, “Kabena kam roora gaind nakerena, tamuŋna auŋna bubuoca, ma an weaŋa mina mɨar nakerena kirar, na ma ainta ŋgoaebap aŋgɨrena. ");
INSERT INTO gai_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Na weaŋa ŋgoaebca mbukca mɨnna tɨk te, mina wɨŋ gaca, mina mbiraca mimo riacnande. Na ŋgoaeb laiŋmo mina aŋgɨca taumma tɨk te, ŋgoaeb ŋgorikmo mina aŋgɨ kecarinandet. ");
INSERT INTO gai_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Na ritri waparacna ra, gan tiacarpaikca ma aind ndarunande. Raraŋ Aetaniacna mbaiŋna aiŋa morena ŋerŋgaura mina kɨpca ramtaɨr ŋgorikmo an ramtaɨr wandoikta rɨkca tɨkca riac aŋgɨnandet. ");
INSERT INTO gai_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Te, ramtaɨr ŋgorikmo aŋgɨca tac aniac nake mbuknande. Na an tacna inikca mina ndorita ndaɨrmo iriki ikca aeraŋnandet.” ");
INSERT INTO gai_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ri, ma ndona iŋa raŋgairena ramtaɨrmo ainda digiatna, “Ne an kamb roura aku muruŋa kerinanna, ne mina mɨnɨŋa lamŋica garacre ki?” Na mina rutica aindopatna, “Ore.” ");
INSERT INTO gai_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Karica ma mimo aindopatna, “Aintik tɨpemb wandik tamŋirena ramtaɨra mina tamuŋna auŋna bubuocna kamna mɨnɨŋa mina lamŋirenan, na mina kac aniac ianna aetna kirar. Na ma ndona kac aniaca mbukca ma ndona reik ŋgaib laiŋapa reik bagrar laiŋmo tumbunna tɨkca aŋgɨ kɨpnande.” ");
INSERT INTO gai_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Karica Iesusa kam roora keca maicatke, ma ŋgepca an tɨkcarica mataŋgat. ");
INSERT INTO gai_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ri, ma taŋga ndona auŋ malaruat, na ma taŋga mina Iudana mimitpac aŋgɨrena kaca mbukca minmo Raraŋ Aetaniacna kam mariptiri. Na mina mana kamma waraca ŋgep ŋgoreac naŋgepca, mina aindopatna, “Gan ramootta ma an landamŋimo, ten ŋgoinna tɨkca aŋgɨatna? Na ma titoca moca ma ŋgagatracara morina? ");
INSERT INTO gai_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Na aia lamŋirena gan ramoot, ma reikta muindira morena ramootna nuoc, na mana aemma Maria. Na mana laipitikca, Iemis, Iosep, Saimonap Iudas. ");
INSERT INTO gai_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Na mana mbiara, aiap eacrenan. Na ma an gargarmo tenna tɨkca aŋgɨatna.” ");
INSERT INTO gai_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ainda moca mina mamo kam ŋgorik topri, mina mamo nikinik iro ŋgoreac maaŋgɨat. Ri, ma minmo aindopatna, “Ramma morena ramoot, ma kabena auŋembca ma iap, na mana auŋapa bar ŋgoinna ma iremb kocor.” ");
INSERT INTO gai_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Aintik an auŋna meikramtaɨra mamo rɨpac ŋgocor, tik ma an auŋmo ŋgagatracara wɨtta mba mori. ");
INSERT INTO gai_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Na an mɨnna Galilina pitrikna ramoot paŋan Erotta Iesusna nininina kam mbaracatnan. Na an Erot, mana i ianna Antipas, na ma gagrirta ramoot Erotna nuoc. ");
INSERT INTO gai_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ainda moca ma ndona mbaiŋna aiŋa morena ramtaɨrmo, aind mambopat, “Anna kɨtac puk neaŋrena ramoot Ion, ma menaca muk ndiŋ mac nda ŋgepca ma ainta gargarap tik, ma an ŋgagatraca morena.” ");
INSERT INTO gai_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ainda moca Erotta, Ionmo utiŋa lawirta ŋgatɨk mbuŋa leaca mamo kac ŋgoreac matɨkat. Na anna mɨnɨŋa gaind, Erotta ndona lapmbitac Pilipna meac Erodias laŋgocatna makukna mori. ");
INSERT INTO gai_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Na kɨtac puk neaŋrena ramoot Ionna, ma Erotmo gaindopatna, “U an meaca laŋgorinanna, anna tɨp laŋa wanaiŋ.” ");
INSERT INTO gai_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ainda moca ma Ionmo mo menacna mori, na ma mac nanambica, moca ma mo te, meikramtaɨra manmo kaega monande, mina lamŋirena Ionna ma ramma morena ramoot ian. ");
INSERT INTO gai_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Karica Erotta mana aemma mana mɨrrina rana ndamŋina moca ma amna reac aniac moca ramtaɨr ndeida kɨpca manap maambri. Na an mɨnna Erodiasna mooŋa kɨpca mina rɨkmo, ma kemna orpaikca mori, Erotta mana kemna orpaikna moca ma toŋtoŋ ŋgoin. ");
INSERT INTO gai_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Aintik ma mamo gainda babua aindopatna, “Gidik ŋgoin, u aukmo kaina reacna digi te, aku umo neaŋnande.” ");
INSERT INTO gai_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ri, an mooŋna aemma manmo iro neaŋga, an mooŋa Erotmo aindopatna, “Aku toŋgorinanna u kɨtac puk neaŋrena ramoot Ionna paŋan wawɨra tuoŋ ianna tɨkca aukmo neaŋ.” ");
INSERT INTO gai_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ainda moca gagrirta ramoot paŋanna an kamma waraca mana nikinik iroa makukuamacariat. Na ma ndona babuatna kamna moca, ma an ndoap eacrina meikramtaɨrta outta, numbir aŋgɨ narica, ma ndona lapoca ruŋrena ramtaɨrmo mbopca mina an mooŋna toŋtoŋ maraŋgaiat. ");
INSERT INTO gai_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ri, ma ramoot ianmo mbagɨrica kac ŋgoreaca taŋca, anna lapoca ruŋrena ramtaɨrmo mbopca mina kɨtac puk neaŋrena ramoot Ionna logotmo wawɨrna. ");
INSERT INTO gai_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ainda moca mina mana paŋanmo wawɨrca tuoŋ ianna tɨkca, aŋgɨca kɨpca an mooŋmo maneaŋgat. Ri, ma an paŋanmo aŋgɨca ndona aemmo aŋgɨca mataŋgat. ");
INSERT INTO gai_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Aintik kɨtac puk neaŋrena ramoot Ionna iŋa raŋgairena ramtaɨra kɨpca mana waɨra aŋgɨca taŋga manmo mamutocat, karica mina taŋga Iesusmo mambopat. ");
INSERT INTO gai_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ri, Iesusa an kamma waracri, ma kor ianna aŋgɨca an auŋ tɨkcarica ma ramtaɨr kocorta taup ianna ndo kabe mataŋgat. Ainda moca meikramtaɨr wɨt aniaca man tataŋna kamma waraca mina ndorita auŋemb tekir tɨkcarica, ŋgepca mbat ndiŋa mana iŋmbai maraŋgaiat. ");
INSERT INTO gai_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Karica ma kornan gaca wattatnanna, ma an meikramtaɨrta tumbun aniaca watca, mana iro inikca mina moca kakadmai aniacap. Ainda moca ma an roumbbebta meikramtaɨrmo, mina roumbbebmo moa laiŋ mamori. ");
INSERT INTO gai_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Na ra irikca wigwacari, mana iŋa raŋgairena ramtaɨra kɨpca mamo aindopatna, “Ra maica mairikreke, na ganna ramtaɨr kocorta taup, u an meikramtaɨrmo mandaca mina taŋca an auŋembta amta reik koikca amna.” ");
INSERT INTO gai_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ainda moca ma minmo rutica aindoprina, “Wanaiŋ, mina mba mac taŋitndai, ne ndori minmo amta reik neaŋca mina amna.” ");
INSERT INTO gai_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ri, mina manmo rutica aindopatna, “Aia tapacar tɨpemb parmbaiapa ŋgoaem mbuniŋ niŋgikap eacrenan.” ");
INSERT INTO gai_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Karica ma mimo aindopatna, “Anmo auk ndambuŋ naaŋgɨ kɨp.” ");
INSERT INTO gai_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ri, ma an meikramtaɨrmo mbopca, mina katgar tambatta mbiraca, ma an tapacar tɨpemb parmbaiapa ŋgoaemniŋ aŋgɨca tamuŋna auŋa raica watca, ma Raraŋ Aetaniacmo kam tɨp laŋ neaŋca ma an tapacarpaikmo, rɨmbɨtta ndona iŋa raŋgairena ramtaɨrmo neaŋca mina an meikramtaɨrmo mabiŋaiat. ");
INSERT INTO gai_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Karica mina muruŋa amba taŋga mɨn ŋgoinna tɨkatna. Na mana iŋa raŋgairena ramtaɨra, an mina amba mɨnna tɨkatna amta reik tɨpembmo larkambca parniŋapa mbut mbuniŋna mɨnpaik maaocat. ");
INSERT INTO gai_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Na an amta reik ambatna ramtaɨra 5,000na mɨn toc. Na mina meikpitikapa mombonikmo mba nduri. ");
INSERT INTO gai_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Karica Iesusa ndona iŋa raŋgairena ramtaɨrmo, aindopatna, “Ne tawina kor naŋgabukca aukmo outmbaica mɨarmo waŋembai nagac.” Na ma ndo pac eaca, meikramtaɨrmo mandaca taŋna toŋtoŋap. ");
INSERT INTO gai_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ainda moca an meikramtaɨr muruŋmo ma mbagɨrica, mina taŋgatke, ma takur ian magat, ma anna tɨkca mbendeina moca. Na ra irikatke, ma ndo kabea an maeacri. ");
INSERT INTO gai_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Na an mɨn mbuŋa kora mɨarmo mon tawan ŋgoinna taŋrena, na watta macaitmo moca ma kora ndatapiri tik, ma minmo aŋgɨca irikgatɨkri. ");
INSERT INTO gai_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Karica maica auŋa raruna mori, Iesusa ŋgepca mɨarna puk nambat ndiŋa wɨtɨkca ndona iŋa raŋgairena ramtaɨr tambuŋa mataŋri. ");
INSERT INTO gai_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Na mina watri, ma macait nambat ndiŋa taŋri, mina nanambia aindopatna, “Anna raraŋ ian.” Na mina kocnaia nekcarica larɨkca ŋgocraica. ");
INSERT INTO gai_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ri, ma minmo anduna aindopatna, “Ne kai nanambi teac, ne gagraca eac, ganna auk.” ");
INSERT INTO gai_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Karica Pita rutica aindoprina, “Kacoot, anna un gidik ecte, auk motocmo mbopca aku macait nambat ndiŋa un ndambuŋ nakɨpna.” ");
INSERT INTO gai_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ri, ma manmo nda rutica aindopatna, “U kɨp!” Ri, Pita kor ndiŋnan irikca macaitta wɨtɨkca, an nambat ndiŋa man ndambuŋ mataŋri. ");
INSERT INTO gai_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Na ma watapa macaitta watca, ma rugut moca, ma puk inik mairikreke, ri, ma manmo kam keca aindopatna, “Kacoot aukmo otac.” ");
INSERT INTO gai_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ri, Iesusa ndona parmo anduna rapaca taŋga Pitamo utiŋga aindoprina, “Una rɨtɨpaca teker ŋgoin! Na kaina moca u iro mbuniŋap?” ");
INSERT INTO gai_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Karica maniŋa muruŋniŋa kor naŋgabukri, an wat gargara toca mamenacat. ");
INSERT INTO gai_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ri, an ramtaɨra kor ndeacrenanna, mina tutpemb rɨmbɨtca mana mbendeiri, mina gaindopatna, “Gidik ŋgoin, u Raraŋ Aetaniacna Nuoc.” ");
INSERT INTO gai_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ainda moca manapa mana iŋa raŋgairena ramtaɨra mɨarmo kataca monmbai waŋa taŋga Genesaret waŋ matundocat. ");
INSERT INTO gai_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ri, anna ramtaɨra mamo watta garaca, mina an auŋembca rambuŋ ndeacrenanmo kam neaŋga taŋga, mina an roumbbebta meikramtaɨrmo, muruŋa aŋgɨca man ndambuŋ makɨpat. ");
INSERT INTO gai_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Na mina mamo gagra mbopca ma an roumbbebta meikramtaɨrmo wattacarica, mina mana tik ŋgapaoc rocotna mamamaina tɨpmo pipikna. Ri, anna meikramtaɨra muruŋa ainda mori, mina laiŋ mamoat. ");
INSERT INTO gai_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Na an mɨnna Parisina ramtaɨr ndeidapa tɨpemb wandik tamŋirena ramtaɨra, Ierusalem tɨkcarica mina Iesus ndambuŋ makɨpri. Na mina mamo gainda digirina, ");
INSERT INTO gai_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Kaina moca una iŋa raŋgairena ramtaɨra, aina nicar ŋgamrirta tɨpemb kirarirmo raŋgai ŋgocora ndorita paɨrmo mba tukica ambrena?” ");
INSERT INTO gai_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ri, ma mina kammo rutica aindopatna, “Na kaina moca ne Raraŋ Aetaniacna Tɨp Wandɨkca raŋgai ŋgocor, na ne ndorita nicar ŋgamrirta tɨpemb kirarir koinda raŋgairena? ");
INSERT INTO gai_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Na Raraŋ Aetaniaca aindoprina, ‘Ne ndorita aemeraterta kambca waraca raŋgai, na mandaia ndona aemaetmo kam ŋgoreac ndop te, mina mamo mo menacnande.’ ");
INSERT INTO gai_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Na ne gaindoprena, ‘Ramoot ianna ma ndona aemmapa aetmo otacna kitukndukarapa reikap, na ma gaindop te, “Kainta reikapa kitukndukca aku oŋmo neaŋ ndoprinanna, aku anmo Raraŋ Aetaniaca neaŋna larapacrina.” ");
INSERT INTO gai_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Te, an ramootta ma ndona aemmapa aetmo kai lamŋica maniŋmo matau mo teac.’ Na an tɨpna kirara ne Raraŋ Aetaniacna kammo nda ipuŋrinan, na nena nicar ŋgamrirta tɨpemb kirarira ne aŋgɨrinanna, ne anna raŋgairena. ");
INSERT INTO gai_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","“Ne paparuna ramtaɨr. An ramma morina ramoot Aisaia, ma nen ŋgoinna rɨŋrina kammo ma gidik ŋgoinna aindoprina, ");
INSERT INTO gai_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Gan meikramtaɨra aukna imo ndorita upemb puŋga aŋgɨca ŋgeprena, na mina nikinik iroara aukmo tawan ŋgoin maeacreke. ");
INSERT INTO gai_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Na mina ramoot, tɨkrina ririptina tɨpemb kirarir tiŋgikca raŋgaica aindoprena, “Ganna Raraŋ Aetaniacna kam.” Aintik mina aukmo wanaiŋa mbendeirena.’” ");
INSERT INTO gai_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Karica Iesusa meikramtaɨrmo aca man ndambuŋa kɨpca, minmo aindopatna, “Ne waraca matau lamŋi rapac. ");
INSERT INTO gai_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Na reaca ramootna up inikca mbukrenanna, anna ramootmo mba moca patiŋga mba moitndai. Na reaca ramootna up inik ndiŋ ndarurenanna, anna ramootmo moca ma patiŋga monande.” ");
INSERT INTO gai_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Karica iŋmbaia mana iŋa raŋgairena ramtaɨra man ndambuŋa kɨpca mamo gaindopatna, “U lamŋire, ki? An Parisina ramtaɨra an u mbopatna kambta moca unmo iroar ŋgorik maaŋgɨat.” ");
INSERT INTO gai_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ri, ma mina kammo rutica aindopatna, “Aukna tamuŋna Aetta ma warɨŋap, na reikca ma ndo ŋgoinna an warɨŋa mutoc ŋgocortan, ma minmo mina mɨnɨŋna kacrirap tarkinandet. ");
INSERT INTO gai_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Na ne minmo ndarekrekke, mina kabena meikramtaɨrmo taup wandacna morenan, na mina ande lamnik pupuroikta ramtaɨrta kirar toc. Na lamnɨac pupurocna ramoot ianna, ianmo aŋgɨca taŋ te, maniŋa muruŋniŋa aoclataca iriknandet.” ");
INSERT INTO gai_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ri, Pita manmo aindopatna, “U aimo gan kam roorna mɨnɨŋa, u an meikramtaɨrmo kerinanna, u aimo mbop te, aia waracna.” ");
INSERT INTO gai_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Na ma minmo aindopatna, “Kaina moca ne toca anna mɨnɨŋa mba garacri? ");
INSERT INTO gai_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Na ne mba lamŋica rapacreke, a? Kaina reaca ma up ndiŋa mbukrenanna, ma loap kurica mac nda larurena. ");
INSERT INTO gai_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Na reaca nikinik iro mbuŋa up ndiŋa larurenanna, anna ande an reaca ramootmo moca ma rat ŋgocor. ");
INSERT INTO gai_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Aintik aku mboprenanna, anna an reikca ramootna iro inik mbuŋ ndarurena. Na an reikca gade, kabena meikramtaɨrmo iro ŋgoreacap, na ramootta mo menacrenan, na laŋtaŋgoara, meacramootna kaŋtertaapna tɨp kirara morenan, na tɨpemb ŋgadudukca morena meikramtaɨrta tɨpemb kirarira damar ŋgorik koinda morenan, na macmakɨmapa ritri waparacmo moca paparuna kam ndoprenanapa, kabena meikramtaɨrmo peperena kamb ŋgorik toprena tɨpembta kirarirap. ");
INSERT INTO gai_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ande an reikca ramootmo Raraŋ Aetaniacna lamnɨaca moca ma rat ŋgocor. Na ramootta amna reaca amna mo te, na ma ndona parmo tuki ŋgocor, an tɨpna kirara mamo mba moca ma Raraŋ Aetaniacna lamnɨacmo mba moi ratitndai.” ");
INSERT INTO gai_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Karica Iesusa an auŋ tɨkcarica ma Tairapa Saidon auŋ aniacniŋna waŋ mataŋgat. ");
INSERT INTO gai_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Na Kenan pitrik waŋna meac ianna ma an ndeacrenanna, ma kɨpca kam keca aca mamo gaindopatna, “Kacoot, u Dewitna ŋgamaɨr, u aukna moca kadmaia otac, ŋeroŋ ŋgoreaca aukna mooŋmo, moa ŋgocrairena.” ");
INSERT INTO gai_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ri, ma mana kam ianna mba rutiri, na mana iŋa raŋgairena ramtaɨra kɨpca manmo gaindopatna, “Gan meaca aimo acrenanna, ma aina iŋmbai nakɨprenan, u mamo mandaca ma taŋ.” ");
INSERT INTO gai_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Karica ma mina kammo rutica gaindopatna, “Raraŋ Aetaniaca aukmo Israelna meikramtaɨr tiŋgik ŋgotacna mandaca aku kɨprina, mina an iŋgoroca eacrena sipsiparta kirar toc.” ");
INSERT INTO gai_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ri, an meaca kɨpca mana outta tutupniŋ rɨmbɨtca mamo aindopatna, “Kacoot, aukmo otac!” ");
INSERT INTO gai_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ainda moca ma mamo rutica aindoprina, “Mombonikta ambrena tapacmo aŋgɨca mina piriŋta outta keca, mina am te, anna laŋa wanaiŋ.” ");
INSERT INTO gai_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ri, an meaca rutica aindopatna, “Kacoot, anna gidik, an piriŋga mina ndorita aeterta ambrena barerta, amta reik tɨpembca wɨkɨn ŋgirikrenanna mina anmo ambrena.” ");
INSERT INTO gai_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ainda moca Iesusa an meaca mboprina kamma waraca ma rutica aindopatna, “Meacmbitac, una rɨtɨpaca ma aniac ŋgoin. Na u toŋgorena reaca unmo larunanna, ma larunande.” Ri, an kɨdrɨk ŋgoinna an meacna mooŋa laŋ mamoat. ");
INSERT INTO gai_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Karica Iesusa an pitrik waŋ tɨkcarica ma Galili mɨar roumb ndiŋa taŋga takur ian nagaca mambiracat. ");
INSERT INTO gai_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ri, meikramtaɨr wɨt aniac ŋgoinna man ndambuŋ makɨpat. Na mina an orapaɨr menacrinanapa lamnik ŋgoriknan, na par gegebar, na kamma mbop kocortanapa ainta kabena kirarirta roumbbebta meikramtaɨrmo, mina aŋgɨca taŋga mana orniŋ ndambuŋa tɨkri. Na ma minmo moa laiŋ mamori. ");
INSERT INTO gai_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Na meikramtaɨr an kamma mbop kocortanna, mboprina, na orapaɨr gegebara laiŋ mamori, na our ŋgorikca taŋrena, na lamnik ŋgorikca mac watrinan, ri, mina tamtam ndamŋirina. Na mina Israelnaŋgepta Raraŋ Aetaniacna imo aŋgɨca maŋgepri. ");
INSERT INTO gai_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Karica Iesusa ndona iŋa raŋgairena ramtaɨrmo aca kɨpca, ma minmo aindopatna, “Aku gan meikramtaɨrta moca kakadmai ŋgoin, mina aukap eaca taŋga rai mbonkacna mɨnna moca mina amta reikca mamairi. Na aku minmo mba mbagɨrica taŋitndai, moca mina taupca taŋca paŋan korereca mina wɨnaca irik nari.” ");
INSERT INTO gai_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ri, mana iŋa raŋgairena ramtaɨra mamo aindopatna, “Gan ramtaɨr kocorta taupmo aia tenna amna tapacar aŋgɨca gan ainta meikramtaɨrta tumbunna neaŋammit?” ");
INSERT INTO gai_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Karica ma minmo madigiat, “Ne tapacar titpaikap eacrena?” Na mina aindoprina, “Aia tapacar parmbaiapa mbut mbuniŋapa ŋgoaem teker mbatep eniŋap.” ");
INSERT INTO gai_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ainda moca ma meikramtaɨrmo mbopca, mina pitrik mambiracat. ");
INSERT INTO gai_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ri, ma an tapacar parmbaiapa mbut mbuniŋapa ŋgoaebmo aŋgɨca, ma Raraŋ Aetaniacmo kam laŋ neaŋca, ma witkica ndona iŋa raŋgairena ramtaɨr maneaŋgat. Na mina an meikramtaɨrmo mabiŋaiat. ");
INSERT INTO gai_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Na an meikramtaɨra amba taŋga mɨnna tɨkca, an amta reik tɨpembca eacri, mana iŋa raŋgairena ramtaɨra larkamb anik parmbaiapa mbut mbuniŋa ruatna. ");
INSERT INTO gai_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ri, an amta reikca ambatna ramtaɨrta ŋgaŋgangɨca 4,000na mɨn, na mina meikpitikapa mombonikca mba nduri. ");
INSERT INTO gai_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Karica ma an meikramtaɨrmo mbopca mina taŋgatke, ma kor naŋgabukca ma mon Magadana waŋ mataŋgat. ");
INSERT INTO gai_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Karica Parisiarapa Sadisiarna ramtaɨra Iesus ndambuŋ nakɨpca manmo towaina morina. Na mina manmo digica ma tamuŋna auŋna ŋgagatrac ianna mo te, mina lamŋinande, anna ma Raraŋ Aetaniacna aiŋa morena ramoot. ");
INSERT INTO gai_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ainda moca ma mina digdigimo rutica aindopatna, “Wigwaca ne aindopnande, ‘Riaca laupa mairikek, na mandeaca mouŋa laŋa monandet.’ ");
INSERT INTO gai_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Na ŋaŋarmuŋmbaia ne aindopnande, ‘Dimir mbɨkmbɨkarapa ra laup te, anna mandeaca pukapa watta kɨpnande.’ Na gidik ŋgoin, ne riacna ŋgagatraca ne watca mbopnandet, na gan mɨnna nena eteacna ŋgagatraca ne mba watta rapacri. ");
INSERT INTO gai_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Aintik gan mɨnna meikramtaɨra, mina meikramtaɨr ŋgorik koind, mina Raraŋ Aetaniacmo nikinik iro kabeapa wanaiŋ. Memetmbaca mina ŋgagatraca watna digirenan. Na mina ŋgagatrac ianna mba watitndai. Wanaiŋ ŋgoin. Mina watna ŋgagatrac kabea, anna ramma morina ramoot, Iounanan.” Karica ma min tɨkcarica mataŋgat. ");
INSERT INTO gai_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Karica Iesusapa mana iŋa raŋgairena ramtaɨra, mina mɨarmo waŋembaia taŋga gari, mana iŋa raŋgairena ramtaɨra gagamna tapac aŋgɨna ndarekrekeri. ");
INSERT INTO gai_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Na ma minmo aindopatna, “Ne Sadisiapa Parisina isna moca, ne ndoritake, matau wat.” ");
INSERT INTO gai_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ainda moca mina an kamna moca ndori puŋga kamb topri, mina gaindopatna, “Aia gagamna tapaca aŋgɨ kɨp ŋgocor tik, ma aimo an kam ndopapekna.” ");
INSERT INTO gai_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ri, ma mina mbopatna kamma ma malamŋiat, ma mimo gaindopatna, “Ne rɨtɨpaik tekirta ramtaɨr, kaina moca ne ndorita rɨkmo aindoprina, ‘Aia tapacar kocor?’ ");
INSERT INTO gai_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Na ne mba lamŋireke, a? An tapacar parmbaia, aku ramtaɨra 5,000na mɨnna neaŋga ambrinanna, na larkam titpaikca ne rurina? ");
INSERT INTO gai_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Na an tapacar parmbaiapa mbut mbuniŋa ramtaɨra, 4,000na mɨnna an ambrinanna, na larkamb anik titpaikca ne rurinanna, ne mba lamŋireke, a? ");
INSERT INTO gai_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Na tida moca ne lamŋi ŋgocor? Aku nemo tapacar tɨpembta kamma mba mbopreke, aku nemo aindoprena. Ne Parisiarapa Sadisiarta isnake, ne ndorimo matau wat.” ");
INSERT INTO gai_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ainda moca mina an kamma waraca, mina lamŋia marapacat, ma mimo an tapaca morena isna kamma mba mbopri. Wanaiŋ. Ma minmo an Parisiarapa Sadisiarta riptirena kamna kam ndoprena. ");
INSERT INTO gai_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Karica Iesusa Sisariapilipaina auŋ tekerna pitrik waŋa mbukna taŋre mbuŋa ma ndona iŋa raŋgairena ramtaɨrmo gainda digirina, “Mandaimo, meikramtaɨra Ramootna Nuoc ndoprena?” ");
INSERT INTO gai_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ri, mina mamo rutica gaindopatna, “Ndeida gaindoprena, kɨtac puk neaŋrena ramoot Ion, na ndeida gaindoprena Elaia, ri, ndeida gaindoprena Ieremaia, co Raraŋ Aetaniacna ramma morena ramoot ian.” ");
INSERT INTO gai_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Karica ma minmo madigiat, “Na nen ŋgoinna, aukmo mandai ŋgacit?” ");
INSERT INTO gai_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ri, Saimon Pita rutica manmo aindopatna, “U an ramootta Raraŋ Aetaniac babuca mbagɨrica kɨpca aimo mac nda aŋgɨna ramoot, u iarwarna eteacna watapna Raraŋ Aetaniacna Nuoc.” ");
INSERT INTO gai_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ainda mori, ma rutica aindoprina, “Saimon, Ionna nuoc, u toŋgo, gan tiacarpaikna ramoot ianna umo gan kamma wandac ŋgocor, wanaiŋ, anna aukna Aet, ma tamuŋna auŋ ndeacrenanna, ma ndo unmo wandacrina. ");
INSERT INTO gai_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Karica ma aindopatna, aku umo aindopnande, u Pita, una ia waut, na aku ndona rɨtɨpacna meikramtaɨrta tumbunmo an waut nambatta monande. Na memenacna gargara anna mba mac moi irikitndai. ");
INSERT INTO gai_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Na aku umo aindopnande, tamuŋna auŋna bubuocna tɨŋ gootna reikca, aku umo neaŋnandet. Na kaina tɨŋa u gan tiacarpaikca kaptikica leaca eacrenan, Raraŋ Aetaniac, ma toco tamuŋna auŋna tɨŋmo kaptikica leacnande. Na kaina tɨŋa u gan tiacarpaikca gootca eacrenanna. Raraŋ Aetaniac toco tamuŋna auŋna tɨŋmo ma gootnandet.” ");
INSERT INTO gai_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ainda moatke, ma ndona iŋa raŋgairena ramtaɨrmo kɨraca, mina kabena meikramtaɨrmo gainda kai mbop teac, ma Raraŋ Aetaniaca babuca mbagɨrica kɨpca aimo mac nda aŋgɨna ramoot. ");
INSERT INTO gai_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Karica an mɨn mbuŋa Iesusa ndona iŋa raŋgairena ramtaɨrmo, ma ndo Ierusalemma taŋna kam landamŋi mambopri. Ma minmo mbopca waraca ma taŋi anna tɨk te, ramtaɨr paŋaindapa, taup ndamtaɨr paŋaindapa, tɨpemb wandik tamŋirena ramtaɨra, mina mamo gɨrgɨr neaŋca manmo mo menacnandet, na ra mbonkacnan mbuŋa ma mac nda ŋgepnande. ");
INSERT INTO gai_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ri, Pita an kam mbaraca, manmo aŋgɨca roumbmbaia taŋga manmo kaega moca gaindopatna, “Kacoot wanaiŋ ŋgoin. Gan reaca unmo mba laruitndai!” ");
INSERT INTO gai_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ainda moca ma repakeca Pitamo aindopatna, “Ramoot Mbɨk u aukna iŋmbaia taŋ, u aukna taup mboracrena, u Raraŋ Aetaniacna iroa mba raŋgairenan, wanaiŋ, u ramootna iroa raŋgairena.” ");
INSERT INTO gai_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Karica ma ndona iŋa raŋgairena ramtaɨrmo gaindoprina, “Ramootta aukmo raŋgaina ndop te, ma ndona toŋtoŋa kɨtac irikca ma ndona kekeracna ik aŋgɨca aukna iŋa raŋgai. ");
INSERT INTO gai_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Na ramootta ndona eteacna wat aŋgɨna moca gagra te, ma ndona an eteacna watta kecarinande. Na ramootta aukna moca lamŋi te, na ma ndona eteacna wat kecari te, an ramoot ma ndona eteacna watta aŋgɨnande. ");
INSERT INTO gai_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Na ramootta gan tiacarpaikna reikca kocnai aŋgɨ te, na mana eteacna watta mai te, an reikca muruŋa manmo titoc ŋgotacit? Na an ramootta ma titocna opoik mbuŋa ndona iarwarna eteacna watta mac nda oikit. ");
INSERT INTO gai_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ainda moca Ramootna Nuoca ma ndona Aetna memetacna tac aniacap kɨp te, mana mbaiŋna aiŋa morena ŋerŋgaura manap kɨpnandet. Te, an kɨdrɨkca ma meikramtaɨrmo mina morina kirarir laiŋta opoikca raŋgaica aŋgɨ neaŋnande. ");
INSERT INTO gai_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Na aku nemo gidik ŋgoinna aindopnande, nena ndeida ganna wɨtɨkca eacrenanna mina menac ŋgocora, mina watnande, Ramootna Nuoca ma gagrirta ramoot paŋan toc nakɨpnande.” ");
INSERT INTO gai_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Na rai parmbaiapa mbut kabe maiatke, Iesusa Pitaapa Sebedina nuocniŋ Iemisapa Ionmo aŋgɨca, mina muruŋa ndori tiŋgikca takur aniac ianna tamuŋ ŋgoin magat. ");
INSERT INTO gai_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Na mina watrenan mbuŋa, mana tikca ŋgetrikica, aintocna wapat ian malaruat. Na mana inpaŋanna rana memetac toca metacri, na mana tik ŋgapaoca memetac gogok toca metacri. ");
INSERT INTO gai_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Na Mosesapa Elaia min ndambuŋa anduna laruca Iesusap mambopri. ");
INSERT INTO gai_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ainda moca Pita anna watca, ma manmo aindopatna, “Kacoot, laŋa moca aia ganna eacrenan, na u toŋgo te, aku nenmo ndamb mbonkaca mona, ianna unan, na ianna Mosesnan, na ianna Elaianan.” ");
INSERT INTO gai_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Na Pita, an kam ndopre mbuŋa dimir ndepikca memetacap mimo wɨŋga kɨtaca, kam ianna anna inikca gaindoprina, “Ganna aukna Nuoc, aku manmo matŋirena, na aku mamo toŋtoŋ ŋgoin. Ne mana kam mbarac.” ");
INSERT INTO gai_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Aindopatke, mina an kam mbaraca mina rugdar moca nanambica, tutpemb rɨmbɨtca pitrik mairikat. ");
INSERT INTO gai_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ri, Iesusa min ndambuŋ nakɨpca, minmo utiŋa aindopatna, “Ne ŋgep, ne kai nanambi teac.” ");
INSERT INTO gai_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ainda moca mina tamuŋa rai watta gari, mina ramoot ianna mba mac watri, man niŋgikca ndo eacrina. ");
INSERT INTO gai_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ri, mina takur tamuŋ ŋgetacndiŋ mac nda irikatke, ma minmo kam gargar mbuŋa gaindopatna, “An reaca ne wattapeknanna, ne ramoot ianmo kai nini teac, taŋca Ramootna Nuoca muk ndiŋa mac nda ŋgep te.” ");
INSERT INTO gai_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Karica mana an iŋa raŋgairena ramtaɨr mbonkaca mamo gainda digirina, “Kaina moca tɨpemb wandik tamŋirena ramtaɨra gaindoprena, Elaia ma outmbaica kɨpnandet?” ");
INSERT INTO gai_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ri, ma mina kammo rutica aindopatna, “An kamma anna gidik, Elaia ma kɨpca reikmo mo laŋa monande. ");
INSERT INTO gai_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Aintik aku nemo gaindopnande, Elaia ma kɨprinanna, na meikramtaɨra mamo mba watta lamŋiri, wanaiŋ, mina ndorita toŋtoŋgara raŋgaica mina manmo kaina reaca monanna, mina mo niŋgik. Na an tɨpna kirar ŋgoinna, mina Ramootna Nuocmo ainda moca ma gɨrgɨr aŋgɨnandet.” ");
INSERT INTO gai_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Na ma aindopatke, mina malamŋiat, ma kɨtac puk neaŋrena ramoot Ionna kam ndoprina. ");
INSERT INTO gai_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Karica Iesusapa mana iŋa raŋgairena ramtaɨr mbonkaca takur tɨkcarica irikca kɨpca, meikramtaɨr wɨt aniac ndambuŋ ndarurinan. Ri, ramoot ianna Iesus ndambuŋ nakɨpca tutupniŋ rɨmbɨtca mamo gaindopatna, ");
INSERT INTO gai_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Kacoot, u aukna nuocmo kadmaia otac, ma paŋan ŋaŋaona roumbap tik, mana tikca ŋgoreac ŋgoin ndeacrena. Na ma memetmbaca tac inikca irikrenan, na memetmbaca pukca pukrenan. ");
INSERT INTO gai_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Na aku manmo una iŋa raŋgairena ramtaɨr tambuŋ naaŋgɨca taŋri, na mina manmo mo laŋa mona mɨnna wanaiŋ.” ");
INSERT INTO gai_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Karica ma mana kammo rutica aindoprina, “Ne rɨtɨpaik kocorta meikramtaɨrta tumbun, nena iroarapa nena tɨpemb kirarira wandoik laiŋga wanaiŋ, ŋgadudukar koind. Na aku nenap eaca maŋateri. Na nena makukar toco mbukna ŋaterena. Aukmo an mooŋnuocmo gan naaŋgɨca kɨp.” ");
INSERT INTO gai_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ri, ma an ŋeroŋ ŋgoreacmo kaega moca, an ŋeroŋ ŋgoreaca an nuoc tɨkcarica, ma anduna laŋ mamori. ");
INSERT INTO gai_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Karica iŋmbaia mana iŋa raŋgairena ramtaɨr tiŋgikca kɨpca mamo aind mac digiatna, “Tida moca aia an ŋeroŋ ŋgoreacmo, mo kecarina mɨnna wanaiŋ.” ");
INSERT INTO gai_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Ri, ma mimo aindoprina, “Nena rɨtɨpaikca tekir koind, aintik ne toawanaiŋ. Na aku nemo gidik ŋgoinna aindopnande, nena rɨtɨpaikca an mastet ikna lour tekirnoikta kirar te, ne gan takurmo mbopna mɨn, ‘U ŋgepca mona taŋ.’ Te, ma taŋnande. Na nemo reac ianna mba kɨracitndai, aiŋira ne mo niŋgik.” ");
INSERT INTO gai_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Karica Iesusapa mana iŋa raŋgairena ramtaɨra muruŋa Galilina pitrik waŋa tumbunna tɨkca eacri, ma mimo aindopatna, “Mina Ramootna Nuocmo, ramtaɨrta para tɨknandet. ");
INSERT INTO gai_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Te, mina manmo mo menacnande, na rai mbonkac mbuŋa, ma mac nda ŋgepnande.” Ri, mana iŋa raŋgairena ramtaɨra an kamma waraca mina kakadmai ŋgoin. ");
INSERT INTO gai_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Na iŋmbaia Iesusapa mana iŋa raŋgairena ramtaɨra, Kapaneam auŋa taŋga laruri, Raraŋ Aetaniacna Kacna kitcartukar iurena ramtaɨra kɨpca Pitamo gainda digirina, “Nena ririptia ma Raraŋ Aetaniacna Kacmo ma kitukndukar neaŋre ki wanaiŋ?” ");
INSERT INTO gai_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ri, ma rutica aindopatna, “Ore, ma neaŋrena.” Na ma kac inikca mbukatke, ma kam ianna mbop ŋgocor, ri, Iesusa manmo gaind mac madigiat, “Saimon, gan tiacarpaikna gagrirta ramtaɨr paŋainda, mina kitukndukarmo mandaibin ndambuŋnan iurena? Mina ndorita barna meikramtaɨr, co, kabena barna meikramtaɨrtan, na u tit ndamŋirena?” ");
INSERT INTO gai_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Karica Pita rutica aindopatna, “Kabena barna meikramtaɨrtan.” Ri, ma manmo aindopatna, “Ainda mo te, mina ndorita barna meikramtaɨrta kitcartukara mba neaŋrena. ");
INSERT INTO gai_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Na moca aia minmo, moi mina aimo kaega mo nari. Aintik u taŋca mɨarmo kaɨr ke. Na u out ŋgoinna wɨŋgekna ŋgoaemmo, u mana up gootca u watnande, anna ma kitukndukap. Te, u an kitukndukmo aŋgɨca minmo neaŋ, anna ma aŋna kitukndukna opoikna mɨn.” ");
INSERT INTO gai_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Karica an mɨnna Iesusna iŋa raŋgairena ramtaɨra man ndambuŋa kɨpca mamo aindopatna, “Mandai ŋgoinna tamuŋna auŋna bubuocmo i aniacap?” ");
INSERT INTO gai_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ainda moca ma mooŋnuoc teker ianmo aca kɨpca, mina rɨkca aŋgɨa wɨtɨkri. ");
INSERT INTO gai_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Na ma minmo aindopatna, “Aku nemo gidik ŋgoinna aindopnandet, ne iroar ŋgetrikica, mombonik tekir toc ndaru ŋgocor te, ne tamuŋna auŋna bubuoca mba mbukitndai. ");
INSERT INTO gai_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Na ramootta ndomo aŋgɨ irikca pɨkɨnna tɨk te, gan mooŋnuoc teker toc, an ramoot, ma tamuŋna auŋna bubuocmo i aniacap. ");
INSERT INTO gai_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Na ramootta auk ndamŋica gaind tocna mooŋnuoc teker otac te, ma aukmo maotacri.” ");
INSERT INTO gai_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Karica Iesusa gaind mac mboprina, “Ramoot ianna gan mombonikca aukca rɨpacrenanna, ianmo moca mana rɨtɨpaca irik te, anna laŋ watcarica mina waut makuk bagaraniac ian aŋgɨca mana logotta leaca, manmo aŋgɨca taŋca macait rɨk nake pukca ma menacna. ");
INSERT INTO gai_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Na gan tiacarpaikna meikramtaɨrpembta kadmai, mina makukara aŋgɨnandet, mina kabena meikramtaɨrmo, moca mina tɨpemb ŋgorikta makukarta ŋgirikrena. Na an tɨp ŋgoreaca gidikca ma larunande. Na an ramootta an tɨp ŋgoreacna makukca mo te, ma makukca aŋgɨnandet. ");
INSERT INTO gai_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Na una par, co ora umo tɨp ŋgoreacna makukca mo te, u anmo kataca kecari. Te, u par kabe, co or kabe mbuŋa iarwarna eteacna wat aŋgɨ, anna laŋ. Moca u par mbuniŋ, co or mbuniŋapa mina umo iarwarna tac inikca ke mbuknande. ");
INSERT INTO gai_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Na una lamnɨaca umo tɨp ŋgoreacna makukca wɨŋna mo te, u manmo tarkica kecari. Te, u lamnɨac kabe mbuŋa iarwarna eteacna wat aŋgɨ, anna laŋ. Moca u lamnɨac mbuniŋapa mina umo menac ŋgocorta iarwara wɨrrena tac nake mbuknande. ");
INSERT INTO gai_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","“Na ne ndoritake, matau wat. Moca ne gaind ndamŋi nari, gan mombonikta rɨkna ianna ma reac wanaiŋ. Na aku nemo aindopnande, mina Raraŋ Aetaniacna mbaiŋna aiŋa morena ŋerŋgaura memetmbaca aukna Aetna lamnɨac outta eacrena, mon tamuŋna auŋ.” ");
INSERT INTO gai_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Karica Iesusa gaind mac mbopatna, “Ne tit ndamŋirena? Ramoot ianna ma 100na mɨnna sipsiparap, na mana ianna iŋgoroc te, ma tida moit? Ma an 99na mɨnna sipsiparmo takura tɨkcarica ma taŋca an iŋgorocrinanna orenande. ");
INSERT INTO gai_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Na aku nemo gidik ŋgoinna gaindopnande, ma an iŋgorocrina sipsipa ore wat te, ma toŋtoŋ ŋgoin. Na an 99na mɨnna sipsipara ma min motocmo toŋtoŋgarap, na an iŋgorocrina kabemo mana toŋtoŋa, minmo tamuŋmbai ŋgoin. ");
INSERT INTO gai_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Aintik an tɨpna kirara nena tamuŋna auŋna Aetta, ma mba toŋgorenan, an mombonik tekirta ianna kai iŋgoroc teac.” ");
INSERT INTO gai_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Karica Iesusa gaind mac mbopatna, “Na una laiplacarta ianna, umo tɨp ŋgoreacna makuk ianna umo mo te, u taŋca mamo an tɨp ŋgoreacna makukca ma mocapeknanmo u mamo mbop waraca oŋgo ndoniŋ niŋgikca eac te. Na ma una kamma warac te, u mamo mac nda aŋgɨrnandet. ");
INSERT INTO gai_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Na ma una kamma warac ŋgocor te, u ramoot kabe, co, mbuniŋ aŋgɨca unapa taŋ, na u ainda mo te, an ramtaɨra una kammo moca gagranande. ");
INSERT INTO gai_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Na ma una kamma warac ŋgocor te, u Raraŋ Aetaniacna rɨpacrena meikramtaɨrta tumbunna meikramtaɨrap mbop. Na ma mina kamma waracna ŋate te, ne mamo watcarica, ma Iudana ramoot wanaiŋna kirar, co, kitcartukar iurena ramootna kirar toc ndeacraŋ. ");
INSERT INTO gai_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Na aku nemo gidik ŋgoinna aindopnande, ‘Kainta reikca ne gan tiacarpaikca leacrenanna, Raraŋ Aetaniaca ma tamuŋna auŋ toco ma leacnande. Na kainta reikca ne gan tiacarpaikca tɨkcaririnanna, Raraŋ Aetaniaca ma tamuŋna auŋ toco tɨkcarinandet.’ ");
INSERT INTO gai_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Na aku gaind mac mambopek, gan tiacarpaikna meikramtaɨr, nena mbuniŋa, iro kabea tɨk te, Raraŋ Aetaniacmo mbendeica reac ian aŋgɨna digi te, aukna tamuŋna auŋna Aetta ma maniŋmo neaŋnande. ");
INSERT INTO gai_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ainda moca meacramoot mbuniŋ, co mbonkaca aukna ina moca, kɨpca tumbunna tɨk te, aku ande, mina rɨk ndeacnande.” ");
INSERT INTO gai_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Karica Pita, Iesus ndambuŋa kɨpca mamo gainda digiatna, “Kacoot, kɨdrɨkar titpaik ŋgoinna aukna kaka aukmo tɨp ŋgoreacna makukca mo te, aku mana tɨpemb ŋgorikta makukarmo mo kecarit? Taŋca par kabeapa mbuniŋna mɨn ki?” ");
INSERT INTO gai_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ri, ma mana kamma rutica aindopatna, “Aku umo aindopnande, par kabeapa mbuniŋna mɨnna wanaiŋ, 77na mɨnna u mana tɨpemb ŋgorikmo mo kecari. ");
INSERT INTO gai_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Na ne warac, tamuŋna auŋna bubuoca ma gagrirta ramoot paŋan ianna kirar, ma toŋgorinanna mana mbaiŋna ramtaɨrmo mana kitukndukca mina digica aŋgɨatnanmo, mac nda rutina. ");
INSERT INTO gai_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ainda moca an gagrirta ramoot paŋanna ndona reikca mana aiŋa morena ramtaɨra digica aŋgɨrinanmo, mac nda rutina aiŋa mo ŋgeprinan. Ri, mina ramoot ianna manmo 10,000,000na mɨnna kitcartukara ma manmo digica aŋgɨatnanmo, mina manmo aŋgɨca makɨpat. ");
INSERT INTO gai_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ri, an ramootta ma ainta kituknduk ŋgocor, aintik mana gagrirta ramoot paŋanna mbopca mina manapa, mana meacapa mombonikapa, mana reikca mina aŋgɨca mbik ŋgoikrena taupca tɨkca mina oik te, an kituknduk aŋgɨca auknanmo rutinandet. ");
INSERT INTO gai_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Aindopatke, an mbaiŋna ramootta, mana outta irikca, ae maŋmaŋapa aindoprina, u aukmo kadmaica lambi te, aku una aŋgɨrina kitukndukarmo rutinande. ");
INSERT INTO gai_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ri, mana gagrirta ramoot paŋanna mana moca kadmaica, manmo watcarica, mana aŋgɨrina kituknduk toco, mbopca ma mba rutiri. ");
INSERT INTO gai_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Karica ma laruca taŋgatke, ma watrinanna, mana aiŋ kabena ramoot ianna mamo kitukndukca gagar kabena mɨn niŋgikca ma manmo ŋgaua digirenanna anna eacre. Ri, ma ndona aiŋ kabena ramootmo utiŋa mana logot mɨnpaca aindopatna, ‘U aukna aŋgɨrina kitukndukca muruŋa neaŋ.’ ");
INSERT INTO gai_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Ri, mana aiŋ kabena ramootta, mana out ŋgirikca aemaŋmaŋap mamo gaindoprina, u aukna kadmaica pac lambi, te, aku una aŋgɨrina kitukndukca nda rutinande. ");
INSERT INTO gai_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Na ma mba toŋgori, ma an mana aiŋ kabena ramootmo aŋgɨca taŋca kac ŋgoreaca tɨkca ma an ndeaca taŋca mana kituknduk rutina. ");
INSERT INTO gai_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Ri, mana aiŋ kabena ramtaɨra an tɨp kirara ma mocapeknanna watca, mina iroar inkara mamo mba toŋgori. Na mina taŋga mina gagrirta ramoot paŋanmo, an mina aiŋ kabena ramoot mocapekna kirarirta reikta kamb mambopat. ");
INSERT INTO gai_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ainda moca gagrirta ramoot paŋanna an mbaiŋna aiŋa morena ramootmo aca kɨpca mamo aindoprina, u mbaiŋna aiŋa morena ramoot ŋgoreac. U ŋgaua aeri aku una aŋgɨrina reikca, umo rutina mba mbopri. ");
INSERT INTO gai_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Na aku unmo kakadmaina opotaca morinan, na kaina moca u ndona aiŋ kabena ramootmo kadmaina opotaca mo ŋgocor? ");
INSERT INTO gai_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Karica mana gagrirta ramoot paŋanna nikkatca, mamo aŋgɨca kac ŋgoreaca tɨkca, ma an ndeaca gɨrgɨr aŋgɨ te, ma mana kitukndukca muruŋa nda rutinandet. ");
INSERT INTO gai_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“An kirar niŋgik mbuŋa aukna Aetta tamuŋna auŋ ndeacrenan, ma nenmo an tɨpna kirar kabea monande, na nena laiplacara nenmo makukar neaŋca ne mina an makukarmo gidikca mo kecari ŋgocor ndacari te, ma nenmo an tɨpna kirar kabea monande.” ");
INSERT INTO gai_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Karica Iesusa an kambca mbopa maica, ma Galilina pitrik waŋ tɨkcarica ma mon Iudiana pitrik waŋa oc Iodanmo monmbai waŋ mataŋgat. ");
INSERT INTO gai_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ri, meikramtaɨr wɨt aniaca manmo maraŋgaiat, ma anna tɨkca mina roumbbeb ŋgorikca moa laiŋ mamori. ");
INSERT INTO gai_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ainda mori, Parisina ramtaɨr ndeida kɨpca mamo towaina mori, mina mamo gainda digirina, “Ramootta ndona meac laŋtaŋgomo ndona toŋtoŋ mbuŋa oot mandac te, an tɨp kirara anna laŋ ki, wanaiŋ?” ");
INSERT INTO gai_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ri, ma mina kammo rutica aindopatna, “Ne Raraŋ Aetaniacna timbigta kapna kamma ne mba watri ki? An kamma ma aindoprina, ‘Gan tiacarpaikca Raraŋ Aetaniaca mandeba reikca mori, ma meacapa ramootta morina. ");
INSERT INTO gai_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Aintik Raraŋ Aetaniaca ma aindoprina, “Ramootta ndona aemmapa aetmo tɨkcarica ma taŋca ndona meacap eac te, maniŋa tik kabe mamori.”’ ");
INSERT INTO gai_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Aintik mandeaca maniŋa damniŋa wanaiŋ, maniŋa kabe. Ainda moca kaina reaca Raraŋ Aetaniaca aŋgɨca tumbunna tɨkrinan, ramootta kai titac teac.” ");
INSERT INTO gai_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ri, an Parisina ramtaɨra mamo aindoprinan, “Na kaina moca Mosesa aimo gan tɨp wandɨkca neaŋga aindopatna, ramootta timbiŋ rapara moca ndona meaca neaŋga laŋtaŋgo kataca, watcarica ma taŋ?” ");
INSERT INTO gai_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ri, ma mimo gaindoprina, “Ne kamma warac ŋgocorta paŋaind garurar, aintik Mosesa nemo watcaria, nena meikmo ne ootta mandacrena. Na ŋgaua ŋgoinna ainta tɨpna kirara kamaind. ");
INSERT INTO gai_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Na aku nemo gaindopnande, ramoot ianna meaca ma meacramootna kaŋtertaapna tɨp kirara mo ŋgocor, na mana kaŋgaitta manmo laŋtaŋgo katac te, na ma kabena meac laŋgo te, an ramootta ma tɨp ŋgadudukca morena tɨp kirara moapekna.” ");
INSERT INTO gai_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ainda moca mana iŋa raŋgairena ramtaɨra, an kamma waraca, mina mamo aindopatna, “Na ramtaɨrta meikca meacramootna kaŋtertaapna tɨp kirara mo ŋgocor te, mina minmo wanaiŋa kai oot mandac teac. Na ramtaɨra an tɨpna kirara raŋgai te, anna laŋ, mina kai laŋgo teac.” ");
INSERT INTO gai_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Karica ma mimo aindoprina, “Ramtaɨr wɨtta an riptirina kamma aŋgɨna mɨnna wanaiŋ. Raraŋ Aetaniaca ma ramtaɨr ndeidmo gagrara min tiŋgikca neaŋrina. ");
INSERT INTO gai_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Na ne warac, ramtaɨr ndeida eacrenan, mina mba laŋgoitndai, mina ndeida mina aemera mɨrca mina mombonikca mo laruna towanaiŋ, na ndeida mina utniŋ waiŋtoca mina mombonikca mo laruna towanaiŋ. Na ndeida tamuŋna auŋna aiŋa moca mina ndorimo wandɨk tɨkca mina mba laŋgori. Aintik mandaia an ririptina kam aŋgɨna mɨn, anna laŋ, ma aŋgɨ niŋgik.” ");
INSERT INTO gai_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Karica an kɨdrɨkca meikramtaɨra Iesusmo mombonik tekir aŋgɨca makɨpri, na mina toŋgorinanna, ma minmo ndona parmo min nambatta tɨkca minmo mbendeina. Na mana iŋa raŋgairena ramtaɨra, minmo kaega moca mboprina. ");
INSERT INTO gai_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ri, ma ndona iŋa raŋgairena ramtaɨrmo aindopatna, “Ne an mombonikmo watcarica mina auk ndambuŋ nakɨp, na ne minmo kai kɨrac teac, aintocna meikramtaɨra mina mombonik tekir toc taru te, tamuŋna auŋna bubuoca anna minan.” ");
INSERT INTO gai_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Karica ma an mombonikmo ndona para tɨkca, iŋmbai ma an taup tɨkcarica mataŋgat. ");
INSERT INTO gai_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Karica ramoot ianna Iesus ndambuŋa kɨpca aindopatna, “Riripti, aku titocna tɨp laŋa mo te, aku iarwarna eteacna wat laŋ aŋgɨit?” ");
INSERT INTO gai_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ri, ma mamo rutica aindopatna, “Kaina moca, u aukmo tɨp laŋna digirena? Raraŋ Aetaniac niŋgik, ma ndo laŋ. Na u iarwar ndeteacna wat aŋgɨna toŋgo te, u Tɨpemb Wandikca raŋgai.” ");
INSERT INTO gai_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Aindopatke, ma mana kammo rutica madigiat, “U titocna Tɨpemb Wandikta kambta digirena?” Ri, ma manmo rutica aindopatna, “An Tɨpemb Wandikca, gan kambap eacrenan, ‘Ne kabena meacramootmo kai, mo menac teac, na laŋtaŋgoita meikramtaɨra mina tɨpemb ŋgadudukca morena meikramtaɨrta tɨpemb kirarira kai mo teac, na ne kai makɨm teac, na ne kabena meacramootmo ritri waparaca moca paparuna kam mbuŋa kai paru teac. ");
INSERT INTO gai_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Te, ne ndorita aemeraeterta kaŋgauk ndeacraŋ, na mina kamb mbaracraŋ, na nena ŋembmo, ne minmo matau matŋiraŋ, an tɨpna kirara u ndo ŋgoinna matŋirena kirar.’” ");
INSERT INTO gai_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ri, an ramoot ŋgamma mamo aindopatna, “An reikca aku raŋgairena. Na kaina reaca aku mba aŋgɨri?” ");
INSERT INTO gai_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Karica ma mamo aindopatna, “U ramoot wandoŋ laŋ ŋgoinna eacna mo te, u taŋca una reik laiŋmo mbik tɨkca oikrena taupca tɨkca mina oik te, u an kitukndukmo aŋgɨca reik kocorta meikramtaɨr ndaekpembmo biŋai. Na u ainda mo te, u tamuŋna auŋna reik laiŋ koindap eacnandet. Te, u kɨpca aukmo raŋgai.” ");
INSERT INTO gai_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ri, an laimnembta ramootta an kamma waraca mana iro inikca makuk ŋgoin tɨk, ma mataŋgat. Ma ndona laimnembta moca. ");
INSERT INTO gai_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Karica ma ndona iŋa raŋgairena ramtaɨrmo aindopatna, “Aku nemo gidik ŋgoinna aindopnandet, an laimnembta ramtaɨra mina tamuŋna auŋna bubuoca mbumbukca owai ŋgoin. ");
INSERT INTO gai_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Na aku nemo mac mambopek, kamela reik iukrena lacna urupa mbumbukca anna wetwet ŋgoin, na laimnembta ramootta Raraŋ Aetaniacna bubuocna kaŋgaukca mbukna owai ŋgoin.” ");
INSERT INTO gai_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ri, mana iŋa raŋgairena ramtaɨra an kamma waraca mina ŋgep ŋgoreac naŋgepri. Na mina aindopatna, “Na aintan te, mandaia ndo iarwar ndeteacna wat aŋgɨit?” ");
INSERT INTO gai_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ainda moatke, ma minmo watta gagraca, gaindopatna, “Meikramtaɨr toca toawanaiŋ, Raraŋ Aetaniac, ma ndo niŋgikca reikca mona mɨn.” ");
INSERT INTO gai_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Na ma aindopatke, Pita mana kammo rutica aindoprina, “U warac, aia ndorita reik tɨkcarica una iŋa raŋgairena. Na aia kaina reac ŋgoinna aŋgɨit.” ");
INSERT INTO gai_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Karica ma minmo aindopatna, “Aku nemo gidik ŋgoinna aindopnande, an mɨnna reikca ŋgaib mac laru te, Ramootna Nuoca ma i aniacap, na ma ndona gagrirta taupca mbirac te, an mɨnna ne an ramtaɨra aukna iŋa raŋgairenanna, ne toca an parniŋapa mbut mbuniŋna mbibiracrena taupca mbiraca, ne an parniŋapa mbut mbuniŋna Israelna wiwitna barerta ramtaɨr paŋaind ndarunandet. ");
INSERT INTO gai_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Na meikramtaɨra muruŋa aukna ina moca ndorita kaik barer, co ndorita mbiar, co ndorita laiplacar, co aeter, co ndorita amer, co ndorita mombonik, co mina warɨŋemb tɨkcari te, ma mina reikmo 100na mɨnna an nambat mac tɨknandet. Na mina iarwarna eteacna wat laŋa aŋgɨnandet. ");
INSERT INTO gai_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Na mandeaca meikramtaɨr wɨtta out ŋgoinna eacrenanna, mina iŋ ŋgoinna taŋca eacnandet, na iŋ ŋgoinnanna, mina taŋca out ŋgoinna eacnandet.” ");
INSERT INTO gai_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Karica Iesusa gaind mac mbopatna, “Aku kam roor ian makecek. Tamuŋna auŋna bubuoca ma wain warɨŋapna ramoot ian toc. Na ŋaŋarmuŋ ŋgoinna, an ramootta, ma taŋga ndona wain warɨŋna aiŋa mona ramtaɨrta korena taŋrina. ");
INSERT INTO gai_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ainda moca ma minap kam leaca, mina ra kabena aiŋa mo te, ma minmo ruar kabena kitukndukna mɨn mbuŋa oiknande. Ri, ma mimo mbagɨrica mina mana wain warɨŋna aiŋa mona mataŋgat. ");
INSERT INTO gai_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Karica rana ŋgaŋganŋgɨa 9na mɨn toca tɨkri, ma mac taŋga mina punirena taupca watri, ramtaɨr ndeida anna wɨtɨkca, wanaiŋa eacrenan. ");
INSERT INTO gai_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ri, ma minmo gaindopatna, ‘Ne toco, taŋca aukna wain warɨŋna aiŋa mo te, aku nena aiŋa morena mɨnna kitukndukna mɨnna oiknande.’ ");
INSERT INTO gai_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ainda moca mina taŋri, na rana ŋgaŋganŋgɨa parniŋapa mbut mbuniŋna mɨnna tɨkri, ma an punirena taup mac taŋri, na rana ŋgaŋganŋgɨa mbonkacna mɨnna tɨkri, ma an tɨp kirar kabea mac mamori. ");
INSERT INTO gai_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","“Na ra uriraca mbe tambatta tɨkri, ma taŋga mina punirena taupca watri, ramtaɨr ndeida wɨtɨkca wanaiŋ eacrenan, ri, ma mimo madigiat, ‘Tida moca gan ra rocotta ne ganna wɨtɨkca aiŋa mo ŋgocor?’ ");
INSERT INTO gai_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ri, mina mana kamma rutica, aindopatna, ‘Ramoot ianna aimo aŋgɨca mana aiŋa mo ŋgocor.’ Na ma minmo aindoprina, ‘Ne toca taŋca aukna wainna warɨŋna aiŋa mo.’ ");
INSERT INTO gai_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Na wigwac ŋgoinna, an wain warɨŋna aetta, ma ndona aiŋa raupŋirena ramoot paŋanmo aindopatna, ‘An aiŋa morina ramtaɨrmo aca kɨpca, minmo mina kituknduk neaŋ. Na u mimo ainda neaŋ, an iŋa kɨpca aiŋa morinan ndiŋa taŋca an outmbainanmo kabe, kabea neaŋ.’ ");
INSERT INTO gai_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ri, an wigwac ŋgoinna kɨpca aiŋa morina ramtaɨra, mina kɨpca ndorita ruar kabe, kabea maaŋgɨat. ");
INSERT INTO gai_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ri, an ŋaŋarmuŋa aiŋa outmbai nakɨpca moatnanna, mina ndorimo tamuŋmbai naaŋgɨ ndamŋiatnanna wanaiŋ, mitoca ruar kabe, kabe maaŋgɨat. ");
INSERT INTO gai_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Na mina an aŋgɨatke, mina an wain warɨŋna aetmo kekelamun kerina. ");
INSERT INTO gai_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Mina aindopatna, ‘Gan ramtaɨra mina wigwacna aiŋ niŋgikca morinan, na aia aiŋ aniac ŋgoinna morinan, ŋaŋarmuŋa tɨkca kɨpca gan mɨn, na ra aimo rotacrinan, na u mina neaŋgapekna opoik kirar kabea u aimo an neaŋrinan.’ ");
INSERT INTO gai_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Karica an warɨŋna aetta an kamma waraca, ma mina ianmo aindopatna, ‘Ramoot, aku umo tɨp ŋgoreac ianna mba mori, na aŋga outta gan ra kabena aiŋna opoikna kamma leacrina. ");
INSERT INTO gai_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Na u ndona kituknduk aŋgɨca taŋ, aku ndona toŋtoŋ mbuŋa an iŋa kɨpca aiŋa morina ramootmo, an u aŋgɨrina kitukndukna kirara neaŋnandet. ");
INSERT INTO gai_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Na anna aukna reac, aku ndona toŋtoŋa raŋgaica kitukndukmo titoca biŋai te, anna aukna reac niŋgik? Aintik aku gan ramtaɨrmo tɨp laŋa mona, kaina moca u aukmo kɨracre?’” ");
INSERT INTO gai_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ri, Iesusa aindopatna, “Aintik an iŋmbaina eacrina ramtaɨr, mina outta eacnande. Na outta eacrenan, mina iŋmbaia eacnandet.” ");
INSERT INTO gai_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Iesusa ndona iŋa raŋgairena ramtaɨr parniŋapa mbut mbuniŋna ramtaɨr tiŋgik aŋgɨca, mina Ierusalemma taŋna taup ndiŋa taŋri, ma mimo gaindopatna, ");
INSERT INTO gai_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Ne warac, mandeaca aia Ierusalem mataŋgek, na mina Ramootna Nuocmo taup ndamtaɨr paŋaindapa tɨpemb wandik tamŋirena ramtaɨrta para tɨknandet. Te, mina mamo ritri waparaca mo te, mamo mo menacna kam leacnande. ");
INSERT INTO gai_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Na mina mamo Iudana meikramtaɨr wanaiŋna para tɨk te, mina mamo peperena kam ndopnandet, na mamo pinandet, na mamo ik nakeracnande. Na rai mbonkac mbuŋa, ma mac nda ŋgepnandet.” ");
INSERT INTO gai_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Karica anna iŋmbaia Sebedina nuocniŋna aemma, mana nuocniŋap kɨpca Iesusna outmo tutupniŋ rɨmbɨtca ma mamo digdigi ianna digina. ");
INSERT INTO gai_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ri, Iesusa mamo, ainda digiatna, “U kaica toŋgorina?” Na ma rutica aindopatna, “U aukap kam leaca, una bubuocna kaŋgaukmo, aukna nuocniŋmo aŋgɨca, ianmo una par umbaia tɨkca mbirac te, ianmo una par aeŋmbaia tɨkca mbiracna.” ");
INSERT INTO gai_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ainda moca ma maniŋna kammo rutica aindopatna, “Oŋgo an digdigia digirenanna, oŋgo mba lamŋirenan? Na oŋgo an gɨgɨrara auk ndambuŋnan aŋgɨna mɨn ki?” Ri, maniŋa rutica aindopatna, “Aŋga mɨn.” ");
INSERT INTO gai_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Na ma maniŋmo aindoprina, “Gidik, oŋgo auk aŋgɨekna gɨrgɨra oŋgo aŋgɨna mɨn, na umo aukna umbai, co, aukna aeŋmbaina para mbiracnanna, aku mba mbopitndai. An mbibiracna reikca anna aukna Aetta larapacrina meikramtaɨrtan.” ");
INSERT INTO gai_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ainda moca an mana iŋa raŋgairena parniŋna mɨnna ramtaɨra, anna waraca mina maniŋmo nikkataririnan. ");
INSERT INTO gai_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Aintik ma minmo aca kɨpca ma minmo aindoprina, “Ne lamŋirena Iudana meikramtaɨr wanaiŋnanta ramtaɨr paŋainda, mina ndorita meikramtaɨrmo makukara neaŋrenanapa, mina minmo mba matau raupŋirenan. Na mina ramtaɨr paŋaind anik toco, minmo gagra mbopca mina, mina raŋgaica mina kambca waracna. ");
INSERT INTO gai_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ainda moca an tɨp kirara nenap kai eac teac, na nena ianna ma ndomo ramoot paŋan aniac ndeacnan, ma nemo mbaiŋna ramoot ndaru. ");
INSERT INTO gai_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Na ramootta nenmo outmbaica eaceknanna, ma nenmo mbaiŋna ramootna kirar toc ndeac. ");
INSERT INTO gai_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","An kirar kabe, Ramootna Nuoca kɨprinanna, meikramtaɨra mana aiŋa moca manmo otacnanna wanaiŋ. Ma kɨprinanna, ma minmo otacna aiŋa mona kɨprina, te, ma ndona eteacna wat neaŋca meikramtaɨr wɨt mac nda aŋgɨna.” ");
INSERT INTO gai_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Karica Iesusapa mana iŋa raŋgairena ramtaɨra Ieriko auŋ tɨkcarica, taŋri, meikramtaɨr wɨt aniaca mana raŋgairina. ");
INSERT INTO gai_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Na lamnɨac ŋgoreacna ramootniŋa taupna roumbca mbiraca eacrena. Na maniŋa waracrinanna Iesusa kɨprena, aintik maniŋa aca mambopat, “Dewitna ŋgamaɨr, aŋna kadmaica aŋmo otac!” ");
INSERT INTO gai_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ri, meikramtaɨra maniŋa aca mboprina kamma waraca, mina maniŋmo tagagarica aindopatna, “Oŋgo watitica eac.” Na maniŋa kocnaia kam aniaca keca aindoprina, “Kacoot, u Dewitna ŋgamaɨr, u aŋmo kadmaica otac.” ");
INSERT INTO gai_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Aindopatke, ma wɨtɨkca maniŋmo aca digica. Aindopatna, “Oŋgo toŋgorinanna aku oŋmo tida moit?” ");
INSERT INTO gai_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Karica maniŋa mana kammo rutica, aindopatna, “Kacoot, aŋga toŋgorinanna u aŋna lamnɨacniŋmo moa laŋa moca aŋga watna.” ");
INSERT INTO gai_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ri, ma maniŋna kadmaica, ma ndona parmo, maniŋna lamnɨacniŋa tɨkca, maniŋna lamnɨacniŋa anduna laŋa moca, maniŋa watri, maniŋa mana iŋa raŋgaica mataŋgat. ");
INSERT INTO gai_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Karica Iesusapa mana iŋa raŋgairena ramtaɨra taŋga Ierusalem auŋ aniacmo rambuŋairi, mina taŋga Olip ŋgacrena takurna auŋ ianna malaruat. An auŋna ia Betpage. Ri, ma ndona iŋa raŋgairena ramootniŋmo mbagɨrica, ");
INSERT INTO gai_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","maniŋmo aindopatna, “Oŋgo monmbai waŋna an auŋa aia watrinanna taŋ. Te, oŋgo watnandet, doŋki ianapa mana mooŋnuoca mina leaca maeacreke, na oŋgo maniŋna ŋgatɨk pɨarra aŋgɨ kɨp. ");
INSERT INTO gai_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Na ramoot ianna oŋmo anna kam ianna mbop te, oŋgo mamo aindop, ‘Kacootta maniŋna aiŋap.’ Na ma doŋkiniŋmo tawi ŋgoinna watcarica ramootniŋa aŋgɨca mataŋri.” ");
INSERT INTO gai_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ainda moatke, an reaca atuna ramma morina ramootta mbopatna kamma moa mɨnna tɨkcapekna. ");
INSERT INTO gai_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Na ma aindopatna, “Saionna meikramtaɨrmo an kammo mbop, ‘Ne wat, nena Gagrirta Ramoot Paŋanna nemo makɨpek! Na ma iremb kocorta ramootna kirara doŋki ŋgam nambatta mbiraca makɨpek.’” ");
INSERT INTO gai_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ainda moca mana iŋa raŋgairena ramootniŋa taŋga an ma mbopatna kirar mamoat. ");
INSERT INTO gai_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ri, maniŋa an doŋki ŋgamapa mana aemmo aŋgɨca kɨpca, ndoniŋna tik ŋgapaoca aŋgɨca an doŋkiniŋa tɨkca, ma doŋki mooŋnuocmo ga mbiraca mataŋgat. ");
INSERT INTO gai_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ri, ramtaɨr wɨtta ndorita tik ŋgapoik riaŋga aŋgɨca taupca tɨkri, ndeida ikirta raprir aŋgɨca taupca imtaca ma an nambatta taŋrina. ");
INSERT INTO gai_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Na meikramtaɨra mamo outmbaica taŋrenan, na mana iŋa taŋrenan, mina muruŋa gainda aca mboprina, “Dewitna ŋgamaɨrmo toŋgoca aŋgɨ werei. Raraŋ Aetaniaca gan ramootmo tɨp laŋa mo, ma Kacootna i mbuŋa kɨprinan! Na Tamuŋ Ŋgoinna Raraŋ Aetaniacna imo aŋgɨ ŋgep.” ");
INSERT INTO gai_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Karica ma Ierusalem auŋ aniacna inikca mbukca meikramtaɨra ŋgep ŋgoreac naŋgepca gainda tamtam madigiat, “An ramootta ma mandai?” ");
INSERT INTO gai_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ri, an taŋrena meikramtaɨra rutica, aindopatna, “Galili pitrik inikna auŋ Nasaretna ramma morena ramoot Iesus.” ");
INSERT INTO gai_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Karica Iesusa taŋga Raraŋ Aetaniacna Kacna wuoca mbukca anna kitukndukar aŋgɨna aiŋira morina ramtaɨrapa reikca oikrena ramtaɨrmo ootta malaruat. Na ma kitukndukar ŋgetrikirena ramtaɨrta bara kabriki keri, na ŋgorikca watrena mbik tɨkca oikrena ramtaɨrta mbiracrena bar toco kabrikirina. ");
INSERT INTO gai_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ri, ma mimo aindopatna, “Raraŋ Aetaniacna timbigta kapca aindoprina, ‘Aukna Kaca anna mbendeirena kac!’ Na mandeaca ne moa aŋgɨa uriraca, macmakɨmna meikramtaɨrta taup more toc.” ");
INSERT INTO gai_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Karica lamnik ŋgoriktanapa, our ŋgorikca taŋga mamo Raraŋ Aetaniacna Kacna wuoc inikca tɨkca, mina kɨpca ma minmo anna tɨkca moa laiŋ mamori. ");
INSERT INTO gai_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ma ainda mori, taup ndamtaɨr paŋaindapa tɨpemb wandik tamŋirena ramtaɨra man moatna ŋgagatracarapa, mombonikca Raraŋ Aetaniacna Kacna wuoc inikca kam keca aindopatna, “Dewitna ŋgamaɨrmo toŋgo!” Mina anna waraca, na ma morina ŋgagatracara watca nikembkatacarica. ");
INSERT INTO gai_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ri, mina mamo ainda digiatna, “U an mina mboprena kamma, waracre ki?” Na ma mina kammo rutica aindopatna, “Ore, na ne Raraŋ Aetaniacna Timbigta Kapna inikna kamma ne mba watri ki? ‘Raraŋ Aetaniaca mombonik tekerapa, mɨr ambrenanmo landamŋi neaŋga mina mana imo aŋgɨ ŋgepnandet.’” ");
INSERT INTO gai_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ainda moca ma min tɨkcarica, ma Ierusalem auŋmo laruca taŋga, Betani auŋmo an mouŋ maeacat. ");
INSERT INTO gai_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Na ŋaŋarmuŋ ŋgoinna Iesusa Ierusalem auŋ mac nda taŋri, ma nikca mawataiat. ");
INSERT INTO gai_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ri, ma taupna roumbca watrinanna, ik ŋgaŋɨn ianna eacri, na ma taŋga rambuŋaica wattatnanna ma gagam kocor, raprir tiŋgik. Ainda moca ma an ikmo aindopatna, “Gidik ŋgoin, u amna reac ianna mba eritndait!” Na anduna an ikca magururi. ");
INSERT INTO gai_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ainda moatke, mana iŋa raŋgairena ramtaɨra anna watca, mina ŋgep ŋgoreac naŋgepca, mina aindopatna, “Titoc ŋgoinna moca an ŋgaŋɨn ikca tawi ŋgoinna magururi?” ");
INSERT INTO gai_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Karica ma mina kam, rutica aindopatna, “Aku nemo gidik ŋgoinna aindopnande, ne gidik ŋgoinna rɨpaca, iro mbuniŋ ŋgocor te, ne an auk mocapekna kirara an ikmo mo mbe. Na an niŋgikca wanaiŋ, ne gan takurmo mbop te, ‘U ŋgepca macaitta putrikica irik,’ te, ma monandet. ");
INSERT INTO gai_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Na ne rɨpaca mbendeica Raraŋ Aetaniacmo kaina reacna digi te, ma nemo neaŋnande.” ");
INSERT INTO gai_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Karica Iesusa mac taŋga Raraŋ Aetaniacna Kacna wuoca mbukca meikramtaɨrmo riptirina. Na taup ndamtaɨr paŋaindapa, ramtaɨr anikca kɨpca mamo gainda digirina, “U tenna gargarapa, i aŋgɨca gan reikca morena? Na mandaia umo an gargarapa, i neaŋca umo an aiŋa mona ndoprina?” ");
INSERT INTO gai_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ri, ma mina kammo rutica aindopatna, “Auk toco nemo digdigi ianap. Na ne aukna digdigia wandoŋa ruti te, aku nemo mbopnande, mandaia ndo aukmo gargarapa i neaŋga aku gan aiŋa morena. ");
INSERT INTO gai_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Na aku nemo gainda diginande, Ionna mana gargara ma ten ndiŋ naaŋgɨca, kɨtac puk neaŋrena, ramootnan, co, tamuŋna auŋnan?” Ri, mina ndorimo, aindopatna, “Aia aindop te, ‘Anna tamuŋna auŋnan.’ Te, ma aimo aindopnande, ‘Kaina moca ne mamo rɨpac ŋgocor?’ ");
INSERT INTO gai_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Na aia gaindop te, ‘Ramootnan.’ Te, aia meikramtaɨrta moca nanambi, moca mina aimo ruŋ nari. Mina lamŋirena, Ion, ma ramma morena ramoot.” ");
INSERT INTO gai_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ri, mina mana kammo gaind mac rutiatna, “Aia mba lamŋireke.” Ainda moatke, ma mimo aindoprina, “Aind ecte, auk toco nemo mba mbopitndai, mandaia ndo aukmo gargarapa i neaŋga aku gan aiŋa moca taŋrena.” ");
INSERT INTO gai_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Karica Iesusa, taup ndamtaɨr paŋaind anikapa ramtaɨr paŋaindmo kam roor ianna gainda keatna, “Na ne tit ndamŋirena? Ramoot aet ianna ma mooŋnuocniŋap, na ma taŋga nuoc lacaumo aindopatna, ‘Nuoc, u mandeaca u taŋca wain warɨŋna aiŋa mo.’ ");
INSERT INTO gai_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ri, an mooŋnuoca rutica aindoprina, ‘Aku karica.’ Na iŋmbaia ma ndona iro ŋgetrikica ma aiŋa mona mataŋgat. ");
INSERT INTO gai_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Karica aetta taŋga kabena nuocmo an kam kirar kabe madigiat, ri, ma rutica aindoprina, ‘Laŋ aku monande.’ Na ma aiŋa mona mba taŋgatke. ");
INSERT INTO gai_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Na an nuocniŋa, mandaia ndo aetna kamma waraca raŋgaiatna?” Ri, mina rutica aindopatna, “Out ndopatna an ramootna nuoc lacau.” Karica ma minmo aindoprina, “Aku nemo gidik ŋgoinna aindopnandet, kitcartukar iurena ramtaɨrapa, meacramootna kaŋtertaapna tɨp kirara morena meikca mina Raraŋ Aetaniacna bubuocmo nemo out ŋgoinna taŋrena. ");
INSERT INTO gai_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Na Ionna kɨpatna mɨnna, ma nenmo taup wandoŋa wandaca, ne manmo mba rɨpacatke. An kitcartukar iurena ramtaɨrapa, meacramootna kaŋtertaapna tɨp kirara morena meikca mina ndori manmo rɨpacrina. Na ne anna watca, ne iroar inkara mba ŋgetrikica, mamo mba rɨpacri.” ");
INSERT INTO gai_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Karica Iesusa an ramtaɨr paŋaindmo kabena kam roor, ian mac keatna. Na ma mimo aindopatna, “Ne warac, ramoot ianna ma wain warɨŋ ianna moca, ma wuoca moca aoca korererina. Na anna inikca ma aua moca, an wain ŋgatɨkna lourta puk aŋgɨrena reac ian mamoat. Na ma warɨŋna ndam ian mamoat, te, ramtaɨrmo an ndeac te, warɨŋna ŋginaŋa mona moca. Karica ma ramtaɨr ndeidapmo kam leaca mina mana wain warɨŋmo raupŋina, na an wainna mai te, ma mimo emtem neaŋnandet, ri, ma kabena auŋ tawanna pitrik mataŋgat. ");
INSERT INTO gai_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ri, maica wainna erca aŋgɨna mɨnna tɨkatke, ma ndona mbaiŋna ramtaɨr ndeidmo mbagɨrica mina an mana warɨŋ raupŋina ramtaɨr tambuŋa taŋca mana biŋna tɨp aŋgɨna. ");
INSERT INTO gai_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Karica an mana warɨŋ raupŋirena ramtaɨra, an mana mbaiŋna ramtaɨrta ianmo, mina laŋa mba piatke, na ianna mina mamo moa menacri, na ianmo, mina mamo watur puŋga rɨŋga mamenacri. ");
INSERT INTO gai_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ainda mori, ma ndona mbaiŋna ramtaɨr wɨtmo mac mbagɨrica mataŋri, na an ramtaɨra mina outta taŋgatna ramtaɨrta ndunduca minmo kundrina. Na an wain warɨŋna mbaiŋna aiŋa morena ramtaɨra minmo an tɨp kirar kabe mamoat. ");
INSERT INTO gai_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Karica iŋmbai ŋgoinna ma ndona nuoc mɨmɨr ŋgoin mandaca taŋri, na ma aindopatna, ‘Mina aukna nuocmo toriit ki!’ ");
INSERT INTO gai_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Na an mana wain warɨŋa raupŋirena ramtaɨra, watatke, mina ndorimo aindopatna, ‘Ganna warɨŋna aetna nuoc, aia manmo mo menac te, aia mana reikmo aetera monandet!’ ");
INSERT INTO gai_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ri, mina mamo muocameraca, warɨŋ raekca keca laruca, mamo moa mamenacat. ");
INSERT INTO gai_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Karica ma mimo, gainda digiatna, ne tit ndamŋirena, iŋmbaia an wain warɨŋna aetta kɨp te, an ramtaɨrmo ma tida moit?” ");
INSERT INTO gai_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ri, an ramtaɨr paŋainda rutica aindopatna, “Ma an warɨŋ raupŋirena ramtaɨr ŋgorikmo mo ŋgoreac ŋgoinna monande. Te, an wain warɨŋmo kabena ramtaɨra neaŋca mina mananmo raupŋinandet. Na mana gagam aŋgɨna mɨnna tɨk te, mina mana biŋmo tɨkca ma aŋgɨnande.” ");
INSERT INTO gai_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Karica Iesusa minmo gainda digiatna, “Ne Raraŋ Aetaniacna Timbigta Kapna inikca eacrena kamma ne mba watreke, a? An kamma ma gaindoprena, ‘Gan kaca morena wautmo, ramtaɨra anmo ŋgoreac ndopca, aŋgɨra roumbmbai nakecarica eacrena wautta, mandeaca ma kacna witta moca, paŋanmbaia wɨtɨkca kacmo moa gagraca maeacreke. Na Kacootta ndo an reaca mo laruca, aia watrinan, ma laŋ ŋgoin.’ ");
INSERT INTO gai_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Aintik aku nemo aindopnandet, Raraŋ Aetaniacna bubuoca ma nena para eacrenanmo aŋgɨca kabena barna meikramtaɨrmo neaŋ, mina mana gagamma morenan. ");
INSERT INTO gai_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Te, ramootta an wautna wit nambatta irik te, ma menacnandet. Na an wautna witta ramoot nambatta irik te, ma kocnaia umbararacarinande.” ");
INSERT INTO gai_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ri, an taup ndamtaɨr paŋaindapa Parisina ramtaɨra an kam roora ma keatnanna waraca, mina malamŋiat, ma mina keatna kamb rour. ");
INSERT INTO gai_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ainda moca mina manmo muoc utiŋna toŋtoŋgarap, na mina an meikramtaɨr tarica rugut mamoat. Na meikramtaɨra lamŋirena, Iesusa ramma morena ramoot. ");
INSERT INTO gai_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Karica Iesusa kamb rour puŋga meikramtaɨrmo kabena kam roor ian mac keatna. ");
INSERT INTO gai_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Ma aindopatna, “Tamuŋna auŋna bubuoca ma gagrirta ramoot paŋan ianna tɨpna kirar. Mana nuoca laŋgona moca, an gagrirta ramoot paŋanna amna reac aniaca maŋgobacat. ");
INSERT INTO gai_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Na out ŋgoinna ma kam neaŋga taŋga ramtaɨrmo an laŋtaŋgona amtiam aniac nakɨpna. Na an amna ra laruri, ma ndona mbaiŋna ramtaɨrmo mbagɨrica taŋca minmo mbopca mina kɨpna. Ri, mina kɨpna karirina. ");
INSERT INTO gai_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ainda moca ma kabena mbaiŋna ramtaɨr ndeid mac mbagɨrica minmo mambopat, ‘Ne taŋca an ramtaɨrmo aku kam neaŋrinanmo aindop, “Ne warac. Aku laŋtaŋgona amna reac aniaca moca kocrorina, na aku ndona bulmakao ramtaɨrapa amta ŋgoaeb anik laiŋ, laiŋga mo menaca rotaca amna aŋgɨ tɨkca kocroca lambia eacrena, mina kɨpca amna.”’ ");
INSERT INTO gai_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Ri, an mbaiŋna ramtaɨra taŋga an mina gagrirta ramoot paŋanna mboprina ramtaɨrmo mbopca, mina, mina kambca mba waracri, mina ŋgepca ndorita toŋtoŋgar mataŋgat. Ianna ma ndona warɨŋna aiŋa mona taŋrina, na ianna ma ndona kituknduk aŋgɨna aiŋa mona mataŋri. ");
INSERT INTO gai_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Na ndeida mina an mbaiŋna ramtaɨrmo muoca utiŋga, mimo pia ŋgocrairi, mina mimo mo menacrina. ");
INSERT INTO gai_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ainda moatke, an gagrirta ramoot paŋanna nikkatca ndona lapoca ruŋrena ramtaɨrmo, mbagɨrica mina taŋca an ramtaɨra mana mbaiŋa morena ramtaɨrmo pia menacatnanmo, rɨŋga menaca matopat. Ri, mina auŋmo tac makeat. ");
INSERT INTO gai_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Karica ma ndona mbaiŋna ramtaɨrmo aca kɨpca, minmo aindopatna, ‘Laŋtaŋgona amna reac aniaca kocroca maeacreke, na an amna reac aniac amna meikramtaɨra, mina meikramtaɨr laiŋga wanaiŋ, aintik mina an amna reac aniac nakɨpna towanaiŋ. ");
INSERT INTO gai_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Aintik ne taŋca an taupembta taupemb kambmo, meikramtaɨra wat te, ne minmo aca mina kɨpca an laŋtaŋgona amna reac aniac nakɨp.’ ");
INSERT INTO gai_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ri, ma aindopatke, mana mbaiŋna ramtaɨra taŋga an taupembta taupemb kambmo, ramtaɨra watca, minmo aŋgɨca tumbun matɨkat, an meikramtaɨr laiŋapa ŋgorikap. Mina kɨpca mbiracri, an kacna inikca mɨn matɨkat. ");
INSERT INTO gai_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Ainda mori gagrirta ramoot paŋanna min mbatna mamoat. Ri, ma wattatnanna ramoot ianna ma laŋtaŋgona lamboi laŋa mba aocri. ");
INSERT INTO gai_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Na ma an ramootmo aindopatna, ‘Aukna ramoot, u titoc ŋgoinna moca laŋtaŋgona lamboi laŋap aoca ganna mbukrina?’ Ri, an ramootta kam kocor. ");
INSERT INTO gai_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ainda moca ma ndona mbaiŋna aiŋa morena ramtaɨrmo aindoprina, ‘Ne mana orparmo leaca mamo raekmbai nake laruca ma neaup ndeac. Na an neaup diriŋa meikramtaɨra aeraŋ te, ndorita ndaɨra wiraŋnande.’ ");
INSERT INTO gai_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Karica Iesusa aindopatna, ne warac, Raraŋ Aetaniaca ma meikramtaɨr wɨt aniacmo ma acrena, na meacramoot kabe, kabemo ma minmo larapacrena.” ");
INSERT INTO gai_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ainda moca Parisina ramtaɨr ndeida kam leaca mina Iesusmo aŋgɨca ritri waparaca mona moca. Aintik mina man ndambuŋa taŋca digdigiar ndeida, digi te, ma katti ruti te, mina mamo utiŋna. ");
INSERT INTO gai_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ainda moca mina ndorita iŋa raŋgairena ramtaɨr ndeidapa, Erotna tumbunna ramtaɨr ndeidmo, mandaca mina man ndambuŋ mataŋgat. Ri, mina mamo aindopatna, “Riripti, aia lamŋirena u kam gidik niŋgik ndoprena ramoot, u an kam gidik mbuŋa meikramtaɨrmo Raraŋ Aetaniacna tɨpemb kirarira riptirena, na u ramoot ianna mba nanambirenan, wanaiŋ ŋgoin. Na u an kam kirar kabemo u an irembta ramtaɨr, co, iremb kocorta ramtaɨrmo mboprena. ");
INSERT INTO gai_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Aintik u aimo mbop, aia gagrirta ramoot paŋan aniac Sisamo, kitukndukca mana kitcartukar iurena ramtaɨra neaŋit ki, co wanaiŋ? Na u anmo tit ndamŋirena?” ");
INSERT INTO gai_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ri, ma atuna mina iroar ŋgorikmo ma lamŋirina, aintik ma mimo aindopatna, “Ne paparuna ramtaɨr koind, kaina moca ne aukmo towaina morina? ");
INSERT INTO gai_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ne aukmo, an nena kitcartukar iurena ramtaɨra neaŋrena kituknduk ianmo wandac.” Ri, mina mamo ian aŋgɨca kɨpca maneaŋgat. ");
INSERT INTO gai_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Karica ma mimo gainda digiatna, “Gan kitukndukca potaca eacrena inpaŋanapa tirca eacrena ia, anna mandainan?” ");
INSERT INTO gai_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ri, mina rutica aindopatna, “Sisanan.” Karica ma mimo gaindopatna, “Sisana reac ecte, ne mamo neaŋ, na Raraŋ Aetaniacna reac ecte, ne Raraŋ Aetaniacmo neaŋ.” ");
INSERT INTO gai_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Aindopatke, mina an kamma waraca, mina ŋgep ŋgoreac naŋgeprina. Na mina man tɨkcarica mataŋgat. ");
INSERT INTO gai_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Na an ra kabe mbuŋa, Sadisina ramtaɨra Iesusmo mac kɨpatna. Na an Sadisina tumbunna ramtaɨr, mina gaindoprena, an menacatna meikramtaɨr, mina mba mac nda ŋgepitndai. ");
INSERT INTO gai_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Ri, mina mamo gaind madigiat, “Riripti, Mosesa, atua ma gaindopatna, ‘Ramootta laŋgoca mooŋnuoc ŋgocora menac te, mana lapmbitaca mana meac konim laŋgoca mana paŋanna moca mamo mooŋnuoca mɨrca neaŋna, te, an ramootna kaminna mba topitndai.’ ");
INSERT INTO gai_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Na ŋgaua kalaip parmbaiapa mbut mbuniŋa aina rɨk ndeacrenanna, na ramoot lacaua ma laŋgoca, ma mombonik kocor ndeaca taŋga ma menacatke, mana lappa an meac mac malaŋgoat. ");
INSERT INTO gai_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Na ma toco mombonik kocor, na mamenacat, ri, man ndambuŋna lap tuk, ma toco an kirar kabe mamoat, taŋ, taŋga mina lap teker toco, an meaca laŋgoca mamenacat, ma toca mombonik kocor. ");
INSERT INTO gai_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ri, mina muruŋa menacatke, iŋmbai ŋgoinna an meaca, ma toco mamenacat. ");
INSERT INTO gai_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Na an kalaipa an meacmo mina muruŋa malaŋgoat, na memenacnan mac nda ŋgepna ra, ma mandai ŋgoinna meac ndeacit?” ");
INSERT INTO gai_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Karica Iesusa mina kammo gainda rutirina, “Ne Raraŋ Aetaniacna Timbigta Kap ndeacrena kambmo, ne mba lamŋireke. Na ne Raraŋ Aetaniacna gargar tocmo ne mba lamŋireke, aintik ne an kambmo katta mboprena. ");
INSERT INTO gai_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Na an menacrinanna mac nda ŋgepna ra laru te, an meikramtaɨra, mina menacrinan, mina mba laŋgoitndai, wanaiŋ ŋgoin. Mina an Raraŋ Aetaniacna mbaiŋna aiŋa morena ŋerŋgaur toc, tamuŋna auŋ ndeacnandet. ");
INSERT INTO gai_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","“Aintik aku nemo, an menaca nda ŋgeprena kammo nemo digina mamoek. Na an kamma Raraŋ Aetaniaca nenmo mboprenanna, anna Raraŋ Aetaniacna timbigta kap ndeacrenanna, ne mba watreket ki, a? ");
INSERT INTO gai_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Ma aindoprena, ‘Aku Abraamapa Aisakapa Iakopna Raraŋ Aetaniac.’ Anna aimo ainda wandacrina, Raraŋ Aetaniaca ma menacrina meikramtaɨrta Raraŋ Aetaniaca wanaiŋ. Ma an watap eacrena meikramtaɨrta Raraŋ Aetaniac. Mana lamnɨac ŋgoutta, meikramtaɨra watap eacrena.” ");
INSERT INTO gai_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ainda moca an meikramtaɨra mana riptirena kamma waraca, mina ŋgep ŋgoreac naŋgeprina. ");
INSERT INTO gai_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ri, Parisina ramtaɨra waracatnanna, Iesusa Sadisiarmo mbopca mina manmo mbopna kamb kocor macariat, ri, Parisina ramtaɨra man ndambuŋ makɨpat. ");
INSERT INTO gai_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Na mina rɨkca tɨpemb wandik tamŋirena ramoot ianna minap eacrina, na ma Iesusmo towaina digdigiap. ");
INSERT INTO gai_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Na ma gainda digiatna, “Riripti, titocna Tɨp Wandɨkca ma Tɨpemb Wandikmo outmbai ŋgoin?” ");
INSERT INTO gai_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ainda moca Iesusa manmo aindopatna, “‘U Raraŋ Aetaniacmo matŋi, ma una Kacoot. Na u manmo ndona iro nikinikapa ŋeroŋapa iroapmo muruŋa manmo matŋiraŋ.’ ");
INSERT INTO gai_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Aintik ganna ande outmbai ŋgoinna taŋrena Tɨp Wandɨk, na Tɨp Wandɨk ndeida mina tamuŋmbaica wanaiŋ. ");
INSERT INTO gai_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Na man ndambuŋna Tɨp Wandɨkca gaind, ‘U ndo ŋgoinna ndoa matŋirena kirara, u ndona kamkabemo u ainda matŋi.’ ");
INSERT INTO gai_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Aintik an Tɨp Wandɨkniŋa maniŋa an Tɨpemb Wandik muruŋcamiŋapa rambca morina ramtaɨra riptirina kambca, an nambatta wɨtɨkca eacrena.” ");
INSERT INTO gai_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Parisiarta ramtaɨra punica eacrenan mbuŋa Iesusa minmo madigiat, ");
INSERT INTO gai_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“An ramootta Raraŋ Aetaniaca babuca mbagɨrica kɨpca aimo mac nda aŋgɨna ramootmo, ne manmo tit ndamŋirena? Na ma mandaina nuoc?” Ri, mina rutica aindopatna, “Dewitna ŋgamaɨr.” ");
INSERT INTO gai_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Karica ma minmo gaind madigiat, “Kaina moca Ŋeroŋ Ratta Dewitmo iro laŋ neaŋca ma mamo, ‘Kacoot ŋgacrena.’ Na atua Dewitta gaindopatna, ");
INSERT INTO gai_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Raraŋ Aetaniac Kacootta aukna Kacootmo aindopatna, “Aukna par umbaia mbirac, te, aku una puŋnaŋgepmo una kaŋgaukca tɨknande.”’ ");
INSERT INTO gai_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Na ne wat, Dewitta, an ramootmo ndona Kacoot ŋgacrena. Na titoca moca ma Dewitna ŋgamaɨr ndaruit?” ");
INSERT INTO gai_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ainda moca mina ianna mana kamma nda rutina mɨnna wanaiŋ. Aintik an ra tɨkca kɨprenanna, mina nanambica mamo digdigi ianna mba mac digiatke. ");
INSERT INTO gai_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Karica iŋmbaia Iesusa ndona iŋa raŋgairena ramtaɨrapa meikramtaɨrmo kamma wiwitica mambopat. ");
INSERT INTO gai_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Na ma mimo aindopatna, “Parisina ramtaɨrapa tɨpemb wandik tamŋirena ramtaɨra nemo Raraŋ Aetaniaca Mosesa neaŋrena tɨpemb wandikca raŋgaina moca, nemo riptirena. Anna atua Mosesa moatna kirar. ");
INSERT INTO gai_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Aintik kaina kambca, mina nemo riptica nemo neaŋrenan, ne anna waraca raŋgai. Na mina morena tɨpemb kirarira anna ne kai raŋgai teac. Kari ŋgoin! Mina kamb wɨtta mboprenan, na mina ndori koinda anna mba raŋgairenan. ");
INSERT INTO gai_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Mina tɨpemb kirarira mina tɨpemb wandikmo mina kabena tɨpemb ŋgaibap tɨkca morenan, na meikramtaɨra anna moca anna makukca aŋgɨ te, mina mba otacit ŋgoin, wanaiŋ ŋgoin. Reik makukarmo aŋgɨca meikramtaɨrta ŋaikparca tɨkca, mina mbuk te, mina patŋit ianna mba otaca mbukitndai, wanaiŋ ŋgoin. ");
INSERT INTO gai_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Na an reikca mina morenanna, mina mo te, meikramtaɨra an watna. Mina mbendeirena rai anikmo, mina ndorita parna rai, co, paŋanna tacdamar anikmo aocrenan, na mina tik ŋgapaocna lamboina balarmo, wattacarica mina roctir ŋgirikca eacrenan. ");
INSERT INTO gai_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Na mina irembapna ramtaɨr mbiraca ambrena taupemb, co, Iudana mimitpac aŋgɨrena kacna ramtaɨr paŋainda mbiracrena taupemb laiŋga mina toŋgorena. ");
INSERT INTO gai_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Na mina toŋgorenanna meikramtaɨra minmo, ‘Riripti ŋgacraŋna.’ Te, mimo punirena taupca tɨkca mimo ra laŋ neaŋraŋna. ");
INSERT INTO gai_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Na ramootta nemo, ‘Ririptia kai ac teac.’ Na nena ririptia kabe niŋgik, na ne muruŋa laiplacar. ");
INSERT INTO gai_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Na gan pitrikca ne ramoot ianmo aetta kai ac teac. Nena Aet kabe niŋgikca, ma tamuŋna auŋ ndeacrena. ");
INSERT INTO gai_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Na mina nemo, ‘Ramoot paŋanna kai ac teac.’ Nena ramoot paŋanna kabe niŋgik, na an ramootta Raraŋ Aetaniaca babuca mbagɨrica kɨpca aimo mac nda aŋgɨna ramoot. ");
INSERT INTO gai_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Na mandaia nemo outmbaica taŋraŋnan, ma nenmo mbaiŋna ramoot ndaru. ");
INSERT INTO gai_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Na ramootta ndona i aŋgɨ ŋgep te, Raraŋ Aetaniaca mana ia nda aŋgɨ iriknande. Na mandai ndona i aŋgɨ irik te, ma i aniac aŋgɨnande.” ");
INSERT INTO gai_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","Karica Iesusa gaind mac mbopatna, “Ne Parisina ramtaɨrapa tɨpemb wandik tamŋirena ramtaɨr, ne makukara aŋgɨnandet. Ne kɨrpaina mimna ramtaɨrta kirar toc, na ne meikramtaɨra tamuŋna auŋna bubuoca mbukna taupembmo mboracrena, na ne ndori koinda anna mba mbukrenanna. Na meikramtaɨra anna mbukna towai te, ne mina taupembmo mboracrena. ");
INSERT INTO gai_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Na ne Parisina ramtaɨrapa tɨpemb wandik tamŋirena ramtaɨr, nen pembta kadmai, ne makukara aŋgɨnandet! Ne kɨrpaina mimna ramtaɨr. Ne pukmbaiapa mbatmbaina auŋembca taŋrena ramtaɨr, ne ramoot kabe niŋgikmo nikinik iro uriraca, nemo raŋgaina morenan. Na ma nemo raŋgai te, ne mamo moca, ma nena taŋrena menac ŋgocorta iarwara wɨrrena taca nenap taŋnande. Na ne moca ma, nena tɨpemb ŋgorikmo mona tɨpmo, ma nemo kundrina. ");
INSERT INTO gai_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Na ne lamnik ŋgorikta meikramtaɨr, ne meikramtaɨrmo taup wandacna morenanna, nen pembta kadmai, ne makukara aŋgɨnandet! Ne gaindoprena, ‘Ramootta ndona kambca mo gagrana moca ma Raraŋ Aetaniacna Kacna i ŋgaca gidik ndop te, anna reac tekernoc. Na ramootta ndona kambca mo gagrana moca ma Raraŋ Aetaniacna Kac inikca eacrena golna i ŋgac te, ma ndomo mo ndoprena reacmo ma monande.’ ");
INSERT INTO gai_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ne ŋaŋaona ramtaɨrapa lamnik pupuroik, kaina reaca Raraŋ Aetaniacna lamnɨac ŋgoutmo, ma out ŋgoin? Gol ki, Raraŋ Aetaniacna Kac? Na ne lamŋirena, gola ma Raraŋ Aetaniacna Kac inik ndeacrena, na Raraŋ Aetaniacna Kaca ndo moca gola Raraŋ Aetaniacna reac. ");
INSERT INTO gai_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Na ne gaind toco mboprena, ‘Ramootta ndona kambca mo gagrana mo te, na ma gɨmbamba morena taupna i ŋgaca gidik ndop te, anna reac tekernoc, na ma gɨmbamna reaca gɨmbamna taupca eacrinanmo ma kam gidik ndop te, ma mo ndoprena reac, co, kamma ma monande.’ ");
INSERT INTO gai_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ne lamnik pupuroik, kaina reaca ma Raraŋ Aetaniacna lamnɨacmo outmbai? Gɨmbamba morena taup ki, gɨmbamna reac? Na ne lamŋirena gɨmbamna amna reaca ma gɨmbamba morena taup ndeacrena, na gɨmbamna reaca morena taupca ma ndo moca gɨmbamna reaca Raraŋ Aetaniacna reac ndarunandet. ");
INSERT INTO gai_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Na ramootta gɨmbamba morena taupna i ŋgaca, ma gidik ndop te, anna ma gɨmbamba morena taupapa gɨmbamna reik puŋga ndona kammo moa gagrarena. ");
INSERT INTO gai_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Na ramootta Raraŋ Aetaniacna Kacna i ŋgaca, ma gidik ndop te, anna ma ndona kammo an Kacapa Raraŋ Aetaniacna i mbuŋa ndona kammo moa gagrarena. Na Raraŋ Aetaniaca, ma ndo ŋgoinna ma ndona kac ndeacrena. ");
INSERT INTO gai_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Na ramootta tamuŋna auŋna i ŋgaca, ma gidik ndop te, anna ma Raraŋ Aetaniacna mbibiracna taupapa Raraŋ Aetaniacna i mbuŋa ndona kammo moa gagrarena, na tamuŋna auŋa anna Raraŋ Aetaniacna mbibiracna taup. ");
INSERT INTO gai_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Aintik ne Parisina ramtaɨrapa tɨpemb wandik tamŋirena ramtaɨr, ne makukara aŋgɨnandet! Ne kɨrpaina mimna ramtaɨr. Ne warɨŋna ikir uprirmo, aŋgɨca nduca taŋca parniŋna mɨnna tɨk te, ne an parniŋa morinanmo, Raraŋ Aetaniaca neaŋ, na ne Tɨp Wandɨk aniaca raŋgaina mba morenanna, an Tɨpemb Wandikca anna meikramtaɨrmo wandoŋainan, na meikramtaɨrmo rɨtɨpacna tɨp laŋa wandacrenan, na meikramtaɨrmo kakadmaina opotaca morena tɨpemb kirarira wandacna, na anna ne mba raŋgairenan. Aintik ne an Tɨp Wandikca raŋgai te, anna laŋ, na ne an nduca parniŋa morena Tɨp Wandɨk toco kai ndarekrekke teac. ");
INSERT INTO gai_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Na ne lamnik pupuroikta ramtaɨr, ne ndorimo meikramtaɨrmo taup wandacna morenanna. Anna ne, ramootta mumkitta mana teram ŋgirikca ma aŋgɨca kecarirena kirar. Na kamela an ramootna teram ndeacrenanna ma mba watri, ma anap kocnaia amba tuocrina. ");
INSERT INTO gai_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Na ne Parisina ramtaɨrapa tɨpemb wandik tamŋirena ramtaɨr, nen pembta kadmai, ne makukara aŋgɨnandet! Ne kɨrpaina mimna ramtaɨr. Ne tuoŋgourapa kabarmo, mina raekrembca mataua tukirena, na amta reikca ne mina inkara tɨkrena. Na an reikca ne macmakɨmapa ndorimo reik laiŋ, laiŋ aŋgɨna tɨpemb kirarir puŋga aŋgɨrinan. ");
INSERT INTO gai_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Na ne Parisiar, ne lamnik pupuroikta ramtaɨr koindar! Na out ŋgoinna, ne tuoŋgourapa kabarta inikmbai tuki te, an raekmbainan toco mina ŋgaib tarunande. ");
INSERT INTO gai_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Na ne Parisiarapa tɨpemb wandik tamŋirena ramtaɨr, nen pembta kadmai, ne makukara aŋgɨnandet! Na ne kɨrpaina mimna ramtaɨr, nen pembta kadmai. Ne ande gom kɨndik laiŋ, laiŋta kirar, mina mukna roumbca mutoca eacrenan toc. Na mana raekmbaina wapatta laŋ ŋgoinna watnande, na mana inikca ma warirta gagrirta reik kokoitap eacrena. ");
INSERT INTO gai_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Aintik an tɨpna kirar kabea, ne meikramtaɨrta raekmbaimo, ne wandoikca taŋrena, na ne kɨrpirta mimta ramtaɨr, nena inkara ne iroar ŋgorikapa tɨp wandɨkmo nda ipuŋrenan.” ");
INSERT INTO gai_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Karica ma gaind mac mbopatna, “Ne Parisiarapa tɨpemb wandik tamŋirena ramtaɨr, nen pembta kadmai, ne makukara aŋgɨnandet! Ne kɨrpaina mimna ramtaɨr. Na ne rambca morina ramtaɨrta mukur laiŋ, laiŋga morena, na ne ramtaɨrta mukurmo lamboir laiŋ, laiŋga tɨkrena. ");
INSERT INTO gai_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Na ne gaindoprena, ‘Aina nicar ŋgamrirta mɨnna minapa eac co, aia minmo mba otaca rambca morina ramtaɨrmo mba mo menac mbe.’ ");
INSERT INTO gai_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Aintik an nena kamna moca ne ndorimo wandaca, nena nicara an rambca morina ramtaɨrmo mo menacrinan, na ne mina ŋgamrir. ");
INSERT INTO gai_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ainda moca ne ŋgepca taŋca ndorita nicar ŋgamrirta tɨp kirar ŋgoreaca raŋgaica mo mɨnna tɨk. ");
INSERT INTO gai_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Na ne nduop ŋgoreacna mombonik, titoca mo te, ne laiŋ teacit, Raraŋ Aetaniac ma nemo ritri waparaca monandet, te, ne menac ŋgocorta iarwara wɨrrena taca taŋca eacnandet. ");
INSERT INTO gai_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","“Aintik ne warac, aku nemo rambca morena ramtaɨrapa iroar laiŋta ramtaɨrapa tɨpemb wandik tamŋirena ramtaɨrmo, mandaca mina nen ndambuŋ nakɨpnandet. Na ne mina ndeidmo mo menacnandet, na mina ndeida ne ik naaŋgɨ keracnandet, na mina ndeidmo ne mimo nena Iudana mimitpac aŋgɨrena kaikca tɨkca pinandet. Na minmo, nena auŋemb anikca tɨkca ootta mandaca mina kabena auŋembca kɨpcarica taŋnandet. ");
INSERT INTO gai_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ainda moca ne gan tiacarpaikna ramtaɨr wandoik laiŋmo mo menacrina makukara anna nena muruŋnan, na an makukara nenap eacnande. Ne an ramtaɨr wandoikmo rɨŋga menacatnanna, an Abolna mɨnna tɨkca kɨpca Sekaraiana mɨn. Ma Berekiana nuoc. Na an ramootta ne mamo Raraŋ Aetaniacna Kacapa gɨmbamba morena taupna rɨkca tɨkca manmo rɨŋga menacatna. Aintik an makukna tɨp ŋgoreaca ne an makukca ne mbuknandet. ");
INSERT INTO gai_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Na aku nemo gidik ŋgoinna aindopnandet, an makukna opoikca, gan mɨnna meikramtaɨra mandeaca eacrenan toco, mina aŋgɨnandet.” ");
INSERT INTO gai_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Karica Iesusa gaind mac mbopatna, “O Ierusalem! U Raraŋ Aetaniacna rambca morena ramtaɨrmo mo menacrena, na ramtaɨra Raraŋ Aetaniaca mbagɨrica kɨprinanmo, ne aŋgɨca watur puŋga rɨŋga menaca mamairi. Na kɨdrɨk wɨtta, aku una mombonikmo aŋgɨca tumbunna tɨkna toŋtoŋ aniacap, an kackur aemma morena tɨpna kirar, na ne mba toŋgorenan. ");
INSERT INTO gai_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Aintik ne warac, mandeaca nena auŋa ma ŋgocrainandet, na reac ianna mba eacitndait. ");
INSERT INTO gai_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Na aku nemo aind mambopek, ne aukmo mba watitndai, taŋca ne aindop te, Raraŋ Aetaniaca ma gan ramootmo, Kacootna i mbuŋa kɨprinanmo, moi laŋa mo.” ");
INSERT INTO gai_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Karica Iesusa Raraŋ Aetaniacna Kacna wuocna inik tɨkcarica taŋgatke, mana iŋa raŋgairena ramtaɨra man ndambuŋ nakɨpca mamo Raraŋ Aetaniacna Kacna roumb ndeacrena kaikca wandacna morina. ");
INSERT INTO gai_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ri, ma minmo gan kamma mambopat, “Ne gan kaik laiŋga watre ki? Aku nemo gidik ŋgoinna aindopnande, mina an kaikta waut ianna mba tɨkcariitndai, na mana waut ianna mbatmbattar mba eacitndai, mina kocnai wɨŋ irikca mo kecarinande.” ");
INSERT INTO gai_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Karica Iesusa taŋga gaca Olip Takura mbiracri. Na mana iŋa raŋgairena ramtaɨra, ndori tiŋgikca manap eaca, mina mamo gainda digiatna, “U aimo mbop, tumbuitta tɨk te, an reiki laruit. Na kaina ŋgagatraca laruca aia wat te, aia garacnande, u nda kɨp te, gan tiacarpaikca ma mainandet?” ");
INSERT INTO gai_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Karica ma mina kammo gainda rutica aindoprina, “Ne ndoritake, matau wat, moca ramoot ianna nemo parunandet. ");
INSERT INTO gai_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Mina wɨtta kɨpca aukna i ŋgaca aindopnande, ‘Aku ande an ramootta Raraŋ Aetaniaca babuca mbagɨrica kɨpca aimo mac nda aŋgɨna ramoot.’ Te, mina meikramtaɨr wɨtmo parunande. ");
INSERT INTO gai_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ainda moca ne runduik anikta mɨmɨtara waracraŋnandet, na ne runduik anikca laruna kambca waracnandet, aintik ne matau wat, na ne rugdara kai mo teac. An reiki, mina larunandet, na gan tiacarpaikna mamaia mba kɨpreke. ");
INSERT INTO gai_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Na kabena pitrik waŋna meikramtaɨra ŋgepca kabena pitrik waŋna meikramtaɨrap ruŋnande. Na kabena gagrirta ramoot paŋanna wiwitna ramtaɨra mina ŋgepca kabena gagrirta ramoot paŋanna wiwitna ramtaɨrap ruŋnande. Na gan tiacarpaikca nik wapatai anikapa numnumar anikca larunandet. ");
INSERT INTO gai_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Aintik an reikca, mina meaca nik tɨkca mooŋnuoca mɨrna mandeba moreke, aŋgɨrena gɨrgɨrna kirar toc ndarunandet. ");
INSERT INTO gai_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Ainda moca an mɨnna mina nemo aŋgɨca makukar neaŋnandet. Na anna gaind, aukna ia nenap eacrenan, aintik mina nemo mo menacnandet, na meikramtaɨra muruŋcamiŋa nemo nikkatnande. ");
INSERT INTO gai_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Te, an mɨn toco, meikramtaɨr wɨtta aukca rɨpacrenanna, mina aukmo mba mac rɨpacitndai. Te, mina ndorimo puŋnaŋgepca moca ndorimo aŋgɨca puŋnaŋgepta para tɨknandet. ");
INSERT INTO gai_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Te, paparuta rambca morena ramtaɨra ŋgepca meikramtaɨr wɨtmo parunande. ");
INSERT INTO gai_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Na tɨp wandɨkmo nda ipuŋrena tɨpna kirara acnainande, te, meikramtaɨr wɨtta kabena meikramtaɨrmo matŋirena tɨpna kirar laŋa iriknandet. ");
INSERT INTO gai_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Na mandaia gagra eaca taŋca an makukara mai te, Raraŋ Aetaniaca manmo mac nda aŋgɨnandet. ");
INSERT INTO gai_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Aintik mina gan kam wembaŋ laŋmo gan tiacarpaikna kabena pitrik waŋna meikramtaɨrmo wiwiti te, meikramtaɨra muruŋa waracna. Te, gan tiacarpaikna mamamaia kɨpnandet.” ");
INSERT INTO gai_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Na Matiu ma gan timbigta kapca tirrina kamma ma gaindopatna, “Ramootta gan kamma wat te, ma matau ŋgoin ndamŋiraŋ.” Karica Iesusa gaind mac mbopatna, “Atua ramma morina ramoot Daniela mboprina, an reac ŋgoreac ŋgoinna ne watnandet. Na an reaca, ma Raraŋ Aetaniacna Kaca wɨtɨkca eacnande. ");
INSERT INTO gai_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Aintik an mɨnna meikramtaɨra Iudiana pitrikca eacrenan, mina kɨpcarica taukruirca taŋnande. ");
INSERT INTO gai_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Na ramootta kac tamuŋ ndeacrenan, ma irik te, ma ndona kac inikna reikta moca, ma mba lamŋiitndait, ma kɨpcarinandet. ");
INSERT INTO gai_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Na ramootta ndona warɨŋ inikca aiŋa morenan, ma ndona kaca mba taŋca ndona tik ŋgapaoc rocotta mba aŋgɨitndai. ");
INSERT INTO gai_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Na an mɨn toco, an nikta meikapa mombonik tekirnoikapta meikca, minpembta kadmai. ");
INSERT INTO gai_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Aintik ne Raraŋ Aetaniacmo mbendeica manmo digica an reikca an tik gagauna mɨnapa Wɨktɨtɨkna Ramo kai wattacarica laru teac. ");
INSERT INTO gai_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Na an mɨnna makukar anikca larunandet. Gan makukara gan tiacarpaikca mandeb ŋgepca kɨpca aukna mɨnna tɨkrina. Na an makukara atua mba laruatke. Na iŋmbai toco an makukara mba laruitndait. ");
INSERT INTO gai_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Na Raraŋ Aetaniaca ma an makukarta ramo mo matpi ŋgocor te, meikramtaɨr wɨtta menacnandet. Aintik ma ndo larapacrina meikramtaɨrta moca ma an ramo, moa matpinandet. ");
INSERT INTO gai_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Na an mɨnna ramoot ianna ma aindop te, ‘Ne wat, an ramootta Raraŋ Aetaniaca babuca mbagɨrica kɨpca aimo mac nda aŋgɨna ramoot, ma ande gan maeacreke,’ co, ‘Ma monde,’ ne mana kamma kai rɨpac teac. ");
INSERT INTO gai_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Na ramtaɨr ndeida kɨpca paparuna kam mbuŋa aindopnande, ‘Aku gade, an ramootta Raraŋ Aetaniaca babuca mbagɨrica kɨpca aimo mac nda aŋgɨna ramoot,’ co ‘Aku ramma morena ramoot ian.’ Te, mina ŋgagatracara moraŋ te, aintocna reik damara mo larunandet. Na gidik ŋgoin, mina mɨn te, mina an Raraŋ Aetaniacna larapacrina meikramtaɨrmo parunandet. ");
INSERT INTO gai_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","“Aintik ne warac! An reikca larunanna aku nemo mboprinan. ");
INSERT INTO gai_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ainda moca mina nemo aindop te, ‘Ne wat, ma ande ramtaɨr kocorta taup ndeacrena.’ Te, ne anna kai taŋ teac. Na mina aindop te, ‘Ne wat, ma ande an kac inik maeacreke.’ Te, ne mina kammo kai rɨpac teac. ");
INSERT INTO gai_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Aintik ne lamŋirenan, weperaca metac te, mana memetaca ma ra gagambaica metaca taŋca ra itirikmbaica mainandet. Na Ramootna Nuocna kɨkɨpna ra, ma toca ainda kɨpnandet, te, meikramtaɨra muruŋa watnande. ");
INSERT INTO gai_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Na an taupca ramtaɨrta warira menaca eacrenan, ŋganmira anna punirenan.” ");
INSERT INTO gai_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Karica Iesusa gaind mac mbopatna, “An mɨnna an makukara mai te, tawi ŋgoinna ra ma taŋca neaupa uriracnande, te, karwaia ndona memetaca mba neaŋitndai, na riac tamuŋna guiara mina riac tamuŋ tɨkcarica, mbutuk iriknandet, te, an riac tamuŋ ndeacrena reik gagrara mina numainande. ");
INSERT INTO gai_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Na an mɨnna Ramootna Nuocna ŋgagatraca riac tamuŋa larua gan tiacarpaikna meikramtaɨra muruŋa aenandet. Te, mina watnandet, Ramootna Nuoca ma riac tamuŋna dimirpaik mbuŋa mbiraca ma ndona gargarapa memetacna tac aniacap kɨpnande. ");
INSERT INTO gai_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Te, taurna mɨtmɨt aniaca kam rapacnande, te, ma ndona mbaiŋna aiŋa morena ŋerŋgaur mandaca mina mana larapacrena meikramtaɨrmo gan tiacarpaikna tenna kouderemb teacrenanmo aŋgɨca punica, man ndambuŋ naaŋgɨ kɨpnande.” ");
INSERT INTO gai_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Karica Iesusa gaind mac mbopatna, “An mɨnna ne ik kembera wat te, ne iroar aŋgɨnande. Mana ŋaikca uprir ŋgaibca weweru te, ne lamŋinandet, pukrapacna kɨdrɨkca makɨpek. ");
INSERT INTO gai_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Na an iro kabe, ne an reikca muruŋa laruca ne watti mai te, ne lamŋinande, Ramootna Nuoca kɨpca tɨŋ kamma rambuŋaica eacrena. ");
INSERT INTO gai_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Aintik aku nemo gidik ŋgoinna aindopnande, gan mɨnna meikramtaɨra menac ŋgocor te, mina an reik larueknanna, mina watnande. ");
INSERT INTO gai_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Na gan tiacarpaikapa riaca topnandet, na aukna kambca mba topitndai.” ");
INSERT INTO gai_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Karica Iesusa gaind mac mbopatna, “Ramoot ian, co, Raraŋ Aetaniacna tamuŋna auŋna mbaiŋna aiŋa morena ŋerŋgaur, co, Raraŋ Aetaniacna Nuoca, an reik lataruna ra, co, ŋgaŋganŋgɨca mina mba lamŋireke. Aetta ndo kabe niŋgikca ma lamŋirena. ");
INSERT INTO gai_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Na an tɨpna kirar kabea mina Noanna mɨnna morinanna, mina Ramootna Nuocna kɨkɨpna ra, mina an tɨpemb kirarir kabea monande. ");
INSERT INTO gai_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Na an mɨnna laemb aniaca laru ŋgocor ndeacri, meikramtaɨra amtiammapa puk gagamapa mina laŋtaŋgoar neaŋga laŋgorenan, taŋga an mɨnna Noa laŋgum mambukat. ");
INSERT INTO gai_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ri, mina an reaca minmo larunanna, mina mba lamŋiatke. Mina aind ndeaca taŋga laemb aniaca kɨpca mimo kocnaia kɨtaca pukca mamenacat. Aintik an tɨp kirar kabea, Ramootna Nuocna kɨkɨpna ra, an tɨp kirara larunande. ");
INSERT INTO gai_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ainda moca ramoot mbuniŋa warɨŋna aiŋa moa eacrenanna, Raraŋ Aetaniaca ian aŋgɨ te, ianmo watcarinande. ");
INSERT INTO gai_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Na meac mbuniŋa tapaca mona witna aiŋa moa eacrenanna, Raraŋ Aetaniaca ian aŋgɨ te, ianmo watcarinande. ");
INSERT INTO gai_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Aintik ne ndoritake matau wat, nena Kacootna kɨkɨpna ra, ne mba lamŋireke. ");
INSERT INTO gai_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Na ne gaind ndamŋi. Kacna aetta ma lamŋi te, macmakɨmna ramootta kaina kɨdrɨkca ma mouŋna kɨp te, ma koaca ma mana kaca mba titaca mbukitndai. ");
INSERT INTO gai_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Aintik ne toco kocro. Oit ianna ne lamŋi ŋgocor ndeac te, Ramootna Nuoca kɨpnande.” ");
INSERT INTO gai_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Karica Iesusa gaind mac mbopatna, “Titna mbaiŋna aiŋa morena ramootta, ma iro laŋap, na ma aiŋa memetmbaca mataua morenan? Mana kacootta manmo ramoot paŋanna tɨkca ma mana kacootna mbaiŋna aiŋa morena ramtaɨrta ŋginaŋa monande. Na mana kacootna mbaiŋna aiŋa morena ramtaɨrmo amna reac neaŋ ndopekna ra, ma mimo amta reik neaŋnande. ");
INSERT INTO gai_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ainta mbaiŋna aiŋa morena ramoot, ma ndona aiŋmo ma toŋtoŋ ŋgoinna morenanna, mana kacootta nda kɨpca manmo wat te, ma ndona aiŋmo ma toŋtoŋa morenan. ");
INSERT INTO gai_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Na aku nemo gidik ŋgoinna aindopnandet, ainta mbaiŋna aiŋa morena ramootta, mana kacootta ma an ndona reikmo muruŋa mana para tɨkca ma mananmo bubuocnande. ");
INSERT INTO gai_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Na mbaiŋna aiŋa morena ramootta, ma aiŋa mona ramootta wanaiŋ, na ma ndona iro mbuŋa aindop te, ‘Aukna kacootta ma mba tawi kɨpitndai.’ ");
INSERT INTO gai_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Te, ma ŋgepca manap mbaiŋna aiŋa morena ramtaɨr ndeidmo tamtamma pi te, ma puk gagamna ramtaɨrap pukapa amna reac amraŋ te. ");
INSERT INTO gai_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Na mana kacootna nda kɨkɨpna ra, co, rana ŋgaŋganŋgɨa ma lamŋi ŋgocor, na ma mba kocrori. Na mana kacootta nda kɨp laru te. ");
INSERT INTO gai_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ma an ndona aiŋa morina ramootmo, ma manmo pica tɨp ŋgoreac ŋgoinna moca, mamo aŋgɨca paparuna ramtaɨrap tɨkca, mina an ndeac te, aeraŋ te, ndorita ndaɨra wiraŋnande.” ");
INSERT INTO gai_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Karica Iesusa kam roor ianna gaind mac makeat, “An mɨnna tamuŋna auŋna bubuoca ma parniŋna mombour ŋgaibta nininina kirar. Ramoot ianna ma laŋgona moca makɨpat. Ri, an momboura, mina ndorita tacaɨr memetacap aŋgɨca, an laŋtaŋgona ramootna lambina taup mataŋgat, na ma kɨp te, mina mamo aŋgɨca kɨpna. ");
INSERT INTO gai_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Na an meikca, parmbaia iroar laiŋgap, na parmbaia iroar laiŋ kocor. ");
INSERT INTO gai_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ri, an iroar laiŋ kocorta meikca, mina ndorita tacaɨr memetacap aŋgɨca kɨpri, na mina ndorita tacaɨr wɨwɨr ŋgotacna tabaɨr pukca mba aŋgɨca kɨpatke. ");
INSERT INTO gai_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Na an iroapnanna mina ndorita tacaɨr memetacap aŋgɨca kɨprinanna, mina ndorita tacaɨr wɨwɨr ŋgotacna tabaɨr pukap aŋgɨca kɨprina. ");
INSERT INTO gai_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ri, an laŋtaŋgona ramootta, ma mba tawia kɨpri, an meikca lambia taŋga mina muruŋa lamnik numbca mina maŋgori. ");
INSERT INTO gai_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Ainda moca taŋga mouŋ rɨktacniŋ ŋgoinna mina waracatnanna, ramoot ianna kam keca aindoprina, an laŋtaŋgo ŋgamna ramootta makɨpek. Aintik ne ŋgepca kɨpca aia taŋca manmo taupca tɨkca ndauprikica mamo aŋgɨ kɨpna. ");
INSERT INTO gai_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Karica an mombour ŋgaibca muruŋa ŋgepca, ndorita tacaɨr memetaikmo moca mina matau mawɨrri. ");
INSERT INTO gai_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ri, an iroar laiŋ kocorta meikca, ŋgepca an landamŋiarta meikmo aindopatna, ‘Ne aimo nena tacaɨr wɨwɨrna tabrir puik emtem ŋgotac, aina tacaɨr wɨwɨrara pikna mamoek.’ ");
INSERT INTO gai_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ri, an iroapna meikca rutica aindopatna, ‘Towanaiŋ, an tacaɨr wɨwɨrna tabrir puikca aimo muruŋa ŋgotacna mɨnna wanaiŋ. Aintik ne taŋca ndoritan ŋgoik.’ ");
INSERT INTO gai_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ainda moca an iroar laiŋ kocorta meikca taŋga, tacaɨr mimitpacna tabrir puik ŋgoikna taŋgatke, an laŋtaŋgo ŋgamna ramootta makɨpat. Na an meikca kocroca eacrenanna, mina manap, an laŋtaŋgona amtiamna kac mambukat. Ri, ramtaɨra tɨŋ makaptikiat. ");
INSERT INTO gai_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Ri, iŋmbaia an iroar laiŋ kocorta meik parmbaia nda kɨpatke, mina aindopatna, ‘Ramoot aniac, ramoot aniac, u kɨpca aimo tɨŋ ŋgot!’ ");
INSERT INTO gai_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Na ma mina kammo rutica aindopatna, ‘Aku nemo gidik ŋgoinna aindopnande, aku nemo mba lamŋirenan.’” ");
INSERT INTO gai_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ainda moca Iesusa gaindopatna, “Ne ndoritake, matau wat. Nena Kacootna kɨkɨpna kaina ra, co, ŋgaŋganŋgɨa ne mba lamŋireke, ma kɨpnande.” ");
INSERT INTO gai_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Karica Iesusa kabena kam roormo gaind mac keatna, “Tamuŋna auŋna bubuoca ma ramoot ianna tawanna auŋa taŋna morena kirar. Ainda moca ma ndona mbaiŋna aiŋa morena ramtaɨrmo aca kɨpca, ndona reikca mina para tɨkna mamoat. Te, mina mananmo bubuocna. ");
INSERT INTO gai_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Na ma mina aiŋa morena iroapa landamŋia watca, minmo ndona kitukndukarmo minmo mabiŋaiat. Ma ianmo 5,000na mɨn maneaŋgat, na ianmo 2,000na mɨn maneaŋgat, na ianmo 1,000na mɨn maneaŋgat, karica ma mataŋgat. ");
INSERT INTO gai_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ri, ma taŋgatke, an 5,000na kitcartukarta mɨn naaŋgɨatna ramootta tawi ŋgoinna taŋga an kitcartukar puŋga aiŋa moca, ma kabena 5,000na kitcartukarmo, an nambat matɨkat. ");
INSERT INTO gai_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Na an 2,000na kitcartukarta mɨn naaŋgɨatna ramoot toco ainda moca ma toca kabena 2,000na kitcartukarmo an nambat matɨkat. ");
INSERT INTO gai_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Na an ramootta 1,000na kitcartukar aŋgɨatna ramootta, ma an kitcartukarmo aŋgɨca, au iaca ma anna inikca tɨkca mana ramoot paŋannanmo aŋgɨca iŋgorocatna. ");
INSERT INTO gai_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Karica kɨdrɨk rocotta taŋgatke, an ramoot paŋanna nda kɨpatke, ma ndona mbaiŋna aiŋa morena ramtaɨrmo mana kitukndukmo kaina aiŋa morina kam mbaracna moca minmo digiatna. ");
INSERT INTO gai_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ri, an ramootta 5,000na mɨnna kitcartukar aŋgɨatnanna, kɨpca ma kabena 5,000na mɨnna kitcartukarap aŋgɨca kɨpca neaŋga aindopatna, ‘Ramoot paŋan u wat! U aukmo 5,000na mɨnna kitcartukar neaŋrina, na aku an mbuŋa kabena 5,000na mɨnna kitcartukarmo an nambatta moa larurina.’ ");
INSERT INTO gai_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Karica ma manmo gaindopatna, ‘Laŋ ŋgoin, u mbaiŋna aiŋa morena ramoot laŋ ŋgoin, u ndona aiŋa mataua morena ramoot. U reik tekirmo mataua bubuocrenan, aintik aku umo aiŋir wɨtta una para tɨknande. Aintik u kɨpca aukap toŋtoŋ ndeac!’ ");
INSERT INTO gai_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Ri, an 2,000na mɨnna kitcartukar aŋgɨatna ramoot tuk kɨpca aindopatna, ‘Ramoot paŋan, u aukmo 2,000na mɨnna kitcartukar neaŋgatna, an mbuŋa aku kabena 2,000na kitcartukarmo an nambatta moca aŋgɨ kɨprina.’ ");
INSERT INTO gai_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Karica ma manmo aindopatna, ‘Laŋ ŋgoin, u mbaiŋna aiŋa morena ramoot laŋ ŋgoin, u ndona aiŋa matau morena ramoot. Aintik aku umo aiŋir anikca una para tɨknande. Aintik u kɨpca aukap toŋtoŋ ndeac.’ ");
INSERT INTO gai_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Karica an ramootta 1,000na mɨnna kitcartukar aŋgɨratnan toco, kɨpca aindopatna, ‘Ramoot paŋan, aku lamŋirena u tac ŋgoreacna ramoot. U kabena ramtaɨrta warɨŋa mbukca an mina mutocrena amta reikmo aŋgɨrenan. Na kabena ramootna tiacarpaik ma amta reik mutocrina, u an amta reikmo aŋgɨrena. ");
INSERT INTO gai_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Aintik aku rugut moca taŋga una kitukndukarmo tiacarpaik naaŋgɨ iŋgorocatna. Gade una 1,000na mɨnna kitcartukarmo, aku muruŋa mac nda maneaŋgek!’ ");
INSERT INTO gai_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Ri, mana ramoot paŋanna rutica aindopatna, ‘U mbaiŋna aiŋa morena ramoot ŋgoreac, u reac borbor. U lamŋirenan, aku kabena ramtaɨrta mutocrina warɨŋembta amta reik aŋgɨrenan, na kabena ramootna tiacarpaikna amna reac mananna aku aŋgɨrenan. ");
INSERT INTO gai_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Na u an kitukndukmo, kitcartukar wembacrena taupca tɨk co, mina an mbuŋa aiŋa moca, emtemma an nambatta tɨk mbe. Aku kɨp te, anapa man nambatta tɨkrina kitukndukap aŋgɨnandet. ");
INSERT INTO gai_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Aintik ne an 1,000na mɨnna kitcartukarmo, man ndambuŋa eacrenanmo aŋgɨca, an 10,000na mɨnna kitcartukarta ramootmo neaŋ. ");
INSERT INTO gai_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Na mandaibinna reikapnanna, aku minmo kabenan mac neaŋnande. Na mandaia reik kocortan, na an reik tekira manap eacrenanna, aku aŋgɨnandet. ");
INSERT INTO gai_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ainda moca ne an mbaiŋna aiŋa morena ramoot ŋgoreacmo, aŋgɨca neaupdiriŋ raekmbai nake laru. An taupca tɨk te, mina aea ndorita ndaɨrmo wiraŋnandet.’” ");
INSERT INTO gai_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Karica Iesusa gaind mac mbopatna, “An mɨnna Ramootna Nuoca ma ndona memetacna tac aniacapa ndona mbaiŋna aiŋa morena ŋerŋgaurap kɨp te, ma ndona gagrirta ramoot paŋanna mbiracrena taup laŋ ŋgoinna mbiraca kɨpnandet. ");
INSERT INTO gai_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Te, meikramtaɨra muruŋa kɨpi punica mana outta wɨtɨknandet. Te, ma minmo titaca, tumbun mbuniŋa monandet. An tɨpna kirara sipsiparta ŋginaŋa morena ramtaɨra morenanna, mina sipsiparmo waŋembaia tɨk te, memearmo waŋembaia tɨkrena. ");
INSERT INTO gai_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Na ma sipsiparmo par umbaia tɨk te, memearmo par aeŋmbaia tɨknandet. ");
INSERT INTO gai_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ainda moca an gagrirta ramoot paŋanna mana umbaina meikramtaɨrmo aindopnande, ‘Aukna Aetna opotac laŋa nenap eacrenan. Ne kɨpca aukna Aetta babuca kocrorina gan tiacarpaikca mandeb ŋgeprina mɨnna Raraŋ Aetaniacna bubuoca aŋgɨ. Ma nemo matau mo laŋa mona morina. ");
INSERT INTO gai_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Na ŋgaua aku nik wataica eacri, ne aukmo amna reac neaŋca aku ambrina. Na aku logotta gagraca puk amna mori, ne aukmo puk neaŋca aku ambrina. Na aku kabena auŋna ramoot, ne aukmo aca tikca aŋgɨca nena kaikca taŋga eacrina. ");
INSERT INTO gai_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Na aku tik ŋgapaoc ŋgocor tik, ne aukmo tik ŋgapaoca otaca neaŋrina, na aku roumbap eacri, ne aukmo raupŋirena. Na aku kac ŋgoreac ndeacri, ne kɨpca aukmo watrina.’ ");
INSERT INTO gai_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Te, an meikramtaɨr wandoikca mana kammo gainda rutinande, ‘Kacoot, tumbuitta aia unmo watri, u nik wapatai ndeacri, aia unmo amna reac neaŋca ambrina? Na tumbuitta u logot gagraca, aia unmo puk neaŋga ambrina? ");
INSERT INTO gai_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Na tumbuitta aia unmo kabena auŋna ramoot toca watca, unmo aina kaiknimb naaŋgɨca taŋrina? Na tumbuitta u tik ŋgapaoc ŋgocora, aia unmo tik ŋgapaoc neaŋrina? ");
INSERT INTO gai_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Na tumbuitta aia unmo roumbap, co kac ŋgoreac ndeacri, aia unmo watna taŋrina?’ ");
INSERT INTO gai_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Te, an gagrirta ramoot paŋanna mina kammo gainda rutica aindopnandet, ‘Aku nemo gidik ŋgoinna aindopnande, an reikca ne aukna iremb kocorta laipitikta ianna morinanna, an reikca ne muruŋa aukca morina.’ ");
INSERT INTO gai_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Ainda moca ma an mana par aeŋbainanmo aindopnande, ‘Ne tɨpemb ŋgorikca morina meikramtaɨr, ne ŋgocrainandet, ne aukmo kacrepca, iarwarna taca mbuknandet. An taca mina Paparuna Ramootapa, mana mbaiŋna aiŋa morena ŋerŋgaur ŋgoriktanna ŋgobaca eacrenan. ");
INSERT INTO gai_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Na anna gaind, ŋgaua aku nik wapatai ndeacri, ne aukmo amna reaca mba neaŋrina. Na aku logot gagrari, ne aukmo pukca mba neaŋga ambrina. ");
INSERT INTO gai_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Na aku kabena auŋna ramoot toc ndeacri, ne aukmo mba ndorita kaiknimbca mba aŋgɨca taŋri. Na aku tik ŋgapaoc ŋgocor, ne aukmo tik ŋgapaoca mba neaŋri. Na aku roumbap co kac ŋgoreaca eacri, ne aukmo mba kɨpca watri.’ ");
INSERT INTO gai_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Te, mitoco mana kammo gainda rutica aindopnandet, ‘Kacoot, tumbuitta aia unmo watca, u nik wapatai ndeacri, co logot gagrari, co u kabena auŋna ramoot toca eacri, co u tik ŋgapaoc ŋgocor, co u roumbap, co u kac ŋgoreaca eacri, na aia unmo otac ŋgocor?’ ");
INSERT INTO gai_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Ainda moca ma mina kammo gainda rutinandet, ‘Aku nemo gidik ŋgoinna aindopnande, an reikca ne an iremb kocorta meikramtaɨrta ianna otac ŋgocor, an reiki, ne auk motocmo otac ŋgocor!’ ");
INSERT INTO gai_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Na an meikramtaɨr, mina gɨgɨrar anik aŋgɨca iarwar ndeacraŋnandet. Na an meikramtaɨr wandoikca, mina iarwarna eteacna wat aŋgɨnandet.” ");
INSERT INTO gai_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Karica Iesusa an kambca muruŋa mbopa maica, ma ndona iŋa raŋgairena ramtaɨrmo gaindopatna, ");
INSERT INTO gai_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Ne lamŋirena ra mbuniŋ niŋgikca eacrena, na an Pasowana Ra aniaca makɨpek. Te, mina Ramootna Nuocmo puŋnaŋgepta para tɨkca, mina mamo ik nakeracnandet.” ");
INSERT INTO gai_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Na an kɨdrɨkca taup ndamtaɨr paŋaindapa, Israelna ramtaɨr paŋainda mina taŋga taup ndamoot paŋan aniac Kaiapasna kac mapuniat. ");
INSERT INTO gai_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Karica mina kam leaca, Iesusmo titoca tɨkca utiŋca manmo mo menacna, te, meikramtaɨra mba lamŋiitndait. ");
INSERT INTO gai_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ri, mina aindopatna, “Aia an reaca mona mo te, aia Raraŋ Aetaniacna mbembendeina rai anikta inikca kai mo teac, moca meikramtaɨra an mbatca nikembkatca, kaega monandet.” ");
INSERT INTO gai_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Na an mɨnna Iesusa taŋga Betani auŋ ndaruca, ma taŋga Saimonna kac maeacat. Na Saimon tikca ma ŋgaua ma roumb lepaapnan. ");
INSERT INTO gai_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ri, meac ianna mina waut mbuŋa morina tabaɨra rurena reac laŋa, iŋpai laŋapna tabaɨra kituknduk aniac mbuŋa oikrenanmo, aŋgɨca kɨpca ma anmo Iesusna paŋan maruŋkiat. Na an kɨdrɨkca Iesusa amba eacri. ");
INSERT INTO gai_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ainda moatke, mana iŋa raŋgairena ramtaɨra an mbatca, mina nikkatta aindopatna, “Kaina moca ma an tabaɨrmo wanaiŋa ruŋkirena? ");
INSERT INTO gai_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Aia anmo mbik oikrena taupca tɨkca mina oik co, aia kituknduk aniac aŋgɨca, an mbuŋa meikramtaɨr ndaekpembca neaŋna mɨn.” ");
INSERT INTO gai_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Karica mina aindopatke, ma mina iroara malamŋiat, ri, ma minmo gaindopatna, “Kaina moca ne an meacmo kekelamun kerena? Ma aukmo tɨp kirar laŋa morinan. ");
INSERT INTO gai_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Na reik kocorta meikramtaɨra memetmbaca nenap eacraŋnandet. Na aku memetmbaca nenap mba eacitndai. ");
INSERT INTO gai_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Aintik an meaca an iŋpai laŋna tabaɨra aukna tikca ruŋkiri, ma aukna waɨrmo aŋgɨa ŋgobaca mutocna kocrorina. ");
INSERT INTO gai_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ainda moca auk nemo gidik ŋgoinna aindopnande, gan tiacarpaikca mina gan kam wembaŋ laŋmo wiwiti taŋ te, mina gan meaca morina reacna kambmo nininandet. Te, mina man moatna reacna ndamŋiraŋnandet.” ");
INSERT INTO gai_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Karica an mɨnna mana iŋa raŋgairena ramtaɨrpaikna ianna ma taup ndamtaɨr paŋaind tambuŋa taŋri. Na mana ia Iudas Iskariot. ");
INSERT INTO gai_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Na ma minmo gainda digirina, “Aku Iesusmo nena para tɨk te, ne aukmo kaina reac neaŋit?” Ri, mina mamo 30na mɨnna silwana kitukndukar nduca mamo maneaŋgat. ");
INSERT INTO gai_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Aintik an kɨdrɨk mbuŋa taŋri, ma taupembta ŋgoreca Iesusmo aŋgɨca mina para tɨkna morina. ");
INSERT INTO gai_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Karica an Isap Kuri Ŋgocorta Tapacna Ra Aniaca, malaruri, na mana iŋa raŋgairena ramtaɨra man ndambuŋa kɨpca mamo gainda digiri, “U toŋgorinanna gan, Pasowana ndamŋina amna reacmo aia tenna tɨkca kocroit?” ");
INSERT INTO gai_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ri, ma mina kamma nda rutica, aindopatna, “Ne auŋ aniac Ierusalemma taŋca, an ramootta wat te, mamo aindop, ‘Ririptia, aindoprina, mana ŋganŋgɨrina ra kɨpca marambuŋairi, aintik manapa mana iŋa raŋgairena ramtaɨra, una kaca tɨkca an Pasowana amtiam amna! Te, an Pasowana Rana ndamŋina.’” ");
INSERT INTO gai_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ainda moca ma minmo mbopatna kirara mina anna raŋgaiatke. Na maniŋa Pasowana amta reikmo makocrori. ");
INSERT INTO gai_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Karica wigwac ŋgoin mbuŋa ma ndona parniŋapa mbut mbuniŋna ramtaɨrap ambrena taup mambiracri. ");
INSERT INTO gai_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Na mina ambrinan mbuŋa ma minmo gaindopatna, “Aku nenmo gidik ŋgoinna mbopnandet, nena ianna aukmo, puŋnaŋgepta para tɨknandet.” ");
INSERT INTO gai_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Na ma aindopatke, mina kakadmaica aŋgɨca, mina ŋgepca, kabe, kabea manmo gaind mambopat, “Kacoot, u auk ki, ndopre ki?” ");
INSERT INTO gai_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ri, ma rutica aindopatna, “Nena ianna aukap gan tuoŋa ambrena ramootta, aukmo puŋnaŋgepta para tɨknandet. ");
INSERT INTO gai_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Aintik Raraŋ Aetaniacna timbigta kapca mboprinan, Ramootna Nuoca ma menacnande. Na an ramootta, Ramootna Nuocmo puŋnaŋgepta para tɨkrinan, man mbaina kakadmai ŋgoin, ma makuk aniac ŋgoin aŋgɨnande. Na mana aemma, mamo mɨr ŋgocor co, an reaca manmo mba laru mbe.” ");
INSERT INTO gai_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ri, an ramootta manmo puŋnaŋgepta para tɨkna ramoot, Iudasa, ma manmo gainda digiatna, “Riripti, u auk ki ndopre ki?” Ri, ma mamo gaind mambopat, “U ndo ande mambopek.” ");
INSERT INTO gai_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Karica mina mbiraca amba eacri, Iesusa tapac ian aŋgɨca, Raraŋ Aetaniacmo mbendeica, kam laŋ neaŋga, ma rɨmbɨtca ndona iŋa raŋgairena ramtaɨrmo neaŋga, ma aindopatna, “Ne aŋgɨca am, anna aukna tikbuit.” ");
INSERT INTO gai_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ainda moca ma wain kabna puk aŋgɨca, Raraŋ Aetaniacmo mbendeica, kam laŋ neaŋga, ma mimo maneaŋri. Na ma aindopatna, “Ne muruŋa an aŋgɨca am. ");
INSERT INTO gai_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Anna aukna racaindpaik, na an mbuŋa ne Raraŋ Aetaniacap kam leacrina. Na aukna racaindpaikca aku meikramtaɨr wɨt muruŋna tɨpemb ŋgorikta makukara mo kecarina. ");
INSERT INTO gai_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Aintik aku nemo aindopek, aku wain pukca mba ammit, taŋi an mɨnna aku nenapmo aukna Aetna bubuocna inikmo wain puk ŋgam amnandet.” ");
INSERT INTO gai_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Karica mina ŋap ian ŋgumbca, mina ŋgepca auŋ aniac Ierusalem tɨkcarica mina Olip Takur mac nda taŋrina. ");
INSERT INTO gai_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ri, Iesusa ma ndona iŋa raŋgairena ramtaɨrpaikmo aindopatna, “Raraŋ Aetaniacna timbigta kapca ma gan kammap, ‘Raraŋ Aetaniaca sipsipna ŋginaŋa morena ramootmo mo menac te, mina tamtamma kɨpcarica taŋnandet. Aintik gan mouŋa aukmo laruekna reikca ne muruŋa watca, nena muruŋna rɨtɨpaikca iriknande.’ ");
INSERT INTO gai_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Na aku muk ndiŋ mac ŋgepca nenmo outta Galilia taŋnandet.” ");
INSERT INTO gai_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ri, Pita, ma mana kammo gainda rutirina, “Aku mba nduitndai, mina muruŋna rɨtɨpaikca irik te, na mina unmo tɨkcari te, aku unmo mba tɨkcariitndai.” ");
INSERT INTO gai_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ri, ma mamo gaindopatna, “Aku umo gidik ŋgoinna aindopnandet, mandeac mouŋa kackurap ŋgocor, u kɨdrɨkar mbonkaca aindopnande, u aukmo mba lamŋireke.” ");
INSERT INTO gai_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ri, ma mana kammo rutica aindopatna, “Wanaiŋ ŋgoin, aku unap menacnandet, na aku ainda mba mbopitndai. Aku umo mba lamŋirena!” Na mana iŋa raŋgairena ramtaɨra muruŋa an kam kirar kabe mambopat. ");
INSERT INTO gai_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Karica Iesusapa mana iŋa raŋgairena ramtaɨra Getsemani ŋgacrena taupca taŋgatke. Ma minmo gaindopatna, “Ne ganna mbiraca eac, na aku monmbaica taŋca mbendeina.” ");
INSERT INTO gai_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ri, ma Pitaapa Sebedina nuocniŋap aŋgɨca mina mataŋgat. Na mana iro nikinikca ma kakadmaiapa iroara pauririna. ");
INSERT INTO gai_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ri, ma minmo aindopatna, “Aukna iro nikinikca makuk ŋgoin, na aku menacnan toc, aintik ne gan ndeaca aukna ŋginaŋa moca, aukmo otaca mbendeina.” ");
INSERT INTO gai_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Na ma min tɨkcarica emtemma taŋga mandaca, ma pitrik ŋgirikca ndona paŋanmo pitrikca tɨkca ma gainda mbendeirina, “Aukna Aet, u mɨn ecte, aku toŋgorina, u gan gɨgɨrara, auk ndambuŋnan aŋgɨca mo kecari! Na u, aukna toŋtoŋa kai raŋgai teac, u ndona toŋtoŋ niŋgikca raŋgai.” ");
INSERT INTO gai_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ainda moca ma ndona iŋa raŋgairena ramtaɨr mbonkac ndambuŋa nda taŋga, ma wattatnanna, mina maŋgori. Na ma Pitamo aindopatna, “Tida moca ne aukmo ŋgaŋganŋgɨa kabena mɨnna watti eacna mɨnna wanaiŋ ki? ");
INSERT INTO gai_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ne ndoritake, watca mbendeica eacraŋ. Moca totowaiara nenmo laru te, ne anna irik nari. Na anna gidik, nena iroar inkara reikca mona toŋtoŋgarap, na tikca ma toŋtoŋgar kocor.” ");
INSERT INTO gai_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ri, ma mac taŋga gainda mbendeirina, “Aukna Aet, gan gɨgɨrar aukmo iukaina mɨnna wanaiŋ, na aku aŋgɨna te, u ndona toŋtoŋ niŋgikca raŋgai.” ");
INSERT INTO gai_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ri, ma min tambuŋa mac nda kɨpca wattatnanna, mina ŋgoca eacri, na anna gaind, mina lamnikca ŋgona numbacarica. ");
INSERT INTO gai_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Karica ma min, tɨkcarica ma kɨdrɨk mbonkacna mbembendeina mona mac mataŋri. Na ma an outta morina mbembendeina kirar kabe mamori. ");
INSERT INTO gai_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ainda moca iŋmbaia ma kɨpca minmo gaindopatna, “Ne warac, ne ŋgoreke, na wɨk laŋ maaŋgɨreke? Na Ramootna Nuocmo mina tɨpemb ŋgorikta makukara morena ramtaɨrta para tɨkna ŋgaŋganŋgɨna mɨnna malaruri. ");
INSERT INTO gai_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ne wat! Aukmo mina para tɨkna ramootta ma kɨpca rambuŋairina, aintik ne ŋgepca aia taŋ.” ");
INSERT INTO gai_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Na Iesusa kam ndoprenan mbuŋa Iudasa ramtaɨrta tumbun aniacap kɨpca malarucat, na ma Iesus ndambuŋ mataŋgat. Na an ramootta ma Iesusna iŋa raŋgairena parniŋapa mbut mbuniŋna ramtaɨrta ramoot ian. Na an ramtaɨrta tumbun aniaca mina bugrimbapa ikir tɨpembap utiŋga kɨprinan. Na an ramtaɨrmo, taup ndamtaɨr paŋaindapa, meikramtaɨrta ramtaɨr paŋaindap, minmo Iudasap mbagɨrica mina kɨpatna. ");
INSERT INTO gai_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Na an ramootta mamo mina para tɨk ndoprina ramoot, ma minmo ŋgagatrac ianna mona gaindoprina, “Aku an ramootmo pipopot te, ande an ramoot, ma Iesus, na ne manmo muoc utiŋ.” ");
INSERT INTO gai_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ri, tawi ŋgoinna, ma man ndambuŋa kɨpca, aindopatna, “Mouŋ laŋ riripti,” karica ma manmo pica mapopotacat. ");
INSERT INTO gai_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ainda moca ma manmo gaindopatna, “Ramoot, an reaca u mona kɨprinanna, u tawi mo.” Ri, mina kɨpca mamo muoca mautiŋgat. ");
INSERT INTO gai_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Na ramoot ianna manap eacrinan, ma ŋgepca ndona bugrim wɨŋga laruca, ma an mbuŋa taup ndamoot paŋan aniacna tuomna aiŋ kamainda morena ramootna koara waca kataca koar waŋga mairikat. ");
INSERT INTO gai_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ri, Iesusa an ramootmo gaindopatna, “Una bugrimma mana taupca nda tɨk. Na mandaibinna bugrim mbuŋa ruŋrenan, mina bugrim mbuŋa menacnandet. ");
INSERT INTO gai_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Na u mba lamŋireke? Aku ndona Aetmo digi te, ma ndona mbaiŋna aiŋa morena ŋerŋgaur wɨt aniac ŋgoinna, mbagɨrica, mina kɨpca aukmo otacnandet. ");
INSERT INTO gai_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Aintik aku ainda mo te, an Raraŋ Aetaniacna timbigta kapna inik ndeacrena kamma, ma mboprena kirar gidikca mba laruitndai. Na Raraŋ Aetaniacna timbigta kapca ma aindoprina, an reikca aukmo larunande.” ");
INSERT INTO gai_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Karica an kɨdrɨk ŋgoinna ma an ramtaɨrmo aindopatna, “Ne aukmo muoc utiŋna kɨprinanna, ne bugrimarapa paraiŋap aŋgɨca kɨpatna. Anmo macmakɨm, co, ruŋrena ramoot ianna muocna kɨprinan ki? Na memetmbaca aku ra, ra katuca Raraŋ Aetaniacna Kacna wuocna inikca mbiraca meikramtaɨrmo riptirena. Na kaina moca ne aukmo an mɨnna muocna karirina? ");
INSERT INTO gai_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ainda moca an rambca morina ramtaɨra Raraŋ Aetaniacna timbigta kapca tirca eacrenanna, mina gidikca larunandet.” Ri, mana iŋa raŋgairena ramtaɨra muruŋa man tɨkcarica kɨpcaririna. ");
INSERT INTO gai_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Karica an ramtaɨra Iesusmo utiŋrinanna, manmo taup ndamoot paŋan aniac Kaiapasna kac naaŋgɨca mataŋgat. Na tɨpemb wandik tamŋirena ramtaɨrapa ramtaɨr paŋainda anna punica eacrenan. ");
INSERT INTO gai_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ainda moca Pita, ma Iesusna moca mana iŋa, iŋ mbumbutukca minmo raŋgaica mataŋri. Na ma an kacna wuoca mbukca ma taŋga anna ŋginaŋna aiŋa morena ramtaɨrap mambiracri. Te, ma watna kaina reaca Iesusmo laruit. ");
INSERT INTO gai_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Karica taup ndamtaɨr paŋaindapa ninik waŋgora muruŋa, ramtaɨr ndeidmo aca kɨpca, mina Iesusa moatna paparuna tɨpna kirarna kamb topna. Te, mina taupembta korena, ma reac ianna katti mo te, mina manmo mo menacna. ");
INSERT INTO gai_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","61","Ainda mori, ramtaɨr wɨtta kɨpca mamo ndoŋrapacrina. Na mina man morina makuk ianna ore laru ŋgocor, te, manmo mo menacna. Ri, ramoot mbuniŋa kɨpca aindopatna, “An ramootta, ma gaindoprina, ‘Aku Raraŋ Aetaniacna Kacmo waŋarca, rai mbonkac niŋgikna inikca mac aŋgɨ wɨtɨkna mɨn.’” ");
INSERT INTO gai_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Karica taup ndamoot paŋan aniaca ŋgepca wɨtɨkca, manmo gaindopatna, “U aina kam ian rutina karirinan ki? Na an kambca mina umo mboprenan anna titoc?” ");
INSERT INTO gai_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ri, ma kam ianna mba mbopri. Ainda moca an taup ndamoot paŋan aniaca aindopatna, “U, Raraŋ Aetaniacna iarwarna eteacna watapna i mbuŋa, u mandeaca kam gidik ndop, u an ramootta Raraŋ Aetaniaca babuca mbagɨrica kɨpca aimo mac nda aŋgɨna ramoot, ki? Na u Raraŋ Aetaniacna Nuoc, ki?” ");
INSERT INTO gai_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Karica ma manmo nda rutica aindopatna, “Ore, u ndo mbuŋa mambopri. Na aku nemo muruŋa aindopnandet, iŋmbaia ne watnandet, Ramootna Nuoca ma Raraŋ Aetaniacna gargarapna par umbaia mbiracnande. Te, ma tamuŋna auŋna dimirpaik anna mbiraca kɨpnande.” ");
INSERT INTO gai_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ri, an taup ndamoot paŋan aniaca an kamna moca, ma ŋgep ŋgoreac naŋgepca ndona tik ŋgapaoca wɨŋga titacatke, ma aindopatna, “Ma Raraŋ Aetaniacna taup aŋgɨna morena. Na aia kabena ramootmo kai aca, manmo mana tɨpembta moca kai ore teac? Na mandebanna aia waracpeknanna, ma ndomo Raraŋ Aetaniacna taup aŋgɨna ndoprena. ");
INSERT INTO gai_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Aintik ne tit ndamŋirena, na aia mamo kaica moit?” Ri, mina mana kammo gainda rutirina, “Ma makukap, ma menacnandet.” ");
INSERT INTO gai_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","68","Aindopatke, mina mana inpaŋanmo taber iuri, na mana kapgɨn ŋgapri, na mamo parmuŋgup mbuŋa piatna. Na mina mamo aindopatna, “Raraŋ Aetaniaca umo babuca mbagɨrica mana meikramtaɨr mac nda aŋgɨna ramoot te, u mandeaca u ramma moca u mbop. An ramootta umo pirinanna anna mandai ki?” ");
INSERT INTO gai_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Na Pita ma wuocna inikna, an mina punica eacrena kacmo raekmbaia mbiraca eacri. Na an taup ndamoot paŋan aniacna mbaiŋna aiŋa morena meac ianna kɨpca aindoprina, “U toco an Galilina pitrik waŋna Iesusap eacrenan.” ");
INSERT INTO gai_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ri, Pita, ma mina muruŋna lamnik ŋgoutmo aindopatna, “Aku un mboprina kamma mba lamŋirenan.” ");
INSERT INTO gai_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Karica ma ŋgepca an wuocna tɨŋkamna kac tekernoca taŋga mbiracri, kabena mbaiŋna aiŋa morena meac ianna mana watca, anna meikramtaɨrmo aindopatna, “An ramootta ma Nasaret auŋna Iesusap eacrina.” ");
INSERT INTO gai_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ri, Pita mana kammo an out ndoprina kirar mac mambopat, “Gidik, gidik, ŋgoin! Aku an ramootmo lamŋi ŋgocor.” ");
INSERT INTO gai_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Na eaca mandaca, an rambuŋa wɨtɨkca eacrena ramtaɨra kɨpca manmo aindopatna, “Gidik ŋgoin, u an wiwitna ramoot ian, una logotna kamma unmo mbopca malaruri.” ");
INSERT INTO gai_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Karica ma gagraca aindopatna, “Gidik ŋgoin, aku an ramootmo mba lamŋirena. Na aku gidikca mbop ŋgocor te, Raraŋ Aetaniaca aukmo mo ŋgocraina mɨn.” Na ma aindopatke, kackura anduna maapat. ");
INSERT INTO gai_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ri, ma Iesusa mbopatna, kamna moca malamŋiat, “Kackura ap ŋgocor te, u kɨdrɨk mbonkaca aindopnande, u aukmo mba lamŋireke.” Ainda moca ma laruca taŋga mba weteica aeri. ");
INSERT INTO gai_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Karica auŋa laruatke, taup ndamtaɨr paŋaindapa Iudananta ramtaɨr paŋainda muruŋa, mina Iesusa mo menacna kam leacatna. ");
INSERT INTO gai_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ri, mina mamo lawirta ŋgatɨk mbuŋa leaca, mamo aŋgɨca taŋca Pailatna para tɨkrinan. Na Pailat, ma Iudiana pitrik waŋna ramoot paŋan aniac. ");
INSERT INTO gai_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ainda moca Iudasa ma Iesusmo puŋnaŋgepta para tɨkrina ramtaɨrmo watri, mina Iesusmo tɨpemb ŋgorikca moca, mamo makuk neaŋgatke, Iudasa ndona iro inik ŋgetrikica, ma an taup ndamtaɨr paŋaindapa, Iudiana ramtaɨr paŋainda, mamo neaŋrina 30na mɨnna silwana kitukndukarmo ma aŋgɨca minmo nda neaŋgatna. ");
INSERT INTO gai_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ri, ma aindopatna, “Gan ramootta aku nena para tɨkrinan, ma tɨp ŋgoreacna makuk ianna mba mori. Na ne mana mo menacna mamoek. Aku tɨp ŋgoreacna makukca mamoat.” Na mina mana kamma rutica aindopatna, “Anna aina reaca wanaiŋ, anna una reac, u ndo wandoŋai.” ");
INSERT INTO gai_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Aindopatke, ma an silwana kitukndukarmo Raraŋ Aetaniacna Kac inikca ke irikca, ma laruca taŋga kaorikca mamenacat. ");
INSERT INTO gai_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Karica taup ndamtaɨr paŋainda, an silwana kitukndukar aŋgɨca, mina gaindopatna, “Gan silwana kitukndukar puŋga anna ramootna racaindpaik ŋgoikrinan. Aintik aia mamo an Raraŋ Aetaniacna Kacna kitukndukarap kai tɨk teac.” ");
INSERT INTO gai_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ri, mina kam leaca, an silwana kitukndukarmo mina aŋgɨca wɨnneca morena ramtaɨrta pitrik umbum maoikat. Te, an pitrik umbummo mina kabena tawanna auŋna meikramtaɨra menac te, mina warirmo anna mutocna. ");
INSERT INTO gai_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Aintik an mɨnna mina an pitrik umbummo gan i neaŋgatna, Racaindpaikna Pitrik Umbum. Na mina manmo aind ŋgacrena. ");
INSERT INTO gai_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ainda moca atua Raraŋ Aetaniaca ndona ramma morina ramoot Ieremaina upa tɨkrina kam ianna ma moa mɨnna tɨkrina. Na an kamma gaindoprina, “Israelna ramtaɨr ndeida mina an 30na mɨnna kitukndukarmo kam leaca aindoprina, an kitukndukara anna an ramootmo oikna mɨn. ");
INSERT INTO gai_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Aintik an silwana kitukndukarmo mina wɨnna morena ramootna tiacarpaikna tiacar tɨp paik ŋgoikrina. Anna Kacootta mbopatna kirar.” ");
INSERT INTO gai_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Na Iesusa ma Iudiananta ramoot paŋan Pailatna outta wɨtɨkca eacri. Na ma manmo gainda digiatna, “U Iudananta gagrirta ramoot paŋan ki?” Ri, Iesusa rutica aindopatna, “U ande mambopri.” ");
INSERT INTO gai_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ainda moca taup ndamtaɨr paŋaindap Iudana ramtaɨr paŋainda, mamo ndoŋrapaca, paparuna kamb topri, ma mina kambca mba rutiri. ");
INSERT INTO gai_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Na ma manmo gaind mac digiatna, “Na mina umo kekelamun kerena kambca u mba waracre ki?” ");
INSERT INTO gai_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Na ma, mana kam ianna mba rutiri. Ainda moca Pailatta tamtam ŋgoin malamŋiat. ");
INSERT INTO gai_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Na an amtiamna ra aniaca Iudiananta bubuocrena ramoot paŋanna, ma kac ŋgoreac ndeacrena ramoot ianmo wattacarica larurena. Ainda moca meikramtaɨra, ndori puŋga an kac ŋgoreac ndeacrena ramootna i ŋgac te, an ramoot paŋanna, ma an ramootmo watcarica ma larunande. ");
INSERT INTO gai_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Na an mɨnna, macmakɨmapa runduŋna tɨp ŋgoreaca morina irembta ramoot ianna ma toco kac ŋgoreaca eacrina. Na mana ia, Barabas. ");
INSERT INTO gai_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ainda moca meikramtaɨra kɨpca puniatke, Pailatta minmo gainda digiatna, “Ne toŋgorinanna, aku mandaimo, watcarica laruit? Aku Barabas, co an Iesusa mina aindoprena, Raraŋ Aetaniaca babuca mbagɨrica kɨpca aimo mac nda aŋgɨna ramootmo, watcarica laruit ki?” ");
INSERT INTO gai_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Na ma aindopatnanna, ma lamŋirina, mina Iesusmo iroar ŋgorikapa nikembkakaitap, na mina manmo aŋgɨca kɨpca ma mamo ritri waparaca mona. ");
INSERT INTO gai_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Na ma an ritri waparacna mbibiracna taupca mbiraca eacri, mana meaca manmo kam ian neaŋga kɨpca aindopatna, “U an ramoot wandoŋmo reac ianna kai mo teac, mouŋa aku mamo tamram mbuŋa watca, aukna iro inikca laŋa mba eacreke.” ");
INSERT INTO gai_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ainda mori, taup ndamtaɨr paŋaindapa Iudiana ramtaɨr paŋainda mina meikramtaɨrta iroara moa ŋgepca, mina Pailatmo aca mbop te, ma Barabasa watcarica laru te, Iesusmo mo menacna. ");
INSERT INTO gai_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Karica an Iudiana ramoot paŋanna minmo gaind mac digiatna, “Ne toŋgorinanna aku an ramootniŋmo mandai ŋgoinna watcarica laruit?” Ri, mina muruŋa aca aindopatna, “Barabas.” ");
INSERT INTO gai_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Aindopatke, ma minmo gainda digiatna, na an Iesusa mina aindoprinanna, Raraŋ Aetaniaca babuca mbagɨrica kɨpca aimo mac nda aŋgɨna ramootmo, kaica moit? Ri, mina muruŋa aca aindopatna, “Mamo ik naaŋgɨ kerac.” ");
INSERT INTO gai_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ri, Pailatta minmo digiatna, “Kaica? Ma kaina reaca moa ŋgocrairinan?” Ri, mina gagraca aca aindopatna, “Mamo ik naaŋgɨ kerac.” ");
INSERT INTO gai_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ainda moca ma malamŋiat, mina mana kammo mba waracitndai, na runduŋ aniaca ŋgepna mamoek. Ri, ma puk aŋgɨca ma ndona parniŋmo mina lamnɨac ŋgoutta tɨkca tukica, ma aindopatna, “An ramootta menac te, anna aukna makukca wanaiŋ, anna nena reac.” ");
INSERT INTO gai_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Aintik an meikramtaɨra muruŋa mana kammo rutica aindopatna, “An makukca aiapa aina mombonikap eacnande.” ");
INSERT INTO gai_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ainda mori, ma Barabasmo wattacarica ma laruca min ndambuŋa taŋgatke, ma mbopca mina Iesusmo lapoca ruŋrena ramtaɨrta para tɨkca, mina mamo ruktuk mbuŋa pirina. Na iŋmbaia mina manmo aŋgɨca taŋca ik nakeracnandet. ");
INSERT INTO gai_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Karica lapoca ruŋrena ramtaɨra Iesusmo aŋgɨca mina aiŋa morena kaca mbukatke, mina an lapoca ruŋrena ramtaɨrmo muruŋa aca kɨprinan. ");
INSERT INTO gai_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ri, mina mana tik ŋgapaocmo pitukca, mamo tik ŋgapaoc laup ian mac maaocat. ");
INSERT INTO gai_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Karica mina kun tocna ŋgatɨk aŋgɨca, an mbuŋa gagrirta ramootna paŋanna tɨkrena reaca moca, mana paŋan matɨkat. Na mana par umbaimo, ruktuk ianna neaŋga mautiŋgat. Ri, mina mana outmo tutpemb rɨmbɨtca manmo peperena kam mbuŋa aindopatna, “Ra laŋ, Iudana gagrirta ramoot paŋan.” ");
INSERT INTO gai_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ri, mina manmo taber iurina, na mamo neaŋrina ruktuk mbuŋa mana paŋanmo an mbuŋa pica, mac piatna. ");
INSERT INTO gai_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Karica mina manmo ainda moa maiatke, mina an tik ŋgapaoca mana tikca tɨkatnan nda riaŋga, mana tik ŋgapaoc ŋgoin matɨkat. Ri, mina mamo ik naaŋgɨ keracna moca aŋgɨca mataŋgat. ");
INSERT INTO gai_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ainda moca mina mamo aŋgɨca laruca taŋgatke. Lapoca ruŋrena ramtaɨra watrinanna, Sairinina auŋna ramoot ian, na mana ia Saimon. Mina man aŋgɨca, mamo moca ma Iesusna keracna ik mambukat. ");
INSERT INTO gai_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ri, mina taŋga taup ian malaruat, na mana ia Golgota. Na an ina mɨnɨŋa gaind, Paŋan Tiaŋgapna Gagarna taup. ");
INSERT INTO gai_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Na anna tɨkca, mina manmo wain pukca mina kabena roumbca rorairena niŋniŋna reacap kurica manmo neaŋamna. Na ma amna towairina, na ma mba ambatke. ");
INSERT INTO gai_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Karica an lapoca ruŋrena ramtaɨra mamo ik naaŋgɨa keracatke, mina matɨp rocotna gegerei toca gereica watna, mandaia ndo mana tik ŋgapoikmo aŋgɨit. ");
INSERT INTO gai_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ainda mori, mina anna mbiraca mana ŋginaŋ mamori. ");
INSERT INTO gai_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Na mana keracrina ikmo, mina mana paŋanna tamuŋmbaia, mina manmo ritri waparaca morina kam tɨp ianna, anna mina gainda tirca tikatna, “Gan Iesus, Ma Iudananta Gagrirta Ramoot Paŋan.” ");
INSERT INTO gai_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Karica mina mana roumbmo, mina macmakɨmna ramootniŋa anna tɨkca makeracat. Na ianna mana aeŋmbaina parna ik nakeracri, na ianmo mana umbaina parna ik makeracat. ");
INSERT INTO gai_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ri, meikramtaɨra taŋ, kɨp tɨkri, mina mamo peperena kamb ŋgorik toprina, na ndorita paŋaindmo korererina. ");
INSERT INTO gai_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Na mina mamo aindopatna, “U Raraŋ Aetaniacna Kacmo waŋarca, rai mbonkacna inikca u mac monandet. Na u Raraŋ Aetaniacna Nuoc ecte, u ndomo otaca, an ik nakeraca eacrenanmo, tɨkcarica irik.” ");
INSERT INTO gai_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ainda moca taup ndamtaɨr paŋaindapa tɨpemb wandik tamŋirena ramtaɨrapa ramtaɨr paŋaind, mitoco mamo pepereca aindopatna, ");
INSERT INTO gai_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Ma kabena meikramtaɨrmo otacrina, na ma ndomo otacna mɨnna wanaiŋ. Na ma Israelna Gagrirta Ramoot Paŋan, ma keracrina ikca tɨkcarica irik te, aia manmo rɨpacnandet. ");
INSERT INTO gai_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Na ma Raraŋ Aetaniacmo rɨpaca aindoprina, ‘Aku Raraŋ Aetaniacna Nuoc.’ Na Raraŋ Aetaniaca mamo toŋgo te, mandeaca ma manmo otacna.” ");
INSERT INTO gai_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Karica an macmakɨmapa tɨpemb ŋgorikca morina ramootniŋa, mina Iesusna roumbniŋa keraca eacrinanna, maniŋ toco manmo an pepere wɨtna kambta kirar kabe mambopat. ");
INSERT INTO gai_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Na maica rana ŋgaŋganŋgɨa ga aŋgɨa rɨmbɨŋa rɨŋgatke, gan tiacarpaikca neaupa muruŋa wɨŋga kɨtaca, taŋca rana ŋgaŋganŋgɨa mbonkacna mɨn. ");
INSERT INTO gai_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ainda moca rana ŋgaŋganŋgɨa mbonkaca mona rambuŋairi, Iesusa kam aniaca keca gaindopatna, “Eli, Eli, lama sabaktani?” Na an kamna mɨnɨŋa gaind, “Aukna Raraŋ Aetaniac, Aukna Raraŋ Aetaniac kaina moca u aukmo tɨkcaririna?” ");
INSERT INTO gai_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ri, ramtaɨr ndeida rambuŋa wɨtɨkca eacrinanna, mina an kamma waraca, mina aindopatna, “Gan ramootta ma Elaiana maacreke.” ");
INSERT INTO gai_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Na tawi ŋgoinna mina ianna ootta taŋga puk wɨŋga utiŋrena reac, mina spans ŋgacrena ian aŋgɨca ma ambrina mambarina wain pukca tɨkca, ma upniŋa tɨkri, ma ik tɨp ianna tɨkca leaca, mamo neaŋamna mamori. ");
INSERT INTO gai_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Na ndeida aindopatna, “Pac lambi, aia pac wat. Moca Elaia kɨpca, mamo otacit ki, co wanaiŋ?” ");
INSERT INTO gai_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ainda mori, ma kam aniac ŋgoin makeat, mana ŋeroŋa putrikica ma mamenacat. ");
INSERT INTO gai_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ainda moatke, Raraŋ Aetaniacna Kacna tɨŋa mboraca keraca eacrina raraŋitta tamuŋa tɨkca titaca pɨkɨn ŋgirikca, waŋniŋ malaruat. Na gan tiacarpaikca numnum aniaca mori, watur anikca witkica irikri. ");
INSERT INTO gai_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ri, warirta mukura gootca, Raraŋ Aetaniacna meikramtaɨr rat ndeida mac nda ŋgeprina. ");
INSERT INTO gai_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ainda mori, Iesusa ŋgepatna ra, mina Ierusalem auŋ aniaca mbukatke, meikramtaɨr wɨtta watatna. ");
INSERT INTO gai_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ri, an lapoca ruŋrena ramoot paŋanap mana lapoca ruŋrena ramtaɨra Iesusna ŋginaŋa mori, mina an reikapa numnum aniaca watca, mina rugdar moca aindopatna, “Gidik ŋgoin, ma Raraŋ Aetaniacna Nuoc!” ");
INSERT INTO gai_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Na meik wɨt toco, mana raŋgaica Galili tɨkcarica kɨpca mamo otacrinan, mitoco tawancait motemma wɨtɨkca an mbatrina. ");
INSERT INTO gai_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Na an meikta inikca, Maria, Makdala auŋna meacapa Maria Iemisapa Iosepna aem, na ianna ma Sebedina nuocniŋna aem. ");
INSERT INTO gai_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Karica ra maica wigwacmbai mbuŋa Arimatia auŋna lamin aniacna ramoot ianna makɨpri. Na mana ia Iosep, na ma Iesusna iŋa raŋgairena ramoot ian. ");
INSERT INTO gai_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ri, ma taŋga Pailatmo laruca, ma Iesusna waɨr aŋgɨca mutocna madigiat. Na ma mana waɨr aŋgɨna kammo laŋ ndop te, minmo mbopca mina mamo watcarica ma aŋgɨna. ");
INSERT INTO gai_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ainda moca ma mana waɨrmo aŋgɨca ma mamatauat. Ma raraŋit gogok ŋgam ian aŋgɨca man mbuŋa tamairinan. ");
INSERT INTO gai_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Karica ma an waɨrmo aŋgɨca taŋga, ma ndo ŋgoinna ndona waɨra anna mutoc ndoprina wautna inik matɨkat. Na an mukna taupca ma mbopa mina moatna. Ri, ma an mukna tɨŋmo mana mboracrena wautmo, rukica mboracarica, ma mataŋgat. ");
INSERT INTO gai_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Na Makdala auŋna Mariaapa mana i kabea, maniŋa mukmo raekmbaina roumbca mbiraca mawatri. ");
INSERT INTO gai_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ainda moca an Wɨktɨtɨkna amna reac ŋgobacna ra maiatke. Wɨktɨtɨkna Ra, taup ndamtaɨr paŋaindapa Parisina ramtaɨra mina Pailatta watna mataŋgat. ");
INSERT INTO gai_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Karica mina taŋga mamo aindopatna, “Ramoot paŋan, an paparuna ramoot mbopatna kam ianna, ma menac ŋgocor ndeacri, ma gaindopatna, ‘Rai mbonkac mai te, aku mac ŋgepnande.’ ");
INSERT INTO gai_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Aintik u mbopca mina mana mukmo ŋginaŋa matau watti, taŋi rai mbonkacna mɨn. Moca mana iŋa raŋgairena ramtaɨra kɨpca mana waɨrmo makɨm aŋgɨa taŋ te, aindopnande, ‘Ma muk ndiŋ mac ŋgepatna.’ Te, an mandeacna paparuna kamma, ma an ŋgaua Iesusa mbopatna paparuna kammo kunnandet.” ");
INSERT INTO gai_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Karica Pailatta minmo gaindopatna, “Ne, lapoca ruŋrena ramtaɨrmo aŋgɨca taŋca minmo mbopca mina an mukna ŋginaŋa mo. Aintik ne taŋca an mukna ŋginaŋa mona reikca matau moca, an mukca ma gargar ŋgoin ndeacna.” ");
INSERT INTO gai_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Aindopatke, mina taŋga mukmo mataua mboraca muptoca tɨkca. Mina lapoca ruŋrena ramtaɨrmo mbopca, mina man ndambuŋa wɨtɨkca mana ŋginaŋa morina. ");
INSERT INTO gai_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Karica Wɨktɨtɨkna Ra maiatke, ŋgat kabena raita, ra lacau ŋgoinna ŋaŋarmuŋ ŋgoin, Makdala auŋna Mariaapa mana i kabea maniŋa mukca watna mataŋgat. ");
INSERT INTO gai_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ri, numnum aniaca anduna manumaiat. Na Raraŋ Aetaniacna mbaiŋna aiŋa morena ŋeroŋ ianna tamuŋna auŋ ndiŋa ma irikca an waut aniaca tɨŋ mboraca eacrinanmo rukica roumbca tɨkca ma an nambatta mbiraca eacri. ");
INSERT INTO gai_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Na an mbaiŋna aiŋa morena ŋeroŋna tik ŋgapaoca mana wapatta, ma gogok dammbai. Na mana inpaŋanna ma rana memetac toc. ");
INSERT INTO gai_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ri, an lapoca ruŋrena ramtaɨra anna watca mina rugdar moca nanambica mina pitrikca irikca menacrina ramtaɨr toc. ");
INSERT INTO gai_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Karica an mbaiŋna aiŋa morena ŋeroŋa an meacniŋmo gaindopatna, “Oŋgo kai nanambi teac. Aku lamŋirena, oŋgo Iesusna ŋgorena kɨprina, ma ande an ramootta mina ik naaŋgɨ keraca ma menacatna. ");
INSERT INTO gai_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Na ma ganna mba eacreke, ma mac nda ŋgeprina. Ne kɨpca mana waɨr eacrina taupca wat. An kamma ŋgaua ma mboprina kirar.” ");
INSERT INTO gai_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ri, ma maniŋmo aindopatna, “Tawi ŋgoinna taŋca mana iŋa raŋgairena ramtaɨrmo mbop, ma menacrinanna, ma mac nda ŋgeprina. Na mandeaca ma nenmo Galilina pitrik waŋmo outmbaica taŋnande, na ne mamo anna tɨkca watnandet. Na aku nemo an kam ndopna nakɨprina.” ");
INSERT INTO gai_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Karica an meacniŋa mukna taupmo tawi ŋgoinna tɨkcarica, namnaimbap, na toŋtoŋ aniacap tik, maniŋa ootta taŋga mana iŋa raŋgairena ramtaɨrmo mbopna. ");
INSERT INTO gai_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Na maniŋa taŋgatke, Iesusa maniŋmo anduna laruca maniŋmo ndauprikica aindopatna, “Ŋaŋarmuŋ laŋ.” Ri, maniŋa taŋga mana or kɨtɨmma rambuŋaica maniŋa paŋanniŋ ramtukca mana orniŋ ŋgutiŋga mambendeiat. ");
INSERT INTO gai_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ainda mori, ma maniŋmo aindopatna, “Oŋgo kai nanambi teac. Oŋgo taŋca aukna laiplacarmo mbopca mina Galilina pitrik waŋa taŋ. Te, mina anna tɨkca aukmo watnandet.” ");
INSERT INTO gai_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Karica an meacniŋa taŋgatke, an lapoca ruŋrena ramtaɨr ndeida an mukna ŋginaŋa morenanna, mina Ierusalem auŋ aniaca taŋga taup ndamtaɨr paŋaindmo an laruatna reikta kambca muruŋ mambopat. ");
INSERT INTO gai_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ainda moca taup ndamtaɨr paŋaindapa Iudiana ramtaɨr paŋainda ndorimo aŋgɨca tumbunna tɨkca, kam maleacat. An lapoca ruŋrena ramtaɨrmo kitukndukar anik puŋ maoikat. ");
INSERT INTO gai_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ri, mina minmo aindopatna, “Ne gaindop, ‘Mouŋa aia ŋgori, mana iŋa raŋgairena ramtaɨra kɨpca mana waɨrmo makɨmbatna.’ ");
INSERT INTO gai_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Na Pailat an kamma waraca, anna ndop te, aia manap kam wandoŋaica mbopnandet. Te, ne makukar kocor.” ");
INSERT INTO gai_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ainda mori, an lapoca ruŋrena ramtaɨra an kitukndukar aŋgɨca, an ramtaɨr paŋainda mbopatna kirar maraŋgaiat. Na an kamma anna gaind, lapoca ruŋrena ramtaɨra ŋgori, Iesusna iŋa raŋgairena ramtaɨra mouŋa kɨpca Iesusna waɨrmo makɨmbca aŋgɨca taŋrina. Ri, an kamma Iudana meikramtaɨrmo tamtamma taŋga, na mandeaca an Iudana meikramtaɨra an kam kirar kabea ninia taŋrena. ");
INSERT INTO gai_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Karica mana iŋa raŋgairena parniŋapa mbut kabena mɨnna ramtaɨra, mina taŋga Galili pitrik waŋna takur ianna, ma minmo anna taŋna moca mbopatna. ");
INSERT INTO gai_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ainda moca mina mamo anna tɨkca mawatat, na mina manmo paŋaind ramtukca manmo mambendeiat. Ri, mina ndeida iroar mbunŋgirap. ");
INSERT INTO gai_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Aintik ma min ndambuŋa kɨpca rambuŋaica ma minmo gaindopatna, “Raraŋ Aetaniaca aukmo, gan tiacarpaikapa tamuŋna auŋna gargar aniaca muruŋ maneaŋgat. ");
INSERT INTO gai_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Aintik ne taŋca gan tiacarpaikna pitrik waŋgorta meikramtaɨrmo muruŋa moca mina aukna iŋa raŋgairena meikramtaɨr taru. Te, ne minmo kɨtac puk neaŋ, na ne Aetapa, Nuocapa, Ŋeroŋ Ratna i mbuŋa mo. ");
INSERT INTO gai_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Na aku nemo neaŋgatna kambmo muruŋa ne minmo riptica mina raŋgai. Na ne warac. Aku nenap memetmbaca eaci, taŋi gan tiacarpaikna mamamai.”");
INSERT INTO gai_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ganna Iesus Karaisna kam wembaŋ laŋ, na ma Raraŋ Aetaniacna Nuoc. ");
INSERT INTO gai_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Na an kam wembaŋ laŋa ramma morina ramoot Aisaia, ma atuna tirrina kirar ndaruatna. Na Ionna aindopatna, “Ne warac. Aku ramoot ianmo mbagɨrica ma outta taŋca aukna kam ndop te. Ma una taupembca ma outta kocronande.” ");
INSERT INTO gai_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Na ramtaɨr kocorta taupca, ramoot ianna kam keca gaindopnandet, “Kacootna taup kocro, na mana taupembmo wandoŋai.” ");
INSERT INTO gai_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ainda moca kɨtac puk neaŋrena ramoot Ion, ma an ramtaɨr ŋgocorta taup ndaruca anna tɨkca meikramtaɨrmo kam wiwitica, mina iroar inkar ŋgetrikica kɨtac puk aŋgɨatna. Te, Raraŋ Aetaniaca mina tɨpemb ŋgorikta makukarmo moi kecarinandet. ");
INSERT INTO gai_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Na Iudiana pitrik waŋapa Ierusalem auŋ aniacna meikramtaɨra muruŋa Ion ndambuŋa taŋrina, mina ndorita tɨpemb ŋgorikta makukarmo mbopri, ma minmo oc Iodanna tɨkca kɨtac puk neaŋgatna. ");
INSERT INTO gai_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Na Ion tikca, mana tik ŋgapaoca mina kamelna rɨkar puŋga moatna, na mana rɨktacniŋa ma weaond tɨkrena. Na mana gagamna reikca, ma raŋna kaborborarapa manoŋnoŋar ambrena. ");
INSERT INTO gai_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Na ma meikramtaɨrmo gan kammo gainda wiwitirina, “Ramoot ianna aukna iŋmbai nakɨprena, mana gargara aukmo tamuŋmbai ŋgoin. Na aku ramoot laŋ ŋgoinna wanaiŋ, aintik aku manmo tutupniŋ rɨmbɨtca mana ortɨmbɨkniŋna or ŋgapaocna ŋgatɨk pɨarna mɨnna wanaiŋ. ");
INSERT INTO gai_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ainda moca aku nemo puk niŋgik mbuŋa kɨtac puk neaŋrena, na ma ndo nenmo Ŋeroŋ Rat mbuŋa kɨtac puk neaŋnande.” ");
INSERT INTO gai_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Karica Iesusa an kɨdrɨkca Galilina pitrik waŋna inikna auŋ teker Nasaret tɨkcarica ma makɨpat. Ri, Ionna manmo oc Iodanna tɨkca kɨtac puk maneaŋgat. ");
INSERT INTO gai_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Na ma kɨtac puk aŋgɨca gacatke, ma wattatnanna tamuŋna auŋa gootca, Ŋeroŋ Ratta ŋgorac riŋnaina kirar toc ŋgirikca manmo mambiracat. ");
INSERT INTO gai_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Karica tamuŋna auŋa kam ianna keca gaindopatna, “U aukna Nuoc ŋgoin. Aku unmo matŋirena, na aukna iro inikca umo toŋtoŋ ŋgoin.” ");
INSERT INTO gai_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ainda moca Ŋeroŋ Ratta Iesusmo an mɨn ŋgoinna tɨkca manmo mandaca ma ramtaɨr kocorta taupca taŋgatna. ");
INSERT INTO gai_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ri, Ramoot Mbɨkca manmo ra kabe, kabea tɨkca towaia taŋ, taŋga rai 40na mɨn. Na ma raŋna amta ŋgoaebap eacrina. Ri, Raraŋ Aetaniacna mbaiŋna aiŋa morena ŋerŋgaura manmo otacatna. ");
INSERT INTO gai_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Karica mina kɨtac puk neaŋrena ramoot Ionmo kac ŋgoreaca tɨkatke, Iesusa Galilina pitrikca taŋga, Raraŋ Aetaniacna aiŋna kam wembaŋ laŋmo wiwitica taŋrina. ");
INSERT INTO gai_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Na ma gaindopatna, “Raraŋ Aetaniaca mbopatna kɨdrɨkca kɨpca malaruri, na mana bubuoca gade ma kɨpca marambuŋairi. Ne ndorita iroar inkar ŋgetrikica kam wembaŋ laŋa rɨpac.” ");
INSERT INTO gai_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Karica Iesusa taŋga, Galili mɨarna roumbca taŋri, na ma wattatnanna Saimonapa mana lapmbitac Andruap, maniŋa mɨarmo weaŋ keri. Na an aiŋ mbuŋa maniŋa kituknduk aŋgɨrena. ");
INSERT INTO gai_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Na ma maniŋmo aindopatna, “Oŋgo kɨpca aukmo raŋgai te, an oŋgo ŋgoaeb aŋgɨrena kirara, aku oŋmo meikramtaɨr aŋgɨna tɨpemb kirarir riptinande.” ");
INSERT INTO gai_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Aindopatke, maniŋa anduna weaŋgaɨr tɨkcarica ŋgepca manmo raŋgaica mataŋgat. ");
INSERT INTO gai_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Karica ma mac taŋga mandaca, ma Sebedina nuocniŋ mawatat. Iemisapa Ion, maniŋa embarta kor inikca mbiraca ndoniŋna weaŋgaɨr titacrinanna urpemb iukri. ");
INSERT INTO gai_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ma tawi ŋgoin motemma maniŋmo aca mbopatke, maniŋa ndoniŋna aetapa mina aiŋa morina ramtaɨrmo kor inikca tɨkcarica, maniŋa gaca mana iŋa raŋgaiatna. ");
INSERT INTO gai_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Karica Iesusa an ramtaɨr paurap, Kapaneam auŋ mataŋgat. Ri, Wɨktɨtɨkna Ra laruatke, ma mina Iudana mimitpac aŋgɨrena kaca mbukca, meikramtaɨrmo riptirina. ");
INSERT INTO gai_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Na mina mana kam mbaraca, mina ŋgep ŋgoreac naŋgepri. An kambca, ma minmo riptiri, an mina tɨpemb wandik tamŋirena ramtaɨr morina kirara mba riptiri. Wanaiŋ ŋgoin, ma an irembapta ramootna kirara ma minmo mariptiat. ");
INSERT INTO gai_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Na an kɨdrɨk toco, ramoot ianna ŋeroŋ ŋgoreacapnanna, ma an mina Iudananta mimitpac aŋgɨrena kac inik ndeacrina. Ainda moca an ramootta kam keca gaindopatna, ");
INSERT INTO gai_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Nasaret auŋna Iesus, u aimo kaia mona kɨpapekna? U aimo mo ŋgocraina moa kɨpri ki? Na aku umo lamŋirena, u Raraŋ Aetaniacna Ramoot Rat.” ");
INSERT INTO gai_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ri, Iesusa an ŋeroŋmo kaega moca manmo gaindopatna, “U watitica, an ramootmo tɨkcarica laruca taŋ!” ");
INSERT INTO gai_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Aindopatke, an ŋeroŋ ŋgoreaca an ramootmo moca ma nekca, kam aniaca keca, manmo tɨkcarica mataŋgat. ");
INSERT INTO gai_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Na meikramtaɨra anna watca, ŋgep ŋgoreac naŋgepca, mina ndorita rɨkmo aindopatna, “Kaina reaca mandeaca gaind ndaruapekna? Gan ramootta kam ŋgam ianna riptiapekna, na anna irembta ramtaɨrta kirar. Na ma ŋerŋgaur ŋgorikmo kam ndop te, mina mana kam mbaracrena.” ");
INSERT INTO gai_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ainda moatke, tawi ŋgoinna, mana moatna reikta kambta nininia Galilina pitrik waŋna auŋembca muruŋ mataŋgat. ");
INSERT INTO gai_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Karica Iesusapa meikramtaɨr ndeida mina Iudana mimitpac aŋgɨrena kac tɨkcarica laruca, mina anduna Saimonapa Andru mbaniŋna kac mataŋgat. Na Iemisap Ion toco minap mataŋgat. ");
INSERT INTO gai_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Na mina kaca mbukca wattatnanna, Saimonna meacna aemma, ma tik owowaina roumbap tik, ma bara meraca eacri, mina tawi ŋgoinna mana roumbna kammo Iesusmo mbopca mawaracat. ");
INSERT INTO gai_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ke, Iesusa taŋga mana par ŋgutiŋga, manmo mana bara tɨkca aŋgɨa ŋgepatke, mana roumbca laŋ mamoat. Na ma mina gagamna amta reik maŋgombacri. ");
INSERT INTO gai_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Karica ra irikca wigwacmbaina mɨn mbuŋa tɨkatke, mina ŋerŋgaur ŋgorikta meikramtaɨrmo Iesus ndambuŋ naaŋgɨa makɨpat. ");
INSERT INTO gai_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Na an auŋ aniacna meikramtaɨra muruŋa kɨpca Saimonapa Andru mbaniŋna kacna tɨŋ kamma punica eacri. ");
INSERT INTO gai_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Na ma an nanrirta roumbbebta meikramtaɨrmo moa laŋa mori, na an ŋerŋgaur ŋgoriktan motoca ma moa kecaririna. Na an ŋerŋgaur ŋgorikca manmo lamŋirena, aintik ma minmo wandɨk tɨkca mina mac mbopna towanaiŋ. ");
INSERT INTO gai_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Na auŋ raruri, Iesusa ŋgepca laruca taŋga ramtaɨr kocorta taupca taŋga mambendeiri. ");
INSERT INTO gai_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Na Saimonapa mana iŋa raŋgairena ramtaɨra ŋgepca, mina mana orena mataŋgat. ");
INSERT INTO gai_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Na mina taŋga manmo watca, mina manmo gaindopatna, “Meikramtaɨra muruŋa una moca mina orerena.” ");
INSERT INTO gai_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ainda moca ma minmo aindopatna, “Watcari, aia an auŋembca rambuŋa eacrenanna taŋca, aku min motoca wiwitina. Aku an aiŋ niŋgikca mona nakɨprina.” ");
INSERT INTO gai_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Aintik ma Galili inikna auŋembca muruŋa taŋga, mina Iudananta mimitpac aŋgɨrena kaikca mbukca minmo wiwitiri, na ma ŋerŋgaur ŋgoriktanmo moa kecarica mina laiŋ mamori. ");
INSERT INTO gai_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Karica roumb lepaapna ramoot ianna Iesusna kɨtɨm nakɨpca, tutupniŋ rɨmbɨtca aemaŋmaŋap, manmo aindopatna, “U toŋgo te, u aukmo moi ratta mo.” ");
INSERT INTO gai_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Na ma mana moca kakadmai ŋgoin, aintik ma ndona parmo mana tikmo utiŋga, manmo aindopatna, “Aku toŋgorina. U rat ndaru.” ");
INSERT INTO gai_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Aindopatke, an roumb lepa an ramootmo andu namamaiat, na mana tikca laŋ mamoat. ");
INSERT INTO gai_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ri, ma manmo tawi ŋgoinna mandaca taŋga, na ma manmo kam gargar mbuŋa aindopatna, ");
INSERT INTO gai_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“U matau wat, u ramoot ianmo kai mbop teac, an reaca unmo laruapekna. Kari ŋgoin. U taŋca ndona tikmo taup ndamootta wandac te, u gɨmbambaca mo, an tɨpna kirara atua Mosesa mbopatna. Te, mina watca lamŋinande, una roumbca mamairi.” ");
INSERT INTO gai_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Na an ramootta ma taŋga meikramtaɨrmo, an reikca man ndarurinanmo, ma ninia mataŋri. Na an nininia ma auŋembmo tamtamma ninia taŋri. Aintik Iesusa meikramtaɨrta lamnikmo, an auŋembmo mbukna towanaiŋ, ma an auŋemb ŋgocorta taupca eacri, na auŋembta meikramtaɨra man ndambuŋ nakɨprena. ");
INSERT INTO gai_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Karica rai ndepikca taŋgatke, Iesusa Kapaneam auŋ teker mac nda taŋgat ke, meikramtaɨra waracatnanna, ma taŋga kac ndeacri. ");
INSERT INTO gai_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Mina taŋga punica kaca mɨnna tɨkatke. Na kacna tɨŋ kam toco, mɨnna tɨkca taup emtemma eac ŋgocor. Na anna tɨkca ma minmo kam wiwitiatna. ");
INSERT INTO gai_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Karica ramtaɨr paura tik memenacna roumbbebta ramoot ianna mina Iesus ndambuŋa aŋgɨca makɨpat. ");
INSERT INTO gai_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Na mina manmo aŋgɨca Iesusna kɨtɨmma tɨkna towanaiŋ, an taupca mɨnna tɨkrina. Aintik mina mamo aŋgɨca kac kopik tamuŋ nagaca, an kac kopik kataca poloca mana barmo ŋgaɨr ikca an Iesusa eacrenan motemmo, manapa mana barmo an ndiŋa kacrepca irikatna. ");
INSERT INTO gai_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Na Iesusa watri, mina rɨtɨpaikca gagrar koind tik, ma an roumbbebta ramootmo aindopatna, “Mooŋnuoc, aku una tɨpemb ŋgorikta makukara aku moa kecamacariri.” ");
INSERT INTO gai_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Na tɨpemb wandik tamŋirena ramtaɨr ndeida an kac inikca mbiraca eacrinanna, mina iroar inkara gaind ndamŋiatna, ");
INSERT INTO gai_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Kaina moca gan ramootta gan kam tɨp ndopapekna, ma Raraŋ Aetaniacna taup aŋgɨna more ki? Na ramoot ianna tɨp ŋgoreacna makukca mo kecarina mɨnna wanaiŋ, anna Raraŋ Aetaniacna ndo kabe niŋgikna aiŋ.” ");
INSERT INTO gai_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ri, ma mina iroar inkarmo, ma ndona iro inik mbuŋa ma tawi ŋgoinna maaŋgɨat. Na ma minmo gainda digiatna, “Kaina moca nena iroar inkara gaind ndamŋirena? ");
INSERT INTO gai_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Kaina kamma aku gan tik memenacna roumbapna ramootmo wetwet ndopit, ‘Una tɨp ŋgoreacna makukca aku moa kecamacariri,’ co, ‘U ŋgepca wɨtɨkca ndona bar aŋgɨca taŋ’?” ");
INSERT INTO gai_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Aintik ne gaind ndamŋi, Ramootna Nuoca ma gan tiacarpaikmo ma gargar aniacap, na ma tɨpemb ŋgorikta makukarmo mo kecarina mɨn. Ri, ma gan tik memenacna ramootmo watta taŋga gaindopatna, ");
INSERT INTO gai_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Aku unmo mambopek, u ŋgep wɨtɨkca ndona bar aŋgɨca, ndona kaca taŋ.” ");
INSERT INTO gai_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ri, ma ŋgepca wɨtɨkca ndona barmo rukumbca aŋgɨca, mina lamnik ŋgoutta, ma tawi ŋgoinna ndona kac mataŋgat. Ainda moatke, mina muruŋa ŋgep ŋgoreac naŋgepca, mina Raraŋ Aetaniacna imo aŋgɨa maŋgepri. Na mina gaindopatna, “Ŋgaua aia ainta reac ianna mba watri, wanaiŋ ŋgoin.” ");
INSERT INTO gai_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Karica Iesusa Galili mɨarna maŋar mac nda mataŋgat. Na meikramtaɨr wɨt aniaca man ndambuŋ nakɨpri, ma minmo riptirina. ");
INSERT INTO gai_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ri, ma taŋga mandaca, ma Alpiusna nuoc Liwaimo mawatat, na ma kitukndukar iurena aiŋna taupca mbiraca eacrina. Na ma manmo aindopatna, “U kɨpca aukmo raŋgai.” Ri, ma ŋgepca manmo maraŋgaiat. ");
INSERT INTO gai_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Karica ma taŋga Liwaina kaca amna mambiracat. Na kitukndukar iurena ramtaɨr wɨtapa, tɨpemb ŋgorikta makukara morena ramtaɨra mina Iesusapa mana iŋa raŋgairena ramtaɨrap mbiraca ambri. Na aintocna ramtaɨr wɨt aniaca memetmbaca mina manmo raŋgairina. ");
INSERT INTO gai_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ri, Parisina wiwitna tɨpemb wandik tamŋirena ramtaɨr ndeida, mina watri, ma an kitukndukar iurena ramtaɨrapa tɨpemb ŋgorikta makukara morena ramtaɨrap ambri. Na mina mana iŋa raŋgairena ramtaɨrmo gaind madigiat, “Kaina moca ma kitukndukar iurena ramtaɨrapa tɨpemb ŋgorikta makukara morena ramtaɨrap ambrena?” ");
INSERT INTO gai_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ainda moatke, ma an kamma waraca, ma an tɨpemb wandik tamŋirena ramtaɨrmo gaindopatna, “Roumbbeb kocorta meikramtaɨra mina pitir gagamna ramoot nake mba taŋca orerenan, wanaiŋ, roumbbebta meikramtaɨra mina ndori taŋca pitir gagamna ramootna orerena. An kirar kabe mbuŋa aku meikramtaɨr wandoikta, mba acna kɨprina, wanaiŋ, aku tɨpemb ŋgorikta makukara morena meikramtaɨrta ŋgacna moca kɨprina.” ");
INSERT INTO gai_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Oit ianna kɨtac puk neaŋrena ramoot Ionna iŋa raŋgairena ramtaɨrapa Parisina ramtaɨra, mina wariraca eacri. Na ramtaɨr ndeida kɨpca Iesusmo gainda digiatna, “Kaina moca Ionna iŋa raŋgairena ramtaɨrapa Parisina ramtaɨra wariracreke, na una iŋa raŋgairena ramtaɨra mba wariracrena?” ");
INSERT INTO gai_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ri, ma minmo aindopatna, “Ramoot ianna laŋgona mo te, ma ndona kam kamkabeap eac te, mina amna reacmo mba waracitndai? Wanaiŋ. Na an mɨnna an laŋgona ramootta minap eac te, mina amna reacmo mba waracitndai. ");
INSERT INTO gai_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Na iŋmbaia mina an ramootta laŋgona morinanna aŋgɨ taŋ te, na ma ndona kamkabearap eac ŋgocor te, ande an kɨdrɨkca mina amna reacmo wariracnandet. ");
INSERT INTO gai_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Na ramoot ianna raraŋit ŋgamna waŋa mba aŋgɨca, tik ŋgapaoc bagarna urupa mba iukrena. Na ma ainda mo te, mina an tik ŋgapaocmo tuki te, an raraŋit ŋgam waŋ anna, ma taŋi tekraicai te, ma an tik ŋgapaocmo mo titacnandet. Te, an iukrena raraŋit ŋgam anna, ma an tik ŋgapaocna urupa moca acnainandet. ");
INSERT INTO gai_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Na ramootta wain ŋgamna pukca mba aŋgɨca memena iŋit bagara mba rurena. Ma ainda mo te, an wain pukca ma an memena iŋitmo mo titacnandet. Te, an wain pukapa memena iŋitta ŋgocrainandet. Aintik mina wain puk ŋgamma, mina memena iŋit ŋgamma, an mbuŋa rurena.” ");
INSERT INTO gai_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ri, Wɨktɨtɨkna Ra ianna Iesusapa mana iŋa raŋgairena ramtaɨra witna warɨŋ rɨkca taŋri. Na mana iŋa raŋgairena ramtaɨra mina anna witna lour maaŋgɨat. ");
INSERT INTO gai_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Karica Parisina ramtaɨra mamo gainda digiatna, “U warac, Wɨktɨtɨkna Ra, mina aiŋa mba morena. Na kaina moca una iŋa raŋgairena ramtaɨra an Wɨktɨtɨkna Ramo aiŋa moapekna? An tɨpna kirara anna wandɨk.” ");
INSERT INTO gai_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ri, ma minmo gaind marutiat, “Atua Dewitta moatna reacna nininia Raraŋ Aetaniacna timbigta kap ndeacrinanna, ne anna mba watri, a? Na aku Dewitapa mana ramtaɨrap mina nikembwataica eacrena kam ndoprena. ");
INSERT INTO gai_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Na an mɨnna Abiatara ma taup ndamoot paŋan aniac ndeacri, Dewitta ma Raraŋ Aetaniacna Ndamma mbukca, ma an tapacar mina Raraŋ Aetaniacna outta tɨkrenanmo ma aŋgɨca ambca, ma ndona ramtaɨrmo neaŋga mina ambrina. Na an tapacar anna wandɨk, taup ndamtaɨr tiŋgikca ndori anmo ambrenan. Na ne an kamma mba watre ki, a?” ");
INSERT INTO gai_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ri, ma minmo gaind mac mbopatna, “Raraŋ Aetaniaca ma meikramtaɨrmo Wɨktɨtɨkna Ramo otacna mba tɨkrina, wanaiŋ, ma Wɨktɨtɨkna Ramo meikramtaɨr otacna tɨkrina. ");
INSERT INTO gai_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Aintik Ramootna Nuoca ma Wɨktɨtɨkna Rana Kacoot.” ");
INSERT INTO gai_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Karica Iesusa Iudananta mimitpac aŋgɨrena kaca mac nda taŋgatna. Na par gagar waŋembaia menacrina ramoot ianna, ma an ndeacrina. ");
INSERT INTO gai_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Na ramtaɨr ndeida Iesusna ŋginaŋa matau ŋgoin mamori, moca ma an ramootmo an Wɨktɨtɨkna Ra, mamo mo laŋa moit, co wanaiŋ. Na Iesusa ainda mo te, mina mamo ritri waparaca monande. ");
INSERT INTO gai_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ainda moca ma an par ŋgoreacna ramootmo aindopatna, “U ŋgepca gan nakɨpca, gan meikramtaɨr wɨtna lamnik ndaru wɨtɨk.” ");
INSERT INTO gai_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ri, ma minmo gainda digirina, “Aia tɨp laŋa Wɨktɨtɨkna Ra moit ki? Co, aia tɨp ŋgoreaca moit? Co, aia meikramtaɨrmo otacnan, co, aia minmo mo menacnan?” Na ramtaɨrta ianna mana kamma mba rutiatke. ");
INSERT INTO gai_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ainda moca ma mina watca, ma nikkatacarica, mina iroara gagrar koind, aintik ma minmo kadmaica, ma an ramootmo aindopatna, “U ndona parmo lotai.” Ri, ma ndona parmo lotairi, mana para laŋ mamoat. ");
INSERT INTO gai_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ainda moatke, Parisiara anna watca, mina tawi ŋgoinna an kac inik tɨkcarica, mina laruca, mina taŋga Erotna tumbunap tɨkca mina mana mo menacna kam leacrina. ");
INSERT INTO gai_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Karica Iesusapa mana iŋa raŋgairena ramtaɨra an auŋ tɨkcarica mina Galili mɨar mataŋgat. Na meikramtaɨrta tumbun aniaca mana iŋa raŋgaica mataŋgat. ");
INSERT INTO gai_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Ri, an auŋemb anikpaikta meikramtaɨra kɨprinanna, anna Ierusalem auŋ aniacnan, Tairnanapa Saidonnan, na kabena pitrik waŋnan toco kɨprinanna, anna Galilinan, na Iudianan, na Idumeanan, na Iodan ocna pitrik waŋmbainan, anna meikramtaɨrta wiwit aniac ŋgoinna kɨprinan, mina man mbopatna reikta kambapa, man morina reikta moca mina kɨpca mamo mapuniat. ");
INSERT INTO gai_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ainda moca ma ndona iŋa raŋgairena ramtaɨrmo aindopatna, “Meikramtaɨrta tumbun aniac ŋgoinna maeacreke, aintik ne kor ianna aŋgɨrca kocro, moca mina aukmo mɨkca ndiaŋ te, aku an kor naŋgabuknande.” ");
INSERT INTO gai_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Na ŋgaua ma roumbbebta meikramtaɨr wɨt aniacmo roumbbebtanna moa laŋa mori, aintik an roumbbebapnanna, mina ndorita par mbuŋmo man ŋgutiŋna morina, ainda moca mina an kabena meikramtaɨrmo ndiaŋ te, mina man ndambuŋa taŋi rambuŋaina moca mori. ");
INSERT INTO gai_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Na an ŋerŋgaur ŋgorikca manmo watca, mina tutpemb rɨmbɨtca, mina kamb keca aindoprina, “U Raraŋ Aetaniacna Nuoc.” ");
INSERT INTO gai_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ainda moca ma an ŋerŋgaur ŋgorikmo wandɨk gargar ŋgoin matɨkat, na mina mamo raekca kai mo laru teac, ma mandai ŋgoin. ");
INSERT INTO gai_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Karica Iesusa takur tamuŋ nagacatke, ma ramtaɨr ndeidmo larapaca, ndoap eacna moca ma an ramtaɨrmo aca mina man ndambuŋ makɨpat. ");
INSERT INTO gai_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Na ma larapacrina ramtaɨrta ndunduca parniŋapa mbut mbuniŋna mɨn, mina manap eacnande. Ri, ma minmo, mana up aŋgɨrena ramtaɨrta i matɨkat. Te, ma minmo mandaca mina Raraŋ Aetaniacna kammo wiwitina. ");
INSERT INTO gai_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Na ma minmo ŋerŋgaur ŋgorikca mo kecarina gagrarapa iremb anikmo neaŋrina. ");
INSERT INTO gai_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Na ma larapacrina parniŋapa mbut mbuniŋna mɨnna ramtaɨrta irembca gaind, ianna Saimon, na ma manmo i Pita matɨkat. ");
INSERT INTO gai_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Na ma Sebedina nuocniŋ motocmo ma larapacrina, ianna Iemis, na mana lapmbitaca Ion. Na ma maniŋmo i Boanerges matɨkat, na an ina mɨnɨŋa gaind, “Meikramtaɨra riacapa weperacna mɨtmɨta morena kirar toc.” ");
INSERT INTO gai_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ri, ma gan ramtaɨr motocmo ma larapacatna, Andru, Pilip, Batolomiu, Matiu, na Tomas, na Iemis, ma Alpiusna nuoc, na Tadias, na Saimon ma Selotna wiwitna ramoot ian. ");
INSERT INTO gai_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Na Iudas Iskariot, ma ande an ramoot, iŋmbaia ma Iesusmo, ramtaɨrta para tɨkca mina manmo mo ŋgocrainande. ");
INSERT INTO gai_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Karica Iesusa kaca taŋgatke, meikramtaɨrta tumbun aniaca mac kɨpca mapuniri, na manapa mana iŋa raŋgairena ramtaɨrpaikca, mina gagamna urpemb kocor. ");
INSERT INTO gai_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ri, mana aemmapa laiplacara an reikca ma morinanna waracatke, mina man aŋgɨ nakɨprina, na mina gaindopatna, “Ma ŋaŋaorina.” ");
INSERT INTO gai_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Karica tɨpemb wandik tamŋirena ramtaɨr ndeida, Ierusalem ndiŋ ŋgirikca, mina gaindopatna, “Belsebula manap maeacreke. Aintik ma Belsebulna gargar mbuŋa ŋerŋgaur ŋgorikca moa kecarirena. Na ma ŋerŋgaur ŋgorikta ramoot paŋan.” ");
INSERT INTO gai_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ri, Iesusa minmo aca kɨpca ndona kɨtɨmma tɨkca, ma minmo kamb rour ndeid makeat. Na ma minmo aindopatna, “Ramoot Mbɨkca titoca tɨkca ndomo, nda mo kecarit? ");
INSERT INTO gai_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Aintik pitrik waŋ ianna meikramtaɨra titaca, wiwit mbuniŋ ndaruca, mina ruŋ te, an pitrik waŋa ma mba gagraca eacitndai. ");
INSERT INTO gai_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Na kamin ianna titaca, wiwit mbuniŋa ndaruca, mina ruŋ te, an kaminna mina mba gagraca eacitndai. ");
INSERT INTO gai_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Aintik Ramoot Mbɨkca ndo titaca, mana tumbun toco titac te, mina mba gagraca eacitndai. Mina kocnai topnandet.” ");
INSERT INTO gai_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ri, ma gaind mac mbopatna, “Ramoot ianna, ramoot gargarna kaca mbukca mana reik aŋgɨna toawanaiŋ. Outta ma an ramootmo ŋgatɨk gargar mbuŋa leac te, ma ainda mo te, ande ma an ramootna reikca kac inik ndeacrenanmo aŋgɨnandet.” ");
INSERT INTO gai_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Aintik ma aindopatna, “Aku nenmo gidik ŋgoin mambopek, Raraŋ Aetaniaca ma meikramtaɨra muruŋcamiŋa morena tɨpemb ŋgorikta makukarapa Raraŋ Aetaniacmo peperena kamb ŋgorik ndoprenanmo, ma mo kecarinandet. ");
INSERT INTO gai_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Na ramootta Ŋeroŋ Ratmo peperena kam ŋgoreac ndop te, Raraŋ Aetaniaca mana tɨp ŋgoreacna makukca mba mo kecariitndai. Na an tɨp ŋgoreacna makukca manap iarwar ndeacraŋnandet.” ");
INSERT INTO gai_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Na an mɨnɨŋna moca mina manmo gaindopatna, “Ma ŋeroŋ ŋgoreacap.” ");
INSERT INTO gai_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Na an kɨdrɨkca Iesusna aemmapa laipitikca kɨpca malaruat. Ri, mina raekca wɨtɨkca manmo kam neaŋga taŋca manmo min ndambuŋ nakɨpna moca. ");
INSERT INTO gai_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Na mana kɨtɨmma mbiraca korererina meikramtaɨrta tumbun aniaca mina mamo gaindopatna, “Una aemmapa laipitikca raekmbai, na mina una moca digirina.” ");
INSERT INTO gai_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ri, ma mina kammo rutica gaindopatna, “Mandaibinna ndori aukna amerapa laiplacar?” ");
INSERT INTO gai_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Karica ma an mana kɨtɨmma mbiraca korererina meikramtaɨrmo watta korereri, ma gaindopatna, “Mandaibinna gan ndeacrenanna, mina aukna amerapa laiplacar! ");
INSERT INTO gai_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Na mandaibinna Raraŋ Aetaniacna toŋtoŋa raŋgairenan, anna mina aukna amerapa, mbiarpaikapa laiplacar.” ");
INSERT INTO gai_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Karica Iesusa meikramtaɨrmo ririptina aiŋmo mɨar roumbca tɨkca mac moa ŋgeprina. Ri, meikramtaɨr wɨt aniac ŋgoinna man ndambuŋ makɨpat. Ainda moca ma an mɨar roumbna kor ian naŋgabukca an mambiracat, ri, meikramtaɨra muruŋa an mɨar roumbmo mbatmbai maeacri. ");
INSERT INTO gai_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Na ma minmo kamb rour ndeid puŋga keca, mimo mariptiat. Na ma minmo kam roor ianmo gaind makeat, ");
INSERT INTO gai_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Ne warac, ramoot ianna ma wit lourmo warɨŋna kena moca mataŋgat. ");
INSERT INTO gai_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Na ma an warɨŋmo, witna lourmo aŋgɨrca keca mataŋri, na lour ndeida, mina an taŋ, kɨp tɨkrena taup ŋgirikca, ŋgorikca kɨpca maammbat. ");
INSERT INTO gai_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Na witna lour ndeida, an tiacarpaikca watura mana kaŋgauk ndeacrinan nambat mairikat, aintik ma tawina magat. ");
INSERT INTO gai_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ainda moca ra gacatke, ma an witna lour garenanmo moca mina marereri. Na mina iacndukara kacrir kocor, aintik mina maguruat. ");
INSERT INTO gai_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Na witna lour ndeida, mina an lacarta katgarap kuria gaca, na an lacarta katgara gaca minmo wɨŋga kɨtaca mina mba kootatke. ");
INSERT INTO gai_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ri, ndeida tiacarpaik waekeke laŋ ŋgirikca, mina amna reaca makotat. Na ndeida 30na mɨnna kootrina, ri, ndeida 60na mɨnna kootrina, ri, ndeida 100na mɨnna kootrina.” ");
INSERT INTO gai_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ainda moca ma minmo aindopatna, “U ramootta koarap, u gan kamma warac.” ");
INSERT INTO gai_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Karica an meikramtaɨr wɨt aniaca taŋgatke, mana iŋa raŋgairena ramtaɨrpaikapa, manap eacrena ramtaɨra, mina mamo an kam roorna mɨnɨŋna madigiat. ");
INSERT INTO gai_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ri, ma minmo gaindopatna, “Raraŋ Aetaniaca ma nemo mana iŋgoroca eacrena bubuocna kamma ma nenmo wandacrina. Na an raekmbai ndeacrena meikramtaɨra, mina an kammo muruŋcamiŋa kam roor mbuŋa waracnande. ");
INSERT INTO gai_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Aintik Raraŋ Aetaniacna timbigta kapna kamma aindoprina, ‘Mina memetmbaca watraŋnandet, na mina reac ianna mba watta garacitndai. Na mina kamma memetmbaca waracraŋnandet, na mina mana mɨnɨŋa mba garacitndai. Moca mina iroar inkar uriraca, Raraŋ Aetaniaca mina tɨpemb ŋgorikta makukarmo mo kecarinande.’” ");
INSERT INTO gai_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Karica ma ndona iŋa raŋgairena ramtaɨrmo gaindopatna, “Kaica ne an kam roorna mɨnɨŋa lamŋi ŋgocor? Na titoca mo te, ne an kabena kamb rourta mɨniŋ nagaracit? ");
INSERT INTO gai_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Na an ramootta wit loura kerinanna, anna ma warɨŋna amna reac mutocrina kirar toc, na ma Raraŋ Aetaniacna kam mutocrina. ");
INSERT INTO gai_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Na meikramtaɨr ndeida, mina an wit loura taup ŋgirikrina kirar toc, mina Raraŋ Aetaniacna kamma waracri, na tawi ŋgoinna Ramoot Mbɨkca kɨpca an Raraŋ Aetaniacna kamma mina iro inikca eacrenanmo, ma mo kecarinande. ");
INSERT INTO gai_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Na meikramtaɨr ndeida mina an tiacarpaikca watura mana kaŋgauk ndeacrenan nambat ŋgirikatna witna lourta kirar, aintik ma tawina magat. Ainda moca mina Raraŋ Aetaniacna kamma waraca, mina iroar inkara tawina maaŋgɨat, na mina toŋtoŋgar koindap. ");
INSERT INTO gai_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Na mina kacrir kocor. Ainda moca an mɨnna meikramtaɨra minmo Raraŋ Aetaniacna kammo ipuŋi mbop te, na minmo makukara neaŋ te, mina rɨtɨpaikca tawi ŋgoinna ŋgiriknande. An meikramtaɨra mina mba gagraca eacitndai. ");
INSERT INTO gai_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Na meikramtaɨr ndeida mina an witna loura lacarta ŋgaɨrta kɨdrɨk ŋgirikca garinanna kirar toc. Na an meikramtaɨra mina kam mbaracrena. ");
INSERT INTO gai_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Na mina gan tiacarpaikna reik laiŋta moca landamŋi aniac ŋgoinna morenan, na mina kituknduk aŋgɨca wembacna iroar anikap, na mina reik laiŋ aŋgɨna toŋtoŋgarapnan. An reikca mina iroar wɨŋga kɨtaca mina Raraŋ Aetaniacna kammo mba aŋgɨitndai. ");
INSERT INTO gai_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Na meikramtaɨr ndeida, mina an witna loura tiacar laiŋpaik ŋgirikrina kirar toc. Na mina kamma waracri, mina aŋgɨca ndorita iroar inkara tɨkrina, na mina gagamma aŋgɨnande. Ndeida 30na mɨn, na ndeida 60na mɨn, na ndeida 100na mɨnna gagam aŋgɨnande.” ");
INSERT INTO gai_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Karica ma ndona iŋa raŋgairena ramtaɨrmo gaindopatna, “Tacna memetaca mina aŋgɨca bar, co wɨnna kaŋgaukca tɨkit ki? Wanaiŋ ŋgoin, mina an tacna memetacmo aŋgɨca waekekena taupca tɨkrena. ");
INSERT INTO gai_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Aintik reikca muruŋa iŋgoroca eacrenan, iŋmbaia mina raek ndarunande. Na reikca meikramtaɨra kɨtaca tamaia eacrenan, iŋmbaia mitoco raek ndarunande. ");
INSERT INTO gai_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ainda moca ramootta koarapnanna, ma gan kammo koar tɨkca warac.” ");
INSERT INTO gai_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Karica ma minmo gaind mac mbopatna, “An kamma ne waracrenanna, anna ne matau ŋgoin ndamŋi. Na ne meikramtaɨrmo neaŋrina reikta ŋgaŋganŋgɨna mɨnna, an ŋgaŋganŋgɨna mɨnna kirara Raraŋ Aetaniaca nenmo nda neaŋnande. Te, ma nenmo emtemma an nambatta tɨknandet. ");
INSERT INTO gai_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Na ramoot ianna reik ndeidapnan, Raraŋ Aetaniaca mamo kabenan mac neaŋnande. Aintik ramootta reik kocortan, Raraŋ Aetaniaca an reik motimbba, manap eacrenanmo ma nda aŋgɨnande.” ");
INSERT INTO gai_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Karica Iesusa kam roor ianna gaind mac keatna, “Raraŋ Aetaniacna bubuoca, ma an ramootta witna lourmo ndona witna warɨŋ nakerina kirar toc. ");
INSERT INTO gai_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ainda moca mouŋembba ma ŋgorena, na raia ma ŋgepca ma ndona aiŋira morena, na an witna loura an warɨŋ inikca titoc nagacrenanna ma mba lamŋirena. ");
INSERT INTO gai_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Na an witna loura garenanna, anna tiacarpaikca ndo moca mina garena, taŋca amna reac kootrena. Out ŋgoinna raprira laruca, taŋi ma kootca mina loura moca, iŋmbaia mina uri taŋca amna mɨnna tɨknande. ");
INSERT INTO gai_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Na mina urica taŋca gagamna mɨnna tɨk te, min aŋgɨ waŋgopna ra laru te, an ramootta ma waca aŋgɨnandet.” ");
INSERT INTO gai_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Karica Iesusa gaind mac mbopatna, “Raraŋ Aetaniacna bubuoca aia titocna reac toc ndopit. Na aia manmo titocna kam roor mbuŋ nakecit? ");
INSERT INTO gai_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Na Raraŋ Aetaniacna bubuocna wapatna kirara, ma ik mastetna loorna kirar toc, na mana loorca tekernoc ŋgoin, na mina manmo tiacarpaik inikca mutocrena. Na ma kabena ikirta lourmo ma tekernoc ŋgoin. ");
INSERT INTO gai_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Na mina mamo mutoc te, ma gaca ik aniac ndarurena. Na ma ŋaik anik tɨkreke, ri, ŋgorikca kɨpca ndorita kaikca mana ŋaikta pacpacarta kaŋgaukca tɨkna morena.” ");
INSERT INTO gai_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ainda moca Iesusa Raraŋ Aetaniacna kammo meikramtaɨrmo kamb rour wɨt puŋ nakerina, na ma gainda wiwitirinanna, ma mina landamŋiarta mɨn mbuŋ nakerena. ");
INSERT INTO gai_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Na meikramtaɨrmo ma minmo kamb rour niŋgik mbuŋa keca riptirena, na ma minmo mana mɨnɨŋmo ma mba mbopca larurenanna. Ainda moca ma ndona iŋa raŋgairena ramtaɨrap eac te, ma minmo an kamb rourta mɨniŋmo ma minmo muruŋcamiŋa mbopca larurena. ");
INSERT INTO gai_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Karica an rana wigwacmbaina mɨn mbuŋa, Iesusa ma ndona iŋa raŋgairena ramtaɨrmo gaindopatna, “Aia mɨarmo monmbai waŋ nagacna.” ");
INSERT INTO gai_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ainda moca mina an meikramtaɨrta tumbun aniaca tɨkcarica, mina man mbiraca eacrena kor mbuŋ naŋgabukca, mina manap aŋgɨca mataŋgat. Na kabena kour ndeid toco minap mataŋgat. ");
INSERT INTO gai_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Na watapa murmur aniac ianna makɨpat, ri, macaitta mina kormo putria mbukri, mina kormo moa bururuna morina. ");
INSERT INTO gai_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Na Iesusa kormo iŋcait ndeacri, na ma memeracna reac nambatta meraca ŋgori, mina manmo omboŋga ŋgepca gaindopatna, “Riripti, aia maica ŋgocraina mamoek, na aia menacna mamoek, na u aina kakadmaiap ki, wanaiŋ?” ");
INSERT INTO gai_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Aindopatke, ma ŋgepca watapa, murmur aniacapa macaitmo, kaega moca gaindopatna, “Ma mɨn, ne mamairi, na ne irik merac.” Ri, watapa murmura mairi, na macait toco nuknukir kocor. ");
INSERT INTO gai_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Karica ma ndona iŋa raŋgairena ramtaɨrmo ainda digiatna, “Kaina moca ne nanambirena? Na ne mba rɨpacre ki, a?” ");
INSERT INTO gai_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ainda moca mina rugdar moca, ndori puŋga gaindopatna, “An ramootta, ma mandai ŋgoin, na watapa macaitta mana kammo waracapekna?” ");
INSERT INTO gai_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Karica Iesusapa mana iŋa raŋgairena ramtaɨra mina Galili mɨarmo kataca, waŋgembai magat, na anna ma Gerasananta pitrik waŋmbai ndeacrena. ");
INSERT INTO gai_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ri, Iesusa kor tɨkcarica gaca wɨtɨkatke, ŋeroŋ ŋgoreaca mbukca eacrina ramootta muk ndeacrinanna, ma tawi ŋgoin motemma man ndambuŋa ootta kɨprina. ");
INSERT INTO gai_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Na an ramootta ma warir mutocrena mukna roumb ndeacrena, na ramoot ianna manmo ŋgatɨk mbuŋa leacna towanaiŋ, co lawirta ŋgatɨk mbuŋa leacna mɨnna wanaiŋ. ");
INSERT INTO gai_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ainda mori, memetmbaca ramtaɨra mana parniŋapa orniŋmo an lawirta ŋgatɨk mbuŋa leacri, na ma anmo ma moa katacrena, na ramoot ianna manmo muoc, iriki mbiracna mɨnna wanaiŋ, ma gargar ŋgoin. ");
INSERT INTO gai_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ainda moca mouŋ, ra, an ramootta an mina ramtaɨrta warir mutocrena mukna roumbapa takur tekerna roumbmo tamtamma ndada taŋrena. Na ma kamb anik keri, na anna watura mana tikmo katacrena. ");
INSERT INTO gai_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Na ma wattatnanna Iesusa mon tawan ŋgoin nakɨpri, karica ma ootta taŋga Iesusna outta taŋga, mana outta tɨkca paŋan ramtukca tutupniŋ marɨmbɨtat. ");
INSERT INTO gai_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Karica an ramootta kam aniac keca aind mambopat, “Iesus, u Tamuŋ Ŋgoin ndeacrena Raraŋ Aetaniacna Nuoc, u aukmo kaia mona moek? Na aku unmo Raraŋ Aetaniacna i mbuŋa digina mamoek, u aukmo gɨrgɨr ianna kai neaŋ teac!” ");
INSERT INTO gai_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Na an ramootta aindopatna mɨnɨŋa gaind, Iesusa an ŋeroŋ ŋgoreacmo mboprina, “U ŋeroŋ ŋgoreac, u an ramootmo tɨkcarica laru!” ");
INSERT INTO gai_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Karica Iesusa manmo madigiat, “Una ia mandai?” Ri, ma rutica gaindopatna, “Aukna ia Wɨt, aintik ŋerŋgaur ŋgorik wɨt aniaca aukap eacrena.” ");
INSERT INTO gai_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Karica ma Iesusmo aemaŋmaŋap iŋambutta mambopat, ma minmo kai mandaca mina an pitrikmo kai tɨkcarica taŋ teac. ");
INSERT INTO gai_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Na markɨmta tumbun aniaca, an takur roumbmo ambca taŋri. ");
INSERT INTO gai_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ri, an ŋerŋgaur ŋgorikca Iesusmo aemaŋmaŋap gaind mambopat, “U aimo mandaca aia mon markɨmbca mbukna, te, aia mina mbukna.” ");
INSERT INTO gai_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Karica mina aindopatna mbatca, Iesusa minmo ainda moa mandacatna, mbatca an ŋerŋgaur ŋgorikca, an ramootmo tɨkcarica taŋga an markɨmbmo mbukatke, na an markɨmta tumbunna ŋgaŋganŋgɨa 2,000na mɨn, na mina an takur tamuŋ ŋgetacndiŋa aŋgɨa ootta irikca an pacpɨkɨnna mɨara pukca, puk ambca menaca mamaiat. ");
INSERT INTO gai_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ainda moatke, an markɨmta ŋginaŋa morina ramtaɨra kɨpcamacariat. Na mina taŋga an auŋ aniacapa an pitrikna auŋembta meikramtaɨr muruŋcamiŋmo an reacna kam ndopa, mina kɨpca an laruatna reaca watna moca. ");
INSERT INTO gai_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ri, an meikramtaɨra kɨpca Iesus ndambuŋ ndaruca watri, an ramootta, ŋerŋgaur ŋgorikca mbukca eacrinanna, ma ndona tik ŋgapaoc aoca iro laŋapa mbiraca eacri, na mina ainda watca nanambiatna. ");
INSERT INTO gai_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ainda moca an meikramtaɨr mandaibinna an laruatna reaca wattatnanna, mina taŋga, kabena meikramtaɨr ndeidmo, an ŋerŋgaur ŋgorikca mbukca eacrina ramootna kammo ninia mboprina. Na mina an markɨmta kam motoco ninia mbopatna. ");
INSERT INTO gai_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ainda moatke, an pitrik waŋna meikramtaɨra ŋgepca Iesusmo an pitrik waŋ tɨkcarina moca aemaŋmaŋap mambopri. ");
INSERT INTO gai_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ainda moca maica Iesusa kor naŋgabukna mori, ŋgaua an ŋerŋgaur ŋgorikca mbukca eacrina ramootta Iesusa moa laŋa moatna ramootta, ndomo Iesusap taŋna moca aemaŋmaŋap madigiat. ");
INSERT INTO gai_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ri, Iesusa manmo mba wattacarica ma mba taŋgatke, ma an ramootmo aindopatna, “U ndona kaca nda taŋca ndona wiwitmo mbop warac, titocna reik muruŋa Kacootta unmo kakadmaina opotaca morinan.” ");
INSERT INTO gai_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Karica an ramootta ŋgepca taŋga, an pitrik Dekapolisnanmo, ma minmo an kam wembaŋ laŋa Iesusa manmo moa laŋa moatna, ninia mbopca taŋri, na meikramtaɨra muruŋcamiŋa waraca tamtam malamŋiat. ");
INSERT INTO gai_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Karica Iesusa kor naŋgabukca, mɨarmo monmbai waŋ nagacat, na ma mɨarna roumb ndeacri, na meikramtaɨrta tumbun ianna manmo mac kɨpca aumb mamoat. ");
INSERT INTO gai_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ri, an Iudananta mimitpac aŋgɨrena kacna ramoot paŋan ianna mana ia Iairus, ma kɨpca anna tɨkca Iesusmo watca ma Iesusna outmo ma tutupniŋ marɨmbɨtat. ");
INSERT INTO gai_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Karica ma iŋambut ŋgoinna aemaŋmaŋap mambopri, “Aukna mooŋa ma menacna mamoek. Aintik u kɨpca ndona parmo man nambatta tɨk te, ma ndona wat mac nda aŋgɨca eacna.” ");
INSERT INTO gai_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ri, Iesusa ŋgepca an ramootap mataŋgat. Na meikramtaɨrta tumbun aniaca mana iŋa raŋgaica taŋri, ndorimo mana kɨtɨmma tɨkca aumba moca ratapaca moa mataŋri. ");
INSERT INTO gai_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Na an meikramtaɨrta rɨkca meac ianna memetmbaca ma meikpitikta karwaina roumbap, na an roumbca manmo aŋgɨca eaca taŋga iarira parniŋapa mbut mbuniŋna mɨn mbuŋ. ");
INSERT INTO gai_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Na an meac, ma an pitir gagamarmo kitukndukar anik puŋga ŋgoikri, na mina an meacmo moi laŋa mo ŋgocor, wanaiŋ ŋgoin, mina manmo gɨgɨrar neaŋrenan, na mana an roumbca mina manmo mba moa laŋa mori, wanaiŋ ŋgoin. ");
INSERT INTO gai_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ri, an meaca Iesusa kɨprina kam wembaŋa waraca, ma kɨpca an tumbun aniacna rɨk ndeaca, Iesusna iŋmbaia taŋca mana tik ŋgapaoc rocotmo pipikri, ");
INSERT INTO gai_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","na ma gaind ndamŋiatna, ma Iesusna tik ŋgapaoca pipik te, mana roumbca laŋa monande. ");
INSERT INTO gai_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ri, ma ainda moatna mbatca mana racainda anduna katacatke, ma ndona tik maraŋgaiat, mana roumbca laŋ mamoat. ");
INSERT INTO gai_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ainda moatke, Iesusa malamŋiat, mana gargara laruca mataŋgat, na ma uriraca minmo, madigiat, “Mandaia ndo aukna tik ŋgapaocmo pipikapekna?” ");
INSERT INTO gai_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ri, mana iŋa raŋgairena ramtaɨra mamo gaind mambopat, “U wat, meikramtaɨr wɨt ŋgoinna unap tɨkca ndada rapacrenan, na u madigiek, mandaia ndo unmo pipikapekna?” ");
INSERT INTO gai_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Na Iesusa kocnaia meikramtaɨrmo watta korereri, mandai ŋgoinna ndo manmo pipikrina. ");
INSERT INTO gai_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Karica an meac mbitaca ma lamŋiatna, an reaca manmo laruapekna, na ma kɨpca Iesusna out ŋgirikca tutupniŋ rɨmbɨtca nanambia nekca ma Iesusmo kamb gidkara muruŋ mambopat. ");
INSERT INTO gai_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ri, ma an meac mbitacmo gaind mambopat, “Mooŋmbitac, u aukmo rɨpacri, aintik u laŋ mamoat. Na u taŋca una nikinik iro wetwet ndeac. Na una roumbca laŋ mamori.” ");
INSERT INTO gai_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Na an mɨnna Iesusa an meacap mbopreke, ramtaɨr ndeida an Iairusna kac ndiŋ nakɨpca mina an ramoot paŋanmo gaind mambopat, “Una mooŋa mamenacri, aintik u ririptimo aiŋ wanaiŋa kai neaŋ teac.” ");
INSERT INTO gai_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ri, Iesusa an ramtaɨr mbopatna kamb mbaraca, ma an Iudananta mimitpac aŋgɨrena kacna ramoot paŋanmo aind mambopat, “U kai nanambi teac, u rɨpac niŋgik.” ");
INSERT INTO gai_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ainda moca ma meikramtaɨrmo manap taŋnarica wandɨk tɨkca ma Pitaapa, Iemisapa mana lapmbitac Ionap, na min mbonkac niŋgikmo aca aŋgɨra mina manap mataŋgat. ");
INSERT INTO gai_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ainda moca mina taŋga an Iudananta mimitpac aŋgɨrena kacna ramoot paŋanna kac ndaruca wattatnanna, meikramtaɨr wɨt aniaca punica gararar anikca mori, aea mboracarica. ");
INSERT INTO gai_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ri, Iesusa an kaca mbukca minmo gaindopatna, “Ne kaina moca gararar anikca moca aerena? An mooŋa, ma mba menacreke, ma maŋgoreke.” ");
INSERT INTO gai_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Na mina manmo malaroŋgat. Ainda moatke, Iesusa minmo mbopca mina kacmo tɨkcarica muruŋcamiŋa raekmbai ndaruatke, ma an mooŋnuocna amepaetniŋapa mana iŋa raŋgairena ramtaɨr mbonkacap aŋgɨca, mina an mooŋna waɨr tɨkca eacrina diab mambukat. ");
INSERT INTO gai_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ri, mina mbukca Iesusa an mooŋna par ŋgutiŋga, na gan kam tɨp mambopat, “Talita, koum.” Na an kam tɨpna mɨnɨŋa gaind, “Meac teker u ŋgep!” ");
INSERT INTO gai_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ri, an mooŋa anduna ŋgepca taŋ kɨp tɨkri, na mina anna watca ŋgep ŋgoreac naŋgepca tamtam malamŋiat. Na an mooŋna iarira parniŋapa mbut mbuniŋna mɨn. ");
INSERT INTO gai_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Karica Iesus minmo an laruapekna reacna kammo, kabena meikramtaɨrmo mbop narica makɨracat. Ri, ma minmo an mooŋmo amna reac, emtem neaŋca amna mbopatna. ");
INSERT INTO gai_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Karica Iesusa an auŋ tɨkcarica ma ndona auŋ mɨnɨŋ mac nda taŋgatna. Na mana iŋa raŋgairena ramtaɨra mana iŋmbai mataŋgat. ");
INSERT INTO gai_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Na Wɨktɨtɨkna Ra, ma taŋga Iudana mimitpac aŋgɨrena kaca mbukca meikramtaɨrmo Raraŋ Aetaniacna kam riptiatke. Na meikramtaɨr wɨt aniaca an kam mbaraca, ŋgep ŋgoreac naŋgepca mina gaindopatna, “An ramootta ma an kammo tenna tɨkca aŋgɨratna? Na an landamŋi man ndambuŋ ndeacrenanna, anna titocna landamŋi? Na titoca moca ma ainta ŋgagatracarap morena? ");
INSERT INTO gai_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Aia lamŋirena. An ramoot ma reikta muindira morena ramoot, na ma Mariana nuoc, na mana laipitikca Iemisapa, Iosepapa, Iudasapa Saimon, na mana mbiar toco gade aiap maeacreke.” Mina aindopca manmo iro ŋgoreac maaŋgɨat. ");
INSERT INTO gai_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ri, Iesusa minmo gaindopatna, “Ramma morena ramootta auŋembmo ma i aniacap eacrena. Na mana auŋ mɨnɨŋ ŋgoinapa, mana racaindpaiknandapa, mana kacnɨm ŋgoinnanda, ma iremb kocor.” ");
INSERT INTO gai_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Aintik ma an auŋmo ainta ŋgagatrac ianna gidikca mba mac moitndaiit. Ma roumbbebta meikramtaɨr kaukimo par mbuŋa mina tikemb tiŋgik ŋgutiŋ te, minmo moi laŋa monande. ");
INSERT INTO gai_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ri, ma ndoa rɨpac ŋgocorta meikramtaɨrta moca tamtam pac malamŋiri. Iesusna iŋa raŋgairena ramtaɨra manmo wat rapac ŋgocor (6.6—8.21) Ainda moca Iesusa an kɨdrɨkna auŋembmo taŋga kambmo anna riptirina. ");
INSERT INTO gai_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ri, Iesusa ndona iŋa raŋgairena ramtaɨr parniŋapa mbut mbuniŋmo aca kɨpca, ma minmo ŋerŋgaur ŋgorikca mbukca eacrena meikramtaɨrtanmo, moa kecarina gagrar neaŋga, na minmo mbuniŋ, mbuniŋa mbagɨrica mataŋgat. ");
INSERT INTO gai_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Na ma minmo gaindopatna, “Ne ndorita kombroormo ndɨpaca taŋrena ndɨndɨpacarmo aŋgɨ taŋ. Na ne kabena tataŋna reikap kai aŋgɨca ndoriap kai taŋ teac. Na ne tapaca kai aŋgɨ teac, na ne ndorita aŋgɨra taŋrena rambca kai aŋgɨ teac, na ne kitukndukap kai aŋgɨca taŋ teac, kari ŋgoin. ");
INSERT INTO gai_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Na ne or ŋgapaocniŋ aocrenan, anna laŋ, an niŋgik aoc. Na ne tik ŋgapaoc mbuniŋa kai aoc teac.” ");
INSERT INTO gai_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ri, ma minmo gaind mac mbopatna, “Ne taŋi auŋ ian ndaruca kacnɨm ianna mbukca mbiracek, ne an niŋgik ndeaca, taŋi ne an auŋ tɨkcarica taŋ. ");
INSERT INTO gai_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Na auŋemb ndeida mina nenmo mina kaiknimbca actɨk ŋgocor ndacari te, na mina nena kamma warac ŋgocor, te, ne an auŋ tɨkcarica taŋ. Na maica ne taŋna naŋgepek, ne ndorita orniŋna tiacar kacopca ne taŋ, te, mina lamŋinandet, mina an tɨpna kirara laŋa mba moapeke.” ");
INSERT INTO gai_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Karica mana iŋa raŋgairena ramtaɨra ŋgepca taŋga meikramtaɨrmo an kam wiwitia mambopat, “Ne ndorita iroar inkar ŋgetriki.” ");
INSERT INTO gai_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Na mina ŋerŋgaur ŋgorikcap eacrena meikramtaɨr wɨt aniktanmo moa kecariatke, na roumbbebta meikramtaɨr wɨt aniktanmo tabaɨr ndikca minmo moa laiŋ mamoat. ");
INSERT INTO gai_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Na gagrirta ramoot paŋan Erot, ma an kamma waracatnanna an reikca aind ndaruri, Iesusna ia an inikca aniac malaruat. Ainda moca meikramtaɨr ndeida aindopca, “An kɨtac puk neaŋrena ramoot Ion, ma menacatnanna, ma mac nda ŋgepatna. Aintik ma an gargar aŋgɨca ma an ŋgagatracara morena.” ");
INSERT INTO gai_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Na ndeida aind mambopat, “Anna Elaia.” Ri, ndeida aind mambopat, “Anna ramma morena ramoot, ma atuna rambca morina ramtaɨrta ramoot ianna kirar toc.” ");
INSERT INTO gai_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Na Erotta an kamma waraca, ma aindopatna, “Aku an ramoot Ion, mana logotta aku atuna wawɨratna, na mandeaca ma mac nda maŋgepri.” ");
INSERT INTO gai_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Na ŋgaua Erot ma ndona lapmbitac Pilipna meac Erodiasmo tapica laŋgorina. Ri, Ionna Erotmo gaindopatna, “U ndona lapmbitacna meac tapica laŋgoapekna tɨpna kirara, anna laŋa wanaiŋ.” Ainda moatke, Erotta an kam mbaraca ŋgepca ramtaɨrmo mbopca mina Ionmo utiŋga manmo lawirta ŋgatɨk mbuŋa leaca maica aŋgɨca taŋga kac ŋgoreac matɨkat. ");
INSERT INTO gai_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","20","Aintik Erot, ma Ion narica rugut morena. Na ma lamŋirena, Ionna ma Raraŋ Aetaniacna lamnɨac ŋgoutta, ma ramoot wandoŋ rat ndeacrena ramoot. Ainda moca Erotta ma Ionna ŋginaŋ mbatrena. Na Ionna kam ian ndop te, ma mana kamma waraca ma tamtam ŋgoin ndamŋiraŋnande, iro inik mananna makuk ŋgoin ndamŋiraŋnande. Na ma Ionna kamma waracna toŋtoŋ ŋgoinna morena. Na Erodias ma nikkatta ŋgocraica ndomo Ionna mo menacna ndamŋirinanna, na ma mɨnna wanaiŋ. ");
INSERT INTO gai_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Iŋmbaia Erodias ma taup ianna gainda watrina. Erot mana aemma mana mɨratna rana ndamŋica ma amtiam aniac ianna monande. Na an amtiam aniaca ma moeknanna, anna ma ndoap aiŋ kabea morena ramtaɨr paŋaindapa, lapoca ruŋrena ramtaɨr paŋaindapa, Galili inikna ramtaɨr paŋaindap amnande. ");
INSERT INTO gai_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Karica mina ambca eacri Erodiasna mooŋa kɨpca mbukca mina outta kemma weri. Na Erotap mbiraca ambrina ramtaɨra an mooŋa kemma werenanna watca mina toŋgocarica. Ainda moca gagrirta ramoot paŋanna an mooŋ ŋgammo madigiat, “Aku umo kai laŋ ŋgoin neaŋ te, u toŋgoit? U aukmo pac mbop te, aku umo neaŋnande.” ");
INSERT INTO gai_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ri, Erot, ma kam gargara manmo gainda babuca mambopat, “Gidik ŋgoin tamuŋ, u kaia toŋgoca digi te, aku umo neaŋnande. Na u aukmo gan tiacarpaik titac ndomo waŋgembai neaŋna ndop te, aku ainda monande.” ");
INSERT INTO gai_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ri, an mooŋa mac nda laruca taŋga ndona aemmo gaind madigiat, “Aku mamo kai aŋgɨna kam ndopit?” Na mana aemma aindopatna, “U taŋca manmo gaindop, u kɨtac puk neaŋrena ramoot Ionna paŋan wawɨrca aukmo mana paŋan neaŋ.” ");
INSERT INTO gai_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Karica an mooŋ ŋgamma tawina mac nda taŋca gagrirta ramoot paŋan ndambuŋ ndaruca manmo gaindopatna, “Aku toŋgorinanna, u mandebanna u kɨtac puk neaŋrena ramoot Ionna paŋan wawɨrca tuoŋ ianna tɨkca aukmo neaŋ.” ");
INSERT INTO gai_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ri, gagrirta ramoot paŋanna an kamma waraca mana iro inikca tamtam malamŋiat. Na ma ndona babua mbopatna kamna malamŋiat, na ma ndoap mbiraca ambrena ramtaɨra watri, ma mina lamnikmo numbir aniac aŋgɨ narica. Ainda moca ma an mooŋna kam mawaracat. ");
INSERT INTO gai_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ri, gagrirta ramoot paŋanna, ndona lapoca ruŋrena ramoot ian mbagɨrica manmo tawi taŋca Ionna paŋan aŋgɨ kɨpna ndopca an lapoca ruŋrena ramootta taŋga kac ŋgoreaca mbukca Ionna logotmo mawawɨrat. ");
INSERT INTO gai_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Karica ma Ionna paŋanmo tuoŋ ianna tɨkca aŋgɨra kɨpca an mooŋ ŋgammo neaŋca, ma aŋgɨca taŋca ndona aem maneaŋgat. ");
INSERT INTO gai_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ri, Erotta Ionmo ainda mo menacatna kamma waraca Ionna iŋa raŋgairena ramtaɨra kɨpca mana waɨr aŋgɨca taŋga mamutocat. ");
INSERT INTO gai_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Na Iesusna up aŋgɨrena ramtaɨra mina mac nda kɨpca man ndambuŋa mina manap puniri. Na mina ndori, morina aiŋirta kambca niniatke, na mina meikramtaɨrmo riptiatna kambca anmo muruŋ maniniat. ");
INSERT INTO gai_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ri, meikramtaɨr wɨt aniaca an motemma taŋ kɨp tɨkri, na Iesusapa mana up aŋgɨrena ramtaɨrap mina amta reik amna mɨnna wanaiŋ. Ainda moca ma ndona up aŋgɨrena ramtaɨrmo aindopatna, “Ne ŋgepca aia ndori tiŋgik ramtaɨr kocorta taup ianna taŋca ne wɨk emtem pac aŋgɨna.” ");
INSERT INTO gai_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Karica mina kor ian naŋgabukca ramtaɨr kocorta taup ianna, mina ndori tiŋgik mataŋgat. ");
INSERT INTO gai_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Na an meikramtaɨr wɨt aniaca mina watri mina taŋri, na mina minmo watta garacri. Ainda moca an auŋembta meikramtaɨra mina muruŋcamiŋa Iesusapa mana up aŋgɨrena ramtaɨr taŋca eacna taupca, mina atuna ootta taŋga laruca maeacri. ");
INSERT INTO gai_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Aintik Iesusa taŋga kor tundoca ma gaca wattatnanna meikramtaɨr wɨt aniaca muruŋa anna punica eacri. Na ma mina watca kakadmai aniac ŋgoin. Mina sipsiparta kirar toc, mina ŋginaŋa mona ramoot ian ŋgocor. Ainda moca ma minmo kamb wɨt ŋgoin riptiatna. ");
INSERT INTO gai_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Iŋmbaia ra maica irik mbukna ŋgirikri. Iesusna iŋa raŋgairena ramtaɨra kɨpca manmo gaind mambopat, “Ganna ramtaɨr kocorta taup, na ra maica irik mbukna mamoek. ");
INSERT INTO gai_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Karica u an meikramtaɨrmo mbagɨrica mina auŋembmo tamtamma taŋca, ndori amna reik ndeidta ore taŋca oikna.” ");
INSERT INTO gai_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Na Iesusa ndona iŋa raŋgairena ramtaɨrpaikna kam nda rutica gaindopatna, “Ne ndori minmo amta reik neaŋ.” Ri, mina manmo aindopca, “U toŋgo te, aia karwai par kabeapa mbut mbuniŋna aiŋa moca aŋgɨrena mɨnna kitukndukar puŋga tapacar tɨpemb ŋgoikca mina neaŋna?” ");
INSERT INTO gai_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ri, ma minmo madigiat, “Ne tapacar tɨpemb titpaikap eacrena? Na ne taŋca wat.” Mina taŋga wattacarica mac nda kɨpca Iesusmo gaind mambopat, “Aia tapacar tɨpemb parmbaiapa ŋgoaem mbuniŋ niŋgikap.” ");
INSERT INTO gai_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ri, Iesusa minmo gaindopatna, “Meikramtaɨra muruŋcamiŋa taŋca gan katgɨn laŋmo tumnambca moi mbirac.” ");
INSERT INTO gai_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Karica mina taŋga ndeida 100na mɨn naaŋgɨra punica mbiracatke, ndeida 50na mɨn naaŋgɨra punica mbiraca maiatke. ");
INSERT INTO gai_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Na Iesusa tapacar tɨpemb parmbaiapa ŋgoaem mbuniŋ aŋgɨca ma tamuŋna auŋa raia watca Raraŋ Aetaniacmo kam laŋ neaŋga. Karica ma tapacar tɨpemb witkica ndona iŋa raŋgairena ramtaɨra neaŋga, mina aŋgɨca an meikramtaɨrmo biŋairi, na ma ŋgoaemniŋ aŋgɨca witkia maica an meikramtaɨrmo muruŋcamiŋmo biŋaia maica. ");
INSERT INTO gai_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Mina muruŋcamiŋa, ambca mɨn ŋgoin matɨkat. ");
INSERT INTO gai_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ri, tapacar tɨpembapa ŋgoaeb tɨpembca eacri, mina anmo aŋgɨa tumbunna tɨkca, larkambca parniŋapa mbut mbuniŋna mɨnpaik maaocat. ");
INSERT INTO gai_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Na an tapacapa ŋgoaem ambatna ramtaɨr niŋgikna ŋgaŋganŋgɨa 5,000na mɨn. Na meikmombonikca mba nduatke. ");
INSERT INTO gai_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Karica Iesusa ndona iŋa raŋgairena ramtaɨrmo aindopatna, “Ne tawina kor aŋgɨca monmbaina auŋ Betsaidamo, ne out nagac.” Na ma ndo pac eaca, meikramtaɨrmo mandaca taŋna toŋtoŋap. ");
INSERT INTO gai_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Na ma meikramtaɨr mandaca mina taŋri, ma takur ian magat, ma anna tɨkca mbendeina moca. ");
INSERT INTO gai_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ri, maica wigwac ŋgoin motemma kora mɨarmo rɨk ndeacri, Iesusa irikca maŋara ndo kabe ndeacri. ");
INSERT INTO gai_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Na ma watri, watta ŋgepca kor paŋan ndiŋ nakɨpca kormo nda tapacri, mina autna aiŋa moca taŋri. Maica auŋ raruri, Iesusa puk nambat ndiŋa wɨtɨkca min ndambuŋ nakɨpri. Na ma maica minmo kunna moatke, ");
INSERT INTO gai_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ri, mana iŋa raŋgairena ramtaɨra watca, ma puk nambat ndiŋ nakɨpri, mina watca anmo raraŋ ian ndopca. Na mina larɨkca ŋgocrairi. ");
INSERT INTO gai_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Na mina muruŋa mana watca rugdar mocaricatke. Ri, Iesusa minmo tawina gaindopatna, “Ne ndorimo moi gagraca eac. Ne kai nanambi teac. Ganna auk.” ");
INSERT INTO gai_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Karica ma min ndambuŋna kor naŋgabukca, minap eacatke, watta mamaiat. Ri, mina ŋgep ŋgoreac ŋgoin maŋgepat. ");
INSERT INTO gai_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Aintik Iesusa tapac rɨmbɨtca meikramtaɨra biŋaiatna mɨnna, mana ainda moatna reikta mɨniŋga, mina ŋaŋari lamŋi ŋgocor, mina iroara mboborac maeacreke. ");
INSERT INTO gai_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Karica Iesusapa mana iŋa raŋgairena ramtaɨra mɨar kataca ga Genesaret auŋ ndaruca, mina ombca tundoca kormo mɨkndacrina. ");
INSERT INTO gai_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Na mina kor tɨkcarica gacatke, meikramtaɨra mina watca, Iesusmo watta magaracat. ");
INSERT INTO gai_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ri, meikramtaɨra an inikna auŋembmo tamtamma ootta taŋca anna meikramtaɨrmo mbopca waracri. Na mina waraca maeacri, Iesusa taup ian ndeacekna kam mbarac te, mina ŋgepca roumbbebta meikramtaɨrmo barera tɨkca minmo Iesus ndambuŋ naaŋgɨca taŋnande. ");
INSERT INTO gai_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Na Iesusa an auŋembapa auŋemb tekirapa an pitrikna auŋembmo muruŋa taŋga larurinanna, na mina ainda morena roumbbebta meikramtaɨrmo an punirena taupembca tɨkrena. Na mina Iesusmo roumbbebta meikramtaɨrmo watcarica mina mana tik ŋgapaoc waŋ ŋgutiŋ te, mina muruŋa laŋa mona moca aemaŋmaŋap digica mbopri, na roumbbebta meikramtaɨra muruŋa ainda morinanna, mina laiŋ mamori. ");
INSERT INTO gai_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Na Parisiara kɨpca tɨpemb wandik tamŋirena ramtaɨr ndeidap tumbunna tɨkca, mina Ierusalem tɨkcarica ŋgepca kɨpca, mina Iesusa watna moca mataŋgat. ");
INSERT INTO gai_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ri, mina wattatnanna mana iŋa raŋgairena ramtaɨra ndorita paɨra tukica rat ŋgocora ambri. ");
INSERT INTO gai_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Na Parisiarapa Iudananda muruŋa mina ndorita nicauna tɨpna kirara raŋgaica, mina paɨr ŋaŋari tuki ŋgocor te, mina mba amitndai. ");
INSERT INTO gai_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Na mina mbik tɨkca oikrena taupca taŋca nda kɨpca, mina ru ŋgocor te, mina mba amitndai. Na mina raŋgairena tɨpembca kirara wɨt ŋgoin, mina ndorita nicar puŋga tɨkca aŋgɨratna tɨpemb kirarir ndeid toco gaind, mina kabarapa, wɨnne tuoŋgourapa barer, motoco mina tukirena. ");
INSERT INTO gai_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Karica Parisiarapa tɨpemb wandik tamŋirena ramtaɨra Iesusmo gainda digiatna, “Tida moca una iŋa raŋgairena ramtaɨra nicauna tɨp kirara raŋgai ŋgocor? Na mina ndorita paɨra tukica rat ŋgocora ambapekna.” ");
INSERT INTO gai_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ri, Iesusa mina kam rutica gaindopatna, “Ramma morina ramoot Aisaia ma nen ŋgoin ndopatna, ne paparuna ramtaɨr. Na ma tirra mbopatna kamma gaind, ‘An meikramtaɨr mina ndorimo aukna i aŋgɨra ŋgeprenanna, upa ndo mboprena, mina iroar inkara aukmo mon tawan ŋgoin maeacreke. ");
INSERT INTO gai_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Na mina ramtaɨrta morena tɨpemb kirarirta kambca riptireke, aindoprena, “Ganna Raraŋ Aetaniacna kam.” Aintik mina aukmo wanaiŋ ŋgoinna tutupniŋ rɨmbɨtca mbendeirena.’ ");
INSERT INTO gai_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Na ne Raraŋ Aetaniacna neaŋgatna Tɨp Wandɨkca kecariapeke, na ne ramtaɨrta tɨpemb kirarir tiŋgikmo mataua utiŋga gagraca maeacreke.” ");
INSERT INTO gai_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ri, Iesusa minmo gaind mac mbopatna, “Ne Raraŋ Aetaniaca neaŋgatna Tɨp Wandɨkca nda ipuŋrena, na ne ndorita tɨpemb kirarira raŋgaina landamŋina ramtaɨr laiŋ koind. ");
INSERT INTO gai_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Na Moses ma aindopatna, ‘U ndona amepaetniŋna kaŋgauk ndeac te, maniŋna kam niŋgikca raŋgai.’ Na, ‘Ramootta ndona amepaetniŋmo kam ŋgoreac ndop te, ma menacnande.’ ");
INSERT INTO gai_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Na ne gaindoprena, ‘Ramoot ianna ma kitukndukarapa ainta reikapnan te, na ma ndona aem co, aetmo otacnande, iŋmbaia ma maniŋmo aindopnande, “Gan kitukndukca aku Raraŋ Aetaniaca neaŋna baburina.”’ ");
INSERT INTO gai_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Na ne aindoprena, ‘An ramootta ma an mbuŋa amepaet ŋgotacna reikca kai mo teac.’ ");
INSERT INTO gai_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Aintik ne ndorita nicarta tɨpemb kirarir aŋgɨca anna raŋgaireke, na ne Raraŋ Aetaniacna kamma nda ipuŋrena. Na anmo reac wanaiŋa morenan. Na ne an reikta tɨpemb kirarirmo ainda morena.” ");
INSERT INTO gai_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Karica Iesusa meikramtaɨrmo mac aca punica, ma minmo gaindopatna, “Ne muruŋ ŋgoinna aukna kammo matau waraca lamŋi rapac. ");
INSERT INTO gai_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Na reaca ramoot ianmo raek ndiŋa mbuk te, ma an ramootmo moi ma patiŋga mba moitndai. Wanaiŋ. Reaca an ramootna nikinik ŋgetacndiŋ ndaru te, ande anna ndo an ramootmo moca ma patiŋga monandet.” ");
INSERT INTO gai_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Karica Iesusa an meikramtaɨr tɨkcarica kaca taŋgatke. Na mana iŋa raŋgairena ramtaɨra manmo an kam roorna mɨnɨŋna madigiat. ");
INSERT INTO gai_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Na ma minmo gaind mac mbopat, “Ne toco iroar kocor, a? Na ne mba lamŋire ki, reik wɨt aniaca, ramootmo raekmbaia up ndiŋa mana nikinikca mbuk te, anna ramootmo patiŋga mba moitndaiit. ");
INSERT INTO gai_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Aku aindopapeknanna anna gaind tocna reikca ramootna iro inikmo gidik ŋgoinna mba irikri. Wanaiŋ. Anna ma lota taupca taŋrena, iŋmbai ma loaepi kecarinande.” An kamma Iesusa mbopapeknanna ma gaindopapekna, aintocna amta reikca Raraŋ Aetaniacna lamnɨacmo mina rat niŋgik. ");
INSERT INTO gai_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ri, Iesusa gaind mac mbopatna, “Reaca ramootna iro inik ndeacrenanna an ndiŋa laru te, anna ndo ramootmo moi patiŋga monandet. ");
INSERT INTO gai_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","Na aku mbopapekna kamma, anna reikca ramootna nikinik iro ŋgetacndiŋ ndarurenan, na an reikca gaind, iroar ŋgorik aŋgɨrena tɨpna kirar, na meacramootna kaŋtertaapna tɨp kirara morenan, na makɨmrena tɨpna kirar, na ramootta rɨŋga menacrena tɨpna kirar. Na laŋtaŋgoara laŋtaŋgona tɨpemb ŋgadudukca morena meikramtaɨrta tɨpemb kirarira morenan, na kabena meikramtaɨrta reikca mamatŋina tɨp kirar, na reac ŋgoreac ŋgoreaca morena tɨp kirar, na parureke, na ndondo ŋgoin ndopca tamtamma morena tɨp kirar, na iro ŋgoreac aŋgɨca kabena meikramtaɨrmo peperena kam ŋgoreac ndoprena tɨp kirar, na garurureke, ŋaŋaŋaona tɨp kirara morena. ");
INSERT INTO gai_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ainta tɨpemb kirarir, anna muruŋcamiŋa ŋgorik, na anna ramootna iro inik ndeacrenanna, an ŋgetacndiŋ ndarurenanna, anna Raraŋ Aetaniacna lamnɨac ŋgoutta, ramootmo mo, rat ŋgocor.” ");
INSERT INTO gai_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Karica Iesusa an auŋ tɨkcarica, ma ŋgepca Tair auŋ aniacna waŋmbai mataŋgat. Na ma anna kac ianna inikca mbukri, na ma mba toŋgori, ramoot ianmo lamŋi narica ma anna eacrenan. Na ma iŋgoroca eacna mɨnna wanaiŋ. ");
INSERT INTO gai_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Na meac ianna manmo an ndeacrena kamma waracrinan. Na an meaca ma mooŋ ianap, na ŋeroŋ ŋgoreac ianna manap eacri. Ainda moca an meaca tawina kɨpca Iesusna or kɨtɨmma tutupniŋ rɨmbɨtca mairikat. ");
INSERT INTO gai_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","An meaca mana aemma manmo Ponisiana pitrik waŋa tɨkca mɨrrinan, na Ponisia ma Siriana pitrik waŋnan. Na an meaca ma Girikna kam mbuŋ ndoprena, na ma Iesusmo ndona mooŋna ŋeroŋ ŋgoreaca moi kecarina moca aemaŋmaŋap madigiat. ");
INSERT INTO gai_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Na Iesusa manmo gaindopatna, “Outta aia mombonikmo amna reac pac neaŋam. Na anna laŋa wanaiŋ, aia mombonikta amta reik aŋgɨca piriŋta ke taŋ nari.” ");
INSERT INTO gai_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Na an meaca mana kam rutica gaindopatna, “Kacoot, piriŋga barna kaŋgauk maeacreke, mitoco mombonikta amta reik tɨpemb ambrena.” ");
INSERT INTO gai_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ri, Iesusa manmo aindopatna, “U gaindopapeke, laŋ u mac nda taŋ. Ŋeroŋ ŋgoreaca una mooŋmo tɨkcamacariri.” ");
INSERT INTO gai_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Na an meaca ndona kac mac nda taŋga, mooŋnuocmo wattatnanna, ŋeroŋ ŋgoreac mamo tɨkcamacariri ma laŋa moca bara meraca maeacri. ");
INSERT INTO gai_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Karica Iesusa Tairna pitrik waŋmbai tɨkcarica, annan mac ŋgepca taŋga auŋ aniac Saidonna pitrik waŋmbai ndaruatna. Ri, ma mac taŋga mandaca taŋga irikca Galili mɨar ndaruca, ma Dekapolisna pitrik mambukat. ");
INSERT INTO gai_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Na mina koarniŋ rɨkdaca, mimma makukuca, kamma ŋaŋari mbop ŋgocorta ramoot ianna aŋgɨra kɨpca, Iesusmo aemaŋmaŋap digiatna, manmo para an ramootna tik nambatta tɨkna moca. ");
INSERT INTO gai_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ri, Iesusa an meikramtaɨrmo tɨkcarica, ma an ramootmo aŋgɨra taŋga, maniŋa ndoniŋ niŋgik ndeacri. Na Iesusa an ramootna koarniŋmo ndona patŋit loorniŋ rapaca mbukacarica. Iŋmbaia ma ndona patŋitmo taber tɨkca an ramootna mim matɨkat. ");
INSERT INTO gai_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Na Iesus ma tamuŋna auŋa raia watta gaca, ma ndona tikca raŋgairinanna, ma aenan toca moca wɨk malacat. Ri, ma an ramootmo gaindopatna, “Epata.” An kamna mɨnɨŋa gaind, “U goot.” ");
INSERT INTO gai_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ri, an ramootna koarniŋa tawi ŋgoinna gootca keatke, reac ianna mana mimma maŋtikica eacrinanna goarakeca ma kam ndopna mɨn. ");
INSERT INTO gai_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Na Iesusa meikramtaɨrmo an laruapekke, mina watapekna reacna kamma kabena ramoot ian ndop narica wandɨk gargar matɨkat. Na wanaiŋ, mina an kammo anduna mbopca mataŋri. ");
INSERT INTO gai_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Na an meikramtaɨra kam anna waraca, mina ŋgep ŋgoreac naŋgepca aindopatna, “Reac, reaca ma morenanna, ma laŋ ŋgoin mamoreke. Ma koara rɨkdaca maica eacrenanmo, moa laŋa moca mina matau mawaracreke, na kamma ŋaŋari mbop ŋgocortanna, kamma matau mambopreke.” ");
INSERT INTO gai_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Karica an mɨn mbuŋa meikramtaɨr wɨt aniaca mac kɨpca punica, mina amna amta reik kocor. Ri, Iesusa ndona iŋa raŋgairena ramtaɨrmo aca kɨpca, ma minmo gaindopatna, ");
INSERT INTO gai_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Aku an meikramtaɨrta kadmaiacarica. Mina aukapmo rai mbonkac ndeacapeke, mina amna amta reik kocor. ");
INSERT INTO gai_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Na aku minmo nikemb wapataiara aintanna ndorita kaikca mbagɨrica taŋ te, mina paŋainda korereca taupembca wɨnaci iriknande. Na mina ndeida taupemb tawan ŋgetacnan kɨprina.” ");
INSERT INTO gai_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ri, mana iŋa raŋgairena ramtaɨra mana kam rutica gaindopatna, “Gan motemma ramtaɨr kocorta taup. Na aia tenna tapacar aŋgɨca amna reaca moca minmo neaŋga mina ammit?” ");
INSERT INTO gai_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Karica Iesusa minmo gainda digiatna, “Ne tapacar tɨpemb titpaikap eacrena?” Ri, mina aindopatna, “Parmbaiapa mbut mbuniŋ niŋgik.” ");
INSERT INTO gai_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Karica Iesusa meikramtaɨrmo mbopca mina pitrik wɨkɨn mambiracat. Na ma an tapacar parmbaiapa mbut mbuniŋ aŋgɨca, ma Raraŋ Aetaniacmo mbendeica kam laŋ ndopacarica, ma an tapacar tɨpembmo otrea maica, ndona iŋa raŋgairena ramtaɨrmo biŋa mona neaŋga. Mina meikramtaɨrmo mabiŋaiat. ");
INSERT INTO gai_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Na mina ŋgoaeb tekir ndeid toca eacrina. Ri, Iesusa an ŋgoaeb tekir motoco ma Raraŋ Aetaniacmo mbendeica kam laŋ ndopacarica ma ndona iŋa raŋgairena ramtaɨrpaikmo, an mac biŋaina maneaŋgat. ");
INSERT INTO gai_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Na maica mina ambca mɨnna tɨkatke, am tipa eacari, mina aŋgɨa punica larkambca parmbaiapa mbut mbuniŋ maaocat. ");
INSERT INTO gai_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Na an ramtaɨr tiŋgikta ŋgaŋganŋgɨa 4,000na mɨn. Karica Iesusa minmo mbagɨrica mina mataŋgat. ");
INSERT INTO gai_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Na ma tawina kor naŋgabukca ndona iŋa raŋgairena ramtaɨr aŋgɨca, mina mon Dalmanutana pitrik waŋ mataŋgat. ");
INSERT INTO gai_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Na Parisinanda kɨpca mina manap ipuŋga mbopca. Na mina manmo mbopca ma ŋgagatrac ianna mo te, anna ndo minmo wandac te, mina lamŋinande, anna gidik ma Raraŋ Aetaniacna aiŋa morena ramoot. Anna mina mana towai ndopca mbopatna. ");
INSERT INTO gai_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ri, Iesusa ndona tikca raŋgaiatnanna mana tikca makukuatke, ma rutica aindopatna, “Tida moca gan mɨnna meikramtaɨra ŋgagatrac ŋgoin laru te, an ŋgoinna watna morena? Na aku nemo gidik ŋgoinna gaindopnande, mina ianna mba ŋgagatrac ianna mba mac watitndai.” ");
INSERT INTO gai_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Karica ma minmo tɨkcarica kor mac ŋgabukca, mɨarmo monmbai waŋ magacat. ");
INSERT INTO gai_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ri, mana iŋa raŋgairena ramtaɨrpaikca iroar ndarekrekeca tapacar tip ndeidap mba aŋgɨra kɨpatke, mina tapac tɨp kabe niŋgikap aŋgɨa kɨpca mina kor inikca tɨkcamacariat. ");
INSERT INTO gai_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Na Iesusa minmo kam gargar mbuŋa gaindopatna, “Ne ndorimo Parisiarta isapa Erotna isna kam roor nake matau wat.” ");
INSERT INTO gai_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ri, mana iŋa raŋgairena ramtaɨrpaikca ndori puŋga aindopca, “Ŋarikca ma an kam ndopapeknanna, anna gidik, aia tapacar kocor.” ");
INSERT INTO gai_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Na mina aindopatna kaina kambca Iesusa lamŋirina, na ma minmo gaindopatna, “Kaina moca ne tamtam ndamŋica kambca aindoprena, ‘Aia tapacar kocor?’ Ne mba lamŋire ki? Na ne landamŋiar kocor ki? Nena iroar inkara mboracapek ki, a? ");
INSERT INTO gai_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Na ne lamnikap, na ne kaica an reikca wat ŋgocor, a? Na ne kourap, na ne kaica an kambca warac ŋgocor, a? Na nena iroara ndarekrekapeki, a? ");
INSERT INTO gai_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Na aku tapacar tɨpemb parmbai rɨmbɨtca, 5,000na mɨnna ramtaɨra neaŋga mina ambca, tɨkcariatna am tipa, ne larkambca titpaikca aocatna?” Ri, mina rutica aindopatna, “Larkambca parniŋapa mbut mbuniŋna mɨn.” ");
INSERT INTO gai_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Na Iesusa gaind mac mbopatna, “Aku tapacar tɨpemb parniŋapa mbut mbuniŋna kataca, an 4,000na mɨnna ramtaɨr tiŋgikca neaŋga mina ambca tɨkcariatna am tipa, ne larkambca titpaik ŋgaocatna?” Ri, mina rutica aindopatna, “Larkambca parmbaiapa mbut mbuniŋ.” ");
INSERT INTO gai_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Na ma minmo aindopatna, “Ne mba watta rapacreke.” ");
INSERT INTO gai_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Karica Iesusapa mana iŋa raŋgairena ramtaɨr, mina mac taŋga Betsaida auŋ malaruat. Ri, an auŋnan, mina lamnɨac ŋgoreacna ramoot ianmo Iesus ndambuŋ naaŋgɨca makɨpat. Na mina Iesusmo aemaŋmaŋap digica mambopat, u mana par ŋgutiŋ. ");
INSERT INTO gai_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Karica Iesusa an lamnɨac ŋgoreacna ramootna par ŋgutiŋga, manap aŋgɨca larua auŋmo raekmbaia taŋri. Na ma mana lamnɨacniŋmo taber iuca, ma ndona para mana lamnɨacniŋa tɨkca, ma manmo madigiat, “U reac ianna watre ki, wanaiŋ?” ");
INSERT INTO gai_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ainda moca an ramootta ndona lamnɨacniŋmo watukca watca, gaind mambopat, “Aku ramtaɨr ndeidmo mawatreke. Na aku ŋaŋari wat ŋgocor, na aku ramtaɨrmo watreke, ikir taŋ kɨpre toc.” ");
INSERT INTO gai_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ri, Iesusa ndona para mana lamnɨacniŋ mac tɨkatke. Na an ramootta mataua watukca watca, mana lamnɨacniŋa laŋ mamoat, ri, ma reikmo mataua watta marapacat. ");
INSERT INTO gai_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ri, Iesusa manmo mana kaca mbagɨriatke, manmo mambopat, “U taŋca auŋmo raekca kai laru teac.” ");
INSERT INTO gai_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Karica Iesusa ma ndona iŋa raŋgairena ramtaɨrap ŋgepca, mina Sisariapilipai auŋ aniacna inikna auŋembca rambuŋ ndeacrenanna taŋri. Na ma ndona iŋa raŋgairena ramtaɨrmo gainda digirina, “Meikramtaɨra mina aukmo mandai ŋgacit?” ");
INSERT INTO gai_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Na mina manmo gaindopatna, “Meikramtaɨr ndeida mina gaindoprena, u kɨtac puk neaŋrena ramoot Ion. Na ndeida gaindoprena, u Elaia. Na ndeida gaindoprena, u ramma morena ramoot ian.” ");
INSERT INTO gai_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ri, Iesusa minmo gaind mac madigiat, “Na ne ndori, ne aukmo mandai ŋgacit?” Na Pita mana kam rutica gaindopatna, “U gade gan ramoot, Raraŋ Aetaniaca babuca larapaca mbagɨrica kɨpca ai mac nda aŋgɨna ramoot.” ");
INSERT INTO gai_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ainda moca Iesusa minmo kabena meikramtaɨrmo ndo ndop laru narica minmo wandɨk matɨkat. ");
INSERT INTO gai_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Karica Iesusa ndona iŋa raŋgairena ramtaɨrmo ripti neaŋga gaind mambopat, “Ramootna Nuoc ma gɨrgɨr bagaraniac aŋgɨnande, te, ramtaɨr paŋaindapa, taup ndamtaɨr paŋaindapa, tɨpemb wandik tamŋirena ramtaɨrap, mina manmo iŋ neaŋ te, manmo rɨŋ menacnande. Te, ma rai mbonkac ndeaca mac nda ŋgepnande.” ");
INSERT INTO gai_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Na ma an kambmo, minmo mataua wiwitia mbopca mawaracri. Na Pita Iesusmo roumbmbai naaŋgɨa taŋga manmo kaeg mamoat. ");
INSERT INTO gai_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ri, Iesusa nda uriraca ndona iŋa raŋgairena ramtaɨra watta taŋga, ma Pitamo kaega moca gaind mambopat, “Ramoot Mbɨk, u aukmo iŋa tɨk. U Raraŋ Aetaniacna iroa mba raŋgaireke. Wanaiŋ ŋgoin. U ganna meikramtaɨrta iroar tiŋgik maraŋgaireke.” ");
INSERT INTO gai_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Karica Iesusa meikramtaɨrapa ndona iŋa raŋgairena ramtaɨrap, minmo ndo ndambuŋ ŋgaca punica. Na ma minmo gaindopatna, “Na ramootta aukmo raŋgaina ndop te, ma ndona landamŋina iroar tɨkcarica, ma ndona keracna ik aŋgɨca mbukca aukna iŋa raŋgai. ");
INSERT INTO gai_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Aintik mandaia ma ndona eteacna watna ndamŋica utiŋ te, ma ndona an eteacna watmo kecarinandet. Na mandai aukna ndamŋireke, na aukna kam wembaŋ laŋna lamŋina morena ramoot, ma ndona wat kecari te, mana an eteacna watta, ma mba maiitndai. ");
INSERT INTO gai_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ŋarikca ramoot ianna ma gan tiacarpaikna reikmo muruŋcamiŋa aŋgɨr mai te, mana eteacna wat mai te, an reikca manmo titoc ŋgotacit? ");
INSERT INTO gai_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Na ramootta ndona eteacna watmo ma titocna opoik mbuŋa oikca ma an eteacna wat mac nda aŋgɨrit? ");
INSERT INTO gai_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Na gan mɨnna meikramtaɨr, mina Raraŋ Aetaniacmo iŋ neaŋgacarica ainta tɨpemb ŋgorikta makukara muruŋa morenan. Na mina ianna aukmo numbira mo te, na aukna kam mbarac narica morenan, iŋmbaia Ramootna Nuoca ma ndona Aetna memetacna tac aniacapa Raraŋ Aetaniacna mbaiŋna aiŋa morena ŋerŋgaur ratap kɨp te, ma an ramootmo numbira monande.” ");
INSERT INTO gai_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Karica Iesusa minmo gaindopatna, “Aku nenmo gidik ŋgoinna gaindopnande, ramtaɨr ndeida ganna wɨtɨkca eacrenanna, mina menac ŋgocor ndeac te, mina Raraŋ Aetaniacna bubuocapa, mana gargar aniacap larueknanmo mina watnande.” ");
INSERT INTO gai_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Karica rai parmbaiapa mbut kabea maiatke, Iesusa Pitaapa, Iemisapa, Ionap, min aŋgɨca mina takur ianna tamuŋ ŋgoin ndeacrinan magat. Na mina ndori tiŋgikca an ndeacri, watrinan mbuŋa Iesusna tikna wapatta kirar dam ŋgoinna ŋgetrikica mina watatna. ");
INSERT INTO gai_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Na mana tik ŋgapaocna reikca kocnaia metaca gogok ŋgoin. Na gan tiacarpaikna ramoot ianna an tik ŋgapaocna kirar toca mba moitndai. ");
INSERT INTO gai_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Na Mosesapa Elaia mbaniŋa laruca Iesusap mbopri, na mana iŋa raŋgairena ramtaɨra watatna. ");
INSERT INTO gai_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ri, Pita anna watca ma Iesusmo aindoprina, “Riripti, anna laŋ aia gan ndeacrenanna. Aia nena ndamb mbonkaca monande, ianna unan, na ianna Mosesnan, na ianna Elaianan.” ");
INSERT INTO gai_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Na Pita aindopatnanna, anna gaind, mina rugdar moca nanambirina, aintik Pita ma mba lamŋiri, ma titocna kamb ndopit. ");
INSERT INTO gai_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ainda moca wawɨrir ndepikca kɨpca minmo wɨŋga makɨtacat. Na an wawɨrpaikna inikca kam ianna gaindoprinan, “Anna aukna Nuoc ŋgoin, na aku manmo matŋirenan. Ne mana kamma waracraŋ.” ");
INSERT INTO gai_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Na tawi ŋgoinna mana iŋa raŋgairena ramtaɨra tamtamma watrinanna, mina ramoot ianmo mba watatke. Iesusa ndo kabea minap eacrena. ");
INSERT INTO gai_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Karica mina an takur tamuŋ tɨkcarica mina mac nda mairikat. Na Iesusa minmo gaindoprina, “An reaca ne watrinanna, ne ramoot ianmo kai mbop teac, taŋca Ramootna Nuoca muk tɨkcarica ma mac nda ŋgepekna mɨn.” ");
INSERT INTO gai_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Na mina an kambmo utiŋga eacri, mina ndorita rɨkmo gaindopatna, “An muk tɨkcarica mac nda ŋgepna kamma anna kaina reac?” ");
INSERT INTO gai_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Na mina Iesusmo gainda digiatna, “Kaina moca ririptina tɨpemb wandik tamŋirena ramtaɨra gaindoprena, Elaia ma outna kɨpnandet?” ");
INSERT INTO gai_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ainda moca Iesusa mina kambmo gainda rutiatna, “An kamma anna gidik. Elaia, ma out nakɨpca reikmo muruŋcamiŋ mac moi wandoŋainandet. Na an kambca Raraŋ Aetaniacna timbigta kap ndeacrenanna tida moit? Na ma aindoprina, Ramootna Nuoca ma gɨgɨrar wɨt aŋgɨnandet, na meikramtaɨra manmo peperena kamb ndopnandet? ");
INSERT INTO gai_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Na aku nenmo gaindopnandet, ŋgaua Elaia makɨpatna. Na meikramtaɨra ndorita toŋtoŋgara raŋgairina, na mina manmo ainta tɨpemb kirarira morinan. Na anna Raraŋ Aetaniacna timbigta kap ndeacrena kamna kirar toc.” ");
INSERT INTO gai_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ri, Iesusapa mana iŋa raŋgairena ramtaɨr mbonkaca takur ndiŋa nda irikca taŋga mana iŋa raŋgairena ramtaɨr tambuŋ ndaruca, mina watrinanna meikramtaɨrta tumbun aniaca minmo paria aŋgɨca eacrina. Na tɨpemb wandik tamŋirena ramtaɨr ndeida minap ipuŋga mboprenan mbuŋa. ");
INSERT INTO gai_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Na an meikramtaɨra muruŋa watrinanna, Iesusa kɨprinanna watca mina ŋgep ŋgoreacna ŋgepatna. Ri, mina tawi ŋgoinna man ndambuŋ ŋgoota mataŋgat. Na mina manmo gaindopatna, “Ra laŋ ŋgoin, u makɨpca.” ");
INSERT INTO gai_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Na Iesusa mana iŋa raŋgairena ramtaɨrmo gainda digirina, “Ne kaina reacna moca minap ipuŋrena?” ");
INSERT INTO gai_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ainda moca an meikramtaɨrta rɨkna ramoot ianna Iesusna kammo gainda nda rutiatna, “Riripti, ŋeroŋ ŋgoreac ianna kɨpca aukna nuocap eacrenan, na ma mana upmo leaca ma kamb ndopna mɨnna wanaiŋ. Aintik aku manmo un ndambuŋ naaŋgɨca kɨpapekna. ");
INSERT INTO gai_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Na memetmbaca an ŋeroŋ ŋgoreaca manmo mbukca, manmo mo ŋaŋaoca manmo pitrikca mo irikrena. Na toptikca mana up ndiŋ ndarurenan, na ma ndona ndaɨrmo iriki ikca wirenan, na mana tikca kocnaia paŋpaŋiacarirena. Na aku una iŋa raŋgairena ramtaɨrmo an ŋeroŋ ŋgoreaca mo kecarina digirinan, na mina mona mɨnna wanaiŋ.” ");
INSERT INTO gai_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Na Iesusa an kambca waraca ma meikramtaɨrmo gaindopatna, “Ne rɨtɨpaik kocorta meikramtaɨr, aku nenapmo kɨdrɨk titpaikca nenap eacit? Na aku nena makukara mbukit? Na aukmo an nuocmo aŋgɨ kɨp.” ");
INSERT INTO gai_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ri, mina an nuocmo man ndambuŋ naaŋgɨra taŋri. Na an ŋeroŋ ŋgoreaca Iesusa watca, ma tawi ŋgoinna an nuocmo moa ŋaŋaoca manmo laŋa mba moa nekatke. Na ma anna tamtamma upuria taŋri, na toptikca mana up ndiŋ ndarurina. ");
INSERT INTO gai_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ainda moca Iesusa an nuocna aetmo gainda digiatna, “Kɨdrɨkar titpaikca ma aind ndeacrinan?” Ri, aetta aindoprinan, “Manmo mooŋnuoc tekera tɨkca kɨprina. ");
INSERT INTO gai_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Na memetmbaca an ŋeroŋ ŋgoreaca manmo mo menacna moca, manmo tac nake mbukrena, na manmo puk nake pukrena. Na u mɨn ecte, u aina kadmaica manmo otac.” ");
INSERT INTO gai_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Karica Iesusa manmo gaindopatna, “Kaina moca u aukmo gaindoprina, ‘U mɨn ecte’? Na u mandai u rɨpac te, u reikmo muruŋa mona mɨn.” ");
INSERT INTO gai_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Na tawi ŋgoinna an nuocna aetta kam keca gaindopatna, “Aku rɨpacrena, na aukna rɨtɨpaca gargara wanaiŋ, u aukna rɨtɨpacmo mo gagra. Na u aukmo otac!” ");
INSERT INTO gai_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ri, Iesusa watrinanna meikramtaɨr wɨt aniaca min ndambuŋa ootta kɨpca rambuŋairinan. Ainda moca ma an ŋeroŋ ŋgoreacmo kaega moca aindopatna, “U ŋeroŋ ŋgoreac up mɨkrenanapa koar rɨkdacrenan, u an nuocmo tɨkcari.” Na u an mooŋnuocmo kai mac nda mbuk teac. ");
INSERT INTO gai_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ainda mocatke, an ŋeroŋ ŋgoreaca kam aniac keca, ma an nuocmo kocnaia moa nekca ŋgocraicarica, ma an nuocmo tɨkcarica mataŋgat. Na an nuoca ma waɨr toc ndeacrina. Ri, meikramtaɨr wɨtta anna watca aindoprina, “Ma mamenacri.” ");
INSERT INTO gai_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Na Iesusa mana parmo utiŋga, manmo aŋgɨ ŋgepri, na ma ŋgepca wɨtɨkrina. ");
INSERT INTO gai_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Karica iŋmbaia Iesusa kaca taŋga eacri, mana iŋa raŋgairena ramtaɨrap mina ndori tiŋgikca eacri, mina manmo gainda digirina, “Titoca moa aia an ŋeroŋ ŋgoreaca mo kecarina mɨnna wanaiŋ?” ");
INSERT INTO gai_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Na ma minmo gaindoprina, “Mbembendeina tɨpna kirar niŋgik mbuŋa an ŋeroŋ ŋgoreaca mo kecarina mɨn. Na kabena taupemb kocor.” ");
INSERT INTO gai_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Karica Iesusapa mana iŋa raŋgairena ramtaɨra an taup tɨkcarica mina Galilina pitrik waŋna rɨkca taŋrina. Na Iesusa ma toŋgorinanna, ma an ndeacrenanna, ramoot ianna kai lamŋi teac, ma an ndeacrenan. ");
INSERT INTO gai_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Na anna mɨnɨŋa gaind, ma ndona iŋa raŋgairena ramtaɨrmo ririptica neaŋrina. Na ma minmo gaindoprina, “Mina Ramootna Nuocmo ramtaɨrta para tɨknandet, na mina manmo mo menacnandet. Na mina manmo mo menaca, ma eaca rai mbonkacna mɨn mbuŋa ma mac nda ŋgepnandet.” ");
INSERT INTO gai_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Na mina an kambta mɨnɨŋa mba lamŋia garacri. Ainda moca mina manmo digina rugdar mori. ");
INSERT INTO gai_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Na Iesusapa mana iŋa raŋgairena ramtaɨra taŋga Kapaneam auŋa larurinan. Na mina kacna inikca mbukca eacri, ma minmo gainda digiatna, “Aia taupna kɨpreke, ne kaina reacna kamna ipuŋga mbopca kɨprena?” ");
INSERT INTO gai_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Na mina manmo kam ianna mbop ŋgocor. Na anna mɨnɨŋa gaind, mina taup ndiŋa kɨprinanna mina ndorimo ipuŋrinan, mandaia ndo mina ramoot paŋan ndeacit. ");
INSERT INTO gai_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ri, Iesusa mbiracatke, ma ndona iŋa raŋgairena parniŋapa mbut mbuniŋna mɨnna ramtaɨrmo aca kɨpca, ma minmo gaindoprina, “Ramootta outta tɨkna mo te, ma iŋmbai ŋgoin ndeacnande. Na ma meikramtaɨr muruŋcamiŋna aiŋa mona ramoot ndarunande.” ");
INSERT INTO gai_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Na ma aindopacarica ma mooŋnuoc teker ianmo aŋgɨca mina rɨkca wɨtɨkrina. Ri, ma an mooŋnuocmo potaca minmo gaindoprina, ");
INSERT INTO gai_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Ramootta aukna iro landamŋiap eacrenan, na ma gaind tocna kirarna mooŋnuocmo otac te, ma aukmo otacrina. Na ramootta auk ŋgotacapeknan, ma auk niŋgikmo mba otacri. Wanaiŋ. Ma an Aetta aukmo mbagɨrica aku kɨprinan motocmo ma otacrina.” ");
INSERT INTO gai_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Karica Ionna Iesusmo gaindoprina, “Riripti, aia watrinanna, ramoot ianna una i mbuŋa ŋerŋgaur ŋgorikca moa kecarireke. Na ma aina wiwitnanna wanaiŋ, aintik aia manmo mbopca, ma an aiŋa kai mo teac.” ");
INSERT INTO gai_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Na Iesusa minmo gaindopatna, “Ne manmo kai kɨrac teac. Na anna gaind, ramoot ianna aukna i mbuŋa ŋgagatraca ianna mo te, ma aukmo kam ŋgoreaca mba tawi mbopitndai.” ");
INSERT INTO gai_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Na ramootta aimo puŋndamootta mo ŋgocor, ma aina aikndamoot. ");
INSERT INTO gai_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Na aku nenmo gidik ŋgoinna gaindopnande, an kammo ne matau warac. Na anna gaind, ramoot ianna nenmo gaind ndamŋi te, ne Karaisna aiŋna ramtaɨr, na anna moca ma nenmo puk neaŋam te, Raraŋ Aetaniaca manmo reac laŋ ian ŋgoin neaŋnande. ");
INSERT INTO gai_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Karica Iesusa gaind mac mbopatna, “Ramoot ianna ganna mombonik tekira aukca rɨpacrenanna, mina ianmo moca, ma tɨp ŋgoreacna makukca irik te, mina an ramootmo waut aniac ian aŋgɨca mana logotmo anap leaca manmo aŋgɨca macait inik nake pukca, ma menac te, anna laŋ. ");
INSERT INTO gai_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Na una para unmo tɨp ŋgoreacna makukca mona wɨŋ te, u kataca kecari. Anna laŋ u par kabe niŋgikap, te, u memetmbaca eteacna wat aŋgɨnande. Na moca u par mbuniŋapa mina unmo menac ŋgocorta iarwara wɨrrena tac nake irik nari. ");
INSERT INTO gai_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Na una ora unmo tɨp ŋgoreacna makukca wɨŋ te, u anmo kataca kecari. Anna laŋ u kabe niŋgikap, te, u memetmbac ndeacrena wat aŋgɨnande. Na moca u or mbuniŋap, mina unmo menac ŋgocorta iarwara wɨrrena tac nake irik nari. ");
INSERT INTO gai_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Na una lamnɨaca unmo tɨp ŋgoreacna makukca wɨŋ te, u ian tarki kecari. Anna laŋ u lamnɨac kabe niŋgikap, te, u Raraŋ Aetaniacna bubuoca mbuknande. Na moca u lamnɨac mbuniŋap mina umo menac ŋgocorta iarwara wɨrrena tac nake irik nari. ");
INSERT INTO gai_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","An taupca, ‘Nduipitikca mina warirmo amraŋnande, na mina mba maiitndait. Na an taca mina warirmo loriraŋnande, na ma mba maiitndait.’ ");
INSERT INTO gai_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Na mina mindaŋmo gɨmbambara muruŋa tɨkrenan, te, an gɨmbambara Raraŋ Aetaniacna lamnɨac ŋgoutta mina ratta mona. Na an tɨpna kirar mbuŋa taca meikramtaɨrmo muruŋa larunandet. ");
INSERT INTO gai_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Na mindaŋa ma reac laŋ. Na mindaŋna tarara mai te, ne titoca moa, mana tarara mac nda kɨpit? Na mindaŋa ma amna ŋgoaebapa reikmo moa laŋa moca eacrenan, na an tɨpna kirar mbuŋa ne mindaŋ laŋna kirar toc ndaruca, eteac laŋmo laiplacarap eacnande.” ");
INSERT INTO gai_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Karica Iesusa ŋgepca an taup tɨkcarica, ma Iudiana pitrik waŋmo, oc Iodanna waŋgembaia taŋrina. Na meikramtaɨr wɨt aniaca man ndambuŋa mac kɨpca punirina. Na ma ndona tɨpna kirara raŋgaica meikramtaɨrmo mimitpac neaŋrina. ");
INSERT INTO gai_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ainda moca Parisina ramtaɨra man ndambuŋa kɨpca, manmo towaina moca. Na mina manmo gainda digirina, “Aina tɨp wandɨkca aimo aindoprina, ramootta ndona meac laŋtaŋgomo, laŋtaŋgo katacna laŋ ki, co, laŋa wanaiŋ?” ");
INSERT INTO gai_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ri, Iesusa mina kambmo gainda rutirina, “Na Mosesa nenmo titocna Tɨp Wandɨkmo nenmo neaŋrina?” ");
INSERT INTO gai_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Na mina gaindoprina, “Mosesa aindoprina, ‘Ramootta laŋtaŋgo kakatacna timbiŋ rapara tirca meacmo neaŋga, manmo mandaca taŋ te, anna laŋ.’” ");
INSERT INTO gai_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Na Iesusa minmo gaindoprina, “Ne garururena ramtaɨr, aintik Mosesa nenmo an Tɨp Wandɨkca tirca nenmo neaŋrina. ");
INSERT INTO gai_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Na ne warac, ‘Atu ŋgoinna Raraŋ Aetaniaca reikmo muruŋcamiŋa morina, na ma meikramtaɨr motocmo muruŋcamiŋa morina. Na ma minmo meacapa ramootta morina. ");
INSERT INTO gai_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ainda moca ramootta ndona aemaetmo tɨkcarica taŋca ndona meacap mɨk te, ");
INSERT INTO gai_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","na maniŋa tik kabe niŋgik ndarunande.’ Na Raraŋ Aetaniaca aindoprinan tik, maniŋa ndamniŋa mba mac eacitndai. Wanaiŋ. Maniŋa tik kabe niŋgik ndarurina. ");
INSERT INTO gai_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Aintik reaca Raraŋ Aetaniaca moa mɨkrinanna, anna ramootta titacna towanaiŋ.” ");
INSERT INTO gai_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ainda moca iŋmbaia Iesusapa mana iŋa raŋgairena ramtaɨra kac mac taŋgatke, mina manmo an laŋtaŋgo kakatacna kambta moca manmo mac digiatna. ");
INSERT INTO gai_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Na ma minmo gaindopatna, “Ramoot ianna ndona meac laŋtaŋgomo tɨkcarica, ma kabena meac laŋgo te, an ramootta ma tɨp ŋgadudukca morina. ");
INSERT INTO gai_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Na meac ianna ndona kaŋgait tɨkcarica kabena ramoot laŋgo te, an meaca ma tɨp ŋgadudukca morina.” ");
INSERT INTO gai_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Karica meikramtaɨra ndorita mombonikmo Iesus ndambuŋ naaŋgɨa kɨprina. Na mina toŋgorinanna, ma mina tikembmo utiŋga mbendeia taŋna. Ri, mana iŋa raŋgairena ramtaɨra anna watca mina an meikramtaɨrmo kaega mori, ");
INSERT INTO gai_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Iesusa anna watca ma minmo kaeg mamoat. Na ma ndona iŋa raŋgairena ramtaɨrmo gaindoprina, “Ne an mombonikmo watcarica mina auk ndambuŋ nakɨp. Ne minmo kai kɨrac teac. Wanaiŋ. Raraŋ Aetaniacna bubuoca ma ainta ramootnan, ma an mombonik tekirta kirar toc ndeacrena. ");
INSERT INTO gai_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Na aku nemo gidik ŋgoinna gaindopnande, ramoot ianna Raraŋ Aetaniacna bubuocmo an mombonik tekir aŋgɨrena tɨpna kirara aŋgɨ ŋgocor te, ma anna mbukna toawanaiŋ. Na wanaiŋ ŋgoin.” ");
INSERT INTO gai_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Na an mombonikmo ma potaca, ma ndona parmo min nambatta tɨkca, ma Raraŋ Aetaniacmo minmo, mo laŋa mona madigiat. ");
INSERT INTO gai_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Karica Iesusa an tɨkcarica ŋgepca taŋre mbuŋa, ramoot ianna ootta kɨpca mana kɨtɨmmo tutupniŋ rɨmbɨtca, manmo gaindopatna, “Riripti laŋ, aku tida mo te, aku iarwar ndeteacna wat laŋ aŋgɨrit?” ");
INSERT INTO gai_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ri, Iesusa manmo gaindopatna, “Kaina moca u aukmo laŋ ŋgacrina? Raraŋ Aetaniac niŋgikca ndo ma laŋ. ");
INSERT INTO gai_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Na u Tɨpemb Wandikta kambca u lamŋirena, ‘Ne kabena meikramtaɨrmo kai mo menac teac. Na ne laŋtaŋgoar, ne tɨpemb ŋgadudukca morena meikramtaɨrta tɨpemb kirarira kai mo teac. Na ne kai makɨm teac. Na ne kabena meacramootmo ritri waparacmo kai moca, paparuna kam mbuŋa kai mbop teac. Na ne kabena ramootna reacmo kai paruca kam kocora kai aŋgɨ teac. Na ne ndorita ameraterta kaŋgauk niŋgik ndeacraŋ, na mina kambmo waracraŋ.’” ");
INSERT INTO gai_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ri, an ramootta Iesusmo gaindopatna, “Riripti, aku mooŋnuoc tekera tɨkca kɨpca mandeacna mɨn, aku an Tɨpemb Wandikmo muruŋa raŋgairena.” ");
INSERT INTO gai_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Na Iesusa manmo watikca, ma manmo matŋia, manmo gaindopatna, “U reac kabena matpirena. U taŋca ndona laimnembta reikmo mbik tɨkca mandaica oik te, u an kitukndukmo aŋgɨca meikramtaɨr ndaekpembmo neaŋ. Na u ainda mo te, u tamuŋna auŋmo u reik laiŋ koindap eacnande. Na u kɨpca aukmo raŋgai.” ");
INSERT INTO gai_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Na an ramootta an kamma waracatke, mana iro inikca makuk ŋgoin, na mana inpaŋanna ŋgocraica ma mataŋgat. Na anna mɨnɨŋa gaind, ma lamin aniacap tik. ");
INSERT INTO gai_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Na Iesusa ndona iŋa raŋgairena ramtaɨrmo watca, ma minmo gaindopatna, “Laimnembta meikramtaɨra, mina Raraŋ Aetaniacna bubuoca mbumbukca, minmo owai ŋgoin.” ");
INSERT INTO gai_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ainda moca mana iŋa raŋgairena ramtaɨra mana an kam mbaraca mina ŋgep ŋgoreac naŋgeprina. Na ma minmo gaind mac mbopatna, “Aukna mombonik, ramootta Raraŋ Aetaniacna bubuocna kaŋgaukca mbubukca, aiŋ aniac ŋgoin! ");
INSERT INTO gai_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Na kamela reik iukrena lacna urupa mbubukca anna wetwet ŋgoin, na an kirara laimnembta ramootta Raraŋ Aetaniacna bubuocna kaŋgaukca mbukna aiŋ ŋgoin.” ");
INSERT INTO gai_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ainda moca mana iŋa raŋgairena ramtaɨra ŋgep ŋgoreac ŋgoin naŋgepca, mina ndorita rɨkmo gaindopatna, “Ainda mo te, mandaia ndo iarwarna eteacna wat aŋgɨrit?” ");
INSERT INTO gai_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ri, Iesusa minmo wat gargara watca ma gaindopatna, “Meikramtaɨra ndori puŋga towanaiŋ, na Raraŋ Aetaniac man niŋgikca, ma ndo reikmo muruŋa mona mɨn.” ");
INSERT INTO gai_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ainda moca Pita, ma Iesusmo kam ianna gaindopatna, “U warac, aia ndorita reik tɨkcarica una iŋ maraŋgaireke.” ");
INSERT INTO gai_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Na Iesusa aindopatna, “Aku nemo gidik ŋgoinna gaindopnandet, meikramtaɨra muruŋa aukapa kam wembaŋ laŋ ndamŋina moca ndorita kaik, co laiplacar, co mbiar, co aemer, co aeter, co mombonik, co warɨŋemb tɨkcari te, ");
INSERT INTO gai_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","mina 100na mɨnna reik aŋgɨnandet. Na an mɨnna mina gan tiacarpaikca eacraŋ te, Raraŋ Aetaniaca minmo reik wɨtta neaŋnandet. Na anmo mina ŋgaua anap eacrenanmo kunnandet. Na mina kaik wɨtapa, laiplacar wɨtapa, mbiar wɨtapa, aemer wɨtapa, mombonik wɨtapa, warɨŋembca wɨtap aŋgɨnandet. Na meikramtaɨr ndeida minmo tɨpemb kirarir ŋgorik ndeid toco an mɨnna monandet. Na minmo iŋmbai ndaruna reaca, mina iarwarna eteacna wat laŋ aŋgɨnandet. ");
INSERT INTO gai_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Na meikramtaɨr wɨtta mandeaca out ndeacrenan, mina iŋmbai ŋgoin ndeacnandet. Na meikramtaɨr wɨtta mandeaca iŋ ŋgoin ndeacrenan, mina out ndeacnandet.” ");
INSERT INTO gai_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Karica Iesusapa mana iŋa raŋgairena ramtaɨra Ierusalemma taŋna moca taup ndiŋa taŋri. Na ma minmo outta taŋrina. Ri, mana iŋa raŋgairena ramtaɨra tamtam ŋgoin ndamŋirina. Na meikramtaɨra mina iŋa raŋgairenanna, mina nanambirina. Aintik ma ndona iŋa raŋgairena parniŋapa mbut mbuniŋna ramtaɨrpaikmo mac aŋgɨca, ma ndo ndaruna reikta kamb ndoprina. ");
INSERT INTO gai_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Na ma aindoprina, “Ne warac. Mandeaca aia Ierusalem mataŋgek, na mina Ramootna Nuocmo mina taup ndamtaɨr paŋaindapa tɨpemb wandik tamŋirena ramtaɨra neaŋnandet. Na mina manmo ritri waparaca monandet, na mina manmo mo menacna kamb leacnandet. Te, mina manmo Iudana meikramtaɨr wanaiŋnanta wiwitna para tɨknandet. ");
INSERT INTO gai_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Na an ramtaɨra manmo peperenandet, na manmo taber iunandet, na manmo pi ŋgoreac ŋgoinna pinandet, na manmo mo menacnandet. Na rai mbonkacna mɨn mbuŋa, ma mac nda ŋgepnandet.” ");
INSERT INTO gai_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Karica Sebedina nuocniŋa Iemisapa Ion, maniŋa Iesus ndambuŋ nakɨpca manmo gaindopatna, “Riripti, aŋga unmo reac ianna digina mamoek, na aŋga toŋgorinanna u aŋmo an reaca mo.” ");
INSERT INTO gai_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ainda moca ma maniŋmo gainda digirina, “Oŋgo toŋgorinanna aku oŋmo kaina reaca moit?” ");
INSERT INTO gai_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Na maniŋa manmo gaindopatna, “An mɨnna u i aniac aŋgɨca gagrirta ramoot paŋan aniaca mo te, aŋga toŋgorinanna aŋna ianna una par umbaia mbirac te, ianna una par aeŋmbaia mbiracna.” ");
INSERT INTO gai_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ri, Iesusa maniŋmo gaind mambopat, “Oŋgo aukmo an reacna digirinanna, oŋgo anmo mba garaca lamŋireke. Na oŋgo an gɨgɨrar auk ndambuŋnan aŋgɨna mɨn ki? Na an kɨtac pukca aku aŋgɨnanna oŋgo aŋgɨna mɨn ki?” ");
INSERT INTO gai_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Na maniŋa manmo aindopatna, “Aŋga mɨn.” Ri, Iesusa maniŋmo aindoprina, “Anna gidik, oŋgo auk aŋgɨekna gɨrgɨra oŋgo aŋgɨna mɨn. Na an kɨtac pukca mandeaca aku aŋgɨna morenanna, oŋ toco anna aŋgɨnandet. ");
INSERT INTO gai_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Na mandaia aukna par umbai, co, mandaia aukna par aeŋmbaia mbiracnanna, anna aukna reaca wanaiŋ. An mbibiracna reikca anna aukna Aetta larapacrina meikramtaɨrtan.” ");
INSERT INTO gai_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Na mana iŋa raŋgairena ramtaɨr parniŋa an reikta kambca Ionapa Iemis mbaniŋa mboprinan, mbaracatke, mina maniŋmo kaega morina. ");
INSERT INTO gai_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ri, Iesusa minmo ndo ndambuŋa ŋgaca kɨpca, minmo aindoprina, “Ne lamŋirena, Iudana raekmbaina meikramtaɨrta ramtaɨr paŋainda eacrenan, mina ndorita wiwitnanmo ndorita kaŋgaukca eacna gagraca bubuocrena. Na mina ramtaɨr paŋainda, ndorita meikramtaɨrmo ndorita kambmo raŋgaina moca gagrarena. ");
INSERT INTO gai_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Na an tɨpna kirara nena rɨkca kai eac teac. Kari ŋgoin. Na ramootta nenmo ramoot paŋan ndeacna mo te, ma nenmo, nena aiŋna ramoot ndeac. ");
INSERT INTO gai_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Na ramootta nenmo out ndeac ndop te, ma nenmo muruŋna mbaiŋna ramootna kirar toc ndeac. ");
INSERT INTO gai_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Na anna gaind, Ramootna Nuoc toco ma kɨprinanna, meikramtaɨra man ŋgotaca mana aiŋa mo nake mba kɨprina, wanaiŋ. Ma min ŋgotacna kɨprina, te, ma ndona eteacna wat mbuŋa meikramtaɨr wɨtmo nda oiknandet.” ");
INSERT INTO gai_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Karica Iesusapa mana iŋa raŋgairena ramtaɨra taŋga Ieriko auŋ ndaruca. Na manapa mana iŋa raŋgairena ramtaɨrapa meikramtaɨrta mɨmɨatta Ieriko auŋmo tɨkcarica taŋre mbuŋa, Timeusna nuoc Bartimeus, ma taup roumbca mbiraca eacrina. Na ma lamnɨac ŋgoreac, na ma meikramtaɨrmo kitukndukna rurena. ");
INSERT INTO gai_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Na ma waracrinanna, Nasaretna Iesusa kɨpri, na ma gaind ŋgaca mboprina, “Iesus u Dewitna ŋgamaɨr, u aukna kadmaica aukmo otac.” ");
INSERT INTO gai_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ri, meikramtaɨr wɨtta manmo kaega moca manmo gaindoprina, “U watiti.” Na ma kamb anik puŋga gaind ŋgaca mboprina, “Dewitna ŋgamaɨr, u aukna kadmaica aukmo otac.” ");
INSERT INTO gai_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ainda moca Iesusa wɨtɨkca aindopatna, “Manmo ac kɨp.” Ri, mina an lamnɨac ŋgoreacna ramootmo aca mambopat, “U toŋgoca ŋgep, ma una maacreke.” ");
INSERT INTO gai_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ainda moca ma ndona tik ŋgapaoc rocot riaŋga kecarica, ma tawi ŋgoin naŋgepca wɨtɨkca ma Iesus ndambuŋa taŋrina. ");
INSERT INTO gai_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Na Iesusa manmo gainda digirina, “U toŋgorinanna aku unmo tida moit?” Na an lamnɨac ŋgoreacna ramootta manmo gaindopatna, “Riripti, aku watna.” ");
INSERT INTO gai_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Na Iesusa manmo gaindoprina, “U taŋ, una rɨtɨpaca ndo unmo moa laŋa morina.” Na tawi ŋgoinna mana lamnɨaca laŋ mamori, na ma watatna. Na ma Iesusa raŋgaica taup ndiŋ mataŋgat. ");
INSERT INTO gai_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Karica Iesusapa mana iŋa raŋgairena ramtaɨra Ierusalem auŋ aniacmo kɨpca rambuŋaiatke, na mina taŋga Olip Takurna roumb ndeacrina auŋniŋ Betpageapa Betani malaruat. Na ma ndona iŋa raŋgairena ramootniŋmo outta mbagɨrica, ");
INSERT INTO gai_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ma maniŋmo gaindopatna, “Oŋgo monmbai waŋna an auŋa aia watrinanna taŋca. Na oŋgo taŋ laru te, oŋgo anduna watnandet, doŋki ŋgam ianna meikramtaɨra manmo mbiraca taŋ ŋgocora mina mɨkndaca eacrenan. Oŋgo mana ŋgatɨk pɨarca aŋgɨ kɨp. ");
INSERT INTO gai_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Na ramoot ianna oŋmo digi te, ‘Kaina moca oŋgo doŋkimo aŋgɨca taŋgek?’ Te, oŋgo manmo rutica aindop, ‘Kacootta manmo aiŋap, na iŋmbaia ma manmo tawina mac nda aŋgɨ kɨpnande.’” ");
INSERT INTO gai_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ainda moca maniŋa mataŋgat, na maniŋa taŋca doŋki ŋgam ianna taupca wɨtɨkca eacrenanna watca, na mina an doŋkimo kac ianna tɨŋna roumbca mɨkndaca eacrena. Ri, maniŋa mana ŋgatɨkmo mapɨari. ");
INSERT INTO gai_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ainda moca an ramtaɨra anna roumbca wɨtɨkca eacrenanna, mina maniŋmo gainda digiatna, “Oŋgo kaia mona moca gan doŋkina ŋgatɨk pɨarrena?” ");
INSERT INTO gai_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Na Iesusa maniŋmo mboprina kamna kirar ŋgoinna maniŋa minmo ainda nda rutirina. Na mina maniŋmo doŋki aŋgɨ taŋna kammo, laŋ mambopat. ");
INSERT INTO gai_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Karica maniŋa Iesusmo doŋki aŋgɨca mataŋgat. Na maniŋa ndoniŋna tik ŋgapaoc rocotniŋ riaŋga aŋgɨca doŋkina kopik nambatta tɨkrina, ri, Iesusa an nambat nagac mambiracat. ");
INSERT INTO gai_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Na meikramtaɨr wɨtta ndorita tik ŋgapoik roctir riaŋga taup ndiŋ ŋgimtaca mataŋri. Na ndeida taŋga ikir raprirmo kataca aŋgɨa kɨpca taup ndiŋ ŋgimtaca taŋri. ");
INSERT INTO gai_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Na meikramtaɨr ndeida mamo outta taŋrenanna, na ndeida mana iŋmbai nakɨprenan, mina muruŋa gaind ŋgaca mboprena, “Raraŋ Aetaniacmo toŋgoca wirairaŋ. Na Raraŋ Aetaniac, an ramootta Kacootna i mbuŋ nakɨprinanmo matau moraŋ. ");
INSERT INTO gai_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Na Raraŋ Aetaniac mandeaca u aina bubuocna gagrirta ramoot paŋanmo matau mo. Na an gagrirta ramoot paŋan, ma aina nicau Dewitna wiwitnan kɨprina. Na Raraŋ Aetaniac Tamuŋ Ŋgoinnanna imo aŋgɨ ŋgepraŋ!” ");
INSERT INTO gai_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Na Iesusa taŋga Ierusalem auŋ aniac ndaruca, ma Raraŋ Aetaniacna Kacna wuoc inikca mbukca, ma anna reikca watta taŋ, taŋga maica ra irik mbukna mori, ma ndona iŋa raŋgairena parniŋapa mbut mbuniŋna ramtaɨr aŋgɨca mina Betani auŋ mac nda mataŋgat. ");
INSERT INTO gai_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Na iŋmbaina ra, mina Betani auŋ tɨkcarica mina Ierusalem auŋ mac nda taŋre mbuŋa, Iesusa nik mawataiat. ");
INSERT INTO gai_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Na ma watrinanna, ik ŋgaŋɨn ianna tawan ŋgoinna eac ŋgocor, na ma raprir tiŋgikap. Aintik ma an ik ndambuŋa taŋca, mana gagaimbta orea wattatnanna, ma gagaimb kocor. Wanaiŋ ŋgoin. Raprir tiŋgikca ndori eacri, na anna ŋgaŋɨnarta erna ŋaŋaɨra wanaiŋ. ");
INSERT INTO gai_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ri, ma an ik ŋgaŋɨnmo gaindopatna, “U mba mac eritndai, te, meikramtaɨra unmo mba mac aŋgɨca amitndait. Wanaiŋ ŋgoin.” Na mana iŋa raŋgairena ramtaɨra an kammo waracrina. ");
INSERT INTO gai_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Karica Iesusapa mana iŋa raŋgairena ramtaɨra taŋga Ierusalem auŋ aniac ndaruca mambukat. Ri, ma Raraŋ Aetaniacna Kacna wuocna inikca mbukca, ma anna tɨkca kitukndukna aiŋa morena ramtaɨrmo ootta mandacatna. Na ma mina kitcartukar ŋgetrikirena ramtaɨrta barermo rapaca irikri, na ŋgorikmo mbik tɨkca oikrena ramtaɨrta mbibiracna reik motoca rapaca mairikat. ");
INSERT INTO gai_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Na ma minmo an Raraŋ Aetaniacna Kacna wuoc inikmo reik aŋgɨca kɨp narica wandɨk matɨkat. ");
INSERT INTO gai_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Na ma minmo gainda riptiatna, “Raraŋ Aetaniacna timbigta kapca aindoprena, ‘Aukna Kaca kabena pitrik waŋna meikramtaɨra muruŋa an nakɨpca aukmo mbendeinande.’ Na ne anmo macmakɨmna meikramtaɨrta iŋgorocna taupna kirara morina.” ");
INSERT INTO gai_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ainda moca taup ndamtaɨr paŋaindapa tɨpemb wandik tamŋirena ramtaɨra an kamma waracatke, mina mana mo menacna iroarta maoreat. Na mina ainda morinanna, mina man narica nanambirina. Na anna gaind, meikramtaɨra muruŋcamiŋa mana riptirena kambta moca ŋgep ŋgoreac naŋgeprena. ");
INSERT INTO gai_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Na wigwacmbai mbuŋa Iesusapa mana iŋa raŋgairena ramtaɨra Ierusalem tɨkcarica mina mataŋgat. ");
INSERT INTO gai_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Karica iŋmbaina rana ŋaŋarmuŋ ŋgoinna Iesusapa mana iŋa raŋgairena ramtaɨrap, mina mac nda kɨpca, mina an ik ŋgaŋɨnmo wattatnanna ma maguruat. Na an ikna raprirapa mana kacrir toco kocnaia gurumacariat. ");
INSERT INTO gai_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Na Pita an Iesusa moatna reac ndamŋiatke, ma gaindoprina, “Riripti u wat, ŋoura u an ik ŋgaŋɨnmo ŋgocraina ndopatnanna, mandeaca ma magururi.” ");
INSERT INTO gai_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","23","Karica Iesusa mana kammo gainda rutirina, “Aku nenmo gidik ŋgoinna gaindopnandet. Ne Raraŋ Aetaniacmo rɨpacraŋ. Na ramoot ianna gan takurmo gaindop te, ‘U ŋgepca macait inik ndaru irik.’ Na an ramootta ma iro nikinik mbuniŋ ŋgocor, na ma gaind ŋgoinna rɨpacrina, an reaca ma mbop te, ma larunandet. ");
INSERT INTO gai_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Na ne reac ian aŋgɨna moca rɨpaca, ne Raraŋ Aetaniacmo mbendei te, ne aŋgɨnande. Ainda moca ne rɨpac, Raraŋ Aetaniac, ma nenmo neaŋnande. Aintik aku nenmo gaind mambopek, an reaca ne mboprina kirar ndarunande. ");
INSERT INTO gai_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","“Na an kɨdrɨkca ne wɨtɨkca mbendeina mo te, na ne gaind ndamŋi, nenmo ramoot ianna tɨp ŋgoreacna makuk ianna morinan. Te, ne an ramootna tɨp ŋgoreacna makukmo mo kecari. Na nena Aetta tamuŋna auŋ ndeacrenan, ma nena tɨp ŋgoreacna makukmo ma mo kecarinandet.” ");
INSERT INTO gai_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Karica Iesusapa mana iŋa raŋgairena ramtaɨrap, mina Ierusalem mac nda taŋga malaruat. Na Iesusa taŋga Raraŋ Aetaniacna Kacna wuoc inikca ndada taŋrina. Ri, taup ndamtaɨr paŋaindapa tɨpemb wandik tamŋirena ramtaɨrapa ramtaɨr anikca mina man ndambuŋ nakɨprina. ");
INSERT INTO gai_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Na mina manmo gainda digiatna, “U an i aniacapa gargarmo u tenna tɨkca aŋgɨratna, na u an reikca morena? Na mandaia unmo an i aniac neaŋgatna, na unmo mbopca u an reikca morena?” ");
INSERT INTO gai_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Aindopatke Iesusa minmo gaindopatna, “Auk toco nenmo reac ianna digdigi ianap. Na ne aukna digdigimo wandoŋa ruti te, aku nenmo mbopnandet, mandaia ndo aukmo an i aniac neaŋga aku an aiŋira morena. ");
INSERT INTO gai_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Na an mɨnna Ionna meikramtaɨrmo kɨtac pukca morinanna, ne tit ndamŋiatna, anna tamuŋna auŋna reac, co, anna meikramtaɨrta reac niŋgik? Ne aukna kambmo nda ruti.” ");
INSERT INTO gai_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ainda moca mina ndori puŋga gaindopatna, “Aia gaindop te, ‘Anna tamuŋna auŋna reac.’ Na ma aimo aindopnande, ‘Aind ecte, kaina moca ne Ionmo rɨpac ŋgocor?’ ");
INSERT INTO gai_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Na aia gaindop te, ‘Anna ramootna reac niŋgik,’ an kam toca mɨnna mba tɨkitndai.” Na mina aindoprinanna, mina meikramtaɨrta nanambirina. Na meikramtaɨra muruŋcamiŋa aind ndamŋirena, Ionna ma ramma morena ramoot gidik. ");
INSERT INTO gai_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ainda moca mina mana kammo gainda rutirina, “Aia mba lamŋireke.” Ri, Iesusa minmo gaindopatna, “Aind ecte, auk toco nemo mba mbopitndai, mandaia ndo aukmo an gargarapa i aniac neaŋga aku an aiŋa morena.” ");
INSERT INTO gai_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ainda moca Iesusa Iudana ramtaɨr paŋaindmo kamb rour ndeid makeat. Na ma gaindoprina, “Ramoot ianna wainna warɨŋ ianna moca, na ma anmo wuoc ŋgaocrina. Na ma au ianna iacrina, anmo wainna lourmo anna tɨkca kɨtac wɨtɨkca wain puk aŋgɨna moca. Na ma warɨŋna ndam ianna mamoat, te, ramtaɨrmo an ndeac te, warɨŋna ŋginaŋa mona moca. Na ma an wain warɨŋmo raupŋirena ramtaɨr ndeidta para tɨkcarica. Na ma ndo ŋgoinna tawanna auŋ ian mataŋgat. ");
INSERT INTO gai_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Na an mɨnna wainna erca, rua maiatke, ma ndona mbaiŋna aiŋa morena ramoot ianmo mbagɨrica ma an wain warɨŋna raupŋirena ramtaɨr tambuŋa taŋca, mina manmo an warɨŋna wain neaŋna moca. ");
INSERT INTO gai_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ri, an warɨŋ raupŋirena ramtaɨra an ramootmo muoca utiŋga, manmo laŋa mba piatke, na mamo par kamainda mbagɨrica ma nda mataŋgat. ");
INSERT INTO gai_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Na an warɨŋna aetta kabena mbaiŋna ramoot ian mac mbagɨrica min ndambuŋa taŋrina. Na mina manmo pia paŋan titacri, na mamo numbirta kamb ndopca, na manmo tɨpemb ŋgorikca morina. ");
INSERT INTO gai_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Na ma kabena mbaiŋna ramoot ian tuk mac mbagɨriatna, na mina manmo moa menacatna. Na iŋmbaia ma ndona mbaiŋna aiŋa morena ramtaɨr wɨtmo mbagɨrina, na mina ndeidmo ruŋgatke, na ndeidmo mina pia mamenacat. ");
INSERT INTO gai_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Na ramoot kabe niŋgikca ndo eacrenanna, anna mana matŋirena nuoc kabe niŋgik. Na iŋmbai ŋgoinna ma an nuocmo mbagɨrica ma an wainna warɨŋna aiŋa morena ramtaɨr tambuŋa taŋgatna. Na an warɨŋna aetta aindopatna, ‘Mina aukna nuocmo tori te, mana kammo waracnandet.’ ");
INSERT INTO gai_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Na an wain warɨŋ raupŋirena ramtaɨra ndorita rɨkmo gaindoprina, ‘Gan ramoot, ma ndona aetna reikmo ma muruŋ naaŋgɨca ma aetta monande. Aria, aia manmo mo menac te, mana reikmo aia aetera mona.’ ");
INSERT INTO gai_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Aintik mina manmo aŋgɨca, mamo mo menacrina. Na mina mana waɨrmo aŋgɨrca warɨŋ roumbca keca malaruat. ");
INSERT INTO gai_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Na an warɨŋna aetta ma tida moit? Ne warac. Ma kɨpca an wain warɨŋ raupŋirena ramtaɨrmo mo menacnandet. Te, ma an wain warɨŋmo kabena ramtaɨrta paɨra tɨknandet. ");
INSERT INTO gai_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","“Na gan kam tɨpca Raraŋ Aetaniacna Timbigta Kap ndeacrenanna, ne mba watre ki, a? Na an kamma ma gaind, ‘Na gan kaca morena wautmo, ramtaɨra anmo ŋgoreac ndopca, aŋgɨra roumbmbai ndakecariatna wautta, mandeaca ma kacna witta moca, paŋanmbaia wɨtɨkca kacmo moa gagraca maeacreke. ");
INSERT INTO gai_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Na Kacootta ndo an reaca mo larurina, aia watrinan, Ma laŋ ŋgoin.’” ");
INSERT INTO gai_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Na an ramtaɨr paŋainda lamŋirena, Iesusa keatna kam roora, anna min ŋgoin ndopapekna. Na mina manmo muoc utiŋna toŋtoŋgar koind, na mina meikramtaɨr tarica rugdar mamoat. Ainda moca mina manmo watcarica mina mataŋgat. ");
INSERT INTO gai_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ainda moca ramtaɨr paŋainda Parisina ramtaɨr ndeidapa gagrirta ramoot paŋan Erotna tumbunna ramtaɨr ndeidmo, mbagɨrica mina Iesus ndambuŋa taŋgatna. Na mina Iesusmo paruca ma kam ndeidmo, ma katti mbop te, mina mana an kam mbuŋa nda ritri waparaca monande. ");
INSERT INTO gai_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ainda moca mina kɨpca manmo gaindopatna, “Riripti, aia lamŋirena u kam gidikca ndoprena. Na u ramoot ian nake mba irikca mbiracrenanna. Na u meikramtaɨrmo kamb kirar kabe ndoprena. Mindacniŋ mandaia irembtan, co, iremb kocortan. Na kam gidik mbuŋa u meikramtaɨrmo Raraŋ Aetaniacna tɨpemb kirarirmo riptirena. Aintik u tit ndamŋirena? Aia an gagrirta ramoot paŋan aniac Sisana kitcartukar iurena ramtaɨrmo, kitukndukca neaŋit ki, co, wanaiŋ? Na aia neaŋit, co, kariit?” ");
INSERT INTO gai_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Na Iesusa ma atuna mina paparuna kambca ma lamŋirena, na minmo gaindoprina, “Kaina moca ne aukmo towaiapekna? Aukmo kituknduk ian aŋgɨ kɨpca aku watna.” ");
INSERT INTO gai_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ri, mina kituknduk ianmo aŋgɨ kɨpca manmo neaŋga. Na ma minmo gainda digiatna, “Gan inpaŋanna titrirapa ia anna mandainan?” Ri, mina aindopatna, “Anna Sisanan.” ");
INSERT INTO gai_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ainda moca Iesusa minmo gaindoprina, “Sisana reac ecte, laŋ, ne Sisamo neaŋ. Na Raraŋ Aetaniacna reac ecte, ne Raraŋ Aetaniacmo neaŋ.” Na mina mana kamma waraca mina ŋgep ŋgoreac ŋgoin naŋgeprina. ");
INSERT INTO gai_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Karica Sadisina ramtaɨr ndeida Iesus ndambuŋ nakɨpca, mamo digdigiar ndeid madigiat. Na an tumbunna ramtaɨra aindoprena, menacrena meikramtaɨra, mina mba mac nda ŋgepitndai. Ainda moca mina Iesusmo gaindopatna, ");
INSERT INTO gai_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Riripti, Mosesa aimo tɨp wandɨk ianna tirra gaindoprina. Ramoot ianna menac te, na ma mombonik kocor, na mana meac konimma menac ŋgocor, na ma eac te. An menacatna ramootna lapmbitaca ma an meac konimmo laŋgonande, te, ma mana mombonikca mo laru te, an menacatna ramootna kaminna mba topitndai, ma eacraŋnandet. ");
INSERT INTO gai_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Na ŋgaua kalaip parmbaiapa mbut mbuniŋa eacrinan. Na ramoot lacaua ma meac ianna laŋgoca, ma mamenacat, na ma mombonik kocor. ");
INSERT INTO gai_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ainda moca man ndambuŋna lapmbitaca, an meac konim mac malaŋgoat. Na ma toco, mamenacat, na ma mombonik kocor. Na an ndambuŋna lapmbitac tukca aind kirar kabe mamoat. ");
INSERT INTO gai_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ainda moca an kalaip parmbaiapa mbut mbuniŋa, mina muruŋa an meac konim malaŋgoat, na mina muruŋa mombonik kocor, na mina muruŋa mamenacat. Na iŋmbai ŋgoinna an meac konim toco mamenacat. ");
INSERT INTO gai_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Na iŋmbaia an menacatna ramtaɨra nda ŋgep te, an meac konimma ma mandai ŋgoinna meac ndeacit? Na u lamŋirina, an ramtaɨrpaikca an meac konimmo muruŋa laŋgoatna, na ma mina meac ndeacrina.” ");
INSERT INTO gai_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Karica Iesusa minmo gaindopatna, “Ne Raraŋ Aetaniacna timbigta kap ndeacrena kambmo, ne mba lamŋireke. Na ne Raraŋ Aetaniacna gargar tocmo mba lamŋireke. Aintik ne an kambmo katta mboprena. ");
INSERT INTO gai_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Na an mɨnna meikramtaɨra menacrinanna, muk tɨkcarica mac nda ŋgep te, an meikramtaɨrmo mina minmo mba neaŋ laŋgoit, co mac laŋgoit. Wanaiŋ ŋgoin. Mina an tamuŋna auŋna mbaiŋna aiŋa morena ŋerŋgaur toc ndeacnandet. ");
INSERT INTO gai_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","“Na an meikramtaɨra menaca, mac nda ŋgepatna kamma, ne Mosesna timbigta kapna inikna nininia, taca ik tekera wɨrrinanna ne mba watatke, a? Na an nininina inikca Raraŋ Aetaniaca Mosesmo gaindopatna, ‘Aku, Abraamapa Aisakapa Iakopna Raraŋ Aetaniac.’ ");
INSERT INTO gai_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Na Raraŋ Aetaniac, ma menacrina meikramtaɨrta Raraŋ Aetaniaca wanaiŋ. Ma meikramtaɨra eteacna watap eacrena Raraŋ Aetaniac. Aintik nena kambca anna makatri.” ");
INSERT INTO gai_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Karica tɨpemb wandik tamŋirena ramoot ianna kɨpca waracrinanna, Sadisina ramtaɨra Iesusap kamb puŋga ipuŋga mboprina. Na ma waracrinanna, Iesusa mina kambmo matau ŋgoinna nda rutirina. Ainda moca ma Iesusmo gainda digirina, “Titocna Tɨp Wandɨkca ma Tɨpemb Wandikmo muruŋa kundrina, na ma out ndeacrena?” ");
INSERT INTO gai_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ri, Iesusa mana kammo gainda rutirina, “Out ŋgoinna Tɨp Wandɨkca gaind, ‘Ne Israelnaŋgep, ne matau ŋgoinna warac. Kacoot, ma ndo kabe niŋgikca, ma aina Raraŋ Aetaniac. ");
INSERT INTO gai_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Na u Raraŋ Aetaniac niŋgikmo matŋiraŋ, ma una Kacoot. Na u manmo una iro nikinikapa, una ŋeroŋapa, una iroapa, una gargarapmo matŋiraŋ.’ ");
INSERT INTO gai_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Na an ndambuŋna Tɨp Wandɨk ianna anna gade, ‘U ndona kamkabemo, u ndoa matŋia morena kirara, min motoco u ainda mo.’ Na kabena Tɨp Wandɨk aniac ianna eac ŋgocor, na an Tɨp Wandɨkniŋmo mba kunitndai. Wanaiŋ.” ");
INSERT INTO gai_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ainda moca an tɨpemb wandik tamŋirena ramootta Iesusmo gaindoprina, “Riripti, una kamma anna laŋ ŋgoin. Na ma gidik ŋgoin, Kacootta ma ndo kabe niŋgikca Raraŋ Aetaniac, na kabena Raraŋ Aetaniaca eac ŋgocor. ");
INSERT INTO gai_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Na aia manmo ndorita iroar inkarapa landamŋiarapa, aina gagrar koind puŋgap manmo matŋiraŋ. Na aia ndorita kamkabearmo, aia ndori koinda matŋia morena kirarira, aia min motocmo ainda mo. Na aia an Tɨp Wandɨkniŋmo raŋgai te, an Tɨp Wandɨkca, ma mina an tac mbuŋa kocnaia rotacrena gɨmbambarmo maniŋa kundrina. Na titocna gɨmbambar toco, ma kundrina.” ");
INSERT INTO gai_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Na Iesusa waracrinanna, an ramootta kambmo rutirinanna, anna ramootta iro landamŋi laŋapna ramootna kirar. Ri, Iesusa manmo gaindoprina, “U Raraŋ Aetaniacna bubuocmo, u tawanmbaica mba eacrena.” Ainda moca meikramtaɨra muruŋa manmo digdigiara digina rugdar morina. ");
INSERT INTO gai_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ainda moca Iesusa Raraŋ Aetaniacna Kacna wuoc inik ndeacri, ma meikramtaɨrmo kamb riptirina. Na ma gaindoprina, “Tida moca tɨpemb wandik tamŋirena ramtaɨra gaindoprenan, an ramootta Raraŋ Aetaniaca babuca mbagɨrica kɨpca aimo mac nda aŋgɨna ramoot, anna Dewitna ŋgamaɨr? ");
INSERT INTO gai_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Na Ŋeroŋ Ratta Dewitmo iro landamŋi neaŋrina, na Dewit, ma ndo ŋgoinna gaindopatna, ‘Raraŋ Aetaniac Kacootta aukna Kacootmo gaindopatna, “U aukna par umbaia mbirac te, aku una puŋnaŋgepmo aŋgɨri, una kaŋgaukca tɨknande.”’ ");
INSERT INTO gai_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Na Dewit, ma ndo ŋgoinna an ramootmo ndona Kacoot ŋgacrena. Na kaica an ramootta ma Dewitna ŋgamaɨr?” Ainda moca meikramtaɨrta mɨmɨat aniaca eacri, na mina Iesusna kamb mbaracna toŋtoŋgar koind. ");
INSERT INTO gai_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Na Iesusa meikramtaɨrmo riptirena, na ma gaindopatna, “Ne tɨpemb wandik tamŋirena ramtaɨrtake, matau wat. Mina ndorimo meikramtaɨra mbik tɨkca taŋga oikrena taupembmo, mina tik ŋgapoik roctir tɨkca taŋ te, meikramtaɨra mbikir tɨkca oikrena taupembca tɨkca minmo ndorimo ra laŋ neaŋraŋna moca. ");
INSERT INTO gai_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Na mina toŋgorenanna, mina Iudananta mimitpac aŋgɨrena kaik inkarta outrembta mbibiraikta taupemb laiŋta riacrena. Na amtiamb anikta raia, mina ndorimo outrembta mbibiraikta taupemb laiŋ aŋgɨna riacrena. ");
INSERT INTO gai_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Na mina meik koinmbarmo parureke, mina kaik barermo wanainir naaŋgɨrena. Na mina paparuarta mbembendeia roctira morena. Ainda morena ramtaɨr, iŋmbaia ritri waparacna ra laru te, mina makukar bagararanik koind aŋgɨnande.” ");
INSERT INTO gai_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Karica Iesusa an ririptina kamb ndopa maiatke, ma taŋga Raraŋ Aetaniacna Kacna wuoc inikca mbukca taŋga kitukndukar tɨkrena taupca taŋca anna roumbmbai mambiracat. Ri, ma watrinanna meikramtaɨr wɨtta kɨpca ndorita gɨmbamba mona kitcartukarmo, an kituknduk tɨkrena taupca tɨkrina. Na laimnembta meikramtaɨr wɨtta kɨpca ndorita kitukndukar wɨt matɨkat. ");
INSERT INTO gai_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Na reik kocorta meac konim ndaekmbai ianna kɨpca ma kituknduk mbuniŋ nocniŋ tɨkrina. ");
INSERT INTO gai_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ri, Iesusa ndona iŋa raŋgairena ramtaɨrmo aca kɨpca, ma minmo gaindopatna, “Aku nemo gidik ŋgoinna gaindopnandet, gan reik kocorta meac konim ndaekmbaia, tɨkcapekna kitukndukca, an meikramtaɨr muruŋnan tɨkcapekna kitcartukarmo kunda tamuŋ ŋgoin. ");
INSERT INTO gai_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Na an meikramtaɨr wɨtta mina kitukndukar wɨtap, na mina mbatep niŋgik neaŋrina. Na an meaca ma kamaind ŋgoin, ma ndoap eacrena mɨnna kitukndukca ma an tɨkrina. Na ma ndona amta reik koikna kitukndukar kocor.” ");
INSERT INTO gai_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Karica Iesusa Raraŋ Aetaniacna Kacna wuoc tɨkcarica taŋgatke, mana iŋa raŋgairena ramtaɨrta ianna manmo gaindopatna, “Riripti, an Kacna watur laiŋapa kaik laiŋmo, u wat!” ");
INSERT INTO gai_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ri, Iesusa mana kammo gainda rutirina, “U an kaik anikmo watrinanna, a? Mina an waturmo mba watcarica mina ndori tambatta mba mac eacitndai. Wanaiŋ ŋgoin. Mina an waturmo kocnai rɨŋi bɨrɨrɨ iriknande, na mina mbinmbata mba mac eacitndait.” ");
INSERT INTO gai_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Karica mina taŋga Olip Takur ndaruca Iesusa taŋga mbiraca Raraŋ Aetaniacna Kaca watta taŋri. Na Pitaapa, Iemisapa, Ionapa, Andruap min niŋgikca man ndambuŋa kɨprina. Na manmo gainda digiatna, ");
INSERT INTO gai_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“U aimo mbop, tumbuitta tɨk te, an reikca laruit? Na titna ŋgagatraca ndo out ndaru te, aia lamŋinande, an reik lataruna kɨdrɨkca maica kɨpca marambuŋairi?” ");
INSERT INTO gai_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Na ma mina kammo gainda nda rutirina, “Ne ndoritake, matau wat. Moca ramoot ianna nenmo paru nari. ");
INSERT INTO gai_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Na meikramtaɨr wɨtta kɨpca aukna i ŋgaca gaindopnandet, ‘Aku ndo, ande an ramoot.’ Te, mina meikramtaɨr wɨtmo parunandet. ");
INSERT INTO gai_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","“Na iŋmbaia ne runduikta mɨmɨtara warac te, na ne kabena pitrik waŋna runduikta kam wembaŋa warac te, ne ŋgep ŋgoreaca kai ŋgep teac. Na an reikca mina larunandet, na gan tiacarpaikna mamamaia mba larureke. ");
INSERT INTO gai_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Na kabena pitrik waŋna ramtaɨra kabena pitrik waŋna ramtaɨrap runduŋa monandet. Na kabena gagrirta ramtaɨr paŋaindta wiwitna ramtaɨra mina ŋgepca kabena gagrirta ramtaɨr paŋaindta wiwitap ruŋnande. Na gan tiacarpaikna auŋemb ndeida numnumar anikca larunandet, na nik wapatai aniaca larunandet. Na an reikca anna meacmbita mɨrna irikca aŋgɨca eacrena gɨrgɨrna kirar toc. ");
INSERT INTO gai_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Na an mɨnna ne ndoritake, matau wat. Na mina nenmo ndorita ninikar waŋgorta outta tɨkca ritri waparaca monandet. Na mina nenmo Iudananta mimitpac aŋgɨrena kaikca tɨkca pinandet. Na mina aukna imo mo irikna moca nenmo ndorita gagrirta ramtaɨr paŋaindapa ramtaɨr anikta out naaŋgɨ wɨtɨkna iroara monandet. Aintik ne minmo kam wembaŋ laŋ wiwiti. ");
INSERT INTO gai_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Na gan tiacarpaikca mai ŋgocor ndeacraŋ te, kam wembaŋ laŋna kamma ma out ŋgoinna gan pitrik waŋna meikramtaɨrmo muruŋcamiŋa taŋca mina waracnandet. ");
INSERT INTO gai_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Na an mɨnna mina nenmo muoc leaca ritri waparacna taup naaŋgɨ taŋ te, ne kai nanambica gainda kai lamŋi teac, ‘Aia tida moit?’ Wanaiŋ. An mɨnna Raraŋ Aetaniaca nenmo mbombopna kambmo muruŋcamiŋa neaŋnandet, na anna ne wiwitinandet. Na anna gaind, ne ndori puŋga kambca mba wiwitiitndai. Wanaiŋ. Ŋeroŋ Ratta ndo an kambmo wiwitinandet. ");
INSERT INTO gai_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Na kalaipa ndorita ianmo ritri waparaca tɨkca, mamo mo menacna kamb topnandet. Na aetera ndorita mombonikmo an tɨpembta kirar kabea monandet. Na mombonikca ndorita ameraetermo puŋnaŋgepca moca, ramtaɨrmo mbopca mina mo menacna kamb ndopnandet. ");
INSERT INTO gai_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Na meikramtaɨra muruŋa nenmo nikembkatnandet, na anna gaind, aukna ia nenap eacrena. Na meikramtaɨra gagraca eaci taŋi gan tiacarpaikna mamamaina ra laru te, Raraŋ Aetaniaca minmo mac nda aŋgɨnandet.” ");
INSERT INTO gai_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Na Makca gan timbigta kapca tirrina kamma ma gaindopatna, “Ramootta gan kamma wat te, ma matau ŋgoin ndamŋiraŋ.” Na an kamma Iesusa gaind mac mbopatna, “An wandɨk tɨkrina taupca reac ŋgoreac ŋgoinna wɨtɨkca eacrenanna, ne anna tɨki watnandet. Na an mɨnna meikramtaɨra Iudiana pitrik inik ndeacrenanna, mina kɨpcarica taukruirca taŋnandet. ");
INSERT INTO gai_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Na ramootta kacmo tamuŋmbaica eac te, ma irik te, ma kaca mba mbukca reac ianna mba aŋgɨritndai. ");
INSERT INTO gai_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Na ramootta warɨŋ inik ndeac te, ma ndona kacmo mba nda taŋca ndona tik ŋgapaoc rocotta mba aŋgɨritndai. ");
INSERT INTO gai_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Na nikembta meikpitikapa meikpitikca mombonikca mɨr ambrenanna, an mɨnna minpembta moca kadmai. ");
INSERT INTO gai_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Na ne mbendeica an tik gagagauna kɨdrɨkca an reikca nenmo kai laru teac. ");
INSERT INTO gai_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Na an mɨnna makuk aniaca larunandet. Na Raraŋ Aetaniaca reikca moatna mɨn mbuŋa tɨkca, kɨp, kɨpca mandeacna mɨnna, aintocna makukca laru ŋgocor. Na iŋmbai toco ainta makuk ian toco mba mac laruitndait. ");
INSERT INTO gai_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Na Kacootta an makuk laruna kɨdrɨkca mo matpi ŋgocor te, meikramtaɨra muruŋcamiŋa topnandet. Na ma ndona larapacrina meikramtaɨrta moca lamŋiatke, ma an kɨdrɨkmo mo matpinandet. ");
INSERT INTO gai_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Na an mɨnna ramoot ianna nenmo gaindop te, ‘Ne wat, Raraŋ Aetaniaca babuca mbagɨrica kɨpca aimo mac nda aŋgɨna ramootta, ma gan ndeacrena!’ Co, ‘Ne wat, ma mon ndeacrena.’ Na ne mina kambmo kai rɨpac teac. ");
INSERT INTO gai_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Na ramtaɨr ndeida kɨpca nenmo gaindopnandet, ‘Aku gade an ramootta Raraŋ Aetaniaca babuca mbagɨrica kɨpca aimo mac nda aŋgɨna ramoot,’ co, ‘Aku ramma morena ramoot ian.’ Te, mina ŋgagatracara moraŋ te, aintocna reik damara mo larunandet. Na gidik ŋgoin, mina mɨn te, mina an Raraŋ Aetaniaca larapacrina meikramtaɨrmo parunandet. ");
INSERT INTO gai_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ainda moca ne ndoritake, matau wat. Na aku nenmo reik lataruna kambca mambopreke.” ");
INSERT INTO gai_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Karica ma gaind mac mbopatna, “Na an makukna kɨdrɨkca mai te, ‘An kɨdrɨkca ra ma uriraca taŋca mouŋna kirar toc ndarunandet, te, karwaia ma mba mac metacitndai, ");
INSERT INTO gai_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","te, guiara riac tamuŋmo tɨkcarica pɨkɨn ŋgiriknandet, te, riac tamuŋna reik gagrarca numainandet.’ ");
INSERT INTO gai_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Te, an mɨnna meikramtaɨra Ramootna Nuocmo watnandet, ma wawɨrirpaikna inik ndeaca, ma ndona memetacna tac aniacapa gargar aniacap kɨpnandet. ");
INSERT INTO gai_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Na an mɨn toco, ma ndona mbaiŋna aiŋa morena ŋerŋgaurmo mbagɨrica taŋca, ma ndonan ŋgoinna larapacrina meikramtaɨrmo aŋgɨri puninandet. Na ma minmo muruŋa gan tiacarpaikna pitrikca tɨkca aŋgɨ taŋca gan tiacarpaikapa riacna mamamaina mɨn.” ");
INSERT INTO gai_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Karica Iesusa minmo gaind mac mbopatna, “An mɨnna ne ik kembera wat te, ne iroar aŋgɨnande. Mana ŋaikca uprir ŋgaibca weweru te, ne lamŋinandet, pukrapacna kɨdrɨkca makɨpek. ");
INSERT INTO gai_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Aintik an kirar kabea ne an reik larueknanna wat te, ne lamŋinandet, Ramootna Nuoca kɨpca marambuŋairi. Na ma tɨŋ kam maeacreke. ");
INSERT INTO gai_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Na aku nemo gidik ŋgoinna aindopnande, gan mɨnna meikramtaɨra menac ŋgocor ndeacraŋ te, mina an reik larueknanna, mina watnandet. ");
INSERT INTO gai_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Na gan tiacarpaikapa riac tamuŋa topnandet, na aukna kambca mba topitndai.” ");
INSERT INTO gai_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Karica Iesusa gaind mac mbopatna, “Ramoot ianna an reik lataruna ra, co, ŋgaŋganŋgɨca mba lamŋireke. Na Raraŋ Aetaniacna tamuŋna auŋna mbaiŋna aiŋa morena ŋerŋgaur toco mba lamŋireke, na Raraŋ Aetaniacna Nuoc toco mba lamŋireke. Aetta ndo kabe niŋgikca ma ndo lamŋirena. ");
INSERT INTO gai_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","“Na ne matau wat. Ne memetmbaca kocroca eacraŋ. Na anna gaind, an reik lataruna kɨdrɨkca ne mba lamŋireke. ");
INSERT INTO gai_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Na ma gaindta kirar, ramoot ianna ma ndona kac tɨkcarica ma kabena auŋa taŋrina. Na ma ndona mbaiŋna aiŋa morena ramtaɨrmo ndona reikmo raupŋina mboprina, na ma minmo kabe, kabemo aiŋir biŋairina. Na ma an tɨŋna ŋginaŋa morena ramootmo mboprina, ma an tɨŋna ŋginaŋmo matau watti eacraŋ. ");
INSERT INTO gai_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Aintik ne toco matau watti eacraŋ. Na ne mba lamŋireke, kaina mɨn mbuŋa tɨkca kacna aetta mac nda kɨpit. Ma wigwacmbai, co mouŋ rɨktacniŋ, co kackur aprena kɨdrɨk, co ŋaŋarmuŋ, anna ne mba lamŋireke. ");
INSERT INTO gai_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Na moca ma tawi ŋgoin nda kɨp te, ma nenmo wat nari, ne maŋgoreke. ");
INSERT INTO gai_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Na an kambca aku nenmo neaŋrenan, anna aku meikramtaɨrmo muruŋa neaŋrina. Na memetmbaca ne kocroca eacraŋ.” ");
INSERT INTO gai_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Karica rarapmbai mbuŋa an Pasowana Ra Aniacna ndamŋinanapa Isap Kuri Ŋgocorta Tapacna Ra Aniacna ndamŋirena ra, ma larunande. Ri, taup ndamtaɨr paŋaindapa tɨpemb wandik tamŋirena ramtaɨra gaindopatna, “Titoca tɨkca aia Iesusmo muoc utiŋa manmo mo menacit?” ");
INSERT INTO gai_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Na mina aindopatna, “Aia Raraŋ Aetaniacna mbembendeina rai anikta inikca kai mo teac? Moca meikramtaɨra anna watca mina aimo kaegapa runduŋ aniaca mo ŋgep nari.” ");
INSERT INTO gai_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Na Iesusa taŋga Betani auŋ ndaruca ma taŋga Saimonna kac ndeacri. Na Saimon tikca ŋgaua ma roumb lepaap. Na Iesusa ambrena taupca mbiraca eacri, meac ianna makɨpat. Na an meaca ma tabaɨra rurena waut mbuŋa morina reac ianap aŋgɨrca makɨpri. Na an reaca ma kituknduk aniac mbuŋa oikrena iŋpai laŋ ŋgoinna tabaɨrap. Na ma an reacmo pi wɨrɨpca anna tabaɨrmo Iesusna paŋan nambat maruŋkiat. ");
INSERT INTO gai_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Na an ndeacrina ramtaɨr ndeida anna watca mina nikembkatca. Karica mina ndorimo gaindopatna, “Kaina moca ma an tabaɨrmo wanaiŋa ruŋkiapekna? ");
INSERT INTO gai_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Na aia an tabaɨrmo watcarica meikramtaɨra oik te, aia 300na mɨnna silwana kitukndukar aŋgɨrca meikramtaɨr ndaekpembca neaŋna mɨn.” Ainda moca mina an meacmo kaega morina. ");
INSERT INTO gai_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ri, Iesusa aindopatna, “Ne an meacmo watcari. Kaina moca ne manmo makukar neaŋrena? Ma aukmo tɨp kirar laŋ ŋgoinna moapekna. ");
INSERT INTO gai_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Na memetmbaca reik kocorta meikramtaɨr ndaekpembca nenap eacraŋnande. Na ne minmo tumbuitta otacna toŋtoŋgarap, ne minmo otacna mɨn. Na aku ndo, aku nenapmo memetmbaca mba eacitndai. ");
INSERT INTO gai_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","An reaca an meaca mona mɨn tik, ma morina. Na ma aukna tikmo iŋpai laŋna tabaɨr tɨkrinanna, anna ma aukna tikmo mukca tɨkna kocrorina. ");
INSERT INTO gai_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Na aku nemo gidik ŋgoinna aindopnande, gan tiacarpaikca mina kam wembaŋ laŋmo wiwiti taŋ te, mina gan meaca morina reacna kambmo niniraŋnandet. Te, mina man moatna reacna ndamŋiraŋnandet.” ");
INSERT INTO gai_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ainda moca an kɨdrɨkca Iesusna iŋa raŋgairena ramtaɨrta ianna, mana ia Iudas Iskariot, ma taup ndamtaɨr paŋaind tambuŋa taŋrina. Ma Iesusmo mina para tɨkna moca. ");
INSERT INTO gai_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Na mina anna waraca toŋtoŋgar koind. Na mina manmo kituknduk ndeid neaŋna kam maleacat. Ainda moca Iudasa ŋgepca Iesusmo tida tɨkca mina para tɨkna malamŋiri. ");
INSERT INTO gai_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Karica an Isap Kuri Ŋgocorta Tapacna Ra Aniacna ra lacaua malaruat. Na an ra mbuŋa mina sipsipar ŋgaibmo mo menac te, an am te, an Pasowana Rana ndamŋina moca. Ri, mana iŋa raŋgairena ramtaɨra gaindoprina, “U toŋgorinanna aia tenna tɨkca reik kocroit, te, aia amtiamma mona?” ");
INSERT INTO gai_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ainda moca Iesusa ndona iŋa raŋgairena ramtaɨrta ramoot mbuniŋa mandaca, aindoprina, “Oŋgo an auŋ aniacmo taŋca mbuk te. Ramoot ianna puk wɨn aniac ian mbukca kɨprenanna, oŋmo taupca tɨkca ndauprikinandet. Te, oŋgo mana raŋgaica taŋ. ");
INSERT INTO gai_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Na an kɨdrɨkca ma kac ianna mbuk te, oŋgo an kacna aetmo gaindop, ‘Ririptia aindoprina, “Aukna diab inikca ten ndeacre? Te, aukapa aukna iŋa raŋgairena ramtaɨra an amna reacmo am te, an Pasowana Rana ndamŋina.”’” ");
INSERT INTO gai_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Te, ma oŋmo kac tamuŋmbaina diab inik aniac ian wandacnande. Na amna reac tɨkca ambrena taupapa mbibiracna taupca, mina kocro maica eacrena. Te, oŋgo aina amta reikmo an diab inikca tɨkca kocro. ");
INSERT INTO gai_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ainda moca mana iŋa raŋgairena ramtaɨrta ramootniŋa mataŋgat. Na maniŋa taŋga an auŋ aniac ndaruca, maniŋa watrinanna, an reikca muruŋa Iesusa mboprina kirar toc ndeacrina. Ri, maniŋa Pasowana amta reikmo anna tɨkca kocrorina. ");
INSERT INTO gai_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Na wigwacmbai mbuŋa Iesusapa mana iŋa raŋgairena parniŋapa mbut mbuniŋna ramtaɨrap mina kɨprinan. ");
INSERT INTO gai_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Na mina amna reacna taupca mbiraca ambri mbuŋa Iesusa gaindopatna, “Aku nemo gidik ŋgoinna aindopnande, nena rɨkna ramoot ianna aukmo, aukna puŋnaŋgepta para tɨknandet. Na mandeaca ma aukap maambreke.” ");
INSERT INTO gai_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Na mana iŋa raŋgairena ramtaɨra an kamma waraca mina makadmairi, mina kabe, kabea ŋgepca manmo gaind madigiat, “U auk ki, ndopre ki, a?” ");
INSERT INTO gai_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ri, Iesusa minmo gaindoprina, “An ramootta ma nena parniŋapa mbut mbuniŋna rɨkna ian. Na an ramootta ma tapac tɨpmo aŋgɨca aukap tuoŋ inikca keca pukca ambrena. ");
INSERT INTO gai_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Na anna gidik, Ramootna Nuoca ma menacnandet, an tɨpna kirara Raraŋ Aetaniacna timbigta kapca mboprinanna, ma ainda menacnandet. Na an ramootta, ma Ramootna Nuocmo puŋnaŋgepta para tɨkrinan, man mbaina kakadmai ŋgoin, ma makuk aniac ŋgoin aŋgɨnandet. Na mana aemma manmo mɨr ŋgocor co, an reaca manmo mba laru mbe.” ");
INSERT INTO gai_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ainda moca mina ambca eacri, Iesusa tapac ian aŋgɨrca, ma Raraŋ Aetaniacmo mbendeica kam laŋ neaŋgacarica, ma an tapacmo witkica ma ndona iŋa raŋgairena ramtaɨrmo maneaŋgat. Na ma gaindopatna, “Ne aŋgɨ, anna aukna tikbuit.” ");
INSERT INTO gai_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Na ma wain pukna kab ian aŋgɨrca, ma Raraŋ Aetaniacmo mbendeica, kam laŋ neaŋgacarica, ma minmo maneaŋgat. Na mina muruŋa an ambrina. ");
INSERT INTO gai_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ri, ma minmo gaindopatna, “Ganna aukna racaindpaik, na an mbuŋa Raraŋ Aetaniacap kam leacrina. Na aku ruŋkinande, te, meikramtaɨr wɨtmo otacnandet. ");
INSERT INTO gai_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Na aku nemo gidik ŋgoinna aindopnande, aku wain pukca mba amitndai, taŋca an mɨnna aku wain puk ŋgammo Raraŋ Aetaniacna bubuoc ŋgamma tɨkca amnandet.” ");
INSERT INTO gai_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Karica mina ŋap ian ŋgumbca, mina ŋgepca auŋ aniac Ierusalem tɨkcarica mina Olip Takur mac nda mataŋgat. ");
INSERT INTO gai_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Karica Iesusa ndona iŋa raŋgairena ramtaɨrmo gaindopatna, “Nena rɨtɨpaikca iriknandet, na anna gaind, Raraŋ Aetaniacna timbigta kapca gaindta kammap, ‘Aku sipsiparta ŋginaŋa morena ramootta mo menac te, sipsipara kɨpcarica tamtamma taŋnandet.’ ");
INSERT INTO gai_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Na aku muk ndiŋ mac ŋgepca nenmo outta Galilia taŋnandet.” ");
INSERT INTO gai_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ri, Pita manmo gaindopatna, “Aku mba nduitndai, mina muruŋna rɨtɨpaca irik te, na mina unmo tɨkcari te, aku unmo mba tɨkcariitndai.” ");
INSERT INTO gai_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Na Iesusa manmo gaindoprina, “Aku unmo gidik ŋgoinna aindopnande, mandeac mouŋa kackura kɨdrɨk mbuniŋa ap ŋgocor ndeacraŋ te, u kɨdrɨk mbonkaca aindopnandet, u aukmo lamŋi ŋgocor.” ");
INSERT INTO gai_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ri, Pita gagraca gaindopatna, “Wanaiŋ ŋgoin, aku unap menacnandet, na aku ainda mba mbopitndai. Aku unmo mba lamŋirena!” Na mana iŋa raŋgairena ramtaɨra muruŋa an kam kirar kabe mambopat. ");
INSERT INTO gai_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Karica Iesusapa mana iŋa raŋgairena ramtaɨra taŋga mina Getsemani ŋgacrena taup ianna taŋga malaruat. Na Iesusa minmo gaindoprina, “Ne ganna mbiraca eacraŋ. Aku mbendeina mamoek.” ");
INSERT INTO gai_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ri, ma Pitaapa, Ionapa, Iemisap aŋgɨrca mina manap mataŋgat. Na mana iro inikca ma kakadmaiapa, iroar mananna tamtam tamŋica kuricarica. ");
INSERT INTO gai_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Na ma minmo gaindoprina, “Aukna iro inikca makuk ŋgoin, na aku menacna kirar mamoek. Na ne gan ndeacraŋ te, ŋginaŋa mo.” ");
INSERT INTO gai_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Na ma taŋga mandaca ma pitrik ŋgirikca ma mambendeiat. Na ma toŋgorinanna taupap te, an makuk ŋgoreacmo ma iukainande. ");
INSERT INTO gai_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Na ma gainda mbendeirina, “Abba, Ate, u reikca muruŋa mona mɨn. Na aku toŋgorinanna, u auk ndambuŋna an kabmo mo kecari. Na u aukna toŋtoŋa kai raŋgai teac. Wanaiŋ. U ndona toŋtoŋ niŋgikca raŋgairaŋ.” ");
INSERT INTO gai_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Karica ma ndona iŋa raŋgairena ramtaɨr mbonkac ndambuŋa taŋga watrinanna, mina ŋgori maeacri. Na ma Pitamo gainda digirina, “Saimon, u maŋgoreke? U ŋgaŋganŋgɨa kabena mɨnna wat eacna mɨnna wanaiŋ ki? ");
INSERT INTO gai_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ne ndoritake, wati mbendei eacraŋ. Moca totowaiara nenmo laruca ne anna moca irik nari. Na anna gidik, iroar inkara ma reikca mona toŋtoŋgarap, na tikca ma toŋtoŋgar kocor.” ");
INSERT INTO gai_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Karica ma mac nda taŋga ma outta morina mbembendeina kirar mac morina. ");
INSERT INTO gai_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Na ma min ndambuŋa mac nda kɨpca wattatnanna, mina ŋgori maeacri, na anna gaind, mina lamnikca numbacarica. Na an kɨdrɨkca ma minmo omboŋga ŋgeprinanna, mina mba lamŋiri, mina manmo titocna kamb ndopit. ");
INSERT INTO gai_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Karica kɨdrɨk mbonkac mbuŋa ma mac nda kɨpca, minmo gaindopatna, “Ne warac, ne wɨktɨkca maŋgoreke. Na anna ma mɨn. Mina Ramootna Nuocmo mandeaca tɨpemb ŋgorikta makukara morena ramtaɨrta para neaŋna ŋgaŋganŋgɨna mɨnna malaruca. ");
INSERT INTO gai_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ne wat! Aukmo mina para tɨkna ramootta makɨpca marambuŋairi, aintik ne ŋgepca aia taŋna.” ");
INSERT INTO gai_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Na Iesusa kam ndoprenan mbuŋa Iudasa ramtaɨrta tumbun aniacap kɨpca malarucat, na ma Iesus ndambuŋ mataŋgat. Na an ramootta ma Iesusna iŋa raŋgairena parniŋapa mbut mbuniŋna ramtaɨrta ramoot ian. Na an ramtaɨrta tumbun aniaca mina bugrimarapa ikir tɨpembap utiŋga kɨprina. Na an ramtaɨrmo, taup ndamtaɨr paŋaindapa, tɨpemb wandik tamŋirena ramtaɨrapa, ramtaɨr paŋaindap, minmo Iudasap mbagɨrica mina kɨpatna. ");
INSERT INTO gai_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Na an ramootta Iesusmo mina para tɨknanna, ma minmo ŋgagatrac ianna mona moca, mimo gaindopatna, “Aku an ramootmo pipopot te, ande an ramoot, ma Iesus. Te, ne manmo muoc utiŋa manmo matau ŋgoinna ŋginaŋa moi, aŋgɨ taŋ.” ");
INSERT INTO gai_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ainda moca Iudasa kɨpca ma tawi ŋgoinna Iesus ndambuŋa taŋga manmo gaindopatna, “Riripti.” Ri, ma manmo pipopotatke. ");
INSERT INTO gai_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Na an kɨprina ramtaɨra manmo muoca mautiŋgat. ");
INSERT INTO gai_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Na ramoot ianna Iesusna kɨtɨmma eacrenanna, ma ndona bugrimmo wɨŋga aŋgɨrca ma taup ndamoot paŋan aniacna mbaiŋna aiŋa morena ramootmo an mbuŋa wacrina, ri, an bugrimma mana koar ianmo kocnai waca katac keca mambutukat. ");
INSERT INTO gai_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ainda moca Iesusa minmo gaindopatna, “Ne aukmo runduŋapa macmakɨmna ramootna kirar toca, bugrimarapa ikir tɨpemb aŋgɨrca kɨpca aukmo an mbuŋa pi muoci leacna kɨpri ki, a? ");
INSERT INTO gai_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Na ra, ra katuca aku memetmbaca nenapmo Raraŋ Aetaniacna Kacna wuocna inikca eaca meikramtaɨrmo ririptia morenanna. Ne aukmo anna tɨkca utiŋna mɨn? Na ne kaica aukmo anna tɨkca utiŋ ŋgocor? Na anna mɨnɨŋa gaind, Raraŋ Aetaniacna timbigta kap ndeacrena kambca ma gidik ŋgoin ndarunandet.” ");
INSERT INTO gai_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ainda moatke, mana iŋa raŋgairena ramtaɨra muruŋcamiŋa manmo tɨkcarica kɨpcamacariat. ");
INSERT INTO gai_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Karica ramoot ŋgam ianna Iesusna iŋa raŋgaica kɨprinanna, ma ndona tikmo raraŋit gogok niŋgik mbuŋa leacrina. Na mina manmo muoc utiŋna moatke, ");
INSERT INTO gai_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ma kɨpcarica ndona raraŋit gogokmo tɨkcarica ma loorkamainda kɨpcamacariat. ");
INSERT INTO gai_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Karica an ramtaɨra Iesusmo utiŋrinanna, mina manmo taup ndamoot paŋan aniacna kac naaŋgɨa taŋrina. Ri, ramtaɨr anikapa, taup ndamtaɨr paŋaindapa, tɨpemb wandik tamŋirena ramtaɨrap mina muruŋcamiŋa anna punica eacrina. ");
INSERT INTO gai_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Na Pita ma Iesusna iŋa raŋgaica taŋrina, na ma tawancait motem ndeacrina. Ri, ma an taup ndamoot paŋan aniacna kacna wuoca mbukrina. Na ma taŋca anna ŋginaŋa morina ramtaɨrapmo taca mbiraca ndona tikmo taca mo owaia eacri. ");
INSERT INTO gai_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Na taup ndamtaɨr paŋaindapa ninikar waŋgora muruŋa ramtaɨr ndeidmo aca kɨpca Iesusa moatna tɨpemb kirarirta kambmo wiwitina. Na mina toŋgorinanna, mina ore watna, ma kaina makukca mo te, mina manmo mo menacna. Na mina makuk ianna mina mba orea watatke. ");
INSERT INTO gai_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Na ramtaɨr wɨtta manmo paparuarta nininiara morinanna, an nininiar toco kirar kabea wanaiŋ. ");
INSERT INTO gai_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Na ramtaɨr ndeida ŋgepca wɨtɨkca manmo gaindta paparuna kamb ndoprina, ");
INSERT INTO gai_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Aia waracrinanna, ma gaindoprina, ‘Aku an Raraŋ Aetaniacna Kaca meikramtaɨra par mbuŋa morinanna tapinandet. Na rai mbonkac mbuŋa aku kabenanna monandet, na aku par mbuŋa mba moitndai.’” ");
INSERT INTO gai_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Na an kamb toco, mina mboprinanna, anna kam wat, na ma kirar kabea wanaiŋ. ");
INSERT INTO gai_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ainda moca taup ndamoot paŋan aniaca ninikar waŋgorta outta ŋgepca wɨtɨkca, ma Iesusmo gainda digirina, “U aina kam ian rutina toawanaiŋna, wanaiŋ ki, a? Na an kambca mina unmo mboprenan anna titoc?” ");
INSERT INTO gai_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ainda moca Iesusa kam kocor ndeacri, na mana kam ianna mba rutiatke. Ri, an taup ndamoot paŋan aniaca manmo gaind mac digiatna, “U Raraŋ Aetaniac, Tamuŋ Ŋgoinna Nuoc, Raraŋ Aetaniaca babuca mbagɨrica kɨpca aimo mac nda aŋgɨna ramoot ki? Co wanaiŋ?” ");
INSERT INTO gai_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Na Iesusa gaindopatna, “Anna auk ŋgoin. Te, ne watnandet, Ramootna Nuoca ma Raraŋ Aetaniacna gargar aniacapna par umbaia mbiracnande. Na ma riac tamuŋna wawɨrpaikap kɨpnandet.” ");
INSERT INTO gai_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ainda moca an taup ndamoot paŋan aniaca, an kamna moca ma ŋgep ŋgoreac naŋgepca ndona tik ŋgapaocmo wɨŋ titaca ma gaindopatna, “Aia kai, kabena ramtaɨr mac aca gan ramootna tɨp kirar nake, kai ore teac. Wanaiŋ. ");
INSERT INTO gai_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Na ne waracrina, ma Raraŋ Aetaniacna taup aŋgɨna morena. Na ne tit ndamŋirena, aia manmo tida moit?” Na mina muruŋcamiŋa gaindoprina, “Ma makukap, aintik ma menacnandet.” ");
INSERT INTO gai_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ainda moca ramtaɨr ndeida manmo tabera iurina, na mina mana lamnɨacniŋmo raraŋit mbuŋa tamaia, na mina manmo piatna, na mina gaindopatna, “U ramma moca mbop, mandaia unmo piapekna.” Ri, piriŋga manmo utiŋga mana kapgɨn ŋgaprina. ");
INSERT INTO gai_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Na Pita ma an taup ndamoot paŋan aniacna kacmo raek pɨkɨnmbaina wuoc inikca eacri. Na taup ndamoot paŋan aniacna mbaiŋna aiŋa morena meac ianna kɨprina, ");
INSERT INTO gai_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","na ma watrinanna, Pita ndona tikca mo owaina tac roumb ndeacri. Na an meaca manmo matau ŋgoinna watikca ma Pitamo gaindopatna, “U toco an Nasaretna Iesusap eacatna.” ");
INSERT INTO gai_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Na Pita mana kammo wanaiŋa gaindopatna, “An kamma u mbopapeknanna, aku mba lamŋirenan.” Na ma laruca wuocna tɨŋmo rambuŋairi, kackur ianna maapat. ");
INSERT INTO gai_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Na an meaca Pitamo mac watca, ma anna wɨtɨkca eacrena ramtaɨrmo gaindopatna, “Gan ramootta ma mina tumbunna ian.” ");
INSERT INTO gai_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Na Pita gaind mac mbopatna, “Wanaiŋ.” Na eaca mandaca, anna wɨtɨkca eacrena ramtaɨra Pitamo gaind mac mbopatna, “Gidik ŋgoin, u mina tumbunna ian. Na u Galilina ramoot ian.” ");
INSERT INTO gai_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Aintik Pita ma gagraca gaindopatna, “Gidik tamuŋ ŋgoin, ne mboprena ramootmo aku mba lamŋirena. Na aku gidik ndop ŋgocor te, Raraŋ Aetaniaca aukmo mo ŋgocrainande.” ");
INSERT INTO gai_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Na ma mbopca maiatke, kackura anduna kɨdrɨk mbuniŋ maapat. Na Pita malamŋiat, an kamma Iesusa manmo mbopatnanmo, “An mɨnna kackura kɨdrɨk mbuniŋa ap ŋgocor ndeacraŋ te, u kɨdrɨk mbonkaca aindopnandet, u aukmo mba lamŋirena.” Ri, Pita ma nananae bagaraniac ŋgoin mamoat. ");
INSERT INTO gai_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ainda moca ŋaŋarmuŋ ŋgoinna, taup ndamtaɨr paŋaindapa, ramtaɨr paŋaindapa, tɨpemb wandik tamŋirena ramtaɨrapa, ninik waŋgorta ramtaɨra muruŋa mina punica, mina ndori mona reikta kamb mataua maleacat. Na iŋmbaia mina Iesusmo ŋgatɨk mbuŋa leaca mina manmo aŋgɨra taŋga Pailatna par matɨkat. ");
INSERT INTO gai_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Karica Pailatta Iesusmo gainda digiatna, “U Iudananta gagrirta ramoot paŋan ki?” Na Iesusa mana kammo gainda nda rutirina, “U ande mambopri.” ");
INSERT INTO gai_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Na taup ndamtaɨr paŋainda manmo paparuna kamb wɨt koind puŋga parurina, ");
INSERT INTO gai_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","na Pailatta manmo gaind mac digiatna, “U tida moca kam ianna ruti mbop ŋgocor? Na u waracrinanna, an kamb wɨtta mina unmo mbopapeknanna.” ");
INSERT INTO gai_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Na Iesusa kam ianna mba mac rutiri, na anna Pailatmo moca ma tamtam malamŋiat. ");
INSERT INTO gai_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Na memetmbaca iar kabe, kabea mina amtiamna ra aniaca Pailatta ma kac ŋgoreac ndeacrena ramtaɨrmo, ma ramoot kabemo wattacarica ma larurena. Na meikramtaɨra an kac ŋgoreac ndeacrena ramootna i ŋgaca mbop te, Pailatta an ramootmo wattacarica ma laruca min ndambuŋa taŋrena. ");
INSERT INTO gai_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Na an mɨnna Iudana ramtaɨr ndeida Romna paŋanna kaŋgauk ndeacrena meikramtaɨrap runduŋa moca ramtaɨr ndeidmo moa menacri, mina minmo kac ŋgoreaca tɨkrina. Na an ramtaɨrta tumbunna ramoot ianna, mana ia Barabas, ma toco an kac ŋgoreacna inik ndeacrina. ");
INSERT INTO gai_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ainda moca meikramtaɨra kɨpca Pailatta ŋgaua minmo, morina tɨpna kirarna moca mina manmo madigiat. ");
INSERT INTO gai_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ri, ma mina kambmo gainda rutirina, “Ne toŋgorinanna, aku nenmo Iudananta gagrirta ramoot paŋanmo nen ndambuŋa watcarica makɨpit ki?” ");
INSERT INTO gai_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Na Pailatta ma aindoprinanna, anna gaind, ma lamŋirinanna, taup ndamtaɨr paŋaind anikca Iesusmo nikinik iroar inkar ŋgorikcap tik, mina manmo man ndambuŋ naaŋgɨ kɨpca ma manmo ritri waparaca mona. ");
INSERT INTO gai_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ri, taup ndamtaɨr paŋaind anikca meikramtaɨrta iroar inkarmo mo ŋgepca, mina Pailatmo aca mbopca ma Iesusmo kai watcarica laru teac. Ma Barabasmo wattacarica ma laruca min ndambuŋa taŋri. ");
INSERT INTO gai_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Karica Pailatta minmo mac digiatna, “Na ne toŋgorinanna gan ramootta ne manmo Iudananta gagrirta ramoot paŋan ŋgacrenanmo, aku manmo tida moit?” ");
INSERT INTO gai_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Na mina gaind ŋgaca mbopatna, “Mamo ik naaŋgɨ kerac.” ");
INSERT INTO gai_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ri, Pailatta minmo digiatna, “Kaica? Ma kaia moa ŋgocrairina?” Na mina kocnaia aca mboracrina, “Manmo ik naaŋgɨ kerac.” ");
INSERT INTO gai_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ri, Pailatta meikramtaɨrmo mo toŋgona mori, ma Barabasmo wattacarica ma min ndambuŋa taŋrina. Na ma mbopca lapoca ruŋrena ramtaɨra Iesusmo pi ŋgoreac ŋgoinna pirinan. Na iŋmbaia ma Iesusmo lapoca ruŋrena ramtaɨrta para tɨk te, mina manmo ik naaŋgɨ keracnande. ");
INSERT INTO gai_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Na lapoca ruŋrena ramtaɨra Iesusmo Ierusalemna bubuocrena ramoot paŋanna kacna wuoc inik naaŋgɨa mbukri, mina an lapoca ruŋrena ramtaɨrmo muruŋa aca kɨprina. ");
INSERT INTO gai_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Na mina Iesusmo tik ŋgapaoc laup ian aocrina. Na mina lacarapna ŋgatɨk kunna kirarna ŋgatɨk aŋgɨca an mbuŋa gagrirta ramootna paŋanna tɨkrena reac ian mamoat. Na mina Iesusna paŋan matɨkat. ");
INSERT INTO gai_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ri, mina manmo gaindopatna, “Ra laŋ, Iudananta gagrirta ramoot paŋan!” ");
INSERT INTO gai_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Na mina ruktuk ian aŋgɨca mana paŋanna pirina. Na mina manmo taber iurina. Na mina ndorita tutpemb rɨmbɨtca manmo an tɨpemb kirarira moca manmo i aniac neaŋna morina. ");
INSERT INTO gai_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Karica mina manmo ainda moa maiatke, mina an tik ŋgapaoc laupa mana tikca tɨkatnan mac nda riaŋga aŋgɨratke, mana tik ŋgapaoc ŋgoinna mac maaocat. Ri, mina mamo ik nakeracna moca aŋgɨra mataŋgat. ");
INSERT INTO gai_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Na Sairini auŋna Saimon, ma kɨpca an auŋ aniaca mbukna moatke. Na Saimon tikca ma Rupusapa Aleksanderna aet. Ri, an lapoca ruŋrena ramtaɨra man aŋgɨrca manmo moca ma Iesusna ik nakeracna ikmo aŋgɨrca mambukat. ");
INSERT INTO gai_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Na mina Iesusmo taup ian naaŋgɨra taŋrina, mana ia Golgota. Na an taupna ina mɨnɨŋa gaind, Paŋan Tiaŋgapna Gagarna taup. ");
INSERT INTO gai_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Na mina Iesusmo wain pukca mina meikramtaɨr rorairena reacap kurinan neaŋri, na ma mba ambatke. ");
INSERT INTO gai_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ainda moca lapoca ruŋrena ramtaɨra Iesusmo aŋgɨra ik makeracat. Na mina ndori puŋga mana tik ŋgapaocapa reikmo mabiŋaiat. Na mina matɨp rocotna kirarna gegerei nagereica watnande, mandaia ndo mana titocna reaca aŋgɨrit. ");
INSERT INTO gai_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Na ŋaŋarmuŋna rana ŋgaŋganŋgɨca par kabeapa mbutremb paur mbuŋa mina Iesusmo ik naaŋgɨ makeracat. ");
INSERT INTO gai_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Na an kapwaŋmo mina mana ritrica orea waracrina kamma an nambatta mina gan kam tɨp tirca eacrenan, “Iudananta Gagrirta Ramoot Paŋan.” ");
INSERT INTO gai_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Na mina manapmo macmakɨmna ramootniŋapmo ik nakeracrina. Ianna mana par umbai, na ianna mana par aeŋmbai. ");
INSERT INTO gai_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Na meikramtaɨra taŋ kɨp tɨkrinanna, mina manmo peperena kamb ŋgorik mambopri. Na mina ndorita paŋaind korereca aindopatna, “Aria, u Raraŋ Aetaniacna Kacmo tapica, rai mbonkacna inik mbuŋa u mac monande. ");
INSERT INTO gai_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Na mandeaca u ndomo otaca, an ik nakeracmo tɨkcarica irik.” ");
INSERT INTO gai_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Na taup ndamtaɨr paŋaindapa, tɨpemb wandik tamŋirena ramtaɨr toco, manmo pepereca mboprina. Na mina ndorita rɨkmo gaindopatna, “Ma kabena meikramtaɨrmo otacrena, na ma ndo ŋgoin ŋgotacna mɨnna wanaiŋ. ");
INSERT INTO gai_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Na an ramoot ma Raraŋ Aetaniaca babuca mbagɨrica kɨpca aimo mac nda aŋgɨna ramoot, na ma Israelna gagrirta ramoot paŋan, ma an ik nakeraca eacrenanmo tɨkcarica irikca aia wat te, aia rɨpacnande.” Na an ramootniŋa mina Iesusna roumbna ik nakeracrinanna, maniŋ toco manmo pepereca mboprina. ");
INSERT INTO gai_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Karica rana ŋgaŋganŋgɨa gaca rɨmbɨŋa rɨŋri, gan tiacarpaikca muruŋa neaupdiriŋ aniaca wɨŋga makɨtacat, eaca taŋga wigwacmbaina rana ŋgaŋganŋgɨa mbonkacna mɨn matɨkat. ");
INSERT INTO gai_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Na rana ŋgaŋganŋgɨa mbonkacna mɨnna tɨkatke, Iesusa kam aniac ŋgoin mbuŋ gaind ŋgaca mbopatna, “Eloi, Eloi, lama sabaktani?” Na an kamna mɨnɨŋa gaind, “Aukna Raraŋ Aetaniac, aukna Raraŋ Aetaniac, kaina moca u aukmo tɨkcaririna.” ");
INSERT INTO gai_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ri, ramtaɨr ndeida rambuŋ ndeacrenanna, mina an kamma waraca mina gaindopatna, “Ne warac. Ma Elaiana ŋgacrena.” ");
INSERT INTO gai_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Na ramoot ianna ootta taŋga puk wɨŋrena reaca mina spans ŋgacrena reacmo aŋgɨrca mambarina wain puk inikca tɨkca, an mambarina wain pukca anna mbukca mɨnna tɨkri, ma aŋgɨrca ik tɨp ianna leaca manmo neaŋamna mori. Na an ramootta gaindopatna, “Pac lambica, aia watna, moca Elaia kɨpca manmo aŋgɨr irikit, co wanaiŋ?” ");
INSERT INTO gai_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Na Iesusa kam aniac ŋgoin keca, na ma mamenacat. ");
INSERT INTO gai_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Na an raraŋit aniaca Raraŋ Aetaniacna Kacna tɨŋ inikca wawaraca eacrenanna, ma tamuŋa tɨkca titaca irikca pɨkɨn matɨkat. Na waŋ mbuniŋ malaruat. ");
INSERT INTO gai_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Na lapoca ruŋrena ramoot paŋanna Iesusna kɨtɨmma wɨtɨkca eacrinanna, ma Iesusa menacrina tɨp kirara watca, ma gaindoprina, “Gidik ŋgoin, an ramootta ma Raraŋ Aetaniacna Nuoc.” ");
INSERT INTO gai_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Na meik ndeid toco tawancait motemma wɨtɨkca watrenanna, mina rɨkna ianna Makdala auŋna Maria. Na ianna Salome. Na ianna Maria, ma Iemis tekerapa Iosepna aem. ");
INSERT INTO gai_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Na an mɨnna Iesusa Galili ndeacri, an meikpitikca manmo raŋgaica manmo otacrina. Na meik wɨt toco an ndeacri, mina Iesusapmo Ierusalem auŋ aniaca taŋrina. ");
INSERT INTO gai_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Karica an rana wigwac mbuŋa Arimatia auŋna Iosepa, makɨpat. Na ma mina ninik waŋna tumbunna ramoot ian, na meikramtaɨrta lamnɨac ŋgoutta ma i laŋap eacrena ramoot. Na ma toco Raraŋ Aetaniacna bubuoca watna lambirena. Na ŋorapmbaia anna Wɨktɨtɨkna Ra, aintik mandeaca anna amna reikapa reikmo kocrona ra. Ainda moca Iosepa mba nanambiatke, ma taŋga Pailatna outta wɨtɨkca, ma manmo digica Iesusna waɨrmo, watcarica ma aŋgɨna. ");
INSERT INTO gai_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Na Pailatta tamtam ndamŋica ma gaindopatna, “Ma menacri ki?” Na ma lapoca ruŋrena ramtaɨrta ramoot paŋan aniacmo, aca kɨpca manmo madigiat, “Iesusa menacri ki, wanaiŋ?” ");
INSERT INTO gai_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Na ma mana kambmo waraca maiatke, ma Iosepmo mbopca, ma Iesusna waɨr aŋgɨna mɨn. ");
INSERT INTO gai_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ainda moca Iosepa taŋga raraŋit gogok ian ŋgoikca, ma Iesusna waɨrmo aŋgɨra mairikat. Na ma an mbuŋ matamairi, na ma an waɨrmo aŋgɨ taŋga wautna mukca ramtaɨra morina muk inikca tɨkrina. Na Iosepa an mukna tɨŋmo waut aniac ian rukica taŋga mboracrina. ");
INSERT INTO gai_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Na Makdala auŋna Mariaapa, Maria Iosepna aemma eacri, maniŋa Iesusna waɨr tɨkrina taupca watrina. ");
INSERT INTO gai_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Karica Wɨktɨtɨkna Ra maiatke, Makdala auŋna Mariaapa, Salomeapa, Maria Iemisna aemmap, mina tabrirapa iŋpemb laiŋta reikap oikca aŋgɨrca kɨprina, na mina Iesusna waɨrmo matauna taŋna moca. ");
INSERT INTO gai_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Na raita ŋgatna ra lacauna ŋaŋarmuŋ ŋgoinna mina muk mataŋgat. ");
INSERT INTO gai_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Na mina ndorita rɨkmo gaindopatna, “Mandaia ndo aimo otaca taŋca tɨŋ mboraca eacrena waut aniacmo rukica tɨŋa gotit?” ");
INSERT INTO gai_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Na an kɨdrɨkca mina kɨpca rambuŋairi, na mina watta taŋrinanna, an taŋga mboracrina wautta tɨŋmo mba mac aŋgɨa mboracri. Wanaiŋ. Mina rukica taŋga roumbca tɨkca eacrina. Na an wautta bagaraniac ŋgoin. ");
INSERT INTO gai_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ainda moca mina an muk inik mambukat, na mina watrinanna, ramoot ŋgam ianna par umbaia mbiraca eacrina, na ma tik ŋgapaoc gogok rocot aoca eacrena. Na mina mana watca ŋgep ŋgoreac naŋgeprina. ");
INSERT INTO gai_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Na ma minmo gaindopatna, “Ne kai nanambi teac. Aku lamŋirena, ne Nasaret auŋna Iesusa mina ik nakeracrinanna, orena kɨprina. Na ma mac nda ŋgeprina. Na ma ganna mba eacreke. An taupca mina manmo anna tɨkrinanmo ne wat. ");
INSERT INTO gai_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Na ne taŋca mana iŋa raŋgairena ramtaɨrapa Pita motoca kam neaŋ, Iesusa nenmo Galili auŋmo, outta taŋnande. Na ne manmo Galili auŋa tɨkca watnande, an kirara ma nenmo ŋgaua mbopatna.” ");
INSERT INTO gai_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ainda moca an meikpitikca nda laruca, mina mukmo tɨkcarica kɨpcarica mataŋgat. Na mina iroar inkara ŋgep ŋgoreac naŋgepri, mina manekri. Na mina ramoot ianmo kam ianna mba mbopatke, mina nanambicariatna. ");
INSERT INTO gai_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Na Iesusa rana ŋgat kabena ra lacauna ŋaŋarmuŋ ŋgoinna ma mac nda ŋgeprina. Na ma Makdala auŋna Mariamo out ndarurina. Na an meac tikca ŋgaua Iesusa manmo par kabeapa mbut mbuniŋna ŋerŋgaur ŋgorikcapnanna moa kecaririna. ");
INSERT INTO gai_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ri, Maria ma taŋga Iesusap ŋgaua taŋrena ramtaɨrmo mambopat. Na an ramtaɨra iroar inkar makukuca eacrenanna mina aerena. ");
INSERT INTO gai_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Na ma minmo gaindopatna, “Iesusa ma eteacna watap, na ma eacrena. Na aku manmo watrina.” Na mina an kambmo waraca mina mba rɨpacatke. ");
INSERT INTO gai_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Karica iŋmbaia mana iŋa raŋgairena ramootniŋa, an auŋ aniacmo tɨkcarica taup ndiŋa taŋri. Na Iesusa maniŋ ndambuŋ ndarurinanna, ma kabena ramootna tikna kirar toc ndarurina. ");
INSERT INTO gai_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Na maniŋa taŋga mana iŋa raŋgairena ramtaɨrmo an kam ndoprina, na mina maniŋmo mba rɨpacatke. ");
INSERT INTO gai_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ainda moca iŋmbaia mana iŋa raŋgairena ramtaɨr parniŋapa mbut kabena mɨnna ramtaɨra, mbiraca ambca eacri mbuŋa Iesusa min ndambuŋ malaruat. Na ma minmo kaega moatnanna, anna gaind, mina iroar inkara gagrar koind, aintik ma mac nda ŋgepatnanna, mina rɨtɨpaik kocor. Na meikramtaɨra manmo watca anna kam ndoprinanmo, mina minmo mba rɨpacatke. ");
INSERT INTO gai_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Karica ma minmo gaindopatna, “Ne gan tiacarpaikmo muruŋa taŋca meikramtaɨrmo muruŋcamiŋmo kam wembaŋ laŋmo wiwiti taŋ. ");
INSERT INTO gai_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Na ramootta rɨpaca kɨtac puk aŋgɨr te, Raraŋ Aetaniaca manmo mac nda aŋgɨnandet. Na ramootta rɨpac ŋgocor te, ma ritri waparacna ramo ma laruca wɨtɨknandet. Na an mɨnna Raraŋ Aetaniaca manmo mba aŋgɨritndait. ");
INSERT INTO gai_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Na Raraŋ Aetaniaca rɨpacrena meikramtaɨrta paɨr puŋga, ma ŋgagatraca monandet. Na mina aukna i mbuŋa mina ŋerŋgaur ŋgorikmo mo kecarinandet, na mina kabena auŋna kam mbuŋ toco mbopnandet. ");
INSERT INTO gai_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Na mina nduipmo ndorita paɨr puŋga utiŋnandet. Na mina titocna pukna kocna reikca meikramtaɨra moa menacrenanna, am te, an koca minmo mba mo ŋgocraiitndai. Na roumbbebta meikramtaɨrmo mina ndorita paɨr tɨk te, mina laiŋga monandet.” ");
INSERT INTO gai_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Karica Kacoot Iesusa minmo kamb topca maiatke, Raraŋ Aetaniaca manmo tamuŋna auŋ naaŋgɨra mataŋgat. Na Iesusa taŋga mana par umbaia mambiracat. ");
INSERT INTO gai_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ainda moatke, mana iŋa raŋgairena ramtaɨra mataŋgat, na mina kam wembaŋ laŋmo auŋembmo muruŋ mawiwitiri. Na Kacootta minap aiŋa mori, na ma minmo moa gagraca mina ŋgagatracara morina, na mina kambmo moa gagrarina.");
INSERT INTO gai_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ramoot paŋan Tiopilus, ŋgaua Raraŋ Aetaniaca aina kɨdrɨkca tɨkca moatna aiŋa, ramtaɨr wɨtta mina anna watca ŋgepca ndorita paɨr puŋga towaia tiratna. ");
INSERT INTO gai_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ainda moca mina an ŋgaua mandeb ŋgepatna reikta kambca, an meikramtaɨra ndorita lamnik puŋga watatnan ndiŋa raŋgaica tiratna. An meikramtaɨr, mina Raraŋ Aetaniacna aiŋna meikramtaɨra moca mori, mina aimo an kam wembaŋ laŋ wiwitiri, na mina aimo an kam wembaŋ laŋa anna niniatna. ");
INSERT INTO gai_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Aintik auk toco, aku ndomo gan reikta nininiara ŋgaua mandeba ŋgepatnanmo, timbigta kapca tɨk ndopca, aku an reikta kambta mɨniŋta moca, memetmbac ŋgoinna digia orea taŋ, taŋga, anna mɨniŋta garacatna mbatca. Mandeaca aku umo wandoŋ ŋgoinna an reik laruatna kirar ŋgoinna timbigta kap matɨkri. ");
INSERT INTO gai_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","An reikta nininia, u wat te, u an reikmo lamŋina, mina umo ŋgaua riptiatna nininina kirar, an nininiar anna gidik ŋgoin. ");
INSERT INTO gai_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","An mɨnna Erot, ma Iudiana gagrirta ramoot paŋan ndeacri, na taup ndamoot ian, mana ia Sekaraia. Ma Abaiananta barna ramoot. Na mana meaca ma Aronna barnan, mana ia Elisabet. ");
INSERT INTO gai_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ri, maniŋa matau ŋgoinna Raraŋ Aetaniacna toŋgorina kirarirta iro ŋgoinna gainda raŋgairina. Na Kacootna kamma mataua waraca, mana tɨpemb koinda mataua raŋgairina. ");
INSERT INTO gai_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Na maniŋa mombonik kocor, Elisabetta kopica, maniŋa aind ndeaca bagaraica mombonik kocor. ");
INSERT INTO gai_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Karica oit ianna Sekaraiana barnanda, mina taŋga taup ndamtaɨrta aiŋa mori. Na Sekaraia toco, ma taŋga Raraŋ Aetaniacna Kaca mbukca ndona memetmbaca morina kirar mamori. ");
INSERT INTO gai_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Na taup ndamtaɨrta tɨpemb kirarira gaind, mina matɨp rocot ŋgacrina gegerei nagereica watna moca, mandaia ndo Raraŋ Aetaniacna Kacna inikca mbukca gɨmbamba moca rotacekna tacna tuorna iŋpai laŋ ŋgoin gana. Ainda moca mina moca wattatnanna, Sekaraia ndo anna mbuknande. ");
INSERT INTO gai_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ri, an mɨn mbuŋa, ma gɨmbamba mona moca Raraŋ Aetaniacna Kacna inikca mbukca an iŋpai laŋna tactuora moatke. Meikramtaɨr wɨt aniaca kɨpca an Raraŋ Aetaniacna Kacmo kocnaia paria aŋgɨca, Raraŋ Aetaniaca mbendeiri, eacri. ");
INSERT INTO gai_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Na Kacootna mbaiŋna aiŋa morena ŋeroŋ ianna kɨpca laruca, Sekaraiana an gɨmbamba moca iŋpai laŋ larurena taupmo, gagar umbaina waŋga wɨtɨkca eacri. ");
INSERT INTO gai_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ainda moca Sekaraia an mbaiŋna aiŋa morena ŋeroŋa watca dumrikica ma mananambiat. ");
INSERT INTO gai_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Na mbaiŋna aiŋa morena ŋeroŋa mamo aindopatna, “Sekaraia, u rugutta kai mo teac. Raraŋ Aetaniaca una mbendeirina kamma, ma mawaracri. Una meac Elisabet, ma nuocna mooŋnuoc ianna mɨrnande. Mana imo Ion tɨk. ");
INSERT INTO gai_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Na una meaca mana mɨr te, una iro u mba ŋateitndai, u manmo toŋgo te, meikramtaɨr wɨt aniac toco manmo toŋgonande. ");
INSERT INTO gai_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Aintik ma Kacootna lamnɨac ŋgoutmo mana ia aniac ndarunande. Ainda moca ma mba wainapa puk gargarmo, ma mba amitndai. Na Ion, ma aemna nikinik ndeacraŋ te, Ŋeroŋ Ratta mana iro inikmo mbuki mɨnna tɨknande. ");
INSERT INTO gai_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Na ma Israelna meikramtaɨr wɨtmo, moi iroar inkar uriraca, mina ndorita Kacoot Raraŋ Aetaniac, ndambuŋa mac nda kɨpnande. ");
INSERT INTO gai_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Te, ma Elaiana ŋeroŋna kirarirta gargar toc ndaruca, ma Kacootmo outmbaica taŋca aeterapa mombonikmo, aŋgɨri iro kabea tɨk te. Ma an kam mbarac ŋgocorta meikramtaɨrta iroarmo, moi iro laŋ kabe ndaruca, mina an meikramtaɨr wandoikta iroarta kirarir toc ndaruca minmo aŋgɨri kocroca mina Kacootna kɨkɨpna ndabina moca.” ");
INSERT INTO gai_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Karica Sekaraia an mbaiŋna aiŋa morena ŋeroŋmo aindopatna, “Titoca mo te, aku una an kammo rɨpacit? U wat, aku bagar ŋgoin, na aukna meac toco bagar.” ");
INSERT INTO gai_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ri, an mbaiŋna aiŋa morena ŋeroŋa gaind mambopat, “Aku Gabriel, aku Raraŋ Aetaniacna lamnɨac ŋgoutca wɨtɨkca eacrena ramoot, ma ndo aukmo mbagɨrica, aku umo an kam wembaŋ laŋ aŋgɨra kɨprina. ");
INSERT INTO gai_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","U warac, kaica u gan kam wembaŋ laŋmo, aku aŋgɨa kɨprinanmo, u rɨpac ŋgocor, aintik mandeaca una upa mɨkca u kam ndopna mɨnna wanaiŋ, u aind ndeaci, taŋi an ra aku baburina reikca min laruna ra, Raraŋ Aetaniac ma malamŋireke. An ra ŋgoinna tɨk te, an reikca mina larunande.” ");
INSERT INTO gai_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ri, an kɨdrɨkca meikramtaɨra mana moca raekmbai ndabiri, mina aindoprina, “Titoca moca Sekaraia Raraŋ Aetaniacna Kacna inikca mbukapeknanna, eaca rocot ŋgoin.” ");
INSERT INTO gai_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Karica ma nda laruatnanna, kam ndopna mɨnna wanaiŋ, ma aintan ndeacri, minmo par mbuŋa ŋgagoatke. Mina malamŋiat, ma Raraŋ Aetaniacna Kacna inikca tɨkca manmbɨanmemraŋna tamram ian mawattat. Ainda moca ma aintan ndeacri, mimo ma reikta ŋgagatracmo par niŋgik mbuŋ maŋgagori. ");
INSERT INTO gai_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Karica ma ndona taup ndamootna aiŋa moa maiatke, ma ŋgepca ndona auŋ mac nda mataŋgat. ");
INSERT INTO gai_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Iŋmbaia an kɨdrɨkar maiatke, mana meac Elisabetta nik tɨkca kac inik nakauka eaca karwira parmbai mamoat. ");
INSERT INTO gai_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ri, Elisabetta, aindopatna, “Kacootta ma aukna nakadmaica mandeaca ma aukmo an reaca ainda moapeke. Meikramtaɨrta lamnik puŋga ma aukna numbirmo moa kecamacarica.” ");
INSERT INTO gai_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Karica an karwira parmbaiapa mbut kabena mɨnna, Elisabetta niktan ndeacri, Raraŋ Aetaniaca ndona mbaiŋna aiŋa morena ŋeroŋ, Gabriel mbagɨrica ma Galilina inikna auŋ teker ian mataŋgat. An auŋna ia Nasaret. ");
INSERT INTO gai_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ma an auŋna mooŋ ŋgam ian ndambuŋa taŋgatna, an mooŋa mina manmo nuoc ŋgam ian laŋgona babuca eacrina, an nuoc ŋgamma, gagrirta ramoot paŋan Dewitna racaindpaikna ramoot, mana ia Iosep. Na an mooŋ ŋgamna ia Maria. ");
INSERT INTO gai_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ainda moca an mbaiŋna aiŋa morena ŋeroŋ Gabriel, ma taŋga an meac ndambuŋ ndaruca manmo aindopatna, “Ra laŋ, Maria. U iro inik wetwet laŋ ndeac, Kacootta unap eac te, unmo otaca u toŋtoŋ bagaraniacap eacraŋnande.” ");
INSERT INTO gai_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Aindopatke, Maria an kam mbaraca, tamtam ndamŋica gaindopatna, “Anna titna kambca aintan, aku anna mɨnɨŋa mba lamŋiapeke?” ");
INSERT INTO gai_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ri, an mbaiŋna aiŋa morena ŋeroŋa Mariamo gaindopatna, “U kai nanambi teac, Raraŋ Aetaniaca una toŋtoŋ aniacap tik, ma unmo otacnande. ");
INSERT INTO gai_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Aintik u nik tɨkca nuocna mooŋnuoc ianna mɨrnande, an nuoc, u mɨr te, mamo i Iesus tɨk. ");
INSERT INTO gai_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Te, ma irembta ramoot aniac ian ndaru te, mina mamo Tamuŋna Raraŋ Aetaniacna Nuoc ŋgacnande. Te, Kacoot Raraŋ Aetaniaca mamo moi gagrirta ramoot paŋan ndaruca ma ndona ŋgamaɨr Dewitna kirar toc ndarunande. ");
INSERT INTO gai_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Te, ma Iakopna rɨmbnarapa ŋgamrirta gagrirta ramoot paŋan ndeac te, min aŋgɨri bubuoc te, mina mana kaŋgaukca iarwar ndeacraŋnande. Na mana an gagrirta i mananna mba mac maiitndai.” ");
INSERT INTO gai_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Aindopri Maria manmo gaindopatna, “Aku ramootap ŋgogoa lamŋi ŋgocor an kirara titoc ndaruit.” ");
INSERT INTO gai_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ri, an mbaiŋna aiŋa morena ŋeroŋa Mariamo aindopatna, “Ŋeroŋ Ratta kɨpca unap eac te, Raraŋ Aetaniacna tamuŋna gargara umo wɨŋi kɨtac te, iŋmbaia u mooŋnuoca mɨrnande. Na an mooŋnuoca ma Raraŋ Aetaniacna lamnɨac ŋgoutmo ramoot wandoŋ laŋ ndeac te, mina mamo Raraŋ Aetaniacna Nuoc ndopnande. ");
INSERT INTO gai_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","“Aintik u warac. Una ocou ŋgaem Elisabet, ma kopica mombonikca mba mɨrenanna, ma aind ndeaca taŋga meac bagar ŋgoin, ma mooŋnuoca mɨrna towanaiŋ. Na mandeaca ma nik tɨkca anap eaca kɨpca karwira parmbaiapa mbut kabe malaruri. ");
INSERT INTO gai_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Na reac ianna, Raraŋ Aetaniacmo anna mona ndopna towanaiŋ, reikca ma ndo kabea morena.” ");
INSERT INTO gai_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ri, Maria aindopatna, “Laŋ, u warac, aku Kacootna mbaiŋna aiŋa morena meac. Na an reik, u auk ndopapekna kirara, ma ainda mo te, aku toŋgonande.” Ri, an mbaiŋna aiŋa morena ŋeroŋa man tɨkcarica mataŋgat. ");
INSERT INTO gai_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","An mɨn mbuŋa Maria, anduna ŋgepca Iudiana taukruirta inik ndeacrina auŋ ian mataŋgat. ");
INSERT INTO gai_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ma taŋga Sekaraiana kacnɨm ndaruca, kac inikca mbukca Elisabetmo watca ra laŋ maneaŋgat. ");
INSERT INTO gai_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ri, Elisabetta, Mariana kam laŋ mbaracatke, mana mooŋnuoca nikinik ndeacrinan toco madumrikiat, ri, Ŋeroŋ Ratta Elisabetmo mbukca mɨn matɨkat. ");
INSERT INTO gai_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ainda moca Elisabetta kam aniac mbuŋa gaindopatna, “Raraŋ Aetaniaca unapa una mooŋnuocmo toŋgoca opotac aniac neaŋgapekna, ŋgaua ma meik ndeidmo ainda otac ŋgocor.” ");
INSERT INTO gai_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ri, Elisabetta aind mac mambopat, “Kaina moca gan reac bagaraniaca aukmo gaind ndaruapekna, aukna Kacootna aemma aukca watna nakɨprina? ");
INSERT INTO gai_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Aukna koarniŋ waracapeke, mandebanna u aukmo ra laŋ neaŋgapeke, aukna nikinikna mooŋnuoc toco, toŋtoŋ ŋgoinna moca madumrikica. ");
INSERT INTO gai_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","U warac, u Kacootna kamma rɨpacat tik, ma unmo, mo ndoprina reik, ma ainda mo te, u toŋgonande.” ");
INSERT INTO gai_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Karica Maria aindopatna, “Aukna iro inikca Kacootna imo tamuŋ ŋgoin naaŋgɨra maŋgepreke. ");
INSERT INTO gai_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Na aukna ŋeroŋa Raraŋ Aetaniacmo toŋtoŋ bagaraniac ŋgoin, ma auk ŋgopotacna ramoot, aintik ma aukmo otacapekna. ");
INSERT INTO gai_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Aku Raraŋ Aetaniacna mbaiŋna aiŋa morena meac, ainda moca aku ndomo mindacniŋa moatke, ma auk mbatca, ma aukna moca kadmairina. Ainda moca mandeacna mɨnapa iŋmbaina mɨnna, meikramtaɨr wɨt aniaca watca aindopnande, ‘Raraŋ Aetaniaca aukmo toŋtoŋ bagaraniac ŋgoin.’ ");
INSERT INTO gai_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Ainda moca Raraŋ Aetaniac, ma gargar bagaraniacap, ma an reikca moatnanna, anna ma auk ŋgotacna moca moatna reik, ainda moca mana ia rat ŋgoin. ");
INSERT INTO gai_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Na meikramtaɨra mana kaŋgauk ndeacrenan. Ma minmo kakadmaina opotaca morena, ainda moca ma mandeacna meikramtaɨrapa iŋmbai ndaruekna meikramtaɨr motocmo, ma ainta kakadmaina opotaca monande. ");
INSERT INTO gai_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Raraŋ Aetaniacna par mananna gargar, ma an ramtaɨra ndorimo gaind ndamŋirena, ‘Aia irembtan, aia outmbai ndeacraŋnande.’ Aind ndamŋirena ramtaɨrmo, ma oot mandaca mina tamtamma taŋ mainande. ");
INSERT INTO gai_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Na ma an irembta gagrirta ramtaɨr paŋaindta gagrar anikca kɨtaci irik te, an iremb kocorta ramtaɨrta iremb aŋgɨra maŋgepri. ");
INSERT INTO gai_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Na ma an amta reik kocorta meikramtaɨrmo, reik wɨt aniac neaŋga mina amba gautpemb putuatke, laimnembta meikramtaɨrmo, ma minmo kamainda mandaca mina mataŋgat. ");
INSERT INTO gai_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Na ma ndona aiŋna meikramtaɨr Israelnandmo, ma minmo otacrenan, na mana an meikramtaɨrmo ma minmo iarwarna kakadmaina opotaca morena. Na gan bababua ma morinanna ma lamŋia mataŋreke, ma aina nicar ŋgamrir, Abraamapa mana racaindpaiknandmo ma iarwara mina kadmairaŋnande.” ");
INSERT INTO gai_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ri, Maria, ma Elisabetapmo eaca taŋga karwira mbonkac maiatke, ma ndona auŋ mac nda mataŋgat. ");
INSERT INTO gai_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Maica Elisabetna mooŋnuoca mɨrna ra laruatke, ma nuocna mooŋnuoc mamɨrat. ");
INSERT INTO gai_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ri, Kacootta Elisabetmo kakadmaina opotaca ainda moatke, mana laiplacarapa mana auŋ kabena meikramtaɨra, an mbaraca mina manap tɨkca toŋtoŋgar anikap eacrina. ");
INSERT INTO gai_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Karica an mooŋnuoca eaca taŋga raia parmbaiapa mbutremb mbonkaca tɨkatke. Mina mac nda kɨpca mana tikiŋit katac te, mana imo mana aetna i Sekaraia tɨkna moca mori. ");
INSERT INTO gai_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Na mooŋnuocna aemma gaindopatna, “Wanaiŋ. Aia mana imo Ion tɨknande.” ");
INSERT INTO gai_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ri, mina mamo aindopatna, “An ia una nicar ŋgamrirta barna ia wanaiŋ.” ");
INSERT INTO gai_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ainda moca mina an nuocna aetmo par mbuŋ naaŋgɨa ŋgagoca aind madigiat, “U mooŋnuocna imo mandai tɨkit?” ");
INSERT INTO gai_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ri, Sekaraia minmo i tirna kapwaŋ ianna digica mina mamo waŋ ian neaŋga, ma tiratna kamma, ma gaindoprina, “Mooŋnuocna ia Ion.” Aindopri mina ŋgep ŋgoreac naŋgepca tamtam malamŋiat. ");
INSERT INTO gai_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ri, an kɨdrɨk ŋgoinna Sekaraiana upa mba mac mɨkatke, ma anduna ŋgepca kamb ndopatke, Raraŋ Aetaniacna i aŋgɨra maŋgepat. ");
INSERT INTO gai_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ri, mana kamkabeara an reac dam ŋgoin laruapeknanna watca, kocnaia rugdar moamacariri. Na an laruatna reikta kam wembaŋa Iudiana taukruirta auŋembta inkara kocnaia taŋga mamaiat. ");
INSERT INTO gai_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ri, an kam wembaŋa waracatna meikramtaɨra muruŋa ndori puŋga gaind malamŋiat, Kacootna gargara manap eacnandet. Ri, mina ndorimo madigiat, “Iŋmbaia an mooŋnuoc, ma titoc naŋgepca titoc ndeacit?” ");
INSERT INTO gai_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Karica an nuocna aet Sekaraia, Ŋeroŋ Ratta manmo mbukca aoca ŋgepca, ma rambca moca aindopatna, ");
INSERT INTO gai_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Aia Raraŋ Aetaniacmo kam laŋ neaŋ te, mana imo aŋgɨ ŋgep, ma Israelnaŋgepta Raraŋ Aetaniac Kacoot, ma minmo okeca, oikca minmo mac nda aŋgɨratna. ");
INSERT INTO gai_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Na an ramootta ma Raraŋ Aetaniacna aiŋa morina ramoot Dewitna racaindpaik ŋgoin, ma ramoot gargar aniac ian ndarunande, Raraŋ Aetaniaca mamo raupŋia kɨpca larurina, ma ai mac nda aŋgɨna ramoot. ");
INSERT INTO gai_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ainda moca Raraŋ Aetaniacna kambca atuna Raraŋ Aetaniacna rambca morina ramtaɨrta up mbuŋ ndoprina kambca. ");
INSERT INTO gai_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Gaind, ma aimo aina puŋnaŋgepta para tɨkca aimo mac nda aŋgɨ te, aimo nikembkatrena ramtaɨrta kɨdrɨkca tɨkca aimo mac nda aŋgɨnande. ");
INSERT INTO gai_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Na ma aina ŋgamrirmo kakadmaina opotaca moatna. Na ma ŋgaua Raraŋ Aetaniacna kam leaca gagraca, babuatna kamma ma mba ndarekrekeri. ");
INSERT INTO gai_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ma atua aimo otac ndopca, aina ŋgamaɨr Abraammap babuca leacatna kamma, ma mandeaca aimo ainda raŋgaica moatna. ");
INSERT INTO gai_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Ainda moca ma aimo otaca aimo aina puŋnaŋgepta para tɨki aimo nda aŋgɨna moca. Aintik aia ndorita nanambiarmo kecarica, aia man niŋgikna aiŋa moraŋ. ");
INSERT INTO gai_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Aintik mandeaca aia eacrenanna, aia mana lamnɨac ŋgoutmo tɨpemb kirarir wandoik laiŋga memetmbaca moraŋ te, mana tɨpemb kirarir ratta aina iroar inkara matau ŋgoin ndamŋi rapacraŋnande. ");
INSERT INTO gai_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Na u nuoc mbitac tikca, iŋmbaia mina unmo Tamuŋna Raraŋ Aetaniacna rambca morena ramoot aniac ian ŋgacnande. Te, u outmbaica taŋca Kacootna taupembta ŋgogoba monande. ");
INSERT INTO gai_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","78","Te, u mana meikramtaɨrmo mbop warac, na mina Raraŋ Aetaniacna kakadmaina opotac bagaraniac ŋgoinna lamŋinandet. Ainda moca ma aimo tamuŋna auŋna memetacmo, ai nambatta metac te, ma mana meikramtaɨrta tɨpemb ŋgorikta makukarmo, mo kecarica ma mimo mac nda aŋgɨnande. ");
INSERT INTO gai_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ainda moca ma an memetacmo meikramtaɨra neaupdiriŋ ŋgoin ndeacreke, memenacmo timma rapaca eacrenanmo, min nambatta metac te, ma aina our aŋgɨri wandoŋai te, aina iroar inkar wandoŋaica, aia nikinik iro wetwet laŋap taŋraŋnande.” ");
INSERT INTO gai_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ainda moca an nuoc mbitaca, iŋmbaia ma ŋgepca acnaiatke, mana ŋeroŋa wakikiri. Ma taŋga ramtaɨr kocorta taup ndeaca taŋga, iŋmbaia ma Israelnaŋgepta lamnikta out malaruat. ");
INSERT INTO gai_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","An mɨnna Raraŋ Aetaniacna gargar mbuŋa ma mooŋnuocmo Mariana nikinikca tɨkca ma niktan ndeacri. Na an mɨn toco, Sisa Ogastus, ma Romna gagrirta ramoot paŋan ndeacri, ma ndona landamŋi mbuŋa iro ianna gainda moa laruatna, ma meikramtaɨr wɨt muruŋna iremb aŋgɨna mori. ");
INSERT INTO gai_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Na Kuirinius ma Siriana ramoot paŋan teker ndeacri, gan iremb aŋgɨna tɨp kirara, Sisa Ogastusa moatna tɨp wandɨkca, ma Romna auŋembta meikramtaɨrta irembmo muruŋ naaŋgɨri. Aintik mana mbaiŋna ramtaɨra anna morina tɨp kirara, anna tɨp wandɨk ŋgam ŋgoin ndaruca. ");
INSERT INTO gai_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ainda moca meikramtaɨra muruŋa ndorita nicarta auŋemb mɨniŋ mac nda taŋga ndorita iremb neaŋna moca. ");
INSERT INTO gai_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Aintik Iosep, ma Galili inikna auŋ Nasaret tɨkcarica ma Iudia taŋga ndona ŋgamaɨr Dewitna auŋ Betlem ndaruca. Na Iosep, ma Dewitna racaind kabepaik ŋgoin. ");
INSERT INTO gai_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ma ndona baburina meac Mariaap taŋga, iremb aŋgɨna ramoot ndambuŋ ndaruca, ndoniŋna i neaŋna moca. Na an mɨn, Maria ma niktan. ");
INSERT INTO gai_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Maniŋa an auŋa taŋga, ŋembta ŋgorena kaikca mɨnna tɨkcariatke, maniŋa taŋga bulmakaorta kaca mbukca maniŋa an ndeaca taŋga, Mariana mɨmɨrna ra laruatke. Ma ndona guina nuoc lacau mamɨrat. Na ma manmo mɨrca, mamo raraŋit mbuŋa tamaia maica. Mamo aŋgɨrca bulmakaorta amna reac tɨkca ambrena taupca meraca ma an ndeacri. ");
INSERT INTO gai_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","An mouŋa Maria Iesusa mɨratna mouŋa, ramtaɨr ndeida an auŋna raekmbai motemma, ndorita sipsiparta ŋginaiŋga moa eacri. ");
INSERT INTO gai_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Kacootna mbaiŋna aiŋa morena ŋeroŋ ianna, min ndambuŋ ndaruatke, Kacootta ma ndona memetacna tac aniacmo min nambatta weperac toca metaca eacatke, mina an mbatca rugdar moa macariat. ");
INSERT INTO gai_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ri, Kacootna mbaiŋna aiŋa morena ŋeroŋa mimo aindopatna, “Ne rugdara kai mo teac. Ne warac. Aku nemo kam wembaŋ laŋ ianap kɨpapekna. Gan kamma nemo meikramtaɨrmo muruŋa moi toŋgocarinande. ");
INSERT INTO gai_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ne warac. Mandebanna, Dewitna auŋ ndeacrena meac, ianna nuoc ian mamɨrri. Na an nuoc, ma nenmo muruŋ mac nda aŋgɨna ramoot. Na an ramoot, Raraŋ Aetaniaca babuca mbagɨrica kɨpca aimo mac nda aŋgɨna ramoot. Ma nena Kacoot. ");
INSERT INTO gai_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Na ŋgagatrac mananna gaind. Ne taŋca mamo gaind mbatnande. Mina ande, manmo raraŋit mbuŋa tamaia maica, mamo bulmakaorta amta reik tɨkca ambrena, taupca tɨkca maeacreke.” ");
INSERT INTO gai_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","An mbaiŋna aiŋa morena ŋeroŋa aindopacariri, tawi ŋgoinna tamuŋna Kacootna mbaiŋna aiŋa morena ŋerŋgaura, lapoca ruŋrena ramtaɨrta mɨmɨatna kirar ŋgirikca. An mbaiŋna aiŋa morena ŋeroŋna kɨtɨmma wɨtɨkca, mina toŋgoca Raraŋ Aetaniacna imo tamuŋ ŋgoin naaŋgɨa ŋgepatna. ");
INSERT INTO gai_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Ri, mina gaindopatna, “Raraŋ Aetaniac, ma tamuŋ, tamuŋ ŋgoin, mana i aniacmo tamuŋ naaŋgɨ ŋgep. Te, gan tiacarpaikna meikramtaɨra, Raraŋ Aetaniaca minmo toŋgorenanmo, mina nikinik iroara moi wewettaca laŋ ndeacnandet.” ");
INSERT INTO gai_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ainda moca Raraŋ Aetaniacna mbaiŋna aiŋa morena ŋerŋgaura min tɨkcarica, tamuŋna auŋ mac nda taŋgatke. Karica sipsiparta ŋginaiŋga morena ramtaɨra ndori puŋga aindopatna, “Ande, Kacootta aimo mambopri. Aria! Aia taŋga an reaca Betlem auŋ ndaruapeknanna watna.” ");
INSERT INTO gai_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Aindopacariri, mina anduna ŋgepca taŋga laruca wattatnanna, Kacootta mbopapekna kirar ŋgoinna Mariaapa Iosep mbaniŋa eacri. Na mooŋnuoca bulmakaorta amta reik tɨkca ambrena taupca meraca eacrina. ");
INSERT INTO gai_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ri, mina taŋga watta maica, karica sipsiparta ŋginaiŋga morena ramtaɨra, ndori watri, waracrina, an nuocna nininia moatke. ");
INSERT INTO gai_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Meikramtaɨra an reacna kam mbaraca iroara an reacna tamtam ndamŋiatke. ");
INSERT INTO gai_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maria an reikta kambca, ma ndona iro mbuŋ ndamŋia maeacri, na ma lamŋia mataŋreke. ");
INSERT INTO gai_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Na sipsiparta ŋginaiŋga morena ramtaɨra, min tɨkcarica, ndorita eacrena taup mac nda taŋga, Raraŋ Aetaniacna i aŋgɨa ŋgepatke, Raraŋ Aetaniacmo kam laŋ maneaŋri. Na ma mimo wandaca mina watri, waracrina, reikca mbaiŋna aiŋa morena ŋeroŋ mboprina kirar ŋgoin malaruat. ");
INSERT INTO gai_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Na rai mbutremb mbonkacna mɨnna raipaikca maiatke. An mɨn, minanna tɨpca raŋgaica an nuocna tikiŋit kataca, mamo i, Iesus matɨkat. An i, Maria ma nik tɨk ŋgocor ndeacri, Raraŋ Aetaniacna mbaiŋna aiŋa morena ŋeroŋa an imo ŋgaua mamo neaŋgatna. ");
INSERT INTO gai_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Karica an meikpitikta baruk tɨkcarica lataruna ra laruca, Iosepapa Maria, maniŋa an lataruna tɨpna kirara raŋgaica Raraŋ Aetaniaca Mosesmo neaŋrina Tɨp Wandɨkca an timbigta kapca tirrina nininina Tɨp Wandɨkca raŋgaica mona. Ri, maniŋa an mooŋnuocmo aŋgɨca Ierusalem naaŋgɨ taŋga Raraŋ Aetaniacmo neaŋna. ");
INSERT INTO gai_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Na Kacootna Tɨp Wandɨkna timbigta kapca ma gaindopatna, “Meikpitikca, mooŋnuoc ianna mɨr ŋgocor ndeaci taŋi, ma ndona guina nuoc, lacaua mɨr te, ne mamo babuca aŋgɨ taŋca, Kacootta neaŋ.” ");
INSERT INTO gai_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Aindopri tik, maniŋ toca ŋgorac ŋgamniŋap kɨpca, Kacootna Tɨp Wandɨkca mboprina tɨpna kirara raŋgaica, pɨanmainiŋ co, riŋnainiŋ an mbuŋa gɨmbamba moa neaŋna moca. ");
INSERT INTO gai_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","An mɨnna ramoot ian, ma Ierusalem ndeacrena. Mana ia Simeon. Ma ramoot wandoŋ laŋ ŋgoin. Ma Raraŋ Aetaniac niŋgikca raŋgairena ramoot. Simeonna Raraŋ Aetaniaca babuca mbagɨrina ramootna ndabirena. Na an ramoot, Israelna meikramtaɨrmo mina nikemb inkara moi laiŋga mona moca ma anna ndabirena. Na Simeonna, Ŋeroŋ Ratta manap eacrena. ");
INSERT INTO gai_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Na Ŋeroŋ Ratta ŋgaua mamo aindopatna, “U mba tawi menacitndai. U ndo ŋgoinna, gan Kacootta babuca mbagɨrica kɨpca aimo mac nda aŋgɨna ramootmo, watnande.” ");
INSERT INTO gai_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Karica Ŋeroŋ Ratta manmo aoca ŋgepca, ma taŋga Raraŋ Aetaniacna Kacna wuoca mbukca. Mooŋnuocna amepaetniŋa ndoniŋna nuoc, Iesusap warkica kɨpca, Tɨp Wandɨkca raŋgaina moca kɨpca mbukatke. ");
INSERT INTO gai_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeonna mamo, ndona par mbuŋa aŋgɨa ŋgepca potaca, ma Raraŋ Aetaniacna imo aŋgɨa ŋgepca gaindopatna, ");
INSERT INTO gai_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Kacoot, aku ŋgaua una mbaiŋna aiŋa morena ramoot, mandeaca, u aukmo watcarica, aku taŋga nikinik iro wetwet laŋa gɨgɨrar kocora menacna. U atu ndoprina reac, ");
INSERT INTO gai_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","aukna lamnɨaca mawatri, an reac u ai mac nda aŋgɨna morina reac. ");
INSERT INTO gai_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","U meikramtaɨr wɨt muruŋna lamnikca, u ai mac nda aŋgɨna reac an kocrorina. ");
INSERT INTO gai_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Anna memetac ian. An memetaca Iudana meikramtaɨra wanaiŋnanda metac te, mina Raraŋ Aetaniacmo lamŋi garacnande. Aintik una Israelna meikramtaɨr mina i aniac ŋgoin aŋgɨnande.” ");
INSERT INTO gai_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Karica Iesusna amepaetniŋ, maniŋa an kambca Simeonna Iesus ndoprina kamb mbaraca, maniŋna iroara tamtam ndamŋiatke. ");
INSERT INTO gai_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeonna Raraŋ Aetaniacmo digica, “U mooŋnuocapa amepaetmo ndona opotac laŋ neaŋ.” Aindopacarica ma mooŋnuocna aem, Mariamo aindopatna, “U warac. Raraŋ Aetaniac, an mooŋnuocmo baburina, ma Israelna meikramtaɨr wɨtmo, mo iriknande. Te, ma mimo wɨt mac nda aŋgɨri ŋgepnande. Ma minmo ŋgagatracna kirar ndeac te, meikramtaɨra manmo kekelamun irik te, ");
INSERT INTO gai_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","mina iroara, iŋgoroca eacrenanna, larui raekca tɨknande. Na Maria, una rugutta lapoc tɨp rɨŋga gɨgɨraek toc, u aind ndamŋinande.” ");
INSERT INTO gai_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Karica ramma morena meac ian, ma eacrena. Mana ia Anna. Ma Panuelna mooŋ. Ma Aserna barnan. Ma maica bagaraica, na ma ŋgaua, ramoot laŋgoca manap eaca taŋga, iarira parmbaiapa mbut mbuniŋna mɨnna tɨkca. ");
INSERT INTO gai_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Iŋmbaia mana kaŋgaitta menacatke. Ma meac konimma wanaiŋ ndeac taŋga. Mandeaca, mana iarira 84na mɨn. Na Anna, ma Raraŋ Aetaniacna Kacna wuoc inikca mba tɨkcarirenanna. Ma ainda morena, memetmbaca, ma warirac te, ma mbendei niŋgikca moraŋnande. Na ma Raraŋ Aetaniacna aiŋa, mouŋapa raap morena. ");
INSERT INTO gai_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Na an mɨn, ma toca kɨpca, mooŋnuoc ndambuŋa rambuŋaica, Raraŋ Aetaniacmo kam toŋtoŋ laŋ neaŋrina. Karica ma meikramtaɨrmo an mooŋnuocna kam ndopca laruca. Na an meikramtaɨr, mina Ierusalem ndeacrenan, na mina Raraŋ Aetaniacna moca muruŋ ndabirena, ma minmo mac nda aŋgɨnandet. ");
INSERT INTO gai_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Mina an lataruna reikca Kacootna Tɨp Wandɨkca mboprina tɨpna kirara kocnaia moa maica. Tɨkcarica, mina Galili mac nda taŋga, ndorita auŋ Nasaret mataŋri. ");
INSERT INTO gai_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Karica mooŋnuoca, an ndeaca taŋga acnaica, ŋgepca ramootta wakikiatke. Mana iro landamŋiar laiŋ koinda, mamo kɨpca mɨnna tɨkca, na Raraŋ Aetaniacna opotaca manap eacrena. ");
INSERT INTO gai_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Na Pasowana Rana moca, Iesusna amepaetniŋa, memetmbaca iarira anna ndamŋireke, maniŋa Ierusalemma taŋrena. ");
INSERT INTO gai_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ri, Iesus, mana iarira taŋga parniŋapa mbut mbuniŋa tɨkatke, mina an ra aniacna tɨpna kirara raŋgaica, taŋga Ierusalem ndaruca. ");
INSERT INTO gai_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Na an ra aniacna tɨpna kirara moa maiatke, mina auŋemb mac nda mataŋgat. Ri, mooŋnuoc Iesusa Ierusalem makariat. Na mana amepaetniŋa mba lamŋiatke. ");
INSERT INTO gai_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","45","Ri, amepaetniŋa mamo kabena meikramtaɨrap outta tataŋ ndopca. Ainda moca maniŋa mataŋgat, na an ra maica, maiatke, maniŋa mannake, watta tambacarica. Iŋmbaia maniŋa ndoniŋna auŋ kabenanapa wiwitnan ndambuŋa mana moca, orerea tambca mamo wat ŋgocor. Ainda moca maniŋa Ierusalem mac nda taŋga mana ŋgorena moca. ");
INSERT INTO gai_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Karica maniŋa mana moca orea taŋ, taŋga rai mbonkac mbuŋa, maniŋa manmo watca. Ma Raraŋ Aetaniacna Kacna wuoc inik ndeacri. Ma ririptiarta kɨdrɨkca mbiraca eacri, min mboprena kamb mbaraci mai te, ma min motoco, ndona digdigiara mac nda digi taŋnande. ");
INSERT INTO gai_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ma ainda moreke, meikramtaɨra mana kamb mbaraca ŋgep ŋgoreac naŋgepri, mana landamŋiapa mana kamna moca. ");
INSERT INTO gai_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Na maniŋa mamo watca tamtam ndamŋica. Mana aemma manmo aindopatna, “Iesus, u aŋmo kaina moca gan tɨpca moapekna? Aŋga, una amepaetniŋa iro inikniŋa tamtam ŋgoin ndamŋica, aŋga una moca aiŋ aniac ŋgoreapekna.” ");
INSERT INTO gai_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Aindopri ma maniŋna kamma gainda rutica, “Kai ŋgoinna moca oŋgo aukna ŋgoreaca taŋre? Oŋgo mba lamŋiritta, a? Aku ndona Aetna Kacna wuoc inik ndeacrena.” ");
INSERT INTO gai_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ma aindopri, maniŋa mana mboprina kamna mɨnɨŋa lamŋi ŋgocor. ");
INSERT INTO gai_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Karica ma maniŋap, mina mac nda taŋga Nasaret auŋ ndaruca. Memetmbaca, ma maniŋna kam niŋgik mbaracrena. Aintik mana aemma an kambca, ndona nikinik mbuŋ ŋgutiŋga maeacri. ");
INSERT INTO gai_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Karica Iesusa ŋgepca acnaica mana landamŋica, laiŋ koind taruatke. Raraŋ Aetaniacapa, meikramtaɨrap mina muruŋa manmo toŋtoŋgar koind. ");
INSERT INTO gai_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Sisa Taiberius, ma Romna gagrirta ramoot paŋan ndeaca, kɨpca iarira 15na mɨn mbuŋ. Na an mɨn, Pontius Pailat, ma Iudiana inik bubuocrena ramoot paŋan, na Erot ma Galilina inik bubuocrena ramoot paŋan, na mana lapmbitac Pilip, ma Ituriaapa Tarakonitisna inik bubuocrena ramoot paŋan, na Lisanias, ma Abilenena inik bubuocrena ramoot paŋan. ");
INSERT INTO gai_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Na Anasapa Kaiapas, maniŋa taup ndamoot paŋan aniacniŋ ndeacri. Na an iar mbuŋa Sekaraiana nuoc Ion, ma ramtaɨr kocorta taup ndeacri. Na an mɨn, Raraŋ Aetaniacna kamma Ion ndambuŋ ndaruca. ");
INSERT INTO gai_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ainda moca Ionna taŋga oc Iodanna inikna auŋembca mbukca. Ma meikramtaɨrmo gan kam wiwitirina, “Nena iroar inkar ŋgetrikica Raraŋ Aetaniaca raŋgaica kɨtac puk aŋgɨ te, Raraŋ Aetaniac nena tɨpemb ŋgorikta makukar, ma mo kecarinande.” ");
INSERT INTO gai_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ri, an reac, ramma morina ramoot Aisaiana timbigta kapna nininina, kirara gaindoprina, “An ramtaɨr kocorta taupca, ramoot ianna kamma gaind ŋgaca mboprina, ‘Kacootna taup matau te, mana taupemb gepairinanmo wandoŋai. ");
INSERT INTO gai_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Te, pacwɨkɨn aupi kɨtac te, taukruirmo kocnai rɨŋi bɨrɨrɨ iriki mbirac. Te, taupembca muruŋa gegebar ndeaceknandap kocnai wandoŋai. Te, taupembca laiŋga wanaiŋ, ne mimo muruŋa moi laŋa mo. ");
INSERT INTO gai_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Te, gan tiacarpaik ndeacrena meikramtaɨra watna, na an aiŋa, Raraŋ Aetaniaca morinanna, anna ai mac nda aŋgɨna aiŋ.’” ");
INSERT INTO gai_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Meikramtaɨr wɨt aniaca kɨpca Ionna par mbuŋa kɨtac puk aŋgɨna moca, ma mimo aindopatna, “Ne nduop ŋgoreacna mombonik, Raraŋ Aetaniaca nenmo nikkakatap, na ma nenmo mo ŋgocrainandet. Na mandaia nemo mbopca ne kɨpcarina moek? Ne an nikkakatta iukaiit, co wanaiŋ? Ma nemo larunande. ");
INSERT INTO gai_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Na ne ndorita iroar inkarmo gidkar koinda ŋgetriki te, nena tɨpembca ndori nemo wandacnande, ne ndorita iroar inkar maŋgetrikiri. Na ne ainda kai lamŋi teac, ne tɨpemb ŋgorikta moca kɨpcarica gaindopna, ‘Abraam, ma aina aterta nicar ŋgamrirta aet.’ Ne ainda kai mbop teac. Aku nemo aindopnandet, Raraŋ Aetaniac ma gan watur puŋga ma Abraamna nicar ŋgamrirta mombonikca, mo laruna mɨn. ");
INSERT INTO gai_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Na oteac ianna ikirta mɨnɨŋa kocroca maeacreke. Na ikira lour laiŋga gɨwaca er ŋgocortanmo, anna muruŋa kocnaii waci irikca kataci aŋgɨri tac nake mbuknande.” ");
INSERT INTO gai_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ma aindopri, meikramtaɨr wɨt aniaca mamo gainda digirina, “Aia tida moit?” ");
INSERT INTO gai_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ri, ma mina kammo gaind mac nda rutirina, “Ne mandaia tik ŋgapaoc mbuniŋapnan, u ramoot ianna wanaiŋ ndeaceknanna neaŋ. Mandaia amta reikap eaceknan, u toco ainda mo.” ");
INSERT INTO gai_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ma aindopri, kitcartukar iurena ramtaɨr ndeida, mitoca kɨpca kɨtac puk aŋgɨna moca, mina manmo digica, “Riripti, aia tida moit?” ");
INSERT INTO gai_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Aindopri, ma mimo aindopatna, “Nena aiŋirta kitukndukara, min tɨkrina ŋgaŋganŋgɨna kituknduk niŋgik naaŋgɨ, ne kai iu kun teac.” ");
INSERT INTO gai_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Aindopri, lapoca ruŋrena ramtaɨr ndeid toca kɨpca, mamo gainda digirina, “Aia tida moit?” Ainda digiri, ma mimo aindopatna, “Ne ramtaɨrta kitukndukar aŋgɨna moca, minmo tamtamma kai pi teac, mina tikembca, kai paru teac. Nena aiŋna kituknduk niŋgik aŋgɨ.” ");
INSERT INTO gai_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ma aindopri, meikramtaɨrta iroara ŋgepca gagraca mina muruŋna nikinik iroara tamtam ŋgoinna gaind ndamŋica, gaindopca, “Anna Ion, Raraŋ Aetaniaca babuca mbagɨrica kɨpca aimo mac nda aŋgɨna ramoot ki?” ");
INSERT INTO gai_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Aintik Ion, ma mimo gaindoprina, “Aku puk mbuŋa nemo kɨtac pukca monande. Na ramoot ian ma iŋmbai nakɨpnande. Mana gargara aukna gargarmo tamuŋ ŋgoin. Na ma aukmo kunda tamuŋ ŋgoin, na ma ramoot totour ŋgoin. Aintik aku manap aiŋa mona mɨnna wanaiŋ. Ma nemo Ŋeroŋ Rat mbuŋapa tac mbuŋa kɨtac pukca monande. ");
INSERT INTO gai_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ma mandeaca makocroca, witmo ma kacopca lour laiŋga irik te, lapea roumbmbaia irik te, ma lourmo aŋgɨri witna kac inikca tɨkcarica ma ŋaŋawirmo aŋgɨri, an taca mba pikrenan nake mbukca, ma loriraŋnande.” ");
INSERT INTO gai_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Karica Ion, ma kabena kam ndeidap mac mboprina, ma mina iroara mo ŋgepna moca an tɨp kirara ma meikramtaɨrmo kam wembaŋ laiŋ wiwitirina. ");
INSERT INTO gai_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","22","Meikramtaɨr wɨt aniaca an ndeacrenanna muruŋa Ionna par mbuŋa kɨtac puk aŋgɨri, na an mɨnna Iesus toca kɨtac puk aŋgɨracarica ma mbendeiri, tamuŋna auŋa gootatke. Ŋeroŋ Ratta man ndambuŋ ŋgirikrinanna, man ndambuŋmo ŋgorac riŋnaina kirar toc, ŋgirikca mana paŋan nambat ndeacri. Na tamuŋna auŋna kam ianna aindopatna, “U aukna Nuoc. Aku unmo mamatŋi ŋgoin. Aukna nikinik iro umo toŋtoŋ ŋgoin.” Na Erotta ma tɨpemb ŋgorik wɨtapna ramoot, ma ŋgepca ndona lapmbitacna meac Erodiasmo tɨp ŋgoreaca mac mori. Ainda moca Ion, ma an Galili bubuocrena ramoot paŋan Erotmo kaega morina. Ri, Erot ma ŋgepca kabena tɨp ŋgoreac ianna an nambat mac mamoat, ma Ionmo aŋgɨra kac ŋgoreaca mac matɨkat. ");
INSERT INTO gai_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Na an mɨnna Iesusa ndona aiŋ aŋgɨa ŋgepatna mɨnna, mana iarira 30na mɨn. An mɨn mbuŋa ma ndona aiŋ aŋgɨra ŋgepatke, meikramtaɨra, mina mamo anmo Iosepna nuoc ndopca. Na Iosep ma Elina nuoc. ");
INSERT INTO gai_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Na Eli ma Matatna nuoc. Na Matat ma Liwaina nuoc. Na Liwai ma Melkina nuoc. Na Melki ma Iannaina nuoc. Na Iannai ma Iosepna nuoc. ");
INSERT INTO gai_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Na Iosep ma Matatiasna nuoc. Na Matatias ma Emosna nuoc. Na Emos ma Naumna nuoc. Na Naum ma Eslina nuoc. Na Esli ma Nagaina nuoc. ");
INSERT INTO gai_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Na Nagai ma Maatna nuoc. Na Maat ma Matatiasna nuoc. Na Matatias ma Semenna nuoc. Na Semen ma Iosekna nuoc. Na Iosek ma Iodanna nuoc. ");
INSERT INTO gai_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Na Ioda ma Ioananna nuoc. Na Ioanan ma Resana nuoc. Na Resa ma Serubabelna nuoc. Na Serubabel ma Sialtielna nuoc. Na Sialtiel ma Nerina nuoc. ");
INSERT INTO gai_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Na Neri ma Melkina nuoc. Na Melki ma Adina nuoc. Na Adi ma Kosamna nuoc. Na Kosam ma Elmadamna nuoc. Na Elmadam ma Erna nuoc. ");
INSERT INTO gai_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Na Er ma Iosuana nuoc. Na Iosua ma Elieserna nuoc. Na Elieser ma Iorimna nuoc. Na Iorim ma Matatna nuoc. Na Matat ma Liwaina nuoc. ");
INSERT INTO gai_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Na Liwai ma Simeonna nuoc. Na Simeon ma Iudana nuoc. Na Iuda ma Iosepna nuoc. Na Iosep ma Ionamna nuoc. Na Ionam ma Eliakimna nuoc. ");
INSERT INTO gai_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Na Eliakim ma Meleana nuoc. Na Melea ma Menana nuoc. Na Mena ma Matatana nuoc. Na Matatta ma Natanna nuoc. Na Natan ma Dewitna nuoc. ");
INSERT INTO gai_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Na Dewit ma Iesina nuoc. Na Iesi ma Obetna nuoc. Na Obet ma Boasna nuoc. Na Boas ma Salmonna nuoc. Na Salmon ma Nasonna nuoc. ");
INSERT INTO gai_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Na Nason ma Aminadapna nuoc. Na Aminadap ma Atminna nuoc. Na Atmin ma Arnina nuoc. Na Arni ma Esronna nuoc. Na Esron ma Peresna nuoc. Na Peres ma Iudana nuoc. ");
INSERT INTO gai_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Na Iuda ma Iakopna nuoc. Na Iakop ma Aisakna nuoc. Na Aisak ma Abraamna nuoc. Na Abraam ma Terana nuoc. Na Tera ma Nakorna nuoc. ");
INSERT INTO gai_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Na Nakor ma Serukna nuoc. Na Seruk ma Reuna nuoc. Na Reu ma Pelekna nuoc. Na Pelek ma Eberna nuoc. Na Eber ma Selana nuoc. ");
INSERT INTO gai_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Na Sela ma Kainanna nuoc. Na Kainan ma Arpaksatna nuoc. Na Arpaksat ma Siemna nuoc. Na Siem ma Noanna nuoc. Na Noa ma Lamekna nuoc. ");
INSERT INTO gai_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Na Lamek ma Metuselana nuoc. Na Metusela ma Enokna nuoc. Na Enok ma Iaretna nuoc. Na Iaret ma Maalalelna nuoc. Na Maalalel ma Kenanna nuoc. ");
INSERT INTO gai_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Na Kenan ma Enosna nuoc. Na Enos ma Setna nuoc. Na Set ma Adamna nuoc. Na Adam ma Raraŋ Aetaniacna nuoc. ");
INSERT INTO gai_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Na Ŋeroŋ Ratta Iesusmo mbukca mɨnna tɨkca. Iesusa oc Iodannan gaca, Ŋeroŋ Ratta manmo aŋgɨra taŋga, ramtaɨr kocorta taupca tɨkca. ");
INSERT INTO gai_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ma an ndeaca taŋga rai 40na mɨn. Na an mɨnna, Paparuna Ramootta mamo matowaiat. Na ma amna reac ianna am ŋgocor ndeacri, na an mɨn maiatke, ma nik wataica ŋgocraica eacri. ");
INSERT INTO gai_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Na Paparuna Ramootta mamo aindopatna, “U Raraŋ Aetaniacna Nuoc ecte, u gan wautmo, mbopca ma gagamna tapac ŋgurirac.” ");
INSERT INTO gai_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Aindopri, Iesusa mana kam rutica aindopatna, “Raraŋ Aetaniacna Timbigta Kapca aindoprina, ‘Meacramootna gargara mba amna reac niŋgik mbuŋa mba gagraitndai.’” ");
INSERT INTO gai_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ma aindopri, Paparuna Ramootta mamo tamuŋa naaŋgɨra gaca weperac wandacri toca, gan tiacarpaik muruŋna auŋembta reik wandaca maica. ");
INSERT INTO gai_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Karica Paparuna Ramootta mamo aindopatna, “Gan gargara auknan. Aku aŋgɨrca eacrena. Aku gan reikta gagrarapa iremb anikca, aku unmo neaŋnande. Na aku ndo mbuŋa ramoot ianna neaŋ ndop te, aku neaŋnande. An auŋemb muruŋapa an inik ndeacrena reikap, aku una bubuocna kaŋgaukca tɨknande. ");
INSERT INTO gai_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Na u aukmo tutupniŋ rɨmbɨtca, mbendei te, gan reik anna unan.” ");
INSERT INTO gai_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ma aindopri, Iesusa mana kam rutica aindopatna, “Raraŋ Aetaniacna Timbigta Kapca aindoprina, ‘U ndona Kacoot niŋgikmo memetmbaca tutupniŋ rɨmbɨtca mbendeiraŋ. Ma una Raraŋ Aetaniac. U mana aiŋ niŋgikca moraŋ.’” ");
INSERT INTO gai_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Iesusa aindopri, Paparuna Ramootta mamo aŋgɨa taŋga Ierusalem naaŋgɨa gaca. Raraŋ Aetaniacna Kacmo, mon tamuŋ ŋgoinnanna tɨkca ma mamo aindopatna, “U Raraŋ Aetaniacna Nuoc ecte, u ganna tɨkca wɨkɨnna putriki irik. ");
INSERT INTO gai_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","11","U ainda mo, Raraŋ Aetaniacna Timbigta Kapca aindoprina, ‘Raraŋ Aetaniaca mana mbaiŋna aiŋa morena ŋerŋgaurmo ma mbagɨrica mina kocroca, unmo ndorita paɨr puŋ ŋgotac te, waut ianna una ora mba rɨŋitndai.’” ");
INSERT INTO gai_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Paparuna Ramootta aindopri, Iesusa mana kam rutica aindopatna, “Raraŋ Aetaniacna Kamma gaind maeacreke, ‘U ndona Kacoot Raraŋ Aetaniacmo kai towai teac. Ma una Raraŋ Aetaniac.’” ");
INSERT INTO gai_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Iesusa aindopri, Paparuna Ramootta Iesusmo totowaiara towaia tambacarica, manmo iŋmbaina ŋginaŋ mac watna moca manmo watcaririna. ");
INSERT INTO gai_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ŋeroŋ Ratna gargar ŋgoin mbuŋa Iesusa Galilina pitrik waŋ inik mac nda taŋga. An inikna auŋembta meikramtaɨr, muruŋa Iesusmo Galili inik mac nda kɨkɨpna kam mbaraca eacri. ");
INSERT INTO gai_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ma mimo memetmbaca mina Iudananta mimitpac aŋgɨrena kaik inkara mbukca, meikramtaɨrmo ripti neaŋga taŋri. Na meikramtaɨra muruŋa, mana i aŋgɨa ŋgeprina. ");
INSERT INTO gai_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Karica Iesusa ma ndona eaca taŋga acnaiatna auŋ Nasaret mac nda mataŋgat. Na Wɨktɨkna Ra, ma ndona tɨp kirara raŋgaica, ma mina Iudananta mimitpac aŋgɨrena kac inikca mbukca, ma anna wɨtɨkca meikramtaɨrmo Raraŋ Aetaniacna kamma watta mbopna kocrori. ");
INSERT INTO gai_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Na mina mamo Raraŋ Aetaniacna ramma morina ramoot, Aisaiana timbigta kap aŋgɨra neaŋga, ma gootca ore taŋga watatna nininia gaindopatna, ");
INSERT INTO gai_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Kacootna Ŋeroŋa aukmo gaindta ŋgagatraca moca, ramoot ianna paŋanmo tabaɨr ruŋkirina kirara, aukmo ainda moca babuca lamarapacat. Na ma aukmo kɨpca mɨnna tɨkri. Aintik ma aukmo meikramtaɨr ndaek ndeacrenan koindmo kam wembaŋ laŋ neaŋna moca. Aintik ma aukmo anna mbagɨrica kɨpca tuomb naaŋgɨrinanmo wattacarica mina taŋ. Te, lamnik ŋgorikcap eacrenan toca, mac watna. Ma aukmo an makukarap eacrenan, anna moi laŋa mona, mimo watcaria mina makukar kocora eacraŋ. ");
INSERT INTO gai_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ma aukmo mbagɨrica, meikramtaɨrmo gan kamma gainda ŋaŋari mbopna moca, Kacootna ndiarna tɨp kirara mandeaca malaruri. Meikramtaɨrmo an ndiarna tɨp kirara minmo moi laŋa monande.” ");
INSERT INTO gai_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Karica Iesusa timbigta kap kaptikica, anna ŋginaŋa morena ramoot mac nda neaŋgacarica, ma mbiracatke. Na meikramtaɨra, an Iudananta mimitpac aŋgɨrena kac inik ndeacrenanna muruŋa lamnikca man niŋgikca wattikri. ");
INSERT INTO gai_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Na ma aindopatna, “Ne an Raraŋ Aetaniacna timbigta kapca, aku mbopapeknanna, ne waracapekca. Mandeaca, ma gade gidik ŋgoin malaruri.” ");
INSERT INTO gai_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ma aindopri, mina mana i aŋgɨa ŋgepatke, mina mana mboprina kamb laiŋta moca, anna ndamŋia taŋga aindopatna, “Titoc ŋgoinna moca ma gaindta kamb ndopapekna? Aia lamŋirena, an ramoot, ma Iosepna nuoc.” ");
INSERT INTO gai_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Na mina aindopatke, Iesusa mimo gaindopatna, “Ŋarikca ne gan kam roora meikramtaɨra mboprenan aŋgɨca aukmo aindopnande, ‘Pitir gagam, u ndona tik ŋgoin motoco wandoŋai.’ Te, ne gaindopnande, ‘Aiata waracrina, u Kapaneamma tɨkca morina reikta kambca, mandeac u gan ndona auŋ mɨnɨŋ motoco, ainta reikta kirarir koinda mo!’” ");
INSERT INTO gai_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Na ma gaind mac mboprina, “Na aku nenmo gidik ŋgoinna aindopnande, mina mba ndorita auŋ mɨnɨŋna ramma morena ramootmo mba aŋgɨ tɨki eacitndai. ");
INSERT INTO gai_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Aku nemo gidik ŋgoinna aindopnande, atua Elaiana mɨnna, Israelna meik wɨtta koinmbar ndeacri. An mɨnna puik kocor. Ra niŋgikca ndo taŋ, taŋga guiar mbonkacapa tɨpap, aŋgɨratke. An iniknanda, nik wapatai aniac laruca eacrina. ");
INSERT INTO gai_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ri, Raraŋ Aetaniac, ma Elaiamo Israelna meac ian nake, mba mbagɨrica taŋgatke. Wanaiŋ, wanaiŋ ŋgoin. Ma mamo auŋ aniac Saidonna inik ndeacrena auŋ ian, Sarepat, anna meac ianna mana kaŋgait menac ma meac konim ndeacri, ma manmo anna mbagɨrica taŋgatna. ");
INSERT INTO gai_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Karica an tɨpna kirar ŋgoin, an ramma morina ramoot, Elaisa, ma Israela taŋga, an inikna meikramtaɨr ndeida roumb lepa moa ŋgocraica, mina embaia laŋa mba mori. Mina muruŋa roumbbebap eacri. Na Naman, ma ndo kabea Siriana pitrik waŋna ramoot, man niŋgikna roumb lepa, Elaisa ndo manmo moa laŋa morina.” ");
INSERT INTO gai_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Iesusa an nininiara ninia maiatke, mina Iudananta mimitpac aŋgɨrena kac inik ndeacrenanna, an kamb mbaraca, nikembkatca ŋgocraica, ");
INSERT INTO gai_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","ŋgepca, manmo aŋgɨa wɨŋga laruca, mamo ke irikna moca. Na an auŋa takur tamuŋ ndeacrena. Anna tɨkca mina mamo takur tamuŋna roumbca tɨkca, pacwɨkɨn nake, irikna moca aŋgɨra taŋgatke. ");
INSERT INTO gai_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ma mina rɨkca mbukca, ma ndona toŋtoŋa taŋga macariri. ");
INSERT INTO gai_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ma taŋga Galili inikna auŋ ian, Kapaneam, ndaruca. Wɨktɨtɨkna Ra, ma meikramtaɨrmo ripti neaŋri. ");
INSERT INTO gai_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Mina an riptiarta kamb mbaraca, tamtam ndamŋica aindopatna, “Gidik ŋgoin! Mana kamma gargarap.” ");
INSERT INTO gai_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Aindopacarica ramoot ianna ŋeroŋ ŋgoreaca mbukca eacrinanna, ma mina Iudananta mimitpac aŋgɨrena kac inik ndeaca. Ŋeroŋ ŋgoreaca kamb anik keca, aindopatna, ");
INSERT INTO gai_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ae! Iesus Nasaretnan, u ai ndambuŋmo kaina nakɨprina? Ŋarikca u kɨpca aimo mo ŋgocrai nari? Aku umo lamŋirena. U Raraŋ Aetaniacna Ramoot Rat.” ");
INSERT INTO gai_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ŋeroŋ ŋgoreaca aindopri, Iesusa an ŋeroŋ ŋgoreacmo kaega moca aindopatna, “U watitica, an ramootmo kacrep!” Aindopri, ma an ramootmo kecarica, ma mina rɨkca tiacarpaik ŋgirikca keca, ŋeroŋa manmo tɨkcarica, mamo mba moa ŋgocrairi. ");
INSERT INTO gai_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ainda moca meikramtaɨra rugdar mocarica ndori puŋga aindopatna, “Anna titna ramootta ndo, iapa gargarapna ramootna kirar toca? Aindopapeke, ŋerŋgaur ŋgorikca mana kam mbaraca, an ramootmo kacrepca mina mataŋgat.” ");
INSERT INTO gai_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ri, Iesusna ainda morina reikta kambca tamtamma taŋga mamaiat. ");
INSERT INTO gai_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Na ma an Iudananta mimitpac aŋgɨrena kac kecarica, taŋga Saimonna kacnɨm ndaruca, mina mamo aindopatna, “Saimonna meacna aemma tik owowaina roumbca moa ŋgocraica maeacreke. U manmo otacna mɨn ki?” ");
INSERT INTO gai_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Aindopri, ma taŋga an meacna kɨtɨmma wɨtɨkca an roumbmo kaega moca aindopatna, “U mandebanna, an meacmo kacrep!” Ri, roumb anna, anduna mamairi. Na an meaca anduna ŋgepca wɨtɨkca minmo amta reik maneaŋri. ");
INSERT INTO gai_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","An ra maica nenepuatke, meikramtaɨra, ndoriap eacrena meikramtaɨr ndeida, ainta roumbbeb ndeida moa ŋgocraica eacrenanna, mina mimo muruŋ ŋgoin naaŋgɨa kɨpca Iesus ndambuŋ ndaruca. Ma an roumbbebta meikramtaɨrmo ndona parmo, min nambatmo kabe, kabemo tɨkri, mina roumbbebca laiŋga moatna. ");
INSERT INTO gai_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Na an ŋerŋgaur ŋgorikca mimo kecarica taŋga, kam keca aindopatna, “U Raraŋ Aetaniacna Nuoc!” Aindopri, ma mimo mbop narica kaega moca mbopri, mina lamŋirena, an ramoot Raraŋ Aetaniaca babuca mbagɨrica kɨpca aimo mac nda aŋgɨna ramoot. ");
INSERT INTO gai_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Na ŋaŋarmuŋ ŋgoinna ma an auŋ tɨkcarica, ma taŋga ramtaɨr kocorta taup ndeacri. Meikramtaɨra mana moca, orea taŋ, taŋga mamo anna tɨkca watca, mamo aindopatna, “U aimo kai kecarica taŋ teac.” ");
INSERT INTO gai_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Mina aindopri, ma minmo gaindopatna, “Aku mba eacitndai. Aku kabena auŋembmo Raraŋ Aetaniacna bubuocna kam wembaŋ laŋ wiwiti taŋna ndopca anna nakɨprina. Ma aukmo anna mbagɨrica, aku an aiŋna nakɨpatna.” ");
INSERT INTO gai_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Na ma aindopacarica ma an Iudiana pitrik waŋna inikna Iudananta mimitpac aŋgɨrena kaikmo Raraŋ Aetaniacna kambca anna wiwitica neaŋga taŋrena. ");
INSERT INTO gai_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Na oit ianna Iesusa Genesaretna mɨar roumbca wɨtɨkca eacri, meikramtaɨr wɨt anikca, Raraŋ Aetaniacna kam mbaracna moca, mina taŋga man ndambuŋa puniri. ");
INSERT INTO gai_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Na ma watrinanna, ŋgoaebta aiŋa morena ramtaɨra embarta korniŋmo mɨar roumbca wɨŋga gaca tɨkcarica, mina weaŋgaɨr tukireke. ");
INSERT INTO gai_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ri, ma an embarta korniŋna ian maŋgabukat, na an kora Saimonnan. Ri, Iesusa Saimonmo aindopatna, “Kormo teker emtemmo, raek acait motemma mo laru.” Aindopri, Saimonna ma kormo rapaca laruri, Iesusa kora mbiraca meikramtaɨrmo ripti neaŋrina. ");
INSERT INTO gai_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Na ma minmo ripti neaŋga maica, karica, iŋmbaia ma Saimonmo aindopatna, “Kormo mon gom raek acait motemma rapac laru te, ne weaŋgaɨrmo keca ŋgoaeb ndeid aŋgɨnande.” ");
INSERT INTO gai_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Aindopri, Saimonna mana kam rutica aindopatna, “Ramoot paŋan, gan mouŋ rocot, aia aiŋ anikca wanaiŋa morina. Aia ŋgoaem ianna mba aŋgɨri. Laŋ, u mbopri tik, aku weaŋgaɨr ke iriknande.” ");
INSERT INTO gai_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Mina ainda mori, ŋgoaebta kaik bagraranikta taup nakataca, keca ŋgoaebca kɨprinanna, an weaŋgaɨrmo mbuk, mbukca, weaŋgaɨra maica, titacnan toca mori. ");
INSERT INTO gai_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ainda moca mina an aiŋ kabea morena ramtaɨr ndeida kor ian ndeacrenanmo, par mbuŋa aca kɨpca, ndori kotacna moca. Aca, mina kɨprina mbatca mina korniŋmo ŋgoaeb ŋgabuk, ŋgabukca, korniŋa maica, bururunan toca mori. ");
INSERT INTO gai_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10","Na Saimonna aiŋ kabea morena ramtaɨrapa, Sebedina nuocniŋ, Iemisapa Ion, mina an ŋgoaeb mbatca, ŋgep ŋgoreac maŋgepat. Ri, Saimonna ma taŋga Iesusna or kɨtɨmma paŋan ramtukca aindopatna “Kacoot, u aukmo tɨkcarica u taŋ. Aku ramoot laŋa wanaiŋ.” Aindopri, Iesusa Saimonmo aindopca, “U rugutta kai mo teac. Ŋgaua una aiŋ, u ŋgoaeb aŋgɨrena ramoot. Mandeaca una aiŋ, u meikramtaɨr aŋgɨnande.” ");
INSERT INTO gai_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Aindopacarica mina kor rapac ombca gaca, reik ruŋkicarica, mina mana raŋgaica manap mataŋri. ");
INSERT INTO gai_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Iesusa auŋ ian ndeacri, ramoot ianna, mana tikca, roumb lepa moa ŋgocraica, ma Iesusmo watca, mana outta tiacarpaik ŋgirikca meraca, aemaŋmaŋap aindopatna, “Kacoot, u ndo toŋgo te, aukmo mo laŋa moa aku Raraŋ Aetaniacna lamnɨac ŋgoutmo rat laŋ ndaruna.” ");
INSERT INTO gai_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Aindopri Iesusa ndona parmo mana tik ŋgutiŋga aindopatna, “Aku toŋgorina. U laŋa mo.” Aindopri, an roumb andu mamairi. ");
INSERT INTO gai_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Na ma an ramootmo kam gargar mbuŋa aindopatna, “U taŋca, gan aiŋ aku una moapeknan, ramoot ianmo kai mbop teac. Kari ŋgoin. U taŋca, ndona tik niŋgikmo taup ndamootta wandac te, Moses mboprina kirara gɨmbamba moca, wandac te, meikramtaɨra lamŋinande, una tikca mawandoŋairi.” ");
INSERT INTO gai_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Karica Iesusa an ramootta morina reikta kambca, tawina tamtamma taŋga mamairi. Na mina an kam mbaraca, ainda moca meikramtaɨra wɨt aniaca kɨpca mana kam mbarac te, ma mina roumbbeba moi laŋa mo maina moca. ");
INSERT INTO gai_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Karica memetmbaca ma gainda morena, ma mbendeina mo te, ma taup ianna, ramtaɨr kocortanna taŋga, anna tɨkca, ma mbendeinandet. ");
INSERT INTO gai_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Oit ianna Iesusa meikramtaɨrmo ripti neaŋga eacri, Iudana ririptina tɨpemb wandik tamŋirena ramtaɨrapa Parisiarapa, mina mon Galili inikna auŋembapa Ierusalemapa Iudiana inikna auŋemb ndeidap, mina mbiraca eacri, Kacootna gargara Iesusap eacri, ma meikramtaɨrta roumbbebca moa laiŋga moatna. ");
INSERT INTO gai_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ainda moca ramtaɨr ndeida ramoot ianna gagrir menacarica eacrenanmo, mina mamo bar mbuŋ naaŋgɨa kɨpca, mamo kac inik naaŋgɨ mbukca, Iesusna outta tɨkna moca, ");
INSERT INTO gai_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","watrinanna, kac inikca meikramtaɨra mɨnna tɨkcarica eacri, mina man aŋgɨ mbukna taupembta orea tambacarica, mina mamo mana barap aŋgɨra gaca kac kopika tɨkca, kopik walanca, mana barmo ŋgaɨr ikca, an ndiŋa meikramtaɨr tambatta kacrepca irikri, mina manmo aŋgɨa Iesusna kɨtɨm matɨkri. ");
INSERT INTO gai_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ma an ramtaɨrmo watrinanna mina rɨpacrina, mbatca ma aindopatna, “Aukna ramoot, una tɨpemb ŋgorikta makukara aku moa kecamacariri.” ");
INSERT INTO gai_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Aindopri, ririptina tɨpemb wandik tamŋirena ramtaɨrapa Parisiarap, mina ndorimo kekelamun keca aindopca, “Anna titna ramoot, ma Raraŋ Aetaniacna taup aŋgɨna morena? Ramoot ianna tɨpemb ŋgorikta makukara mo kecarina mɨnna wanaiŋ. Anna Raraŋ Aetaniacna ndo kabena aiŋ!” ");
INSERT INTO gai_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Mina aindopri, Iesusa mina iroara atuna ndamŋica, ma mina kamma gainda rutirina, “Kaina moca ne an iro aŋgɨrina? ");
INSERT INTO gai_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Titna kamma ndo aukmo wetwet ndopit an kam ki, ‘U ŋgepca taŋ,’ co, gan kam, ‘Aku una tɨpemb ŋgorikta makukara moa kecamacariri’? ");
INSERT INTO gai_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Aku toŋgorina ne gaind ndamŋi, Ramootna Nuoc ma gan tiacarpaikna gargara ma mɨn ŋgoin, ma tɨpemb ŋgorikta makukara mo kecarina mɨn.” Aintik Iesusa ma an gagrir menaca eacrena ramootmo aindopatna, “Aku umo aindopnande, una meraca eacrena barnan aŋgɨca, ndona kaca taŋ.” ");
INSERT INTO gai_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Aindopri an gagrir menaca eacrena ramootta, meikramtaɨr wɨt aniacna lamnikmo, anduna ŋgepca wɨtɨkca, ndona bar aŋgɨca Raraŋ Aetaniacna ia aŋgɨa ŋgepcarica, nakac mataŋri. ");
INSERT INTO gai_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Na mina muruŋ an reac mbatca rugdar moa tamtam ŋgoin ndamŋiatna, na mina nikinik iroara moca ŋgepca Raraŋ Aetaniacna gargar mbatca mana i aŋgɨa ŋgepca, aindopatna, “Mandeaca aia reac dam ŋgam ŋgoin laruapeknan mawatri.” ");
INSERT INTO gai_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Iŋmbaia Iesusa annan taŋgatnanna, kitcartukar iurena ramoot ianna watca, mana ia Liwai. Ma kituknduk aŋgɨrena taupca mbiraca eacri, Iesusa mamo aindopatna, “U aukna iŋa raŋgai.” ");
INSERT INTO gai_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Aindopri ma ŋgepca reik tɨkcariatke, Iesusna iŋmbai mataŋgat. ");
INSERT INTO gai_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Karica ma Iesusap mbiracna moca, amna reac aniac ianna, ndona kac tɨkca, moa maica, kitcartukar iurena ramtaɨr wɨtapa ramtaɨr ndeidap. Mina maniŋap mbiraca ambatke, ");
INSERT INTO gai_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Parisiarapa tɨpemb wandik tamŋirena ramtaɨrap, mina an Parisina wiwitnan, mina Iesusna iŋa raŋgairena ramtaɨrmo, kekelamun irikca, aindopatna, “Kaina moca ne pukapa amna reaca an kitcartukar iurena ramtaɨrapa tɨpemb ŋgorikca morena ramtaɨrap ambapekna?” ");
INSERT INTO gai_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Aindopri, Iesusa mina kam rutica aindopatna, “Roumbbeb kocorta meikramtaɨr, mina pitir gagamna ramoot ndambuŋa mba taŋitndai. Wanaiŋ ŋgoin. Roumbbebta meikramtaɨra ndori tiŋgikca pitir gagam ndambuŋa taŋnande.” ");
INSERT INTO gai_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Karica ma aindopatna, “Aku gan nakɨprinanna, aku mba kɨpca meikramtaɨr wandoikca aci mina iroar inkar ŋgetrikinake, mba kɨpri, wanaiŋ ŋgoin. Aku gan nakɨprinan, aku an tɨpemb ŋgorikta makukara morena meikramtaɨr aci kɨpca mina iroar inkar ŋgetrikina kɨprina.” ");
INSERT INTO gai_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","An ramtaɨra mina Iesusmo gaind mac mambopat, “Memetmbaca Ionna iŋa raŋgairena ramtaɨra gagamna reac niŋgikmo warirac te, mina mbendeiraŋnande. An tɨpna kirara Parisinanta iŋa raŋgairena ramtaɨr toca ainda morenan, na una iŋa raŋgairena ramtaɨra wanaiŋ. Mina pukapa amna reac ambrena.” ");
INSERT INTO gai_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Aindopri Iesusa mimo aindopatna, “Ramootta meac laŋgona mo te, ne an ramootna kamkabearmo mbopca ma minap eacraŋ te, mina amna reacna wariracit ki? ");
INSERT INTO gai_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Towanaiŋ. Iŋmbai ecte, mina mamo aŋgɨri taŋgacarica, mana kamkabearapmo eac ŋgocor ndeac te. An mɨn, mina amna reacna warirac tɨknande.” ");
INSERT INTO gai_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Iesusa mimo kam roor mbuŋa aindopatna, “Ramoot ianna mba tik ŋgapaoc ŋgam aŋgɨca, waŋmbai titaca tik ŋgapaoc bagarna urupa mba tɨki iukitndai. Ma ainda mo te, ma ŋgammbaimo moca ma ŋgocrainandet, na an iŋit waŋ ŋgammo bagarap tɨki wat te, ma laŋa mba watitndai.” ");
INSERT INTO gai_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Aindopacarica ma aindopatna, “Ramoot ianna mba memena iŋit bagarmo wainna puk ŋgammo mba duduitndai. Ma ainda mo te, ma putu taŋca titaca pukca ruŋki taŋcarinande. U meme iŋit bagar anna mo ŋgocrainande. ");
INSERT INTO gai_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ainda wanaiŋ! U meme iŋit ŋgam aŋgɨca, wain puk ŋgamna puk dudu te, ma mba titacitndai. ");
INSERT INTO gai_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ramootta memetmbaca wain bagar ambrenan, ma mba wain puk ŋgamma mba toŋgoitndai. Ma aindopnande, ‘Wain bagara, laŋ.’” ");
INSERT INTO gai_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Karica Wɨktɨtɨkna Ra ianna, Iesusa witna warɨŋembta inikca anna mbukca taŋri. Mana iŋa raŋgairena ramtaɨra, witna lour aŋgɨra ndorita paɨr puŋga mumuria lape irikri, mina lour aŋgɨrca ambri. ");
INSERT INTO gai_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ainda moca Parisina ramtaɨr ndeida an mbatca kekelamun irikca aindopatna, “Kaina moca ne an tɨp kirara moapekna, Wɨktɨtɨkna Ra meikramtaɨrmo an tɨpna kirara mo narica mboprina. Na an tɨpna kirara anna wandɨk.” ");
INSERT INTO gai_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Aindopri Iesusa an mina mboprina kam rutica aindopatna, “Eee, ne Dewitta morina reacna nininia ne Raraŋ Aetaniacna timbigta kapna inikca mba watri, a? Aku ande an mɨnɨŋna Dewitapa mana ramtaɨrap, mina nikembwataica eacrina kam ndoprina. ");
INSERT INTO gai_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ri, Dewitta taŋga Raraŋ Aetaniacna Ndamna inikca mbukca, Raraŋ Aetaniacna outta tɨkca eacrina tapac wandɨk aŋgɨca, kataca ndo ambatke, ndoap eacrena ramtaɨr motoco neaŋga, mina maammbat. Na an tɨpna kirara ramoot wanaiŋa mba morenanna. An tapaca wandɨk. Taup ndamtaɨra ndori ambrena. Ne mba an kamna nininia mba watatke, a?” ");
INSERT INTO gai_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Iesusa aindopacarica ma gaind mac mboprina, “Ramootna Nuoc, ma Wɨktɨtɨkna Rana Kacoot.” ");
INSERT INTO gai_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Karica kabena Wɨktɨtɨkna Ra mbuŋa Iesusa mina Iudananta mimitpac aŋgɨrena kac inikca mbukca meikramtaɨrmo mimitpac neaŋri, ramoot ianna par kumbut umbai menaca, ma an ndeacri. ");
INSERT INTO gai_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ainda moca tɨpemb wandik tamŋirena ramtaɨrapa Parisiarap, mina Iesusmo Wɨktɨtɨkna Ramo meikramtaɨrmo moi laŋa moit ki, wanaiŋ. Mina Iesusmo ainda moeknanna moca anna ŋginaŋ mbatri. Ma ainda mo te, mina mamo ritri waparacna taupembta oreri. ");
INSERT INTO gai_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Na Iesusa mina iroarmo atuna ndamŋica ma an ramootta par kumbut umbai menacarica eacrena ramootmo aindopatna, “U ŋgepca gan meikramtaɨr wɨtta lamnik taru wɨtɨk.” Aindopri ma ŋgepca taŋga wɨtɨkri. ");
INSERT INTO gai_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Iesusa mimo aindopatna, “Aku nemo gainda diginandet. Aia Wɨktɨtɨkna Ramo tɨp laŋa moit ki, co aia tɨp ŋgoreaca moit? Ki, aia meikramtaɨrmo opotaca moit ki, co aia meikramtaɨrmo mo ŋgocrait?” ");
INSERT INTO gai_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Karica Iesusa meikramtaɨr muruŋmo watta korereca maica, ma an ramootmo aindopatna, “U ndona parmo lotai.” Aindopatke, ma ndona parmo lotaiatke, mana para laŋ mamoat. ");
INSERT INTO gai_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ri, tɨpemb wandik tamŋina ramtaɨrapa Parisina ramtaɨrap mina an mbatca, nikembkatca ŋgocraica, ndori puŋga aindopatna, “Aia mamo titoca moit?” ");
INSERT INTO gai_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","An mɨn mbuŋna ra ianna Iesusa mbendeina moca ma taŋga, takur tamuŋ nagaca. An mouŋ rocotta ma Raraŋ Aetaniacmo mbendeia taŋ, taŋga. Maica auŋ raruca ra gacatke, ");
INSERT INTO gai_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","ma ndona iŋa raŋgairena ramtaɨrmo aca kɨpca ndona aiŋa monanpaikmo parniŋapa, mbut mbuniŋna ramtaɨrta mɨnpaika larapaca, ma mimo up aŋgɨrena ramtaɨrta i maneaŋgat. ");
INSERT INTO gai_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Na mina irembca ianna Saimon, Iesusa mamo i Pita matɨkat, Andru motoco manduat. Ma Saimonna lap. Na ianna Iemis, na ianna Ion, na ianna Pilip, na ianna Batolomiu. ");
INSERT INTO gai_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Na ianna Matiu, na ianna Tomas, na ianna Iemis, ma Alpiusna nuoc. Na Saimon mina mamo Selotna wiwitna ramoot ian ŋgacrena. ");
INSERT INTO gai_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Na Iudas ma Iemisna nuoc. Na ianna Iudas Iskariot, ande an ramootta, iŋmbaia ma Iesusmo puŋnaŋgepta para neaŋnande. ");
INSERT INTO gai_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Karica Iesusa ndona iŋa raŋgairena ramtaɨrapmo takur tamuŋnan mac nda irikca. Na mina taŋga tiacar wandoikpaika wɨtɨkri. Na mana raŋgairena meikramtaɨr wɨt aniacapa, Iudia inikna auŋembta meikramtaɨrapa, Ierusalemnanapa, Tairapa Saidonna maŋara rambuŋaia eacrena meikramtaɨrap, mina muruŋ ŋgoin mitoca kɨpca eacri. ");
INSERT INTO gai_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Na mina ndorimo Iesusna kam mbarac te, ma mina roumbbebmo, moi laiŋga mona moca, anna nakɨpca eacri. Na mina meikramtaɨr ndeida, ŋerŋgaur ŋgorikca moa ŋgocraica eacrenanna, Iesusa mimo moa laiŋ mamori. ");
INSERT INTO gai_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Na an gargar aniaca ndo Iesus ndaruca eacreke, ainda moca roumbbebta meikramtaɨr wɨt aniaca, ndorimo manmo towai pipikna moca. An gargara meikramtaɨra anna pipik te, mina laiŋga monande. ");
INSERT INTO gai_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Karica Iesusa ndona iŋa raŋgairena ramtaɨrmo watta taŋga ma mimo aindopatna, “Ndaekpembca eacrena meikramtaɨra ne toŋtoŋgarap eac. Ne toco, Raraŋ Aetaniacna bubuocnan. ");
INSERT INTO gai_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Ne mandaibinna nikembwataica eacrenan, ne toco toŋtoŋgarap eac, iŋmbaia ne ammi mɨnna tɨknande. “Ne mandaibinna aerenan, ne toca toŋtoŋgarap eac, iŋmbaia ne laroŋnande. ");
INSERT INTO gai_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Ne iŋmbaia mandaibinna Ramootna Nuoca raŋgai te, mina nikembkatca nemo mba toŋgoitndai, nemo kaega moca kam ŋgoreac ndop te, nena imo pepere ŋgocrainandet. Mina ainda mo te, ne toŋtoŋgarap eac. ");
INSERT INTO gai_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Na atu ŋgoinna nena nicara ainta tɨp ŋgoreacna kirarira mina rambca morina ramtaɨrmo an tɨp kirara moatna. Ne warac! Mina nemo ainta reikca mo te, ne toŋgo werei, nena opoik bagaraniaca Raraŋ Aetaniacna tamuŋna auŋ malambireke. ");
INSERT INTO gai_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Ne kɨtcaɨrapa reik wɨtna ramtaɨr, nen pembta kadmai. Ne ande ndorita reikta toŋtoŋa ne gan tiacarpaikca tɨkca aŋgɨra mamairi. ");
INSERT INTO gai_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Ne mandaibinna mandeaca amba gautpemb putuca eacrenan, nen pembta kadmai, iŋmbaia ne nik watainande. “Ne mandaia mandeaca toŋgoca laroŋrenan, nen pembta kadmai, iŋmbaia ne kadmaica aenande. ");
INSERT INTO gai_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ne meikramtaɨra muruŋa una imo aŋgɨ ŋgep te, nen pembta kadmai. Atua nena nicara an tɨpemb kirarira, mina paparuna rambca morina ramtaɨrmo an tɨp kirara morina.” ");
INSERT INTO gai_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Iesusa gaind ŋgoin mac mboprina, “Ne meikramtaɨr, aukna moca kamb mbaraca raŋgairena, nemo makukar neaŋga taŋrena meikramtaɨrmo ne mimo toco matŋi. Na mina nemo kaega moca, titikca mo te, ne mimo tɨp laŋ, niŋgikca mo. ");
INSERT INTO gai_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Na mandaia Raraŋ Aetaniacmo digica nemo tɨp ŋgoreaca mo te, ne Raraŋ Aetaniacmo digica ma mana nakadmai, na meikramtaɨra umo tɨp ŋgoreaca morenan u minmo mbendei. ");
INSERT INTO gai_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Na ramoot ian ma una kapgɨn ŋap te, u mac urirac te, ma embaia mac ap. Na ramoot ianna una tik ŋgapaoc aniac aŋgɨ te, u tik ŋgapaoc teker motoco watcarica ma aŋgɨri taŋ. ");
INSERT INTO gai_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Meikramtaɨra una reik aŋgɨna digi te, u minmo aŋgɨri neaŋ. Na ramoot ianna ma una reik aŋgɨ te, u an reik mac nda aŋgɨnake, kai digi teac. ");
INSERT INTO gai_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Na an tɨpemb kirarir muruŋa ne toŋgorenan, kabena meikramtaɨra nenmo morenanna, an tɨpna kirarir ŋgoinna ne min motocmo mo. ");
INSERT INTO gai_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Na ne ndorica matŋirena meikramtaɨr tiŋgikca matŋi te, mandaia ndo aindopit, ‘Ne meikramtaɨr laiŋ’? Na tɨpemb ŋgorikta makukara morena meikramtaɨr, mitoco meikramtaɨra minmo matŋirenanmo, mitoco minmo matŋirena. ");
INSERT INTO gai_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Na ne meikramtaɨra nemo tɨpemb laiŋga morena meikramtaɨr tiŋgikmo, tɨp laŋa mo te, mandaia ndo aindopit, ‘Ne meikramtaɨr laiŋ’? Tɨp ŋgoreac morena meikramtaɨr mitoca ainta kirara morena. ");
INSERT INTO gai_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ne meikramtaɨrmo reik neaŋ te, ne gainda kai lamŋica neaŋ teac. Mina ainanmo mac nda rutinande, ne ainda mo te, mandaia ndo aindopit, ‘Ne meikramtaɨr laiŋ’? Tɨpemb ŋgorikca morena meikramtaɨr, mitoca ndorita reikmo meikramtaɨrmo neaŋgacarica. Iŋmbai, mina lamŋinande, mina anna ruruti mac nda aŋgɨnande. ");
INSERT INTO gai_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Na ne ndorita puŋnaŋgepmo matŋi. Te, mimo tɨp laŋa mo. Ne meikramtaɨrmo reik neaŋgacarica anna ruruti mac nda aŋgɨnake, kai lamŋi teac. Ne ainda mo te, iŋmbai, ne anna opoik bagaraniac aŋgɨ te, ne tamuŋna mombonik koind tarunande. Aintik Raraŋ Aetaniacmo kam laŋ neaŋ ŋgocorta meikramtaɨrapa, meikramtaɨr ŋgorikcap, ma min motocmo tɨp kirar laŋa morena. ");
INSERT INTO gai_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Nena Aetna ndiarna tɨpna kirara, meikramtaɨr motocmo ainta ndiarna tɨpna kirara mo.” ");
INSERT INTO gai_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Na an kam maica Iesusa gan kam mac mboprina, “Ne meikramtaɨrta tɨpemb kirarira kai watca, mimo gainda kai mbop teac, ‘Mina meikramtaɨr ŋgorik.’ Moca Raraŋ Aetaniaca nemo an tɨp kirar kabea nemo toco mo nari. Ne meikramtaɨrta tɨpemb kirarir ŋgorikta makukarmo mo kecari te, Raraŋ Aetaniac toco nena tɨpemb ŋgorikta makukara ma mo kecarinande. ");
INSERT INTO gai_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ne ndorita reikmo, kabena meikramtaɨrmo aŋgɨri neaŋ te, Raraŋ Aetaniaca ma nena reikmo ma rutinande. Na ma nenanmo biŋ laŋa matau moca, ma rui gaca upembca tɨk mai te, ma mac rɨŋndɨŋi irikca mac rui, rui reik annda gaci upemb koinda tɨkca roumbmbaiap ruŋki te, ma nenmo neaŋnande. Na ne kabena meikramtaɨra biŋairina mɨn, an biŋna mɨn, Raraŋ Aetaniac, ma nena an biŋna mɨn, ma an mɨn mac nda rutinande.” ");
INSERT INTO gai_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ri, Iesusa mimo kabena kam roor ianna gaindoprina, “Lamnɨac ŋgoreacna ramoot ian, ma taŋga lamnɨac ŋgoreac ianna par ŋgutiŋga manmo taup wandacna mɨn ki? Towanaiŋ. Ma ainda mo te, maniŋa taŋca muruŋniŋa au ŋgiriknande.” ");
INSERT INTO gai_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Aindopacarica ma gaindoprina, “Ripti aŋgɨrena ramootta ma ndona riripti neaŋrena ramootmo tamuŋmbaia wanaiŋ. Ma mbiraca ndona ririptia matau aŋgɨri mai te, karica ma ndona ririptina ramootna kirar toc ndarunande. ");
INSERT INTO gai_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“U titoca tɨkca una kakana lamnɨacna gigiratta watapeke, na u ndona lamnɨacna inikca wawararina ik tɨp aniac ianna mba lamŋiapeke? ");
INSERT INTO gai_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","U ndona lamnɨac ndeacrena ik tɨp aniacmo, u wat ŋgocor, u tida watca u ndona kakamo mbopnande, ‘Kaka, aku una lamnɨacna gigiratta moa kecamariri’? U paparuna ramoot ŋgoin. Outta u ndona lamnɨac ndeacrena ik tɨp aniacmo, u mo kecarica lamnɨaca mataui wat te, iŋmbaia u ndona kakana lamnɨac ndeacrena gigiratta watca mo kecarinande.” ");
INSERT INTO gai_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Iesusa gaind mac mboprina, “Ik laŋ ma mba amna reac ŋgoreaca mba eritndai. Anna kirar, ik ŋgoreac toco amna reac laŋa mba eritndai. ");
INSERT INTO gai_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ramtaɨra ndorita ikna gagam pac wati, garaca mina ndori lamŋinande. An ikca ma laŋ, co, ma ŋgoreac. Ramtaɨra mba lacarta ŋgatɨkca ikna loura anna tɨkca mba aŋgɨritndai. An tɨpna kirara, mina mba wainna loura lacarta ŋgatɨkca tɨkca mba aŋgɨritndai. ");
INSERT INTO gai_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ramoot laŋ, ma iro wɨt laiŋgap eacrena. Aintik ma tɨp laŋa morena. An tɨpna kirara ramoot ŋgoreac toco mana iroara ŋgorik wɨtap eacrena. Aintik ma tɨp ŋgoreaca morena. Ainta iroara nikinikca mɨn ndeacreke, up ndiŋ ndarurena.” ");
INSERT INTO gai_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Iesusa gaind mac mbopatna, “Kaina moca, ne aukmo gaind ŋgacrena, ‘Kacoot, Kacoot,’ ne aukna kam mbaraca raŋgai ŋgocor? ");
INSERT INTO gai_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","U mandaia auk ndambuŋ nakɨpca aukna kam mbaraca raŋgai te, aku nemo ainta ramootna tɨpna kirara, aku nemo mbopnande. ");
INSERT INTO gai_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Gan ramoot, ma ramoot ianna kaca mona moek toc. Out ŋgoinna ma watur tambatmo auremb roctira iaca maica auremb mbitda waturap, an nambatta kac paŋpaiŋ ŋgoinna moca, wawaraca laemb laruca pukapa wat aniacapa laclaocap kɨpca rapac te, ma witki irikca ŋgocraina mɨnna wanaiŋ, ma paŋpaiŋ ŋgoin. ");
INSERT INTO gai_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","U mandaia aukna kamma waraca raŋgai ŋgocor, anna ma ramootta kacmo tiacarpaik wanaiŋmo, aurembca mbatca iaca keca morina kacna kirar. Iŋmbai, watapa puk kɨpca rapac te, ma mba eacitndai. Ma tawina witki irikca kocnai ŋgocrainande.” ");
INSERT INTO gai_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Karica Iesusa meikramtaɨrmo kam ndopca waraca maica. Karica ma Kapaneamma taŋga laruca. ");
INSERT INTO gai_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Romna lapoca ruŋrena ramoot paŋan ianna ma eacri. Mana lapoca ruŋrena ramtaɨra 100na mɨn. Ma ndona tuomna aiŋ kamaindna ramoot ianap. Ma mana aiŋna outmbaica taŋrena ramoot ian, ma mana toŋtoŋ ŋgoinna moca eacrinanna, ma roumbca moca mbac tarkica eacri. ");
INSERT INTO gai_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Na ma waracatnanna Iesus kɨprina kam mbaraca. Karica ma Iudananta inikna ramtaɨr anik ndeidmo mbagɨrica, ma minmo aindopatna, “Taŋca, Iesusmo digi mbopca, ma kɨp te, ma aukna tuomna aiŋ kamaindna ramootna roumbmo, mo laŋa mona.” ");
INSERT INTO gai_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Mimo mbagɨrica mina taŋga larua, Iesus ndambuŋa, mamo kam gargar mbuŋa aindopatna, “An lapoca ruŋrena ramoot paŋanna, ma ramoot laŋ ŋgoin. U mamo otacna mɨn ki? ");
INSERT INTO gai_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ma aimo Iudana meikramtaɨrmo toŋtoŋ ŋgoinna moca, ma aina Iudananta mimitpac aŋgɨrena kaca otaca morina.” ");
INSERT INTO gai_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Mina Iesusmo aindopacarica. Ma minap taŋga lapoca ruŋrena ramoot paŋanna kac ndambuŋa rambuŋairi, an lapoca ruŋrena ramoot paŋanna ndona aikndamtaɨr ndeidmo mbagɨrica kɨpca, Iesusmo gaindopna moca, “Kacoot! U irembta ramoot paŋan aniac. U kai aiŋ aniaca, kai mo teac. U aukna kacnɨm nakɨpna, anna laŋa wanaiŋ. Aku irembta ramoot paŋanna wanaiŋ. ");
INSERT INTO gai_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ainda moca auk toco, aku u ndambuŋ nakɨpna, towanaiŋ. U an niŋgikca tɨkca, u kam niŋgik ndop te, aukna tuomna aiŋ kamaindna ramootna roumbca laŋa monande. ");
INSERT INTO gai_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Na auk toco, aku iapna ramootna kaŋgauk ndeacrena. Ma ndo aukmo aiŋ neaŋ te, aku monande. Ainda moca aku ndona lapoca ruŋrena ramoot ianmo aindop te, ‘U taŋ!’ aindop te, ma taŋnandet. Na ian motoco aku aindop te, ‘U kɨp!’ aindop te, ma kɨpnandet. Na aku ndona tuomna aiŋ kamaindna ramootmo aindop te, ‘U gan aiŋa mo!’ aindop te, ma taŋca an aiŋa monande.” ");
INSERT INTO gai_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Lapoca ruŋrena ramoot paŋanna mbopatna kambca, Iesusa an kamma waraca, mana iro inikca tamtam ŋgoin ndamŋica, ma kumbakeca, ndona raŋgairena meikramtaɨr wɨt aniacmo, ma aindopatna, “Aku nemo gaindopnande, aku an Israelna wiwitna meacramootna, ianmo ainta rɨtɨpac gargar ianna wat ŋgocor.” ");
INSERT INTO gai_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Iesusa aindopacarica an lapoca ruŋrena ramoot paŋanna mbagɨrica kɨprina ramtaɨra mac nda taŋga, mina watrinanna mana tuomna aiŋ kamaindna ramootta, kaca tɨkca laŋ mamori. ");
INSERT INTO gai_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Na iŋmbaia Iesusapa mana iŋa raŋgairena ramtaɨrapa, meikramtaɨr wɨt aniac ndeidap, mina manap taŋga auŋ ian ndaruca. An auŋna ia Nain. ");
INSERT INTO gai_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ma maica an auŋ kam ndaruatke. An auŋnanta ramoot ianna menaca, mina mana waɨrap aŋgɨrca auŋ kam ndaruatke. Iesusa mimo anna tɨkca ndauprikica. An waɨrna aemma, ma nuoc kabe ŋgoinap. Na mana kaŋgait toco, atuna menaca, ma meac konim ndeacri. An auŋna meikramtaɨr wɨt aniaca mina an meac konimap kɨpri. ");
INSERT INTO gai_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Na Kacootta an meaca watca, ma mana moca nikinik iro kakadmaiap tik, ma mamo aindopatna, “U kai ae teac.” ");
INSERT INTO gai_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ma aindopacarica ma taŋga rambuŋaica, an waɨrna barmo utiŋri, an bar aŋgɨra taŋrena ramtaɨra mina wɨtɨkri. Ma gaindopatna, “Nuoc ŋgam! Aku umo aindoprina, u ŋgep!” ");
INSERT INTO gai_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Aindopri an menaca eacrena ramootta anduna naŋgepca mbiraca ma kam ndopri. Na Iesusa mamo mana aemmo mac nda maneaŋri. ");
INSERT INTO gai_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Na meikramtaɨra tamuŋna Raraŋ Aetaniacna gargara mina anna watca, mina iroar inkara mananambiat, ainda moca mina mana i aŋgɨra ŋgepca aindopatna, “Ramma morena ramoot aniac ianna, gade, aina kɨdrɨk malaruca.” Ainda moca mina aindopatna, “Tamuŋna Raraŋ Aetaniaca ma gade makɨpri, ndona meikramtaɨr ŋgotacna moca.” ");
INSERT INTO gai_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Karica meikramtaɨra Iudia inikna auŋembapa, raekmbai ndeacrena auŋembca, mbukca mina anna auŋembca tamtamma taŋri, Iesusna nininia moa taŋrina. ");
INSERT INTO gai_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Karica Ionna iŋa raŋgairena ramtaɨra, Ionmo an Iesusna reikta nininia, mamo anna moatke. ");
INSERT INTO gai_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ma an kam mbaraca ma ndona iŋa raŋgairena ramootniŋmo aca kɨpca maniŋmo aindopatna, “Oŋgo taŋi Iesus ndambuŋ ndaruca, mamo gainda digi, ‘U ande Raraŋ Aetaniac babuca mbagɨrica kɨprina ramoot ki? Co aia kabena ramootna mac lambiit?’” ");
INSERT INTO gai_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Maniŋmo aindopna moca, maniŋmo mandaca, maniŋa taŋga, Iesus ndambuŋ ndaruca, mamo gaindopatna, “Aŋga kɨtac puk neaŋrena ramoot Ion mandaca kɨprina. Ma umo gainda digirina, ‘U gade Raraŋ Aetaniac babuca mbagɨrica kɨprina ramoot ki? Co, aia kabena ramootna mac lambiit?’” ");
INSERT INTO gai_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Na an mɨn mbuŋa meikramtaɨra ainta roumbbeb ŋgorikcap eacrenanna, Iesusa minmo moca, mina roumbbeba laiŋ mamori. Na ndeida, ŋerŋgaur ŋgorikcap eacrenanmo, ma moca mina laiŋga mori. Na lamnik ŋgorik motocmo moa laiŋ mamori. ");
INSERT INTO gai_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Karica Ionna mbagɨrica, kɨprina ramootniŋmo Iesusa aindopatna, “Oŋgo taŋca Ionmo an reikca mandeac oŋgo watapeke, waracapekna reikta kamma mamo aindop, ‘Lamnik ŋgoriktan, mina lamnikca laiŋga moca mina mac mawatreke. Ri, our ŋgoriktanna mina oura laiŋga moca, mina mataŋreke, na roumb lepa moa ŋgocrai eacrenanna, mina tikembca mataua laiŋ macariri. Na kour rɨkdaca eacrenanna, mina koura laiŋga moca mina kambca mawaracreke. Na menaca eacrenanmo, ma mac nda moca mina maŋgepri. Na reik kocorta meikramtaɨr ndaekpemb, mina kam wembaŋ laŋa maaŋgɨri.’ ");
INSERT INTO gai_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Aintik meikramtaɨra auk morina reik mbatca, mina rɨtɨpaikca mba irikitndai, ainda moca mina toŋtoŋgar koind.” ");
INSERT INTO gai_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Karica Ionna mandaca kam aŋgɨna nakɨprina ramootniŋa mac nda taŋgatke, Iesusa meikramtaɨrmo Ionna ninia moca aindopatna, “Ne ramtaɨr kocorta taupca taŋca, ne kaina reac mbatna taŋrena? Ne anna taŋca tukara watta moca numairenanna watna taŋre ki? Ainda wanaiŋ. ");
INSERT INTO gai_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ne ramoot ianna lamboi laŋ, laŋ tɨkrena ramootta watna taŋre ki? Ainda wanaiŋ. Na meikramtaɨra lamboir laiŋga ndorita tikembmo aocrenanapa reik laiŋapnan, ainta meikramtaɨra mina gagrirta ramtaɨr paŋaindta kaiknimbca eacrena. ");
INSERT INTO gai_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Na ne kai ŋgoin mbatna taŋre? Ne ramma morena ramoot ianna mbatna taŋre ki, a? Ore, man niŋgik, na aku nemo aindopnande. An ramma morena ramoot an, ma rambca morena ramtaɨr ndeidta aiŋirmo, ma mimo tamuŋmbai ŋgoin. ");
INSERT INTO gai_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","An ramoot anmo Raraŋ Aetaniacna timbigta kapca mana nininia morina, ‘Ne warac. Aku ramoot ianmo mbagɨrica ma outta taŋca aukna kam ndop te. Ma una taupembca ma outta kocronande.’ ");
INSERT INTO gai_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Aku nemo gaindopnande, Ion, mana ia gan tiacarpaikna meikramtaɨrmo tamuŋmbai ŋgoin. Ainda moca ramootta Raraŋ Aetaniacna bubuocna kaŋgaukmo mooŋnuoc teker toc ndeacrenan, ma Ionmo tamuŋmbai ŋgoin ndeacrena.” ");
INSERT INTO gai_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Karica meikramtaɨrapa kitcartukar iurena ramtaɨra, mitoca Iesusna kam mbaraca maica, mina gaindopatna, “Raraŋ Aetaniacna tɨp kirara wandoŋ ŋgoin.” Mina aindopatna, ainda moca mina taŋga Ionna par mbuŋa kɨtac puk aŋgɨrina. ");
INSERT INTO gai_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Karica Parisina ramtaɨrapa tɨpemb wandik tamŋirena ramtaɨrap, mina ianna Ionna par mbuŋa kɨtac pukca mba aŋgɨratke. Ainda moca mina Raraŋ Aetaniaca, mimo wandacapekna taup wandoŋ laŋmo mina iŋ neaŋga macariri. ");
INSERT INTO gai_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Karica Iesusa gaind mac mboprina, “Aku mandeaca gan mɨnna meikramtaɨr morena tɨpna kirara, anna, kam roora aku titna keit? Mina titna meikramtaɨr koind? ");
INSERT INTO gai_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Mina gainda morena tɨp kirara mina taŋga, mombonik morena tɨp kirara meikramtaɨra mbik tɨkca punirena taupca tɨkca, mombonikca an ndeacrinanmo aca aindopatna, ‘Aia nemo toŋtoŋgarta ŋapar kumbri, ne mba weri. Na aia nemo kakadmaina ŋapar kumbri, ne mba aeri.’” ");
INSERT INTO gai_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Karica Iesusa gaind mac mboprina, “Kɨtac puk neaŋrena ramoot Ion, ma kɨpca ma mba tapaca mba ambrenanna, ma mba wain pukca mba ambrenanna. Ma ainda moatke, ne mamo gaind mambopat, ‘Ŋeroŋ ŋgoreaca manap maeacreke.’ ");
INSERT INTO gai_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Na mandeaca Ramootna Nuoc kɨpca, ma wainapa tapacap ambapeke, ne mamo aindopapekna, ‘Watwa, ma amta reik anikapa wain puk anik ambapekna ramoot. Ainta ramootta ma kitcartukar iurena ramtaɨrapa, tɨpemb ŋgorikta makukarap morena meikramtaɨrta aikndamoot,’ ne ndori puŋga ne aindoprina. ");
INSERT INTO gai_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Karica Raraŋ Aetaniacna landamŋina kam mbaracrina meikramtaɨr, mina ndori, aimo wandacrina, an Raraŋ Aetaniacna landamŋi, anna reac gidik ŋgoin.” ");
INSERT INTO gai_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Karica Parisina ramoot ianna, mana ia Saimon, ma Iesusmo ndona kaca amna ndopca, Iesusa taŋga larua, an Parisina kac nagaca, manap amna tɨp kirara raŋgaica mbiracatke. ");
INSERT INTO gai_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Meacramootna kaŋtertaapna tɨpca morena meac ianna an auŋnan, ma Iesusmo an Parisina kaca tɨki, amna taŋrina kam mbaraca. Ainda moca ma kituknduk aniac mbuŋ ŋgoikrena tabaɨr tiamma iŋpai gargar laŋna tiamma mina waut mbuŋa moca, tabaɨra anna duduca eacrena tabaɨrap aŋgɨrca kɨpca gaca. ");
INSERT INTO gai_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ma taŋga Iesusna ortɨmbɨkniŋna kɨtɨmma wɨtɨkca eacri, aeri. Ainda moca mana lamnɨacna timbca, Iesusna ortɨmbɨkniŋ nambat ŋgirikri. Ma ndona paŋanna lakoar puŋga, Iesusna ortɨmbɨkniŋmo an mbuŋa muria maica. Karica ma mina ndiarna tɨp kirara raŋgaica Iesusna ortɨmbɨkniŋmo mumutoc wɨtta moa maica, mana ortɨmbɨkniŋmo an iŋpai gargarapna tabaɨr mbuŋa ndikrina. ");
INSERT INTO gai_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ri, an Parisina ramootta, Iesusmo nakac ŋgaca kɨprinanna, ma an meac morina tɨp kirar mbatca, mana iroa gaind ndamŋirina, “An ramoot, ma ramma morena ramoot gidik ecte, an meaca mana ortɨmbɨkniŋmo tukiapeknanna, ma mana kirarapa mana tɨpembap ma lamŋinande. An meac, ma meacramootna kaŋtertaapna tɨp kirara morena meac.” ");
INSERT INTO gai_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Karica Iesusa an Parisina ramootna iro inikca atuna ndamŋica ma Saimonmo aindopatna, “Saimon, aku una neaŋna kam ianap.” Aindopri, Saimonna aindopatna, “Laŋ riripti, una kammo mbopwa.” ");
INSERT INTO gai_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Aindopri Iesusa kam roor mbuŋa gaindoprina, “Ramooteniŋa, ramoot ian ndambuŋmo kitukndukca gaindpaik naaŋgɨrina. Ianna 500na mɨn, ianna 50na mɨn. ");
INSERT INTO gai_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Maniŋ aindpaik naaŋgɨracarica, iŋmbaia anna rurutina ra laruatke, maniŋa an mac nda neaŋna kitukndukca kamaind. Ainda moatke, an ramootta maniŋmo kadmaica aindopatna, ‘Oŋgo, an nake, kai lamŋi teac.’” Aindopacarica ma Saimonmo aindoprina, “U mbop, maniŋa mandaia ndo, anna mamatŋi aniacap eacreke, mandaia ndo anna mamatŋi aniaca wanaiŋ?” ");
INSERT INTO gai_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Aindopri Saimon aindopatna, “Aku aindopnande, kituknduk aniac nda rutina ramootta ndo toŋtoŋ aniacap.” Aindopri Iesusa mamo aindoprina, “Una kamma wandoŋ ŋgoin.” ");
INSERT INTO gai_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Karica Iesusa mac nda kumbakeca an meacmo watta taŋga, ma Saimonmo aindopatna, “U gan meacmo wat kɨpwa? Aku gan una kac inik nakɨpca mbukri, u mba aukmo gaindta aina Iudana ndiarna tɨpca mba mori, gan meac, ma aukmo ndiarna tɨp kirara moapekna. Aku kɨpca mbukapekke, u mba pukca mba aŋgɨrca kɨpca aukna ortɨmbɨkniŋa mba tukiri. Gan meac ma ndo kɨpca, mana lamnɨacna timbta puk mbuŋa aukna ortɨmbɨkniŋmo an mbuŋa tukia maica, ndona paŋanna lakoar puŋga muririna. ");
INSERT INTO gai_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","U mba aina Iudananta ndiarna tɨpna kirara aukmo mba pipopotacri. Aku kɨpca una kaca mbukca eaca kɨdrɨk kecapeke, gan meaca ma aina ndiarna tɨp kirara moa, ma ndo aukna ortɨmbɨkniŋmo kɨdrɨk wɨtpaikca mumutocrina. ");
INSERT INTO gai_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","U mba aina Iudananta tɨpna kirara mba raŋgaica tabaɨra mba aŋgɨrca aukna paŋan nambat mba ndikri. Gan meaca, ndiarna tɨp kirara moca ma aukna ortɨmbɨkniŋmo kituknduk aniac mbuŋ ŋgoikrena tabaɨrap kɨpca aukna ortɨmbɨkniŋmo an mbuŋa ndikrina. ");
INSERT INTO gai_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ainda moca aku umo gaindopnande, aia, an meacmo watri, ma aukmo mamatŋi ŋgoin. Ainda moca aia mamo lamŋirena, Raraŋ Aetaniaca ma mana tɨpemb ŋgorikta makukar wɨtmo ma moa kecamacariri. Karica ramoot ianna tɨp ŋgoreac ianna aniaca wanaiŋ. Ma anna moca kɨpca Raraŋ Aetaniaca mananmo mo kecari te, an ramoot mana mamatŋi mananna Raraŋ Aetaniacmo memetmbaca mba toŋgoitndai. Mana mamatŋia tekemmotem.” ");
INSERT INTO gai_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Karica Iesusa an meacmo aindopatna, “Aku una tɨpemb ŋgorikta makukara moa kecamacariri.” ");
INSERT INTO gai_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Karica ramtaɨra manap mbiraca ambrinanna, an kamb mbaraca mina ŋgepca ndori puŋga kekelamun irikca aindopatna, “Ganna titna ramoot ma tɨpemb ŋgorikta makukara moa kecariapekna.” ");
INSERT INTO gai_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Mina aindopri, Iesusa an meacmo aindopatna, “U taŋca una nikinik iro wetwet laŋ ndeac. Una rɨtɨpaca ndo unmo otaca aŋgɨra kɨpca, mandeaca u Raraŋ Aetaniacap eteaca laŋ ndeacnande.” ");
INSERT INTO gai_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","An maiatke, iŋmbai mbuŋa Iesusa, an auŋemb anikapa auŋemb tekirap anna inikca mbukca, Raraŋ Aetaniacna bubuocna kam wembaŋ laŋna kammo meikramtaɨra wiwitica taŋri, mana iŋa raŋgairena ramtaɨrpaikca parniŋapa mbut mbuniŋa, mina manap mataŋgat. ");
INSERT INTO gai_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ri, meik ndeida ŋgaua Iesusa mina ŋerŋgaur ŋgorikcapa roumbbeba moa laŋa moatna meik toco, manap taŋrina. An meikca, mina ianna ia Maria, ma Makdalana auŋna meac. Ŋgaua ŋerŋgaur ŋgorik parmbaiapa mbut mbuniŋa mana mbukca eacri, Iesusa mana ŋerŋgaurmo moa kecariatna. ");
INSERT INTO gai_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Na Ioanapa, Susannaapa, meik ndeidap, mina manap raŋgaica taŋgatna. Ioanna, mana kaŋgaitna ia Kusa, ma Erotna kacna ŋginaŋ mbatrena ramoot paŋan. Na an meikca Iesusapa mana iŋa raŋgairena ramtaɨrmo mina ndori puŋga mimo kitukndukarapa reik kotacrena. ");
INSERT INTO gai_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ainda moca meikramtaɨr wɨt aniaca kɨpca punica eacri, mon tawanna auŋembta meikramtaɨr toca kɨpca. Iesus ndambuŋ ndaruca, mina eacri. Ainda moca Iesusa mimo kam roor ianna gaind nakerina, ");
INSERT INTO gai_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Ramoot ian, ma witna lourmo aŋgɨrca taŋga warɨŋna inikca mbukca, ma an witna lourmo an nakeca taŋri, ndeida taup ndiŋ ŋgirikrinanna. Na meikramtaɨra an nambatta kɨtaca wɨtɨkca taŋri. Na ŋgorik ndeida kɨpca an lourmo ambrinan. ");
INSERT INTO gai_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ri, lour ndeida, watur tambatna tiacarpaik ndeacrenanna. An nambat nagaceknanna, tiacarpaikca gagraca puik kocortacari te, mina marereca kocnai gurunande. ");
INSERT INTO gai_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Na witna lour ndeida lacarta ŋgaɨrta kɨdrɨk ŋgirikca, lacarta ŋgaɨrap kuria gaca, lacarta ŋgaɨra ŋgepca minmo kapaca wɨŋga, makɨtacat. ");
INSERT INTO gai_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Na witna lour ndeida tiacar laiŋpaik nambat ŋgirikca, an nambat nagacrinanna, mina ŋgepca amta reik wɨt ŋgoin nakootrina. An witna gagar kabe, kabena loura, ianna 100na mɨn nakootnande, ndeida mitoco aind nakootnande.” Karica Iesusa an kam ndopacarica, ma gaind ŋgaca mboprina, “U ramootta koarap, u gan kam mbarac.” ");
INSERT INTO gai_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Karica mana iŋa raŋgairena ramtaɨra, mamo mana kecapekna kam roorna mɨnɨŋna nda digiri. ");
INSERT INTO gai_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ma mimo aindoprina, “Raraŋ Aetaniacna bubuocna kamma tamaia iŋgoroca eacrenan, ma nemo wattacarica, ne lamŋia garacrina. Na kabena meikramtaɨrmo, ma an kamma mimo kam roor mbuŋ nakeraŋ te, mina an kam roorna mɨnɨŋna moca ore watraŋ te, mina mba ore watitndai. Na mina an kam roora warac te, mina mba an kamna mɨnɨŋa mba lamŋitndai.” ");
INSERT INTO gai_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Karica Iesusa gaindoprina, “An wit lourta kam roorna mɨnɨŋa gaind. Witna lour, anna Raraŋ Aetaniacna kam. ");
INSERT INTO gai_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Na witna lour ndeida taup ndiŋ ŋgirikrinanna, anna mɨnɨŋa gaind. Meikramtaɨra Raraŋ Aetaniacna kam mbaracrinan. Iŋmbaia Paparuna Ramootta kɨpca, Raraŋ Aetaniacna kamma mina iro inik ndeacrenanna tɨki mo kecarinande. Na ma lamŋirena ŋarikca, mina anna rɨpaca Raraŋ Aetaniaca minmo mac nda aŋgɨ nari. ");
INSERT INTO gai_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Witna loura watur tambatna tiacarpaik ŋgirikca kootrinan, anna mɨnɨŋa gaind. Meikramtaɨra Raraŋ Aetaniacna kamma waraca, anna toŋgoca rɨpacrinan an rɨtɨpac minanna gaind. Witta watur tambatna tiacarpaik nagaca eacnduk mananna mbatca taŋrina kirar, aintik mina rɨtɨpaca mba eaci roctaitndai, ainta totowai ian laru te, mina Raraŋ Aetaniacmo kecamacariek. ");
INSERT INTO gai_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Na witna lour ndeida, lacarta ŋgaɨrta kɨdrɨk ŋgirikrinanna. Anna mɨnɨŋa gaind, meikramtaɨra Raraŋ Aetaniacna kamma waraca maica. Mina taŋga iro minanna, kitukndukapa min ŋgopotacna reik laiŋapa gan tiacarpaikna reikta tamtam ŋgoin ndamŋiraŋnande. An reikca ndori mina iroarmo wɨŋga kɨtaca mina Raraŋ Aetaniacna kamna mɨnɨŋa waracna mɨnna wanaiŋ. Ainta meikramtaɨra, mina amta reikca ŋaŋari ru ŋgocorta reikta kirar. ");
INSERT INTO gai_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Na an witna loura tiacar laiŋpaik ŋgirikrinan. Anna mɨnɨŋa gaind. Meikramtaɨra Raraŋ Aetaniacna kamma waraca utiŋ te, ndorita iroar inkara wandoik laiŋ ndeac te, na mina ainda gagraca eaca te, mina amta reik laiŋ aŋgɨraŋnandet.” ");
INSERT INTO gai_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Karica Iesusa kam roor ianmo gaind mac keatna, “Meikramtaɨr, mina wɨn aŋgɨca tacmo mba aŋgɨri taurkitndai, co, mba bar kaŋgaukca mba iŋgorocitndai. Wanaiŋ ŋgoin. Mina gainda morena. Tacmo tacna taupca mbiraca, meikramtaɨra kɨpca kac inikca mbuk te, mina an tacna memetac mbatnande. ");
INSERT INTO gai_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Te, iŋgoroca eacrena reikca iŋmbaia mina muruŋa larui raekca tɨk te, tamaia iŋgoroca eacrena reik toco muruŋa larui raekca tɨkca, meikramtaɨra mimo muruŋa wati garacnande. ");
INSERT INTO gai_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Ne ndoritake, matau wat. Ne kamma waparacna kirarmo titoca waraca rapacapek. Ŋarikca ramoot ianna landamŋiap eaceknanna, Raraŋ Aetaniaca mamo kabena landamŋi ianna an nambat mac neaŋnande. Na ramootta landamŋiar kocorta ramoot, ma ndomo landamŋi tekermotemap mboprenan, anna Raraŋ Aetaniaca mananmo mo kecarinande.” ");
INSERT INTO gai_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Na an mɨn mbuŋa Iesusna aemmapa laipitikca man mbatna moca anna nakɨprinanna, meikramtaɨr wɨt aniaca punica eacri, mina kɨpca man mbatna toawanaiŋ. ");
INSERT INTO gai_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Aintik mina raekmbai ndeacri. An tumbunnanda ndori watca, Iesusmo aindopatna, “Una aemmapa laipitikca kɨpca raek malambireke, mina ndorimo un mbatna moca.” ");
INSERT INTO gai_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Karica ma mina kamma gaind mac nda rutirina, “Meikramtaɨra mina Raraŋ Aetaniacna kamma waraca anna raŋgairenanna, an meikramtaɨra, mina aukna aemmapa laipitik.” ");
INSERT INTO gai_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Oit ianna Iesusapa mana iŋa raŋgairena ramtaɨrap, mina embarta kor ian naŋgabukca ma mimo aindopatna, “Aia mɨarmo monmbai waŋ nagana.” Aindopca mina kor aŋgɨrca gari. ");
INSERT INTO gai_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Na mina taŋri. Iesusa korna inik naŋgori. Na mɨara watapa murmur aniac ianna laruatke, mactir anikca an mɨar naŋgepca maica mina kormo pia bururuca maica, mina ŋgocrainan toca moatke. ");
INSERT INTO gai_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Mina taŋga Iesusmo, aca ŋgepca aindopatna, “Kacoot! Kacoot! Aia maica ŋgocraina mamoek!” Aindopatke, Iesusa ŋgepca an murmurapa an macaitmo karaca mbopca, maniŋa andu namamaiat, na pukca nuknukir kocor koind. ");
INSERT INTO gai_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Karica ma mimo gainda digirina, “Nena rɨtɨpaca ten ndeacre?” Ma aindopri, mina mana an aiŋna gargar mbatca, rugdar moca ndori puŋga tamtam ndamŋica aindopatna, “Anna mandai ŋgoin? Ma murmurapa pukmo karaca mbopca maniŋa mana kam mbaraca maiapekna.” ");
INSERT INTO gai_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ainda mocarica Iesusapa mana iŋa raŋgairena ramtaɨrap, mina taŋga Galili mɨarmo waŋembai ndeacrina Gerasananta pitrikna kamndɨp ŋguroca. ");
INSERT INTO gai_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ma kor tɨkcarica, gacatke, an auŋ aniacna ramoot ianna ŋerŋgaur ŋgoreacapnanna, man ndambuŋ makɨpat. An ramootta ŋerŋgaur ŋgorikcap eacrenan. Ŋgaua ma raraŋitta mba leacrenanna. Na ma loorkamaind ndeacrenan, na ma kacap mba eacrenanna, wanaiŋ ŋgoin. Ma tamtam ŋgoinna taŋrena, na ma mina warir mutocrena mukur teacrena. ");
INSERT INTO gai_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ri, an ramootta Iesusa wattatnanna, ma larɨkca ŋgocraica, ma mana out ŋgirikca ma gaindopca, “Iesus! U Raraŋ Aetaniac tamuŋna Nuoc. U aukmo tida moit? Aku umo gaind ŋgoinna diginande. U aukmo gɨgɨrar anikca kai neaŋ teac!” ");
INSERT INTO gai_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Aintik Iesusa an ŋeroŋ ŋgoreacmo mambopat, “U an ramootmo kacrep.” An ŋeroŋa ŋgaua mamo memetmbaca mba kacreprenanna. Ainda moca ramtaɨra mana aiŋa morenanna, mina mana parniŋapa orniŋmo lawirta ŋgatɨk mbuŋa leaca maica ma eacri, mina mana ŋginaŋa mori, na ma an lawirta ŋgatɨkmo moa katac kecarica, an ŋeroŋ ŋgoreac mamo, mon ramtaɨr kocorta taup naaŋgɨa mandaca ma anna taŋraŋnande. ");
INSERT INTO gai_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ri Iesusa manmo gainda digirina, “Una ia mandai?” Na ma aindopatna, “Aukna ia, ‘Wɨt Aniac.’” Anna mɨnɨŋa gaind, ŋerŋgaur ŋgorik wɨt aniaca mana iro inikca mbukca an ndeacrena. ");
INSERT INTO gai_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Karica an ŋerŋgaur ŋgorikca Iesusmo memetmbac ŋgoinna gainda digica gaindoprina, “U aimo kai an aua mbitrem kocorta aua kai ke, irik teac!” ");
INSERT INTO gai_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ri, markɨmta wiwit aniac ianna rambuŋna takur roumb ŋgambca taŋrinanna. Ŋerŋgaur ŋgorikca Iesusmo gagra digica aindopatna, “U aimo watcarica, aia an markɨmta inkara mbukna.” Mina aindopri, Iesusa minmo wattacarica. ");
INSERT INTO gai_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","An ŋerŋgaur ŋgorikca an ramootmo tɨkcariatke, mina taŋga markɨmta inkara mbukca. An markɨmbca paŋpaiŋ ŋgoinna pacwɨkɨnca ŋgotta irikatnanna, pukapukca, mina puk ambca menaca mamaiat. ");
INSERT INTO gai_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ri, mina ŋginaŋa morina ramtaɨra an laruatna reikca watca, ainda moca mina kɨpcarica taŋga, an auŋ aniacapa anna rambuŋna auŋembmo an iniknanmo, an reacna kamma tamtamma ninia mataŋgat. ");
INSERT INTO gai_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ri, meikramtaɨra ndorimo kɨpca, an reac laruca eacrinan mbatna moca. Anna kai ŋgoin laruca eacre, aindopca, mina taŋga Iesus ndambuŋ ndaruca. Wattatnanna an ŋerŋgaur ŋgorikca mbukca eacrina ramootta laŋa moca, iro landamŋi laŋ aŋgɨca, raraŋit aŋgɨra leaca, Iesusna kɨtɨmma mbiraca eacri. Na meikramtaɨra an mbatca, rugdar mocaricatke. ");
INSERT INTO gai_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","An reik laruca watatna meikramtaɨr, mina an reikca Iesusa an ramootta, ŋgaua ŋerŋgaur ŋgorikcap eacrinanna moa, laŋa moca, mandeaca ma laŋ mamori, mina anna ninini moatke. ");
INSERT INTO gai_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Gerasa inikna auŋembta meikramtaɨra muruŋa, mina iroara tamtam ndamŋirina, an aiŋ gargar aniac Iesus morinan mbatca, mina rugdar mocarica. Ainda moca an meikramtaɨra anna watca Iesusmo, ndori tɨkcarica taŋna moca aemaŋmaŋap digia, ma minmo tɨkcarica taŋna. Na ma irikca embarta kor naŋgabukca mataŋri. ");
INSERT INTO gai_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","An ŋerŋgaur ŋgorikca manmo tɨkcariatna ramootta, ma Iesusmo ainda gagra digirina, “U aukmo watcarica aku unap taŋna mɨn ki?” Ainda digiatke, Iesusa manmo mana auŋ mac nda mbagɨrica aindopatna, ");
INSERT INTO gai_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“U ndona kaca taŋca, Raraŋ Aetaniaca un ŋgotacna moca morina reikta kammo, ndona auŋa nini.” Aindopri an ramootta mac nda taŋga ndona auŋna meikramtaɨrmo aindopatna, an reikca Iesusa auk ŋgotacna morina reik. ");
INSERT INTO gai_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Karica Iesusa mɨarmo waŋembai mac nda gacatke, meikramtaɨra mana moca lambia eacrinanna, man mbatca mina toŋtoŋgar koind. ");
INSERT INTO gai_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ainda moca ramoot ianna mana ia Iairus ma Iudananta mimitpac aŋgɨrena kacna ŋginaŋ mbatrena ramoot paŋan. Ma laruca Iesusna outmo mana or kɨtɨmma tutupniŋ rɨmbɨtca mbiraca Iesusmo, ndona kaca taŋna moca anna gagra digiri. ");
INSERT INTO gai_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Mana mooŋna mooŋnuoca kabe ŋgoin, mana iarira parniŋapa mbut mbuniŋna mɨn, ma maica menacna mori. Ainda moca Iesusa taŋgatke, meikramtaɨr wɨt aniac manap taŋri, mana tikmo ndindiaŋ nakeri. ");
INSERT INTO gai_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Na meac ianna eacrinanna, memetmbaca ma meikta roumb aŋgɨca racaind taŋrina meac. Ma an roumb aŋgɨca eaca taŋ, taŋga iarira parniŋapa mbut mbuniŋna mɨn. Ramoot ianna mana roumbca mo laŋa mo ŋgocor. ");
INSERT INTO gai_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ainda moca an meaca Iesusna iŋmbai nakɨpca rambuŋaica, karica mana tik ŋgapaoc rocotna tɨpmo pipikatke. Mana racainda anduna gagraca mba mac laruatke. ");
INSERT INTO gai_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Karica Iesusa minmo gainda digiatke, “Mandaia ndo aukmo pipikapekna?” Aindopri mina muruŋa aindopatna, “Aia wanaiŋ.” Ri, Pita aindopatna, “Kacoot, meikramtaɨr wɨt aniaca unmo wɨtɨkca korere aŋgɨca aumba moca, una tikmo ndindiaŋ nakerina.” ");
INSERT INTO gai_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Aindopri Iesusa aindopatna, “Ianna aukmo pipikri. Aku ndona tikca raŋgaiapeknanna aukna gargar ianna aukmo kecarica mataŋga.” ");
INSERT INTO gai_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Aindopri, an meaca iŋgorocna mɨnna wanaiŋ. Ainda moca ma lamŋica, mana tikca nekca ŋgocraica, ma kɨpca Iesusna or kɨtɨm ŋgirikca meikramtaɨr wɨt anikta, lamnik ŋgoutta tɨkca aindopatna, ma kaina moca, Iesusna tik ŋgutiŋrina. Ma ndona roumbca anduna maiatna nininia moatna. ");
INSERT INTO gai_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Aindopri Iesusa manmo gaindopatna, “Aukna mooŋnuoc. U aukca rɨpacapeke, ainda moca u laŋ macarica. U taŋca nikinik iro wetwet laŋ ndeac.” ");
INSERT INTO gai_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Iesusa an ndopca eacri, ramoot ianna Iairusna kac ŋgetacndiŋa kɨpca, mamo aindopca, “Una mooŋnuoca mamenacri. Na ririptimo aiŋ aniaca kai neaŋ teac.” ");
INSERT INTO gai_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Aindopri, Iesusa an mbaraca, ramoot paŋanmo gaind mac nda rutica mbopatna, “U rugutta kai mo teac. U rɨpac. Una mooŋnuoc, ma laŋa monande.” ");
INSERT INTO gai_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Karica Iesusa ŋgepca taŋga, an ramoot paŋanna kac ndaruca, mbukna moatke, ma meikramtaɨr muruŋmo kɨracarica mina manap mba mbukatke, wanaiŋ. Ma Pitaapa, Ionapa, Iemisapa, mooŋnuocna amepaetap, ma min niŋgik aŋgɨca mina manap mbukatna. ");
INSERT INTO gai_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ri, meikramtaɨra an kacnɨm ndeacrinanna, an mooŋnuocna kadmaica, aeri eacri. Na Iesusa mimo gaindopatna, “Ne kai ae teac. Ma mba menacri. Ma meraca ŋgorena.” ");
INSERT INTO gai_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Aindopri, mina manmo laroŋa ŋgocraica, aindopatna, “Aia lamŋirina mooŋnuoc ma kocnai mamenacri.” ");
INSERT INTO gai_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ainda moca Iesusa an mooŋna mooŋnuocna par ŋgutiŋga aindopatna, “Aukna mooŋnuoc, u ŋgep!” ");
INSERT INTO gai_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Aindopri, an mooŋnuocna ŋeroŋa mac nda kɨpca mbukca, ma anduna ŋgepatke. Iesusa aindopatna, “Ne an mooŋnuocmo amna reac neaŋca ma am.” ");
INSERT INTO gai_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Mina ainda moatke, mooŋnuocna amepaetta ŋgep ŋgoreac ŋgoin naŋgepca. Iesusa maniŋmo gaind nagagra mboprina, “Oŋgo ramoot ianmo gan laruapekna reacna kamma kai mbop teac ŋgoin.” ");
INSERT INTO gai_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Karica Iesusa ndona parniŋapa mbut mbuniŋna iŋa raŋgairena ramtaɨrmo aca kɨpca. Mimo meikramtaɨrta roumbca moca laŋa mona gargarapa meikramtaɨra ŋerŋgaur ŋgorikcap eacrenanmo mo kecarina, i aniacapa gargarap neaŋgatna. ");
INSERT INTO gai_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ma mimo mbagɨrica taŋca Raraŋ Aetaniacna bubuocna kam ndop te, roumbbebta meikramtaɨrmo moi laiŋga mona moca. ");
INSERT INTO gai_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Aindopacarica ma mimo aindopatna, “Ne taŋna mo te, ndori ŋgopotacna reikap kai aŋgɨri taŋ teac. Na ne, ndorita utiŋga ndɨpaca taŋrena komborap, kai utiŋa taŋ teac. Na ne ndorita aŋgɨra taŋrena rambaɨrap kai aŋgɨri taŋ teac. Na ne gagaimbta tapacar tɨpembapa, kitcartukarap, kai aŋgɨri taŋ teac. Na ne ŋgegetrikina tik ŋgapaoc laiŋgap kai aŋgɨri taŋ teac. Ne wanaiŋa taŋ. ");
INSERT INTO gai_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Na ne taŋi kabena auŋ ndaruca, kac ianna mbiraca an ŋgamca an naŋgo te, kac kaca, kai tumcai taŋ teac. Nena mbiracrina kac niŋgik ndeaci, taŋca ne kabena auŋa taŋna mo te, nena eacrena kac tɨkcarica, ne ŋgepca kabena auŋa taŋ. ");
INSERT INTO gai_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Na ne auŋ ian ndaru te, an auŋna meikramtaɨra nenmo actɨkca nemo ndiarna tɨpca mo ŋgocor, ne ŋgepca an auŋ tɨkcarica taŋna mo te, ne ndorita orniŋna tiacar kacopca taŋ te, mina lamŋinande, aia mimo ndiarna tɨpca laŋa mba moapeke.” ");
INSERT INTO gai_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Aindopacarica mina ŋgepca an auŋembta inikca mbukca, auŋ, auŋmo Raraŋ Aetaniacna kam wembaŋ laŋ wiwitiri, mina roumbbebta meikramtaɨra moa laiŋ mamori. ");
INSERT INTO gai_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Na Erotta ma Galili bubuocrena ramoot paŋan, ma Iesusna moatna reikta kamb mbaraca ma tamtam ndamŋirina nininia gaind. Na ramtaɨr ndeida aindoprena, “Ion ma menacatnanna ma mac nda maŋgepri.” ");
INSERT INTO gai_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Na ramtaɨr ndeida aindopatna, “Anna Elaia, ma mac nda makɨpri.” Na ndeida aindoprina, “Atuna ramma morina ramoot ianna, ma warir eacrena pitrik umbum ndiŋ mac nda ŋgeprina.” ");
INSERT INTO gai_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ainda moca Erotta gaindopatna, “Aku mbopca, mina Ionna logotta wawɨrrina. Na an ramoot, anna ma mandai ŋgoin? Aku waracreke, ramtaɨra mana aiŋna nininia moca taŋrena?” Aintik ma ndomo Iesus ŋgoin mbatna moca. ");
INSERT INTO gai_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Mana an up aŋgɨrena ramtaɨra ma mbagɨrica taŋgatnanna, mina mac nda kɨpca mina Iesusmo, ndori morina reikta kamb ndopacarica, karica, Iesusa min niŋgik aŋgɨca. Mina taŋga kabena auŋ ian ndaruatna. An auŋna ia Betsaida. ");
INSERT INTO gai_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","An mɨn mbuŋa meikramtaɨr wɨt aniaca Iesusmo an auŋa tataŋna kam mbaracatke, mina mana iŋa raŋgaica taŋri. Na mina taŋga, man ndambuŋ ndaruatke, ma min kɨpatnan mbatca toŋgoca, mimo aca kɨpca, ma mimo Raraŋ Aetaniacna bubuocna kam ndopatke, ma mina roumbbebmo moa laiŋga moatna. ");
INSERT INTO gai_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Karica wigwacariatke, mana iŋa raŋgairena ramtaɨra kɨpca man ndambuŋa mamo aindopatna, “Karica u gan meikramtaɨr wɨtmo mbagɨrica mina auŋembapa, kaiknimbca tamtambca taŋga ndorita amta reikta koreca am te, ndorita ŋgogona taupembta mbatca ŋgona. Gan taupca aia eacrenan, anna auŋemb kocor.” ");
INSERT INTO gai_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ri, Iesusa mimo gaindopatna, “Ne ndori puŋga mimo amna reac neaŋam.” Aindopri mina aindopatna, “U ndo toŋgo te, aia gan meikramtaɨr wɨtmo muruŋa neaŋamna amta reik oikna taŋna ki? Aia amta reikca wɨtta wanaiŋ, tapacar tɨp parmbaiapa ŋgoaem mbuniŋa ndo maeacreke.” ");
INSERT INTO gai_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Na an ndeacatna ramtaɨr tiŋgikca 5,000na mɨmɨatna mɨn. Na meikmombonikca mba nduatke. Ri, Iesusa ndona iŋa raŋgairena ramtaɨrmo aindopatna, “An ndeacrenanmo mbopca, mina taŋca 50, 50na mɨnna nduca tumnambca moi taŋi mbirac.” ");
INSERT INTO gai_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Aindopatke, mana iŋa raŋgairena ramtaɨra an meikramtaɨrmo mbopca, mina taŋga mbiraca maiatke. ");
INSERT INTO gai_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Karica Iesusa an tapacar tɨpemb parmbaiapa ŋgoaem mbuniŋap aŋgɨca tamuŋna auŋa watca ma Raraŋ Aetaniacmo, kam tɨp laŋ neaŋga ma an tapacar tɨpembapa ŋgoaemniŋ witkica aŋgɨra ndona iŋa raŋgairena ramtaɨra neaŋga, mina an ramtaɨrmo mabiŋaiat. ");
INSERT INTO gai_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Na biŋaia maica, mina muruŋa amba mɨnna tɨkca, mina an amta reik tɨpmo aŋgɨra tumbunna tɨkca, larkambca parniŋapa mbut mbuniŋnan paikca aoca mamaiat. ");
INSERT INTO gai_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Na oit ianna Iesusa Raraŋ Aetaniacmo mbendeia eacri, mana iŋa raŋgairena ramtaɨrap, mina taup ianna ndori tiŋgik ndeacri. Na ma mimo gainda digirina, “Meikramtaɨra aukna moca titoc ndoprena? Aku mandai ŋgoin?” ");
INSERT INTO gai_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Aindopri, mina mana kam rutica gaindopatna, “Ndeida unmo kɨtac puk neaŋrena ramoot Ion ndoprena. Ri, ndeida gaindoprena, ‘U Elaia.’ Ri, ndeida gaindoprena, ‘U atuna rambca morina ramtaɨrta ramma morina ramoot ianna, warir eacrena pitrik umbum ndiŋ mac nda ŋgeprina.’” ");
INSERT INTO gai_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Aindopatke, ma minmo aindopatna, “Ne ndori koinda aukmo mandai ŋgacit?” Aindopatke, Pita mana kam rutica gaindopatna, “U Raraŋ Aetaniaca babuca mbagɨrica kɨpca aimo mac nda aŋgɨna ramoot.” ");
INSERT INTO gai_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Karica Iesusa ndona iŋa raŋgairena ramtaɨrmo, ramoot ianmo gaindop narica, anna ma mandai ŋgoin. Aindop narica, anna wandɨk tɨkatna. ");
INSERT INTO gai_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Karica ma gaindopatna, “Ramootna Nuoc, ma gɨgɨrar wɨt ŋgoin aŋgɨnandet. Te, ramtaɨr paŋaindapa, taup ndamtaɨr paŋaindapa, tɨpemb wandik tamŋirena ramtaɨrap, mitoco mamo ga wɨtɨk te, meikramtaɨra mamo mo menacnande. Na ma eaci, rai mbonkac mai te, ma mac nda ŋgepnande.” ");
INSERT INTO gai_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Karica ma mimo muruŋa gaindopatna, “Mandaia aukca raŋgai ndop te, ma ndona toŋtoŋgarta kirarir tɨkcarica, ma ndona kekeracna ik aŋgɨca mbukca, ra, ra ma aukca raŋgairaŋ. ");
INSERT INTO gai_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Na ramoot ianna ma ndona eteacna watna moca utiŋcari te, mana an eteacna watta, ma mainande. Na ramoot ian ma aukna moca ndona eteacna wat kecari te, mana an eteacna watta mba maiitndai. ");
INSERT INTO gai_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Na ramoot ian ma gan tiacarpaikna reikca muruŋ ŋgutiŋ te, na ma ŋgocrai te, an reikca mina mamo titoc ŋgotacit? ");
INSERT INTO gai_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","U mandaia aukna kambta moca mo te, na aukmo numbira neaŋ te, iŋmbaia Ramootna Nuoca mana memetacna tac aniacapa, Aetna memetacna tac aniacapa, Raraŋ Aetaniacna mbaiŋna aiŋa morena ŋerŋgaur ratnandap, ma anna memetacna tac aniacna kaŋgaukca mbiraca kɨp te, ma an ramootmo numbira monande. ");
INSERT INTO gai_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Na aku nemo gidik ŋgoin ndoprena, ramtaɨr ndeid, mina ganna wɨtɨkca eacrenan, mina menac ŋgocor ndeac te, mina tamuŋna Raraŋ Aetaniacna bubuoca mina watnande.” ");
INSERT INTO gai_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Iŋmbaia rai parmbaiapa mbutremb mbonkacna raipaikna kirar maiatke, Iesusa mbendeina moca ma Pitaapa, Ionapa, Iemisap, minmo aŋgɨca takur tamuŋ magat. ");
INSERT INTO gai_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ma gaca mbendeia eacri, mana inpaŋan mananna kocnaia ŋgetrikicaricatke, mana tik ŋgapaoca kocnaia metaca goamacariat, ");
INSERT INTO gai_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","na ramootniŋa andu man ndambuŋ ndaruca manap wɨtɨkca mbopca eacrina. Na an ramootniŋa Mosesapa Elaia. ");
INSERT INTO gai_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Maniŋa Raraŋ Aetaniacna memetacna tac aniacna kaŋgauk mbuŋ ndaruca, Iesusmo, Ierusalemma tɨkca maniŋa manap, mana momona reikta kam ndopatke, mamo gan tiacarpaik tɨkcarica tataŋna kam ndopacarica. ");
INSERT INTO gai_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Karica mana iŋa raŋgairena ramootniŋapa Pitaap, mina lamnik numbacarica mina ŋgoa niri mbuŋa, mina ŋgepca wattatnanna Iesusa memetacna tac aniacap eacri. Mina wattatnanna an ramootniŋa manap wɨtɨkca eacri. ");
INSERT INTO gai_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Na maniŋa Iesusmo tɨkcarica taŋna moatke. Pita Iesusmo gaind mambopat, “Kacoot, aia gan ndeac te, laŋ. Aia nena ndamb mbonkaca monande. Ianna unan, na ianna Mosesnan, na ianna Elaianan.” Pita an kam ndopri, ma ndo mboprina kamna mɨnɨŋa lamŋi ŋgocor. ");
INSERT INTO gai_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Karica Pita an kamb ndopreke, dimir ndepikca kɨprinanna mimo wɨŋga kɨtaca, mina rugdar mocariri. ");
INSERT INTO gai_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","An dimirpaikna inikca kam ianna gaindoprina, “Anna aukna Nuoc. Aku manmo larapacrina, na ne mana kam mbarac.” ");
INSERT INTO gai_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","An kam maiatke, mina wattatnanna Iesusa ndo kabea wɨtɨkca eacri, na mina takur tamuŋ ŋgetacndiŋ mac nda irikatke, an mɨn mbuŋa mana iŋa raŋgairena ramtaɨr mbonkaca, mina ramoot ianmo, ndori watatna reikta nininia mba moatke. ");
INSERT INTO gai_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Iŋmbaina ra mbuŋa Iesusa ndona iŋa raŋgairena ramtaɨr mbonkacap mina takur tamuŋ tɨkcarica mac nda irikatke, meikramtaɨr wɨt aniaca kɨpatnanna Iesusmo taupca tɨkca ndauprikiatke. ");
INSERT INTO gai_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Mina inikna ramoot ianna kam keca aemaŋmaŋap gaindopatna, “Riripti, aku unmo digdigi gargar ianap. U aukna nuoca wat? Anna aukna nuoc kabe ŋgoin. ");
INSERT INTO gai_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Memetmbaca ŋeroŋ ŋgoreac ianna manmo mbuk te, ma kam aniaca andu nake te, mana tikca wanaiŋa nekraŋ te, mana upa toptik laruraŋnande. An ŋeroŋ ŋgoreaca mamo mo ŋgoreaca moreke, manmo tawi kecari ŋgocor. ");
INSERT INTO gai_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Aku una iŋa raŋgairena ramtaɨrmo, mana ŋeroŋ ŋgoreac ŋgot kɨpcarina gargarna digiri, mina mona mɨnna wanaiŋ.” ");
INSERT INTO gai_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Aindopri, Iesusa mana kam rutica aindoprina, “Ne gan mɨnna meikramtaɨrta, iroar landamŋia wandoŋa wanaiŋ. Ne rɨtɨpaik laiŋ kocor. Tumbuitta tɨk te, aku nenap eacit, aku nenap epa kɨpca mɨn matɨkca, tumbuitta tɨk te, ne iroar landamŋi laiŋ aŋgɨrit? Una nuocmo gan naaŋgɨ kɨp.” ");
INSERT INTO gai_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Karica an nuoca kɨpca, Iesus ndambuŋa rambuŋaiatke, an ŋeroŋ ŋgoreaca mamo moa ŋgocraica, ma irikca keca orapaɨr wɨpɨkca rɨŋgatke. Iesusa ŋgepca an ŋeroŋmo kaega mocarica, ma an nuocmo, moca ma laŋa morina, na mamo mana aet mac nda maneaŋgat. ");
INSERT INTO gai_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ri, meikramtaɨr wɨt aniaca Raraŋ Aetaniacna gargar aniac mbatca mina rugdar mocarica. Ainda moca meikramtaɨra Iesus moatna reik wɨt anikta moca tamtam ndamŋiatke, Iesusa ndona iŋa raŋgairena ramtaɨrmo aindopatna, ");
INSERT INTO gai_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ne ndorita koura ŋaŋari tɨkca gan kam mbarac. Iŋmbaia mina Ramootna Nuocmo raraŋwɨtɨkca mamo meikramtaɨrta para neaŋnande.” ");
INSERT INTO gai_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Aindopri, mina an kamna mɨnɨŋa aŋgɨ ŋgocor, na mina mba lamŋiatke, an kamna mɨnɨŋa minmo iŋgoroca eacri, na mina lamŋi rapac ŋgocor. Ainda moca mina manmo anna digdigiar monanna, mina rugdar moca. ");
INSERT INTO gai_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Oit ianna mana iŋa raŋgairena ramtaɨra, ndorimo gan kam kɨdrɨkna ŋgipuŋgatna, “Mandaia ndo aina ramoot paŋan ndeacit?” ");
INSERT INTO gai_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ainda moatke, Iesusa mina iroara atuna ndamŋica, ma mooŋnuoc teker ian aŋgɨca kɨpca ndona kɨtɨmma wɨtɨkca. ");
INSERT INTO gai_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Mana iŋa raŋgairena ramtaɨrmo ma gaindopatna, “Ramootta aukna iroapa landamŋiap eacrenan, ma gan mooŋnuocmo, otac te, ma auk ŋgotacapekna, na ramootta auk ŋgotac te, ma aukmo mbagɨrica kɨpatna ramoot ŋgotacapekna. Aintik an ramoot, mana ia nena muruŋna irembta kaŋgauk ndeacrenan, mana ia tamuŋ ŋgoin maeacreke.” ");
INSERT INTO gai_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ri, Ionna ma Iesusna kam mbaraca, ma mana kam rutica aindopatna, “Kacoot, aia watrina ramoot ianna una i mbuŋa meikramtaɨrta ŋerŋgaur ŋgorikca moa kecarica taŋrena. An ramoot, ma aina tumbunnanna wanaiŋ. Aintik aia manmo ndoriap eteaca, wandɨk tɨkrina.” ");
INSERT INTO gai_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Aindopri, Iesusa mamo nda rutica aindopatna, “U mamo wandɨkca kai tɨk teac. Na mandaia unmo nda mbop ŋgocor, anna una aikndamoot ŋgoin.” ");
INSERT INTO gai_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Raraŋ Aetaniaca Iesusmo, ndona tamuŋna auŋ mac nda aŋgɨ taŋna ra rambuŋaiatke, ainda moca Iesusa ndomo Ierusalemma taŋna iro paŋpaiŋ naŋgepri. ");
INSERT INTO gai_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Na ma ramtaɨr ndeidmo, outta mbagɨrica mina taŋga mana reik kocrona moca, taŋga Samariana inikna auŋ ian ndaruca, mina mana reik kocrona mori. ");
INSERT INTO gai_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Na Samaria auŋna meikramtaɨra lamŋirina, ma Ierusalemma taŋna taŋrena, ainda moca mina aindopca, “Mamo kai actɨk teac. Watcarica ma taŋ.” ");
INSERT INTO gai_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Aindopri, Iesusna iŋa raŋgairena ramootniŋa, Ionapa Iemis, maniŋa Samariana meikramtaɨr morina tɨp kirara watca toŋgo ŋgocor, ainda moca maniŋa Iesusmo gainda digiatna, “Kacoot, u toŋgo te, aia tamuŋna auŋna tac ŋgac irikca an meikramtaɨrmo kocnai wɨrcarina.” ");
INSERT INTO gai_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Maniŋa aindopri, Iesusa nda repakeca watca maniŋmo kaega mocarica. ");
INSERT INTO gai_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Na mina ŋgepca kabena auŋ ian mataŋgat. ");
INSERT INTO gai_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ri, Iesusapa mana iŋa raŋgairena ramtaɨrap, mina taup ndiŋa taŋri, ramoot ianna mamo gaindoprina, “U tenna taŋ te, aku una raŋgaica unap taŋraŋnande.” ");
INSERT INTO gai_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Aindopri, Iesusa mamo gaindopatna, “Raŋna piriŋ kunnara minanna ŋgorena tiacarpaikna aurembap, na ŋgorik mitoco minanna ŋgorena timbap, na Ramootna Nuoc ma meraca ŋgogona taupemb kocor.” ");
INSERT INTO gai_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Karica Iesusa kabena ramoot ian motocmo gaindopatna, “U ŋgepca aukna iŋ nakɨp.” Aindopatke, an ramootta mamo gaindopatna, “Kacoot, u aukmo pac watcarica, aku ndona aetna waɨr pac mutocarica.” ");
INSERT INTO gai_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Aindopri, Iesusa mamo gaindopatna, “Memenaikta kirarna ramtaɨrmo watcarica, mina ndorimo ndorita waɨrmo ndori mutoc. U watcarica ŋgepca taŋca, Raraŋ Aetaniacna bubuocna kam ndopna taŋ.” ");
INSERT INTO gai_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Karica ramoot ian tuk, ma Iesusmo gaindopatna, “Kacoot, aku unap taŋnande. U aukmo pac watcarica aku taŋca ndona aemaetapa laiplacarap mbibirac emtemma mocarica.” ");
INSERT INTO gai_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Aindopri, Iesusa mamo gaindopatna, “Ramootta tiŋar ŋgutiŋrena ramoot, ma memetmbaca iŋmbaia kai wat teac, ma laŋa mba taŋitndai. Ainta ramoot ma Raraŋ Aetaniacna bubuocna aiŋa mona mɨnna wanaiŋ.” ");
INSERT INTO gai_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Karica Kacootta kabena 72na mɨnna ramtaɨr ndeidmo mac nduca. Na ma mimo mbuniŋ, mbuniŋa nduca maica, mimo ndona tataŋna auŋemb anikapa auŋemb tekirap, mimo outta taŋna ndopca, ma mimo mbagɨrica mina taŋna moatke. ");
INSERT INTO gai_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ma mimo gaindopatna, “Warɨŋna amta reik wɨtta muruŋa kocnaia ruamaica maeacreke. Na min aŋgɨna ramtaɨra wɨtta wanaiŋ. Aintik ne an warɨŋna Kacootmo mbendei mbopca ma ndona mbaiŋna ramtaɨrmo mbagɨrica, mina taŋca mana warɨŋna amta reikmo aŋgɨri tumnambca tɨk. ");
INSERT INTO gai_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","“Ne taŋ! Aku nemo sipsiparta mombonikta kirara, nemo raŋna piriŋ ŋgorikta kɨdrɨkca mandaca mambukek. ");
INSERT INTO gai_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Na ne taŋ te, kitukndukapna tukutapa rambap kai aŋgɨ teac, kabena ortɨmbɨkniŋ ŋgapaocap kai aŋgɨ teac. Ne an reikap kai aŋgɨca taŋ teac. Na ne taŋ te, ramoot ianap kai aocke mbop teac. ");
INSERT INTO gai_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Na ne taŋi kacnɨm ianna mbukca anna mbirac te, reac lacaua, ne mimo gaindop, ‘Ne gan kacnɨm ndeacrena meikramtaɨr, ne nikinik iro wetwet laŋap eacraŋ.’ ");
INSERT INTO gai_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ainta nikinik iro wetwet laŋna ramoot ianna gan kacnɨm ndeac te, nena an ndiarna kam laŋa ma aŋgɨnande. Na ŋarikca ainta nikinik iro wetwet laŋna ramoot ianna eac ŋgocor, an nikinik iro wetwet laŋa, anna nenan, ne mac nda aŋgɨ. ");
INSERT INTO gai_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Na ne an kacnɨm niŋgikca mbiraca eac te, an kacnɨmnannda, nemo amna reikapa pukap neaŋamnande. Aintik ramootta aiŋa mo te, ma anna opoik aŋgɨnande. Na ne kai kabena kaikmo kai tamtami taŋ teac. ");
INSERT INTO gai_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Karica ne kabena auŋ ianna taŋca, anna meikramtaɨra nemo ndorita kaik taŋgɨ taŋca, nemo amta reik neaŋ te, ne aŋgɨca am. ");
INSERT INTO gai_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ne an auŋna meikramtaɨrta roumbbebmo, moi laŋa mo te, mimo gan kam ndop, ‘Raraŋ Aetaniacna bubuoca nenmo maica kɨpca rambuŋaia macariri.’ ");
INSERT INTO gai_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ŋarikca ne taŋi auŋ ian ndaruca, an auŋna meikramtaɨra nenmo ndorita kaik taŋgɨ taŋi, ndiarirta tɨpembmo mo ŋgocor ndacari te, ne ŋgepca nda taŋgek, ne taŋca an auŋa punirena taupca wɨtɨkca minmo aindop, ");
INSERT INTO gai_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Nena auŋna tiacara aina ortɨmbɨkcara kapaca eacrenan, aia iriki an tiacarta ourmo kacopca taŋ te, ne lamŋinande. Ne an tɨp kirara laŋa mba moapeke. Na ne ndoritake wat. Raraŋ Aetaniacna bubuocna mɨnna maica kɨpca rambuŋaia macarica.’” ");
INSERT INTO gai_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Karica ma gaindopatna, “Mina aukmo aindopnandet, Raraŋ Aetaniacna meikramtaɨrta makukara ritri waparacna ra, ma lamŋirenanna laru te, gan auŋna meikramtaɨrta morina makukara bagraranik koind. Mina Sodom auŋna meikramtaɨrta makukarmo kocnaia kundrinan.” ");
INSERT INTO gai_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Karica Iesusa gaind mac mboprina, “Korasinna meikramtaɨrapa Betsaidana meikramtaɨr, ndoripembta kadmai, ne makukara aŋgɨnandet. Ramoot ianna atua taŋga Tairapa Saidonna inikca taŋga gaindta ŋgagatrac wɨtta, aku nena kɨdrɨkca tɨkca morina kirara, mina kɨdrɨkca tɨkca mori co, mina atuna iroar inkar ŋgetrikica ndori morina tɨpemb ŋgorikta makukarta kakadmaica moca, kakadmaina lamboi aŋgɨca kotir aŋgɨca aoca eac mbe, mina ndorimo, an tɨp ŋgoreacna makuk mina morinanna laŋa wanaiŋ. Aintik mina ndorita tɨpemb ŋgorikta kakadmaimo wandac mbe. ");
INSERT INTO gai_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ŋarikca Raraŋ Aetaniaca meikramtaɨrta makukara ritri waparacna ra laru te, ne an auŋniŋna morina tɨpemb ŋgorikta makukara Tairapa Saidonna morina tɨpemb ŋgorikta makukarmo kunnandet. ");
INSERT INTO gai_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ainda mo te, u Kapaneamma, u ndomo aŋgɨca tamuŋna auŋ nagac ndopat ki? Wanaiŋ ŋgoin. Unmo mac nda aŋgɨri iriki memenacna taup ŋgoinna tɨknande.” ");
INSERT INTO gai_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ri, Iesusa 72na mɨnna ramtaɨrmo gaindopatna, “Ramootta nena kam mbarac te, an ramoot, ma aukna kam mbaracrena. Na nemo iŋ neaŋgekna ramoot, ma auk motoco iŋ neaŋnande. Na ma aukmo, iŋ neaŋgekna ramoot, ma Raraŋ Aetaniac motoco, ma iŋ neaŋgapekna. Na an Raraŋ Aetaniac, ma ndo aukmo mbagɨrica aku kɨprina.” ");
INSERT INTO gai_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Iŋmbaia Iesusa mbagɨrica taŋgatna 72na mɨnna ramtaɨrpaikca mac nda kɨpatke, mina toŋgocarica, mina aindopatna, “Kacoot, aia una i ŋgacreke, ŋerŋgaur ŋgorik toco, aina kamma waraca raŋgairena.” ");
INSERT INTO gai_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Mina aindopri, Iesusa aindopatna, “Aku Ramoot Mbɨkmo watrinanna, ma tamuŋna auŋmo, weperac metacri toc, ma an tamuŋna auŋ tɨkcarica gan tiacarpaik mairikat.” ");
INSERT INTO gai_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ri, ma aindopatna, “Warac, aku nenmo gagrarca neaŋrina, ne mɨn. Ne an ramootta wirena nduipapa kaŋur wɨtmo ne kɨtac wɨtɨkna mɨn. Na Ramoot Mbɨk, ma nena puŋndamoot, ne mana gargara mo irikna mɨn. Na Ramoot Mbɨkca moekna reac ianna nemo mo ŋgocraina mɨnna wanaiŋ ŋgoin. ");
INSERT INTO gai_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Na ne gainda kai toŋgo mbop teac, ‘Ŋerŋgaour ŋgorikca aina kam mbaraca raŋgairena.’ Ainda kai mbop teac, kari ŋgoin ndacari. Ne Raraŋ Aetaniacmo toŋgo, ma nena irembmo, ma ndona tamuŋna auŋna timbigta kapca tirca maeacreke.” ");
INSERT INTO gai_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","An mɨn mbuŋa, Ŋeroŋ Ratta Iesusna nikinik ŋgaoca ŋgepca Iesusa toŋgo wiraiacarica, ma gaindopatna, “Raraŋ Aetaniac, u tamuŋna auŋapa gan tiacarpaikna Kacoot. Aintik aku unmo toŋtoŋ ŋgoin, u landamŋina ramtaɨrapa iroar laiŋta ramtaɨrmo, an reik aŋgɨra iŋgorocatke. U ramtaɨra mombonik tekirta kirar ndeacrenanmo, u an reikca minmo wandacrenanna, anna laŋ. Raraŋ Aetaniac, u ndona toŋtoŋa raŋgaica, u ainda morina.” ");
INSERT INTO gai_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Karica Iesusa gaind mac mbopatna, “Aukna Aet, ma an reikca muruŋa aukna para tɨkrina. Na ramoot ianna ma Nuocmo mba lamŋireke. Aetta ma ndo kabe niŋgik manmo lamŋirena. Na ramoot ianna ma Aetmo mba lamŋireke. Nuoca ma ndo kabe niŋgik ndamŋirena, na Nuoca ndo ramtaɨrmo toŋgorenanmo Aetmo wandacrina, na an ramtaɨra, min tiŋgikca ndori Aetta ndamŋinande.” ");
INSERT INTO gai_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Iesusna iŋa raŋgairena ramtaɨra ndori manap eacri, ma nda kumbakeca, minmo watca aindopatna, “Meikramtaɨra nena watrena reikca watreke, mina toŋgorena. ");
INSERT INTO gai_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Aku nenmo gaindopnande, atuna rambca morina ramtaɨr wɨt anik ndeidapa gagrirta ramtaɨr paŋaind wɨt anik ndeidap, mitoca ndorimo an reikca wat ndopatnanna, an reik mandeaca ne watreke, waracrena reik. Mina mba watri, mina mba waracri, wanaiŋ ŋgoin.” ");
INSERT INTO gai_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Karica tɨpemb wandik tamŋirena ramoot ianna, ŋgepca, ndomo Iesusa towai digi ndopca, ma ŋgepca Iesusmo gaind madigiat, “Riripti, aku tida mo te, aku iarwarna eteacna wat laŋ aŋgɨit?” ");
INSERT INTO gai_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Aindopri, Iesusa mamo gaind mac nda rutiatna, “Tɨp Wandɨkna kamma timbigta kap ndeacrenanna, tit ndoprina? U ndo tit mbatrina?” ");
INSERT INTO gai_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Aindopatke, tɨpemb wandik tamŋirena ramootta kam rutica gaindopatna, “U tamuŋna Raraŋ Aetaniac niŋgikca matŋi, ma una Kacoot. U mamo ndona iro nikinikapa, ndona ŋeroŋapa, gargarapa, ndona iro ŋgoin mbuŋa man niŋgik ndamŋi te. U ndona kamkabe motoco, u ndoa matŋia morena tɨp kirara, min motoco u ainda mo.” ");
INSERT INTO gai_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Aindopatke, Iesusa mamo gaindopatna, “Ande. U wandoŋ mambopri. U ainda mo te, u iarwar ndeteacna wat rocot aŋgɨnande.” ");
INSERT INTO gai_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Karica tɨpemb wandik tamŋirena ramootta ma gaind malamŋiat, ŋarikca Iesusa aukmo gaind ndamŋi nari, aukna landamŋiara mɨnna wanaiŋ. Aintik ma Iesusmo ma gaindopatna, “Mandaia aukna kamkabe, na anna mandai ŋgoin?” ");
INSERT INTO gai_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Aindopri, Iesusa mana kam rutica gaindopatna, “Ramoot ianna Ierusalemnan ŋgepca auŋ aniac Ieriko ŋgirikna taŋri. Na macmakɨmna ramtaɨra taupca iŋgoroca eacrinanna, mina laruca mana tik ŋgapaoc aŋgɨratke, manmo pia ŋgocraica. Mina mamo ainda moa ŋgocraica, taup ndiŋa meracarica taŋga maiatke, ma meraca eaca, maica menaca makatat. ");
INSERT INTO gai_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ri, an mɨnna taup ndamootna ramoot ianna, an taup ndiŋa raŋgaia irikatnanna, ma an ramootta watca, ma taup ndiŋa meraca eacri, ma mamo mitaca wattacarica ma aocatitaca mataŋgat. ");
INSERT INTO gai_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","An tɨpna kirara, Liwaina ian toco, an taup ndiŋa nakɨpca an ndaruca, an ramootta watca, mamo mitaca watcarica aocatitaca mataŋgat. ");
INSERT INTO gai_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","“Maniŋa ainda mocarica taŋgatke, Samariana ramoot ianna ndo an taup ndiŋ nakɨpatnanna, kɨpca an ramoot ndambuŋ ndaruca. Ma man mbatca, iro inik mananna mana kakadmai ŋgoin. ");
INSERT INTO gai_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ainda moca ma taŋga mamo utiŋga mana pitirmo tabaɨrapa wainna puk mbuŋa tukia tamaia maica. Karica manmo aŋgɨra ŋgepca ndona doŋkia mbiraca. Karica manmo warkica aŋgɨra taŋga ŋemb ŋgorena kac naaŋgɨra taŋga, mana ŋginaŋa moa eacri. ");
INSERT INTO gai_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Na iŋmbaina ra, ma an ŋembta kacna aetmo kitukndukca ruar mbuniŋna mɨn neaŋgatke. Ma manmo gaindopatna, ‘U gan ramootmo matau raupŋi eac. U mana moca kitukndukca titpaik nakecari te, iŋmbaia aku nda kɨp te, unanmo rutinande.’” ");
INSERT INTO gai_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Aindopri, Iesusa an tɨpemb wandik tamŋirena ramootmo gainda digiatke, “U tit ndamŋire? An ramtaɨr mbonkacmo, mandaia ndo an macmakɨmna ramtaɨra pia ŋgocrairina ramootna kamkabe?” ");
INSERT INTO gai_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ri, ma gainda rutirina, “An ramoot, ma mana kakadmaina opotaca morinan.” Aindopri, Iesusa mamo gaindopatna, “U taŋca an tɨpna kirar ŋgoinna mo.” ");
INSERT INTO gai_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Karica Iesusapa mana iŋa raŋgairena ramtaɨrap, mina taup ndiŋa taŋ, taŋga auŋ ian ndaruca. An auŋna meac ian, mana ia Mata. Na Mata mamo aca tɨkca mamo ndiarna tɨp kirara moca aŋgɨra taŋga ndona kac nagaca mambiracri. ");
INSERT INTO gai_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Na Mata ma ndona lapnameac ianap, mana ia Maria. Na Maria ma kɨpca Kacootna kɨtɨmma mbiraca man mboprina kamb mbaracri, ma manap eacrina. ");
INSERT INTO gai_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ri, Mata taŋga min amna moca amta reikta aiŋir anikca moca taŋ, taŋga ŋateca kɨpca mamo gaindopatna, “Kacoot, aukna lapnameaca aukmo kɨpca otac ŋgocor. Aintik aku ndo kabea moa mataŋreke, u aukna moca lamŋire ki, wanaiŋ? U manmo mbopca ma kɨpca aukmo otaca, aŋga amta reik kocrona.” ");
INSERT INTO gai_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Aindopri, Iesusa mana kam rutica gaindopatna, “O Mata, una paŋanna iroara wɨt ŋgoinapa kakadmaiap. ");
INSERT INTO gai_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Aintik u reac laŋ ianna, iroa mba aŋgɨapeke. Gan reaca Maria aŋgɨna morena reac, anna reac laŋ ŋgoin. Aintik aia mamo an reac aŋgɨna, anna kɨracna mɨnna wanaiŋ.” ");
INSERT INTO gai_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Karica Iesusa taup ianna mbendeia eaca taŋga mbendeia maiatke, mana iŋa raŋgairena ramoot ianna manmo gaindopatna, “Kacoot, u aimo mbendeia momona kamna tɨp kirar ripti, ŋgaua Ionna ndona iŋa raŋgairina ramtaɨra riptirina kirar.” ");
INSERT INTO gai_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Aindopri, Iesusa mimo gaindopatna, “Ne mbendeina mo te, ne gainda mbendei, ‘Ate, i unanmo watcarica ma memetmbaca aina rɨkmo wandoŋ rat ndeacraŋ. Aia toŋgorinanna, una bubuocmo watcarica ma kɨp. ");
INSERT INTO gai_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Memetmbaca u aina amna reikmo u ra, ra katu neaŋraŋ. ");
INSERT INTO gai_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Na meikramtaɨra aimo tɨpemb ŋgorikta makukara moreke, aia mina tɨpemb ŋgorikta makukarmo mo kecarica minmo matau mo, aintik u aina tɨpemb ŋgorikta makukarmo mo kecarica, u aimo totowaira kai watcarica, aimo kai towai teac.’” ");
INSERT INTO gai_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Aindopacarica Iesusa minmo gaind mac mbopatna, “Ŋarikca nena rɨkna ramoot ian, ma ndona aikndamoot laŋ ŋgoinmo, ma mouŋ rɨkniŋ ŋgoinna taŋi laruca ndona aikndamootmo aindop te, ‘Aukna aikndamoot, aku toŋgorinanna, u aukmo tapacar tɨpemb mbonkac pac neaŋ. ");
INSERT INTO gai_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Aukna aikndamoot ianna, taup ndiŋ nakɨp kɨpca, aukna kacnɨm ndaruca, aku mana neaŋamna amta reik kocor.’ ");
INSERT INTO gai_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Aindop te, an kacna inik ndeacrina ramootta gainda rutica mbopnande, ‘U aukmo aiŋ aniaca, kai neaŋi mo teac. Aku tɨŋ kaptikica leacarica ndona mombonikap maŋgoreke. Aku mba ŋgepca unmo amna reac, tɨp ianna mba neaŋitndai!’” ");
INSERT INTO gai_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Karica Iesusa gaind mac mbopatna, “Aku nemo gaindopnande, an kacna aet, ma ndona aikndamootmo ŋatŋaetap. Na ma ŋgepca mana rurina reik maneaŋgat. Ŋarikca manmo mouŋ aniaca reikta ru te, mana ŋgogo katac narica, ma ainda moatna, ma ŋgepca ndona aikndamootna toŋgorina kainta reikmo, mana aikndamootmo aŋgɨri neaŋnande. ");
INSERT INTO gai_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ainda moca aku nemo gaindopnande. Ne Raraŋ Aetaniacmo ndorimo otacna mbendeia digi te, ma nemo otacnande. Na ne ore te, ne watnandet. Na ne manmo ac te, ma nemo waraca ruti te, ne man ndambuŋ nakɨpnande. ");
INSERT INTO gai_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Aintik mandaia digiraŋ te, Raraŋ Aetaniaca manmo memetmbaca neaŋnande. Na mandaia oreraŋ te, ma memetmbaca watnandet. Na mandaia acraŋ te, Raraŋ Aetaniac mamo, waraca rutica ma man ndambuŋ nakɨpnande. ");
INSERT INTO gai_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Ne atera tida moit? Nena ianna mooŋnuoc ian, ma unmo ŋgoaem ian neaŋna digi te, ne mamo nduop ŋgoreac ian aŋgɨri neaŋit ki, co wanaiŋ. ");
INSERT INTO gai_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Co, tida moit? Mooŋnuoca nemo ŋgorac loor ian neaŋna digi te, ne mamo kaŋur ŋgoreac ianna aŋgɨri neaŋit ki, a? An toca laŋa wanaiŋ! ");
INSERT INTO gai_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Mindacniŋ. Na ne ater, ne tɨp ŋgorik wɨt aniaca morena ramtaɨr, na ne ndorita mombonikta ndamŋireke, na ne mimo mataua moreke, mimo reik laiŋ neaŋrena. Ainda moca anna gidik ecte, ne gaind ŋgoin ndamŋi. Nena tamuŋna Aet, ma mandaibinna mbendeica Ŋeroŋ Rat aŋgɨna digi te, ma neaŋnandet!” ");
INSERT INTO gai_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Karica Iesusa ramoot ianna ŋeroŋ ŋgoreac ianna manap eacrenanna, moa kecariatna. Ma manap eacreke, ma mana kam leaca ma kam ndop ŋgocor ndeacrenanna. An ŋeroŋ ŋgoreaca taŋgatke. Ri, an kam kocorta ramootta kam ndopri, meikramtaɨr wɨt aniaca an mbatca tamtam ndamŋirina. ");
INSERT INTO gai_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ri, meikramtaɨr ndeida gaindopatna, “Iesusa ŋerŋgaur ŋgorikca moa kecarirenanna, ma Belsebulna gargar mbuŋa morena. Na Belsebul ma Ramoot Mbɨk. Ma ŋerŋgaur ŋgorikta ramoot paŋan.” ");
INSERT INTO gai_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Aindopri, meikramtaɨr ndeida ndorimo Iesusa towai ndopca, mina mamo ainda digiatna, “U tamuŋna auŋna ŋgagatrac ianna mo te, aia lamŋinande, u Raraŋ Aetaniacna gargarap.” ");
INSERT INTO gai_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Aindopri, Iesusa mina iroara atuna ndamŋica, ma mimo gaindopatna, “Gagrirta ramoot paŋan ianna, mana bubuocna kaŋgauk ndeacrena meikramtaɨra, mina ndorimo rɨkca titaca tumbun mbuniŋ ndaruca ndorica ruŋ te, mina ndorimo mo ŋgocrainande. Co, kamin kabena meikramtaɨra, mina ndorita kɨdrɨkca tumbun mbuniŋa titaca ndorica ruŋ te, mina ndorita kaminna mo ŋgocrainandet. ");
INSERT INTO gai_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Na Ramoot Mbɨkna bubuocna kaŋgauk ndeacrenanda, mina ndorimo tumbun mbuniŋa titaca ndorimo paŋaindamtaɨra moca mo te, ma titocna gargarap eacraŋit? Aria, ne mbop, aku Belsebulna gargar mbuŋa meikramtaɨrta ŋerŋgaur ŋgorikca moa kecarire ki, a? ");
INSERT INTO gai_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Aku Belsebulna gargar mbuŋa morenanna, anna gidik ecte, mandaia ndo nena ndeidmo otaca mina nena ndeidta ŋerŋgaur ŋgorik ŋgotta mandacrina? Nena ndeida ndori nenmo mbopnande, ‘Na man ndoprena kambca, anna gidikca wanaiŋ.’ ");
INSERT INTO gai_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Moca Raraŋ Aetaniaca ndo aukmo an gargar neaŋga, aku ŋerŋgaur ŋgorikca mo kecari te, ne aind ndamŋi, Raraŋ Aetaniacna bubuoca nena kɨdrɨk makɨpri. ");
INSERT INTO gai_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Na ramoot gargar ianna mana lapoiknan aŋgɨca, ndona kac tɨŋa wɨtɨkca anna ŋginaŋa mo te, mana reikca muruŋa laŋ ŋgoin ndeacnandet. ");
INSERT INTO gai_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ma an reikta gagrarmo ndo ŋgopotac ndopca moeknanna, ramoot gargar aniac ianna laruca manap ruŋca manmo pi kɨtac wɨtɨk te, ma mana gagrarca ruŋrena reik aŋgɨ te, ma mana reikmo ramtaɨr ndeida biŋainande. ");
INSERT INTO gai_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Na ramootta aukna aikndamootta wanaiŋ, ma aukmo ndona paŋaindamoota monande. Na ramootta aukmo otaca meikramtaɨrmo, aŋgɨri puni ŋgocor, ma ndo minmo aŋgɨri ootca mina tamtamma taŋ mainandet.” ");
INSERT INTO gai_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Karica Iesusa gaind mac mbopatna, “Moca ŋeroŋ ŋgoreaca ramoot ian tɨkcarica, ma puik kocorta taupca ndo mbukca mbiraca wɨktɨki eacna taupembta kore taŋ, taŋi tambacari te, ma aindopnande, ‘Aku mac nda taŋca ndona atu ndeacrena kac mac nda taŋca, an ndeacna.’ ");
INSERT INTO gai_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Aindopca ma mac nda kɨpca, an kaca wattatnanna anna mina mataua maica laŋ ŋgoin ndeacri. ");
INSERT INTO gai_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ainda moca ma nda taŋga kabena tɨpemb ŋgorik koindara morena ŋerŋgaur parmbaiapa mbut mbuniŋna mɨn naaŋgɨca kɨpca mina an kac ndeacnande. An ŋerŋgaura mina tɨpemb ŋgorikca, mana tɨpemb ŋgorikmo, minanna kunda tamuŋ ŋgoin ndeacrenan, aŋgɨca kɨpca mina an kacna inik ndeac te, an ramootta ma ŋgaua laŋmbai ndeacrenanna. Mandeaca ma kocnai ŋgocrainande.” ");
INSERT INTO gai_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Karica Iesusa an kamb ndopatna mɨn mbuŋa meikramtaɨra muruŋ ndeacatke, ma mbopri mbuŋa, meac ianna mina rɨk ndeacrinanna, ma kam aniac mbuŋa aindopatna, “Gan meac, ma una mɨrca unmo ndona mɨr mbuŋa wirambrina meac, ma toŋtoŋap.” ");
INSERT INTO gai_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Na Iesusa gaindopatna, “Aia gaind ŋgoin ndopnande, ‘Mandaibinna Raraŋ Aetaniacna kam mbaraca raŋgairenanna, mina toŋtoŋgar koindap eacnande.’” ");
INSERT INTO gai_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Karica meikramtaɨr wɨt aniaca Iesus ndambuŋa andu nakɨpri, Iesusa minmo gaindopatna, “Gan mɨnna meikramtaɨr, mina meikramtaɨr ŋgorik, mina ndorimo ŋgagatrac ianna wat garacna, mina ndorimo an nagarac te, anna ndo minmo wandacnande, aku Raraŋ Aetaniacna aiŋna ramoot. Na mina mba ŋgagatrac ianna mba garacitndai, wanaiŋ ŋgoin. Mina ŋgagatrac kabe niŋgik mbatnande, an ŋgagatraca ramma morina ramoot, Iounanan. ");
INSERT INTO gai_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Atua Iouna, ma ŋgagatracna kirar ndaruca, Raraŋ Aetaniac manmo Niniwa auŋ aniacnanda wandacatna. Anna kirara Ramootna Nuoc, ma toca ainta ŋgagatracna kirar ndarunandet, te, Raraŋ Aetaniaca manmo gan mɨnna meikramtaɨrmo an wandacnandet. ");
INSERT INTO gai_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Kaina ra ian, Raraŋ Aetaniac ma ndo meikramtaɨrta makukara waparacna ra laru te, mon tawan ŋgoinna raŋmbaina tiacarpaikna mamaina pitrikna auŋna gagrirta meac ianna ndo kɨpca gan mɨnna meikramtaɨr morena tɨpemb ŋgorikta kirarira wandacnande. Aintik an gagrirta meac paŋan, ma mon tiacarpaikna mamaina auŋ ndeacrenanna, ma ndomo kɨpca Solomonna, ndona landamŋi laiŋta kam ndop te, ma ndomo anna waracna moca anna nakɨpatna. Na nena kɨdrɨk ndeacrena ramoot ian, mana landamŋi laiŋ mananna Solomonna landamŋimo kunda tamuŋmbai. ");
INSERT INTO gai_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Na Niniwananda, atu ŋgoinna mina Iounana mimitpacna kam mbaraca mina anduna iroar inkar ŋgetrikirina. Na ramoot ianna ma aina kɨdrɨk ndeacrenanna, mana gargara Iounana gargarmo kunda tamuŋ ŋgoin ndeacrena. Ainda moca Raraŋ Aetaniac, ma meikramtaɨrta makukara waparacna ra laru te, Niniwana meikramtaɨra mitoco ŋgepca laruca gan mɨnna meikramtaɨr morena tɨpemb ŋgorikca wandacnande.” ");
INSERT INTO gai_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ri, Iesusa gaind mac mbopatna, “Meikramtaɨra mina tac wɨwɨrmo mba aŋgɨri iŋgorocitndai. Na mina mba aŋgɨra tuoŋ kaŋgaukca mba aŋgɨri iŋgorocitndai. Wanaiŋ ŋgoin. Mina aŋgɨri tacna taupca mbirac te, meikramtaɨra an kacnɨm nakɨp mbuk te, mina an tacna memetac mbatnande. ");
INSERT INTO gai_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Una lamnɨaca anna una tikna tac wɨwɨrna kirar. Na una lamnɨaca laŋ ndeac te, mana memetaca una tikmo muruŋ naaŋgɨnande. Na una lamnɨaca ŋgocrai te, una tikca muruŋa nenepucarinande. ");
INSERT INTO gai_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ainda moca u ndona ŋginaŋa mataui mo, moca an memetaca un ndambuŋ ndeacrenanna, moca taŋi nenepu nari. ");
INSERT INTO gai_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Aintik una tikca muruŋa memetacap eac te, una tik umbum ianna mba nenepuca eacitndai. Ainda moca una tikna memetaca bagaraniac ndaruca una tikca muruŋa tac wɨwɨrna memetac nakirar toca, una tikca muruŋa metacarinande.” ");
INSERT INTO gai_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Iesusa kamb ndopca maiatke, Parisina ramoot ianna manmo kɨpca ndoap amna digiri. Ainda moca Iesusa taŋga mana kacna inikca mbukca gagamna taupca mbiraca ambri. ");
INSERT INTO gai_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Na an Parisia, watrinanna ma para tuki ŋgocora ambatke, ainda moca ma tamtam ndamŋirina. ");
INSERT INTO gai_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ri, Kacootta manmo aindopatna, “Ne, Parisiara ne gainda morena, ne tuoŋgourapa kabarmo mina raekrembca mataua tukia ŋgaib tarureke. Na nena inkara, ne macmakɨmapa tɨpemb kirarir ŋgorikca momona mɨnɨŋ koindar. ");
INSERT INTO gai_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Na ne ŋaŋaŋaona ramtaɨr koindar! Na ramootta raekmbaina reikca morenan, ma an inikmbaina reik toco ma mba more ki, a? ");
INSERT INTO gai_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ainda moca reikca inikmbai ndeacrenan, ne anmo reik kocorta ramtaɨr ndaekpembca neaŋ, minmo otac. Ne ainda mo te, nena reikca muruŋa ŋgaib tarunande. ");
INSERT INTO gai_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Na ne Parisiara, ne ndoripembta kadmai! Ne makukara aŋgɨnandet. Ne iniŋpaik, co gagamna raikdar, co ainta warɨŋna ambrena ikir uprirmo, ne muruŋ naaŋgɨca anmo ne nduca parniŋ ndaru te, ne an parniŋ ndarurina kabemo, ne aŋgɨca Raraŋ Aetaniaca neaŋ te. Na ne taup wandoŋ laŋ gidikna kirarapa Raraŋ Aetaniacna matŋirena toŋtoŋna kirarmo ne kecamacariek. Aintik ne an taup wandoŋ laŋapa manmo matŋirena toŋtoŋna tɨp kirarmo, mo gagra te, ne an kabenanmo mba ndarekrekeitndai. ");
INSERT INTO gai_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Na ne Parisiar, ne ndoripembta kadmai! Ne makukar aŋgɨnandet. Ne gainda morena, ne ndorimo Iudananta mimitpac aŋgɨrena kaikta ramtaɨr paŋainda mbiracrena taupemb koinda riaca toŋgo aŋgɨreke. Na ne ndorimo meikramtaɨr punirena taupembta toŋgorena, mimo kɨp te, ndorimo kam laŋ neaŋna moca, ne anna punirena. ");
INSERT INTO gai_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Ne ndoripembta kadmai! Ne makukar aŋgɨnandet. Ne ande gom kɨndik kocorta mukna kirar, meikramtaɨra lamŋi ŋgocora mina an nambatta taŋraŋnande.” ");
INSERT INTO gai_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Aindopatke, tɨpemb wandik tamŋirena ramoot ianna an kam mbaraca, ma Iesusmo nda rutica gaindoprina, “Riripti. U Parisiarmo ainta kam ndopapeke, u ai motocmo mapepereca.” ");
INSERT INTO gai_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Aindopatke, Iesusa mana kam rutica aindopatna, “Ne tɨpemb wandik tamŋirena ramtaɨr, ne ndoripembta kadmai! Ne makukar aŋgɨnandet. Ne toco ne gainda morena. Ne meikramtaɨrmo makukar neaŋga, mina an makuk aniac maaŋgɨreke. Ne ndori koinda nena patŋit ianna mina makukara mba aŋgɨrenanna. ");
INSERT INTO gai_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Na ne ndoripembta kadmai! Ne makukar aŋgɨnandet. Nena nicara atuna rambca morina ramtaɨrmo rɨŋga menacri, na ne min ndamŋina moca, ne mina warir mutocrina taupembca ne ŋgagatraca tɨkrena. ");
INSERT INTO gai_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Na an tɨpembta kirarira ne meikramtaɨrmo an wandacri, nena nicarta ater, mina ndorimo ainda mori, na ne an kirarirmo, laiŋga mori ndopca. Aintik mina rambna ramtaɨra rɨŋga menacri, na ne min ndamŋina moca, mina warir mutocrina taupembmo ne wat garacna reik tɨkrina. ");
INSERT INTO gai_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“Ainda moca Raraŋ Aetaniacna landamŋiapa iro laŋ mananna ma gaindopatna, ‘Aku ndona rambca morena ramtaɨrapa ndona up aŋgɨrena ramtaɨrmo mbagɨrica mina taŋga meikramtaɨra mina ndeidmo mo ŋgoreaca moatke, mina ndeidmo rɨŋga menacatna.’ ");
INSERT INTO gai_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ainda moca an meikramtaɨr wɨt aniaca an kirar ŋgoreacap eacreke, mina rambca morina ramtaɨrmo rɨŋga menacatke, an rɨŋ memenacna tɨp kirara Raraŋ Aetaniaca gan tiacarpaikmo mandeb moca eacri, an makukara an mɨn ndaruca, kɨpca mandeacna mɨn. An tɨp kirara mandeacna mɨnna meikramtaɨra anap eacraŋ te, mina an tɨpembta makukar aŋgɨraŋnande. ");
INSERT INTO gai_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Reac lacaua memenaca Abolna mɨn ndaruca kɨpca, Raraŋ Aetaniacna ramma morina ramoot Sekaraiana memenacna mɨn mbuŋ. An ramoot Sekaraia, mina mamo gɨmbambara morena taupapa Raraŋ Aetaniacna Kacna kɨdrɨkca tɨkca mina anna tɨkca manmo pia menacarina. Anna gidik ŋgoin, na aku nenmo aindopnande, an tɨp ŋgoreacna opoik ŋgoreaca, gan mɨnna meikramtaɨr puŋga larunande.” ");
INSERT INTO gai_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Aindopacarica ma gaind mac mbopatna, “Ne tɨpemb wandik tamŋirena ramtaɨr, ne ndoripembta kadmai! Ne makukar aŋgɨnandet. Ne ande landamŋi laŋ aŋgɨrena taupmo mbuk narica, an leacarica, ne kabena meikramtaɨra ndorimo taŋi mbukca kam laŋ aŋgɨna mo te, ne mina taupemb mboracraŋnande.” ");
INSERT INTO gai_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Karica Iesusa ndona eacrina kac tɨkcarica taŋna moatke, iŋmbaia tɨpemb wandik tamŋirena ramtaɨrapa Parisina ramtaɨrap, mina manmo nikkatta ŋgocraica, mamo digdigiara wɨt aniaca digiatna. ");
INSERT INTO gai_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Mina manmo kam tɨp ŋgoreac ian ndopekna moca, anna towaia digirina. Ma kam tɨp ian katti mbop te, mina anna wat rapacna moca. ");
INSERT INTO gai_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","An kɨdrɨkna inikca meikramtaɨr wɨt aniac ŋgoin, mina kɨpca punica an motemma mɨn ŋgoinna tɨkcarica, anna ndeida, ndeidta our kaoci latac te, labdɨacna mɨn ŋgoin, ainda moca Iesusa ŋgepca ndona iŋa raŋgairena ramtaɨrmo, aindopatna, “Ne Parisiarta isna matau wat, anna mina parua pocpocrena. ");
INSERT INTO gai_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","An tamaia moca eacrena inikna reikca muruŋa larui raekca tɨk te. An iŋgoroca eacrena kamb toco, muruŋa larui raekca tɨkca meikramtaɨra muruŋa waraci lamŋi garacnande. ");
INSERT INTO gai_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Na kainta reikta kambca ne neaupa, tɨkca mboprinanna, an kambmo meikramtaɨra ra tɨki waracnande. Na ne kamb ndeidmo, kac inikca tɨkca lektekarta kam mbuŋa tɨkca mboprena kambca, mina taŋi punirena taupca tɨkca meikramtaɨrmo kam aniac mbuŋa aci mbopnande.” ");
INSERT INTO gai_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Karica Iesusa ndona iŋa raŋgairena ramtaɨrmo gaind mac mbopatna, “Aukna ramtaɨr laiŋ, aku nemo aindopnande. Ne an, tikembca moa menacrena ramtaɨrtarica kai nanambi teac, mina iŋmbaia reac ianna mba moitndai. ");
INSERT INTO gai_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Aku nemo wandoŋ ŋgoinna aindopnande, ne mandai narica ne nanambit. Ne Raraŋ Aetaniac narica nanambi. Raraŋ Aetaniac, ma tikembmo mo menaca menac ŋgocorta iarwara wɨrrena tac nake mbukna gargarap, ainda moca aku nemo gidik ŋgoin ndoprena, ne Raraŋ Aetaniacna moca nanambi.” ");
INSERT INTO gai_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Karica ma gaind mac mbopatna, “Ne lamŋirena, meikramtaɨra ŋgorik tekir parmbaimo mina kituknduk mbuniŋ nocniŋ, mbuŋa an ŋgorik ŋgoikatna. Aintik Raraŋ Aetaniac, ma mba an ŋgorik tekirta ianmo, ma mba ndarekrekeitndai. ");
INSERT INTO gai_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Na Raraŋ Aetaniaca nena paŋaindta lakoarta kirir motocmo, ma nduca maica ma mina ŋgaŋganŋgɨarmo ma malamŋireke. Ainda moca ne kai nanambi teac, nena ŋgaŋganŋgɨara an ŋgorik tekirnoikmo tamuŋ ŋgoin maeacreke.” ");
INSERT INTO gai_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ainda moca Iesusa mimo aind mac mbopatna, “Nena ianna, meikramtaɨrta outta wɨtɨkca aindop te, ‘Aku Iesusmo rɨpacrena.’ Aindop te, Ramootna Nuoc toco ŋgepca taŋca Raraŋ Aetaniacna mbaiŋna aiŋa morena ŋerŋgaurmo aindopnande, ‘Ma aukna ramoot.’ ");
INSERT INTO gai_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Na nena ianna taŋca ndeidta outta wɨtɨkca aindop te, ‘Aku Iesusmo mba rɨpacrenanna,’ aindop te, auk toco ŋgepca taŋca Raraŋ Aetaniacna mbaiŋna aiŋa morena ŋerŋgaurmo aindopnande, ‘Ma auknanna wanaiŋ.’” ");
INSERT INTO gai_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Karica ma gaind mac mbopatna, “Meacramoot ianna, ma Ramootna Nuocmo peperena kam ŋgoreac ndop te, Raraŋ Aetaniaca mana tɨp ŋgoreacna makukmo ma mo kecarinande. Na ramoot ianna, ma Ŋeroŋ Ratmo peperena kam ŋgoreac ndop te, Raraŋ Aetaniaca mana an tɨp ŋgoreacna makukca mba mo kecariitndai. ");
INSERT INTO gai_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Ainda moca mina nenmo Iudananta mimitpac aŋgɨrena kaikta inkar naaŋgɨ mbukca ramtaɨr paŋaindapa, gagrirta ramtaɨr paŋaindta out naaŋgɨri wɨtɨk te, ne kai rugdar moca iroara tamtam ndamŋica gainda kai lamŋi teac, ‘Aia kammo tida tɨki mbopit? Tida tɨki rɨtaci mbopit?’ Ainda kai lamŋi teac. ");
INSERT INTO gai_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","An kɨdrɨk mbuŋa Ŋeroŋ Rat, umo mbopna kamma, ma umo ripti te, u mbopnande.” ");
INSERT INTO gai_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Karica ramoot ianna an tumbun aniacna inikca tɨkca Iesusmo aindopatna, “Riripti, aukna aetta menacatke, tɨkcariatna reik. U aukna lacaumo mbopca u an reikmo titaca aŋnanmo biŋa moca manan tɨkcari te, aukna reikmo neaŋ.” ");
INSERT INTO gai_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ri, Iesusa an ramootmo ainda nda rutica mambopat, “Kaia! Mandaia ndo aukmo oŋna ritri waparac mona larapacrina, te, aku oŋna reikmo biŋa mona?” ");
INSERT INTO gai_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Karica Iesusa an meikramtaɨrmo gaindopatna, “Ne ndoritake, matau wat, moca ne kabena reik mac aŋgɨna toŋtoŋgarap kai eac teac, kari ŋgoin ndacari. Ne reik wɨtap, na an reiki nemo mbibirac eteac laŋa mba neaŋitndai.” ");
INSERT INTO gai_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Karica Iesusa mimo kabena kam roor ianmo gaind nakecatna, “Lamin aniacapna ramoot ian, mana warɨŋ aniac mananna gagam laiŋ koind aŋgɨatke. ");
INSERT INTO gai_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","An lamin aniacapna ramoot, ma ndo mbuŋa ndamŋia taŋga aindopatna, ‘Aku tida moit? Aukna warɨŋna reik tɨkna taupemb kocor.’ ");
INSERT INTO gai_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ma lamŋia taŋga, gaindopatna, ‘Mandeaca aku malamŋica, ndo momona kirarira, aku gainda monande, aku gan amta reik tɨkrena kaik tekir tapica, karica, kaik bagraranikca moca. Ndona warɨŋna witna lourapa kabena amta reik ndeidap, minmo aŋgɨca an kaikta inik naaŋgɨri wembacnande. ");
INSERT INTO gai_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ainda moca aku ndomo aindopnande, aku ndo tik, mandeaca aku amta reikca toc ŋgoin, an amta reikca iarwar ndeacna mɨn. Ainda moca mandeaca aku wɨktɨki eac te, amtiamma moi amraŋ te, toŋgoi werai eacraŋnande.’ ");
INSERT INTO gai_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ri, Raraŋ Aetaniaca manmo aindoprina, ‘U ŋaŋaona ramoot. Na mandeac mouŋ, u menacnandet. Na mandaia ndo an reikta aetta moca an reik aŋgɨ te, anna ŋginaŋa moit?’” ");
INSERT INTO gai_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ainda moca Iesusa aindopatna, “Ainta kirarira meikramtaɨra moraŋnande, ndorimo lamin aniac ndaruna moca aŋgɨra punirenanna, Raraŋ Aetaniacna lamnɨac watreke, mina reik kocorta ramtaɨrta kirarir maeacreke.” ");
INSERT INTO gai_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Karica Iesusa ndona iŋa raŋgairena ramtaɨrmo gaindopatna, “Aku nemo aindopnande, ne an kam roor anna waracapeknanna, ndorita eteacna wat nake, tamtami lamŋica, gainda kai mbop teac, aia kaina reac am te, na ndorita tikemb ŋgapaocna reikmo tida tɨkca aŋgɨrit, na ainda kai lamŋi teac. ");
INSERT INTO gai_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Na nena eteacna watta, ma amna reikmo ma tamuŋmbai ŋgoin ndeacrena, na ma nena tikemb iŋir ŋgapaocna reik motocmo, ma tamuŋ ŋgoin ndeacrena. ");
INSERT INTO gai_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Na ne an ŋgorik kaugacarmo wat. Mina warɨŋa mba morenanna, kaikca mba morenanna, amta reikmo mba aŋgɨra wembacrenanna, wanaiŋ ŋgoin. Raraŋ Aetaniaca ndo minmo raupŋirena, ainda moca ne meikramtaɨra, ŋgorikmo tamuŋmbai ŋgoin ndeacrena. ");
INSERT INTO gai_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ŋarikca nena ianna, ndomo eac rocot ndeacna iro ndamŋia eaceknan, an iroa mamo mba eteac rocot ndeacna wat mananmo, mba aŋgɨri taŋi roctaitndai, wanaiŋ ŋgoin. ");
INSERT INTO gai_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Kaica ne an reik tekirca mona mɨn wanaiŋ, na kaina moca ne reik anikta moca kadmairena?” ");
INSERT INTO gai_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Karica ma minmo gaind mac mbopatna, “Ne mon, kokocarmo wat, min larurena kirarirmo, mina aiŋa mba morenanna, mina mba ndori aoc leacna reikta aiŋa mba morenanna. Aintik aku nenmo aindopnande. Gagrirta ramoot paŋan, Solomon, atua mana aocrina tik ŋgapaocna lamboi mananna taror ŋgoin, mana an lamboirta wapat mananna, gan kokocarta lamboira, mana lamboirta wapatmo kunda. ");
INSERT INTO gai_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ainda moca ainta kaɨtgarta kokocara, anna Raraŋ Aetaniac morina lamboir, mina mba eaci roctaitndai, mina mandeac ndeaca, ŋorapa ramtaɨra waci aŋgɨri tac nake mbukca mina wɨrcarinande. Ainta kaɨtgarta lamboira Raraŋ Aetaniaca minanmo aocrena. Ainda moca ne meikramtaɨra ŋaŋari rɨpac ŋgocortan, ne aind ndamŋi, Raraŋ Aetaniac, ma kaɨtgarta lamboira aocrena, na ma nen motoco lamboira neaŋnande. ");
INSERT INTO gai_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ainda moca ne kai tamtami kadmai lamŋica gainda kai mbop teac, ‘Aia kai ammit, na kaina puk ammit?’ ");
INSERT INTO gai_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Gan tiacarpaikna pitrik waŋgorta meikramtaɨra ndorimo an reik aŋgɨna moca anna ŋgorerenan. Nena toŋgorena reikmo nena Aetta ma lamŋirena, ma nenanmo neaŋnande. ");
INSERT INTO gai_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ainda moca ne Raraŋ Aetaniacmo watcarica ma nena Gagrirta Ramoot Paŋan ndeac te, nena toŋgorena reikca mana bubuocna kaŋgauk ndeacrenanmo, ma nemo neaŋnande.” ");
INSERT INTO gai_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Karica ma gaindap mac mbopatna, “Ne wɨtta wanaiŋ, ne kai nanambi teac. Nena Aet, ma atuna aindopatna, ma nemo toŋgoca mana bubuoca ma nemo neaŋnande. ");
INSERT INTO gai_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Na nena reikmo aŋgɨri tɨkca mina oik te, ne an kitukndukarmo aŋgɨca an reik kocorta meikramtaɨr ndaekpembca neaŋ. Te, ne an tawi ŋgocrai ŋgocorta kitukndukar wembacrena tukut laŋ aŋgɨca, tamuŋna auŋna reik laiŋmo, an mbuŋ naaŋgɨ wembac te, tamuŋna auŋna reik laiŋ aŋgɨ, an reik, mina mba mac tawi maiitndai, na macmakɨmna ramtaɨra mba mac makɨmitndai, na bobodira mba mo ŋgocraiitndai. ");
INSERT INTO gai_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Aintik nena iroar inkar nenanna an reik laiŋ eacrena taupmo, nena toŋtoŋgar toco, an reik laiŋ eacrena taup ndeacnande.” ");
INSERT INTO gai_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Karica Iesusa gaind mac mbopatna, “Ne raraŋitmo wɨŋi gaci matpia, weondor puŋga leaci paŋpaiŋica tacaɨr watɨki utiŋa kocroca lambiraŋ. ");
INSERT INTO gai_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ne gan aiŋna ramtaɨr lambia eacrena kirar ndabi, mina ndorita kacootna lambia eacri, ma an laŋtaŋgo ianna amna reacna taŋgatnan, ma an tɨkcarica, ma mac nda kɨpca tɨŋa pi te, mana aiŋna ramtaɨra lambia eacrenanna tawina tɨŋmo gootnande. ");
INSERT INTO gai_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","An mbaiŋna ramtaɨr, minanna kacootna moca aind nakocroca lambi te, mina kacootta mac nda kɨpca minmo aind mbat te, mina toŋgonande. Ainda moca aku nemo gidik ŋgoinna aindopnande, an kacoot, ma ndona raraŋitmo, wɨŋi leaca ndona mbaiŋna ramtaɨrmo mbopnande, ne taŋca gagamna taupca mbirac, aindopca mina mbirac te, ma ndo ŋgoinna ŋgepca amta reik aŋgɨca minmo biŋainande. ");
INSERT INTO gai_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","An mbaiŋna aiŋa morena ramtaɨra mina ndorita kacootna ndabia taŋ, taŋga mouŋ rɨkniŋa tɨkca, outna kackur keatke, an mɨn mbuŋa mina kacootta kɨpca mimo wattatnanna, mina kocroca lambia eacrina ramtaɨr. Aintik mina ndorita kacoot mbatca mina toŋgocarica. ");
INSERT INTO gai_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Ainda moca ne matau lamŋi, kacna aet ma lamŋi te, kaina kɨdrɨkca macmakɨmna ramoot makɨpnande. Te, an kacna aet, ma mba watcarica macmakɨmna ramootta mana kaca mba gacitndai. ");
INSERT INTO gai_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Aintik ne toca kocro, oit ianna ne lamŋi ŋgocor ndeac te, Ramootna Nuoca kɨpnande.” ");
INSERT INTO gai_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Karica Pita Iesusmo gainda digiatna, “Kacoot, u gan kam roormo, ai niŋgik ndopapekna ki, co, u meikramtaɨrmo, muruŋ ndopapekna?” ");
INSERT INTO gai_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Aindopri, Kacootta aindopatna, “Titna mbaiŋna aiŋa morena ramoot paŋan, ma ndona aiŋna landamŋia mataua aŋgɨca morena ramoot? Ainta mbaiŋna aiŋa morena ramootta, ramoot paŋanna, ainta ramootta matŋirena, ma ainta, ramootmo aŋgɨca ndona mbaiŋna aiŋa morena ramtaɨrta ramoot paŋanna tɨknande, mamo ndona mbaiŋna aiŋa morena ramtaɨrta amna reacna ŋginaŋa mona moca, ramoot paŋanna ndo minmo amna reac neaŋ ndop te, ma mimo amna reac neaŋnande. ");
INSERT INTO gai_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ainta mbaiŋna aiŋa morena ramoot, mana ramoot paŋanna kɨpi wateknanna, an mbaiŋna aiŋa morena ramootta mana neaŋgatna aiŋmo toŋtoŋ ŋgoinna moraŋ te. ");
INSERT INTO gai_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Aintik aku kam gidik ŋgoin ndoprena, ainta mbaiŋna aiŋa morena ramoot, mana ramoot paŋanna, ma an ndona reikmo mana para tɨkca ma mananmo watta monande. ");
INSERT INTO gai_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Aintik an mbaiŋna aiŋa morena ramoot, mana iro ma gaind ndamŋiatna, ‘Aukna ramoot paŋanna, ma mba mac tawi kɨpitndai,’ ma ŋgepca, an mbaiŋna aiŋa morena meikapa ramtaɨr ndeidmo, tamtamma pi te, ma amna reik am te, puk ammi ŋaŋaoraŋnande. ");
INSERT INTO gai_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Na an kɨdrɨkca an mbaiŋna aiŋa morena ramoot, ma ndona ramoot paŋanmo nda kɨkɨpa lamŋi ŋgocor ndeac te, na ramoot paŋanna oit ianna ma kɨp te, an mbaiŋna aiŋa morena ramoot, ma ramoot paŋan kɨkɨpa lamŋi ŋgocor. Ainda moca an ramoot paŋanna, an mbaiŋna aiŋa morena ramootmo pia ŋgocraica manmo mandaci taŋca ma an kam mbarac ŋgocorta ndeidap eacnande. ");
INSERT INTO gai_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“An mbaiŋna aiŋa morena ramootta ma lamŋirena, mana ramoot paŋanna mamo mona ndopatna mana toŋtoŋna reikca an mbaiŋna aiŋa morena ramootta mana ramoot paŋanna mbopatna mana toŋtoŋna reikmo kocro mai ŋgocor, ainda moca an mbaiŋna aiŋa morena ramootmo, mana ramoot paŋanna mamo pi ŋgoreac ŋgoinna pinande. ");
INSERT INTO gai_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Na aiŋna ramoot, ma ndona ramoot paŋanna mo ndopekna reikca ma lamŋi ŋgocor, ma anna gɨrgɨr aŋgɨna to ŋgoin, na mana ramoot paŋan kɨp te, ma manmo mba pi ŋgoreaca mba piitndai. Na meikramtaɨra mandaia reik wɨt aniac aŋgɨrinan, an meikramtaɨr mina manmo an reik wɨt aniac mac nda rutinande. Na meikramtaɨra ramoot ianmo reik wɨtta mana para tɨk te, mina manmo mac nda rutina ŋgacnandet.” ");
INSERT INTO gai_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Iesusa gaind mac mbopatna, “Aku gan tiacarpaikmo, tac kena nakɨprina, aku toŋgorinanna tac anna tawina wɨr. ");
INSERT INTO gai_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Mandeaca aku kɨtac puk, kirar dam ian aŋgɨnande. Ainta kɨtac pukca ma ramootmo aia puk mbuŋa kɨtacrena kirar, an kirara makukara kɨpca aukmo kɨtacnandet, na aku mba aŋgɨreke, ainda moca aukna iro inikca makuk ŋgoin ndeacrena. Taŋi aku an kɨtac puk aŋgɨnande. ");
INSERT INTO gai_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ainda moca ŋarikca ne gaind ndamŋi nari. Aku gan tiacarpaikna runduikca mo menacna kɨprina. Wanaiŋ ŋgoin! Aku kɨprinanna, aku gan tiacarpaikna meikramtaɨrmo, rɨkniŋa titacnande. ");
INSERT INTO gai_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Mandeacna mɨn mbuŋa, kaiknimbca parmbaiapnanna, mina tɨpniŋa titaca mbonkaca mina mbuniŋmo ndorimo ŋateca titaca dammbai ndeac te, mbuniŋa maniŋ toco mbonkacmo titaca dammbai ndeacnande. ");
INSERT INTO gai_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Na aetapa mana nuoc, maniŋ toco titacnande. Na nuoc ma ndona aetmo ŋateca titaca dammbai ndeac te. Na nuocna aet, ma toco ndona nuocmo ŋateca titaca ma toco dammbai ndeacnande, na aemmapa mana mooŋ, maniŋ toco titacnande. Mooŋa ndona aemmo ŋateca titaca dammbai ndeac te. Na aem toco, ndona mooŋ motocmo, ŋateca titaca dammbai ndeacnande, na an aem, ma ndona tamooŋap, ŋateca titaca dammbai ndeac te, mana tamooŋ toco ŋgepca ndona kaŋgaitna aemmo ŋateca titaca dammbai ndeacnande.” ");
INSERT INTO gai_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ainda moca Iesusa meikramtaɨrmo gaindopatna, “Ne ainda morena, dimira ra itirik ndiŋ nagac te, ne aindopnande, pukca rapacna mamoek. Aindop te, gidik ŋgoinna pukca andu rapacnande. ");
INSERT INTO gai_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Na ne wat te, watta raŋmbai ndiŋ naŋgep te, ne aindopnande, mandeaca ra owaicarinande, aindop te, gidik ŋgoinna ra owaicarinande. ");
INSERT INTO gai_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ri, ma minmo aindopatna, ne parua pocpocrena meikramtaɨr koindar, ne gan pitrikna reikapa, riac tamuŋna reikca ne mina mɨniŋga mataua lamŋireke, titoca moca ne gan mɨn ndarurena reikta, mɨniŋga lamŋi ŋgocor?” ");
INSERT INTO gai_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Karica Iesusa gaind mac mbopatna, “Tida moca ne ndori koinda reikmo ŋaŋari wati garaci lamŋi rapac ŋgocor, ma laŋ co laŋa wanaiŋ? ");
INSERT INTO gai_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ainda moca meacramoot ianna umo ritri waparacna ramoot ian ndambuŋ naaŋgɨ taŋna moca oŋgo taŋraŋ te, u mamo taupca tɨkca an reac wandoŋaina moca, mamo tawi digi, ŋarikca, ma unmo ritri waparacna ramoot ndambuŋ naaŋgɨ taŋca ma unmo piraŋna para tɨkca, moca piraŋa unmo aŋgɨca kac ŋgoreaca tɨk nari. ");
INSERT INTO gai_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Aku unmo gidik ŋgoinna aindopnande, unmbaia, mba mac tawi nda laruitndai, u an kac ŋgoreacna inik ndeacraŋ te, an kitukndukna ŋgaŋganŋgɨa mina tɨkrina mɨnna, u an kac ŋgoreac ndeacraŋ te, u oikraŋnande, taŋi u muruŋa kocnaia oiknande.” ");
INSERT INTO gai_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Karica Iesusa kam ndopca maiatke, meikramtaɨr ndeida manmo Galilina ramtaɨr ndeid tarurina kirarirta nininia ainda ninirina. Galilina ramtaɨra Raraŋ Aetaniacmo gɨmbamba morina mɨn mbuŋa, ramoot paŋan Pailat, mana lapoca ruŋrena ramtaɨrmo mbagɨrica mina minmo rɨŋga mamenacat. Na mina racainda gɨmbambara morina ŋgoaebta racaind tambat ŋgirikca anap kuririna. ");
INSERT INTO gai_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ri, Iesusa mina kam rutica aindopatna, “Ne tit ndamŋirena, an tɨp kirara Galilina ramtaɨrmo laruapeknanna, ne gaind ndamŋire ki? An ramtaɨra, mina tɨpemb ŋgorikta makukara morenanna Galilina meikramtaɨr ndeidmo moa kundre ki? Anna mɨnɨŋa ndo minmo laruapek ki, a? ");
INSERT INTO gai_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Wanaiŋ ŋgoin, aku nemo wandoŋ ŋgoin ndopnande, ne muruŋa ndorita iroar inkara ŋgetriki ŋgocor, ne toco an ramtaɨr ŋgocrairina kirar naaŋgɨnande. ");
INSERT INTO gai_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Karica ma gaind mac mbopatna, an 18na mɨnna ramtaɨrmo ŋgaua Siloamna kɨdrɨkna kac tamuŋ rocot aniaca witkica min tambat ŋgirikca mimo moa menacatnanmo, ne tit ndamŋire? Ne gaind ndamŋire ki? An ramtaɨr, mina morina tɨpemb ŋgorikca wɨt aniac ŋgoin, an Ierusalemna inik ndeacrena meikramtaɨrmo, moa kundapek ki, a? ");
INSERT INTO gai_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Min ainda wanaiŋ ŋgoin, aku nemo wandoŋ, ŋgoin ndopnande, ne ndorita iroar inkara ŋgetrikica eac ŋgocor, ne toco min ŋgocrairina kirar naŋgocrainande.” ");
INSERT INTO gai_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Karica Iesusa kam roorna ninini ianmo gaind nakecatna, “Ramoot ian, ma ndona ik ŋgaŋɨnmo, ndona wainna warɨŋ inikca mutoca eacrenanna. Iŋmbaia ma mac nda taŋca an ŋgaŋɨn lourta koreatnanna lour kocor, kamaind ŋgoin. ");
INSERT INTO gai_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ainda moca mana warɨŋ raupŋirena ramootmo aindopatna, ‘U warac, iarir mbonkac ŋgoin maiapeke, aku mac nda kɨpca an ŋgaŋɨn lourta orerea tambca mana lour kocor, ma mba erri. Kaina moca ma tiacarpaikna waimo wanaiŋ naaŋgɨrena? Aintik u mamo wac kecari.’ ");
INSERT INTO gai_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Na an warɨŋ raupŋirena aiŋna ramootta mana kam rutica aindopatna, ‘Ramoot paŋan, manmo watcarica ma iar kabe ian ndeac te, aku mana mɨnɨŋna tiacarmo au iaca bulmakaona lo aŋgɨ tɨki aupa watna. ");
INSERT INTO gai_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ainda moca an ŋgaŋɨn ikca iŋmbaina iara ma er te, laŋ, na ma er ŋgocor ndacari te, u mamo wacmandac.’” ");
INSERT INTO gai_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Wɨktɨtɨkna Ra ianna Iesusa meikramtaɨrmo Iudananta mimitpac aŋgɨrena kac ianna inikca mbukca anna tɨkca mimitpac neaŋrina. ");
INSERT INTO gai_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ri, meac ianna an inik ndeacrinanna, ma ŋeroŋ ŋgoreac ianap. An ŋeroŋa manmo ŋgaua roumb neaŋga ma an roumbapmo eaca iarira 18na mɨn, an roumbca manmo, ainda moca mana kopikna gagara gepaica ma wandoŋa mba taŋrenanna. ");
INSERT INTO gai_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Karica Iesusa an meacmo watca, ma an meacmo ndo ndambuŋ ŋgaca kɨpca mamo aindopatna, “Meacmbitac una roumbca aku moa kecamacariri.” ");
INSERT INTO gai_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ainda moca Iesusa ndona parmo an meac nambatta tɨkatke, an meaca anduna naŋgepca wandoŋa wɨtɨkca ma Raraŋ Aetaniacna i aŋgɨa ŋgepatna. ");
INSERT INTO gai_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ri, an Iudananta mimitpac aŋgɨrena kacna ramoot paŋanna, Iesusmo nikkatacariatna. Iesusa an meacna roumbmo Raraŋ Aetaniacna Wɨktɨtɨkna Rana inik mbuŋa moa laŋa moca. Ainda moca ma an meikramtaɨrmo, aindopatna, “Nena aiŋa momona raia parmbaiapa mbut kabe, na an raita inikca tɨki moi laŋa mona kariatna? Kaina moca ne Raraŋ Aetaniacna Wɨktɨtɨkna Rana inikmo, ne kabena ramootmo ndorita roumbbeba moi laŋa mona moca digirena?” ");
INSERT INTO gai_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Aindopatke, Kacootta mana kam rutica aindopatna, “Ne an meikramtaɨr, ne parua pocpocrena meikramtaɨr koind, ne muruŋa ndorita mboprena kambapa ndorita morina kirarira ne mba raŋgairenanna, ne memetmbaca ne Raraŋ Aetaniacna Wɨktɨtɨkna Raimo ne taŋga ndorita bulmakaorapa doŋkiarta kaikca taŋga minmo puk amna naaŋgɨra taŋrena. ");
INSERT INTO gai_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Na gan meaca aku moa laŋa mocapeknanna, anna Abraamna ŋgamaɨr ian, Ramoot Mbɨkca manmo roumb mbuŋ leaca tɨkca eaca, iarira 18na mɨn, na aku an roumbca mo kecari te, tida moca, anna ŋgoreaca wanaiŋ, mana roumbmo Raraŋ Aetaniacna Wɨktɨtɨkna Ra tɨki moi laŋa mo te, kaica?” ");
INSERT INTO gai_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Iesusa an kam ndopatke, manmo paŋaindamtaɨra morenanna, mina muruŋa numbir koinda mocaricatke. Na anna meikramtaɨr wɨt anikca mina muruŋa Iesus moapekna reik laiŋga watca, mina toŋtoŋgar koindap. ");
INSERT INTO gai_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Karica Iesusa gaind mac mbopatna, “Raraŋ Aetaniacna bubuoca titocna reacna kirar? Na aku nemo kai mbuŋa an bubuocna iro wandacit? ");
INSERT INTO gai_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Raraŋ Aetaniacna bubuocna kirara, ik mastetna loorna kirar, ramoot ianna an ik loor ianmo ndona warɨŋmo mutoca iŋmbaia ma gaci ikna kirara aniaca mo te. Raŋna ŋgocraikca mana ŋaikmo kaikca moraŋnande.” ");
INSERT INTO gai_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Karica Iesusa gaind mac mbopatna, “Kaina reac mbuŋa aku Raraŋ Aetaniacna bubuoc wandacit? ");
INSERT INTO gai_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Mana ŋgagatraca isna kirar, meac ianna an is aŋgɨca witna kapɨrta kɨndɨb mbonkacmo isap tɨki kuri te, iŋmbaia ma urica gaca bagaraniaca monande.” ");
INSERT INTO gai_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Karica Iesusa an kam ndopca maica, ma ŋgepca Ierusalemma taŋrena taup ndiŋa taŋga an inikna auŋemb tekirapa auŋemb anikta inikca mbukca anna meikramtaɨrmo mimitpac neaŋrina. ");
INSERT INTO gai_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Karica ramoot ianna manmo ainda digiatna, “Kacoot, Raraŋ Aetaniaca ramoot mbatepeniŋ niŋgik mac nda aŋgɨit ki?” Aindopri, Iesusa manmo gainda rutiatna, ");
INSERT INTO gai_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Ne ndorita gagrar puŋga an tɨŋ tekera mbukna towai paŋpaiŋi. Aku nenmo aindopnande, meikramtaɨr wɨt aniaca ndorimo an tɨŋa mbuk ndopca morenanna mina toa mba tɨkitndai. ");
INSERT INTO gai_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ainda mo te, an kacna aet, ma ŋgepca kacna tɨŋ aŋgɨri kaptiki te. Ne raekca wɨtɨkca ne ŋgepca taŋi tɨŋa pica aindop te, ‘Kacoot aimo tɨŋ goot,’ te, ma nena kammo gainda rutinande, ‘Aku nenmo lamŋi ŋgocor, ne ten ndiŋ nakɨprina?’ ");
INSERT INTO gai_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Na ne mamo aindopnande, ‘Aia unapmo, pukapa amna reac ambatke, u aina punirena taupembca wɨtɨkca aimo ririptina kam ndopatna.’ ");
INSERT INTO gai_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ri, ma nenmo gainda rutinande, ‘Aku nenmo lamŋi ŋgocor, ne tenmbai ndiŋ nakɨprina, auk ndambuŋa kai kɨp teac, ne kacrep. Ne tɨpemb ŋgorikca morena meikramtaɨr.’ ");
INSERT INTO gai_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Aindop te, anna inikca ne watnande, Abraamapa, Aisakapa, Iakopapa rambca morina ramtaɨrap, ne Raraŋ Aetaniacna bubuocna kaŋgaukca, tɨki watnande. Te, nenmo oot mandaca ne raek ndeac te. Ne ndaɨr iriki ikca aeraŋnandet. ");
INSERT INTO gai_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ainda mo te, meikramtaɨr, mina ndorita pitrikar kecarica mina kɨpnande, ndeida ra gagacait ndiŋ nakɨp te, ndeida ra itirikcait ndiŋ nakɨp te, ndeida maŋarmbai ndiŋ nakɨp te, ndeida raŋmbai ndiŋ nakɨpnande. Kɨpi maica mina Raraŋ Aetaniacna bubuocna kaŋgaukna amtiam ndeacnande. ");
INSERT INTO gai_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Na ne matau warac, mandeaca, mandaibinna, mina iŋ ndeacrenan, mina taŋi outmbaica tɨk te, an out ndeacrenan, mina taŋi iŋmbaia tɨknande.” ");
INSERT INTO gai_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","An kɨdrɨk ŋgoin mbuŋa Parisina ramtaɨr ndeida kɨpca Iesusmo aindopatna, “U ŋgepca gan auŋ tɨkcarica u kabena taupca taŋ. Ierusalemna gagrirta ramoot paŋan Erotta, una mo menacna moca mamoreke.” ");
INSERT INTO gai_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ri, ma minmo rutica aindopatna, “Ne taŋca an raŋna piraŋ kunmo aindop, ‘Mandeacapa ŋorapa, aku ŋerŋgaur ŋgorikapnanmo mo kecari te, roumbbebta meikramtaɨrmo moi laiŋga monande, rarapmbaia aku ndona aiŋir kocnai korwinande.’ ");
INSERT INTO gai_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ainda moca aku mandeacapa, ŋorap, co rarap, aku moca taŋraŋnande. Gidik ŋgoin, ramma morena ramootta mina mamo kabena auŋa tɨki, mo memenaca laŋa wanaiŋ, ma Ierusalemna inik ŋgoin ndeac te, mina mamo anna tɨki mo menacnande.” ");
INSERT INTO gai_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Ri, ma aindopatna, “O Ierusalem, Ierusalem, u Raraŋ Aetaniacna rambca morena ramtaɨrmo mo menacri, an mandaca kɨprina ramtaɨrmo watur puŋga rɨŋga menaca mamairi. Memetmbaca aku una mombonikca kackur aemma ndona mombonikmo aŋgɨca tumbunna tɨkna kirara moreke. Na ne mba toŋgorenanna. ");
INSERT INTO gai_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Na ne warac, aku nemo wandoŋ ŋgoin ndopnande, ‘Nena auŋa ŋgocrai te, ma kocnai ŋgocrainande.’ Na aku nemo gainda wandoŋ ŋgoinna aindopnande, ne aukna inpaŋanna mba watitndai, taŋ, taŋi, mana mɨn ŋgoinna tɨk te, ne aindopnande, ‘Raraŋ Aetaniac u an ramootmo toŋgo, ma Kacootna i mbuŋ nakɨprina ramoot.’” ");
INSERT INTO gai_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Wɨktɨtɨkna Ra ianna, Iesusa Parisiarta ramoot paŋan iannap amna moca mana kacmo amna taŋgatke, an ndeacrina meikramtaɨr, mina mana ŋginaŋ mamori. ");
INSERT INTO gai_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Na ramoot ianna mana tikca upurina roumbap eacrinanna, ma Iesusna kɨtɨm ndeacri. ");
INSERT INTO gai_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Na Iesusa manmo wattacarica, ma ŋgepca tɨpemb wandik tamŋirena ramtaɨrapa, Parisiarmo gainda digiatna, “Tɨp Wandɨkca titoc ndoprina, aia meikramtaɨrta roumbbebmo, Wɨktɨtɨkna Ra tɨki moi laiŋga moit ki, wanaiŋ?” ");
INSERT INTO gai_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ma aindopatke, mina kam ianna mba rutiatke, mina kam kocora mbiracariatke, Iesusa ŋgepca an ramootmo, aŋgɨca manmo moa laŋa moca ma mataŋgat. ");
INSERT INTO gai_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Karica ma minmo gaind mambopat, “Nena ianna mooŋnuoc ian co, nena ianna bulmakao ian, ma Wɨktɨtɨkna Ra, aua puk te, ne tida moit? Ne watcarica Wɨktɨtɨkna Ra mai te, ne taŋca aŋgɨrit ki? Ki, ne anduna ŋgepca taŋca aŋgɨrit?” ");
INSERT INTO gai_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ri, mina mana kam ruti, mbopna mɨnna wanaiŋ. ");
INSERT INTO gai_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ainda moatke, Iesusa an Parisina ramootta mbaiŋ tɨkrina ramtaɨrmo watri, mina ndorimo irembta ramtaɨr mbiracrena taupemb laiŋ aŋgɨna moca anna riacri. Na ma minmo muruŋa kam roor ian mbuŋa gaind makeat, ");
INSERT INTO gai_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Moca ramoot ianna ma nemo laŋtaŋgo ianna amtiam ianna amna mbaiŋ tɨk te, ne taŋ te. Ne taŋca kai outmbaina taup laŋa kai aŋgɨ teac. Moca mina an taupmo ramoot ianna irembta ramoot, mana ia nena irembmo tamuŋmbai ndeacrena ramoot, man mbiracna moca tɨkca larapacrina taupca, u anna mbirac te. ");
INSERT INTO gai_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ŋarikca iŋmbaia moca unmo mbaiŋ tɨkca kɨprina ramootta, ma kɨpca unmo aindop nari, ‘U an mbiraca eacrena taup kacrepca, an irembta ramootta mbiracna.’ Aindop te, u numbira moca mac nda taŋi, an iremb kocorta ramtaɨr mbiracrena taupca, u anna taŋi mbiracnande. ");
INSERT INTO gai_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Na ramoot ianna umo amna mbaiŋ tɨk te, u taŋca mbiraca amna taupmo iŋmbai ŋgoinna taŋi mbirac. U ainda mo te, an kacnɨmna aetta kɨpi unmo watca aindopnande, ‘Aukna ŋem ndamoot, u ŋgepca taŋi, outmbaica mbirac.’ An kacna aetta, ma umo kabena ŋembta outta ainda mo te, an kirar mbuŋ, mina una i aniacmo aŋgɨri ŋgepnande. ");
INSERT INTO gai_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Aintik meikramtaɨra ndorita iremb aŋgɨra ŋgeprenan, ainta meikramtaɨra Raraŋ Aetaniaca ma mina irembmo aŋgɨ iriknande. Na ne meikramtaɨra mandaia ndorita iremb aŋgɨra wɨkɨnna tɨkrenan, Raraŋ Aetaniaca mina irembmo, aŋgɨri ŋgepca tamuŋmbaia tɨknande.” ");
INSERT INTO gai_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ainda moca Iesus, ma ndo ŋgaca kɨpca ambatna kacna aetmo aindopatna, “U amna reac aniac ianna mo ndop te, ndona aikorapa, ndona laiplacarapa, ndona racaind kabenandapa, ndona auŋ kabenanda reik wɨtna meikramtaɨrmo, mbaiŋa kai tɨk teac, u ainda mo te, moca mina una amta reik mac nda ruti nari. ");
INSERT INTO gai_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Na u ainda mo narica mo te, u gainda mo, u amna reac aniac ianna mo te, u reik kocorta ramtaɨr ndaekpembapa, tikemb iŋir ŋgorikcapa, orapaɨr ŋgorikcapa, lamnik ŋgorikapnanmo mbaiŋ tɨk. ");
INSERT INTO gai_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","U ainda mo te, u anna opotac aŋgɨnande. Ainta meikramtaɨr, mina una amta reik anik mac nda rutina mɨnna wanaiŋ, iŋmbaia Raraŋ Aetaniaca rɨpaca menacatna meikramtaɨr wandoikca Raraŋ Aetaniacna kam mbaraca muk ŋgetacndiŋ mac nda ŋgep te, Raraŋ Aetaniaca una moatna opoikca mac nda rutinande.” ");
INSERT INTO gai_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","An mɨn mbuŋa ramoot ianna an inikca mbiraca eacrinanna, Iesusmo aindopatna, “An meikramtaɨr, mina Raraŋ Aetaniacna bubuocna kaŋgauk nakɨpca ambeknan, an meikramtaɨr, mina toŋgoca weperai aniac ŋgoin ndeacnande!” ");
INSERT INTO gai_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ri, Iesusa manmo gaindopatna, “Ramoot ianna amtiam aniac ianna morinanna, ma meikramtaɨrmo muruŋ ŋgoinna mbaiŋ tɨkrina. ");
INSERT INTO gai_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Karica an amtiam aniacna amna ra laruri, ma ndona mbaiŋna ramoot mbagɨrica ma taŋga an meikramtaɨrmo mbopca taŋri, ‘Ne kɨpca taŋca amna. Amta reikca muruŋ nakocroca mamairi.’ ");
INSERT INTO gai_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Na an meikramtaɨr, mina muruŋ an naŋgepca aindopatna, ‘Aia mba taŋitndai.’ Na ianna out naŋgepatna ramootta aindopatna, ‘Aku mba taŋitndai, aku ndona oikatna warɨŋa watna taŋnande. Aintik u taŋca ndona kacootmo aukna kakadmaina kamma manmo mbop warac.’ ");
INSERT INTO gai_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ri, ian tuk ŋgepca ndona aiŋna kamma an mbaiŋna ramootmo aind mambopat, ‘Aku bulmakaor parniŋna mɨnpaik ŋgoikca, ainda moca aku mina towaina moca mataŋgek. Aintik u taŋca ndona kacootmo aukna kakadmaina kamma manmo mbop warac.’ ");
INSERT INTO gai_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ri, kabena ian tuk ŋgepca, aindopatna, ‘Aku mandebanna laŋgoca aku mba kɨpitndai.’ ");
INSERT INTO gai_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Ainda moca an mbaiŋna ramootta mac nda taŋga ndona kacootmo an kamb, ndopatke, an kacna aetta an kamma waraca ma nikkattarica ŋgepca ndona mbaiŋna ramootmo aindopatna, ‘U tawi ŋgoin motemma taŋca mon taupemb ŋaik tekirapa, taupemb anikta auŋembta reik kocorta ndaekpembapa, tikemb iŋir ŋgorikcapa, lamnik ŋgorikcapa orapaɨr ŋgorikapnan, ainta meikramtaɨrmo mbopca minmo aŋgɨca aukna kac naaŋgɨ kɨp.’ ");
INSERT INTO gai_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Ri, an mbaiŋna ramootta ainda mocarica, ma aindopatna, ‘Kacoot, una kam ndiŋa aku ainda morinanna, kacna inikca mɨnna tɨk ŋgocor, kabenan mac mbukna taupca mɨn maeacreke.’ ");
INSERT INTO gai_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ainda moca kacootta manmo mac nda mbagɨrica aindopatna, ‘U taŋca auŋ raekmbai ndeacrena taupemb anikapa taupemb tekirta wuoc roumb ndiŋa taŋca minmo wat te, gagrai mbopca mina kɨpca aukna amtiam am te, kac inik auknanna mbuki mɨnna tɨkna. ");
INSERT INTO gai_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Aku nemo aindopnande, aku ŋgaua mbaiŋ tɨkca tambacariatna meikramtaɨr, mina aukna amtiam aniacna am emtemma mba amitndai, wanaiŋ ŋgoin.’” ");
INSERT INTO gai_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Meikramtaɨr wɨt anikca ŋgepca Iesusap taŋri, na ma nda kumbakeca mimo aindopatna, ");
INSERT INTO gai_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“U mandaia aukna iŋa raŋgairena ramootta mona mo te, u aukca matŋirena an mamatŋi anna, ma una amepaetapa, una meacapa, una mombonikapa, una laiplacarapa, una mbiarapa, u ndo ŋgoinap matŋirena an mamatŋimo, ma kunda tamuŋ ŋgoin ndeacnande. Na wanaiŋ ecte, u aukna iŋa raŋgairena ramootta mba eacitndai. ");
INSERT INTO gai_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Na u mandaia ndona kekeracna iknan aŋgɨca aukna iŋ nakɨp ŋgocor, u aukna iŋa raŋgairena ramootta wanaiŋ. ");
INSERT INTO gai_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Ainda moca ne mandaia ndomo kac aniac ianna mona mo te, out ŋgoinna ma mbirac an iroar tɨki aŋgɨca, kitukndukna ŋgaŋganŋgɨa, mo laruca titpaik ŋgoin ma an aiŋa moi korwit. ");
INSERT INTO gai_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ainda moca an ramoot, ma out ŋgoinna, ma ainda mo ŋgocora mo te, ma kac iac ikca, mo taŋi ikir maica, an kacmo kikirpaika tɨkcari te, meikramtaɨra aindopnande, ‘Ma ramoot borbor ŋgoin.’ ");
INSERT INTO gai_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Mina aindopnande, ‘Gan ramootta kacmo aŋgɨra wɨtɨkapenanna, ma mba moa korwiapeke.’ ");
INSERT INTO gai_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Na gagrirta ramoot paŋan ianna kabena gagrirta ramoot paŋanap, ruŋna mo te, ma mbiraca lamŋinande, aukna lapoca ruŋrena ramtaɨra 10,000na mɨn. Na manap ruŋrena lapocna ramtaɨrta mɨnna 20,000na mɨn. Ainda moca ma mbirac pac lamŋinande, ma an gagrirta ramoot paŋanap ruŋna mɨn ki, mɨnna wanaiŋ? ");
INSERT INTO gai_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ma lamŋi taŋga ma mɨnna wanaiŋ te, mana puŋndamootta mon tawan ŋgoin nakɨpraŋ te, ma ndona ramtaɨr ndeid mbagɨrica mina taŋca an puŋndamootmo nikkat narica kam wetwet laŋ mbuŋ ndopca taŋga mamo mbopnande, ‘Aŋga kai ruŋ teac.’ ");
INSERT INTO gai_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","“Na ainta kirar kabe, ne mandaia ndona reikmo iŋ neaŋ ŋgocor, ne aukna iŋa raŋgairena ramootta wanaiŋ.” ");
INSERT INTO gai_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Karica Iesusa gaind mac mbopatna, “Mindaŋa reac dadaɨr laŋ, iŋmbaia mana dadaɨr mai te, aia mamo titoca tɨki mo te, mana dadaɨr mac nda aŋgɨit. ");
INSERT INTO gai_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Na ainta mindaŋa aia bulmakaona loapa tiacarap warɨŋna amna reacap mutoc te, ma warɨŋna amta reikmo waia mba neaŋitndai, wanaiŋ ŋgoin. Aia aŋgɨca kecarirenan. Na mandaia koarapnan, u koar ikca matau warac.” ");
INSERT INTO gai_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Karica kitcartukar iurena ramtaɨrapa tɨpemb ŋgorikta makukara morena meikramtaɨrap, mina Iesus ndambuŋ nakɨpca mana kam mbaracna moca mori. ");
INSERT INTO gai_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Na Parisiarapa, Iudana tɨpemb wandik tamŋirena ramtaɨrap, mina ŋgepca kekelamun keca mambopri, “Gan ramoot, ma an tɨpemb ŋgorikta makukara morena meikramtaɨrmo aca kɨpca, ma minap maamreke.” ");
INSERT INTO gai_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ainda mori Iesusa mimo gan kam roor makeat, ");
INSERT INTO gai_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Nena ianna mana sipsipara 100na mɨn, na kabe ianna taŋi iŋgoroc te, ma ŋgepca an 99na mɨn paikmo, mina ambrena taupca tɨkcarica, mina an ndeac te, ma ŋgepca an iŋgorocrinanna ŋgore taŋca wat te. ");
INSERT INTO gai_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ma ndona sipsipa watatke, toŋtoŋ bagaraniac ŋgoin, ainda moca ma ndona sipsipmo, aŋgɨra ndona ŋakep nakeca auŋ mac nda mataŋgat. ");
INSERT INTO gai_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Taŋga auŋ ndaruatke, ma ndona aikndamtaɨrapa, ndona auŋ mɨnɨŋna meikramtaɨrmo, kam neaŋga taŋga mina kɨpca puniatke, ma minmo aindopatna, ‘Aukna sipsip ianna taŋca iŋgoroca eacrinanna, aku orea maaŋgɨri, aia manapmo mbibirac emtemma mona.’” ");
INSERT INTO gai_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Karica Iesusa aindopatna, “Aku nemo wandoŋ ŋgoinna aindopnande, titocna toŋtoŋa ndo Raraŋ Aetaniacna tamuŋna auŋ ndaruit. Na tɨpemb ŋgorikta makukara morena ramoot ianna ndona morina tɨpemb ŋgorikca tɨkcarica iro inik ŋgetrikica Raraŋ Aetaniac ndambuŋ nakɨp te, ainta ramootmo mina toŋtoŋgar anik koinda monandet. Na gan 99na meikramtaɨr wandoikca mina tɨpemb ŋgorikca mba morenan, mandeaca mina iroar inkar ŋgorik mac ŋgetrikina aiŋa mba moitndai. Mina minmo toŋtoŋgar anik koinda mba moitndaiit.” ");
INSERT INTO gai_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ri, Iesusa gaind mac mbopatna, “Meac ian, mana kitukndukara gagar kabena mɨnpaik ndeacrenanna, ruar ianna iŋgoroc te, ma tida moit? Ma tac aŋgɨca metaci ore te, gagarirpaik aŋgɨca matau lari orei taŋ, taŋi watca aŋgɨnande. ");
INSERT INTO gai_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Na an meaca, ma ndona kituknduk orea aŋgɨratke. Ma ainda monande, ma ndona aikorapa, ndona auŋ mɨnɨŋna meikramtaɨrmo, muruŋ ŋgaca kɨpca tumbunna tɨkca ma minmo aindopnande, ‘Aku ndona iŋgorocatna ruar kabea orea maaŋgɨri, aia manap mbiracna.’ ");
INSERT INTO gai_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ainda moca an taupna kirara aku nemo aindopnande, meac, co ramoot ianna ma ndona iro inik ŋgetrikica ndona tɨpemb ŋgorikta makukar tɨkcarica Raraŋ Aetaniac ndambuŋ mac nda kɨp te. Raraŋ Aetaniacna mbaiŋna aiŋa morena ŋerŋgaura, mina toŋtoŋgar anik aŋgɨnandet.” ");
INSERT INTO gai_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ri, Iesusa gaind mac mboprina, “Ramoot ianna ndona nuocniŋap. ");
INSERT INTO gai_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Na mana nuoc lapmbitaca ŋgepca ndona aetmo aindopatna, ‘Ate, u aŋmo neaŋ ndopca eacrena reik, aku toŋgorinanna, u an reikmo titaca auknanmo neaŋ.’ Aindopatke, maniŋna aetta ŋgepca ndona reikmo titaca maniŋmo kocnaia biŋaia aŋgɨra maneaŋgat. ");
INSERT INTO gai_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Karica eaca rocotta wanaiŋ, nuoc lapmbitaca ŋgepca ndona reikmo aŋgɨra tɨkca meikramtaɨra mbik tɨkca mina oikatna mbatca, ma an reikta kitukndukar aŋgɨca, ma ŋgepca taŋca mon tawan ŋgoinna pitrikna auŋ ianna taŋca, anna tɨkca ndona toŋtoŋna tɨpemb ŋgorikca ainda moatke, an kitukndukara anna tɨkca moa kecarica. ");
INSERT INTO gai_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ri, ma kitukndukarmo ainda moa kecarica, iŋmbaia an auŋa nik wapatai aniac laruatke. Ma amta reik kocor. ");
INSERT INTO gai_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ainda moca ma taŋga an pitrik inikna ramoot ian ndambuŋ ndaruca, aiŋirta digiatke, ma mamo markɨmta wuocna ŋginaŋa mona mandaca taŋga. ");
INSERT INTO gai_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ma taŋga wattatnanna, markɨmbca mankɨn lourta lape ambri, ma aind ndamŋiatna, ‘Ramoot ianna aukmo amna reac ianna neaŋna toawanaiŋ. Aku gan markɨmb ambrena mankɨnnarta lourta lape aŋgɨrca am te, aku mɨnna tɨk mbe.’ ");
INSERT INTO gai_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Karica iŋmbaia ma mbirac lamŋia taŋga aindopatna, ‘Aukna aetna aiŋna ramtaɨra amta reikap maeacreke, na aku nik wapatai ŋgoinna gan maeacreke.’ ");
INSERT INTO gai_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ma gaind ndamŋiatna, ‘Mindacniŋ, aku ŋgepca ate ndambuŋ, mac nda taŋca mamo aindopna, “Ate, aku Raraŋ Aetaniacapa unmo tɨp ŋgoreacna makuk ŋgoinna morina. ");
INSERT INTO gai_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Mandeaca aku una nuoca mba laruitndai, u aukmo ndona aiŋna ramtaɨra morena kirara, u aukmo ainda mo.”’ ");
INSERT INTO gai_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Karica ma ŋgepca ndona aet ndambuŋ mac nda taŋga. “Taup kam ndaruatke, mana aetta, ndona nuocmo mon tawan ŋgoinna tɨkca watca mana nikinik iroa manmo kakadmai bagaraniac ŋgoinna moca ma ŋgepca ootta taŋga ndona nuocmo utiŋga, pipopotacri. ");
INSERT INTO gai_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Na nuoca aetmo aindopatna, ‘Ate, aku Raraŋ Aetaniacapa unap, oŋmo tɨp ŋgoreacna makuk ŋgoinna morina. Ainda moca mandeaca aku una nuoca mba laruitndai.’ ");
INSERT INTO gai_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ainda moatna mbatca, mana aetta ndona mbaiŋna ramtaɨrmo aca kɨpca aindopatna, ‘Ne tawina taŋca mon tik ŋgapaoc rocot laŋ ŋgoin, aŋgɨca kɨpca mamo neaŋ aoc, te, mana parna lamboi tɨk te, mana ortɨmbɨk ŋgapaocniŋ tɨk. ");
INSERT INTO gai_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Te, taŋca tikta bulmakao ŋgam ianna rɨŋ menaca aŋgɨri kɨpca aia manap amtiamma moca am te, manap mbiracna. ");
INSERT INTO gai_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Aukna gan nuoc, ma menacrina ramoot, mandeaca ma ndona wat ŋgam mac nda maaŋgɨca. Ma taŋga iŋgorocarica eacrenan, ma mac nda kɨpca malaruri.’ Mana aetta aindopacarica, mina amtiam aniaca moca amba toŋgoca weraica eacrina. ");
INSERT INTO gai_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Ri, an aetna nuoc lacaua, ma warɨŋ inik ndeaca, iŋmbaia ma nda kɨpca, kacmo rambuŋaica waracatnanna, mina ŋapar kumbri werina mɨtmɨtarapa ŋapar mbaraca. ");
INSERT INTO gai_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ainda moca an nuoc lacau, ma ndona aetna mbaiŋna ramoot ianmo aca kɨpca digiatna, ‘Anna mina kaia more?’ ");
INSERT INTO gai_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ri, an mbaiŋa morena ramoot, ma mana kam rutica aindopatna, ‘Una aetta bulmakao tikrɨtɨk ŋgam ianna rɨŋga tɨkca mina amtiam anna morena, una lapmbitaca ŋgocrai ŋgocor. Ainda moca una aetta man mbatca toŋtoŋ bagaraniac ŋgoin.’ ");
INSERT INTO gai_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Aindopri, an nuoc lacaua an kam mbaraca, nikkatta ŋgocraica kac inikca mba mbukri, ma raekmbai ndeacri. Ainda moca mana aetta laruca manmo mbukna moca kam laŋ mbuŋa aemaŋmaŋap mbopri. ");
INSERT INTO gai_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Na ma ndona aetmo gainda rutirina, ‘Kaica? Iarir wɨt aniac aku una aiŋ anikca moreke, na una kamma mba nda rutirenanna. Na u aukmo meme ŋgam ianna mba neaŋga aku ndona aikormo, amna reac ianna moca am ŋgocor, wanaiŋ ŋgoin. ");
INSERT INTO gai_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","U wat, an una nuoc, ma una reik aŋgɨra taŋga ruar mbuniŋna meikap tɨkca moa kecarica ma mac nda kɨpapeke, u manap mbiracna moca bulmakaoa tikrɨtɨk ŋgamma rɨŋga manap mbiracapekna.’ ");
INSERT INTO gai_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Karica aetta mamo gaindopatna, ‘Aukna nuoc, memetmbaca u aukap eacreke, na gan aukna reik anna unan. ");
INSERT INTO gai_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Aintik aia manapmo toŋtoŋ weperai aniaca morena, na manmo gan amna reac aniaca moapekna, na una lapmbitaca ma taŋga menacrina ramootna kirar, mandeaca ma wat ŋgam mac nda maaŋgɨri, mataŋga iŋgoroca eacrenanna, mandeaca aia mamo orea maaŋgɨri.’” ");
INSERT INTO gai_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","An kam roorna ninini maiatke, Iesusa, ma ndona iŋa raŋgairena ramtaɨrmo kabena kam roor ianmo gaind nakecatna, “Laimnembta ramoot ianna eacrenanna, ma ndona reikta ŋginaŋa morena ramoot paŋan ianap. An ramoot paŋanmo, kabena meikramtaɨr ndeida, an laimnembta ramoot paŋanmo aindopatna, ‘Una reikta ŋginaŋa morena ramoot paŋanna, una kitukndukarapa, una reikmo ndona toŋtoŋ mbuŋ mamoreke.’ ");
INSERT INTO gai_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Aindopri, an laimnembta ramoot, ma ŋgepca an ndona reikta ŋginaŋa morina ramootmo aca kɨpca aindopatna, ‘U tida moapekna reikta kamma aku an mbaracpekna, mandeban ŋgoin u taŋca aukna reikca un ndambuŋ ndeacrena reikta nininimo timbigta kapca tɨkca, tɨkcari te, u aukna aiŋa mba mac moitndai.’ ");
INSERT INTO gai_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Karica an reikta ŋginaŋa morena ramoot, ma ŋgepca ndomo aindopatna, ‘Aku ainda mo te, aku tida moit? Ramoot paŋan auknan, ma aukna aiŋa katacnande. Aku warɨŋna aiŋa mona toawanaiŋ, na amna reacna runa numbirca monande.’ ");
INSERT INTO gai_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ri, ma lamŋia taŋga gaind ndamŋirina, ‘Mandeac aku malamŋica, aukna ramoot paŋan, ma aukmo ndona aiŋna ramoot paŋanna morina aiŋ mai ndop te, aku gainda mona, na mina aukmo ndorita kaiknimbca aŋgɨ taŋna mɨn.’ ");
INSERT INTO gai_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ainda moca ma an ramtaɨra mana kacootna reikca wanaiŋ naaŋgɨatna ramtaɨrmo, ma an reik rutina ŋgaca, mina kabe, kabea man ndambuŋ nakɨpca an reik rutina nakɨpatke, ma out nakɨpatna ramootmo madigiat, ‘U aukna kacootna reikca titpaikca wanaiŋ naaŋgɨrina?’ ");
INSERT INTO gai_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ri, ma aindopatna, ‘Amta reik rotacrena tabrirta wɨnne anikca 100na mɨn.’ Aindopri, kacootna reikta ŋginaŋa morena ramootta mamo aindopatna, ‘U gan timbiŋ rapara una wanaiŋ naaŋgɨrina reik tɨkca eacrenanmo, u tawina mbiraca 50na mɨn mbuŋa tir.’ ");
INSERT INTO gai_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Karica ma maiatke, iŋmbaia ramoot ian tuk mac kɨpca laruatke, ŋginaŋna ramoot paŋanna mamo mac digiatna, ‘U aukna kacootna reikmo titpaikca wanaiŋ naaŋgɨatna?’ Ainda digiatke, wanaiŋ naaŋgɨatna ramootta aindopatna, ‘Witna tamura 100na mɨn.’ Aindopatke, an ŋginaŋa ramoot paŋanna aindopatna, ‘U gan timbiŋ rapar aŋgɨca u wanaiŋ naaŋgɨatna reikmo 80na mɨnna tir.’” ");
INSERT INTO gai_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Na ma aindopatna, “Iŋmbaia an laimnembta kacootta, ndona ŋginaŋna ramoot moatna aiŋ laŋa wat te, ma an ŋginaŋna ramoot ŋgoreacna i aŋgɨ ŋgepnandet. Na ma morina tɨpna kirara anna iroapna ramoot mori toc. Aintik meikramtaɨra gan tiacarpaikna tɨpembta kirarira raŋgairenan, mina titocna iroar puŋga monanna, mina mɨn ŋgoin. Na mina an Raraŋ Aetaniacna memetacna inikca taŋrena meikramtaɨrmo, mina minmo outmbai ndeacrena.” ");
INSERT INTO gai_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Aintik Iesusa gaind mac mbopatna, “Aku nenmo aindopnande, gan tiacarpaikna kitukndukapa reikmo, ŋembta meikramtaɨrmo otaca an kitukndukapa reikca neaŋ, gan tiacarpaikca mai te, tamuŋna auŋnanda nemo aŋgɨ taŋca iarwar ndeacnande. ");
INSERT INTO gai_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Na u mandaia, u reik tekirmo mataui raupŋi te, u reik anik motoco u mataui raupŋinande. Na u mandaia u reik tekirmo tɨp, laŋa mo ŋgocor, tɨp aniac toco u mba mataui moitndai. ");
INSERT INTO gai_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ainda moca ne gan tiacarpaikna kitukndukarmo matau raupŋi ŋgocor, te, mandaia ndo nemo reik gidkar neaŋca ne an raupŋit? ");
INSERT INTO gai_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ainda moca ne mandaia ne kabena meikramtaɨrta reikmo matau raupŋi ŋgocor, mandaia ndo nemo nena reik neaŋit?” ");
INSERT INTO gai_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Karica ma gaind mac mbopatna, “Tuomna aiŋ kamainda morena ramootta, kacoot mbuniŋna aiŋa mba moitndai. Ma mo te, ma ianmo ŋate te, ma ian niŋgikca matŋinande. Na ma ianna kam mbarac te, ma ianmo iŋ neaŋ wɨtɨknande. Aintik ne mba Raraŋ Aetaniacapa gan tiacarpaikapna kitukndukna aiŋmo, kapca mba tɨki moitndai.” ");
INSERT INTO gai_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Parisinanta ramtaɨra kɨtcaɨrtukar toŋgorena ramtaɨr, ainda moca mina Iesus mbopatna kam mbaraca, mamo piria mbopca malaroŋri. ");
INSERT INTO gai_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ainda moca ma minmo aindopatna, “Ne ndorimo ainda mo te, meikramtaɨrmo anna watca aind ndamŋina moca, ‘Mina tɨpemb kirarira wandoik laiŋga morena ramtaɨr.’ Na Raraŋ Aetaniac, ma nena iroar inkar ndeacrena tɨpemb kirarir ŋgorikca, ma malamŋireke, an reikca ramtaɨra anmo reik laiŋ ndoprena reikmo, Raraŋ Aetaniacna lamnɨaca watreke, an reikca anna reik ŋgorik. ");
INSERT INTO gai_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Na Tɨp Wandɨkna kammapa, Raraŋ Aetaniacna rambca morina ramtaɨrta kambta gagrara kɨpca kɨtac puk neaŋrina ramoot Ionna mɨnna tɨknandet. Na Ionna mɨn mbuŋa tɨkca, Raraŋ Aetaniacna bubuocna kam wembaŋ laŋa auŋembta meikramtaɨra muruŋ mbaraca, mina an bubuocna kaŋgaukca mbukna mawakikireke. ");
INSERT INTO gai_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","“Ainda moca riac tamuŋapa gan tiacarpaik, maniŋa laŋanna mainande. Na Tɨp Wandɨkna tɨp emtemma mba maiitndait.” ");
INSERT INTO gai_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Karica ma gaindap mac mbopatna, “Ne mandaia u ndona meac ŋgootta mandaceknan, u kabena meac mac laŋgo te, u tɨp ŋgadudukca morena meacramootna tɨp kirara moapekna. Na u mandaia, meac ianna mana kaŋgaitta mamo tɨkcarica ma wanaiŋ ndeacrenanna, u mandaia ainta meac laŋgo te, an toco, u tɨp ŋgadudukca morena meacramootna tɨp kirara moapekna.” ");
INSERT INTO gai_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Karica Iesusa gaind mac niniatna, “Ŋgaua laimnembta ramoot ian, ma gainda morina, ma tik ŋgapaoc laŋ, laŋmo ra, ra katuca aocreke, gagamna reik laiŋ, laiŋmo ra, ra katuca ambrena. ");
INSERT INTO gai_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","21","Ainda moca reik kocorta ramoot embaia mana ia Lasarus, mana tikiŋitta pitira kocnaia mɨnna tɨkca eacrena, mina mamo aŋgɨra taŋga laimnembta ramootna kacna wuocna tɨŋ roumbca tɨkca. Ma an ndeac te, an laimnembta ramootta bara mbiraca ambca, amta reik tɨpembca wɨkɨnna mbutukri. Lasarusa anna watca an aŋgɨca amna iro ndamŋiri eacri. Na pitir mananna racainda irikri, piriŋga kɨpca ndorita mimb puŋga maikrena. ");
INSERT INTO gai_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Iŋmbaia an reik kocorta ramootmbaia, ainda moa taŋ, taŋga menacatke, Raraŋ Aetaniacna mbaiŋna aiŋa morena ŋerŋgaura kɨpca mamo aŋgɨra taŋga Abraam ndambuŋ matɨkat. An laimnembta ramoot toco, menaca mina manmo mamutocat. ");
INSERT INTO gai_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ma an memenacna taup ndeacri, gɨgɨrar anik aŋgɨri, ma anna tɨkca tamuŋ mbatatnanna, Abraamma mon tawan ŋgoin ndeacri. An reik kocorta ramoot Lasarus, ma Abraamna kɨtɨm ndeacrinan mbatca. ");
INSERT INTO gai_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ainda moca ma aca mambopat, ‘Aukna aet Abraam, u aukna moca kadmaica otac, te, Lasarusmo mbopca ma ndona patŋitlormo puk nake pukca aŋgɨ kɨpca aukna mim nake te, aukna mimma gagauna, aku gan tacna gɨrgɨr aniacna inik maeacreke.’ ");
INSERT INTO gai_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Aindopatke, Abraamma manmo aindopatna, ‘Nuoc mbitac, u menac ŋgocor ndeacri, moatna reikmo u lamŋi, u tiacarpaik ndeacri, u reik laiŋ, laiŋ aŋgɨrina. Na Lasarusmbaia reac ŋgoreac, ŋgoreac aŋgɨrina. Aintik mandeaca gan auŋmo ma toŋtoŋ bagaraniacap. Na u gɨrgɨr aniacna inik ndeacnande. ");
INSERT INTO gai_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Na reac ian toco gaind maeacreke, aiapa nena rɨkca, Raraŋ Aetaniaca oc bagaraniac ian kataca tɨkca maeacreke. Aintik aia an oc kataca nenanmbai nagacna mɨnna wanaiŋ. Na ne toco an oc kataca ainanmbai nagacna mɨnna wanaiŋ.’ ");
INSERT INTO gai_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Ainda moca an laimnembta ramoot, ma aindopatna, ‘Aintan ecte laŋ, ate aku umo gainda diginande, u Lasarusmo watcarica ma aukna aetna kacnɨma taŋna mɨn ki? ");
INSERT INTO gai_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Aku laiplacar parmbaiap, u Lasarusmo watcarica mataŋca mimo mbopi, gagraca mina iroar ŋgetriki. Moca mitoco gan auŋ nakɨpca gan gɨgɨrar aŋgɨ nari.’ ");
INSERT INTO gai_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Aindopri, Abraamma mamo rutica aindopatna, ‘Una laiplacara Mosesapa Raraŋ Aetaniacna rambca morina ramtaɨrta mbopatna kambca eacrena. Na mina ndorita kour tɨkca an kam mbarac.’ ");
INSERT INTO gai_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ri, an laimnembta ramootta mac nda rutica aindopatna, ‘Ate Abraam, anna mɨnna wanaiŋ, ramootta menaca mutoca eacrena, muk ŋgetacndiŋ mac nda ŋgep te, mina anna wat te, mina iroar inkar ŋgetrikina mɨn.’ ");
INSERT INTO gai_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Aintik Abraam, ma rutica aindopatna, ‘Mosesapa Raraŋ Aetaniacna rambca morina ramtaɨrmo mina warac ŋgocor, anmo mindacniŋa mo te, mina anna ŋgegetrikia mba aŋgɨritndai. Na ramootta menaca mutoca eacrena, muk ŋgetacndiŋ mac nda ŋgep te, an ramoot toco, mina mba rɨpacitndai.’” ");
INSERT INTO gai_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Karica Iesusa ndona iŋa raŋgairena ramtaɨrmo aindopatna, “Ainta reac, reaca meikramtaɨrmo larunande, anna mina rɨtɨpaca mo iriknan. Aintik mandaia ainta reaca moa larurina ramoot, manbaina kakadmai ŋgoin. Ma makukca aŋgɨnandet. ");
INSERT INTO gai_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Na ramoot ian, ma an mombonikta ianmo, moca ma tɨp ŋgoreacna makukca mbutuk te. Ainta ramootmo, mina aŋgɨca mana logotmo, waut aniacap ŋgatɨk mbuŋa leaca aŋgɨri, macait inik nake pukca, ma menacnande. Na ainta makukca ma aŋgɨeknanna, Raraŋ Aetaniaca mamo neaŋgekna makukca, anmo kunda tamuŋ ŋgoin. ");
INSERT INTO gai_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","“Aintik ne ndorimo mataui bubuoci eac. Moca una laiplacarta ianna, unapmo tɨp ŋgoreacna makukca mo te, u mamo gɨgɨrai mbopca ma ndona tɨp ŋgoreacna makukmo, moi wandoŋai. Na ma ndona iro inik ŋgetriki te, u mana tɨp ŋgoreacna makukca mo kecari. ");
INSERT INTO gai_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Aintik ŋarikca ma unapmo ra kabena inikca unmo tɨpemb ŋgorikta makukarmo, parmbaiapa mbutniŋna mɨnna mo te, an rana inikca ma kɨdrɨk parmbaiapa mbutniŋna mɨnna mac nda kɨpca, unap morina tɨp ŋgoreacna makukna moca unapmo, anna kakadmaina kam ndop te, u mamo mana tɨp ŋgoreacna makukmo mo kecaria, mamo tɨp laŋa mo.” ");
INSERT INTO gai_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ri, Iesusna up aŋgɨrena ramtaɨr, mina aindopatna, “Kacoot, u aina rɨtɨpacmo moi bagaraniac ŋgoin ndaru.” ");
INSERT INTO gai_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Karica Kacootta minmo aindopatna, “Nena rɨtɨpaca ik mastetna loorna aniacna kirar toc te, na ne ik aniac ianmo aindop te, ‘U kacrirpaikap tarkica taŋi, macait rɨkmbaia wɨtɨk.’ Ne aindop te, ma nena kam mbaracnande.” ");
INSERT INTO gai_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ainda moca Iesusa mimo aind mac mbopatna, “Moca nena inikna ramoot ian, ma ndona mbaiŋna aiŋa morena ramootmo, mbagɨrica mataŋca warɨŋna aiŋa mo te, mana sipsiparta ŋginaŋa moi mai te. An mbaiŋna aiŋa morena ramootta mac nda kɨpi kacnɨm ndaru te, moca mana kacootta mamo aindop te, ‘U tawi kɨpca mbiraca ndona amna reac aŋgɨca am?’ ");
INSERT INTO gai_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ma aindopit ki? Wanaiŋ ŋgoin. Kacoot, ma ndona aiŋna ramootmo ma aindopnande, ‘U aukna amna reac kocroca, na lamboi laŋ aŋgɨri aoca, aukna amna reac rɨŋa aŋgɨri kɨpca aku am mai te, iŋmbaia ecte, u ndona amna reacapa puk am.’ ");
INSERT INTO gai_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Na an mbaiŋna aiŋa morena ramootta, ndona kacootna kamma waraca aiŋa mo te, mana kacootta manmo kam laŋ neaŋit ki? Wanaiŋ ŋgoin. ");
INSERT INTO gai_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ainda moca ne toco ne ainta tɨpemb kirarirmo, Raraŋ Aetaniac mboprina tɨp kirar ŋgoinna mo te, ne ŋgepca aindop, ‘Aia mbaiŋna aiŋa morena ramtaɨr laiŋga wanaiŋ. Titna aiŋa aia morenanna, anna aia ndorita aiŋira morena.’” ");
INSERT INTO gai_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Karica Iesusa Ierusalemma taŋna taŋga, Samariaapa, Galilina pitrik aniacniŋna kɨdrɨkna auŋ ian ndaruca. ");
INSERT INTO gai_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ma an auŋna inikca mbukca taŋri, roumb lepaap eacrina ramtaɨr parniŋa, mina kɨpca mamo taupca tɨkca ndauprikica, manmo mon tawanna wɨtɨkri. ");
INSERT INTO gai_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Na mina maacat, “Kacoot Iesus, u aimo kadmaia otac.” ");
INSERT INTO gai_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ri, Iesusa minmo watca aind mambopat, “Ne ndorita tikembmo taŋca taup ndamtaɨrmo wandac.” Aindopca mina taŋga ndorita tikembmo, wattatnanna laŋ ŋgoin ndacariri. ");
INSERT INTO gai_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Na an ramtaɨra taŋga taupmo rɨkniŋa tɨkatke, mina ianna ndona tikmo wattatnanna, mana tikca laŋa moatna mbatca, ma Iesus ndambuŋ mac nda taŋga, Raraŋ Aetaniacna imo aŋgɨra ŋgepri toŋtoŋ ŋgoin. ");
INSERT INTO gai_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Karica ma nda taŋga Iesus ndambuŋ ndaruca, mana or kɨtɨmmo paŋan ramtukca mamo kam laŋ maneaŋgat. An ramoot, ma Samarianan. ");
INSERT INTO gai_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ri, Iesusa an ramootta watca, manmo gaindopatna, “Aku anmo an ramtaɨr parniŋmo laŋa momondopca, na an par kabeapa mbutremb paura ten ndeacre? ");
INSERT INTO gai_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Kaica, ramoot embaia mac nda kɨpca Raraŋ Aetaniacna i aniacmo aŋgɨri ŋgep ŋgocor? Na an kabena auŋna ramootta ndo, mana i aniacmo aŋgɨra ŋgepapekna?” ");
INSERT INTO gai_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Karica Iesusa an ramootmo aindopatna, “U ŋgepca taŋ, una rɨtɨpaca ndo umo moca u laŋ mamori.” ");
INSERT INTO gai_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Karica Parisiarta ramtaɨr ndeida Iesusmo gainda digiatna, “Tumbuitta tɨk te, Raraŋ Aetaniacna bubuoca kɨpit?” Ri, Iesusa mina kam rutica gaindopatna, “An mɨnna Raraŋ Aetaniacna bubuoca kɨp te, meikramtaɨrta lamnikca mba ŋgagatrac ianna mba watitndai. ");
INSERT INTO gai_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Na meikramtaɨra gainda mba mbopitndai, ‘Wat, gade ma gan maeacreke.’ Co, ‘Monde, ma mon maeacreke.’ Na ne warac. Raraŋ Aetaniacna bubuoca ande nenap maeacreke.” ");
INSERT INTO gai_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ainda moca Iesusa ndona iŋa raŋgairena ramtaɨrmo aindopatna, “Iŋmbaia ra ianna kɨpnandet. Te, ne Ramootna Nuocmo an ra tɨki watca, ne manap eacna toŋtoŋgar anikap monandet, na ne gidikca mba watitndai. ");
INSERT INTO gai_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Na mina nemo gaindopnande, ‘Ne wat, ma monde mon maeacreke!’ Co, ‘Ne wat, ma gade gan maeacreke!’ Aindop te, ne kai ŋgepca mina iŋa kai raŋgaica kai taŋ teac. ");
INSERT INTO gai_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Na weperaca, riac tamuŋa metacrenanna ne lamŋirena, ma waŋembaia tɨkca aŋgɨri metac te, mana memetaca mon tawan ŋgoinna metaci taŋnande. Na Ramootna Nuocna kɨkɨp, ma an weperac wandacre toc nakɨp te, meacramoota muruŋa watnande. ");
INSERT INTO gai_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Na outmbaica ma gɨgɨrar anik wɨtta pac aŋgɨcarica, na anna iŋmbaia gan mɨnna meikramtaɨra mamo mba toŋgoitndai. ");
INSERT INTO gai_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Ainta tɨpembta kirarira, mina Noanna mɨn mbuŋa moatna kirarira, mina Ramootna Nuocna mac nda, kɨkɨpna ra mbuŋa, mina ainta tɨp kirar kabe mac monande. ");
INSERT INTO gai_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Mina Noanna mɨn mbuŋa, mina amtiambca moa ambri, puik gagrara ambri, na ŋgepca meacramootta ndorica ndada malaŋgori. Ainda moca taŋ, taŋga, maica Noa ndona laŋgum aniacna inikca mbukatke, laemb bagaraniaca kɨpatnanna minmo kɨtaca pukca mina muruŋa menaca mamaiat. ");
INSERT INTO gai_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Na Lotna mɨn toco, meikramtaɨr toco an iro kabe mamoat, mina amtiamma moa ambri, puik gagrar ambri, reac, reac biŋaia mina oikri, na warɨŋembapa kaik barer mamori. ");
INSERT INTO gai_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ainda moca Lota, Sodom auŋ tɨkcarica taŋgatke, mana iŋmbai tac aniacap watur owira, tamuŋna auŋ ndiŋa pukrapcat toc ŋgirikca minmo wɨramacariat. ");
INSERT INTO gai_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ainta kirarir koinda, Ramootna Nuocna kɨkɨpna mɨn ndarunande. ");
INSERT INTO gai_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“An ra laru te, ramootta mandaia u ndona kacna tɨmpaikna up ndeacrenanna, an rana inikca kacna inikca kai mac nda mbukca reik aŋgɨnake kai mo teac. An kirar kabea, ramootta mandaia ma ndona warɨŋa taŋga eacrenan, ma kaca kai mac nda taŋ teac. ");
INSERT INTO gai_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Na ne matau lamŋi Lotna meacmo laruatna reac. ");
INSERT INTO gai_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","U mandaia ndona watna moca utiŋcari te, una an watta ma mainande. Na u mandaia ndona watmo kecari te, una wat anna mba maiitndai. ");
INSERT INTO gai_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Na aku nemo aindopnande, an mouŋa Ramootna Nuoca kɨpi laruca ramootniŋa bar kabe naŋgoraŋeknanna, Raraŋ Aetaniaca ian aŋgɨ te, ianmo tɨkcarinande. ");
INSERT INTO gai_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Na meaceniŋ, maniŋa witna lour aŋgɨca witna kapɨrpaika mona moca eacrinanna, Raraŋ Aetaniaca kɨpca ian aŋgɨ te, ianmo tɨkcarinande.” ");
INSERT INTO gai_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ri, mana iŋa raŋgairena ramtaɨra an kam mbaraca, mamo gainda digiatna, “Kacoot, an reikca ten ndaruit?” Ri, ma minmo aindopatna, “An warir eacrena taup mbuŋa, ande ŋganmira kɨpca an motem mapunireke.” ");
INSERT INTO gai_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Karica Iesusa mimo kam roor ian keca, mimo an kam roora riptica, mina memetmbaca mbembendeia moraŋ, na mina kai ŋate teac. ");
INSERT INTO gai_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ma aindopatna, “Ritri waparacrena ramoot ian, ma auŋ aniac ian ndeacrenanna, na ma Raraŋ Aetaniac nake, mba nanambirenanna, na ma mba ramoot ian nake, mba dadanake lamŋitndai. ");
INSERT INTO gai_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ri, an auŋna meac konim ian toco, eacrena, memetmbac ma kɨpca an ritri waparaca morena ramootmo aindoprena, ‘Aukna puŋnaŋgepca aukmo mo ŋgocraina mamoek, u aukmo otaca aukna kambca ritri waparaca mo.’ ");
INSERT INTO gai_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ainda moca an ritri waparaca morena ramoot, ma an meac ŋgotacna toŋtoŋgar kocor, ma eaca kɨdrɨk rocot, iŋmbai ŋgoinna ma ndo mbuŋ ndamŋia taŋga aindopatna, ‘Aku Raraŋ Aetaniac nake, mba nanambirenanna, na aku mba ramoot ian nake, mba dadanake lamŋitndai. ");
INSERT INTO gai_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Ainda moca gan meac konimma, ma aukmo memetmbac ŋgoinna ndo ŋgotaca, ndona makukara waracna moca moreke. Aintik aku mana makukara ritri waparacnande, moca ma auk ndambuŋa memetmbac nakɨpraŋ nari, na aukmo moi ŋate nari.’” ");
INSERT INTO gai_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Karica Kacootta gaind mac mbopatna, “Ne waracapek, an kambca ritri waparaca morena ramoot ŋgoreac mbopapekna kammo. ");
INSERT INTO gai_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Aind ecte, Raraŋ Aetaniac, ma ndona babuatna meikramtaɨrmo ma tida moit, mina mamo ndori ŋgotacna moca mouŋ ra ŋgae te, ma mina nananaemo waracarica, eacici andu watcarit ki? ");
INSERT INTO gai_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Aku nemo aindopnande, wanaiŋ ŋgoin, ma mba watcaritndai. Ma mimo andu ŋgotacnande. Na Ramootna Nuoca, ma gan tiacarpaik nakɨp te, ma gan tiacarpaik ndeacrena meikramtaɨrta rɨtɨpaikmo watnande, mina rɨpacre ki, co wanaiŋ?” ");
INSERT INTO gai_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ainda moca Iesusa ainta ramtaɨr morina kam roorna kamma, ma an makeat. Ramtaɨr ndeida ndorimo ramtaɨr wandoik ndopreke, na ndeidmo aindoprena, mina aina kirarir toco wanaiŋ. ");
INSERT INTO gai_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Karica ma ainda niniatna, “Ramoot mbuniŋa Raraŋ Aetaniacna Kacna roumbca tɨki mbendeina moatna. An ramootniŋa, ianna Parisinan, na ianna kitcartukar iurena ramoot. ");
INSERT INTO gai_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","An Parisina ramoot, ma ndo mbuŋa wɨtɨkca, ndona iro mbuŋa gaind mambendeiat, ‘Raraŋ Aetaniac, aku ramtaɨr ndeidta kirar toco wanaiŋ, ainda moca aku umo kam laŋ neaŋnande, laŋ ŋgoin. Aku aindopnande, mina makɨmreke, na mina tɨpemb ŋgadudukca morena meikramtaɨrta tɨpemb kirarira morenan, na mina tɨpemb wandoikca mba morenanna. Aku wanaiŋ, aku gan kitcartukar iurena ramootna kirara, wanaiŋ. ");
INSERT INTO gai_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Aku rai parmbaiapa mbut mbuniŋna ŋgatna inikna, ra mbuniŋa aku amna reacmo wariracnande. Na an reikca aku aŋgɨrenanna, aku nduca parniŋ ndarureke, aku titaca parmbaiapa paur aŋgɨ te, una kabemo neaŋrena.’ ");
INSERT INTO gai_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Na an kitcartukar iurena ramoot, ma mon tawanna wɨtɨkca tamuŋna auŋmo mba raia watatke, ma ndona mapdɨŋa pica aindopatna, ‘Raraŋ Aetaniac, aukna nakadmai, aku tɨpemb ŋgorikta makukara morena ramoot.’” ");
INSERT INTO gai_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ri, Iesusa aindopatna, “Aku nemo aindopnande, gan kitcartukar iurena ramoot, ma ndona kaca nda taŋ te, man niŋgikca, ma ndo Raraŋ Aetaniacna lamnɨac ŋgoutmo, ma ramoot wandoŋ laŋ ndarunande. Na an Parisina ramootta wanaiŋ. Aintik meikramtaɨra ndorita iremb aŋgɨra ŋgeprenan, ainta meikramtaɨra Raraŋ Aetaniaca ma mina irembmo aŋgɨ wɨkɨn ŋgiriknande. Na ne meikramtaɨra mandaia ndorita iremb aŋgɨra wɨkɨnna tɨkrenan, Raraŋ Aetaniaca mina irembmo, aŋgɨri ŋgepca tamuŋmbaia tɨknande.” ");
INSERT INTO gai_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Karica meikramtaɨra muruŋa Iesusmo ndorita mɨr katacrina mombonikapa mɨr ambrena mombonikap, aŋgɨa kɨpca, ma mina tikemb ŋgutiŋga mbendeia taŋri. Na Iesusna iŋa raŋgairena ramtaɨra ainda watca, an meikramtaɨrmo kaega moca mambopat, “Mombonikmo man ndambuŋa kai aŋgɨ kɨp teac.” ");
INSERT INTO gai_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ainda moatke, Iesusa an mombonikmo aca ndo ndambuŋ nakɨpatke, ma ndona iŋa raŋgairena ramtaɨrmo aindopatna, “Mombonik tekirmo watcarica mina auk ndambuŋ nakɨp, minmo kai kɨrac teac. Meikramtaɨra aintocna mombonik tekir toc ndaru te, Raraŋ Aetaniacna bubuoca, anna minan. ");
INSERT INTO gai_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Aku nemo gidik ŋgoinna aindopnande, ramootta mandaia Raraŋ Aetaniacna bubuocmo mombonik tekir aŋgɨrina kirara ainda aŋgɨr ŋgocor, an ramootta ma Raraŋ Aetaniacna bubuoca mba mbukitndai.” ");
INSERT INTO gai_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Karica ramoot paŋan ianna Iesusmo ainda digiatna, “Riripti laŋ, aku tida mo te, aku iarwarna eteacna wat laŋ aŋgɨit?” ");
INSERT INTO gai_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ri, Iesusa an ramoot paŋanmo aindopatna, “U kaina moca aukmo laŋ ŋgacapekna? Na ramoot ianna laŋa wanaiŋ, Raraŋ Aetaniac niŋgikca ma ndo laŋ. ");
INSERT INTO gai_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Na u lamŋirena Tɨpemb Wandikta kirarirta kambca aindoprena, ‘Ne tɨpemb ŋgadudukca morena meikramtaɨrta tɨpemb kirarira kai mo teac. Na meacramootmo kai mo menac teac, na kai makɨm teac, na ne ritri waparacmo moa paparuna kam mbuŋa kai mbop teac, na ndorita amepaetna kamb mbaraca mina kaŋgauk ndeac.’” ");
INSERT INTO gai_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ri, an ramoot paŋanna aindopatna, “An kɨdrɨkca aku ramoot ŋgam ndeacri, aku Tɨpemb Wandikmo, aku matau ŋgoinna raŋgaica kɨp, kɨpca, kɨpca mandeacna mɨn.” ");
INSERT INTO gai_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ri, Iesusa an ramoot paŋanna mbopatna kam mbaraca, ma manmo aindopatna, “Un mona reac ianna maeacreke, u taŋca ndona laimnembmo aŋgɨri mbik tɨkca oikrena taupca tɨkca meikramtaɨra oik te, an kitukndukmo, u aŋgɨca reik kocorta meikramtaɨr ndaekpembmo biŋai. Na u ainda mo te, u tamuŋna auŋmo u reik laiŋ koindap eacnandet. Na u kɨpca aukmo raŋgai.” ");
INSERT INTO gai_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Karica an laimnembta ramoot paŋan, ma an kamb mbaraca, ainda moca ma ndona lamin aniacna moca tamtam ndamŋica, kadmairina. ");
INSERT INTO gai_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ri, Iesusa an ramoot paŋanna iro aŋgɨca, ma aindopatna, “Ramootta lamin aniacapnan, ma Raraŋ Aetaniacna bubuocna kaŋgaukca mbumbukca owai ŋgoin. ");
INSERT INTO gai_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Na kamela reik iukrena lacna urupa mbumbukca anna wetwet ŋgoinna mbukrena, na laimnembta ramootta, Raraŋ Aetaniacna bubuocna kaŋgaukca mbumbukca anna owai ŋgoin.” ");
INSERT INTO gai_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ri, an meikramtaɨra Iesus mbopatna kamb mbaraca, aindopatna, “Ainda mo te, mandaia ndo an iarwar ndeteacna wat aŋgɨit?” ");
INSERT INTO gai_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Na Iesusa mac nda rutica aindopatna, “Reikca ramootta mona mɨnna wanaiŋ, Raraŋ Aetaniaca mona mɨn.” ");
INSERT INTO gai_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Karica Pita ŋgepca aindopatna, “U warac, aia ndorita reikmo tɨkcarica una iŋa raŋgairena.” ");
INSERT INTO gai_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ri, Iesusa minmo aindopatna, “Aku nemo gidik ŋgoinna aindopnande, ne mandaia Raraŋ Aetaniacna bubuocna ndamŋica, u ndona kac, co ndona meac, co u ndona laiplacar, co ndona amepaet, co ndona mombonikmo min tɨkcarica, kɨprinan. ");
INSERT INTO gai_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Ne gan tiacarpaik ndeacraŋekna mɨnna, Raraŋ Aetaniac, ma nenmo reik wɨt aniac ŋgoin neaŋnande, nena ŋgaua naaŋgɨra wembacrina reikmo kunnande. Te, iŋmbaia ne iarwarna eteacna wat aŋgɨnande.” ");
INSERT INTO gai_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Iesusa ndona iŋa raŋgairena ramtaɨr parniŋapa, mbut mbuniŋna ramtaɨr aŋgɨra punica mimo aindopatna, “Ne warac. Aia mandeaca Ierusalemma taŋna mamoek, na atuna rambca morina ramtaɨra tiratna kamna kirarirta reikca mandeaca Ramootna Nuocmo gidikca larunande. ");
INSERT INTO gai_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Mina manmo Iudana meikramtaɨr wanaiŋna para tɨkca, mina manmo kome te, manmo taber iu te, manmo mo ŋgoreaca monande. ");
INSERT INTO gai_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Na mina manmo pia ŋgocraica, na iŋmbaia mina manmo mo menacnande. Na rai mbonkac mbuŋa, ma mac nda ŋgepnandet.” ");
INSERT INTO gai_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ri, mana iŋa raŋgairena ramtaɨra mana mbopatna kambta mɨnɨŋa mba lamŋiatke, minmo an kambta mɨnɨŋa iŋgorocamariat, ainda moca mana mbopatna kambca mina lamŋi rapac ŋgocor. ");
INSERT INTO gai_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Karica Iesusa taŋga Ieriko auŋa rambuŋairi, lamnɨac ŋgoreacna ramoot ianna taupna roumbca mbiraca, meikramtaɨrmo kitukndukna rurena. ");
INSERT INTO gai_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ma mbiraca waracatnanna, meikramtaɨr wɨt aniaca taŋri, ma waraca meikramtaɨr ndeidmo madigiat, “Mina kaia more?” ");
INSERT INTO gai_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Na mina mamo aindopatna, “Iesus Nasaretnan taŋrena.” ");
INSERT INTO gai_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Aindopatke, an lamnɨac ŋgoreacna ramootta Iesusmo aca aindopatna, “Iesus, Dewitna ŋgamaɨr, u aukna kadmaia aukmo otac!” ");
INSERT INTO gai_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Karica an outmbai nakɨpatna ramtaɨra, kɨpca an lamnɨac ŋgoreacna ramootmo tagagarica aindopatna, “U watitica kam kocor ndeac.” Aindopri wanaiŋ, ma kam aniac keca aindopatna, “U Dewitna ŋgamaɨr, u aukmo kadmaia otac!” ");
INSERT INTO gai_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ma aindopatna mbatca, Iesusa wɨtɨkca minmo aindopatna, “An lamnɨac ŋgoreacna ramootmo, auk ndambuŋ naaŋgɨ kɨp.” Ri, an lamnɨac ŋgoreacna ramootta kɨpca Iesusna kɨtɨmma wɨtɨkatna mbatca, ma manmo madigiat, ");
INSERT INTO gai_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Aku unmo titoca moit?” Ri, ma aindopatna, “Kacoot, aku mac watna toŋgorina.” ");
INSERT INTO gai_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Na Iesusa manmo aindopatna, “Una rɨtɨpaca ndo una lamnɨacmo, moa laŋa moca, mandeaca una lamnɨaca mac watnande.” ");
INSERT INTO gai_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ainda moca an mɨn mbuŋa, an ramootna lamnɨaca anduna laŋa moca ma watukca watca ŋgepca Iesusna iŋa taŋga, Raraŋ Aetaniacna i aŋgɨra ŋgepri, anna meikramtaɨra anna watca mitoca ŋgepca Raraŋ Aetaniacna ia aŋgɨra maŋgepat. ");
INSERT INTO gai_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Karica Iesusa taŋga Ieriko auŋ ndaruca, an auŋ tɨkcarina moca taup ndiŋa taŋri. ");
INSERT INTO gai_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","An auŋ ndeacrina laimnembta ramoot ian, mana ia Sakias, ma mina kitcartukar iurena ramoot paŋan. ");
INSERT INTO gai_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","An ramoot Sakias, ma ramoot matɨp ŋgoin. Ma ndomo Iesusa watna moca towaia tambca, meikramtaɨra wɨt ŋgoin. ");
INSERT INTO gai_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Aintik ma out ŋgotacarica taŋga taup roumbna ik aniac ian ŋgoteca gaca Iesusa watna moca, ma lamŋirina Iesusa an taup ndiŋ nakɨpnande. ");
INSERT INTO gai_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Karica Iesusa kɨpca manap mɨn kabea wɨtɨkca, raia watca Sakiasmo gaind mambopat, “U tawi irik. Aku mandeac unapmo una kac inik ndeacnande.” ");
INSERT INTO gai_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ri, Sakiasa toŋgocarica tawina ŋgirikca, Iesusmo aŋgɨca ndona kac mataŋgat. ");
INSERT INTO gai_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Na meikramtaɨra muruŋa anna watca, mina muruŋa kekelamun irikca mambopri, “Ma taŋga an tɨpemb ŋgorikta makukara morena ramootna kac maeacreke.” ");
INSERT INTO gai_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Karica mina an kac inik ndeacri, Sakiasa ŋgepca wɨtɨkca Kacootmo aindopatna, “Kacoot, u warac, aku ndona reikmo tumbun mbuniŋa tɨkca tɨpca reik kocorta ndaekpembta meikramtaɨra neaŋnande. Na ŋarikca aku ramootna reac ianna parua aŋgɨca mananmo mac nda neaŋ ŋgocor ndeaceknanna, aku mana reacmo kabena reik paurmo an nambatta tɨkca manmo neaŋnande.” ");
INSERT INTO gai_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ri, Iesusa manmo aindopatna, “An ramoot, ma toco Abraamna ŋgamaɨr ian. Aintik mandeaca Raraŋ Aetaniaca mana kacnandmo mac nda maaŋgɨri. ");
INSERT INTO gai_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Aintik Ramootna Nuoca kɨpatnanna, ma anna taŋga taprekerina meikramtaɨr mac nda ore aŋgɨca, min mac nda aŋgɨnande.” ");
INSERT INTO gai_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ainda moca Iesusa maica Ierusalem ndaruna rambuŋairi, mina aind malamŋiat, Raraŋ Aetaniacna bubuoca maica kɨpna mamoek. Aintik ma an meikramtaɨrmo kam roor ian makeat. ");
INSERT INTO gai_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Karica ma gaindopatna, “Ramoot aniac ian, ma mon tawanna pitrik aniac ianna taŋga, mina mamo moi irembta gagrirta ramoot paŋan ndaruca, iŋmbaia ma nda kɨpi ndona auŋ mɨnɨŋ ndaruca, ndona auŋ mɨnɨŋna meikramtaɨrmo bubuocnande. ");
INSERT INTO gai_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ainda moca ma taŋna moatke, ma ndona mbaiŋna aiŋa morena ramtaɨr parniŋmo aca kɨpca, minmo kitukndukca K20na mɨnna, mina kabe, kabemo ainda neaŋga. Ma minmo aindopatna, ‘Ne gan kitukndukar puŋga aiŋa moi taŋi, aku ndo mac nda kɨp te.’ ");
INSERT INTO gai_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Ri, mana pitrikna ramtaɨra nikembkatacarica eacri, ma taŋgatke. Iŋmbaia mina ramtaɨr ndeidmo mbagɨrica mina taŋga an ramoot aniac eacrina auŋnandmo aindopatna, ‘Aia an ramootmo ndorita gagrirta ramoot paŋan ndatarua, aia toŋgo ŋgocor.’ ");
INSERT INTO gai_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Na an ramootta, ma taŋga mina mamo gagrirta ramoot paŋan naaŋgɨa wɨtɨkatna mbatca, iŋmbaia ma mac nda kɨpca ndona auŋ ndaruatke, ma aind mambopat, ‘An mbaiŋna aiŋa morena ramtaɨrmo mbopca mina auk ndambuŋ nakɨp, ŋgaua aku minmo neaŋgatna kitukndukca mina kabe, kabea moca aŋgɨra an nambatta tɨkrina ŋgaŋganŋgɨa watna.’ ");
INSERT INTO gai_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Karica an outta tɨkca kɨpatna aiŋna ramootta aindopatna, ‘Kacoot, aku una neaŋgatna K20mo an mbuŋa aiŋa moa taŋga, K200na mɨnna aŋgɨratna.’ ");
INSERT INTO gai_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ri, gagrirta ramoot paŋanna an mbaiŋna aiŋa morena ramootmo aindopatna, ‘U mbaiŋna aiŋa morena ramoot gidik laŋ. U an reac teker mbuŋa, aiŋ laŋ ŋgoinna moapekna. Aintik aku unmo auŋemb parniŋna meikramtaɨr bubuocna ramoot paŋanna tɨknande.’ ");
INSERT INTO gai_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Na an aiŋna ramoot ian tuk mac kɨpca aindopatna, ‘Kacoot, aku una neaŋgatna K20mo, an mbuŋa aiŋa moa taŋga, kabena K100mo, aŋgɨca an nambat mac tɨkrina.’ ");
INSERT INTO gai_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ri, gagrirta ramoot paŋanna mamo aindoprina, ‘Aku umo auŋemb parmbai bubuocna ramoot paŋanna tɨknande.’ ");
INSERT INTO gai_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Na kabena aiŋna ramoot ian tuk, ma mac kɨpca aindopatna, ‘Kacoot, una neaŋgatna K20mo, aku raraŋit mbuŋa tamaia, maeacreke. ");
INSERT INTO gai_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Aku unmo lamŋirena, u nikkakatna ramoot, u kabena meikramtaɨrta aŋgɨra tɨkrena reikca tamtam naaŋgɨreke, kabena ramootna warɨŋa mbatrina reikca an toco u aŋgɨrena. Ainda moca aku un narica nanambica.’ ");
INSERT INTO gai_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Karica gagrirta ramoot paŋanna, an mbaiŋna aiŋa morena ramootmo aindopatna, ‘U mbaiŋna aiŋa morena ramoot laŋa wanaiŋ, u ramoot ŋgoreac, aku una an kam mbuŋa unmo mo ŋgocrainande, u lamŋirena aku nikkakatna ramoot, aku kabena ramtaɨr tɨkca eacrena reik aŋgɨreke, kabena ramoot mbatacrena reik aŋgɨrena ramoot. ");
INSERT INTO gai_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Na kaina moca u aukna kitukndukmo, aŋgɨca kituknduk tɨkrena kaca tɨki eaca, iŋmbaia aku mac nda kɨp te, aku an kituknduk nambatta tɨkeknanap mac aŋgɨr ŋgocor?’ ");
INSERT INTO gai_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ri, an ramoot ndambuŋa wɨtɨkca maica eacrina ramtaɨrmo, ma aindopatna, ‘Ne an ramoot ndambuŋ ndeacrena K20mo aŋgɨca mon K200apna aiŋna ramootta neaŋ.’ ");
INSERT INTO gai_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Na mina mamo ainda nda mambopat, ‘Kacoot, an aiŋna ramootta ma outna K200ap maeacreke?’ ");
INSERT INTO gai_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Ri, ma aindopatna, ‘Aku nemo aindopnande, mandaibinna reik wɨtapnan, minmo aku kabenanmo, an nambat mac neaŋnande. Na mandaibinna reikca wɨtta wanaiŋ, an reac mbatepniŋa man ndambuŋ ndeacrenanmo, aku man ndambuŋa tɨkca mac nda aŋgɨnande. ");
INSERT INTO gai_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Na aukmo gagrirta ramoot paŋan ndaru narica, aukmo ndorita puŋndamootta moca, morena ramtaɨrmo aŋgɨca gan aukna kɨtɨm naaŋgɨ kɨpca, aku watraŋ te, ne minmo mo menac.’” ");
INSERT INTO gai_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Karica Iesusa an kam roor ndopacarica, ma ŋgepca Ierusalem nagacna moca, taupca mbukca mataŋgat. ");
INSERT INTO gai_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Maica Iesusa Betpageapa, Betani auŋapa, Olip ŋgacrina takura taŋga rambuŋairi, ma ndona iŋa raŋgairena ramtaɨrta ramoot mbuniŋmo, outta taŋna mbagɨrica maniŋa taŋna moca. ");
INSERT INTO gai_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Ma maniŋmo aindopatna, “Oŋgo monmbai waŋna an auŋa aia watrinanna taŋ. Te, oŋgo watnande, doŋki ŋgam ianna, mina mana logotmo ŋgatɨk ikca, ikca leaca eacrena doŋkia, ramoot ianna mamo mbiraca oot ŋgocor, mana ŋgatɨk pɨarca mamo gan auk ndambuŋ naaŋgɨ kɨp. ");
INSERT INTO gai_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Na ramoot ianna oŋmo aindop te, ‘Kaina moca oŋgo an doŋkina ŋgatɨk pɨarre?’ Aindop te, oŋgo mana kam nda rutica aindop, ‘Kacootta mana aiŋap.’” ");
INSERT INTO gai_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Karica Iesusa maniŋmo mbagɨrica maniŋa taŋga laruca wattatnanna, an reiki mana mbopatna kirar ndeacri. ");
INSERT INTO gai_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Maniŋa ŋgepca doŋkina ŋgatɨk pɨarri, an doŋkina ameraetera maniŋmo madigiat, “Oŋgo an doŋkina ŋgatɨkmo kaina pɨarre?” ");
INSERT INTO gai_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ri, maniŋa nda rutica aindopca, “Kacootta anna toŋgoca.” ");
INSERT INTO gai_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Karica maniŋa an doŋkimo aŋgɨca kɨpca Iesus ndambuŋa tɨkca, mina Iesusmo otaca, mamo tamuŋa mbiraca taŋna moca, mina ndorita tik ŋgapoik aŋgɨca, doŋkina kopik nambatta tɨkca maiatke. Na Iesusa an doŋki nagaca mbiraca, an mbuŋa taŋgatke. ");
INSERT INTO gai_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Na meikramtaɨra ndorita tik ŋgapoik roctirmo, riaŋga aŋgɨra taup ndiŋa ŋgimtaca taŋri. ");
INSERT INTO gai_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","An kɨdrɨkca Iesusa Olip Takur tɨkcarica maica irikri. Mana iŋa raŋgairena meikramtaɨr wɨt anikca, mana moatna ŋgagatracara watca, an ndamŋica ŋgepca kam keca aindopatna, Raraŋ Aetaniacna i aŋgɨri ŋgep. ");
INSERT INTO gai_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ri, mina aindopatna, “Raraŋ Aetaniaca, gan gagrirta ramoot paŋanmo opotac laŋa morena, ma Kacootna i mbuŋ nakɨpatna ramoot. Na tamuŋna auŋmo nikinik iro wetwet laŋa mo. Na Raraŋ Aetaniacmo i aniac neaŋ.” ");
INSERT INTO gai_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ri, Parisiar ndeid, an meikramtaɨrta wɨt aniacna inik ndeacrinanna, mina Iesusmo aindopatna, “Riripti, u ndona iŋa raŋgairena meikramtaɨrmo mbopca, mina an kamma ainda kai mbopraŋ teac.” ");
INSERT INTO gai_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Na ma mimo nda rutica aindopatna, “Aku nenmo aindopnande, mina watiti te, gan watura ndori kam kenande.” ");
INSERT INTO gai_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Karica Iesusa kɨpca Ierusalemma rambuŋaica, ma Ierusalem auŋ aniaca watta taŋga mana moca ma aeatke. ");
INSERT INTO gai_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ma aind mambopat, “Ierusalem, mandeaca gan ra ŋgoinna aku toŋgorinanna, u ndo nikinik iro wetwet ŋgopotacna reik anmo matau wat rapac, an reiki iŋtiŋgoroc maeacreke, u watna mɨnna wanaiŋ. ");
INSERT INTO gai_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","44","U matau warac. Raraŋ Aetaniac un ŋgotacna nakɨpca eacrenanna, u wat rapac ŋgocor. Ainda moca iŋmbaina ra ianna, una puŋnaŋgepca kɨpca una wuoc roumbmo tiacar aŋgɨri aupi korereca aŋgɨca, umo wataci korere aŋgɨca. Mina umo kocnai mo ŋgocrainande, te, una inik ndeacrena mombonikap kocnainande. Na mina una wuocapa kaikca moatna waturmo ianmo watcarica, waut ianna ian nambatta mba eacitndai.” ");
INSERT INTO gai_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Karica Iesusa taŋga Raraŋ Aetaniacna Kacna wuocna inikca mbukatnanna, meikramtaɨra anna tɨkca ndorita reikmo oikca kituknduk aŋgɨna aiŋira mori, Iesusa minmo anna tɨkca ootta mandaca. ");
INSERT INTO gai_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ma minmo aindopatna, “Raraŋ Aetaniacna Timbigta Kapca aindoprina, ‘Kac auknanna anna mbendeirena kac.’ Na mandeaca, ne moa aŋgɨa uriraca, macmakɨmna meikramtaɨrta taupca more toc.” ");
INSERT INTO gai_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","48","Ri, memetmbaca, Iesusa meikramtaɨrmo Raraŋ Aetaniacna Kacna wuocna inikca tɨkca, minmo kam laŋ riptiri, taup ndamtaɨr paŋaindapa, tɨpemb wandik tamŋirena ramtaɨrapa, meikramtaɨrta ŋginaiŋ mbatrena ramtaɨr anikap, mina ndorimo Iesusa mo menac ndopca, taupembta tɨkca orea tambac. An mɨnna meikramtaɨra mamo kocnaia wɨtɨkca mboraca mana kamb mbaracri, ainda moca ramtaɨr paŋainda ndorimo mana mo menacna ndopca taupembta tɨk, tɨkca tambac. ");
INSERT INTO gai_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Oit ianna inikca Iesusa Raraŋ Aetaniacna Kacna wuocna inikca mbukca anna tɨkca meikramtaɨrmo Raraŋ Aetaniacna kam wembaŋ laŋna kamma riptiri. Na taup ndamtaɨr paŋaindapa, tɨpemb wandik tamŋirena ramtaɨrapa, ramtaɨr anikap, mina man ndambuŋ nakɨpatna. ");
INSERT INTO gai_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Mina kɨpca mamo aindopatna, “U aimo mbop, u i aniacapa an gargara tenna tɨkca aŋgɨca, u gan reikmo ainda morena? Mandaia ndo unmo an gargar neaŋgatna?” ");
INSERT INTO gai_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ri, ma mina kammo gaind mac nda rutiatna, “Auk toco nenmo reac ianna digdigi ianap, ne aukmo mbop. ");
INSERT INTO gai_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Digdigia gaind, Ionna meikramtaɨrmo kɨtac pukca morenanna, ne tit ndamŋire, anna tamuŋna auŋna reac, co, anna ramootna reac?” ");
INSERT INTO gai_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ri, mina ndori puŋga aindopatna, “Aia tit ndopit? Aia gaindop te, ‘Anna tamuŋna auŋna reac.’ Aindop te, ma aindopnande, ‘Aind ecte, kaina moca ne Ionmo rɨpac ŋgocor?’ ");
INSERT INTO gai_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Na aia gaindop te, ‘Anna ramootna reac.’ Aindop te, gan meikramtaɨrta tumbunna mina aindopnande, ‘Ionna ma Raraŋ Aetaniacna ramma morena ramoot ian.’ Aintik mina aimo watur puŋga rɨŋnande.” ");
INSERT INTO gai_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ainda moca mina Iesusna kammo nda rutica aindopca, “Meikramtaɨrmo kɨtac pukca momona i aniacapa gargara, Ionna tenna tɨkca aŋgɨratna, aia mba lamŋiri.” ");
INSERT INTO gai_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ri, Iesusa minmo gaindopatna, “Aind ecte, auk toco nemo mba mbopitndai, mandaia ndo aukmo an i aniacapa gargar neaŋga, aku an aiŋa morena.” ");
INSERT INTO gai_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Karica Iesusa an meikramtaɨrmo, gan kam roor keca aind mambopat, “Ramoot ian, ma ndona wainna warɨŋa moca wainar mbataca maica an wainna warɨŋmo ma raupŋirena ramtaɨr ndeidta para tɨkca minmo aindopatna, ‘Ne an mbuŋa aiŋa moca ndoritan aŋgɨ te, auknanmo aŋgɨ tɨkca eac.’ Na man tikca ma mon tawan ŋgoinna auŋ ianna taŋca anna kɨdrɨk rocot ŋgoin ndeacnande. ");
INSERT INTO gai_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Na iŋmbaia an wainara erca min aŋgɨna mɨnna tɨkatna mbatca, an wainarta warɨŋna aet, ma ndona mbaiŋna aiŋa morena ramoot ianmo aindopatna, ‘Aku toŋgorinanna, u taŋca wain warɨŋna raupŋirena ramtaɨr tambuŋa taŋca minmo mbop waraca mina umo an warɨŋna wainar neaŋ.’ Ri, an mbaiŋna aiŋa morena ramootta taŋga laruatke, an warɨŋa raupŋirena ramtaɨra mamo laŋa mba piatke, na manmo mbagɨrica ma par kamainda mac nda mataŋgat. ");
INSERT INTO gai_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ri, an warɨŋna aetta ŋgepca kabena mbaiŋna aiŋa morena ramoot ian mac mbagɨrica taŋgatke, an wain warɨŋna raupŋirena ramtaɨra man motoco, ainda pica mamo numbirta tɨpemb kirarir ŋgocraica moca, manmo mbagɨrica ma wanaiŋa nda mataŋgat. ");
INSERT INTO gai_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Karica mina an mbuniŋmo ainda moatke, ma ŋgepca mbonkaca moatna ramoot mac mbagɨrica taŋgatke, mina mamo aind kabea moca pia ŋgocraica pia ndibemb neaŋga, mamo wɨŋga larua wainna warɨŋmo raekmbaina kecamacariat. ");
INSERT INTO gai_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ainda moca an warɨŋna aetta aindopatna, ‘Aku tida moit? Laŋ, aku ndona matŋirena nuoc ŋgoin mbagɨrica taŋ te, mina manmo toriit ki?’ ");
INSERT INTO gai_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ri, an wain warɨŋna raupŋirena ramtaɨra, mina an wain warɨŋna aetna nuoca kɨprinanna watca, mina ndorimo aindopatna, ‘An ramoot, ma ndona aetna reik ma kocnai aŋgɨnandet. Aia mamo mo menac te, aia mana reikmo aetera monandet.’ ");
INSERT INTO gai_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ainda moca mina manmo aŋgɨa larua warɨŋmo raekmbaia tɨkca manmo pia menacatke. “Na an wain warɨŋna aetta an wain warɨŋna raupŋirena ramtaɨrmo, ma minmo tida moit? ");
INSERT INTO gai_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","An wain warɨŋna aetta kɨp te, ma an wain warɨŋna raupŋirena ramtaɨrmo mo menac mai te, ma an warɨŋmo aŋgɨca kabena ramtaɨra neaŋnande.” Ri, an kam roor mbaracrina meikramtaɨra, aindopatna, “Raraŋ Aetaniac, an reacmo kai watcarica laru teac.” ");
INSERT INTO gai_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Karica Iesusa minmo watta taŋga, minmo gainda digiatna, “Kaina moca mina an kammo Raraŋ Aetaniacna Timbigta Kapca tirca eacrena? ‘Na gan kaca morena wautmo, ramtaɨra anmo ŋgoreac ndopca, aŋgɨra roumbmbai nakecarica eacrena wautta, mandeaca ma kacna witta moca paŋanmbaia wɨtɨk gagraca kaca mbukca eacrenan.’ ");
INSERT INTO gai_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Na meikramtaɨra muruŋa, an waut nambat ŋgirikike te, mina gagrira kocnaii mo ŋgocrainande. Na an waut toco ramoot nambat ŋgirik te, ma an ramootmo kocnai moi umbararacarinandet.” ");
INSERT INTO gai_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ri, tɨpemb wandik tamŋirena ramtaɨrapa, taup ndamtaɨr paŋainda mina waraca gaind malamŋiat, Iesusna mbopapekna kam roora, anna min ŋgoin ndopapekna. Ainda moca mina anduna ŋgepca mamo utiŋ ndamŋiatnanna, wanaiŋ. Mina meikramtaɨr tarica rugut moca mba moatke. ");
INSERT INTO gai_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Aintik taup ndamtaɨr paŋaindapa, tɨpemb wandik tamŋirena ramtaɨr paŋainda, mina ndorimo Iesusmo ainda paruna moca, mina mana kamma waracna toŋtoŋgar koind. Ainda moca mina manmo paruna moca mina ramtaɨr ndeidmo, mandaca mina taŋga Iesusmo iŋgoroci watna moca, ma kam ianmo katti mbop te, mina mamo Romna gagrirta ramoot paŋan aniacna para tɨkca, ma mana kambca ritri waparaca mona. ");
INSERT INTO gai_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ainda moca an iŋgoroca mamo watatna ramtaɨr, mina mamo gaind madigiat, “Riripti, aia lamŋirena una kamma wandoŋ, u meikramtaɨrmo mboprena kambapa, ripti unanna gidik ŋgoin. Na u meikramtaɨrmo an kambapa, an ripti kirar kabe niŋgikca, morena. Mindacniŋ mandai irembapnan, co mandaia iremb kocortan, u an Raraŋ Aetaniacna laŋna kirarirmo, u meikramtaɨrmo aind niŋgikca morena. ");
INSERT INTO gai_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Na u tit ndamŋire? Aia an gagrirta ramoot paŋan aniac Sisamo kitukndukara neaŋ te, anna laŋ ki, co wanaiŋ?” ");
INSERT INTO gai_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ri, Iesusa mina paparua atuna, ndamŋica, ainda moca ma minmo aindopatna, ");
INSERT INTO gai_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Ne aukmo kituknduk ian wandac, anna mandaina iapa inpaŋanna ndo an kituknduk ndeacre?” Ri, mina nda rutica aindopatna, “Anna Sisanan.” ");
INSERT INTO gai_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ainda moca ma minmo gaindopatna, “Sisana reac ecte, laŋ, ne Sisananmo neaŋ, na Raraŋ Aetaniacna reac ecte, ne Raraŋ Aetaniacnanmo neaŋ.” ");
INSERT INTO gai_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ainda moca Iesusa an meikramtaɨrap eacreke, mina mamo paparuna kam ian mac paruna mɨnna wanaiŋ. Mina mana nda rutica mbopapekna kam mbaraca, mina tamtam ndamŋica kam kocora mbiracamacariat. ");
INSERT INTO gai_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Karica Sadisina ramtaɨr ndeida, mina Iesus ndambuŋ nakɨpatna, mina digdigi ianap, an ramtaɨr, mina gainda rɨpacrenan, meikramtaɨra menacrenanna, mina mba mac nda ŋgepitndai. ");
INSERT INTO gai_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Aindoprena ramtaɨr, mina Iesusmo aindopatna, “Riripti, Mosesa aimo tirca mbopatna kam ianna gaind, ‘Ramoot ianna meac ian laŋgoca eaci taŋca mombonik kocor, na iŋmbaia ma menac te, ŋarikca mana kaminna top narica mana lapmbitaca mana meac konim laŋgoca, mana mombonikca mɨrnande.’ ");
INSERT INTO gai_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Na ŋgauna mɨn, kalaip parmbaiapa mbut mbuniŋ, mina eacri, mina lacaua meac ian laŋgoca mombonik kocor, na ma mamenacat. ");
INSERT INTO gai_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ri, man ndambuŋna mana lapmbitac tuk, an meac konim mac laŋgori. ");
INSERT INTO gai_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Na iŋmbaia an ndambuŋnan toco, an meac konim mac malaŋgoat. Na an kalaip parmbaiapa mbut mbuniŋna kalaipa, an meac kabemo ainda laŋgoi taŋi mombonik kocora menac mainande. ");
INSERT INTO gai_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Na iŋmbaia an meac konim toco mamenacat. ");
INSERT INTO gai_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Na iŋmbaia an menaca mairina ramtaɨra mac nda ŋgep te, an meac konimma mandaina meac? U wat an kalaipi, mina parmbaiapa mbut mbuniŋ, mina muruŋa an meac kabe laŋgorina.” ");
INSERT INTO gai_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ri, Iesusa mina kam nda rutica, minmo aindopatna, “Gan mɨnna meikramtaɨr, mina laŋgorena. ");
INSERT INTO gai_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Na iŋmbaia Raraŋ Aetaniacna iarwarna eteacna wat aŋgɨna morena meikramtaɨr, mina menaca maica eacrenanna, Raraŋ Aetaniaca aindoprina, mina mac nda ŋgepca manap iarwarna eteacna wat aŋgɨ te, mina mba laŋgoitndai. ");
INSERT INTO gai_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Aintik an meikramtaɨr, Raraŋ Aetaniaca minmo muknan mac nda aŋgɨca mina mana mbaiŋna aiŋa morena ŋerŋgaur toc ndeac te, manapmo iarwar ndeacnande, mina mba menacitndai, mina mana mombonik ndeacnande. ");
INSERT INTO gai_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Na Moses toco, ma aimo ramtaɨra menaca mutoca mac nda ŋgeprenanna, ma aimo wandacatna. Na an ik tekernoca tac wɨratna nininimo, Mosesa aindopatna, ‘An Kacoot, ma Abraamapa Aisakapa, Iakopap, ma mina Raraŋ Aetaniac ndeacrena!’ ");
INSERT INTO gai_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Na anna, aimo ainda wandacrina, Raraŋ Aetaniaca ma menacrina meikramtaɨrta Raraŋ Aetaniaca wanaiŋ. Ma watap eacrena meikramtaɨrta Raraŋ Aetaniac. Mana lamnɨac ŋgoutta, meikramtaɨra watap eacrena.” ");
INSERT INTO gai_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ri, tɨpemb wandik tamŋirena ramtaɨr ndeida, Iesusna mbopatna kamb mbaraca, mina manmo aindopatna, “Riripti, una kambca laiŋ koind!” ");
INSERT INTO gai_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ainda moca an ramtaɨra mina nanambica mamo kabena reac ian nake mba mac nda digiatke. ");
INSERT INTO gai_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ainda moca Iesusa an ramtaɨrmo gaind madigiat, titoca moca meikramtaɨra gaindoprena, “An Raraŋ Aetaniaca babuca mbagɨrica kɨpca aimo mac nda aŋgɨna ramootmo, mina gaindoprena, ma Dewitna ŋgamaɨr? ");
INSERT INTO gai_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Na Dewit ma ndo ŋgoin, ma Ŋaparta timbigta kapca tirca eacrena kamma, ma aindopatna, ‘Raraŋ Aetaniac Kacootta aukna Kacootmo aindopatna, “U aukna par umbaia mbirac te. ");
INSERT INTO gai_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Aku una puŋnaŋgepmo aŋgɨri una kaŋgaukca tɨknande.”’” ");
INSERT INTO gai_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ri, Iesusa gaindap mac mbopatna, “Ne wat, Dewit ma ndo ŋgoinna an ramootmo, ndona Kacoot ndoprena, na titoca moca ne an ramootmo, Dewitna ŋgamaɨr ndoprena?” ");
INSERT INTO gai_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Karica meikramtaɨra muruŋa waracri, Iesusa mbopri mbuŋa ma ndona iŋa raŋgairena ramtaɨrmo gaindopatna, ");
INSERT INTO gai_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Ne tɨpemb wandik tamŋirena ramtaɨrtake, matau wat. Mina ndorimo meikramtaɨra mbik tɨkca taŋga oikrena taupembmo, mina tik ŋgapaoc roctirar tɨkca taŋ te, meikramtaɨra mbik tɨkca oikrena taupca minmo ra laŋ neaŋraŋ. Na mina toŋgorenanna, mina Iudananta mimitpac aŋgɨrena kac inikna outna mbibiracna taupemb laiŋ aŋgɨna. Na amtiam anikta ra, mina ndorimo outta mbiracrena taupemb laiŋta riacna morenan. ");
INSERT INTO gai_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Na mina, meik koinmbarmo parureke, mina, mina kaik barermo wanaiŋ naaŋgɨrena. Na mina paparuna mbembendeia roctira morenan. Ainda morena ramtaɨr, iŋmbaia ritri waparacna ra laru te, mina makuk bagaraniac ŋgoin aŋgɨnande.” ");
INSERT INTO gai_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Karica Iesusa kam ndopca maica ma watri, laimnembta ramtaɨra Raraŋ Aetaniacmo ndorita gɨmbamba momona kitukndukar aŋgɨra kɨpca, Raraŋ Aetaniacna Kacna kitukndukar tɨkrina taupmo kitukndukar tɨkri. ");
INSERT INTO gai_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Na ma watrinanna, reik kocorta meac konim ndaekmbaia, ma ndona gɨmbamba momona, kituknduk mbuniŋ nocniŋap aŋgɨra kɨpca, kitukndukar tɨkrina taupca tɨkri. ");
INSERT INTO gai_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Na Iesusa anna wattacarica gaind mambopat, “Aku nemo gidik ŋgoinna aindopnande, gan reik kocorta meac konim ndaekmbaia tɨkcapekna kitukndukca, meikramtaɨr muruŋna tɨkcapekna kitukndukarmo kundrina. ");
INSERT INTO gai_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Na gan meikramtaɨr, mina muruŋna kitukndukar minanna maeacreke, mina tɨp tekemmotem tɨkcapekna. Na an meaca ma kamaind ŋgoin, ma ndoap eacrena mɨnna kitukndukca ma an tɨkrina. Na ma ndona amta reik koikna kitukndukar kocor.” ");
INSERT INTO gai_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Karica meikramtaɨr ndeida, Raraŋ Aetaniacna Kaca watca aind mambopat, “Mina Raraŋ Aetaniacna Kacmo, watur laiŋapa, meikramtaɨra Raraŋ Aetaniacmo gɨmbambara moa neaŋrena reik laiŋmo an mbuŋa, Raraŋ Aetaniacna Kacmo lamboi laŋ ŋgoin aocrena.” ");
INSERT INTO gai_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Ri, Iesusa aindopatna, “Aku nena wandacapekna reikta kambca, aku nemo aindopnande, an ra laru te, mina an waturmo mba watcarica mina ndori tambatta mba mac eacitndai. Wanaiŋ ŋgoin. Mina an waturmo, kocnai ruki iriki mainande.” ");
INSERT INTO gai_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Karica an meikramtaɨra Iesusmo gainda digiatna, “Riripti, tumbuitta tɨk te, an reikca laruit? Na titna ŋgagatraca ndo outmbai ndaru te, aia lamŋinande, maica an reik lataruna kɨdrɨkca maica kɨpca marambuŋaica?” ");
INSERT INTO gai_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ri, ma aindopatna, “Ne ndoritake matau wat, ramtaɨr wɨtta kɨpca nemo aukna i mbuŋ nakɨpca nemo gainda parunande, ‘Aku ande an ramoot,’ te, mina aindopnande, ‘Maica ra kɨpca rambuŋaia macariri.’ Aindop te, ne kai mina kamma kai waraca raŋgai teac. ");
INSERT INTO gai_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Na iŋmbaia kabena pitriknanda, kabena pitriknandap ruŋrinanapa, pitrik kabenan ŋgoinna ndorica ruŋ te, an kam wembaŋa warac te, ne kai rugdar moca nanambi teac, an reikca gidik, mina outmbai ndarunande, na gan tiacarpaikna mamaia, ma mba mac tawi maiitndai.” ");
INSERT INTO gai_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ri, ma mimo, gaindap mac mbopatna, “Kabena pitrik waŋna ramtaɨra, kabena pitrik waŋna ramtaɨrap ruŋnande. Na kabena gagrirta ramoot paŋanna wiwitna ramtaɨra, mina ŋgepca kabena gagrirta ramoot paŋanna wiwitna ramtaɨrap ruŋnande. ");
INSERT INTO gai_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Na gan tiacarpaikna auŋemb ndeida numnumar anikca larunandet, na auŋemb ndeida nik wapatai aniacapa, roumbbeb ŋgorikca gan pitrikmo tamtamma laru te, ne watnande, mon riac tamuŋna ainta ŋgagatracarapa, ainta reik ŋgorikca an ndaru te, ne watca rugdar monande. ");
INSERT INTO gai_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Ainda moca an reikca laru ŋgocor ndeacraŋekna mɨnna, mina nenmo utiŋa nenmo mo ŋgoreaca mo te, nenmo Iudananta mimitpac aŋgɨrena kaikapa kaik ŋgorikta inkarca tɨki nena tɨpembca ritri waparacrena ramtaɨrta para tɨkca, mina nena kambca ritri waparaca mona, nenmo aŋgɨri gagrirta ramtaɨr paŋaindapa ramtaɨr paŋaindta outta naaŋgɨri wɨtɨknande, na anna mɨnɨŋa gaind, ne aukmo rɨpacrenan tik. ");
INSERT INTO gai_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Mina nemo ainda mo te, anna nena Raraŋ Aetaniacna kam wembaŋ laŋ ndopna taupca ande. ");
INSERT INTO gai_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ainda moca ne mina kamb nda ruti mbombopna kambtake, kai tamtami lamŋi teac. ");
INSERT INTO gai_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Na aku ndo, nena upembmo kamb aŋgɨ tɨk te, nenmo landamŋiar laiŋ neaŋnande, te, nenmo ritri waparaca mona moca moekna ramtaɨr, mina mba aku nena neaŋgekna kambca mba nda tapi mbopitndai, na nemo mba nda ipuŋitndai, toawanaiŋ. ");
INSERT INTO gai_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","“Te, nena amer aterapa laiplacarapa, nena racaind kabepaiknandapa, nena aikorap, mitoca ŋgepca nenmo aŋgɨri puŋnaŋgepta para tɨkca, mina nena ndeidmo mo menacnande. ");
INSERT INTO gai_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Na anna gaind, aukna ia nenap eacrenan, na meikramtaɨra muruŋa nenmo nikembkatca ŋatenande. ");
INSERT INTO gai_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Aintik nena paŋaindta lakoarta kirit ianna mba mac iŋgorocitndai. ");
INSERT INTO gai_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ainda moca ne matau wɨtɨki gagraca, ne iarwar ndeteacna wat laŋ aŋgɨca eteac laŋ ndeacnande.” ");
INSERT INTO gai_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Karica Iesusa gaindap mac mbopatna, “Ne watraŋ, lapoca ruŋrena ramtaɨra kɨpi Ierusalemmo wɨtɨki korere aŋgɨca aumba mo te, ne lamŋi ande an auŋ aniaca mo ŋgocraina mɨnna ande kɨpca marambuŋairi. ");
INSERT INTO gai_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Na an mɨn laru te, ne Iudiana pitrik inik ndeacrenanna meikramtaɨra mina kɨpcarica taukruirca taŋnandet! Na ne Ierusalem auŋ aniacna inik ndeacrenan, ne laruca kabena taupca taŋnandet! Na ne Ierusalemmo raekmbai ndeacrena auŋembta meikramtaɨra ne Ierusalem auŋ aniacna inikca mba mac taŋi mbukitndai! ");
INSERT INTO gai_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ande an raipaik mbuŋa anna Raraŋ Aetaniaca meikramtaɨrta morina kirarir ŋgorikta makukar mac nda rutinande, ainda moca Raraŋ Aetaniaca mbopatna kambca mana Timbigta Kap ndeacrena kambca ma anna moi mɨnna tɨknande. ");
INSERT INTO gai_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Na an raipaik laru te, meikpitikca nikemb tɨkca eacrenanapa, mombonikca mɨr ambrena amera, anap eacekna mɨnna ne ndoripembta kadmai, an mɨnna makuk bagaraniaca gan tiacarpaik ndarunande. Te, Raraŋ Aetaniac toco ndona nikkakatmo ma watcarica, ma an ramtaɨr tambat ŋgiriknande. ");
INSERT INTO gai_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Te, puŋnaŋgepca kɨpca mina ndeidmo pi menac te, ndeidmo tuomb naaŋgɨnande. Te, Iudana meikramtaɨr wanaiŋa Ierusalem auŋ aniac aŋgɨca, ma mina kaŋgauk ndeaci, taŋi Raraŋ Aetaniacna ŋganŋgɨrina raipaik mai te, mina taŋnande.” ");
INSERT INTO gai_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Karica Iesusa gaindap mac mboprina, “An ra ŋgoinna mon riac tamuŋa raapa, karwaiapa, guiarmo ainta ŋgagatracar anikca, min mbuŋ ndarunande. Te, gan tiacarpaikna meikramtaɨra, tamtam ndamŋica rugdar mocarica, na mina mac waraceknanna, macait witkirena mɨtmɨta waraca mina iroar inkara tamtam ndamŋica rugdar mocarinande. ");
INSERT INTO gai_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Na meikramtaɨr wɨt aniaca tamtam malamŋireke, an reikca gan tiacarpaik ndaruna moca morenanna laru te, riac tamuŋna reikta gagrar anikca muruŋa kocnai numnum rapacrina kirar toca numai te, meikramtaɨra anna wat te, rugdar mocarica, mina lamnik korere taŋi wɨnacraŋnande. ");
INSERT INTO gai_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","An mɨnna meikramtaɨra Ramootna Nuocmo watnandet, ma ndona gargar aniacapa memetacna tac aniac mbuŋa, dimirpaikna inik ndeaca kɨpnande. ");
INSERT INTO gai_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Na an reikca laruraŋ te, ne ŋgep wɨtɨkca ndorita paŋaind aŋgɨ ŋgepca wat, ande Raraŋ Aetaniaca nen mac nda aŋgɨna ra ande, kɨpca marambuŋairi.” ");
INSERT INTO gai_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Karica Iesusa minmo kabena kam roor ian mac, keca mambopat, “Ne an ik kembera wat! Kabena ikir motocmo wat! ");
INSERT INTO gai_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Maica an ikira kabena raprir mac weweru te, ne watca lamŋinande, pukrapacna kɨdrɨkca makɨpek. ");
INSERT INTO gai_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Na ainta reik larurenanmo, ne an kirar kabe ndamŋi, maica Raraŋ Aetaniacna bubuoca maica kɨpca marambuŋairi. ");
INSERT INTO gai_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Aku nemo gidik ŋgoinna aindopnande, gan mɨnna meikramtaɨr, mina menac ŋgocor ndeacraŋ te, mina an reik larueknanna, mina watnande. ");
INSERT INTO gai_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Na gan tiacarpaikapa riaca topnandet, na aukna kambca mba topitndai.” ");
INSERT INTO gai_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Karica Iesusa gaind mac mbopatna, “Ne ndoritake, matau wat. Moca ne puik gagrara memetmbac ŋgami taŋca, paŋaind roreca, ndorita tikembta eteacna reikta kakadmaica mo nari. Nenmo an makukca aind nakɨtac irik te, Raraŋ Aetaniacna ra nenmo wambani aŋgɨrekna kirar toc nakɨpnande. ");
INSERT INTO gai_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Na an ra, gan tiacarpaikna meikramtaɨra tenten ndeaceknanmo muruŋ ndarunande. ");
INSERT INTO gai_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Aintik memetmbaca ne lambica kocroca eacraŋ. Na ne Raraŋ Aetaniacmo memetmbaca mbendei, ma nenmo gagrar neaŋnande. Te, an reikca larueknanmo, ne muruŋa uriaŋgɨnandet. Te, ne Ramootna Nuocna lamnɨac ŋgoutta wɨtɨknande.” ");
INSERT INTO gai_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Na memetmbaca Iesusa meikramtaɨrmo Raraŋ Aetaniacna Kacna wuoc inikca tɨkca, Raraŋ Aetaniacna kam wembaŋ laŋna ripti neaŋi taŋi wigwaca te, ma min tɨkcarica mina raekmbai ndeacrina takur ianna mina Olip ŋgacrina takurna kaca taŋi an naŋgonande. ");
INSERT INTO gai_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ri, meikramtaɨra muruŋa ŋaŋarmuŋembca Raraŋ Aetaniacna Kacna wuocna inikca taŋrena, mina Iesusna kamb mbaracna moca. ");
INSERT INTO gai_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Na Isap Kuri Ŋgocorta Tapacna Ra Aniac, mina gaind toc ŋgacrena, Pasowana Ra Aniac, an ra laruna mori. ");
INSERT INTO gai_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Na taup ndamtaɨr paŋaindapa, tɨpemb wandik tamŋirena ramtaɨra, ndorimo Iesusa mo menacna moca moatnanna, mina meikramtaɨr tarica nanambica, ainda moca mina mana mo menacna moca taupembta mori. ");
INSERT INTO gai_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Na Ramoot Mbɨkca Iudas Iskariotna iro inik mambukat, an ramoot Iudas, ma Iesusna parniŋapa mbut mbuniŋna iŋa raŋgairena ramtaɨrta ramoot ian. ");
INSERT INTO gai_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ri, Iudasa ainda moatna mbatca, ma laruca taŋga taup ndamtaɨr paŋaindapa, Raraŋ Aetaniacna Kacna wuocna inikna aiŋa morina ramtaɨr paŋaindmo mambopat, ma ndo Iesusmo aŋgɨca mina para tɨkna taupembta ŋgorenande. ");
INSERT INTO gai_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ainda moatna mbatca, an ramtaɨr paŋainda toŋtoŋgar koinda moca, mina ŋgepca manap kam maleacat, mina Iudasmo kituknduk mbuŋ ŋgoiknande. ");
INSERT INTO gai_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ri, Iudasa, mina mbopatna kamb mbaraca toŋgoca, ainda moca ma taupembta ŋgorerina, meikramtaɨra Iesusmo waeke te, Iudasa mamo aŋgɨca an ramtaɨr paŋaindta para tɨknande. ");
INSERT INTO gai_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Karica an Isap Kuri Ŋgocorta Tapacna Ra Aniaca, malaruri. Na an ra, mina sipsipar ŋgaibmo mo menac te, mina an am te, an Pasowana Rana ndamŋina moca. ");
INSERT INTO gai_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Aintik Iesusa Pitaapa Ionmo gaindopatna, “Oŋgo taŋca aia ndori an Pasowana Ra ndeac te, amna amta reik kocro.” ");
INSERT INTO gai_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ri, maniŋa mamo aindopatna, “U toŋgorinanna aŋga taŋca ten taupca tɨkca, an amna reac kocroit?” ");
INSERT INTO gai_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Karica ma maniŋmo gaindopatna, “Oŋgo warac. Oŋgo taŋi auŋ aniac ndaru te, ramoot ianna puk wɨn aniacap aŋgɨca, kɨpi oŋmo taupca tɨki wat te. Oŋgo manap taŋca, ma kac ianna inik mbuk te, oŋgo manap an kacna inikca mbuk. ");
INSERT INTO gai_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Oŋgo an kacna aetmo aindop, ‘Ririptia umo gainda digirina, “Una kacna diabca ten ndeacre? Aku ndona iŋa raŋgairena ramtaɨrap, an Pasowana amna reaca moca amna. Te, an Pasowana Rana ndamŋina.”’ ");
INSERT INTO gai_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Te, ma oŋmo tamuŋmbaina diab aniac ianna, wandac mbopnande, ‘An kacna diab inikna mbiracna taupembapa, gagamna bara kocro maeacreke.’ Aintik oŋgo aina gagamna reikmo, an inikca tɨkca kocro!” ");
INSERT INTO gai_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Karica maniŋa taŋgatnanna, na maniŋa watri, an Iesusna mbopatna kirara reikca aind ndeacri. Na maniŋa Pasowana amta reikmo kocrorinan. ");
INSERT INTO gai_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Karica an amna reac amna ŋgaŋganŋgɨna mɨn laruatke, Iesusa gagamna taupca mbiracatke, mana up aŋgɨrena ramtaɨr toco manap mambiracat. ");
INSERT INTO gai_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ri, ma minmo aindopatna, “Aku nenapmo gan Pasowana Rana, gagamna inik ndeacna toŋtoŋ ŋgoin, na an mai te, iŋmbaia aku gɨrgɨr aniac aŋgɨca menacnande. ");
INSERT INTO gai_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Aintik aku nenmo aindopnande, aku gan amna reaca mba mac amitndai, taŋi an reikta mɨnɨŋa gidik ŋgoin ndaruca, Raraŋ Aetaniacna bubuoca laruekna mɨn mbuŋ.” ");
INSERT INTO gai_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Aindopacarica ma Raraŋ Aetaniacmo mbendeica kam laŋ neaŋgarica, ma wain pukna kab aŋgɨca minmo neaŋga aindopatna, “Ne gan wain pukna kab aŋgɨca ndorimo teker tekera, biŋaia am. ");
INSERT INTO gai_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Aintik aku nenmo aindopnande, aku gan wain pukca mba mac amitndai, mandeacna mɨnna tɨkca, taŋi Raraŋ Aetaniacna bubuoc laruekna mɨn mbuŋ.” ");
INSERT INTO gai_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Karica ma tapac ian aŋgɨca, Raraŋ Aetaniacmo mbendeia kam laŋ ndopacarica, ma tapac witkica, minmo aindopatna, “Ganna aukna tik, nena moa aku maneaŋgek, na ne aŋgɨ am te, memetmbaca ne ainda moraŋ te, aukna ndamŋi.” ");
INSERT INTO gai_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Karica mina amba maiatke, ma kabena wain pukna kab aŋgɨca, anmo, an kirar kabea moca, aindopatna, “Gan kab wainna, anna aukna racaindpaik, an mbuŋ Raraŋ Aetaniacap kam ŋgam leacrina, an racaindpaikca nena moca ruŋkinande. ");
INSERT INTO gai_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Na ne wat, mandaia, aukmo aŋgɨri puŋnaŋgepta para tɨkna moca morena ramoot, mandeaca ma aukap gan amta reik tɨkca ambrena taupca mbiraca maeacreke. ");
INSERT INTO gai_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Aintik Ramootna Nuoc, atua Raraŋ Aetaniaca mamo menac ndopca mbopatna kirar, ma ainda monande, na an ramoot, ma manmo puŋnaŋgepta para tɨkrinan, man mbaina kakadmai ŋgoin, ma makuk aniac ŋgoin aŋgɨnande.” ");
INSERT INTO gai_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ri, mina an kam mbaraca ŋgepca, ndorimo ian, ian madigiri, “Aia mandaia ndo, ainda moit?” ");
INSERT INTO gai_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Karica Iesusna up aŋgɨrena ramtaɨra, ndorimo ipuŋga mambopri, mandaia ndo mina ramoot paŋan ndeacit. ");
INSERT INTO gai_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ri, Iesusa minmo gaindopatna, “Gan Iudana meikramtaɨr wanaiŋna gagrirta ramtaɨr paŋaind, mina ndorita meikramtaɨr bubuocrena gagrar minanna tamuŋ, ainda moca mina ndorita meikramtaɨrmo mataua bubuocrena irembap. ");
INSERT INTO gai_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Na ne, ainda kai mo teac. Kari ŋgoin ndacari, ramootta nena rɨkmo aniaca moca tamuŋmbai ndeacrenan, ma mac nda irikca ramoot aniacna kirara wanaiŋ, ma mooŋnuoc tekerna kirar ndeac. Na nena ramoot paŋan, ma aiŋna ramoot eacrena kirar ndeac te, nenmo biŋa mo. ");
INSERT INTO gai_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Na ne titoc ndamŋire, titocna ramootta ndo outmbai ndeacit, an amna reac ambrena ramoot ki, ki, an amna reac, biŋairena aiŋna ramootta ndo aniac?” Ri, ma aindopatna, “An ambrena ramoot, man niŋgikca ndo aniac. Na aku ndo, nena rɨk ndeac te, nenmo otaca, nena mbaiŋa mo te, nenmo opotaca momona aiŋna ramootna kirar ndeacnande. ");
INSERT INTO gai_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Na maica aukmo ainta totowaiar laruri, ne aukmo mba kacrepri, ne aukap eacri. ");
INSERT INTO gai_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Na aukna Aetta aukmo an bubuocna gargara neaŋrina, aku nen motocmo, an bubuocna gargara nenmo neaŋnande. ");
INSERT INTO gai_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Aintik ne aukna an bubuocna inikna amta reik tɨkrena bar auknan, ne anna mbiraca amta reikapa puk amnande, te, gagrirta ramtaɨr paŋaind mbiracrena taupca ne anna mbiraca, Israelna parniŋapa mbut mbuniŋna wiwitta raupŋinandet.” ");
INSERT INTO gai_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Karica Iesusa aindopatna, “Saimon, Saimon, u warac, Ramoot Mbɨkca aindoprina, ma nena rɨtɨpaikmo ramtaɨra ndorita wit aŋgɨca ŋaŋawir irikna moca, aŋgɨra numairena kirar aŋgɨri numainande. ");
INSERT INTO gai_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Aintik aku una moca mbendeiatna, ŋarikca una rɨtɨpaca irik narica, ainda moca u rɨpaca auk ndambuŋ mac nda kɨp te, ndona laiplacar motocmo moi gagra.” ");
INSERT INTO gai_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ri, Pita mamo aindopatna, “Kacoot, aku kocrorina, aku unap kac ŋgoreaca mbuk te, unap menacnande.” ");
INSERT INTO gai_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ri, Iesusa mamo aindopatna, “Pita, aku umo gaindopnande, mandeac mouŋa kackur ianna ap ŋgocor ndeacraŋ te, u kɨdrɨk mbonkaca aindopnande, u aukmo lamŋi ŋgocor.” ");
INSERT INTO gai_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Karica Iesusna iŋa raŋgairena ramtaɨrmo ma aindopatna, “Aku nemo ndona aiŋa mona moca, nenmo mandaca taŋgatna mɨnna, ne mba kituknduk aocrena taum ianap mba aŋgɨatke, na par ŋgutiŋga taŋrena ramb ianna mba aŋgɨatke, na ortɨmbɨk ŋgapaocniŋ ianap mba aŋgɨa taŋgatke, ne wanaiŋa taŋgatna, na an mɨnna nemo reac ianna matpiat ki, wanaiŋ?” Ri, mina aindopatna, “Wanaiŋ?” ");
INSERT INTO gai_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Na ma minmo aindopatna, “Mandeaca u mandaia kituknduk aocrena tukutap, par ŋgutia taŋrena larkamap u aŋgɨ, na u mandaia bugrim ŋgocor, u ndona tik ŋgapaocmo, mbik tɨkca oikrena taupca tɨkca, mina oik te, u an kituknduk aŋgɨca, ndona bugrim ŋgoik. ");
INSERT INTO gai_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Aintik Raraŋ Aetaniacna Timbigta Kapna kamma aukmo aindoprina, ‘Meikramtaɨra mamo wat te, ramoot ŋgoreac ianna kirar ndamŋinande,’ an kamma paparua wanaiŋ, anna gidik, meikramtaɨra muruŋa aukmo ainda monande. Aintik Raraŋ Aetaniacna Timbigta Kapca mboprina reikta kirar, ma aukmo aind ndarunande.” ");
INSERT INTO gai_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ri, mana iŋa raŋgairena ramtaɨra mamo aindopatna, “Kacoot, u wat, aia bugrim mbuniŋ niŋgikap maeacreke.” Na ma minmo aindopatna, “Anna ma mɨn.” ");
INSERT INTO gai_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Karica Iesusa ndona memetmbaca morina kirara, ma ŋgepca auŋ aniac tɨkcarica, Olip Takura taŋna taŋgatke, mana iŋa raŋgairena ramtaɨr toco, mina ŋgepca mana iŋ maraŋgaiat. ");
INSERT INTO gai_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ri, ma taŋga an taup ndaruca, ma minmo aindopatna, “Ne toco mbendei, ŋarikca nenmo totowai ian laru te, moca ne anna irik nari.” ");
INSERT INTO gai_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Aindopacarica ma ŋgepca mimo waekeca dammbaia tɨkca ma tutupniŋ rɨmbɨtca, ma gainda mbendeia mambopat, ");
INSERT INTO gai_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Ate, u ndo toŋgo te, u gan gɨgɨrara auk ndambuŋ nakɨpna morenanmo mo kecari, aku umo anna digirena, u aukna toŋtoŋna digdigia kai raŋgai teac, u ndona toŋtoŋ mbuŋa mo.” ");
INSERT INTO gai_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ri, Raraŋ Aetaniacna mbaiŋna aiŋa morena ŋeroŋ ianna kɨpca laruca, manmo moa magagrat. ");
INSERT INTO gai_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Na Iesus, ma gɨrgɨr aniacap tik, ma paŋpaiŋ ŋgoin mambendeiri, na mana tikna gaupgaupa racaind larurena kirar ndaruca pitrik mairikri. ");
INSERT INTO gai_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Karica ma mbendeia maica, ma ŋgepca ndona iŋa raŋgairena ramtaɨr tambuŋa nda taŋga, wattatnanna mina iroar inkara makukapa kadmaiacarica ŋgori. ");
INSERT INTO gai_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Na ma minmo aindopatna, “Ne tida mona naŋgore? Ne ŋgepca mbendei, ŋarikca nenmo totowai ian laru te, ne anna moca irik nari.” ");
INSERT INTO gai_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Na Iesusa kam ndopre mbuŋa, ramtaɨrta tumbun aniac ianna kɨpca laruca. An tumbunna inik nakɨpatna ramoot ianna, mana iŋa raŋgairena ramtaɨr parniŋapa mbut mbuniŋna ramtaɨrta ramoot ian, na mana ia Iudas, ma ndo an ramtaɨrmo taup wandaca kɨpca laruca, ma Iesusmo pipopotaca mona taŋga rambuŋaiatke. ");
INSERT INTO gai_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ri, Iesusa manmo gainda digiatna, “Iudas, u ndomo Ramootna Nuocmo, gan pipopotacna tɨp mbuŋa parua moca manmo puŋnaŋgepta para tɨkna moek, a?” ");
INSERT INTO gai_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ainda moatke, mana iŋa raŋgairena ramtaɨra manap eacrinanna, mina wattatnanna maica an reac laruna mori, mina aindopatna, “Kacoot, aia mimo bugrimniŋ mbuŋa ruŋna mamoek?” ");
INSERT INTO gai_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ri, mina ianna ŋgepca bugrim mbuŋa, taup ndamoot paŋan aniacna mbaiŋna ramootmo waca, mana koar umbai katacakeca mbutukatke. ");
INSERT INTO gai_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Na Iesusa watta taŋga aindopatna, “An kirarira kari ŋgoin ndacari.” Na ma an mbaiŋna ramootna koarmo utiŋgatke, mana koara laŋ mac mamoat. ");
INSERT INTO gai_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ri, Iesusa ndo aŋgɨna kɨpatna, ramtaɨr paŋaindapa, taup ndamtaɨr paŋaindapa Raraŋ Aetaniacna Kacna wuocna inikna aiŋa morina ramtaɨr paŋaindap, mina ndorimo man aŋgɨna moatke. Ma minmo aindopatna, “Ne bugrimarapa paraiŋap aŋgɨca kɨpapeknanna, anna makɨmreke ruŋrena ramootta pi leaca aŋgɨna nakɨpapekna kirar toc? ");
INSERT INTO gai_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Na memetmbaca aku nenapmo, Raraŋ Aetaniacna Kacna wuocna inikca nenapmo ra, ra katuca eacri. Ne auk aŋgɨnake ainda mba towairi, mandeaca neaupna gargara nenmo wɨŋga kɨtaca, ande nena mɨn matɨkca.” ");
INSERT INTO gai_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Karica Iesusa mbopca maiatna mbatca, mina mamo utiŋga aŋgɨra taŋga, taup ndamoot paŋan aniacna kac naaŋgɨra mbukatke. Ri, Pita ŋgepca mina iŋmbaia tawancait motem maraŋgairi. ");
INSERT INTO gai_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Na ramtaɨr ndeida mina an kacna wuoc inikmo tac keca mbiraca eacrina. Ri, Pita kɨpca mbukca minap mbiraca eacri. ");
INSERT INTO gai_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Karica mbaiŋna meac ianna Pitamo taca mbiraca eacrinanna tɨkca watca matau watamaica ma aindopca, “Gan ramoot toco, Iesusap eacrina ramoot ian.” ");
INSERT INTO gai_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Aindopatke, Pita an meacmo gaind mawawɨriat, “Meacmbitac, aku manmo lamŋi ŋgocor.” ");
INSERT INTO gai_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Karica eaca mandaca iŋmbaia ramoot ian tuk, manmo watca aindopatna, “U toco mina ian.” Ri, ma aindopatna, “Ramoot, aku wanaiŋ.” ");
INSERT INTO gai_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Karica eaca kɨdrɨk kecariatke, kabena ramoot ian tuk, kam gargar ŋgoin mbuŋa aindopatna, “Gidik ŋgoin, ma toco Galilina ramoot ian, ma manap eacrena ramoot.” ");
INSERT INTO gai_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ri, Pita aindopatna, “Ramoot, aku una mbopapekna kamma, aku lamŋi ŋgocor ŋgoin.” Ma an kam ndopri mbuŋa, kackura andu maapat. ");
INSERT INTO gai_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ri, Kacootta nda kumbakeca, Pitamo watta gagracariatke. Pita Kacoot mbopatna gan kam malamŋiat. Kacootta manmo gaindopatna, “Mandeac mouŋa kackura ap ŋgocor ndeacraŋ te, u kɨdrɨk mbonkaca aindopnande, ‘Aku manmo lamŋi ŋgocor.’” ");
INSERT INTO gai_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Na Pita an kam ndamŋica, laruca ae ŋgoreac ŋgoin maaeri. ");
INSERT INTO gai_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Na an ramtaɨra Iesusmo utiŋrinanna, manmo komea mbopri, mamo mapiri. ");
INSERT INTO gai_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Na mina mana lamnɨacniŋmo, raraŋit mbuŋa tamaia, manmo madigiri, “U rambca morena ramtaɨr mboprena kirara moca aimo mbop, una pirena ramootna ia mandai?” ");
INSERT INTO gai_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Na mina manmo kabena peperena kamb ŋgorik ndeidap mamo mambopri. ");
INSERT INTO gai_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Maica auŋa larua keca ra gari, Iudana ramtaɨr paŋainda kɨpca puniri, taup ndamtaɨr paŋaindapa tɨpemb wandik tamŋirena ramtaɨrap. Mitoco kɨpca laruca mina ndorimo aŋgɨa tumbunna tɨkca. Mina ŋgepca Iesusmo aŋgɨra taŋga, ndorita ninik waŋgorta ramtaɨr tambuŋa tɨkca. ");
INSERT INTO gai_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Mina mamo madigiat, “U aimo mbop, unmo Raraŋ Aetaniaca babuca mbagɨrica kɨpca aimo mac nda aŋgɨna ramoot ki, wanaiŋ?” Ri, ma minmo aindopatna, “Aku mbop te, ne mba rɨpacitndai. ");
INSERT INTO gai_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Na aku nenmo reac ianna kamma digi te, ne aukna kamma mba nda rutiitndai. ");
INSERT INTO gai_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Na mandeaca tɨkca taŋgekna mɨnna, Ramootna Nuoc, ma Raraŋ Aetaniacna par umbaia mbiracnande. Na Raraŋ Aetaniac ma gargar aniacapnan.” ");
INSERT INTO gai_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ri, mina muruŋa mamo madigiat, “Na u Raraŋ Aetaniacna Nuoc ki?” Na ma minmo aindopatna, “Ne ndori mboprena, aku gade man.” ");
INSERT INTO gai_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Karica mina muruŋa ŋgepca aindopatna, “Aia kabena meikramtaɨrmo, mana morena kirarirtake, kai mac aŋgɨ kɨpca digi ore teac, ma gade ndona up mbuŋa mbopapeke, aia waracapekna.” ");
INSERT INTO gai_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Karica an ramtaɨr paŋainda muruŋ naŋgepca, Iesusmo Iudiana inikca raupŋirena ramoot paŋan, Pailat ndambuŋ naaŋgɨra mataŋgat. ");
INSERT INTO gai_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Taŋga mana morina reikta kambca Pailatmo, mina aindopatna, “Aia gan ramootmo utiŋga aŋgɨra kɨpapeknan, mana morena kirarira aia mawatri, ma aina meikramtaɨrmo aŋgɨri taup wandoŋa taŋ ŋgocor. Ma aimo Romna gagrirta ramoot paŋanmo kituknduk neaŋ narica, anna wandɨk tɨkri. Na ma ndomo aindopca, ‘Aku ande an ramoot, Raraŋ Aetaniaca babuca mbagɨrica kɨpca aimo mac nda aŋgɨna ramoot, ma gagrirta ramoot paŋan.’” ");
INSERT INTO gai_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ri, Pailatta Iesusmo gaind madigiat, “U Iudananta gagrirta ramoot paŋan ki?” Ri, ma rutica gaindopatna, “U ande mambopri.” ");
INSERT INTO gai_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Na Pailatta taup ndamtaɨr paŋaindapa an meikramtaɨrmo aindopatna, “Aku gan ramootna moa ŋgocrairina tɨp ianna wat ŋgocor.” ");
INSERT INTO gai_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ri, mina andu naŋgepca kamb gagrar koind puŋga aindopatna, “Ma gainda morena, ma Iudiana inikna pitrikca muruŋa tamtam ŋgoinna taŋrena, ma Galilia tɨkca taŋgeknanna, kɨpi gan aina auŋ aniac ndarunande, na ma meikramtaɨrmo mimitpacap neaŋga taŋreke, mina iroara moa ŋgeprena.” ");
INSERT INTO gai_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pailatta an kam mbaraca ma minmo gainda digiatna, “An ramootta ma Galilinan ki?” ");
INSERT INTO gai_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Na Iesusmo Pailatta lamŋirina, ma Erotna raupŋirena inik ŋgetacndiŋ nakɨpatna ramoot ian, aintik Pailatta Iesusmo Erot ndambuŋ mac nda mbagɨrica mataŋgat, an mɨn toco Erotta kɨpca Ierusalem ndeacri. ");
INSERT INTO gai_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Karica Erotta Iesusa watatke, ma toŋtoŋ ŋgoin, ma Iesusna morina reikta kamma waraca, ndomo mana watna moca kɨdrɨk rocot ŋgoin malambiat. Ma ndomo Iesusmo ŋgagatracara mo te, ndomo anna watna moca. ");
INSERT INTO gai_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ainda moca ma Iesusmo digdigiar wɨt aniac ŋgoinna digiatna, ri, Iesusa mana digdigiarta kam ianna mba nda rutiri, wanaiŋ ŋgoin. ");
INSERT INTO gai_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ri, an taup ndamtaɨr paŋaindapa tɨpemb wandik tamŋirena ramtaɨr, mina laruca Iesusna outta wɨtɨkca, mina mamo kamb gagrar puŋga aŋgɨakea mambopri. ");
INSERT INTO gai_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Aintik Erotapa mana ruŋrena ramtaɨr, mina Iesusmo taŋbugainna kamb topatke, manmo peperearta, kamb topca maica, mamo tik ŋgapaoc laŋ ian neaŋga aoca, mamo Pailat ndambuŋ mac nda mbagɨrica mataŋgat. ");
INSERT INTO gai_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Na an ra ŋgoinna Erotta Pailatmo, aŋgɨa ndona aikndamoot mamoat, ŋgaua ma manmo ndona puŋndamootta moca morina. ");
INSERT INTO gai_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Karica Pailatta taup ndamtaɨr paŋaindapa, ramtaɨr paŋaindapa, meikramtaɨr motocmo muruŋ ŋgaca punica. ");
INSERT INTO gai_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ma minmo aindopatna, “Ne an ramootmo auk ndambuŋ naaŋgɨra kɨpca, ne aindoprina, ‘Ma meikramtaɨrta iroara moa ŋgetrikirena ramoot.’ Na ne eacri, aku mamo mataua gagraca digirina an reikta moca, na aku mana tɨp ŋgoreac ianna wat ŋgocor, aku aind ndamŋirina, ma an reikca ne mboprenanna, ma mo ŋgocor. ");
INSERT INTO gai_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Na Erot toco, ma an iro landamŋi kabeap tik, ma manmo ai ndambuŋa nda mbagɨrica kɨprina. Na ne warac, gan ramootta tɨp ŋgoreac ianna mori co, aku mana mo menacna kam ndop mbe. ");
INSERT INTO gai_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Aintik aku manmo pi niŋgikca pica, watcarica ma taŋnande.” ");
INSERT INTO gai_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Karica an meikramtaɨra muruŋ naŋgepca, kamb anik keca gaind ŋgaca mbopatna, “An ramootmo mo menac te, aimo Barabas watcarica ma kɨp.” ");
INSERT INTO gai_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Na an ramoot Barabasmo, mina mamo kac ŋgoreaca tɨkca eacrina ramoot. Ma kaeg aniac ianna Ierusalemma tɨkca moca, an auŋ aniacna inikna ramoot ianna pia menaca, ainda moca mina mamo kac ŋgoreaca tɨkca eacrina. ");
INSERT INTO gai_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Karica Pailatta Iesusmo watcarica taŋna iroap tik, ma meikramtaɨrmo mac nda mbopatke. ");
INSERT INTO gai_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Wanaiŋ, an meikramtaɨrta tumbunna kam keca aindopatna, “Mamo ik naaŋgɨ kerac, mamo ik naaŋgɨ kerac.” ");
INSERT INTO gai_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ri, Pailatta kɨdrɨk mbuniŋ ndopacarica, karica, kɨdrɨk mbonkacnan mbuŋa, ma minmo mac madigiat, “Tida moca? Ma kaia moa ŋgocraica? Aku man morina reac ianna wat ŋgocor. Aintik aku mana mo menacna kamma mba mbopitndai, aku mamo pi niŋgikca pica watcarica ma taŋnande.” ");
INSERT INTO gai_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ri, mina Pailatmo anduna gagramacariat, Iesusmo ik naaŋgɨ keracna moca kamb gagrar maneaŋri. Mina mbopatna kambca Pailatna kammo wɨŋga kɨtacatke. ");
INSERT INTO gai_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ainda moca Pailat, ma mina kamma raŋgaica, Iesusmo mo menacna kammo, laŋ mambopat. ");
INSERT INTO gai_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ri, mina Pailatmo an Ierusalemma tɨkca kaeg aniaca moa ŋgepca ramootta pia menacatke, Romna lapoca ruŋrena ramtaɨr paŋainda manmo aŋgɨca kac ŋgoreaca tɨkatna ramootmo, watcarica laruna moca mbopca, Pailatta manmo wattacarica ma taŋri. Na Pailatta an ramtaɨrta kamma raŋgaica, Iesusmo aŋgɨra lapoca ruŋrena ramtaɨrta par matɨkat. ");
INSERT INTO gai_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Karica lapoca ruŋrena ramtaɨr, mina Iesusmo ik naaŋgɨ keracna moca, aŋgɨra laruri, Sairinina auŋna ramootta an auŋ aniacna inikca mbukna taŋri, na mina manmo mandauprikiat, mana ia Saimon, mina manmo anna tɨkca, mamo Iesus keracna moca aŋgɨra laruatna ik neaŋga mbukca, ma an mbukca Iesusna iŋ mataŋgat. ");
INSERT INTO gai_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ri, meikramtaɨrta tumnamb anikca mana iŋa taŋri, na meik ndeida mana nakadmaica aea taŋri. ");
INSERT INTO gai_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Karica Iesusa nda kumbakeca watca, an meikmo aindopatna, “Ne an Ierusalemna meikpitik, ne auk nake kai ae teac, ne ndoripembapa ndorita mombonikta moca anna ŋgae. ");
INSERT INTO gai_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Na ne warac, iŋmbaia kɨdrɨk ian laru te, mina aindopnande, ‘Ne kopica eacrena meikpitikapa, mombonikca mɨr ŋgocor ndeacrena meikpitikapa, mombonikmo mɨr neaŋam ŋgocorta meikpitikap, ne an meiki, ne toŋgonande.’ ");
INSERT INTO gai_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","An kɨdrɨkna mɨn laru te, mina taukruir anikapa tekirmo aindopnande, taukruir anik, ‘Ne kapuca ai nambat ŋgirik te, taukruir tekira aimo aŋgɨ iŋgoroc.’ ");
INSERT INTO gai_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ainda moca mandeaca mina an ikca pukap eacrenanmo ainda mo te, laŋ an ikca guruca eacrena ik motocmo an iro kabea titoca tɨki moit?” ");
INSERT INTO gai_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Karica an lapoca ruŋrena ramtaɨra, kabena tɨp ŋgoreaca moatna ramoot mbuniŋmo, mina maniŋmo Iesusap tɨkca mo menacna moca. ");
INSERT INTO gai_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Mina aŋgɨa taŋga taup ian ndaruca, an taupna imo mina anmo gaind ŋgacrena, Paŋan Tiaŋgapna Gagar. An taupca tɨkca, mina Iesusmo ik naaŋgɨa keracatke, an tɨp ŋgoreaca moatna ramootniŋmo aŋgɨca, ianmo mana par aeŋmbaina ik nakeracatke, ianmo mana par umbaina ik makeracat. ");
INSERT INTO gai_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ri, Iesusa aindopatna, “Ate, u mina moapekna tɨp ŋgoreacmo mo kecari, mina lamŋi ŋgocor tik, mina ainda moapekna.” Karica lapoca ruŋrena ramtaɨra, ŋgepca mana tik ŋgapaoc aŋgɨca, ndorimo an mbuŋa matɨp rocot ŋgacrina gegerei nagereica an reik maaŋgɨrat. ");
INSERT INTO gai_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ri, an meikramtaɨra wɨtɨkca watri, Iudana ramtaɨr paŋainda, Iesusmo pepereca aindoprina, “Ma kabena meikramtaɨr ŋgotacrena, na Raraŋ Aetaniaca manmo larapaca ma an ramootta Raraŋ Aetaniaca babuca mbagɨrica kɨpca aimo mac nda aŋgɨna ramoot, gidik ecte, kaica ma ndomo otac ŋgocor?” ");
INSERT INTO gai_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Na an lapoca ruŋrena ramtaɨr toco, kɨpca rambuŋaica, mamo pepereca mbopri, manmo mambarina puk neaŋca amna mori. ");
INSERT INTO gai_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","38","Na mina ik waŋ ian aŋgɨca, kambca anna tirca maica aŋgɨa mana paŋanmo tamuŋmbai nambatta tɨkca, aindopatna, “Ganna Iudananta Gagrirta Ramoot Paŋan.” Ri, mina mamo gaindopatna, “U Iudana Gagrirta Ramoot Paŋan ecte, u ŋgepca ndomo otac.” ");
INSERT INTO gai_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Karica tɨpemb ŋgorikca morina ramootniŋmo, mina Iesusap keracrina, ramootniŋna ianna Iesusmo peperena kam ŋgoreacmo gaindopatna, “U Raraŋ Aetaniaca babuca mbagɨrica kɨpca aimo mac nda aŋgɨna ramoot ecte, u ndo ŋgotac te, aŋmo tocmo otac.” ");
INSERT INTO gai_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ri, ianna an kam mbaraca, mamo kaega moca aindopatna, “U toco manap an makuk kabe aŋgɨca maeacreke, na u Raraŋ Aetaniac nake, mba nanambireke, a? ");
INSERT INTO gai_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Na mina aŋmo mo menacna morena tɨp kirara, anna mina tɨp kirar wandoŋa morena. Na anna wandoŋ, aŋga ndoniŋna morina tɨpemb ŋgorikta moca menacnande, na gan ramoot, ma tɨp ŋgoreac ianna mo ŋgocor.” ");
INSERT INTO gai_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ri, ma Iesusmo gaindopatna, “U Gagrirta Ramoot Paŋanna mo te, u aukna ndamŋi.” ");
INSERT INTO gai_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ainda moca Iesusa manmo gaindopatna, “Aku unmo gidik ŋgoinna aindopnande, mandeaca u an tamuŋna auŋ laŋa aukap eacnandet.” ");
INSERT INTO gai_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Maica rana ŋgaŋganŋgɨa gaca rɨmbɨŋa rɨŋri, ra andua pikatke, gan tiacarpaikca neaupdiriŋ aniaca wɨŋga kɨtaca, eaca taŋga wigwacmbaina ŋgaŋganŋgɨa mbonkac aŋgɨatke. ");
INSERT INTO gai_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","46","Rana memetaca an mɨnna pikatke, Iesusa kam aniac keca, gaindopatna, “Ate, aukna ŋeroŋa una parnambat mairikek.” Aindopca, ma andu mamenacat. Ri, Raraŋ Aetaniacna Kacna tɨŋ nakeraca eacrina, raraŋitta titacatɨka waŋniŋ malaruat. ");
INSERT INTO gai_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ainda moatke, lapoca ruŋrena ramoot paŋanna an reikca watca, ma Raraŋ Aetaniacna, i aŋgɨra ŋgepca gaindopatna, “Gidik ŋgoin, an ramootta tɨp ŋgoreac ianna mo ŋgocor, ma ramoot wandoŋ ŋgoin.” ");
INSERT INTO gai_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ri, an meikramtaɨra an laruekna reac mbatna moca, kɨpca punica eacrinanna, an reac laruapeknanna watca, mina kadmaiacarica ndorita kakadmaina ŋgagatrac wandaca ndorita mapdɨŋara pica, ndorita kaikca nda mataŋgat. ");
INSERT INTO gai_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ri, Iesusna aikorapa, meikpitikca mana iŋa raŋgaica, Galili tɨkcarica kɨpatnanda, mina tawancait motemma wɨtɨkca an larurina reikca mina mataua watatna. ");
INSERT INTO gai_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Karica ramoot ian, mana ia Iosep. Ma Iudana auŋ teker iannan, na mina Arimatia ŋgacrina auŋna ramoot. Na an ramoot, ma ramoot wandoŋ laŋ, ma toco ninik waŋgorta ramtaɨrta inik ndeacrena tumbunna ramoot paŋan ian. ");
INSERT INTO gai_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Na ma an ninik waŋgorta ramtaɨr paŋaind ndeida moatna tɨpembta kirarira ma anna watca, ma ainda toŋgo ŋgocor, ma Raraŋ Aetaniacna bubuoc kɨpeknanna moca anna nakocroca lambia eacrina. ");
INSERT INTO gai_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Karica an ramoot, ma Pailat ndambuŋa taŋga manmo Iesusna waɨr aŋgɨna taŋna digica, Pailatta manmo laŋ ndoprina mbatca. ");
INSERT INTO gai_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ma taŋga Iesusna waɨra ik nakeraca eacrinan aŋgɨr irikca, mana waɨrmo raraŋit gogok mbuŋa tamaia, aŋgɨra taŋga waut aniac laoŋga eacrena, mukna inikca tɨkatna. Na ŋgaua mina waɨr ianna anna mutoc ŋgocor, mana waɨrmo, ma aŋgɨra mbukca an matɨkat. ");
INSERT INTO gai_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","An ra, anna amta reik kocrorena ra, ma maica nenepuna rambuŋaia taŋri, Raraŋ Aetaniacna Wɨktɨtɨkna Ra maica kɨpca rambuŋaiacariri. ");
INSERT INTO gai_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Na Galili ŋgetacndiŋa, Iesusap ŋgepca kɨpatna meikpitikca, mina Iosepap taŋi mana mukca wat te, mana waɨrmo, Iosep tɨkeknanna watna moca mataŋgat. ");
INSERT INTO gai_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Karica an meikpitikca watta maica, mina mac nda taŋga, iŋpembta tabrirapa, mana rororaina reik aŋgɨa kocroca maica. Karica mina Tɨp Wandɨkca raŋgaica, Wɨktɨtɨkna Ra mina wɨktɨkca maeacat. ");
INSERT INTO gai_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Karica ŋgat kabena raita ra lacau ŋgoinna, meikpitikca ndori aŋgɨra kocroatna reikmo aŋgɨca, ŋaŋarmuŋ ŋgoinna, mina Iesusna mukca watna mataŋgat. ");
INSERT INTO gai_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Mina taŋga laruca wattatnanna, muk tɨŋa mboraca eacrina waut aniaca, rukica taŋga roumbmbai ndeacrina. ");
INSERT INTO gai_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ri, mina an inikca mbukca wattatnanna, Kacoot Iesusna waɨra eac ŋgocor. ");
INSERT INTO gai_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ri, mina wɨtɨkca ndorita iroar inkar puŋga, tamtam ŋgoinna gaind ndamŋia wɨtɨkca maeacri, Iesusna waɨra ten ndeacre, aind ndamŋia eacri. Na mina wattatnanna, ramooteniŋa tawi ŋgoinna mina kɨtɨmma wɨtɨkca eacri, mina wattatnanna maniŋna tikŋgapaocniŋa gogordambai, anna ma ninik metacri toc. ");
INSERT INTO gai_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Aintik an meikpitikca mina watca nanambica paŋaind ramtukca wɨkɨnna watri. Na an ramootniŋa minmo aindopatna, “Kaina moca ne an menac ŋgocor ndeacrena ramootna moca, gan menaca mutoca eacrena taup ŋgorere? ");
INSERT INTO gai_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ma ganna mba eacreke. Ma mac nda maŋgepri. Na ne gan kam nake mba mac nda keca lamŋiri, ŋgaua ma Galili ndeacri mbopatna kambca. ");
INSERT INTO gai_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ma nemo gaindopatna, ‘Ramootna Nuocmo, mina mamo aŋgɨca tɨpemb ŋgorikta makukarta ramtaɨrta para tɨkca, mina manmo aŋgɨri ik nakeraca ma menacnande. Na ra mbuniŋ maica mbonkacnan mbuŋa, ma mac nda ŋgepnandet.’” ");
INSERT INTO gai_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ri, mina mana ŋgau ndopatna kamma mac nda malamŋiat. ");
INSERT INTO gai_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Karica, mina muk tɨkcarica mac nda taŋga, mana up aŋgɨrena ramtaɨr parniŋapa mbut kabeapa, meikramtaɨrmo an laruapekna reikta kambca, minmo anna ninia mambopat. ");
INSERT INTO gai_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","An kam aŋgɨra kɨpca mbopatna meikpitikca, Ioanna, na Maria ma Makdalanan, na Maria, ma Iemisna aem, na meik ndeidap mina muruŋ nakɨpca an kambmo up aŋgɨrena ramtaɨr ndopatna. ");
INSERT INTO gai_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ri, Iesusna up aŋgɨrena ramtaɨra, an kam mbaraca anmo kam wat ian ndopca, an meikpitik mbopatna kambca, mina rɨpac ŋgocor. ");
INSERT INTO gai_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ainda moca mina waracatke, Pita anna garacna moca andu ŋgepca mukca watna moca otacarica taŋga laruca, ramtukca mukca watca mbukatnanna, raraŋgir laiŋ kamndera ndori eacri. Na ma ainda watca nda taŋca ndona kaca tɨkca an laruatna reikta tamtam ŋgoin malamŋiri. ");
INSERT INTO gai_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Meikpitikca Iesusna mukca watna moca taŋgatna ra ŋgoinna, mana iŋa raŋgairena ramooteniŋa, ndoniŋmo Emeus ŋgacrena auŋa taŋ ndopca. An auŋa tɨkca Ierusalemma tataŋa, wigwacait naŋgep te, Ierusalemmo mouŋ ndarunande. ");
INSERT INTO gai_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ri, an ramootniŋa taupca taŋri, an laruatna reikta kambca ninia mbopca mataŋri. ");
INSERT INTO gai_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Na maniŋa ndoniŋmo an laruatna reikta kambca ninia mbopca taŋri mbuŋa, Iesusa ndo ŋgoinna kɨpca maniŋna kɨtɨmma, maniŋap mataŋri. ");
INSERT INTO gai_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Na reac ianna maniŋna lamnɨaca moca, maniŋa manmo mba watarapacri. ");
INSERT INTO gai_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ainda moca ma maniŋmo gainda digiatna, “Oŋgo kainta reikta kambca ninia mbopca taŋre?” Ma aindopri, na maniŋa kakadmaina inpaŋanna kirara wɨtɨkca maeacri. ");
INSERT INTO gai_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Na maniŋna ianna, mana ia Kiliopas, ma mana kam nda rutica gaindopatna, “Auŋembta meikramtaɨr muruŋa mandeaca Ierusalem maeacreke. Na u ndo an ramoot kabe ŋgoin, u gan kɨpca taŋgapekna raita inik mbuŋa, Ierusalemna inik ndaruapekna reikca u mba lamŋiapeke?” ");
INSERT INTO gai_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ma aindopri, Iesusa maniŋmo gaind mac digiatna, “Kainta reik?” Ri, maniŋa rutica manmo aindopatna, “Aia Iesus Nasaretnan, ndarurina reikta kamb toprena. An ramoot, ma Raraŋ Aetaniacna ramma morena ramoot, ma gargar aniacap, mana mboprena kambapa, mana morena reikca Raraŋ Aetaniacna lamnɨac ŋgoutapa, meikramtaɨrta lamnik ŋgoutmo, laŋa morena. ");
INSERT INTO gai_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ainda moca aina taup ndamtaɨr paŋaindapa aina ramtaɨr paŋainda manmo aŋgɨca, Romna ramoot paŋanna para tɨkca mina mana mo menacna moca kam leaca mamo ik naaŋgɨa makeracat. ");
INSERT INTO gai_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Na outmbaica, aia aind ndamŋia rɨpacrina, an ramootmo Raraŋ Aetaniaca Israelna meikramtaɨr mac nda aŋgɨ ndopca babuatna ramoot. “Na kam ian toco gaind, an reik laruapekna iŋmbaia mina manmo rɨŋga menaca mutoca, mandeaca raia kɨpca aŋgɨra mbonkaca mori, an reaca laruapekna. ");
INSERT INTO gai_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","Ri, aina tumbunna meik ndeida ŋaŋarmuŋ ŋgoinna, mina taŋga mukca watapeknanna, Iesusna waɨra eac ŋgocor. Mina ainda wattacarica kɨpca gaindopapekna, ‘Aia Raraŋ Aetaniacna mbaiŋna aiŋa morena ŋeroŋniŋa watca maniŋa aimo gaindopapekna, “Ma mac nda maŋgepri.”’ Meikpitikca aimo aindopri aia ŋgep ŋgoreac naŋgepapekna. ");
INSERT INTO gai_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Aintik aina tumbunna ramtaɨr ndeid tukca mukca taŋga wattatnanna, meikpitik mbopatna kirara, an reikca aind ndeacri. Na mitoco mana waɨrmo wat ŋgocor.” ");
INSERT INTO gai_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ri, Iesusa maniŋmo gaind mambopat, “Oŋgo iroar kocor koind, ainda moca oŋna rɨtɨpacna iroa lawep ŋgoin, ainda moca Raraŋ Aetaniacna rambca morina ramtaɨrta mbopatna kambmo, oŋgo tawi rɨpaci lamŋi ŋgocor. ");
INSERT INTO gai_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Kaica oŋgo gainda lamŋi ŋgocor? An ramootta Raraŋ Aetaniaca babuca mbagɨrica kɨpca aimo mac nda aŋgɨna ramoot, ma gɨrgɨr bagaraniac aŋgɨracarica iŋmbai ecte, ma anna i aniac aŋgɨnande?” ");
INSERT INTO gai_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ri, ma maniŋmo mimitpaca neaŋga aindopatna, Mosesna tirca mbopatna kambta mɨnna tɨkca kɨpca rambca morina ramtaɨrta kambca, Raraŋ Aetaniacna Timbigta Kapna inik ndeacrenanna, ma ndona kam ndopatna. ");
INSERT INTO gai_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ri, mina taŋga maica maniŋna taŋ ndopca taŋgatna auŋa, mina anna rambuŋaiatke. Iesusa ndomo anduna taŋ kun ndopca taŋri. ");
INSERT INTO gai_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Na maniŋa manmo kɨraca gaind mambopat, “Ra irikca mbukca maica nenepucarina mamoek, u aŋgap pac eac.” Ainda moca ma maniŋap kac inikca mbukca mina maeacat. ");
INSERT INTO gai_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Iŋmbaia Iesusa amna moca, maniŋap gagamna taupa mbiraca. Na ma tapac ian aŋgɨca Raraŋ Aetaniacmo mbendeica kam laŋ ndopacarica, ma tapac witkica maniŋmo maneaŋgat. ");
INSERT INTO gai_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ma ainda moatke, maniŋna lamnɨacniŋa pɨarakeca manmo watta magaracat. Ri, ma maniŋna kɨtɨmma, tɨkca andu taprekecariatke. Maniŋa mamo mba mac watri. ");
INSERT INTO gai_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Karica maniŋa ŋgepca ndoniŋmo gaind mambopri, “Gidik ŋgoin, aŋga taupna kɨpreke, ma aŋmo Raraŋ Aetaniacna Timbigta Kapna kambca ninia mbopca kɨpreke, aŋna ironiŋa moa maŋgepat.” ");
INSERT INTO gai_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ri, maniŋa aindopacarica anduna ŋgepca Ierusalemma nda taŋga laruca, maniŋa wattatnanna Iesusna up aŋgɨrena ramtaɨr parniŋapa mbut kabe, mina ndorita aikorap punica eacri. ");
INSERT INTO gai_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","An ramootniŋmo, mina maniŋmo gaindopatna, “Gidik ŋgoin, ma mac nda maŋgepri. Saimonna mamo watrina.” ");
INSERT INTO gai_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Karica maniŋa taupca tɨkca ndoniŋ ndaruatna reikta kambta nininia mori. Maniŋa minmo gaindopatna, “Maica ma tapac witkiatke, aŋga manmo watta marapacat.” ");
INSERT INTO gai_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Karica Iesusna iŋa raŋgairena ramtaɨra ndori ndopca eacri, Iesusa mina rɨk ndarua wɨtɨkca. Ma minmo gaindopatna, “Ne nikinik iro wetwet laŋ ndeac.” ");
INSERT INTO gai_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Karica mina muruŋa rugdar moa nanambicarica, anmo ndorimo ŋeroŋ ianna wapat ndopca mori. ");
INSERT INTO gai_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Na ma minmo gaindopatna, “Ne kaina moca rugdar mocarica tamtam ndamŋiapeke, nanambiapekna? ");
INSERT INTO gai_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Na ne aukna parniŋapa orniŋmo wat, ganna auk, ne kɨpca aukna parniŋapa orniŋapa tikmo utiŋa wat. Ainta ŋerŋgaur, mina budirapa gagrir kocor, gan ne auk ŋgutiŋgapeke, watapekna kirarar mba watitndai.” ");
INSERT INTO gai_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Karica ma aindopacarica ma ŋgepca ndona parniŋapa orniŋa minmo mawandacat. ");
INSERT INTO gai_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Mina manmo ainda watca toŋgorinanna, mina mamo tacro rɨpac ŋgocor. Ainda moca mina iroara tamtam ndamŋiri. Na ma minmo gaindopatna, “Ne amta reik ndeidap eacre ki, wanaiŋ?” ");
INSERT INTO gai_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ri, mina ŋgepca mamo rotaca eacrina ŋgoaem tɨp aŋgɨra neaŋgatke. ");
INSERT INTO gai_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Na ma an ŋgoaem tɨp aŋgɨca, mina outta tɨkca ma maammbat. ");
INSERT INTO gai_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ri, ma minmo gaindopatna, “Aku nenap eacatna mɨnna, aku nemo gaindopca maiatna, gan reikca atua mina aukna moca tiratnanna, mina Mosesna Tɨp Wandɨkna timbigta kapca tirca eacrenanapa, Raraŋ Aetaniacna rambca morina ramtaɨrta timbigta kapca tirca eacrenanapa, Ŋaparta timbigta kapca tirca mbopatna reikta kambca gidik ŋgoin ndarunande.” ");
INSERT INTO gai_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Na ma minmo an kam ndopca, mina iroara moi pɨarca mina Raraŋ Aetaniacna Timbigta Kapna kam ndamŋi rapacna moca. ");
INSERT INTO gai_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ri, ma minmo gaindopatna, “Raraŋ Aetaniacna Timbigta Kapca gan kambap eacrena, Raraŋ Aetaniaca babuca mbagɨrica kɨpca aimo mac nda aŋgɨna ramoot, ma gɨrgɨr aniac aŋgɨca menaci mutoca, muk inikca ra mbuniŋ ndeaca mbonkacnan mbuŋa, ma mac nda ŋgepnande. ");
INSERT INTO gai_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ainda moca mana i mbuŋa mina gan tiacarpaikna pitrik waŋna meikramtaɨrmo, muruŋcamiŋmo an kamma wiwitica, meikramtaɨra iroar inkar ŋgetrikica, Raraŋ Aetaniaca mina tɨpemb ŋgorikta makukarmo mo kecarinande. An aiŋmo Ierusalemma tɨkca mo ŋgepi acnainande. ");
INSERT INTO gai_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Te, ne gan laruapekna reikta kambca, ne watapeknanmo ne ndorimo tamtamma wiwitia mbopi taŋraŋ. ");
INSERT INTO gai_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ne warac, ŋgaua aukna Aetta nemo neaŋ ndopca babuatna Ŋeroŋ Ratta, kɨdrɨk tekemmotem, aku manmo nen ndambuŋa mbagɨrica kɨpnande. Na ne gan auŋ aniac niŋgik ndabi eaca, an Raraŋ Aetaniacna gargar aŋgɨna.” ");
INSERT INTO gai_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Karica Iesusa ndona iŋa raŋgairena ramtaɨrap aŋgɨca, min warkica taŋga Betani auŋa rambuŋaica anna tɨkca. Ma ndona parniŋ aŋgɨra ŋgepca Raraŋ Aetaniacmo aindopatna, “U minmo otac.” ");
INSERT INTO gai_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Maica Iesusa minmo Raraŋ Aetaniacna opotacna kam neaŋri mbuŋa, ma min tɨkcarica Raraŋ Aetaniaca manmo aŋgɨca tamuŋna auŋ magat. ");
INSERT INTO gai_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ri, mina toŋgocarica manmo tutpemb rɨmbɨtca mana i aŋgɨra ŋgepcarica, mina Ierusalem mac nda mataŋgat. ");
INSERT INTO gai_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ainda moca mina memetmbaca Raraŋ Aetaniacna Kacna wuocna inik ndeacri, Raraŋ Aetaniacna i aŋgɨra maŋgepri.");
INSERT INTO gai_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Atu, atu ŋgoinna reikca gan tiacarpaikmo laru ŋgocor ndeacri. Kamma ma eacrena. Na Kamma ma Raraŋ Aetaniacap eacrenan, na Kamma ma ndo ŋgoinna Raraŋ Aetaniac. ");
INSERT INTO gai_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Aintik atu, atu ŋgoinna Kamma ma Raraŋ Aetaniacap eacrina. ");
INSERT INTO gai_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Na an Kam niŋgik mbuŋa Raraŋ Aetaniaca reikmo muruŋcamiŋa moa larurina. Na reac ianna kabena taup ian ndiŋa mba laruri. Wanaiŋ ŋgoin. Reikca muruŋa larurinanna, anna Kamma ndo moa larurina. ");
INSERT INTO gai_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Na eteacna watta manap eacrenan, na an eteacna watta ma meikramtaɨrta memetac. ");
INSERT INTO gai_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Na an memetaca ma neaupa metaca eacrenan, na neaupa manmo mba wɨŋga kɨtacrenanna. ");
INSERT INTO gai_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Na ramoot ianna larurinan, na mana ia Ion. Na Raraŋ Aetaniaca manmo mbagɨrica ma kɨprina. ");
INSERT INTO gai_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Na ma kam wiwitina kɨprina. Na ma an memetacna kammo wiwiti te, meikramtaɨra muruŋa mana an kammo waraca, mina rɨpacnandet. ");
INSERT INTO gai_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Na ma ndo, ma an memetaca wanaiŋ. Ma an memetacna kam niŋgik wiwitina kɨprina. ");
INSERT INTO gai_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Na an memetaca ma memetac gidik, na ma meikramtaɨrmo muruŋcamiŋa memetac neaŋrena, na ma gan tiacarpaik nakɨprina memetac. ");
INSERT INTO gai_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ainda moca Kamma gan tiacarpaik ndeacrena. Na an Kam mbuŋa Raraŋ Aetaniaca gan tiacarpaikca moa laruatna. Na gan tiacarpaikna meikramtaɨra manmo mba watta rapacrena. ");
INSERT INTO gai_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Na ma ndona auŋ mɨnɨŋa taŋrinanna, na mana barna wiwitnanna manmo mba aca tɨkatke. ");
INSERT INTO gai_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ainda moca kabena barna meikramtaɨrta wiwitta mamo aca tɨkrina, ande an meikramtaɨr tiŋgikca mana ia rɨpacrena. Na ma mimo ia aniac neaŋrina, te, mina Raraŋ Aetaniacna mombonik tarunandet. ");
INSERT INTO gai_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Na mina Raraŋ Aetaniacna mombonik tarurinanna, mina ndorita aemaetna racaind puŋga mba laruri, na tɨkna toŋtoŋ mbuŋa mba laruri, na ramootna iro mbuŋa mba laruri, wanaiŋ. Raraŋ Aetaniaca ndo mimo larapaca mina mana mombonik tarurina. ");
INSERT INTO gai_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Na Kamma ma ndo ramoot ndaruca, ma kɨpca aina rɨk ndeacrina. Na aia mana memetacna tac aniacapa i aniaca watrina. Na anna an Mooŋnuoc kabe niŋgikna memetacna tac aniacapa i aniac, Aetta mandaca kɨprina. Na kakadmaiapa kam gidik laŋa manmo mɨn ŋgoin. ");
INSERT INTO gai_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ainda moca kɨtac puk neaŋrena ramoot Ionna ma meikramtaɨrmo gaind ŋgaca mbopatna kam, “Anna an ramoot ŋgaua aku nenmo, mana moca mboprina. Na aku gaindopatna, ‘Ramootta aukna iŋmbai nakɨpna ramoot, ma aukmo out ŋgoin, na ma tamuŋmbai. Na anna mɨnɨŋa gaind, ma atu ŋgoin ndeacrena, an mɨnna aukna aemma aukmo mɨr ŋgocor ndeacri.’” ");
INSERT INTO gai_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Na kakadmaia an ramootmo mɨn ŋgoinna tɨkca eacrena, na mana an kakadmai mbuŋa ma aimo muruŋcamiŋa laŋ ŋgoinna morena. ");
INSERT INTO gai_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Na anna gidik, aia Raraŋ Aetaniacna Tɨp Wandɨkmo Moses ndambuŋa tɨkca aŋgɨrina. Na Iesus Karais mbuŋa aia kakadmaiapa kam gidik laŋ aŋgɨrina. ");
INSERT INTO gai_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Na ramoot ianna Raraŋ Aetaniacmo mba watri. Wanaiŋ, wanaiŋ ŋgoin. An Raraŋ Aetaniacna Nuoc kabe ŋgoin, ma ndo Raraŋ Aetaniac, na ma Aetmo rambuŋ ŋgoin ndeacrena, ma ndo kabe ŋgoinna aimo Raraŋ Aetaniaca wandacrina. ");
INSERT INTO gai_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","20","Ri, Iudanaŋgepca ndorita taup ndamtaɨrapa Liwaiarmo mbagɨrica mina Ierusalem auŋ aniacmo tɨkcarica mina kɨpca Ionmo gainda digirina, “U mandai ŋgoin?” Ainda moca ma minmo kam ianna mba aŋgɨra iŋgorocatke, ma minmo wandoŋa gainda wiwitia mbopatna. Na ma gaindopatna, “Aku an ramootta Raraŋ Aetaniaca babuca mbagɨrica kɨpca aimo mac nda aŋgɨna ramootta wanaiŋ.” ");
INSERT INTO gai_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ri, mina Ionmo madigiat, “Kaia? U Elaia ki?” Na ma aindopatna, “Wanaiŋ.” Na mina gaind mac digiatna, “U aina lambirena ramma morena ramoot ki?” Ri, ma mina kammo nda rutica aindopatna, “Wanaiŋ.” ");
INSERT INTO gai_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ainda moca mina manmo gaind mac digiatna, “U mbop, u mandai ŋgoin? Te, mandaibinna aimo mbagɨrica aia kɨprinanmo, aia an kamna rurutia minmo nda aŋgɨ taŋca minmo mbopna. U mandai ŋgoin?” ");
INSERT INTO gai_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ainda moca Ionna gaindopatna, “Aku an ramtaɨr kocorta taupca ramoot ianna kamma, gaind ŋgaca mboprina, ‘Kacootna taup matau.’ Na anna ramma morina ramoot Aisaia mboprina kamna kirar toc.” ");
INSERT INTO gai_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Na an ramtaɨrmo Parisina ramtaɨra minmo mbagɨrica mina kɨpatna. ");
INSERT INTO gai_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ri, mina Ionmo gainda digiatna, “Na u an ramootta Raraŋ Aetaniaca babuca mbagɨrica kɨpca aimo mac nda aŋgɨna ramootta wanaiŋ ecte, na u Elaia wanaiŋ ecte, na u an ramma morina ramootta wanaiŋ ecte, kaina moca u meikramtaɨrmo kɨtac puk neaŋrena?” ");
INSERT INTO gai_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Karica Ionna mina kambmo gainda rutirina, “Aku minmo puk mbuŋa kɨtac puk neaŋrena. Na nena rɨkna ramoot ianna maeacreke, na ne manmo mba lamŋireke. ");
INSERT INTO gai_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Anna an ramootta aukna iŋmbai nakɨprenan. Ma i aniacap, na ma aukmo kunda tamuŋmbai, na aku wanaiŋ.” ");
INSERT INTO gai_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Na Ionna Betani auŋ tekera tɨkca mbopatna kamb, anna Iodan ocmo waŋembai. Na an taupca tɨkca ma meikramtaɨrmo kɨtac puk neaŋrena. ");
INSERT INTO gai_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Na iŋmbaina ra mbuŋa, kɨtac puk neaŋrena ramoot Ionna watrinanna, Iesusa man ndambuŋ nakɨprina. Na ma aindoprina, “Ne wat! Anna Raraŋ Aetaniacna Sipsip Nuoc. Na ma kɨprinanna, ma gan tiacarpaikna meikramtaɨr muruŋna tɨpemb ŋgorikta makukara mo kecarina kɨprina. ");
INSERT INTO gai_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Na anna an ramootta ŋgaua aku mana kambmo gaindopatna, ‘Ramootta aukna iŋmbai nakɨpna ramoot, ma aukmo out ndeacnandet, na ma aukmo tamuŋ ŋgoin. Na anna mɨnɨŋa gaind, ma atu ŋgoin ndeacrina, an mɨnna aukna aemma aukmo mɨr ŋgocor ndeacri.’ ");
INSERT INTO gai_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Na aku ndo, manmo mba garacri, ma mandai ŋgoin. Na aku kɨprinanna, aku meikramtaɨrmo puk mbuŋa kɨtac puk neaŋrena, te, Israelna meikramtaɨra an ramootmo lamŋina.” ");
INSERT INTO gai_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Karica Ionna gaind mac mbopatna, “Aku watrinanna Ŋeroŋ Ratta tamuŋna auŋ tɨkcarica ŋgorac riŋnaina kirar toc ŋgirikrina. Na ma taŋga man nambatta eacri. ");
INSERT INTO gai_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Na aku ndo manmo lamŋi ŋgocor. Raraŋ Aetaniaca ndo aukmo mbagɨrica aku meikramtaɨrmo puk mbuŋa kɨtac puk neaŋrena, na an kirara ma aukmo ŋgaua aindopatna, ‘U wat te, Ŋeroŋ Ratta kɨpca iriki ramoot ian ndambuŋ ndeac te, ande an ramoot, ma meikramtaɨrmo Ŋeroŋ Rat mbuŋa kɨtac puk neaŋnandet.’ ");
INSERT INTO gai_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Na aku ndo mbuŋa watca mana kammo gainda wiwitirinan, anna Raraŋ Aetaniacna Nuoc.” ");
INSERT INTO gai_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Na iŋmbaina ra mbuŋa, Ionna mac wɨtɨkca eacri, na mana iŋa raŋgairena ramoot mbuniŋ toco manap wɨtɨkca eacrina. ");
INSERT INTO gai_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Na ma watrinanna, Iesusa taŋrena. Ri, ma aindoprina, “Ne wat! Mona Raraŋ Aetaniacna Sipsip Nuoc.” ");
INSERT INTO gai_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ri, an mana iŋa raŋgairena ramootniŋa man mboprina kamma waraca maniŋa taŋga Iesusna iŋ maraŋgaiat. ");
INSERT INTO gai_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ainda moca Iesusa uriraca watrinanna maniŋa mana iŋ nakɨpri, ma maniŋmo gainda digirina, “Oŋgo kaina reacna ŋgorere?” Na maniŋa manmo madigiat, “Rabai, u tenna kac ndeacrena?” Na an i, “Rabai,” mana mɨnɨŋa gaind, “Riripti.” ");
INSERT INTO gai_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ainda moca Iesusa maniŋmo gaindopatna, “Oŋgo kɨpca wat.” Ri, maniŋa taŋga man eacrena kaca watrina. Na an ra, maniŋa manap eacrinan, na anna mɨnɨŋa, rana ŋgaŋganŋgɨa paur mamoat, na ra mai ndambuŋa tɨkri. ");
INSERT INTO gai_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Na Andru, ma Saimon Pitana lap, ma toco ma anna ramoot ianna Ionna kam mbaraca taŋga Iesusna iŋa raŋgairina. ");
INSERT INTO gai_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Na ma Iesus tɨkcarica ma taŋga ndona kaka Saimonna moca orena mataŋgat. Na ma manmo aindopatna, “Aia Mesaiamo watrina.” Na an i, “Mesaia,” mana mɨnɨŋa gaind, “Raraŋ Aetaniaca babuca mbagɨrica kɨpca aimo mac nda aŋgɨna ramoot.” ");
INSERT INTO gai_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ainda moca ma Saimonmo Iesus ndambuŋa aŋgɨca taŋrina. Ri, Iesusa Saimonna watca ma aindopatna, “U Saimon u Ionna nuoc. Na iŋmbaia mina unmo gan i Kepasa tɨknandet.” Na an i, “Kepas” ma an i kabe, “Pita” nakirar. Na mana mɨnɨŋa gaind, “Anna waut.” ");
INSERT INTO gai_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Karica iŋmbaina ra mbuŋa Iesusa Galilia taŋna mori. Ma taŋga Pilipmo watatke, ma manmo gaindopatna, “U kɨpca aukmo raŋgai.” ");
INSERT INTO gai_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Na Pilip, ma Betsaidana ramoot, na anna Andruapa Pitana auŋ mɨnɨŋ. ");
INSERT INTO gai_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ainda moca Pilipa taŋga Natanielmo watca manmo gaindopatna, “Atua Mosesa Tɨp Wandɨkna timbigta kapca tirca eacrenanapa rambca morina ramtaɨrta tirrina timbigta kapca eacrenanna, an ramootmo aia manmo watrinan. Na ma Nasaret auŋna Iesus, na ma Iosepna nuoc.” ");
INSERT INTO gai_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ri, Nataniela manmo gainda digiatna, “Ainta auŋ Nasaretmo reac laŋ ianna laruit ki?” Na Pilipa manmo gaindoprinan, “U kɨpca wat.” ");
INSERT INTO gai_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Karica Iesusa watrinanna Nataniela man ndambuŋ nakɨprinan, na ma aindoprina, “Ne wat. An ramootta kɨprenan, ma Israelna ramoot gidik ŋgoin. Na paparuna kamb, co paparuna tɨpna kirar ianna manap eac ŋgocor.” ");
INSERT INTO gai_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ainda moca Nataniela Iesusmo ainda digiatna, “Titoca tɨkca u aukmo lamŋiatna?” Ri, Iesusa mana kambmo gainda rutirina, “An mɨnna Pilipa umo ac ŋgocora eacri, aku umo ŋgaŋɨn ikna mɨnɨŋna kaŋgaukca eacrinanna watrinan.” ");
INSERT INTO gai_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ainda moca Nataniela an kamb mbaraca aindopatna, “Riripti, u Raraŋ Aetaniacna Nuoc. Na u Israelna gagrirta ramoot paŋan.” ");
INSERT INTO gai_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Na Iesusa mana kambmo gainda rutirina, “Aku unmo gaindopnandet, aku unmo ŋgaŋɨn ikna mɨnɨŋna kaŋgaukca tɨkca watatke, u anna mɨnɨŋna moca aukmo rɨpacatna. Na iŋmbaia u an reik anikca an reacmo tamuŋmbai ŋgoinnanmo u watnandet.” ");
INSERT INTO gai_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Karica Iesusa manmo gaind mac mbopatna, “Aku nemo gidik, gidik ŋgoinna aindopnandet, iŋmbaia ne tamuŋna auŋmo watnandet, ma goot te, ne watnandet, Raraŋ Aetaniacna mbaiŋna aiŋa morena ŋerŋgaura mina tamuŋ naganandet, na mina pɨkɨnna irikca Ramootna Nuoc ndambuŋa taŋnandet.” ");
INSERT INTO gai_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Karica Iesusa Pilipapa Natanielmo acrina ra mbuniŋna iŋmbai mbuŋa ramoot ianna Galili inikna pitrik waŋna auŋ Kanaca laŋtaŋgo mamoat. Na Iesusna aemma an laŋtaŋgo watna mataŋgat. ");
INSERT INTO gai_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Na mina Iesusapa mana iŋa raŋgairena ramtaɨr tocmo mbaiŋ tɨkrinanna, mitoco anna taŋga eacrina. ");
INSERT INTO gai_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Na an mɨnna wain pukca maiatke, Iesusna aemma manmo gaindopatna, “Mina wain pukca mamairi.” ");
INSERT INTO gai_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Na Iesusa manmo aindopatna, “Abo, anna una reac. Na anna aukna reaca wanaiŋ. Aukna kɨdrɨkca mba larureke.” ");
INSERT INTO gai_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ainda moca mana aemma an mbaiŋna aiŋa morena ramtaɨrmo gaindopatna, “Ma nenmo reac ianna mona ndop te, ne mo.” ");
INSERT INTO gai_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Na an kacna inikca wautna wɨnne anikca parmbaiapa mbut kabe ndeacrena, na an mbuŋa Iudanaŋgepca ndorita tɨpemb kirarira raŋgaica rurenan. Na kabe, kabea 100na mɨnna litana puk ŋgutiŋna mɨn. ");
INSERT INTO gai_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ainda moca Iesusa an aiŋa morena ramtaɨrmo aindopatna, “An wɨnnepaikmo puk ru.” Na mina an wɨnnepaikmo kocnaia ruca upembca tɨkrinan. ");
INSERT INTO gai_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Karica ma minmo gaindopatna, “Ndepikmo mandeban naaŋgɨca taŋca amta reik raupŋirena ramootmo neaŋ.” Ainda moca an mbaiŋna aiŋa morena ramtaɨra ndepikmo aŋgɨca mataŋri. ");
INSERT INTO gai_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Na an pukca ma uriraca wain puk malaruri, na an amta reik raupŋirena ramootta matowaiat. Na ma mba lamŋiri, mina an wain pukmo ten ndiŋ naaŋgɨ kɨprinan. Na an mbaiŋna aiŋa morena ramtaɨra puk wɨtrinanna, mina ndori tiŋgikca an tamŋirena. Ainda moca an amta reik raupŋirena ramootta an laŋtaŋgona ramootmo aca kɨpca, ");
INSERT INTO gai_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ma manmo gaindopatna, “Ramtaɨra muruŋcamiŋa wain puk laŋmo outta biŋairena. Na mina wɨtca anmo ammi mai te, mina an laŋ ŋgoinna wanaiŋnanmo iŋmbaia biŋainandet. Na u, an wain puk laŋmo mba biŋaiatke, u mandeban naaŋgɨca kɨprinan.” ");
INSERT INTO gai_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Na ganna Iesusna out ŋgoinna moatna ŋgagatrac ŋgoin. Na ma anmo Galili inikna pitrik waŋna auŋ Kanaca tɨkca moatnan. Na an ŋgagatraca mana gargarapa i aniacmo wat rapacna. Na mana iŋa raŋgairena ramtaɨra an mbatca mina manmo marɨpacat. ");
INSERT INTO gai_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ainda moca Iesusa Kanac auŋ tɨkcarica ndona aemmapa, laipitikapa, mana iŋa raŋgairena ramtaɨrap, mina Kapaneam auŋ mairikat. Na mina an auŋmo rai ndepikca an ndeacrina. ");
INSERT INTO gai_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Iudanaŋgepta mbendeina ra aniac ianna laruna kɨpca rambuŋairi, na anna Pasowana Rana ndamŋirena, aintik Iesusa Ierusalem auŋ aniac mataŋgat. ");
INSERT INTO gai_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Na Raraŋ Aetaniacna Kacna wuocna inikca, ma wattatnanna, ramtaɨra kitukndukna aiŋira morena, mina bulmakaoapa, sipsipapa, ŋgorikmo mbik tɨkca oikca kitukndukar aŋgɨrena. Na ma watrinanna kituknduk ŋgetrikina ramtaɨr toco, anna mbiraca eacrena. ");
INSERT INTO gai_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ainda moca ma lawirta ŋgatɨk aŋgɨca ma ramootta pina reaca morina. Ri, ma an ramtaɨrmo muruŋcamiŋapa bulmakaoapa sipsiparmo ootca mina an Raraŋ Aetaniacna Kacna umbum an tɨkcarica mataŋgat. Na an kituknduk ŋgetrikirena kitukndukarta tɨkrena barer motocmo, ma aŋgɨca kabrikirina. ");
INSERT INTO gai_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Na an ŋgorik puŋga kituknduk aŋgɨrena ramtaɨrmo, ma aindoprina, “Ne ndorita ŋgorik aŋgɨca taŋ. Ne aukna Aetna Kacmo mbik tɨkca oikrena taupca kai mo teac.” ");
INSERT INTO gai_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ainda moatke, mana iŋa raŋgairena ramtaɨra an man morina tɨpna kirara watca, mina an Raraŋ Aetaniacna timbigta kap ndeacrena kam ianna malamŋiat. Na an kamma gaind, “Aku una kacna toŋtoŋ ŋgoin, ainda moca aku an kacmo laŋ ndeacna moca aiŋ gargara morena.” ");
INSERT INTO gai_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Na Iudanaŋgepca an tɨpna kirara Iesusa moatnanna watca, manmo gainda digiatna, “U aimo titocna ŋgagatraca wandac te, aia anna wat garacna, u mandeaca morina tɨpna kirarna i aniacapnan?” ");
INSERT INTO gai_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ainda moca Iesusa mina kambmo gainda rutirina, “Ne gan Raraŋ Aetaniacna Kacmo tapi irik, te, rai mbonkacna inik mbuŋa aku mac mo ŋgep wɨtɨknandet.” ");
INSERT INTO gai_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ri, Iudanaŋgepta ramtaɨra aindopatna, “Iaukke! An Kaca iarira 46na mɨnna tɨkca mina moa ŋgepca wɨtɨkrinan, na u ndomo rai mbonkacna inikmo, an mac mo ŋgep wɨtɨkna mɨn ki?” ");
INSERT INTO gai_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Na an kaca ma mboprenanna, anna ma ndona tikna kam ndoprena. ");
INSERT INTO gai_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ainda moca an mɨnna Raraŋ Aetaniaca manmo muk ndiŋa moa ŋgepatnanna, mana iŋa raŋgairena ramtaɨra ŋgaua ma mbopatna, an kammo, mina mac malamŋiat. Na an kambca Raraŋ Aetaniacna Timbigta Kap ndeacrenanapa Iesusa mbopatna kambmo mina rɨpacatna. ");
INSERT INTO gai_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Na an Pasowana Rana ndamŋina moca, Iesusa ma Ierusalem ndeacri, na meikramtaɨr wɨt anikca ma moatna ŋgagatracarmo watrina. Ainda moca mina mana imo marɨpacat. An kam tɨp kirar kabe toco an ndeacrena. ");
INSERT INTO gai_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Na Iesus, ma minmo mba rɨpacri, ");
INSERT INTO gai_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","na an kɨdrɨkca, ma meikramtaɨrta tɨpemb kirarirmo, ma muruŋcamiŋa lamŋirena. Na ma iro landamŋia mba matpirenan, te, ramoot ianna meikramtaɨrta tɨpemb kirarirta kambca manmo mbopna. Wanaiŋ. Ma ndo meikramtaɨrta iroar landamŋiara ma lamŋirena. ");
INSERT INTO gai_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Na ramoot ianna eacrenan, na mana ia Nikodemus. Na ma Parisina tumbunna ramoot ian, na ma toco Iudanaŋgepta ramoot paŋan ian. ");
INSERT INTO gai_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Na an ramootta Iesusmo mouŋa kɨpca manmo gaindopatna, “Riripti, aia lamŋirena Raraŋ Aetaniaca unmo mandaca ririptina kirar toca kɨprina. Na Raraŋ Aetaniaca ramoot ianap eac ŋgocor te, an ramootta un morena an ŋgagatraca ma mba moitndai.” ");
INSERT INTO gai_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ainda moca Iesusa mana kambmo gainda rutirinan, “Aku unmo gidik, gidik ŋgoinna aindopnandet, ramootta ŋgam ndaru ŋgocor te, ma Raraŋ Aetaniacna bubuocmo ma mba watitndai.” ");
INSERT INTO gai_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Karica Nikodemusa manmo gainda digiatna, “Titoca tɨk te, ramoot bagara ma ŋgam ndaruit? Ma ndona aemna nikinik mac nda mbukca, aem mananna manmo mac nda mɨrna ki?” ");
INSERT INTO gai_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ri, Iesusa mana kambmo gainda rutirina, “Aku unmo gidik, gidik ŋgoinna aindopnandet, ramootta pukapa Ŋeroŋ Rat mbuŋa ŋgam ndaru ŋgocor te, ma Raraŋ Aetaniacna bubuoca mba mbukitndai. ");
INSERT INTO gai_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Na reaca ramootna tikca mo larurinan, anna ramootna tikna reac. Na reaca Ŋeroŋ Ratta mo larurinan, anna ŋeroŋna reac. ");
INSERT INTO gai_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Na aku unmo mbopekna an kamb, ‘Ne ŋgaib mac laruna,’ u anna moca kai ŋgep ŋgoreac naŋgep teac. ");
INSERT INTO gai_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Na watta ma ndona toŋtoŋa raŋgaia kɨprena, na ma titoc nakɨprenan. Na u mana mɨtmɨt niŋgikca waracrena, na mana kɨkɨp tataŋa u mba lamŋirena. Na meikramtaɨra muruŋcamiŋa Ŋeroŋ Rat mbuŋa ŋgaib taru te, mina muruŋcamiŋa aintoc ndarunande.” ");
INSERT INTO gai_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ri, Nikodemusa manmo gainda digirina, “Na an reaca u mboprenanna, ma titoc ndaruit?” ");
INSERT INTO gai_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Na Iesusa mana kammo gainda rutirina, “U Israelna ririptina ramoot paŋan ian, na u an reacmo mba lamŋire ki? ");
INSERT INTO gai_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Na aku unmo gidik, gidik ŋgoinna aindopnande, aia reikca aia lamŋirenanna mambopreke. Na aia reikmo aia watrinanmo, aia anna wiwitirenan. Na an kambca aia wiwitirenanmo, ne iŋ neaŋrenan. ");
INSERT INTO gai_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Na aku nenmo gan tiacarpaikna reikta kamb ndoprenan, na ne mba rɨpacrena. Aintik aku nenmo tamuŋna auŋna reikta kamb ndop te, ne titoca rɨpacit? ");
INSERT INTO gai_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Na ramoot ianna tamuŋna auŋa mba taŋri. Wanaiŋ. Ramootna Nuoca ma ndo kabe niŋgikca tamuŋna auŋmo tɨkcarica irikrinan. ");
INSERT INTO gai_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Na atua Mosesa reik kocorta taupmo ma barasna nduopmo aŋgɨca ik nakeracrinan, na an tɨpna kirar mbuŋa mina Ramootna Nuocmo mina manmo ik naaŋgɨ keracnandet. ");
INSERT INTO gai_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Ainda mo te, meikramtaɨra muruŋa manmo rɨpacnandet, te, mina iarwarna eteacna wat laŋa aŋgɨnandet. ");
INSERT INTO gai_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Na Raraŋ Aetaniaca ma Nuoc kabe niŋgikap. Na ma gan tiacarpaikna meikramtaɨrmo muruŋcamiŋa matŋirenan, aintik ma minmo an ndona Nuoc kabemo minmo neaŋrinan. Na ma ainda mo te, meikramtaɨra muruŋcamiŋa manmo rɨpacrenanna, mina mba taprekeitndait. Wanaiŋ. Mina an iarwarna eteacna wat laŋa aŋgɨnandet. ");
INSERT INTO gai_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Na Raraŋ Aetaniaca ma ndona Nuocmo gan tiacarpaikmo mba mbagɨrica kɨpca meikramtaɨrta tɨpemb kirarira ritri waparaca mo nake, mba mbagɨricatnan. Wanaiŋ. Ma manmo mbagɨrica ma minmo mac nda aŋgɨna. ");
INSERT INTO gai_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Na ramootta manmo rɨpac te, ma ritri waparac ŋgocor. Na ramootta manmo rɨpac ŋgocor, ma manmo ritri waparaca monandet, na an kɨdrɨkca ma Raraŋ Aetaniacna an Nuoc kabena imo ma rɨpac ŋgocor. ");
INSERT INTO gai_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Na an ritri waparacna mɨnɨŋa gaind. Memetaca gan tiacarpaikca kɨpca larurinan, na meikramtaɨra neaupna toŋtoŋgar koindap maeacreke. Na mina memetacmo mba toŋgorenan, na anna gaind, mina tɨpemb ŋgorikca morena meikramtaɨr koind. ");
INSERT INTO gai_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Na meikramtaɨra muruŋcamiŋa tɨpemb ŋgorikca morenan, mina memetacmo puŋndamootta morina. Na mina toŋgorinanna, mina morena tɨpemb kirarirta reikca raekca kai laru teac. Ainda moca mina memetac ndambuŋa mba kɨprenan. ");
INSERT INTO gai_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Na ramootta tɨpemb kirarir laiŋga morenan, ma memetac ndambuŋa kɨprenan. Te, meikramtaɨra matau watnandet, ma ndona aiŋa Raraŋ Aetaniacna gargar mbuŋa morenan.” ");
INSERT INTO gai_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Karica iŋmbaia Iesusapa mana iŋa raŋgairena ramtaɨra Iudiana pitrik waŋmbai mataŋgat. Na ma minapa eaca, meikramtaɨrmo kɨtac pukca neaŋrenan. ");
INSERT INTO gai_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Na Ion toco, ma meikramtaɨrmo kɨtac pukca Ainon auŋa tɨkca neaŋrenan, na an auŋa ma Salim auŋmo rambuŋmbai. Na ocik wɨtta an ndeacrenan, aintik meikramtaɨra man ndambuŋa taŋga kɨtac puk aŋgɨrena. ");
INSERT INTO gai_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Na an kɨdrɨkca Erotta, Ionmo kac ŋgoreaca mba aŋgɨca tɨkatke. ");
INSERT INTO gai_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Karica iptipuŋ ianna Ionna iŋa raŋgairena ramtaɨrapa Iudana ramoot ianna rɨk malaruat. Na mina ipuŋga taŋga, mina titocna ruruca raŋgaica Raraŋ Aetaniacna lamnɨac ŋgoutmo rat ndaruit. ");
INSERT INTO gai_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ri, Ionna iŋa raŋgairena ramtaɨra Ion ndambuŋa taŋga aindopatna, “Riripti, ŋgaua an ramootta unapmo oc Iodanmo monmbai waŋ ndeacrinan, na u mana kambmo wiwitirinan, an ramoot, mandeaca ma kɨtac pukca neaŋrenan, aintik meikramtaɨra man ndambuŋa taŋrena.” ");
INSERT INTO gai_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ainda moca Ionna mina kambmo gainda rutirinan, “Tamuŋna auŋna Raraŋ Aetaniac, ma ramoot ianmo reac ianna neaŋ ŋgocor te, an ramootta ma mba aŋgɨri. ");
INSERT INTO gai_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Na ne ndori waracatna, aku wiwitiatna kamma, ‘Aku an ramootta Raraŋ Aetaniaca babuca mbagɨrica kɨpca aimo mac nda aŋgɨna ramootta wanaiŋ, Raraŋ Aetaniaca ndo aukmo mandaca aku manmo outmbaica kɨprinan.’ ");
INSERT INTO gai_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Na ramoot ianna meac ianna laŋgo te, an meaca ma an ramootna meac. Na an ramootna aikndamootta, ma wɨtɨkca ndona aikndamoot an laŋgorina kamna toŋgoca koar tɨkca waracrena. Na an tɨpna kirar mbuŋa toŋtoŋa aukna nikinik iromo mɨnna tɨkrinan. ");
INSERT INTO gai_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Na mana ia ma ŋgepraŋ te, aukna ia ma irikraŋnandet.” ");
INSERT INTO gai_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Na ramootta tamuŋa eaca kɨprinan, ma reikmo tamuŋmbai. Na gan tiacarpaikna ramoot, ma gan tiacarpaikna reikca morenan, na ma gan tiacarpaikna reikta kamb ndoprena. Na ramootta auŋ tamuŋnan ndiŋa kɨprinan, ma reikmo outmbai. ");
INSERT INTO gai_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Na reikca ma watrinan, na reikca waracrina, ma anna wiwitirenan. Na ramoot ianna man wiwitirina an kamb anmo, mba utiŋrinan. ");
INSERT INTO gai_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Na ramootta mana kambmo aŋgɨca utiŋrenan, anna wandacrinan, ma gan kambmo gidikca rɨpacrena, “Raraŋ Aetaniaca ma kam gidik ŋgoin ndoprena.” ");
INSERT INTO gai_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Na an ramootta Raraŋ Aetaniac mbagɨrica kɨprinan, ma Raraŋ Aetaniacna kambmo wiwitirenan. Na an kɨdrɨkca gaind, Raraŋ Aetaniaca ma manmo Ŋeroŋ Ratmo tɨp, tɨpca mba neaŋrenan. ");
INSERT INTO gai_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Na Aetta ma Nuocmo mamatŋi ŋgoin, aintik ma reikmo muruŋa mana para tɨkrina. ");
INSERT INTO gai_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Na meacramootta mandaia Nuocmo rɨpac te, ma iarwarna eteacna watap eacnande. Na meacramootta mandaia Nuocna kambmo raŋgai ŋgocor, ma iarwarna eteacna watta mba aŋgɨitndai. Wanaiŋ. Raraŋ Aetaniacna nikkakatta manap eacrena. ");
INSERT INTO gai_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Na Parisina ramtaɨra gainda waracatna, Iesusa meikramtaɨr wɨtmo kɨtac puk neaŋrenan, na mina mana iŋa raŋgairena meikramtaɨr malaruat. Na mina ŋgaŋganŋgɨa Ionna iŋa raŋgairena meikramtaɨrmo kunda tamuŋmbai. ");
INSERT INTO gai_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Na Iesus, ma ndo ŋgoinna kɨtac pukca mba neaŋrenan, wanaiŋ, mana iŋa raŋgairena ramtaɨra ndori puŋga meikramtaɨrmo kɨtac puk neaŋrena. ");
INSERT INTO gai_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Na Iesusa ma lamŋirina, Parisina ramtaɨra ainda waracrena, meikramtaɨr wɨtta mana raŋgairena meikramtaɨr tarurina. Ainda moca ma an Iudiana pitrik waŋ tɨkcarica ma Galilina pitrik waŋ mac nda mataŋgat. ");
INSERT INTO gai_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Na an taupca ma raŋgaiatnanna, anna ma Samariana pitrik waŋna rɨkca taŋrena. ");
INSERT INTO gai_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Aintik ma taŋga Samariana auŋ teker ian malaruat, na an auŋmo mina Sikar ŋgacrena. Na an auŋ tikca ma an pitrikca Iakopa ndona nuoc Iosepmo neaŋrinanmo, rambuŋaia eacrena. ");
INSERT INTO gai_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Na au puk ianna atua Iakopa iacrinanna, ma an ndeacrena. Na Iesusa kɨp, kɨpca ma bobororina, aintik ma taŋga an au pukna kɨtɨmma mbiracrina. Na rana ŋgaŋganŋgɨa taŋca rɨkca tɨkrinan. ");
INSERT INTO gai_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ri, Samariana auŋna meac ianna puk wɨtna kɨprinan, na Iesusa manmo gaindopatna, “U aukmo puk neaŋca aku amna, aku puk amna toŋtoŋap.” ");
INSERT INTO gai_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Na mana iŋa raŋgairena ramtaɨra an auŋmo amta reik koikna mataŋgat. ");
INSERT INTO gai_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ainda moca an Samaria auŋna meaca manmo gaindopatna, “U Iudanaŋgepta ramoot, na aku Samarianaŋgepta meac, na kaina moca u aukmo aindopapekna, ‘U aukmo puk neaŋam, aku puk amna toŋtoŋap’?” Na an meaca an kam ndoprenanna, mana mɨnɨŋa gaind, Iudanaŋgepca Samarianaŋgepmo tumbunna mba tɨkrenanna. ");
INSERT INTO gai_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ainda moca Iesusa an meacmo gaindopatna, “U an reaca Raraŋ Aetaniaca wanaiŋa neaŋna morenanna u lamŋi te, na an ramootta unmo aindoprenanna, ‘U aukmo puk neaŋam, aku puk amna toŋtoŋap,’ u man ndamŋi te, na u manmo mbopca, ma unmo pukca eteacna watapnanmo ma unmo neaŋnandet.” ");
INSERT INTO gai_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Karica an meaca manmo aindopatna, “Ramoot aniac, u puk wɨtna reac ŋgocor, na an au pukca orer ŋgoin. Aintik an eteacna watapna pukca u ten ndiŋ naaŋgɨit? ");
INSERT INTO gai_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Aina nicau Iakop, ma aimo gan au pukca aimo neaŋrinan. Na ma ndo ŋgoinapa, mana nuikapa mana bulmakaoapa, sipsiparap, mina muruŋa an auna pukca ambrina. Na u ndomo, aina nicau Iakopmo kunda tamuŋmbai ki?” ");
INSERT INTO gai_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Karica Iesusa mana kammo gainda rutirinan, “Meikramtaɨra muruŋcamiŋa gan auna puk ambrenanna, mina logotta mac gagranandet. ");
INSERT INTO gai_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Na mandaimo aku neaŋgekna puk am te, mana logotta puk mac amna, mba mac gagraitndai. Wanaiŋ. Na an pukca aku neaŋ ndoprinanna, ma an ocna pukca mana inik ndeacrena kirar toc ndeacnande. Na an pukca memetmbaca ma laruraŋ te, manmo iarwarna eteacna watmo neaŋnandet.” ");
INSERT INTO gai_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ri, an meaca Iesusmo aind mambopat, “Ramoot aniac, u aukmo an pukca neaŋam. Te, iŋmbaia aukna logotta mba mac gagraitndai, na aku ganna mba mac nda kɨpca puk wɨtca aŋgɨ taŋitndai.” ");
INSERT INTO gai_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Karica Iesusa manmo gaind mac mbopatna, “U taŋca ndona kaŋgaitmo aca oŋgo kɨp.” ");
INSERT INTO gai_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ri, ma aind mambopat, “Aku kaŋgait ŋgocor.” Na Iesusa mana kammo rutica gaindopatna, “U wandoŋ ndoprina, u kaŋgait ŋgocor. ");
INSERT INTO gai_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Na anna gidik, ŋgaua u ramtaɨr parmbaimo malaŋgoat, na mandeaca unap eacrena ramootta anna una kaŋgait ŋgoinna wanaiŋ. Na u aukmo kam gidik ndoprina.” ");
INSERT INTO gai_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ainda moca an meaca manmo gaindopatna, “Ramoot aniac, aku mandeaca malamŋica, u ramma morena ramoot ian. ");
INSERT INTO gai_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Na aina nicar, ŋgamrira mina an takura mbendeina punirena. Na ne Iudanaŋgepca aindoprena, Ierusalem auŋ aniaca ande an taupca aia muruŋa mbendeina punirenan.” ");
INSERT INTO gai_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Karica Iesusa manmo gaindopatna, “Meacmbitac, u aukna kammo rɨpac. Oit ianna larunandet, na ne Aetmo gan takura mba tɨkca mbendeitndait, co, Ierusalem toco tɨkca mba mbendeitndait. ");
INSERT INTO gai_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Na ne Samarianaŋgepca ne lamŋi ŋgocorta reacmo mbendeirena. Na ai Iudanaŋgepca aia lamŋirena reacna moca anna mbendeirena. Na anna gaind, aia Iudanaŋgepmo Raraŋ Aetaniaca aimo larapaca aia meikramtaɨrmo mac nda aŋgɨna aiŋmo, outta tɨkca morena. ");
INSERT INTO gai_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Na aku unmo aindopnandet, oit ianna larunandet, na mandeaca ma malaruri, na meikramtaɨra Raraŋ Aetaniacmo mbendeina mo te, mina an takurapa Ierusalemmo mba mac lamŋiitndait. Wanaiŋ. Mina Raraŋ Aetaniac Aetmo, ndorita iroar inkarapa manmo gidikca raŋgaica mbendeiraŋnandet. Na Raraŋ Aetaniaca ma ainta meikramtaɨrta ŋgorerena. ");
INSERT INTO gai_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Na Raraŋ Aetaniaca ma Ŋeroŋ. Aintik meikramtaɨra manmo mbendeina morena, mina Ŋeroŋ Ratna gargarapa tɨp kirar gidik mbuŋa mbendeirena.” ");
INSERT INTO gai_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Na an meaca Iesusmo, nda rutica aindoprina, “Aku lamŋirena, Raraŋ Aetaniaca babuca mbagɨrica kɨpca aimo mac nda aŋgɨna ramoot, ma kɨpnandet. Na an mɨnna ma gan tiacarpaik nakɨp te, ma aimo reikmo muruŋa mbopi larunandet.” ");
INSERT INTO gai_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ri, Iesusa manmo gaindopatna, “Aku ndo unap mboprena ramoot, aku Karais.” ");
INSERT INTO gai_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Na ma an meacmo aindopatke, an kɨdrɨkca mana iŋa raŋgairena ramtaɨra nda kɨpca larurina. Na mina watrinanna ma an meacap mbopreke, mina tamtam malamŋiat. Na mina ianna manmo mba digiatke, “U kaina reaca toŋgorinan? Co, kaina moca u an meacap mboprena?” ");
INSERT INTO gai_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Karica an meaca ma ndona puk wɨn tɨkcarica ma auŋ mac mataŋgat. Na ma meikramtaɨrmo aindopatna, ");
INSERT INTO gai_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Ne kɨpca ramoot ianna watna, ma aukmo ŋgaua aku morina reikta kambmo mboprena. Na ma an ramootta Raraŋ Aetaniaca babuca mbagɨrica kɨpca aimo mac nda aŋgɨna ramoot ki?” ");
INSERT INTO gai_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ainda moca an auŋna meikramtaɨra laruca kɨpca Iesusmo watrina. ");
INSERT INTO gai_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Karica an kɨdrɨkca mana iŋa raŋgairena ramtaɨra manmo aindopatna, “Riripti, u am.” ");
INSERT INTO gai_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Na ma minmo aindopatna, “Aku gagamna amna reacap, na ne mba lamŋireke.” ");
INSERT INTO gai_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ainda moca mina ndori puŋga aindopatna, “Moca ramoot ianna manmo amna reac neaŋca ambri ki?” ");
INSERT INTO gai_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ri, ma minmo gaindopatna, “Raraŋ Aetaniaca aukmo mbagɨrica aku kɨprinan, na aukna amna reaca mana toŋtoŋa raŋgairenanapa ma aukmo neaŋrina aiŋira moca korwina. ");
INSERT INTO gai_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","“Na ne aindoprenan, ‘Karwai paura maeacreke, na an mai te, aia warɨŋna amta reik aŋgɨrena.’ Na aku nenmo aindopnandet, ne tamtamca wat, warɨŋembmo matau wat, amta reikca maica kocroca eacrena. ");
INSERT INTO gai_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Na ramootta amta reikmo aŋgɨra punirenanna, ma anna opoikca aŋgɨrena, na ma iarwarna eteacna watna amta reikca aŋgɨca punirena. Aintik amta reik mutocrena ramootapa amta reikmo aŋgɨca punirena ramootta, maniŋa muruŋniŋa toŋgonandet. ");
INSERT INTO gai_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ainda moca an kambca anna gidik, ‘Ramoot ianna warɨŋna amta reikmo mutocrena, na kabena ramootta amta reikmo aŋgɨra punirena.’ ");
INSERT INTO gai_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Na aku nenmo mandaca ne taŋga warɨŋa ne ŋgaua mana aiŋa mo ŋgocorta amta reik aŋgɨrina. Na an warɨŋa kabena ramtaɨra morinan, na ne anna mbukca mina aiŋ aniac mbuŋ ndarurina amta reikca aŋgɨrena.” ");
INSERT INTO gai_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Na an auŋ Samariana meikramtaɨr wɨt aniaca an meacna kamma waraca, mina Iesusmo rɨpacrina. Na anna mɨnɨŋa gaind, an meaca ma aindopatna, “Ma aukmo ŋgaua aku moatna reikta kambmo ma muruŋ ndoprina.” ");
INSERT INTO gai_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ainda moca Samarianaŋgepca kɨpca manmo mina ndoriap eacna aemaŋmaŋap madigiat. Aintik ma minapmo ra mbuniŋa an auŋ ndeacrina. ");
INSERT INTO gai_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Na meikramtaɨr wɨt aniac ŋgoinna Iesusna kambmo waraca mina marɨpacat. ");
INSERT INTO gai_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ainda moca mina an meacmo aindopatna, “Aia una kamb tiŋgikmo mba waraca, an ramootmo rɨpacrina, wanaiŋ. Aia ndori mana kambmo waraca, aia lamŋirina, an ramootta ma ndo niŋgikca gan tiacarpaikna meikramtaɨrmo, muruŋcamiŋa mac nda aŋgɨna ramoot.” ");
INSERT INTO gai_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Aintik Iesusa Samarianaŋgepta meikramtaɨrap ra mbuniŋa minap eaca, karica ma an auŋmo tɨkcarica ma Galilina pitrik waŋa taŋrina. ");
INSERT INTO gai_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Na ma ndo ŋgoinna ma kambmo gainda wiwitirina, “Ramma morena ramootta, ma ndona auŋ mɨnɨŋa ma iremb kocor.” ");
INSERT INTO gai_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Karica ma taŋga Galili malaruat, na Galilinanda man kɨkɨpna moca mina toŋtoŋgar koindap. Na mana mɨnɨŋa gaind, mitoco mina an Ierusalemna mbembendei aniacna moca anna taŋca, an auŋ aniaca ma morina reikca mina muruŋa watrina. ");
INSERT INTO gai_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Karica ma auŋ teker Kanaca Galilina inik ndeacrena auŋmo mac nda taŋga larurina, na an auŋ tekermo ma ŋgaua puk mbuŋa wainna pukca uriraca larurinan. Na an mɨn toco, Romna ramoot paŋan ianna ma Kapaneam auŋ ndeacrena, na mana nuoca roumbap. ");
INSERT INTO gai_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ainda moca an ramootta waracrinanna, Iesusa Iudia tɨkcarica ma taŋga Galilia ndarurina. Aintik ma taŋga Iesusmo digica ma Kapaneam auŋ ŋgirikca ndona an nuocmo moi laŋa mona. Na an nuoca ma menacna morena. ");
INSERT INTO gai_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Karica Iesusa an ramootmo gaindopatna, “Ne ainta ŋgagatracara wat ŋgocor co, ne mba rɨpacitndai.” ");
INSERT INTO gai_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ri, ramoot paŋanna aindopatna, “Kacoot, u tawi ŋgoinna kɨpca irik. Moca aukna nuoca menacnari.” ");
INSERT INTO gai_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Na Iesusa manmo gaindopatna, “U taŋ, una nuoca ma mba menacitndai.” Ainda moca an ramoot paŋanna mana kambmo rɨpaca ma mataŋgat. ");
INSERT INTO gai_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Na an ramoot paŋanna Kapaneam auŋmo laru ŋgocor ndeacri, mana mbaiŋna aiŋa morena ramtaɨra manmo taupca tɨkca ndapurikica mina manmo aindopatna, “Una nuoca ma mba menacri, ma laŋ ndarurina.” ");
INSERT INTO gai_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Na ma minmo digiatna, kaina rana ŋgaŋganŋgɨ ma laŋ emtemma morina. Na mina manmo gaindopatna, “Ŋoura rana ŋgaŋganŋgɨa ramo rɨkmbai motem tɨkca roumbca manmo tɨkcaririna.” ");
INSERT INTO gai_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ri, an nuocna aetta malamŋiat, ŋoura an mɨn mbuŋa Iesusa manmo aindopatna, “Una nuoca ma mba menacitndai.” Na manapa mana wiwitinanna mina marɨpacat. ");
INSERT INTO gai_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Na anna Iesusna ŋgaŋganŋgɨ mbuniŋna ŋgagatraca ma Galilina inikca tɨkca moatna, na ma moatna kɨdrɨkca ma Iudia tɨkcarica ma kɨpca Galili ndeacrina. ");
INSERT INTO gai_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Na iŋmbaia Iudanaŋgepta mbembendeina ra aniac ianna laruatna, ri, Iesusa Ierusalemma taŋgatna. ");
INSERT INTO gai_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Na Ierusalem auŋ aniacna inikca rurena au puk ianna eacrenan, na ma wuocna tɨŋ ianna roumbca eacrenan. Na an wuocna tɨŋna ia Sipsiparta Tɨŋ. Na an rurena au pukna ia mina Iburuna kam mbuŋa gaind ŋgacrena Betesda. Na mana roumbmbaica wacraet parmbaiap eacrenan. ");
INSERT INTO gai_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Na an wacraet parmbaina, roumbbebta meikramtaɨr wɨtapa, lamnik ŋgorikcapa, or ŋgorikcapa, meikramtaɨra gagrira menacrinanna anna eacrenan. ");
INSERT INTO gai_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Na ramoot ianna roumbapnanna anna tɨmpaik up ian ndeacrena, na mana an roumbca iarir 38na mɨn, na ma anap eacrenan. ");
INSERT INTO gai_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Na Iesusa watrinanna, an ramootta meraca eacrenan, na ma lamŋirenan, ma an roumbapmo kɨdrɨk rocotap eacrenan. Ainda moca Iesusa manmo madigiat, “U toŋgorinanna una tikca laŋa mona ki?” ");
INSERT INTO gai_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ri, an roumbbebta ramootta mana kambmo gainda rutirinan, “Kacoot, an mɨnna pukca numai te, auk aŋgɨca taŋca an rurena au puk inikca tɨkna ramtaɨr kocor. Na aku ndo anna irikna mo te, kabena ramootta aukmo kunda anna iriknandet.” ");
INSERT INTO gai_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Karica Iesusa manmo gaindopatna, “U ŋgepca wɨtɨkca ndona bar aŋgɨca taŋ.” ");
INSERT INTO gai_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Na tawi ŋgoinna an ramootna tikca laŋ mamoat. Ri, ma ŋgepca wɨtɨkca ndona bar aŋgɨca mataŋgat. Na an reaca Wɨktɨtɨkna Ra mbuŋa larurinan, ");
INSERT INTO gai_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","ainda moca Iudanaŋgepca an ramootmo watca mina manmo gaindopatna, “Mandeaca anna Wɨktɨtɨkna Ra, na anna wandɨk, u ndona bara kai aŋgɨca taŋ teac.” ");
INSERT INTO gai_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Na ma mina kambmo nda rutica aindopatna, “An ramootta aukmo moa laŋa morinanna, ma aukmo aindoprina, ‘U ndona barmo aŋgɨca taŋ.’” ");
INSERT INTO gai_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ri, mina manmo madigiat, “Titocna ramootta unmo mboprinan? Na u ndona bar aŋgɨca taŋrena?” ");
INSERT INTO gai_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Na an ramootta laŋa larurinanna, ma mba lamŋiri, mandai ŋgoinna manmo mboprina. Na mana mɨnɨŋa gaind, meikramtaɨr wɨt ŋgoinna an ndeacrinan, na Iesus toco ma mataŋgat. ");
INSERT INTO gai_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Karica iŋmbaia Iesusa Raraŋ Aetaniacna Kacna wuocna inikca mbukca an ramootmo watrinanna ma eacrena. Ri, ma an ramootmo aindopatna, “U warac. Mandeaca u laŋ mamori. Na u tɨp ŋgoreacna makukca kai mac mo teac, moca makuk aniac ianna unmo laruca u ŋgocrainandet.” ");
INSERT INTO gai_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Karica an ramootta taŋga Iudanaŋgepmo gaindopatna, “An ramootta aukmo, mo laŋa morinanna, anna Iesus niŋgik.” ");
INSERT INTO gai_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ainda moca Iudanaŋgepca Iesusmo tɨp kirar ŋgoreaca morenan, na anna mɨnɨŋa gaind, ma an reikmo Wɨktɨtɨkna Ra mbuŋa morena. ");
INSERT INTO gai_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Na Iesusa mina kambmo gainda rutirinan, “Aukna Aetta ma memetmbaca aiŋa moa kɨp, kɨpca mandeacna mɨn. Na auk toco aku aiŋa morenan.” ");
INSERT INTO gai_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Na Iudanaŋgepca an kamma waraca mina Iesusa mo menacna toŋtoŋgar anikap. Na anna mɨnɨŋa gaind, ma Wɨktɨtɨkna Ra niŋgikna tɨpmo mba kundrenan. Wanaiŋ. Ma aindoprenan, Raraŋ Aetaniaca mana Aet ŋgoin. Na an kam mbuŋa ma ndomo moca Raraŋ Aetaniacna kirara larurinan. ");
INSERT INTO gai_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ainda moca Iesusa Iudanaŋgepta kambmo gainda rutirinan, “Aku nemo gidik, gidik ŋgoinna aindopnande, Nuoca ma ndona iro mbuŋa reac ianna mba moitndai, wanaiŋ. Ma ndona Aetta morina reik tiŋgikca watca ma morenan. Na reik muruŋa Aetta morenan, Nuoc toco anna morena. ");
INSERT INTO gai_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Na Aetta ma Nuocmo matŋirenan tik, ma ndo morena reik muruŋmo manmo wandacrenan. Te, nenmo moca ne ŋgep ŋgoreac naŋgepnande. Na Aetta ma Nuocmo kabena aiŋir anik toco waracnandet, an aiŋira ma outta morinanmo kunnandet. ");
INSERT INTO gai_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Na Aetta menacrina meikramtaɨrmo, moca mac nda ŋgeprinan, na minmo eteacna watta neaŋrena. Ainda moca Nuoc toco, ma meikramtaɨrmo ndona toŋtoŋ mbuŋa minmo eteacna watta neaŋrena. ");
INSERT INTO gai_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Na Aetta ma ramoot ianmo ritri waparaca mba morena. An ritri waparacna aiŋir muruŋa ma ndona Nuocna para tɨkrina. ");
INSERT INTO gai_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ainda moca meikramtaɨr muruŋcamiŋa Nuocna imo aŋgɨ ŋgepnandet. Na an tɨpna kirara mina Aetna i aŋgɨ ŋgeprena. Na meacramoota Nuocna imo aŋgɨ ŋgep ŋgocor, ma an Aetta an Nuocmo mandaca kɨprina imo mba aŋgɨ ŋgeprinan. ");
INSERT INTO gai_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Na aku nemo gidik, gidik ŋgoinna aindopnande, ramootta aukna kambca waracrenan, na Aetta aukmo mbagɨrica kɨprinanmo rɨpac te, ma iarwarna eteacna watapmo memetmbaca eacraŋnandet. Na ma ritri waparac ŋgocor, na ma memenacmo tɨkcarica ma eteacna watap eacrenan. ");
INSERT INTO gai_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“Na aku nemo gidik, gidik ŋgoinna aindopnande, kɨdrɨkca kɨpca laruna mamoek, na mandeaca ma kɨpca larurina, te, an menacrina meikramtaɨra Raraŋ Aetaniacna Nuocna upna kambmo waracnandet. Na meikramtaɨra anna waracrenan, mina eteacna watta aŋgɨnande. ");
INSERT INTO gai_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Na Aetta ma ndo ŋgoinna ma eteacna watap. Na ma Nuocmo gargara neaŋrinan, na Nuoc toco ma ndo ŋgoinna eteacna watap. ");
INSERT INTO gai_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Na ma Ramootna Nuoc, ainda moca Aetta manmo i aniaca neaŋrinan, te, ma meikramtaɨrmo ritri waparaca mo te, mina tɨpemb kirarirmo ma ritrina. ");
INSERT INTO gai_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Na ne aukna an kambta moca kai tamtamca lamŋi teac. Na an kɨdrɨkca laruna mamoek, na mukca eacrena meikramtaɨr muruŋa mina Nuocna upna kambmo waracnandet, ");
INSERT INTO gai_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","te, mina mukmo tɨkcarica ŋgepca larunandet. Na meikramtaɨra tɨpemb kirarir laiŋga morenan, mina mac nda ŋgepca eacnandet. Na meikramtaɨra tɨpemb ŋgorikca morenan, mitoco mac nda ŋgepca ritri waparac taŋnandet. Te, ritri waparaca aindopnandet, mina ŋgocrainandet.” ");
INSERT INTO gai_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Karica Iesusa gaind mac mbopatna, “Aku ndona nikinik iro mbuŋa reac ianna mona towanaiŋ. Aku Aet ndambuŋna kambca aŋgɨrenan, na anna raŋgairenan, na meikramtaɨrta tɨpemb kirarirmo ritrirena. Na aukna ritri waparac, ma wandoŋ niŋgik. Na anna mɨnɨŋa gaind, aku ndo ndona nikinikna iro mbuŋa mba raŋgairenan. Wanaiŋ. Aku Aetna toŋtoŋ niŋgikca raŋgairena, na ma ndo aukmo mbagɨrica aku kɨprina. ");
INSERT INTO gai_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Na aku ndo kabea ndona aiŋapa ndona tɨpna kirara mbop te, meikramtaɨra aukna wiwitirina kambmo mba rɨpacitndai. ");
INSERT INTO gai_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Na kabena ramoot ian toco ma eacrenan, na ma toco aukna aiŋna kambapa aukna tɨp kirarmo wiwitirena. Na aku lamŋirenan, an kambca ma wiwitirenanna anna gidik. ");
INSERT INTO gai_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","34","“Na aku ndo lamŋirena, ramoot ianna aukna kambca moi gagrana mɨnna wanaiŋ. Na aku lamŋirena, ŋgaua ne meikramtaɨrmo mbagɨrica mina Ion ndambuŋna kamb aŋgɨna taŋrina. Na aku toŋgorinanna, Raraŋ Aetaniaca nenmo mac nda aŋgɨna, aintik aku toŋgorenanna, ne Ionna aukna aiŋapa tɨpemb kirarirta kambmo mboprinanna, ne anna lamŋiraŋ. Na Ionna ma kamb gidkarmo wiwitirina. ");
INSERT INTO gai_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Na Ion tikca ma tacna wɨwɨr toca wɨra eacrina kirara meikramtaɨrmo memetaca neaŋgatna. Na kɨdrɨk teker motem mbuŋa nena iroar inkara mana memetacna moca toŋtoŋgar koind. ");
INSERT INTO gai_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Na reaca Ionmo kunda tamuŋmbai, ma mandeaca aukmo wiwitirenan. Na anna aiŋira Aetta aukmo neaŋga aku muruŋa kocnai monandet. Na an aiŋa aku morenanna, anna meikramtaɨrmo mataua wiwitica mbopnandet, Aetta aukmo mbagɨrica aku kɨprinan. ");
INSERT INTO gai_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Na Aetta ndo aukmo mandaca aku kɨprinan, na ma ndo aukmo wiwitirena. Na ne mana kam upa mba waracrenan. Wanaiŋ ŋgoin. Na ne mana inpaŋanna mba watrenan. ");
INSERT INTO gai_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Na mana kamb toco, nenap mba eacrenan, na ramootta Aetta mandaca kɨprinanna, ne mana kambca mba rɨpacrena. ");
INSERT INTO gai_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","“Na ne gaind ndamŋirena, kambca Raraŋ Aetaniacna Timbigta Kapca eacrenanna, ma nenmo iarwarna eteacna wat laŋa neaŋrena. Ainda moca ne Raraŋ Aetaniacna Timbigta Kapna kambmo muruŋcamiŋa watreke, na ritrirena. Na Raraŋ Aetaniacna Timbigta Kap toco aukna moca wiwitirena, ");
INSERT INTO gai_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","na ne auk ndambuŋ nakɨpca eteacna wat aŋgɨna karirenan. ");
INSERT INTO gai_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Na aku gainda mba lamŋireke, aku i aniac aŋgɨna moca aku meikramtaɨrmo an kambca mboprenan. ");
INSERT INTO gai_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Na aku nenmo lamŋirenan. Nena iroar inkara ne Raraŋ Aetaniacmo mba matŋirena. ");
INSERT INTO gai_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Na aku ndona Aetna i mbuŋa kɨprinan, na ne aukna kambmo mba aŋgɨatke. Na ramoot ianna ndona i mbuŋa kɨp te, ne tawi ŋgoinna mana kambmo aŋgɨnandet. ");
INSERT INTO gai_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Na ne ndorita wiwitnanmo i aniaca aŋgɨrenan. Na an i aniaca Raraŋ Aetaniaca ndo niŋgikca neaŋrenan, na ne anmo aŋgɨna karirenan. Na ne ainta tɨpembta kirarira mo te, ne toca titoca tɨkca rɨpacit? ");
INSERT INTO gai_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Na ne gainda kai lamŋi teac, aku nenmo Aetna lamnɨac ŋgoutta tɨkca ritri waparaca monanna. Wanaiŋ. Na ramootta nenmo ritri waparaca monanna, anna Mosesa ndo ŋgoin, na anna an ramootta ne gainda lamŋirenan, ma nenmo otacnandet. ");
INSERT INTO gai_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Na ne Mosesna kambmo rɨpac te, ne aukna kamb motocmo rɨpacnandet. Na anna mɨnɨŋa gaind, an kambca ma tirrinan, anna aukmo wiwitirena. ");
INSERT INTO gai_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Na ne an mana tirrina kambmo rɨpac ŋgocor te, ne titoca tɨkca aukna kambmo rɨpacit?” ");
INSERT INTO gai_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Karica iŋmbaia Iesusa Galilina mɨarna monmbai waŋa taŋrina, na an mɨarna i ian toco Taiberias mɨar. ");
INSERT INTO gai_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Na meikramtaɨrta mɨmɨat aniaca mina man morina ŋgagatracar wɨt anikca, ma an roumbbebta meikramtaɨrmo moa laiŋga morinanna watri tik, mina manmo raŋgairena. ");
INSERT INTO gai_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ri, ma takur teker ian nagaca ndona iŋa raŋgairena ramtaɨrap mbiracrina. ");
INSERT INTO gai_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Na an mɨnna Iudanaŋgepta ra aniaca laruna rambuŋairina, anna an Pasowana Ra. ");
INSERT INTO gai_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ainda moca Iesusa tamtamma watrinanna, meikramtaɨrta mɨmɨat aniaca man ndambuŋ nakɨprina. Ri, ma Pilipmo gainda digirina, “Aia tenna tɨkca tapacar koikca gan meikramtaɨrmo neaŋamna?” ");
INSERT INTO gai_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Na ma an kammo morinanna, anna Pilipmo towaina. Na ma ndo ŋgoinna ma titoca tɨkca mona reaca ma lamŋirena. ");
INSERT INTO gai_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ri, Pilipa mana kammo gainda rutirina, “Aia karwir parmbaiapa mbut mbuniŋna aiŋa moca aŋgɨrena mɨnna kitukndukarta mɨn mbuŋa tapacar koik te, ma an meikramtaɨrta kabe, kabemo teker, tekera neaŋ te, mina mɨnna mba mac tɨkitndait.” ");
INSERT INTO gai_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ainda moca Iesusna iŋa raŋgairena ramtaɨrta ianna, Andru, ma Saimon Pitana lap, ma Iesusmo gaindopatna, ");
INSERT INTO gai_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Nuoc teker ianna ganna eacrenanna, ma tapacar tɨpemb parmbaia mina balina wit mbuŋa morinanapa ŋgoaem mbuniŋap. Na meikramtaɨrta mɨmɨat aniac ŋgoinna gan ndeacrena. Na gan tapacar tɨpembapa ŋgoaemniŋa aimo titoc ŋgotacit?” ");
INSERT INTO gai_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Aindopatke, Iesusa minmo gaind mambopat, “Meikramtaɨrmo mbopca mina mbirac.” Na an kɨdrɨkca katgar wɨtta an ndeacrena, aintik mina anna mbiracrina. Na anna mbiracrina ramtaɨr tiŋgikna ndunduna mɨnna 5,000na mɨn. ");
INSERT INTO gai_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ainda moca mina mbiracatke, Iesusa an tapacarpaik aŋgɨca Raraŋ Aetaniacmo mbendeica kam laŋ neaŋga, ma meikramtaɨrmo mabiŋaiat. Na an kirar kabe toco, ma an ŋgoaemniŋ motocmo aind mamoat. Na ma minmo neaŋga mina ndorita mɨnna aŋgɨrina. ");
INSERT INTO gai_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Na mina amba maiatke, ma ndona iŋa raŋgairena ramtaɨrmo gaindopatna, “Ne an am tɨpembca eacrenanmo, aŋgɨca tumbunna tɨk. Moca ndeida wanaiŋa eac nari.” ");
INSERT INTO gai_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ainda moca mina an tapacarpaikna tɨpembmo, aŋgɨca tumbunna tɨkca, mina larkambca parniŋapa mbut mbuniŋna mɨn ŋgaocrina. Na anna meikramtaɨra amba mɨnna tɨkri, anna tɨpembca eacrena. ");
INSERT INTO gai_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ri, an meikramtaɨra man morina an ŋgagatraca watca, mina aindopatna, “Gidik ŋgoin, ma an ramma morena ramootta Raraŋ Aetaniaca mbopatnanna, ma gan tiacarpaikmo mbagɨrica kɨpnandet.” ");
INSERT INTO gai_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Na Iesusa an kamma waraca ma lamŋirina, mina kɨpca manmo utiŋca mina manmo ndorita gagrirta ramoot paŋanna monandet. Ainda moca ma an taupmo tɨkcarica ma ndo kabe ŋgoinna takur mac taŋgatna. ");
INSERT INTO gai_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Na wigwac mbuŋa Iesusna iŋa raŋgairena ramtaɨra mɨar mairikat. ");
INSERT INTO gai_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ri, mina kor ian naŋgabukca mina mɨarmo kataca monmbai waŋa taŋna. Na mina Kapaneam auŋa taŋna morena. Na ra mairinan, na Iesusa min ndambuŋa mba kɨpatke. ");
INSERT INTO gai_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ri, wat aniaca ŋgepatke, ma macaitta moa ŋgeprina. ");
INSERT INTO gai_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Na mina an kor mbuŋa parmbai, co, parmbaiapa mbut kabena kilomitana mɨn mbuŋa auta mɨarmo laruri, na mina watrinanna Iesusa mɨarna puk nambatta taŋrena, na ma kɨpca kormo rambuŋairi. Na mina nanambiatke, ");
INSERT INTO gai_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","ma minmo aindopatna, “Anna auk niŋgik kɨprena. Ne kai nanambi teac.” ");
INSERT INTO gai_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ainda moca mina mamo kor naaŋgɨ ŋgabukna toŋtoŋgarap tik, tawi ŋgoinna an kora mina taŋna morena auŋmo taŋga malaruat. ");
INSERT INTO gai_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Na iŋmbaina ra mbuŋa, meikramtaɨra mina an mɨarmo an waŋembai ndeacrinanna, mina lamŋirena, ŋoura kour kocor, anna kor kabe niŋgik ndeacrina. Na Iesusa ma ndona iŋa raŋgairena ramtaɨrapmo, an kormo mba ŋgabukatke. Wanaiŋ. Mana iŋa raŋgairena ramtaɨr tiŋgikca an kor naŋgabukca mina taŋgatna. ");
INSERT INTO gai_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Na Taiberias auŋna kour ndeida kɨpca an taupca Kacootta tapacarpaikmo kam laŋ neaŋga mina ambrinanmo rambuŋairi, ");
INSERT INTO gai_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","na meikramtaɨra ainda watrina, Iesusapa mana iŋa raŋgairena ramtaɨra anna mba eacri. Ainda moatke, mina an kourpaik puŋga ŋgabukca mina Kapaneam auŋa taŋca Iesusna ŋgorena. ");
INSERT INTO gai_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Karica meikramtaɨra mɨarmo waŋmbaia taŋga Iesus ndambuŋ ndaruca, mina manmo gaindopatna, “Riripti, tumbuitta u gan nakɨprina?” ");
INSERT INTO gai_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ri, ma mina kambmo gainda rutirina, “Aku nemo gidik, gidik ŋgoinna aindopnandet, ne an ŋgagatraca aku morinanna watca mba lamŋireke. Na anna an ŋgagatraca aku nenmo wandacrinan, ne tapacarpaikca amba mɨnna tɨkri, na anna mɨnɨŋna moca ne aukna ŋgorerenan. ");
INSERT INTO gai_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Na ne ainta amta reikca ŋgocrairenanna, aiŋa kai mo teac. Wanaiŋ. Ne amta reikca iarwar ndeacrenanna aiŋ niŋgikca moraŋ, na anna an amta reikca iarwara eacrena watnan. Na ainta amta reikca Ramootna Nuoca nenmo neaŋnandet. Na Raraŋ Aetaniac Aetta, manmo larapaca ndonanna morinan.” ");
INSERT INTO gai_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ainda moca mina manmo gaindopatna, “Aia tida mo te, aia Raraŋ Aetaniacna aiŋa moit?” ");
INSERT INTO gai_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ri, Iesusa mina kambmo gainda rutirina, “Raraŋ Aetaniacna aiŋa gaind. Ne an ramootta Raraŋ Aetaniac mbagɨrica makɨprinanmo ne mana rɨpac.” ");
INSERT INTO gai_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","31","Ainda moca mina an kamma waraca mina manmo gainda digirina, “U titocna ŋgagatraca mo te, aia an ŋgagatraca watca aia una kammo rɨpacna? Na aina nicar ŋgamrira ramtaɨr kocorta taupca tɨkca mina menamo ambrinan, an kam tɨpna kirara Raraŋ Aetaniacna timbigta kap ndeacrena, ‘Ma meikramtaɨrmo tamuŋna auŋna tapac neaŋga mina ambrina.’ Na u titocna ŋgagatrac ŋgoinna moit?” ");
INSERT INTO gai_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ainda moca Iesusa minmo gaindopatna, “Aku nemo gidik, gidik ŋgoinna aindopnande, mandeaca Mosesa nenmo tamuŋna auŋna tapaca mba neaŋrenan. Wanaiŋ. Aukna Aetta mandeaca nenmo tamuŋna auŋna tapac gidik neaŋrena. ");
INSERT INTO gai_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Na an tapaca Raraŋ Aetaniaca neaŋrinanna, ma tamuŋna auŋmo tɨkcarica ma irikca gan tiacarpaikna meikramtaɨrmo eteacna wat neaŋrena.” ");
INSERT INTO gai_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ri, mina manmo aindopatna, “Ramoot aniac, u aimo memetmbaca an tapac neaŋraŋ.” ");
INSERT INTO gai_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Na Iesusa minmo gaindopatna, “Auk ndo, aku iarwarna eteacna watna tapac. Na ramootta auk ndambuŋ nakɨp te, ma mba mac nik wataiitndai. Na ramootta aukmo rɨpac te, ma logotta puk amna moca mba gagraitndai. ");
INSERT INTO gai_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","“Na aku nenmo mboprinan, na ne aukmo watrinan, na ne mba rɨpacrenan. ");
INSERT INTO gai_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Na meikramtaɨra muruŋa Aetta aukmo neaŋrinanna, mina auk ndambuŋ nakɨpnandet. Na ramootta auk ndambuŋ nakɨp te, aku manmo mo kecarina mɨnna wanaiŋ ŋgoin. ");
INSERT INTO gai_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Na aku tamuŋna auŋmo tɨkcarica irikrinanna, aku ndona toŋtoŋa raŋgaina mba kɨpri. Wanaiŋ. Aku irikrinanna, aku ndona Aetna toŋtoŋa raŋgaina kɨprinan, ma aukmo mbagɨrica aku kɨprina. ");
INSERT INTO gai_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Na Aetna toŋtoŋa ma aukmo mbagɨrica kɨprinanna gaind. Aku man neaŋrina meikramtaɨrta ianna kai tɨkcari teac. Wanaiŋ. Aku minmo gan tiacarpaikna reikta mamamaina ramo, minmo mo ŋgepnandet. ");
INSERT INTO gai_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Na aukna Aetna toŋtoŋa gaind. Meikramtaɨr muruŋa Nuocmo watca rɨpac te, mina iarwarna eteacna wat aŋgɨnandet. Na aku minmo gan tiacarpaikna mamamaina ra, minmo aŋgɨnandet.” ");
INSERT INTO gai_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Na Iudanaŋgepca waracrinanna Iesusa gaindopatna, “Aku ndo an tapaca tamuŋna auŋ tɨkcarica irikrinan.” Na mina kekelamun keca, manmo kamb wɨtta tamtam mambopri. ");
INSERT INTO gai_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Na mina aindopatna, “An ramoot, ma Iesus, na ma Iosepna nuoc. Na aia mana aemmapa aetmo lamŋirena. Aintik titoca moca mandeaca ma aindoprina, ‘Aku tamuŋna auŋmo tɨkcarica irikrinan’?” ");
INSERT INTO gai_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Karica Iesusa mina kambmo gainda rutirina, “Ne ndorita rɨkmo kamb wɨtmo kai mbop teac. ");
INSERT INTO gai_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Aetta ndo aukmo mbagɨrica aku kɨprina. Na ramoot ianna ndona toŋtoŋ mbuŋa auk ndambuŋa kɨpna toawanaiŋ. Wanaiŋ ŋgoin. Aetta ndo mana nikinik iroa mo ŋgepca ma auk ndambuŋ nakɨpnandet. Na gan tiacarpaikna mamamaina ra, aku ndo minmo muk ndiŋa mo ŋgepnandet. ");
INSERT INTO gai_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Na rambca morina ramtaɨrta timbigta kapna inik ndeacrena kamma gaind, ‘Raraŋ Aetaniaca ma meikramtaɨrmo riptinandet.’ Te, meikramtaɨra muruŋa Aetna kambmo waracrinanna, na manmo lamŋirenan, mina auk ndambuŋ nakɨprena. ");
INSERT INTO gai_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","“Na ramoot ianna Aetmo mba watri, wanaiŋ ŋgoin. Na an ramootta Raraŋ Aetaniacap eaca kɨprinan, ma ndo niŋgikca Aetmo watrina. ");
INSERT INTO gai_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Na aku nemo gidik, gidik ŋgoinna aindopnande, ramootta aukmo rɨpac te, ma iarwarna eteacna watap eacnandet. ");
INSERT INTO gai_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Na aku ndo niŋgikca, aku iarwarna eteacna watna tapac. ");
INSERT INTO gai_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Na nena an nicar ŋgamrira menamo ramtaɨr kocorta taupca tɨkca ambrinanna, mina mamenacri. ");
INSERT INTO gai_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Na an tapaca tamuŋna auŋmo tɨkcarica irikrinanna, anna meikramtaɨra man am te, mina mba menacitndai. ");
INSERT INTO gai_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Na aku ndo an tapaca iarwarna eteacna watapnan. Na aku tamuŋna auŋmo tɨkcarica irikrina. Na ramoot ianna an tapac am te, ma iarwarna eteacna watap eacnandet. Na an tapaca aku manmo neaŋgeknanna, anna aukna tik. Na aku gan tiacarpaikna meikramtaɨra neaŋ te, mina iarwarna eteacna wat aŋgɨnandet.” ");
INSERT INTO gai_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Na Iudanaŋgepca an kamma waraca, mina ndorita rɨkmo kekelamun keca mambopri. Na mina gaindopatna, “Titoc ŋgoinna tɨkca, an ramootta mana tikmo aimo neaŋca aia ammit?” ");
INSERT INTO gai_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ainda moca Iesusa minmo aindopatna, “Aku nemo gidik, gidik ŋgoinna aindopnandet, ne Ramootna Nuocna tikmo am ŋgocor, na mana racaindpaikmo am ŋgocor te, eteacna watta nenap mba eacitndai. ");
INSERT INTO gai_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Na ramootta aukna tikapa racaindpaik ambrenan, ma iarwarna eteacna watap memetmbaca eacraŋnandet. Te, aku manmo reikta mamamaina ra mbuŋa mo ŋgepnandet. ");
INSERT INTO gai_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Na anna gidik, aukna tikca ma amna reac gidik, na aukna racaindpaikca anna amna reac gidik. ");
INSERT INTO gai_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Na ramootta aukna tikapa racaindpaikmo am te, ma aukap eacrena, na aku manap eacrena. ");
INSERT INTO gai_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Na iarwarna eteacna watapna Aetta ma aukmo mandaca aku kɨprina, na aku Aetna gargar mbuŋa iarwarna eteacna watap eacrena. Na anna kirar mbuŋa ramootta aukmo am te, ma aukna gargar mbuŋa iarwarna eteacna watta aŋgɨnandet. ");
INSERT INTO gai_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Na an niŋgikca anna an tapaca tamuŋna auŋmo tɨkcarica irikrinan. Na ma an nicar ŋgamrira atua ambrina tapacna kirara wanaiŋ, mina anmo amba menacrinan. Wanaiŋ. Na ramootta an tapacmo am te, ma iarwarna eteacna watap eacraŋnandet.” ");
INSERT INTO gai_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Na Iesus, ma Kapaneamna Iudananta mimitpac aŋgɨrena kac ndeacatke, ma meikramtaɨrmo an kamb neaŋrina. ");
INSERT INTO gai_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ainda moca mana iŋa raŋgairena meikramtaɨr wɨtta an kambca waraca mina aindopatna, “An ririptina kambca aia gɨwac garacna aiŋ ŋgoin. Na mandaia ndo waracit?” ");
INSERT INTO gai_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Na Iesusna nikinik iroa ma lamŋirenan, mana iŋa raŋgairena meikramtaɨra man mboprena kambta moca tamtam mambopreke. Ainda moca ma minmo gainda digirina, “An kambca nena rɨtɨpaikca moa ŋgocrairi ki? ");
INSERT INTO gai_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Na ne Ramootna Nuocmo wat te, ma atu ndeacrina taup mac nda taŋca an ndeac te, anna kaica? ");
INSERT INTO gai_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Na Ŋeroŋ Ratta ndo meikramtaɨrmo eteacna wat neaŋrena, na ramootna tikca ma aimo otacna mɨnna wanaiŋ. Na an kambca aku nenmo neaŋrenanna, ma eteacna watap, na ma ŋeroŋ. ");
INSERT INTO gai_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Na nena rɨkna ramtaɨr ndeida mba rɨpacrenan.” Na Iesusa ma atuna lamŋirina, mandaia rɨpac ŋgocor. Na ma lamŋirena, an ramootta manmo aŋgɨca puŋnaŋgepta para tɨknandet. ");
INSERT INTO gai_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ainda moca ma gaindopatna, “Mina mba rɨpacrenanna, na anna mɨnɨŋna moca aku nenmo mboprina, ‘Na Aetta ramoot ianmo gargar neaŋ ŋgocor te, an ramootta auk ndambuŋa mba kɨpitndai.’” ");
INSERT INTO gai_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Karica Iesusa an kambca wiwitia maiatke, mana iŋa raŋgairena meikramtaɨr wɨtta manmo tɨkcarica mataŋgat, na mina manap mba mac taŋgatke. ");
INSERT INTO gai_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ainda moca Iesusa mana iŋa raŋgairena ramtaɨr parniŋapa mbut mbuniŋna mɨnmo gainda digiatna, “Na ne toco, aukmo tɨkcarica taŋit ki?” ");
INSERT INTO gai_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ri, Saimon Pita, mana kammo nda rutica aindopatna, “Kacoot, aia mandai ndambuŋa taŋit? Una kamb tiŋgikca iarwarna eteacna wat neaŋrena. ");
INSERT INTO gai_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Na aia rɨpacrina, na aia mataua lamŋirena, u an ramoot ratta Raraŋ Aetaniaca ndo ŋgoin unmo larapacrina.” ");
INSERT INTO gai_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Karica Iesusa mina kambmo gainda rutirina, “Kaica? Na aku ndo, aku nenmo aukna iŋa raŋgaina ramtaɨr, parniŋapa mbut mbuniŋa larapacrina. Na nena rɨkna ianna ma paparuna ramoot ianna kirar toc.” ");
INSERT INTO gai_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Na anna ma Saimon Iskariotna nuoc, Iudasna kam ndoprina. Na Iudas tikca ma an parniŋapa mbut mbuniŋna mana iŋa raŋgairena ramtaɨrta ramoot ian. Na iŋmbaia ma Iesusmo aŋgɨca puŋnaŋgepta para tɨknandet. ");
INSERT INTO gai_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Karica iŋmbai mbuŋa Iesusa Galilina pitrik waŋ niŋgikca taŋrina. Na ma Iudiana pitrik waŋa mba taŋri, anna Iudanaŋgepca manmo mo menacna morena. ");
INSERT INTO gai_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Na Iudana mbembendeina rai anikca kɨpca laruna marambuŋairi, na anna, an Ndamb Ndeacrena Rai Anik. ");
INSERT INTO gai_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Aintik mana laiplacara manmo gaindopatna, “U gan auŋ tɨkcarica u Iudia taŋ, te, una iŋa raŋgairena ramtaɨra un morena ainta aiŋira u morenanna mina watna. ");
INSERT INTO gai_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ainda moca ramootta meikramtaɨra manmo wat rapacna mo te, ma aiŋa mba iŋgoroca mba morenan. Na u ainta reikca mona mo te, u laruca raekca tɨkca meikramtaɨrta lamnikta outta wɨtɨkca monandet.” ");
INSERT INTO gai_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Na mana laiplacar toco mina manmo mba rɨpacrenan, aintik mina manmo an kam ndopatna. ");
INSERT INTO gai_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ainda moca Iesusa mina kambmo gainda rutirina, “Aukna kɨdrɨkca mba larureke. Na kɨdrɨkar wɨtta anna nena kɨdrɨkar. ");
INSERT INTO gai_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ainda moca gan tiacarpaikna meikramtaɨra mina nenmo puŋnaŋgepca mba moitndai. Na mina aukmo puŋndamootta monandet, na aku mina morena tɨpemb kirarir ŋgorik minanmo, aku mbopca larurenan. ");
INSERT INTO gai_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Na ne an rai anikta moca ne Ierusalemma taŋga mbendeirenan. Na aku mba taŋitndai, aukna kɨdrɨkca mba larureke.” ");
INSERT INTO gai_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ri, ma minmo aindopacarica ma Galilia lambica eacri. ");
INSERT INTO gai_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Karica mana laiplacara taŋgatke, ma toco eaca iŋmbai mataŋgat. Na ma raekca mba larua taŋri, wanaiŋ, ma iŋgoroca taŋrina, te, meikramtaɨra manmo mba wati garacitndai. ");
INSERT INTO gai_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Na an mbendeina ra aniac, Iudanaŋgepta ramtaɨr paŋainda ŋgepca mana moca oreri, mina gaindopatna, “An ramootta ten ndeacrena?” ");
INSERT INTO gai_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ri, meikramtaɨra mana moca ndorita rɨkca lektekarta kamb puŋga mbopca taŋrena. Na ndeida aindoprina, “Ma ramoot laŋ.” Na ndeida aindopatna, “Wanaiŋ. Ma meikramtaɨrmo parurena.” ");
INSERT INTO gai_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ainda moca mina Iudanaŋgepta ramtaɨr paŋaindta moca nanambiri, na mina ianna mana morena tɨpna kirarna kammo raekca mba tɨkca mbopatke. ");
INSERT INTO gai_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Karica an Ndamb Ndeacrena Rai Anikta mamamaia kɨpca rambuŋairi, Iesusa Raraŋ Aetaniacna Kacna wuocna inikca mbukca meikramtaɨrmo riptirina. ");
INSERT INTO gai_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ri, Iudanaŋgepca mana an kambca waraca mina iroara tamtam ndamŋica mina gaindopatna, “Tida moca an ramootta an iro landamŋiap? Na ma landamŋi aŋgɨrena taupca mba taŋga landamŋi aŋgɨri.” ");
INSERT INTO gai_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Karica Iesusa mina kammo gainda rutica aindopatna, “Na an ririptiara aku nenmo neaŋrenanna, anna auknanna wanaiŋ. Anna Raraŋ Aetaniacnan, na ma ndo aukmo mbagɨrica kɨprina. ");
INSERT INTO gai_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Na ramoot ianna mana kambmo matau ŋgoinna raŋgaina mo te, ma auk riptica mbopapekna kambta mɨnɨŋmo lamŋi garacnandet. Te, ma lamŋinandet, an riptia anna Raraŋ Aetaniac ndambuŋnan, co, aukna iro mbuŋa larurina kam. ");
INSERT INTO gai_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ainda moca ramootta ndona iro mbuŋa kam ndop te, ma ndona i aniacmo aŋgɨ ŋgepna morena. Na ramootta man mbagɨrica kɨprina ramootna i aniacmo aŋgɨ ŋgepna mo te, an ramoot, ma ramoot wandoŋ ŋgoin. Na ma mba parurena ramoot. ");
INSERT INTO gai_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","“Na atua Mosesa nenmo Tɨp Wandɨkca neaŋrina. Ri, nena rɨkna ramoot ianna an Tɨp Wandɨkca mba raŋgairenan ŋgoin. Na kaina moca ne aukmo, mo menacna morena?” ");
INSERT INTO gai_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Karica meikramtaɨra mana kammo gainda rutica mboprina, “Ŋeroŋ ŋgoreaca unap eacre ki? Na mandaia unmo mo menacna morena?” ");
INSERT INTO gai_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ri, Iesusa mina kammo gainda nda rutica aindopatna, “Aku aiŋ ianna moatke, ne muruŋa anna tamtam malamŋireke. ");
INSERT INTO gai_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Na ne matau lamŋi. Mosesa nenmo tikiŋit kakatacna tɨp kirara ma nenmo neaŋgatnan, na ne Wɨktɨtɨkna Ramo nuikta tikiŋitmo katacrena. Na anna gidik, Mosesa ndo mbuŋa an Mosesna tɨp kirara mba moatnan. Anna nicar ŋgamrirta mɨn mbuŋa laruatna. ");
INSERT INTO gai_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Aintik ne Mosesna Tɨp Wandɨkmo matau raŋgaina moca ne ndorita nuikta tikiŋitmo Wɨktɨtɨkna Ra mbuŋa katacrenan. Na aku ramoot ianna tikca Wɨktɨtɨkna Ramo, mo laŋa mo te, kaina moca ne aukmo nikkatrenan? ");
INSERT INTO gai_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Na ne lamnɨac mbuŋa reikmo kai watca ritri teac, ne reikmo muruŋa tɨp kirar wandoŋ mbuŋa ritri moraŋ.” ");
INSERT INTO gai_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ainda moca Ierusalemna meikramtaɨr ndeida Iesus moatna reikca watca mina gaindopatna, “An ramootta ramtaɨr paŋainda manmo mo menacna morena ramoot ki? ");
INSERT INTO gai_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Na ne wat, ma ande raekca tɨkca kambmo wiwitirenan, na mina manmo reac ianna mba moreke. Moca mina lamŋire ki, ma an ramootta Raraŋ Aetaniaca babuca mbagɨrica kɨpca aimo mac nda aŋgɨna ramoot ki? ");
INSERT INTO gai_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Na an ramootna auŋ mɨnɨŋa aia lamŋirena. Na an mɨnna Raraŋ Aetaniaca babuca mbagɨrica kɨpca aimo mac nda aŋgɨna ramootta ma kɨp laru te, ramoot ianna mana auŋ mɨnɨŋa mba lamŋi garacitndai.” ");
INSERT INTO gai_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ri, Iesusa ma Raraŋ Aetaniacna Kacna wuocna inikca eaca meikramtaɨrmo Raraŋ Aetaniacna kambmo riptirena. Na ma kam keca gaindopatna, “Ne aukna auŋ mɨnɨŋapa aukmo, ne lamŋi ndopre ki? Na aku ndona toŋtoŋ mbuŋa mba kɨpri, wanaiŋ. Aetta ndo aukmo mbagɨrica aku kɨprinan. Na mana tɨpemb kirarira gidik, na ne manmo mba lamŋia rapacri. ");
INSERT INTO gai_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Na aku ndo manmo lamŋirenan. Na aku manapa eaca ma aukmo mbagɨrica aku kɨprinan.” ");
INSERT INTO gai_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ainda moca mina mana kamb mbaraca mina manmo kac ŋgoreaca tɨkna mori. Na mana ra mba kɨpca rambuŋairi, aintik ramoot ianna manmo mba utiŋgatke. ");
INSERT INTO gai_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ri, meikramtaɨr wɨtta manmo rɨpaca gaindopatna, “An mɨnna Raraŋ Aetaniaca babuca mbagɨrica kɨpca aimo mac nda aŋgɨna ramootta kɨp te, ma ŋgagatrac wɨtta moca, an ramootta morenanmo kunit ki?” ");
INSERT INTO gai_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Karica ramtaɨra Iesusa moatna ainta reikta kamb ndopatke, Parisiarta ramtaɨra mawaracat. Ainda moca taup ndamtaɨr paŋaindapa, Parisina ramtaɨra piriŋmo mbagɨrica manmo utiŋna. ");
INSERT INTO gai_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ri, Iesusa gaindopatna, “Kɨdrɨk tekemmotemma aku nenap eacnandet, na aku Aet ndambuŋa taŋnandet. Ma aukmo mbagɨrica aku kɨprina. ");
INSERT INTO gai_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Te, ne aukna moca oreraŋnandet, na ne aukmo mba watitndai. Na aku eacrena auŋa ne taŋna towanaiŋ.” ");
INSERT INTO gai_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ri, Iudanaŋgepca ndori puŋga gaindopatna, “Ma tenna taŋ te, aia manmo mba watit? Moca ma aina wiwittar tambuŋa taŋca Giriknanmo ripti nari? ");
INSERT INTO gai_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Na ma toco gaindopatna, ‘Ne aukna oreraŋ te, ne aukmo mba watitndai.’ Na ma mac gaindopatna, ‘Aku eacrena taupca ne mba taŋitndai.’ Na an kamna mɨnɨŋa kai?” ");
INSERT INTO gai_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Na an mbembendeina rai anikta mamamaina ra, anna ra aniac ŋgoin. Ri, an kɨdrɨkca Iesusa ŋgepca wɨtɨkca aca gaindopatna, “U mandaia puk amna logotta gagra te, u auk ndambuŋ nakɨpca puk am. ");
INSERT INTO gai_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Na an kamma Raraŋ Aetaniacna Timbigta Kap ndeacrena kirar, na ma gaind, ramootta aukmo rɨpac te, iarwarna eteacna pukca mana nikinik iroa mbukca mɨnna tɨknande.” ");
INSERT INTO gai_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Na anna Iesusa Ŋeroŋ Ratna kam ndoprenan, ramootta mana rɨpac te, ma aŋgɨnandet. Na an kɨdrɨkca Iesusa i aniaca mba aŋgɨreke, aintik Ŋeroŋ Ratta laru ŋgocor. ");
INSERT INTO gai_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Karica meikramtaɨr ndeida Iesus mbopatna kamb mbaraca mina gaindopatna, “Gidik ŋgoin, gan ramootta ma ande, Raraŋ Aetaniacna ramma morena ramoot.” ");
INSERT INTO gai_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ri, mina ndeida gaindopatna, “Ma an ramootta Raraŋ Aetaniaca babuca mbagɨrica kɨpca aimo mac nda aŋgɨna ramoot.” Na ndeida gaindoprina, “Wanaiŋ, an ramootta Raraŋ Aetaniaca baburinanna, ma Galili ndiŋa mba kɨpitndait. ");
INSERT INTO gai_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Na Raraŋ Aetaniacna Timbigta Kapca aindoprina, an ramootta Raraŋ Aetaniaca babuca mbagɨrica kɨpca aimo mac nda aŋgɨna ramoot, ma gagrirta ramoot paŋan Dewitna wiwitnan ndiŋ nakɨpnandet. Na ma Betlem ndiŋa kɨpnandet, an auŋa atua Dewitta eacrina.” ");
INSERT INTO gai_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ainda moca meikramtaɨra iroar damarap tik mina tumbun mbuniŋa titacrina. ");
INSERT INTO gai_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ri, ndeida manmo kac ŋgoreaca tɨkna mori, na mina ianna manmo utiŋna moca mba mori. ");
INSERT INTO gai_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Karica piriŋga taup ndamtaɨr paŋaindapa, Parisiar tambuŋa mac nda mataŋgat. Ri, mina minmo gainda digiatna, “Kaina moca ne manmo mba aŋgɨca kɨpri?” ");
INSERT INTO gai_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Na mina mimo nda rutica gaindopatna, “Ŋgaua ramoot ianna an ramoot mboprena kamna kirara mba mbopri.” ");
INSERT INTO gai_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Karica Parisiara minmo gaind mac rutica gaindopatna, “Ma nen motoco paruapek ki? ");
INSERT INTO gai_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Na aina Parisiarapa ramtaɨr paŋaindta wiwitmo ne watrena, aina ianna manmo rɨpacre ki? Wanaiŋ ŋgoin.” ");
INSERT INTO gai_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Na mina gaind mac mbopatna, “An wiwitta mana rɨpacrenanna, mina Tɨp Wandɨkca mba lamŋirena meikramtaɨr. Na Raraŋ Aetaniaca ma mboprinan, mina ŋgocrainandet.” ");
INSERT INTO gai_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Na Nikodemus ma an ramootta ŋgaua Iesus ndambuŋa taŋgatna ramoot, na ma mina wiwitnan. Ri, ma minmo gaindopatna, ");
INSERT INTO gai_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Aina tɨp wandɨkca gaindopre ki? Aia ramootmo wanaiŋa ritri waparaca wanaiŋa moit ki? Wanaiŋ. Aia mana kammo outta warac te, aia iŋmbaia lamŋina, ma kaina reac ŋgoreaca morina.” ");
INSERT INTO gai_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ri, mina mana kammo gainda rutirina, “U toco u Galilina ramoot ki? U Raraŋ Aetaniacna Timbigta Kapmo matau wat te, u toco u lamŋi garacna, ramma morena ramoot ianna Galili ndiŋa mba laruitndait.” ");
INSERT INTO gai_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Karica meikramtaɨra ndorita kaikca taŋgatna. ");
INSERT INTO gai_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Na Iesusa ma Olip Takur mataŋgat. ");
INSERT INTO gai_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Na ŋaŋarmuŋ ŋgoinna ma Raraŋ Aetaniacna Kacna wuoc mambukat. Na meikramtaɨr wɨtta man ndambuŋ nakɨpri, na ma anna mbiraca minmo ripti neaŋgatna. ");
INSERT INTO gai_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ainda moca tɨpemb wandik tamŋirena ramtaɨrapa, Parisina ramtaɨra meac laŋtaŋgo ianap aŋgɨca kɨprinan, na mina watrinanna, an meaca ma tɨp ŋgadudukca morena meacramootna tɨp kirar morinanmo, mina aŋgɨca kɨpca manmo meikramtaɨrta out mawɨtɨkat. ");
INSERT INTO gai_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Karica mina Iesusmo gaindopatna, “Riripti, gan meaca ma tɨp ŋgadudukca morena meacramootna tɨp kirara moca, mina manmo watrina. ");
INSERT INTO gai_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Na Tɨp Wandɨk mbuŋa Mosesa aindoprina, aia ainta meacmo waut mbuŋa rɨŋ menacnandet. Na u tit ndopit?” ");
INSERT INTO gai_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Na anna gaind, mina an kam mbuŋ ndopca, manmo towaina morina, te, ma kam ianna kati mbop te, mina manmo ritri waparaca tɨkna. Ri, Iesusa tutupniŋ rɨmbɨtca ma ndona patŋit mbuŋa pitrik matirri. ");
INSERT INTO gai_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Karica mina manmo memetmbac madigiri, na ma ŋgepca wɨtɨkca minmo gaindopatna, “Mandaia nena rɨknanna, tɨp ŋgoreacna makukca mo ŋgocor, ma outna wautmo an meaca rɨŋ.” ");
INSERT INTO gai_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ri, ma mac tutupniŋ rɨmbɨtca pitrik mac matirri. ");
INSERT INTO gai_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ainda moca mina an kam mbaraca mina muruŋa kabe, kabea ŋgepca an taup tɨkcarica mataŋgat. Na ramtaɨra iarir wɨtapnanna, mina outta taŋri, na ramtaɨr ŋgaibpaikca iŋmbai mataŋgat. Na Iesusa ndo kabe tutupniŋ rɨmbɨtca eacri, na an meaca mana outta wɨtɨkca eacrina. ");
INSERT INTO gai_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ainda moca Iesusa ŋgepca wɨtɨkca ma an meacmo gaindopatna, “Meacmbitac, gan ramtaɨra tenna taŋgapekna? Unmo ritri waparaca mona ramoot ianna eac ŋgocor ki?” ");
INSERT INTO gai_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ri, an meaca aindopatna, “Ramoot aniac, ramtaɨr kocor.” Na Iesusa gaindopatna, “Auk toco unmo ritri waparaca mba moitndai. U taŋca iŋmbaia tɨp ŋgoreacna makukca kai mac mo teac.” ");
INSERT INTO gai_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Karica Iesusa meikramtaɨrmo gaind mac mbopatna, “Aku ndo gan tiacarpaikna memetac. Na ramootta aukmo raŋgai te, ma neaupa mba taŋitndai. Ma iarwarna eteacna watna memetacap.” ");
INSERT INTO gai_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ri, Parisiara an kamb mbaraca mina Iesusmo gaindopatna, “U ndo mbuŋa u ndona aiŋapa tɨpemb kirarirta kamb tiŋgik ndoprena. Aintik u wiwitica mboprena kambca meikramtaɨra mba rɨpacitndai.” ");
INSERT INTO gai_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Karica Iesusa mina kammo gainda rutica mboprina, “Anna gidik, aku ndo mbuŋa ndona tɨpemb kirarirta kambca wiwitirena. Na meikramtaɨra aukna kambmo mina rɨpacnandet. Na aku gaindopnandet, aku ŋgepca kɨprina auŋa aku lamŋirena, na aku nda taŋna auŋa aku malamŋireke. Na ne aukna auŋ mɨnɨŋa ne mba lamŋireke. Na aku taŋgekna auŋa, ne an tocmo mba lamŋireke. ");
INSERT INTO gai_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Na ne meikramtaɨrmo tiacarpaikna tɨpna kirar mbuŋa ritri waparaca morenan. Na aku ramoot ianmo ainta tɨpna kirar mbuŋa ritri waparaca mba morenanna. ");
INSERT INTO gai_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Na aku ramoot ianmo mana tɨpna kirar mbuŋa ritri waparaca mo te, aukna ritri waparaca ma wandoŋ, na aukna kambca aku meikramtaɨrmo wiwitirinanna, mina rɨpacnandet, na aku ndo kabea mba ritri waparaca moitndai. Wanaiŋ. Na Aetta ndo aukmo mbagɨrica aku kɨprinan, ma ndo aukap aiŋa morena. ");
INSERT INTO gai_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Na nena Tɨp Wandɨkna kamma gaind maeacreke. Ramoot mbuniŋa kambmo iro kabe ndop te, maniŋna an kambca anna gidik. ");
INSERT INTO gai_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Na aku ndoa ndona aiŋapa tɨpna kirarna kambmo wiwitirenan, na Aetta aukmo mbagɨrica aku kɨprinanna, ma toco aukna aiŋapa tɨpna kirarna kambca wiwitirenan.” ");
INSERT INTO gai_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ainda moca Parisiara manmo gainda digirina, “An Aetta u mboprenanna, ma ten ndeacrena?” Ri, Iesusa gainda rutiatna, “Ne aukmo mba lamŋireke, na ne aukna Aetmo mba lamŋirenanna. Na ne aukmo lamŋi te, ne aukna Aet motoco ne lamŋinandet.” ");
INSERT INTO gai_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Na Iesusa an kamb toprinanna, ma meikramtaɨrmo Raraŋ Aetaniacna Kacna kitcartukar iurena diabna roumbca tɨkca minmo riptirena. Na ramoot ianna manmo mba utiŋri, an mɨnna mana kɨdrɨkca laru ŋgocor ndeacri. ");
INSERT INTO gai_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Karica Iesusa meikramtaɨrmo gaind mac mbopatna, “Aku mataŋgek, na ne aukmo mba watitndai. Na nena tɨpemb ŋgorikta makukara ma eacraŋnandet, na ne menacnandet. Aintik aku taŋrena auŋa ne mba taŋitndai.” ");
INSERT INTO gai_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ri, Iudanaŋgepca an kam mbaraca mina ndorimo aindopatna, “Tida moca ma aindopapekna, ‘Aku taŋrena auŋa ne mba taŋitndai?’ Moca ma ndomo mo menac nari?” ");
INSERT INTO gai_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Na Iesusa mina kammo nda rutica gaindopatna, “Ne pɨkɨnna meikramtaɨr, na aku, aku tamuŋna auŋnan. Na ne gan tiacarpaikna meikramtaɨr, na aku gan tiacarpaiknanna wanaiŋ. ");
INSERT INTO gai_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ainda moca aku nenmo mboprina, nena tɨpemb ŋgorikta makukara ma eacraŋnandet, na ne menacnandet. Na ne ainda rɨpac ŋgocor te, Aku Ndo, Aku Aind Ndeacraŋnandet, te, nena tɨpemb ŋgorikta makukara eacraŋnandet, na ne menacnandet.” ");
INSERT INTO gai_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Karica mina manmo mac digica mbopatna, “U mandai?” Ri, Iesusa minmo aindopatna, “Na aku nenmo mambopri, aku mandai. ");
INSERT INTO gai_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Na nena tɨpemb kirarirta moca, aku nenmo mbopna kam wɨt anikap. Te, aku nena tɨpemb kirarirmo, aku ritri waparacna ramoot toca monandet. Na Ramootta aukmo mbagɨrica aku kɨprinanna, mana tɨpemb kirarira wandoik koind. Na man ndambuŋa aku waracrina kambca anna aku gan tiacarpaikna meikramtaɨrmo wiwitirena.” ");
INSERT INTO gai_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Na mina mba lamŋireke, ma minmo Aetna kamb ndoprenanna, ");
INSERT INTO gai_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","ainda moca ma minmo gaindopatna, “An mɨnna ne Ramootna Nuocmo aŋgɨca ik nakerac te, ne gaind ndamŋinandet, Aku Ndo, Aku Aind Ndeacraŋnandet. Te, ne lamŋinande, aku reac ianna ndona iro mbuŋa mba morenanna. Wanaiŋ. Aetta aukmo mboprina kambmo aku anmo muruŋa riptirena. ");
INSERT INTO gai_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Na Aetta ma aukmo mbagɨrica aku kɨprina, na ma aukap eacrena. Na ma aukmo mba tɨkcariri, na aku ndo kabe ndeacrena. Wanaiŋ. Ma aukmo mba tɨkcarirenanna, memetmbaca ma toŋgorena reikca aku morena.” ");
INSERT INTO gai_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ri, meikramtaɨra Iesus mboprena an kambca waraca mina wɨtta manmo marɨpacat. ");
INSERT INTO gai_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Karica Iesusa mana rɨpacatna Iudanaŋgepmo gaindopatna, “Ne aukna kambmo utiŋ gagra te, ne aukna iŋa raŋgairena ramtaɨr gidkar teacnandet. ");
INSERT INTO gai_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Te, ne kam gidikmo lamŋinandet, na kam gidikca nenmo moca ne tuombta aiŋir kamndera mba eacitndait.” ");
INSERT INTO gai_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ri, mina mana kambmo gainda rutica aindopatna, “Aia Abraamna wiwitnan, na atu ŋgoinna tɨkca kɨprinan, aina ianna tuomna aiŋ kamaindna aiŋa mona ramoot ianna mba laruri, wanaiŋ ŋgoin. Aintik u kaina moca gaindopatna, ‘Ne tuombta aiŋir kamndera mba moitndai’?” ");
INSERT INTO gai_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Na Iesusa mina kambmo gainda rutica mbopatna, “Aku nemo gidik, gidik ŋgoinna aindopnande, meikramtaɨra muruŋcamiŋa tɨpemb ŋgorikta makukara morenan, mina tɨp ŋgoreacna makukna tuomna aiŋ kamainda morena meacramoot ndeacrena. ");
INSERT INTO gai_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Na tuomna aiŋ kamainda morena ramootta, ma ndona ramoot paŋanap mba iarwara mba eacrenanna, wanaiŋ. An ramoot paŋanna nuoca ndo iarwara mana aetap eacraŋnandet. ");
INSERT INTO gai_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ainda moca Nuoca nenmo moca ne tuombta aiŋir kamndera eac ŋgocorta meikramtaɨr taru te, ne tuombta aiŋir kamndera eac ŋgocorta meikramtaɨr koind teacnandet. ");
INSERT INTO gai_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","“Na aku lamŋirena, ne Abraamna wiwitnan. Na aukna kamma ma nena iroar inkara mba eacreke. Aintik ne aukmo mo menacna morena. ");
INSERT INTO gai_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ainda moca aku ndona Aetta aukmo wandacrina reikta kamb toprena. Na nena aetta nenmo neaŋrina tɨpembta kirarira ne anna raŋgaica morena.” ");
INSERT INTO gai_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Karica Iudanaŋgepca Iesusna kam mbaraca mina mana kammo gainda rutica mbopatna, “Aina nicar ŋgamrirta aetta Abraam.” Ri, Iesusa minmo gaindopatna, “Ne Abraamna nicar ŋgamrir te, ne Abraamma morina tɨpembta kirarira ne anna raŋgainandet. ");
INSERT INTO gai_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Na aku Raraŋ Aetaniac ndambuŋna kamb gidkar aku waracrinanna, anna nenmo an wiwitirena. Na mandeaca ne aukmo mo menacna mamoreke. Na ainta tɨpna kirara anna Abraamna tɨpna kirara wanaiŋ. ");
INSERT INTO gai_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ainda moca ne ndorita aetna tɨpna kirara raŋgaica morena.” Ri, mina manmo gaindopatna, “Aina amera meacramootna kaŋtertaapna tɨp kirara mba moca aimo mba mɨrrinan. Wanaiŋ. Aia Aet kabe niŋgikap, na ma Raraŋ Aetaniac.” ");
INSERT INTO gai_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Karica Iesusa minmo gaindopatna, “Na anna gidik ecte, Raraŋ Aetaniaca ma nena Aet, te, ne aukmo matŋinandet, aind aku Raraŋ Aetaniacap eaca kɨprina. Na aku ndona nikinik iro mbuŋa mba kɨpri. Wanaiŋ. Raraŋ Aetaniaca ndo aukmo mandaca aku kɨprina. ");
INSERT INTO gai_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","“Na kaina moca ne aukna kambmo matau garac ŋgocor? Na mana mɨnɨŋa ma gaind. Ne aukna kambmo waracna toawanaiŋ. ");
INSERT INTO gai_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Na ne Paparuna Ramootna mombonik, na ma nena aet. Na ne mana toŋtoŋa raŋgaina gagrarenan. Na atua ma meikramtaɨra mo menacna ramoot ndeacri. Aintik ma an tɨp kirar gidikca mba raŋgairenan, aind an tɨp kirar gidikca manmo mba eacrenanna. Na ma paparuna kamb toprena ramoot, na ma paparuna tɨpna kirarna kam ndoprena aet ŋgoin. ");
INSERT INTO gai_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Na aku kamb gidkara wiwitirena, na ne aukna kambca mba rɨpacrenanna. ");
INSERT INTO gai_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Na ne gaind ndamŋirena, aku tɨp ŋgoreacna makukca more ki? Na ne aind ndamŋi te, ne aukna tɨp ŋgoreacna makukmo wandac mbe. Na aku kam gidikca wiwit te, kaica ne aukna kammo rɨpac ŋgocor? ");
INSERT INTO gai_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Na Raraŋ Aetaniacna mombonikca mina mana kambmo muruŋa waracrena. Na ne Raraŋ Aetaniacna mombonikca wanaiŋ, ainda moca ne mana kambca mba waracrenanna.” ");
INSERT INTO gai_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Karica Iudanaŋgepca Iesusna kammo gainda rutica gaindopatna, “Aia aindoprina, u Samariana ramoot, na ŋeroŋ ŋgoreac ianna unap eacrenan, na anna gidik ki?” ");
INSERT INTO gai_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ri, Iesusa mina kammo gainda rutirina, “Wanaiŋ. Ŋeroŋ ŋgoreac ianna aukap eac ŋgocor. Na aku ndona Aetna i niŋgikca aŋgɨa ŋgeprena, na ne aukna imo aŋgɨa irikrena. ");
INSERT INTO gai_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Na aku ndona imo mba aŋgɨca ŋgeprenanna, Ramoot ianna aukna i aniacmo aŋgɨa ŋgepatnanna ma eacrena, na ma ritri waparaca morena ramoot. ");
INSERT INTO gai_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Na aku nemo gidik, gidik ŋgoinna aindopnandet, ramoot ianna aukna kamma raŋgai te, ma mba menacitndai. Wanaiŋ ŋgoin.” ");
INSERT INTO gai_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ri, an Iudanaŋgepca Iesusmo aindoprina, “Mandeaca aia malamŋica, u ŋeroŋ ŋgoreacap eacrena. Na Abraamapa rambca morina ramtaɨra menaca mamairi. Na u gaindoprina, ‘Ramootta una kammo matau raŋgai te, ma mba menacitndai.’ ");
INSERT INTO gai_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Kaica? U aina muruŋna ŋgamaɨr Abraammo tamuŋmbai ki? Na ma mamenacri. Na rambca morina ramtaɨr toco mina mamenacri. Na u ndomo mandai ŋgoin ndopca?” ");
INSERT INTO gai_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ri, Iesusa mina kammo gainda rutirina, “Aku ndona i aniacmo aŋgɨ ŋgep te, aukna i aniaca anna reac wanaiŋ. Aind aukna Aetta ma aukna i aniacmo aŋgɨa ŋgeprina. Na ne gaindoprena, ma nena Raraŋ Aetaniac. ");
INSERT INTO gai_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Na ne manmo mba mataua lamŋirenanna. Na aku ndo manmo lamŋirena. Na aku aindop te, ‘Aku manmo mba lamŋireke,’ te, aku nen toca paparuna ramoot ndarunandet. Na aku manmo lamŋirina, na mana kammo aku matau ŋgoinna raŋgairena. ");
INSERT INTO gai_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","“Na an mɨnna nena ŋgamaɨr Abraam, ma aukna rana watna iroap, na ma toŋtoŋ ŋgoin. Na an ramo ma watrinan, aintik ma nikinik iroa laŋ ŋgoin ndeacrena.” ");
INSERT INTO gai_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Karica Iudanaŋgepca an kam mbaraca mina Iesusmo aindoprina, “Una iarira 50na mɨnna mba aŋgɨatke, na titoca tɨkri, u Abraammo watatna?” ");
INSERT INTO gai_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Na Iesusa minmo gaindopatna, “Aku nemo gidik, gidik ŋgoinna aindopnandet, an mɨnna Abraamma laru ŋgocor, Aku Ndo, Aku Aind Ndeacraŋnandet.” ");
INSERT INTO gai_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ri, mina watur aŋgɨca manmo an mbuŋa rɨŋna mamori. Na Iesusa iŋgoroca ma Raraŋ Aetaniacna Kacna wuoc tɨkcarica ma raek malaruri. ");
INSERT INTO gai_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Karica Iesusa taŋrinan mbuŋa, ma lamnɨacniŋa ŋgocrairina ramoot ianna watrina. Na mana aemma manmo mɨrrinanna, ma lamnɨac ŋgoreac ndaruca aind ndeacrina. ");
INSERT INTO gai_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Na mana iŋa raŋgairena ramtaɨra manmo digica gaindopatna, “Riripti, mandaia tɨp ŋgoreacna makukca moca aemma mana mɨrri, ma lamnɨac ŋgoreac ndarurina? An ramootta ndo tɨp ŋgoreacna makukca mori ki, co mana aemaeta ndo tɨp ŋgoreacna makukca mori?” ");
INSERT INTO gai_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ri, Iesusa mina kammo ainda rutica aindopatna, “Gan ramootta ma tɨp ŋgoreacna makukca mba mori, na mana aemaet toco tɨp ŋgoreacna makukca mba mori. Wanaiŋ. Na gan reaca larurinanna, te, meikramtaɨra an ramootmo laruekna reacmo watnandet. Te, Raraŋ Aetaniacna aiŋa minmo raekca laruca mina watna. ");
INSERT INTO gai_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Na mandeaca anna memetacna mɨn, na aia Raraŋ Aetaniacna aiŋa moraŋ, ma aukmo mbagɨrica aku kɨprinan. Na neaupa kɨpnandet, te, meikramtaɨra aiŋ ianna mba moitndai. ");
INSERT INTO gai_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Na an mɨnna aku gan tiacarpaik ndeacrenanna, aku ndo gan tiacarpaikna memetac.” ");
INSERT INTO gai_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Karica Iesusa aindopacarica ma pitrikmo taber iuca. Ri, ma an tabermo pitrikap kurica, ma an pitrik aŋgɨca an lamnɨac ŋgoreacna ramootna lamnɨacniŋmo matɨkat. ");
INSERT INTO gai_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Karica Iesusa manmo gaindopatna, “U taŋca Siloamna rurena au pukca ru.” Na an i Siloam, ma an kamna kirar, “Mina manmo mandaca taŋrinan.” Ri, ma taŋga anna rurina. Na ma nda kɨpri, ma reikmo mataua watrina. ");
INSERT INTO gai_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Na mana kamkabeapa meikramtaɨrmo, ma ŋgaua minmo kitukndukna rurenanna mina manmo watca ndorimo aindopatna, “Kaica, anna an ramootta ŋgaua ma meikramtaɨrmo kitukndukna rurenan ki?” ");
INSERT INTO gai_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Na ndeida aindoprina, “Ore, an ramoot co.” Na ndeida aindoprina, “Wanaiŋ. Ma man tocna ramoot, na ma ramoot dam.” Ri, an ramootta ma ndo aindoprina, “Ganna auk.” ");
INSERT INTO gai_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ainda moca mina manmo madigiat, “Tida moca una lamnɨaca laŋa mori?” ");
INSERT INTO gai_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ri, ma gainda rutica mboprina, “An ramootta mina manmo Iesus ŋgacrenan, ma ndo pitrikapa pukap kurica aukna lamnɨacniŋa tɨkrinan. Na ma aukmo aindopatna, ‘U Siloamna rurena au pukca taŋca anna ru.’ Ainda moca aku anna taŋca ruri, aukna lamnɨacniŋa laŋa moca, aku reikmo mataua watrenan.” ");
INSERT INTO gai_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ri, mina manmo gainda rutica aindopatna, “Na an ramootta ten ndeacrenan?” Ri, ma aindopatna, “Aku mba lamŋireke.” ");
INSERT INTO gai_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Karica mina an ramootmo aŋgɨa Parisiar tambuŋ mataŋgat. ");
INSERT INTO gai_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Na an ra Iesusa pitrikmo kuririnanna, anna Wɨktɨtɨkna Ra. ");
INSERT INTO gai_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ainda moca Parisiara manmo mac digica, “Una lamnɨaca titoca moca ma laŋ ndaruri?” Ri, ma minmo gaindopatna, “Ma aukna lamnɨacmo pitrik kurica tɨkca aku ruca aku reikmo mataua mawatreke.” ");
INSERT INTO gai_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ri, Parisiar ndeida aindopatna, “Na aia lamŋirenan, Raraŋ Aetaniaca an ramootmo mba mbagɨrica kɨpri, ma Wɨktɨtɨkna Rana tɨpmo mba raŋgairena.” Na ndeida gaindopri, “Kaica ramootta tɨp ŋgoreacna makukapnanna, ainta ŋgagatraca morenan?” Ri, mina titaca tumbun mbuniŋ ndaruatna. ");
INSERT INTO gai_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ainda moca mina an ramootta ŋgaua ma lamnɨacniŋa ŋgocraica eacrenanmo mac digiat, “An ramootta una lamnɨacniŋmo mo laŋa morinanna, u manmo mandai ndamŋirina?” Na ma mina kammo rutica aindopatna, “Ma ramma morena ramoot ian.” ");
INSERT INTO gai_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Na anna gidik, ŋgaua gan ramootta ma lamnɨac ŋgoreac, na mandeaca mana lamnɨacniŋa laŋa morina. Na Iudanaŋgepca anna rɨpacna karirinan. Ri, mina an ramootta lamnɨacniŋa laŋa morina aemaetmo aca kɨpri. ");
INSERT INTO gai_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ainda moca maniŋa kɨpri, mina maniŋmo gainda digirinan, “Ganna oŋna nuoc ki? Na aemma manmo mɨrri, ma aintan ndeacri ki? Na kaica ma mandeaca watrenan?” ");
INSERT INTO gai_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Karica mana aemaeta gaindopatna, “Aŋga lamŋirena, anna aŋna nuoc. Na mana aemma manmo mɨrrinanna, na ma lamnɨac ŋgoreac ndeacri, an toco aŋga lamŋirinan. ");
INSERT INTO gai_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Na mandeaca mana lamnɨacniŋa laŋa morinanna, anna aŋga mba lamŋiri. Ne manmo digi, ma ramoot aniaca mori. Na ma ndona kam ndopi larunandet.” ");
INSERT INTO gai_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Na an kɨdrɨkca aemaeta Iudanaŋgepna nanambica an kam ndoprina. An Iudanaŋgepca mina kam leaca gaindopatna, ramoot ianna aindop te, Iesusa an ramootta Raraŋ Aetaniaca babuca mbagɨrica kɨpca aimo mac nda aŋgɨna ramoot, aindop te, mina manmo mba wattacarica mina Iudananta mimitpac aŋgɨrena kaca mba mbukca mbendeitndai. ");
INSERT INTO gai_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ainda moca an mɨnɨŋna moca an ramootna aemaeta gaindopri, “Ma ramoot aniaca mori, ne manmo digi.” ");
INSERT INTO gai_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Karica mina an lamnɨacniŋ ŋgocrairina ramoot mac aca kɨpca. Mina manmo aindopatna, “U Raraŋ Aetaniacna i aniacmo aŋgɨ ŋgepca kammo leaca moi gagraca u kam gidik ndop. Na aia lamŋirenan, an ramootta u mboprenan, anna ma tɨp ŋgoreacna makukca morena ramoot.” ");
INSERT INTO gai_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ri, ma mina kambmo gainda rutirinan, “Ma tɨp ŋgoreacna makukca morena ramoot, co wanaiŋ, anna aku mba garacri. Na reac kabe niŋgikca aku lamŋirenan. Na ŋgaua aku lamnɨac ŋgoreac ndeacrina, na mandeaca aku watrena.” ");
INSERT INTO gai_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ri, mina manmo gaind mac digica, “Ma unmo tida mori? Na una lamnɨacniŋmo ma titoca moca laŋa mori?” ");
INSERT INTO gai_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Karica ma mina kammo gainda rutica aindopatna, “Aku nenmo mbopatke, ne mba waracri. Na kaina moca ne memetmbaca waracna morenan? Moca ne toco mana iŋa raŋgairena ramtaɨr taruna more ki?” ");
INSERT INTO gai_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ri, Parisiara an ramootmo gainda pepereca aindopatna, “U ndo mana iŋa raŋgairena ramoot, na aia wanaiŋ, aia Mosesna iŋa raŋgairena ramtaɨr. ");
INSERT INTO gai_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Na aia lamŋirina, Raraŋ Aetaniaca ma Mosesmo kam neaŋgatnan, na an ramoot, ma ten ndiŋa kɨprinan, aia mba lamŋireke?” ");
INSERT INTO gai_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ainda moca an ramoot, ma ŋgaua lamnɨacniŋa ŋgocraica eacrenanna, ma mina kambmo gainda nda rutica aindopatna, “Ne kabena kam ŋgoin mambopreke. An ramootta ma aukna lamnɨacniŋa moa laŋa morinan, na ne gaindoprenan, ne manmo mba lamŋireke? Na ma ten ndiŋa kɨprinan. ");
INSERT INTO gai_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ainda moca aia lamŋirena, Raraŋ Aetaniac, ma tɨp ŋgoreacna makukca morena ramootna kamma ma mba waracrenan. Na ramoot ianna ma manmo mbendeirenan, na mana toŋtoŋa raŋgairenan, te, Raraŋ Aetaniac, ma mana kammo waracnandet. ");
INSERT INTO gai_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Na atuna mɨnna tɨkca kɨpca mandeacna mɨnna, ramoot ianna mana aemma manmo mɨrca ma lamnɨac ŋgoreac ndeaca, iŋmbaia ramoot ianna mana lamnɨacmo laŋa morina nininia kamaind ŋgoin. ");
INSERT INTO gai_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ainda moca Raraŋ Aetaniaca gan ramootmo mbagɨrica ma kɨp ŋgocor, te, ma reac ianna mba moitndai.” ");
INSERT INTO gai_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ri, Parisiara an kam mbaraca mina mana kammo gainda rutica aindopatna, “Kaia? Tɨp ŋgoreacna makukca unmo matau ŋgoinna leacrinan, an mɨnna una aemma unmo mɨrca kɨpca mandeacna mɨn. Na u aimo riptina more ki, a?” Karica mina manmo raekca keca larurina. ");
INSERT INTO gai_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ainda moca Iesusa an ramootmo mina kaekga moca manmo raekca keca larurenanna kam mbaraca ma mana ŋgoreaca taŋri. Karica ma manmo watca ma manmo gaindopatna, “U Ramootna Nuocmo rɨpacre ki, co wanaiŋ?” ");
INSERT INTO gai_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ri, ma rutica aindopatna, “Ramoot aniac, Ramootna Nuoca mandai? U aukmo mbop te, aku mana rɨpacnandet.” ");
INSERT INTO gai_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Karica Iesusa manmo gaindopatna, “U manmo mawatri, ma ande an ramootta unap mambopreke.” ");
INSERT INTO gai_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ri, an ramootta aindopatna, “Kacoot aku rɨpacrena.” Karica ma tutupniŋ rɨmbɨtca ma manmo mambendeiat. ");
INSERT INTO gai_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ainda moca Iesusa gaindopatna, “Aku gan tiacarpaikna meikramtaɨrta tɨpemb kirarirmo ritri waparacna kɨprinan. Ainda moca lamnik ŋgorikca eacrena ramtaɨr mina watnandet. Te, lamnik laiŋga watrenan, mina lamnik ŋgorikca moca pupuroik ndeacnandet.” ");
INSERT INTO gai_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ri, Parisiar ndeida Iesusna kɨtɨm ndeacrenanna, mina an kam mbaracri. Ainda moca mina manmo madigiat, “U aimo lamnik ŋgorik pupuroikta ramtaɨr ndopre ki?” ");
INSERT INTO gai_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ri, Iesusa mina kammo gainda rutica aindopatna, “Nena lamnikca ŋgocrai te, ne tɨpemb ŋgorikta makukara mba moitndai. Na ne gaindoprenan, ‘Aina lamnikca laiŋ.’ Aintik nena tɨpemb ŋgorikta makukara maeacreke.” ");
INSERT INTO gai_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Karica Iesusa gaind mac mbopatna, “Aku nemo gidik, gidik ŋgoinna aindopnandet, ramootta ma sipsipna wuocna tɨŋa mba mbukrenan, ma wuocmo monmbai waŋa werapca mbukrenanna, ainta ramoot ma macmakɨmna ramoot, na ma kabena ramootna reacmo kam kocora aŋgɨrena. ");
INSERT INTO gai_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Na ramootta tɨŋ ndiŋa mbukrenan, anna ma sipsipna bubuoca morena ramoot. ");
INSERT INTO gai_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Na tɨŋna ŋginaŋa morena ramootta ma an sipsipna ŋginaŋa morena ramootna tɨŋ gootrena. Na sipsipara an mina ŋginaŋa morena ramootna kammo warac garacnandet. Na ma mina irembmo kabe, kabe ŋgacrenan, te, ma minmo aŋgɨca laruna. ");
INSERT INTO gai_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Na ma minmo muruŋa aŋgɨ laru mai te, ma minmo outta taŋraŋnandet. Te, sipsipara mina mana kam mbaraca manmo raŋgaica taŋrena. ");
INSERT INTO gai_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Na mina kabena ramootmo mba raŋgairena, na kabena ramootta ac te, mina man narica kɨpcarinandet. Na mina kabena ramtaɨrta kambca mba waracrenan, wanaiŋ ŋgoin.” ");
INSERT INTO gai_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Na Iesusa minmo an kam roora keatke, mina mana keatna kam roorna mɨnɨŋa mba garacatke. ");
INSERT INTO gai_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ri, ma minmo gaind mac mbopatna, “Aku nemo gidik, gidik ŋgoinna aindopnandet, aku ndo aku sipsiparta wuocna tɨŋ.” ");
INSERT INTO gai_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Na aukmo outta muruŋa kɨpatna ramtaɨra mina ŋgapir, na reikmo kam kocora aŋgɨrenan. Na sipsipara mina kambmo mba waracrena. ");
INSERT INTO gai_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Na aku ndo aku tɨŋ. Na ramoot ianna ma auk ndambuŋa kɨpca tɨŋa mbuk te, Raraŋ Aetaniaca manmo mac nda aŋgɨnandet. Te, ma ŋaia mbukca, na raekca taŋca, na taŋ kɨpca amna reac aŋgɨnandet. ");
INSERT INTO gai_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","“Na macmakɨmna ramoot, ma reac ianna mona mba kɨprenan, wanaiŋ. Ma sipsipar makɨmna kɨprenan, na ma minmo mo menacnanapa mo ŋgocraina kɨprina. Na aku kɨprinanna, mina iarwarna eteacna wat aŋgɨna, na iarwarna eteacna watta minmo mɨnna tɨkna. ");
INSERT INTO gai_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Na aku ndo aku sipsipara bubuocna ramoot laŋ. Na sipsiparta bubuocna ramoot laŋ, ma ndona eteacna watmo ndona sipsiparmo otacna moca kecarirena. ");
INSERT INTO gai_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Na ramootta kitukndukna aiŋa morenan, na ma sipsiparta bubuoc gidikca wanaiŋ, na ma mina aetta wanaiŋ, na ma raŋna piraŋ kunna wat te, ma sipsiparmo tɨkcarica kɨpcarinandet. Te, an raŋna piraŋa ma sipsiparmo wi te, minmo tamtamca ootca mina tamtamca taŋnandet. ");
INSERT INTO gai_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Na an ramootta ma ainda moatnanna, ma kituknduk niŋgikna aiŋa morenan. Ainda moca ma sipsiparta moca ma mba kadmairena. ");
INSERT INTO gai_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Na aku ndo aku sipsiparta bubuocna ramoot laŋ. Na aku ndona sipsiparmo lamŋirenan, na mina aukmo lamŋirenan, ");
INSERT INTO gai_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","na an tɨpna kirara Aetta aukmo lamŋirena, na auk toco Aetmo lamŋirena. Ainda moca aku ndona eteacna wat auknanmo sipsipar kotacna kecarinandet. ");
INSERT INTO gai_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Na auk toco kabena sipsiparap, na mina gan wuocnanna wanaiŋ. Na aku an sipsipar motocmo aŋgɨ kɨpnandet. Te, mina aukna kam mbaracna. Ainda mo te, sipsiparta tumbun kabe niŋgik, na min bubuocna ramootta kabe niŋgik. ");
INSERT INTO gai_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Na an kamna mɨnɨŋa gaind, Aetta ma aukmo mamatŋi ŋgoin, aku ndona eteacna watnanmo kecariri, na aku mac nda aŋgɨnandet. ");
INSERT INTO gai_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ainda moca ramoot ianna aukna eteacna watmo mo maina mɨnna wanaiŋ, wanaiŋ ŋgoin. Aukna toŋtoŋ mbuŋa aku ndona eteacna watmo kecarinandet. Na aku ndona eteacna wat kecarina gargarap, na aku ndona eteacna wat mac nda aŋgɨna gargarap. Na aukna Aetta aukmo ainda mona mboprina.” ");
INSERT INTO gai_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ri, Iudanaŋgepca an kamb mbaraca mina tumbun mbuniŋa titacatna. ");
INSERT INTO gai_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ainda moca mina wɨtta gaindopatna, “Ŋeroŋ ŋgoreaca manap eacrenan, na ma ŋaŋaŋaorenan. Na kaina moca ne kour tɨkca mana kambmo waracrenan?” ");
INSERT INTO gai_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Na ndeida gaindopatna, “Anna ŋeroŋapna ramootna kambca wanaiŋ. Na ŋeroŋ ŋgoreaca lamnɨac ŋgoreacna ramootta moi laŋa mona mɨn ki, a?” ");
INSERT INTO gai_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Na an mɨnna Raraŋ Aetaniacna mbembendeiana ra aniaca Ierusalemma larurinan. Na anna mina atua Raraŋ Aetaniacna Kacmo mana para tɨkna moca mina an ramo larapacatna. Na an mɨnna anna tik gagagau aniacna mɨn. ");
INSERT INTO gai_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ainda moca Iesusa ma Raraŋ Aetaniacna Kacna wuoc roumbna inikna Solomonna morina wacraetna inikca taŋrena. ");
INSERT INTO gai_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ri, Iudanaŋgepca kɨpca manmo paria mina manmo, gaindopatna, “Tumbuitta tɨkca u aimo mbop garacna, u mandai ŋgoin? Na u an ramootta Raraŋ Aetaniaca babuca mbagɨrica kɨpca aimo mac nda aŋgɨna ramoot ecte, u aimo mbop garacna.” ");
INSERT INTO gai_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Karica Iesusa mina kambmo gainda nda rutica aindopatna, “Aku nenmo mbopatke, ne mba rɨpacri. Na aiŋira aku ndona Aetna i mbuŋa morinanna, anna nenmo wandacrina, aku mandai ŋgoin. ");
INSERT INTO gai_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Na ne aukna sipsiparta tumbunna wanaiŋ tik, ainda moca ne mba rɨpacrena.” ");
INSERT INTO gai_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Na aukna sipsipara mina aukna kambca waracrenan, na aku minmo lamŋirena, na mina aukmo raŋgairena. ");
INSERT INTO gai_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Na aku minmo iarwar ndeacrena wat neaŋca, mina mba topitndai. Wanaiŋ ŋgoin. Na ramoot ianna minmo aukna para mba tɨkca aŋgɨitndai. ");
INSERT INTO gai_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Aukna Aetta minmo aukmo neaŋgatna. Na ma tamuŋ ŋgoin, na reikmo ma muruŋa kunda tamuŋ, tamuŋ ŋgoin. Ainda moca ramoot ianna minmo mana para tɨkca aŋgɨna mɨnna wanaiŋ. ");
INSERT INTO gai_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Na aukapa Aetta aŋga kabe niŋgik. ");
INSERT INTO gai_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ri, Iudanaŋgepca an kambca waraca mina watur mac aŋgɨca mana rɨŋ menacna mori. ");
INSERT INTO gai_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Karica Iesusa minmo gaindopatna, “Aku nenmo Aetna aiŋir laiŋga wandacatna. Na ne an aiŋirmo titocnanmo tit ndamŋica aukmo watur puŋga rɨŋ menacna morena?” ");
INSERT INTO gai_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ri, Iudanaŋgepca mana kambmo gainda rutica aindopatna, “Aia aiŋ laŋ ianna mba lamŋica unmo watur puŋga rɨŋ menacna mori, wanaiŋ. U ndomo Raraŋ Aetaniacna taup aŋgɨna more tik, anna mɨnɨŋna moca aia unmo watur puŋga rɨŋ menacna morena. Na u ramoot wanaiŋ niŋgik, na u ndomo Raraŋ Aetaniac ndoprenan.” ");
INSERT INTO gai_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Karica Iesusa mina kambmo gainda rutirinan, “Na nena Tɨp Wandɨkca Raraŋ Aetaniacna kam ianna gaindoprenan, ‘Aku aindoprina, “Ne toco ne Raraŋ Aetaniac.”’ ");
INSERT INTO gai_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Na atua Raraŋ Aetaniaca meikramtaɨrmo an kamma wiwitiatnan, na ma aindopatna mina Raraŋ Aetaniac. Na kamma Raraŋ Aetaniacna Timbigta Kap ndeacrena kambca mba ŋgetrikirena. ");
INSERT INTO gai_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Na aukmo Aetta ndo larapacrinan, na ma aukmo mandaca aku gan tiacarpaikca kɨprinan. Ainda moca aku gaindop te, ‘Aku Raraŋ Aetaniacna Nuoc.’ Kaina moca ne aindopatna, ‘U Raraŋ Aetaniacna taup aŋgɨna morena’? ");
INSERT INTO gai_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","“Na aku ndona Aetna aiŋira mo ŋgocor te, ne aukna kambmo mba rɨpacitndai. ");
INSERT INTO gai_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Na aku mana aiŋira morenan. Aintik ne aukna kambmo rɨpacna kari te, ne auk morena aiŋirmo ne rɨpac. Ainda moca ne iroar landamŋi laiŋmo gainda aŋgɨna, Aetta aukap eacrenan, na aku Aetap eacrenan.” ");
INSERT INTO gai_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Na mina manmo mac muoc utiŋna mori, na ma minmo iukaia mataŋgat. ");
INSERT INTO gai_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Karica Iesusa mac nda taŋga Iodan ocmo kataca mataŋgat. Na ma taŋga ŋgaua Ionna meikramtaɨrmo kɨtac pukca neaŋrena taup ndaruca, ma an ndeacri. ");
INSERT INTO gai_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Na meikramtaɨr wɨtta man ndambuŋ nakɨprina. Na mina gaindopatna, “Gidik, Ionna ma ŋgagatrac ianna mba moca ndona kamma mo gagrana ŋgagatraca mba moatna, wanaiŋ. Na an kambca Ionna gan ramootmo mbopatnanna, anna gidik niŋgik.” ");
INSERT INTO gai_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Na an mɨnna Iesusa an ndeacri, meikramtaɨr wɨtta manmo rɨpacatna. ");
INSERT INTO gai_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Na ramoot ianna ma roumbapnan, na mana ia Lasarus, na ma Betani auŋnan. Na Betani auŋa anna Mariaapa mana lacainameac Matana auŋ. ");
INSERT INTO gai_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Na an Maria ma Kacootna ormo tabaɨr ruŋkica ndikrina meac, na ma ndona paŋanna lakoar puŋga muririna. Na Lasarus, ma an ramootta roumbapna ramoot, na ma an meacniŋna ndaŋ. ");
INSERT INTO gai_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ri, an meacniŋa Iesusmo kam neaŋga taŋga aindopatna, “Kacoot, an ramootta u matŋirenanna, ma roumbap.” ");
INSERT INTO gai_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Na Iesusa anna waraca ma gaindopatna, “An roumbca anna ramootta menacna roumbca wanaiŋ. Anna ma meikramtaɨrmo moca mina Raraŋ Aetaniacna gargara watca manmo i aniac neaŋna. Na an taup mbuŋa Raraŋ Aetaniacna Nuoc toco, ma i aniac aŋgɨnandet.” ");
INSERT INTO gai_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Na Iesusa ma Lasarusapa mana mbiniŋmo mamatŋi aniacap. ");
INSERT INTO gai_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Na an mɨn mbuŋa, ma Lasarusna roumbna kam mbaracatnanna, ma an auŋa ma eacrinanmo ma kabena ra mbuniŋ mac eacatna. ");
INSERT INTO gai_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Karica iŋmbaia ma ndona iŋa raŋgairena ramtaɨrmo gaindopatna, “Aia Iudiana pitrik waŋga nda taŋna.” ");
INSERT INTO gai_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ri, mana iŋa raŋgairena ramtaɨra gaindopatna, “Riripti, rocotta wanaiŋa Iudanaŋgepca unmo watur puŋga rɨŋ menacna morina. Na u an mac taŋna more ki?” ");
INSERT INTO gai_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Na Iesusa mina kambmo gainda rutirina, “Ra ma ŋaŋarmuŋa tɨkca taŋi ra wigwac te, ma memetacap. Na u mandaia an kɨdrɨk mbuŋa taŋ te, una ora mba aoclataca irikitndait. Na anna ma gan tiacarpaikna memetac mbuŋa watca taŋrenan. ");
INSERT INTO gai_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Na ramootta mouŋa taŋ te, ma irikrenan, an kɨdrɨkca ma memetaca metac watna tac ŋgocor.” ");
INSERT INTO gai_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Na ma aindopca maica, iŋmbaia ma gaind mac mbopatna, “Aina aikndamoot Lasarusa ma ŋgorena. Na aku taŋca manmo, mo ŋgepnandet.” ");
INSERT INTO gai_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ri, mana iŋa raŋgairena ramtaɨra an kam mbaraca mina gaindopatna, “Kacoot, ma ŋgo te, mana roumbca laŋa moca ma laŋa monande.” ");
INSERT INTO gai_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Na mina gaind ndamŋirena Iesusa Lasarusmo ŋgogo niŋgikna kam ndoprina. Na an kɨdrɨkca mina mba garacri, Iesusa aindoprina, Lasarusa menacrinan. ");
INSERT INTO gai_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ainda moca Iesusa mandeaca minmo mbopca waracrina, na ma gaindopatna, “Lasarusa ma mamenacri. ");
INSERT INTO gai_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Na aku toŋgorinanna aku an kɨdrɨkca manapa mba eacri. Anna aku nena moca lamŋirina. Na anna ndo nenmo moca ne rɨpacnandet. Aintik mandeaca aia man ndambuŋa taŋnandet.” ");
INSERT INTO gai_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Na Iesusa aindopca maicatke, Tomas mana i ianna Didimus, ma ndo, Iesusna iŋa raŋgairena ramtaɨrmo gaindopatna, “Aria, aia muruŋa taŋca Iesusap Iudia tɨkca manap menacna.” ");
INSERT INTO gai_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Karica Iesusapa mana iŋa raŋgairena ramtaɨra taŋga Betani auŋmo rambuŋairi, ma ainda waracrina, mina Lasarusmo mutoca muk inik ndeaca raia paur mamoat. ");
INSERT INTO gai_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Na Betani auŋa ma Ierusalem auŋ aniacmo tawan ŋgoinna wanaiŋ. ");
INSERT INTO gai_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ainda moca Iudanaŋgepta meikramtaɨr wɨtta kɨpca Mataapa Maria mbaniŋap eacrina, te, maniŋa iro wetwet aŋgɨca ndoniŋna ndaŋna moca mba kadmaiitndai. ");
INSERT INTO gai_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ri, Mata ma waracrinanna, Iesusa taup ndiŋ nakɨpri, aintik ma ndona lapnameac Mariamo tɨkcarica ma taup ndiŋa taŋca manmo ndauprikina. ");
INSERT INTO gai_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Karica ma manmo gaindopatna, “Kacoot u gan ndeac co, aukna ndaŋa mba menac mbe. ");
INSERT INTO gai_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Na mandeac aku malamŋiri, u Raraŋ Aetaniacmo, reac ianna mbendei te, ma unmo neaŋnandet.” ");
INSERT INTO gai_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ri, Iesusa manmo gaindopatna, “Una ndaŋa ma mac ŋgepnandet.” ");
INSERT INTO gai_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Na Mata manmo aindopatna, “Aku lamŋirena, ma gan tiacarpaikna mamaina ra ma mac ŋgepnande, na an mɨnna gan tiacarpaikna meikramtaɨra muruŋa mac ŋgepnandet.” ");
INSERT INTO gai_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ainda moca ma manmo gaindoprina, “Mac nda ŋgeŋgepca aku ndo. Na eteacna watta aku ndo. Na mandaia aukmo rɨpac te, na ma menac te, ma eacraŋnandet. ");
INSERT INTO gai_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Na meikramtaɨra muruŋa menac ŋgocora, aukmo rɨpacrenan, mina mba menacitndai. Mina iarwar ndeacraŋnandet. Na u anna rɨpacri ki, co wanaiŋ?” ");
INSERT INTO gai_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ri, Mata Iesusmo gaindopatna, “Ore Kacoot. Aku rɨpacrina, u Raraŋ Aetaniacna Nuoc. Na u an ramootta Raraŋ Aetaniaca babuca mbagɨrica kɨpca aimo mac nda aŋgɨna ramoot.” ");
INSERT INTO gai_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Na Mata aindopacarica ma taŋga ndona lapnameac Mariana maacat. Ri, ma mana koarmo laŋanna gaindopatna, “Ririptia kɨpca maeacreke, na ma una moca digirena.” ");
INSERT INTO gai_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ainda moca Maria an kam mbaraca ma tawi ŋgoin naŋgepca Iesus mbatna mataŋgat. ");
INSERT INTO gai_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Na Iesusa ma auŋmo mba larureke. Ma an taupca Mata manmo watrinanna, ma an ndeacrena. ");
INSERT INTO gai_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Na an Iudanaŋgepca Mariaap kadmaica eacrenan, mina watrinanna, ma ŋgepca tawi ŋgoinna kac tɨkcarica laruri, mitoco ŋgepca laruca maraŋgaiat. Na mina gaind ndamŋirina, moca ma taŋca mukca tɨkca ae nari. ");
INSERT INTO gai_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ainda moca Maria ma taŋca Iesus eacrena taup ndaruca, ma manmo watca, mana kɨtɨmma ma ndona tutupniŋmo rɨmbɨtca manmo gaindopatna, “Kacoot, u gan ndeac co, aukna ndaŋa ma mba menac mbe.” ");
INSERT INTO gai_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ri, Iesusa wattatnanna Mariaapa Iudana meikramtaɨra aerena, na ma kakadmai ŋgoin mamoat. ");
INSERT INTO gai_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Na ma mimo madigiat, “Waɨrmo ne tenna mutocrina?” Ri, mina manmo nda rutica gaindopatna, “Kacoot, u kɨpca ndo wat.” ");
INSERT INTO gai_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ri, Iesusa anduna maaeat. ");
INSERT INTO gai_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Na Iudana meikramtaɨra aindopatna, “Ne wat, ma Lasarusna toŋtoŋ aniac ŋgoin tik ma aerena.” ");
INSERT INTO gai_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Na mina ndeida aindopatna, “Ma lamnik ŋgorikmo, moa laŋa morenan, na kaica ma Lasarusmo otac ŋgocor?” ");
INSERT INTO gai_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Na Iesusa ma kakadmai aniacap maeacreke. Ainda moca ma muk ndambuŋa taŋrina, na an mukca mina wautmo aua iaca waut aniac mbuŋa mana tɨŋmo mboracrena. ");
INSERT INTO gai_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Karica ma ramtaɨrmo mbopca, mina wautmo rukica taŋ te, tɨŋa gootna. Ri, Mata gaindopatna, “Kacoot, u lamŋirena Lasarusa ma menaca raia paur mamoat, na waɨra ma iŋpairapacnandet.” ");
INSERT INTO gai_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ri, ma minmo aindopatna, “Aku nenmo mboprinan, ne rɨpac te, ne Raraŋ Aetaniacna gargarapa i aniacmo watnandet.” ");
INSERT INTO gai_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ainda moca mina wautmo rukica taŋga roumbmbaia tɨkri, Iesusa tamuŋna auŋa raia watca ma mambendeiat, na ma aindopatna, “Ate, aku unmo toŋtoŋ ŋgoin, u aukna mbembendeimo mawaracri. ");
INSERT INTO gai_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Na aku lamŋirena, u memetmbaca aukna mbembendeiarmo, u waracrena. Na aku aindop te, gan meikramtaɨra rɨpacnandet, u aukmo mbagɨrica aku kɨprina.” ");
INSERT INTO gai_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Karica ma mbendeia maiatke, ma kam keca gaindopatna, “Lasarus, u laru!” ");
INSERT INTO gai_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Na an menacrina ramootta malaruat. Na mana orapa para mina raraŋit budir puŋga tamairina, na mana inpaŋan tocmo raraŋit mbuŋa tamairina. Karica Iesusa meikramtaɨrmo gaindopatna, “Mana tikna raraŋitmo pɨarca ma taŋna.” ");
INSERT INTO gai_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ainda moca an Iudanaŋgepta ramtaɨr wɨt aniaca Mariaap kɨpca kakadmaica morinanna, mina an reaca Iesusa moatnanna watca mina manmo marɨpacat. ");
INSERT INTO gai_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ri, mina ndeida ŋgepca taŋca Parisiarmo an man morina reacna kam ndoprina. ");
INSERT INTO gai_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ainda moca taup ndamtaɨr paŋaindapa Parisiara mina ninik waŋgorta ramtaɨrmo aca kɨpca mina minmo gaindoprina, “Aia tida moit? Gan ramootta ma ŋgagatrac wɨt aniaca morenan. ");
INSERT INTO gai_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Na aia manmo wattacarica ma an tɨp kirara moraŋ te, meikramtaɨra muruŋcamiŋa manmo rɨpacnandet. Te, Romnaŋgepca kɨpca aina Raraŋ Aetaniacna Kacapa aina barna wiwitna meikramtaɨrmo, mo topnande.” ");
INSERT INTO gai_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Na mina rɨkna ramoot ianna mana ia Kaiapas, na an mɨnna ma taup ndamoot paŋan aniac ndeacri, na ma minmo gaindopatna, “Ne iroar kocor koind ki? ");
INSERT INTO gai_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Aintik nen opotacna iro landamŋiap kocor ki? Na anna laŋ, ramoot kabea ndo meikramtaɨr wɨtna taup aŋgɨca menac te, aina barna wiwitna meikramtaɨra mba topitndait.” ");
INSERT INTO gai_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Na Kaiapas ma ndona iro mbuŋa an kambmo mba moatke, wanaiŋ. An mɨnna ma taup ndamoot paŋan aniac ndeacri, ma an rambna kambmo moca Iesusa menac te, Iudanaŋgepta meikramtaɨrmo otacna. ");
INSERT INTO gai_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ainda moca Iesusa menacatnanna, ma Iudanaŋgepta meikramtaɨr tiŋgikmo mba otacnanna. Wanaiŋ. Ma menacrinanna, ma Raraŋ Aetaniacna mombonikca tamtam ndeacrenanmo, aŋgɨca tumbunna tɨkca mina wiwit kabe ndarunan. ");
INSERT INTO gai_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ri, an ra ŋgoin mbuŋa, ramtaɨr paŋainda kamb leaca taupembta koreca, manmo mo menacna. ");
INSERT INTO gai_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ainda moca Iesusa Iudanaŋgepta raekmo mba mac larua taŋri. Aintik ma an auŋ tɨkcarica ma meikramtaɨr kocorta taupna auŋ ianna mana ia Epiraim mataŋgat, na ma ndona iŋa raŋgairena ramtaɨrap, an ndeacrina. ");
INSERT INTO gai_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Na an Pasowana Ra ma kɨpca marambuŋairi. Ainda moca auŋembta meikramtaɨra Ierusalem auŋ aniaca taŋca ndorimo Raraŋ Aetaniacna lamnɨac ŋgoutmo, mo ratna moca mataŋgat. ");
INSERT INTO gai_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ri, mina Iesusna ŋgorerina. Na mina Raraŋ Aetaniacna Kacna wuocna inikca wɨtɨkca ndorita rɨkmo aindoprina, “Ne tit ndamŋire? Ma an mbembendeina ra aniaca watna kɨpit ki, co wanaiŋ?” ");
INSERT INTO gai_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Na taup ndamtaɨr paŋaindapa Parisiara mina meikramtaɨrmo mambopat, mandaia lamŋi te, Iesusa ten ndeac te, ma minmo kam landamŋi neaŋ te, mina manmo utiŋa kac ŋgoreaca tɨknandet. ");
INSERT INTO gai_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ri, Pasowana Rana rai parmbaiapa mbut kabe niŋgikca maeacreke. Ri, Iesusa Betani auŋa mac taŋgatna. Na Betani auŋa anna Lasarusna auŋ, na an ramootmo Iesusa muk ndiŋa moa ŋgeprinan. ");
INSERT INTO gai_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Na mina Iesusap mbibiracna amtiamna amna reacmo anna morinan. Ri, Mata ma amna reacmo amta reikta tuoŋgoura rɨŋrena, na Lasarus ma Iesusap ambrina ramtaɨrap mbiraca eacri. ");
INSERT INTO gai_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Karica Maria ma kituknduk aniacna tabaɨra kilo kabena mɨnmo aŋgɨca kɨpca Iesusna ormo ndikrina, na ma ndona paŋanna lakoar puŋga moca magagracat. Ri, an iŋpai laŋa an kac inikmo kocnaia wɨŋga kɨtacrina. ");
INSERT INTO gai_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Na mana iŋa raŋgairena ramoot ianna mana ia Iudas Iskariot, ma iŋmbaia Iesusmo puŋnaŋgepta para tɨknandet, ma gaindopatna, ");
INSERT INTO gai_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Kaina moca an meaca an tabaɨrmo wanaiŋa ruŋkire, aia an tabaɨrmo mbik tɨk te, ramtaɨra 300na silwana kitukndukna mɨn mbuŋa oik te, aia an kitukndukca aŋgɨca meikramtaɨr ndaekpembca neaŋna mɨn?” ");
INSERT INTO gai_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Na Iudasa ma meikramtaɨr ndaekpembta mba lamŋirena, wanaiŋ. Ma kituknduk makɨmrena ramoot. Na ma Iesusna iŋa raŋgairena ramtaɨrta kitukndukca bubuocrena ramoot, na mina manmo kituknduk neaŋ te, ma ndeidmo makɨmrenan. ");
INSERT INTO gai_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Karica Iesusa an kam mbaraca ma gaindoprina, “An meacmo watcari. Ma an tabrirmo ndikrinanna, aku anap eaci taŋca menaca mina aukmo mutocnandet. ");
INSERT INTO gai_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Na meikramtaɨr ndaekpembca mina nenapa memetmbaca eacraŋnandet. Na aku nenapa mba memetmbaca eacitndai.” ");
INSERT INTO gai_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Na Iudanaŋgepta meikramtaɨr wɨt aniaca mina lamŋirena, Iesusa Betani auŋ ndeacrenan, aintik mina man ndambuŋa kɨprina. Na mina man niŋgikca watna mba kɨprina, wanaiŋ. Mina lamŋirina, ŋgaua Iesusa Lasarusmo muk ndiŋa moca ŋgepatnanna, mitoco Lasarusa watna kɨprina. ");
INSERT INTO gai_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ainda moca taup ndamtaɨr paŋainda kamb leaca Lasarus motocmo mo menacna, ");
INSERT INTO gai_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","na an kɨdrɨkca Iudanaŋgep wɨt aniaca Iesusa Lasarusmo moatna reac an mbatca, mina taup ndamtaɨr paŋaindmo tɨkcarica mina Iesusmo marɨpacri. ");
INSERT INTO gai_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ainda moca meikramtaɨr wɨt aniaca Ierusalemma kɨpca punica mina an mbembendeina ra aniaca watna. Na Iesusa Lasarusna kaca ambrina an rana iŋmbai mbuŋa meikramtaɨra aind mbaracrinan, Iesusa maica ma Ierusalem auŋ aniac ndaruna mamoek. ");
INSERT INTO gai_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ainda moca mina ik palmenna raprir aŋgɨca mina taŋga manmo taupca ndauprikina mataŋgat. Na mina kam keca gainda aca aindoprena, “Aia Raraŋ Aetaniacmo toŋtoŋgar koindap. Ma an ramootmo laŋa mo, ma Kacootna i mbuŋa kɨprinan. Na ma Israelna gagrirta ramoot paŋan.” ");
INSERT INTO gai_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ri, Iesusa doŋki ian aŋgɨca an nambatta mbiracatna. Na anna ma Raraŋ Aetaniacna timbigta kapna inik ndeacrena kam tɨpna kirar, ");
INSERT INTO gai_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Ne Saion auŋna meikramtaɨr, ne kai nanambi teac. Ne wat, nena gagrirta ramoot paŋanna makɨpek. Ma doŋki ŋgamma mbiraca makɨpek.” ");
INSERT INTO gai_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Na an reaca larucapeknanna, mana iŋa raŋgairena ramtaɨra an reacna kamna mɨnɨŋa mba lamŋirena. Na iŋmbaia Raraŋ Aetaniaca Iesusmo i aniaca neaŋrinan, mina an kambca Raraŋ Aetaniacna timbigta kap ndeacrina kamma lamŋiatna. Na mina lamŋirina, anna ma Iesus ŋgoinna kamb ndoprina. Na mina iroar mac maaŋgɨat, an reaca meikramtaɨra manmo moatnanna. ");
INSERT INTO gai_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Na an mɨnna Lasarusa menacri, mina manmo mukca tɨkca eacrinanna, meikramtaɨr wɨt aniaca Iesusap eaca mina watrina, ma Lasarusmo aca moa mac ŋgeprinan. Na mandeaca an meikramtaɨra Iesus moatna reacna kammo wiwitirena. ");
INSERT INTO gai_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ainda moca meikramtaɨra an ma moatna ŋgagatracna kamma waraca mina taupca taŋga manmo ndauprikirina. ");
INSERT INTO gai_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ri, Parisiara an mbatca mina ndorita rɨkca tɨkca aindopri, “Watwa! An reaca aia mo ndoprinanna, ma mandeaca mba laruitndai. Meikramtaɨra muruŋcamiŋa taŋga manmo raŋgairenan.” ");
INSERT INTO gai_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Na an Ierusalemmo Raraŋ Aetaniacna mbembendeina ra aniacna kɨprina meikramtaɨrta rɨkca Girikna ramtaɨr ndeid toco an ndeacrena. ");
INSERT INTO gai_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Na an Girikna ramtaɨra Pilip ndambuŋa taŋri, na man tikca ma Galilinan, na mana auŋa Betsaida. Ri, mina manmo gaindoprina, “Ramoot aniac, aia Iesusa watna toŋgorina.” ");
INSERT INTO gai_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ainda moca ma taŋga Andrumo mambopat. Ri, maniŋa taŋga Iesusmo mambopat. ");
INSERT INTO gai_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Karica Iesusa maniŋna kammo gainda rutica aindopatna, “Ramootna Nuocna ia aniac aŋgɨna kɨdrɨkca kɨpca marambuŋairi. ");
INSERT INTO gai_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Na aku nemo gidik, gidik ŋgoinna aindopnandet, witna loor ianna pitrikca irikca ŋgocrai ŋgocor te, ma ndo kabe niŋgikca eacnandet. Ainda moca u manmo mutoc te, ma ŋgepca amta reik wɨt ŋgernandet. ");
INSERT INTO gai_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Na ramoot ianna ndona eteacna watna toŋtoŋ ŋgoin, te, ma ndona eteacna watta kecarinandet. Na ramoot ianna ndona eteacna watmo gan tiacarpaikmo iŋ neaŋ te, ma ndona an iarwarna eteacna watmo memetmbaca utiŋa eacraŋnandet. ");
INSERT INTO gai_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Na ramoot ianna aukna aiŋa mo te, ma aukmo raŋgainandet. Na an auŋ aku eacrenan, aukna aiŋa morena ramoot toco, ma aukap eacnandet. Na ramootta aukna aiŋa mo te, aukna Aetta manmo i aniaca neaŋnandet.” ");
INSERT INTO gai_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Karica Iesusa gaind mac mbopatna, “Mandeaca aukna nikinik iroa makuk ŋgoin, na aukna iroara tamtam malamŋireke. Na aku kai ndopit? Co aku gaindopit ki, ‘Ate u aukmo mandeaca an reac laruna moeknanmo, u mo kecari?’ Wanaiŋ. Aku ainda mba mbopitndai. An makukna kɨdrɨkca ma aukmo larunandet. Na anna mɨnɨŋna moca aku kɨprina. ");
INSERT INTO gai_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Aintik Aetta u ndona imo aniaca morinan.” Ri, Iesusa mbopca maica tamuŋna auŋna kam ianna gaindoprina, “Aku ndona imo aniaca morinan, na aku mac monandet.” ");
INSERT INTO gai_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ainda moca an meikramtaɨra rambuŋa wɨtɨkca eacrenanna, mina an kammo waracrinan, na mina gaindopatna, “Anna riacna mɨtmɨt ki?” Na ndeida gaindopatna, “Mbaiŋna aiŋa morena ŋeroŋ ianna manap mboprenan.” ");
INSERT INTO gai_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ri, Iesusa mina kambmo gainda rutica aindopatna, “An kambca ne mandeaca waracrinanna, ma aukmo mba otacitndai, wanaiŋ. Ma nenmo otacnandet. ");
INSERT INTO gai_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Na mandeaca Raraŋ Aetaniaca gan tiacarpaikna meikramtaɨrta tɨpemb kirarirmo ritri waparaca monandet. Na mandeaca ma gan tiacarpaikna bubuocrena ramoot paŋanmo ma mo kecarinandet. ");
INSERT INTO gai_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Na mandeaca aku gan tiacarpaikca eacrena, na iŋmbaia mina aukmo aŋgɨca ik nakerac te, an mɨnna aku meikramtaɨrmo kocnaia wɨŋa mina auk ndambuŋ nakɨpnandet.” ");
INSERT INTO gai_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Na Iesusa an kam ndoprinanna, ma ndona memenacna tɨpna kirarna kam ndopca larurina. ");
INSERT INTO gai_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ri, meikramtaɨra mina mana kammo gainda rutirina, “Aia Tɨp Wandɨkna kamma gainda waracrinan, an mɨnna Raraŋ Aetaniaca babuca mbagɨrica kɨpca aimo mac nda aŋgɨna ramootta kɨp te, ma iarwara eacraŋnandet. Na tida moca u aindoprina, ‘Mina Ramootna Nuocmo aŋgɨca ik nakeracnandet’? Na an Ramootna Nuoca ma mandai ŋgoin?” ");
INSERT INTO gai_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Karica Iesusa minmo aindopatna, “Tekemmotemma memetaca nenap eacnandet. Na mandeaca ne memetacap eacrenan, aintik ne memetac mbuŋa taŋraŋ, moca neaupa nenmo wɨŋ kɨtac nari. Na ramootta neaupa taŋrenan, ma mba lamŋirena, ma tenna taŋrena. ");
INSERT INTO gai_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Na mandeaca memetaca nenap maeacreke, aintik ne memetacmo rɨpac te, ne memetacna mombonik tarunandet.” Ainda moca Iesusa minap mbopca maica ma min tɨkcarica ma minmo iŋgoroca taŋrina. ");
INSERT INTO gai_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Na mina man morina ŋgagatrac wɨt aniaca watca mina manmo mba rɨpacatke. ");
INSERT INTO gai_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ainda moca ramma morina ramoot Aisaiana kambca gidik ŋgoin malaruat. Na ma gaindopatna, “Kacoot, mandaia aina kambca rɨpacit? Na Kacootta mandeaca moatna ainta gargar aniacna aiŋa mandaia watrina?” ");
INSERT INTO gai_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Na mina Iesusmo mba rɨpacitndai. Na mana mɨnɨŋa Aisaia ma kabena kamma tirca maeacreke. Na ma gaindoprina, ");
INSERT INTO gai_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Raraŋ Aetaniaca mina lamnikca moca mina mba wat rapacit, na mina iroarmo moa mboracri, moca mina lamnikca reac ianna wat rapac nari, na mina iroar inkara kambta mɨnɨŋa lamŋi nari, te, mina nikinik iroar ŋgetrikica auk ndambuŋa kɨpca aku minmo moi laiŋga monandet.” ");
INSERT INTO gai_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Na Aisaia ma Iesusna gargarapa i aniaca watca ma Iesusmo an kam ndopatna. ");
INSERT INTO gai_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Na anna gidik, ramtaɨr paŋaind wɨtta Iesusmo rɨpacatnanna. Na mina Parisiarta nanambica mina ndorita rɨtɨpaikca raekca mba wandacri. Na mina nanambirinanna, moca Parisiara minmo wandɨk tɨkca mina Iudananta mimitpac aŋgɨrena kacmo mba mbendeitndai. ");
INSERT INTO gai_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Na an ramtaɨr paŋainda mina toŋgorinanna, meikramtaɨra mina iremb anikmo aŋgɨa ŋgepraŋna. Na mina toŋgorinanna Raraŋ Aetaniaca mina iremb anikmo kai aŋgɨr ŋgepraŋ teac. ");
INSERT INTO gai_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Na Iesusa kam aniac keca gainda wiwitica mbopatna, “Ramootta aukmo rɨpacrenanna, ma auk niŋgikca mba rɨpacrena, ma aukmo mbagɨrica kɨprina Aet motocmo ma rɨpacrina. ");
INSERT INTO gai_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Na ramootta aukmo watri, ma aukmo mbagɨrica kɨprina Aet motocmo ma watrinan. ");
INSERT INTO gai_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Na aku gan tiacarpaikmo memetac nakirar toco kɨprina, te, meikramtaɨra muruŋa aukmo rɨpacrenan, mina neaupa mba eacitndai. ");
INSERT INTO gai_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Na ramoot ianna aukna kambca waraca ma raŋgai ŋgocor te, aku manmo ritri waparaca mba moit. Na aku kɨprinanna, aku gan tiacarpaikna meikramtaɨrta ritri waparacna mona mba kɨprina. Wanaiŋ. Aku min mac nda aŋgɨ nakɨprina. ");
INSERT INTO gai_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Na ramootta aukmo iŋ neaŋga aukna kambmo mba aŋgɨrenan, man mona ritri waparacna ramootap. Na an kambca aku wiwitirinanna, anna ndo an ramootna ritri waparaca moca ma ŋgocrainandet. ");
INSERT INTO gai_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Na aku an kambmo ndona iro mbuŋa mba moapeke. Wanaiŋ. Aetta ndo aukmo mbagɨrica aku kɨprinanna, ma ndo aukmo gagraca an kambmo muruŋa mbop larunan, na aku anna monandet, na aku anna wiwitinandet. ");
INSERT INTO gai_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Na aku lamŋirena, Aetna kambca ma iarwarna eteacna watmo memetmbaca laŋa moca larurenan. Ainda moca kambca aku muruŋa morenanna, anna Aetta aukmo mboprina kirara aku mboprena.” ");
INSERT INTO gai_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Na Pasowana Rana amta reik ambrena ra laru ŋgocor ndeacri, Iesusa ma lamŋiatna, ma gan tiacarpaik tɨkcarica Aet ndambuŋa taŋna kɨdrɨkca kɨpca marambuŋairi. Na ma ndona meikramtaɨra gan tiacarpaik ndeacrenanmo mamatŋi ŋgoin, na an mamatŋina kirar kabea ma minmo matŋia taŋga ma menacrina. ");
INSERT INTO gai_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Karica wigwaca ŋgoinna mina amba eacri. Na Iudas, ma Saimon Iskariotna nuoc, manmo Paparuna Ramootta mana nikinik iromo iro ŋgoreaca tɨkrina. Te, ma Iesusmo puŋnaŋgepta para tɨknandet. ");
INSERT INTO gai_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ri, Iesusa ma lamŋirina, Aetta manmo reikmo muruŋcamiŋa mana para tɨkrinan. Na ma gaind toc, toco ma lamŋirina, Raraŋ Aetaniaca manmo mbagɨrica ma kɨprina, na ma man ndambuŋa mac taŋnandet. ");
INSERT INTO gai_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ainda moca Iesusa amta reik tɨkcarica ma ŋgepca ndona tik ŋgapaoc rocotta pitukca, ma tik mumurina reac aŋgɨca ndona rɨkca leacrinan. ");
INSERT INTO gai_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Na ma pukmo tuoŋ aniac ianna ruŋkica, ma ŋgepca ndona iŋa raŋgairena ramtaɨrta ourmo tukica ma ndona rɨkca leaca eacrina tik mumurimo aŋgɨca an mbuŋa mamuriat. ");
INSERT INTO gai_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ri, ma Saimon Pita ndambuŋa kɨpatke. Ma manmo gainda digiatna, “Kacoot, u aukna orniŋa tukina moek ki?” ");
INSERT INTO gai_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Na Iesusa mana kammo gainda rutica aindopatna, “Na reaca aku mandeaca moeknanna, u mba garacrena. Iŋmbai te, u garacnandet.” ");
INSERT INTO gai_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ri, Pita manmo gaindoprina, “U aukna orniŋmo kai tuki teac, kari ŋgoin ndacari.” Na Iesusa mana kammo gainda rutirinan, “Aku una orniŋmo tuki ŋgocor te, u aukapa mba eacitndai.” ");
INSERT INTO gai_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Na Pita manmo gaindopatna, “Kacoot aintan ecte, u aukna orniŋ niŋgikca kai tuki teac, u aukna parapa paŋan toco tuki.” ");
INSERT INTO gai_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ainda moca Iesusa manmo aindopatna, “Ramootta rurenanna, ma mba mac ruitndai. Ma orniŋ niŋgik tuki te, ma kocnaia rat ndarunandet. Na ne rat ndarurinan. Na aku nenmo muruŋa mba mboprinan.” ");
INSERT INTO gai_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Na Iesusa an kam ndoprinanna, ma lamŋirina, an ramootta manmo puŋnaŋgepta para tɨkna morena. Aintik ma aindoprina, “Ne muruŋcamiŋa ratta mba eacrena.” ");
INSERT INTO gai_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Karica ma mina oura tukica maica ma ndona tik ŋgapaoc rocotta tɨkca ma taŋga mac mbiracatna. Ri, ma minmo gainda digirina, “Na an reacna mɨnɨŋa aku nenmo morinanna ne lamŋire ki? ");
INSERT INTO gai_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Na ne aukmo Ririptiapa Kacoot ŋgacrena. Na anna laŋ, ne aind ŋgacrenan. Aku Ririptiapa Kacoot. ");
INSERT INTO gai_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Na aku nena Kacootapa Riripti, aku nena ourmo tukirinan, na ne toco an kirar kabea aku morinanna, ne aina wiwitna meikramtaɨrta ourmo tuki. ");
INSERT INTO gai_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Na mandeaca aku nenmo tɨp kirar damma wandacrina, na ne toco an tɨp kirar kabea, aku nenmo morenanna, ne toco ndorita kabe, kabemo ainda mo. ");
INSERT INTO gai_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Na aku nemo gidik, gidik ŋgoinna aindopnandet, mbaiŋa morena ramootta ma ndona kacootmo mba kunitndait. Na ramootta aiŋ ianna taŋ te, ma an ramootta manmo mbagɨrica taŋrina ramootmo mba kunda tamuŋmbaia eacitndait. ");
INSERT INTO gai_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Na mandeaca ne an tɨpna kirara aku morinanna, ne mana mɨnɨŋa garaca lamŋirinan, na ne matau ŋgoinna raŋgai te, ne toŋgonandet. ");
INSERT INTO gai_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Na aku nenmo muruŋa mba mboprina. Aku nenmo larapacrena ramtaɨr auknan, aku lamŋirenan. Na Raraŋ Aetaniacna timbigta kap ndeacrena kambca, aku lamŋirenanna, ma gidikca larunandet. Na an kambca ma gaindoprina, ‘Ramootta aukap tapac ambrenanna, ma aukmo mo ŋgocrainandet.’ ");
INSERT INTO gai_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Na an reaca ma mba larureke, na mandeaca aku nenmo an kambca mboprinan. Ainda moca ma iŋmbaia laru te, ne gainda rɨpacna, Aku Ndo, Aku Aind Ndeacraŋnandet. ");
INSERT INTO gai_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Na aku nemo gidik, gidik ŋgoinna aindopnande, ramootta aku mbagɨrica taŋrina aiŋna ramootmo aŋgɨ te, na mamo matau mo te, an ramootta ma aukmo aŋgɨca aukmo matau morinan. Na ramootta aukmo aŋgɨ te, ma Raraŋ Aetaniacmo aŋgɨrinan, ma ndo aukmo mbagɨrica aku kɨprinan.” ");
INSERT INTO gai_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ainda moca Iesusa an kam ndopca maica, mana nikinik iroa makuk ŋgoin ndarurina. Na ma kammo gainda wiwitirina, “Aku nemo gidik, gidik ŋgoinna aindopnandet. Nena ianna aukmo puŋnaŋgepta para tɨknandet.” ");
INSERT INTO gai_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Na ma aindopatke, mana iŋa raŋgairena ramtaɨra ndorimo mawattat. Na mina mba lamŋiri, ma mandaina ndoprina. ");
INSERT INTO gai_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ri, an mana iŋa raŋgairena ramoot, ma manmo matŋirenanna, ma mana kɨtɨmma eacrenan. ");
INSERT INTO gai_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Na Saimon Pita, ma manmo paŋan mbuŋa digia aindoprina, “U Iesusmo digi, ma mandaina kam ndoprena.” ");
INSERT INTO gai_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ri, an mana matŋirena iŋa raŋgairena ramootta ma ndona paŋanmo Iesus ndambuŋa tɨkca ma manmo laŋanna gainda digirina, “Kacoot u mandaina kam ndoprina?” ");
INSERT INTO gai_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Karica Iesusa mana kammo gainda rutirina, “Aku gan am tɨpmo aŋgɨca teramma tɨkca ramoot ianna neaŋ te, anna ande an ramoot ŋgoinna aku mboprenan.” Ainda moca ma am tɨpmo aŋgɨca teramma tɨkca ma Saimon Iskariotna nuoc Iudas maneaŋgat. ");
INSERT INTO gai_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ri, Iudasa an amna reacmo aŋgɨatke, Ramoot Mbɨkca mana nikinik iro mambukat. Ainda moca Iesusa manmo gaindopatna, “Na an reaca u mo ndoprenanna, u anmo tawi mo.” ");
INSERT INTO gai_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Na an ramtaɨra muruŋa mbibiracna taupca mbiraca eacrenanna, an kamma Iesusa Iudasmo mboprenanna waraca mina an kamna mɨnɨŋa mba garacrinan. ");
INSERT INTO gai_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Na Iudas ma mina kitukndukca bubuocrena ramoot, na mina ndeida gaind ndamŋirina, Iesusa manmo mbopca ma taŋca an mbembendeina ra aniacna amna reac ŋgoiknan, co ma taŋca an meikramtaɨr ndaekpembmo reik neaŋnan. ");
INSERT INTO gai_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ainda moca Iudasa an am tɨpca aŋgɨri, ma tawi ŋgoinna raekca laruca mataŋgat. Na an kɨdrɨkca mouŋ malaruri. ");
INSERT INTO gai_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Karica Iudasa raekca taŋgatke, Iesusa gaindopatna, “Mandeaca Ramootna Nuoca ma i aniac aŋgɨrina. Na Raraŋ Aetaniaca Ramootna Nuoc mbuŋa i aniac aŋgɨrina. ");
INSERT INTO gai_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Na an mɨnna Raraŋ Aetaniaca man mbuŋa i aniaca aŋgɨeknanna, ma ndo Ramootna Nuocmo i aniac neaŋnandet. Na ma anmo tawi ŋgoinna monandet. ");
INSERT INTO gai_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Na aukna mombonik, kɨdrɨk tekemmotemma aku nenap eacnandet. Na ne aukna moca orenande. Na aku Iudanaŋgepmo mboprina, na an kam kirar kabea aku nen motocmo mambopek. Na an auŋa aku taŋgeknanna, ne anna taŋna towanaiŋ. ");
INSERT INTO gai_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Aintik mandeaca aku nenmo Tɨp Wandɨk ŋgam maneaŋgek, na ma gaind, ne kabe, kabea, kabena meikramtaɨrmo matau matŋi. Na aku nenmo mataua matŋirina, na an tɨp kirar kabea ne kabe, kabea, kabena meikramtaɨr motocmo, ainda matau matŋi. ");
INSERT INTO gai_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Na ne kabe, kabea aukna wiwitna meikramtaɨr motocmo, mataua matŋi te, anna meikramtaɨrmo muruŋa wandacnandet, ne aukna iŋa raŋgairena ramtaɨr.” ");
INSERT INTO gai_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ri, Saimon Pita ma Iesusmo gainda digirinan, “Kacoot u tenna taŋit?” Na Iesusa mana kammo gainda rutirina, “Na auŋa aku taŋgeknanna, u mandeaca u aukmo raŋgaica anna taŋna mɨnna wanaiŋ. Na iŋmbai te, u aukmo raŋgaica kɨpnandet.” ");
INSERT INTO gai_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Karica Pita manmo digiatna, “Kacoot tida moca aku unmo mandeaca raŋgaina mɨnna wanaiŋ? Na aku ndona eteacna wat auknanna, un ŋgotacna mo te, aku kecarinandet.” ");
INSERT INTO gai_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ainda moca Iesusa mana kammo gainda rutirinan, “U ndomo ndona eteacna wat kecaria aukmo otacna ndopre ki, a? Aku unmo gidik, gidik ŋgoinna aindopnandet, kackura ap ŋgocor ndeac te, u kɨdrɨk mbonkaca aindopnandet, u aukmo mba lamŋirena.” ");
INSERT INTO gai_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Karica Iesusa gaind mac mboprina, “Ne iroar inkara kai tamtam ndamŋica kadmai teac. Ne Raraŋ Aetaniacmo rɨpac. Na ne auk motocmo rɨpac. ");
INSERT INTO gai_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Na aukna Aetna kac inikca diabar wɨtta eacrenan, na aku taŋca nena taupembca kocronandet. Na ainda wanaiŋ te, aku nenmo an kamma ainda mba mbopitndai. ");
INSERT INTO gai_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Na aku nena taupemb kocrona taŋ te, aku nda kɨpca nenmo aŋgɨca ne taŋca aukap eacnandet. Na an taupca aku eacrenan, ne toco anna aukap eacnandet. ");
INSERT INTO gai_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Na aku taŋrena auŋa ne an taupca malamŋireke.” ");
INSERT INTO gai_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ri, Tomasa manmo gaindopatna, “Kacoot u tenna taŋrena auŋa, anna aia mba lamŋireke. Na tida tɨkca aia an taupca lamŋi garacit?” ");
INSERT INTO gai_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ainda moca Iesusa manmo aindopatna, “Aku ndo, aku taup, na aku kam gidikna mɨnɨŋ, na iarwarna eteacna watna mɨnɨŋ. Na ramoot ianna Aet ndambuŋmo kabena taup ian mbuŋa taŋna toawanaiŋ. Wanaiŋ ŋgoin. Auk niŋgik. ");
INSERT INTO gai_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Na ne aukmo lamŋi te, mandeaca ne aukna Aet motocmo, ne lamŋinandet. Na mandeaca ne manmo malamŋiek. Na ne manmo mawatri.” ");
INSERT INTO gai_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Karica Pilipa Iesusmo gaindoprina, “Kacoot u aimo Aetta wandac te, anna ndo aina iroarapa landamŋiara moi mɨnna tɨknandet.” ");
INSERT INTO gai_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ri, Iesusa manmo aindopatna, “Pilip, kɨdrɨk rocotta aku nenap eacrinan, na u aukmo mba lamŋire ki, a? Na ramootta aukmo wat te, ma Aetmo mawatri. Na kaina moca u gaindoprina, ‘U aimo Aetta wandacna’? ");
INSERT INTO gai_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Na u ainda mba rɨpacri ki, Aetta aukap eacrenan, na aku Aetap eacrenan? Na kamma aku nenmo neaŋrenanna, anna aku ndona nikinik iro mbuŋa mba morenanna. Wanaiŋ. Aetta aukap eacrenan, na ma ndo, ndona aiŋira morena. ");
INSERT INTO gai_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Na ne an kammo rɨpac. Aku Aet ndambuŋ ndeacrenan, na Aetta ma auk ndambuŋ ndeacrena. Na wanaiŋ ecte, ne auk morina aiŋirmo lamŋinandet, te, anna ndo nena rɨtɨpaikca moi ŋgepnandet. ");
INSERT INTO gai_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“Na aku nemo gidik, gidik ŋgoinna aindopnandet, na ramootta aukmo rɨpac te, ma toco ainta aiŋira aku morenanna, ma monandet. Na ma aiŋir anikca monandet, na an aiŋira aku morinanmo ma mo kunnande, na anna aku Aet ndambuŋa taŋrinan. ");
INSERT INTO gai_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Na reikca ne muruŋa aukna i mbuŋa digieknanna, anna aku monandet. Ainda moca Aetta ma ndona Nuoc mbuŋa ma i aniac aŋgɨnandet. ");
INSERT INTO gai_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Na reikca ne muruŋa aukna i mbuŋa digi te, anna aku monandet.” ");
INSERT INTO gai_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Karica Iesusa gaind mac mbopatna, “Ne aukmo matau matŋi te, ne aukna kambmo matau raŋgairaŋnandet. ");
INSERT INTO gai_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Na aku ndona Aetta digica ma nenmo kabena iro damna Opotac neaŋca, anna ndo nenmo moi gagranandet. Te, ma nenap iarwara eacraŋnandet. ");
INSERT INTO gai_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Na an Opotaca ma kam gidikna Ŋeroŋ. Na gan tiacarpaikna meikramtaɨra mina manmo mba watitndai, na mina mba aŋgɨitndai. Na mina manmo mba lamŋiitndait. Na nen tikca ne manmo lamŋirena, na ma nenap eacrenan, na ma nena iroar inkarmo eacnandet. ");
INSERT INTO gai_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Na aku nenmo mombonik ndaekpembca mba tɨkcariitndai, na nenmo mba wattacarica ne wanaiŋa eacitndait. Wanaiŋ. Aku nen ndambuŋa kɨpnandet. ");
INSERT INTO gai_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Na kɨdrɨk tekemmotemma gan tiacarpaikna meikramtaɨra aukmo mba mac watitndai. Na nen tikca ne aukmo watnandet. Aku iarwarna eteacna watap eacrenan, na ne toco iarwarna eteacna watap eacnandet. ");
INSERT INTO gai_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Na an ra kɨp te, ne lamŋinande, aku ndona Aet ndambuŋa eacnandet, na ne auk ndambuŋa eacrenan, na aku nen ndambuŋa eacrena. ");
INSERT INTO gai_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Na ramootta aukna tɨpemb wandikmo aŋgɨca matau raŋgai te, an ramootta ma aukmo mamatŋi ŋgoin. Na ramootta aukmo matŋi te, aukna Aetta manmo matŋinandet. Na auk toco manmo matŋinandet, na aku manmo ndomo wandacnandet.” ");
INSERT INTO gai_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Na Iesusa aindopri, Iudas Iskariotna i kabena ramoot, Iudasa ma Iesusmo gainda digirina, “Kacoot tida moca u aimo ndo wandacit, na u gan tiacarpaikna meikramtaɨrmo u ndomo mba wandacri?” ");
INSERT INTO gai_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Karica Iesusa mana kammo gainda rutirina, “Ramootta aukmo matau matŋiraŋ te, ma aukna kambca matau raŋgairaŋnandet. Na aukna Aetta an ramootmo matŋinandet. Na aukapa Raraŋ Aetaniaca man ndambuŋ nakɨpnandet, na manap memetmbaca eacraŋnandet. ");
INSERT INTO gai_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Na ramootta aukmo matŋi ŋgocor ŋgoinna, ma aukna kammo mba gɨwaci raŋgaiitndai. Na an kambca ne waracrenanna, anna aukna kambca wanaiŋ. Anna Aetna kamb, na ma aukmo mbagɨrica aku kɨprinan. ");
INSERT INTO gai_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Na an mɨnna aku nenap eacri, aku nenmo an reikta kamb toprina. ");
INSERT INTO gai_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Na Ŋeroŋ Rat, ma nenmo moi gagrana Opotac gidik. Na aukna i mbuŋa Aetta manmo mbagɨrica ma kɨpnandet. Na ma nenmo reikca muruŋa riptinandet. Te, ma nena iroara mo ŋgepca ne an aku nenmo neaŋrina kambmo muruŋcamiŋa lamŋi rapacnandet. ");
INSERT INTO gai_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Na aku nenmo tɨkcarina moca nenmo nikinik iro wetwetta maneaŋgek, na ma nenap eacraŋnandet. Na aukna nikinik iro wetwetta aku nenmo neaŋrena, anna gan tiacarpaikna meikramtaɨra neaŋrena kirara wanaiŋ. Aintik ne nikinik iroara kai makuku teac, na tamtamma kai lamŋi teac, na kai nanambi teac. ");
INSERT INTO gai_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Na an kambca aku nenmo neaŋrinanna, ne mawaracri, ‘Na aku nenmo tɨkcarica taŋnandet. Na aku nenmo nda kɨpnandet.’ Na ne aukmo gidikca matŋi te, anna ndo nenmo moi toŋtoŋgarap eacnandet. Na anna aku Aet ndambuŋa taŋrinan, na ma out ŋgoin, na ma aukmo tamuŋmbai. ");
INSERT INTO gai_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Na an reaca laru ŋgocor ndeacri, aku nenmo mandeaca mbopca malarurek. Na iŋmbaia ma laru te, ne rɨpacnandet. ");
INSERT INTO gai_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“Na aku nenmo kamb wɨt anikca mba mbopit, gan tiacarpaikca bubuocrena ramoot paŋanna makɨpek. Na ma aukmo reac ianna mona gargar ŋgocor, ");
INSERT INTO gai_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","na aku toŋgorinanna gan tiacarpaikna meikramtaɨra lamŋina, aku Aetmo mamatŋi ŋgoin, na Aetta aukmo mboprena reikca aku muruŋcamiŋa morena. Ainda moca ne ŋgepca aia taŋna.” ");
INSERT INTO gai_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Karica Iesusa gaind mac mbopatna, “Aku ndo aku wain ŋgatɨk gidik ŋgoin. Na aukna Aetta ma an wain warɨŋna aet. ");
INSERT INTO gai_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Na aukna ŋaikca er ŋgocor te, anna Aetta mo kecarirenan. Na an ŋaikca errenanna, Aetta ma minmo mataurenan, na minmo moa laŋa mo te, mina amta reik wɨtta matau ernandet. ");
INSERT INTO gai_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Na ne rat ndarurina. Na an kamma aku nenmo neaŋgeknanna ma nenmo moa ratrina. ");
INSERT INTO gai_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Na ne aukap mɨk te, aku nenap mɨknandet. Na wainna ŋaikca wainna ŋgatɨkca mɨk ŋgocor te, mina mba eritndai. Na anna tɨpna kirar kabea, ne aukmo mɨk ŋgocor te, ne toco amta reikca mba eritndai. ");
INSERT INTO gai_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Na aku ndo wain ŋgatɨk, na ne ŋgatɨk wainna ŋaik. Na ramootta aukmo mɨkca, na aku mana mɨk te, ma amta reik wɨt ŋgernandet. Na ne aukmo tɨkcari te, ne reac ianna mba moitndai. ");
INSERT INTO gai_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Na ramoot ianna aukmo mɨk ŋgocor te, mina manmo ik ŋaca mo kecarirena kirara mina manmo ainda monandet, na ma gurunandet. Na ainta ŋgatɨk ŋaikca mina aŋgɨ punica taca ke mbukca wɨrrenan. ");
INSERT INTO gai_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","“Na ne aukmo mɨk te, na aukna kambca nenapa eacrenan, ne ndorita toŋtoŋgarta mɨnna reikta digi te, an reikca ne mboprina kirar ndarunandet. ");
INSERT INTO gai_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Na ne amta reik wɨt ŋgera aukna iŋa raŋgairena ramtaɨr ndeacnande. Na an tɨpna kirar mbuŋa aukna Aetta ma i aniac aŋgɨnandet. ");
INSERT INTO gai_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Na Aetta ma aukmo mamatŋirenan, na an tɨpna kirar kabea aku nenmo matŋirena. Na memetmbaca ne an aukna mamatŋina inik ndeacraŋ. ");
INSERT INTO gai_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Na ne aukna tɨpemb wandikapa aukna kambca matau raŋgairaŋ te, ne aukna mamatŋina inik ndeacnandet. Na an tɨpna kirara aku ndona Aetna tɨpembapa kambca mataua raŋgairenan, na aku mana toŋtoŋna inik ndeacrenan. ");
INSERT INTO gai_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Na an reikca aku nenmo mboprinanna. Na aku toŋgorinanna, aukna toŋtoŋa nenap eaca, na an toŋtoŋa ma nena nikinik iroarmo moi mɨn koinda tɨknande. ");
INSERT INTO gai_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Na aukna tɨp wandɨkca ma gaind, ne kabe, kabea ne kabena meikramtaɨrmo matau matŋi, na an tɨpna kirara aku nenmo matŋirenan. ");
INSERT INTO gai_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Na ramoot ianna ma ndona aikndamtaɨrmo mamatŋi ŋgoin, na ma ndona eteacna wat ndonanmo kecarica min ŋgotac te, na an kabena meikramtaɨrmo matau matŋirena tɨpna kirara, ma kabena meikramtaɨra matŋina tɨpna kirarmo kunda tamuŋmbai. ");
INSERT INTO gai_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Na auk mbopatnanna, ne ainda mo te, ne aukna aikndamtaɨra eacnandet. ");
INSERT INTO gai_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Na mbaiŋna ramootta ma ndona kacootna morena reikca ma mba lamŋirenan. Ainda moca aku nenmo gainda mba ŋgacri, ‘Ne mbaiŋna ramtaɨr.’ Wanaiŋ. Na kambca aku Aet ndambuŋa muruŋa waracrinanna, anna aku nenmo mboprena. Aintik aku nenmo, ‘Aikndamtaɨr ŋgacrena.’ ");
INSERT INTO gai_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","“Na ne aukmo mba larapaca aku nenap eacrenan. Wanaiŋ. Aku nenmo larapaca ne aukna wiwit ndeacrenan. Na aku nenmo aiŋ neaŋrinan, ne taŋga an aiŋa mo gagra, na mana gagamma ma larunandet, te, ma mba ŋgocraiitndai. Ainda moca ne Aetmo aukna i mbuŋa mbendeica reac ianna digi te, ma nenmo neaŋnandet. ");
INSERT INTO gai_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Na aku nenmo gagraca mambopek. Ne kabe, kabea kabena meikramtaɨrmo matŋiraŋ.” ");
INSERT INTO gai_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Karica Iesusa gaind mac mbopatna, “Na gan tiacarpaikna meikramtaɨra nenmo puŋnaŋgepca mo te, ne kai iroar ndarekrekke teac, outta mina auk motocmo puŋndamootta morina. ");
INSERT INTO gai_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Na ne gan tiacarpaikna meikramtaɨrta kirar ndeac te, anna meikramtaɨra mina nenmo gainda matŋinandet, ne mina wiwitnan. Na ne gan tiacarpaikna ramtaɨra wanaiŋ. Na aku nenmo larapacrinan, na ne gan tiacarpaikna tɨpemb kirarira tɨkcarinandet. Aintik gan tiacarpaikna meikramtaɨra nenmo puŋnaŋgepca morena. ");
INSERT INTO gai_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ainda moca ne an kambca aku nenmo mboprinanna, ne matau ŋgoin ndamŋi. Mbaiŋna aiŋa morena ramootta ma ndona kacootmo mba kunitndait. Na mina aukmo ŋgoreaca mo te, mina nen motocmo mo ŋgocrainandet. Na mina aukna kambmo raŋgai te, mina nena kamb motocmo raŋgainandet. ");
INSERT INTO gai_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Na aukmo mbagɨrica kɨprina Aetmo, mina mba lamŋirenan. Ainda moca mina an tɨpemb kirarir ŋgorikmo muruŋa nenmo monandet. Na mina lamŋirena ne aukna wiwitnan. ");
INSERT INTO gai_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","“Na aku kɨpca minmo kambca neaŋ ŋgocor, te, mina tɨpemb ŋgorikta makukara mba mbukitndai. Na mandeaca mina ndorita tɨp ŋgoreacna makukara iŋgorocna taupemb kocor. ");
INSERT INTO gai_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Na ramootta aukmo puŋndamootta mo te, ma aukna Aet motocmo ma puŋndamootta monande. ");
INSERT INTO gai_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Na an aiŋir gargarara ramoot ianna mina rɨkmo ŋgaua mo ŋgocornanna, aku an aiŋir anikca mo ŋgocor te, na mina anna wat te, mina ndorita tɨpemb ŋgorikta makukara mba aŋgɨitndait. Na mina aukna aiŋira muruŋa watrinan, na mina aukmo puŋndamootta morina, na aukna Aet motocmo, ainda morina. ");
INSERT INTO gai_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Na an tɨpna kirara mina moatnanna anna ma laruca mina Tɨp Wandɨkna kam ianna moca mɨnna tɨkna. Na an kamma ma gaind, ‘Meikramtaɨra aukmo wanaiŋa puŋndamootta morena.’ ");
INSERT INTO gai_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Na nenmo opotacna Ŋeroŋa ma Aetap eacrenan, na aku manmo mbagɨrica nen ndambuŋa kɨpnandet. Na an Ŋeroŋa ma kam gidik ndoprena, na ma Aetap eacrenan, na ma kɨpnandet. Na ma kɨp te, ma aukna aiŋapa tɨpna kirarmo mbopi laru garacnandet. ");
INSERT INTO gai_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ainda moca ne toco aukna kambmo wiwiti mbop, na anna ne aukap eaca aku an mɨnna aiŋa moa ŋgeprinan, na ne aukap eaca kɨpca mandeacna mɨn. ");
INSERT INTO gai_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Na aku nena rɨtɨpaikmo tɨkcarina mba toŋgorinan, ainda moca aku nenmo an kamb toprina. ");
INSERT INTO gai_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Na mina nenmo Iudananta mimitpac aŋgɨrena kaikmo wandɨk tɨknandet. Na iŋmbaina mɨnna mina nenmo mo menacnandet, na mina gaind ndamŋinandet, mina Raraŋ Aetaniacna aiŋir laiŋga morina. ");
INSERT INTO gai_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ainda moca mina Aetmo mba lamŋirenanna, na mina auk motocmo mba lamŋirenan, ainda moca mina an tɨpembta kirarira morena. ");
INSERT INTO gai_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ainda moca mandeaca aku nenmo mboprinan, an reikca larunande. Na iŋmbaina mɨnna an meikramtaɨra nenmo an tɨpemb kirarira mo te, ne gan kam tɨpca aku nenmo neaŋrinanna ndamŋina.” Karica Iesusa gaind mac mbopatna, “Ŋgaua aku nenap eacrinan, ainda moca aku nenmo an reikta kambca mba mboprinan. ");
INSERT INTO gai_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Na mandeaca aku Aet ndambuŋa taŋnandet, ma ndo aukmo mbagɨrica aku kɨprinan. Aintik nena ianna aukmo mba digiri, ‘U tenna taŋrena?’ ");
INSERT INTO gai_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Na aku nenmo an kamb toprinanna, mandeaca nena iroar inkara makuk ŋgoin. ");
INSERT INTO gai_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ainda moca aku nenmo gidik ŋgoinna aindoprina, aku nenmo tɨkcarica taŋnandet, na anna nenmo otacna. Na aku taŋ ŋgocor te, nenmo mo gagrana Ŋeroŋa ma nenmo mba kɨpitndait. Na aku taŋ te, aku manmo mbagɨrica ma nen ndambuŋa kɨpnandet. ");
INSERT INTO gai_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Na ma kɨpca gan tiacarpaikna meikramtaɨrmo tɨpemb ŋgorikta makukarta mɨnɨŋa moi mina wat rapacna, na tɨp kirar wandoŋna mɨnɨŋmo mo wandoŋainan, na Raraŋ Aetaniacna ritri waparacna mɨnɨŋa moi waekeca mina wat rapacna. ");
INSERT INTO gai_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Na tɨp ŋgoreacna makukna mɨnɨŋa ma gaind, mina aukmo mba rɨpacrenan. ");
INSERT INTO gai_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Na tɨp kirar wandoŋmo, mo wandoŋaina mɨnɨŋa gaind, aku Aet ndambuŋa taŋnandet, na ne aukmo mba mac watitndait. ");
INSERT INTO gai_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Na Raraŋ Aetaniacna ritri waparacna mɨnɨŋa gaind, gan tiacarpaikca bubuocrena ramoot paŋan, Raraŋ Aetaniaca manmo ritri waparaca moatke, ma manmo moa irikrinan. ");
INSERT INTO gai_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Na aku nenmo neaŋna kamb wɨt aniacap eacrenan, na ne mandeaca aŋgɨna mɨnna wanaiŋ. ");
INSERT INTO gai_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Na kam gidikna Ŋeroŋa kɨp te, ma nena iroarmo tiŋara monandet, na ne kam gidikmo muruŋa lamŋinandet. Na ma ndona iro mbuŋa kamma mba mbopitndai. Wanaiŋ. Na kambca ma waracrinanna, ma an niŋgikca wiwitinandet. Te, ma nenmo iŋmbaia lataruna reikta kamb topnandet. ");
INSERT INTO gai_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Na ma aukna kambmo aŋgɨca nenmo wiwitinandet, na an tɨpna kirar mbuŋa aukna i aniacapa gargara mo larunandet. ");
INSERT INTO gai_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Na Aetna reikca muruŋcamiŋa anna auknan. Ainda moca aku aindoprina, ma aukna kamb aŋgɨca nenmo wiwitinandet.” ");
INSERT INTO gai_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Karica Iesusa gaind mac mbopatna, “Kɨdrɨk tekemmotemma ne aukmo mba mac watitndai. Na iŋmbaina kɨdrɨk tekemmotem mbuŋa ne aukmo mac watnandet.” ");
INSERT INTO gai_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ri, mana iŋa raŋgairena ramtaɨra ndorita rɨkmo aindoprina, “An kamma ma aimo mboprinanna, anna kaina mɨnɨŋna kam? Na ma aindoprinan, ‘Kɨdrɨk tekemmotemma ne aukmo mba watitndai, na iŋmbaina kɨdrɨk tekemmotem mbuŋa ne aukmo mac watnandet.’ Na ma gaind mac mboprina, ‘Mana mɨnɨŋa gaind, aku Aet ndambuŋa taŋnandet.’” ");
INSERT INTO gai_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Na mina aindopri, “An ‘kɨdrɨk tekemmotemma.’ Ma mboprenanna, anna kaina reac? Na an kamma ma mboprinanna, aia mana mɨnɨŋa mba lamŋireke.” ");
INSERT INTO gai_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ainda moca Iesusa ma lamŋirinan, mina manmo digina morenan, aintik ma minmo gaindoprina, “Ne auk mboprina kamna mɨnɨŋna moca ne ndorimo anna digirenan ki? Na aku gaindoprina, ‘Kɨdrɨk tekemmotemma ne aukmo mba watitndai. Na iŋmbai ecte, ne aukmo mac watnandet.’ ");
INSERT INTO gai_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Na aku nemo gidik, gidik ŋgoinna aindopnandet, ne nananae aniacapa kakadmai aniaca monandet. Na gan tiacarpaikna meikramtaɨra mina toŋtoŋgarap eacnandet. Na nena iroar inkara makukuraŋnandet. Na nena an nikinik iroarta makukara mina uriraca mina toŋtoŋgar koind tarunandet. ");
INSERT INTO gai_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Na ma gaind, meaca ma mooŋnuoca mɨrna mo te, ma gɨrgɨr aniaca aŋgɨnandet, na ma mɨr te, ma mooŋnuocna mo te, ma toŋtoŋ ŋgoin, na ma an gɨrgɨrnake ma mba lamŋiitndai. ");
INSERT INTO gai_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Na anna kirara ne mandeaca ne makuk aŋgɨca kadmainandet. Na aku nenmo watnandet, na nena iroar inkara toŋtoŋgara larunandet. Na ramoot ianna nena an toŋtoŋgarmo mo kecarina mɨnna wanaiŋ. ");
INSERT INTO gai_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Na an kɨdrɨkca ne aukmo reac ianna mba digiitndai. Na aku nenmo gidik, gidik ŋgoinna aindopnande, na ne Aetmo reac ianna aukna i mbuŋa digi te, ma nenmo neaŋnandet. ");
INSERT INTO gai_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Na ŋgaua ne aukna i mbuŋa reac ianna aŋgɨna mba digiri. Na ne digi te, ne aŋgɨnandet. Na nena iroar inkara toŋtoŋgara mɨn ŋgoinna tɨknandet.” ");
INSERT INTO gai_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Karica Iesusa gaind mac mbopatna, “Aku nenmo an kambmo, kam roor mbuŋa keca mboprinan. Na iŋmbaia aku nenmo an tɨpna kirara mba mac moitndai. Wanaiŋ. Na aku nenmo Aetna kambca raekca wandoŋ ndopnandet. ");
INSERT INTO gai_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Na an mɨnna ne aukna i mbuŋa mbendeinandet. Na aku nenmo ainda mba mboprinan, aku ndo nenmo Aetta mbendeica ma nenmo otacnan. ");
INSERT INTO gai_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Wanaiŋ. Aetta ma ndo nenmo matŋirenan, na anna ne aukmo matŋirinan, na ne aukmo rɨpacatna, aku Raraŋ Aetaniacap eaca kɨprinan. ");
INSERT INTO gai_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Na atua aku Aetap eacrina, ri, aku man tɨkcarica gan tiacarpaikca kɨprina. Na mandeaca aku gan tiacarpaikca tɨkcarica Aet ndambuŋa taŋnandet.” ");
INSERT INTO gai_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ri, mana iŋa raŋgairena ramtaɨra gaindoprina, “Ore! Mandeaca u mbopca malaruri. Na mandeaca u kam roor mbuŋa mba kecapeke. ");
INSERT INTO gai_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Na mandeaca aia malamŋiri, u ramootmo mba digina lambirenan, na u mana opotacmo rutinan. Wanaiŋ. U reikmo u muruŋcamiŋa lamŋirenan. Ainda moca aia gainda rɨpacrinan, u Raraŋ Aetaniacap eacrenan, na u kɨprinan.” ");
INSERT INTO gai_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Karica Iesusa mina kambmo gainda rutirina, “Eee, mandeaca ne rɨpacapek, ki? ");
INSERT INTO gai_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Na ne warac, ra kɨpca marambuŋairi. Na ma larunandet, te, mina nenmo ootca ne ndorita auŋembca kabe, kabea taŋ mainandet. Na ne aukmo tɨkcarica aku ndo kabea eacnandet. Na aku ndo kabea mba eacitndai, wanaiŋ, Aetta ma memetmbaca aukap eacrenan. ");
INSERT INTO gai_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Aintik aku toŋgorinanna, ne aukap mɨkca nikinik iro wetwet ndeac, ainda moca aku nenmo an kam ndoprina. Na an mɨnna ne gan tiacarpaikca eacrenan, ainta makukara nenmo larunandet, na nena nikinik iroara gargar ndeacraŋ. Na gan tiacarpaikna gargara aku moa irikrinan.” ");
INSERT INTO gai_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Karica Iesusa ndona iŋa raŋgairena ramtaɨrmo kambca mbopa maica ma auŋ tamuŋmo watta gaca ma gaindopatna, “Ate, ŋgaŋganŋgɨna mɨnna kɨpca malaruek. Na mandeaca u ndona Nuocmo i aniac neaŋ, te, ma unmo i aniac neaŋnandet. ");
INSERT INTO gai_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Na u manmo i aniaca neaŋrinan. Na u manmo meikramtaɨr muruŋna paŋanna wɨtɨkna larapacrina, te, ma an meikramtaɨra u manmo neaŋrinanmo, ma minmo iarwarna eteacna watta neaŋnandet. ");
INSERT INTO gai_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Na gan iarwarna eteacna watta, ma gaind, meikramtaɨra an iarwarna eteacna wat aŋgɨrenanna, mina unmo lamŋirina, u ndo kabe ŋgoinna Raraŋ Aetaniac gidik. Na u mbagɨrica kɨprina ramoot Iesus Karaismo mina lamŋirena. ");
INSERT INTO gai_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","“Na aku gan tiacarpaikna meikramtaɨrmo una gargarapa i aniacmo wandacrina. Na aiŋa u aukmo mo ndopca neaŋrinanna, aku moa mairina. ");
INSERT INTO gai_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Na Ate, gan tiacarpaikca laru ŋgocor ndeacri, aku unap eacrinan, na aku i aniacap. Na mandeaca aku toŋgorinanna, u aukmo an i aniac mac nda neaŋ, te, aku unap eacnandet. ");
INSERT INTO gai_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Na gan meikramtaɨra u aukmo gan tiacarpaikca tɨkca neaŋrinanmo, aku una imo minmo, wiwitiatna. Ri, mina una kambmo matau ŋgoinna raŋgairina. ");
INSERT INTO gai_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Na mandeaca u aukmo neaŋrina reik muruŋa mina lamŋirena, anna un ndambuŋ ndiŋ nda kɨprena. ");
INSERT INTO gai_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Na an kambca u aukmo neaŋrinanna, aku minmo neaŋrina. Na mina manmo aŋgɨca mina gidikca gainda lamŋirina, atua aku unap eaca kɨprinan. Na mina gainda rɨpacrenan, u ndo aukmo mbagɨrica aku kɨprinan. ");
INSERT INTO gai_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Na aku min ŋgotacna mbendeirena. Na aku gan tiacarpaikna meikramtaɨrmo muruŋa otac nake mba mbendeirenan. Aku mbendeirenanna, aku an meikramtaɨra u aukmo neaŋrinanna moca mbendeirena, na mina una meikramtaɨr. ");
INSERT INTO gai_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Na aukna an meikramtaɨra muruŋcamiŋa anna unan. Na una meikramtaɨrta tumbunna muruŋcamiŋa anna auknan. Na an kɨdrɨkca meikramtaɨra aukna an tumbunna wat te, mina aukmo i aniac neaŋnandet. ");
INSERT INTO gai_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","“Na mandeaca aku un ndambuŋ makɨpek, na aku gan tiacarpaikca mba mac eacitndai. Na mina gan tiacarpaikca eacnandet. Na Ate, u rat ŋgoin, na ianna un toco wanaiŋ. Na u minmo ndona ina gargar mbuŋa bubuocrenan, na an ia u aukmo neaŋrina. Na mina kabea larunandet, an kirara aŋga aind ndeacrinan. ");
INSERT INTO gai_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Na an mɨnna aku minap eacri, aku una ina gargar mbuŋa minmo bubuocrinan, na an ia u aukmo neaŋgatnanna. Na aku an mbuŋa minmo matau ŋgoinna bubuocrenan, na mina ianna mba taprekeitndai. Na taprekena ramoot, ma ndo kabea taprekenandet, te, an una Timbigta Kap ndeacrena kamma ma gidik ŋgoin ndarunandet. ");
INSERT INTO gai_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Aintik mandeaca aku un ndambuŋmo makɨpek. Na aku gan tiacarpaik ndeacrena kɨdrɨk mbuŋ tik, aku an kamb topatna. Te, aukna toŋtoŋa mina nikinik iroarmo mɨnna tɨkca eacraŋnandet. ");
INSERT INTO gai_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","“Na una kambca aku minmo neaŋrinan. Na gan tiacarpaikna meikramtaɨra minmo puŋnaŋgepca morena, na aukna meikramtaɨr, mina gan tiacarpaikna meikramtaɨra wanaiŋ, na an tɨpna kirar toco, auk toco gan tiacarpaiknanna wanaiŋ. ");
INSERT INTO gai_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Na aku minmo gan tiacarpaik tɨkcarina moca unmo mba digirena, wanaiŋ. Aku unmo mbendeirinanna, u minmo bubuocna, te, Ramoot Ŋgoreaca minmo mba mo ŋgocraiitndai. ");
INSERT INTO gai_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Na mina gan tiacarpaikna meikramtaɨra wanaiŋ, na an kirar toco auk toco gan tiacarpaiknanna wanaiŋ. ");
INSERT INTO gai_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Na una kambca gidkar koind, na aku toŋgorenanna, u ndona an kamb gidkarmo, mina nikinik iroarmo aiŋa moraŋ. Te, minmo moca mina una meikramtaɨr koind tarunandet. ");
INSERT INTO gai_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Na ŋgaua u aukmo mbagɨrica aku kɨpca gan tiacarpaikna meikramtaɨrta rɨk ndeacrinan. Aintik an kirar kabea auk toco an meikramtaɨra u aukmo neaŋrinanmo, mbagɨrica mina taŋga gan tiacarpaikna meikramtaɨrta rɨk ndeacnandet. ");
INSERT INTO gai_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Te, minmo otacnan, na aku ndona eteacna watmo kocnaia unmo neaŋrinan, te, mina una meikramtaɨr gidkar koind tarunandet. ");
INSERT INTO gai_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Na aku an meikramtaɨr tiŋgikmo memetmbaca otacna mba mbendeirinan, wanaiŋ. Aku mandeaca mbendeirinanna, meikramtaɨrmo otaca mina aukna meikramtaɨrta kambca waraca aukmo rɨpacna. ");
INSERT INTO gai_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Na aku toŋgorinanna, an meikramtaɨra iro kabe ndeacraŋna, an kirara u Aetta u aukap eacrenan, na aku unap eacrenan. Na an kirar kabea aku toŋgorinanna, mina aŋgap eacraŋ. Te, gan tiacarpaikna meikramtaɨra rɨpacnandet, u ndo aukmo mbagɨrica aku kɨprinan. ");
INSERT INTO gai_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Na u aukmo i aniacapa gargara neaŋrinan, na aku minmo neaŋrina. Te, mina nikinik iroara kabe ndeacnandet, na an tɨpna kirara aŋga eacrenan toc. ");
INSERT INTO gai_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Na aku minap eacrenan, na u aukap eacrenan, na an tɨpna kirara aku toŋgorinanna, mina nikinik iroara kabe ndeacna. Ainda mo te, gan tiacarpaikna meikramtaɨra lamŋinandet, u ndo aukmo mbagɨrica aku kɨprinan, na u aukna an meikramtaɨrta wiwitmo toŋgorenan, na an tɨpna kirar kabea u aukmo matŋirina. ");
INSERT INTO gai_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Na Ate, auk toŋgorinanna, u aukmo neaŋrina meikramtaɨr, mina aukap an auŋa aku eacrenanmo mina an ndeacna. Na aku toŋgorinanna, mina aukna memetacna tac aniacapa i aniaca watna. Na an mɨnna gan tiacarpaikca laru ŋgocor ndeacri, u aukmo matŋirinan, na u aukmo an memetacna tac aniacapa i aniac neaŋrina. ");
INSERT INTO gai_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Na u Aet wandoŋ ŋgoin, gan tiacarpaikna meikramtaɨra mina unmo mba lamŋirenan. Na aku ndo unmo lamŋirena. Na aukna gan meikramtaɨra mina lamŋirena, u aukmo mbagɨrica aku kɨprinan. ");
INSERT INTO gai_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Na minmo aku una imo moa larurina. Na aku memetmbaca mo laruraŋnandet. Te, mina kabena laiplacarmo toŋgoca matŋirena tɨpna kirar aŋgɨna, na an tɨpna kirara u aukmo toŋgoca matŋirena kirar. Te, auk toco minap eacnandet.” ");
INSERT INTO gai_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Karica Iesusa an kamb topca maica ma ndona iŋa raŋgairena ramtaɨrap, mina taŋca Kidron oc irikca monmbai waŋ magat. Na an ocna waŋga warɨŋ ianna maeacreke, ri, Iesusapa mana iŋa raŋgairena ramtaɨra mina an warɨŋ mambukat. ");
INSERT INTO gai_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Na Iesusmo puŋnaŋgepta para tɨkna ramoot Iudas, ma toco an taupca malamŋirenan. Na kɨdrɨk wɨtta Iesusa ma ndona iŋa raŋgairena ramtaɨrmo aŋgɨca mina an warɨŋa punirenan. ");
INSERT INTO gai_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ainda moca Iudasa an taup ndamtaɨr paŋaindta aiŋa morena ramtaɨrapa Parisiarta aiŋa morena ramtaɨrapa, lapoca ruŋrena ramtaɨrap, aŋgɨca mina an warɨŋ makɨpat. Na mina runduikta reikapa tacapa racbikarta kaipta tacap kɨprenan. ");
INSERT INTO gai_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ri, an reikca muruŋa man ndarunanna, ma atuna ndamŋirina. Ainda moca ma an tumbun ndambuŋa taŋga rambuŋaica ma minmo gainda digirinan, “Ne mandaina orerenan?” ");
INSERT INTO gai_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Karica mina mana kambmo gainda rutirina, “Aia Nasaretna Iesusna orena kɨprina.” Ri, Iesusa minmo aindopatna, “Aku gade.” Na manmo aŋgɨrca mina neaŋna ramoot Iudasa ma minap eacrina. ");
INSERT INTO gai_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Na mina waracrinanna, Iesusa aindoprina, “Aku gade man.” Ri, an ramtaɨra iŋ ndiŋa taŋga pitrik mairikat. ");
INSERT INTO gai_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Karica Iesusa minmo mac digiatna, “Ne mandaina orerena?” Na mina aindopatna, “Nasaret auŋna Iesus.” ");
INSERT INTO gai_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ainda moca Iesusa mina kambmo gainda rutirinan, “Aku nenmo mboprinan, anna auk. Na ne aukna ore te, ne gan ramtaɨrmo watcarica mina taŋ.” ");
INSERT INTO gai_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Na an tɨpna kirara ma ŋgaua mboprina kirara gan kamma moa mɨnna tɨkatna, “An ramtaɨra u aukmo neaŋrinanna, ianna mba taprekeitndait.” ");
INSERT INTO gai_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ainda moca Saimon Pita ma bugrim ianap aŋgɨca taŋrenanna, ma an mbuŋa taup ndamoot paŋan aniacna tuomna aiŋ kamainda morena ramootmo mawacat. Na an bugrimma an ramootna koar umbai waŋa kataca mairikat. Na an mbaiŋna aiŋa morena ramootna ia Malkus. ");
INSERT INTO gai_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Karica Iesusa Pitamo gaindopatna, “An bugrimmo mana taupca nda tɨk. Kai ac? Na u tit ndamŋirena, an gɨgɨrar Aetta aukmo neaŋna morenanna, aku mba mbukit ki?” ");
INSERT INTO gai_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ainda moca an lapoca ruŋrena ramtaɨrta wiwitapa, mina outta taŋrena ramoot paŋanapa, Iudana aiŋa morena piriŋgap, mina Iesusmo utiŋga mana parniŋmo ŋgatɨk mbuŋa leacrinan. ");
INSERT INTO gai_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ri, mina manmo outta Anas ndambuŋ naaŋgɨa mataŋgat. Na Anas ma Kaiapasna meacna aet, na Kaiapasa an mɨnna ma taup ndamoot paŋan aniac ndeacri. ");
INSERT INTO gai_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Na man tikca, ma an ramootta Iudanaŋgepmo aindopatna, “Anna laŋ ecte, ramoot kabea ndo meikramtaɨr wɨtna taup aŋgɨca menacna.” ");
INSERT INTO gai_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ainda moca Saimon Pitaapa kabena Iesusna iŋa raŋgairena ramoot ianna maniŋa Iesusna iŋa raŋgaica mataŋri. Na an Iesusna iŋa raŋgairena kabena ramoot, anna taup ndamoot paŋan aniaca manmo lamŋirena, aintik ma Iesusmo raŋgaica taup ndamootna kacna wuoca mbukrinan. ");
INSERT INTO gai_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Na Pita ma wuocmo raekmbaina tɨŋ kamma, wɨtɨkca eacri. Ainda moca an kabena Iesusna iŋa raŋgairena ramootta taup ndamoot paŋan aniaca manmo lamŋirenanna, ma an tɨŋna ŋginaŋa morena meacmo mbopca ma taŋga Pitamo ŋai naaŋgɨca mambukat. ");
INSERT INTO gai_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ri, an tɨŋna ŋginaŋa morena meaca Pitamo gainda digirina, “Na u toco, mana iŋa raŋgairena ramtaɨrta ramoot ian ki?” Ri, Pita gaindopatna, “Wanaiŋ, aku mana iŋa raŋgairena ramtaɨrta ianna wanaiŋ.” ");
INSERT INTO gai_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Na an mouŋa gagauri, na an mbaiŋna aiŋa morena ramtaɨrapa Iudana aiŋa morena piriŋgap, tac aniac ianna keca eacri. Na mina wɨtɨkca ndorita tikembmo moa owairena. Ainda moca Pita toco minap wɨtɨkca ndona tikmo moa owairina. ");
INSERT INTO gai_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Na an mɨnna taup ndamoot paŋan aniaca Iesusmo ndona iŋa raŋgairena ramtaɨrta moca digirinanapa, an kambca ma meikramtaɨrmo riptirenan. ");
INSERT INTO gai_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ainda moca Iesusa mana kambmo gainda rutirinan, “Aku meikramtaɨrmo memetmbaca kambca waekekeca neaŋrenan. Na memetmbaca aku meikramtaɨrmo Iudananta mimitpac aŋgɨrena kaikca tɨkca riptirenan, na Raraŋ Aetaniacna Kacna wuocna roumbca anna Iudanaŋgepca anna punirenan. Na aku kam ianna ŋaia mba tɨkca mboprenan. ");
INSERT INTO gai_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Na kaica u aukmo digirenan? U an kamb mbaracrina meikramtaɨrmo digi. Na an kambca aku mboprinanna, mina lamŋirenan.” ");
INSERT INTO gai_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ainda moca Iesusa aindopatke, piraŋ ianna wɨtɨkca eacrenanna, ma Iesusmo apakeca aindoprina, “Kaina moca u taup ndamoot paŋan aniacna kambmo gaindta tɨpna kirara rutica mboprina?” ");
INSERT INTO gai_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Karica Iesusa mana kammo gainda rutirinan, “Aku kam ŋgoreaca mbop te, u aukna mbopatna kam ŋgoreacna mɨnɨŋmo mbop. Na aku kam laŋ ndop te, kaina moca u aukmo pirinan?” ");
INSERT INTO gai_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Karica Anasa Iesusmo taup ndamoot paŋan aniac Kaiapas ndambuŋa mbagɨrica taŋrina. Na an ŋgatɨkca mina mana parniŋmo leacrinanna, mina mba pɨaratke. ");
INSERT INTO gai_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Na Saimon Pita ma wɨtɨkca ndona tikmo taca tɨkca moa owairi. Na mina manmo gainda digirina, “U toco, mana iŋa raŋgairena ramtaɨrta ramoot ian ki?” Ainda moca ma gaindopatna, “Wanaiŋ, aku mana iŋ raŋgairena ramtaɨrta ianna wanaiŋ.” ");
INSERT INTO gai_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Na taup ndamoot paŋan aniacna mbaiŋna aiŋa morena ramoot, Pita mana koarmo bugrim mbuŋa waca katacrinanna, mana kamkabe ianna ma aindoprina, “Aku umo watrinanna, u Iesusap warɨŋ inikca eacrina ramoot ki?” ");
INSERT INTO gai_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ainda moca Pita gaind mac mbopatna, “Wanaiŋ.” Na an kɨdrɨk ŋgoinna kackura maapat. ");
INSERT INTO gai_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Karica Iudanaŋgepta ramtaɨra Kaiapasna kac tɨkcarica mina Iesus aŋgɨca Romna ramoot paŋanna, an ndeacrinanmo, mina manmo anna aŋgɨ taŋrina. Na anna ŋaŋarmuŋ ŋgoin. Na mina gaind malamŋiat, “Moca aia Raraŋ Aetaniacna lamnɨac ŋgoutta ratta mba laruitndai, te, aia mina an Pasowana Rana amtiamma mba ammit.” Ainda moca mina ndori koinda an Romna ramoot paŋanna kaca mba mbukatke. ");
INSERT INTO gai_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ri, mina raekca lambia eacri, Pailatta min ndambuŋa kɨpca minmo gainda digirina, “Ne gan ramootmo kaina reacna moca manmo ritri waparaca mona more?” ");
INSERT INTO gai_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Na mina mana kambmo gainda rutirina, “Ma tɨp kirar ŋgoreaca mo ŋgocorta ramoot ecte, aia manmo un ndambuŋa mba aŋgɨ kɨpitndai.” ");
INSERT INTO gai_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ri, Pailatta minmo gaindopatna, “Ne manmo aŋgɨca taŋca ndorita tɨp wandɨk mbuŋa manmo ritri waparaca mo.” Na an Iudanaŋgepca aindopatna, “Aia ramootta mo memenaca anna wandɨk.” ");
INSERT INTO gai_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Na ŋgaua Iesusa ndo memenacna tɨpna kirara ma mbopatnan, na an reaca larurinanna, ma an mana kammo gidikca moa mɨnna tɨkatna. ");
INSERT INTO gai_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Karica Pailatta an Romna ramoot paŋanna kaca nda mambukat. Ri, ma Iesusmo aca kɨpca manmo madigiat, “U Iudananta gagrirta ramoot paŋan ki?” ");
INSERT INTO gai_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ri, ma mana kambmo gainda rutirinan, “U ndo an kambmo ndo mbuŋa lamŋica mbopre, ki? Co, kabena ramootta aukna moca unmo mboprinan ki?” ");
INSERT INTO gai_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ainda moca Pailatta mana kambmo gainda rutirina, “Kaica? Na aku Iudana ramoot ki? Una wiwitnanapa taup ndamtaɨr paŋainda unmo auk ndambuŋ naaŋgɨca kɨprina. Na u kai ŋgoinna morina?” ");
INSERT INTO gai_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Karica Iesusa gaindopatna, “Aukna bubuoca gan tiacarpaiknanna wanaiŋ. Na aukna bubuoca gan tiacarpaiknan co, aukna mbaiŋa morena ramtaɨra ruŋ mbe, te, ramoot ianna aukmo Iudanaŋgepta para mba tɨkitndai. Aind aukna bubuoca gan tiacarpaiknanna wanaiŋ.” ");
INSERT INTO gai_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ri, Pailatta manmo gainda digiatna, “Na anna gidikca, u gagrirta ramoot paŋan ian ki?” Ri, Iesusa mana kammo gainda rutirina, “Na an gagrirta ramoot paŋanna kambca anna una kamb. Na aemma aukmo mɨrrinanna, aku gan tiacarpaik nakɨprinanna, aku aiŋ kabe niŋgikca mona kɨprinan. Na anna kamb gidkara wiwitinan, te, meikramtaɨra muruŋa waracnande. Ainda moca meikramtaɨra muruŋcamiŋa kamb gidkara raŋgairenanna, mina aukna kamma raŋgainandet.” ");
INSERT INTO gai_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Na Pailatta manmo mac madigiat, “Na kam gidikca anna kaina reac ŋgoin?” Na Pailatta an kamb topca maica ma nda laruca Iudanaŋgep tambuŋ mataŋgat, na ma minmo gaindoprinan, “Aku mana makuk ianna mba watri. ");
INSERT INTO gai_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Na aukna raŋgairena tɨpna kirara ne lamŋirenan. Na an Pasowana Rana iarira aku memetmbaca kac ŋgoreacna ramoot ianmo wattacarica ma larurenan. Ainda moca ne toŋgorinanna, aku nenmo gan Iudananta gagrirta ramoot paŋanmo watcarica ma larua taŋit ki?” ");
INSERT INTO gai_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ri, mina kamb keca aindoprina, “Ma wanaiŋ co. U Barabasmo watcarica ma laru.” Na Barabas tikca ma runduŋa moa ŋgeprenanapa reik makɨmrena ramoot. ");
INSERT INTO gai_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ainda moca Pailatta mbopca mina Iesusmo aŋgɨca ruktuk mbuŋa pirina. ");
INSERT INTO gai_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ri, lapoca ruŋrena ramtaɨra kun tocna ŋgatɨk aŋgɨca, an mbuŋa gagrirta ramootna paŋanna tɨkrena reaca moca, mana paŋanna matɨkat. Na mina manmo tik ŋgapaoc laup ianna aocrina. ");
INSERT INTO gai_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ri, mina mana kɨtɨm nakɨpca manmo gaindopatna, “Ra laŋ, Iudana gagrirta ramoot paŋan!” Na mina manmo maapat. ");
INSERT INTO gai_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Karica Pailatta mac nda laruca meikramtaɨrmo aindopatna, “Ne wat, aku manmo nen ndambuŋa aŋgɨca laruca ne watnandet, na ne lamŋinandet, aku man morina reac ianna wat ŋgocor.” ");
INSERT INTO gai_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ainda moca Iesusa laruatke. Na an paŋanna tɨkrena reaca mina kunna ŋgatɨk mbuŋa morinanna, mana paŋanna eacrinan. Na an tik ŋgapaoc laupa anna manap eacri. Na Pailatta minmo gaindopatna, “Ne wat, gan ramootta gade.” ");
INSERT INTO gai_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ainda moca taup ndamtaɨr paŋaindapa piriŋga mamo watca kamb keca aindoprina, “Manmo mo menac! Manmo mo menac! Na manmo ik naaŋgɨ kerac!” Ri, Pailatta minmo aindopatna, “Ne ndori, manmo aŋgɨca ik nakerac. Aku man morina makuk ianna wat ŋgocor.” ");
INSERT INTO gai_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ainda moca Iudanaŋgepca mana kambmo gainda rutica aindoprina, “Aia tɨp wandɨk ianap, an tɨp wandɨkca ma aindoprina, an ramoot ma menacnandet. Na anna mɨnɨŋa ma aindoprina, ‘Aku Raraŋ Aetaniacna Nuoc.’” ");
INSERT INTO gai_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Na Pailatta an kamb mbaraca ma kocnaia nanambiacarica. ");
INSERT INTO gai_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ri, ma ndona an kaca mbukca ma Iesusmo gainda digiatna, “U tenna auŋnan.” Na mana kambca Iesusa mba rutiri. ");
INSERT INTO gai_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ainda moca Pailatta manmo gaindoprina, “Kaica? U aukna kambmo rutina karirinanna? Aku unmo wattacarica taŋna gargarap, na aku umo ik naaŋgɨ keracna gargarap. Na u anmo mba lamŋire ki?” ");
INSERT INTO gai_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ri, ma mana kambmo gainda rutirina, “Na tamuŋna Raraŋ Aetaniaca unmo gargara neaŋ ŋgocor te, u aukmo mo irikna gargar kocor. Ainda moca ramootta aukmo una para tɨkrinan, mana tɨp ŋgoreacna makukca una tɨp ŋgoreacna makukmo kunda tamuŋmbai, na mananna bagaraniac ŋgoin.” ");
INSERT INTO gai_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ainda moca Pailatta an kamb mbaraca ma Iesusmo wattacarica taŋna taupembta korerina. Na Iudanaŋgepnanna, gaindta kamb keca gaindoprina, “U an ramootmo watcaria ma taŋ te, u Sisana aikndamootta wanaiŋ. Na ramootta ndomo gagrirta ramoot paŋan ndop te, ma Sisana puŋndamoot.” ");
INSERT INTO gai_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Karica Pailatta an kamb mbaraca ma Iesusmo raek naaŋgɨa malaruri. Na ma ritri waparacna mbibiracna taupca mbiracri, an taupca mina gaind ŋgacrenan, waturta taup. Na Iburuna kam mbuŋa mina gaind ŋgacrenan, Gabata. ");
INSERT INTO gai_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Na an ra, anna amta reik ŋgobacrena ra, na ma Pasowana Ramo rambuŋairi, aintik mina amna reacmo kocrorenan. Na rana ŋgaŋganŋgɨca ramo rɨk ŋgoinna tɨkri. Pailatta Iudanaŋgepnanmo gaindoprina, “Nena gagrirta ramoot paŋanmo wat.” ");
INSERT INTO gai_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ainda moca mina aindoprina, “Manmo ik nakerac! Manmo aŋgɨ taŋca ik nakerac! Manmo ik naaŋgɨ kerac!” Karica Pailatta minmo gaind madigiat, “Ne toŋgorinanna, aku nena gagrirta ramoot paŋanmo ik naaŋgɨ keracait, ki?” Ri, taup ndamtaɨr paŋainda mana kambmo rutica aindoprina, “Aia kabena gagrirta ramoot paŋan kocor, Sisa ndo kabe niŋgik!” ");
INSERT INTO gai_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ainda moca ma Iesusmo lapoca ruŋrena ramtaɨrta para tɨkrina, te, mina manmo aŋgɨca ik naaŋgɨ keracna. ");
INSERT INTO gai_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Karica mina Iesusmo aŋgɨca mataŋgat. Na ma ndo ŋgoinna ndona keracna ik mbukca aŋgɨca mataŋri. Na ma an auŋ aniacmo tɨkcarica ma taup ianna taŋri, na an taupca mina Paŋan Tiaŋgapna Gagar ŋgacrenan. Na Iburuna kam mbuŋa mina gaind ŋgacrena, Golgota. ");
INSERT INTO gai_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Na an taupca tɨkca mina manmo ik naaŋgɨca keracatna. Na ramoot mbuniŋmo mina manap keracrina. Ianna waŋembai, na ianna waŋembai. Na Iesus tikmo rɨkca tɨkrina. ");
INSERT INTO gai_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Na Pailat toco mbopca mina kam tɨp ianmo tirca an ik naaŋgɨca keracrina. Na an kamma gaind, “Nasaretna Iesus, Iudana Gagrirta Ramoot Paŋan.” ");
INSERT INTO gai_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Na ma minmo an kammo Iburunanapa Romnanapa Girikna kamb puŋga tirca mboprinan. Na an taupca mina Iesusmo ik naaŋgɨ keracrinanna, ma auŋ aniacmo rambuŋmbai, aintik Iudanaŋgepta wɨt aniaca kɨpca watatna, na mina an tirrina kammo watrinan. ");
INSERT INTO gai_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ainda moca Iudanaŋgepta taup ndamtaɨr paŋainda Pailatmo gaindopatna, “U ainda kai tir teac, ‘Iudana gagrirta ramoot paŋan.’ Wanaiŋ. U gainda tir, ‘Gan ramootta gaindoprina, “Aku Iudana gagrirta ramoot paŋan.”’” ");
INSERT INTO gai_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ri, Pailatta mina kambmo nda rutica gaindoprina, “Kaina kambca aku tireknan, ma eacnandet.” ");
INSERT INTO gai_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Karica lapoca ruŋrena ramtaɨr paura manmo ik naaŋgɨa keracatke, mina ndorimo kabe, kabea mana tik ŋgapaoca aŋgɨatna. Na mana aocrena tik ŋgapaoc rocotta mina raraŋit kabe mbuŋa morinan tocmo mina aŋgɨatna. ");
INSERT INTO gai_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ainda moca an lapoca ruŋrena ramtaɨra aindopatna, “Aia gan tik ŋgapaocmo kai titac teac. Aia matɨp rocotna gegerei tocna gegerei mbuŋa gereia, watna mandaia ndo aŋgɨit.” Na mina aind mamoat, na an tɨpna kirarira mina Raraŋ Aetaniacna timbigta kapna kam ianmo, moa mɨnna tɨkrina. Na an kamma gaind, “Mina aukna tik ŋgapaocmo biŋaia mina aŋgɨatnan. Ri, mina matɨp rocotna gegerei nagereica aukna kabena tik ŋgapaocmo watna, mandaia ndo aŋgɨit.” Na an tɨpna kirar mbuŋa an lapoca ruŋrena ramtaɨra ainda morinan. ");
INSERT INTO gai_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Na Iesusna aemmapa, Iesusna aemna lapnameac, Kilopasna meac Mariaapa, Makdala auŋ tekerna meac Mariaapa, mina muruŋa Iesusna keracrina ikna roumbca wɨtɨkca eacrinan. ");
INSERT INTO gai_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ri, Iesusa ndona aemmapa mana matŋirena iŋa raŋgairena ramtaɨrta ramootta watri, na maniŋa mana kɨtɨm ndeacrina. Na ma ndona aemmo gaindoprina, “Abo, gan ramootta anna una nuoc.” ");
INSERT INTO gai_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Na ma an mana iŋa raŋgairena ramtaɨrta ramootmo gaindoprina, “Gan meaca anna una aem.” Na an mɨnna tɨkca an mana iŋa raŋgairena ramtaɨrta ramootta, ma Maria aŋgɨca ndona kaca taŋca manmo raupŋinandet. ");
INSERT INTO gai_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ainda moca Iesusa lamŋirinan, mana aiŋira mamairi. Na ma gaindopatna, “Aku logotta magagrari.” Na ma an kam tɨpmo mbopatke, ma an Raraŋ Aetaniacna Timbigta Kap ndeacrena kam ianmo moa mɨnna tɨkatna. ");
INSERT INTO gai_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Na mambarina wain puk wɨn ianna ma rambuŋ ndeacrenan. Ainda moca mina puk wɨŋa utiŋrena reaca, mina spans ŋgacrena reac ian aŋgɨca an wain pukna inikca tɨkrina. Na wain pukca mbukca mɨnna tɨkri, mina ik isopna ŋaca leaca mina aŋgɨca mana upa tɨkrina. ");
INSERT INTO gai_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ri, Iesusa an mbuŋa wain pukca ambatke, ma gaindopatna, “Mamairi.” Na ma ndona paŋanmo ramtukca mana ŋeroŋa manmo tɨkcamacariat. ");
INSERT INTO gai_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Na an ra, anna Wɨktɨtɨkna Rana amna reac ŋgobacrena ra. Na an Wɨktɨtɨkna Ra anna ra aniac ŋgoin, aintik Iudanaŋgepca mina warirmo an ra ik naaŋgɨ keraca eacrenanna, mina mba toŋgorenan. Ainda moca mina Pailatmo mbopa waraca mina an ik naaŋgɨ keraca eacrena ramtaɨrta ourmo, mo rɨmbɨtca, mina tawi menacna, te, mina warirmo aŋgɨca mutocna. ");
INSERT INTO gai_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ainda moca lapoca ruŋrena ramtaɨra taŋga an Iesusap ik nakeracrina ramootniŋna orniŋmo moa rɨmbɨtrina. ");
INSERT INTO gai_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Na an kɨdrɨkca mina Iesus ndambuŋ nakɨpca, mina watrinanna, ma menacatna. Aintik mina mana orniŋmo mba moa rɨmbɨtatke. ");
INSERT INTO gai_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ainda moca lapoca ruŋrena ramoot ianna Iesusna kanmbac waŋembaia lapoc mbuŋa rɨŋrinan. Ri, tawi ŋgoinna pukapa racainda mairikat. ");
INSERT INTO gai_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Na ramootta an reikca watrinanna, ma an reikta kambca ma wiwitirinan. Na an kambca ma wiwitirinanna, anna gidik, aintik ne rɨpac. ");
INSERT INTO gai_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Na an reikca mina Raraŋ Aetaniacna timbigta kapna inikna kam ianmo moa gidik malaruri. Na an kamma gaind, “Mina mana gagar ianna mba rɨmbɨtitndai.” ");
INSERT INTO gai_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Na kabena kam tɨp toco Raraŋ Aetaniacna timbigta kap ndeacrenanna, ma gaindoprina, “An meikramtaɨra mina manmo rɨŋrinanna, mina watnandet.” ");
INSERT INTO gai_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Karica iŋmbaia Arimatia auŋna Iosepa taŋga Pailatmo digia manmo laŋ ndop te, ma Iesusna waɨrmo aŋgɨna. Na Iosep tikca ma Iesusna iŋa raŋgairena ramtaɨrta ramoot ian, na ma Iudanaŋgepta nanambica ma ndona rɨtɨpacmo aŋgɨ iŋgorocrenan. Ri, Pailatta manmo laŋ ndopri, ma Iesusna waɨrmo aŋgɨrina. ");
INSERT INTO gai_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Na Nikodemusa an ramootta ŋgaua ma mouŋa kɨpca Iesusmo watrina ramoot, ma toco kɨprina. Ma tabrir ndeidap aŋgɨca kɨprinan, anna mina ik mbuniŋna manŋar puŋga kurica morinan, na maniŋna iŋpaia laŋ ŋgoin. Na an tabaɨr pukna makukca 30 kilogeremna mɨn. ");
INSERT INTO gai_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ainda moca an ramootniŋa Iesusna waɨrmo aŋgɨca an tabrir puŋga ndikrinan. Na an Iudanaŋgepca menacrena meikramtaɨrmo, morena tɨpna kirara raŋgaica mana waɨrmo, maniŋa raraŋit laŋ aŋgɨca an mbuŋa tamairinan. ");
INSERT INTO gai_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Na lapoca ruŋrena ramtaɨra Iesusmo ik naaŋgɨca keracrina taupca warɨŋ ianna anna rambuŋa eacrenan. Na an warɨŋna inikca muk ŋgam ianna eacrena, na mina waɨr ianna anna mba tikrinan. ");
INSERT INTO gai_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Na anna Iudanaŋgepta Wɨktɨtɨkna Rana amta reik ŋgobacrena ra, na an mukca rambuŋa eacrenan. Ainda moca maniŋa Iesusna waɨrmo aŋgɨca taŋga an mukca tɨkrinan. ");
INSERT INTO gai_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Na raita ŋgat kabena ra lacaua, Makdala auŋna Maria, ma auŋ raruna morina ŋaŋarmuŋ ŋgoinna ma mukca taŋrina. Na ma watrinanna wautta tɨŋmo mboraca eacrenanna, anna tɨŋmo mba mboracri. ");
INSERT INTO gai_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ainda moca ma ootta taŋga Saimon Pitaapa an Iesusna iŋa raŋgairena ramtaɨrta ramootta, Iesusa manmo matŋirenanmo, ma maniŋmo aindoprina, “Mina Kacootmo mukca tɨkca aŋgɨa mataŋri, na mina manmo tenna tɨkrinanna, aia mba lamŋireke.” ");
INSERT INTO gai_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ri, Pitaapa an Iesusna iŋa raŋgairena ramootta, maniŋa ŋgepca auŋ tɨkcarica muk ndambuŋ mataŋri. ");
INSERT INTO gai_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Na maniŋa muruŋniŋa ootrinan, na an Iesusna iŋa raŋgairena ramtaɨrta an ramootta Iesusa matŋirenanna, ma Pitamo ootta kunda ma mukmo outta taŋga malaruat. ");
INSERT INTO gai_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Na ma ramtukca ŋaia watta mbukrinanna, na ma watrinanna, mina Iesusna waɨrmo tamairina raraŋgir laiŋ kamndera ndori eacrina. Na ma mba mbukatke. ");
INSERT INTO gai_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ri, Saimon Pita ma mana iŋ nakɨpca laruca ma muk mambukat. Na ma watrinanna, raraŋgir tiŋgikca ndoria eacrenan, ");
INSERT INTO gai_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","na ma kabena raraŋit motocmo watrina, anna mina Iesusna paŋanna tamaiatnanna, anna mba eacatke. Na an raraŋitta ma an ndeacrena raraŋgirap mba eacri. Wanaiŋ. Manmo ramootta aŋgɨca rukumbca aŋgɨca kabena taupca tɨkca eacrina kirar toc. ");
INSERT INTO gai_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ainda moca an Iesusna iŋa raŋgairena ramootta outta larurinanna, ma toco mbukrina. Na ma an reikca watca ma marɨpacat. ");
INSERT INTO gai_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Na an mɨnna mina Raraŋ Aetaniacna Timbigta Kap ndeacrena kambca mba gɨwaca lamŋireke, Iesusa muk ŋgetacndiŋ mac ŋgepnandet. ");
INSERT INTO gai_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Karica an mana iŋa raŋgairena ramootniŋa auŋ aniac mac nda mataŋgat. ");
INSERT INTO gai_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ri, Maria ma an mukmo raekmbaia aea eacri. Na ma ae mbuŋa ramtukca ma mukna inikca watta mbukatke. ");
INSERT INTO gai_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ma tik ŋgapaoc gogok aoca eacrena mbaiŋna aiŋa morena ŋeroŋ mbuniŋ mawatri. Na an mbaiŋna aiŋa morena ŋeroŋniŋa an Iesusna waɨra eacrina taupca mbiraca eacrena. Ianna mana paŋanna eacrina taup, na ianna mana orniŋa eacrina taupca mbiraca eacrina. ");
INSERT INTO gai_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Karica maniŋa Mariamo gainda digirina, “Meacmbitac, kaina moca u aerena.” Ri, ma maniŋmo gainda rutiatna, “Mina aukna Kacootna waɨrmo aŋgɨca tenna tɨkrinanna, aku mba lamŋireke.” ");
INSERT INTO gai_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Na ma aindopacarica, ma kumbakeca watrinanna, ma Iesusmo mawatri. Na ma mba lamŋiri, anna Iesus. ");
INSERT INTO gai_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ainda moca Iesusa manmo gainda digirina, “Meacmbitac kaina moca u aerena? Na u mandaina ŋgorerena?” Na Maria anmo warɨŋna aiŋa morena ramoot ndopca, ma manmo gaindopatna, “Ramoot aniac, u manmo aŋgɨ taŋ te, u aukmo tɨkrina taup ndop te, aku taŋca manmo aŋgɨna.” ");
INSERT INTO gai_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ri, Iesusa gaindopatna, “Maria.” Na Maria kumbakeca manmo Iburuna kam mbuŋa gaindopatna, “Rabonai.” Na an kam, “Rabonai,” mana mɨnɨŋa gaind, “Riripti.” ");
INSERT INTO gai_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Karica Iesusa manmo gaindoprina, “U aukmo kai utiŋ teac, aku ndona Aet ndambuŋmo mba gacreke. Na u taŋga aukna laiplacarmo gaindop, aku tamuŋ naganandet. Na aku ndona Aetapa nena Aet ndambuŋa taŋnandet. Na aku ndona Raraŋ Aetaniacapa nena Raraŋ Aetaniac ndambuŋa taŋnandet.” ");
INSERT INTO gai_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ainda moca Makdala auŋna Maria ma ŋgepca taŋga, mana iŋa raŋgairena ramtaɨrmo gaindopatna, “Aku Kacootmo watrina.” Ri, Iesusa manmo neaŋrina kambmo, ma minmo mboprina. ");
INSERT INTO gai_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Na mana iŋa raŋgairena ramtaɨra Iudanaŋgepta moca nanambirina, aintik mina eacrena an kacna tɨŋmo kaptikica leacrina. Na an raipaikna ŋgatna ra lacaua maica ra irikca wigwacari, Iesusa kɨpca mina rɨk mawɨtɨkat. Na ma minmo gaindopatna, “Nena iroar inkara wetwet laŋ ndeacraŋ.” ");
INSERT INTO gai_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Karica ma aindopacarica, ma minmo ndona parapa kanmbacarpaikna ndibmo minmo mawandacat. Na mana iŋa raŋgairena ramtaɨra Kacootmo watca mina iroar inkara toŋtoŋgar koinda morina. ");
INSERT INTO gai_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ri, Iesusa minmo gaind mac mbopatna, “Nena iroar inkara wetwet laŋ ndeacraŋ, na Aetta aukmo mbagɨrica aku kɨprinan, na an kirara aku nenmo mbagɨrica ne taŋnandet.” ");
INSERT INTO gai_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Na ma aindopri, ma ndona watmo minmo wica taŋga, ma minmo gaindopatna, “Ne Ŋeroŋ Ratmo aŋgɨ. ");
INSERT INTO gai_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Na ne meikramtaɨrta tɨpemb ŋgorikta makukarmo, mo kecari te, mina tɨpemb ŋgorikta makukara mainandet. Na ne mina tɨpemb ŋgorikta makukarmo moi kecari ŋgocor te, mina an tɨpemb ŋgorikta makukarap eacraŋnandet.” ");
INSERT INTO gai_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Na an mɨnna Iesusa mana iŋa raŋgairena ramtaɨr tambuŋ ndarurinanna, mina ramtaɨrpaikna ianna ma minap mba eacri. Anna Tomas, na mana i tekera Didimus. ");
INSERT INTO gai_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ainda moca iŋmbai mbuŋa mana iŋa raŋgairena ramtaɨra Tomasmo gaindopatna, “Aia Kacootmo watrina.” Na ma minmo gaindoprina, “Aku mana lacna ndibca mina mana para tɨkrinanna wat ŋgocor, na aku ndona patŋitmo an ndibembta ge tɨk ŋgocor, na aku mana kanmbaca ndona par mbuŋa utiŋ ŋgocor tik, aku mba rɨpacitndai. Wanaiŋ ŋgoin.” ");
INSERT INTO gai_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Na rai parmbaiapa mbut mbuniŋna iŋmbai mbuŋa mana iŋa raŋgairena ramtaɨra an kac inik ndeacrinan, na Tomas toco, ma minap eacrina. Na mina an kacna tɨŋmo kaptikica leacrinan, na Iesusa kɨpca mina rɨkca wɨtɨkrina. Na ma minmo gaindoprina, “Nena iroar inkara wetwet laŋ ndeacraŋ.” ");
INSERT INTO gai_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Karica ma Tomasmo aindopatna, “U kɨpca ndona patŋitmo ganna tɨk, na u aukna para wat. Na u ndona parmo aukna kanmbacarpaikmo, u utiŋ. Na u iro mbuniŋa kai aŋgɨ teac, u rɨpac niŋgik.” ");
INSERT INTO gai_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Na Tomasa mana kambmo gainda rutirinan, “U aukna Kacoot, na u aukna Raraŋ Aetaniac.” ");
INSERT INTO gai_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Karica Iesusa manmo gaindopatna, “U aukmo watca u rɨpacri ki? Na meikramtaɨra aukmo wat ŋgocor, na rɨpacrinanna, an meikramtaɨra mina toŋtoŋgar tiŋgik.” ");
INSERT INTO gai_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ainda moca Iesusa mana iŋa raŋgairena ramtaɨrta lamnik ŋgoutmo ainta ŋgagatracar wɨtta morinanna, aku anmo gan timbigta kapca mba tirri. ");
INSERT INTO gai_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Na an kambca aku tirrinanna, anna aku tirca ne Iesusmo rɨpacnandet, ma an ramootta Raraŋ Aetaniaca babuca mbagɨrica kɨpca aimo mac nda aŋgɨna ramoot. Na ma Raraŋ Aetaniacna Nuoc. Aintik ne rɨpac te, ne eteacna watmo mana i mbuŋa aŋgɨnandet. ");
INSERT INTO gai_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Karica iŋmbaia Iesusa mana iŋa raŋgairena ramtaɨrmo, Galili mɨar ndambuŋ mac larurinan, na an mɨarna i ianna Taiberias mɨar. Na ma min ndambuŋmo gainda larurinan, ");
INSERT INTO gai_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saimon Pitaapa, Tomas, mana i tekera Didimusapa, Nataniel, ma Galili pitrikna auŋ Kanacnan, na Sebedina nuocniŋapa, mana iŋa raŋgairena kabena ramootniŋap, mina tumbun ndeacri. ");
INSERT INTO gai_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Karica Saimon Pita ma minmo gaindopatna, “Aku ŋgoaebta korena taŋnandet.” Na mina manmo gaindopatna, “Ai toco unap taŋnandet.” Ri, mina manap embarta kor ian naŋgabukca mataŋgat. Na an mouŋ rocotta mina ŋgoaem ianna mba aŋgɨatke. ");
INSERT INTO gai_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Na auŋ raruca ra gaca Iesusa maŋara wɨtɨkca eacrinan. Na mina manmo mba watta garacri, ma Iesus. ");
INSERT INTO gai_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ainda moca Iesusa minmo gainda digirina, “Ramtaɨr, ne ŋgoaeb ndeidap ki?” Na mina mana kammo gainda rutirinan, “Wanaiŋ co.” ");
INSERT INTO gai_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Na ma minmo aindopatna, “Ne weaŋmo korna par umbaia ke, te, ne ŋgoaeb ndeidmo aŋgɨnandet.” Ainda moca mina weaŋmo keca mapukat, ri, mina ŋgoaebmo mba weteica aŋgɨrinan, na mina weaŋmo wɨŋ ŋgacna mɨnna wanaiŋ. ");
INSERT INTO gai_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Na an mana iŋa raŋgairena ramtaɨrta ramootta Iesusa manmo matŋirenanna, ma Pitamo aindoprina, “Anna Kacoot niŋgik.” Na Pita ma ndona tik ŋgapaoc rocotta pitukca tɨkcarica ma aiŋa moa eacri. Na ma an kamma waraca, “Anna Kacoot,” ri, ma ndona tik ŋgapaocmo leaca ma pukca, pukca maŋara iria magari. ");
INSERT INTO gai_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Na an mana iŋa raŋgairena ramtaɨr ndeida kor mbuŋ nakɨpri, na mina ŋgoaebmo weaŋap wɨŋga makɨpri. Na mina maŋarmo tawan ŋgoinna wanaiŋ. Mina 100 mitana ŋgaŋganŋgɨna mɨn. ");
INSERT INTO gai_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Na mina kɨpca tunduoca, mina watrinanna tac ianna wɨra eacrenan. Na ŋgoaem ianna an taca eacrenanapa tapac ian toco an ndeacrena. ");
INSERT INTO gai_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Karica Iesusa minmo gaindopatna, “Na an ŋgoaebca ne aŋgɨrinanna, ne ndeidmo aŋgɨ kɨp.” ");
INSERT INTO gai_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ainda moca Saimon Pita ma kor naŋgabukca ma weaŋmo maŋara wɨŋga magari. Na ŋgoaeb anikca weaŋmo mɨn ŋgoin, na mina ŋgaŋganŋgɨa 153na mɨn. Na ŋgoaebca wɨt koind, na weaŋa mba titacatke. ");
INSERT INTO gai_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Karica Iesusa minmo gaindopatna, “Ne kɨpca am.” Ri, mana iŋa raŋgairena ramtaɨra nanambia ianna manmo mba digiatke, “U mandai?” Mina lamŋirina, ma Kacoot niŋgik. ");
INSERT INTO gai_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ri, ma tac ndambuŋa taŋga rambuŋaica ma tapac aŋgɨca minmo neaŋrina. Na ma ŋgoaem tocmo aŋgɨca minmo neaŋgatna. ");
INSERT INTO gai_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Na Iesusa muk ndiŋ naŋgepca eacrina mɨnna, ma kɨdrɨk mbonkaca ma ndona iŋa raŋgairena ramtaɨr tambuŋ ndaruatna. ");
INSERT INTO gai_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Karica Iesusapa mana iŋa raŋgairena ramtaɨra amba mairi, na ma Saimon Pitamo gaindoprina, “Saimon, Ionna nuoc, u aukmo mamatŋi aniacap ki? Na una an mamatŋia an ramtaɨrmo kundrinan ki?” Na Pita aindoprina, “Ore Kacoot, u lamŋirenan aku unmo matŋirena.” Ri, Iesusa manmo gaindopatna, “U aukna sipsipna mombonikmo wiram.” ");
INSERT INTO gai_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Na kɨdrɨk keca Iesusa manmo mac digiatna, “Saimon Ionna nuoc, u aukmo matŋirinan ki?” Ri, ma gaindopatna, “Nat co Kacoot, u lamŋirenan, aku unmo matŋirena.” Ri, Iesusa aindopatna, “U aukna sipsiparmo bubuoc.” ");
INSERT INTO gai_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Karica kɨdrɨkca mac keatke, ma mac digiatna, “Saimon Ionna nuoc, u aukmo matŋiri ki?” Na an kɨdrɨkca Pita ma maŋateat, ma manmo kɨdrɨk mbonkaca gainda digiatna, “U aukmo matŋiri ki?” Na ma Iesusmo gaindopatna, “Kacoot reikca u muruŋa lamŋirenan. Na u lamŋirenan, aku unmo matŋirena.” Ri, Iesusa manmo aindopatna, “U aukna sipsiparmo wiram. ");
INSERT INTO gai_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","“Na Aku unmo gidik, gidik ŋgoinna aindopnandet, u ramoot ŋgamma eac te, u ndona weaond leaca u ndona toŋtoŋna taupca taŋrenan. Na u bagarai te, u ndona parmo aŋgɨ ŋgepca kabena ramootta una weaond leaca una toŋgo ŋgocorta taupca aŋgɨ taŋnandet.” ");
INSERT INTO gai_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Na Iesusa an kamb toprinanna, ma Pitana ŋgagatraca morinan. Titocna tɨpna kirara ma menac te, Raraŋ Aetaniacmo i aniac neaŋnandet. Na iŋmbaia ma Pitamo gaindopatna, “U aukmo raŋgai.” ");
INSERT INTO gai_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ainda moatke, Pita ma kumbakeca watrinanna, an mana iŋa raŋgairena ramtaɨrta ramootta Iesusa manmo matŋirenanna, ma maniŋap kɨprina. Na ma ande an ramootta ndona paŋanmo Iesusna rugut paŋanna tɨkrinan, an mɨnna mina ambrina taupca tɨkca ma Iesusmo madigiat, “Kacoot mandaia ndo unmo puŋnaŋgepta para tɨkit?” ");
INSERT INTO gai_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ri, Pita manmo watca ma Iesusmo gainda digiatna, “Kacoot, na gan ramootta titoc?” ");
INSERT INTO gai_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Na Iesusa mana kammo gainda rutirina, “Na aku toŋgo te, ma eaca taŋga aku ndo nda kɨp te, na anna una reaca wanaiŋ? U kɨpca aukmo raŋgai.” ");
INSERT INTO gai_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ainda moca kamb watta Iesusa rɨpacrena laiplacarmo gainda taŋrina, “Gan mana iŋa raŋgairena ramtaɨrta ramootta ma mba menacitndai.” Na Iesusa ainda mba mboprina, ma mba menacitndai, wanaiŋ. Ma aindoprinan, “Aku toŋgoca ma eaca taŋga aku mac nda kɨp te, anna una reaca wanaiŋ?” ");
INSERT INTO gai_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Na anna an mana iŋa raŋgairena ramtaɨrta ramootta mandeaca ma gan reikta kambmo wiwitirenan, na ma gan kambmo timbigta kapca tirrinan. Na aia lamŋirenan, an kambca ma wiwitirenanna, anna gidik ŋgoin. ");
INSERT INTO gai_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Na kabena reik wɨt aniac toco Iesusa morinanna, mina an reikmo muruŋcamiŋna kabe, kabea timbigta kapca tir ndop te, gan aina tiacarpaikca an timbigta kaip tɨkna taupca mɨnna mba tɨkitndai.");
INSERT INTO gai_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Tiopilus, an timbigta kapca ŋgaua aku tirca neaŋga kɨpatnanna, anna Iesusna mandeb ŋgepca moatna reikta kambapa, ma meikramtaɨrmo mimitpac neaŋgatna kambca, ma an mɨnna tɨkca moa kɨpca Raraŋ Aetaniaca manmo tamuŋna auŋ mac nda aŋgɨa taŋgatna mɨn mbuŋna reik. Na aku an tirca neaŋga kɨpatna. Na an mɨnna tɨkca kɨp, kɨpca Raraŋ Aetaniaca manmo mac nda aŋgɨra gacatna ra mbuŋ. Ma taŋga ndona up aŋgɨrena ramtaɨr tambuŋ ndarurina, na an ramtaɨra ma ndo larapacrina. Na Ŋeroŋ Ratna gargar mbuŋa ma minmo reac, reacna aiŋira momona kam ndopca maiatke. Iŋmbaia Raraŋ Aetaniaca manmo tamuŋna auŋ mac nda aŋgɨrca magat. ");
INSERT INTO gai_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Na ma tamuŋna auŋa taŋ ŋgocor ndeacri, outmbaica, ma gɨrgɨr bagaraniac aŋgɨca menaca, mutoca eaca. Iŋmbaia ma wat mac nda aŋgɨca ma ŋgepca ndona up aŋgɨrena ramtaɨr tambuŋ ndaruca minapmo ainta reac, reac mamori, mimo ndo nagaraca gaind ndamŋina moca, gidik, ma mac nda maŋgepri. Aintik ma minapmo rai 40na mɨn ndeaca ma minmo Raraŋ Aetaniacna Bubuocna kam mambopat. ");
INSERT INTO gai_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Na an mɨn, ma minap eacri, na ma minmo kam gargar mbuŋa gaindopatna, “Ne Ierusalem auŋ aniacmo kai tawi tɨkcarica taŋ teac, aku nemo ŋgaua ndopatna reacmo, Aetta nenmo neaŋ ndopca babuatna reaca ma neaŋnande. ");
INSERT INTO gai_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Na Ion, ma meikramtaɨrmo kɨtac pukca, puk mbuŋa morena, na rocotta mba tɨkitndai, raeniŋ mai te, ne Ŋeroŋ Rat mbuŋa kɨtac puk aŋgɨnande.” ");
INSERT INTO gai_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Na an mɨn mbuŋa mana up aŋgɨrena ramtaɨra kɨpca punica mamo gainda digiatna, “Kacoot, u mandeaca Israelna tiacarpaikna bubuoca minmo mac nda neaŋit ki, wanaiŋ?” ");
INSERT INTO gai_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ri, ma mina kammo gainda nda rutiatna, “Anna nena reaca wanaiŋ. Ne an raiapa ŋgaŋganŋgɨ Aetnan ndamŋina, anna mana reac, ma ndo kabe ndamŋirena. Anna mana landamŋina ŋginaŋna kaŋgauk ndeacrenan. ");
INSERT INTO gai_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Na iŋmbaia an mɨn Ŋeroŋ Ratta ndo kɨpca nenap eac te, ne gagrar aŋgɨnande. Te, ne ŋgepca aukna morina reikta kambmo, Ierusalemna meikramtaɨrmo an kam wembaŋ laŋ an wiwiti te, Iudiana pitrik waŋna inikna auŋembapa Samarianandapa, mon tawan ŋgoinna auŋembca gan tiacarpaik ndeacrenanmo, gan kam wembaŋ laŋmo kocnai metmbaci mbopi taŋraŋ.” ");
INSERT INTO gai_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Karica Iesusa an kam ndopacarica, mina watrinan mbuŋa, Raraŋ Aetaniaca manmo aŋgɨra magari, na magari wawɨrpaikca kɨpca manmo, aŋgɨra iŋgorocatke, mina mamo mba mac watatke. ");
INSERT INTO gai_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ma taŋgacariatke, mina wɨtɨkca riac tamuŋmo an motemmo, mataua ŋginaŋikca eacri. Na tik ŋgapaoc gogokapna ramooteniŋa tawi ŋgoin motemma, mina kɨtɨm ndarua mawɨtɨkat. ");
INSERT INTO gai_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Maniŋa gaindopatna, “Ne Galilina ramtaɨr, tida moca ne wɨtɨkca riac tamuŋmo ŋginaŋikca eacre? An ramoot Iesus, ma nen tɨkcarica mandeaca Raraŋ Aetaniaca mamo tamuŋna auŋ naaŋgɨra magari, na ma gade gacpeke, ne watapekna kirar, mana gan tiacarpaikca nda kɨkɨpa, ne manmo aind mbatnandet.” ");
INSERT INTO gai_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Karica up aŋgɨrena ramtaɨra, mina Olip ŋgacrina takur tɨkcarica, mina ŋgepca Ierusalemma nda mataŋgat. Na an Olip Takur ŋgetacndiŋa, Ierusalemma tataŋa tawan ŋgoinna wanaiŋ. ");
INSERT INTO gai_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ri, mina taŋga Ierusalem auŋ aniacna inikca mbukca taŋga ndorita ŋgau ndeacrina kacna tamuŋmbaina diabca mbukna morina, an ramtaɨrta irembca gade, ianna Pita, na ianna Ion, na ianna Iemis, na ianna Andru, na ianna Pilip, na ianna Tomas, na ianna Batolomiu, na ianna Matiu, na ianna Iemis, ma Alpiusna nuoc, na ianna Saimon ma Selotna barna ramoot ian, na ianna Iudas ma Iemisna nuoc. ");
INSERT INTO gai_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","An ramtaɨra ndorimo aŋgɨra iro kabea tɨkca, memetmbaca ndorimo aŋgɨra punica mbendeirena, na meik ndeidapa Iesusna aem Mariaapa mana laipitik, mitoco memetmbaca kɨpca minap tɨkca mbendeirena. ");
INSERT INTO gai_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Na an mɨnna kɨpca puniatna, Iesusa rɨpacrena laiplacarta ŋgaŋganŋgɨa 120na mɨn. Ri, Pita mina rɨkca wɨtɨkca minmo gaindopatna, ");
INSERT INTO gai_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Min aukna laiplacar, Ŋeroŋ Ratta Dewitmo iro neaŋga ma atu ndopatna kambca, Raraŋ Aetaniacna Timbigta Kapna inik ndeacrena kambca, ma Iudasna kam ndopatna. An ramoot Iudas, ma or ikca mina kɨpca Iesusmo utiŋgatna. Dewitta aindopatna kamna gagamma ma amna reac aŋgɨnandet, na mandeaca mana gagamma ande ma malaruri. ");
INSERT INTO gai_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Na an ramoot Iudas, ma aiap aiŋ kabea morina tumbunna ramoot ian, ŋgaua ma toco ma ai aŋgɨrca morina aiŋna aiŋa morina ramoot ian.” ");
INSERT INTO gai_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Karica an ramoot Iudasa ndo moatna tɨp ŋgoreacna aiŋna opoikna kituknduk aŋgɨca, an mbuŋa pitrik waŋ emtem ŋgoikca. Iŋmbaia ma an pitrik ŋgirikca keca gadaup titaca mimuŋapa larkamapa an pitrik mairikat. ");
INSERT INTO gai_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ainda moca iŋmbaia Ierusalemna inik ndeacrina meikramtaɨr, mina muruŋa an kam anna waraca malamŋiat. Ainda moca mina ndorita auŋna kam mbuŋa an pitrik umbummo gaind ŋgacrina, Akeldama. An i Akeldama mana mɨnɨŋa gaind, “Racaindta Pitrik Umbum.” ");
INSERT INTO gai_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Karica Pita gaind mac mbopatna, “An kambca mina Ŋaparta timbigta kapna inikca tirca eacrena kambca gaind, ‘Mana eacatna kac mananna kabena ramoot ianna mana kaca kai aŋgɨ teac, an kaca watcarica ma wanaiŋ ndeac, na u an kacmo kai watcarica ramoot ianna kai aŋgɨ teac.’ Na an timbigta kapna kam tɨp ian toco gaind mac mbopatna, ‘Kabena ramoot ianmo watcarica ma mana taup rutica ma morina aiŋ aŋgɨca mo.’ ");
INSERT INTO gai_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Aintik aia mandeaca Kacoot Iesusa aina inikca aiap eacri, memetmbac taŋ kɨp tɨkrina, ramtaɨrta ianna watca manmo larapaca, ma Iudasna taup aŋgɨ. ");
INSERT INTO gai_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Na an larapacna ramoot, ma Ionna mandeb ŋgepca meikramtaɨrmo kɨtac pukca moatna aiŋapa, Iesusna aiŋa mandeba aŋgɨra ŋgepca, moa kɨpca Raraŋ Aetaniacna ŋganŋgɨatna mɨn ndaruri, Raraŋ Aetaniaca manmo aŋgɨca ma ai tɨkcarica tamuŋna auŋ naaŋgɨca magat, na an reikca watatna ramoot ianna, aia ainta ramoot larapaca, ma ai ŋgotaca Iesusna menaca mac nda ŋgepatna kam wembaŋ laŋ wiwitina.” ");
INSERT INTO gai_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Pita aindopatke, mina ŋgepca ramoot mbuniŋmo lamarapacat ianna Iosep, mana i ianna Barsabas, na mana i ian toco Iastus. Na ramoot ianna ia Matias. ");
INSERT INTO gai_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Karica mina gaind mambendeiat, “Kacoot, u gan ramtaɨrta iroar inkar teacrena landamŋiara, u malamŋireke, gan ramootniŋmo u ndo maniŋmo, aimo ian wandaca mbop. ");
INSERT INTO gai_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Te, ma up aŋgɨrena ramoot ian ndaruca, Iudasna taup aŋgɨna. Iudasa an aiŋ an tɨkcarica. Na ma taŋga ndona eacrina auŋ, an mac nda mataŋri.” ");
INSERT INTO gai_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ri, mina ŋgepca matɨp rocot, na gegerei ian tocna gegerei nagereica wattatnanna, Matiasa ndo aŋgɨatna mbatca, mina manmo aŋgɨra parniŋapa mbut kabe ndeacrena up aŋgɨrena ramtaɨrta inik matɨkat. ");
INSERT INTO gai_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pentikosna ra aniac laruatke, Iesusna up aŋgɨrena ramtaɨra muruŋcamiŋa kɨpca taup kabea punica eacri. ");
INSERT INTO gai_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Na tamuŋna auŋa mɨtmɨt ianna anduna ndaruatke, mina waracatnanna, anna ma aigogomna mɨtmɨtna kirar toc nakɨpatnanna, mina mbiraca eacrina an kacna inikmo kocnaia neaŋga gararamacariat. ");
INSERT INTO gai_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ri, mina wattatnanna, reac ianna tacna kirar toc, ndaruatke, anna inikca tacna mim tocna reikca titaca an inik ndaruca mina watri, an tac tocna mimma mina kabe, kabemo muruŋ mairikat. ");
INSERT INTO gai_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ainda moca minmo muruŋa Ŋeroŋ Ratta mbukca mɨnna tɨkca, na mina ŋgepca auŋembta kambca muruŋ mambopri, anna Ŋeroŋ Ratta minmo gargar neaŋga, minmo kabena auŋembta kamb puŋ topna moca. ");
INSERT INTO gai_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Na Raraŋ Aetaniaca rɨpacrina Iudana meikramtaɨr ndeida, gan tiacarpaikna pitrik waŋgorta auŋemb ŋgetacndiŋ nakɨpca mina muruŋa Ierusalem ndeacrina. ");
INSERT INTO gai_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Na an mɨtmɨt aniaca laruatna mɨnna, meikramtaɨra mina muruŋa anna waraca, anna wat ndopca kɨpca mapuniat. Na mina kour ikca waracri, Iesusna up aŋgɨrena ramtaɨr mbopatna kambca, an kɨpca puniatna auŋembta auŋ kabe, kabena kamb puŋ toprina, ri, mina waracatnanna mina kam ŋgoin. Ainda moca mina ŋgep ŋgoreac naŋgepca tamtam ndamŋirina. ");
INSERT INTO gai_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Karica an Iudana meikramtaɨra anna watca ŋgep ŋgoreac naŋgepca, aindopatna, “An ramtaɨra muruŋa Galili niŋgiknan ki? ");
INSERT INTO gai_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Kaica aia waracapeke, mina aina auŋemb kabe, kabena kamb koind puŋ ndopapekna. ");
INSERT INTO gai_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Wat, aia pitrik kabe ŋgetacndiŋa mba kɨpri. Aina gan inikna meacramoot kabe, kabea, aia gan pitrikartiŋ nda kɨpatna, aina ndeida pitrik Partiapa, Midiapa, Elamnan. Na aina ndeida aia gan pitrikartiŋ toco kɨprina, Mesopotemiapa, Iudiaapa, Kapadosiaapa, na Pontusapa, Esiana pitrikap an ŋgetacndiŋ nakɨprina. ");
INSERT INTO gai_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Na pitrik Pirigiapa, Pampilia, na pitrik Isipap, na pitrik Libia ma mon Sairini auŋ aniaca rambuŋaia eacrena, na aia Romna meikramtaɨr toco, aia muruŋ nakɨpca gan ndeacrina. ");
INSERT INTO gai_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Aia Iudanandapa Iudana meikramtaɨr wanaiŋa muruŋa ndorita iroar ŋgetrikica, Iudana rɨpacrina rɨtɨpaca raŋgairi. Aina ndeida mon mut Kiritapa pitrik Arebianan, aia muruŋa waracri, mina aina auŋembta kamb puŋga Raraŋ Aetaniacna morina reik anikta kamb topri, aia waracatna.” ");
INSERT INTO gai_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ainda moca mina ŋgep ŋgoreac naŋgepca, iroara tamtam ndamŋica ndori puŋga aindopatna, “An laruapekna reaca, anna kaina reacna mɨnɨŋ?” ");
INSERT INTO gai_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ri, mina ndeida minmo piria mbopca gaindopca, “Anna mina wain puik amba, amba paŋaind roreca mboprena kamb.” ");
INSERT INTO gai_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Karica Pita up aŋgɨrena ramtaɨr 11na mɨnpaikap wɨtɨkca, ma kam aniac ŋgoin mbuŋa meikramtaɨrmo aindopatna, “Ne Iudanandapa, an kɨpamaica gan Ierusalem ndeacrena meikramtaɨr, ne gan laruapekke, ne watapekna reikta mɨniŋga, aku mbop te, ne kour ikca matau warac. ");
INSERT INTO gai_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ne an ramtaɨrmo anmo ŋaŋaoraŋ ndopat ki? Wanaiŋ ŋgoin, mina wain pukca mba amba ŋaŋaoreke, na mandeac ŋaŋarmuŋa, rana ŋgaŋganŋgɨa 9na mɨn niŋgik. ");
INSERT INTO gai_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Gan reaca mandeban ndaruapeknan atua an reacmo ramma morina ramoot Ioela, mana kammo, ma gaindopatna, ");
INSERT INTO gai_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Raraŋ Aetaniaca aindoprina, “Maica gan tiacarpaikna mamamaia kɨpi rambuŋai te, aku ndona Ŋeroŋ Ratmo, meikramtaɨr tambatmo muruŋcamiŋa kactacnandet. Te, nena nuikapa momboura, rambca moa mboprina ramtaɨrta kirarir toc ndaruca aukna kam ndopnande. Te, ramtaɨr ŋgaibi manmbɨanmemraŋ, tocna tamram mbuŋ mbatnande, te, ramtaɨr bagrara, tamram mbuŋ mbatnande. ");
INSERT INTO gai_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Na an mɨn toco, aku ndona mbaiŋna aiŋa morena ramtaɨrapa meikmo ndona Ŋeroŋ Ratmo min nambatta kactac te, mina aukna kammo atuna rambca moca mboprina ramtaɨrta kirarir toc ndopnandet. ");
INSERT INTO gai_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Te, aku ainta ŋgagatracarmo riac tamuŋa tɨki laru te, aku gan ŋgagatracarmo tiacarpaik wɨkɨnna tɨki larunandet. An reikta ŋgagatracara, racaindpaikapa tacapa tactuor aniaca gan tiacarpaik ndarunandet. ");
INSERT INTO gai_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Te, ra kocnai nenepucari te, karwaia kocnai laupcarica racaindpaik toc ndacarinandet. Na iŋmbai ŋgoinna Kacootna ra aniac ŋgoinna larunandet. ");
INSERT INTO gai_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","An mɨnna, meikramtaɨra muruŋcamiŋa Kacootna i ŋgac te, ndori kotacna digi te, ma minmo mac nda aŋgɨca mina mba ŋgocraiitndai.”’ Na an kambca ramma morina ramoot Ioel, ma an ndopatna.” ");
INSERT INTO gai_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Na Pita ma gaindopatna, “Ne Israelnaŋgepta meikramtaɨr, ne aukna gan kammo, kour ikca matau warac. Aku nemo gan Nasaretna ramoot Iesusna kam ndop te, ne warac. Ne ndori waracatke watatna, Raraŋ Aetaniacna moatna reik anikta aiŋir anikapa, mana moatna ainta ŋgagatracara, ma Iesusna para tɨkca ma nena rɨkmo ndoa watrapaca aindopna moca, ‘An ramootta Raraŋ Aetaniac mbagɨrica kɨpatna ramoot.’ ");
INSERT INTO gai_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Na an ramootmo, nena para tɨkatnan. Na an ramootmo, Raraŋ Aetaniaca atu ŋgoinna ma lamŋiatna, ma manmo ainda mo ndopca, ma kam leaca maica nena para tɨkatna. Te, ne mamo aŋgɨra ramtaɨr ŋgorikta par matɨkat, na mina manmo ik naaŋgɨra keraca ma mamenacat. ");
INSERT INTO gai_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Te, Raraŋ Aetaniac, ma manmo mba an memenacna taup ŋgoreaca mba wattacarica ma mba anna mba mac eacatke. Na memenaca ma gargar kocor ma an ramootmo mo menacna towanaiŋ. ");
INSERT INTO gai_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Aintik Dewit toco atua ndomo aindopatna, ‘Aku Kacootmo watreke, ma aukna kɨtɨmmo memetmbaca aukap eacreke, na ma aukmo moa gagrarenan, aintik reac ianna aukmo moi nanambi te, na moi rugut mona mɨnna wanaiŋ. ");
INSERT INTO gai_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ainda moca aukna iro inikca toŋtoŋ aniac laruca, aku kam toŋtoŋ ŋgoinna, aindopnandet. Aku Raraŋ Aetaniacna ndabirena, ma aukmo reik laiŋga monande. ");
INSERT INTO gai_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ainda moca u aukmo mba watcarica, aukna ŋeroŋa an meikramtaɨrta menaca eacrena taupca mba eacitndai. Na ramootmo u babuca, ma una ramoot rat ndarurina ramootta, u mamo mba watcarica ma an menaca kotrena taupca mba eacitndai, wanaiŋ ŋgoin. ");
INSERT INTO gai_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","U aukmo iarwar ndeacna auŋ laŋna taupca u aukmo wandaca mamairi. Ainda moca u aukmo watcarica aku unap eac te, u aukmo moca aku iarwar ndeteacna toŋtoŋ bagaraniaca, memetmbaca aukap eacraŋnandet.’ Na gan kambca Dewit mbopatna kam.” ");
INSERT INTO gai_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Karica Pita gaindopatna, “Min laiplacar, aku nemo wandoŋ ŋgoinna aindopnande, aina nicau Dewit. Ma menaca mina manmo mamutocri. Mana mukca aiap maeacreke. ");
INSERT INTO gai_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Na Dewit tikca, ma Raraŋ Aetaniacna ramma morina ramoot ian. Aintik Dewit, ma lamŋirina Raraŋ Aetaniacna babuca mbopatna gan kamma, ma gidik ŋgoin ndopatna, ‘Iŋmbaia aku una mombonikta ianmo aŋgɨri gagrirta ramoot paŋan naaŋgɨri wɨtɨkca, ma una kirar toc ndarunande.’ ");
INSERT INTO gai_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Aintik Dewitta an Raraŋ Aetaniacna mbopatna reikta kammo, ma atuna ndamŋiatna, mamo Raraŋ Aetaniaca mba watcarica ma memenacna taup inikca mba eacitndai, na mana waɨra mba kotitndai. Na Dewit, ma an kam ndopatnanna, ma mba ndonake, mba mbopatke, wanaiŋ. Raraŋ Aetaniaca mo ndopatna reikmo, ma atuna ndamŋiatna. Ainda moca ma an ramootna kamma ma an ndopatna, an ramootta Raraŋ Aetaniaca babuca mbagɨrica kɨpca aimo mac nda aŋgɨna ramoot, ma muk ndiŋ mac nda ŋgepnandet. ");
INSERT INTO gai_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","An ramoot, ande Iesus. Raraŋ Aetaniaca manmo mukca tɨkca moa maŋgepat. Na aia muruŋa manmo muk ŋgetacndiŋ naŋgepatna iŋmbai mbuŋa aia manmo watatke, aia mana nda ŋgepatnanna aia ndorita lamnik puŋga watca, aia nemo anna wiwitia mboprena. ");
INSERT INTO gai_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Na Iesus tikca mandeaca Raraŋ Aetaniaca mamo aŋgɨa gaca ndona tamuŋna auŋa, ma mana par umbai maeacreke. Aintik atua Raraŋ Aetaniaca mamo neaŋ ndopca babuatna Ŋeroŋ Ratta, ma mamo neaŋga ma muruŋcamiŋa kactaca, ne waracatke, na mawatat. ");
INSERT INTO gai_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Na Dewit, ma tamuŋna auŋa Iesus gacatna kirar toca mba gacatke. Na ma aindopatna, ‘Raraŋ Aetaniac Kacootta ma aukna Kacootmo gaindopatna, “U aukna par umbaia mbirac te. ");
INSERT INTO gai_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Aku una puŋnaŋgepmo, una kaŋgaukca tɨknande.”’ ");
INSERT INTO gai_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Aintik ne Israelnaŋgepca ne gaind ŋgoinna matau lamŋi, an ramoot Iesusmo, ne manmo aŋgɨra ik naaŋgɨa keracatnanna, mandeaca Raraŋ Aetaniaca manmo aŋgɨrca Kacoot ŋgacrina, na an ramoot, ma Raraŋ Aetaniaca babuca mbagɨrica kɨpca aimo mac nda aŋgɨna ramoot.” ");
INSERT INTO gai_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ainda moca meikramtaɨr wɨt aniaca Pita mbopatna kam mbaraca, an kamma mina iroar inkarca rɨŋri. Mina ŋgepca Pitaapa up aŋgɨrena ramtaɨrmo gaind madigiat, “Min laiplacar, ainda mo te, aia tida moit?” ");
INSERT INTO gai_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ri, Pita minmo gainda nda rutica mambopat, “Ne muruŋcamiŋa ramoot kabe, kabea, ne ndorita iroar inkar ŋgetrikica, Iesus Karaisna i mbuŋa kɨtac puk aŋgɨ te, Raraŋ Aetaniaca nena tɨpemb ŋgorikta makukara, ma mo kecarinandet. Ne ainda mo te, Raraŋ Aetaniaca nenmo Ŋeroŋ Rat neaŋnande. ");
INSERT INTO gai_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ŋgaua Raraŋ Aetaniac baburina Ŋeroŋ Ratta ma nenapa nena mombonikapa mon tawanna auŋembta meikramtaɨrap, ma ndo aca kɨpekna meikramtaɨrmo ma Ŋeroŋ Ratta neaŋnande.” ");
INSERT INTO gai_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ri, Pita minmo kabena kamb ndeidap mbopca maica, ma minmo kam gargar ŋgoinna gaindopatna, “Ndorita ŋginaŋa matau mo, te, ndoritake wat, moca ne toco, an tɨp ŋgorikca morena meikramtaɨrap ŋgocrai nari.” ");
INSERT INTO gai_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ri, Pitana mbopatna kambca meikramtaɨr wɨt anikta iroar inkara rɨŋga, mina puk mbuŋa kɨtac puk maaŋgɨrat. Na an ra ndaruca Iesusa rɨpaca eacrena wiwitta mbukatna meikramtaɨrta ŋgaŋganŋgɨa, 3,000na mɨn toc malaruat. ");
INSERT INTO gai_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","An kɨdrɨkca meikramtaɨra up aŋgɨrena ramtaɨrta riptia mataua waracri, na mina ndorita reikmo ndorimo otacrina, ri, mina ndorimo aŋgɨra punica tapac rɨmbɨtca ndorimo biŋaica ambrina, ri, mina Raraŋ Aetaniacmo mambendeiri. ");
INSERT INTO gai_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Na Iesusna up aŋgɨrena ramtaɨrta para tɨkca ainta ŋgagatracara mori, meikramtaɨra muruŋa an ŋgagatracara watta maica, mina rugdar mamori. ");
INSERT INTO gai_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ainda moca meikramtaɨra Iesusa rɨpaca eacrenanna, memetmbaca mina muruŋa ndorimo aŋgɨra, punica eacrina, ri, mina ndorita reikmo ndorica biŋaia maaŋgɨri. ");
INSERT INTO gai_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Karica, mina ndorita pitrikar waŋgorpaikembapa, ndorita tɨkca eacrina reikmo mbik tɨkca oikrina taupca tɨkca meikramtaɨra oikri, mina an kitukndukar aŋgɨca, an koteterina meikramtaɨrmo, an kitukndukar biŋaica mina an puŋga reik maoikri. ");
INSERT INTO gai_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Na an rɨpacrina meikramtaɨr, memetmbaca mina ndorimo Raraŋ Aetaniacna Kacna wuocna inikca tɨkca aŋgɨra punireke, ndorita kaikmo ian ianna tɨkreke, amba taŋreke, toŋtoŋ bagaraniac ŋgoin, ainda moca mina ndorimo aind naaŋgɨra punica aind ŋgambca taŋrena. ");
INSERT INTO gai_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Na memetmbaca mina Raraŋ Aetaniacna i aŋgɨra ŋgepreke, meikramtaɨra minmo ainda morenanna moca, mina toŋtoŋ ŋgoin. Na Kacootta ra kabe, kabena inikca ma meikramtaɨrmo mac nda aŋgɨrena, ma ainda moreke, mina Iesusa rɨpaca eacrena tumbunna mbukreke, Iesusa rɨpacrena tumbunna ŋgaŋganŋgɨa kunda tamuŋ ŋgoin magareke. ");
INSERT INTO gai_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Oit ianna, wigwac mbuŋa, rana ŋgaŋganŋgɨa mbonkacna mɨnna tɨkatke, Pitaapa Ionna Raraŋ Aetaniacna Kacna wuocna inikca mbendeina moca mataŋgat. ");
INSERT INTO gai_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Maniŋa taŋga laruca wattatnanna, meikramtaɨr ndeida ramoot ianna orniŋa menaca eacrina ramootap aŋgɨca makɨpat, na memetmbaca mina an ramootmo ra, ra katuca aŋgɨa kɨpca ma an Raraŋ Aetaniacna raekmbaina Kacna wuoc aniacna tɨŋa tɨkca ma an ndeacraŋ te, watraŋnande. Na an tɨŋna ia Tɨŋ Taror. Meikramtaɨra Raraŋ Aetaniacna Kacna wuocna inikca mbukna kɨp te, ma minmo kitukndukarta runande. Na an ramoot, mana orniŋa aemna nikinikca tɨkca ŋgocraica, mana aemma mamo ainda mɨratna. ");
INSERT INTO gai_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Na an ramoot, ma Pitaapa Ionna watca, maniŋa Raraŋ Aetaniacna Kacna wuocna inikca mbukna taŋgatke, ma maniŋmo kitukndukna maruat. ");
INSERT INTO gai_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Na Pitaapa Ionna manmo mataua watikca, Pita aind mambopat, “U aŋga wat.” ");
INSERT INTO gai_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ri, an ramootta anmo maniŋmo ndomo reac ian neneaŋ ndopca watatke. ");
INSERT INTO gai_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ri, Pita aindopatna, “Aku kɨtcaɨrtukar kocor, na auk ndambuŋa reac ianna ndo maeacreke, aku unmo neaŋnande. An reaca aku umo Nasaretna ramoot Iesus Karaisna i mbuŋa aindopnande, u ŋgepca taŋ.” ");
INSERT INTO gai_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Aindopacarica Pita mamo otaca mana gagar umbai ŋgutiŋga manmo aŋgɨra ŋgepca wɨtɨkatke, tawi ŋgoin motemma mana ortɨmbɨkniŋapa ŋgorac mburmburniŋa laŋ mamoat. ");
INSERT INTO gai_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ri, ma putrikica ŋgepca wɨtɨkca maniŋap taŋga Raraŋ Aetaniacna Kacna wuocna inikca mbukca tamtam naaŋgɨra putriri, an inikca taŋ kɨp tɨkri, Raraŋ Aetaniacna imo aŋgɨra maŋgepri. ");
INSERT INTO gai_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ainda mori, meikramtaɨra muruŋa watri ma ŋgepca Raraŋ Aetaniacna imo aŋgɨra ŋgepri, tamtamma putririnanna watca. ");
INSERT INTO gai_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Mina malamŋiat, anna ande orniŋa menaca eacrena ramoot. Memetmbaca ma Raraŋ Aetaniacna Kacna wuocna inikca mbukca ma taŋga raekmbaina wuocna Tɨŋ Tarormo an ndeacrena. Na meikramtaɨrmo kitukndukarapa reikta rurena ramoot. Na mina watri ma laŋ mamori, ainda moca mina anna watca mina iroara tamtam malamŋiat. ");
INSERT INTO gai_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ainda moca meikramtaɨra ŋgepca an ramootta watna moca, muruŋa ootta kɨpca laruca wattatnanna, ma Pitaapa Ion mbaniŋmo muocameraca mina wacraet ndeacri, mina kɨpca laruca anna tɨkca mawatri. Na an wacraetna imo, mina gaind ŋgacrena, Solomonna wacraet. ");
INSERT INTO gai_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ri, Pita ainda watatke, ma meikramtaɨrmo gaind mambopat, “Ne Israelnaŋgepta meikramtaɨr, kaina moca ne an laruapekna reac mbatca ŋgep ŋgoreac naŋgepca, aŋmo wat gargar mbatek? Ne an reacmo gaind ki ndamŋire ki, aŋga ndoniŋna gargar mbuŋapa aŋna ndiarirta tɨpemb kirarir laŋ ki, manmo moa laŋa momo ndopat ki? Aintik aŋga manmo moa laŋa moca ma ndona orniŋ mbuŋa taŋre ki? Wanaiŋ ŋgoin, ne ainda kai lamŋi teac. ");
INSERT INTO gai_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Raraŋ Aetaniac, ma Abraamapa, Aisakapa Iakopap, ma mina Raraŋ Aetaniac, na an Raraŋ Aetaniac, ma aina an ŋgamrirta Raraŋ Aetaniac. Aintik ma ndona aiŋna Ramoot Iesusmo, i aniac neaŋgatna. Ande an ramootmo ne mamo aŋgɨra puŋnaŋgepta para tɨkca, Pailatta manmo watcarica ma taŋna moatke. Ne Pailatmo iŋ neaŋga wɨtɨkatke, gaindopatna, ‘U Iesusmo kai watcarica taŋ teac.’ ");
INSERT INTO gai_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Aindopatna ramootta, mandeaca ma Raraŋ Aetaniacna kaŋgauk ŋgoin maeacreke. Ma ramoot rat wandoŋ ŋgoin. Na ne Israelnaŋgepta meikramtaɨr, ne an ramootmo ne manmo iŋ neaŋgatke, ne Pailatmo aca mambopat, ‘U ramootta rɨŋga menacatna an ramootmo ai ndambuŋa mbagɨrica kɨp.’ ");
INSERT INTO gai_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Na aimo iarwar ndeteacna taup naaŋgɨri laruna ramoot laŋmo, ne aŋgɨra manmo moa mamenacat. Ri, Raraŋ Aetaniaca manmo muk inikca tɨkca mac nda moa ŋgepatke, aŋga anna watca nemo an reacna kam wiwitia mboprenan. ");
INSERT INTO gai_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Na aŋga Iesusa rɨpacrina ramootniŋ, aintik Iesusna ina gargar mbuŋa, gan nena lamŋirena or ŋgoreacniŋna ramootta moa laŋa moapekna. Iesusa ndo aŋna rɨtɨpaca moa paŋpaiŋiri, an rɨtɨpaca ndo an ramootmo moca ma laŋa moapekna. Ainda moca mandeaca ne mamo aind mawatca. ");
INSERT INTO gai_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Min laiplacar, anna gidik, aku lamŋirina ne ainda ŋaŋari lamŋi ŋgocor tik, nenapa nena ramtaɨr paŋaindap, ne Iesusmo ainda moatna. ");
INSERT INTO gai_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ainda moca atua Raraŋ Aetaniaca an kambmo rambca morina ramtaɨrta iroar inkara tɨkca, mina an ramootna kambmo aindopatna, Raraŋ Aetaniaca babuca mbagɨrica kɨpca aimo mac nda aŋgɨna ramootta, ma gɨrgɨr aŋgɨnande, aindopatna kamma, mandeaca ne an ramootmo ainda moapeke, Raraŋ Aetaniaca ndona mbopatna kambmo moa mɨn matɨkca. ");
INSERT INTO gai_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","“Aintik mandeaca ne ndorita iroar inkar ŋgetrikica, Raraŋ Aetaniaca raŋgai te, ma nena tɨpemb ŋgorikta makukarmo ma mo kecarinandet. ");
INSERT INTO gai_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ne ainda mo te, Kacootta ma nenap eac te, ma nenmo wɨktɨtɨk laŋapa gargar neaŋnande. Na an ramoot ŋgaua Raraŋ Aetaniaca babuca mbagɨrica kɨpca aimo mac nda aŋgɨna ramoot. Ande an ramoot, Raraŋ Aetaniaca manmo larapacatna, ma Iesus. ");
INSERT INTO gai_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Aintik mandeaca ma tamuŋna auŋ maeacreke, ma Raraŋ Aetaniacna ŋganŋgɨrina, an rana moca malambireke, an ra laru te, ma an reikmo mac nda moi ŋgaib tarunande. Ainda moca ma atua ndona an reik lataruna kamb topna moca ramtaɨr ndepik larapaca mina rambca morina ramtaɨr taruatke, ma minmo ndona aiŋ anna mona moca, an kambmo mina upembca tɨkca mbopca laruatna. ");
INSERT INTO gai_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","“Na atu ŋgoinna Mosesa gaindopatna, ‘Nena Kacoot Raraŋ Aetaniac, ma nena barna ianmo ma larapacnande, na ma aukna kirar tocna ramma morena ramoot ndaruca, ne mana mbopekna kambca waraca ne an kambmo kocnai raŋgairaŋ. ");
INSERT INTO gai_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Na meikramtaɨra mandaia an ramma morena ramootna kam mbarac ŋgocor, Raraŋ Aetaniaca minmo kocnai mo topnandet. Te, mina Israelnanta inikca mba mac eacitndai.’ ");
INSERT INTO gai_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Na atua Raraŋ Aetaniacna ramma morina ramoot Samuelna mɨnapa mana iŋmbai ndaruatna rambca morina ramtaɨra, muruŋa gade mandeban ndaruapekna reacna kamma mina anna ninirena. ");
INSERT INTO gai_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","“Ne an rambca morina ramtaɨrta mombonik ŋgamrira, Raraŋ Aetaniaca nena nicara neaŋ ndopca minap kam leaca gagara moatna reikca ne aŋgɨnande. Ma Abraammo gaindopatna, ‘Una rɨmbɨnna nuoc mbuŋ tik, aku gan tiacarpaikna meikramtaɨrmo muruŋ ŋgotacnande.’ ");
INSERT INTO gai_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ainda moca Raraŋ Aetaniaca ndona an aiŋna ramootmo larapaca manmo nen ndambuŋmo outmbaica mbagɨrica ma kɨpatna, nenmo otaca nena tɨpemb ŋgorikmo kabe, kabe naŋgetrikina moca.” ");
INSERT INTO gai_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Karica Pitaapa Ionna meikramtaɨrmo Raraŋ Aetaniaca mbopatna kamb topca eacrinan mbuŋa, taup ndamtaɨr ndeidapa, Sadisina tumbunna ramtaɨr ndeidapa, Raraŋ Aetaniacna Kacna wuocna inikna ŋginaŋa morena lapoca ruŋrena ramoot paŋanap, mina muruŋa maniŋ ndambuŋ makɨpat. ");
INSERT INTO gai_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Mina gaind ndamŋiatna, maniŋa meikramtaɨrmo gainda riptiatna, Iesusa menaca mutocatnanna ma mac nda maŋgepri, na an menaca mutocrena meikramtaɨra mina Iesusa mac nda ŋgepatna kirara mitoco, aind mac nda ŋgepnande. Aintik mina maniŋmo nikembkatacarica, ");
INSERT INTO gai_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","mina ŋgepca maniŋmo utiŋga, maniŋna mbopatna kambca ritri waparac ndopca moatnanna, ra maiatna mbatca, mina maniŋmo kac ŋgoreacna inik naaŋgɨra mbukca tɨŋ kaptikica leaca tɨkcamacariat. Na ŋorapmbai te, mina maniŋna kambca waracnande. ");
INSERT INTO gai_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Na an meikramtaɨr wɨt aniaca, maniŋna mbopatna kam wembaŋ laŋa waraca, Iesusa rɨpacatna. Na ramtaɨrta ŋgaŋganŋgɨa 5,000na mɨn malaruat. ");
INSERT INTO gai_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Karica kabena ra mbuŋa Iudana ramtaɨr paŋaindapa, minmo outmbaica taŋrina ramtaɨr paŋaindapa, Iudana tɨpemb wandik tamŋirena ramtaɨrap, mina muruŋa Ierusalem mapuniat. ");
INSERT INTO gai_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ri, taup ndamoot paŋan aniac, Anasapa mana barna taup ndamtaɨra an makɨpat, na an ramtaɨra ande, Kaiapasapa, Ionapa Aleksanderap, na mina barna taup ndamtaɨrta tumbunna ramtaɨr ndeidap, mina muruŋ nakɨpca punica maica. ");
INSERT INTO gai_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Karica mina an up aŋgɨrena ramootniŋ, Pitaapa Ionmo, aŋgɨra larua an ramtaɨr paŋaindta lamnik ŋgoutta wɨtɨkca, mina maniŋmo aind madigiat, “Oŋgo titocna gargar aŋgɨca, an reikmo ainda moca taŋrenan? Oŋgo mandaina i mbuŋa ainda moca mbopca taŋrenan, a?” ");
INSERT INTO gai_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ri, Pitamo Ŋeroŋ Ratta mbukca mɨnna tɨkca ma minmo aindopatna, “Ne Israelnaŋgepta ramtaɨr anikapa ramtaɨr paŋaind, ");
INSERT INTO gai_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ne mandeaca gan aŋga otacapekna or ŋgoreacna ramootna digia, anna landamŋi aŋgɨna morena. Ne ndorimo mana landamŋi aŋgɨna moca, ma tida moapeke ma laŋa moapekna. ");
INSERT INTO gai_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Aind, nenapa Israelnanda, ne muruŋcamiŋa gaind ŋgoin ndamŋi, gan or ŋgoreacna ramoot, ma Nasaretna ramoot Iesus Karaisna i mbuŋa ma laŋ mamori, mandeaca ma nena meacramoot muruŋna lamnɨacmo, ma ŋgepca wɨtɨkatna. Na an ramoot Iesus, ne manmo aŋgɨra ik nakeraca ma menacatnanna, Raraŋ Aetaniaca manmo mac nda mukca tɨkca moa maŋgepri. ");
INSERT INTO gai_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Na an ramoot Iesus ma kaca morena wautna wit ian, na an wautna witta kaca morena ramtaɨra anmo ŋgoreac ndopca aŋgɨra roumbmbai nakecarica eacrena wautta, mandeaca ma kacna witta moca paŋanmbaia wɨtɨkca gagraca maeacreke. ");
INSERT INTO gai_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Na ai mac nda aŋtaŋgɨna ramoot ian ŋgocor. Wanaiŋ ŋgoin. An ramootta Iesus niŋgik, Raraŋ Aetaniaca mamo babuatna, man niŋgik, ma ndo ai mac nda aŋgɨnande. Mana i mbuŋa aia gan tiacarpaikna meacramootta, muruŋa mataui eacna mɨn.” ");
INSERT INTO gai_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ainda moca ramtaɨr paŋainda malamŋiat, Pitaapa Ion mbaniŋa landamŋi aŋgɨrena taup ianna taŋga anna ripti ianna aŋgɨ ŋgocor, aintik maniŋa landamŋiar kocorta ramootniŋ. Na mina watri, maniŋa rugutta mo ŋgocor, maniŋna mboprina kambca gargar ŋgoin, ri, mina tamtam ndamŋia taŋga malamŋiat. Ŋgaua maniŋa Iesusap eacrina ramootniŋ. ");
INSERT INTO gai_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ri, mina wattatnanna, an moa laŋa moatna ramootta Pitaapa Ionap wɨtɨkca eacri. Na mina maniŋmo nda ruti, mbopna kamb kocor. ");
INSERT INTO gai_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ainda moca an ramtaɨr paŋainda maniŋmo aindopatna, “Oŋgo gan kambca ritri waparacrena kacna inik tɨkcarica raekmbai pac laruca lambi.” Aindopca maniŋa taŋgatke. Mina kam leaca aind mambopat, ");
INSERT INTO gai_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Aia an ramootniŋmo tida tɨki moit? Maniŋa ŋgagatrac ianna Ierusalemma tɨkca moa laruapekke, meikramtaɨra muruŋcamiŋa anna watta mamairi, na aia minmo wawri mbopna towanaiŋ. ");
INSERT INTO gai_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ainda moca an kammo, ŋarikca meikramtaɨr muruŋa warac nari. Aintik aia maniŋmo gagra mbopca maniŋa kai kabena meikramtaɨrmo Iesusna i mbuŋa reikta kambca kai mac nini mbopi taŋ teac, kari ŋgoin ndacari.” ");
INSERT INTO gai_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Karica mina maniŋmo aca kɨpca maniŋmo wandɨk matɨkat, oŋgo kai Iesusna i mbuŋa meikramtaɨrmo an reikta kambca kai riptica mbop teac. ");
INSERT INTO gai_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ri, Pitaapa Ion, maniŋa mina kammo gainda nda rutica mambopat, “Ne titoc ndamŋire, titna tɨp kirara ndo Raraŋ Aetaniacna lamnɨacmo laŋ ndaruit? Aŋga Raraŋ Aetaniacna kam mbarac naki, co, aŋga nena kam mbaracit, ki? Ne ndori an kamniŋmo ritrica wat. ");
INSERT INTO gai_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Na aŋga mba mac karitndai, aŋga ndoniŋ watri, waracrina reikta kambca, aŋga memetmbac ndopca taŋraŋnande.” ");
INSERT INTO gai_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","22","Karica ninik waŋgorta ramtaɨra maniŋmo kabena kam gargar mbuŋa mac tagagarica mbopacarica, mina meikramtaɨr tarica rugut mocarica mina maniŋmo wattacarica maniŋa mataŋgat. Na an ramoot, maniŋa man mbuŋa ŋgagatraca moatna ramoot, mana guiarpaika 40na mɨn mbuŋ, ma an or ŋgoreacna roumbap eaca kɨpca guiarpaika 40na mɨnna tɨkatke, maniŋa manmo moa laŋa moatna. Ri, meikramtaɨra an Raraŋ Aetaniacna moapekna ŋgagatraca watca, mina muruŋ ŋgoinna mana i aŋgɨra ŋgepatke, na an ramtaɨr paŋainda maniŋa tɨki mona taupembtake, moa tambacarica toawanaiŋ. ");
INSERT INTO gai_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Karica ninik waŋgorapna ramtaɨra, Pitaapa Ionmo watcariatke, maniŋa nda taŋga ndoniŋna tumbun ndambuŋ ndaruca. Maniŋa minmo taup ndamtaɨr paŋaindapa, ramtaɨr paŋaind mbopatna kambca, minmo an maniniat. ");
INSERT INTO gai_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ri, mina muruŋa waraca maica, karica mina ŋgepca aŋgɨra iro kabea tɨkca Raraŋ Aetaniacmo gaind mambendeiat, “Gagrirta Kacoot Aniac, u riac tamuŋapa tiacarpaikapa, macaitapa min nambat ndeacrena reikca un moatna. ");
INSERT INTO gai_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Na aina nicau Dewit, ma una aiŋna ramoot, atua Ŋeroŋ Ratta, iro neaŋga ma kam ianmo gaindopatna, ‘Kaina moca Iudana meikramtaɨr wanaiŋa muruŋa nikemb katreke? Na kaina moca an meikramtaɨra tɨpemb ŋgorikca mona moca anna kamma wanaiŋa leacrena? ");
INSERT INTO gai_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Na gan tiacarpaik ndeacrena gagrirta ramtaɨr paŋainda ruŋna kocroca eacreke. Mina ramtaɨr paŋainda muruŋ naaŋgɨra punica, Raraŋ Aetanaic Kacootapa mana babuca mbagɨrica ndona meikramtaɨr mac nda aŋgɨna ramoot, mina maniŋmo ruŋna moca.’ ");
INSERT INTO gai_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Anna gidik ŋgoin, aintik Erotapa Pontius Pailatap, Iudana meikramtaɨr wanaiŋapa Israelnandap, mina muruŋa an auŋ aniac Ierusalemma punica Iesusa mo menacna moca lambirina, an aiŋna ramoot Iesus, ma una aiŋna ramoot rat, atua u mamo ndona aiŋa mona moca larapacatna ramoot. ");
INSERT INTO gai_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Na mina ainda moatna reikca anna mina una iroapa toŋtoŋ niŋgikca raŋgairena. Una gargar mbuŋa atu ŋgoinna u kam leacatna, an reikmo mo laru ndopatna. ");
INSERT INTO gai_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Aintik Raraŋ Aetaniac Kacoot, u mandeaca lamŋirina mina mboprena kambca, anna mina aimo moi nanambina ndoprenanna, u aimo una mbaiŋna aiŋa morena ramtaɨrmo otac. Te, aia mba nanambitndai, aia una kam wembaŋ laŋna kam ndopna moca paŋanmbaia mbukraŋnande. ");
INSERT INTO gai_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Te, u ndona gargarmo neaŋ te, meikramtaɨrmo, mo laŋa monande, u Iesusna i mbuŋa ŋgagatracara moi laruraŋ te, mina tamtam ndamŋiraŋnandet, ma una aiŋna ramoot, rat ŋgoin!” ");
INSERT INTO gai_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Mina mbendeia maiatke, mina punica eacrina kaca warak mamoat, ri, Ŋeroŋ Ratta minmo mbukca lacakeca, mina Raraŋ Aetaniacna kam wembaŋ laŋmo kam aniaca tɨkca mawiwitiat, na mina mba nanambiatke. ");
INSERT INTO gai_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Meikramtaɨra muruŋa Iesusa rɨpaceknanna, mina iroar inkara wewettar laiŋ ndeac te, iro kabe aŋgɨca iro landamŋi kabe ŋgoin ndeac. Te, mina kabe, kabena reikca mina ianna an reik mbatca gainda mba lamŋitndai, an reiki anna mannan. Wanaiŋ. Mina gaind ndamŋinande, an reikca anna mina muruŋcamiŋnan. ");
INSERT INTO gai_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ri, Kacoot Iesusna up aŋgɨrena ramtaɨra, mana nda ŋgeŋgepna kam wiwitiri, an kam minanna gargar bagaraniacap. Ainda moca Raraŋ Aetaniaca min ŋgopotacna toŋtoŋ bagaraniacap. Aintik ma minmo muruŋcamiŋmo reik laiŋga mataua morena. ");
INSERT INTO gai_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ainda mori, an meikramtaɨrta ianna mba amna reac nake, mba koteteri. Mina mandaia ndorita pitrikapnan, co kaikapnan, mina muruŋa an reikmo aŋgɨra mbik tɨkca oikrena taupca tɨkca mina oikca aŋgɨr te, minmo anna kituknduk neaŋ te. Mina an kitukndukar aŋgɨra kɨpca, ");
INSERT INTO gai_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","up aŋgɨrena ramtaɨrmo neaŋ te. Mina an kitukndukar aŋgɨca, an koteterina meikramtaɨrmo mabiŋaiat. ");
INSERT INTO gai_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ri, mina inik ndeacrina ramoot ianna, mana ia Iosep. Ma Liwainanta ian, ma Saiprus mutna ramoot. Na up aŋgɨrena ramtaɨra mana i Iosep ŋgetrikica, manmo i Banambas matɨkat. Na an i Banambas, mana mɨnɨŋa gan ina kirar, “Iroa moa Gagararena Ramoot.” ");
INSERT INTO gai_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ma ndona pitrik waŋ emtemmo mbik tɨkca oikrena taupca tɨkca ramoot ianna oikatna mbatca, ma an kitukndukar aŋgɨa kɨpca up aŋgɨrena ramtaɨrta par matɨkat. ");
INSERT INTO gai_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ramoot ian ma toco anna inik ndeacrenanna, mana ia Ananaias, na mana meacna ia Sapaira. Na maniŋa ndoniŋna pitrik waŋ emtemmo, mbik tɨkca oikrena taupca tɨkca ramoot ianna oikri. ");
INSERT INTO gai_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Na an kitukndukarta kitukndukna tɨpca Ananaiasa paruca ndo tɨp aŋgɨracariatke. Na mana meac Sapaira, mana kaŋgaitta ainda moatna tɨp kirara, ma toco ma lamŋirina. Ri, Ananaiasa paruca tɨp niŋgik aŋgɨrca kɨpca up aŋgɨrena ramtaɨrmo maneaŋgat. ");
INSERT INTO gai_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ri, Pita manmo gaind mambopat, “Ananaias, u tida mona moca Ramoot Mbɨkmo wattacarica ma unmo towairina, na u mana kamma waraca ma una iro inikca mbukca, u Ŋeroŋ Ratmo paruapekna, na u ndona pitrik waŋna kitukndukar aŋgɨca, ndo tɨp aŋgɨapekna? ");
INSERT INTO gai_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ŋgaua an pitrik waŋa anna unan, na u ndona toŋtoŋ mbuŋa mbik tɨkca oikrena taupca tɨkca kabena ramootta unanmo oikrico, u ndona an pitrik waŋna kitukndukarmo u ndona toŋtoŋna reikmo u an mbuŋa mo mbe. Na tida mona moca u an iro ŋgoreac aŋgɨca ainda moapekna? U ndomo ramoot wanaiŋ ianna paru ndopca paruapeknanna, wanaiŋ ŋgoin, u Raraŋ Aetaniac ŋgoin maparuca.” ");
INSERT INTO gai_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananaiasa an kam mbaraca ma anduna mamenacat. Na meikramtaɨra Ananaias ndaruatna reikta kam wembaŋ mbaraca, mina kocnaia rugdar moamacariat. ");
INSERT INTO gai_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ri, nuik ŋgaibca kɨpca mana waɨrmo raraŋit mbuŋa tamaia maica, mana waɨrmo aŋgɨra taŋga mamutocat. ");
INSERT INTO gai_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Na eaca kɨdrɨk rocot ŋgoinna wanaiŋ, Ananaiasna meaca kɨpca mambukat. Ma ndona kaŋgait ndaruatna reaca, ma lamŋi ŋgocor. ");
INSERT INTO gai_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ri, Pita manmo gaind mambopat, “U aukmo mbop, oŋna pitrik waŋ emtemna kitukndukca an niŋgik, ki?” Ri, mana meaca gaindopatna, “Nat co, anna gidik.” ");
INSERT INTO gai_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ri, Pita manmo gaind mambopat, “Kaica oŋgo kam leaca ndoniŋ ndopca maica Kacootna Ŋeroŋmo towaina moca oŋgo paruapekna? U warac! Una kaŋgaitna waɨr mutocrina nuik ŋgaibca, monde tɨŋ kam mambukreke. Mina una waɨr motocmo aŋgɨri taŋnande.” ");
INSERT INTO gai_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ri, an meaca Pitana or kɨtɨmma anduna kocnaia menaca matɨkat. Na an nuik ŋgaibca kɨpca mbukca wattatnanna, ma menaca tɨkca eacri, mina watca mana waɨrmo aŋgɨa larua mana kaŋgaitna muk roumb mamutocat. ");
INSERT INTO gai_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ri, Iesusna rɨtɨpaikta meikramtaɨrta tumbunapa raekmbai ndeacrena meikramtaɨrap, mina an laruatna reikta kamb mbaraca, mina muruŋa kocnaia rugdar moamacariat. ");
INSERT INTO gai_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Karica up aŋgɨrena ramtaɨra ainta ŋgagatracarmo, meikramtaɨrta kɨdrɨkca tɨkca mori. Na meikramtaɨra muruŋcamiŋ ŋgoinna Kacootta rɨpaca, mina muruŋa iro kabe aŋgɨca, mina muruŋa Raraŋ Aetaniacna Kacna wuocna inikca mbukca, Solomonna wacraet mapuniat. ");
INSERT INTO gai_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ri, mina an inik ndeac ŋgocorta meikramtaɨra, mina moatna reik mbatca mina iremb aŋgɨra maŋgepat. Na mina ndoria, mina rugdar mocarica, ainda moca mina, an mina inikca kɨpi mbuk ŋgocor. ");
INSERT INTO gai_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Na an meikramtaɨr wɨt aniac ŋgoinna, mina Iesusna kam mbaraca rɨpaca, mina kɨpca mana rɨtɨpacna tumbunnandap mambukat. ");
INSERT INTO gai_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ri, an meikramtaɨra up aŋgɨrena ramtaɨr morina ŋgagatracara watarapaca. Ainda moca mina ndorita roumbbebta meikramtaɨrmo aŋgɨra larua kɨpca, Pitana taŋrena taupembmo mbimbitamar keca, roumbbebta meikramtaɨrmo an mameracri. Mina lamŋirina Pita an ndiŋ nakɨp te, ra manmo aŋgɨ te, mana ninikna papaca minmo aŋgɨrnande. ");
INSERT INTO gai_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Na Ierusalem auŋ aniaca rambuŋaia eacrina auŋembta meikramtaɨr, mitoca kɨpca up aŋgɨrena ramtaɨrmo watrina. Aintik mitoco ndorita roumbbebta meikramtaɨrapa, ŋerŋgaur ŋgorikca mbukca moa ŋaŋaorina meikramtaɨrap aŋgɨa kɨpatnanna, an meikramtaɨra mina muruŋcamiŋa laiŋ mamoat. ");
INSERT INTO gai_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Karica taup ndamoot paŋan aniacapa mina Sadisina tumbunna aikorta ramtaɨrap, mina an up aŋgɨrena ramtaɨrta moatna reikca, watca mina minmo titkara morina. ");
INSERT INTO gai_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Mina ŋgepca an up aŋgɨrena ramtaɨrmo, utiŋca aŋgɨra taŋga tɨp ŋgoreaca morina meikramtaɨr eacrina, kac ŋgoreacna inikna tɨŋ gootca, up aŋgɨrena ramtaɨrmo, minap an inik kabea tɨkca, tɨŋ kaptiki leaca tɨkcamacariat. ");
INSERT INTO gai_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Na eaca mouŋmbai mbuŋa Kacootna mbaiŋna aiŋa morena ŋeroŋ ianna kɨpca kac ŋgoreacna tɨŋ gootca minmo aŋgɨra laruca raekca tɨkca, minmo gaindopatna, ");
INSERT INTO gai_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Ne taŋca Raraŋ Aetaniacna Kacna wuocna inikca mbukca, anna wɨtɨkca meikramtaɨrmo iarwar ndeteacna watna kam an wiwiti mbop.” ");
INSERT INTO gai_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Karica up aŋgɨrena ramtaɨra, an kam mbaraca maiatna mbatca, ŋaŋarmuŋ ŋgoinna mina taŋga Raraŋ Aetaniacna Kacna wuocna inikca mbukca meikramtaɨrmo, an kam riptica eacrina. Na taup ndamoot paŋan aniacapa mana aikorap, mina kam neaŋga taŋga, Israelnaŋgepta ramtaɨr paŋaindmo muruŋa kɨp te, mina ninikar waŋgorta tumbunna mona. Mina kac ŋgoreacna ŋginaŋa morena piriŋmo mbopca taŋga, minmo up aŋgɨrena ramtaɨr aŋgɨ kɨpna moca. ");
INSERT INTO gai_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Karica piriŋga taŋga kac ŋgoreacna tɨŋ gootca wattatnanna, up aŋgɨrena ramtaɨra an inikca eac ŋgocor. Ri, mina mac nda taŋga ramtaɨr paŋaindta tumbunmo gaind mambopat, ");
INSERT INTO gai_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Aia watri mina an kac ŋgoreacna tɨŋmo kaptiki leaca maica, mina anna ŋginaŋa moa auŋ raruca, ŋaŋarmuŋa aia kacna tɨŋ gootca wattatnanna, an inikca meikramtaɨr kocor koind.” ");
INSERT INTO gai_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Na Raraŋ Aetaniacna Kacna wuocna inikca tɨkca aiŋa morena piriŋta ramtaɨrta ramoot paŋanapa taup ndamtaɨr paŋaindap, mina an kam mbaraca tamtam ndamŋiri, aindopca, “An ramtaɨra titoca taŋgapek? Na kaina reaca ndo laruit?” ");
INSERT INTO gai_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ri, ramoot ianna laruca, minmo gaindopatna, “Ne warac! An ramtaɨra, ne minmo aŋgɨrca kac ŋgoreaca tɨkca eacrenanna, mandeaca mina Raraŋ Aetaniacna Kacna wuocna inikca mbukca, wɨtɨkca meikramtaɨrmo kam mariptireke.” ");
INSERT INTO gai_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ainda moca mina outmbai ndeacrena piriŋta ramoot paŋanapa, piriŋgap, mina taŋga up aŋgɨrena ramtaɨrmo utiŋga laŋan naaŋgɨra makɨpri, na mina minmo kaega mba mori. Mina rugdar moca, ŋarikca meikramtaɨra minmo watur puŋga rɨŋ narica. ");
INSERT INTO gai_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ri, piriŋga an up aŋgɨrena ramtaɨrmo, ninik waŋgorta ramtaɨrta out naaŋgɨra larua wɨtɨkatke. Na taup ndamoot paŋan aniaca minmo gaindopatna, ");
INSERT INTO gai_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Aia nemo an ramootna i mbuŋa moatna reikta nininimo, an meikramtaɨra ripti narica, anna wandɨk tɨkatna. Na ne an kammo, aimo an ramootta rɨŋ memenac ndopca aimo anna tuk tɨkca. Na ne meikramtaɨrmo an kamma anduna riptica mbopca mataŋri. Na Ierusalemna inikna meikramtaɨra, an kammo kocnaia waraca mamaiat.” ");
INSERT INTO gai_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ri, Pitaapa up aŋgɨrena ramtaɨra, mina mana kammo nda rutica gaindopatna, “Aia Raraŋ Aetaniacna kam niŋgikca raŋgairaŋnande. Aia ramoot ianna kamma mba waraca raŋgaiitndai. ");
INSERT INTO gai_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ne Iesusmo ik naaŋgɨra keraca manmo rɨŋga menacatke, aina nicarta Raraŋ Aetaniac tamuŋnan, manmo mac nda moa maŋgepat. ");
INSERT INTO gai_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Mandeaca Raraŋ Aetaniaca manmo aŋgɨra gaca, manmo aŋgɨra ndona par umbai naaŋgɨra mbiraca maeacreke. Ma ndo aina ramoot paŋan, na ma ndo ai mac nda aŋgɨna aiŋ ndeacnande, te, ma ndo aimo Israelnaŋgepmo otaca aimo moi iroar inkar ŋgetriki te, aina tɨpemb ŋgorikta makukarmo moi kecarinandet. ");
INSERT INTO gai_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","An reikca aia Raraŋ Aetaniaca moatnanna watta maica. Ainda moca aia an reikta kambca ndorimo wiwitirena. Na Ŋeroŋ Rat toco an reikta kamb kaukica wiwitirena. Na Raraŋ Aetaniac, ma meikramtaɨra mana kam mbaracrenan, na raŋgairenanmo, ma Ŋeroŋ Rat neaŋrena.” ");
INSERT INTO gai_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","An ninikar waŋgorta ramtaɨra Pitana mbopatna kamb mbaraca, mina nikembkatca ŋgocraica, ndorimo up aŋgɨrena ramtaɨra rɨŋ menacna kam pia mboprina. ");
INSERT INTO gai_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ri, Parisiarta ninik waŋna ramoot ian, ma mawɨtɨkat, mana ia Gamaliel. Ma Iudana tɨpemb wandik tamŋirena ramoot, ainda moca meikramtaɨra manmo torirena. Ri, ma ramtaɨrmo ma gaindopatna, ne up aŋgɨrena ramtaɨrmo raek naaŋgɨ laruca tekemtem pac eac. ");
INSERT INTO gai_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Mina minmo aŋgɨra larua maiatna mbatca, Gamaliela ndona aiŋ kabena ninikar waŋgormo, gaindopatna, “Ne Israelnaŋgepta ramtaɨr, ne an ramtaɨrmo reac ianna kai mo teac, ndori matau lamŋi. ");
INSERT INTO gai_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Na ne malamŋireke, kɨdrɨk rocot ŋgoinna wanaiŋ, Teudas ma ŋgepca gaindopatna, ‘Aku ramoot paŋan, aku irembta ramoot.’ Na ma aindopatke, mana kamb mbaraca raŋgaiatna meikramtaɨrta ŋgaŋganŋgɨa maica 400na mɨn aŋgɨatke. Mina Romna ramoot paŋan aniaca aind mbatatke, manmo moca ma menacatke, mana rɨpaca raŋgairina meikramtaɨra tamtam nakɨpacariatke, mina an aiŋa andua watamacariat. ");
INSERT INTO gai_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ri, iŋmbaia mina Romna ramoot paŋan aniaca, meikramtaɨrta iremb aŋgɨri, Galilina ramoot Iudas, ma an meikramtaɨrta iroara moa ŋgetrikica mina ŋgepca mana raŋgaica. Mina an ramoot paŋan aniacap ruŋca mana mo irikna moca, moatnanna, wanaiŋ. Mina mana rɨŋga menacatke, meikramtaɨra mana rɨpaca raŋgairinanna, mina kɨpcarica tamtamma taŋga mamaiat. ");
INSERT INTO gai_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Aintik mandeaca aku nenmo gaindopnande, ne an ramtaɨrmo reac ianna kai mo teac kari, ne minmo watcarica mina eac. An aiŋ, minnanna toŋtoŋ mbuŋa mo te, ma wanaiŋ ndac