﻿USE sofia;
DROP TABLE IF EXISTS sofia.gah_vpl;
CREATE TABLE gah_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES gah_vpl WRITE;
INSERT INTO gah_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Vegená utó imi itiki itiki ikago Izesu Kilistó eza agulizaki ve Tevitini agávolaho utó imó. Itó Tevití eza Avalahani agávolaho minamó. Nenémini gakoláa imane neve. ");
INSERT INTO gah_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Avalahakutí Isaká utó imó. Isakani asevalotí Zakopó utó imó. Zakoponi asevalotí Zutaki uvolage agunalagi utó amó. ");
INSERT INTO gah_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Zutani asevalotí Pelezeko Zelako utó asimó nene Tamalé getamó. Pelezeni asevalotí Hezeloná utó imó. Hezelonani asevalotí Lamú utó imó. ");
INSERT INTO gah_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Lamuni asevalotí Aminatapá utó imó. Aminatapani asevalotí Nasoná utó imó. Nasonani asevalotí Salamó utó imó. ");
INSERT INTO gah_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salamoni asevalotí Poasini nene Lahapá getokago utó imó. Poasini asevalotí Opeteni nene Lutí getokago utó imó. Opeteni asevalotí Zesí utó imó. ");
INSERT INTO gah_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Zesini asevalotí agulizaki ve Tevití utó imó. Agulizaki ve Tevitini asevalotí Salomó utó imó. Uliá helekago gevoná venalímo nene Tevititó vike getamó. ");
INSERT INTO gah_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomoni asevalotí nene Lehopoámo utó imó. Lehopoámini asevalotí nene Apiá utó imó. Apiani asevalotí nene Asá utó imó. ");
INSERT INTO gah_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asani asevalotí nene Zehosapatá utó imó. Zehosapatani asevalotí Zolamá utó imó. Zolamani asevalotí Uziá utó imó. ");
INSERT INTO gah_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uziani asevalotí nene Zotámo utó imó. Zotámini asevalotí nene Ahazí utó imó. Ahazini asevalotí Hezekiá utó imó. ");
INSERT INTO gah_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hezekiani asevalotí nene Manasé utó imó. Manaseni asevalotí nene Amó utó imó. Amoni asevalotí nene Zosiá utó imó. ");
INSERT INTO gah_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Zosiani asevalotí nene Zekoniá itó agunalagi utó amó. Zuta vegená nagá kimiiki Papelonia mikasigú kilímiki va gamenaló nene utó amó. ");
INSERT INTO gah_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Papelonia mikasiuka kilímiki vikago nenetí nene Zekoniani asevalotí Sealitielé utó imó. Sealitieleni asevalotí nene Zelupapelé utó imó. ");
INSERT INTO gah_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zelupapeleni asevalotí nene Apiutí utó imó. Apiutini asevalotí nene Eliakímo utó imó. Eliakímini asevalotí nene Azolá utó imó. ");
INSERT INTO gah_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azolani asevalotí nene Zatokó utó imó. Zatokoni asevalotí nene Akimá utó imó. Akimani asevalotí nene Eliutú utó imó. ");
INSERT INTO gah_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliutuni asevalotí nene Eleazalá utó imó. Eleazalani asevalotí nene Mataná utó imó. Matanani asevalotí nene Zakopó utó imó. ");
INSERT INTO gah_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Zakoponi asevalotí nene Zosehé utó imó. Eza Maliani vana loló imó. Maliá nene Izesuni getamó. Eza nene Ómasímo gologí oletative loko lo mololeta ve. ");
INSERT INTO gah_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Utó iakaláa nene imanéminiki nene utó amó. Avalahakutí nene utó imi iteke lakani nene 14 utó ikago agulizaki ve Tevití utó imó. Tevitikutí nene lakani 14 utó iliki itikago nene Zuta vegená nagá kimiiki Papelonia mikasigú nene kilímiki vamó. Nene gamenalotí nene ámináminoko lakani nene 14 utó imi itikago gologí oletative loko lo mololeta vema utó imó. ");
INSERT INTO gah_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Izesu Kilistó utó itímini mogonáa lá oko neve. Izolaho Maliá nene Zoseheni ánigi milimikago ve aleve amasike hotopotó minasimó. Niasigo Ómasímini Sikalahulímini zámuzaló Maliá nene izegipa agatupagi minamó. ");
INSERT INTO gah_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Minokago nene ánigi milita ve Zosehé nene monolagi ve minamó nenazo, nenemú nene ahulotatomóza, vegená kogovisaló ahulotatomó nene avoza helekatize, legesó oko nene ahulotatove. ");
INSERT INTO gah_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Loko loake agata gelekago nene, Guivahanímini ageló makolímo vamotoka utó o amike láa loko lo amimó: Zosehé geza nene Tevitini agávolagamaka, venaka Maliani nene alitohe alemitohe loko nene gagata giliko gena givisemino. Izegipa agatupagi nominamó nene Sikalahulímini zámuzaló neve. ");
INSERT INTO gah_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Eza vegenala zuha nene golesa netalímini nagakutí gologí oketatimó nenazo, minoko gipala getatimó nene agulizá nene Izesú ave loko molatane. Ámina agulizalímini mogonáa nene gologí olimiaká ve. ");
INSERT INTO gah_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Itó netá matá lá oko utó imó nene Ómasímini agepagutí gakó loaká vemámo nene Guivahanímini gakó makó nene gihila zitive loko utó imó neve. Eza luhuva makó láa loko gizamó neve: ");
INSERT INTO gah_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Gilinahe. Vegi akamimó zaha mina vená makolímo izegipa agatupagi minooko gipala getatimó nene, agulizá nene Emanuelé ave liki litave. Itó ámina agulizalímini mogonáa lelí gakokutí nene Ómasi nene lezagi makó noive loko. ");
INSERT INTO gah_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Láa loko vamotoka lo amekago Zosehé nene oteake, Maliani nene numunagú alémoko itimó. ");
INSERT INTO gah_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ve aleve oko minoaká nenéminiki minamasike gipala getamó. Getokago Zosehé nene agulizá Izesú ave loko molamó. ");
INSERT INTO gah_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Heloté nene agulizaki ve napa loló oake gizapa noigo, Izesú nene Petelehe numutoka utó imó, Zutaia mikasigú nene. Gamena nene zupa nene ho noititokatí mikasi mulalokatí sonohí mogonáa gili vevesiaká a ve makó nene Zelusale numutoka amó. ");
INSERT INTO gah_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Iake nene loká iki Zuta ve lekelí agulizaki ve gosohá nene hí apatoka utó ive. Leza numuteloka ho noitiuka nene utó itímini sonohila okulumató nego ánigokunike gupá ze amitune loko nene noune. ");
INSERT INTO gah_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Liki loká ikago nene, agulizaki ve Heloté nene gakó geleake, ininá noike agata gululusi nogiligo, ");
INSERT INTO gah_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","keza Zelusale apá amelage ámináminiki ininá amó. Lá niago, Heloté nene guguni giziaká a ve napagi monó mogona apí ikimiaká a vegi kelémo nupa oake nene Ómasímo gologí oleketative loko lo mololeketa vema nene hí apatoka utó itive liki linamó neve. ");
INSERT INTO gah_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Loko loká okimikago, keza láa liki li amemó: Petelehe numutoka Zutaia mikasiuka utó itive loko Ómasímini agepagutí gakó loaká vemámo Ómasímo lo ami gakó láa loko luhuva gizonoimóma nenae: ");
INSERT INTO gah_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Petelehe numutokatí agulizaki ve napa makó utó okoko nene Isilae vegenáne zuha nene gizapa oketati ve nenazo, ámina apá Zutaia mikasigú noimó nenémo Zutaia mikasiuka gotó apá mukí niakutí lemeko nene nomive. ");
INSERT INTO gah_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Liki nene gakó li amikago nene, geleake, Heloté nene sonohí mogonáa gili vevesiaká a vema asugunatoka kelémo nupa oake, sonohíma apí oko utó itotí gamena nanakí vive loko loká okimikago, nene gamenave liki legesó iki li amemó. ");
INSERT INTO gah_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Li amikago, Heloté nene láa loko lo kemeake kimisilimó: Lekeza nene Petelehe numutoka viki amuza miliki vitagá iki alími utó iiki iki li nimitaze. Iki li nimikiko, neza vinake ámináminoko voko gupá ze amitoze. ");
INSERT INTO gah_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Loko lokago, nivago nene, numúitoka ho noititoka ániga sonohíma utó oake nene, ale goí imó. Ale goí oko vike nene, izegipa namuni mina numuni veletó oko hizekago, ");
INSERT INTO gah_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","ánigiake, mulúikú lamaná giliake nene, ");
INSERT INTO gah_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","numukú itiake ánigamó nene izolaho Maliaki niasigo, ánigiake kalapusa hiziki izegipa namunima gupá zi amiake góini agepáa ali vatá iake áminagutí nene henokanoni lehizitamó. Henokanoni nene goli gehani itó lokila anuvavagi iteaká i netá itó anuva hilina lamaná nene ");
INSERT INTO gah_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","lehizimiake, akinago nene, Ómasímo nene vamotoka láa loko lo kimimó: Lekeza nene Heloté noigo ánigiake anite gapoló vamiki haitó gapoloka atiginá iki viki numutitoka vi anititaze. Loko lo kemekago nene vamó. ");
INSERT INTO gah_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Nivago nene, Ómasímini ageló makolímo Zoseheni nene vamotoka utó o amike láa loko lo amimó: Helotéma gipakamú nene vitagá oko ale utó okoko nene apilitove loko lokamó nenazo, geza litá oko otekoko izolahiko gipalago nene kelémoko Izipi mikasiuka viki minataze. Viki niiki nene, nénisi gakó litokumukó gámemé iki gili minataze. ");
INSERT INTO gah_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Loko lokago, Zosehé nene litá oko oteake límugusigú nene izolahiki gipalagi kelémoko Izipi mikasiloka vamó. ");
INSERT INTO gah_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Neneloka viki niago Heloté nene hilimó. Lá okago, Zosehege atiginá iki Isilae mikasiló vamó nene hanuvamú negopa Ómasímini agepagutí gakó loaká ve makolímo gipáne nene Izipi mikasiuka minokago sele lo amutó noave loko Ómasímo lo ami gakó luhuva gizamó nene alévolé itive liki atiginá iki vamó. ");
INSERT INTO gah_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Itó Heloté nene velesá helenamike sonohí mogona giliaká a ve nenete agoka viziake vakumú nene izapaló molamó. Izapaló golesa molokago nene, gimisigi ve nene kimiselekago, keza nene Petelehe numutó itó apá alitokagi numutó namató mihina mihina iki nene izegipa namuni gipagó kilisimasi losi ali ahulinamamoláa kipili asú amó. ");
INSERT INTO gah_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Lá iki kipili asú amó nene, sonohí mogona giliaká a vete sonohíma ganá apí oko ániguhatotí gamena lá oko mota vokave liki Heloteni li ametó lá amó. Lá ikago, Lama numuni nene Petelehe numuni helegaloka minamó nenazo, Ómasímini agepagutí gakó loaká ve Zelemiá gakó láa loko limó nene alévolé imó: ");
INSERT INTO gah_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Lama numutoka nene ive nama nenémo haitolíminoko nominago Lahelé nene izegipa apalamú ive noigo nene alémo zou litune liki nilago, mukitó mota hili asú ikamó nenazo alími zou lamitamó ikago ive okogó minamó neve. ");
INSERT INTO gah_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Heloté helekago nene, Izipi mikasigú Guivahanímini ageló makolímo Zoseheni nene vamotoka goha utó o amike láa loko lo amimó: ");
INSERT INTO gah_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Gipaka apilitove loko li vema mota helekave. Nenemú geza otekoko izolahiko gipalago kelémoko Isilae mikasiuka atiginá oko kelémoko vozo. ");
INSERT INTO gah_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Loko lokago izolahiko gipalago nene goha kelémoko vimó. Atiginá iki Isilae mikasigú minake nene, ");
INSERT INTO gah_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Zosehé nene gakó makó láa loko gilimó: Heloteni gipala Akelaó áisi nene amelahini akilí hitoake, Zutaia mikasigú nene agulizaki ve loló oko noive. Gakó némika liki likago geleake, Zutaia mikasigú voko minatikumú alegesá ligimó. Alegesá legekago nene, vamotoka gakó makó gilimó. Geleake, Galilaia mikasiloka nene ");
INSERT INTO gah_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","apá makó agulizá Nasalete neneloka voko minamó. Lá okago, Ómasímini agepagutí gakó liaká a ve keza Ómasímo amisilitove loko lo mololeta vemú Nasalete veve liki litave liki lina gakó nene alévolé imó. ");
INSERT INTO gah_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Gamena nene zupa monó nagamí holokimiaká ve Zoní nene Zutaia mikasigú oake, mikasi gomopalaló monó láa loko lo utó imó: ");
INSERT INTO gah_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ómasímini agulizaki ve napa nene omo lokogovisaloka okaze. Likigika ali viligalo. ");
INSERT INTO gah_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Loko limó nene, Ómasímini agepagutí gakó loaká ve Isaiá gakó láa loko limó: Mikasi gomopalaló ve makolímo gakó napagutí nene Guivahanímini gapo vilitalo. Likigikagú limiti gapo ali hee litalo loko nolive. ");
INSERT INTO gah_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Loko luhuva giza gakó nene Zonitoka alévolé okago, eza Ómasímini agepagutí gakó loaká ve Ilaizani suni alike kamele iza zopovatunú lilí a gó luhoake, iza galupavatunú lilí a holotani nene gohalaló zeake, pipizá nosánetá nene ganuki himoni nogozagi nene noko minamó. ");
INSERT INTO gah_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Lá noigo, Zelusale numutotí itó Zutaia apá makotokatí itó Zota nagamí vola helega ima helegalokatí nene aitoka vi anitiake nene, ");
INSERT INTO gah_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","lihimáini li utó ikago, Zota nagamikú monó nagamí holoketamó. ");
INSERT INTO gah_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Noholoketago nene, Palisaio monó ve itó Satukaio monó ve keza monó nagamí hilanigi ikago, láa loko lo kimimó: Gosihalímini agapilamó zuha lekeza nene golesa netalímini lihima nene lekelitoka anitinogo noimó nene likigika ali viligamiki hanuva golisi itave loko éaho lo likimigo niave. ");
INSERT INTO gah_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Likigika nene ali viligiiki nenémini gihila ali utó iiki alo. ");
INSERT INTO gah_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Neza láa loko lo nolukumuve: Avalahani agapilamó zuha keza sonohikitana nene gatamoakalímini lilí itave loko lo molota gakó nene alévolé itive loko lekelisi negopa, Ómasi nenémo gakó litove loko nene lokiko, gehani imanete Avalahani agapilamó zuha lilí inigi nene lilí itamó nenazo, nenemú lukugupelini aliki itiki Avalahani agapilamó zuha nouninazo, Ómasímo lihimatemú goní oletaminogo ive liki lamilo. ");
INSERT INTO gah_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Luni makó nene za mogonagú gamuni oake noive. Nenemú gihila lamaná ali utó inamitamoláa nene, hukoko lokú gizanogo ive. ");
INSERT INTO gah_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Neza nene likigika ali viligikamómave loko nene nagamí hololikimiaká noumóza, nemegesaloka noa ve áisi nene Ómasímini Sikalahulagi likigikagú netá golesa lolímo lati loki hololeketanogo noave. Aí zámuza nenémo není zámuza nene nivilegekave. Neza ánéámina gelekelé otoko aí gasa gó ate akisitomó oko minamuve. ");
INSERT INTO gah_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Eza nene lolopa giteaká netaki aleko oko laisi nene gesopá zeko lolopa giteko ale lamaná itove loko ale vavá okave. Nosánetá lamaná nene numunagú gizaká oko ale molokiko minanogo ive. Lolopaváa nene giteko lokú gizokiko lova lova oko minanogo ive, loko limó. ");
INSERT INTO gah_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Gamena nene zupa Izesú nene Galilaia mikasigutí vike Zota nagamitoka anitike nagamí holonetative loko Zonini voko lo amekago, ");
INSERT INTO gah_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Zoní nene géneka loake láa loko limó: Nénisi ánéama nounazo, géisi holonetatanimó nene etanogo ize. Nenitoka animó nene etamive. ");
INSERT INTO gah_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Loko lokago, Izesú nene láa loko limó: Nene gakó lamaná nolanimóza, itínasa nene nenéminoko minatíize. Hoza nene lá iki alitáive loko loletamóma nenazo, golesa aminogo ive. Loko lokago, Zoní nene gele amimó. ");
INSERT INTO gah_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Gele ameake nene alémoko lemeko Zota nagamikú nene holomikago, iteake ánigamó nene, okulumá koló okago, Ómasímini Sikalahú nenémo nama luhusimagitana oko lemeko Izesuni amupiló nolimigo ánigamó. ");
INSERT INTO gah_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Lá okago nene, okulumakutí gakó makó láa loko limimó: Imane nigika amenou gipáne noive. Ánigo lamaná okuve, loko limó. ");
INSERT INTO gah_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Lá okago, Ómasímini Sikalahú nenémo Izesuni nene mikasi gomopalaló alémoko vimó nene Satá gimivagú molative loko geleake alémoko vimó. ");
INSERT INTO gah_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Neneloka minake gamena 40 oko novigo nosánetá mosimó nenazo, gaúna helekago, ");
INSERT INTO gah_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","gimilegú moloaká ve nenémo aitoka anitimó. Aniteake láa loko limó: Geza Ómasímini gipala noitanimó nene, gehani imane gakó lo kemekako nosánetá lilí ikiko natanize. ");
INSERT INTO gah_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Loko lokago, Izesú nene Óe, monó gotolaú láa liki luhuva gizinamóma neve: Vegená neneta nosánetakó nokoko lamaná oko minoakaláa nene nomive. Ómasímini agepagutí gakó nolimimó nene gele alekoko lamaná oko minoakaláa neve. ");
INSERT INTO gah_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Loko lokago, Izesuni alémoko Zelusalega vike monó zagusave agoka hánaló nene alémoko iteake, ");
INSERT INTO gah_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","láa loko lo amimó: Geza Ómasímini gipala noitanimó nene, imanelotí ká omane mikasiló olío molozo. Gakó makó monó gotolaú láa liki luhuva gizinamó neve: Geikumú Ómasímo aí ageló nene hoza gakó lo kemekiko gehanímo gigisagú hizekative liki keza limiki kigizani agikagú gilími milanigave, liki luhuva gizinamó nenazo, gotá gepeleminogo ive. ");
INSERT INTO gah_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Loko lokago, Izesú láa loko lo amimó: Óe, monokú gakó makó láa loko neve: Guivahani Ómasímo lelémo vatí itihe loko negi netá lilí amilo. ");
INSERT INTO gah_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Loko lokago nene, agoka hána hána makotó alémoko itimó. Neneloka itike numutó namató kugulizaki vetini apáini itó luhuvagi netáini nene nalapizike, ");
INSERT INTO gah_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","láa loko limó: Geza nene galapusa hizeko negepoka lokako, gelepizu netá mukí geí loló itive. ");
INSERT INTO gah_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Loko lokago, Izesú láa loko limó: Satá geza nene ahulokoko vozo. Gakó makó nene monó gotolaú láa liki luhuva gizinamóma neve: Guivahani Ómasi aikó nene lalapusa hizeko gupá ze ameko agepoka loakaláa neve. Itó aikó gelekelé omiakaláa neve. ");
INSERT INTO gah_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Loko lokago, ve golesa nenémo ahuloake vokago nene, agelolite aniteke nasahilí itiki minamó. ");
INSERT INTO gah_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Zonini nene nagá numukú ahulimikago noigo nene, Izesú nene gakó geleake Galilaia mikasigú vimó. ");
INSERT INTO gah_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nasalete numutoka voko gamena hána minamike agilikaloka nene Kapanao numutoka voko minoko aleko imó. Ámina apá nene Galilaia nonohuló agataloka minamó nene Zepuloko Napataliko keí kagapilamó zuhatini mikasiloka minamó. ");
INSERT INTO gah_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Lá okago, Ómasímini agepagutí gakó loaká ve Isaiá epoapoga li gakó nene alévolé imó. Eza láa loko luhuva gizamó neve: ");
INSERT INTO gah_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Zepuloni mikasigú itó Napatalini mikasigú nene, age nagamí alitó, Zota nagamí vola helegaloka nene, itó Galilaia mikasiuka numuká ve keza miniki aliki iaká niatoka nene, ");
INSERT INTO gah_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","límugusigú miniaká nia vegená keza ló liví napa ánigatave. Itó heleakalímini límugusigú mina vegená keza nene lapaná utó okiminogo ive. ");
INSERT INTO gah_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Nene gamenaló Izesú nene monó láa loko apí oko lo kimimó: Ómasímini agulizaki ve napa nene omo lokogovisaló okave. Likigika nene ali viligalo, loko lo kimimó. ");
INSERT INTO gah_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Gamena makó zupa Izesú nene Galilaia nonohuló agataloka mohona noigo, ve lositá uvolahiko agunalago minasimó. Makó agulizá nene Saimon, agulizá makó nene Pitá, itó agunalámini agulizá nene Etulú, keza nene lagaha miliaká asi ve niasinazo, nonohulokú nene lagaha gotaha ahuliki niasigo, ");
INSERT INTO gah_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Izesú ánigoake láa loko lo kimimó: Némegetiki alizo. Lagaha hoza aliki minasimóma itína vegenatoka hoza aliki kilími nenitoka milatáive loko lekelémo nomuluve. ");
INSERT INTO gah_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Loko lokago nene, litá iki lagaha gotaha nene ahulikasike ámegetiki vasimó. ");
INSERT INTO gah_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Itó vake Zepetaioni gipala lositá ámináminiki niasigo ánigamó. Uvolahini agulizá nene Zemusí, itó agunalámini agulizá nene Zoní. Keza sipigú nene améipiki minasike, lagaha gotaha ali lamaná niasigo, Izesú ánigoake sele lo kimimó. ");
INSERT INTO gah_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Sele lo kemekago litá iki améipinigi itó nagamikú lapéinigi nene ahulikasike Izesuni ámegetiki vasimó. ");
INSERT INTO gah_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Izesú nene Galilaia mikasigú nene vigé vigé oko mohona ike nene, monó numuni minakú minakú nene monó lo keme keme ike Ómasímini gizapaló minoakalímini gakó lamaná lo utó moloko lo kemeká itó haitopaitó netá gizale vegená itó haitopaitó netá kivisi vegená kelémo zokoká oko minamó. ");
INSERT INTO gah_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Lá noigo, aikumú gakoláa likago, Silia mikasigú vike numutó namató vo asú okago nene gili asú amó. Gili asú iake nene haitopaitó netá kivisi vegená itó kugupe miluma gele vegená itó kigikagú holosi mina vegená itó kigika gopa okago minamoláa itó gepili minamoláa mukí nene Izesutoka kilímiki ikago kelémo zoko asú imó. ");
INSERT INTO gah_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Lá okago nene, Galilaia mikasiukatí taoni 10-a mina mikasi agulizá Tekapoli loko noi mikasigutí itó Zelusale numutokatí, itó Zutaia apá makotokatí, itó Zota nagamí vola helegalokatí nene vegená vaí iki ámegetiki vamó. ");
INSERT INTO gah_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Izesú nene vegená mukí alegesá ikago ánigoake zopegaló iteko minamó. Noigo, izegipala zuha nene aitoka alegesá iki minamó. ");
INSERT INTO gah_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Niago nene Izesú monó láa loko lo kimimó: ");
INSERT INTO gah_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Kigikámini henonimú gilikago lemeko mina vegenakumú gelekugo kogoliza nivizemó geleaká noive. Okulumalímini lapaná nene ali lá inigave. ");
INSERT INTO gah_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Itó ive nama iki miluma giliki miniaká niamó nene keikumú gelekugo kogoliza nivizemó geleaká noive. Ómasímo kelémo zou litive. ");
INSERT INTO gah_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Itó kugupenini aliki limiki miliaká niamó nene keikumú gelekugo kogoliza nivizemó geleaká noive. Mikasiuka nene Ómasímini helisa henoni mukí nene ali lá inigave. ");
INSERT INTO gah_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Itó Ómasímini avogisaló hee hee liki minatakumú miluma giliki miniaká niamó nene keikumú gelekugo kogoliza nivizemó geleaká noive. Hee liki minatamó nenémo kigika itive. ");
INSERT INTO gah_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Kigika hizi kimiaká niamó keikumú gelekugo nene kogoliza nivizemó geleaká noive. Ómasi eza agika hize kimitimó neve. ");
INSERT INTO gah_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Itó kigika gizopagi miniaká niamó nene keikumú gelekugo kogoliza nivizemó geleaká noive. Keza miniki Ómasi ániganigave. ");
INSERT INTO gah_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Itó kilími zou liaká niamó nene keikumú gelekugo kogoliza nivizemó geleaká noive. Ómasímo izegipáne zuha niave loko loketanogo ive. ");
INSERT INTO gah_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Itó hee lo mina mogona ámegetiaká niató miluma netá alikitiki gopoguni milikimikago miniaká niamó keikumú gelekugo nene kogoliza nivizemó geleaká noive. Keza nene okulumalímini lapanató viki minanigave. ");
INSERT INTO gah_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Itó nenikumule liki alivi letivi iki gopoguni mililikitiki likilími golesa galasa iki lotoka lataka nihizilikitikoma nene lokogoliza vizitave lokogó nene gelenouve. ");
INSERT INTO gah_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Okulumakú meinavatini sipisi netimó nenazo, nenemú mulutikú lamaná giliki lokogoliza viziki láa liki gilitave: Ómasímini agepagutí gakó liaká a ve gozapá nene áminámini ikitamóma nenazo, Ómasímo ámina vegenaki meinava napa kimimó nene ámináminoko liminogo ive liki lokogoliza vizilo. ");
INSERT INTO gah_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Lekeza nene mukí vegenalitini age lilí iki niave. Agémini lagaváa asú itimó nene, nana oko goha alémo melelé itune. Ma aminogo une. Ha netá loló okamó nenazo, nenemú lekeko ale ahulokuko, ká omane mikasiló neiko nene, vegená nenete lisiki goihá ziki vigá igá inigave. ");
INSERT INTO gah_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Itó lekeza nene mikasiuka vegená mukilitini livíini lilí iki niave. Liví napa nene agokaló ale utó molonouko, netá makolímo ale hitosá amive. ");
INSERT INTO gah_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Itó liví lege molokoko nene somotunú gahumá oakaláa nomive. Holomaló molokuko nene, numukú nia vegená hize sata o asú okimiaká noive. ");
INSERT INTO gah_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Lekeza miniki aliki atímo livímáminoko vegená nene hize sata oketatize. Lá okoko nene, lekelisi lamaná iki iki miliki itamó nene vegená nenete ánigiiki laga kivisekiko, okulumakú ametipini agepoka litaze. ");
INSERT INTO gah_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Nenikumú nene Mosé lo hukoko li gakó itó Ómasímini agepagutí gakó liaká a vete li likimina gakó ale ahulatove loko okane liki lakagata gelemilo. Ale ahulatove loko lumumó negopa, mogonáa lo utó oko lokugo gihila zitive loko lumumóma neve. ");
INSERT INTO gah_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Gakó lamaná lo likimitoze, gililo: Okulumaki mikasigi velesá vo tolova amoko ha nekoma nene, Mosé lo hukoko li gakokutí gakó koma ma gopa aminogo ive. Ha mino-loko voko neiko nenémini gihila utó inogo ive. ");
INSERT INTO gah_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Nenemú makó eza lo hukoko li gakokutí koma makó avutá apeleoko vegená lugáate ámináminiki avutá apilitave loko lo kimitimó nene, okulumakú Ómasímini avogisaló eza lemeko minanogo ive. Itó makó eza lo hukoko li gakó gele alekoko vegená makolite ámináminiki gili alitave loko lainim-oketatimó nene, okulumakú Ómasímini avogisaló iteko minanogo ive. ");
INSERT INTO gah_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nénisi láa loko lo nolukumuve: Lekeza nene monó mogona apí ikimiaká nia vetini itó Palisaio monó vetini mogonáinimú gilikago hee lokogó noitive liki giliaká niamóza, lekelí hehe liki miniaká nia mogonatini nenémo keí mogonáini kiviligemitimó nene, lekeza okulumakú Ómasímini avogisaló ma iteminigave. ");
INSERT INTO gah_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Mosé lo hukoko li gakokutí avotikini láa liki li kiminamóma neve: Geza vegená kepele helemo. Makolímohe makolímohe ve makó apele hilitimó nene, gakó hozámini mututoni loló itive. ");
INSERT INTO gah_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Itó nénisi nene láa loko lo nolukumuve: Makolímohe makolímohe agivelahinimú izapaló molatimó nene gakó hozámini mututoni loló inogo ive. Itó makolímohe makolímohe agivelahini ale mumusopa zeko litimó nene monó gizapa vetini kovogisaló goní napa inogo ive. Itó makolímohe makolímohe agivelahinimú aleko letoko negi ve lotatimó nene, áisi nene ló apalímini mututoni loló inogo ive. ");
INSERT INTO gah_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Nenemú geza nene guguni gizoaká netá matá aleko voko holomaló molatani zupa nene nigivénehiki logoka hotopotó igo lovaleta onousimóma nenazo, nenema ha neve loko gilitanimó nene, ");
INSERT INTO gah_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","guguni gizoaká netá neneló ahulokako, neko nene, voko gigivekahiki gakó ligili hagili iki nene likigizakú aliki ali hulu itáive. Ali hulu iiki nene guguni gizoaká netáma nene goha voko Ómasímini holomaló molatane. ");
INSERT INTO gah_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ve makó eza geí lihimamú goní ogetanogo goní numutoka gelémoko noviko, gapoloka niviki nene lihimavaka asú itive loko netá makó amezo. Itó áminagi aleloko gopa hanuva goní ale heleaká ve noitoka anititanimó nene, goní ale heleaká vemámo pilisi vetini kigizakú gelémo molokiko keza nagá numukú ahuligimikataze. ");
INSERT INTO gah_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Neza lamaná lo nogumuve. Geza Ómasímini nagá numuni napagú minokoko lihimakámini meinaváa koma napa apaso asú amitanimó nene áminagú mino-loko voko minanogo ane. ");
INSERT INTO gah_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Mosé lo hukoko li gakokutí avotikini nene gakó láa liki li kiminamóma neve: Haitó vená makó loká amo. ");
INSERT INTO gah_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Itó nénisi nene láa loko lo nolukumuve: Ve makó nenémo vená makó nene ánigo amu hilitimó nene ámina vená nene agikatunú mota loká okamó nenazo, nenémini lihima aitoka minanogo ive. ");
INSERT INTO gah_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Nenemú gogómula lugaloka nenémo lihima aleaká gapogú gelémo nomilikoma nene, gugupe avasavagi minoko nene meikú holokatanize. Nenemú gogómula nenémo gelémo gopa okative loko gogómula lugaloka nene hize likoko ale ahulozo. Gogómula hamoki minoko vávani oko minanogo ane. ");
INSERT INTO gah_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Itó gigizani lugaloka nenémo lihima aleaká gapogú gelémo nomilikoma, gugupe avasavagi minoko meikú holokatanize, nenemú gigizani lugaloka hukoko ale ahulozo. Gigizani hamoki minoko vávani oko minanogo ane. ");
INSERT INTO gah_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Mosé lo hukoko li gakó makó láa loko neve: Makó eza venala ahulotatove loko nookoma nene pepa luhuva gizo ameoko nene ahulotatize. ");
INSERT INTO gah_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Itó nénisi nene láa loko lo nolukumuve: Ve makolímohe makolímohe venala gumesisi mokoló mogonaló negopa hanuvamú amisele ahulatimó nene, ámina mini ezega emega oakalímini lihimavala nene goí o vanaloka minanogo ive. Itó alika vegi apiziki minasitímini lihimavala nene goí o vanámini amupiló iteko minanogo ive. ");
INSERT INTO gah_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Mosé lo hukoko li gakokutí nene avotikini nene gakó láa liki li kiminamóma neve: Geza nene Ómasímini avogisaló lo hukoaká noanimó nene sozagutí ale moloko lamo. Guivahanímini avogisaló gakó lo hukoko lanimó nene gele alekako gihila utó inogo ive. Nene gakó lekeza mota gilinamóza, ");
INSERT INTO gah_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","nénisi láa loko lo nolukumuve: Ómasímini avogisaló lo hukoaká gakó nene ahulalo. Okulumakutí nene Ómasímo gizapa olimiaká noimó neve. Nenemú okulumatoka ali miliki gakó li hukamilo. ");
INSERT INTO gah_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Itó imane mikasiló nene Ómasímo lisoaká noive. Nenemú mikasigú ali miliki gakó li hukamilo. Itó Zelusale nene okulumakú agulizaki ve napámini apá neve. Nenemú Zelusale numutoka ali miliki lo hukoaká nene ahulalo. ");
INSERT INTO gah_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Itó lekeza zopovatini loí zekikoma nene gakó li amikiko anupá loló amitimó, itó zopovatini anupá nene gakó li amikiko loí zemitimó neve. Nenemú zopovatiniló ali miliki gakó li hukamilo. ");
INSERT INTO gah_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Netá nenémináa ahuliiki lamaná oo loló itune likigó, itó óe loló amitune likigó lilo. Nenémini amupiló gakó makó litamó nene ve golesalokatí linigave. ");
INSERT INTO gah_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Moseni gakó makó láa liki linamó nene giliaká niamóma neve: Makolímo gogómula hize likokikoma, ámináminoko aí agómula hize likozo. Makolímo gegepa ze letokikoma geza aí agepa ze letozo. ");
INSERT INTO gah_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Liki linamóza, nénisi nene láa loko lo nolukumuve: Likipilitune nikikoma lukugupelini ali agutó vizemilo. Nenemú ve makolímo gagamipa lugaloka zekikoma, gagamipa lugaloka nipilitive loko viligo amezo. ");
INSERT INTO gah_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Makolímo goní nogetoko nene siotika alekikoma nene, hepé gómagi gopa amezo. ");
INSERT INTO gah_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Itó kiapé makolímo henokanoni geheko gapo alínipaló vitane loko nolikoma, gapo hánagi nene hanuva geheko vozo. ");
INSERT INTO gah_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Itó makolímo geí netakumú voká nolikoma, hanuva amezo. Netá mataka gutá ale minatove lokikoma, amezo. ");
INSERT INTO gah_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Gakó makó láa liki linamó nene giliaká niamóma neve: Geza gigika nene gigivekahini amezo. Gala vega nene aleko letoko mukahá apelezo. ");
INSERT INTO gah_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Liki linamóza, nénisi láa loko lo nolukumuve: Gala velini nene likigika kimiki nasahilí ikitalo. Gopoguni mililikitata vegenakumú Ómasiloka lilo. ");
INSERT INTO gah_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Lá niiki okulumakú ametipini gipala mohó gihila lilí iki minatave. Áisi lokago, aí ho silikakéna nenémo vegená golesagi lamanaki mukitoka hamó lelegitó hize hanatolimiaká noive, itó áisi lokago nene aí golini nenémo golesa iki mina vegenaki hee liki mina vegenaki hamó lelegitokó ale geha zelimiaká noive. ");
INSERT INTO gah_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Lekeza nene kigika likimita vegenakó nasahilí iki likigika kimitamó nene, Ómasímitokatí meinaváa alemitamó neve. Takisi gehani aliaká ve lekeza ánigi goselé iaká nia ve nenete kigika limita vegená nene ligika kimitune liki liaká niamole. ");
INSERT INTO gah_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Itó likigivetikinigó geké likitatamó nene, likigivetikini nana netá lamaná lilí ikimiaká niamó neve. Monó gilina vegenalitini suni negopa, monó gelema vegená kezagi ámina suni aliaká niave. ");
INSERT INTO gah_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Nenemú lekelisi okulumakú ametipo hee loko minoaká noimó nenéminikigó minalo. ");
INSERT INTO gah_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Lekeza monokumule liki vegená kilími lamaná iki nasahilí ikitata netá nene vegenalite legepoka litave liki lilí amilo. Lekeza vegenalite legepoka litave liki ali minatamó nene, ehe, okulumakú ametipo meinaváa lekememinogo ive. ");
INSERT INTO gah_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Nenemú gohogó vegená nasahilí oketokoko gigivekage ánigi lamaná itave loko golómeni gizamo. Genezáini losigi ve nenete soza saza gakó lake monó numukú itó vegená kovogisaló vegenalite ánigi lamaná iiki legepoka litave liki lá iaká niave. Neza lamaná lo likimitoze, gililo. Kegepoka liaká niamó nenémo keí meinaváa loló okago mota alikago asú oaká noive. ");
INSERT INTO gah_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Gohogó vegená nasahilí oketatove lokoma gigizani lamagalokatí asugunatoka nasahilí oketozo. Lá okako gigizani sogaloka nia vegená nenete gelemitave. ");
INSERT INTO gah_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Lá okako nasahilika nene asugunatoka minative. Amekaho nene asuguná oko aleaká noani netá ánigoaká noinazo, nenemú meinaváa giminogo ive. ");
INSERT INTO gah_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Lekeza Ómasiloka nilikima nene sozaló genezáini losigi vegenalitini suni alemilo. Keza nene monó numúikú itó vegená kovogisaló vegenalite ánigi lamaná itave liki otiki Ómasiloka liaká niave. Neza lamaná lo likimitoze, gililo. Kegepoka liaká niamó nenémo keí meinaváini loló okago mota alego asú oaká noive. ");
INSERT INTO gah_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Geza Ómasiloka litove loko nookoma nene, numukagú iteoko gahe gekoko amekaho asugunatoka ánigoaká noi veloka lozo. Lá okako nene, amekaho asuguná netá aleaká noani netá ánigo asú oaká noi ve nenémo meinaváa giminogo ive. ");
INSERT INTO gah_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Lekeza nene Ómasiloka niliki nene lekegepatunú goha liiki goha liiki ikiko hána hána loló okiko ha gakó loló okatize. Monó gelema vegenalite Ómasiloka loloko vova vova nouko gele limitihe liki lá iaká niave. ");
INSERT INTO gah_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Lekeza keí suni alemilo. Ómasímo netá matakumú vitagá nouko nene litá oko voká lonamuko hanuva geleaká noive. ");
INSERT INTO gah_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Nenemú lekeza nene láa liki Ómasiloka lilo: Okulumakú ametega, geí gugulizá etó oko minatize. ");
INSERT INTO gah_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Numutó namató geí gizapaló minoakalímini zámuza utó o asú ino. Okulumakú géisi lanitó molanitó gelekelé igimiaká niave. Mikasiuka lezaloka áminagó oko utó ino. ");
INSERT INTO gah_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Gamena gamena nosánetate lemezo. ");
INSERT INTO gah_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Leza ligivetegini lihima nekisáini ahulokimiaká nounimó nenéminoko lihimate ale minuháma nene ale ahuloletozo. ");
INSERT INTO gah_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Gimilegú moloakakú lelémo molamo. Ve golesámitokatí akagá oletozo. ");
INSERT INTO gah_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Lekeza likigivetikini lihima ahulikitatamó nene, okulumakú ametipo nene áminagó oko lekelí lihimatini ale ahuloleketanogo ive. ");
INSERT INTO gah_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Itó lekeza vegenalitini lihima ali minatamó nene ámináminoko okulumakú ametipo nene lekelí lihimatini ale minanogo ive. ");
INSERT INTO gah_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Itó monokumule liki nosánetá mosi keké ita zupa nene monó gelemiki genezáini losigi vegenalitini suni alemilo. Vegená makolite mosé oaká nouni suni ánigiiki legepoka litave liki kogoka kegepaló ánigiake muhelé ahelé iaká niave. Neza lamaná lo likimitoze, gililo. Vegenalite kegepoka liaká niamó nenémo meinaváini loló okago, mota alikago asú oaká noive. ");
INSERT INTO gah_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Géisi nene monokumule loko nosánetá nomoseko nene gotoka komu aleko ale lamaná okoko gogoka gegepa nagamí zezo. ");
INSERT INTO gah_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Lá okako, vegená makolite nosánetá nomosenimó nene ánigi vevesamitave. Amekaho asugunatoka noi ve nenémo gilitize. Itó asugunatoka aleaká ani netá ánigoaká noi ve amekaho nene meinaváa giminogo ive. ");
INSERT INTO gah_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Mikasigú henoni nene gaupá geakalímini itó gúnakonite hukiakalímini, itó vegenalite zivi letivi iki gumina oakalímini nenazo, nenemú mikasiuka imane ali nupa nupa amilo. ");
INSERT INTO gah_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Lekeza okulumakú henoni nene gaupá gemoakalímini gúnakonite hukamiakalímini itó guminaló vete zivi letivi iki gumina alemoakalímini nene ali nupa ilo. ");
INSERT INTO gah_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Gelenape. Henokanoka lamaná neti apatoka nene gigika neinogo ive. ");
INSERT INTO gah_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Gogómula nene gugupémini ló liví neve. Gogómula nenémo mumuzó oakalímini gapogú gelémo molamitimó nene, Ómasímini lapaná nenémo gugupe gigika mukitoka hize hanato asú inogo ive. ");
INSERT INTO gah_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Itó gogómula nenémo gelémo golesa itimó nene, gigikaloka ámina oko límugusi ze minanogo ive. Gigikagú liví lonoimó nenémo lihatimó nene, límugusi zitimóza, sipisi haitolímini zekiko nene gopa gapo veleko minanogo ane. ");
INSERT INTO gah_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Ve hámakolímo kugulizaki ve lositosini gelekelé ma oketaminogo ive. Maga ve agika amekoko maga ve gasó amitimó onoive. Makotó gímize lamaná okoko makó ánigo goselé itimó neve. Lekeza nene ámina iki Ómasímini hozagi moni henonímini hozagi lelegí oko aleakaláa nomive. ");
INSERT INTO gah_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Nenemú neza láa loko lo likimitoze, gililo. Lekeza miniki aliki itakumú nene nosánetá hikutí noko minatupe, itó ginegane nene hikutí ale akoloko minatupe liki mulutini itemino. Lekelisi ma liléna. Miniki aliki iaká nia netá nenémo netá gihila nehe, itó nosánetá nenémo netá gihila neve. Lukugupémo netá gihila nehe lukugupeló ginegane nenémo netá gihila neve. Minoko aleko oaká itó lugupe nenémo netá gihila nenae. ");
INSERT INTO gah_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Lekeza veletó vogalaló nama nene ánigalo. Keza netá matá ma zuhá isá amave. Itó minumuni o molokago nosánetá nene numúikú ali nupa iki nisá amave. Lá onoimóza, okulumakú ametipo nosánetá gopa ale utó o kemeaká noive. Nenegú nana onoive. Namamate itiki niago lekelisi nene lemeko noune liki nigelehe. Lá oko nomive. Lekeza itiki nianazo, netá matá vitagá nia netá nene hanuva ale utó mololeketanogo ive. ");
INSERT INTO gah_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Lekelikutí makó éaho muluna noitiko minoko aleko ititó nene ezáa agata geleko miní ameko kilisimasi makó molomo iteko minative. Ma nomive. ");
INSERT INTO gah_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Itó gineganemú nene nanamú mulutini iteaká noive. Gihisigú palauá nenetini mogona gili vevesamahe. Netá nenémináate hoza alisá amave. Itó ginegane lamanatamanakó ali luhatakumú gó isá amave. ");
INSERT INTO gah_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Lá onoimóza, nenemú lo likimitoze, gililo. Gozapá agulizaki ve napa Salomó nene golivagi netá akoloaká imóza, gihisigú palauá nenete Salomoni agupeló netá nene aviligikave. ");
INSERT INTO gah_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Palauá nene itínasa utó oaká noive, itó gó lokago gululupasokago hukiki ló giziaká niave. Lá onoimóza, Ómasímo lokago, ámina palauá nenémo lá oko gonanalisi lamaná oaká noimó nenazo, nenemú lekeza komáisí gili alévolé inamó neneta, ginegane nene Ómasímo hanuva ale utó oleketanogo ive. ");
INSERT INTO gah_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Nenemú lekelisi nosánetá hikutí aleko noko moloko itupe, itó ginegane ale akalatunimó nene hikutí ale akalatupe liki mulutini itemino. ");
INSERT INTO gah_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Monó gelema vegená keza ámina netakumú kagata gululusi giliki vitagá iaká niave. Keí suni alemilo. Okulumakú ametipo nene ámina netá makó lekelitoka minamitimó nene lukugupe lamaná amitive loko geleneimóma nenae. ");
INSERT INTO gah_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Lekeza ámina netakumukopa, Ómasímo gizapa vetini loló iti gapogú itó Ómasímini hee hee loko minoaká gapogú likigika lakagata goí iki miliko vo minino. Lá ikiko nene, lukugupémini netaki nene hagitana lehizeleketanogo ive. ");
INSERT INTO gah_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Nenemú azo utó iti netakumú nene mulutini itemino. Azo utó iti netá nenémini genaváa azogó asú inogo ive. ");
INSERT INTO gah_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Lekeza vegenalitini lihimáinimú gakó li hukikitamilo. Ómasímo ámináminoko lekelí lihimamú gakó lo hukolikimikatize. ");
INSERT INTO gah_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Lekeza vegenalitini lihimáinimú li hukikita polosava lekelí lihimamú lo hukoleketanogo ive. Itó lekeza vegenalititoka iki miliki ita polosava ámináminoko Ómasímo lekelitoka oko moloko inogo ive. ");
INSERT INTO gah_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Nenemú geza gigivekahini agómulagú gilisá onoikoma ánigokoko gezaka gogómulagú za lana vonoimó nene nanamú ánigo lamaná amane. ");
INSERT INTO gah_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Gezaka gogómulagú za lana vonoimó nene hanuva nego, gigivekahini nanamú gogómulagú gilisá vonoimó nene ale ahulogetatove loko nolane. ");
INSERT INTO gah_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Sozaló ve genezaka losi minamó neneka, gezaka gogómulagú za lana nemó nene goí oko ale ahulokoko alika geza ánigo vevesooko nene gigivekahini agómulagú gilisá ale ahulotatanimó nene etanogo ive. ");
INSERT INTO gah_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Lekeza nene monolímini gakó lamaná nene galagitana vegená li kememilo. Keza gopa viligiki akohú likipilikataze. Itó monolímini meinava iteko mina gakó nene izagitana vegená li kememilo. Keza nene monotini gili ahuliiki likilími golesa ikataze. ");
INSERT INTO gah_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","8","Voká liaká nia vegenalite netá matá mota aliaká niave. Vitagá iaká nia vegenalite gihila ali utó iaká niave. Gaheló hoko-hoko likago koló okimiaká noive. Lá onoinazo, Ómasiloka liki voká litamó nene alinigave. Vitagá itamó nene gihila ali utó inigave. Gaheló hoko-hoko nilikoma, gahe koló oleketanogo ive. ");
INSERT INTO gah_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Lekelikutí ve makolímini gipala nenémo nosánetakumú voká lokiko, amelaho gehani mula makó amitihe. ");
INSERT INTO gah_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Itó lagahamú voká lokiko gosihá amitihe. Óe, lá aminogo ive. ");
INSERT INTO gah_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Lekeza vegená golesa minikamóza, izegipatini gizapa lamaná ikitake netá lamaná ali kegepa iaká nianazo, okulumakú ametipo voká lita vegená nene aleko iteko haitolímini nene netá lamaná lehizeleketanogo ive. ");
INSERT INTO gah_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Lekeza vegenalite némini manámini lilí ilitatave liki giliaká niamó nene lekeza áminagó iki nenémini manámini lilí ikitalo. Ámina gakó nenémo Mosé lo hukoko li gakoki Ómasímini agepagutí gakó liaká a vete apí ikimina gakoki nenémini gotoláa neve. ");
INSERT INTO gah_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Latila oaká apalímini gatenáa napa neve, itó gapováa sipisi neve, itó neneloka vegená mukilite viaká niave. Nenemú ámina gapogú vamiki okulumá gateni komagú itilo. ");
INSERT INTO gah_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Alévolé oko minoaká apalímini gatenía koma neve, itó gapováa koma nego génopa hoza aleko iteakaláa nenazo, vegená luguhakó viaká niave. ");
INSERT INTO gah_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Soza saza monó lili ali ve keza kugupe zou lo minamó itó hela gala kigikagi nenémináate lekelitoka anititakumú, ehe, lukugupe gizapa iki minalo. ");
INSERT INTO gah_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Keza iki miliki ita sunímo mogonataganáini ale utó okiko ánigi vevesataze. Hilipa nenémo gihila noakalímini zitimó nehe. Itó gomogisigú nene gihila noakalímini zitimó nehe. Óe, nenéminoko nomive. ");
INSERT INTO gah_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Za lamaná nenémo gihila lamanakó zeaká noive. Za golesa nenémo gihila golesagó zeaká noive. ");
INSERT INTO gah_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Za lamanalímo gihila golesa zeakaláa nomive. Za golesámo gihila lamaná zeakaláa nomive. ");
INSERT INTO gah_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Lá onoinazo, vegenalitini mogonatagana hamó lelegitó neve. Gihila lamaná ali utó amitamoláa hukoko lokú gizanogo ive. ");
INSERT INTO gah_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Nenemú soza saza monó lili ali vete iki miliki ita suni nenémo mogonataganáini ale utó okiko, lekeza nenémini gihiláa nene ánigi vevesanigave. ");
INSERT INTO gah_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Guivahaníneve guivahaníneve liki liaká nia vegenakutí lugáa avasavagi okulumá apakú iteminigave. Aménehini gakó gili aliaká nia vegenakó nene itinigave. ");
INSERT INTO gah_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Gamena napaló nene vegená lugáate láa liki li niminigave: Guivahanitemaka, leza nene geí gakotó monó lo kemeaká uháma neve. Itó geí gakotó kigikagutí holosi kepeleko kimisele ahuluháma neve. Itó geí gakotó alévolé suni mukí aleháma neve. Nenemú gahe segeletamane. ");
INSERT INTO gah_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Liki li nimikiko, neza nene láa loko lo kimitove: Nénisi nene lekelí ánigo vevesonamuve. Golesa netatokagó mihina amó neneta aló vilo loko linogo uve. ");
INSERT INTO gah_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Nenemú gakóne imane giliiki ámegetata vegená nenémináate lá iki niave: Gele veveso mina ve makolímo numuna nene mikasi alévolelaló nené oko gekago, ");
INSERT INTO gah_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","nego nene, golini napa zeake nagamí velekago itó una napa alekago, mikasi alévolelaló gimó nenazo, alévolé okogó minamó. ");
INSERT INTO gah_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Itó gakóne imane giliiki gili ahulata vegená nenémináate lá iki niave: Negi ve makolímo numuna nene nagamí agataloka getatoka gekago, nego, ");
INSERT INTO gah_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","golini napa zeake nagamí napa vilitímo itó una napa alitímo ake ahelú okago, numunima lemeko pou loko akamó. ");
INSERT INTO gah_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Loko Izesú ámina gakó lo keme asú okago, ali nupa iki gakola gele vegená nene Izesú monó lo kimikumú sigaga litake láa liki lamó: ");
INSERT INTO gah_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Monó mogona apí ikimiaká nia vete nene avotegini gakotó amegesaló milatave likigó liaká niamóza, áisi nene ezáa gakola nene gihila noikumule loko amegesa milatató neve loko lainim-olimiaká noive, liki lamó. ");
INSERT INTO gah_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Izesú agokagutí nolimigo, ve vená mukí nene ámegetiki vamó. ");
INSERT INTO gah_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Nivago, ve makó halamé gizaleake mina ve nenémo vike alapusa hizeko Izesuni láa loko lo amimó: Guivahanínemaka, geza nelémo gililitove loko nene hanuva nelémo gililitanimó nenazo, nelémo gililitane loko noluve. ");
INSERT INTO gah_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Loko lokago nene, Izesú nene agizani lutoko agupeloka ale nogilike gililitane loko gelekuze, halamé nene gilelezo. Loko lokago halamé netala litá oko gililimó. ");
INSERT INTO gah_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Gilelekago, Izesú nene láa loko lo amimó: Geza nene imane gakó avetó oko vegená makó lo kememoko voko guguni gizoaká ve nene gugupe alapizekako mota gilelekane loko ánigatize. Itó gilelenikumú nene Moseni gakotó ale moloko netá makó Ómasi guguni gizo amiti netá amekako gilelenitímini mogona nene mukí vegená lo kemekiko gili vevesatave, loko lo amimó. ");
INSERT INTO gah_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Izesú nene Kapanao numutoka itekago, Loma apatotí ami vetini gizapa ve makolímo aniteake negénegeka loko láa loko lo amimó: ");
INSERT INTO gah_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Guivahanínemaka, gelekelé izegipáne nene netá napa avisekago helisala hulupa lo minokago miluma geleko numukuka noize, makó vitíive loko noluve. ");
INSERT INTO gah_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Loko lokago, Izesú nénisi vinake alémo zokatove loko lo amekago, ");
INSERT INTO gah_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","ami gizapa vémo láa loko limó: Guivahanínemaka, goselé gapo okoko ve ánéámina není numukú nanamú ititane. Geza nene imaneloka nooko hanuva gegepatunú lokako gelekelé izegipáne nene zokative. ");
INSERT INTO gah_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nénisi nene ámináminoko kugulizaki vetini gelekeleláa nouve. Itó lovámini gala ve makó není gizapaló niave. Lá niago, ve makokumú nene vozo loko lomikugo hanuva vinogo ive. Itó ve makokumú ano loko lomikugo nene hanuva anogo ive. Itó gelekelé izegipánemú nene voko hoza alezo litomó nene hanuva voko alitimó nenazo, geí gakó ámináminoko alévolé itive loko gelenouve. Nenemú nene geza hanuva imaneloka nooko gakoláa lokako zokatihe loko lunae. ");
INSERT INTO gah_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Loko lokago, Izesú geleake nene sigaga lotake ámegetiki va vegená nene láa loko lo kimimó: Neza lamaná lo likimitoze, gililo. Hetoka ve imanémo nenikumú gele alévolé onoimó nene haitolímini neve. Isilae ve lekezalokatí gele alévolé oaká nenémini makó ánigoko gelesá amumóma neve. ");
INSERT INTO gah_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nenemú nene láa loko lo nolukumuve. Ho noititokatí itó ho nolimitokatí hetoka vegená ve imanegitana nia vegená mukí nenete anitiiki nene Avalahá Isaká Zakopó kezagi okulumalímini lapanalaló alegesá iki miniki nosánetá niki kogoliza vizinigave. ");
INSERT INTO gah_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Lá niiko, goí oko alesa molo kimimó Isilae vegená nene límugusi apakú ahulokimikiko, limiki miniki ive nama iki miluma maluma giliki kegepa atalá iki minanigave. ");
INSERT INTO gah_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Loko loake, ami gizapa ve nene láa loko lo amimó: Geza nene numutoka vozo. Gele alévolé animó nenémini gihila utó inogo ive. Loko Izesú agepa ateleko noligo nene, gelekelé izegipa nene zokamó. ");
INSERT INTO gah_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Izesú nene Pitani numukú iteake, Pitani venalámini izolahini agupegú ló lokago, akonoigo ánigoake, ");
INSERT INTO gah_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","agizakú alimó. Agizakú naligo, ló la netá nene asú omikago, oteake nasahilí otamó. ");
INSERT INTO gah_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Lá okago, únaká ho lemekago nene, kigikagú holosi mina vegená nene Izesutoka kilímiki amó. Ikago nene, kivisi vegená kelémo zokoká kigika gopa i vegená gakó noloketake holosi kepeleko kimiseleká imó. ");
INSERT INTO gah_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Lá okago nene, Ómasímini agepagutí gakó loaká ve Isaiá gakó láa loko luhuva gizamó nene alévolé imó: Netá livisekago keé lamuni netá ezáa agohí gimole. ");
INSERT INTO gah_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Lá okago, ve vená mukí iki Izesutoka hizi vigikago, ánigoake izegipala zuha nene sipigú nilímiki vola helegaloka vitave loko lo kimimó. ");
INSERT INTO gah_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Lo kemekago nene, monó mogona apí okemeaká ve makolímo voko amatoka minoake Izesuni láa loko lo amimó: Tisánemaka, vitanitoka vitanitoka neza gémegé gémegé inogo uve. ");
INSERT INTO gah_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Loko lokago, Izesú nene láa loko lo amimó: Gaha nene mikasi koló onoikú itiaká niave. Itó namatini numúini nemóza, okulumakutí lumu ve gihila neza akato numúne itó gotóneló za nomigo vitagá noumó nenazo, makó vitíive loko lanimó nenémini mogona gele hee lominoko nolape, loko lo amimó. ");
INSERT INTO gah_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Itó ámegetiki va vegenakutí makó nenémo láa loko lo amimó: Guivahanínemaka, geza gelekako nene, neza minoko améneho helekiko vinake gale zemikinake oko gémegetatove. ");
INSERT INTO gah_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Loko lokago, Izesú nene láa loko lo amimó: Geza nene némegetoko ano. Hilinita vegená gale zikimiaká nene kigika heleneiti vegená kezagi ámina hoza alitave, loko limó. ");
INSERT INTO gah_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Izesú izegipala zuhagi nagamikú lapegú itiake vamó. ");
INSERT INTO gah_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Nivago nene, una napa nene litá oko amó. Amuza moloko alekago nene, nagamí nene valahuká zeko lapegú nene ite vaí inogo imó. Lá okago, Izesú nene avó akonoigo, ");
INSERT INTO gah_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","izegipala zuhate alími noteke láa liki lamó: Guivahanitemaka, nagamikú simá nanogo nounize, lugutó vizemane. ");
INSERT INTO gah_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Liki likago, Izesú láa loko lo kimimó: Lekelisi komáisí gili alévolé iaká niatita, nanamú likigika gologolo sekave. Loko loake, oteake, unagi nagamí valahukaki nene ahulalizo loko lo kemekago nene kii nolike zou limó. ");
INSERT INTO gah_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Zou lokago nene, vegená mukí nenete sigaga lake láa liki lamó: Ve imane haitolímini neve. Unagi nagamí valahukaki keza aí gakoláa gili alikasive, liki lamó. ");
INSERT INTO gah_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Nonohuló aviligiake vola helega Gatala vegenalitini mikasigú anitikago, ve lositá holosi golesa kigikagú mina ve minasimó. Niasike, ámepa vizikasigo, vegená nene kelegesá legekago neneló vigá igá amamó. ");
INSERT INTO gah_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ámina ve nenetosa geha mulikú gonosi milimiligutí lemesike Izesugegi hotu lamó. Hotu liake keza litá iti gopaga liki láa liki gamoga giki li amesimó: Ómasímini gipalamaka nana netá golesa oletanogo noane. Gamena alitamitó nene miluma hoza liminogo noape. ");
INSERT INTO gah_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Liki lasimó nene áminaló iza mulusi napa miliki hotó otigí iki gale niki minamó. ");
INSERT INTO gah_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Gale niki niago nene, holosi nenete negénegeka lake láa liki lamó: Limisele ahulanogo nookoma nene iza mulusi vozane kigikagú nene limisele ahulamane. ");
INSERT INTO gah_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Liki likago, Izesú nene vilo loko kimiselekago, viki izatini kigikagú itiake nene lememó. Izatini kigikagú nene limikago, ámina iza mukí nene olíi miliake meiniló limiake nonohulokú limiki nagamí niki hutiake hili gesá amó. ");
INSERT INTO gah_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Hili gesá ikago nene, iza gizapa ve nenete golisi viake taoniloka gakó nene liliki vake kigikagú holosi mina vetosini gakoláa avetó iki li kememó. ");
INSERT INTO gah_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Li kimikago, ve vená mukí nene gili asú iake mukí vegenalite Izesuni ánigatune liki limiake mikasinini ahulokoko vitive liki negénegeka liki li amemó. ");
INSERT INTO gah_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Izesuge nene nagamikú lapegú itiake numunaloka goha atiginá iki amó. ");
INSERT INTO gah_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ikago nene, ve gepili makó nene ukoakogú nene zaló miliki aliki amó. Aliki ikago, Izesú nene ezáamú gili alévolé amó nenémini mogonáa ánigoake ve gepilima láa loko lo amimó: Gipáneve, goha gena givisemino. Lihimaka nene ahulogimikuve. ");
INSERT INTO gah_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Loko lokago, keza monó mogona apí ikimiaká a ve lugáa nenete kigikauka nene Ómasi aviliginogo nolihe liki gelemó. ");
INSERT INTO gah_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Liki gilikago Izesú nene Zuta vegenalite lihima ahulolimiaká itó vegená kelémo zokoaká nene Ómasímogó loló oaká netá neve liki kigikagú gelemó nenémini mogonatagana ánigoake láa loko lo kimimó: Likigikauka nene nanamú gakó golesa nigeleve. ");
INSERT INTO gah_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ve makolímo Ómasi noamitimó nene lihimaka gilatogimikuve loko vávani oko lamitimóza, ámináminoko kelémo zokoaká zámuzagi ve noamitimó nene ve gepili makó geza otekoko mohona oko vozo loko litá oko lo ameminogo ive. ");
INSERT INTO gah_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Lá onoimóza, okulumakutí lumu ve gihila nénisi nene imane mikasiuka lihima gilatoakalímini zámuza itó vegená kelémo zokoakalímini zámuza nenitoka nemó nenémini mogonatagana ánigi vevesatave loko loake ve gepilima nene láa loko lo amimó: Oteoko nene avilisaka geheko numukauka vozo. ");
INSERT INTO gah_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Loko lokago oteake avilisala geheko numunaloka vimó. ");
INSERT INTO gah_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Geheko vokago, vegená mukí keza ánigiake kehelele vizekago, Ómasímini zámuza nene mikasigú vegená kigizakú molokamó minokave liki giliake Ómasi agepoka lamó. ");
INSERT INTO gah_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Gamena nene zupa Izesú nene vike takisi moni aleaká ve není nugulizá Mataiona takisi moni aleaká numúnegú minokugo ánigoake láa loko lo nimimó: Geza nene némegetoko ano. Loko lo nemekago, ámegetoko vumó. ");
INSERT INTO gah_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Izesugegi není numukú iteko minunike nosánetá noko minuhá. Lá nouko, takisi aliaká a vegi netá golesa aliaká a ve lugáagi mukí keza iteke mini miní ameke minake nosánetá namó. ");
INSERT INTO gah_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ninago Palisaio monó ve nenete ánigiake ametipo nana igo takisi aliaká ve sukagi netá golesa aliaká nia ve lugáagi makó minake nosánetá nonave, liki nene Izesuni izegipala zuha loká ilitamó. ");
INSERT INTO gah_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Li limikago nene, Izesú geleake láa loko limó: Keza kivisemigo ha minamoláate lusa vemú sele lisá amave. Kivisi vegenalitegó nene lusa vemú sele liaká niave. ");
INSERT INTO gah_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Itó lekeza nene monó gotolaú Ómasímo li gakó makó lá oko nemómámini mogonáa nene gili vevesiki gililo: Neza nene guguni gizi nimitave loko gelesá amuve. Likigika hizi kimiakakumú geleaká nouve. Itó kugupeninimú hee loko noune liki liaká nia vegená kelémo otopá zitove loko lememumó neve. Neza nene lihimáinigi vegená kelémo otopá zitove loko lumumóma nenae, loko limó. ");
INSERT INTO gah_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Gamena neneloka monó nagamí holokimiaká ve Zonini izegipala keza Ómasímo nosánetá mosekuko lelikumú litihe liki liaká a ve nenete Izesutoka viki alegesá iake láa liki loká itamó: Leza nene Palisaio monó vegenaki monokumule loko nosánetá nene mosé mosé oaká noune. Itó geí izegipaka zuhá keza mosisá amave. Nanamú neve. ");
INSERT INTO gah_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Liki likago nene, Izesú láa loko lo kimimó: Ve makolímo agivelagegi makó kogoliza viziki minata zupa nene agivelage aikumú miluma giliiki nosánetá mositahe. Lá oko nomive. Minoko gala vete ámina ve nene kigizakutí ipá iki apili hilikiko nene, keza miluma giliiki nosá netá mosinigave. Ámináminiki izegipáne zuhate alika nenikumú miluma giliki mosí mosí itamóza, itína lá oko nomive. ");
INSERT INTO gah_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Makó nene lavolavo gó nene litaha lokoko hukokiko nene, lavolavo gosohá nene nagamí ziki ali koma ama lavolavo nene hukoko ale litaha lavolavoló molo apizeko akotoakaláa nomive. Akotiiki nagamí zikiko nene gosohá lavolavo nenémo litaha lavolavolotí hikelekiko litaha gó nene hukoloko voko huko napa inogo ive. ");
INSERT INTO gah_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Itó makó nene vain nagamí gituhú galakalá noigo nagamí getununi litahagú ligi milisá amave. Vain nagamí nenémo gituhú galakalá nooko giputooko litaha getununi zeko ategekiko vain nagamiki itó goni getununigi nene latila okative liki vain nagamí gosohá nene goni getununi gosohakú leke moloaká noune. Lá okuko getununigi vain nagamiki lamaná oko minanogo ive. Loko limó nene litaha monó sunímini amupiló nene ezáa gosohá monó molo apizeakaláa nomive loko nosánetá moseakakumú anoza gakó lo kimimó. ");
INSERT INTO gah_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Izesú nene gakó lo kemeko noigo nene, monó gizapa ve makolímo oko gupá ze amike láa loko limó: Není mohóne nene itína mota helekaze, nenemú nene voko gigizanitunú ale geleko nónohá zemikoko alémo otitane loko gelémoko vitove loko nouve. ");
INSERT INTO gah_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Loko lo amekago, Izesú nene oteake izegipala zuha lezagi nene ámegetoko vunimó. ");
INSERT INTO gah_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Novuko nene, vená makó nene ikanímo apelekago númase gapo molova molova oko noigo kilisimasi 12-a ale ahulamó. ");
INSERT INTO gah_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Eza nene agikatunú láa loko gilimó: Neza nene voko Izesuni agupeló ahe itó hanuva luhoaká gotó ale gelekinake zokatove. ");
INSERT INTO gah_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Loko geleake Izesuni amegesaló oko noike luhoaká gó agataloka ale gelekago, Izesú nene viligoko láa loko limó: Mohó geza goha gena givisemino. Gele alévolé anitímo gelémo zokokave, loko nene lo amimó. Loko agata ateleko noligo litá oko zokamó. ");
INSERT INTO gah_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Lá okago, Izesú nene vike monó gizapa vemámini numukú iteko ánigamó nene, musiki ziaká a ve alegesá iki niago ive nama nenémo notoloni lemeko minamó. ");
INSERT INTO gah_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Nego, Izesú nene itike alémo otitove loko geleneike láa loko limó: Ahuliiki vilo. Imane mohó nene helemive. Hanuva avó akonoive. Loko lokago nene, keza nene giza gakó lihe liki giza itamó. ");
INSERT INTO gah_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Giza nitago nene, kimisele hetoka oake, mohóma ako mina holomaloka nene vimó. Vo alí loake agizató ale notigo mohó nene otimó. ");
INSERT INTO gah_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Otekago, nenémini gakola nene mikasi nekisa vokisauka vo asú imó. ");
INSERT INTO gah_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Lá okago, Izesú nene ámina numuni apá ahuloake novigo, kogómula lika ve lositá nene ámegetiki vasimó. Ámegetiki nivasike nene gamoga giki sele liki agulizaki ve napa Tevitini agávolagamaka lelikumú milumavate geleletamane. ");
INSERT INTO gah_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Liki likasigo, voko numukú itekago nene, ámina ve lositá viki amatoka minikasigo nene, Izesú loká oketake láa loko limó: Lokogómula ale goloutato zámuza nenitoka nemó nene mota gili alévolé inasihe. Loko loká okimikago keza láa liki lasimó: Guivahanitemaka, mota gele alévolé onousimole. ");
INSERT INTO gah_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Liki likasigo Izesú nene kogómulaló ale nogilike láa loko limó: Gili alévolé asitímini gihila nene utó ino. ");
INSERT INTO gah_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Loko lokago, kogómula goloutokago, Izesú nene láa loko lo kimimó: Gilinasihe. Lá oleketu netakumú viki vegená li pou lamilizo. ");
INSERT INTO gah_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Loko lokago gakó nene gililiki vasimóza, ámina gakoláa li pou likasigo, mikasi nekisa vokisauka nene puu loko vo asú imó. ");
INSERT INTO gah_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Itó nivasigo nene, ve makó holosi makolímo agepa ze lakolí okago mina ve nene zaló miliki alikamó. ");
INSERT INTO gah_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Aliki ikago, Izesú nene holosi apeleko amiseleko ale ahulamó. Alahulokago, litá oko gakó limó. Ámina netá nene vegená mukilite ánigiake sigaga lake Isilae mikasigú gozapá netá némináa makó utó igo ánigamuháma neve. ");
INSERT INTO gah_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Liki lamóza, Palisaio monó ve keza Izesukumú nene holositini agulizaki ve nenémo alémo vatí igo holosi nene kepeleko kimiseleaká noive, liki lamó. ");
INSERT INTO gah_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Lá ikago Izesú nene numutó namató mohona ike apá koma napa nene ánigo asú imó. Ánigo asú ike, monó numuni minakú minakú nene monó lo keme keme oko minamó. Lá ike nene, Ómasímini gizapaló minoakalímini gakó lamaná nene lo utó moloko lo kemeko mohona imó. Itó haitopaitó netá gizale vegená itó haitopaitó netá kivisi vegená kelémo zokomo vimó. ");
INSERT INTO gah_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Lá oake vegená mukí ánigamó nene muhelé ahelé ake gopa iki minamó. Sipsip iza gizapa venini nomigo hanuva minamó nenéminiki minikago, Izesú ánigoake agika hizekago ");
INSERT INTO gah_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","izegipala zuhama anoza gakó makó láa loko lo limimó: Vegená imane latila ikataze. Mikú nosánetá mukí omolokamóza, hoza aleaká ve nene lagasó minokunize. ");
INSERT INTO gah_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Nenemú lekeza mini amelahitoka likiko nene hozaló ve makó kimiselekiko viki hozavagú minumuni alitaze, loko limó. ");
INSERT INTO gah_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Izesuni izegipala zuha 12-a alesa molo lemekago, okuko nene, kigikagú holosi minatamó kipiliki kimisilitave loko itó haitopaitó netá gizalinita vegená itó haitopaitó netá kivisiti vegená kilími zokatave loko zámuza nene limimó. ");
INSERT INTO gah_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Aposolo 12 leza lugulizate nene makó agulizá Saimon agulizá gosohá nene Pitá, itó agunala Etulú, itó Zepetaioni gipala Zemusí itó agunala Zoní, ");
INSERT INTO gah_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","itó Pilipó, itó Patolomaió, Itó Tomasí, itó Mataiona neza takisi moni aleaká u ve nene, itó Alapaioni gipala Zemusí itó Tataió, ");
INSERT INTO gah_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","itó Saimoná eza Lomagatí gamani amisele ahulanogo i ve, itó Kaliotó apakutí Izesuni amimika li ve Zutá. ");
INSERT INTO gah_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ámina ve 12-a nene nolimisilike hoza gakó láa loko lo limimó: Lekeza nene hetoka vetini mikasigú itó Samalia vegenalitini apá makotoka ma vamilo. ");
INSERT INTO gah_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Isilae vegená lugáagutí sipsip iza vi tolova amó keitokagó nene viki ánigalo. ");
INSERT INTO gah_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Niviki monó nene láa liki nene lilo: Ómasímini agulizaki ve napámini zámuza nene omo lokovogisaloka okave. ");
INSERT INTO gah_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Nenemú kivisimoláa kilími zokataze, itó helemoláa nene kilími otitaze, itó halamé gizalemoláa kilími gililitaze, itó kigikagú holosi golesa minatamó nene kipiliki kimisili ahulataze. Meinaváa nomimó hagitana lehizeleketumó nenazo, nenemú meinaváa nomitimó hanuva kilími lamaná ilo. Itó moni koma lagasoláagi ma gúiki alemilo, keké. ");
INSERT INTO gah_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","10","Gapo vitatoka akiseaká gó aliki vamilo. Itó gó lositá nene luhamilo. Itó likigisaló suú nene luhamilo. Itó hánusaló nene alemiki hanuvagó vilo. Vegená makolititoka hoza alita ve nenete ámina vegenalitinigutí nosánetá aliki niki minatamó nene lamaná itive. ");
INSERT INTO gah_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Itó apá nenelokahe nenelokahe viki anitiiki nene ganá nene apá amelagini loká iki mogonáinimú gililo. Makolímini mogona lamaná itimó nene, aí numukú itiki miniki nene ámina numukukó akiliki viki otiki vitaze. ");
INSERT INTO gah_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Itó numukú itiki niminiki nene hulu nene lekelitoka minino liki li kimilo. ");
INSERT INTO gah_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Numuni amelage likilími milikikoma, miniki ámina gakó li kiminamó nenémini gihiláa utó itimóma neve. Itó minikiko mogonáini lamaná amikoma nene, hulu gakolímini gihiláa nene goha atiginá oko lekelitoka anogo ive. ");
INSERT INTO gah_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Itó apá makokú likilími lamaná iki gakotini gelemikoma nene lekemegesa vizi kimiiki niviki nene vahé miliki likigisagutí mumusopa usagamá zi ahuliki vilo. ");
INSERT INTO gah_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Neza lamaná lo likimitoze, gililo. Gamena napaló nene Soto apakú itó Gomola apakú mina vegená keza lihima koma alinigave. Itó likilími lamaná amita vegená nene lihima napa itiki alinigave. ");
INSERT INTO gah_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Gilinahe. Sipsip izagitana nene hela galatini holúikú geha ziki minatave loko nolikimisuluve. Nenemú lekelisi nene gili guni i miniki hulu iki minalo. ");
INSERT INTO gah_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Keza nene likigizató aliki gonitó likilímiki vinigave. Itó monó numúikú numúikú nene segi nogosani likipilinigaze. Ehe, lekeza gizapa alévolé iki minalo. ");
INSERT INTO gah_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Itó není nugulizá lekelitoka minakumule liki kugulizaki vetini itó kiapegini kovogisaló likilímiki vikiko nene gakó hoza alilikitanigave. Lá niko nene, lekeza keí kovogisaló itó hetoka vetini kovogisaló není monó li utó itave. ");
INSERT INTO gah_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Není gakónemule liki gonitó likilímiki vita gamena nene, gakó nanave loko litupe itó gakó nana oko geleko litupe liki lakagata giliko gena amino. Gamena nene zupa nene gakó litave loko Sikalahú nenémo likigikagú mololeketanogo ive. ");
INSERT INTO gah_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Lá okiko, gakó likiko nene, lekelí gakó loló aminogo ive. Ametipini Sikalahú nenémo likigikagú gakó lo nomiliko linigave. ");
INSERT INTO gah_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Itó uvolaho makó nenémo agunala nene agizató alekoko goní omikiko nene agunalama apili hilinigave. Itó amelaho nene gipala nene agizató alekoko goní omikiko nene gipalama apili hilinigave. Itó izegipáini keza izóikini améikini nene goní ikimikiko izóikini améikini kipili hilinigave. ");
INSERT INTO gah_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Itó vegená mukilite není nugulizá lekelitoka minakumule liki mukahá likipilinigi niamóza, makó keza gamenaváini asú ititó monó ahulamiki alévolé iki miniliki vitamó nene Ómasímo kugutó vizinogo ive. ");
INSERT INTO gah_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Itó apá makotoka gopoguni mililikitikoma, golisi iiki apá makotoka nene vilo. Neza lamaná lo likimitoze, gililo. Lekeza monó hozaló Isilae mikasiuka mukí apató vi asú amiko okulumakutí lumu ve gihila neza litá oko anitinogo uve. ");
INSERT INTO gah_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Sukulu izegipa nenémo tisala avilegeakaláa nomive. Gelekelé izegipa nenémo agulizaki veva nene avilegeakaláa nomive. ");
INSERT INTO gah_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Lá onoinazo, sukulu izegipa oko moloko itimó nenémo tisalámini lelegitó onoikoma etanogo ive. Itó gelekelé izegipa oko moloko itimó nenémo agulizaki vevámini lelegitó onoikoma etanogo ive. Ámináminoko ametipina nenikumú holositini gizapa ve Pelezepulole liki linamó nenazo, izegipa nugunamotamó neneta, lekelí lukugulizá aliki mumusopa ziliki viki minanigave. ");
INSERT INTO gah_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Nenemú gopoguni mililikitata vegenakumú lekelegesá legemino. Hitonoiti netá matá nenémo minoko tolova aminogo ive. Minoko utó o asú ititó neve. Itó asuguná ne netá nenémo minoko utó o asú inogo ive. ");
INSERT INTO gah_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Neza nene límugusigú legesó oko lo lukumu gakó nene lekelisi miniki hanató li utó itaze. Itó lakagatauka musika loko lo lukumu gakó nene lekelisi miniki numuni hetotí gakó napagutí li utó iki litaze. ");
INSERT INTO gah_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Vegená makolite lukugupegó nene apili hilinigave. Lekemeni apili hiliaká zámuza keitoka nominazo, keikumú nene lekelegesá legemino. Itó lekemeni nemó itó lukugupe nemó ale nupa napa oko ló apakú apele heleaká zámuzagi ve Ómasimú nene lekelegesá ligino. ");
INSERT INTO gah_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Somohá nene ha netá neve. Itó golohá monitunú nene nama somohá lositá meina hizeakaláa nemóza, ametipo gelemikoma nama somohá hamokó nene nene mikasigú lememinogo ive. ");
INSERT INTO gah_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Lekelí gototini zopovatini gatoakaláa nene Ómasímo gele asú oko geleneive. ");
INSERT INTO gah_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Lekeza nene nama somohá niamave. Lekelisi nene vegená nianazo, itó Ómasímo gizapa olikimiaká noinazo, nenemú lekelisi nene netá makokumú ma lekelegesá legemino. ");
INSERT INTO gah_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Vegenalitini kovogisaló není nugulizá li utó iki nilími napa ita vegená nene neza ámina oko okulumakú aménehini avogisaló kelémo napa oko litomóza, ");
INSERT INTO gah_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","vegenalitini kovogisaló nenikumú zivi hitivi ita vegená nene neza ámináminoko okulumakú aménehini avogisaló keikumú zevo hitovo inogo uve. ");
INSERT INTO gah_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Nenikumú nene mikasiuka nonagá ale utó inogo limimóma neve liki lamilo. Neza nene nonagakigó nomive. Lovagi ale utó itove loko lumumóma neve. ");
INSERT INTO gah_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Neza lumumómámini gihila nene amelahiko gipalago lovaleta lavaleta iki kogoka hotó itimó neve. Itó izolahiko moholago lovaleta lavaleta iki kogoka hotó itimó neve. Itó anohúvolahiko avolahiko lovaleta iki kogoka hotopotó itimó neve. ");
INSERT INTO gah_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Itó lekelí numutikú lekelí zuhate gala velini lilí inigave. ");
INSERT INTO gah_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Itó lekeza izotikini ametikiniloka likigika kimiiki itó nenitoka koma nimitamó nene, není mututoni minata avotigila iki niamave. Itó izegipatiniloka likigika kimiiki itó nenitoka koma nimitamó nene, není mututoni minata avotigila iki niamave. ");
INSERT INTO gah_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Itó zohota zaló kipili hilinigi miluma netá ali gihikitatakumú gili ahuliiki nigizaka hiziki némegetiki amitamó nene není mututoni minaminigave. ");
INSERT INTO gah_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Itó makó keza nene kigika kemeníini ale gikitiiki ali minatamó nene, miniki gopa itamó neve. Makó keza nenikumule liki kigika kemeni vínasatamó nene alévolé kemetameni alinigave. ");
INSERT INTO gah_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Vegená makó keza lekelí nasahilí ilikitatamó nene není nasahilí inimiaká niamó gelekave. Itó nasahilí initatamó nene nimisili vema nasahilí imiaká niamó gelekave. ");
INSERT INTO gah_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Vegená makó keza monó lole ale ve noikumule liki monó lole ale ve makó nasahilí itatamómámini meinaváa alinigave. Itó vegená makó nenete monolagi ve noikumule liki monolagi ve makó alími lamaná iki nasahilí itatamó nene, nenémini meinaváa alinigave. ");
INSERT INTO gah_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Neza lamaná lo likimitoze, gililo. Lekeza nene není vegenáne zuhagutí makó limiki minatamoki keikutí makó nene není gipa noikumule liki gosohá nagamí ihiki amitamó nene, haha aminogo ive. Meinaváa alitamó neve. ");
INSERT INTO gah_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Izesú nene izegipala zuha 12-a nene ámina gakó lo leme asú oake, leza voko minuhá numutó numutó monó lo kemeko apí okiminogo vimó. ");
INSERT INTO gah_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Lá okago, monó nagamí holokimiaká ve Zoní nene nagá numukú noike netá golesagutí gologí olimiaká ve Kilistó ave loko loaká nouni vémo hoza alimó nenémini gakoláa geleake, izegipala zuha losi nene kimiselekago Izesú noitoka vasike láa liki loká itasimó: ");
INSERT INTO gah_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Utó itive liki monó gotolaú luhuva gizina vema nene géisi noape, itó alika makó utó itikumú ageva itunimó nehe, liki loká itasimó. ");
INSERT INTO gah_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Loká itasigo, Izesú nene ámina vema noive loko Zoní gilitive loko láa loko lo kimimó: Lekeza nene atiginá iki viki nene loló nou netá matá imane nánigasimó nenémini gakoláa avetó iki Zonini li amilizo. ");
INSERT INTO gah_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Kogómula lilikupá molamó nene kogómula ale hanatokimiaká noive. Itó kigisaló alimó nene kigisa ale lamaná okimiaká noive. Itó halamé gizalemó nene kelémo gileleaká noive. Itó kagata molamó nene kagata ale koló okago gakó giliaká noive. Lepa gonosi nene kelémo oteaká noive. Itó limiki minamó ámemena nenete gakó lamaná nene giliaká niave. ");
INSERT INTO gah_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Lá onoinazo, není mogonamú kagata losi pasi gelemitamó nenete kogoliza viziki minanigave. ");
INSERT INTO gah_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Loko lokago, Zonini izegipala zuhama atiginá iki nivasigo, Izesú eza vegenala sii sii liki minamoláa nene Zonikumú láa loko lo kimimó: Lekeza nene mikasi gomopalaló nanámini o mina ve ániganigi vamóma neve. Zoní nene hepelímo gihinahisi ale volaloka imaloka imómámini noigo ániganigi vamóma nehe. ");
INSERT INTO gah_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Itó eza gola gonanalivagi luhoake noigo ániganigi vamóma nehe. Óe. Gó luhuvagi luhiaká nia ve nene kugulizaki vetini numukú akiki otiki iaká niave. ");
INSERT INTO gah_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Zoní nene Ómasímini agepagutí gakó loaká ve noigo ániganigi vamó nehe, olo. Neza lo likimitoze, gililo. Lekeza nene ánigi mina vema nene Ómasímini agepagutí gakó loaká ve lugáagitana minamimó neve. Eza haitolímini okave. ");
INSERT INTO gah_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Monó gotolaú Ómasímo li gakó makó láa liki gizinamóma neve: Gililo. Neza nene gakó lole ale ve makó amiselekugo áisi voko ale goí oko kigikagú hoza aleko gapo velegetanogo ive. Ámina gakó nene Zonitoka voko alimó neve. ");
INSERT INTO gah_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Itó neza lamaná lo likimitoze, gililo. Mikasiuka utó ina vegenakutí makolímo monó nagamí holokimiaká ve Zonini nene ma avilegesá amimóza, Ómasímini gizapaló limiki niamolategi gopa Zonini aviligitigí iki niave. ");
INSERT INTO gah_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Zoní nene monó nagamí holokimiaká i gamenalotí minoloko iteko okulumalímini gapo nene utó o lamaná oko utó noigo, vegená mukilite amuza miliki lovasava iki okulumalímini lapanala ali lá iaká niave. ");
INSERT INTO gah_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Zoní velesá utó amigo Ómasímini agepagutí gakó liaká a vegi Moseki keza mukitoka alika utó iti netakumú epoapoga liki Ómasímo agulizaki ve napa alemó utó iti gakó liliki vamó. ");
INSERT INTO gah_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Itó gilitune liki nilikoma makó lo likimitoze, gililo: Ve makó Ómasímini agepagutí gakó loaká ve Ilaizakitana ative liki lina ve nene Zoní noave. ");
INSERT INTO gah_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Lá onoinazo, lekeza lakagatagi minatamó neneta ámina gakó lonoumó nene gili vevesiki gililo. ");
INSERT INTO gah_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Oko moloko oaká nou netá ánigina vegená nene nanetató lo moloko nolugo vo guni itive. Keza gili goselé iaká nia izegipagitana niave. Izegipa keza alegesá apató niake kigivéikini nene sele liki láa liki li kimiaká niave: ");
INSERT INTO gah_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Leza nama luható nene nanamú lisá amave. Itó helegaloka ive nama uható nene nanamú ive nama isá amave, liki liaká niave. ");
INSERT INTO gah_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ámináminoko Zoní nene hozava apí oake nene nosánetá lamaná namike vain nagamí namike etó oko minamó. Etó oko noigo ánigiake holosi makolímo agika ale gopa okago noihe, liki nene lamó. ");
INSERT INTO gah_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Itó helegaloka neza okulumakutí lumu ve gihila okuke iza goula zahí nagamí nosánetá lamaná nonugo, ánigiake láa liki nilave: Ve imane nene ánigalo. Áisi nene gasova ve itó nagamitó ve noike takisi aleaká vegi itó netá golesa aliaká nia ve lugáatini zogonini noive, liki liaká niave. Lá onoimóza, Ómasímo gele guni oko netá matá aleaká noimó nenémini gihiláa utó okago, vevesokogó minoaká noimó nenémini mogonáa nene utó oaká noive, loko limó. ");
INSERT INTO gah_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Izesú apá lugáaloka nene hoza aleloko vike alévolé suni haitolímini mukí ale utó imó. Ale utó okago ánigamóza, ánigi hagele gele iake kigika ali viligamago, gahá kemeko láa loko nene limó: ");
INSERT INTO gah_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Agae, Kolazina amelagita. Agae, Petesaita amelagita. Lekelitoka nene golivagi netá utó inogo ive. Golesa netá aliki minakumú nene Tulo apá itó Sitona apá gozapá tui loko vimóza, alévolé suni lekelitoka alumó nene ámina apá lositatoka utó imó nelina, keza nene gozapá miluma giliki kigika ali viligamó nenémini mogonáa ali utó iki ginegane línaha luhiake lánehá nene kugupeló hiliki hanuva minaline. ");
INSERT INTO gah_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Nenemú lo likimitoze, gililo. Tulo apató itó Sitona apató vegená keza gamena napaló nene lihima koma alitamóza, lekelisi nene lihima napa alinigave. ");
INSERT INTO gah_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Itó Kapanao amelagita lekeza lukugulizá nene okulumakú ititive liki ali otiaká niahe. Nenéminoko nomive. Lokú lekehelú inogo ive. Alévolé suni lekelitoka ale utó umó nene Soto apakú utó imó nelina, kigika ali viligikago ámina apá nene tui loko vamiline. Imane gamenaló nene hanuva minalinamó neve. ");
INSERT INTO gah_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Nenemú lo likimitoze, gililo. Lihima kimiti gamenaló nene Soto apatoka nene lihima lagasó keitoka utó inogo ive. Itó lekelí nene ale nupa okoko genavaló geheleketanogo ive, loko limó. ");
INSERT INTO gah_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Gamena nene zupa Izesú gakó láa loko nene limó: Aménega, geza okulumaki mikasigi keí Guivahani géisi nene noane. Sukulu lunike gele vevesokune liki liaká nia vegená keza monoka giliiki gili guni ikatave loko ale halá geko molokimikanike nene sukulu lamake izegipa namunigitana iki mina vegenalitini kigikagú molokimiaká noane. Lá oaká noanikumú gegepoka noluve. ");
INSERT INTO gah_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Aménega, nenéminoko utó oloko vitive loko gelenanimó nene etoaká noive. ");
INSERT INTO gah_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Loko loake, miní ameko láa loko limó: Améneho netá matá mukí nene nigizakú molo asú okave. Lá onoimóza, Ómasímini gipalámina mogona gili vevesina vegená ma niamave. Améneho hamokó geleneive. Itó aménehini mogona nene ve makolite gili vevesamave. Gipala noutímina itó nezáne lo utó oko lo kemekugo ánigi hehe litave loko gilito vegená niamoláa lezategó aménehini mogona gelenoune. ");
INSERT INTO gah_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Goselekaselé iki muhelé ahelé iki nia vegená itó haitopaitó netalímo gena likiviseaká noi vegenalita mukitoka nenitoka imi asú iki alo. Lekelémo geha zinogo uve. ");
INSERT INTO gah_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Neza nene zou loko nouve. Itó nigika lamanaki nouve. Ikiko nene nigínaloka hévetú nemó nene mololeketatoze. Mololikimikugo nene nenitokatí gakó lamaná gilitaze. Itó lekemenitini nene avasú vizeko mino lamaná oko minatize. ");
INSERT INTO gah_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Není nigínaloka hévetú nemó nene huluváa lamaná neve. Itó genavagi nomive, loko limó. ");
INSERT INTO gah_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Gamena nene zupa holisi makokú Izesú ale goí igo izegipala zuha leza kilé mikú mohona oko vunimó. Novunike nene, izegipala leza gaúna helekunike kilé akutokunike gihiláa hiseko nomo novuko nene, ");
INSERT INTO gah_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Palisaio monó ve keza ánigiake gili golesa ake Izesuni nene láa liki li amemó: Ánigozo. Izegipakamate netá nalemó nenémo nene golesa okave. Lelí holisigú hoza nalemó nene lá amoakalímini ikave. ");
INSERT INTO gah_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Liki likago, Ómasímo vegenala zuhate netakumú vitagá niko ezáa lo huka gakó nene hanuva molo gaheva itimó neve liki gilitave loko láa loko lo kimimó: Gozapá agulizaki ve napatipo Tevití nene vegenala zuhagi nosánetakumú gaúna hiliake netá makó alemó nenémini gakola monó gotolaú luhuva gizikago lekeza gatinamóza, mogonáa gilisá amahe. ");
INSERT INTO gah_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Tevití eza nene Ómasímini monó numukú itekago guguni gizoaká ve napámo Ómasímini avogisaló mila peleti nene amekago namóma neve. Itó vegenala kezagi namóma neve. Itó ámina peleti nene hanuva vegenalite namitave liki guguni giziaká vetegó natave liki monó gotolaú li hukinamóma neve. ");
INSERT INTO gah_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Itó Mosé nene guguni giziaká ve keza holisigú nene monó zagusaveú hoza aliki niake nene holisimú li hukina gakó nene avutá apiliaká niamóza, áminámo lihima keitoka minosá amive loko luhuva gizonoimóza, nene gatiki gilisá amahe. ");
INSERT INTO gah_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Nénisi nene lo likimitoze, gililo. Likigilikagú noutímina nene monó zagusave avilegeko nene nouve. ");
INSERT INTO gah_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Itó monó gotolaú Ómasímo li gakó makó lá oko neve: Neza nene guguni gizi nimitave loko gelesá amuve. Likigika hizi kimiakakumú geleaká nouve. Lekeza nene ámina gakolímini mogona gelelina nene, lekeza lihimaváini nomiti vegenalitini lihimáinimú gakó hoza alikitamaline. ");
INSERT INTO gah_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Okulumakutí lumu ve gihila neza nene holisi amelahina nounazo, izegipáne zuhate holisigú lilí ita netá nene není netá neve. ");
INSERT INTO gah_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Láa loake, nenelotí oteake vike monó numuni makokú nene itimó. ");
INSERT INTO gah_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Itimó nene ve makó agizani lugaloka nakeseta ve noigo, ve lugáa keza Izesuni loká itake lelí holisigú nene vegená kelémo zokoakaláa nene nehe nomive, liki nene lamóza, hanuva nene Izesuni imane nana gakotó ale moloko lokinake goní otatune liki, gimivagú miliki nene lamó. ");
INSERT INTO gah_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Lá iki gimivagú milikago, Izesú nene kigikagú emane ánigo vevesoko ánigoake láa loko limó: Lekelikutí makó nenémo nene sipsip iza akaleváa makó nene holisigú nene gale hánagú velehé limitimó nene, holisimagule lokoko ahulokiko áminagú minatimó nehe. Óve, ale gelelehá oko ale veletoka alahulatimó neve. ");
INSERT INTO gah_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Lá itimóza, sipsip nene ha netá neve. Itó vegená lélisi nene netá gihiláa noune. Nenemú holisigú nene vegená kelémo lamaná oakaláa nene neve. ");
INSERT INTO gah_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Loko loake ámina ve nene gigizani lutozo loko lokago, agizani lugaloka nene lutokago, agizani magáa minamómámini oko goha lamaná imó. ");
INSERT INTO gah_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Lamaná okago nene, Palisaio monó vegená keza ámina netá ánigamó. Ánigiake limiki viake Izesuni nene nana inake apele hilitune liki lova gizamó. ");
INSERT INTO gah_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Lá okago, Izesú ámina gakó geleake nene, numuni apá ahuloake apá makotoka vimó. Lá oko novigo mukí vegená ámegetiki vamó. Lá ikago, kivisi vegená mukí nene kelémo zokoake nene, ");
INSERT INTO gah_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","aí mogonáa nene avetó iki lili ali amitave loko lo hukoko loketamó. ");
INSERT INTO gah_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Láa loko lokimikago, Ómasímini agepagutí gakó loaká ve Isaiá anoza gakó makó láa loko luhuva gizamó nene gihila zimó: ");
INSERT INTO gah_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Ómasímo láa loko nolive: Gelekelé izegipáne alémo etó umó nene ánigalo. Nigika amenouke aikumú nene gele lamaná oaká nouve. Itó neza Sikalahúne nene aí amupiló molokugo alémo vávani okiko, hetoka ve numutó namató vegená nene lihimáinimú gona moloketati gakó nene lo utó oko lo kimitimó neve. ");
INSERT INTO gah_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Eza lovaleta oko gopaga lamoko gapoló gakó napagutí laminogo ive. ");
INSERT INTO gah_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Vegená ámemenáa limiki minamó nene ma kelémo golesa o asú aminogo ive. Limiki mina vegená nenete gelemó ló guluma koma nenéminoko nemó nene ma ze lihaminogo ive. Itó lá okoko hozaváa amuza moloko aleloko voko miniko nene, ale kegesoaká nenémo netá mukí kivilegeko minanogo ive. ");
INSERT INTO gah_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Lá okiko, hetoka ve numutó namató vegenalite kigika nene aí agulizató ali miliiki aikumú kagata losi gelemiki ageva iki minanigave, loko lo hukoko limó. ");
INSERT INTO gah_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Nene gamenaló ve makó nene holosi makolímo agika ale gopa oko agómula lika ve itó agepa hize lakolí okago mina ve nene Izesú noitoka alímiki vamó. Alímiki vikago, Izesú nene alémo lamaná okago, ve eza agómula goloutoake nene, gakó limó. ");
INSERT INTO gah_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Gakó lokago nene, vegená mukí nenete ánigiake sigaga litake agulizaki ve Tevitini agávolaho ative liki la ve netihe. ");
INSERT INTO gah_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Liki likago nene, Palisaio monó vete ámina gakó giliake láa liki lamó: Pelezepuló eza holositini agulizaki ve loló oake alémo vatí igogó holosi nene kepeleko kimiseleaká noive. ");
INSERT INTO gah_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Liki likago, Izesú nene kigikagú gakó hanuva geleake láa loko lo kimimó: Mikasi makotoka vegená keza hizi hoú liiki lova gopa hizitamó nene, keí mikasi gámé minatimó neve. Itó apá makotoka itó numuni makokú vegená keza hizi hoú liiki eza akohú apiliko eza akohú apiliko itamó nene hutilí iki vinigave. ");
INSERT INTO gah_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Itó Satá ezáa izegipala zuha kepeleko kimiseleneitimó nene, aí avogisaló nene itína mota hizi hoú liake alévolé iki minamitamó neve. ");
INSERT INTO gah_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Lekeza nenikumú Pelezepuloni zámuzatunú holosi nene kepeleko kimiseleaká noive liki liaká niave. Láa likima nene lekelitini izegipatini zuha nenete nene Satá ámina oko kelémo vatí igo holosi kipiliki kimisiliaká niahe. Óe, lá oko nomive. Nenemú kéisi nene soza gakotinímini mogona hanuva ali utó itamó neve. ");
INSERT INTO gah_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Lá onoimóza, nénisi nene Ómasímini Sikalahulímo nelémo vatí igo holosi nene kepeleko kimiseleaká nounazo, Ómasímo agulizaki ve napa ale utó oleketamó nenémini zámuza lokovogisaloka mota omo ávatiha onoimó nenémini mogona mota utó okave. ");
INSERT INTO gah_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ve makolímo gasovagi ve amuza ve makolímini numukú nene litá oko iteko henokanona nene ma ipá oko alitihe. Nenéminoko nomive. Gasovagi ve amuza vema nene goí oko agisa agizató nagá aleakaláa nene neve. Lá okogó aí henoni ipá inogo ive. Loko limó nene Satani zámuza avilegeake holosiva kepeleko kimiseleaká nouve loko lo moloko limó neve. ");
INSERT INTO gah_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Loko loake makó láa loko limó: Makó keza nene nenikutí ve minamitamó nene není gala ve minanigave. Ve makó keza nilími vatí iki vegená kilími nupa amitamó nenete kilími hutilí iaká niamó geleneive. ");
INSERT INTO gah_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Nenemú lo likimitoze, gililo. Ómasímo golesa netá haitopaitó itó alivi letivi liaká haitopaitolímini nenémini lihimavala ahuloaká gapo nemóza, ve makolímo Sikalahukumú alevo letovo oko litimó nene Ómasímo ámina lihima ahulotati gapo nomive. ");
INSERT INTO gah_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Makó keza okulumakutí lumu ve gihila není imane alivi letivi itamó nene Ómasímo ámina lihima nene hanuva ahulokimiakaláa nemóza, Sikalahukumú alivi letivi iki lita lihima nene mikasigú nemó itó okulumakú nemó nene ma asú amititó neve. ");
INSERT INTO gah_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Lekeza nene za gihila lamaná makó ánigiiki za lamanakutí neve liki litaze. Itó za gihila golesa makó ánigiiki nene ámina iki za golesagutí neve liki litaze. Za gihila nenémo zámini mogona ale utó oaká noive. ");
INSERT INTO gah_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Gosihalímini agapilamó zuha lekelisi nene niave. Mogonatini golesagi nianazo, gakó lamaná ma lisá amave. Ligikagú vaí o minakutí legepatunú loaká noune. ");
INSERT INTO gah_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Vegená lamanalitini kigikagú nene netá lamanakó ititimó nenazo, kigikagutí nene vatí sunigó utó itimó neve. Itó vegená golesatini kigikagú nene golesa netakó minatimó nenazo, kigikagutí ámináminoko golesa sunigó ititimó neve. ");
INSERT INTO gah_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Nenemú nénisi lo likimitoze, gililo. Lihima aleaká gamenaló nene vegená mukilite ha gakó haitopaitolímini gopa linakumú nene gakó hozava aliiki asenini hiziki lúitamó neve. ");
INSERT INTO gah_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Gakó lanimó nenémo oko moloko animómámini mogonaka lo utó molokiko, lamaná itimó nene, lihimaka nomitimó minatanimó neve. Itó golesa itimó nene, lihimaka ha minatimó neve. ");
INSERT INTO gah_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Láa loko lo kemekago, monó mogona apí ikimiaká a ve itó Palisaio monó ve lugáa keza gakó láa liki li amemó: Tisatemaka, geza nene alévolé suni ma ale utó okako nene ánigatune. ");
INSERT INTO gah_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Liki likago, Izesú láa loko lo kimimó: Oko moloko oaká nou netá ánigiaká nia vegená lekelisi nene vegená golesave itó monó gili ahuliaká vegená niave. Lekelisi alévolé suni ale utó okugo ánigatune liki liaká niamóza, lekelisi nene haitó suni makó ale utó ugo ánigaminigave. Ómasímini agepagutí gakó loaká ve Zonatoka emane utó i suni makó nenitoka utó okiko nenegó ánigatave. ");
INSERT INTO gah_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Zoná nene gamena losive makole nene lagaha sipisímini agatupagú minake goha otimóma neve. Áminagó oko okulumakutí lumu ve gihila nénisi nene gamena losive makole mikasigú mininake goha otinogo uve. ");
INSERT INTO gah_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Itó Zoná nene Ninive vegená monó lo nokimigo kigika ali viligamóma neve. Itó nénisi ató imane nene Zonakitana minamoko Zonani avilegeko noumóza, lekeza není gakó gili ahuliake likigika ali viligamave. Nenemú Ómasímo gona mololeketati gamena nene Ninive apá amelage nene otiki miniki oko moloko nou netá ánigiaká nia vegenalitini lihimáinimú lotuva liginigave. Lá ikiko lihima alitamó neve. ");
INSERT INTO gah_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Itó agulizaki vená Sipá mikasi emegaló minamó nenémo Ómasímo gona mololeketati gamena nene otekoko oko moloko nou netá ánigiaká nia vegenalitini mogonatini nene lotuva legekiko lihima nene alitamó neve. Ámina vená nenémo Salomó gele vevesoko gilimómámini gihiláa gilinogo mikasi hotokatí gapo hána hána amó. Itó nénisi ató imane noumó nene Salomoni avilegeko noumóza, lekeza není gakó gelemave. ");
INSERT INTO gah_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Holosi makó nene ve makolímini agikagutí iteoko avasú vizeko minati numunimú vitagá inogo vegená minama mikasiló voko mohona itive. Vitagá oloko novoko, ");
INSERT INTO gah_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","neza numúne nene ahulokuke umóma nenazo, goí oko minu numutoka goha atiginá oko vinake minatoze lokoko nene, atiginá oko, oko ánigatimó nene, ámina numuni lolopa gitiki ali guni inakú nene numuni gizapa ve nomiko ánigatimó nene, ");
INSERT INTO gah_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","goha nene ahulokoko voko holosi agivelagini 7-a nene kugupelotí sisipa anuva ovimó nene kelémoko oko áminagú nene limiki miniki aliki inigave. Lá ikiko, ámina ve nene goí oko golesa oko minamóza, íi, alika nene golesa o lamaná oko golesa inogo ive. Lá onoize, ve golesa áimane lekelitoka utó itikumú noluze, ehe. ");
INSERT INTO gah_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Izesú gakó lo kemeko noigo, amegesaloka nene izolage izegipa agunamotamola nene gakó lo amitune liki hetoka gizapa iki niago, ");
INSERT INTO gah_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","ve makolímo Izesuni nene gelenape, izokage izegipa gugunamotamokama gakó lo gimitune liki nene hetoka iki gizapa niave. ");
INSERT INTO gah_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Loko lokago, Izesú nene láa loko lo amimó: Izónege nugunamotamónemú lape. ");
INSERT INTO gah_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Loko loake, izegipa apala nouni liginaloka nene agizani hisú oko láa loko limó: Ánigalo. Izónege izegipa nugunamotamóne imane niave. ");
INSERT INTO gah_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Okulumakú améneho li gakó ámegetiaká niamó kéisi nene izónege izegipa nugunamotamóne niave, loko limó. ");
INSERT INTO gah_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Izesú nene ámina gamenaló numuni minakutí lemeake nonohuló agataló lemeko noike, ");
INSERT INTO gah_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","gakó apí okiminogo mitó minokago, ve vená mukí nene iki sii sii liki getatoka alegesá ikago, ánigoake vegená gikí akumule loko nagamikú lape makokú nene itimó. Iteko minake nene, ");
INSERT INTO gah_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","anoza gakó haitopaitolímini lo kimimó. Lá noike, makó láa loko limó: Gilinahe. Zuha netá atilí oaká ve makó nenémo netá gihila nene atilí inogo vimó. ");
INSERT INTO gah_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Vike mikuka atilí omo novigo nene, makó nene gapogú alemó zekago gaha namate ake ni asú amó. ");
INSERT INTO gah_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Itó lugáa nene gehani amupiló mikasi lagasó netó lemekago, mikasi hána nomimó nenazo, goloakaláa golokago litá oko itiha, ");
INSERT INTO gah_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","ho nolake avagugu vizekago, luhusa hána nomigo osagava vizimó. ");
INSERT INTO gah_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Itó gihila lugáa nene lilihámini luhusa nene mikasigú ha netó alemó zeake, goloko itekaha, lilihámo zetamó. ");
INSERT INTO gah_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Itó lugáa nene mikasi lamanakú lemeko minake goloko iteake gihila lamaná zimó. Zava makototí nene gihila 100 nene zimó. Zava makototí nene gihila 60 zimó. Zava makototí nene gihila 30 zimó. ");
INSERT INTO gah_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Lekeza lakagatagi minatamó neneta gakó imane gili vevesiki gililo. ");
INSERT INTO gah_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Gakó láa loko lo lemekago, izegipala zuha leza amatoka voko minunike geza nene anoza gakó nenémináa nanamú lo nokemene. ");
INSERT INTO gah_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Loko lokuko nene, eza láa loko lo limimó: Okulumalímini gasovaló minoakalímini asuguná gakó nene lekeza gilitave loko nene lonoimóza, lugáa keza gelemitave loko nene neve. ");
INSERT INTO gah_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Makó keza monó nene vatí iki gizapa iki ali minata vegená nene áminaló nene miní ameko kemekiko minumuni lamaná utó o kiminogo ive. Itó makó keza monó nene lamaná iki gizapa amita vegená nene hanuvagó ale minune liki litamóza ipá oko alekiko nene hanuva minanigave. ");
INSERT INTO gah_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Keza nene ánigatune liki ánigi-liki nivamóza, ánigi hehe lisá amave. Itó gilitune liki gilimi vaha vaha mogonáa nene gili vevesisá amave. Nenemú anoza gakó imane lo nokumuve. ");
INSERT INTO gah_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Lá okago Ómasímini agepagutí gakó loaká ve Isaiá alika utó iti netakumú lo ami gakó nenémo keitoka voko alekave. Ómasímo li gakó nene láa loko luhuva gizamóma neve: Lakagatatunú giliakaláa nene hanuva gilitamóza, gili vevesaminigave. Itó lokogómulatunú ánigiakaláa nene hanuva ánigatamóza, ma ánigi vevesaminigave. ");
INSERT INTO gah_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Vegená mulusi imane niamó kigika nene hize lí oake kigika kii lo vimó niave. Itó kogómula nene liko vimó niave, itó kagata molamó niave. Nenemú netá matá hanuva ánigoakaláa hanuva nánigave. Itó kagatatunú geleakaláa hanuva nigeleve. Kigikatunú nene gili lamaná iki nene ma gilisá amave. Lá iiki kigika ali viligisá amanazo, neza nana oko kelémo lamaná itomó neve. ");
INSERT INTO gah_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Itó Ómasímo nónohá zelikimikago, lekelisi nene lokogómulatunú ánigi vevesiake lakagatatunú gili lamaná iaká niave. ");
INSERT INTO gah_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Neza lamaná lo likimitoze, gililo. Gozapá Ómasímini agepagutí gakó liaká ve mukí kezagi itó monó gele ve mukí kezagi nene oko moloko nou netá lekeza ánigiaká nia netáma ánigatune liki lamóza, ánigamamóma neve. Itó lekeza nene negepagutí gakó giliaká nia gakó gilitune liki lamóza, gelemamóma neve. ");
INSERT INTO gah_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Netá gihila atilí oakalímini mogona nene lo likimitoze, gililo. ");
INSERT INTO gah_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ómasímini gasovaló minoakalímini gakó giliki gili vevesama vegenalite monó nene kigikagú milikago minamó nene golesa netá amelaho Satá nene netá gihilama aleko golisi vokiko netá gihila gapoló alemó zimó nenéminiki minanigave. ");
INSERT INTO gah_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Itó gehani amupiló lemeko minamó nenéminiki minata vegená nene monó nigiliki laga kivisekago giliaká niamóza, ");
INSERT INTO gah_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","kigikagú emane nene luhusa ale gilitamigo, gamena alínipa aliniko, monó gakó gilinakumule liki gopogu galatakalatá milikitata gamenaló nene litá iki ahulanigave. ");
INSERT INTO gah_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Itó lilihagú limimó nenéminiki minata vegená nene monó giliakaláa hanuva gilitamóza, imane mikasiuka gena kepeleaká noi netá itó monimú lagaváa giliaká nia netá nenémo monó zemikago, keitoka gihiláa makó utó osá amive. ");
INSERT INTO gah_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Itó mikasi lamanakú limimó nenéminiki minatamoláa monó giliiki gili vevesiki ali minata vegenatoka nene gihila zeaká noive. Makolititoka napa otigí zeaká noive, makolititoka mukí zeaká noive, makolititoka vauva aleko zeaká noive. ");
INSERT INTO gah_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Láa loko loake, anoza gakó makó láa loko lo limimó: Okulumalímini avogisaló iteaká mogonamú nene ve makolímo nene minagú laisi gihiláa atilí imó neneló ale moloko litoze. ");
INSERT INTO gah_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Gihiláa atilí oake vokago nene, makó holugú nene vegená kovó aki asú iki akinago, gala veva nenémo aniteake laisi vogalaló minoake nene, liliha nene atilí oake vimó. ");
INSERT INTO gah_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Lá okago laisi goloko iteakaláa goloko iteake, gihiláa nene nozigo, liliha makó nene ámináminoko goloko itimó. ");
INSERT INTO gah_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Lá okago, izegipala zuha nenete iki láa liki li amemó: Gugulizaki velemaka, geza nene mikagú nene netá lamanaláa makó atilí animóma nemóza, liliha mukí nene nana oko itive. ");
INSERT INTO gah_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Liki likago, eza nene gala ve makolímo onoitive loko lokago, keza voko lilihama asutatupe liki likago nene, ");
INSERT INTO gah_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","eza láa loko nene limó: Óe, liliha nene asuti ahulatamóza, laisigi nene asutikatave. ");
INSERT INTO gah_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Nenemú nene laisigi lilihagi hanuva minatize. Neiko nene, laisi ale moloaká gamenaló nene minumuni aliaká ve láa loko loketatove: Lekeza niviki liliha nene apí iki gizaká iiki asapú ikiko lokú gizatunize. Itó laisima nene haitó gizaká iiki ale moloaká numúnegú milataze, loko limó. ");
INSERT INTO gah_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Izesú nene anoza gakó makó láa loko lo limimó: Okulumalímini avogisaló vi hilata vegená keza nene masteti gihila nenéminiki niave. ");
INSERT INTO gah_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ámina netá nene zuha netá lugáagutí koma koma nemóza, ve makó nenémo ámina netá nene minagú atilí okago goloko iteko napa oake zamú mukí kivilegeko zagitana loló onoive. Lá okago, nama nenete anitiake nenémini izanaló nene numuni giaká niave. ");
INSERT INTO gah_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Anoza gakó makó láa loko lo limimó: Okulumalímini lapanató vo holoakaláa nene peleti lulu vizeaká netá nenéminoko neve. Vená makolímo ámina netá nene polisigi ali gopa okago hutilí okago peleti nene lulu vize napa oaká noive. ");
INSERT INTO gah_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Vegená vaí iki alegesá ikago, Izesú eza gakó mukí imane lo kimimó nene anoza gakokutí nene lo kimimó. Gakó lo kiminogo noike anoza gakokutikó lo kemeaká imó. ");
INSERT INTO gah_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Lá noigo, Ómasímini agepagutí gakó loaká ve makó nenémo gakó láa loko luhuva gizamó nene alévolé imó: Negepagutí anoza gakokutí lo nokiminake mikasi emane utó amigo gakó halá geko minoloko voko minamó nene itína nene lo utó itove. ");
INSERT INTO gah_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Izesú nene vegená ahulokimiake numukú itekago, izegipala zuha leza laisi mikú liliha utó itímini mogona lokako gilitune loko loká omikuko, ");
INSERT INTO gah_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Izesú láa loko limó: Gihila lamaná atilí i vemú lumó nene okulumakutí lumu ve gihila nezánemú luve. ");
INSERT INTO gah_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Minimú lumó nene mukí mikasiukamú luve. Itó netá gihila lamanakumú lumó nene Ómasímini lapaná alina vegenakumú luve. Lilihamú lumó nene netá golesa amelaho Satani vegenala zuhamú luve. ");
INSERT INTO gah_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Gala ve aniteake netá golesa atilí i vemú lumó nene Satakumú luve. Laisi ale moloaká gamenaló minumuni aliaká vemú lumó nene, mikasiuka netá asú iti gamenaló nene hozaló ve keza hoza alitakumú luve. ");
INSERT INTO gah_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Liliha nene asutiiki lokú gizamó nene ámináminoko mikasiuka netá asú iti gamenaló nene ");
INSERT INTO gah_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","okulumakutí lumu ve gihila neza nene agelóne kimiselekugo, není gizapaló vegenáne zuha niakutí kilími gohá iaká nia vegená itó golesa netá aliaká nia vegená gizaká iki kilími nupa iiki ");
INSERT INTO gah_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ló napagú ali ahulikimikiko liminigave. Neneloka limiki miniki ive nama iki miluma maluma giliki kegepa atalá iki minanigave. ");
INSERT INTO gah_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Itó hee liki minamoláa keza nene améipini avogisaló nene ho nenémini iki lapanáinigi minanigave. Lá onoize, lekeza lakagatagi minatamó neneta gakó imane gili vevesiki gililo. ");
INSERT INTO gah_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Okulumalímini lapanató iteakalímini meinava lá oko neve. Helisa netá makó nene za zuhagú minatimó nene etó oko apazá neiko nene, ve makó nenémo voko ánigokoko nene goha ale halá gekoko agoliza vizeko voko ezáa moni henokanona nene salimi asú okoko moni aleoko ámina za zuhama meina hizeko alinogo ive. ");
INSERT INTO gah_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Okulumakú iteakalímini meinaváa lá oko neve. Ve makó nenémo lulú makó meinava iteko mina netakumú nene vitagá oloko vike nene ");
INSERT INTO gah_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","hozavagú molokiko neiko, lulú makó meinava iteko noitimó nene ale utó okoko nene ezáa moni henokanona salimi asú okoko moni aleoko ámina netá nene meina hizeko alinogo ive. ");
INSERT INTO gah_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Okulumalímini lapanató iteaká gapováa nene lagaha gotaha nenémini oko nene neve. Vegená keza lagaha gotaha nene age nagamikú ahulikago lemeake lagaha nene haitopaitolímini nene aleaká noive. ");
INSERT INTO gah_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Gotaha nene vaí okago, gelelehá iki ali getatoka iake minake nene, noakalímini nene lapegú ali milimili iaká niave. Namoakalímini nene ali etó iki ahuliaká niave. ");
INSERT INTO gah_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Mikasi gamenava asú iti zupa nene ageló nenete áminámini inigave. Ageló nenete numutó namató vetini holúikutí vegená golesa gizaká iiki ");
INSERT INTO gah_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","lokú nene ali ahulikitanigave. Neneloka miniki ive nama iki miluma maluma giliki kegepa atalá iki minanigave. ");
INSERT INTO gah_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Izesú láa loko lo leme asú oake nene, láa loko loká oletamó: Lekeza nene mukitoka gakó imane gili asú inahe. Loko lokago, leza mota gele asú onoune ");
INSERT INTO gah_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","loko lokuko, eza láa loko limó: Ve makolímo aí henoni litahagutí itó gosohakutí gona moloko aí vegenala zuha kemeaká noimómáminiki monó mogona apí ikimiaká a ve lugáa keza okulumalímini lapanalímini mututoni lilí nia vegená nenete Ómasímini litaha monolímini agikagutí itó gosohá monolímini agikagutí ali utó itamó neve. ");
INSERT INTO gah_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Izesú nene anoza gakó haitopaitolímini láa loko lo leme asú oake nene, ámina numuni apá ahuloake ");
INSERT INTO gah_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ezáa gotó apalaloka vo anitimó. Vo aniteake monó numukú iteake monó lo kimimó. Monó gakó nene avetó oko lo kemekago, giliake sigaga sagaga litake láa liki lamó: Ve imanémo gele vevesoakaláa nene hikutí alive. Itó alévolé suni aleaká noimómave. ");
INSERT INTO gah_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Leza aí mogonáa gelenounize. Áisi nene kapetamámini gipalama noive. Itó izolahini agulizá nene Maliáma neve. Itó agunamotamolatini kugulizáini nene Zemusiki Zoseheki itó Saimon itó Zutá nene agunamotamola niave. ");
INSERT INTO gah_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Itó mohó agunala kezagi imaneló miniki aliki iaká nianazo, áisi lezagitana ve noimóza, áisi nene haitopaitó suni nana oko aleaká noive. ");
INSERT INTO gah_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Liki liake aikumú gelemó nene gena okago, aí nene ali letivi iki likago, Izesú láa loko lo kimimó: Ómasímini agepagutí gakó liaká vetini kugulizá nene numutó namató puu loko vitimóza, kezáini gotó apatokagi numúikukagi kezáini kugulizá nomitive, loko limó. ");
INSERT INTO gah_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ámina apató vegená keza nene gili alévolé amamó nenazo, Izesú nene alévolé suni mukí neneló ale utó amimó. ");
INSERT INTO gah_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Gamena nene zupa agulizaki ve napa Heloté nene Izesuni gakoláa likago gilimó. ");
INSERT INTO gah_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Geleake nene, gelekelé izegipala nene láa loko lo kimimó: Zoní monó nagamí holokimiaká ve áisi nene hilimómagutí oteake imane zámuza nene netá haitolímini ale utó oake noihe loko limó. ");
INSERT INTO gah_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Nene hanuva lamimó. Heloté nene amunaloka emane uvolaho Piliponi vená agulizá nene Helotiasini ipá oko alimó. ");
INSERT INTO gah_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Lá okago, Zoní nene Heloteni nene uvokahini vená ipá oko alenimó nene etamive. Loko lo ame-ame oloko vokago, Heloté nene venalámo gala vizekago ve makó kimiselekago vake Zonini agizató aliake nagá numukú ahulitamó. ");
INSERT INTO gah_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Mukí vegenalite Zonikumú nene Ómasímini agepagutí gakó loaká ve noive liki liaká amó nenazo, Heloté nene Zonini apilitomó nene Ómasímo nana onetatihe loko ahelele vizekago ahulamó. ");
INSERT INTO gah_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Lá imóza, Heloteni nene geta gamena alitokago mukí kugulizaki ve aí numukú nene iki alegesá amó. Alegesá iki niago, Helotiasini mohola nenémo kovogisaló melekeni noigo, Heloté nene ánigo amu heleake, ");
INSERT INTO gah_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","láa loko limó: Neza nene Ómasímini avogisaló lo hukoko noluve. Geza nemú manamú nivisive loko litani netá hanuva giminogo uve. ");
INSERT INTO gah_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Loko lokago nene, izolaho lo amekago láa loko limó: Monó nagamí holokimiaká ve Zonini luvana nene hutoko lapegú moloko nemekako ánigokinake mota helekave loko litove loko noluve. ");
INSERT INTO gah_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Loko lokago nene, agulizaki vémo agepa gahava nomigo gilimó gena imóza, Ómasímini avogisaló lo hukokumóma nenazo itó alesa molokugo iki mina vegenalitini kovogisaló imane lo hukokunazo loake, gele ameake, gopa nene pilisi ve makó voko luvana hutoko alekative loko lomikago, ");
INSERT INTO gah_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","vike nagá numukú nene luvana hutoake gotola gitegeko nene ");
INSERT INTO gah_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","lapegú moloake mohóma amekago, moholámo aleko vike izolahini alemo amimó. ");
INSERT INTO gah_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Alemo amekago nene, Zonini izegipala zuha nenete ámina gakoláa nene giliake vake gonosiváa gale zemó. Gale ziake, ámina gakó nene Izesuni avetó iki li amemó. ");
INSERT INTO gah_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Li amikago, geleake ámina apá ahuloake izegipala zuhagegi nagamikú lapegú itekunike vola helegaloka mikasi gomopalaló vo anitehá. Lá okuko, vegená mukí keza giliake, numuni apáini ahuliake mikasigú ámegetiki vamó. ");
INSERT INTO gah_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Lá ikago, Izesú nene lapegutí olío lemeko ánigamó nene, vaí iki alegesá ikago ánigoake, agika hizekago kivisi vegená nene kelémo zokamó. ");
INSERT INTO gah_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Lá okago, únaká ho lemekago, izegipala zuha leza aitoka unike láa loko lo amunimó: Imane apá nene ha gámetó minokaze, itó gamena mota asú okaze, vegenáma apá makotoka makotoka viiki nosánetáini meina hizitave loko kimiselemane. ");
INSERT INTO gah_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Loko lo amekuko, Izesú láa loko lo limimó: Nanamú vitave. Lekezatini nene nosánetá kimiki nalo. ");
INSERT INTO gah_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Loko lokago, leza íi, peleti 5-a itó lagaha lositakó imane molonouhá lae. ");
INSERT INTO gah_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Loko lokuko, Izesú láa loko limó: Nene aliki nenitoka alo. ");
INSERT INTO gah_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Loko lo lemeake, vegená keza gihisiló minatave loko lolimiake, peleti 5-agi itó lagaha lositaki aleake, okulumatoka okenava oko nánigake, Ómasi agepoka loake, peleti gitegeko lemekago, leza vegená mukí gona moloko kemehá. ");
INSERT INTO gah_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Kemekuko, mukilite nikake kagatupa okago nosánetá lumáa ali nupa iki gosúveha 12 vaí okago ali milamó. ");
INSERT INTO gah_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Nosánetá na véa 5000 nenéminiki minamó. Vená izegipáini nene gatamune. ");
INSERT INTO gah_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Lá okago, Izesú ezáa nene vegená nokimisilike izegipala zuhama sipigú itiiki vola helegaloka goí iki vitave loko loletamó. Lolimikago novuko nene, ");
INSERT INTO gah_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","vegená kimisele asú oake ezáagó agoka makokú iteko minake Ómasiloka loko minamó. Lá noigo, ");
INSERT INTO gah_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","límugusi zekago akovevé loló okago nene, izegipala zuha leza sipigú voko voko nonohuló holutó novuko logómulalokatí nene una napa aleko ake lehelú inogo igo, nagamí nenémo valahuká zeko lelémo ligitagani imó. ");
INSERT INTO gah_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Lá noigo, gokululuva notovoigo, Izesú nene nonohuló amupiló liso liso vike vo alí noligo, ");
INSERT INTO gah_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","izegipala zuha leza ánigokunike, holosi noahe oko lehelele vizekago, gopaga lunimó. ");
INSERT INTO gah_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Gopaga lokuko, Izesú litá oko láa loko limó: Lekelegesá legemino. Nezama nouve. Mulutini lepa hizino. ");
INSERT INTO gah_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Loko lokago, Pitá nene láa loko limó: Guivahanitemaka, géisi noitanimó nene lokako nagamí amupiló imane lisokinake géisi noanitoka vitohe. ");
INSERT INTO gah_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Loko lokago amane loko lokago, Pitá nene sipigutí olío lemeake, Izesú noitó nene apí oko nagamí amupiló liso liso vimó. ");
INSERT INTO gah_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Liso liso novigo, una nalikumú geleake alegesá legekago, nagamikú velehé liminogo noike, Guivahanínemaka nelémo nugutó vizemane loko gopaga lokago, ");
INSERT INTO gah_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Izesú litá oko agizani lutoko nanukike láa loko lo amimó: Geza komáisí nenikumú gele alévolé anitika, nanamú gagata losi gelenimó neve. ");
INSERT INTO gah_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Loko loake, sipigú goha itikasigo, una nene asú imó. ");
INSERT INTO gah_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Asú okago, sipigú makó minuhá ve leza Izesuni gupá ze ameko geza lamaná Ómasímini gipala noane, loko lunimó. ");
INSERT INTO gah_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Loko lunike, vola helegaloka Genesalete apakú vo anitunimó. ");
INSERT INTO gah_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Nagamí nonohuló agataloka getatoka nene itekuko, vegená keza Izesuni ánigi vevesiake Izesuteho mota okave liki numuni apá alitoka gakoláa ahulikago, vegená keza giliake kivisi vegená Izesutoka kilímiki amó. Kilímiki ake ");
INSERT INTO gah_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","kivisi vegená imane nene gele kemekako, gugupeló ahe itó hanuva luhoaká gó gahevalokahe imane ali giliiki nene zokatave, liki negénegeka likago, áminámini niake ale gele vegená nene zoki asú amó. ");
INSERT INTO gah_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Gamena nene zupa Zelusalegatí Palisaio monó ve itó monó mogona apí ikimiaká a ve lugáa kezagi Izesutoka ake láa liki loká itamó: ");
INSERT INTO gah_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Izegipaka zuha keza avotegini mogonatagana ali minamake nanamú ahulikave. Nosánetá natune liki ligika ale golotuva loaká suni aliki kigizani nene nagamí zemave. ");
INSERT INTO gah_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Liki likago, Izesú láa loko lo kimimó: Lekelisi nanamú avotikini gakóini gili alinigi Ómasímo lo hukoleketa gakó avutá iaká niave. ");
INSERT INTO gah_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ómasímo láa loko lonoimóma neve: Izokahiko amekahiko kugulizá ale otezo. Itó makó nene láa loko lonoimóma neve: Makó eza nene izolahiko amelahiko usí vizekimiaká gakó lo kimitimó nene, apele hilitunize. ");
INSERT INTO gah_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Lá onoimóza, lekeza nene láa liki liaká niave: Makó eza nene izolahiko amelahiko hize lé oketanogo lonou netáma mota Ómasímini amekuve, ");
INSERT INTO gah_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","liki liake nene izotikini ametikini nasahilí ikitata gapo hizi lí iaká niave. Itó lekeza lá iake, Ómasímini gakó nene vasá ziake lekezatini avotikini gakó alévolé iki ali miniaká niave. ");
INSERT INTO gah_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Genezatini lositaki neneta Isaiá alika utó iti netakumú gakó láa loko limó nene, lamaná lekelikumú lonoimóma neve. Ómasímo li gakó nene láa loko luhuva gizonoimóma neve: ");
INSERT INTO gah_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Vegená mulusi imane nene kegepatunukó nugulizá ali otiaká niamóza, kigika nenitoka mili gímizinamake mili hotó inave. ");
INSERT INTO gah_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Vegenalitini gakó nene není gakokitana okago li kimi-kimi iki miniaká niake, soza miliki gupá zi nimiaká niave. ");
INSERT INTO gah_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Izesú nene láa loko lo kemeake vegená lugáa mukí sele lo kemekago, aitoka ikago, láa loko lo kimimó: Neza gakó lo likimitoze. Gili vevesiki gililo. ");
INSERT INTO gah_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ni mikilí ikago lakagatupagú lemeaká noi netá nenémo likigika ale golotuva lamitimó neve. Lekegepagutí emane ititi netalímo likigika ale golotuva litimó neve. ");
INSERT INTO gah_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Loko lo kemekago, izegipala zuha leza amatoka voko láa loko lunimó: Geza nene Palisaio monó ve imane gakó lo kemekako gili golesa ikave. Gili golesa amó nene mota gelenape. ");
INSERT INTO gah_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Loko lokuko, Izesú eza anoza gakó láa loko lo limimó: Za nene okulumakú améneho zuhá amigo hanuva goloko itimoláa nene áisi asutoko luhusagi ale ahulanogo ive. ");
INSERT INTO gah_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Lá onoinazo, lekeza ahulikimikiko minino. Palisaio monó ve nene kogómula lika mola vegitana niave. Agómula lika ve makolímo agómula lika ve makó nene gapo alapizitihe. Kogómula lika ve losi nenetosa eza agizató aliko eza agizató aliko iiki vitáimó nene losiló galegú hilanigasive. ");
INSERT INTO gah_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Loko lokago, Pitá láa loko lo amimó: Geza nene anoza gakó itínasa lanimómámini mogonáa lo utó okako gilitune. ");
INSERT INTO gah_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Loko lokago, Izesú láa loko limó: Íi, lekelisi nene áminagó iki lakagata velesá kolosamimó niahe. ");
INSERT INTO gah_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Mogonáa gili vevesamahe. Lekegepatunú nosánetá nikago aselikú nene lemeake nene eza gapováa voaká noive. ");
INSERT INTO gah_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Itó lekegepagutí iteaká noimó nenémo likigikagutí utó oake lekemeni ale golotuva loaká noive. ");
INSERT INTO gah_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Vegená likigikagutí iteaká noi netá nene lá oko neve: Golesa lakagata geleaká, itó vegená kepele heleaká, ve vená huki ezega emega oaká, mokoló mogona, gumina, soza, kemegeka loaká, nene. ");
INSERT INTO gah_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Netá nenémináámo lekemeni alémo golesa oaká noive. Ligizani nagamí zemunike noaká nouhá nenémo lemeni ale golotuva losá amive. ");
INSERT INTO gah_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Loko loake, Izesuki makó vunike mikasi ahuloko Tulo numutoka itó Sitona numutoka apá agilikaloka voko nouko nene, ");
INSERT INTO gah_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Kenan mikasiukatí hetoka mina vená makó nene aitoka noake gamoga geko láa loko limó: Guivahanínemaka, geza Tevitini agávolagamaka golesa netakutí gologí oletatani velemaka, milumaváne gelenetamane. Holosi golesa makolímo mohónémini agikagú minoake alémo gopa napa okago noinae. ");
INSERT INTO gah_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Loko lokago, Izesú nene geletigí gelemotigí oake novigo nene, izegipala zuha leza vená imanémo negénegeka lomo lémegetoko amó goselé ovize. Geza nene amiselekako vitiho. ");
INSERT INTO gah_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Loko lokuko, Izesú láa loko lo limimó: Neza nene Isilae vegená vi tolova inakutí kelémo vatí itane lokogó nimiselekago lumumóma nenae. ");
INSERT INTO gah_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Loko lokago, vená nenémo litá oko amatoka oko agisauka gupá nozike láa loko limó: Guivahanínemaka, geza nelémo vatí amane. ");
INSERT INTO gah_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Loko lokago, Izesú nene Isilae vegenalite Ómasímini lusa goí iki ali alitakumú geleneike anoza gakó láa loko lo amike limó: Izegipatini nosánetá nene ipá oko galatini kegepagú ahuloakaláa nomive. ");
INSERT INTO gah_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Loko lokago, hetoka vená nenémo Isilae vegenakó negopa, ezagi Ómasímini lusa ale alitikumú geleneike láa loko limó: Guivahanínemaka, nene lamaná lokanimóza, neza litoze. Gala amelage nene nosánetá ninago lanáa koma alemó zimó nene galate gopa niaká niamole. ");
INSERT INTO gah_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Loko lokago, Izesú láa loko limó: Geza nene gigika ma nego lokanize. Nenemú nene lani netá utó ogetanogo ive. Loko lokago nene, ámina gamenalóisí mohola nene zokoko lamaná imó. ");
INSERT INTO gah_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Lá oake Izesú nene numuni apáma ahuloake goha atiginá oko vike Galilaia nonohulotoka aniteake zopega makokú iteko minamó. ");
INSERT INTO gah_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Iteko noigo, vegená mulusi haitopaitolíminiki alegesá amó. Iki alegesá amó nene kigisaló alimó kogómulaló alimó itó lilikupá gepili nuvane itó gakó lamamó negi ve itó kivisi vegená mukí kilímiki iki Izesuni agisauka kilími nupa ikago kelémo zoko asú imó. ");
INSERT INTO gah_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Lá okago, gakó lama vegená nene kegepa alémo vávani okago gakó lamó, itó kigisa kigizani nakeseta vegená nene kelémo lamaná okago lamaná iki minamó, itó kigisaló alimó nene lisi pehe liake otiki vamó. Itó kogómulaló ali vegená nene kogómula ale goloutokimikago kogómula ánigamó. Lá iki minago vegená mukí keza sigaga lake leza Isilae vegenalitini Ómasite napa noive liki agepoka lamó. ");
INSERT INTO gah_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Lá okago, Izesú nene izegipala zuhama sele lo lemekago, aitoka okuko, láa loko lo limimó: Vegená mukí imane nosánetá namake nenitoka nene gamena losive makole minikago milumaváini gelekuze. Itó itína gaúna hiliki niko, kimiselekugo, numúitoka niviko gapoló kovonana vizekatihe loko nenemú nagata gulugo gena nivisekave. ");
INSERT INTO gah_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Loko lokago mikasi gomopalaló nouninazo, vegená imane nosánetá nene hikutí ale utó oko kemeko natune. ");
INSERT INTO gah_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Loko lokuko, Izesú loká oletake lekelitoka peleti nanakí neve. Loko lokago, leza nene peleti 7-a, itó lagaha koma luguhakó ma neve. ");
INSERT INTO gah_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Loko lokuko, áminama aliki alo loake nene aleko okuko, Izesú nene vegená mukí mikasiló minalo loko lolimiake, ");
INSERT INTO gah_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","peletigi lagahagi aleake, Ómasi agepoka loake, gitegeko lemekago, leza vegená gona moloko kemekuko namó. ");
INSERT INTO gah_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Niki niki kagatupa ikago, nosánetá lumáa minamó ali nupa iki gosúveha nene 7-a vaí okago ali milamó. ");
INSERT INTO gah_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Nosánetá na ve nene 4000 nenéminiki minake namó. Vená izegipáini ma gatamune. ");
INSERT INTO gah_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Lá okago Izesú nene ámina vegená kimisele ahulokago, nivago, sipigú makó itunike Magatana mikasiuka vola helegaloka vo anitunimó. ");
INSERT INTO gah_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Palisaio monó vegi itó Satukaio monó vegi keza Izesutoka iake gimivagú molatune liki loká itake láa liki lamó: Geza nene Ómasilokatí alévolé suni makó ale utó okako geí mogona ánigatune. ");
INSERT INTO gah_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Liki likago, eza láa loko lo kimimó: Lekeza nene límugusi zinogo noigo guhizakó ánigiake azo ho latimó neve, liki liaká niave. ");
INSERT INTO gah_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Itó gó lokago gó nohitago nene golini zitimó neve liki liaká niave. Itó lekelisi nene okulumató ánigiake nenémini mogona gona miliki giliaká niamóza, itína gamenaló oko moloko oaká noutímini mogonamú nene ma gili lamaná amake hanuva miniaká niave. ");
INSERT INTO gah_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Imane gamenaló nia vegená lekelisi nene ve golesave itó monó nene gili ahuliaká vegená niave. Lekelisi nene alévolé suni ale utó okugo ániganigi giliake nilahe. Lekelisi nene haitó suni makó ale utó ugo ánigaminigave. Gozapá monó loaká ve Zoná nene gamena losive makole oko vokago heleaká gapogutí oti sunigitana makó nenitoka utó iko nenegó ániganigave, loko lo kemeake ahulokimiake vimó. ");
INSERT INTO gah_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Itó izegipala zuha leza nene peleti makó aleko vitunikumú lagatí molokago ahulunike sipigú makó itunike nonohuló avilegekunike ima helegaloka oko anitehá. ");
INSERT INTO gah_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Oko anitekuko, Izesú nene anoza gakokú láa loko lo limimó: Lekeza nene Palisaio monó vegi itó Satukaio monó vegi keí lulu vizeaká netalímo lekepelekatize, ehe. ");
INSERT INTO gah_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Loko lo lemekago, peletímini lulu vizeaká netakumú lihe loko lezateloka logele hagele unike peleti nene ahulokoko unikumú nene gakó lo nolimize. ");
INSERT INTO gah_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Loko luni gakó nene agataló holokago geleake láa loko lo limimó: Agae, lekeza komáisí gili alévolé amó neneta, peleti ahulokoko unikumú nolive liki nanamú mulutini itekago lekezatitoka ligili hagili niave. ");
INSERT INTO gah_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Neza nene alévolé suni aleko nosánetá hanuva ale utó oleketatomómámini mogonáa velesá gili hee lamahe. Neza ve 5 tausenimú peleti 5-a gitegeko kemekugo, niake kagatupa okago lumáa ahulikago gosúveha 12 nene vaí okago aleve. Nenemú lakagatí molokago nilahe. ");
INSERT INTO gah_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Itó vegená nene 4 tausen keikumú peleti ligizani lugaloka losi olío molago kemekugo, nikake kagatupa okago, lumáa nene gizaká iki ali milamóma nene gosúveháa 7 ali milamó neve. Nenegi lakagatí molokago nilahe. ");
INSERT INTO gah_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Leza nene peletimú lo lemenape liki lekeza nene není mogonamú nanamú gili vevesamave. Palisaio monó vegi Satukaio monó vegi keí lulu vizeaká netalímo lekepelekatize, ehe. ");
INSERT INTO gah_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Loko gakó nene lo lemekago, neneló nene gele vevesunimó. Gele vevesunike nene, peletímini lulu vizeaká netakumukopa, Palisaiote itó Satukaiote soza monó liaká akumú nene lokave loko nene gulunimó. ");
INSERT INTO gah_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Izesú nene Sisalia mikasiuka agulizaki ve Piliponi agulizató apá nene agilikaloka voko noike, izegipala zuha nene láa loko loká oletake limó: Vegená keza nene okulumakutí lumu ve gihila nenikumú nene éahove liaká niave. ");
INSERT INTO gah_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Loko lokago nene, vegená lugáa nenete Zoní monó nagamí holokimiaká vema noane liki liaká niave. Itó lugáa nenete Ilaizá gozapá okulumakú iti vema noane liki nilago, lugáa nenete Ómasímini agepagutí gakó loaká ve Zelemiá ahe itó Ómasímini agepagutí gakó loaká ve makó gozapá minamokitana noane liki liaká niave. ");
INSERT INTO gah_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Loko lo amekuko nene, itó lekelisía nene nenikumú éahove liki liaká niave. ");
INSERT INTO gah_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Loko loká olimikago nene, Saimon Pitá nene láa loko limó: Geza gologí oletatane loko lo mololeta vema alévolé Ómasímini gipala nene noane. ");
INSERT INTO gah_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Loko lokago, Izesú nene láa loko lo amimó: Zonani gipala Saimoga, geí gakó nene gelekugo gogoliza novizenimó geleaká noive. Vegenalite ma li gimikago lamane. Okulumakú améneho nene gelémo vávani igo lokanize. ");
INSERT INTO gah_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nenemú lo gimitoze, gelezo. Geza gugulizaka nene Pitá noane. Itó lelí gakokutí nene gasova gehanímo. Itó nénisi nene ámina gasova gehanimámini amupiló nene monó ali amegesa milina vegená kelémo nupa okoko ahulokimikugo meikú hilatatímini zámuzáa nenémo ma kelémo amunauka aminogo ive. ");
INSERT INTO gah_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Itó nénisi nene okulumalímini lapanató vi hilatatímini kiiláa giminogo uve. Itó geza nene mikasiuka netá makokumú lo hoipa oketatanimó nene Ómasímo okulumakukagi ámina netakumú lo hoipa oketanogo ive. Itó mikasiuka netá makokumú lo hoipa oketamitanimó nene Ómasímo okulumakukagi ámina netakumú lo hoipa oketamitimó neve. ");
INSERT INTO gah_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Loko loake, izegipala zuhama nene lagata alike alévolé oko lo limimó: Neza gologí oleketative loko lo mololeketa vema noumóza, nene gakó nene vegená keké li kememilo, loko limó. ");
INSERT INTO gah_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Gamena nene zupa Izesú nene apí oake minomo vike netá matá aitoka utó iti gakó nene izegipala zuha láa loko lo limimó: Zelusalega itekugo nene, monó gizapa ve itó guguni giziaká ve itó monó mogona apí ikimiaká vete miluma netá mukí nimiiki nipili hilikiko, gamena losive makole minokinake goha otinogo uve. ");
INSERT INTO gah_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Nene gakó lo leme asú okago, Pitá nene Izesuni alémo apazá zeake géneka loko gahá amike láa loko limó: Guivahanínemaka, Ómasímo asega zegeto-loko noviko nenémini suni nene geí gumupiló utó aminogo ive. ");
INSERT INTO gah_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Loko lokago, Izesú viligoko Pitani láa loko lo amimó: Satani gakó lanitika, géisi nene mino olové amane. Není gapo hize lí itani gakó lokane. Gakó nene lokanimóza Ómasímini gakó lamanike ha vegenalitini kigikagutí gakó aleko lokane. ");
INSERT INTO gah_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Loko loake, gamena nene zupa Izesú izegipala zuhama miní ameko láa loko lo limimó: Vegená makó nenete není némegetoko vitune liki nigilikima nene, kugupémo giliti netá gili ahuliiki zohota zaló kipili hilinigi miluma netá ali gihikitatakumú gili zagiiki némegetiki ataze. ");
INSERT INTO gah_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Makó keza nene kigika kemeníini aliki amánapa iki minata vegená nene kigika kemeni gopa inogo ive. Itó makó keza nenikumule liki kigika kemeni vínasatamó nene alévolé kemetameni alinigave. ");
INSERT INTO gah_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Makó keza nene mikasi amupiló ne netá ali asú iiki itó kezáini kigika kemeni gopa okoko tolova itimó nene ámina mikasigú henoni nenémo nana oko kelémo lamaná itive. Itó kigika kemeni nene nana nana iki meina hiziki goha alitamó neve. Nenéminoko nomive. ");
INSERT INTO gah_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Okulumakutí lumu ve gihila neza aménehini lapaná nenémo numupiló itekiko, agelova mukí nene kelémoko lemekinake vegená mukí mikasigú iki miliki iaká niamó nenémini ago helegáa lihima kimitomó neve. ");
INSERT INTO gah_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Neza lamaná lo likimitoze, gililo. Lekelisi ató nene nia vegená lekelikutí nene lugáa makó hili asú inamiki ha niko okulumakutí lumu ve gihila neza liminake agulizaki vetini loló oleketatomómámini zámuza nene lamaná oko utó okiko lekelisi ániganigave, loko limó. ");
INSERT INTO gah_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Izesú hoza gamena 6-a minomo noitike Pitani Zemusini itó Zemusini agunala Zoninigi kelémoko kezáikó agoka hána makokú itemó. ");
INSERT INTO gah_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Neneloka itiake kogómulaló nene Izesú haitó agupe ale luhamó. Okulumakú agupe ale luhoake nego, agoka agepa nenémo ho silikakéna nenéminoko noigo, goláa nenémo gizopa vae vae loko minamó. ");
INSERT INTO gah_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Lá okago, Ómasímini agepagutí gakó emane amunaló liaká asi ve Ilaizako Moseko nene utó i kimikasigo, keza Izesugegi gakó ligili hagili amó. ");
INSERT INTO gah_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ligili hagili ikago, ánigiake, Pitá nene Izesuni láa loko lo amimó: Guivahanitemaka, imaneloka minuhá laga okaze. Nenemú gelekako nene imaneló gaizopa losive makole geleketatunize, makó geile, makó Ilaizanive, makó Mosenive. ");
INSERT INTO gah_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Loko noli agepagi límusi saheheváa nene lemeko ze hitokimikago, límusigutí Ómasímo láa loko limó: Imane nigika amenou gipáne noimó nene ánigo numu helekuze, lekeza nene gakoláa gili alilo. ");
INSERT INTO gah_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Loko lokago, izegipala zuha keza nene mikasigú kogoka hiziki akiake kehelele vizekago, kigisa kigizakutí nene guli guli oko minamó. ");
INSERT INTO gah_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Lá niago Izesú nene voko kugupeloka ale nogilike láa loko limó: Lekelegesá legemiko otemave. ");
INSERT INTO gah_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Loko lokago, otiki ánigamó nene Izesú ezáagó noigo ánigamó. ");
INSERT INTO gah_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ánigiake, Izesugegi agokagutí nilemeke Izesú láa loko lo kimimó: Agokaló lekeza netá matá ánigamó nene vegená litá iki avetó iki li kememilo. Nénisi okulumakutí lumu ve gihila heleneitokutí iteko vokugo li kimitaze. ");
INSERT INTO gah_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Loko lokago keza láa liki loká itake lamó: Gologí oletati vema anitemigo Ilaizá goí oko anititive liki monó mogona apí ikimiaká ve nenete nanamú liaká niave. ");
INSERT INTO gah_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Liki likago nene eza láa loko limó: Ilaizá goí oko aniteko netá matá mukí ale vavá itive liki lamaná linamóza, ");
INSERT INTO gah_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","neza lo likimitoze, gililo. Ilaizakitana noi vema mota anitekamóza, ánigi vevesamake kezáini kagata gele netá golesa lilí itiki minamó. Keza ámináminiki okulumakutí lumu ve gihila není nene miluma netá niminigave. ");
INSERT INTO gah_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Loko Ilaizakitana vemú limó nene monó nagamí holokimiaká ve Zonikumú nolinae liki gelemó. ");
INSERT INTO gah_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Lá iake, agokagutí limiake vegená mukí niatoka ikago nene, ve makolímo ake Izesuni amatoka alapusa hizike láa loko limó: ");
INSERT INTO gah_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Guivahanínemaka, gipánemú nene milumaváne gelemane. Eza negi hizeake sehovala veleake minake, lokú ahe itó nagamikú ahe lemeko pou loko akoaká noive. ");
INSERT INTO gah_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Izegipaka zuhate alími zokatahe loko keitoka alémoko vumóza, lá imi vaha vaha alími zokamave. ");
INSERT INTO gah_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Loko lokago, Izesú láa loko limó: Lekeza ató imane gili alévolé amake mulutikú amanapa iki minamó neneta lekelikumú goselé nepelekave. Lekezagi gamena gamena minoloko voko mininake nene lokogohí gehekogó minatohe. Loko loake nene, izegipama nene nénisi noutoka alímiki alo. ");
INSERT INTO gah_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Loko lokago, alímiki ikago, Izesú nene ámina holosi nene gahá amekago ahulomioko vimó. Vokago, izegipama ámina gamenalóisí lamaná okago nene, ");
INSERT INTO gah_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","izegipala zuha lezategó Izesuki makó minunike loká otoko leza nene holosima nanamú apeleko amiselemuháma neve. ");
INSERT INTO gah_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Loko lokuko, láa loko lo limimó: Lekelisi nene gele alévolé oakatini nene alínipa minokago lá amave. Lamaná lo likimitoze, gililo. Lekelisi gili alévolé niamó nenémo komá netá netimóza, masteti gihila komamámo goloko iteko napa napa oaká noimómáminoko amuzavagi netimó nene, agoka imane mino olové ozo liki litamó nene hanuva mino olové itimó neve. Itó lekelisi nene netá makó lilí amitatíminoko nomive, loko limó. ");
INSERT INTO gah_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Koma minomo noiteko izegipala zuha lelémoko vike Galilaia mikasigú vo aniteake nene Izesú láa loko lo limimó: Okulumakutí lumu ve gihila neza nene mini hána amiki vegenalitini kigizakú nilími milikiko, ");
INSERT INTO gah_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","nipili hilitamóza, gamena losive makole minokinake heleneitokutí goha otinogo uve. Loko lo lemekago, izegipala zuha leza mulute gitihiná imó. ");
INSERT INTO gah_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Minoko nene Kapanao numutoka atiginá oko vokuko, monó zagusavémini takisi aliaká a ve nenete Pitani amatoka vake loká itake láa liki lamó: Monó tisatini nenémo monó zagusavémini takisi moni ahuloaká noihe. ");
INSERT INTO gah_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Liki likago, Pitá nene nana ive. Moloaká noimole. Láa loake, numunagú iteko gakó nene Izesuni velesá lo amenamigo, Izesú loká otake láa loko limó: Saimoga, geza nanave loko nogelene. Imane mikasigú kugulizaki véinite hí vegenatokatí takisi moni aliaká niave. Kezáini vegenáini zuhalokatí aliaká niahe itó gutá a vegenatokatí aliaká niave. ");
INSERT INTO gah_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Loko lokago, Pitá nene gutá a vegenatokatí aliaká niave loko lokago nene, Izesú láa loko lo amimó: Láa lokoma mikasi amelage kugupe meina hizemiki hanuva minataze. ");
INSERT INTO gah_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Itó neza ámina monó numuni napámini amelaho nounazo, ámina takisi moni ahulamoko ha minatomóza, keza nene lelikumú gilikiko golesa okatize. Nenemú geza nonohulokú lemeko lagaha aleaká nagá nene nagamí nonohulokú ahulo molokoko lagaha ganá alitanimoláa nene gelelehá o veletoka okoko agepa ale á oko ánigozo. Lagahamámini agepagú nene moni neko ánigoko alekokoma gezagi nezagi lugupe meina hizitíi moni aleko voko kemezo, loko limó. ");
INSERT INTO gah_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Gakó láa loko lo limi zupahé nene izegipala zuha leza Izesutoka vunike láa loko loká otunimó: Ómasímo agulizaki ve napa ale utó o limikiko nene lelikutí éaho livilegeko agulizaki ve loló itimó neve. ");
INSERT INTO gah_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Loko lokuko, Izesú izegipa koma makó sele loko alémoko ake holutegú hize otemiake ");
INSERT INTO gah_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","láa loko limó: Neza lamaná lo likimitoze, gililo. Lekelisi nene likigika ali viligiiki aliliki limiki izegipa koma imanéminiki minamitamó nene Ómasímini avogisaló nene keké ma vaminigave. ");
INSERT INTO gah_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Makó keza nene izegipa koma imanéminiki kezáinimú gilikiko lemeko minatimó nenete Ómasímini avogisaló viki kugulizaki ve lilí itamó neve. ");
INSERT INTO gah_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ve makó nenete nenikumule liki izegipa koma áimanéminiki nasahilí itatamó nenete není nasahilí inimiaká niamó gelekave. ");
INSERT INTO gah_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Itó nenikumú gili alévolé i mina izegipáne limiki minamoki keikutí hamó nene ve makolímo golesa netá alitive loko gala vizeko litimó nene, agae, Ómasímo loló otati netá nene genavagi golesa neve. Ámina vémini luvanaló gehani napa nagá ziiki age nagamikú ahelú i ahulatatímini avilegeko genavagi netá golesa loló otanogo ive. ");
INSERT INTO gah_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Itó agae, golesa netá alitave loko gala vizeko loaká suni haitopaitolímini nene mikasiuka neve. Ámina netá golesa nene hanuva utó inogo imóza, ve makolímo golesa netá alitave loko gala vizeko lomo mohona itimó nene Ómasímo nana otative. Agae, netá golivagi loló otanogo ive. ");
INSERT INTO gah_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Nenemú nene gigizanímohe itó gigisámohe lihima aleaká gapogú gelémo nomilikoma, hukoko nene ale ahulozo. Gigizani hamokó neiko itó gigisa hámakó neiko alévolé oko minoakalímini apakú ititaninazo. Gigizani losigi itó gigisa losigi minokoko lihima alitanitímo ló apakú gelémo molokiko, ló nene lihamike lova lova oko nomina lokú vokatanize. ");
INSERT INTO gah_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Itó gogómulámo lihima aleaká gapogú gelémo nomilikoma, geza hanuva hize lí okoko ale ahulozo. Gogómula hamó neiko minoko alévolé oko minoaká apakú ititaninazo. Gogómula losigi minokoko lihima alitanitímo milumámini lokú gelémo molokatize. ");
INSERT INTO gah_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","Lekeza ehe tináneve. Lekeza izegipa nugunamotamónemú gilikiko lememino. Neza nenemú lo likimitoze, gililo. Ageloninite okulumakú miniaká niamó keza nene okulumakú gamena gamena aménehini avogisaló minake gizapa ikimiaká niave. ");
INSERT INTO gah_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Nenemú lekeza nene nanave liki nigeleve. Ve makó nenémo sipsip izava nene 100-a niakutí sipsip hamokó tolova itimó nene, vitagá amitihe. Lá oko nomive. Sipsip lugáa 99-a nene agokaú ahuloketonoko hamó legesó imolamú amuza moloko vitagá oloko vinogo ive. ");
INSERT INTO gah_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Lamaná lo nolukumuve. Eza vitagá ova ova oko sipsip iza hamóma ale utó okoko agoliza vizinogo ive. Agoliza vizitimó nene sipsip iza 99 hanuva niamoláamú agoliza vizeminogo ive. ");
INSERT INTO gah_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Itó ámináminoko lekelí ametipo okulumakú noimó nenémo izegipa nugunamotamóne lekelikutí makó nene legesó itikumú ma amu helemive. ");
INSERT INTO gah_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Gigivekaho makolímo geitoka lihima suni alegimikikoma, geza voko lekezatikó miniki lihimala alapizezo. Lá noako, geí gakó gelekikoma nene, goha gigivekahini alémo geitoka itanize. ");
INSERT INTO gah_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Lá onoimóza, geí gakó gelemikoma, ve hamó ahe lositá ahe kelémoko lekeza ámina lihimagi ve noitoka makó vilo. Lá ikiko, monó gotolaú gakó makó láa liki luhuva gizinamó nenémo gihila zitive: Gakó hoza alitató nene vegená losihe losive makolehe ve makolímini mogonamú gakó hoza alitamó nene voko hee hee linogo ive. ");
INSERT INTO gah_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Lá onoimóza, keí gakó gelemikoma nene, geza monó gilina vegená lo kemezo. Itó eza nene monó gele vegenalitini gakó gele ahulokikoma, aikumú gelekako eza nene mota lihimalagi ve ánigi goselé iaká nia ve loló ino. ");
INSERT INTO gah_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Neza lamaná lo likimitoze, gililo. Lekeza mikasiuka netá makokumú li hoipa ikitatamó nene Ómasímo okulumakuka ámina netakumú lo hoipa oketatimó neve. Itó lekeza netá makokumú mikasiuka li hoipa ikitamitamó nene Ómasímo okulumakukagi ámina netakumú lo hoipa oketamitimó neve. ");
INSERT INTO gah_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Makó miní ameko lo likimitoze. Lekelikutí vegená makolitehe itó lositakó ahe keza netá makokumú nene ligika mili nupa iiki hamokó loló okiko Ómasiloka litáimó nene okulumakú améneho gele kiminogo ive. ");
INSERT INTO gah_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Itó vegená makolitehe itó losive makolehe itó lositakó ahe keza apá makotoka není nugulizakumú ali nupa itamó nene nénisi holúikú minanogo uve. ");
INSERT INTO gah_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Loko lokago, Pitá nene Izesuni amatoka mino molake láa loko loká otake limó: Guivahanínemaka, nigivéneho makolímo gamena nanakí zupa lihima netá alenimikiko ahulotatove. Gamena 7 ahe. ");
INSERT INTO gah_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Loko lokago, Izesú láa loko lo amimó: Gamena 7 nomive. Gamena 7 ahuloto-loko vova vova noako gamena 700 loló ino. ");
INSERT INTO gah_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Nenemú nene Ómasímini avogisaló minoakalímini ago helegáa lekelepizeko gakó makó litoze. Agulizaki ve napa makolímo gelekelé izegipalatini lihimáini netimoláamú ale hehe linogo gilimó. ");
INSERT INTO gah_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Lihima milikitinitamó ale hehe linogo apí oko hozaváa naligo, ve makó nene aitoka alímiki amó. Aitoka lihima 10 milioni kina minamó. ");
INSERT INTO gah_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Lá imóza, eza nene ámina lihima apasati moni nene ma nomimó. Lá okago nene, agulizaki ve nenémo láa loko limó: Galanava apasatikumú ezáagi itó vená izegipala izava galava itó henokanonagi nene mota vegenalite meinava hizi asú iki alikiko megusa lilí iki minatave. ");
INSERT INTO gah_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Loko lokago, gelekelé izegipa nenémo voko agulizaki vemámini agisauka alapusa hizeko láa loko limó: Asene zenetoloko voko noako, neza voko mininake moni ale utó okinake apaso asú oko gimitove. ");
INSERT INTO gah_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Loko lokago, eza ámina hozaló vémini agulizaki ve nenémo hozaló vevamú miluma gelemiake ahulotamó. Itó lihimalagi nene hanuva ahulotamó. ");
INSERT INTO gah_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ahulomikago, ámina gelekelé izegipama numukutí olío lemeake vike hozaló ve agivelahini makó nene moni 100 kina amunaloka emane ameneitó nenazo, ánigoake luvana aleko poló noike láa loko lo ameko limó: Geza moni gumumóma nene mukí apasoko aló nememane. ");
INSERT INTO gah_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Loko lokago, agivelaho nene agisauka alapusa hizike negénegeka nolike láa loko lo amike limó: Geza asene zeneto-loko voko noako, moni alika ánigokinake apasoko gimitove. ");
INSERT INTO gah_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Loko limóza, eza gele ahuloake agivelahinima nene goní omikago nagá numukú ahulitamó. Nenegú minoko lihima asú itive loko kalapusi amimó. ");
INSERT INTO gah_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Lá okago, keza agivelage lugáa nenete ámina suni ánigiake mulúikú golesa gelemó. Golesa giliake keza nene viki agulizaki veninima avetó iki li amemó. ");
INSERT INTO gah_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Lá ikago, agulizaki ve nenémo ámina gelekelé izegipa nene sele lo amekago, okago, láa loko lo amimó: Gelekelé izegipa golesa neneka, geza negénegeka lako lako lihimaka mukí nene hanuva ahulogetumóma neve. ");
INSERT INTO gah_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Neza geikumú miluma gelegetumóma nenazo, geza ámináminoko gigivekahikumú miluma geleko lihimava nene ahulotataninazo. ");
INSERT INTO gah_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Loko loake, agulizaki veva nenémo izapaló golesa molokago miluma netá aliti-liki niviko minoko lihimavala mukí apasative loko pilisí vetini kigizakú molamó. ");
INSERT INTO gah_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Loko Izesú loake, miní ameko láa loko limó: Lekeza mukitó nene likigikagú likigivetikini lihima ahulikitamitamó nene, není améneho okulumakú noimó nenémo áminagó oko lekelitoka loló oleketanogo ive. ");
INSERT INTO gah_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Izesú nene gakó lo asú oake, Galilaia mikasi ahuloake Zutaia mikasiloka Zota nagamí vola helegaloka vimó. ");
INSERT INTO gah_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Novigo, vegená mukí ámegetiki vamó. Neneloka kivisi vegená nene kelémo zoka zoka oko minamó. ");
INSERT INTO gah_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Lá noigo, Palisaio monó ve lugáa aitoka ake amekú miliki láa liki lamó: Mosé lo hukoko li gakokú nene ve makolímo netá nemú manamú venala amisele ahulosá neve loko gizonoimóza, nene etahe etamive. ");
INSERT INTO gah_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Liki likago nene, Izesú láa loko lo kimimó: Lekeza nene monokú gakó láa loko nemó nene gatiki gilinamóma lakagatí molokahe: Gozapá Ómasímo ale utó ikú emane nene vegi venaki kelémo utó onoimóma neve. ");
INSERT INTO gah_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Itó kelémo utó oake láa loko limó: Nenemú ve makolímohe makolímohe izolahini amelahini ahulokimioko venalagi nene kugupe kigika hamokó loló okiko apiziki minatáive. ");
INSERT INTO gah_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Loko gakó imane limó nenazo, ve aleve keza lositá hoú liki nene minaminigasive. Hamó kugupe loló onoimó gelekave. Nenemú Ómasi nenémo kelémo apizimó nenazo vegenalita nene kelémo hotopotó oakaláa nomive. ");
INSERT INTO gah_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Loko lo kemekago, Palisaio monó vete láa liki lamó: Mosé nene vená kimisilinigima nene luhuva netá giziki kimiiki kimisililo loko limó nene nanamú live. ");
INSERT INTO gah_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Liki likago, Izesú nene láa loko limó: Mosé nene hanuvamú lamive. Lekelisi ánuvane negi nagi hiziki likigika gopa ovikumule loko vená kimisilitave loko gele likimimóma neve. Lá onoimóza, netá matá apí oko kelémo utó i gamenaló emane nene nenéminoko nomimóma nenae. ");
INSERT INTO gah_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nenemú nénisi nene láa loko lo nolukumuze, gililo. Ve makolímohe makolímohe nene venala mokoló netató negopa ha netakumú amisele ahulokoko haitó vená alitimó nene, lihima napa alinogo ive. ");
INSERT INTO gah_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Loko lokago, izegipala zuha leza Íi, vegi venaki nene mogona lá oko minokanazo, vená ma aleminake hanuva gohuna minatuninazo. ");
INSERT INTO gah_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Loko lokuko, Izesú láa loko lo limimó: Ve vená mukilite gakó imane aleminigave. Ómasímo zámuza kemeneimoláa kéisigó nene alitamó neve. ");
INSERT INTO gah_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ve lugáa nene izóikini kagatupagutí vená alemoakalímini utó inamó neve. Itó vegená lugáa nene gohana netá kimiká itó sihana gakó li kimiká iaká ikago hanuva miniaká niave. Itó ve lugáate Ómasímini luhuva hutilí oko vitikumú giliake vená aleakakumú nene kezáini óe liaká niave. Makó keza nenemú nene zámuza alinitatite gakó imane gili alitamó neve, loko limó. ");
INSERT INTO gah_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ámina gamenaló nene izegipa koma koma Izesutoka kilímiki vamó. Eza agizani lutoko gotóitó molonoko nónohá zeketative liki kilímiki nivago, izegipala zuha leza gahá kemehá. ");
INSERT INTO gah_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Gahá noluko, Izesú nene láa loko lo limimó: Lekeza izegipa koma nene ahulikimikalo. Nenitoka ataze. Ánémináate Ómasímini avogisaló viakalímini mututoni nianazo, lekeza li hoipa ikitamilo. ");
INSERT INTO gah_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Loko loake nene, agizanitunú ale nogilike nónohá zeketamó. Lá oake ámina apá ahuloake vimó. ");
INSERT INTO gah_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ve makó Izesú noitoka ake láa loko loká otake limó: Tisánemaka, neza nana netá lamaná alekinake alévolé nemetameni alitomó neve. ");
INSERT INTO gah_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Loko lokago, Izesú láa loko lo amimó: Geza netá lamanakumú nanamú loká nonetane. Lamanalímini amelaho Ómasi hámakó noinazo, mogonáne gele hee noloko netá lamanakumú loká nonetape. Itó alévolé gemetameni alitove lokoma gapo lota gakó gele alekoko mukí ámegetozo. ");
INSERT INTO gah_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Loko lokago, ámina vémo gapo lota gakokutí hí gakokumú nolane loko lokago, Izesú láa loko limó: Gapo lota gakó lá oko neve: Vegená kepele helemo. Ve aleve suni ale gopa oko huko ezega emega amo. Gumina amo. Soza hakupá gakó lamo. ");
INSERT INTO gah_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Geza nene izokahiko amekahiko kugulizá ale otezo. Gezakamú geleaká noanimómáminoko gigivekaginimú geleko gigika kemezo. ");
INSERT INTO gah_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Loko lokago, gosohá vemámo láa loko lo amimó: Ámina lo huka gakó mukí nene ámegetoaká noumóma nenae. Makó hí netakumú ligitagani okuke alemuve. ");
INSERT INTO gah_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Loko lokago, Izesú láa loko lo amimó: Geza gigika avasavagi minative loko geleokoma, voko henonika mukí meinavaló moloko moni aleoko gohogó vegená kemekoko oko némegetozo. Lá okako, okulumakú alévolé helisa henoni nene geitoka utó inogo ive. Loko lokago, ");
INSERT INTO gah_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","gosohá ve nenémo ámina gakó geleake henona vaí oko minamó nenazo, gona moloko kimitohe loko agata gilitímo mulunagú gena avisekago vimó. ");
INSERT INTO gah_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Novigo, Izesú nene izegipala zuha lo limike láa loko limó: Neza lamaná lo likimitoze, gililo. Henóiki ve nenete okulumá lapanató silipa iki ititamó neve. ");
INSERT INTO gah_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Goha makó lo likimitoze. Kamele iza nenémo nakasi vovónagú voakaláa nene vávani oko nomimóza, henonavagi vémo Ómasímini lapanató voakaláa nene genavagi golesa neve. ");
INSERT INTO gah_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Loko lokago, leza gelekunike ininá goha unimó. Ininá unike loká otunike láa lokoma éaho agutó vizekiko minoloko voko minative. ");
INSERT INTO gah_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Loko lokuko, Izesú gonú lepele hee lonoike láa loko lo limimó: Vegenalite nenémini itamoláa nomimóza, Ómasi nenémo loló itove loko i netá mukí hanuva loló inogo ive. ");
INSERT INTO gah_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Loko lokago, Pitá láa loko lo amimó: Gelenape. Leza mukí netá matate ahulokunike geí gémegetokune. Lá onoimó nenazo, leza alika netá makó alesá nehe. ");
INSERT INTO gah_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Loko lokago, Izesú láa loko lo limimó: Neza lamaná lo likimitoze. Alika netá matá mukí gosohá utó iti gamenaló nene okulumakutí lumu ve gihila neza lapanánegi noinake gizapa okimiaká siató nougo, némegetiaká nia ve 12-a lekeza ámináminiki lapanatiki miniki gonanalivagi siá 12-a neneló miniki Isilae vegenalitini mulusi 12-a gizapa ikitiki gona milikitanigave. ");
INSERT INTO gah_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ve vená mukí není nugulizakumule liki numúinihe itó gouna zuhahe izóikinihe améikinihe itó izegipáinihe míinihe ahulatamó nene ahulatatímini meinava aliliki itiki alitaze. Itó minova minova oaká kemetameni alinigave. ");
INSERT INTO gah_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Itína goí ina vegenakutí mukilite alika milanigave. Itó alika milina vegenakutí mukilite alika goí inigave, loko limó. ");
INSERT INTO gah_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ómasímini luhuva hutilí oko vitikumú hoza aleakalímini meinaváa nene hamó lelegitó minatitímini mogona lá oko neve. Ve makolímini mikasi napa minamó nenémo neteká holugú otekoko vain minagú hoza alitave loko hozaló vemú vitagá oko vimó. ");
INSERT INTO gah_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Vike hozaló vete aliaká amómáminiki gamena hamotó nene 1 kina alitave loko lokago gili amikago vain minagú kimiselekago hoza alitamó. ");
INSERT INTO gah_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Hoza nalego, neteká ho itekago 9 kilokumaló nene vike ánigamó nene maketiloka ve makó hanuva niago ánigamó. ");
INSERT INTO gah_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ánigoake lekezagi nene vain mikú hoza alitamó nene moni nene hoza alita avotigila oko likiminogo uve. ");
INSERT INTO gah_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Loko lokago, keza nene viki hoza alemó. Holisakaki itó únakaki 3 kilokumagi voko ánigamó nene ámináminigó imó. ");
INSERT INTO gah_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Únaká 5 kilokuló nene maketiloka voko ánigamó nene ve makó lugáa nene hanuva otinago ánigamó. Ánigoake lekeza neteká únaká imane gamenaló nana okago hanuva otinave. ");
INSERT INTO gah_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Loko lokago, ve makolímo hoza lememive, liki likago, eza láa loko lo kimimó: Lekezagi není vain mikú viki hoza alilo. ");
INSERT INTO gah_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Loko loake únaká molokago, vain mini amelaho nene hozaló gizapa veva láa loko lo amike limó: Hozaló ve sele lo kemekako, ikiko, meinaváa kemezo. Alika hozaló a ve nene moni kemeloko novoko goí iki iki hoza alemoláa nene keme lutegezo. ");
INSERT INTO gah_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Loko lokago, gele amekago, únaká 5 kilokuló hoza ale vema nene 1 kina alikago, ");
INSERT INTO gah_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","keza goí iki hoza ale ve nene meinava napa alitupe liki gelemóza, ma nomimó. Kezagi nene 1 kinasí alimi vamó. ");
INSERT INTO gah_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Naleke vain mini amelahini nene gahá amiki ");
INSERT INTO gah_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","láa liki lamó: Keza alika a ve nene hoza gamena koma aletó meinava kezagi hamolíminokogó lemekane. Lá onoimóza, leza nene genavagi hoza ho napa lató itó hómo lugupeló lake govisi lipiligo miluma geleko alekunimómave. ");
INSERT INTO gah_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Liki likago, mini amelaho nene keí holúikutí ve makó láa loko lo amimó: Nigivénega, neza gelémo golesa amuve. Leza ligika molo hamó okusike 1 kina alitane loko lokusimóma neve. ");
INSERT INTO gah_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Geza meinavaka alekoko vozo. Meina gumumó nene hamolíminokogó alika a ve nene kimitove loko gelenouve. ");
INSERT INTO gah_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Nana onoive. Neza ámina monínetunú netá makó loló itove loko gelenoumóza, nene ma akohenamihe. Neza netá lamaná alegetumóza, geza nenemú gelekako golesa onoihe, loko mini amelaho limó. ");
INSERT INTO gah_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Loko Izesú loake miní ameko láa loko limó: Ámináminiki itínasa alika milina vegená nene alika goí inigave. Itó itínasa goí ina vegenakutí mukilite alika milanigave, loko limó. ");
INSERT INTO gah_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Izesugegi nene Zelusale numutoka tivinigi niake gapoló nivake izegipala zuha 12-a nene lelémo apazá zeake láa loko lo limike limó: ");
INSERT INTO gah_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Gililo. Itína nene Zelusalega notune. Neneló okulumakutí lumu ve gihila není nene guguni giziaká ve napagi itó monó mogona apí ikimiaká a vegi keí kigizakú milikiko, neneló goní initiki nipili hilita gakó li hukanigave. ");
INSERT INTO gah_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Lá iiki, hetoka vetini kigizakú nilími milikiko, gopoguka linitiki segi nogosanitunú nipiliiki zohota zaló nipili hilinigave. Lá ikiko, gamena losive makole minokinake goha otinogo uve, loko limó. ");
INSERT INTO gah_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Gamena nene zupa Zepetaioni venala nenémo gipala lositá nene Izesutoka kelémoko vike gupá ze amike netá makokumú gele nimitane loko nouve, loko limó. ");
INSERT INTO gah_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Loko lokago, Izesú nene nanetakumú givisekago nolane. Loko lokago, eza láa loko limó: Gele nemekako, gugulizaki ve napa loló okako geí gizapaló nene gipáne losi imane nene gonanalivagi siató gigilika luga luga minatáive loko noluve. ");
INSERT INTO gah_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Loko lokago Izesú nene ámina ve lositá láa loko lo kimimó: Lekeza loká initasi netalímini mogona gili gopa ikasike nilasive. Nénisi nene ekesá netá natomó nene lekelisi nene áminagutí hanuva natáimó nehe. Loko lokago, keza nana ive. Hanuva natíimóma nenae. ");
INSERT INTO gah_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Liki likasigo Izesú láa loko lo kimimó: Ekesá netá natomó nene lamaná lekezagi natáimóza, není nigilika luga luga minoakaláa není netá nego likimitohe. Améneho ale vavá oketa vegenalitini siakumú nilasive. ");
INSERT INTO gah_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Loko lokago, izegipala zuha lugáa 10-a leza ámina gakó gelekunike ligiveteginimú mukahá kepelekuko, ");
INSERT INTO gah_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Izesú nene sele lo limike láa loko limó: Mikasigú kugulizaki ve keza mukí nene gelekelé izegipáini nene kagahaisiuka limitigí iki niago gizapa ikimiaká niave. Itó guivahani keza nene vegená ámemenáa kiviligiki miniaká niave. Nene lekeza mota gilinamóza, ");
INSERT INTO gah_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","lekelitoka nene lá oko minamitize. Lekelitokatí makó nenémo nugulizaki ve minatove loko nolokoma hanuva lemetigí oko gelekelé oleketoko minative. ");
INSERT INTO gah_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Itó vegená mukí kivilegeko minatove loko nolokoma lemeko lekelí megusa izegipa loló oleketanogo ive. ");
INSERT INTO gah_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Okulumakutí lumu ve gihila nénisi nene lekeza gelekelé initatave loko lememuve. Vegená mukitoka gelekelé oketoko meina hizeko gologí oketatove loko minoko aleko nugupe ahulanogo lumumóma neve, loko limó. ");
INSERT INTO gah_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Izesuki makó vunike Zeliko apá ahulunimó. Ahulokunike novuko, vegená mukí nenete sii sii liki lémegetiki vamó. ");
INSERT INTO gah_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Lá niago nene, ve lositá kogómulaló alimó nenetosa gapoló minasike, Izesú noave liki nilago gilikasike, Izesuni gamoga giki sele lasike láa liki lasimó: Guivahani geza agulizaki ve Tevitini agávolagamaka gologí oletatane loko lo mololeta vetemaka, lelikumú milumate geleletamane. ");
INSERT INTO gah_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Liki nilasigo, vegená mukí nenete legesó iki minatáive liki gahá kememó. Lá amóza, keza gili ahulikasike pigi viziki sele lasike láa liki lasimó: Guivahani geza Tevitini agávolagamaka, lelikumú milumate geleletamane. ");
INSERT INTO gah_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Liki nilasigo, Izesú nene vike gapoló noike sele lo kemekago, ikasigo láa loko limó: Lekeza nana netá aleleketatokumú nilasive. ");
INSERT INTO gah_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Loko lokago, logómula imane ale panava zeletatane loko nolusive. ");
INSERT INTO gah_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Liki likasigo, Izesú nene milumaváini gelekimiake kogómulaló ale nogiligo, ámina gamenaló kogómula goloutokago ánigikasike Izesuni ámegetiki vasimó. ");
INSERT INTO gah_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Lá okago, keza vake Zelusale apá ali alitiake Petepage numutoka Olivi agoka agisauka nene vi anitemó. Neneloka vi anitiake, Izesú nene izegipala zuhagutí ve lositá nokimisilike ");
INSERT INTO gah_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","láa loko limó: Lekeza viki helegaloka apá komaló vi anitiiki nene, toki iza izolahiko gipalago nene nagá zikitinamó nene ánigiiki vínasiki imaneló kilímiki alizo. ");
INSERT INTO gah_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Itó vínasiki aliki nisiko nene, ve makolímo loká noleketikoma Guivahanitémo hoza nego imane izamú lokago nousive liki lilizo. Láa likisiko litá oko gele lekemekiko vínasiki aliki anigasive. ");
INSERT INTO gah_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Loko lokago, vasimó nene hanuva lá amasimó. Ómasímini agepagutí gakó loaká ve makolímo anoza gakó luhuva gizamó nene haha okative loko lá asimó. ");
INSERT INTO gah_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Nene láa loko luhuva gizamóma neve: Zaion agokaló vegená láa liki li kimilo: Gilinahe. Agulizaki velini nenémo lekelitoka novive. Eza lemetigí oko noike nene toki izámini amupiló iteake noave. Toki izámini akaleva nenémo agohí gigo húane novive. ");
INSERT INTO gah_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Itó izegipala zuhamate keza vasike Izesú li gakó nene gili alikasike, ");
INSERT INTO gah_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","toki iza izolahiko gipalago nene kilímiki asimó. Kilímiki ikasike nene, luhoaká góini nene gololohá ikasike toki iza amegesamaló milikasigo, Izesú neneló iteko minamó. ");
INSERT INTO gah_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Noigo, mukí vegená nenete góini nene gololohá iake gapogú nene avilisá itamó. Itó lugáa nenete kokonasi agila letiake gapogú nene avilisá itiliki vamó. ");
INSERT INTO gah_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Lá niago, vegená mukí goí iká alika miliká amó nenete gakó napagutí láa liki lamó: Agae, Tevitini agávolagamaka, gegepoka litune. Guivahanitémini gakotó anitelimikane. Ómasímo lusa gegetative. Agae, veletoka okulumakú Ómasi agepoka litune. ");
INSERT INTO gah_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Liki likago, Zelusalega ite anitekago, apá amelage keza nene mulúini itimó. Mulúini iteko séna gekago nene, éaho noago nilave liki likago, ");
INSERT INTO gah_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ómasímini agepagutí gakó loaká ve Izesúma Galilaia mikasigutí Nasalete numutotí ve nene noave, liki lamó. ");
INSERT INTO gah_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Izesú nene vike monó zagusave napagú nene iteko ánigoake, áminagú moni meina kona ali volaló imaló a vegenáma kimisele ahuloake, haitó mikasigutí moniló ámina mikasigú moni kimiaká a vetini holoma aleko gululupa soake, itó Ómasímini guguni gizi aminigi nama luhusi miliaká a vegenalitini holoma aleko gululupa soake, ");
INSERT INTO gah_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","láa loko lo kimimó: Ómasímo li gakó makó nene monó gotolaú láa liki luhuva gizinamóma neve: Není numunimú nene Ómasiloka loaká numunive liki litave liki luhuva gizinamóma neve. Láa onoimóza, lekeza nene alími maketi numuni lilí inamó nene guminaló vete halá giki miniaká geha mulí lilí ikamó geleaká noive, loko limó. ");
INSERT INTO gah_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Lá oko monó zagusaveú noigo, vegená kogómula likamó itó kigisa kigizató alimó nene aitoka ikago kelémo lamaná oko minamó. ");
INSERT INTO gah_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Lá noigo guguni giziaká a ve napa itó monó mogona apí ikimiaká ve nene golivagi netá oko moloko imó nene ánigiake, itó izegipa koma nenete monó zagusaveú minake gopaga lake sigaga sagaga litiki, Tevitini agávolahove gegepoka litune liki nilago giliake, kizapaló molokago, ");
INSERT INTO gah_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","gakó nilamó nene gelemape liki likago, Izesú láa loko lo kimimó: Imane vegenalite sigaga nilinitamó nene gelenoumóza, lekeza nene monó gotolaú gakó makó lá oko nemó nene gatinamóza, lakagatí molahe: Geza lokako namuni keza aminí ninamó nenete sigaga ligitiki gegepoka linigave. ");
INSERT INTO gah_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Láa loko lo kemeake, Zelusalega ahuloake Petania numutoka vike límugusi zekago neneloka akamó. ");
INSERT INTO gah_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Akoake gó lokago, neteká Izesú nene nene Zelusalega goha novike gaúna olamó. ");
INSERT INTO gah_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Gaúna olokago, gohuna za makó nene gapo gohalaló nego ánigoake mogonagú noike gihila zeneihe loko ánigamó. Ánigamó nene agilagó minokago ánigoake gohuna za nene láa loko lo amimó: Geza nene gihila makó zemoko gohuna loloko voko minatanize. Loko noli agepagi ámina za nene osagava vizimó. ");
INSERT INTO gah_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Osagava vizekago, izegipala zuha leza ánigokunike sigaga loko za imane nana okago litá oko osagava vizive. ");
INSERT INTO gah_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Loko lokuko, Izesú nene láa loko lo limimó: Neza lamaná lo likimitoze, gililo. Lekeza nene lakagata losi gelemilo. Gili alévolé iki minatamó nene imane gohuna zamú lumó nenéminiki lekeza alika lilí inigave. Itó nenegó nomive. Lekelisi gili alévolé iminiki agoka makó nene vozane agoka litá oko zeko akutooko age nagamikú holamane liki litamó nene gakotini gele alitimó neve. ");
INSERT INTO gah_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Itó Ómasiloka netá makokumú voká linigi nene, gili alévolé inikigó litamó nene ámina netá alinigave, loko limó. ");
INSERT INTO gah_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Lá oake nene vike monó zagusaveú goha itike monó lo kemeko minamó. Lo kemeko noigo, guguni giziaká ve napa itó monó gizapa ve keza Izesutoka ake gimivagú miliki láa liki lamó: Geza imaneloka netá matá azozá alenimó nene éahini gakotó alene. Itó éaho lokago alenimó neve. ");
INSERT INTO gah_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Liki likago, Izesú nene láa loko lo kimimó: Nezagi gakó makó loká oleketatoze. Li nimikiko nénisi nene éahini gakotó imane netá lá oaká nouhe nenéa nene lo likimitove. ");
INSERT INTO gah_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Zoní nene monó nagamí holokimiaká hoza alimó nene hikutí ale utó ive. Ómasímini gakotó alihe itó mikasiuka vegenalitini gakotó alimó neve. Loko loká okimikago kezáitoka ligili hagili niake ámina gakotó nana oko ale viligoko lo amitune liki gelemó nene gopa okago, láa liki gelemó: Leza Ómasímini gakotó ale utó imole losá nene, eé, lekeza nanamú aí gakó nene gili alévolé amave, loko linogo inae. ");
INSERT INTO gah_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Itó vegená mukí nenete Zonikumú nene Ómasímini agepagutí gakó loaká veve liki linamóma nenazo, hanuva vegenalitikutí ámina hoza ale utó imole losá nene vegenalite nana ilitatahe loko lehelele vizekave. ");
INSERT INTO gah_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Liki kezáitoka liake láa liki lamó: Zonini mogona ma gelemune. Liki likago, Izesú láa loko lo kimimó: Láa likima neza netá matá imane aleaká noumó nene, éahini gakotó lá oaká nouhe nenegi ámina oko lo lekememinogo uve. ");
INSERT INTO gah_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Gakó makó láa loko lo likimitoze, giliki ánigalo. Ve makolímini gipala lositá minasimó. Améipo nene ganá gipala nene láa loko lo amimó: Geza gipánemaka, itínasa nene voko vain mikú nene hoza alezo. ");
INSERT INTO gah_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Loko lokago eza alemitove loko loake alika nene genezala ale viligoake gopa voko alimó. ");
INSERT INTO gah_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Lá okago, alika gipala nenémo amelaho nene ámina gakokó lo amekago, alitove loko loake vike hoza alemoko zogozogo vizeko minamó. ");
INSERT INTO gah_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Itó lekeza nene amelahini gakó éaho gele alimole liki nigeleve. Loko lokago, keza ganá gipala nenémo gele amimole. Liki likago, Izesú nene láa loko lo kimimó: Neza lamaná lo likimitoze, gililo. Takisi moni aliaká vema lekeza ánigi goselé iaká nia vegi itó gapoló vená keza nene Ómasímini avogisaló nene goí i likimiki vinigave. ");
INSERT INTO gah_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Zoní lekelitoka aniteko hehe loko minoaká gapo nene lekelepizekago, lekeza nene monolagi gili ahulikamóma neve. Gili ahulikago, takisi aliaká a vegi itó gapoló venaki nene iki Zonini gakola nene gili alévolé ikamóma nemóza, lekelisi nene aí monó gili alévolé amake likigika ali viligamamóma neve. ");
INSERT INTO gah_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Loko Izesú loake makó láa loko limó: Neza anoza gakó makó litoze, gililo. Ve makó nenémo mikasiva napa minokago, makotoka vain nagá zuhá o asú oake vego vego oko geisa hize asú oake, gihila mí zeko liliká ziti gale legeake, gizapa numuni hána geake, gizapa iki niko meinava likimitove loake vegená makó nene gutá kemeake, mikasi makotoka venoni vimó. ");
INSERT INTO gah_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Voko noigo, gihiláa guzá loaká gamena alitokago, gihiláa makó alinitiki atave loko agulizaki ve nenémo gelekelé izegipala nene kimisilimó. ");
INSERT INTO gah_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Kimiselekago, vi anitikago, mitó gizapa iki mina ve nenete kigizató aliake, makó nene kigizanitunú apelemó, makó nene apili helemó, makó nene gehanitunú apelemó. Lá ikago, gelekelé izegipa makolite viki agulizaki véinima avetó iki li amemó. ");
INSERT INTO gah_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Li amikago, geleake, gelekelé izegipa mukí goha kimiselekago vamó nene ámináminiki kimisiliki kepelemó. ");
INSERT INTO gah_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Kimisilikago, vikago nene, agulizaki ve nenémo lá ikave loko ahulamike gipala hámakó nene láa loko geleake amisilimó: Není gipa gihila imane amiselekugo, agulizaki vemámini gipalama okaze liki ánigiiki nene alími lamaná itamole, loko geleneike amiselekago nene, vo anitekago, ");
INSERT INTO gah_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","mitó gizapa ve keza ánigiake kezáitoka láa liki ligili hagili amó: Imanémo nene mikasi amelahini gipala noinazo, minokoko imane hoza nene ale lá inogo ive. Nenemú nene lélisi apele helekuko helisa henoni nene lelí loló itive, ");
INSERT INTO gah_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","liake nene agizató aliake vain mikutí nene ahelú iliki vake apili helemó. Lá ikamó nenazo, ");
INSERT INTO gah_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","nenemú nene mini amelaho aniteoko nagá mini gizapa ve nene nana oketatimó neve. ");
INSERT INTO gah_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Loko Izesú nene loká okago, keza láa liki li amemó: Áisi lamaná ámina ve golesa kepele gesá itimóma nenae. Itó vain mini nene haitó gizapa ve gutá kemekiko, keza nene guzá lati gamenaló nene gihiláa gona miliki amitave. ");
INSERT INTO gah_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Liki likago, Izesú nene láa loko miní ameko lo kimimó: Monó gotolaú gakó makó lá oko neve: Numuni giaká vete gehani napa makó ánigi ahulamó nenémo geha lapusa alévoleláa loló oake noive. Ámina netá nene Guivahanímini gakotó utó okaze. Vegená neneta ánigokuko nene lamaná okave. Liki luhuva gizina gakó nene lekeza gatinamóza, lakagatí molahe. ");
INSERT INTO gah_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","44","Nenemú lo likimitoze, gililo: Ómasímini gizapa olikimiakalímini lusa nene Zuta ve lekelitotí ipá okoko haitó vegená kiminogo ive. Lá okiko lusámini gihiláa ámina vegenalite ali utó inigave, loko lo kimimó. ");
INSERT INTO gah_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ámina anoza gakó nene lo asú oko lokago, guguni giziaká ve napa itó Palisaio monó vema keza giliake láa liki lamó: Agae, anoza gakokutí gehanimú limó nene Izesuni ánigo ahulunikumú lokave, liki giliake nene ");
INSERT INTO gah_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","agizató alekinake nagá amitune liki lamóza, Izesukumú nene vegená mukilite Ómasímini agepagutí gakó loaká veve liki likamó nenazo, vegenalite lipilikatave liki kelegesá legekago ahulamó. ");
INSERT INTO gah_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Izesú goha miní ameko anoza gakó láa loko limó: ");
INSERT INTO gah_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Okulumalímini lapanalímini mututoni lilí itakumú nene agulizaki ve makolímo netá matá oko moloko imó neneloka lo moloko avetó oko lo likimitoze, gililo. Agulizaki ve makolímo gipalaló vená alemo molanogo noike nosánetá ale vavá imó. ");
INSERT INTO gah_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ale vavá noike gelekelé izegipala kimiselekago, goí oko alesa molo kimi vegená nene iki nosánetá natave liki viki li kememó. Li kimikago, keza nene amánapa ikago, ");
INSERT INTO gah_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","gelekelé izegipalama goha nokimisilike láa loko limó: Neza alesa molo kumu vegená nene viki láa liki li kimilo: Nosánetá nene mota ale vavá okaze. Pulumaká iza gehato minamoláama itó nosánetá haitopaitolímini nene mota ale vavá okave. Lekeza vená ale kemeaká nosató nene alo. ");
INSERT INTO gah_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Loko lokago, keza gelekelé izegipa nenete viki ámina gakó li kememóza, keza gilikago goselé kipilimó. Gili ahuliake ha-gelegele amó. Makó nene míiniuka vamó. Itó makó lugáa nene hozagazanikú vamó. ");
INSERT INTO gah_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Itó lugáa nenete agulizaki vemámini gelekelé izegipa nene kigizató alinake ali golesa iki kepelemó. Makó lugáa nene kipili helemó. ");
INSERT INTO gah_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Lá ikago, eza agulizaki ve nenémo gele golesa oake, izapaló golesa molokago, pilisi veva kimiselekago, vake ámina gelekelé izegipala kipili hele vegenáma kipili gesá iake numuni apáini nene vitú vitú iki ali golesa amó. ");
INSERT INTO gah_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Lá ikago, agulizaki ve nenémo gelekelé izegipalama láa loko lo kimike limó: Vená ale kemeaká nosá nene mota ale vavá okumóza, alesa molo kumu vegenalitini kemetameni nenémo ámina nosá nata avotigila oko minamive. ");
INSERT INTO gah_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Nenemú lekeza gapo izana koma komagú viki vegená nánigikima alesa mili kimikiko vená ale kemeakató nosá ale vavá uhá nene iki natave. ");
INSERT INTO gah_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Loko lo kemekago, gelekelé izegipama nene viki gapo koma komagú mihina ake vegená vóvotiki golesa lamaná mukí nene kilímiki ake nosá ale vavá i numukú nene iki vaí i lamaná amó. ");
INSERT INTO gah_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Vegená mukí iki niago, agulizaki ve nenémo ánigoketanogo itimó. Itike ve makó ánigamó nene vená ali keme gamenámini luhiaká nia gó lamaná luhamike noigo, ánigoake, ");
INSERT INTO gah_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","agulizaki vémo láa loko lo amimó: Nigivénega, nana okago vená ali kiminigi niamómámini luhoaká gó luhamanike imanegú iteko noane. Loko ligo, eza gakó litimoláa nomimó. ");
INSERT INTO gah_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Lá okago, agulizaki ve nenémo gelekelé izegipalama láa loko lo kimimó: Lekeza agisa agizató nagá aliiki ali hetó iiki límugusi apakú ahulimikiko lemeko minino. Neneló minoko ive nama oko miluma maluma geleko agepa atalá oko minanogo ive. ");
INSERT INTO gah_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Loko Izesú lo kemeake makó láa loko limó: Ómasímo vegená mukí alesa molo kemeneimóza, vegená luguhakó kelémo etó okago itiaká niave. ");
INSERT INTO gah_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Izesú láa loko lo kemekago, Palisaio monó ve keza vake láa liki lamó: Nana gakotunú gelehusi gekuko nenegú apilitive. Liake nene gakó gona giziki minake, ");
INSERT INTO gah_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","kezáini izegipáini zuhagutí itó Heloteni izegipala zuhagutí lugáa nene kimisilikago, Izesú noitoka viake láa liki li amemó: Tisalemaka, geí mogonaka gelenoune. Geza gakó gihilagó loaká noane. Gakó lamanakó lanike vegená Ómasímini gapováa vevesoko kelepizeaká noane. Vegenakumú gonukonú osá amane. Vegená iti minamó limi minamó mukí nene lelegí okogó lainim-okimiaká noane. ");
INSERT INTO gah_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Lá onoinazo, geza hanuva lo limitanize. Nanave loko nogelene. Loma gamanímini agulizaki ve napa Sisani nene takisi moni ameaká nounimó nene etahe etamive. ");
INSERT INTO gah_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Liki lamó nene amemitune loko lokikoma gamaniloka alémoko voko goní otatune. Itó hanuva amitune loko lokikoma Zuta vegenalite gili golesa itave loko Izesú nene keí gakóinímini mogona golesa hanuva geleake, láa loko lo kimimó: Genezatini lositaki neneta, nanamú giminegú milanigi nilave. ");
INSERT INTO gah_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Takisi monigutí makó nelepizilo. Loko lokago, moni makó aliki aitoka vamó. ");
INSERT INTO gah_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Vikago, loká oketake vogunahana imanegi itó imane luhuvagi nene éahini neve. ");
INSERT INTO gah_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Loko loká okimikago, keza gamanímini agulizaki ve napa Sisanive liki lamó. Liki likago eza nene láa likima nene gamanímo voká loaká noi netá nene gamani amilo. Itó Ómasímo voká loaká noi netá nene Ómasi amilo. ");
INSERT INTO gah_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Loko lokago, keza nene gakó giliake sigaga limiake ahulimiake vamó. ");
INSERT INTO gah_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ámina gamenaló Satukaio monó vegená lugáa Izesutoka amó. Keza vegená hilinakutí otisá amave liki liaká a vegená nene Izesú noitoka ake, ");
INSERT INTO gah_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","láa liki lamó: Tisalemaka, Mosé láa loko limó: Ve makó izegipala getamoko minoko helekikoma agunalámo ámina gevoná vená nene alekoko uvolaho hili vemú izegipala geto molative. ");
INSERT INTO gah_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Láa lokamó nenazo, gozapá uvolaho agunala 7-a nene lelitoka minamó. Lá iki minake, ganá ve nenémo vená aleake, izegipa getamike helekago, agunala nenémo ámina vená alimó. ");
INSERT INTO gah_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Alekago ámina sunímo utó o amekago, lá imi imi vake vake keza ve 7-a nene ámináminigó amó. ");
INSERT INTO gah_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Keza hili asú ikago, venáini nene alika hilimó. ");
INSERT INTO gah_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ámina ve 7-a nenete aí vanagó minikamó nenazo, nenemú hilinakutí goha otita gamena nene ámina venáma éahini venala loló itimó neve. ");
INSERT INTO gah_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Liki galegutí oteaká gakokumú amé ziki giza itanigi likago, Izesú nene konotó aleko láa loko limó: Lekeza monó gotolaú gakó makó nemóma nene gatinamóza, mogonáa gelemake itó Ómasímo galegutí kelémo oteaká zámuzamú nene ma gelemake gili gopa iki nilahe. ");
INSERT INTO gah_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Keza hele vegená otita gamena nene vená aleakaláa nene nomive. Itó vená aleme kemeakaláa nomive. Okulumakú ageló nenéminiki gohuna minanigave. ");
INSERT INTO gah_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Lá onoimóza, hele vegená goha otitakumú nene gohakú loká oleketatoze. Lekeza imane gakó Ómasímo lo likimimó nene gatinamóza, mogonáa gilinamahe. Emaneloka miniliki ite vemú láa loko lonoimóma neve: ");
INSERT INTO gah_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Neza Avalahani Isakani itó Zakoponi Ómasi minutímina mino loko voko nominuve. Láa loko limó nenazo, nenemú kemeni helenei vegenalitini Ómasi negopa, kemenía hanuva ne vegenalitini Ómasi noinazo, Ómasimú gili zaginake hele vegenaki hanuva mina vegenalitini Ómasi noive. ");
INSERT INTO gah_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Loko lokago, vegená mukí keza gakoláa lo kimikumú nene sigaga sagaga lake agae, vatí oko ale viligoko lo kimive, liki lamó. ");
INSERT INTO gah_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Izesú nene gakotunú Satukaio monó vetini kegepa ze letoko lokago, Palisaio monó ve keza nene gakó nigeleke aitoka iki alegesá iake, ");
INSERT INTO gah_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","keí holúikutí ve makó gakó mogona geleaká i ve nenémo Izesuni amekú molanogo láa loko limó: ");
INSERT INTO gah_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Tisalemaka, Mosé lo hukoko li gakokutí nene hilímo kivilegeko napa neve. ");
INSERT INTO gah_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Loko lokago, Izesú láa loko lo ameko limó: Gigika itó gemeni itó geleakaka mukí nene Guivahani geí Ómasi lehizetozo. ");
INSERT INTO gah_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Nene gakó nenémo napa iteko neve. ");
INSERT INTO gah_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Itó napa otigí nenémo hamolíminigó oko nemó nene lá oko neve: Gezakamú geleaká noanimómáminoko gigivekaginimú geleko gigika kemezo. ");
INSERT INTO gah_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ámina lo hukoko li gakó losi nenémo Mosé lo mola gakó itó Ómasímini agepagutí gakó liaká a vete li mila gakolímini gotoláa loló onoive, loko limó. ");
INSERT INTO gah_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Itó Palisaio monó ve keza alegesá iki niago, Izesú loká oketake láa loko limó: ");
INSERT INTO gah_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Lekeza Ómasímo gologí oleketative loko lo mololeketa vemamú nanave liki nigeleve. Éahini agávolaho noitive. Loko lokago, keza agulizaki ve napate Tevitini agávolahove. ");
INSERT INTO gah_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Liki likago, eza láa loko lo kimimó: Láa likima Sikalahulímo nanamú Tevitini alémo vávani okago Tevití nene ámina vemú nene Guivahaníneve loko live. Tevití láa loko limó neve: ");
INSERT INTO gah_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Mezaú ve nenémo není Guivahani nene není nigizani zamagaloka mino-loko voko noako, gala vega nene geí gigisa lapuvauka ahuloketanogo uve loko lo amimóma neve. ");
INSERT INTO gah_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Tevití nene gologí oleketative loko lo mololeketa vemú nene Guivahaníne ve loko limó nenazo, ámina ve nenémo nana igo Tevitini agávolahogó noitive. ");
INSERT INTO gah_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Tevitini agapilamola noitimóza, Tevitini ve napagi nene noitive. Loko lokago, ve makolite Izesuni anotó aliki li amemitamó onoive. Keza ámina gamenámini veletó nene gakó makó loká itatakumú gelego gena okago, gimivagú miliki loká itamisá amó. ");
INSERT INTO gah_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Izesú koma nominake izegipala zuhagi itó vegená mukiki gakó lo limike láa loko limó: ");
INSERT INTO gah_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Keza monó mogona apí ikimiaká vegi itó Palisaio monó vegi Moseni akilí ali hitinake lo mola gakó mukí apí ilikimiaká niave. ");
INSERT INTO gah_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Lá inake gakó mukí li likimiaká niave. Nene giliiki ámina gakotó ámegetalo. Lá onoimóza, keza iki miliki nia kemetameni nene lekezagi lá amilo. Keza gakó mukí liaká niamóza, kezáini nene ámina gakó ma ámegetisá amave. ");
INSERT INTO gah_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Mosé lo mola gakó nenémo genavagi loló okago vetini kigínagú gihikimikago, gihinago, kezáini nene ámina genavagi netá ma kigizani hisúinitunú kilími vatí itigí iki ma alisá amave. ");
INSERT INTO gah_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Netá mukí aliaká niamó nene vegenalite ánigi kumu hilitive lokogó neve. Monó gotola pepa nene pokisi komagú miliake golihíitó miliake nagá ziaká niave. Itó kigizatoki ámina iaká niave. Luhiaká gó napaló nene gonanalisivagi luhuva hána miní amiki akotiake luhiaká niave. ");
INSERT INTO gah_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Lá inake nosánetá napa ninató nene agepaló siakumukó giliaká niave. Itó monó numukú numukú nene kovogisaló minoaká holomamú kumu heleaká noive. ");
INSERT INTO gah_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Itó vegenalite maketiloka geké lilitatave likigó, itó Tisale liki lilitatave likigó giliaká niave. ");
INSERT INTO gah_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Lá onoimóza, vegenalite lekelikumú Tisale liki li likiminigi niko gili kememilo. Ómasi hamokó nene lekelí tisá noigo, lekeza aí izegipala niake hamó lelegitó niave. ");
INSERT INTO gah_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Imane mikasiuka ve makokumú nene ametehove liki lamilo. Ametipo hámakó okulumakú noive. ");
INSERT INTO gah_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Itó lekelikumú nene lukugulizaki veve liki li likimikatave loko noluve. Lekelí guivahani hamó nene Ómasímo gologí oleketative loko lo mololeketa ve nouve. ");
INSERT INTO gah_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ve makolímo ve napatini loló itove lokoma nene hanuva lemetigí oko gelekelé oleketoko minative. ");
INSERT INTO gah_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Lekelikutí ve makolímohe makolímohe ezáa agulizala ale otitimó nene, ezáa agulizala liminogo ive. Itó ve makolímo ezáa agulizala aleko lemeko molatimó nene, Ómasímo agulizala ale napa inogo ive. ");
INSERT INTO gah_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","Lekeza Palisaio monó ve itó monó mogona apí ikimiaká nia ve ehe tináneve. Lekeza genezatini losigi niamó neneta Ómasímini lapanató voaká gapo nene vegenalitini kovogisaló hizi lí iaká niave. Lekezatini áminagú itisá amave. Itó vegená makó itinigi niago, hanuva itikatave liki ánigi ahulikitisá amave. ");
INSERT INTO gah_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Lekeza monó mogona apí ikimiaká vegi itó Palisaio monó ve lekezagi genezatini losigi neneta, ehe tináneve. Lekeza age nagamitokagi itó mikasiukagi mihina niake vegená makó lekelí izegipatini zuha lilí itave liki kilími miliaká niave. Izegipatini zuha lilí ikago, lekezatinímini iki kilími miluma apakú miliaká niago, kéisi likivilegetigí iki meinímini mututoni lilí iaká niave. ");
INSERT INTO gah_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Lekeza kigikámini agómula likonoiti vema gapo kelepizinigi niamó neneta, lekeza ehe tináneve. Lekeza nene makolímohe makolímohe monó zagusave agulizá oko agizani iteko litimó nene nagamí pizekikoma ha netá nemóza, makolímo monó zagusaveú goli gehani agulizá oko agizani ale oteko litimó nene nagamí pizemoko litímini inogo ive liki liaká niave. ");
INSERT INTO gah_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Lekeza negi nagi likigikámini agómula likamó neneta, nana netalímo iteko neve. Goli gehani iteko nehe itó goli gehani ale etó oko moloaká monó numuni nenémo iteko neve. ");
INSERT INTO gah_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Itó ve makolímohe makolímohe guguni gizoaká ita veletó neti netá agulizá oko agizani noiteko litimó nene nagamí pizekikoma ha netá nemóza, ita amupiló neti netá agulizá oko agizani noiteko litimó nene nagamí pizemoko litímini inogo ive liki liaká niave. ");
INSERT INTO gah_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Lekeza likigikámini agómula lika ve neneta, guguni gizoaká nenémo iteko nehe, itó guguni ale etó oko moloaká ita nenémo iteko neve. ");
INSERT INTO gah_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Nenemú ve makolímo guguni gizoaká italó agulizá oko agizani noiteko litimó nenémo ita veletó neti netaki agulizá oko agizani noiteko litimó geleaká noive. ");
INSERT INTO gah_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Itó ve makolímohe makolímohe monó zagusave agulizá oko agizani noiteko litimó nenémo monó zagusavegi monó zagusaveú minoko aleko oaká noi Ómasigi kugulizá oko agizani noiteko litimó geleaká noive. ");
INSERT INTO gah_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ve makolímohe makolímohe okulumá agulizá oko agizani iteko litimó nene, Ómasi minoaká noi holomagi holomaló minoaká noi Ómasigi kugulizá oko litimó geleaká noive. ");
INSERT INTO gah_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Lekeza monó mogona apí ikimiaká vegi itó Palisaio monó vegi ehe tináneve. Lekeza genezatini losigi vese, mikú noguni mupanuha itó za silogehenigitana oko anuva oaká netá haitopaitolímini nene aliake netá 10 10 minakutí hamopamó nene Ómasíminive liki amiaká niave. Lá iaká niamóza, lo huka gakokutí iteko minamoláa napa nene hehe loko minoko vegená gona moloaká itó likigika hize kemeaká itó Ómasimú gele alévolé oaká netá nene ahulikave. Netá matá 10 10 nekutí hamopamó Ómasi ameaká netá nene ahuloakaláa nomimóza, nolu netá napa nenegi hanuva loló oaká netá neve. ");
INSERT INTO gah_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Lekeza kigikámini agómula likonoi vema gapo kelepizinigi niamó neneta, netá koma likigika ale gopa amoaká netá nene gizaká iki ali ahuliake lekelémo gopa oaká netá napa nene hanuva gopa niki mikilí iaká niave. ");
INSERT INTO gah_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Lekeza monó gakó apí ikimiaká nia vegi Palisaio monó vegi, lekeza ehe tináneve. Lekeza genezatini losigi nego nagamí goni itó lape hetoláa nagamí zinake agikáagú nene guminaló suni itó lukugupémo ánigo amu hili netá nene goni vizi vaí iaká niave. ");
INSERT INTO gah_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Palisaio monó ve gigikámini agómula likonoimó neneka, geza gigikaka nagamí zeko ale guni onako hetokagi nene guluvitanogo ive. ");
INSERT INTO gah_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Lekeza monó mogona apí ikimiaká vegi itó Palisaio monó ve neneta, ehe tináneve. Genezatini losi nego gakó losi liaká niave. Lekeza nene gonosi milimililó vegenalite ánigikiko kumu hilitive liki simeniló gonanalisi iki guhí hiliaká niamó nenéminiki niave. Hetoláaloka ánigi lamaná iaká niamóza, gale agikagú nene hele vegenalitini gonosi zámuza neike anuva oaká netá áminagú vaí onoive. ");
INSERT INTO gah_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Lekezagi lá ikigó niave. Vegenalite hanuva lukugupeló nánigake lekeza hehe liki niave liki giliaká niave. Likigikagú nene soza loaká gakolímo itó li huka gakó pelevesava ziaká netalímo vaí oko neve. ");
INSERT INTO gah_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Lekeza monó mogona apí ikimiaká vegi itó Palisaio monó ve neneta, ehe tináneve. Lekeza genezatini losigi ve neneta, Ómasímini agepagutí gakó liaká a vetini gonosi milimili numuni lamaná lilí iake hee liki iki miliki a vetini gonosi milimili nene gonanalisi ikimiake, ");
INSERT INTO gah_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","leza gozapá avotegini gamenaló minutilina, Ómasímini agepagutí gakó liaká a ve makó kepele hele vegená nene kelémo vatí amutiline liki liaká niave. ");
INSERT INTO gah_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Nene gakó li utó iaká niamó nene lekezatini mogonatinimú nilave. Lekeza Ómasímini agepagutí gakó liaká a ve kipili hele vetini kagapilamó zuha niave. ");
INSERT INTO gah_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Avotikini mogona golesa nene lekelitoka vo aleko neve. ");
INSERT INTO gah_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Lekeza gosihalímini agapilamó zuha neneta Ómasímini goní nenémo lekelémo ló apakú molanogo ive. Lekeza keé liki golisi aminigave. ");
INSERT INTO gah_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Nenemú gililo. Neza Ómasímini agepagutí gakó liaká a vegi itó monolímini mogona apí ikimiaká nia vegi itó monó pukugutí giliaká nia vegi kimiselekugo lekelitoka vinigave. Keí holúikutí nene lekeza lugáa kipili hiliiki lugáa nene zohota zaló gánava ziki apatiiki lugáa nene monó numutikú segi nogosanitunú kipiliiki apá napa makokutí nene gímiziliki viki haitó apakú ahulikitanigave. ");
INSERT INTO gah_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Lá ikiko, mukí hee liki nia vegená kipili helemómámini lihima nene lekelí lukumupiló iteko minanogo ive. Hehe loko mina ve Epoloni apele nohiligo golani leki gamenalotí nene ve lugáa kipili hililiki nivago, Palakiani gipala Zakaliá nene monó zavusave itó guguni giziakató nenémini holutó noigo lekeza napelego golani lekimó keí golanímini lihima mukí nene lekelí lukumupiló itinogo ive. ");
INSERT INTO gah_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Neza lamaná lo likimitoze, gililo. Ámina mogonámini lihimavaláa nene imane oko moloko nou netá ánigiaká nia vegenalitini kumupiló ite asú inogo ive. ");
INSERT INTO gah_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Kee, Zelusale vegenáise, lekeza Ómasímini agepagutí gakó liaká a ve kipili hiliká itó Ómasímo hozaló kimiselekago lekelitoka a ve gehanitunú ahuli miliki kipili hiliká iaká niave. Neza nene lekelí izegipatini zuha nene okolohómo izegipala ale amakuka moloaká noimómáminoko kelémo mulúneuka molanogo oaká noumóza, lekeza gili nimisá amave. ");
INSERT INTO gah_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Lekeza gililo. Ómasímo viselelikimikiko, apatini nene gámé pizinogo ive. ");
INSERT INTO gah_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Láa loko lo nolukumuve. Není nene goha áninagamiki miniliki viki alika Guivahanímini gakotó anitelimikane, Ómasímini lusaló okane liki li niminigave, loko limó. ");
INSERT INTO gah_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Izesú eza monó zagusave ahuloake novigo, izegipala zuha leza monó numunima alapizinogo aitoka unimó. ");
INSERT INTO gah_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Lá unimóza, eza láa loko lo limimó: Lekeza numuni mukí imane nánigahe. Agae, neza lamaná lo likimitoze, gililo. Monó numuni napámini gehani mukí nene apiliki tele vizikiko gehani nene amupiló amupiló iki mililiki itekutí zeko gululupa so asú inogo ive. Itó ziki lana iiki ali hutilikatilí inigave. ");
INSERT INTO gah_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Loko loake, koma minake, Izesú eza Olivi agokaú mitó noigo, izegipala zuha lezagó aitoka itekunike láa loko loká otoko lunimó: Geza lo lemezo. Itína utó iti netakumú lanimó nene nanahé utó itive, itó mikasiuka netá matá asú iti gamena itó geza atiginá itani gamena alitokiko nana anosa utó okiko ánigokinake gele hee litune. ");
INSERT INTO gah_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Loko lokuko, Izesú nene lonotó aleko láa loko limó: Ehe, gizapa ilo. Ve makolímo atiginá oko ato gamenamú lokogoka vizekatize. ");
INSERT INTO gah_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ve mukilite nanitiki není nugulizató liki neza Ómasímo gologí oleketative loko lo mololeketa vema nouve liki vegená mukí kogoka vizinigave. ");
INSERT INTO gah_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Lekeza haitopaitó lovámini gakoláa giliiki itó lova hizinigi niko nenémini gakoláa gilinigave. Lekeza ehe tináneve. Lekeza mulutini itemino. ");
INSERT INTO gah_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ómasímo netá nenémináa utó itive loko lonoimóza, mukí netá matá velesá asú aminogo ive. Numutó namató vegená makolite gala véini lova ali nikimiko, itó numutó namató agulizaki ve napa makolímini zuhagi itó makolímini zuhagi lova hizinigave. Itó haitopaitó mikasiuka gaúna gamena utó oko mino-loko noitiko mukí mikasiuka nene imimá napa omo noviko, ");
INSERT INTO gah_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","miluma netá nenémináa utó itimó nene venalite izegipa getanigi miluma giliaká niamó nenéminoko utó inogo ive. ");
INSERT INTO gah_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Ámina gamenaló nene likigizató aliki viki goní ilikitiki miluma netá alilikitanigave. Itó lá niiki lekelikutí makó likipili hilinigave. Není nugulizá lekelitoka minakumule liki vegená mukí nenete mukahá likipilinigave. ");
INSERT INTO gah_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ámina gamenaló nene vegená mukilite Ómasimú gili alévolé iakáini nene ahulanigave. Keza nene eza amimí iko eza amimí iko iki gasó eza amiko eza amiko inigave. ");
INSERT INTO gah_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Lá niko, mukí Ómasímini agepagutí gakó liaká ve sozámini utó iiki vegená mukí kogoka vizinigave. ");
INSERT INTO gah_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Golesa mogona nenémo hutilí noiko, vegená mukí nenete kigika kemeaká netá nene geha zinogo ive. ");
INSERT INTO gah_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Lá onoimóza, makó keza gamenaváini asú ititó monó ahulamiki alévolé iki minatamó nene, Ómasímo kugutó vizinogo ive. ");
INSERT INTO gah_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Itó Ómasímini gasovaló minoakalímini gakó lamaná nene mikasi nekisa vokisauka numutó namató vegená mukitoka giliiki gili alitahe liki nene li hutilí i asú inigave. Lá ikiko gamena asú inogo ive. ");
INSERT INTO gah_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Lekeza nene mulikizapa iti netá golesa nene apá ale golesa oaká netá gozapá Ómasímini agepagutí gakó loaká ve Tanielé nenemú limó nenémo etó o mina numukú oteneiko ániganigave. (Imane gakó gatatanimó neneka nene gakokumú gele guni ozo.) ");
INSERT INTO gah_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ámina gamenaló Zutaia mikasiuka nita vegená nene golisi iliki agokaloka ititakumule. ");
INSERT INTO gah_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Keza makó numuni numupitó nita vegená nene golisi iliki limiki henoníini nene numúikutí ma aliki vamitakumule. ");
INSERT INTO gah_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Vegená makó mikuka nitakutí nene numukuka luhoaká góini alitune liki atiginá iki vamitakumule. ");
INSERT INTO gah_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Kee, izegipa kagatupagi nita vená itó izegipa namuni aminí nikimita vená nene nana itamó neve. ");
INSERT INTO gah_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Lekeza nene nolu netakutí golisi ita zupa nene golini gamenagú ahe itó Ómasímo lo mololeketa holisi gamenagú ahe utó amitive liki Ómasiloka likigó minalo. ");
INSERT INTO gah_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ámina gamenaló nene genavagi netá napa utó itimó nenémo mikasi nene gosohá nego nenéminoko utó amigo minoloko iteko imane gamenaló utó amive. Nolu gamenaló nene utó okoko, nenémini veletoka goha utó aminogo ive. ");
INSERT INTO gah_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Lá onoimóza, Ómasímo ámina miluma gilita gamena ale atuhá amitimó nene vegená makó ma kavasavagi minamitamóza, Ómasímo kelémo etó i vegenakumule loko ámina gamena ale atuhá inogo ive. ");
INSERT INTO gah_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ámina gamenaló ve makolímo ánigalo, gologí oletati vema imaneloka utó okave, itó volane noive loko lo nolikimikoma lekeza gili zagemilo. ");
INSERT INTO gah_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ámina gamenaló gologí oleketati ve sozámini itó soza saza Ómasímini agepagutí gakó liaká ve utó iiki Ómasímo kelémo etó onoi vegená kogoka vizitupe liki vegenalite sigaga lita netaki soza alévolé sunigi lilí iki avevezaha inigave. ");
INSERT INTO gah_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Gililo. Imane nolu netá utó onamigo mota lo lekemekuve. ");
INSERT INTO gah_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Itó ve makolímo ánigalo, Ómasímo gologí oleketati vema nene mikasi gomopalaló noive loko lo nolikimikoma, lekeza neneloka vamilo. Itó ánigalo, eza nene vozane numukú halá geko noive liki nilikoma, lekeza gili zagemilo. ");
INSERT INTO gah_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Okulumató gó melevezá itimó nene ho noitikukatí ho nolimitoka vinogo ive. Okulumakutí lumu ve gihila neza nenéminoko omo nougo lekeza není ánigi asú inigave. ");
INSERT INTO gah_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Netá helemó gonosiváa nekú nene nama gosúveha mukilite litá iki ánigiiki alegesá iaká niave. Ámináminoko okulumakutí nolumugo mukí vegenalite ánigi asú inigave. ");
INSERT INTO gah_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Nene gamenaló ámina genavagi netá nene asú okiko, ho nene noitiko litá oko límugusi zekiko, ikanímo hize sata amiko, itó sonohí nene okulumatotí atohimí niziko, okulumató amuzavagi netá nene mómoká i asú inigave. ");
INSERT INTO gah_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Lá ikiko, okulumakutí lumu ve gihila goha ato anosa nene okulumató utó noiko, imane mikasiuka není gakó gelema vegená mulusi mukí nene ive nama inigave. Lá niiki okulumakutí lumu ve gihila neza alévolé zámuzánegi itó lapanánegi nene okulumalímini límusi amupiló nolumugo ániganigave. ");
INSERT INTO gah_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Agelóne kimiselekugo, pikuli nene anó napa nomiliko kelémo etó u vegená ezega emegatí ho noititokatí ho nolimitokatí itó mikasi nekisa vokisalokatí kilími nupa inigave. ");
INSERT INTO gah_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Lekeza za gohunámini anoza gakola gili vevesiki gililo. Izanámo nene nagamila nego agila guluma sekago, lekeza ánigiake hogaí gamena mota alitokave liki liaká niave. ");
INSERT INTO gah_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ámináminoko lekeza imane nolu netá mukí utó noiko ánigiiki guivahanite anogo gatekú omo alitokave liki gilitaze. ");
INSERT INTO gah_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Neza lamaná lo likimitoze, gililo. Oko moloko oaká nou netá ánigina vegená velesá hili asú inamiko imane nolu netá mukí utó inogo ive. ");
INSERT INTO gah_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Mikasigi itó okulumaki tolova itáiha, imane lonou gakó nene ma gopa oko tolova aminogo ive. ");
INSERT INTO gah_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Lá onoimóza, ámina gamenamú ve hamoláate keké gelemave. Okulumakú agelogegi nene ma gelemave. Gipala nezánegi ma gelemuve. Améneho hamokó áisi geleneive. ");
INSERT INTO gah_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Okulumakutí lumu ve gihila není gamena alí noliko Noá mina gamenaló lilí a mogona áminagó oko utó inogo ive. ");
INSERT INTO gah_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Gozapá nagamí napa velesá velenamigo, nene gamenaló zahí nagamí niki minake vená meinakona ake zuguzugu zegezege viziki miniliki niago, Noage sipigú itemó. ");
INSERT INTO gah_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ámina vegenalite Noani nagamí viliti gakó gili ahuliake gopa niago, nagamí napa vilike vegená mukí kepele gesá imó. Okulumakutí lumu ve gihila neza ato gamena nene lá oko utó inogo ive. ");
INSERT INTO gah_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ámina gamenaló ve lositá nene makó mikú hoza nalisiko, Ómasímo maga ve alémokoko maga ve ahulotanogo ive. ");
INSERT INTO gah_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Vená lositalitosa nosá isiki nisiko, Ómasímo vená magáa alémokoko magáa ahulomikiko minanogo ive. ");
INSERT INTO gah_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Nenemú Guivahanitini ati gamena nene lekeza ma gilinamamó nenazo, lekeza gizapa keké viziki minalo. ");
INSERT INTO gah_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Lekeza gakó imane gili minalo: Numuni amelaho nene guminaló ve atikumú gilitimó nene, gizapa noiko guminaló ve oko numuni zeko epetooko henoni nene aleminogo ive. ");
INSERT INTO gah_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ámináminoko okulumakutí lumu ve gihila neza atokumú negeva iki minamita gamena atomó nenazo, lekezagi ali vavá iki minalo. ");
INSERT INTO gah_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Není gelekelé izegipa makó nene gele vevesiniki gili minatamó itó hozaváini nene litokó aliki minatamó nene mogonamú anoza gakó lo likimitoze. Gelekelé izegipa makolímo gizapa vevámo aí numukú netá matató gizapa oko minoko hozaló izegipa lugáa gizapa oketative loko lomikiko nosánetá nata gamenaló gona moloko kimitive. ");
INSERT INTO gah_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Gizapa veva nene okoko ámina gelekelé izegipa nene goí oko lotatíminoko hoza nalikoma ánigatimó nene ámina gelekelé izegipamú gulugo agoliza vizitimó neve. ");
INSERT INTO gah_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Neza lamaná lo nolukumuve. Gizapa vevámo gizapa lamaná i izegipama mukí netató gizapa ve loló otanogo ive. ");
INSERT INTO gah_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Lá onoimóza, ámina izegipama gelekelé izegipa golesa noitimó nene není gizapa ve nene litá oko aminogo ive loko mulunagú gelekoko ");
INSERT INTO gah_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","hozaló izegipa lugáa nene nokepeleko itó piá nagamitó ve kezagi niki minatamó neve. ");
INSERT INTO gah_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Lá iki niko, ámina izegipámini gizapa veva nene ámina izegipama ageva oko minamiti gamenahe itó gatizá minati gamenahe okoko ");
INSERT INTO gah_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ámina gelekelé izegipa nene agupe apelevo hukovo okoko soza liaká ve genezáini losigi mina ve niakú alémo molanogo ive. Lá okiko ámina apakuka minoko ive nama oko miluma maluma geleko agepa atalá oko minanogo ive. ");
INSERT INTO gah_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ato gamenaló nene okulumalímini gasovaló vita mogona nenémini oko neve. Vená goliló ve anogo noigo, zaha vená 10-a nenete alími vatí inigi lamu lóini aliiki viki gapoló hotu lokinake zaha venáma noitoka alemoko atune liki vamó. ");
INSERT INTO gah_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Keikutí vená 5 nene negi vená minamó. Itó vená 5 nene kagata koló onoimó. ");
INSERT INTO gah_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Keza negi vená nenete lamu lóini aliki vamó nene nagamilagi aliki vamamó. ");
INSERT INTO gah_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Keza kagatagi vená nenete hela nagamí nene gonigú leki miliake lamu loki nene aliki vamó. ");
INSERT INTO gah_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Vená goliló ve nene litá oko amigo, keza zaha venáma nene kogómula ahihí okago aki minamó. ");
INSERT INTO gah_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Lá iki akinago, holugú akovevé nene sele makó láa loko utó imó: Vená goliló vema mota okave. Lekeza viki gapolotí alímiki ataze, vilo. ");
INSERT INTO gah_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Liki likago, keza vená nenete otiake lamu lóini nene levonaha ali ahuliake ló ligi milamó. ");
INSERT INTO gah_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Lá iake, keza negi vená nenete kagatagi mina venáma láa liki li kememó: Lekeza kalasini makó limilo. Lelí lamutegú nene nagamíma asú okago mota lihanogo noive. ");
INSERT INTO gah_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Liki likago, keza kagatagi mina vená nenete láa liki li kememó: Óe, lekeza viki situakutí meina hizemave. Lekelitokagi lelitokagi vo alemiti avotigila oko minokave. ");
INSERT INTO gah_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Liki likago, keza negi venáma situakú kalasini meina hizinigi viki niago, eza vená goliló vema anitimó. Lá okago, keza ali vavá iki mina venámagi makó itiki numukú minake vená ali kimiaká nosakutí namó. Itó gahe nene giki etoha amó. ");
INSERT INTO gah_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Lá ikago vená lugáama alika ake láa liki sele lamó: Guivahanitemaka, guivahanitemeka, gahe segeletozo. ");
INSERT INTO gah_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Liki likago, eza láa loko lo kimimó: Neza lamaná lo likimitoze, gililo. Lekelí nene ma ánigo hee lamu vená niaze, vilo. ");
INSERT INTO gah_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Loko Izesú nene loake, miní ameko láa loko limó: Nenemú lekeza ato gamenamú ma gilinamamó nenazo, gizapa i guni iki minalo. ");
INSERT INTO gah_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Atiginá inake není gizapaló mina vegenalite iki miliki inakumú goní oketatomó nenémini mogonamú anoza gakó makó lá onoive. Ve makolímo venoni vinogo noko gelekelé izegipala sele lo kemekago, ikago, aí netá mukí nene gizapa initatave loko kigizakú molamó. ");
INSERT INTO gah_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Eza nene gelekelé izegipalatini mogonamú itó zámuzáinimú hamopamó geleneike nenémini avotigila oko moni nene gona moloko kimimó. Ve makó nene 5 tausen kina amimó. Ve makó nene 2 tausen kina amimó. Ve makó nene 1 tausen kina amimó. Lá oake nene, gapo hána venoni vimó. ");
INSERT INTO gah_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Vokago, ámina 5 tausen kina ami vemámo vike pisinisi ike polopeti moni 5 tausen kina makó ale utó imó. ");
INSERT INTO gah_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Itó eza 2 tausen kina ami vemámo ámináminoko pisinisi ike 2 tausen kina ale utó imó. ");
INSERT INTO gah_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Itó 1 tausen kina ali vemámo agulizaki vemámini moni nene aleko vike mikasigú gale legeake gale zimó. ");
INSERT INTO gah_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Gamena hána oko vokago, gelekelé izegipatini kugulizaki vema atiginá oake ámina moni gozapá kemeneikumú nene gakó hoza aliki ali hee litave loko gelekelé izegipama sele lo kimimó. ");
INSERT INTO gah_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Lá okago ámina 5 tausen kina ali ve nenémo ake láa loko limó: Gugulizaki venemaka, ánigozo. Geza 5 tausen kina nemenimó nene neza voko pisinisi uke 5 tausen kina goha makó ale miní ameko ale utó okuke aleko nouve. ");
INSERT INTO gah_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Loko loake amekago, eza agulizaki vevámo láa loko lo amimó: Geza gelekelé ve lamaná noane. Geza vatí oko hozaló gizapa lamaná okane. Hoza komaló ale guni oko gizapa lamaná okanize, nenemú mukí netá gemekugo gizapa itane. Geza oko gugulizaki vegagi logoliza vizeko minatíive. ");
INSERT INTO gah_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Loko lo amekago, eza 2 tausen kina ami ve nenémo ake láa loko limó: Gugulizaki venemaka, ánigozo. Geza 2 tausen kina nemenimó nene aleko vuke pisinisi okuke 2 tausen kina makó goha ale miní ameko ale utó okuke aleko nouve, loko limó. ");
INSERT INTO gah_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Loko loake amekago, agulizaki vevámo láa loko lo amimó: Geza gelekelé ve lamaná noane. Geza vatí oko hoza lamaná oko gizapa okane. Geza hoza komaló ale guni oko gizapa lamaná okanize, nenemú mukí netá gemekugo gizapa itane. Geza oko gugulizaki vegagi logoliza vizeko minatíive. ");
INSERT INTO gah_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Loko lo amekago, eza 1 tausen kina ali ve nenémo ake láa loko limó: Gugulizaki venemaka, geí mogona mota gelenoumole. Geza gínikaha ve noane. Ve makolite mini zuhá inató minumuni omolokago géisi nosá aleko asutoaká noane. Itó ve makolite hoza alikago gihiláa utó okago géisi aleaká noane. ");
INSERT INTO gah_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Lá oaká noanikumú neza nehelele vizekago, ámina 1 tausen kina nene aleko voko mikasigú gale zenoumole. Ména. Geza netaka imane alitane. ");
INSERT INTO gah_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Loko lokago, ve napava nenémo anotó aleko láa loko limó: Geza hozaló ve golesa goselé vaseletó ve noane. Geza není mogona gelenane. Ve makolite mikú netá zuhá inató nosá aleko asutoaká nouve. Itó vegená makolite zuha netá gihila atilí inató minumuni omolokago netá gihila aleaká nouve. ");
INSERT INTO gah_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Nenemú není moni nene peni numukú molataninazo, nanamú neve. Lá onako neza goha inake ámina moniló miní ameke nimilinitiko voko alitonazo. ");
INSERT INTO gah_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Lá okanize, aitokatí ipá iiki 10 tausen kina ale mina vema amilo. ");
INSERT INTO gah_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Gililo. Vegená netá ali miniki gizapa lamaná iki minatamoláa nene goha miní ameko kiminogo uve. Lá onoimóza, ve makolímo netá koma ale minoko gizapa lamaná amitimó nene goha ipá oko alinogo uve. ");
INSERT INTO gah_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Itó ámina hozaló ve goekae ovimoláa nene amisili hetó ikiko límugusi apakú lemeko ive nama oko miluma maluma geleko agepa atalá oko minanogo ive, loko limó. ");
INSERT INTO gah_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Okulumakutí lumu ve gihila neza lapanánegi noinake agelogegi makó inake gonanalivagi siató minanogo uve. ");
INSERT INTO gah_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Lá oko nougo, keza mikasiuka vegená mukí iki novogisaló alegesá inigave. Lá niko, neza gona moloko vegená nene kelémo losi molanogo uve. Izaló gizapa vémo meme iza kelémo haitó noike itó sipsip iza kelémo haitó oaká noimó nenémini oko ");
INSERT INTO gah_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","neza sipsip izagitana nia vegená nene kelémo nigizani zamagaloka milinake, meme izagitana nia vegená nene kelémo sogaloka molanogo uve. ");
INSERT INTO gah_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Lá okinake nugulizaki ve noumó imanémina nigizani zamagaloka mina vegená nene láa loko lo kiminogo uve: Améneho nónohá zeleketa vegená neneta, gililo. ");
INSERT INTO gah_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Neza gaúna nohulugo nosánetá nimiaká amó, itó nagamikumú nonivisigo nagamí ihimi nimiaká amó, itó veno ve loló okuke nougo numutikú nilími miliaká amó. ");
INSERT INTO gah_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ginegane nomigo ginegane nimiaká amó. Nivisekago nougo lekeza nasahilí inimiaká amó. Nagá numukú nougo lekeza iki áninigiaká amó. Lá iaká amó nenazo, gozapá mikasi apí oko ale utó inogo Ómasímini gizapaló minata apá ale vavá oleketonoimóma nene iki alilo. ");
INSERT INTO gah_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Loko lo kemekugo, keza hee liki mina vegená nenete láa liki li niminigave: Guivahanitemaka, leza nanahé zupa gaúna nogolago ánigokunike nosánetá gemehá neve. Itó nanahé zupa nagamikumú nogivisigo nagamí ihemo gemehá neve. ");
INSERT INTO gah_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Itó nanahé zupa veno ve loló oko noako numuteuka gelémo muluhá neve. Itó nanahé zupa ginegane nomigo leza ginegane gemehá neve. ");
INSERT INTO gah_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Itó nanahé zupa givisekago noako ániguhá neve. Itó nanahé zupa nagá numukú noako ániguhá neve. ");
INSERT INTO gah_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Liki likiko, neza nugulizaki ve noumó imanémina láa loko lo kiminogo uve: Neza lamaná lo likimitoze, gili minalo: Vegenáne zuha limiki minamoki loló oketupe liki lilí amó nene není lilí initamó gelekave. ");
INSERT INTO gah_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Loko lo nokiminake nigizani sogaloka minata vegená nene láa loko lo kiminogo uve: Usilímini mututoni lekeza gililo. ");
INSERT INTO gah_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Neza gaúna heleko nougo nosánetá makó nimisá amamó. Nagamikumú nonivisigo nagamí ihimi nimisá amamó. ");
INSERT INTO gah_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Neza veno ve loló okuke nougo lekeza numutikú nilími milisá amamóma neve. Itó gineganemú vitagá nougo ginegane ma nimisá amamóma neve. Itó nagá numukú nougo itó nivisekago nougo lekeza ma iki ániginitamamóma nenazo, není ahuliiki viki ló lihamike lova lova oko nomina ló améneho Satagegi itó agelolagi ale vavá oketonoimó nenegú limilo. ");
INSERT INTO gah_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Loko lo kemekugo, keza láa liki li niminigave: Guivahanitemaka, geza nanahé zupa gaúna heleko noako itó nanahé zupa nagamikumú nogivisigo itó nanahé zupa veno ve loló oko noako itó nanahé zupa gineganega nomigo itó nanahé zupa givisekago noako itó nanahé zupa nagá numukú noako gelémo vatí amuhakumú lane. ");
INSERT INTO gah_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Liki likiko, neza láa loko lo kiminogo uve: Neza lamaná lo likimitoze, gililo. Imane mikasiuka limiki mina vegenaki lá ikitamamó nenémo není lá initamamó gelekave. ");
INSERT INTO gah_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Loko lo kemekugo, ámina vegená nene miluma apakú viki miniki miluma asú amoakalímini alinigave. Itó hehe liki mina vegená nene alévolé kemetamenigi minova minova oaká apató viki minanigave. ");
INSERT INTO gah_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Izesú nene ámina gakó lo leme asú oake ámina gamenaló izegipala zuha láa loko lo limike limó: ");
INSERT INTO gah_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Gamena losi oko vokiko gozapá avotikini asenini zeketakumú gele minoaká holisi utó inogo ive liki lekeza gilinave. Lá noiko, okulumakutí lumu ve gihila neza nene ve makolímo nimimika loko lova vetini kigizakú nelémo molokiko zohota zaló nipili hilinigave, loko limó. ");
INSERT INTO gah_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ámina gamenaló monó gizapa vegi guguni giziaká vegi keza Isilae vegenalitini guguni giziaká ve napatini gizapa venini Kaiapani numuni napagú alegesá amó. ");
INSERT INTO gah_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Keza asuguná iki Izesuni agizató aliki apili hilita gakó ligili hagili iki li hukamó. ");
INSERT INTO gah_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Lá amóza, ámina holisigú apele helemitune. Vegenalite lova napa ali utó iki lipilikataze, liki lamó. ");
INSERT INTO gah_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Izesú nene Petania numutó nene Saimon eza halamé gizaleake minake zoka vémini numukú minamó. ");
INSERT INTO gah_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Lá noigo, vená makó aitoka ake agizakú anuva uveli meinava iteko mina netá nene gehanigitana gonigú aleake Izesú nosánetá noko noigo gotolaú leketamó. ");
INSERT INTO gah_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Lá noigo, izegipala zuha leza ánigokunike gele golesa nounike lezateloka láa loko lunimó: Anuvagi uveli lamaná nene nanamú latila noive. ");
INSERT INTO gah_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Itó leza ámina anuvagi uveli nene hanuva minalina, vegená meina hizitave loko kemesá nene meinava napa alekunike gohogó vegená kumutiline. ");
INSERT INTO gah_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Loko noguluko Izesú nene gakote geleake láa loko lo limimó: Lekeza imane vená nana igo genavagi gakó li nameve. Eza nene netá lamaná alenimikave. ");
INSERT INTO gah_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Gohogó vegená keza nene lekezagi miniliki viki minatamóza, neza lekezagi gamena hána minoloko voko minaminogo uve. ");
INSERT INTO gah_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Vená imanémo gonosi milimiligú gale zinitatakumú geleake nugupeló anuvagi uveli holonimikave. ");
INSERT INTO gah_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Neza lamaná lo likimitoze. Mukí mikasiuka není gakó lamaná imane li utó iki li kimitató li kimitató nene imane venalímini mogonamú gili zagitave liki eza loló oneta sunimú li kiminigave. ");
INSERT INTO gah_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Loko lokago, ámina gamenaló izegipala zuha 12-a lelikutí Kaliotó numutotí ve agulizá Zutá áisi nene guguni giziaká ve napa niató vimó. ");
INSERT INTO gah_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Vike Izesuni amimí itotó lekeza nanetá nimitune liki nigeleve. Loko lokago, keza silivá gehani 30 alitane liki li hutiake amikago, ");
INSERT INTO gah_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","eza nene Izesuni amimika linogo amapani molamó. ");
INSERT INTO gah_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Lulu vizemi peleti niaká a holisímini ganá gamenagú nene izegipala zuha leza Izesú noitoka voko geza asenini zeketakumú gele minoaká nosánetá nene hikú viki ale vavá initatave loko nolane. Loko lokuko, ");
INSERT INTO gah_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","eza láa loko limó: Lekeza taonigú viki ve makó noititó nene viki tisamámo není gamena mota alitokaze, geí numukú asenini zekimiaká nosá nene izegipáne zuhagi natune lokago nousive liki li amilizo. ");
INSERT INTO gah_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Loko lokago lelikutí ve lositosa nene Izesú litímini asike asenini zekimiaká nosá ali vavá asimó. ");
INSERT INTO gah_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Lá ikasigo gánavaló nene Izesuki izegipala zuha 12-a lezagi alegesá unike nosánetá nunimó. ");
INSERT INTO gah_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Nosánetá noko nounike Izesú láa loko limó: Lamaná lo likimitoze, gililo. Lekelikutí makolímo nimimika linogo ive. ");
INSERT INTO gah_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Loko lokago, leza miluma nogeleko hamopamó Guivahanitemaka, nenikumú nolape, nenikumú nolape loko loká miká otunimó. ");
INSERT INTO gah_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Lá okuko, Izesú láa loko lo limimó: Hamó lapegú peleti nagamí zeko nonousi ve nenémo nimimika linogo ive. ");
INSERT INTO gah_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Okulumakutí lumu ve gihila nenikumú monó gotolaú luhuva gizinamómámini oko hilito gapogú novumóza, nimimika liti ve agae, lihima sipisi alitimó nenazo, izolaho aí getamilina nene vávani oko minaline. ");
INSERT INTO gah_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Loko lokago, amimika liti ve Zutá nene láa loko limó: Tisalemaka, nenikumú nolape. Loko lokago, Izesú nene gezaka mota lokanimole loko limó. ");
INSERT INTO gah_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Nosánetá nonunike Izesú nene peleti aleake Ómasi agepoka loake gitegeko izegipala zuha nolimike láa loko limó: Aliki nalo. Imane není mémeláne neve. ");
INSERT INTO gah_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Loko loake, vain goni aleake Ómasi agepoka loake nolimike láa loko limó: Lekeza mukitó nalo. ");
INSERT INTO gah_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Lo múnaheaká gakolímini golaníne nene vegená mukilitini lihimáini gilatoketative loko lekitomó imane neve. ");
INSERT INTO gah_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Lamaná lo likimitoze, gililo. Vain nagalímini gihilagutí goha naminake minoloko vinake améneho nugulizaki velini loló onetati gamenaló vain nagamí haitolímini lekezagi makó natune. ");
INSERT INTO gah_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Loko loake, monó nama makó lunike lemeko Olivi agokaú itinogo vuhá. ");
INSERT INTO gah_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Agokaloka itinogo nounike Izesú láa loko lo limimó: Monó gotolaú Ómasímo li gakó makó láa liki gizinamóma neve: Gizapa ve apelekugo sipsip iza mulusi nene hutilí iki golisi inigave. Liki gizinamóma nenazo, itína holugú lekeza mukitó golisi iiki visilinitatamóza, ");
INSERT INTO gah_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","helekugo, goha nelémo otekiko, Galilaia mikasiuka goí o lekemeko vitove. ");
INSERT INTO gah_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Loko lokago, anotó aleko Pitá láa loko lo amike limó: Nénisi viselegetamitove. Keza mukitó gele alévolé oakáini nene golo golo sokikoma, neza lá aminogo uve. ");
INSERT INTO gah_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Loko lokago, Izesú láa loko lo amimó: Lamaná lo gimitoze, gelezo. Itína holugú nene okolohomámo anó molonamiko nenikumú ánigamuve loko egamega onetatanimó nene gamena losive makole inogo ive. ");
INSERT INTO gah_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Loko lokago, Pitá láa loko lo amimó: Neza nene geikumú egamega ogetaminogo uve. Nipili hilinigi niko gezagi makó helekusigoma lá ogetaminogo uve. Loko lokago, izegipala zuha mukitó leza láa lokogó lunimó. ");
INSERT INTO gah_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Loko lokuko Izesú nene izegipala zuhamagi apá makó agulizá Gesemane neneloka makó vuhá. Vo anitekunike láa loko lo limimó: Lekeza nene imaneló niko neza volaneloka vokinake Ómasiloka litove. ");
INSERT INTO gah_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Loko loake Pitani itó Zepetaioni gipala losigi nene kelémoko vimó. Nivake mulunagú peisi nozigo miluma golesa gilike ");
INSERT INTO gah_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","láa loko lo kimimó: Neza mulúnegú nene gónupa geake hilitomó onoive. Lekeza imaneló miniki nenikumú gizapa iki niko makó gizapa oko minatune. ");
INSERT INTO gah_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Loko loake koma minomo novike avogisalokatí pou loko agoka hizeko nakake Ómasiloka láa loko limó: Aménega, gapo neikoma geza genavagi gihinitata netá imane ale ahulonetatane loko nolumóza, není nigikaloka ale molamoko geí gigikaloka nelémo molatane loko noluve. ");
INSERT INTO gah_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Loko loake, goha ake, izegipala zuhama kovó akinago ánigoake, Pitani alémo oteko láa loko lo amimó: Lekeza nene nana ive. Nezagi gizapa oko mininake gamena koma ma oti minamitamó nehe. ");
INSERT INTO gah_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Lekemekú milatakumú gopa ikataze, lekeza gizapa iki miniki Ómasiloka liki minalo. Ligikámo vávani noimóza, lugupémo gena noive. ");
INSERT INTO gah_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Loko loake, goha vike Ómasiloka like láa loko limó: Aménega, genavagi netá imanémo nivilege vamitimó noikoma, geí gigikaloka nelémo molozo. ");
INSERT INTO gah_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Loko loake, goha oko ánigamó nene kogómula ahihí okago, kovó akinago ánigamó. ");
INSERT INTO gah_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ahulokimiake goha vike Ómasiloka ligo gamena losive makoki imó. Goí oko vike Ómasiloka limómámini okogó limó. ");
INSERT INTO gah_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Loko loake, goha ake izegipala zuha lelémo otike láa loko lo limimó: Lekeza nanamú lakavasú viziki hanuva aki niminave. Gilinahe. Okulumakutí lumu ve gihila nimimika liki lihimáinigi vetini kigizakú nilími milata gamena mota okave. ");
INSERT INTO gah_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Lá onoize, lekeza otiiki vilo. Ánigalo. Nimimika liti vema alitó mota okave. ");
INSERT INTO gah_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Izesú gakó lo limi agepagi izegipala zuha 12 lelikutí makó Zutá noago, vegená mukí ámegetiki niake sopolo hánagi gelekahosigi ali minake amó. Keza nene guguni giziaká vete itó Zuta vetini monó gizapa vete emane amunaloka kimisilikago vamó. ");
INSERT INTO gah_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Nivake Izesuni amimí inogo i vémo gakó makó lo kimike láa loko limó: Neza vinake ve makó nene agoka legeko nonugoma ánigiiki ámina ve noive liki nigiliki agizató alilo. ");
INSERT INTO gah_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Loko loake, ake, Izesú noitó litá oko vo amatoka aniteake, oho, Tisalema, nene noape loko loake, agoka legeko namó. ");
INSERT INTO gah_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Lá noigo, Izesú láa loko lo amimó: Nigive, geza loló inogo noani netá nene litá oko loló ozo. Loko noligo, lova ve nenete ake Izesuni agizató ali gikitiki alemó. ");
INSERT INTO gah_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Nalego Izesuki makó minuhakutí makolímo sopolo hána nene golagutí aleko gelelehá oake guguni gizoaká ve napámini gelekelé izegipa apilike agata zeko isimó. ");
INSERT INTO gah_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Lá okago, Izesú láa loko lo amimó: Sopoloka nene alenikuka goha ale molozo. Lekeza sopolotunú geza okaní geza okaní liki liki likipili gesá ikataze. ");
INSERT INTO gah_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Geza nene gelemape. Neza aménehitoka litomó nene litá oko ageló nene lovámini galaváa mulusi napa 12-a nene kimiselekiko limiki nilími vatí inigave. ");
INSERT INTO gah_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Lá itamóza, lá okugo Ómasímini luhuva nenémo nana oko gihila zitive. Gozapá monó gotolaú nenéminoko utó itive liki luhuva gizinamóma neve. ");
INSERT INTO gah_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Loko loake, ámina gamenaló ali nupa ina vegená nene Izesú láa loko lo kimike limó: Lekeza nenikumú gelemó nene geligeli ve nougo sopolo hánagi gelekahosigi aliki niake nigizató alinigi niahe. Neza gamena gamena monó zagusaveú minuke monó lo keme keme oko minumómaló nene nigizató alemamó nehe. ");
INSERT INTO gah_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Lá ikamóza, Ómasímini agepagutí gakó liaká a vete emane amunaló monó gotolaú nenikumú luhuva gizina gakó nene gihila zitive loko netá mukí imane utó noive. Loko lokago, izegipala zuha leza Izesuni ahulomikunike golisi hutilí oko vunimó. ");
INSERT INTO gah_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Izesuni agizató aliake guguni giziaká vetini ve napa Kaiapani numukú alímiki vake keza monó mogona apí ikimiaká vegi itó monó gizapa vegi ali nupa iki minató alímiki vamó. ");
INSERT INTO gah_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Lá niago Pitá nene hotó otigí oko kémegetoko vike guguni giziaká vetini ve napámini hé numunaló áneneló vo aniteake, iteake pilisi vegi minake neneló goní itatakutí nana netá utó itihe loko gizapa oko minamó. ");
INSERT INTO gah_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Lá noigo, guguni giziaká ve napagi monó kansolegi mukitó nene Izesuni apele hilitune liki soza hakupá gakóinimú vitagá amóza, ");
INSERT INTO gah_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","ma ali utó amamó. Mukilite ake Izesukumú soza hakupá gakó lamóza, liki amupesamó. Lá iva iva niake ve lositá nenetosa otikasike ");
INSERT INTO gah_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","láa liki lasimó: Imane vémo nene Ómasímini monó zagusave zeko tele vizekinake gamena losive makolegó oko noviko goha hanuva gitomó neve loko noligo gulusimóma neve. ");
INSERT INTO gah_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Liki likasigo, guguni giziaká vetini ve napa nenémo oteake Izesuni láa loko lo amimó: Geza goní nigitasike nilasi gakotó ale viligoko lo kimitani gakó ma nomihe, olo. ");
INSERT INTO gah_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Loko lokago, Izesú agepa apizeake minokago, eza ve napa nenémo láa loko lo amimó: Alévolé Ómasímini avogisaló lo utó itane loko nologetuve. Geza Ómasímini gipala gologí oletatane loko lo mologeta vema noape loko lo lemezo. ");
INSERT INTO gah_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Loko lokago, Izesú láa loko lo amimó: Nene geza mota lokanimóza, neza makó láa loko lo nolukumuve: Imane gamenámini veletó nene okulumakutí lumu ve gihila neza amuza vémini agizani zamagaloka nougo, itó okulumalímini límusi amupiló nolumugo ániganigave. ");
INSERT INTO gah_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Loko lokago, guguni giziaká vetini ve napa nenémo gele golesa oake luhoaká gola aleko polo noligike láa loko limó: Mota Ómasi aviliginogo lokave. Gakola gilinita vegená makó nanamú sele lokinake gakola makó litune. Eza Ómasi avilegeko li gakó lekeza itínasa mota gilikave. ");
INSERT INTO gah_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Nenemú lekeza nana otatune liki nigeleve. Loko lokago, keza nakahunímini gakó lokaze, mota hilitive. ");
INSERT INTO gah_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Liki liake, lugáate Izesuni agoka agepagú gituhú nitake kigizanitunú napelego, lugáate agoka agepaló nihitake kigizanitunú napeleke ");
INSERT INTO gah_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","gologí okimiaká ve neneka, geza gakó mogona geleaká ve noitanimó nene éaho nogipilihe lo utó oko lo lemezo liki li amemó. ");
INSERT INTO gah_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Lá niago, Pitá nene hé numunaló noigo guguni giziaká vetini ve napámini gelekelé mohó makolímo Pitá noitó oake, geza Galilaia mikasigutí ve Izesuki miniaká niasi vema noane, ");
INSERT INTO gah_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","loko lo amekago, eza vegená kovogisaló egamega ike gakó lanimó nene ma gelemuve. Loko loake, ");
INSERT INTO gah_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","hé numunamámini gatetó lemeko noigo, gelekelé mohó makolímo aí ánigoake áminaló mina vegená nene láa loko lo kimimó: Ve imanémo Nasalete numutotí ve Izesuki miniaká asi vema noinae. ");
INSERT INTO gah_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Loko lokago, Pitá goha egamega ike láa loko limó: Ómasímini avogisaló nigizani ale oteko lamaná noluve. Ma ánigonamu vemú nolane. ");
INSERT INTO gah_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Loko loake, gamena komáisí noigo, áminaló oti mina ve nenete Pitá noitoka ake láa liki li amemó: Lamaná nilave, geza ámina vémini zuhagutí noane. Gonó lupámo geí Galilaia mikasiukatí mogonaka ale utó okave. ");
INSERT INTO gah_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Liki likago, Pitá nene Ómasímini avogisaló lo hutoko lamaná noluve, ámina ve nene ánigonamuve. Soza litomó nene Ómasímo usí vizenimikatize, loko limó. Loko noli agepagi litá oko okoloho nenémo anó molamó. ");
INSERT INTO gah_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Anó molokago, Pitá nene Izesú nene okoloho nenémo anó molonamiko není ánigonamuve loko egamega onetatanimó nene gamena losive makole inogo ive loko lo ami gakó goha agata geleake, lemeko hetoka ive napa imó. ");
INSERT INTO gah_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Neteká ho noitigo, guguni giziaká ve napagi itó monó gizapa vegi Izesuni apili hilita gakó li hukamó. ");
INSERT INTO gah_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Lá niake nagá ziki alímiki agulizaki ve Pilató noitoka goní itanigi alímiki vamó. ");
INSERT INTO gah_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Zutá eza Izesuni amimika li ve nenémo ánigamó nene Izesunima goní nitake hilitive liki gakó li hukimikago, Zutá nene goha agika ale viligoake silivá moni 30-ma nene guguni giziaká ve napagi itó monó gizapa vegi minatoka aleko atiginá oko voko kimimó. ");
INSERT INTO gah_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Lá noike láa loko limó: Neza lihima alenouve. Eza lihimavala nomi vema amimika lokugo hilinogo noive. Loko limóza, nene lelí netá nomive. Geí netaka neve. ");
INSERT INTO gah_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Liki likago, eza Zutá nene ámina silivá moni 30 nene aleko itike monó numuni napagú hutilí oko ahuloake, lemeake vike nagá imó. ");
INSERT INTO gah_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Lá okago keza guguni giziaká vemate ámina silivá moni 30 nene aliake láa liki lamó: Imane hutono moni nene ve makó hilinogo imómámini moni neve. Lekeza nenémi moni nene monó numukú milamilo liki li hukinamóma neve. ");
INSERT INTO gah_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Liki liake, ligili hagili iake gakó makó li hukamó. Lá iake mikasi mulalokatí vetini gonosi milimili minative liki mikasi agulizá nene mikasi somo lilí iaká vetini mikasi nene meina hizemó. ");
INSERT INTO gah_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Lá iake ámina mikasi agulizá nene gola mikasive liki milamó. Ámina agulizá nene itínasagi nene hanuva neve. ");
INSERT INTO gah_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Lá onoigo gakó makó gozapá Ómasímini agepagutí gakó loaká ve Zelemiani agepagú lo mola gakó nene gihila zimó. Láa loko luhuva gizamóma neve: Keza ámina silivá moni 30 alemó nene Isilae vegenalite monimú li milamó imane vémini meinavamú neve liki linamóma nenazo, ");
INSERT INTO gah_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ámina moni aliake mikasi somo lilí iaká nia vetini mikasi meina hizemó nene Guivahanímo lo nimitó neve. ");
INSERT INTO gah_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Izesuni nene alímiki vake kugulizaki vetini ve napa Pilatoni avogisaló hizi otitamó. Lá ikago, eza agulizaki vemámo loká otake láa loko limó: Geza nene Zuta vetini kugulizaki ve napáini noape. Loko lokago, Izesú nene gezaka mota lokanimole. ");
INSERT INTO gah_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Loko lokago, guguni giziaká vemagi itó monó gizapa vemagi keza Izesunimú hizi miliki gakó nilago, eza la gakotó ma lo kememigo, ");
INSERT INTO gah_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pilató nene láa loko limó: Geza nene mukí gakó liki goní nigitamó nene gelemape. ");
INSERT INTO gah_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Loko limóza, Pilató li gakotó ma viligoko lo amemimó. Lá noigo kugulizaki vetini ve napa Pilató nene agata gululusi gilimó. ");
INSERT INTO gah_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Asenini zeketakumú gili mina holisi gamena meleketó meleketó nene Zuta ve vená nenete aseva zetatune liki ve makolímini agulizá ikago agulizaki ve nenémo nagá numukú mina ve nene kimisele ahuloká ahuloká okago nene, ámina ve keitoka viaká amó. ");
INSERT INTO gah_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ámina gamenaló nene ve makó agulizá hutilí oko vi ve nene nagá numukú minamó, Izesuni apolaho agulizá napa nene Palapasí. ");
INSERT INTO gah_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Lá okago, ve vená alegesá ikago, Pilató loká oketake lekeza éahini aseva zemikugo lekelitoka vitive liki nilave. Gologí olimiaká veve liki lina ve Izesuni aseva zetatohe, itó Izesuni apolahini Palapasini aseva zetatohe. ");
INSERT INTO gah_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Loko limó nene keza Izesukumú amekugú niki miniake gonitó alími utó amó nenemú Pilató geleneike loká oketamó. ");
INSERT INTO gah_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Itó Pilató nene goní gakó lo hukoaká siató noigo, venala nenémo aitoka gakó lo ahulake láa loko limó: Geza nene ámina hehe loko noi vemámini agupeloka gakó ma lo molotamo. Itína holugú nene vamó makó ánigo amekuke aikumule loko miluma napa gelemikuve, loko limó. ");
INSERT INTO gah_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Itó guguni giziaká ve napamagi itó monó gizapa vemagi vegenalitini mulúikú hiziki láa liki nilago, Palapasini aseva zetative liki Pilatotoka nilake Izesuni nene apili hilitave liki lamó. ");
INSERT INTO gah_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Liki likago, eza agulizaki vemámo ve losi imane niasimó nene éahini ahulomikugo lekelitoka vitive. Loko lokago, Palapasinive liki lamó. ");
INSERT INTO gah_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Liki likago, Pilató nene lá okinake vegená mukilite gologí olimiaká noi veve liki lina ve Izesuni nene nana otatove. Loko loká okimikago, keza zohota zaló nagá otamane liki lamó. ");
INSERT INTO gah_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Liki likago, Pilató eza nanamú neve limó. Eza nana netá golesa alekago nilave, loko limóza keza zohota zaló nagá otamane liki pigi viziki lamó. ");
INSERT INTO gah_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Liki likago, Pilató gilimó nene eza liti gakó nene ma vo alemitimó oake lova napa utó itimó okago, eza nene vegenalitini kovogisaló nagamí aleake agizani nagamí zimó. Lá noike láa loko limó: Imane ve apili hilitatímini lihima nenitoka ma minaminogo ive. Nene lekelí netale. ");
INSERT INTO gah_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Loko lokago, keza vegená mukí nenete anotó aliki láa liki lamó: Ámina lihima nene lezalokagi itó izegipa lagapilamotokagi minino. ");
INSERT INTO gah_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Liki likago, Pilató nene Palapasini gologí omikago keitoka vimó. Itó Pilató lokago, Izesuni nene segi nogosanitunú apilikago zohota zaló nilitunú ziki apili hilitave loko pilisí vetini kigizakú molamó. ");
INSERT INTO gah_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Lá okago agulizaki vemámini pilisí vevate Izesuni nene alímiki agulizaki vemámini numuna napagú nene iteke keza ámina pilisí ve mukitoka nene kilími nupa amó. ");
INSERT INTO gah_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Lá iake agulizaki vegitana lilí itake Izesuni ginegane nene gololohá iki ali miliake ginegane okohu gó nene luhimiake, ");
INSERT INTO gah_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","gasovagi nagatunú nene akilí lilí iake gotolaló hitimiake, agizani zamagaloka nene akepa nogosani makó amikago ale minamó. Lá onoigo, pilisí vete amatoka iki kalapusa hizeke gopoguka litake láa liki lamó: Oga, mokáneve, Zuta vetini kugulizaki veninimave. ");
INSERT INTO gah_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Liki nilake agoka agepagú gituhú nitake ámina akepa nogosani nene aliake gotolaló zemó. ");
INSERT INTO gah_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ziake gopoguka li asú itake okohu gó luhitamó nene gololohá iake ezáa gineganeva nene goha luhitamó. Luhimiake zohota zaló nilitunú ziki apili hilinigi alímiki vamó. ");
INSERT INTO gah_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Lá inigi nivake Apilika mikasiukatí Sailini apatotí ve makó agulizá Saimon nene gapoló noago ánigiake Izesuni alémo vatí oko zohota zava gehetative liki gala vizikago, ");
INSERT INTO gah_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","makó vake apá makotó vamó, agulizá Goligota, nene agulizalímini mogona nene gotóini gonosi helisa apale loko. ");
INSERT INTO gah_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Neneló anitiake Izesú native liki vain nagamiki ekesá netaki ali gopa iake miluma gelemitive liki amemó. Amikago eza nene no geleake namike hanuva minamó. ");
INSERT INTO gah_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Lá okago, zohota zaló apiliki apatemó. Lá iake gineganeva nene éaho alitihe éaho alitihe liake kezáini nene satu zohí amó. ");
INSERT INTO gah_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Lá niake áminaló nene gizapa iki minamó. ");
INSERT INTO gah_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Velé gotolaloka nene goní ita gakó nene láa liki luhuva gizikago minamó: Imane ve nene Izesú ave Zuta vetini kugulizaki veninive. ");
INSERT INTO gah_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Liki luhuva giziake Izesuni amatoka nene guminaló ve geligeli ve lositá nene makó nene agizani sogaloka apatiake itó makó nene agizani zamagaloka kipiliki apatemó. ");
INSERT INTO gah_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Lá inake keza vegená vigá igá amó nenete gotóini goké goké nizeke amé ziki gopoguka litake, ");
INSERT INTO gah_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","láa liki lamó: Geza nene monó zagusave zeko tele vizekoko gamena losive makolegó oko vokiko gitomó neve loko loaká noanimóma neze, geza gugupeka alémo agutó vizemane. Geza Ómasímini gipala nouve lokoma zohota za nene ahulokoko lememane. ");
INSERT INTO gah_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Liki nilago, keza guguni giziaká ve napamagi itó monó mogona apí ikimiaká ve itó monó gizapa vemagi hamolíminiki amé ziki gopoguka litake láa liki lamó: ");
INSERT INTO gah_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Vegená lugáa kelémo kugutó vizeaká imóza ezáa nene alémo agutó vizemitimó okave. Eza Isilae vetini agulizaki vema noitimó nene itínasa zohota zalotí apasokoko limitinae. Lemekiko leza aikumú gele alévolé ituninazo. ");
INSERT INTO gah_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Eza nene Ómasimú gele alévolé onoike neza nene Ómasímini gipala nouve loko limó nenazo, Ómasímo aikumú geleneitimó nene itína alémo agutó vizitimole. ");
INSERT INTO gah_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Liki likago, guminaló geligeli ve losi Izesuni agilika luga luga zohota zaló kipiliki apatemó nenetosagi ámináminiki amé zitigí iki lasimó. ");
INSERT INTO gah_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Holisaká nene mukí mikasiuka límugusi ze asú oake minoloko novigo únaká ho ale zohota imó. ");
INSERT INTO gah_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Únaká ho ale zohota noigo, Izesú pigi vizeko ezáa gakokutí nene Eli Eli lema sapakatani loko limó. Lelí gakotegutí nene Ómasinemaka, Ómasinemaka, geza nanamú viselenimikane. ");
INSERT INTO gah_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Láa loko lokago amatoka mina ve lugáate ámina gakó giliake imane vémo Ilaizani sele nolive. ");
INSERT INTO gah_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Liki liake, keikutí makolímo ololu loko vike notunigitana netá aleake akepa lolovaló hizeake vike ekesá vain nagamikú lupizeake, Izesú native loko aminogo noigo, ");
INSERT INTO gah_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","lugáate láa liki lamó: Ánigonozo, Ilaizá oko alémo agutó vizitihe, gizapa onoitune. ");
INSERT INTO gah_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Liki nilago, Izesú nene gakó napagutí nolike sikalahula ahulokago vimó. ");
INSERT INTO gah_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Lá noigo, áminasitó monó zagusaveú Ómasímini avogisaló iteaká gatetó zi lí ika lavolavo nene veletokatí zeko hoú loloko limike ale luga luga imó nene lelí gahe ale koló oletamó. Lá noigo mikasi imimá noike gehani napa napa nene zevo hoú lovo imó. ");
INSERT INTO gah_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Lá noigo, gonosi milimili gale makó nene koló noigo, Ómasímini vegenala zuha lugáa gozapá hilina vegená nene otemó. ");
INSERT INTO gah_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Gonosi milimili ahuli asú iake Izesú nene galegutí otekago viki Zelusale numutoka itikago, mukí vegenalite ánigamó. ");
INSERT INTO gah_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Itó pilisí vetini ve napagi pilisí vegi Izesuniló gizapa iki minake, mikasi nene imimá imó itó haitopaitó netá mukí utó itímo kehelele goha vizekago, imane ve nene lamaná Ómasímini gipala minamó neve liki lamó. ");
INSERT INTO gah_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Itó vená mukí minamó keza nene amunaló Galilaia mikasi ahuliake Izesuni izamuha hiziki ámegetiki viaká a vená nene hotó otigí iki minake ánigi minamó. ");
INSERT INTO gah_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Keikutí Magatala numutotí vená Maliá minamó itó Maliá makó nene Zemusiko Zoseheko keí izóipo, itó vená makó nene Zepetaioni venala minamó. ");
INSERT INTO gah_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Únaká huluvaló henonavagi ve makó Alimataia apatotí ve agulizá Zosehé eza goí oko Izesuni izegipala zuha minamó. ");
INSERT INTO gah_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Eza nene Izesuni gonosiváa alinogo nene voko Pilatoni loká imó. Loká okago, Pilató nene gonosiváa ali amilo loko lokago, gili amemó. ");
INSERT INTO gah_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Gili amikago, Zosehé nene lavolavo gó gosohá mokoná lamanatunú nene asapú imó. ");
INSERT INTO gah_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Lá oake gonosi nene ezáa gonosi milimiliva gosohakú aleko voko molamó. Gonosi milimili nene meikú nego mulí ezáa goló vateikamó nenegú molomiake gehani napa makó nene ahelú ahelú oko aleko vike gonosi gale agepaló nene ze lí imó. ");
INSERT INTO gah_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Lá noigo, vená lositá minasimó, makó nene Magatala numutotí vená Maliá itó Maliá makó minasike gonosi gale ávatiha ánigi minasimó. ");
INSERT INTO gah_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Lá ikasigo, gó lokago holisi gamenamámini nosánetá ale vavá oaká gamena vokago guguni giziaká ve napagi itó Palisaio monó vegi viki Pilatotoka alegesá amó. ");
INSERT INTO gah_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ake láa liki lamó: Ve napale leza gakó ma gelekunike noune. Ámina sozaló ve nene ha agómulagi noike gamena losive makole vokiko neza otinogo uve loko limómámini okatize. ");
INSERT INTO gah_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Nenemú pilisí ve makó kimiselekako, viki gonosi gale agepamaló nene gamena losive makole etoha iki gizapa itave. Izegipala zuhamate gonosiváa gumina iki aliki viiki vegená nene gonosi galegutí mota otekave liki li kimikatanaze. Goí oko soza gakó limó nene alika soza gakó litatímo avilegeikanogo ive. ");
INSERT INTO gah_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Liki likago, Pilató láa loko lo kimimó: Lekeza pilisí ve makoki kilímiki vilo. Ámina gonosi gale agepaló nene lekeza itatímini avotigila iki gehanima zi lí ilo. ");
INSERT INTO gah_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Loko lokago, keza nene vake gonosi gale agepaló zi hita gehani nene alévolé oko minative liki anosa miliki nagá makó alemó. Lá iake lovámini galaváa nene áminaló gizapa itave liki ahulikitamó. ");
INSERT INTO gah_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Holisi gamena asú okago, Sategú neteká ho itinogo noigo, Magatala numutotí vená Maliá itó Maliá makómagi gonosi galema ániganigi vasimó. ");
INSERT INTO gah_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Nivasigo genémané mikasi nene imimá napa imó nene Guivahanímini ageló makó nene okulumakutí lemeake gehani napa nene gonosi gale agepaló zi hitamóma nene ahelú oko alahuloake ámina geható nene ase hizeko noigo imimá napa imó. ");
INSERT INTO gah_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Noigo agoka agepa nene gó melevezakitana oko noigo luhoaká gola nene gizopa nukúnukú loko minamó. ");
INSERT INTO gah_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Lá okago, lovámini gala ve keza nenemú kehelele vizekago luvoluvo ziake hele vegenakitana iki zámuzáini migelelé amó. ");
INSERT INTO gah_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Lá noigo vená lositáma tizikasigo ageló nenémo láa loko lo kimimó: Lekeza lekehelele vizemino. Lekeza zohota zaló apiliki apate ve Izesuni ániganigi niasive loko gelenoumole. ");
INSERT INTO gah_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Eza imanegú noamive. Lá okove gozapá ezáa litó mota otekave. Láa loko lekeza iki ámina ve ako mina apá ánigalizo. ");
INSERT INTO gah_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Lá iiki litá iki viiki izegipala zuhama galegutí nene mota otekave. Goí o lekemeko Galilaia mikasiuka novive. Lekeza viki neneloka aí nene ániganigave liki li kimilizo. Nene lo lekemenoumómámini okove. ");
INSERT INTO gah_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Loko lo kemekago, keza vená losi nene kehelele novizigo itó kogoliza nivizesike hetoka lemesike geha mulikutí litá iki ololu liki vasike aikumú izegipala zuhama li kiminigi vasimó. ");
INSERT INTO gah_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Nivasigo, Izesuki gapoloka galinali hotu liake, eza nene niasihe loko lo kimimó. Loko noligo, keza nene vi alitikasike agisaló alesimó. Lá niasike gupá zi amiki agepoka lasimó. ");
INSERT INTO gah_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Nilasigo, Izesú láa loko lo kimike limó: Lekeza lekehelele vizemino. Lekeza viki nugunáne nene Galilaia mikasiuka viiki keza nene není neneloka ániganigave liki li kimilizo loko nene limó. ");
INSERT INTO gah_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Keza vená losima nene gapo miliki nivasigo, gale agepaló gizapa imina ve lugáamate viake taonigú itemó. Itiake guguni giziaká ve napama nene utó i netakumú avetó iki li kememó. ");
INSERT INTO gah_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Li kimikago, keza guguni giziaká vemagi itó monó ve napamagi ali nupa ake gakó makó ligili hagili ake gakó makó li milamó. Lá ake lovámini galaváama nene age nonó gehani mukí kememó. ");
INSERT INTO gah_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Nikemeke láa liki lamó: Lekeza nene láa likigó lilo: Leza ako helenouko holugú nene izegipala zuhate ake gonosiváa gumina iki aliki vikave likigó nene lilo. ");
INSERT INTO gah_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Itó agulizaki ve napamámo ámina gakoláa gelekoko nolikoma, leza gakó makó lo aminogo une. Lekezaloka gakó makó minaminogo ive. ");
INSERT INTO gah_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Liki likago, keza lovámini gala vemate la gakotó amegesaló milamó. Lá ikago ámina gakoláa nene Zuta vetiniuka hutilí oko vo asú okago, itínasa gamenagi nene ámina gakokó liaká niamole. ");
INSERT INTO gah_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Izegipala zuha 11 leza Galilaia mikasiuka vunike Izesú nene agoka makotoka vitave loko lo limitó nene itekunike, ");
INSERT INTO gah_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Izesuni ánigokunike gupá zeko agepoka lunimóza, makó lugáate nene heleneikutí lamaná oteko áisi noihe liki kagata losi gelemó. ");
INSERT INTO gah_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Lá ikago Izesú nene omo alitoake gakó lo nolimike láa loko limó: Ómasi nenémo okulumalímini mikasímini zámuza nene nenikó neme asú onoimóma neve. ");
INSERT INTO gah_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Nenemú lekeza mikasi nekisa vokisauka viki vegená mukí nene kilími není izegipáne zuha lilí ilo. Lá niiki aménehini agulizató itó gipala není nugulizató itó Sikalahulímini agulizató kilími nupa iki monó nagamí hilikitalo. ");
INSERT INTO gah_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Lá niiki nénisi loleketonou gakotó ámegetatave liki lainim-ikitalo. Gilinahe. Imane mikasímini gamena asú onamiko neza nene lekezagi makó mino-loko voko minanogo uve, loko limó. ");
INSERT INTO gah_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Izesu Kilistó Ómasímini gipalamú gakó lamaná nene lá oko apí imó neve. ");
INSERT INTO gah_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Nenémini gakoláa Ómasímo gipala lo ami gakó nene Ómasímini agepagutí gakó loaká ve Isaiá láa loko luhuva gizamóma neve: Gelezo, není gakó lo keme keme iti ve amiselekugo, áisi ale goí oko voko kigikagú hoza alitanimó nenémini gapoga velegetative. ");
INSERT INTO gah_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Mikasi gomopalaló ámina vémo gakó napagutí láa loko nolive: Guivahanimú nene likigika ali hee litalo. Likigikagú limiti gapo ali hee litalo. ");
INSERT INTO gah_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ámina gakó Zonitoka okago eza mikasi gomopalaló vo anitimó nene vegená makó eza noitoka ali nupa ikago likigika ali viligiiki nenémini mogona utó itive liki monó nagamí hilitamó nene Ómasímo lihimatini ahuloleketative loko lo utó oko lo kemeko minamó. ");
INSERT INTO gah_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Lá okago, Zelusale numutokatí itó Zutaia apá makotokatí nene mukí vegená Zoní noitoka vake lihimáini li utó ikago, Zota nagamikú monó nagamí holoketamó. ");
INSERT INTO gah_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Zoní nene Ómasímini agepagutí gakó loaká ve Ilaizakitana oko kamele iza zopovatunú lilí a gó luhoake, itó iza galupavatunú lilí a holotani nene gohalaló zeake, ganuki himoni nogozagigó noko minamó. ");
INSERT INTO gah_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Noko minake, láa loko lo utó oko lo kemeko minamó: Nemegesaloka noa ve aí zámuza nenémo není zámuza nivilegekave. Nénisi ánéámina aí lelegitó minamunazo, hoza lagasó aletoko aí gasa gó ate akisitomó nene etaminogo ive. ");
INSERT INTO gah_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nénisi nagamikó nohololeketumóza, áisi nene Ómasímini Sikalahú hololeketanogo ive, loko lo kimimó. ");
INSERT INTO gah_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Gamena nene zupa Galilaia mikasigú nene apá makó minamó, agulizá Nasalete. Izesú nenelotí Zoní noitoka anitekago Zota nagamikú monó nagamí holotamó. ");
INSERT INTO gah_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Holomikago, nagamikutí iteake ánigamó nene, okulumá koló okago, Ómasímini Sikalahú nene nama luhusigitana oko Izesuni amupiló nolimigo ánigamó. ");
INSERT INTO gah_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Lá okago okulumakutí Ómasímo gakó makó láa loko limó: Geza nene nigika amenou gipáne noane. Geí ánigo lamaná okuve. ");
INSERT INTO gah_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Loko lokago Sikalahulímo Izesuni amiselekago mikasi gomopalaló vimó. ");
INSERT INTO gah_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Neneloka voko noigo, gamena 40-a oko novigo Satá nene gimivagú moloko minamó. Itó Izesú eza nene hela gaha namatini holúikú noigo ageló keza nasahilí itiki minamó. ");
INSERT INTO gah_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Lá okago, Zonini nene nagá numukú ahulimikago noigo, Izesú nene Galilaia mikasigú vo aniteake Ómasímini gakó lamaná lo utó oko láa loko lo kimimó: ");
INSERT INTO gah_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Gamena mota alitokaze, Ómasímo gizapa oleketati gamena nene omo alitokave. Nenemú likigika ali viligiiki gakó lamaná gili alévolé ilo, loko limó. ");
INSERT INTO gah_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Nominake Galilaia nonohuló agataloka mohona noigo Saimoko agunala Etuluko keza lagaha miliaká asi ve minasinazo, nonohulokú nene lagaha gotaha ahuliki minasimó. Lá niasigo ánigoake Izesú láa loko lo kimimó: ");
INSERT INTO gah_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Némegetiki alizo. Lagaha hoza aliki minasimóma, vegenatoka hoza nalisiko vegená není zuha lilí itave loko lekelémo nomuluve. ");
INSERT INTO gah_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Loko lokago, litá iki lagaha gotahama ahulikasike ámegetiki vasimó. ");
INSERT INTO gah_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Lá ikasigo Izesú koma makó novike Zepetaioni gipala lositá Zemusiko agunala Zoniko keza nagamikú lapegú minasike lagaha gotaha ali lamaná niasigo, ánigoake, ");
INSERT INTO gah_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","sele lo kemekago, gilikasike, améipini Zepetaiogegi gelekelé izegipalagi lapegú niago ahulikimikasike Izesuni ámegetiki vasimó. ");
INSERT INTO gah_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Lá okago, keza Kapanao numutoka viki anitiake holisi gamena alitokago, Izesú nene monó numukú iteko monó lo kimimó. ");
INSERT INTO gah_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Lo kemekago, gilikago, itimó. Monó mogona apí ikimiaká a vete gakó lainim oketamó nenéminoko apí oketamimó. Ezáa monó gakola gale geheko lo kemekago, giliake sigaga sagaga litamó. ");
INSERT INTO gah_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Lá okago, gamena nene zupa monó numukú ve makó minamó nene agika ale gopa i holosi agikagú minamó. ");
INSERT INTO gah_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Eza gamoga geko Nasalete ve Izesuvo, geza nana netá golesa aleletanogo noane. Géisi lelémo golesa itove loko noape. Geí ánigo hee hee noluve. Géisi Ómasilokatí etó oko noani vema noane. ");
INSERT INTO gah_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Loko lokago, Izesú nene gahá amike gegepa apizeoko agikagutí iteko legesó oko vozo. ");
INSERT INTO gah_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Loko lomikago, agika ale gopa i holosi nenémo ale helonalo lomikago, gopaga nolike agikagutí iteko ahulomiake vimó. ");
INSERT INTO gah_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Lá okago ve vená mukí keza ininá ake kezáitoka loká loká ake lamó: Íi, imane nana suni neve. Monó nene haitolímini amuzavagi neve. Áisi gakola gale geheko holosima lokimikago gili amiaká niave. ");
INSERT INTO gah_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Liki likago, aikumú gakoláa likago litá oko Galilaia mikasiuka puu loko vimó. ");
INSERT INTO gah_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Lá okago, monó numukutí limiake, Saimon itó Etulú keí numukú Zemusigegi Zonigegi itemó. ");
INSERT INTO gah_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Saimoni venalámini izolahini agupegú ló la netá avisekago akonoigo, Izesuni litá iki li amemó. ");
INSERT INTO gah_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Li amikago, vo aniteake agizató aleko alémo otekago, agupegú ló la netá nenémo litá oko asú omikago, oteake Izesugini nasahilí oketamó. ");
INSERT INTO gah_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Lá noigo, únaká ho lemekago, mukí kivisi vegenaki kigikagú holosi golesa mina vegenaki Izesutoka kilímiki ikago, ");
INSERT INTO gah_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","apá amelage mukí iki gatetó alegesá amó. ");
INSERT INTO gah_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Lá ikago, haitopaitó netá kivisi vegená mukí kelémo zokoake holosi golesa mukí nene kigikagutí kepeleko kimisilimó. Lá itó nene ánigi hee hee likanazo, aí mogona lili ali amitave loko lo hukoketamó. ");
INSERT INTO gah_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Gó lomolomo gokululuva notovo igo, línumuvamú Izesú eza numukutí lemeake apá makotoka mikasi gomopalaló voko minake Ómasiloka limó. ");
INSERT INTO gah_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Lá noigo Saimon nene agivelagegi keza agizaka hiziki, ");
INSERT INTO gah_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","alími utó iake láa liki li amemó: Vegená mukí geikumú vitagá niaze, geza imaneló nana noane. ");
INSERT INTO gah_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Liki likago, eza láa loko lo kimimó: Apá mukí vaí oko alitoka neve. Neneló monó lo utó itove loko makó vitune. Neza nene ámina hoza alitove loko omo nouve. ");
INSERT INTO gah_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Loko loake vike Galilaia mikasiuka mohona o asú noike, keí monó numuni minakú minakú monó lo utó oko minake, holosi nene kigikagutí kepeleko kimiseleko alahula ahula imó. ");
INSERT INTO gah_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Lá okago, halamé netá gizali ve makolímo aitoka oake negénegeka loko alapusa hizike lo amike limó: Geza nene nelémo gililitove loko nene hanuva nelémo gililitanimó nenazo, nelémo gililitane loko noluve. ");
INSERT INTO gah_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Loko lokago, Izesuni agika hizekago agizani lutoko agupeloka ale nogilike lo amike limó: Gililitane loko gelekuze. Gilelezo. ");
INSERT INTO gah_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Loko lokago, litá oko halamé netáma asú omikago agupe lamaná okago, ");
INSERT INTO gah_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Izesú litá oko namisilike lo hukotake limó: ");
INSERT INTO gah_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Gelenape. Geza imane gakó avetó oko vegená lo kememo. Gilelekane liki gili hee litave loko geza nene voko guguni gizoaká ve gugupe alapizekako mota gilelekane loko ánigative. Itó gilelenikumú nene Mosé loleketa netá Ómasi guguni gizo amitive loko amekako eza vegená mukí lo kemekiko nenémini mogona gili vevesatave. ");
INSERT INTO gah_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Loko lokago, ámina ve nenémo voko avetó avetó oko lole ale imó. Nenemú Izesú nene vegená sii sii liki alegesá ikatave loko taoni makotoka hanuva vamike apá agataloka minokago, vegená keza numutó namatotí gopa aitoka ikigó minamó. ");
INSERT INTO gah_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Gamena makó oko vokago, Izesú nene Kapanao numutoka goha vo anitekago, Izesú nene numukú noive liki gakoláa giliake ");
INSERT INTO gah_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","vauva aliki iki alegesá akumú gatetoki hizi lí amó. Lá okago, monó lo nokimigo, ");
INSERT INTO gah_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","ve losive losive nenete ve gepili makó ukoakoló aliki niago, keitoka vegená makó kémegetiki amó. ");
INSERT INTO gah_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Lá ikago vegená gikí ikago, Izesuni amatoka amitamó okago numupitó itinigi ukoakoló milimiake akaló aliki itemó. Izesuni gotolaló ali koló iake, ve gepili mina ukoakoma nagá ziki ahulikago Izesuni amatoka limimó. ");
INSERT INTO gah_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Lá okago, Izesúma gili alévolé amó nenémini mogona ánigoko geleake ve gepilima láa loko lo amimó: Gipáneve, lihimaka ahulogimikuve. ");
INSERT INTO gah_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Loko lokago, monó mogona apí ikimiaká ve neneló minamoláate láa liki kigikatunú gelemó: ");
INSERT INTO gah_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Íi, Ve makó éaho lihimate ale ahuloletatimó neve. Ómasi hamokó lihima ale ahuloaká noimó nenazo, eza agupe aleko iteko Ómasi aviliginogo nolihe. ");
INSERT INTO gah_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Láa liki kagata nigelego, Izesú nene Zuta vegenalite lihima ahulolimiaká itó vegená kelémo zokoaká nene Ómasímogó loló oaká netá neve liki gelemó nene hanuva agikatunú geleake láa loko lo kimimó: Likigikauka gakó nenémináa nanamú nigeleve. ");
INSERT INTO gah_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ve makolímo Ómasi noamitimó nene lihimaka gilatogimikuve loko vávani oko lamitimóza, ámináminoko kelémo zokoaká zámuzagi ve noamitimó nene oteoko ukoakoka geheko vozo loko litá oko lo ameminogo ive. ");
INSERT INTO gah_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Lá onoimóza, okulumakutí lumu ve gihila neza mikasigú nene lihima gilatoakalímini zámuza itó vegená kelémo zakoakalímini zámuza nenitoka neve liki gili hee hee litave loko ve gepilima lo amike limó: ");
INSERT INTO gah_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Otekoko ukoakoka geheko numukaloka vozo loko nologetuve. ");
INSERT INTO gah_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Loko lokago, galinali kogovisaló ukoakoma geheko vimó. Lá okago, vegená mukí keza sigaga litake Ómasi agepoka láa liki lamó: Nene suni ánigosá amuhá gosohá utó okago ánigokune, liki lamó. ");
INSERT INTO gah_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Izesú lá oake goha lemeake nonohuló agataloka vike vegená mukí aitoka alegesá ikago monó apí o kemeko minamó. ");
INSERT INTO gah_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Nenelotí novike, Alapaioni gipala Livaí nene takisi aleaká numukú noigo, ánigoake némegetoko ano, loko lokago, Livaí nene oteake ámegetoko vimó. ");
INSERT INTO gah_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Vike Livaini numukú itiki minasike nosánetá ninasigo, takisi moni aliaká vegi golesa netá aliaká niave liki kagata giliaká a ve makoláagi mukí keza Izesuni ámegetiki viaká a ve minamó. ");
INSERT INTO gah_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Lá niago, Palisaio monó vegenalitini monó mogona apí ikimiaká ve nenete Izesú nene ámina ánigi goselé iaká vegenaki nosánetá ninago ánigiake nene, izegipala zuha láa liki li kememó: Íi, áisi nene golesa netá aliaká vegená nenémináagi nosánetá nana igo nonave. ");
INSERT INTO gah_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Liki likago, Izesú nene geleake anoza gakó makó láa loko lo kimimó: Keza ha minamoláate lusa vemú sele lisá amave. Kivisi vegenalitegó lusa vemú sele liaká niave. Neza hee loko noune liki liaká nia vegená kelémo otopá zitove loko lememumóma neve. Neza lihimáinigi vegená kelémo otopá zitove loko lumumóma nenae, loko limó. ");
INSERT INTO gah_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Zonini izegipala zuhagi Palisaio monó vegenaki keza Ómasímo nosánetá mosekuko lelikumú litihe liki mosé mosé iaká amó. Lá niago, ve lugáa keza Izesutoka vake láa liki loká itamó: Zonini izegipala zuhagi Palisaio monó vegenalitini izegipáini zuhagi keza nosánetá mosé mosé iaká niamóza, geí izegipaka zuha keza mosisá amave. Nanamú neve. ");
INSERT INTO gah_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Liki likago, Izesú anoza gakó láa loko lo kimimó: Ve makolímo agivelagegi makó kogoliza viziki minata zupa nene keza aikumú miluma giliiki nosánetá mositamó nehe. Lá oko nomive. Ámina vegi apiziki minata zupa nene nosánetá moseminigave. ");
INSERT INTO gah_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ámina vema apili hilita zupa alitokiko, nene zupa miluma nigiliki nosánetá mosinigave. Áminámini iki, izegipáne zuhate alika nenikumú miluma giliki mosí mosí inigave. Itína nene moseminigave. ");
INSERT INTO gah_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Itó lavolavo gó gosohá gí zenamimó nene huki koma iiki ali litaha lavolavoló miliki akotisá amave. Alika nagamí zikiko gikí okiko nene gosohá gó komamámo litaha lavolavomalotí hikelekiko lavolavoma golesa o asú inogo ive. ");
INSERT INTO gah_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Itó vain nagamí gosohá gituhú galakalá noigo nene litaha getununigú milisá amave. Vain nagamímámo giputooko getununima zeko pulutokiko vain nagamíma hutilí okatize, itó getununima ámina oko golesa okatize. Vain nagamí gituhú galakalá noimó nene litaha getununigú negopa gosohámagukó miliaká niave. Loko anoza gakó limó nene Zuta vetini litaha mogonáagi Izesuni izegipala zuhate gosohá iki miliki ita sunigi molo apizeakaláa nomive loko limó. ");
INSERT INTO gah_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Holisi gamena makokú Izesuni izegipala zuhagi kilé mikú mihina niago, izegipala zuhate gaúna hilikago kilé asutiake gihiláa hisiki nimi vamó. ");
INSERT INTO gah_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Lá niago, Palisaio monó vegenalite gili golesa ake Izesuni li amiki lamó: Ánigozo, netá nalemó nenémo golesa okave. Lelí holisigú imane hoza lá amoakalímini nene nanamú naleve. ");
INSERT INTO gah_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Liki likago, eza monolímini li hukina gakó nenémo vegená kelémo vatí iti gapo nene hize lí itive loko utó amive liki gilitave loko láa loko lo kimimó: Gozapá agulizaki ve Tevitige vegenala zuhagi nosánetakumú gaúna hiliake netá alemó nene monokú luhuva gizinamóza lekeza ámina gakó gatiake mogonáa gelemiki nilahe. ");
INSERT INTO gah_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Tevití eza Ómasímini numukú itekago guguni gizoaká ve napa Apiatalá nene Ómasímini avogisaló mila peleti amekago noake ezagi makó mina vegená nene kemeko namó. Ámina peleti nene hanuva vegenalite namitave liki guguni giziaká vetegó natave liki alévolé iki li hukinamó nene gopa namó neve. ");
INSERT INTO gah_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Loko loake, miní ameko láa loko lo kimimó: Holisi gamenamule loko Ómasímo vegená loló amimóza, holisi gamena nene vegenakumule loko utó onoimó neve. ");
INSERT INTO gah_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Lá onoinazo, okulumakutí lumu ve gihila neza holisi amelahina nounazo, izegipáne zuhate holisi gamenagú lilí ita netá nene není netá neve, loko limó. ");
INSERT INTO gah_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Minoko monó numukú nene agizani nakeseta ve makó iteko noigo, Izesú áminagú goha itekago, ");
INSERT INTO gah_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","holisimagú nenazo, ámina ve imane holisimagú hoza aleko alémo zokokikoma goní otatunize liake gizapa iki minamó. ");
INSERT INTO gah_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Lá niago, Izesú nene agizani nakeseta vema láa loko lo amimó: Holutegú ote minozo. ");
INSERT INTO gah_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Loko loake vegená láa loko loká oketamó: Holisigú nene netá lamaná alesatímo etatihe netá golesa alesatímo etative. Vegená kelémo lamaná osatímohe kepele helesatímove. ");
INSERT INTO gah_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Loko limóza, anotó alemake niago, izapaló molago gonú nokipilike gili ámegekumú miluma geleake, agizani nakeseta vema gigizani lutozo loko lokago, agizani lutokago goha lamaná imó. ");
INSERT INTO gah_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Lá okago, Palisaio monó vegená keza limiki vake nana oko apele hilitune liki kezagi Heloteni patigú vegenaki litá iki lova gizamó. ");
INSERT INTO gah_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Lá okago, Izesú eza izegipala zuha kelémoko nonohulotó lemekago, vegená mukí Galilaia mikasilotí kémegetiki vamó. Itó kéisigó vamamó. ");
INSERT INTO gah_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Zelusalegatí itó Zutaia apakú numuni apá makotokatí itó Itumaio mikasilotí itó Zota nagamí vola helegalotí itó Tulo numutokatí Sitona numutokatí vegená keza iki Izesú oko moloko imó nenémini gakoláa giliake vaí iki aitoka alegesá amó. ");
INSERT INTO gah_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Lá ikago, Izesú alegesá iki mina vegená aitoka mununú ikatave loko izegipala zuhate nagamikú lape makó aliiki nagamí getatoka milikiko nenegú iteko minoko gakó lo kimitove loko loketamó. ");
INSERT INTO gah_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Vegená mukí kelémo zokamómave liki netá golesa gizale vegenalite agupeló ale gilitunitímo lelémo zokative liki aitoka iki mulusi milakumule loko lapemú limó. ");
INSERT INTO gah_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Lá okago, holosi golesa kigikagú mina vegenalite ániga zupa kigihúna giki gamoga giki géisi Ómasímini gipalama noane liki liaká amó. ");
INSERT INTO gah_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Láa liki likago aí mogona avetó iki lili ali amitave loko alévolé oko lo hukoketamó. ");
INSERT INTO gah_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Izesú nene zopegaló iteake agikatunú gili vegená sele lo kemekago aitoka viki alegesá amó. ");
INSERT INTO gah_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Lá ikago, ve 12-a ezagi minatave loko itó kimiselekiko monó gakó li kimitave loko ");
INSERT INTO gah_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","itó zámuza kemekiko kigikagú holosi minatamó kipiliki kimisilitave loko kelémo etó oake kugulizá nene aposolo vemave loko molamó. ");
INSERT INTO gah_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ve 12-a nene lá iki minamó: Kugulizá Saimon, agulizá gosohá Pitani molamó, ");
INSERT INTO gah_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","itó Zepetaioni gipala Zemusí itó agunala Zoní, keza nene kugulizá Poanelekesi loko molamó, lelí gakokutí nene gó hegeaká ve. ");
INSERT INTO gah_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Itó Etulú itó Pilipó itó Patolomaió itó Mataió itó Tomasí itó Alapaioni gipala Zemusí itó Tataió itó Saimoná eza Loma vemú giligo ahulanogo i ve, ");
INSERT INTO gah_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","itó Kaliotó numutotí ve Zutá eza minomo iteko Izesuni amimika limó. ");
INSERT INTO gah_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Izesú nene aí numutoka vimó. Vo anitekago vegená vaí iki alegesá akumú nosánetá namamó. ");
INSERT INTO gah_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Lá ikago, Izesuni vegenala zuhate áisi negi hizekave liki la gakó giliake, agizató alitune liki vamó. ");
INSERT INTO gah_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Lá ikago, monó mogona apí ikimiaká ve Zelusalegatí a ve keza Izesunimú láa liki lamó: Holosi golesa makó agulizá Pelezepuló nene agikagú noive, itó holositini agulizaki vémo alémo vatí igo holosi nene kepeleko kimiseleaká noive. ");
INSERT INTO gah_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Láa liki nila gakó Izesú nene geleake sele lo kemeake Satani zámuza mota avilegeneikumú anoza gakó makó láa loko lo kimimó: Íi, Satá ezáa izegipala zuha kepeleko kimisilitihe. ");
INSERT INTO gah_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Mikasi makokú vegená hizi hoú latamó nene, alévolé iki minamiko ámina apatoka gámekokó pizinogo ive. ");
INSERT INTO gah_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Itó hamó zuha nenete hizi hoú latamó nene, ámina vegená alévolé iki minaminigave. ");
INSERT INTO gah_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Lá onoinazo, Satá nene ezáa vegenala zuhagi hizi hoú latamó nene, voko alévolé oko minamitimó nenazo, tolova inogo ive. ");
INSERT INTO gah_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Itó ve makolímo gasovagi ve amuza vémini numukú litá oko iteko aí henoni mukí ipá oko aleakaláa nomive. Goí oko ámina vémini agisa agizató nagá aleoko alika nene iteko alitimó neve. Lá oko nagá aleoko alika iteko henoniva ipá inogo ive loko limó nene Satani agizató nagá aleuke holosiva nene kepeleko kimiseleaká nouve loko anoza gakokutí limó. ");
INSERT INTO gah_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Loko loake, makó láa loko limó: Neza lamaná lo likimitoze, gililo. Netá golesa haitopaitó nenémini lihima itó alivi letivi iaká nenémini lihimavaláa nene Ómasímo hanuva ahuloaká gapo nemóza, ");
INSERT INTO gah_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","ve makolímo Ómasímini Sikalahukumú alevo letovo oakaláa nene Ómasímo nenémini lihimáa apasoakaláa nomive. Ámina lihima ámina vémini amupiló mino lúaló moloko minanogo ive. ");
INSERT INTO gah_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Loko limó nene Ómasímini Sikalahulímini zámuzatunú negopa, holosi makolímo Izesuni agikagú lemeko alémo vatí igo holosi nene kepeleko kimiseleaká noive liki lakumú nene láa loko Izesú lo kimimó. ");
INSERT INTO gah_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Izesuni izolage izegipa agunamotamolagi anitiake numuni hetoka aikumú sele lamó. ");
INSERT INTO gah_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Sele nilago, alími vego iake mina vegenalite láa liki li amemó: Gelenape, izokage izegipa gugunamotamoka keza hetoka emane niake geikumú sele nilave. ");
INSERT INTO gah_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Liki likago, Izesú láa loko lo kimimó: Izónegini nugunamotamónemú nilahe. ");
INSERT INTO gah_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Loko loake, aitoka mina vegená nene gonú nokipilike láa loko limó: Ánigalo. Izónege izegipa nugunamotamóne imane niamole. ");
INSERT INTO gah_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ómasímo li gakotó gili amiaká nia vegená kéisi nene izónege nugunamotamóne niave, loko limó. ");
INSERT INTO gah_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Izesú goha nonohuló agataloka monó lo nokimigo, aitoka vegená mukí keza sii sii liki alegesá ikago vegená gikí akumule loko nagamikú lapegú iteko minokago, lape nene nagamikú minokago, vegená alegesá amó mukí keza getatoka minamó. ");
INSERT INTO gah_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Minikago, Izesú anoza gakó haitopaitolímini lo nokimike makó láa loko lo kimimó: ");
INSERT INTO gah_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Gililo. Zuha netá atilí oaká ve makolímo netá gihila atilí inogo vimó. ");
INSERT INTO gah_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Mikuka atilí omo novigo, gihila makó gapoló alemó zekago, gaha namate ake ni asú amó. ");
INSERT INTO gah_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Makó nene gehani amupiló mikasi lagasó netó lemekago mikasi hána nomimó nenazo, goloakaláa litá oko golokaha, ");
INSERT INTO gah_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","ho nolake avagugu vizekago, luhusa hána minamike osagava vizimó. ");
INSERT INTO gah_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Makó nene lilihámini luhusa nene mikasigú ha netó alemó zike golokago, liliha nenémo goloko iteake zemikago gihila zemimó. ");
INSERT INTO gah_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Makó nene mikasi lamanakú lemeko minake goloko iteko gihila zimó. Zava makó nenémo gihila 30 zimó, makó nenémo gihila 60 zimó, makó nenémo gihila 100 zimó. ");
INSERT INTO gah_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Lakagatagi minatamó neneta imane gakó gili hee liki gililo, loko limó. ");
INSERT INTO gah_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Vegená lugáa vi asú ikago, aitoka mina vegenaki izegipala zuha 12-a kezagó minake ámina anoza gakokumú loká imikago, ");
INSERT INTO gah_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","láa loko lo kimimó: Ómasímini gasovaló minoakalímini asuguná gakó lekeza gilitave loko lonoimóza, hetó niamoláa keza anoza gakokukó gilitave loko loaká nouve. ");
INSERT INTO gah_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Nenemú Ómasímini agepagutí gakó loaká i ve Isaiá gakó makó láa loko luhuva gizonoimó nene keitoka alévolé oko neve: Kogómulatunú ánigiakaláa ha ánigatamóza, ma ánigi vevesaminigave. Itó kagatatunú giliakaláa nene ha gilitamóza, gili vevesaminigave. Kigika ali viligamikoma, lihimáini ahuloketamigo, ha minanogo ive. ");
INSERT INTO gah_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Izesú miní ameko láa loko lo kimimó: Imane anoza gakó lumó nenémini mogonáa gelemahe. Lá noikoma, anoza gakó mukí nene nana iki gili vevesatave. ");
INSERT INTO gah_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Netá gihila atilí oaká vémo monó nene atilí oaká noive. ");
INSERT INTO gah_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Zuha netá makó atilí noigo gapoló alemó zimó nenémini iki minatamó keza monó gilitamóza, Satá litá oko aniteko monó nene kigikagú milikago minamó nene aleko vokago kigikagú minamimó. ");
INSERT INTO gah_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Itó zuha netá gehani hizenei mikasiló limimó nenémini iki minatamó keza monó nigiliki litá iki laga kivisekago giliaká niamóza, ");
INSERT INTO gah_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","kigikagú luhusa ale gikitamigo gamena alínipa aliniko monó gakó alinakumú gopogu galatakalatá milikitata gamenaló nene litá oko akatimó neve. ");
INSERT INTO gah_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Itó lilihagú limimó nenéminiki minatamó keza monó giliaká niamóza, ");
INSERT INTO gah_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","imane mikasiuka gena kepeleaká noi netá itó monimú lagava giliaká nia netalímo itó netá haitopaitokumú kumu heleaká noi netá nenémo kigikagú minoake, monó zemikago keitoka gihila utó osá amive. ");
INSERT INTO gah_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Itó mikasi lamanakú limimó nenéminiki minatamó nenete monó giliki alinago, keitoka gihila zeaká noive. Makolititoka napa otigí zeaká noive, makolititoka mukí zeaká noive, makolititoka vauva aleko zeaká noive. ");
INSERT INTO gah_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Loko loake anoza gakó makó miní ameko láa loko lo kimimó: Ve makolímo liví lege molokoko holoma sepekú ahe somotunú gahumá oakaláa nomive. Eza liví moloaká holomaló molokago, hize hanatanogo ive. ");
INSERT INTO gah_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ámináminoko Ómasímini asuguná ne netá mino-loko vo tolova amitive. Minoko utó o asú inogo ive. Halá genei netá ámina oko hanato asú inogo ive. ");
INSERT INTO gah_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Lakagatagi minatamó neneta gakó imane gili hee liki gililo. ");
INSERT INTO gah_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Loko loake láa loko limó: Lekeza gakó imane nigiliki gili guni iki gililo. Lekeza gakó gilita polosava nene Ómasímo áminagó oko nene monó lehizeleketanogo ive. Itó nenegó nomive. Aleko iteko likiminogo ive. ");
INSERT INTO gah_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Makó keza monó nene vatí iki gizapa iki ali minatamó nene Ómasímo goha miní ameko kiminogo ive. Itó makó keza monó nene lamaná iki gizapa amitamó nene monó alenoupe gilitamóza, goha ipá oko alekiko nene hanuva minatamó neve. ");
INSERT INTO gah_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Izesú gakó makó láa loko limó: Ómasímini monolímo likigikagú gihila ale utó itimómámini mogonáa lá oko neve: Ve makolímo mikú zuha netá mikasigú atilí oake, noike, ");
INSERT INTO gah_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","gó lana gó lana nominago nenémini mogonáa ánigo hee lamigo, zuha netáma goloko iteko napa noigo, ");
INSERT INTO gah_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","mikasímo ezáa lulu vizeake goloaká noive. Apí oko hosi oake goloko itike agila oake, gihila zeaká noive. ");
INSERT INTO gah_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Gihila zeake zuha lokago, aleko natuni gamena alitokave loake, hukatave loko kimiselekago minumuni aliaká niave. ");
INSERT INTO gah_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Gakó miní ameko láa loko limó: Ómasímini avogisaló vi hilata vegená hizi hutilí itakumú nene nanetalímini amupiló ale moloko litove. Nenemú litove loko nene nana gakotó anoza ale moloko litove. ");
INSERT INTO gah_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Masteti loko nei zuha netá nenéminoko neve. Ámina netá nene mikasigú atilí inigi niago, mikasiuka gihila lugáagutí ezáa koma koma nemóza, ");
INSERT INTO gah_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","atilí ikago, goloko iteko iteko napa oake, zamú mukí kivilegeko izana napagi itekago, nama nenete samapalagú numuni giaká niave. ");
INSERT INTO gah_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Izesú anoza gakó haitopaitó mukí hamolíminoko monó lo kemeko minamó nene gilita polosava lo kimimó. ");
INSERT INTO gah_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Gakó lo kiminogo noike anoza gakokutikó lo kemeake, lo utó oko lo kememike ezagi izegipala zuhagi kezáikó minake nene, gakó mogonáa mukí lo utó oko lo kimimó. ");
INSERT INTO gah_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ámina gamenalokó únaká gamena gánavaló nene Izesú eza izegipala zuhama vola helegaloka mota vitune, ");
INSERT INTO gah_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","loko loake alegesá iki mina vegená ahulokimiake sipigú iteko noigo, keza alímiki nivago, vegená makolite nagamikú lape makokú kémegetiki vamó. ");
INSERT INTO gah_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Nivago una napa alekago, nagamí nene valahuká zitímo lapegú lemeko vaí inogo noigo Izesú nene lape asevaló akonoike, gotolaló za moloko akonoigo, ");
INSERT INTO gah_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","izegipala zuhate alími otiake láa liki li amemó: Monó gizapa velemaka, nagamikú simá nanogo nounize, geza nanamú lelikumú gele lememanike hanuva noane. ");
INSERT INTO gah_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Liki likago, Izesú oteake unama gahá amekake nagamí nonohuló nene valahuká zemoko legesó oko minozo loko lokago, una nene ha okago nagamí nene kii nolike zou limó. ");
INSERT INTO gah_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Lá okago, izegipala zuha láa loko lo kimimó: Nanamú lekelegesá ligive. Nenikumú velesá gili alévolé amahe. ");
INSERT INTO gah_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Loko lokago, kehelele goha vizigo kezáini ligili hagili ake láa liki lamó: Agae, imane ve nene haitolímini neve. Unagi nonohuloki nenetosa gakola gili alikasive, liki lamó. ");
INSERT INTO gah_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Nonohuló vola helegaloka viake, Gelasa vegenalitini mikasiuka anitemó. ");
INSERT INTO gah_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Neneló agikagú holosi golesa mina ve makó minamó. ");
INSERT INTO gah_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ámina ve nenémo geha mulikú akoaká noigo, ve makolite agizató alisá ikago seni nagatunuki alemó nene alemimó. ");
INSERT INTO gah_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Gamena gamena agisa agizató etoha iki seni nagatunú aliaká amóza, agizató nagá nene zeko halí oake, agisaló nagá alemó nene zeko hukokago, ve makolímo amuza moloko alémo zou lamitimó imó. ");
INSERT INTO gah_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Gamena gamena únaká neteká mulikuki agokaloki minake nene, gopaga loko minake nene, gehanitunú agupeva gesopá zeko minoaká imó. ");
INSERT INTO gah_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ámina ve nenémo Izesú nene sipigutí nolimigo geha mulikú gonosi apakú minakutí ake hototí Izesuni ánigoake ololu loko oko Izesuni agisauka gupá ze amike ");
INSERT INTO gah_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","gamoga geko láa loko limó: Izesuvo, Ómasi napámini gipalamaka, géisi nana netá golesa loló onetanogo noane. Loko lokago, Izesú nene holosi golesa neneka, ámina vémini agikagutí iteko vamane loko lomikago, holosi nenémo amanapa ike neza Ómasímini agulizá noluze, miluma hoza nememo. ");
INSERT INTO gah_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Loko lokago Izesú nene loká otake gugulizaka éagave. Loko loká omikago eza limó: Leza mukí nouninazo, lugulizá nene ami mulusi nouve. ");
INSERT INTO gah_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Loko loake ámina mikasilotí limiselemitane loko negénegeka limó. ");
INSERT INTO gah_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Loko lokago, iza gululusi mukí zopegaló gale niki niago, ");
INSERT INTO gah_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","holosite negénegeka lake izatini kigikagú limiselekako limitune. ");
INSERT INTO gah_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Liki likago, gele kemekago, holosi golesa nenete agikagutí itiake iza gululusi tu tausen nenetini kigikagú itiake limikago, olíi miliake meiniló limiake nonohulokú limiki nagamí niki hutiake hiligesá amó. ");
INSERT INTO gah_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Hilikago, iza gizapa vete golisi viake taoni napaloka iza gihiló numutokagi avetó iki li kimikago, vegená keza utó i netá ániganigi viake, ");
INSERT INTO gah_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Izesutoka anitiake holosi agikagutí kimiselekago va ve nene ginegane ale luhoake geleakala lamaná okago, mitó noigo, ánigiake kelegesá ligimó. ");
INSERT INTO gah_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Lá niago, nene suni ániga vete holosi golesagi mina ve lamaná imó itó iza helemó nenémini gakoláa avetó iki li kimikago, ");
INSERT INTO gah_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","mikasinini ahulokoko vitive liki Izesuni negénegeka lamó. ");
INSERT INTO gah_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Likago, Izesú eza sipigú noitigo, holosi agikagutí kimiselekago va ve nenémo Izesuki makó minatíive loko negénegeka lokago, ");
INSERT INTO gah_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Izesú gele amemike láa loko lo amimó: Numukaloka voko Guivahanímo geikumú agika hizekago loló ogeta netá lamanalímini gakola nene vegenaka zuha avetó oko lo kemezo. ");
INSERT INTO gah_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Loko lokago, Tekapoli mikasiloka atiginá oko vike Izesú loló ota netakumú lo utó oko lo kimigo, ve vená mukilite Izesuni sigaga litiki minamó. ");
INSERT INTO gah_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Lá ikago, Izesuge sipigú itiake ima helegaloka goha iake, getató limiki niago, vegená vaí iki aitoka alegesá amó. ");
INSERT INTO gah_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Lá ikago, monó numukú agulizaki ve makó Zailó loko noi vémo oko ");
INSERT INTO gah_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Izesuni ánigoake, gupá ze amike negénegeka like limó: Není mohó komámini ameni nomigo, mota hilinogo noize, zokoko agómulagi minative loko, oko gigizanitunú ale geleko nónohá zetatane loko noluve. ");
INSERT INTO gah_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Loko lo amekago, geleake, makó nivasigo, vegená alegesá amó vaí iki ámegetiki nivake, aitoka sii sii liki nivakú nene ");
INSERT INTO gah_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","vogaláikú vená makó nene ikanímo avutá apelekago númase gapo kilisimasi 12 oko novigo molova molova oko noi vená minamó. ");
INSERT INTO gah_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Lusa ve mukilite miluma netá mukí amikago moni keme asú imóza, avisi netáma asú otamike alika sipisi netá gizaleko minamó. ");
INSERT INTO gah_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Eza nene Izesuni gakoláa geleake vegená alegesá amó nivakú nene Izesuni amegesaloka oake, ");
INSERT INTO gah_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","agupeló ahe itó hanuva luhoaká golaló ale gelekinake zokatove loko agata geleake luhoaká golaló ale gilimó. ");
INSERT INTO gah_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ale nogilike, litá oko sepá zekago, nivisi netá asú onimikave loko agupegú gilimó. ");
INSERT INTO gah_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Gelekago, Izesú nene zámuzala agikagutí vokago geleake, vegená alegesá akutí viligoko láa loko limó: Není luhoaká gotó éaho ale gilive. ");
INSERT INTO gah_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Loko lokago, aí izegipala zuhate láa liki li amemó: Vegená alegesá ikima sii sii likima nianazo, nugupeló éaho ale nogilive loko nolape. ");
INSERT INTO gah_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Liki likago, éaho alihe loko ániganogo ánigomo mohona imóza, ");
INSERT INTO gah_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","vená nenémo Izesú loló ota netakumú geleake ahelele novizigo, luvoluvo nozike ake, agihúna geko lo utó oko lo ame asú imó. ");
INSERT INTO gah_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Lo utó oko lo amekago, eza láa loko lo amimó: Mohónemaka, nenikumú gele alévolé anitímo gelémo zokokave. Mulukagú hulu iko vozo. Givisi netakutí zokoko minozo. ");
INSERT INTO gah_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Loko noligo, monó numukú agulizaki vemámini numukutí vegená makó iake láa liki li amemó: Mohokama mota helekave. Nenemú tisaka nanamú goha negénegeka nolotane. ");
INSERT INTO gah_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Liki gakó lamóza, Izesú nene gele ahuloake, monó numukú agulizaki vema láa loko lo amimó: Geza gehelele vizemino. Gele alévolé okogó minozo. ");
INSERT INTO gah_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Loko loake, vegená makó ámegetiki vamitave loko lo hukoko lokago, Pitaki Zemusiki agunala Zoniki kezagó kelémoko vimó. ");
INSERT INTO gah_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Viki monó numukú agulizaki vemámini numukú anitiki ánigamó nene, gakó napa napa liki ive nama iki hitagá hiziki niago ánigamó. ");
INSERT INTO gah_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ánigoake Izesú nene numukú iteake ve venáma láa loko lo kimimó: Lekeza nanamú gakó akó napa napa liki ive nama niave. Mohóma nene helemive. Hanuva avó akonoive. ");
INSERT INTO gah_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Loko alémo otitove loko gelenei gakó noligo, giza napa itamóza, vegená mukí kehelú ike kimiselekago, hetoka limikago, mohómámini izolahiko amelahiko izegipala zuha losive makolemagi kelémoko mohóma akonoitó itimó. ");
INSERT INTO gah_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Iteake agizató nalike aí gakokutí láa loko lo amimó: Talita kumi. Nenémini mogonáa lelí gakokutí nene mohó koma otitane loko noluve loko neve. ");
INSERT INTO gah_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Loko lokago, mohó nenémo litá oko oteake mohona oko minamó. Aí kilisimasi 12-a minamó. Itó vegená keza ánigiake litá iki sigaga goha lamó. ");
INSERT INTO gah_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Lá niago imane netakumú vegenalite gilikataze, avetó iki li kememilo loko lo hukoketake nene, ámina mohó nene nosánetá amilo loko lo kimigo nosánetá aliake amemó. ");
INSERT INTO gah_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Izesú nene apá ahuloake, ezáa gotó apalaloka vo anitekago, izegipala zuha keza ámegetiki vamó. ");
INSERT INTO gah_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Lá ikago holisi gamena alitokago, monó numukú monó lo keme keme oko noigo, vegená mukilite giliake sigaga sagaga litake láa liki lamó: Imane vémo nene gakó hikutí alive. Gele vevesoakaláa éaho amive. Imane ve nenémo imane alévolé suni nene hikutí ale utó oaká noive. ");
INSERT INTO gah_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Leza aí mogonáa gelenoune. Aísi numuni geaká ve nene Maliani gipala noinae. Itó Zemusí Zosé Zutá Saimonige keí uvóipoma noinae. Mohó agunala kezagi imaneló miniki aliki iaká nianazo, áisi nene hanuva lelikitana ve noive. Liki liake gelego, gena okago, aliki limiki likago, ");
INSERT INTO gah_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Izesú láa loko lo kimimó: Ómasímini agepagutí gakó loaká vémini agulizá nene numutó namató puu loko vitimóza, ezáa gotó apatokagi ezáa vegenala zuhalokagi ezáa numunakagi aí agulizá minamitimó neve. ");
INSERT INTO gah_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Loko loake áisi neneló Ómasímini zámuza ale utó itove loko imóza, gena avisekago ahuloake, kivisi vegená lugáa agizanitunú ale geleko nónohá zeketake kelémo zokamó. ");
INSERT INTO gah_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Lá oake, aikumú gili alévolé amakumú giligo gena imó. Lá okago, Izesú nene numutó numutó mohona oko monó lo keme keme oko minamó. ");
INSERT INTO gah_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Lá oake, minomo noitike, izegipala zuha 12 nene kelémo nupa oake, mihina iki holosi golesa vegenalitini kigikagutí kipiliki kimisilitave loko zámuza nokimike, losi losi oko nokimisilike láa loko loketamó: ");
INSERT INTO gah_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Gapo vitatoka nene netá makó alemiki hánusagó aliki vilo. Itó peleti alemiki akiseaká gó alemiki gó komagú nene moni gúemiki, ");
INSERT INTO gah_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","likigisaló suú luhiki nene luhiaká gó lositá luhamiki vilo. ");
INSERT INTO gah_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Loko loake láa loko lo kimimó: Itita numuni makokú itiikima ámina numukú aki-liki niviki ámina apatotí vitave. ");
INSERT INTO gah_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Itó apá makotoka likilími lamaná amikoma itó lekelí gakó gelemikoma nene, ámina apá nahuliki vahé miliki likigisalotí mumusopa nene usagamá zi ahuliki vilo. ");
INSERT INTO gah_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Loko lokago, vake vegená keza kigika ali viligatave liki li utó iki li kimiake, ");
INSERT INTO gah_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","holosi mukí kigikagutí kipiliki kimisiliki itó kivisi vegená mukí nene netupa hilikimiake kilími zokimi vamó. ");
INSERT INTO gah_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Lá ikago gakoláa hutilí oko vike agulizaki ve napa Heloteni agataló vo holokago gilimó. Ámina gamenaló nene vegená makolite Izesukumú nene Zoní monó nagamí holokimiaká vema heleneikutí oteake imane zámuza nene netá haitolímini ale utó oaká noive. ");
INSERT INTO gah_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Liki nilago lugáa keza Izesukumú nene Ómasímini agepagutí loaká ve Ilaizá goha okulumakutí lemeake noive liki nilago, lugáa nenete gozapá Ómasímini agepagutí gakó liaká a ve makokitana oko noive liki liaká amóza, ");
INSERT INTO gah_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Heloté nene geleake Zoní eza luvana hukotu vemámo galegutí oteake ámina netá loló oaká noive loko limó. ");
INSERT INTO gah_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Nene hanuvamú lamive. Heloté nene amunaloka emane uvolaho Piliponi venala Helotiasini nene ipá oko alimó. Lá okago, Zoní nene Heloteni lo ame ame oloko vike uvokahini vená ipá oko alenimó etamive. Loko lokago, venalámo gala vizekago Heloté nene ve makó kimiselekago vake Zonini agizató aliake nagá numukú ahulitamó. ");
INSERT INTO gah_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","20","Lá ikago, Helotiasí nene Zonikumú izapaló molokago apele hilinogo gilimóza, Zoní nene lihimavala nomi ve minake monolagi ve minokago, Heloté nene apilitomó nene Ómasímo nana onetatihe loko ahelele vizekago Zonini gizapa lamaná otatonazo lokago Helotiasí nene Zonini apelemitimó imó. Heloté nene Zonini gakó gamena gamena geleake agata losi goha gilimóza, Zoní li gakokumú geleake laga avisimó. ");
INSERT INTO gah_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Minake Heloteni nene geta gamena alitokago, mukí kugulizaki vegi lova gizapa vegi Galilaia mikasiuka vegená iti minamómagi kelémo nupa oake nosánetá vatá okimikago, niki niago, Helotiasí nene Zonini apiliti gamena ale utó imó. ");
INSERT INTO gah_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Heloteki nosánetá niki niago, Helotiasini moholama iteake kovogisaló melekeni okago, keza ánigi kumu hiliake agulizaki ve napa nenémo mohóma láa loko lo amimó: Geza netá nemú manamú nogilitanimó nene lokako gimitove. ");
INSERT INTO gah_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Loko loake, Ómasímini avogisaló lo hutoko limó: Nana nana netakumú loká onetatane. Ha giminogo uve. Gizapa nou mikasimuki loká onetatanimó nene hanuva hutoko giminogo uve. ");
INSERT INTO gah_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Loko lokago, mohó nenémo hetoka lemeake izolahini nene gizapa vemámo láa loko lokanazo, nana netakumú loká otatove. Loko lokago, izolaho láa loko lo amimó: Mota helekave gilitokive loko monó nagamí holokimiaká ve Zonini luvana hutoko gotoláa nimitane loko lamane. ");
INSERT INTO gah_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Loko lokago, mohómámo litá oko agulizaki ve napa noitoka goha iteake láa loko loká otamó: Monó nagamí holokimiaká ve Zonini gotola itínasa gitegeko lapegú molokoko nimitane loko noluve. ");
INSERT INTO gah_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Loko lokago, agulizaki ve napa nenémo giligo gena imóza, Ómasímini avogisaló lo hukokumóma nenazo itó alesa molokago iki mina vegenalitini kovogisaló lo hukokunazo loko geleake, ");
INSERT INTO gah_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","litá oko pilisi ve makó amisilike Zonini gotola gitegeko alekative loko lomikago, vike nagá numukú nene Zonini luvana hutoake gotola gitegeko ");
INSERT INTO gah_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","lapegú moloake aleake mohóma amekago, mohó nenémo izolaho noitoka aleko voko amimó. ");
INSERT INTO gah_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Lá okago, Zonini izegipala zuhate ámina gakoláa giliake viki gonosiváa aliki vake geha mulikú gale zemó. ");
INSERT INTO gah_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Aposolo zuha nene losi losi iki mihina i asú iake, atiginá iki ake Izesú noitoka ali nupa ake netá iki miliki ake monó li kemekumú nene avetó iki li ami asú ikago, ");
INSERT INTO gah_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","vegená mukí vigá igá niago, nosánetá nata gamenagi nominazo, Izesú nene lezategó vegená niamató voko lavasú vizeko minatune. ");
INSERT INTO gah_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Loko lokago kezáikó nagamikú lapegú itiake vake vegená niamató vamó. ");
INSERT INTO gah_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Nivago vegená mukí keza ánigiake ánigi vevesiake, taoni mukikutí nene mikasigú ololu liki vake goí ikitiki neneló vi anitemó. ");
INSERT INTO gah_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Vi anitiake vegená vaí iki alegesá iki minikago, Izesú nene sipigutí olío lemeko ánigamó nene sipsip iza gizapa venini nomimó nenéminiki minikago ánigoake, keikumú agika hizekago gakó mukí lo keme keme oko minamó. ");
INSERT INTO gah_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Lá niago, ho lemekago, izegipala zuhate aitoka ake láa liki lamó: Imane apá nene ha gámetó nouko gamena mota asú okaze, ");
INSERT INTO gah_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","viki iza gihiló numutokagi luhuva numutokagi mihina iki nosánetáini meina hizitave loko kimiselezo. ");
INSERT INTO gah_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Liki likago, konotó aleko lekezatini nosánetá kimiki nalo. Loko lokago, izegipala zuhate láa liki lamó: Íi, moni gó lositatunú peleti meina hizekoko kemesá nenegi vo aleminogo ive. ");
INSERT INTO gah_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Liki likago, eza loká oketake limó: Lekezaloka peleti nanakí neve. Viki ánigalo. Loko lokago, viki ánigiake láa liki lamó: Ligizani helegaloka asú igo neve, itó lagaha lositá neve. ");
INSERT INTO gah_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Liki likago, mukí vegená nene hizi letiká hizi letiká iki gihisi gosoható minatave loko lokimikago, ");
INSERT INTO gah_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","hizi letiki tivamoláa nene 100 nenéminiki itó amunaloka miniliki lememoláa nene 50 nenéminiki minamó. ");
INSERT INTO gah_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Lá iki minikago, peleti ligizani helegaloka asú igo itó lagaha lositáma aleake okulumatoka okenava oko ánigoake Ómasi agepoka loake peletima gitegeake, vegená gona miliki kimitave loko izegipala zuha kemeake, lagaha losimagi vegená mukilite natave loko gona moloko kimimó. ");
INSERT INTO gah_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Lá okago vegená mukilite nikake kagatupa okago, ");
INSERT INTO gah_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","peletigi lagahagi lumáa ali nupa iki gosúveha 12-a vaí okago ali milamó. ");
INSERT INTO gah_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Itó nosánetá na véa nene 5 tausen nenéminiki minamó. Vená izegipagi gatamune. ");
INSERT INTO gah_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Lá iki niago, eza vegenáma nokimisilike izegipala zuha nene nagamikú lapegú itiiki vola helegaloka Petesaita numutoka goí iki nivitave loko loketamó. ");
INSERT INTO gah_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Lá oake vegená gekévaké loko kimiseleake eza nene zopega makotó Ómasiloka linogo itimó. ");
INSERT INTO gah_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Lá noigo límugusi zekago, izegipala zuha nene lapegú viki viki nonohuló holukú nivago, Izesú nene ezáagó getató minake ánigamó nene, ");
INSERT INTO gah_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","una napa aleko kogómulalokatí kehelú inogo inazo, nagamí apiliaká nogosanitunú amuza miliki apeleke ligitagani amó. Lá niago gokululuva notovoigo, Izesú nene nonohuló amupiló liso liso vike keza niatoka vo anitimó. Keza kiviligitimó noike, ");
INSERT INTO gah_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","nonohuló amupiló mohona noigo ánigiake, holosi noave liki giliake keza mukitó kelegesá legekago gopaga lamó. ");
INSERT INTO gah_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Lá niago, Izesú litá oko gakó lo kimike láa loko lo kimimó: Lekelegesá legemino. Mulutini lepa hizino. Nezama nouze. ");
INSERT INTO gah_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Loko loake, sipigú itekago hepé kii limóza, ");
INSERT INTO gah_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","nosánetá 5 tausen vegená kimitotí Izesu haitopaitó avevezaha aleaká itímini mogonáa gili hee hee lamake sigaga liki minamó. ");
INSERT INTO gah_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Keza vola helegaloka Genesalete numutoka vi anitiake, nagamikú lape ali gaheva ake nagá ziake, ");
INSERT INTO gah_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","lapegutí olíi limikago, vegenalite litá iki aí ánigi vevesiake, ");
INSERT INTO gah_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ololu liki numutó numutó vi asú iake, kivisi vegená nene ukoakogú kilími miliake, Izesú mina numutó numutokumú giliake neneló kilímiki vamó. ");
INSERT INTO gah_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Minakutí minakutí nene taoniloka itó luhuva numutoka itó iza gihiló numutoka nene kivisi vegená nene alegesá apatoka kilímimi miliake láa liki li amemó: Gugupeló ahe itó hanuva gineganega gahevalokahe ali giliiki nene zokatave. Liki negénegeka likago, áminámini niake ali gele vegená nene zoki asú amó. ");
INSERT INTO gah_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Palisaio monó vegenaki Zelusale numutotí monó mogona apí-ikimiaká a ve lugáagi Izesutoka iki alegesá amó. ");
INSERT INTO gah_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Lá amó nene izegipala zuha lugáate kigizani nagamí zemake nosánetá ninago ánigamó. ");
INSERT INTO gah_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Palisaio monó vegenaki Zuta vegená mukitoka keza golesa okatune liki avóike la gakotó giliiki kigizani vauva aliki nagamí zemikima nosánetá nisá amamó. Avóike li hukiki la gakó ali amegesaló miliki lá iaká amó. ");
INSERT INTO gah_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Itó maketilotí nosánetá meina hiziki alikamó nene monó gelemi ve makolímo ámina nosánetá ale geleneitimó nene ligika ale golesa iti netá loló okave liki giliake nosánetáma monó nagamí hepa hepa ikakegó niaká amó. Itó nenémini okogó minamive. Mogonatagana haitopaitolímini ali minamó. Nagamí gonigi somogi kapa lapegi nene ligikagú golotuva loko lelémo golesa okative liki nagamí ziaká amó nene avóike ali minató ali amegesaló amegesaló mililiki itemó. ");
INSERT INTO gah_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Lá iaká amó nenazo, Palisaio monó vegenaki monó mogona apí ikimiaká a vegi keza Izesuni loká itake lamó: Geí izegipaka zuha nene avotegini mogonatagana ali minamake nanamú ahulikave. Nosánetá natune liki, ligika ali golotuva liaká suni aliki kigizani nagamí zemake ninave. ");
INSERT INTO gah_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Liki likago, Izesú láa loko lo kimimó: Genezatini lositaki neneta Isaiá nene alika utó iti netakumú gozapá limó nene lamaná lekelikumú lokamóma neve. Ómasímo li gakó láa loko luhuva gizonoimóma neve: Vegená mulusi imane keza kegepatunukó nugulizá ali otiaká niamóza, kigika nenitoka mili gímizinamake mili hotó niave. ");
INSERT INTO gah_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Vegenalitini gakó nene není gakokitana okago li kimi-kimi iki miniaká niake soza miliki gupá zi nimiaká niave. ");
INSERT INTO gah_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Lekelisi nene Ómasímo lo hukoleketa gakó ahuliake vegenalitini mogonatagana ali miniaká niave. ");
INSERT INTO gah_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Láa loake nene láa loko lo kimimó: Avotegini mogonatagana alitune liki Ómasímo lo hukoleketa gakó lekemegesa amiake niamó nene vatí suni nego aliaká niahe. ");
INSERT INTO gah_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mosé nene lekeza izokahiko amekahiko kugulizá ale otezo, itó ve makó eza izolahiko amelahiko usí vizekimiaká gakó lo kimitimó nene apele hilitune loko leketonoimóma neve. ");
INSERT INTO gah_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Láa loko limóza, lekelisi láa liki liaká niave: Ve makó eza izolahiko amelahiko nene hize lé oketatove loko u netá mota kolopani loló okave. Nenémini mogonáa lelí gakokutí nene Ómasímini mota amekuve. ");
INSERT INTO gah_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Loko litikumú nene izolahini amelahini nasahilí oketati gapo hize lí oaká noive. ");
INSERT INTO gah_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Lekeza lá iake nene Ómasímini gakó vasá ziake lekezatini avotikini gakó alévolé iki lukesa ali miniaká niave. Itó nenegó nomive. Nenémini netá mukí ali miniaká niave, loko limó. ");
INSERT INTO gah_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Láa loko loake ve vená mukí sele lokago, aitoka alegesá ikago, láa loko lo kimimó: Nénisi nene gakó lo likimitoze, gililo. Mukitoka giliiki gili vevesiki gililo. ");
INSERT INTO gah_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Ni mikilí ikago lakagatupagú lemeaká noi netá nenémo likigika ale golotuva lamitimó neve. Likigikagutí iteaká noi netalímo likigika ale gopa itimó neve. ");
INSERT INTO gah_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Loko loake numukú iteake, ve vená ámegekimikago, izegipala zuhate ámina anoza gakokumú loká imikago, láa loko lo kimimó: ");
INSERT INTO gah_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Íi, lekelisi ámináminiki lakagata kolosamimó niahe. Mogonáa gili vevesamahe. Legepatunú netá matá nokuko ligikagú lemekoko eza gapovagú voaká noinazo, lakagatupagú lemeaká noi netalímo likigika ale gopa osá amive. Loko limó nene nosánetá mukí nene noaká netakó minokave loko live. ");
INSERT INTO gah_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Láa loake makó láa loko limó: Likigikagutí iteaká noi netalímo lekemeni ale golotuva loaká noive. ");
INSERT INTO gah_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Vetini kigikagutí nene golesa kagata geleaká, mokoló mogona, gumina, vegená kepele heleaká, ve vená huki ezega emega oaká, ");
INSERT INTO gah_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ánigi lamaná oaká, netá golesa aleaká, kogoka vizeaká, hokolizá itó mumuzó oaká, kemegeka loaká, kugupe aleko iteaká, zogozogo vizeaká nenemú noluve. ");
INSERT INTO gah_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Imane netá golesa mukí nagatumó nenémo likigikagutí iteake lekemeni ale golotuva loaká noive, loko limó. ");
INSERT INTO gah_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Nenetí ámina apá ahuloake Tulo numutoka apá agilikaloka vimó. Vo aniteake, numuni makokú iteake nenemú gelemitave loko gilimóza halá gemitimó okave. ");
INSERT INTO gah_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Vená makolímini mohola nene holosi makolímo agikagú lemeake alémo golesa o minamó. Lá noigo ámina venámámo Izesuni gakoláa geleake litá oko ake Izesuni agisagú agihúna gimó. ");
INSERT INTO gah_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ámina vená nene Zuta vená negopa hetoka vená minake, Pinisia apá nene Silia mikasiuka getamó minatímo eza nene moholámini agikagutí holosi apeleko amisilitive loko loká omikago, ");
INSERT INTO gah_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Izesú nene Isilae vegenalite Ómasímini lusa goí iki ali alitakumú geleneike anoza gakó makó láa loko lo amimó: Izegipatini nosánetá ipá oko galatini kimitunimó nene etamive. Izegipa nenete goí iki niki kagatupa itave. ");
INSERT INTO gah_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Loko lokago, ámina hetoka venámámo gele veveso minake ezáagi Ómasímini lusa ale alitikumú geleake láa loko limó: Guivahanínemaka, lamaná lokanimóza, nezama litoze. Nosánetá noaká holomalotí izegipate niki lana koma alemó zimó nene galatini netá loló oaká noive. ");
INSERT INTO gah_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Loko lokago, Izesú lo amike limó: Láa loko lanikumú gele gumuze, atiginá oko numukaloka vozo. Holosi nenémo mohokámini agikagutí mota ahulomiake vokave. ");
INSERT INTO gah_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Loko lokago, numunaloka vike ánigamó nene, holosi nene moholámini agikagutí golisi okago holomaló hanuva akonoigo ánigamó. ");
INSERT INTO gah_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Lá okago, Izesú nene Tulo numutotí atiginá oko vike Sitona numutoka avilegeake, vike Tekapoli mikasi avilegeake Galilaia nonohulotó vo anitimó. ");
INSERT INTO gah_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Vo anitekago, negi ve makó genezala gena imó nene alímiki Izesutoka vi anitiake, eza nene agizanitunú nónohá zemikiko lamaná itive liki negénegeka likago, ");
INSERT INTO gah_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","vegená alegesá akutí alémo otopá zeake kezáikó minasike agizani hisulatunú agatagú hizeake gituhú oake, agizanitunú genezalaló lupizeake, ");
INSERT INTO gah_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","okulumakú okenava oko ánigoake, ahuu lo nahulake láa loko lo amimó: Epata. Nenémini mogonáa lelí gakokutí nene koló ino loko. ");
INSERT INTO gah_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Loko lokago, agata koló okago, genezala viligoake gakó lamaná limó. ");
INSERT INTO gah_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Lá okago, Izesú nene avetó iki vegená li kememitave loko lo hukoketamóza, eza lo hutoko loketaha loketaha negénegeka liki li utó iliki vamó. ");
INSERT INTO gah_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Keza nene sigaga goha liki minake láa liki lamó: Netá mukí loló noimó nene lamaná okogó loló oaká noive. Kagata mola vegená nene ale vevesokimikago gakó giliaká niave, itó kegepa lakolí i ve ale vevesokimikago gakó liaká niave, liki lamó. ");
INSERT INTO gah_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Gamena nene zupa vegená vaí iki alegesá ikago, keí nosánetá nomigo, Izesú nene izegipala zuhama sele lokago, aitoka ikago, láa loko lo kimimó: ");
INSERT INTO gah_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Vegená mukí imane nosánetá namake nenitoka nene gamena losive makole minikago milumáini gelekuve. ");
INSERT INTO gah_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Itó lugáa nene hotokatí nianazo, itína gaúna giliki niko numúitoka kimiselekugo vitamó nene gapoloka kovonana vizinogo ive. ");
INSERT INTO gah_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Loko lokago, izegipala zuhamate láa liki li amemó: Mikasi gomopalaló imane vegená mukí imane nosánetá hikutí ale utó oko kemeko natune. ");
INSERT INTO gah_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Liki likago, Izesú loká oketake lekelitoka peleti nanakí neve loko lokago, keza 7-a neve. ");
INSERT INTO gah_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Liki likago, vegená mukí nene mikasiló minatave loko lokimiake, peleti 7-a aleake Ómasi agepoka loake, gitegeake vegená gona miliki kimitave loko izegipala zuha kemekago, keza vegená gona miliki kememó. ");
INSERT INTO gah_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Lagaha lagasó minokago, nenemuki Ómasi agepoka loake imanegi gona miliki kimilo loko lokimikago kememó. ");
INSERT INTO gah_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Vegená nenete niki niki kagatupa okago, lumáagi lanahanagi ali nupa iki gosúveha 7-a vaí okago ali milamó. ");
INSERT INTO gah_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ámina nosánetá na vegená nene 4 tausen nenéminiki minake namó. ");
INSERT INTO gah_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Lá ikago kimiselekago numúitoka nivago, izegipala zuhagi litá iki sipigú itiake Talamanuta numutoka vamó. ");
INSERT INTO gah_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Vi anitikago, Palisaio monó vegená keza iake gimivagú miliki okulumakutí ve noitihe loko gilitune liki alévolé suni ale utó okako ánigatune liki Izesugegi lova leta amó. Lá ikago, ");
INSERT INTO gah_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Izesú gele golesa oake láa loko limó: Imane oko moloko oaká nou suni ánigiaká nia ve neneta alévolé suni ale utó okugo itína ánigatune liki nanamú liaká niave. Lamaná lo likimitoze, gililo. Alévolé suni makó ale utó ugo ánigaminigave. ");
INSERT INTO gah_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Loko loake, ahulokimiake izegipala zuhagi nene sipigú goha itiake ima helegaloka amó. ");
INSERT INTO gah_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Lá niago, peletimú kagatí molokago, alemago peleti hamokó nene nagamikú lapemagú minamó. ");
INSERT INTO gah_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Lá okago, Izesú nene Palisaio monó vegi Helotémagi soza mogonáinimú anoza gakokú kagata aleko láa loko limó: Palisaio monó vegi agulizaki ve napa Heloteki keí lulu vizeaká netá ehe, lekepelekatize. ");
INSERT INTO gah_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Loko lokago, izegipala zuhamate peletímini lulu vizeaká netakumú lihe liki kezáitoka láa liki ligili hagili iki minamó: Peleti nene lagatí molokago ahulokoko unikumú lokave. ");
INSERT INTO gah_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Liki la gakolímo agataló holokago geleake láa loko lo kimimó: Peleti ahulokunike unikumú lokave liki nanamú ligili hagili iki niminave. Azozá netá matá oko moloko utímini mogonáa giliki velesá gili hee hee lamahe. Likigika kolosamihe. ");
INSERT INTO gah_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Lekeza lokogómula nemóza ánigamahe. Lakagata nemóza gelemahe. Lakagatí molokago ahe. ");
INSERT INTO gah_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ve 5 tausen keikumú peleti ligizani lugaloka asú igo gitegekugo niake kagatupa okago lumáa ahulikago gosúveha nanakí vaí iki aleve. Loko lokago, keza 12-a neve, liki lamó. ");
INSERT INTO gah_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Láa liki likago, eza vegená 4 tausen keikumú peleti 7-a kemekugo niake kagatupa okago lumáa gizaká iki ali milamó nene gosúveha napa nanakí vaí iki aleve. Loko lokago, keza 7-ave liki lamó. ");
INSERT INTO gah_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Láa liki likago, eza láa loko lo kimimó: Nene ániginamóma nemóza, goí oko loló oleketu netakitana oko goha loló itomó neve liki velesá gili vevesinamahe, loko limó. ");
INSERT INTO gah_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Lá okago, vake Petesaita numutoka vi anitikago, agómula lika ve makó nene Izesutoka alímiki viake, agizanitunú ale gelekoko ale goloutative liki negénegeka likago, ");
INSERT INTO gah_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","agómula lika vemámini agizató aleake símekaloka alémoko limike, agómulaló gituhú otake agizanitunú ale geleko nónohá zetake loká otake netáma nánigape. ");
INSERT INTO gah_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Loko lokago, agómula goloutoko ánigoake vegená mihina niago nánigumóza, zagitana iki niago nániguve. ");
INSERT INTO gah_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Loko lokago, goha agizanitunú agómulaló nónohá zemikago, ánigo hokolotoake lamaná okago, netá mukí ánigo kolosoko ániguve loko limó. ");
INSERT INTO gah_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Lá okago, Izesú nene numunaloka namisilike limó: Numuni napaloka goí oko vamoko geza minoko aleko itanitoka vozo, loko lo amimó. ");
INSERT INTO gah_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Izesú nene izegipala zuha kelémoko Sisalia mikasiuka agulizaki ve Piliponi agulizató apatoka luhuvagi numuni numutó numutó vamó. Gapoloka nivake izegipala zuha loká oketake vegenalite nenikumú éahove liki liaká niave. ");
INSERT INTO gah_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Loko lokago, keza li amiki lamó: Monó nagamí holokimiaká ve Zoní nene goha utó oko noane liki liaká niave. Itó lugáa nenete Ilaizá eza gozapá okulumakú iti vema goha lemeko noane liki liaká niave. Itó lugáa nenete Ómasímini agepagutí gakó liaká a ve gozapá minamokitana noane liki liaká niave. ");
INSERT INTO gah_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Liki likago, Izesú goha loká oketake lekelisi nenikumú éahove liaká niave. Loko lokago, Pitá nene láa loko limó: Geza Ómasímo gologí oletatane loko lo mololeta vema noane. ");
INSERT INTO gah_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Loko lokago, aikumú avetó iki vegená láa liki li kememitave loko lo hutoketamó. ");
INSERT INTO gah_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Lá okago, gamena nene zupa apí oko gakó láa loko lo utó oko lo kimimó: Okulumakutí lumu ve gihila neza nene miluma netá mukí nimiiki, monó gizapa vegi guguni giziaká ve napagi monó mogona apí-ikimiaká vegi keza není ánigi ahulikiko miluma netá mukí nimiiki, nipili hilikiko, gamena losive makole minokinake heleneitokutí goha otinogo uve. ");
INSERT INTO gah_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Loko lo utó oko lo kemekago, Pitá nene alémo apazá zeake géneka like gahá amimóza, ");
INSERT INTO gah_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Izesú viligoko izegipala zuha ánigoake Pitani gahá namike limó: Satani gakó lanitika mino olové omane. Geza gakó gelenanimó nene Ómasímini gakó lamanike vegenalite kigikagutí liaká nia gakó nene lokane. ");
INSERT INTO gah_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Loko loake, vegená mukí itó izegipala zuhamagi sele lo kemeake láa loko lo kimimó: Ve makolite není némegetatune liki nigilikima kugupémo giliti netá gili ahuliiki zohota zaló kipili hilinigi miluma netá gihikitatakumú gili zagiiki némegetatakumule. ");
INSERT INTO gah_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Makó keza nene kigika kemeníini aliki amánapa iki minata vegená nene kigika kemeni gopa inogo ive. Itó makó keza nenikumule liki itó gakó lamanakumule liki kigika kemeni vínasi ahulatamó nene alévolé kemetameni alinigave. ");
INSERT INTO gah_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ve makó keza imane mikasímini amupiló ne netá ale asú iiki itó kezáini kigika kemeni gopa okoko tolova itimó nene nenémo nana oko kelémo lamaná itive. ");
INSERT INTO gah_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Kigika kemeni nene nana netatunú meina hiziiki goha alitamó neve. Ma nomive. ");
INSERT INTO gah_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Imane vegená mukí kéisi netá golesa aliaká nia vegená itó Ómasi kemegesa amiaká nia vegená niago, holúikú ve makó keza nenikumupe monónemupe gilikiko kovoza hilitimó nene, okulumakutí lumu ve gihila neza aménehini lapaná nenémo numupiló itekiko apazá agelova kelémoko limito gamenaló nene keza kovoza hilimó nenéminoko nezagi kugulizá ale otitokumú novoza hilinogo ive, loko limó. ");
INSERT INTO gah_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Láa loko loake, Izesú miní ameko láa loko lo kimimó: Lamaná lo likimitoze, gililo. Lekelisi ató nene nia ve lekelikutí lugáa makó hili asú inamiki ha niko Ómasímini gizapa olikimiakalímini zámuza nene amuza moloko utó okiko ániganigave. ");
INSERT INTO gah_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Loko loake, hoza gamena 6-a minomo noitike Izesú nene Pitá Zemusí Zoní kezagó kelémoko agoka hánagú kezáikó itemó. Neneló kogómulaló noike haitó agupe ale luhoake noigo, ");
INSERT INTO gah_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","gineganevámo gizopa vaevae loko minokago, mikasigú vegenalite nenéminoko ale mokoná lamoaká nenéminoko minamó. ");
INSERT INTO gah_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Lá okago Ómasímini agepagutí gakó imane amunaló liakó asi ve Ilaizako Moseko utó i kimikasigo, keza Izesugegi gakó ligili hagili iki minamó. ");
INSERT INTO gah_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Lá niago, Pitá nene Izesuni láa loko lo amimó: Monó gizapa velemaka, imaneló minuhá laga okaze. Nenemú gaizopa losive makole geleketatunize, makó geile, makó Mosenive, makó Ilaizanive. ");
INSERT INTO gah_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Loko limó nene kelegesá goha legekago, lo amiti gakokumú vitagá oake nene gakó gopa limó. ");
INSERT INTO gah_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Noligo, límusi sahehevámo lemeko ze hitokimikago, límusigutí Ómasímo láa loko limó: Imane nene nigika ameaká nou gipáne noize, aí gakó gili alilo. ");
INSERT INTO gah_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Loko lokago, litá iki gilipe iki ánigamó nene keitoka Izesú ezáagó noigo ánigamó. ");
INSERT INTO gah_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ánigiake Izesugegi agokagutí nilemeke Izesú ánigina netakumú avetó iki li kememitave loko, okulumakutí lumu ve gihila neza helenoitototí otekugogó li kimitave loko loketamó. ");
INSERT INTO gah_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Láa loko li gakó gili alemóza, hilinakutí otiakalímini mogonamú loká loká amó. ");
INSERT INTO gah_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Láa liki loká itamó: Monó mogona apí-ikimiaká ve nenete gologí oletati vema velesá anitemiko Ilaizá goí oko anititive liki nanamú liaká niave. ");
INSERT INTO gah_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Liki loká imikago, eza monó nagamí holokimiaká ve Zonikumú láa loko lo kimimó: Ilaizá goí oko aniteko netá matá mukí ale vavá itive liki lamaná linave. Itó okulumakutí lumu ve gihila neza nene miluma netá numupiló miliiki gopoguni milinitatave liki nenikumú monó gotolaú luhuva gizinamómagi neve. Áminamú lakagatí molahe. ");
INSERT INTO gah_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Itó Ilaizakumú láa loko lo nolukumuve. Eza mota anitekago, aikumú monó pukugú luhuva gizina gakotó kezáini kagata gele netá golesa mota lilí imikago mota helekave, loko limó. ");
INSERT INTO gah_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Láa loko lokago, izegipala zuha lugáa niatoka vi anitiake ánigamó nene, vegená vaí iki alegesá iake kezagi monó mogona apí-ikimiaká vegi lova leta iki niago ánigamó. ");
INSERT INTO gah_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ánigikago, vegená mukí nenete Izesuni ánigiake, litá iki sigaga goha litake aitoka ololu liki vake geké litamó. ");
INSERT INTO gah_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Lá niago Izesú loká oketake lekeza nanamú lovaleta niave. ");
INSERT INTO gah_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Loko loká okimikago, keikutí ve makolímo oteake láa loko lo amimó: Monó gizapa velemaka, holosi golesa gipánémini agikagú lemeko minoake agepa aleko lakolí okago, alémoko geitoka nouve. ");
INSERT INTO gah_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Gipáne nenémo holosi nene agikagú lemeake alémo gopa napa oaká gamena nene mikasigú alémo akokago zupakopá zeko mohona oaká noive. Lá noike sehovala novilike agepagutí gelilikelilí nolike, agisa agizani pehe loake minoaká noive. Lá okago, izegipaka zuha keza holosi apiliki amisilitave loko lo kumumóza amiselemitamó okave. ");
INSERT INTO gah_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Loko lokago, Izesú láa loko lo kimimó: Lekeza ató imane gili alévolé amamó neneta, lekelikumú goselé nepelekave. Gamena gamena lekezagi minoloko voko mininake likizamuha hizekogó minatohe. Izegipama nénisi noutó alímiki alo. ");
INSERT INTO gah_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Loko lokago, gipa nene aitoka alímiki ikago, holosi golesa nenémo Izesuni ánigoake gopa alémo ininá okago, mikasiló pou loko akoake, ako viligá viligá noike, sehovala vilimó. ");
INSERT INTO gah_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Lá noigo Izesú nene amelahini loká otake hí gamenaló gizalimó neve. Loko loká okago limó: Izegipa komaló gizaleneimó neve. ");
INSERT INTO gah_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Mukí gamena ámina netalímo alémo golesa inogo lokú nemó nagamikú nemó ahelú o ahuloaká onoimóma neve. Lá onoimóza, zámuza geitoka neikoma lelikumú gigika hizekiko lelémo vatí ozo. ");
INSERT INTO gah_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Loko lokago, Izesú láa loko lo amimó: Zámuza geitoka neikoma loko lanimó nene nanamú lane. Makó keza Ómasímo lelémo vatí itimó neve liki gili alévolé iki minatamó nenete mukí netá nene vávani ikigó lilí itamóma neve. ");
INSERT INTO gah_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Loko lokago gipámini amelaho nene litá oko gamoga geko limó: Koma gele alévolé onoumóza koma miní ameko luhusáne ale kii lonimikako napa oko gele alévolé itove loko noluve. ");
INSERT INTO gah_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Loko lokago, Izesú ánigamó nene ve vená mukí alegesá niago, ánigoake, holosi golesama lovaga lo amike namisilike limó: Holosi golesa geza agepa agata aleko lakolí anitika, agikagutí itekoko vozo. Lá okoko goha atiginá oko oko itemitane loko lo nohukogetuve. ");
INSERT INTO gah_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Loko lokago, gopaga like alémo ininá goha okago, agikagutí iteko vimó. Iteko vokago, gipa nenémo gonosigitana oko mikasiló ako minakumú nene vegená makolite mota helekave liki lamó. ");
INSERT INTO gah_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Láa liki lamóza, Izesú nene agizató aleko alémo otekago ote minamó. ");
INSERT INTO gah_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Lá okago, Izesú nene izegipala zuhamagi numukú itiki kezáikó minake láa liki loká itamó: Leza nene nanamú apeleko amiselemuháma neve. ");
INSERT INTO gah_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Liki likago, eza láa loko lo kimimó: Holosi imanémini nene netá makotunú kepeleko kimiseleakaláa nomive. Ómasiloka loakatunukó kepeleko kimisilinogo une, loko limó. ");
INSERT INTO gah_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ámina apá ahuliake Galilaia mikasi aviligiki vamó. ");
INSERT INTO gah_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Nivake Izesú nene izegipala zuhama láa loko lo keme keme imó: Okulumakutí lumu ve gihila neza nilími gala vetini kigizakú milikiko nipili hilinigave. Nipili hilikiko gamena losive makole minokinake goha otinogo uve. Loko lo kemeake vegená makolite ámina gakoláa gilikatave loko legesó oko vimóza, ");
INSERT INTO gah_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","ámina gakó nene gili vevesamake loká otatune liki lamóza, kehelele vizekago loká itamamó. ");
INSERT INTO gah_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Kapanao numutoka vi anitiake, numunagú itiake Izesú loká oketake gapoloka nanetakumú ligili hagili ave. ");
INSERT INTO gah_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Loko loká oketamó nene gapoloka nivake lelikutí éaho livilegeko agulizaki ve noive liki kezáitoka ligili hagili anazo, anotó alemiki kegepa apiziki minamó. ");
INSERT INTO gah_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Lá niago, mitó minake izegipala zuha 12-a sele lo kemeake láa loko lo kimimó: Ve makó eza nugulizaki ve napa minatove loko gilitimó nenémo lemeko minoko vegená mukilitini gelekelé oketanogo ive. ");
INSERT INTO gah_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Loko Izesú loake, izegipa koma makó nene holúikú alémoko oko hize otemiake aputá vizeneike láa loko lo kimimó: ");
INSERT INTO gah_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Makó keza izegipa koma imanéminiki nenikumule liki nasahilí itatamó nene, není nasahilí inimiaká niamó geleaká noive. Itó makó keza nasahilí initamó nene nenikó nasahilí initamitave. Améneho nimisili ve aiki nasahilí itatamó geleaká noive, loko limó. ");
INSERT INTO gah_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Lá okago, Zoní láa loko lo amike limó: Tisalemaka, ve makolímo geí gugulizató like holosi golesa nene vegenalitini kigikagutí kepeleko nokimisiligo ánigunimó nene, lelí lémegetamimó nenazo, géneka lotunimó neve. ");
INSERT INTO gah_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Loko lokago Izesú láa loko limó: Lekeza géneka litamilo. Makó eza nugulizató loko alévolé netá netá loló itimó nene litá oko nenikumú alevo letovo aminogo ive. ");
INSERT INTO gah_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Vegená makó keza lelí gala ve minamitamó nene lelikutí vegená ninigave. ");
INSERT INTO gah_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Neza lamaná lo likimitoze, gililo. Makó keza není vegenáne zuha niakumule liki geha nagamí kapu hamokó ihiki likimitamó nene haha aminogo ive. Meinaváa alitamó neve. ");
INSERT INTO gah_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Nenikumú gili alévolé i mina izegipáne zuha limiki minamoki keikutí ve makolímo netá golesa alitive loko agoka vizeko litimó nene, agae, Ómasímo nana otatimó neve. Ámina vémini luvanaló gehani napa nagá ziki age nagamikú ahelú i ahulatatímini avilegeko genavagi netá golesa loló otanogo ive. ");
INSERT INTO gah_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Lá onoinazo, gigizani nenémo lihima aleaká gapogú gelémo nomilikoma gigizani hutozo. Geza nene gigizani avasavagi minokoko ló apakuka lihamiti lokú holokataninazo, gepili minoko okulumakú ititanimó nene lamaná itive. ");
INSERT INTO gah_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Gigisa nenémo lihima aleaká gapogú gelémo nomilikoma nene gigisa hutozo. Geza nene gigisa avasavagi nooko ló apakú gehelú ikatanazo, gepili minoko okulumakú ititanimó nene lamaná itive. ");
INSERT INTO gah_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Gogómula nenémo lihima aleaká gapogú gelémo nomilikoma nene gigizanitunú gogómula hize likozo. Geza nene gogómula avasavagi nooko lokú gehelú ikatanazo, gogómula hamokó minoko Ómasímini avogisaló ititanimó nene lamaná itive. ");
INSERT INTO gah_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ló apakú holoko minatanimó nene, gugupegú ginini hizitimó nene asú amiti lokú voko minanogo ane. ");
INSERT INTO gah_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Nosánetakú nene anuva amoko laga itive loko age ahuloaká noune. Nenémini oko vegená mukitoka kigikámini lotuva nene Ómasímini ló nenémo latimó neve. ");
INSERT INTO gah_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Age nene netá lamaná nemóza, agema melelé amitimó nene nana iki goha alími melelé itave. Ma lá aminigave. Lekelisi nene age nenémini iki minalo, itó hulu iki nene minalo, loko limó. ");
INSERT INTO gah_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Izesú ámina apá ahuloake, limike Zutaia mikasi avilegeake Zota nagamí vola helegaloka vokago, vegená mukí goha aí amatoka alegesá ikago, goí oko aleaká imó nenéminoko monó lo keme keme oko minamó. ");
INSERT INTO gah_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Lá noigo, Palisaio monó vegenalite anitiake loká itake gimivagú milake lamó: Mosé lo hukoko li gakokú nene ve makolímo venala amisele ahulatove loko hanuva amisele ahulatimó neve liki gizinamóma nene etatihe etamitive. ");
INSERT INTO gah_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Láa liki loká imikago eza ale viligoko loká oketake limó: Mosé nene nanave loko loleketamó neve. ");
INSERT INTO gah_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Loko lokago, keza lamó: Vená kimisilinigima nene luhuva netá giziki kimiiki kimisilitave loko Mosé gele kemeaká imóma nenae. ");
INSERT INTO gah_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Liki likago, Izesú láa loko lo kimimó: Lekelisi negi nagi hiziki likigika gopa ovimó nenemú imane lo hutoleketa luhuva gizamóza, ");
INSERT INTO gah_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","netá matá apí oko kelémo utó i gamenaló emane nene Ómasímo vegi venaki kelémo utó imó. ");
INSERT INTO gah_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Nenemú Ómasímo láa loko limó: Nenemú ve makolímohe makolímohe izolahiko amelahiko ahulokimioko venalagi nene, ");
INSERT INTO gah_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","kugupe nemó kigika nemó hamokó loló okiko apiziki minatáive. Loko gakó imane limó nenazo, keza lositá hoú liki minaminigasive. Hamokó kugupe loló onoimó gelekave. ");
INSERT INTO gah_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Nenemú Ómasímo kelémo apizimó nenazo, vegenalita kelémo hotopotó oakaláa nomive. ");
INSERT INTO gah_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Loko lokago, numukú itiki niake, izegipala zuhamate ámina gakokumú goha loká imikago, ");
INSERT INTO gah_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Izesú láa loko lo kimimó: Ve makó eza venala amisele ahulokoko haitó vená alitimó nene, ve vená huko ezega emega imómámini lihima alinogo ive. ");
INSERT INTO gah_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Itó ámináminoko vená makolímo vana amisele ahulokoko ve makotó vitimó nene, ve vená huko ezega emega imómámini lihima alinogo ive, loko limó. ");
INSERT INTO gah_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ve vená mukí keza agizanitunú kugupeló aleko nónohá zeketative liki izegipa koma kama Izesutoka kilímiki vikago, izegipala zuhate gahá kememó. ");
INSERT INTO gah_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Gahá kimikago, Izesú ánigoake mulunagú golesa okago láa loko lo kimimó: Lekeza izegipa koma nene ahulikimikalo. Nenitoka ataze. Keza izegipa koma nenémináa nene Ómasímini avogisaló viakalímini mututoni nianazo, li hoipa ikitamilo. ");
INSERT INTO gah_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Neza gakó lamaná lo likimitoze. Ve makó keza izegipa namuni monokú itiaká niamómáminiki vávani iki monokú itemitamó nene, Ómasímini avogisaló nene keké vaminigave. ");
INSERT INTO gah_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Loko lo kemeake, izegipa komama kuputá vizike agizanitunú nónohá zeketamó. ");
INSERT INTO gah_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Izesú eza ámina apatotí vitove loko noigo, ve makolímo ololu loko vike alapusa hizike loká otake tisá lamanámaka, nana okinake alévolé nemetameni alitomó neve. ");
INSERT INTO gah_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Loko lokago, Izesú láa loko lo amimó: Geza nenikumú ve lamanale loko lanimó nene mogonánemú gele hee lo minoko nolape itó hanuva nolane. Lamaná améneho Ómasi hamokó noize, makó nomive. ");
INSERT INTO gah_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Itó geza gapo lota gakó geleaká noane. Láa lokove: Geza vegená kepele helemo. Ve aleve suni ale gopa oko huko ezega emega amo. Gumina alemo. Soza hakupá gakó lamo. Vegenalitini netá hanuvamú alemo. Izokahiko amekahiko nene kugulizá ale otezo. ");
INSERT INTO gah_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Loko lokago, eza láa loko lo amimó: Tisatemaka, neza nene umaki velotí nene ámina hoza aleaká noumole. ");
INSERT INTO gah_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Loko lokago, Izesú nene gonú napilike agika aitoka moloake gakó láa loko lo amimó: Netá hamokó nemó nene ale hee litanize. Geza voko henokanoka mukí molokoko meinaváa monima aleoko gohogó vegená gona moloko kemeoko oko némegetozo. Lá okako okulumakú helisa henoni geitoka utó ogetanogo ive. ");
INSERT INTO gah_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Loko lokago, ámina gakó geleake aí henoni vaí o minamó nenazo, gona moloko kimitohe loko agata gilitímo agoka agepa muhelé okago, mulunagú gena avisekago vimó. ");
INSERT INTO gah_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Lá oko novigo, Izesú viligoko izegipala zuhama ánigoake láa loko lo kimimó: Henoníini vegená nene Ómasímini lapanató silipa iki itesá neve. ");
INSERT INTO gah_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Loko lokago, izegipala zuhamate ámina gakokumú ininá amóza, Izesú goha láa loko lo kimimó: Izegipánemata, Ómasímini amakú vo holoaká nene genavagi neve. ");
INSERT INTO gah_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kamele izámo nakasi vovónagú voakaláa nene vávani oko nomimóza, henonavagi ve nene Ómasímini lapanató voakaláa nene áminámini oko genavagi golesa neve. ");
INSERT INTO gah_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Loko lokago, ininá goha iake li amiki lamó: Láa lokoma éaho agutó vizekiko minoloko voko minative. ");
INSERT INTO gah_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Liki likago, Izesú gonú nokipilike láa loko lo kimimó: Vegenalite nenémini itamoláa nomimóza, Ómasímo netá makó loló itove loko agata giliti netá nene vávani okogó loló oaká noive. ");
INSERT INTO gah_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Láa loko lokago, Pitá láa loko lo amimó: Gelenape. Leza mukí netá matate ahulokunike geí gémegetokuninazo, alika nene meinava alitunimó nehe. ");
INSERT INTO gah_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Loko lokago, Izesú limó: Neza lamaná lo likimitoze. Ve makó keza numúinihe gouna zuhahe izóikini améikini izegipáinihe míinihe nenikumule liki itó není gakó lamanakumule liki ahulatamó nene, ");
INSERT INTO gah_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","itína imane gamenaló nene numuni gouna zuha izóikini izegipáini míini 100 nenéminiki alitamóza, vegená makolite hanuvamú gopoguni milikitanigave. Lá ikiko alika utó iti gamena keza alévolé oko minoaká kemetamenigi minanigave. ");
INSERT INTO gah_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Lá onoimóza, itína goí ina vegenakutí mukilite alika milanigave, itó alika milina vegenakutí mukilite goí inigave, loko limó. ");
INSERT INTO gah_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Gapoló vake Zelusalega itinigi niake Izesú ale goí oko novigo, izegipala zuhamate ininá niago, ámegetiki va vegená alika kezáitoka utó iti netakumú kehelele vizigo minamó. Lá niago, Izesú eza izegipala zuha 12 nene kelémo otopá zeake, aitoka alika utó iti netakumú láa loko lo kimimó: ");
INSERT INTO gah_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Gililo. Leza Zelusale numutoka notune. Neneló okulumakutí lumu ve gihila není nene guguni giziaká ve napagi monó mogona apí-ikimiaká vegi keí kigizakú milikiko goní initiki nipili hilita gakó li hukiki hetoka vetini kigizakú milanigave. ");
INSERT INTO gah_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Lá ikiko, gopoguka linitiki gituhú initiki segi nogosanitunú nipiliiki nipili hilinigave. Lá ikiko, gamena losive makole minokinake goha otinogo uve, loko limó. ");
INSERT INTO gah_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Zepetaioni gipala lositá Zemusiko Zoniko nene Izesutoka asike láa liki lasimó: Tisalemaka, lélisi nene nemú manamú logimikusigo nene, ámina netá aleletatane loko nolusive. ");
INSERT INTO gah_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Liki likasigo, eza nana netá aleleketatokumú nilasive. ");
INSERT INTO gah_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Loko lokago, láa liki li amesimó: Geí lapanakaló leza geí gigilika luga luga minalizo loko gele limitane loko nolusive. ");
INSERT INTO gah_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Liki likasigo, Izesú láa loko lo kimimó: Loká ninitasi netalímini mogona gili gopa ikasike likasive. Nénisi nene ekesá netá natomó nene lekelisi áminagutí hanuva natáimó nehe. Itó miluma netá gihitomó nene lekelisiva gihitáimó nehe. ");
INSERT INTO gah_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Loko lokago, láa liki li amesimó: Hanuva natíimó nenae. Liki likasigo, Izesú láa loko lo kimimó: Ekesá netá natomó nene lamaná lekezagi nanigasive. Itó miluma netá gihitomó nene lekezagi gihitáimóza, ");
INSERT INTO gah_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","není nigilika luga luga minoakaláa nene, není netá nego likimitohe. Ale vavá oketa vegenalitini holomamú nilasive. ");
INSERT INTO gah_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Loko lokago, izegipala zuha lugáa 10-a ámina gakó giliake, Zemusiko Zoniko keikumú mukahá kipilikago, ");
INSERT INTO gah_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Izesú nene izegipala zuha mukí sele lo kemeake láa loko lo kimimó: Ve makokumú nene mikasiuka vegenalitini kugulizaki ve niave liki liaká niamó nenete gelekelé izegipáini nene alévolekutí gizapa ikimiaká niave. Itó guivahani keza nene ámina iki ámemenáa kiviligiki miniaká niamó nene lekeza giliaká niave. ");
INSERT INTO gah_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Lá onoimóza, lekelitoka lá oko minamino. Lekelikutí ve makolímo nugulizaki ve minatove loko nolokoma nene hanuva lemetigí oko gelekelé oleketoko minatize. ");
INSERT INTO gah_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Makó eza mukí vegená kivilegeko minatove loko nolokoma lemeko vegená mukilitini megusa izegipa loló oko gelekelé oketatize. ");
INSERT INTO gah_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Okulumakutí lumu ve gihila neza gelekelé initatave loko lememuve. Vegená mukitoka gelekelé oketoko golesa netáini nene meina hizeko gologí oketatove oko nene minoko aleko u nugupe ahulatove loko lumumole, loko limó. ");
INSERT INTO gah_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Izesugegi Zeliko apatoka viki anitemó. Ámina apá ahulanigi niake, ezagi izegipala zuhagi vaí iki alegesá iki mina vegená makó nivago, Timeoni gipala Patimiasí eza agómula lika ve monimú voká vokató ve nene gapo agataloka minamó. ");
INSERT INTO gah_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Minake, Nasalete ve Izesúma noave liki likago geleake, gamoga geko sele loko limó: Izesuvo geza nene agulizaki Tevitini agávolaga, gologí oletatane loko lo mololeta velemaka, nenikumú miluma gelenetamane. ");
INSERT INTO gah_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Loko lokago, vegená mukilite legesó oko minative liki agómula lika vema gahá ameke li amemóza, áisi gele ahuloake gamoga geko sele limó: Geza Tevitini agávolagamaka, nenikumú gigika hizino. ");
INSERT INTO gah_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Loko negénegeka ligo ligo, Izesú geleake voko gapoló noike ámina ve nene sele likiko ino. Loko lokago, agómula lika vema láa liki sele li amemó: Gogoliza vizeko otekoko ano. Geí sele nolize. ");
INSERT INTO gah_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Liki likago, hepé gola gololohá o ahuloake, moí oko oteake Izesutoka vimó. ");
INSERT INTO gah_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Vo anitekago, Izesú nana netá alegetatokumú nolane loko loká omikago, agómula lika vemámo tisánemaka, nogómula ale goloutonetatane loko noluve. ");
INSERT INTO gah_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Loko lokago, Izesú láa loko lo amimó: Geza nene vozo. Nenikumú gele alévolé anitímo gelémo zokokaze. Loko noli agepagi, agómula goloutokago ánigoake gapoloka Izesuni ámegetoko vimó. ");
INSERT INTO gah_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Keza vake Zelusalega ali ávatiha niake, Olivi agoka gohalaló nene apá lositá minamó nene Petepage itó Petania loko netoka vi anitemó. Neneloka anitiake, Izesú nene izegipala zuhagutí ve lositá láa loko lo kimike kimisilimó: ");
INSERT INTO gah_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Helega numutoka vi anitiiki toki iza akaleva nagá zinamóma nene, vegená kogohí geko mohona onamitimoláa nene, ánigiiki vínasiki aliki alizo. ");
INSERT INTO gah_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Vínasiki aliki nisiko, ve makolímo nanamú niasive nolikoma, láa liki lilizo: Guivahanitémo hoza nego ámina izamú lokago aleko vinogo nousive. Goha imaneloka litá oko amiselekiko aliki anigave, liki li amilizo. ");
INSERT INTO gah_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Loko lo kemekago, vasike ámina toki iza akaleva nene gapo gahevaloka gatetó nagá zinamó ánigikasike nivínasasigo, ");
INSERT INTO gah_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","gatetó mina vegenalite ánigiake, toki iza akaleva nene nanetakumú nivínasasive. ");
INSERT INTO gah_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Liki likago, Izesú lo kimi gakó nene li kimikasigo gili kememó. ");
INSERT INTO gah_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Lá ikago, keza toki iza akaleva nene Izesutoka aliki vasike, gineganéini nene gololohá ikasike toki iza akalevamámini amegesaló milikasigo, Izesú iteko amupiló minamó. ");
INSERT INTO gah_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Lá oko novigo, vegená mukilite gineganéini gapoló avilisá imi nivago, lugáa nenete kokonasi agila nene gihisigutí hutiki mililiki viki gapoló avilisá imi vamó. ");
INSERT INTO gah_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Lá niago, goí iká alika miliká a vegenalite gakó napagutí láa liki lamó: Agae, Guivahanímini gakotó anitelimikaninazo, Ómasímo nónohá zegetino. ");
INSERT INTO gah_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Avoteho Tevitikitana minati vémo gizapa oketatimoláa Ómasímo lusa geketino. Agae, veletoka okulumakú Ómasi agepoka litune, liki lamó. ");
INSERT INTO gah_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Lá imi vago, Zelusalega ite aniteake, monó zagusave napagú iteake netá makó ánigomo mohona o asú oake, gamena asú okago, ezagi izegipala zuhamagi Petania numutoka limiki vamó. ");
INSERT INTO gah_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Límugusi zeake gó lokago, Petania numutoka ahuliake nivake, Izesuni gaúna olokago, ");
INSERT INTO gah_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","ánigamó nene gohuna za makó hotó neike agila mukí minokago ánigoake gihila zeneihe loko voko ánigamó nene, gihila zeaká gamena alitamigo, agilagó nego ánigoake ");
INSERT INTO gah_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","za nene láa loko lo amimó: Geza nene gihila makó zemoko gohuna loloko voko noako geikutí nene vegenalite keké namitave. Láa loko noligo, izegipala zuhate ámina gakó gili asú amó. ");
INSERT INTO gah_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Lá iake Zelusalega vi anitiake, Izesú nene monó zagusaveú itike áminagú moni meina kona ali volaló imaló a vegená kimisele ahuloake, hotó mikasigutí moniló ámina mikasigú moni kimiaká a vetini holoma aleko gululupa soake, Ómasímini guguni gizi amitakumú nama luhusi miliaká a vegenalitini minoaká holoma aleko gululupa soake, ");
INSERT INTO gah_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","monó zagusave napagú nene netá matá aliki tigá igá amilo loko lo hukoketamó. ");
INSERT INTO gah_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Lo hukoketake láa loko lo kimimó: Ómasímo li gakó nene monó gotolaú láa liki luhuva gizinamóma neve: Není numunimú haitopaitó vegenalite Ómasiloka liaká numunive liki litave liki gizinamóma neve. Lá onoimóza, lekeza nene alími maketi numuni lilí inamó nene guminaló veta halá giki miniaká geha mulí lilí ikave. ");
INSERT INTO gah_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Loko lokago, guguni giziaká ve napagi monó mogona apí-ikimiaká vegi keza nenemú giliake, nana okinake apele helekuko imane suni asú itive liki lamó. Láa liki ligili hagili amóza, vegená mukilite monó lo keme keme okago laga kivisigo sigaga lita mogonamú giliake kelegesá legekago nenemú ahulitamó. ");
INSERT INTO gah_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Lá okago únaká gamena gamena Izesuge ámina apá ahuliki viaká amó. ");
INSERT INTO gah_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Neteká gó lokago, nivake, gohuna za nenémo mogonagutí osagava vizekago, ánigamó. ");
INSERT INTO gah_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Lá okago, Izesú gakó limó nenemú Pitá geleake láa loko lo amimó: Tisao, ánigozo. Gohuna za azozá usí vize amenimómámo mota osagava vizeake neve. ");
INSERT INTO gah_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Loko lokago, Izesú lo kimike limó: Ómasimú gili alévolé ilo. ");
INSERT INTO gah_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Neza lamaná lo likimitoze, gililo. Ve makolímohe makolímohe vozane agoka litá oko zeko akutooko age nagamikú holamane loko litimó nene agata losi gelemoko nolu gakó alévolé inogo ive loko gele alévolé itimó nene, utó o aminogo ive. ");
INSERT INTO gah_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Lekelisi nene netá nemú manamú giliiki Ómasiloka voká niliki mota alekune liki gili alévolé inikigó litamó nene, alinigave. ");
INSERT INTO gah_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Itó otiki Ómasiloka lita gamena gamena nene, ve makolímini lihima ali minatamó nene ahulalo. Lá ikiko, okulumakú ametipo ámina oko lekelí lihimatini ahuloleketanogo ive, loko lo kimimó. ");
INSERT INTO gah_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Zelusalega goha atiginá iki iake, Izesú monó zagusave napagú iteko mohona noigo, guguni giziaká ve napagi monó mogona apí-ikimiaká vegi monó gizapa vegi aitoka iake ");
INSERT INTO gah_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","láa liki loká itake lamó: Geza imaneloka netá matá aleaká noanimó nene éahini gakotó lá oaká noane. Éaho lokago aleaká noane. ");
INSERT INTO gah_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Liki loká imikago, Izesú láa loko lo kimimó: Nezagi gakó hamó loká oleketatoze. Lekeza li nimikiko neza éahini gakotó imane netá ale utó oaká nouhe nenéa lo likimitove. ");
INSERT INTO gah_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Zoní monó nagamí holokimiaká hoza alimó nene hikutí ale utó ive. Ómasímini gakotó alihe, itó vegenalitini gakotó alive. Li nimikiko gilitoze. ");
INSERT INTO gah_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Loko loká okimikago, kezáitoka ligili hagili iki láa liki lamó: Okulumakutí ale utó imole loko litunimó nene, íi, lekeza nanamú Zonini gakola gili alévolé amave loko linogo inazo, ");
INSERT INTO gah_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","itó mukí vegenalite Zoní nene Ómasímini agepagutí gakó loaká ve noive liki nilanazo, ámina hoza nene vetinigutí ale utó imole loko losá nene vegenalite nene nana ilitatahe loko lehelele vizekave liki kezáitoka liake, ");
INSERT INTO gah_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Izesú li gakokumú láa liki li amemó: Leza nene Zonini mogonala ma gelemune. Liki likago, Izesú láa loko lo kimimó: Láa likima nene netá matá imane aleaká noumó nene éahini gakotó lá oaká nouhe nenegi neza ámina oko lo lekememinogo uve, loko limó. ");
INSERT INTO gah_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Izesú anoza gakó makó láa loko lo kimimó: Ve makolímo vain nagá nene zuhá oake, vego vego oko geisa hize asú oake, gihiláa mí zeko liliká ziti gale legeake, gizapa numuni hána geake, gizapa iki niko meinava likimitove loko vegená makó gutá kemeake mikasi makotoka venoni vimó. ");
INSERT INTO gah_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Voko minake nagá gihila guzá loaká gamena alitokago, geleake nagá gihila mikutí lugáa alenetoko ative loko gelekelé izegipala makó nene gizapa nia vegenatoka amiselekago, ");
INSERT INTO gah_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","vo anitimó. Vo anitekago, vain mitó gizapa imina vete apiliake nagá gihila amemake hanuva amisilikago atiginá oko vimó. ");
INSERT INTO gah_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Lá ikago, gelekelé izegipa makó goha amiselekago keitoka goha anitekago, mini gizapa vete gotola ziki hoú nilake gopoguka litamó. ");
INSERT INTO gah_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Lá ikago, makó goha amiselekago, aí nene apili helemó. Lá ikago, goha mukí kimiselekago, vi anitikago, lugáa nene gosohá nogosani kepelemó, itó lugáa nene kipili helemó. ");
INSERT INTO gah_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Lá ikago, agika ami gipala hamokó minamó. Aí nene keitoka alika luma lama zeko láa loko geleake amisilike limó: Není gipa gihila imane amiselekugo ve napámini gipalama okaze liki ánigiiki nene alími lamaná itanigave. ");
INSERT INTO gah_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Loko geleake amisilimóza, vo anitekago, mitó gizapa vete kezáitoka ligili hagili ake láa liki lamó: Imanémo nene mikasi amelahini gipala noinazo, áisi nene minokoko imane hoza ale lá inogo ive. Nenemú mota losé apelekuko helekiko, helisa henoni imane nene lelí loló itive. ");
INSERT INTO gah_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Liki liake, gipalama agizató aliake losé apili hiliake, nagá gihila mikutí hetoka nene gonosiváa ali ahulamó. ");
INSERT INTO gah_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Lá ikamó nenazo, nagá mini amelaho nene nana itive. Áisi okoko mini gizapa vema kepele ahulokoko vain mini nene haitó vete gizapa itave loko lehizeketanogo ive. ");
INSERT INTO gah_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Itó imane monó gotolaú gakó láa liki luhuva gizinamóma nene lekeza gatinamóza lakagatí molokahe: Numuni giaká vete gehani napa makó ánigi ahulamó nenémo geha lapusa alévoleláa loló oake noive. ");
INSERT INTO gah_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ámina netá nene Guivahanímini gakotó utó okanazo, vegenalita ánigokuko lamaná okave. ");
INSERT INTO gah_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Láa loko lo kemekago, Zuta vetini monó gizapa ve keza anoza gakokutí gehanimú limó nene Izesuni ánigo ahulunikumú lokave liki giliake, agizató alinake nagá amitune liki gelemóza, lá itunimó nene vegená vaí iki minamó nenete nana ilitatahe liki kehelele vizekago, ahulimiake hanuva vamó. ");
INSERT INTO gah_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Zuta ve keza Palisaio monó vegenakutiki Heloteni patigú vegenakutiki ve lugáa nene Izesúma gakó makó lo gopa okiko agizató alitave liki aitoka kimisilikago, ");
INSERT INTO gah_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Izesutoka vi anitiake láa liki li amemó: Tisalemaka, geí mogonaka gelenoune. Gakó gihilagó loaká noane. Geza vegenakumú gonukonú osá amane. Géisi vegená iti minamó limi minamó mukitoka Ómasímini gapováa vevesoko lelepizeaká noane. Nenemú lokako gilitune. Loma apatoka agulizaki ve napa Sisani nene takisi moni ameaká nouhá etahe etamive. ");
INSERT INTO gah_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Takisi moni kimitupe kememitune. Láa lamó nene amemitune loko lokikoma gamaniloka alémoko voko goní otatune. Itó hanuva amitune loko lokikoma Zuta vegenalite gili golesa itave liki gimivagú milikago, Izesú gakó latímini mogonáa geleake láa loko lo kimimó: Nanamú giminegú milanigi nilave. Moni makó nelepizikiko ánigatove. ");
INSERT INTO gah_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Loko lokago, makó alapizikago ánigoake láa loko loká oketake limó: Vogunahana imane itó luhuva imanegi éahini neve. Loko lokago, keza gamani agulizaki ve napa Sisanive liki lamó. Láa liki likago, ");
INSERT INTO gah_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Izesú láa loko lo kimimó: Láa likima nene gamanímo voká loaká noi netá nene gamani amilo, itó Ómasímo voká loaká noi netá nene Ómasi amilo. Loko lokago, vatí oko ale viligoko lo kimikumú sigaga goha litiki minamó. ");
INSERT INTO gah_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Satukaio monó vegená lugáa keza hilinakutí otisá amave liki liaká a vegená makolite Izesutoka iake láa liki loká itake lamó: ");
INSERT INTO gah_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Tisalemaka, Mosé láa loko luhuva gizo limimóma neve: Ve makolímo izegipa geto molamoko minoko helekikoma, agunalámo ámina gevoná vená alekoko uvolahini hili vemú izegipa geto molative loko loletamóma neve. ");
INSERT INTO gah_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Lá okanazo, uvolaho agunala 7-a minamó. Lá iake, ganá ve nenémo vená aleake, izegipa getamike helekago, ");
INSERT INTO gah_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","agunalámo ámina vená aleake minake, izegipa getamike helekago, agunala makolímo ámináminoko alimó. ");
INSERT INTO gah_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Itó lá iliki vake ve 7-a nenete ámina venakó ali volaló imaló iki minake izegipa getamake hili asú ikago, venáini nene minake alika hilimó. ");
INSERT INTO gah_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ve 7-a nenete ámina vená ali volaló imaló iki minamó nenazo, hilinitakutí goha otita gamena nene ámina vená nene éahini venala minative. ");
INSERT INTO gah_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Liki galegutí oteaká gakokumú amé ziki giza itanigi likago, Izesú láa loko lo kimimó: Lekeza monó gotolaú gakó gelemake itó Ómasímo galegutí kelémo oteaká zámuzagi ma gelemake gili gopa ikave. ");
INSERT INTO gah_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Keza hele vegená otita gamena nene, vená aleakaláa nomive, itó vená alimi kimiakaláa nomive. Okulumakú ageló nenéminiki minanigave. ");
INSERT INTO gah_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Itó hele vegená goha otiaká nenemú neza lo likimitoze. Gozapá nene Mosé eza zamukutí ló guluma utó okago, ánigoake noigo, Ómasímo gakó láa loko limó nene gatiaká niamóza mogona gelemave. Ómasímo nene ká emane amunaló hilina vemú nene Moseni láa loko lo ameneimóma neve: Neza Avalahani Isakani Zakoponi keí Ómasi minutímina minoloko voko nominuve. ");
INSERT INTO gah_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Loko limó nenazo, nenemú eza kemeni hele vegenalitini Ómasi negopa, kemenía hanuva ne vegenalitini Ómasi noinazo, Ómasimú gili zaginake hele vegenaki hanuva mina vegenalitini Ómasi noive. Lekeza ámina gakó gili gopa goha ikave, loko limó. ");
INSERT INTO gah_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Láa liki lova-leta iki niago, monó mogona apí-okimiaká ve makolímo oake gámemé oko geleake Izesú nene ale lamaná oko ale viligoko lo nokimigo geleake, loká otake láa loko limó: Mosé lo hukoko li gakokutí hilímo kivilegeko napáa neve. ");
INSERT INTO gah_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Loko lokago, Izesú láa loko lo amimó: Napa nenémo lá oko neve: Lekeza Isilae vese gililo. Guivahani Ómasile nene Guivahani hamokó noive. ");
INSERT INTO gah_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Likigika lekemeni geleakatini zámuzatini mukí nene Guivahani Ómasitiniloka amilo. ");
INSERT INTO gah_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Itó gakó napa makó nenémo lá oko neve: Gezakamú geleaká noanimómáminoko gigivekaginimú geleko gigika kemezo. Loko loketa gakokutí napáa makó iteko minamive. ");
INSERT INTO gah_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Loko lokago, monó mogona apí-okimiaká vemámo láa loko lo amimó: Tisalemaka, gakó nene lamaná lokane. Nene gelekugo etokave. Ómasi hamokó noive, Ómasi makó nomive. ");
INSERT INTO gah_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Itó ligika nemó gele vevesoakate nemó zámuzate nemó mukí aitoka amitunimó itó lezatemú geleaká nounimómáminoko ligivetegikumú geleko ligika kimitunimó nenémo Ómasi guguni gizo ameaká netá haitopaitolímini nene avilegekave. ");
INSERT INTO gah_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Loko gele vevesoko lokago, Izesú geleake láa loko lo amimó: Ómasi alémo geí gizapa ogetati ve loló itani gamena nene hotó nomive. Loko lokago, giliake, netá makokumú goha loká itatakumú kelegesá legekago, loká itamamó. ");
INSERT INTO gah_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Izesú monó zagusave napagú monó lo keme keme noike láa loko limó: Monó mogona apí-ikimiaká vete nene gologí oleketative loko lo mololeketa ve nene agulizaki ve napate Tevitini agávolaho noive liki nanamú liaká niave. ");
INSERT INTO gah_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Tevití eza Ómasímini Sikalahú nenémo agikagú alémo vávani okago láa loko limó: Mezaú ve eza není Guivahaníne nene není nigizani zamagaloka minoloko voko noako, mukí gala vega nene gigisa lapuvauka ahuloketanogo uve loko lo amimóma neve. ");
INSERT INTO gah_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Tevití nene gologí oleketative loko lo mololeta vemú nene Guivahaníneve lokamó nenazo, gologí oletative loko lo molota vémo nana igo Tevitini agávolahogó noitive. Tevitini agapilamola noitimóza, Tevitini ve napagi noitive. Loko Izesú noligo, alegesá iki mina vegená mukí nenete giliake laga kivisimó. ");
INSERT INTO gah_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Izesú nene monó lo nokimike miní ameko láa loko lo kimimó: Monó mogona apí-ikimiaká vemú, ehe. Kugupeló netá hána luhatakumú itó maketiloka mihina niago vegená makolite gekévaké likitatakumú, ");
INSERT INTO gah_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","itó monó numukú numukú nene vegená mukilitini kovogisaló minoaká holomaló minatakumú, itó nosánetá napa ninató nene agepaló siakumukó nene netakumú kumu heleaká noive. ");
INSERT INTO gah_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Keza gevoná venalitini henokanoni gumina ali asú iká itó kegepatunú soza miliki agepoka hána liki Ómasiloka liká iaká nianazo, ámina ve nenete miniki lihima napa genavagi alinigave, loko limó. ");
INSERT INTO gah_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Izesú eza monó zagusaveú nene moni miliaká pokisi gahevaloka minake, vegená mukilite ámina pokisigú moni nimilago ánigo minamó. Ánigo noigo, henóinigi vegená mukí nenete moni mukí miliva miliva niago, ");
INSERT INTO gah_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","gohogó vená gevoná makolímo oake golohá moni koma lositá nene pokisimagú ahulamó. ");
INSERT INTO gah_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Lá okago, Izesú nene izegipala zuha sele lo kemeake láa loko lo kimimó: Neza lamaná lo likimitoze, gililo. Vegená mukí imanete vaí iki milina monigutí nahulamóza, gohogó vená gevoná imanémo gohogó noikutí netá matala mukí nosánetá meina hizitimoláa ahulo asú okave. ");
INSERT INTO gah_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Nenemú gohogó vená imanémo moni miliaká polisigú ahula monimámo mukí vegenalitini moni avilegeneimó gelekave, loko limó. ");
INSERT INTO gah_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Izesú nene monó zagusavegutí nolimigo, izegipala zuhagutí makolímo láa loko lo amimó: Tisalemaka, ánigozo. Imane geha numuni lagámini ali tolova iki ginamó neve. ");
INSERT INTO gah_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Loko lokago, Izesú láa loko lo amimó: Áimáa numuni napa imanemú nolape. Itína nene ha nego nánigamóza, minoko lova gala ve keza imaneló gehani apiliki tele vizikiko gehani nene amupiló amupiló iki mililiki itekutí gululupaso asú inogo ive. ");
INSERT INTO gah_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Loko loake, Izesú nene izegipala zuha Olivi agokaloka kelémoko iteake, monó zagusave helegaloka nego, neneló minake, Pitá Zemusí Zoní Etulú kezagó Izesú noitoka vake loká itake lamó: ");
INSERT INTO gah_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Itína netakumú lanimó nene nanahé gamena utó itive, itó lani gamena nene alitanogo noiko nana anosa utó okiko ánigatune. Lo lemezo. ");
INSERT INTO gah_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Liki likago, Izesú láa loko lo kimimó: Ehe, gizapa ilo. Ve makolímo lokogoka vizekatize. ");
INSERT INTO gah_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Vegená mukilite nanitiki není nugulizató liki okulumakutí lumu ve gihila nezama nouve liki vegená mukí kogoka vizinigave. ");
INSERT INTO gah_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Lekeza haitopaitó lovámini gakola nigiliki itó lovatini konó nigiliki nene mulutini itemino. Ámina netá utó itimóza netá matá velesá asú aminogo ive. ");
INSERT INTO gah_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Numutó namató vegená makó nenete gala venini lova ali nikimiko, agulizaki ve makolímini zuhagi itó makolímini zuhagi lova hizinigave. Itó mukí mikasiuka imimá noiko gaúna gamena mukí utó itimóza, ámina netá utó itimó nene venalite izegipa getanigi miluma giliaká niamó nenémini oko utó inogo ive. ");
INSERT INTO gah_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Lá onoize, lekelisi gizapa keké viziki ilo. Gakó hoza alilikimiiki gonitó likilímiki vinigave. Itó monó numúikú numúikú nene segi nogosanitunú likipilitamó neve. Není nugulizá lekelitoka minakumule liki kugulizaki ve napatini itó kiapegini kovogisaló likilími milikiko keí kovogisaló oti miniki není mogona li kiminigave. ");
INSERT INTO gah_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Lá itamóza, gamena litá oko asú aminogo ive. Goí oko Ómasímini gakó lamaná nene numutó namató puu loko vitive liki li hutilí i asú inigave. ");
INSERT INTO gah_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Likigizató aliki likilímiki viki goní ilikitata gamena nene, nanave loko litupe liki lakagata giliko gena amino. Gamena nene zupa Sikalahulímo likigikagú gakó mololikimikiko áminagó nene lilo. Lélisi lupe lamiki Sikalahulímini gakó loló ino. ");
INSERT INTO gah_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ámina zupahé nene uvolaho makolímo agunala agizató alekoko goní omikiko agunala nene apili hilinigave. Amelaho nene gipala agizató alekoko goní omikiko nene gipala apilinigave. Izegipáini nenete izóikini améikini lova ali kimiiki likiko izóikini améikini kipili hilinigave. ");
INSERT INTO gah_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Není nugulizá lekelitoka minakumule liki vegená mukilite mukahá likipilinigi niamóza, vegená makolite gamenáini asú amititó monó ahulamiki alévolé iki vitamó nene Ómasímo kugutó vizinogo ive. ");
INSERT INTO gah_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Minoko lekeza nene mu likizapa iti netá golesa nene minamoaká apatoka apá ale golesa oaká netá nenémo oteneiko ánigatave. Imane gakó gatatanimó neneka imane nolu gakokumú gele guni ozo. Ámina gamenaló Zutaia mikasiuka nita vegená nene golisi iliki agokaloka ititakumule. ");
INSERT INTO gah_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Keí numupitó nita vegená nene golisi iliki limiki numúikú henoníini ma aliki vamitakumule. ");
INSERT INTO gah_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Itó mikú noiti ve nenémo luhoaká gó alitove loko numunaloka atiginá oko vamitikumule. ");
INSERT INTO gah_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Kee, izegipa kagatupagi nita venaki izegipa namuni aminí nikimita venaki nene ámina gamenaló nene nana itamó neve. ");
INSERT INTO gah_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Lekelisi nolu netá nene golini gamena utó amitive liki Ómasiloka liki minalo. ");
INSERT INTO gah_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ámina gamenaló genavagi netá utó itimó nenémo Ómasímo apí oko netá matá ale utó i gamenalotí emane utó osá ami netá nene minoloko itike itike imane gamenaló utó amive. Nolu gamenaló utó okoko nenémini veletó goha utó aminogo ive. ");
INSERT INTO gah_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Guivahanímo ámina miluma gilita gamena ale atuhá amitimó nene, vegená makó ma kavasavagi minamitamó nemóza, kelémo etó onoi vegenakumule loko ámina gamena nene ale atuhá inogo ive. ");
INSERT INTO gah_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Nene gamenaló ve makolímo ánigalo, gologí oletati vema imaneloka utó okave, itó ánigalo, volaneloka utó okave loko lo likimitimó nene, ámina gakó gili zagemilo. ");
INSERT INTO gah_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ámina gamenaló nene gologí oleketati ve sozámini itó Ómasímini agepagutí gakó liaká ve sozámini utó iiki vegenalite sigaga lita netaki soza avevezaha sunigi aliiki Ómasímo kelémo etó onoi vegená kogoka vizitupe liki lá inigave. ");
INSERT INTO gah_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ehe, nolu netá nene utó onamigo mota lo lekeme asú okuve. Nenemú gizapa alévolé iki minalo. ");
INSERT INTO gah_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ámina gamenaló ámina genavagi netá asú okiko, ho noiteko litá oko límugusi zekiko ikanímo hize sata amiko, ");
INSERT INTO gah_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","sonohí nenete okulumatotí atohiki velehé nilimiko, okulumakú amuzavagi netá mómoká i asú niko ");
INSERT INTO gah_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","okulumakutí lumu ve gihila neza zámuzánegi itó lapanánegi nene límusi amupiló nolumugo ániganigave. ");
INSERT INTO gah_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Lá okiko, agelogini kimiselekugo, kelémo etó onou vegená ho noititokatí ho nolimitokatí itó ezega emegatí itó mikasi nekisa vokisaukatí kilími nupa inigave. ");
INSERT INTO gah_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Gohunagitana zamú anoza gakola nemó nene gili vevesiki gililo. Izanámo nene nagamila nego agila guluma sekago lekeza ánigiake ho gamena mota alitokave liki giliaká niave. ");
INSERT INTO gah_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Itó ámináminiki lo lukumu netá nene utó noiko ánigiiki ve napate nene gatekú omo ávatiha okave liki litaze. ");
INSERT INTO gah_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Neza lamaná lo likimitoze, gililo. Imane gamenaló nia vegená velesá hili asú inamiko nolu netá mukí nene utó inogo ive. ");
INSERT INTO gah_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Okulumaki mikasigi tolova itáiha, není gakó nene ma gopa oko tolova aminogo ive. ");
INSERT INTO gah_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Lá onoimóza, ámina gamenamú ve hamoláate keké gelemave, itó okulumakú ageló keza ma gelemave, itó Ómasímini gipala noutímina ma gelemuve. Améneho hamokó áisigó geleneive. ");
INSERT INTO gah_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ato gamenamú lekeza ma gelemanazo, ehe, gizapa i guni iki minalo. ");
INSERT INTO gah_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Lá oko neve. Ve makolímo venoni vinogo nooko numuni apala ahuloko vinogo noike gelekelé izegipala nene mukí hoza nene etó etó oko kigizakú moloko netá matalaló gizapa initatave loko ahulokimiake gatetó gizapa ve nene gizapa oko minozo loko lomiake vimó. ");
INSERT INTO gah_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Nenemú numuni amelahoma ati gamena nene gánavaló ahe akovevé ahe gó anuva noikohe gokululuva notovoikohe lekeza ma gelemanazo, nenemú gizapa i guni iki minalo. ");
INSERT INTO gah_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Lokovó akiniko galinali oko ánigolikimikatize. ");
INSERT INTO gah_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Lo nolukumu gakó nene lekelikumukó lamuve, vegená mukikumú noluze. Lekeza nene gizapa iki minalo, loko limó. ");
INSERT INTO gah_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Avóikini asenini zeketakumú gili mina holisigú lulu vizemi peleti niaká a holisi alitokago, gamena lositá ha nego, guguni giziaká ve napagi itó monó mogona apí-ikimiaká vegi keza láa liki lamó: ");
INSERT INTO gah_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Vegenalite lova napa ali utó iki lipilikatanazo, holisigú nene Izesuni apelemitune. Lá onoinazo, asuguná oko Izesuni agizató aleko apele hilitune liki gakó liki liake nenémini gapomú vitagá amó. ");
INSERT INTO gah_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Lá noigo Izesú nene Petania numutoka noike Saimon eza halamé netá gizaleake minake zoka vémini numukú iteko nosánetá noko noigo, vená makolímo gehanigitana goni aleake, agepáa zeko ategeake áminagú nene anuva lamanaki uveli agulizá nalita nene meinava iteko mina netá nene Izesuni gotolaló leketamó. ");
INSERT INTO gah_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Lá okago, ve lugáate mulúikú golesa okago, kezáitoka lamó: Uveli lamaná nene nanamú latila ive. ");
INSERT INTO gah_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ámina uveli nene hanuva minalina meinaváa moni 300 kina alekinake gohogó vegená kumutiline. Liki liake gahá amikago, ");
INSERT INTO gah_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Izesú geleake láa loko lo kimimó: Ahulitalo. Nana igo gena gakó li nameve. Vená imanémo netá lamaná alenimikago etokave. ");
INSERT INTO gah_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Gohogó vegená keza lekelitoka gamena hána miniliki viki minanigi anazo, kelémo lamaná itune liki nene kilími lamaná itamóza, neza lekezagi minoloko voko minaminogo uve. ");
INSERT INTO gah_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ezáa loló itove loko agata gili netá nene loló okave. Alika nénisi helekugo gonosi milimiligú gale zinitatakumú agata geleake nugupeló anuva lamanaki uveli holonimikave. ");
INSERT INTO gah_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Neza lamaná lo likimitoze, gililo. Makó mikasiuka není gakó lamaná imane li utó iki li kimitató li kimitató nene imane venalímini mogonamú gili zagitave liki eza loló oneta sunimuki li kiminigave, loko limó. ");
INSERT INTO gah_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Lá okago, Izesuni izegipala zuha keikutí ve makó agulizá Zutá eza Kaliotó apatotí ve nenémo guguni giziaká ve napa niatoka vike Izesuni amimika loko alémoko oko likigizakú ahulatove loko lo kimimó. ");
INSERT INTO gah_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Lo kemekago, giliake, mulúikú lamaná okago, age nonó lá oko gimitune liki Zutani agómulaló li hutikago, geleake Izesuni amimika linogo amapani molamó. ");
INSERT INTO gah_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Lulu vizemi peleti niaká a holisímini ganá gamena nene avóikini asenini zeketakumú gili minake sipsip iza akaleva apiliaká a gamenaló nene, izegipala zuhate Izesuni loká itake lamó: Asenini zeketakumú gele minoaká holisímini nosánetá nene hiláauka viki ali vavá initatave loko nolane. ");
INSERT INTO gah_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Liki likago, izegipala zuhagutí ve lositá nene nokimisilike láa loko lo kimimó: Zelusalega nanitisiko ve makó eza paisele somo nagamilagi geheneike gapoló hotu nilikima nene ámina ve ámegetiki vilizo. ");
INSERT INTO gah_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Lá iki viki ámina ve nene numukú itekiko numuni amelahini láa liki li amilizo: Tisalémo nezagi izegipáne zuhagi asenini zekimiaká nosá natuni numuni agika hiláauka neve loko lokago nousive. ");
INSERT INTO gah_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Liki likisiko, numuni agika veletó nego netá matá avilisá ohá lekelepizekiko neneló nosánetate ali vavá ilizo. ");
INSERT INTO gah_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Loko lo kemekago, izegipala losima keza gili alikasike taoniló vi anitikasike ánigasimó nene Izesú lo kimimómáminoko nego ánigikasike asenini zekimiaká holisímini nosá ali vavá asimó. ");
INSERT INTO gah_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Lá ikasigo, límugusi zekago, Izesú nene izegipala zuha 12-agi ali nupa iake, ");
INSERT INTO gah_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","nosánetá niki niake, Izesú láa loko limó: Lamaná lo likimitoze, gililo. Lekelikutí nosánetá nonuhakutí ve makolímo nimimika linogo ive. ");
INSERT INTO gah_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Loko lokago, keza miluma nigeleke hamopamó li amiki nenikumú nolape. ");
INSERT INTO gah_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Liki likago, eza láa loko lo kimimó: Ve 12 lekelikutí hamó lapegutí peleti nagamí zeko natíi ve nenémove. ");
INSERT INTO gah_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Okulumakutí lumu ve gihila nenikumú monó gotolaú luhuva gizinamómámini oko hilito gapogú novumóza, nimimika loko nelémoko viti vema agae, lihima sipisi alinogo ive. Izolaho aí getamilina nene vávani oko minaline, loko limó. ");
INSERT INTO gah_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Nosánetá ninake Izesú nene peleti aleake Ómasi agepoka loake gitegeko nokimike láa loko limó: Aliki nalo. Imane není mémeláne neve. ");
INSERT INTO gah_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Loko loake vain goni aleake Ómasi agepoka loake, kemekago, nenegutí mukitó ninago, ");
INSERT INTO gah_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","láa loko lo kimimó: Lo múnaheaká gakolímini golaníne nene vegená mukikumule loko lekitomó imane neve. ");
INSERT INTO gah_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Lamaná lo likimitoze, gililo. Vain gihilagutí goha naminake minoloko vinake Ómasímini agulizaki vetipo loló oleketato gamena nene vain nagamí haitolímini natove, loko limó. ");
INSERT INTO gah_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Láa loko lokago, monó nama makó liake limiake, Olivi agoka agisauka anitiake, ");
INSERT INTO gah_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Izesú láa loko lo kimimó: Monó gotolaú nene Ómasímo li gakó nene láa liki luhuva gizinamóma neve: Gizapa ve apelekugo sipsip iza nene hutilí iki golisi inigave. Liki gizinamóma nenazo, lekeza mukitó není visilinitanigave. Lá onoitimóza, ");
INSERT INTO gah_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","helekugo goha nelémo otekiko, Galilaia mikasiuka goí o likiminogo uve. ");
INSERT INTO gah_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Loko lokago, Pitá láa loko lo amimó: Neza viselegetamitove. Keza mukitó gele alévolé oakáini nene gologolo sokikoma nénisi nene lá aminogo uve. ");
INSERT INTO gah_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Loko lokago, Izesú láa loko lo amimó: Lamaná lo gimitoze, gelezo. Itína holugú nene okolohomámo anó losi molonamiko nenikumú ánigamuve loko gamena losive makole egamega onetanogo ane. ");
INSERT INTO gah_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Loko lokago, Pitá pigi vizeko limó: Neza geikumú egamega ogetaminogo uve. Nipili hilinigi niko, gezagi helekusigoma nene lá ogetaminogo uve. Loko lokago izegipa zuha mukitó keza alími vatí ake ámina gakokó lamó. ");
INSERT INTO gah_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Lá ikago, apá makó agulizá Gesemane loko neneló vi anitiake, izegipala zuha láa loko lo kimimó: Lekeza imaneló niko neza voko Ómasiloka litoze. ");
INSERT INTO gah_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Loko loake, Pitanigi Zemusinigi Zoninigi kelémoko voake, Izesú nene mulunagú peisi nozigo miluma geleake, ");
INSERT INTO gah_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","láa loko lo kimimó: Mulúnegú gónupa geake hilitomó noize, lekelisi nene imaneloka miniki gizapa iki minalo. ");
INSERT INTO gah_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Loko loake, koma minomo novike mikasigú agoka nohizike Ómasiloka láa loko limó: Aménega, genavagi gihito netá imane gelekako nivilege vitive loko noluve. ");
INSERT INTO gah_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Loko nolike láa loko limó: Aménegamaka, geza mukí netá loló itove loko gagata gilitani netá nene vávani okogó loló itanimó nenazo, genavagi gihinitata netá imane nenitokatí ale olové itane loko nogulumóza, není nigikaloka molamoko geí gigikaloka nelémo molatane loko noluve. ");
INSERT INTO gah_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Loko loake, oake izegipala zuha ánigamó nene, kovó akinago ánigoake, Pitani alémo otike láa loko lo amimó: Saimon geza akonape. Geza gamena koma gizapa oko ote minamitape. ");
INSERT INTO gah_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Lekemekú milatakumú gopa ikatanaze, gizapa iki miniki Ómasiloka liki minalo. Likigikámo vávani noimóza, lukugupémo gena noive. ");
INSERT INTO gah_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Loko lo kemeake, goha vike ámina gakó like Ómasiloka loake, ");
INSERT INTO gah_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","atiginá oko ánigamó nene, kogómula ahihí okago kovó akinago ánigamó. ");
INSERT INTO gah_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Lá okago anotó aliki li amita gakokumú vitagá amó. Goha ago nene losive makole okago, Izesú lo kimike limó: Lekeza lakavasú viziki hanuva aki niminahe. Ánesile. Gilinahe. Okulumakutí lumu ve gihila neza lihimáinigi vetini kigizakú nimimika liki nilími milata gamena mota alitokave. ");
INSERT INTO gah_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Otilo, mota vitunize. Ánigalo. Nimimika liti vema mota alitó okave. ");
INSERT INTO gah_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Láa loko lo kemeko noigo, izegipala 12 keikutí kigivéipo makó Zutá noago, vegená mukí keza ámegetiki niake gelekahosigi sopolo hánagi ali minake amó. Keza nene guguni giziaká vegi monó mogona apí ikimiaká vegi monó gizapa vegi keza emane amunaloka kimisilikago, ");
INSERT INTO gah_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","nivake amimika liti vemámo gakó makó láa loko limó: Novinake ve makó agoka legeko nonugo nene ánigiiki ámina ve noive liki agizató aliki gizapa itiki alímiki vilo. ");
INSERT INTO gah_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Loko loake ake, Izesú noitoka litá oko vo amatoka aniteake, oho, tisatehove nolike agoka legeko namó. ");
INSERT INTO gah_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Lá okago lova ve nenete ake Izesuni agizató ali gikitiki alemó. ");
INSERT INTO gah_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Lá niago, amatoka mina vegenakutí makolímo aí sopolo hána nene golagutí segeake guguni gizoaká ve napámini gelekelé izegipala apilike agata zeko isimó. ");
INSERT INTO gah_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Lá okago, Izesú nene lova vema láa loko lo kimimó: Neza nene laskoli nougo sopolo hánagi itó gelekahosigi aliki niake nigizató alitune liki niahe. ");
INSERT INTO gah_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Gamena gamena lekezagi monó zagusave napagú minuke monó lo keme keme oko minumómaló nigizató alisá amamó nehe. Lá ikamóza, emane amunaló nenikumú monó gakó luhuva gizinamó nene alévolé itive loko netá imane utó okave. ");
INSERT INTO gah_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Loko lokago, izegipala zuha nenete ahulimiake golisi hutilí iki vamó. ");
INSERT INTO gah_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Lá ikago, gosohá ve makolímo gó gizopa agupeló likeake Izesuni nene ámegetoko novigo, ámina ve nene agizató alikago, ");
INSERT INTO gah_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","góma nene gololohá oko ahulo kigizakú oake agupe zapakó golisi vimó. ");
INSERT INTO gah_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Lá okago, Izesuni nene guguni gizoaká ve napa noitoka alímiki vikago, guguni giziaká ve napagi itó monó gizapa vegi monó mogona apí ikimiaká vegi alegesá iki minakú alímiki itemó. ");
INSERT INTO gah_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Izesuni alímiki nivago, Pitá nene hotó otigí oko kémegetoko vike, guguni gizoaká ve napámini hé numunagú áneneló iteko ámina vémini gelekelé izegipategi minake lotó agupe lotá oko minamó. ");
INSERT INTO gah_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Lá noigo, guguni giziaká ve napagi keí kansolegi mukitó nene Izesuni apele hilitune liki soza hakupá gakóinimú vitagá amóza, ");
INSERT INTO gah_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","hakupá gakó la ve nenete gakóini hamó lamamó. Mukí liki amupesamó nenazo, ali utó amamó. ");
INSERT INTO gah_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Makolite otiki hakupá gakó aikumú láa liki lamó: ");
INSERT INTO gah_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Eza nene monó zagusave napa kigizanitunú ginamóma imane zeko tele vizekinake, gamena losive makole noviko goha nigizanitunú gemitoha hanuva lokugo utó inogo ive loko noligo gulunimole. ");
INSERT INTO gah_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Liki lamóza, gakóini nene hamó gapoló vamigo, ");
INSERT INTO gah_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","guguni giziaká vetini ve napáini nenémo holúikú oteake Izesuni loká otake goní nigitake nila gakotó geza ale viligoko lo kimitani gakó ma nomihe. ");
INSERT INTO gah_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Loko limóza, Izesú nene agepa apizeake minake gakó ale viligoko lo amemigo, guguni giziaká vetini ve napa nenémo goha loká otake limó: Geza gologí oletatane loko lo mola vema Ómasi agepoka loaká nouhámámini gipala noape. ");
INSERT INTO gah_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Loko loká omikago Izesú limó: Oo, nene mota nolane. Itó makó lo likimitoze, gililo. Okulumakutí lumu ve gihila neza amuza vémini agizani zamagaloka nougo, itó okulumalímini límusigú nolumugo ániganigave. ");
INSERT INTO gah_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Loko lokago, guguni giziaká vetini ve napa nenémo gele golesa oake luhoaká gola aleko polo noligike vegenala zuha láa loko lo kimimó: Gakola gilina vegená makó nanamú sele lokinake gakó goha lokiko gilitune. ");
INSERT INTO gah_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ómasi avilegeko li gakó mota gilikaze. Nenemú lekeza gilikago nana onoive. Loko lokago, keza mukilite nakahunímini gakó lokaze, mota losé apilitune liki li hukitake, ");
INSERT INTO gah_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","lugáate gituhú itake agoka agepaló nihitake kigizanitunú napeleke lamó: Geza gakó mogona lo utó oaká ve noitanimó nene, éaho nogipilihe lo utó oko lo lemezo. Liki likago, gelekelé izegipáinimate kigizanitunú apelemó. ");
INSERT INTO gah_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Lá niago Pitá nene hé numuni amunaloka noigo, guguni gizoaká ve napámini gelekelé mohola makolímo oko ánigamó nene, ");
INSERT INTO gah_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pitá nene agupe ló lotá oko noigo, ánigoake gonú napilike geza nene Nasalete numutotí ve Izesuki miniaká niasi vema noane. ");
INSERT INTO gah_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Loko lokago, Pitá eza egamega ike gakó lanimó nene ma gelemuve, itó mogonáa gele vevesamuve. Loko loake, gatekú nolimigo, ");
INSERT INTO gah_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","ámina gelekelé mohó nenémo aí goha ánigoake alegesá iki mina vegenáma lo kimike ve imane Izesuni zuhagutí noive. ");
INSERT INTO gah_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Loko lokago, goha egamega hulupaváa imó. Lá okago, gamena komáisí neigo áminaló oti mina vegenalite Pitani goha láa liki li amemó: Géisi Galilaia ve noaninazo, géisi lamaná Izesuni zuhagutí noane. ");
INSERT INTO gah_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Liki likago, eza Ómasímini avogisaló lo hutoko lamaná noluze, soza litomó nene Ómasímo usí vizenimikatize, lekeza gakó nila ve nene ánigonamu vemú nilave, loko limó. ");
INSERT INTO gah_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Loko noli agepagi okoloho nenémo goha anó molamó. Anó molokago, Pitá nene Izesú lo ami gakó nene, okoloho nenémo gamena lositá anó molonamiko není ánigonamuve loko egamega onetatanimó nene gamena losive makole inogo ive loko amunaloka lo ami gakó goha geleake ive napa imó. ");
INSERT INTO gah_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Neteká ho noitigo, guguni giziaká ve napagi monó gizapa vegi monó mogona apí-ikimiaká vegi monó kansole ve mukí kezagi lova gizi hutiake Izesuni nene nagá zimiake alímiki vake Pilatoni agizakú milamó. ");
INSERT INTO gah_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Lá ikago, Pilató nene Izesuni ánigoake loká otake geza nene Zuta vetini kugulizaki ve napáini noape. Loko loká omikago, eza láa loko lo amimó: Nene gezaka mota lokanimole. ");
INSERT INTO gah_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Loko lokago, guguni giziaká ve napamate mukí netakumú goní imikago, ");
INSERT INTO gah_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilató goha loká otake limó: Geikumú gakó genavagi nilamó nenazo, geza gakó ale viligoko lo kimitanimoláa ma nomihe. ");
INSERT INTO gah_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Loko loká omikago, Izesú gakó ale viligoko lo kememigo Pilató nene agata gululusi gilimó. ");
INSERT INTO gah_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Kiapé eza Zuta vetini avolagini asenini zeketakumú gili mina holisigú meleketó meleketó nene Zuta ve keza aseva zetatane liki ve makolímini agulizá ikago, agulizaki ve nenémo nagá numukú ahulikita ve kimisele ahuloká ahuloká okago, ámina ve nene numúitoka viaká amó. ");
INSERT INTO gah_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Lá imó nene gamena nene zupa ve makó nagá numukú minamó, agulizá Palapasí. Áisi nene vegená lugáa kelémo vatí ike gamaniloka lova gizakú nene ve makó kepele hilimó nenazo, nagá numukú ahulimikago minamó neve. ");
INSERT INTO gah_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Lá okago, vegená mukí nenete Pilató noitoka vake eza aleaká imómáminoko alitive liki loká imikago, ");
INSERT INTO gah_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","guguni giziaká ve napa nenete Izezukumukó amekugú niki miniake gonitó alímiki vakumú nene Pilató geleneike láa loko lo kimike limó: Láa likima Zuta vetini agulizaki vetipo nene aseva zemikugo lekelitoka vitive liki nilahe. ");
INSERT INTO gah_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Loko limóza, guguni giziaká ve napa nenete vegená mukilitini mulúikú hizikago ");
INSERT INTO gah_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","aitotí Palapasini aseva zetamane liki likago, Pilató goha lo kimike limó: Zuta vetini kugulizaki véini noive liki liaká nia vemú nene nana otatove. ");
INSERT INTO gah_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Loko loká okimikago, goha gopaga liki zohota zaló hilitikumule. ");
INSERT INTO gah_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Liki likago, Pilató nene nanamú. Nana netá golesa alekago nilave. ");
INSERT INTO gah_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Loko lokago, keza goha gopaga liki likago, Pilató nene ali nupa imina vegenalitini mulúikú hulu itive loko Palapasini gologí omikago keitoka vimó. Itó Pilató lokago, Izesuni nene segi nogosanitunú apiliake viki zaló nilitunú ziki apili hilitave loko kigizakú molamó. ");
INSERT INTO gah_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Lá okago, ami vemate agulizaki ve napamámini numuni holutó nene Izesuni alímiki iteke ami ve lugáa mukí kilími nupa ake, ");
INSERT INTO gah_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","agulizaki vegitana lilí itake okohu gó luhimiake gasovagi nagatunú akilí lilí iki gotolaló hitimiake, ");
INSERT INTO gah_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","amé ziki geké litake oga mokáneve, Zuta vetini kugulizaki véinimave. ");
INSERT INTO gah_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Liki liake, akepa nogosanitunú gotolaló ziake gituhú nitake agisagú gupá nizeke soza miliki agoka agaka vizemó. ");
INSERT INTO gah_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Lá ake gopoguka li asú itake okohu gó luhitamó nene gololohá iki ali miliake ezáa gola luhimiake, zohota zaló nene nilitunú ziki apili hilinigi alímiki vamó. ");
INSERT INTO gah_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Lá iake gapoló nivago, ve makó agulizá Saimon eza Apilika mikasiuka Sailini apatotí ve Alesaté itó Lupú keí améipo nene minaukatí noago, hotu liake gala vizikago, Izesú geheko vi za nene alémo vatí oko gehetoko vimó. ");
INSERT INTO gah_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Lá noigo, alímiki vake apá makotoka agulizá Goligota loko, lelí gakokutí nene gotóini gonosi helisa apale loko neneloka anitiake, ");
INSERT INTO gah_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Izesú native liki vain nagamikú nene miluma gelemiti lusa netá makó agulizá mulu nene miliki ali gopa iake amemóza, namimó. ");
INSERT INTO gah_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Namigo, zohota zaló nene apiliki apatiake gineganeva gona miliki aliki éaho alitihe éaho alitihe liki satu zohí amó. ");
INSERT INTO gah_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Lá iki apelemó nene gó loake ho ite alévolé noigo, zaló apiliki apatemó. ");
INSERT INTO gah_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Lá ikago, nakahunímini gakó luhuva nene Zuta vetini kugulizaki véinive liki giziake apatemó. ");
INSERT INTO gah_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Itó laskoli ve geligeli ve makó nene agizani sogaloka apatemó, itó makó nene agizani zamagaloka apiliki apatemó. ");
INSERT INTO gah_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Lá ikago, vegená vigá igá amó nenete gotóinitunú goké goké nizeke amé ziki gopoguka litake láa liki lamó: Oho, monó zagusave zeko tele vizekinake gamena losive makolegó oko vokiko goha gitove loko loaká anitika, ");
INSERT INTO gah_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","gugutó vizeko zohota za ahulokoko lememane. ");
INSERT INTO gah_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Liki nilago, guguni gizoaká ve napagi monó mogona apí ikimiaká vegi keza hamolímini iki amé ziki gopoguka litake kezáitoka láa liki lamó: Vegená lugáa kelémo kugutó vizeaká noimóza, ezáa nene alémo agutó vizemitimó okave. ");
INSERT INTO gah_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Eza nene Isilae ve lelí gologí olimiaká ve itó lelí agulizaki ve noitimó nene itínasa zohota zalotí apasoko lemekiko, ánigokinake gakola gele alévolé ituninazo. Liki likago, keza luga luga zohota zaló kipiliki apate ve nenetosa áminámini iki kilími vatí asike amé zitigí iki lasimó. ");
INSERT INTO gah_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Holisakatotí mukí mikasiuka límugusi ze asú oake mino-loko novigo únaká ho nene ale zohota imó. ");
INSERT INTO gah_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ho ale zohota noigo, Izesú pigi vizeko ezáa gakokutí nene Eloi, Eloi, lama sapakatani loko limó nene lelí gakokutí nene Ómasinemaka, Ómasinemaka, geza nanamú viselenimikane. ");
INSERT INTO gah_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Loko lokago, amatoka mina vegená lugáate nene gakó giliake láa liki lamó: Gililo. Ómasímini agepagutí gakó loaká ve Ilaizani sele nolive. ");
INSERT INTO gah_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Liki liake ve makolímo ololu loko vike notunigitana netá legeake akepa lolovaló hizeake ekesá vain nagamikú lupizeake ale oteko Izesú native loko amimó. Namike láa loko limó: Ánigatune. Ilaizá oko apasotatihe loko gizapa onoitune. ");
INSERT INTO gah_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Loko lokago, Izesú gakó napagutí like, ahuu lo nahulake hilimó. ");
INSERT INTO gah_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Lá okago, monó zagusave napagú Ómasímini avogisaló itiaká nia gatetó zi lí ika lavolavo nene velekutí zeko hoú loloko limike ale luga luga imó nene lelí gahe ale koló imó. ");
INSERT INTO gah_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Izesú nene ahuu lo nahulake helekago, ami vetini gizapa vémo Izesuni agómulaló noike imane ve nenémo lamaná Ómasímini gipala minamó neve, loko limó. ");
INSERT INTO gah_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Itó vená lugáate hotó otigí iki oti minake ánigi minamó. Keikuka nene Magatala numutotí vená Maliá minamó, itó Maliá makó eza Zemusí komáa itó Zosé keí izóipo itó Salomé nene makó minamó. ");
INSERT INTO gah_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Keza amunaló Izesú nene Galilaia mikasiuka noigo ámegetiki nivake izamuha hiziki minamó neve. Kezagi itó Izesugegi Zelusalega itina vená lugáa mukímagi neneló minamó. ");
INSERT INTO gah_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Únaká huluvaló nene holisi gamenamámini netá ali vavá iaká a gamena alitokago, holisi gamenama alitokago, gamena hamó ha nego, ");
INSERT INTO gah_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Alimataia numutotí ve Zosehé eza monó kansole vete agika itiake a vémo áisi Ómasímo gizapa ve napa ale utó oketati gamenamú gizapa oko mina vémo ahelele vizimó ze hitoake Izesuni gonosiváa alinogo Pilatoni nene loká omikago, ");
INSERT INTO gah_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Izesú mota hilihe loko agata losi geleake, ami vetini gizapa vema sele loake, mota hilihe loko loká otamó. ");
INSERT INTO gah_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Loká omikago, ami vetini gizapa vemámini gakó geleake, gonosiváamú nene Zosehé hanuva aleko vitive loko gele amimó. ");
INSERT INTO gah_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Gele amekago, Zosehé nene gonosiváa asapú otatikumú lavolavo gó mokoná lamaná meina hizeake gonosiváa nene zalotí apasoko ale mikasiló oake, gó mokoná lamanámagú asapú omiake aleko vike meikú geha mulí goló vateikamó nenegú molomiake, gehani napa makó ahelú oko geha mulilímini agepaló ze lí imó. ");
INSERT INTO gah_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Nenegú nomolago, Maliá eza Magatala numutotí vená itó Maliá makó Zoseni izolaho nene áminaló ánigi minasimó. ");
INSERT INTO gah_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ho lemekago, holisi mota asú okave liki liake, Magatala numutotí vená Maliá, itó Maliá makó Zemusini izolaho, itó Salomé keza Izesuni gonosiváaló anuva lamanaki uveli holotatune liki anuva uveli meina hizemó. ");
INSERT INTO gah_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Hiziki aliake, holisi napa Sategú nene gó lomolomo gonosi apakú viki nanitego, ho itimó. ");
INSERT INTO gah_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Lá okago, vake gonosi apató ali alitiake kezáini ligili hagili ake geha mulí agepalotí gehani napama nene éaho ale ámegeletative. ");
INSERT INTO gah_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Liki ligili hagili iake ánigamó nene, ámina gehani napa mota ahelú o ámegekago gale koló onoigo ánigamó. Ánigiake, ");
INSERT INTO gah_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","geha mulikú itiake ánigamó nene, gosohá ve makó nene luhoaká gó mokoná hána luhoake zamagaloka noigo, ánigiake ininá goha amó. ");
INSERT INTO gah_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ininá niago, eza láa loko lo kimimó: Lekeza ininá amilo. Lekeza nene Nasalete ve Izesuni zohota zaló apiliki apate vema ániganigi niahe. Imanegú noamive. Mota otekave. Gonosiváa milita apáma ánigalo. ");
INSERT INTO gah_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Itó ánigiiki viki Pitage itó izegipala zuha lugáamagi láa liki li kimilo: Amunaló lo likimimómámini oko goí o lekemeko Galilaia mikasiuka mota vokanazo, lekeza neneloka aí ániganigave liki li kimilo. ");
INSERT INTO gah_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Loko lokago, luvoluvo nizeke ininá anazo, hetoka limiake geha mulikutí golisi vamó. Ololu liki vake kehelele vizekago, vegená makó avetó iki li kememamó.  ");
INSERT INTO gah_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Izesú nene lelí holisi Sategú nene neteká holugú galegutí oteake, Magatala numutotí vená Maliá eza holosi golesa 7-a agikagutí kepeleko kimisele ámegeta vená nene ganá utó o amimó. ");
INSERT INTO gah_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Lá okago, eza vike agivelagini nene miluma maluma nigeleke ive nama iki niago avetó oko lo kimimó. ");
INSERT INTO gah_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Heleneikutí oteake hanuva noigo ánigokuve loko lo kemekago, giliake gili zagemamó. ");
INSERT INTO gah_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Nenelotí keikutí ve lositá nene gihisigú nivasigo, Izesú nene ametameni haitolímini ale luhoake utó o kimimó. ");
INSERT INTO gah_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Lá okago, keza atiginá iki taoniloka vasike vegená lugáa avetó iki li kemesimóza, gakó lasimó nene gili zagemamó. ");
INSERT INTO gah_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Alika Izesú nene izegipala 11 kezáikó alegesá iki nosánetá niki niago, utó o kemeake eza galegutí oteake noigo aí ániga vegenalitini gakó gili zagemamó nenazo, gili alévolé amakumú itó kigika hize lí ikumú nene gahá kimimó. ");
INSERT INTO gah_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Lá ike láa loko lo kimimó: Lekelisi nene numutó namató ho noititoka nolimitoka viki vegená mukitó niamó nene není gakó lamaná li kimilo. ");
INSERT INTO gah_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Lá ikiko gili alévolé iiki monó nagamí hilinita vegená nene okulumalímini mututoni itamóza, gili alévolé amita vegená nene meinímini mututoni inigave. ");
INSERT INTO gah_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Itó imane anosa nene gili alévolé iki minata vegenatoka utó oketanogo ive. Není nugulizá iki holosi golesa nene kipiliki kimisilinigave. Haitó konokutí galinali linigave. ");
INSERT INTO gah_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Gosihá nene gopa ali otiki minatamó itó gipe nagamí gopa natamó nene nenémo kelémo golesa aminogo ive. Kivisiti vegená nene kigizanitunú nónohá zikitatamó nene zokanigave, loko limó. ");
INSERT INTO gah_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Láa loko Guivahani Izesú lo kemekago, Ómasímo alémoko okulumakú itekago, eza Ómasímini agizani lamagaloka minamó. ");
INSERT INTO gah_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Lá noigo, keza izegipala zuha nenete numutó namató viake gakola li utó iki li nikemego, Guivahani nenémo kelémo vatí ike ámina anosa utó o kimitunú nene keí gakó hize lé oketamó. ");
INSERT INTO gah_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ve mukilite holutegú utó i netá nenémini gakoláa ali amegesaló miliki luhuva gizinamó. ");
INSERT INTO gah_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Keza nene monó liaká vete mogonalotí Izesuni netá mukí ánigi hee liake li utó iki li leme gakó luhuva gizinamó nenazo, ");
INSERT INTO gah_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","neza ámina oko ámina gakó lamaná nene legesó oko ale lamaná oko gele hee lokuke nene, Teopilo gugulizaki venemaka, geí nene ale etó etó oko luhuva imane gizo nogumumó nene ");
INSERT INTO gah_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","géisi nene gatoko avetó gakó li gememó nene gihila lamaná neve loko gilitane loko nogizuve. ");
INSERT INTO gah_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Zutaia mikasigú nene agulizaki ve napa Heloté gizapa oko mina zupa nene Ómasi guguni gizo ameaká ve makó minamó agulizá Zakaliá, Apiani mulusigutí. Eza Alonani agapilamokutí vená makó alimó agulizá Elisapeté. ");
INSERT INTO gah_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Keza Ómasímini avogisaló kigika lamanaki minasike gapo lota gakó Ómasímo lo hukoko li gakó lihimáini nomimó minasike gili alikigó minasimó. ");
INSERT INTO gah_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Elisapeté nene gohuna vená minokago, keza izegipáini nomimó minasike ozaha gelehosi milasimó. ");
INSERT INTO gah_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Zakaliani mulusi keza monó numuni napagú Ómasi guguni gizi amita gamena alitokago, ");
INSERT INTO gah_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","guguni giziaká vete aliaká amó nenéminiki hozanini ali etó etó iki alimi nivake, Zakaliani nene Ómasi guguni gizo amezo liki alími etó ikago, monó zagusave agikagú itike anuva lamanaki netá nene Ómasi guguni gizo namigo, ");
INSERT INTO gah_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","vegená mukilite geisa agikagú minake Guivahaniloka liki minamó. ");
INSERT INTO gah_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Nilago Guivahanímini ageló makolímo utó o amike guguni gizoaká ita lamagaloka ote minamó. ");
INSERT INTO gah_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Oteneigo, Zakaliá ánigoake ininá ike alegesá ligimó. ");
INSERT INTO gah_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Alegesá legekago, ageló nenémo láa loko lo amimó: Zakaliazo, geza gelegesá legemino. Guivahanímo numuna nolanimó nene mota geleneize, venaka Elisapeté nene izegipa agatupagi minoko gipa getatimó nene agulizá Zoní ave loko molozo. ");
INSERT INTO gah_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Geza mulukagú lamaná geleko gogoliza vizinogo ane. Itó vegená mukilite gipaka utó itikumú nene laga kivisinogo ive. ");
INSERT INTO gah_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Eza nene Guivahanímini avogisaló nene ve napa loló oko minative. Eza vain nagamí ahe itó negi nagamí ahe nonamoko moseko nominiko, izolahini agatupagú noikutí Sikalahulímo aí agikagú mino vaí itive. ");
INSERT INTO gah_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Lá okiko Isilae vegená mukí nene gapo golesagutí kelémo atiginá okiko, Guivahani Ómasímini kovogisa i aminigave. ");
INSERT INTO gah_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Eza Ómasímini agepagutí gakó loaká ve Ilaizá oaká imó nenéminoko amuza moloko Guivahanímini gapo veletoko aí gakó lo utó utó oko minanogo ive. Lá oko minoko olotiva vegenalitini itó izegipa komatini kigika ale apizeketative. Lá okiko gakó gili ahuliaká vegená nenete kigika lamanaki vete nigele monó nene kagata gámemé iki gilinigave. Itó eza ámina hoza alekiko, vegená mukí keza Guivahanimú ageva iki minanigave. ");
INSERT INTO gah_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ageló nenémo láa loko lokago, Zakaliá eza anotó aleko láa loko lo amimó: Venánegi leza ozaha gelehosima nousinazo, nenemú geí gakó gulugo gihiláa loló amive. ");
INSERT INTO gah_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Loko lokago, agelómámo láa loko lo amimó: Gelenape. Neza nugulizáne Gapelienama noluve. Neza Ómasímini avogisaló minoko aleko oaká noumóma neve. Áisi nimiselekago lumuke gakó lamaná imane lo nogumuve. ");
INSERT INTO gah_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Nenemú gelezo. Gakó lo nogumumó nene gele alévolé amanimómámini lihima nene gakó lamoko negi hizeko minoloko novako, minoko gakó lo nogumumó nene gihila ziti gamena nene gakó goha linogo ane. Neza nolu gakó nene hetagá aminogo ive. ");
INSERT INTO gah_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Loko lokago, Zakaliá eza monó numuni napagú gamena hána minokago, vegená keza ageva iki minake minake gopa kagata gelemó. ");
INSERT INTO gah_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Lá iki niago, Zakaliá alika limike gakó lo kiminogo gopa imó. Gakola gopa okago, keza nene monó zagusaveú netá haitolímini makó ánigonoitive. Liki nigelego, eza negi hizeake gakó nana oko lo kimitohe loko agizanitunú avevezaha o kimike gakó lo kememimó. ");
INSERT INTO gah_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Lá oko noigo, hoza aliti gamena asú okago Zakaliá nene numunaloka atiginá oko vimó. ");
INSERT INTO gah_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Alika venala Elisapeté nene izegipa agatupagi minamó. Lá oake ikani 5 oko novigo halá geko minake, ");
INSERT INTO gah_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Guivahanímo gamena molamó nene alitokago Guivahanímo hize lé onimiake gohuna vená minukumule loko novoza hulu netá monéna ale ahulonimikave, loko limó. ");
INSERT INTO gah_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Lá okago, izegipalagi minatotí ikani 5-a ale ahulokago, Ómasímo ageló Gapelienima goha amiselekago Galilaia mikasiuka Nasalete numutoka vimó. ");
INSERT INTO gah_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Neneloka izaina vená makó minamó, agulizá Maliá. Eza nene agulizaki ve napa Tevitini agapilamó zuhagutí ve makó minamó agulizá Zosehé aí ánigi milimikago minamó. ");
INSERT INTO gah_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Noigo ageló nenémo Maliá noitoka utó oake láa loko lo amimó: Guivahanímo hize lé ogetago noanitika nenoape. Guivahanímo geitoka noive. ");
INSERT INTO gah_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Loko agelómámo lokago, Maliá giligo gena okago, agikatunú nene gakó limómámini mogona nana oko netive. ");
INSERT INTO gah_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Loko nogiligo, agelómámo láa loko lo amimó: Maliazo geza gehelele vizemino. Ómasímo geí ánigokago lamaná okave. ");
INSERT INTO gah_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Gelenape. Geza izegipakagi minoko gipa getatanimó nene agulizá Izesú ave loko molozo. ");
INSERT INTO gah_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Eza nene sipisi ve loló oko noiko Ómasímini gipalave liki linigave. Itó Guivahani Ómasímo nene avolaho Tevitini akilí ale hitomikiko minanogo ive. ");
INSERT INTO gah_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Itó mino lúaló moloko Zakoponi agapilamó zuhaloka gizapa oko minanogo ive. Guivahani loló oko minatimó nene asú amoko gamena hána hána mino-loko voko minanogo ive. ");
INSERT INTO gah_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Loko agelómámo lokago, Maliá láa loko lo amimó: Neza vánegi apizeko minamusive. Nenemú nolani gakó nene nana oko alévolé itive. ");
INSERT INTO gah_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Loko lokago, ageló nenémo láa loko lo amimó: Ómasímini Sikalahulímo geí gumupiló liminogo ive, itó Guivahanímini zámuzámo hize lé ogetanogo ive. Nenemú gipa getatanimó nene etó keké vizeko noi gipa Ómasímini gipalave liki linigave. ");
INSERT INTO gah_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Itó makó lo gimitoze, gelezo. Geí zuhagutí Elisapetéma nene gelehosimámo izegipa agatupagi noigo ikani 6 mota vokave. Eza nene gohuna venámave liki nilago izegipalagi minokave. ");
INSERT INTO gah_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ómasímo loló amiti netala ma nomive. Loló iti netakó nenazo, nenemú Ómasímo Elisapetenimú li gakó mota gihila zekave. ");
INSERT INTO gah_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Loko lokago, Maliá nene neza Guivahanímini gelekelé mohó nounazo, nolani gakó nene ámináminoko utó ino. Loko lokago, ageló nenémo ahulomiake vimó. ");
INSERT INTO gah_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Maliá nene mino hána amike Zutaia mikasiuka agokaloka numuni makó minatoka iteko vimó. ");
INSERT INTO gah_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Iteko vike Zakaliani numukú itike Elisapeteni geké lotamó. ");
INSERT INTO gah_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Geké lomikago, Elisapeteni mulunagutí izegipalama ziginí igo gilimó. Gelekago, Ómasímini Sikalahulímo nene Elisapeteni agikagú lemeko vaí okago, ");
INSERT INTO gah_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","gakó napa like láa loko lo amimó: Ómasímo eza vená mukikutí gelémo etó ike nónohá zegimikave, itó izegipa getatanimó nenegi lusa gemikave. ");
INSERT INTO gah_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Geza není Guivahanímini izolagama noane. Vená ánéama nounazo, nanamú nenitoka okane. ");
INSERT INTO gah_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Gelezo. Geké nolonetako, izegipa nenémo mulúnegutí agoliza novizike ziginí okago gelekuve. ");
INSERT INTO gah_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Itó geza nene Guivahanímo lo gimi gakó vo alitive loko gele alévolé okako, Ómasímo lusa gegimikave. Nenemú gulugo lamaná okave. ");
INSERT INTO gah_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Loko lokago, Maliá láa loko limó: Neza nigikatunú Guivahani agepoka noluve, ");
INSERT INTO gah_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","itó sikalahúnetunú Ómasi nugutó vizeaká vemú nogoliza vizuke agepoka noluve. ");
INSERT INTO gah_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","49","Itó gelekelé mohola neza minomo lemeko minumó itínasa nelémoko noitive. Ómasi alévolé ve nenémo nenitoka netá gihila ale utó okamó nenazo, nenemú omolelé amalelé iki mini-liki itita vegenalite nenikumú giliiki Ómasímo lusa geta venale liki linigave. Aí agulizá etó oko neve. ");
INSERT INTO gah_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Aí gili amita vegená nasahilí okimiaká noive. Omolelé amalelé iki minimi ite vegená lá okimiaká noive. ");
INSERT INTO gah_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Kezáini kugupemú gelego iteaká noi vegená nene ezáa alévolé zámuza ale utó ike kelémo ahuloaká noive. ");
INSERT INTO gah_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Itó kugulizaki ve kehelú okago keí gonanalivagi holomalotí velehé limiaká niave. Itó vegená limiki minamoláatini kugulizáini ale napa oaká noive. ");
INSERT INTO gah_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Gohogó vegená itó gaúna hiliki nimina vegená nene netá gihila kemekago, kagatupa igo miniaká niave. Itó henóinigi vegená ahulokimikago muhelé iki miniaká niave. ");
INSERT INTO gah_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ómasi eza gelekelé otoko minuni vegená nene hize lé olimikave. Eza agika lamanakímove loko Isilae vegená leza lá olimikave. ");
INSERT INTO gah_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Avotegini láa loko lo moloketamó nene Avalahani itó agapilamó zuhagi lo mololetamómámini gihila utó oloko voko minanogo ive. ");
INSERT INTO gah_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Loko Maliá loake, Elisapeteki minasike ikani losive makole ale ahuloake, numunaloka atiginá oko vimó. ");
INSERT INTO gah_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Itó Elisapeté eza izegipa getati gamena alitokago, gipa getamó. ");
INSERT INTO gah_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Getokago, vegenala zuha agivelage keza Guivahanímo muluna ze hoú lake ale utó i netakumú giliake, ezagi makó mulúikú lamaná gelemó. ");
INSERT INTO gah_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Lá iake, gamena 8 oko vokago, gipa namunimámini agupeló Ómasímini anosa militanigi mukí vegená alegesá ake amelaho Zakaliani agulizató milanigi lamó. ");
INSERT INTO gah_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Liki likago, izolaho géneka like Óe, agulizá Zoní ave loko molatune. ");
INSERT INTO gah_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Loko lokago, keza láa liki li amemó: Íi, geí zuhatini kugulizá makó nenéminoko nomive. ");
INSERT INTO gah_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Liki géneka hánaka nilake, Zakaliá nene gipalámini agulizá nanave loko molative liki kigizanitunú avevezaha ikago, ");
INSERT INTO gah_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","eza pepamú agizanitunú avevezaha okago, pepa alimi amikago, agulizá Zoní ave loko luhuva gizamó. Gizokago, giliake sigaga lamó. ");
INSERT INTO gah_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Lá ikago, Zakaliani genezala litá oko lamaná okago, Ómasi agepoka limó. ");
INSERT INTO gah_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Lá okago, agive lugáa keza giliake kelegesá ligimó. Lá okago, Zutaia mikasigú zopegaloka numutó namató nene ámina gakó avetó iki ligili hagili ikago, ");
INSERT INTO gah_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","vegená mukilite gakóini giliake ali kigikagú milake gipama nene napa okoko nana itive. Liki lamó nene, Guivahanímini zámuza nene ámina gipaloka nego giliake lamó neve. ");
INSERT INTO gah_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Itó amelaho Zakaliani nene Ómasímini Sikalahulímo agikagú minake alémo vávani igo alika utó iti netakumú epoapoga like láa loko limó: ");
INSERT INTO gah_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Isilae ve leza Guivahanite Ómasi agepoka litune. Eza nene vegenala zuha lelí lelémo vatí ike netá golesagutí gologí olimikave. ");
INSERT INTO gah_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Lugutó viziti lapusa ale oteko hizekave. Gelekelé izegipala Tevitini agapilamó zuha lelitoka neve. ");
INSERT INTO gah_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ómasímini agepagutí gakó liaká ve kelémo vávani okago epoapoga gozapá láa liki liaká amóma neve: ");
INSERT INTO gah_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Lova vetini kigizakutí gologí oletanogo ive. Mukahá lipiliaká nia vegutí akagá oletanogo ive. ");
INSERT INTO gah_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Avotegini nigika hize kimitove loko lo moloketamole. Lo múnaheake lo hukoko li gakó gele minake lá oketamole. ");
INSERT INTO gah_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Itó avoteho Avalahani láa loko alévolé oko lo molotamole: ");
INSERT INTO gah_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Gala vetini kigizakutí gologí oletanogo ive. Lá okiko lelegesá legemiko gelekelé otoko minanogo une. ");
INSERT INTO gah_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Nenemú ligika avasavagi miniko gakote minamiko gelekelé otoko minoko hilitune, liki lamó neve. ");
INSERT INTO gah_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Itó gipa geza Guivahanímini monó gakoláa lole ale oko aí gapo veletataninazo, geikumú nene vozaú vémini agepagutí gakó loaká veve liki linigave. ");
INSERT INTO gah_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ómasímo vegenala zuha kugutó viziti gakó lo kemekako, keza gili zagikiko, lihimáini ahuloketanogo ive. ");
INSERT INTO gah_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Lelí Ómasile eza milumate geleaká noimó nenazo, eza lititó nene velé okulumakutí okululuva notovoko, ");
INSERT INTO gah_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","límugusigú nouhá vegená hize hanatoletanogo ive. Itó heleakakú nominuhá vegená hize sata oletanogo ive. Lá onoiko nonagá lamanalímini gapova utó iko nenegú vinogo une, loko Zakaliá limó. ");
INSERT INTO gah_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Itó ámina gipa nene agupegi agikagi napa oko alévolé okago, mikasi gomopalaló voko noigo, hoza aliti gamena alitokago, Isilae vegenatoka utó oko minamó. ");
INSERT INTO gah_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Gamena nene zupa Loma vetini agulizaki ve napa minamó, agulizá Agustó. Eza numutó namató vegená kugulizá alilo loko gakó ahulokago vimó. ");
INSERT INTO gah_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Nenémini hoza gozapá alemamó. Kilinió nene Silia mikasiuka agulizaki ve loló oko noigo ámina netá apí iki alemó. ");
INSERT INTO gah_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Lá niago, vegená mukí nene lugulizá alitave liki avóikini gotó apáitoka viká viká niago, ");
INSERT INTO gah_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Zosehé eza agulizaki ve napa Tevitini agapilamó minamó nenazo, eza ámináminoko Galilaia mikasiuka Nasalete numutoka minatotí ahuloko Zutaia mikasiuka nene Tevitini gotó apatoka Petelehe numutoka itimó. ");
INSERT INTO gah_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Noitike ánigi milita vená Maliáma izegipa agatupagi alémago vasimó. ");
INSERT INTO gah_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Viki minasike izegipala getati gamena alitokago, venoni vegenalitini akiaká numuni gikí okago, olovó zikasike pulumaká izatini numukú itiki minasike, ");
INSERT INTO gah_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","ganá gipala getoake, gotunú asapú omiake pulumaká izatini nosánetá kimiaká lapegú molomikago ako minamó. ");
INSERT INTO gah_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Lá okago, ámina mikasiuka ve lugáa nene holugúnaka gihisiló minake sipsip izáiniló gizapa iki minamó. ");
INSERT INTO gah_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Lá niago Guivahanímini ageló makolímo keitoka utó noigo, Guivahanímini lapanalímo hize sata omikago, kehelele vizimó. ");
INSERT INTO gah_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Lá okago, agelómámo láa loko lo kimimó: Gilinahe. Neza gakó lamaná aleko nolumumó nenazo, lekeza lekehelele vizemino. Nenémini gihiláa nene vegená mukitoka utó o likimiko mulutikú agila guluma inogo ive. ");
INSERT INTO gah_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Itínasa lukugutó viziti ve Guivahani eza gologí oleketative loko lo mololeketa vema nene Tevitini gotó numutó utó o noive. ");
INSERT INTO gah_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Itó anosa makó lo likimitoze, gililo. Izegipa namuni makó nene gotunú asapú iki izatini nosánetá lapegú milimikago akonoize, viki ánigalo. ");
INSERT INTO gah_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Loko lo kemekago, galinali ageló vegená mulusi napa nene okulumakutí limiki kigivéipo minató alegesá iki minake Ómasi agepoka lake nama láa liki lamó: ");
INSERT INTO gah_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Logoliza vizeko okulumakú Ómasi agepoka litune. Mikasiuka Ómasímo ánigo amu hili vegenatoka hulu utó ino. ");
INSERT INTO gah_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Liki ageló vegenámate liake atiginá iki okulumakú itikago, sipsip izaló gizapa ve keza láa liki ligili hagili amó: Leza Petelehe numutoka vinake Guivahanímo gakó lo limitímini gihila ánigatune. ");
INSERT INTO gah_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Liki liake litá iki viki Maliako Zoseheko kilími utó iake gipa namunima pulumaká izatini nosánetá lapegú akonoigo ánigamó. ");
INSERT INTO gah_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ánigiake, agelómámo izegipamú lo kimi gakó nene avetó iki li kememó. ");
INSERT INTO gah_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Lá ikago, izaló gizapa vetini kegepagutí gakoláa gele vegená keza sigaga li asú amóza, ");
INSERT INTO gah_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maliá nene gakó mukí ale agikagú moloake agata geleva geleva oko minamó. ");
INSERT INTO gah_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Itó sipsip iza gizapa ve keza atiginá iki vake ageló lo kimitó utó okago ániga netakumú nene Ómasi agepoka liki agulizá ali otiki minamó. ");
INSERT INTO gah_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Gipa Izesúma utó okago, gamena 8-ía vokago, gipamámini agupeló nene Ómasímini anosa militake agulizá Izesú ave liki milamó. Ámina agulizá nene Maliá izegipa agatupagi minonamigo ageló nenémo goí oko lo amitó nene milamó. ");
INSERT INTO gah_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Gipala getakumú agupe ali lamaná itave loko Mosé lo hukoko li netá aliki lilí itái gamena alitokago, Zoseheko Maliako keza gipa Izesuni nene Zelusalega alímiki itesike, Guivahani Ómasímini gipa minative liki anosa militasimó. ");
INSERT INTO gah_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Lá asimó nene Guivahanímo láa loko lo hutokago mina gakó nene gili alesike lá asimó: Ganá gipa utó noiko, Guivahanímini gipa minative liki lehizitalo. ");
INSERT INTO gah_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Itó Nama luhusihe nama gelehová ahe lositá aliki viki není guguni gizi nimilo loko Guivahanímo lo huta gakó nene gili alesike namagi aliki vasimó. ");
INSERT INTO gah_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Lá ikasigo, Zelusalega ve makó minamó, agulizá Simeó. Eza nene hee hee loko monolagi ve minake, Isilae vegenáma miluma giliki minakutí gologí oketati vemú ageva oko minoaká imó. Aí agikagú nene Ómasímini Sikalahulímo lemeko vaí oko minake, ");
INSERT INTO gah_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","gakó láa loko lo amimó: Geza helemoko hanuva noako Guivahanímo gologí oleketative loko lo mololeketa vema ániganogo ane. ");
INSERT INTO gah_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Itó Simeó nene Sikalahulímo alémo vávani okago monó zavusavegú itimó. Lá imó nene Maliako Zoseheko keza Ómasímo lo hukoko li gakotó aliki lilí itatave liki gipa Izesunima alímiki itesigo, ");
INSERT INTO gah_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeó nene gipa Izesunima zanava oko geheneike Ómasi agepoka like láa loko limó: ");
INSERT INTO gah_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","30","Guivahanínemaka, imane lugutó viziti vema itínasa nene nogómula gihilatunú ánigokuve. Gakó lo molonetanimó nene gihila mota zekaze, nenemú geí gelekelé ve neza monokú nelémo molako hulu nivisiko hilitove. ");
INSERT INTO gah_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Geza numutó namató vegenalite ánigatave loko lelémo lamaná iti ve imane alémo utó okane. ");
INSERT INTO gah_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Nenémo hetoka vegenalitini kigika hize hanatokimikiko monó gilinigave. Itó Isilae vegenalitini lugulizá ale otinogo ive. ");
INSERT INTO gah_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Loko gipa Izesukumú lokago, izolahiko amelahiko gilikasike sigaga lasimó. ");
INSERT INTO gah_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Lá ikasigo, Simeó eza lusa getake izolahini Malianima láa loko lo amimó: Gelenape. Imane gipaloka Isilae vegená hizi hoú litave loko lonoimóma neve. Ámina gipámini gakotó nene vegená lugáa keza lisiki gululú viziki akatave. Itó lugáa keza lisi gikitiiki otitave. Eza anosavagi noitimó nenazo, ve mukilite alivi letivi itatave. ");
INSERT INTO gah_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Itó napiliko geza gipakamú miluma geleko gigika hizinogo ive. Nene suni utó noiko, vegená mukilitini kigikagú gakóini utó inogo ive. ");
INSERT INTO gah_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Loko lokago, Ómasímini agepagutí gakó loaká vená makó minamó, agulizá Haná. Áisi Panueleni mohola Aseloni mulusigutí minatímo veló voko minake kilisimasi 7 ale ahulokago, vana helekago, ");
INSERT INTO gah_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","gevoná vená loló oko minomo noitike kilisimasi 84 ale ahulake gelehosi molamó. Áisi nene monó zagusave ahulamike gamena gamena únaká neteká Ómasi geké lotoko minake, nosánetá moseko minake, Ómasiloka loaká imó. ");
INSERT INTO gah_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Eza nene ámina gamenaló anitike Ómasi agepoka like, Zelusale numutoka Ómasímo gologí oketati gamenamú ageva iki mina vegená nene gipa Izesukumú avetó oko lo kimimó. ");
INSERT INTO gah_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Lá okago, Maliako Zoseheko keza Guivahanímo lo huka gakolímini hozaváa ali asú ikasike, Galilaia mikasiuka keí numutoka Nasalete neneloka atiginá iki vasimó. ");
INSERT INTO gah_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Neneloka viki niasigo gipa Izesuni nene Ómasímo gizapa otake hize lé omikago, napa ike alévolé oko minake gakó mukí gilimó. ");
INSERT INTO gah_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Avóikini asenini zeketakumú gili mina holisi zupa meleketó meleketó nene Maliako Zoseheko keza Zelusalega itiaká asimó. ");
INSERT INTO gah_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Lá iki niasigo, gipa Izesú nene kilisimasi 12 ale ahulokago ámina holisi makó alitokago goí iki aliaká asimó nenéminiki gipa Izesuni alímiki Zelusalega makó itemó. ");
INSERT INTO gah_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Itiki niago, holisima asú noigo nene, keza nene gipa Izesuni nene Zelusalega taiza imikasigo, noigo, Maliako Zoseheko taiza itasikumú gelemasike atiginá iki lemesimó. ");
INSERT INTO gah_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Vegená lugáaloka gímizeko vo noitihe liki gilikasike, gapoloka nivasigo límugusi zekago, keí zuhagi itó kigivéike niakú vitagá asimó nene, ");
INSERT INTO gah_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","noamigo, Zelusalega atiginá iki itesimó. ");
INSERT INTO gah_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Itiki vitagá iva iva iki niasigo, gamena losive makole oko vokago, Izesú nene monó zavusave napagú noike monó gakó lainim-ikimiaká vetini holúikú minake gakóini gilike itó mogonamú loká oketoko noigo ánigasimó. ");
INSERT INTO gah_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Itó monó ve nenete gipa Izesú gakó gilikumú itó loká atoka ale viligoko lo kimikumú sigaga litamó. ");
INSERT INTO gah_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Lá oko holúikú noigo alími utó ikasike, ininá goha asike izolaho láa loko lo amimó: Gipáne geza nanamú taiza oletane. Gelenape. Amekahiki leza geikumú mulute ze hoú loko mohona oko vitagá onousive. ");
INSERT INTO gah_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Loko lo amekago, Izesú láa loko lo kimimó: Nanamú vitagá asimó neve. Neza aménehini numukú aleko minozo loko loneta hozamagú nouve. Nene gakó gelemasike nilasihe. ");
INSERT INTO gah_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Loko limóza, keza nenémini mogonáa gili vevesamasimó. ");
INSERT INTO gah_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Lá ikasigo, izolahiko amelahiko alímiliki vake Nasalete numutoka vasigo eza gelekelé oketoko minamó. Itó izolaho nene gili gakó mukí ale agikagú moloko minamó. ");
INSERT INTO gah_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Noigo, Izesú nene agikagi agupegi napa oko alévolé igo minamó. Lá okago niago, Ómasigi mukí vegenaki Izesukumú keza ánigi kumu hiliki minamó. ");
INSERT INTO gah_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tipelió eza Loma vegenalitini kugulizaki ve napa-napa loló oko noigo, kilisimasi 15 oko vokago, Potiasí Pilató eza Zutaia mikasiuka kiapé napa loló oko noigo, itó agunala Pilipó nene Itulaia itó Talakoniti mikasiuka kiapé loló oko noigo, itó Lisaniá nene Apilene mikasiuka kiapé loló oko noigo, ");
INSERT INTO gah_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","itó guguni giziaká ve napatini gizapa ve lositá Anasiko Kaiapako niasigo, ve nenéminiki gizapa ve lilí iki niago, gamena nene zupa Zakaliani gipala Zoní nene mikasi gomopalaló noigo, Ómasímo hoza gakó lotamó. ");
INSERT INTO gah_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Lá okago, Zota nagamí vola helega ima helega mohona mohona ike, vegená kigika ali viligiiki monó nagamí hilikiko Ómasímo lihimáini ahuloketative loko lo utó oko lo kemeko minamó. ");
INSERT INTO gah_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Lá noigo, Ómasímini agepagutí gakó loaká ve Isaiáma epoapo gakó láa loko gizamó nene Zonitoka alévolé imó: Mikasi gomopalaló ve makolímo gakó napagutí láa loko nolive: Guivahanímini gapova likigikagú vilitalo. Aí gapo ali hee litalo. ");
INSERT INTO gah_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Gímuza lemeneitimó nene apiziki alími lamaná ilo. Agoka iteneitimoláa alími lasava zilo. Zová zeneitimoláa alími pehe lalo. Gapoló mikasi itesú lemesú itimó nene apiziki alími geleni lilí ilo. ");
INSERT INTO gah_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Lá ikiko, mikasigú vegená mukí keza Ómasímini kugutó vizeaká netá ániganigave. ");
INSERT INTO gah_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Lá noigo vegená mukilite Zoní noitoka vake monó nagamikumú likago, eza láa loko lo keme keme oko minoaká imó: Lekeza gosihalímini agapilamó zuha neneta, golesa mogonatinímini lihimala anitinogo noimó nene lekeza likigika ali viligamiki hanuva golisi itune liki niahe. ");
INSERT INTO gah_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Lekeza likigika ali viligiiki nenémini gihila ali utó ilo. Neza lo likimitoze, gililo. Avalahani agapilamó zuha keza sonohikitana nene gatamoakalímini lilí itave loko lo molota gakó alévolé itive loko lekelisi negopa, Ómasi nenémo gakó litove loko nene lokiko gehani imanete Avalahani agapilamó zuha lilí inigi nene hanuva lilí itamó nenazo, lekeza lukugupetini aliki itiki Avalahani agapilamó zuhama nouninazo, Ómasi eza lihimatemú goní oletaminogo ive liki lamilo. ");
INSERT INTO gah_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Luni leko makó nene za mogonagú gamuni oake noimóma neve. Nenemú gihila lamaná ali utó inamitamoláa nene asahizeko lokú gizanogo ive. ");
INSERT INTO gah_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Loko lo kemekago, mukí alegesá iki mina vegenalite loká itake leza nana itune. ");
INSERT INTO gah_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Liki likago, láa loko lo kimimó: Ve makó nenémo sioti losi aleminokoma agivelahini sioti nomiti ve nene magáa amino. Itó nosánetaki nene áminámini ilo. ");
INSERT INTO gah_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Loko lokago, takisi aliaká vete monó nagamí hilanigi aniteke loká itake monó velemaka, leza nana itunimó neve. ");
INSERT INTO gah_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Liki likago, eza láa loko lo kimimó: Takisi moni gamanímo alilo loko molató nene aviligiki alimi itiki alemilo. ");
INSERT INTO gah_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Loko lokago, pilisí ve nene ake loká itake leza nene nana itunimó neve liki likago, eza láa loko lo kimimó: Lekeza vegenalite moni limitave liki kipiliki kilími golesa amiki hakupá gakó likitamilo. Itó ikató hozalotí moni aliaká niamó nenemú goselé lekepelemino, loko limó. ");
INSERT INTO gah_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Vegená mukí keza Ómasímo gologí oketative loko lo moloketa ve atikumú gituhú niki ageva iki minake, Zonikumú nene ámina vema noihe liki kagata losi gelemó. ");
INSERT INTO gah_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Lá ikago, Zoní nene vegená mukí láa loko lo kimimó: Neza nene nagamikó hololikimiaká nouve. Není nemegesaloka noa vémini zámuza nenémo není zámuza nivilegekave. Neza ánéama nounazo, aí gasa gó ate akisitomó nene etaminogo ive. Áisi nene Ómasímini Sikalahuki likigikámini pipizá netá loko loaká loki hololeketanogo ive. ");
INSERT INTO gah_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Eza nene lolopa giteaká netaki aleko oko laisi nene gesopá zeko lolopa giteko ale lamaná inogo ive. Nosánetá lamaná nene gizaká oko ale numunagú molokiko minanogo ive. Lolopaváa nene giteko lokú gizokiko lova lova oko minanogo ive, loko limó. ");
INSERT INTO gah_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Zoní eza lá oko vegená kagata alike ámina gakoki gakó lugáagi lo kimike Ómasímini gakó lamaná lo kemeko minamó. ");
INSERT INTO gah_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Lá imóza, agulizaki ve Heloté nene uvolahini venala Helotiasini ipá oko aleake netá golesa lugáa alekago, Zoní nenemú gahá amekago, Heloté nenemú gele golesa oake, ");
INSERT INTO gah_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","miní amike netá golesa goha alike Zonini nene nagá numukú ahulotamó. ");
INSERT INTO gah_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Zonini nene nagá numukú velesá ahulotamigo vegená mukí monó nagamí holokimikago, Izesú ámináminoko Zonitoka voko monó nagamí holamó. Holoake, Ómasiloka noligo, okulumá koló okago, ");
INSERT INTO gah_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ómasímini Sikalahú nene nama luhusi agupegi loló oake Izesuni amupiló lemeko minamó. Noigo, okulumakutí gakó makó láa loko utó imó: Gipáne gihila noane. Geí ánigo lamaná okuve, loko limó. ");
INSERT INTO gah_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Izesú nene kilisimasiva 30 nenéminoko oko novigo monó hoza apí oko alimó. Naligo, vegená nenete Zoseheni gipala nehe liki gelemó. Zosehé nene Helini gipala, ");
INSERT INTO gah_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","eza nene Matatani gipala, eza nene Livaini gipala, eza nene Melikini gipala, eza nene Zanaini gipala, eza nene Zoseheni gipala, ");
INSERT INTO gah_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","eza nene Matatiani gipala, eza nene Amosini gipala, eza nene Nahumini gipala, eza nene Eselini gipala, eza nene Nagaini gipala, ");
INSERT INTO gah_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","eza nene Malatani gipala, eza nene Matatiani gipala, eza nene Semeinini gipala, eza nene Zosekeni gipala, eza nene Zotani gipala, ");
INSERT INTO gah_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","eza nene Zoanani gipala, eza nene Lesani gipala, eza nene Zelupapeleni gipala, eza nene Sealitieleni gipala, eza nene Nelini gipala, ");
INSERT INTO gah_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","eza nene Melikini gipala, eza nene Atini gipala, eza nene Kosamini gipala, eza nene Alimatamani gipala, eza nene Eleni gipala, ");
INSERT INTO gah_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","eza nene Zosuani gipala, eza nene Eliezeleni gipala, eza nene Zolimini gipala, eza nene Matatani gipala, eza nene Livaini gipala, ");
INSERT INTO gah_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","eza nene Simeoni gipala, eza nene Zutani gipala, eza nene Zoseheni gipala, eza nene Zonamani gipala, eza nene Eliakímini gipala, ");
INSERT INTO gah_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","eza nene Meleani gipala, eza nene Menani gipala, eza nene Matatani gipala, eza nene Natanani gipala, eza nene agulizaki ve napa Tevitini gipala, ");
INSERT INTO gah_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","eza nene Zesini gipala, eza nene Opeteni gipala, eza nene Poasini gipala, eza nene Salani gipala, eza nene Nasonani gipala, ");
INSERT INTO gah_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","eza nene Aminatapani gipala, eza nene Ataminoni gipala, eza nene Alanini gipala, eza nene Hezelonani gipala, eza nene Pelezeni gipala, eza nene Zutani gipala, ");
INSERT INTO gah_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","eza nene Zakoponi gipala, eza nene Isakani gipala, eza nene Avalahani gipala, eza nene Telani gipala, eza nene Naholeni gipala, ");
INSERT INTO gah_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","eza nene Seluguni gipala, eza nene Lagauni gipala, eza nene Pelegeni gipala, eza nene Epeleni gipala, eza nene Selani gipala, ");
INSERT INTO gah_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","eza nene Kenani gipala, eza nene Alapasatani gipala, eza nene Semeni gipala, eza nene Noani gipala, eza nene Lamekeni gipala, ");
INSERT INTO gah_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","eza nene Metusalani gipala, eza nene Enokuni gipala, eza nene Zaleteni gipala, eza nene Mahalaleni gipala, eza nene Kenani gipala, ");
INSERT INTO gah_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","eza nene Enosini gipala, eza nene Seteni gipala, eza nene Atani gipala, Atá nene Ómasilokatí. ");
INSERT INTO gah_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Izesú nene Ómasímini Sikalahulímo agikagú leme vaí oake alémo zaú okago, Zota nagamí ahuloake mikasi gomopalaló vimó. ");
INSERT INTO gah_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Neneloka gamena ve lositosini kigisa kigizani asú igo akoko noike, nosánetá namike alika gaúna heleko minamó. Lá noigo, Satá nene oko gimivagú molake ");
INSERT INTO gah_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","láa loko lo amimó: Geza Ómasímini gipala noitanimó nene, geza lokako gehani imanémo nosánetá loló okiko noko minamane. ");
INSERT INTO gah_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Loko lokago, Izesú láa loko lo amimó: Óe, monó gotolaú luhuva láa liki gizinamóma neve: Vegená neneta nosánetakó nokoko lamaná oko minoakaláa nene nomive. ");
INSERT INTO gah_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Loko lokago, Satá agoka hána makokú alémoko itike numutó namató kugulizaki ve mukilitini apáini litá oko alapize asú oake, ");
INSERT INTO gah_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","láa loko lo amimó: Amuza miliki niago kugulizá novi netaki mikasigú netá lamanaláa nenegi imane geikó geme asú itove. Ámina netá nene není nigizakú molo asú onoinazo, makope makope amitove loko hanuva amitomóma neve. ");
INSERT INTO gah_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Nenemú geza není nigisauka gupá zeko negepoka lokako geikó loló o asú itive. ");
INSERT INTO gah_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Loko lokago, Izesú láa loko lo amimó: Óe, gakó makó monó gotolaú láa liki gizinamóma neve: Guivahani Ómasigó lalapusa hizeko gupá ze ameko agepoka loakaláa neve, itó aikó gelekelé omiakaláa neve. ");
INSERT INTO gah_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Loko lokago Satá nene Izesuni alémoko Zelusalega vike monó zavusave napámini agoka hánaló alémoko itike láa loko lo amimó: Geza Ómasímini gipala noitanimó nene, imanelotí olío ká omanegú molozo. ");
INSERT INTO gah_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Gakó makó monó gotolaú láa liki luhuva gizinamóma neve: Geikumú Ómasímo aí ageló nene hoza gakó lo kemekiko gizapa iki gilími vatí inigave. ");
INSERT INTO gah_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Itó makó láa loko neve: Gehanímo gigisagú hizekative liki keza limiki kigizani lukilagú gilími milanigave. Liki luhuva gizinamóma nenazo, golesa aminogo ane. Loko lokago, Izesú láa loko lo amimó: ");
INSERT INTO gah_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Óe, monokú gakó makó láa loko neve: Guivahani Ómasi nene gopa netakumú gimivagú molamitane. ");
INSERT INTO gah_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Loko lokago Satá nene lá oká lá oká ike agoka vize asú oake, ahuloko gamena makó zupave loake ahulomiake vimó. ");
INSERT INTO gah_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Izesú nene Sikalahulímo hize lé otake zámuza amekago, Galilaia mikasiuka atiginá oko vimó. Atiginá oko okago, aí gakoláa helega helega vo asú igo gelemó. ");
INSERT INTO gah_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Neneloka monó numuni minakú minakú nene iteko lemeko oko monó lo kemekago, vegená mukilite laga kivisekago geké litamó. ");
INSERT INTO gah_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Lá ikago, Izesú ezáa napa i apá Nasalete numutoka nene áminámini oko vo anitike, holisi alitokago, monó numukú itimó. Eza holisi mina zupa zupa ámináminoko iteaká imó. Iteko monó gatoko lo kiminogo noitigo, ");
INSERT INTO gah_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ómasímini agepagutí gakó loaká ve Isaiá giza pepama amikago, ataloko ánigoake gakó makó láa loko minamó nene ale utó ike gato kimimó: ");
INSERT INTO gah_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Guivahanímini Sikalahulímo nenitoka holonetake, hoza gakó láa loko lonetamóma neve. Minimi limiki nia vegená nene gakó lamanáma lo kemezo. Kalapusi numukú nia vegená gologí oleketatove loko, itó kogómula lika vegená nene ale goloutoleketatove loko, itó muhelé ahelé iki minata vegená nene gologí oleketoko lekelémo molatove loko lo kemezo. ");
INSERT INTO gah_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Guivahanímo lekelémo lamaná iti gamena alitokave loko lo kemezo. ");
INSERT INTO gah_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Loko Izesú nene gatoko lo kemeake, pepama gakeko gelekelé vema goha ameake mitó minamó. Noigo, monó numukú mina vegená keza mukitoka aí gonú apiliki niago, ");
INSERT INTO gah_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","gakó láa loko lo kimimó: Monó gotola gakó gatokugo gelemómámini gihila itínasa nenitoka utó okave. ");
INSERT INTO gah_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Loko lokago, keza giní i amiake, aí agepagutí gakó gilikago laga kivisimó. Lá okago, keza sigaga lake lamó: Eza nene hanuva ánigonouhá ve Zoseheni gipala nenazo, nenémini gakó nana oake nolive. ");
INSERT INTO gah_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Liki likago, eza láa loko lo kimimó: Anoza gakó makó láa liki liaká niave: Lusa ve gezaka haitó vegená kelémo vatí ani netá aleko gezaka vegenaka zuha kelémo lamaná amane. Neza nagata gulumó lekeza ámina anoza gakó vasá zeke li nimiiki, Kapanao numutoka hoza aleko gakoláa gulunimómáminoko imane gotó numukaloka alekako ánigatune liki li nimitaze. ");
INSERT INTO gah_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Loko loake, miní ameko láa loko limó: Neza lamaná lo likimitoze, gililo. Ómasímini agepagutí gakó loaká vémo ezáa gotó apalaloka voko monó lo kemekago eza lelí gipate noive liki gakola gilisá amave. ");
INSERT INTO gah_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Nene sunimú gakó lamaná lo likimitove. Ilaizá eza monó hoza ali gamena nene okulumá gapo lí okago minake melekeni losive makolegi ikani 6-ía oko novigo golini zemimó. Golini zemigo gaúna gamena napa nene mukí apatoka utó imó. Ámina gamenaló nene Isilae mikasiuka gevoná vená mukí minamóza, ");
INSERT INTO gah_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ómasímo Ilaizani nene ámina vená keitoka kelémo vatí itive loko amiselemive. Sitona mikasiuka Salepata apatoka Zuta vená negopa hetoka gevoná vená makó noitoka alémo vatí itive loko amisilimó. ");
INSERT INTO gah_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Itó Ómasímini agepagutí gakó loaká ve Elisá hoza ali gamena nene Isilae mikasiuka halamé gizale ve mukí minamóza, Elisá keikutí kelémo zokamike Silia mikasiuka hetoka ve makó Nemanigó alémo zokamó. ");
INSERT INTO gah_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Loko lo kemekago, ámina gakó giliake, Ómasímo lezagi ahuloletati gakó lokave liki giliake monó numukú mina vegená keza mulúikú golesa giliake, kizapaló goha molokago, ");
INSERT INTO gah_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","zaú iki otiake númaseloka Izesuni alímiki vake ámina apá mina agoka lusenaló agataloka ahelú i ahulanigi alímiki iteha, ");
INSERT INTO gah_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","áisi nene ahulokimiake holúikutí hanuva vimó. ");
INSERT INTO gah_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Lá oake Izesú nene Galilaia mikasiuka lemeake, Kapanao numutoka anitike holisigú holisigú nene monó lo kemeko minamó. ");
INSERT INTO gah_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Lá noigo, monó gakola gale geheko lo kemeaká imó nenazo, nenemú keza ininá iki sigaga litamó. ");
INSERT INTO gah_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Lá niago, keí monó numukú nene ve makó minamó nene holosi makolímo agikagú minake alémo gopa okago minamó nenémo gamoga geko láa loko limó: ");
INSERT INTO gah_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Eé, Nasalete ve Izesuvo, nana netá golesa aleletanogo noane. Lelémo golesa inogo noape. Geí nene ánigo hehe noluve. Geza Ómasilokatí etó keké vizeko noani vema noane. ");
INSERT INTO gah_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Loko lokago, Izesú gahá amike gegepa apizeoko legesó oko agikagutí lemeko vamane. Loko lokago, holosi nenémo vegená holúikú ámina vema nene ahelú okago puu loko akamóza, alémo golesa amike ahulomiake vimó. ");
INSERT INTO gah_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Lá okago keza vegená mukitoka ininá ake ligili hagili ake láa liki lamó: Nana ive. Monola nene haitolímini neve. Áisi gakola gale geheko aí amuzatunú lokimiaká noigo holosi golesate ahulikimiaká niave. ");
INSERT INTO gah_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Liki likago, Izesunimú gakó nene ámina apá helega helega puu loko vo asú imó. ");
INSERT INTO gah_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Lá okago, Izesú nene monó numukutíma lemeake Saimoni numukú itimó. Neneló Saimoni venalámini izolahini agupegú ló napa lo minokago, alémo zokative liki li amemó. ");
INSERT INTO gah_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Li amikago, áisi voko alitó oteneike agupegú ló la netáma nene gahá amekago agupegú ló la netáma asú otamó. Asú omikago, ámina venalímo litá oko oteake Izesugini nasahilí oketamó. ");
INSERT INTO gah_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Únaká ho nolimigo, haitopaitó netá kivisi vegená kilímiki Izesú noitoka ikago, agizanitunú kugupeló ale geleko kelémo zokamó. ");
INSERT INTO gah_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Itó vegenalitini kigikagú holosi golesa minamó nene kepeleko nokimisiligo, gopaga lake geza Ómasímini gipala noane. Liake ahulikimiake vamó. Nivago, keza Izesukumú Ómasímo gologí oletative loko lo mololeta vema noive liki gelemó nenazo, Izesú nene gahá nokimike aí mogona lili ali amitave loko lo hukoketamó. ");
INSERT INTO gah_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Neteká ho noitigo, Izesú eza numuni apakutí lemeake voko mikasi amegesa vizitoka minoko numuna linogo voko minamó. Noigo, vegená keza aikumú vitagá iki iki alími utó iake, ahuloketamitive liki lamóza, ");
INSERT INTO gah_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","eza láa loko lo kimike limó: Neza nene apá lugaloka mohona oko Ómasímini gasovaló minoakalímini gakó lamaná lo keme keme inogo uve. Ámina hoza alitane loko Ómasímo nimiseleneimóma neve. ");
INSERT INTO gah_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Loko loake, vike Zutaia mikasiuka monó numuni minakú minakú iteko monó lo keme keme oko mohona imó. ");
INSERT INTO gah_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Gamena makó zupa Izesú eza Genesalete nonohuló agataloka noigo, vegená keza Ómasímini gakó gilitune liki ali nupa iake aitoka sii sii liki minikago, ");
INSERT INTO gah_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","lagaha aliaká ve makó nene nagamikú lapéinigutí limiake, lagaha gotaháinima nagamí nizego, itó sipi lositá nene nagamikú ha nego, ");
INSERT INTO gah_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Izesú nene ánigoake magáa Saimoni nagamikú lape minakú iteake, nagamí getatokatí hilulú oloko koma vitane loko loká imó. Gele amekago sipigú minake mukí ali nupa a vegenáma monó lo kimimó. ");
INSERT INTO gah_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Lo keme asú oake Saimoni láa loko lo amimó: Hilulú oloko voko nagamí ohunáagú molo-minoko nene gigivekagegi lagaha alinigi niaze, gotahalini nene ohunagú ahulalo. ");
INSERT INTO gah_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Loko lokago, Saimon Pitá nene anotó aleko láa loko lo amimó: Gizapa velemaka, leza itína holugúnaka gotaha ova ova oko minuháza, lagaha hamolagi ma alemune. Lá unimóza, geza lanimómave loko nene lagaha gotaha nene goha nagamí ohukú ahulatune. ");
INSERT INTO gah_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Loko lo ameake, aliki viki gotahama ahulake lagaha mukí nalego, lagaha gotaháini nene zeko hukanogo noigo, ");
INSERT INTO gah_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","kigive lugáa sipi makokú minamoláama iki kilími vatí itave liki kigizani gumí zi kimiki sele lamó. Lá ikago, keza ake sipi lositámagú lagaha ali nimilago, lagaha vaí oake nagamikú lapema nene nagamikú liminogo imó. ");
INSERT INTO gah_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","9","Lá noigo, Saimon Pitaki makó mina vegenaki keza lagaha mukí alekumú ánigiake sigaga lamó nenazo, Pitá eza Izesuni agisauka gupá zeko lo amike Guivahanínemaka, neza lihimánegi ve nounazo, ahulonimioko vozo. ");
INSERT INTO gah_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Loko noligo Zepetaioni gipala losi Zemusiko Zoniko keza Saimoni agivelahiko nenetosa ámináminiki sigaga lasimó. Sigaga nilasigo, Izesú nene Saimoni láa loko lo amimó: Geza gehelele vizemino. Itína imanémini veletó nene geza monó hoza aleloko novako mukí vegená nene není zuha lilí itave. ");
INSERT INTO gah_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Loko lokago, nagamikutí lapéinima aliliki getatoka vake nene, mukí netá matáini ahuliake Izesuni ámegetiki vamó. ");
INSERT INTO gah_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Izesú nene apá napa makotoka voko noigo, halamé agupeló vaí oko gizali ve makó noike, Izesuni ánigoake vike agisauka gupá ze ameake negénegeka like láa loko limó: Guivahanínemaka geza nene nelémo gililitove loko nene hanuva nelémo gililitanimó nenazo, nelémo gililitane loko noluve. ");
INSERT INTO gah_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Loko lokago, Izesú nene agizani lutoko agupeló ale nogilike gililitane loko gelekuze, gilelezo. Loko lokago, litá oko gililimó. ");
INSERT INTO gah_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Lá okago, ámina gakó nene avetó oko vegená avetó oko lo kememitive loko lo hukomiake láa loko limó: Aló gilelekane liki gili hee litave loko geza nene voko guguni gizoaká vémitokama gugupe alapizekako ánigative. Itó gilelenikumú nene Mosé loleketa netá aleko Ómasi guguni gizo amitive loko amekako eza vegená mukí lo kemekiko nenémini mogona gili vevesatave. ");
INSERT INTO gah_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Loko limóza, aí gakoláa nene puu loko vokago, mukí vegenalite gili asú iake Izesuni gakó gilitune liki itó kivisi netakutí kelémo zokative liki Izesú noitoka alegesá iaká amóza, ");
INSERT INTO gah_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","eza mikasi gomopalaló voko minake Ómasiloka linogo voaká imó. ");
INSERT INTO gah_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Gamena makó zupa Izesú eza monó gakó lainim-oketoko noigo Palisaio monó vegenaki monó mogona apí ikimiaká vegi keza Galilaia apatotí itó Zelusalegatí itó Zutaia apá makotokatí nene mukí numutotí iki neneló ali nupa amó. Lá niago Izesú nene kivisi vegená kelémo zokati zámuzagi minató minamó. ");
INSERT INTO gah_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Lá noigo ukoakoló zaló mililiki a ve gepili makó nene alímiki iake Izesuni agisauka ahulitanigi niago, ");
INSERT INTO gah_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","vegená mukí gikí iake gapo hizi lí ikago, alímiki numupitó itiake ali koló iake, ukoakogi nagá ziake ahulikago vegenalitini holúikú limike Izesuni avogisaloka lemekago, ");
INSERT INTO gah_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Izesú nene ánigoake gili alévolé amó nenémini mogonáa ánigoko geleake, ve gepilima láa loko lo amimó: Vémage, lihimaka ahulogimikuve. ");
INSERT INTO gah_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Loko lokago monó mogona apí-ikimiaká vegi Palisaio monó vegi keza kagata gululusi giliake kezáitoka láa liki ligili hagili amó: Makó éaho lihima gilatoaká noive. Ómasímo hamokó lá oaká noinazo, ezáa agupevamú giligo itekago, Ómasi aviliginogo limó nene etamive. ");
INSERT INTO gah_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Liki kigikatunú nigelego, Izesú nene Zuta vegenalite lihimate ahulolimiaká itó vegená kelémo zokoaká nene Ómasímogó loló oaká netá neve liki gilinave loko geleake láa loko lo kimimó: Lekeza likigikauka nanamú láa liki nigeleve. ");
INSERT INTO gah_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ve makolímo Ómasi noamitimó nene lihimaka gilatogimikuve loko vávani oko lamitimóza, kelémo zokoaká zámuzagi ve noamitimó nene gakó lokiko gihila zemitihe loko ve gepili makó nene oteoko vozo loko litá oko lo ameminogo ive. ");
INSERT INTO gah_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Lá onoimóza, okulumakutí lumu ve gihila neza mikasigú lihima gilatoaká zámuzagó negopa, lihimatini ale ahulolikimiaká zámuza nenitoka neve. Loko loake nenémini mogonáa gili hee hee litave loko ve gepilima lo amike nene láa loko nologetuve: Otekoko ukoakoka geheko numukaloka vozo. ");
INSERT INTO gah_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Loko lokago, mukí vegenalitini kogómulaló nene litá oko oteake ukoakova ale geheko numunaloka vike Ómasímini agulizá ale oteko minamó. ");
INSERT INTO gah_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Lá noigo, vegená mukilite sigaga liake Ómasi agepoka lake mulúini otopá nozigo itínasa haitolímini suni ánigokune, liki lamó. ");
INSERT INTO gah_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Alika Izesú lemeake novike takisi aleaká ve makó agulizá Livaí áisi nene hoza aleaká numunauka noigo ánigoake geza nene némegetoko ano. ");
INSERT INTO gah_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Loko sele lo amekago Livaí nene netá mukí ahuloake ámegetoko vimó. ");
INSERT INTO gah_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Makó vasike Livaini numukú nosánetá napa Izesuni vatá omikago, takisi aliaká vegi ve makoki keza mukitó namó. ");
INSERT INTO gah_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ninago, Palisaio monó vegi monó mogona apí-ikimiaká vegi keza Izesuni izegipala zuhamú gili golesa niake láa liki li kememó: Lekeza nene takisi aliaká vegi netá golesa aliaká vegená makoki nanamú makó miniki nosánetá ninave. ");
INSERT INTO gah_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Liki likago, Izesú geleake láa loko lo kimimó: Hanuva lamaná iki mina vegenalite lusa vemú sele lisá amave. Kivisi vegenalitegó lusa vemú sele liaká niave. ");
INSERT INTO gah_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Neza hee loko noune liki liaká nia vegená kelémo otopá zitove loko lememumóma neve. Neza lihimáinigi vegená kigika ali viligatave loko kelémo otopá zinogo lumumóma nenae, loko limó. ");
INSERT INTO gah_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Lá okago, keza láa liki li amemó: Zonini izegipala zuha keza gamena mukí monokumule liki nosánetá mosé mosé iki Ómasiloka liaká niave. Itó Palisaio monó vetini izegipáini zuha keza ámina suni aliaká niamóza, geí izegipaka zuha keza nosánetá gopa aliki niaká niamó nene nanamú niave. ");
INSERT INTO gah_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Liki likago, Izesú anoza gakó láa loko lo kimimó: Vená ali amita ve ezagi agivelagegi apiziki niminiko ve makolímo nosánetá moseketatimó nehe. Lá aminogo ive. ");
INSERT INTO gah_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Gala vete vená ali amita vema kigizakutí ipá ita gamena alitokiko, nene zupa miluma nigiliki nosánetá mosinigave. Ámináminiki izegipáne zuhate alika nenikumú miluma giliki mosé mosé inigave. Itína lá oko nomive. ");
INSERT INTO gah_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Loko loake, miní ameko anoza gakó makó láa loko lo kimimó: Lavolavo gó nene litaha looko hukokiko nene, gosohá gó makó hukiiki litaha gotó molo apizeko akotoakaláa nomive. Nagamí zikiko gikí okiko lavolavo gó gosohá hukokiko gosohá lavolavo gó nenémo litaha lavolavo gotó haitolíminoko minanogo ive. ");
INSERT INTO gah_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Itó vain nagamí nene gituhú galakalá noigo nene nagamí getununi litahagú ligi milisá amave. Vain nagamí nenémo gituhú galakalá nooko giputooko litaha getununi zeko ategekiko vain nagamiki nagamí getununigi latila okatinazo, ");
INSERT INTO gah_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","vain nagamí gituhú galakalá noimó nene goni getununi gosohakukó leke moloaká noune. ");
INSERT INTO gah_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Itó ve makolímohe makolímohe vain nagamí litahagó noaká noike, áminamú laga avisekago gosohá vain nagamí natove loko gelesá amive. Litaha vain nagamí nene vatí oko neve loko loaká noive. Loko limó nene litaha monó sunímini amupiló nene ezáa gosohá monó molo apizesá nene etamive loko anoza gakó limó. ");
INSERT INTO gah_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Holisi gamena makokú nene Izesú eza izegipala zuhagi kilé mikú mihina niake, izegipala zuhate kiléma akutiake gihiláa kigizanitunú hisiki nimi vamó. ");
INSERT INTO gah_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Lá niago, Palisaio monó ve lugáate ánigiake gili golesa ake láa liki lamó: Holisi gamenagúma nenazo, hoza nalemó nene netá golesa lilí niave. Lá amoakalímini nene nanamú naleve. ");
INSERT INTO gah_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Liki likago, Ómasímo vegenala zuhate netakumú vitagá niko ezáa lo huka gakó nene hanuva molo gaheva itimó neve liki gilitave loko Izesú láa loko lo kimike limó: Gozapá agulizaki ve napa Tevitige vegenala zuhagi nosánetakumú gaúna hiliake netá makó alemó nene lekeza gakó gatinamóza, mogona gelemiki nilahe. ");
INSERT INTO gah_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Tevití eza Ómasímini monó numukú itekago guguni gizoaká ve napámo Ómasímini avogisaló mila peletima ameko ezagi makó mina vegená kimigo namóma neve. Ámina peleti nene hanuva vegenalite namitave liki guguni giziaká vetegó natave liki alévolé iki li hutinamóza ámina gamena nene hanuva vegenalite gopa namó neve. ");
INSERT INTO gah_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Loko loake, Izesú miní ameko láa loko lo kimimó: Okulumakutí lumu ve gihila neza holisi amelahina nounazo, izegipáne zuhate holisi gamenagú lilí ita netá nene není netale, loko limó. ");
INSERT INTO gah_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Holisi makokú Izesú nene monó numukú iteko monó lainim-oketoko noigo, agizani zamagaloka nakeseta ve makó minamó. ");
INSERT INTO gah_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Noigo, monó mogona apí-ikimiaká vegi Palisaio monó vegi keza ámina vema alémo lamaná okikoma imane holisimagú nenazo, goní otatunize liake, gizapa iki minamó. ");
INSERT INTO gah_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Lá iki kagata gelemoláa nene Izesú ánigoake, agizani nakeseta vema otekoko holutegú ote minozo loko lo amekago, eza oteake áminaló ote minamó. ");
INSERT INTO gah_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Lá oko oteneigo, Izesú láa loko lo kimimó: Netá makokumú loká oleketatoze. Holisigú nene netá lamaná alesatímo etatihe netá golesa alesatímo etative. Vegená kelémo lamaná osatímo nehe kepele helesatímo nene neve. ");
INSERT INTO gah_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Loko loake, vegená mukí gonú nokipilike agizani nakeseta ve nene gigizani lutozo loko lo amekago, agizani lutokago, goha lamaná imó. ");
INSERT INTO gah_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Lá imóza, monó mogona apí-ikimiaká vegi Palisaio monó vegi keza kizapaló molokago Izesuni nana otatune liki ligili hagili amó. ");
INSERT INTO gah_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Gamena nene zupa Izesú nene Ómasiloka linogo agokaú itimó. Itike Ómasiloka loko minova minova noigo gó lamó. ");
INSERT INTO gah_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Gó lokago, ho noitigo, izegipala zuhama sele lo kemekago, ikago, keikutí ve 12 kelémo etó oake, kugulizá nene aposolo veve loko molamó. ");
INSERT INTO gah_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Keza lá iki minamó: Kugulizá Saimon agulizá gosohá Pitá ave loko molamó, itó agunala Etulú, itó Zemusí, Zoní, Pilipó, Patolomaió, ");
INSERT INTO gah_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mataió, Tomasí, Alapaioni gipala Zemusí, itó Saimoná eza Loma gamani amisele ahulanogo i ve, itó Zemusí makolímini gipala Zutá, ");
INSERT INTO gah_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","itó Kaliotó numutotí ve Zutá eza minomo noitike Izesuni amimika li ve neve. ");
INSERT INTO gah_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Izesú nene izegipala zuhagi limiake apá geleni makotó neneló viki niago, aí vegenala zuha makoki ve vená mukí Zelusalegatí itó Zutaia apá makotokatí itó age nagamí gahevaloka nene Tulo itó Sitona apatotí keza Izesuni gakó gilitune liki itó kivisi vegená kelémo zokative liki neneló alegesá iki minamó. ");
INSERT INTO gah_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Niago, holosi golesa kigikagú mina vegená nene kelémo lamaná imó. ");
INSERT INTO gah_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Itó Izesuni agupeló ali gilikago aí agupegutí zámuza nenémo netá kivisi vegenáma kelémo zoko asú imó nenazo, alegesá iki mina vegená mukilite ligizani lutoko agupeló ale gilitunitímo lelémo zokative liki gelemó. ");
INSERT INTO gah_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Lá ikago, Izesú nene izegipala zuhama gonukonú kepeleake láa loko limó: Lekeza gohogó vegená neneta, Ómasímini lapaná ali lá itamó nenazo, lokogoliza nivizemó geleaká noive. ");
INSERT INTO gah_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Lekeza netá lamanakumú likivisigo mina vegená neneta, netá lamanalímo likigikagú vaí itimó nenazo, lokogoliza nivizemó geleaká noive. Lekeza ive nama iki nimina vegená neneta, lekeza giza zohí itamó nenazo, lokogoliza nivizemó geleaká noive. ");
INSERT INTO gah_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Okulumakutí lumu ve gihila nenikumule liki vegená makolite mukahá likipiliiki visililikimiiki lekelikumú alivi letivi iiki vegená golesave liki lukugulizatini ali ahulatamó nene, lokogoliza vizitave lokogó gelenouve. ");
INSERT INTO gah_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Lá nilikitikoma likigisa ziki miniki lokogoliza viziki gozapá avóike keza Ómasímini agepagutí gakó liaká a ve ámina iki lilí ikimikago Ómasímo meinava napa kimimó nenazo, okulumakú meinavatini sipisi netimó neve liki gililo. ");
INSERT INTO gah_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Lekeza henotiki vegená neneta, lekeza ehe tináneve. Lokogoliza viziki iki miliki amó mota asú okave. ");
INSERT INTO gah_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Lekeza niki lakagatupa iki nia vegenalita, ehe tináneve. Alika gaúna hilinigave. Lekeza giza zohí iki nia vegená neneta, ehe tináneve. Alika lekeza miluma giliki ive inigave. ");
INSERT INTO gah_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Lekeza vegená mukilite lukugulizá ali otiaká niamó neneta, ehe tináneve. Avóike ámináminiki soza monó lili ali vetini kugulizá ali otiaká amóma nemóza, Ómasímo ámináminoko keikumú giligo itemimóma neve. ");
INSERT INTO gah_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Lá onoimóza, není gakó nigele vegenáise gakó lo likimitoze, gililo. Lekeza gala velini nene likigika kimiiki nasahilí ikitalo. Vaika likamita vegená nene kilími lamaná ilo. ");
INSERT INTO gah_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Lekelikumú alivi letivi nia vegená nene nónohá zikitalo. Gopoguni mililikitata vegenakumú numuna lilo. ");
INSERT INTO gah_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ve makolímo agizanitunú nene gagamipaló helegaloka zekikoma, helegaloka gipilitive loko velegepá ze amezo. Ve makolímo geí hepé goka ipá oko aleko novikoma, geí sioti aleko amanapa amo. Nenegi aleko vitize. ");
INSERT INTO gah_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Itó ve makolímo geí netakumú voká litimó nene hanuva amezo. Itó ve makolímo geí netá aleko vitove lokikoma hanuva amekako aleko vokiko goha ale nimitive loko voká lamo. ");
INSERT INTO gah_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Lekeza vegená makolite némini manámini suni lilí ilitatave liki giliaká nia netá nene lilí ikitalo. ");
INSERT INTO gah_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Vegená golesate kigika limiaká nia vegená nene ligika kimitune liki liaká nianazo, ámináminiki kigika likimiaká nia vegenakó likigika kimitamó nene, Ómasímo lekegepoka lamitive. Vegená golesate kezagi ámináminiki kigika limiaká nia vegená nene ligika kimitune liki liaká niave. ");
INSERT INTO gah_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Lekeza netá lamaná lilí ilikimiaká nia vegenakó nene pekimi iki netá lamaná lilí ikitatamó nene, Ómasímo lekegepoka lamitive. Vegená golesate kezagi ámina suni aliaká niave. ");
INSERT INTO gah_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Lekeza vegená makolite netá makó limitave liki giliiki netá makó kimitamó nene Ómasímo lekegepoka lamitive. Vegená golesate alika keza ámináminiki limitave liki ve golesa makó nene moni kimiaká niave. ");
INSERT INTO gah_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Lá niamóza, lekelisi gala velini likigika kimiiki netá lamaná lilí ikitiki goha limitave liki gelemiki hagitana kimilo. Lá ikiko, alika nene meinavatini napa iteko neiko, lekeza okulumakuka Ómasímini izegipa lamaná minatave. Ómasi eza agepoka lama vegenaki vegená golesagi hanuva muluna moloketake lehizekimiaká noive. ");
INSERT INTO gah_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Lekeza lá iki ametipo miluma gelelikimiaká noimómámini iki vegenakumú miluma gilikitalo. ");
INSERT INTO gah_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Lekeza nene vegenalitini mogonataganamú lotuva legemilo. Lá niko Ómasímo lekelí mogonataganamú lotuva legeminogo ive. Lekeza vegenalitini lihimamú gakó li hukikitamilo. Lá niko Ómasímo lekelí lihimamú gakó lo hukoleketaminogo ive. Lekeza vegenalitini lihima ahulikitatamó nene, Ómasímo ámina oko lihimatini ahuloleketanogo ive. ");
INSERT INTO gah_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Lekeza vegenalititoka iki miliki ita polosava nene Ómasímo ámináminoko lekelitoka oko moloko inogo ive. Ómasímo lamaná oko likigikagú lehizelikimioko mí zeko hilulú oko nogúeko goha gúitimó nene velemó zesá oko minanogo ive. Lekeza gona miliki kimiaká niamómámini avotigila oko Ómasímo ámináminoko gona moloko likiminogo ive. ");
INSERT INTO gah_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Loko loake, miní ameko netá golesáinimú anoza gakó makó láa loko lo kimimó: Agómula lilikupá mola ve makolímo agómula mola ve makó nene gapo alapizitihe. Óe, lá oko nomive. Ve lilikupá losi nenetosa eza agizató aliko eza agizató aliko vitáimó nene lositáma galegú hilanigasive. ");
INSERT INTO gah_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Itó sukulu izegipa makolímo litá oko tisala avilegemitive. Alika sukulu loloko voko gele asú okoko tisala nenéminoko minanogo ive. ");
INSERT INTO gah_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Geza gigivekahini agómulagú gilisá onoive loko lanimóza, gezaka gogómulagú za lana vonoimó nene nanamú ánigo lamaná amoko lane. ");
INSERT INTO gah_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Gezaka gogómulagú za lana vonoimó ha nego ánigamanimó nenazo, géisi nene nigivénega, gogómulagú gilisá vonoimó nene ale ahulogetatove loko nanamú nolane. Geza sozaló ve genezaka losi minamó neneka, gezaka gogómulagú za lana nemó nene goí oko ale ahulooko gogómulatunú ánigo vevesooko alika nene gigivekahini agómulagú gilisá onoimó nene ale ahulotatanimó nene etanogo ive. ");
INSERT INTO gah_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Itó za lamaná makolímo gihila golesa zeminogo ive. Itó za golesa makolímo gihila lamaná zeminogo ive. ");
INSERT INTO gah_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Za gihilamámo ámina zámini lamaná imoláahe golesa imoláahe ale utó oaká noive. Hilipa nenémo gizasi apelekiko hukiki natahe. Itó gumené nenémo loisi apelekiko akutiki natahe. Lá oko nomive. ");
INSERT INTO gah_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ámináminoko ve lamanalitini kigikagú netá lamaná minatimó nenazo, kigikagutí vatí sunigó ititimó neve. Ámináminigó oko ve golesatini kigikagutí nene golesa sunigó ititimó neve. Ligikagú vaí o minakutí legepagutí loaká noune. ");
INSERT INTO gah_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Lekeza nenikumú Guivahaniteve Guivahaniteve liaká niamó neneta není gakó nene nanamú ámegetisá amave. ");
INSERT INTO gah_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Nenitoka iake není gakó gili aliaká nia vegenalitini mogonamú lo likimitoze. ");
INSERT INTO gah_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ve makolímo numuni ginogo gale hána legeake gehani amupiló lapusa hizeake, numuni gekago, golini zike nagamí napa veleko una napa nenémo ake numunima ahelú imóza, numuni nene geható ginazo, mómoká amike alévolé oko minamó. ");
INSERT INTO gah_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Nenéminiki niamóza, ve makolite není gakó giliakaláa giliake není gakó gili alisá amave. Keza nenéminiki niave. Ve makolímo numuni ginogo lapusa hizemoko mikasi veletó soza moloko numuni gekago, alika nagamí veleko una napa nenémo ake ahelú okago, numunima litá oko lemeko pou loko akamó. ");
INSERT INTO gah_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Izesú eza monó gakóma neneló lo keme asú oake Kapanao numutoka vimó. ");
INSERT INTO gah_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Neneló Loma apatotí ami vetini gizapa ve makolímini gelekelé veva netá napa gizaleake helesakosá oko noigo, gizapa vevámo izegipalamú nene amekumú izegipala nenazo, ");
INSERT INTO gah_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Izesuni gakoláa geleake, Zuta vetini ve uvóipini makó nokimisilike Izesuni li amikiko okoko není gelekelé izegipa nene avisi netáma alémo zokatihe liki viki loká ilo loko loketamó. ");
INSERT INTO gah_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Lokimiake kimiselekago, keza Izesutoka viki anitiake amuza miliki láa liki li amemó: Lelí lova vetémini gizapa vema oko moloko noimó nene lamaná noive. ");
INSERT INTO gah_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Eza nene agikáa nene leza Zuta vegená lemeaká noive. Itó monó numute utó itive loko nene moni napa molokago, akohekago, gilitamóma neve. Lá oaká noi vema nenazo, gakola gele amitanimó nene vevesanogo ive. ");
INSERT INTO gah_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Liki li amikago, Izesú geleake kezagi makó vamó. Viki numu ávatiha vikago, lova gizapa ve nenémo agive makó nene Izesutoka nokimisilike gakó láa loko kimiselekago vamó: Guivahanínemaka, neza ánéáminaloka goselé gapo okoko numúnegú nanamú ititane. Áminaló minozo. ");
INSERT INTO gah_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Nezánemú gulumó vevesamigo, geitoka vamuve. Nenemú gezama hanuva neneló nooko gegepatunú lokako gelekelé izegipáne zokative. ");
INSERT INTO gah_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Neza ámináminoko kugulizaki vetini gelekeleláa nouve. Itó ami ve makó nene není gizapaló niave. Lá niago keitokatí makokumú vozo lomikugo hanuva vinogo ive. Itó makokumú ano lomikugo nene hanuva anogo ive. Itó gelekelé izegipánemú nene voko hoza alezo litomó nene hanuva voko hoza alinogo ive. Nenéminoko geí gakó nene alévolé onoinazo, hanuva áminaló minoko gakó lokako avisi netá zokative loko lunae. ");
INSERT INTO gah_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Liki li amikago, Izesú nene ámina gakó geleake, ámina ami vetini gizapa vema sigaga lotake mino viligoake, ámegetiki va vegená láa loko lo kimimó: Neza lamaná lo likimitoze, gililo. Isilae vegená lekezalokatí gele alévolé oaká nenémináa makó ánigoko gelesá onamumóma neve. ");
INSERT INTO gah_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Loko lokago, ami gizapa vémo kimisili vegená atiginá iki numutoka vake ámina vémini gelekelé ve ánigamó nene zokoake noigo ánigamó neve. ");
INSERT INTO gah_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Lá okago, Izesú mino hána amike apá makó agulizá Naino neneloka izegipala zuhagi nivago vegená mukí kémegetiki vamó. ");
INSERT INTO gah_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Viki numu gatetó nanitego gonosi makó zaló miliki aliki lememó nene, gevoná vená makolímini gipala hámakó minamó nene helekago, gale zinigi numutotí ve vená mukí nilemego, ");
INSERT INTO gah_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Guivahanímo gevoná venáma ánigoake muluna gitihiná okago ive amo loko loake ");
INSERT INTO gah_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","vike ukoakoló ale gilimó. Ale gelekago, gihiake otinago, Izesú gipa geza otitane loko noluze, otemane loko lokago, ");
INSERT INTO gah_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","helenei netalímo oteake gakó akó limó. Noligo, Izesú nene izolahiki goha minatáive loko lotamó. ");
INSERT INTO gah_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Lomikago vegená keza ániga netakumú kelegesá goha legekago, Ómasi agepoka lake Ómasímini agepagutí gakó loaká ve napa nene holutegú utó oko noive liki likago, lugáate Ómasímo vegenala zuha lelémo vatí inogo ve imane amiselekago okave. ");
INSERT INTO gah_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Liki likago aikumú gakoláa nenémo Zutaia mikasiuka itó mikasi helega helegaloka voko oko imó. ");
INSERT INTO gah_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Zoní nene nagá numukú noigo, izegipala zuhate Izesú oko moloko i gakola avetó iki li amikago, ");
INSERT INTO gah_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ámina gakó geleake, Izesukumú agata losi geleake, keikutí ve lositá alesa moloake Guivahanima láa liki loká itáive loko kimisilimó: Utó itive liki monó gotolaú luhuva giza vema nene géisi noape itó alika makó utó itikumú ageva itune, liki lilizo loko kimiselekago, ");
INSERT INTO gah_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","ámina ve keza Izesutoka viki lasimó: Monó nagamí holokimiaká ve Zoníma gologí oletative loko lo mololeta ve ative liki li milamóma géisi nene noape, itó makokumú ageva itune liki loká ilizo loko limiselekago nousive. ");
INSERT INTO gah_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Liki likasigo, ámina zupama Izesú nene mukí kivisi vegená itó netá gizale vegená kelémo zokoká itó kigikagutí holosi golesa kepeleko kimiseleká itó kogómula likamó ale pulusoketoká imó. ");
INSERT INTO gah_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Lá noigo, ve losima anitiki loká imikasigo Izesú nene ámina vema noive loko Zoní gilitive loko láa loko lo kimimó: Lekeza atiginá iki viki netá matá imane loló nougo ánigiki miliki asimó nenémini gakola avetó iki Zonini li amilizo: Kogómula lilikupá molamó nene kogómula ale hanatokimiaká noive. Kigisaló alimó nene ale lamaná okimiaká noive. Halamé gizalemó nene gililiaká niave. Kagata molamó nene kagata ale koló okago gakó giliaká niave. Lepa gonosi kelémo oteaká noive. Itó limiki minamó ámemena nenete není gakó lamaná giliaká niave. ");
INSERT INTO gah_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Lá onoinazo, makó keza není mogonamú kagata losipasi gelemitamó nenete kogoliza viziki minanigave liki li amilizo. ");
INSERT INTO gah_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Loko Zoní kimisili vema lo kemekago, atiginá iki nivasigo, Izesú vegená sii sii liki minamoláa Zonikumú láa loko lo kimimó: Lekeza Zoní noitoka mikasi gomopalaló vamó nene nanakitana vema ániganigi vamóma neve. Ve makó akepagitana oko hepelímo aleko mómoká noiko ániganigi vamóma nehe. ");
INSERT INTO gah_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Itó ve makó gonanalivagi gó ale akoloake noigo ániganigi vamóma nehe. Gilinahe. Luhuvagi gó ali akiliki miniaká nia ve keza kugulizaki vetini numuni napagú akiki otiki minake nosá hisugú viziaká niave. ");
INSERT INTO gah_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Lekeza Ómasímini agepagutí gakó loaká ve makó ániganigi vamóma neve, olo. Itó makó lo likimitoze, gililo. Lekeza ánigi mina vema Ómasímini agepagutí gakó liaká ve lugáa keikitana minamive. Eza haitolíminoko minokave. ");
INSERT INTO gah_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Monó gotolaú Ómasímo gakó makó láa loko limó nene láa liki luhuva gizinamóma neve: Gililo. Není gakó lole ale ve makó amiselekugo, ale goí oko voko kigikagú hoza alitanimómámini gapoga velegetanogo ive. Loko li gakó nene Zonitoka vo alimó neve. ");
INSERT INTO gah_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Loko loake, láa loko limó: Neza lamaná lo likimitoze, gililo. Mikasiuka utó ina vegenakutí makolímo Zonini ma avilegesá amive. Lá onoimóza, Ómasímo gizapa okimiaká noi vegená limiki niamoláa kezagi gopa Zonini aviligitigí iki niave. ");
INSERT INTO gah_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Loko lokago, takisi aliaká nia vegi vegená lugáagi keza ámina gakó giliake Zonitokatí monó nagamí amunaloka emane hilinamó nenazo, Ómasímini gakó hizi lé ikago gihila zimóza, ");
INSERT INTO gah_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Palisaio monó vegi monó mogona apí ikimiaká a vegi keza nene Zonini monó nagamikumú goselé iake Ómasímo veleketa gapo nene ánigi ahulamó neve. ");
INSERT INTO gah_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Loko loake, Izesú makó láa loko limó: Oko moloko nougo ánigiaká nia vegená nene nanetató lo moloko lokugo vo guni itive. Hiláagitana niave. ");
INSERT INTO gah_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Keza gili goselé iaká nia izegipagitana niave. Izegipa keza alegesá apatoka minake izegipa lugáama sele liki leza nama luható nene nanamú nama lisá amave. Itó helegaloka nene ive nama luható nene nanamú ive nama isá amave liki li kimiaká niave. ");
INSERT INTO gah_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Itó nezagi Zonímagi ámináminoko nousigo goselé lekepeleaká noive. Monó nagamí holokimiaká ve Zoní eza apí oko hozaváa nalike iza goula nosá zahí nagamí lamaná namike etó oko minokago lekeza ánigiake holosi makolímo agika ale gopa okago noive liki lamó. ");
INSERT INTO gah_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Itó okulumakutí lumu ve gihila neza lemeko iza goula zahí nagamí nosánetá lamaná noaká nougo ánigiake ve imane ánigalo. Áisi nene gasova ve nagamitó ve eza nene takisi aliaká ve itó ánigo goselé oaká nouhá vegená makolitini zogonini noive liki liaká niave. ");
INSERT INTO gah_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Láa nilamóza, Ómasímo gele guni oko netá matá aleaká noimó nene vevesokogó minoaká noigo, izegipala zuha keza nenémini mogona ali utó iaká niave, loko limó. ");
INSERT INTO gah_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Palisaio monó ve makolímo nosánetá natane loko Izesuni alesa molo amekago, numunagú itiki nosánetá niki minasimó. ");
INSERT INTO gah_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ámina apatotí mokoló vená makolímo Izesú eza Palisaio monó vemámini numukú iteko noive liki lamóma geleake, anuva hilina gehanigitana gonigú minamó nene aleko iteko, ");
INSERT INTO gah_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","amegesaloka noike ive noigo, agómula nogoza nene Izesuni agisaló lemekago, gotola zopovatunú nene agisa gilatotamó. Gilatomiake, Izesuni agisa nene agoka legeko nonake, anuvavagi meseme nene agisaló holotamó. ");
INSERT INTO gah_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Holomikago, Izesuni alesa molo ami ve nenémo ánigoake, agikatunú láa loko gilimó: Imane Izesuni agupeló ale nogili vená nenémo golesa netató vená noive. Izesú eza ató imane Ómasímini agepagutí gakó loaká ve minalina, ámina venalímini mogonamú nene moko mogonaló venale loko gililine. ");
INSERT INTO gah_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Loko agikatunú gelekago, Izesú nene Saimonao, neza gakó makó lo gimitoze loko lo amekago, tisánemaka, lokako gilitove. ");
INSERT INTO gah_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Loko lokago Izesú anoza gakó makó láa loko limó: Ve makolímo alikamule loko loake moni nene ve losi gutá kimimó. Makó nene 500 kina amimó, itó maga ve nene 50 kina amimó. ");
INSERT INTO gah_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Lá okago alika nene áminaló nene pekimitíive liki monimú vitagá asimó nene nomigo, eza ahulalizo loko lokago, ali haha asimó. Keitokatí hilímo aikumú lagaváa napaló geleneitive. ");
INSERT INTO gah_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Loko lokago, Saimoná láa lo amimó: Nagata gulumó moni nekisala napaló ahulota ve nene neitive. Loko lokago, Izesú geza vatí oko lokane. ");
INSERT INTO gah_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Loko loake, venáma noitoka viligo moloake Saimonani láa loko lo amimó: Vená imane ánigonape. Neza numukagú itekugo, géisi nigisa nigizani nagamí zito nagamí leke molonetamako, imane vená nenémo ive nogozatunú nigisaló holonimiake gotola zopovatunú nogilatonetave. ");
INSERT INTO gah_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Itó géisi leza Zuta vetini suni aleko nogoka negepa namanimóza, vená imanémo numukagú apí oko noitugo nigisáne amuza moloko agoka agepa nonave. ");
INSERT INTO gah_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Géisi oaká nouhá netá aleko gotónegú nene meseme holonetamanimóza, imane vená nenémo nigisáneló anuvavagi mesemetunú holonimikave. ");
INSERT INTO gah_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Neneló láa loko lo nogumuve. Imane vená eza nenikumú geleake nasahilí napa onimikago lihimala mukí ahulomikuve. Makó eza lihimavala koma ahulomikiko noititímo nene lihimavala gilatota vema agika napa ameminogo ive. ");
INSERT INTO gah_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Loko loake, venáma láa loko lo amimó: Lihimaka ahulo asú ogimikuve. ");
INSERT INTO gah_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Loko lokago, ezagi nosá niki mina vegená keza kigikatunú láa liki lamó: Áisi haitolíminímo nolihe. Lihimavaka asú okave loko nolimó nene hí ve suka nolive. ");
INSERT INTO gah_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Liki nilago, Izesú nene venáma láa loko lo amimó: Nenikumú gele alévolé anitímo gelémo lamaná okaze, mulukagú hulu iko vozo, loko limó. ");
INSERT INTO gah_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Nene zupa velelaló nene Izesú eza apá koma napaló mohona ike vegená nene monó lo kemeko Ómasímini gizapaló minoakalímini gakó lamaná lo keme keme oko mohona imó. Mohona noigo, ámegetiki mihina niamoláa nene izegipala zuha 12-a ");
INSERT INTO gah_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","itó vená lugáa amunaló emane kigikagutí holosi kepeleko kimisilimoláa itó kivisekago niago kelémo zokamoláa keitokatí makó Maliá agulizá Magatalalo liki milamó, agikagutí holosi 7 kepeleko kimisili vená, ");
INSERT INTO gah_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","itó makó agulizá Zoaná eza Heloteni hozaló gizapa ve Kuzani venala, itó Susaná itó vená lugáa keza moni henokanonigi miniake Izesugini nasahilí ikitiki minamó. ");
INSERT INTO gah_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Numutó namató ve némitó ve Izesutoka vóvotiki alegesá iki minamó. Lá niago, ánigoake anoza gakó makó láa loko lo kimimó: ");
INSERT INTO gah_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Zuha netá atilí oaká ve makolímo netá gihiláa atilí inogo vimó. Mikuka atilí omo novigo, gihila lugáa gapoló alemó zekago, vegenalite lisiki matelé zemó. Itó gaha namate ake ni asú amó. ");
INSERT INTO gah_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Itó gihila lugáa nene gehani amupiló lemeko minake, goloko iteakaláa itekamóza, mikasi nogoza minamigo osagava vizeake hilimó. ");
INSERT INTO gah_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Itó gihila lugáa nene lilihámini luhusa nene mikasigú ha netó lemeko minake goloko itike liliha nenémo zemikago, nogotamó. ");
INSERT INTO gah_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Makó nene mikasi lamanakú lemeko minake goloake, gihila mukí zimó. Hamó zámo nene gihila 100 zimó. Loko lo asú oake, gakó napagutí láa loko limó: Lakagatagi minatamó neneta, gakó imane gili hee liki gililo, loko limó. ");
INSERT INTO gah_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Loko lokago izegipala zuhate anoza li gakokumú loká itago, ");
INSERT INTO gah_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","eza láa loko lo kimimó: Ómasímini gasovaló minoakalímini asuguná gakó lekeza gilitave loko lonoimóza, lugáa keza nene anoza gakokó gilitaze. Lá niiki netá matá kogómulatunú nene ánigatamóza ánigi vevesaminigave, itó kagatatunú gakoláagó gilitamóza, mogonáa gili vevesaminigave. ");
INSERT INTO gah_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Itó anoza gakó imane nolumó nenémini mogonáa lá oko neve. Zuha netá gihiláa nene Ómasímini gakó neve. ");
INSERT INTO gah_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Gihiláa gapoló lemeko minamó nenéminiki minatamó keza monó gilitamó nene kigikagú limitimóza, áminasitó Satá nene gili alévolé ikiko Ómasímo kugutó vizekative loko aniteko ámina gakó nene ipá oko aleko voaká noive. ");
INSERT INTO gah_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Itó gihila lugáa gehani amupiló lemeko goloaká imó nenémini iki minatamó keza monó nigiliki laga kivisekago giliaká niamóza, kigikagú luhusáini alemigove liki gamena alínipa alinago giminikú moloaká netá utó okago monóma ahuliaká niave. ");
INSERT INTO gah_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Gihila lugáa lilihagú lemeko minamó nenéminiki minatamó keza monó giliakaláa gilitamóza, kugupémini netakumú gelekeleláa niminiko, moni henokanonímini lagavámo kigikagú lemeake monóma zemikago, keitoka gihila utó oko guzá losá amive. ");
INSERT INTO gah_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Gihila lugáa mikasi lamanakú lemeko minamó nenéminiki minatamó keza monó giliiki kigika ali guni iiki legesó iki ali minikago, keitoka monolímini gihila utó oaká noive. ");
INSERT INTO gah_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Hí vémo liví legeoko somotunú ze hitatimó neve, itó hí vémo legeoko sepekú lolosá gitimó neve. Lá oko nomive. Itita vegená nene hize hanatoketative loko legeoko holomaló molanogo ive. ");
INSERT INTO gah_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ámináminoko Ómasímini asuguná onoi netá nene mino-loko voko tolova amitive. Minoko utó o asú inogo ive. Halá genei netá nemó nene ámina oko utó o asú okoko hitaminogo ive. ");
INSERT INTO gah_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Monó alinita vegená nene vatí iki gizapa iki ali minatamó nene Ómasímo goha miní ameko makó kiminogo ive. Itó makó keza monóma lamaná iki gizapa amitamó nenete alenoupe liki litamóza, goha ipá oko alekiko hanuva minatamó neve. Nenemú lekeza gakó imane nigiliki gili guni iki gililo, loko limó. ");
INSERT INTO gah_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Gamena makó nene mukí vegenalite Izesuni hizi vigiake niago, Izesuni izolage izegipa agunamotamolave ake vegenakumú olovó ziake mini hetó minamó. ");
INSERT INTO gah_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Lá niago, ve makolímo ánigoake Izesuni nene izokage izegipa gugunamotamokama geí ániganigi amó nene hetoka niave. ");
INSERT INTO gah_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Loko lo amekago, Izesú nene vegenáma láa loko lo kimimó: Ómasímini gakó giliiki gili alitamó imanete není izónege izegipa nugunamotamóne niave, loko limó. ");
INSERT INTO gah_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Gamena makó zupa Izesú ave izegipala zuhagegi nagamikú lapegú itemó. Itiake, Izesú nene nonohuló likeko vola helegaloka vitune loko lokago, giliake, vamó. ");
INSERT INTO gah_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Nivake, Izesú nene agómula ahihí okago, avó akonoigo una napa nalike nonohulóma golesa oake valahuká nozike sipimámini agikagú lemeko vaí oake, nagamí nonohulokú hilisá amó. ");
INSERT INTO gah_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Lá niake, Izesuni alími oteke láa liki li amemó: Gizapa velemaka, leza nagamí nonohulokú simá nanogo nouhá lae. Liki likago, Izesú oteake, unamagi nagamí valahukámagi gahá kemekago, kii nolike zou limó. ");
INSERT INTO gah_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Zou lokago, lekeza gili alévolé iakatini hí neve. Loko lo kemekago, izegipala zuhate keza ámina netá ánigiake, kelegesá legekago, sigaga lake ligili hagili niake, agae, ve imanémo hepeki nagamí valahukaki gakó lokimikamó nene gili alikasimó nenazo, ve imane haitolímini netive, liki lamó. ");
INSERT INTO gah_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Lá okago, Galilaia nonohuló helegaloka Gelegesa vegenalitini mikasiuka vi anitemó. ");
INSERT INTO gah_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Neneló anitiake nagamí gahevaloka nitego, numuni apá napalokatí ve makó ake Izesuki hotu lasimó. Ámina vémini agikagú nene holosi golesa mukí minikago gamena hána gó luhamike minake numukú akosá amigo, hanuva geha mulikú gonosi milimiligukó akoko mohona oaká i ve minamó. ");
INSERT INTO gah_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Ámina holosite gamena gamena ámina vémini agikagú alévolé iki minikago, vegená keza agisa agizató seni nagatunú ziake gizapa iki minamóza, holosi nenete nagá nene apiliki hukimikago golisi mikasi gomopalaló voaká imó. Áisi nene Izesuni ánigoake gopaga like agisauka pou loko mikasiló akoake gakó napagutí gamoga geko láa loko limó: Izesuvo, Ómasi napámini gipalamaka, géisi nene nana netá golesa onetanogo noane. Loko lokago Izesú nene holosi golesa geza ámina vémini agikagutí itekoko vamane loko lo amekago, holosi nenémo amanapa ike geza miluma hoza nememitane loko alévolé oko loká nogetuve. ");
INSERT INTO gah_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Loko lokago, Izesú loká otake limó: Gugulizaka éagave. Loko loká omikago, holosi vaí iki agikagú minamó nenazo, neza nugulizáne nene ami mulusi nouve loko limó. ");
INSERT INTO gah_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Loko lokago, holosimate meikú limisele molamitane liki negénegeka lamó. ");
INSERT INTO gah_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Liki likago, ámina mikasiló iza gululusi mukí nene agokaú gale niki niago, limiselekako izatini kigikagú limitune liki negénegeka likago, gele kemekago, ");
INSERT INTO gah_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","holosi golesa nenete ámina vémini agikagutí itiake vake izatini kigikagú itiake limikago, ámina iza keza olíi miliake meiniló limiake nonohulokú limiki nagamí niki hutiake helemó. ");
INSERT INTO gah_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Limiki hilikago, iza gizapa vemate ánigiake ololu liki taoniloka itó numuni amegesaloka viki avetó iki li kimikago ");
INSERT INTO gah_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","vegená keza ámina utó i netá ániganigi viake, Izesutoka anitiake holosi agikagutí kimiselekago va vema nene luhoaká gó luhoake itó geleakaláa lamaná okago, Izesuni agisauka gakó geleko noigo, ánigiake kelegesá ligimó. ");
INSERT INTO gah_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Lá niago, ámina netá ániga vete holosivagi mina ve lamaná ikumú nene ánigi mina vegená avetó i kememó. ");
INSERT INTO gah_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Lá ikago, Gelegesa mikasiuka amelage keza kelegesá goha legekago, Izesú eza nene mikasinini ahulooko vitive liki li amemó. Li amikago, eza atiginá oko vinogo nagamikú lapegú itimó. ");
INSERT INTO gah_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Noitigo, holosi agikagutí kimiselekago va vemámo Izesuki minatíive loko negénegeka lokago, Izesú gele amemike láa loko lo amimó: ");
INSERT INTO gah_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Geza numukaloka voko Ómasímo loló ogeta netá lamanalímini gakoláa nene vegenaka lo kemezo loko amiselekago, ámina vemámo atiginá oko vike Izesú loló ota netakumú nene apá amelagini lo utó oko lo keme asú imó. ");
INSERT INTO gah_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Lá okago, vegená keza vola helegaloka Izesukumú ageva iki niago, atiginá oko omo anitekago, ánigiake, geké vaké limikago, ");
INSERT INTO gah_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","monó numukú agulizaki ve makó agulizá Zailó loko noi vémini mohola hamokó aí kilisimasiva 12-a mina mohó nene helesakosá oko minokago eza ake Izesuni agihúna geko numúneloka makó vitíive loko negénegeka loko limó. Lá okago, makó nivasigo, vegená keza sii sii liki nivago, ");
INSERT INTO gah_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","holúikú vená makó minamó nene ikanímo apelekago númase gapo molova molova oko noigo, kilisimasi 12 oko novigo lusa ve nene moni keme asú imóza, keza lusa geha geha asú amitimó okago ahulitamó. ");
INSERT INTO gah_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ámina venalímo Izesuni amegesaloka oake, luhoaká gó gahevaloka ale gilimó. Ale nogiligo áminasitó nene golaniva utamó. ");
INSERT INTO gah_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Lá noigo, Izesú loká oketoko éaho nugupeloka ale gilive loko lokago, vegená keza egamega ikago, Pitá láa loko limó: Gizapa velemaka, vegená sii sii liki nivamó nenazo, makolímo noitive. ");
INSERT INTO gah_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Loko lokago, Izesú láa loko limó: Óe, makolímo nugupeló ale nogiligo, zámuzáne makó nene nugupelotí novigo noguluke noluve. ");
INSERT INTO gah_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Loko lokago, vená eza mogonáne mota utó noinazo loko geleake, luvoluvo zeake Izesuni agihúna geake, vegenalitini kovogisaló nene avisi netalímini mogona itó ale nogilike zokamó nenémini mogona lo utó okago gili asú amó. ");
INSERT INTO gah_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Nigelego Izesú láa loko lo amimó: Mohónemaka, nenikumú gele alévolé anitímo gelémo zokokave. Mulukagú hulu iko vozo. ");
INSERT INTO gah_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Loko noligo, monó numukú agulizaki vemámini numukutí ve makolímo oake láa loko limó: Mohokama mota helekave. Lá okanazo, tisate nene goselé gapo hanuvamú okatize, ahulikozo. ");
INSERT INTO gah_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Loko lokago, Izesú geleake Zailoni láa loko lo amimó: Geza gehelele vizemiko gele alévolé okogó minatanimó nene, mohoka goha otinogo ive. ");
INSERT INTO gah_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Loko loake, numutó vo aniteake vegená makó nene ámina numukú itemitave loko lokimikago, hetó niago, Pitá Zoní Zemusí itó mohó izolahiko amelahiko kezagó kelémoko itimó. ");
INSERT INTO gah_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Iteke ve vená keza ámina mohó ive nama itiki niago, ánigoake goha alémo otitikumú geleneike anoza gakó láa loko lo kimimó: Ive amilo. Mohóma nene helemive. Hanuva avó akonoive. ");
INSERT INTO gah_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Loko lokago, mota heleneimó nemóza liki giliake giza itamó. ");
INSERT INTO gah_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Giza imikago, Izesú nene agizató aleake sele loko mohó geza otezo loko lokago, ");
INSERT INTO gah_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","áminasitó ameni atiginá okago otimó. Otekago, nosánetá aliiki mohóma amiko native loko loketamó. ");
INSERT INTO gah_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Lokimikago, izolahiko amelahiko keza gelesimó nene golivagi netá loló imó. Lá okago, Izesú nene ámina netakumú gakó avetó iki vegená li kememitave loko lo hukoketamó. ");
INSERT INTO gah_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Izesú eza izegipala zuha 12-pala sele lo kemeake vegenalitini kigikagutí holosima gale gihiki kipiliki kimisilitave loko itó kivisi vegená kilími zokatave loko nenémini zámuza kimimó. ");
INSERT INTO gah_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Kemeake, Ómasímini gizapaló minoakalímini gakó li kimiki kivisiti vegená kilími zokatave loko nokimisilike, ");
INSERT INTO gah_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","gakó láa loko lo kimimó: Gapo vitatoka netá matá aliki vamilo. Hánusa akiseaká gó peleti moni nene alemiki, itó gó lositá luhamiki vilo. ");
INSERT INTO gah_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Itita numuni makokú itiikima, ámina numukú akiliki niviki ámina apatotí vitave. ");
INSERT INTO gah_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Apá makotoka likilími lamaná amikoma, ámina apá ahuliiki niviki vahé miliki likigisalotí mumusopa nene usagamá zi ahuliiki vilo. ");
INSERT INTO gah_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Loko lo kemekago, keza numutó namató vake Izesuni gakó lamaná nene li utó i kimi kimi iká kivisi vegená kilími zokiká amó. ");
INSERT INTO gah_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Lá niago, agulizaki ve Heloté nene aposolote alévolé netá lilí niakumú geleake, agata gululusi gilimó nene, ve makolite Zoní nene heleneikutí oteake ámina netá loló noive liki nilago, ");
INSERT INTO gah_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","itó makolite nene Ómasímini agepagutí gakó loaká i ve Ilaizá goha utó okave liki liaká niago, makolite nene gozapá Ómasímini agepagutí gakó liaká a vegutí makóma Ómasímo alémo oteneive liki liaká amó nene, ");
INSERT INTO gah_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Heloté geleake, láa loko limó: Zonini luvana hukumóza, ve makokumú gakoláa nenémika liki lago nogulumó nene hí ve noitive. Loko loake, Izesuni ániganogo gilimó. ");
INSERT INTO gah_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Aposolo keza monó hozaló kimisilitotí atiginá iki iake, keza iki miliki a netakumú Izesuni avetó iki li amemó. Avetó iki li amikago, eza kelémoko vike kezáikó apá makó agulizá Petesaita numutó vi anitemó. ");
INSERT INTO gah_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Lá niago, ve vená mukí keza giliake, Izesuni ámegetiki nivago, eza kelémo moloake Ómasímini gasovaló minoakalímini gakó lo kimike, kivisi vegená kelémo zokamó. ");
INSERT INTO gah_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Lá noigo, únaká nene gamena asú inogo noigo, izegipala zuha 12-palamate iake láa liki li amemó: Leza mikasi gomopalaló nouninazo, vegená kimiselekako luhuva numutokagi iza gihiló numutokagi viki nosánetakumú vitagá iki niiki akatave. ");
INSERT INTO gah_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Liki likago, Izesú nene lekezatini nosánetá kimiki nalo loko lokago, keza anotó aliki láa liki lamó: Peleti ligizani lugaloka asú igo itó lagaha lositakó molonounimó nenazo, leza imane vegenalitini nosánetá voko meina hizeketatune loko nolape. ");
INSERT INTO gah_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Liki lamó nene áminaló mina véa 5000 nenéminiki niago giliake láa liki likago, Izesú nene izegipala zuha láa loko lo kimimó: Mukí vegená nene 50 50 nenéminiki mulusi miliki minalo liki likitalo. ");
INSERT INTO gah_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Loko lokago, keza izegipala zuhate láa liki likimikago, vegenáma mulusi miliki niago, ");
INSERT INTO gah_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Izesú nene peleti ligizani lugaloka asú igoma itó lagaha lositámagi aleake, okulumakú okenava oko nánigake Ómasi agepoka loake peleti gitegeake, ámina nosánetá gona miliki kimitave loko izegipala zuha kimimó. ");
INSERT INTO gah_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Lá okago, vegená mukilite nikake kagatupa okago, nosánetá lumáa ali nupa iki gosúveha 12 vaí okago ali milamó. ");
INSERT INTO gah_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Gamena makó nene Izesú eza Ómasiloka loko noigo, izegipala zuha kezagó neneló niago, eza loká oketake vegenalite nenikumú éahove liki liaká niave. ");
INSERT INTO gah_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Loko lokago, keza láa liki li amemó: Monó nagamí holokimiaká ve Zoníma goha utó noane liki liaká niave. Itó lugáate nene Ilaizá gozapá okulumakú iti vema goha lemeko minane liki liaká niave, itó lugáate nene gozapá Ómasímini agepagutí gakó liaká vegutí makó nene galegutí otekave liki liaká niave. ");
INSERT INTO gah_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Liki likago, Izesú loká oketoko lekelisi nenikumú éahove liki liaká niave. Loko lokago, anotó aleko Pitá nene geza Ómasímo gologí oletatane loko lo mololeta vema noane, loko limó. ");
INSERT INTO gah_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Láa loko lokago, Izesú láa loko lo hukoketoko limó: Lekeza imane gakó lo nolukumumó nene vegená makó li kememilo. ");
INSERT INTO gah_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Okulumakutí lumu ve gihila neza nene monó gizapa vegi guguni giziaká ve napagi monó mogona apí-ikimiaká vegi keza miluma netá mukí nimiiki není ánigi goselé ikiko nipili hilikiko, gamena losive makole minokinake heleneitokutí goha otinogo uve. ");
INSERT INTO gah_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Loko loake, vegená mukí láa loko lo kimimó: Vegená makolite není némegetatune liki nigilikima nene kugupémo giliti netá matá nene gili ahuliiki zohota zaló kipili hilinigi miluma netá ali gihikitatakumú gamena gamena gili zagiiki némegetiki ataze. ");
INSERT INTO gah_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Makó keza kigika kemeníini ali amánapa iki minata vegená nene kigika kemeni gopa inogo ive. Itó makó keza nene nenikumule liki kigika kemeni vínasi ahulatamó nene alévolé kemetameni alitamó neve. ");
INSERT INTO gah_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Makó keza mikasímini amupiló ne netá ali asú niko kezáini kigika kemeni gopa okoko tolova itimó nene, mikasiuka henonimámo nana oko kelémo lamaná itive. ");
INSERT INTO gah_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ve makó keza nenikumupe monónemupe avetó itakumú kovoza hilitimó nene, okulumakutí lumu ve gihila neza lapanáne itó aménehini lapaná nenémo numupiló itekiko apazá agelova kelémoko limito gamenaló nene keza kovoza hilimó nenéminoko nezagi nene kugulizá ale otitokumú novoza hilinogo ive. ");
INSERT INTO gah_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Neza lamaná lo likimitoze, gililo. Lekelisi ató nene nia vegená lekelikutí lugáa makó hilinamiki ha niko Ómasímo gizapa oketatimómámini zámuza utó okiko ániganigave, loko limó. ");
INSERT INTO gah_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Izesú ámina gakó lo kemeake, gamena 8-ía nenéminoko oko vokago, Pitani Zonini Zemusini kelémake agokaú Ómasiloka linogo itimó. ");
INSERT INTO gah_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Itike Ómasiloka loko noigo, haitó agoka agepa ale noluhake noike gineganevámo gizopa vaevae loko minamó. ");
INSERT INTO gah_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Lá noigo, galinali ve lositá Moseko Ilaizako keza okulumakutí utó ikasike Izesugegi gakó ligili hagili ake, ");
INSERT INTO gah_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","okulumalímini gonanalivagi niasike, Izesú nene Zelusalega noheleko Ómasímo lo mola netá loló itikumú ligili hagili amó. ");
INSERT INTO gah_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Lá niago, Pitagegi kogómula ahihí okago, kovó akinakutí otiake ánigamó nene, Izesú eza lapanalagi noigo itó ve losima ezagi niasigo ánigamó. ");
INSERT INTO gah_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ánigikago, ve losima keza ahulimiiki vinigi niasigo, Pitá láa loko Izesuni lo amike limó: Monó gizapa velemaka, imaneló minuhá laga okaze. Lá okanazo, gaizopa losive makole geleketatune, makó geile, makó Mosenive, makó Ilaizanive loko limó nene gakó gele guni amike gopa limó. ");
INSERT INTO gah_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Loko noli agepagi límusímo lemeko ze hitokimikago, límusi hitoketakumú kehelele vizimó. ");
INSERT INTO gah_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Lá noigo, límusigutí Ómasímo láa loko limó: Imane gipáne alémo etó onou gipáne noize. Aí gakó gili alilo. ");
INSERT INTO gah_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Gakó láa loko utó okago, giliake ánigamó nene Izesú ezáagó noigo ánigamó. Ánigiake, ámina gamenaló ániga netakumú kegepa apiziake avetó iki vegená makó nene li kememamó. ");
INSERT INTO gah_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Akiake gó lokago, agokagutí limiake niago, vegená mukí iake Izesugegi hotu lamó. ");
INSERT INTO gah_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Hotu liake keikutí ve makolímo gakó napagutí láa loko limó: Monó gizapa velemaka, není gipa hamokó oko ánigatane loko loká nogetuve. ");
INSERT INTO gah_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Holosi makolímo aleko alévolé oake noigo, galinali gopaga loaká noive. Lá noigo, holosi nenémo alémo mómoká goha okago, sehovala veleaká noive. Itó apeleva apeleva oko noike litá oko ahulotosá amive. ");
INSERT INTO gah_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Itó izegipaka zuha nene holosima apiliki amisilitave loko lo kumumóza, amiselemitamó okave. ");
INSERT INTO gah_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Loko lokago, Izesú láa loko lo kimimó: Lekeza ató imane gili alévolé amake mulutikú amánapa iki minamó neneta lekelikumú goselé nepelekave. Lekezagi gamena gamena minoloko iteko minokugo gili alévolé itahe. Lá ikaze, gipaka imaneló alémoko ano. Loko lokago, izegipama Izesutoka noago, holosi nenémo mikasiloka ahelú okago pou loko akonoigo, alémo mómoká imó. ");
INSERT INTO gah_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Lá okago, Izesú nene holosi golesama gahá amike namisilike, ámina gipa alémo zokoake, goha amelahitoka alémo atiginá imó. ");
INSERT INTO gah_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Lá noigo, ve vená mukí keza Ómasímini zámuza napamú sigaga sagaga lamó. Lá iake Izesú oko moloko i netakumú sigaga nilago, Izesú nene izegipala zuha láa loko lo kimimó: ");
INSERT INTO gah_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Lekeza imane gakotó lakagata miliki giliki minalo: Okulumakutí lumu ve gihila neza gala vetini kigizakú nene nepele hilitune liki nilími milanigave. ");
INSERT INTO gah_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Loko limóza, nene gakolímini mogonáa gilikatave loko kigika kagata koló amimó nenazo, keza gili vevesamake, ámina gakokumú loká itanigi kehelele vizekago loká itamamó. ");
INSERT INTO gah_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Lá ikago, izegipala zuhamate gakokumú lova hizeke lelikutí éaho livilegeko agulizaki vele minative liki lamó. ");
INSERT INTO gah_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Nilago Izesú eza kigikagú nigele gakó geleake izegipa koma makó alémoko ake amatoka alémo oteneike, ");
INSERT INTO gah_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","láa loko lo kimimó: Makó keza nenikumule liki izegipa koma áimanémini nasahilí ikitatamó nene, není nasahilí inimiaká niamó gelekave. Itó makó keza nasahilí initatamó nene nimisili ve aménehini nasahilí itatamó gelekave. Lekelikutí ve makolímo lemeko nouve loko giliti ve nene Ómasímo alémo ve napa loló okiko likivilegeko minanogo ive. ");
INSERT INTO gah_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Loko lokago, Zoní láa loko lo amimó: Gizapa velemaka, leza ve makolímo geí gugulizató like holosi golesa nene vegenalitini kigikagutí kepeleko nokimisiligo ánigunimó nene lelí lémegetami ve nenazo, géneka lotunimole. ");
INSERT INTO gah_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Loko lokago, Izesú láa loko lo amimó: Lekeza géneka litamilo. Ve makó keza lekelí gala velini niamitamó nene lekelikutí ve ninigave, loko limó. ");
INSERT INTO gah_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ómasímo Izesuni goha okulumakú alémoko ititi gamena alitokago, Izesú nene Zelusalega vitove loko alévolé oko agata gilimó. ");
INSERT INTO gah_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Lá oake ve makó kimiselekago, vake Izesú atikumú ali vatí itanigi Samalia mikasiuka apá makotoka vi anitemóza, ");
INSERT INTO gah_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Samalia vegenaki Zelusale vegenaki kogoka hotopotó minamó nenazo, Izesú eza Zelusalega vitove loko likumú goselé kepelekago alími milamago, ");
INSERT INTO gah_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","izegipala zuhagutí Zemusiko Zoniko keza nene suni ánigikasike láa liki li amesimó: Guivahanitemaka, leza lokuko okulumakutí lolímo lemeko imane ve kepele gesá itive loko nogelepe. ");
INSERT INTO gah_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Liki likasigo, Izesú mino viligoake gahá kimimó. ");
INSERT INTO gah_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Gahá kemeake haitó apatoka makó vamó. ");
INSERT INTO gah_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Gapoloka nivago, ve makolímo Izesuni lo amike vitanitoka vitanitoka nene neza gémegé gémegé oko minanogo uve. ");
INSERT INTO gah_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Loko lokago, Izesú láa loko lo amimó: Mikasi koló onoikú nene gahate itiaká niave, itó namatini numúini nemóza, okulumakutí lumu ve gihila neza akato numuníne itó gotóneló za nomigo vitagá noumó nenazo, makó vitíive loko nolape. ");
INSERT INTO gah_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Loko loake, ve makó nene geza oko némegetozo. Loko lokago, eza láa loko limó: Guivahanínemaka, geza gelekako nene, neza minoko améneho helekiko vinake gale zemikinake gémegetatove. ");
INSERT INTO gah_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Loko lokago, Izesú láa loko lo amimó: Hilinita vegená gale zikimiaká hoza nene kigika heleneiti vegená kezagi ámina hoza alitamó neve. Géisi nene voko Ómasímini gizapaló minoakalímini gakó lo utó oko lo kemezo. ");
INSERT INTO gah_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Loko lokago, makolímo láa loko limó: Guivahanitemaka, geí gémegetanogo noumóza, voko není numukú nia vegenáma kemesosoka lokinake gémegetatove. ");
INSERT INTO gah_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Loko lokago, Izesú láa loko lo amimó: Ve makolímohe makolímohe není hozagutí mino viligatimó nenémo Ómasímini gapogú hoza alitimoláa nomive, loko limó. ");
INSERT INTO gah_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Lá okago, Guivahanímo ve 72-a kelémo etó oake, gona moloko losi losi iki ale goí iki vitave loko alika ezáa vinogo noi apatoka numutó namató kimisilimó. ");
INSERT INTO gah_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Lá noike aí vegenala zuha lilí inigi nia vegenakumú anoza gakó makó láa loko lo kimimó: Mikú nosánetá mukí omolokamóza, hoza aleaká vegená lagasó minokunize. Nenemú lekeza mini hoza amelahitoka likiko nene hozaló vegená makó kimiselekiko hozavagú viki minumuni alitaze. ");
INSERT INTO gah_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Lekeza vilo. Gilinahe, hela galagitana mina vegenalitini holúikú nene likigikagú geha ziki sipsip izagitana minatave loko lekelí nolikimisuluve. ");
INSERT INTO gah_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Lekeza vinigi niki, moni gúeaká gó itó akiseaká gó itó likigisaló suú alemiki lekeza gapoló niviki miniki aliki amiki amuza miliki vilo. ");
INSERT INTO gah_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Numuni makokú itinigi niikima numuni amelagini mulutikú hulu oleketino liiki itilo. ");
INSERT INTO gah_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ámina numukú hulu ve makó noitimó nene, hulumú lina gakó nene aitoka gihila zitimóza, nenémini ve noamitimó nene hulu gakolímini gihiláa nene lekelitoka goha atiginá oko anogo ive. ");
INSERT INTO gah_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ve makolititoka hoza alita vegená nenete ámina vegutí nosánetá aliki niki minatamó nene lamaná itimó nenazo, numuni makokú itiikima ámina numukú mini-liki niviki meinavatini nosánetá zahí nagamí likimitamokó nene niki minalo. Lekeza haitó numukú itemiki numuni hamokukó minalo. ");
INSERT INTO gah_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Apá makokú niviko, ámina apá amelage likilími milikoma lekeza nosánetá likimitamokó nene niki niminiki ");
INSERT INTO gah_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","kivisi vegená nene kilími zokiki láa liki li kimilo: Ómasímini gizapaló minoakalímini zámuza nene lokovogisaloka okave. ");
INSERT INTO gah_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Itó apá makokú niviko, likilími lamaná amikoma, lekeza viki gapoló otiniki láa liki li kimilo: ");
INSERT INTO gah_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Lekelí apakutí mumusopa ligisaló gímizeneimó nene lekelikumú vahé moloko atilí noune. Lá nounimóza, gakó imane gili minalo: Ómasímo gizapa oleketatimó nenémini zámuza nene lokovogisaloka omo alitokago ánigi ahulikave, liki li kimilo. ");
INSERT INTO gah_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Neza gakó lo likimitoze, gililo. Gamena napaló nene Soto apakú mina vegenalite golesa mogonáinimú goní koma itamóza, likilími lamaná amita vegenalite goní sipisi inigave. ");
INSERT INTO gah_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Agae, Kolazina amelagita, itó Petesaita amelagita, lekelitoka golivagi netá utó inogo ive. Alévolé suni lekelitoka loló umó nene golesa netá aliaká a vegená miniaká a apá Tulo apatoka itó Sitona apakú utó ilina, keza gozapá miluma giliki kigika ali viligamó nenémini mogonáa li utó iki ginegane litaha ali akiliki ló lana nene kugupeló hiliki minaline. ");
INSERT INTO gah_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Gamena napaló nene Tulo apakuki Sitona apakuki mina vegenalite goní itamóza, lekeza goní napa genavagi inigave. ");
INSERT INTO gah_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Itó lekeza Kapanao amelagita, lugulizá okulumakú ititive liki ali otiaká niahe. Nenéminoko nomive. Zunigú lekehelú inogo ive. ");
INSERT INTO gah_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Loko loake, goha miní ameko izegipala zuha láa loko nokimisilike limó: Ve makó keza lekegepagutí gulupe liki gilitamó nene není negepagutí gakó gilinogo ive. Itó ve makó keza kemegesa likimitamó nene, kemegesa nememó gilitimó neve, itó kemegesa nimitamó nenete nimisili ve kemegesa amemó gilitimó neve. ");
INSERT INTO gah_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Láa loko kimiselekago, viki miniake, goha ake mulúikú agila guluma igo kogoliza viziki láa liki lamó: Guivahanitemaka, geí gakotó nene holosi golesa nenete kezagi gili limiki golisi iaká niave. ");
INSERT INTO gah_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Liki likago, Izesú láa loko lo kimike limó: Satá eza gó vegitana oko okulumakutí lemekago ánigokuve. ");
INSERT INTO gah_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Lekeza gililo. Neza zámuza lekemekugo lekeza gosiható itó akohú oaká gosihakitana netató lisatamó itó lelí lova gala ve Satani zámuzalaló nilisikoma nenémo lekepeleminogo ive. ");
INSERT INTO gah_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Lá onoimóza, holosite lekelí gakó gili aliaká niakumukó giliko itemiko, lekeza Ómasímini mututoni minakumule loko lukugulizá nene okulumakú gizonoimó nenemú lokogoliza viziki minalo. ");
INSERT INTO gah_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Loko loake áminasitó Ómasímini Sikalahulímo agika alémo vávani noigo, mulunagú ló guluma noigo láa loko limó: Aménega geza okulumalímini mikasímini Guivahani géisigó nene noane. Sukulu lunike gele vevesokune liki liaká nia vegená keza giliki gili guni ikatave loko monó imane ale halá geko molokanike sukulu lamake izegipa namunigitana iki mina vegenalitini kigikagú molokimiaká noanikumú gegepoka noluve. Aménegamaka, geza nene nenéminoko utó oloko vitive loko gelekako nene etoaká noive. ");
INSERT INTO gah_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Loko loake, miní ameko láa loko limó: Améneho netá mukí nene nigizakú molo asú okave. Itó ve makolite Ómasímini gipala noutímini mogona gelemave. Améneho ezagó geleneive. Itó ve makolite aménehini mogona gili vevesamave. Neza gipaka noumó itó nezáne lo utó oko lo kemekugo ánigi hehe litave loko gilito vegená niamó lezategó aménehini mogona gelenoune. ");
INSERT INTO gah_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Loko loake, izegipala zuhaloka mino viligoake keikó Izesú láa loko lo kimimó: Ómasímo nónohá zelikimikago lekeza lokogómulatunú netá imane ánigi vevesikave. ");
INSERT INTO gah_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Neza gakó lo likimitoze, gililo. Gozapá Ómasímini agepagutí gakó liaká a vegi kugulizaki ve napagi nenete oko moloko nou netá lekeza ánigiaká niamó nene ánigatune liki gelemóza, ánigamamóma neve. Itó lekeza negepagutí giliaká nia gakó gilitune liki amóza, gelemamóma neve. ");
INSERT INTO gah_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Loko lokago, monó mogona apí-okimiaká ve makolímo oteake Izesuni amekú moloko láa loko loká otake limó: Monó gizapa velemaka, neza nana okinake alévolé nemetameni alitohe. ");
INSERT INTO gah_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Loko li gakotó nene Izesú lo amike limó: Mosé nanave loko lo hukoleketave. Geza nene gakó nanave loko gatoko gelene. ");
INSERT INTO gah_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Loko lokago, eza láa loko limó: Geza gigika gemeni zámuzaka itó geleakaka mukí nene Guivahani geí Ómasiloka lehizetozo. Itó gezakamú geleaká noanimómáminoko gigivekaginimú geleko gigika kemezo loko luhuva gizonoimóma neve. ");
INSERT INTO gah_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Loko lokago, Izesú láa loko lo amimó: Lo nogumu gakotó lo vevesoko lokane. Lani gakotó amegesa molokogó loló itanimó nene alévolé oko minanogo ane. ");
INSERT INTO gah_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Loko lokago, ámina ve nenémo ezáa mogonala hize lé inogo Izesuni loká otake láa loko limó: Nigivénege keza éage niave. ");
INSERT INTO gah_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Loko lokago, Izesú láa loko lo amike limó: Ve makó eza Zelusalega ahuloake Zeliko numutoka nolimigo laskoli vete gapoló apiliake lavolavo gola netá matala mukí gumina iki aliki vikago, hilinogo gapoló ako minamó. ");
INSERT INTO gah_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Lá oko akonoigo, Ómasi guguni gizoaká ve makó nene ámina gapoló novike ánigamó nene hilinogo akonoigo zová zeko avilegeko vimó. ");
INSERT INTO gah_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Vokago, ámináminoko monó zagusaveú hozaló ve Livaini agapilamokutí makó nenémo áminaloka oake ánigamó nene lá oko akonoigo, ánigoake zová zeko avilegeko vimó. ");
INSERT INTO gah_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Vokago, Samalia vegi Zuta vegi apiziki minamamóma nemóza, Samalia ve makolímo ámina gapoló novike apili ahula vema akonoitó oko ánigoake, muluna gitihiná okago, ");
INSERT INTO gah_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","noitó vike apelego golani imómaló nene hilinagi vain nagamiki holomiake asapú omiake, alémo oteake toki izavámini amegesaló ahulomiake vike veno vegenalitini numukú itesike nasahilí otamó. ");
INSERT INTO gah_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Akikasike gó lokago ámina ve vinogo noike veno vegenalitini numuni gizapa ve nene kina lositá namike limó: Geza imane ve gizapa lamaná otozo. Lá noako moni gumumó nene asú okikoma neza goha inake gimitove, loko limó. ");
INSERT INTO gah_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Nenemú geza nanave loko nogelene. Ve losive makole akutí nene laskoli vete apilikago gapoló ako mina vemámini agivelaho hí ve minamó neve. ");
INSERT INTO gah_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Loko lokago, monó mogona apí-okimiaká vemámo láa loko limó: Miluma gelemiake alémo lamaná i veve. Loko lokago, Izesú nene géisi voko áminámini ozo, loko lotamó. ");
INSERT INTO gah_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Lomiake, gapoló nivake apá makokú anitemó. Nene apakú vená makó minamó agulizá Malatá eza Izesuni alémo numunagú molokago, ");
INSERT INTO gah_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","mohó agunala agulizá Maliá eza nene ake Guivahanímini agisauka minake aí gakó geleko minamó. ");
INSERT INTO gah_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Lá noigo, Malatá eza nosánetá ale vavá i hozamú muluna itimó. Lá oake, Malatá vike Izesuni láa loko lo amimó: Guivahanínemaka, mohó nugunáne Maliá nene ahulonimikago nezánegó nosánetá ale vavá noumó ánigamape. Lo amekako, oko hozaló nelémo vatí itive. ");
INSERT INTO gah_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Loko lokago, Guivahanímo lo amike láa loko limó: Malata, Malata, geza gagata gululusi nogelenike muluka itekave. ");
INSERT INTO gah_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Geza netá hámakokumú gelezo. Maliá nene netá lamanaláa ale gizaká ike nenitokatí zámuza alekave. Nenémo aitoka gihila zekiko makolímo agizakutí ipá aminogo ive, loko limó. ");
INSERT INTO gah_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Gamena makó zupa Izesú nene apá makotoka Ómasiloka loko lo asú okago, izegipala zuhagutí makolímo láa loko lo amimó: Guivahanitemaka, Zoní nene izegipala zuha Ómasiloka litave loko lainim-oketoaká i netá aleko lainim-oletozo. ");
INSERT INTO gah_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Loko lokago, Izesú láa loko lo kimimó: Ómasiloka niliki nene láa liki lilo: Ametega, geí gugulizá etó oko minatize. Numutó namató geí gizapaló minoakalímini zámuza utó o asú ino. ");
INSERT INTO gah_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Geza gamena gamena nosate lemezo. ");
INSERT INTO gah_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Leza ligivetegini lihima nekisáini ale ahulokimiaká nounimó nenémini oko lihimate ale ahuloletozo. Geza gimilegú moloaká netakú lelémo molamo. ");
INSERT INTO gah_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Loko loake, láa loko lo kimimó: Lekelikutí ve makolímo nene holugú akovevé zogovámini numutoka voko sele loko zogone geza peleti losive makole nemezo. ");
INSERT INTO gah_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Zogone makó nene gapoló ake ake není numukú itínasa okago, nosánetá koma amitomó nomigo loká nouve. ");
INSERT INTO gah_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Loko lokiko, zogova nenémo numukutí nene leza gahe gekunike vená izegipánegi akonouhakú goseleka lamo. Neza otekinake netá makó gememinogo uve. ");
INSERT INTO gah_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Loko litimó nene, neza láa loko lo nolukumuve. Eza není zogone minokagove loko oteoko netá makó amemitimó nene, maga ve nenémo sele lova lova okiko, eza oteoko vitagá noi netáma aminogo ive. ");
INSERT INTO gah_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","10","Nenemú láa loko lo nolukumuve. Ómasiloka voká liaká niamó nenete netá mota aliaká niave. Vitagá iaká niamó nenete netá gihila ali utó iaká niave. Itó gaheló hoko-hoko likago gahe koló okimiaká noive. Lá onoinazo, lekeza Ómasiloka voká liikima ámina netá alinigave. Vitagá iikima netá gihila ali utó inigave. Gaheló hoko-hoko nilikoma gahe koló oleketanogo ive. ");
INSERT INTO gah_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Lekelikutí ve makolímini gipalámo lagahamú voká lokiko nene amelaho gosihá amitihe. ");
INSERT INTO gah_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Itó okoloho mulamú voká lokiko nene akohú gosihakahá amitihe. Lá aminogo ive. ");
INSERT INTO gah_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Nenemú lekeza vegená golesa neneta izegipatini gizapa lamaná ikitake netá lamaná ali kegepa iaká nianazo, okulumakú ametipo nene voká lita vegená nene aleko iteko Sikalahula lehizeleketanogo ive, loko limó. ");
INSERT INTO gah_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Gamena makó zupa nene ve makolímini agepa ale lakolí okago mina holisi nene Izesú apeleko amiselekago, vokago, agepa apizi vema nene agepa á oake gakó akó limó. Lá okago, vegená keza sigaga lamóza, ");
INSERT INTO gah_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","lugáate láa liki lamó: Holositini agulizaki ve Pelezepuló loko noi vémo alémo vatí noigo holosi kepeleko kimiseleaká noive. ");
INSERT INTO gah_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Liki likago, lugáate amekú milake loká itake okulumakutí alévolé suni makó ale utó okako geí mogonaka ánigatunize. ");
INSERT INTO gah_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Liki likago, Izesú kigikámini gakó hanuva geleake láa loko lo kimimó: Mikasi makokú vegená hizi hoú liiki lova gopa hizitamó nene keí mikasi nene gámekó minatimóma neve, itó numuni makokú vegená keza hizi hoú liiki eza akohú apiliko eza akohú apiliko itamó nene ámina numuni ahuliiki hutilí iki vinigave. ");
INSERT INTO gah_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Lekeza nenikumú nene Pelezepuloni zámuzatunú holosi kepeleko kimiseleaká noive liki liaká niamóza, Satá nene ezáa izegipala zuhagi hizi hoú latamó nene aí gizapaló minatamoláa nene nana iki alévolé iki minatave. ");
INSERT INTO gah_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Nenikumú nene Pelezepuloni zámuzatunú holosi golesa kepeleko kimiseleaká noive liki liaká niave. Láa likima lekelitini izegipatini zuhate nene ámina iki Satani zámuzatunú holosi golesa kipiliki kimisiliaká niave liki litahe. Óe, láa liki lamitamó nenazo, kéisi soza gakotinímini mogonáa hanuva ali utó itamó neve. ");
INSERT INTO gah_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Lá onoimóza, neza Ómasímini zámuzatunú holosi kepeleko kimiseleaká nounazo, Ómasímini gasovaló minoakalímini zámuza nenémo lokovogisaloka mota omo ávatiha okamó nenémini mogona mota utó okave. ");
INSERT INTO gah_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Satá eza gasovagi ve amuza ve minooko gimisi magé aleoko numuna gizapa itimó nene, netá matala mukí nene avasavagi minanogo ive. ");
INSERT INTO gah_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Lá itimóza, neza alévolé ve noutímina nene okoko ámina ve lova ale ameko aí aviligitomó nene, gimisi magé gele alévolé i netáma ipá oko vegená makó gona moloko kimitove. ");
INSERT INTO gah_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Itó makó keza nenikutí vegená minamitamó nene, není gala vegená ninigave. Makó keza nilími vatí iki vegená kilími nenitoka amitamó nenete kilími hutilí iaká niamó gelekave. ");
INSERT INTO gah_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Holosi makolímo ve makolímini agikagutí iteoko nene avasú vizeko minati numunimú vitagá inogo osagava apató voko mohona itive. Vitagá oloko novoko neza numúne ahulokuke umóma nenazo lokoko mohona oko vitagá itimóza, nomiko neza goha áminagú atiginá oko vinake minatove loko agata geleoko ");
INSERT INTO gah_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","atiginá oko voko ánigatimó nene ámina numuni agika nene lolopa gitiki ali guni ikiko itó gizapa ve makó noamiko ánigatimó nene, ");
INSERT INTO gah_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","eza goha ahulooko voko holosi agivelagini 7-ía kugupelotí sisipa anuva ovimoláa kelémoko oko nene áminagú miniki aliki inigave. Lá ikiko ámina ve goí oko golesa oko minamóza, íi alika nene golesa o lamaná oko golesa inogo ive. Ve golesa áimane lekelitoka utó itikumú noluze, ehe tináneve. ");
INSERT INTO gah_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Loko noligo, ve venalitini holúikutí vená makó minamó nenémo Izesuni sele like láa loko lo amike limó: Vená makó nenémo geí getoake aminí gemeneimó nene Ómasímo lusa getonoimóma neve. ");
INSERT INTO gah_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Loko lokago, Izesú láa loko limó: Láa loko lanimóza, Ómasímini gakó giliki Ómasímo li gakotó ámegetiaká nia vegená nene Ómasímo nónohá zeketonoimóma neve. ");
INSERT INTO gah_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Loko loake, vegená sii sii liki alegesá niago, Izesú miní ameko láa loko lo kimimó: Oko moloko oaká nou netá ánigiaká nia vegená nene vegená golesa minikave. Keza alévolé suni makó ánigatune liki liaká niamóza, haitó suni makó ale utó ugo ánigaminigave. Zonatoka emane utó i sunigitana makó utó iko nenegó ániganigave. ");
INSERT INTO gah_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Zoná nene lagaha sipisimámini agikagú lemeko gamena losive makole minake heleaká gapogutí goha oteake Ninive vetini kovogisaló ámina sunimú lo utó o kimimómámini oko okulumakutí lumu ve gihila neza imaneló vegenalitini kovogisaló není anosa ale utó oketanogo uve. ");
INSERT INTO gah_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ómasímo gona mololeketati gamena nene Sepá mikasiuka agulizaki vená minamó nenémo oteoko imane gamenaló nia vegenalitini mogonáini lotuva legekiko lihima napa alitamó oko nene neve. Ámina vená nenémo nene agulizaki ve napa Salomóma mukí netá mogona gele vevesoko gilimómámini gihiláa gilinogo mikasi hotokatí gapo hána hána amó. Itó nénisi ató imane Salomoni koma avilegeko noumóza lekeza není gakó gilisá amave. ");
INSERT INTO gah_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ómasímo gona mololeketati gamena nene Ninive apá amelage otiki oko moloko oaká nou netá ánigiaká nia vegenalitini mogonáini lotuva liginogo ive. Lotuva legekiko lihima alitatokó oko neve. Nene hanuvamú nomive. Zoná nene monó lo nokimigo Ninive apá amelage kigika ali viligamó neve. Itó nénisi ató imane Zonakitana oko minonamuve. Zonani avilegenoumóza, lekeza gakóne gili ahuliake likigika ali viligamamó neve. ");
INSERT INTO gah_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Hí vémo ló liví legeoko holoma sepekú molatimó neve, itó somotunú gahumá itimó neve. Lá oko nomive. Liví nene legeake numukú itita vegená hize hanatoketative loko holomaló molosá neve. ");
INSERT INTO gah_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Itó gogómula nene gugupémini ló liví neve. Gogómula nenémo mumuzó oakalímini gapogú gelémo molamitimó nene, Ómasímini lapaná nenémo gigikagú hize hanato asú itimóza, gogómula nenémo gelémo golesa itimó nene, gugupeló itó gigikagú límugusi ze minanogo ive. ");
INSERT INTO gah_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Nenemú gigikagú Ómasímini liví lonoimó nenémo lihokiko límugusigú minokatanize, gizapa lamaná ozo. ");
INSERT INTO gah_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Gigika makotoka límugusi zemoko hanato asú onoiko, ló livilímo hize hanatogetatimó nenéminoko gigika hanatokogó minanogo ive, loko limó. ");
INSERT INTO gah_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Izesú láa loko lo asú noigo, Palisaio monó ve makolímo nosánetakumú alesa molo amimó. Lá okago, Izesú nene numunagú iteake nosánetá makó niki minasimó. ");
INSERT INTO gah_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ámina Palisaio monó ve nenémo Izesuni ánigamó nene, Zuta vetini suni aleko agizani nagamí zemike nosánetá hanuva nonago ánigoake, etami suni nalive loko geleake, ininá oake agata gululusi gilimó. ");
INSERT INTO gah_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Lá noigo Guivahanímo láa loko lo amimó: Gelezo. Palisaio monó ve lekeza lape somogitana iki niave. Lekeza nagamí goni itó lape hetolaloka nagamí ziaká niamóza, likigikagú guminaló suni itó haitopaitó netá golesa nenémo vaí onoive. ");
INSERT INTO gah_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Lekeza ve negi ve lamaná niave. Ómasímo netá hetoláa itó agikáa hamó lelegitó loló okamóma neve. Nene gelemahe. ");
INSERT INTO gah_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Likigikagutí vegená nasahilí ikitatamó nene, likigika viheletokogó minanogo ive. ");
INSERT INTO gah_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Lekeza Palisaio monó ve ehe tináneve. Lekelí mikutí mapánuha ekipá anuva lamanaki netá itó netá makó haitopaitolímini 10 10 nekutí nene hamopamó aliake Ómasi amiaká niamóza, lekeza nene hehe loko hamó lelegitó vegená gona moloakalímini itó likigika Ómasiloka moloakalímini nene ahulikave. Lekelí netá matá 10 10 nekutí Ómasi amiakalímini nene ahuloakaláa nomimóza, imane netá napa nenegi hanuva loló oakalímini neve. ");
INSERT INTO gah_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Lekeza Palisaio monó ve ehe tináneve. Lekeza monó numukú numukú nene vegenalitini kovogisaló minoaká siató minatune liki giliaká niave, itó lekeza maketiloka mukí vegená nenete geké lilitatave liki giliaká niave. ");
INSERT INTO gah_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Lekeza ehe. Lekeza gonosi milimili halá geneimó nenéminiki niave. Áminaló vegenalite mihina niake likigikagú lili okave liki gilisá amave. ");
INSERT INTO gah_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Loko Izesú lokago, monó mogona apí-okimiaká ve napa makolímo lo amike monó gizapa velemaka, geza láa loko nolanike lelikumuki gahá nolape. ");
INSERT INTO gah_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Loko lokago, Izesú láa loko limó: Oo, lekeza monó mogona apí-ikimiaká ve, lekeza ehe tináneve. Lekezatini li mila gakó nenémo genavagi loló okago vetini kigínagú gihikimiaká niago, keza silipa iki gihiaká niamóza, ámina genavagi netá nene lekezatini likigizani hisúinitunú kilími vatí itigí iki ma alisá amave. ");
INSERT INTO gah_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Lekeza ehe. Lekeza avotike Ómasímini agepagutí gakó liaká ve kipili hilina vetini gonosi milimili numuni lamaná lilí iake gonanalisi ikimiaká niave. ");
INSERT INTO gah_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Lá niago, lekeza avotike iki miliki iaká amoláa hizi lé iaká niamómámini mogona utó okave. Avotike keza Ómasímini agepagutí gakó liaká ve kipili hilikago, lekeza keikitana niake gonosi milimili numúini lamaná lilí ikimiaká niave. ");
INSERT INTO gah_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Nenemú Ómasi eza gele vevesoaká noi ve nenémo láa loko lonoimóma neve: Negepagutí gakó liaká vegi aposologi kimiselekugo, viki niiko, lugáa gopoguni milikimiiki lugáa kipili hilinigave. ");
INSERT INTO gah_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Loko lonoimó nenazo, mikasi gena oake mino-loko iteko novigo, Ómasímini agepagutí gakó liaká ve nikepelego golani lekemó nenémini lihima nene imane gamenaló nia vegenalitini kumupiló ite asú inogo ive. ");
INSERT INTO gah_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Neza lamaná lo likimitoze, gililo. Atani gipala Epoloni apele nohiligo golani leki gamenalotí Ómasímini agepagutí gakó liaká a vegená lugáa kipili hililiki nivago golani lekikago, Zakaliá eza Ómasi guguni gizi amiaká itagi etó onoi numunigi holutó noigo napelego golani lekimó, keí golanímini lihimavala nene imane gamenaló nia vegenalitini kumupiló itinogo ive. ");
INSERT INTO gah_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Lekeza monó mogona apí-ikimiaká ve, ehe. Lekeza gakó gele vevesoaká gahémini kiila aliki vikave. Lekezatini áminagú itemake, vegená makó itinigi niago gapo hizi lí ikimiaká niave. ");
INSERT INTO gah_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Loko loake, numukutíma nolimigo, monó mogona apí-ikimiaká vegi Palisaio monó vegi keza gakotunú Izesuni lova ali aminigi gakó loká loká itamó. ");
INSERT INTO gah_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Izesú gakó lo gopa okiko goní otatune liki aí agepaló gizapa iki minamó. ");
INSERT INTO gah_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Lá niago, vegená makó iki kugupeló kugupeló iki sii sii liki alegesá ikago, Izesú nene izegipala zuhaloka láa loko lo kemeneike limó: Palisaio monó ve nenete sozaló vetini suni aliki iki miliki iaká amó nene ekesá netá neve. Lekeza nenemú ehe, gizapa ilo. ");
INSERT INTO gah_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Hitonoiti netá nene utó o asú ititokó neve. Itó asuguná iki lilí ina netá nene utó okiko vegená mukilite gilinigave. ");
INSERT INTO gah_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Lá niiki holugú límugusigú gakó legesó iki linamó nene hanatoka likiko mukí vegenalite gili asú inigave, itó lekeza numuni agikagú gakó musika linamó nene numuni hetotí gakó napagutí li utó niko gilinigave. ");
INSERT INTO gah_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Nigivénegita, lo likimitoze, gililo. Vegená makolite lukugupegó apili hilinigave. Alika netá makó lilí ilikitatamó nomitimó nenazo, lá ita vegenakumú lekelegesá legemino. ");
INSERT INTO gah_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Lá onoimóza, lekehelele viziti ve makó lekelepizitove. Ómasi eza lukugupe apele helekoko ló apakú lekehelú o ahuloaká zámuzagi ve noive. Neza lamaná lo nolukumuze, gililo, aikumú lekelegesá ligino. ");
INSERT INTO gah_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Somohá nene ha netá nianazo, golohá moni lositatunú nama somohá ligizani lugaloka asú igo meina hizemosaláa neve. Lá onoimóza, Ómasi nene nama somohá makokumú ma agatí molosá amive. ");
INSERT INTO gah_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Lekelí gototini zopovatini gatoakaláa nene Ómasímo gele asú oko geleneive. Itó lekeza nama somohá niamave. Lekelisi nene vegená nianazo, itó Ómasímo gizapa olikimiaká noinazo, nenemú netá makokumú ma lekehelele vizemino. ");
INSERT INTO gah_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Neza lo likimitoze, gililo. Vegenalitini kovogisaló ve makó keza není nugulizá li utó iki nilími napa itamó nene, okulumakutí lumu ve gihila neza Ómasímini agelogini kovogisaló ámina oko kelémo napa oko linogo uve. ");
INSERT INTO gah_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ve makó keza vetini kovogisaló nenikumú zivi hitivi itamó nene, neza ámináminoko Ómasímini agelogini kovogisaló keikumú zevo hitovo itomóma neve. ");
INSERT INTO gah_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Itó makó keza okulumakutí lumu ve gihila nenikumú alivi letivi itamó nene, Ómasímo ámina lihimavala ahuloakaláa nene nemóza, Ómasímini Sikalahukumú alevo letovo oakaláa nene, Ómasímo nenémini lihimavala ahuloakaláa nomive. ");
INSERT INTO gah_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Itó monó numúikupe monó gizapa vetini itó kugulizaki vetini kovogisalope goní nilikitikoma, konotó aleko nana gakó litupe itó nanave loko litupe liki lakagata giliko gena amino. ");
INSERT INTO gah_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ámina gamenalóisí lekeza lita gakó nene Sikalahulímo lo lekeme lekeme noiko li kimitamó nenazo, lekeza mulutini itemino. ");
INSERT INTO gah_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Loko lokago, alegesá iki mina vegenakutí ve makolímo Izesuni lo amike láa loko limó: Monó gizapa velemaka, geza uvónehini lo amekako, ameteho nene helisa henoni mololetamó nene gona moloko lugáa nimitive. ");
INSERT INTO gah_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Loko lokago, Izesú láa loko lo amimó: Vémage, helisa henonimú gona mololeketatane loko itó gonikumú lo hukoleketatane loko éaho nelémo etó okago nolane. ");
INSERT INTO gah_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Loko loake, vegená láa loko lo kimimó: Lugupémini henoni vaí oko minatimó nenémo ligikámini henoni ale utó amitimó nenazo, ánigo lukumu heleaká netakumú gizapa ilo. ");
INSERT INTO gah_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Loko loake, anoza gakó makó láa loko lo kimimó: Moni henoni vaí oko mina ve makolímini mikasi nenémo nosánetá vaí oko ale utó imó. ");
INSERT INTO gah_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ale utó okago, mulunagú nene ale moloaká numukú nene nosánetá vaí okanazo, nosánetá lugáa nene nana itove. ");
INSERT INTO gah_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Loko geleake, láa loko gilimó: Nosánetá ale moloaká numunima lukokinake napa napa gitove. Lá okinake nosánetánegi netá matánegi nene ámina numukú ale molatove. ");
INSERT INTO gah_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ale molokinake, nezánemú láa loko litove: Nezáne netá matá vaí oko minokamó nenazo, asú amiko melekeni mukí oko vinogo ive. Nenemú navasú vizinake nosánetá noko zahí nagamí noko nogoliza vizeko minanogo uve. ");
INSERT INTO gah_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Loko gelekago, Ómasímo láa loko lo amimó: Negi ve neneka, itína holugú geí sikalahuka alekugo hilinogo ane. Lá okiko nosánetá henokanoka ale molanimó nene hutilí inogo ive. ");
INSERT INTO gah_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Loko lo amitimó nenazo, netá matá vaí oko minati ve makó eza Ómasímini agómulaló gohogó ve minatimó nene, ámina suni aitoka utó inogo ive. ");
INSERT INTO gah_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Loko loake, izegipala zuha láa loko lo kimimó: Lá onoigo láa loko lo nolukumuve. Lekeza miniki aliki itakumú nene nosánetá hikutí noko minatupe itó ginegane nene hikutí ale akalatupe liki mulutini itemino. ");
INSERT INTO gah_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Nosánetá nene netá gihila nomive. Lekelisi miniki aliki itamó nenémo netá gihila neve. Itó lukugupeló ginegane nenémo netá gihila nomive. Lukugupe nenémo netá gihila neve. ");
INSERT INTO gah_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Namamú lakagata giliki gili vevesalo. Keza netá matá zuhá isá amave, itó minumuni o molokago nosánetá nene numúikú ali nupa iki nisá amave, itó nosánetá ali milata numuni gisá amamóza, Ómasímogó nosánetá gopa ale utó o kemeaká noive. Itó lekeza nama minamave. Vegená nianazo, itó nama mukí nene limiki niago lekeza itiki niamó nenazo, Ómasímo netá matá hanuva ale utó mololeketatimó nenae. ");
INSERT INTO gah_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Lekelikutí makó éaho muluna noitiko minoko aleko ititó nene ezáa agata geleko kilisimasi makó miní ameko molomo iteko minative. Ma nomive. ");
INSERT INTO gah_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Itó nene netá koma nemóza, lekeza ámina netá alisá amamó nenazo, netá makokumú nanamú mulutini iteaká noive. ");
INSERT INTO gah_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Lekeza palauá guvava oko minoaká noimó nenémini mogona gili vevesamahe. Palauá kéisi nene hoza makó alisá amave, itó ginegane lamanatamanakó ali luhatakumú gó isá amave. Lá onoimóza, neza lo likimitoze, gililo. Gozapá agulizaki ve napa Salomó nene gonanalivagi netá ale luhoaká imóza, palauá nenete Salomoni agupeló netá aviligikave. ");
INSERT INTO gah_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Palauá nene itínasa utó oake gó lokago gululupasokago hukiki ló giziaká niave. Itó Ómasímo lokago ámina palauá nenémo gonanalivagi netá ale koloaká noinazo, nenemú lekeza komasí gili alévolé inamó neneta ginegane nene Ómasímo hanuva ale utó oleketanogo ive. ");
INSERT INTO gah_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Lekeza lakagata gululusi nigiliki leza nana netá natunimó neve, itó nana zahí nagamí natunimó neve liki mulutini itemilo. ");
INSERT INTO gah_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Keza numutó namató monóini nomi vegená nenete ámina netakumú kagata gululusi giliki vitagá iaká niave. Lá niamóza, ametipo nene ámina netá lekelitoka minamitimó nene minamitave loko geleneive. ");
INSERT INTO gah_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Lekeza ámina netakumukopa Ómasímo gizapa vetini loló iti gapogú likigika lakagata goí iki miliko vo minino. Lá ikiko nene, lukugupémini netaki nene hagitana lehizeleketanogo ive. ");
INSERT INTO gah_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Lekeza vegená luguhá nupa inamó neneta lekehelele vizemino. Ametipo gizapa omiaká noi netá matá mukí lehizeleketanogo agoliza vizeko nogilive. ");
INSERT INTO gah_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Nenemú nene henokanotini salimiiki áminalotí meinava moni aliiki gohogó vegená kimilo. Lá iiki moni gúeaká gó haitolímini hulupa lamitímini alilo. Lekeza lá iki okulumakuka asú amiti henoni ali nupa itamó nene, neneló guminaló vete mihina aminigave, itó gúnakonímo hutamitimó neve. ");
INSERT INTO gah_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Henokanotini lamaná neti apatoka nene, likigika neinogo ive. ");
INSERT INTO gah_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Lekeza lavolavo gotini ali likiiki gohatitó leti ziiki lamu ló ligi miliiki ali nené iki minalo. ");
INSERT INTO gah_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ve makó keza gizapa venini nene vená alimi ame gamenaló amisi gitatotí numutoka atiginá oko atikumú ageva iki minake, eza oko gaheló okohá zekiko litá oko gahe segetatune liki gizapa iki minamó. Lekeza ámináminiki gizapa iki minalo. ");
INSERT INTO gah_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Gizapa venini nenémo oko gelekelé izegipala nene akamiki gizapa iki minikiko ánigatimó nene kogoliza viziki minanigave. Neza lamaná lo likimitoze, gililo. Gizapa venini nenémo okoko hoza aleaká lavolavo likeoko nosánetá iki miniki nalo loko lo kemeoko, ezáa oko nosánetá vatá oketoko gona moloko kiminogo ive. ");
INSERT INTO gah_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Eza nene holugú akovevé ahe itó gó lomolomohe oko ánigatimó nene, gelekelé izegipala gizapa iki niko ánigatimó nené, keza kogoliza viziki minanigave. ");
INSERT INTO gah_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Itó lekeza imanemú gililo. Numuni amelaho nene guminaló ve ati gamenamú gililina, guminaló vemule loko gizapa onoitimó nenazo, guminaló ve nene oko numuni zeko epetamitimó neve. ");
INSERT INTO gah_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ámináminoko okulumakutí lumu ve gihila neza negeva iki minamita zupa anogo unazo, lekezagi ali nené iki minalo. ");
INSERT INTO gah_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Loko lokago, Pitá láa loko limó: Guivahanitemaka, anoza gakó lo nolemenimó nene lelikumukó nolape itó ve makokumuki nolane. ");
INSERT INTO gah_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Loko lokago, Guivahanímo láa loko limó: Hozaló ve makó nene gele vevesonoko gele minatimó itó hozaváa nene amegesa moloko minati ve nene gizapa vevámo aí numukú netá matató gizapa oko minoko hozaló ve makó lugáa gizapa oketative loko lomikiko nosánetá nata gamenaló nene gona moloko kimiti vémini mogonamú lo likimitove. ");
INSERT INTO gah_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Gizapa veva nene okoko ámina hozaló ve nene goí oko lotamómámini oko hoza naliko ánigatimó nene, ámina hozaló vemú giligo nene lamaná itimó neve. ");
INSERT INTO gah_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Lá onoinazo, neza lamaná lo nolukumuze, gililo. Gizapa vevámo lá oko gizapa lamaná i vema nene mukí netató gizapa ve loló otanogo ive. ");
INSERT INTO gah_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Lá itimóza, ámina hozaló ve nenémo není gizapa vema nene gamena hána minokaze, litá oko aminogo ive loko mulunagú gelekoko, hozaló ve vená makó lugáa kepeleká itó nosánetá nene hanuva noko minoká itó zahí nagamí noko itó ekesá nagamí noko negi nagi hizeko minoká itimó nene, ");
INSERT INTO gah_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ámina hozaló vémini gizapa veva nene okoko ámina hozaló ve nene gizapa vevamú ageva oko minamiti gamena eza gatizá minati gamena okoko ámina hozaló ve nene agupe apelevo hukovo ooko amisele ahulokiko, hozamú mulúikú gili alévolé inamita vegená niakú voko minanogo ive. ");
INSERT INTO gah_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Hozaló ve makolímo nene gizapa vevámini agepagutí gakó gelekoko netá ale vavá oko minamoko gizapa vemámo li gakotó amegesa molamitimó nene, gizapa veva nenémo vauva aleko napiliko goní hoza napa alitimóza, ");
INSERT INTO gah_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","hozaló ve makolímo gizapa vevámini agepagutí gakó gelemoko nogosani nati suni alitimó nene, gizapa veva nenémo hana okogó apilinogo ive. Ómasilokatí helisa henoni vaí iki alinita vegená nene Ómasímo ali atiginiki nimitave loko goha lokiko aminigave. Itó Ómasímo ve makó nene netá vaí oko kemeneitimó nene, ali atiginiki nimitave loko lokiko goha aminigave. Itó amemitamó nene, nana oketative. ");
INSERT INTO gah_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Neza mikasiuka ló gizoleketatove loko lemekumóma neve. Itó mukí vegenalitini golesa netáini ló gizatove loko itína lalina, mulúnegú lamaná gululine. ");
INSERT INTO gah_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Miluma netá gihinitanigave. Velesá gihiniti asú inamiko mulúne gitihiná iko minoloko novugo alika gihinitanigave. ");
INSERT INTO gah_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Nenikumú nene imane mikasiuka nonagá ale utó itane loko lemekane liki nigelehe. Óe, lo likimitoze, gililo. Není monokumú hize hoú loaká netá ale utó inogo lumumóma neve. ");
INSERT INTO gah_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Itína gamenalotí veletó nene numuni makokú vegená ligizani lugaloka asú igo nitamó nene, není monokumú hizi hoú liiki, ve losive makole nenete ve losimú nene gala ve lilí ikitanigave, itó ve losi nenetosa ve losive makolemú gala ve lilí ikitanigasive. ");
INSERT INTO gah_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Lá iiki, lá iki hizi hoú lanigave. Amelahiko gipalago mini luga luga iki hoú lanigasive, itó izolahiko moholago mini luga luga iki hoú lanigasive, itó anohúvolahiko avolahiko mini luga luga iki hoú lanigasive. ");
INSERT INTO gah_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Loko Izesú loake, alegesá a vegená láa loko lo kimimó; Lekeza límusi makó ezegalokatí noitiko ánigiake, golini mota zinogo ive liki liaká niave. Láa liki linató nene gihila zeaká noive. ");
INSERT INTO gah_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Itó okulumá nene anupakó utó noiko, ánigiake, hogaí napa lanogo ive liki liaká niató nene gihila zeaká noive. ");
INSERT INTO gah_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Lekeza sozaló vegenáise, mikasímini mogona gona miliká itó okulumalímini mogona gona miliká iaká niamóza, itínasa gamena oko moloko noumómámini mogona nanamú gili vevesisá amave. ");
INSERT INTO gah_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Itó lekezatini nene mogona makó hee lo noitimoláa nanamú gona milisá amave. ");
INSERT INTO gah_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Lá niake, ve makolímo goní ogetanogo goní numutoka gelémoko novoko goní napa ale heleaká veló gelémoko noviko, gapoloka makó niviki mulunagú hulu itive loko netá makó amitanize. Lá amoko áminagi aleloko gopa hanuva goní ale heleaká ve noitoka anititanimó nene, goní napa ale heleaká ve nenémo pilisi vetini kigizakú gelémo molokiko nagá numukú ahuligimikataze. ");
INSERT INTO gah_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Neza lamaná lo nogumuve. Zunigú nagá numuni napagú minokoko lihimakámini meinaváa koma napa apaso asú amitanimó nene, áminagú ahulogimikiko mino-loko voko minanogo ane, loko lo kimimó. ");
INSERT INTO gah_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ámina gamenaló neneló mina vegená lugáate Galilaia vegená makolitini gakoláa nene Izesuni láa liki li amemó: Keza Ómasímini guguni gizi namego, Pilató nene kepele nahulake Ómasímini guguni gizi ame netalímini golanigi keí golanigi ale gopánapa imó. ");
INSERT INTO gah_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Liki li amikago, eza konotó aleko láa loko lo kimike limó: Galilaia vegenakutí lá iki hele vegenalitini lihimaváini napa napa nego lá iki kemeni vami gapo vikave liki nigelehe. ");
INSERT INTO gah_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Lá oko nomive loko lo nolukumuve. Lekelisi ámináminiki likigika ali viligamitamó nene, lekezagi lá ikigó tolova inigave. ");
INSERT INTO gah_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Itó Siloama apatoka numuni napa makó nene lemeko akake vegená 18 kepele hilimó nene, Zelusalega mina vegenakutí lá iki hele vegenalitini lihimaváini napa minamole liki nigelehe. ");
INSERT INTO gah_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Lá oko nomive loko lo nolukumuve. Lekelisi ámináminiki likigika ali viligamitamó nene, lekezagi lá ikigó tolova inigave. ");
INSERT INTO gah_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Loko loake, Ómasímo Zuta vegenakumú goselé apilikumú anoza gakó makó láa loko limó: Ve makolímo nene gohuna za makó zuhá oake, minake, alika ake gihilamú vitagá imó. Oko ánigamó nene gihiláa nomigo, ");
INSERT INTO gah_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","mikú hozaló véa láa loko lo amimó: Ánigozo, melekeni losive makole oko novigo imane gohuna zámini gihiláa liginogo umóza, gihiláa nomive. Mikasi nogozáa hanuvamú ale asú okatize, apele ahulozo. ");
INSERT INTO gah_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Loko lokago, mikú hozaló vemámo láa loko lo amike limó: Golohá venemaka, itína meleketó mogonauka hoza aleko mikasi ale viligokinake, pulumaká izatini ase makó nene molatove. ");
INSERT INTO gah_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Lá okugo, alika kilisimasiló nene gihila zitimó nene, lamaná itive. Gihila zemikoma, apelezo loko lokako, apele ahulatove, loko live loko Izesú limó. ");
INSERT INTO gah_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Holisi makokú Izesú nene monó numukú iteake monó gakó lainim-oketamó. ");
INSERT INTO gah_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Lá noigo, vená makó minamó nene holosi makó agikagú noigo melekeni 18-ía oko novigo netá napa gizaleko minoaká imó. Lá noike, helisagi zová zekago, hee loko ote minamitimó imó. ");
INSERT INTO gah_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Lá noigo, Izesú nene ánigoake, gakó napagutí láa loko lo amimó: Vená geza givisi netá apasogimikuve. ");
INSERT INTO gah_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Loko nolike venámámini gotolaló agizanitunú nónohá zetago áminasitó litá oko ámina vená nenémo ote vevesoake Ómasi agepoka limó. ");
INSERT INTO gah_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Lá noigo, monó numuni gizapa ve napámo holisigú Izesú alémo zokakumú mulunagú golesa geleake, áminaló mina vegená láa loko lo kimimó: Hoza aleaká gamena nene 6-así nenazo, livisi vegená lelémo zokative liki nigilikima nene holisi gamenagú amiki hoza gamenagukó alo. ");
INSERT INTO gah_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Loko lokago, Guivahanímo láa loko lo amimó: Lekeza sozaló ve genezatini losigi minamó neneta, holisigú nene pulumaká izatini numukú viiki nagamí natave liki toki iza pulumaká izatini nene hoza aliki vínasiki kilímiki viaká niamó neve. ");
INSERT INTO gah_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Lá onoinazo, Zuta venáma imane nene Satá alémo golesa okago, noigo, melekeni 18-ía oko vimó nene avisi netalímini mogonáa nene holisi gamenagú apasotatomó etamihe. ");
INSERT INTO gah_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Loko noligo, gala veva nenetini kovoza napa hilimó. Lá noigo, ve vená mukí keza golivagi netá lamanalímini loló ikumú nene kogoliza vizeke geké lamó. ");
INSERT INTO gah_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Lá niago, Izesú láa loko lo kimimó: Ómasímini avogisaló vi hilata vegená nene nanáminiki niave. Nanetalímini amupiló ale moloko litove. ");
INSERT INTO gah_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Masteti gihila nenéminiki niave. Ve makolímo ámina gihila hamó alekoko minagú zuhá imó nene goloko iteake zagitana okago, nama nenete ake izanaló numuni gemóma neve. ");
INSERT INTO gah_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Loko loake, goha láa loko limó: Ómasímini lapanató vo holoakaláa nene nanetalímini amupiló ale moloko litove. ");
INSERT INTO gah_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Peleti lulu vizeaká netá nenéminoko neve. Vená makolímo nene peleti lulu vizeaká netá nene talam losigú polisigi ale gopa okago, hutilí okago, peleti nene lulu vize napa imó neve loko Izesú limó. ");
INSERT INTO gah_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Izesú nene Zelusalega vinogo noike apá kománapagú vike, gakó lainim-oketomo mohona noike vimó. ");
INSERT INTO gah_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Lá noigo, ve makolímo lo amike Guivahanínemaka, Ómasímo vegená luguhakó kugutó vizitihe. Loko lokago, Izesú láa loko lo kimike limó: ");
INSERT INTO gah_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Gateni komagú itinigima lekeza helisatini ali alévolé iniki ititave. Neza láa loko lo nolukumuve. Vegená mukilite ititune liki gilitamóza, iteminigave. ");
INSERT INTO gah_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Lá niiko, numuni amelaho nene oteoko numuni gahe ze lí okoko gahe lopena hizekiko, lekeza hetoka otiniki gaheló okohá ziki sele liki Guivahanitemaka, gahe segeletozo. Liki likiko, neza lekelí ánigo hehe lamuve. Hí numutotí vegená niave. ");
INSERT INTO gah_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Loko lo lekemekugo, lekeza láa liki li niminigave: Gezagi makó minunike nosánetá noko zahí nagamí noko nounike, geza nene lelí numute gapoló vanike numuteló monó gakó lainim-oletanimóma neve. ");
INSERT INTO gah_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Liki li nimikiko, neza láa loko lo likimitove: Lekeza hí apakú vegená niahe loko gelemuve loko mota lo lekemekuve. Lekeza golesa netatokagó mihina amó neneta aló vilo loko lo likimitoze. ");
INSERT INTO gah_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Loko lokugo, lekeza ánigatamó nene, Avalahá Isaká Zakopó itó Ómasímini agepagutí gakó liaká a ve mukí nene Ómasímini gizapaló niiko itó lekezatini likimisele ahulokiko hetó niiki ánigiiki ive nama iki miluma maluma giliki lekegepa atalá iki minanigave. ");
INSERT INTO gah_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Lá niiko, vegená ho noititokatí itó ho nolimitokatí ezegalokatí emegalokatí iki alegesá iiki Ómasímo gizapa okimiakató nosánetá niki kogoliza vizinigave. ");
INSERT INTO gah_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Lekeza gililo. Itína gamenaló limiki mina vegenakutí makolite alika itiki minanigave. Itó itína itiki mina vegenakutí makolite alika limiki minanigave, loko limó. ");
INSERT INTO gah_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ámina gamenalóisí Palisaio monó ve makó iake láa liki li amemó: Geza imane apá ahulokoko vozo. Agulizaki ve napa Heloté gepele hilinogo ive. ");
INSERT INTO gah_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Liki likago, eza hoza aleloko voko ale asú okoko alika hilitikumú anoza gakó láa loko lo kimimó: Lekeza viki ámina gala ameki ve láa liki li amikiko gilino: Itínagi azogi mininake holosi golesa kepeleko kimisele ahuloká itó kivisi vegená kelémo zokoká okinake okozá hozane nene ale lutigitove. ");
INSERT INTO gah_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Lá onoimóza, haitó apá makotoka Ómasímini agepagutí gakó loaká ve makó apili hilitamó nene etamitive. Zelusalega lá itave liki linamóma nenazo, itínagi azogi okozaki nene neza gaponeuka vinogo nouve. ");
INSERT INTO gah_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Kee, Zelusale vegenáise, Ómasímini agepagutí gakó liaká ve kipili hiliká itó Ómasímo lekelitoka hozaló kimisili vegená nene lekeza gehanitunú ahuli miliki kipili hiliká iaká niave. Neza lekelí izegipatini zuha nene okolohómo izegipala ale mulunauka moloaká noimómáminoko gamena gamena kelémo mulúneuka molanogo oaká noumóza, lekeza gili nimisá amave. ");
INSERT INTO gah_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Nenemú gililo. Ómasímo viselelikimikiko apatini nene gámé numuni vizinogo ive. Neza lo likimitove, gililo. Lekeza není nene goha ma áninagamiki mini-liki niviki alika nene Guivahanímini agulizató anitelimikane. Ómasímo lusa gegimikave liki li niminigave, loko limó. ");
INSERT INTO gah_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Holisi makokú Izesú nene Palisaio monó vetini kugulizaki ve makolímini numukú iteko nosánetá noko noigo, Izesú netá ale gopa itihe liki gizapa iki minamó. ");
INSERT INTO gah_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Lá niago, áminaló ve makó minamó nene, agisa agizani lulu vizi netá gizali ve nene Izesuni avogisaló minamó. ");
INSERT INTO gah_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Noigo, Izesú nene monó mogona apí-ikimiaká vegi Palisaio monó vegi loká oketake leza kivisi vegená nene holisi gamenagú kelémo zokosá nehe kelémo zokamosá neve. ");
INSERT INTO gah_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Loko lokago, keza nene kegepa apiziake minamó. Lá niago, ámina avisi vema alémo zokoake amiselekago, vimó. ");
INSERT INTO gah_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Vokago, Izesú láa loko lo kimimó: Lekelikutí ve makolímini gipalahe pulumaká izahe gale hánagú holisi gamenagú velehé limitimó nene, holisimagule lokoko ahulokiko áminagú minatimó nehe. Itó litá oko gelelehá oko galegutí alémo otitimó neve. ");
INSERT INTO gah_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Loko lokago, anotó aliki li amemisá amó. ");
INSERT INTO gah_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Lá ikago, alesa molo kemekago a vegená nene nosánetá nanigi niake, siá lamanaláaló minatune liki niago, Izesú ánigoake, anoza gakó makó láa loko lo kimimó: ");
INSERT INTO gah_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Ve makolímo nosánetá napaló atane loko alesa molo gemekiko nookoma, siá lamanató minamo. Ámina nosánetató ve makolímini agulizá nenémo geí givilegeneitimó nene, ");
INSERT INTO gah_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","alesa molo likimiti ve nenémo okoko geza imane noani siá ahulokoko imane ve amezo. Loko lo gemekiko, geza govoza helekiko kemegesaloka ne siá golesaló minokatanize. ");
INSERT INTO gah_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Nosánetá napaló alesa miligimikikoma, geza vokoko kemegesaloka siató noako, alesa molo gemeneiti ve nenémo okoko zogone geza kovogisaloka ne holomaló voko minozo. Loko lo gemekiko, nosánetá niki nia vegenalitini kovogisaló gugulizá oteko vinogo ive. ");
INSERT INTO gah_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ve makolímohe makolímohe ezáa agulizá ale otitimó nene, ezáa agulizala liminogo ive. Itó ve makolímo ezáa agulizala aleko lemeko molatimó nene, Ómasímo aí agulizala ale napa inogo ive. ");
INSERT INTO gah_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Loko loake, Izesú alesa molo ami vema láa loko lo amimó: Geza nosánetá napa ale vavá nooko nene, zogoga itó gugunaka itó geza zuha itó geza numukaloka vegená itó moníini vaí onoiti vegenakó alesa molo kememo. Keza nosánetá napa ali vavá niiki alesa mili gimiiki, nosánetá kemenitó goha akú gimikataze. ");
INSERT INTO gah_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Geza nosánetá napa ale vavá nooko nene, gohogó vegenaki kigisa kigizani nakeseta vegenaki kigisa genisi ina vegenaki kogómula lika vegenaki alesa molo kemezo. ");
INSERT INTO gah_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Lá okako, keza niiki nene, alika goha akú nosánetá pekimi iki gimitamoláa nominazo, geza gogoliza vizeko minanogo ane. Lá oko noako, Ómasímo vegená lamanaláa hilinitakutí kelémo otiti gamena nene meinaváa giminogo ive, loko limó. ");
INSERT INTO gah_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Nosánetá noko mina ve makolímo Izesú láa loko noligo geleake, láa loko lo amimó: Keza Ómasímo gizapa okimiaká onoitó miniki nosánetá niki minata vegená kogoliza viziki minanigave. ");
INSERT INTO gah_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Loko lokago, Izesú nenemú anoza gakó makó láa loko lo amimó: Ve makó nenémo nosánetá napa ale vavá inogo vegená mukí alesa molo kimimó. ");
INSERT INTO gah_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Alesa molo kemekago, nosánetá nata gamena alitokago, nosánetató atave loko hozaló veva amiselekago, alesa molo kimi vegenatoka vike lekeza alo, nosánetá mota ale vavá okave. ");
INSERT INTO gah_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Loko lo kemekago, keza mukitó vitakumú goselekaseleka lake makolímo nene láa loko lo amike limó: Neza mikasi makó meina hizenounazo, neneloka voko ániganogo novuze, agulizaki vema láa loko lo amezo. ");
INSERT INTO gah_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Loko lokago, makolímo láa loko limó: Itínasa pulumaká iza ligizani luga luga asú igo meina hizenoumó nenazo, hanuva nitahe loko ániganogo nouze, agulizaki vema láa loko lo amezo. ");
INSERT INTO gah_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Loko lokago, makó nenémo láa loko limó: Neza itínasa vená alekuke nouke, nenemule loko vaminogo uze, loko limó. ");
INSERT INTO gah_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Láa liki likago, ámina hozaló vemámo nene goha atiginá oko vike keza la gakó nene gizapa veva avetó oko lo amekago, geleake, izapaló molokago, hozaló vema láa loko lo amike limó: Geza litá oko taoniloka voko gapo napagú komagú novoko neneló gohogó vegená kigisa kigizani nakeseta vegená kogómula lika vegená kigisa genisi ina vegená kelémoko ano. ");
INSERT INTO gah_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Loko lokago, hozaló vevámo gele ameko mohona oake okoko láa loko lo amimó: Gizapa venemaka, hoza gakó lonetanimó mota gele alekumóza, siá makó nene hanuva minokave. ");
INSERT INTO gah_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Loko lokago, golohá veva nenémo hozaló vema láa loko lo amimó: Geza nene pilipilí gapoló itó mi gapoló novoko není numukú gikí iki minatave loko vegená gala vizeko kelémoko ano. ");
INSERT INTO gah_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Neza láa loko lo nogumuve. Neza goí oko alesa molo kumu vegená amanazo, není nosánetakutí keké naminigave, loko lo kimimó. ");
INSERT INTO gah_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Vegená mukí nene Izesuni ámegetiki nivago, eza viligoko láa loko lo kimimó: ");
INSERT INTO gah_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Makó eza nezagi minatíive lokokoma izolagini amelagini vená izegipala eza zuhamú gelekiko itekikoma, itó ezáa minoko aleko itimó nenemú gelekiko itekikoma nene, itó nenikumú gelekiko lemetigí oko noikoma nene, není izegipa loló oko minaminogo ive. ");
INSERT INTO gah_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Makó ezáa zohota zaló apili hilinigi miluma netá gihitatakumú gele zageoko némegetamitimó nene, není izegipa loló oko minaminogo ive. ");
INSERT INTO gah_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Lekelikutí makolímo numuni napa makó ginogoma ganatilisi meinaváa gelekoko moni mota akohihe akohemihe loko molo geleko ánigokoko, giti avotigí nehe nenémini mogonáa geleko ániganogo ive. ");
INSERT INTO gah_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Itó lá amoko litávatá oko gopa numuni ale hizeko gitimó nene, monima asú okiko vitagá okoko numunima ahulokiko, vegená keza ánigiiki nene giza itiki, ");
INSERT INTO gah_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","imane vémo sozáa moloko numuni napa ale hizeake lá iha iha ahulokago lá onoive liki linigave. ");
INSERT INTO gah_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Itó agulizaki ve napa makolímo agivelahini agulizaki ve makó apilitove loko oko lova agoka ameminogo ive. Áisi ganá láa loko agata gilinogo ive: Leza áimane luguhakó 10 tausen minokune, itó kéisi mukí 20 tausen minikanazo, kepelesá nehe kepelemosá nehe lokoko, ");
INSERT INTO gah_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","ezáagi izegipa agunamotamolagimú giliko akohemikoma, gala veva nene numunaloka ha noiko, litá oko hutono netá ameko ve makó amiselekiko voko itína nonagá itune loko nimiselekago nouve. ");
INSERT INTO gah_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Loko litimó nenazo, nenemú lekelitokatí makó eza ámina oko netá matala mukí ahulo asú amitimó nene nana oko není izegipa loló oko minative. ");
INSERT INTO gah_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Age nene netá lamaná nemóza, agema laga amitimó nene, nana oko goha alémo melelé itune. Ma lá aminogo une. ");
INSERT INTO gah_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Némini manáminoko ale melelé itunimoláa nomive. Hanuva lepe ahulanogo une. Nenemú lakagatagi minatamó neneta gakó imane gili hee liki gililo. Lekezagi melelé iki minalo, loko limó. ");
INSERT INTO gah_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Takisi aliaká vegi moko mogonaló vegenaki mukí iki monó gakola gilinigi Izesutoka alegesá iaká amó. ");
INSERT INTO gah_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Lá niago, Palisaio monó vegi monó mogona apí-ikimiaká vegi keza nenemú gelego, golesa imó. Golesa okago, Izesukumú láa liki liaká amó: Imane ve eza mokoló vegenámagi kelémo molokago nosánetá noaká noimó nene etamive. ");
INSERT INTO gah_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Liki likago, Izesú geleake, anoza gakó makó láa loko lo kimimó: ");
INSERT INTO gah_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Lekelitokatí makolímo sipsip izava 100 minatakutí nene hamó tolova itimó nene vitagá amitihe. Lá oko nomive. Lugáa 99 hanuva minamoláa makotoka kelémo nupa onoko ahuloketonoko mohona oko tolova imoláamú vitagá inogo ive. ");
INSERT INTO gah_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Vitagá oko oko ale utó okoko, mulunagú lamaná geleko agohí geko numutoka alekanogo ive. ");
INSERT INTO gah_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Aleko oko agivelagini kelémo nupa okoko láa loko lo kiminogo ive: Sipsip izáne tolova imóma ale utó molokuze, logoliza vizitune loko litimó neve. ");
INSERT INTO gah_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Nenemú neza lo likimitoze, gililo. Vatí oko noune liki litamoláa 99 asite kigika ali viligamita vegenakumú nene okulumakú kogoliza aminigave. Ve golesa hámakolímo agika ale viligokagoma nene okulumakú kogoliza napa viziaká niave. ");
INSERT INTO gah_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Itó vená makolímo silivá gehani 10-ía molo ikakutí hámakó alemó zitimó nene ma ahulaminogo ive. Eza liví legeko lolopa giteva giteva oko ale utó molokoko, ");
INSERT INTO gah_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","vená agivelagini kelémo nupa okoko gehanínema alemó zimóma vitagá oko ale utó okuze, nezagi makó logoliza vizitunize loko lo kiminogo ive. ");
INSERT INTO gah_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Nenemú neza lo likimitoze, gililo. Ómasímini ageloge keza ámina iki mokoló ve hámakolímo agika ale viligokagoma kogoliza napa viziaká niave. ");
INSERT INTO gah_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Izesú nene gakó makó láa loko lo kimimó: Ve makolímini gipala losi minasimó. ");
INSERT INTO gah_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Miniki alika nanasi nenémo amelahini lo amike ahóno, geza moni henokanoni molo netanimóma nemezo. Loko lokago, moni henokanoni gona moloko gipa lositáma kimimó. ");
INSERT INTO gah_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Kemekago, alika nanasi eza mino hána amike henokanona ale nupa oake, gita oko aleko vimó. Voko mikasi gohauka minake, gumesisi gamasisi ike, iza goula nosató henokanona ahulo asú imó. ");
INSERT INTO gah_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ahulo asú oake noigo, ámina mina mikasiló nene gaúna sipisi helemó. Hilikago, nosánetakumú vitagá oake, ");
INSERT INTO gah_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","mikasi amelaho makotoka voko lokago, eza iza gizapa oko minatane loko lomikago, neneloka voko izama gizapa noike, ");
INSERT INTO gah_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","nosá makó amemake mosimikago izatini nosánetakutí natove loko imóza, nenegi mositamó. ");
INSERT INTO gah_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Lá ikago, minake agata kolosokago, láa loko agata gilimó: Aménehini gelekelé izegipala mukí minake, goula nosánetá lamaná niki nitamóza, neza imaneloka gaúnamú hilinogo nounazo, ");
INSERT INTO gah_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","numúneloka atiginá oko vinake aménehitoka láa loko lo amitove: Ahóno, golesa netá loló okugo, lihimavánémo Ómasiloka itó geitoka gena okaze, ");
INSERT INTO gah_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","goha gipakave loko minamitove. Hanuva gelekelé izegipaka nelémo molokako minatove. Loko geleake, oteko amelahitoka vimó. ");
INSERT INTO gah_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Voko numu gatetó anitigo, amelaho ánigoake, milumavala geleake, ololu loko vike anukeake agoka agepa nonago, ");
INSERT INTO gah_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","gipalamámo láa loko lo amimó: Ahóno netá golesa loló okugo, lihimaváne Ómasiloka itó geitoka gena okaze. Nenemú goha gipakave loko minamitove. ");
INSERT INTO gah_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Loko noligo, amelaho nene gelekelé izegipala lo kimike limó: Lekeza litá iki gó lamaná aliiki goló vizitalo. Ana lamaná ali vizitiki suú ali militiki ali namiki, ");
INSERT INTO gah_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","pulumaká iza akaleva geható minamó makóma apiliki gitalo. Leza ninake logoliza vizeko minatune. ");
INSERT INTO gah_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Gipáne nene heleneikutí goha otekave, itó eza tolova onoikutí goha utó okave. Loko lokago, kogoliza viziki gehani giziki namó. ");
INSERT INTO gah_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Lá niago, ganá gipalamámo hozauka minakutí ake, númaseloka anitike gilimó nene, kogoliza viziki meleketakeni niago, geleake, ");
INSERT INTO gah_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","gelekelé izegipa makó sele lo ameake, okago, loká otoko nuvane nana niave, ");
INSERT INTO gah_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","loko lokago, áisi limó: Gugunakama gozapá vimóma avasavagi omo anitekago, ametipo pulumaká iza akale geható minamóma nene apelego gizo vatá noune. ");
INSERT INTO gah_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Loko lo amekago, ganá gipalamámo izapaló molokago, mesaha oake áminaló vo anitemigo, améipo geleake, lemeko alémo hulu iha, ");
INSERT INTO gah_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","gele ahuloake láa loko lo amimó: Gelezo. Melekeni mukí ale ahulokuke gelekelé ogetoko minuke, gakoka makó gele ahulosá amumóma nemóza, geza nene meme iza akaleva makó nemeko nigive nagavegi ma apeleko namuháma neve. ");
INSERT INTO gah_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Itó gipaka alika nanasima geí moni henokanonima moko netató ahulo asú okave. Ánenémini okago, geza lokako pulumaká iza akale geható minamóma apiliki gizi vatá nitahe. ");
INSERT INTO gah_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Loko lokago, améipo láa loko lo amimó: Gipánemaka, geza gamena hána nezagi minanimóma nenazo, není netá mukí nene geíma neve. ");
INSERT INTO gah_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Itó gugunaka nene heleneikutí oteko okave, itó tolova onoikutí goha utó okave. Nenemú mulutegú lamaná geleko logoliza vizuko lamaná noive, loko limó. ");
INSERT INTO gah_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Izesú nene izegipala zuhama gakó makó láa loko lo kimimó: Henonavagi ve napa makolímini gizapa ve makó minamó. Minoko gizapa vemámini gakó makó nene gizapa vemámo henoni ale gopa oaká noive liki lamó nene geleake, ");
INSERT INTO gah_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","sele lo ameake, láa loko lo amimó: Geí gakó nanave liki lago guluhe. Ve nenéminaka není gizapa ve goha minamitane loko noluve. Hoza tiketima alekano. Moni henokanoníne gizapa anitímini mogonáa ale utó molatune. ");
INSERT INTO gah_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Loko lokago, henoni gizapa vemámo agikatunú láa loko gilimó: Imane golohá venémo hozanema ipá okiko nana itomó neve. Govisi hoza alitomó nene goselé nepelekave. Gapoló monimú voká vokató mohona itomó nene novozáne helekative. ");
INSERT INTO gah_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Loko gelekunazo, neza golohá venémo nimiselekiko ve nigivénege nilími lamaná niko numúikú minoko aleko itomoláamú netá lamaná makó oketatoze. ");
INSERT INTO gah_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Loko loake, golohá vevámini nekisáa ali mina vegenáma hamopamó alesa molamó. Moloake, makó láa loko loká otamó: Golohá venémini nekisa geitoka nanakí neve. ");
INSERT INTO gah_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Loko lokago, áisi meseme nogoza talam 100 neve. Loko lokago, litá oko tiketi imane alekoko 50 loko gizamane. ");
INSERT INTO gah_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Loko loake, makóma loká otake golohá venémini nekisáa geitoka nanakí neve. Loko lokago, áisi laisi gó 1 tausen neve. Loko lokago, litá oko tiketi imane alekoko 800 loko gizamane. ");
INSERT INTO gah_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Loko lokago, golohá vevámo geleake, henona ale gopa napa gizapa vema gele veveso minake alikumú geké lotamó. Itó monóini nomi vegenalite netá matá inigi gili vevesi minake napaló gili kimiaká niave. Monotinigi vegená lekeza nenémini suni lekelitoka ma minamive. ");
INSERT INTO gah_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Nenemú litoze, gililo. Lekeza ámina iki moni henokanoni ha netale liiki vegená kimikiko keza likigive lilí ikiko, ámina netá ali minata gamenaváa asú okiko nene alévolé apatoka molo lekemekiko áminagú miniki meinavatini alinigave. ");
INSERT INTO gah_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Makó eza netá koma kamaló nene ale guni oko gizapa itimó áisi nene netá napaloka ámina oko ale guni oko gizapa lamaná inogo ive. Itó makó eza netá koma-kamaló ale gopa napa itimó áisi nene netá napagi ámina oko ale gopa napa inogo ive. ");
INSERT INTO gah_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Lekeza henokanoni ha netá nene ali lamaná iki gizapa amitamó nene, netá gihila nene éaho likimitive. ");
INSERT INTO gah_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Itó netá hagitana likimimó nene gizapa i guni amitamó nene, lekelí alévolé henoni nene alika éaho lehizeleketative. ");
INSERT INTO gah_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ve hámakolímo kugulizaki ve lositalitini gelekelé ma oketaminogo ive. Lá itimó nene maga ve agika amekoko maga ve mukahá apilitimó onoive. Itó maga veloka gímize lamaná okoko maga ve ánigo goselé inogo ive. Lekeza ámináminiki Ómasímini hoza nemó itó moni henokanonímini hoza nemó ganagana lelegí oko aleakaláa nomive. ");
INSERT INTO gah_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Loko lokago, Palisaio monó ve keza moni henokanonimú lagaváa gili miniaká a ve nenete giliake, gakola gili hazutazu amó. ");
INSERT INTO gah_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Lá ikago, Izesú láa loko lo kimimó: Lekeza nene vegená kovogisaló veveso noune liki amuza miliki mihina iaká niamóza, Ómasímo nene likigikámini mogonáa geleaká noive. Vegenalite ánigamó nene vevesonoi netá geleaká noigo, Ómasímo ánigoko gilimó nene mu-izapa oaká noive. ");
INSERT INTO gah_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Mosé lo hukoko li gakó itó Ómasímini agepagutí gakó liaká a vetini gakó minoloko ova ova ike ike Zonitoka anitimó. Nenelotí veletoka nene Ómasímini gizapaló minoakalímini gakó lamaná hutilí oko vokago vegená mukilite lovasava iki Ómasímini avogisagú vinigi lá iaká niave. ");
INSERT INTO gah_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Okulumaki mikasigi keza vo tolova itíive liki vi tolova itáimóza, Mosé lo hukoko li gakó nenémini lotonáa hamokó ma haha aminogo ive. ");
INSERT INTO gah_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ve makolímohe makolímohe venala amisele ahulokoko haitó vená alitimó nene, ve vená huko ezega emega oakalímini lihima alinogo ive. Itó ve makolímohe makolímohe ahulinita vená makó alitimó nene, ámina netalímini lihima alinogo ive loko Izesú limó. ");
INSERT INTO gah_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Izesú anoza gakó makó láa loko limó: Henonavagi ve napa minamó. Eza gó luhuvagigó meinava iteko minamokó ale akoloko minamó. Itó gamena gamena ló gehaka like agoliza vizé vizé oko minoaká imó. ");
INSERT INTO gah_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Lá noigo, gohogó ve makó agulizá Lasaló eza agupeló halamé gizaleake henonagi vemámini numuni sepekuka ako minake, ");
INSERT INTO gah_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","nosá nakutí litímotila alemó zimoláa ma nimiko natonazo loko geleko minoaká imó. Lá oko noigo, galate aniteke halamelalotí génimiaká amó. ");
INSERT INTO gah_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Lá oko minake, gohogó vema helekago, ageló keza alímiki itiki Avalahani amatoka ahulimikago minamó. Itó alika nene henonavagi vema helekago, gale zitamó. ");
INSERT INTO gah_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Gale zimikago, meikú lemeko miluma maluma geleko minake, okenava oko ánigamó nene Lasaló nene Avalahani amatoka noigo ánikagamó. ");
INSERT INTO gah_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ánikogoake, sele loko láa loko limó: Avalahazo, aménegamaka, nenikumú milumaváne geleoko Lasaloni amiselekako agizani gosavatunú nagamikú lupizeoko oko genezáneloka naliko hulu nivisitiho. Neza lokú imane miluma maluma golesa geleko nouho. ");
INSERT INTO gah_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Loko lokago, Avalahá láa loko limó: Gipánemaka, gelenape. Geza mikasiuka lagámini amupiló minanimóma nene mota asú okamole. Itó Lasaló nene miluma malumámini amupiló minamóma ámina oko asú okave. Itína nene Lasaloni alími hulu niago, géisi miluma maluma geleko noane. ");
INSERT INTO gah_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Itó ligilikagú nene zuni napa aleko hukokamóma nenazo, imanelokatí lemeakaláa nomive. Itó nenelokatí iteakaláa nomive. ");
INSERT INTO gah_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Loko lokago, henonavagi vemámo láa loko limó: Aménegamaka, makó litoze, gele nemezo. Elane není numutoka ");
INSERT INTO gah_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","izegipa nugunáne ligizani lugaloka asú igo niave. Keza miluma apakú imane ikataze, Lasaloni amiselekako voko kagata alitive. ");
INSERT INTO gah_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Loko lokago, Avalahá láa loko limó: Óve, Moseni gakó itó Ómasímini agepagutí gakó liaká a vetini gakóma nemole. Nenema gilinitanae. ");
INSERT INTO gah_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Loko lokago, eza limó: Óe, Avalahazo, aménegamaka, mokáne, lá oko nomive. Heleneitikutí ve makolímo oteoko voko lo kemekiko, kigika ali viliganigave. ");
INSERT INTO gah_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Loko lokago, láa loko limó: Keza Mosele itó Ómasímini agepagutí gakó liaká a vetini gakó gili ahuliaká nitamóma, ve makolímo heleneikutí oteoko voko lo kimitimóza, nene ámina iki gili ahulanigi anae, loko limó. ");
INSERT INTO gah_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Izesú eza izegipala zuhama gakó makó láa loko lo kimimó: Golesa netakumú gala vizeaká nene ha minanogo imóza, golesa netakumú gala vizé vizé iti ve nene agae, Ómasímo nana otatimó neve. ");
INSERT INTO gah_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Izegipáne koma koma minakutí ve makolímo netá golesa alitive loko gala vizeko litimó nene Ómasímo nana otatimó neve. Gehani napa nene luvanaló nagá ziki age nagamikú ahelú itamola avilegeko Ómasímo genavagi netá golesa loló otanogo ive. ");
INSERT INTO gah_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ehe, lekeza likigika gizapa iki minalo. Likigive makolímo galana alekikoma, gahá ameko agata alezo. Lá okako, geí gakó gelekikoma lihimavala ahulotozo. ");
INSERT INTO gah_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Itó gamena hámakó zupa lihima netá alegetoloko vitimó nene gamena 7-ía geitoka oko nigivénega, némini ogetutímo mulúne gitihiná okave loko lo gimitimó nene, nenemú geza ámina oko lihimavala ahulotoko minozo, loko limó. ");
INSERT INTO gah_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Aposolo keza Guivahanima nene geza gele alévolé oakate ale hutilí oletozo. ");
INSERT INTO gah_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Liki likago, Guivahanímo láa loko limó: Masteti gihila komámo goloko iteko zamú geleaká noive. Nenéminoko gele alévolé oakatinía ma minatimó nene, nimuza za volane asutooko age nagamikú omane lemeko ote minamane liki li amitamó nene, gakotini gele lekemekoko hanuva lá inogo ive. ");
INSERT INTO gah_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Lekelikutí ve makolímini gelekelé izegipala makó nene mikasigú hoza aleko minatikutí itó iza gizapa oko minatikutí únakala anitekiko, gizapa veva nenémo geza litá oko numukuka iteko nosánetaka noko minozo loko hanuva lo amitihe. ");
INSERT INTO gah_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Lá oko nomive. Áisi nene láa loko lo aminogo ive: Géisi hoza aleaká lavolavo likeoko únaká nosá vatá onimikako, nonugo, hozaka asú okiko, alika gezaka vatá oko natane. ");
INSERT INTO gah_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Loko lo amekiko, gelekelé izegipama eza gizapa vevámo lota hoza nene alekogó noiko, gizapa vevámo gele lamaná itihe. Ma alémo napa aminogo ive. ");
INSERT INTO gah_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Itó mogonatipogi ámina oko neve. Lekeza hoza gakó loleketumó nene lilí i asú iikima leza gelekelé izegipa ánéa nene loletani hozagó alekune, miní ameko makó loló amune liki lilo, loko limó. ");
INSERT INTO gah_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Izesú Zelusalega vinogo Galilaia mikasigi Samalia mikasigi holúikú novike, ");
INSERT INTO gah_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","apá makotoka aniteake noitigo, halamé vegená ligizani luga luga asú igo keza ánigiake, zuha kemeaká netá nenazo liake hotokatí sele liki ");
INSERT INTO gah_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","láa liki lamó: Gizapa vele Izesugama, lelikumú milumavate gelezo. ");
INSERT INTO gah_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Liki likago, ánikogoake, láa loko lo kimimó: Lekeza viki gililitamolamú lukugupetini nene guguni giziaká ve nene kelepizilo. Loko lokago, keza nivago, kugupeló gizale netá gilili asú amó. ");
INSERT INTO gah_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Gilili asú ikago, keitokatí hámakolímo gileleake, ánigoake, atiginá oko gakó napagutí Ómasi agepoka lomo lomo, ");
INSERT INTO gah_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Izesutoka vike agihúna geko akoake, agepoka limó. Ámina ve nene Zuta ve negopa, Samalia mikasigutí vémo lá imó. ");
INSERT INTO gah_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Lá okago, Izesú láa loko limó: Ve ligizani luga luga asú igo gililikamóza, ve 9-ía keza hitoka vave. ");
INSERT INTO gah_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Keza atiginá iki iki Ómasi agepoka linigi lamake, hanuva gatizá nivago, Samalia mikasigutí hetoka ve imane eza hámakó noahe. ");
INSERT INTO gah_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Loko loake, ámina ve láa loko lo amimó: Gele alévolé anitímo gelémo zokokaze, nenemú oteoko vozo, loko lo amimó. ");
INSERT INTO gah_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Palisaio monó ve keza Izesuni loká itiki Ómasímo gizapa olimiaká ve napa hí zupa utó o lamaná itive liki likago, eza láa loko lo kimimó: Ómasímo gizapa olikimiaká netá nene lekeza ániginiko gonanalivagi utó aminogo ive. ");
INSERT INTO gah_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Nenemú lekeza anosa makó ánigiiki, eé, imaneloka utó okave, itó eé, elaneloka utó okave liki laminigave. Gilinahe. Ómasímo gizapa olikimiaká netá nene likigilikagú utó oko nemole, loko limó. ");
INSERT INTO gah_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Itó izegipala zuhama láa loko lo kimimó: Minoko gamena makó alitati zupa nene, okulumakutí lumu ve gihila neza gamena hamokó zupa utó ugo ániganigi lagava gilitamóza, ma ánigaminigave. ");
INSERT INTO gah_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Nene zupahé eé, imane lelitoka utó onoive, itó eé, keitoka utó onoive liki li likimikikoma kémegetiki vamilo. Itó giliko, lamaná amino. ");
INSERT INTO gah_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Gopisína nene okulumá nekisalokatí melevezá okago, vo lutegeaká noive. Ámináminoko okulumakutí lumu ve gihila neza ato gamena alitokiko mikasi nekisa vokisaloka nene vegená mukitó keza není ánigi asú inigave. ");
INSERT INTO gah_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Lá oko nemóza, oko moloko oaká nou netá ánigiaká nia vegenalite není ánigi golesa iiki miluma netá mukí nimitave liki linitinamóma neve. ");
INSERT INTO gah_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Noá mina zupa nene vegená keza miniki aliki amó ámina iki okulumakutí lumu ve gihila není gamena alí noliko ámina inigave. ");
INSERT INTO gah_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Keza iza goula nosá nake vená meina-kona ake, zuguzugu zegezege viziki miniliki nivago, Noá eza vená izegipala kelémo sipigú itekago, nagamí napa veleko anitike kepele gesá imó. ");
INSERT INTO gah_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Itó Lotí mina zupa áminagó amó. Keza iza goula nosá nake meina-kona ake, hozagaza aliki zuhaina zahaina ake, numuni luki giká lá iká iki Lotini gakó gelemiki niago, ");
INSERT INTO gah_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Lotí eza Soto apá ahuloake novigo, okulumakutí nene lánehakó netá ló gulumavagi limike vegená kepele gesá imó. ");
INSERT INTO gah_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Okulumakutí lumu ve gihila neza minoko utó ito zupa nene mukí vegená keza ámina inigave. ");
INSERT INTO gah_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ámina zupa nene numuni numupitó nita vegená nene atiginá iki numúitokatí henóini ma aliki vamitakumule. Itó vegená hozáitoka minatatotí henonimú giliki atiginá iki numutoka amitakumule. ");
INSERT INTO gah_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lekeza Lotini venalámitokagó gili minalo. ");
INSERT INTO gah_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Makó keza nene kigika kemeníini ali gikitiiki ali minata vegená nene kigika kemeni gopa inogo ive, itó makó keza kigika kemeni vínasi ahulatamó nene alévolé kemetamenigi minanigave. ");
INSERT INTO gah_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Neza lo likimitoze, gililo. Ámina holugú nene ve losi keza hamó holomaló akinitáikutí maga ve alémokoko maga ve ahulomikiko minative. ");
INSERT INTO gah_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Vená losi ámina iki nosá isiki minatáitotí Ómasi nenémo vená magáa alémokoko magáa ahulomikiko minanogo ive. ");
INSERT INTO gah_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Loko Izesú lokago, izegipala zuhamate loká itake Guivahanitemaka, nene netá hitoka utó itive. Liki likago, eza láa loko limó: Anuva i netalímo nama gosúveha maú zigo alegesá iaká niave. Ámina oko kigika anuva i vegená minató minató goní napa inigave, loko lo kimimó. ");
INSERT INTO gah_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Izesú nene izegipala zuhama viki akamiki gamena gamena goselekaselé amiki Ómasiloka liliki viki minikoma nene Ómasímo gele kimitikumú anoza gakó makó láa loko lo kimimó: ");
INSERT INTO gah_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Apá makotó nene goní ale heleaká ve makó minamó. Áisi nene Ómasi noimó itó vegená niamó keikumú ma gelesá amimó. ");
INSERT INTO gah_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Lá onoigo, ámina apató nene gevoná vená makó minamó. Áisi nene goní ale heleaká ve noitoka gamena gamena vike láa loko lo ameaká imó: Geza gala venémo nelémo golesa inogo igo nugutó vizitane loko noluve. ");
INSERT INTO gah_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Loko lo ameaká noigo, goní ale heleaká vemámo gevoná venámámini gakó gamena hána gele ahuloake minoaká imóza, minoko agikatunú láa loko limó: Neza Ómasi noimó vegená niamó keikumú ma gelesá amumóza, ");
INSERT INTO gah_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","gevoná vená imanémo negénegé gakó loaká noive. Lá oko loloko ova ova oko nominiko, goselé nepelekatize, nenemú alémo vatí oko ámina gakó apele hilitove loko limó. ");
INSERT INTO gah_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Loko Guivahanímo lo asú oake, láa loko limó: Goní ale heleaká ve gínikahámo gakó limó nene mota gilinahe. ");
INSERT INTO gah_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Olile. Lekeza Ómasimú nanave liki liaká niave. Eza kelémo etó i vegenala zuhamate gamena gamena negénegeka liki niiko ale vevesoketamitimó neve liki nilahe. Itó gele ahulokoko minatimó nehe. Lá oko nomive. ");
INSERT INTO gah_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Neza láa loko lo nolukumuve. Eza ale akutoko ale vevesoketanogo ive. Lá itimóza, okulumakutí lumu ve gihila neza minoko atiginá oko imane mikasiuka ato zupa nene, není gelegele minatamoláa nene ma nitahe minamitahe loko nagata gululusi noguluve, loko limó. ");
INSERT INTO gah_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ve lugáate kezáinimú gelego vevesokago, kigivéikinimú gelego lemeaká noigo, Izesú ánigoake keikumú anoza gakó makó láa loko limó: ");
INSERT INTO gah_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Ve losi keza Ómasiloka linigi monó numuni napagú itesimó, makó nene Palisaio monó ve, itó makó nene takisiló mohona oko moni gumina aleaká ve. ");
INSERT INTO gah_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Palisaio monó vemámo ote hee lonoike ezáamú lá oko geleake láa loko limó: Kee, Ómasizo, ve lugáa keza laskoli miniki guminatamina iki vená loká iki miniaká niave. Neza keikitana ve minamuve, itó takisi ale ale ve hé melanegitana minamuve. Nenemú gegepoka noluve. ");
INSERT INTO gah_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Neza holisigú holisigú gamena lositá nene monokumule loko nosánetá mosekuke minoaká nouve. Itó moni henokanoni nániguke 10 10 nekutí hamopamó nene monokumule loko moloaká nouve. ");
INSERT INTO gah_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Loko lokago, takisi ale ale vemámo nene akelepauka minake okenava oko ániganogo avoza helekago, gasínamake minake, láa loko agepoka limó: Kee, Ómasinemaka, ve golesa není gigika hize nemezo loko limó. ");
INSERT INTO gah_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Gilinahe. Takisi ale ale vemámini lihimavala ahulo asú omikago numunaloka atiginá oko vimó. Palisaio monó vemámini lihima nene ha minamó. Lá onoinazo, kezáini kugulizáini ali otita vegenalitini kugulizá liminogo ive. Itó makó keza kezáini kugulizáini aliki limiki milatamó nene Ómasímo kugulizáini ale napa inogo ive, loko limó. ");
INSERT INTO gah_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Itó ve vená keza izegipáini nene Izesú noitoka agizanitunú kugupeló aleko nónohá zeketative liki kilímiki viaká amó. Lá niago, izegipala zuhamate gahá kimikago, ");
INSERT INTO gah_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Izesú nene sele lo kimike limó: Lekeza izegipa koma ahulikimikiko nenitoka atave. Nenémináa keza Ómasímini avogisaló viakalímini mututoni nianazo, li hoipa ikitamilo. ");
INSERT INTO gah_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Neza lamaná lo likimitoze, gililo. Makó keza izegipa namuni monokú vávani iki itiaká niamó nenéminiki monokú itemitamó nene, Ómasímo gizapa okimiakakú keké iteminigave, loko limó. ");
INSERT INTO gah_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Itó monó gizapa ve makolímo Izesuni loká otoko Tisá lamanámaka, neza nana okinake alévolé nemetameni alitomó neve. ");
INSERT INTO gah_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Loko lokago, Izesú láa loko lo amimó: Geza nenikumú ve lamanale loko nanamú nolane. Lamaná améneho Ómasi hámakó noize, makó nominazo, není mogonamú gele hee lominoko nolape. ");
INSERT INTO gah_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Itó geza gapo lota gakó gelenane. Láa lokove: Ve aleve suni ale gopa oko huko ezega emega amo. Geza vegená kepele helemo. Gumina amo. Geza soza hakupá gakó lamo. Geza izokahiko amekahiko kugulizá ale otezo. ");
INSERT INTO gah_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Loko lokago, gizapa vemámo láa loko limó: Neza ámina lo huka gakó mukí nene izegipa namutotí apí oko ámegetoaká noumóma neve. ");
INSERT INTO gah_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Loko lokago, Izesú geleake, láa loko lo amimó: Netá hámakó velesá loló amanimó nene ale hee litanize. Geza voko henokanoka mukí nene meinaló moloko moni alekoko gohogó vegená kemekoko, oko némegetozo. Itó lá okako okulumakú helisa henoni utó ogetanogo ive. ");
INSERT INTO gah_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Loko lokago, ve eza henokanona vaí oake minamó nenazo, gona moloko kimitohe loko giligo gena imó. ");
INSERT INTO gah_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Lá okago, Izesú ánigoake limó: Henokanóiki vegená keza Ómasímini lapanató silipa iki ititamó neve. ");
INSERT INTO gah_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kamele izámo nakasi vovónagú voakaláa vávani oko nomimóza, henokanóiki vegená nene Ómasímini lapanató voakaláa nene ámina oko genavagi golesa neve. ");
INSERT INTO gah_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Loko noligo gele vegenalite láa liki lamó: Íi, láa lokoma éahinima Ómasímo agutó vizekiko minoloko voko minative. ");
INSERT INTO gah_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Liki likago, Izesú lo kimimó: Vegenalite nenémini itamoláa nomimóza, Ómasímo loló itove loko agata gili netá nene vávani okogó loló oaká noive. ");
INSERT INTO gah_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Loko lokago, Pitá láa loko lo amimó: Gelenape. Leza mukí netá matate ahulo asú okunike geí gémegetokuninazo, alika nene meinava alesá nehe. ");
INSERT INTO gah_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Loko lokago, Izesú Pitaginima láa loko lo kimimó: Lamaná lo likimitoze, gililo. Makó keza numúini apáini nehe vená izegipáinihe gouna zuhahe izóikini améikinihe Ómasímini lapanakumule liki ahulikitiki iki nemegesaló atamó nene, ");
INSERT INTO gah_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","nenémini meinava nene mikasiuka napaló alinigave, itó miniki okulumakuka alévolé kemetameni alinigave, loko lo kimimó. ");
INSERT INTO gah_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Izesú nene izegipala zuhama amegesa vizitoka kelémo moloake láa loko lo kimimó: Gililo. Leza Zelusalega noitune. Itekuko, Ómasímini agepagutí gakó liaká a vete okulumakutí lumu ve gihila nenikumú epoapoga linamó mukí nene alévolé inogo ive. ");
INSERT INTO gah_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Hetoka vetini kigizakú nilími milikiko, keza gopoguka linitiki galaná milinitiki, gituhú initanigave. ");
INSERT INTO gah_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Lá iiki uheni nagatunú nipiliiki nipili hilikiko, gamena losive makole minokinake heleneitokutí goha otinogo uve. ");
INSERT INTO gah_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Loko lokago, keza gelego ligitagani imó. Mogonáa hitokimikago, ámina gakó gilinigi gili vevesamamó. ");
INSERT INTO gah_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Izesú eza vike Zeliko numutó ale alitamó. Ale alitokago, gapo agilikaloka nene agómula lika ve makó minake, monimú voká vokató minoaká imó. ");
INSERT INTO gah_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Lá oko noike, mukí vegená vigá igá niago, mogonamú loká okimikago, ");
INSERT INTO gah_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","keza Nasalete numutotí ve Izesúma noave. ");
INSERT INTO gah_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Liki likago, gakó napagutí sele loko Izesuvo, geza Tevitini agávolagamaka akagá oletatane loko lo mololeta vetemaka, nenikumú miluma gelenetamane. ");
INSERT INTO gah_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Loko lokago, goí iki niva vegenalite legesó oko minative liki gahá amemóza, áisi nene gele ahuloake gamoga gike sele like geza Tevitini agávolagamaka, nenikumú gigika hizino. ");
INSERT INTO gah_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Loko lokago, Izesú geleake, gapoló noike lekeza nenitoka alímiki alo. Loko lokimikago, agómula lika vema Izesutoka alímiki ikago, loká otake limó: ");
INSERT INTO gah_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Geza nana netá alegetatokumú nolane. Loko lokago, agómula lika vemámo Guivahanínemaka, nogómuláne ale goloutonetatane loko noluve. ");
INSERT INTO gah_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Loko lokago, Izesú láa loko lo amimó: Gogómulaka goloutino. Nenikumú gele alévolé anitímo gelémo zokokaze. ");
INSERT INTO gah_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Loko noligo, áminasitó agómula goloutamó. Goloutokago ánigoake Izesuni ámegetoko vike Ómasi agepoka limó. Lá noigo, ániga vegená keza ámina iki Ómasi agepoka lamó. ");
INSERT INTO gah_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Izesú nene Zeliko numutoka aniteake, avilegeko vinogo igo, ");
INSERT INTO gah_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","ámina apató ve makó minamó, agulizá Zakiasí, áisi nene takisi aliaká a vetini agulizaki venini. Eza henokanonámo vaí o mina ve minamó. ");
INSERT INTO gah_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Áisi nene ve alínipa nenazo, Izesuni agupeló ánigatove lokoko vegená mulusigú minake Izesuni ánigamike, ");
INSERT INTO gah_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","ololu loko vegená kivilegeake, vike zaló iteko noike imaneló nougo Izesú imaneloka okiko ánigatove. ");
INSERT INTO gah_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Loko geleake noigo, Izesú eza áminaló vo aniteake, okenava oko ánigoake láa loko lo amimó: Zakiasizo, litá oko lemeno. Itína neza geí numukuka vitíive loko nouve. ");
INSERT INTO gah_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Loko lokago, litá oko lemeake, mulunagú lamaná geleko numunauka alémoko vimó. ");
INSERT INTO gah_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Vi itikasigo mukí vegená keza ánigiake, gili golesa iake áisi nene nanamú ve golesámini numukú iteko noive. ");
INSERT INTO gah_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Liki likago, Zakiasí áisi nene Guivahanímini avogisaló oteko láa loko limó: Guivahanínemaka, gelezo. Moni henokanóne lelegí oko gona molokinake lugáa nene gohogó vegená kiminogo uve. Itó vegená lugáatini moni henokanóini soza saza luke avilegeko aleaká umó nene neko, aleko iteko hamó alutó nene losive losive kimitove. ");
INSERT INTO gah_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Loko lokago, Izesú limó: Nenémini hoza aliaká nia vemú nene monóini nomi vegená niave liki liaká niamóza, imane ve Zakiasí nene ezagi Avalahani agávolaho Zuta ve gihila noive. Itína aí numukú oko ánigumóma agutó vizeaká netá mota utó okave. ");
INSERT INTO gah_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Okulumakutí lumu ve gihila neza tolova inita vegenakumú vitagá oko kugutó vizitove loko lumumóma neve, loko limó. ");
INSERT INTO gah_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Izesú Zelusalega ale alí noligo, gakola gele vegenalite itína Ómasímo gizapa olimiaká ve napa alémo utó iti gamenava alitokave liki nigelego, gili hee litave loko Izesú anoza gakó makó láa loko lo kimimó: ");
INSERT INTO gah_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Agulizaki ve makolímo agulizaki ve napaloka voko lokugo mikasi gizapa ve nenémini akilí hitonimikiko atove loake, mikasi gohauka vinogo noike, ");
INSERT INTO gah_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","gelekelé izegipala ligizani luga luga asú igo sele lo kemeake, moni gó hamopamó nokimike láa loko limó: Lekeza imanetunú lilí iki ali hutilí iki niko, atiginá oko ánigatove. ");
INSERT INTO gah_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Loko loake, vokago, aí gizapaló mina vegená lugáate gili golesa imiake, vegená kimisilikago, ámegetiki vake agulizaki ve napama láa liki li amemó: Géisi nene mikasi gizapa vele minamitane loko nolune. ");
INSERT INTO gah_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Liki likago, agulizaki ve napamámo nene gopa voko minake mikasi gizapa vémini akilí amekago, atiginá imó. Atiginá oko vike nene gelekelé izegipala moni kimi vegená láa loko alesa molo kimimó: Moni lukumumóma nene hozaváa alikago, nanakí akohekahe, alikalo loko alesa molokago, ");
INSERT INTO gah_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","gelekelé izegipa makolímo anitike limó: Guivahanínemaka, geza moni gó hámakó nemenimó nenetunú hoza aleko gó gosohá ligizani luga luga asú igo ale utó molokuve. ");
INSERT INTO gah_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Loko lokago, láa loko lo amimó: Geza gelekelé ve lamaná noane. Vatí oko hozaló gizapa okane. Geza ha netalímini hozaváa ale guni oko gizapa okanize, nénisi numuni apá ligizani luga luga asú igo nenetini gizapa ve loló ogimikugo minatane. ");
INSERT INTO gah_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Loko lokago, gelekelé izegipa makolímo anitike limó: Guivahanínemaka, geza moni gó hámakó nemenimó nenetunú hoza aleko gó gosohá ligizani lugaloka asú igo ale utó molokuve. ");
INSERT INTO gah_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Loko lokago, láa loko lo amimó: Vatí okove. Geza numuni apá ligizani lugaloka asú igo nenetini gizapa ve minatane, loko lotamó. ");
INSERT INTO gah_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Itó gelekelé izegipa makolímo aniteake láa loko limó: Guivahanínemaka, moni gó hámakó nemenimó nene gotunú asapú oko otoha oko ale molonoumó imane aleko nouve. ");
INSERT INTO gah_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Geza gínikaha ve minokaninazo, ve makolite hoza alikago gihiláa utó okago aleaká noane. Itó ve makolite mini zuhá inató gihila omolokago nosánetá aleko asutoko noaká noane. Nenemú gelekuke geikumú nehelele vizekago monika nene gizapa oko alenoumole. ");
INSERT INTO gah_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Loko lokago, gizapa vemámo láa loko lo amimó: Gelekelé izegipa golesa gezaka lani gakó nene ale viligoko goní nogetuve. Geza gínikaha ve noutímini mogona gelenane. Ve makolite hoza alikago gihiláa utó okago aleaká nouve, itó ve makolite mini zuhá inató gihila omolokago nosánetá aleaká nouve. ");
INSERT INTO gah_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Nene mogonáne gelekanimóza, moníne nene peni numukuka molokako ámina moniló miní amiki nimilinitiko neza goha inake voko alitonazo. Nanamú neve. ");
INSERT INTO gah_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Loko loake, aí amatoka oti mina vegená láa loko lo kimimó: Moni gó aleneimó nene aliiki moni gó ligizani luga luga asú igo alenei vema nene amilo. ");
INSERT INTO gah_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Loko lokago, keza ininá iake Guivahanitemaka, eza nene moni gó ligizani luga luga asú igo mota alekamole. ");
INSERT INTO gah_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Liki likago, eza limó: Neza gakó makó lo likimitoze, gililo. Ve makolímo Ómasilokatí netá makó alenokoma gizapa lamaná itimó nene Ómasímo goha miní ameko aminogo ive. Itó netá makó gizapa lamaná amiti ve nenémo ale nouhe loko agata gilitimóza, Ómasímo goha ipá oko alinogo ive. ");
INSERT INTO gah_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Itó není gala ve nene nenikumú Guivahanite loló amitane liki liaká a vema kilímiki iki není nogómulaló kipili hililo, loko limó. ");
INSERT INTO gah_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Izesú láa loko lo kemeake, Zelusalega vinogo ale goí o kemeko novike, ");
INSERT INTO gah_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Olivi agoka gohalaló numuni apá lositá nene Petepage itó Petania minasitó ale alí nolike, izegipala zuhagutí ve lositá nokimisilike, ");
INSERT INTO gah_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","láa loko lo kimimó: Lekeza helega numutoka viki anitiiki toki iza akaleva nagá zinamóma nene vegená kogohí geko mohona onamitimoláa nene ánigiiki vínasiki aliki alizo. ");
INSERT INTO gah_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Vínasiki aliki nisiko, ve makolímo nanamú nivínasasive loko nolikoma, Guivahanímo hoza nego ámina izamú limiselekago nousive, liki li amilizo. ");
INSERT INTO gah_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Loko loake kimiselekago, keza vasigo, Guivahanímo goí oko lo kimi gakotó ámina netá utó imó. ");
INSERT INTO gah_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Utó okago, toki iza akalevámini nagá nivínasasigo, iza amelage lekeza nene toki iza akalevama nanamú nivínasasive, ");
INSERT INTO gah_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","liki likago, keza láa liki li kemesimó: Guivahanímo hoza nego imane izamú lokago oko novínasusive. ");
INSERT INTO gah_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Liki likasigo, iza amelage gili kimikago, toki iza nene Izesutoka aliki vikasike, hepekumú luhoaká góini gololohá iki ámina toki iza akalevámini amegesaló milikasike Izesú nene iza amegesaló ahulimikasigo, ");
INSERT INTO gah_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","toki izámini amegesaló minoake novigo, vegená keza hepekumú luhoaká góini nene gololohá iake gapoló nene avilisá itimi vamó. ");
INSERT INTO gah_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Lá niago, Zelusalega ale alitoake, Olivi agokalotí lomo noi gapoló vo alí noligo, izegipala zuha mukilite kogoliza nivizeke alévolé suni aligo ánigakumú nene gakó napagutí Ómasi agepoka lake, ");
INSERT INTO gah_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","láa liki lamó: Guivahanímini gakotó agulizaki ve napa anitelimikane. Ómasímo nónohá zegetatize. Okulumakú nonagá oletino. Ómasímini mogonáa nene lapanalagi minino. ");
INSERT INTO gah_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Liki likago, vegená alegesá iki minakutí Palisaio monó ve makolite holúikú niake láa liki lamó: Gizapa ve geza izegipaka zuha imane láa liki lamilo loko lo hukoketamane. ");
INSERT INTO gah_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Liki likago, eza láa loko lo kimimó: Neza lo likimitoze, gililo. Keza gakó lamiki ha minatamó nene, gehani imanete gakó napagutí negepoka linigave, loko limó. ");
INSERT INTO gah_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Lá oake, omo anitike Zelusale apá nánigake, agika nohizigo ive napa ike, ");
INSERT INTO gah_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","láa loko limó: Lekeza nonagá iki minata gakó gili ahuliaká niamó nene itína gamena gili alitanazo. Lá onoimóza, mogonáa halá geneimó nenazo, lokogómulatunú ánigi vevesaminigave. ");
INSERT INTO gah_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Gamena makó lekelitoka noiko, gala velinite iki numutini apatini hizi vigiiki mikasi amumú iki geisa hiziiki, likilími vigiiki ");
INSERT INTO gah_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","vená izegipatinigi lekehelú iki likipili gesá inigave. Lá niiki numutini zivi akúvasivi niiki geha numuni nene ziki akúvasikiko gehani nene amupiló amupiló iki mililiki itekutí gululupaso asú inogo ive. Lekeza Ómasímo lukugutó vizinogo lekelitoka amómámini mogona gili vevesamamó nenazo, ámina suni lekelitoka utó oleketanogo ive. ");
INSERT INTO gah_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Loko Izesú loake, monó zagusaveú itike netá matá meina konaló vegená kimisele nahulake, ");
INSERT INTO gah_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","láa loko lo kimimó: Ómasímo li gakó nene monó gotolaú láa liki luhuva gizinamóma neve: Není numunimú Ómasiloka loaká numunive liki litave. Láa liki gizinamóza, lekeza guminaló veta halá giki miniaká nia geha mulí lilí ikave. ");
INSERT INTO gah_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Loko lo kemeake, gamena gamena monó zagusaveú nene monó gakó lainim-oketamó. Lá noigo, guguni giziaká ve napagi monó mogona apí-ikimiaká vegi itó Zuta vegenalitini monó gizapa vegi keza apili hilita gapováamú vitagá amóza, ");
INSERT INTO gah_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","vegená mukilite Izesú li gakó nene gámemé iki gili minikago, Izesuni apili hilita gapo ali utó amamó. ");
INSERT INTO gah_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Lá niago, nene gamenaló Izesú nene monó zagusaveú itike monó lainim-oketoko gakó lamaná lo utó oko lo nokimigo, guguni giziaká ve napagi monó mogona apí-ikimiaká vegi monó gizapa vegi iki anitiake, ");
INSERT INTO gah_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","imaneloka azozá loló ani netá nene éahini gakotó lá ane, itó éaho litó loló ape, lo lemezo. ");
INSERT INTO gah_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Liki loká imikago, eza láa loko lo kimimó: Nezagi ámina oko gakó hamó loká oleketanogo uze, lekeza li nimilo. ");
INSERT INTO gah_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Zoní monó nagamí holokimiaká hoza alimó nene, hikutí ale utó ive. Ómasímini gakotó alihe itó vegenalitini gakotó alive. ");
INSERT INTO gah_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Loko loká okimikago, kezáitoka ligili hagili ake nene gakotó nana oko lo viligoko lo amitune liki gelemó nene gopa okago, láa liki gelemó: Leza Ómasilokatí ale utó imole loko litunimó nene, íi, lekeza nanamú Zonini gakoláa gili alévolé amave loko linogo noimó. ");
INSERT INTO gah_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Itó vegená mukí nenete Zonikumú nene Ómasímini agepagutí gakó loaká veve liki linamóma nenazo, hoza alimó nene hanuva vetinigutí ale utó imole loko litunimó nene gehanitunú lipili hilinigave. ");
INSERT INTO gah_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Liki nigeleke Izesuni láa liki li amemó: Zoní éahitotí hoza ale utó ihe loko nenémini mogonáa gele vevesamune. ");
INSERT INTO gah_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Liki likago, Izesú láa loko lo kimimó: Láa likima nene netá matá imane loló oaká nougo ánigiaká niamó nene éahini gakotó lá oaká nouhe nenegi nezagi áminagó oko lo lekememinogo uve. ");
INSERT INTO gah_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Loko loake, anoza gakó makó nene Izesú láa loko vegená lo kimimó: Ve makolímo vain nagá mini nene zuhá oake, gizapa iki nitiko meinava likimitove loko vegená makó gutá kemeake, haitó mikasiloka hotó voko gamena hána minamó. ");
INSERT INTO gah_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Noigo gihila guzá lati gamena alitokago, gizapa nia vegená nenete mikutí nagá gihila lugáa alinitiki atave loko gelekelé izegipa makó amiselekago, vo anitekago, keza mini gizapa vemate ámina ve apiliake nagá gihila amemake hanuva amisilikago golohá veva noitoka vimó. ");
INSERT INTO gah_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Lá okago, gelekelé izegipala makó goha amiselekago vimó. Vo anitekago keza mini gizapa vemate gopoguka litake apiliake, hanuva amisilikago vimó. ");
INSERT INTO gah_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Lá okago, makóma amiselekago vimómámini agupe apilivi hukivi iake, hetoka alími ahulamó. ");
INSERT INTO gah_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Lá ikago, mini amelaho láa loko limó: Neza nana itove. Ma alími lamaná itahe loko nigika amenou gipáne amiselekugo vitize. ");
INSERT INTO gah_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Loko geleake, amiselekago voko áminaló anitekago, mitó gizapa vemate ánigiake kezáitoka láa liki ligili hagili amó: Imanémo nene mikasi amelahini gipala nenazo, áisi nene minokoko olopa ve molokoko imane hoza ale lá itimó nenazo, helisa henonima lelí loló itive loko mota apele hilitune. ");
INSERT INTO gah_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Liki liake, nagá gihila mikutí ahelú iliki vake losé apili helemó. Lá inamó nenazo, nagá mini amelaho aniteoko ámina mikú hozaló vema nene nana oketative. ");
INSERT INTO gah_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Áisi okoko gizapa vema kepele heleoko ámina vain mini nene haitó gizapa ve lamaná lehizeketanogo ive. Loko Izesú lokago, giliake, keza eé, lá oko nomive lamane. Liki likago, ");
INSERT INTO gah_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","geleake, gonú nokipilike láa loko lo kimimó: Láa likima monó gotolaú gakó láa liki luhuva gizinamóma nenémini mogonamú lekeza nanave liki nigeleve: Numuni giaká vete gehani napa makó ánigi ahulamó nenémo geha lapusa alévoleláa loló oake noive. ");
INSERT INTO gah_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ve makó nenete ámina geható velehé limitamó nene ziki nogotanigave. Itó ámina gehani nenémo ve makolímini amupiló alemó zitimó nene, ámina ve nene zeko lanahana inogo ive. ");
INSERT INTO gah_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Loko lokago, monó mogona apí-ikimiaká vegi guguni giziaká ve napagi keza ámina anoza gakokutí gehanimú limó nene Izesuni ánigo ahulunikumú lokave liki giliake, ámina gamenaló agizató alekinake nagá amitune liki lamóza, lá itunimó nene vegenalite nana ilitatave liki kehelele vizimó. ");
INSERT INTO gah_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Kehelele vizekago, Izesuni apilita gamenamú gizapa iki niake keikutí ve makó kimisilikago, vake amamaka miliki minake, Izesú gakó lo gopa itikumú amamaka moloko noinake gakó makó lokiko hee lamikoma agulizaki ve napámini agizakú molokuko nagá amitave liki vevesina vegitana lilí iki minake, ");
INSERT INTO gah_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Izesuni láa liki loká itamó: Tisalemaka, geza ve vená lainim-okimiaká noani gakó nene hee lokogó nego geleaká noune. Geza vegená mukí ánigo hamó lelegí oko ánigokanike, Ómasímini gapo kelepize vevesoaká noane. ");
INSERT INTO gah_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Geza nanave loko nogelene. Loma apatoka gamanímini agulizaki ve napa Sisani nene takisi moni ameaká nouhá nene etahe etamive. ");
INSERT INTO gah_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Liki lamó nene etamive loko lokikoma gamaniloka goní otatune itó vatí okove loko lokikoma Zuta vegenalite gili golesa itave liki amekú miliki la gakó nogilike, láa loko lo kimimó: ");
INSERT INTO gah_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Lekeza moni makó nelepizilo. Ámina moniló noi vogunahana imanegi itó luhuva imanegi éahini neve. Loko lokago, gamani ve napa Sisani neve. ");
INSERT INTO gah_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Liki likago, láa likima nene, gamanímo voká loaká noi netá nene gamani amilo, itó Ómasímo voká loaká noi netá nene Ómasi amilo. ");
INSERT INTO gah_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Loko Izesú limó nene gámemé iki linamómámini gelehusigutí lá oko avilegekago, sigaga liake kegepaló gena okago, vegenalitini kovogisaló agizató alemisá amó. ");
INSERT INTO gah_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Lá okago, Satukaio monó vegená keza hilinitakutí otisá amave liki liaká a vegená lugáate Izesutoka iake, ");
INSERT INTO gah_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","láa liki loká itamó: Tisalemaka, Mosé nene luhuva láa loko gizo lemeneimóma neve: Ve makolímo vená alitimó nene, izegipa getamoko mino-loko voko helekikoma, agunalámo ámina gevoná vená alekoko uvolaho hili vemú izegipala geto molative loko luhuva gizamó neve. ");
INSERT INTO gah_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Lá okanazo, uvolaho agunala 7-a minamó. Lá iki niake ganá ve nenémo vená aleake, minoloko novike izegipa getamike helekago, ");
INSERT INTO gah_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","agunala makolímo áminámini okago, ");
INSERT INTO gah_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","agunala makolímo áminámini okago, keza ve 7 nenete ámina vená ali volaló imaló iki minake izegipa getamake hili asú ikago, ");
INSERT INTO gah_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","ámina gevoná vená nene minake alika hilimó. ");
INSERT INTO gah_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ámina ve 7-a nenete ámina vená ali volaló imaló iki minamó nenazo, hilinitakutí goha otita gamena nene ámina vená nene éahini venala minative. ");
INSERT INTO gah_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Liki likago, Izesú láa loko lo kimimó: Lekeza imane gamenaló vená aliká itó vená alimi kimiká iaká niamóza, ");
INSERT INTO gah_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ómasímo vegená makokumú nene alika gamenaló hilinitakutí otitatímini mututoni niave loko loketonoimóma nenete vená alisá amave, itó vená alimi kimisá amave. ");
INSERT INTO gah_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Keza ageló nenéminiki goha hilisá amave. Hilinitakutí otita vegená nene Ómasímini mututoni miniki gosohá kemetamenigi minanigave. ");
INSERT INTO gah_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Itó heleakakutí oteakakumú nene lo likimitoze, gililo. Mosé ámina netakumú gakó makó lo lemeneimóma neve. Eza zamukutí ló guluma i gakó gizake hele vegenalitini mogonamú gilike Guivahanimú nene láa loko limóma neve: Eza Avalahani Isakani Zakoponi keí Ómasi minamó nominave. ");
INSERT INTO gah_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Loko limó nenazo, hele vegenaki ha nia vegenaki nene Ómasímini agómulaló nene ha nia vegenakó niave loko ánigo nominamó nenazo, nenemú kemeni helenei vegenalitini Ómasi negopa, kemenía hanuva ne vegenalitini Ómasi noinazo, Ómasimú gili zaginake hele vegenaki hanuva nia vegenaki keí Ómasi noive. ");
INSERT INTO gah_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Loko lokago, monó mogona apí-ikimiaká ve lugáate tisalemaka, gakó lamaná lokane. ");
INSERT INTO gah_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Liki liake, goha gámemé iki loká itakumú kehelele vizekago, loká itamisá amó. ");
INSERT INTO gah_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Lá niago, eza láa loko lo kimimó: Gologí oleketative loko lo mololeketa vemámo agulizaki ve napa Tevitini agávolaho noive liki nanamú liaká niave. ");
INSERT INTO gah_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Tevití eza Ómasi agepoka liká nama liká a gakokutí láa loko luhuva gizonoimóma neve: Mezaú ve eza není Guivahaníne nene není nigizani zamagaloka minoloko voko noako, ");
INSERT INTO gah_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","gala vega nene gigisa lapuvauka ahuloketanogo uve loko lo amimó neve. ");
INSERT INTO gah_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Tevití ámina vemú nene Guivahaníneve lokamó nenazo, gologí oleketative loko lo mololeketa vemámo nana igo Tevitini agávolahogó neitive. Tevitini guivahanigi neitive. ");
INSERT INTO gah_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Loko Izesú loake, vegená mukilite nigelego, izegipala zuha láa loko lo kimimó: ");
INSERT INTO gah_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Monó mogona apí-ikimiaká vemú lekeza, ehe. Keza nene luhiaká gó hána luhatakumú, itó maketiloka vegená makolite geké vaké likitatakumú, itó monó numukú numukú vegená kovogisaló minoaká holomaló minatakumú, itó nosánetá napa ninató agepaló iti mina siató minatakumú kumu heleaká noive. ");
INSERT INTO gah_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Keza gevoná venalitini henokanoni gumina i asú iká itó kegepatunú soza miliki Ómasi agepoka hána liki Ómasiloka liká iaká niave. Ámina ve nenete lihima napa genavagi alinigave, loko limó. ");
INSERT INTO gah_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Izesú nene monó zagusaveú minake okenava oko ánigamó nene henóiki vegenalite moni moloaká pokisigú moni nimilago ánigamó. ");
INSERT INTO gah_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Lá noigo, gohogó vená gevoná makolímo golohá moni lositá nene áminagú nomolago, ánigoake, ");
INSERT INTO gah_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","izegipala zuha láa loko lo kimimó: Neza lamaná lo likimitoze, gililo. ");
INSERT INTO gah_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Vegená imanete vaí o mina monigutí ahulamóza, vená gevoná imanémo gohogó noikutí nosá meina hizitimoláa ahulo asú okamó nenazo, áisi moni ahulamó nenémo keza moni ahulamó kivilegekamó gelekave, loko limó. ");
INSERT INTO gah_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Izegipala zuha makó nenete monó zagusave nánigake gehani lamanaláatunú ginamó itó gonanalisi lamanaláa áminaló minamó nene ánigiake sigaga nilago, Izesú láa loko lo kimimó: ");
INSERT INTO gah_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Lekeza imane netá itína nánigamó nene alika gamena atitó nene lova ve makolite imaneló gehani mukí apiliki tele vizikiko, gehani nene amupiló amupiló iki mililiki itekutí gululupa so asú inogo ive. ");
INSERT INTO gah_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Loko lokago, keza loká itiki monó gizapa velemaka, itína lani netá nene nanahé gamena utó itive, itó nana anosa utó okiko ánigokinake lani netá nene mota alévolé inogo ive loko litune. ");
INSERT INTO gah_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Liki likago, eza láa loko limó: Ehe, lokogoka vizitakumú gizapa ilo. Vegená mukilite nanitiki nugulizató liki okulumakutí lumu ve gihila nezama nouve nilikoma, itó gamena mota ávatiha okave nilikoma, kémegetiki vamilo. ");
INSERT INTO gah_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Itó mikasi makotokatí lova napa hiziki niiko, itó holutikutí lova utó noiko, lekehelele vizemino. Nenémini suni nene goí oko utó itive loko lonoimóza, mukí netá matá litá oko asú aminogo ive. ");
INSERT INTO gah_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Loko loake, miní amike láa loko lo kimimó: Numutó namató ve mukí nenete gala venini lova ali nikimiko, agulizaki ve makolímini zuhagi makolímini zuhagi lova hizinigave. ");
INSERT INTO gah_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Itó mukí mikasiuka imimá napa noiko haitopaitó mikasiuka gaúna gamena napa utó oko minoloko noitiko, itó vegená mukí kivise asú iti netá napa utó noiko, okulumató mulutini pou liti netaki utó noiko, anosa napa napa makó utó inogo ive. ");
INSERT INTO gah_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Lá itimóza, ámina suni utó onamiko likigizató aliiki gopoguni mililikitiiki monó numukuki nagá numukuki goní ilikitatave. Lá niiki není nugulizá lekelitoka minakumule liki likigizató aliki kugulizaki ve napatini itó kiapegini kovogisaló likilími milikiko, ");
INSERT INTO gah_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","lekeza není mogonamú gili alévolé inamó nenémini gakoláa li utó iki li kimitave. ");
INSERT INTO gah_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Nenemú itína lakagata gili nivevesiki láa liki li hukalo: Goní nilikitikoma nila gakotó nanave loko lo kimitupe liki goí iki lakagata gululusi gelemilo. ");
INSERT INTO gah_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Nénisi lekegepa ale vávani okinake gakó loakatini lekemekugo litamó nenazo, gala velinite ma lekehelú aminigave. ");
INSERT INTO gah_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Izotike ametike uvotike lekelí zuhagutí makolite likigivetike kezagi likigizató aliiki goní ilikimikiko, lekelikutí makó lugáa likipili hilitave. ");
INSERT INTO gah_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Lá niiki není nugulizá lekelitoka minakumule liki vegená mukilite mukahá likipilitamóza, ");
INSERT INTO gah_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","likigika makó gopa aminogo ive. Avasavagi hanuva minanogo ive. ");
INSERT INTO gah_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Lá itimó nenazo, lekeza alévolé iki oti minatamó nene, alévolé lekemetamenigi minanigave. ");
INSERT INTO gah_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Lá iki niiki, Zelusale apatoka lova vetini gimisigi vete iki hizi vego niikoma, lekeza nene netá matá otuhá apatekiko, gámé loló iti gamena alitokave liki gililo. ");
INSERT INTO gah_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Lá niiki nene Zutaia mikasigú nita vegená nene agokaló golisi nitiko, Zelusalega vegená nene, ámina apá nahuliko, Zelusale numutoka gahevaloka nia vegená nene nenegú iteminigave. ");
INSERT INTO gah_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ámina gamenaló nene netá golesáinímini lihimaváini kimiti gamena nenazo, monó gotolaú luhuva gizinamóma utó oko alévolé o asú inogo ive. ");
INSERT INTO gah_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Kee, izegipa kagatupagi nita venaki izegipa namuni aminí nikimita venaki, ámina gamenaló nene nana itamó neve. Imane mikasiuka genavagi netá utó okiko, Ómasímini izapaló molati netá nenémo imane mikasiuka vegená hize viginogo ive. ");
INSERT INTO gah_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Lá okiko, lugáa sopolotunú likipili hiliiki lugáa nene nagá likimiiki numutó namató likilími milikiko, hetoka vete nene Zelusale apá lisiki nogotiki miniliki viki niiko, hetoka vegenalitini gamenaváini lutiginogo ive. ");
INSERT INTO gah_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Okulumató ho sonohí ikani nenémo haitopaitó avevezaha noiko, age nagamí valahuká zeko sasa loko noiko mikasiuka vegená mukí keza anó nigiliki ininá niiki mulúini pou noliko, ");
INSERT INTO gah_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","okulumató amuzavagi netá mukí nene mómoká i asú iki haitó suni alitamó nenazo, lá itakumú kehelele vizititímo kovonana noviziko, mikasiuka alévolé suni utó inogo noitímo mulutini itinogo ive. ");
INSERT INTO gah_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Lá okiko, okulumakutí lumu ve gihila neza zámuzánegi itó lapanánegi nene límusi amupiló nolumugo ániganigave. ");
INSERT INTO gah_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Nenemú ámina suni utó noiko, lekeza oti hee liiki okenava iki ánigiiki, gologí oletati gamena nene mota alitokave liki gililo. ");
INSERT INTO gah_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Loko Izesú loake, anoza gakó makó láa loko lo kimimó: Gohuna zahe za makó ahe ánigiiki gililo. ");
INSERT INTO gah_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Za agila nene guluma sekago lekeza ánigiake hogaí gamena mota alitokave liki giliaká niave. ");
INSERT INTO gah_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ámináminoko nolu suni utó noiko Ómasímo gizapa oleketati gamena mota alitokave liki gilinigave. ");
INSERT INTO gah_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Neza lamaná lo likimitoze, gililo. Imane gamenaló nia vegená velesá hili asú inamiko imane nolu netá mukí utó inogo ive. ");
INSERT INTO gah_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Okulumaki mikasigi tolova itáiha, není gakó nene, ma gopa oko tolova aminogo ive. ");
INSERT INTO gah_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Ehe, lekeza lekemeni gizapa lamaná ilo. Negi nagi hizeaká sunímo itó negi nagamí vauva aleko noaká sunímo itó lakagata gululusi geleaká nenémo gena likivisekiko, gamena napa lekelitoka galinali utó olimikatize. ");
INSERT INTO gah_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ámina gamena napa nenémo gelehusigú nenéminoko imane mikasiuka numutó namató vegená mukí likipilinogo ive. ");
INSERT INTO gah_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Lekeza Ómasímo amuza lekemekiko ámina utó iti netá olové noinake okulumakutí lumu ve gihila není novogisaló ote minatune liki Ómasiloka liki gizapa iliki viki minalo. ");
INSERT INTO gah_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Loko Izesú lo kemeake, gamena gamena nene monó numuni napagú gakó lo kemeake, holugú nene ámina apá ahuloake, zopega makó agulizá Olivi agoka nenegú iteko akoaká imó. ");
INSERT INTO gah_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Lá noigo, vegená mukí nenete neteká holugú ake monó zavusavegú nene Izesutokatí gakó gilinigi alegesá iaká amó. ");
INSERT INTO gah_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Lulu vizemi peleti niaká a holisi agulizá napa nene avóikini asenini zeketakumú gili mina holisi nene alitokago, ");
INSERT INTO gah_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","guguni giziaká ve napagi monó mogona apí-ikimiaká vegi keza vegená mukikumú kehelele vizekago, Izesuni apili hilinigi gapováamú hanuva gizapa iki minamó. ");
INSERT INTO gah_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Lá niago, Satá nene Izesuni vegenala zuha 12 keikutí Kaliotó numutotí ve Zutani mulunagú lemeake alémo vávani igo, ");
INSERT INTO gah_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","eza vike guguni giziaká ve napagi itó monó zavusavegú pilisí vegi gakó akó lake, Izesuni amimika loko keitoka alémoko atitímini gakola ligili hagili amó. ");
INSERT INTO gah_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Lá niake, keza kogoliza vizeke hutono gehani nene Zutani amitune liki li hutamó. ");
INSERT INTO gah_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Li hutikago, Zutá nene konotó aleko mukí vegená alegesá inamiko keitoka amimika linogo amapani molamó. ");
INSERT INTO gah_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Lulu vizemi peleti niaká a gamena asenini zeketakumú gele minoaká holisimule liki sipsip iza akaleva apiliaká a gamenama alitokago, ");
INSERT INTO gah_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Izesú nene izegipala zuhagutí lositá nene Zonímagi Pitámagi nokimisilike láa loko limó: Lekeza viki asenini zekimiaká nosá ali vavá ikisiko leza natune. ");
INSERT INTO gah_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Loko lo kemekago, keza nosánetá hikú ale vavá onetatíive loko nolane. ");
INSERT INTO gah_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Liki likasigo, Izesú láa loko lo kimimó: Gililizo. Lekeza nene taoniloka viki nanitisiko ve makolímo paisele somo nagamilagi geheneiko, gapoló hotu nilikima ámina ve ámegetiki viiki eza ititi numukú nene itilizo. ");
INSERT INTO gah_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Itiiki numuni amelahini láa liki li amilizo: Tisalémo nezagi izegipáne zuhagi avotegini asenini zeketakumú gele minoaká nosá natuni numuni agika nene hiláauka neve liki loká ilizo loko lokago lo nogumusive. ");
INSERT INTO gah_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Liki likisiko, numuni agika veletó nego netá matá avilisá ohá lekelepizitive. Neneló nosánetate ali vavá ilizo. ");
INSERT INTO gah_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Loko lo kemekago, vasike ánigasimó nene, lo kimimómáminoko nego ánigikasike, asenini zekimiaká nosánetáma ali vavá asimó. ");
INSERT INTO gah_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Lá ikasigo, nosánetá nata gamena alitokago, Izesúma aposologegi minake nosánetá niki minamó. ");
INSERT INTO gah_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Lá iki niake Izesú láa loko lo kimimó: Imane asenini zeketakumú gele minoaká nosá nene miluma velesá gelenaminake lekezagi natune loko mulúnegú lamaná geleloko voko minumó neve. ");
INSERT INTO gah_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Lá onoimóza, makó lo likimitoze, gili minalo. Nosánetá imane goha naminake minoloko voko Ómasímo gizapa oleketatitímini gapováa utó okiko nanogo uve. ");
INSERT INTO gah_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Loko loake, vain goni makó aleake, Ómasi agepoka loake láa loko limó: Lekeza imane gona miliki nalo. ");
INSERT INTO gah_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Gakó makó lo likimitoze. Imane gamenalotí veletó nene vain nagalímini gihilagutí goha naminake, minoloko vinake Ómasímo nugulizaki vetipo loló onetati gamena utó okiko natove. ");
INSERT INTO gah_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","20","Loko loake, peleti makó aleake, Ómasi agepoka loake gitegeko gona moloko nokimike láa loko limó: Imane není mémeláne neve. ");
INSERT INTO gah_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Lá onoimóza, ánigalo. Není nimimika liti vegi holoma hamotó minusike, ligizani ahuloko nosánetá aleko noko nousive. ");
INSERT INTO gah_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Okulumakutí lumu ve gihila neza vozo loko loneta gapoloka hilito gapogú novumóza, není nimimika liti vema nene agae, lihima genavagi alinogo ive. ");
INSERT INTO gah_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Loko lokago, izegipala zuha keza éaho lá itikumú nolihe liki liake kezáitoka lokatoká amó. ");
INSERT INTO gah_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Lá iake, izegipala zuhamate lelikutí éaho agulizaki ve loló itive liki lova sava amó. ");
INSERT INTO gah_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Lá ikago, Izesú láa loko lo kimimó: Mikasiuka hanuva vegenalite gelekelé ikimiake kagahisiuka limitigí iki niago kugulizaki véinite alévolekutí gizapa ikimiaká niave. Itó kugulizaki vete legepoka litave liki liaká niamóza, ");
INSERT INTO gah_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","lekelitoka nene lá oko minamino. Lekelitokatí itiki minamoláate nene limiki mina vegená nenéminiki minataze. Itó lekelí gizapa ve nenete hanuva lemetigí iki gelekelé ve nenéminiki minataze. ");
INSERT INTO gah_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Lekelisi lilo. Éaho agulizaki ve noive. Nosánetá hanuva minoko natimó nenémohe, itó nosánetá vatá oko ale vavá otati ve nenémo agulizaki ve noihe. Hanuva minoko natimó nenémo agulizaki ve noitimóza, nénisi nene lekelí holutikú nene agulizaki ve suni alemoko gelekelé izegipagitana loló oko minoaká nouve. ");
INSERT INTO gah_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Lekeza nene gasova netalímini agikagú nougo lekeza áminagú nilími vatí iki miniaká niave. ");
INSERT INTO gah_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Améneho vegená mukí gizapa oketatane loko lonetamó áminámini oko neza hoza gakó nololeketuve. ");
INSERT INTO gah_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Lekeza gizapa okimiaká noutó miniki nosánetá niki lokogoliza vizitave loko itó gonanalivagi siató miniki Isilae vegenalitini mulusi 12 gizapa ikitiki gona milikitanigave loko nololeketuve. ");
INSERT INTO gah_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Saimon, Saimon, laisi lotuva lake gizaká iki alími etó iaká niamómáminoko Satá nene lekeza aí agizakú hilikiko gizaká oko lekelémo etó inogo lonoimóza, ");
INSERT INTO gah_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","nénisi nene gele alévolé animó nene gologolo samitive loko Ómasiloka loaká nouve. Lá onoumó nenazo, geza monó gapoló goha atiginá oko voko minokoko, gigivekagini hize lé oketozo. ");
INSERT INTO gah_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Loko lo amekago, Pitá láa loko lo amimó: Guivahanínemaka, geza kalapusi numukupe itó gipili hilinitamope nezagi áminagú vinogo uve. ");
INSERT INTO gah_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Loko lokago, Izesú láa loko lo amimó: Pitaga neza lo gimitoze, gelezo. Itína holugú nene okoloho nenémo velesá anó molonamiko geza nenikumú ánigonamuve loko egamega onetatanimó gamena losive makole inogo ive. ");
INSERT INTO gah_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Loko loake, láa loko lo kimimó: Goí oko nolikimisuluke, moni gúeaká gó itó akiseaká gó itó likigisaló suú aliki vamilo loko lo lukumu gamenaló nene nivake netá makokumú vitagá amó nehe. Loko lokago, keza óve liki likago, ");
INSERT INTO gah_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","eza láa loko lo kimimó: Lá ikamóza, itína gamenaló moni gúeaká gó ahe akiseaká gó ahe ale neiti vemámo aleko vitive. Itó sopolo hána alenamiti vémo nene hepé golalotí moni alekoko sopolo hána meina hizitive. ");
INSERT INTO gah_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Neza lamaná lo nolukumuve. Monó gotolaú gakó makó láa liki luhuva gizinamó nene nenitoka utó inogo noive: Netá golesa aliaká nia vetini kigivéipo noive liki aiki gatamó. Itó monó gotolaú luhuva mukí nenikumú gizinamó nene nenitoka utó oko alévolé noive. ");
INSERT INTO gah_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Loko lokago, keza nene Guivahanitemaka, ánigozo. Sopolo hána losi imane neve. Liki likago, eza není gakó gelemaze, áminasile loko lo kimimó. ");
INSERT INTO gah_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Nenetí hetoka lemeake vike, eza goí oko aleaká imómámini oko alinogo Olivi agokaú noitigo, izegipala zuhamate ámegetiki vamó. ");
INSERT INTO gah_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Olivi agokaloka vo alí nolike izegipala zuha láa loko lo kimimó: Lekeza imaneló miniki lekemekú milatakumú gopa okatune liki Ómasiloka liki minalo. ");
INSERT INTO gah_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Loko ahulokimiake, alitóisí minomo novike, alapusa nohizike Ómasiloka láa loko limó: ");
INSERT INTO gah_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Aménega, geza lá itove loko gelekokoma genavagi gihinitata netá imane nenitokatí ale olové itane loko nogulumóza, není nigikaloka molamoko geí gigikaloka molatane loko noluve. ");
INSERT INTO gah_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Loko noligo, okulumakutí ageló makó limike utó o amike hize lé otamó. ");
INSERT INTO gah_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Lá okago, miluma alévolé oko nogilike, amuza moloko Ómasiloka noligo, govisi apilimó nene golani nenéminoko mikasiuka aleloko limimó. ");
INSERT INTO gah_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Lá noigo, Ómasiloka loko minatotí oteake, izegipala zuha niató goha oake, netá golesa utó itikumú miluma giliki kovó akinago oko ánigoake, ");
INSERT INTO gah_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","kelémo oteake láa loko lo kimimó: Lekeza nanamú lokovó akinave. Lekeza otiiki lekemekú milatakumú gopa okatune liki Ómasiloka liki minalo. ");
INSERT INTO gah_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Loko lo kemeko noigo, Izesuni vegenala zuhagutí ve makó Zutá áisi nene goí o kimigo vegená mukí iki Izesutoka iki alegesá amó. Lá ikago Zutá nene Izesuni agoka agepa legeko nanogo noitoka omo alí noligo, ");
INSERT INTO gah_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Izesú láa loko lo amimó: Zutazo, geza okulumakutí lumu ve gihila není nogoka negepa legeko nanogo nimimika linogo noape. ");
INSERT INTO gah_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Loko lokago, Izesuni amatoka mina vete nene utó inogo i netá nánigake Guivahanitemaka, sopolotunú kipilitupe. ");
INSERT INTO gah_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Liki nilake, keikutí ve makolímo nene guguni gizoaká ve napámini gelekelé izegipala nene sopolotunú apilike agata zamagaloka zeko isimó. ");
INSERT INTO gah_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Lá okago, Izesú nenémini suni alemo loake, agizani lutoko ámina vemámini agataló ale nogilike agata alémo lamaná otamó. ");
INSERT INTO gah_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Alémo lamaná omiake, guguni giziaká ve napagi monó zavusavegú pilisí vegi monó gizapa vegi Izesuni agizató alitune liki a vema láa loko lo kimimó: Lekeza nenikumú gelemó nene laskoli nougo sopolo hánagi gelekahosigi aliki niake nigizató alinigi niahe. ");
INSERT INTO gah_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Gamena gamena lekezagi monó zavusave napagú minoaká umó nene, nigizató alisá amamó neve. Lá ikamóza, itína nene lekelí gamena nego, límugusi amelahini Satani amuza netá mota utó okave. ");
INSERT INTO gah_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Loko lokago, Izesuni agizató aliake, alímiki vake guguni giziaká vetini gizapa vémini numukú alímiki itemó. Lá niago, Pitá nene hotó otigí oko kémegetoko novigo, ");
INSERT INTO gah_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","ámina numukú hé numunaló holutó nene ló giziake minamó. Lá iki niago, Pitá kezagi makó minamó. ");
INSERT INTO gah_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Eza ló hanatolaloka ló lotá oko noigo, gelekelé vená makolímo ánigoake, gonukonú napilike imane ve nene Izesuki miniaká asi ve noive. ");
INSERT INTO gah_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Loko lokago, eza egamega ike venáage, neza ánigonamu vemú nolane. ");
INSERT INTO gah_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Loko lokago, koma noigo, ve makolímo Pitani ánigoake geza nene ámina vémini zuhagutí noane. Loko lokago, Pitá nene vémage, neza noamuve. ");
INSERT INTO gah_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Loko lokago, gamena koma novigo, ve makó nenémo pigi vizeko ezagi Galilaia anoki ve noinazo, lamaná ezagi makó minasimó neitive. ");
INSERT INTO gah_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Loko lokago, Pitá nene vémage, geza nolani gakoka ma gelemu gakó nolane. Loko noli agepagi okolohomámo anó molamó. ");
INSERT INTO gah_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Anó molokago, Guivahanímo mino viligake avogisa o amike Pitani ánigamó. Ánigokago, Pitá eza Guivahinímo amunaló lota gakó nene itína okoloho nenémo anó molonamiko egamega onetatanimó nene gamena losive makole inogo ive loko lo ami gakóma goha nogilike, ");
INSERT INTO gah_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","agika hizekago, lemeko hetoka ive napa imó. ");
INSERT INTO gah_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Lá okago, Izesuni agizató ali mina vete gopoguka nilitake kigizanitunú napeleke, ");
INSERT INTO gah_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","agómulaló lavolavo gotunú zi hitimiake láa liki lamó: Geza lo utó oko lo lemezo. Éaho nogipilive. ");
INSERT INTO gah_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Liki liake, alivi letivi iki haitopaitó gakó litiki minamó. ");
INSERT INTO gah_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Niago, neteká gó lokago, Isilae mikasiuka gizapa ve keza guguni giziaká ve napagi monó mogona apí-ikimiaká vegi alegesá iake, monó kansoletini niatoka Izesuni alímiki viake ");
INSERT INTO gah_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","geza gologí oletative loko lo mololeta vema nookoma lo lemezo. Liki likago, eza láa loko lo kimimó: Neza lo likimitomó nene lekeza gili alévolé aminigave. ");
INSERT INTO gah_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Itó áminamú loká oleketatomó nene lekeza nonotó aliki li nememinigave. ");
INSERT INTO gah_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Lá onoimóza, imane gamenalotí veletó nene okulumakutí lumu ve gihila neza amuza ve Ómasímini agizani lamagaloka minanogo uve. ");
INSERT INTO gah_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Loko lokago, keza li amiki nilake láa lokoma geza Ómasímini gipala nouve loko nolape, olo. Liki likago, eza lá onoive liki lekezatini mota likave. ");
INSERT INTO gah_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Loko lo kemekago, keza láa liki lamó: Aí gakola gilina vegená makó nanamú sele lokinake gakó makó gilitune. Aí agepagutí láa loko lokago mota gelekunimóma neve, liki lamó. ");
INSERT INTO gah_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Láa liki liake, keza mukitó otiake Izesuni alímiki Pilató noitoka vamó. ");
INSERT INTO gah_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Alímiki viake, apí iki goní itake láa liki lamó: Imane vémo leza Zuta vegená lelémo gopa oaká noike, takisi moni nene Loma vegenalitini gamani agulizaki ve napa Sisani amemilo loko loake, ezáamú nene nugulizaki ve napa gologí oleketatove loko lo mololeketa vema nouve loko loaká noive. ");
INSERT INTO gah_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Liki likago, Pilató eza Izesuni loká otake geza nene Zuta vetini kugulizaki ve napáini noape. Loko loká omikago, Izesú nene gezaka lokanimole. ");
INSERT INTO gah_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Loko lokago, Pilató nene guguni giziaká ve napamagi mukí vegenámagi láa loko lo kimimó: Neza imane vémini lihimavalamú vitagá umó nomive. ");
INSERT INTO gah_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Loko lokago, keza pigi vizeke láa liki lamó: Eza mukí vegená kelémo otopá zemo novike Galilaia mikasiuka apí oake, Zutaia mikasiuka vo asú okoko gakó lainim-oketomo novike imaneló omo anitekave. ");
INSERT INTO gah_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Liki likago, Pilató nene gakóini geleake, imane ve nene Galilaia mikasiuka ve noihe. ");
INSERT INTO gah_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Loko loká okimiake, Izesúma Heloté gizapa onoi mikasiukatí ve noigo geleake, itó Heloté nene ámina gamenaló Zelusalega minamó nenazo, Izesuni nene Heloté noitoka alímiki vilo loko amiselekago, alímiki vamó. ");
INSERT INTO gah_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Lá ikago, Heloté nene Izesuni gakó gozapá geleko minamó nenazo, Izesú nene avevezaha makó okiko ánigatonazo loko agata gelekelé oko noitotí nene Izesuni ánigoake agoliza goha vizimó. ");
INSERT INTO gah_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Lá oko noike nene, Heloté nene Izesú oko moloko i netá mukikumú loká otamóza, Izesú nene Heloté li gakotó ma anotó aleko lo amemimó. ");
INSERT INTO gah_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Lá noigo, guguni giziaká ve napamagi itó monó mogona apí-ikimiaká vemagi keza aí amatoka otinake amuza miliki goní itamó. ");
INSERT INTO gah_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Lá ikago, eza ve golesa noigogitana Helotege itó gimisigi véate gopoguka litamó. Gopoguka limiake, agulizaki ve napámini luhoaká gó lamanaláa luhimiake, Heloté nene Pilató noitoka goha amiselekago vimó. ");
INSERT INTO gah_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Lá okago, Heloteko Pilatoko keza nene gozapá gala ve lilí iki minasimóza, nenelotí goha zogo milasimó. ");
INSERT INTO gah_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Lá ikasike, Pilató nene ve vená mukí itó guguni giziaká ve napagi monó gizapa vegi kelémo nupa oake, ");
INSERT INTO gah_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","láa loko lo kimimó: Lekeza imane ve nenitoka alímiki iake, vegená kelémo otopá zeaká noive liki lamóza, lekelí lokovogisaló aí mogonamú vitagá umó nene, gililo. Lekeza netá matá golesa alikumú goní notune liki lamóza, neza nene vitagá umó ma ale utó amuve. ");
INSERT INTO gah_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Heloteki eza ámina oko lihimavamú vitagá imó nene nomigo lelitoka amiselekago okave. Lá onoize, gililo. Eza nene netá golesa makó alilina, apele hulutilinamóza, lá oko nomimó nenazo, ");
INSERT INTO gah_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","neza lokugo uheni nagasunitunú apiliiki amisilikiko hanuva vitive. Loko lokago, ");
INSERT INTO gah_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","keza ganaganagó gamoga giki láa liki lamó: Imane ve nene agoka legesó itize. Palapasini nene gologí omikako lelitoka ino. ");
INSERT INTO gah_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Liki lamó nene Palapasí nene Zelusale apakuka gamaniloka lova gizoko kipili vémo lova hizeko ve makó apele helekago, nagá numukú ahulikago mina vemú lamó. ");
INSERT INTO gah_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Lá noigo, Pilató nene Izesuni gologí otatove loko geleake, gakó goha lo kimimóza, ");
INSERT INTO gah_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","keza pigi viziki malipo zaló hilitikumule, zohota zaló hilitikumule. ");
INSERT INTO gah_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Liki likago, Pilató goha láa loko lo kimimó: Nanamú. Nana netá golesa alekago nilave. Aí apele hilituni mogona makó ale utó amuve. Lá onoinazo, neza lokugo, uheni nogosanitunú apiliiki amisilikiko hanuva vitive. ");
INSERT INTO gah_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Loko lokago, keza Pilató li gakó zivi hitivi ake pigi viziki gakó napagutí zohota zaló nagá otamane liki la gakolímo Pilatoni gakó alémo amunauka imó. ");
INSERT INTO gah_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Lá ikago, Pilató nene keza negénegeka liki lakumú keí gakó lá itove loko lo hutamó. ");
INSERT INTO gah_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Lo hukoake, amunaló emane gamaniloka lova gizake lova ale utó oko ve makó apele heleake nagá numukú mina vemú gologí otative liki loká ita vema nene gologí omiake, Izesuni nene kezáini kagata gele netá lilí itave loko gimisigi vetini kigizakú kimimó. ");
INSERT INTO gah_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Lá okago, Izesuni nene apilinigi alímiki nivago ve makó agulizá Saimon eza Apilika mikasiuka Sailini apatotí ve nene minaukatí taoniloka novike gapoló noigo ánigiake, agizató aliake zohota zama gihimikago, agínagú geheake Izesuni ámegetoko vimó. ");
INSERT INTO gah_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Lá iki nivago, mukí ve vená kémegetiki nivake, vená nenete miluma gilitake ive nama itimi vamó. ");
INSERT INTO gah_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Lá iki nivago, Izesú nene mino viligoake láa loko lo kimimó: Lekeza Zelusale venáise, nenikumú ive amiki lekezatinimú itó lekezatini izegipatinimú ive ilo. ");
INSERT INTO gah_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Gamena makó alitonoimó nene utó okiko láa liki litaze: Izegipa getinama vená itó izegipa nene aminí kiminama vená keza gohuna vená nene vatí iki minikave. ");
INSERT INTO gah_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Liki liiki ámina gamenaló nene agoka napamú nene agae, agoka vozaneka, zeko akutooko oko hitoletatapo, liki linigave. Itó agoka komamú iki zi hitilitalo liki linigave. ");
INSERT INTO gah_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Loko loake, láa loko lo kimimó: Neza gosohá lokitana noumóza, není nene hanuva lokú gizatamó nenazo, lekeza osagava lokitana vegená nene nana ilikitatave. ");
INSERT INTO gah_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Loko lokago, netá golesa aliaká asi ve losigi Izesunigi kipili hilinigi kilímiki vamó. ");
INSERT INTO gah_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Kilímiki vake, apá makó agulizá gotóini gonosi helisa apale liki latoka anitiake, neneló Izesuni nene zohota zaló apiliki apatiake, netá golesa aliaká asi ve losima makó nene agizani sogaloka hizeke itó makó nene agizani lamagaloka apiliki apatemó. ");
INSERT INTO gah_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Lá ikago, Izesú nene aménega, gili vevesamake gopa netá nalemó nenazo, geza lihimáini ahuloketozo, loko limó. Loko lokago, keza nene Izesuni luhoaká gola nene éaho alitihe éaho alitihe liki satu zohí amó. ");
INSERT INTO gah_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Lá noigo, vegená mukí alegesá iki ánigi minamó. Lá niago, Zuta vetini gizapa ve nenete gopoguka litake láa liki lamó: Vegená kugutó vizeaká i vema eza Ómasímo alémo etó onoi ve nene gologí oleketative loko lo mololeketa vema nouve loko loaká i vema nenazo, ezáa agutó vizino. ");
INSERT INTO gah_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Liki liake, gimisigi ve nenetegi gopoguka nilitake ekesá vain nagamí natihe liki agokaú miliake, ");
INSERT INTO gah_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","geza Zuta vetini kugulizaki ve nookoma, gezaka gugutó vizezo. ");
INSERT INTO gah_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Liki li namego, velé gotolaloka luhuva makó nene imane ve nene Zuta vetini kugulizaki veninive liki gizikago minamó. ");
INSERT INTO gah_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Lá onoigo, netá golesa aliaká asi vegutí magáámo láa loko Izesuni alevo letovo oko limó: Geza gologí oletative loko lo mololeta vema noitanimó nene, gezaka gugutó novizeko lezagi lugutó vizemane. ");
INSERT INTO gah_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Loko lokago, maga véa nenémo gahá amike láa loko lo amimó: Ezagi lezagi goní nilitake, hilitave liki lilitinamóma nenazo, nohelenike geza Ómasimú gehelele vizemihe. ");
INSERT INTO gah_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Loko loake, leza nene lihimatemaló apasiki lipili nihelemó nene vevesonoimóza, imane ve nene lihimavala nomi ve hakupá netá aliki apili niheleve. ");
INSERT INTO gah_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Loko loake, Izesuni láa loko lo amimó: Izesuvo geza gugulizaki ve loló ooko gizapa okimiaká hoza alitani zupa nene nenikumú gele minatane loko noluve. ");
INSERT INTO gah_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Loko lokago, Izesú láa loko lo amimó: Neza lamaná lo gimitoze, gelezo. Itína nene Palatisi zazuha apakú gezagi apizeko minanogo usive. ");
INSERT INTO gah_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Loko noligo, holisaka gamena nene hómini silikakéna gopa noike mukí mikasiuka nene límugusi ze asú oake mino-loko novigo únaká ho ale zohota imó. ");
INSERT INTO gah_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Lá noigo, monó zavusavémini gatetó Ómasímini avogisaló iteaká gatetó zi lí ika lavolavo nene zeko hoú lo losi imó nene lelí gahe ale koló imó. ");
INSERT INTO gah_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Lá noigo, Izesú nene gakó napagutí nolike aménega, není nemeni nene geí gigizakú nomuluve. Loko loake, ahuu lo nahulake hilimó. ");
INSERT INTO gah_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Lá noigo, lovámini gala vevatini gizapa vemámo utó i netáma ánigoake, Ómasímini agulizá ale otike lamaná imane ve nene hee loko noi ve minamó neve. ");
INSERT INTO gah_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Loko lokago, ámina suni ániganigi alegesá ina vegená nenete ánigiake, miluma napa giliake, kolómusaló zimi zimi atiginá iki numúitoka vamó. ");
INSERT INTO gah_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Lá niago, aí agivelagegi itó Galilaia mikasigutí ámegetiki a venaki keza nene hotó otigí iki otinake ámina suni ánigamó. ");
INSERT INTO gah_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Lá ikago, ve makó minamó, agulizá Zosehé. Áisi nene Zutaia apá makó agulizá Alimataia loko noi numutó ve minamó. Eza ve lamaná itó veveso mina ve Zuta vetini monó kansole ve makó minamó. ");
INSERT INTO gah_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Lá imóza, kansole lugáate Izesuni apilitune liki kagata giliake lova gizi hukakumú nene gele kememi ve nenémo Ómasímo gizapa okimiaká ve alémo utó iti gamenamú gizapa oko mina ve minamó. ");
INSERT INTO gah_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Áisi nene Izesuni gonosiva alinogo Pilató noitoka vike loká omikago, gele amekago, ");
INSERT INTO gah_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","zalotí apasoko aleko lemeake, gizopa gó lamanakú asapú omiake, aleko voko meikú geha mulí goló vatinakú nenegú ve vená makó gale zikitinamakú gale zetamó. ");
INSERT INTO gah_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Palaitegú gale zetamó, avóikini asenini zeketakumú gili mina holisi gamena alí noligo nene. ");
INSERT INTO gah_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Lá noigo, Galilaia mikasigutí Izesuni ámegetiki a vená nenete Izesuni gonosiváa nana oko gale zetatihe liki ániganigi Zoseheni ámegetiki vake gonosi milimilimagú viki ánigamó. ");
INSERT INTO gah_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ánigiake, numúitoka atiginá iki vake gonosiváaló holotatune liki anuva hilina ali vavá amó. Lá iake, ámina vená nenete holisigú Zuta vete li hukinamómaló nene kavasú viziki minamóza, ");
INSERT INTO gah_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Sategú neteká holugú nene gonosiva mola apató vinigi anuvagi hilina ali vavá iki milamóma nene aliki vamó. ");
INSERT INTO gah_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Vi anitiake ánigamó nene, geha mulí agepaló gehani napa zi hitamó nene aló ahelú i ámiginago ánigamóza, ");
INSERT INTO gah_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","keza áminagú itiake ánigamó nene Guivahani Izesuni gonosiváa ánigamamó neve. ");
INSERT INTO gah_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Lá iake ámina netakumú negi nagi hiziki niago, ve lositá galinali utó ikasike, iki holúikú minasimó nene, luhoaká góini nenémo gizopa vaevae loko minamó. ");
INSERT INTO gah_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Lá noigo ánigiake ámina vená nenete kehelele novizigo, mikasiuka gupá zemó. Lá niago, ámina ve losi nenetosa láa liki li kemesimó: Hele vegenalitini apakú amenigi oteko noi vemamú nanamú vitagá niave. Eza imanegú noamive. Mota otopá zeko otekave. ");
INSERT INTO gah_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","7","Lekeza Galilaia mikasiuka minake okulumakutí lumu ve gihila neza netá golesa aliaká nia vetini kigizakú nilími milikiko, zohota zaló nipili hilikiko, gamena losive makole minokinake goha otinogo uve loko lo likimi gakokumú goha lakagata giliki minalo. ");
INSERT INTO gah_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Liki likasigo, keza gozapá láa loko lo kimi gakómaloka goha kagata giliake, ");
INSERT INTO gah_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","geha mulikú gonosi mola apáma ahuliake, goha atiginá iki vake, aí izegipala zuhagutí ileveníagi vegená lugáagi nene ániga sunimú avetó iki li kememó nene, ");
INSERT INTO gah_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Maliá eza Magatala apatotí vená itó Zoaná itó Maliá magáa eza Zemusini izolaho itó vená makó lugáa nenete ámina gakó avetó iki aposoloma li kememóza, ");
INSERT INTO gah_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","aposolomate gakó imane gihila nilave liki gili alévolé amamó. ");
INSERT INTO gah_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Lá niago, Pitá nene oteake gonosi mola apámaloka ololu loko vike geha mulikú gupá zeko ánigamó nene, lavolavo gó gizopa lamaná lositáma hanuva nego ánigoake, eza nene goha atiginá oko numutoka vike, ámina suni utó ikumú agata gululusi geleko minamó. ");
INSERT INTO gah_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Lá noigo, ámina gamenaló izegipala zuhagutí ve losi nene Emause numutoka vinigi gapoló vasimó. Emause apá nene Zelusalegatí hotó otigí oko 11 kilomita nenéminoko minamó. ");
INSERT INTO gah_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Lá iki nivasike, Izesutoka utó i netakumú ligili hagili iki nivasigo, ");
INSERT INTO gah_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Izesú nene vogaláikutí utó oake makó vamóza, ");
INSERT INTO gah_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","kogómulaló hitonoigo, Izesú noive liki ánigi vevesamasigo, ");
INSERT INTO gah_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","eza gakó nene nana onoigo ligili hagili iki nivasive loko lokago, keza nene viki notesike kogoka kegepa muhelé noigo, ");
INSERT INTO gah_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","keikutí maga ve agulizá Kiliopá ave loko noi vémo anotó aleko láa loko lo amimó: Veno ve mukí iki Zelusale apakú ali nupa niamó nenete imane gamenaló utó i sunimú gili asú inamóza, géisi ve hamó nene gelemape. ");
INSERT INTO gah_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Loko lokago, eza nana suni utó ikumú nilasive loko loká okimikago, keza láa liki li amesimó: Nasalete numutotí ve Izesuni sunimú nolusive. Eza nene Ómasímini agepagutí gakó loaká ve minake, Ómasímini agómulaló itó vegenalitini kogómulaló alévolé gakó loaká ve itó alévolé suni aleaká ve minamó neve. ");
INSERT INTO gah_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Lá imó nemóza, lelí guguni giziaká vete napagi lelí monó gizapa vetegi apili ahulatave liki goní imikago, zohota zaló apiliki apeteke apili hele vemú nolusive. ");
INSERT INTO gah_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Itó goí oko Isilae mikasiuka gala vetini kigizakutí lelémo atiginá itihe loko gelenounimóza, gakó makó láa loko neve. Ámina suni utó ikutí nene gamena losive makole mota vokave. ");
INSERT INTO gah_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Lá onoimóza, lelí zuhagutí vená makó lugáate iki likago ininá okune. Keza neteká holugú nene gonosi milimilimaló vake, ");
INSERT INTO gah_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","gonosiva ánigamake, ageló losi utó ikasike Izesú nene oteko agómulagi noive liki lasi gakokumú nene ámina vená nenete vamokitana ánigiake, atiginá iki iki avetó iki li lememó. ");
INSERT INTO gah_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Lá ikago, lelikutí makolititosa viki geha mulikú gonosi milimilima ánigasike, venalite iki avetó amómáminoko nego ánigasimóza, ámina ve nene agupeló ánigamasimó. ");
INSERT INTO gah_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Liki likasigo, Izesú láa loko lo kimimó: Lekeza ve negi niasive. Mulutini lepa hizetigí onoigo Ómasímini agepagutí gakó liaká a vete gakó mukí luhuva gizinamóma nene gili zagemasive. ");
INSERT INTO gah_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ómasímo gologí oleketative loko lo mololeketa vema nene ámina miluma netá ali gihimikiko helekoko alika nene oteoko lapanala goha alitive likigó gizinamóma neve. ");
INSERT INTO gah_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Loko loake, Moseki itó Ómasímini agepagutí gakó liaká a vetegi gizina gakó lo kemeloko novike, ezáamú monó gotolaú gizina gakó mukí nenémini mogonamú ale hee loko lo kimimó. ");
INSERT INTO gah_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Lo kemeloko novike, Emause apá ali ávatiha iake, eza nene ámina apá avilegeko vinogo noigo, ");
INSERT INTO gah_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","keza agata aliki ho mota lemeake límugusi zinogo noize, lezagi makó akatune liki li amikasigo, Izesú nene gele kemekago, numukú nene makó itemó. ");
INSERT INTO gah_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Itiki minake, nosá nanigi niake, eza nene mitó minake peleti aleake, Ómasi agepoka loake, gitegeake kimimó. ");
INSERT INTO gah_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Lá noigo, kogómula panava zekago, Izesuni nene ánigi hee hee lasimó. Ánigi hee hee nilasigo, litá oko legemage imó. ");
INSERT INTO gah_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Lá okago, keza láa liki ligili hagili asimó: Gapoloka gakó lo limike monó gotolámini mogona lo utó oko lo nolimike lelémo zaú okave. ");
INSERT INTO gah_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Liki ligili hagili asike, litá iki otiki Zelusalega atiginá iki vasimó. Vi anitikasike, aí izegipala zuha 11-imagi agive lugáagi alegesá iki niago ánigikasigo, ");
INSERT INTO gah_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ámina ve lositá nene litá iki avetó iki Guivahanitema nene lamaná oteko noike Saimoni utó o amekave. ");
INSERT INTO gah_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Liki li kimikago, keza lá iki Izesúma gapoloka kémegetoko vike nosánetá nanigi peleti gitigitó ánigi hee lasi gakó nene avetó iki li kemesimó. ");
INSERT INTO gah_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Izegipala zuhamate ámina gakó ligili hagili niago, Izesú nene galinali utó oake, ote minake hulu nene lekelitoka minino. ");
INSERT INTO gah_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Loko lokago, keza ánigiake, ininá iake holosi utó okahe liki kehelele vizimó. ");
INSERT INTO gah_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Lá iki kagata nigelego, eza láa loko lo kimimó: Lekeza nanamú ininá iki lakagata losi nigeleve. ");
INSERT INTO gah_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Imane nezama lamaná utó nouve. Lekeza nigisa nigizatoka nuhúma ánigalo. Itó ánigiiki iki nugupeló ali giliiki ánigi hee lilo. Neza nugupegi vegená lahani utó okuve. Holosi nene nenéminiki niamave. ");
INSERT INTO gah_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Loko lo kemeake, agisa agizani nene kelepizimó. ");
INSERT INTO gah_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Lá okago, keza mulúikú agila guluma itímo velesá gili alévolé amake kagata losi nigelego, Izesú nene lekelitoka nosánetá ma nehe. ");
INSERT INTO gah_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Loko loká okago, keza lotó gizina lagaha makó amiake, ");
INSERT INTO gah_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ániginago aleko namó. ");
INSERT INTO gah_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Itó Izesú láa loko lo kimimó: Neza lekezagi minunike Mosé lo hukoko li gakokú itó Ómasímini agepagutí gakó liaká a vetini gakokú itó Ómasi agepoka liká nama liká a gakokú nenikumú epoapo gakó luhuva gizamóma nene gihila ze asú inogo ive loko lo lekemeaká umóma neve. ");
INSERT INTO gah_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Loko loake, monó gotolaú luhuva gizikago mina gakó nene gili vevesatave loko kigika kagata ale koló oake, ");
INSERT INTO gah_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","láa loko lo kimimó: Monó gotolaú gologí oleketative loko lo mololeketa vemú nene miluma geleko heleoko gamena losive makole galegú minooko heleneitikutí otopá zeko otinogo ive liki luhuva gizinamóma neve. ");
INSERT INTO gah_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Itó aí agulizá nene numutó namató vegenatoka vo asú oko vokiko, vegená keza giliiki kigika ali viligikiko lihimáini ahuloketative loko lonoive. Itó ámina hoza nene Zelusale numutoka apí iki alimi vitave liki luhuva gizinamóma neve. ");
INSERT INTO gah_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ámina netá ánigakumú avetó iki li kimita vegenáma lekelisi niave. ");
INSERT INTO gah_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Gilinahe. Améneho Sikalahula lehizeleketatove loko lo mololeketamó nene amiselekugo liminogo ive. Lá itomó nenazo, lekeza imane apá litá iki ahulamiki ageva iki niiko velé okulumakutí zámuza lekemekiko vitave. ");
INSERT INTO gah_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Loko loake, minake, numutotí kelémoko vike Petania numuni ali alitiki viake, agizani ale otike nónohá zeketamó. ");
INSERT INTO gah_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Nónohá nozeketake ahuloketoko okulumakú itimó. ");
INSERT INTO gah_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Lá okago, keza mulúikú agila guluma goha igo, Zelusalega atiginá iki vake, ");
INSERT INTO gah_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","guguni giziaká zavusavegú nene gamena gamena Ómasi agepoka liki minamó. ");
INSERT INTO gah_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Netá matá apí oko utó i gamena nene, Ómasímini agepagú gakotó mina vémo nene hanuva minake, mino-loko iteko minamó. Lá noike, Ómasímini amatoka minamó. Itó agepagú gakotó mina ve nenémo Ómasi minamó. ");
INSERT INTO gah_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Áisi nene apí oko Ómasiloka minamó. ");
INSERT INTO gah_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Minoake nene, netá mukí ale utó o asú imó. Netá hámakoláa áisi minamigo utó osá amimó neve. ");
INSERT INTO gah_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Eza nene alévolé oko minoakalímini amelaho loló oko minake, alévolé oko minoaká nenémo vegená hize hanatoketamó. ");
INSERT INTO gah_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Lapaná nenémo límugusigú hize hanatokago, límugusi nenémo lapaná nene apele helemimó. ");
INSERT INTO gah_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ómasímo ve makó alémo etó oake, amiselekago, voko utó imó, agulizá Zoní. ");
INSERT INTO gah_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Áisi nene vegená mukí keza aí gakó giliiki gili alévolé itave loko lapaná nenémini gakoláa lo utó oko minamó. ");
INSERT INTO gah_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Lá imóza, Zoní ezáa nene lapaná amelaho minamive. Eza hanuva lapaná amelahini gakoláagó lo utó oaká imó. ");
INSERT INTO gah_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Lapaná amelaho eza numutó namató vegená hize sata okimiaká noi vémo gamena nene zupa mikasigú utó oake minamó. ");
INSERT INTO gah_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Áisi nene mikasigú utó oakaláa nene utó imóza, mikasigú netá mukí nene áisi ale utó imó. Ale utó oake mino-loko novike lemeko mikasigú utó okago, mikasigú vegená keza aí ánigi hee hee lamamó. ");
INSERT INTO gah_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Lá ikago, ezáa ale utó i apakú utó imóza, vegenala zuhate lelikutí noize liake alími kamatoka amamó. ");
INSERT INTO gah_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Kigikagú aí ali gúemoláa nene Ómasímini izegipala zuha lilí itave loko gapo veleketamó nene aikumú gili alévolé ina vegená nenémini itave loko gele kemeaká noive. ");
INSERT INTO gah_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Keza nene izóike getakutí Ómasímini vegenala lilí iki gosohá utó amave, itó lugupegú golanímini gapogú viki gosohá utó isá amave. Ómasilokatí gosohá utó iaká niave. ");
INSERT INTO gah_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ómasímini agepagú gakotó mina ve nenémo vegená loló oake, vogalategú minoko aleko ike, nasahilí asapulagi gakó gihilagi ale-loko limigo, ániguhá. Aí okulumakú lapaná ánigunimó nene, amelahini gipala hamokó minake amelahini lapanala lelepizigo ánigunimóma neve. ");
INSERT INTO gah_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Aí mogonáa nene Zoní gakó napagutí láa loko lo utó imó: Nénisi ámina vemú goí oko nene neza utó amugo emane amunalotí mino-loko iteko mina ve nenazo, ámina ve alika nemegesaló noamó áisi nene není nivilegeko noave loko lo lukumumóma neve. ");
INSERT INTO gah_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Áisi nene vegená mukitoka netá mukí asapulagi nasahilí olimikago, hagitana alekogó minoaká noune. ");
INSERT INTO gah_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ómasímo lokago, Mosé eza lo hukoko li gakokó luhuva gizo limimóza, Izesu Kilistó áisi aleko iteko nasahilí nene hagitana oletake gakó gihiláa lehizeletamóma neve. ");
INSERT INTO gah_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ómasi nene ve makolímohe makolímohe ánigonamive. Gipala hamokó ezáa nene Ómasi noive. Eza amelahini amatoka minake, amelahini mogonáa aleloko limike lo utó oko lo lemekave. ");
INSERT INTO gah_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Zelusale numutokatí Zuta vegenalitini monó gizapa vete guguni giziaká vegi monó zavusavegú gelekelé ve makoki kimisilikago, Zonitoka vi anitiake, géisi éaga noane, gologí oletative loko lo mololeta vema noape liki loká imikago, ");
INSERT INTO gah_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","ezáa mogona egamega amike lo kimike lo utó ike neza gologí oleketative loko lo mololeketa vema minamuve. ");
INSERT INTO gah_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Loko lokago, keza miní ameke goha loká itake itó géisi éagama noane. Gologí olimiaká vema velesá anitemiko okulumakutí goha ative liki lina ve Ilaizagama noape. Liki likago, eza nene Ilaizá noamuve lokago, géisi nene Ómasímini agepagutí gakó loaká ve makó Mosekitana noi ve ageva oko nominuhá vema noape. Liki likago, eza óve lokago, ");
INSERT INTO gah_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","láa lokoma geza éahoma noane. Geitoka limisilikago uhá vegenáma voko nanave loko lo kimitune. Gezakamú nanave loko nolane. ");
INSERT INTO gah_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Liki likago, Zoní láa loko lo kimimó: Ómasímini agepagutí gakó loaká ve Isaiá luhuva makó láa loko gizamóma neve: Mikasi gomopalaló ve makolímo gakó napagutí Guivahanímini gapo nene likigikagú ali hee liki vilitalo, loko nolive loko giza gakó nene nenitoka alévolé okave. ");
INSERT INTO gah_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Loko lokago, Palisaio monó vete kimisilikago Zonitoka viki anite ve nenete ");
INSERT INTO gah_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","áminamú goha loká itake lamó: Geza gologí oletative loko lo mololeta vema minamane, itó Ilaizaga minamane, itó Ómasímini agepagutí gakó loaká ve ageva nominuhá vema minamanimó nenazo, nanamú vegená nene monó nagamí holokimiaká noane. ");
INSERT INTO gah_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Liki likago, Zoní láa loko lo kimimó: Neza vegená nagamikó holokimiaká noumóza, holutikú ve makó utó oake noimó nene lekeza ánigi guni isá amave. ");
INSERT INTO gah_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Áisi nene némegetoko ova ova noive. Ámina veloka akohemunazo, aí gelekelé otoko hoza lagasó aletatomoki akohemuve. ");
INSERT INTO gah_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Loko li netá nene Petania apatoka Zota nagamí vola helegaloka Zoní monó nagamí holokimiaká noitó utó imó. ");
INSERT INTO gah_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Akiake gó lago, Izesú nene Zoní noitoka anitekago, hotó otigí oko volane noago ánigoake, láa loko vegenáma lo kimimó: Ánigalo. Volane áisi nene Ómasímini guguni gizoakalímini sipsip iza akaleva gihila nene numutó namató vegenalitini lihimaváini aí amupiló itekago agohí geaká noive. ");
INSERT INTO gah_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Neza aikumú nene neza utó amugo emane amunalotí mino-loko iteko mina ve nenazo, ámina ve alika nemegesaló noamó áisi nene není nivilegeko noive loko lo lukumumóma neve. ");
INSERT INTO gah_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Neza nene gozapá aí nene ánigo hee hee lamumóza, lekeza Isilae vegenalita ámina vémini gakola lo lukumugo gilitave loko aniteuke monó nagamí apí oko hololeketumóma neve. ");
INSERT INTO gah_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Loko Zoní nene loake, goha láa loko avetó ike lo kimimó: Neza Sikalahulímo okulumakutí nama luhusigitana oko lemeko ámina vémini amupiló aleneigo ánigumóma neve. ");
INSERT INTO gah_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Neza gozapá aí nene ánigo hee hee lamumóza, monó nagamí hololikimiaká hozaló nimisili vémo Sikalahú limike amupiló aleneiko ánigatani ve áisi nene vegená nene není Sikalahú holoketanogo ive loko lo nimimóma neve. ");
INSERT INTO gah_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Loko litoka lemeko noigo ánigumole loko mogonamú nene áisi nene Ómasímini gipala noive, loko limó. ");
INSERT INTO gah_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Akiake gó lago, Zoní ave itó izegipala zuhagutí ve lositá ámina mikasiló minamó. ");
INSERT INTO gah_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Niago, Izesú nene apá makotoka novigo, ánigoake, izegipala losima nene láa loko lo kimimó: Ómasímini sipsip iza akaleva ánigalizo. ");
INSERT INTO gah_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Loko lokago, keza nene gakó gilikasike, Izesuni ámegetiki vasimó. ");
INSERT INTO gah_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Vikasigo, Izesú nene viligoko ánigoake, lekeza nanamú niasive loko lokago, kezáini gakokutí Lavi velemaka, lelí gakokutí nene monó gizapa velemaka, geza hí numukú minoaká noane. ");
INSERT INTO gah_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Liki likasigo, iki ánigalizo loko lokago, keza ámegetiki vasike, numunáa ánigasike, ho ale zohota okago, áminaloka makó mini milasimó. ");
INSERT INTO gah_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Zonini gakó gilikasike Izesuni ámegetasi vegutí nene makó agulizá Etulú, eza Saimon Pitani agunala. ");
INSERT INTO gah_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Áisi nene litá oko uvolahini Saimoni ánigoake, láa loko lo amimó: Leza Mesiani mota ánigokune. (Mesiá nene Zuta vetini gakokutí, itó Kilistó nene Kiliki gakokutí, ámina agulizalímini mogonáa nene gologí oletative loko lo mololeta ve loko neve.) ");
INSERT INTO gah_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Loko loake, Izesutoka alémoko vokago, Izesú nene ánigoake, láa loko lo amimó: Geza Saimoga Zonini gipalamaka, geí gugulizá Sipasí ave loko nomuluve. (Sipasí nene Zuta vetini gakokutí, itó Kiliki gakokutí nene Pitá, agulizalímini mogonáa nene geha sepepizámo.) ");
INSERT INTO gah_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Akiake gó lago, Izesú nene Galilaia mikasiuka vitove loko agata geleake, Piliponi ánigoake, geza némegetozo. ");
INSERT INTO gah_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Loko limó nene, Pilipó ave Etulú ave Pitá ave nene Petesaita apatokatikó minamó. ");
INSERT INTO gah_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Itó Pilipó nene Natanaeni ánigoake láa loko lo amimó: Mosé lo hukoko li gakoki itó Ómasímini agepagutí gakó liaká a vete la gakoki luhuva giza vema mota ánigokune. Nasalete apatokatí Zoseheni gipala Izesunima. ");
INSERT INTO gah_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Loko lokago, Natanaé nene Nasalete apatokatí nana netá lamaná makó utó itive. Loko lokago, Pilipó nene láa lokoma oko ánigozo, ");
INSERT INTO gah_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","loko lokago, Natanaé nene Izesutoka vo anitekago, ánigoake, Ánigalo. Imane ve Isilae ve gihiláa nenazo, agikagú soza gakó minami ve noive. ");
INSERT INTO gah_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Loko lokago, Natanaé loká otake geza hitóma nougo ániganimó neve. Loko lokago, Izesú nene Pilipó velesá gelémoko amigo, nimuza za mogonaló noako ánigumóma neve. ");
INSERT INTO gah_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Loko lokago, Natanaé láa loko limó: Monó gizapa venemaka, geza lamaná Ómasímini gipala noane. Isilae ve lelí gugulizaki ve noane. ");
INSERT INTO gah_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Loko lokago, Izesú láa loko limó: Nimuza za mogonaló noako ánigumóma neve loko lo gumutó gelekanike nenikumú gele alévolé onoape. Gelezo. Oko moloko umó imane nene avevezahaváa neve. Netá gihila gohaláa nene alika ánigoko gilinogo ane. ");
INSERT INTO gah_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Loko loake, miní ameko láa loko limó: Neza lamaná lo likimitoze, gililo. Lekeza okulumá koló okiko, Ómasímini ageló keza okulumakutí lumu ve gihila nenitoka tigá limigá niko ániganigave, loko limó. ");
INSERT INTO gah_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Numuni lositá akiake, Kana numutó Galilaia mikasiuka nene ve vená losima ali agizakú vizinigi nosánetá ali vavá niago, Izesuni izolaho áminaló noigo, ");
INSERT INTO gah_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Izesú ezagi izegipala zuhagi alesa milikimikago, viki makó miniki nosánetá ninago, ");
INSERT INTO gah_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","áminagú mina vegenalite vain nagamíma ni asú ikago, Izesuni izolaho nene vain nagamíma mota ni asú ikave loko lo amimó. ");
INSERT INTO gah_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Loko lokago, Izesú láa loko lo amimó: Vená geza nenemú nanamú nenitoka nolane. Nene není netáma neve. Neza alévolé netá loló ito gamenaváne velesá alitonamive. ");
INSERT INTO gah_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Loko lokago, izolaho nene gelekelé izegipalama nene netá makokumú lo nolikimikoma ilo, loko lo kimimó. ");
INSERT INTO gah_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Itó Zuta vegenalite litá litá iki kugupe nogokalavó iaká amó nenazo, ámina numukú nene nagamí goni sipisi gehanitunú lilí amó nene 6-ía minamó. Ámina goni napa hamopamó vaí itikumú nene somo ligizani luga luga asú igo ihiki lekiaká amó neve. ");
INSERT INTO gah_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Lá okago, Izesú eza gelekelé izegipala nene lekeza nagamí ihiki nagamí goni napamagú lekilo. Loko lo kemekago, keza nagamí ihimi leki leki ago ago, goni napama nene vaí oake agepagó minamó. ");
INSERT INTO gah_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Lá ikago, Izesú nene lekeza lugáa ihiki aliki viki nosánetá gizapa vema amilo. Loko lokago, keza ihiki aliki nivago, ");
INSERT INTO gah_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ámina ha nagamilímo vain nagamí loló okago, nosá gizapa vemámo no gilimó nene laga imóza, hikutí utó itímini mogona gele vevesamimó. Gelekelé izegipama kezáikó gili hee hee lamó. Lá igo nosá gizapa vemámo vená alimi ame vema sele loake, ");
INSERT INTO gah_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","láa loko lo amimó: Ve mukitoka nene vain nagamí lagaváa nene goí iki kimikago, niki niki kigikauka gopa okago, alika nene vain nagamí golesáa nene ihiki kimiaká niave. Nenéminokoma nemóza, géisi nene senisim okanike vain nagamí lamaná imane halá gekanike minanike minanike alika ale utó molokanimó nene vatí sunive, loko lo amimó. ");
INSERT INTO gah_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Izesú nene Kana numutoka Galilaia mikasigú nene ámina alévolé suni apí ike, ezáa hazana kelepizekago, izegipala zuha keza nene ánigiake, aikumú gili alévolé amó. ");
INSERT INTO gah_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Lá ikago, Izesú nene Kana numutó ahuloake Kapanao apatoka lemeko novigo, izolahove agunala izegipala zuha mukí keza ámegetiki vamó. Viki neneló gamena hána minamake, ");
INSERT INTO gah_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Zuta vetini avóikini asenini zeketakumú gili mina holisi alitokagove loko, Izesú nene Zelusalega iteko vimó. ");
INSERT INTO gah_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Neneló Izesú ánigamó nene monó zavusave hé numunaloka pulumaká iza itó nama luhusi nene Ómasi guguni gizi amitave liki aliki ake, haitó mikasigutí moniló ámina mikasigú moni kimiaká a ve keza moni holomaló gatiká iki niago, ánigoake, ");
INSERT INTO gah_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","lepa nagá límegeake nakahuni loló oake, vegená niamó sipsip iza pulumaká iza niamó kepeleko kimisele ahula ahula igo, nivago, haitó mikasigutí moniló ámina mikasigú moni kimiaká a vetini holoma aleko gululupa soake gatiki mina moni aleko tulu ahuloake, ");
INSERT INTO gah_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","nama luhusi miliaká a vema láa loko lo kimimó: Aménehini numuni imane ali meina numuni lilí amilo. Imane netá hatoka aliki vilo. ");
INSERT INTO gah_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Loko Izesú lokago, izegipala zuha leza nene geí numunimule loko mulúne gitihiná imó nenémo nepele hilitimó okave liki monó gotolaú gizikago mina gakó goha gulunimó. ");
INSERT INTO gah_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Lá okago, Zuta vetini monó gizapa vete láa liki li amemó: Geza némini manámini noanimóma éahini gakotó nalene. Haitó suni makó ale utó moloko mogonaka lelepizemane. ");
INSERT INTO gah_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Liki likago, konotó aleko láa loko lo kimimó: Lekeza monó zavusave imane tele vizikiko, nénisi nene gamena losive makole oko noviko, ge lutiginogo uve. ");
INSERT INTO gah_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Loko lo kemekago, keza lamó: Avotege keza monó zavusave imane kilisimasi 46 oko novigo gi lutiginamóma neve. Itó géisi nene gamena losive makolegó noviko ge lutigitove loko nolape. ");
INSERT INTO gah_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Liki lamóza, Izesú nene ezáa agupémini zavusavegú lo vizike limó. ");
INSERT INTO gah_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Minoko heleneikutí gamena losive makole minake mómoká oko otekago, izegipala zuha leza ámina netakumú Izesú li gakómagi monó gotolagutí gakó nenegi mota alévolé okago gelekunike, gele alévolé unimó. ");
INSERT INTO gah_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Izesú nene avóikini asenini zeketakumú gili mina holisigú nene Zelusalega noike, ezáa mogona utó itive loko alévolé suni haitopaitolímini loló okago, mukí vegená keza ánigiake, agulizaláa gili alévolé amóza, ");
INSERT INTO gah_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Izesú ezáa nene mukí vegenalitini mogona ánigo asú okamó nenazo, keitoka voko ale akisemimó. ");
INSERT INTO gah_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Eza ve makolímini mogona gilinogo voko vegenatoka loká miká oketosá amimó. Ezáagó vegená kigikagú ánigo asú oaká imó neve. ");
INSERT INTO gah_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Palisaio monó vetini kigivéipo makó minamó, agulizá Nikotemó. Áisi nene Zuta vetini monó gizapa venini makó minamó. ");
INSERT INTO gah_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ámina ve áisi límugusigú Izesú noitoka vike láa loko lo amimó: Monó gizapa velemaka, leza mogonaka geleaká noune. Géisi monó apí o lemeaká ve gihila minokanike, Ómasilokatí lemenimóma neve. Ve makó nenémo Ómasi aitoka minamiko loló oaká noani suni aleko alévolé netá loló oakaláa nene nomive. ");
INSERT INTO gah_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Loko lokago, Izesú láa loko lo amimó: Neza lamaná lo gimitoze, gelezo. Makó nenémo okulumakutí gosohá utó amitimó nenémo Ómasímo alévolé oko gizapa olikimiaká apá ánigaminogo ive. ");
INSERT INTO gah_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Loko lokago, Nikotemó láa loko limó: Íi, mota napa okatímo nana oko gosohá utó itive. Nana oko izolahini agatupagú itekiko goha getatikumú lane. ");
INSERT INTO gah_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Loko lokago, Izesú láa loko lo amimó: Neza lamaná lo gimitoze. Makó eza monó nagamí holoko Sikalahulímini agikagú vo holokoko gosohá utó amitimó nenémo Ómasímo alévolé oko gizapa olikimiaká apakú iteminogo ive. ");
INSERT INTO gah_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Vegenalititokatikó utó itamó nenete vegenalitini kemetamenigi utó inigave. Sikalahulímitokatí utó itamó nenete Sikalahulímini ametamenigi utó inigave. ");
INSERT INTO gah_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Lá onoinazo, lekeza okulumakutí gosohá utó itave loko lumó nene geza gelekako gena amino. ");
INSERT INTO gah_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Hepé nene gopa aleaká noive. Lá noigo hepelímini anó giliaká niamóza, mogonáa hitotí apí oake aleaká noive itó vike hitoka lutegeaká noihe nene gelemave. Itó Sikalahulímitokatí utó ita vegenalitini mogonáa ámináminoko nene neve. ");
INSERT INTO gah_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Loko lokago, Nikotemó nene gakó lanimó nene mogonaló gelemu gakó laninazo, nana oko utó itive. ");
INSERT INTO gah_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Loko lokago, Izesú láa loko lo amimó: Géisi nene Isilae vetini gakó apí o kemeaká ve noanimó nenazo, gakó nolumómámini mogona nanamú gele gopa okane. ");
INSERT INTO gah_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Neza lamaná lo gimitoze, gelezo. Leza nene ánigoko gele nouni netá áminagó lo lekemeaká nounimóza, lekeza nene gakote gili ahuliaká niave. ");
INSERT INTO gah_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Neza mikasigú utó oaká noi netakumú lo lekemekugo, gili seketigí amanazo, nenemú okulumakú utó oaká noi netakumú lo likimitomó nene, nanatitotí gili seketigí itave. ");
INSERT INTO gah_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Lekelikutí ve makolímo okulumakú iteko okulumakú noi netá nene keké ánigonamimóma neve. Okulumakutí lumu ve gihila nénisi Ómasilokatí lumumó nenazo, neza okulumakú noi netá nene ánigonoumóma neve. ");
INSERT INTO gah_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Mosé nene gozapá mikasi gomopalaló gosihakitana avevezaha netá loló oake zaló ale otimó nene gosihámate kepele vegenalite áminaló ánigiiki goha lamaná itave loko lá imó nene nenéminiki okulumakutí lumu ve gihila není nene malipo zaló nilími otinigave. ");
INSERT INTO gah_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Nilími otikiko nene, nenikumú gili alévolé itamoláa keza alévolé kemetamenigi minanigave, loko limó. ");
INSERT INTO gah_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ómasímo numutó namató vegená lelikumú milumavate gilimó nene napa napa nego gipala hamokó lehizeletamó nene aikumú gili alévolé ita vegená keza latila amiki alévolé kemetamenigi minanigave loko lá imó neve. ");
INSERT INTO gah_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Gipala nenémo mikasiuka vegená lihima kimitove loko nomive. Kelémo kugutó vizitive loko Ómasímo amiselekago limimó neve. ");
INSERT INTO gah_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Makó keza Ómasímini gipalamú gili alévolé itamó nene, Ómasímo lihima kememinogo ive. Makó keza gili alévolé amitamó nenete Ómasímini gipala hamokó aí agulizá gili alemamó nenazo, nenemú Ómasímo mota lihima kiminogo ive. ");
INSERT INTO gah_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Lihima kemeaká nenémini mogonáa lá oko neve: Okulumakutí lapaná nene mikasiuka vegenalitini kovogisaló ale utó okugo, keza nene netá golesa aliki miniaká amó nenazo, keza lapaná nene ahuliake, límugusímini mututoni mini etó amó neve. ");
INSERT INTO gah_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Makó keza netá golesa aliki minatamó nenete Ómasímini lapaná kemegesa amiiki kezáini miniki aliki amó nenémini mogonáa utó okative liki Ómasímini lapanató isá amave. ");
INSERT INTO gah_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Makó keza netá gihila aliki minatamó nenete Ómasímo hize lé okimikago iki miliki amó nenémini mogonáa utó itive liki lapanalámini avogisaló anigave. ");
INSERT INTO gah_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Lá iki miniki, Izesú nene izegipala zuha lelémoko Zelusalega ahulokunike, Zutaia mikasiloka voko minuhá. Neneloka makó minunike nagamí holoketoko minuhá. ");
INSERT INTO gah_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ámina zupa nene Zonini nene velesá nagá numukú alími milamago, Zoní nene Salima apá agilikaloka minake, Aeno loko noi numutoka minamó. ");
INSERT INTO gah_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Neneló nagamí mukí minokagove loko vegená anitikago, monó nagamí holoketoko minuhá. ");
INSERT INTO gah_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Lá okago, Zuta ve makolímo Zonini izegipala zuhagi nagamí holokimiaká sunimú pelevesava zemó. ");
INSERT INTO gah_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Lá iake, Zonitoka viki láa liki li amemó: Tisalemaka geza Zota nagamí vola helegaloka noako, gezagi makó minasi ve mogonáa lo utó moloko lo lemeni ve nenémo itína gamena nene vegená nagamí noholoketago, mukí vegená ahuligitiki aitoka vi asú niamole. ");
INSERT INTO gah_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Liki likago, Zoní láa loko lo kimimó; Ve makó nenémo okulumá amelaho netá matá amemikoma ezáa hagitana alitihe. ");
INSERT INTO gah_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Neza gologí oleketative loko lo mololeketa vema minamuve loko lo lukumumóma neve. Ámina ve ale goí otoko gapova veletatane loko Ómasímo nimiselekago umóma neve. ");
INSERT INTO gah_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Vená ánigi milita ve áisi vená ve loló okoko agoliza noviziko, agivelaho gelekoko alémo vatí oko mulunagú lamaná gilinogo ive. Nenéminoko mukí vegená nene Izesutokagó nivago gelekuke mulúnegú agila guluma itimó nenémo hutilí oko vaí oko minative. ");
INSERT INTO gah_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ámina vémini agulizá nene minomo iteko minatimóza, nénisi minomo lemeko minanogo uve. ");
INSERT INTO gah_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Veletokatí limimó áisi livilegeko noive. Makó nene mikasigutí utó amó nenete mikasímini mututoni lilí inigave. Lá iki mikasigutí gakó linigave. Itó okulumakutí limi ve nenémo livilege asú onoive. ");
INSERT INTO gah_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Áisi nene netá matá geleko ániga netakumú loaká noimóza, aí gakó giliake amegesaló mila vegená mukí niamave. ");
INSERT INTO gah_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Gakoláa gili alitamó keza Ómasímo lokago alévolé oaká noi veve liki nene gakó hize lé iaká niave. ");
INSERT INTO gah_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ómasímo amiselekago limi ve áisi nene Ómasímini Sikalahula gúe vaí omiake Ómasímini gakokó loaká noive. ");
INSERT INTO gah_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Amelaho eza gipala ánigo amu heleake, mukí netá nene gipalámini agizakú molo asú okave. ");
INSERT INTO gah_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Makó nenete Ómasímini gipalamú gili alévolé itamó keza alévolé kemetameni mota alikave. Itó makó keza gipalámini gakó gili ahuliiki mihina itamó keza alévolé kemetameni aleminigave. Nenémini amupiló Ómasímini mesaha ititokó minanigave, loko limó. ");
INSERT INTO gah_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Palisaio ve keza Izesukumú láa liki gelemó: Zoní nene vegenala zuha luguhakó kelémo moloko monó nagamí holokimiaká noimóza, Izesú nene vegená mukí kelémo moloake holokimiaká noive. ");
INSERT INTO gah_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Nene gakó nene hanuva lamó. Izesú nene izegipala zuha lo lemekago lezategó monó nagamí holoketunimó. Lá okago, Izesú nene gakó geleake, ");
INSERT INTO gah_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Zutaia mikasi nene ahuloake, Galilaia mikasigú goha vimó. ");
INSERT INTO gah_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Novike nene, Samalia mikasiuka vo anitimó. ");
INSERT INTO gah_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Samalia mikasigú apá makó agulizá Sika loko neneloka anitimó. Ámina apá nene ká emane amunaló Zakopó eza mikasi makó nene gipala Zoseheni amimómámini agilikaloka minamó. ");
INSERT INTO gah_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Lá okago, áminaló nene Zakoponi nagamí gale minokago, Izesú nene áminaloka holínaka vo aniteake, gapo vike vitímo agizamuha zekago, ámina nagamí galeló minamó. ");
INSERT INTO gah_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Noigo, aí izegipala zuha leza nosánetá meina hizinogo numutoka itekuko, Izesú ezáagó noitoka Samalia vená makó nagamí ihitove loko amó. Oko anitekago, Izesú nene nagamíma ihe nemezo loko lokago, ");
INSERT INTO gah_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Zuta vegi itó Samalia vegi nene otopá ziki miniaká amó nenazo, ámina vená nenémo geza Zuta ve neneka nanamú Samalia vená nenitoka nagamikumú voká nolane. ");
INSERT INTO gah_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Loko lokago, Izesú láa loko lo amimó: Geza Ómasímo gimiti netalímini mogona gelemane. Itó nagamí ihe nemezo loko nolu ve není mogona gelemane. Geza není mogona geletilina, itó alévolé oko mino-loko voakalímini nagamikumú loká atilina, gumuline. ");
INSERT INTO gah_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Loko lokago, vená nenémo láa loko limó: Ve lamanámaka, gale hána nenazo, itó geí nagamí iheaká netá nominazo, alévolé oko mino-loko voakalímini nagamí hikutí iheko nimitane. ");
INSERT INTO gah_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Avoteho Zakopó eza nagamí gale imane ligimó nenazo, ezáagi gipalagi iza galavagi keza áminagutikó niaká amó. Itó géisi nene Zakoponi avilegeko nagamí makó haitolímini ale utó inogo nolape. ");
INSERT INTO gah_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Loko lokago, Izesú láa loko lo amimó: Nagamí imane natamóza, goha nagamikumú likivisinogo ive. ");
INSERT INTO gah_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Není nagamí nene lakagatupa oaká nagamí neve. Makó keza nenitokatí nagamí natamó nene, goha nagamikumú kiviseminogo ive. Nénisi nene nagamí kemekugo nene kigikagú agómula minati nagamí minokiko alévolé kemetamenigi minimi itiki minanigave. ");
INSERT INTO gah_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Loko lokago, vená nenémo ha nagamikumú nolihe loko láa loko lo amimó: Ve lamanámaka, geza ámina nagamí nemekako, nokinake nagamikumú goha nivisemiko, imaneloka gamena gamena oko nagamí iheva iheva oaká noumó nene ahulokinake navasú vizeko minatoha. ");
INSERT INTO gah_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Loko lokago, Izesú ezáa mogonamú gele hee litive loko láa loko lo amimó: Voko vaka nene alémoko ano. ");
INSERT INTO gah_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Loko lokago, vená nenémo váne nomimó nenae. Loko lokago, Izesú láa loko limó: Geza váne nomive loko lamaná lokanimóza, ");
INSERT INTO gah_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","géisi nene veló vanimó nene ligizani lugaloka asú igo vokanike animóma neve. Itó itínasa vonani ve nene geí vaka nomive. Nenemú geza soza lamane. ");
INSERT INTO gah_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Loko lokago, vená nenémo láa loko limó: Ve lamanámaka, itínasa mota gelekuve. Geza Ómasímini agepagutí gakó loaká ve noane. ");
INSERT INTO gah_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Leza Samalia vegenalitini avotege nene imaneló Gelizim agokaló Ómasi geké limiaká amó. Itó Zuta ve lekeza Zelusalega Ómasi geké lotatune liki liaká niamóma neve. ");
INSERT INTO gah_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Loko lokago, Izesú láa loko limó: Vená geza lo gimitoze, geleko alezo. Gamena makó alitokaze. Nene alitokiko nene, aménehini imane agokalokó negopa, itó Zelusale numutokagó negopa, mukí apatoka gupá zi amiki monola litave. ");
INSERT INTO gah_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Lekeza gili gopa iki nene gupá zi amiaká niave. Lukugutó vizeaká nene Zuta ve lelitokatí utó itinazo, Zuta ve lélisi gele hee lo nounike Ómasi gupa ze ameaká noune. ");
INSERT INTO gah_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Gamena makó alitanogo ive. Itó imane litá oko mota alitokaze. Nenemú vegenala zuha lamaná keza kigikatunú itó gakó gihilatunú aménehini gupá zi aminigave. Améneho nenéminiki gupá zi amita vegenakumú vitagá noive. ");
INSERT INTO gah_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ómasi nene sikalahú nenazo, leza Ómasímini Sikalahulímini zámuzatunú itó gakó gihilatunú gupá ze amitune. ");
INSERT INTO gah_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Loko lokago, vená nenémo láa loko lo amimó: Gologí oletative loko lo mololeta ve (leza Kilistó ave loaká nouhá ve) utó itive liki likago gelenoumó nenazo, nene mota gelekuve. Eza utó okoko netá matá mukí nene lo utó o asú inogo ive. ");
INSERT INTO gah_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Loko lokago, Izesú gakó lo nogumu ve nénisi nene noumole, loko lo amimó. ");
INSERT INTO gah_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Loko noligo, izegipala zuha leza okunike, ámina Samalia venaki gakó lasimó nenemú sigaga lomikunike, nanetakumú nolihe itó nanamú gakó lo namihe loko loká otanogo gena livisekago ahulunimó. ");
INSERT INTO gah_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Lá okago, vená nenémo nagamí goni nene ahuloake, ololu loko taoniloka vike mukí vegená láa loko lo kimimó: ");
INSERT INTO gah_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Lekeza iki imane ve ánigalo. Ánigonamu ve áisi nene asugunatoka oko moloko umó nene gakó lo utó molo asú onimikave. Lá imó nenazo, eza gologí oletative loko lo mololeta vema noitihe. ");
INSERT INTO gah_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Loko lokago, numutokatí lemeke Izesú noitoka anitikago, ");
INSERT INTO gah_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","izegipala zuha leza gala vizeko monó gizapa velemaka, nosánetá nozo. ");
INSERT INTO gah_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Loko lokuko, eza láa loko lo limimó: Nosánetá haitolímini nenitoka nemóza lekeza gelemave. ");
INSERT INTO gah_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Loko lokago, lezatetoka logele hagele unike makolímo nosánetá makó ale ma amekago lihe. ");
INSERT INTO gah_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Loko lokuko, eza limó: Nimisilimó eza lititoka molatitoka oko hoza gakó lonetamó nene nalumó nenémo nosánetáne neve. ");
INSERT INTO gah_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Lekeza ikani losive makole goloko helekiko nosánetá omolanogo ive liki liaká niamóza, lo likimitoze, gililo. Lokogómula pulusiki aménehini mini nene ánigalo. Nosánetá mota omolamó nenémini iki vegená kigika mota ali vavá iki niminave. ");
INSERT INTO gah_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Loko lo nolukumu gakó nenémini hozaváa alita ve nenete meinaváa alinigave. Alikiko vegená makolite alévolé kemetameni ali luhanigave. Lá ikiko, kigikagú monó zuha atilí a vegi gihila lege vegi ali apiziiki kogoliza vizinigave. ");
INSERT INTO gah_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Lá okiko, makolímo zuhá okago, makolímo gihila lege moloaká noive liki liaká nia gakóma alévolé inogo ive. ");
INSERT INTO gah_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Lekeza ali zuhá amikima gihiláa ligitave loko likimiselekumóma neve. Vegená makolite hoza aliki ali zuhá ikago mota omolokago, lekeza hozaninímini gihila hanuva milikave. ");
INSERT INTO gah_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Loko lokago, Samalia vená nenémo netá matá oko moloko umóma lo utó molo asú onimikave loko lo kemekago, ámina apakú vegená mukilite Izesukumú gili alévolé amó. ");
INSERT INTO gah_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Lá iake, Izesutoka vi anitiake, makó minatune liki alesa milikago, gamena lositá kezagi makó minamó. ");
INSERT INTO gah_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Kezagi minake monó lo kimigo, mukilite gili seketigí amó. ");
INSERT INTO gah_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Lá iake, ámina vená nene láa liki li amemó: Leza ganáma nene géisi avetó okako geleháma neve. Lá unimó nemóza, itínasa nene ezáa agepagutí gakó ligo gelekunike gele alévolé okune. Áisi lamaná numutó namató ve lelí lugutó vizeaká ve noive loko mota gele alévolé okune, liki lamó. ");
INSERT INTO gah_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","44","Izesú ganá nene Ómasímini agepagutí gakó liaká ve kezáini numuni apáitoka minikikoma nene, ma kilími napa aminigave loko likumú nene Izesú eza kezagi gamena losima minoake, Galilaia mikasiuka vimó. ");
INSERT INTO gah_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Galilaia mikasiuka vo anitekago, Galilaia vegená keza amunaloka Zelusalega viake avóikini asenini zeketakumú gele minoaká holisigú eza hoza aligo ánigamó nenazo, nenemú Izesuni alími milamó. Lá ikago, Kana numutoka Galilaia mikasigú nene amunaló emane Izesú lokago hanuva nagamilímo vain nagamí loló i numutoka atiginá oko vimó. ");
INSERT INTO gah_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Voko noigo, Kapanao numutoka kiapé makolímini gipala avisekago, noigo, ");
INSERT INTO gah_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Izesú eza Zutaia mikasi ahuloko goha atiginá oko Galilaia mikasiuka oko nanitive liki likago, geleake ámina kiapé nene gipala helesakosá oko noigove loko Kapanao numutoka alémoko vitove loko Izesutoka vike negénegeka limó. ");
INSERT INTO gah_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Negénegeka lokago, Izesú nene lekeza lu avevezaha la avevezaha nougo, ánigiake gakóne gili aliaká niahe. ");
INSERT INTO gah_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Loko lokago, ámina vémo limó: Ve lamanámaka, gipáne helekatize, litá oko lomano. ");
INSERT INTO gah_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Loko lokago, Izesú nene geza hanuva vozo. Gipaka mota zokokave. Loko lo amekago, ámina vemámo Izesuni gakó gele aleake, atiginá oko vimó. ");
INSERT INTO gah_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Novigo, gó lokago, gelekelé vemate gapoló anitiki gipaka mota zokoake noive. ");
INSERT INTO gah_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Liki likago, zoka gamenamú loká oketago, keza azozá ho luseteló nego agupegú govisi alike hakalotave. ");
INSERT INTO gah_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Liki likago, gipámini amelaho nene mogonamú lá oko gilimó: Ámina gamenaló Izesú nimisilike gipaka mota zokokave loko limóma neve. Loko geleake, ezáagi vená izegipalagi Izesukumú gili alévolé amó. ");
INSERT INTO gah_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Izesú nene Zutaia mikasiukatí oko Galilaia mikasiuka atiginá ike lu avevezaha la avevezaha nene igo, losi imó. ");
INSERT INTO gah_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Minoko Zuta vetini holisi napa makó alitokago, Izesú nene Zelusalega itimó. ");
INSERT INTO gah_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Neneló sipsip izatini gatetó nene nonohuló makó minamó, agulizaláa Petezata. Agilikaloka gaizopa numuni ligizani lugaloka asú igo minamó. ");
INSERT INTO gah_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ámina numukú nene kivisi vegená, kogómulaló ali vegená, kigisaló ali vegená, kigisa kigizani nakeseta vegená mukí aki miniaká amó. ");
INSERT INTO gah_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Lá amó nene Guivahanímini ageló makolímo gamena makó zupa lemeaká noike ámina nagamí ale heipeí oaká itotí ámina nonohulokú ganá limi ve nene avisi netakutí zokoaká imó nenazo, keza nagamíma heipeí itikumú gizapa iki minamó. ");
INSERT INTO gah_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Lá iki minakú nene ve makó agisa genisi i ve izolaho getakutí kilisimasi 38 oko novigo alímiki áminaló ahulikago minamó. ");
INSERT INTO gah_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Noigo, Izesú eza ámina ve ánigoake, gamena hána hána minokave loko geleake, loká otake geza zokatove loko ma gelenape. ");
INSERT INTO gah_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Loko lokago, agisa genisi i vemámo limó: Ve lamanámaka, hí ve noitímo nagamí nonohulóma heipeí noiko nagamikú nelémo molokiko zokatove. Liminogo nougo, makolímo litá oko nivilegeake lemeaká noive. ");
INSERT INTO gah_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Loko lokago, Izesú láa loko lo amimó: Geza oteoko avilisaka geheko gapo moloko vozo. ");
INSERT INTO gah_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Loko li agepagi agisa golesa i vemámo agisa pehe lo ahuloake, oteko avilisala geheko gapo moloko vimó. Ámina hoza nene holisi zupa alimó. ");
INSERT INTO gah_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Nenemú Zuta vegenalitini monó gizapa vete ve zokamó nene itína holisimagú nenazo, avilisaka ale nogehenimó nene amosá suni alekane. ");
INSERT INTO gah_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Liki li amikago, eza láa loko lo kimimó: Nelémo zoka vemámo avilisaka geheko gapo moloko vozo loko loake nimiselekago aleko nouve. ");
INSERT INTO gah_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Loko lokago, keza láa loko lo gimi ve agulizá éahoma neve. ");
INSERT INTO gah_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Liki lamóza, Izesú nene mulusi ikú holúikú legesá oko vimó nenazo, alémo zokago mina vemámo agulizaláa gelemimó nenazo, ");
INSERT INTO gah_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","gelemuve loake, monó zavusavegú iteko noigo, Izesú minoko aí ánigoake láa loko lo amimó: Gugupega mota lamaná okaze. Nenemú alika genavagi netá gizalekatanize, lihima netá goha alemo. ");
INSERT INTO gah_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Loko lokago, ámina ve eza Izesuni ánigo hee loake, vike Zuta gizapa vema ánigoake nelémo zoka vémini agulizá Izesúma neve, loko lo kimimó. ");
INSERT INTO gah_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Holisigú holisigú hoza nenémináa aleaká ikumú nene Zuta vegenalitini monó gizapa vete nenelotí apí iki gopoguni militake lovaga li amemó. ");
INSERT INTO gah_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Lá ikago, Izesú láa loko lo kimimó: Améneho hoza aleaká noimó nene holisi gamenagi miní ameko aleaká noive. Itó nezagi áminagó oko aleaká nouve. ");
INSERT INTO gah_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Loko lokago, Izesú nene Zuta vetini holisi ale gopa ikumú, itó Ómasimú nene aménehove like Ómasigi nezagi lelegí oko nousive loko likumú nene Zuta vetini monó gizapa vemate ámina netá lositakumú nene gili golesa goha ake, apele hilitune liki amuza golesa miliaká amó neve. ");
INSERT INTO gah_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Lá okago, Izesú nene gakó láa loko lo kimimó: Neza lamaná lo likimitoze, gililo. Neza Ómasímini gipala noumóza, nezáne nagata geleko hoza alitomoláa nomive. Améneho alimó nene ánigouke áminagó oko aleaká nouve. Améneho oko moloko noimó nene gipala neza ánigouke, áminagó oko oko moloko oaká nouve. ");
INSERT INTO gah_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Améneho nene gipala není ánigo amu heleaká noike, hoza nalimó nene nelepize asú oaká noive. Itó lekeza hoza nalugo ánigiaká niamó nenegó nomive. Lekeza ánigiiki sigaga linitatave loko améneho eza hoza napa lekelepizitove loko neve. ");
INSERT INTO gah_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Améneho eza hele vegená kelémo otike kelémo lamaná oaká noimó ámináminoko gipala neza aipe aipe kemetameni gosohá kimitove loko hanuva kiminogo uve. ");
INSERT INTO gah_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Améneho eza vegenalitini lihimamú lo hukoketosá amive. Ámina hoza mukí nene gipala není nigizakú molokamó nene ");
INSERT INTO gah_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","vegená mukilite aménehini agulizá ali otiaká niamó nenémini iki gipala není nugulizá ali otitave loko neve. Makó keza gipala není nugulizá ali otema vegenalite gipala nimisilimó aménehini agulizá ali otemamó geleaká noive. ");
INSERT INTO gah_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Neza lamaná lo likimitoze, gililo. Makolímohe makolímohe není gakó gelekoko nimisili vemú gele alévolé onoimó nenémo alévolé ametameni mota alekave. Alika lihimalamú goha goní aminogo ive. Heleaká ametameni nene ahuloake alévolé ametameni mota aleake noive. ");
INSERT INTO gah_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Neza lamaná lo likimitoze, gililo. Gamena makó alitanogo ive. Itó imane litá oko mota alitokave. Neneloka helemó nenete Ómasímini gipala není nonó lupa giliiki otiiki minanigave. ");
INSERT INTO gah_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Améneho eza alévolé oakalímini mogonáa neve. Gipala neza áminagó oko alévolé oakalímini mogonáa minatane loko nimisilimó. ");
INSERT INTO gah_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Lá okago, neza okulumakutí lumu ve gihila nounazo, améneho nene mukí vegenalitini lihimáinimú lo hukoketatane loko lonetamóma neve. ");
INSERT INTO gah_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Imane nolu gakó giliiki nene ininá amilo. Gamena makó molamó nene hanuva neze. Nene alitokiko, gonosi apakú akinamó keza nonó lupa giliiki, ");
INSERT INTO gah_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","galegutí otinigave. Lá iiki netá lamaná aliki minamoláa keza alévolé kemetamenigi otinigave. Itó netá golesa aliki minamoláa keza otikiko, lihima kiminogo uve. ");
INSERT INTO gah_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Lá itomóza, nezáne nagata geleko hoza alitomoláa nomive. Améneho lokiko nene, lihimamú lo hukoketanogo uve. Lá inake, lihimamú hoza alekugo, etanogo ive. Ámina hoza alitomóza, nezáne nagata geleko alemoko nimisilimó áisi lititoka molatitoka oko alinogo uve. ");
INSERT INTO gah_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Nezáne mogonáne lo utó itomó nene, gihila zemitinazo, ");
INSERT INTO gah_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","makolímo mogonáne lo utó okiko gihila zinogo ive loko nene gelenouve. ");
INSERT INTO gah_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Lekeza Zonitoka ve makó kimisilikago, keza loká imikago, eza gakó gihila lo utó onoimóma neve. ");
INSERT INTO gah_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Vegená neneta mogonáne ánigiiki hizi lé initatave loko lamuve. Hanuva giliiki alévolé lekemetameni aliiki alévolé gapogú vitave loko lekelikumú nene noluve. ");
INSERT INTO gah_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Zoní eza lamaná liví napa loló oake, hize hanatoleketonoigo, lokogoliza viziki minamó neve. ");
INSERT INTO gah_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ómasímo není hize lé onimiaká noimó nene Zonini avilegeko haitolíminoko neve. Améneho haitopaitó hoza alitane loko hoza gakó lonetamó nene ámina hozámini gihila ale utó okugo, améneho nimiselekago lumumómámini mogonáa utó oaká noive. ");
INSERT INTO gah_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Améneho nimisilimó áisi mogonáne lo utó oaká noimóza, lekelisi nene aí anó lupa gilisá amamóma neve, itó aí ánigisá amamóma neve. ");
INSERT INTO gah_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Lekeza améneho nimisili vemú gili alévolé amanazo, aí gakó nene likigikagú minamive. ");
INSERT INTO gah_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Lekeza nene monó gotola mota alenoune liake, alévolé oko minoakalímini gakoláa nenegú neve liki giliake, agizaka hiziki miniaká niave. Itó není mogona nene ámina luhuvagú utó noimóza, ");
INSERT INTO gah_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","lekelisi nene nenitoka iki gímiziiki alévolé lekemetamenigi itanazo, gopa ahulinimiaká niave. ");
INSERT INTO gah_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Itó vegenalita nugupe aliki ititave loko losá amumóza, ");
INSERT INTO gah_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","lekelí mogonáa nene lamaná gelenouve. Likigika nene Ómasiloka milisá amave. ");
INSERT INTO gah_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nénisi nene aménehini gakotó moloko lekelitoka lumumopa, lekelisi nene geha zi nimisá amave. Minoko ve makó ezáa agata geleko anitekikoma nene, geha zi aminigave. ");
INSERT INTO gah_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Lekeza nene vegenalite lilími napa itave liki giliake, Ómasi hamokolímo lelémo napa itive liki makó lisá amave. Lá ikanazo, nana iiki Ómasimú gili alévolé itave. ");
INSERT INTO gah_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Lekeza nenikumú nene Ómasi amelahini avogisaló goní oletatimó nehe liki lamilo. Lá oko nomive. Lekelisi nene Moseni gakotoka leheta iaká niave. Ámina ve Moseni gakó nenémo goní oleketanogo ive. ");
INSERT INTO gah_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Áisi nene luhuva gizamó nene nenikumú gizonoimóma neve. Nenemú lekeza aí gakó gili alemó nelina nezamuki gili alévolé aline. ");
INSERT INTO gah_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Lá onoimóza, Moseni luhuva gakó gili ahulikamó nenazo, není gakó nene nana iki gili guni itamó neve, loko lo kimimó. ");
INSERT INTO gah_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Izesú eza ámina gakó lo asú oake, Galilaia nonohuló agulizá makó Tipelia loko noi nonohuló likeko vo helega imó. ");
INSERT INTO gah_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Voake kivisi vegená mukí kelémo zoka zoka ike, lu avevezaha la avevezaha igo, vegenalite ánigiake, ámegetiki viki minamó. ");
INSERT INTO gah_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Lá niago, Izesú nene izegipala zuha lelémoko agokaú iteko minunimó. ");
INSERT INTO gah_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Gamena nene zupa Zuta vetini avóikini asenini zeketakumú gili mina holisi alitokago, ");
INSERT INTO gah_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Izesú nene vegená mukí aitoka nanitego, ánikogoake, Piliponi nene loká otake nosánetá hikutí meina hizeko kimitune. Láa vegená alegesá amó imanete niko vo holoma itimó neve. ");
INSERT INTO gah_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Loko limó nene Izesú eza netá matá oko moloko itimó nene nego, hanuva gimivagú moloko limó. ");
INSERT INTO gah_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Lokago, Pilipó nene moni gó ligizani lugaloka asú igo ahuloko nosánetá meina hizeko kimitunimóza, ma vo aleminogo ive. ");
INSERT INTO gah_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Loko lokago, izegipala zuha lelitokatí makó Saimon Pitani agunala Etulú áisi nene láa loko limó: ");
INSERT INTO gah_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Imaneuka izegipa makó noimó áisi peleti ligizani lugaloka asú igo itó lagaha lositá aleneimóza, vegená mukí nianazo, ánenéatunú nana itune. ");
INSERT INTO gah_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Loko loká okago, Izesú nene lekeza vegenáma li kimikiko mikasiló mini gesá iki minino loko lo limimó. Ámina apató nene tau lamaná minamó nenazo, neneló ve 5 tausen ale alitoko nenéminiki limiki mini gesá ikago, ");
INSERT INTO gah_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Izesú nene ámina peleti aleake, Ómasi agepoka loake, alegesá iki mina vegená gona moloko kemeake, ámina oko lagahama kimimó. ");
INSERT INTO gah_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Kemekago, niki niki kagatupa okago, Izesú nene izegipala zuha lo limike lumatamáa minoko latila okatize, gizaká ilo. ");
INSERT INTO gah_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Loko lokago, leza peleti ligizani lugaloka asú igo kemekuko namó nenémini lumatamáa ale nupa oko gosúveha 12 vaí okago ale mulunimó. ");
INSERT INTO gah_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Lá okago, golivagi alévolé netá lá oko loló igo, vegená keza ánigiake, imane lamaná Ómasímini agepagutí gakó loaká ve napa makó mikasigú utó itive liki lina vema noitive. ");
INSERT INTO gah_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Liki liake, Izesuni hizi vigiake, agulizaki venini lilí itanigi ago, ánigoko geleake, ahulokimiake ezáagó agoka makotoka itimó. ");
INSERT INTO gah_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Iteko noigo, únaká molokago, izegipala zuha leza nonohuló agilikaloka lemehá. ");
INSERT INTO gah_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Lemeko Kapanao numutoka atiginá oko vinogo nagamikú lapegú noituko, límugusi litihokago, Izesú velesá amigo, lezategó vunimó. ");
INSERT INTO gah_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Novuko, ohuhú napa alike, nagamíma valahuká napa nozigo, vunimó. ");
INSERT INTO gah_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Leza nene kilomita 5-ahe itó 6-ahe ahulokunike novuko, Izesú nene nonohuló amupiló liso liso vike lugupeló naligo, ánigokunike, lehelele vizimó. ");
INSERT INTO gah_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Lehelele novizigo, Izesú nene lekelegesá legemino. Nénisima nouze. ");
INSERT INTO gah_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Loko lokago, sipigú alémo molanogo nouko, áminasitó vitune loko luni apatoka nene vo anitunimó. ");
INSERT INTO gah_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Akunike gó lago, vegená mukí nonohuló vola helega minamoláa keza láa liki lamó: Holugú sipi hamokó imaneló nego ánigunimó. Nenegú izegipala zuha kezáikó Izesuni ahuliake vikamó nenazo, Izesú hitoka vonoitive. ");
INSERT INTO gah_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Liki kagata gululusi giliake niago, Tipelia apatokatí vegená makó nene sipi makokú itiake Guivahanímo Ómasi agepoka loake peleti kemekago namómaló imi anitemó. ");
INSERT INTO gah_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Anitiake, mukí vegenalite Izesuge izegipala zuha niamago, vitagá iake, ámina sipigú itiake, Izesukumú vitagá itune liki Kapanao numutoka atiginá iki vamó. ");
INSERT INTO gah_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Nonohuló imane helegaloka vitagá iki iki alími utó miliake Monó gizapa velemaka, geza nana oko ane. ");
INSERT INTO gah_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Liki likago, Izesú láa loko lo kimimó: Neza lamaná lo likimitoze, gililo. Lekeza lu avevezaha la avevezaha ugo ánigiake, nenikumú vitagá niahe. Lá oko nomive. Peleti lukumugo, niki niki lakagatupa okago vitagá niave. ");
INSERT INTO gah_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Lekeza hozaváa alilo. Haha iti nosá nenemukopa, alévolé oko minoaká nosánetá nenémini hozaváa alilo. Okulumakutí lumu ve gihila neza Ómasi aménehini anosa alenou ve neza alévolé oko minoakalímini nosánetá lamaná likiminogo uve. ");
INSERT INTO gah_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Loko lokago anotó aliki Ómasímo giliko lamaná itive loko nana hoza alitune. ");
INSERT INTO gah_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Liki loká ikago, láa loko lo kimimó: Ómasímo hoza alitave loko loleketonoimóma nene nimisili ve nenikumú gili alévolé itave lokoma nenae. ");
INSERT INTO gah_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Loko lokago, láa liki li amemó: Alévolé suni makó ale utó okako, ánigokinake, geikumú gele guni itune. Nana hoza makó alitane. ");
INSERT INTO gah_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Avotege keza gozapá mikasi gomopalaló minamómaló nene mana nosakó niki minamóma neve. Nenémini luhuva gakó nene Okulumakutí nosá kimigo niki minamó neve liki gizinamóma neve. ");
INSERT INTO gah_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Liki likago, Izesú láa loko lo kimimó: Lamaná lo likimitoze, gililo. Mosé nene okulumakutí nosá lekememimóma neve. Améneho nene likimimó. Itó okulumakutí nosá gihila lekemeaká noive. ");
INSERT INTO gah_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Nosánetá nene okulumakutí mikasigú limimó nenémo alévolé oko minoaká nene ale utó olekemeaká noive. Nenémo nene Ómasilokatí nosánetá gihila neve. ");
INSERT INTO gah_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Loko lokago, Guivahani geza nosánetakumú lanimó nene gamena gamena limitanize. ");
INSERT INTO gah_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Liki li amikago, Izesú láa loko lo kimimó: Alévolé oko minoakalímini nosánetá nénisi nene nouve. Makó keza nenitoka iki gímizitamó nene gaúna heleminigave. Itó nenikumú gili alévolé itamó keza nagamikumú kiviseminogo ive. ");
INSERT INTO gah_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Neza nene lo lekemeaká noumóza, lekeza nene gili ahuliake, gili alévolé amave. ");
INSERT INTO gah_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Mikasiuka vegená nene améneho nemeaká noi vegená keza mukí nene nenitoka anitinigave. Nenitoka anitita vegená nene ma kehelú aminogo uve. ");
INSERT INTO gah_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Okulumakutí lumumó není negepagú gakó hize lé itove loko lememuve. Nimisili vémo lititoka molatitoka oko hoza alitove loko lumumóma neve. ");
INSERT INTO gah_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Améneho nene nenitoka kelémo mola vegená latila ikatave loko kelémo nupa okinake gamena napaló avasavagi kelémo otekugo, otinigave. Nimisili vémini agepagutí gakó lá oko neve. ");
INSERT INTO gah_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Gipala ánigi hee li miniki aikumú gili alévolé itamó keza alévolé kemetameni alikiko, gamena napaló kelémo ote asú inogo uve. Aménehini gakó nenéminoko neve. ");
INSERT INTO gah_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Loko Izesú nene okulumakutí nosánetá nénisi nouve loko likumú nene Zuta vetini monó gizapa vete gili golesa iake géneka lake, Izesukumú láa liki lamó: ");
INSERT INTO gah_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Imane ve nene Zoseheni gipalama neve. Itó izolahiko amelahiko nene ánigo nouháma nenazo, neza okulumakutí lumumóma neve loko nanamú loaká noive. ");
INSERT INTO gah_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Liki likago, Izesú láa loko lo kimike limó: Lekeza gilikiko golesa amino. ");
INSERT INTO gah_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ve makó nene kezáini kigikatunú giliiki nenitoka iki gímizeminigave. Améneho nimisilimó eza kelémoko okiko, iki anitinigave. Lá okiko, neza nene vegená nenémináa gamena napaló kelémo otinogo uve. ");
INSERT INTO gah_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ómasímini agepagutí gakó liaká a vete gakó láa liki luhuva gizinamóma neve: Ómasi ezáa vegená mukí nene monó lo kemeko apí okiminogo ive. Liki gizinamó nenazo, améneho monó lo kimiko gilitamó keza nenitoka anitinigave. ");
INSERT INTO gah_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ve makolímohe makolímohe aménehini ánigosá amimóma neve. Ómasilokatí lumumó nénisi hamokó nounazo, nezagó ánigonouve. ");
INSERT INTO gah_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Neza lamaná lo likimitoze, gililo. Nenikumú gili alévolé ina vegená kéisi nene alévolé kemetameni mota alikave. ");
INSERT INTO gah_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Alévolé oko minoakalímini nosá nénisi nene nouve. ");
INSERT INTO gah_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Avotike keza mikasi gomopalaló mana nosakó niliki nivake alika helemó. ");
INSERT INTO gah_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Itó okulumakutí nosá nokoko helemoakalímini imane nenitoka nene neve. ");
INSERT INTO gah_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Alévolé nosá okulumakutí limimó nene nénisi nene nouve. Nenemú makó keza nenitokatí nosánetá natamó nene, alévolé iki mini lúaló miliki viki minanigave. Mémelánémo nene nosánetá loló onoive. Numutó namató vegená lekeza alévolé lekemetamenigi minatave loko likiminogo uve. ");
INSERT INTO gah_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Loko lokago, Zuta ve keza pelevesava zeke áisi nana okoko mémeláa limiko natunikumú live. ");
INSERT INTO gah_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Liki likago, Izesú ezáa zohota zaló hilitimó nenémini gihila ali lá itakumú anoza gakó láa loko lo kimimó: Neza lamaná lo nolukumuve. Lekeza okulumakutí lumu ve gihila není mémelagi golanigi namitamó nene, alévolé lekemetameni aleminigave. ");
INSERT INTO gah_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Makó keza není mémelagi golanigi natamó nene, alévolé kemetameni mota alikago gamena napaló kelémo otinogo uve. ");
INSERT INTO gah_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Není mémela nenémo nosá gihila neve. Itó není golani nenémo nagamí gihila neve. ");
INSERT INTO gah_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Není mémelagi golanigi ninamó nenete neniki ali akisikave. Neza ámina oko keí ale akisekuve. ");
INSERT INTO gah_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Améneho alévolé vémo nimiselekago, lemekumole loko aí gelegele nominuve. Ámina iki není mémeláne nata vegenalite není gelegele minanigave. ");
INSERT INTO gah_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Okulumakutí limi nosalímini mogonáa lá oko neve. Avotike gozapá namómáminoko nomive. Kéisi mana nosánetakó niliki vake alika helemóma neve. Itó není nosá imane natamó nenete mini lúaló miliki alévolé kemetamenigi minanigave. ");
INSERT INTO gah_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Loko Izesú eza Kapanao numutoka minake monó numukú itike, ámina monó nene lo kimi gakó neve. ");
INSERT INTO gah_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Lá okago, aí vegenala zuha keikutí mukilite ámina gakó nene giliake, kezáitoka nene gakó imane gelehá nene gena okanazo, nene éaho gele hee loko amegesa molative. Liki goseleka likago, ");
INSERT INTO gah_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Izesú nene agikatunú geleake, láa loko limó: Gakó nene gilikago golesa okahe. ");
INSERT INTO gah_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Okulumakutí lumu ve gihila neza goí oko minu apató atiginá oko noitugo, lekeza ánigatamó nene, nana itamó neve. ");
INSERT INTO gah_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Lugupémini mémela nenémo alévolé lemetameni ale utó oakaláa nomive. Alévolé lemetameni loló oaká nene Sikalahulímini hoza neve. Itó gakó lo nolukumumó nenémo alévolé lekemetameni ale utó oaká gakó neve. ");
INSERT INTO gah_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Láa loko lo lukumumóza, lekelikutí lugáa nenete gili alévolé amave, loko limó. Izesú nene monola gili ahulata vegenala nene hozava apí i zupa mota geleneimó neve. Itó amimika liti ve ámina oko geleneimóma neve. ");
INSERT INTO gah_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Nenemú ámina gakó lo kemeake, miní ameko láa loko lo kimimó: Neza nenemú láa loko lo nolukumuze, gililo: Makolímo améneho alémo vávani amiko nenitoka omo aniteakaláa nomive. ");
INSERT INTO gah_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Loko lokago, ámina zupa nene vegenala zuha mukilite ezagi minanigi goselé kepelekago, kemegesa amiake vikago, ");
INSERT INTO gah_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Izesú nene izegipala zuha 12-ama loká oletake lekezagi ámina iki ahulinimiiki vitune liki nilahe. ");
INSERT INTO gah_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Loko lokago, Saimon Pitá láa loko lo amimó: Guivahani geza ahulogimikinake éahitoka vitune. Geza hamokó alévolé oko minoaká gakó loaká noane. ");
INSERT INTO gah_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Leza nene geikumú mota gele alévolé onoune. Geza Ómasilokatí apazá keké vizeko noani ve noane loko gelenoune. ");
INSERT INTO gah_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Loko lokago, Izesú láa loko lo kimimó: Neza izegipa 12-a lekelémo etó okumóza, lekelitokatí makó nenémo Satatoka mino molokave. ");
INSERT INTO gah_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Loko limó nene Kaliotó numutotí Saimoni gipala Zutá eza Izesuni vegenala zuha 12 lelikutí vémo minoko amimika litikumú limó neve. ");
INSERT INTO gah_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Lá okago, Zelusalegatí Zuta vegenalitini monó gizapa ve keza Izesuni apele ahulatune liki amuza milikago, Zutaia mikasi nene ahuloake Galilaia mikasigukó vogá ogá oko minamó. ");
INSERT INTO gah_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Lá oko noigo, avóike minumuni gekumú gili mina holisi alitokago, ");
INSERT INTO gah_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Izesuni agunamotamolate láa liki li amemó: Vegenaka zuha keza lu avevezaha la avevezaha oaká noanimó nene ánigatave loko imane apá ahulokoko voko Zutaia mikasiloka loló okako ánigatave. ");
INSERT INTO gah_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Makó nenémo omo utó itove lokoma asuguná minoko hozaváa ma alesá amive. Geza hoza nenémináa alitove lokoma, voko vegená kovogisaló utó okoko aliko ánigatanazo, ");
INSERT INTO gah_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","liki izegipa agunamotamola keza lamó nene, aikumú gili alévolé amake láa liki likago, ");
INSERT INTO gah_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Izesú nene láa loko lo kimimó: Lekeza netá matá loló itune liki litá iki lilí itamóza, Zutaia apató vito gamenaváne velesá alitamive. ");
INSERT INTO gah_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Monó gelema vegenalite mukahá lekepeleminigave. Neza nene miniki aliki ago golesa imoláa lo utó oaká nou netató gasó nimiaká niave. ");
INSERT INTO gah_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Lekeza nene holisigú vilo. Neza nene gamenáne alitaminazo, itínasa ma tovaminogo uve. ");
INSERT INTO gah_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Loko loake, Galilaia mikasiuka minamó. ");
INSERT INTO gah_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Minokago, agunamotamolate goí iki holisi minatune liki Zelusalega tivikago, ezagó nene alika olío hizeko tovo imó. ");
INSERT INTO gah_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Notovo igo, holisi nene alitokago, Zuta ve keza aikumú lokatoká iki hiláauka voko noitive liki vitagá amó. ");
INSERT INTO gah_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Lá iki mihina iki vitagá niago, mukí vegenalite aikumú musímusika liki nilake lugáate Izesú nene ve lamanáma neve liki likago, lugáate géneka liake ahulalo, áisi nene vegená kelémo gopa napa oaká noive. ");
INSERT INTO gah_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Liki lamóza, Zuta vetini monó gizapa vemú kehelele vizekago, gakó napagutí lamake asugunatoka lamó. ");
INSERT INTO gah_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Lá ikago, holisi holulagú Izesú nene monó zagusavegú itike monó apí okimike limó. ");
INSERT INTO gah_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Lá oko noigo, Zuta ve keza sigaga lake áisi nene lelí sukulu lamimóma nemóza, monó mogona hiláaukatí geleaká imó nolive. ");
INSERT INTO gah_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Liki likago, Izesú láa loko lo kimimó: Neza monó apí olikimiaká noumó nene nezáne geleko lo lekemesá amuve. Nimisili vémitokatí geleko lo lekemeaká nouve. ");
INSERT INTO gah_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Makó nenete Ómasímo lititoka molatitoka oko alitune liki gilitamó nene, alika Ómasilokatí nehe nenitokatí nehe nene ámina monokumú gili hee linigave. ");
INSERT INTO gah_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Makó nenete kezáini kagata gilitató litamó nene kugupe aliki itiki linigave. Makó nenete kimisili ve hoza amelahikumukó agupe aleko ititune liki hozava alita ve nenete ve huluva, sozagi nomi vegená niave loko litune. ");
INSERT INTO gah_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Lekelikutí Mosé eza lo hukoko lo likimi gakó amegesa mila vegená ma niamave. Nenemú lekelisi nene nanamú nipilitune liki liaká niave. ");
INSERT INTO gah_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Loko lokago, vegená mukilite lamó: Geza matuka gopa okago nolape. Éaho gipilitove noligo nolane. ");
INSERT INTO gah_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Liki likago, Izesú láa loko lo kimimó: Neza holisi zupa avevezaha hamokó loló umó nene ánigiake sigaga linamó neve. ");
INSERT INTO gah_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Nenemú gililo. Mosé nene izegipatini kugupeló Ómasímini anosa milikitatave loko loleketamó nene, Mosé apí amimó. Avotike kezáini apí amóma neve. Lá okago, ámina hoza alita gamena alitokago, holisima neve liki lamiki ámina hoza hanuva aliaká niave. ");
INSERT INTO gah_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Nene Mosé lo hukoko li gakó haha okative liki Ómasímini anosa nene izegipatini kugupeló nene holisi gamenaló milikimiaká nianazo, nénisi nene holisi zupa ve gepili alémo lamaná ukumú lekeza nanamú gili golesa iaká niave. ");
INSERT INTO gah_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Lekeza ánigi lamaná amikima gakó galinali lamilo. Mogonaló gili hee hee likigó lilo. ");
INSERT INTO gah_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Loko lokago, Zelusale apá amelage luguhate láa liki lamó: Apilitune liki liaká nia vema imane nehe. ");
INSERT INTO gah_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Nana okago gakó utó nolitó imane kugulizaki vele nenete géneka litamave. Keza aí mogonáa giliki gili vevesamó Ómasímo gologí oletative loko lo mololeta vema noigo niahe. ");
INSERT INTO gah_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Lá oko nomive. Imane vémini getamoláa mota gelenoune. Gologí oletative loko lo mololeta vema utó itimómámini mogona ma gele vevesaminogo une. ");
INSERT INTO gah_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Liki lamó nene Izesú Nasalete numutoka utó ihe like giliake láa liki likago, Izesú monó zagusavegú nene monó apí oketoko noike gakó napagutí láa loko limó: Íi, lekeza mogonánegi není getamó mogonáagi gelenoune liki linamóza, lumumó nene nezáne nagata geleko lememuve. Lamanalímini amelaho noive. Áisi nimiselekago lumumóza, lekeza aikumú nene gelemave. ");
INSERT INTO gah_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Nénisi nene aí amatoka minutotí nimiselekago lemekumó nenazo, aí mogona gele vevesonouve. ");
INSERT INTO gah_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Loko lokago, Ómasilokatí lumumó neve loko likumú nagá aminigi amóza, gamenaváa alitamigove liki kigizató gena okago ahulamó. ");
INSERT INTO gah_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Lá ikago, keitokatí vegená mukilite aikumú gili alévolé iake láa liki lamó: Imane vémo lu avevezaha la avevezaha oaká noinazo, gologí oletative loko lo mololeta vema anititive liki lina vemámo Izesuni aviligitihe. Óve, avilegeminogo ive. ");
INSERT INTO gah_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Alegesá iki mina vegenalite láa liki nilago. Palisaio monó vegenalite giliake, keza guguni giziaká a ve napagi ligili hagili iake Izesuni nene nagá numukú alími milatave liki pilisi ve kimiselemó. ");
INSERT INTO gah_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Lá ikago, Izesú láa loko limó: Neza gamena koma lekelitoka mininake nimisili veloka atiginá oko vinogo uze. ");
INSERT INTO gah_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Lá okugo lekeza nenikumú vitagá itamóza, ma ánigaminigave. Voko minatotoka nene nana iki ititave. Ma iteminigave. ");
INSERT INTO gah_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Loko lokago, Zuta vete kezáitoka láa liki ligili hagili amó: Imane ve hitoka voko noiko vitagá itunikumú live. Zuta vegená Kiliki mikasiuka hutilí iki viki niamoláa keitoka voko minoko monó gakó apí o kemeko noiko vitagá itunikumú lihe. ");
INSERT INTO gah_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Lekeza nenikumú vitagá itamóza, ma ánigaminigave loko limó itó voko minatotoka ma iteminigave loko limó nene nana itikumú live, liki lamó. ");
INSERT INTO gah_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Zuta vegenalitini holisi napa nene asú inogo noigo, alegesá napa iki niago, Izesú oake gakó napa like láa loko lo kimimó: Makó keza nagamikumú kivisekikoma, nenitokatí iki natave. ");
INSERT INTO gah_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Itó monó gotolaú nenikumú gili alévolé ita vegenakumú nene kigikagutí monó nenémo nagamí lisani nenémini oko zeko minanogo ive liki luhuva gizinamóma neve. ");
INSERT INTO gah_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Loko Izesú limó nene ezáamú gili alévolé ita vegená nene Sikalahú lehizeketatove loko limó neve. Eza okulumakú gonanalisi lapanalámini agikagú velesá itenamikeve loko Sikalahú velesá lehizeketamike limóma neve. ");
INSERT INTO gah_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ámina gakó nene vegenalite giliake, lugáate Izesukumú nene lamaná Ómasímini agepagutí gakó loaká vele gakoláa gelekunike ageva nouhá ve imane noive. ");
INSERT INTO gah_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Liki likago, lugáate áisi nene Ómasímo gologí oletative loko lo mololeta vema noive liki likago, lugáate Izesukumú Galilaia mikasiuka utó ihe liki giliake pelevesava ziki láa liki lamó: Gologí oletati vema nene nana oko Galilaia mikasigutí utó itive. ");
INSERT INTO gah_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Monó gotolaú nene gologí oletative loko lo mololeta ve eza Tevitini apá gotola Petelehe apakú itó Tevitini agapilamó zuhagutí utó inogo ive liki luhuva gizinamóma neve. ");
INSERT INTO gah_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Liki liake, aikumú mini luga luga amó. ");
INSERT INTO gah_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Lugáate nagá amitune liki amó nene kigizató gena okago ahulamó. ");
INSERT INTO gah_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Lá iake, monó zagusaveló pilisi ve minamó keza atiginá iki vikago, guguni giziaká a vegi Palisaio monó vegi keza loká ikitake lekeza nanamú alímiki amave. ");
INSERT INTO gah_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Liki likago, pilisi vete áisi gakó nolimó nenémini iki ve makolite lisá amave. ");
INSERT INTO gah_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Liki likago, Palisaio ve keza láa liki lamó: Lekezagi ámina oko lokogoka vizekago nilahe. ");
INSERT INTO gah_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Monó gizapa ve lugáagi Palisaio ve lugáagi aikumú gelemó alévolé okago nilahe. ");
INSERT INTO gah_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Óve. Imane li huka gakó gelema vegená alegesá iki niamó nene usí vize kemenei vegenakó niave. ");
INSERT INTO gah_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Liki likago, keikutí ve makó Nikotemó nene amunaló emane límugusigú Izesutoka vi vemámo láa loko lo kimimó: ");
INSERT INTO gah_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Lekeza lilo. Ve makó nene mogonáa giliki lihimavala ánigamiki apilitune liki liaká niahe. Monó gotolaú lá oko nomive. ");
INSERT INTO gah_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Loko lokago, agivelage gahá amiki láa liki lamó: Gezagi nene ámina oko Galilaia mikasiukatí numuká ve noape. Monó gotolaú vitagá ova ova oko Galilaia mikasiukatí Ómasímini agepagutí gakó loaká ve makó utó itive loko keké nomive loko gilitanize.  ");
INSERT INTO gah_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Liki liake, hutilí iki numúitoka vi vi amó. ");
INSERT INTO gah_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ikago, Izesú nene Olivi agokaú itimó. ");
INSERT INTO gah_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Akiake gó lokago, ho sikí noligo, monó zagusavegú goha iteko noigo, vegená mukí áisi noitoka alegesá ikago, mitó minake monó apí o kimimó. ");
INSERT INTO gah_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Lainim-noketago, monó mogona apí ikimiaká a vegi Palisaio monó vegi keza vená makó moko mogonaló noigo ánigiake Izesutoka alímiki viki alími holukú miliake láa liki lamó: ");
INSERT INTO gah_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Tisalemaka, imane vená mokoló noigo ánigokunike alémoko nounimó lae. ");
INSERT INTO gah_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Itó Mosé eza lo hukoko li gakokú vená nenémináa gehanitunú kipili ahulalo loko loletonoimóma nenazo, géisi nanave loko nogelene. ");
INSERT INTO gah_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Liki lamó nene gakó lo gopa itihe liki gimivagú miliki lamó. Gakó nana oko litihe gelekinake neneló alémo moloko lokinake goní otatune liki agoka viziki lamó. Likago, Izesú gupá zeake mikasiló nene agizanitunú luhuva gizamó. ");
INSERT INTO gah_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Nogizago, keza loká imiake goha loká itago, oteake láa loko lo kimimó: Lekelitokatí ve makó lihimavala nomiti vémo apí oko gehanitunú apelekiko apililo. ");
INSERT INTO gah_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Loko loake, goha gupá zeake mikasiló agizanitunú luhuva makó gizamó. ");
INSERT INTO gah_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Nogizago gakola giliake, améipo ale goí oko vokago, hamopamó viká viká iki vi asú amó. Vikago, ámina venáma Izesuni amatoka noigo, ");
INSERT INTO gah_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Izesú okena oko gonú napilike loká otake vená geza gilímiki a vegená hitoka vave. Makolímo lihimakamú goní ogetamihe. ");
INSERT INTO gah_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Loko lokago, vená nenémo Guivahanínemaka, lá amave. Loko lokago, Izesú limó: Nezagi ámina oko lihimakamú goní ogetamuve. Nenemú voko lihima netá goha alemo, loko lo amimó. ");
INSERT INTO gah_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Alika Izesú eza vegená nene gakó miní ameko láa loko lo kimimó: Neza mikasiuka vegená lekelí liví nouve. Makó není némegetata vegená keza límugusi gapogú viki minaminigave. Alévolé lapaná aliiki minanigave. ");
INSERT INTO gah_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Loko lokago, Palisaio monó ve keza láa liki li amemó: Gezaka mogonaka lo utó moloko lanimó nene leza gelekuko gihila nomive. ");
INSERT INTO gah_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Liki likago, Izesú láa loko lo kimimó: Nezánéne mogonáne lo utó mulumó nene, neza hitokatí umó itó hitoka vitohe nenémini mogonáa gelenouke, gakó nolumó nene gihiláa neve. Lekelisi nene nemú manamú makó gilisá amave. ");
INSERT INTO gah_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Lekeza ha vegenalite lotuva ligiaká niató liaká niave. Neza mogonataganamú lotuva legeko hozaváa itína alemumóza, ");
INSERT INTO gah_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","neza mogonatagana lotuva legeko alulina nene nezánegó alitomoláa oko minamiline. Nimisili ve améneho nelémo vatí oaká noinazo, alitomoláa oko nene lotuva legeko hozaváa alitomó nene gihiláa zinogo ive. ");
INSERT INTO gah_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Mosé lo hukoko li gakokutí láa loko nemóma neve: Ve lositalitosa ve makolímini mogona li utó iki litái gakó nene hamó gapoló vokikoma lasi gakó nene gihiláa neve loko litune. ");
INSERT INTO gah_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Nezáne mogonáne nolugo, nimisili ve améneho nene ámina oko lo utó molonimiaká noive. ");
INSERT INTO gah_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Loko lokago, keza loká itiki amekaho hí noive liki likago, eza láa loko lo kimimó: Lekeza není mogona gili guni amake aménehinigi mogona gili guni amave. Lekeza není mogona gelelina, aménehini mogonagi ámina iki gili guni aline. ");
INSERT INTO gah_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Loko Izesú limó nene eza monó zagusavegú moni miliaká a pokisi mina agilikaloka minake, monó lainim-oketoko ámina gakó limóza, gamenaváa alitamigo ve makolímo oko nagá numukú alémo molamimó neve. ");
INSERT INTO gah_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Izesú miní ameko láa loko lo kimimó: Neza ahulolikimikinake vokugo, lekeza vitagá iiki lihimatinigi ha miniko hilinigave. Lá iki hiliiki nénisi voko minatotoka ma aminigave. ");
INSERT INTO gah_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Loko lokago, Zuta vetini monó gizapa vete neza voko minatotoka ma aminigave loko limó nene nanamú live. Ezáa agupe ale golesa oko hilinogo lihe. ");
INSERT INTO gah_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Liki likago, eza láa loko lo kimimó: Lekelisi nene amunalokatí niave. Nénisi veletokatí nouve. Lekeza mikasiukatí niamóza, neza mikasiukatí minamuve. ");
INSERT INTO gah_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Lá onoimó nenazo, neza nenemú lihimatinigi ha miniko hilinigave loko lo lekemekuve. Neza imane minoko mogonáne lo nolukumumóza, lekeza Ómasilokatí lemeni ve noane liki gili alévolé amitamó nene, lihimatinigi ha miniko hilinigave. ");
INSERT INTO gah_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Loko lokago, loká itiki Olo, éahoma noane. Liki likago, Izesú láa loko lo kimimó: Apí oko mikasiuka lumutotí lo lekeme-loko voaká noumó lae. ");
INSERT INTO gah_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Neza lekelí lihima gakó mukí alenoumóza, nimisili vémini gakó imane lo utó moloko lo lekemeaká nouve. ");
INSERT INTO gah_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Loko amelahikumú láa loko lo kemekago, keza gili hee lamamó. ");
INSERT INTO gah_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Nenemú Izesú miní ameko láa loko lo kimimó: Lekeza okulumakutí lumu ve gihila není nene zaló nilími otiiki, lo lekemeaká noumómámini oko noive liki gili guni inigave. Itó nezáne nagata geleko alemuke, améneho lo nimitokó loaká noive liki gili guni inigave. ");
INSERT INTO gah_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Nimisili ve eza nezagi makó noive. Neza gamena gamena netá matá oko moloko ukumú amu helekago, ma ahulonetosá amive. ");
INSERT INTO gah_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Loko lokago, vegená mukilite Ómasilokatí limi ve noive liki aikumú gili alévolé amó. ");
INSERT INTO gah_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Zuta ve gili alévolé iminamoláa nene Izesú láa loko lo kimimó: Lekeza není gakotokó minatamó nene, není izegipáne gihila minanigave. ");
INSERT INTO gah_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Lá iiki gakó gihiláa gili guni ikiko, ámina gakolímo nagakutí gologí olikimikiko, vatí iki minatave. ");
INSERT INTO gah_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Loko lokago, makolite láa liki li amemó: Leza Avalahani agapilamola nouko makolímo ezáa gopoguna lelémo molosá aminazo, geza gologí olimikako, vatí oko minatune loko nolape. ");
INSERT INTO gah_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Liki likago, Izesú láa loko lo kimimó: Neza lamaná lo likimitoze, gililo. Makó keza lihima netá aliki minatamó nene lihima netalímini gopogu izegipa minanigave. ");
INSERT INTO gah_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Gopogunate gizapa véinímini numukú miniki aliki aminigave. Gipalámogó nene amelahini numukú mino lúaló moloko minanogo ive. ");
INSERT INTO gah_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Nenemú Ómasímini gipala áisi gologí olikimikiko, lekeza lamaná nagakutí gologí olikimikiko minanigave. ");
INSERT INTO gah_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Lekeza Avalahani agapilamola niave loko mota gelenoumóza, gakónémo likigikagú minamigo, nepele hilitune liki liaká niave. ");
INSERT INTO gah_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Neza aménehini amatoka minuke ánigonou netakumukó loaká nouve. Lekeza nene lekezatini ametipitokatí ánigiki gele netakó lilí iaká niave. ");
INSERT INTO gah_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Loko lokago, ameteho nene Avalahá noinae. Liki likago Izesú láa loko lo kimimó: Lekeza Avalahani agapilamola minalina, aí avevezahaló iki miliki minaline. ");
INSERT INTO gah_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ómasilokatí gakó gihiláa gulumó nene lo lekemenoumóza, nepele hilitune liki liaká niave. Avalahá nenémini osá amimole. ");
INSERT INTO gah_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Lekelisi nene ametipo imó imó nene iaká niave. Loko lokago, leza gapoló izegipa minamune. Ómasi nene ameteho hamokóma noive. ");
INSERT INTO gah_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Liki likago, Izesú láa loko lo kimimó: Neza Ómasi minutotí vegená nemetamenigi loló okuke lemenouve. Neza nagata geleko lumumó negopa, Ómasímo nimiselekago noumó nenazo, ametipo nene Ómasi minalina, likigika nenitoka milaline. ");
INSERT INTO gah_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Není gakó nana okago gili vevesamave. Neza gakó nolugo gena likivisekago gilisá amamó, nenemú. ");
INSERT INTO gah_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Lekelisi ametipo Satá amu hiliti netá alitune liki giliaká niave. Áisi gozapá nene kepelenó kepelenó oko mino-loko noave. Agikagú gakó gihila nomigo, amegesa ameaká noive. Soza gakolímini amelaho eza soza saza gakó nene nosánetala loló okago, áminaló gelekelela minoaká noive. ");
INSERT INTO gah_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Nénisi nene gakó gihiláa lo lekemeaká noumóza, lekelisi nene gili ahuliaká niave. ");
INSERT INTO gah_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Lekelitokatí makolímo není lihima ma lo utó okiko alévolé itihe. Neza gakó gihiláa lo lekemeaká noumó nenazo, nanamú gili alisá amave. ");
INSERT INTO gah_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Makó keza Ómasímini gipa minatatite Ómasímini gakó gilinigave. Lekeza Ómasímini izegipala minamake, aí gakó gili ahuliaká niave. ");
INSERT INTO gah_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Loko lokago, monó gizapa ve keza láa liki li amemó: Geza Samalia numuká ve matuka gopa okago nolape loko gelekunike gakó lamaná loaká noune. ");
INSERT INTO gah_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Liki likago, Izesú láa loko lo kimimó: Neza matúne gopa okago lamuve. Aménehini ale napa oko loaká nouve. Lekelisi nene není aliki mumusopa ziaká niave. ");
INSERT INTO gah_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Neza nugulizá vitive loko losá amuve. Nene aménehini hoza neve. Áisi nene gakó lo hukoaká ve nenémo vegenalitini mogonataganáinimú lo hukanogo ive. ");
INSERT INTO gah_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Neza gakó lamaná lo likimitoze, gililo. Makó keza není gakó gili alitamó nene kigikáa ma heleminogo ive. ");
INSERT INTO gah_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Loko lokago, Zuta vete láa liki li amemó: Matuka lamaná gopa okave. Avalahá gozapá helekamóma neve. Itó Ómasímini agepagutí gakó liaká a ve keza ámina iki hilikamóza, makó keza není gakó gili alitamó nene kigikáa ma heleminogo ive loko nolape. ");
INSERT INTO gah_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Avoteho Avalahá iteko mina ve helekamóma neve. Géisi Avalahani aviliginogo nolape. Itó Ómasímini agepagutí gakó liaká a ve keza ámina iki hilikave. Geza hí ve suka loko gugupe aleko noitene. ");
INSERT INTO gah_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Liki likago, Izesú láa loko lo kimimó: Nezáne nugupe aleko ititomó nene etaminogo ive. Améneho Ómasileve liki liaká nia ve áisi nene nelémo napa oaká noive. ");
INSERT INTO gah_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Lekeza aikumú gili vevesisá amave. Nezáne nene aikumú gelenouve. Aikumú gelemuve loko lulina nene, lekelikitana oko sozaló ve minulinamóza, lá oko nomive. Amenehikumú gelenouke gakoláa gele aleaká nouve. ");
INSERT INTO gah_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Avotipo Avalahá neza mikasiuka lumu gamena nene vamotoka ánigoake, agoliza vizeko minamóma neve. ");
INSERT INTO gah_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Loko lokago, ámina gizapa ve keza li amiki geí kilisimasi 50-a vaminazo Avalahani ma ánigonape. ");
INSERT INTO gah_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Liki likago, Izesú láa loko lo kimimó: Neza lamaná lo likimitoze, gililo. Avalahá nene utó onamigo, minumó nominuve. ");
INSERT INTO gah_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Loko lokago, gehani aliake apili hilinigi ago, Izesú nene unamaha oake monó zagusavegutí lemeko vimó. ");
INSERT INTO gah_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Gamena makó zupa nene Izesú eza gapoló novike, ve makó izolahini agatupagutí agómula liko vimó geta ve ánigamó. ");
INSERT INTO gah_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Nánigago, vegenala zuha leza loká otoko monó gizapa velemaka, éahini lihimámo agómula likamó getave. Ezáa lihimámo nehe itó izolahiko amelahiko lihimámo neve. ");
INSERT INTO gah_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Loko loká omikuko, Izesú láa loko lo limimó: Nenémo amive. Itó izolahiko amelahiko lihimámogi amive. Ómasímini zámuza aitoka utó itive loko nenémináa getamó neve. ");
INSERT INTO gah_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Mikasiuka vegená niamó keza holisakasanagó hoza aliake, holugú nene hoza alisá amave. Ámináminoko leza nimisili vémini hoza itína alekinake, lelí hoza asú iti gamena nene hoza aleminogo une. ");
INSERT INTO gah_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Neza mikasigú minato gohala mikasiuka vegenalitini liví minanogo uve. ");
INSERT INTO gah_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Loko loake, mikasiuka gituhú oake, mikasi aleko lukená zeake agómula lika vemámini agómulaló holomiake, ");
INSERT INTO gah_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","láa loko nolike amisilimó: Geza voko Siloama nonohulokú golotuvaka nagamí zezo. Ámina nagamí agulizalímini mogonáa nene apili mila nagamile. Láa loko lokago, ámina ve vike nagamí zeake, agómula goloutokago, atiginá oko amó. ");
INSERT INTO gah_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Lá okago, agivelage ánigiake, goí oko monimú voká vokató ve minoaká imómave liki giliake, monimú voká vokató mumuzó mumuzó oko minoaká i ve imane nehe. ");
INSERT INTO gah_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Liki likago, lugáate ámina vema nenae liki likago, lugáate óve, áminagitana haitó noinogo ive. Liki likago, ámina vemámo neza ámina vema nounae. ");
INSERT INTO gah_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Loko lokago, loká itiki nana okanike gogómula goloutane. ");
INSERT INTO gah_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Liki likago, láa loko lo kimimó: Ve makó agulizá Izesú áisi goihá loló oake nogómulaló holonimiake, Siloama nonohulokú voko nagamí zezo loko lo nemekago, neza voko novogisa nagamí zeuke nogómula pulusokave. ");
INSERT INTO gah_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Loko lokago, keza loká itake ámina ve hikuka noive liki likago, neza ma ánigamuve loko limó. ");
INSERT INTO gah_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Láa loko lokago, agómula ale goloutota vema nene Palisaio monó vegenatoka alímiki vamó. ");
INSERT INTO gah_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Itó Izesú nene goihatunú agómula ale goloutamó nene holisi zupa lá imó. ");
INSERT INTO gah_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Lá okago, Palisaio monó ve keza ámina iki agómula goloutakumú goha loká itiki likago, láa loko lo kimimó: Izesú nogómulaló goihá holonimikago, nagamí zekugo, nogómula goloutokamole. ");
INSERT INTO gah_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Loko lokago, Palisaio ve lugáate Izesunimú nene lelí holisigú hoza lá oko alike ale golesa oaká noinazo, ámina ve eza Ómasilokatí noamive. Liki likago, lugáate lamó: Eza ve golesa minalina, golivagi hoza nenémináa nana oko aliline. Liki liake, pelevesava ziki mini luga luga amó. ");
INSERT INTO gah_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Lá iake, agómula lika vema loká itiki gogómula ale lamaná i vemú gezaka nanave loko nolane. Liki likago, eza limó: Eza Ómasímini agepagutí gakó loaká ve noitive. ");
INSERT INTO gah_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Loko lokago, Zuta vetini monó gizapa ve keza agómula lika ve minamóma agómula goloutokave liki gili seketigí amake, izolahiki amelahiki sele li kimiake, ");
INSERT INTO gah_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","loká ikitiki gipatini agómula liko minamó getusimole liki nilasihe. Itó ámina gipa imane nehe. Nana oake agómula goloutave. ");
INSERT INTO gah_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Liki likago, izolahiko amelahiko láa liki lasimó: Gipatema noive loko gelenousive. Itó agómula likamó getusimómave loko gelenousimóza, ");
INSERT INTO gah_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","eza nana oake itína agómula goloutahe, itó éaho agómula ale goloutave nene gelemusive. Eza olotiva netá nenazo, ezáa loká itiko lo likimitimole. ");
INSERT INTO gah_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Liki lasimó nene, Zuta vetini monó gizapa ve keza gozapá amunaló nene ve makolímo Izesukumú nene gologí oletative loko lo mololeta vema noive lokikoma monó mosetatune liki li hukamó nenazo, nenemú izolahiko amelahiko keza Zuta vetini gizapa vemú kelegesá legekago, ");
INSERT INTO gah_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","olotiva netá nenazo, loká italo liki lasimó. ");
INSERT INTO gah_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Likasigo, agómula lika vema goha sele li amiake, láa liki li amemó: Geza Ómasímini avogisaló gakó lamaná lamane. Leza ámina vemú nene lihima netá aleaká ve noive loko gelenounimó nenazo, aí agulizá ale otemo. ");
INSERT INTO gah_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Liki likago, áisi láa loko lo kimimó: Eza nene lihima netá aleaká ve nehe nene gelenamumóza, netá hámakó gelenouve. Neza goí oko nogómula likamó minumómaha itína nogómulánema ánigokave loko lamaná gelenouve. ");
INSERT INTO gah_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Loko lokago, goha loká itiki nana ogetave, gogómulaka nana oko ale goloutogetave. ");
INSERT INTO gah_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Liki likago, láa loko lo kimimó: Mota lo lekemekumole. Nene gelemahe. Goha litaha gakó nanamú lugo gilinigi nilave. Lekezagi aí izegipala zuha loló itune liki nilahe. ");
INSERT INTO gah_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Loko lokago, lekesava amiake lamó: Géisi nene aí izegipala noane. Lélisi nene Moseni izegipala noune. ");
INSERT INTO gah_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ómasímo nene gakó makó Moseni lo amimó neve loko gelenounimóza, imane ve nene getamoláa nene gelemune. ");
INSERT INTO gah_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Liki likago, ámina vémo gakó láa loko lo kimimó: Nogómula ale goloutoneta vémini getamoláa gelemahe. Neza giza lo noleketuve. ");
INSERT INTO gah_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ómasi eza vegená golesatini gakóini geleko kelémo vatí osá amimóza, makó nenémo Ómasi geké lotoko gakola gele alitimó nene, Ómasímo alémo vatí inogo ive loko geleaká noune. ");
INSERT INTO gah_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Itó ganá apí oko mikasi utó itotí ká emane ve makolímo agómula likamó getamó agómula ale golouta gakó ma lago gelemuháma neve. ");
INSERT INTO gah_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Nenemú imane ve Ómasilokatí lememimó nelina, hoza nenémináa ma alemiline. ");
INSERT INTO gah_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Loko lokago, láa liki lamó: Golesa gupilizá utó animó ánenéminaka monó lo lemesaláa noape. Liki liake, ahelú i ahulamó. ");
INSERT INTO gah_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Izesú nene amisili ahula gakó geleake, koma minake ámina ve ánigoake, loká otoko geza okulumakutí limi ve gihilamú gele alévolé onoape. ");
INSERT INTO gah_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Loko lokago, ámina vémo ve lamanámaka, lani ve nelepizekako, ánigo lamaná okinake, aikumú gele alévolé itove. ");
INSERT INTO gah_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Loko lokago, Izesú nene geza ánigonoako gakó lo nogumu ve neza imane noumole. ");
INSERT INTO gah_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Loko lokago, ámina vémo Guivahanínemaka, neza mota gele alévolé onouve. Loko loake, agihúna geko akamó. ");
INSERT INTO gah_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Lá okago, Izesú limó: Neza vegenalitini mogonáini ale vevesatove loko mikasiuka lumumó nene kigikámini agómula nomimó nenete pulusiki ánigataze, itó ligikámini agómula likamimó neve liki liaká nia vegenalitini kogómula likokiko, ámináa miniliki viki minatave loko neve. ");
INSERT INTO gah_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Loko lokago, Palisaio monó ve minamoláa lugáa keza giliake, loká itiki Olo, ligikámini agómula likamó nouko nolape. ");
INSERT INTO gah_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Liki likago Izesú láa loko lo kimimó: Lekeza likigikámini agómula likakumú gatizá minalina, lihimatini minamilinamóza, lekeza nene ligikámini agómula goloutonoive liki liaká nianazo, lihimatini ha minanogo ive, loko limó. ");
INSERT INTO gah_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Izesú gakó makó láa loko limó: Neza lamaná lo likimitoze, gililo. Makó eza sipsip izatini geisagú itinogo gatekú itemoko geisa gohalaló itekikoma, gumina vaukaló ve noive loko litune. ");
INSERT INTO gah_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Gatetó ititi vemú nene iza gizapa ve noive loko litune. ");
INSERT INTO gah_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Áisi nene anitekiko gatetó gizapa ve nenémo gahe segetanogo ive. Itó sipsip izava keza gizapa vémini anó lupamú gilinigave. Nigiliko sipsip izavatini kugulizá oko sele noloko geisa mikutí kelémoko liminogo ive. ");
INSERT INTO gah_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ezáa mututoni kelémoko lemeko ale goí noigo, anó lupamú gelekune liki ámegetanigave. ");
INSERT INTO gah_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Haitó ve makolímini anó lupamú gelemitamó nenazo, ámegetaminigave. Kelegesá legekiko, golisi inigave. ");
INSERT INTO gah_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Loko Izesú anoza gakó láa loko lo kemekago, keza nanamú lihe liake, gili vevesamamó. ");
INSERT INTO gah_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Lá ikago, Izesú eza miní ameko lo kimimó: Lamaná lo likimitoze, gililo. Sipsip izatini geisagú itiaká gateni nénisi nene nouve. ");
INSERT INTO gah_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Nénisi noamugo soza monó liaká ve utó amó mukitó nene gumina vaukaló ve minamó. Nenemú sipsip iza keza gakóini gili alisá amamó neve. ");
INSERT INTO gah_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Gateni nénisi nene nouve. Makó keza není nivilegemiki miniki geisagú ititamó keza latila aminigave. Némegé némegé iki minumuni lamanakú mihina inigave. ");
INSERT INTO gah_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Guminaló ve eza voko sipsip iza vauka apeleko aleko vinogogó geisagú iteaká noive. Není sipsip izate alévolé kemetamenigi minumuni lamanakú mihina iki minatave loko lumumóma neve. ");
INSERT INTO gah_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Nénisi nene sipsip izatini gizapa ve lamaná nouve. Gizapa ve lamanalímina sipsip izamule loko minoko aleko oakaláa ahulatimó neve. ");
INSERT INTO gah_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Gelekelé izegipa nene iza amelaho minamive, itó gizapa lamaná oko amitimó neve. Nenemú hela gala anitekiko, ánigooko sipsip iza ahulokimioko golisi inogo ive. Lá okiko, hela gala nenémo sipsip izama kepeleko kelémo hutilí inogo ive. ");
INSERT INTO gah_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Eza monimukó hoza aleaká noinazo, sipsip izamú makó gelesá amike ahulokimioko golisi voaká noive. ");
INSERT INTO gah_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Nénisi nene sipsip izatini gizapa ve lamaná nouve. Aménehiki nezagi ánigoko gelenousive. ");
INSERT INTO gah_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Ámina oko vegenáne zuhagi nezagi ánigoko gelenoune. Nenemú není sipsip izamule loko minoko aleko oakánéa ahulanogo uve. ");
INSERT INTO gah_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Itó sipsip izáne mulusi makó niave. Keza imane mikasigú vegenalitini geisa mikutí niamave. Neza kelémoko okugo, nonó lupamú gilinigave. Lá ikiko, sipsip iza mulusi hamokó minanigave, itó ámina oko gizapa ve hamokó minanogo uve. ");
INSERT INTO gah_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Neza minoko alekóne ahulanogo noukumule loko améneho agika nemeaká noive. Ahulokinake, gosohá goha alinogo uve. ");
INSERT INTO gah_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Minoko alekónéa makolímo ipá aminogo ive. Nene nezáne nagata geleko ahulanogo uve. Neza minoko alekóne ahulatove loko itó goha alitove loko nenémini zámuza nenitoka neve. Nenémini itane loko améneho lonetonoimóma neve. ");
INSERT INTO gah_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Loko Izesú némika loko lokago, Zuta vegená keza giliake, goha ligí ahuligí iake, mini luga luga amó. ");
INSERT INTO gah_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Lá okago, mukilite holosi makó nene agikagú minokago gakó gopa nolinazo, nanamú gilinigi nilave. ");
INSERT INTO gah_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Liki likago, lugáate láa liki lamó: Holosi makolímo agikagú minatimó nene, gakó nenémináa makó laminogo ive. Itó holosi makolímo kogómula lika vegenalitini kogómula ma ale goloutoketaminogo ive, liki lamó. ");
INSERT INTO gah_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Zuta vetini monó zagusave lusa gemó nenémini holiváa hepé gamena alitonoigo minamó. ");
INSERT INTO gah_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Izesú eza monó zagusave gaizopa agika makó agulizá Salomoni nenegú olío vogá ogá oko noigo, ");
INSERT INTO gah_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Zuta vetini monó gizapa ve keza iki alími vigiake, láa liki li amemó: Geza gamena hána nanamú mogonaka ale halá gekako, gele gopa oaká noune. Geza gologí oletative loko lo mololeta vema noitanimó nene lo utó moloko lo lememane. ");
INSERT INTO gah_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Liki likago, Izesú láa loko lo kimimó: Neza lo lekemeaká noumóza, lekeza gili seketigí iki gilisá amave. Aménehini gakotó alévolé suni loló oaká noumó nenémo mogonáne lo utó moloaká noimole. ");
INSERT INTO gah_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Lekeza nene sipsip izáne lilí iki minamakeve liki gakóne gili seketigí amave. ");
INSERT INTO gah_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Sipsip izáne lilí iki nia vegenalite nonó lupamú giliaká niago, neza ánigoko geleketonougo némegetiaká niave. ");
INSERT INTO gah_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Neza alévolé kemetameni kemekugo, latila amiki mini lúaló miliki minanigave. Není nigizakutí ve makolímo keí ipá aminogo ive. ");
INSERT INTO gah_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Améneho nenitoka kelémo mola ve áisi nene netá matá mukí kivilegeko noigo, aménehini agizakutí makolímo ipá aminogo ive. ");
INSERT INTO gah_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nezagi aménehiki leza hamokó nousive. ");
INSERT INTO gah_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Loko lokago, Zuta vetini monó gizapa ve keza gehani goha aliake, apili hilinigi niago, ");
INSERT INTO gah_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Izesú láa loko lo kimimó: Hoza lamaná haitopaitolímini nene aménehini gakotó aleaká noumóza, lekeza hí hoza ánigamó golesa okago gehanitunú nipili hilinigi niave. ");
INSERT INTO gah_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Loko lokago, Zuta gizapa ve keza anotó aliki láa liki lamó: Hoza lamaná aleaká noanikumú lamune. Geza lelikitana vema noanimóza, geza Ómasi avilegekanike gezakamú Ómasi nouve loaká noanikumú gehanitunú gipilinogo noune. ");
INSERT INTO gah_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Liki likago, Izesú láa loko lo kimimó: Lekelí monó gotolaú Ómasímo goní hoza aliaká a vemú nene lekeza ómai netá niave loko lumole loko li gakó nene luhuva gizinamóma neve. ");
INSERT INTO gah_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Nene Ómasímini gakó utó okimi vegenakumú ómai netá niave loko limó nenazo, itó monó gotolaú luhuva gizinamoláa nene lemeko akatimoláa oko nomive. ");
INSERT INTO gah_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Nenemú améneho nelémo otopá zeake nimiselekago mikasiuka lumu ve neza Ómasímini gipala nouve loko lumó nenazo, nenemú lekeza nanamú Ómasi avilegeaká noane liki nilave. ");
INSERT INTO gah_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Hoza aleaká noumó nene ánigikiko, aménehini avotigí amikoma, gakóne gili ahulatamó nene lamaná onoive. ");
INSERT INTO gah_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Itó ánigiko, není hozagi aménehini hozagi hamó lelegitó onoikoma, gakónemukopa alévolé suni loló oaká noumó nene ánigalo. Ánigi guni itamó nene, améneho není nene akiseneive, itó neza ámina oko aménehini akiseneive liki giliiki mogonáa gili lamaná inigave. ");
INSERT INTO gah_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Loko loake, goha nagá aminigi niakutí ahuloake vimó. ");
INSERT INTO gah_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Vike Zota nagamí vola helega Zoní apí oko monó nagamí holoketa apató goha voko minamó. ");
INSERT INTO gah_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Neneló noigo, vegená mukí aitoka anitiake, láa liki lamó: Zoní nene golivagi netá makó alemimóza, imane vemú gakola limóma mukí mota gihila zekave. ");
INSERT INTO gah_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Liki liake neneló vegená mukilite Izesukumú gili alévolé amó. ");
INSERT INTO gah_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Petania numutoka ve makó avisekago ako minamó, agulizá Lasaló. Aí atolage lositá áminaló minasimó, kugulizáini Maliako Matako. ");
INSERT INTO gah_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maliá nene Guivahani Izesuni nene anuva lamanaki netupa holomiake gotola zopovatunú agisa gilatoko ale lamaná ota venalímini agunala Lasaloni avisekago, ");
INSERT INTO gah_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","keza Izesutoka gakó láa liki ahulasimó: Guivahanitemaka gelezo. Zogova vema netá napa avisekago akonoive. ");
INSERT INTO gah_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Liki likasigo Izesú nene gakó geleake, láa loko limó: Monéna hilitove loko gizalemive. Ómasímini lapaná utó itive loko, itó Ómasímini gipala není luhuva gegemá itive loko aviseneive, loko limó. ");
INSERT INTO gah_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Izesú nene Lasaloki atolage Mataki Maliakimú agika kemenei vegená minamó nenazo, ");
INSERT INTO gah_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","nenemú Lasaloni avisi gakó geleake, ako mina numutó gamena lositá miní ameko minoake, ");
INSERT INTO gah_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","izegipala zuha láa loko lo limimó: Alo, Zutaia mikasiuka atiginá oko vitunize. ");
INSERT INTO gah_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Loko lokago, izegipala zuha leza láa loko lo amunimó: Monó gizapa velemaka, Zuta vetini monó gizapa ve keza goí okoma vanitó gehanitunú gepele hilitune liki linamóma nenazo, goha vitune loko nolape. ");
INSERT INTO gah_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Liki likago, Izesú láa loko lo limimó: Hoza gamena netekaki holisakaki únakaki vaí onoive. Makó keza holisakaláa lapanató gapo niviko, netá matá hanuva lotohá kepeleminogo ive. Neza hoza alito gamenaváne ha neve. ");
INSERT INTO gah_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Makó keza lapaná nomiko holugú gapo vitamó nene, lotohá kipilinogo ive. ");
INSERT INTO gah_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Loko lo lemeake, miní ameko láa loko limó: Zogole Lasaló mota ako helekamóza, neza voko alémo otinogo uve. ");
INSERT INTO gah_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Loko lokago, izegipala zuha leza Guivahanitemaka, avó akonoitimó nene zokanogo inae. ");
INSERT INTO gah_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Loko luhá nene, Izesú eza heleakakumú anoza gakó lo limitó leza hanuva akonoikumú lihe loko gele hee lamunike lokuko, ");
INSERT INTO gah_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Izesú lo utó moloko láa loko lo limimó: Lasaló mota helekave. ");
INSERT INTO gah_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Neza neneloka vamuke imaneloka nougo hilikumú nene lekelikumule loko gele alévolé oakatinímini gihila lilí itave loko mulúnegú lamaná noguluve. Nenemú áminaloka vitune. ");
INSERT INTO gah_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Loko lokago, Tomasí agulizá makó Lopé áisi nene agivelagini láa loko lo limimó: Leza mukitoka voko ezagi hilitune. ");
INSERT INTO gah_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Loko lokago, makó vunimó. Vunike Lasaloni gale zimikago gamena losive losive oko vokago, Izesú nene Petania numutoka vo aniteake, ámina gakó gilimó. ");
INSERT INTO gah_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Petania apá nene Zelusalegatí 3 kilomitasí minamó. ");
INSERT INTO gah_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Nenemú Zuta vegená mukilite Matako Maliako kugunáini helekagove liki ive nama ikitanigi vamó. ");
INSERT INTO gah_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Lá ikago, Matá eza Izesú noave lamó geleake, Maliá nene numukú noigo, vike gapoló hotu lasimó. ");
INSERT INTO gah_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Izesuki hotu likasike, láa loko lo amimó: Guivahanínemaka, geza imaneló minatilina, nugunáne nene helemiline. ");
INSERT INTO gah_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Itó itínasagi nene nemú manamú Ómasiloka voká lokako, gele gimitimóma neve loko gelenouve. ");
INSERT INTO gah_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Loko lokago, gugunaka nene mómoká oko otinogo ive. ");
INSERT INTO gah_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Loko lokago, Matá láa loko lo amimó: Minoko gamena napaló Ómasímo vegená mukí lelémo otititó nene ezagi otitimóma neve loko gelenouve. ");
INSERT INTO gah_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Loko lokago, Izesú láa loko lo amimó: Nénisi helenosakutí oteoko alévolé oko minoaká amelahina nouve. Makó keza nenikumú gili alévolé itamó nenete hiliiki goha otiki miniki aliki inigave. ");
INSERT INTO gah_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Itó makó keza kogómulagi miniki nenikumú gili alévolé itamó nenetini kigika ma heleminogo ive. Minoloko voko minanogo ive. Geza imane nolu gakó mota gele seketigí onoape. ");
INSERT INTO gah_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Loko lokago, Matá limó: oo, Guivahanínemaka, geza gologí oletatane loko lo mololeta vema Ómasímini gipala mikasigú lemenane liki lina ve noane loko nigikatunú mota gele alévolé onouve. ");
INSERT INTO gah_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Loko loake, mohó agunala Maliani nene sele lo ameake, musika loko monó gizapa vema oake, geikumú nolive. ");
INSERT INTO gah_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Loko lo amekago, Maliá nene geleake, litá oko oteko Izesutoka vimó. ");
INSERT INTO gah_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Novigo, Izesú nene numutoka velesá vo anitemike, Malatani gakó lo ami apatoka minamó. ");
INSERT INTO gah_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Lá noigo, Maliá eza litá oko oteko nolimigo, Zuta vegená numunagú makó miniki ive nama itiki mina vegenalite Lasaloni militamómaloka ive inogo novihe liki ámegetiki vamóza, ");
INSERT INTO gah_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Maliá eza Izesú noitoka aniteake ánigoake, agihúna geko akoake, Guivahanínemaka, imaneloka noako nelina, nugunáne helemiline. ");
INSERT INTO gah_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Loko loake, ive imó. Ive noigo, Zuta vegená ámegetiki vamoláa keza ámina iki alími vatí iki ive niago, Izesú nene ánigoake, mulunagú miluma napa geleake, agika hizekago, ");
INSERT INTO gah_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","loká oketake hikuka gale zinave. Loko lokago, Guivahanitemaka, oko ánigatane. ");
INSERT INTO gah_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Liki likago, Izesú nene agómulagutí leke leke lokago ive imó. ");
INSERT INTO gah_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ive okago, Zuta vegenalite ánigiake lamó: Ánigalo. Agika nene aí ame gikitoko amenei ve neinogo ive. ");
INSERT INTO gah_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Liki likago, keikutí lugáate lamó: Goí oko agómula lika ve makóma ale goloutotamóma nenazo, imane ve hanuva alémo zokaline. ");
INSERT INTO gah_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Liki likago, Izesú goha miluma napa geleake, matimatiló anitemó nene geha mulí minamó, itó agepaló nene gehani napa mili lí amóma nene ");
INSERT INTO gah_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Izesú ánigoake, gehanima ali ahulalo loko lokago, hili vémini atolaho Matá láa loko lo amimó: Guivahanínemaka, gamena losive losive minokanazo, mota anuva noinogo ive. ");
INSERT INTO gah_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Loko lokago, Izesú láa loko lo amimó: Nenikumú gele alévolé itanimó nene Ómasímini zámuzalámini luhuva utó iko ániganogane loko lo gumu gakó mota gagatí molokahe. ");
INSERT INTO gah_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Loko lokago, gehanima akili ahulikago, Izesú nene okena oko velekuka ánigoake, láa loko limó: Aménega, geitoka lonoumó nene gelekanikeve loko gegepoka noluve. ");
INSERT INTO gah_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Itó gamena gamena geitoka loaká noumó nene gelenane loko gelenoumóza, imane ali nupa nia vegenalite géisi nimiselekako limimole liki gili zagiki gilitave loko láa loko lo nogumuve. ");
INSERT INTO gah_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Loko loake, gakó napagutí sele loko Lasalo, geza oteoko lemeno. ");
INSERT INTO gah_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Loko lokago, helenei vémo agisa agizatoka nagá likita netá akoheminago lemekago, Izesú vínasiki ali ahulitalo loko lokago, vínasiki ali ahulitamó. ");
INSERT INTO gah_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Lá ikago, Zuta vegená Maliatoka anitemoláa keitokatí mukilite Izesú oko moloko i netá ánigiake, aikumú gelego alévolé imóza, ");
INSERT INTO gah_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","lugáate Palisaio monó vegenatoka vake Izesú oko moloko i gakó avetó i kememó. ");
INSERT INTO gah_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Avetó iki li kimikago, kezagi guguni giziaká a vegi monó kansole kilími nupa iake láa liki lamó: Imane lu avevezaha la avevezaha mukí okanazo, leza nana itune. ");
INSERT INTO gah_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Leza nene amanapa oko nouko, eza lá oloko vova vova noiko, mukí vegenalite lugulizaki ve napa noive liki gili zaginigave. Lá ikiko, Loma gevenalitini ami vete iki lova ali limiiki monó zagusavele nemó vegenate niamó ali tolova inigave. ");
INSERT INTO gah_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Liki likago, keitokatí makó agulizá Kaiapá ámina kilisimasi oko novigo guguni giziaká vetini gizapa ve loló i vémo láa loko lo kimimó: Lekelisi negi nagi niaze. ");
INSERT INTO gah_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Leza Zuta ve mukitoka latila o asú okatuninazo, ve hamokolímo lelémo nupa napa oko helekiko nenémo netá gihila ale utó oletative liki gilisá amave. ");
INSERT INTO gah_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Loko limó nene ezáa agata geleko ligopa, eza ámina kilisimasiló nene guguni giziaká vetini ve napa minoakeve loko Izesú eza vegená mukikumule loko hiliti gakó lo kimimó. ");
INSERT INTO gah_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Nene Zuta vegenakumukó lamimó. Ómasímini vegenala zuha numutó namató nia vegená kelémo nupa okiko mulusi hamokó miliki minatave loko hilitikumú limó neve. ");
INSERT INTO gah_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Láa loko lokago guguni giziaká a ve keza ámina zupa nene Izesuni apili hilinigi apí iki lova gizamó. ");
INSERT INTO gah_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Lá ikago, Izesú eza Zutaia apakú vegenalitini kogómulaló goha vo utó amike mikasi gomopalaló minamó. Nenémini agataloka apá makó minamó, agulizá Epalaima neneloka izegipala zuhagi makó minunimó. ");
INSERT INTO gah_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Nouko, Zuta ve avotegini asenini zeketakumú gele minoaká holisi alitokago, apá koma kamalokatí vegená mukilite kugupe kigikáini ali guluvitanigi goí iki Zelusalega tivamó. ");
INSERT INTO gah_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Viki monó zagusave napagú itiki niake Izesú noamigo vitagá ake, ligili hagili niake lekeza nanave liki nigeleve. Áisi nene holisigú atimó nehe amitimó neve. ");
INSERT INTO gah_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Liki lamó nene guguni giziaká a ve napagi Palisaio monó vegi keza ve makolímo Izesú minoko aleko noiti apá ánigoko geleko onoitimó nene oko lo lemekiko, gelekinake voko nagá amitune, liki amunaló li miliki lató nene ámina gakó lamó. ");
INSERT INTO gah_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Asenini zeketakumú gele minoaká holisi gamena alitokago gamena 6-a veletoka ha nego, Izesú eza Petania numutoka vo anitimó. Ámina apató nene emane amunaló Lasaloni heleneikutí alémo otimó. ");
INSERT INTO gah_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Áminaló nene nosánetá gizi vatá ikago, Matá nene hizeko gona moloko ale nokimigo, Izesú nene Lasalogegi makó minake nosánetá namó. ");
INSERT INTO gah_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Niki niago, Maliá nene anuva lamanaki netupa agulizaláa nalita loko meinava iteko mina netá nene hapu lita potologú minamó nene Izesuni agisaló holomiake, gotola zopovalatunú gilatoko ale lamaná otamó. Lá okago, numukuka anuvámo moloake minamó. ");
INSERT INTO gah_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Lá okago, izegipala zuhagutí ligive makó Kaliotó numutotí ve agulizá Zutá eza minoko Izesuni amimika liti ve nenémo láa loko limó: ");
INSERT INTO gah_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Anuva lamanaki netupa hanuva minatinazo. Nenémini meinava moni gó losive makole hizekoko gohogó vegená kemekuko etatinazo. ");
INSERT INTO gah_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Loko limó nene gohogó vegenakumú geleko limó negopa, áisi nene lelí moniló gizapa oko noigo moni alimi namego, ale halá halá geko minoaká inazo, nenemú limó. ");
INSERT INTO gah_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Loko lokago, Izesú nene limó: Ahulikalo. Helekugo gale zinitanigi anuvavagi netupa nene nugupeló hilinitatakumú geleake loló onimikave. ");
INSERT INTO gah_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Gohogó vegená keza nene lekezagi miniliki viki minaniganae. Neza nene lekezagi mino-loko voko minaminogo uve. ");
INSERT INTO gah_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Loko lokago, Zuta ve mukilite Izesú neneloka noive liki nila gakó giliake áminaló anitemó nene Izesukumukó nomimó. Lasaloni emane amunaló heleneikutí alémo oti vegi ániganigi amó. ");
INSERT INTO gah_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Ikago, Lasaloni alémo otikumú nene Zuta vegená mukilite Zuta vetini monó gizapa ve ahulikimiake Izesutoka viki gímiziki aikumú gili alévolé amó. Nenemú guguni giziaká a ve napa keza Lasalonigi apele hilitune liki lova gizamó. ");
INSERT INTO gah_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Akiake gó lokago, holisiló a vegená mukilite Izesú Zelusalega noave gakó giliake, ");
INSERT INTO gah_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","kokonasi agila letiki Izesú ati gapoló militanigi aliki vamó. Hotu liake sigaga litimi nivake agae, Guivahanímini gakotó anitelimikane. Ómasímo lusa gegetatize. Isilae ve lelí gugulizaki vele noane. ");
INSERT INTO gah_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Liki nilago, Izesú eza toki iza akaleva makó ánigoake, amupiló iteake vimó. Nene monó gotolaú gakó láa loko minató gele minake lá imó: ");
INSERT INTO gah_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Zaion agokaú vegená lekeza lekelegesá legemino. Gilinahe. Agulizaki velini nene toki iza akalevámini amupiló iteake noave. ");
INSERT INTO gah_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ámina gakó nene izegipala zuha leza goí oko gele vevesamunimóza, alika Izesú nene okulumá lapanalagú atiginá oko itekago, nene gakó goha gelekunike, ámina gakó aikumú gizi milamómaló ámina avevezaha itake lá amó neve loko gele vevesunimó. ");
INSERT INTO gah_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Itó Izesú nene Lasaloni sele lo amekago heleneikutí gonosi galegutí limigo ániga vegená mukilite keza ámina sunimú vegená lugáa avetó iki li kimiki minamó. ");
INSERT INTO gah_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ámina sunímini gakó giliake, mukilite gapoloka hotu lanigi vamó. ");
INSERT INTO gah_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Lá ikago, Palisaio monó vete kezáini ligili hagili niake lekeza gilinahe. Hizi lí itata hoza nalemó nene gihila nomigo, vegená mukitoka aitoka gímizi asú niave, liki lamó. ");
INSERT INTO gah_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ámina holisigú Ómasi geké lotatune liki Zelusale numutoka tiva vegenakutí Kiliki ve lugáa minamó. ");
INSERT INTO gah_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Keza nene Galilaia mikasiuka Petesaita numutotí ve Pilipó noitoka vake, ve lamanámaka, Izesuni ánigatune loko noune. ");
INSERT INTO gah_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Liki likago, Pilipó nene Etuluni lo amekago, ezagi makó viki Izesuni li amikasigo, ");
INSERT INTO gah_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","ezáa hilitikumú anoza gakó láa loko limó: Okulumakutí lumu ve gihila není lapanánegi luhuváa utó iti gamena mota alitokave. ");
INSERT INTO gah_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Lamaná lo likimitoze, gililo. Kilé zuha makó nene mikasigú hizemitunimó nene hanuvagó minanogo ive. Mikasigú hizekuko, lemeko nenegú helekoko mikasímini nosánetá loló okoko gihila mukí zinogo ive. ");
INSERT INTO gah_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Áminámini oko makó keza kigika kemeníikumú gilikiko ititimó nene, alikaloka kigika kemeni gopa inogo ive. Makó keza mikasigú miniki nenikumule liki kigika kemeníikumú gilikiko limitimó nene alévolé kemetameni ali luhanigave. ");
INSERT INTO gah_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ámina Kiliki vehe itó vegená makó ahe není gelekelé izegipa minatune liki gilitamó nene némegetiki ataze. Lá ikiko neza minomo ititotoka gelekelé izegipánegi makó minanogo une. Itó nasahilí initata vegenalitini kugulizá nene améneho ale otinogo ive. ");
INSERT INTO gah_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Nigika ololó oake, luvoluvo zekave. Lá okazo, nenemú nanave litove. Aménega, gamenaváne alitokaze, nugupeló ititi netá molo hotó onetozo litomó nene etamitinazo, láa loko lamitove. Miluma gilito netá mota numupiló itinogo noigo, gamenaváne okaze. ");
INSERT INTO gah_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Nenemú aménega, geza lokako, gugulizalímini luhuva utó itive. Loko lokago, okulumakutí gakó láa loko limimó: Nugulizalímini luhuva mota gonanalivagi utó okamóza, utó oloko voko utó okogó minanogo ive. ");
INSERT INTO gah_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Loko ligo, vegená mulusi miliki minamó keza giliake, ageló makolímo gakó lo amekave. ");
INSERT INTO gah_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Liki likago, Izesú láa loko lo kimimó: Gakóma nene nenikumule loko nomive. Lekelikumule loko utó okave. ");
INSERT INTO gah_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Itína Ómasímo imane mikasigú vegenalitini lihimáinimú meina kimiti gamena mota alitokave. Itína imane mikasigú agulizaki Satani amisilinogo uve. ");
INSERT INTO gah_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Imane mikasigutí zaló nilími otikiko, numutó namató vegená alesa molo kemekugo, nenitoka imi asú inigave. ");
INSERT INTO gah_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Loko limó nene zohota zaló hilitikumú anoza gakó limó. ");
INSERT INTO gah_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Loko lokago, mukí mina vegenalite láa liki li amemó: Leza monokú nene gologí oletative loko lo mololeta ve eza nene helemoko mino lúaló moloko minanogo ive liki luhuva gizina gakó gelenounimó nenazo, geza okulumakutí lumu ve gihila nene zaló nilími otikiko hilitove loko nanamú nolape. Okulumakutí limi ve haitolíminimú nolane. ");
INSERT INTO gah_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Liki likago, Izesú láa loko lo kimimó: Ló liví nene gamena komáisí holutikú hanatanogo ive. Nenemú límugusi nenémo lekelitoka sinitokatize, ló livíma lekelitoka lapaná noliko aliiki minalo. Ve makó keza límugusi gapogú vitamó nene, gapo ánigi hee laminigave. ");
INSERT INTO gah_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Nenemú livíma lekelitoka miniko, ali lá ilo. Lekelisi livilímini mututoni loló itune likima nenikumú gili alévolé ilo, loko limó. Izesú nene gakó láa loko loake vo halá geko minamó. ");
INSERT INTO gah_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Izesú eza haitopaitó suni kogómulaló ale utó okago ánigamóza, aikumú gili alévolé amamó. ");
INSERT INTO gah_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Lá amó nene Ómasímini agepagutí gakó loaká ve Isaiá li gakó nene alévolé itive liki lá amó. Eza lo goselé ike gakó láa loko luhuva gizamóma neve: Guivahanínemaka, gakoka lokuko vegená nanakilite gili alévolé inave. Itó Guivahanímini zámuza éahitoka utó okago gele zageneive. ");
INSERT INTO gah_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Itó Isaiani gakó makó láa loko luhuva gizató keza gili alévolé amamó neve: ");
INSERT INTO gah_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Áisi kogómula gahaga like kigika ale gopa okago, keza kogómulatunú netá matá ánigi hee lisá amave. Kigika ali viligamago, kelémo lamaná itomoláa nomive. ");
INSERT INTO gah_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Loko Isaiá limó nene Izesuni lapaná okulumakú nego ánigoake limó neve. ");
INSERT INTO gah_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Lá okago, Zuta vetini gizapa vegutí lugáa nenete Izesukumú gili alévolé amóza, lo utó itunimó nene, Palisaio monó ve nenete monó gapo hizi lí ilimikatave liki kehelele vizekago, li utó amamó. ");
INSERT INTO gah_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Keza vegená makolite legepoka litave likigó iki miliki iaká amó neve. Ómasímo lelémo napa itive liki iki miliki isá amamó neve. ");
INSERT INTO gah_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Lá okago, Izesú nene gakó napagutí láa loko limó: Makó keza nenikumú gili alévolé itamó nenete nenikumukó negopa, nimisili ve aménehinimuki gili alévolé inamó geleneive. ");
INSERT INTO gah_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Makó keza není ánigi hee litamó nenete nimisili vegi ánigi hee hee linamó geleneive. ");
INSERT INTO gah_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nenikumú gili alévolé ita vegenalite límugusigú minamitave loko mikasiuka vegenalitini liví minanogo lemenoumóma neve. ");
INSERT INTO gah_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Makó keza gakóne imane giliiki gili ahulatamó nene, nénisigó goní oketaminogo uve. Nénisi nene mikasiuka vegená lihima kimitove loko negopa, numutó namató vegená kugutó vizitove loko lumumóma neve. ");
INSERT INTO gah_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Makó keza není ahuli hotó inimiiki není gakó ahulatamó nene, gakó lo mulumó nenémo gamena napaló goní oketanogo ive. ");
INSERT INTO gah_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Nezáne nagata geleko losá amuve. Améneho nimisili vémo lo utó itane loko lonimikago loaká nouve. ");
INSERT INTO gah_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Lá nouke, neza agepagutí gakó nenémo alévolé oko minoaká mogona ale utó oaká noive loko gelenouve. Gakó nolumó nene améneho litokó loaká nouve, loko Izesú limó. ");
INSERT INTO gah_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Avotegini asenini zeketakumú gele minoaká holisi alitokago, gamena hamokó veletoka ha nego, Izesú nene imane mikasi ahulokinake aménehitoka atiginá oko itito gamena mota alitokave loko geleake, imane mikasiuka aí mututoni lilí a vegená agika lemeneike agika limitímini mogona lelepizinogo netá makó alimó. ");
INSERT INTO gah_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Nosánetá nanogo alegesá okuko, netá makó lá oko utó imó. Kaliotó numutotí ve Saimoni gipala Zutani agikagú nene Satá iteake alémo vávani okago, Izesuni amimí inogo gilimó. ");
INSERT INTO gah_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Lá okago, Izesú nene améneho eza netá matá mukí nene nigizakú molonoimóma neve loko, itó Ómasilokatí lumutímina goha nene Ómasiloka atiginá oko itinogo uve loko geleneike, ");
INSERT INTO gah_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","nosánetá noko minuhakutí oteake, luhoaká gola hána nene gololohá oake, tauli aleko gohalaló likeake, ");
INSERT INTO gah_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","nagamí nene lapegú leke moloake, izegipala zuhatini ligisa nagamí zelimiká taulitunú gilatolimiká oloko vike, ");
INSERT INTO gah_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Saimon Pitá noitoka vokago, eza láa loko lo amimó: Guivahanínemaka, není nigisa nene géisi nagamí zenetatove loko nolape. ");
INSERT INTO gah_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Loko lokago, Izesú láa loko lo amimó: Imane loló nou suni nenémini mogonáa itínasa gelemane. Alika minomo iteko gilinogo ane. ");
INSERT INTO gah_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Loko lokago, Pitá nene není nigisa nagamí zenetaminogo ane. Loko lokago, Izesú nene nénisi nagamí zegetamitomó nene, gezagi nezagi apizeminogo usive. ");
INSERT INTO gah_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Loko lo amekago, Saimon Pitá láa loko lo amimó: Guivahanínemaka, láa lokoma nigisagó negopa, nigizanigi gotónegi mukí nagamí zenetatane. ");
INSERT INTO gah_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Loko lokago, Izesú anoza gakó makó láa loko lo amimó: Makó keza nagamikú akiiki alika nene kigisagó nagamí zikiko nene, kugupe nene guluvito asú inogo ive. Lekeza nene áminagó iki likigika guluviti asú inamóma nemóza, lekeza mukitoka guluviti asú ikigó minamave. ");
INSERT INTO gah_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Loko limó nene ve makó hí vémo amimika litikumú geleneike, lekeza mukitoka guluviti asú ikigó minamave loko lo limimó. ");
INSERT INTO gah_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ligisa nagamí zeleto asú oake, gola nene goha ale luhoake, mitó minake láa loko lo limimó: Imane loló oleketu netalímini mogonáa mota gili hee linahe. Olile. ");
INSERT INTO gah_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Lekeza nenikumú nene Guivahaniteve itó tisaleve liki liaká niamóma vatí iki liaká niave. ");
INSERT INTO gah_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Itó neza Guivahanitini itó tisalinímina gelekelé oleketuke likigisa nagamí zelikimikumó nenazo, lekezagi ámináminiki lukugupe alimi limiki likigisa nagamí eza zetiko eza zetiko iliki viki minalo. ");
INSERT INTO gah_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Imane gelekelé olikimiaká suni naleleketumó nene lekezatini ámináminiki aliliki vitave loko apí o nolukumuve. ");
INSERT INTO gah_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Neza lamaná lo likimitoze, gililo. Gelekelé izegipa makó nenémo golohá veva avilegeakala nene nominazo, lukugupe aliki itikatave loko noluve. ");
INSERT INTO gah_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Itó gakó nolumó nene gilinamó nenazo, áminama amegesaló milatamó nene Ómasímo nónohá zeleketa vegená minanigave. ");
INSERT INTO gah_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Gakó nolumó imanémo lekelí mukitoka ale asú amive. Neza nene lekelémo etó onou vetini mogonatini gelenoumóza, monó gotolagutí gakó makó láa loko neve: Nosánetá noko minusi ve nenémo není nehelú okave liki luhuva gizina gakó nene ve makotoka alévolé inogo ive. ");
INSERT INTO gah_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Itó ámina netá utó okiko, lekeza lo lekemeaká nou ve noive liki gili seketigí itave loko ámina netá velesá utó onamigo lo nolukumuve. ");
INSERT INTO gah_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Neza lamaná lo likimitoze, gililo. Makó keza amisilito ve makó nasahilí itatamó nene, hoza amelahina neniki nasahilí initamó gilinogo ive, itó makó keza nasahilí initatamó nene nimisili vegi nasahilí itamó gilinogo ive. ");
INSERT INTO gah_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Itó Izesú ámina gakó láa loko lo asú oake, muluna gitihiná okago, láa loko lo utó oko lo limimó: Neza lamaná lo likimitoze, gililo. Lekelikutí ve makolímo nimimika linogo ive. ");
INSERT INTO gah_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Loko lokago, izegipala zuha leza gonú gimisi okunike nene, éahikumú live lokunike nene, gele gopa unimó. ");
INSERT INTO gah_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Lá okuko, eza Izesú agika nemeaká i veve liki lina vémina amatoka nougo, ");
INSERT INTO gah_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Saimon Pitá agizanitunú avevezaha ike éahikumú nolihe loká okako lo gimino loko lokago, ");
INSERT INTO gah_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","neza Izesuni amatoka nouke loká otuke Guivahanínemaka, éahikumú nolane. ");
INSERT INTO gah_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Loko lokugo, Izesú láa loko limó: Nosánetá nagamikú lupizeoko amekugo nati vemú noluve. Loko loake, nosánetá lupizeake, Kaliotó ve Saimoni gipala Zutani nene amimó. ");
INSERT INTO gah_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Amekago, nokago, Satá nene agikagú itekago, Izesú láa loko lo amimó: Geza netá matá loló itove loko lanimó nene litá oko loló ozo. ");
INSERT INTO gah_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Láa loko lo ami gakó nene agivelage leza makó minuni vete gele hee lamunimó. ");
INSERT INTO gah_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Lá unike, lugáa nenete Zutá nene moni gotó gizapa oaká imó nenazo, nenemú holisigú nosánetá meina hizitive loko namisilihe loko nene gelehá. Itó lugáa nenete gohogó vegená nene moni gona moloko kimitive loko namisilihe loko gulunimó. ");
INSERT INTO gah_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Lá okuko, Zutá nene nosánetá noake, agupegú límugusi zekago hetoka lemeko vimó. ");
INSERT INTO gah_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Hetoka lemekago, Izesú láa loko limó: Itína okulumakutí lumu ve gihila není nugulizalímini luhuva mota gonanalivagi utó inogo ive. ");
INSERT INTO gah_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ómasímini agulizalímini luhuva gonanalivagi utó noiko, Ómasímo lokiko, nugulizalímini luhuva nene litá oko gonanalivagi utó inogo ive. ");
INSERT INTO gah_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Izegipánemata, gililo. Lekezagi gamena koma mininake vitove. Vokugo, lekeza nenikumú vitagá itamóza, amunaloka Zuta vegená lo kumumómámini oko itínasa láa loko lo nolukumuve. Neza voko minatotoka nene lekeza aminigave. ");
INSERT INTO gah_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Itó itínasa gosohá láa loko lo nohukoleketuve. Likigika eza amiko eza amiko ilo. Neza nigika lekemenoumó nenémini iki likigika eza amiko eza amiko iliki vilo. ");
INSERT INTO gah_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Likigika eza amiko eza amiko itatímo nene, vegená mukilite lekelikumú nene není izegipáne zuha niave liki gilinigave. ");
INSERT INTO gah_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Láa loko lokago, Saimon Pitá nene Guivahanitemaka, hitoka vitane. Loko lokago, Izesú láa loko limó: Apá makotoka vitomó nene itínasa némegetamitanimóza, alika némegetanogo ane. ");
INSERT INTO gah_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Loko lokago, Pitá láa loko lo amimó: Guivahanitemaka, itína neza nanamú gémegetaminogo uve. Geikumule loko minoko alekóne ahulatove loko ale vatí okumóma nenae. ");
INSERT INTO gah_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Loko lokago, Izesú lo amike limó: Nenikumule loko minoko alekóne ahulatove loko nolape. Íi, lamaná lo gimitoze, gelezo. Azo neteká nene okoloho nenémo anó velesá molonamiko, nenikumú nene ánigonamuve loko egamega onetatanimó nene gamena losive makole inogo ive, loko lo amimó. ");
INSERT INTO gah_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Izesú gakó makó láa loko limó: Mulutini lepa hiziko minalo. Lá iki miniki Ómasimú gili alévolé iki nenikumuki gili alévolé iki minalo. ");
INSERT INTO gah_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Aménehini numukú numuni agika vaí oko neve. Lá oko nomilina neza voko apá makó ale vavá oleketatove loko lamuline. ");
INSERT INTO gah_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Neza voko apá makó ale vavá olikimioko mininake, atiginá oko oko lekelémoko vokugo, nenitoka minatave. Lá niiki neza minato apakú nene lekezagi makó minanogo une. ");
INSERT INTO gah_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Neza voko minato apalímini gapováa lekeza ániginave. ");
INSERT INTO gah_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Loko lokago, Tomasí lo amike limó: Óe, Guivahanitemaka, geza voko minatani apaláa gelemune. Nenemú gapováa nana oko gilitune. ");
INSERT INTO gah_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Loko lokago, Izesú láa loko lo amimó: Gapovagi itó gakó gihilagi itó alévolé oko minoakalímini amelahina nénisi nene nouve. Není niviligiiki aménehitoka viki anitiakala nene ma nomive. ");
INSERT INTO gah_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Lekeza nenikumú gili vevesalina, aménehikumuki gili vevesaline. Itína aikumú gili vevesiake, aí mota ánigikave. ");
INSERT INTO gah_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Loko lokago, Pilipó nene Guivahanitemaka, ametehini lelepizekako, netá makokumú loká ogetamitune. ");
INSERT INTO gah_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Loko lo amekago, Izesú láa loko lo amimó: Pilipo, gamena hána lekezagi minumóza, geza není velesá ánigo hee hee lamape. Ve makolímo není ánigonoiti vémo aménehinigi ánigo noimó gelekave. Nenemú geza nanamú ametehini lelepizezo loko nolane. ");
INSERT INTO gah_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Améneho nene není ale akiseneive itó neza nene aménehini ale akisenouve loko géisi nene gele zagemape, olo. Gakó lo nolukumumó nene neza nagata geleko lo lekemesá amuve. Alévolé suni aleaká noumó nene nigikagú noi ve aménehini zámuzaló utó oaká noive. ");
INSERT INTO gah_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Améneho nene není akiseneive liki, itó neza aménehini akisenouve liki gili zagitave loko nolumóza, ámina gakó nigiliki gihila zemikoma alévolé suni aleaká noumó nenemú nenikumú gili alévolé ilo. ");
INSERT INTO gah_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Neza lamaná lo likimitoze, gililo. Nenikumú gili alévolé itamó nenete alévolé suni aleaká noumó áminagó iki alinigave. Itó nenegó nomive. Neza aménehitoka itekinake Sikalahú amisilitomó nenazo, aí zámuzatunú alévolé suni lilí itamó nene není hoza aviligiki alinigave. ");
INSERT INTO gah_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Itó lekelisi nene není nugulizá ali miniki netá makokumú voká litamó nene, aménehini agulizá ale hutilí itove loko gele lekemekogó minanogo uve. ");
INSERT INTO gah_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Není nugulizá ali miniki netá makokumú voká litamó nene gele likiminogo uve. ");
INSERT INTO gah_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Likigika nenitoka miliaká niamó nekoma nene není gakó gili alinigave. ");
INSERT INTO gah_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Lá niiko, nénisi aménehitoka lokugo, izotipo loló oko luhusatini ale kii liti ve amiselekiko, lemeko lekezagi mino lúaló moloko minanogo ive. ");
INSERT INTO gah_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Gakó gihila gotoláa nene Sikalahukumú noluve. Nene monó gelema vegenalite aí ánigi hee hee lamamó, itó mogonalamú gili hee hee lamamó. Nenemú aí aleminigave. Lá onoimóza, lekezagi minake likigikagú lemeko minoaká noimó nenazo, mogonala nene lekelisi gilinamóma neve. ");
INSERT INTO gah_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Neza ahulolikimikugo, megusa lilí iki minikatave loko neza lekelitoka goha anogo uve. ");
INSERT INTO gah_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Gamena alínipa makó neize. Nene gamena asú noiko, monó gele zagemita vegená nenete není goha ánigamitamóza, lekelisi nene ániganigave. Neza gosohá minoloko iteakalímini amelaho nounazo, lekeza áminagó iki gosohá miniliki itinigave. ");
INSERT INTO gah_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Gamena nene zupa lekeza nene améneho není ale akiseneive itó lekelí neza ale akiseneive itó lekelisi není ali akisinave liki gili hee hee linigave. ");
INSERT INTO gah_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Makó keza negepagutí gakó ali miniki gili aliaká nia vegená nene lamaná kigika nimiaká nia vegená niave. Itó kigika nimitamó nene, améneho agika kiminogo ive. Itó nezánegi nigika kiminake mogonáne lo utó oko lo kiminogo uve. ");
INSERT INTO gah_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Loko lokago, Kaliotó numutotí ve Zutani apolaho loká otake Guivahanitemaka, geza nana okoko mogonaka lelitokagó lo utó okoko monó gelema vegenatoka halá gitane. ");
INSERT INTO gah_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Loko lokago, láa loko lo amimó: Ve makolímohe agika nimitimó nenémo gakóne nene gele alekiko, améneho áminagó oko agika aminogo ive. Lá okoko nezagi lositá aitoka voko anitekisinake agikagú minoko aleko inogo usive. ");
INSERT INTO gah_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Makó keza kigika nememitamó nene, gakóne gili aleminigave. Itó gakó imane lo nolukumumó nene není gakó nomive. Améneho nimisili vémini gakó lo nolukumuve. ");
INSERT INTO gah_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Neza nene lekezagi minuke gakó imane lo lekemeaká noumóza, ");
INSERT INTO gah_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","izotipo loló oko luhusatini ale kii liti ve Sikalahú nene améneho není nugulizató amiselekiko, lemeko netá mukikumú apí o lekemeko nénisi lo lukumu gakó nene ale gosohá oleketoko lo lekemeko minanogo ive. ");
INSERT INTO gah_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Není helisa nene hulu nolukumuve. Hanuva vegenalitini hulu lekememuve. Nezáne hulu nene nolukumuve. Nenemú likigika nene ololó okoko lekehelele vizemino. ");
INSERT INTO gah_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Neza voko nomininake lekelitoka goha atiginá itove loko lo nolukumugo gilinamóma neve. Likigika nenitoka miliiki minamó nelina nene, améneho nivilegeko noinazo, aménehitoka ititokumú giliiki mulutikú lamaná geleline. ");
INSERT INTO gah_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Imane netá utó okiko lekeza ánigiki nenikumú gili alévolé itave loko ámina netá utó onamigo goí oko lo nolukumuve. ");
INSERT INTO gah_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Neza nene gakó mukí miní ameko lo lekememitove. Imane mikasigú agulizaki ve Satá nenitó oko nehelú itove loko ale vatí okave. Áisi nene okoko ma nehelú aminogo imóza, ");
INSERT INTO gah_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","monó gelema vegenalite nigika aménehini ameaká noumó itó hoza gakó lonetamó nene aleaká noumó nene ánigi hee hee litave loko imane suni aleaká nouve. Lekeza otilo. Mota vitunize, loko limó. ");
INSERT INTO gah_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Izesú miní ameko láa loko lo limimó: Neza nene vain nagá mogonáa lamaná nouve. Itó améneho nene vain mini amelaho noive. ");
INSERT INTO gah_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Nenitokatí izana makolímo gihila zemitimó nene hukoko alahulanogo ive. Itó hupena makolímo gihila zekiko, gihila vauva aleko zitive loko golesa itimoláa huko ahuloaká noive. ");
INSERT INTO gah_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Lekeza nene monó lo lukumugo gili alévolé niatímo likigikagú mota guluvitiaká niave. ");
INSERT INTO gah_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Lekelisi nene nenitoka iki apiziki minatamó nene, neza lekelitoka voko apizeko minanogo uve. Izana makolímo mogonaló apizeko minamitimó nene gihila zeakaláa ma nomive. Lekeza nene nenitoka iki apizemitamó nene, lekelitoka áminagó oko gihila ma zeminogo ive. ");
INSERT INTO gah_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Vain nagá mogonáa nénisi nene nouve, itó lekeza nene izanáa niave. Makó keza nenitoka iki apiziki minatamó nene, neza áminagó oko keitoka voko apizekugo, keitoka gihila mukí zinogo ive. Lekeza nene nenitoka gímizemiki netá gihila lilí iakaláa ma nomive. ");
INSERT INTO gah_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Makó keza nenitoka iki gímizemitamó nene, izanagitana oko gulugulu vizekiko, hukoko alahulanogo ive. Izanáa nene gulugulu vizekago, hukiki lokú giziaká niave. Nenitoka iki gímizema vegenatoka ámina suni utó inogo ive. ");
INSERT INTO gah_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Lekeza nene nezagi apiziki minatamó itó gakóne likigikagú minatimó nene, netá nemú manamú voká litamó nene, utó olikiminogo ive. ");
INSERT INTO gah_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Lekelitoka gihila mukí zekiko, lekeza lamaná není vegenáne zuha lilí iki minatamó nenémo aménehini lapaná nene gonanalivagi utó inogo ive. ");
INSERT INTO gah_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Améneho nene agika nemeaká noive. Neza ámináminoko nigika ameaká nouve. Lá okago, lekeza nene nigika lekemeaká noutímini agikagú minalo. ");
INSERT INTO gah_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Neza améneho loneta gakó gele alekuke, agika nemeaká noitímini agikagú noumó neve. Ámináminiki loleketonou gakó gili alitamó nene nigika lekemeaká noutímini agikagú minanigave. ");
INSERT INTO gah_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Není mulúnegú agila guluma oaká noi netá nene mulutikú minative loko, itó mulutikú agila guluma itimó nenémo hutilí oko vaí oko minative loko gakó imane lo lekeme asú nouve. ");
INSERT INTO gah_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Láa loko nololeketuve. Nigika lekemeaká noumó nenéminiki lekezagi likigika eza amiko eza amiko iliki viki minalo. ");
INSERT INTO gah_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Makó eza agivelaginimule loko minoko aleko imoláa ahulatimó nene, agika kimimómámini mogona utó inogo ive. Haitolíminoko agika kemeaká nenémo lá oko agika kimi suni avilegemitimó neve. ");
INSERT INTO gah_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Lekeza loleketonou gakó ámegetatamó nene zogone milanigave. ");
INSERT INTO gah_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Gelekelé izegipa makolímo gizapa vevámo oko moloko i netakumú geleminazo, neza goha lekelikumú nene gelekelé izegipáneve loko lamitove. Neza nene aménehitokatí gakó gulumó nene lo utó oko lo lekeme asú okumó nenazo, itína lekelikumú zogone niave loko litove. ");
INSERT INTO gah_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Lekelisi není nene nilími etó amave. Nénisi nene lekelémo etó okugo, lekeza viki gihila ali utó ikiko alévolé oko minova minova oko minative loko loleketumóma neve. Lá iiki není nugulizá ali miniki netá nemú manamú aménehitoka voká litató likiminogo ive. ");
INSERT INTO gah_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Likigika eza amiko eza amiko itave loko nololeketuve. ");
INSERT INTO gah_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Monó gelema vegenalite lova ali likimikikoma Guivahanite mikasigú noigo goí iki lova ali amemóma neve liki gili minalo. ");
INSERT INTO gah_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Lekeza monó gelema vegenalitini mulusigutí minalina, keza kigika lekemeline. Neza nene holúikutí lekelémo etó okugo, keza iki miliki a netá nene lekeza ahulikamóma nenazo, nenemú lova ali likimiaká niave. ");
INSERT INTO gah_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Gelekelé izegipalaló lilí itatamó nenémo gizapa véa lilí ita netá avilegeminogo ive loko lo lukumu gakó nene lakagatí molamino. Keza není gopoguni milinimiaká nianazo, lekezagi áminagó iki gopoguni mililikitanigave. Není gakó ali gúemamó nenazo, lekelí gakó ámináminiki ali gúeminigave. ");
INSERT INTO gah_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Nimisili ve ánigi hee lamamó nenazo, nenemú není nugulizá lekelitoka minakumule liki lá ilikitanigave. ");
INSERT INTO gah_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Neza keitoka lemeko utó oko gakó lo kememumó nelina, lihimáini minamiline. Lá okamóza, lo kemenoumó nenazo, lihimaváini nana iki ahulatamó neve. ");
INSERT INTO gah_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Lova ali nimiaká nia vegenalite aménehinigi áminagó iki lova ali amiaká niave. ");
INSERT INTO gah_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Neza holúikú haitó suni golivagi nene vegenalite ali utó amatímini ale utó amumó nelina, keitoka lihima nomimó minaline. Itó imane alekugo, keza ániginamó ánigi ahulinake, není lova ali nimiaká niake aménehini áminagó iki lova ali nameve. ");
INSERT INTO gah_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Lá ikago monó gotolaú gakó makó láa liki luhuva gizinamó nene alévolé oko neve: Keza nene hanuvamú není lova ali nemeve. ");
INSERT INTO gah_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Izotipo loló oko luhusatini ale kii liti ve gakó gihilámini amelaho Sikalahú nene aménehitoka noive. Aí amiselekugo, aménehitokatí lemeko mogonáne lo utó inogo ive. ");
INSERT INTO gah_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Itó lekelisi nene hoza apí ukutí nezagi miniliki itinamó nenazo, lekezagi áminagó iki mogonáne li utó inigave. ");
INSERT INTO gah_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Alikaloka netá golesa nalilikitikoma, monó ahulikatave loko gakó imane lo nolukumuve. ");
INSERT INTO gah_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Lá iiki monó numutini hizi lí ilikitanigave. Itó gamena makó alitanogo ive. Lá noiko, Ómasi nasahilí notupe liki likipili hilinigave. ");
INSERT INTO gah_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Keza nene aménehinigi nezagi ánigi hee hee lamiki nene suni alinigave. ");
INSERT INTO gah_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Neza goí oko imane lo nolukumu gakó nene alévolé okiko, ameteho gozapá lo limi gakóma gihila zekave liki gilinigave. Hoza apí u gamenaló lekezagi minoko aleko ituni gamena hána ha nego lo lekememumóma nemóza, ");
INSERT INTO gah_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","itína nene nimisili vémitoka atiginá oko vinogo ugo, lekelikutí ve makolímo hitoka vitane loko loká onetamive. ");
INSERT INTO gah_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Gakó imane lo lekemekugo miluma netalímo likigikagú vaí noize. ");
INSERT INTO gah_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Lá noimóza, neza gakó gihila litoze, gililo. Neza atiginá oko aménehitoka ititomó nenémo netá gihila ale utó oleketanogo ive. Ahulolikimioko itemulina, hize lé oleketati ve izotipo nene lememiline. Itekinake amiselekugo, lekelitoka liminogo ive. ");
INSERT INTO gah_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Lemeko mikasiuka monóini nomi vegenalitini lihimáinímini mogona itó hee loko minoko aleko oakalímini mogonamú itó lihima limititímini mogonamú lo utó okiko gili hee hee linigave. ");
INSERT INTO gah_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Keza nenikumú gili alévolé amanazo, lihimáinímini mogonamú lo kemekiko gilitave. ");
INSERT INTO gah_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Neza aménehitoka atiginá oko itekugo, goha není ánigaminigi anazo, hee loko minoko aleko oakalímini mogonamú lo kemekiko gilinigave. ");
INSERT INTO gah_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Imane mikasiuka agulizaki ve Satani lihimamú mota goní okamóma nenazo, goní oakalímini mogonamú lo kemekiko gilinigave. ");
INSERT INTO gah_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Gakó lo likimitomó mukí nemóza, itína litá oko lo lekeme asú okugo, gena lekepelekatize. ");
INSERT INTO gah_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Gakó gihilámini amelaho Sikalahú áisi lemekoko gakó gihilagú lekelémoko vinogo ive. Nene ezáa agata geleko lo likimitigopa, nenitokatí itó aménehitokatí gakó geleoko lo likiminogo ive. Lá okoko alika utó iti netakumú lo lekeme lekeme oko minanogo ive. ");
INSERT INTO gah_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Gakó nene nenitokatí alekoko lo nolikimioko není nugulizá ale napa inogo ive. ");
INSERT INTO gah_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Aménehitokatí netá matá nene nenikó neme asú onoimó neve. Nenemú Sikalahulímo nenitokatí gakó alekoko lo likiminogo ive loko mota lo lekemekuve. ");
INSERT INTO gah_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Lekeza gamena koma niminiki není goha ánigaminigave. Nenémini veletó koma miniiki není goha ániganigave. ");
INSERT INTO gah_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Loko lokago, vegenala zuha lugáa leza logele hagele unike gakó imane nana gakó nolive. Gamena koma niminiki není ánigaminigave, itó nenémini veletó koma miniki není goha ániganigave, itó aménehitoka atiginá oko ititove loko nolimó nene nana gakó nolive. ");
INSERT INTO gah_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Loko lunike, gamena komamú nolimó nene nana gamenamú nolive. Gakó limó nenémini mogona gelemune. ");
INSERT INTO gah_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Loko lokunike, loká otanogo nouko Izesú geleake láa loko lo limimó: Gamena koma niminiki není ánigaminigave, itó nenémini veletó koma miniki není goha ániganigave loko lo lukumumómamú ligili hagili niahe. ");
INSERT INTO gah_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Lamaná lo likimitoze, gililo. Lekeza nene ive nama iki niminiko, monó gelema vegená nenete kogoliza vizinigave. Itó lekeza miluma giliki minanigave. Lá niiko, ale viligokiko mulutikú agila guluma inogo ive. ");
INSERT INTO gah_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Vená makolímo izegipa getati gamena alitokiko, miluma gilinogo ive. Minoko getoake, izegipala utó ikumú mulunaú agila guluma itímo miluma gilikumú agatí molanogoive. ");
INSERT INTO gah_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Lekezagi ámináminiki itína miluma gilitamóza, goha ánigolikimikugo, mulutikú agila guluma inogo ive. Lá okiko, ve makolímo ipá oko ale ahulaminogo ive. ");
INSERT INTO gah_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ámina gamenaló netá matakumú není voká linitaminigave. Neza lamaná lo likimitoze, gililo. Lekeza netá nemú manamú aménehitoka voká litamó nene, áisi není nugulizató likiminogo ive. ");
INSERT INTO gah_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Lekeza amunaloka miniliki itetó nene není nugulizá ali minake netá matakumú loká amamóma neve. Mulutikú agila guluma itimó nenémo hutilí oko napa oko minative liki voká liiki alinigave. ");
INSERT INTO gah_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Gakó imane lo lekemeva lekemeva omo iteko minumó nene, anoza gakokutí lo lukumumóma neve. Gamena makó alitanogo ive. Neneloka anoza gakó goha lo lekememinogo uve. Aménehini mogona lo utó oko lo likiminogo uve. ");
INSERT INTO gah_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","27","Gamena nene zupa není nugulizá ali miniki voká litave. Neza aménehitokatí lumu gakó mota gili alévolé iake, likigika nimikakeve loko aménehiki agika lekemekave. Nenemú lekelikumú aménehitoka voká litove loko nene lo lekememuve. ");
INSERT INTO gah_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Neza aménehini ahulomikuke mikasiuka lumumó neve. Itó imane mikasi ahulokinake aménehitoka itinogo uve. ");
INSERT INTO gah_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Loko lokago, izegipala zuhate leza láa loko lo amunimó: Imane anoza lamanike lo utó oko lo lemekane. ");
INSERT INTO gah_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nenemú itínasa geikumú nene vegená keza loká miká igitamago geza netá matá mukikumú gele asú onane loko nogulune. Geza Ómasilokatí lemenimó neve loko gele alévolé onoune. ");
INSERT INTO gah_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Loko lokuko, Izesú láa loko lo limimó: Lekeza itínasa gele alévolé okune liki nilahe. ");
INSERT INTO gah_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Gamena makó alitanogo ive. Alitokiko, není ahulinimiiki hutilí iki numutitoka vi asú inigave. Vikiko, nezánegó minanogo uve. Lá itomóza, aménehiki minanogo usive. Nenemú nezánegó minaminogo uve. Ámina gamena itína mota alitokave. ");
INSERT INTO gah_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Není hulu nenémo lekelitoka minative loko gakó imane lo nolukumuve. Lekeza mikasiuka niminiko gopoguni mililikitatamóza, mulutikú golesa gelemilo. Nénisi nene imane mikasiuka mukí netá avilege nou vema nouve. ");
INSERT INTO gah_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Izesú nene gakó lo asú oake, okulumakuka ánigo nomolake láa loko limó: Aménegamaka, gamena mota alitokave. Geza gipakámini lapaná ale utó molokako, gipakámina neza geí lapaná ale utó molatoze. ");
INSERT INTO gah_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Géisi numutó namató vegenalitini améipina nelémo loló animó nene nenitoka kelémo molani vegená nene alévolé kemetameni kimitove loko lá animó neve. ");
INSERT INTO gah_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Alévolé kemetamenímini mogona lá oko neve: Ómasi gihila hamokó geí mogonaka itó nimiseleni ve gipaka Izesu Kilistó není mogonáne giliniko, alévolé kemetameni nene utó o kiminogo ive. ");
INSERT INTO gah_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Hoza nememimó nene, ale lutegekuke, mikasiuka geí lapaná ale utó okuve. ");
INSERT INTO gah_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Kee, aménega, mikasi velesá utó amigo gezagi makó okulumá lapanánegi minumó nene itína govogisaló nougo ámina netá goha nemekako ale minatove loko noluve. ");
INSERT INTO gah_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Mikasiuka vegenakutí makó nenitoka kelémo molanimoláa nene mogonaka avetó oko lo kemenoumóma neve. Geí mututoni nenitoka kelémo molokako, keza geí gakó gili alikave. ");
INSERT INTO gah_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Itó nenitoka netá nemó nene geitokatikó neve liki mota gilinave. ");
INSERT INTO gah_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Itó gakó lo nemenimó nene lo kemekugo, mota gili asú inave. Itó géisi nimiselekako geitokatí lumumó neve liki mota gili seketigí ikave. ");
INSERT INTO gah_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Neza keikumule loko geitoka noluve. Monóini nomi vegenakumú lamuve. Nemenimó keza geí mututoni niamó keikumú noluve. ");
INSERT INTO gah_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Itó není mututoni nene geí mututoni niave, itó geí mututoni nene není mututoni niave. Itó iki miliki niamó nenémo není lapaná ale utó moloaká noive. ");
INSERT INTO gah_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Neza mikasiuka minato gamena mota asú noive. Kéisi nene miní amiki niko, neza geitoka mota itinogo uve. Etó keké vizeko noani aménega, geí gugulizá kumumó nenémini zámuzatunú ale gilitokimikako, nenémini agikagú avasavagi minatave. Lá okiko leza ligika hámakó nemómáminoko keza kigika hámakó minatize. ");
INSERT INTO gah_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Kezagi makó minuni zupa nene, nenitoka kelémo molani vegená nene gugulizalímini zámuzatunú gizapa oketoko minugo, nenémini agikagú minamó. Lá okago, gizapa okimikugo, gopa amamóma neve. Monó gotolaú luhuva gizina gakó makó alévolé itive loko lolímini mututoni hámakó nene latila imó neve. ");
INSERT INTO gah_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Itína geitoka vinogo nouke, imane mikasiuka vegenáne zuhatini mulúikú agila guluma itimó nenémo hutilí oko napa oko minative loko láa loko lo nogumuve. ");
INSERT INTO gah_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Neza gakoka lo kemenoumóma neve. Neza mikasiuka mututoni minamuve. Kezagi ámina iki mikasigú mututoni minamanazo, monó gelema vegená nenete lova ali kimiaká niave. ");
INSERT INTO gah_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Géisi není vegenáne zuha mikasiukatí kelématane loko lamuve. Ve golesa Satakumú geisa hizeko gizapa oketatane loko lo nogumuve. ");
INSERT INTO gah_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Neza mikasigú mututoni minamuve. Itó ámina iki keza mikasigú mututoni minamave. ");
INSERT INTO gah_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Gakó gihila kigikagú limitimoláatunú kelémo etó ozo. Geí gakó nene gihila neve. ");
INSERT INTO gah_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Géisi nene mikasiuka hoza gakó lonetoko nimiselenimó nenéminoko mikasiuka hoza gakó lokimikuke nokimisuluve. ");
INSERT INTO gah_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Geí gakó gihilámo kigikagú lemekoko kelémo etó okiko minatave loko nezáne nigikáne nugupéne ale etó oko nomuluve. ");
INSERT INTO gah_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Itó neza keikumukó geitoka lamuve. Keza li kimikiko nenikumú gili alévolé ita vegenakumuki geitoka noluve. ");
INSERT INTO gah_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Kigika hamokó miniko minatave loko lo nogumuve. Aménega, geza není akisenane, itó neza geí akisenoumó nene kezagi ámina iki akisikisiko, monóini nomi vegená keza nimiselekako lumumó neve liki gili seketigí itave loko noluve. ");
INSERT INTO gah_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Leza ligikate hamokó neve. Ámina oko keí kigika hamokó miniko minatave loko lapanaka nemenimó nene ámina oko kemekuve. ");
INSERT INTO gah_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Lá umó nene neza nemeni kumugo, itó geza gemeni nemekako, keza kigikatunú múnahiiki hamokó lilí iki minatave loko, itó lá iki niko, monóini nomi vegená kéisi nimiselekako lumumó neve liki gili seketigí itaze, itó gigika nenitoka moloaká noanimó nene ámina oko keitoka moloaká noane liki gili lamaná itave loko neve. ");
INSERT INTO gah_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Aménega, nenitoka kelémo molani vegená nene keza nénisi minatotoka minatave loko noluve. Neneló niiki nene mikasi utó amigo gigika nenitoka molanike okulumá lapaná lehizenetanimó nene ánigi guni itave. ");
INSERT INTO gah_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Aménega gehaváamaka, monóini nomi vegená keza geí mogona gili guni amamóza, nénisi nene gelenouve, itó vegenáne zuha nenete géisi nimiselekako lumumó neve liki gilinave. ");
INSERT INTO gah_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Neza gigika není nemenimó ámina oko keitoka minative loko itó neza ámina oko kigilikaloka minatove loko keí holúikú nene mogonaka lo kemeko minanogo uve. ");
INSERT INTO gah_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Izesú eza gakó láa loko lo asú oake, ezagi vegenala zuhagi leza Kitilona nagamí gímuza vola helegaloka vunike, zazuha makokú itunimó. ");
INSERT INTO gah_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ámina zazuhagú Izesugegi gamena gamena alegesá oaká unimó nenazo, itó amimika liti ve Zutá ezagi ámina apakumú ánigonoimó nenazo, Izesú neneló noinogo ive loko geleneike, ");
INSERT INTO gah_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","guguni giziaká a ve napagi Palisaio monó vegi niatoka vike Izesuni nene kigizakú molatikumú loká okago, mulusi makokú ami vegi itó monó zagusavegú pilisi ve lugáagi kimisilikago, keza ló ligiki aleke lova hiziaká netá aleke, Zutá kelémo goí igo ámina zazuhaloka Izesú noitoka vamó. ");
INSERT INTO gah_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Vi anitikago, Izesú nene aí amupiló utó iti netá mukikumú geleake, keitoka vike loká oketake lekeza éahikumú vitagá niave. ");
INSERT INTO gah_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Loko lokago, keza Nasalete ve Izesunimamú vitagá noune liki likago, Izesú nene nezama imane nouve loko lo kimimó. Loko lokago, amimika li ve Zutá nene holúikú minake, ");
INSERT INTO gah_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","ezagi kezagi Izesú li gakokumú kemegesalokatí nivake mikasiló pou liki akimi vamó. ");
INSERT INTO gah_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Lá ikago, goha loká oketake lekeza éahikumú vitagá niave. Loko lokago, keza Nasalete ve Izesunimú vitagá noune liki likago, ");
INSERT INTO gah_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Izesú láa loko lo kimimó: Nezama imane noumole loko mota lo lekemekuve. Nenemú nenikumú vitagá niikima, izegipáne zuha imane ahulikimikiko hanuva vitaze. ");
INSERT INTO gah_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Loko lokago, nenitoka kelémo molani vegutí makó tolova amitive loko amunaloka li gakó nenémo alévolé imó. ");
INSERT INTO gah_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Lá okago, Saimon Pitá eza sopolo aleneimó nene golagutí aleko segeake, guguni gizoaká vetini ve napámini gelekelé izegipala agulizá Malakusini apilike, zamagaloka agata zeko isimó. ");
INSERT INTO gah_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Lá okago, Izesú nene Pitani láa loko lo amimó: Sopolo nene goha golagú ale gúezo. Améneho miluma netá gihitane loko lonetonamóma nenazo, gehemitane loko lá noape, loko limó. ");
INSERT INTO gah_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Lá okago, ami vegi monó gizapa veninigi Zuta vetini pilisi vegi keza Izesuni agizató aliake nagá alemó. ");
INSERT INTO gah_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Nagá aliake, apí iki alímiki viki Kaiapani venalámini amelaho Anasí noitoka alímiki vamó. Kaiapá nene ámina kilisimasi oko novigo Zuta vetini guguni giziaká vetini gizapa ve minake, ");
INSERT INTO gah_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","amunaló emane Zuta ve kagata alike leza mukitó helekatunize, ve hamokolímo lelémo nupa napa oko helekiko nenémo netá gihila ale utó oletative loko li ve minamó. ");
INSERT INTO gah_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Lá okago, Saimon Pitako Izesuni izegipala zuhagutí ve makó Izesuni ámegetoko vusi ve nene guguni giziaká vetini ve napa nenémo není ánigonoimó nenazo, Izesuki makó vusike guguni giziaká vetini geisa mikú nanitusigo, ");
INSERT INTO gah_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pitá nene geisa gatetoka oteneigo, neza vuke gatetó gizapa noi venáma lo amekuke, Pitani alémoko geisa mikú itusimó. ");
INSERT INTO gah_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Itekusigo, ámina venalímo Pitani loká otake geza nene ámina goní nita vémini izegipa zuhagutí makó noape. Loko lokago, Pitá nezama noamuve loko limó. ");
INSERT INTO gah_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Lá okago, hepé legekago, gelekelé vegi gimisigi vegi keza lóo lotá itune liki ló lokunusa ló gizikago, Pitá nene kezagi ote minake lóo lotá oko minamó. ");
INSERT INTO gah_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Lá noigo, guguni giziaká vetini ve napa nenémo izegipala zuhamuki apí o kemeaká i gakokumuki Izesuni loká otamó. ");
INSERT INTO gah_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Loká omikago, Izesú láa loko lo amimó: Neza numutó namató vegená lo utó okogó lo kemeaká umóma neve. Neza nene lekelí monó numutikú itó monó zagusave napagú lekeza Zuta ve alegesá iaká niató nene gakó apí o kemeaká onouve. Neza nene asugunatoka gakó makó lo kemesá amuve. ");
INSERT INTO gah_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Geza není nene nanamú loká nonetane. Není gakó gilina vegená nene lo kumu gakokumú nanave loko limó neve loko loká oketozo. Lo kemeaká nou gakó nene keza gilinave. ");
INSERT INTO gah_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Loko lokago, pilisi ve makó áminaló ote minamó nenémo agizanitunú Izesuni napilike guguni gizoaká ve napama nene geza gakó nenémináa nanamú lo namene. ");
INSERT INTO gah_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Loko lokago, Izesú láa loko lo amimó: Neza gakó golesa makó lonoitomóma lo utó ozo. Gakó lamaná lo nolukumugo nanamú nonepelene. ");
INSERT INTO gah_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Loko lokago, Anasí nene nagatunú nene Izesuni agizató goha nagá zeake, guguni gizoaká vetini ve napa Kaiapá noitoka amiselekago alímiki vamó. ");
INSERT INTO gah_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Lá noigo, Saimon Pitá nene lóo lotá oko oteneigo loká itake gezagi ámina vémini izegipala zuhagutí noape. Liki likago, eza egamega ike neza aí zuhagutí noamuve. ");
INSERT INTO gah_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Loko lokago, guguni giziaká vetini ve napámini gelekelé izegipala Pitá agata zeko isi vémini zuhagutí ve makolímo loká otake gezagi zazuhagú niasigo ánigo noumóma neve, olo. ");
INSERT INTO gah_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Loko lokago, Pitá goha egamega okago, áminaló litá oko okoloho nenémo anó molamó. ");
INSERT INTO gah_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Lá okago, Izesuni nene Kaiapani numukutí alími hetó iake, alímiki agulizaki vémini numutoka vamó. Viake, neteká holugú nego, avóikini asenini zeketakumú gili mina nosá nanigi niake Zuta veta amosá suni aleko hetoka ve makolímini numukú itekinake ligika ale golotuva lokatune liki kezáini nene agulizaki vemámini numukú itemamó. ");
INSERT INTO gah_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Lá ikago, Pilató nene hetoka lemeake, loká oketake lekeza iki imane ve nanamú goní nitave. ");
INSERT INTO gah_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Loko lokago, keza láa liki lamó: Imane ve eza netá golesa aleaká ve minamilina, leza agizató aleko geitoka alémoko amutiline. ");
INSERT INTO gah_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Liki likago, Pilató láa loko li kimimó: Lekezatini agizató aliiki lekezatini li huka gakotinimaló ali miliki goní italo. Loko lokago, Zuta vetini monó gizapa vete zohota zaló hilitive liki giliake láa liki li amemó: Óe, lezatete ve makó apele helesakumú nene lekelí gamanímo óe loko lo hukonoimóma neve. ");
INSERT INTO gah_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Liki likago, zohota zaló vegená kepele heleaká nene Loma vetini mogona minokago, Izesú nenéminoko hilitove loko amunaloka lo kimi gakó nene alévolé inogo imó. ");
INSERT INTO gah_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Lá okago, Pilató goha kugulizaki vetini numukú iteake Izesuni sele lo ameake loká otake geza nene Zuta vetini kugulizaki ve napa noape. ");
INSERT INTO gah_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Loko lokago, Izesú láa loko lo amimó: Gezaka gagata geleko nene gakó nolape, itó ve makolite nenikumú láa liki li gimikago nolane. ");
INSERT INTO gah_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Loko lokago, Pilató láa loko lo amimó: Neza Zuta ve nougo nolape. Gezaka vegenakagi itó guguni giziaká ve napagi gilímiki nenitoka iminamóma neve. Geza nana netá golesa loló okako neve. ");
INSERT INTO gah_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Loko lokago, Izesú láa loko lo amimó: Neza nugulizaki ve napa noumóza, nenémini mogona nene imane mikasigú vetini suni nomive. Imane mikasiuka netá minalina, Zuta vetini kigizakú nilími milikatave liki izegipáne zuhate lova ali utó alinamóza, nugulizaki ve minato mogona nene imane mikasigú vetini suni nomive. ");
INSERT INTO gah_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Loko lokago, Pilató láa loko lo amimó: Láa lokoma geza nugulizaki ve napa nouve loko nolape. Loko lokago, Izesú láa loko lo amimó: Nene nugulizaki ve nouve loko gezaka mota lokane. Neza gakó gihila lo utó itove loko imane mikasiuka lemekuke, izóneho getokago nouve. Gakó gihila giliaká nia vegená mukilite negepagutí gakó giliaká niave. ");
INSERT INTO gah_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Loko lokago, Pilató nene gakó gihila nene nana gakó neve. Loko loake, Zuta vegenatoka hetoka lemeake, láa loko lo kimimó: Imane vémini lihimavalamú vitagá umó nomive. ");
INSERT INTO gah_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Lá onoimóza, lekezatini mogona lá oko neve. Avotikini asenini zeketakumú gili mina holisigú kilisimasiló kilisimasiló nene lekezatini ve makolímini agulizá ikago, nagá numukutí ve hamopamó kimisele ahulo ahulo oaká nougo lekelitoka viaká niave. Itó imane gilikiko etokikoma, Zuta ve lekelí agulizaki velini aseva zemikugo lekelitoka vitihe. ");
INSERT INTO gah_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Loko lokago, keza nene negénegeka lake gakó napagutí nene Óe, aí nomive. Palapasini aseva zetamane. Liki lamó nene Palapasí nene laskoli ve nenae. ");
INSERT INTO gah_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Lá okago, Pilató lokago, segi nogosanitunú nene Izesuni apiliake, ");
INSERT INTO gah_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","agulizaki vema nenae liki anosa netá lilí itiake ami vete uhenagi nagatunú akilí lilí iki gotolaló hitimiake, ginegane hána luhuvagi okohu gó luhitamó. ");
INSERT INTO gah_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Lá iake, amatoka hizi letiki niake, ganimakilisi i ameke Oga, mokáne, Zuta vetini kugulizaki véinimave. Nilake, kigizanitunú Izesuni agokaló zemó. ");
INSERT INTO gah_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Lá ikago, Pilató nene Zuta ve niatoka goha limike láa loko limó: Ánigalo, lihimavalamú vitagá umó nene nomive liki gilitave loko lekelitoka alémoko nouve. ");
INSERT INTO gah_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Loko lokago, Izesú nene uhenagi akiliki okohu gó luhoake keza niatoka lemeko noigo, Pilató nene nokelepizike imane ve ánenémináa ánigalo. ");
INSERT INTO gah_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Loko lokago, guguni giziaká a ve napa keza vegenáinigi Izesuni ánigiake, gakó gamoga geke zohota zaló apele helemane. Zohota zaló hilitinae. Liki likago, Pilató nene konotó alike láa loko limó: Neza nene lihimavalamú vitagá umó nomize. Nenemú lekezatini alímiki viki zohota zaló apililo. ");
INSERT INTO gah_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Loko lokago, Zuta vetini monó gizapa ve keza láa liki lamó: Ezáamú Ómasímini gipala nouve loaká noimóma nenae. Nenemú ve nenémináa nene hilitave liki li hukilita gakokú luhuva gizinamóma nenazo, mota hilitive. ");
INSERT INTO gah_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Liki likago, Pilató nene Ómasímini gipala noive liki lakumú alegesá goha ligimó. ");
INSERT INTO gah_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Alegesá legekago, Izesuni nene goha numukú alémoko itike loká otake géisi hikutí utó animó neve. Loko lokago, Izesú nene anotó alemimó. ");
INSERT INTO gah_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Anotó alemigo, Pilató láa loko lo amimó: Geza gakó nene lo nememane. Neza lokugo hanuva minanogo ane, itó nénisi lokugo zohota zaló hilinogo ane. Nenémini zámuza niminamóma nenae. Nene gelemape. ");
INSERT INTO gah_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Loko lokago, Izesú láa loko lo amimó: Není gakó litane loko veletokatí Ómasímo zámuza gememilina geza není gakó nana oko latiline. Nene nolanimole. Nenemú nene geitoka nelémo mola vémini lihima givilegeko napa napa neve, loko lo amimó. ");
INSERT INTO gah_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pilató nene gakó geleake, Izesuni nene aseva zetatove lokago, Zuta vete ganimakilisi ake láa liki lamó: Geza nene imane ve aseva zetatanimó nene, Loma apatoka agulizaki ve napámini agivelaho minaminogo ane, itó asú igitanigave. Itó makó eza ezáamú nugulizaki ve napa nouve loko litimó nene Loma apatoka agulizaki ve napa Sisani aviligitohe loko lova gizo aminogo ive. ");
INSERT INTO gah_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Liki likago, Pilató nene geleake, lokimikago, Izesuni alímiki limikago, gakó lo hukoaká holomaló lemeko minamó agulizá nene Hipulu gakokutí nene Gapatave liaká amó, lelí gakokutí nene geha holomave loko. ");
INSERT INTO gah_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Itó avotegini asenini zeketakumú azo holisi minatune liake, netá matá ali vatí niago, holisaká gamena noigo, Pilató nene holomavaló noike, Zuta vetini gizapa ve nene agulizaki velini imane ánigalo. ");
INSERT INTO gah_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Loko lo kemekago, keza ganimakilisi ake zohota zaló apele helemane liki likago, Pilató láa loko limó: Íi, agulizaki velinima lekelisi likiko zohota zaló hilitive liki nilahe. Loko lokago, guguni giziaká a ve napa keza gakó láa liki li amemó: Leza nene agulizaki vele makó nomive. Loma apatoka agulizaki ve napa Sisá hámakó noive. ");
INSERT INTO gah_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Liki likago, Pilató nene ake, Izesú nene zohota zaló nilitunú ziki apili hilitave loko kigizakú molamó. ");
INSERT INTO gah_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Lá okago ami vemate Izesuni alímiake, zohota za amikago, gihigo, apá makó agulizá nene gotóini gonosi helisa apale loko, itó Hipulu gakokutí Goligota loko neneloka alímiki vamó. ");
INSERT INTO gah_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Alímiki vake zohota zaló apiliki apatemó. Lá iake, ve golesa lositá luga luga kipiliki apatemó. Izesuni nene holukú hizi otitamó. ");
INSERT INTO gah_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Lá ikago, Pilató lokago nene, Izesuni gotolaló zaló luhuva láa liki gizikago minamó: Nasalete numutotí Zuta vetini agulizaki venini Izesú ave. ");
INSERT INTO gah_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Nene mikasi Zelusale numuni símekaló minanazo, Zuta vegená mukí vigá igá niake ámina luhuva gatamó. Nene luhuva nene Hipulu gakokutí itó Loma gakokutí itó Kiliki gakokutí luhuva gizikago minamó. ");
INSERT INTO gah_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Lá ikago, Zuta vetini guguni giziaká a ve napa keza Pilatoni láa liki li amemó: Zuta ve lelí agulizaki veve loko luhuva gizamoko, neza Zuta vetini nugulizaki ve nouve loko limó neve loko gizamane. ");
INSERT INTO gah_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Liki likago, Pilató nene mota luhuva gizokutó neze, ha minatize, loko limó. ");
INSERT INTO gah_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Lá okago, ami ve keza Izesuni nene zohota zaló apiliki apatiake, gineganeva gona miliake, losive losive okago, amelaho ve lilí i asú amó. Lá ikago, gola hána miní amiki akotamamó mukipa gó minokago, ");
INSERT INTO gah_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","nenemú láa liki lamó: Hukoko alesá golesa okatize, nenemú zohikú molokuko winititímo nene amelaho ve loló itive. Liake lá ikago, monó gotolaú nene není ginegane ali gona miliki, nugupeló netá nene zohikú milikamó neve liki luhuva giza gakó nene alévolé imó. ");
INSERT INTO gah_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ami ve keza nene lá niago, Izesuni zohota za mogonagú nene vegená lá iki minamó: Izolahiki atolahiki itó Kolopani venala Maliaki itó Magatala numutotí Maliá makoki. ");
INSERT INTO gah_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Neneló Izesú agika ameaká i veve liki lina ve nezagi makó nouko, Izesú nene izolahini láa loko lo amimó: Vená geza ánigozo. Ve imane gipaka loló noive. ");
INSERT INTO gah_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Loko loake, láa loko lo nimimó: Vená imane ánigozo. Geí izokahove. Loko lokago, ámina gamenaló Izesuni izolahini alémoko vuke numúneuka minoko aleko usimó. ");
INSERT INTO gah_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Izesú nene mota hoza ale asú okuve loko geleake, gihila zitive loko monó gotolaú mina gakó makó láa loko limó: Nagamikumú nivisekave. ");
INSERT INTO gah_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Loko lokago, neneló lape makokú ekesá vain nagamí lagasó ma nego, nenegú notunigitana netá nagamí ziake, zokaitunú hiziake agepagú amikago, namó. ");
INSERT INTO gah_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Vain nagamí nene noake, sele like mota hozane ale lutegekuve. Loko loake, gotola nene gupá zeake sikalahula ahuloake hilimó. ");
INSERT INTO gah_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Lá okago, Zuta vetini monó gizapa ve keza gó lokiko avóikini asenini zeketakumú gili miniaká a holisigú minanigi netá ali vatí niake, ámina holisi nene napa napa nenazo, itó Mosé ve makolímini gonosiva nene límugusigú zaló minatimó etamitive loko lo mola gakó gili minake, Pilatoni láa liki li amemó: Ami ve makó kimiselekako, viki ámina vetini kigisa helisáini zi letiiki gonosíini nene zalotí aliliki limiki gale zikitatave loko noune. ");
INSERT INTO gah_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Liki likago, gele kemekago, ami ve keza golesa netá alesi ve Izesuki makó kepele vetosini kigisa helisa zi letiake, ");
INSERT INTO gah_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","viki Izesuni ánigamó nene mota helekago, ánigiake, agisa helisa nene zi letamamó. ");
INSERT INTO gah_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Lá okago ami ve makolímo zokaitunú nene alómusagú hizekago, golanigi nagamiki nene áminagutí litá oko limimó. ");
INSERT INTO gah_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Nene suni nene nogómula gihilatunú ánigokuke lo utó noumó nene soza nomive. Gakó gihila neve loko gelekuke lekeza ámina gakó gili seketigí itave loko gizo nolukumuve. ");
INSERT INTO gah_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Monó gotolaú anoza gakó makó lá oko nemó nene, gihila zitive loko ámina suni utó imó: Lekeza nene helisa nene ma zi letaminigave. ");
INSERT INTO gah_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Itó monó gotolaú gakó makó lá oko neve: Keza nene zokaitunú hiziki hokolota ve nene ániganigave. ");
INSERT INTO gah_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Lá okago, Alimataia numutotí ve Zosehé áisi Zuta vetini monó gizapa vemú ahelele vizigo minake, asuguná oko Izesuni izegipala mina vémo Izesuni gonosiváa aleko vitohe loko Pilató noitoka voko loká okago, Pilató gele amekago, gonosiváa nene zohota zalotí apasoko aleloko lemekago, ");
INSERT INTO gah_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikotemó nene amunaló emane límugusigú Izesutoka vi vemámo anuva netupa meseme lamanalímini lositá ale gopa oake, sigeliló molamó genava nene 35 kilo okago, geheko vimó. ");
INSERT INTO gah_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Lá oake, Zosehé alémo vatí igo, Izesuni gonosiváa nene ámina netupa meseme hilimikasike, gó gizopa lamanatunú asapú itasimó nene Zuta vete gonosi miliaká a suni alesimó. ");
INSERT INTO gah_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Itó Izesuni apele mikasi agilikaloka zazuha makó minamó. Nenegú geha mulí makó goló vatikago, nego, vegená nenegú gale zikitamago hanuva gosohá minamó. ");
INSERT INTO gah_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Lá okago, holisi gamena mota alitokamómave loko hoza alita gamena asú okago, itó ámina geha mulí nene alitó minamó nenazo, nenegú Izesuni gonosiváa milasimó. ");
INSERT INTO gah_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Holisi napa Sategú nene gó lo mikasiló amigo, Magatala numutotí vená Maliá nene gonosi apató vo aniteake ánigamó nene agepaló gehani napa mili lí amóma ahelú ali ahulinago ánigoake, ");
INSERT INTO gah_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","ololu loko vike Saimon Pitanigi nezagi ánigolimiake, láa loko lo limimó: Guivahanímini gonosiváa mota aliki vikave. Itó nene hikú milamó netive. Leza gelemune. ");
INSERT INTO gah_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Loko lokago, Pitaki nezagi gonosi apatoka makó vusimó. ");
INSERT INTO gah_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Gapoló ololu loko novusike, neza nene Pitani avilegeuke litá oko gonosi galeló vo anituke, ");
INSERT INTO gah_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","gava hizeko ánigumó nene, nagá like gokó nego ánigumóza, áminagú itemuve. ");
INSERT INTO gah_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Lá okugo, Saimon Pitá nene alika oake geha mulí agikagú iteko ánigamó nene, mokoná lavolavo asapú amóma nene nego, ");
INSERT INTO gah_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","itó gotolaló asapú ita gó nene haitó gakeko nego ánigamó. ");
INSERT INTO gah_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Lá okago, nénisi goí oko anitumóma nemóza, alika áminagú itekuke, ámina netakó nego ánigouke, lamaná oteko iteko vokave loko gele seketigí umó. ");
INSERT INTO gah_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Amunaloka nene monó gotolaú Izesú heleneikutí oteko ititive liki gakó gizamó nene gele hee lamusimó. ");
INSERT INTO gah_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Itó leza nene goha numutoka atiginá oko vusimó. ");
INSERT INTO gah_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Vokusigo, Magatala numutotí vená Maliá eza nene gonosi galeló goha vike hetoka ive oko minatotí nene galegú ániganogo gava hizeko ánigamó nene, ");
INSERT INTO gah_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ageló lositá Izesuni gonosiváa goí oko mina galeló gó gizopa luhiki minasike mitó niasigo ánigamó. Makolímo gotolaló minamó. Makolímo agisaloka minamó. ");
INSERT INTO gah_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Minasike vená geza nanamú ive noane liki likasigo, iza láa loko limó: Není Guivahanímini gonosiva aliki vikago, hitoka aliki vahe loko vitagá nouve. ");
INSERT INTO gah_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Loko loake, mino viligoko ánigamó nene Izesú noigo ánigamóza, agoka agepa ánigo vevesamimó. ");
INSERT INTO gah_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ánigo vevesamigo, Izesú loká otake vená geza nanamú ive noane itó éahikumú vitagá noane. Loko lokago, eza nene zazuhagú hoza aleaká ve noihe loko láa loko lo amimó: Ve lamanámaka, géisi nene gonosivama aleko voko makokuka molonoitanimó nene, lo nemekako aleko vitove. ");
INSERT INTO gah_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Loko lokago, Izesú nene Maliazo lokago, eza viligoko Zuta gakokutí laponi, lelí gakokutí nene monó gizapa venemaka. ");
INSERT INTO gah_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Loko lokago, Izesú láa loko lo amimó: Neza nene aménehitoka velesá itemumó nenazo, nenemú nunukemo. Geza nene voko izegipa nugunamotamónema není améneho nene lekelí ametipove, itó není Ómasi nene lekelí Ómasi noitoka itinogo uve loko lo kemezo. ");
INSERT INTO gah_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Loko lokago, Magatala numutotí vená Maliá eza atiginá oko vike Izesuni vegenala zuha nene neza Guivahani ánigokugo gakó láa loko lo nemekave, loko lo limimó. ");
INSERT INTO gah_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Loko lokago, ámina holisi napagú límugusi zekago, izegipala zuha leza Zuta vetini monó gizapa vemú lelegesá legekago, numukú itekunike gahe etoha oko gekunike nouko, Izesú nene holutegú utó oake ote minake hulu nene lekelitoka minino. ");
INSERT INTO gah_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Loko lo lemeake, agizani lositá nolelepizike, alómusagú hize ahúma lelepizekago, izegipala zuha leza Guivahanima ánigokunike mulutegú lamaná gulune. ");
INSERT INTO gah_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Lá okuko, goha láa loko limó: Hulu lekelitoka minino. Améneho nimisilimó áminagó oko lekelí nolikimisuluve. ");
INSERT INTO gah_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Loko loake, huhu loletake, láa loko limó: Ómasímini Sikalahú alilo. ");
INSERT INTO gah_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Lá iiki vegenalitini lihimáini liki ahulatamó nene, asú itive. Liki ahulamitamó nene hanuva minative, loko limó. ");
INSERT INTO gah_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ligiveteho makó agulizá Tomasí agulizá makó Lopé áisi nene makotoka noigo Izesú utó o limimó. ");
INSERT INTO gah_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Utó o lemekago, ve agivelage leza makó zupa Tomasini ánigokunike avetó oko leza Guivahanima ánigokune. Loko lo amekuko, eza limó: Nezáne nogómulatunú agizató ahúma ánigamoko itó nigizanitunú ahúmaló ale gelemoko, itó alómusalokama ale geleko ánigaminake, gakotini nene gele alévolé aminogo uve. ");
INSERT INTO gah_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Loko lokago, holisi makó alitokago, izegipala zuha leza Tomasigegi nene numuni makokú goha ale nupa unike gahe gekunike nouko, Izesú nene ligilikagutí utó oake noike, hulu lekelitoka minino. ");
INSERT INTO gah_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Loko lo lemeake, Tomasini láa loko lo amimó: Gigizani hisukatunú nigizatoka nuhúma ale geleko ánigozo. Itó gigizani ahuloko nolómusaloka ale gelezo. Lá okoko gagata losi gelemoko gele alévolé ozo. ");
INSERT INTO gah_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Loko lokago, Tomasí nene Guivahanínemakave, itó Ómasinemakave. ");
INSERT INTO gah_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Loko lokago, Izesú láa loko lo amimó: Géisi ánigokanike gele alévolé okane. Není ánigamake gili alévolé iaká nia vegenakumú gulugo lamaná okave, loko limó. ");
INSERT INTO gah_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Itó Izesú nene izegipala zuhatini lovogisaló lu avevezaha la avevezaha mukí loló imó nene imane luhuvagú gizo asú amumóza, ");
INSERT INTO gah_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","imane gizonoumoláa lekeza gatiki giliiki Izesú nene gologí oletative loko lo mololeta vema Ómasímini gipalave liki aikumú gili alévolé i miniki alévolé lekemetameni alitave loko gizonoumole. ");
INSERT INTO gah_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Itó minoko izegipala zuha leza Tipelia nonohulotó voko nouko, Izesú nene haitó suni aleko utó o limimó. ");
INSERT INTO gah_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saimon Pitaki lopé izegipa Tomasiki Galilaia mikasigú Kana apatotí ve Natanaeki nezagi uvónehiko losigi aí izegipala zuhagutí makó losimagi leza alegesá oko nouko, ");
INSERT INTO gah_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Saimon Pitá nene neza lagaha alinogo novuve. Loko lo lemekago, lezagi makó vitune loko lokunike, sipigú itekunike vunimó. Voko minunike ámina holugú lagaha alemunike lá ova ova oko nouko, ");
INSERT INTO gah_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","gokululuva notovo igo, Izesú nene getatoka melane minamóza, izegipala zuha leza Izesuni ameni ánigo guni amuko, ");
INSERT INTO gah_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Izesú loká oletake izegipaguvo, lagaha ma alehe. Loko lokago, leza Óe, alemune. ");
INSERT INTO gah_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Loko lokuko, láa loko lo limimó: Gotaha ali zamagaloka miliki ahulatamó nene lagaha alinigave. Loko lokago, gotaha ale zamagaloka molokunike, lagaha vauva aleko alunimó nene gelelehá unimóza, vaí okago, keé loko ale otemuhá. ");
INSERT INTO gah_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Lá okuko, Izesú ameni nemeaká i veve liki lina ve neza nene Guivahanima nenae loko Pitani lo amekugo, Saimon Pitá není gakó geleake, agupe zapakó minatotí gineganeva ale luhoake, nagamikú olío lemeake, galanogosá zeko 100 mitagitana oko voko nagamí getatoka vo anitekago, ");
INSERT INTO gah_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","ve lugáa leza nagamikú lapegú lagaha gotaha gelelehá oko aleko vuhá. ");
INSERT INTO gah_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Voko getatoka itekunike netá makó lá oko ánigunimó. Ló nokusa ale hitikakú lagahagi peleti makoki nego ánigunimó. ");
INSERT INTO gah_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Nániguko, Izesú nene lagaha itína alemómagutí lugáa alikalo. ");
INSERT INTO gah_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Loko lo lemekago, Saimon Pitá nene sipigú iteake gotaha gelelehá oko getatoka ale moloake lagaha napa 153 nene gotahagú vaí iki minamóza, gotaha nene alegetá vizemimó. ");
INSERT INTO gah_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Lá okago, Izesú nene iki neteká nosá nalo. Loko lo lemekago, izegipa leza Guivahanimave loko mota gelenounimómaló nenazo, geza éagama noane loko loká otamune. Loká otamuko, ");
INSERT INTO gah_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Izesú oake, peletigi lagahagi aleake gona moloko limimó. ");
INSERT INTO gah_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Lá imó nene Izesú heleneikutí oteake minake izegipala zuha lelitoka utó o limigo ániguni gamena neneló losive makole loló imó. ");
INSERT INTO gah_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Neteká nosá no asú okuko, Izesú nene Saimon Pitani láa loko loká otamó: Zonini gipala Pitao, gigive keza kigika nimiaká niamó nene kivilegeko gigika nemeaká noape. Loko lokago, Pitá nene Guivahanínemaka, geikumú geleaká noumó nene gelenanimole. Loko lokago, Izesú nene vegenáne zuha kigikámini nosánetá mí zeko kemeko nozo. ");
INSERT INTO gah_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Loko lo ameake, goha lo amike Zonini gipala Pitao, geza lamaná gigika nemeaká noape. Loko lokago, Pitá nene Guivahani neza geikumú geleaká noumó nene gelenane. Loko lokago, Izesú nene vegenáne zuha lamaná oko nasahilí oketozo. ");
INSERT INTO gah_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Loko loake, miní ameko loká otake Zonini gipala Pitao, geza nenikumú geleaká noape. Némika loko loká otamó nene gamena losive makole imó nenemú Pitá agika hizekago lo amike limó: Guivahanínemaka, mukí netakumú gelenanimole. Neza geikumú geleaká noumó nene gelenane. Loko lokago, Izesú láa loko lo amimó: Geza nene vegenáne zuha lamaná oko gizapa oketozo. ");
INSERT INTO gah_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Lamaná lo gimitoze, gelezo. Geza gosohá ve minanike holotaka nene gohakaló ze gilitokanike, gapo neloka manaloka vitove loko gagata gelekanike voaká animóma neve. Lá onoimóza, minoko ozaha molokoko gigizani lutooko noako, ve makolímo holotaka zegimioko vamitove litanitoka gelémoko vinogo ive. ");
INSERT INTO gah_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Loko Izesú nene Pitá minoko nenémini oko zohota zaló noheleko Ómasímini agulizá alémo kegesative loko anoza gakó limó. Loko loake, miní ameko némegetoko ano loko lo amimó. ");
INSERT INTO gah_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Loko lokago, Pitá viligoko Izesú ameni nemeaká i veve liki lina ve není ánigamó. Neza amunaló nosá nuni zupa Izesuni amatoka minuke nene Guivahanínemaka, éaho gimimika litikumú nolane loko lu ve minumó nenazo, ");
INSERT INTO gah_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pitá nene nenikumú Izesuni loká otake imane ve nana itimó neve. ");
INSERT INTO gah_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Loko loká omikago, Izesú láa loko lo amimó: Áisi hanuva agómulagi noiko nénisi atiginá itove loko lokugoma, geí netá nehe, olo. Geza nene hanuva némegetoko ano. ");
INSERT INTO gah_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Loko li gakolímo hutilí oko vokago, vegenala zuha keza nenikumú nene heleminogo ive liki gelemóza, Izesú nene gakó némika loko lamike, áisi hanuva agómulagi noiko nénisi atiginá itove loko lokugoma geí netá nehe lokogó limó. ");
INSERT INTO gah_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Itó Izesuni izegipala neza ámina netá ánigoko gelekuke, lo utó moloko aí mogonamú luhuva imane nogizuve. Leza mukilite nene imane luhuva gizonou gakó nene gihilave loko gelenoune. ");
INSERT INTO gah_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Itó Izesú oko moloko imó nene nana oko gizo asú itune. Ha nenazo, gizo asú uhá minalina, nagata gulumó mikasiuka ma asú amiline. ");
INSERT INTO gah_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teopilo, goí okoma luhuva netá gizo gumumó nene Izesú apí oko hoza alimoláa itó apínapí o kimike aleloko vimoláa ale lutigike okulumakú itimoláagi nene gizo gumumóma neve. ");
INSERT INTO gah_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Okulumakú velesá itemike aposolo lilí itave loko kelémo etó imoláa nene Ómasímini Sikalahulámo litó hoza gakó lo kimimó. ");
INSERT INTO gah_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Zaló itike miluma geleake heleneikutí oteake nene, hanuva agómulagi minake aleloko novive liki gili hee litave loko alévolé suni mukí loló ike gamena 40-a utó okemeká tolova oká noike, Ómasímo gizapa okimiaká gakó lo kemeko minamó. ");
INSERT INTO gah_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Lá oake alika nene kezagi minake, láa loko lo kimimó: Lekeza Zelusalega nene litá iki ahulamiki améneho Sikalahúne amisilitove loko lo mololikimikago lo lukumu vemú nene ageva iki minalo. ");
INSERT INTO gah_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Zoní nene hanuva nagamiláa holokimiaká imóma nemóza, améneho nene gamena hána minamoko Sikalahú hololeketanogo ive, loko lo kimimó. ");
INSERT INTO gah_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Gamena makó zupa keza alegesá iake, Izesuni láa liki loká itamó: Guivahanitemaka, kugulizaki ve goí iki lelitoka gizapa iaká amómámini oko geza itína gamena nene gugulizaki ve loló okoko Isilae vegená lelitoka gizapa itape. ");
INSERT INTO gah_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Liki likago, eza láa loko lo kimimó: Nugulizaki ve napa loló ito gamena nene améneho ezáa zámuzalaló molo gilike gamena hánahe alínipahe ezáa lo hukonoimó nenazo, lekelisi ma geleminigave. ");
INSERT INTO gah_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Lá onoimóza, imane gilitave. Ómasímini Sikalahú eza lekelitoka lemeko zámuza lekemekiko, gakóne nene Zelusalega apí iki liiki nene lili ali iki Zutaia apá makokuka itó Samalia mikasiuka viiki, nenetí mikasi nekisa vokisauka vi asú itave, loko lo kimimó. ");
INSERT INTO gah_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Láa loko lo kemekago, keza gonú napelego, vávani oko iteko novigo límusi nenémo molo hitokago, vo tolova imó. ");
INSERT INTO gah_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Okulumakú teho lokago, izegipala zuhate okenava iki gonú inago, ve lositá nene gineganéini mokonaki keitoka galinali utó ikasike, ");
INSERT INTO gah_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","láa liki li kemesimó: Galilaia mikasiló vese, lekeza nanamú okulumakuka gonú iki niave. Izesutipo nene ániginago ahulolikimiake okulumakú iteka ve nene okulumakú itimómáminoko alika liminogo ive, liki li kemesimó. ");
INSERT INTO gah_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Lá okago, keza Olivi agokalotí atiginá iki limiake gapo alínipa viki Zelusalega vi anitiake, ");
INSERT INTO gah_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","numuni amupiló makó gikakú miniaká a numukú nene itiki minamó. Keí kugulizáinía Pitá Zoní Zemusí Etulú Pilipó Tomasí Patolomaió Mataió itó Alapaioni gipala Zemusí makó itó Saimoná eza Loma vemú giligo goselé apeleaká i ve itó Zemusí makolímini gipala Zutá. ");
INSERT INTO gah_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Nene ve itó Izesuni izamuha hiziki miniaká a venámagi Maliá Izesuni izolahiki itó Izesuni agunamotamolagi kigika mili hamó iki Ómasiloka liki minamó. ");
INSERT INTO gah_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Gamena nene zupa Izesuni vegenala zuha nene vegená 120 nenéminiki minikamó nene alegesá iki niago, Pitá nene oteake gakó láa loko lo kimimó: ");
INSERT INTO gah_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Nigivénegita, Zutá eza ale goí igo Izesuni agizató ale vemámini mogonala nene lo likimitoze, gililo. ");
INSERT INTO gah_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ámina ve nene monó hoza leza nolimike ezagi amimó neve. ");
INSERT INTO gah_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Ámina ve nene mikasi makó gomulusi gehanitunú meina hizikago, áminaloka voko minake gotolalokatí velehé limike agatupa zeko pou lokago mí aseva akúvalomó zimó. ");
INSERT INTO gah_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Lá i gakó nene Zelusale vegená mukilite giliake ámina apá agulizá keí gakokutí Akeletama liki milinamóma neve. Itó lelí gakokutí nene gola mikasive neve. ");
INSERT INTO gah_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Itó Ómasímini Sikalahulímo agulizaki ve napa Tevitini alémo vávani okago, alika Zutá nene loló iti netakumú gakó limó nene alévolé imó. Ámina netá nene Zutatoka utó itikumú nene Ómasi agepoka liká nama liká a gakokutí láa loko luhuva gizonoimóma neve: Numuni apala nene gámé vizekiko, numutagalagú nene ve makolímo minamitive, loko gizamó. Itó makó lá oko neve: Aí hoza agepaló nene ve makolímo alitive. ");
INSERT INTO gah_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Luhuva láa loko gizonoimó nenazo, Guivahani Izesú nene holutegú minoko aleko noigo, ve lugáa nenete Zoní eza Izesuni nene nagamí holota gamenaló apí iki lehelukalú imi nivago Ómasímo Izesuni alémoko okulumakú itimó. Ámina vegutí nene Zutani hoza agepaló alitive loko ve makó alémo etó okuko, Izesú nene galegutí otimó nene ezagi lezagi makó ániguháma nenazo, ezagi makó avetó oko lo kimitune loko noluve. ");
INSERT INTO gah_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Loko Pitá lo kemekago, ve lositá, makó Zosehé, agulizá koma Pasapá, agulizá makó Zustó, itó ve makó agulizá Matatiá nene kilími utó miliake, ");
INSERT INTO gah_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Ómasiloka láa liki agepoka lamó: Kee, Guivahanitemaka, ligika ánigoaká ve noane. Zutá nene aposolo hoza ahuloake heleake, Ómasímo ale vavá ota apatoka vokave. Lá okago, aí hoza agepaló aliti ve imane ve lositakutí alémo etó itanimoláa lelepizezo. ");
INSERT INTO gah_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Liki agepoka liake, kugulizá nene luhuva giziki ali nupa iki milakutí makó ali otiki ánigamó nene Matatiani agulizá nego, aposolo hoza amemó. ");
INSERT INTO gah_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Zuta vetini avóikini asenini zeketakumú gili mina holisi asú okago, gamena 50 oko vokago, holisi makó alitokago, Izesuni vegenala zuha keza apá makokú alegesá iki niago, ");
INSERT INTO gah_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","okulumakutí anó makó ohuhú nenéminoko moloko galinali lemeake, mina numuni agikagú nene iteko mino vaí imó. ");
INSERT INTO gah_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Lá okago, ló gulumagitana netá makó utó oake mukilitini gotóitó hamopamó mino asú okago, ");
INSERT INTO gah_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ómasímini Sikalahú nene lemeko kigikagú mino vaí oake nenémini zámuza kemekago, haitopaitó konokutí apí iki gakó lamó. ");
INSERT INTO gah_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Lá niago, gamena nene zupa Zuta vegená monóinigi vegená nene vaí iki ake Zelusale numutoka minamó neve. ");
INSERT INTO gah_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Niake guu guu loko okulumakutí limi netalímini anola giliake alegesá ake, konóikutí konóikutí gakó li kimi kimi ago giliake, ");
INSERT INTO gah_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","kegepa gahava minamigo, sigaga likitake láa liki lamó: Gakó nila ve imane Galilaia mikasigutí vegó niamóza, ");
INSERT INTO gah_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","keza nana iake gakotegutí gakotegutí likago nogulune. ");
INSERT INTO gah_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Leza nene Patia ve nouhá, itó Mitia ve nouhá, itó Elame ve nouhá, itó Mesopotamia mikasiuka ve nouhá, itó Zutaia ve nouhá, itó Kapatosia ve nouhá, itó Potu ve nouhá, Asia ve nouhá, ");
INSERT INTO gah_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","itó Pilisia ve nouhá, Pamapilia ve nouhá, Izipi mikasiuka ve nouhá, itó Lipia mikasigutí Sailini ve nouhá, itó Loma apatotí venove nouhá Zuta vegi monokumú gutá amoláagi nene, ");
INSERT INTO gah_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","itó Kiliti ve itó Alapia ve leza nene ve minunike nene, Ómasímini suni alévoleláa nene lá iki lonokutí lonokutí likago gelekune. ");
INSERT INTO gah_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Liki liake, kigika gopa okago, gili gopa iake ligili hagili iki Agae, imane nana suni naleve. ");
INSERT INTO gah_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Liki likago, lugáate gopoguka likitake vain nagamí gosohá niake matúini gopa okago lutuka nilave, liki lamó. ");
INSERT INTO gah_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Liki likago, Pitá ave agivelage ileven-amagi oti minake gakó napagutí láa loko lo kimimó: Zelusale apá amelagita itó Zuta vegená lugáa neneta, neza gakó lo likimitoze, gili vevesiki gililo. ");
INSERT INTO gah_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Lekeza lelikumú nene vain nagamí niake kigika gopa okago nilave liki nilamóza, gó izoha nolanazo, lá oko nomive. Sipaki gamena nomive. ");
INSERT INTO gah_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Imane sunimú Ómasímini agepagutí gakó loaká ve Zoelé láa loko luhuva giza gakó nene mota gihila zekave: ");
INSERT INTO gah_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Minoko gamena napa asú iti zupa nene Sikalahúne numutó namató vegená mukitó lehizelikimikugo, izegipatini lakagapilamolite Ómasímini agepagutí gakó li nimiliko, gosohá velinite vamómáminiki nánigiko, ozahatini keza vamó ániganigave. ");
INSERT INTO gah_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Itó ámina zupa Sikalahúne nene lehizekimikugo, není gelekelé ve vená kezagi alikamú gakó li milanigave. ");
INSERT INTO gah_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Lá niko, okulumatokagi mikasilokagi golivagi netá haitopaitolímini nolekelepizugo ániganigave. ");
INSERT INTO gah_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Guivahanímini golivagi gamena napa velesá utó amigo, mikasiuka nene golanigi loki lokilagi utó inogo ive, itó okulumató nene hómini agómulaló hitanogo ive, itó ikani nene ámina oko golakó loló inogo ive. ");
INSERT INTO gah_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Lá okiko, Guivahanímini agulizá iki sele li amita vegená nene kugutó vizinogo uve, loko Ómasímo lokave liki luhuva gizamóma neve. ");
INSERT INTO gah_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Isilae mikasigú vese, lo likimitoze, gililo. Nasalete numutotí ve Izesú eza holutikú minake, Ómasilokatile liki litave loko Ómasímo hize lé otago, zámuzalaló molo gilike golivagi netá mukí ale utó molamó nene lekeza gilinave. ");
INSERT INTO gah_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ámina ve nene Ómasímo gozapá molo hukake gili netá aleko likigizakú molokago, lekelisi gala vevatini kigizakú milikago alími-liki viki zaló nilitunú apilikago hilimóma neve. ");
INSERT INTO gah_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Lá ikamóza, gonosi matimatigú minamitimó okago, miluma gilike heleneikutí Ómasímo alémo otimó. ");
INSERT INTO gah_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Agulizaki ve Tevití nene aikumú nene láa loko luhuva gizamóma neve: Neza Guivahani ánigo gisili hizekuke minoaká nouve. Voko gopa okatove loko nigizani zamagaloka noive. ");
INSERT INTO gah_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Nenemú nigikagú laga noike, mulúnegú agila guluma noigo noluve. Itó nugupemú nene gele hamokó oko gegeva oko minanogo uve. ");
INSERT INTO gah_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Není ahulonimikako nigika lamanaki nou vémina nugupéa anuva aminogo ive. Nemenía nene hele vegenalitiniuka ahulonetamitanikumú noluve. ");
INSERT INTO gah_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Geza alévolé nemetameki mohona ito gapo nelepizenitika, govogisaló mulúnegú agila guluma igo minanogo uve, loko limó. ");
INSERT INTO gah_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Uvónegita aménegita, neza avoteho Tevitikumú ale akutoko lo likimitoze. Eza helekago, gale zimikago, gonosi matimati galeva itína ha nego ánigiaká niave. ");
INSERT INTO gah_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Eza Ómasímini agepagutí gakó loaká ve minoake, nénisi helekugo Ómasímo nene není izegipa nugunamotamokutí makolímo není hoza agepaló agulizaki ve napa alémo loló itove loko alévolé oko lo huta gakó nene geleake, ");
INSERT INTO gah_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","gologí oletative loko lo mololeta vema galegutí otitikumú geleake, agika lamanaki veva agupéa anuva okative loko hele vegenalitiniuka amenía ahulotamimó neve loko limó. ");
INSERT INTO gah_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Itó Izesuni nene Ómasímo galegutí alémo otekago, leza logómula gihilatunú ánigonouháma neve. ");
INSERT INTO gah_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Itó Ómasímo agizani zamagaloka alémo moloake, amelaho lo mololetató nene Sikalahú molomikago, ámina Sikalahú itína nene lehizelimikago, ámina netá giliká ánigiká niave. ");
INSERT INTO gah_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Itó Tevití nene okulumakú itemimóza, eza gakó makó láa loko limó neve: Mezaú ve eza není Guivahaníne nene není nigizani lamagaloka minoloko voko noako, ");
INSERT INTO gah_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","gala vega nene gigisa heumauka ahulokimikugo minanigave, loko lo amimóma neve. ");
INSERT INTO gah_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Lá onoize, Isilae vegená mukí lekeza alévolé iki gililo. Ámina ve apilikago hili ve Izesú nene Guivahanite gologí oletative loko lo mololeta vema noive loko Ómasímo alémo apazá noive, loko limó. ");
INSERT INTO gah_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Láa loko lo kemekago, miluma giliake Pitá ave itó aposolo lugáave loká ikitake ligivese, leza nana okuko lamaná itive. ");
INSERT INTO gah_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Liki likago, Pitá láa loko lo kimimó: Ómasímo lihimatini apaso ahuloleketative liki likigika ali viligalo. Lá ikiko, leza Izesu Kilistoni agulizató monó nagamí hololikimikuko, Ómasímo Sikalahula lehizeleketanogo ive. ");
INSERT INTO gah_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Lekezagi izegipatinigi itó hetoka nia vegenaki sele lo kemekiko ata vegená mukí nene Sikalahú lehizeleketanogo lo mololeketonoimóma neve. ");
INSERT INTO gah_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Loko Pitá loake, mukí gakó miní ameko kagata aleko itína gamena ve neginagi keí holúikú ahulikimiiki ikiko Ómasímo lukugutó vizitive, loko lo kimimó. ");
INSERT INTO gah_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Láa loko lo kemekago, aí gakó gili alemoláa goha 3 tausen nene Ómasímo Izesuni vegenalaló miní ameketago, monó nagamí hilikitamó. ");
INSERT INTO gah_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Lá ikago, gamena gamena amuza miliki alegesá iake gili hamó iki aposolo apí i keme gakó giliake, hanuva nosaki lepa nosaki niki Ómasiloka liki miniaká amó. ");
INSERT INTO gah_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Lá niake, aposolomate haitopaitó alévolé suni aleke golivagi netá alikago, vegená mukí kehelele vizigo minamó. ");
INSERT INTO gah_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Izesunimú gili alévolé iki mina vegenalite nene netá matá ali minamó nene mukitó netáini ali minake, ");
INSERT INTO gah_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","henokanóini makó ali minamó nene maketiló miliake moni aliake netakumú vitagá a vegená nene gona miliki ali volaló imaló ake, ");
INSERT INTO gah_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","gamena gamena kigika mili hamó ake monó numuni napagú monó liká itó numúikú hanuva nosaki lepa nosaki niká iki kigika mili apiziki nosánetá gona miliki ali volaló imaló iki niake, ");
INSERT INTO gah_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ómasi agepoka liki miniaká niago, vegená mukilite ánigi kumu helemó. Lá noigo, Guivahanímo gamena gamena vegená makó kugutó vizike Izesuni vegenalaló miní ameketamó. ");
INSERT INTO gah_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Gamena makó zupa Pitako Zoniko nene ho ale zohota noigo Ómasiloka loaká gamena nene monó zagusave napagú itinigi nivasigo, ");
INSERT INTO gah_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","ve makó izolaho getakutí gepili minamó nenémo numuni gatetó minoko monó numukú tigá limigá a vegenáma monimú voká loko minoaká imó. Ámina ve nene gamena gamena monó zagusave gatenáa agulizá lamanapani loko netó nene alimi ahulimikago, ");
INSERT INTO gah_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","monimú voká loko minoaká imó. Ámina ve nene áminaló minake Pitako Zoniko monó zagusave napagú itinigi nivasigo, ánigoake, monimú voká limó. ");
INSERT INTO gah_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Voká lokago, Pitako Zoniko keza gonú napelesike, Pitá nene gonú lepelezo. ");
INSERT INTO gah_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Loko lo amekago, ve gepili nenémo netáma niminigi nilasihe loko gituhú noake gonú kipilimó. ");
INSERT INTO gah_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Lá noigo Pitá láa loko lo amimó: Moni lelitoka nomimóza, netá hamokó lelitoka nemó nene gimitoze, alezo. Nasalete numutotí ve Izesu Kilistoni gakotó oteoko gapo moloko vozo. ");
INSERT INTO gah_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Loko lo namike agizani lamagaloka aleko alémo otekago, litá oko agisaguki agisa gehanaguki alévolé okago, ");
INSERT INTO gah_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","moí oko oteake gapo moloko olío ite ite oko Ómasi agepoka lomo lomo vike Pitako Zoniko monó zagusave napagú nene makó itemó. ");
INSERT INTO gah_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Lá okago, gapo mohona noike Ómasi agepoka noligo, vegená mukilite ánigiake, ");
INSERT INTO gah_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","goí oko monó numuni gateni agulizá lamanapaniveló minake monimú voká voká loko minoaká i ve noive liki ánigi hee liake, agisa lamaná ikumú ininá iake sigaga lamó. ");
INSERT INTO gah_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ámina vémo Pitako Zonikoló gímizekago, vegená mukí keza monó zagusaveló gaizopa makó agulizá Salomonive liki atagamó nenegú ololu liki viki alegesá iake kegepa gahava nomigo minamó. ");
INSERT INTO gah_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Lá niago, Pitá nene ánigoake láa loko lo kimimó: Isilae mikasigú vese, ve imane ánigiake sigaga sagaga nilamóza, lelí zámuzatunú itó lelí lamanatetunú oko alémo otemusinazo, gonukonú lepelemilo. ");
INSERT INTO gah_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Avotege Avalahá Isaká Zakopó keí Ómasímini gelekelé gipala Izesuni zámuza utó igo nánigave. Agulizaki ve Pilató eza Izesuni aseva zetatove loko noligo lekelisi nene Pilatoni agómulaló Izesuni ánigi lá iake apilitave liake ami vetini kigizakú milamó. ");
INSERT INTO gah_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Lekelisi ámina vevesoko nomina ve agika lamanaki vema ánigi lá iake, ve makó kepele hili ve noimóma aseva zetative liake, ");
INSERT INTO gah_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","minoaká amelahinima apilikago hilimóza, Ómasímo heleneikutí alémo otekago, ánigonouháma neve. ");
INSERT INTO gah_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ámina ve Izesuni agulizá gele alévolé ominusitímo ánigina vema imane alémo lamaná usigo, eza Izesukumú giligo alévolé okago zokokave. ");
INSERT INTO gah_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Nigive nagavese, lekezagi gizapa velinigi gili hee lamake Izesuni apilinamóma neve loko gelenouve. ");
INSERT INTO gah_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ómasímini agepagutí gakó liaká a vetini kegepa ale vávani okimikago gologí oletative loko lo mololeta vema miluma geleko hilitive loko nenémini gakola lili ali vetini kegepauka lo molokago gizi mila gakóma itína mota alévolé okave. ");
INSERT INTO gah_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Lihimavatini gilatoleketative liki likigika ali viligiiki golesa netatini ahuliiki Ómasiloka gímizilo. Lá ikiko Guivahanilokatí likigikámini nosánetá ame íi liti gamena anogo ive. ");
INSERT INTO gah_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Lá okiko, Ómasímo eza gologí oleketative loko lo mololeketa ve Izesuni alémo etó oleketonoi vema amiselekiko goha mikasiuka liminogo ive. ");
INSERT INTO gah_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Izesú nene okulumalímo asapú okago noiko, Ómasímo lu netá la netá mukí goha ale lamaná iti gamena Ómasímini agepagutí gakó liaká a vetini kegepagú lo molokago gakó li mila gamena nene alitokiko liminogo ive. ");
INSERT INTO gah_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Itó Izesukumú nene Mosé gakó makó láa loko limó neve: Guivahani Ómasímo likigivetikini holúikutí nene agepagutí gakó loaká ve makó nenikitana oko alémo etó oleketatomó nenazo, némini manámini lo likimiti gakó mukí nene ámegetalo. ");
INSERT INTO gah_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Itó ámina monó lole ale vémini gakó gili alemita vegená nene, Ómasímo kehelú inogo ive, loko limó neve. ");
INSERT INTO gah_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Itó Samuelé minatotí Ómasímini agepagutí gakó liaká a ve miniliki itemoláa mukilite imane gamenamú nene alika utó itive liki minamó. ");
INSERT INTO gah_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Lekeza ámina vete alika utó itive liki li mila vema ali lá inamó nenazo, itó Ómasímo avotikitoka lo mola gakó nene Avalahani nene gagapilamó makolímo numutó namató vegená mukí lusa geketanogo ive loko lo ami vema ali lá inamó nenazo, likigika ali viligiiki golesa netatini ahulalo loko noluve. ");
INSERT INTO gah_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ómasi eza gelekelé gipala alémo etó i vema lusa gelikimioko gapo golesagutí lekelémo atiginá itive loko lekeza Zuta vegenatoka amisilimóma neve. ");
INSERT INTO gah_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pitako Zoniko keza vegená gakó láa liki li kimiki niasigo, guguni giziaká vegi monó zagusavegú gizapa vegi itó Satukaio monó vegenaki keitoka ake, ");
INSERT INTO gah_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","vegená nene Ómasímo Izesuni nene heleneikutí alémo otimómámini oko vegená makó kelémo otitive liki apí ikimiki lasi gakokumú gili golesa iake, ");
INSERT INTO gah_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","kigizató aliake, límugusi mota zekago, azozá goní oketatune liki kilími kalapusi numukú milamó. Lá ikago numuni hamó akasimóza, ");
INSERT INTO gah_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","gakóini gelemoláagutí gili alévolé a véa 5 tausen minamó. ");
INSERT INTO gah_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Akiake gó lago, Zuta vetini kugulizaki vegi monó ve lunáagi monó mogona apí ikimiaká a vegi ");
INSERT INTO gah_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","guguni gizoaká i ve napa Anasí itó Kaiapá itó Zoní itó Alesaté itó guguni giziaká a zuha makoki mukí nene Zelusalega alegesá iki minake, ");
INSERT INTO gah_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","aposoloma kilími holúikú miliake, loká ikitake hí vémini zámuzaló itó hí vémini agulizató ve imane alími zokasive. ");
INSERT INTO gah_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Liki likago, Ómasímini Sikalahulímo lemeko Pitani agikagú mino vaí onoigo, láa loko lo kimimó: Uvónegita aménegita, ");
INSERT INTO gah_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","lekeza ve gepilima nana ikasike alími zokasimó neve liki itína netá gihila alusikumú goní hoza nilememóza, ");
INSERT INTO gah_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","lekezagi mukí Isilae mikasigú vegená neneta, gakó lo likimitoze, gililo. Nasalete numutotí ve Izesu Kilistoni nene lekelisi zaló apili hilikago Ómasímo heleneikutí alémo oti vemámini zámuzaló ve imane lokogómulaló zokoake nene noive. ");
INSERT INTO gah_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Aí mogonamú nene monó gotolaú luhuva makó láa liki gizinamóma neve: Numuni giaká vete gehani napa makó ánigi ahulamó nenémo gehani lapusa alévoleláa loló oake noive, liki gizinave. Lekeza ámina numuni giaká ve niave, itó Izesukumú gehani lapusa golesave liki liake ánigi ahulamóma neve. ");
INSERT INTO gah_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Numutó namató vegenakutí lugutó viziti ve makó noamive, itó aí agulizató lamaná itunimoláa neve, ve makó imane mikasiuka minamive, loko limó. ");
INSERT INTO gah_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Lá okago, Pitako Zoniko keza kehelele vizemigo ali akutiki gakó likasigo, sukulu lamasi vematosave liki giliake nene, sigaga liake Izesuni amatoka minasi vematosa lasinae liki gelemó. ");
INSERT INTO gah_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Lá niago, alími zokasi ve nene keí kamatoka noigo, ve lositosini konotó aliki li kimita gakoláa nomigo, vitagá amó. ");
INSERT INTO gah_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Vitagá iake, gakó numukutí kimisili hetoka iake, kezáikó láa liki ligili hagili amó: ");
INSERT INTO gah_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Imane ve lositáma nana oketatune. Kéisi nene netá golivagi alikasive liki Zelusale numutoka vegená mukilite gili asú ikanazo, leza nana okiko egamega oko lá oko nomive loko litune. ");
INSERT INTO gah_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Lá onimóza, ámina gakó hutilí okiko vegená gili asú ikatave liake, Izesuni agulizató gakó goha li kememitáive liki kagata alitune liki liake, ");
INSERT INTO gah_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","goha sele li kimiake, Izesuni agulizató gakó li kimi kimi iki vegená goha apí i kememitáive liki kagata alemó. Lá ikago, ");
INSERT INTO gah_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pitako Zoniko keza láa liki li kemesimó: Lekeza giliki ánigalo. Vegená lekelí gakó gele alekoko Ómasímini gakó gele ahulatunimó nene Ómasímo gele lamaná itihe. ");
INSERT INTO gah_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Leza ánigoko geleko uni netá nene hitooko minaminogo une. ");
INSERT INTO gah_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Liki likasigo, keza goha kehelele viziti gakó li kimiake, kipilita gapomú vitagá amó nene nomigo, hanuva kimisili ahulikago vasimó. ");
INSERT INTO gah_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Lá amó nene ámina netá golivagi aliki alími zokasi vema nene kilisimasiva 40-a alahuloko minamó nenazo, vegená mukilite ámina netakumú Ómasi agepoka liki minikago, ve losima kipilitunimó nene vegenalite nana ilitatahe liki giliake gapomú vitagá iake ahulikimikago vasimó. ");
INSERT INTO gah_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Kimisili ahulikago, limikasike kigivéike niatoka vasike, guguni giziaká ve napate itó monó ve lunáate li keme gakó nene avetó iki li kimikasigo, ");
INSERT INTO gah_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","giliake, kegepa hamó ake Ómasiloka láa liki lamó: Mezaú ve Guivahani geza okulumakuka ito mikasiuka itó age nagamikú lamó lamimó molanitika, ");
INSERT INTO gah_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Sikalahuka nenémo gakola nene avoteho geí gelekelé ve Tevitini agepagú lo molokago, gakó láa loko limóma neve: Hetoka vegená nene kizapaló molokago gopaga lamó neve. Itó Zuta vegenalite netá golesa loló otatune liki gilikamóza, hanuva geleakaláagó gelemó neve. ");
INSERT INTO gah_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Mikasiuka kugulizaki ve napa nenete ali vavá iake, itó gizapa vete ali nupa iake, némini manámini iki Guivahanigi gologi oletative loko lo mololeta vevagi lova ale kimitune liki gona gizamole, loko limó. ");
INSERT INTO gah_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Lapanalagi gelekelé gipaka Izesúma lugutó vizeaká hozamú alémo etó ani vema lova ali aminigi Heloté ave Potiasi Pilató ave itó hetoka vegenaki Isilaeló gizapa vegi keza lamaná imane apatoka alegesá iake, ");
INSERT INTO gah_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","géisi gosohá utó itive loko lo molani netá mukí alemóma neve. ");
INSERT INTO gah_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Lá ikamóza, Guivahanitemaka geza lehelele viziti gakó gelekoko gakó ale akutoko litune loko genezate ale vávani olimioko, ");
INSERT INTO gah_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","zámuza lemekako vegená kelémo zokinake lapanalagi gelekelé gipaka Izesuni agulizató golivagi hoza alitune loko nolune. ");
INSERT INTO gah_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Liki Ómasiloka likago, alegesá iki mina numunima guliguli oko mómoká okago, Ómasímini Sikalahú nene lemeko kigikagú mino vaí oake kelémo vávani igo, limiake Ómasímini gakó ali akutiki li kimi kimi iaká amó. ");
INSERT INTO gah_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Lá niake, Izesunimú gili alévolé iki mina vegená keza kigika mili hamó iake, geí netá není netá lamake netá matá ali minamó nene mukitó netale liki ali minamó. ");
INSERT INTO gah_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Lá niake, aposolote Guivahani Izesú galegutí otekago ánigune liki gakó nene alévolé iki avetó iki li kimi kimi iki minikago, Ómasímo hize lé okimikago niave liki mukí vegenalite gili minamó. ");
INSERT INTO gah_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Nenémini gihila nene numunihe mikasihe zazuhahe netá amelage meinaváa aliake, ");
INSERT INTO gah_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","aliki viki aposolo kimikago, ve lugáate netakumú vitagá niago nene gona miliki kimikago, ve makolímo netakumú vitagá osá amimó. ");
INSERT INTO gah_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Nenémi suni nene ve makó agulizá Zosehé eza aposolote agulizá makó Panapasí ave liki mila ve, nene agulizalímini mogonáa lelí gakokutí nene kelémo kii lokimiaká ve eza Livaini agávolaho Saipalasi mikasi pokolagú getamó nenémo ");
INSERT INTO gah_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","zazuha apala makó ale minamó nene meinava moni aleake aleko voko aposolo kimimó. ");
INSERT INTO gah_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Lá okamóza, ve makó agulizá Ananiasí itó venala Sapailá keza ligili hagili ikasike, zazuha apá makó salimikasike, moni alikasike, ");
INSERT INTO gah_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","lugáa nene ali halá gikasike, Ananiasí nene lugalokatí aleko voko aposoloma nene áminasí alusimó neve loko lo kimimó. ");
INSERT INTO gah_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Lá okago, Pitá láa loko lo amimó: Ananiasio, geza nanamú Satá gigika ale gopa okago Ómasímini Sikalahú soza gakó lo amekanike mikasímini meinava lugalokatí ale halá gekane. ");
INSERT INTO gah_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Mikasiga nene gezakaloka minatinazo, gezaka gagata geleko kemenimóma neve. Itó salimokanike meinava alenimó nene geza monikama nenazo, lélisi voká logetamune. Nenelotí meinava aleokoma nenetunú netá mataka meina kona itove loko itaninazo, geza nana okago gezaka gigikámo gogoka vizekago nenémini ane. Vegená soza lo lumuhe loko Ómasi soza lo amekane. ");
INSERT INTO gah_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Loko noli agepagi, Ananiasí nene nogilike pou loko akoake hilimó. Helekago, ánigiake, kelegesá ligimó. ");
INSERT INTO gah_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Itó lá oko helekago gosohá ve minamoláate otiki gonosiváa nene gotunú asapú iake aliki viki gale zitamó. ");
INSERT INTO gah_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Gale zimikago, koma nominake, venalámo ámina gakó gelemike hanuva noihe loko anitimó. ");
INSERT INTO gah_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Anitekago, Pitá nene loká otake Olo, mikasilotí meinava áminasí alesimó nehe. Loko lokago, eza oo, áminasíma nenae. ");
INSERT INTO gah_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Loko lokago, Pitá láa loko lo amimó: Lekeza nanamú Guivahanímini Sikalahulímo ánigamitive liki agoka vizinigi ligili hagili ikasike asihe. Gelezo. Vakama nene gale ze vema gatetoka liti liti liki niki laze, gezagi nene áminámini iki aliki viki gale zigitanigave. ");
INSERT INTO gah_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Loko noli agepagi nene eza galinali agisagú pou loko akoake hilimó. Helekago, ámina gosohá ve nenete iteke gonosiváa ánigiake, aliki vili vana gale zitató nene gale zitamó. ");
INSERT INTO gah_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Gale zikago, monó gele vegená itó gakóini gele vegená mukí keza kelegesá ligigo minamó. ");
INSERT INTO gah_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Aposolo keza alévolé suni haitopaitolímini mukí nene vegenalitini holúikú ali utó iminikago Izesuni vegenala zuha mukí nene monó zagusave napámini gaizopa numuni makó agulizá Salomonive liki atagamó nenegú kigika mili hamokó iki alegesá iaká amó. ");
INSERT INTO gah_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Niago, vegená lugáate kugulizáini ali otemóza, ve vená mukilite kelegesá legekago monó gele vegenatoka viki gímizemamóza, ");
INSERT INTO gah_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","ve vená mukilite vauva aliki Guivahanimú gili alévolé iake keitoka miní amiki miniaká amó. ");
INSERT INTO gah_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Lá iake, kivisi vegená nene gapoló kilími miliki Pitá tizokoko kugupeló ale gelekikohe itó hanuva vogunámo avutá kepelekiko zokatave liake, ukoako nene lilí iake ámina vegená nene miliki kilími-liki iki agisauka nene ahulikimiaká amó. ");
INSERT INTO gah_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Lá niago Zelusalega alitoka miniliki va vegenalite kivisi vegenaki kigikagú holosi golesa mina vegenaki kilímiki ikago, kilími zoki asú amó. ");
INSERT INTO gah_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Lá niago, guguni gizoaká i ve napagi izegipala zuhagi itó Satukaio monó vegená kezagi ámina suni ánigiake, kemekugú niake kizapaló molokago, ");
INSERT INTO gah_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","aposoloma kigizató aliake kalapusi numukú kilími milamó. ");
INSERT INTO gah_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Lá ikago, akinago, holugú akovevé nene Guivahanímini ageló makolímo kalapusi numukutí gahe segekimiake, kelémoko limike láa loko lo kimimó: ");
INSERT INTO gah_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Lekeza viki monó zagusavegú itiki alévolé kemetamenigi minata gakó li kimi kimi iki minalo. ");
INSERT INTO gah_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Loko lo kemekago, giliake, neteká ho noitigo monó zagusavegú itiki monó li kimi kimi iki minamó. Lá niago, guguni gizoaká i ve napa nenémo izegipa agunamotamolagi Isilae vegenalitini monó gizapa vegi monó kansolegi kilími nupa iake gakó ligili hagili iake, aposoloma kilímikatave liki pilisi ve makó nene kalapusi numukuka kimiselemó. ");
INSERT INTO gah_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Kimisilikago, viki kalapusi numukú ánigamó nene, niamago, vitagá iake, atiginá iki ake lamó: ");
INSERT INTO gah_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Leza voko ániguhá nene kalapusi numuni gahe lopena alinago gizapa vema gatetó ha minamóza, leza gahe segekunike, iteko ánigunimóza, ámina vegená niamago vitagá okune. ");
INSERT INTO gah_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Gakó láa liki likago, monó zagusave gizapa vegi guguni giziaká ve napagi keza gelemó gena okago, alika netá makó utó itimó nehe liake, kagata losi gelemó. ");
INSERT INTO gah_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Nigelego, ve makolímo anitike kalapusi numukú kilími mila vemate viki monó zagusavemagú monó li kimi kimi iki nianae. ");
INSERT INTO gah_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Loko lo kemekago, monó zagusave napa gizapa ve nenémo pilisi ve kelémoko vike aposoloma kipilitunimóza ha vegenalite gehanitunú lipili hilikatave liki kehelele vizekago, hana ikisí kilímiki amó. ");
INSERT INTO gah_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Kilímiki iake monó kansoletini holúikú kilími milikago niago, guguni giziaká vetini ve napámo láa loko lo kimimó: ");
INSERT INTO gah_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Leza nene ámina vémini agulizá iki li kimi kimi amilo loko lo lekememuhá nehe, olo. Lekeza pelevesava ziake, nene gakó nene Zelusale numutoka li hutilí ikave. Lá iake, aí apili helemómámini lihima nene lelí lumupiló molatune liki nilahe. ");
INSERT INTO gah_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Loko lokago, Pitá ave aposolo lugáa kezagi anotó aliki láa liki li amemó: Vegenalitini gakó gele aleoko Ómasímini gakó gele ahuloakala nomive. ");
INSERT INTO gah_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Lekeza Izesuni nene zohota zaló apili hilikago, avotegini Ómasímo alémo otekago otimó neve. ");
INSERT INTO gah_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ómasímo Isilae vegená lekelisi likigika ali viligikiko lihimatini apasoleketative loko ámina ve nene agulizaki vele itó lugutó vizeaká vema alémo etó oake, galegutí alémo otekago, Ómasímini amatoka noive. ");
INSERT INTO gah_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Lá okago, Ómasímini gakó gili aliaká niamoláa kemeaká noi Sikalahulímo itó lezagi ánigoko gelekunike ámina gakó lo lekemeaká noune, loko lo kimimó. ");
INSERT INTO gah_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Loko lo kemekago, giliake, kizapaló golesa molokago, aposolo kipili hilinigi li hukamóza, ");
INSERT INTO gah_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Zuta vetini kansolegutí Palisaio monó ve makó minamó, agulizá Gamalielé. Áisi nene Mosé lo hukoko li gakó lainim-okimikago vegenalite ánigi lamaná a ve minamó. Áisi nene oteake aposoloma kilími hetó itave loko lokago, aposolo keza olíi hetó limiki niago, ");
INSERT INTO gah_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","agivelagini láa loko lo kimimó: Isilae vese, lekeza imane vemú gili hee liiki netá matá ikitalo. ");
INSERT INTO gah_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Gozapá ve makó minamó, agulizá Teutá ave loko mina vemámo nugulizaki ve napa nouve loko lokago, ve 400 aitoka gímizemóza, alika nene Teutoni apili ahulikago, vegená aitoka gímizemoláa kimisili ahulikago, hutilí iki viake apí a hoza nene ahulamó. ");
INSERT INTO gah_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Itó alika nene Galilaia mikasigutí ve makó agulizá Zutá eza lugulizá aliaká a gamenaló nene oteake, vegená gala vizeko ale goí ike lova mogoka ligo, lova apí amóza, ámina ve nene apili ahulikago, izegipa agunamotamola hutilí iki vamó neve. ");
INSERT INTO gah_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Nenemú gakó imane lo likimitoze, gililo. Lekeza imane ve ahulikimikiko hanuva minatave. Keza gakó akó liki hoza nalemó nene kezáini kagata giliki nalitamó nene, gopa oko haha inogo ive. ");
INSERT INTO gah_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Itó Ómasímo hize lé oketago nalitamó nene, lekeza Ómasímini hozava ali golesa itiki lova ali amikatave loko loú noko likipilinogo ive. Nenemú lakagata aleko noluve. ");
INSERT INTO gah_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Loko lo kemekago, keza gili aliake aposoloma kilímiki itiake segi nogosanitunú kipiliake, Izesuni agulizá nene goha avetó iki vegená li kememitave liki li hukikimiake kimiselemó. ");
INSERT INTO gah_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Kimisilikago, nivake, Guivahanimule loko lovoza hili netá aliki lepelemóza, Ómasímo nenemú gilimó etokave liki liake, kogoliza viziki kansoletini kovogisalokatí limiake vamó. ");
INSERT INTO gah_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Vake, gamena gamena monó zagusave napagú itó numúikú nene gologí oletative loko lo mololeta ve Izesuni gakó lamaná ahulamake miní amiki li kimi kimi iki minamó. ");
INSERT INTO gah_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Gamena nene zupa Izesuni vegenala zuha hizi hutilí niago, keikutí Zuta vegená makó Kiliki gakokutí liaká a ve nenete getó venalitini nosánetá nene gamena gamena gona miliki kememóma vo alemikumule liki Zuta gakokó liaká a ve nene gahá kememó. ");
INSERT INTO gah_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Lá ikago, aposolo 12 keza Izesuni vegenala zuha sele li kimiake láa liki li kememó: Leza Ómasímini gakó lo utó aminake lugupémini hozagó alesá etaminogo ive. ");
INSERT INTO gah_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Nenemú ligivetegita, lekeza lekelí holutikutí ve 7-a gotóini lamanaki itó Ómasímini Sikalahuki kigikagú mino vaí oko neiko vegenalite ánigi lamaná iaká nia ve kilími etó ikiko, leza ámina hoza kemekuko alitaze. ");
INSERT INTO gah_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Lá ikiko leza nene Ómasi agepoka loaká itó monola loaká hoza goselekaselé aminake aleko minatune. ");
INSERT INTO gah_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Liki likago, Izesuni vegenala zuha mukilite gili lamaná iake ve makó kilími etó amó, kugulizá Setepanó eza agikatunú gele alévolé oko minokago Ómasímini Sikalahú lemeko agikagú mino vaí oko mina ve, itó Pilipó, itó Polokoló, itó Nikanoló, itó Timoná, itó Palamená, itó Nikolaó eza Atiokia numutotí Zuta vegenatoka monokumule liki gutá a ve. ");
INSERT INTO gah_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Nene vete aposolotini kamatoka hizi letiake niago, aposolote kigizani nene gotóitó milake Ómasiloka lake kilími etó amó. ");
INSERT INTO gah_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Lá ikago, Ómasímini gakó hutilí oko vogá ogá oko minago, Izesuni vegenala zuha nene Zelusalega miní amiká amiká ago, guguni giziká a vegutí lugáate Izesuni monokumú gili alévolé amó. ");
INSERT INTO gah_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Lá okago, Ómasi eza Setepanoni hize lé omiake zámuza mukí amekago, alévolé suni haitopaitolímini nene vegenatoka mohona oko aleko minamó. ");
INSERT INTO gah_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Lá okago, monó numuni makokutí miluma hozagutí asenini zikitamoláate Sailini apatotí itó Alesatalia apakutí itó Silisia ve itó Asia ve nenete ali nupa iake, Setepanoni pelevesava zitamóza, ");
INSERT INTO gah_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Sikalahulímo alémo vávani okago, monó limó nenémo keí gakó satamó. Satokago nene loú noko kipilimó. ");
INSERT INTO gah_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Lá okago, vegenatoka asuguná gomulusi gihikago, Setepanoni amimika lake gakó láa liki lamó: Ámina ve nenémo Moseki Ómasigi alevo galatovo okago gelekune. ");
INSERT INTO gah_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Liki liake, numuká vegenaki olopa napagi monó mogona apí-ikimiaká a vegi gala vizikago, galinali Setepanoni gohoni milake agizató aliake kansoletini numukú alímiki vamó. ");
INSERT INTO gah_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Alímiki viake soza sazaló ve kilími numukú milikago, láa liki lamó: Ve imanémo lelí monó apakumú itó Mosé lo huka gakokumú alevo galatovo oko loaká noive. ");
INSERT INTO gah_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Makó nene láa loko noligo gelenouháma neve: Nasalete numutotí ve Izesúma imane apá ale golesa okoko oko moloko oaká nouhá sunimú Mosé gizo molamó nene ale gopa napa inogo ive, liki lamó. ");
INSERT INTO gah_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Láa liki liake ámina numukú mina ve mukitó keza Setepanoni agoka agepauka ánigamó nene, ageló makolímini agovisagitana oko lapanalagi noigo ánigamó. ");
INSERT INTO gah_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Lá okago, guguni giziaká a vetini ve napa nenémo loká otake gakó nilamó imane mota lamaná nilahe. ");
INSERT INTO gah_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Loko lokago, Setepanó láa loko limó: Avónegita aménegita, gakó litoze, gililo. Avoteho Avalahá eza Halana mikasiuka velesá vonamike Mesopotamia mikasiuka noigo, Ómasi eza lapanalagi vemámo utó o amike ");
INSERT INTO gah_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","láa loko lo amimó: Numuka apaka itó vegenaka zuha ahulokimioko nénisi mikasi makó gelepizitoze, neneló voko minatane. ");
INSERT INTO gah_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Loko lokago, nene gakó geleake, Kalatia mikasi ahuloake, Halana mikasiuka voko minamó. Neneloka noigo, amelaho helekago, gale zemiake Ómasímo litó nene ámina mikasigutí goha gá logoko léisi nouhatoka amóma neve. ");
INSERT INTO gah_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Gá logoko okago, mikasi ma alemimóma neve. Ómasímo mikasi koma makó keké amemimóma neve. Izegipa geto molamike noigo, minoloko notike ezáagi agapilamoki miniliki itiki ámina mikasi alitave loko lo molamó. ");
INSERT INTO gah_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ómasímo láa loko lomiake, gakó makó láa loko limóma neve: Gagapilamoka keza mikasi makotoka gutá miniki gelekelé ikitiki miluma hoza aliki goselekaselé iki niko, kilisimasi 400 oko vinogo ive. ");
INSERT INTO gah_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Loko loake, Ómasímo gakó makó miní amike láa loko limó: Lá oko noviko, miluma hoza kiminita vegená nene goní hoza kiminogo uve. Lá okugo, gagapilamoka kimisili milikiko, imane mikasiloka iki nugulizá ali otiki gupá zinimiki minanigave, loko lo amimó. ");
INSERT INTO gah_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Láa loko lo ameake, Avalahani izegipa agapilamolatini kugupeloka Ómasímini anosa minative loko lo hukotamó. Loko lomikago, Avalahá eza gipala Isakani getoake, gamena 8-a oko vokago, ámina anosa nene agupeló molotamó. Molomikago, Isaká minoloko noitike Zakoponi getamó. Lá okago alika Zakopó nene izegipala 12-a getamó nene lelí avotege zuha minamó. ");
INSERT INTO gah_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Lá okago, avotege keza kugunáini Zosehekumú amekugú niake, aí nene Isimaeli vegenatoka salimi iki agupelotí meina alemó. Alikago, Izipi mikasiuka alímiki vikago, neneloka voko noigo, Ómasímo Zosehé noitoka minake, ");
INSERT INTO gah_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","miluma geleko mina netá ale ahulomiake nasahilí omikago, netá mukikumú gele vevesoko minokago, Izipi mikasigú agulizaki ve Palaó ánigo lamaná oake, Izipi mikasiló itó aí numuni apá izegipa agunamotamola mukitoka gizapa ve napa minative loko alémo molamó. ");
INSERT INTO gah_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Lá okago, noigo, Izipi mikasigú itó Kenan mikasigú mukí nene gaúna napa giliki minikago, avotege ámina iki nosánetakumú vitagá amó. ");
INSERT INTO gah_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Minake Zakopó nene Izipi mikasiuka nosánetá neve liki lamó nene geleake, izegipala kimiselekago vamó. ");
INSERT INTO gah_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Viake atiginá ikago, goha kimiselekago, goha vikago nene, Zosehé nezama noumó lae loko uvolagini nene agoka kelepizekago Palaoki ámina gakó gilimó. ");
INSERT INTO gah_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Lá okago, Zosehé eza amelaho Zakoponi itó izegipa agunamotamolagi alo loko Izipi mikasiuka alesa molokago, ve vená 75 nene vamó. ");
INSERT INTO gah_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Zakopó voko Izipi mikasiuka minake hilimó. Helekago, izegipa agapilamola avotege keza ámina iki miniake hili asú ikago, ");
INSERT INTO gah_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","gonosiváini nene Sekeme apatoka aliki ake Hamoleni agapilamó zuhagutí gonosi apá Avalahá goí oko meina hizikú nene gale zikitamó. ");
INSERT INTO gah_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Lá ikago, Ómasímo Avalahani gakó lo molotamó nene alévolé iti gamena alitokago, Zuta vegená keza Izipi mikasiuka hizi hutilí amó. ");
INSERT INTO gah_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Lá iki niago, Izipi mikasiuka agulizaki ve gosohá utó imó. Áisi nene Zoseheni mogona gelemimó. ");
INSERT INTO gah_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Áisi nene avoteginimú lotoka hizike kelémo golesa galasa ike avotegini gipa getatamó nene hilitave loko leti ahuli ahuli ilo lokago, avotege ámina gipa koma leti ahuli ahuli iaká amó. ");
INSERT INTO gah_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Nene zupa nene Moseni nene izolaho getamó. Agoka agepa lamanaki utó okago, Ómasímo ánigo lamaná okago, amelahini numukú ali halakipalaki iki alinago, ikani losive makole golamó. ");
INSERT INTO gah_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Alika nene apilikatave liki halá gitinago Palaoni moholámo ánigoake, gipáneve loake alémo lá imó. ");
INSERT INTO gah_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Lá okago, Palaoni vegenala zuhate Izipi gakó li ami ami ago, gele asú oake, oko moloko ike monó anoka like alévolé oko minamó. ");
INSERT INTO gah_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Lá oko minake, kilisimasi 40 ale ahuloake, Isilae vegená nigivénegini voko ánigatove loko geleake, mulunagú lamaná geleko vimó. ");
INSERT INTO gah_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Voko ánigamó nene, Izipi ve makolímo nene Isilae ve makó napiligo ánigoake, agivelahini alémo vatí oko miluma gele minamó apasoko Izipi vema apele hilimó. ");
INSERT INTO gah_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Neza nigivénegini nene Palaoni agizakutí ipá itane loko Ómasímo nelémo etó onoimóma neve liki gili guni itahe loko Izipi vema apilimóza, keza gili hee lamamó. ");
INSERT INTO gah_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Akiake gó lago, goha nene vimó. Voko ánigamó nene, Isilae ve losi nenetosa lova nihizesigo, ánigoake alata moloketake ve loe lekeza gounama niasinazo, nanamú lova niasive. ");
INSERT INTO gah_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Loko lo kemekago, lova apí oko agivelahini apili vemámo láa loko lo amimó: Éaho gelémo gugulizaki ve loló ogimikago gonitó lelémo molanogo nolane. ");
INSERT INTO gah_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Lá okanike azozá Izipi ve makó apelenanimóma nenazo, itína ámina oko není nipilinogo nolape, olo. ");
INSERT INTO gah_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Loko lokago, Mosé nene geleake ahelele vizekago golisi oko Mitiana mikasiuka voko kugupeló ve minamó. Voko minake vená aleake, gipala losima getamó. ");
INSERT INTO gah_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Minake, kilisimasi 40 goha ale ahuloake, vike mikasi gomopalaló Sinai agoka agisauka nene zamukutí ló guluma ikú ánigamó nene Guivahanímo ageló loló oake lemeko utó o amekago, ");
INSERT INTO gah_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Mosé ánigoake, ininá oake nana netá utó noive loake, ánigo hee hee linogo vo alitó noigo, Guivahanímini anó lupa láa loko utó imó: ");
INSERT INTO gah_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Neza avokage Avalahá Isaká Zakopó keí Ómasi minumó minoloko voko nominuve. Loko lokago, Mosé geleake, ininá oake luvoluvo zeko minake ahelele vizekago okenava oko ánigamimó. ");
INSERT INTO gah_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Lá oko noigo, Guivahanímo láa loko lo amimó: Mikasi nolisanimó nene lo hutokugo etó oko nei mikasi neve. Nenemú geí suú gololohá ozo. ");
INSERT INTO gah_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Vegenáne zuha Izipi mikasiuka niamó nene gopoguni milikitago, ive nama iki niago gelemo iteva iteva noumó mota asú okave. Itínasa nene gologí oketatove loko lemekuve. Nenemú geí nene Izipi mikasiuka nogimisuluze, vozo, loko lo amimó. ");
INSERT INTO gah_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Itó ámina ve nene éaho gelémo gugulizaki ve loló ogimikago lelémo gonitó molanogo noane liki ánigi ahula ve Moseni nene zamukutí Ómasímini agelóma utó o amekago, Ómasímo nene gizapa ve itó kugutó vizeaká ve minative loko amisilimó. ");
INSERT INTO gah_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Amiselekago, vike vegená kelémo vike Izipi mikasiuka itó age nagamí makó agulizá golohá nagamitoka, itó mikasi gomopalaló nene alévolé suni haitopaitolímini ale utó moloko noigo, kilisimasi 40 oko vimó. ");
INSERT INTO gah_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ámina ve Mosé eza Isilae vegená nene Ómasímo likigivetikini holúikutí nene ezáa agepagutí gakó loaká ve makó nenikitana ve alémo etó oleketanogo ive, loko lo kimimó. ");
INSERT INTO gah_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Itó avotege keza Ómasímini monokumule liki mikasi gomopalaló alegesá iki niago, Sinai agokaloka Ómasímini ageló itó agivelagini holúikú minake loloko vogá ogá ve minake, alévolé lemetamenímini gakó lehizeletatove loko Ómasilokatí alimó. ");
INSERT INTO gah_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Alekago, avotege keza Moseni gakola gili ahuliake, aí nene vasá ziake Izipi mikasiuka atiginá iki vinigi kigika neneloka minokago, ");
INSERT INTO gah_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Moseni uvolaho Alonani nene láa liki li amemó: Geza avevezaha netá makó loló olimikako ámina netalímo ale goí iko leza atiginá oko Izipi mikasiuka vitune. Mosé nene Izipi mikasigutí lelémoko a ve eza voko gopa ihe itó hela hizihe leza gelemunize. Liki liake, ");
INSERT INTO gah_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","nene zupahé pulumaká akalevámini vogunahana avevezaha netá lilí iake, guguni gizi amiki kigizanitunú lilí a netakumú kogoliza viziki minamó. ");
INSERT INTO gah_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Lá ikago Ómasímo viselekimikago, kigika gopa okago, okulumatoka hanatoaká netá mukí goliva giliki agepoka liki minamó. Nene sunimú Ómasímo li gakó nene ezáa agepagutí gakó loaká ve makolímo láa loko luhuva gizonoimóma neve: Isilae vegená lekeza mikasi gomopalaló minake kilisimasi 40 oko novigo gaha nama kipiliki guguni giziaká amóza, není makó gizi nimisá amamóma neve. ");
INSERT INTO gah_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Lekeza soza ómasilini agulizá Molokoni seli numuni komagú lilí i miliake itó makó nene Lepanani sonohikitana makó lilí i miliake, ámina netalímini vogunahana goliva geleko agepoka litune liki soza ómai netá lilí inamó nenazo, nénisi lokugo, Papelonia apá hotoka likilímiki vinigave, loko luhuva gizonoimóma neve. ");
INSERT INTO gah_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Mikasi gomopalaló nene Ómasímo Moseni nene monó numuni lá oko gitane loko litokó gekago avotegitoka minamó nene seli numunigó minamó. ");
INSERT INTO gah_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Lá okago, ámina seli numuni nene omolelé amalelé iki aliki tiva tiva niago, Ómasímo ale goí ike numuká ve kimisilikago, nivago, avotege nene iki ámina mikasi aliake ámina seli numuni nene Zosuagegi aliki amó. Lá iki ámina numuni aliliki viva viva iki niago, agulizaki ve Tevití utó imó. ");
INSERT INTO gah_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Ómasímo Tevitini ánigamó lamaná okago, Tevití nene monó numuni nene avolaho Zakoponi Ómasi getatove loko loká imóza, ");
INSERT INTO gah_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ómasímo géneka loake gipaka Salomó genetative loko gele amekago eza Ómasímini numuni getamó. ");
INSERT INTO gah_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Lá imóza, okulumakú ve napa nene vegenalite ge numukú nene minoko aleko osá amive. Nenémini gakola Ómasímini agepagutí gakó loaká ve makolímo láa loko luhuva gizamóma neve: ");
INSERT INTO gah_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Guivahanímo láa loko nolive: Okulumá nene není numuni apá neve. Itó mikasiuka nene nigisa liso minuke gizapa oaká nouve. Lá oaká nounazo, numuni nanáminiki ginimikiko etative. Itó hí holomaló navasú vizeko minatove. ");
INSERT INTO gah_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Neza nigizanitunú okulumaki mikasigi netá mukí kelémo utó okumóma neve, loko luhuva gizamóma neve. ");
INSERT INTO gah_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Gínikaha golesa lekeza likigika lakagata koló amimó neneta, nénisi negopa, lekelisi nene avotike iki miliki amómáminiki niminake, Ómasímini Sikalahú nene lova ali amiaká niave. ");
INSERT INTO gah_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Avotike Ómasímini agepagutí gakó liaká a ve gopoguni milikitamiki asenini zikitamó nehe. Ma nomive. Mosé itó ve heeváa utó itive liki gakó li miliki la ve lugáagi nene kipili asú ikago, minoko lekelisi ámina ve heeváa nene utó okago amimí iki alímiki viake apilikago hilimóma neve. ");
INSERT INTO gah_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ómasímini ageló nenete Ómasímo lo huka gakóma Moseni amemó nene lekelitoka anitekamóza, lekelisi ámina gakó aliake gizapa iki gili alisá amave. ");
INSERT INTO gah_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Setepanó láa loko lo kemekago, giliake, mulúikú golesa okago, kizapaló golesa molamóza, ");
INSERT INTO gah_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Setepanó nene Ómasímini Sikalahulímo lemeko agikagú mino vaí okago, ánigo okulumakuka moloake, Ómasímini lapaná nego itó Izesú eza Ómasímini amatoka noigo ánigoake láa loko limó: ");
INSERT INTO gah_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Neza okulumá koló okago ánigumó nene Ómasilokatí limi ve gihila Ómasímini amatoka noigo ánigokuve. ");
INSERT INTO gah_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Loko lokago, keza kagataló hitinake valala ziki hitimiake viki anukemó. ");
INSERT INTO gah_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Anukiake ahelukalú iliki vake alími númaseloka miliake gehanitunú apilinigi goláa vizakiake, gosohá ve makó agulizá Sauloni agisauka milamó. ");
INSERT INTO gah_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Lá iake Setepanoni nene gehanitunú napelego, hilinogo noike Ómasiloka nolike Guivahani Izesúnegamaka, není sikalahú alezo. ");
INSERT INTO gah_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Loko loake, alapusa hizeake sele loko limó: Guivahani geza imane lihimáini ahuloketozo. Loko loake, hilimó. Apili hilikago, Sauló nene mulunaú lamaná gilimó. ");
INSERT INTO gah_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Setepanoni apili hilikago, monó ve lugáa keza Setepanoni ive nama goha itiki gale zitamó. Ámina zupa nene Zelusale numutoka monó gele vegená apí iki gopoguni napa milikitamó. Milikimikago hutilí iki nivake Zutaia mikasiuka itó Samalia mikasiuka vi asú ikago, aposoloma kezáikó Zelusalega minamó. ");
INSERT INTO gah_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Lá niago, Sauló nene monó gele vegená lova ale kimike numúikú iteká lemeká noike ve vená gelelehá oloko leme leme ike nagá numukú ahuloketomo vimó. ");
INSERT INTO gah_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Lá noigo, hutilí i va vegenámate Ómasímini gakó li kimi kimi iki mihina iki minamó. ");
INSERT INTO gah_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Minake, Pilipó nene Samalia apalímini taoni napaló lomoko anitike Ómasímo gologí oletative loko lo mololeta ve Izesuni gakó lo keme keme oko minamó. ");
INSERT INTO gah_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Lo kemekago, vegená mukilite Pilipó lo kimi gakó gili hamó iki amegesaló miliake, Pilipó alévolé suni haitopaitolímini loló igo ánigamó. ");
INSERT INTO gah_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Lá noike vegenalitini kigikagú holosi golesa minamoláa kepeleko kimisele ahulokago, gopaga liki vamó. Itó gepili napili itó genisi vegená mukí kelémo zokamó. ");
INSERT INTO gah_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Lá okago ámina apakú vegená keza kogoliza vizemó. ");
INSERT INTO gah_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Lá niago, ámina taoniló ve makó minamó, agulizá Saimon. Áisi gamena hána soza saza lusa geko minake, neza nugulizaki ve nouve like Samalia vegená mukí kogoka vizeaká imó. ");
INSERT INTO gah_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Lá noigo, iti minamó limi minamó keza gelemó lamaná okago, aikumú nene Ómasímo zámuza amekago, netá matá loló okago gihila zeaká noive liki liaká amó. ");
INSERT INTO gah_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Lá iake, gamena hána aí avevezaha netakumú sigaga limiake, aí gakó gili aliake aitoka viki gímizemó. ");
INSERT INTO gah_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Lá iki niago, Pilipó eza Ómasímini gasovaló minoakalímini gakó lamaná itó Izesu Kilistoni gakola lo kemekago, gili alévolé iake, ve vená mukí nene monó nagamí hilamó. ");
INSERT INTO gah_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Lá ikago, Saimon eza ámina oko monó gele alévolé oake nagamí holoake Pilipotoka voko gímizekago, Pilipó golivagi netá haitopaitó ale utó okago, ánigoake sigaga sagaga loko minamó. ");
INSERT INTO gah_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Itó aposolomate Samalia vegenalite Ómasímini gakó gili alemó nene gilikago, Zelusalegatí nene Pitaki Zoniki áminaloka kimisilikago vasimó. ");
INSERT INTO gah_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","16","Neneloka anitikasike ánigasimó nene Izesuni agulizatokó monó nagamí hilinamóza, Ómasímini Sikalahú nene monó nagamí hila vegenatoka limitive liki Ómasiloka linamamó nenazo, Sikalahú nene keitoka velesá lememigo hanuva niago ánigasimó. ");
INSERT INTO gah_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Lá okago, aposolo keza gotóitó kigizani milikasigo, Sikalahú nene keitoka limimó. ");
INSERT INTO gah_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Lá okago, Saimon nene ánigoake, keitoka moni alitáihe loko aleko vike, ");
INSERT INTO gah_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ve makolímini gotolaló nigizani molokugo Sikalahú limitive liki zámuza lekelitoka nekoma makó nimilizo. ");
INSERT INTO gah_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Loko lo kemekago, Pitá láa loko lo amimó: Ómasímini zámuza hanuva lemeaká netá nemóza géisi monitunú meina hizitove loko nolape. Nenemú geza monikagi voko lokú latila inogo ane. ");
INSERT INTO gah_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ómasímo geí gigika ánigamó nene monó nominazo, monó hoza nalusimó nene aleminogo ane. ");
INSERT INTO gah_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Golesa netaka ale ahulokoko gigika ale viligoko Guivahanímo gigikatunú netá golesa alitove loko nogeleni netá ahulogetative loko amuza moloko aitoka lozo. ");
INSERT INTO gah_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Gigikagú golesa netá ekesalagi minoake gelémo golesa okago gelekuve. ");
INSERT INTO gah_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Loko lokago, Saimon nene nenikumule liki nilasi netá nenitoka utó amitive liki Ómasiloka lilizo, loko lo kimimó. ");
INSERT INTO gah_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Aposolo nenetosa Guivahanímini gakó liki Guivahani oko moloko i gakó li kimikasike, Zelusalega atiginá iki nivasike Samalia apá mukitoka nene gakó lamaná li kimi kimi iki mihina asimó. ");
INSERT INTO gah_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Lá niasigo, Guivahanímini ageló makolímo Piliponi láa loko lo amimó: Geza Zelusale numutoka ahulokoko ezega agilikaloka Gaza apatoka lomo noi gapoló mikasi gomopalaloka nene lomoko vozo. ");
INSERT INTO gah_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Loko lo amekago, Pilipó nene oteake lomoko vimó. Novigo, Etiopia mikasigutí agulizaki ve makó minamó. Eza Etiopia vegenalitini agulizaki vená napa Kataké ave liki liaká a vená nene gelekelé otoko minake aí moniló gizapa otoko minoaká imó. Eza Zelusalega Ómasímini monó linogo iteake, ");
INSERT INTO gah_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","atiginá oko nolimike hosi izate gelelehá iaká a kaligú iteake novike, Ómasímini agepagutí gakó loaká ve Isaiá luhuva giza gakó nagatago, ");
INSERT INTO gah_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Sikalahulímo Piliponi nene voko kali volane vo agupeló vozo. ");
INSERT INTO gah_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Loko lokago, Pilipó nene ololu loko áminaloka vimó. Vike Isaiá giza gakó nagatago geleake loká otake gakó nagatanimómámini mogonáa gelenape. ");
INSERT INTO gah_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Loko lokago, ve makolímo lo utó oko lo nememitimó nene, mogonáa nana oko gilitove. Loko loake, imanegú iteko minoko lo nimitane loko Piliponi lo amekago, kaligú itekago, makó minasimó. ");
INSERT INTO gah_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Lá niasigo monó gotolagutí gata gakó lá oko minamó: Sipsip iza kipilinigi aliliki nivago zohenené lisá amave. Sipsip izatini zopova nihukago gopaga lisá amave. Ezagi ámináminoko géneka loko gopaga lamive. ");
INSERT INTO gah_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Miluma netá alimiake avozagi netá lilí imiake aí lihima nomitó hanuvamú goní hoza amemole. Mikasigú minoko aleko i gamena nene hukitamó nenazo, oko moloko noigo ánigi mina vegenalitini lihimáini nene ve makolímo gato asú aminogo ive. ");
INSERT INTO gah_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Loko mina gakó nene gatoake, agulizaki vemámo Piliponi láa loko loká otamó: Geza lo nemezo, gilitoze. Ómasímini agepagutí gakó loaká vemámo éahikumú nolive. Ezáamú nolihe itó ve makokumú nolive. ");
INSERT INTO gah_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Loko lokago, Pilipó nene ámina monó gotolaú gakó apí oko loloko vike Izesuni monó gakó nene miní ameko lo utó oko lo amimó. ");
INSERT INTO gah_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","37","Lá ikasike viki nagamitó anitesimó. Anitikasike agulizaki vemámo láa loko limó: Ánigozo. Nagamí imane nenazo, hize lí ogetati netá nomikoma monó nagamí holonetatane loko noluve. ");
INSERT INTO gah_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Loko loake, hosi izama pasimozo lokago, pasimikasike, Pilipoki agulizaki vegi keza nagamikú lemesimó. Lemesike Pilipó nene nagamí holotamó. ");
INSERT INTO gah_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Lá ikasike nagamikutí itesimó. Itikasigo, Guivahanímini Sikalahú nenémo Piliponi alémoko vokago, agulizaki vemámo goha aí ánigamimóza, gapoló novike agoliza vizitímo Pilipó legesó ikumú nene miluma gelemimó. ");
INSERT INTO gah_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Itó Pilipó nene galinali Azoto numutoka nouve loko geleake, monó gakó nene numutó namató lo keme keme oko vike Sisalia numutoka anitimó. ");
INSERT INTO gah_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Lá noigo, Sauló eza Guivahanímini vegenala zuha kipilinogo lovaga lo kimike guguni giziaká a vetini ve napa noitoka vike láa loko lo amimó: ");
INSERT INTO gah_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Izesú vi gapoló amegesaló miliki vina vegená vehe venape nániginake kalapusi kemeko kelémo-loko Zelusale numutoka atove loko luhuva netá gizokoko nemekako nene aleko vinake Tamasiko numutoka monó numukú gizapa vegená kimitove loko noluve. ");
INSERT INTO gah_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Loko lokago, luhuva netá gizoko amekago, aleko Tamasiko numutoka vimó. Voko ámina apá ale alitokago, okulumakutí lapaná galinali aitoka limike hizekago, ");
INSERT INTO gah_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","mikasigú pou loko akoake gakó makó lá oko gilimó: Saulo, Saulo, nanamú gopoguni nomolonetane. ");
INSERT INTO gah_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Loko lokago, eza Guivahani geza éagama nolane loko lokago, eza lo amike limó: Gopoguni molonimiaká noani ve neza Izesunama noluve. ");
INSERT INTO gah_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Otezo, taoni napagú itekako, netá matá loló itanimó nenémini gakola li giminigi aze, oteoko aló tovozo. ");
INSERT INTO gah_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Loko lokago, Sauloki makó va vegenalite vegenaláa agupeló ánigamamóza, gakola ligo anoláagó giliake kegepa gahava nomigo minamó. ");
INSERT INTO gah_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Lá okago, Sauló eza oteake ánigamó agómula mota golesa okago, netá matá ánigamimó. Lá oko ánigamigo, vegenala zuhate agizató aliki alími Tamasiko numutoka vamó. ");
INSERT INTO gah_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Lá ikago, neneloka gamena losive makole nene agómula pulusamigo nosánetaki nagamiki namike, hanuva ako minamó. ");
INSERT INTO gah_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Lá okago, Tamasiko numutoka nene Izesuni gelekelé veva makó minamó, agulizá Ananiá. Guivahanímo vamotoka sele lokago, eza Guivahanínemaka, imane nouve lokago, ");
INSERT INTO gah_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Guivahanímo miní ameko láa loko lo amimó: Geza otekoko gapo makó agulizá hee lo mina gapoló voko Zutani numukú iteko Taliso numutotí ve makó agulizá Sauló loko noi vemú nene vitagá oko ánigozo. Eza Ómasiloka agepoka loko noive. ");
INSERT INTO gah_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Áisi nene vamokitana netá lá oko ánigokave. Ve makó agulizá Ananiá ave loko noi vémo numunagú iteake goha agómula goloutative loko agizani nene gotolaló moloko Ómasiloka noligo ánigoake Ómasiloka nolive. ");
INSERT INTO gah_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Loko lo amekago, Ananiá láa loko limó: Guivahanínemaka, ámina vemú gakola avetó iaká niago gelenou vemú nolaninae. Áisi nene Zelusale numutoka vegenaka zuhama kelémo golesa palasa oaká noive. ");
INSERT INTO gah_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Itó imaneloka guguni giziaká a ve napa nenete geí gugulizá alina vegená nene nagá zeko kelémoko Zelusalega nagá numukú ahuloketative liki litina vema nenae. ");
INSERT INTO gah_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Loko lokago, Guivahanímo láa loko lamoko hanuva vozo loko limó. Ámina ve nenémo nigizani luhuva nene hetoka vegenaki kugulizaki ve napagi Isilae vegenaki keitoka lole ale oko minative loko alémo etó okuve. ");
INSERT INTO gah_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Lá noiko nénisi nene nugulizakumule loko miluma netalímini amupiló iteko minative loko alapizinogo uve. ");
INSERT INTO gah_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Loko lo amekago, Ananiá nene vike Zutani numunagú vo aniteake numukú itike Sauloni ánigoake agizani nene gotolaló moloake Sauló nigivénega, gapoló noako Guivahani Izesú utó o gimi vemámo goha gogómula goloutokiko Ómasímini Sikalahú nene lemeko gigikagú mino vaí itive loko nimiselekago nouve. ");
INSERT INTO gah_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Loko noli agepagi galavizakitana netá nene agómulagutí alemó zekago, agómula goloutokago oteake monó nagamí holamó. ");
INSERT INTO gah_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Holokago, nosánetá noake amuza goha molamó. Lá oake, Sauló nene Izesuni vegenala zuhagi gamena lagasó Tamasiko numutoka nominake, ");
INSERT INTO gah_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","litá oko Zuta vetini monó numukú iteko Izesuni gakola like Izesú nene lamaná Ómasímini gipala noive. ");
INSERT INTO gah_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Loko lo kemekago, ámina gakó gele vegená mukilite láa liki lamó: Zelusale numutoka ámina agulizá noli ve amegesaló mila vegená kelémo golesa galasa i vema nehe. Áisi ámina oko imaneloka nagá kemeko kelémo-loko Zelusale numutoka guguni giziaká a ve napa niatoka vinogo noamóma neve. Nana oake ale noviligave. ");
INSERT INTO gah_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Liki kagata losi nigeleke lamóza, Sauló nene amuza moloko vova vova oko minake Izesú nene gologí oletative loko lo mololeta vema noive loko Tamasiko numutoka Zuta ve minamoláa ale guni oko lo kemekago, kegepa gahava nomigo minamó. ");
INSERT INTO gah_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","24","Lá iake Zuta vete Sauloni apili hilinigi li hukiake, únaká neteká numuni gatetó nene gohoni gohoni nimilago, Sauló nene gakó geleake lokago, ");
INSERT INTO gah_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","vegenala zuhate nene holugú gosúveha makó aliake lohusi iake áminagú Sauloni ahulimiake geisa hetoka ahelú i ahulikago, lemeake mikasi makotoka golisi vimó. ");
INSERT INTO gah_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Alika Sauló vike Zelusalega aniteake Izesuni vegenala zuhaloka miní amitove lokago, Izesuni izegipala loló imó nene gili guni amake aikumú kehelele vizimó. ");
INSERT INTO gah_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Lá okago, Panapasí nene ale gímizeake alémo-loko aposolo niatoka vike Sauló nene gapoló Guivahani ániga gakó itó Guivahanímo lo ami gakó itó Tamasiko numutoka Izesuni gakola ale akutoko lo kimi gakó nene avetó oko lo kemekago, giliake ");
INSERT INTO gah_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","kezagi Zelusale numutoka miniki aliki amó. ");
INSERT INTO gah_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Lá ake, Sauló eza Izesuni gakola nene alegesá legemigo vegená lo kemeaká imó. Lá oake, ezagi Zuta ve lugáa Kiliki gakokutí liaká a vegenaki monó ligili hagili ake pelevesa ziake ámina ve nenete Sauloni apele hilitune likago, ");
INSERT INTO gah_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","agive keza giliake, alímiki Sisalia apatoka limiki ahulimikago, eza vike ezáa gotó apatoka Taliso numutoka anitimó. ");
INSERT INTO gah_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Lá okago, monó gele vegená Zutaia itó Galilaia itó Samalia mikasiuka minamoláaloka nene nonagá iki minamó. Hulu utó okago minake, Ómasímo zámuza kemekago, gakola gili aliake, némini manámini amake Ómasímini Sikalahulímo hize lé okimikago, hizi hutilí iki minamó. ");
INSERT INTO gah_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pitá nene Izesuni vegenala zuha ániganogo mohona oko vike, Lita numutoka lomo voko anitimó. ");
INSERT INTO gah_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Aniteake, neneloka ve makó ánigamó, agulizá Aeniasí. Áisi ve gepili loake, holomaló akonoigo, kilisimasi 8-ía oko vimó. ");
INSERT INTO gah_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Lá okago, Pitá láa loko lo amimó: Aeniasizo, Izesu Kilistó gelémo nozokaze, oteoko, avilisaka gakezo. Loko li agepagi oteake avilisalagi gakeko aleko vimó. ");
INSERT INTO gah_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Lá okago, Lita numutoka itó Salona numutoka nia vegená mukilite ánigiake kigika ali viligiake, Guivahaniloka viki gímizemó. ");
INSERT INTO gah_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Lá ikago, Zopa numutoka Izesuni vegenala zuhagutí vená makó minamó, agulizá Tapitá, itó Kiliki gakokutí nene agulizá Tolokasí. Eza netá gihila mukí loló ike vegená ámemena ámamana nasahilí oketoko minamó. ");
INSERT INTO gah_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Lá oake, nene gamenaló netá makó avisekago hilimó. Helekago, gonosiváa nene nagamí ziake, aliki itiki numuni amupiló makó ginakú nene ahulamó. ");
INSERT INTO gah_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lá amó nene Lita numuni nene Zopa numutotí alitó nego, Izesuni vegenala zuha keza Pitáma Litaga noive lamó giliake, ve lositá kimisilikago, áminaloka vasimó. Vasike Pitani nene voká liki gezagi litá oko lelí numutoka vitune loko nolusive. ");
INSERT INTO gah_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Liki li amikasigo, Pitagegi makó vamó. Viki gonosima milinakú nene alímiki itemó. Iteko ánigamó nene, getokó getokó ali nupa iake ive nama ake, Tolokasí nene agómulagi minake gó haitopaitolímini akotoketamó nene alapizi asú amó. ");
INSERT INTO gah_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Lá amóza, Pitá nene kimisele hetoka oake alapusa hizike Ómasiloka limó. Numuna lo asú oake, gonosima agovisa o amike Tapitazo, geza otemane. Loko lokago, agómula goloutoake, Pitani ánigoake, ote minamó. ");
INSERT INTO gah_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Noigo, Pitá nene agizakú aleko alémo otimó. Lá oake, vená getoki Izesunimú gili alévolé a vegená lugáagi sele lo kemekago, itiki ánigamó nene heleneikutí oteake noigo ánigamó. ");
INSERT INTO gah_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Lá ikago, nenémini gakola nene Zopa numutoka hutilí oko vokago, mukí vegenalite Guivahanimú gili alévolé amó. ");
INSERT INTO gah_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Lá ikago, Pitá nene ve makó pulumaká iza galupava ale lamanatamaná oaká i ve Saimoni numukú voko minamó. ");
INSERT INTO gah_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Sisalia numutoka ami vetini gizapa ve makó minamó, agulizá Koneliasí. Eza Italia mikasigutí ami ve 100 keí gizapa véini minamó. ");
INSERT INTO gah_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Eza Ómasimú alévolé oko geleko minoaká i ve monó gizapa ve minake, izegipa agunalagi Ómasi geké litiki minake, Zuta ve ámemena hize lé oketoko minake, Ómasiloka gamena gamena loko minamó. ");
INSERT INTO gah_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Koneliasí eza nenéminoko minokago, gamena makó zupa nene ho ale zohota noigo, Ómasímini ageló makolímo vamotoka agulizá oko sele noligo, eza ánigo hee loko ánigamó. ");
INSERT INTO gah_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Gisili hizeko ánigoake, ininá oake Guivahanínemaka, nana ive loko lokago, áisi lo amike limó: Ómasiloka loaká ani netá itó ámemena hize lé okimiaká ani netáma Ómasiloka itekago gele lamaná okave. ");
INSERT INTO gah_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Nenemú geza ve makó kimiselekako Zopaga viki ve makó Saimon agulizá gosohá nene Pitani alímiki atave. ");
INSERT INTO gah_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Aí apolaho iza galupava ale lamanatamaná oaká vémini numuni age nagamí gahevaloka nekú noimóma alímiki atave. ");
INSERT INTO gah_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Loko agelolímo lo ameake vokago, gelekelé izegipala losi itó ami vegutí nasahilí otoko mina ve Ómasimú alévolé oko geleko minoaká i ve nene sele loake, ");
INSERT INTO gah_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","gakó akó lo kemeake kimiselekago, Zopa numutoka vamó. ");
INSERT INTO gah_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Akiake gó lokago, vake apáma ali alitanigi ago, holisaká Pitá nene numuni amupiló ginakú iteko Ómasiloka loake, ");
INSERT INTO gah_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","gaúna olokago, avonana vizekago akonoike nosánetakumú lokago, vatá iki ali vatí nitago, agómula molatohe loko noike netá makó lá oko ánigamó. ");
INSERT INTO gah_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Okulumá koló okago, netá makó lavolavo gizopa napa lohusi oake nagá alehá nene mikasigú ahelú okago nolimigo ánigamó. ");
INSERT INTO gah_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Áminámini agikagú nene gaha nama iza gala haitopaitolímini Zuta vegenalite namó namamó gopánapa netá nego ánigamó. ");
INSERT INTO gah_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Lá okago, áminagutí nene gakó makó láa loko utó imó: Pitazo, litá oko kepeleko namane. ");
INSERT INTO gah_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Loko lokago, Pitá limó: Guivahanínemaka, lá oko nomive. Neza mosehá netá ligika ale golotuva loaká netá nene gopa nosá amuve. ");
INSERT INTO gah_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Loko lokago, anotó aleko láa loko limó: Ómasímo loko nagamí zenei netá nene géisi ma moseminogo ane. ");
INSERT INTO gah_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Loko lokago, ámina gakó nene gamena losive makole likasigo, litá oko lohuvagi gelelehá oko okulumakú iteko vimó. ");
INSERT INTO gah_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Lá okago, Pitá nene nogómula molatohe loko nouke vamó itína ániguhe loko giligo gena imó. Lá okago, noigo, Koneliasí kimisili ve keza Saimoni numunimú lokatoká iki vake, ali utó iake, gatetó minake, ");
INSERT INTO gah_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","sele liki lamó: Saimon agulizá gosohá Pitá loko ne vema imane numukú noihe. ");
INSERT INTO gah_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Liki loká niago, Pitá eza vamotoka gosohá netá ánigamó nene agata geleva geleva oko noigo, Sikalahulímo láa loko lo amimó: Ve losive makolete geikumú vitagá niave. ");
INSERT INTO gah_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Nénisi kimiselekugo niaze, geza lemeko Zuta ve niagopa hetoka ve niakumú gagata losi gelemoko kezagi makó vilo. ");
INSERT INTO gah_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Loko lokago, Pitá ve niatoka lemeake nenikumú vitagá nitamó nene imane nouze, nanamú niave. ");
INSERT INTO gah_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Loko lokago, ve keza láa liki li amemó: Ami ve 100 keí gizapa ve Koneliasí áisi agika lamanaki ve Ómasimú alévolé oko geleko minoaká i ve nene Zuta vegená mukilite ánigi lamaná nia ve noive. Ómasímini ageló makolímo gakó makó lo amekago eza limiselekago, geí gelémoko aí numutoka vokuko, gegepagutí gakó lo lemekako gilitune loko noune. ");
INSERT INTO gah_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Liki likago, Pitá nene kelémo numunagú molokago akamó. Akiake gó lago, Pitá nene Zopa numutokatí agivegi makó vamó. ");
INSERT INTO gah_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Viki gapoló akiake, gó lokago goha viki Sisalia numutoka anitiake, Koneliasí nene vegenala zuhagi zogovagi kelémo nupa oake kegeva iki niago, ánigamó. ");
INSERT INTO gah_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Lá iake, Pitá nene numunagú itimó. Itekago, Koneliasí ake agisauka agihúna geake gupá zeko gekévaké lotamó. ");
INSERT INTO gah_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Lá omikago, Pitá alémo oteake lá amoko otezo, neza nene vegenáma nouve. ");
INSERT INTO gah_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Loko lo amekago, ligili hagili ikasike, vegená mukí alegesá iki mina numukú itesike ");
INSERT INTO gah_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Pitá nene láa loko lo kimimó: Lekeza Zuta ve lelí mogona mota gilinave. Lezagi Zuta vegená niamamolagi nonagá oko apizeko minamitune liki li hukinamóma nemóza, vegená makokumú móina ve loko loketamo loko Ómasímo mogona nelepizeko lo nemekago gelekuve. ");
INSERT INTO gah_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Nenemú lekeza nenikumú sele-sele likago, gena amuke okuve. Itína sele lamó nenémini mogonáa likiko gilitove. ");
INSERT INTO gah_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Loko lokago, Koneliasí lo amike limó: Neza sene ho ale zohota noigo, Ómasiloka noluke ánigumó nene, ve makó ginegane agovisámo lapetapé oko minamó nenémo nenitoka omo anitekago, ániguve. ");
INSERT INTO gah_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Nánigugo láa loko lo nimive: Koneliasizo, Ómasiloka lanimó itó vegená ámemena hize lé oketanike noanimó nene Ómasímo mota gele lamaná okave. ");
INSERT INTO gah_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Nenemú geza vegená kimiselekako, Zopa numutoka viki Saimon agulizá gosohá Pitani alímikatave. Áisi nene apolahini numukú pulumaká iza galupava ale lamanatamaná oaká vémini numukú age nagamí gahevaloka noinogo ive. ");
INSERT INTO gah_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Loko lo nemekago, nenemú litá oko kimiselekugo, geitoka vikago geza gakóne gelekanike okako mulúnegú lamaná gelekuve. Itínasa nene Guivahanímo logeta gakó nene lokako gilitune loko Ómasímini avogisaló alegesá oko imane noune. ");
INSERT INTO gah_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Loko lo amekago, Pitá láa loko limó: Ómasímo mukí vegená lelí lugupelokamú giligo iteká lemeká osá amive. Nene mota gelenouve. ");
INSERT INTO gah_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Numutó namató vegenalite Ómasimú goliva giliki etati netá aliki minata vegená mukikumú giligo hamó lelegitokó neve. ");
INSERT INTO gah_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Isilae vegenatoka gakó lamaná amisilimó nene lekeza mota gilinave. Izesu Kilistó eza vegená mukilitini Guivahani noi vemú gelekuko ligikagú hulu iti gakó nene, ");
INSERT INTO gah_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Zoní apí oko monó nagamí hilatave loko lo utó oko lo kemekago, Zutaia mikasiloka li hutilí amóma neve. ");
INSERT INTO gah_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Itó Ómasímo eza Sikalahula amiselekago, Nasalete numutotí ve Izesuni amatoka minake zámuza amekago, Ómasímo alémo vatí igo, Izesú nene mohona mohona ike hoza gihila alike Satá kelémo golesa galasa oko minoaká i vegená kelémo lamanatamaná oko mina gakó nene lekeza mota gilinave. ");
INSERT INTO gah_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Itó Zuta ve lelí mikasiukagi itó Zelusale numutokagi oko moloko ike alimó nene ánigoko gelekune. Lá onouko, zohota zaló apilikago hilimóza, ");
INSERT INTO gah_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","heleake noigo, gamena losive makole oko vokago, Ómasímo galegutí goha alémo otimó. Alémo oteake alémo utó molake lelepizigo, ánigonouháma neve. ");
INSERT INTO gah_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Mukí vegenalite Izesuni ánigamamóza, heleneikutí oteake ezagi apiziki gitigiki niki miniaká a vegená Ómasímo lelémo etó i vegenaláagó leza ánigonouháma neve. ");
INSERT INTO gah_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Itó Ómasímo lo molató gipala Izesú nene logómulagi vegenaki hele vegenaki gona mololetati ve loló i gakó nene vegená li utó iki li kimitave loko Ómasímo loletonoimóma neve. ");
INSERT INTO gah_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ómasímini agepagutí gakó liaká a ve mukilite ámina vémini gakoláa luhuva gizinamó nene lá oko neve: Aikumú gili alévolé ita vegená nene Ómasímo Izesukumule loko lihimáini ahuloketanogo ive, loko limó. ");
INSERT INTO gah_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pitá láa loko noli agepagi giliki mina vegenatoka Ómasímini Sikalahú limimó. ");
INSERT INTO gah_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Lá oko limimó nene Ómasímo Sikalahú nene hetoka vegenatokagi lehizekimikago, ");
INSERT INTO gah_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","haitopaitó konokutí liki Ómasi agepoka nilago, giliake Zuta vegenakutí Izesukumú gili alévolé a ve Pitaki makó a vete sigaga likitamó. Lá ikago, Pitá láa loko lo kimimó: ");
INSERT INTO gah_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Goí oko lelitoka Sikalahú limimó ámina oko imane hetoka vegenatoka lemekave. Nenemú monó nagamí holoketamitunimó nene etaminogo ive. ");
INSERT INTO gah_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Loko loake, lo kemekago, Izesu Kilistoni agulizató kilími milake monó nagamí hilikitamó. Hilikimiake, Pitá nene gamena luguhá kezagi minoko aleko itive liki likago, makó minamó. ");
INSERT INTO gah_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Lá okago, hetoka vegenalite Ómasímini gakotó miní ame gakó nene puu loko vokago, aposolo lugáagi kigive Zutaia mikasiuka minamoláagi keza gelemó. ");
INSERT INTO gah_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Nenemú Pitá nene Zelusalega atiginá oko tovokago, Zuta vegenakutí Izesuni nagá minamoláate aikumú gelemó gena okago, gahá nameke, ");
INSERT INTO gah_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","láa liki li amemó: Geza nanamú Ómasímini anosa kugupeloka minami vegenatoka voko kigizakutí nosá noaká noane. ");
INSERT INTO gah_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Liki likago, Pitá nene Koneliasitoka utó i gakó nene mogonagutí apí oko ale mesamá oko lo kimike limó: ");
INSERT INTO gah_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Goí oko neza Zopa numutoka Ómasiloka loko nougo, novonana vizekago, vamó netakutí lá oko ánigumó: Netá makó lavolavo napagitana nene lohuvagi nekisaloka nagá aliake okulumakutí ahelú ikago lemeko nenitoka anitimó. ");
INSERT INTO gah_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Anitekago, ánigo gisili hizeko ánigumó nene, agikagú gaha nama iza gala haitopaitolímini agisa agizani nemó nomimó nego ánigumó. ");
INSERT INTO gah_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Lá okago, nenitoka gakó láa loko anitimó: Pitazo, otekoko kepeleko nozo. ");
INSERT INTO gah_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Loko lokago, neza láa loko lumó: Guivahanínemaka lá oko nomive. Neza ligika ale golotuva loaká netá nene gopa nosá amuve. ");
INSERT INTO gah_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Loko lokugo, okulumakutí Ómasímo gakó makó miní ameko láa loko limó: Ómasímo loko nagamí zenei netá nene géisi ma moseminogo ane. ");
INSERT INTO gah_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Loko gamena losive makole nene ámina gakó lokusigo, gelelehá oko okulumakú iteko vimó. ");
INSERT INTO gah_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ma gilínagalo. Ámina netá asú noigo, áminasitó Sisalia numutokatí ve losive makole lélisi nouhatoka alesa iki anitemó. ");
INSERT INTO gah_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Anitikago, Sikalahulímo láa loko lo nimimó: Geza ámina vegi hetoka ve niakumule loko makó vinogoma gena givisemino. Loko lokago, kigive 6-a kezagi vunike ámina ve kimisili vémini numukú itekuko, ");
INSERT INTO gah_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","gakola láa loko lo limimó: Není numukú agelolímo iteko utó oake geza ve makó kimiselekako Zopa numutoka viki Saimon agulizá makó Pitá ave loko noi ve alímiki ikiko, ");
INSERT INTO gah_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","gezagi izegipa gugunamotamoki Ómasímo lukugutó viziti gakó lo lekemekiko, lamaná inigave, loko lo nimimó. ");
INSERT INTO gah_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Nene gakó lo nemekago, monó nene apí oko lo nokumugo, Ómasímini Sikalahú goí oko lelitoka limimómáminoko keitoka limimó. ");
INSERT INTO gah_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Lemekago, ánigouke, Guivahanímo Zoní nene hanuva nagamí hololeketamóza Ómasímo nene Sikalahula hololeketanogo ive loko amunaloka li gakó nene goha nagata gulumó. ");
INSERT INTO gah_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Leza Guivahani Izesu Kilistokumú gele alévolé okuko Sikalahú lehizeletamómáminoko keitoka limimó nenazo, neza ánéámina Ómasi pelevesava zetamosala nouve. ");
INSERT INTO gah_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Loko lo kemekago, keza giliake, kigikaú hulu okago, Ómasi agepoka liki láa liki lamó: Oho, Ómasi eza hetoka vegenaki kigika ali viligiiki alévolé kemetameki lilí itave loko gapo velekimikamóma neve, liki lamó. ");
INSERT INTO gah_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Setepanoni apili hilikago, Izesukumú gili alévolé a vegená nene gopoguni milikimikago, keza golisi hutilí iki vake Pinisia mikasiuka itó Saepalasi mikasi pokolaloka itó Atiokia numutoka viki Zuta vegenakó monó li kimi kimi iki minamó. ");
INSERT INTO gah_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Lá niago, holúikú Saepalasi pokolagutí itó Sailini apatokatí gili alévolé amoláa lugáate nene Atiokia numutoka aniteke Guivahani Izesuni monola nene Zuta vegenaki hetoka vegená lugáagi li kememó. ");
INSERT INTO gah_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Li kimikago, Guivahanímo zámuza kemekago, vegená mukilite giliake kigika ali viligiake Guivahaniloka viki gímizemó. ");
INSERT INTO gah_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Lá ikago, ámina gakó nene Zelusalega vokago, monó gele vegenalite giliake, Panapasini amisilikago, Atiokia numutoka vimó. ");
INSERT INTO gah_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Vo aniteake, Ómasímo hize lé oketamó nene ánigoko lamaná geleake, Guivahaniloka kigika mili alévolé itave loko kagata alimó. ");
INSERT INTO gah_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Panapasí nene agika lamanaki ve Sikalahú nene lemeko agikagú mino vaí okago, vegená mukilite giliake, Guivahaniloka miní amemó. ");
INSERT INTO gah_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Lá ikago, Panapasí eza Sauloni ániganogo Taliso numutoka vimó. ");
INSERT INTO gah_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Voko ánigoake, Atiokia numutoka alémoko vokago, monó gele vegenaki ali nupa iki minikago, vegená mukí nene monó apí i kimi kimi iki niasigo, kilisimasi hamó oko vimó. Oko novigo, Atiokia numutoka Izesuni vegenala zuhamú nene Kilistoni zuhave liki apí iki kugulizá milamó. ");
INSERT INTO gah_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Gamena nene zupa Ómasímini agepagutí gakó liaká ve makó nene Zelusalegatí Atiokia numutoka lemeke, ");
INSERT INTO gah_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","keitokatí ve makó agulizá Agaponi nene Ómasímini Sikalahulímo alémo vávani okago, oteake, numutó namató gaúna napa hilita gakó lo utó oko lo kimimó. Lo kemekago, alika nene agulizaki ve napa Loma apatoka minamó, agulizá Kalautió nene, gizapa oketonoigo, ámina gakó nene alévolé imó. ");
INSERT INTO gah_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Lá okago, Atiokia numutoka Izesuni vegenala zuhamate ámina gakó giliake, kigive Zutaia mikasiloka minamoláaloka moni mina avotigila oko ale nupa oko kimitune liki li hukiake, ");
INSERT INTO gah_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","ali nupa iake Panapasinigi Saulonigi nene kimikago, keza aliki viki Zelusalega monó olotiva ve nene kemesimó. ");
INSERT INTO gah_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Gamena nene zupa agulizaki ve napa Heloté nene Izesuni vegenala zuha lugáa nene lova ale kimike, ");
INSERT INTO gah_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","eza lokago, Zonini uvolaho Zemusini luvana hukamó. ");
INSERT INTO gah_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Lá ikago, Zuta vegenalitini monó gizapa vete gili lamaná ikago ánigoake, lá itave loko lokago, Zuta vetini avóikini asenini zeketakumú gili mina holisigú Pitani nene nagá numukú alími milamó. ");
INSERT INTO gah_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Ámina holisi asú okiko Zuta vetini kigizakú molokugo goní imiiki apili hilitave loko geleake, agizató aleko nagá numukú alémo moloake, losive losive iki gizapa itatave loko pilisi ve 16 kelémo molamó. ");
INSERT INTO gah_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Lá okago, Pitá noitó nene alévolé iki gizapa iki niago, Pitá nene nagá numukú akonoigo, Izesuni vegenala zuha keza Ómasiloka alévolé iki numuna nilago, te te oko minamó. ");
INSERT INTO gah_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Lá onoigo, Heloté eza gó lokiko Pitani nene Zuta vegenalitini kigizakú molati gamena alitokago, ámina holugú Pitani agizani lugaloka pilisi vémini agizatoka seni nagatunú zemó, itó agizani lugaloka nene maga vémini agizató zemó. Lá iake akinago, gizapa ve lugáa nene gatetó gizapa iki minamó. ");
INSERT INTO gah_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Lá niago, Guivahanímini ageló makolímo galinali utó oake noigo, nagá numuni agikagú nene lapaná lo asú imó. Lá okago, ageló nenémo Pitani agahaisiló zeko alémo oteko litá oko otezo loko lokago, Pitá otimó nene agizakú seni nagá apasomó zekago, ");
INSERT INTO gah_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","ageló nenémo holotakama ale zekoko gigisaló suú ale luhozo. Loko lo amekago lá okago, goha lo amike limó: Goka hánama ale luhokoko némegetoko ano. ");
INSERT INTO gah_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Loko lokago, agelolímo oko moloko imó nene gele guni amike vamó nániguhe loko nogilike ámegetamó. ");
INSERT INTO gah_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Lá iki limiki gateni makotó pilisi ve niago kiviligikasike gateni makotó ámina iki niago kiviligikasike, apá napaló vegegisa aenitunú atagamó nene ezáa gahe segeake koló okago, limikasike gapoloka nivasike, agelóma tolova imó. ");
INSERT INTO gah_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Lá okago, Pitá nene agata kolosokago, láa loko limó: Mota gelekuve. Guivahanímo ageló makó amiselekago, limike, Heloteni agizakutí itó Zuta vegenalitini gizapa vetini mukahakutí gologí onimikave. ");
INSERT INTO gah_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Loko Pitá nene geleake, Zoní agulizá napa nene Makí ave loko noi vémini izolaho Maliani numutó vo anitimó. Ámina numukú vegená mukí alegesá iki minake Ómasiloka liki niago, ");
INSERT INTO gah_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pitá nene gatetó hoko-hoko lokago, gelekelé mohó makó agulizá Loté nene éaho hoko-hoko nolihe loko lemeko ");
INSERT INTO gah_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","gatetó nene Pitani anó lupamú geleake, gahe segemike agoliza napa vizitímo ololu loko iteko Pitá nene oko gatetó noive loko lo kemekago, ");
INSERT INTO gah_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","áminagú mina vegenalite giliake gigika hize lí okago nolape. Liki li amikago, áisi nene Óe, negiga lamuve, áisima gatetó noigo noluve, loko lokago, keza vogunámo noitive. ");
INSERT INTO gah_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Liki nilago, Pitá nene hoko-hoko lokogó noigo, gahe sigiake ánigamó nene Pitá noigo ánigiake, kegepa gahava nomigo ininá amó. ");
INSERT INTO gah_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ininá ikago, gakó lamitave loko agizanitunú avevezaha o kemeake, numukú itemike, Guivahanímo nagá numukutí gologí oko alémo hetó i gakó nene avetó oko lo kemeake láa loko limó: Lekeza imane gakó viki Izesui agunala Zemusini itó monó gele vegená lugáa li kimilo loake, olío hizeko apá makotoka vimó. ");
INSERT INTO gah_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Lá okago, akiake, gó lokago, pilisi ve keza Pitakumú vitagá amó nene nagá numukú noamigo, Pitani nana itave liake, negi-nagi hizeke lova leta lava leta iki minamó. ");
INSERT INTO gah_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Lá ikago, Heloté nene vitagá itave loko lokago, vitagá iha iha alími utó milamago, pilisi ve nagá numuni gizapa vema loká miká okimiake, kipili ahuli ahuli itave loko lo hukoketamó. Lá oake, Heloté nene Zutaia mikasi ahuloake Sisalia numutoka lemeko minamó. ");
INSERT INTO gah_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Nene zupa nene Tulo vegená itó Sitona vegenakumú Heloté izapaló molokago, lova ale kimimó. Lá okago, ámina apá amelage keza Heloté noitoka imi asú iake, Heloteni gizapa veva makó agulizá Pilasitó ave loko noi ve agata aliki likago, eza agulizaki ve napamaloka voko gakóini nene láa loko lo amimó: Keza nosánetá ale nómonó ituni gapo hukokaninazo, gelémo hulu itune liki ikave. ");
INSERT INTO gah_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Loko lokago, Heloté nene gakó lo kimitove loko gamena molamó nene alitokago, vegená mukí iki niago, eza kugulizaki vetini gonanalivagi gó ale luhoake, golivagi siató iteko minake, gakó hána hána like gakó lo kimimó. ");
INSERT INTO gah_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Gakó lo nokimigo, vegená mukilite gakó napa lake vegenalitini konó lupa nomive. Ómasi makolímini anó lupa neve. ");
INSERT INTO gah_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Liki likago, géneka lamike nenikumú gekévaké lamiki Ómasi hamokó geké litalo loko láa loko lamigo, Guivahanímini ageló makolímo galinali anitike lokago, ámina vémini agupegú ginini hizekago hilimó. ");
INSERT INTO gah_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Itó Ómasímini gakó nenémo hutilí oko puu loko mukí apatoka vimó. ");
INSERT INTO gah_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Lá okago, Panapasiko Sauloko keza Zelusalega goí iki moni kimiki kimisele hoza kememó nene ali asú ikasike Atiokia apatoka atiginá iki vinigi niasike Zoní agulizá napa Makini nene alímiki makó vamó. ");
INSERT INTO gah_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Atiokia numutoka Ómasímini vegenala zuhatini holúikú Ómasímini agepagutí gakó liaká a vegi monó apí i kimiaká vegi minamó, kugulizá Panapasí itó Simeó agulizá makó Anupavé, itó Lukió eza Kulena apatotí ve, itó Manaé, ezagi gizapa ve Heloteki ganagana minimi niteki napa asi ve, itó Sauló. ");
INSERT INTO gah_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Gamena makó zupa monokumule liki nosánetá mosiki minake monó numukú alegesá iki numuna nilago, Sikalahulímo gakó láa loko limó: Panapasiko Sauloko keza monó hoza alitáive loko loketumó nene nenikumule liki kilími gapo ilo. ");
INSERT INTO gah_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Loko lokago, nosánetá mosiki minake Ómasiloka lake kigizani nene gotóitó milake lusa gikimiake, monó hozaló kimisilikago vasimó. ");
INSERT INTO gah_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Ómasímini Sikalahulímo lá okimiake kimiselekago, vasike Selusia numukú limiviki vasimó. Vi anitikasike sipigú itikasike viki Saepalasi mikasi pokolagú anitesimó. ");
INSERT INTO gah_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Apá gotola Salamisi neneló viki Zuta vetini monó numukú itiki Zoní agulizá napa Makí áisi kelémo vatí igo Ómasímini gakó li utó asike li kemesimó. ");
INSERT INTO gah_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Lá ikasike pokolagú mihina i asú iake Papo numutoka anitemó. Neneloka Zuta ve soza saza lusa geaká i ve soza monó lole ale ve minamó, agulizá Pala-Izesú. ");
INSERT INTO gah_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Nene vémo kiapé makó Selegió Pauloni apolaho agata koloso mina veloka hoza aleko minamó. Kiapé nenémo Ómasímini gakó gilinogo Panapasiko Sauloko alesa molo kimimó. ");
INSERT INTO gah_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Alesa molo kemekago, soza saza lusa geaká i vémo agulizá makó nene Elimasí eza kiapémo giliko alévolé okative loko zevo hukovo oketamó. ");
INSERT INTO gah_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Lá okago, Sauló agulizá gosohá Pauló eza Sikalahulímo lemeko agikagú mino vaí oake alémo vávani igo, Elimasini gisili hize agupe oake, ");
INSERT INTO gah_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","láa loko lo amimó: Géisi nene Satani gipalamaka netá lamaná lova ale ameaká ve neneka, soza saza gakolímo gigikagú vaí oko minamó geza Guivahanímini gapo hize lí okanike ale gopa napa oaká noani netá nene nanahé ahulatane, olo. ");
INSERT INTO gah_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Nenemú imane Guivahanímini zámuzámini mogona ánigatanize. Geza gogómula likokiko gamena makotó lapaná ánigamoko minatane. Loko noli agepagi agómulagú límugusi zekago, likatiká ike akaká akaká oko mohona noike nigizató alitave loko vegená sele loiaká imó. ");
INSERT INTO gah_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Lá okago, kiapé nenémo ámina netá utó imó nene ánigoake Guivahanímini monokumú gilimó nene goliva hizekago, gele alévolé imó. ");
INSERT INTO gah_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Lá okago, Pauló agivelagegi keza Papo apá ahuliake sipigú itiake viki viki Pamapilia mikasiuka Pelega numutoka anitemó. Neneló Zoní ahulokimiake atiginá oko Zelusalega vimó. ");
INSERT INTO gah_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Lá okago, keza Pelega numutotí viki Pisitia mikasiuka nene Atiokia numutoka anitesimó. Neneló niasike Zuta vetini holisigú keí monó numukú itiki niasigo, ");
INSERT INTO gah_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","keí gizapa ve keza Mosé giza gakokutiki Ómasímini agepagutí gakó liaká a vete giza gakokutiki gati kemeke gati asú iake, alesa miliake láa liki li kememó: Ligivese, lelémo kii loletati gakó makó likigikagú netimó nene likisiko gilitune. ");
INSERT INTO gah_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Liki likago, Pauló oteake, legesó iki minatave loko agizanitunú avevezaha ike láa loko lo kimimó: Isilae vese, lekezagi Ómasimú goliva giliaká nia vegená lugáa lekelí nene lo likimitoze, gililo. ");
INSERT INTO gah_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Isilae ve lelí Ómasi áisi nene avotege keza Izipi mikasiuka niago, kelémo napa napa igo, hizi hutilí amó. Lá ikago, zámuzalaló molo gelekelé ike nenelokatí kelémoko oake, ");
INSERT INTO gah_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","mikasi gomopalaló keikumú goselé apelemimó nene hanuva geheake nasahilí oketoloko novigo, kilisimasi 40 oko vimó. ");
INSERT INTO gah_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Oko novigo, Kenan mikasigú vegená mulusi 7-a kelémo tolova oake, mikasíini nene avotegini gona moloko kemekago, ali etó etó ake alemó. Lá ikago, kilisimasi 450 oko vokago, ");
INSERT INTO gah_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ómasi eza gizapa ve kelémo etó omo novigo, miniliki nivago, Ómasímini agepagutí gakó loaká ve Samuelé utó imó. ");
INSERT INTO gah_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Utó oake mino-loko itekago, vegená keza agulizaki ve napamú loká miká ikago, Ómasímo Pezamini agapilamó keikutí Kisini gipala Sauloni alémo etó okago, kilisimasi 40-a ale nahulake gizapa oketamó. ");
INSERT INTO gah_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Lá okago, Ómasímo Sauloni viselemiake Tevitini nene agulizaki ve napa alémo otimó. Lá oake aí gakola láa loko limó: Zesini gipala Tevitikumú lagava gelekuke ánigo mulumó. Áisi nene litotoka molatotoka oko moloko inogo ive, loko limó. ");
INSERT INTO gah_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Itó Ómasímo utó itive loko lo molató Tevitini agapilamola zuhagutí Isilae ve lelitoka lugutó viziti ve Izesuni amisilimó. ");
INSERT INTO gah_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Vegená holúikú omo utó itive loko Zoní nene Isilae vegená kigika ali viligiiki monó nagamí hilatave loko lo utó oko lo kimimó. ");
INSERT INTO gah_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Lá oake, Zonini ami hoza nene ale lutegeake láa loko lo kimimó: Gologí oletative loko lo mololeta vema noape liki loká inimiaká nia ve nene neza minamuve. Áisi nene alika nemegesa moloko ova ova noize, neza ánéámina hoza makó alemioko aí gasa gó ate akisitotó vo akohemuve. ");
INSERT INTO gah_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Nigive nagavese, Avalahani agapilamola lekezagi itó hetoka vegená lugáa Ómasimú geké limiaká nia vese, gakó litoze, gililo. Lugutó viziti gakó nene lelitoka molonoimóma neve. ");
INSERT INTO gah_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Zelusale numutoka kugulizaki vegi vegená lugáa mukí keza Izesuni ánigi hee lamake, Ómasímini agepagutí gakó liaká a vete gizi mila gakó holisi zupa zupa gatoaká nouháma gili hee lamake, Izesuni apilitave liki li hukitamó. Lá ikago, Ómasímini agepagutí gakó liaká a vete aikumú luhuva gizina gakó nene alévolé imó. ");
INSERT INTO gah_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Lá okago, Izesuni apilita gakokumú vitagá iake, gakola nomigo, gopa Pilatotoka viki negénegeka lago lago gele kemekago, apili helemóma neve. ");
INSERT INTO gah_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Lá ikago, monó gotolaú aikumú luhuva gizi mila netá nene lilí i asú ikago, zohota zalotí vínasiki aliki viki gonosi matimati geha mulikú militamóza, ");
INSERT INTO gah_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ómasímo heleneikutí alémo otimó. ");
INSERT INTO gah_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Alémo otekago, Galilaia mikasiukatí Zelusale numutoka ezagi makó tiva vegenatoka gamena gamena utó okemeká tolova oká igo ánigiaká a vegená nenete aí gakó nene li utó iaká ve lilí iki niave. ");
INSERT INTO gah_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Itó avotegini nene Ómasímo lehizeketatove loko lo moloketa netakumú mulutikú lamaná gilita gakó láa loko lo nolukumune: Ómasímo Izesuni alémo otitove loko li gakó nenémo kagapilamó lelitoka nene mota gihila zekave. ");
INSERT INTO gah_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Alémo otikumú Ómasi agepoka liká nama liká a gakokutí lakani losigú láa loko luhuva gizonoimóma neve: Geza nene gipáne noanize, neza itínasa gelémo utó molokuve. ");
INSERT INTO gah_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Itó Izesuni nene heleneikutí alémo otekago, alikaloka goha heleminogo ive. Nenemú Ómasímo láa loko lokago luhuva gizo molonoimóma neve: Neza Tevitini lehizetatove loko lo molotu netá nene lamaná lehizeleketanogo uve. ");
INSERT INTO gah_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Nenemú Ómasi agepoka liká nama liká a gakokutí gakó makó lá oko neve: Neza nigika lamanaki ve nounazo, geza lanitoka nugupéa anuva aminogo ive, loko limó. ");
INSERT INTO gah_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Tevitini mogonáa mota geleaká noune. Aí nene Ómasímo hoza gakó lotamó nene vegenala zuhaloka hoza aleloko vike ale asú oake hilimó. Helekago, avolagini gonosíini milikimiakakú milimikago, agupéa anuva oko gelesa imó nenazo, nugupéa anuva aminogo ive loko li gakó nene Tevititoka gihila zemimóza, ");
INSERT INTO gah_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ómasímo alémo oti vémini agupe anuva oko gelesamimó. ");
INSERT INTO gah_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Nenemú nigive nagavese, hehe loko lo likimitoze, gililo. Ámina vémo ale utó molokamómave loko gakolímo omo lokogovisaloka noave. ");
INSERT INTO gah_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Lihimatini nagakutí nene Mosé lo hukoko li gakolímo gologí oletosá amimóza, Izesukumú gili alévolé itamó nene lihimavatini nagakutí gologí o asú oleketanogo ive. ");
INSERT INTO gah_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Ómasímini agepagutí gakó liaká a vete gakó makó luhuva gizinamóma nene, lekelitoka alévolé okative loko lakagata aleko lo nolukumuze, ehe, gizapa iki minalo. Láa liki luhuva gizinamóma neve: ");
INSERT INTO gah_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Agae, monó gili ahuliaká ve lekeza sigaga liki liki hili minalo. Lekelí gamenavatini nene hoza haitolímini alinogo uve. Nenémini gakola li likimikiko gilitamóza, gili vevesiki geleminigave, liki luhuva gizinamóma neve. ");
INSERT INTO gah_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Itó Pauloko Panapasiko láa liki li kimikasigo, monó numukutí limiake alika holisigú ámina gakó goha litáihe liki loká ikitamó. ");
INSERT INTO gah_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Láa liki liake, alegesakutí limiake Zuta vegená mukí itó hetoka vegená keza Zuta vetini monokumú gutá iki mina vegená kezagi makó Pauloko Panapasiko kémegetago, Ómasímini nasahilikú alévolé iki minatave liki kagata alesimó. ");
INSERT INTO gah_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Lá ikasigo, holisi makó alitokago, ámina apá amelage Ómasímini gakó gilinigi vóvotiki anitemó. ");
INSERT INTO gah_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Anitikago, Zuta vete keza ánigiake, kemekugú niake, Pauloni gakola pelevesava ziake Pauloni alivi galativi amó. ");
INSERT INTO gah_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Lá ikago, Pauloko Panapasiko ali akutiki láa liki li kemesimó: Zuta ve lekelisi ató nene Ómasímini gakó ganá apí iki gilitave liki 