﻿USE sofia;
DROP TABLE IF EXISTS sofia.fuv_vpl;
CREATE TABLE fuv_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES fuv_vpl WRITE;
INSERT INTO fuv_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","طٜعٜ نغٛنِ اِنْطٜ مَامَعٜنْ يٜىٰسُ اَلْمَسِيحُ لٜݧٛلْ دَوْدَ، دَوْدَ لٜݧٛلْ اِبْرَاهِمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","اِبْرَاهِمْ دَݧِ اِشِيَاکُ، ندٜنْ اِشِيَاکُ دَݧِ يَاکُبُ، ندٜنْ يَاکُبُ دَݧِ يَحُودَ اٜ سَکِرَاٻٜ مَاکٛ، ");
INSERT INTO fuv_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","يَحُودَ دَݧِ فٜرٜسَ اٜ جٜىٰرَ، مَدُوجٛ جٜىٰرَ وٛنِ تَامَرْ، فٜرٜسَ دَݧِ حٜسٜرُونَ، حٜسٜرُونَ دَݧِ اَرَمْ، ");
INSERT INTO fuv_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","اَرَمْ دَݧِ اَمِينَدَبْ، اَمِينَدَبْ دَݧِ نَاشٛنْ، نَاشٛنْ دَݧِ سَلْمٛنْ، ");
INSERT INTO fuv_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","سَلْمٛنْ دَݧِ بٛعَاجَ، مَدُوجٛ بٛعَاجَ وٛنِ رَحَبْ، بٛعَاجَ دَݧِ اٛبِدَ، مَدُوجٛ اٛبِدَ وٛنِ رُتْ، اٛبِدَ دَݧِ جٜىٰسِ، ");
INSERT INTO fuv_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","جٜىٰسِ دَݧِ دَوْدَ لَامِيطٛ، دَوْدَ لَامِيطٛ دَݧِ سُلٜيْمَانُ، مَدُوجٛ سُلٜيْمَانُ وٛنِ دٜبّٛ اُرِيَ ندٜنّٛ، ");
INSERT INTO fuv_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","سُلٜيْمَانُ دَݧِ رٜحٛبٛوَمْ، رٜحٛبٛوَمْ دَݧِ اَبِجَ، اَبِجَ دَݧِ اَاسَ، ");
INSERT INTO fuv_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","اَاسَ دَݧِ جٜحٛوشَفَتْ، جٜحٛوشَفَتْ دَݧِ جٛورَمْ، جٛورَمْ دَݧِ اَجَارِيَ، ");
INSERT INTO fuv_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","اَجَارِيَ دَݧِ جٛوتَمَ، جٛوتَمَ دَݧِ اَحَسْ، اَحَسْ دَݧِ حٜجٜکَايَ، ");
INSERT INTO fuv_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","حٜجٜکَايَ دَݧِ مَنَاسٜ، مَنَاسٜ دَݧِ اَمٛنْ، اَمٛنْ دَݧِ جٛوسَيَ، ");
INSERT INTO fuv_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","جٛوسَيَ دَݧِ جٜکٛونِيَ اٜ سَکِرَاٻٜ مَاکٛ وٛرْٻٜ، شَرٜلْ کٛ يَحُودَنْکٛعٜنْ نَنْغَا نجَارَا لٜيْدِ بَابِيلَ؞ ");
INSERT INTO fuv_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","غَطَ طُمْ يَارِيٻٜ لٜيْدِ بَابِيلَ، جٜکٛونِيَ دَݧِ شٜيَلْتِيَلْ، شٜيَلْتِيَلْ دَݧِ جَرُوبَبٜلْ، ");
INSERT INTO fuv_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","جَرُوبَبٜلْ دَݧِ اَبِيحُدُ، اَبِيحُدُ دَݧِ اٜلِيَاکِمْ، اٜلِيَاکِمْ دَݧِ اَاجٛرٛ، ");
INSERT INTO fuv_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","اَاجٛرٛ دَݧِ جَادٛکْ، جَادٛکْ دَݧِ اَاکِمْ، اَاکِمْ دَݧِ اَلِييُدُ، ");
INSERT INTO fuv_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","اَلِييُدُ دَݧِ اٜلٜيَاجَرْ، اٜلٜيَاجَرْ دَݧِ مَتَانَ، مَتَانَ دَݧِ يَاکُبُ، ");
INSERT INTO fuv_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","يَاکُبُ دَݧِ يُسُفُ غٛرْکٛ مَرْيَامَ، مَرْيَامَ دَݧِ يٜىٰسُ بِعٜتٜىٰطٛ اَلْمَسِيحُ؞ ");
INSERT INTO fuv_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","اٜ وٛودِ مَامَعٜنْ سَڤّٛ اٜ نَيٛ دَغَ جَامَنُ اِبْرَاهِمْ يَاکِ جَامَنُ دَوْدَ؞ اٜ وٛودِ مَامَعٜنْ سَڤّٛ اٜ نَيٛ دَغَ جَامَنُ دَوْدَ يَاکِ شَرٜلْ نغٜلْ يَحُودَنْکٛعٜنْ نجَارَا مَشُّنغَاکُ تٛ لٜيْدِ بَابِيلَ؞ اٜ وٛودِ مَامَعٜنْ سَڤّٛ اٜ نَيٛ دَغَ شَرٜلْ نغٜلْ يَحُودَنْکٛعٜنْ نجَارَا مَشُّنغَاکُ تٛ لٜيْدِ بَابِيلَ يَاکِ دَݧْنغٛلْ اَلْمَسِيحُ؞ ");
INSERT INTO fuv_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","رَا نٛ يٜىٰسُ اَلْمَسِيحُ دَݧِرَا؞ مَدُوجٛ مَاکٛ مَرْيَامَ وَادِ اَلْکَوَلْ تٜىٰغَلْ اٜ يُسُفُ؞ اَمَّا کٛ ٻٜ نغَطَ تٜىٰغَلْ، سٜيْ اٛ تَوْرَا رٜىٰدُ دَغَ تٛ رُوحُ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","ندٜ يُسُفُ اٛ نٜطّٛ اَادِلِيجٛ، اٛ يِطَا اٛ سٜمْتِنَمٛ اٜ نجَيْرِ؞ اٛ دَرْوِ اٛ يٛوفَمٛ اٜ سُوطٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","اَمَّا شَرٜلْ نغٜلْ اٛ ݧُمَتَ دٛوْ مَاجُمْ، مَلَاعِکَاجٛ جٛومِرَاوٛ وَنْغَنِمٛ ندٜرْ کٛيْطٛلْ، وِعِمٛ، ‏«‏يُسُفُ ٻِي دَوْدَ، تَاع حُلُ تٜعُکِ مَرْيَامَ، نغَمْ ٻِنْغٜلْ نغٜلْ اٛ سَاوِ دَغَ تٛ رُوحُ اَللَّه نغٜلْ پِوٛيِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","اٛ دَݧَيْ ٻِطّٛ غٛرْکٛ ندٜنْ اَ نٛدَّيْمٛ يٜىٰسُ، نغَمْ اٛ حِسْنَيْ يِمْٻٜ مَاکٛ دَغَ حَکّٜ مَٻّٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","فُو فِي طُعُمْ طُمْ وَطِ نغَمْ طُمْ حٜبِّنَ کٛ جٛومِرَاوٛ وِعِ دَغَ حٛنْدُکٛ اَنَّبِيجٛ، اٛ وِعِ، ");
INSERT INTO fuv_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","‏«‏رَطُّمْ، سُرْبَاجٛ مٛ اَنْدَا غٛرْکٛ دَݧَيْ ٻِطّٛ غٛرْکٛ، ندٜنْ طُمْ نٛدَّيْ اِنْدٜ مَاکٛ اِمَانُوٜلْ؞»‏ مَعَنَ اِمَانُوٜلْ وٛنِ، ‏«‏اَللَّه اٜ وٛنْدِ اٜ مٜىٰطٜنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","ندٜ يُسُفُ اُمِّي دَغَ طٜيْنغٛلْ نغٛلْ، سٜيْ وَطِ کٛ مَلَاعِکَاجٛ جٛومِرَاوٛ اٛنْ وِعِمٛ، اٛ تٜعِ مَرْيَامَ؞ ");
INSERT INTO fuv_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","اَمَّا اٛ اَنْدَامٛ نَاکِ غَطَ اٛ دَݧِ ٻِطّٛ مَاکٛ؞ ندٜنْ يُسُفُ نٛدِّ ٻِطّٛ اٛنْ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","غَطَ يٜىٰسُ دَݧَامَ اٜ غَرِيرِ بَيْتَلَامِ ندٜرْ لٜيْدِ يَحُودِيَ، ندٜرْ شَرٜلْ نغٜلْ حِرُدُسْ لَامٛتٛ، وٛٻّٜ اَنْدَنْٻٜ کٛودٜ دَغَ فُونَ ٻٜ نغَرِ اُرُشَلِيمَ، ");
INSERT INTO fuv_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","اٜ ٻٜ پَمَ، ‏«‏تٛيٜ اٛنْ طٛنْ دَݧَاطٛ لَامِيطٛ يَحُودَنْکٛعٜنْ؟ نغَمْ مِنْ نغِعِ حٛودٜرٜ مَاکٛ دَغَ فُونَ، مِنْ نغَرِي مِنْ مَوْنِنَمٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","ندٜ حِرُدُسْ لَامِيطٛ نَنِ نٛنْ، اٛ وَنِّ، کَنْکٛ اٜ يِمْٻٜ اُرُشَلِيمَ طُطْٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","سٜيْ اٛ نٛدِّ مَوْٻٜ اَرْدِيٻٜ دِينَ اٜ مٛودِٻّٜ اَتَّوْرَ، اٛ پَمِٻٜ، ‏«‏تٛيٜ اَلْمَسِيحُ دَݧٜتٜىٰ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","ٻٜ مبِعِمٛ، ‏«‏ندٜرْ غَرِيرِ بَيْتَلَامِ ندٜرْ لٜيْدِ يَحُودِيَ؞ نغَمْ رَا کٛ اَنَّبِيجٛ وِنْدِ، ");
INSERT INTO fuv_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‏‹‏اَمَّا، اَنْ، غَرِيٜلْ بَيْتَلَامِ غٛنْغٜلْ ندٜرْ لٜيْدِ يَحُودَ، اَنْ اَ غَرِيٜلْ غٛودُنغٜلْ تٜدُّنغَلْ ندٜرْ لٜيْدِ ندِنْ، نغَمْ دَغَ ندٜرْ مَاطَ غٛطّٛ لَامِيطٛ پِوٛيْتَ، کَنْکٛ وَرْتَتَ غَيْنَاکٛ يِمْٻٜ اَمْ اِسْرَاعِيلَنْکٛعٜنْ؞›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","سٜيْ حِرُدُسْ نٛدِّ ٻٜنْ طٛنْ اَنْدَنْٻٜ کٛودٜ اٜ سُوطٜ، اٛ پَمِٻٜ شَرٜلْ نغٜلْ ٻٜ نغِعِ حٛودٜرٜ ندٜنْ، ٻٜ مبِعِمٛکَ؞ ");
INSERT INTO fuv_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","سٜيْ اٛ لِلِٻٜ بَيْتَلَامِ، اٛ وِعِ، ‏«‏نجَحٜىٰ طَٻِّتٛنْ ٻِنْغٜلْ نغٜلْ بٛطُّمْ؞ تٛ اٛنْ نغِعِينغٜلْ، نغَرٛنْ مبِعٛنْيَمْکَ، نغَمْ مِنْ مَا مِ يَحَ مِ مَوْنِنَنغٜلْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT2_9‏","070_2_9‏","MAT","2","9‏","10","ندٜ ٻٜ نَنِ کٛ لَامِيطٛ اٛنْ وِعِ، سٜيْ ٻٜ نَنْغِ لَاوٛلْ؞ ندٜ ٻٜ نغِعِ حٛودٜرٜ ندٜنْ، ٻٜ نَنِ بٜلْطُمْ نَاع سٜطَّ؞ حٛودٜرٜ ندٜنْ اَرْدِيٻٜ نَاکِ ندٜ دَرِ دٛوْ تٛ ٻِنْغٜلْ نغٜلْ وٛنِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","ندٜ ٻٜ نَتِّ وُرٛ نغٛنْ، ٻٜ تَوِ ٻِنْغٜلْ نغٜلْ اٜ مَرْيَامَ مَدُوجٛ مَاغٜلْ؞ ٻٜ ندِشِّ ٻٜ مَوْنِنِنغٜلْ، ندٜنْ ٻٜ ڤِتِّ دٛݝْلٜ مَٻّٜ ٻٜ کٛکِّنغٜلْ شَاحُ جِينَارِ، اٜ اُرْدٜ وٜلْندٜ بِعٜتٜىٰندٜ فِرَنْکِسٜنْ، اٜ نٜبَّمْ اُرٛوجَمْ بِعٜتٜىٰطَمْ مُرْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","ندٜ اَللَّه حَطِيٻٜ ندٜرْ کٛيْطٛلْ تٛع ٻٜ شٛعّٛو تٛ حِرُدُسْ، سٜيْ ٻٜ تٛکِّ لَاوٛلْ فٜىٰرٜ ٻٜ شٛعِّ لٜيْدِ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","غَطَ اَنْدَنْٻٜ کٛودٜ ٻٜنْ ندِلِّ، سٜيْ مَلَاعِکَاجٛ جٛومِرَاوٛ وَنْغَنِ يُسُفُ ندٜرْ کٛيْطٛلْ، وِعِمٛ، ‏«‏اُمَّ کٛشَّا ٻِنْغٜلْ نغٜلْ اٜ مَدُوجٛ مَاغٜلْ ندٛغَّا نجَحَا لٜيْدِ مَسَرْ؞ نجٛوطٜىٰ تٛنْ نَا مِ وِعِيعٛنْ نغَرْتٛنْ، نغَمْ حِرُدُسْ اٜ يِطِ طَٻِّتَ ٻِنْغٜلْ نغٜلْ نغَمْ اٛ وَرَنغٜلْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","يُسُفُ اُمِّي حٛشِّ ٻِنْغٜلْ نغٜلْ اٜ مَدُوجٛ مَاغٜلْ شَکَ جٜمَّ، اٛ دِلِّ لٜيْدِ مَسَرْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","تٛنْ ٻٜ نجٛوطِ نَاکِ حِرُدُسْ مَايِ؞ نٛنْ وَطِي نغَمْ طُمْ حٜبِّنَ کٛ جٛومِرَاوٛ وِعِ دَغَ حٛنْدُکٛ اَنَّبِيجٛ مَاکٛ وِيکِ، ‏«‏دَغَ لٜيْدِ مَسَرْ مِ نٛدِّ ٻِطّٛ اَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","ندٜ حِرُدُسْ فَامِ اَنْدَنْٻٜ کٛودٜ ٻٜنْ پٛيْرِيمٛ، سٜيْ ٻٜرْندٜ مَاکٛ مٜتِّ نَاع سٜطَّ؞ اٛ وِعِ طُمْ وَرَ ٻِکّٛيْ ڤَمَرٛيْ فُو نغٛرٛيْ نغٛودُکٛيْ دُوٻِ طِطِ يَاکِ لٜيْ نغٛنْکٛيْ ندٜرْ غَرِيٜلْ بَيْتَلَامِ اٜ حَادٜ غَرِيٜلْ نغٜلْ؞ اٛ وَطُ نٛنْ نغَمْ اَنْدَنْٻٜ کٛودٜ ٻٜنْ مبِعِمٛ اَرَنْدٜ حٛودٜرٜ ندٜنْ وَنْغَنِيٻٜ دُوٻِ طِطِ پَٻِّيطِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","نٛنْ حٜبِّنِ کٛ اَللَّه وِعِ دَغَ حٛنْدُکٛ اَنَّبِ اِرْمِيَ وِيکِ، ");
INSERT INTO fuv_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","‏«‏طُمْ نَنِ حٛنٛنْدٜ ندٜرْ غَرِيرِ رَامَ، بٛجِّ نَوْطِ؞ طُمْ رَحِيلَ وٛيَنْتَ ٻِٻّٜ مَاکٛ، اٛ وَݧِ اٛ وَلْتِنَنٜىٰ ٻٜرْندٜ، نغَمْ ٻِٻّٜ مَاکٛ مَايِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","غَطَ حِرُدُسْ مَايِ، سٜيْ مَلَاعِکَاجٛ جٛومِرَاوٛ وَنْغَنِ يُسُفُ ندٜرْ کٛيْطٛلْ اٜ مَسَرْ، وِعِ، ");
INSERT INTO fuv_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","‏«‏اُمَّ کٛشَّا ٻِنْغٜلْ نغٜلْ اٜ مَدُوجٛ مَاغٜلْ شٛعّٛطَا لٜيْدِ اِسْرَاعِيلَ، نغَمْ ٻٜنْ طٛنْ طَٻُّتُٻٜ مبَرَ ٻِنْغٜلْ نغٜلْ ٻٜ مَايِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","سٜيْ يُسُفُ اُمِّي، حٛشِّ ٻِنْغٜلْ نغٜلْ اٜ مَدُوجٛ مَاغٜلْ، ٻٜ شٛعِّي لٜيْدِ اِسْرَاعِيلَ؞ ");
INSERT INTO fuv_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","اَمَّا ندٜ اٛ نَنِ اَرْکِلَيُسْ رٛنِي جٛوطٛرْغَلْ لَامُ ݧَاکٛ مُوطُمْ حِرُدُسْ اٜ مٛ لَامٛ لٜيْدِ يَحُودِيَ، سٜيْ اٛ حُلِ يَاکِ تٛنْ؞ اَمَّا ندٜ طُمْ وَغِّنِمٛ ندٜرْ کٛيْطٛلْ، سٜيْ اٛ سٛعِّ اٛ يَحِ لٜيْدِ غَلِيلِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","اٛ يَحِ اٛ جٛوطِي ندٜرْ وٛنْدِ غَرِيرِ بِعٜتٜىٰندِ نَجَرَتْ، نغَمْ طُمْ حٜبِّنَ کٛ اَللَّه وِعِ دَغَ کٛنْدُطٜ اَنَّبٛعٜنْ وِيکِ، ‏«‏طُمْ نٛدَّيْمٛ نَجَرَنْکٜىٰجٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","غَطَ دُوٻِ طُطِّ يَحَيَ غَطٛووٛ بَڤْتِسْمَ يَحِ ندٜرْ لَدّٜ يَحُودِيَ، اٜ مٛ وَعَجِنَ، ");
INSERT INTO fuv_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","اٜ مٛ وِعَ، ‏«‏تُوبٜىٰ، نغَمْ لَامُ اَللَّه ٻَدَکٜ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","اٛنْ طٛنْ کَنْکٛ وٛنِ مٛ اَنَّبِ اِشَايَ مٜتِ دٛوْ مَاکٛ، وِعِ، ‏«‏غٛطّٛ اٜ نٛدَّ ندٜرْ لَدّٜ، اٜ وِعَ، ‏‹‏مٛعِّنٜىٰ طَتَلْ جٛومِرَاوٛ، ڤٛرْتٜىٰ لَاوٛلْ نغَمْ غَرٛلْ مَاکٛ!‏›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","يَحَيَ اٜ ٻٛرْنِي کٛلْتٜ طٜ طُمْ وَطِرِ لٜىٰٻٜ نغٜىٰلٛوبَ، اٜ مٛ تَادِي تَادٛرْدٜ لَرَلْ؞ ݧَمْندُ مَاکٛ وٛنِ بَابٜىٰجِ اٜ نجُمْرِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","سٜيْ يِمْٻٜ طُطْٻٜ دَغَ غَرِيرِ اُرُشَلِيمَ اٜ لٜيْدِ يَحُودِيَ فُو اٜ غَرِيجٜ طٜ حَادٜ شَانغٛلْ اُرْدُنْ ٻٜ نغَطِ کَ يَاکِ تٛ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","اٜ ٻٜ مبِعَ فُو کٛ وٛوطَا طُمْ ٻٜ نغَطِ، اٜ مٛ وَطَنَٻٜ بَڤْتِسْمَ ندٜرْ شَانغٛلْ اُرْدُنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","اَمَّا ندٜ يَحَيَ يِعِ فَارِسَنْکٛعٜنْ اٜ سَادُسَنْکٛعٜنْ طُطْٻٜ نغَرِ نغَمْ اٛ وَطَنَٻٜ بَڤْتِسْمَ، اٛ وِعِٻٜ، ‏«‏اٛنٛنْ ٻِٻّٜ بٛولٜ!‏ مٛيٜ وِعِعٛنْ ندٛغّٛنْ بٛنٜ غَرَيْطُمْ؟ ");
INSERT INTO fuv_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","نغَطٜىٰ کٛ حٛلَّتَ اٛنْ اَلِ حَکّٜىٰجِ مٛوطٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","تٛع اٛنْ ݧُمُ اٛنْ مبِعَيْ ندٜرْ ٻٜرْطٜ مٛوطٛنْ، ‏‹‏مِنٛنْ، مِنْ ٻِٻّٜ اَنَّبِ اِبْرَاهِمْ؞›‏ نغَمْ اٜ مِ وِعَعٛنْ، اَللَّه وَاوَيْ اُمِّنَنْکِ اَنَّبِ اِبْرَاهِمْ ٻِٻّٜ دَغَ ندٜرْ کَاپٜ طٜعٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","کٛو جٛونِ فٜعِّرْدٜ پٜفْتَامَ نغَمْ فٜعَّ لٜطّٜ دَغَ طَطِ مَاجٜ؞ لٜکِّ فُو کِ رِمَتَا ٻِکّٛيْ مبٛطْکٛيْ، طُمْ فٜعَّيْکِ طُمْ فَطَّکِ ندٜرْ حِيتٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","مِنْ، اٜ مِ وَطِرَنَعٛنْ بَڤْتِسْمَ اٜ ندِيَمْ نغَمْ حٛلُّکِ اٛنْ تُوبِ؞ اَمَّا ٻُرْطٛيَمْ مَنْغُ اٜ وَرَ غَطَ اَمْ؞ مِ فٛتَايِ مِ جٛغٛو ڤَطٜ مَاکٛ؞ اٛ وَطِرَنَيْعٛنْ بَڤْتِسْمَ اٜ رُوحُ اَللَّه اٜ حِيتٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","اٜ مٛ جٛغِي بٜسِرْطُمْ غَوْرِ مَاکٛ نغَمْ سٜنْدُکِ غَوْرِ اٜ ݧَاندٜ؞ اٛ حَوْرِتَيْ غَوْرِ ندِنْ، اٛ وَطَندِ ندٜرْ رٜسِرْدٜ غَوْرِ مَاکٛ، اَمَّا اٛ وُلَ ݧَاندٜ ندٜنْ ندٜرْ حِيتٜ نغٜ وَاتَتَا؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","اٜ شَرٜلْ نغٜلْ يٜىٰسُ وَرٛيِ دَغَ لٜيْدِ غَلِيلِ؞ اٛ يَحِ شَانغٛلْ اُرْدُنْ تٛ يَحَيَ نغَمْ يَحَيَ وَطَنَمٛ بَڤْتِسْمَ؞ ");
INSERT INTO fuv_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","اَمَّا يَحَيَ يِطِي وَݧَ وَطَنْکِمٛ بَڤْتِسْمَ، اٜ وِعَ، ‏«‏اٜ حَانِ نغَطَنَايَمْ بَڤْتِسْمَ، اَمَّا اَ وَرِ تٛ اَمْ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","اَمَّا يٜىٰسُ نٛوتِي وِعِ، ‏«‏اَلُ طُمْ وَرْتَ نٛنْ جٛونِ، نغَمْ نٛنْ حَانِ کٜبِّنِرٜنْ کٛ اَللَّه يِطِ نغَطٜنْ؞»‏ ندٜنْ يَحَيَ جَٻِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","ندٜ طُمْ وَطَنِ يٜىٰسُ بَڤْتِسْمَ، اٜ مٛ وُرْتٛ ندٜرْ ندِيَمْ طَمْ، سٜيْ طٛنْ اٜ طٛنْ دٛوْ مَٻِّتِي اٛ يِعِ رُوحُ اَللَّه اٜ جِڤّٛيٛ دٛوْ مَاکٛ اٜ ٻَنْدُ بٛ فٛوندُ؞ ");
INSERT INTO fuv_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","سٜيْ حٛنٛنْدٜ پِوٛيِ دَغَ دٛوْ وِعِ، ‏«‏اٛعٛ وٛنِ ٻِطّٛ اَمْ مٛ نغِطُمِ، اٜ مِ نَنَ بٜلْطُمْ مَاکٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","سٜيْ رُوحُ اَللَّه يَارِ يٜىٰسُ ندٜرْ لَدّٜ نغَمْ شٜيْطَنْ فٛوندَمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","غَطَ يٜىٰسُ وَطِي بَلْطٜ 40 اٜ سُومٛو جٜمَّ اٜ ݧَلَوْمَ، وٜىٰلٛ نَنْغِمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","سٜيْ شٜيْطَنْ وَرِ، وِعِمٛ، ‏«‏تٛ اَنْ وٛنِ ٻِطّٛ اَللَّه، وِعُ طٜعٜ کَاپٜ نغَرْتَ بُرٛودِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","يٜىٰسُ نٛوتِي وِعِمٛ، ‏«‏اَايَارٜ وِعِي، ‏‹‏نَاع اٜ ݧَمْندُ تَنْ نٜطّٛ مَرٛرْتٛو، سٜيْ نِ اٜ کٛو ندٜيٜ وٛلْدٜ غَرٛيْندٜ دَغَ تٛ اَللَّه؞›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","سٜيْ شٜيْطَنْ يَارِمٛ اُرُشَلِيمَ غَرِيرِ شٜنِيندِ دَرْنِمٛ تٛنْ دٛوْ حٛورٜ وُرٛ شٜنِينغٛ، ");
INSERT INTO fuv_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","وِعِمٛ، ‏«‏تٛ اَنْ وٛنِ ٻِطّٛ اَللَّه، دِوُ دَغَ طٛعٛ نغَمْ اَايَارٜ وِعِي، ‏‹‏اَللَّه وِعَيْ مَلَاعِکَعٜنْ مُوطُمْ مبَلُّمَا بٛطُّمْ؞ ٻٜ تَٻّٜتٜ ندٜرْ جُوطٜ مَٻّٜ، نغَمْ تٛع نَوْنَا کٛيْطٜ مَاطَ دٛوْ حَيْرٜ؞›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","يٜىٰسُ وِعِمٛ، ‏«‏طٛنْمَا اَايَارٜ وِعِي، ‏‹‏تَاع فٛوندُ اَللَّه جٛومِرَاوٛ مَاطَ!‏›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","شٜيْطَنْ فُطِّتِ يَارِمٛ دٛوْ وٛنْدٜ حٛشّٜىٰرٜ تٛوْندٜ حٛلِّمٛ لٜيْطٜ دُونِيَارُ فُو اٜ جَوْدِ مَاجٜ، ");
INSERT INTO fuv_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","اٛ وِعِمٛ، ‏«‏طُعُمْ فُو مِ حٛکّٜتٜطُمْ تَا دِشَّکٜ اَ مَوْنِنِييَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","سٜيْ يٜىٰسُ وِعِمٛ، ‏«‏اُمَّ دَغَ طٛعٛ، اَنْ شٜيْطَنْ!‏ اَايَارٜ وِعِي، ‏‹‏مَوْنِنْ اَللَّه جٛومِرَاوٛ مَاطَ، کَنْکٛ تَنْ مَوْنِنْتَا؞›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","سٜيْ شٜيْطَنْ اَلِمٛ، مَلَاعِکَعٜنْ نغَرِ مبَلِّمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","تٛو، ندٜ يٜىٰسُ نَنِ طُمْ مَٻِّي يَحَيَ ندٜرْ سُودُ شُرَلْ، اٛ سٛعِّي لٜيْدِ غَلِيلِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","اٛ اَلِ غَرِيرِ نَجَرَتْ، اٛ يَحِ اٛ جٛوطِي غَرِيرِ کَفَرْنَحُمْ نغٛنْدِ حَادٜ مبٜىٰلَ ندٜرْ لٜيْدِ جَبَلُونَ اٜ نَفْتَالِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","اٛ وَطِي نٛنْ نغَمْ طُمْ حٜبِّنَ کٛ اَللَّه وِعِ دَغَ حٛنْدُکٛ اَنَّبِ اِشَايَ وِيکِ، ");
INSERT INTO fuv_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","‏«‏لٜيْدِ جَبَلُونَ اٜ لٜيْدِ نَفْتَالِ، اٛنٛنْ لٜيْطٜ غٛنْطٜ دٛوْ لَاوٛلْ حَادٜ مبٜىٰلَ، فٛنْغٛ شَانغٛلْ اُرْدُنْ، ندٜرْ لٜيْدِ غَلِيلِ ندِ يِمْٻٜ نَاع يَحُودَنْکٛعٜنْ!‏ ");
INSERT INTO fuv_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","يِمْٻٜ جٛوطِيٻٜ ندٜرْ ݧِوْرٜ ٻٜ نغِعِي جَيْنغٛلْ مَنْغٛلْ، ندٜنْ ٻٜنْ طٛنْ جٛوطِيٻٜ ندٜرْ لٜيْدِ ندِ طٛوْدِ مَيْدٜ، جَيْنغٛلْ وُرْتٛيَکٜ يٜيْنِ دٛوْ مَٻّٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","دَغَ شَرٜلْ نغٜلْ، يٜىٰسُ فُطِّ وَعَجِنْکِ، اٜ وِعَ، ‏«‏تُوبٜىٰ، نغَمْ لَامُ اَللَّه وَرِي حَادٜ مٛوطٛنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","يٜىٰسُ اٜ يَحَ حَادٜ مبٜىٰلَ غَلِيلِ، اٛ يِعِ سَکِرَاٻٜ طِطٛ، سِيمَنْ بِعٜتٜىٰطٛ بِيتُرُسْ اٜ مِݧِرَاوٛ مَاکٛ اَنْدِرَاوُسْ، اٜ ٻٜ نغَطَ نَنْغِرْطُمْ لِپِّ مَٻّٜ ندٜرْ ندِيَمْ، نغَمْ ٻٜ نَنْغٛوٻٜ لِپِّ؞ ");
INSERT INTO fuv_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","سٜيْ يٜىٰسُ وِعِٻٜ، ‏«‏تٛکّٜىٰيَمْ، مِ وَرْتِرَيْعٛنْ غَدَّيْٻٜ يِمْٻٜ تٛ اَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","طٛنْ اٜ طٛنْ ٻٜ اَلِ نَنْغِرْطُمْ لِپِّ مَٻّٜ ٻٜ تٛکِّمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","ندٜ اٛ ٻٜيْدِ يٜىٰسٛ سٜطَّ، سٜيْ اٛ يِعِ وٛٻّٜ سَکِرَاٻٜ طِطٛ، يَاکُبُ اٜ مِݧِرَاوٛ مُوطُمْ يَحَيَ ٻِٻّٜ جَبَدِ، اٜ ٻٜ ندٜرْ کٛمِوَلْ اٜ ݧَاکٛ مَٻّٜ جَبَدِ، اٜ ٻٜ مٛعِّنَ نَنْغِرْطُمْ لِپِّ مَٻّٜ، سٜيْ يٜىٰسُ نٛدِّٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","طٛنْ اٜ طٛنْ ٻٜ اَلِ کٛمِوَلْ نغَلْ اٜ ݧَاکٛ مَٻّٜ اٛنْ، ٻٜ تٛکِّ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","يٜىٰسُ يَحِ کٛو تٛيٜ ندٜرْ لٜيْدِ غَلِيلِ، اٜ مٛ اٜکِّتِنَ ندٜرْ شُوطِ دٛعَارٜ مَٻّٜ، اٜ مٛ وَعَجِنَ حَبَرُ بٜلْطُمْ دٛوْ لَامُ اَللَّه، ندٜنْ اٜ مٛ يَمْطِتِنَ کٛو اِرِ طُمٜ ݧَوُ اٜ شِيَ نجَمُ ندٜرْ يِمْٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","حَبَرُ مَاکٛ سَنْکِتِ کٛو تٛيٜ ندٜرْ لٜيْدِ سِيرِيَ؞ يِمْٻٜ نغَدَّنِمٛ فُو ݧَوْٻٜ، ڤِيدٛوٻٜ اٜ ݧَوُوجِ فٜىٰرٜ‑فٜىٰرٜ، اٜ ڤِيدٛوٻٜ اٜ نَوْطُمْ ٻَلِّ، اٜ غٛودُٻٜ غِنِّ، اٜ غٛودُٻٜ ڤَطّٜ، اٜ جَرَاٻٜ، اٛ يَمْطِتِنِٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","يِمْٻٜ طُطْٻٜ تٛکِّ يٜىٰسُ پِوٛيْٻٜ لٜيْدِ غَلِيلِ، اٜ لٜيْدِ دِکَڤٛلِسْ، اٜ اُرُشَلِيمَ، اٜ لٜيْدِ يَحُودِيَ، اٜ فٛنْغٛ شَانغٛلْ اُرْدُنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","ندٜ يٜىٰسُ يِعِ يِمْٻٜ طُطْٻٜ نغَرِ، سٜيْ اٛ پٜنْتِ پٛلْدٜ اٛ جٛوطِ، تٛکُّٻٜمٛ نغَرِ تٛ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","سٜيْ اٛ فُطِّ اٜکِّتِنْکِٻٜ، اٛ وِعِ، ");
INSERT INTO fuv_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","‏«‏ٻٜ بَرْکِطِنَاٻٜ غَطُٻٜ فُو کَمُّندٜ دٛوْ اَللَّه، نغَمْ کَمْٻٜ نجٜيِ لَامُ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","‏«‏ٻٜ بَرْکِطِنَاٻٜ يِمْٻٜ وٛيٛوٻٜ، نغَمْ طُمْ وَلْتِنَيْ ٻٜرْطٜ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","‏«‏ٻٜ بَرْکِطِنَاٻٜ لٜيْنٛوٻٜ کٛعٜ، نغَمْ کَمْٻٜ ندٛنَتَ دُونِيَارُ؞ ");
INSERT INTO fuv_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","‏«‏ٻٜ بَرْکِطِنَاٻٜ نَنٛوٻٜ وٜىٰلٛ اٜ طٛنْکَ وَطُکِ اَادِلَاکُ، نغَمْ ٻٜ کَرْنٜتٜىٰٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","‏«‏ٻٜ بَرْکِطِنَاٻٜ جُرْمِنَنٛوٻٜ يِمْٻٜ، نغَمْ کَمْٻٜ مَا طُمْ يُرْمِنَنَيْٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","‏«‏ٻٜ بَرْکِطِنَاٻٜ ٻٜ ٻٜرْطٜ لَٻْطٜ، نغَمْ ٻٜ نغِعَيْ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","‏«‏ٻٜ بَرْکِطِنَاٻٜ شِرْيٛوتِرٛوٻٜ يِمْٻٜ، نغَمْ طُمْ نٛدِّرَيْٻٜ ٻِٻّٜ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","‏«‏ٻٜ بَرْکِطِنَاٻٜ تٛرّٜتٜىٰٻٜ نغَمْ وَطُکِ اَادِلَاکُ، نغَمْ کَمْٻٜ نجٜيِ لَامُ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","‏«‏اٛنْ بَرْکِطِنَاٻٜ تٛ يِمْٻٜ کُطِيعٛنْ، تٛرِّيعٛنْ، ڤٜوَنِيعٛنْ مبِعِي حَالَاجِ کَلُّطِ فٜىٰرٜ‑فٜىٰرٜ دٛوْ مٛوطٛنْ نغَمْ اَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","نَنٜىٰ بٜلْطُمْ، مبٜلْمبٜلْتٜىٰ، نغَمْ بَرْکَ مٛوطٛنْ طُمْ طُطُّمْ اٜ دٛوْ، نغَمْ نٛنْ ٻٜ نغَطَنّٛو اَنَّبٛعٜنْ اَرَنْدٜعٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","‏«‏اٛنٛنْ نغٛنِ لَمْطَمْ دُونِيَارُ؞ اَمَّا تٛ بٜلْطُمْ مَاجَمْ اِتَّکٜ، کٛ وَرْتِرْتَ بٜلْطُمْ مَاجَمْ؟ وَلَا کٛ طَمْ نَفَتَ کَدِنْ، سٜيْ نِ طَمْ رُفٜىٰ يِمْٻٜ نجَاٻَطَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","‏«‏اٛنٛنْ نغٛنِ جَيْنغٛلْ دُونِيَارُ؞ غَرِيرِ نغٛنْدِ دٛوْ پٛلْدٜ ندِ سُوطَتَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","وَلَا غَطَنَيْطٛ فِتِلَارُ حِيتٜ حِڤَّ تُمُّدٜ دٛوْ مَيْرُ؞ سٜيْ نِ اٛ رٜسَندُ دٛوْ دَنْکِ، ندُ يٜيْنَنٛو کٛو مٛيٜ غٛنْطٛ ندٜرْ وُرٛ نغٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","نٛنْ اٛنٛنْ مَا، اَلٜىٰ جَيْنغٛلْ مٛوطٛنْ يٜيْنَنٛو يِمْٻٜ، نغَمْ ٻٜ نغِعَ کُوطٜ مٛوطٛنْ بٛطّٜ، ٻٜ مَوْنِنَ ݧَاکٛ مٛوطٛنْ مٛ دٛوْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","‏«‏تٛع اٛنْ کَمّٛ مِ وَرٛيِ نغَمْ مِ وَرْتِرَ اَتَّوْرَ کٛو دٜفْتٜ اَنَّبٛعٜنْ مٜىٰرٜ؞ مِ وَرٛيِ نَاع نغَمْ مِ وَرْتِرَطُمْ مٜىٰرٜ، اَمَّا نغَمْ مِ حٜبِّنَطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","اٜ مِ وِعَعٛنْ غٛونغَ، حَا دٛوْ اٜ لٜيْ رٜعَ، وَلَا بِنْدٜلْ غٛعٛ کٛو تٛٻّٜلْ غٛعٜلْ اِتّٜتٜىٰنغٜلْ ندٜرْ اَتَّوْرَ نَا کٛو نغٜلٜ بِنْدٜلْ ندٜرْ اَتَّوْرَ حٜبِّنَامَ؞ ");
INSERT INTO fuv_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","نغَمْ نٛنْ، کٛو مٛيٜ يٜوِ غٛعٛ ندٜرْ کٛو کٛ ٻُرِ فَمْطُکِ ندٜرْ کٛ اَللَّه وِعِ طُمْ وَطَ، ندٜنْ اٛ اٜکِّتِنِ وٛٻّٜ نغَطَ نٛنْ، طُمْ نٛدَّيْمٛ ٻُرْطٛ فَمْطُکِ ندٜرْ لَامُ اَللَّه؞ اَمَّا کٛو مٛيٜ وَطِ کٛ اَللَّه وِعِ طُمْ وَطَ، ندٜنْ اٛ اٜکِّتِنِ وٛٻّٜ نغَطَ نٛنْ، طُمْ نٛدَّيْمٛ مَوْطٛ ندٜرْ لَامُ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","اٜ مِ وِعَعٛنْ، تٛ اَادِلَاکُ مٛوطٛنْ ٻُرَايِ طُمْ مٛودِٻّٜ اَتَّوْرَ اٜ فَارِسَنْکٛعٜنْ، اٛنْ نَتَّتَا لَامُ اَللَّه کٛو سٜطَّ!‏ ");
INSERT INTO fuv_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","‏«‏اٛنْ نَنِ طُمْ وِعِ يِمْٻٜ ندٜنّٛ، ‏‹‏تَاع وَطُ وَرْحٛورٜ،›‏ ندٜنْ ‏‹‏کٛو مٛيٜ وَطِ وَرْحٛورٜ اٛ کِيتٜتٜىٰطٛ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","اَمَّا اٜ مِ وِعَعٛنْ، کٛو مٛيٜ مٛنَّنِ غٛطّٛ، اَللَّه حِيتٛتٛمٛ؞ کَدِنْ کٛو مٛيٜ حُطِ غٛطّٛ، اَرْدِيٻٜ حِيتٛتٛمٛ؞ ندٜنْ کٛو مٛيٜ وِعِ غٛطّٛ ‏‹‏اَ مٜىٰرٜىٰجٛ!‏›‏ اٜ مٛ دٛوْ لَاوٛلْ نَتُّکِ وُرٛ حِيتٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","نغَمْ نٛنْ، تَا وَرِي حٛکُّکِ دٛکَّلْ نغَمْ اَللَّه تٛ سَکِّرْدٜ، تَا سِفْتٛرِي بَنْدِرَاوٛ مَاطَ اٜ مٛنَّنْمَا، ");
INSERT INTO fuv_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","اَلُ دٛکَّلْ مَاطَ يٜىٰسٛ سَکِّرْدٜ ندٜنْ، اَرَنْدٜ يَحُ شِرْيٛوتِرَا اٜ بَنْدِرَاوٛ مَاطَ اٛنْ، ندٜنْ نغَرْتَا کٛکَّا دٛکَّلْ مَاطَ؞ ");
INSERT INTO fuv_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","‏«‏تٛ غٛطّٛ وُلّٛيَکٜمَ، شَرٜلْ نغٜلْ نغٛنْطٛنْ دٛوْ طَتَلْ يَاکِ يٜىٰسٛ لَامُ سِرْيٛوتِرْ اٜ مَاکٛ جَوْطُمْ؞ تٛ نَاع نٛنْ، اٛ يَارٜتٜ يٜىٰسٛ غَطٛووٛ کِيتَ، غَطٛووٛ کِيتَ وَطُمَا ندٜرْ جُوطٜ تَادِيٻٜ، طُمْ مَٻُّمَا ندٜرْ سُودُ شُرَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","اٜ مِ وِعَعٛنْ غٛونغَ، اَ وُرْتَتَاکٛ نَا اَ يٛٻِي فُو شٜىٰدٜ طٜ طُمْ تٛکَّتَمَ کٛو اَنِينِيٜلْ حٛرَتَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","‏«‏اٛنْ نَنِ طُمْ وِعِي، ‏‹‏تَاع وَطُ نجٜىٰنُ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","اَمَّا مِنْ، اٜ مِ وِعَعٛنْ کٛو مٛيٜ رَارِ دٜبّٛ دَرْطٜ سُونٛ يَادَکٜ وَادِي نجٜىٰنُ اٜ مَاکٛ ندٜرْ ٻٜرْندٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","تٛ حِتٜرٜ مَاطَ ندٜ ݧَامٛ اٜ وَطُمَا نغَطَا حَکّٜ، اِتُّندٜ، ڤَطَّاندٜ؞ طُمْ ٻُرَنِيمَ ندُلَّا جٛکّٛودٜ غٛعٛ ندٜرْ جٛکّٛوطٜ ٻَنْدُ مَاطَ اٜ دٛوْ طُمْ حُبِنَ فُو ٻَنْدُ مَاطَ ندٜرْ وُرٛ حِيتٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","تٛ جُنْغٛ مَاطَ ݧَامٛ اٜ وَطُمَا نغَطَا حَکّٜ، اِتُّنغٛ، ڤَطَّانغٛ؞ طُمْ ٻُرَنِيمَ ندُلَّا جٛکّٛودٜ غٛعٛ ندٜرْ جٛکّٛوطٜ ٻَنْدُ مَاطَ اٜ دٛوْ فُو ٻَنْدُ مَاطَ نَتَّ ندٜرْ وُرٛ حِيتٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","‏«‏کَدِنْ طُمْ وِعِ، ‏‹‏کٛو مٛيٜ يٛوفِ دٜبّٛ مُوطُمْ، سٜيْ حٛکَّمٛ طٜرٜوٛلْ وَرْکِ تٜىٰغَلْ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","اَمَّا مِنْ، اٜ مِ وِعَعٛنْ، کٛو مٛيٜ يٛوفِ دٜبّٛ مُوطُمْ تٛ نَاع نجٜىٰنُ اٛ وَطِ، تٛو، اٛ وَطِيمٛ وَطُکِ نجٜىٰنُ تٛ اٛ وَطِي وٛنْغَلْ تٜىٰغَلْ؞ ندٜنْ کٛو مٛيٜ تٜعِ جٛوفَاطٛ وَطِ نجٜىٰنُ؞ ");
INSERT INTO fuv_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","‏«‏اٛنْ نَنِي طُمْ وِعِي يِمْٻٜ ندٜنّٛ، ‏‹‏تَاع حُنَ دٛوْ فٜوْرٜ، اَمَّا حٜبِّنْ اَلْکَوَلْ نغَلْ نغَطَنْطَا جٛومِرَاوٛ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","اَمَّا اٜ مِ وِعَعٛنْ، تٛع اٛنْ کُنٛ کٛو سٜطَّ؞ تٛع اٛنْ کُنٛرٛ دٛوْ، نغَمْ تٛنْ وٛنِ تٛ اَللَّه جٛوطٛتٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ندٜنْ تٛع اٛنْ کُنٛرٛ دُونِيَارُ، نغَمْ طٛنْ وٛنِ تٛ اَللَّه رٜسَتَ کٛيْطٜ مُوطُمْ؞ ندٜنْ تٛع اٛنْ کُنٛرٛ اُرُشَلِيمَ نغَمْ کَيْرِ وٛنِ غَرِيرِ لَامِيطٛ مَوْطٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","تٛع اٛنْ کُنٛرٛ غَاسَ کٛعٜ مٛوطٛنْ، نغَمْ اٛنْ مبَاوَتَا وَرْتِرْکِ لَاسٛلْ غٛعٛتٛلْ دَنٜوٛلْ کٛو ٻَلٜوٛلْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","اَلْ ‏‹‏اٜىٰ›‏ مٛوطٛنْ وَرْتَ ‏‹‏اٜىٰ،›‏ ندٜنْ ‏‹‏اَاعَ›‏ مٛوطٛنْ وَرْتَ ‏‹‏اَاعَ؞›‏ فُو کٛ پَٻِّي طُعُمْ، دَغَ تٛ شٜيْطَنْ طُمْ پِوٛيِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","‏«‏اٛنْ نَنِ طُمْ وِعِي، ‏‹‏حِتٜرٜ نغَمْ حِتٜرٜ، ندٜنْ ݧِيندٜ نغَمْ ݧِيندٜ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","اَمَّا اٜ مِ وِعَعٛنْ، تٛ غٛطّٛ وَطَنِيعٛنْ غٛطُّمْ کَلُّطُمْ، تٛع اٛنْ نغَاتٛ؞ تٛ غٛطّٛ فِيِيمَ تٛ وٛلٛ ݧَامٛ، وَيْلِتَنْمٛ وٛعٛتٛ نغٛنْ مَا؞ ");
INSERT INTO fuv_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","تٛ غٛطّٛ يَارِيمَ يٜىٰسٛ لَامُ نغَمْ جَٻَنْمَا تٛغّٛورٜ، حٛکُّمٛ فُو اٜ شُدَّارِ مَاطَ؞ ");
INSERT INTO fuv_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","تٛ غٛطّٛ وَطِيمَ نغَطَا يَادُ مِلْ غٛعٛ، يَادُ اٜ مَاکٛ مِلْ طِطِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","تٛرِيطٛمَ غٛطُّمْ فُو، حٛکُّمٛ؞ تٛ غٛطّٛ پَمِيمَ ݧَمَاندٜ، تَاع حَطُمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","‏«‏اٛنْ نَنِي طُمْ وِعِي، ‏‹‏يِطُ بَنْدِرَاوٛ مَاطَ، وَݧُ غَݧٛ مَاطَ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","اَمَّا اٜ مِ وِعَعٛنْ، نغِطٜىٰ غَݧٛوٻٜ مٛوطٛنْ، نغَطَنٜىٰ تٛرّٛوٻٜعٛنْ دٛعَارٜ، ");
INSERT INTO fuv_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","نغَمْ نغَرْتٛنْ ٻِٻّٜ ݧَاکٛ مٛ دٛوْ؞ نغَمْ اٜ مٛ وَطَ نَانغٜ مَاکٛ يٜيْنٛو دٛوْ يِمْٻٜ کَلُّٻٜ اٜ يِمْٻٜ غَطٛوٻٜ کٛ وٛوطِ، ندٜنْ اٜ مٛ وَطَ ندِيَمْ تٛٻَ دٛوْ اَادِلِعٜنْ اٜ ٻٜ نغَلَا اَادِلَاکُ؞ ");
INSERT INTO fuv_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","تٛ يِطُٻٜعٛنْ تَنْ نغِطّٛنْ، طُمٜ بَرْکَ کٜٻٛتٛنْ؟ کٛو جَٻٛوٻٜ شٜىٰدٜ لٜيْدِ مَا اٜ نغِطِ يِطُٻٜٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","تٛ بَنْدِرَاٻٜ مٛوطٛنْ تَنْ کٛوْنٛتٛنْ، طُمٜ نغَطٛتٛنْ ٻُرْطُمْ طُمْ وٛٻّٜ نغَطَتَ؟ يِمْٻٜ نَاع يَحُودَنْکٛعٜنْ نَاع اٜ نغَطَ نٛنْ؟ ");
INSERT INTO fuv_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","نغَمْ نٛنْ، نغَرْتٜىٰ کٜىٰوُٻٜ نٛ ݧَاکٛ مٛوطٛنْ مٛ دٛوْ اٛ کٜوْطٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","‏«‏ڤَامٜىٰ تٛع نغَطٛنْ کُوطٜ اَادِلَاکُ مٛوطٛنْ يٜىٰسٛ يِمْٻٜ نغَمْ ٻٜ نغِعَ؞ نغَمْ تٛ اٛنْ نغَطِي نٛنْ، اٛنْ کٜٻَتَا مبَرْجَارِ تٛ ݧَاکٛ مٛوطٛنْ مٛ دٛوْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","‏«‏نغَمْ نٛنْ، تَا حٛکَّيْ ٻٜ نغَلَنَا شَاحُ، تَاع اَنْدِنْکَ کٛو مٛيٜ نٛ مُنَافُکِعٜنْ نغَطَتَ ندٜرْ شُوطِ دٛعَارٜ اٜ دٛوْ طَتَلْ نغَمْ يِمْٻٜ نغِعَ مَنْتَٻٜ؞ اٜ مِ وِعَعٛنْ غٛونغَ، ٻٜ نجَادَکٜ ٻٜ کٜٻِ مبَرْجَارِ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","اَمَّا تَا حٛکَّيْ مٛ وَلَنَا شَاحُ، تَاع جَٻُ جُنْغٛ نَنٛ مَاطَ اَنْدَ کٛ جُنْغٛ ݧَامٛ مَاطَ وَطَتَ؞ ");
INSERT INTO fuv_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","حٛکُّ شَاحُ مَاطَ اٜ سُوطٜ، ندٜنْ ݧَاکٛ مَاطَ مٛ دٛوْ اَنْدُطٛ کٛو طُمٜ غَطَاطُمْ اٜ سُوطٜ، اٛ حٛکّٜتٜ مبَرْجَارِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","‏«‏تٛ اٛنْ نغَطَيْ دٛعَارٜ، تٛع اٛنْ نغَطُ نٛ مُنَافُکِعٜنْ نغَطَتَ، نغَمْ اٜ ٻٜ نغِطِ وَطُکِ دٛعَارٜ اٜ ٻٜ ندَرِي ندٜرْ شُوطِ دٛعَارٜ اٜ دٛوْ تٛ طَتٜ کَوْرِ نغَمْ کٛو مٛيٜ يِعَٻٜ؞ اٜ مِ وِعَعٛنْ غٛونغَ، ٻٜ نجَادَکٜ ٻٜ کٜٻِي مبَرْجَارِ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","اَمَّا تَا وَطَيْ دٛعَارٜ، نَتُّ سُودُ مَاطَ مَٻَّا دَمُّغَلْ، تٛرٛطَا ݧَاکٛ مَاطَ مٛ دٛوْ مٛ يِعَتَاکٜ؞ ندٜنْ کَنْکٛ غِعٛووٛ کٛ وَطٜتٜىٰ اٜ سُوطٜ اٛ حٛکّٜتٜ مبَرْجَارِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","‏«‏تٛ اٛنْ نغَطَ دٛعَارٜ، تٛع اٛنْ مٜتُ حَالَاجِ مٜىٰرٜ نٛ يِمْٻٜ ٻٜ اَنْدَا اَللَّه نغَطَتَ؞ اٜ ٻٜ ݧُمَ اَلَّاجِ مَٻّٜ نَنَيْ کٛ ٻٜ مبِعِ نغَمْ ٻٜ کُوتِرِ بٛلِيطٜ طُطّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","تٛع اٛنْ نغَطُ نٛ ٻٜ نغَطَتَ نغَمْ ݧَاکٛ مٛوطٛنْ مٛ دٛوْ اٜ اَنْدِ کٛ نغِطّٛنْ کٛ تٛرٛوطٛنْمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","رَا نٛ نغَطِرْتٛنْ دٛعَارٜ، ‏‹‏يَا اَللَّه ݧَاکٛ اَمِنْ مٛ دٛوْ، اِنْدٜ مَاطَ شٜنِيندٜ مَوْنِنٜىٰ؞ ");
INSERT INTO fuv_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","لَامُ مَاطَ وَرَ، کٛ نغِطَّا وَطٜىٰ ندٜرْ دُونِيَارُ، نٛ طُمْ وَطِرْتٜىٰ اٜ دٛوْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","حٛکُّمِنْ کٛ مِنْ ݧَامَتَ حَنْدٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","يَافَنَمِنْ حَکّٜىٰجِ اَمِنْ نٛ مِنْ نجَافٛرَنْتٛو غَطَنْٻٜمِنْ کٛ وٛوطَا؞ ");
INSERT INTO fuv_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","تَاع اَلُ مِنْ نجَحَ تٛ مِنْ نغَطَتَ حَکّٜ، اَمَّا حِسْنُمِنْ دَغَ کَلُّطٛ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","‏«‏نغَمْ تٛ اٛنْ نجَافَنَکٜ غَطَنْٻٜعٛنْ کٛ وٛوطَا، ݧَاکٛ مٛوطٛنْ مٛ دٛوْ مَا يَافَنْتٛعٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","اَمَّا تٛ اٛنْ نجَافَنَاکِٻٜ، کَنْکٛ مَا اٛ يَافَنْتَاکٛعٛنْ حَکّٜ مٛوطٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","‏«‏تٛ اٛنْ شُومِي، تٛع اٛنْ مبٛنُّ غٜىٰشٜ مٛوطٛنْ نٛ مُنَافُکِعٜنْ نغَطَتَ، نغَمْ کَمْٻٜ اٜ ٻٜ مبٛنَّ غٜىٰشٜ مَٻّٜ نغَمْ ٻٜ کٛلَّ يِمْٻٜ اٜ ٻٜ شُومِي؞ اٜ مِ وِعَعٛنْ غٛونغَ، ٻٜ نجَادَکٜ ٻٜ کٜٻِي مبَرْجَارِ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","اَمَّا تَا سُومِي، سُلْمَ، مٛيْتَنَا حٛورٜ مَاطَ نٜبَّمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","تَا وَطِي نٛنْ، وَلَا اَنْدَيْطٛ اَ سُومِي، سٜيْ نِ ݧَاکٛ مَاطَ مٛ دٛوْ مٛ يِعَتَاکٜ؞ ندٜنْ کَنْکٛ غِعٛووٛ کٛ وَطٜتٜىٰ اٜ سُوطٜ، اٛ حٛکّٜتٜ مبَرْجَارِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","‏«‏تٛع اٛنْ ندٜسَنْ کٛعٜ مٛوطٛنْ جَوْدِ اٜ دُونِيَارُ تٛ مٛوپُ وٛنَّتَندِ، کٛو ندِ ݧٛلَ، کٛو تٛ وُيْٻٜ ڤُسَتَ، نَتَّ، نغُجَّندِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","اَمَّا ندٜسَنٜىٰ کٛعٜ مٛوطٛنْ جَوْدِ تٛنْ دٛوْ تٛ مٛوپُ وٛنَّتَاندِ، کٛو ندِ ݧٛلَ، تٛ وُيْٻٜ مبَاوَتَا ڤُسَ نَتَّ نغُجَّندِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","نغَمْ تٛ جَوْدِ مَاطَ وٛنِ، تٛنْ ٻٜرْندٜ مَاطَ مَا سٛعّٛتٛو؞ ");
INSERT INTO fuv_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","‏«‏غِتٜ نغٛنِ فِتِلَارُ ٻَنْدُ؞ تٛ غِتٜ مَاطَ اٜ نجَمْطِ، ٻَنْدُ مَاطَ فُو حٜىٰوَيْ جَيْنغٛلْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","اَمَّا تٛ غِتٜ مَاطَ نجَمْطَا، ٻَنْدُ مَاطَ فُو حٜىٰوَيْ ݧِوْرٜ؞ تٛ جَيْنغٛلْ غٛنْغٛلْ ندٜرْ ٻَنْدُ مَاطَ طُمْ ݧِوْرٜ، ݧِوْرٜ ندٜنْ وَرْتَيْ ٻَلٜىٰرٜ نَاع سٜطَّ؞ ");
INSERT INTO fuv_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","‏«‏وَلَا بَاوَيْطٛ جَغَّنَاکِ جٛومُ وُرٛعٜنْ طِطٛ؞ کٛو اٛ وَݧَ غٛعٛتٛ اٛ يِطَ غٛعٛتٛ، کٛو اٛ مَوْنِنَ غٛعٛتٛ اٛ يَوَنَ غٛعٛتٛ؞ نٛنْ اٛنٛنْ مَا، اٛنْ مبَاوَتَا جَغَّنَاکِ اَللَّه اٜ جَغَّنَاکِ جَوْدِ شَرٜلْ غٛعٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","‏«‏نغَمْ نٛنْ، اٜ مِ وِعَعٛنْ، تٛع اٛنْ نغَنُّ دٛوْ جٛنْدٜ مٛوطٛنْ، وَاتٛ دٛوْ کٛ ݧَامٛتٛنْ، کٛو کٛ نجَرٛتٛنْ، کٛو کٛ ٻٛرْنٛتٛوطٛنْ؞ نَاع يٛنْکِ ٻُرِي ݧَمْندُ؟ ندٜنْ نَاع ٻَنْدُ ٻُرِي کٛلْتٜ؟ ");
INSERT INTO fuv_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","ندَارٜىٰ شٛلِّ!‏ طِ اَاوَتَا، طِ ڤٜعَّتَا، طِ نغَلَا تٛ طِ ندٜسَتَ ݧَمْندُ؞ فُو اٜ نٛنْ ݧَاکٛ مٛوطٛنْ مٛ دٛوْ اٜ ݧَمْنَطِ؞ نَاع اٛنْ ٻُرِي شٛلِّ دَرَجَ؟ ");
INSERT INTO fuv_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","مٛيٜ ندٜرْ مٛوطٛنْ تٛ وَنِّي وَاوَتَ ٻٜيْدَنْکِ حٛورٜ مُوطُمْ شَرٜلْ سٜطَّ ندٜرْ بَلْطٜ مُوطُمْ؟ ");
INSERT INTO fuv_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","‏«‏تٛو، نغَمْ طُمٜ نغَنّٛتٛنْ دٛوْ کٛ ٻٛرْنٛتٛوطٛنْ؟ ندَارٜىٰ ڤِنْدِ لَدّٜ نٛ مَوْنِرْتَ، ندِ حُوَتَا، ندِ سَݧَتَا کٛلْتٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","فُو اٜ نٛنْ اٜ مِ وِعَعٛنْ، اَنَّبِ سُلٜيْمَانُ فُو اٜ رِسْکُ مُوطُمْ مٜىٰطَايِ مٛعِّتِنَاکِ بٛ ڤِنْدِ وٛعٛيْرِ ندِعِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","تٛ اَللَّه اٜ مٛعِّتِنِرَ ڤِنْدِ لَدّٜ نِحِ، حَنْدٜ اٜ ندِ طٛنْ، جَانغٛ ندِ وُلٜىٰ، حَکّٛ اٛنٛنْ، اٛ ٻُرَيْ نٛنْ ٻٛرْنُکِعٛنْ، اٛنٛنْ کٛولِيٻٜمٛ سٜطَّ!‏ ");
INSERT INTO fuv_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","‏«‏نغَمْ نٛنْ، تٛع اٛنْ نغَنُّ مبِعٛنْ، ‏‹‏کٛ ݧَامٜتٜنْ؟›‏، کٛو ‏‹‏کٛ نجَرٜتٜنْ؟›‏، کٛو ‏‹‏کٛ ٻٛرْنٛتٛوطٜنْ؟›‏ ");
INSERT INTO fuv_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","نغَمْ اِرِ طُمْ طٛنْ يِمْٻٜ ٻٜ اَنْدَا اَللَّه طَٻِّتَتَ؞ ݧَاکٛ مٛوطٛنْ مٛ دٛوْ اٜ اَنْدِ اٛنْ نغِطِ فُو فِي طُعُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","اَمَّا اَرَنْدٜ طَٻِّتٜىٰ لَامُ اَللَّه اٜ اَادِلَاکُ مَاکٛ، ندٜنْ طُمْ ٻٜيْدَنَيْعٛنْ فُو فِي طُعُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","نغَمْ نٛنْ، تٛع اٛنْ نغَنُّ اٜ جَانغٛ، نغَمْ جَانغٛ اٜ وٛودِ وَنَّارٜ مُوطُمْ؞ کٛو ندٜيٜ ݧَلْندٜ اٜ وٛودِ وَنَّارٜ مَيْرٜ کٜپَيْندٜندٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","‏«‏تٛع اٛنْ کِيتٛ وٛٻّٜ، نغَمْ تٛع طُمْ حِيتٛعٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","نغَمْ نٛنْ نٛ کِيتٛرِيطٛنْ وٛٻّٜ، اٛنٛنْ مَا نٛنْ طُمْ حِيتٛرَنْتٛوعٛنْ، ندٜنْ اٜ ڤٛوندِرْغٜلْ نغٜلْ ڤٛوندِرْطٛنْ، اٜ مَاغٜلْ طُمْ فٛوندِرَنْتَعٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","نغَمْ طُمٜ ندَارَتَا غٜىٰنٜلْ غٛنْغٜلْ ندٜرْ حِتٜرٜ بَنْدِرَاوٛ مَاطَ، اَمَّا اَ وَنَّايِ اٜ لٜغَّ وٛنْغَ ندٜرْ حِتٜرٜ مَاطَ؟ ");
INSERT INTO fuv_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","نٛ وَطَتَ مبِعَا بَنْدِرَاوٛ مَاطَ، ‏‹‏اَلْ مِ اِتَّنْمَا غٜىٰنٜلْ ندٜرْ حِتٜرٜ مَاطَ،›‏ ندٜنْ بٛو اٜ وٛودِ لٜغَّ ندٜرْ حِتٜرٜ مَاطَ؟ ");
INSERT INTO fuv_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","اَنْ مُنَافُکِيجٛ، اَرْتُ اِتُّکِ لٜغَّ وٛنْغَ ندٜرْ حِتٜرٜ مَاطَ، ندٜنْ نغِعَا بٛطُّمْ کٜٻَا نٛ اِتِّرَا غٜىٰنٜلْ غٛنْغٜلْ ندٜرْ حِتٜرٜ بَنْدِرَاوٛ مَاطَ؞ ");
INSERT INTO fuv_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","‏«‏تٛع اٛنْ کٛکُّ کُتِيجِ غٛطُّمْ شٜنِيطُمْ؞ تٛ اٛنْ نغَطِي نٛنْ، طِ نغَيْلِتٛتٛ، طِ شِشِّتَعٛنْ؞ تٛع اٛنْ کُبَنٛ اَلَدٜىٰجِ لُعُ‑لُعُ؞ تٛ اٛنْ نغَطِي نٛنْ، طِ نجَاٻَيْطُمْ تَنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","‏«‏تٛرٜىٰ، طُمْ حٛکَّيْعٛنْ؞ طَٻِّتٜىٰ، اٛنْ کٜٻَيْ؞ شِلْمِنٜىٰ، طُمْ مَٻِّتَنَيْعٛنْ دَمُّغَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","نغَمْ کٛو مٛيٜ تٛرِيطٛ طُمْ حٛکَّيْمٛ، طَٻُّتُطٛ بٛو حٜٻَيْ، ندٜنْ کٛو مٛيٜ شِلْمِنِيطٛ طُمْ مَٻِّتَنَيْمٛ دَمُّغَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","مٛيٜ ندٜرْ مٛوطٛنْ تٛ ٻِطّٛ مُوطُمْ تٛرَکٜمٛ بُرٛودِ، اٛ حٛکَّمٛ حَيْرٜ؟ ");
INSERT INTO fuv_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","کٛو بٛو تٛ اٛ تٛرَکٜمٛ لِنْغُ، اٛ حٛکَّمٛ مبٛودِ؟ ");
INSERT INTO fuv_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","تٛ اٛنٛنْ کَلُّٻٜ، اٛنْ اَنْدِ نٛ کٛکِّرْتٛنْ ٻِٻّٜ مٛوطٛنْ فِي بٛطُّمْ، حَکّٛ ݧَاکٛ مٛوطٛنْ مٛ دٛوْ!‏ اٛ ٻُرَيْ نٛنْ حٛکُّکِ تٛرِيٻٜمٛ فِي بٛطُّمْ!‏ ");
INSERT INTO fuv_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","‏«‏فُو کٛ نغِطّٛنْ وٛٻّٜ نغَطَنَعٛنْ، اٛنٛنْ مَا نغَطَنٜىٰٻٜ نٛنْ، نغَمْ کَنْجُمْ وٛنِ کٛ اَتَّوْرَ اٜ دٜفْتٜ اَنَّبٛعٜنْ مبِعِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","‏«‏نَتِّرٜىٰ دَمُّغَلْ ٻِطِّينغَلْ؞ نغَمْ دَمُّغَلْ جَارَيْنغَلْ حَلْکٜرٜ نغَلْ جَاجُنغَلْ، ندٜنْ نغَلْ سَطَا تٛکُّکِ، نَتِّرٛوٻٜنغَلْ اٜ طُوطِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","اَمَّا دَمُّغَلْ جَارَيْنغَلْ يٛنْکِ کِ رٜعَتَا نغَلْ ٻِطِّينغَلْ، طٛنْمَا طَتَلْ جَارَيْنغَلْ يٛنْکِ کِ رٜعَتَا اٜ نغَلْ سَطِ تٛکُّکِ، يِمْٻٜ سٜطَّ تٛکَّتَنغَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","‏«‏ڤَامَنٜىٰ اَنَّبٛعٜنْ فٜوْرٜ غَرَيْٻٜ تٛ مٛوطٛنْ ندٜرْ نَنْدِ بَالِ، اَمَّا ندٜرْ ٻٜرْطٜ مَٻّٜ اٜ ٻٜ نَنْدِ اٜ شَافَالِ کَلُّطِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","اٛنْ اَنْدِتِرَيْٻٜ کُوطٜ مَٻّٜ؞ طُمْ حٜٻَتَا ٻِکّٛيْ اِنَبٛوجٜ تٛ غِعٜحِ، کٛو اِبّٜ دَغَ تٛ کٛورَاجٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","نٛنْ مَا، کٛو کِيٜ لٜکِّ بٛطْکِ اٜ کِ رِمَ ٻِکّٛيْ مبٛطْکٛيْ؞ لٜکِّ کِ وٛوطَا بٛو اٜ کِ رِمَ ٻِکّٛيْ کٛيْ مبٛوطَا؞ ");
INSERT INTO fuv_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","لٜکِّ بٛطْکِ رِمَتَا ٻِکّٛيْ کٛيْ مبٛوطَا؞ نٛنْ مَا، لٜکِّ کِ وٛوطَا رِمَتَا ٻِکّٛيْ مبٛطْکٛيْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","فُو لٜکِّ کِ رِمَتَا ٻِکّٛيْ مبٛطْکٛيْ طُمْ فٜعَّيْکِ طُمْ فَطَّکِ ندٜرْ حِيتٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","نغَمْ نٛنْ، اٛنْ اَنْدِتِرَيْٻٜ کُوطٜ کَلُّطٜ طٜ ٻٜ نغَطَتَ؞ ");
INSERT INTO fuv_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","‏«‏نَاع فُو بِعَيْطٛيَمْ، ‏‹‏مٛودِبّٛ، مٛودِبّٛ،›‏ نَتَّتَ لَامُ اَللَّه، سٜيْ نِ غَطُطٛ کٛ ݧَاکٛ اَمْ مٛ دٛوْ يِطِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","اٜ ݧَلْندٜ جَانغٛ يِمْٻٜ طُطْٻٜ مبِعَيْيَمْ، ‏‹‏مٛودِبّٛ، مٛودِبّٛ!‏ نَاع مِنْ نغَعَجِنِي ندٜرْ اِنْدٜ مَاطَ؟ نَاع مِنْ مبُرْتِنِي غِنِّ ندٜرْ اِنْدٜ مَاطَ؟ نَاع مِنْ نغَطِي کَيْطِنِيطُمْ طُطُّمْ ندٜرْ اِنْدٜ مَاطَ؟›‏ ");
INSERT INTO fuv_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","اَمَّا مِ وِعَيْٻٜ، ‏‹‏مِ اَنْدَاعٛنْ؞ شٜنْدِرٜىٰ اٜ اَمْ، اٛنٛنْ کَلُّٻٜ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","‏«‏نغَمْ نٛنْ، نٜطّٛ فُو نَنْطٛ طٜعٜ بٛلِيطٜ اَمْ وَطِ کٛ مبِيمِ اٜ نَنْدِ اٜ نٜطّٛ غٛودُطٛ فَامُ مَحُطٛ وُرٛ مُوطُمْ دٛوْ تَفَارٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","ندٜ ندِيَمْ وَطِ، شَنْطِ کٜىٰوِ، حٜنْدُ اُمّٛيِي ڤِيِ وُرٛ نغٛنْ، اَمَّا نغٛ يَنَايِ نغَمْ نغٛ مَحَامَ دٛوْ تَفَارٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","‏«‏اَمَّا کٛو مٛيٜ نَنْطٛ بٛلِيطٜ اَمْ وَطَايِ کٛ مبِيمِ اٜ نَنْدِ اٜ نٜطّٛ مٛ وَلَا حَکِّيلٛ مَحُطٛ وُرٛ مُوطُمْ دٛوْ نجَارٜىٰندِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","ندٜ ندِيَمْ وَطِ، شَنْطِ کٜىٰوِ، حٜنْدُ اُمّٛيِي ڤِيِ وُرٛ نغٛنْ، سٜيْ نغٛ يَنِ نغٛ سَنْکِتِي نغٛ فُو؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","ندٜ يٜىٰسُ يٛتِّنِ کٛ وِعَتَ، يِمْٻٜ حَوْرُتُٻٜ کَيْطِنِ اٜ اٜکِّتِنٛلْ مَاکٛ، ");
INSERT INTO fuv_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","نغَمْ اٛ اٜکِّتِنِرَايِٻٜ نٛ مٛودِٻّٜ اَتَّوْرَ اٜکِّتِنِرْتَ، اَمَّا اٛ اٜکِّتِنِيٻٜ اٜ بَوْطٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","ندٜ يٜىٰسُ جِڤّٛيِي دَغَ دٛوْ حٛشّٜىٰرٜ ندٜنْ، يِمْٻٜ طُطْٻٜ تٛکِّمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","سٜيْ غٛطّٛ غٛودُطٛ ݧَوُ ݧَامٛوجُمْ لَرَلْ وَرِ دِشِّي يٜىٰسٛ مَاکٛ، وِعِ، ‏«‏مٛودِبّٛ، تَا جَٻِي، اَ وَاوَيْ نجَمْطِتِنَايَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","سٜيْ يٜىٰسُ فٛرْتِ جُنْغٛ مُوطُمْ، مٜىٰمِمٛ، وِعِ، ‏«‏مِ جَٻِي؞ يَمْطُتُ!‏»‏ طٛنْ اٜ طٛنْ ݧَوُ طُمْ اَلِمٛ، اٛ يَمْطِتِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","سٜيْ يٜىٰسُ وِعِمٛ، ‏«‏فَامُ، تَاع وِعُکَ کٛو مٛيٜ، اَمَّا يَحُ کٛلَّا حٛورٜ مَاطَ تٛ اَرْدِيطٛ دِينَ، ندٜنْ کٛکَّا شَکِّرِ نٛ مُوسَ وِعِ طُمْ وَطَ نغَمْ لَاٻٛلْ مَاطَ؞ وَطُ نٛنْ نغَمْ تَبِّتِنَنْکِ يِمْٻٜ اَ يَمْطِتِي؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","ندٜ يٜىٰسُ نَتِّ غَرِيرِ کَفَرْنَحُمْ، سٜيْ غٛطّٛ مَوْطٛ سٛوجِعٜنْ رٛومَ وَرِ تٛ مَاکٛ، اٜ تٛرٛومٛ، وِعِ، ");
INSERT INTO fuv_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","‏«‏مٛودِبّٛ، مَشُّطٛ اَمْ اٜ فُکِّي اٜ وُرٛ اٛ جَرَاطٛ، اٜ مٛ فِيدَ اٜ نَوْطُمْ کَلُّطُمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","يٜىٰسُ وِعِمٛ، ‏«‏مِ يَحَيْ مِ يَمْطِتِنَمٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","سٜيْ مَوْطٛ سٛوجِعٜنْ اٛنْ نٛوتِي وِعِ، ‏«‏مٛودِبّٛ، مِ فٛتَايِ نَتَّا وُرٛ اَمْ، اَمَّا مٜتُ تَنْ، مَشُّطٛ اَمْ يَمْطِتَيْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","نغَمْ مِنْ اٜ حٛورٜ اَمْ لٜيْ لَامُ وٛٻّٜ سٛوجِعٜنْ نغٛنْمِ، مِنْ مَا، اٜ مِ لَامٛو سٛوجِعٜنْ؞ تٛ مِ وِعِي اٛعٛ، ‏‹‏دِلُّ!‏›‏ اٛ دِلَّيْ؞ تٛ مِ وِعِي اٛنْ تٛنْ، ‏‹‏وٛرٛيْ!‏›‏ اٛ وَرَيْ؞ تٛ بٛو مِ وِعِي مَشُّطٛ اَمْ، ‏‹‏وَطُ طُعُمْ!‏›‏ اٛ وَطَيْطُمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","ندٜ يٜىٰسُ نَنِ نٛنْ، حَيْطِنِ، وِعِ کَوْرُتُٻٜ اٜ تٛکِّمٛ، ‏«‏اٜ مِ وِعَعٛنْ غٛونغَ، کٛو ندٜرْ اِسْرَاعِيلَ مِ حٜٻَايِ کٛولِيطٛيَمْ ٻٜرْندٜ غٛعٛ بٛ اٛعٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","اٜ مِ وِعَعٛنْ، يِمْٻٜ نَاع يَحُودَنْکٛعٜنْ طُطْٻٜ نغَرَيْ دَغَ فُونَ اٜ حِرْنَ ٻٜ نجٛوطٛو ٻٜ ݧَامَ ݧَمْندُ حُمْتٛ اٜ اَنَّبِ اِبْرَاهِمْ، اٜ اِشِيَاکُ، اٜ يَاکُبُ ندٜرْ لَامُ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","حَانُٻٜ نغَرْتَ يِمْٻٜ اَللَّه اَمَّا ٻٜ نغَݧِ، طُمْ فَطَّيْٻٜ ندٜرْ ݧِوْرٜ ٻَلٜىٰرٜ؞ طٛنْ ٻٜ مبٛيَتَ ٻٜ ݧٜرْپِندِرَ ݧِيپٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","سٜيْ يٜىٰسُ وِعِ مَوْطٛ سٛوجِعٜنْ رٛومَ اٛنْ، ‏«‏يَحُ!‏ نغَمْ اَ حٛولَکٜ اَللَّه، مَشُّطٛ مَاطَ يَمْطِتَيْ؞»‏ طٛنْ اٜ طٛنْ مَشُّطٛ سٛوجِيجٛ اٛنْ يَمْطِتِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","ندٜ يٜىٰسُ يَحِ وُرٛ بِيتُرُسْ يِعِ اٜسِرَاوٛ بِيتُرُسْ دٜبّٛ اٜ فُکِّي، جٛنْتٜ کَلُّطٜ اٜ تٛرَّمٛ، ");
INSERT INTO fuv_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","اٛ مٜىٰمِ جُنْغٛ مَاکٛ؞ جٛنْتٜ طٜنْ نجٛوفِ دٜبّٛ اٛنْ، اٛ اُمِّي، اٛ فُطِّ وَدَّنْکِمٛ ݧَمْندُ؞ ");
INSERT INTO fuv_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","ندٜ فُتُرٛ وَطِ، يِمْٻٜ نغَدَّنِ يٜىٰسُ غٛودُٻٜ غِنِّ طُطْٻٜ؞ اٛ مٜتَنِطِ وٛلْدٜ غٛعٛ طِ مبُرْتِي؞ اٛ يَمْطِتِنِ فُو ٻٜ نجَمْطَا؞ ");
INSERT INTO fuv_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","نٛنْ وَطِي نغَمْ طُمْ حٜبِّنَ کٛ اَللَّه وِعِ دَغَ حٛنْدُکٛ اَنَّبِ اِشَايَ، وِيکِ، ‏«‏اٛ اِتِّي ݧَوُوجِ مٜىٰطٜنْ، اٛ يَمْطِتِنِيعٜنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","ندٜ يٜىٰسُ يِعِ يِمْٻٜ طُطْٻٜ اٜ ڤِلِيمٛ، اٛ وِعِ تٛکُّٻٜمٛ، ‏«‏اٜنْ کُولُ فٛنْغٛ مبٜىٰلَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","سٜيْ غٛطّٛ مٛودِبّٛ اَتَّوْرَ وَرِ تٛ مَاکٛ، وِعِمٛ، ‏«‏مٛودِبّٛ، مِ تٛکّٜتٜ تٛ نجَحَتَا فُو؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","يٜىٰسُ وِعِمٛ، ‏«‏دِلَاجِ اٜ نغٛودِ غَيْطٜ، شٛلِّ اٜ نغٛودِ شَٻّٜ، اَمَّا ٻِي نٜطّٛ وَلَا تٛ فُکّٛتٛو؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","غٛطّٛ ندٜرْ تٛکُّٻٜمٛ وِعِمٛ، ‏«‏مٛودِبّٛ، اَلْ مِ يَحَ مِ اُوٛيَ ݧَاکٛ اَمْ تَوْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","اَمَّا يٜىٰسُ وِعِمٛ، ‏«‏تٛکَّمْ، اَلُ مَيْٻٜ اُوَ مَيْٻٜ مُعّٜنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","يٜىٰسُ نَتِّ کٛمِوَلْ، تٛکُّٻٜمٛ مَا تٛکِّمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","سٜيْ حٜنْدُ شٜمْبِنْدُ اُمّٛيِي دٛوْ مبٜىٰلَ نغَنْ، غٜىٰلٛوطِ ندِيَمْ ڤُطِّ ڤِيکِ کٛمِوَلْ نغَلْ، ندِيَمْ نَتِّ ندٜرْ مَاغَلْ حَا نَاکِ نغَلْ ٻَدِي حٜىٰوَ ندِيَمْ، اَمَّا يٜىٰسُ اٜ ندٜرْ مَاغَلْ اٜ طَانِي؞ ");
INSERT INTO fuv_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","سٜيْ تٛکُّٻٜمٛ ٻَدِّي ڤِنْدِنِمٛ، ٻٜ مبِعِ، ‏«‏مٛودِبّٛ، حِسْنُعٜنْ!‏ اٜنْ کَلْکَيْ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","سٜيْ اٛ وِعِٻٜ، ‏«‏نغَمْ طُمٜ کُلْتٛرْطٛنْ، اٛنٛنْ کٛولِيٻٜيَمْ سٜطَّ؟»‏ سٜيْ اٛ اُمِّي، اٛ حَٻَنِ حٜنْدُ ندُنْ اٜ غٜىٰلٛوطِ ندِيَمْ طِنْ؞ سٜيْ کٛو طُمٜ دٜعِّتِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","کٛو مٛيٜ حَيْطِنِ وِعِ، ‏«‏اٛعٛ طُمْ اِرِ مٛيٜ نٜطّٛ، حَا کٜنِ اٜ غٜىٰلٛوطِ ندِيَمْ اٜ نغَطَ کٛ اٛ وِعِ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","ندٜ يٜىٰسُ يٛتِّي فٛنْغٛ مبٜىٰلَ ندٜرْ لٜيْدِ غَارَسِنْکٛعٜنْ، سٜيْ وٛٻّٜ وٛرْٻٜ طِطٛ تَٻِّيمٛ، غٛودُٻٜ غِنِّ جٛوطٛتٛوٻٜ تٛ غٜنَالٜ؞ ٻٜ نغَرْتِي کٛ حُلْنِي نَاع سٜطَّ حَا مَا وَلَا بَاوَيْطٛ تٛکِّرَ لَاوٛلْ نغٛلْ طٛنْ!‏ ");
INSERT INTO fuv_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","طٛنْ اٜ طٛنْ ٻٜ نغُلِّ، اٜ ٻٜ مبِعَ، ‏«‏کٛ وَنُّمَا اٜ اَمِنْ، ٻِطّٛ اَللَّه؟ اَ وَرِي نغَمْ تٛرَّامِنْ کٛ شَرٜلْ وَطَ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","حَادٜ طٛنْ اٜ وٛودِ اٛرْندٜ اَلَدٜىٰجِ طُطِّ اٜ دُرَ؞ ");
INSERT INTO fuv_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","غِنِّ طِنْ تٛرِي يٜىٰسُ، مبِعِ، ‏«‏تَا رِيوِيمِنْ، اَلُمِنْ مِنْ نَتّٛيَ اٛرْندٜ اَلَدٜىٰجِ طِنْ نِي؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","سٜيْ اٛ وِعِطِ، ‏«‏ندِلّٜىٰ!‏»‏ سٜيْ طِ مبُرْتِي، طِ نَتّٛيِ اَلَدٜىٰجِ طِنْ؞ سٜيْ اٛرْندٜ ندٜنْ فُو ݧَارِ جِڤّٛيِي دَغَ دٛوْ پٛلْدٜ ندٜنْ، يَنِ ندٜرْ مبٜىٰلَ، ندِيَمْ ݧَامِطِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","وٛيْنَاٻٜ اَلَدٜىٰجِ طِنْ ندٛغِّ نجَحِ ندٜرْ غَرِيرِ مبِعٛيِ کٛو طُمٜ کٛ وَطِ؞ طٛنْمَا ٻٜ مبِعِ کٛ حٜٻِ غٛودُٻٜ غِنِّ طِنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","سٜيْ يِمْٻٜ غَرِيرِ ندِنْ طُطْٻٜ مبُرْتٛيِي تَٻِّي يٜىٰسُ؞ ندٜ ٻٜ نغِعِمٛ، ٻٜ تٛرِيمٛ اٛ اَلَنَٻٜ لٜيْدِ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","سٜيْ يٜىٰسُ نَتِّ کٛمِوَلْ حُولِ سٛعِّي غَرِيرِ مُوطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","سٜيْ وٛٻّٜ نغَدَّنِمٛ غٛطّٛ جَرَاطٛ دٛوْ دَاغٛ؞ ندٜ يٜىٰسُ يِعِ حٛولَارٜ مَٻّٜ، اٛ وِعِ جَرَاطٛ اٛنْ، ‏«‏تَاع وَنُّ، حِغٛ اَمْ، اَ يَافَنَامَ حَکّٜىٰجِ مَاطَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","ندٜ وٛٻّٜ مٛودِٻّٜ اَتَّوْرَ نَنِ نٛنْ، ٻٜ ڤُطِّ مٜتِتَاکِ حَکُّندٜ مَٻّٜ، اٜ ٻٜ مبِعَ، ‏«‏اٛعٛ نٜطّٛ اٛ فٛتِّدِنِ حٛورٜ مَاکٛ اٜ اَللَّه؞ کَعَ حَالَ کَ کَلُّکَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","اَمَّا يٜىٰسُ فَامِ کٛ وٛنِ ندٜرْ ٻٜرْطٜ مَٻّٜ، سٜيْ اٛ وِعِٻٜ، ‏«‏نغَمْ طُمٜ ݧُمٛتٛنْ ݧُمٛ کَلُّنغٛ ندٜرْ ٻٜرْطٜ مٛوطٛنْ؟ ");
INSERT INTO fuv_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","کٛ ٻُرِ حٛيْکِ، طُمْ وِعَ، ‏‹‏اَ يَافَنَامَ حَکّٜ مَاطَ،›‏ کٛو طُمْ وِعَ، ‏‹‏اُمَّ يَاٻُ؟›‏ ");
INSERT INTO fuv_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","اَمَّا اٜ مِ يِطِ اَنْدٛنْ ٻِي نٜطّٛ اٜ وٛودِ لَامُ ندٜرْ دُونِيَارُ يَافٛو حَکّٜ؞»‏ سٜيْ اٛ وِعِ جَرَاطٛ اٛنْ، ‏«‏اُمَّ کٛشَّا دَاغٛ مَاطَ، کٛوتَا وُرٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","سٜيْ جَرَاطٛ اٛنْ اُمِّي حٛوتِ وُرٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","ندٜ کَوْرُتُٻٜ طٛنْ نغِعِ نٛنْ، ٻٜ کُلِ، ٻٜ مَنْتِ اَللَّه، کٛکُّطٛ يِمْٻٜ اِرِ طٜعٜ بَوْطٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","يٜىٰسُ اٜ اَلَ وِغٜىٰرٜ ندٜنْ، سٜيْ يِعِ غٛطّٛ جَٻٛووٛ شٜىٰدٜ لٜيْدِ بِعٜتٜىٰطٛ مَاتِيُ اٜ جٛوطِي تٛ طُمْ جَٻَتَ شٜىٰدٜ لٜيْدِ؞ سٜيْ يٜىٰسُ وِعِمٛ، ‏«‏تٛکَّمْ؞»‏ سٜيْ مَاتِيُ اُمِّي، تٛکِّمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","غَطَ طٛنْ يٜىٰسُ يَحِ وُرٛ مَاتِيُ، جٛوطِي اٜ ݧَامَ حِرَاندٜ، سٜيْ جَٻٛوٻٜ شٜىٰدٜ لٜيْدِ اٜ غَطٛوٻٜ حَکّٜ نغَرِ نجٛوطِي تٛ مَاکٛ اٜ تٛکُّٻٜمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","ندٜ فَارِسَنْکٛعٜنْ نغِعِ نٛنْ، ٻٜ مبِعِ تٛکُّٻٜمٛ، ‏«‏نغَمْ طُمٜ مٛودِبّٛ مٛوطٛنْ ݧَمْدَتَ اٜ جَٻٛوٻٜ شٜىٰدٜ لٜيْدِ اٜ غَطٛوٻٜ حَکّٜ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","ندٜ يٜىٰسُ نَنِ نٛنْ، وِعِ، ‏«‏نَاع يَمْٻٜ نغِطِ ݧَوْندٛووٛ، سٜيْ نِ ݧَوْٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","نجَحٜىٰ، اٜکِّتٛوطٛنْ مَعَنَ اَايَارٜ بِيندٜ، ‏‹‏اٜ مِ يِطِ کٛلّٛنْ يُرْمٜىٰندٜ، نَاع سَکُّکِ شَکِّرِ؞›‏ مِ وَرٛيَايِ نغَمْ نٛدُّکِ ݧُمٛوٻٜ ٻٜ اَادِلِعٜنْ، اَمَّا مِ وَرٛيِ نغَمْ نٛدُّکِ اَنْدُٻٜ ٻٜ غَطٛوٻٜ حَکّٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","سٜيْ تٛکُّٻٜ يَحَيَ غَطٛووٛ بَڤْتِسْمَ نغَرِ تٛ يٜىٰسُ ٻٜ پَمِمٛ، ٻٜ مبِعِ، ‏«‏نغَمْ طُمٜ مِنٛنْ اٜ فَارِسَنْکٛعٜنْ اٜ مِنْ شُومٛو، اَمَّا تٛکُّٻٜمَ شُومَتَاکٛ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","سٜيْ يٜىٰسُ نٛوتِي وِعِٻٜ، ‏«‏اٜ يِيکِ مٛوطٛنْ حِغٛوٻٜ اَنْغٛوجٛ نَنَيْ بٜلْطُمْ شَرٜلْ نغٜلْ اَنْغٛوجٛ اٛنْ وٛنْدِ اٜ مَٻّٜ؟ اَمَّا شَرٜلْ اٜ وَرَ نغٜلْ طُمْ حٛشَّتَ اَنْغٛوجٛ اٛنْ دَغَ ندٜرْ مَٻّٜ، اٜ شَرٜلْ نغٜلْ ٻٜ شُومٛتٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","‏«‏وَلَا ݧٛوتَيْطٛ لٜفٜلْ کٜسٜلْ تٛ لِمْشٜرٜ کِيندٜ، نغَمْ لٜفٜلْ نغٜلْ نغٜلْ سٜىٰکَيْ لِمْشٜرٜ کِيندٜ ندٜنْ؞ نٛنْ وَطَيْ ندٜ ٻُرَ نٛ ندٜنّٛ سٜىٰکُکِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","نٛنْ مَا وَلَا غَطَيْطٛ ندِيَمْ اِنَبٛجَمْ کٜسَمْ ندٜرْ فَاندُ حِيندُ؞ تٛ اٛ وَطِي نٛنْ، طَمْ پُوفَيْ، طَمْ ڤُسَ فَاندُ ندُنْ، طَمْ رُفَ، فَاندُ ندُنْ بٛو لَلِّ وٛنْ طٛنْ؞ اَمَّا ندِيَمْ اِنَبٛجَمْ کٜسَمْ اٜ وَطٜىٰ ندٜرْ فَاندُ حٜيْرُ نغَمْ تٛع طُمْ دُلَّطَمْ طُمْ دُلَّ فَاندُ ندُنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","يٜىٰسُ اٜ ندٜرْ وِيکِٻٜ نٛنْ، سٜيْ غٛطّٛ اَرْدِيطٛ سُودُ دٛعَارٜ بِعٜتٜىٰطٛ جَايِرُسْ وَرِ؞ اٛ دِشِّي يٜىٰسٛ يٜىٰسُ، اٛ وِعِ، ‏«‏ٻِطّٛ اَمْ سُرْبَاجٛ مَايِي جٛونِ‑جٛونِ، اَمَّا وَرٛيْ نجَحٜنْ مٜىٰمَامٛ، اٛ اُمّٛتٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","يٜىٰسُ اُمّٛدِي اٜ تٛکُّٻٜمٛ ٻٜ ندِلِّدِ اٜ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","تٛو، اٜ وٛودِ غٛطّٛ دٜبّٛ طٛنْ غَطُطٛ دُوٻِ سَڤّٛ اٜ طِطِ اٜ تٛرّٛدٛو اٜ رُفُکِ پِيپَمْ اٛ پِوٛيِ غَطَ يٜىٰسُ، اٛ مٜىٰمِ شِلْمبِ تٛغّٛورٜ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","نغَمْ اٛ وِعِي ندٜرْ ٻٜرْندٜ مَاکٛ، ‏«‏کٛو تٛغّٛورٜ مَاکٛ تَنْ مٜىٰمُمِ، مِ يَمْطِتَيْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","ندٜ يٜىٰسُ وَيْلِتِي، يِعِمٛ، وِعِ، ‏«‏تَاع وَنُّ، بَنْدِرَاوٛ؞ حٛولَارٜ مَاطَ يَمْطِتِنِيمَ؞»‏ طٛنْ اٜ طٛنْ دٜبّٛ اٛنْ يَمْطِتِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","ندٜ يٜىٰسُ يٛتِّي وُرٛ جَايِرُسْ اٛنْ، يِعِ دُودٛوٻٜ دُودَالِ اٜ حَوْرُتُٻٜ اٜ ٻٜ نغُلَّ سٜمْبٜىٰ، ");
INSERT INTO fuv_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","سٜيْ اٛ وِعِٻٜ، ‏«‏اَلٜىٰ طٛعٛ، نغَمْ سُرْبَاجٛ اٛنْ مَايَايِ، اَمَّا اٛ طَانِ؞»‏ سٜيْ ٻٜ نجَلِمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","اَمَّا غَطَ اٛ وُرْتِنِي کٛو مٛيٜ يَاسِ، اٛ نَتِّ، اٛ جٛغِي جُنْغٛ سُرْبَاجٛ اٛنْ، سٜيْ سُرْبَاجٛ اٛنْ اُمِّي؞ ");
INSERT INTO fuv_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","حَبَرُ طُمْ بٛو سَنْکِتِي کٛو تٛيٜ ندٜرْ لٜيْدِ ندِنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","يٜىٰسُ اٜ اَلَ وِغٜىٰرٜ ندٜنْ، سٜيْ وٛٻّٜ وُمْٻٜ طِطٛ تٛکِّمٛ اٜ نٛدَّ سٜمْبٜىٰ، اٜ مبِعَ، ‏«‏ٻِطّٛ دَوْدَ، يُرْمِنَنْمِنْ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","ندٜ يٜىٰسُ نَتِّ وٛنْغٛ وُرٛ، سٜيْ وُمْٻٜ ٻٜنْ نغَرِ تٛ مَاکٛ، اٛ پَمِٻٜ، اٛ وِعِ، ‏«‏اٛنْ نجَٻِي مِ وَاوَيْ يَمْطِتِنْکِعٛنْ؟»‏ ٻٜ مبِعِمٛ، ‏«‏اٜىٰ، مٛودِبّٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","سٜيْ يٜىٰسُ مٜىٰمِ غِتٜ مَٻّٜ، وِعِ، ‏«‏نٛنْ نٛ کٛولٛرِيطٛنْيَمْ مِ يَمْطِتِنَيْعٛنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","طٛنْ اٜ طٛنْ غِتٜ مَٻّٜ مبُمْتِي؞ سٜيْ يٜىٰسُ وَغِّنِٻٜ، وِعِ، ‏«‏تٛع اٛنْ مبِعُکَ غٛطّٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","اَمَّا ٻٜ ندِلِّ ٻٜ شَنْکِتِ حَبَرُ مَاکٛ کٛو تٛيٜ ندٜرْ لٜيْدِ ندِنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","وُمْٻٜ ٻٜنْ اٜ ندِلَّ، سٜيْ طُمْ وَدَّنِ يٜىٰسُ غٛطّٛ غٛودُطٛ غِنّٛلْ غَرْتِرْنغٛلْمٛ ڤَحٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","غَطَ يٜىٰسُ وُرْتِنِي غِنّٛلْ نغٛلْ، نٜطّٛ اٛنْ فُطِّ مٜتُکِ؞ يِمْٻٜ طُطْٻٜ کَوْرُتُٻٜ طٛنْ کَيْطِنِ، مبِعِ، ‏«‏طُمْ مٜىٰطَايِ يِيکِ غٛطُّمْ اِرِ طُعُمْ ندٜرْ لٜيْدِ اِسْرَاعِيلَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","اَمَّا فَارِسَنْکٛعٜنْ مبِعِ، ‏«‏اٜ بَوْطٜ بَعَلْجَبُلْ لَامِيطٛ غِنِّ اٛ وُرْتِنِرْتَ غِنِّ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","يٜىٰسُ يَحِ غَرِيجٜ مَوْطٜ اٜ نغَرِحٛيْ ڤَمَرٛيْ فُو، اٜ اٜکِّتِنَ ندٜرْ شُوطِ دٛعَارٜ طِ يَحُودَنْکٛعٜنْ، اٜ وَعَجِنَ حَبَرُ بٜلْطُمْ دٛوْ لَامُ اَللَّه، اٜ مٛ يَمْطِتِنَ يِمْٻٜ غٛودُٻٜ کٛو اِرِ طُمٜ ݧَوُ، اٜ کٛو اِرِ طُمٜ شِيَ نجَمُ؞ ");
INSERT INTO fuv_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","ندٜ اٛ يِعِ يِمْٻٜ طُطْٻٜ کَوْرِتِي، سٜيْ اٛ نَنِ جُرُمْطُمْ مَٻّٜ، نغَمْ اٜ ٻٜ تٛرّٛو، وَلَا بَلَّيْطٛٻٜ، بٛ بَالِ طِ نغَلَا غَيْنَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","سٜيْ اٛ وِعِ تٛکُّٻٜمٛ، ‏«‏غٜسٜ ٻٜنْدُطٜ اٜ طُوطِ، اَمَّا حُوٛوٻٜ طُوطَا؞ ");
INSERT INTO fuv_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","تٛرٜىٰ جٛومُ غٜسٜ طٜنْ لِلٛيَ حُوٛوٻٜ ندٜرْ غٜسٜ مَاکٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","سٜيْ يٜىٰسُ نٛدِّ تٛکُّٻٜمٛ سَڤّٛ اٜ طِطٛ، اٛ حٛکِّٻٜ بَوْطٜ وُرْتِنْکِ غِنِّ اٜ يَمْطِتِنْکِ يِمْٻٜ دَغَ کٛو اِرِ طُمٜ ݧَوُ اٜ شِيَ نجَمُ؞ ");
INSERT INTO fuv_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","رَا اِنْطٜ لِلَاٻٜ سَڤّٛ اٜ طِطٛ ٻٜنْ:‏ اَرَنْدٜ اٜ وٛودِ سِيمَنْ بِعٜتٜىٰطٛ بِيتُرُسْ، اٜ مِݧِرَاوٛ مَاکٛ اَنْدِرَاوُسْ، اٜ يَاکُبُ ٻِي جَبَدِ، اٜ مِݧِرَاوٛ مَاکٛ يَحَيَ، ");
INSERT INTO fuv_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","اٜ فِلِبُسْ، اٜ بَتِلٛومِ، اٜ تٛومَ، اٜ مَاتِيُ جَٻٛووٛ شٜىٰدٜ لٜيْدِ، اٜ يَاکُبُ ٻِي حَلْفَ، اٜ تَادِيُسْ، ");
INSERT INTO fuv_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","اٜ سِيمَنْ کَنَنِيَنْکٜىٰجٛ، ندٜنْ اٜ يَحُودَ اِسْکَرِيٛوتِ، غَرْتُطٛ کٛکِّتِرْطٛ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","يٜىٰسُ لِلِ تٛکُّٻٜمٛ سَڤّٛ اٜ طِطٛ ٻٜنْ، اٛ وِعِٻٜ، ‏«‏تٛع اٛنْ نجَحُ تٛ يِمْٻٜ نَاع يَحُودَنْکٛعٜنْ؞ طٛنْمَا تٛع اٛنْ نَتُّ غَرِيجٜ سَمَارِيَنْکٛعٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","سٜيْ نِ نجَحٛنْ تٛ يِمْٻٜ اِسْرَاعِيلَ غَرْتُٻٜ بٛ بَالِ مَجُّطِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","نجَحٜىٰ، نغَعَجِنَنٛنْٻٜ، مبِعٛنْ، ‏‹‏لَامُ اَللَّه وَرِي حَادٜ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","نجَمْطِتِنٜىٰ ݧَوْٻٜ، اُمِّنٜىٰ مَيْٻٜ دَغَ مَيْدٜ، نجَمْطِتِنٜىٰ غٛودُٻٜ ݧَوُ ݧَامٛوجُمْ لَرَلْ، مبُرْتِنَنٜىٰ يِمْٻٜ غِنِّ؞ مِ حٛکِّيعٛنْ بَوْطٜ يَمْطِتِنْکِ يِمْٻٜ شَاحُ، نغَمْ نٛنْ نجَمْطِتِنٜىٰ يِمْٻٜ شَاحُ؞ ");
INSERT INTO fuv_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","تٛع اٛنْ نجٛغٛ شٜىٰدٜ جِينَارِ، کٛو شٜىٰدٜ اَجُرْفَارِ، کٛو شٜىٰدٜ نجَمْندِ مبٛطٜىٰرِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ندٜنْ تٛع اٛنْ نجَادُ اٜ جَکَارٜ، کٛو تٛغّٛوجٜ طِطِ، کٛو ڤَطٜ کٛيْطٜ طِطِ، کٛو سَوْرُ، نغَمْ کُوٛووٛ حَانِي حٛکّٜىٰ ݧَمْندُ؞ ");
INSERT INTO fuv_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","‏«‏فُو غَرِيرِ کٛو غَرِيٜلْ ڤَمَرٜلْ تٛ نَتُّطٛنْ، طَٻِّتٜىٰ نٜطّٛ مٛ نغِکُّ بٛطُّمْ، نجٛوطٛوطٛنْ وُرٛ مَاکٛ نَا اٛنْ اَلِي وِغٜىٰرٜ ندٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","تٛ اٛنْ نَتِّي وُرٛ نغٛنْ، شِلْمِنٜىٰ؞ ");
INSERT INTO fuv_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","تٛ يِمْٻٜ وُرٛ نغٛنْ نجَٻَّکٜعٛنْ بٛطُّمْ، اَلٜىٰ بَرْکَ مٛوطٛنْ جٛوطٛو دٛوْ مَٻّٜ؞ اَمَّا تٛ ٻٜ نجَٻَّاکِعٛنْ بٛطُّمْ، اَلٜىٰ بَرْکَ مٛوطٛنْ وَرْتَ تٛ مٛوطٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","فُو مٛ جَٻَّاکِعٛنْ، کٛو وَݧِ کٛ مبِيطٛنْ، تٛ اٛنْ مبُرْتَکٜ وُرٛ نغٛنْ کٛو غَرِيرِ ندِنْ، ڤِطّٜىٰ سٛلَّارٜ کٛيْطٜ مٛوطٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","اٜ مِ وِعَعٛنْ غٛونغَ، ݧَلْندٜ جَانغٛ اَللَّه ٻُرَيْ يُرْمِنَنْکِ يِمْٻٜ سٛدٛمْ اٜ غٛمٛورَ دٛوْ يِمْٻٜ غَرِيرِ ندِنْ طٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","‏«‏رَطُّمْ، اٜ مِ لِلَعٛنْ بٛنٛ مبَالٛيْ شَکَ شَافَالِ؞ نغَمْ نٛنْ، ڤَامَنٜىٰ کٛعٜ مٛوطٛنْ نٛ بٛولٜ نغَطَتَ، طٛنْمَا نغَرْتٜىٰ ٻٜ کَلَّا بٛ ڤٛولِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","ڤَامَنٜىٰ يِمْٻٜ، نغَمْ ٻٜ نجَارَيْعٛنْ يٜىٰسٛ مَوْٻٜ، ٻٜ ڤِيَعٛنْ ندٜرْ شُوطِ دٛعَارٜ مَٻّٜ، ");
INSERT INTO fuv_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","ٻٜ نجَارَعٛنْ يٜىٰسٛ مَوْٻٜ لٜيْدِ اٜ لَامِيٻٜ، نغَمْ اٛنْ تٛکُّٻٜيَمْ اٛنْ کٛکَّيْٻٜ حَبَرُ اَمْ؞ نٛنْ وَرْتَيْ لَاوٛلْ نٛ کٛکِّرْتٛنْٻٜ حَبَرُ اَمْ کَمْٻٜ اٜ يِمْٻٜ نَاع يَحُودَنْکٛعٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","فُو شَرٜلْ نغٜلْ طُمْ نَنْغِعٛنْ طُمْ يَارِعٛنْ يٜىٰسٛ لَامُ، تٛع اٛنْ نغَنُّ دٛوْ نٛ مٜتِرْتٛنْ، کٛو کٛ مبِعٛتٛنْ، نغَمْ ندٜرْ شَرٜلْ نغٜلْ طُمْ وِعَيْعٛنْ کٛ مبِعٛتٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","نغَمْ نَاع طُمْ اٛنٛنْ مٜتَتَ، اَمَّا طُمْ رُوحُ ݧَاکٛ مٛوطٛنْ مٛ دٛوْ مٜتَتَ ندٜرْ کٛنْدُطٜ مٛوطٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","‏«‏نٜطّٛ حٛکِّتِرَيْ سَکِرَاوٛ مُوطُمْ طُمْ وَرَمٛ، ݧَاکٛ مَا حٛکِّتِرَيْ ٻِطّٛ مُوطُمْ؞ ٻِٻّٜ اُمَّنْتٛ دَݧٛوٻٜ مَٻّٜ، ٻٜ نغَطَ طُمْ وَرَٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","کٛو مٛيٜ وَݧَيْعٛنْ نغَمْ اٛنْ تٛکُّٻٜيَمْ؞ اَمَّا مُݧُطٛ حَا رٜعِرْدٜ حِسَيْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","تٛ يِمْٻٜ تٛرِّيعٛنْ ندٜرْ وٛنْدِ غَرِيرِ، ندٛغّٜىٰ نجَحٛنْ وٛنْدِ غَرِيرِ؞ اٜ مِ وِعَعٛنْ غٛونغَ، کٛ نجَحِدٛنْ غَرِيجٜ اِسْرَاعِيلَ فُو، ٻِي نٜطّٛ وَرْتٛيَيْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","‏«‏اٜکِّتٛتٛوطٛ ٻُرَتَا مٛودِبّٛ مُوطُمْ، مَشُّطٛ بٛو ٻُرَتَا جٜيْطٛمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","اٜکِّتٛتٛوطٛ نَنَيْ بٜلْطُمْ تٛ وَرْتِي بٛ مٛودِبّٛ مُوطُمْ، مَشُّطٛ مَا نَنَيْ بٜلْطُمْ تٛ وَرْتِي بٛ جٜيْطٛمٛ؞ تٛ ٻٜ نٛدِّرِي جٛومُ وُرٛ اٛنْ بَعَلْجَبُلْ لَامِيطٛ غِنِّ، ٻٜ ٻُرَيْ وِيکِ کٛ حَلِّ دٛوْ ٻٜ وُرٛ نغٛنْ!‏ ");
INSERT INTO fuv_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","‏«‏نغَمْ نٛنْ، تٛع اٛنْ کُلُ يِمْٻٜ، نغَمْ وَلَا غٛطُّمْ اٛمْبَاطُمْ طُمْ اٛمْتَتَاکٜ، نٛنْ مَا وَلَا شُوطِيطُمْ طُمْ سُورِتَتَاکٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","کٛ مبِيمِعٛنْ ندٜرْ ݧِوْرٜ، مبِعٜىٰکَ ݧَلَوْمَ، نٛنْ مَا کٛ نَنْطٛنْ تٛ اَمْ اٜ سُوطٜ، مبِعٜىٰکَ اٜ نجَيْرِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","تٛع اٛنْ کُلُ وَرٛوٻٜ ٻَنْدُ نٜطّٛ، اَمَّا ٻٜ مبَاوَتَا وَرْکِ يٛنْکِ مَاکٛ؞ سٜيْ نِ کُلٛنْ اٛنْ طٛنْ بَاوَيْطٛ حَلْکَ ٻَنْدُ اٜ يٛنْکِ فُو ندٜرْ وُرٛ حِيتٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","نَاع شٛلٛيْ طِطٛيْ اٜ شٛورٜىٰ يَمْندٜ غٛعٛ؟ فُو اٜ نٛنْ وَلَا کٛو غٛعٛتٜلْ مَاکٛيْ بَاتَيْنغٜلْ نَا اٜ يِدّٜ ݧَاکٛ مٛوطٛنْ مٛ دٛوْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","کٛو غَاسَ کٛعٜ مٛوطٛنْ مَا فُو کَ لِمَامَ؞ ");
INSERT INTO fuv_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","نغَمْ نٛنْ، تٛع اٛنْ کُلُ، اٛنْ ٻُرِي شٛلٛيْ طُطْکٛيْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","‏«‏کٛو مٛيٜ جَٻُطٛيَمْ يٜىٰسٛ يِمْٻٜ، مِ جَٻَيْمٛ يٜىٰسٛ ݧَاکٛ اَمْ مٛ دٛوْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","اَمَّا فُو غَݧُطٛيَمْ يٜىٰسٛ يِمْٻٜ، مِنْ مَا مِ وَݧَيْمٛ يٜىٰسٛ ݧَاکٛ اَمْ مٛ دٛوْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","‏«‏تٛع اٛنْ کَمّٛ مِ وَرٛيِي وَدَّنْکِ دُونِيَارُ جٛنْدٜ جَمْ؞ مِ وَرٛيَايِ نغَمْ وَدُّکِ جٛنْدٜ جَمْ، سٜيْ نِ حَوْرٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","مِ وَرِي نغَمْ مِ وَدَّ سٜنْدِرْکِ حَکُّندٜ ٻِطّٛ اٜ ݧَاکٛ مُوطُمْ، ٻِطّٛ دٜبّٛ اٜ مَدُوجٛ مُوطُمْ، دٜبّٛ بٛو اٜ اٜسِرَاوٛ مُوطُمْ دٜبّٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","ٻٜ نجٛوطٛدِطَا وُرٛ غٛعٛ ٻٜ نغَرْتَيْ وَݧْوَݧْٻٜ مَاطَ؞ ");
INSERT INTO fuv_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","‏«‏کٛو مٛيٜ ٻُرِ يِطُکِ ݧَاکٛ مُوطُمْ کٛو مَدُوجٛ مُوطُمْ دٛوْ اَمْ، اٛ فٛتَايِ وَرْتُکِ تٛکُّطٛيَمْ؞ طٛنْمَا فُو ٻُرْطٛ يِطُکِ ٻِطّٛ مُوطُمْ دٛوْ اَمْ، اٛ فٛتَايِ وَرْتُکِ تٛکُّطٛيَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","ندٜنْ فُو مٛ حٛشَّايِ غَافَانغَلْ مُوطُمْ تٛکِّيَمْ، اٛ فٛتَايِ وَرْتُکِ تٛکُّطٛيَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","فُو غِطّٛ حِسْنُکِ يٛنْکِ مُوطُمْ، اٛ دُلَّيْکِ؞ اَمَّا فُو دُلُّطٛ يٛنْکِ مُوطُمْ نغَمْ اَمْ، اٛ حِسْنَيْکِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","‏«‏فُو جَٻُطٛعٛنْ جَٻِييَمْ، طٛنْمَا فُو جَٻُطٛيَم جَٻِي اٛنْ طٛنْ لِلٛيْطٛيَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","کٛو مٛيٜ جَٻُطٛ اَنَّبِيجٛ نغَمْ اٛ اَنَّبِيجٛ، اٛ حٜٻَيْ مبَرْجَارِ اَنَّبِيجٛ؞ ندٜنْ کٛو مٛيٜ جَٻُطٛ اَادِلِيجٛ نغَمْ اٛ اَادِلِيجٛ، اٛ حٜٻَيْ مبَرْجَارِ اَادِلِيجٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","کٛو مٛيٜ کٛکُّطٛ ٻُرْطٛ فَمْطُکِ ندٜرْ تٛکُّٻٜيَمْ ٻٜعٜ کٛو ندِيَمْ ڤٜوْطَمْ ندٜرْ جَرْدُغٜلْ نغَمْ اٛ تٛکُّطٛيَمْ، اٜ مِ وِعَعٛنْ غٛونغَ، اٛ دُلَّتَا حٜٻُکِ مبَرْجَارِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","ندٜ يٜىٰسُ يٛتِّنِ کٛ وِعَتَ تٛکُّٻٜمٛ سَڤّٛ اٜ طِطٛ، سٜيْ اٛ اُمِّي دَغَ طٛنْ، اٛ دِلِّ، اٜ مٛ اٜکِّتِنَ، اٜ مٛ وَعَجِنَ ندٜرْ غَرِيجٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","اٜ شَرٜلْ نغٜلْ، يَحَيَ غَطٛووٛ بَڤْتِسْمَ سُرَامَ ندٜرْ سُودُ شُرَلْ؞ ندٜ اٛ نَنِ حَبَرُ کٛ اَلْمَسِيحُ وَطَتَ، سٜيْ اٛ نٛدِّ وٛٻّٜ ندٜرْ تٛکُّٻٜمٛ اٛ لِلِٻٜ تٛ مَاکٛ ");
INSERT INTO fuv_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","نغَمْ ٻٜ پَمَمٛ، ٻٜ مبِعَ، ‏«‏اَنْ وٛنِ اَلْمَسِيحُ مٛ طُمْ وِعِ وَرَيْ، کٛو مِنْ کٜطٛو غٛطّٛ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","يٜىٰسُ نٛوتِي، وِعِٻٜ، ‏«‏نجَحٜىٰ، مبِعٛنْ يَحَيَ کٛ نَنُطٛنْ اٜ کٛ نغِيطٛنْ:‏ ");
INSERT INTO fuv_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","وُمْٻٜ اٜ مبُمْتَ، جَرَاٻٜ اٜ نجَاٻَ، غٛودُٻٜ ݧَوُ ݧَامٛوجُمْ لَرَلْ اٜ نجَمْطِتِنٜىٰ، ڤَحُٻٜ اٜ نَنَ، مَيْٻٜ اٜ اُمِّنٜىٰ، ٻٜ نغَلَنَا اٜ نغَعَجِنَنٜىٰ حَبَرُ بٜلْطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","اٛ بَرْکِطِنَاطٛ نٜطّٛ مٛ اَلَايِ حٛولَاکِيَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","غَطَ لِلَاٻٜ ٻٜنْ ندِلِّ، سٜيْ يٜىٰسُ فُطِّ مٜتَنْکِ يِمْٻٜ دٛوْ يَحَيَ، اٛ وِعِٻٜ، ‏«‏طُمٜ نجَاطٛنْ رَارٛيْکِ ندٜرْ لَدّٜ؟ کُطٛلْ نغٛلْ حٜنْدُ دِمْبَتَ ندَارٛيْطٛنْ؟ ");
INSERT INTO fuv_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","تٛ نَاع نٛنْ، طُمٜ نجَاطٛنْ رَارٛيْکِ؟ نٜطّٛ ٻٛرْنِيطٛ لِمْشٜ بٛطّٜ؟ نَاع نٛنْ، نغَمْ ٻٛرْنٛتٛوٻٜ لِمْشٜ بٛطّٜ اٜ لَامٛرْدٜ ٻٜ نغٛنِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","تٛو، طُمٜ نجَاطٛنْ رَارٛيْکِ؟ اَنَّبِيجٛ؟ اٜ مِ وِعَعٛنْ غٛونغَ، اٛ ٻُرِي اَنَّبِيجٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","کَنْکٛ وٛنِ مٛ اَللَّه وِعِ ندٜرْ اَايَارٜ، ‏‹‏رَطُّمْ، مِ لِلٛيَيْ لِلَاطٛ اَمْ اٛ اَرْدٛو يٜىٰسٛ مَاطَ اٛ مٛعِّنَنْمَا لَاوٛلْ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","اٜ مِ وِعَعٛنْ غٛونغَ، ندٜرْ ٻٜ رٜوْٻٜ ندَݧِ فُو وَلَا ٻُرْطٛ يَحَيَ غَطٛووٛ بَڤْتِسْمَ مَنْغُ؞ فُو اٜ نٛنْ، ٻُرْطٛ فَمْطُکِ ندٜرْ لَامُ اَللَّه ٻُرِيمٛ مَنْغُ؞ ");
INSERT INTO fuv_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","دَغَ جَامَنُ يَحَيَ غَطٛووٛ بَڤْتِسْمَ حَا وَدُّکِ حَنْدٜ، لَامُ اَللَّه اٜ تٛرّٜىٰ؞ تٛرّٛوٻٜ لَامُ طُمْ اٜ نغِطِ تٜىٰتَطُمْ اٜ سٜمْبٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","نغَمْ دٜفْتٜ اَنَّبٛعٜنْ فُو اٜ اَتَّوْرَ مٜتِي دٛوْ لَامُ طُمْ نَا يَحَيَ غَطٛووٛ بَڤْتِسْمَ وَرِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","تٛ اٛنْ نجَٻَيْ کٛ ٻٜ مبِعِ، يَحَيَ وٛنِ اِلِيَ مٛ طُمْ وِعِ وَرَيْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","غٛودُطٛ نٛڤِّ نَنُکِ فُو نَنَ؞ ");
INSERT INTO fuv_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","‏«‏کٛ نَنْدِنَيْمِ يِمْٻٜ جَامَنُ طُعُمْ؟ اٜ ٻٜ نَنْدِ اٜ سُکَحٛيْ نجٛوطِيکٛيْ ندٜرْ لُومٛ اٜ نٛدِّندِرَ، اٜ مبِعَ، ");
INSERT INTO fuv_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‏‹‏مِنْ ندُودَنِيعٛنْ دُودَاندُ، اَمَّا اٛنْ نغَمَايِ؞ مِنْ مبٛيِ بٛ غٛطّٛ مَايِ، اَمَّا اٛنْ مبٛيَايِ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","نغَمْ يَحَيَ غَطٛووٛ بَڤْتِسْمَ وَرِي ݧَامَتَا ݧَمْندُ يَرَتَا ندِيَمْ اِنَبٛجَمْ، سٜيْ ٻٜ مبِعِ، ‏‹‏اٜ مٛ وٛودِ غِنّٛلْ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","ٻِي نٜطّٛ بٛو وَرِي اٜ ݧَامَ اٜ يَرَ، سٜيْ ٻٜ مبِعِ، ‏‹‏رَا اٛعٛ، اٛ بٜىٰلَاطٛ اٛ جَرٛووٛ، حِغٛ جَٻٛوٻٜ شٜىٰدٜ لٜيْدِ اٜ غَطٛوٻٜ حَکّٜ؞›‏ فُو اٜ نٛنْ، تٛکُّٻٜ لَاوٛلْ اَللَّه فُو اٜ ٻٜ کٛلَّ کَنْغٛلْ وٛنِ غٛونغَوٛلْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","سٜيْ اٛ فُطِّ حَٻَنْکِ غَرِيجٜ طٜ اٛ وَطِ کُوطٜ کَيْطِنِيطٜ ندٜرْ مَاجٜ نغَمْ يِمْٻٜ غَرِيجٜ طٜنْ تُوبَايِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","اٛ وِعِ، ‏«‏يِمْٻٜ غَرِيرِ کٛرَسِنْ، اٛنْ مبٛنِي!‏ يِمْٻٜ غَرِيرِ بٜتَسَيْدَ، اٛنْ مبٛنِي!‏ دَا کُوطٜ کَيْطِنِيطٜ غَطَاطٜ ندٜرْ مٛوطٛنْ طٜ نغَطَنَامَ يِمْٻٜ تَايَ اٜ سِدٛنْ، دَا ٻٜ ٻٛرْنَکٜ کٛلْتٜ کٛلَّيْطٜ وَنَّارٜ ٻٜ نجٛوطَکٜ ندٜرْ تٛوکَ نغَمْ حٛلُّکِ ٻٜ تُوبِي؞ ");
INSERT INTO fuv_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","اَمَّا اٜ مِ وِعَعٛنْ، ݧَلْندٜ جَانغٛ اَللَّه ٻُرَيْ يُرْمِنَنْکِ يِمْٻٜ تَايَ اٜ سِدٛنْ دٛوْ مٛوطٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","اٛنٛنْ بٛو، يِمْٻٜ غَرِيرِ کَفَرْنَحُمْ، اٛنْ کَمِّي طُمْ حٛشَّيْعٛنْ يَاکِ دٛوْ؟ نَاع نٛنْ!‏ طُمْ نَتِّنَيْعٛنْ ندٜرْ نغَيْکَ حِيتٜ؞ دَا کُوطٜ کَيْطِنِيطٜ غَطَاطٜ ندٜرْ مَاطَ طٜ نغَطَامَ ندٜرْ غَرِيرِ سٛدٛمْ، دَا اٜ ندِ طٛنْ حَا جٛونِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","اَمَّا اٜ مِ وِعَعٛنْ، ݧَلْندٜ جَانغٛ اَللَّه ٻُرَيْ يُرْمِنَنْکِ يِمْٻٜ سٛدٛمْ دٛوْ مٛوطٛنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","اٜ شَرٜلْ نغٜلْ يٜىٰسُ وِعِ، ‏«‏مِ يٜتِّيمَ، ݧَاکٛ اَمْ مٛ دٛوْ، جٛومِرَاوٛ دٛوْ اٜ لٜيْ، نغَمْ اَ سُوطِي فِي طُعُمْ تٛ غٛودُٻٜ فَامُ اٜ اَنْدَلْ، اَ حٛلِّيطُمْ ٻِکّٛيْ ڤَمَرٛيْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","نٛنْ ݧَاکٛ اَمْ، نغَمْ نٛنْ وٜلَنْمَا نغَطَا؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","سٜيْ اٛ وِعِ يِمْٻٜ، ‏«‏ݧَاکٛ اَمْ حٛکِّييَمْ کٛو طُمٜ؞ وَلَا اَنْدُطٛ مٛيٜ وٛنِ ٻِطّٛ اٛنْ سٜيْ نِ ݧَاکٛ اٛنْ، نٛنْ مَا وَلَا اَنْدُطٛ ݧَاکٛ اٛنْ سٜيْ نِ ٻِطّٛ اٛنْ، اٜ مٛ ٻِطّٛ اٛنْ يِطِ اَنْدِنَ ݧَاکٛ اٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","‏«‏نغَرٜىٰ تٛ اَمْ اٛنْ فُو دٛنْدِيٻٜ دٛݝْلٜ تٜدُّطٜ، مِ حٛکَّيْعٛنْ سِوْتَارٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","تٛکّٜىٰ کٛ مبِعَيْمِعٛنْ؞ اٜکِّتٜىٰ تٛ اَمْ، نغَمْ اٜ مِ وٛودِ حَکِّيلٛ، مِ لٜسْتِنْطٛ حٛورٜ، ندٜنْ ٻٜرْطٜ مٛوطٛنْ مبَلْتٛتٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","نغَمْ کٛ مبِيمِعٛنْ نغَطٛنْ طُمْ سَطَا وَطُکِ، ندٜنْ دٛنْغَلْ اَمْ تٜدَّا؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","اٜ شَرٜلْ نغٜلْ طُمْ ݧَلْندٜ سِوْتَارٜ؞ يٜىٰسُ اٜ يَحَ ندٜرْ نغٜسَ اَلْکَمَارِ، سٜيْ تٛکُّٻٜمٛ نَنِ وٜىٰلٛ ٻٜ ڤُطِّ ٻٛرُکِ شَمّٜىٰجٜ مَيْرِ اٜ ٻٜ ݧَامَ؞ ");
INSERT INTO fuv_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","اَمَّا ندٜ وٛٻّٜ فَارِسَنْکٛعٜنْ نغِعِ نٛنْ، مبِعِ يٜىٰسُ، ‏«‏رَا تٛکُّٻٜمَ اٜ نغَطَ کٛ اَتَّوْرَ حَطِ طُمْ وَطَ ݧَلْندٜ سِوْتَارٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","سٜيْ يٜىٰسُ وِعِٻٜ، ‏«‏اٛنْ مٜىٰطَايِ جَنْغُکِ کٛ دَوْدَ وَطِ ندٜ نَنِ وٜىٰلٛ، کَنْکٛ اٜ غٛنْدُٻٜ اٜ مَاکٛ؟ ");
INSERT INTO fuv_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","اٛ نَتِّ لُکُرُ سٜنِيطُمْ، اٛ ݧَامِ بُرٛودِ شٜنِيطُمْ، اٛ حٛکّٛرِ جَادٛوٻٜ اٜ مَاکٛ؞ اَتَّوْرَ بٛو وِعِي اَرْدِيٻٜ دِينَ تَنْ حَانِ ݧَامُکِ بُرٛودِ طُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","کٛو اٛنْ مٜىٰطَايِ جَنْغُکِ ندٜرْ اَتَّوْرَ نٛ اَرْدِيٻٜ دِينَ نغٜوِرْتَ دٛوکَ ݧَلْندٜ سِوْتَارٜ ندٜرْ وُرٛ شٜنِينغٛ، اَمَّا طُمْ وَرْتَايِ حَکّٜ؟ ");
INSERT INTO fuv_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","اٜ مِ وِعَعٛنْ، رَا ٻُرْطٛ وُرٛ شٜنِينغٛ طٛعٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","اَمَّا دَا اٛنْ اَنْدُنٛو مَعَنَ اَايَارٜ ندٜعٜ بِعُندٜ، ‏‹‏اٜ مِ يِطِ کٛلّٛنْ يُرْمٜىٰندٜ، نَاع سَکُّکِ شَکِّرِ،›‏ دَا اٛنْ کِيتَاکِ ٻٜ نغَطَايِ حَکّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","نغَمْ ٻِي نٜطّٛ وٛنِ جٛومُ ݧَلْندٜ سِوْتَارٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","سٜيْ يٜىٰسُ اَلِ طٛنْ دِلِّ، نَتِّ سُودُ دٛعَارٜ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","اٜ وٛودِ غٛطّٛ مٛ جُنْغٛ جَرَانغٛ ندٜرْ مَيْرُ؞ سٜيْ فَارِسَنْکٛعٜنْ پَمِ يٜىٰسُ، مبِعِ، ‏«‏اَتَّوْرَ جَٻِي طُمْ يَمْطِتِنَ ݧَلْندٜ سِوْتَارٜ؟»‏ ٻٜ مبِعُ نٛنْ نغَمْ ٻٜ کٜٻَ کٛ ٻٜ نغُلِّرٛيْتٛومٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","سٜيْ يٜىٰسُ وِعِٻٜ، ‏«‏مٛيٜ ندٜرْ مٛوطٛنْ تٛ اٜ وٛودِ مبَالَ غٛعٛ تٛ نغَ يَنِي ندٜرْ نغَيْکَ ݧَلْندٜ سِوْتَارٜ، اٛ جٛغَتَاکٛنغَ اٛ اِتّٛيَنغَ؟ ");
INSERT INTO fuv_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","تٛو!‏ نٜطّٛ ٻُرِي مبَالَ دَرَجَ نَاع سٜطَّ!‏ نغَمْ نٛنْ، اَتَّوْرَ حَطَايِ طُمْ وَطَ کٛ وٛوطِ ݧَلْندٜ سِوْتَارٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","سٜيْ اٛ وِعِ نٜطّٛ اٛنْ، ‏«‏فٛرْتُ جُنْغٛ مَاطَ؞»‏ سٜيْ اٛ فٛرْتِنغٛ، سٜيْ نغٛ يَمْطِتِ، نغٛ وَرْتِ بٛ وٛعٛتٛ نغٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","اَمَّا فَارِسَنْکٛعٜنْ ٻٜنْ مبُرْتِي مٜدِّ دٛوْ نٛ ٻٜ مبَرْدَتَ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","ندٜ يٜىٰسُ فَامِ کٛ ٻٜ شِرْيٛتٛو، سٜيْ اٛ اُمِّي اٛ اَلِ وِغٜىٰرٜ ندٜنْ؞ سٜيْ يِمْٻٜ طُطْٻٜ تٛکِّمٛ، اٛ يَمْطِتِنِٻٜ ٻٜ فُو، ");
INSERT INTO fuv_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","اٛ وَغِّنِٻٜ تٛع ٻٜ مبِعَکَ کٛو مٛيٜ کَنْکٛ اٛ مٛيٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","طُعُمْ فُو وَطِي نغَمْ طُمْ حٜبِّنَ کٛ اَللَّه وِعِ دَغَ حٛنْدُکٛ اَنَّبِ اِشَايَ، وِيکِ، ");
INSERT INTO fuv_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","‏«‏اٛعٛ وٛنِ مَشُّطٛ مٛ شُٻُمِ، مٛ نغِطُمِ، اٜ مِ نَنَ بٜلْطُمْ مَاکٛ نَاع سٜطَّ؞ مِ حٛکَّيْمٛ رُوحُ اَمْ، اٛ حٛکَّيْ لٜݧِ حَبَرُ کِسْندَمْ اَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","اٛ يٜدَّتَا اٛ مٜتَتَا سٜمْبٜىٰ، وَلَا نَنَيْطٛ حٛولٛ حٛنٛنْدٜ مَاکٛ دٛوْ طَتٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","اٛ حٜىٰݧِتَتَا يٜوُکِ پٛمْبَلْ ٻَدِينغَلْ يٜوُکِ؞ اٛ ݧِفَتَا فِتِلَارُ ٻَدِيندُ وَاتُکِ، نَا اٛ وَطِي اَادِلَاکُ حٜٻِ جَالٛرْغَلْ دٛوْ حَلّٜىٰندٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","لٜݧِ فُو نغَطَيْ کَمُّندٜ دٛوْ مَاکٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","سٜيْ طُمْ وَدَّنِمٛ غٛطّٛ ڤَحٛ بُمْطٛ غٛودُطٛ غِنّٛلْ؞ يٜىٰسُ بٛو يَمْطِتِنِمٛ، اٛ وَرْتِ اٜ مٛ مٜتَ، اٜ مٛ يِعَ؞ ");
INSERT INTO fuv_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","کَوْرُتُٻٜ فُو کَيْطِنِ، مبِعِ، ‏«‏اٜ يِيکِ مٛوطٛنْ کٛو اٛعٛ وٛنِ ٻِطّٛ دَوْدَ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","اَمَّا ندٜ فَارِسَنْکٛعٜنْ نَنِ نٛنْ، ٻٜ مبِعِ، ‏«‏اٜ بَوْطٜ بَعَلْجَبُلْ لَامِيطٛ غِنِّ اٛ وُرْتِنِرْتَ غِنِّ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","اَمَّا يٜىٰسُ اٜ اَنْدِ کٛ وٛنِ ندٜرْ ٻٜرْطٜ مَٻّٜ، اٛ وِعِٻٜ، ‏«‏لَامُ فُو شٜنْدِيطُمْ اٜ وَݧْوَݧْتِرَ، طُمْ لَلَّيْ؞ نٛنْ مَا تٛ غَرِيرِ کٛو وُرٛ سٜنْدَکٜ اٜ وَݧْوَݧْتِرَ، طُمْ وَاوَتَا طُمْ دَرٛو؞ ");
INSERT INTO fuv_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","تٛ شٜيْطَنْ اٜ وُرْتِنَ غِنِّ شٜيْطَنْ ندٜرْ لَامُ شٜيْطَنْ، شٜيْطَنْ سٜنْدَکٜ اٜ وَݧْوَݧْتِرَ وٛنْ طٛنْ؞ تٛ لَامُ مَاکٛ سٜنْدَکٜ، نٛيٜ لَامُ طُمْ دَرٛرْتٛو؟ ");
INSERT INTO fuv_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","تٛ اٜ مِ وُرْتِنِرَ غِنِّ ندٜرْ بَوْطٜ بَعَلْجَبُلْ، اٜ بَوْطٜ مٛيٜ تٛکُّٻٜعٛنْ مبُرْتِنِرْتَطِ؟ نغَمْ نٛنْ تٛکُّٻٜعٛنْ کٛلَّيْ اٛنْ نغَلَا غٛونغَ؞ ");
INSERT INTO fuv_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","اَمَّا، تٛ اٜ مِ وُرْتِنَ غِنِّ ندٜرْ بَوْطٜ رُوحُ اَللَّه، تٛو، حٛلِّي لَامُ اَللَّه وَرَنِيعٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","‏«‏نٛ وَطَتَ طُمْ وَاوَ نَتُّکِ وُرٛ نٜطّٛ شٜمْبِطّٛ طُمْ تٜىٰتَنَمٛ کٛ اٛ وٛودِ، نَاع سٜيْ تٛ طُمْ اَرْتِي حَٻُّکِمٛ؟ ندٜنْ طُمْ وَاوَ حٛشُّکِ کٛ اٛ وٛودِ ندٜرْ وُرٛ نغٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","‏«‏مٛ وٛنْدَا اٜ اَمْ فُو، اٛ غَݧٛ اَمْ؞ مٛ وَلَّايِيَمْ مٛٻْتُکِ فُو، اٛ شَنْکِتٛووٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","نغَمْ نٛنْ، اٜ مِ وِعَعٛنْ، طُمْ وَاوَيْ يَافَنَاکِ يِمْٻٜ حَکّٜ اٜ کٛو اِرِ طِيٜ حَالَاجِ طِ مبٛوطَا طِ ٻٜ مٜتِ، اَمَّا بِعُطٛ کٛ وٛوطَا دٛوْ رُوحُ اَللَّه اٛ يَافَنْتَاکٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","فُو بِعُطٛ کٛ وٛوطَا دٛوْ ٻِي نٜطّٛ، طُمْ وَاوَيْ يَافَنَاکِمٛ؞ اَمَّا فُو بِعُطٛ کٛ وٛوطَا دٛوْ رُوحُ اَللَّه، اٛ يَافَنْتَاکٜ حَا اَبَدَا؞ ");
INSERT INTO fuv_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","‏«‏لٜکِّ بٛطْکِ اٜ رِمَ ٻِکّٛيْ مبٛطْکٛيْ، نٛنْ مَا لٜکِّ کِ وٛوطَا اٜ رِمَ ٻِکّٛيْ کٛيْ مبٛوطَا؞ کٛو کِيٜ لٜکِّ اٜ اَنْدِرٜىٰ ٻِکّٛيْ مَاکِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","اٛنٛنْ بٛولٜ کَلُّطٜ!‏ نٛ وَطَتَ اٛنٛنْ کَلُّٻٜ مٜتٛنْ کٛ وٛوطِ؟ نغَمْ حٛنْدُکٛ نٜطّٛ اٜ مٜتَ کٛ وٛنِ ندٜرْ ٻٜرْندٜ مُوطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","نٜطّٛ مٛ نغِکُّ بٛطُّمْ اٜ وُرْتِنَ فِي بٛطُّمْ دَغَ ندٜرْ ٻٜرْندٜ مُوطُمْ؞ نٛنْ مَا نٜطّٛ کَلُّطٛ اٜ وُرْتِنَ حَلّٜىٰندٜ دَغَ ندٜرْ ٻٜرْندٜ مُوطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","‏«‏اٜ مِ وِعَعٛنْ، ندٜرْ ݧَلْندٜ جَانغٛ کٛو مٛيٜ دٛولٜ وِعَ اَللَّه نغَمْ طُمٜ وِعِ کٛو طٜيٜ بٛلِيطٜ مٜىٰرٜىٰجٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","دٛوْ بٛلِيطٜ طٜ مبِعُطَا طُمْ وَطِرَنْتَمَ کِيتَ، کٛو طٜ نَنْغُمَا، کٛو طٜ مبُرْتِنْمَا؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","سٜيْ وٛٻّٜ ندٜرْ مٛودِٻّٜ اَتَّوْرَ اٜ فَارِسَنْکٛعٜنْ مبِعِمٛ، ‏«‏مٛودِبّٛ، اٜ مِنْ نغِطِ يِيکِ غٛطُّمْ کَيْطِنِيطُمْ دَغَ تٛ مَاطَ تَبِّتِنَيْطُمْ اَللَّه لِلٛيْمَا؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","سٜيْ يٜىٰسُ نٛوتِي، وِعِٻٜ، ‏«‏يِمْٻٜ جَامَنُ طُعُمْ کَلُّٻٜ ٻٜ کُلَتَا اَللَّه، اٜ ٻٜ نغِطِ حٛلّٜىٰکِ غٛطُّمْ کَيْطِنِيطُمْ، اَمَّا وَلَا کٛ طُمْ حٛلَّتَٻٜ سٜيْ نِ کٛ حٜٻُنٛ اَنَّبِ اِنُوسَ؞ ");
INSERT INTO fuv_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","نغَمْ نٛنْ، نٛ اِنُوسَ وَطِرِ بَلْطٜ تَتِ جٜمَّ اٜ ݧَلَوْمَ ندٜرْ وٛنْغَ لِنْغَ مَنْغَ، نٛنْ مَا ٻِي نٜطّٛ وَطِرْتَ بَلْطٜ تَتِ جٜمَّ اٜ ݧَلَوْمَ ندٜرْ يٜنَاندٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","اٜ ݧَلْندٜ جَانغٛ يِمْٻٜ غَرِيرِ نِينٜبَ ٻٜ اُمّٛدٛتٛ اٜ يِمْٻٜ جَامَنُ طُعُمْ؞ ٻٜ کٛلَّ کٛ يِمْٻٜ جَامَنُ طُعُمْ نغَطِ طُمْ وٛوطَا، نغَمْ کَمْٻٜ، ندٜ ٻٜ نَنِ وَعَجُ اَنَّبِ اِنُوسَ، ٻٜ تُوبِي؞ رَا بٛو ٻُرْطٛ اِنُوسَ طٛعٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","ݧَلْندٜ جَانغٛ لَامِيطٛ لٜيْدِ فٛمْبِنَ دٜبّٛ اٛ اُمّٛدٛتٛ اٜ يِمْٻٜ جَامَنُ طُعُمْ؞ اٛ حٛلَّ کٛ ٻٜ نغَطِ طُمْ وٛوطَا، نغَمْ کَنْکٛ اٛ وَرٛيِي دَغَ ٻَدَاکِ نَنُکِ فَامُ اَنَّبِ سُلٜيْمَانُ؞ رَا بٛو ٻُرْطٛ سُلٜيْمَانُ طٛعٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","‏«‏تٛ غِنّٛلْ وُرْتَکٜ ندٜرْ ٻَنْدُ نٜطّٛ، نغٛلْ يَحَيْ تٛ بِغٜىٰجٜ جٛرْطٜ اٜ نغٛلْ طَٻِّتَ تٛ نغٛلْ سِوْتٛتٛو؞ اَمَّا تٛ نغٛلْ حٜٻَايِ، ");
INSERT INTO fuv_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","سٜيْ نغٛلْ وِعَ، ‏‹‏مِ سٛعّٛتٛ وُرٛ نغٛ مبُرْتٛيِيمِ؞›‏ تٛ نغٛلْ وَرْتِي، نغٛلْ تَوِي وُرٛ نغٛنْ وَلَا غٛطُّمْ ندٜرْ، نغٛ وُووَامَ نغٛ مٛعِّنَامَ؞ ");
INSERT INTO fuv_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","سٜيْ نغٛلْ يَحَ نغٛلْ وَدّٛيَ غِنِّ جٛوٜىٰطِطِ ٻُرْطِنغٛلْ حَلُّکِ، طِ نَتَّ طِ نجٛوطٛو طٛنْ؞ ندٜنْ رٜعِرْدٜ نٜطّٛ اٛنْ ٻُرَيْ فُطّٛودٜ مَاکٛ حَلُّکِ؞ نٛنْ طُمْ وَرْتَنْتَ يِمْٻٜ جَامَنُ طُعُمْ کَلُّطُمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","يٜىٰسُ اٜ مٜدَّ اٜ يِمْٻٜ طُطْٻٜ حَوْرُتُٻٜ، سٜيْ رَا مَدُوجٛ مَاکٛ اٜ مِݧِرَاٻٜ مَاکٛ نغَرِ ندَرِي يَاسِ، اٜ ٻٜ نغِطِ مٜدُّکِ اٜ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","سٜيْ غٛطّٛ وِعِمٛ، ‏«‏مَدُوجٛ مَاطَ اٜ مِݧِرَاٻٜ مَاطَ اٜ تٛنْ ندَرِي يَاسِ، اٜ ٻٜ نغِطِ مٜدُّکِ اٜ مَاطَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","اَمَّا اٛ وِعِ بِيطٛمٛکَ اٛنْ، ‏«‏مٛيٜ وٛنِ مَدُوجٛ اَمْ، ندٜنْ ٻٜيٜ نغٛنِ مِݧِرَاٻٜ اَمْ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","سٜيْ اٛ سَڤِّي تٛکُّٻٜمٛ، اٛ وِعِ، ‏«‏رَا مَدُوجٛ اَمْ اٜ مِݧِرَاٻٜ اَمْ طٛعٛ!‏ ");
INSERT INTO fuv_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","نغَمْ کٛو مٛيٜ وَطِ کٛ ݧَاکٛ اَمْ مٛ دٛوْ يِطِ، کَنْکٛ وٛنِ مِݧِرَاوٛ اَمْ اٜ مَدُوجٛ اَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","ݧَلْندٜ ندٜنْ يٜىٰسُ وُرْتِي وُرٛ نغٛنْ، يَحِ جٛوطِي حَادٜ مبٜىٰلَ غَلِيلِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","يِمْٻٜ طُطْٻٜ کَوْرِتِ تٛ مَاکٛ نَاکِ اٛ نَتِّ کٛمِوَلْ اٛ جٛوطِي ندٜرْ مَاغَلْ دٛوْ ندِيَمْ؞ کَوْرُتُٻٜ فُو ندَرِي حَادٜ مبٜىٰلَ نغَنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","سٜيْ اٛ حُوتِرِ مِسَالُ اٛ اٜکِّتِٻٜ اٜکِّتِنٛلْ فٜىٰرٜ‑فٜىٰرٜ طُطْنغٛلْ، اٛ وِعِ، ‏«‏غٛطّٛ دٜمٛووٛ يَحِ نغٜسَ نغَمْ سَاکَ اَوْدِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","اٜ مٛ ندٜرْ سَاکُکِ اَوْدِ ندِنْ، وٛنْدِ يَنِ دٛوْ طَتَلْ، شٛلِّ نغَرِ شُڤِّدِندِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","وٛنْدِ بٛو يَنِ ندٜرْ کَاپٜ، طٛنْ ندِ حٜٻَايِ لٜيْدِ طُنْدِ؞ ندِ فُطِ جَوْطُمْ نغَمْ لٜيْدِ ندِنْ لُغَّا؞ ");
INSERT INTO fuv_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","اَمَّا ندٜ نَانغٜ وُرْتٛيِي فِيِندِ، سٜيْ ندِ يٛورِ نغَمْ ندِ وَلَا طَطِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","وٛنْدِ اَوْدِ بٛو يَنِ ندٜرْ غِعٜ، سٜيْ غِعٜ طٜنْ مَوْنِ ٻِطِّندِ حَا ندِ وَاوَايِ وَطُکِ شَمّٜىٰجٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","اَمَّا وٛنْدِ اَوْدِ يَنِ دٛوْ لٜيْدِ مبٛنْدِ ندِ فُطِ ندِ مَوْنِ ندِ وَطِ شَمّٜىٰجٜ؞ وٛنْدِ وَطِ غَبّٜ 100، وٛنْدِ وَطِ غَبّٜ 60، وٛنْدِ وَطِ 30؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","ندٜ يٜىٰسُ حٜىٰݧِ حٛکُّکِ مِسَالُ طُعُمْ، سٜيْ وِعِ، ‏«‏غٛودُطٛ نٛڤِّ نَنُکِ فُو نَنَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","سٜيْ تٛکُّٻٜمٛ نغَرِ پَمِمٛ، مبِعِ، ‏«‏نغَمْ طُمٜ مٜتِرَنْتَاٻٜ اٜ مِسَالُ نِحِ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","اٛ نٛوتِي اٛ وِعِٻٜ، ‏«‏اٛنٛنْ اٛنْ کٛکَّامَ فَامُ سِرُّ لَامُ اَللَّه، اَمَّا کَمْٻٜ ٻٜ کٛکَّاکَ؞ ");
INSERT INTO fuv_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","نغَمْ فُو غٛودُطٛ فَامُ دٛوْ لَامُ اَللَّه طُمْ ٻٜيْدَنَيْمٛ، حَا طُمْ طُوطَنَمٛ؞ اَمَّا مٛ وَلَا فَامُ دٛوْ لَامُ اَللَّه، کٛو کٛ اٛ وٛودِ مَا طُمْ جَٻَيْطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","کٛ وَطِ مٜتِرَنَيْمِ يِمْٻٜ اٜ مِسَالُ وٛنِ، نغَمْ کٛو ٻٜ ندَارِي ٻٜ نغِعَتَا، کٛو ٻٜ کٜتِّنْدَکٜ ٻٜ نَنَتَا، طٛنْمَا ٻٜ ڤَامَتَا؞ ");
INSERT INTO fuv_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","دٛوْ مَٻّٜ طُمْ حٜبِّنِ کٛ اَللَّه وِعِ دَغَ حٛنْدُکٛ اِشَايَ، ‏‹‏اٛنْ نغَطَيْ کَ نَنُکِ، اَمَّا اٛنْ ڤَامَتَا کٛو سٜطَّ؞ اٛنْ نغَطَيْ کَ رَارُکِ، اَمَّا اٛنْ نغِعَتَا کٛو سٜطَّ؞ ");
INSERT INTO fuv_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","نغَمْ ٻٜرْطٜ يِمْٻٜ ٻٜنْ طٛنْ طٜ شٜمْبِطّٜ، ندٜنْ ٻٜ شُکِّي نٛڤِّ مَٻّٜ، ٻٜ مَٻِّي غِتٜ مَٻّٜ، نغَمْ تٛع ٻٜ نغِعَ اٜ غِتٜ مَٻّٜ، تٛع ٻٜ نَنَ اٜ نٛڤِّ مَٻّٜ، ٻٜ ڤَامَ ندٜرْ ٻٜرْطٜ مَٻّٜ حَا ٻٜ نغَرْتَ تٛ اَمْ، مِ يَمْطِتِنَ ٻٜرْطٜ مَٻّٜ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","‏«‏اَمَّا اٛنٛنْ، غِتٜ مٛوطٛنْ طٜ بَرْکِطِنَاطٜ نغَمْ اٜ طٜ نغِعَ، اٜ نٛڤِّ مٛوطٛنْ نغَمْ اٜ طِ نَنَ؞ ");
INSERT INTO fuv_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","اٜ مِ وِعَعٛنْ غٛونغَ، اَنَّبٛعٜنْ اٜ اَادِلِعٜنْ طُطْٻٜ نغِطِي نغِعَ کٛ نغِيطٛنْ، اَمَّا ٻٜ نغِعَايِ؞ ٻٜ بٛو نغِطِي نَنُکِ کٛ نَنٛتٛنْ، اَمَّا ٻٜ نَنَايِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","‏«‏تٛو، رَا مَعَنَ مِسَالُ دٜمٛووٛ اٛنْ طٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","فُو نَنُطٛ حَبَرُ لَامُ اَللَّه اٛ حٜٻْتَايِطُمْ، سٜيْ شٜيْطَنْ وَرَ حٛشَّ کٛ طُمْ اَاوِ ندٜرْ ٻٜرْندٜ مَاکٛ؞ طُمْ طٛنْ وٛنِ مِسَالُ اَوْدِ نجَنُندِ دٛوْ طَتَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","جَنُندِ دٛوْ کَاپٜ وٛنِ مِسَالُ نَنُطٛ وٛلْدٜ اَللَّه طٛنْ اٜ طٛنْ اٛ جَٻَندٜ اٜ بٜلْطُمْ ٻٜرْندٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","اَمَّا ندٜ وٛلْدٜ ندٜنْ وَلَا طَطِ ندٜرْ ٻٜرْندٜ مَاکٛ، اٛ مُݧَيْ شَرٜلْ سٜطَّ تَنْ؞ تٛ شَطٜىٰلٜ کٛو تٛرَّ وَرِي نغَمْ وٛلْدٜ ندٜنْ، طٛنْ اٜ طٛنْ اٛ يٛوفَندٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","جَنُندِ ندٜرْ غِعٜ وٛنِ مِسَالُ نَنْٻٜ وٛلْدٜ اَللَّه، اَمَّا وَنُّکِ اٜ فِي دُونِيَارُ، اٜ يِدّٜ جَوْدِ، ٻِطِّ وٛلْدٜ ندٜنْ کَطِندٜ وَلُّکِٻٜ ٻٜ نغَطَ کٛ اَللَّه يِطِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","اَمَّا اَوْدِ شَاکَاندِ دٛوْ لٜيْدِ مبٛنْدِ وٛنِ مِسَالُ نَنْطٛ وٛلْدٜ اَللَّه، اٛ فَامِندٜ بٛطُّمْ، اٛ وَطِ کٛ اَللَّه وِعِ، اٛ حُوتِنِرِندٜ حَا اٛ حٜٻِ ٻٜيْدَارِ؞ غٛطّٛ حٜٻِ ندٜ 100، غٛطّٛ بٛو حٜٻِ ندٜ 60، غٛطّٛ حٜٻِ ندٜ 30؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","سٜيْ يٜىٰسُ حٛکِّٻٜ غٛطُّمْ مِسَالُ وِعِ، ‏«‏لَامُ اَللَّه اٜ نَنْدِ اٜ غٛطّٛ نٜطّٛ اَاوُطٛ اَلْکَمَارِ مبٛنْدِ ندٜرْ نغٜسَ مُوطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","اَمَّا جٜمَّ، کٛو مٛيٜ اٜ طَانِي، سٜيْ غٛطّٛ غَݧٛ مَاکٛ يَحِ سَاکِ اَوْدِ غٛطّٜ غٜىٰنٜ ندٜرْ اَلْکَمَارِ ندِنْ دِلِّ؞ ");
INSERT INTO fuv_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","ندٜ اَلْکَمَارِ ندِنْ فُطِ، مَوْنِ وَطِ شَمّٜىٰجٜ، سٜيْ غٜىٰنٜ طٜنْ مَا اُمّٛيِي؞ ");
INSERT INTO fuv_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","سٜيْ مَشُّٻٜ جٛومُ نغٜسَ کَنْ نغَرِ مبِعِمٛ، ‏‹‏جٛومُ وُرٛ، نَاع اَوْدِ مبٛنْدِ اَاوُطَا تٛ نغٜسَ مَاطَ؟ تٛو، نٛ وَطِ غٜىٰنٜ ڤُطٛيِ ندٜرْ مَيْرِ؟›‏ ");
INSERT INTO fuv_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","اٛ وِعِٻٜ، ‏‹‏طُمْ غٛطّٛ غَݧٛ اَمْ وَطِ نٛنْ؞›‏ سٜيْ مَشُّٻٜ ٻٜنْ مبِعِمٛ، ‏‹‏اَ يِطِ مِنْ نجَحَ مِنْ اِتَّطٜ؟›‏ ");
INSERT INTO fuv_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","اَمَّا اٛ وِعِٻٜ، ‏‹‏نَاع نٛنْ؞ نغَمْ تٛ اٛنْ اِتَّطٜ، اٛنْ اِتَّيْ فُو اٜ اَلْکَمَارِ ندِنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","اَلٜىٰطٜ طٜ مَوْنِدَ اٜ مَيْرِ نَا شَرٜلْ تَپُکِندِ وَطِ؞ تٛ شَرٜلْ تَپُکِندِ وَطِ، مِ وِعَيْ تَپٛوٻٜ ٻٜنْ اَرْتَ تَپُکِ غٜىٰنٜ طٜنْ ٻٜ کَٻَّطٜ کَٻّٜ‑کَٻّٜ، طُمْ وُلَطٜ؞ اَمَّا اَلْکَمَارِ ندِنْ، ٻٜ نغَطَندِ ندٜرْ رٜسِرْدٜ غَوْرِ اَمْ؞›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","يٜىٰسُ فُطِّتِ حٛکِّٻٜ غٛطُّمْ مِسَالُ وِعِ، ‏«‏لَامُ اَللَّه اٜ نَنْدِ اٜ غَبّٜلْ مَسْتَتْ نغٜلْ غٛطّٛ حٛشِّ اَاوِ ندٜرْ نغٜسَ مُوطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","کَنْغٜلْ وٛنِ غَبّٜلْ ٻُرْنغٜلْ فَمْطُکِ ندٜرْ نغَبّٛيْ فُو، اَمَّا تٛ نغٜلْ مَوْنِ، سٜيْ نغٜلْ ٻُرَ کٛو نغٜلٜ لٜغّٜلْ مَوْنُکِ، حَا شٛلِّ نغَرَ نغَطَ شَٻّٜ دٛوْ لِشٜ مَاغٜلْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","يٜىٰسُ فُطِّتِ حٛکِّٻٜ غٛطُّمْ مِسَالُ وِعِ، ‏«‏لَامُ اَللَّه اٜ نَنْدِ اٜ پُوفِنِرْطُمْ طُمْ غٛطّٛ دٜبّٛ حٛشِّ لَنْشِندِرِ اٜ شٛنْدِ اَلْکَمَارِ ڤٛوندِرْکٛيْ تَتٛيْ، حَا ندِ فُو ندِ پُوفِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","يٜىٰسُ مٜتِرَنِ حَوْرُتُٻٜ ٻٜنْ فُو فِي طُعُمْ اٜ مِسَالُ؞ فُو کٛ اٛ وِعَتَٻٜ اٜ مٛ حُوتِرَ مِسَالُ؞ ");
INSERT INTO fuv_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","اٛ وَطِي نٛنْ نغَمْ اٛ حٜبِّنَ کٛ اَللَّه وِعِ دَغَ حٛنْدُکٛ اَنَّبِيجٛ وِيکِ، ‏«‏مِ مٜتِرَنَيْ يِمْٻٜ اٜ مِسَالُ؞ کٛ سُوطِي دَغَ تَغُکِ دُونِيَارُ، مِ وُرْتِنَيْطُمْ اٜ نجَيْرِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","سٜيْ يٜىٰسُ اَلِ يِمْٻٜ ٻٜنْ نَتِّ وُرٛ؞ تٛکُّٻٜمٛ نغَرِ تٛ مَاکٛ مبِعِمٛ، ‏«‏وِعُمِنْ مَعَنَ مِسَالُ غٜىٰنٜ ندٜرْ نغٜسَ اَلْکَمَارِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","اٛ وِعِٻٜ، ‏«‏اَاوُطٛ اَوْدِ مبٛنْدِ ندِنْ وٛنِ ٻِي نٜطّٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","نغٜسَ کَنْ وٛنِ دُونِيَارُ؞ ندٜنْ اَوْدِ مبٛنْدِ ندِنْ وٛنِ ٻِٻّٜ لَامُ اَللَّه؞ غٜىٰنٜ طٜنْ نغٛنِ ٻِٻّٜ شٜيْطَنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","اٛنْ طٛنْ غَݧٛ اَاوُطٛ غٜىٰنٜ طٜنْ، کَنْکٛ وٛنِ شٜيْطَنْ؞ شَرٜلْ تَپُکِندِ وٛنِ رٜعُکِ دُونِيَارُ، ندٜنْ تَپٛوٻٜنْدِ نغٛنِ مَلَاعِکَعٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","نٛنْ نٛ طُمْ حَوْرِتِرْتَ غٜىٰنٜ طُمْ وُلَطٜ، نٛنْ طُمْ وَطَتَ اٜ رٜعُکِ دُونِيَارُ؞ ");
INSERT INTO fuv_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","ٻِي نٜطّٛ لِلٛيَيْ مَلَاعِکَعٜنْ مُوطُمْ، ٻٜ مبُرْتِنَ کٛو طُمٜ ڤٛوطٛوجُمْ يِمْٻٜ نغَطَ حَکّٜ اٜ فُو غَطٛوٻٜ کٛ حَلِّ ندٜرْ لَامُ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","سٜيْ مَلَاعِکَعٜنْ ٻٜنْ کُبٛوٻٜ ندٜرْ حِيتٜ کَلُّنغٜ؞ طٛنْ ٻٜ مبٛيَتَ ٻٜ ݧٜرْپِندِرَ ݧِيپٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","ندٜنْ اَادِلِعٜنْ طٜلْکِتٛتٛ بٛ نَانغٜ ندٜرْ لَامُ ݧَاکٛ مَٻّٜ مٛ دٛوْ؞ فُو غٛودُطٛ نٛڤِّ نَنُکِ نَنَ؞ ");
INSERT INTO fuv_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","‏«‏لَامُ اَللَّه اٜ نَنْدِ اٜ جَوْدِ شُوطِيندِ اٜ نغٜسَ ندِ غٛطّٛ حٜٻْتِ، اٛ فُطِّتِ اٛ سُوطِندِ؞ ندٜرْ وٜلْوٜلٛ اٛ يَحِ، اٛ سٛورِ فُو کٛ اٛ وٛودِ اٛ سٛودِ نغٜسَ کَنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","‏«‏طٛنْمَا لَامُ اَللَّه اٜ نَنْدِ اٜ نٜطّٛ شٛودٛووٛ اٜ سٛورِتٛو طَٻِّتٛووٛ لُعُ‑لُعُ غٛودُطُمْ شٜىٰدٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","ندٜ اٛ يِعِ غٛعٛ غٛودُطُمْ شٜىٰدٜ طُطّٜ، سٜيْ اٛ يَحِ اٛ سٛورِ فُو کٛ اٛ وٛودِ، اٛ سٛودِ لُعُ‑لُعُ طُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","‏«‏طٛنْمَا لَامُ اَللَّه اٜ نَنْدِ اٜ نَنْغِرْطُمْ لِپِّ طُمْ وٛٻّٜ کُبِي ندٜرْ مبٜىٰلَ، طُمْ نَنْغٛيِ کٛو اِرِ طِيٜ لِپِّ؞ ");
INSERT INTO fuv_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","ندٜ طُمْ حٜىٰوِ، ٻٜ ڤٛوطٛيِطُمْ دَاندٜ مبٜىٰلَ نغَنْ، ٻٜ نجٛوطِي، ٻٜ شُڤْتِ لِپِّ بٛطِّ، ٻٜ نغَطِطِ ندٜرْ فَاندُ، اَمَّا ٻٜ شَنْکِتِ طِ مبٛوطَا طِنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","نٛنْ طُمْ وَطَتَ اٜ رٜعُکِ دُونِيَارُ؞ مَلَاعِکَعٜنْ نغَرَيْ کَکِّتَ کَلُّٻٜ دَغَ ندٜرْ اَادِلِعٜنْ، ");
INSERT INTO fuv_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ٻٜ کُبٛو کَلُّٻٜ ٻٜنْ ندٜرْ حِيتٜ کَلُّنغٜ؞ طٛنْ ٻٜ مبٛيَتَ ٻٜ ݧٜرْپِندِرَ ݧِيپٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","‏«‏اٛنْ ڤَامِي فُو طُعُمْ؟»‏ ٻٜ نٛوتِي ٻٜ مبِعِ، ‏«‏اٜىٰ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","سٜيْ اٛ وِعِٻٜ، ‏«‏تٛو، فُو مٛودِبّٛ اَتَّوْرَ اٜکِّتِيطٛ دٛوْ لَامُ اَللَّه اٜ مٛ نَنْدِ اٜ جٛومُ وُرٛ بُرْتِنْطٛ جَوْدِ کٜيْرِ اٜ کِيندِ ندٜرْ ندٜسَ مُوطُمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","ندٜ يٜىٰسُ حٜىٰݧِ وِيکِٻٜ فُو مِسَالُ طُعُمْ، سٜيْ اٛ اُمِّي اٛ اَلِ وِغٜىٰرٜ ندٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","اٛ يَحِ غَرِيرِ تٛ اٛ مَوْنِ، اٛ فُطِّ اٜکِّتِنْکِ يِمْٻٜ ندٜرْ سُودُ دٛعَارٜ مَٻّٜ حَا ٻٜ کَيْطِنِ، ٻٜ مبِعِ، ‏«‏تٛيٜ نٜطّٛ اٛعٛ حٜٻِ فَامُ طُعُمْ اٜ بَوْطٜ وَطُکِ کُوطٜ کَيْطِنِيطٜ طٜعٜ؟ ");
INSERT INTO fuv_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","نَاع کَنْکٛ وٛنِ ٻِطّٛ اٛنْ طٛنْ شٜحٛووٛ؟ نَاع مَدُوجٛ مَاکٛ اٜ وِعٜىٰ مَرْيَامَ؟ نَاع يَاکُبُ اٜ يُسُفُ اٜ سِيمَنْ اٜ يَحُودَ نغٛنِ مِݧِرَاٻٜ مَاکٛ؟ ");
INSERT INTO fuv_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","ندٜنْ نَاع اٜنْ نغٛنْدِ اٜ مِݧِرَاٻٜ مَاکٛ رٜوْٻٜ؟ تٛو، تٛيٜ نٜطّٛ اٛعٛ حٜٻِ فُو فِي طُعُمْ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","سٜيْ ٻٜ نغَݧِ حٛولَاکِ يٜىٰسُ؞ اَمَّا يٜىٰسُ وِعِٻٜ، ‏«‏کٛو تٛيٜ يِمْٻٜ اٜ کٛکَّ اَنَّبِيجٛ مَنْغُ، اَمَّا يِمْٻٜ غَرِيرِ مَاکٛ، اٜ يِمْٻٜ وُرٛ مَاکٛ ٻٜ کٛکَّتَامٛ مَنْغُ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","يٜىٰسُ وَطَايِ غٛطُّمْ کَيْطِنِيطُمْ تٛنْ نغَمْ ٻٜ کٛولَاکِمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","اٜ شَرٜلْ نغٜلْ حِرُدُسْ لَامِيطٛ نَنِ حَبَرُ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","سٜيْ اٛ وِعِ مَشُّٻٜ مَاکٛ، ‏«‏اٛنْ طٛنْ طُمْ يَحَيَ غَطٛووٛ بَڤْتِسْمَ اُمِّنَا دَغَ مَيْدٜ، کَنْجُمْ وَطِ اٜ مٛ وٛودِ بَوْطٜ وَطُکِ کُوطٜ کَيْطِنِيطٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","نغَمْ ندٜنّٛ حِرُدُسْ اٜ حٛورٜ مُوطُمْ وَطِي طُمْ نَنْغِي يَحَيَ، طُمْ حَٻِّمٛ، طُمْ سُرِمٛ ندٜرْ سُودُ شُرَلْ؞ حِرُدُسْ وَطِ نٛنْ نغَمْ حِرُودِيَ دٜبّٛ مَوْنِرَاوٛ مَاکٛ فِلِبُسْ مٛ اٛ تٜعِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","نغَمْ ندٜنّٛ يَحَيَ وِعِي حِرُدُسْ، ‏«‏طُمْ حَانَايِ تٜعَامٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","نٛنْ وَطِ حِرُدُسْ اٜ يِطِ وَرْکِ يَحَيَ، اَمَّا اٜ مٛ حُلَ يِمْٻٜ، نغَمْ ٻٜ نجَٻِي يَحَيَ اٛ اَنَّبِيجٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","اَمَّا ندٜ ݧَلْندٜ حُمْتٛ سِفْتٛرْکِ دَݧْنغٛلْ حِرُدُسْ وَرِ، سٜيْ ٻِطّٛ حِرُودِيَ سُرْبَاجٛ وَمِ يٜىٰسٛ حٛٻّٜ غَرْٻٜ حُمْتٛ نغٛنْ؞ غَمٛلْ مَاکٛ وٜلِي حِرُدُسْ، ");
INSERT INTO fuv_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","حَا وَطَنِمٛ اَلْکَوَلْ حُنَنِيمٛ وِيکِ حٛکَّيْمٛ کٛو طُمٜ کٛ اٛ تٛرِي؞ ");
INSERT INTO fuv_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","سٜيْ مَدُوجٛ مَاکٛ وِعِمٛ کٛ اٛ وِعَتَ؞ سُرْبَاجٛ اٛنْ وِعِ حِرُدُسْ، ‏«‏حٛکَّمْ حٛورٜ يَحَيَ غَطٛووٛ بَڤْتِسْمَ ندٜرْ لٜعَلْ جٛونِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","لَامِيطٛ اٛنْ بٛو وَنِّ، اَمَّا نغَمْ اٛ يَادَکٜ اٛ حُنَنَکٜمٛ يٜىٰسٛ حٛٻّٜ، اٛ وَطِ طُمْ حٛکَّمٛ حٛورٜ ندٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","اٛ لِلِ وٛٻّٜ اِتّٛنٛيِ يَحَيَ حٛورٜ ندٜرْ سُودُ شُرَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","طُمْ وَدِّ حٛورٜ ندٜنْ ندٜرْ لٜعَلْ، طُمْ حٛکِّ سُرْبَاجٛ اٛنْ؞ سُرْبَاجٛ اٛنْ بٛو وَدَّنِندٜ مَدُوجٛ مُوطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","سٜيْ تٛکُّٻٜ يَحَيَ اٛنْ نغَرِ کٛشِّ ٻَنْدُ ندُنْ اُوٛيِندُ؞ ندٜنْ ٻٜ نجَحِ ٻٜ مبِعٛيِکَ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","ندٜ يٜىٰسُ نَنِ نٛنْ، سٜيْ نَتِّ کٛمِوَلْ اٜ تٛکُّٻٜمٛ ٻٜ ندِلِّ تٛ وِغٜىٰرٜ ندٜرْ لَدّٜ کَمْٻٜ تَنْ؞ اَمَّا ندٜ يِمْٻٜ طُطْٻٜ نَنِ نٛنْ، ٻٜ مبُرْتٛيِي دَغَ غَرِيجٜ، ٻٜ تٛکِّمٛ اٜ کٛيْطٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","اٜ جِڤَّاکِ يٜىٰسُ دَغَ ندٜرْ کٛمِوَلْ نغَلْ اٛ يِعِ يِمْٻٜ طُطْٻٜ اٜ کَوْرِتِ، سٜيْ اٛ نَنِ جُرُمْطُمْ مَٻّٜ، اٛ يَمْطِتِنِ ٻٜ نجَمْطَا ندٜرْ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","ندٜ نَانغٜ حِيرِي، سٜيْ تٛکُّٻٜمٛ نغَرِ تٛ مَاکٛ، مبِعِمٛ، ‏«‏طٛعٛ طُمْ لَدّٜ، طٛنْمَا نَانغٜ حِيرِ؞ وِعُ يِمْٻٜ ٻٜعٜ ندِلَّ نغَمْ ٻٜ نجَحَ نغَرِحٛيْ ٻٜ شٛودَنَ کٛعٜ مَٻّٜ کٛ ٻٜ ݧَامَتَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","يٜىٰسُ وِعِٻٜ، ‏«‏نَاع دٛولٜ ٻٜ ندِلَّ؞ اٛنٛنْ کٛکّٜىٰٻٜ کٛ ٻٜ ݧَامَتَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","سٜيْ ٻٜ نٛوتِي ٻٜ مبِعِمٛ، ‏«‏بُرٛودِ جٛوِ اٜ لِپِّ طِطِ تَنْ مِنْ نغٛودِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","سٜيْ اٛ وِعِ، ‏«‏نغَدَّنٜىٰيَمْطُمْ طٛعٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","اٛ وِعِ حَوْرُتُٻٜ ٻٜنْ نجٛوطٛو دٛوْ حُطٛ حٜشّٛ؞ اٛ حٛشِّ بُرٛودِ جٛوِ طُمْ اٜ لِپِّ طِطِ طِنْ، اٛ رَارِ دٛوْ، اٛ يٜتِّ اَللَّه، اٛ سٜنْدِ بُرٛودِ طُمْ اٛ حٛکِّ تٛکُّٻٜمٛ، سٜيْ تٛکُّٻٜمٛ نغٜىٰدَنِ يِمْٻٜ حَوْرُتُٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","ٻٜ فُو ٻٜ ݧَامِ ٻٜ کَارِ؞ تٛکُّٻٜمٛ مٛٻْتِ کٛ حٛرِ کٛ وَطِ کٛنْدٛوجٜ سَڤّٛ اٜ طِطِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","ݧَامُٻٜ ݧَمْندُ ندُنْ وٛرْٻٜ تَنْ ٻَدَکٜ ‏5,000، سُکَاٻٜ اٜ رٜوْٻٜ لِمَاکَ؞ ");
INSERT INTO fuv_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","طٛنْ اٜ طٛنْ يٜىٰسُ وَطِ تٛکُّٻٜمٛ نَتَّ کٛمِوَلْ ٻٜ اَرْتَمٛ حُولُکِ يَاکِ فٛنْغٛ، کَنْکٛ بٛو اٛ جَٻِّتٛتٛ کَوْرُتُٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","غَطَ اٛ جَٻِّتَکٜ حَوْرُتُٻٜ ٻٜنْ، اٛ پٜنْتِ حٛشّٜىٰرٜ کَنْکٛ تَنْ نغَمْ اٛ وَطَ دٛعَارٜ؞ ندٜ فُتُرٛ وَطِ، اٜ مٛ تٛنْ کَنْکٛ تَنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","اٜ شَرٜلْ نغٜلْ کٛمِوَلْ نغَلْ اٜ شَکَ مبٜىٰلَ؞ غٜىٰلٛوطِ ندِيَمْ اٜ ڤِيَنغَلْ، حٜنْدُ اٜ حَطَٻٜ يَادُ؞ ");
INSERT INTO fuv_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","فَجِرِ اٜ مٛ يَحَ تٛ مَٻّٜ، اٜ مٛ يَحَ دٛوْ ندِيَمْ مبٜىٰلَ نغَنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","اَمَّا ندٜ ٻٜ نغِعِمٛ اٜ مٛ يَحَ دٛوْ ندِيَمْ، ٻٜ کُلْتٛرِ، ٻٜ مبِعِ، ‏«‏طُمْ غِنّٛلْ!‏»‏ سٜيْ ٻٜ نغُلِّ نغَمْ کُلٛلْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","اَمَّا طٛنْ اٜ طٛنْ اٛ مٜتَنِٻٜ، اٛ وِعِ، ‏«‏ڤُکِّنٜىٰ ٻٜرْطٜ مٛوطٛنْ، طُمْ مِنْ؞ تٛع اٛنْ کُلُ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","سٜيْ بِيتُرُسْ نٛوتِي، وِعِمٛ، ‏«‏مٛودِبّٛ، تٛ طُمْ اَنْ، وِعَمْ مِ وَرَ تٛ مَاطَ دٛوْ ندِيَمْ طَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","يٜىٰسُ وِعِمٛ، ‏«‏وٛرٛيْ؞»‏ سٜيْ بِيتُرُسْ وُرْتِي ندٜرْ کٛمِوَلْ نغَلْ فُطِّ يَادُ دٛوْ ندِيَمْ طَمْ يَاکِ تٛ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","اَمَّا ندٜ اٛ نَنِ حٜنْدُ شٜمْبِنْدُ، سٜيْ اٛ حُلْتٛرِ، ندِيَمْ طَمْ فُطِّ مٛطُکِمٛ، سٜيْ اٛ وُلِّ، اٛ وِعِ، ‏«‏مٛودِبّٛ، حِسْنَمْ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","طٛنْ اٜ طٛنْ يٜىٰسُ فٛرْتِ جُنْغٛ مُوطُمْ فٛوطٛيِمٛ، وِعِمٛ، ‏«‏اَنْ غٛودُطٛ حٛولَارٜ سٜطَّ، نغَمْ طُمٜ نغَطُطَا سٜکٛ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","اٜ نَتُّکِ مَٻّٜ ندٜرْ کٛمِوَلْ نغَلْ، حٜنْدُ ندُنْ دَرِي؞ ");
INSERT INTO fuv_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","وٛنْٻٜ ندٜرْ کٛمِوَلْ نغَلْ مَوْنِنِ يٜىٰسُ، اٜ مبِعَ، ‏«‏غٛونغَ، اَنْ اَ ٻِطّٛ اَللَّه؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","ندٜ ٻٜ کُولِ فٛنْغٛ مبٜىٰلَ نغَنْ، ٻٜ نجٛتِّي لٜيْدِ جَنِسَرَتْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","ندٜ يِمْٻٜ لٜيْدِ ندِنْ اَنْدِتِ يٜىٰسُ، ٻٜ لِلِ کٛو تٛيٜ ندٜرْ لٜيْدِ ندِنْ طُمْ وَدّٛيَ فُو ݧَوْٻٜ تٛ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","ٻٜ تٛرِيمٛ ݧَوْٻٜ ٻٜنْ مٜىٰمَ شِلْمبِ تٛغّٛورٜ مَاکٛ تَنْ؞ فُو مٜىٰمُٻٜطِ نجَمْطِتِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","سٜيْ وٛٻّٜ فَارِسَنْکٛعٜنْ اٜ مٛودِٻّٜ اَتَّوْرَ نغَرِ تٛ يٜىٰسُ دَغَ اُرُشَلِيمَ، ٻٜ مبِعِ، ");
INSERT INTO fuv_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","‏«‏نغَمْ طُمٜ تٛکُّٻٜمَ تٛکَّتَا ندٛنُ مَامَعٜنْ مٜىٰطٜنْ؟ نغَمْ ٻٜ لٛوتَتَا جُوطٜ مَٻّٜ کٛ ٻٜ ڤُطَّ ݧَامُکِ ݧَمْندُ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","سٜيْ يٜىٰسُ نٛوتِي، وِعِٻٜ، ‏«‏اٛنٛنْ مَا، نغَمْ طُمٜ اٛنْ تٛکَّتَا کٛ اَللَّه وِعِ نغَمْ ندٛنُ مٛوطٛنْ؟ ");
INSERT INTO fuv_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","نغَمْ اَللَّه وِعِي، ‏‹‏حٛکُّ ݧَاکٛ مَاطَ اٜ مَدُوجٛ مَاطَ مَنْغُ،›‏ ندٜنْ، ‏‹‏کٛو مٛيٜ حُطِ ݧَاکٛ مُوطُمْ کٛو مَدُوجٛ مُوطُمْ دٛولٜ وَرٜىٰ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","اَمَّا اٛنٛنْ اٛنْ مبِعَ تٛ نٜطّٛ وِعِي ݧَاکٛ مُوطُمْ کٛو مَدُوجٛ مُوطُمْ، ‏‹‏فُو کٛ کٛکَّيْنٛمَامِ، مِ حٛکِّيطُمْ اَللَّه،›‏ تٛو، نَاع دٛولٜ نٜطّٛ اٛنْ مَوْنِنَ ݧَاکٛ مَاکٛ وٛنْ طٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","نٛنْ نغَرْتِرْطٛنْ وٛلْدٜ اَللَّه مٜىٰرٜ نغَمْ ندٛنُ مٛوطٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","اٛنٛنْ مُنَافُکِعٜنْ!‏ اِشَايَ وِعِي غٛونغَ ندٜ اٛ وَطِ اَنَّبَاکُ دٛوْ مٛوطٛنْ وِيکِ، ");
INSERT INTO fuv_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","اَللَّه وِعِي، ‏‹‏ٻٜنْ طٛنْ يِمْٻٜ اٜ حٛنْدُکٛ تَنْ ٻٜ مَوْنِنْتَيَمْ، اَمَّا ٻٜرْطٜ مَٻّٜ اٜ نغٛطِّتِييَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","اٜ مٜىٰرٜ ٻٜ مَوْنِنْتَيَمْ؞ اٜ ٻٜ اٜکِّتِنَ دٛوکَ يِمْٻٜ بٛ تٛ اَمْ طُمْ پِوٛيِ؞›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","سٜيْ يٜىٰسُ نٛدِّ يِمْٻٜ حَوْرُتُٻٜ، وِعِٻٜ، ‏«‏کٜتِّندٜىٰ، ڤَامٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","نَاع کٛ نَتَّتَ نٜطّٛ اٜ حٛنْدُکٛ وَرْتِرْتَ ٻٜرْندٜ مَاکٛ ندٜ لَاٻَا يٜىٰسٛ اَللَّه، اَمَّا کٛ وُرْتٛيْتٛو دَغَ ندٜرْ حٛنْدُکٛ مَاکٛ وَرْتِرْتَمٛ مٛ لَاٻَا يٜىٰسٛ اَللَّه؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","سٜيْ تٛکُّٻٜمٛ نغَرِ تٛ مَاکٛ، مبِعِمٛ، ‏«‏اَ اَنْدِ فَارِسَنْکٛعٜنْ نَنِي مٛنّٜرٜ ندٜ ٻٜ نَنِ کَنْ طٛنْ حَالَ کَ مبِيطَا؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","يٜىٰسُ نٛوتِي، وِعِ، ‏«‏فُو اَوْرٜ ندٜ طُمْ اَاوِ، تٛ نَاع ݧَاکٛ اَمْ مٛ دٛوْ اَاوِندٜ، طُمْ طٛوفَيْندٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","اَلٜىٰٻٜ!‏ ٻٜ وُمْٻٜ اَرْدِيٻٜ وُمْٻٜ؞ تٛ بُمْطٛ اَرْدَکٜ بُمْطٛ، ٻٜ فُو طِطٛ ٻٜ نجَنَيْ ندٜرْ نغَيْکَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","سٜيْ بِيتُرُسْ وِعِمٛ، ‏«‏وِعُمِنْ مَعَنَ طُعُمْ مِسَالُ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","يٜىٰسُ وِعِٻٜ، ‏«‏حَا جٛونِ اٛنٛنْ مَا اٛنْ ڤَامَايِ؟ ");
INSERT INTO fuv_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","اٛنْ اَنْدَا فُو کٛ نَتِّ ندٜرْ حٛنْدُکٛ نٜطّٛ ندٜرْ رٜىٰدُ مَاکٛ طُمْ نَتِّ، ندٜنْ طُمْ وُرْتٛتٛ؟ ");
INSERT INTO fuv_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","اَمَّا کٛ وُرْتٛيِي ندٜرْ حٛنْدُکٛ، دَغَ ندٜرْ ٻٜرْندٜ طُمْ پِوٛيِ؞ کَنْجُمْ وَرْتِرْتَ نٜطّٛ مٛ لَاٻَا يٜىٰسٛ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","نغَمْ دَغَ ندٜرْ ٻٜرْندٜ نٜطّٛ ݧُمٛ کَلُّنغٛ وُرْتٛيْتٛو، اٜ وَرْحٛورٜ، اٜ نجٜىٰنُ، اٜ نجٜىٰنُ حَکُّندٜ يِمْٻٜ ٻٜ نغَلَا تٜىٰغَلْ، اٜ نغُيْکَ، اٜ شٜيْدَ فٜوْرٜ، اٜ وٛنُّکِ اِنْدٜ نٜطّٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","طُعُمْ کَنْجُمْ وَرْتِرْتَ نٜطّٛ مٛ لَاٻَا يٜىٰسٛ اَللَّه، اَمَّا ݧَامُکِ ݧَمْندُ اٜ جُوطٜ طٜ لٛوتَاکَ نَاع کَنْجُمْ وَرْتِرْتَ نٜطّٛ مٛ لَاٻَا يٜىٰسٛ اَللَّه؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","يٜىٰسُ اَلِ طٛنْ يَحِ حَادٜ غَرِيجٜ تَايَ اٜ سِدٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","سٜيْ رَا غٛطّٛ کَنْعَانِيَنْکٜىٰجٛ دٜبّٛ نٜطّٛ لٜيْدِ ندِنْ وَرِ نٛدِّ سٜمْبٜىٰ، وِعِ، ‏«‏مٛودِبّٛ، ٻِي دَوْدَ، يُرْمِنَنَمْ!‏ وٛنْغٛلْ غِنّٛلْ اٜ تٛرَّ ٻِطّٛ اَمْ سُرْبَاجٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","اَمَّا يٜىٰسُ وِعَايِمٛ غٛطُّمْ؞ سٜيْ تٛکُّٻٜمٛ نغَرِ تٛرِيمٛ، مبِعِ، ‏«‏رِيوُمٛ، نغَمْ اٜ مٛ تٛکِّعٜنْ اٜ مٛ وَنَّعٜنْ اٜ وُلُّکِ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","سٜيْ اٛ وِعِ دٜبّٛ اٛنْ، ‏«‏مِ لِلٛيَاکَ تٛ وٛٻّٜ، سٜيْ تٛ بَالِ مَجُّطِ طِ لٜݧٛلْ اِسْرَاعِيلَ تَنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","اَمَّا اٛ وَرِ اٛ دِشِّي يٜىٰسٛ يٜىٰسُ، اٛ وِعِ، ‏«‏مٛودِبّٛ، وَلَّمْ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","يٜىٰسُ نٛوتِي، وِعِ، ‏«‏طُمْ حَانَايِ طُمْ حٛشَّ ݧَمْندُ ٻِکّٛيْ طُمْ حُبَنٛوندُ کُتِحٛيْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","اٛ وِعِ، ‏«‏اٜىٰ، طُمْ نٛنْ، مٛودِبّٛ، اَمَّا کٛو کُتِحٛيْ اٜ ݧَامَ حٛرَانٛ جَنُطُمْ دَغَ تٜىٰبُرْ جٜيْطٛکٛيْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","سٜيْ يٜىٰسُ نٛوتِي، وِعِمٛ، ‏«‏حٛولَارٜ مَاطَ اٜ طُوطِ!‏ طُمْ وَطَنْتٜ نٛ نغِطَّا؞»‏ طٛنْ اٜ طٛنْ ٻِطّٛ مَاکٛ يَمْطِتِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","يٜىٰسُ اُمِّي، اَلِ طٛنْ، تٛکِّ حَادٜ مبٜىٰلَ غَلِيلِ، اٛ پٜنْتِ دٛوْ حٛشّٜىٰرٜ اٛ جٛوطِي؞ ");
INSERT INTO fuv_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","يِمْٻٜ طُطْٻٜ نغَرِ تٛ مَاکٛ، ٻٜ نغَدّٛيِ ٻٜ کٛيْطٜ جَرَاطٜ، اٜ وُمْٻٜ، اٜ لَپٛوٻٜ، اٜ ٻٜ مبَاوَتَا مٜتُکِ، اٜ وٛٻّٜ طُطْٻٜ غٛودُٻٜ ݧَوُوجِ؞ ٻٜ ندٜسِٻٜ يٜىٰسٛ مَاکٛ، سٜيْ اٛ يَمْطِتِنِٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","يِمْٻٜ کَيْطِنِ ندٜ نغِعِ يِمْٻٜ ٻٜ مٜتَتَا اٜ مٜتَ، لَپٛوٻٜ اٜ نجَحَ، ٻٜ کٛيْطٜ جَرَاطٜ اٜ نجَاٻَ، وُمْٻٜ اٜ نغِعَ؞ سٜيْ ٻٜ مَنْتِ اَللَّه اِسْرَاعِيلَ؞ ");
INSERT INTO fuv_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","سٜيْ يٜىٰسُ نٛدِّ تٛکُّٻٜمٛ، وِعِٻٜ، ‏«‏اٜ مِ نَنَ جُرُمْطُمْ يِمْٻٜ ٻٜعٜ نغَمْ حَنْدٜ بَلْطٜ مَٻّٜ تَتِ اٜ ٻٜ نغٛنْدِ اٜ اَمْ، اَمَّا ٻٜ نغَلَا کٛ ٻٜ ݧَامَتَ؞ مِ يِطَا ٻٜ ندِلِّدَ اٜ وٜىٰلٛ، نغَمْ طُمْ سَطَا ٻٜ ڤٜکّٛرَ دٛوْ طَتَلْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","سٜيْ تٛکُّٻٜمٛ مبِعِمٛ، ‏«‏تٛيٜ مِنْ کٜٻٛيْتَ بُرٛودِ ندٜرْ لَدّٜ ندٜعٜ کٜپَيْطُمْ يِمْٻٜ طُطْٻٜ ٻٜعٜ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","يٜىٰسُ پَمِٻٜ وِعِ، ‏«‏بُرٛودِ نٛيٜ نغٛودُطٛنْ؟»‏ ٻٜ مبِعِ، ‏«‏بُرٛودِ جٛوٜىٰطِطِ اٜ لِپِّ سٜطَّ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","سٜيْ اٛ وِعِ يِمْٻٜ حَوْرُتُٻٜ ٻٜنْ فُو ٻٜ نجٛوطٛو اٜ لٜيْدِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","اٛ حٛشِّ بُرٛودِ جٛوٜىٰطِطِ طُمْ اٜ لِپِّ طِنْ، اٛ يٜتِّ اَللَّه، اٛ سٜنْدِطُمْ، اٛ حٛکِّ تٛکُّٻٜمٛ، کَمْٻٜ بٛو ٻٜ نغٜىٰدَنِ يِمْٻٜ ٻٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","يِمْٻٜ ٻٜنْ فُو ݧَامِ کَارِ؞ غَطَ مَاجُمْ تٛکُّٻٜمٛ مٛٻْتِ کٛ حٛرِي، طُمْ حٜىٰوِ کٛنْدٛوجٜ جٛوٜىٰطِطِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","ݧَمْٻٜ ٻٜنْ وٛرْٻٜ تَنْ نغَطِ ‏4,000، رٜوْٻٜ اٜ سُکَاٻٜ لِمَاکَ؞ ");
INSERT INTO fuv_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","غَطَ يٜىٰسُ جَٻِّتَکٜ حَوْرُتُٻٜ ٻٜنْ، سٜيْ اٛ نَتِّ کٛمِوَلْ، اٛ دِلِّ لٜيْدِ مَغَدَنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","فَارِسَنْکٛعٜنْ اٜ سَادُسَنْکٛعٜنْ نغَرِ تٛ يٜىٰسُ، اٜ ٻٜ نغِطِ فٛوندُکِمٛ، سٜيْ ٻٜ مبِعِمٛ اٛ وَطَنَٻٜ غٛطُّمْ کَيْطِنِيطُمْ پِوٛيْطُمْ تٛ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","يٜىٰسُ نٛوتِي، وِعِٻٜ، ‏«‏تٛ نَانغٜ حِيرِي، دٛوْ وٛوجِي، اٛنْ مبِعَ، ‏‹‏جَانغٛ نجَيْرِ وٛوطَيْ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","طٛنْمَا تٛ سُبَکَ وَطِي اٛنْ نغِعِي دٛوْ وٛوجِي اٜ وٛودِ دُولٜ کٛو تٛيٜ، اٛنْ مبِعَ، ‏‹‏حَنْدٜ طُمْ وَطَيْ اِيٜىٰندٜ؞›‏ اٛنْ مبَاوِ رَارُکِ کٛ وٛنِ اٜ دٛوْ اَنْدٛنْ کٛ وَطَتَ، اَمَّا اٛنْ مبَاوَتَا فَامُکِ مَعَنَ کُوطٜ طٜ نغَطَيْمِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","يِمْٻٜ جَامَنُ طُعُمْ کَلُّٻٜ ٻٜ کُلَتَا اَللَّه، اٜ ٻٜ نغِطِ حٛلّٜىٰکِ غٛطُّمْ کَيْطِنِيطُمْ، اَمَّا وَلَا کٛ طُمْ حٛلَّتَٻٜ سٜيْ نِ کٛ حٜٻُنٛ اَنَّبِ اِنُوسَ؞»‏ سٜيْ اٛ اَلِٻٜ اٛ دِلِّ؞ ");
INSERT INTO fuv_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","ندٜ تٛکُّٻٜمٛ کُولِ فٛنْغٛ مبٜىٰلَ، ٻٜ نغِعِ ٻٜ نغٜجِّتِي ٻٜ نغَرْدٛيَ اٜ بُرٛودِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","سٜيْ يٜىٰسُ وِعِٻٜ، ‏«‏ڤَامٜىٰ، نغَطٜىٰ حَکِّيلٛ اٜ پُوفِنِرْطُمْ فَارِسَنْکٛعٜنْ اٜ سَادُسَنْکٛعٜنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","سٜيْ تٛکُّٻٜمٛ مٜدِّ حَکُّندٜ مَٻّٜ، ٻٜ مبِعِ، ‏«‏اٛ وِعُ نٛنْ نغَمْ اٜنْ نغَدَّايِ بُرٛودِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","ندٜ يٜىٰسُ فَامِ کٛ ٻٜ مبِعَتَ، سٜيْ اٛ پَمِٻٜ، اٛ وِعِي، ‏«‏اٛنٛنْ غٛودُٻٜ حٛولَارٜ سٜطَّ، نغَمْ طُمٜ مٜدّٛتٛنْ دٛوْ اٛنْ نغَلَا بُرٛودِ؟ ");
INSERT INTO fuv_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","حَا جٛونِ اٛنْ ڤَامَايِ؟ اٛنْ شِفْتٛرَايِ نٛ ݧَمْنِرْمِ يِمْٻٜ ‏5,000 اٜ بُرٛودِ جٛوِ، اٜ کٛنْدٛوجٜ سَڤّٛ اٜ طِطِ طٜ ٻٛڤْتُطٛنْ اٜ کٜىٰوِ حٛرَانٛ؟ ");
INSERT INTO fuv_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","طٛنْمَا اٛنْ شِفْتٛرَايِ نٛ ݧَمْنِرْمِ يِمْٻٜ ‏4,000 اٜ بُرٛودِ جٛوٜىٰطِطِ، اٜ کٛنْدٛوجٜ جٛوٜىٰطِطِ طٜ ٻٛڤْتُطٛنْ اٜ کٜىٰوِ حٛرَانٛ؟ ");
INSERT INTO fuv_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","نٛ طُمْ وَطِ اٛنْ ڤَامَايِ نَاع دٛوْ بُرٛودِ مٜتَيْمِ؟ مِ وِعِي ڤَامَنٜىٰ پُوفِنِرْطُمْ فَارِسَنْکٛعٜنْ اٜ سَادُسَنْکٛعٜنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","ندٜنْ تٛکُّٻٜمٛ کٜٻْتِ نَاع اٜ مٛ مٜتَنَٻٜ ٻٜ ڤَامَ دٛوْ پُوفِنِرْطُمْ غَطٜتٜىٰطُمْ ندٜرْ بُرٛودِ، اَمَّا ٻٜ نغَطَ حَکِّيلٛ اٜ اٜکِّتِنٛلْ فَارِسَنْکٛعٜنْ اٜ سَادُسَنْکٛعٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","ندٜ يٜىٰسُ وَرِ لٜيْدِ کَيْسَارِيَ فِلِبِ، سٜيْ اٛ پَمِ تٛکُّٻٜمٛ، اٛ وِعِ، ‏«‏مٛيٜ يِمْٻٜ مبِعَتَ ٻِي نٜطّٛ وٛنِ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","سٜيْ ٻٜ مبِعِ، ‏«‏وٛٻّٜ اٜ مبِعَ اَ يَحَيَ غَطٛووٛ بَڤْتِسْمَ؞ وٛٻّٜ بٛو اٜ مبِعَ اَ اَنَّبِ اِلِيَ؞ ندٜنْ وٛٻّٜ اٜ مبِعَ اَ اَنَّبِ اِرْمِيَ کٛو غٛعٛتٛ ندٜرْ اَنَّبٛعٜنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","اٛ وِعِٻٜ، ‏«‏اَمَّا اٛنٛنْ، مٛيٜ مبِعٛتٛنْيَمْ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","سٜيْ سِيمَنْ بِيتُرُسْ نٛوتِي، وِعِ، ‏«‏اَنْ وٛنِ اَلْمَسِيحُ، ٻِطّٛ اَللَّه مٛ يٛنْکِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","يٜىٰسُ نٛوتِي وِعِمٛ، ‏«‏اَ بَرْکِطِنَاطٛ، سِيمَنْ ٻِي اِنُوسَ، نغَمْ نَاع طُمْ نٜطّٛ وِعِمَاکَ، سٜيْ نِ ݧَاکٛ اَمْ مٛ دٛوْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","اٜ مِ وِعِمَا، اَنْ وٛنِ بِيتُرُسْ، وَاتٛ تَفَارٜ؞ دٛوْ تَفَارٜ ندٜنْ نجٛوطِنَيْمِ تٛکُّٻٜيَمْ؞ مَيْدٜ فُو اٜ بَوْطٜ مَيْرٜ وَاوَتَا جَالٛوٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","مِ حٛکّٜتٜ مَٻِّتِرْکٛيْ لَامُ اَللَّه، فُو کٛ کَطُطَا اٜ دُونِيَارُ، اَللَّه مٛ دٛوْ جَٻِ؞ طٛنْمَا فُو کٛ اَلُطَا طُمْ وَطَ اٜ دُونِيَارُ، اَللَّه مٛ دٛوْ جَٻِي؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","سٜيْ يٜىٰسُ حَطِ تٛکُّٻٜمٛ تٛع ٻٜ مبِعَکَ کٛو مٛيٜ کَنْکٛ وٛنِ اَلْمَسِيحُ؞ ");
INSERT INTO fuv_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","دَغَ نغٜلْ طٛنْ شَرٜلْ يٜىٰسُ فُطِّ وِيکِ تٛکُّٻٜمٛ دٛولٜ اٛ يَحَ اُرُشَلِيمَ، اٛ يَرَ بٛنٜ طُطُّمْ تٛ جُوطٜ مَوْٻٜ يِمْٻٜ، اٜ مَوْٻٜ اَرْدِيٻٜ دِينَ، اٜ مٛودِٻّٜ اَتَّوْرَ، ندٜنْ اٛ وَرٜىٰ؞ ندٜرْ ݧَلْندٜ تَتَوْرٜ بٛو طُمْ اُمِّنَيْمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","سٜيْ بِيتُرُسْ نٛدِّمٛ وُتُّدُ غٛعٛ فُطِّ حَٻَنْکِمٛ، اٜ وِعَ، ‏«‏اَللَّه حٛيْنَ، مٛودِبّٛ!‏ نٛنْ حٜٻَتَامَ حَا اَبَدَا!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","اَمَّا يٜىٰسُ وَيْلِتِي، وِعِ بِيتُرُسْ، ‏«‏سٜنْدِرْ اٜ اَمْ، اَنْ شٜيْطَنْ!‏ اَ کَطَيْطٛيَمْ وَطُکِ کٛ اَللَّه يِطِ، نغَمْ نَاع تٛ اَللَّه ݧُمٛ مَاطَ پِوٛيِ، اِرِ ݧُمٛ يِمْٻٜ ݧُمَتَا؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","سٜيْ يٜىٰسُ وِعِ تٛکُّٻٜمٛ، ‏«‏فُو غِطّٛ وَرْتَ تٛکُّطٛيَمْ، دٛولٜ وَݧَ حٛورٜ مُوطُمْ، حٛشَّ غَافَانغَلْ مُوطُمْ، تٛکَّيَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","نغَمْ فُو غِطّٛ حِسْنُکِ يٛنْکِ مُوطُمْ اٛ دُلَّيْکِ؞ اَمَّا فُو دُلَّيْطٛ يٛنْکِ مُوطُمْ نغَمْ اَمْ اٛ حٜٻَيْکِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","کٛ طُمْ نَفَنْتَ نٜطّٛ تٛ اٛ حٜٻِي دُونِيَارُ فُو، اَمَّا دُلِّي يٛنْکِ مَاکٛ؟ کٛو بٛو کٛ نٜطّٛ وَاوَتَ حٛکُّکِ نغَمْ جَٻْتٛيَ يٛنْکِ مُوطُمْ؟ ");
INSERT INTO fuv_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","نغَمْ ٻِي نٜطّٛ وَرَيْ ندٜرْ تٜدُّنغَلْ ݧَاکٛ مُوطُمْ مٛ دٛوْ اٜ مَلَاعِکَعٜنْ مَاکٛ، اٛ وَاتَنَيْ کٛو مٛيٜ کٛ وَطِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","اٜ مِ وِعَعٛنْ غٛونغَ، اٜ وٛودِ وٛٻّٜ دَرِيٻٜ طٛعٛ ٻٜ مَايَتَا نَا ٻٜ نغِعِي ٻِي نٜطّٛ اٜ وَرٛيَ ندٜرْ لَامُ مُوطُمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","غَطَ بَلْطٜ جٛوٜىٰغٛعٛ، سٜيْ يٜىٰسُ حٛشِّ بِيتُرُسْ اٜ يَاکُبُ اٜ مِݧِرَاوٛ مَاکٛ يَحَيَ، اٛ يَارِٻٜ دٛوْ وٛنْدٜ حٛشّٜىٰرٜ تٛوْندٜ کَمْٻٜ تَنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","سٜيْ نَنْدِ مَاکٛ وَيْلِتِ يٜىٰسٛ مَٻّٜ؞ يٜىٰسٛ مَاکٛ اٜ طٜلْکِتٛو بٛ نَانغٜ؞ کٛلْتٜ مَاکٛ نغَرْتِ دَنٜىٰجٜ تَرْ بٛ جَيْنغٛلْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","طٛنْ اٜ طٛنْ سٜيْ اَنَّبِ مُوسَ اٜ اَنَّبِ اِلِيَ وَنْغَنِٻٜ اٜ ٻٜ مٜدَّ اٜ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","سٜيْ بِيتُرُسْ وِعِ يٜىٰسُ، ‏«‏مٛودِبّٛ، وٛنْکِ اَمِنْ طٛعٛ اٜ وٛوطِ؞ اَلْ مِنْ ݧِٻَ شُوطِ تَتِ طٛعٛ، وٛعٛيْرُ ندُ مَاطَ، وٛعٛيْرُ ندُ مُوسَ، ندٜنْ وٛعٛيْرُ ندُ اِلِيَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","اٜ مٛ ندٜرْ مٜتُکِ، سٜيْ رَا وٛنْغَ ندُولَ طٜلْکِتٛتٛونغَ وَرِ سُدِّٻٜ؞ ٻٜ نَنِ حٛنٛنْدٜ اَللَّه دَغَ ندٜرْ مَاغَ، وِعِ، ‏«‏اٛعٛ وٛنِ ٻِطّٛ اَمْ مٛ نغِطُمِ؞ اٜ مِ نَنَ بٜلْطُمْ مَاکٛ نَاع سٜطَّ؞ نَنٜىٰ کٛ اٛ وِعَتَعٛنْ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","ندٜ تٛکُّٻٜمٛ نَنِ حٛنٛنْدٜ ندٜنْ، کُلٛلْ مَنْغٛلْ نَنْغِٻٜ ٻٜ نجَنِ اٜ لٜيْدِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","سٜيْ يٜىٰسُ وَرِ مٜىٰمِٻٜ، وِعِ، ‏«‏اُمّٜىٰ، تٛع اٛنْ کُلُ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","ندٜ ٻٜ پٜفْتِ کٛعٜ، ٻٜ نغِعَايِ غٛطّٛ سٜيْ يٜىٰسُ تَنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","اٜ ٻٜ نجِڤّٛيٛو دَغَ دٛوْ حٛشّٜىٰرٜ ندٜنْ، سٜيْ يٜىٰسُ وَغِّنِٻٜ، وِعِ، ‏«‏تٛع اٛنْ مبِعُ غٛطّٛ کٛ نغِيطٛنْ نَا طُمْ اُمِّنِ ٻِي نٜطّٛ دَغَ مَيْدٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","تٛکُّٻٜمٛ پَمِمٛ، مبِعِ، ‏«‏تٛو، نغَمْ طُمٜ مٛودِٻّٜ اَتَّوْرَ اٜ مبِعَ دٛولٜ اَنَّبِ اِلِيَ اَرْتَ اَلْمَسِيحُ وَرْکِ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","اٛ نٛوتِي، اٛ وِعِ، ‏«‏غٛونغَ اَنَّبِ اِلِيَ اَرْتَيْ وَرْکِ، نغَمْ اٛ سِرْيٛو کٛو طُمٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","اَمَّا اٜ مِ وِعَعٛنْ، اِلِيَ يَادَکٜ وَرِي، ٻٜ بٛو کٜٻْتَايِ طُمْ کَنْکٛ، اَمَّا ٻٜ نغَطَنِمٛ فُو کٛ ٻٜ نغِطِ؞ نٛنْ مَا ٻِي نٜطّٛ يَرَيْ بٛنٜ اٜ جُوطٜ مَٻّٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","ندٜنْ تٛکُّٻٜمٛ ڤَامِ اٜ مٛ مٜتَنَٻٜ دٛوْ يَحَيَ غَطٛووٛ بَڤْتِسْمَ؞ ");
INSERT INTO fuv_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","ندٜ ٻٜ نجٛتِّي تٛ يِمْٻٜ طُطْٻٜ کَوْرِتِ، سٜيْ غٛطّٛ نٜطّٛ وَرِ تٛ يٜىٰسُ دِشِّي يٜىٰسٛ مَاکٛ وِعِ، ");
INSERT INTO fuv_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","‏«‏مٛودِبّٛ، يُرْمِنَنْ سُکَ اَمْ اٜ وٛودِ ݧَوُ ڤَطّٜ، اٜ مٛ تٛرّٛو نَاع سٜطَّ؞ ندٜ طُطُّمْ اٜ مٛ يَنَ ندٜرْ حِيتٜ اٜ ندٜرْ ندِيَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","مِ يَارِيمٛ تٛ تٛکُّٻٜمَ، اَمَّا ٻٜ مبَاوَايِ يَمْطِتِنْکِمٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","سٜيْ يٜىٰسُ نٛوتِي وِعِ، ‏«‏اٛنٛنْ يِمْٻٜ جَامَنُ طُعُمْ کَلُّطُمْ اٛنْ کٛولَاکِيَمْ، حَا ندٜيٜ نجٛوطٛدٛتٛومِ اٜ مٛوطٛنْ اٜ مِ مُݧِدَ اٜ مٛوطٛنْ؟ نغَدَّنٜىٰيَمْ سُکَ اٛنْ طٛعٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","سٜيْ يٜىٰسُ حَٻَنِ غِنّٛلْ نغٛلْ، نغٛلْ وُرْتِي سُکَ اٛنْ، طٛنْ اٜ طٛنْ اٛ يَمْطِتِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","سٜيْ تٛکُّٻٜمٛ نغَرِ تٛ مَاکٛ کَمْٻٜ تَنْ، ٻٜ پَمِمٛ ٻٜ مبِعِ، ‏«‏نغَمْ طُمٜ مِنٛنْ مِنْ مبَاوَايِ وُرْتِنْکِ غِنّٛلْ نغٛلْ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","يٜىٰسُ نٛوتِي وِعِٻٜ، ‏«‏نغَمْ حٛولَارٜ مٛوطٛنْ فَمْطِي؞ اٜ مِ وِعَعٛنْ غٛونغَ، دَا اٛنْ نغٛودِ حٛولَاکِ فَمْطِرْکِ بٛ غَبّٜلْ مَسْتَتْ، اٛنْ مبَاوَيْ مبِعٛنْ حٛشّٜىٰرٜ ندٜعٜ، ‏‹‏اِتَّ دَغَ طٛعٛ، يَحُ طَاعٜ،›‏ سٜيْ ندٜ وَطَ کٛ مبِيطٛنْ؞ وَلَا بٛو کٛ سَلٛرْتَعٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","‏‏اَمَّا اِرِ نغٛعٛلْ غِنّٛلْ نغٛلْ وُرْتَتَاکٛ سٜيْ اٜ دٛعَارٜ اٜ سُومَاکِ؞‏»‏ ");
INSERT INTO fuv_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","ندٜ يٜىٰسُ اٜ تٛکُّٻٜمٛ کَوْرِتِ اٜ لٜيْدِ غَلِيلِ، سٜيْ اٛ وِعِٻٜ، ‏«‏طُمْ حٛکِّتِرَيْ ٻِي نٜطّٛ ندٜرْ جُوطٜ يِمْٻٜ، ");
INSERT INTO fuv_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ٻٜ مبَرَمٛ، اٜ ݧَلْندٜ تَتَوْرٜ طُمْ اُمِّنَيْمٛ؞»‏ سٜيْ فِي طُمْ وَنِّ تٛکُّٻٜمٛ نَاع سٜطَّ؞ ");
INSERT INTO fuv_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","ندٜ يٜىٰسُ اٜ تٛکُّٻٜمٛ نجٛتِّي غَرِيرِ کَفَرْنَحُمْ، جَٻٛوٻٜ شٜىٰدٜ نغَمْ وُرٛ شٜنِينغٛ نغَرِ تٛ بِيتُرُسْ، ٻٜ مبِعِمٛ، ‏«‏مٛودِبّٛ مٛوطٛنْ اٜ حٛکَّ شٜىٰدٜ وَلُّکِ وُرٛ شٜنِينغٛ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","اٛ وِعِ، ‏«‏اٜىٰ، اٜ مٛ حٛکَّ؞»‏ ندٜ بِيتُرُسْ وَرْتِ وُرٛ، سٜيْ يٜىٰسُ اَرْتِ مٜتَنْکِمٛ، وِعِ، ‏«‏نٛ نغِيطَا، بِيتُرُسْ؟ تٛ ٻٜيٜ لَامِيٻٜ دُونِيَارُ ندُعُ نجَٻَتَ شٜىٰدٜ لٜيْدِ، تٛ ٻِٻّٜ مَٻّٜ کٛو تٛ وٛٻّٜ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","ندٜ بِيتُرُسْ وِعِ، ‏«‏تٛ وٛٻّٜ،»‏ سٜيْ يٜىٰسُ وِعِ، ‏«‏تٛو، ٻِٻّٜ مَٻّٜ نجٛٻَتَا وٛنْ طٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","فُو اٜ نٛنْ، نغَمْ تٛع ٻٜ نَنَ مٛنّٜرٜ مٜىٰطٜنْ، يَحُ مبٜىٰلَ نغَطَا نَنْغِرْطُمْ لِپِّ مَاطَ؞ فُو لِنْغُ نغُ اَرْتُطَا نَنْغُکِ، مَٻُّتُ حٛنْدُکٛ مَاغُ اَ تَوَيْ يَمْندٜ اَجُرْفَارِ ندٜرْ؞ حٛشُّندٜ، کٛکَّاٻٜ نجٛٻَارِ وُرٛ شٜنِينغٛ نغَمْ مِنْ اٜ مَاطَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","اٜ نغٜلْ طٛنْ شَرٜلْ تٛکُّٻٜ يٜىٰسُ نغَرِ پَمِمٛ، مبِعِ، ‏«‏مٛيٜ ٻُرِ مَنْغُ فُو ندٜرْ لَامُ اَللَّه؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","سٜيْ يٜىٰسُ نٛدِّ وٛنْغٜلْ سُکَيٜلْ ڤَمَرٜلْ دَرْنِنغٜلْ شَکَ مَٻّٜ، ");
INSERT INTO fuv_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","وِعِ، ‏«‏اٜ مِ وِعَعٛنْ غٛونغَ، تٛ نَاع اٛنْ لٜسْتِنْ کٛعٜ مٛوطٛنْ نغَرْتُطٛنْ بٛ سُکَحٛيْ، اٛنْ نَتَّتَا لَامُ اَللَّه کٛو سٜطَّ!‏ ");
INSERT INTO fuv_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","فُو لٜسْتِنْطٛ حٛورٜ مُوطُمْ بٛ سُکَيٜلْ ڤَمَرٜلْ نغٜعٜلْ، کَنْکٛ وٛنِ ٻُرْطٛ مَنْغُ ندٜرْ لَامُ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","ندٜنْ فُو جَٻُطٛ سُکَيٜلْ ڤَمَرٜلْ بٛ نغٜعٜلْ ندٜرْ اِنْدٜ اَمْ جَٻِييَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","‏«‏اَمَّا فُو غَطُطٛ غٛعٛتٛ ندٜرْ سُکَاٻٜ ٻٜعٜ کٛولِيٻٜيَمْ وَطِ حَکّٜ، طُمْ ٻُرَنَيْمٛ اٛ حَٻَّنٜىٰ کَاپَ نَمٛلْ مَنْغَ اٜ دَاندٜ مَاکٛ طُمْ فَطَّمٛ ندٜرْ مبٜىٰلَ لُغُّنغَ؞ ");
INSERT INTO fuv_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","دُونِيَارُ وٛنِي نغَمْ اٜ وٛودِ کٛ فٛوطَتَ يِمْٻٜ نغَطَ حَکّٜ!‏ نغَمْ دٛولٜ کٛ فٛوطَتَ يِمْٻٜ نغَطَ حَکّٜ وَرَ، فُو اٜ نٛنْ فٛوطُطٛ غٛطّٛ وَطِ حَکّٜ وٛنِي؞ ");
INSERT INTO fuv_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","‏«‏تٛ جُنْغٛ مَاطَ کٛو کٛيْنغَلْ مَاطَ اٜ وَطُمَا نغَطَا حَکّٜ، تٛو، اِتُّنغٛ ڤَطَّانغٛ، کٛو اِتُّنغَلْ ڤَطَّانغَلْ؞ طُمْ ٻُرَنِيمَ نَتَّا وُرٛ اَللَّه اٜ جُنْغٛ وٛعٛتٛ کٛو کٛيْنغَلْ غٛعٛتَلْ دٛوْ طُمْ حُبٛمَا ندٜرْ حِيتٜ نغٜ ݧِفَتَا حَا اَبَدَا اٜ جُوطٜ طِطِ کٛو کٛيْطٜ طِطِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","تٛ بٛو حِتٜرٜ مَاطَ اٜ وَطُمَا نغَطَا حَکّٜ، اِتُّندٜ ڤَطَّاندٜ؞ طُمْ ٻُرَنِيمَ نَتَّا وُرٛ اَللَّه اٜ حِتٜرٜ غٛعٛ دٛوْ طُمْ حُبٛمَا ندٜرْ وُرٛ حِيتٜ اٜ غِتٜ طِطِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","‏«‏ڤَامٜىٰ، تٛع اٛنْ نجَوَنْ کٛو غٛعٛتٛ ندٜرْ سُکَحٛيْ ڤَمَرٛيْ کٛعٛيْ؞ نغَمْ اٜ مِ وِعَعٛنْ، مَلَاعِکَعٜنْ مَاکٛيْ تٛنْ دٛوْ کٛو ندٜيٜ اٜ ندَارَ يٜىٰسٛ ݧَاکٛ اَمْ مٛ دٛوْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","‏‏ندٜنْ ٻِي نٜطّٛ وَرٛيِي نغَمْ حِسْنَ کٛ مَجِّ؞‏ ");
INSERT INTO fuv_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","‏«‏تٛو، کٛ ݧُمٛتٛنْ؟ تٛ نٜطّٛ اٜ وٛودِ بَالِ 100، سٜيْ غٛعٛ ندٜرْ بَالِ طِنْ مَجِّ، نَاع اٛ اَلَيْ کٛرِيطِ لٜيْ حٛشّٜىٰرٜ، اٛ دِلَّ طَٻُّتُکِ مبَالَ مَجُّنغَ نغَنْ؟ ");
INSERT INTO fuv_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","اٜ مِ وِعَعٛنْ غٛونغَ، تٛ اٛ حٜٻْتٛيِينغَ، بٜلْطُمْ طُمْ اٛ نَنَتَ دٛوْ مَاغَ طُمْ ٻُرِي طُمْ بَالِ کٛرِيطِ طِنْ طِ مٜىٰطَايِ مَجُّکِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","نٛنْ ݧَاکٛ مٛوطٛنْ مٛ دٛوْ يِطَا کٛو غٛعٛتٛ ندٜرْ سُکَاٻٜ ڤَمَرْٻٜ ٻٜعٜ حَلْکَ؞ ");
INSERT INTO fuv_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","‏«‏تٛ بَنْدِرَاوٛ مَاطَ وَطَنِيمَ کٛ وٛوطَا، يَحُ مبِعَامٛ کٛ وٛوطَا طُمْ اٛ وَطَنْمَا، اَنْ اٜ مَاکٛ تَنْ؞ تٛ اٛ جَٻِي، اَ وَرْتِرِي سُمْڤٛ حَکُّندٜ مٛوطٛنْ وٛنْ طٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","اَمَّا تٛ اٛ وَݧِي جَٻُکِ، سٜيْ فُطِّتَا شٛعّٛدٛطَا اٜ نٜطّٛ غٛعٛتٛ کٛو طِطٛ تٛ مَاکٛ، نغَمْ ‏‹‏دٛولٜ طُمْ حٜٻَ شٜيْدُعٜنْ طِطٛ کٛو تَتٛ کٛ طُمْ تَبِّتِنَ حَالَ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","تٛ بٛو اٛ وَݧِي کٛ ٻٜ مبِعِ کَمْٻٜ مَا، سٜيْ مبِعَاکَ کَوْتَلْ تٛکُّٻٜيَمْ؞ طٛنْمَا تٛ اٛ وَݧِي نَنْکِ کَوْتَلْ تٛکُّٻٜيَمْ، حٛشُّمٛ بٛ مٛ اَنْدَا اَللَّه کٛو غٛودُطٛ حَکّٜ غَݧُطٛ تُوبَ؞ ");
INSERT INTO fuv_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","‏«‏اٜ مِ وِعَعٛنْ غٛونغَ، فُو کٛ کَطُطٛنْ اٜ دُونِيَارُ، اَللَّه مٛ دٛوْ جَٻِ؞ طٛنْمَا فُو کٛ اَلُطٛنْ طُمْ وَطَ اٜ دُونِيَارُ، اَللَّه مٛ دٛوْ جَٻِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","‏«‏طٛنْمَا، اٜ مِ وِعَعٛنْ، تٛ يِمْٻٜ طِطٛ ندٜرْ مٛوطٛنْ کَوْتِي کٛعٜ تٛرَکٜ غٛطُّمْ اٜ دُونِيَارُ، ݧَاکٛ اَمْ مٛ دٛوْ وَطَنَيْٻٜطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","نغَمْ تٛ يِمْٻٜ طِطٛ کٛو تَتٛ کَوْرِتِ ندٜرْ اِنْدٜ اَمْ، اٜ مِ وٛنْدِ اٜ مَٻّٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","سٜيْ بِيتُرُسْ ٻَدّٛيِي وِعِ يٜىٰسُ، ‏«‏مٛودِبّٛ، ندٜ نٛيٜ بَنْدِرَاوٛ اَمْ اٜ وَطَنَيَمْ کٛ وٛوطَا اٜ مِ يَافَنٛومٛ؟ ندٜ جٛوٜىٰطِطِ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","يٜىٰسُ نٛوتِي وِعِمٛ، ‏«‏نَاع ندٜ جٛوٜىٰطِطِ تَنْ، اَمَّا جٛوٜىٰطِطِ ندٜ شَڤَّنْطٜ جٛوٜىٰطِطِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","نغَمْ نٛنْ، طُمْ نَنْدِنَيْ لَامُ اَللَّه اٜ غٛطّٛ لَامِيطٛ غِطّٛ لِمَ جَوْدِ مُوطُمْ نغٛنْدِ جُنْغٛ کُوَنٛوٻٜمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","ندٜ اٛ فُطِّ لِمُکِندِ، سٜيْ طُمْ وَدَّنِمٛ غٛطّٛ مٛ اٛ تٛکَّتَ ݧَمَاندٜ شٜىٰدٜ طٜ اٛ وَاوَتَا يٛٻُکِ حَا کٜىٰرٛلْ جٛنْدٜ مَاکٛ اٜ دُونِيَارُ؞ ");
INSERT INTO fuv_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","ندٜ اٛ تَمڤِ يٛٻُکِ، سٜيْ لَامِيطٛ اٛنْ وَطِ طُمْ سٛورَمٛ اٜ دٜبّٛ مَاکٛ اٜ ٻِٻّٜ مَاکٛ اٜ کٛو طُمٜ کٛ اٛ وٛودِ نغَمْ طُمْ يٛٻَ شٜىٰدٜ طٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","سٜيْ مَشُّطٛ اٛنْ دِشِّي يٜىٰسٛ مَاکٛ، تٛرِيمٛ، وِعِ، ‏‹‏وَطُ مُݧَلْ؞ مِ يٛٻٜتٜ کٛو طُمٜ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","سٜيْ لَامِيطٛ اٛنْ نَنِ جُرُمْطُمْ مَشُّطٛ اٛنْ يَافَنِيمٛ ݧَمَاندٜ ندٜنْ يٛوفِمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","‏«‏اَمَّا مَشُّطٛ اٛنْ اٜ وُرْتَاکِ مَاکٛ اٛ تَوِ غٛطّٛ مٛ اٛ حُودَتَ مٛ اٛ تٛکَّتَ ݧَمَاندٜ شٜىٰدٜ طٜ طُمْ يٛٻَتَ کُوٛووٛ تٛ نغٜسَ لٜبِّ جٛوِ؞ اٛ طٜطَّنِمٛ دَاندٜ، اٛ وِعِمٛ، ‏‹‏يٛٻَمْ کٛ تٛکَّيْمَامِ!‏›‏ ");
INSERT INTO fuv_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","سٜيْ مٛ اٛ حُودَتَ اٛنْ دِشِّ تٛرِيمٛ، وِعِ، ‏‹‏وَطَنَمْ مُݧَلْ مِ يٛٻٜتٜ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","اَمَّا اٛ وَݧِ، اٛ وَطِ طُمْ مَٻِّمٛ ندٜرْ سُودُ شُرَلْ سٜيْ ندٜ اٛ يٛٻِمٛ کٛ اٛ تٛکَّتَمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","ندٜ حِغٛوٻٜ کُوغَلْ مَاکٛ نغِعِ نٛنْ، ٻٜ نغَنِّ نَاع سٜطَّ؞ سٜيْ ٻٜ نجَحِ ٻٜ مبِعِکَ لَامِيطٛ اٛنْ فُو کٛ وَطِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","‏«‏سٜيْ لَامِيطٛ اٛنْ نٛدِّ مَشُّطٛ اٛنْ، وِعِمٛ، ‏‹‏اَنْ اَ مَشُّطٛ کَلُّطٛ!‏ مِ يَافَنَکٜمَ فُو ݧَمَاندٜ ندٜ تٛکَّيْمَامِ نغَمْ اَ تٛرَکٜيَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","تٛو، حَانَايِ نجُرْمِنَنَا مٛ کُودَتَا نٛنْ نٛ نجُرْمِنِرَنْمَامِ؟›‏ ");
INSERT INTO fuv_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","لَامِيطٛ اٛنْ نَنِ مٛنّٜرٜ نَاع سٜطَّ، اٛ وَطِ طُمْ نَنْغِمٛ طُمْ وَطَ کَ تٛرُّکِمٛ نَا اٛ يٛٻِي کٛو طُمٜ کٛ طُمْ تٛکَّتَمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","‏«‏نٛنْ ݧَاکٛ اَمْ مٛ دٛوْ وَطَنْتَ کٛو مٛيٜ مٛوطٛنْ مٛ يَافَنَاکِ بَنْدِرَاوٛ مُوطُمْ اٜ ٻٜرْندٜ غٛعٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","ندٜ يٜىٰسُ حٜىٰݧِ وِيکِ فِي طُعُمْ، سٜيْ اٛ اَلِ لٜيْدِ غَلِيلِ اٛ نَتِّ لٜيْدِ يَحُودِيَ نغٛنْدِ فٛنْغٛ شَانغٛلْ اُرْدُنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","يِمْٻٜ طُطْٻٜ تٛکِّمٛ، اٛ يَمْطِتِنِ ݧَوْٻٜ تٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","سٜيْ وٛٻّٜ فَارِسَنْکٛعٜنْ نغَرِ تٛ مَاکٛ نغَمْ ٻٜ ڤٛوندَمٛ، ٻٜ پَمِمٛ، ٻٜ مبِعِ، ‏«‏اٜ يِيکِ مَاطَ اَتَّوْرَ اَلِي نٜطّٛ يٛوفَ دٜبّٛ مُوطُمْ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","اٛ نٛوتِي، اٛ وِعِ، ‏«‏تٛو، اٛنْ مٜىٰطَايِ جَنْغُکِ اَايَارٜ بِيندٜ تَغُطٛ يِمْٻٜ دَغَ فُطّٛودٜ تَغُکِ اٛ تَغِيٻٜ غٛرْکٛ اٜ دٜبّٛ؟ ");
INSERT INTO fuv_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","اٛ وِعِي، ‏‹‏نغَمْ نٛنْ نٜطّٛ اَلَيْ ݧَاکٛ مُوطُمْ اٜ مَدُوجٛ مُوطُمْ تَکَّنٛو دٜبّٛ مُوطُمْ، کَمْٻٜ طِطٛ ٻٜ نغَرْتَ غٛعٛ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","نغَمْ نٛنْ نَاع ٻٜ طِطٛ کَدِنْ، اَمَّا ٻٜ نغَرْتِي نٜطّٛ غٛعٛتٛ؞ نغَمْ مَاجُمْ کٛ اَللَّه حَوْتِ، تٛع نٜطّٛ سٜنْدَطُمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","سٜيْ ٻٜ مبِعِمٛ، ‏«‏تٛو، نغَمْ طُمٜ اَنَّبِ مُوسَ وِعِ نٜطّٛ وِنْدَنَ دٜبّٛ مُوطُمْ طٜرٜوٛلْ وَرْکِ تٜىٰغَلْ وِعَمٛ اٛ دِلَّ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","سٜيْ يٜىٰسُ وِعِٻٜ، ‏«‏نغَمْ ٻٜرْطٜ مٛوطٛنْ طٜ شَاتُطٜ وَطِ مُوسَ اَلِعٛنْ نجٛوفٛنْ رٜوْٻٜ مٛوطٛنْ، اَمَّا نَاع نٛنْ طُمْ وٛنِ دَغَ اَرَنْدٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","اٜ مِ وِعَعٛنْ، کٛو مٛيٜ يٛوفِ دٜبّٛ مُوطُمْ، تٛ نَاع نجٜىٰنُ اٛ وَطِ، ندٜنْ تٜعِ غٛطّٛ دٜبّٛ، وَطِي نجٜىٰنُ وٛنْ طٛنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","سٜيْ تٛکُّٻٜمٛ مبِعِمٛ، ‏«‏تٛ نٛنْ طُمْ وٛنِ حَکُّندٜ نٜطّٛ اٜ دٜبّٛ مُوطُمْ، تٛو، شِيَ تٜىٰغَلْ مَا ٻُرِي؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","اَمَّا اٛ وِعِٻٜ، ‏«‏نَاع کٛو مٛيٜ وَاوَتَ جَٻُکِ حَالَ کَعَ، سٜيْ نِ ٻٜ اَللَّه وَوْنِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","نغَمْ اٜ وٛودِ ٻٜ طُمْ دَݧِ نغٛرْغُ مَٻّٜ اٜ وَاتِ؞ اٜ وٛودِ وٛٻّٜ بٛو ٻٜ يِمْٻٜ تَڤِّ؞ ندٜنْ اٜ وٛودِ وٛٻّٜ ٻٜ تٜعَتَا نغَمْ طَٻُّتُکِ لَامُ اَللَّه؞ فُو بَاوَيْطٛ جَٻُکِ حَالَ کَعَ جَٻَکَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","سٜيْ طُمْ وَدَّنِ يٜىٰسُ سُکَحٛيْ ڤَمَرٛيْ نغَمْ اٛ يٛوَنَکٛيْ جُوطٜ اٛ وَطَنَکٛيْ دٛعَارٜ؞ اَمَّا تٛکُّٻٜمٛ کَٻَنِ غَدَّيْٻٜکٛيْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","سٜيْ يٜىٰسُ وِعِٻٜ، ‏«‏اَلٜىٰ سُکَحٛيْ ڤَمَرٛيْ نغَرَ تٛ اَمْ؞ تٛع اٛنْ کَطُکٛيْ، نغَمْ غٛودُٻٜ ٻٜرْطٜ اِرِ طٜ مَاکٛيْ نجٜيِ لَامُ اَللَّه؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","سٜيْ اٛ يٛوَنِکٛيْ جُوطٜ مَاکٛ نغَمْ بَرْکِطِنْکِ، ندٜنْ اٛ دِلِّ؞ ");
INSERT INTO fuv_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","سٜيْ غٛطّٛ ٻَدّٛيِي تٛ يٜىٰسُ وِعِ، ‏«‏مٛودِبّٛ، طُمٜ فِي غٜىٰتُمْ حَانِ مِ وَطَ نغَمْ مِ حٜٻَ يٛنْکِ کِ رٜعَتَا؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","سٜيْ يٜىٰسُ وِعِمٛ، ‏«‏نغَمْ طُمٜ پَمَتَايَمْ دٛوْ غٜىٰتُمْ؟ اٜ وٛودِ غٜىٰتٛ غٛعٛتٛ تَنْ؞ تَا يِطِ کٜٻَا يٛنْکِ کِ رٜعَتَا، تٛکُّ کٛ اَتَّوْرَ وِعِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","سٜيْ اٛ وِعِ يٜىٰسُ، ‏«‏طُمٜ اَتَّوْرَ وِعِ؟»‏ سٜيْ يٜىٰسُ وِعِ، ‏«‏تَاع وَطُ وَرْحٛورٜ؞ تَاع وَطُ نجٜىٰنُ؞ تَاع وُجُّ؞ تَاع حٛکُّ شٜيْدَ فٜوْرٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","حٛکُّ ݧَاکٛ مَاطَ اٜ مَدُوجٛ مَاطَ مَنْغُ؞ يِطُ بَنْدِرَاوٛ مَاطَ نٛ نغِطِرْطَا حٛورٜ مَاطَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","سٜيْ کَيٜىٰجٛ اٛنْ وِعِمٛ، ‏«‏اٜ مِ وَطَ فُو فِي طُعُمْ؞ کٛ حٛرَنِييَمْ کَدِنْ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","يٜىٰسُ وِعِمٛ، ‏«‏تَا يِطِ نغَرْتَا کٜوْطٛ، يَحُ، شٛورَا کٛ نغٛودُطَا فُو، کٛکَّا ٻٜ نغَلَنَا شٜىٰدٜ طٜنْ، ندٜنْ اَ حٜٻَيْ مبَرْجَارِ تٛنْ دٛوْ؞ ندٜنْ نغَرَا، تٛکَّايَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","ندٜ کَيٜىٰجٛ اٛنْ نَنِ نٛنْ، اٛ دِلِّ اٛ نَنَايِ بٜلْطُمْ، نغَمْ اٜ مٛ وٛودِ رِسْکُ طُطُّمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","سٜيْ يٜىٰسُ وِعِ تٛکُّٻٜمٛ، ‏«‏اٜ مِ وِعَعٛنْ غٛونغَ، اٜ طُمْ سَطِ نَاع سٜطَّ دِسْکُطٛ نَتَّ لَامُ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","طٛنْمَا اٜ مِ وِعَعٛنْ، طُمْ ٻُرَيْ حٛيْکِ نغٜىٰلٛوبَ تٛکَّ ندٜرْ يٛلْندٜ بَاتَلْ دٛوْ دِسْکُطٛ نَتَّ لَامُ اَللَّه؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","ندٜ تٛکُّٻٜمٛ نَنِ نٛنْ، ٻٜ کَيْطِنِ نَاع سٜطَّ، ٻٜ مبِعِ، ‏«‏تٛو، تٛ طُمْ نٛنْ، مٛيٜ حِسَتَ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","اَمَّا يٜىٰسُ رَارِٻٜ، وِعِ، ‏«‏تٛ يِمْٻٜ طُمْ وَطَتَاکٛ، اَمَّا تٛ اَللَّه کٛو طُمٜ طُمْ غَطٛتٛوطُمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","سٜيْ بِيتُرُسْ وِعِ، ‏«‏تٛو، رَطُّمْ، مِنٛنْ مِنْ اَلِي کٛو طُمٜ مِنْ تٛکِّيمَ؞ کٛ مِنْ کٜٻَتَ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","يٜىٰسُ وِعِٻٜ، ‏«‏اٜ مِ وِعَعٛنْ غٛونغَ، اٜ جَامَنُ غَرَيْطُمْ، تٛ ٻِي نٜطّٛ جٛوطَکٜ دٛوْ جٛوطٛرْغَلْ لَامُ مُوطُمْ طُمْ تٜدُّنغَلْ، اٛنٛنْ تٛکُّٻٜيَمْ اٛنٛنْ مَا اٛنْ نجٛوطٛتٛ دٛوْ جٛوطٛرْلٜ لَامُ سَڤّٛ اٜ طِطِ، اٛنْ لَامٛو لٜݧِ اِسْرَاعِيلَ سَڤّٛ اٜ طِطِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","طٛنْمَا کٛو مٛيٜ اَلُطٛ غُرٜىٰجٜ، کٛو سَکِرَاٻٜ مُوطُمْ وٛرْٻٜ کٛو رٜوْٻٜ، کٛو ݧَاکٛ، کٛو مَدُوجٛ، کٛو ٻِٻّٜ، کٛو غٜسٜ نغَمْ اَمْ، اٛ حٜٻَيْ کٛ ٻُرِ نٛنْ ندٜ 100، ندٜنْ اٛ حٜٻَيْ يٛنْکِ کِ رٜعَتَا؞ ");
INSERT INTO fuv_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","اَمَّا يِمْٻٜ طُطْٻٜ اَرْتُٻٜ ٻٜ نغَرْتَيْ شَکِتِيٻٜ، ندٜنْ شَکِتِيٻٜ نغَرْتَيْ اَرْتُٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","‏«‏لَامُ اَللَّه اٜ نَنْدِ اٜ غٛطّٛ جٛومُ نغٜسَ بُرْتِيطٛ اِلَا سُبَکَ نغَمْ اٛ حٜٻَ حُوٛوٻٜ تٛ نغٜسَ اِنَبٛوجٜ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","اٛ وَادِ اٜ مَٻّٜ اٛ يٛٻَيْٻٜ يَمْندٜ اَجُرْفَارِ غٛعٛ اٜ ݧَلْندٜ، سٜيْ اٛ وِعِٻٜ ٻٜ نجَحَ نغٜسَ کَنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","ندٜ اٛ وُرْتِي فَرٛ نجَمْندِ جٛوٜىٰنَيِ سُبَکَ، سٜيْ اٛ يِعِ وٛٻّٜ اٜ نجٛوطِي اٜ مٜىٰرٜ ندٜرْ لُومٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","سٜيْ اٛ وِعِٻٜ، ‏‹‏اٛنٛنْ مَا نجَحٜىٰ نغٜسَ اَمْ، مِ يٛٻَيْعٛنْ کٛ حَانِ؞›‏ سٜيْ ٻٜ نجَحِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","ندٜ اٛ فُطِّتِ اٛ وُرْتِي، اٛ وَطِ نٛنْ فَرٛ شَکَ ݧَلَوْمَ اٜ فَرٛ نجَمْندِ تَتِ اَلَاسَرَ؞ ");
INSERT INTO fuv_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","فَرٛ نجَمْندِ جٛوِ اَلَاسَرَ اٛ فُطِّتِ اٛ وُرْتِي اٛ تَوِ وٛٻّٜ اٜ ندَرِي، اٛ وِعِٻٜ، ‏‹‏نغَمْ طُمٜ ݧَلُّطٛنْ اٛنْ ندَرِي اٜ مٜىٰرٜ؟›‏ ");
INSERT INTO fuv_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","سٜيْ ٻٜ مبِعِمٛ، ‏‹‏نغَمْ وَلَا کٛشُّطٛمِنْ کُوغَلْ؞›‏ سٜيْ اٛ وِعِٻٜ، ‏‹‏اٛنٛنْ مَا نجَحٜىٰ نغٜسَ اَمْ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","‏«‏ندٜ فُتُرٛ وَطِ، جٛومُ نغٜسَ اٛنْ وِعِ ڤَامَنٛووٛ کُوغَلْ نغٜسَ کَنْ، ‏‹‏نٛدّٛيْ حُوٛوٻٜ ٻٜنْ، نجٛٻَاٻٜ نجٛٻَارِ مَٻّٜ، اَرْتِرَا شَکِتِيٻٜ ٻٜنْ حَا يَاکِ اَرَنْدٜعٜنْ ٻٜنْ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","ندٜ کٛشَّاٻٜ فَرٛ نجَمْندِ جٛوِ اَلَاسَرَ نغَرِ، کٛو مٛيٜ حٛکَّا يَمْندٜ اَجُرْفَارِ غٛعٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","نغَمْ نٛنْ، ندٜ اَرَنْدٜعٜنْ نغَرِ، اٜ ٻٜ کَمِّي ٻٜ کٜٻَيْ کٛ ٻُرِ نٛنْ، اَمَّا کٛو مٛيٜ مَٻّٜ حٛکَّا يَمْندٜ اَجُرْفَارِ غٛعٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","ندٜ ٻٜ نجَٻِ شٜىٰدٜ طٜنْ، ٻٜ مٜتِتَنِ جٛومُ نغٜسَ اٛنْ، ");
INSERT INTO fuv_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","اٜ ٻٜ مبِعَ، ‏‹‏ٻٜعٜ شَکِتِيٻٜ اٜ وَرُکِ، شَرٜلْ سٜطَّ تَنْ ٻٜ کُوِ، ندٜنْ اَ حٛکِّيٻٜ نٛ کٛکُّطَامِنْ، مِنٛنْ ݧَلُّٻٜ ندٜرْ نَانغٜ اٜ کُوَ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","سٜيْ اٛ نٛوتِي، اٛ وِعِ غٛعٛتٛ ندٜرْ مَٻّٜ، ‏‹‏حِغٛ، مِ حَلَّنَايِمَ؞ نَاع اٜنْ نغَادِي دٛوْ يَمْندٜ اَجُرْفَارِ غٛعٛ اٜ ݧَلْندٜ؟ ");
INSERT INTO fuv_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","جَٻُ نجٛٻَارِ مَاطَ، ندِلَّا؞ مِنْ يِطِ حٛکُّکِ شَکِتِيٻٜ ٻٜنْ نٛ کٛکُّمَامِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","مِ وَلَا لَامُ مِ وَطَ نٛ نغِطُمِ وَطُکِ اٜ شٜىٰدٜ اَمْ؟ کٛو اَ نَنَ لَوْلِيرُ نغَمْ مِ وَطِ کٛ وٛوطِ؟›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","ندٜنْ اٛ يٛتِّنِ اٜ وِيکِ، ‏«‏نٛنْ يِمْٻٜ شَکِتِيٻٜ ٻٜ نغَرْتَيْ اَرْتُٻٜ، ندٜنْ اَرْتُٻٜ نغَرْتَيْ شَکِتِيٻٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","يٜىٰسُ اٜ تٛکُّٻٜمٛ اٜ دٛوْ طَتَلْ يَاکِ اُرُشَلِيمَ، سٜيْ اٛ نٛدِّٻٜ وُتُّدُ لَاوٛلْ، اٛ وِعِٻٜ، ");
INSERT INTO fuv_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","‏«‏رَطُّمْ، اٜنْ نجَحَيْ اُرُشَلِيمَ، ندٜنْ طُمْ وَطَيْ ٻِي نٜطّٛ ندٜرْ جُوطٜ مَوْٻٜ اَرْدِيٻٜ دِينَ اٜ مٛودِٻّٜ اَتَّوْرَ؞ ٻٜ تَپَنَيْمٛ کِيتَ مَيْدٜ، ");
INSERT INTO fuv_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ٻٜ نغَطَمٛ ندٜرْ جُوطٜ حٜىٰفٜرْٻٜ ٻٜ نجُکِّتَمٛ، ٻٜ ڤِيَمٛ، ٻٜ مبَرَمٛ دٛوْ غَافَانغَلْ؞ ندٜنْ ݧَلْندٜ تَتَوْرٜ طُمْ اُمِّنَيْمٛ دَغَ مَيْدٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","سٜيْ مَدُوجٛ ٻِٻّٜ جَبَدِ وَرِ تٛ يٜىٰسُ اٜ ٻِٻّٜ مَاکٛ اٛ دِشِّي يٜىٰسٛ مَاکٛ، نغَمْ اٛ تٛرٛومٛ غٛطُّمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","سٜيْ يٜىٰسُ وِعِمٛ، ‏«‏کٛ نغِطَّا؟»‏ مَدُوجٛ اٛنْ وِعِمٛ، ‏«‏وَطُ ٻِٻّٜ اَمْ ٻٜعٜ طِطٛ نجٛوطٛو وُتُّدُ جٛوطٛرْغَلْ مَاطَ ندٜرْ لَامُ مَاطَ، غٛعٛتٛ ݧَامٛ مَاطَ غٛعٛتٛ نَنٛ مَاطَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","اَمَّا يٜىٰسُ نٛوتِي، وِعِ، ‏«‏اٛنْ اَنْدَا کٛ تٛرٛتٛوطٛنْ؞ اٛنْ مبَاوَيْ نجَرٛنْ اِرِ جَرْدُغٜلْ تٛرَّ نغٜلْ نجَرَيْمِ يٜىٰسٛ طٛعٛ؟»‏ ٻٜ مبِعِمٛ، ‏«‏اٜىٰ، مِنْ مبَاوَيْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","سٜيْ يٜىٰسُ وِعِٻٜ، ‏«‏اٜىٰ، اٛنْ نجَرَيْ اِرِ جَرْدُغٜلْ تٛرَّ نغٜلْ نجَرَيْمِ، اَمَّا جٛوطَاکِ اٜ جُنْغٛ اَمْ ݧَامٛ اٜ جُنْغٛ اَمْ نَنٛ نَاع مِنْ حٛکَّتَطُمْ؞ طٜعٜ بِغٜىٰجٜ طُمْ طٜ ٻٜنْ طٛنْ ٻٜ ݧَاکٛ اَمْ مٛ دٛوْ سِرْيَنِي؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","ندٜ حٛرِيٻٜ تٛکُّٻٜ يٜىٰسُ سَڤّٛ نَنِ نٛنْ، ٻٜ ڤُطِّ مٛنَّنْکِ يَاکُبُ اٜ يَحَيَ؞ ");
INSERT INTO fuv_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","اَمَّا يٜىٰسُ نٛدِّٻٜ ٻٜ فُو، وِعِٻٜ، ‏«‏اٛنْ اَنْدِ لَامِيٻٜ يِمْٻٜ نَاع يَحُودَنْکٛعٜنْ اٜ کٛلَّٻٜ لَامُ سٜمْبٜ، ندٜنْ مَوْٻٜ مَٻّٜ مَا اٜ کٛلَّ ٻُرَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","اَمَّا اٛنٛنْ، تٛع اٛنْ نغَطُ نٛنْ حَکُّندٜ مٛوطٛنْ؞ فُو غِطّٛ وَرْتَ مَوْطٛ ندٜرْ مٛوطٛنْ دٛولٜ وَرْتَ جَغَّنْتٛوطٛعٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","کَدِنْ فُو غِطّٛ وَرْتَ اَرْدِيطٛ مٛوطٛنْ، دٛولٜ اٛ وَرْتَ مَشُّطٛ مٛوطٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","نٛنْ مَا ٻِي نٜطّٛ وَرِي نَاع نغَمْ اٛ جَغَّنٜىٰ، اَمَّا نغَمْ اٛ جَغَّنٛو يِمْٻٜ، اٛ حٛکَّ يٛنْکِ مَاکٛ نغَمْ رِمْطِنْکِ طُطْٻٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","يٜىٰسُ اٜ تٛکُّٻٜمٛ اٜ مبُرْتٛو غَرِيرِ جٜرِيکٛ، سٜيْ يِمْٻٜ طُطْٻٜ تٛکِّمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","سٜيْ رَا وُمْٻٜ طِطٛ اٜ نجٛوطِي حَادٜ طَتَلْ؞ ندٜ ٻٜ نَنِ يٜىٰسُ اٜ پَٻّٛو، سٜيْ ٻٜ نٛدِّ سٜمْبٜىٰ، ‏«‏مٛودِبّٛ، ٻِطّٛ دَوْدَ، يُرْمِنَنْمِنْ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","کَوْرُتُٻٜ ٻٜنْ کَٻَنِٻٜ ٻٜ ندٜعِّتَ، اَمَّا ٻٜ ٻٜيْدِ نٛدُّکِ اٜ سٜمْبٜ، اٜ ٻٜ مبِعَ، ‏«‏مٛودِبّٛ، ٻِطّٛ دَوْدَ، يُرْمِنَنْمِنْ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","سٜيْ يٜىٰسُ دَرِي، نٛدِّٻٜ، وِعِ، ‏«‏کٛ نغِطّٛنْ مِ وَطَنَعٛنْ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","ٻٜ مبِعِمٛ، ‏«‏مٛودِبّٛ، اٜ مِنْ نغِطِ مبُمْتِنَامِنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","يٜىٰسُ نَنِ جُرُمْطُمْ مَٻّٜ، مٜىٰمِ غِتٜ مَٻّٜ؞ طٛنْ اٜ طٛنْ غِتٜ مَٻّٜ مبُمْتِ، ٻٜ تٛکِّمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","ندٜ يٜىٰسُ اٜ تٛکُّٻٜمٛ ٻَدِي غَرِيٜلْ بٜتَفَاجِ حَادٜ اُرُشَلِيمَ تٛ حٛشّٜىٰرٜ ندٜ لٜطّٜ جَيْتُنْ، سٜيْ اٛ لِلِ تٛکُّٻٜمٛ طِطٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","اٛ وِعِٻٜ، ‏«‏نجَحٜىٰ ندٜرْ غَرِيٜلْ غٛنْغٜلْ يٜىٰسٛ مٜىٰطٜنْ؞ اٜ نَتُّکِ مٛوطٛنْ، اٛنْ تَوَيْ مبَبَّ اٜ حَٻِّي اٜ ٻِنْغَ مَاغَ؞ ڤِتّٛيٜىٰطِ نغَدَّنٛنْيَمْطِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","تٛ غٛطّٛ مٜتَنِيعٛنْ، مبِعٜىٰ، ‏‹‏مٛودِبّٛ اٜ يِطِ حُوتِرَطِ، اٛ وَطَيْ طُمْ وَرْتِرَطِ نَاع کٛ نٜىٰٻِ؞›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","نٛنْ وَطِي نغَمْ طُمْ حٜبِّنَ کٛ اَللَّه وِعِ دَغَ حٛنْدُکٛ اَنَّبِ جَکَارِيَ، وِيکِ، ");
INSERT INTO fuv_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","‏«‏مبِعٜىٰ يِمْٻٜ اُرُشَلِيمَ، ‏‹‏رَا لَامِيطٛ مٛوطٛنْ اٜ وَرَ تٛ مٛوطٛنْ!‏ اٛ لٜسْتِنْطٛ حٛورٜ اٜ مٛ دٛوْ مبَبَّ، اٜ دٛوْ مبَبَّ مٛلَ ڤَمَرَ؞›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","سٜيْ تٛکُّٻٜمٛ ٻٜنْ ندِلِّ، نغَطِ کٛ يٜىٰسُ وِعِٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","ٻٜ نجَارِ مبَبَّ نغَنْ اٜ ٻِنْغَ مَاغَ، ٻٜ مبٜعِّتِ شُدَّارِ مَٻّٜ دٛوْ مَاجِ، اٛ پٜنْتِ اٛ جٛوطِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","يِمْٻٜ طُطْٻٜ حَوْرُتُٻٜ مبٜعِّتِ شُدَّارِ مَٻّٜ دٛوْ طَتَلْ نغَلْ، وٛٻّٜ بٛو نغٜوٛيِ حَاکٛ تٛ لٜطّٜ اٜ مبٜعِّتَکٛ دٛوْ طَتَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","يِمْٻٜ طُطْٻٜ يَحٛوٻٜ يٜىٰسٛ يٜىٰسُ اٜ تٛکِّرْٻٜمٛ غَطَ اٜ ٻٜ مبِعَ اٜ سٜمْبٜ، ‏«‏حٛسَانَ تٛ ٻِطّٛ دَوْدَ!‏ اٛ بَرْکِطِنَاطٛ غَرٛيْطٛ ندٜرْ اِنْدٜ جٛومِرَاوٛ!‏ اٜنْ مَنْتُ اَللَّه مٛ دٛوْ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","ندٜ يٜىٰسُ نَتِّ اُرُشَلِيمَ، حَکِّيلٛ يِمْٻٜ غَرِيرِ ندِنْ فُو اُمِّي، اٜ ٻٜ مبِعَ، ‏«‏طُمْ مٛيٜ اٛعٛ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","سٜيْ يِمْٻٜ طُطْٻٜ ٻٜنْ جَادٛوٻٜ اٜ يٜىٰسُ مبِعِ، ‏«‏طُمْ يٜىٰسُ، اَنَّبِيجٛ دَغَ غَرِيرِ نَجَرَتْ ندٜرْ لٜيْدِ غَلِيلِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","سٜيْ يٜىٰسُ نَتِّ وُرٛ شٜنِينغٛ رِيوِ سٛورٛوٻٜ اٜ سٛودٛوٻٜ ندٜرْ مَغّٛ؞ اٛ تَلِّ تٜىٰبُرْجِ غَيْلِتٛوٻٜ شٜىٰدٜ رٛومَنْکٛعٜنْ يَاکِ شٜىٰدٜ وُرٛ شٜنِينغٛ اٜ جٛوطٛرْلٜ شٛورٛوٻٜ ڤٛولِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","اٛ وِعِٻٜ، ‏«‏طُمْ وِنْدَامَ اَللَّه وِعِي، ‏‹‏طُمْ نٛدِّرَيْ وُرٛ اَمْ وُرٛ دٛعَارٜ،›‏ اَمَّا اٛنْ نغَرْتِرِينغٛ لُورٛ وُيْٻٜ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","سٜيْ وُمْٻٜ اٜ لَپٛوٻٜ نغَرِ تٛ مَاکٛ ندٜرْ وُرٛ شٜنِينغٛ، اٛ يَمْطِتِنِٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","اَمَّا مَوْٻٜ اَرْدِيٻٜ دِينَ اٜ مٛودِٻّٜ اَتَّوْرَ نَنِ مٛنّٜرٜ ندٜ ٻٜ نغِعِ کُوطٜ کَيْطِنِيطٜ طٜ اٛ وَطِ، حَا سُکَحٛيْ اٜ مبِعَ اٜ سٜمْبٜ ندٜرْ وُرٛ شٜنِينغٛ، ‏«‏حٛسَانَ تٛ ٻِطّٛ دَوْدَ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ٻٜ مبِعِمٛ، ‏«‏اَ نَنَ کٛ سُکَاٻٜ ٻٜعٜ مبِعَتَ؟»‏ يٜىٰسُ نٛوتِي، وِعِ، ‏«‏اٜىٰ؞ اٛنْ مٜىٰطَايِ جَنْغُکِ اَايَارٜ بِيندٜ، ‏‹‏اَنْ سِرْيِ سُکَحٛيْ ڤَمَرٛيْ اٜ مُسِنَيْکٛيْ مَنْتُمَا؟›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","سٜيْ اٛ دِلِّ اٛ اَلِٻٜ اٛ وُرْتِي غَرِيرِ ندِنْ اٛ يَحِ بٜتَنِ اٛ وَالِ تٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","ندٜ وٜىٰتِ يٜىٰسُ اٜ وَرْتٛيَ غَرِيرِ اُرُشَلِيمَ اٛ نَنِ وٜىٰلٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","ندٜ اٛ يِعِ وٛکِّ اِبِّ حَادٜ طَتَلْ، اٛ يَحِ تٛ مَاکِ، اَمَّا اٛ تَوَايِ غٛطُّمْ تٛ مَاکِ سٜيْ حَاکٛ تَنْ؞ سٜيْ اٛ وِعِکِ، ‏«‏تَاع فُطُّتُ ندِمَا حَا اَبَدَا!‏»‏ طٛنْ اٜ طٛنْ کِ يٛورِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","ندٜ تٛکُّٻٜمٛ نغِعِ نٛنْ، ٻٜ کَيْطِنِ، ٻٜ مبِعِ، ‏«‏نٛ طُمْ وَطِ اِبِّ کِعِ يٛورِ طٛنْ اٜ طٛنْ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","يٜىٰسُ نٛوتِي، وِعِٻٜ، ‏«‏اٜ مِ وِعَعٛنْ غٛونغَ، تٛ اٛنْ نغٛودِ حٛولَارٜ، اٛنْ نغَلَا سٜکٛ کٛو سٜطَّ، اٛنْ مبَاوَيْ نغَطٛنْ کٛ ٻُرِ کٛ نغَطَنْمِ اِبِّ کِعِ، حَا مَا تٛ اٛنْ مبِعِي حٛشّٜىٰرٜ ندٜعٜ، ‏‹‏طٛوفَ دَغَ طٛعٛ، کُبٛطَا حٛورٜ مَاطَ ندٜرْ مبٜىٰلَ،›‏ سٜيْ ندٜ وَطَ نٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","تٛ اٛنْ نغٛودِ حٛولَارٜ، فُو کٛ تٛرِيطٛنْ اَللَّه اٛنْ کٜٻَيْطُمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","ندٜ يٜىٰسُ نَتِّ وُرٛ شٜنِينغٛ اٜ مٛ ندٜرْ اٜکِّتِنْکِ، سٜيْ مَوْٻٜ اَرْدِيٻٜ دِينَ اٜ مَوْٻٜ يِمْٻٜ نغَرِ تٛ مَاکٛ مبِعِ، ‏«‏اٜ لَامُ مٛيٜ نغَطَتَا کُوطٜ طٜعٜ؟ مٛيٜ حٛکُّمَا لَامُ طُمْ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","سٜيْ يٜىٰسُ نٛوتِي، وِعِٻٜ، ‏«‏مِنْ مَا مِ پَمَيْعٛنْ؞ تٛ اٛنْ نٛوتَنَکٜيَمْ، ندٜنْ مِ وِعَيْعٛنْ اٜ طُمٜ لَامُ نغَطِرَيْمِ کُوطٜ طٜعٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","تٛو، بَڤْتِسْمَ طُمْ يَحَيَ وَطِ، تٛ اَللَّه طُمْ پِوٛيِ کٛو تٛ يِمْٻٜ؟»‏ سٜيْ ٻٜ مٜدِّ حَکُّندٜ مَٻّٜ، ٻٜ مبِعِ، ‏«‏تٛ اٜنْ مبِعِي، ‏‹‏دَغَ تٛ اَللَّه طُمْ پِوٛيِ،›‏ اٛ وِعَيْعٜنْ، ‏‹‏کٛ وَطِ اٛنْ جَٻَايِ کٛ اٛ وِعِ؟›‏ ");
INSERT INTO fuv_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","اَمَّا تٛ اٜنْ مبِعِي، ‏‹‏تٛ يِمْٻٜ طُمْ پِوٛيِ،›‏ اٜنْ کُلَ کٛ يِمْٻٜ نغَطَنْتَعٜنْ، نغَمْ ٻٜ فُو ٻٜ نجَٻِي يَحَيَ اٛ اَنَّبِيجٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","نغَمْ نٛنْ ٻٜ نٛوتِي، ٻٜ مبِعِ يٜىٰسُ، ‏«‏مِنْ اَنْدَا؞»‏ يٜىٰسُ وِعِٻٜ، ‏«‏نٛنْ مِنْ مَا، مِ وِعَتَاعٛنْ کٛو اٜ طُمٜ لَامُ نغَطِرَيْمِ کُوطٜ طٜعٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","‏«‏تٛو، نٛ نغِيطٛنْ؟ اٜ وٛودِ غٛطّٛ غٛودُطٛ سُکَاٻٜ طِطٛ؞ اٛ يَحِ تٛ سُکَ اَرَنْدٜىٰجٛ اٛنْ، اٛ وِعِ، ‏‹‏ٻِطّٛ اَمْ، حَنْدٜ يَحُ نغٜسَ اِنَبٛوجٜ کُوَا؞›‏ ");
INSERT INTO fuv_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","سٜيْ سُکَ اٛنْ وِعِمٛ، ‏‹‏مِ يَحَتَا؞›‏ اَمَّا دَغَ غَطَ سُکَ اٛنْ وَيْلِتِ ݧُمٛ مُوطُمْ يَحِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","سٜيْ ݧَاکٛ اٛنْ يَحِ تٛ سُکَ طِطَٻٛ اٛنْ وِعِمٛ کٛ وِعِ اٛنْ تٛنْ سُکَ اَرَنْدٜىٰجٛ اٛنْ؞ سُکَ اٛنْ نٛوتِي، وِعِ، ‏‹‏تٛو، مِ يَحَيْ، بَڤَّ،›‏ اَمَّا اٛ يَحَايِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","تٛو، ندٜرْ مَٻّٜ مٛيٜ وَطِ کٛ ݧَاکٛ اٛنْ يِطِ؟»‏ سٜيْ ٻٜ مبِعِ، ‏«‏اَرَنْدٜىٰجٛ اٛنْ؞»‏ يٜىٰسُ وِعِٻٜ، ‏«‏اٜ مِ وِعَعٛنْ غٛونغَ، جَٻٛوٻٜ شٜىٰدٜ لٜيْدِ اٜ کَارُوَعٜنْ اٜ ٻٜ اَرْتَعٛنْ نَتُّکِ لَامُ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","نغَمْ يَحَيَ وَرِي حٛلِّيعٛنْ لَاوٛلْ اَادِلَاکُ، اٛنْ کٛولَاکِمٛ؞ اَمَّا جَٻٛوٻٜ شٜىٰدٜ لٜيْدِ اٜ کَارُوَعٜنْ کٛولَکٜمٛ؞ کٛو ندٜ نغِيطٛنْ نٛنْ، دَغَ غَطَ اٛنْ تُوبَايِ کٛولِيطٛنْمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","‏«‏تٛو، رَا غٛطُّمْ مِسَالُ؞ اٜ وٛودِ غٛطّٛ جٛومُ نغٜسَ غَطُطٛ نغٜسَ اِنَبٛوجٜ، اٛ حٛوِکَ، اٛ وَسِ نغَيْکَ مَوْکَ ندٜرْ تَفَارٜ نغَمْ مٛيْلُکِ ندِيَمْ دَغَ ندٜرْ اِنَبٛوجٜ طٜنْ، اٛ مَحِ سُودُ تٛوْندُ نغَمْ رٜىٰنُکِ نغٜسَ کَنْ؞ سٜيْ اٛ حٛکِّکَ وٛٻّٜ رٜمٛوٻٜ مٛعِّنَکَ، اٛ دِلِّ وٛنْدِ لٜيْدِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","ندٜ شَرٜلْ ٻٜنْدُکِ اِنَبٛوجٜ طٜنْ وَطِ، اٛ لِلِ مَشُّٻٜ مَاکٛ تٛ ٻٜ اٛ حٛکِّ نغٜسَ کَنْ نغَمْ ٻٜ نجَٻٛنٛيَمٛ کٛ ٻٜ نغَادُنٛ ندٜرْ کٛ ٻٜنْدِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","اَمَّا ٻٜ نَنْغِٻٜ ٻٜ ڤِيِ غٛعٛتٛ، ٻٜ مبَرِ غٛعٛتٛ، ٻٜ کُبٛرِي غٛعٛتٛ کَاپٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","سٜيْ اٛ فُطِّتِ اٛ لِلِ وٛٻّٜ مَشُّٻٜ مَاکٛ ٻُرْٻٜ اَرَنْدٜعٜنْ طُوطُکِ؞ کَمْٻٜ مَا رٜمٛوٻٜ ٻٜنْ نغَطَنِٻٜ نٛنْ نٛ ٻٜ نغَطَنِ اَرَنْدٜعٜنْ ٻٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","غَطَ طٛنْ جٛومُ نغٜسَ اٛنْ لِلِ ٻِطّٛ مَاکٛ تٛ رٜمٛوٻٜ ٻٜنْ، اٜ مٛ وِعَ، ‏‹‏ٻٜ کٛکَّيْ ٻِطّٛ اَمْ مَنْغُ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","اَمَّا ندٜ ٻٜ اٛ حٛکِّ نغٜسَ کَنْ نغِعِ ٻِطّٛ اٛنْ، سٜيْ ٻٜ مبِعِ حَکُّندٜ مَٻّٜ، ‏‹‏تٛو!‏ رَا دٛنٛووٛ جٛومُ نغٜسَ کَنْ؞ نغَرٜىٰ مبَرٜنْمٛ، ندٛنُ نغٜسَ کَنْ وَرْتَ طُمْ مٜىٰطٜنْ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","سٜيْ ٻٜ نَنْغِمٛ، ٻٜ مبُرْتِنِمٛ ندٜرْ نغٜسَ کَنْ، ٻٜ مبَرِمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","‏«‏تٛو، تٛ جٛومُ نغٜسَ اٛنْ وَرِي، کٛ اٛ وَطَنْتَ ٻٜ اٛ حٛکِّ نغٜسَ ٻٜنْ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","سٜيْ ٻٜ مبِعِمٛ، ‏«‏اٛ وَطَنَيْ کَلُّٻٜ ٻٜنْ طٛنْ وٛکِّ وَرْکِ کَلُّکِ؞ اٛ حٛکَّ وٛٻّٜ نغٜسَ کَنْ کٛکَّيْٻٜمٛ دَغَ ندٜرْ کٛ ٻٜنْدِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","يٜىٰسُ وِعِٻٜ، ‏«‏اٛنْ مٜىٰطَايِ جَنْغُکِ کٛ اَايَاجٜ مبِعِ؟ طٜ مبِعِ، ‏‹‏حَيْرٜ ندٜ مَحٛوٻٜ نغَݧِ، کَيْرٜ وَرْتِ حَيْرٜ ٻُرْندٜ دَرْنُکِ مَادِ؞ طُعُمْ طُمْ کُوغَلْ جٛومِرَاوٛ، طُمْ کَيْطِنِيطُمْ تٛ مٜىٰطٜنْ!‏›‏ ");
INSERT INTO fuv_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","‏«‏نغَمْ نٛنْ اٜ مِ وِعَعٛنْ، طُمْ جَٻَيْ لَامُ اَللَّه تٛ مٛوطٛنْ طُمْ حٛکَّطُمْ وٛٻّٜ غَطَيْٻٜ کٛ اَللَّه يِطِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","کٛو مٛيٜ يَنٛيِ دٛوْ حَيْرٜ ندٜنْ يٜوِ يٜوِنَيْ؛ اَمَّا تٛ حَيْرٜ ندٜنْ يَنِي دٛوْ غٛطّٛ، ندٜ نَمَيْمٛ بٛ شٛنْدِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","ندٜ مَوْٻٜ اَرْدِيٻٜ دِينَ اٜ فَارِسَنْکٛعٜنْ نَنِ مِسَالُ فٜىٰرٜ‑فٜىٰرٜ طُمْ اٛ حٛکِّ، سٜيْ ٻٜ ڤَامِ دٛوْ مَٻّٜ اٛ مٜتِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","سٜيْ ٻٜ طَٻِّتِ لَاوٛلْ نٛ ٻٜ نَنْغِرْتَمٛ، اَمَّا اٜ ٻٜ کُلَ يِمْٻٜ، نغَمْ يِمْٻٜ ٻٜنْ نجَٻِي اٛ اَنَّبِيجٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","سٜيْ يٜىٰسُ فُطِّتِ مٜتِرَنِٻٜ مِسَالُ، وِعِ، ");
INSERT INTO fuv_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","‏«‏طُمْ نَنْدِنَيْ لَامُ اَللَّه اٜ غٛطّٛ لَامِيطٛ شِرْيَنِيطٛ ٻِطّٛ مُوطُمْ حُمْتٛ تٜىٰغَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","اٛ لِلِ مَشُّٻٜ مَاکٛ نٛدّٛيَ کُمْڤِتَاٻٜ حُمْتٛ نغٛنْ، اَمَّا کُمْڤِتَاٻٜ ٻٜنْ نغَݧِ نغَرَ؞ ");
INSERT INTO fuv_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","سٜيْ اٛ فُطِّتِ اٛ لِلِ وٛٻّٜ مَشُّٻٜ مَاکٛ، اٛ وِعِ، ‏‹‏نجَحٜىٰ مبِعٛنْ کُمْڤِتَاٻٜ ٻٜنْ، ‏«‏رَطُّمْ مِ سِرْيَکٜ ݧَمْندُ، طُمْ حِرْسِي غَعِ اٜ ݧَلْبِ ڤَيْطِ، کٛو طُمٜ سِرْيَامَ؞ نغَرٜىٰ حُمْتٛ تٜىٰغَلْ نغَلْ!‏»‏ ›‏ ");
INSERT INTO fuv_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","اَمَّا کُمْڤِتَاٻٜ ٻٜنْ نغَنَّايِ؞ غٛعٛتٛ يَحِ نغٜسَ مُوطُمْ، غٛعٛتٛ يَحِ لُومٛ مُوطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","حٛرِيٻٜ ٻٜنْ نَنْغِ مَشُّٻٜ ٻٜنْ تٛرِّٻٜ، مبَرِٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","سٜيْ لَامِيطٛ اٛنْ ٻٜرْنِ نَاع سٜطَّ، لِلِ سٛوجِعٜنْ مُوطُمْ ٻٜ کَلْکِ ٻٜنْ طٛنْ غَطُٻٜ وَرْحٛورٜ ٻٜ نغُلِ غَرِيرِ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","سٜيْ اٛ وِعِ مَشُّٻٜ مَاکٛ، ‏‹‏حُمْتٛ تٜىٰغَلْ نغٛنْ سِرْيَامَ، اَمَّا کُمْڤِتَاٻٜ ٻٜنْ ٻٜ ڤٛتَايِ وَرْکِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","نغَمْ نٛنْ نجَحٜىٰ دٛوْ طَتٜ مَوْطٜ، کُمڤِتٛنْ فُو مٛ نغِيطٛنْ وَرَ حُمْتٛ نغٛنْ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","سٜيْ مَشُّٻٜ ٻٜنْ نجَحِ دٛوْ طَتٜ طٜنْ ٻٜ ٻٛڤْتٛيِ کٛو مٛيٜ مٛ ٻٜ تَوِ، فُو کَلُّٻٜ اٜ ٻٜ نغِکُّ بٛطُّمْ، حَا وُرٛ حُمْتٛ نغٛنْ حٜىٰوِ حٛٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","‏«‏اَمَّا ندٜ لَامِيطٛ اٛنْ نَتّٛيِ نغَمْ يِعَ حٛٻّٜ ٻٜنْ، اٛ يِعِ غٛطّٛ ندٜرْ مَٻّٜ مٛ ٻٛرْنَاکِ لِمْشٜ حُمْتٛ تٜىٰغَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","سٜيْ اٛ وِعِمٛ، ‏‹‏حِغٛ، نٛ طُمْ وَطِ نَتّٛيْطَا طٛعٛ اَ ٻٛرْنَاکِ لِمْشٜ حُمْتٛ؟›‏ اَمَّا نٜطّٛ اٛنْ دُلِّ کٛ وِعَتَ؞ ");
INSERT INTO fuv_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","سٜيْ لَامِيطٛ اٛنْ وِعِ کُوَنٛوٻٜمٛ، ‏‹‏کَٻّٜىٰ نٜطّٛ اٛعٛ جُوطٜ اٜ کٛيْطٜ، ڤَطّٛنْمٛ ندٜرْ ݧِوْرٜ کَلُّندٜ، تٛ طُمْ وٛيَتَ طُمْ ݧٜرْپِندِرَ ݧِيپٜ؞›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","يٜىٰسُ ٻٜيْدِ وِيکِ، ‏«‏يِمْٻٜ طُطْٻٜ کُمْڤِتَا، اَمَّا سٜطَّ شُٻَا؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","سٜيْ فَارِسَنْکٛعٜنْ نجَحِ کَوْتِ کٛعٜ، کَٻِّ دَبَرٜ نٛ ٻٜ نَنْغِرْتَ يٜىٰسُ دٛوْ کٛ اٛ وِعِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","سٜيْ ٻٜ لِلٛيِ تٛکُّٻٜٻٜ اٜ يِمْٻٜ حِرُدُسْ، ٻٜ مبِعِ، ‏«‏مٛودِبّٛ، اٜ مِنْ اَنْدِ کٛ مبِعَتَا اٜ کٛ نغَطَتَا طُمْ غٛونغَ، اَ اٜکِّتِنَ دٛوْ لَاوٛلْ اَللَّه اٜ غٛونغَ، اَ حُلَتَا کٛ يِمْٻٜ مبِعَتَ دٛوْ مَاطَ، اَ حٛلَّتَا فٜىٰرٛوتِرٛلْ حَکُّندٜ يِمْٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","تٛو، وِعُمِنْ، اٜ يِيکِ مَاطَ اٜ حَانِ مِنْ نجٛٻَ کَيْسَرْ شٜىٰدٜ لٜيْدِ کٛو طُمْ حَانَايِ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","اَمَّا يٜىٰسُ حٜٻْتِ حَلّٜىٰندٜ مَٻّٜ، اٛ وِعِٻٜ، ‏«‏نغَمْ طُمٜ ڤٛوندٛتٛنْيَمْ، اٛنٛنْ مُنَافُکِعٜنْ؟ ");
INSERT INTO fuv_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","کٛلّٜىٰيَمْ يَمْندٜ ندٜ طُمْ يٛٻِرْتَ شٜىٰدٜ لٜيْدِ؞»‏ سٜيْ ٻٜ نغَدَّنِمٛ يَمْندٜ غٛعٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","يٜىٰسُ وِعِٻٜ، ‏«‏طٛوْدِ مٛيٜ اٜ اِنْدٜ مٛيٜ وٛنِ دٛوْ مَيْرٜ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","ٻٜ نٛوتِي، ٻٜ مبِعِ، ‏«‏طُمْ کَيْسَرْ؞»‏ سٜيْ يٜىٰسُ وِعِٻٜ، ‏«‏تٛو، نغَمْ نٛنْ کٛکّٜىٰ کَيْسَرْ کٛ وٛنِ طُمْ کَيْسَرْ، ندٜنْ کٛکّٛنْ اَللَّه کٛ وٛنِ طُمْ اَللَّه؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","ندٜ ٻٜ نَنِ نٛنْ، ٻٜ کَيْطِنِ، ٻٜ اَلِمٛ، ٻٜ ندِلِّ؞ ");
INSERT INTO fuv_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","سَادُسَنْکٛعٜنْ اٜ مبِعَ وَلَا اُمَّاکِ مَيْٻٜ؞ اٜ ݧَلْندٜ ندٜنْ، سٜيْ وٛٻّٜ مَٻّٜ نغَرِ تٛ يٜىٰسُ، ٻٜ پَمِمٛ، ٻٜ مبِعِ، ");
INSERT INTO fuv_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","‏«‏مٛودِبّٛ، اَنَّبِ مُوسَ وِعِي تٛ نٜطّٛ تٜعِي دٜبّٛ مَايِي دَݧِدَايِ اٜ مَاکٛ، سَکِرَاوٛ مَاکٛ سٜيْ تٜعَمٛ نغَمْ حٜٻَنَ سَکِرَاوٛ مُوطُمْ مَيْطٛ ٻِٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","تٛو، ندٜنّٛ اٜ وٛودِ وٛٻّٜ سَکِرَاٻٜ وٛرْٻٜ نجٛوٜىٰطِطٛ ندٜرْ اَمِنْ؞ اَفٛ اٛنْ تٜعِ دٜبّٛ، مَايِ؞ ندٜ اٛ دَݧِدَايِ اٜ دٜبّٛ اٛنْ، اٛ اَلَنِمٛ سَکِرَاوٛ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","نٛنْ مَا طِطَٻٛ اٛنْ اٜ تَتَٻٛ اٛنْ حَا نجٛوٜىٰطِطَٻٛ اٛنْ وَطِي نٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","غَطَ مَاجُمْ دٜبّٛ اٛنْ مَا مَايِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","تٛو، ݧَلْندٜ ندٜ مَيْٻٜ اُمّٛتٛو دٜبّٛ اٛنْ وَرْتَيْ دٜبّٛ مٛيٜ ندٜرْ مَٻّٜ؟ نغَمْ ٻٜ فُو ٻٜ تٜعِيمٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","سٜيْ يٜىٰسُ نٛوتِي، وِعِٻٜ، ‏«‏اٛنْ مبٛوفِي نغَمْ اٛنْ اَنْدَا کٛ اَايَاجٜ مبِعِ، ندٜنْ اٛنْ اَنْدَا بَوْطٜ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","تٛ مَيْٻٜ اُمَّکٜ دَغَ مَيْدٜ، وَلَا تٜعَيْطٛ وَلَا تٜعٜتٜىٰطٛ، اَمَّا ٻٜ نغَرْتَيْ بٛ مَلَاعِکَعٜنْ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","ندٜنْ دٛوْ اُمَّاکِ مَيْٻٜ دَغَ مَيْدٜ، اٛنْ مٜىٰطَايِ جَنْغُکِ کٛ اَللَّه وِعِعٛنْ؟ اٜ طُمْ وِنْدِ وِيکِ، ");
INSERT INTO fuv_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‏‹‏مِنْ وٛنِ اَللَّه مٛ اِبْرَاهِمْ، اَللَّه مٛ اِشِيَاکُ، اَللَّه مٛ يَاکُبُ؞›‏ کَنْکٛ نَاع اٛ اَللَّه مَيْٻٜ، اَمَّا اٛ اَللَّه غٛودُٻٜ يٛنْکِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","ندٜ حَوْرُتُٻٜ طٛنْ نَنِ نٛنْ، ٻٜ کَيْطِنِ دٛوْ اٜکِّتِنٛلْ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","کٛ يٜىٰسُ وِعِ وَطِ سَادُسَنْکٛعٜنْ ندُلِّي کٛ مبِعَ؞ ندٜ فَارِسَنْکٛعٜنْ نَنِ نٛنْ، سٜيْ ٻٜ کَوْرِتِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","غٛعٛتٛ ندٜرْ مَٻّٜ، مٛودِبّٛ اَتَّوْرَ، پَمِ يٜىٰسُ نغَمْ فٛوندَمٛ، وِعِ، ");
INSERT INTO fuv_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","‏«‏مٛودِبّٛ، طُمٜ دٛوکَ ٻُرِ مَنْغُ فُو ندٜرْ اَتَّوْرَ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","يٜىٰسُ وِعِمٛ، ‏«‏ ‏‹‏يِطُ جٛومِرَاوٛ اَللَّه مَاطَ اٜ ٻٜرْندٜ مَاطَ فُو، اٜ يٛنْکِ مَاطَ فُو، اٜ حَکِّيلٛ مَاطَ فُو؞›‏ ");
INSERT INTO fuv_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","طُعُمْ وٛنِ دٛوکَ مَوْطُمْ اَرَنْدٜجُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","طِطَٻُمْ مَا اٜ فٛتِّدِ اٜ اَرَنْدٜجُمْ طُمْ؞ ‏‹‏يِطُ بَنْدِرَاوٛ مَاطَ نٛ نغِطِرْطَا حٛورٜ مَاطَ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","دٛوْ طُعُمْ دٛوکَ طِطُمْ اَتَّوْرَ اٜ دٜفْتٜ اَنَّبٛعٜنْ ندَرِي؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","ندٜ فَارِسَنْکٛعٜنْ کَوْرِتِ، يٜىٰسُ پَمِٻٜ، ");
INSERT INTO fuv_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","وِعِ، ‏«‏طُمٜ ݧُمٛتٛنْ دٛوْ اَلْمَسِيحُ؟ اٛ ٻِطّٛ مٛيٜ؟»‏ ٻٜ مبِعِمٛ، ‏«‏اٛ ٻِطّٛ دَوْدَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","سٜيْ يٜىٰسُ وِعِٻٜ، ‏«‏تٛو، نٛ طُمْ وَطِ دَوْدَ ندٜرْ بَوْطٜ رُوحُ اَللَّه نٛدِّ اَلْمَسِيحُ ‏‹‏جٛومِرَاوٛ؟›‏ اٛ وِعِ، ");
INSERT INTO fuv_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‏‹‏جٛومِرَاوٛ وِعِي جٛومِرَاوٛ اَمْ، ‏«‏جٛوطَ تٛ جُنْغٛ اَمْ ݧَامٛ، نَا مِ وَطِي اَ يَاٻِي وَݧْوَݧْٻٜ مَاطَ؞»‏ ›‏ ");
INSERT INTO fuv_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","ندٜ دَوْدَ نٛدِّي اَلْمَسِيحُ ‏‹‏جٛومِرَاوٛ،›‏ تٛو، نٛ طُمْ وَطَتَ اٛ وَرْتَ ٻِطّٛ دَوْدَ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","وَلَا بَوْطٛ نٛوتَنَاکِمٛ؞ دَغَ ندٜنْ طٛنْ ݧَلْندٜ وَلَا غَطُطٛ سٜمْبٜ ٻٜرْندٜ پَمِمٛ وٛنْغٛلْ پَمٛلْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","يٜىٰسُ مٜتَنِ حَوْرُتُٻٜ اٜ تٛکُّٻٜمٛ، وِعِ، ");
INSERT INTO fuv_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","‏«‏مٛودِٻّٜ اَتَّوْرَ اٜ فَارِسَنْکٛعٜنْ کٛکَّامَ لَامُ حٛکُّکِ يِمْٻٜ مَعَنَ کٛ مُوسَ وِنْدِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","نغَمْ نٛنْ، نغَطٜىٰ فُو کٛ ٻٜ اٜکِّتِنِعٛنْ تٛکّٜىٰطُمْ، اَمَّا تٛع اٛنْ نغَطُ کٛ ٻٜ نغَطَتَ، نغَمْ ٻٜ نغَطَتَا کٛ ٻٜ نغَعَجِنْتَ؞ ");
INSERT INTO fuv_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","اٜ ٻٜ کَٻَّ دٛݝْلٜ تٜدُّطٜ شَطُطٜ حٛشُّکِ، ٻٜ نجٛوَطٜ دٛوْ بَلْبٜ يِمْٻٜ، اَمَّا کَمْٻٜ اٜ کٛعٜ مَٻّٜ کٛو کٛولٜلْ غٛعٛ ٻٜ نغَطَتَا ٻٜ مبَلَّٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","فُو کٛ ٻٜ نغَطَتَ اٜ ٻٜ نغَطَطُمْ نغَمْ يِمْٻٜ نغِعَٻٜ؞ اٜ ٻٜ کَٻَّ لَايَحٛ مَوْکٛ کٛ اَايَاجٜ دٜفْتٜرٜ شٜنِيندٜ تٛ تِيطٜ مَٻّٜ اٜ جُوطٜ مَٻّٜ، اٜ ٻٜ نجُوتِنَ شِلْمبِ تٛغّٛوجٜ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","تٛ حُمْتٛ اٜ ٻٜ نغِطِ جٛوطَاکِ تٛ مَوْٻٜ نجٛوطٛتٛو؛ ندٜرْ شُوطِ دٛعَارٜ مَا اٜ ٻٜ نغِطِ جٛوطٛرْلٜ مَوْٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","اٜ ٻٜ نغِطِ حٛوْنِرٜىٰکِ مَنْغُ ندٜرْ لُومٛ، ندٜنْ اٜ ٻٜ نغِطِ طُمْ وِعَٻٜ، ‏‹‏اَللَّه سَبِّنَنٜىٰ، مٛودِبّٛ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","اَمَّا اٛنٛنْ، تٛع طُمْ نٛدِّرَعٛنْ ‏‹‏مٛودِبّٛ،›‏ نغَمْ مٛودِبّٛ مٛوطٛنْ اٛ غٛعٛتٛ، ندٜنْ اٛنْ فُو اٛنْ بَنْدِرَاٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","تٛع اٛنْ نٛدُّ کٛو مٛيٜ ‏‹‏ݧَاکٛ›‏ اٜ دُونِيَارُ، نغَمْ اٛنْ نغٛودِ ݧَاکٛ غٛعٛتٛ، غٛنْطٛ تٛنْ دٛوْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","ندٜنْ تٛع طُمْ نٛدِّرَعٛنْ ‏‹‏اَرْدِيطٛ،›‏ نغَمْ اٛنْ نغٛودِ اَرْدِيطٛ غٛعٛتٛ، کَنْکٛ وٛنِ اَلْمَسِيحُ؞ ");
INSERT INTO fuv_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","سٜيْ مَوْطٛ ندٜرْ مٛوطٛنْ وَرْتَ جَغَّنْتٛوطٛعٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","فُو مَوْنِنْطٛ حٛورٜ مُوطُمْ طُمْ لٜسْتِنَيْمٛ؞ فُو لٜسْتِنْطٛ حٛورٜ مُوطُمْ طُمْ مَوْنِنَيْمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","‏«‏اٛنْ مبٛنِي، اٛنٛنْ مٛودِٻّٜ اَتَّوْرَ اٜ فَارِسَنْکٛعٜنْ!‏ اٛنْ مُنَافُکِعٜنْ!‏ اٛنْ مَٻَّنِي يِمْٻٜ دَمُّغَلْ نَتُّکِ لَامُ اَللَّه؞ اٛنٛنْ اٛنْ نَتَّايِ، اٛنْ اَلَايِ غِطُٻٜ نَتُّکِ نَتَّ؞ ");
INSERT INTO fuv_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","‏‏اٛنْ مبٛنِي اٛنٛنْ مٛودِٻّٜ اَتَّوْرَ اٜ فَارِسَنْکٛعٜنْ!‏ اٛنْ مُنَافُکِعٜنْ!‏ اٛنْ ݧَامَ جَوْدِ رٜوْٻٜ ٻٜ وٛرْٻٜ مَٻّٜ مَايِ، اٛنْ نغَطَ دٛعَارٜ جُوتُندٜ نغَمْ يِمْٻٜ نغِعَ؞ نغَمْ نٛنْ، اَللَّه ٻُرَيْ حٛکُّکِعٛنْ بٛنٜ؞‏ ");
INSERT INTO fuv_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","‏«‏اٛنْ مبٛنِي، اٛنٛنْ مٛودِٻّٜ اَتَّوْرَ اٜ فَارِسَنْکٛعٜنْ!‏ اٛنْ مُنَافُکِعٜنْ!‏ نغَمْ اٛنْ کُولَ مَايٛ اٛنْ نغِيلٛو ندٜرْ لٜيْطٜ فٜىٰرٜ‑فٜىٰرٜ نغَمْ حٜٻُکِ غٛعٛتٛ تٛکَّيْطٛ دِينَ مٛوطٛنْ؞ تٛ اٛنْ کٜٻِيمٛ، اٛنْ نغَرْتِرَمٛ کَلُّطٛ ٻُرْطٛعٛنْ حَلُّکِ ندٜ طِطِ نَتَّيْطٛ حِيتٜ بٛ مٛوطٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","‏«‏اٛنْ مبٛنِي، اٛنٛنْ وُمْٻٜ اَرْدِيٻٜ وُمْٻٜ!‏ اٛنْ مبِعَ، ‏‹‏کٛو مٛيٜ حُنٛرِي وُرٛ شٜنِينغٛ، نَاع طُمْ غٛطُّمْ؞ اَمَّا کٛو مٛيٜ حُنٛرِي جِينَارِ غٛنْطُمْ ندٜرْ مَاغٛ، دٛولٜ اٛ وَطَ کٛ اٛ حُنَنِي؞›‏ ");
INSERT INTO fuv_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","اٛنٛنْ کَاݝَاٻٜ، وُمْٻٜ!‏ طُمٜ ٻُرِ مَنْغُ، جِينَارِ طُمْ، کٛو وُرٛ شٜنِينغٛ نغٛنْ غَرْتِرْنغٛ جِينَارِ طُمْ شٜنِيطُمْ؟ ");
INSERT INTO fuv_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","طٛنْمَا اٛنْ مبِعَ، ‏‹‏کٛو مٛيٜ حُنٛرِي سَکِّرْدٜ، نَاع طُمْ غٛطُّمْ؞ اَمَّا کٛو مٛيٜ حُنٛرِي شَکِّرِ نغٛنْدِ دٛوْ سَکِّرْدٜ ندٜنْ، دٛولٜ اٛ وَطَ کٛ اٛ حُنَنِي؞›‏ ");
INSERT INTO fuv_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","اٛنٛنْ وُمْٻٜ!‏ طُمٜ ٻُرِ مَنْغُ، شَکِّرِ ندِنْ، کٛو سَکِّرْدٜ غَرْتِرَيْندٜ شَکِّرِ ندِنْ شٜنِيندِ؟ ");
INSERT INTO fuv_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","نغَمْ نٛنْ، کٛو مٛيٜ حُنٛرِي سَکِّرْدٜ ندٜنْ حُنٛرَکٜندٜ اٜ کٛو طُمٜ کٛ وٛنِ دٛوْ مَيْرٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","طٛنْمَا کٛو مٛيٜ حُنٛرِي وُرٛ شٜنِينغٛ نغٛنْ حُنٛرَکٜنغٛ اٜ اَللَّه جٛوطِيطٛ ندٜرْ مَاغٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","ندٜنْ کٛو مٛيٜ حُنٛرِي دٛوْ، حُنٛرَکٜ جٛوطٛرْغَلْ لَامُ اَللَّه اٜ جٛوطِيطٛ دٛوْ مَاغَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","‏«‏اٛنْ مبٛنِي، اٛنٛنْ مٛودِٻّٜ اَتَّوْرَ اٜ فَارِسَنْکٛعٜنْ!‏ اٛنْ مُنَافُکِعٜنْ!‏ اٛنْ کٛکَّ اَللَّه جَکَّ حَاکٛحٛيْ نجٛنْغٜتٜىٰکٛيْ، اَمَّا اٛنْ تٛکَّايِ کٛ ٻُرِ دَرَجَ ندٜرْ اَتَّوْرَ، وَاتٛ وَطَنْکِ يِمْٻٜ کٛ حَانِ، اٜ يُرْمٜىٰندٜ، اٜ حٛولَاکِ اَللَّه؞ طُعُمْ تَتُمْ اٜ حَانِ نغَطٛنْطُمْ، اَمَّا تٛع اٛنْ اَلُ وَطُکِ کٛ حٛرِي؞ ");
INSERT INTO fuv_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","اٛنٛنْ وُمْٻٜ اَرْدِيٻٜ وُمْٻٜ!‏ اٛنْ اِتَّ بُولُلٜلْ ندٜرْ ندِيَمْ طَمْ نجَرٛتٛنْ، اَمَّا اٛنْ مٛطَ نغٜىٰلٛوبَ!‏ ");
INSERT INTO fuv_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","‏«‏اٛنْ مبٛنِي، اٛنٛنْ مٛودِٻّٜ اَتَّوْرَ اٜ فَارِسَنْکٛعٜنْ، مُنَافُکِعٜنْ!‏ اٛنْ لَيْٻَ غَطَ نجَرْدُکٛيْ مٛوطٛنْ اٜ لٜعٛيْ مٛوطٛنْ، اَمَّا ندٜرْ اٜ حٜىٰوِ نغُيْکَ اٜ شِيَ سُرُکِ حٛورٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","اَنْ فَارِسَنْکٜىٰجٛ بُمْطٛ!‏ اَرْتُ لَيْٻُکِ ندٜرْ جَرْدُغٜلْ نغٜلْ اٜ لٜعٜلْ نغٜلْ، ندٜنْ کٛو تٛيٜ مَاکٛيْ وَرْتَيْ لَٻْطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","‏«‏اٛنْ مبٛنِي، اٛنٛنْ مٛودِٻّٜ اَتَّوْرَ اٜ فَارِسَنْکٛعٜنْ!‏ اٛنْ مُنَافُکِعٜنْ!‏ اٛنْ نَنْدِ اٜ غٜنَالٜ مٛيْتَنَاطٜ نجٛوجٜىٰرِ ندَنٜىٰرِ يَاسِ مَاجٜ اٜ مبٛوطِ يِيکِ، اَمَّا ندٜرْ مَاجٜ اٜ وٛودِ پِعٜ مَيْٻٜ اٜ کٛو اِرِ طُمٜ نٜفْنِيطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","نٛنْ اٛنٛنْ مَا مبَاطٛنْ؞ يِمْٻٜ اٜ نغِعَعٛنْ بٛ اٛنْ اَادِلِعٜنْ، اَمَّا ندٜرْ ٻٜرْطٜ مٛوطٛنْ اٛنْ مُنَافُکِعٜنْ اٛنْ کٜىٰوِي حَلّٜىٰندٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","‏«‏اٛنْ مبٛنِي، اٛنٛنْ مٛودِٻّٜ اَتَّوْرَ اٜ فَارِسَنْکٛعٜنْ!‏ اٛنْ مُنَافُکِعٜنْ!‏ اٛنْ مَحَ غٜنَالٜ بٛطّٜ طٜ سِفْتٛرْکِ اَنَّبٛعٜنْ، طٛنْمَا اٛنْ مٛعِّتِنَ غٜنَالٜ اَادِلِعٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","اٛنْ مبِعَ، ‏‹‏دَا اٜنْ طٛنْ شَرٜلْ مَامَاجِ مٜىٰطٜنْ، دَا اٜنْ مبَلَّايِٻٜ وَرْکِ اَنَّبٛعٜنْ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","نٛنْ کٛلِّرْطٛنْ اٛنْ ٻِٻّٜ بَرْٻٜ اَنَّبٛعٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","تٛو، سٜيْ کٜىٰݧِتٛنْ کُوغَلْ نغَلْ مَامَاجِ مٛوطٛنْ ڤُطِّ!‏ ");
INSERT INTO fuv_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","اٛنٛنْ بٛولٜ، ٻِٻّٜ بٛولٜ کَلُّطٜ!‏ نٛ طُمْ وَطَتَ کِسٛنْ نَتُّکِ وُرٛ حِيتٜ؟ ");
INSERT INTO fuv_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","نغَمْ نٛنْ، اٜ مِ لِلٛنٛيَعٛنْ اَنَّبٛعٜنْ اٜ غٛودُٻٜ فَامُ اٜ مٛودِٻّٜ؞ اٛنْ مبَرَ وٛٻّٜ، اٛنْ مبَرَ وٛٻّٜ دٛوْ غَافَانغَلْ، اٛنْ ڤِيرَ وٛٻّٜ لٛوشِ ندٜرْ شُوطِ دٛعَارٜ مٛوطٛنْ، اٛنْ تٛکَّٻٜ غَرِيرِ‑غَرِيرِ اٛنْ تٛرَّٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","نغَمْ نٛنْ پِيپَمْ فُو اَادِلِعٜنْ بَرَاٻٜ ندُفَاطَمْ ندٜرْ دُونِيَارُ طُمْ طَٻِّتَيْطَمْ دٛوْ مٛوطٛنْ، دَغَ پِيپَمْ حَبِيلَ اَادِلِيجٛ حَا يَاکِ پِيپَمْ اَنَّبِ جَکَارِيَ، ٻِطّٛ بٜرِيکِيَ، مٛ مبَرْطٛنْ حَکُّندٜ سُودُ جٛومِرَاوٛ اٜ سَکِّرْدٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","اٜ مِ وِعَعٛنْ غٛونغَ، پِيپَمْجِ طِنْ طٛنْ فُو طُمْ طَٻِّتَيْطِ تٛ جُوطٜ يِمْٻٜ جَامَنُ طُعُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","‏«‏جَلَّ اُرُشَلِيمَ، اُرُشَلِيمَ اَ وَرِي اَنَّبٛعٜنْ، اَ وَرْدِي لِلٛيَاٻٜ تٛ مَاطَ اٜ کَاپٜ!‏ ندٜ طُطُّمْ اٜ مِ يِطِ مٛٻْتُکِ يِمْٻٜ مَاطَ نٛ غٜرٛوغَلْ مٛٻْتِرْتَ ٻِکّٛيْ مَاغَلْ لٜيْ بِيٜىٰلِ مَاغَلْ، اَمَّا اَ جَٻَايِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","رَطُّمْ، اَللَّه اَلَنَيْعٛنْ وُرٛ شٜنِينغٛ مٛوطٛنْ وِنْدٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","اٜ مِ وِعَعٛنْ، اٛنْ ڤُطِّتَتَا نغِعٛنْيَمْ، نَا ݧَلْندٜ ندٜ مبِيطٛنْ، ‏‹‏اٛ بَرْکِطِنَاطٛ، غَرٛيْطٛ ندٜرْ اِنْدٜ جٛومِرَاوٛ؞›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","يٜىٰسُ اٜ وُرْتٛيٛو وُرٛ شٜنِينغٛ اٜ مٛ يَحَ، سٜيْ تٛکُّٻٜمٛ نغَرِ مبِعِمٛ اٛ رَارَ شُوطِ مَاغٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","سٜيْ اٛ نٛوتِي، اٛ وِعِٻٜ، ‏«‏اٛنْ نغِعِي فُو شُوطِ طِعِ؟ اٜ مِ وِعَعٛنْ غٛونغَ، وَلَا وٛنْدٜ حَيْرٜ اَلٜتٜىٰندٜ دٛوْ وٛنْدٜ؞ طٜ فُو طُمْ سَنْکِتَيْطٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","يٜىٰسُ اٜ جٛوطِي دٛوْ حٛشّٜىٰرٜ ندٜ لٜطّٜ جَيْتُنْ سٜيْ تٛکُّٻٜمٛ نغَرِ تٛ مَاکٛ کَمْٻٜ تَنْ، ٻٜ مبِعِ، ‏«‏وِعُمِنْ، ندٜيٜ فِي طُعُمْ وَطَتَ؟ طُمٜ وٛنِ کٛ حٛلَّتَ وَرْتٛيْکِ مَاطَ اٜ رٜعُکِ دُونِيَارُ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","سٜيْ يٜىٰسُ وِعِٻٜ، ‏«‏ڤَامٜىٰ تٛع غٛطّٛ مَجِّنَعٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","يِمْٻٜ طُطْٻٜ نغَرٛيَيْ ٻٜ مبِعَ کَمْٻٜ نغٛنِ مِنْ، ٻٜ مبِعَ، ‏‹‏مِنْ وٛنِ اَلْمَسِيحُ،›‏ ٻٜ مَجِّنَ يِمْٻٜ طُطْٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","اٛنْ نَنَيْ حَبَرُ کٛنُوجِ غَطٜتٜىٰطِ حَادٜ مٛوطٛنْ، اٜ حَبَرُ کٛنُوجِ غَطٜتٜىٰطِ ٻَدَاکِ؞ تٛع اٛنْ کُلُ، نغَمْ دٛولٜ طُعُمْ وَطَ، اَمَّا رٜعُکِ دُونِيَارُ اٜ حٛرِي تَوْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","لٜݧٛلْ اُمَّنْتٛ لٜݧٛلْ، لَامُ اُمَّنْتٛ لَامُ؞ طُمْ وَطَيْ وٜىٰلٛ کَلُّنغٛ اٜ دِمْبٛلْ لٜيْدِ تٛ بِغٜىٰجٜ فٜىٰرٜ‑فٜىٰرٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","اَمَّا طُعُمْ فُو طُمْ فُطّٛودٜ تٛرَّاجِ غَرَيْطِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","‏«‏ندٜنْ ٻٜ نغَطَيْعٛنْ ندٜرْ جُوطٜ يِمْٻٜ تٛرَّيْٻٜعٛنْ، طُمْ وَرَعٛنْ؞ فُو لٜݧِ دُونِيَارُ نغَݧَيْعٛنْ نغَمْ اٛنْ تٛکُّٻٜيَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","اٜ شَرٜلْ نغٜلْ يِمْٻٜ طُطْٻٜ اَلَيْ حٛولَاکِيَمْ، اٜ ٻٜ نغُلّٛوتِرَ، اٜ ٻٜ نغَݧِندِرَ؞ ");
INSERT INTO fuv_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","اَنَّبٛعٜنْ فٜوْرٜ طُطْٻٜ اُمّٛيْتٛ، ٻٜ مَجِّنَ يِمْٻٜ طُطْٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","حَلّٜىٰندٜ ٻٜيْدٛتٛ حَا يِدّٜ طُطْٻٜ اُسْتٛو؞ ");
INSERT INTO fuv_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","اَمَّا مُݧُطٛ حَا رٜعِرْدٜ اٛ حِسَيْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","ندٜنْ طُمْ وَعَجِنَيْ حَبَرُ بٜلْطُمْ دٛوْ لَامُ اَللَّه کٛو تٛيٜ ندٜرْ دُونِيَارُ، نغَمْ طُمْ وَرْتَ شٜيْدَ تٛ لٜپِّ فُو، ندٜنْ رٜعُکِ دُونِيَارُ کِنْ وَرَ؞ ");
INSERT INTO fuv_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","‏«‏شَرٜلْ اٜ وَرَ نغٜلْ نغِعٛتٛنْ ‏‹‏نٜفْنِيطُم›‏ غَرْتِرٛوجُمْ وُرٛ شٜنِينغٛ نغٛ لَاٻَا اٜ دَرِي تٛ وِغٜىٰرٜ شٜنِيندٜ طُمْ اَنَّبِ دَانِيٜلْ وِعِ؞ فُو جَنْغٛووٛ فَامَ مَعَنَ مَاجُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","اٜ شَرٜلْ نغٜلْ وٛنْٻٜ ندٜرْ لٜيْدِ يَحُودِيَ ندٛغَّ نَتّٛيَ کٛشّٜىٰجٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","غٛنْطٛ دٛوْ سُودُ فُو تٛع جِڤّٛيٛ نغَمْ حٛشُّکِ کٛ وٛنِ ندٜرْ سُودُ؞ ");
INSERT INTO fuv_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","غٛنْطٛ تٛ نغٜسَ تٛع سٛعّٛ نغَمْ حٛشُّکِ شُدَّارِ مُوطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","‏«‏رٜوْٻٜ غٛودُٻٜ دٜىٰطِ اٜ مُسِنْتٜىٰٻٜ ٻٜ تٛرّٛتٛ نَاع سٜطَّ ندٜرْ طٜنْ طٛنْ بَلْطٜ!‏ ");
INSERT INTO fuv_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","نغَطٜىٰ دٛعَارٜ تٛع دٛغُّدُ ندُنْ وَرَنَعٛنْ ندٜرْ ندُنْغُ کٛو ݧَلْندٜ سِوْتَارٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","نغَمْ ندٜرْ طٜنْ طٛنْ بَلْطٜ طُمْ وَطَيْ تٛرَّ کَلُّکَ مَوْکَ اِرِ کَ طُمْ مٜىٰطَايِ وَطُکِ دَغَ شَرٜلْ نغٜلْ اَللَّه تَغِ دُونِيَارُ حَا جٛونِ؞ طُمْ بٛو فُطِّتَتَا طُمْ وَطَ اِرِ کَنْ طٛنْ تٛرَّ؞ ");
INSERT INTO fuv_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","دَا اَللَّه اُسْتَايِ طٜنْ طٛنْ بَلْطٜ، دَا وَلَا غٛطّٛ کِسَيْطٛ؞ اَمَّا نغَمْ ٻٜنْ طٛنْ شُٻَاٻٜ مَاکٛ، اٛ اُسْتَيْ بَلْطٜ طٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","‏«‏اٜ نغٜلْ طٛنْ شَرٜلْ تٛ غٛطّٛ وِعِيعٛنْ، ‏‹‏رَا اَلْمَسِيحُ طٛعٛ!‏›‏ کٛو بٛو، ‏‹‏رَمّٛ طَاعٜ!‏›‏ تٛع اٛنْ نجَٻُ؞ ");
INSERT INTO fuv_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","نغَمْ اَلْمَسِيحُعٜنْ فٜوْرٜ اٜ اَنَّبٛعٜنْ فٜوْرٜ مبُرْتٛيْتٛ، ٻٜ نغَطَ اَلَامَاجِ مَوْطِ اٜ کُوطٜ کَيْطِنِيطٜ نغَمْ ٻٜ مَجِّنَ يِمْٻٜ، حَا اٜ شُٻَاٻٜ ٻٜنْ تٛ طُمْ وَطٛتٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","رَطُّمْ، مِ وِعِيعٛنْ کٛو طُمٜ کٛ شَرٜلْ نغٜلْ وَرَ؞ ");
INSERT INTO fuv_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","‏«‏نغَمْ نٛنْ، تٛ ٻٜ مبِعِيعٛنْ، ‏‹‏رَمّٛ طَاعٜ ندٜرْ لَدّٜ،›‏ تٛع اٛنْ نجَحُ؞ کٛو تٛ ٻٜ مبِعِيعٛنْ، ‏‹‏رَمّٛ طٛعٛ اٜ مٛ سُوطِي ندٜرْ شُوطِ،›‏ تٛع اٛنْ نجَٻُ؞ ");
INSERT INTO fuv_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","نٛنْ نٛ مَپّٜرٜ مَپِّرْتَ دَغَ فُونَ ندٜ يِعٜ حَا حِرْنَ، نٛنْ وَرْتُکِ ٻِي نٜطّٛ وَعَتَ؞ ");
INSERT INTO fuv_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","‏«‏فُو تٛ بَاتُطُمْ وٛنِ، طٛنْ جِغَاجٜ کَوْرِتَتَ؞ ");
INSERT INTO fuv_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","‏«‏غَطَ تٛرَّ کَلُّکَ کَنْ، طٛنْ اٜ طٛنْ طُمْ ٻَلْوِنَيْ نَانغٜ، لٜوْرُ بٛو حٛکَّتَا جَيْنغٛلْ مَيْرُ؞ کٛودٜ نجَنٛيَيْ دَغَ دٛوْ، ندٜنْ کٛ وٛنِ دٛوْ فُو دِمْبٛتٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","اٜ شَرٜلْ نغٜلْ طُمْ يِعَيْ اَلَامَ ٻِي نٜطّٛ وَنْغِي تٛنْ دٛوْ، ندٜنْ فُو لٜݧِ دُونِيَارُ مبٛيَيْ بٛجِّ نَوْطِ؞ سٜيْ ٻٜ نغِعَ ٻِي نٜطّٛ اٜ وَرَ ندٜرْ دُولٜ اٜ بَوْطٜ اٜ تٜدُّنغَلْ مَنْغَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","اٛ وَطَيْ طُمْ دُودَ لُوَلْ سٜمْبٜىٰ دُودُکِ لِلُکِ مَلَاعِکَعٜنْ مَاکٛ، ٻٜ کَوْرِتَ ٻٜ اٛ سُٻِ دَغَ کٛو تٛيٜ ندٜرْ دُونِيَارُ، دَغَ نغٛعٛلْ کٜىٰرٛلْ دُونِيَارُ يَاکِ نغٛلْ تٛنْ کٜىٰرٛلْ دُونِيَارُ؞ ");
INSERT INTO fuv_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","‏«‏تٛو، اٜکِّتٜىٰ اٜکِّتِنٛلْ نغٛعٛلْ دَغَ تٛ اِبِّ؞ تٛ لِشٜ مَاکِ ڤُطِّ وِلُتُکِ، اٛنْ اَنْدِ ندُنْغُ ٻَدَکٜ وٛنْ طٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","نٛنْ مَا تٛ اٛنْ نغِعِي فُو فِي طُعُمْ اٜ وَطَ، تٛو، اٛنْ اَنْدَيْ ٻِي نٜطّٛ ٻَدَکٜ وَرْتٛيَ، اٜ مٛ حَادٜ دَمُّغَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","اٜ مِ وِعَعٛنْ غٛونغَ، جَامَنُ طُعُمْ طُمْ رٜعَتَا نَا فُو فِي طُعُمْ وَطِي؞ ");
INSERT INTO fuv_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","دٛوْ اٜ لٜيْ پَٻّٛتٛ، اَمَّا بٛلِيطٜ اَمْ پَٻَّتَاکٛ حَا اَبَدَا؞ ");
INSERT INTO fuv_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","‏«‏وَلَا اَنْدُطٛ ندٜنْ طٛنْ ݧَلْندٜ کٛو نغٜلْ طٛنْ شَرٜلْ نغٜلْ فِي طُمْ طٛنْ وَطَتَ؞ کٛو مَلَاعِکَعٜنْ وٛنْٻٜ دٛوْ اَنْدَا، کٛو ٻِطّٛ اٛنْ مَا اَنْدَا، سٜيْ ݧَاکٛ مٛ دٛوْ تَنْ اَنْدِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","نٛنْ نٛ طُمْ وَطِ اٜ جَامَنُ اَنَّبِ نُحُ، نٛنْ مَا وَرْتٛيْکِ ٻِي نٜطّٛ وَعَتَ؞ ");
INSERT INTO fuv_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","ندٜرْ بَلْطٜ کٛ ندِيَمْ تُفَانَ وَطَ، يِمْٻٜ اٜ ݧَامَ، اٜ نجَرَ، اٜ تٜعَ، اٜ تٜعٜىٰ، حَا شَرٜلْ کٛ اَنَّبِ نُحُ نَتِّ کٛمِوَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","ٻٜ ڤَامَايِ حَا ندِيَمْ تُفَانَ وَرِ حَلْکِٻٜ ٻٜ فُو؞ نٛنْ مَا وَرْتٛيْکِ ٻِي نٜطّٛ وَعَتَ؞ ");
INSERT INTO fuv_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","اٜ شَرٜلْ نغٜلْ، وٛرْٻٜ طِطٛ اٜ کُوَ اٜ نغٜسَ، طُمْ حٛشَّ غٛعٛتٛ طُمْ اَلَ غٛعٛتٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","رٜوْٻٜ طِطٛ اٜ نَمِدَ، طُمْ حٛشَّ غٛعٛتٛ طُمْ اَلَ غٛعٛتٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","نجٛوطٜىٰ اٛنْ شِرْيِي، نغَمْ اٛنْ اَنْدَا شَرٜلْ کٛ جٛومِرَاوٛ مٛوطٛنْ وَرَتَ؞ ");
INSERT INTO fuv_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","اَمَّا اَنْدٜىٰ طُعُمْ، دَا جٛومُ وُرٛ اٜ اَنْدِ شَرٜلْ نغٜلْ غُجّٛ وَرَنْتَمٛ جٜمَّ، دَا اٛ جٛوطٛتٛ اٜ مٛ سِرْيِي اٛ اَلَتَا اٛ نَتَّنَمٛ وُرٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","نغَمْ نٛنْ، اٛنٛنْ مَا دٛولٜ نجٛوطٛوطٛنْ اٛنْ شِرْيِي نغَمْ اٜ شَرٜلْ نغٜلْ اٛنْ اَنْدَا ٻِي نٜطّٛ وَرَتَ؞ ");
INSERT INTO fuv_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","‏«‏مٛيٜ وٛنِ مَشُّطٛ مٛ غٛونغَ مٛ فَامُ، مٛ جٛومُ وُرٛ مُوطُمْ يٛوِ دٛوْ مَشُّٻٜ مُوطُمْ، نغَمْ اٛ حٛکَّٻٜ ݧَمْندُ ندٜرْ شَرٜلْ؟ ");
INSERT INTO fuv_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","اٛ بَرْکِطِنَاطٛ مَشُّطٛ مٛ جٛومُ وُرٛ مُوطُمْ وَرْتِ تَوِ اٜ مٛ وَطَ نٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","اٜ مِ وِعَعٛنْ غٛونغَ، جٛومُ وُرٛ اٛنْ يٛوَيْمٛ دٛوْ جَوْدِ مُوطُمْ فُو؞ ");
INSERT INTO fuv_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","اَمَّا تٛ مَشُّطٛ اٛنْ اٛ کَلُّطٛ اٛ وِعَيْ حٛورٜ مَاکٛ، ‏‹‏جٛومُ وُرٛ اَمْ وَرْتَتَا جٛونِ،›‏ ");
INSERT INTO fuv_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","سٜيْ اٛ فُطِّ فِيُکِ مَشُّٻٜ ٻٜ اٛ حُودَتَ، اٜ مٛ ݧَامَ، اٜ مٛ يَرْدَ نجَرُ اٜ يَرٛوٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","جٛومُ وُرٛ اٛنْ وَرْتَيْ اٜ ݧَلْندٜ ندٜ مَشُّطٛ اٛنْ کَمَّاکِ اٜ شَرٜلْ نغٜلْ اٛ اَنْدَا، ");
INSERT INTO fuv_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","اٛ فِيَيْمٛ بٛطُّمْ اٛ وَطَمٛ ندٜرْ مُنَافُکِعٜنْ؞ طٛنْ طُمْ وٛيَتَ طُمْ ݧٜرْپِندِرَ ݧِيپٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","‏«‏ندٜنْ طُمْ نَنْدِنَيْ لَامُ اَللَّه اٜ سُرْبَاٻٜ سَڤّٛ کٛشُّٻٜ فِتِلَاجِ ٻٜ ندِلِّ تَٻّٛيَاکِ اَنْغٛوجٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","نجٛوٛ ندٜرْ مَٻّٜ اٜ نغٛودِ فَامُ، نجٛوٛ ندٜرْ مَٻّٜ بٛو نغَلَا فَامُ؞ ");
INSERT INTO fuv_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","شَرٜلْ کٛ سُرْبَاٻٜ ٻٜ نغَلَا فَامُ ٻٜنْ کٛشِّ فِتِلَاجِ مَٻّٜ، ٻٜ نجٛغَاکِ نٜبَّمْ فِتِلَ فٜىٰرٜ ندٜرْ کٛلْبَاجِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","غٛودُٻٜ فَامُ ٻٜنْ بٛو کٛشِّ فِتِلَاجِ مَٻّٜ اٜ نٜبَّمْ فٜىٰرٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","ندٜ اَنْغٛوجٛ اٛنْ نٜىٰٻِ يٛتَّاکِ، سٜيْ ٻٜ فُو ٻٜ ڤُطِّ ݝٛݝُکِ حَا ٻٜ طَانِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","‏«‏تٛنْ شَکَ جٜمَّ سٜيْ طُمْ نَنِ نٛدّٛلْ سٜمْبٜىٰ، اٜ طُمْ وِعَ، ‏‹‏رَا اَنْغٛوجٛ اٛنْ!‏ مبُرْتٛيٜىٰ، تَٻّٜىٰمٛ!‏›‏ ");
INSERT INTO fuv_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","سٜيْ سُرْبَاٻٜ ٻٜنْ فُو اُمِّي شِرْيِي فِتِلَاجِ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","ٻٜ نغَلَا فَامُ ٻٜنْ مبِعِ غٛودُٻٜ فَامُ ٻٜنْ، ‏‹‏کٛکّٛرٜىٰمِنْ نٜبَّمْ مٛوطٛنْ سٜطَّ؞ فِتِلَاجِ اَمِنْ اٜ مبَاتَ!‏›‏ ");
INSERT INTO fuv_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","اَمَّا غٛودُٻٜ فَامُ ٻٜنْ مبِعِٻٜ، ‏‹‏نَاع نٛنْ، طَمْ حٜپَتَاعٜنْ؞ طُمْ ٻُرِي نجَحٛنْ تٛ سٛورٛوٻٜ، شٛودٛيٛنْ طَمْ مٛوطٛنْ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","اٜ ٻٜ دٛوْ لَاوٛلْ سٛودٛيْکِطَمْ، سٜيْ اَنْغٛوجٛ اٛنْ يٛتِّي؞ شِرْيِيٻٜ فِتِلَاجِ ٻٜنْ نَتِّدِ اٜ مَاکٛ ندٜرْ وُرٛ تٛ طُمْ وَطَتَ حُمْتٛ نغٛنْ؞ طُمْ مَٻِّي دَمُّغَلْ وُرٛ نغٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","‏«‏دَغَ غَطَ سٜيْ سُرْبَاٻٜ کٛرِيٻٜ ٻٜنْ مَا نغَرْتِ، ٻٜ مبِعِ، ‏‹‏جٛومُ وُرٛ!‏ جٛومُ وُرٛ!‏ مَٻِّتَنْمِنْ!‏›‏ ");
INSERT INTO fuv_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","اَمَّا اٛ نٛوتِي، اٛ وِعِ، ‏‹‏اٜ مِ وِعَعٛنْ غٛونغَ، مِ اَنْدَاعٛنْ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","‏«‏نغَمْ نٛنْ، سٜيْ نجٛوطٛوطٛنْ اٛنْ شِرْيِي، نغَمْ اٛنْ اَنْدَا ݧَلْندٜ ندٜنْ کٛو شَرٜلْ نغٜلْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","‏«‏طٛنْمَا، لَامُ اَللَّه اٜ نَنْدِ اٜ غٛطّٛ نٜطّٛ غَطَيْطٛ يَادُ، سٜيْ اٛ نٛدِّ مَشُّٻٜ مَاکٛ اٛ تَمْبِنِٻٜ جَوْدِ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","اٛ حٛکِّ غٛعٛتٛ جَکَاجٜ جٛوِ کٜوْطٜ شٜىٰدٜ جِينَارِ، غٛعٛتٛ بٛو جَکَاجٜ طِطِ، غٛعٛتٛ بٛو جَکَارٜ غٛعٛ؞ اٛ حٛکِّ کٛو مٛيٜ نٛ وَاوَتَ، ندٜنْ اٛ دِلِّ؞ ");
INSERT INTO fuv_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","جَٻُطٛ جَکَاجٜ جٛوِ اٛنْ، طٛنْ اٜ طٛنْ اٛ دِلِّ اٛ وَادِ لُومٛ اٜ شٜىٰدٜ طٜنْ حَا اٛ حٜٻِ بٛ مَاجٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","نٛنْ مَا جَٻُطٛ جَکَاجٜ طِطِ اٛنْ حٜٻِ بٛ مَاجٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","اَمَّا جَٻُطٛ جَکَارٜ غٛعٛ اٛنْ يَحِ وَسِ نغَيْکَ سُوطِ شٜىٰدٜ جِينَارِ جٛومُ وُرٛ مُوطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","‏«‏تٛو، غَطَ طُمْ نٜىٰٻِي، سٜيْ جٛومُ مَشُّٻٜ اٛنْ وَرْتِ نغَمْ يِعَ کٛ کٛو مٛيٜ حٜٻَنِمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","سٜيْ جَٻُطٛ جَکَاجٜ جٛوِ کٜوْطٜ شٜىٰدٜ جِينَارِ وَرِ وَدِّ شٜىٰدٜ جَکَاجٜ جِينَارِ جٛوِ طٜ اٛ ٻٜيْدِي؞ اٛ وِعِ، ‏‹‏جٛومُ وُرٛ، اَ حٛکِّييَمْ جَکَاجٜ کٜوْطٜ شٜىٰدٜ جِينَارِ جٛوِ؞ رَا مِ ٻٜيْدِي جَکَاجٜ شٜىٰدٜ جٛوِ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","سٜيْ جٛومُ وُرٛ اٛنْ وِعِمٛ، ‏‹‏اَ حُوِي بٛطُّمْ، مَشُّطٛ بٛطّٛ مٛ غٛونغَ؞ ندٜ اَ وَطِي غٛونغَ دٛوْ فِي سٜطَّ، مِ تَمْبِنْتٜ طُطُّمْ؞ وٛرٛيْ، نَنِدَا بٜلْطُمْ اٜ اَمْ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","سٜيْ جَٻُطٛ جَکَاجٜ طِطِ کٜوْطٜ شٜىٰدٜ جِينَارِ مَا وَرِ، وِعِ، ‏‹‏جٛومُ وُرٛ، اَ حٛکِّييَمْ جَکَاجٜ طِطِ کٜوْطٜ شٜىٰدٜ جِينَارِ؞ رَا مِ ٻٜيْدِي جَکَاجٜ شٜىٰدٜ طِطِ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","سٜيْ جٛومُ وُرٛ اٛنْ وِعِمٛ، ‏‹‏اَ حُوِي بٛطُّمْ، مَشُّطٛ بٛطّٛ مٛ غٛونغَ؞ ندٜ اَ وَطِي غٛونغَ دٛوْ فِي سٜطَّ؞ مِ تَمْبِنْتٜ طُطُّمْ؞ وٛرٛيْ، نَنِدَا بٜلْطُمْ اٜ اَمْ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","ندٜنْ جَٻُطٛ جَکَارٜ غٛعٛ کٜوْندٜ شٜىٰدٜ جِينَارِ اٛنْ وَرِ، وِعِ، ‏‹‏جٛومُ وُرٛ، اٜ مِ اَنْدِ اَ نٜطّٛ شَطَنْطٛ، اَ يِطِ فٜعُّکِ کٛ اَ اَاوَايِ، اَ غِطّٛ مٜىٰرٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","اٜ مِ حُلَ، نغَمْ نٛنْ نجَامِ نغَسُمِ نغَيْکَ شُوطُمِ شٜىٰدٜ مَاطَ ندٜرْ لٜيْدِ؞ رَا شٜىٰدٜ مَاطَ!‏›‏ ");
INSERT INTO fuv_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","سٜيْ جٛومُ وُرٛ اٛنْ نٛوتِي، وِعِ، ‏‹‏اَنْ اَ مَشُّطٛ کَلُّطٛ، دَکِّيطٛ!‏ تٛو، اٜ يِيکِ مَاطَ اٜ مِ فٜعَّ کٛ مِ اَاوَايِ، ندٜنْ مِ غِطّٛ مٜىٰرٜ؟ ");
INSERT INTO fuv_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","اٜ حَانِ ندٜسَنَايَمْ شٜىٰدٜ تٛ طٜ کُوتِرْتٜىٰ طٜ ٻٜيْدٛو، نغَمْ تٛ مِ وَرْتٛيِي مِ جَٻَطٜ حَا اٜ ٻٜيْدَارِ!‏ ");
INSERT INTO fuv_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","نغَمْ نٛنْ، نجَٻٜىٰ شٜىٰدٜ طٜنْ تٛ مَاکٛ، کٛکّٛنْ اٛنْ طٛنْ غٛودُطٛ جَکَاجٜ سَڤّٛ کٜوْطٜ شٜىٰدٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","نغَمْ فُو غٛودُطٛ، طُمْ ٻٜيْدَنَيْمٛ، حَا طُمْ طُوطَنَمٛ؞ اَمَّا مٛ وَلَا، کٛو کٛ اٛ وٛودِ مَا طُمْ جَٻَيْطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","ندٜنْ ڤَطّٜىٰ مَشُّطٛ اٛعٛ مٜىٰرٜىٰجٛ ندٜرْ ݧِوْرٜ ٻَلٜىٰرٜ، تٛ طُمْ وٛيَتَ طُمْ ݧٜرْپِندِرَ ݧِيپٜ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","‏«‏تٛ ٻِي نٜطّٛ وَرِي ندٜرْ تٜدُّنغَلْ مُوطُمْ اٜ مَلَاعِکَعٜنْ فُو، اٛ جٛوطٛتٛ دٛوْ جٛوطٛرْغَلْ لَامُ مَاکٛ طُمْ تٜدُّنغَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","طُمْ حَوْرِتَيْ يِمْٻٜ دُونِيَارُ فُو يٜىٰسٛ مَاکٛ، اٛ حَکِّتَٻٜ فٜىٰرٜ‑فٜىٰرٜ نٛنْ نٛ غَيْنَاکٛ حَکِّتِرْتَ بَالِ اٜ بٜعِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","اٛ وَطَ بَالِ اٜ جُنْغٛ ݧَامٛ مَاکٛ، بٜعِ اٜ نَنٛ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","سٜيْ لَامِيطٛ اٛنْ وِعَ وٛنْٻٜ ݧَامٛ مُوطُمْ، ‏‹‏نغَرٜىٰ، اٛنٛنْ ٻٜ ݧَاکٛ اَمْ بَرْکِطِنِ، ندٛنٜىٰ لَامُ طُمْ اُمْ سِرْيَنِيعٛنْ دَغَ فُطّٛودٜ دُونِيَارُ؞ ");
INSERT INTO fuv_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","نغَمْ مِ نَنِي وٜىٰلٛ اٛنْ کٛکِّييَمْ ݧَمْندُ؞ مِ نَنِي طٛنْکَ اٛنْ کٛکِّييَمْ کٛ نجَرَيْمِ؞ مِ وَطِي کٛطَاکُ اٛنْ نجِڤِّنِييَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","مِ وَلَا کٛ ٻٛرْنٛتٛومِ اٛنْ کٛکِّييَمْ کٛلْتٜ؞ مِ وَطِي شِيَ نجَمُ اٛنْ ڤَامَنِييَمْ؞ اٜ مِ سُرِ ندٜرْ سُودُ شُرَلْ اٛنْ کٛوْنِييَمْ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","اٜ شَرٜلْ نغٜلْ اَادِلِعٜنْ نٛوتٛتٛ، مبِعَمٛ، ‏‹‏مٛودِبّٛ، ندٜيٜ مِنْ نغِيدُمَا اٜ وٜىٰلٛ مِنْ کٛکُّمَا ݧَمْندُ، کٛو مِنْ نغِيدُمَا اٜ طٛنْکَ مِنْ کٛکُّمَا کٛ نجَرَتَا؟ ");
INSERT INTO fuv_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","ندٜيٜ مِنْ نغِيمَا اَ کٛطٛ مِنْ نجِڤِّنْمَا، کٛو اَ وَلَا کٛ ٻٛرْنٛتٛطَا مِنْ کٛکُّمَا کٛلْتٜ؟ ");
INSERT INTO fuv_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","ندٜيٜ مِنْ نغِيمَا اَ يَمْطَا کٛو اَ سُرِي ندٜرْ سُودُ شُرَلْ مِنْ کٛوْنُمَا؟›‏ ");
INSERT INTO fuv_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","سٜيْ لَامِيطٛ اٛنْ نٛوتٛو، وِعَٻٜ، ‏‹‏اٜ مِ وِعَعٛنْ غٛونغَ، ندٜ اٛنْ نغَطَنِ غٛعٛتٛ ندٜرْ ٻٜعٜ بَنْدِرَاٻٜ اَمْ ٻُرْٻٜ فَمْطُکِ، مِنْ نغَطَنْطٛنْ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","‏«‏ندٜنْ اٛ وِعَيْ وٛنْٻٜ نَنٛ مَاکٛ، ‏‹‏شٜنْدِرٜىٰ اٜ اَمْ، اٛنٛنْ لَانَاٻٜ!‏ نَتّٜىٰ حِيتٜ نغٜ ݧِفَتَا حَا اَبَدَا نغٜ طُمْ سِرْيَنِي شٜيْطَنْ اٜ مَلَاعِکَعٜنْ مُوطُمْ!‏ ");
INSERT INTO fuv_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","نغَمْ مِ نَنِي وٜىٰلٛ اٛنْ کٛکَّايِيَمْ ݧَمْندُ؞ مِ نَنِي طٛنْکَ اٛنْ کٛکَّايِيَمْ کٛ نجَرَيْمِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","مِ وَطِي کٛطَاکُ اٛنْ نجِڤِّنَايِيَمْ؞ مِ وَلَا کٛ ٻٛرْنٛتٛومِ اٛنْ کٛکَّايِيَمْ کٛلْتٜ؞ مِ وَطِي شِيَ نجَمُ اٛنْ ڤَامَنَايِيَمْ؞ مِ سُرَامَ ندٜرْ سُودُ شُرَلْ اٛنْ کٛوْنَايِيَمْ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","ندٜنْ کَمْٻٜ مَا ٻٜ نٛوتٛو، ٻٜ مبِعَمٛ، ‏‹‏مٛودِبّٛ، ندٜيٜ مِنْ نغِيدُمَا اٜ وٜىٰلٛ، کٛو اٜ طٛنْکَ، کٛو اٜ شِيَ کٛلْتٜ، کٛو اٜ شِيَ نجَمُ، ندٜيٜ مِنْ نغِيمَا اَ کٛطٛ، کٛو اَ ندٜرْ سُودُ شُرَلْ، مِنْ مبَلَّايِمَ؟›‏ ");
INSERT INTO fuv_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","سٜيْ اٛ نٛوتٛو، اٛ وِعَٻٜ، ‏‹‏اٜ مِ وِعَعٛنْ غٛونغَ، ندٜ اٛنْ نغَطَنَايِ کٛو غٛعٛتٛ ندٜرْ ٻٜعٜ ٻُرْٻٜ فَمْطُکِ، مِنْ وٛنِ اٛنْ نغَطَنَايِ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","ٻٜعٜ نغٛنِ نَتَّيْٻٜ بٛنٜ طُمْ رٜعَتَا، اَادِلِعٜنْ بٛو کٜٻَ يٛنْکِ کِ رٜعَتَا؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","ندٜ يٜىٰسُ يٛتِّنِ وِيکِ فُو فِي طُعُمْ، اٛ وِعِ تٛکُّٻٜمٛ، ");
INSERT INTO fuv_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","‏«‏اٛنْ اَنْدِ حُمْتٛ سَکِّنْکِ حَنْدٜ حٛرِي بَلْطٜ طِطِ، طُمْ حٛکِّتِرَيْ ٻِي نٜطّٛ طُمْ وَرَمٛ دٛوْ غَافَانغَلْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","سٜيْ مَوْٻٜ اَرْدِيٻٜ دِينَ اٜ مَوْٻٜ يِمْٻٜ کَوْرِتِ اٜ لَامٛرْدٜ مَوْطٛ مَوْٻٜ اَرْدِيٻٜ دِينَ بِعٜتٜىٰطٛ کَيَافَ؞ ");
INSERT INTO fuv_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ٻٜ کَٻِّ ٻٜ نَنْغَ يٜىٰسُ اٜ سُوطٜ ٻٜ مبَرَمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","ٻٜ مبِعِ، ‏«‏اَمَّا نَاع نِ شَرٜلْ حُمْتٛ سَکِّنْکِ، نغَمْ طُمْ غَطٛتٛوطُمْ يِمْٻٜ اُمِّنَ حَوْرٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","يٜىٰسُ اٜ ندٜرْ غَرِيرِ بٜتَنِ تٛ وُرٛ سِيمَنْ غٛودُطٛ ݧَوُ ݧَامٛوجُمْ لَرَلْ، ");
INSERT INTO fuv_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","سٜيْ غٛطّٛ دٜبّٛ وَرِ تٛ مَاکٛ اٜ جٛغِي جٛلّٛيٜلْ حَيْرٜ بٛنْغٜلْ نغٜلْ نٜبَّمْ اُرٛوجَمْ مبٜلْطَمْ غٛودُطَمْ شٜىٰدٜ؞ يٜىٰسُ اٜ ݧَامَ ݧَمْندُ، سٜيْ دٜبّٛ اٛنْ وَيْلِطَمْ دٛوْ حٛورٜ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","اَمَّا ندٜ تٛکُّٻٜمٛ نغِعِ نٛنْ، سٜيْ ٻٜرْطٜ مَٻّٜ مٜتِّ، ٻٜ مبِعِ، ‏«‏نغَمْ طُمٜ اٛ وٛنِّ نٜبَّمْ طَعَمْ نِحِ؟ ");
INSERT INTO fuv_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","دَا طَمْ سٛورَامَ شٜىٰدٜ طُطّٜ، طُمْ حٛکَّ ٻٜ نغَلَنَا شٜىٰدٜ طٜنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","اَمَّا يٜىٰسُ فَامِ کٛ وٛنِ ندٜرْ ٻٜرْطٜ مَٻّٜ، سٜيْ اٛ وِعِٻٜ، ‏«‏نغَمْ طُمٜ نغَنّٛتٛنْ دٜبّٛ اٛعٛ؟ کٛ اٛ وَطَنِيَمْ طُمْ بٛطُّمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","کٛو ندٜيٜ ٻٜ نغَلَنَا اٜ نغٛنْدِ اٜ مٛوطٛنْ، اَمَّا مِنْ، شَرٜلْ اٜ وَرَ نغٜلْ اَلَيْمِعٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","ندٜ اٛ وَيْلِ طَعَمْ نٜبَّمْ دٛوْ ٻَنْدُ اَمْ، اٛ وَطُ نٛنْ نغَمْ سِرْيَاکِ اُوُکِيَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","اٜ مِ وِعَعٛنْ غٛونغَ، کٛو تٛيٜ تٛ طُمْ وَعَجِنِ طُعُمْ حَبَرُ بٜلْطُمْ ندٜرْ دُونِيَارُ فُو، طُمْ حٛکَّيْ حَبَرُ کٛ دٜبّٛ اٛعٛ وَطِ نغَمْ سِفْتٛرْکِمٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","سٜيْ غٛعٛتٛ ندٜرْ تٛکُّٻٜ يٜىٰسُ سَڤّٛ اٜ طِطٛ بِعٜتٜىٰطٛ يَحُودَ اِسْکَرِيٛوتِ يَحِ تٛ مَوْٻٜ اَرْدِيٻٜ دِينَ، ");
INSERT INTO fuv_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","اٛ وِعِ، ‏«‏طُمٜ کٛکّٛتٛنْيَمْ تٛ مِ وَطِي يٜىٰسُ ندٜرْ جُوطٜ مٛوطٛنْ؟»‏ سٜيْ ٻٜ کٛکِّمٛ شٜىٰدٜ اَجُرْفَارِ کَنْجٜ 30؞ ");
INSERT INTO fuv_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","دَغَ شَرٜلْ نغٜلْ يَحُودَ فُطِّ طَٻُّتُکِ لَاوٛلْ نٛ حٛکِّتِرْتَ يٜىٰسُ ندٜرْ جُوطٜ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","ݧَلْندٜ اَرَنْدٜىٰرٜ ندٜ حُمْتٛ بُرٛودِ طُمْ وَلَا پُوفِنِرْطُمْ، سٜيْ تٛکُّٻٜمٛ نغَرِ تٛ مَاکٛ، ٻٜ مبِعِمٛ، ‏«‏تٛيٜ نغِطَّا مِنْ نجَحَ مِنْ شِرْيَنٛمَا نغَمْ ݧَامٜنْ ݧَمْندُ حُمْتٛ سَکِّنْکِ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","سٜيْ اٛ وِعِ، ‏«‏نَتّٜىٰ غَرِيرِ تٛ غٛطّٛ نٜطّٛ مبِعٛنْمٛ، ‏‹‏مٛودِبّٛ وِعِ:‏ شَرٜلْ اَمْ ٻَدَکٜ؞ مِ وَطَيْ حُمْتٛ سَکِّنْکِ اٜ تٛکُّٻٜيَمْ تٛ وُرٛ مَاطَ؞›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","سٜيْ تٛکُّٻٜمٛ ٻٜنْ نغَطِ نٛنْ نٛ يٜىٰسُ وِعِٻٜ، سٜيْ ٻٜ شِرْيِي کٛو طُمٜ نغَمْ حُمْتٛ سَکِّنْکِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","ندٜ فُتُرٛ وَطِ، يٜىٰسُ جٛوطِي نغَمْ ݧَمْدَ اٜ تٛکُّٻٜمٛ سَڤّٛ اٜ طِطٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","اٜ ٻٜ ندٜرْ ݧَامُکِ، سٜيْ اٛ وِعِ، ‏«‏اٜ مِ وِعَعٛنْ غٛونغَ، غٛعٛتٛ ندٜرْ مٛوطٛنْ حٛکِّتِرَيْيَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","سٜيْ ٻٜ نغَنِّ نَاع سٜطَّ، ٻٜ ڤُطِّ وِعُکِمٛ غٛعٛتٛ‑غٛعٛتٛ، ‏«‏مٛودِبّٛ، نَاع طُمْ مِنْ، کٛو؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","سٜيْ اٛ نٛوتِي، اٛ وِعِ، ‏«‏نٜطّٛ ݧَمْدَيْطٛ اٜ اَمْ اٜ لٜعَلْ غٛعٛ، کَنْکٛ حٛکِّتِرْتَيَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","ٻِي نٜطّٛ مَايَيْ نٛ طُمْ وِنْدِرَا دٛوْ مَاکٛ، اَمَّا کٛکِّتِرَيْطٛمٛ وٛنِي!‏ طُمْ ٻُرَنَيْمٛ دَا اٛ دَݧَاکَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","سٜيْ يَحُودَ کٛکِّتِرَيْطٛمٛ وِعِ، ‏«‏مٛودِبّٛ، نَاع طُمْ مِنْ، کٛو؟»‏ يٜىٰسُ وِعِمٛ، ‏«‏اٜىٰ، طُمْ اَنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","اٜ ٻٜ ندٜرْ ݧَامُکِ ݧَمْندُ، سٜيْ يٜىٰسُ حٛشِّ بُرٛودِ يٜتِّ اَللَّه، اٛ سٜنْدِطُمْ، اٛ حٛکِّ تٛکُّٻٜمٛ، اٛ وِعِ، ‏«‏نجَٻٜىٰطُمْ، ݧَامٛنْ؞ طُعُمْ طُمْ ٻَنْدُ اَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","طٛنْمَا اٛ حٛشِّ جَرْدُغٜلْ ندِيَمْ اِنَبٛجَمْ، اٛ يٜتِّ اَللَّه، اٛ حٛکِّٻٜطَمْ، اٛ وِعِ، ‏«‏نجَرٜىٰ، اٛنْ فُو، ");
INSERT INTO fuv_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","نغَمْ طَعَمْ کَنْجَمْ وٛنِ پِيپَمْ اَمْ تَبِّتِنَيْطَمْ اَلْکَوَلْ اَللَّه ندُفٜتٜىٰطَمْ نغَمْ يِمْٻٜ طُطْٻٜ نغَمْ يَافَاکِ حَکّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","اٜ مِ وِعَعٛنْ، مِ فُطِّتَتَا مِ يَرَ ندِيَمْ اِنَبٛوجٜ نَا ݧَلْندٜ ندٜ نجَرَيْمِ نغٛطَّمْ کٜسَمْ حَوْتِ اٜ مٛوطٛنْ ندٜرْ لَامُ ݧَاکٛ اَمْ مٛ دٛوْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","سٜيْ ٻٜ نغِمِ غِمٛلْ مَنْتُکِ اَللَّه، ندٜنْ ٻٜ ندِلِّ حٛشّٜىٰرٜ ندٜ لٜطّٜ جَيْتُنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","يٜىٰسُ وِعِ تٛکُّٻٜمٛ، ‏«‏ندٜرْ جٜمَّارٜ ندٜعٜ اٛنْ فُو اٛنْ ندٛغَّيْ اَلٛنْيَمْ، نغَمْ ندٜرْ اَايَارٜ اَللَّه وِعِي، ‏‹‏مِ وَرَيْ غَيْنَاکٛ، ندٜنْ اٛرْندٜ بَالِ طِنْ شَنْکِتٛتٛ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","اَمَّا غَطَ مِ اُمَّکٜ دَغَ مَيْدٜ، مِ اَرْتَيْعٛنْ يَاکِ غَلِيلِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","سٜيْ بِيتُرُسْ وِعِمٛ، ‏«‏کٛو ٻٜ فُو ٻٜ اَلِيمَ، مِنْ مِ اَلَتَامَ کٛو سٜطَّ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","يٜىٰسُ وِعِمٛ، ‏«‏اٜ مِ وِعُمَا غٛونغَ، حَنْدٜ، ندٜرْ جٜمَّارٜ ندٜعٜ، کٛ نجَکَرْدِ حَنَ، اَ وِعَيْ اَ اَنْدَايَمْ ندٜ تَتِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","اَمَّا بِيتُرُسْ وِعِمٛ، ‏«‏کٛو طُمْ وَرْدَيْيَمْ اٜ مَاطَ، مِ وِعَتَا مِ اَنْدَامَ؞»‏ حٛرِيٻٜ ٻٜنْ مَا مبِعِ نٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","سٜيْ يٜىٰسُ يَادِ اٜ تٛکُّٻٜمٛ وٛنْدٜ وِغٜىٰرٜ بِعٜتٜىٰندٜ غٜىٰسَمَنِ، اٛ وِعِٻٜ، ‏«‏نجٛوطٜىٰ طٛعٛ، مِ يَحَ طَاعٜ مِ وَطَ دٛعَارٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","اٛ حٛشِّ بِيتُرُسْ اٜ ٻِٻّٜ جَبَدِ طِطٛ؞ ٻٜرْندٜ مَاکٛ بٛو تٜدِّ، اٛ فُطِّ وَنُّکِ نَاع سٜطَّ؞ ");
INSERT INTO fuv_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","سٜيْ اٛ وِعِٻٜ، ‏«‏ٻٜرْندٜ اَمْ وَنِّي نَاع سٜطَّ حَا بٛ مِ مَايَيْ؞ نجٛوطٛدٜىٰ اٜ اَمْ طٛعٛ اٛنْ ندٜىٰنَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","ندٜ اٛ يَحِ يٜىٰسٛ سٜطَّ، سٜيْ اٛ يَنِ اٜ لٜيْدِ اٜ مٛ حِڤِّي، اٛ وَطِ دٛعَارٜ، اٛ وِعِ، ‏«‏ݧَاکٛ اَمْ مٛ دٛوْ، تٛ طُمْ وَطٛتٛ، اِتَّنَمْ جَرْدُغٜلْ تٛرَّ کَعَ؞ فُو اٜ نٛنْ نَاع کٛ نغِطُمِ وَطٜتٜىٰ، اَمَّا کٛ نغِطَّا وَطٜىٰ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","غَطَ طٛنْ اٛ سٛعِّي تٛ ٻٜنْ طٛنْ تٛکُّٻٜمٛ تَتٛ، اٛ تَوِ اٜ ٻٜ طَانِي، سٜيْ اٛ وِعِ بِيتُرُسْ، ‏«‏تٛو، اٛنْ مبَاوَتَا جٛوطٛدَاکِ اٜ اَمْ اٛنْ طَانَاکِ کٛو شَرٜلْ سٜطَّ؟ ");
INSERT INTO fuv_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","نجٛوطٜىٰ، تٛع اٛنْ طَانٛ، نغَطٜىٰ دٛعَارٜ تٛ طُمْ فٛوندِيعٛنْ تٛع نغَطٛنْ حَکّٜ؞ ٻٜرْندٜ اٜ يِطِ وَطُکِ کٛ حَانِ، اَمَّا ٻَنْدُ تَمْڤِي؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","اٛ فُطِّتِ اٛ دِلِّ طِطَٻُمْ، اٛ وَطِ دٛعَارٜ، اٛ وِعِ، ‏«‏ݧَاکٛ اَمْ مٛ دٛوْ، تٛ طُمْ وَطَتَاکٛ طُمْ اِتَّنَيَمْ تٛرَّ کَعَ، سٜيْ تٛ مِ يَرِيکَ، اَلْ کٛ نغِطَّا وَطٜىٰ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","سٜيْ اٛ فُطِّتِ اٛ سٛعّٛيِي تٛ مَٻّٜ، اٛ تَوِ اٜ ٻٜ طَانِي، نغَمْ اٜ ٻٜ نَنَ طٜيْنغٛلْ تٜدُّنغٛلْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","سٜيْ اٛ فُطِّتِ اٛ دِلِّ تَتَٻُمْ اٛ وَطِ دٛعَارٜ، اٛ وِعِ نٛنْ نٛ اٛ وِعُنٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","اٛ فُطِّتِ اٛ سٛعِّي تٛ مَٻّٜ تَتَٻُمْ، اٛ وِعِٻٜ، ‏«‏حَا جٛونِ اٛنْ طَانِي، اٛنْ شِوْتٛو؟ شَرٜلْ وَرِي؞ طُمْ حٛکِّتِرِي ٻِي نٜطّٛ ندٜرْ جُوطٜ غَطٛوٻٜ حَکّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","اُمّٜىٰ ندِلّٜنْ!‏ رَا اٛنْ طٛنْ کٛکِّتِرَيْطٛيَمْ اٜ وَرَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","يٜىٰسُ اٜ مٜتَ، سٜيْ يَحُودَ، غٛعٛتٛ ندٜرْ تٛکُّٻٜمٛ سَڤّٛ اٜ طِطٛ وَرِ؞ اٛ وَرْدٛيِ اٜ يِمْٻٜ طُطْٻٜ اٜ ٻٜ نجٛغِي کَافَاجٜ اٜ شَبِّ؞ مَوْٻٜ اَرْدِيٻٜ دِينَ، اٜ مَوْٻٜ يِمْٻٜ لِلٛيِٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","تٛو، ندٜنْ مَا کٛکِّتِرَيْطٛ يٜىٰسُ اٛنْ اٛ يَادَکٜ اٛ وِعِيٻٜ نٛ اٛ حٛلِّرْتَٻٜ يٜىٰسُ، اٛ وِعِ، ‏«‏نٜطّٛ مٛ کٛوْنَيْمِ حٛوْنُکِ حِغَاکُ طُمْ کَنْکٛ؞ نَنْغٜىٰمٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","طٛنْ اٜ طٛنْ يَحُودَ اٛنْ ٻَدِّي يٜىٰسُ، وِعِ، ‏«‏مٛودِبّٛ، اَللَّه سَبِّنَنٜىٰ!‏»‏ ندٜنْ اٛ حٛوْنِمٛ حٛوْنُکِ حِغَاکُ؞ ");
INSERT INTO fuv_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","يٜىٰسُ نٛوتِي، وِعِمٛ، ‏«‏حِغٛ اَمْ، وَطُ کٛ وَدُّمَا؞»‏ سٜيْ يِمْٻٜ ٻٜنْ ٻَدِّي نَنْغِ يٜىٰسُ ٻٜ نجٛغِيمٛ بٛطُّمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","اٜ يِيکِ نٛنْ، غٛعٛتٛ ندٜرْ غٛنْدُٻٜ اٜ يٜىٰسُ نَنْغِ کَافَحِ مُوطُمْ سٛلْتِکِ، فٜعِّ مَشُّطٛ مَوْطٛ مَوْٻٜ اَرْدِيٻٜ دِينَ اٛ اِتَّنِمٛ نٛوْرُ؞ ");
INSERT INTO fuv_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","اَمَّا يٜىٰسُ وِعِمٛ، ‏«‏وَتُّ کَافَحِ مَاطَ ندٜرْ حٛلْغٛ مَاکِ؞ نغَمْ فُو کٛشُّطٛ کَافَحِ، کَافَحِ وَرَتَمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","اٛنْ کَمِّي مِ وَاوَتَا تٛرَاکِ ݧَاکٛ اَمْ مٛ دٛوْ، طٛنْ اٜ طٛنْ اٛ لِلٛيَ مٛٻْطٜ مَلَاعِکَعٜنْ ٻُرْطٜ مٛٻْطٜ سَڤّٛ اٜ طِطِ؟ ");
INSERT INTO fuv_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","اَمَّا نٛ وَطَتَ اَايَاجٜ کٜىٰوَ بِيطٜ دٛولٜ طُعُمْ وَطَ نِحِ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","اٜ نغٜلْ طٛنْ شَرٜلْ يٜىٰسُ وِعِ غَرٛيْٻٜ ٻٜنْ، ‏«‏اٛنْ نغَرْدٛيِ اٜ کَافَاجٜ اٜ شَبِّ نغَمْ نَنْغٛيْيَمْ بٛ مِ غُجّٛ شَلٛرْطٛ؟ کٛو ندٜيٜ اٜ مِ جٛوطٛو ندٜرْ وُرٛ شٜنِينغٛ اٜ مِ اٜکِّتِنَ، اٛنْ نَنْغَايِيَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","اَمَّا طُعُمْ وَطِي نغَمْ کٛ اَنَّبٛعٜنْ مبِنْدِ حٜىٰوَ؞»‏ سٜيْ فُو تٛکُّٻٜمٛ اَلِمٛ، ندٛغِّ؞ ");
INSERT INTO fuv_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","سٜيْ نَنْغُٻٜ يٜىٰسُ ٻٜنْ نجَارِمٛ تٛ وُرٛ کَيَافَ مَوْطٛ مَوْٻٜ اَرْدِيٻٜ دِينَ، تٛ مٛودِٻّٜ اَتَّوْرَ اٜ مَوْٻٜ يِمْٻٜ کَوْرِتِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","اَمَّا بِيتُرُسْ تٛکِّرِمٛ غَطَ دَغَ تٛ وٛطِّ حَا يَاکِ شَکَ وُرٛ مَوْطٛ مَوْٻٜ اَرْدِيٻٜ دِينَ اٛنْ؞ اٛ نَتِّ اٛ جٛوطٛدِي اٜ تَادِيٻٜ وُرٛ شٜنِينغٛ، نغَمْ اٛ يِعَ نٛ طُمْ وَطَنْتَ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","مَوْٻٜ اَرْدِيٻٜ دِينَ اٜ فُو کَوْتَلْ مَوْٻٜ اٜ ٻٜ طَٻِّتَ شٜيْدَ فٜوْرٜ طُمْ ٻٜ نَنْغِرْتَ يٜىٰسُ، نغَمْ ٻٜ کٜٻَ ٻٜ مبَرَمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","اَمَّا ٻٜ کٜٻَايِ غٛطُّمْ، کٛو ندٜ يِمْٻٜ طُطْٻٜ ندَرَکٜ يٜىٰسٛ مَٻّٜ کٛکِّ شٜيْدَ فٜوْرٜ؞ اٜ رٜعِرْدٜ، يِمْٻٜ طِطٛ ندَرِي يٜىٰسٛ يِمْٻٜ، ٻٜ مبِعِ، ");
INSERT INTO fuv_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","‏«‏اٛعٛ نٜطّٛ وِعِي، ‏‹‏مِ وَاوَيْ سَنْکُتُکِ وُرٛ شٜنِينغٛ نغٛ اَللَّه، مِ مَحِتٛونغٛ ندٜرْ بَلْطٜ تَتِ؞›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","سٜيْ مَوْطٛ مَوْٻٜ اَرْدِيٻٜ دِينَ اُمِّي دَرِي وِعِ يٜىٰسُ، ‏«‏اَ وَلَا کٛ مبِعَتَا؟ کٛ ٻٜ مبِعِ دٛوْ مَاطَ طُمْ غٛونغَ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","اَمَّا يٜىٰسُ دٜعِّتِ؞ سٜيْ مَوْطٛ مَوْٻٜ اَرْدِيٻٜ دِينَ اٛنْ وِعِمٛ، ‏«‏مِ حَوْتِيمَ اٜ اَللَّه مٛ يٛنْکِ، وِعُمِنْ تٛ اَنْ وٛنِ اَلْمَسِيحُ، ٻِطّٛ اَللَّه؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","يٜىٰسُ نٛوتِي، وِعِ، ‏«‏اٜىٰ، طُمْ نٛنْ نٛ مبِيطَا؞ اَمَّا اٜ مِ وِعَعٛنْ، يٜىٰسٛ طٛعٛ اٛنْ نغِعَيْ ٻِي نٜطّٛ اٜ جٛوطِي تٛ جُنْغٛ ݧَامٛ نغٛ جٛومُ بَوْطٜ اٜ مٛ وَرٛيَ ندٜرْ دُولٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","سٜيْ مَوْطٛ مَوْٻٜ اَرْدِيٻٜ دِينَ اٛنْ سٜىٰکِ کٛلْتٜ مُوطُمْ وِعِ، ‏«‏اٛ حُطِي اَللَّه؞ طُمٜ شٜيْدَ طَٻِّتٜتٜنْ کَدِنْ؟ جٛونِ اٛنْ نَنِي نِ حَالَ کَلُّکَ کَ اٛ مٜتِ دٛوْ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","کٛ وٛنِ شُٻٛلْ مٛوطٛنْ؟»‏ سٜيْ ٻٜ مبِعِ، ‏«‏حٜوْتِي اٛ وَرٜىٰ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","سٜيْ ٻٜ تُتَّنِمٛ جٛودٜ تٛ يٜىٰسٛ، ٻٜ ڤِيِمٛ، وٛٻّٜ کٜلِّمٛ تٛ وٛلٛ، ");
INSERT INTO fuv_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","اٜ ٻٜ مبِعَمٛ، ‏«‏اَلْمَسِيحُ، وَطَنْمِنْ اَنَّبَاکُ!‏ مٛيٜ فِيُمَا؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","بِيتُرُسْ اٜ جٛوطِي شَکَ وُرٛ نغٛنْ، سٜيْ غٛطّٛ کٛرْطٛ وَرِ تٛ مَاکٛ وِعِ، ‏«‏اَنْ مَا، اَ وٛنْدِ اٜ يٜىٰسُ غَلِلَنْکٜىٰجٛ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","اَمَّا بِيتُرُسْ يٜدِّ يٜىٰسٛ مَٻّٜ ٻٜ فُو وِعِ، ‏«‏مِ اَنْدَا کٛ مبِعَتَا!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","سٜيْ اٛ يَحِ حَادٜ دَمُّغَلْ وُرٛ نغٛنْ؞ طٛنْمَا سٜيْ غٛطّٛ کٛرْطٛ يِعِمٛ، وِعِ يِمْٻٜ دَرِيٻٜ طٛنْ، ‏«‏اٛعٛ نٜطّٛ اٜ مٛ وٛنْدِ اٜ يٜىٰسُ نَجَرَنْکٜىٰجٛ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","سٜيْ بِيتُرُسْ فُطِّتِ يٜدِّ حَا اٜ حُنَاکِ، وِعِ، ‏«‏مِ اَنْدَا نٜطّٛ اٛنْ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","غَطَ طٛنْ سٜطَّ، سٜيْ دَرِيٻٜ طٛنْ ٻَدِّي بِيتُرُسْ، مبِعِ، ‏«‏سٜکٛ وَلَا اَنْ مَا اَ غٛعٛتٛ ندٜرْ تٛکُّٻٜمٛ، نغَمْ اِرِ نٛ مٜتِرْتَا نَنْغِيمَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","سٜيْ بِيتُرُسْ فُطِّ لَانُکِ حٛورٜ مُوطُمْ حُنِي وِعِ، ‏«‏مِ اَنْدَا نٜطّٛ اٛنْ!‏»‏ طٛنْ اٜ طٛنْ نجَکَرْدِ حَنِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","سٜيْ بِيتُرُسْ سِفْتٛرِ کٛ يٜىٰسُ وِعُنٛومٛ وِعُکِ، ‏«‏کٛ نجَکَرْدِ حَنَ اَ وِعَيْ ندٜ تَتِ اَ اَنْدَايَمْ؞»‏ سٜيْ اٛ وُرْتِي يَاسِ اٛ وٛيِ بٛجِّ نَوْطِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","ندٜ وٜىٰتِ، سٜيْ فُو مَوْٻٜ اَرْدِيٻٜ دِينَ اٜ مَوْٻٜ يِمْٻٜ مٜدِّ دٛوْ نٛ ٻٜ مبَرْدَتَ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","ٻٜ کَٻِّمٛ، ٻٜ ندِلِّدِ اٜ مَاکٛ ٻٜ نجَارِمٛ تٛ بِلَاتُسْ غٛمْنَاجٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","ندٜ يَحُودَ کٛکِّتِرْطٛ يٜىٰسُ يِعِ طُمْ تَپَنِي يٜىٰسُ کِيتَ مَيْدٜ، سٜيْ اٛ وَنِّ، اٛ سٛعِّتَنِ مَوْٻٜ اَرْدِيٻٜ دِينَ اٜ مَوْٻٜ يِمْٻٜ شٜىٰدٜ اَجُرْفَارِ 30 طٜنْ طٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","اٛ وِعِ، ‏«‏مِ وَطِي حَکّٜ نغَمْ مِ حٛکِّتِرِي نٜطّٛ مٛ وَطَايِ کٛ وٛوطَا؞»‏ اَمَّا ٻٜ مبِعِمٛ، ‏«‏کٛ وَنِّمِنْ؟ اَنْ اَنْدِ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","سٜيْ اٛ حُبِنِ شٜىٰدٜ طٜنْ ندٜرْ وُرٛ شٜنِينغٛ، اٛ دِلِّ اٛ سَغِ حٛورٜ مَاکٛ اٜ ٻٛغّٛلْ دٛوْ لٜکِّ اٛ وَرِ حٛورٜ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","اَمَّا مَوْٻٜ اَرْدِيٻٜ دِينَ ٻٛڤْتِ شٜىٰدٜ طٜنْ، مبِعِ، ‏«‏اَتَّوْرَ حَطِي طُمْ وَطَ طٜعٜ شٜىٰدٜ ندٜرْ تٛ طُمْ رٜسَتَ دٛکَّلْ نغَمْ اَللَّه ندٜرْ وُرٛ شٜنِينغٛ، ندٜ شٜىٰدٜ طٜنْ طُمْ شٜىٰدٜ پِيپَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","نغَمْ نٛنْ ٻٜ شُٻِ ٻٜ کُوتِرَ شٜىٰدٜ طٜنْ ٻٜ شٛودَ نغٜسَ تٛ غٛطّٛ مَحٛووٛ غٛجِيجٜ، ٻٜ نغَرْتِرَکَ وِغٜىٰرٜ تٛ طُمْ اُوَتَ حٛٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","کَنْجُمْ وَطِ، حَا جٛونِ نغٜسَ کَنْ اٜ نٛدِّرٜىٰ ‏«‏نغٜسَ پِيپَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","نٛنْ حٜبِّنِ کٛ اَنَّبِ اِرْمِيَ وِعِ، وِيکِ، ‏«‏ٻٜ کٛشِّ شٜىٰدٜ اَجُرْفَارِ 30، شٜىٰدٜ طٜ اِسْرَاعِيلَنْکٛعٜنْ مبِعِ طُمْ يٛٻَ دٛوْ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ٻٜ کُوتِرِ شٜىٰدٜ طٜنْ ٻٜ شٛودِ نغٜسَ تٛ مَحٛووٛ غٛجِيجٜ، نٛنْ نٛ جٛومِرَاوٛ وِعِ مِ وَطَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","يٜىٰسُ اٜ دَرِي يٜىٰسٛ غٛمْنَاجٛ، سٜيْ غٛمْنَاجٛ اٛنْ پَمِمٛ، وِعِ، ‏«‏اَنْ وٛنِ لَامِيطٛ يَحُودَنْکٛعٜنْ؟»‏ يٜىٰسُ نٛوتِي وِعِ، ‏«‏اَ وِعِيکَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","اَمَّا ندٜ مَوْٻٜ اَرْدِيٻٜ دِينَ اٜ مَوْٻٜ يِمْٻٜ نغُلِّيمٛ، اٛ وِعَايِ غٛطُّمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","سٜيْ بِلَاتُسْ وِعِمٛ، ‏«‏اَ نَنَتَا ٻٜ نغُلّٛرَکٜمَ فِي طُطُّمْ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","اَمَّا يٜىٰسُ نٛوتَنَاکِمٛ کٛو ندٜ غٛعٛ، حَا غٛمْنَاجٛ اٛنْ حَيْطِنِ نَاع سٜطَّ؞ ");
INSERT INTO fuv_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","تٛو، اٜ شَرٜلْ حُمْتٛ سَکِّنْکِ، بِلَاتُسْ غٛمْنَاجٛ وٛووِي يٛوفَنْکِ حَوْرُتُٻٜ شُرَاطٛ غٛعٛتٛ مٛ ٻٜ نغِطِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","اٜ شَرٜلْ نغٜلْ بٛو اٜ وٛودِ شُرَاطٛ کَلُّطٛ اِنْدِنْطٛ بِعٜتٜىٰطٛ بَرَبَّسْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","ندٜ يِمْٻٜ کَوْرِتِ، سٜيْ بِلَاتُسْ پَمِٻٜ، وِعِ، ‏«‏مٛيٜ نغِطّٛنْ مِ يٛوفَنَعٛنْ؟ بَرَبَّسْ کٛو يٜىٰسُ بِعٜتٜىٰطٛ اَلْمَسِيحُ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","نغَمْ بِلَاتُسْ فَامِي لَوْلِيرُ وَطِ ٻٜ نغَطِ يٜىٰسُ ندٜرْ جُنْغٛ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","بِلَاتُسْ اٜ جٛوطِي دٛوْ جٛوطٛرْغَلْ کِيتَ، سٜيْ دٜبّٛ مَاکٛ لِلٛيِ طُمْ وِعَمٛ، ‏«‏تَاع مٜىٰمُ اٛنْ طٛنْ مٛ وَطَايِ کٛ وٛوطَا، نغَمْ حَنْکِ مِ حٛيْطِي دٛوْ مَاکٛ مِ وَنِّي نَاع سٜطَّ دٛوْ کٛيْطٛلْ نغٛلْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","مَوْٻٜ اَرْدِيٻٜ دِينَ اٜ مَوْٻٜ يِمْٻٜ نغَطِ يِمْٻٜ مبِعَ طُمْ يٛوفَ بَرَبَّسْ طُمْ وَرَ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","غٛمْنَاجٛ اٛنْ فُطِّتِ وِعِٻٜ، ‏«‏ندٜرْ يِمْٻٜ طِطٛ ٻٜنْ مٛيٜ نغِطّٛنْ مِ يٛوفَنَعٛنْ؟»‏ ٻٜ مبِعِ، ‏«‏بَرَبَّسْ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","سٜيْ بِلَاتُسْ پَمِٻٜ وِعِ، ‏«‏تٛو، کٛ نغِطّٛنْ مِ وَطَنَ يٜىٰسُ بِعٜتٜىٰطٛ اَلْمَسِيحُ؟»‏ ٻٜ فُو ٻٜ مبِعِ، ‏«‏وَرُمٛ دٛوْ غَافَانغَلْ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","بِلَاتُسْ وِعِ، ‏«‏نغَمْ طُمٜ؟ طُمٜ کٛ حَلِّ اٛ وَطِ؟»‏ اَمَّا ٻٜ ٻٜيْدِ وِعُکِ سٜمْبٜىٰ، ‏«‏وَرُمٛ دٛوْ غَافَانغَلْ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","ندٜ بِلَاتُسْ يِعِ وَلَا کٛ وَاوَتَ وَطُکِ، ندٜنْ حَوْرٜ فُطِّ اُمَّاکِ، سٜيْ اٛ ݧٜطٛيِ ندِيَمْ اٛ لٛوتِ جُوطٜ مَاکٛ يٜىٰسٛ مَٻّٜ؞ اٛ وِعِ، ‏«‏مِ وَلَا حَکّٜ پِيپَمْ نٜطّٛ اٛعٛ؞ طُمْ شَطُّمْ مٛوطٛنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","سٜيْ يِمْٻٜ ٻٜنْ فُو نٛوتِي، مبِعِ، ‏«‏اٜىٰ، حَکّٜ پِيپَمْ مَاکٛ اٜ دٛوْ اَمِنْ اٜ ٻِٻّٜ اَمِنْ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","سٜيْ اٛ يٛوفَنِٻٜ بَرَبَّسْ، اَمَّا اٛ وَطِ طُمْ فِيِ يٜىٰسُ لٛوشِ، ندٜنْ اٛ تَمْبِنِمٛ سٛوجِعٜنْ رٛومَ نغَمْ ٻٜ مبَرٛيَمٛ دٛوْ غَافَانغَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","دَغَ طٛنْ سٛوجِعٜنْ غٛمْنَاجٛ نجَارِ يٜىٰسُ ندٜرْ لَامٛرْدٜ غٛمْنَاجٛ، ٻٜ کَوْرِتِ فُو سٛوجِعٜنْ کٛرِيٻٜ يٜىٰسٛ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","ٻٜ ٻٛرْتِمٛ ٻٜ ٻٛرْنِمٛ اِرِ تٛغّٛورٜ لَامِيٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ٻٜ مبَالِ غِيفٛلْ غِعٜ، ٻٜ تَارَنِمٛنغٛلْ اٜ حٛورٜ، ٻٜ نغَطَنِمٛ سَوْرُ اٜ جُنْغٛ ݧَامٛ مَاکٛ، ٻٜ ندِشِّي يٜىٰسٛ مَاکٛ، اٜ ٻٜ نجُکِّتَمٛ، اٜ ٻٜ مبِعَ، ‏«‏اَللَّه رٜىٰنٜ، لَامِيطٛ يَحُودَنْکٛعٜنْ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","ٻٜ تُتَّنِمٛ جٛودٜ، ٻٜ نجَٻِ سَوْرُ ندُنْ ٻٜ نغَطِ کَ ڤِيرُکِمٛندُ تٛ حٛورٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","غَطَ ٻٜ نجُکِّتِيمٛ، ٻٜ ٻٛرْتِمٛ تٛغّٛورٜ لَامِيٻٜ ندٜ ٻٜ ٻٛرْنُنٛومٛ، ندٜنْ ٻٜ ٻٛرْنِمٛ کٛلْتٜ مَاکٛ؞ سٜيْ ٻٜ مبُرْتِنِمٛ ٻٜ اَرْدِنِمٛ نغَمْ ٻٜ مبَرٛيَمٛ دٛوْ غَافَانغَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","اٜ ٻٜ نجَحَ سٜيْ ٻٜ کَوْرِ اٜ غٛطّٛ نٜطّٛ سَايِرَنْکٜىٰجٛ بِعٜتٜىٰطٛ سِيمَنْ؞ ٻٜ نغَطِمٛ اٜ سٜمْبٜ اٛ حٛشَّ غَافَانغَلْ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","ندٜ ٻٜ نغَرِ تٛ وٛنْدٜ وِغٜىٰرٜ بِعٜتٜىٰندٜ غٛلْغٛوتَ، وَاتٛ ‏«‏پِپَلْ حٛورٜ،»‏ ");
INSERT INTO fuv_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ٻٜ کٛکِّ يٜىٰسُ ندِيَمْ اِنَبٛجَمْ جِلِّندِرَاطَمْ اٜ غٛطُّمْ کَطُّمْ؞ اَمَّا ندٜ اٛ تَحِطَمْ، اٛ سَلِي اٛ يَرَ؞ ");
INSERT INTO fuv_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","غَطَ ٻٜ ڤِيَنِيمٛ کُوسَاجٜ دٛوْ غَافَانغَلْ، ٻٜ نغَطِ شَاشَ نغَمْ ٻٜ شٜنْدَ کٛلْتٜ مَاکٛ حَکُّندٜ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","غَطَ نٛنْ ٻٜ نجٛوطِي اٜ ٻٜ ندٜىٰنَمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","دٛوْ حٛورٜ غَافَانغَلْ نغَلْ طُمْ تَکِّ اَلّٛوَلْ؞ طُمْ وِنْدِ دٛوْ مَاغَلْ کٛ طُمْ وُلّٛرِيمٛ وِعُکِ، ‏«‏اٛعٛ وٛنِ يٜىٰسُ لَامِيطٛ يَحُودَنْکٛعٜنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","ٻٜ ڤِيَنِ وُيْٻٜ طِطٛ کُوسَاجٜ دٛوْ غَافَالٜ حَادٜ يٜىٰسُ، غٛعٛتٛ اٜ جُنْغٛ مَاکٛ ݧَامٛ، غٛعٛتٛ اٜ جُنْغٛ مَاکٛ نَنٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","يِمْٻٜ پَٻّٛتٛوٻٜ اٜ کُطَ يٜىٰسُ اٜ نغِيلَ کٛعٜ، ");
INSERT INTO fuv_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","اٜ ٻٜ مبِعَ، ‏«‏اَنْ غِطّٛ ڤُسُکِ وُرٛ شٜنِينغٛ مَحِتٛونغٛ ندٜرْ بَلْطٜ تَتِ، حِسْنُ حٛورٜ مَاطَ!‏ تَا ٻِطّٛ اَللَّه، جِڤّٛيَ دَغَ دٛوْ غَافَانغَلْ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","نٛنْ مَا مَوْٻٜ اَرْدِيٻٜ دِينَ، اٜ مٛودِٻّٜ اَتَّوْرَ، اٜ مَوْٻٜ يِمْٻٜ نجُکِّتِمٛ، اٜ مبِعَ، ");
INSERT INTO fuv_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","‏«‏اٛ حِسْنِي وٛٻّٜ، اَمَّا اٛ وَاوَايِ حِسْنُکِ حٛورٜ مَاکٛ؞ تٛ کَنْکٛ وٛنِ لَامِيطٛ اِسْرَاعِيلَ، اَلْ اٛ جِڤّٛيٛو دَغَ دٛوْ غَافَانغَلْ جٛونِ، اٜنٜنْ بٛو کٛولٛوطٜنْمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","اٛ حٛولَکٜ اَللَّه؞ اَلْ اَللَّه اٛنْ حِسْنَمٛ جٛونِ تٛ اٜ مٛ يِطِمٛ، نغَمْ اٛ وِعِي، ‏‹‏مِنْ مِ ٻِطّٛ اَللَّه؞›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","نٛنْ مَا ٻٜنْ طٛنْ وُيْٻٜ ٻٜ طُمْ ڤِيَنِ کُوسَاجٜ دٛوْ غَافَالٜ کُطِمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","دَغَ شَکَ ݧَلَوْمَ ݧِوْرٜ مَٻِّ لٜيْدِ فُو، حَا يَاکِ نجَمْندِ تَتِ ندِ اَلَاسَرَ؞ ");
INSERT INTO fuv_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","اٜ نجَمْندِ تَتِ ندِنْ، سٜيْ يٜىٰسُ وِعِ اٜ سٜمْبٜ، ‏«‏اٜلٛيْ، اٜلٛيْ، لَمَ سَبَتَّنِ؟»‏ وَاتٛ، ‏«‏يَا اَللَّه اَمْ، يَا اَللَّه اَمْ، نغَمْ طُمٜ شٜنْدِرْطَا اٜ اَمْ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","ندٜ وٛٻّٜ دَرِيٻٜ تٛ وِغٜىٰرٜ ندٜنْ نَنِ نٛنْ، ٻٜ مبِعِ، ‏«‏اٜ مٛ نٛدَّ اَنَّبِ اِلِيَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","سٜيْ طٛنْ اٜ طٛنْ غٛعٛتٛ مَٻّٜ دٛغِّ حٛشِّ سٛوسٛوَ، سُووِنغَ ندٜرْ ندِيَمْ اِنَبٛجَمْ لَمُّطَمْ، اٛ طِيسِنغَ تٛ سَوْرُ، اٛ لِوَنِي يٜىٰسُ يَرَ؞ ");
INSERT INTO fuv_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","اَمَّا وٛٻّٜ مبِعِ، ‏«‏اَلٜىٰ نغِعٜنْ کٛو اِلِيَ وَرَيْ حِسْنَمٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","سٜيْ يٜىٰسُ فُطِّتِ وُلِّ سٜمْبٜىٰ ندٜنْ يٛوفِ يٛنْکِ مُوطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","سٜيْ وُدٜرٜ شٜنْدُندٜ سُودُ جٛومِرَاوٛ سٜىٰکِ طِطِ دَغَ دٛوْ يَاکِ لٜيْ؞ لٜيْدِ بٛو دِمْبِ، کَاپٜ ڤٜشَّا؞ ");
INSERT INTO fuv_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","طُمْ اٛمْتِ غٜنَالٜ، يِمْٻٜ اَللَّه مَيْٻٜ طُطْٻٜ اُمِّي اٜ يٛنْکِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ٻٜ مبُرْتٛيِي ندٜرْ غٜنَالٜ طٜنْ؞ غَطَ يٜىٰسُ اُمَّکٜ دَغَ مَيْدٜ، ٻٜ نَتّٛيِ غَرِيرِ شٜنِيندِ، يِمْٻٜ طُطْٻٜ نغِعِٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","ندٜ مَوْطٛ سٛوجِعٜنْ اٛنْ اٜ حٛرِيٻٜ سٛوجِعٜنْ رٜىٰنٛوٻٜ يٜىٰسُ نغِعِ دِمْبٛلْ لٜيْدِ نغٛلْ اٜ فُو کٛ وَطِ، سٜيْ ٻٜ کُلْتٛرِ نَاع سٜطَّ، ٻٜ مبِعِ، ‏«‏غٛونغَ نٜطّٛ اٛعٛ اٛ ٻِطّٛ اَللَّه!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","اٜ وٛودِ رٜوْٻٜ طُطْٻٜ تٛکّٛيْٻٜ يٜىٰسُ دَغَ لٜيْدِ غَلِيلِ وَلّٛوٻٜمٛ اٜ ٻٜ ندَارَ دَغَ تٛ وٛطِّ؞ ");
INSERT INTO fuv_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","ندٜرْ مَٻّٜ اٜ وٛودِ مَرْيَامَ پِوٛيْطٛ مَغَدَلَ، اٜ مَرْيَامَ مَدُوجٛ يَاکُبُ اٜ يُسُفُ، اٜ مَدُوجٛ ٻِٻّٜ جَبَدِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","ندٜ اَلَاسَرَ وَطِ، سٜيْ غٛطّٛ دِسْکُطٛ پِوٛيْطٛ غَرِيرِ اَرْمَاتِيَ وَرِ؞ اِنْدٜ مَاکٛ يُسُفُ؞ کَنْکٛ مَا اٛ تٛکُّطٛ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","اٛ يَحِ تٛ بِلَاتُسْ، اٛ تٛرِيمٛ اٛ حٛکَّمٛ ٻَنْدُ يٜىٰسُ؞ سٜيْ بِلَاتُسْ وَطِ طُمْ حٛکَّمٛندُ؞ ");
INSERT INTO fuv_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","سٜيْ يُسُفُ حٛشِّ ندُ تَارِندُ اٜ وُدٜرٜ لَمْندٜ ندٜ شٜىٰدٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","اٛ فُکِّنٛيْندُ ندٜرْ يٜنَاندٜ مَاکٛ حٜيْرٜ ندٜ اٛ وَطِ طُمْ وَسَنِمٛ ندٜرْ حَيْرٜ؞ اٛ تَلِّتِ کَاپَ مَنْغَ اٛ مَٻِّ دَمُّغَلْ يٜنَاندٜ ندٜنْ، اٛ دِلِّ؞ ");
INSERT INTO fuv_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","مَرْيَامَ پِوٛيْطٛ مَغَدَلَ اٜ غٛعٛتٛ مَرْيَامَ اٛنْ اٜ ٻٜ طٛنْ نجٛوطِي يٜىٰسٛ يٜنَاندٜ ندٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","ندٜ فِنِ، وَاتٛ غَطَ ݧَلْندٜ سِرْيَاکِ، سٜيْ مَوْٻٜ اَرْدِيٻٜ دِينَ اٜ فَارِسَنْکٛعٜنْ کَوْرِتِ يٜىٰسٛ بِلَاتُسْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ٻٜ مبِعِ، ‏«‏اَللَّه رٜىٰنٜ!‏ مِنْ شِڤْتٛرِي کٛ اٛنْ طٛنْ مَجِّنٛووٛ يِمْٻٜ وِعِ کٛ اٛ مَايَ، اٛ وِعِ، ‏‹‏مِ اُمّٛتٛ دَغَ مَيْدٜ غَطَ بَلْطٜ تَتِ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","نغَمْ نٛنْ، سٜيْ نغَطَا طُمْ يَحَ طُمْ رٜىٰنَ يٜنَاندٜ ندٜنْ بٛطُّمْ حَا بَلْطٜ تَتِ، نغَمْ تٛع تٛکُّٻٜمٛ نجَحَ نغُجَّ ٻَنْدُ مَاکٛ مبِعَ يِمْٻٜ اٛ اُمَّکٜ دَغَ مَيْدٜ؞ مَجِّنْکِ يِمْٻٜ شَکِتِيکِ کِنْ ٻُرَيْ اَرَنْدٜحِ حَلُّکِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","سٜيْ بِلَاتُسْ وِعِٻٜ، ‏«‏تٛو، نجَحٜىٰ، کٛشّٛنْ سٛوجِعٜنْ، نغَطٛنْ کٛ مبَاوٛتٛنْ وَطُکِ ندٜىٰنٛنْ يٜنَاندٜ ندٜنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","سٜيْ ٻٜ نجَحِ يٜنَاندٜ ندٜنْ ٻٜ ڤِيِ حَاتِمِيرٜ لَامِيطٛ دٛوْ حَيْرٜ تٛ دَمُّغَلْ يٜنَاندٜ ندٜنْ، ٻٜ نغَطِ سٛوجِعٜنْ ندٜىٰنَنْدٜ بٛطُّمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","تٛو، غَطَ ݧَلْندٜ سِوْتَارٜ، ݧَلْندٜ اَلَلْ سُبَکَ، سٜيْ مَرْيَامَ پِوٛيْطٛ مَغَدَلَ اٜ مَرْيَامَ غٛعٛتٛ اٛنْ ٻٜ نجَحِ نغَمْ ٻٜ نغِعَ يٜنَاندٜ ندٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","طٛنْ اٜ طٛنْ طُمْ وَطِ وٛنْغٛلْ دِمْبٛلْ لٜيْدِ مَنْغٛلْ، نغَمْ غٛطّٛ مَلَاعِکَاجٛ جٛومِرَاوٛ وَرِ دَغَ دٛوْ، اٛ تَلِّتِ کَاپَ نغَنْ دَغَ دَمُّغَلْ يٜنَاندٜ ندٜنْ، اٛ جٛوطِي دٛوْ مَاغَ؞ ");
INSERT INTO fuv_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","اٜ مٛ طٜلْکِتٛو بٛ مَپّٜرٜ، کٛلْتٜ مَاکٛ بٛو اٜ رَنِّ تَرْ بٛ حٛتّٛلّٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","ندٜ سٛوجِعٜنْ رٜىٰنٛوٻٜ يٜنَاندٜ ندٜنْ نغِعِمٛ، کُلٛلْ مَنْغٛلْ نَنْغِٻٜ حَا ٻٜ ندِوْنِ، ٻٜ نجَنِ، ٻٜ نغَرْتِ بٛ مَيْٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","اَمَّا مَلَاعِکَاجٛ اٛنْ وِعِ رٜوْٻٜ ٻٜنْ، ‏«‏تٛع اٛنْ کُلُ؞ اٜ مِ اَنْدِ يٜىٰسُ طَٻِّتٛتٛنْ، بَرَاطٛ دٛوْ غَافَانغَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","اٛ وَلَا طٛعٛ؞ طُمْ اُمِّنِيمٛ دَغَ مَيْدٜ؞ نغَرٜىٰ نغِعٛنْ تٛ طُمْ فُکِّنّٛومٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","نجَحٜىٰ ندٜرْ يَوْطَارٜ مبِعٛنْ تٛکُّٻٜمٛ، ‏‹‏اٛ اُمَّکٜ دَغَ مَيْدٜ؞ رَطُّمْ، اٛ اَرْتَيْعٛنْ يَاکِ لٜيْدِ غَلِيلِ؞ تٛنْ نغِعٛتٛنْمٛ؞›‏ کَنْجُمْ وٛنِ حَبَرُ طُمْ نغَدَّنْمِعٛنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","سٜيْ رٜوْٻٜ ٻٜنْ اَلِ يٜنَاندٜ ندٜنْ جَوْطُمْ ندٜرْ کُلٛلْ، اَمَّا اٜ وٜلْوٜلٛ مَنْغٛ؞ ٻٜ ندٛغِّ ٻٜ نجَحِ نغَمْ ٻٜ مبِعَکَ تٛکُّٻٜ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","سٜيْ يٜىٰسُ حَوْرِ اٜ مَٻّٜ، وِعِ، ‏«‏اَکُ مٛوطٛنْ!‏»‏ ٻٜ ٻَتِّيمٛ، ٻٜ ندِشِّي، ٻٜ نجٛغِي کٛيْطٜ مَاکٛ، ٻٜ مَوْنِنِمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","سٜيْ يٜىٰسُ وِعِٻٜ، ‏«‏تٛع اٛنْ کُلُ؞ نجَحٜىٰ مبِعٛنْ بَنْدِرَاٻٜ اَمْ نجَحَ لٜيْدِ غَلِيلِ؞ تٛنْ ٻٜ نغِعَتَيَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","رٜوْٻٜ ٻٜنْ اٜ دٛوْ لَاوٛلْ، سٜيْ وٛٻّٜ ندٜرْ سٛوجِعٜنْ رٜىٰنٛوٻٜ يٜنَاندٜ ندٜنْ نجَحِ غَرِيرِ طِيوِتِ مَوْٻٜ اَرْدِيٻٜ دِينَ فُو کٛ وَطِ؞ ");
INSERT INTO fuv_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","ندٜ مَوْٻٜ اَرْدِيٻٜ دِينَ اٜ مَوْٻٜ يِمْٻٜ کَوْرِتِ، ٻٜ ندَرْوِ دَبَرٜ؞ ٻٜ کٛکِّ سٛوجِعٜنْ ٻٜنْ شٜىٰدٜ طُطّٜ، ");
INSERT INTO fuv_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ٻٜ مبِعِٻٜ، ‏«‏مبِعٜىٰ يِمْٻٜ، ‏‹‏تٛکُّٻٜمٛ نغَرِ جٜمَّ اٜ مِنْ طَانِي ٻٜ نغُجِّمٛ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","تٛ غٛمْنَاجٛ نَنِي طُعُمْ حَبَرُ، مِنْ اٜسْتَيْمٛ مِنْ شُرَنَعٛنْ نَتُّکِ تٛرَّ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","سٜيْ سٛوجِعٜنْ ٻٜنْ نجَٻِ شٜىٰدٜ طٜنْ، ٻٜ نغَطِ نٛنْ نٛ طُمْ وِعِٻٜ ٻٜ نغَطَ؞ حَبَرُ طُمْ سَنْکِتَامَ ندٜرْ يَحُودَنْکٛعٜنْ، اٜ ٻٜ کٛکَّ حَبَرُ طُعُمْ حَا حَنْدٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","سٜيْ تٛکُّٻٜمٛ سَڤّٛ اٜ غٛعٛ ٻٜنْ ندِلِّ لٜيْدِ غَلِيلِ تٛ حٛشّٜىٰرٜ ندٜ يٜىٰسُ وِعِٻٜ ٻٜ نجَحَ؞ ");
INSERT INTO fuv_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","ندٜ ٻٜ نغِعِمٛ، سٜيْ ٻٜ مَوْنِنِمٛ، اَمَّا وٛٻّٜ نغَطِ سٜکٛ ندٜرْ ٻٜرْطٜ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","سٜيْ يٜىٰسُ ٻَدِّي حَادٜ مَٻّٜ، وِعِٻٜ، ‏«‏طُمْ حٛکِّييَمْ فُو لَامُ دٛوْ اٜ لٜيْ؞ ");
INSERT INTO fuv_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","نغَمْ نٛنْ، نجَحٜىٰ نغَرْتِرٛنْ فُو لٜݧِ دُونِيَارُ تٛکُّٻٜيَمْ، نغَطَنٛنْٻٜ بَڤْتِسْمَ ندٜرْ اِنْدٜ اَللَّه ݧَاکٛ مٛ دٛوْ، اٜ ٻِطّٛ، اٜ رُوحُ اَللَّه، ");
INSERT INTO fuv_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","اٛنْ اٜکِّتِنَٻٜ ٻٜ تٛکَّ کٛو طُمٜ کٛ مبِيمِعٛنْ نغَطٛنْ؞ رَطُّمْ، اٜ مِ وٛنْدِ اٜ مٛوطٛنْ کٛو ندٜيٜ حَا رٜعُکِ دُونِيَارُ؞»‏");
INSERT INTO fuv_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","طُعُمْ وٛنِ حَبَرُ بٜلْطُمْ دٛوْ يٜىٰسُ اَلْمَسِيحُ، ٻِطّٛ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","طُمْ وِنْدَامَ ندٜرْ دٜفْتٜرٜ اَنَّبِ اِشَايَ وِيکِ، ‏«‏اَللَّه وِعِ، ‏‹‏رَطُّمْ، مِ لِلٛيَيْ لِلَاطٛ اَمْ اٛ اَرْدٛو يٜىٰسٛ مَاطَ اٛ مٛعِّنَنْمَا لَاوٛلْ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","غٛطّٛ اٜ نٛدَّ ندٜرْ لَدّٜ، اٜ وِعَ، ‏‹‏مٛعِّنٜىٰ طَتَلْ جٛومِرَاوٛ، ڤٛرْتٜىٰ لَاوٛلْ نغَمْ غَرٛلْ مَاکٛ؞›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","نٛنْ بٛو يَحَيَ غَطٛووٛ بَڤْتِسْمَ جٛوطِي ندٜرْ لَدّٜ، اٜ وَعَجِنَ، اٜ مٛ وِعَ، ‏«‏تُوبٜىٰ، طُمْ وَطَنَعٛنْ بَڤْتِسْمَ، ندٜنْ اَللَّه يَافَنْتٛعٛنْ حَکّٜىٰجِ مٛوطٛنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","يِمْٻٜ طُطْٻٜ دَغَ لٜيْدِ يَحُودِيَ فُو اٜ غَرِيرِ اُرُشَلِيمَ نغَطِ کَ يَاکِ تٛ مَاکٛ؞ اٜ ٻٜ مبِعَ فُو کٛ وٛوطَا طُمْ ٻٜ نغَطِ، اٜ مٛ وَطَنَٻٜ بَڤْتِسْمَ ندٜرْ شَانغٛلْ اُرْدُنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","يَحَيَ اٜ ٻٛرْنِي کٛلْتٜ طٜ طُمْ وَطِرِ لٜىٰٻٜ نغٜىٰلٛوبَ، اٜ مٛ تَادِي تَادٛرْدٜ لَرَلْ؞ ݧَمْندُ مَاکٛ وٛنِ بَابٜىٰجِ اٜ نجُمْرِ؞ ");
INSERT INTO fuv_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","اٜ مٛ وَعَجِنَ، اٜ مٛ وِعَ، ‏«‏غٛطّٛ اٜ وَرَ غَطَ اَمْ اٛ ٻُرِييَمْ مَنْغُ، کٛو لٛکُّلِّ ڤَطٜ مَاکٛ مِ فٛتَايِ تُرَاکِ مِ فِتَّطِ؞ ");
INSERT INTO fuv_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","اٜ مِ وَطِرَنَعٛنْ بَڤْتِسْمَ اٜ ندِيَمْ، اَمَّا کَنْکٛ اٛ وَطِرَنَيْعٛنْ بَڤْتِسْمَ اٜ رُوحُ اَللَّه؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","ندٜرْ بَلْطٜ طٜنْ يٜىٰسُ وَرٛيِ دَغَ غَرِيرِ نَجَرَتْ ندٜرْ لٜيْدِ غَلِيلِ، سٜيْ يَحَيَ وَطَنِمٛ بَڤْتِسْمَ ندٜرْ شَانغٛلْ اُرْدُنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","اٜ وُرْتَاکِ يٜىٰسُ دَغَ ندٜرْ ندِيَمْ طَمْ، اٛ يِعِ دٛوْ اٜ مَٻِّتٛو، رُوحُ اَللَّه اٜ جِڤّٛيٛو دٛوْ مَاکٛ بٛ فٛوندُ؞ ");
INSERT INTO fuv_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","حٛنٛنْدٜ پِوٛيِ دَغَ دٛوْ وِعِ، ‏«‏اَنْ وٛنِ ٻِطّٛ اَمْ، مٛ نغِطُمِ؞ اٜ مِ نَنَ بٜلْطُمْ مَاطَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","طٛنْ اٜ طٛنْ رُوحُ اَللَّه يَارِمٛ ندٜرْ لَدّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","تٛنْ اٛ وَطِ بَلْطٜ 40 شٜيْطَنْ اٜ فٛوندَمٛ؞ اٜ مٛ وٛنْدِ اٜ مَرْلٜ لَدّٜ، مَلَاعِکَعٜنْ مبَلِّمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","تٛو، غَطَ طُمْ سُرِي يَحَيَ ندٜرْ سُودُ شُرَلْ، يٜىٰسُ يَحِ غَلِيلِ اٜ وَعَجِنَ حَبَرُ بٜلْطُمْ دَغَ تٛ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","اٜ مٛ وِعَ، ‏«‏شَرٜلْ وَطِي!‏ لَامُ اَللَّه وَرِي حَادٜ مٛوطٛنْ؞ تُوبٜىٰ، نجَٻٛنْ حَبَرُ بٜلْطُمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","يٜىٰسُ اٜ يَحَ حَادٜ مبٜىٰلَ غَلِيلِ، سٜيْ اٛ يِعِ سِيمَنْ اٜ مِݧِرَاوٛ مُوطُمْ اَنْدِرَاوُسْ اٜ ٻٜ نغَطَ نَنْغِرْطُمْ لِپِّ مَٻّٜ ندٜرْ ندِيَمْ، نغَمْ ٻٜ نَنْغٛوٻٜ لِپِّ؞ ");
INSERT INTO fuv_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","سٜيْ يٜىٰسُ وِعِٻٜ، ‏«‏تٛکّٜىٰيَمْ، مِ وَرْتِرَيْعٛنْ غَدَّيْٻٜ يِمْٻٜ تٛ اَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","طٛنْ اٜ طٛنْ ٻٜ اَلِ نَنْغِرْطُمْ لِپِّ مَٻّٜ ٻٜ تٛکِّمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","ندٜ اٛ ٻٜيْدِ يٜىٰسٛ سٜطَّ، سٜيْ اٛ يِعِ يَاکُبُ ٻِي جَبَدِ اٜ مِݧِرَاوٛ مُوطُمْ يَحَيَ اٜ ٻٜ ندٜرْ کٛمِوَلْ مَٻّٜ، اٜ ٻٜ مٛعِّنَ نَنْغِرْطُمْ لِپِّ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","طٛنْ اٜ طٛنْ اٛ نٛدِّٻٜ؞ سٜيْ ٻٜ اَلِ ݧَاکٛ مَٻّٜ جَبَدِ ندٜرْ کٛمِوَلْ اٜ کُوَنٛوٻٜٻٜ، ٻٜ تٛکِّ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","سٜيْ يٜىٰسُ اٜ تٛکُّٻٜمٛ نجَحِ غَرِيرِ کَفَرْنَحُمْ؞ ندٜ ݧَلْندٜ سِوْتَارٜ وَرِ، اٛ نَتِّ سُودُ دٛعَارٜ، اٛ فُطِّ اٜکِّتِنْکِ؞ ");
INSERT INTO fuv_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","يِمْٻٜ کَيْطِنِ اٜ اٜکِّتِنٛلْ مَاکٛ، نغَمْ اٛ اٜکِّتِنِرَايِٻٜ نٛ مٛودِٻّٜ اَتَّوْرَ اٜکِّتِنِرْتَ، اَمَّا اٛ اٜکِّتِنِيٻٜ اٜ بَوْطٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","طٛنْ اٜ طٛنْ غٛودُطٛ غِنّٛلْ ندٜرْ سُودُ دٛعَارٜ ندُنْ وُلِّ سٜمْبٜىٰ، ");
INSERT INTO fuv_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","وِعِ، ‏«‏کٛ وَنُّمَا اٜ اَمِنْ، يٜىٰسُ نَجَرَنْکٜىٰجٛ؟ اَ وَرٛيِ نغَمْ کَلْکَامِنْ؟ اٜ مِ اَنْدِ اَنْ اَ مٛيٜ؞ اَنْ وٛنِ شٜنِيطٛ اَللَّه؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","سٜيْ يٜىٰسُ حَٻَنِنغٛلْ، وِعِ، ‏«‏دٜعُّتُ!‏ وُرْتَ ندٜرْ مَاکٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","سٜيْ غِنّٛلْ نغٛلْ دِمْبِمٛ دِمْبٛلْ کَلُّنغٛلْ، نغٛلْ وُلِّ سٜمْبٜىٰ، نغٛلْ وُرْتِي ندٜرْ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","ٻٜ فُو ٻٜ کَيْطِنِ، ٻٜ نغَطِ کَ پَمْپَمْتِرْکِ، اٜ ٻٜ مبِعَ، ‏«‏طُمْ اُمْ طُمٜ؟ نغٛعٛلْ اٜکِّتِنٛلْ نغٛلْ کٜسٛلْ!‏ نٜطّٛ اٛعٛ اٜ وٛودِ بَوْطٜ حَا غِنِّ اٜ نغَطَ کٛ اٛ وِعِطِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","ندٜرْ شَرٜلْ سٜطَّ حَبَرُ يٜىٰسُ سَنْکِتِي کٛو تٛيٜ ندٜرْ لٜيْدِ غَلِيلِ؞ ");
INSERT INTO fuv_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","ندٜ يٜىٰسُ اٜ يَاکُبُ اٜ يَحَيَ ٻٜ مبُرْتِي دَغَ سُودُ دٛعَارٜ ندُنْ، ٻٜ نَتِّ وُرٛ بِيتُرُسْ اٜ اَنْدِرَاوُسْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","اٜسِرَاوٛ بِيتُرُسْ دٜبّٛ اٜ مٛ فِيدَ اٜ جٛنْتٜ اٜ مٛ فُکِّي؞ اٜ نَتُّکِ يٜىٰسُ ٻٜ کٛکِّمٛ حَبَرُ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","سٜيْ يٜىٰسُ يَحِ تٛ مَاکٛ جٛغَنِيمٛ جُنْغٛ اُمِّنِمٛ؞ طٛنْ اٜ طٛنْ جٛنْتٜ طٜنْ نجٛوفِمٛ، اٛ اُمِّي اٛ فُطِّ وَدَّنْکِٻٜ ݧَمْندُ؞ ");
INSERT INTO fuv_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","فُتُرٛ، غَطَ نَانغٜ حِيرِي، يِمْٻٜ نغَدَّنِ يٜىٰسُ فُو ݧَوْٻٜ اٜ غٛودُٻٜ غِنِّ؞ ");
INSERT INTO fuv_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","سٜيْ يِمْٻٜ غَرِيرِ ندِنْ طُطْٻٜ کَوْرِتِ اٜ دَمُّغَلْ وُرٛ نغٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","يٜىٰسُ يَمْطِتِنِ طُطْٻٜ غٛودُٻٜ ݧَوُوجِ فٜىٰرٜ‑فٜىٰرٜ؞ اٛ وُرْتِنَنِ يِمْٻٜ طُطْٻٜ غِنِّ، اٛ حَطِطِ مٜتُکِ نغَمْ اٜ طِ اَنْدِمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","اِلَا سُبَکَ، دَغَ ݧِوْرٜ اٜ حٛرِي، اٛ اُمِّي اٛ يَحِ وٛنْدٜ وِغٜىٰرٜ ندٜرْ لَدّٜ، اٛ وَطِ دٛعَارٜ تٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","سٜيْ سِيمَنْ اٜ غٛنْدُٻٜ اٜ مَاکٛ ندِلِّ طَٻُّتُکِمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ندٜ ٻٜ کٜٻْتِمٛ، ٻٜ مبِعِمٛ، ‏«‏کٛو مٛيٜ اٜ طَٻُّتُمَا!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","سٜيْ يٜىٰسُ وِعِٻٜ، ‏«‏اٜنْ نجَحُ غَرِيجٜ غٛنْطٜ حَادٜ طٛعٛ مِ وَعَجِنَ تٛنْ مَا، نغَمْ کَنْجُمْ نغَرْمِ مِ وَطَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","اٛ يَحِ کٛو تٛيٜ ندٜرْ لٜيْدِ غَلِيلِ، اٜ مٛ وَعَجِنَ ندٜرْ شُوطِ دٛعَارٜ مَٻّٜ، اٜ مٛ وُرْتِنَنَ يِمْٻٜ غِنِّ؞ ");
INSERT INTO fuv_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","غٛطّٛ غٛودُطٛ ݧَوُ ݧَامٛوجُمْ لَرَلْ وَرِ تٛ يٜىٰسُ دِشِّي اٜ تٛرٛومٛ، اٜ وِعَ، ‏«‏تَا جَٻِي، اَ وَاوَيْ نجَمْطِتِنَايَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","جُرُمْطُمْ نَنْغِ يٜىٰسُ، اٛ فٛرْتِ جُنْغٛ، اٛ مٜىٰمِمٛ، اٛ وِعِمٛ، ‏«‏مِ جَٻِي؞ يَمْطُتُ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","طٛنْ اٜ طٛنْ ݧَوُ طُمْ اَلِمٛ، اٛ يَمْطِتِ؞ ");
INSERT INTO fuv_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","سٜيْ يٜىٰسُ وَغِّنِمٛ، وِعِمٛ، ‏«‏دِلُّ، ");
INSERT INTO fuv_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","فَامُ، تَاع وِعُکَ کٛو مٛيٜ، اَمَّا يَحُ کٛلَّا حٛورٜ مَاطَ تٛ اَرْدِيطٛ دِينَ، ندٜنْ کٛکَّا شَکِّرِ نٛ مُوسَ وِعِ طُمْ وَطَ نغَمْ لَاٻٛلْ مَاطَ؞ وَطُ نٛنْ نغَمْ تَبِّتِنَنْکِ يِمْٻٜ اَ يَمْطِتِي؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","اَمَّا اٛ دِلِّ اٜ مٛ وِعَکَ کٛو تٛيٜ، اٜ مٛ سَنْکِتَ حَبَرُ طُمْ؞ نٛنْ وَطِ يٜىٰسُ وَاوَايِ نَتُّکِ وٛنْدِ غَرِيرِ اٜ نجَيْرِ، اَمَّا اٛ جٛوطِي اٜ لَدّٜ؞ فُو اٜ نٛنْ، يِمْٻٜ طُطْٻٜ نغَطِ کَ وَرْکِ تٛ مَاکٛ دَغَ کٛو تٛيٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","غَطَ بَلْطٜ سٜطَّ يٜىٰسُ سٛعِّي کَفَرْنَحُمْ؞ سٜيْ يِمْٻٜ نَنِ حَبَرُ اٜ مٛ وُرٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","يِمْٻٜ طُطْٻٜ کَوْرِتِ کٜىٰوِ وُرٛ نغٛنْ حَا وَلَا نجَيْرِ ندٜرْ وُرٛ نغٛنْ اٜ يَاسِ دَمُّغَلْ مَاغٛ؞ اٜ مٛ وَعَجِنَنَٻٜ وٛلْدٜ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","سٜيْ وٛٻّٜ نغَرٛيِ، ٻٜ نغَدَّنِمٛ غٛطّٛ جَرَاطٛ، يِمْٻٜ نَيٛ اٜ کٛشّٛيِمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","ندٜ ٻٜ مبَاوَايِ نَتِّنْکِمٛ تٛ يٜىٰسُ وٛنِ نغَمْ يِمْٻٜ طُوطِي، سٜيْ ٻٜ پٜنْتِنِمٛ دٛوْ سُودُ ندُنْ، ٻٜ نجُلِندُ، ٻٜ نغَطِمٛ ندٜرْ يُلْندٜ ندٜنْ دٛوْ دَاغٛ مَاکٛ، ٻٜ نجِڤِّنِمٛ يٜىٰسٛ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","ندٜ يٜىٰسُ يِعِ حٛولَارٜ مَٻّٜ، اٛ وِعِ جَرَاطٛ اٛنْ، ‏«‏حِغٛ، اَ يَافَنَامَ حَکّٜىٰجِ مَاطَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","وٛٻّٜ مٛودِٻّٜ اَتَّوْرَ اٜ نجٛوطِي طٛنْ اٜ ٻٜ ݧُمَ ندٜرْ ٻٜرْطٜ مَٻّٜ، ");
INSERT INTO fuv_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","اٜ ٻٜ مبِعَ، ‏«‏نغَمْ طُمٜ نٜطّٛ اٛعٛ مٜتِرْتَ نِحِ؟ اٜ مٛ فٛتِّدِنَ حٛورٜ مَاکٛ اٜ اَللَّه!‏ مٛيٜ وَاوَتَ يَافَاکِ حَکّٜ تٛ نَاع اَللَّه تَنْ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","طٛنْ اٜ طٛنْ يٜىٰسُ فَامِ ندٜرْ ٻٜرْندٜ مُوطُمْ اٜ ٻٜ ݧُمَ دٛوْ فِي طُعُمْ ندٜرْ ٻٜرْطٜ مَٻّٜ، اٛ وِعِٻٜ، ‏«‏نغَمْ طُمٜ ݧُمٛتٛنْ اِرِ ݧُمٛوجِ طِعِ ندٜرْ ٻٜرْطٜ مٛوطٛنْ؟ ");
INSERT INTO fuv_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","کٛ ٻُرِ حٛيْکِ، طُمْ وِعَ جَرَاطٛ اٛعٛ، ‏‹‏اَ يَافَنَامَ حَکّٜ مَاطَ،›‏ کٛو طُمْ وِعَمٛ، ‏‹‏اُمَّ حٛشُّ دَاغٛ مَاطَ، يَاٻُ؟›‏ ");
INSERT INTO fuv_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","اَمَّا اٜ مِ يِطِ اَنْدٛنْ ٻِي نٜطّٛ اٜ وٛودِ لَامُ ندٜرْ دُونِيَارُ يَافٛو حَکّٜ؞»‏ نغَمْ نٛنْ اٛ وِعِ جَرَاطٛ اٛنْ، ");
INSERT INTO fuv_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","‏«‏اٜ مِ وِعُمَا، اُمَّ، کٛشَّا دَاغٛ مَاطَ، کٛوتَا وُرٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","سٜيْ اٛ اُمِّي، اٛ حٛشِّ دَاغٛ مَاکٛ، اٛ وُرْتِي، اٛ دِلِّ يٜىٰسٛ کٛو مٛيٜ؞ فِي طُعُمْ حَيْطِنِ فُو يِمْٻٜ غٛنْٻٜ طٛنْ، ٻٜ مَنْتِ اَللَّه، ٻٜ مبِعِ، ‏«‏مِنْ مٜىٰطَايِ يِيکِ اِرِ فِي طُعُمْ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","يٜىٰسُ فُطِّتِ وُرْتِي يَحِ حَادٜ مبٜىٰلَ غَلِيلِ؞ يِمْٻٜ طُطْٻٜ نغَرِ تٛ مَاکٛ اٛ اٜکِّتِٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","اٜ مٛ پَٻّٛو، اٛ يِعِ لٜىٰوِ ٻِي حَلْفَ اٜ جٛوطِي تٛ طُمْ جَٻَتَ شٜىٰدٜ لٜيْدِ، سٜيْ يٜىٰسُ وِعِمٛ، ‏«‏تٛکَّمْ؞»‏ سٜيْ لٜىٰوِ اُمِّي تٛکِّمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","غَطَ طٛنْ يٜىٰسُ اٜ تٛکُّٻٜمٛ اٜ ٻٜ نجٛوطِي اٜ ٻٜ کِرْتٛو تٛ وُرٛ لٜىٰوِ؞ جَٻٛوٻٜ شٜىٰدٜ لٜيْدِ طُطْٻٜ اٜ غَطٛوٻٜ حَکّٜ اٜ ݧَمْدَ اٜ مَاکٛ اٜ تٛکُّٻٜمٛ، نغَمْ اٜ وٛودِ يِمْٻٜ طُطْٻٜ اِرِ مَٻّٜ اٜ تٛکِّمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","ندٜ مٛودِٻّٜ اَتَّوْرَ فَارِسَنْکٛعٜنْ نغِعِ اٜ مٛ ݧَمْدَ اٜ غَطٛوٻٜ حَکّٜ اٜ جَٻٛوٻٜ شٜىٰدٜ لٜيْدِ، ٻٜ مبِعِ تٛکُّٻٜمٛ، ‏«‏نغَمْ طُمٜ اٛ ݧَمْدَتَ اٜ جَٻٛوٻٜ شٜىٰدٜ لٜيْدِ اٜ غَطٛوٻٜ حَکّٜ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","ندٜ يٜىٰسُ نَنِ نٛنْ، اٛ وِعِٻٜ، ‏«‏نَاع يَمْٻٜ نغِطِ ݧَوْندٛووٛ، سٜيْ نِ ݧَوْٻٜ؞ مِ وَرٛيَايِ نغَمْ نٛدُّکِ ݧُمٛوٻٜ ٻٜ اَادِلِعٜنْ، اَمَّا مِ وَرٛيِ نغَمْ نٛدُّکِ اَنْدُٻٜ ٻٜ غَطٛوٻٜ حَکّٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","تٛو، تٛکُّٻٜ يَحَيَ غَطٛووٛ بَڤْتِسْمَ اٜ تٛکُّٻٜ فَارِسَنْکٛعٜنْ اٜ شُومٛو؞ سٜيْ وٛٻّٜ نغَرِ پَمِ يٜىٰسُ، ٻٜ مبِعِ، ‏«‏نغَمْ طُمٜ تٛکُّٻٜ يَحَيَ اٜ تٛکُّٻٜ فَارِسَنْکٛعٜنْ اٜ شُومٛو، اَمَّا تٛکُّٻٜمَ شُومَتَاکٛ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","يٜىٰسُ نٛوتِي، وِعِٻٜ، ‏«‏اٜ يِيکِ مٛوطٛنْ حِغٛوٻٜ اَنْغٛوجٛ شُومٛتٛ اٜ شَرٜلْ نغٜلْ اَنْغٛوجٛ اٛنْ اٜ وٛنْدِ اٜ مَٻّٜ؟ تٛ نِ اٜ ٻٜ نغٛنْدِ اٜ اَنْغٛوجٛ اٛنْ، ٻٜ شُومَتَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","اَمَّا شَرٜلْ اٜ وَرَ نغٜلْ طُمْ حٛشَّتَ اَنْغٛوجٛ اٛنْ دَغَ ندٜرْ مَٻّٜ، ندٜنْ اٜ ݧَلْندٜ ندٜنْ ٻٜ شُومٛتٛو؞ ");
INSERT INTO fuv_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","‏«‏وَلَا ݧٛوتَيْطٛ لٜفٜلْ کٜسٜلْ تٛ لِمْشٜرٜ کِيندٜ؞ تٛ اٛ وَطِي نٛنْ، لٜفٜلْ کٜسٜلْ نغٜلْ سٜىٰکَيْ اٜ لِمْشٜرٜ کِيندٜ ندٜنْ؞ نٛنْ وَطَيْ ندٜ ٻُرَ نٛ ندٜنّٛ سٜىٰکُکِ؞ ");
INSERT INTO fuv_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","نٛنْ مَا وَلَا غَطَيْطٛ ندِيَمْ اِنَبٛجَمْ کٜسَمْ ندٜرْ فَاندُ حِيندُ؞ تٛ اٛ وَطِي نٛنْ، طَمْ پُوفَيْ طَمْ ڤُسَ فَاندُ ندُنْ، ندٜنْ طُمْ دُلَّيْطَمْ، طُمْ دُلَّ فَاندُ ندُنْ؞ اَمَّا ندِيَمْ اِنَبٛجَمْ کٜسَمْ حَانِ وَطٜىٰ ندٜرْ فَاندُ حٜيْرُ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","وٛنْدٜ ݧَلْندٜ سِوْتَارٜ يٜىٰسُ اٜ تٛکُّٻٜمٛ اٜ پَٻّٛو ندٜرْ غٜسٜ اَلْکَمَارِ، سٜيْ تٛکُّٻٜمٛ ڤُطِّ ٻٛرُکِ شَمّٜىٰجٜ مَيْرِ اٜ ٻٜ ݧَامَ؞ ");
INSERT INTO fuv_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","سٜيْ فَارِسَنْکٛعٜنْ مبِعِمٛ، ‏«‏رَا کٛ تٛکُّٻٜمَ نغَطَتَ؞ کٛ وَطَتَ اٜ ٻٜ نغَطَ کٛ اَتَّوْرَ حَطِ طُمْ وَطَ ݧَلْندٜ سِوْتَارٜ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","يٜىٰسُ وِعِٻٜ، ‏«‏اٛنْ مٜىٰطَايِ جَنْغُکِ کٛ دَوْدَ وَطِ، کَنْکٛ اٜ غٛنْدُٻٜ اٜ مَاکٛ ندٜ ٻٜ نَنِ وٜىٰلٛ کَدِنْ اٜ ٻٜ ندٜرْ دُلّٜرٜ ݧَمْندُ؟ ");
INSERT INTO fuv_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","اٜ جَامَنُ طُمْ اَبِيَتَ وٛنِ مَوْطٛ مَوْٻٜ اَرْدِيٻٜ دِينَ، دَوْدَ نَتِّ لُکُرُ سٜنِيطُمْ ݧَامِ بُرٛودِ شٜنِيطُمْ؞ اَتَّوْرَ بٛو وِعِي اَرْدِيٻٜ دِينَ تَنْ حَانِ ݧَامُکِ بُرٛودِ طُمْ، اَمَّا دَوْدَ ݧَامِطُمْ حَا مَا اٛ حٛکّٛرِ جَادٛوٻٜ اٜ مَاکٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","سٜيْ يٜىٰسُ وِعِٻٜ، ‏«‏ݧَلْندٜ سِوْتَارٜ وَطَا نغَمْ نٜطّٛ، نَاع نٜطّٛ وَطَا نغَمْ ݧَلْندٜ سِوْتَارٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","نغَمْ نٛنْ ٻِي نٜطّٛ اٛ جٛومُ کٛو طُمٜ حَا اٜ ݧَلْندٜ سِوْتَارٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","وٛنْدٜ ݧَلْندٜ يٜىٰسُ نَتِّ سُودُ دٛعَارٜ، اٜ وٛودِ غٛطّٛ مٛ جُنْغٛ جَرَانغٛ ندٜرْ مَيْرُ؞ ");
INSERT INTO fuv_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","سٜيْ وٛٻّٜ ندٜرْ سُودُ دٛعَارٜ ندُنْ شُتِيمٛ کٛو اٛ يَمْطِتِنَيْ نٜطّٛ اٛنْ ݧَلْندٜ سِوْتَارٜ نغَمْ ٻٜ کٜٻَ کٛ ٻٜ نغُلِّرٛيْتٛومٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","سٜيْ يٜىٰسُ وِعِ مٛ جُنْغٛ جَرَانغٛ اٛنْ، ‏«‏وٛرٛيْ طٛعٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","ندٜنْ يٜىٰسُ پَمِٻٜ وِعِ، ‏«‏کٛ اَتَّوْرَ وِعِ طُمْ وَطَ ݧَلْندٜ سِوْتَارٜ؟ طُمْ وَطَ کٛ وٛوطِ، کٛو طُمْ وَطَ کٛ وٛوطَا؟ طُمْ حِسْنَ يٛنْکِ، کٛو طُمْ وَطَ وَرْحٛورٜ؟»‏ اَمَّا ٻٜ فُو ٻٜ ندٜعِّتِ؞ ");
INSERT INTO fuv_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","يٜىٰسُ رَارِٻٜ ٻٜرْندٜ مُوطُمْ اٜ مٜتِّ، اٛ وَنِّي نغَمْ ٻٜرْطٜ مَٻّٜ طٜ شَاتُطٜ؞ سٜيْ اٛ وِعِ مٛ جُنْغٛ جَرَانغٛ اٛنْ، ‏«‏فٛرْتُ جُنْغٛ مَاطَ؞»‏ اٛ فٛرْتِنغٛ، سٜيْ نغٛ يَمْطِتِ؞ ");
INSERT INTO fuv_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","سٜيْ فَارِسَنْکٛعٜنْ مبُرْتِي سُودُ دٛعَارٜ ندُنْ، ٻٜ ڤُطِّ مٜدُّکِ اٜ يِمْٻٜ حِرُدُسْ دٛوْ نٛ ٻٜ مبَرْدَتَ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","سٜيْ يٜىٰسُ دِلِّدِ اٜ تٛکُّٻٜمٛ يَاکِ حَادٜ مبٜىٰلَ غَلِيلِ؞ سٜيْ يِمْٻٜ طُطْٻٜ پِوٛيِٻٜ غَلِيلِ تٛکِّمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ندٜ يِمْٻٜ طُطْٻٜ نَنِ حَبَرُ فُو کٛ اٛ وَطَتَ، ٻٜ نغَرِ تٛ مَاکٛ دَغَ يَحُودِيَ، اٜ اُرُشَلِيمَ، اٜ اِدُومِيَ، اٜ فٛنْغٛ شَانغٛلْ اُرْدُنْ، اٜ لٜيْدِ حَادٜ غَرِيجٜ تَايَ اٜ سِدٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","اٛ وِعِ تٛکُّٻٜمٛ نغَدَّنَمٛ کٛمِوَلْ نغَمْ يِمْٻٜ طُطْٻٜ کَوْرِتِي تٛع ٻٜ ٻِطَّمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","اٛ وَطُ نٛنْ نغَمْ اٛ يَمْطِتِنِي يِمْٻٜ طُطْٻٜ حَا ݧَوْٻٜ طُطْٻٜ نغَطِ کَ فِيدُکِ نغَمْ ٻٜ مٜىٰمَمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","فُو شَرٜلْ نغٜلْ يِمْٻٜ غٛودُٻٜ غِنِّ نغِعِمٛ، سٜيْ ٻٜ نجَنَ يٜىٰسٛ مَاکٛ اٜ ٻٜ مبِعَ اٜ سٜمْبٜ، ‏«‏اَنْ اَ ٻِطّٛ اَللَّه!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","اَمَّا اٛ وَغِّنِٻٜ تٛع ٻٜ مبِعَکَ کٛو مٛيٜ کَنْکٛ اٛ مٛيٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","يٜىٰسُ پٜنْتِ حٛشّٜىٰرٜ نٛدِّ ٻٜ اٛ يِطِ؞ ٻٜ نجَحِ تٛ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","اٛ سُٻِ يِمْٻٜ سَڤّٛ اٜ طِطٛ نغَمْ ٻٜ نجٛوطٛدٛو اٜ مَاکٛ، ندٜنْ اٛ لِلَٻٜ ٻٜ نغَعَجِنٛيَ، اٛ نٛدِّٻٜ لِلَاٻٜ، ");
INSERT INTO fuv_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","اٛ حٛکِّٻٜ بَوْطٜ وُرْتِنْکِ غِنِّ؞ ");
INSERT INTO fuv_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","رَا اِنْطٜ يِمْٻٜ ٻٜ اٛ سُٻِ ٻٜنْ:‏ سِيمَنْ مٛ اٛ حٛکِّ اِنْدٜ بِيتُرُسْ، ");
INSERT INTO fuv_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","اٜ يَاکُبُ ٻِي جَبَدِ، اٜ مِݧِرَاوٛ مُوطُمْ يَحَيَ، اٛ حٛکِّٻٜ اِنْدٜ بُوَرْنَجِسْ، وَاتٛ ٻِٻّٜ رِغَّانغٛ، ");
INSERT INTO fuv_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","اٜ اَنْدِرَاوُسْ، اٜ فِلِبُسْ، اٜ بَتِلٛومِ، اٜ مَاتِيُ، اٜ تٛومَ، اٜ يَاکُبُ ٻِي حَلْفَ، اٜ تَادِيُسْ، اٜ سِيمَنْ کَنَنِيَنْکٜىٰجٛ، ");
INSERT INTO fuv_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","اٜ يَحُودَ اِسْکَرِيٛوتِ، غَرْتُطٛ کٛکِّتِرْطٛ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","ندٜنْ يٜىٰسُ نَتِّ وُرٛ تٛ جٛوطٛتٛو، سٜيْ يِمْٻٜ طُطْٻٜ فُطِّتِ کَوْرِتِ تٛ مَاکٛ حَا کَنْکٛ اٜ تٛکُّٻٜمٛ ٻٜ مبَاوَايِ ݧَامُکِ ݧَمْندُ؞ ");
INSERT INTO fuv_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","ندٜ بَنْدِرَاٻٜ مَاکٛ نَنِي نٛنْ، ٻٜ نجَحِ نغَمْ ٻٜ نَنْغٛيَمٛ، نغَمْ ٻٜ نَنِي يِمْٻٜ اٜ مبِعَ، ‏«‏اٛ حَاݝَکٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","مٛودِٻّٜ اَتَّوْرَ غَرٛيْٻٜ دَغَ اُرُشَلِيمَ مبِعِ، ‏«‏بَعَلْجَبُلْ لَامِيطٛ غِنِّ نَنْغِمٛ، ندٜنْ اٜ بَوْطٜ مَاغٛلْ اٛ وُرْتِنِرْتَ غِنِّ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","سٜيْ يٜىٰسُ نٛدِّٻٜ حٛکِّٻٜ مِسَالُ وِعِٻٜ، ‏«‏نٛ وَطَتَ شٜيْطَنْ رِيوَ شٜيْطَنْ؟ ");
INSERT INTO fuv_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","تٛ لَامُ سٜنْدَکٜ اٜ وَݧْوَݧْتِرَ، طُمْ وَاوَتَا طُمْ دَرٛو؞ ");
INSERT INTO fuv_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","نٛنْ مَا تٛ وُرٛ سٜنْدَکٜ اٜ وَݧْوَݧْتِرَ، نغٛنْ طٛنْ وُرٛ نغٛ وَاوَتَا نغٛ دَرٛو؞ ");
INSERT INTO fuv_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","تٛ لَامُ شٜيْطَنْ سٜنْدَکٜ اٜ وَݧْوَݧْتِرَ، طُمْ وَاوَتَا طُمْ دَرٛو، رٜعِرْدٜ مَاجُمْ وَرِي وٛنْ طٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","‏«‏وَلَا بَاوَيْطٛ نَتَّ وُرٛ شٜمْبِطّٛ تٜىٰتَنَمٛ کٛ اٛ وٛودِ، سٜيْ نِ اَرْتَ حَٻُّکِمٛ، ندٜنْ وَاوَ حٛشُّکِ کٛ اٛ وٛودِ ندٜرْ وُرٛ نغٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","‏«‏اٜ مِ وِعَعٛنْ غٛونغَ، طُمْ وَاوَيْ يَافَنَاکِ يِمْٻٜ حَکّٜ اٜ کٛو اِرِ طِيٜ حَالَاجِ کَلُّطِ طِ ٻٜ مٜتِ؞ ");
INSERT INTO fuv_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","اَمَّا فُو بِعُطٛ کٛ وٛوطَا دٛوْ رُوحُ اَللَّه، اٛ يَافَنْتَاکٜ حَا اَبَدَا؞ حَا اَبَدَا حَکّٜ طُمْ اٜ دٛوْ مَاکٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","يٜىٰسُ وِعِي نٛنْ نغَمْ اٜ ٻٜ مبِعَ، ‏«‏اٜ مٛ وٛودِ غِنّٛلْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","سٜيْ مَدُوجٛ يٜىٰسُ اٜ مِݧِرَاٻٜ مَاکٛ نغَرِ ندَرِي يَاسِ، ٻٜ لِلِ غٛطّٛ نٛدّٛيَ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","يِمْٻٜ طُطْٻٜ اٜ نجٛوطِي اٜ ٻٜ ڤِلِي يٜىٰسُ، ٻٜ مبِعِمٛ، ‏«‏مَدُوجٛ مَاطَ اٜ مِݧِرَاٻٜ مَاطَ اٜ ٻٜ تٛنْ يَاسِ، اٜ ٻٜ طَٻُّتُمَا؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","يٜىٰسُ پَمِٻٜ وِعِ، ‏«‏مٛيٜ وٛنِ مَدُوجٛ اَمْ، ندٜنْ ٻٜيٜ نغٛنِ مِݧِرَاٻٜ اَمْ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","اٛ رَارِ جٛوطِيٻٜ اٜ ڤِلِيمٛ اٛ وِعِ، ‏«‏رَا مَدُوجٛ اَمْ اٜ مِݧِرَاٻٜ اَمْ طٛعٛ!‏ ");
INSERT INTO fuv_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","فُو غَطُطٛ کٛ اَللَّه يِطِ، کَنْکٛ وٛنِ مِݧِرَاوٛ اَمْ اٜ مَدُوجٛ اَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","طٛنْمَا يٜىٰسُ فُطِّ اٜکِّتِنْکِ حَادٜ مبٜىٰلَ غَلِيلِ؞ يِمْٻٜ طُطْٻٜ کَوْرِتِ تٛ مَاکٛ نَاکِ اٛ نَتِّ کٛمِوَلْ اٛ جٛوطِي ندٜرْ مَاغَلْ دٛوْ ندِيَمْ؞ کَوْرُتُٻٜ ٻٜنْ فُو اٜ ٻٜ حَادٜ مبٜىٰلَ نغَنْ دٛوْ نجَارٜىٰندِ؞ ");
INSERT INTO fuv_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","سٜيْ اٛ حُوتِرِ مِسَالُ اٛ اٜکِّتِٻٜ اٜکِّتِنٛلْ فٜىٰرٜ‑فٜىٰرٜ طُطْنغٛلْ؞ ندٜرْ اٜکِّتِنٛلْ مَاکٛ اٛ وِعِ، ");
INSERT INTO fuv_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","‏«‏کٜتِّندٜىٰ!‏ غٛطّٛ دٜمٛووٛ يَحِ نغٜسَ نغَمْ سَاکَ اَوْدِ؞ ");
INSERT INTO fuv_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","اٜ مٛ ندٜرْ سَاکُکِ اَوْدِ ندِنْ، وٛنْدِ يَنِ دٛوْ طَتَلْ، شٛلِّ نغَرِ شُڤِّدِندِ؞ ");
INSERT INTO fuv_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","وٛنْدِ بٛو يَنِ ندٜرْ کَاپٜ؛ طٛنْ ندِ حٜٻَايِ لٜيْدِ طُنْدِ؞ ندِ فُطِ جَوْطُمْ نغَمْ لٜيْدِ ندِنْ لُغَّا؞ ");
INSERT INTO fuv_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","اَمَّا ندٜ نَانغٜ وُرْتٛيِي فِيِندِ، سٜيْ ندِ يٛورِ نغَمْ ندِ وَلَا طَطِ؞ ");
INSERT INTO fuv_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","وٛنْدِ اَوْدِ بٛو يَنِ ندٜرْ غِعٜ، سٜيْ غِعٜ طٜنْ مَوْنِ ٻِطِّندِ حَا ندِ وَاوَايِ وَطُکِ شَمّٜىٰجٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","اَمَّا وٛنْدِ اَوْدِ يَنِ دٛوْ لٜيْدِ مبٛنْدِ ندِ فُطِ ندِ مَوْنِ ندِ وَطِ شَمّٜىٰجٜ؞ وٛنْدِ وَطِ غَبّٜ 30، وٛنْدِ وَطِ غَبّٜ 60، وٛنْدِ حَا 100؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","ندٜ يٜىٰسُ حٜىٰݧِ حٛکُّکِ مِسَالُ طُعُمْ، سٜيْ اٛ وِعِ، ‏«‏غٛودُطٛ نٛڤِّ نَنُکِ فُو نَنَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","ندٜ يٜىٰسُ اٜ جٛوطِي کَنُمْ تَنْ، تٛکُّٻٜمٛ سَڤّٛ اٜ طِطٛ اٜ وٛٻّٜ تٛکُّٻٜمٛ نجَحِ تٛ مَاکٛ ٻٜ پَمِمٛ اٛ حٛکَّٻٜ مَعَنَ طُمْ طٛنْ مِسَالُ؞ ");
INSERT INTO fuv_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","سٜيْ اٛ وِعِٻٜ، ‏«‏اٛنٛنْ اٛنْ کٛکَّامَ فَامُکِ سِرُّ لَامُ اَللَّه، اَمَّا يِمْٻٜ ٻٜ نغَلَا ندٜرْ مٛوطٛنْ، کٛو طُمٜ سٜيْ اٜ مِسَالُ، ");
INSERT INTO fuv_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","نغَمْ، ‏‹‏اٜ ٻٜ ندَارَ، اَمَّا ٻٜ نغِعَتَا؞ اٜ ٻٜ نَنَ، اَمَّا ٻٜ ڤَامَتَا؞ نغَمْ تٛ نَاع نٛنْ طُمْ غَطٛتٛوطُمْ ٻٜ نَنَ، ٻٜ تُوبَ، طُمْ يَافَنٛوٻٜ؞›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","سٜيْ يٜىٰسُ وِعِٻٜ، ‏«‏اٛنْ ڤَامَايِ مِسَالُ طُعُمْ؟ تٛو، نٛ ڤَامِرْتٛنْ مِسَالُ کٛرِيطُمْ؟ ");
INSERT INTO fuv_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","کٛ دٜمٛووٛ اٛنْ سَاکِ وٛنِ وٛلْدٜ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","وٛٻّٜ يِمْٻٜ اٜ نَنْدِ اٜ اَوْدِ نجَنُندِ دٛوْ طَتَلْ؞ شَرٜلْ نغٜلْ ٻٜ نَنِ وٛلْدٜ اَللَّه، طٛنْ اٜ طٛنْ شٜيْطَنْ وَرَ حٛشَّندٜ دَغَ ندٜرْ ٻٜرْطٜ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","وٛٻّٜ بٛو اٜ نَنْدِ اٜ اَوْدِ نجَنُندِ حَکُّندٜ کَاپٜ؞ تٛ ٻٜ نَنِي وٛلْدٜ اَللَّه، طٛنْ اٜ طٛنْ ٻٜ نجَٻَندٜ ندٜرْ بٜلْطُمْ ٻٜرْندٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","اَمَّا ندٜ ٻٜ نغَلَا طَطِ، ٻٜ مُݧَيْ شَرٜلْ سٜطَّ تَنْ؞ تٛ شَطٜىٰلٜ کٛو تٛرَّ وَرِي نغَمْ وٛلْدٜ ندٜنْ، طٛنْ اٜ طٛنْ ٻٜ نجٛوفَندٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","وٛٻّٜ کَدِنْ اٜ نَنْدِ اٜ اَوْدِ شَاکَاندِ ندٜرْ غِعٜ؞ ٻٜ نَنِ وٛلْدٜ ندٜنْ، ");
INSERT INTO fuv_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","اَمَّا وَنُّکِ اٜ فِي دُونِيَارُ، اٜ يِدّٜ جَوْدِ، اٜ سُونٛ فٜىٰرٜ‑فٜىٰرٜ نَتِّ ٻٜرْطٜ مَٻّٜ ٻِطِّ وٛلْدٜ ندٜنْ کَطِندٜ وَلُّکِٻٜ ٻٜ نغَطَ کٛ اَللَّه يِطِ؞ ");
INSERT INTO fuv_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","وٛٻّٜ بٛو اٜ نَنْدِ اٜ اَوْدِ شَاکَاندِ دٛوْ لٜيْدِ مبٛنْدِ؞ ٻٜ نَنِ وٛلْدٜ اَللَّه، ٻٜ نجَٻِندٜ، ٻٜ کُوتِنِرِندٜ حَا ٻٜ کٜٻِ ٻٜيْدَارِ، وٛٻّٜ کٜٻِ ندٜ 30، وٛٻّٜ کٜٻِ ندٜ 60، وٛٻّٜ حَا ندٜ 100؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","اٛ وِعِٻٜ، ‏«‏اٛنْ نغَدَّيْ فِتِلَارُ کِڤّٛنْ تُمُّدٜ دٛوْ مَيْرُ، کٛو ندٜسٛنْدُ لٜيْ لٜىٰسٛ؟ نَاع اٛنْ ندٜسَيْندُ دٛوْ دَنْکِ؟ ");
INSERT INTO fuv_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","فُو کٛ سُوطِي، طُمْ وُرْتِنَيْطُمْ اٜ نجَيْرِ، نٛنْ مَا فُو کٛ اٛمْبَا طُمْ اٛمْتٜتٜىٰطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","غٛودُطٛ نٛڤِّ نَنُکِ فُو نَنَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","اٛ فُطِّتِ اٛ وِعِٻٜ، ‏«‏ڤَامٜىٰ بٛطُّمْ اٜ کٛ نَنٛتٛنْ!‏ اٜ ڤٛوندِرْغٜلْ نغٜلْ ڤٛوندِرْتٛنْ، اٜ مَاغٜلْ طُمْ فٛوندِرَنْتَعٛنْ حَا مَا طُمْ ٻٜيْدَنَعٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","نغَمْ فُو غٛودُطٛ فَامُ دٛوْ لَامُ اَللَّه طُمْ ٻٜيْدَنَيْمٛ؞ اَمَّا مٛ وَلَا فَامُ دٛوْ لَامُ اَللَّه، کٛو کٛ اٛ وٛودِ مَا طُمْ جَٻَيْطُمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","يٜىٰسُ فُطِّتِ وِعِ، ‏«‏لَامُ اَللَّه اٜ نَنْدِ اٜ نٜطّٛ شَاکٛووٛ اَوْدِ اٜ نغٜسَ؞ ");
INSERT INTO fuv_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","وَالَ فِنَ، کٛو اٜ مٛ طَانِي کٛو اٛ طَانَاکِ، اَوْدِ ندِنْ فُطَيْ مَوْنَ، اَمَّا اٛ اَنْدَا نٛ طُمْ وَطِرِ؞ ");
INSERT INTO fuv_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","لٜيْدِ اٜ وُرْتِنَ غَوْرِ اٜ حٛورٜ مَيْرِ؞ اَرَنْدٜ پٛمْبَلْ وُرْتٛتٛ، ندٜنْ سَمّٜىٰرٜ، ندٜنْ سَمّٜىٰرٜ ندٜنْ وُرْتِنَ نغَبّٛيْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","تٛ غَوْرِ ندِنْ ٻٜنْدِي، سٜيْ اٛ يَادَ اٜ لَوْجٜىٰرُ اٛ تَپَ، نغَمْ شَرٜلْ اِتُّکِندِ وَرِي؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","يٜىٰسُ کَدِنْ وِعِ، ‏«‏کٛ نَنْدِنَيْمِ لَامُ اَللَّه؟ کٛو بٛو اٜ طُمٜ مِسَالُ نَنْدِنَيْمِطُمْ؟ ");
INSERT INTO fuv_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","اٜ طُمْ نَنْدِ اٜ غَبّٜلْ مَسْتَتْ، غَبّٜلْ ٻُرْنغٜلْ کٛو نغٜلٜ غَبّٜلْ اَاوٜتٜىٰنغٜلْ فَمْطُکِ؞ ");
INSERT INTO fuv_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","فُو اٜ نٛنْ تٛ نغٜلْ اَاوَامَ، اٜ نغٜلْ مَوْنَ نغٜلْ ٻُرَ کٛو نغٜلٜ لٜغّٜلْ مَوْنُکِ، نغٜلْ وَطَ لِشٜ مَوْطٜ حَا شٛلِّ کٛطَ ندٜرْ طٛوْدِ مَاغٜلْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","يٜىٰسُ حُوتِرِي اِرِ مِسَالُ طُعُمْ طُطُّمْ، اٛ وَعَجِنَنِٻٜ وٛلْدٜ اَللَّه حَا کٜىٰرٛلْ نٛ ٻٜ مبَاوِ فَامُکِ؞ ");
INSERT INTO fuv_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","فُو کٛ اٛ وِعَتَٻٜ اٜ مٛ حُوتِرَ مِسَالُ؞ اَمَّا تٛ اٜ مٛ وٛنْدِ اٜ تٛکُّٻٜمٛ کَمْٻٜ تَنْ، سٜيْ اٛ وِعَٻٜ مَعَنَ کٛ اٛ وِعِ؞ ");
INSERT INTO fuv_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","اٜ ندٜنْ طٛنْ ݧَلْندٜ اَلَاسَرَ يٜىٰسُ وِعِ تٛکُّٻٜمٛ، ‏«‏اٜنْ کُولُ فٛنْغٛ مبٜىٰلَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","سٜيْ تٛکُّٻٜمٛ اَلِ يِمْٻٜ حَوْرُتُٻٜ، ٻٜ نَتِّ ندٜرْ کٛمِوَلْ نغَلْ اٛ وٛنِ ندٜرْ، ٻٜ ندِلِّدِ اٜ مَاکٛ؞ اٜ وٛودِ کٛمِيجٜ فٜىٰرٜ تٛکِّٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","سٜيْ اِيٜىٰندٜ اٜ حٜنْدُ شٜمْبِنْدُ اُمّٛيِي، غٜىٰلٛوطِ ندِيَمْ ڤُطِّ ڤِيکِ کٛمِوَلْ نغَلْ، ندِيَمْ نَتِّ ندٜرْ مَاغَلْ حَا نَاکِ کٛمِوَلْ نغَلْ ٻَدِي حٜىٰوَ ندِيَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","يٜىٰسُ بٛو اٜ تٛنْ غَطَ کٛمِوَلْ نغَلْ اٜ طَانِي دٛوْ ٻَنْتِرْطُمْ حٛورٜ؞ سٜيْ تٛکُّٻٜمٛ ڤِنْدِنِمٛ مبِعِمٛ، ‏«‏مٛودِبّٛ، اَ وَنَّايِ تٛ اٜنْ کَلْکِي؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","سٜيْ اٛ اُمِّي، اٛ حَٻَنِ حٜنْدُ ندُنْ، اٛ وِعِ غٜىٰلٛوطِ ندِيَمْ طِنْ، ‏«‏ندٜعِّتٜىٰ!‏ اَلٜىٰ!‏»‏ سٜيْ حٜنْدُ ندُنْ اَلِ، کٛو طُمٜ دٜعِّتِ؞ ");
INSERT INTO fuv_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","اٛ وِعِ تٛکُّٻٜمٛ، ‏«‏نغَمْ طُمٜ نغٛودُطٛنْ کُلٛلْ؟ حَا جٛونِ اٛنْ کٛولَاکِيَمْ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","ٻٜ کُلْتٛرِ، ٻٜ پَمْپَمْتِرِ، ٻٜ مبِعِ، ‏«‏طُمْ مٛيٜ اٛعٛ؟ حَا حٜنْدُ اٜ غٜىٰلٛوطِ ندِيَمْ اٜ نغَطَ کٛ اٛ وِعِ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","يٜىٰسُ اٜ تٛکُّٻٜمٛ کُولِ فٛنْغٛ مبٜىٰلَ ٻٜ نجٛتِّي لٜيْدِ غَارَسِنْکٛعٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","ندٜ يٜىٰسُ وُرْتِي دَغَ ندٜرْ کٛمِوَلْ نغَلْ، سٜيْ غٛطّٛ غٛودُطٛ غِنّٛلْ پِوٛيِ تٛ غٜنَالٜ تَٻِّيمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","نٜطّٛ اٛنْ ندٜرْ غٜنَالٜ اٛ جٛوطٛتٛو، وَلَا بَاوَيْطٛ حَٻُّکِمٛ، کٛو اٜ ٻٛغِّ نجَمْندِ؞ ");
INSERT INTO fuv_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","ندٜ طُطُّمْ اٜ مٛ حَٻِّرٜىٰ ٻٛغِّ نجَمْندِ جُوطٜ اٜ کٛيْطٜ، اَمَّا اٛ تَپَطِ اٛ يٜوَ نجَمْندِ غَطَاندِ تٛ کٛيْطٜ مَاکٛ؞ وَلَا غٛودُطٛ سٜمْبٜ بَاوَيْطٛ جٛغَاکِمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","جٜمَّ اٜ ݧَلَوْمَ اٜ مٛ ندٜرْ غٜنَالٜ کٛو دٛوْ کٛشّٜىٰجٜ، اٜ مٛ وُلَّ سٜمْبٜىٰ، اٜ مٛ تَپِرَ ٻَنْدُ مَاکٛ اٜ کَاپٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","ندٜ اٛ حَيْنِي يٜىٰسُ، اٛ دٛغِّ اٛ يَحِ تٛ مَاکٛ، اٛ دِشِّي يٜىٰسٛ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","اٛ وُلِّ سٜمْبٜىٰ اٛ وِعِ، ‏«‏کٛ وَنُّمَا اٜ اَمْ، يٜىٰسُ ٻِطّٛ اَللَّه جٛومُ مَنْغُ؟ اٜ مِ تٛرٛمَا نغَمْ اَللَّه، تَاع تٛرَّمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","اٛ وِعُ نٛنْ نغَمْ يٜىٰسُ وِعِي، ‏«‏اَنْ غِنّٛلْ، وُرْتَ ندٜرْ نٜطّٛ اٛعٛ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","سٜيْ يٜىٰسُ پَمِنغٛلْ وِعِ، ‏«‏نٛ اِنْدٜ مَاطَ؟»‏ نغٛلْ نٛوتِي نغٛلْ وِعِ، ‏«‏طُطِّ، نغَمْ اٜ مِنْ طُوطِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","سٜيْ نغٛلْ وَطِ کَ تٛرَاکِ يٜىٰسُ تٛع اٛ رِيوَطِ دَغَ لٜيْدِ ندِنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","حَادٜ طٛنْ اٜ وٛودِ اٛرْندٜ اَلَدٜىٰجِ طُطِّ اٜ دُرَ تٛ رٜغٛرْدٜ حٛشّٜىٰرٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","سٜيْ غِنِّ طِنْ تٛرِي يٜىٰسُ طِ مبِعِ، ‏«‏اَلُمِنْ مِنْ نَتّٛيَ اَلَدٜىٰجِ طِنْ نِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","يٜىٰسُ جَٻِ، سٜيْ طِ مبُرْتِي طِ نَتّٛيِ اَلَدٜىٰجِ طِنْ؞ اَلَدٜىٰجِ طِنْ بٛو کٜوْتِي 2,000؞ اٛرْندٜ ندٜنْ فُو ݧَارِ جِڤّٛيِي دَغَ دٛوْ پٛلْدٜ ندٜنْ يَنِ ندٜرْ مبٜىٰلَ، ندِيَمْ ݧَامِطِ؞ ");
INSERT INTO fuv_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","وٛيْنَاٻٜ اَلَدٜىٰجِ طِنْ ندٛغِّ مبِعٛيِکَ يِمْٻٜ ندٜرْ غَرِيرِ اٜ يِمْٻٜ نغَرِحٛيْ؞ يِمْٻٜ ٻٜنْ نجَحِ نغِعَ کٛ وَطِ؞ ");
INSERT INTO fuv_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","ندٜ ٻٜ نغَرِ تٛ يٜىٰسُ وٛنِ، ٻٜ نغِعِ غٛودُنٛوطٛ غِنِّ طُطِّ اٛنْ، اٜ مٛ جٛوطِي طٛنْ، اٜ ٻٛرْنِي، اٜ مٛ ندٜرْ حَکِّيلٛ مَاکٛ؞ کٛو مٛيٜ مَٻّٜ حُلِ؞ ");
INSERT INTO fuv_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","غِعُٻٜ کٛ وَطِ ٻٜ مبِعِ يِمْٻٜ ٻٜنْ کٛ حٜٻِ غٛودُنٛوطٛ غِنِّ اٛنْ اٜ اَلَدٜىٰجِ طِنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","سٜيْ يِمْٻٜ ٻٜنْ ڤُطِّ تٛرَاکِ يٜىٰسُ اَلَنَٻٜ لٜيْدِ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","يٜىٰسُ اٜ نَتَّ کٛمِوَلْ، سٜيْ غٛودُنٛوطٛ غِنِّ اٛنْ تٛرِي دِلِّدَ اٜ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","اَمَّا يٜىٰسُ جَٻَايِ اٛ دِلِّدَ اٜ مُوطُمْ، وِعِمٛ، ‏«‏حٛوتُ تٛ بَنْدِرَاٻٜ مَاطَ مبِعَٻٜ فِي مَوْطُمْ طُمْ جٛومِرَاوٛ وَطَنْمَا اٜ نٛ اٛ يُرْمِنِرَنْمَا؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","سٜيْ نٜطّٛ اٛنْ دِلِّ لٜيْدِ دِکَڤٛلِسْ، اٛ فُطِّ حٛکُّکِ حَبَرُ فِي مَوْطُمْ طُمْ يٜىٰسُ وَطَنِمٛ؞ فُو يِمْٻٜ ٻٜنْ کَيْطِنِ؞ ");
INSERT INTO fuv_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","ندٜ يٜىٰسُ فُطِّتِ حُولِ فٛنْغٛ مبٜىٰلَ ندٜرْ کٛمِوَلْ، يِمْٻٜ طُطْٻٜ کَوْرِتِ تٛ مَاکٛ، کَنْکٛ بٛو اٜ مٛ حَادٜ مبٜىٰلَ نغَنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","سٜيْ غٛعٛتٛ ندٜرْ اَرْدِيٻٜ سُودُ دٛعَارٜ بِعٜتٜىٰطٛ جَايِرُسْ وَرِ؞ ندٜ اٛ يِعِ يٜىٰسُ، اٛ دِشِّي يٜىٰسٛ مَاکٛ، ");
INSERT INTO fuv_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","اٛ وَطِ کَ تٛرَاکِ يٜىٰسُ، اٜ مٛ وِعَ، ‏«‏ٻِطّٛ اَمْ سُرْبَاجٛ ڤَمَرٛ ٻَدَکٜ مَيْدٜ، اٜ مِ تٛرٛمَا نغَرَا مٜىٰمَامٛ نغَمْ اٛ يَمْطِتَ تٛع اٛ مَايَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","سٜيْ يٜىٰسُ يَادِ اٜ مَاکٛ؞ يِمْٻٜ طُطْٻٜ تٛکِّمٛ، اٜ ٻٜ ٻِطَّمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","اٜ وٛودِ غٛطّٛ دٜبّٛ طٛنْ غَطُطٛ دُوٻِ سَڤّٛ اٜ طِطِ اٜ تٛرّٛدٛو اٜ رُفُکِ پِيپَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","دٜبّٛ اٛنْ تٛرَّکٜ نَاع سٜطَّ تٛ جُوطٜ ݧَوْندٛوٻٜ طُطْٻٜ، اٛ مَجِّنِي فُو جَوْدِ مَاکٛ؞ اٛ يَمْطِتَايِ، اَمَّا ݧَوُ طُمْ ٻٜيْدِي؞ ");
INSERT INTO fuv_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","ندٜنْ مَا اٛ نَنِي حَبَرُ يٜىٰسُ، سٜيْ اٛ پِوٛيِ غَطَ يٜىٰسُ ندٜرْ يِمْٻٜ، اٛ مٜىٰمِ تٛغّٛورٜ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","نغَمْ اٛ وِعِي ندٜرْ ٻٜرْندٜ مَاکٛ، ‏«‏کٛو تٛغّٛورٜ مَاکٛ مٜىٰمُمِ تَنْ، مِ يَمْطِتَيْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","طٛنْ اٜ طٛنْ پِيپَمْ طَمْ دَرِي، اٛ نَنِ ندٜرْ ٻَنْدُ مَاکٛ طُمْ يَمْطِتِنِيمٛ دَغَ ݧَوُ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","طٛنْ اٜ طٛنْ يٜىٰسُ فَامِ بَوْطٜ مبُرْتَکٜ دَغَ ندٜرْ مُوطُمْ؞ اٛ وَيْلِتِي ندٜرْ يِمْٻٜ، اٛ وِعِ، ‏«‏مٛيٜ مٜىٰمِ تٛغّٛورٜ اَمْ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","سٜيْ تٛکُّٻٜمٛ مبِعِمٛ، ‏«‏اَ يِعَ يِمْٻٜ طُطْٻٜ اٜ ٻِطُّمَا، اَمَّا اَ پَمَ مٛيٜ مٜىٰمُمَا؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","اَمَّا يٜىٰسُ وَطِ کَ رَارُکِ ندٜرْ يِمْٻٜ ٻٜنْ نغَمْ يِعَ مٛيٜ مٜىٰمِمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","دٜبّٛ اٛنْ بٛو ندٜ اٜ مٛ اَنْدِ کٛ حٜٻِ ٻَنْدُ مَاکٛ، اٛ وَرِ ندٜرْ کُلٛلْ اٜ مٛ دِوْنَ، اٛ دِشِّي يٜىٰسٛ يٜىٰسُ، اٛ وِعِمٛ غٛونغَ دٛوْ کٛو طُمٜ کٛ وَطِ؞ ");
INSERT INTO fuv_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","سٜيْ يٜىٰسُ وِعِمٛ، ‏«‏بَنْدِرَاوٛ، حٛولَارٜ مَاطَ يَمْطِتِنِيمَ؞ نجِڤّٛطَا جَمْ، اَ حٛيِي دَغَ ݧَوُ مَاطَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","يٜىٰسُ اٜ مٜتَ، سٜيْ وٛٻّٜ دَغَ وُرٛ جَايِرُسْ اَرْدِيطٛ سُودُ دٛعَارٜ اٛنْ نغَرِ، ٻٜ مبِعِمٛ، ‏«‏ٻِطّٛ مَاطَ مَايِي؞ نغَمْ طُمٜ نغَنَّتَا مٛودِبّٛ کَدِنْ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","اَمَّا يٜىٰسُ وَنَّايِ اٜ کٛ ٻٜ مبِعِ، اٛ وِعِ اَرْدِيطٛ سُودُ دٛعَارٜ اٛنْ، ‏«‏تَاع حُلُ، حٛولَيَمْ تَنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","اٛ اَلَايِ کٛو مٛيٜ يَادِ اٜ مَاکٛ سٜيْ بِيتُرُسْ، اٜ يَاکُبُ، اٜ يَحَيَ مِݧِرَاوٛ يَاکُبُ؞ ");
INSERT INTO fuv_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","ندٜ ٻٜ نجٛتِّي وُرٛ جَايِرُسْ، يٜىٰسُ يِعِ يِمْٻٜ ندٜرْ وَنَّارٜ، وٛٻّٜ اٜ مبٛيَ، وٛٻّٜ اٜ نغُلَّ اٜ سٜمْبٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","اٛ نَتِّ، اٛ وِعِ، ‏«‏نغَمْ طُمٜ نَتُّطٛنْ وَنَّارٜ ندٜعٜ اٛنْ مبٛيَ؟ سُرْبَاجٛ اٛنْ اٛ مَايَايِ، اَمَّا اٛ طَانِ تَنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","سٜيْ ٻٜ نجَلِمٛ؞ اٛ وُرْتِنِٻٜ ٻٜ فُو يَاسِ، اٛ حٛشِّ ݧَاکٛ سُرْبَاجٛ اٛنْ اٜ مَدُوجٛ مَاکٛ اٜ تٛکُّٻٜمٛ ٻٜ اٛ وٛنْدِ، ٻٜ نَتِّ تٛ سُرْبَاجٛ اٛنْ وٛنِ؞ ");
INSERT INTO fuv_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","يٜىٰسُ جٛغِي جُنْغٛ سُرْبَاجٛ اٛنْ وِعِ، ‏«‏تَلِيتَ، کُمِ،»‏ وَاتٛ، ‏«‏سُرْبَاجٛ، اُمَّ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","طٛنْ اٜ طٛنْ سُرْبَاجٛ اٛنْ اُمِّي فُطِّ يَادُ؞ اٜ مٛ وٛودِ دُوٻِ سَڤّٛ اٜ طِطِ؞ فِي طُمْ حَيْطِنِٻٜ نَاع سٜطَّ؞ ");
INSERT INTO fuv_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","يٜىٰسُ وَغِّنِٻٜ وِعِ تٛع ٻٜ نجَٻَ ٻٜ مبِعَکَ کٛو مٛيٜ؞ ندٜنْ اٛ وِعِٻٜ، ‏«‏کٛکّٜىٰمٛ غٛطُّمْ اٛ ݧَامَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","سٜيْ يٜىٰسُ اَلِ وِغٜىٰرٜ ندٜنْ سٛعِّي غَرِيرِ تٛ مَوْنِ، تٛکُّٻٜمٛ نجَادِ اٜ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","ندٜ ݧَلْندٜ سِوْتَارٜ وَرِ، اٛ فُطِّ اٜکِّتِنْکِ ندٜرْ سُودُ دٛعَارٜ؞ يِمْٻٜ طُطْٻٜ نَنْٻٜ کٛ اٛ وِعِ، ٻٜ کَيْطِنِ اٜ اٜکِّتِنٛلْ مَاکٛ؞ اٜ ٻٜ مبِعَ، ‏«‏تٛيٜ نٜطّٛ اٛعٛ حٜٻِ فُو فِي طُعُمْ؟ تٛيٜ اٛ حٜٻِ اِرِ فَامُ طُعُمْ؟ تٛيٜ اٛ حٜٻِ بَوْطٜ وَطُکِ اِرِ کُوطٜ کَيْطِنِيطٜ طٜعٜ؟ ");
INSERT INTO fuv_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","نَاع کَنْکٛ وٛنِ اٛنْ طٛنْ شٜحٛووٛ، ٻِطّٛ مَرْيَامَ، مَوْنِرَاوٛ يَاکُبُ، اٜ يُسُفُ، اٜ يَحُودَ، اٜ سِيمَنْ؟ ندٜنْ مِݧِرَاٻٜ مَاکٛ رٜوْٻٜ نَاع اٜنْ نغٛنْدِ اٜ مَٻّٜ طٛعٛ؟»‏ سٜيْ ٻٜ نجَوَنِمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","يٜىٰسُ وِعِٻٜ، ‏«‏کٛو تٛيٜ يِمْٻٜ اٜ کٛکَّ اَنَّبِيجٛ مَنْغُ، اَمَّا يِمْٻٜ غَرِيرِ مَاکٛ، اٜ بَنْدِرَاٻٜ مَاکٛ، اٜ يِمْٻٜ وُرٛ مَاکٛ، ٻٜ کٛکَّتَامٛ مَنْغُ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","يٜىٰسُ وَاوَايِ وَطُکِ غٛطُّمْ کَيْطِنِيطُمْ تٛنْ، سٜيْ نِ يِمْٻٜ سٜطَّ ٻٜ نجَمْطَا اٛ يٛوِ جُوطٜ مَاکٛ دٛوْ مَٻّٜ اٛ يَمْطِتِنِٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","اٛ حَيْطِنِ نغَمْ ٻٜ کٛولَاکِمٛ؞ يٜىٰسُ اٜ يِيلٛو اٜ اٜکِّتِنَ ندٜرْ نغَرِحٛيْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","اٛ نٛدِّ تٛکُّٻٜمٛ سَڤّٛ اٜ طِطٛ، اٛ لِلِٻٜ طِطٛ‑طِطٛ، اٛ حٛکِّٻٜ لَامُ دٛوْ غِنِّ؞ ");
INSERT INTO fuv_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","اٛ وِعِٻٜ تٛع ٻٜ کٛشَّ غٛطُّمْ نغَمْ يَادُ، کٛو ݧَمْندُ، کٛو جَکَارٜ، کٛو شٜىٰدٜ اٜ جِيبَ؞ سَوْرُ تَنْ ٻٜ نجٛغٛتٛو؞ ");
INSERT INTO fuv_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","ٻٜ نغَتَّ ڤَطٜ، اَمَّا تٛع ٻٜ ٻٛرْنٛو تٛغّٛوجٜ طِطِ؞ ");
INSERT INTO fuv_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","اٛ بٛو وِعِٻٜ، ‏«‏فُو وُرٛ نغٛ نجِڤِّيطٛنْ، نجٛوطٜىٰ ندٜرْ مَاغٛ نَا اٛنْ اَلِي غَرِيرِ ندِنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","تٛ طُمْ جَٻَّاکِعٛنْ اٜ وِغٜىٰرٜ، کٛو طُمْ وَݧِي حٜتِّندَنَاکِعٛنْ، ڤِطّٜىٰ سٛلَّارٜ کٛيْطٜ مٛوطٛنْ شَرٜلْ کٛ اَلٛتٛنْ وِغٜىٰرٜ ندٜنْ؞ کَنْجُمْ حٛلَّتَ ٻٜ نغَطِي حَکّٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","سٜيْ ٻٜ ندِلِّ اٜ ٻٜ نغَعَجِنَ وِعُکِ يِمْٻٜ تُوبَ؞ ");
INSERT INTO fuv_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","ٻٜ مبُرْتِنَنِ يِمْٻٜ طُطْٻٜ غِنِّ، طُطْٻٜ ٻٜ نجَمْطَا بٛو ٻٜ مٛيْتَنِٻٜ نٜبَّمْ ٻٜ نجَمْطِتِنِٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","حِرُدُسْ لَامِيطٛ نَنِ حَبَرُ فِي طُعُمْ، نغَمْ اِنْدٜ يٜىٰسُ اَنْدَامَ کٛو تٛيٜ؞ وٛٻّٜ اٜ مبِعَ يَحَيَ غَطٛووٛ بَڤْتِسْمَ اُمِّنَا دَغَ مَيْدٜ، کَنْجُمْ وَطِ اٜ مٛ وٛودِ بَوْطٜ وَطُکِ کُوطٜ کَيْطِنِيطٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","وٛٻّٜ بٛو مبِعِ، ‏«‏طُمْ اَنَّبِ اِلِيَ؞»‏ ندٜنْ وٛٻّٜ مبِعِ، ‏«‏اٛ اَنَّبِيجٛ بٛ اَنَّبٛعٜنْ ندٜنّٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","اَمَّا ندٜ حِرُدُسْ نَنِ نٛنْ، اٛ وِعِ، ‏«‏يَحَيَ مٛ اِتَّنْمِ حٛورٜ، کَنْکٛ اُمِّنَا دَغَ مَيْدٜ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","نغَمْ ندٜنّٛ حِرُدُسْ اٜ حٛورٜ مُوطُمْ وَطِي طُمْ نَنْغِي يَحَيَ، طُمْ حَٻِّمٛ، طُمْ سُرِمٛ ندٜرْ سُودُ شُرَلْ؞ اٛ وَطُ نٛنْ نغَمْ حِرُودِيَ دٜبّٛ مَوْنِرَاوٛ مَاکٛ فِلِبُسْ مٛ اٛ تٜعِ؞ ");
INSERT INTO fuv_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","نغَمْ يَحَيَ وَطِي کَ وِيکِ حِرُدُسْ، ‏«‏طُمْ حَانَايِ تٜعَا دٜبّٛ مَوْنِرَاوٛ مَاطَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","حِرُودِيَ بٛو ندٜرْ ٻٜرْندٜ مَاکٛ اٜ مٛ جٛغِتِي يَحَيَ اٜ مٛ يِطِ وَرْکِمٛ؞ اَمَّا اٛ وَاوَايِ وَرْکِمٛ، ");
INSERT INTO fuv_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","نغَمْ حِرُدُسْ اٜ حُلَ يَحَيَ اٜ سُرَنَمٛ، ندٜ اٜ مٛ اَنْدِ کَنْکٛ اٛ اَادِلِيجٛ اٛ شٜنِيطٛ؞ فُو شَرٜلْ نغٜلْ حِرُدُسْ نَنِ حَالَ يَحَيَ، اٜ مٛ نَتَّ وَنَّارٜ؞ اَمَّا فُو اٜ نٛنْ اٜ مٛ يِطِ حٜتِّندَنَاکِمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","اَمَّا حِرُودِيَ حٜٻِ لَاوٛلْ نٛ وَرِرْتَ يَحَيَ؞ ݧَلْندٜ حُمْتٛ سِفْتٛرْکِ دَݧْنغٛلْ حِرُدُسْ، حِرُدُسْ سِرْيِي حُمْتٛ نغَمْ کُوٛوٻٜ مَوْٻٜ ندٜرْ لَامُ مَاکٛ، اٜ مَوْٻٜ اَرْدِيٻٜ سٛوجِعٜنْ، اٜ مَوْٻٜ لٜيْدِ غَلِيلِ؞ ");
INSERT INTO fuv_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","ندٜ ٻِطّٛ حِرُودِيَ سُرْبَاجٛ نَتِّ وَمِ، اٛ وٜلْنَنِ حِرُدُسْ ٻٜرْندٜ اٜ حٛٻّٜ مَاکٛ؞ سٜيْ حِرُدُسْ وِعِمٛ، ‏«‏تٛرَيَمْ فُو کٛ نغِطَّا، مِ حٛکّٜتٜطُمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","حِرُدُسْ حُنَنِيمٛ وِعِ، ‏«‏فُو کٛ تٛرِطَايَمْ مِ حٛکّٜتٜطُمْ حَا کٛ حٜوْتَتَ سٜنْدٜرٜ لَامُ اَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","سٜيْ سُرْبَاجٛ اٛنْ وُرْتِي وِعِ مَدُوجٛ مُوطُمْ، ‏«‏کٛ حَانِ مِ تٛرٛو؟»‏ مَدُوجٛ اٛنْ وِعِمٛ، ‏«‏تٛرَمٛ حٛورٜ يَحَيَ غَطٛووٛ بَڤْتِسْمَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","طٛنْ اٜ طٛنْ سُرْبَاجٛ اٛنْ ندٜرْ يَوْطَارٜ اٛ سٛعِّي تٛ لَامِيطٛ اٛنْ اٛ وِعِمٛ، ‏«‏اٜ مِ يِطِ جٛونِ‑جٛونِ کٛکَّايَمْ حٛورٜ يَحَيَ غَطٛووٛ بَڤْتِسْمَ ندٜرْ لٜعَلْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","حِرُدُسْ لَامِيطٛ وَنِّي نَاع سٜطَّ، اَمَّا ندٜ اٛ يَادَکٜ اٛ حُنَنَکٜمٛ يٜىٰسٛ حٛٻّٜ، اٛ يِطَا اٛ حَطَمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","طٛنْ اٜ طٛنْ اٛ وَطِ سٛوجِيجٛ اٛ يَحَ اٛ وَدّٛيَ حٛورٜ يَحَيَ؞ سٛوجِيجٛ اٛنْ يَحِ اِتَّنِ يَحَيَ حٛورٜ ندٜرْ سُودُ شُرَلْ، ");
INSERT INTO fuv_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","اٛ وَدّٛيِ حٛورٜ ندٜنْ ندٜرْ لٜعَلْ، اٛ حٛکِّندٜ سُرْبَاجٛ اٛنْ؞ سُرْبَاجٛ اٛنْ بٛو حٛکِّندٜ مَدُوجٛ مُوطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","ندٜ تٛکُّٻٜ يَحَيَ نَنِ نٛنْ ٻٜ نغَرِ ٻٜ کٛشِّ ٻَنْدُ مَاکٛ ٻٜ ڤُکِّنٛيِندُ ندٜرْ يٜنَاندٜ غَسَاندٜ ندٜرْ حَيْرٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","لِلَاٻٜ ٻٜ يٜىٰسُ لِلُنٛو نغَرْتٛيِي تٛ مَاکٛ، ٻٜ مبِعِمٛ کٛو طُمٜ کٛ ٻٜ نغَطِ اٜ کٛ ٻٜ اٜکِّتِنِ؞ ");
INSERT INTO fuv_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","اٛ وِعِٻٜ، ‏«‏نغَرٜىٰ، نجَحٜنْ تٛ وِغٜىٰرٜ غٜوْتُندٜ کٜٻٛنْ شِوْتٛوطٛنْ سٜطَّ؞»‏ اٛ وِعِي نٛنْ نغَمْ يِمْٻٜ طُطْٻٜ اٜ نغَرَ اٜ شٛعّٛو حَا حٜوْتِ ٻٜ کٜٻَايِ کٛو شَرٜلْ ٻٜ ݧَامِ ݧَمْندُ؞ ");
INSERT INTO fuv_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","سٜيْ ٻٜ نَتِّ کٛمِوَلْ ٻٜ ندِلِّ تٛ وِغٜىٰرٜ ندٜرْ لَدّٜ کَمْٻٜ تَنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","اَمَّا شَرٜلْ نغٜلْ ٻٜ ندِلَّتَ يِمْٻٜ طُطْٻٜ نغِعِٻٜ اَندِتِٻٜ؞ يِمْٻٜ ٻٜنْ مبُرْتٛيِي دَغَ غَرِيجٜ طُطّٜ ٻٜ ندٛغِّ اٜ کٛيْطٜ ٻٜ اَرْتِٻٜ يَاکِ تٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","اٜ جِڤَّاکِ يٜىٰسُ دَغَ ندٜرْ کٛمِوَلْ نغَلْ اٛ يِعِ يِمْٻٜ طُطْٻٜ اٜ کَوْرِتِ، سٜيْ اٛ نَنِ جُرُمْطُمْ مَٻّٜ، نغَمْ اٜ ٻٜ طٛنْ بٛ بَالِ طِ نغَلَا غَيْنَاکٛ؞ سٜيْ اٛ فُطِّ اٜکِّتِنْکِٻٜ فِي طُطُّمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","ندٜ اَلَاسَرَ وَطِ، سٜيْ تٛکُّٻٜمٛ نغَرِ تٛ مَاکٛ مبِعِمٛ، ‏«‏طٛعٛ طُمْ لَدّٜ، طٛنْمَا نَانغٜ حِيرِي؞ ");
INSERT INTO fuv_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","وِعُ يِمْٻٜ ٻٜعٜ ندِلَّ نغَمْ ٻٜ نجَحَ غُرٜ غٛنْطٜ حَادٜ اٜ نغَرِحٛيْ نغٛنْکٛيْ حَادٜ ٻٜ شٛودَنَ کٛعٜ مَٻّٜ کٛ ٻٜ ݧَامَتَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","اَمَّا يٜىٰسُ وِعِٻٜ، ‏«‏اٛنٛنْ کٛکّٜىٰٻٜ کٛ ٻٜ ݧَامَتَ؞»‏ سٜيْ ٻٜ مبِعِمٛ، ‏«‏اَ يِطِ مِنْ نجَحَ مِنْ شٛودٛنٛيَٻٜ ݧَمْندُ کٜوْتُندُ شٜىٰدٜ طٜ کُوٛووٛ يٛٻٜتٜىٰ بَلْطٜ 200 مِنْ کٛکَّٻٜ ٻٜ ݧَامَ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","اٛ وِعِٻٜ، ‏«‏بُرٛودِ نٛيٜ نغٛودُطٛنْ؟ نجَحٜىٰ ندَارٛنْ؞»‏ ندٜ ٻٜ ندَارِ، ٻٜ مبِعِ، ‏«‏بُرٛودِ جٛوِ اٜ لِپِّ طِطِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","سٜيْ يٜىٰسُ وِعِٻٜ ٻٜ مبِعَ يِمْٻٜ نجٛوطٛو مٛٻْطٜ‑مٛٻْطٜ دٛوْ حُطٛ حٜشّٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","سٜيْ ٻٜ نجٛوطِي مٛٻْطٜ 100‏‑100، وٛٻّٜ نجٛوطِي مٛٻْطٜ 50‏‑50؞ ");
INSERT INTO fuv_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","اٛ حٛشِّ بُرٛودِ جٛوِ طُمْ اٜ لِپِّ طِطِ طِنْ، اٛ رَارِ دٛوْ، اٛ يٜتِّ اَللَّه، اٛ سٜنْدِ بُرٛودِ طُمْ اٛ حٛکِّ تٛکُّٻٜمٛ نغٜىٰدَنَ يِمْٻٜ فُو؞ نٛنْ اٛ وَادِ اٜ لِپِّ طِطِ طِنْ مَا؞ ");
INSERT INTO fuv_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","ٻٜ فُو ٻٜ ݧَامِ ٻٜ کَارِ؞ ");
INSERT INTO fuv_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","تٛکُّٻٜمٛ مٛٻْتِ بُرٛودِ کٛرِيطُمْ اٜ لِپِّ کٛرِيطِ کٛ وَطِ کٛنْدٛوجٜ سَڤّٛ اٜ طِطِ؞ ");
INSERT INTO fuv_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","ݧَامُٻٜ بُرٛودِ طُمْ وٛرْٻٜ تَنْ ٻَدَکٜ 5,000؞ ");
INSERT INTO fuv_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","طٛنْ اٜ طٛنْ يٜىٰسُ وَطِ تٛکُّٻٜمٛ نَتَّ کٛمِوَلْ ٻٜ اَرْتَمٛ حُولُکِ يَاکِ بٜتَسَيْدَ، کَنْکٛ بٛو اٛ جَٻِّتٛتٛ کَوْرُتُٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","غَطَ اٛ جَٻِّتَکٜٻٜ اٛ پٜنْتِ وٛنْدٜ حٛشّٜىٰرٜ نغَمْ اٛ وَطَ دٛعَارٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","ندٜ فُتُرٛ وَطِ، کٛمِوَلْ نغَلْ اٜ شَکَ مبٜىٰلَ، يٜىٰسُ بٛو اٜ دٛوْ حٛشّٜىٰرٜ کَنُمْ تَنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","اٛ يِعِ تٛکُّٻٜمٛ اٜ ڤِيدَ اٜ کٛمِوَلْ، نغَمْ حٜنْدُ اٜ حَطَٻٜ يَادُ؞ فَجِرِ اٜ مٛ يَحَ تٛ مَٻّٜ، اٜ مٛ يَحَ دٛوْ ندِيَمْ مبٜىٰلَ نغَنْ؞ اٜ مٛ يِطِ اٛ پَٻّٛوٻٜ، ");
INSERT INTO fuv_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","اَمَّا ندٜ ٻٜ نغِعِمٛ اٜ مٛ يَحَ دٛوْ ندِيَمْ، ٻٜ کَمِّ طُمْ غِنّٛلْ، سٜيْ ٻٜ نغُلِّ، ");
INSERT INTO fuv_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","نغَمْ ٻٜ فُو ٻٜ نغِعِيمٛ ٻٜ کُلْتٛرِي؞ اَمَّا طٛنْ اٜ طٛنْ اٛ مٜتَنِٻٜ، اٛ وِعِ، ‏«‏ڤُکِّنٜىٰ ٻٜرْطٜ مٛوطٛنْ، طُمْ مِنْ؞ تٛع اٛنْ کُلُ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","ندٜنْ اٛ نَتِّ کٛمِوَلْ نغَلْ تٛ مَٻّٜ، سٜيْ حٜنْدُ ندُنْ دَرِي؞ ٻٜ کَيْطِنِ نَاع سٜطَّ، ");
INSERT INTO fuv_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","نغَمْ ٻٜ ڤَامَايِ مَعَنَ ݧَمْنُکِ يِمْٻٜ 5,000 کِ اٛ وَطِ، نغَمْ ٻٜرْطٜ مَٻّٜ ڤَامَايِ مَعَنَ مَاجُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","ندٜ ٻٜ کُولِ فٛنْغٛ مبٜىٰلَ نغَنْ، ٻٜ نجٛتِّي لٜيْدِ جَنِسَرَتْ ٻٜ کَٻِّ کٛمِوَلْ نغَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","ندٜ ٻٜ مبُرْتِي ندٜرْ مَاغَلْ، طٛنْ اٜ طٛنْ يِمْٻٜ اَنْدِتِ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","يِمْٻٜ ٻٜنْ ندٛغِّ ٻٜ نجَحِ کٛو تٛيٜ ندٜرْ لٜيْدِ ندِنْ، اٜ ٻٜ نغَدّٛيَ ݧَوْٻٜ دٛوْ مبٜعِّتَارِ تٛ يٜىٰسُ کٛو تٛيٜ تٛ ٻٜ نَنِ اٛ وٛنِ؞ ");
INSERT INTO fuv_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","کٛو تٛيٜ تٛ اٛ يَحِ، کٛو ندٜرْ نغَرِحٛيْ، کٛو ندٜرْ غَرِيجٜ مَوْطٜ، کٛو ندٜرْ غُرٜ لَدّٜ، يِمْٻٜ اٜ ڤُکِّنَ ݧَوْٻٜ ندٜرْ لُومٛ، ٻٜ تٛرٛومٛ ݧَوْٻٜ ٻٜنْ مٜىٰمَ کٛو شِلْمبِ تٛغّٛورٜ مَاکٛ؞ فُو مٜىٰمُٻٜطِ نجَمْطِتِ؞ ");
INSERT INTO fuv_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","فَارِسَنْکٛعٜنْ اٜ وٛٻّٜ ندٜرْ مٛودِٻّٜ اَتَّوْرَ غَرٛيْٻٜ دَغَ اُرُشَلِيمَ ٻٜ کَوْرِتِ تٛ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","سٜيْ ٻٜ نغِعِ وٛٻّٜ تٛکُّٻٜ يٜىٰسُ اٜ ٻٜ ݧَامَ ݧَمْندُ ٻٜ لٛوتَايِ جُوطٜ مَٻّٜ نٛ دِينَ يَحُودَنْکٛعٜنْ وِعِ؞ ");
INSERT INTO fuv_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","فَارِسَنْکٛعٜنْ اٜ فُو يَحُودَنْکٛعٜنْ ٻٜ ݧَامَتَا ݧَمْندُ نَا ٻٜ لٛوتِي جُوطٜ مَٻّٜ نٛ دِينَ مَٻّٜ وِعِ، اٜ ٻٜ تٛکِّ ندٛنُ مَامَعٜنْ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","تٛ ٻٜ نغَرْتٛيِي دَغَ لُومٛ، ٻٜ ݧَامَتَا ݧَمْندُ نَا ٻٜ لٛوتَکٜ نٛ دِينَ مَٻّٜ وِعِ؞ طٛنْمَا اٜ ٻٜ تٛکَّ ندٛنُ طُطُّمْ طُمْ ٻٜ ندٛنِ، بٛ لٛوتُکِ جَرْدُطٜ، اٜ غٛجِيجٜ، اٜ ڤَالِ غَطِرَاطِ نجَمْندِ مبٛطٜىٰرِ؞ ");
INSERT INTO fuv_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","سٜيْ فَارِسَنْکٛعٜنْ اٜ مٛودِٻّٜ اَتَّوْرَ ٻٜنْ پَمِ يٜىٰسُ ٻٜ مبِعِ، ‏«‏نغَمْ طُمٜ تٛکُّٻٜمَ تٛکَّتَا ندٛنُ مَامَعٜنْ مٜىٰطٜنْ، اَمَّا اٜ ٻٜ ݧَامِرَ ݧَمْندُ جُوطٜ طٜ لَاٻَا؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","سٜيْ يٜىٰسُ نٛوتِي وِعِ، ‏«‏اَنَّبِ اِشَايَ وِعِي غٛونغَ ندٜ وَطِ اَنَّبَاکُ دٛوْ مٛوطٛنْ، اٛنٛنْ مُنَافُکِعٜنْ، نٛ طُمْ وِنْدِرَا، اَللَّه وِعِي، ‏‹‏ٻٜنْ طٛنْ يِمْٻٜ اٜ حٛنْدُکٛ تَنْ ٻٜ مَوْنِنْتَيَمْ، اَمَّا ٻٜرْطٜ مَٻّٜ اٜ نغٛطِّتِييَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","اٜ مٜىٰرٜ ٻٜ مَوْنِنْتَيَمْ؛ اٜ ٻٜ اٜکِّتِنَ دٛوکَ يِمْٻٜ بٛ تٛ اَمْ طُمْ پِوٛيِ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","‏«‏اٛنْ اَلِي تٛکُّکِ کٛ اَللَّه وِعِ طُمْ وَطَ، اٛنْ نجٛغَکٜ ندٛنُوجِ يِمْٻٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","سٜيْ اٛ وِعِٻٜ، ‏«‏اٛنْ ݧُمَ اٛنْ نغَطِي فِي بٛطُّمْ ندٜ نغَݧُطٛنْ کٛ اَللَّه وِعِ نغَمْ تٛکّٛنْ ندٛنُ مٛوطٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","نغَمْ مُوسَ وِعِي، ‏‹‏حٛکُّ ݧَاکٛ مَاطَ اٜ مَدُوجٛ مَاطَ مَنْغُ،›‏ ندٜنْ، ‏‹‏کٛو مٛيٜ حُطِ ݧَاکٛ مُوطُمْ کٛو مَدُوجٛ مُوطُمْ دٛولٜ وَرٜىٰ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","اَمَّا اٛنْ مبِعَ تٛ نٜطّٛ وِعِي ݧَاکٛ مُوطُمْ کٛو مَدُوجٛ مُوطُمْ، ‏‹‏فُو کٛ کٛکَّيْنٛمَامِ، طُمْ کٛرْبَنْ، وَاتٛ مِ حٛکِّيطُمْ اَللَّه،›‏ ");
INSERT INTO fuv_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ندٜ مبِيطٛنْ نٛنْ اٛنْ کَطِي يِمْٻٜ مبَلَّ دَݧٛوٻٜ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","نٛنْ نغَرْتِرْطٛنْ وٛلْدٜ اَللَّه مٜىٰرٜ لَاوٛلْ ندٛنُ طُمْ اٜکِّتِنْطٛنْ؞ کَدِنْ اٛنْ نغَطَ فِي طُطُّمْ اِرِ طُعُمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","سٜيْ يٜىٰسُ فُطِّتِ نٛدِّ يِمْٻٜ حَوْرُتُٻٜ، اٛ وِعِ، ‏«‏کٜتِّندٜىٰ، اٛنْ فُو، ڤَامٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK7_15‏","071_7_15‏","MRK","7","15‏","16","وَلَا غٛطُّمْ يَاسِ ٻَنْدُ نٜطّٛ نَتَّيْطُمْ ندٜرْ مَاکٛ وَرْتِرَمٛ مٛ لَاٻَا يٜىٰسٛ اَللَّه؞ اَمَّا کٛ وُرْتٛيْتٛو دَغَ ندٜرْ ٻٜرْندٜ نٜطّٛ کَلُّطُمْ کَنْجُمْ وَرْتِرْتَمٛ مٛ لَاٻَا يٜىٰسٛ اَللَّه؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","ندٜ اٛ سٜنْدِرِ اٜ يِمْٻٜ فُو، اٛ نَتِّ وُرٛ، تٛکُّٻٜمٛ پَمِمٛ مَعَنَ اٜکِّتِنٛلْ نغٛعٛلْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","اٛ نٛوتِي اٛ وِعِ، ‏«‏اٛنٛنْ مَا اٛنْ ڤَامَايِ مَعَنَ طُعُمْ؟ اٛنْ اَنْدَا وَلَا کٛ نَتَّتَ نٜطّٛ دَغَ يَاسِ وَرْتِرَمٛ مٛ لَاٻَا؟ ");
INSERT INTO fuv_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","نغَمْ نَاع ندٜرْ ٻٜرْندٜ طُمْ نَتَّتَ، اَمَّا ندٜرْ رٜىٰدُ، ندٜنْ طُمْ وُرْتٛ ٻَنْدُ؞»‏ ﴿ندٜ يٜىٰسُ وِعِ طُعُمْ، اٛ حٛلِّي کٛو ندُيٜ ݧَمْندُ ندُ لَمْندُ؞﴾ ");
INSERT INTO fuv_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","اٛ ٻٜيْدِ وِعُکِ، ‏«‏کٛ وُرْتٛتٛو دَغَ ندٜرْ ٻٜرْندٜ نٜطّٛ، کَنْجُمْ وَطَتَ نٜطّٛ وَرْتَ مٛ لَاٻَا يٜىٰسٛ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","نغَمْ دَغَ ندٜرْ ٻٜرْندٜ نٜطّٛ ݧُمٛ کَلُّنغٛ وُرْتٛيْتٛو، اٜ وَطُکِ نجٜىٰنُ حَکُّندٜ يِمْٻٜ ٻٜ نغَلَا تٜىٰغَلْ، اٜ نغُيْکَ، اٜ وَرْحٛورٜ، اٜ نجٜىٰنُ، ");
INSERT INTO fuv_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","اٜ سُونٛ فِي دُونِيَارُ، اٜ حَلّٜىٰندٜ، اٜ پٛيْرٜ کَلُّندٜ، اٜ فُو کُوطٜ کَلُّطٜ طٜ ٻٜرْطٜ مَٻّٜ نغِطِ، اٜ لَوْلِيرُ، اٜ وٛنُّکِ اِنْدٜ نٜطّٛ، اٜ مَوْنِنْکِ حٛورٜ، اٜ وَݧُکِ وَطُکِ کٛ وٛوطِ؞ ");
INSERT INTO fuv_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","فُو طٜعٜ کُوطٜ کَلُّطٜ دَغَ ندٜرْ ٻٜرْندٜ طٜ مبُرْتٛيْتٛو طٜ نغَرْتِرَ نٜطّٛ مٛ لَاٻَا يٜىٰسٛ اَللَّه؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","دَغَ طٛنْ يٜىٰسُ دِلِّ يَحِ وِغٜىٰرٜ حَادٜ غَرِيجٜ تَايَ اٜ سِدٛنْ؞ اٛ نَتِّ وٛنْغٛ وُرٛ، اٛ يِطَا کٛو مٛيٜ اَنْدَ اٜ مٛ طٛنْ طُمْ؞ اَمَّا فُو اٜ نٛنْ اٛ وَاوَايِ سُوطَاکِ يِمْٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","طٛنْ اٜ طٛنْ غٛطّٛ دٜبّٛ غٛودُطٛ ٻِطّٛ سُرْبَاجٛ ڤَمَرٛ غٛودُطٛ غِنّٛلْ نَنِ حَبَرُ يٜىٰسُ؞ سٜيْ اٛ وَرِ اٛ دِشِّي يٜىٰسٛ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","دٜبّٛ اٛنْ بٛو اٛ حٜلٜنَنْکٜىٰجٛ تٛ فِنِيکِيَ ندٜرْ لٜيْدِ سِيرِيَ اٛ دَݧَا؞ اٛ تٛرِي يٜىٰسُ وُرْتِنَنَ ٻِطّٛ مَاکٛ غِنّٛلْ نغٛلْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","سٜيْ يٜىٰسُ وِعِمٛ، ‏«‏اَرَنْدٜ اَلْ طُمْ ݧَمْنَ ٻِکّٛيْ، نغَمْ طُمْ حَانَايِ طُمْ حٛشَّ ݧَمْندُ ٻِکّٛيْ طُمْ حُبَنٛوندُ کُتِحٛيْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","اَمَّا دٜبّٛ اٛنْ وِعِمٛ، ‏«‏اٜىٰ، مٛودِبّٛ، اَمَّا حَا کُتِحٛيْ نغٛنْکٛيْ لٜيْ تٜىٰبُرْ اٜ ݧَامَ حٛرَانٛ سُکَاٻٜ ٻٜنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","سٜيْ يٜىٰسُ وِعِمٛ، ‏«‏نغَمْ اَ وِعِي نٛنْ، حٛوتُ، غِنّٛلْ نغٛلْ وُرْتَکٜ ٻِطّٛ مَاطَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","سٜيْ دٜبّٛ اٛنْ سٛعِّي وُرٛ تَوِ ٻِطّٛ مُوطُمْ اٜ فُکِّي دٛوْ لٜىٰسٛ، غِنّٛلْ نغٛلْ بٛو وُرْتَکٜ دَغَ ندٜرْ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","سٜيْ يٜىٰسُ اَلِ وِغٜىٰرٜ غٛنْدٜ حَادٜ غَرِيرِ تَايَ، اٛ تٛکِّرِ غَرِيرِ سِدٛنْ، اٛ رٜغٛيِي مبٜىٰلَ غَلِيلِ، اٛ نَتِّ لٜيْدِ دِکَڤٛلِسْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","تٛنْ وٛٻّٜ يِمْٻٜ نغَدَّنِمٛ غٛطّٛ ڤَحٛ مٛ مٜتٛ مُوطُمْ وُرْتَتَاکٛ بٛطُّمْ؞ ٻٜ تٛرِي يٜىٰسُ يٛوَ جُوطٜ مُوطُمْ دٛوْ مَاکٛ يَمْطِتِنَمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","اٜ وٛودِ يِمْٻٜ طُطْٻٜ طٛنْ، سٜيْ يٜىٰسُ حَکِّتِي کَنْکٛ اٜ ڤَحٛ اٛنْ، اٛ وَطِ کٛولِ مَاکٛ ندٜرْ نٛڤِّ ڤَحٛ اٛنْ؞ اٛ تُتِّ جٛودٜ اٛ مٜىٰمِ طٜمْنغَلْ ڤَحٛ اٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","ندٜنْ يٜىٰسُ رَارِ دٛوْ فٛوفِ فٛوفَانغٛ جُوتُنغٛ وِعِمٛ، ‏«‏اِفَتَ،»‏ وَاتٛ، ‏«‏مَٻِّتَ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","طٛنْ اٜ طٛنْ نٛڤِّ نٜطّٛ اٛنْ مَٻِّتِي، طٜمْنغَلْ مَاکٛ يٛوفِي، اٛ فُطِّ مٜتُکِ بٛطُّمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","سٜيْ يٜىٰسُ وِعِٻٜ تٛع ٻٜ مبِعَکَ غٛطّٛ؞ اَمَّا فُو شَرٜلْ نغٜلْ اٛ حَطِٻٜ وِعُکِکَ، سٜيْ ٻٜ ٻٜيْدَ وِعُکِکَ کٛو تٛيٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","يِمْٻٜ کَيْطِنِ نَاع سٜطَّ مبِعِ، ‏«‏اٛ وَطِي کٛو طُمٜ بٛطُّمْ، حَا مَا اٜ مٛ وَطَ ڤَحُٻٜ نَنَ، اٜ مٛ وَطَ ٻٜ مبَاوَتَا مٜتُکِ مٜتَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","ندٜرْ طٜنْ طٛنْ بَلْطٜ يِمْٻٜ طُطْٻٜ فُطِّتِ کَوْرِ تٛ يٜىٰسُ؞ ندٜ ٻٜ نغَلَا کٛ ٻٜ ݧَامَتَ، سٜيْ يٜىٰسُ نٛدِّ تٛکُّٻٜمٛ، وِعِٻٜ، ");
INSERT INTO fuv_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","‏«‏اٜ مِ نَنَ جُرُمْطُمْ يِمْٻٜ ٻٜعٜ نغَمْ حَنْدٜ بَلْطٜ مَٻّٜ تَتِ اٜ ٻٜ نغٛنْدِ اٜ اَمْ، اَمَّا ٻٜ نغَلَا کٛ ٻٜ ݧَامَتَ؞ ");
INSERT INTO fuv_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","تٛ مِ وِعِيٻٜ ٻٜ کٛوتِدَ اٜ وٜىٰلٛ، ٻٜ ڤٜکّٛرَيْ دٛوْ طَتَلْ، نغَمْ وٛٻّٜ نغَرٛيِي دَغَ ٻَدَاکِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","تٛکُّٻٜمٛ نٛوتِي مبِعِ، ‏«‏تٛيٜ غٛطّٛ حٜٻَتَ بُرٛودِ ندٜرْ لَدّٜ ندٜعٜ کٜپَيْطُمْ يِمْٻٜ ٻٜعٜ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","يٜىٰسُ پَمِٻٜ وِعِ، ‏«‏بُرٛودِ نٛيٜ نغٛودُطٛنْ؟»‏ ٻٜ مبِعِمٛ، ‏«‏جٛوٜىٰطِطِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","سٜيْ اٛ وِعِ يِمْٻٜ حَوْرُتُٻٜ ٻٜنْ فُو ٻٜ نجٛوطٛو اٜ لٜيْدِ؞ اٛ حٛشِّ بُرٛودِ جٛوٜىٰطِطِ طُمْ، اٛ يٜتِّ اَللَّه، اٛ سٜنْدِطُمْ، اٛ حٛکِّ تٛکُّٻٜمٛ نغٜىٰدَنَ يِمْٻٜ، کَمْٻٜ بٛو ٻٜ نغٜىٰدَنِ يِمْٻٜ حَوْرُتُٻٜ ٻٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","طٛنْمَا اٜ ٻٜ نغٛودِ غٛطِّ لِپِّ ڤَمَرِ سٜطَّنَاجِ، سٜيْ اٛ يٜتِّ اَللَّه نغَمْ مَاجِ، اٛ وِعِ تٛکُّٻٜمٛ کَنْجِ مَا ٻٜ نغٜىٰدَنَ يِمْٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","يِمْٻٜ ٻٜنْ ݧَامِ کَارِ؞ غَطَ مَاجُمْ تٛکُّٻٜمٛ مٛٻْتِ کٛ حٛرِي، طُمْ حٜىٰوِ کٛنْدٛوجٜ جٛوٜىٰطِطِ؞ ");
INSERT INTO fuv_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","يِمْٻٜ ٻٜنْ ٻَدَکٜ 4,000؞ سٜيْ اٛ جَٻِّتِيٻٜ ");
INSERT INTO fuv_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","اٛ نَتِّ کٛمِوَلْ، کَنْکٛ اٜ تٛکُّٻٜمٛ، ٻٜ ندِلِّ لٜيْدِ دَلْمَنُوتَ؞ ");
INSERT INTO fuv_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","فَارِسَنْکٛعٜنْ نغَرِ ڤُطِّ يٜدّٛوتِرْکِ اٜ يٜىٰسُ؞ اٜ ٻٜ نغِطِ فٛوندُکِمٛ، سٜيْ ٻٜ مبِعِمٛ اٛ وَطَنَٻٜ غٛطُّمْ کَيْطِنِيطُمْ پِوٛيْطُمْ تٛ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","سٜيْ يٜىٰسُ فٛفْتِ فٛوفَانغٛ جُوتُنغٛ وِعِ، ‏«‏نغَمْ طُمٜ اٛنٛنْ يِمْٻٜ جَامَنُ طُعُمْ طَٻِّتٛتٛنْ حٛلّٜىٰکِ غٛطُّمْ کَيْطِنِيطُمْ؟ اٜ مِ وِعَعٛنْ غٛونغَ، وَلَا کٛ طُمْ حٛلَّتَ يِمْٻٜ جَامَنُ طُعُمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","دَغَ طٛنْ اٛ اَلِٻٜ، اٛ فُطِّتِ اٛ نَتِّ کٛمِوَلْ، اٛ حُولِ يَاکِ نغٛنْ تٛنْ فٛنْغٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","تٛکُّٻٜ يٜىٰسُ نغٜجِّتِي نغَرْدٛيَ اٜ بُرٛودِ، سٜيْ بُرٛودِ غٛعٛ تَنْ طُمْ ٻٜ نغٛودِ ندٜرْ کٛمِوَلْ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","يٜىٰسُ وَغِّنِٻٜ وِعِ، ‏«‏ڤَامٜىٰ، نغَطٜىٰ حَکِّيلٛ اٜ پُوفِنِرْطُمْ فَارِسَنْکٛعٜنْ اٜ طُمْ حِرُدُسْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","سٜيْ تٛکُّٻٜمٛ مٜدِّ حَکُّندٜ مَٻّٜ، ٻٜ مبِعِ، ‏«‏اٛ وِعُ نٛنْ نغَمْ اٜنْ نغَلَا بُرٛودِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","ندٜ يٜىٰسُ فَامِ کٛ ٻٜ مبِعَتَ، سٜيْ اٛ پَمِٻٜ، اٛ وِعِ، ‏«‏نغَمْ طُمٜ مٜدّٛتٛنْ دٛوْ اٛنْ نغَلَا بُرٛودِ؟ حَا جٛونِ اٛنْ کٜٻْتَايِ اٛنْ ڤَامَايِ؟ کٛو ٻٜرْطٜ شَاتُطٜ نغٛودُطٛنْ؟ ");
INSERT INTO fuv_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","اٛنْ نغٛودِ غِتٜ، اَمَّا تَمْڤُطٛنْ يِيکِ؟ اٛنْ نغٛودِ نٛڤِّ، اَمَّا تَمْڤُطٛنْ نَنُکِ؟ اٛنْ شِفْتٛرَايِ؟ ");
INSERT INTO fuv_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","شَرٜلْ نغٜلْ ݧَمْنُمِ يِمْٻٜ 5,000 بُرٛودِ جٛوِ، کٛنْدٛوجٜ نٛيٜ ٻٛڤْتُطٛنْ اٜ کٜىٰوِ حٛرَانٛ؟»‏ ٻٜ مبِعِ، ‏«‏سَڤّٛ اٜ طِطِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","‏«‏ندٜنْ شَرٜلْ نغٜلْ ݧَمْنُمِ يِمْٻٜ 4,000 بُرٛودِ جٛوٜىٰطِطِ، کٛنْدٛوجٜ نٛيٜ ٻٛڤْتُطٛنْ اٜ کٜىٰوِ حٛرَانٛ؟»‏ ٻٜ مبِعِمٛ، ‏«‏جٛوٜىٰطِطِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","سٜيْ يٜىٰسُ وِعِٻٜ، ‏«‏حَا جٛونِ اٛنْ ڤَامَايِ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","يٜىٰسُ اٜ تٛکُّٻٜمٛ نجٛتِّي غَرِيرِ بٜتَسَيْدَ، سٜيْ وٛٻّٜ يِمْٻٜ نغَدِّ بُمْطٛ، ٻٜ تٛرِي يٜىٰسُ مٜىٰمَمٛ نغَمْ يَمْطِتِنَمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","يٜىٰسُ جٛغِي جُنْغٛ بُمْطٛ اٛنْ، يَارِمٛ تٛنْ غَطَ غَرِيٜلْ، تُتَّنِمٛ جٛودٜ تٛ غِتٜ يٛوِ جُوطٜ مُوطُمْ دٛوْ مَاکٛ، سٜيْ پَمِمٛ، وِعِ، ‏«‏اَ يِعِي غٛطُّمْ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","سٜيْ بُمْطٛ اٛنْ پٜفْتِ حٛورٜ، رَارِ، وِعِ، ‏«‏اٜ مِ يِعَ يِمْٻٜ، اَمَّا اٜ ٻٜ نَنْدِ اٜ لٜطّٜ اٜ ٻٜ نغِيلٛو؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","سٜيْ يٜىٰسُ فُطِّتِ مٜىٰمِ غِتٜ طٜنْ؞ بُمْطٛ اٛنْ مَٻِّتِ غِتٜ بٛطُّمْ، غِتٜ مَاکٛ نجَمْطِتِ، اٛ يِعِ کٛو طُمٜ بٛطُّمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","سٜيْ يٜىٰسُ وِعِمٛ اٛ حٛوتَ، وِعِمٛ، ‏«‏تَاع نَتُّ ندٜرْ غَرِيٜلْ نغٜلْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","يٜىٰسُ اٜ تٛکُّٻٜمٛ ٻٜ ندِلِّ يَاکِ نغَرِحٛيْ نغٛنْکٛيْ حَادٜ غَرِيرِ کَيْسَارِيَ فِلِبِ؞ اٜ ٻٜ نجَحَ دٛوْ طَتَلْ سٜيْ اٛ پَمِٻٜ، اٛ وِعِ، ‏«‏مٛيٜ يِمْٻٜ مبِعَتَيَمْ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","ٻٜ نٛوتِي ٻٜ مبِعِ، ‏«‏وٛٻّٜ اٜ مبِعَ اَ يَحَيَ غَطٛووٛ بَڤْتِسْمَ؞ وٛٻّٜ بٛو اٜ مبِعَ اَ اَنَّبِ اِلِيَ؞ ندٜنْ وٛٻّٜ اٜ مبِعَ اَ غٛعٛتٛ ندٜرْ اَنَّبٛعٜنْ ندٜنّٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","سٜيْ اٛ پَمِٻٜ، اٛ وِعِ، ‏«‏اَمَّا اٛنٛنْ، مٛيٜ مبِعٛتٛنْيَمْ؟»‏ سٜيْ بِيتُرُسْ نٛوتِي وِعِ، ‏«‏اَنْ وٛنِ اَلْمَسِيحُ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","ندٜنْ يٜىٰسُ وَغِّنِٻٜ نَاع سٜطَّ وِعِٻٜ تٛع ٻٜ مبِعَکَ کٛو مٛيٜ کَنْکٛ اٛ مٛيٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","سٜيْ يٜىٰسُ فُطِّ اٜکِّتِنْکِٻٜ اٜ وِعَ دٛولٜ ٻِي نٜطّٛ تٛرّٛو نَاع سٜطَّ؞ مَوْٻٜ يِمْٻٜ، اٜ مَوْٻٜ اَرْدِيٻٜ دِينَ، اٜ مٛودِٻّٜ اَتَّوْرَ نغَݧَمٛ، ندٜنْ اٛ وَرٜىٰ؞ غَطَ بَلْطٜ تَتِ بٛو اٛ اُمّٛتٛ دَغَ مَيْدٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","يٜىٰسُ مٜتِي حَالَ کَعَ اٜ نجَيْرِ؞ سٜيْ بِيتُرُسْ نٛدِّمٛ وُتُّدُ غٛعٛ فُطِّ حَٻَنْکِمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","اَمَّا يٜىٰسُ وَيْلِتِي رَارِ تٛکُّٻٜمٛ کٛرِيٻٜ، حَٻَنِ بِيتُرُسْ، وِعِ، ‏«‏سٜنْدِرْ اٜ اَمْ، اَنْ شٜيْطَنْ!‏ نَاع تٛ اَللَّه ݧُمٛ مَاطَ پِوٛيِ، اِرِ ݧُمٛ يِمْٻٜ ݧُمَتَا؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","سٜيْ اٛ نٛدِّ يِمْٻٜ طُطْٻٜ حَوْرُتُٻٜ حَوْتِ اٜ تٛکُّٻٜمٛ، اٛ وِعِٻٜ، ‏«‏فُو غِطّٛ وَرْتَ تٛکُّطٛيَمْ، تٛع وَطَ کٛ حٛورٜ مُوطُمْ يِطِ وَطُکِ تَنْ، اَمَّا دٛولٜ حٛشَّ غَافَانغَلْ مُوطُمْ تٛکَّيَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","نغَمْ فُو غِطّٛ حِسْنُکِ يٛنْکِ مُوطُمْ اٛ دُلَّيْکِ؞ اَمَّا فُو دُلَّيْطٛ يٛنْکِ مُوطُمْ نغَمْ اَمْ اٜ نغَمْ حَبَرُ بٜلْطُمْ اٛ حِسْنَيْکِ؞ ");
INSERT INTO fuv_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","کٛ طُمْ نَفَنْتَ نٜطّٛ، تٛ اٛ حٜٻِي دُونِيَارُ فُو، اَمَّا اٛ دُلِّي يٛنْکِ مَاکٛ؟ ");
INSERT INTO fuv_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","کٛو بٛو کٛ نٜطّٛ وَاوَتَ حٛکُّکِ نغَمْ جَٻْتٛيَ يٛنْکِ مُوطُمْ؟ ");
INSERT INTO fuv_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","کٛو مٛيٜ غَݧُطٛيَمْ اٜ بٛلِيطٜ اَمْ ندٜرْ طُعُمْ جَامَنُ طُمْ حَکّٜ، طُمْ وَلَا غٛونغَ، مِنْ ٻِي نٜطّٛ مِ وَݧَيْمٛ تٛ مِ وَرْتِدٛيِي اٜ مَلَاعِکَعٜنْ شٜنِيٻٜ ندٜرْ تٜدُّنغَلْ ݧَاکٛ اَمْ مٛ دٛوْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","اٛ وِعِٻٜ، ‏«‏اٜ مِ وِعَعٛنْ غٛونغَ، اٜ وٛودِ وٛٻّٜ دَرِيٻٜ طٛعٛ ٻٜ مَايَتَا نَا ٻٜ نغِعِي لَامُ اَللَّه وَرْدِ اٜ بَوْطٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","غَطَ بَلْطٜ جٛوٜىٰغٛعٛ، سٜيْ يٜىٰسُ حٛشِّ بِيتُرُسْ، اٜ يَاکُبُ، اٜ يَحَيَ، اٛ يَارِٻٜ دٛوْ وٛنْدٜ حٛشّٜىٰرٜ تٛوْندٜ کَمْٻٜ تَنْ؞ سٜيْ نَنْدِ مَاکٛ وَيْلِتِي يٜىٰسٛ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","کٛلْتٜ مَاکٛ نغَرْتِ دَنٜىٰجٜ تَرْ؞ وَلَا غٛطّٛ بَاوَيْطٛ لَاٻِنِرَ کٛلْتٜ نٛنْ ندٜرْ دُونِيَارُ فُو؞ ");
INSERT INTO fuv_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","سٜيْ اَنَّبِ اِلِيَ اٜ اَنَّبِ مُوسَ مبَنْغَنِٻٜ اٜ ٻٜ مٜدَّ اٜ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","سٜيْ بِيتُرُسْ وِعِ يٜىٰسُ، ‏«‏مٛودِبّٛ، وٛنْکِ اَمِنْ طٛعٛ اٜ وٛوطِ؞ اَلْ مِنْ ݧِٻَ شُوطِ تَتِ طٛعٛ، وٛعٛيْرُ ندُ مَاطَ، وٛعٛيْرُ ندُ مُوسَ، وٛعٛيْرُ ندُ اِلِيَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","بِيتُرُسْ نٛ دُلُّ کٛ وِعَتَ نغَمْ کَنْکٛ اٜ تٛکُّٻٜ يٜىٰسُ کٛرِيٻٜ ٻٜ کُلْتٛرِي نَاع سٜطَّ؞ ");
INSERT INTO fuv_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","سٜيْ ندُولَ وَنْغِ سُدِّٻٜ، سٜيْ وٛنْدٜ حٛنٛنْدٜ پِوٛيِ ندٜرْ ندُولَ نغَنْ، وِعِ، ‏«‏اٛعٛ وٛنِ ٻِطّٛ اَمْ مٛ نغِطُمِ؞ نَنٜىٰ کٛ اٛ وِعَتَعٛنْ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","طٛنْ اٜ طٛنْ ٻٜ ندَارِ ٻٜ نغِعَايِ غٛطّٛ اٜ وٛنْدِ اٜ مَٻّٜ سٜيْ يٜىٰسُ تَنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","اٜ ٻٜ نجِڤّٛيٛو دَغَ دٛوْ حٛشّٜىٰرٜ ندٜنْ، سٜيْ يٜىٰسُ وَغِّنِٻٜ وِعِ تٛع ٻٜ مبِعَ کٛو مٛيٜ کٛ ٻٜ نغِعِ نَا غَطَ ٻِي نٜطّٛ اُمَّکٜ دَغَ مَيْدٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","نغَمْ نٛنْ ٻٜ اَلِ حَالَ کَنْ حَکُّندٜ مَٻّٜ، اٜ ٻٜ مٜدَّ دٛوْ مَعَنَ ‏«‏اُمَّاکِ دَغَ مَيْدٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","سٜيْ ٻٜ پَمِمٛ، ٻٜ مبِعِ، ‏«‏نغَمْ طُمٜ مٛودِٻّٜ اَتَّوْرَ اٜ مبِعَ دٛولٜ اَنَّبِ اِلِيَ اَرْتَ اَلْمَسِيحُ وَرْکِ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","يٜىٰسُ نٛوتِي، وِعِ، ‏«‏غٛونغَ، اَنَّبِ اِلِيَ اَرْتَيْ وَرْکِ نغَمْ اٛ سِرْيٛو کٛو طُمٜ؞ نغَمْ طُمٜ طُمْ وِنْدِ وِيکِ دٛولٜ ٻِي نٜطّٛ تٛرّٛو نَاع سٜطَّ ندٜنْ اٛ وَݧٜىٰ؟ ");
INSERT INTO fuv_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","اَمَّا اٜ مِ وِعَعٛنْ اِلِيَ يَادَکٜ وَرِي، يِمْٻٜ بٛو نغَطَنِيمٛ فُو کٛ ٻٜ نغِطِ، نٛنْ نٛ طُمْ وِنْدِرَا دٛوْ مَاکٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","ندٜ يٜىٰسُ اٜ تٛکُّٻٜمٛ نجٛتِّي تٛ تٛکُّٻٜمٛ کٛرِيٻٜ، سٜيْ ٻٜ نغِعِ يِمْٻٜ طُطْٻٜ اٜ ڤِلِيٻٜ؞ وٛٻّٜ مٛودِٻّٜ اَتَّوْرَ اٜ نغٜدّٛوتِرَ اٜ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","ندٜ فُو يِمْٻٜ ٻٜنْ نغِعِ يٜىٰسُ، ٻٜ کَيْطِنِ نَاع سٜطَّ، ٻٜ ندٛغِّ ٻٜ نجَحِ تٛ مَاکٛ نغَمْ ٻٜ کٛوْنَمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","سٜيْ يٜىٰسُ پَمِٻٜ وِعِ، ‏«‏دٛوْ طُمٜ نغٜدّٛوتِرْتٛنْ اٜ مَٻّٜ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","سٜيْ غٛعٛتٛ ندٜرْ يِمْٻٜ ٻٜنْ نٛوتِي وِعِ، ‏«‏مٛودِبّٛ، مِ وَدَّنِيمَ ٻِطّٛ اَمْ غٛودُطٛ غِنّٛلْ؞ غِنّٛلْ نغٛلْ حَطِيمٛ اٛ مٜتَ؞ ");
INSERT INTO fuv_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","فُو شَرٜلْ نغٜلْ غِنّٛلْ نغٛلْ نَنْغِمٛ، سٜيْ نغٛلْ دٛعَّمٛ تٛ لٜيْدِ، نغُوفٛ نغَطَ کَ وُرْتَاکِ اٜ حٛنْدُکٛ مَاکٛ، اٜ مٛ ݧٜرْپِندِرَ ݧِيپٜ مَاکٛ، ٻَنْدُ مَاکٛ وَرْتَ بٛ لٜکِّ؞ مِ تٛرَکٜ تٛکُّٻٜمَ مبُرْتِنَنغٛلْ، اَمَّا ٻٜ مبَاوَايِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","يٜىٰسُ نٛوتِي وِعِ، ‏«‏اٛنٛنْ يِمْٻٜ جَامَنُ طُعُمْ طُمْ حٛولَاکِيَمْ، حَا ندٜيٜ نجٛوطٛدٛتٛومِ اٜ مٛوطٛنْ اٜ مِ مُݧِدَ اٜ مٛوطٛنْ؟ نغَدَّنٜىٰيَمْ سُکَ اٛنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","سٜيْ ٻٜ نغَدِّمٛ؞ ندٜ غِنّٛلْ نغٛلْ يِعِ يٜىٰسُ، طٛنْ اٜ طٛنْ نغٛلْ وَطِ ٻَنْدُ سُکَ اٛنْ وَطِ کَ دِوْنُکِ، اٛ يَنِ تٛ لٜيْدِ، اٜ مٛ تَلِّتٛو، حٛنْدُکٛ مَاکٛ اٜ وُرْتِنَ نغُوفٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","سٜيْ يٜىٰسُ پَمِ ݧَاکٛ سُکَ اٛنْ، وِعِ، ‏«‏دَغَ ندٜيٜ طُعُمْ فِي حٜٻِ سُکَ اٛنْ؟»‏ ݧَاکٛ اٛنْ وِعِ، ‏«‏دَغَ اٛ ڤَمَرٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","ندٜ طُطُّمْ اٜ نغٛلْ فَطَّمٛ ندٜرْ حِيتٜ کٛو ندٜرْ ندِيَمْ نغَمْ نغٛلْ وَرَمٛ؞ اَمَّا تَا وَاوَيْ وَطُکِ غٛطُّمْ، يُرْمِنَنْمِنْ مبَلَّامِنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","يٜىٰسُ وِعِمٛ، ‏«‏نغَمْ طُمٜ مبِعَتَايَمْ، ‏‹‏تَا وَاوَيْ؟›‏ کٛو طُمٜ طُمْ غَطٛتٛوطُمْ تٛ نٜطّٛ حٛولَکٜيَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","طٛنْ اٜ طٛنْ سٜيْ ݧَاکٛ سُکَ اٛنْ پٜفْتِ حٛنٛنْدٜ وِعِ، ‏«‏مِ حٛولَکٜمَ؞ وَلَّمْ مِ جَالٛو شِيَ حٛولَارٜ اَمْ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","ندٜ يٜىٰسُ يِعِ يِمْٻٜ اٜ نغَرٛيَ اٜ دٛغُّدُ نغَمْ نغِعَ کٛ وَطَتَ، سٜيْ اٛ حَٻَنِ غِنّٛلْ نغٛلْ، اٛ وِعِنغٛلْ، ‏«‏اَنْ، غِنّٛلْ کَطُنغٛلْ سُکَ اٛعٛ مٜتُکِ اٜ نَنُکِ، اٜ مِ وِعِمَا، وُرْتَ دَغَ ندٜرْ مَاکٛ!‏ تَاع فُطُّتُ نَتُّکِمٛ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","سٜيْ غِنّٛلْ نغٛلْ وُلِّ، نغٛلْ وَطِ سُکَ اٛنْ دِوْنِ نَاع سٜطَّ، ندٜنْ نغٛلْ وُرْتِي؞ سُکَ اٛنْ وَرْتِ بٛ مَيْطٛ، حَا مَا يِمْٻٜ طُطْٻٜ مبِعِ، ‏«‏اٛ مَايِي؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","اَمَّا يٜىٰسُ جٛغِي جُنْغٛ مَاکٛ اُمِّنِمٛ، اٛ دَرِي؞ ");
INSERT INTO fuv_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","ندٜ يٜىٰسُ نَتِّ ندٜرْ وُرٛ، تٛکُّٻٜمٛ نغَرِ تٛ مَاکٛ کَمْٻٜ تَنْ، ٻٜ پَمِمٛ ٻٜ مبِعِ، ‏«‏نغَمْ طُمٜ مِنٛنْ مِنْ مبَاوَايِ وُرْتِنْکِ غِنّٛلْ نغٛلْ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","يٜىٰسُ نٛوتِي، وِعِ، ‏«‏اِرِ نغٛعٛلْ غِنّٛلْ نغٛلْ وُرْتَتَاکٛ سٜيْ اٜ دٛعَارٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","سٜيْ يٜىٰسُ اٜ تٛکُّٻٜمٛ اَلِ طٛنْ ٻٜ ندِلِّ ٻٜ پِوِ ندٜرْ لٜيْدِ غَلِيلِ؞ يٜىٰسُ يِطَا کٛو مٛيٜ اَنْدَ تٛ ٻٜ نغٛنِ، ");
INSERT INTO fuv_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","نغَمْ اٜ مٛ اٜکِّتِنَ تٛکُّٻٜمٛ، اٜ مٛ وِعَٻٜ، ‏«‏طُمْ حٛکِّتِرَيْ ٻِي نٜطّٛ ندٜرْ جُوطٜ يِمْٻٜ ٻٜ مبَرَمٛ؞ ندٜنْ تٛ اٛ وَرَامَ، غَطَ بَلْطٜ تَتِ اٛ اُمّٛتٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","اَمَّا ٻٜ ڤَامَايِ کٛ اٛ وِعِٻٜ، ندٜنْ اٜ ٻٜ کُلَ پَمُکِمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","سٜيْ ٻٜ نجٛتِّي کَفَرْنَحُمْ؞ غَطَ يٜىٰسُ نَتِّي وُرٛ، اٛ پَمِ تٛکُّٻٜمٛ، اٛ وِعِ، ‏«‏دٛوْ طُمٜ مٜدّٛتٛنْ دٛوْ طَتَلْ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","اَمَّا ٻٜ ندٜعِّتِ نغَمْ دٛوْ طَتَلْ ٻٜ نغٜدّٛوتِرِ دٛوْ مٛيٜ وٛنِ ٻُرْطٛ مَنْغُ ندٜرْ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","سٜيْ اٛ جٛوطِي، اٛ نٛدِّ تٛکُّٻٜمٛ سَڤّٛ اٜ طِطٛ ٻٜنْ، اٛ وِعِٻٜ، ‏«‏فُو غِطّٛ وَرْتَ مَوْطٛ، دٛولٜ اٛ وَرْتَ ڤَمَرٛ، ندٜنْ اٛ وَرْتَ مَشُّطٛ کٛو مٛيٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","سٜيْ اٛ حٛشِّ سُکَ ڤَمَرٛ، اٛ دَرْنِنغٜلْ شَکَ مَٻّٜ، اٛ وُوندِينغٜلْ، اٛ وِعِٻٜ، ");
INSERT INTO fuv_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","‏«‏فُو جَٻُطٛ سُکَيٜلْ ڤَمَرٜلْ بٛ نغٜعٜلْ ندٜرْ اِنْدٜ اَمْ جَٻِييَمْ؞ فُو جَٻُطٛيَمْ بٛو نَاع مِنْ تَنْ جَٻِ، اَمَّا جَٻِي لِلٛيْطٛيَمْ مَا؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","سٜيْ يَحَيَ وِعِمٛ، ‏«‏مٛودِبّٛ، مِنْ نغِعِ غٛطّٛ اٜ وُرْتِنَ غِنِّ ندٜرْ اِنْدٜ مَاطَ مِنْ کَطِمٛ، نغَمْ کَنْکٛ نَاع اٛ تٛکُّطٛعٜنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","اَمَّا يٜىٰسُ وِعِ، ‏«‏تٛع اٛنْ کَطُمٛ، نغَمْ وَلَا غَطٛووٛ غٛطُّمْ کَيْطِنِيطُمْ ندٜرْ اِنْدٜ اَمْ ندٜنْ طٛنْ اٜ طٛنْ وِعَ حَالَ کَلُّکَ دٛوْ اَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","نغَمْ فُو مٛ وَݧَايِعٜنْ اٜ وٛنْدِ اٜ مٜىٰطٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","اٜ مِ وِعَعٛنْ غٛونغَ، کٛو مٛيٜ حٛکِّعٛنْ ندِيَمْ ندٜرْ جَرْدُغٜلْ نجَرٛنْ نغَمْ اٛنٛنْ طُمْ ٻٜ اَلْمَسِيحُ، غٛونغَ اٛ دُلَّتَا حٜٻُکِ مبَرْجَارِ؞ ");
INSERT INTO fuv_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","‏«‏تٛ غٛطّٛ وَطِي غٛعٛتٛ ندٜرْ سُکَحٛيْ ڤَمَرٛيْ کٛعٛيْ کٛولِيکٛيْيَمْ وَطِي حَکّٜ، طُمْ ٻُرَنِيمٛ اٛ حَٻَّنٜىٰ کَاپَ نَمٛلْ مَنْغَ اٜ دَاندٜ طُمْ فَطَّمٛ ندٜرْ مبٜىٰلَ؞ ");
INSERT INTO fuv_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","تٛ جُنْغٛ مَاطَ اٜ وَطُمَا نغَطَا حَکّٜ، اِتُّنغٛ؞ طُمْ ٻُرَنِيمَ نَتَّا وُرٛ اَللَّه جُنْغٛ وٛعٛتٛ دٛوْ طُمْ حُبٛمَا ندٜرْ وُرٛ حِيتٜ نغٜ ݧِفَتَا اٜ جُوطٜ طِطِ؞ ");
INSERT INTO fuv_vpl VALUES ("MK9_44‏","071_9_44‏","MRK","9","44‏","45","نٛنْ مَا تٛ کٛيْنغَلْ مَاطَ اٜ وَطُمَا نغَطَا حَکّٜ، اِتُّنغَلْ؞ طُمْ ٻُرَنِيمَ نَتَّا وُرٛ اَللَّه اٜ کٛيْنغَلْ غٛعٛتَلْ دٛوْ طُمْ حُبٛمَا ندٜرْ وُرٛ حِيتٜ اٜ کٛيْطٜ طِطِ؞ ");
INSERT INTO fuv_vpl VALUES ("MK9_46‏","071_9_46‏","MRK","9","46‏","47","تٛ بٛو حِتٜرٜ مَاطَ اٜ وَطُمَا نغَطَا حَکّٜ، اِتُّندٜ؞ طُمْ ٻُرَنِيمَ نَتَّا وُرٛ اَللَّه اٜ حِتٜرٜ غٛعٛ دٛوْ طُمْ حُبٛمَا ندٜرْ وُرٛ حِيتٜ اٜ غِتٜ طِطِ؞ ");
INSERT INTO fuv_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ندٜرْ حِيتٜ نغٜنْ ‏‹‏غِلْپِ ݧَامَيْطِٻٜ طِ مبَاتَتَا، حِيتٜ نغٜنْ بٛو نغٜ ݧِفَتَا؞›‏ ");
INSERT INTO fuv_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","‏«‏نٛنْ نٛ وٛنْدُ ݧَمْندُ دٛولٜ وَطَنٜىٰ لَمْطَمْ نغَمْ ندُ وٜلَ، نٛنْ مَا فُو يِمْٻٜ دٛولٜ نَتَّ حِيتٜ، وَاتٛ شَطٜىٰلٜ، نغَمْ نغِکُّ مَٻّٜ وَرْتَ بٛطُّمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","‏«‏لَمْطَمْ طُمْ فِي بٛطُّمْ، اَمَّا تٛ بٜلْطُمْ مَاجَمْ اِتَّکٜ، کٛ وَرْتِرْتَ بٜلْطُمْ مَاجَمْ؟ نغَرْتٜىٰ بٛ لَمْطَمْ، وَاتٛ مبٜلْنِنْدِرٜىٰ ٻٜرْطٜ مٛوطٛنْ، ندٜنْ نجٛوطٜىٰ جَمْ حَکُّندٜ مٛوطٛنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","سٜيْ يٜىٰسُ اُمِّي اَلِ طٛنْ يَحِ لٜيْدِ يَحُودِيَ اٜ فٛنْغٛ شَانغٛلْ اُرْدُنْ؞ يِمْٻٜ طُطْٻٜ فُطِّتِ کَوْرِتِ تٛ مَاکٛ، اٛ اٜکِّتِنِٻٜ نٛ اٛ وٛووِ وَطُکِ؞ ");
INSERT INTO fuv_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","سٜيْ وٛٻّٜ فَارِسَنْکٛعٜنْ نغَرِ تٛ مَاکٛ نغَمْ ٻٜ ڤٛوندَمٛ، ٻٜ پَمِمٛ ٻٜ مبِعِ، ‏«‏اٜ يِيکِ مَاطَ اَتَّوْرَ اَلِي نٜطّٛ يٛوفَ دٜبّٛ مُوطُمْ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","يٜىٰسُ نٛوتِي وِعِ، ‏«‏طُمٜ مُوسَ وِعِعٛنْ نغَطٛنْ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","ٻٜ مبِعِ، ‏«‏مُوسَ وِعِ نٜطّٛ وَاوَيْ وِنْدَنَ دٜبّٛ مُوطُمْ طٜرٜوٛلْ وَرْکِ تٜىٰغَلْ وِعَمٛ اٛ دِلَّ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","سٜيْ يٜىٰسُ وِعِٻٜ، ‏«‏نغَمْ ٻٜرْطٜ مٛوطٛنْ طٜ شَاتُطٜ وَطِ مُوسَ وِنْدَنِعٛنْ طُعُمْ دٛوکَ؞ ");
INSERT INTO fuv_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","اَمَّا دَغَ فُطّٛودٜ تَغُکِ ‏‹‏اَللَّه تَغِيٻٜ غٛرْکٛ اٜ دٜبّٛ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‏‹‏نغَمْ نٛنْ نٜطّٛ اَلَيْ ݧَاکٛ مُوطُمْ اٜ مَدُوجٛ مُوطُمْ تَکَّنٛو دٜبّٛ مُوطُمْ، ");
INSERT INTO fuv_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","کَمْٻٜ طِطٛ ٻٜ نغَرْتَ غٛعٛ؞›‏ نغَمْ نٛنْ نَاع ٻٜ طِطٛ کَدِنْ، اَمَّا ٻٜ نغَرْتِي نٜطّٛ غٛعٛتٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","نغَمْ مَاجُمْ کٛ اَللَّه حَوْتِ، تٛع نٜطّٛ سٜنْدَطُمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","اٜ ٻٜ ندٜرْ وُرٛ کَدِنْ، تٛکُّٻٜمٛ پَمِمٛ دٛوْ حَالَ کَنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","سٜيْ اٛ وِعِٻٜ، ‏«‏کٛو مٛيٜ يٛوفِ دٜبّٛ مُوطُمْ تٜعِ غٛطّٛ، نجٜىٰنُ اٛ وَادَتَ اٜ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","طٛنْمَا تٛ دٜبّٛ سٜنْدِرِي اٜ غٛرْکٛ مُوطُمْ تٜىٰرِ اٜ غٛطّٛ، نجٜىٰنُ اٛ وَطَتَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","يِمْٻٜ اٜ نغَدَّنَ يٜىٰسُ سُکَحٛيْ ڤَمَرٛيْ نغَمْ اٛ بَرْکِطِنَکٛيْ، اَمَّا تٛکُّٻٜمٛ کَٻَنِٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","ندٜ يٜىٰسُ يِعِ نٛنْ، ٻٜرْندٜ مُوطُمْ مٜتِّ، اٛ وِعِٻٜ، ‏«‏اَلٜىٰ سُکَحٛيْ ڤَمَرٛيْ نغَرَ تٛ اَمْ؞ تٛع اٛنْ کَطُکٛيْ، نغَمْ غٛودُٻٜ ٻٜرْطٜ اِرِ طٜ مَاکٛيْ نجٜيِ لَامُ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","اٜ مِ وِعَعٛنْ غٛونغَ، فُو مٛ جَٻَايِ لَامُ اَللَّه بٛ سُکَيٜلْ ڤَمَرٜلْ، اٛ نَتَّتَا لَامُ طُمْ کٛو سٜطَّ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","سٜيْ يٜىٰسُ وُوندِيکٛيْ غٛعٛ‑غٛعٛ، اٛ يٛوَنِکٛيْ جُوطٜ مَاکٛ نغَمْ بَرْکِطِنْکِ؞ ");
INSERT INTO fuv_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","يٜىٰسُ نَنْغِ لَاوٛلْ وٛنْ طٛنْ، سٜيْ غٛطّٛ نٜطّٛ دٛغِّ يَحِ دِشِّي يٜىٰسٛ مَاکٛ؞ نٜطّٛ اٛنْ پَمِمٛ، وِعِ، ‏«‏مٛودِبّٛ غٜىٰتٛ، کٛ حَانِ مِ وَطَ مِ حٜٻَ يٛنْکِ کِ رٜعَتَا؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","يٜىٰسُ وِعِمٛ، ‏«‏نغَمْ طُمٜ نٛدِّرْطَايَمْ غٜىٰتٛ؟ وَلَا غٜىٰتٛ سٜيْ اَللَّه تَنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","اَ اَنْدِ کٛ اَتَّوْرَ وِعِ:‏ ‏‹‏تَاع وَطُ وَرْحٛورٜ؞ تَاع وَطُ نجٜىٰنُ؞ تَاع وُجُّ؞ تَاع حٛکُّ شٜيْدَ فٜوْرٜ؞ تَاع پٛيْرُ نٜطّٛ نجَٻَنَامٛ کٛ اٛ جٜيِ؞ حٛکُّ ݧَاکٛ مَاطَ اٜ مَدُوجٛ مَاطَ مَنْغُ؞›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","سٜيْ اٛ وِعِ يٜىٰسُ، ‏«‏مٛودِبّٛ، اٜ مِ وَطَ فُو فِي طُعُمْ دَغَ اٜ مِ سُکَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","يٜىٰسُ رَارِمٛ ندٜرْ يِدّٜ، وِعِمٛ، ‏«‏اَ دُلِّي وَطُکِ فِي غٛعٛ؞ يَحُ، شٛورَا کٛ نغٛودُطَا، کٛکَّا ٻٜ نغَلَنَا شٜىٰدٜ طٜنْ، ندٜنْ اَ حٜٻَيْ مبَرْجَارِ تٛنْ دٛوْ؞ ندٜنْ نغَرَا، تٛکَّايَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","ندٜ نٜطّٛ اٛنْ نَنِ نٛنْ، ٻٜرْندٜ مَاکٛ تَپِ، اٛ دِلِّ اٛ نَنَايِ بٜلْطُمْ، نغَمْ اٜ مٛ وٛودِ رِسْکُ طُطُّمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","يٜىٰسُ رَارِ تٛکُّٻٜمٛ وِعِٻٜ، ‏«‏اٜ طُمْ سَطِ دِسْکُطٛ نَتَّ لَامُ اَللَّه!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","تٛکُّٻٜمٛ کَيْطِنِي اٜ کٛ اٛ وِعِ، اَمَّا اٛ فُطِّتِ اٛ وِعِٻٜ، ‏«‏ٻِٻّٜ اَمْ، نَتُّکِ لَامُ اَللَّه اٜ سَطِ نَاع سٜطَّ!‏ ");
INSERT INTO fuv_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","طُمْ ٻُرَيْ حٛيْکِ نغٜىٰلٛوبَ تٛکَّ ندٜرْ يٛلْندٜ بَاتَلْ دٛوْ دِسْکُطٛ نَتَّ لَامُ اَللَّه؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","تٛکُّٻٜمٛ کَيْطِنِ نَاع سٜطَّ، ٻٜ مبِعِمٛ، ‏«‏تٛو، تٛ طُمْ نٛنْ، مٛيٜ حِسَتَ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","يٜىٰسُ رَارِٻٜ، وِعِ، ‏«‏تٛ يِمْٻٜ طُمْ وَطَتَاکٛ، اَمَّا تٛ اَللَّه طُمْ وَطٛتٛ؞ نغَمْ تٛ مَاکٛ کٛو طُمٜ طُمْ غَطٛتٛوطُمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","سٜيْ بِيتُرُسْ وِعِمٛ، ‏«‏تٛو، رَطُّمْ، مِنٛنْ مِنْ اَلِي کٛو طُمٜ مِنْ تٛکِّيمَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","يٜىٰسُ وِعِ، ‏«‏اٜ مِ وِعَعٛنْ غٛونغَ، فُو اَلُطٛ وُرٛ مُوطُمْ، کٛو سَکِرَاٻٜ مُوطُمْ وٛرْٻٜ کٛو رٜوْٻٜ، کٛو مَدُوجٛ مُوطُمْ، کٛو ݧَاکٛ مُوطُمْ، کٛو ٻِٻّٜ مُوطُمْ، کٛو غٜسٜ مُوطُمْ نغَمْ اَمْ اٜ حَبَرُ بٜلْطُمْ، ");
INSERT INTO fuv_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","اٛ حٜٻَيْ کٛ ٻُرِ نٛنْ ندٜرْ طُعُمْ جَامَنُ؞ اٛ حٜٻَيْ غُرٜىٰجٜ، اٜ سَکِرَاٻٜ وٛرْٻٜ اٜ رٜوْٻٜ، اٜ دَݧٛوٻٜ، اٜ ٻِٻّٜ، اٜ غٜسٜ ندٜ 100؞ طٛنْمَا يِمْٻٜ تٛرَّيْمٛ، اَمَّا ݧَلْندٜ جَانغٛ اٛ حٜٻَيْ يٛنْکِ کِ رٜعَتَا؞ ");
INSERT INTO fuv_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","اَمَّا يِمْٻٜ طُطْٻٜ اَرْتُٻٜ ٻٜ نغَرْتَيْ شَکِتِيٻٜ، ندٜنْ شَکِتِيٻٜ نغَرْتَيْ اَرْتُٻٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","يٜىٰسُ اٜ تٛکُّٻٜمٛ سَڤّٛ اٜ طِطٛ اٜ وٛٻّٜ تٛکُّٻٜمٛ اٜ ٻٜ دٛوْ لَاوٛلْ يَاکِ اُرُشَلِيمَ، يٜىٰسُ اٜ اَرْدِيٻٜ؞ تٛکُّٻٜمٛ سَڤّٛ اٜ طِطٛ ٻٜنْ اٜ کَيْطِنِ، تٛکُّٻٜمٛ کٛرِيٻٜ بٛو اٜ کُلَ؞ يٜىٰسُ فُطِّتِ نٛدِّ تٛکُّٻٜمٛ سَڤّٛ اٜ طِطٛ ٻٜنْ کَمْٻٜ تَنْ، اٛ فُطِّ وِعُکِٻٜ کٛ حٜٻَتَمٛ، ");
INSERT INTO fuv_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","اٛ وِعِ، ‏«‏رَطُّمْ، اٜنْ نجَحَيْ اُرُشَلِيمَ، ندٜنْ طُمْ وَطَيْ ٻِي نٜطّٛ ندٜرْ جُوطٜ مَوْٻٜ اَرْدِيٻٜ دِينَ اٜ مٛودِٻّٜ اَتَّوْرَ؞ ٻٜ تَپَنَيْمٛ کِيتَ مَيْدٜ، ندٜنْ ٻٜ نغَطَمٛ ندٜرْ جُوطٜ يِمْٻٜ نَاع يَحُودَنْکٛعٜنْ، ");
INSERT INTO fuv_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ٻٜ نجُکِّتَمٛ، ٻٜ تُتَّنَمٛ جٛودٜ، ٻٜ ڤِيَمٛ، ٻٜ مبَرَمٛ؞ ندٜنْ غَطَ بَلْطٜ تَتِ، اٛ اُمّٛتٛ دَغَ مَيْدٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","سٜيْ يَاکُبُ اٜ يَحَيَ ٻِٻّٜ جَبَدِ ٻَدِّي يٜىٰسُ، مبِعِ، ‏«‏مٛودِبّٛ، اٜ مِنْ نغِطِ نغَطَنَامِنْ فُو کٛ مِنْ تٛرِمَا؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","سٜيْ يٜىٰسُ وِعِٻٜ، ‏«‏کٛ نغِطّٛنْ مِ وَطَنَعٛنْ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","ٻٜ مبِعِ، ‏«‏تَا جٛوطَکٜ دٛوْ جٛوطٛرْغَلْ لَامُ مَاطَ ندٜرْ تٜدُّنغَلْ مَاطَ، غٛعٛتٛ اَمِنْ جٛوطٛو تٛ ݧَامٛ مَاطَ، غٛعٛتٛ تٛ نَنٛ مَاطَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","اَمَّا يٜىٰسُ وِعِٻٜ، ‏«‏اٛنْ اَنْدَا کٛ تٛرٛتٛوطٛنْ؞ اٛنْ مبَاوَيْ نجَرٛنْ اِرِ جَرْدُغٜلْ تٛرَّ نغٜلْ نجَرَيْمِ يٜىٰسٛ طٛعٛ؟ کٛو اٛنْ مبَاوَيْ طُمْ وَطَنَعٛنْ اِرِ بَڤْتِسْمَ تٛرَّ طُمْ اُمْ وَطَنْتَيَمْ يٜىٰسٛ طٛعٛ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","ٻٜ مبِعِ، ‏«‏اٜىٰ، مِنْ مبَاوَيْ؞»‏ سٜيْ يٜىٰسُ وِعِٻٜ، ‏«‏اٛنْ نجَرَيْ اِرِ جَرْدُغٜلْ تٛرَّ نغٜلْ نجَرَيْمِ، ندٜنْ طُمْ وَطَنَعٛنْ بَڤْتِسْمَ اِرِ طُمْ اُمْ وَطَنْتَيَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","اَمَّا جٛوطَاکِ اٜ جُنْغٛ اَمْ ݧَامٛ اٜ جُنْغٛ اَمْ نَنٛ نَاع مِنْ حٛکَّتَطُمْ؞ طٜعٜ بِغٜىٰجٜ طُمْ طٜ ٻٜنْ طٛنْ ٻٜ طُمْ سِرْيَنِيطٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","ندٜ حٛرِيٻٜ تٛکُّٻٜ يٜىٰسُ سَڤّٛ نَنِ نٛنْ، ٻٜ ڤُطِّ مٛنَّنْکِ يَاکُبُ اٜ يَحَيَ؞ ");
INSERT INTO fuv_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","سٜيْ يٜىٰسُ نٛدِّٻٜ، وِعِٻٜ، ‏«‏اٛنْ اَنْدِ ندٜرْ يِمْٻٜ نَاع يَحُودَنْکٛعٜنْ، يِمْٻٜ ٻٜ طُمْ اَنْدِرِ لَامُ اٜ کٛلَّ لَامُ سٜمْبٜ، ندٜنْ مَوْٻٜ مَٻّٜ اٜ کٛلَّ ٻُرَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","اَمَّا اٛنٛنْ، تٛع اٛنْ نغَطُ نٛنْ حَکُّندٜ مٛوطٛنْ؞ فُو غِطّٛ وَرْتَ مَوْطٛ ندٜرْ مٛوطٛنْ، دٛولٜ وَرْتَ جَغَّنْتٛوطٛعٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","کَدِنْ فُو غِطّٛ وَرْتَ اَرْدِيطٛ، دٛولٜ اٛ وَرْتَ مَشُّطٛ کٛو مٛيٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","نغَمْ ٻِي نٜطّٛ وَرِي نَاع نغَمْ اٛ جَغَّنٜىٰ، اَمَّا نغَمْ اٛ جَغَّنٛو يِمْٻٜ، اٛ حٛکَّ يٛنْکِ مَاکٛ نغَمْ رِمْطِنْکِ طُطْٻٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","سٜيْ ٻٜ نجٛتِّي غَرِيرِ جٜرِيکٛ؞ يٜىٰسُ اٜ تٛکُّٻٜمٛ حَوْتِ اٜ يِمْٻٜ طُطْٻٜ اٜ مبُرْتٛو غَرِيرِ جٜرِيکٛ، غٛطّٛ بُمْطٛ تٛرٛتٛوطٛ اٜ جٛوطِي حَادٜ طَتَلْ؞ اِنْدٜ مَاکٛ بَرْتِمَاوُسْ، وَاتٛ ٻِي تِمَاوُسْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","ندٜ اٛ نَنِ يٜىٰسُ نَجَرَنْکٜىٰجٛ پَٻّٛتٛو، اٛ فُطِّ نٛدُّکِ اٜ سٜمْبٜ، اٜ مٛ وِعَ، ‏«‏يٜىٰسُ، ٻِطّٛ دَوْدَ، يُرْمِنَنَمْ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","يِمْٻٜ طُطْٻٜ کَٻَنِمٛ مبِعِمٛ اٛ دٜعِّتَ، اَمَّا اٛ ٻٜيْدِ نٛدُّکِ اٜ سٜمْبٜ، اٜ مٛ وِعَ، ‏«‏ٻِطّٛ دَوْدَ، يُرْمِنَنَمْ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","سٜيْ يٜىٰسُ دَرِي، وِعِ، ‏«‏نٛدَّنٜىٰيَمّٛ؞»‏ ٻٜ نٛدِّ بُمْطٛ اٛنْ، ٻٜ مبِعِمٛ، ‏«‏نَنُ بٜلْطُمْ!‏ اُمَّ!‏ اٜ مٛ نٛدُّمَا؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","سٜيْ اٛ حُبِنِ شُدَّارِ مَاکٛ، اٛ اُمِّي جَوْطُمْ، اٛ يَحِ تٛ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","سٜيْ يٜىٰسُ پَمِمٛ، وِعِ، ‏«‏طُمٜ نغِطَّا مِ وَطَنْمَا؟»‏ بُمْطٛ اٛنْ نٛوتِي وِعِ، ‏«‏مٛودِبّٛ، اٜ مِ يِطِ مبُمْتِنَايَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","سٜيْ يٜىٰسُ وِعِمٛ، ‏«‏دِلُّ؞ حٛولَارٜ مَاطَ يَمْطِتِنِيمَ؞»‏ طٛنْ اٜ طٛنْ غِتٜ مَاکٛ مبُمْتِ، اٛ تٛکِّ يٜىٰسُ، ٻٜ ندِلِّدِ؞ ");
INSERT INTO fuv_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","ندٜ ٻٜ ٻَدِي اُرُشَلِيمَ، تٛ غَرِيجٜ بٜتَفَاجِ اٜ بٜتَنِ تٛ حٛشّٜىٰرٜ ندٜ لٜطّٜ جَيْتُنْ، سٜيْ يٜىٰسُ لِلِ تٛکُّٻٜمٛ طِطٛ، ");
INSERT INTO fuv_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","اٛ وِعِٻٜ، ‏«‏نَتّٜىٰ غَرِيٜلْ غٛنْغٜلْ يٜىٰسٛ مٛوطٛنْ؞ اٜ نَتُّکِ مٛوطٛنْ، اٛنْ تَوَيْ مبَبَّ مٛلَ اٜ نغَ حَٻِّي، طُمْ مٜىٰطَايِ وَطَّاکِنغَ؞ ڤِتّٛيٜىٰنغَ نغَدّٛنْغَ طٛعٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","تٛ غٛطّٛ پَمِيعٛنْ، ‏‹‏کٛ وَطِ ڤِتّٛتٛنْغَ؟›‏ مبِعٜىٰمٛ، ‏‹‏مٛودِبّٛ اٜ يِطِ حُوتِرْکِنغَ، اٛ وَطَيْ طُمْ وَرْتِرَنغَ نَاع کٛ نٜىٰٻِ؞›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","سٜيْ ٻٜ نجَحِ ٻٜ تَوِ مبَبَّ مٛلَ نغَنْ اٜ حَٻِّي تٛ دَمُّغَلْ، حَادٜ طَتَلْ؞ اٜ ٻٜ ڤِتَّنغَ، ");
INSERT INTO fuv_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","سٜيْ وٛٻّٜ دَرِيٻٜ طٛنْ پَمِٻٜ مبِعِ، ‏«‏نغَمْ طُمٜ ڤِتّٛتٛنْغَ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","کَمْٻٜ بٛو ٻٜ مبِعِٻٜ کٛ يٜىٰسُ وِعِ، سٜيْ يِمْٻٜ ٻٜنْ اَلِٻٜ ٻٜ ندِلِّدِ اٜ مَاغَ؞ ");
INSERT INTO fuv_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","ٻٜ نجَارَنِنغَ يٜىٰسُ، ٻٜ مبٜعِّتِ شُدَّارِ مَٻّٜ دٛوْ مَغَّ؞ يٜىٰسُ وَطِّينغَ؞ ");
INSERT INTO fuv_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","سٜيْ يِمْٻٜ طُطْٻٜ مبٜعِّتِ شُدَّارِ مَٻّٜ دٛوْ طَتَلْ، وٛٻّٜ بٛو مبٜعِّتِ حَاکٛ کٛ ٻٜ نغٜوٛيِ تٛ سَابٜىٰرٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","يِمْٻٜ وٛنْٻٜ يٜىٰسٛ مَاکٛ اٜ وٛنْٻٜ غَطَ مَاکٛ، اٜ ٻٜ مبِعَ اٜ سٜمْبٜ، ‏«‏حٛسَانَ!‏ اٛ بَرْکِطِنَاطٛ اٛنْ طٛنْ غَرٛيْطٛ ندٜرْ اِنْدٜ جٛومِرَاوٛ!‏ ");
INSERT INTO fuv_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","لَامُ مَامَ مٜىٰطٜنْ دَوْدَ غَرَيْطُمْ طُمْ بَرْکِطِنَاطُمْ!‏ اٜنْ مَنْتُ اَللَّه مٛ دٛوْ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","سٜيْ يٜىٰسُ نَتِّ اُرُشَلِيمَ، اٛ نَتِّ وُرٛ شٜنِينغٛ، اٛ رَارِ کٛو طُمٜ غَطٜتٜىٰطُمْ طٛنْ؞ نغَمْ نَانغٜ حِيرِي، سٜيْ اٛ وُرْتِي، اٛ دِلِّ بٜتَنِ کَنْکٛ اٜ تٛکُّٻٜمٛ سَڤّٛ اٜ طِطٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","ندٜ وٜىٰتِ، اٜ ٻٜ اَلَ بٜتَنِ، يٜىٰسُ نَنِ وٜىٰلٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","اٛ حَيْنِي لٜکِّ اِبِّ غٛودُکِ حَاکٛ، اٛ يَحِ اٛ يِعَ کٛو اٛ حٜٻَيْ اِبّٜ تٛ مَاکِ؞ ندٜ اٛ يٛتِّي تٛ مَاکِ، اٛ تَوَايِ غٛطُّمْ سٜيْ حَاکٛ، نغَمْ نَاع طُمْ شَرٜلْ ٻِکّٛيْ مَاکِ؞ ");
INSERT INTO fuv_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","سٜيْ اٛ وِعِ لٜکِّ کِنْ، ‏«‏تٛع کٛو مٛيٜ ٻٜيْدَ ݧَامُکِ ٻِکّٛيْ دَغَ تٛ مَاطَ!‏»‏ تٛکُّٻٜمٛ بٛو نَنِي کٛ اٛ وِعِ؞ ");
INSERT INTO fuv_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","ندٜ ٻٜ نَتِّ اُرُشَلِيمَ، يٜىٰسُ نَتِّ وُرٛ شٜنِينغٛ، سٜيْ اٛ فُطِّ رِيوُکِ سٛورٛوٻٜ اٜ سٛودٛوٻٜ ندٜرْ مَغّٛ؞ اٛ تَلِّ تٜىٰبُرْجِ غَيْلِتٛوٻٜ شٜىٰدٜ رٛومَنْکٛعٜنْ يَاکِ شٜىٰدٜ وُرٛ شٜنِينغٛ اٜ جٛوطٛرْلٜ شٛورٛوٻٜ ڤٛولِ؞ ");
INSERT INTO fuv_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","اٛ حَطِ کٛو مٛيٜ پَٻّٛدٛو اٜ دٛنْغَلْ ندٜرْ نجَيْرِ وُرٛ شٜنِينغٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","اٛ وِعِٻٜ، ‏«‏طُمْ وِنْدَامَ، اَللَّه وِعِي، ‏‹‏طُمْ نٛدِّرَيْ وُرٛ اَمْ وُرٛ دٛعَارٜ نغَمْ لٜپِّ فُو،›‏ اَمَّا اٛنٛنْ اٛنْ نغَرْتِرِينغٛ لُورٛ وُيْٻٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","مَوْٻٜ اَرْدِيٻٜ دِينَ اٜ مٛودِٻّٜ اَتَّوْرَ نَنِ کٛ يٜىٰسُ وَطِ، سٜيْ ٻٜ نغَطِ کَ طَٻُّتُکِ لَاوٛلْ نٛ ٻٜ مبَرْدَتَمٛ؞ اٜ ٻٜ کُلَمٛ، نغَمْ يِمْٻٜ فُو کَيْطِنِ اٜ اٜکِّتِنٛلْ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","ندٜ نَانغٜ حِيرِ، يٜىٰسُ اٜ تٛکُّٻٜمٛ مبُرْتِي غَرِيرِ ندِنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","سُبَکَ اٜ ٻٜ پَٻّٛو، سٜيْ ٻٜ نغِعِ لٜکِّ اِبِّ کِنْ يٛورِي حَا اٜ طَطِ مَاکِ؞ ");
INSERT INTO fuv_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","بِيتُرُسْ سِفْتٛرِ وِعِ يٜىٰسُ، ‏«‏مٛودِبّٛ، رَارُ!‏ اِبِّ کِنْ طٛنْ کِ لَانُطَا کِ يٛورِي؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","يٜىٰسُ نٛوتِي وِعِٻٜ، ‏«‏کٛولٜىٰ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","اٜ مِ وِعَعٛنْ غٛونغَ، تٛ غٛطّٛ وِعِي حٛشّٜىٰرٜ ندٜعٜ، ‏‹‏دِلُّ، کُبٛطَا حٛورٜ مَاطَ ندٜرْ مبٜىٰلَ،›‏ تٛ اٛ وَطَايِ سٜکٛ ندٜرْ ٻٜرْندٜ مَاکٛ، اَمَّا اٛ حٛولِي کٛ اٛ وِعِ طُمْ وَطَيْ، طُمْ وَطَنَيْمٛطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","نغَمْ نٛنْ اٜ مِ وِعَعٛنْ، فُو کٛ تٛرِيطٛنْ ندٜرْ دٛعَارٜ، کٛولٜىٰ اٛنْ کٜٻِيطُمْ، ندٜنْ طُمْ وَرْتَيْ طُمْ مٛوطٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK11_25‏","071_11_25‏","MRK","11","25‏","26","کٛو ندٜيٜ تٛ اٛنْ ندَرَکٜ اٛنْ نغَطَ دٛعَارٜ، تٛ اٜ وٛودِ مٛ نجٛغِتِيطٛنْ ندٜرْ ٻٜرْطٜ مٛوطٛنْ، نجَافَنٜىٰمٛ، نغَمْ ݧَاکٛ مٛوطٛنْ مٛ دٛوْ مَا يَافَنٛوعٛنْ حَکّٜ مٛوطٛنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","طٛنْمَا يٜىٰسُ اٜ تٛکُّٻٜمٛ نَتِّ اُرُشَلِيمَ؞ يٜىٰسُ اٜ يِيلٛو ندٜرْ وُرٛ شٜنِينغٛ، سٜيْ مَوْٻٜ اَرْدِيٻٜ دِينَ اٜ مٛودِٻّٜ اَتَّوْرَ اٜ مَوْٻٜ يِمْٻٜ نغَرِ تٛ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ٻٜ مبِعِمٛ، ‏«‏اٜ لَامُ مٛيٜ نغَطَتَا کُوطٜ طٜعٜ؟ مٛيٜ حٛکُّمَا لَامُ وَطُکِطٜ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","يٜىٰسُ نٛوتِي وِعِٻٜ، ‏«‏مِ پَمَيْعٛنْ پَمٛلْ غٛعٛ؞ نٛوتَنٜىٰيَمْ، ندٜنْ مِ وِعَيْعٛنْ اٜ طُمٜ لَامُ نغَطِرَيْمِ کُوطٜ طٜعٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","بَڤْتِسْمَ طُمْ يَحَيَ وَطِ، تٛ اَللَّه طُمْ پِوٛيِ، کٛو تٛ يِمْٻٜ طُمْ پِوٛيِ؟ نٛوتَنٜىٰيَمْ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","سٜيْ ٻٜ مٜدِّ حَکُّندٜ مَٻّٜ، ٻٜ مبِعِ، ‏«‏تٛ اٜنْ مبِعِي، ‏‹‏دَغَ تٛ اَللَّه طُمْ پِوٛيِ،›‏ اٛ وِعَيْ، ‏‹‏کٛ وَطِ اٛنْ جَٻَايِ کٛ اٛ وِعِ؟›‏ ");
INSERT INTO fuv_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","اَمَّا تٛ اٜنْ مبِعِي، ‏‹‏تٛ يِمْٻٜ طُمْ پِوٛيِ…›‏ »‏ ٻٜ مبِعُ نٛنْ نغَمْ اٜ ٻٜ کُلَ يِمْٻٜ، نغَمْ کٛو مٛيٜ جَٻِي يَحَيَ اٛ اَنَّبِيجٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","سٜيْ ٻٜ نٛوتِي ٻٜ مبِعِ يٜىٰسُ، ‏«‏مِنْ اَنْدَا؞»‏ يٜىٰسُ وِعِٻٜ، ‏«‏نٛنْ مِنْ مَا، مِ وِعَتَاعٛنْ کٛو اٜ طُمٜ لَامُ نغَطِرَيْمِ کُوطٜ طٜعٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","سٜيْ يٜىٰسُ فُطِّ مٜتِرَنْکِٻٜ اٜ مِسَالُ، وِعِ، ‏«‏غٛطّٛ نٜطّٛ وَطِ نغٜسَ اِنَبٛوجٜ، اٛ حٛوِکَ، اٛ وَسِ نغَيْکَ مَوْکَ ندٜرْ تَفَارٜ نغَمْ مٛيْلُکِ ندِيَمْ دَغَ ندٜرْ اِنَبٛوجٜ طٜنْ، اٛ مَحِ سُودُ تٛوْندُ نغَمْ رٜىٰنُکِ نغٜسَ کَنْ؞ سٜيْ اٛ حٛکِّکَ وٛٻّٜ رٜمٛوٻٜ مٛعِّنَکَ، اٛ دِلِّ وٛنْدِ لٜيْدِ؞ ");
INSERT INTO fuv_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","ندٜ شَرٜلْ ٻٜنْدُکِ اِنَبٛوجٜ طٜنْ وَطِ، اٛ لِلِ مَشُّطٛ مَاکٛ تٛ يِمْٻٜ ٻٜ اٛ حٛکِّ نغٜسَ کَنْ نغَمْ اٛ جَٻَنٛيَمٛ کٛ ٻٜ نغَادُنٛو ندٜرْ کٛ ٻٜنْدِ؞ ");
INSERT INTO fuv_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","اَمَّا ٻٜ نَنْغِ مَشُّطٛ اٛنْ، ٻٜ ڤِيِمٛ، ٻٜ ندِيوِمٛ کٛو کٛ ٻٜ کٛکِّمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","سٜيْ جٛومُ نغٜسَ اٛنْ فُطِّتِ لِلِ غٛطّٛ مَشُّطٛ تٛ مَٻّٜ، کَنْکٛ مَا ٻٜ ڤِيَنِمٛ حٛورٜ، ٻٜ کُطِکُطِنِمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","سٜيْ اٛ فُطِّتِ اٛ لِلِ غٛطّٛ مَشُّطٛ، کَنْکٛ بٛو ٻٜ مبَرِمٛ؞ اٛ لِلِلِلِنِي مَشُّٻٜ طُطْٻٜ؞ ٻٜ ڤِيِ وٛٻّٜ، ٻٜ مبَرِ وٛٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","جٛومُ نغٜسَ کَنْ اٜ وٛودِ غٛعٛتٛ مٛ اٛ لِلَايِ، وَاتٛ ٻِطّٛ مَاکٛ مٛ اٛ يِطِ؞ غَطَ مَاجُمْ فُو اٛ لِلِ ٻِطّٛ اٛنْ تٛ مَٻّٜ، اٛ وِعِ، ‏‹‏ٻٜ کٛکَّيْ ٻِطّٛ اَمْ مَنْغُ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","اَمَّا ٻٜ اٛ حٛکِّ نغٜسَ ٻٜنْ مبِعِ حَکُّندٜ مَٻّٜ، ‏‹‏تٛو!‏ رَا دٛنٛووٛ نغٜسَ کَنْ؞ نغَرٜىٰ مبَرٜنْمٛ، ندٛنُ نغٜسَ کَنْ وَرْتَ طُمْ مٜىٰطٜنْ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","سٜيْ ٻٜ نَنْغِمٛ ٻٜ مبَرِمٛ، ٻٜ ڤَطِّمٛ غَطَ نغٜسَ کَنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","‏«‏تٛو، کٛ جٛومُ نغٜسَ کَنْ وَطَتَ؟ اٛ وَرَيْ اٛ حَلْکَٻٜ، اٛ حٛکَّ وٛٻّٜ نغٜسَ کَنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","اٛنْ مٜىٰطَايِ جَنْغُکِ کٛ اَايَارٜ وِعِ؟ ندٜ وِعِي، ‏‹‏حَيْرٜ ندٜ مَحٛوٻٜ نغَݧِ کَيْرٜ وَرْتِ حَيْرٜ ٻُرْندٜ دَرْنُکِ مَادِ؞ ");
INSERT INTO fuv_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","طُعُمْ طُمْ کُوغَلْ جٛومِرَاوٛ، طُمْ کَيْطِنِيطُمْ تٛ مٜىٰطٜنْ؞›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","دَغَ طٛنْ سٜيْ مَوْٻٜ ٻٜنْ طَٻِّتِ لَاوٛلْ نٛ ٻٜ نَنْغِرْتَمٛ، نغَمْ اٜ ٻٜ اَنْدِ دٛوْ مَٻّٜ اٛ حٛکِّ مِسَالُ طُمْ، اَمَّا اٜ ٻٜ کُلَ يِمْٻٜ؞ نغَمْ نٛنْ ٻٜ اَلِمٛ، ٻٜ ندِلِّ؞ ");
INSERT INTO fuv_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","غَطَ مَاجُمْ ٻٜ لِلِ وٛٻّٜ فَارِسَنْکٛعٜنْ اٜ وٛٻّٜ يِمْٻٜ حِرُدُسْ تٛ يٜىٰسُ نغَمْ ٻٜ کٜٻَ کٛ ٻٜ نَنْغِرْتَمٛ ندٜرْ مٜتٛ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","ٻٜ نغَرِ تٛ يٜىٰسُ، ٻٜ مبِعِمٛ، ‏«‏مٛودِبّٛ، اٜ مِنْ اَنْدِ کٛ مبِعَتَا اٜ کٛ نغَطَتَا طُمْ غٛونغَ؞ اَ حٛلَّتَا فٜىٰرٛوتِرٛلْ حَکُّندٜ يِمْٻٜ، نغَمْ اَ حٛشِّي يِمْٻٜ فُو اٜ ڤٛتِّدِ؞ طٛنْمَا اَ اٜکِّتِنَ لَاوٛلْ اَللَّه اٜ غٛونغَ؞ تٛو، وِعُمِنْ، اٜ طُمْ حَانِ مِنْ نجٛٻَ کَيْسَرْ مَوْطٛ لَامِيٻٜ شٜىٰدٜ لٜيْدِ، کٛو طُمْ حَانَايِ؟ ");
INSERT INTO fuv_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","مِنْ نجٛٻَ شٜىٰدٜ لٜيْدِ، کٛو تٛع مِنْ نجٛٻَ؟»‏ اَمَّا يٜىٰسُ اٜ اَنْدِ اٜ ٻٜ نغِطِ پٛيْرُکِمٛ، سٜيْ اٛ وِعِٻٜ، ‏«‏نغَمْ طُمٜ ڤٛوندٛتٛنْيَمْ؟ نغَدَّنٜىٰيَمْ يَمْندٜ اَجُرْفَارِ مِ رَارَندٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","ٻٜ نغَدَّنِمٛ يَمْندٜ غٛعٛ؞ اٛ وِعِٻٜ، ‏«‏طٛوْدِ مٛيٜ اٜ اِنْدٜ مٛيٜ وٛنِ دٛوْ مَيْرٜ؟»‏ ٻٜ نٛوتِي ٻٜ مبِعِ، ‏«‏طُمْ کَيْسَرْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","سٜيْ يٜىٰسُ وِعِٻٜ، ‏«‏تٛو، کٛکّٜىٰ کَيْسَرْ کٛ وٛنِ طُمْ کَيْسَرْ، ندٜنْ کٛکّٛنْ اَللَّه کٛ وٛنِ طُمْ اَللَّه؞»‏ سٜيْ اٛ حَيْطِنِٻٜ نَاع سٜطَّ؞ ");
INSERT INTO fuv_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","سَادُسَنْکٛعٜنْ اٜ مبِعَ وَلَا اُمَّاکِ مَيْٻٜ؞ وٛٻّٜ مَٻّٜ نغَرِ تٛ يٜىٰسُ، ٻٜ پَمِمٛ، ٻٜ مبِعِ، ");
INSERT INTO fuv_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","‏«‏مٛودِبّٛ، اَنَّبِ مُوسَ وِعِي تٛ نٜطّٛ تٜعِي دٜبّٛ مَايِي دَݧِدَايِ اٜ مَاکٛ، سَکِرَاوٛ مَاکٛ سٜيْ تٜعَمٛ نغَمْ حٜٻَنَ مَيْطٛ اٛنْ ٻِٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","تٛو، ندٜنّٛ اٜ وٛودِ وٛٻّٜ سَکِرَاٻٜ وٛرْٻٜ نجٛوٜىٰطِطٛ؞ اَفٛ اٛنْ تٜعِ، مَايِ، اَلِ دٜبّٛ وَلَا ٻِطّٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","سٜيْ طِطَٻٛ اٛنْ تٜعِ دٜبّٛ اٛنْ؞ کَنْکٛ مَا اٛ مَايِ، اٛ اَلِ دٜبّٛ اٛنْ وَلَا ٻِطّٛ؞ تَتَٻٛ اٛنْ مَا نٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ٻٜ فُو نجٛوٜىٰطِطٛ ٻٜنْ ٻٜ تٜعِي دٜبّٛ اٛنْ، ٻٜ مَايِ، ٻٜ اَلِمٛ وَلَا ٻِطّٛ؞ غَطَ طٛنْ دٜبّٛ اٛنْ مَا مَايِ؞ ");
INSERT INTO fuv_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","تٛو، ݧَلْندٜ ندٜ مَيْٻٜ اُمّٛتٛو، دٜبّٛ اٛنْ وَرْتَيْ دٜبّٛ مٛيٜ ندٜرْ مَٻّٜ؟ نغَمْ ٻٜ فُو نجٛوٜىٰطِطٛ ٻٜ تٜعِيمٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","سٜيْ يٜىٰسُ نٛوتِي وِعِٻٜ، ‏«‏اٛنْ مبٛوفِي نغَمْ اٛنْ اَنْدَا کٛ اَايَاجٜ مبِعِ، ندٜنْ اٛنْ اَنْدَا بَوْطٜ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","تٛ مَيْٻٜ اُمَّکٜ دَغَ مَيْدٜ، وَلَا تٜعَيْطٛ وَلَا تٜعٜتٜىٰطٛ، اَمَّا ٻٜ نغَرْتَيْ بٛ مَلَاعِکَعٜنْ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","ندٜنْ دٛوْ اُمَّاکِ مَيْٻٜ دَغَ مَيْدٜ، اٛنْ جَنْغَايِ دٜفْتٜرٜ مُوسَ دٛوْ حَبَرُ لٜغّٜلْ غٛودُنغٜلْ حِيتٜ؟ اَللَّه وِعِيمٛ، ‏‹‏مِنْ وٛنِ اَللَّه مٛ اِبْرَاهِمْ، اَللَّه مٛ اِشِيَاکُ، اَللَّه مٛ يَاکُبُ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","کَنْکٛ نَاع اٛ اَللَّه مَيْٻٜ، اَمَّا اٛ اَللَّه غٛودُٻٜ يٛنْکِ؞ اٛنْ مَجِّ نَاع سٜطَّ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","غٛعٛتٛ ندٜرْ مٛودِٻّٜ اَتَّوْرَ وَرِ نَنِ اٜ ٻٜ نغٜدّٛوتِرَ حَکُّندٜ مَٻّٜ؞ ندٜ اٛ نَنِ يٜىٰسُ نٛوتَنَکٜٻٜ بٛطُّمْ، سٜيْ اٛ پَمِ يٜىٰسُ، اٛ وِعِ، ‏«‏ندٜرْ دٛوکَاجِ طِ اَللَّه وَطِ، طُمٜ ٻُرِ مَنْغُ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","يٜىٰسُ نٛوتِي وِعِ، ‏«‏ٻُرْطُمْ مَنْغُ وٛنِ، ‏‹‏يِمْٻٜ اِسْرَاعِيلَ نَنٜىٰ، اَللَّه جٛومِرَاوٛ مٜىٰطٜنْ اٛ جٛومِرَاوٛ غٛعٛتٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","يِطُ اَللَّه جٛومِرَاوٛ مَاطَ اٜ ٻٜرْندٜ مَاطَ فُو، اٜ يٛنْکِ مَاطَ فُو، اٜ حَکِّيلٛ مَاطَ فُو، اٜ سٜمْبٜ مَاطَ فُو؞›‏ ");
INSERT INTO fuv_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","طِطَٻُمْ بٛو وٛنِ، ‏‹‏يِطُ بَنْدِرَاوٛ مَاطَ نٛ نغِطِرْطَا حٛورٜ مَاطَ؞›‏ ندٜرْ دٛوکَاجِ طِ اَللَّه وَطِ وَلَا ٻُرْطُمْ طِعِ طِطِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","سٜيْ مٛودِبّٛ اَتَّوْرَ اٛنْ وِعِ، ‏«‏مٛودِبّٛ، اَ وِعِي غٛونغَ ندٜ مبِيطَا اَللَّه اٛ غٛعٛتٛ، وَلَا غٛطّٛ سٜيْ کَنْکٛ تَنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","نٜطّٛ يِطَمٛ اٜ ٻٜرْندٜ مُوطُمْ فُو، اٜ فَامُ مُوطُمْ فُو، اٜ سٜمْبٜ مُوطُمْ فُو، ندٜنْ يِطَ بَنْدِرَاوٛ مُوطُمْ نٛ يِطِرِ حٛورٜ مُوطُمْ، طُمْ ٻُرِي مَرْلٜ غُلَنْتٜىٰطٜ اَللَّه اٜ فُو کٛ طُمْ سَکَّنْتَمٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","ندٜ يٜىٰسُ نَنِ اٛ نٛوتٛرَکٜ فَامُ، سٜيْ وِعِمٛ، ‏«‏غٛونغَ اَ وٛطِّدَا اٜ لَامُ اَللَّه؞»‏ غَطَ مَاجُمْ وَلَا غَطُطٛ سٜمْبٜ ٻٜرْندٜ پَمِمٛ وٛنْغٛلْ پَمٛلْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","يٜىٰسُ اٜ اٜکِّتِنَ ندٜرْ نجَيْرِ وُرٛ شٜنِينغٛ، سٜيْ اٛ پَمِ، اٛ وِعِ، ‏«‏نغَمْ طُمٜ مٛودِٻّٜ اَتَّوْرَ اٜ مبِعَ اَلْمَسِيحُ اٛ ٻِطّٛ دَوْدَ؟ ");
INSERT INTO fuv_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","نغَمْ دَوْدَ اٜ حٛورٜ مُوطُمْ، ندٜرْ بَوْطٜ رُوحُ اَللَّه اٛ وِعِي، ‏‹‏جٛومِرَاوٛ وِعِي جٛومِرَاوٛ اَمْ، ‏«‏جٛوطَ تٛ جُنْغٛ اَمْ ݧَامٛ، نَا مِ وَطِي اَ يَاٻِي وَݧْوَݧْٻٜ مَاطَ؞»‏ ›‏ ");
INSERT INTO fuv_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","دَوْدَ اٜ حٛورٜ مُوطُمْ نٛدِّرِيمٛ جٛومِرَاوٛ؞ تٛو، نٛ وَطَتَ اَلْمَسِيحُ وَرْتَ ٻِطّٛ دَوْدَ؟»‏ يِمْٻٜ طُطْٻٜ کَوْرُتُٻٜ کٜتِّندَنِيمٛ ندٜرْ وٜلْوٜلٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","يٜىٰسُ اٜ اٜکِّتِنَ، وِعِ، ‏«‏ڤَامَنٜىٰ مٛودِٻّٜ اَتَّوْرَ، غِطُٻٜ يِيلَاکِ اٜ ٻٛرْنِي تٛغّٛحٛ نجُوتُکٛ، غِطُٻٜ حٛوْنِرٜىٰکِ مَنْغُ ندٜرْ لُومٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","اٜ ٻٜ نغِطِ جٛوطَاکِ دٛوْ جٛوطٛرْلٜ مَوْٻٜ ندٜرْ شُوطِ دٛعَارٜ اٜ جٛوطٛرْلٜ مَوْٻٜ تٛ حُمْتٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","کَمْٻٜ نغٛنِ ݧَامٛوٻٜ جَوْدِ رٜوْٻٜ ٻٜ وٛرْٻٜ مُعّٜنْ مَايِ حَا اٜ غُرٜ مَٻّٜ، اٜ ٻٜ نغَطَ دٛعَارٜ جُوتُندٜ نغَمْ طُمْ يِعَٻٜ؞ اِرِ ٻٜنْ طٛنْ يِمْٻٜ طُمْ وَطَنَيْٻٜ کِيتَ ٻُرْکَ حَلُّکِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","يٜىٰسُ جٛوطِي ندٜرْ وُرٛ شٜنِينغٛ حَادٜ تٛ طُمْ حٛکَّتَ شٜىٰدٜ نغَمْ اَللَّه؞ اٜ مٛ رَارَ يِمْٻٜ اٜ ٻٜ نغَطَ شٜىٰدٜ مَٻّٜ ندٜرْ تٛ طُمْ حٛکَّتَ شٜىٰدٜ نغَمْ اَللَّه؞ رِسْکُٻٜ طُطْٻٜ نغَطِ شٜىٰدٜ طُطّٜ ندٜرْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","سٜيْ رَا غٛطّٛ دٜبّٛ مٛ وَلَنَا مٛ غٛرْکٛ مُوطُمْ مَايِ؞ اٛ وَرِ اٛ وَطِ شٜىٰدٜ نجَمْکٛيْ طِطٛيْ کٛيْ نجَمْندِ مبٛطٜىٰرِ ندٜرْ؞ طُمْ شٜىٰدٛيْ سٜطَّنَحٛيْ تَنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","سٜيْ يٜىٰسُ نٛدِّ تٛکُّٻٜمٛ، وِعِٻٜ، ‏«‏اٜ مِ وِعَعٛنْ غٛونغَ، اٛعٛ دٜبّٛ مٛ وَلَنَا، کٛ اٛ حٛکِّ طُمْ ٻُرِي کٛ حٛرِيٻٜ فُو کٛکِّ؞ ");
INSERT INTO fuv_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","نغَمْ کَمْٻٜ ٻٜ کٛکِّ دَغَ ندٜرْ رِسْکُ مَٻّٜ؞ اَمَّا کَنْکٛ بٛو، دَغَ ندٜرْ شِيَ مَاکٛ، اٛ حٛکِّ فُو کٛ اٛ وٛودِ، وَاتٛ کٛو طُمٜ طُمْ اٛ مَرٛرْتٛو؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","يٜىٰسُ اٜ وُرْتٛيٛو وُرٛ شٜنِينغٛ، سٜيْ غٛعٛتٛ ندٜرْ تٛکُّٻٜمٛ وِعِمٛ، ‏«‏مٛودِبّٛ، رَارُ کَاپٜ مَوْطٜ طٜ طُمْ مَحِرِ وُرٛ نغٛعٛ!‏ رَارُ نٛ مَادِ ندِنْ وٛوطِرِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","سٜيْ يٜىٰسُ وِعِمٛ، ‏«‏اَ يِعِي ندِعِ مَادِ مَوْندِ؟ وَلَا وٛنْدٜ حَيْرٜ اَلٜتٜىٰندٜ دٛوْ وٛنْدٜ؞ طٜ فُو طُمْ سَنْکِتَيْطٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","يٜىٰسُ اٜ جٛوطِي دٛوْ حٛشّٜىٰرٜ ندٜ لٜطّٜ جَيْتُنْ دَارَيْندٜ وُرٛ شٜنِينغٛ، سٜيْ بِيتُرُسْ، اٜ يَاکُبُ، اٜ يَحَيَ، اٜ اَنْدِرَاوُسْ ٻٜ نجَحِ تٛ مَاکٛ کَمْٻٜ تَنْ، ٻٜ پَمِمٛ ٻٜ مبِعِ، ");
INSERT INTO fuv_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","‏«‏وِعُمِنْ، ندٜيٜ فِي طُعُمْ وَطَتَ؟ طُمٜ وٛنِ کٛ حٛلَّتَ فُو فِي طُعُمْ ٻَدَکٜ حٜىٰوَ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","سٜيْ يٜىٰسُ وِعِٻٜ، ‏«‏ڤَامٜىٰ تٛع غٛطّٛ مَجِّنَعٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","يِمْٻٜ طُطْٻٜ نٛدِّرَيْ کٛعٜ مَٻّٜ اِنْدٜ اَمْ، ٻٜ مبِعَ ‏‹‏مِنْ وٛنِ اَلْمَسِيحُ،›‏ ٻٜ مَجِّنَ يِمْٻٜ طُطْٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","تٛ اٛنْ نَنِي حَبَرُ کٛنُوجِ غَطٜتٜىٰطِ حَادٜ مٛوطٛنْ، اٜ کٛنُوجِ غَطٜتٜىٰطِ ٻَدَاکِ، تٛع اٛنْ کُلُ؞ دٛولٜ طُعُمْ وَطَ، اَمَّا رٜعُکِ دُونِيَارُ اٜ حٛرِي تَوْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","لٜݧٛلْ اُمَّنْتٛ لٜݧٛلْ، لَامُ اُمَّنْتٛ لَامُ؞ طُمْ وَطَيْ وٜىٰلٛ کَلُّنغٛ اٜ دِمْبٛلْ لٜيْدِ تٛ بِغٜىٰجٜ فٜىٰرٜ‑فٜىٰرٜ؞ طُعُمْ طُمْ فُطّٛودٜ تٛرَّاجِ غَرَيْطِ؞ ");
INSERT INTO fuv_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","‏«‏اَمَّا ڤَامَنٜىٰ کٛعٜ مٛوطٛنْ؞ ٻٜ نغَطَيْعٛنْ ندٜرْ جُوطٜ مَوْٻٜ شُوطِ دٛعَارٜ، طُمْ ڤِيَعٛنْ ندٜرْ شُوطِ دٛعَارٜ طِنْ؞ نغَمْ اٛنْ تٛکُّٻٜيَمْ طُمْ يَارَيْعٛنْ يٜىٰسٛ مَوْٻٜ لٜيْدِ اٜ لَامِيٻٜ، نٛنْ وَرْتَيْ لَاوٛلْ نٛ کٛکِّرْتٛنْٻٜ حَبَرُ اَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","اَمَّا کٛ رٜعِرْدٜ دُونِيَارُ وَرَ، دٛولٜ طُمْ اَرْتَ وَعَجِنْکِ حَبَرُ بٜلْطُمْ ندٜرْ فُو لٜپِّ دُونِيَارُ؞ ");
INSERT INTO fuv_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","فُو شَرٜلْ نغٜلْ طُمْ نَنْغِعٛنْ طُمْ يَارِعٛنْ يٜىٰسٛ لَامُ، تٛع اٛنْ نغَنُّ دٛوْ کٛ مبِعٛتٛنْ؞ اٜ شَرٜلْ نغٜلْ اَللَّه حٛکَّيْعٛنْ کٛ مبِعٛتٛنْ، سٜيْ مبِعٛنْکَ؞ نغَمْ نَاع طُمْ اٛنٛنْ مٜتَتَ، اَمَّا طُمْ رُوحُ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","نٜطّٛ حٛکِّتِرَيْ سَکِرَاوٛ مُوطُمْ طُمْ وَرَمٛ، ݧَاکٛ مَا حٛکِّتِرَيْ ٻِطّٛ مُوطُمْ؞ ٻِٻّٜ اُمَّنْتٛ دَݧٛوٻٜ مَٻّٜ، ٻٜ نغَطَ طُمْ وَرَٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","کٛو مٛيٜ وَݧَيْعٛنْ نغَمْ اٛنْ تٛکُّٻٜيَمْ؞ اَمَّا مُݧُطٛ حَا رٜعِرْدٜ حِسَيْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","‏«‏شَرٜلْ اٜ وَرَ نغٜلْ نغِعٛتٛنْ ‏‹‏نٜفْنِيطُم›‏ غَرْتِرٛوجُمْ وُرٛ شٜنِينغٛ نغٛ لَاٻَا اٜ دَرِي تٛ وِغٜىٰرٜ ندٜ حَانَا؞ فُو جَنْغٛووٛ فَامَ مَعَنَ مَاجُمْ؞ اٜ شَرٜلْ نغٜلْ وٛنْٻٜ ندٜرْ لٜيْدِ يَحُودِيَ ندٛغَّ نَتّٛيَ کٛشّٜىٰجٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","غٛنْطٛ دٛوْ سُودُ تٛع جِڤّٛيٛو کٛو نَتَّ وُرٛ نغَمْ حٛشُّکِ غٛطُّمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","غٛنْطٛ تٛ نغٜسَ تٛع سٛعّٛ حٛشَّ شُدَّارِ مُوطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","رٜوْٻٜ غٛودُٻٜ دٜىٰطِ اٜ مُسِنْتٜىٰٻٜ ٻٜ تٛرّٛتٛ نَاع سٜطَّ ندٜرْ طٜنْ طٛنْ بَلْطٜ!‏ ");
INSERT INTO fuv_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","نغَطٜىٰ دٛعَارٜ تٛع فِي طُعُمْ وَطَ ندٜرْ ندُنْغُ؞ ");
INSERT INTO fuv_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","نغَمْ ندٜرْ طٜنْ طٛنْ بَلْطٜ طُمْ وَطَيْ تٛرَّ کَلُّکَ اِرِ کَ طُمْ مٜىٰطَايِ وَطُکِ دَغَ شَرٜلْ نغٜلْ اَللَّه تَغِ دُونِيَارُ حَا جٛونِ؞ طُمْ بٛو فُطِّتَتَا طُمْ وَطَ اِرِ کَنْ طٛنْ تٛرَّ؞ ");
INSERT INTO fuv_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","دَا جٛومِرَاوٛ اُسْتَايِ طٜنْ طٛنْ بَلْطٜ، دَا وَلَا غٛطّٛ کِسَيْطٛ؞ اَمَّا نغَمْ ٻٜنْ طٛنْ شُٻَاٻٜ مَاکٛ ٻٜ اٛ سُٻِ، اٛ اُسْتِي بَلْطٜ طٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","‏«‏اٜ نغٜلْ طٛنْ شَرٜلْ تٛ غٛطّٛ وِعِيعٛنْ، ‏‹‏رَا اَلْمَسِيحُ طٛعٛ!‏›‏ کٛو بٛو، ‏‹‏رَمّٛ طَاعٜ!‏›‏ تٛع اٛنْ نجَٻُ؞ ");
INSERT INTO fuv_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","نغَمْ اَلْمَسِيحُعٜنْ فٜوْرٜ اٜ اَنَّبٛعٜنْ فٜوْرٜ ٻٜ مبُرْتٛيْتٛ ٻٜ نغَطَ اَلَامَاجِ اٜ کُوطٜ کَيْطِنِيطٜ نغَمْ ٻٜ مَجِّنَ يِمْٻٜ، حَا اٜ شُٻَاٻٜ ٻٜنْ تٛ طُمْ وَطٛتٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","ندَرٜىٰ، اٛنْ ندٜىٰنَ!‏ مِ وِعِيعٛنْ کٛو طُمٜ کٛ شَرٜلْ نغٜلْ وَرَ؞ ");
INSERT INTO fuv_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","‏«‏اَمَّا ندٜرْ طٜنْ طٛنْ بَلْطٜ غَطَ کَنْ طٛنْ تٛرَّ کَلُّکَ، طُمْ ٻَلْوِنَيْ نَانغٜ، لٜوْرُ بٛو حٛکَّتَا جَيْنغٛلْ مَيْرُ؞ ");
INSERT INTO fuv_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","کٛودٜ نجَنٛيَيْ دَغَ دٛوْ، ندٜنْ کٛ وٛنِ دٛوْ فُو دِمْبٛتٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","اٜ شَرٜلْ نغٜلْ طُمْ يِعَيْ ٻِي نٜطّٛ اٜ وَرَ ندٜرْ دُولٜ؞ اٛ وَرْدَيْ اٜ بَوْطٜ مَوْطٜ اٜ تٜدُّنغَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","اٛ لِلٛيَيْ مَلَاعِکَعٜنْ مَاکٛ ٻٜ کَوْرِتَ ٻٜ اٛ سُٻِ دَغَ کٛو تٛيٜ ندٜرْ دُونِيَارُ، دَغَ نغٛعٛلْ کٜىٰرٛلْ دُونِيَارُ يَاکِ نغٛلْ تٛنْ کٜىٰرٛلْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","‏«‏تٛو، اٜکِّتٜىٰ اٜکِّتِنٛلْ نغٛعٛلْ دَغَ تٛ لٜکِّ اِبِّ؞ تٛ لِشٜ مَاکِ ڤُطِّي وِلُتُکِ، اٛنْ اَنْدِ ندُنْغُ ٻَدَکٜ وٛنْ طٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","نٛنْ مَا تٛ اٛنْ نغِعِي فِي طُعُمْ اٜ وَطَ، تٛو، اٛنْ اَنْدَيْ ٻِي نٜطّٛ ٻَدَکٜ وَرْتٛيَ، اٜ مٛ حَادٜ دَمُّغَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","اٜ مِ وِعَعٛنْ غٛونغَ، جَامَنُ طُعُمْ طُمْ رٜعَتَا نَا فُو فِي طُعُمْ وَطِي؞ ");
INSERT INTO fuv_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","دٛوْ اٜ لٜيْ پَٻّٛتٛ، اَمَّا بٛلِيطٜ اَمْ پَٻَّتَاکٛ حَا اَبَدَا؞ ");
INSERT INTO fuv_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","‏«‏وَلَا اَنْدُطٛ ندٜنْ طٛنْ ݧَلْندٜ کٛو نغٜلْ طٛنْ شَرٜلْ نغٜلْ فِي طُمْ طٛنْ وَطَتَ؞ کٛو مَلَاعِکَعٜنْ وٛنْٻٜ دٛوْ اَنْدَا، ٻِطّٛ اٛنْ مَا اَنْدَا، سٜيْ ݧَاکٛ مٛ دٛوْ تَنْ اَنْدِ؞ ");
INSERT INTO fuv_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","ڤَامٜىٰ، نجٛوطٜىٰ اٛنْ شِرْيِي، نغَمْ اٛنْ اَنْدَا کٛ شَرٜلْ نغٜلْ وَرَتَ؞ ");
INSERT INTO fuv_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","طُمْ بٛ نٜطّٛ غَطُطٛ يَادُ؞ ندٜ اٛ وَرِ دِلُّکِ اٛ اَلِ وُرٛ مَاکٛ ندٜرْ جُوطٜ مَشُّٻٜ مَاکٛ، اٛ حٛکِّ کٛو مٛيٜ کُوغَلْ نغَلْ وَطَتَ، اٛ وِعِ دٜىٰنٛووٛ دَمُّغَلْ نغَلْ اٛ دَرٛو اٜ مٛ رٜىٰنَ؞ ");
INSERT INTO fuv_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","نغَمْ نٛنْ، نجٛوطٜىٰ اٛنْ ندٜىٰنَ نغَمْ اٛنْ اَنْدَا شَرٜلْ نغٜلْ جٛومُ وُرٛ نغٛنْ وَرْتٛيْتَ، کٛو طُمْ فُتُرٛ، کٛو طُمْ شَکَ جٜمَّ، کٛو طُمْ فَجِرِ، کٛو طُمْ سُبَکَ؞ ");
INSERT INTO fuv_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","تٛ اٛ وَرْتِي وَلَا اَنْدُطٛ، تٛع اٛ تَوَ اٛنْ طَانِي؞ ");
INSERT INTO fuv_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","کٛ مبِيمِعٛنْ، اٜ مِ وِعَکَ کٛو مٛيٜ، کَنْجُمْ وٛنِ نجٛوطٜىٰ اٛنْ شِرْيِي!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","حٛرِي بَلْطٜ طِطِ طُمْ وَطَ حُمْتٛ سَکِّنْکِ اٜ حُمْتٛ بُرٛودِ طُمْ وَلَا پُوفِنِرْطُمْ؞ مَوْٻٜ اَرْدِيٻٜ دِينَ اٜ مٛودِٻّٜ اَتَّوْرَ اٜ طَٻِّتَ لَاوٛلْ نٛ ٻٜ نَنْغِرْتَ يٜىٰسُ اٜ سُوطٜ ٻٜ مبَرَمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","ٻٜ مبِعِ، ‏«‏اَمَّا نَاع نِ شَرٜلْ حُمْتٛ، نغَمْ تٛع يِمْٻٜ اُمِّنَ حَوْرٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","يٜىٰسُ اٜ ندٜرْ غَرِيرِ بٜتَنِ تٛ وُرٛ سِيمَنْ غٛودُطٛ ݧَوُ ݧَامٛوجُمْ لَرَلْ؞ اٜ مٛ ݧَامَ ݧَمْندُ، سٜيْ غٛطّٛ دٜبّٛ وَرِ اٜ جٛغِي جٛلّٛيٜلْ حَيْرٜ بٛنْغٜلْ نغٜلْ نٜبَّمْ اُرٛوجَمْ مبٜلْطَمْ طَمْ طُمْ وَطِرِ نَرْدِ غٛودُطَمْ شٜىٰدٜ؞ سٜيْ اٛ مَٻِّتِنغٜلْ، اٛ وَيْلِ نٜبَّمْ طَمْ دٛوْ حٛورٜ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","وٛٻّٜ غٛنْٻٜ طٛنْ ٻٜ مٛنِّ ٻٜ مبِعِ حَکُّندٜ مَٻّٜ، ‏«‏نغَمْ طُمٜ اٛ وٛنِّ نٜبَّمْ طَعَمْ نِحِ؟ ");
INSERT INTO fuv_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","دَا طَمْ سٛورَامَ، دَا طُمْ حٜٻِي شٜىٰدٜ ٻُرْطٜ طٜ طُمْ يٛٻَتَ کُوٛووٛ حِتَاندٜ غٛعٛ، طُمْ حٛکَّطٜ ٻٜ نغَلَنَا؞»‏ ٻٜ کَٻَنِ دٜبّٛ اٛنْ سٜمْبٜىٰ؞ ");
INSERT INTO fuv_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","اَمَّا يٜىٰسُ وِعِٻٜ، ‏«‏اَلٜىٰمٛ؞ نغَمْ طُمٜ نغَنّٛتٛنْمٛ؟ کٛ اٛ وَطَنِيَمْ طُمْ بٛطُّمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","کٛو ندٜيٜ ٻٜ نغَلَنَا اٜ نغٛنْدِ اٜ مٛوطٛنْ، اٛنْ مبَاوَيْ وَلُّکِٻٜ فُو شَرٜلْ نغٜلْ نغِطّٛنْ؞ اَمَّا مِنْ، شَرٜلْ اٜ وَرَ نغٜلْ اَلَيْمِعٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","اٛعٛ دٜبّٛ وَطِي کٛ اٛ وَاوَتَ وَطُکِ؞ اٛ وَيْلَنِي ٻَنْدُ اَمْ نٜبَّمْ نغَمْ سِرْيَاکِ اُوُکِيَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","اٜ مِ وِعَعٛنْ غٛونغَ، کٛو تٛيٜ تٛ طُمْ وَعَجِنِ حَبَرُ بٜلْطُمْ ندٜرْ دُونِيَارُ فُو، طُمْ حٛکَّيْ حَبَرُ کٛ دٜبّٛ اٛعٛ وَطِ نغَمْ سِفْتٛرْکِمٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","سٜيْ غٛعٛتٛ ندٜرْ تٛکُّٻٜ يٜىٰسُ سَڤّٛ اٜ طِطٛ بِعٜتٜىٰطٛ يَحُودَ اِسْکَرِيٛوتِ يَحِ تٛ مَوْٻٜ اَرْدِيٻٜ دِينَ نغَمْ حٛکِّتِرَ يٜىٰسُ ندٜرْ جُوطٜ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","ٻٜ نَنِ بٜلْطُمْ نَاع سٜطَّ ندٜ ٻٜ نَنِ نٛنْ، ٻٜ نغَطِ اَلْکَوَلْ حٛکُّکِمٛ شٜىٰدٜ؞ نغَمْ نٛنْ، يَحُودَ فُطِّ طَٻُّتُکِ لَاوٛلْ نٛ حٛکِّتِرْتَ يٜىٰسُ ندٜرْ جُوطٜ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","ݧَلْندٜ اَرَنْدٜىٰرٜ ندٜ حُمْتٛ بُرٛودِ طُمْ وَلَا پُوفِنِرْطُمْ، ݧَلْندٜ ندٜ طُمْ حِرْسَتَ کَرٛوجِ نغَمْ حُمْتٛ سَکِّنْکِ، تٛکُّٻٜ يٜىٰسُ پَمِمٛ، مبِعِ، ‏«‏تٛيٜ نغِطَّا مِنْ نجَحَ مِنْ شِرْيَنٛمَا نغَمْ ݧَامٜنْ ݧَمْندُ حُمْتٛ سَکِّنْکِ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","سٜيْ اٛ لِلِ تٛکُّٻٜمٛ طِطٛ، اٛ وِعِٻٜ، ‏«‏نَتّٜىٰ غَرِيرِ، اٛنْ کَوْرَيْ اٜ غٛطّٛ اٜ مٛ رٛنْدِي پٛوغِرْدٜ ندِيَمْ؞ تٛکّٜىٰمٛ ");
INSERT INTO fuv_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","يَاکِ وُرٛ نغٛ اٛ نَتَّتَ، مبِعٛنْ جٛومُ وُرٛ نغٛنْ، ‏‹‏مٛودِبّٛ وِعِي مِنْ پَمُمَا:‏ تٛيٜ سُودُ ندُ ݧَامَيْمِ ݧَمْندُ حُمْتٛ سَکِّنْکِ، مِنْ اٜ تٛکُّٻٜيَمْ؟›‏ ");
INSERT INTO fuv_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","اٛ حٛلَّيْعٛنْ سُودُ مَوْندُ ندُ دٛوْ مٛعِّنَاندُ شِرْيَاندُ؞ شِرْيَنٜىٰعٜنْ کٛو طُمٜ طٛنْ نغَمْ ݧَامٜنْ ݧَمْندُ حُمْتٛ سَکِّنْکِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","سٜيْ تٛکُّٻٜمٛ ٻٜنْ نَنْغِ لَاوٛلْ نَتِّ غَرِيرِ ندِنْ ٻٜ تَوِ کٛو طُمٜ نٛنْ نٛ يٜىٰسُ وِعِٻٜ؞ سٜيْ ٻٜ شِرْيِي کٛو طُمٜ نغَمْ حُمْتٛ سَکِّنْکِ؞ ");
INSERT INTO fuv_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","ندٜ فُتُرٛ وَطِ، يٜىٰسُ اٜ تٛکُّٻٜمٛ سَڤّٛ اٜ طِطٛ نغَرِ وُرٛ نغٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","اٜ ٻٜ نجٛوطِي اٜ ٻٜ ݧَامَ ݧَمْندُ، سٜيْ يٜىٰسُ وِعِ، ‏«‏اٜ مِ وِعَعٛنْ غٛونغَ، غٛعٛتٛ ندٜرْ مٛوطٛنْ ݧَمْندَيْطٛ اٜ اَمْ حٛکِّتِرَيْيَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","سٜيْ ٻٜ نغَنِّ، ٻٜ ڤُطِّ وِعُکِمٛ غٛعٛتٛ‑غٛعٛتٛ، ‏«‏نَاع طُمْ مِنْ، کٛو؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","يٜىٰسُ نٛوتِي، وِعِ، ‏«‏طُمْ غٛعٛتٛ ندٜرْ مٛوطٛنْ، اٛنٛنْ سَڤّٛ اٜ طِطٛ ٻٜ شُٻُمِ، ݧَمْدَيْطٛ اٜ اَمْ لٜعَلْ غٛعٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","ٻِي نٜطّٛ مَايَيْ نٛ طُمْ وِنْدِرَا دٛوْ مَاکٛ، اَمَّا کٛکِّتِرَيْطٛمٛ وٛنِي!‏ طُمْ ٻُرَنَيْمٛ دَا اٛ دَݧَاکَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","اٜ ٻٜ ندٜرْ ݧَامُکِ ݧَمْندُ، سٜيْ يٜىٰسُ حٛشِّ بُرٛودِ يٜتِّ اَللَّه، اٛ سٜنْدِطُمْ، اٛ حٛکِّ تٛکُّٻٜمٛ، اٛ وِعِ، ‏«‏نجَٻٜىٰطُمْ؞ طُعُمْ طُمْ ٻَنْدُ اَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","طٛنْمَا اٛ حٛشِّ جَرْدُغٜلْ ندِيَمْ اِنَبٛجَمْ، اٛ يٜتِّ اَللَّه، اٛ حٛکِّٻٜطَمْ، ٻٜ فُو ٻٜ نجَرِطَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","ندٜنْ اٛ وِعِٻٜ، ‏«‏طَعَمْ کَنْجَمْ وٛنِ پِيپَمْ اَمْ تَبِّتِنَيْطَمْ اَلْکَوَلْ اَللَّه ندُفٜتٜىٰطَمْ نغَمْ يِمْٻٜ طُطْٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","اٜ مِ وِعَعٛنْ غٛونغَ، مِ فُطِّتَتَا مِ يَرَ ندِيَمْ اِنَبٛوجٜ نَا ݧَلْندٜ ندٜ نجَرَيْمِ نغٛطَّمْ کٜسَمْ ندٜرْ لَامُ اَللَّه؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","سٜيْ ٻٜ نغِمِ غِمٛلْ مَنْتُکِ اَللَّه، ندٜنْ ٻٜ ندِلِّ حٛشّٜىٰرٜ ندٜ لٜطّٜ جَيْتُنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","يٜىٰسُ وِعِ تٛکُّٻٜمٛ، ‏«‏اٛنْ فُو اٛنْ ندٛغَّيْ اَلٛنْيَمْ، نغَمْ ندٜرْ اَايَارٜ اَللَّه وِعِي، ‏‹‏مِ وَرَيْ غَيْنَاکٛ، ندٜنْ بَالِ طِنْ شَنْکِتٛتٛ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","اَمَّا غَطَ مِ اُمَّکٜ دَغَ مَيْدٜ، مِ اَرْتَيْعٛنْ يَاکِ غَلِيلِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","سٜيْ بِيتُرُسْ وِعِمٛ، ‏«‏کٛو ٻٜ فُو ٻٜ اَلِيمَ، مِنْ مِ اَلَتَامَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","يٜىٰسُ وِعِمٛ، ‏«‏اٜ مِ وِعُمَا غٛونغَ، حَنْدٜ، ندٜرْ جٜمَّارٜ ندٜعٜ، کٛ نجَکَرْدِ حَنَ ندٜ طِطِ، اَ وِعَيْ اَ اَنْدَايَمْ ندٜ تَتِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","اَمَّا بِيتُرُسْ جَٻَايِ، اٛ وِعِ، ‏«‏کٛو طُمْ وَرْدَيْيَمْ اٜ مَاطَ، مِ وِعَتَا مِ اَنْدَامَ؞»‏ حٛرِيٻٜ ٻٜنْ مَا مبِعِ نٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","سٜيْ ٻٜ نجَحِ وِغٜىٰرٜ بِعٜتٜىٰندٜ غٜىٰسَمَنِ، يٜىٰسُ وِعِ تٛکُّٻٜمٛ، ‏«‏نجٛوطٜىٰ طٛعٛ، مِ يَحَ مِ وَطَ دٛعَارٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","سٜيْ اٛ حٛشِّ بِيتُرُسْ، اٜ يَاکُبُ، اٜ يَحَيَ؞ ٻٜرْندٜ مَاکٛ بٛو تٜدِّ، اٛ فُطِّ وَنُّکِ نَاع سٜطَّ؞ ");
INSERT INTO fuv_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","اٛ وِعِٻٜ، ‏«‏ٻٜرْندٜ اَمْ وَنِّي نَاع سٜطَّ حَا بٛ مِ مَايَيْ؞ نجٛوطٜىٰ طٛعٛ اٛنْ ندٜىٰنَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","ندٜ اٛ يَحِ يٜىٰسٛ سٜطَّ، سٜيْ اٛ يَنِ اٜ لٜيْدِ اٜ مٛ حِڤِّي، اٛ وَطِ دٛعَارٜ، اٛ وِعِ تٛ طُمْ غَطٛتٛوطُمْ طُمْ حٛشَّنَمٛ شَرٜلْ تٛرَّ وٛنْکَ يٜىٰسٛ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","اٛ وِعِ، ‏«‏يَا ݧَاکٛ اَمْ مٛ دٛوْ، کٛو طُمٜ طُمْ غَطٛتٛوطُمْ تٛ مَاطَ؞ تَا جَٻِي، اِتَّنَمْ جَرْدُغٜلْ تٛرَّ کَعَ؞ فُو اٜ نٛنْ نَاع کٛ نغِطُمِ وَطٜتٜىٰ، اَمَّا کٛ نغِطَّا وَطٜىٰ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","غَطَ طٛنْ اٛ سٛعِّي تٛ ٻٜنْ طٛنْ تٛکُّٻٜمٛ تَتٛ، اٛ تَوِ اٜ ٻٜ طَانِي، سٜيْ اٛ وِعِ بِيتُرُسْ، ‏«‏بِيتُرُسْ، اَ طَانِي؟ اَ وَاوَتَا جٛوطَاکِ اَ طَانَاکِ کٛو شَرٜلْ سٜطَّ؟ ");
INSERT INTO fuv_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","نجٛوطٜىٰ، تٛع اٛنْ طَانٛ، نغَطٜىٰ دٛعَارٜ تٛ طُمْ فٛوندِيعٛنْ تٛع نغَطٛنْ حَکّٜ؞ ٻٜرْندٜ اٜ يِطِ وَطُکِ کٛ حَانِ، اَمَّا ٻَنْدُ تَمْڤِي؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","اٛ فُطِّتِ اٛ دِلِّ، اٛ وَطِ دٛعَارٜ، اٛ وِعِ کٛ اٛ وِعُنٛو؞ ");
INSERT INTO fuv_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","اٛ فُطِّتِ اٛ سٛعّٛيِي تٛ مَٻّٜ، اٛ تَوِ اٜ ٻٜ طَانِي، نغَمْ اٜ ٻٜ نَنَ طٜيْنغٛلْ تٜدُّنغٛلْ؞ ٻٜ ندُلِّ کٛ ٻٜ مبِعَتَمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","اٛ فُطِّتِ اٛ سٛعِّي تٛ مَٻّٜ تَتَٻُمْ، اٛ وِعِٻٜ، ‏«‏حَا جٛونِ اٛنْ طَانِي، اٛنْ شِوْتٛو؟ طُمْ حٜپِي نٛنْ!‏ شَرٜلْ وَرِي؞ طُمْ حٛکِّتِرِي ٻِي نٜطّٛ ندٜرْ جُوطٜ غَطٛوٻٜ حَکّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","اُمّٜىٰ ندِلّٜنْ!‏ رَا اٛنْ طٛنْ کٛکِّتِرَيْطٛيَمْ اٜ وَرَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","يٜىٰسُ اٜ مٜتَ، سٜيْ يَحُودَ، غٛعٛتٛ ندٜرْ تٛکُّٻٜمٛ سَڤّٛ اٜ طِطٛ يٛتِّي؞ اٛ وَرْدٛيِ اٜ يِمْٻٜ طُطْٻٜ اٜ ٻٜ نجٛغِي کَافَاجٜ اٜ شَبِّ؞ مَوْٻٜ اَرْدِيٻٜ دِينَ، اٜ مٛودِٻّٜ اَتَّوْرَ، اٜ مَوْٻٜ يِمْٻٜ لِلٛيِٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","تٛو، ندٜنْ مَا کٛکِّتِرَيْطٛ اٛنْ يَادَکٜ وِعِيٻٜ نٛ حٛلِّرْتَٻٜ يٜىٰسُ، اٛ وِعِ، ‏«‏نٜطّٛ مٛ کٛوْنَيْمِ حٛوْنُکِ حِغَاکُ طُمْ کَنْکٛ؞ نَنْغٜىٰمٛ، نغَطٛنْ تَادِيٻٜ نجٛغٛومٛ بٛطُّمْ ندِلِّدَ اٜ مَاکٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","ندٜ يَحُودَ يٛتِّي تٛ ٻٜ نغٛنِ، طٛنْ اٜ طٛنْ اٛ ٻَدِّي يٜىٰسُ، اٛ وِعِمٛ، ‏«‏مٛودِبّٛ!‏»‏ ندٜنْ اٛ حٛوْنِمٛ حٛوْنُکِ حِغَاکُ؞ ");
INSERT INTO fuv_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","سٜيْ يِمْٻٜ ٻٜنْ نَنْغِ يٜىٰسُ ٻٜ نجٛغِيمٛ بٛطُّمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","اَمَّا غٛعٛتٛ ندٜرْ تٛکُّٻٜ يٜىٰسُ دَرِيطٛ طٛنْ سٛلْتِ کَافَحِ مُوطُمْ فٜعِّ مَشُّطٛ مَوْطٛ مَوْٻٜ اَرْدِيٻٜ دِينَ اِتَّنِمٛ نٛوْرُ؞ ");
INSERT INTO fuv_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","سٜيْ يٜىٰسُ وِعِٻٜ، ‏«‏اٛنْ نغَرْدٛيِ اٜ کَافَاجٜ اٜ شَبِّ نغَمْ نَنْغٛيْيَمْ بٛ غُجّٛ شَلٛرْطٛ؟ ");
INSERT INTO fuv_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","کٛو ندٜيٜ اٜ مِ وٛنْدِ اٜ مٛوطٛنْ، اٜ مِ اٜکِّتِنَ ندٜرْ وُرٛ شٜنِينغٛ، اٛنْ نَنْغَايِيَمْ؞ اَمَّا دٛولٜ کٛ اَايَاجٜ مبِعِ حٜىٰوَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","سٜيْ تٛکُّٻٜمٛ فُو اَلِمٛ ندٛغِّ؞ ");
INSERT INTO fuv_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","غٛطّٛ کَيٜىٰجٛ بٛو اٜ تٛکِّرِ يٜىٰسُ تٛنْ غَطَ، اٛ ٻٛرْنَاکِ غٛطُّمْ، وُدٜرٜ ندٜ شٜىٰدٜ تَنْ اٛ وَانِي؞ ٻٜ نَنْغِمٛ، ");
INSERT INTO fuv_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","سٜيْ اٛ اَلَنِٻٜ وُدٜرٜ ندٜنْ، اٛ دٛغِّ اٛ ٻٛرْنَاکِ؞ ");
INSERT INTO fuv_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","ٻٜ نجَارِ يٜىٰسُ تٛ مَوْطٛ مَوْٻٜ اَرْدِيٻٜ دِينَ؞ فُو مَوْٻٜ اَرْدِيٻٜ دِينَ، اٜ مَوْٻٜ يِمْٻٜ، اٜ مٛودِٻّٜ اَتَّوْرَ کَوْرِتِي طٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","بِيتُرُسْ بٛو تٛکِّرِمٛ غَطَ دَغَ تٛ وٛطِّ حَا يَاکِ شَکَ وُرٛ مَوْطٛ مَوْٻٜ اَرْدِيٻٜ دِينَ؞ اٛ جٛوطٛدِي اٜ تَادِيٻٜ وُرٛ شٜنِينغٛ، اٜ مٛ اِرْفٛو حَادٜ حِيتٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","مَوْٻٜ اَرْدِيٻٜ دِينَ اٜ فُو کَوْتَلْ مَوْٻٜ اٜ ٻٜ طَٻِّتَ شٜيْدَ کٛ ٻٜ نَنْغِرْتَ يٜىٰسُ، نغَمْ ٻٜ کٜٻَ ٻٜ مبَرَمٛ، اَمَّا ٻٜ کٜٻَايِ غٛطُّمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","يِمْٻٜ طُطْٻٜ مٜتِ حَالَاجِ فٜوْرٜ دٛوْ مَاکٛ، اَمَّا کٛ ٻٜ مبِعِ وَرْدَايِ غٛعٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","سٜيْ وٛٻّٜ اُمِّي ٻٜ مبِعِ حَالَاجِ فٜوْرٜ طِعِ دٛوْ مَاکٛ، ٻٜ مبِعِ، ");
INSERT INTO fuv_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","‏«‏مِنْ نَنِي اٛ وِعِي اٛ سَنْکِتَيْ نغٛعٛ وُرٛ شٜنِينغٛ نغٛ يِمْٻٜ مَحِ، ندٜنْ ندٜرْ بَلْطٜ تَتِ اٛ مَحَ وٛنْغٛ نَاع اٜ جُوطٜ يِمْٻٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","اَمَّا فُو اٜ نٛنْ کٛ ٻٜ مبِعِ وَرْدَايِ غٛعٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","سٜيْ مَوْطٛ مَوْٻٜ اَرْدِيٻٜ دِينَ اُمِّي دَرِي يٜىٰسٛ مَٻّٜ پَمِ يٜىٰسُ، اٛ وِعِ، ‏«‏اَ وَلَا کٛ مبِعَتَا؟ کٛ ٻٜ مبِعِ دٛوْ مَاطَ طُمْ غٛونغَ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","اَمَّا يٜىٰسُ دٜعِّتِ نٛوتَنَاکِمٛ؞ مَوْطٛ مَوْٻٜ اَرْدِيٻٜ دِينَ اٛنْ فُطِّتِ پَمِ يٜىٰسُ، وِعِ، ‏«‏تٛو، اَنْ وٛنِ اَلْمَسِيحُ، ٻِطّٛ جٛومُ مَنْغُ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","يٜىٰسُ نٛوتِي، وِعِ، ‏«‏اٜىٰ، طُمْ مِنْ؞ اٛنْ نغِعَيْ ٻِي نٜطّٛ اٜ جٛوطِي تٛ جُنْغٛ ݧَامٛ نغٛ جٛومُ بَوْطٜ، اٜ مٛ وَرٛيَ ندٜرْ دُولٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","سٜيْ مَوْطٛ مَوْٻٜ اَرْدِيٻٜ دِينَ اٛنْ سٜىٰکِ کٛلْتٜ مُوطُمْ وِعِ، ‏«‏طُمٜ شٜيْدَ طَٻِّتٜتٜنْ کَدِنْ؟ ");
INSERT INTO fuv_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","اٛنْ نَنِي نِ حَالَ کَلُّکَ کَ اٛ مٜتِ دٛوْ اَللَّه؞ کٛ وٛنِ شُٻٛلْ مٛوطٛنْ؟»‏ سٜيْ يِمْٻٜ فُو مبِعِ اٜ حَانِ اٛ وَرٜىٰ؞ ");
INSERT INTO fuv_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","وٛٻّٜ ڤُطِّ تُتَّنْکِمٛ جٛودٜ، ٻٜ کَٻَّنِمٛ غِتٜ، ٻٜ ڤِيِمٛ، اٜ ٻٜ مبِعَمٛ، ‏«‏وَطُ اَنَّبَاکُ!‏ مٛيٜ فِيِمَا؟»‏ سٜيْ تَادِيٻٜ وُرٛ شٜنِينغٛ کٛشِّمٛ ڤِيِمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","بِيتُرُسْ اٜ شَکَ وُرٛ نغٛنْ، سٜيْ غٛعٛتٛ ندٜرْ حٛرْٻٜ مَوْطٛ مَوْٻٜ اَرْدِيٻٜ دِينَ وَرِ وِغٜىٰرٜ ندٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ندٜ اٛ يِعِ بِيتُرُسْ اٜ اِرْفٛو، اٛ سُتِيمٛ، اٛ وِعِمٛ، ‏«‏اَنْ مَا، اَ وٛنْدِ اٜ يٜىٰسُ اٛنْ طٛنْ پِوٛيْطٛ غَرِيرِ نَجَرَتْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","اَمَّا بِيتُرُسْ يٜدِّ وِعِ، ‏«‏مِنْ مِ اَنْدَا، مِ فَامَايِ کٛ مبِعَتَا؞»‏ بِيتُرُسْ وُرْتِي يَحِ نجَيْرِ دَمُّغَلْ يَاسِ، سٜيْ نجَکَرْدِ حَنِ؞ ");
INSERT INTO fuv_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","کٛرْطٛ اٛنْ يِعِ بِيتُرُسْ تٛنْ، اٛ فُطِّتِ اٛ وِعِ دَرِيٻٜ طٛنْ کَمْٻٜ مَا، ‏«‏اٛعٛ نٜطّٛ اٛ غٛعٛتٛ مَٻّٜ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","اَمَّا بِيتُرُسْ فُطِّتِ يٜدِّ؞ غَطَ طٛنْ سٜطَّ، دَرِيٻٜ حَادٜ طٛنْ مبِعِ بِيتُرُسْ، ‏«‏سٜکٛ وَلَا اَنْ مَا اَ غٛعٛتٛ ندٜرْ تٛکُّٻٜمٛ، نغَمْ اَ غَلِلَنْکٜىٰجٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","بِيتُرُسْ فُطِّ لَانُکِ حٛورٜ مُوطُمْ حُنِي وِعِ، ‏«‏مِ اَنْدَا نٜطّٛ اٛعٛ مٛ مبِعٛتٛنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","طٛنْ اٜ طٛنْ نجَکَرْدِ حَنِ طِطَٻُمْ؞ سٜيْ بِيتُرُسْ سِفْتٛرِ کٛ يٜىٰسُ وِعُنٛومٛ وِعُکِ، ‏«‏کٛ نجَکَرْدِ حَنَ ندٜ طِطِ، اَ وِعَيْ اَ اَنْدَايَمْ ندٜ تَتِ؞»‏ ندٜنْ بِيتُرُسْ فُطِّ بٛجِّ؞ ");
INSERT INTO fuv_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","اِلَا سُبَکَ مَوْٻٜ اَرْدِيٻٜ دِينَ، اٜ مَوْٻٜ يِمْٻٜ، اٜ مٛودِٻّٜ اَتَّوْرَ، اٜ فُو کَوْتَلْ مَوْٻٜ ٻٜ مٜدِّ دٛوْ کٛ ٻٜ نغَطَتَ؞ سٜيْ ٻٜ کَٻِّ يٜىٰسُ ٻٜ ندِلِّدِ اٜ مَاکٛ، ٻٜ تَمْبِنِمٛ بِلَاتُسْ غٛمْنَاجٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","بِلَاتُسْ پَمِمٛ، وِعِ، ‏«‏اَنْ وٛنِ لَامِيطٛ يَحُودَنْکٛعٜنْ؟»‏ يٜىٰسُ نٛوتِي، وِعِمٛ، ‏«‏اٜىٰ، اَ وِعِيکَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","مَوْٻٜ اَرْدِيٻٜ دِينَ نغُلّٛرِيمٛ فِي طُطُّمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","سٜيْ بِلَاتُسْ فُطِّتِ پَمِمٛ، وِعِ، ‏«‏وَلَا کٛ مبِعَتَا؟ رَا ٻٜ نغُلّٛرَکٜمَ فِي طُطُّمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","اَمَّا يٜىٰسُ ٻٜيْدَايِ نٛوتَاکِ، حَا طُمْ حَيْطِنِ بِلَاتُسْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","تٛو، اٜ شَرٜلْ حُمْتٛ سَکِّنْکِ بِلَاتُسْ وٛووِي يٛوفَنْکِٻٜ شُرَاطٛ غٛعٛتٛ مٛ ٻٜ تٛرِي؞ ");
INSERT INTO fuv_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","اٜ وٛودِ غٛطّٛ بِعٜتٜىٰطٛ بَرَبَّسْ شُرَاطٛ، کَنْکٛ اٜ وٛٻّٜ شُرَاٻٜ نغَمْ ٻٜ کَٻْدِي اٜ لَامُ، ٻٜ نغَطِي وَرْحٛورٜ ندٜرْ حَوْرٜ ندٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","سٜيْ يِمْٻٜ طُطْٻٜ نغَرِ ٻٜ تٛرِي بِلَاتُسْ وَطَنَٻٜ کٛ اٛ وٛووِ وَطَنْکِٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","بِلَاتُسْ پَمِٻٜ وِعِ، ‏«‏اٛنْ نغِطِ مِ يٛوفَنَعٛنْ لَامِيطٛ يَحُودَنْکٛعٜنْ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","نغَمْ بِلَاتُسْ فَامِي لَوْلِيرُ وَطِ مَوْٻٜ اَرْدِيٻٜ دِينَ نغَطِ يٜىٰسُ ندٜرْ جُنْغٛ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","اَمَّا مَوْٻٜ اَرْدِيٻٜ دِينَ ٻٜنْ نغَطِ يِمْٻٜ مبِعَ بِلَاتُسْ اٛ يٛوفَنَٻٜ بَرَبَّسْ نَاع يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","سٜيْ بِلَاتُسْ پَمِٻٜ، وِعِ، ‏«‏تٛو، کٛ نغِطّٛنْ مِ وَطَنَ نٜطّٛ اٛعٛ مٛ نٛدِّرْتٛنْ لَامِيطٛ يَحُودَنْکٛعٜنْ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","ٻٜ فُو ٻٜ مبِعِ سٜمْبٜىٰ، ‏«‏وَرُمٛ دٛوْ غَافَانغَلْ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","بِلَاتُسْ پَمِٻٜ، وِعِ، ‏«‏نغَمْ طُمٜ؟ طُمٜ کٛ حَلِّ اٛ وَطِ؟»‏ اَمَّا ٻٜ ٻٜيْدِ وِعُکِ سٜمْبٜىٰ، ‏«‏وَرُمٛ دٛوْ غَافَانغَلْ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","ندٜ بِلَاتُسْ اٜ يِطِ وَطَ کٛ حَوْرُتُٻٜ ٻٜنْ نغِطِ، اٛ يٛوفَنِٻٜ بَرَبَّسْ؞ اٛ وَطِ طُمْ فِيِ يٜىٰسُ لٛوشِ، ندٜنْ اٛ تَمْبِنِمٛ سٛوجِعٜنْ رٛومَ نغَمْ ٻٜ مبَرٛيَمٛ دٛوْ غَافَانغَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","سٛوجِعٜنْ ٻٜنْ اَرْدِنِ يٜىٰسُ يَاکِ لَامٛرْدٜ غٛمْنَاجٛ بِعٜتٜىٰندٜ ‏«‏فِرٜتٛورِيُمْ؞»‏ ٻٜ نٛدِّ فُو سٛوجِعٜنْ کٛرِيٻٜ ٻٜ کَوْرِتِٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","ٻٜ ٻٛرْنِمٛ اِرِ تٛغّٛورٜ لَامِيٻٜ، ندٜنْ ٻٜ مبَالِ غِيفٛلْ غِعٜ، ٻٜ تَارَنِمٛنغٛلْ تٛ حٛورٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","سٜيْ ٻٜ ڤُطِّ حٛوْنُکِمٛ، اٜ ٻٜ مبِعَ، ‏«‏اَللَّه رٜىٰنٜ، لَامِيطٛ يَحُودَنْکٛعٜنْ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","ٻٜ نغَطِ کَ ڤِيرُکِمٛ سَوْرُ تٛ حٛورٜ؞ اٜ ٻٜ تُتَّنَمٛ جٛودٜ؞ ٻٜ ندِشِّي يٜىٰسٛ مَاکٛ بٛ ٻٜ کٛکَّيْمٛ مَنْغُ؞ ");
INSERT INTO fuv_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","غَطَ ٻٜ نجُکِّتِيمٛ، ٻٜ ٻٛرْتِمٛ تٛغّٛورٜ لَامِيٻٜ ندٜ ٻٜ ٻٛرْنُنٛومٛ، ندٜنْ ٻٜ ٻٛرْنِمٛ کٛلْتٜ مَاکٛ؞ سٜيْ ٻٜ مبُرْتِنِمٛ ٻٜ اَرْدِنِمٛ نغَمْ ٻٜ مبَرٛيَمٛ دٛوْ غَافَانغَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","غٛطّٛ نٜطّٛ سَايِرَنْکٜىٰجٛ اٜ پَٻّٛو بِعٜتٜىٰطٛ سِيمَنْ، ݧَاکٛ اَلِجَنْدَ اٜ رُوفُسْ؞ اٛ پِوٛيْطٛ ندٜرْ لَدّٜ اٜ مٛ نَتّٛيَ غَرِيرِ ندِنْ؞ سٜيْ ٻٜ نغَطِمٛ اٜ سٜمْبٜ اٛ حٛشَّ غَافَانغَلْ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","ٻٜ نجَارِ يٜىٰسُ وٛنْدٜ وِغٜىٰرٜ بِعٜتٜىٰندٜ غٛلْغٛوتَ، وَاتٛ ‏«‏وِغٜىٰرٜ پِپَلْ حٛورٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","ندٜنْ ٻٜ کٛکِّمٛ ندِيَمْ اِنَبٛجَمْ جِلِّندِرَاطَمْ اٜ مُرْ نغَمْ اٛ يَرَ، اَمَّا اٛ يَرَايِطَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","سٜيْ، ٻٜ ڤِيَنِمٛ کُوسَاجٜ دٛوْ غَافَانغَلْ؞ ندٜنْ ٻٜ شٜنْدِ کٛلْتٜ مَاکٛ حَکُّندٜ مَٻّٜ، ٻٜ نغَطِ شَاشَ نغَمْ ٻٜ نغِعَ کٛ کٛو مٛيٜ حٜٻَتَ؞ ");
INSERT INTO fuv_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","شَرٜلْ نغٜلْ ٻٜ ڤِيَنِمٛ کُوسَاجٜ دٛوْ غَافَانغَلْ طُمْ نجَمْندِ جٛوٜىٰنَيِ سُبَکَ؞ ");
INSERT INTO fuv_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","دٛوْ حٛورٜ غَافَانغَلْ نغَلْ طُمْ تَکِّ اَلّٛوَلْ؞ طُمْ وِنْدِ دٛوْ مَاغَلْ کٛ طُمْ وُلّٛرِيمٛ وِعُکِ، ‏«‏لَامِيطٛ يَحُودَنْکٛعٜنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK15_27‏","071_15_27‏","MRK","15","27‏","28","کَدِنْ ٻٜ ڤِيَنِ وُيْٻٜ طِطٛ کُوسَاجٜ دٛوْ غَافَالٜ حَادٜ يٜىٰسُ، غٛعٛتٛ اٜ جُنْغٛ مَاکٛ ݧَامٛ، غٛعٛتٛ اٜ جُنْغٛ مَاکٛ نَنٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","يِمْٻٜ پَٻّٛتٛوٻٜ اٜ کُطَ يٜىٰسُ اٜ ٻٜ نغِيلَ کٛعٜ، اٜ ٻٜ مبِعَ، ‏«‏تٛو!‏ اَنْ غِطّٛ ڤُسُکِ وُرٛ شٜنِينغٛ مَحِتٛطَانغٛ ندٜرْ بَلْطٜ تَتِ، ");
INSERT INTO fuv_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","جِڤّٛيَ دَغَ دٛوْ غَافَانغَلْ کِسْنَا حٛورٜ مَاطَ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","نٛنْ مَا مَوْٻٜ اَرْدِيٻٜ دِينَ اٜ مٛودِٻّٜ اَتَّوْرَ ٻٜ نجُکِّتِمٛ حَکُّندٜ مَٻّٜ، اٜ ٻٜ مبِعَ، ‏«‏اٛ حِسْنِي وٛٻّٜ، اَمَّا اٛ وَاوَايِ حِسْنُکِ حٛورٜ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","اَلْ اٛعٛ بِعٛووٛ کَنْکٛ وٛنِ اَلْمَسِيحُ، لَامِيطٛ اِسْرَاعِيلَ، اٛ جِڤّٛيٛو جٛونِ دَغَ دٛوْ غَافَانغَلْ نغَمْ نغِعٜنْ کٛولٛوطٜنْمٛ؞»‏ ٻٜنْ طٛنْ وُيْٻٜ ٻٜ طُمْ ڤِيَنِ کُوسَاجٜ دٛوْ غَافَالٜ مَا کُطِمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","شَکَ ݧَلَوْمَ، سٜيْ ݧِوْرٜ مَٻِّ لٜيْدِ فُو حَا يَاکِ نجَمْندِ تَتِ ندِ اَلَاسَرَ؞ ");
INSERT INTO fuv_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","اٜ نجَمْندِ تَتِ ندِنْ، سٜيْ يٜىٰسُ وِعِ اٜ سٜمْبٜ، ‏«‏اٜلٛيْ، اٜلٛيْ، لَمَ سَبَتَّنِ؟»‏ وَاتٛ، ‏«‏يَا اَللَّه اَمْ، يَا اَللَّه اَمْ، نغَمْ طُمٜ شٜنْدِرْطَا اٜ اَمْ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","ندٜ وٛٻّٜ دَرِيٻٜ تٛ وِغٜىٰرٜ ندٜنْ نَنِ نٛنْ، ٻٜ مبِعِ، ‏«‏نَنٜىٰ، اٜ مٛ نٛدَّ اَنَّبِ اِلِيَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","سٜيْ غٛعٛتٛ مَٻّٜ دٛغِّ سٛفْنِ سٛوسٛوَ ندٜرْ ندِيَمْ اِنَبٛجَمْ لَمُّطَمْ، اٛ طِيسِنغَ تٛ سَوْرُ، اٛ حٛکِّ يٜىٰسُ يَرَ؞ اٛ وِعِ، ‏«‏اَلٜىٰ نغِعٜنْ کٛو اِلِيَ وَرَيْ جِڤِّنَمٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","سٜيْ يٜىٰسُ وُلِّ سٜمْبٜىٰ، ندٜنْ مَايِ؞ ");
INSERT INTO fuv_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","سٜيْ وُدٜرٜ شٜنْدُندٜ سُودُ جٛومِرَاوٛ سٜىٰکِ طِطِ دَغَ دٛوْ يَاکِ لٜيْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","مَوْطٛ سٛوجِعٜنْ دَرِيطٛ طٛنْ اٜ رَارَ يٜىٰسُ؞ ندٜ اٛ يِعِ نٛ يٜىٰسُ فٛفْتِرِ فٛوفَانغٛ شَکِتِينغٛ، مَايِ، اٛ وِعِ، ‏«‏غٛونغَ، نٜطّٛ اٛعٛ اٛ ٻِطّٛ اَللَّه!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","اٜ وٛودِ وٛٻّٜ رٜوْٻٜ اٜ ٻٜ ندَارَ دَغَ تٛ وٛطِّ؞ ندٜرْ مَٻّٜ اٜ وٛودِ مَرْيَامَ پِوٛيْطٛ مَغَدَلَ، اٜ مَرْيَامَ مَدُوجٛ يَاکُبُ ڤَمَرٛ، اٜ يُسُفُ، اٜ سَلٛومِ؞ ");
INSERT INTO fuv_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","ٻٜعٜ رٜوْٻٜ کَمْٻٜ تٛکَّيْنٛو يٜىٰسُ، اٜ ٻٜ مبَلَّمٛ کٛ اٛ وٛنّٛو لٜيْدِ غَلِيلِ؞ اٜ وٛودِ رٜوْٻٜ طُطْٻٜ فٜىٰرٜ غَرْدٛيْٻٜ اُرُشَلِيمَ اٜ مَاکٛ اٜ ٻٜ طٛنْ طُمْ کَمْٻٜ مَا؞ ");
INSERT INTO fuv_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","طُمْ اَلَاسَرَ ݧَلْندٜ سِرْيَاکِ، وَاتٛ تٛ فِنِي طُمْ ݧَلْندٜ سِوْتَارٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","نغَمْ مَاجُمْ يُسُفُ پِوٛيْطٛ غَرِيرِ اَرْمَاتِيَ، اٛ وَطِ سٜمْبٜ ٻٜرْندٜ، اٛ يَحِ تٛ بِلَاتُسْ، اٛ تٛرِيمٛ اٛ حٛکَّمٛ ٻَنْدُ يٜىٰسُ؞ يُسُفُ اٛ نٜطّٛ مٛ طُمْ حٛکَّتَ مَنْغُ ندٜرْ کَوْتَلْ مَوْٻٜ، کَنْکٛ مَا اٛ حَاٻِي يِعُکِ غَرٛلْ لَامُ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","بِلَاتُسْ حَيْطِنِ ندٜ نَنِ يٜىٰسُ يَادَکٜ مَايِي؞ اٛ نٛدِّ مَوْطٛ سٛوجِعٜنْ، اٛ پَمِمٛ کٛو طُمْ نٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","ندٜ اٛ نَنِ تٛ حٛنْدُکٛ مَوْطٛ سٛوجِعٜنْ اٛنْ يٜىٰسُ يَادَکٜ مَايِ، سٜيْ اٛ جَٻِ يُسُفُ حٛشَّ ٻَنْدُ ندُنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","سٜيْ يُسُفُ سٛودٛيِ وُدٜرٜ ندٜ شٜىٰدٜ، اٛ وَطِ طُمْ جِڤِّنِ ٻَنْدُ يٜىٰسُ، اٛ تَارِندُ اٜ وُدٜرٜ ندٜنْ، اٛ فُکِّنٛيِندُ ندٜرْ يٜنَاندٜ غَسَاندٜ ندٜرْ حَيْرٜ؞ اٛ تَلِّتِ کَاپَ مَنْغَ اٛ مَٻِّ دَمُّغَلْ يٜنَاندٜ ندٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","مَرْيَامَ پِوٛيْطٛ مَغَدَلَ اٜ مَرْيَامَ مَدُوجٛ يُسُفُ ٻٜ نغِعِ تٛ طُمْ فُکِّنِ ٻَنْدُ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","ندٜ ݧَلْندٜ سِوْتَارٜ پَٻِّي، مَرْيَامَ پِوٛيْطٛ مَغَدَلَ، اٜ مَرْيَامَ مَدُوجٛ يَاکُبُ، اٜ سَلٛومِ ٻٜ شٛودِ نٜبَّمْ اُرٛوجَمْ مبٜلْطَمْ نغَمْ ٻٜ نجَحَ ٻٜ مٛيْتَنَ ٻَنْدُ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","ݧَلْندٜ اَلَلْ سُبَکَ غَطَ نَانغٜ فُطِي، اٜ ٻٜ دٛوْ لَاوٛلْ يَاکِ تٛ يٜنَاندٜ ندٜنْ، ");
INSERT INTO fuv_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","اٜ ٻٜ مبِعَ حَکُّندٜ مَٻّٜ، ‏«‏مٛيٜ تَلِّتَنْتَعٜنْ کَاپَ مَنْغَ نغَ طُمْ مَٻِّرِ دَمُّغَلْ يٜنَاندٜ ندٜنْ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","اَمَّا ندٜ ٻٜ ندَارِ ٻٜ نغِعِ طُمْ يَادَکٜ طُمْ تَلِّتِي کَاپَ نغَنْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","ندٜ ٻٜ نَتِّ يٜنَاندٜ ندٜنْ، ٻٜ نغِعِ غٛطّٛ کَيٜىٰجٛ اٜ جٛوطِي وُتُّدُ ݧَامٛ؞ اٜ مٛ ٻٛرْنِي کٛلْتٜ دَنٜىٰجٜ تَرْ، سٜيْ ٻٜ کُلْتٛرِ؞ ");
INSERT INTO fuv_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","کَيٜىٰجٛ اٛنْ وِعِٻٜ، ‏«‏تٛع اٛنْ کُلُ؞ اٛنْ طَٻِّتَ يٜىٰسُ نَجَرَنْکٜىٰجٛ بَرَاطٛ دٛوْ غَافَانغَلْ؞ طُمْ اُمِّنِيمٛ دَغَ مَيْدٜ!‏ اٛ وَلَا طٛعٛ؞ رَا تٛ طُمْ فُکِّنّٛومٛ؞ ");
INSERT INTO fuv_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","اَمَّا نجَحٜىٰ مبِعٛنْ تٛکُّٻٜمٛ، حَا اٜ بِيتُرُسْ، اٛ اَرْتَيْعٛنْ يَاکِ لٜيْدِ غَلِيلِ؞ تٛنْ نغِعٛتٛنْمٛ نٛنْ نٛ اٛ وِعُنٛوعٛنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","کُلٛلْ نَنْغِٻٜ اٜ ٻٜ ندِوْنَ ٻٜ مبُرْتِي دَغَ ندٜرْ يٜنَاندٜ ندٜنْ ٻٜ ندٛغِّ؞ ٻٜ مبِعَايِ غٛطّٛ کٛو طُمٜ نغَمْ اٜ ٻٜ کُلَ؞ ");
INSERT INTO fuv_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","‏‏سُبَکَ ݧَلْندٜ اَلَلْ يٜىٰسُ اُمِّي دَغَ مَيْدٜ؞ غَطَ اٛ اُمَّکٜ اٛ اَرْتِ وَنْغَنْکِ مَرْيَامَ پِوٛيْطٛ مَغَدَلَ مٛ اٛ وُرْتِنَنِ غِنِّ جٛوٜىٰطِطِ؞ ");
INSERT INTO fuv_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","سٜيْ مَرْيَامَ اٛنْ يَحِ وِعِکَ ٻٜنْ طٛنْ غٛنْدُنٛوٻٜ اٜ مَاکٛ، اٛ تَوِٻٜ ندٜرْ وَنَّارٜ اٜ ٻٜ مبٛيَ؞ ");
INSERT INTO fuv_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","اَمَّا ندٜ ٻٜ نَنِ يٜىٰسُ اٜ وٛودِ يٛنْکِ، طٛنْمَا مَرْيَامَ اٛنْ يِعِيمٛ، ٻٜ نجَٻَايِکَ؞ ");
INSERT INTO fuv_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","غَطَ مَاجُمْ وٛٻّٜ تٛکُّٻٜمٛ طِطٛ اٜ ٻٜ دٛوْ لَاوٛلْ ندٜرْ لَدّٜ يَاکِ وٛنْغٜلْ غَرِيٜلْ، سٜيْ يٜىٰسُ وَنْغَنِٻٜ ندٜرْ نَنْدِ فٜىٰرٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","سٜيْ ٻٜ شٛعِّي ٻٜ مبِعِکَ حٛرِيٻٜ، اَمَّا ٻٜ نجَٻَايِ کٛ ٻٜ مبِعِ کَمْٻٜ مَا؞ ");
INSERT INTO fuv_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","دَغَ غَطَ يٜىٰسُ وَنْغَنِ تٛکُّٻٜمٛ سَڤّٛ اٜ غٛعٛ اٜ شَرٜلْ نغٜلْ اٜ ٻٜ ݧَامَ ݧَمْندُ؞ سٜيْ اٛ حَٻَنِٻٜ نغَمْ شِيَ حٛولَارٜ مَٻّٜ اٜ ٻٜرْطٜ شَاتُطٜ طٜ ٻٜ نغٛودِ، نغَمْ ٻٜ نجَٻَايِ کٛ غِيٻٜمٛ غَطَ اٛ اُمَّکٜ مبِعِٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","ندٜنْ اٛ وِعِٻٜ، ‏«‏نجَحٜىٰ کٛو تٛيٜ ندٜرْ دُونِيَارُ نغَعَجِنَنٛنْ کٛو مٛيٜ حَبَرُ بٜلْطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","کٛو مٛيٜ کٛولِيطٛيَمْ وَطَنَا بَڤْتِسْمَ اٛ حِسَيْ، اَمَّا فُو مٛ حٛولَاکِيَمْ طُمْ تَپَنَيْمٛ کِيتَ؞ ");
INSERT INTO fuv_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","فُو کٛولِيٻٜيَمْ ٻٜ نغَطَيْ کُوطٜ کٛلَّيْطٜ اٜ ٻٜ نغٛودِ بَوْطٜ اَللَّه؞ ندٜرْ اِنْدٜ اَمْ ٻٜ مبُرْتِنَيْ غِنِّ، ٻٜ نغَطَيْ دٛعَارٜ ندٜرْ طٜمْطٜ طٜ ٻٜ اَنْدَا؞ ");
INSERT INTO fuv_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ٻٜ نَنْغَيْ بٛولٜ اٜ جُوطٜ مَٻّٜ، ندٜنْ تٛ ٻٜ نجَرِي تٛوکٜ، طٜ نغَطَنْتَاٻٜ غٛطُّمْ؞ ٻٜ بٛو نجٛوَنَيْ ݧَوْٻٜ جُوطٜ، ݧَوْٻٜ ٻٜنْ نجَمْطِتَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","غَطَ يٜىٰسُ جٛومِرَاوٛ مٜتَنِيٻٜ، اٛ حٛشَّا يَاکِ دٛوْ، اٛ جٛوطِي جُنْغٛ ݧَامٛ نغٛ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","سٜيْ تٛکُّٻٜمٛ ٻٜنْ ندِلِّ ٻٜ نغَعَجِنٛيِ حَبَرُ بٜلْطُمْ کٛو تٛيٜ؞ جٛومِرَاوٛ وَلِّٻٜ، اٛ حٛکِّٻٜ بَوْطٜ وَطُکِ کُوطٜ کَيْطِنِيطٜ نغَمْ تَبِّتِنْکِ کٛ ٻٜ مبِعَتَ تٛ مَاکٛ طُمْ پِوٛيِ؞‏");
INSERT INTO fuv_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","يَا تِيٛوفِلُسْ مَوْطٛ، يِمْٻٜ طُطْٻٜ فُطِّي وِنْدُکِ حَبَرُ دٛوْ کٛ يٜىٰسُ وَطِ ندٜرْ اَمِنْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","ٻٜ مبِنْدِ حَبَرُ طُمْ نَنْطٜنْ دَغَ کٛنْدُطٜ غِيٻٜ کٛ وَطِ اٜ غِتٜ مَٻّٜ، اَنْدِنٛوٻٜ وٛلْدٜ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","نغَمْ نٛنْ، مِنْ مَا طُمْ وٛوطَنِييَمْ مِ طَٻِّتَ کٛو طُمٜ اٜ سٜىٰسٜ‑سٜىٰسٜ دَغَ فُطُّکِ مَاجُمْ، مِ وِنْدَنْمَا کٛو طُمٜ نٛ وٛنِ، ");
INSERT INTO fuv_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","نغَمْ اَنْدَا غٛونغَ دٛوْ کٛو طُمٜ کٛ طُمْ اٜکِّتِنْمَا؞ ");
INSERT INTO fuv_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","ندٜرْ شَرٜلْ نغٜلْ حِرُدُسْ لَامِيطٛ لٜيْدِ يَحُودِيَ لَامٛتٛو، اٜ وٛودِ اَرْدِيطٛ دِينَ بِعٜتٜىٰطٛ جَکَارِيَ، اٜ مٛ ندٜرْ اَرْدِيٻٜ دِينَ دَغَ لٜݧٛلْ اَبِجَ؞ دٜبّٛ مَاکٛ اَلِسَبَتُ پِوٛيِي دَغَ لٜݧٛلْ هَرُونَ، وَاتٛ اَرْدِيٻٜ دِينَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","ٻٜ فُو طِطٛ ٻٜ نجٛوطَکٜ جٛنْدٜ وٛوطُندٜ يٜىٰسٛ اَللَّه، اٜ ٻٜ نغَطَ کٛو طُمٜ کٛ جٛومِرَاوٛ وِعِ يِمْٻٜ نغَطَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","اَمَّا ٻٜ نغَلَا ٻِٻّٜ، نغَمْ اَلِسَبَتُ اٛ دَݧَتَا، کَدِمَا ٻٜ فُو طِطٛ ٻٜ نَوْيِي؞ ");
INSERT INTO fuv_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","وٛنْدٜ ݧَلْندٜ جَکَارِيَ اٜ حُوَ يٜىٰسٛ اَللَّه ندٜرْ وُرٛ شٜنِينغٛ اٜ ٻٜ اٛ حُودَتَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","طُمْ سُٻِيمٛ، نٛ اَرْدِيٻٜ دِينَ مبٛووِ وَطُکِ، نغَمْ اٛ نَتَّ ندٜرْ سُودُ جٛومِرَاوٛ اٛ وُلَ اُرْدٜ وٜلْندٜ نغَمْ جٛومِرَاوٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","ندٜ شَرٜلْ وُلُکِ اُرْدٜ وٜلْندٜ وَطِ، مٛٻْغَلْ فُو اٜ دَرِ يَاسِ اٜ ٻٜ نغَطَ دٛعَارٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","سٜيْ مَلَاعِکَاجٛ جٛومِرَاوٛ وَنْغِ تٛ مَاکٛ اٜ دَرِي وُتُّدُ ݧَامٛ تٛ طُمْ وُلَتَ اُرْدٜ وٜلْندٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","ندٜ جَکَارِيَ يِعِمٛ، ٻٜرْندٜ مُوطُمْ تَپِ، کُلٛلْ نَنْغِمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","اَمَّا مَلَاعِکَاجٛ اٛنْ وِعِمٛ، ‏«‏تَاع حُلُ جَکَارِيَ، جٛومِرَاوٛ نَنِي دٛعَارٜ مَاطَ؞ دٜبّٛ مَاطَ اَلِسَبَتُ دَݧَنْتٜ ٻِطّٛ غٛرْکٛ، ندٜنْ اَ حٛکَّيْمٛ اِنْدٜ يَحَيَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","ٻِطّٛ اٛنْ وَطٜتٜ نَنَا بٜلْطُمْ طُطُّمْ، طُطْٻٜ مَا نَنَيْ بٜلْطُمْ نغَمْ دَݧٜىٰکِ مَاکٛ، ");
INSERT INTO fuv_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","نغَمْ اٛ وَرْتَيْ مَوْطٛ يٜىٰسٛ جٛومِرَاوٛ؞ اٛ يَرَتَا ندِيَمْ اِنَبٛجَمْ کٛو نجَرُ غَيْلِتَيْنغُ حٛورٜ، ندٜنْ اٛ حٜىٰوَيْ رُوحُ اَللَّه دَغَ اٜ مٛ ندٜرْ رٜىٰدُ مَدُوجٛ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","اٛ وَرْتِرَيْ ٻِٻّٜ اِسْرَاعِيلَ طُطْٻٜ تٛ اَللَّه جٛومِرَاوٛ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","اٛ اَرْتَيْ اَلْمَسِيحُ وَرْکِ ندٜرْ بَوْطٜ رُوحُ اَللَّه طٜ اَنَّبِ اِلِيَ حٜٻُنٛو، اٛ سِرْيٛوتِرَيْ دَݧٛوٻٜ اٜ ٻِٻّٜ مَٻّٜ؞ اٛ وَيْلِتَيْ شَلِيٻٜ طَتَلْ جٛومِرَاوٛ تٛ طَتَلْ غٛودُٻٜ غٛونغَ؞ اٛ وَطَيْ يِمْٻٜ شِرْيٛو نغَمْ غَرٛلْ جٛومِرَاوٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","جَکَارِيَ پَمِ مَلَاعِکَاجٛ اٛنْ وِعِ، ‏«‏نٛيٜ اَنْدِرَيْمِ کٛ مبِيطَا طُمْ غٛونغَ؟ مِنْ، مِ نَوْيِي، دٜبّٛ اَمْ بٛو دُوٻِ مُوطُمْ طُوطِي؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","مَلَاعِکَاجٛ اٛنْ وِعِمٛ، ‏«‏مِنْ وٛنِ جِبِرِيلُ دَرٛتٛوطٛ يٜىٰسٛ اَللَّه، مِ لِلٛيَا تٛ مَاطَ نغَمْ مِ حٛکُّمَا حَبَرُ بٜلْطُمْ طُعُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","اَمَّا جٛونِ اَ وَاوَتَا مٜتُکِ نَا ݧَلْندٜ ندٜ فِي طُعُمْ وَطِ، نغَمْ اَ جَٻَايِ حَالَ اَمْ تَبِّتَيْکَ تٛ شَرٜلْ مَاکَ وَرِي؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","اٜ شَرٜلْ نغٜلْ يِمْٻٜ اٜ کٜطِي جَکَارِيَ يَاسِ، ٻٜ کَيْطِنِي کٛ وَطِ اٛ نٜىٰٻِرِ نٛنْ ندٜرْ سُودُ جٛومِرَاوٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","ندٜ اٛ وُرْتٛيِي، اٛ وَاوَايِ مٜتَنْکِٻٜ؞ ٻٜ فَامِ اٛ يِعِ وَحَيُ ندٜرْ سُودُ جٛومِرَاوٛ؞ اٛ وَطِ کَ مٜتِرَنْکِٻٜ جُوطٜ، اَمَّا نٛنْ اٛ جٛوطٛرِي اٛ مٜتَتَا؞ ");
INSERT INTO fuv_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","ندٜ اٛ حٜىٰݧِ بَلْطٜ کُوغَلْ مَاکٛ، اٛ سٛعِّي وُرٛ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","غَطَ فِي طُعُمْ وَطِي، دٜبّٛ مَاکٛ اَلِسَبَتُ حٜٻِ رٜىٰدُ، وَطِ لٜبِّ جٛوِ اٛ وُرْتَاکِ دَغَ ندٜرْ وُرٛ؞ اٛ وِعِ، ");
INSERT INTO fuv_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","‏«‏جٛومِرَاوٛ وَطَنِييَمْ طُعُمْ؞ ندٜرْ بَلْطٜ طٜعٜ، اٛ اِتَّنِييَمْ سٜمْتٜىٰندٜ اَمْ حَکُّندٜ يِمْٻٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","ندٜرْ لٜوْرُ جٛوٜىٰغٛعٛورُ غَطَ اَلِسَبَتُ حٜٻِي رٜىٰدُ، اَللَّه لِلِ مَلَاعِکَاجٛ جِبِرِيلُ تٛ غَرِيرِ بِعٜتٜىٰندِ نَجَرَتْ نغٛنْدِ ندٜرْ لٜيْدِ غَلِيلِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","مَلَاعِکَاجٛ اٛنْ يَحِ تٛ سُرْبَاجٛ بِعٜتٜىٰطٛ مَرْيَامَ غَطَنَاطٛ اَلْکَوَلْ تٜىٰغَلْ اٜ بِعٜتٜىٰطٛ يُسُفُ، دَغَ لٜݧٛلْ دَوْدَ؞ مَرْيَامَ اٛنْ اَنْدَا غٛرْکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","مَلَاعِکَاجٛ اٛنْ وِعِمٛ، ‏«‏اٜ مِ سِلْمِنٛو، بَرْکِطِنَاطٛ جٛومِرَاوٛ!‏ جٛومِرَاوٛ اٜ وٛنْدِ اٜ مَاطَ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","حَالَ کَنْ وَنِّي مَرْيَامَ کٛ طُوطِ؞ اٛ وِعِ ندٜرْ ٻٜرْندٜ مَاکٛ، ‏«‏مِنْ، مِ مٛيٜ اٛعٛ مٜتِّرَنْتَيَمْ نِحِ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","اَمَّا مَلَاعِکَاجٛ اٛنْ وِعِمٛ، ‏«‏تَاع حُلُ، مَرْيَامَ، اَللَّه سُٻِي بَرْکِطِنْمَا؞ ");
INSERT INTO fuv_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","اَ حٜٻَيْ رٜىٰدُ، اَ دَݧَيْ ٻِطّٛ غٛرْکٛ، ندٜنْ اَ نٛدَّيْ اِنْدٜ مَاکٛ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","اٛ وَرْتَيْ مَوْطٛ، طُمْ نٛدَّيْمٛ ٻِطّٛ اَللَّه جٛومُ مَنْغُ؞ اَللَّه جٛومِرَاوٛ حٛکَّيْمٛ جٛوطٛرْغَلْ لَامُ مَامَ مَاکٛ دَوْدَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","اٛ لَامٛتٛ دٛوْ ٻِٻّٜ اِسْرَاعِيلَ حَا اَبَدَا؞ لَامُ مَاکٛ رٜعَتَا؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","مَرْيَامَ وِعِ مَلَاعِکَاجٛ اٛنْ، ‏«‏نٛيٜ طُمْ وَطٛرْتٛو؟ مِ اَنْدَا غٛرْکٛ سَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","مَلَاعِکَاجٛ اٛنْ وِعِمٛ، ‏«‏رُوحُ اَللَّه جِڤّٛيْتٛ دٛوْ مَاطَ، بَوْطٜ اَللَّه جٛومُ مَنْغُ سُدّٜتٜ بٛ طٛوْدِ؞ نغَمْ نٛنْ، دَݧٜتٜىٰطٛ اٛنْ طُمْ نٛدِّرَيْمٛ ‏‹‏ٻِطّٛ اَللَّه، شٜنِيطٛ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","رَا، اَلِسَبَتُ بَنْدِرَاوٛ مَاطَ حٜٻِي رٜىٰدُ ندٜرْ نَيٜوُ مُوطُمْ، اٛ دَݧَيْ ٻِطّٛ غٛرْکٛ؞ کَنْکٛ مٛ يِمْٻٜ مبِعَتَ اٛ دَݧَتَا، جٛونِ اٜ مٛ وٛودِ رٜىٰدُ ندُ لٜبِّ جٛوٜىٰغٛعٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","نغَمْ وَلَا کٛ سَلٛرْتَ اَللَّه؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","ندٜنْ مَرْيَامَ وِعِ، ‏«‏مِ کٛرْطٛ جٛومِرَاوٛ، طُمْ وَرْتَنَيَمْ نٛنْ نٛ مبِيطَا؞»‏ سٜيْ مَلَاعِکَاجٛ اٛنْ دِلِّ اَلِمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","ندٜرْ بَلْطٜ طٜنْ، مَرْيَامَ اُمِّي ندٜرْ يَوْطَارٜ يَحِ غَرِيرِ نغٛنْدِ ندٜرْ کٛشّٜىٰجٜ لٜيْدِ يَحُودِيَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","اٛ نَتِّ وُرٛ جَکَارِيَ، اٛ حٛوْنِ اَلِسَبَتُ؞ ");
INSERT INTO fuv_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","شَرٜلْ کٛ اَلِسَبَتُ نَنِ کٛوْنٛلْ مَرْيَامَ، ٻِطّٛ غٛنْطٛ ندٜرْ رٜىٰدُ مَاکٛ دِوِ نغَمْ بٜلْطُمْ، اَلِسَبَتُ بٛو حٜبِّنَا رُوحُ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","اٛ نٛدِّ مَرْيَامَ اٜ سٜمْبٜ، اٛ وِعِ، ‏«‏اَ بَرْکِطِنَاطٛ ندٜرْ رٜوْٻٜ!‏ ٻِطّٛ مٛ شَاوُطَا اٛ بَرْکِطِنَاطٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","مِنْ، مِ مٛيٜ ندٜ اِنَّ اَلْمَسِيحُ وَرَتَ تٛ اَمْ؟ ");
INSERT INTO fuv_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","ندٜ نَنُمِ کٛوْنٛلْ مَاطَ، ٻِطّٛ غٛنْطٛ ندٜرْ رٜىٰدُ اَمْ دِوِي نغَمْ بٜلْطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","اَ بَرْکِطِنَاطٛ نغَمْ اَ جَٻِي کٛ جٛومِرَاوٛ وَطَنْمَا اَلْکَوَلْ طُمْ حٜىٰوَيْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","ندٜنْ مَرْيَامَ وِعِ، ‏«‏اٜ مِ مَنْتَ جٛومِرَاوٛ اٜ ٻٜرْندٜ اَمْ فُو؞ ");
INSERT INTO fuv_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","اٜ مِ نَنَ بٜلْطُمْ طُطُّمْ ندٜرْ ٻٜرْندٜ اَمْ نغَمْ اَللَّه، کِسْنٛووٛيَمْ، ");
INSERT INTO fuv_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","نغَمْ اٛ يُرْمِنَنِييَمْ، مِنْ، کٛرْطٛ مَاکٛ، لٜسْتِنْطٛ حٛورٜ؞ دَغَ جٛونِ يِمْٻٜ دُونِيَارُ فُو نٛدِّرَيْيَمْ بَرْکِطِنَاطٛ، ");
INSERT INTO fuv_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","نغَمْ اَللَّه بَاوُطٛ وَطَنِييَمْ فِي مَوْطُمْ طُطُّمْ، اٛ شٜنِيطٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","جُرُمْطُمْ مَاکٛ جٛوطٛتٛ دٛوْ کُلٛوٻٜمٛ حَا اَبَدَا؞ ");
INSERT INTO fuv_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","اٜ مٛ وَطَ فِي مَوْطُمْ اٜ جُنْغٛ مَاکٛ سٜمْبِنْغٛ، اٜ مٛ سَنْکِتَ مَوْنِنْٻٜ کٛعٜ مَٻّٜ اٜ کٛ ٻٜ مَنْتٛرْتٛو ندٜرْ ٻٜرْطٜ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","اٜ مٛ اِتَّ لَامِيٻٜ دٛوْ لَامُ مَٻّٜ، اَمَّا اٜ مٛ مَوْنِنَ لٜسْنُٻٜ کٛعٜ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","اٜ مٛ حَرْنَ نَنٛوٻٜ وٜىٰلٛ اٜ فِي بٛطُّمْ، اَمَّا اٜ مٛ اَلَ رِسْکُٻٜ جُوطٜ مٜىٰرٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","اٜ مٛ وَلَّ يِمْٻٜ اِسْرَاعِيلَ مَشُّٻٜ مَاکٛ، اٛ يٜجِّتَتَا يُرْمِنَنْکِ ");
INSERT INTO fuv_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","اِبْرَاهِمْ اٜ لٜݧٛلْ مُوطُمْ حَا اَبَدَا، نٛ اٛ وِعُنٛو مَامَعٜنْ مٜىٰطٜنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","مَرْيَامَ جٛوطٛدَکٜ اٜ اَلِسَبَتُ کٛ وَطِ لٜبِّ تَتِ، ندٜنْ اٛ سٛعِّي وُرٛ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","ندٜ شَرٜلْ دَݧُکِ اَلِسَبَتُ وَطِ، اٛ دَݧِ ٻِطّٛ غٛرْکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","ٻٜ اٛ حٜدِّ اٜ بَنْدِرَاٻٜ مَاکٛ ٻٜ نَنِدِ بٜلْطُمْ اٜ مَاکٛ ندٜ ٻٜ نَنِ جٛومِرَاوٛ يُرْمِنَنِمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","ندٜ ٻِنْغٜلْ نغٜلْ وَطِ بَلْطٜ جٛوٜىٰتَتِ، ٻٜ نغَرِ نَادُکِنغٜلْ؞ ٻٜ نغِطِينٛ نٛدَّنْکِنغٜلْ اِنْدٜ ݧَاکٛ مَاغٜلْ جَکَارِيَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","اَمَّا مَدُوجٛ مَاغٜلْ وِعِ، ‏«‏نَاع نٛنْ، طُمْ نٛدَّنَنغٜلْ يَحَيَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","ٻٜ مبِعِمٛ، ‏«‏وَلَا غٛطّٛ ندٜرْ لٜݧٛلْ مَاطَ غٛودُطٛ اِنْدٜ ندٜنْ طٛنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","سٜيْ ٻٜ مٜتِرَنِ ݧَاکٛ مَاغٜلْ جُوطٜ، نغَمْ ٻٜ اَنْدَ اِنْدٜ ندٜ اٛ يِطِ طُمْ نٛدَّنَنغٜلْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","جَکَارِيَ حٛلِّٻٜ اٜ مٛ يِطِ اَلّٛوَلْ، اٛ وِنْدِ، ‏«‏اِنْدٜ مَاغٜلْ يَحَيَ؞»‏ ٻٜ فُو فِي طُمْ حُلْنِيٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","طٛنْ اٜ طٛنْ، حٛنْدُکٛ مَاکٛ مَٻِّتِي، طٜمْنغَلْ مَاکٛ يٛوفِ، ندٜنْ اٛ فُطِّ مٜتُکِ، اٜ مٛ مَنْتَ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","کُلٛلْ نَنْغِ ٻٜ اٛ حٜدِّ فُو، کٛو مٛيٜ وَطِ کَ مٜتُکِ دٛوْ فِي طُمْ فُو ندٜرْ کٛشّٜىٰجٜ لٜيْدِ يَحُودِيَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","کٛو مٛيٜ نَنْطٛ فِي طُعُمْ ݧُمِ دٛوْ مَاجُمْ، اٜ وِعَ، ‏«‏طُمٜ ٻِنْغٜلْ نغٜعٜلْ وَرْتَتَ تٛ مَوْنِ؟»‏ نغَمْ جُنْغٛ جٛومِرَاوٛ اٜ وٛنْدِ اٜ مَاغٜلْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","جَکَارِيَ، ݧَاکٛ ٻِنْغٜلْ نغٜلْ، اٜ حٜىٰوِ رُوحُ اَللَّه، وَطِ اَنَّبَاکُ، اٛ وِعِ، ");
INSERT INTO fuv_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","‏«‏اٜنْ مَنْتُ جٛومِرَاوٛ، اَللَّه اِسْرَاعِيلَ، نغَمْ اٛ وَرٛيِي اٛ رِمْطِنِي يِمْٻٜ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","اَللَّه وَدَّنِيعٜنْ کِسْنٛووٛ مَوْطٛ پِوٛيْطٛ دَغَ لٜݧٛلْ دَوْدَ، مَشُّطٛ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","نٛ اٛ وِعُنٛو ندٜرْ کٛنْدُطٜ اَنَّبٛعٜنْ مَاکٛ شُٻَاٻٜ دَغَ کٛ نٜىٰٻِ، ");
INSERT INTO fuv_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","اٛ حِسْنَيْعٜنْ دَغَ غَݧٛوٻٜ مٜىٰطٜنْ اٜ کَلَّنْٻٜعٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","اٛ وِعِينٛ اٛ يُرْمِنَنَيْ مَامَعٜنْ مٜىٰطٜنْ، اٛ يٜجِّتَتَا اَلْکَوَلْ مَاکٛ شٜنِينغَلْ، ");
INSERT INTO fuv_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","نغَلْ اٛ وَطَنّٛو مَامَ مٜىٰطٜنْ اِبْرَاهِمْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","اٛ وِعِي اٛ حِسْنَيْعٜنْ دَغَ جُوطٜ غَݧٛوٻٜ مٜىٰطٜنْ، نغَمْ کُوَنٜنْمٛ کُلٛلْ وَلَا، ");
INSERT INTO fuv_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","نجٛوطٛوطٜنْ جٛنْدٜ شٜنِيندٜ اٜ اَادِلَاکُ يٜىٰسٛ مَاکٛ ندٜرْ بَلْطٜ مٜىٰطٜنْ فُو، نغَطٜنْ کٛو طُمٜ کٛ اٛ وِعِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","‏«‏اَنْ ٻِنْغٜلْ اَمْ، طُمْ نٛدِّرْتٜ اَنَّبِيجٛ جٛومِرَاوٛ جٛومُ مَنْغُ، اَ اَرْتَيْ اَلْمَسِيحُ وَرْکِ نغَمْ مٛعِّنَنَامٛ لَاوٛلْ، ");
INSERT INTO fuv_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","نغَمْ اَنْدِنَا يِمْٻٜ مَاکٛ طُمْ حِسْنَيْٻٜ لَاوٛلْ يَافَاکِ حَکّٜ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","اَللَّه وَطِي فِي طُعُمْ نغَمْ اٛ کٜىٰوُطٛ جُرُمْطُمْ؞ نغَمْ جُرُمْطُمْ مَاکٛ، اَلْمَسِيحُ وَرٛيَيْ تٛ مٜىٰطٜنْ دَغَ دٛوْ نٛ نَانغٜ وُرْتِرٛيْتٛو، ");
INSERT INTO fuv_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","نغَمْ اٛ يٜيْنَنٛو وٛنْٻٜ ندٜرْ ݧِوْرٜ اٜ ندٜرْ کُلٛلْ مَيْدٜ، طُمْ تٛکِّنَيْ کٛيْطٜ مٜىٰطٜنْ دٛوْ لَاوٛلْ جَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","ٻِطّٛ اٛنْ مَوْنِ، فَامُ مَاکٛ ٻٜيْدِي؞ اٜ مٛ جٛوطِي ندٜرْ لَدّٜ حَا شَرٜلْ کٛ طُمْ اَنْدِنِمٛ تٛ يِمْٻٜ اِسْرَاعِيلَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","شَرٜلْ کٛ يَحَيَ غَطٛووٛ بَڤْتِسْمَ دَݧَا، مَوْطٛ لَامِيٻٜ لٜيْطٜ رٛومَ بِعٜتٜىٰطٛ کَيْسَرْ اَغُسْتُسْ وِعِ وٛنْٻٜ ندٜرْ لَامُ رٛومَ فُو طُمْ وِنْدَ اِنْطٜ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","کَنْکِ وٛنِ وِنْدُکِ اَرَنْدٜحِ کِ طُمْ وَطِ شَرٜلْ کٛ کِرِينِيُسْ وٛنِ غٛمْنَاجٛ لٜيْدِ سِيرِيَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","کٛو مٛيٜ يَحِ تٛ لٜݧٛلْ مُوطُمْ پِوٛيِ نغَمْ طُمْ وِنْدَ اِنْدٜ مُوطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","سٜيْ يُسُفُ مَا اُمِّي دَغَ غَرِيرِ نَجَرَتْ ندٜرْ لٜيْدِ غَلِيلِ؞ اٛ يَحِ غَرِيرِ تٛ دَوْدَ دَݧَا بِعٜتٜىٰندِ بَيْتَلَامِ نغٛنْدِ ندٜرْ لٜيْدِ يَحُودِيَ، نغَمْ کَنْکٛ دَغَ لٜݧٛلْ دَوْدَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","اٛ يَحُ تٛنْ نغَمْ طُمْ وِنْدَ اِنْدٜ مَاکٛ، کَنْکٛ اٜ مَرْيَامَ، مٛ طُمْ وَطَنِمٛ اَلْکَوَلْ تٜىٰغَلْ؞ مَرْيَامَ اٛنْ اٜ وٛودِ رٜىٰدُ؞ ");
INSERT INTO fuv_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","اٜ ٻٜ ندٜرْ بَيْتَلَامِ، سٜيْ شَرٜلْ دَݧْنغٛلْ مَاکٛ وَطِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","سٜيْ اٛ دَݧِ ٻِطّٛ غٛرْکٛ، اَفٛ مَاکٛ، اٛ سَاوِمٛ ندٜرْ وُدٜرٜ وٛوطُندٜ، اٛ فُکِّنِمٛ ندٜرْ تٛ طُمْ وَطَنْتَ مَرْلٜ ݧَمْندُ، نغَمْ وَلَا نجَيْرِ ندٜرْ سُودُ حٛٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","اٜ وٛودِ وٛيْنَاٻٜ حَادٜ طٛنْ اٜ ٻٜ مبَالَ يَاسِ، اٜ ٻٜ ندٜىٰنَ مَرْلٜ مَٻّٜ جٜمَّ؞ ");
INSERT INTO fuv_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","سٜيْ مَلَاعِکَاجٛ جٛومِرَاوٛ وَنْغَنِٻٜ ندٜرْ تٜدُّنغَلْ جٛومِرَاوٛ، کُلٛلْ نَنْغِٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","اَمَّا مَلَاعِکَاجٛ اٛنْ وِعِٻٜ، ‏«‏تٛع اٛنْ کُلُ!‏ مِ وَدَّنِيعٛنْ حَبَرُ ٻُرْطُمْ وٜلْکِ نغَمْ کٛو مٛيٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","حَنْدٜ ندٜرْ غَرِيرِ دَوْدَ طُمْ دَݧَنِيعٛنْ کِسْنٛووٛ، کَنْکٛ وٛنِ اَلْمَسِيحُ، جٛومِرَاوٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","رَا نٛ کٜٻْتِرْتٛنْمٛ، اٛنْ تَوَيْ ٻِنْغٜلْ اٜ سَاوَا ندٜرْ وُدٜرٜ، ندٜنْ اٜ نغٜلْ فُکِّنَا ندٜرْ تٛ طُمْ وَطَنْتَ مَرْلٜ ݧَمْندُ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","طٛنْ اٜ طٛنْ سٜيْ وٛٻّٜ مَلَاعِکَعٜنْ طُطْٻٜ وَنْغِ حَادٜ مَلَاعِکَاجٛ اٛنْ، اٜ ٻٜ مَوْنِنَ مَنْغُ اَللَّه، اٜ ٻٜ مبِعَ، ");
INSERT INTO fuv_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","‏«‏اٜنْ مَوْنِنْ اَللَّه مٛ دٛوْ، جَمْ جٛوطٛو ندٜرْ دُونِيَارُ اٜ دٛوْ يِمْٻٜ ٻٜ اٛ نَنَتَ بٜلْطُمْ مَٻّٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","ندٜ مَلَاعِکَعٜنْ ٻٜنْ شٛعِّي دٛوْ، سٜيْ وٛيْنَاٻٜ ٻٜنْ نغَطِ کَ مٜدُّکِ، اٜ ٻٜ مبِعَ، ‏«‏اٜنْ نجَحُ بَيْتَلَامِ نغِعٜنْ فِي طُعُمْ طُمْ جٛومِرَاوٛ وِعِعٜنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","سٜيْ ٻٜ نجَوْطِي، ٻٜ نجَحِ، ٻٜ تَوِ مَرْيَامَ اٜ يُسُفُ اٜ ٻِنْغٜلْ نغٜلْ اٜ نغٜلْ فُکِّي ندٜرْ تٛ طُمْ وَطَنْتَ مَرْلٜ ݧَمْندُ؞ ");
INSERT INTO fuv_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","ندٜ ٻٜ نغِعِنغٜلْ، ٻٜ ندِلِّ، ٻٜ مبِعِ يِمْٻٜ کٛ مَلَاعِکَاجٛ وِعِٻٜ دٛوْ مَاغٜلْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","کٛ وٛيْنَاٻٜ ٻٜنْ مبِعِ کَيْطِنِي کٛو مٛيٜ نَنْطٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","اَمَّا مَرْيَامَ بٛو اٜ جٛغِي کٛ نَنِ فُو ندٜرْ ٻٜرْندٜ مُوطُمْ، اٛ وَطِ کَ ݧُمُکِ دٛوْ مَاجُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","سٜيْ وٛيْنَاٻٜ ٻٜنْ شٛعِّي، اٜ ٻٜ مَوْنِنَ اَللَّه، اٜ ٻٜ مَنْتَمٛ نغَمْ کٛو طُمٜ کٛ ٻٜ نَنِ اٜ کٛ ٻٜ نغِعِ، نٛنْ نٛ طُمْ وِعِرِٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","ندٜ ٻِنْغٜلْ نغٜلْ وَطِ بَلْطٜ جٛوٜىٰتَتِ، طُمْ نَادِمٛ طُمْ حٛکِّمٛ اِنْدٜ يٜىٰسُ، اِنْدٜ ندٜ مَلَاعِکَاجٛ حٛکِّمٛ کٛ طُمْ وَطَ رٜىٰدُ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","غَطَ بَلْطٜ لٛوتَاکِ مَٻّٜ حٜىٰݧِ نٛ اَنَّبِ مُوسَ وِعِ ندٜرْ اَتَّوْرَ ٻٜ نغَطَ تٛ ٻٜ ندَݧِي، يُسُفُ اٜ مَرْيَامَ نجَارِ يٜىٰسُ اُرُشَلِيمَ يٜىٰسٛ جٛومِرَاوٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","نٛنْ طُمْ وِنْدِرَا ندٜرْ اَتَّوْرَ، ‏«‏کٛو مٛيٜ غٛرْکٛ اَفٛ، جٛومِرَاوٛ جٜيِمٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","ٻٜ شَکَّنِ اَللَّه نٛ طُمْ وِنْدِرَا ندٜرْ اَتَّوْرَ، ‏«‏ڤٛولِ طِطِ کٛو بٛو تَتَّبَرَحٛيْ طِطٛيْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","اٜ شَرٜلْ نغٜلْ اٜ وٛودِ غٛطّٛ نٜطّٛ ندٜرْ اُرُشَلِيمَ بِعٜتٜىٰطٛ سَامِنُ، اَادِلِيجٛ، کُلٛووٛ اَللَّه؞ اٛ حَاٻِي اٛ يِعَ غَرٛلْ اَلْمَسِيحُ نغَمْ حِسْنَ يِمْٻٜ اِسْرَاعِيلَ؞ رُوحُ اَللَّه اٜ وٛنْدِ اٜ مَاکٛ، ");
INSERT INTO fuv_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","حٛلِّيمٛ اٛ مَايَتَا نَا اٛ يِعِي اَلْمَسِيحُ جٛومِرَاوٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","رُوحُ اَللَّه يَارِمٛ ندٜرْ وُرٛ شٜنِينغٛ؞ سٜيْ مَرْيَامَ اٜ يُسُفُ نغَدّٛيِ يٜىٰسُ ندٜرْ وُرٛ نغٛنْ نغَمْ وَطَنْکِمٛ کٛ اَتَّوْرَ وِعِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","سَامِنُ جَٻِ ٻِنْغٜلْ نغٜلْ ندٜرْ جُوطٜ مُوطُمْ، ندٜنْ مَنْتِ اَللَّه، وِعِ، ");
INSERT INTO fuv_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","‏«‏يَا جٛومِرَاوٛ، اَ حٜبِّنِي اَلْکَوَلْ مَاطَ؞ جٛونِ اَلُ مَشُّطٛ مَاطَ دِلَّ جَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","نغَمْ غِتٜ اَمْ نغِعِي کِسْنٛووٛ مٛ لِلٛيْطَا، ");
INSERT INTO fuv_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","مٛ شِرْيَنِطَا لٜݧِ فُو؞ ");
INSERT INTO fuv_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","اٛ وَرْتَيْ بٛ جَيْنغٛلْ، اٛ حٛلَّيْ لٜݧِ دُونِيَارُ لَاوٛلْ مَاطَ، اٛ وَطَيْ يِمْٻٜ مَاطَ يَحُودَنْکٛعٜنْ کٜٻَ مَنْغُ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","ݧَاکٛ ٻِنْغٜلْ نغٜلْ اٜ مَدُوجٛ مَاغٜلْ ٻٜ کَيْطِنِ اٜ کٛ طُمْ وِعِ دٛوْ مَاغٜلْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","سٜيْ سَامِنُ بَرْکِطِنِٻٜ، ندٜنْ اٛ وِعِ مَرْيَامَ، مَدُوجٛ يٜىٰسُ، ‏«‏ٻِنْغٜلْ نغٜعٜلْ وَرْتَيْ طَتَلْ يَنُکِ طُطْٻٜ اٜ اُمَّاکِ طُطْٻٜ ندٜرْ لٜيْدِ اِسْرَاعِيلَ؞ نغٜلْ وَرْتَيْ اَنْدِتِرْطُمْ دَغَ اَللَّه طُمْ يِمْٻٜ طُطْٻٜ نغَݧَتَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ٻِطّٛ اٛعٛ وَنْغِنَيْ ݧُمٛوجِ يِمْٻٜ شُوطِيطِ؞ اَنْ مَا، ٻٜرْندٜ مَاطَ نَاوَيْ بٛنٛ کَافَحِ تُفِندٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","طٛنْمَا اٜ وٛودِ اَنَّبِيجٛ دٜبّٛ بِعٜتٜىٰطٛ حَنَّتُ ٻِي فَانُوٜلْ، پِوٛيْطٛ دَغَ لٜݧٛلْ اَاشِرُ؞ دٜبّٛ اٛنْ اٛ نَيٜىٰجٛ، اٛ جٛوطٛدَکٜ اٜ غٛرْکٛ مَاکٛ دُوٻِ جٛوٜىٰطِطِ، ندٜنْ غٛرْکٛ اٛنْ مَايِي؞ ");
INSERT INTO fuv_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","غَطَ غٛرِيکٛ مَايِ، اٛ جٛوطِي اٛ تٜعَاکَ حَا دُوٻِ مَاکٛ نغَطِ 48؞ کٛو ندٜيٜ اٜ مٛ يَحَ وُرٛ شٜنِينغٛ اٜ مٛ مَوْنِنَ اَللَّه، اٜ مٛ سُومٛو، اٜ مٛ وَطَ دٛعَارٜ جٜمَّ اٜ ݧَلَوْمَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","اٜ شَرٜلْ نغٜلْ، اٛ وَرٛيِ تٛ مَٻّٜ، اٛ يٜتِّ اَللَّه، اٛ يَحِ تٛ کَاٻُٻٜ يِعُکِ شَرٜلْ کٛ اَللَّه رِمْطِنْتَ اُرُشَلِيمَ، اٛ حٛکِّٻٜ حَبَرُ دٛوْ ٻِنْغٜلْ نغٜلْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","ندٜ يُسُفُ اٜ مَرْيَامَ نجٛتِّنِ کٛو طُمٜ کٛ اَتَّوْرَ وِعِ طُمْ وَطَ، ٻٜ شٛعِّي غَرِيرِ مَٻّٜ نَجَرَتْ ندٜرْ لٜيْدِ غَلِيلِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","يٜىٰسُ مَوْنِ، سٜمْبِطِ، فَامُ حٜىٰوِمٛ، ندٜنْ بَرْکَ اَللَّه اٜ دٛوْ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","کٛو طُمٜ ندُنْغُ دَݧٛوٻٜ يٜىٰسُ اٜ نجَحَ اُرُشَلِيمَ نغَمْ حُمْتٛ سَکِّنْکِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","ندٜ يٜىٰسُ وَطِ دُوٻِ سَڤّٛ اٜ طِطِ، ٻٜ نجَحِ حُمْتٛ نٛ ٻٜ مبٛووِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","غَطَ حُمْتٛ نغٛنْ حٜىٰݧِ، دَݧٛوٻٜ مَاکٛ اٜ دٛوْ طَتَلْ حٛوتُکِ وُرٛ، يٜىٰسُ بٛو دَرِي ندٜرْ اُرُشَلِيمَ، اَمَّا دَݧٛوٻٜ ٻٜنْ اَنْدَا اٛ دَرَکٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","اٜ ٻٜ کَمِّي اٜ مٛ ندٜرْ ٻٜ ٻٜ نجَادَتَ، ٻٜ نغَطِ يَادُ ݧَلْندٜ غٛعٛ، ندٜنْ ٻٜ ڤُطِّ طَٻُّتُکِمٛ ندٜرْ بَنْدِرَاٻٜ مَٻّٜ اٜ حِغٛوٻٜ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ندٜ ٻٜ طَٻِّتِ ٻٜ کٜٻْتَايِمٛ، ٻٜ شٛعِّي اُرُشَلِيمَ نغَمْ طَٻُّتُکِمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","ندٜرْ ݧَلْندٜ تَتَوْرٜ ٻٜ تَوِمٛ ندٜرْ وُرٛ شٜنِينغٛ، اٜ مٛ جٛوطِي حَکُّندٜ مٛودِٻّٜ، اٜ مٛ نَنَٻٜ، ندٜنْ اٜ مٛ پَمَٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","نَنْطٛمٛ فُو حَيْطِنِ اٜ فَامُ مَاکٛ اٜ نٛوتَاکِ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","ندٜ دَݧٛوٻٜ مَاکٛ نغِعِمٛ، ٻٜ کَيْطِنِ؞ مَدُوجٛ مَاکٛ وِعِمٛ، ‏«‏ٻِطّٛ اَمْ، کٛ وَطِ نغَطَنْطَامِنْ نِينِ؟ مِنْ اٜ ݧَاکٛ مَاطَ ندٜ مِنْ طَٻِّتِ مِنْ نغِعَايِمَ، مِنْ نغَنِّي؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","اٛ وِعِٻٜ، ‏«‏کٛ وَطِ طَٻِّتٛتٛيْيَمْ؟ اٛنْ اَنْدَا اٜ حَانِ مِ جٛوطٛو ندٜرْ وُرٛ ݧَاکٛ اَمْ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","اَمَّا ٻٜ فَامَايِ کٛ اٛ وِعِٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","سٜيْ يٜىٰسُ سٛعّٛدِي اٜ مَٻّٜ نَجَرَتْ، اٜ مٛ وَطَ کٛ ٻٜ مبِعِمٛ فُو؞ مَدُوجٛ مَاکٛ جٛغِي فِي طُعُمْ فُو ندٜرْ ٻٜرْندٜ مُوطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","يٜىٰسُ مَوْنِ، ٻٜيْدِ فَامُ اٜ حٜٻُکِ يِدّٜ دَغَ تٛ اَللَّه اٜ تٛ يِمْٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","مَوْطٛ لَامِيٻٜ لٜيْطٜ رٛومَ بِعٜتٜىٰطٛ کَيْسَرْ تِبَارِيَ اٜ وٛودِ دُوٻِ سَڤّٛ اٜ جٛوِ دٛوْ لَامُ، اٜ شَرٜلْ نغٜلْ بُنْتُسْ بِلَاتُسْ وٛنِ غٛمْنَاجٛ لٜيْدِ يَحُودِيَ؞ حِرُدُسْ بٛو اٜ لَامِي لٜيْدِ غَلِيلِ، مَوْنِيکٛ فِلِبُسْ بٛو اٜ لَامِي لٜيْدِ اِتُورِيَ اٜ تَرَکُنِيتَسْ، ندٜنْ لِسَانِيَسْ اٜ لَامِي لٜيْدِ اَبِيلِيَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","حَنَانَ اٜ کَيَافَ بٛو نغٛنِ مَوْٻٜ مَوْٻٜ اَرْدِيٻٜ دِينَ؞ اٜ شَرٜلْ نغٜلْ وٛلْدٜ اَللَّه وَرَنِ يَحَيَ، ٻِطّٛ جَکَارِيَ، ندٜرْ لَدّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","نغَمْ نٛنْ، يَحَيَ يَحِ بِغٜىٰجٜ غٛنْطٜ حَادٜ شَانغٛلْ اُرْدُنْ فُو، اٜ مٛ وَعَجِنَ، اٜ مٛ وِعَ، ‏«‏تُوبٜىٰ، طُمْ وَطَنَعٛنْ بَڤْتِسْمَ، ندٜنْ اَللَّه يَافَنْتٛعٛنْ حَکّٜىٰجِ مٛوطٛنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","نٛ طُمْ وِنْدِرَا ندٜرْ دٜفْتٜرٜ اَنَّبِ اِشَايَ دٛوْ يَحَيَ، ‏«‏غٛطّٛ اٜ نٛدَّ ندٜرْ لَدّٜ اٜ وِعَ، ‏‹‏مٛعِّنٜىٰ طَتَلْ جٛومِرَاوٛ، ڤٛرْتٜىٰ لَاوٛلْ نغَمْ غَرٛلْ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","ڤٛغٛوجِ فُو طِ کٜبِّنْتٜىٰطِ، کٛشّٜىٰجٜ اٜ پٛولٜ فُو طٜ نَمٜتٜىٰطٜ؞ طَتٜ غُورِيطٜ طٜ دَرْتِنْتٜىٰطٜ، طَتٜ بٛنِّيطٜ طٜ مٛعِّنْتٜىٰطٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","يِمْٻٜ دُونِيَارُ فُو ٻٜ نغِعَيْ کِسْندَمْ اَللَّه؞›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","يِمْٻٜ طُطْٻٜ نغَرٛيِ تٛ يَحَيَ نغَمْ اٛ وَطَنَٻٜ بَڤْتِسْمَ؞ اٛ وِعِٻٜ، ‏«‏اٛنٛنْ ٻِٻّٜ بٛولٜ!‏ مٛيٜ وِعِعٛنْ ندٛغّٛنْ بٛنٜ غَرَيْطُمْ؟ ");
INSERT INTO fuv_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","نغَطٜىٰ کٛ حٛلَّتَ اٛنْ اَلِي حَکّٜىٰجِ مٛوطٛنْ؞ تٛع اٛنْ مبِعُ ندٜرْ ٻٜرْطٜ مٛوطٛنْ، ‏‹‏مِنٛنْ، مِنْ ٻِٻّٜ اَنَّبِ اِبْرَاهِمْ؞›‏ نغَمْ اٜ مِ وِعَعٛنْ، اَللَّه وَاوَيْ اُمِّنَنْکِ اَنَّبِ اِبْرَاهِمْ ٻِٻّٜ دَغَ ندٜرْ کَاپٜ طٜعٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","کٛو جٛونِ فٜعِّرْدٜ پٜفْتَامَ نغَمْ فٜعَّ لٜطّٜ دَغَ طَطِ مَاجٜ؞ لٜکِّ فُو کِ رِمَتَا ٻِکّٛيْ مبٛطْکٛيْ، طُمْ فٜعَّيْکِ طُمْ فَطَّکِ ندٜرْ حِيتٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","يِمْٻٜ مبِعِمٛ، ‏«‏کٛ حَانِ مِنْ نغَطَ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","يَحَيَ وِعِٻٜ، ‏«‏غٛودُطٛ تٛغّٛوجٜ طِطِ فُو حٛکَّ مٛ وَلَنَا غٛعٛ، ندٜنْ غٛودُطٛ ݧَمْندُ فُو حٛکّٛرَ مٛ وَلَنَا؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","جَٻٛوٻٜ شٜىٰدٜ لٜيْدِ مَا نغَرِ نغَمْ ٻٜ نغَطَنٜىٰ بَڤْتِسْمَ، ٻٜ مبِعِمٛ، ‏«‏مٛودِبّٛ، کٛ حَانِ مِنْ نغَطَ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","اٛ وِعِٻٜ، ‏«‏تٛع اٛنْ نجَٻُ کٛ ٻُرِ نٛ طُمْ وِعِعٛنْ نجَٻٛنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","وٛٻّٜ سٛوجِعٜنْ پَمِمٛ مبِعِ، ‏«‏مِنٛنْ مَا، کٛ حَانِ مِنْ نغَطَ؟»‏ اٛ وِعِٻٜ، ‏«‏تٛع اٛنْ تٜىٰتَنْ يِمْٻٜ شٜىٰدٜ اٜ سٜمْبٜ، تٛع اٛنْ مبِعُ يِمْٻٜ نغَطِي کٛ ٻٜ نغَطَايِ نغَمْ نجَٻَنٛنْٻٜ شٜىٰدٜ؞ مُݧٜىٰ دٛوْ کٛ طُمْ يٛٻَتَعٛنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","يِمْٻٜ کَاٻِي نغِعَ اَلْمَسِيحُ؞ کٛو مٛيٜ ندٜرْ مَٻّٜ اٜ ݧُمَ ندٜرْ ٻٜرْندٜ مُوطُمْ کٛو يَحَيَ وٛنِ اَلْمَسِيحُ؞ ");
INSERT INTO fuv_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","يَحَيَ وِعِٻٜ، ‏«‏اٜ مِ وَطِرَنَعٛنْ بَڤْتِسْمَ اٜ ندِيَمْ، اَمَّا ٻُرْطٛيَمْ مَنْغُ اٜ وَرَ؞ مِ فٛتَايِ فِتُّکِ لٛکُّلِّ ڤَطٜ مَاکٛ؞ اٛ وَطِرَنَيْعٛنْ بَڤْتِسْمَ اٜ رُوحُ اَللَّه اٜ حِيتٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","اٜ مٛ جٛغِي بٜسِرْطُمْ غَوْرِ مَاکٛ نغَمْ سٜنْدُکِ غَوْرِ اٜ ݧَاندٜ؞ اٛ حَوْرِتَيْ غَوْرِ ندِنْ، اٛ وَطَندِ ندٜرْ رٜسِرْدٜ غَوْرِ مَاکٛ، اَمَّا اٛ وُلَ ݧَاندٜ ندٜنْ ندٜرْ حِيتٜ نغٜ وَاتَتَا؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","نٛنْ يَحَيَ وَغِّنِ يِمْٻٜ اٜ بٛلِيطٜ طُطّٜ، اٛ اَنْدِنِيٻٜ حَبَرُ بٜلْطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","ندٜنْ اٛ حَٻَنِ حِرُدُسْ لَامِيطٛ لٜيْدِ نغَمْ تٜعِ دٜبّٛ مَوْنِرَاوٛ مُوطُمْ بِعٜتٜىٰطٛ حِرُودِيَ، کَدِمَا نغَمْ کُوطٜ کَلُّطٜ فُو طٜ اٛ وَطِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","سٜيْ اٛ ٻٜيْدِ وَطُکِ کٛ ٻُرِ نٛنْ، اٛ وَطِ طُمْ مَٻِّ يَحَيَ ندٜرْ سُودُ شُرَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","ندٜ يِمْٻٜ فُو نغَطَنَا بَڤْتِسْمَ، يٜىٰسُ مَا وَطَنَا بَڤْتِسْمَ؞ اٜ مٛ ندٜرْ وَطُکِ دٛعَارٜ، سٜيْ دَمُّغَلْ دٛوْ مَٻِّتِي؞ ");
INSERT INTO fuv_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","رُوحُ اَللَّه جِڤّٛيِي دٛوْ مَاکٛ اٜ ٻَنْدُ بٛ فٛوندُ؞ حٛنٛنْدٜ پِوٛيِ دَغَ دٛوْ وِعِ، ‏«‏اَنْ وٛنِ ٻِطّٛ اَمْ، مٛ نغِطُمِ؞ اٜ مِ نَنَ بٜلْطُمْ مَاطَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","کٛ يٜىٰسُ فُطِّ کُوغَلْ مُوطُمْ، اٛ ٻَدَکٜ دُوٻِ 30؞ يِمْٻٜ اٜ ݧُمَ يٜىٰسُ طُمْ ٻِطّٛ يُسُفُ؞ يُسُفُ ٻِطّٛ حٜىٰلِ، ");
INSERT INTO fuv_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","حٜىٰلِ ٻِطّٛ مَتَتْ، مَتَتْ ٻِطّٛ لٜىٰوِ، لٜىٰوِ ٻِطّٛ مَلْکِ، مَلْکِ ٻِطّٛ يَنَّ، يَنَّ ٻِطّٛ يُسُفُ، ");
INSERT INTO fuv_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","يُسُفُ ٻِطّٛ مَتَاتِيَ، مَتَاتِيَ ٻِطّٛ اَمٛسْ، اَمٛسْ ٻِطّٛ نَاحُمْ، نَاحُمْ ٻِطّٛ اَجَلِيَ، اَجَلِيَ ٻِطّٛ نَجَيَ، ");
INSERT INTO fuv_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","نَجَيَ ٻِطّٛ مَعَتَ، مَعَتَ ٻِطّٛ مَتَاتِيَ، مَتَاتِيَ ٻِطّٛ شِمٜىٰيَ، شِمٜىٰيَ ٻِطّٛ جٛوسٜکْ، جٛوسٜکْ ٻِطّٛ يَحُودَ، ");
INSERT INTO fuv_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","يَحُودَ ٻِطّٛ يٛوَانَنْ، يٛوَانَنْ ٻِطّٛ رٜفَيَ، رٜفَيَ ٻِطّٛ جَرُوبَبٜلْ، جَرُوبَبٜلْ ٻِطّٛ شٜيَلْتِيَلْ، شٜيَلْتِيَلْ ٻِطّٛ نٜىٰرِ، ");
INSERT INTO fuv_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","نٜىٰرِ ٻِطّٛ مَلْکِ، مَلْکِ ٻِطّٛ اَدِّ، اَدِّ ٻِطّٛ کٛسْمَ، کٛسْمَ ٻِطّٛ اَلْمَدَمَ، اَلْمَدَمَ ٻِطّٛ اٜرْ، ");
INSERT INTO fuv_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","اٜرْ ٻِطّٛ جٛوشُوَ، جٛوشُوَ ٻِطّٛ اٜلِيٜىٰجَ، اٜلِيٜىٰجَ ٻِطّٛ يٛرِمْ، يٛرِمْ ٻِطّٛ مَتَتْ، مَتَتْ ٻِطّٛ لٜىٰوِ، ");
INSERT INTO fuv_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","لٜىٰوِ ٻِطّٛ سَامِنُ، سَامِنُ ٻِطّٛ يَحُودَ، يَحُودَ ٻِطّٛ يُسُفُ، يُسُفُ ٻِطّٛ يٛنَنَ، يٛنَنَ ٻِطّٛ اٜلِيَاکِمْ، ");
INSERT INTO fuv_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","اٜلِيَاکِمْ ٻِطّٛ مَلَيَ، مَلَيَ ٻِطّٛ مَيْنَنَ، مَيْنَنَ ٻِطّٛ مَتَاتَ، مَتَاتَ ٻِطّٛ نَاتَنْ، نَاتَنْ ٻِطّٛ دَوْدَ، ");
INSERT INTO fuv_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","دَوْدَ ٻِطّٛ جٜىٰسِ، جٜىٰسِ ٻِطّٛ اٛبِدَ، اٛبِدَ ٻِطّٛ بٛعَاجَ، بٛعَاجَ ٻِطّٛ سَلْمٛنْ، سَلْمٛنْ ٻِطّٛ نَاشٛنْ، ");
INSERT INTO fuv_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","نَاشٛنْ ٻِطّٛ اَمِينَدَبْ، اَمِينَدَبْ ٻِطّٛ اَرَمْ، اَرَمْ ٻِطّٛ حٜسٜرُونَ، حٜسٜرُونَ ٻِطّٛ فٜرٜسَ، فٜرٜسَ ٻِطّٛ يَحُودَ، ");
INSERT INTO fuv_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","يَحُودَ ٻِطّٛ يَاکُبُ، يَاکُبُ ٻِطّٛ اِشِيَاکُ، اِشِيَاکُ ٻِطّٛ اِبْرَاهِمْ، اِبْرَاهِمْ ٻِطّٛ تٜىٰرَ، تٜىٰرَ ٻِطّٛ نَاحٛ، ");
INSERT INTO fuv_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","نَاحٛ ٻِطّٛ سٜرُغْ، سٜرُغْ ٻِطّٛ رٜيُ، رٜيُ ٻِطّٛ فٜىٰلٜ، فٜىٰلٜ ٻِطّٛ اٜبٜرْ، اٜبٜرْ ٻِطّٛ شٜىٰلَ، ");
INSERT INTO fuv_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","شٜىٰلَ ٻِطّٛ کٜنَنْ، کٜنَنْ ٻِطّٛ اَرْفَکَشَادِ، اَرْفَکَشَادِ ٻِطّٛ شٜمْ، شٜمْ ٻِطّٛ نُحُ، نُحُ ٻِطّٛ لَمٜکْ، ");
INSERT INTO fuv_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","لَمٜکْ ٻِطّٛ مٜتُسٜلَ، مٜتُسٜلَ ٻِطّٛ اٜنٛکْ، اٜنٛکْ ٻِطّٛ يَرٜدْ، يَرٜدْ ٻِطّٛ مَحَالَلٜلْ، مَحَالَلٜلْ ٻِطّٛ کٜنَنْ، ");
INSERT INTO fuv_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","کٜنَنْ ٻِطّٛ اٜنٛشْ، اٜنٛشْ ٻِطّٛ شِيتُ، شِيتُ ٻِطّٛ اَادَمُ، اَادَمُ مٛ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","يٜىٰسُ پِوٛيِ دَغَ شَانغٛلْ اُرْدُنْ اٜ حٜىٰوِ رُوحُ اَللَّه؞ سٜيْ رُوحُ اَللَّه يَارِمٛ ندٜرْ لَدّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","تٛنْ اٛ وَطِ بَلْطٜ 40 شٜيْطَنْ اٜ فٛوندَمٛ، اٛ ݧَامَايِ غٛطُّمْ ندٜرْ بَلْطٜ طٜنْ؞ ندٜنْ غَطَ مَاجٜ، وٜىٰلٛ نَنْغِمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","شٜيْطَنْ وِعِمٛ، ‏«‏تٛ اَنْ وٛنِ ٻِطّٛ اَللَّه، وِعُ ندٜعٜ حَيْرٜ وَرْتَ بُرٛودِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","يٜىٰسُ نٛوتِي وِعِمٛ، ‏«‏اَايَارٜ وِعِي، ‏‹‏نَاع اٜ ݧَمْندُ تَنْ نٜطّٛ مَرٛرْتٛو؞›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","سٜيْ شٜيْطَنْ يَارِمٛ وٛنْدٜ وِغٜىٰرٜ تٛوْندٜ، بٛ مَپُّکِ حٛلِّمٛ لٜيْطٜ دُونِيَارُ فُو؞ ");
INSERT INTO fuv_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ندٜنْ شٜيْطَنْ وِعِمٛ، ‏«‏مِ حٛکّٜتٜ لَامُ اٜ مَنْغُ دٛوْ لٜيْطٜ طٜعٜ فُو، نغَمْ طُمْ حٛکِّييَمْطٜ؞ مِ وَاوَيْ حٛکُّکِطٜ کٛو مٛيٜ مٛ نغِطُمِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","نغَمْ نٛنْ، تَا مَوْنِنِييَمْ، طُعُمْ فُو طُمْ وَرْتَيْ طُمْ مَاطَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","يٜىٰسُ وِعِمٛ، ‏«‏اَايَارٜ وِعِي، ‏‹‏مَوْنِنْ اَللَّه جٛومِرَاوٛ مَاطَ، کَنْکٛ تَنْ مَوْنِنْتَا؞›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","سٜيْ شٜيْطَنْ يَارِمٛ اُرُشَلِيمَ، دَرْنِمٛ تٛنْ دٛوْ حٛورٜ وُرٛ شٜنِينغٛ، وِعِمٛ، ‏«‏تٛ اَنْ وٛنِ ٻِطّٛ اَللَّه، دِوُ دَغَ طٛعٛ، ");
INSERT INTO fuv_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","نغَمْ اَايَارٜ وِعِي، ‏‹‏اَللَّه وِعَيْ مَلَاعِکَعٜنْ مُوطُمْ مبَلُّمَا بٛطُّمْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ٻٜ تَٻّٜتٜ ندٜرْ جُوطٜ مَٻّٜ، نغَمْ تٛع نَوْنَا کٛيْطٜ مَاطَ دٛوْ حَيْرٜ؞›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","يٜىٰسُ وِعِمٛ، ‏«‏اَايَارٜ وِعِ، ‏‹‏تَاع فٛوندُ اَللَّه جٛومِرَاوٛ مَاطَ؞›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","ندٜ شٜيْطَنْ حٜىٰݧِ فٛوندُکِ يٜىٰسُ فُو، سٜيْ اٛ اَلِمٛ يَاکِ وٛنْغٜلْ شَرٜلْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","سٜيْ يٜىٰسُ سٛعِّي لٜيْدِ غَلِيلِ ندٜرْ بَوْطٜ رُوحُ اَللَّه؞ حَبَرُ مَاکٛ سَنْکِتِي ندٜرْ لٜيْدِ ندِنْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","اٛ فُطِّ اٜکِّتِنْکِ ندٜرْ شُوطِ دٛعَارٜ مَٻّٜ، کٛو مٛيٜ مَنْتِمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","يٜىٰسُ يَحِ نَجَرَتْ، غَرِيرِ تٛ مَوْنِ؞ ݧَلْندٜ سِوْتَارٜ، اٛ نَتِّ سُودُ دٛعَارٜ نٛ اٛ وٛووِ وَطُکِ؞ سٜيْ اٛ اُمِّي اٛ دَرِي نغَمْ اٛ جَنْغَ دٜفْتٜرٜ شٜنِيندٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","طُمْ حٛکِّمٛ دٜفْتٜرٜ اَنَّبِ اِشَايَ، اٛ مَٻِّتِندٜ، اٛ جَنْغِ اَايَاجٜ بِعُطٜ، ");
INSERT INTO fuv_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","‏«‏رُوحُ جٛومِرَاوٛ اٜ دٛوْ اَمْ، نغَمْ اٛ سُٻِييَمْ مِ حٛکَّ ٻٜ نغَلَنَا حَبَرُ بٜلْطُمْ؞ اٛ لِلِييَمْ مِ وَدَّ حَبَرُ يٛوفُکِ مَشُّٻٜ، مِ وُمْتِنَ وُمْٻٜ، مِ وَطَ طُمْ اَلَ تٛرّٜتٜىٰٻٜ ندِلَّ، ");
INSERT INTO fuv_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","مِ وَعَجِنَنَ دُونِيَارُ وِيکِ حِتَاندٜ ندٜ جٛومِرَاوٛ حِسْنَتَ يِمْٻٜ مُوطُمْ وَرٛيِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","سٜيْ اٛ مَٻِّ دٜفْتٜرٜ ندٜنْ، اٛ حٛکِّتِندٜ بَلِّتٛووٛ اٛ جٛوطِي؞ کٛو مٛيٜ غٛنْطٛ ندٜرْ سُودُ دٛعَارٜ ندُنْ سُتِيمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","سٜيْ يٜىٰسُ وِعِٻٜ، ‏«‏طٜعٜ اَايَاجٜ طٜ نَنْطٛنْ، حَنْدٜ طٜ کٜىٰوِي؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","کٛو مٛيٜ اٜ وِعَ بٛطُّمْ دٛوْ مَاکٛ؞ بٛلِيطٜ بٛطّٜ بُرْتِيطٜ ندٜرْ حٛنْدُکٛ مَاکٛ حَيْطِنِيٻٜ؞ ٻٜ مبِعِ، ‏«‏نَاع اٛعٛ وٛنِ ٻِطّٛ يُسُفُ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","اٛ وِعِٻٜ، ‏«‏وَلَا سٜکٛ اٛنْ مبِعَيْيَمْ حَالَ کَعَ، ‏‹‏ݧَوْندٛووٛ، يَمْطِنْ حٛورٜ مَاطَ!‏ کٛ مِنْ نَنِ اَ وَطِي ندٜرْ کَفَرْنَحُمْ، وَطُ طُمْ طٛعٛ ندٜرْ غَرِيرِ مَاطَ؞›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","کَدِمَا اٛ وِعِٻٜ، ‏«‏غٛونغَ، اٜ مِ وِعَعٛنْ، وَلَا اَنَّبِيجٛ جَٻٜتٜىٰطٛ تٛ غَرِيرِ مُوطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","اٜ مِ وِعَعٛنْ غٛونغَ، اٜ شَرٜلْ اَنَّبِ اِلِيَ اٜ وٛودِ رٜوْٻٜ طُطْٻٜ ندٜرْ لٜيْدِ اِسْرَاعِيلَ ٻٜ وٛرْٻٜ مُعّٜنْ مَايِ؞ اٜ شَرٜلْ نغٜلْ، طُمْ وَطِ دُوٻِ تَتِ اٜ لٜبِّ جٛوٜىٰغٛعٛ ندِيَمْ تٛٻَايِ، ندٜنْ طُمْ وَطِ وٜىٰلٛ کَلُّنغٛ ندٜرْ لٜيْدِ ندِنْ فُو؞ ");
INSERT INTO fuv_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","اَمَّا اَنَّبِ اِلِيَ لِلٛيَاکَ تٛ کٛو مٛيٜ مَٻّٜ، سٜيْ تٛ غٛطّٛ دٜبّٛ نَاع يَحُودَنْکٜىٰجٛ مٛ غٛرْکٛ مُوطُمْ مَايِ، غٛنْطٛ غَرِيرِ جَرِفَتْ ندٜرْ لٜيْدِ سِدٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","کَدِمَا اٜ وٛودِ غٛودُٻٜ ݧَوُ ݧَامٛوجُمْ لَرَلْ طُطْٻٜ ندٜرْ اِسْرَاعِيلَ اٜ شَرٜلْ اَنَّبِ اِلِيشَ، اَمَّا وَلَا جَمْطِنَاطٛ ندٜرْ مَٻّٜ سٜيْ نَعَمَنْ نٜطّٛ لٜيْدِ سِيرِيَ، نَاع اٛ يَحُودَنْکٜىٰجٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","ندٜ يِمْٻٜ وٛنْٻٜ ندٜرْ سُودُ دٛعَارٜ ندُنْ نَنِ نٛنْ، ٻٜ فُو ٻٜرْطٜ مَٻّٜ مٜتِّ؞ ");
INSERT INTO fuv_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","ٻٜ اُمِّي، ٻٜ ندِيوِمٛ دَغَ ندٜرْ غَرِيرِ، ندٜنْ ٻٜ نجَارِمٛ دٛوْ پٛلْدٜ تٛ غَرِيرِ مَٻّٜ وٛنِ، نغَمْ ٻٜ تُورٛيٛومٛ لٜيْ، ");
INSERT INTO fuv_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","اَمَّا اٛ تٛکِّ حَکُّندٜ مَٻّٜ، اٛ دِلِّ؞ ");
INSERT INTO fuv_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","سٜيْ يٜىٰسُ يَحِ غَرِيرِ کَفَرْنَحُمْ ندٜرْ لٜيْدِ غَلِيلِ، اٜ مٛ اٜکِّتِنَٻٜ ندٜرْ سُودُ دٛعَارٜ ݧَلْندٜ سِوْتَارٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","ٻٜ کَيْطِنِ اٜ اٜکِّتِنٛلْ مَاکٛ، نغَمْ بٛلِيطٜ مَاکٛ اٜ وٛودِ بَوْطٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","اٜ وٛودِ غٛودُطٛ غِنّٛلْ ندٜرْ سُودُ دٛعَارٜ ندُنْ، اٛ وُلِّ سٜمْبٜىٰ، اٛ وِعِ، ");
INSERT INTO fuv_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","‏«‏وَيْيٛو!‏ کٛ وَنُّمَا اٜ اَمِنْ، يٜىٰسُ نَجَرَنْکٜىٰجٛ؟ اَ وَرٛيِ نغَمْ کَلْکَامِنْ؟ اٜ مِ اَنْدِ اَنْ اَ مٛيٜ؞ اَنْ وٛنِ شٜنِيطٛ اَللَّه!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","يٜىٰسُ حَٻَنِنغٛلْ وِعِ، ‏«‏دٜعُّتُ!‏ وُرْتَ ندٜرْ مَاکٛ!‏»‏ سٜيْ غِنّٛلْ نغٛلْ دٛعِّ نٜطّٛ اٛنْ يٜىٰسٛ مَٻّٜ، نغٛلْ وُرْتِي نغٛلْ نَوْنَايِمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","ٻٜ فُو ٻٜ کَيْطِنِ، ٻٜ نغَطِ کَ مٜتُکِ حَکُّندٜ مَٻّٜ، اٜ ٻٜ مبِعَ، ‏«‏اِرِ طٜيٜ بٛلِيطٜ نغٛنِ طٛعٛ؟ نغَمْ اٜ مٛ مٜتَنَ غِنِّ ندٜرْ لَامُ اٜ بَوْطٜ، اٜ طِ مبُرْتٛو؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","ندٜنْ حَبَرُ يٜىٰسُ سَنْکِتِي ندٜرْ لٜيْدِ ندِنْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","غَطَ يٜىٰسُ اَلِي سُودُ دٛعَارٜ، دِلِّي وُرٛ سِيمَنْ؞ اٜسِرَاوٛ بِيتُرُسْ دٜبّٛ جٛنْتٜ کَلُّطٜ اٜ تٛرَّمٛ، ٻٜ تٛرِي يٜىٰسُ يَمْطِتِنَمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","اٛ وَرِ تٛ ݧَوْطٛ اٛنْ، اٛ حَٻَنِ جٛنْتٜ طٜنْ، سٜيْ طٜ نجٛوفِمٛ؞ طٛنْ اٜ طٛنْ ݧَوْطٛ اٛنْ اُمِّي، فُطِّ وَدَّنْکِٻٜ ݧَمْندُ؞ ");
INSERT INTO fuv_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","ندٜ نَانغٜ حِيرِ، يِمْٻٜ نغَدَّنِ يٜىٰسُ غٛودُٻٜ ݧَوُوجِ فٜىٰرٜ‑فٜىٰرٜ، اٛ يٛوِ جُوطٜ مَاکٛ دٛوْ کٛو مٛيٜ ݧَوْطٛ، اٛ يَمْطِتِنِٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","غِنِّ مَا مبُرْتِي ندٜرْ يِمْٻٜ طُطْٻٜ، اٜ طِ نغُلَّ، اٜ طِ مبِعَ، ‏«‏اَنْ، اَ ٻِطّٛ اَللَّه!‏»‏ اَمَّا اٛ حَٻَنِطِ، اٛ حَطِطِ مٜتُکِ، نغَمْ اٜ طِ اَنْدِ کَنْکٛ وٛنِ اَلْمَسِيحُ؞ ");
INSERT INTO fuv_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","ندٜ وٜىٰتِ، يٜىٰسُ وُرْتِي غَرِيرِ ندِنْ يَحِ وٛنْدٜ وِغٜىٰرٜ ندٜرْ لَدّٜ؞ يِمْٻٜ نغَطِ کَ طَٻُّتُکِمٛ؞ ندٜ ٻٜ تَوِمٛ، ٻٜ نغِطَا اٛ دِلَّ اٛ اَلَٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","اَمَّا اٛ وِعِٻٜ، ‏«‏دٛولٜ مِ وَعَجِنَ حَبَرُ بٜلْطُمْ دٛوْ لَامُ اَللَّه اٜ غٛطّٜ غَرِيجٜ، نغَمْ مَاجُمْ طُمْ لِلٛيِيَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","ندٜنْ اٛ وَطِ کَ وَعَجِنْکِ ندٜرْ شُوطِ دٛعَارٜ لٜيْدِ يَحُودِيَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","وٛنْدٜ ݧَلْندٜ يٜىٰسُ اٜ دَرِي دَاندٜ مبٜىٰلَ جَنِسَرَتْ، يِمْٻٜ اٜ ڤِلِيمٛ اٜ نَنَ وٛلْدٜ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","اٛ يِعِ کٛمِيجٜ طِطِ اٜ طٜ ندٜسِي دَاندٜ ندِيَمْ؞ نَنْغٛوٻٜ لِپِّ مبُرْتِي ندٜرْ مَاجٜ، اٜ ٻٜ لَٻِّنَ نَنْغِرْطُمْ لِپِّ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","اٛ نَتِّ کٛمِوَلْ سِيمَنْ، اٛ تٛرِي سِيمَنْ دِرْدِنَنغَلْ سٜطَّ ندٜرْ ندِيَمْ؞ اٛ جٛوطِي ندٜرْ مَاغَلْ، اٜ مٛ اٜکِّتِنَ يِمْٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","ندٜ اٛ حٜىٰݧِ کٛ اٛ وِعَتَ، اٛ وِعِ سِيمَنْ، ‏«‏تُرْتَ کٛمِوَلْ نغَلْ يَاکِ تٛنْ تٛ لُغِّ، نغَطَا نَنْغِرْطُمْ لِپِّ مَاطَ ندٜرْ ندِيَمْ نغَمْ نَنْغُکِ لِپِّ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","سِيمَنْ بِيتُرُسْ وِعِ، ‏«‏مٛودِبّٛ، مِنْ کُوِي جٜمَّارٜ فُو، مِنْ نَنْغَايِ غٛطُّمْ؞ اَمَّا دَغَ اَ وِعِ نٛنْ، مِ وَطَيْ نَنْغِرْطُمْ لِپِّ ندٜرْ ندِيَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","ندٜ ٻٜ نغَطِ نٛنْ، ٻٜ نَنْغِ لِپِّ طُطِّ حَا نَنْغِرْطُمْ طُمْ فُطِّ سٜىٰکُکِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","سٜيْ ٻٜ نٛدِّرِ حِغٛوٻٜ مَٻّٜ جُوطٜ، وٛنْٻٜ ندٜرْ وٛنْغَلْ کٛمِوَلْ، نغَمْ ٻٜ نغَرَ ٻٜ مبَلَّٻٜ؞ ٻٜ نغَرِ، ٻٜ کٜبِّنِ کٛمِيجٜ طٜنْ طٜ فُو طِطِ اٜ لِپِّ نَاکِ طٜ فُطِّ مُتُکِ ندٜرْ ندِيَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","ندٜ سِيمَنْ يِعِ نٛنْ، اٛ دِشِّي يٜىٰسٛ يٜىٰسُ، اٛ وِعِ، ‏«‏مٛودِبّٛ، وٛطِّتَيَمْ، مِ نٜطّٛ غٛودُطٛ حَکّٜ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","سِيمَنْ وِعِ نٛنْ نغَمْ کَنْکٛ اٜ غٛنْدُٻٜ اٜ مَاکٛ ٻٜ کَيْطِنِي اٜ لِپِّ طُطِّ طِ ٻٜ نَنْغِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","يَاکُبُ اٜ يَحَيَ، ٻِٻّٜ جَبَدِ، حِغٛوٻٜ کُوغَلْ سِيمَنْ، کَمْٻٜ مَا ٻٜ کَيْطِنِي؞ يٜىٰسُ وِعِ سِيمَنْ، ‏«‏تَاع حُلُ!‏ دَغَ جٛونِ اَ وَدَّيْ يِمْٻٜ تٛ اَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","ٻٜ مبُرْتِنِ کٛمِيجٜ مَٻّٜ دَغَ ندٜرْ ندِيَمْ، ٻٜ اَلِ کٛو طُمٜ، ٻٜ تٛکِّ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","وٛنْدٜ ݧَلْندٜ يٜىٰسُ اٜ ندٜرْ وٛنْدِ غَرِيرِ، غٛطّٛ وَرٛيِ غٛودُطٛ ݧَوُ ݧَامٛوجُمْ لَرَلْ فُو ٻَنْدُ مَاکٛ؞ ندٜ اٛ يِعِ يٜىٰسُ، اٛ دِشِّي، اٛ تٛرِي يٜىٰسُ، اٛ وِعِ، ‏«‏مٛودِبّٛ، تَا جَٻِي، اَ وَاوَيْ نجَمْطِتِنَايَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","سٜيْ يٜىٰسُ فٛرْتِ جُنْغٛ مُوطُمْ، مٜىٰمِمٛ، وِعِ، ‏«‏مِ جَٻِي؞ يَمْطُتُ!‏»‏ طٛنْ اٜ طٛنْ اٛ يَمْطِتِ، ݧَوُ نغُنْ اَلِمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","يٜىٰسُ وِعِمٛ، ‏«‏تَاع وِعُکَ غٛطّٛ؞ اَمَّا يَحُ، کٛلَّا حٛورٜ مَاطَ تٛ اَرْدِيطٛ دِينَ، کٛکَّا شَکِّرِ نٛ اَنَّبِ مُوسَ وِعِ نغَمْ لَاٻٛلْ مَاطَ؞ وَطُ نٛنْ نغَمْ تَبِّتِنَنْکِ يِمْٻٜ اَ يَمْطِتِي؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","اَمَّا کٛو ندٜ يٜىٰسُ حَطِيمٛ وِعُکِکَ، حَبَرُ طُمْ وٛطِّنِي، يِمْٻٜ طُطْٻٜ نغَرِ نغَمْ نَنُکِ اٜکِّتِنٛلْ مَاکٛ اٜ يَمْطِتِنٜىٰکِ دَغَ ݧَوُوجِ مُعّٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","اَمَّا نٛ يٜىٰسُ وٛووِ اٜ يَحَ وِغٜىٰرٜ ندٜرْ لَدّٜ وَطَ دٛعَارٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","وٛنْدٜ ݧَلْندٜ يٜىٰسُ اٜ ندٜرْ اٜکِّتِنْکِ، فَارِسَنْکٛعٜنْ اٜ مٛودِٻّٜ اَتَّوْرَ اٜ نجٛوطِي طٛنْ پِوٛيْٻٜ نغَرِحٛيْ فُو نغٛنْکٛيْ ندٜرْ لٜيْطٜ غَلِيلِ اٜ يَحُودِيَ اٜ غَرِيرِ اُرُشَلِيمَ؞ بَوْطٜ جٛومِرَاوٛ اٜ وٛنْدِ اٜ مَاکٛ، اٜ مٛ يَمْطِتِنَ ݧَوْٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","سٜيْ وٛٻّٜ نغَدِّ غٛطّٛ جَرَاطٛ دٛوْ دَاغٛ، ٻٜ طَٻِّتِ طَتَلْ نغَلْ ٻٜ نَتِّنِرْتَمٛ ندٜرْ وُرٛ نغٛنْ، ٻٜ ڤُکِّنَمٛ يٜىٰسٛ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","اَمَّا ٻٜ مبَاوَايِ نَتِّنْکِمٛ نغَمْ يِمْٻٜ طُوطِي، سٜيْ ٻٜ پٜنْتِنِمٛ دٛوْ سُودُ ندُنْ، ٻٜ نجُلِندُ، ٻٜ نجِڤِّنِمٛ دَغَ دٛوْ مَيْرُ يَاکِ حَکُّندٜ يِمْٻٜ يٜىٰسٛ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","ندٜ يٜىٰسُ يِعِ حٛولَارٜ مَٻّٜ، اٛ وِعِ جَرَاطٛ اٛنْ، ‏«‏حِغٛ، طُمْ يَافَنَکٜمَ حَکّٜىٰجِ مَاطَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","سٜيْ فَارِسَنْکٛعٜنْ اٜ مٛودِٻّٜ اَتَّوْرَ ڤُطِّ مٜتِتَاکِ حَکُّندٜ مَٻّٜ، اٜ ٻٜ مبِعَ، ‏«‏اٛعٛ طُمْ مٛيٜ ڤٛتِّدِنٛووٛ حٛورٜ مُوطُمْ اٜ اَللَّه؟ مٛيٜ وَاوَتَ يَافَاکِ حَکّٜ تٛ نَاع اَللَّه؟»‏ ");
INSERT INTO fuv_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","يٜىٰسُ فَامِ ݧُمٛ مَٻّٜ، اٛ وِعِٻٜ، ‏«‏نغَمْ طُمٜ ݧُمٛتٛنْ اِرِ ݧُمٛوجِ طِعِ ندٜرْ ٻٜرْطٜ مٛوطٛنْ؟ ");
INSERT INTO fuv_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","کٛ ٻُرِ حٛيْکِ، طُمْ وِعَ، ‏‹‏اَ يَافَنَامَ حَکّٜ مَاطَ،›‏ کٛو طُمْ وِعَ، ‏‹‏اُمَّ يَاٻُ؟›‏ ");
INSERT INTO fuv_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","اَمَّا اٜ مِ يِطِ اَنْدٛنْ ٻِي نٜطّٛ اٜ وٛودِ لَامُ ندٜرْ دُونِيَارُ يَافٛو حَکّٜ؞»‏ سٜيْ اٛ وِعِ جَرَاطٛ اٛنْ، ‏«‏اٜ مِ وِعِمَا، اُمَّ، کٛشَّا دَاغٛ مَاطَ، کٛوتَا وُرٛ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","طٛنْ اٜ طٛنْ اٛ اُمِّي يٜىٰسٛ مَٻّٜ، اٛ حٛشِّ دَاغٛ مَاکٛ، اٛ حٛوتِ وُرٛ، اٜ مٛ مَنْتَ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","ٻٜ فُو ٻٜ کَيْطِنِ، ٻٜ مَوْنِنِ اَللَّه؞ کُلٛلْ نَنْغِٻٜ، ٻٜ مبِعِ، ‏«‏حَنْدٜ اٜنْ نغِعِ کٛ حُلْنِي!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","غَطَ طٛنْ، يٜىٰسُ وُرْتِي يِعِ جَٻٛووٛ شٜىٰدٜ لٜيْدِ بِعٜتٜىٰطٛ لٜىٰوِ، اٜ مٛ جٛوطِي تٛ طُمْ جَٻَتَ شٜىٰدٜ لٜيْدِ، يٜىٰسُ وِعِمٛ، ‏«‏تٛکَّمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","لٜىٰوِ اُمِّي، اَلِ کٛو طُمٜ، تٛکِّمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","سٜيْ لٜىٰوِ يَارِ يٜىٰسُ وُرٛ مُوطُمْ دٜفَنِمٛ ݧَمْندُوجِ فٜىٰرٜ‑فٜىٰرٜ؞ جَٻٛوٻٜ شٜىٰدٜ لٜيْدِ طُطْٻٜ اٜ وٛٻّٜ يِمْٻٜ اٜ ݧَمْدَ اٜ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","اَمَّا، فَارِسَنْکٛعٜنْ اٜ مٛودِٻّٜ اَتَّوْرَ مَٻّٜ نغَطِ کَ مٜتِتَاکِ، اٜ ٻٜ مبِعَ تٛکُّٻٜ يٜىٰسُ، ‏«‏نغَمْ طُمٜ ݧَمْدٛتٛنْ اٜ جَٻٛوٻٜ شٜىٰدٜ لٜيْدِ اٜ غَطٛوٻٜ حَکّٜ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","يٜىٰسُ وِعِٻٜ، ‏«‏نَاع يَمْٻٜ نغِطِ ݧَوْندٛووٛ، سٜيْ نِ ݧَوْٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","مِ وَرٛيَايِ نغَمْ نٛدُّکِ ݧُمٛوٻٜ ٻٜ اَادِلِعٜنْ، اَمَّا مِ وَرٛيِ نغَمْ نٛدُّکِ اَنْدُٻٜ ٻٜ غَطٛوٻٜ حَکّٜ ٻٜ تُوبَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","ٻٜ مبِعِمٛ، ‏«‏کٛو ندٜيٜ تٛکُّٻٜ يَحَيَ غَطٛووٛ بَڤْتِسْمَ اٜ شُومٛو اٜ نغَطَ دٛعَارٜ، نٛنْ مَا تٛکُّٻٜ فَارِسَنْکٛعٜنْ نغَطَتَ، اَمَّا تٛکُّٻٜمَ اٜ ݧَامَ اٜ نجَرَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","يٜىٰسُ نٛوتِي وِعِٻٜ، ‏«‏اٛنْ مبَاوَيْ کَطٛنْ حِغٛوٻٜ اَنْغٛوجٛ ݧَامُکِ ݧَمْندُ شَرٜلْ نغٜلْ اٛ وٛنْدِ اٜ مَٻّٜ؟ اٛنْ مبَاوَتَا!‏ ");
INSERT INTO fuv_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","اَمَّا شَرٜلْ اٜ وَرَ نغٜلْ طُمْ حٛشَّتَ اَنْغٛوجٛ اٛنْ دَغَ ندٜرْ مَٻّٜ، غَطَ طٛنْ ٻٜ شُومٛتٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","اٛ وِعِٻٜ مِسَالُ طُعُمْ، ‏«‏وَلَا شٜىٰکٛووٛ لٜفٜلْ دَغَ لِمْشٜرٜ حٜيْرٜ ݧٛوتَنغٜلْ تٛ لِمْشٜرٜ کِيندٜ؞ تٛ اٛ وَطِي نٛنْ، اٛ سٜىٰکَيْ لِمْشٜرٜ حٜيْرٜ ندٜنْ، لٜفٜلْ کٜسٜلْ نغٜلْ بٛو يَادَتَا اٜ لِمْشٜرٜ حِيندٜ ندٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","نٛنْ مَا وَلَا غَطَيْطٛ اِنَبٛجَمْ کٜسَمْ ندٜرْ فَاندُ حِيندُ؞ تٛ اٛ وَطِي نٛنْ، طَمْ پُوفَيْ، طَمْ ڤُسَ فَاندُ ندُنْ، طَمْ رُفَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","اَمَّا، اِنَبٛجَمْ کٜسَمْ حَانِ وَطٜىٰ ندٜرْ فَاندُ حٜيْرُ؞ ");
INSERT INTO fuv_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","وَلَا بٛو جَرٛووٛ اِنَبٛجَمْ کِيطَمْ غَطَ طٛنْ طَٻِّتَ کٜسَمْ، نغَمْ اٛ وِعَيْ، ‏‹‏کِيطَمْ طَمْ ٻُرِي؞›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","وٛنْدٜ ݧَلْندٜ سِوْتَارٜ يٜىٰسُ اٜ يَحَ ندٜرْ نغٜسَ اَلْکَمَارِ، سٜيْ تٛکُّٻٜمٛ نغَطِ کَ ٻٛرُکِ شَمّٜىٰجٜ مَيْرِ اٜ مٛلْمَطٜ ندٜرْ جُوطٜ مَٻّٜ، اٜ ٻٜ ݧَامَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","اَمَّا وٛٻّٜ فَارِسَنْکٛعٜنْ مبِعِٻٜ، ‏«‏کٛ وَطِ نغَطٛتٛنْ کٛ اَتَّوْرَ حَطِ طُمْ وَطَ ݧَلْندٜ سِوْتَارٜ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","يٜىٰسُ وِعِٻٜ، ‏«‏اٛنْ مٜىٰطَايِ جَنْغُکِ کٛ دَوْدَ وَطِ ندٜ نَنِ وٜىٰلٛ، کَنْکٛ اٜ غٛنْدُٻٜ اٜ مَاکٛ؟ ");
INSERT INTO fuv_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","اٛ نَتِّ لُکُرُ سٜنِيطُمْ، اٛ حٛشِّ بُرٛودِ شٜنِيطُمْ، اٛ ݧَامِطُمْ؞ اَتَّوْرَ بٛو وِعِي اَرْدِيٻٜ دِينَ تَنْ حَانِ ݧَامُکِ بُرٛودِ طُمْ، اَمَّا دَوْدَ ݧَامِطُمْ حَا مَا اٛ حٛکّٛرِ جَادٛوٻٜ اٜ مَاکٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","سٜيْ يٜىٰسُ وِعِٻٜ، ‏«‏ٻِي نٜطّٛ وٛنِ جٛومُ ݧَلْندٜ سِوْتَارٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","وٛنْدٜ ݧَلْندٜ سِوْتَارٜ اٛ نَتِّ ندٜرْ سُودُ دٛعَارٜ، اٜ مٛ اٜکِّتِنَ؞ غٛطّٛ مٛ جُنْغٛ جَرَانغٛ اٜ ندٜرْ مَيْرُ؞ ");
INSERT INTO fuv_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","مٛودِٻّٜ اَتَّوْرَ اٜ فَارِسَنْکٛعٜنْ شُتِي يٜىٰسُ کٛو اٛ يَمْطِتِنَيْ غٛطّٛ ندٜرْ ݧَلْندٜ سِوْتَارٜ، نغَمْ ٻٜ کٜٻَ کٛ ٻٜ نغُلِّرٛيْتٛومٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","اَمَّا، يٜىٰسُ اٜ اَنْدِ کٛ وٛنِ ندٜرْ ٻٜرْطٜ مَٻّٜ، سٜيْ اٛ وِعِ نٜطّٛ مٛ جُنْغٛ جَرَانغٛ اٛنْ، ‏«‏وٛرٛيْ، ندَرٛطَا شَکَ مَٻّٜ؞»‏ اٛ اُمِّي، اٛ دَرِي طٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","سٜيْ يٜىٰسُ وِعِٻٜ، ‏«‏اٜ مِ پَمَعٛنْ، کٛ اَتَّوْرَ وِعِ طُمْ وَطَ ندٜرْ ݧَلْندٜ سِوْتَارٜ، وَطَ کٛ وٛوطِ کٛو وَطَ کٛ وٛوطَا، حِسْنَ يٛنْکِ کٛو حَلْکَکِ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","غَطَ اٛ رَارِيٻٜ ٻٜ فُو، سٜيْ اٛ وِعِ نٜطّٛ اٛنْ، ‏«‏فٛرْتُ جُنْغٛ مَاطَ؞»‏ اٛ فٛرْتِنغٛ، سٜيْ نغٛ يَمْطِتِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","اَمَّا ٻٜرْطٜ مَٻّٜ مٜتِّ نَاع سٜطَّ، ٻٜ مٜتِ حَکُّندٜ مَٻّٜ دٛوْ کٛ ٻٜ نغَطَنْتَ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","ندٜرْ بَلْطٜ طٜنْ، يٜىٰسُ يَحِ دٛوْ حٛشّٜىٰرٜ نغَمْ وَطَ دٛعَارٜ؞ اٛ وَالِ وَطُکِ دٛعَارٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","ندٜ وٜىٰتِ، اٛ نٛدِّ تٛکُّٻٜمٛ، اٛ سُٻِ سَڤّٛ اٜ طِطٛ، اٛ حٛکِّٻٜ اِنْدٜ لِلَاٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","کَمْٻٜ نغٛنِ:‏ سِيمَنْ مٛ اٛ حٛکِّ اِنْدٜ بِيتُرُسْ، اٜ مِݧِرَاوٛ مَاکٛ اَنْدِرَاوُسْ، اٜ يَاکُبُ، اٜ يَحَيَ، اٜ فِلِبُسْ، اٜ بَتِلٛومِ، ");
INSERT INTO fuv_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","اٜ مَاتِيُ، اٜ تٛومَ، اٜ يَاکُبُ ٻِي حَلْفَ، اٜ سِيمَنْ بِعٜتٜىٰطٛ جَلٛوتِ، ");
INSERT INTO fuv_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","اٜ يَحُودَ ٻِي يَاکُبُ، اٜ يَحُودَ اِسْکَرِيٛوتِ، غَرْتُطٛ کٛکِّتِرْطٛ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","سٜيْ يٜىٰسُ جِڤّٛدِي اٜ مَٻّٜ اٛ دَرِي اٜ نجَيْرِ؞ تٛکُّٻٜمٛ طُطْٻٜ اٜ طٛنْ اٜ يِمْٻٜ طُطْٻٜ پِوٛيْٻٜ دَغَ لٜيْدِ يَحُودِيَ فُو، اٜ اُرُشَلِيمَ، اٜ لٜيْدِ تَايَ اٜ سِدٛنْ حَادٜ مبٜىٰلَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","ٻٜ نغَرٛيِ نغَمْ نَنُکِمٛ اٜ يَمْطِنٜىٰکِ دَغَ ݧَوُوجِ مَٻّٜ؞ ٻٜ غِنِّ تٛرَّتَ نجَمْطِنَا؞ ");
INSERT INTO fuv_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","وٛنْٻٜ طٛنْ فُو اٜ ٻَدّٛو نغَمْ مٜىٰمَ يٜىٰسُ، نغَمْ بَوْطٜ اٜ مبُرْتٛو دَغَ ندٜرْ مَاکٛ، اٜ مٛ يَمْطِتِنَ کٛو مٛيٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","يٜىٰسُ رَارِ تٛکُّٻٜمٛ، وِعِ، ‏«‏اٛنْ بَرْکِطِنَاٻٜ، اٛنٛنْ ٻٜ نغَلَنَا، نغَمْ اٛنٛنْ نجٜيِ لَامُ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","‏«‏اٛنْ بَرْکِطِنَاٻٜ، اٛنٛنْ نَنٛوٻٜ وٜىٰلٛ جٛونِ، نغَمْ اٛنْ نغَرْتَيْ کَرْنٜتٜىٰٻٜ؞ ‏«‏اٛنْ بَرْکِطِنَاٻٜ، اٛنٛنْ وٛيٛوٻٜ جٛونِ، نغَمْ اٛنْ نغَرْتَيْ جَلَيْٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","‏«‏اٛنْ بَرْکِطِنَاٻٜ تٛ يِمْٻٜ نغَݧِيعٛنْ، ندِيوِيعٛنْ، کُطِيعٛنْ، مبٛنِّي اِنْطٜ مٛوطٛنْ نغَمْ ٻِي نٜطّٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","نَنٜىٰ بٜلْطُمْ ندٜرْ ݧَلْندٜ ندٜنْ، نغَمٜىٰ نغَمْ بٜلْطُمْ، نغَمْ بَرْکَ مٛوطٛنْ طُمْ طُطُّمْ اٜ دٛوْ؞ نٛنْ مَامَعٜنْ مَٻّٜ نغَطَنّٛو اَنَّبٛعٜنْ اَرَنْدٜعٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","‏«‏اٛنْ مبٛنِي، اٛنٛنْ رِسْکُٻٜ، نغَمْ اٛنْ کٜٻِي کٛ طَٻِّتٛتٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","‏«‏اٛنْ مبٛنِي، اٛنٛنْ کَرْٻٜ جٛونِ، نغَمْ اٛنْ نَنَيْ وٜىٰلٛ؞ ‏«‏اٛنْ مبٛنِي، اٛنٛنْ جَلَيْٻٜ جٛونِ، نغَمْ اٛنْ نَنَتَا بٜلْطُمْ، اٛنْ مبٛيَيْ بٛجِّ نَوْطِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","‏«‏اٛنْ مبٛنِي تٛ يِمْٻٜ فُو مَنِيعٛنْ، نغَمْ نٛنْ مَامَعٜنْ مَٻّٜ نغَطَنّٛو اَنَّبٛعٜنْ فٜوْرٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","‏«‏اَمَّا اٜ مِ وِعَعٛنْ اٛنٛنْ نَنٛوٻٜ کٛ مبِعَيْمِ:‏ نغِطٜىٰ غَݧٛوٻٜ مٛوطٛنْ، نغَطَنٜىٰ وَݧُٻٜعٛنْ کٛ وٛوطِ، ");
INSERT INTO fuv_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","مبَرْکِطِنٜىٰ لَانٛوٻٜعٛنْ، نغَطَنٜىٰ تٛرّٛوٻٜعٛنْ دٛعَارٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","تٛ غٛطّٛ فِيِيمَ تٛ وٛلٛ، وَيْلِتَنْمٛ وٛعٛتٛ نغٛنْ مَا؞ تٛ غٛطّٛ جَٻِي شُدَّارِ مَاطَ، تَاع حَطُمٛ تٛغّٛورٜ مَاطَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","تٛرِيطٛمَ غٛطُّمْ فُو، حٛکُّمٛ؞ تٜىٰتَنْطٛمَ غٛطُّمْ، تَاع وِعِمٛ اٛ حٛکُّتُمَا؞ ");
INSERT INTO fuv_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","نغَطَنٜىٰ وٛٻّٜ کٛ نغِطّٛنْ ٻٜ نغَطَنَعٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","‏«‏تٛ يِطُٻٜعٛنْ تَنْ نغِطّٛنْ، طُمٜ بَرْکَ کٜٻٛتٛنْ؟ کٛو کَلُّٻٜ مَا اٜ نغِطِ يِطُٻٜٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","تٛ غَطَنٛوٻٜعٛنْ بٛطُّمْ تَنْ نغَطَنْتٛنْ بٛطُّمْ، طُمٜ بَرْکَ کٜٻٛتٛنْ؟ اَيْ، کَلُّٻٜ مَا اٜ نغَطَ نٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","تٛ ٻٜ کَمِّيطٛنْ نجٛٻَيْعٛنْ تَنْ کٛکّٛتٛنْ ݧَمَاندٜ، طُمٜ بَرْکَ کٜٻٛتٛنْ؟ اَيْ، کَلُّٻٜ مَا اٜ کٛکَّ کَلُّٻٜ ݧَمَاندٜ، اٜ ٻٜ کَمّٛو حٛکِّتٜىٰکِ ݧَمَاندٜ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","اَمَّا نغِطٜىٰ غَݧٛوٻٜ مٛوطٛنْ، نغَطَنٜىٰٻٜ بٛطُّمْ، کٛکّٜىٰٻٜ ݧَمَاندٜ، تٛع اٛنْ کَمّٛو حٛکِّتٜىٰکِ؞ تٛ اٛنْ نغَطِي نٛنْ، اٛنْ کٜٻَيْ بَرْکَ طُطُّمْ، اٛنْ نغَرْتَيْ ٻِٻّٜ اَللَّه جٛومُ مَنْغُ؞ نغَمْ اَللَّه اٜ يُرْمِنَنَ ٻٜ نغٜتَّتَا اٜ کَلُّٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","نجُرْمِنَنٜىٰ يِمْٻٜ نٛنْ نٛ ݧَاکٛ مٛوطٛنْ مٛ دٛوْ يُرْمِرْتَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","‏«‏تٛع اٛنْ کِيتٛ وٛٻّٜ، اٛنْ کِيتَتَاکٜ؞ تٛع اٛنْ مٜتُ کَلُّکَ دٛوْ غٛطّٛ، طُمْ مٜتَتَا کَلُّکَ دٛوْ مٛوطٛنْ؞ نجَافٜىٰ، طُمْ يَافَنْتٛعٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","کٛکّٜىٰ، طُمْ حٛکَّيْعٛنْ اٜ ڤٛوندِرْغٜلْ کٜوْنغٜلْ تِطَّانغٜلْ دِمْبَانغٜلْ بٛطُّمْ، طُمْ وَيْلَنَيْعٛنْ ندٜرْ تُمُّطٜ مٛوطٛنْ، نغَمْ ڤٛوندِرْغٜلْ نغٜلْ ڤٛوندِرْطٛنْ، اٜ مَاغٜلْ طُمْ فٛوندِرَنْتَعٛنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","طٛنْمَا اٛ حٛکِّٻٜ مِسَالُ طُعُمْ، اٛ وِعِ، ‏«‏اٛنْ نغِعَ بُمْطٛ وَاوَيْ اَرْدَاکِ بُمْطٛ؟ ٻٜ فُو طِطٛ نَاع سٜيْ ٻٜ نجَنَ ندٜرْ نغَيْکَ؟ ");
INSERT INTO fuv_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","اٜکِّتٛتٛوطٛ ٻُرَتَا مٛودِبّٛ مُوطُمْ، اَمَّا کٛو مٛيٜ اٜکِّتِنَاطٛ بٛطُّمْ وَرْتَيْ بٛ مٛودِبّٛ مُوطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","‏«‏نغَمْ طُمٜ ندَارَتَا غٜىٰنٜلْ غٛنْغٜلْ ندٜرْ حِتٜرٜ بَنْدِرَاوٛ مَاطَ، اَمَّا اَ وَنَّايِ اٜ لٜغَّ وٛنْغَ ندٜرْ حِتٜرٜ مَاطَ؟ ");
INSERT INTO fuv_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","نٛ وَطَتَ مبِعَا بَنْدِرَاوٛ مَاطَ، ‏‹‏بَنْدِرَاوٛ، اَلْ مِ اِتَّنْمَا غٜىٰنٜلْ ندٜرْ حِتٜرٜ مَاطَ،›‏ ندٜنْ اَنْ اٜ حٛورٜ مَاطَ اَ يِعَايِ لٜغَّ وٛنْغَ ندٜرْ حِتٜرٜ مَاطَ؟ اَنْ مُنَافُکِيجٛ، اَرْتُ اِتُّکِ لٜغَّ وٛنْغَ ندٜرْ حِتٜرٜ مَاطَ، ندٜنْ نغِعَا بٛطُّمْ کٜٻَا نٛ اِتِّرَا غٜىٰنٜلْ غٛنْغٜلْ ندٜرْ حِتٜرٜ بَنْدِرَاوٛ مَاطَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","‏«‏لٜکِّ بٛطْکِ رِمَتَا ٻِکّٛيْ کٛيْ مبٛوطَا، نٛنْ مَا لٜکِّ کِ وٛوطَا رِمَتَا ٻِکّٛيْ مبٛطْکٛيْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","نغَمْ کٛو کِيٜ لٜکِّ اٜ اَنْدِرٜىٰ ٻِکّٛيْ مَاکِ؞ طُمْ تٜٻِّتَتَا اِبّٜ تٛ لٜکِّ کٛورَاجٜ، نٛنْ تٛ غِعٜحِ طُمْ تٜٻِّتَتَا ٻِکّٛيْ بُمّٜىٰجٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","نٜطّٛ مٛ نغِکُّ بٛطُّمْ اٜ وُرْتِنَ فِي بٛطُّمْ دَغَ ندٜرْ کٛ وٛنِ ندٜرْ ٻٜرْندٜ مُوطُمْ؞ نٛنْ مَا نٜطّٛ کَلُّطٛ اٜ وُرْتِنَ حَلّٜىٰندٜ دَغَ ندٜرْ ٻٜرْندٜ مُوطُمْ، نغَمْ حٛنْدُکٛ نٜطّٛ اٜ مٜتَ کٛ وٛنِ ندٜرْ ٻٜرْندٜ مُوطُمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","اٛ وِعِٻٜ، ‏«‏نغَمْ طُمٜ نٛدِّرْتٛيْيَمْ، ‏‹‏مٛودِبّٛ، مٛودِبّٛ،›‏ اَمَّا اٛنْ نغَطَتَا کٛ مبِيمِعٛنْ؟ ");
INSERT INTO fuv_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","نٜطّٛ فُو غَرْطٛ تٛ اَمْ نَنِ بٛلِيطٜ اَمْ وَطِ کٛ مبِيمِ، مِ حٛلَّيْعٛنْ کٛ اٛ نَنْدِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","اٜ مٛ نَنْدِ اٜ نٜطّٛ مَحٛووٛ وُرٛ غَسُطٛ لٜيْدِ لُغُّطُمْ حَا اٛ حٜوْتِ تَفَارٜ، اٛ مَحِ وُرٛ دٛوْ مَيْرٜ؞ شَانغٛلْ حٜىٰوِ فَلْپِ فِيِ وُرٛ نغٛنْ، اَمَّا نغٛ دِمْبَاکِ، نغَمْ نغٛ مَحَامَ دٛوْ تَفَارٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","اَمَّا نَنْطٛ بٛلِيطٜ اَمْ، ندٜنْ وَطَايِ کٛ مبِيمِ اٜ نَنْدِ اٜ نٜطّٛ مَحُطٛ وُرٛ دٛوْ نجَارٜىٰندِ؞ ندٜ شَانغٛلْ فَلْپِ فِيِنغٛ، طٛنْ اٜ طٛنْ نغٛ يَنِ نغٛ فُو!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","ندٜ يٜىٰسُ يٛتِّنِ فُو کٛ وِعَتَ يِمْٻٜ، اٛ دِلِّ اٛ نَتِّ غَرِيرِ کَفَرْنَحُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","تٛنْ اٜ وٛودِ غٛطّٛ مَوْطٛ سٛوجِعٜنْ اٜ مٛ وٛودِ مَشُّطٛ مٛ اٛ يِطِ نَاع سٜطَّ؞ مَشُّطٛ اٛنْ يَمْطَا، اٛ ٻَدَکٜ مَيْدٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","ندٜ مَوْطٛ سٛوجِعٜنْ اٛنْ نَنِ حَبَرُ يٜىٰسُ، اٛ لِلِ وٛٻّٜ مَوْٻٜ يَحُودَنْکٛعٜنْ تٛ مَاکٛ نغَمْ ٻٜ تٛرٛومٛ اٛ وَرَ اٛ يَمْطِتِنَ مَشُّطٛ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","ندٜ ٻٜ نغَرِ تٛ يٜىٰسُ، ٻٜ تٛرِيمٛ کٛ طُوطِ، ٻٜ مبِعِ، ‏«‏اٜ حَانِ مبَلَّا نٜطّٛ اٛعٛ، ");
INSERT INTO fuv_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","نغَمْ اٜ مٛ يِطِ لٜݧٛلْ مٜىٰطٜنْ، کَنْکٛ مَحِ سُودُ دٛعَارٜ مٜىٰطٜنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","سٜيْ يٜىٰسُ يَادِ اٜ مَٻّٜ؞ ندٜ اٛ ٻَدِي وُرٛ نغٛنْ، مَوْطٛ سٛوجِعٜنْ اٛنْ لِلٛيِ حِغٛوٻٜ مُوطُمْ مبِعَمٛ، ‏«‏مٛودِبّٛ، تَاع تٛرُّ حٛورٜ مَاطَ نغَمْ مِ فٛتَايِ نَتَّا وُرٛ اَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","کَنْجُمْ وَطِ ندَارُمِ حٛورٜ اَمْ مِ فٛتَايِ وَرْکِ تٛ مَاطَ، اَمَّا مٜتُ تَنْ، مَشُّطٛ اَمْ يَمْطِتَيْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","نغَمْ مِنْ اٜ حٛورٜ اَمْ لٜيْ لَامُ وٛٻّٜ سٛوجِعٜنْ نغٛنْمِ، مِنْ مَا، اٜ مِ لَامٛو سٛوجِعٜنْ؞ تٛ مِ وِعِي اٛعٛ، ‏‹‏دِلُّ!‏›‏ اٛ دِلَّيْ؞ تٛ مِ وِعِي اٛنْ تٛنْ، ‏‹‏وٛرٛيْ!‏›‏ اٛ وَرَيْ؞ تٛ مِ وِعِي مَشُّطٛ اَمْ، ‏‹‏وَطُ طُعُمْ!‏›‏ اٛ وَطَيْطُمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","ندٜ يٜىٰسُ نَنِ نٛنْ، طُمْ حَيْطِنِيمٛ، اٛ يٜىٰپِي يِمْٻٜ طُطْٻٜ تٛکُّٻٜمٛ، اٛ وِعِ، ‏«‏اٜ مِ وِعَعٛنْ، کٛو ندٜرْ اِسْرَاعِيلَ مِ حٜٻَايِ کٛولِيطٛيَمْ ٻٜرْندٜ غٛعٛ بٛ اٛعٛ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","سٜيْ لِلَاٻٜ ٻٜنْ شٛعِّي وُرٛ نغٛنْ، ٻٜ تَوِ مَشُّطٛ اٛنْ يَمْطِتِي؞ ");
INSERT INTO fuv_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","غَطَ مَاجُمْ سٜطَّ، يٜىٰسُ يَحِ وٛنْدِ غَرِيرِ بِعٜتٜىٰندِ نَايِنْ، کَنْکٛ اٜ تٛکُّٻٜمٛ سَڤّٛ اٜ طِطٛ اٜ يِمْٻٜ طُطْٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","ندٜ اٛ ٻَدِي دَمُّغَلْ غَرِيرِ ندِنْ، اٛ حَوْرِ اٜ وٛٻّٜ اٜ کٛشّٛيِ مَيْطٛ ٻٜ اُوٛيَيْمٛ، کَنْکٛ تَنْ مَدُوجٛ مَاکٛ وٛودِ؞ دٜبّٛ اٛنْ بٛو غٛرْکٛ مُوطُمْ مَايِ، يِمْٻٜ غَرِيرِ ندِنْ طُطْٻٜ اٜ تٛکِّمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","ندٜ يٜىٰسُ يِعِمٛ، يُرْمِنَنِ دٜبّٛ اٛنْ، وِعِ، ‏«‏اَلُ بٛجِّ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","اٛ ٻَدِّي، اٛ مٜىٰمِ کٛشِّرْطُمْ مَيْطٛ اٛنْ؞ سٜيْ کٛشُّٻٜمٛ ٻٜنْ ندَرِي؞ اٛ وِعِ، ‏«‏سُکَ، اٜ مِ وِعُمَا، اُمَّ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","مَيْطٛ اٛنْ اُمِّي، جٛوطِي، فُطِّ مٜتُکِ؞ سٜيْ يٜىٰسُ حٛکِّتِمٛ مَدُوجٛ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","کُلٛلْ نَنْغِٻٜ ٻٜ فُو، ٻٜ مَنْتِ اَللَّه، ٻٜ مبِعِ، ‏«‏اَنَّبِيجٛ مَوْطٛ وَنْغِي حَکُّندٜ مٜىٰطٜنْ!‏ اَللَّه وَرِي وَلُّکِ يِمْٻٜ مُوطُمْ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","حَبَرُ طُمْ سَنْکِتِي ندٜرْ لٜيْدِ يَحُودِيَ اٜ لٜيْطٜ غٛنْطٜ حَادٜ فُو؞ ");
INSERT INTO fuv_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","ندٜ تٛکُّٻٜ يَحَيَ غَطٛووٛ بَڤْتِسْمَ مبِعِمٛ فِي طُعُمْ فُو، اٛ نٛدِّ طِطٛ ندٜرْ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","اٛ لِلِٻٜ تٛ يٜىٰسُ ٻٜ پَمَمٛ، ٻٜ مبِعَ، ‏«‏اَنْ وٛنِ اَلْمَسِيحُ مٛ طُمْ وِعِ وَرَيْ، کٛو مِنْ کٜطٛو غٛطّٛ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","ندٜ ٻٜ نجَحِ تٛ يٜىٰسُ، ٻٜ مبِعِمٛ، ‏«‏يَحَيَ غَطٛووٛ بَڤْتِسْمَ لِلٛيِيمِنْ تٛ مَاطَ مِنْ پَمُمَا، ‏‹‏اَنْ وٛنِ اَلْمَسِيحُ مٛ طُمْ وِعِ وَرَيْ، کٛو مِنْ کٜطٛو غٛطّٛ؟›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","اٜ شَرٜلْ نغٜلْ يٜىٰسُ يَمْطِتِنِي يِمْٻٜ طُطْٻٜ غٛودُٻٜ ݧَوُوجِ، اٛ وُرْتِنِي غِنِّ، اٛ وُمْتِنِي وُمْٻٜ طُطْٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","اٛ وِعِ لِلَاٻٜ يَحَيَ، ‏«‏نجَحٜىٰ، مبِعٛنْ يَحَيَ کٛ نغِيطٛنْ اٜ کٛ نَنُطٛنْ:‏ وُمْٻٜ اٜ مبُمْتَ، جَرَاٻٜ اٜ نجَاٻَ، غٛودُٻٜ ݧَوُ ݧَامٛوجُمْ لَرَلْ اٜ نجَمْطِتِنٜىٰ، ڤَحُٻٜ اٜ نَنَ، مَيْٻٜ اٜ اُمِّنٜىٰ، ٻٜ نغَلَنَا اٜ نغَعَجِنَنٜىٰ حَبَرُ بٜلْطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","اٛ بَرْکِطِنَاطٛ نٜطّٛ مٛ اَلَايِ حٛولَاکِيَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","غَطَ ٻٜ يَحَيَ لِلٛيِ ندِلِّي، يٜىٰسُ فُطِّ مٜتَنْکِ يِمْٻٜ دٛوْ يَحَيَ، اٛ وِعِٻٜ، ‏«‏طُمٜ نجَاطٛنْ رَارٛيْکِ ندٜرْ لَدّٜ؟ کُطٛلْ نغٛلْ حٜنْدُ دِمْبَتَ ندَارٛيْطٛنْ؟ ");
INSERT INTO fuv_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","تٛ نَاع نٛنْ، طُمٜ نجَاطٛنْ رَارٛيْکِ؟ نٜطّٛ ٻٛرْنِيطٛ لِمْشٜ بٛطّٜ؟ نَاع نٛنْ، اَيْ ٻٛرْنٛتٛوٻٜ لِمْشٜ بٛطّٜ اٜ نَنٛوٻٜ بٜلْطُمْ فُو اٜ لَامٛرْدٜ ٻٜ نغٛنِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","تٛو، طُمٜ نجَاطٛنْ رَارٛيْکِ؟ اَنَّبِيجٛ؟ اٜ مِ وِعَعٛنْ غٛونغَ، اٛ ٻُرِي اَنَّبِيجٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","کَنْکٛ وٛنِ مٛ اَللَّه وِعِ ندٜرْ اَايَارٜ، ‏‹‏رَطُّمْ، مِ لِلٛيَيْ لِلَاطٛ اَمْ اٛ اَرْدٛو يٜىٰسٛ مَاطَ، اٛ مٛعِّنَنْمَا لَاوٛلْ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","اٜ مِ وِعَعٛنْ، ندٜرْ ٻٜ رٜوْٻٜ ندَݧِ فُو وَلَا ٻُرْطٛ يَحَيَ غَطٛووٛ بَڤْتِسْمَ مَنْغُ؞ فُو اٜ نٛنْ ٻُرْطٛ فَمْطُکِ ندٜرْ لَامُ اَللَّه ٻُرِيمٛ مَنْغُ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","ندٜ يِمْٻٜ فُو اٜ جَٻٛوٻٜ شٜىٰدٜ لٜيْدِ نَنِ کٛ يٜىٰسُ وِعِ، ٻٜ نجَٻِ طَتَلْ اَللَّه وٛنِ غٛونغَ؞ کَمْٻٜ نغٛنِ ٻٜ يَحَيَ وَطَنّٛو بَڤْتِسْمَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","اَمَّا فَارِسَنْکٛعٜنْ اٜ مٛودِٻّٜ اَتَّوْرَ نغَݧِ کٛ اَللَّه يِطَنِٻٜ؞ ٻٜعٜ نغٛنّٛو غَݧُٻٜ يَحَيَ وَطَنَٻٜ بَڤْتِسْمَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","طٛنْمَا يٜىٰسُ وِعِ، ‏«‏کٛ نَنْدِنَيْمِ يِمْٻٜ جَامَنُ طُعُمْ؟ ");
INSERT INTO fuv_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","اٜ ٻٜ نَنْدِ اٜ سُکَحٛيْ نجٛوطِيکٛيْ ندٜرْ لُومٛ اٜ نٛدِّندِرَ اٜ مبِعَ، ‏‹‏مِنْ ندُودَنِيعٛنْ دُودَاندُ، اَمَّا اٛنْ نغَمَايِ؞ مِنْ مبٛيِ بٛ غٛطّٛ مَايِ، اَمَّا اٛنْ مبٛيَايِ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","نغَمْ يَحَيَ غَطٛووٛ بَڤْتِسْمَ وَرِي ݧَامَتَا ݧَمْندُ يَرَتَا ندِيَمْ اِنَبٛجَمْ، اٛنْ مبِعِي، ‏‹‏اٜ مٛ وٛودِ غِنّٛلْ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","ندٜنْ ٻِي نٜطّٛ وَرِي اٜ ݧَامَ اٜ يَرَ، اٛنْ مبِعِي، ‏‹‏رَا اٛعٛ، اٛ بٜىٰلَاطٛ اٛ جَرٛووٛ، حِغٛ جَٻٛوٻٜ شٜىٰدٜ لٜيْدِ اٜ غَطٛوٻٜ حَکّٜ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","فُو اٜ نٛنْ، تٛکُّٻٜ لَاوٛلْ اَللَّه فُو اٜ ٻٜ کٛلَّ کَنْغٛلْ وٛنِ غٛونغَوٛلْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","غٛعٛتٛ ندٜرْ فَارِسَنْکٛعٜنْ وِعِ يٜىٰسُ اٜ يِطِ يٜىٰسُ يَحَ وُرٛ مُوطُمْ نغَمْ ٻٜ کِرْتٛو؞ اٛ يَحِ وُرٛ نغٛنْ اٛ جٛوطِي نغَمْ اٛ ݧَامَ ݧَمْندُ؞ ");
INSERT INTO fuv_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","اٜ وٛودِ کَارُوَاجٛ اٜ غَرِيرِ ندِنْ، ندٜ اٛ نَنِ يٜىٰسُ اٜ حِرْتٛو اٜ وُرٛ فَارِسَنْکٜىٰجٛ اٛنْ، اٛ وَدِّ جٛلّٛيٜلْ حَيْرٜ بٛنْغٜلْ نغٜلْ نٜبَّمْ اُرٛوجَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","اٛ دَرِي غَطَ يٜىٰسُ حَادٜ کٛيْطٜ مَاکٛ، اٜ مٛ وٛيَ، غٛنْطِ مَاکٛ فُطِّ سٛفْنُکِ کٛيْطٜ يٜىٰسُ، اٛ مٛيْتِرِطٜ غَاسَ حٛورٜ مَاکٛ اٛ مٜىٰمِرِطٜ حٛنْدُکٛ مَاکٛ اٛ مٛيْتَنِطٜ نٜبَّمْ اُرٛوجَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","ندٜ فَارِسَنْکٜىٰجٛ اٛنْ يِعِ نٛنْ، اٛ وِعِ ندٜرْ ٻٜرْندٜ مَاکٛ، ‏«‏دَا نٜطّٛ اٛعٛ اٛ اَنَّبِيجٛ، دَا اٛ اَنْدَيْ طُمْ اِرِ مٛيٜ دٜبّٛ مٜىٰمَتَمٛ، دَا اٛ اَنْدَيْ اٛ غَطٛووٛ حَکّٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","يٜىٰسُ وِعِ فَارِسَنْکٜىٰجٛ اٛنْ، ‏«‏سِيمَنْ، اٜ وٛودِ کٛ مبِعَيْمَامِ؞»‏ اٛ وِعِمٛ، ‏«‏وِعُکَ مٛودِبّٛ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","يٜىٰسُ وِعِمٛ، ‏«‏اٜ وٛودِ يِمْٻٜ طِطٛ جَٻُٻٜ ݧَمَاندٜ شٜىٰدٜ تٛ غٛطّٛ کٛکّٛووٛ ݧَمَاندٜ؞ غٛعٛتٛ جَٻِ شٜىٰدٜ اَجُرْفَارِ 500، غٛعٛتٛ اٛنْ جَٻِ شٜىٰدٜ اَجُرْفَارِ 50؞ ");
INSERT INTO fuv_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","وَلَا غٛودُطٛ شٜىٰدٜ ندٜرْ مَٻّٜ طٜ يٛٻِرْتَمٛ، نغَمْ نٛنْ اٛ يَافَنِيٻٜ ݧَمَاندٜ ندٜنْ؞ اٜ يِيکِ مَاطَ، مٛيٜ ندٜرْ مَٻّٜ ٻُرَتَ يِطُکِمٛ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","سِيمَنْ وِعِمٛ، ‏«‏اٜ مِ کَمّٛو مٛ اٛ يَافَنِي شٜىٰدٜ ٻُرْطٜ طُوطُکِ؞»‏ يٜىٰسُ وِعِمٛ، ‏«‏اَ وِعِي غٛونغَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","سٜيْ اٛ يٜىٰپِي دٜبّٛ اٛنْ اٛ وِعِ سِيمَنْ، ‏«‏اَ يِعِ دٜبّٛ اٛعٛ؟ مِ نَتِّي وُرٛ مَاطَ، اَ حٛکَّايِيَمْ ندِيَمْ لٛوتُمِ کٛيْطٜ اَمْ؞ اَمَّا دٜبّٛ اٛعٛ اٛ سٛفْنِرِي کٛيْطٜ اَمْ غٛنْطِ مَاکٛ اٛ مٛيْتِرِيطٜ غَاسَ حٛورٜ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","اَ حٛوْنَايِيَمْ حٛوْنُکِ حِغَاکُ، اَمَّا دَغَ نَتّٛيْکِ اَمْ دٜبّٛ اٛعٛ حٛوْنِيَمْ بٛطُّمْ، اٛ وَطِ کَ لٛوتُکِ کٛيْطٜ اَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","اَ مٛيْتَنَايِ حٛورٜ اَمْ نٜبَّمْ، اَمَّا کَنْکٛ اٛ مٛيْتَنِي کٛيْطٜ اَمْ نٜبَّمْ اُرٛوجَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","نغَمْ نٛنْ اٜ مِ وِعُمَا، اٛ حٛلِّييَمْ يِدّٜ مَوْندٜ نغَمْ اٜ مٛ اَنْدِ اٛ يَافَنَامَ حَکّٜ طُطُّمْ؞ اَمَّا جَافَنَاطٛ سٜطَّ، يِدّٜ سٜطَّ حٛلَّتَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","سٜيْ يٜىٰسُ وِعِ دٜبّٛ اٛنْ، ‏«‏اَ يَافَنَامَ حَکّٜىٰجِ مَاطَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","ݧَمْدٛوٻٜ اٜ مَاکٛ ڤُطِّ مٜتُکِ حَکُّندٜ مَٻّٜ، اٜ مبِعَ، ‏«‏طُمْ مٛيٜ وٛنِ اٛعٛ، حَا حَکّٜ فُو اٜ مٛ يَافٛ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","يٜىٰسُ وِعِ دٜبّٛ اٛنْ، ‏«‏اَ حِسِي نغَمْ اَ حٛولَکٜيَمْ، يَحُ جَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","غَطَ طٛنْ، يٜىٰسُ يَحِ غَرِيجٜ اٜ نغَرِحٛيْ ڤَمَرٛيْ فُو، اٜ وَعَجِنَ حَبَرُ بٜلْطُمْ دٛوْ لَامُ اَللَّه؞ تٛکُّٻٜمٛ سَڤّٛ اٜ طِطٛ اٜ نغٛنْدِ اٜ مَاکٛ، ");
INSERT INTO fuv_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","اٜ وٛٻّٜ رٜوْٻٜ بُرْتِنَنَاٻٜ غِنِّ اٜ جَمْطِتِنَاٻٜ دَغَ ݧَوُوجِ؞ کَمْٻٜ نغٛنِ مَرْيَامَ پِوٛيْطٛ مَغَدَلَ، مٛ غِنِّ جٛوٜىٰطِطِ مبُرْتِي ندٜرْ مُوطُمْ، ");
INSERT INTO fuv_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","اٜ يٛوَانَ، دٜبّٛ کُوجَ، اَرْدِيطٛ کُوٛوٻٜ وُرٛ حِرُدُسْ، اٜ سُجَانَ، اٜ وٛٻّٜ رٜوْٻٜ طُطْٻٜ، بَلّٛوٻٜٻٜ دَغَ ندٜرْ جَوْدِ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","يِمْٻٜ طُطْٻٜ نغَطِ کَ وَرْکِ تٛ يٜىٰسُ دَغَ غَرِيجٜ فٜىٰرٜ‑فٜىٰرٜ؞ ندٜ يِمْٻٜ طُطْٻٜ کَوْرِتِ، اٛ حٛکِّٻٜ مِسَالُ طُعُمْ، اٛ وِعِ، ");
INSERT INTO fuv_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","‏«‏غٛطّٛ دٜمٛووٛ يَحِ نغٜسَ نغَمْ سَاکَ اَوْدِ؞ اٜ مٛ ندٜرْ سَاکُکِ اَوْدِ ندِنْ، وٛنْدِ يَنِ دٛوْ طَتَلْ، ندِ يَاٻَا، شٛلِّ شُڤِّدِندِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","وٛنْدِ بٛو يَنِ ندٜرْ کَاپٜ، ندٜ ندِ فُطِ، ندِ يٛورِ نغَمْ ندِيَمْ حٜپَايِندِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","وٛنْدِ اَوْدِ بٛو يَنِ ندٜرْ غِعٜ، طٜ مَوْنِدِ اٜ مَيْرِ، طٜ طٜطِّندِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","اَمَّا وٛنْدِ اَوْدِ يَنِ دٛوْ لٜيْدِ مبٛنْدِ، ندِ مَوْنِ، ندِ وَطِ شَمّٜىٰجٜ؞ غَبّٜلْ غٛعٛ فُو وَطِ نغَبّٛيْ 100؞»‏ ندٜ يٜىٰسُ حٜىٰݧِ حٛکُّکِٻٜ مِسَالُ طُعُمْ، اٛ نٛدِّ اٜ سٜمْبٜ، اٛ وِعِ، ‏«‏غٛودُطٛ نٛڤِّ نَنُکِ فُو نَنَ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","تٛکُّٻٜمٛ پَمِمٛ اٛ فَمْتِنَٻٜ مِسَالُ طُعُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","اٛ وِعِ، ‏«‏اٛنٛنْ اٛنْ کٛکَّامَ فَامُ سِرُّ لَامُ اَللَّه، اَمَّا وٛٻّٜ سٜيْ اٜ مِسَالُ طُعُمْ، نغَمْ ‏‹‏اٜ ٻٜ ندَارَ، اَمَّا ٻٜ نغِعَتَا؛ اٜ ٻٜ نَنَ، اَمَّا ٻٜ ڤَامَتَا؞›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","اٛ وِعِ، ‏«‏رَا مَعَنَ مِسَالُ طُعُمْ:‏ اَوْدِ ندِنْ وٛنِ وٛلْدٜ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","نجَنُندِ دٛوْ طَتَلْ وٛنِ نَنُٻٜ وٛلْدٜ اَللَّه، ندٜنْ شٜيْطَنْ وَرَ حٛشَّندٜ دَغَ ندٜرْ ٻٜرْطٜ مَٻّٜ، نغَمْ تٛع ٻٜ مبَاوَ جَٻُکِندٜ ٻٜ کِسَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","نجَنُندِ دٛوْ حَيْرٜ وٛنِ يِمْٻٜ جَٻُٻٜ وٛلْدٜ اَللَّه ندٜرْ بٜلْطُمْ ٻٜرْندٜ، اَمَّا ندٜ وَلَا طَطِ، ندٜ جٛوطَاکِ ندٜرْ ٻٜرْطٜ مَٻّٜ؞ ٻٜ نجَٻُندٜ نغَمْ شَرٜلْ سٜطَّ، اَمَّا ندٜ طُمْ فٛوندِٻٜ، ٻٜ نجٛوفِندٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","اَوْدِ نجَنُندِ ندٜرْ غِعٜ بٛو وٛنِ يِمْٻٜ نَنُٻٜ وٛلْدٜ ندٜنْ، اَمَّا وَنَّارٜ، اٜ رِسْکُ، اٜ بٜلْطُمْ دُونِيَارُ ٻِطِّ ٻٜرْطٜ مَٻّٜ، نغَمْ نٛنْ ٻٜ مَوْنَايِ ندٜرْ طَتَلْ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","اَمَّا اَوْدِ جَنُندِ دٛوْ لٜيْدِ مبٛنْدِ وٛنِ نَنُٻٜ وٛلْدٜ اَللَّه، ٻٜ نجٛغٛوندٜ ٻٜرْندٜ غٛعٛ، ندٜرْ مُݧَلْ ٻٜ تٛکَّندٜ حَا ٻٜ نغَطَ کٛ اَللَّه يِطِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","‏«‏وَلَا غَطَنَيْطٛ فِتِلَارُ حِيتٜ حِڤَّ تُمُّدٜ دٛوْ مَيْرُ کٛو رٜسَندُ لٜيْ لٜىٰسٛ؞ سٜيْ نِ اٛ رٜسَندُ دٛوْ دَنْکِ، نغَمْ ندُ يٜيْنَنٛو نَتُّطٛ فُو؞ ");
INSERT INTO fuv_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","‏«‏نغَمْ وَلَا فِي شُوطِيطُمْ طُمْ سُورِتَتَاکٜ؞ نٛنْ بٛو وَلَا سِرُّ طُمْ اَنْدِتَتَاکٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","‏«‏نغَمْ نٛنْ ڤَامٜىٰ بٛطُّمْ نٛ نَنِرْتٛنْ؞ نغَمْ فُو غٛودُطٛ فَامُ دٛوْ لَامُ اَللَّه طُمْ ٻٜيْدَنَيْمٛ؞ اَمَّا مٛ وَلَا فَامُ دٛوْ لَامُ اَللَّه، حَا کٛ اٛ ݧُمَتَ اٜ مٛ وٛودِ طُمْ جَٻَيْطُمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","ندٜنْ مَدُوجٛ يٜىٰسُ اٜ مِݧِرَاٻٜ مَاکٛ نغَرِ تٛ مَاکٛ، اَمَّا ٻٜ کٜٻَايِ يٛتَّاکِ حَادٜ مَاکٛ نغَمْ يِمْٻٜ طُوطِي؞ ");
INSERT INTO fuv_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","غٛطّٛ وِعِمٛ، ‏«‏مَدُوجٛ مَاطَ اٜ مِݧِرَاٻٜ مَاطَ اٜ ٻٜ تٛنْ ندَرِي يَاسِ، اٜ ٻٜ نغِطِ يِيکِمَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","اَمَّا اٛ نٛوتِي، اٛ وِعِ، ‏«‏نَنٛوٻٜ وٛلْدٜ اَللَّه، نغَطَ کٛ ندٜ وِعِ، کَمْٻٜ نغٛنِ مَدُوجٛ اَمْ اٜ مِݧِرَاٻٜ اَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","وٛنْدٜ ݧَلْندٜ يٜىٰسُ نَتِّ کٛمِوَلْ، کَنْکٛ اٜ تٛکُّٻٜمٛ، اٛ وِعِٻٜ، ‏«‏اٜنْ کُولُ فٛنْغٛ مبٜىٰلَ؞»‏ سٜيْ ٻٜ ندِلِّ؞ ");
INSERT INTO fuv_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","اٜ ٻٜ ندٜرْ حُولُکِ، يٜىٰسُ طَانِي؞ اِيٜىٰندٜ اٜ حٜنْدُ شٜمْبِنْدُ اُمّٛيِي دٛوْ مبٜىٰلَ نغَنْ، کٛمِوَلْ نغَلْ فُطِّ ݧٜطُکِ ندِيَمْ، ٻٜ ٻَدِي حَلْکُکِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","ٻٜ ٻَدِّي يٜىٰسُ، ٻٜ ڤِنْدِنِمٛ، اٜ ٻٜ مبِعَ، ‏«‏مٛودِبّٛ، مٛودِبّٛ، اٜنْ کَلْکَيْ!‏»‏ اٛ اُمِّي، اٛ حَٻَنِ حٜنْدُ ندُنْ اٜ غٜىٰلٛوطِ ندِيَمْ طِنْ؞ کٛو طُمٜ دَرِي، دٜعِّتِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","اٛ وِعِٻٜ، ‏«‏کٛ وَطِ اٛنْ کٛولَاکِيَمْ؟»‏ ٻٜ کُلِ، ٻٜ کَيْطِنِ، ٻٜ نغَطِ کَ مٜتُکِ حَکُّندٜ مَٻّٜ، اٜ ٻٜ مبِعَ، ‏«‏اٛعٛ طُمْ مٛيٜ؟ اٛ حَٻَنِي کٜنِ اٜ ندِيَمْ، اٜ طِ نغَطَ کٛ اٛ وِعِ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","ٻٜ نجٛتِّي لٜيْدِ غَارَسِنْکٛعٜنْ نغٛنْدِ فٛنْغٛ مبٜىٰلَ غَلِيلِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","ندٜ يٜىٰسُ وُرْتِي ندٜرْ کٛمِوَلْ، اٛ حَوْرِ اٜ نٜطّٛ غَرِيرِ ندِنْ غٛودُطٛ غِنِّ؞ طُمْ نٜىٰٻِي نٜطّٛ اٛنْ اٜ يَحَ ٻٛرْنَتَاکٛ، اٛ جٛوطَتَاکٛ ندٜرْ وُرٛ، سٜيْ ندٜرْ غٜنَالٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","ندٜ اٛ يِعِ يٜىٰسُ، اٛ يَنِ يٜىٰسٛ مَاکٛ، اٛ وُلِّ سٜمْبٜىٰ، اٛ وِعِ، ‏«‏وَيْيٛو!‏ کٛ وَنُّمَا اٜ اَمْ، يٜىٰسُ ٻِطّٛ اَللَّه جٛومُ مَنْغُ؟ اٜ مِ تٛرٛمَا، تَاع تٛرَّمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","اٛ وِعُ نٛنْ نغَمْ يٜىٰسُ حَٻَنِي غِنّٛلْ نغٛلْ نغٛلْ وُرْتٛو ندٜرْ مَاکٛ؞ ندٜنْ مَا، نغٛلْ نٜىٰٻِ اٜ نغٛلْ نَنْغَمٛ؞ اٜ مٛ حَٻِّرٜىٰ ٻٛغِّ نجَمْندِ جُوطٜ اٜ کٛيْطٜ، اَمَّا اٜ مٛ تَپَ ٻٛغِّ طِنْ، نغٛلْ وَطَمٛ اٛ نَتَّ لَدّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","يٜىٰسُ پَمِمٛ، وِعِ، ‏«‏نٛ اِنْدٜ مَاطَ؟»‏ اٛ نٛوتِي اٛ وِعِ، ‏«‏اٜ مِ نٛدِّرٜىٰ طُطِّ،»‏ نغَمْ اٜ مٛ وٛودِ غِنِّ طُطِّ؞ ");
INSERT INTO fuv_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","طِ نغَطِ کَ تٛرَاکِ يٜىٰسُ تٛع اٛ وِعَ طِ نَتَّ نغَيْکَ کَلُّکَ لُغُّکَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","حَادٜ طٛنْ اٜ وٛودِ اٛرْندٜ اَلَدٜىٰجِ طُطِّ اٜ ندُرَ دٛوْ پٛلْدٜ؞ طِ تٛرِي يٜىٰسُ اَلَطِ طِ نَتّٛيِ ندٜرْ اَلَدٜىٰجِ طِنْ؞ سٜيْ اٛ اَلِطِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","طِ مبُرْتِي ندٜرْ نٜطّٛ اٛنْ، طِ نَتّٛيِ اٛرْندٜ اَلَدٜىٰجِ طِنْ؞ اٛرْندٜ ندٜنْ فُو ݧَارِ جِڤّٛيِي دَغَ دٛوْ پٛلْدٜ ندٜنْ، يَنِ ندٜرْ مبٜىٰلَ، ندِيَمْ ݧَامِطِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","ندٜ وٛيْنَاٻٜ اَلَدٜىٰجِ طِنْ نغِعِ نٛنْ، ٻٜ ندٛغِّ، ٻٜ مبِعٛيِکَ يِمْٻٜ غَرِيرِ اٜ يِمْٻٜ نغَرِحٛيْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","سٜيْ يِمْٻٜ ٻٜنْ نجَحِ نغِعٛيَ کٛ فٛفِ؞ ندٜ ٻٜ نغَرِ تٛ يٜىٰسُ، ٻٜ تَوِ بُرْتِنَنَاطٛ غِنِّ اٛنْ اٜ جٛوطِي حَادٜ يٜىٰسُ، اٜ ٻٛرْنِي، اٜ مٛ ندٜرْ حَکِّيلٛ مَاکٛ؞ کٛو مٛيٜ مَٻّٜ حُلِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","غِعُٻٜ کٛ وَطِ مبِعِ يِمْٻٜ نٛ غٛودُنٛوطٛ غِنِّ اٛنْ يَمْطِتِنِرَا؞ ");
INSERT INTO fuv_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","يِمْٻٜ لٜيْدِ غَارَسِنْ فُو تٛرِي يٜىٰسُ اَلَنَٻٜ لٜيْدِ مَٻّٜ، نغَمْ کُلٛلْ مَنْغٛلْ نَنْغِيٻٜ؞ نغَمْ مَاجُمْ اٛ نَتِّ کٛمِوَلْ اٛ سٛعّٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","نٜطّٛ بُرْتِنَنَاطٛ غِنِّ اٛنْ تٛرِي يٜىٰسُ نغَمْ اٛ دِلِّدَ اٜ مَاکٛ، اَمَّا اٛ سٛعِّمٛ، اٛ وِعِ، ");
INSERT INTO fuv_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","‏«‏سٛعَّ وُرٛ مَاطَ، مبِعَا فِي مَوْطُمْ طُمْ اَللَّه وَطَنْمَا؞»‏ سٜيْ نٜطّٛ اٛنْ سٛعِّي اٜ وِعَ يِمْٻٜ غَرِيرِ ندِنْ فِي مَوْطُمْ طُمْ يٜىٰسُ وَطَنِمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","ندٜ يٜىٰسُ سٛعِّي، کَوْرُتُٻٜ نجَٻِّيمٛ، نغَمْ ٻٜ فُو ٻٜ کَاٻِي ٻٜ نغِعَمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","سٜيْ غٛطّٛ بِعٜتٜىٰطٛ جَايِرُسْ، اَرْدِيطٛ سُودُ دٛعَارٜ وَرِ، دِشِّي يٜىٰسٛ يٜىٰسُ، تٛرِيمٛ اٛ يَحَ وُرٛ مَاکٛ، ");
INSERT INTO fuv_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","نغَمْ اٜ مٛ وٛودِ ٻِطّٛ غٛعٛتٛ سُرْبَاجٛ، دُوٻِ مَاکٛ نغَطَيْ سَڤّٛ اٜ طِطِ، اٛ ٻَدَکٜ مَيْدٜ؞ يٜىٰسُ اٜ يَحَ، يِمْٻٜ طُطْٻٜ اٜ تٛکِّمٛ حَا اٜ ٻٜ ٻِطَّمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","اٜ وٛودِ غٛطّٛ دٜبّٛ غَطُطٛ دُوٻِ سَڤّٛ اٜ طِطِ اٜ تٛرّٛدٛو اٜ رُفُکِ پِيپَمْ؞ اٛ مَجِّنِي فُو جَوْدِ مَاکٛ تٛ ݧَوْندٛوٻٜ، اَمَّا وَلَا بَوْطٛ يَمْطِنْکِمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","اٛ پِوٛيِ غَطَ يٜىٰسُ، اٛ مٜىٰمِ شِلْمبِ تٛغّٛورٜ مَاکٛ؞ سٜيْ طٛنْ اٜ طٛنْ رُفُکِ پِيپَمْ طَمْ دَرِي؞ ");
INSERT INTO fuv_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","يٜىٰسُ وِعِ، ‏«‏مٛيٜ مٜىٰمِيَمْ؟»‏ کٛو مٛيٜ وِعِ نَاع طُمْ کَنُمْ؞ بِيتُرُسْ بٛو وِعِمٛ، ‏«‏مٛودِبّٛ، حَکُّندٜ يِمْٻٜ طُطْٻٜ نغٛنْطَا، اٜ ٻٜ ٻِطُّمَا؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","اَمَّا يٜىٰسُ وِعِ، ‏«‏غٛطّٛ مٜىٰمِييَمْ؞ مِ نَنِي بَوْطٜ مبُرْتَکٜ ندٜرْ اَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","ندٜ دٜبّٛ اٛنْ اَنْدِتِ سُوطَتَاکٛ، وَرِ اٜ دِوْنَ، دِشِّي يٜىٰسٛ مَاکٛ؞ يٜىٰسٛ يِمْٻٜ فُو اٛ وِعِ کٛ وَطِ اٛ مٜىٰمِمٛ، اٜ نٛ اٛ يَمْطِتِرِ طٛنْ اٜ طٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","يٜىٰسُ وِعِمٛ، ‏«‏بَنْدِرَاوٛ، حٛولَارٜ مَاطَ يَمْطِتِنِيمَ؞ نجِڤّٛطَا جَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","يٜىٰسُ اٜ مٜتَ، سٜيْ غٛطّٛ وَرٛيِ دَغَ وُرٛ جَايِرُسْ اَرْدِيطٛ سُودُ دٛعَارٜ، وِعِمٛ، ‏«‏جَايِرُسْ، ٻِطّٛ مَاطَ مَايِ؞ تَاع وَنُّ مٛودِبّٛ کَدِنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","اَمَّا ندٜ يٜىٰسُ نَنِ نٛنْ، وِعِ جَايِرُسْ، ‏«‏تَاع حُلُ، حٛولَيَمْ تَنْ، ندٜنْ ٻِطّٛ مَاطَ اُمّٛتٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","ندٜ اٛ يٛتِّي وُرٛ جَايِرُسْ، اٛ حَطِ کٛو مٛيٜ نَتِّدَ اٜ مَاکٛ، سٜيْ بِيتُرُسْ، اٜ يَحَيَ، اٜ يَاکُبُ، اٜ ݧَاکٛ سُرْبَاجٛ اٛنْ اٜ مَدُوجٛ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","کٛو مٛيٜ اٜ وٛيَ اٜ وُلَّ سٜمْبٜىٰ؞ اَمَّا يٜىٰسُ وِعِٻٜ، ‏«‏اَلٜىٰ وٛيُکِ؞ اٛ مَايَايِ، اٛ طَانِ تَنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","سٜيْ ٻٜ نجَلِمٛ نغَمْ اٜ ٻٜ اَنْدِ سُرْبَاجٛ اٛنْ مَايِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","اَمَّا يٜىٰسُ جٛغِي جُنْغٛ مَيْطٛ اٛنْ، نٛدِّمٛ، وِعِ، ‏«‏سُرْبَاجٛ، اُمَّ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","يٛنْکِ سُرْبَاجٛ اٛنْ وَرْتِ، طٛنْ اٜ طٛنْ اٛ اُمِّي؞ ندٜنْ يٜىٰسُ وِعِٻٜ ٻٜ کٛکَّمٛ کٛ اٛ ݧَامَتَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","دَݧٛوٻٜ سُرْبَاجٛ اٛنْ کَيْطِنِ، اَمَّا اٛ وِعِٻٜ تٛع ٻٜ مبِعَکَ کٛو مٛيٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","غَطَ يٜىٰسُ نٛدِّي تٛکُّٻٜمٛ سَڤّٛ اٜ طِطٛ، اٛ حٛکِّٻٜ بَوْطٜ اٜ لَامُ دٛوْ وُرْتِنْکِ غِنِّ اٜ يَمْطِنْکِ ݧَوُوجِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","اٛ لِلِٻٜ ٻٜ نغَعَجِنَ لَامُ اَللَّه، ٻٜ نجَمْطِتِنَ ٻٜ نجَمْطَا؞ ");
INSERT INTO fuv_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","اٛ وِعِٻٜ، ‏«‏تٛع اٛنْ کٛشُّ کٛو طُمٜ نغَمْ يَادُ، کٛو سَوْرُ، کٛو جَکَارٜ، کٛو ݧَمْندُ، کٛو شٜىٰدٜ، کٛو تٛغّٛوجٜ طِطِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","وُرٛ نغٛ اَرْتُطٛنْ نَتُّکِ فُو، نجٛوطٜىٰ طٛنْ نَا اٛنْ اَلِي غَرِيرِ ندِنْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","تٛ يِمْٻٜ ندٜرْ غَرِيرِ ندِنْ نجَٻَّاکِعٛنْ، اَلٜىٰ غَرِيرِ ندِنْ، ڤِطّٜىٰ سٛلَّارٜ کٛيْطٜ مٛوطٛنْ؞ کَنْجُمْ حٛلَّتَ ٻٜ نغَطِي حَکّٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","سٜيْ ٻٜ ندِلِّ، ٻٜ نجَحِ نغَرِحٛيْ فٜىٰرٜ‑فٜىٰرٜ، اٜ ٻٜ نغَعَجِنَ حَبَرُ بٜلْطُمْ، اٜ ٻٜ نجَمْطِتِنَ يِمْٻٜ کٛو تٛيٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","ندٜ حِرُدُسْ، لَامِيطٛ لٜيْدِ غَلِيلِ، نَنِ کٛو طُمٜ کٛ وَطَتَ، اٛ وَنِّي نغَمْ وٛٻّٜ اٜ مبِعَ طُمْ يَحَيَ غَطٛووٛ بَڤْتِسْمَ اُمِّي دَغَ مَيْدٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","وٛٻّٜ بٛو اٜ مبِعَ طُمْ اَنَّبِ اِلِيَ وَنْغِ، اَمَّا وٛٻّٜ کَدِمَا اٜ مبِعَ طُمْ غٛعٛتٛ ندٜرْ اَنَّبٛعٜنْ ندٜنّٛ اُمِّي؞ ");
INSERT INTO fuv_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","حِرُدُسْ وِعِ، ‏«‏مِ اِتَّنِي يَحَيَ حٛورٜ؞ طُمْ مٛيٜ کَدِنْ وٛنِ اٛعٛ، مٛ نَنَيْمِ فِي طُعُمْ دٛوْ مُوطُمْ؟»‏ ندٜنْ اٛ طَٻِّتِ نٛ اٛ يِعِرْتَ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","ندٜ لِلَاٻٜ نغَرْتِ، ٻٜ مبِعِ يٜىٰسُ کٛ ٻٜ نغَطِ؞ سٜيْ اٛ حٛشِّٻٜ کَمْٻٜ تَنْ يَاکِ حَادٜ غَرِيرِ بِعٜتٜىٰندِ بٜتَسَيْدَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","اَمَّا ندٜ يِمْٻٜ طُطْٻٜ حَوْرُتُٻٜ نغِعِ نٛنْ، ٻٜ تٛکِّمٛ؞ اٛ جَٻِّيٻٜ، اٛ مٜتَنِٻٜ دٛوْ لَامُ اَللَّه؞ اٛ يَمْطِتِنِ غِطْٻٜ يَمْطِتِنٜىٰکِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","ندٜ نَانغٜ حِيرِ، تٛکُّٻٜمٛ سَڤّٛ اٜ طِطٛ نغَرِ تٛ مَاکٛ، مبِعِ، ‏«‏وِعُ حَوْرُتُٻٜ ندِلَّ نغَرِحٛيْ اٜ غُرٜ غٛنْطٜ حَادٜ نغَمْ ٻٜ کٜٻَ کٛ ٻٜ ݧَامَتَ اٜ تٛ ٻٜ مبَالَتَ، نغَمْ طٛعٛ طُمْ لَدّٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","سٜيْ اٛ وِعِٻٜ، ‏«‏اٛنٛنْ کٛکّٜىٰٻٜ کٛ ٻٜ ݧَامَتَ؞»‏ اَمَّا ٻٜ مبِعِمٛ، ‏«‏بُرٛودِ جٛوِ اٜ لِپِّ طِطِ تَنْ مِنْ نغٛودِ طٛعٛ؞ سٜيْ نِ مِنْ نجَحَ، مِنْ شٛودَ ݧَمْندُ نغَمْ يِمْٻٜ ٻٜعٜ فُو؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","وٛرْٻٜ تَنْ ندٜرْ حَوْرُتُٻٜ ٻٜنْ ٻَدَکٜ 5,000؞ سٜيْ يٜىٰسُ وِعِ تٛکُّٻٜمٛ، ‏«‏مبِعٜىٰٻٜ ٻٜ نجٛوطٛ مٛٻْدٜ يِمْٻٜ 50 ‑ 50 کٛو تٛيٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","سٜيْ ٻٜ نغَطِ نٛنْ، کٛو مٛيٜ جٛوطِي؞ ");
INSERT INTO fuv_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","يٜىٰسُ حٛشِّ بُرٛودِ جٛوِ طِنْ اٜ لِپِّ طِطِ طِنْ، اٛ رَارِ دٛوْ، اٛ يٜتِّ اَللَّه، اٛ سٜنْدِطُمْ، اٛ حٛکِّ تٛکُّٻٜمٛ نغٜىٰدَنَ حَوْرُتُٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","ٻٜ فُو ٻٜ ݧَامِ، ٻٜ کَارِ؞ تٛکُّٻٜمٛ مٛٻْتِ کٛ حٛرِي کٛ وَطِ کٛنْدٛوجٜ سَڤّٛ اٜ طِطِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","وٛنْدٜ ݧَلْندٜ يٜىٰسُ اٜ وَطَ دٛعَارٜ، کَنُمْ تَنْ، تٛکُّٻٜمٛ اٜ حَادٜ مَاکٛ؞ اٛ پَمِٻٜ، اٛ وِعِ، ‏«‏مٛيٜ يِمْٻٜ مبِعَتَيَمْ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","ٻٜ نٛوتِي ٻٜ مبِعِ، ‏«‏وٛٻّٜ اٜ مبِعَ اَ يَحَيَ غَطٛووٛ بَڤْتِسْمَ؞ وٛٻّٜ بٛو اٜ مبِعَ اَ اَنَّبِ اِلِيَ؞ ندٜنْ وٛٻّٜ کَدِمَا اٜ مبِعَ غٛعٛتٛ ندٜرْ اَنَّبٛعٜنْ ندٜنّٛ اُمِّي؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","اٛ وِعِٻٜ، ‏«‏اَمَّا اٛنٛنْ، مٛيٜ مبِعٛتٛنْيَمْ؟»‏ سٜيْ بِيتُرُسْ نٛوتِي، وِعِ، ‏«‏اَنْ وٛنِ اَلْمَسِيحُ مٛ اَللَّه!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","اَمَّا يٜىٰسُ حَطِٻٜ تٛع ٻٜ مبِعَکَ کٛو مٛيٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","ندٜنْ اٛ وِعِ، ‏«‏دٛولٜ ٻِي نٜطّٛ يَرَ بٛنٜ طُطُّمْ؞ مَوْٻٜ يِمْٻٜ اٜ مَوْٻٜ اَرْدِيٻٜ دِينَ اٜ مٛودِٻّٜ اَتَّوْرَ نغَݧَمٛ، ندٜنْ اٛ وَرٜىٰ؞ ندٜرْ ݧَلْندٜ تَتَوْرٜ بٛو طُمْ اُمِّنَيْمٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","سٜيْ اٛ وِعِٻٜ ٻٜ فُو، ‏«‏فُو غِطّٛ وَرْتَ تٛکُّطٛيَمْ، تٛع وَطَ کٛ حٛورٜ مُوطُمْ يِطِ وَطُکِ تَنْ، اَمَّا دٛولٜ حٛشَّ غَافَانغَلْ مُوطُمْ کٛو ندٜيٜ تٛکَّيَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","نغَمْ فُو غِطّٛ حِسْنُکِ يٛنْکِ مُوطُمْ اٛ دُلَّيْکِ؞ اَمَّا فُو دُلَّيْطٛ يٛنْکِ مُوطُمْ نغَمْ اَمْ اٛ حِسْنَيْکِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","کٛ طُمْ نَفَنْتَ نٜطّٛ، تٛ اٛ حٜٻِي دُونِيَارُ فُو، اَمَّا اٛ مَجِّنِي حٛورٜ مَاکٛ کٛو اٛ حَلْکِ؟ ");
INSERT INTO fuv_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","کٛو مٛيٜ غَݧُطٛيَمْ، مِنْ ٻِي نٜطّٛ اٜ بٛلِيطٜ اَمْ، مِ وَݧَيْمٛ تٛ مِ وَرْتٛيِي ندٜرْ تٜدُّنغَلْ اَمْ، اٜ ندٜرْ تٜدُّنغَلْ ݧَاکٛ اَمْ مٛ دٛوْ، اٜ مَلَاعِکَعٜنْ مَاکٛ شٜنِيٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","اٜ مِ وِعَعٛنْ غٛونغَ، اٜ وٛودِ وٛٻّٜ دَرِيٻٜ طٛعٛ ٻٜ مَايَتَا نَا ٻٜ نغِعِي لَامُ اَللَّه؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","بَلْطٜ جٛوٜىٰتَتِ غَطَ يٜىٰسُ وِعِٻٜ بٛلِيطٜ طٜنْ، اٛ پٜىٰݝِ دٛوْ حٛشّٜىٰرٜ نغَمْ اٛ وَطَ دٛعَارٜ؞ بِيتُرُسْ، اٜ يَحَيَ، اٜ يَاکُبُ اٜ وٛنْدِ اٜ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","اٜ مٛ ندٜرْ دٛعَارٜ سٜيْ يٜىٰسٛ مَاکٛ اٜ کٛلْتٜ مَاکٛ نغَرْتِ دَنٜىٰجٜ تَرْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","طٛنْ اٜ طٛنْ سٜيْ رَا، اَنَّبٛعٜنْ طِطٛ، مُوسَ اٜ اِلِيَ، وَنْغِ ");
INSERT INTO fuv_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ندٜرْ تٜدُّنغَلْ، اٜ ٻٜ مٜدَّ اٜ مَاکٛ؞ ٻٜ مٜدِّ دٛوْ مَيْدٜ مَاکٛ ندٜ تَبِّتَيْ نَاع کٛ نٜىٰٻِ ندٜرْ اُرُشَلِيمَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","بِيتُرُسْ اٜ غٛنْدُٻٜ اٜ مُوطُمْ طَانَکٜ، شَرٜلْ کٛ ٻٜ کُيْلِي، ٻٜ نغِعِ تٜدُّنغَلْ مَاکٛ اٜ يِمْٻٜ طِطٛ دَرٛدِيٻٜ اٜ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","شَرٜلْ کٛ اَنَّبٛعٜنْ ٻٜنْ اَلَتَ يٜىٰسُ، بِيتُرُسْ وِعِمٛ، ‏«‏مٛودِبّٛ، وٛنْکِ اَمِنْ طٛعٛ اٜ وٛوطِ؞ اَلْ مِنْ ݧِٻَ شُوطِ تَتِ، وٛعٛيْرُ ندُ مَاطَ، وٛعٛيْرُ ندُ مُوسَ، ندٜنْ وٛعٛيْرُ ندُ اِلِيَ؞»‏ اَمَّا بِيتُرُسْ اَنْدَا کٛ وِعَتَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","اٜ مٛ ندٜرْ مٜتُکِ، سٜيْ ندُولَ وَنْغِ، سُدِّٻٜ، ٻٜ کُلْتٛرِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","ٻٜ نَنِ حٛنٛنْدٜ اَللَّه دَغَ ندٜرْ ندُولَ نغَنْ وِعِ، ‏«‏اٛعٛ وٛنِ ٻِطّٛ اَمْ مٛ شُٻُمِ؞ نَنٜىٰ کٛ اٛ وِعَتَعٛنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","ندٜ حٛنٛنْدٜ ندٜنْ دٜعِّتِ، ٻٜ نغِعِ يٜىٰسُ کَنُمْ تَنْ؞ تٛکُّٻٜمٛ اَلِطُمْ حَکُّندٜ مَٻّٜ، ندٜرْ ݧَلْطٜ طٜنْ ٻٜ مبِعَايِ غٛطّٛ کٛ ٻٜ نغِعِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","ندٜ وٜىٰتِ، ٻٜ نجِڤّٛيِي دَغَ دٛوْ حٛشّٜىٰرٜ ندٜنْ، کَوْرُتُٻٜ طُطْٻٜ تَوِمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","ندٜرْ کَوْرُتُٻٜ ٻٜنْ غٛطّٛ غٛرْکٛ نٛدِّ اٜ سٜمْبٜ، وِعِ، ‏«‏مٛودِبّٛ، اٜ مِ تٛرٛمَا، رَارُ ٻِطّٛ اَمْ غٛرْکٛ نغَمْ کَنْکٛ تَنْ نغٛودُمِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","غِنّٛلْ نٜىٰٻِي اٜ نَنْغَمٛ؞ تٛ نغٛلْ نَنْغِيمٛ، اٛ فُطَّ وُلُّکِ، اٛ وَطَ کَ دِوْنُکِ، نغُوفٛ نغَطَ کَ وُرْتٛيَاکِ ندٜرْ حٛنْدُکٛ مَاکٛ، نغٛلْ اَلَتَامٛ نَا نغٛلْ نَوْنِيمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","مِ تٛرَکٜ تٛکُّٻٜمَ مبُرْتِنَنغٛلْ، اَمَّا ٻٜ مبَاوَايِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","يٜىٰسُ نٛوتِي، وِعِ، ‏«‏اٛنٛنْ يِمْٻٜ جَامَنُ طُعُمْ کَلُّطُمْ اٛنْ کٛولَاکِيَمْ، حَا ندٜيٜ نجٛوطٛدٛتٛومِ اٜ مٛوطٛنْ اٜ مِ مُݧِدَ اٜ مٛوطٛنْ؟ وَدُّ ٻِطّٛ مَاطَ طٛعٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","ٻِطّٛ اٛنْ اٜ وَرٛيَ، سٜيْ غِنّٛلْ نغٛلْ دٛعِّمٛ، اٜ مٛ دِوْنَ؞ اَمَّا يٜىٰسُ حَٻَنِ غِنّٛلْ نغٛلْ، يَمْطِتِنِ سُکَ اٛنْ، حٛکِّتِمٛ ݧَاکٛ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","وٛنْٻٜ طٛنْ فُو کَيْطِنِ اٜ مَنْغُ اَللَّه؞ اَمَّا اٜ ٻٜ ندٜرْ حَيْطِنْکِ دٛوْ کٛ اٛ وَطِ، يٜىٰسُ وِعِ تٛکُّٻٜمٛ، ");
INSERT INTO fuv_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","‏«‏ڤَامٜىٰ بٛطُّمْ نَنٛنْ کٛ مبِعَيْمِعٛنْ!‏ طُمْ حٛکِّتِرَيْ ٻِي نٜطّٛ ندٜرْ جُوطٜ يِمْٻٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","اَمَّا ٻٜ ڤَامَايِ کٛ اٛ وِعِٻٜ؞ طُمْ سُوطَنَکٜٻٜ نغَمْ تٛع ٻٜ ڤَامَطُمْ، ندٜنْ اٜ ٻٜ کُلَ پَمُکِمٛ دٛوْ مَاجُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","ندٜنْ غٜدِّ اُمِّي حَکُّندٜ تٛکُّٻٜمٛ دٛوْ طُمْ مٛيٜ ٻُرِ مَنْغُ ندٜرْ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","اَمَّا يٜىٰسُ حٜٻْتِ کٛ وٛنِ ندٜرْ ٻٜرْطٜ مَٻّٜ، سٜيْ اٛ حٛشِّ سُکَيٜلْ ڤَمَرٜلْ، اٛ دَرْنِنغٜلْ حَادٜ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ندٜنْ اٛ وِعِٻٜ، ‏«‏کٛو مٛيٜ جَٻُطٛ سُکَيٜلْ ڤَمَرٜلْ بٛ نغٜعٜلْ ندٜرْ اِنْدٜ اَمْ جَٻِييَمْ؞ ندٜنْ کٛو مٛيٜ جَٻُطٛيَمْ جَٻِي لِلٛيْطٛيَمْ؞ نغَمْ لٜسْتِنْطٛ حٛورٜ مُوطُمْ فُو ندٜرْ مٛوطٛنْ، کَنُمْ وٛنِ مَوْطٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","يَحَيَ نٛوتِي، وِعِ، ‏«‏مٛودِبّٛ، مِنْ نغِعِي غٛطّٛ اٜ وُرْتِنَ غِنِّ ندٜرْ اِنْدٜ مَاطَ، مِنْ کَطِمٛ نغَمْ کَنْکٛ نَاع اٛ تٛکُّطٛعٜنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","اَمَّا يٜىٰسُ وِعِمٛ، ‏«‏تٛع اٛنْ کَطُمٛ، نغَمْ فُو مٛ وَݧَايِعٛنْ اٜ وٛنْدِ اٜ مٛوطٛنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","ندٜ شَرٜلْ ٻَدِي نغَمْ طُمْ حٛشَّمٛ يَاکِ دٛوْ، يٜىٰسُ اٜ حٛورٜ مُوطُمْ سُٻِ يَحُکِ اُرُشَلِيمَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","سٜيْ اٛ لِلِ لِلَاٻٜ يٜىٰسٛ مَاکٛ، ٻٜ نجَحَ ندٜرْ غَرِيٜلْ سَمَارِيَنْکٛعٜنْ نغَمْ ٻٜ شِرْيٛو کٛو طُمٜ نغَمْ غَرٛلْ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","اَمَّا يِمْٻٜ غَرِيٜلْ نغٜلْ نجَٻَايِمٛ نغَمْ ٻٜ کٜٻْتِي اُرُشَلِيمَ اٛ فَعِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","ندٜ تٛکُّٻٜمٛ يَاکُبُ اٜ يَحَيَ نغِعِ نٛنْ، ٻٜ مبِعِ، ‏«‏مٛودِبّٛ، اَ يِطِ مِنْ نٛدَّ حِيتٜ دَغَ دٛوْ وَرَ حَلْکَٻٜ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","اَمَّا يٜىٰسُ وَيْلِتِي حَٻَنِٻٜ، ");
INSERT INTO fuv_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","سٜيْ ٻٜ نجَحِ وٛنْغٜلْ غَرِيٜلْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","اٜ ٻٜ ندٜرْ يَادُ دٛوْ طَتَلْ، سٜيْ غٛطّٛ وِعِمٛ، ‏«‏مِ تٛکّٜتٜ تٛ نجَحَتَا فُو؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","يٜىٰسُ وِعِمٛ، ‏«‏دِلَاجِ اٜ نغٛودِ غَيْطٜ، شٛلِّ اٜ نغٛودِ شَٻّٜ، اَمَّا ٻِي نٜطّٛ وَلَا تٛ فُکّٛتٛو؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","اٛ وِعِ غٛطّٛ نٜطّٛ، ‏«‏تٛکَّمْ؞»‏ اَمَّا نٜطّٛ اٛنْ وِعِمٛ، ‏«‏مٛودِبّٛ، اَلْ مِ يَحَ، مِ اُوٛيَ ݧَاکٛ اَمْ تَوْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","اَمَّا يٜىٰسُ وِعِمٛ، ‏«‏اَلُ مَيْٻٜ اُوَ مَيْٻٜ مُعّٜنْ، اَمَّا اَنْ، يَحُ، نغَعَجِنَا لَامُ اَللَّه؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","غٛطّٛ کَدِمَا وِعِ، ‏«‏مِ تٛکّٜتٜ، مٛودِبّٛ، اَمَّا اَلْ مِ يَحَ مِ پَمَ ٻٜ وُرٛ اَمْ تَوْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","اَمَّا يٜىٰسُ وِعِمٛ، ‏«‏کٛو مٛيٜ جٛغِيطٛ رٜمٜرْغٛ فُطِّ رٜمُکِ اٜ يٜىٰپٛو غَطَ، وَلَا کٛ نَفِ ندٜرْ کُوغَلْ اَللَّه؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","غَطَ مَاجُمْ يٜىٰسُ سُٻِ وٛٻّٜ کَمْٻٜ 27، ندٜنْ اٛ لِلِٻٜ طِطٛ‑طِطٛ، ٻٜ اَرْتَمٛ يَاکِ کٛو ندِيٜ غَرِيرِ اٜ وِغٜىٰرٜ تٛ اٛ يِطِ يَحُکِ فُو؞ ");
INSERT INTO fuv_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","اٛ وِعِٻٜ، ‏«‏غٜسٜ ٻٜنْدُطٜ اٜ طُوطِ، اَمَّا حُوٛوٻٜ طُوطَا؞ تٛرٜىٰ جٛومُ غٜسٜ طٜنْ لِلٛيَ حُوٛوٻٜ ندٜرْ غٜسٜ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","نجَحٜىٰ؞ مِ لِلِيعٛنْ تٛ يِمْٻٜ بٛنٛ مبَالٛيْ حَکُّندٜ شَافَالِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","تٛع اٛنْ نجَادُ اٜ جَکَارٜ شٜىٰدٜ کٛو جَکَارٜ لِمْشٜ، کٛو ڤَطٜ، ندٜنْ تٛع اٛنْ کٛوْنُ غٛطّٛ کٛوْنٛلْ جُوتُنغٛلْ دٛوْ طَتَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","وُرٛ نغٛ نَتُّطٛنْ فُو، ڤُطّٜىٰ وِعُکِ، ‏‹‏اَللَّه حٛکَّ وُرٛ نغٛعٛ جَمْ!‏›‏ ");
INSERT INTO fuv_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","تٛ اٜ وٛودِ نٜطّٛ غِطّٛ جَمْ ندٜرْ وُرٛ نغٛنْ، بَرْکَ مٛوطٛنْ جٛوطٛتٛ دٛوْ مَاکٛ، اَمَّا تٛ وَلَا، طُمْ وَرْتَيْ تٛ مٛوطٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","نجٛوطٜىٰ ندٜرْ وُرٛ نغٛ طُمْ جَٻِّيعٛنْ، ݧَامٜىٰ، نجَرٜىٰ کٛو طُمٜ کٛ ٻٜ کٛکِّعٛنْ، نغَمْ کُوٛووٛ اٜ حَانِ يٛٻٜىٰکِ؞ تٛع اٛنْ کَکِّتٛ دَغَ وُرٛ يَاکِ وُرٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","فُو غَرِيرِ ندِ نَتُّطٛنْ، تٛ يِمْٻٜ مَيْرِ نجَٻَّکٜعٛنْ، ݧَامٜىٰ کٛ طُمْ رٜسِ يٜىٰسٛ مٛوطٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","نجَمْطِنٜىٰ ݧَوْٻٜ وٛنْٻٜ ندٜرْ غَرِيرِ ندِنْ، ندٜنْ مبِعٛنْٻٜ، ‏‹‏لَامُ اَللَّه وَرِي حَادٜ مٛوطٛنْ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","اَمَّا، غَرِيرِ ندِ نَتُّطٛنْ فُو، تٛ ٻٜ نجَٻَّاکِعٛنْ، مبُرْتٜىٰ نجَحٛنْ دٛوْ طَتٜ مَيْرِ مبِعٛنْ، ");
INSERT INTO fuv_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‏‹‏مِنْ ڤِطِّي سٛلَّارٜ غَرِيرِ مٛوطٛنْ دَغَ کٛيْطٜ اَمِنْ، کَنْجُمْ طُمْ حٜٻْتِرْتَ اٛنْ نغَطِي حَکّٜ؞ اَمَّا اَنْدٜىٰ طُعُمْ، لَامُ اَللَّه وَرِي حَادٜ مٛوطٛنْ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","اٜ مِ وِعَعٛنْ، اٜ ݧَلْندٜ جَانغٛ اَللَّه ٻُرَيْ يُرْمِنَنْکِ يِمْٻٜ غَرِيرِ سٛدٛمْ دٛوْ يِمْٻٜ غَرِيرِ ندِنْ طٛنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","اٛ وِعِ، ‏«‏يِمْٻٜ غَرِيرِ کٛرَسِنْ، اٛنْ مبٛنِي!‏ يِمْٻٜ غَرِيرِ بٜتَسَيْدَ، اٛنْ مبٛنِي!‏ دَا کُوطٜ کَيْطِنِيطٜ غَطَاطٜ ندٜرْ مٛوطٛنْ طٜ نغَطَنَامَ يِمْٻٜ تَايَ اٜ سِدٛنْ، دَا ٻٜ ٻٛرْنَکٜ کٛلْتٜ کٛلَّيْطٜ وَنَّارٜ ٻٜ نجٛوطَکٜ ندٜرْ تٛوکَ نغَمْ حٛلُّکِ ٻٜ تُوبِي؞ ");
INSERT INTO fuv_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","اَمَّا ݧَلْندٜ جَانغٛ اَللَّه ٻُرَيْ يُرْمِنَنْکِ يِمْٻٜ تَايَ اٜ سِدٛنْ دٛوْ مٛوطٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","اٛنٛنْ بٛو، يِمْٻٜ غَرِيرِ کَفَرْنَحُمْ، اٛنْ کَمِّي طُمْ حٛشَّيْعٛنْ يَاکِ دٛوْ؟ نَاع نٛنْ!‏ طُمْ نَتِّنَيْعٛنْ ندٜرْ نغَيْکَ حِيتٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","ندٜنْ يٜىٰسُ وِعِ تٛکُّٻٜمٛ، ‏«‏جَٻُطٛ کٛ مبِيطٛنْ فُو جَٻِي کٛ مبِيمِ، غَݧُطٛعٛنْ بٛو وَݧِييَمْ، ندٜنْ غَݧُطٛيَمْ وَݧِي اٛنْ طٛنْ لِلٛيْطٛيَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","سٜيْ تٛکُّٻٜمٛ 27 نغَرْتِ اٜ نَنَ بٜلْطُمْ، ٻٜ مبِعِ، ‏«‏مٛودِبّٛ، حَا غِنِّ مَا نغَطِي کٛ مِنْ مبِعِطِ فُو ندٜرْ اِنْدٜ مَاطَ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","اٛ وِعِٻٜ، ‏«‏مِ يِعِي شٜيْطَنْ يَنٛيِي بٛ مَپّٜرٜ دَغَ دٛوْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","رَا، مِ حٛکِّيعٛنْ لَامُ يَاٻُکِ دٛوْ بٛولٜ اٜ جَحٜ اٜ حٜٻُکِ جَالٛرْغَلْ دٛوْ بَوْطٜ غَݧٛ، وَلَا کٛ حٜٻَتَعٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","اَمَّا تٛع اٛنْ نَنُ بٜلْطُمْ نغَمْ غِنِّ اٜ نغَطَ کٛ مبِيطٛنْ، اَمَّا نَنٜىٰ بٜلْطُمْ نغَمْ اِنْطٜ مٛوطٛنْ مبِنْدَامَ اٜ وُرٛ اَللَّه؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","اٜ شَرٜلْ نغٜلْ، يٜىٰسُ نَنِ بٜلْطُمْ ندٜرْ رُوحُ اَللَّه، اٛ وِعِ، ‏«‏مِ يٜتِّيمَ، ݧَاکٛ اَمْ مٛ دٛوْ، جٛومِرَاوٛ دٛوْ اٜ لٜيْ، نغَمْ اَ سُوطِي فِي طُعُمْ تٛ غٛودُٻٜ فَامُ اٜ اَنْدَلْ، اَ حٛلِّيطُمْ ٻِکّٛيْ ڤَمَرٛيْ؞ نٛنْ ݧَاکٛ اَمْ، نغَمْ نٛنْ وٜلَنْمَا نغَطَا؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","سٜيْ اٛ وِعِ يِمْٻٜ، ‏«‏ݧَاکٛ اَمْ حٛکِّييَمْ کٛو طُمٜ؞ وَلَا اَنْدُطٛ مٛيٜ وٛنِ ٻِطّٛ اٛنْ سٜيْ نِ ݧَاکٛ اٛنْ، نٛنْ مَا وَلَا اَنْدُطٛ مٛيٜ وٛنِ ݧَاکٛ اٛنْ سٜيْ نِ ٻِطّٛ اٛنْ، اٜ مٛ ٻِطّٛ اٛنْ يِطِ اَنْدِنَ ݧَاکٛ اٛنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","سٜيْ اٛ وَيْلِتِي تٛ تٛکُّٻٜمٛ اٛ وِعِٻٜ کَمْٻٜ تَنْ، ‏«‏غِتٜ غِعُطٜ کٛ نغِيطٛنْ طٜ بَرْکِطِنَاطٜ!‏ ");
INSERT INTO fuv_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","نغَمْ اٜ مِ وِعَعٛنْ، اَنَّبٛعٜنْ طُطْٻٜ اٜ لَامِنٛوٻٜ طُطْٻٜ نغِطِي نغِعَ کٛ نغِيطٛنْ، اَمَّا ٻٜ نغِعَايِ؞ ٻٜ نغِطِي نَنُکِ کٛ نَنٛتٛنْ، اَمَّا ٻٜ نَنَايِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","سٜيْ غٛطّٛ مٛودِبّٛ دٛوکَ اُمِّي دَرِي نغَمْ فٛوندَ يٜىٰسُ، اٛ وِعِ، ‏«‏مٛودِبّٛ، کٛ حَانِ مِ وَطَ نغَمْ مِ حٜٻَ يٛنْکِ کِ رٜعَتَا؟»‏ ");
INSERT INTO fuv_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","سٜيْ يٜىٰسُ وِعِمٛ، ‏«‏کٛ وِنْدَا ندٜرْ اَتَّوْرَ؟ نٛيٜ نجَنْغِرْتَا؟»‏ ");
INSERT INTO fuv_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","اٛ نٛوتِي، اٛ وِعِ، ‏«‏ ‏‹‏يِطُ جٛومِرَاوٛ اَللَّه مَاطَ اٜ ٻٜرْندٜ مَاطَ فُو، اٜ يٛنْکِ مَاطَ فُو، اٜ سٜمْبٜ مَاطَ فُو، اٜ حَکِّيلٛ مَاطَ فُو،›‏ ندٜنْ، ‏‹‏يِطُ بَنْدِرَاوٛ مَاطَ نٛ نغِطِرْطَا حٛورٜ مَاطَ؞›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","يٜىٰسُ وِعِمٛ، ‏«‏اَ نٛوتَکٜ بٛطُّمْ؞ وَطُ نٛنْ، ندٜنْ اَ حٜٻَيْ يٛنْکِ کِ رٜعَتَا؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","اَمَّا مٛودِبّٛ دٛوکَ اٛنْ يِطِي وُرْتِنَ حٛورٜ مُوطُمْ، سٜيْ اٛ پَمِ يٜىٰسُ، اٛ وِعِ، ‏«‏مٛيٜ وٛنِ بَنْدِرَاوٛ اَمْ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","يٜىٰسُ وِعِمٛ، ‏«‏غٛطّٛ نٜطّٛ اٜ يَحَ دَغَ اُرُشَلِيمَ يَاکِ جٜرِيکٛ، سٜيْ وٛٻّٜ وُيْٻٜ تَٻِّيمٛ؞ ٻٜ ٻٛرْتِمٛ، ٻٜ نجَٻِ کٛ اٛ وٛودِ فُو، ٻٜ ڤِيِمٛ بٛطُّمْ، ٻٜ ندِلِّ، ٻٜ اَلِمٛ حَکُّندٜ يٛنْکِ اٜ مَيْدٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","سٜيْ اَرْدِيطٛ دِينَ تٛکّٛيِ طَتَلْ نغَلْ؞ ندٜ اٛ يِعِ نٜطّٛ اٛنْ، اٛ سٜلِ، اٛ پَٻِّي؞ ");
INSERT INTO fuv_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","کَدِمَا، غٛطّٛ لٜىٰوِيَنْکٜىٰجٛ تٛکّٛيِ طَتَلْ نغَلْ، ندٜ اٛ وَرٛيِ تٛ نٜطّٛ اٛنْ وٛنِ، اٛ يِعِمٛ، اٛ سٜلِ، اٛ پَٻِّي؞ ");
INSERT INTO fuv_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","اَمَّا غٛطّٛ سَمَارِيَنْکٜىٰجٛ اٜ ندٜرْ يَادُ اٛ وَرٛيِ تٛ نٜطّٛ اٛنْ وٛنِ، اٛ يِعِمٛ، اٛ يُرْمِنَنِمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","اٛ يَحِ تٛ مَاکٛ، اٛ لٛوتَنِمٛ نَوْنٛوطٜ اٜ نٜبَّمْ اٜ ندِيَمْ اِنَبٛجَمْ، اٛ حَٻَّنِمٛ نَوْنٛوطٜ طٜنْ؞ ندٜنْ اٛ وَطِّنِمٛ دٛوْ مبَبَّ مَاکٛ اٛ يَارِمٛ وُرٛ تٛ طُمْ يٛٻَتَ طُمْ وَالَ، اٛ وَلِّمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","ندٜ وٜىٰتِ، سَمَارِيَنْکٜىٰجٛ اٛنْ اِتِّ شٜىٰدٜ اَجُرْفَارِ طِطِ دَغَ جِيبَ مُوطُمْ، حٛکِّ مَوْطٛ وُرٛ اٛنْ وِعِمٛ، ‏‹‏وَلُّمٛ؞ تَا مَجِّنِي شٜىٰدٜ کٛ ٻُرِ طٜعٜ، مِ يٛٻٜتٜ تٛ مِ سٛعّٛيَکٜ؞›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","سٜيْ يٜىٰسُ پَمِ مٛودِبّٛ دٛوکَ اٛنْ وِعِ، ‏«‏مٛيٜ ندٜرْ يِمْٻٜ تَتٛ ٻٜعٜ کَمِّطَا وٛنِ بَنْدِرَاوٛ مٛ وُيْٻٜ ڤِيِ اٛنْ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","اٛ وِعِ، ‏«‏اٛنْ طٛنْ جُرْمِنَنْطٛمٛ؞»‏ سٜيْ يٜىٰسُ وِعِمٛ، ‏«‏اَنْ مَا، يَحُ نغَطَا نٛنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","يٜىٰسُ اٜ تٛکُّٻٜمٛ اٜ ندٜرْ يَادُ، سٜيْ اٛ نَتِّ وٛنْغٜلْ غَرِيٜلْ، غٛطّٛ دٜبّٛ بِعٜتٜىٰطٛ مَرْتَ جَٻِّيمٛ تٛ وُرٛ مُوطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","مَرْتَ اٛنْ اٜ وٛودِ مِݧِرَاوٛ بِعٜتٜىٰطٛ مَرْيَامَ؞ مَرْيَامَ جٛوطِي حَادٜ يٜىٰسُ اٜ مٛ نَنَ اٜکِّتِنٛلْ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","اَمَّا مَرْتَ وَنِّي نغَمْ اٜ حُوَ کُوطٜ طُطّٜ؞ سٜيْ اٛ وَرِ تٛ يٜىٰسُ، اٛ وِعِ، ‏«‏مٛودِبّٛ، اَ وَنَّايِ ندٜ مِݧِرَاوٛ اَمْ اَلْدِيَمْ اٜ کُوغَلْ نغَعَلْ مِنْ تَنْ؟ وِعُمٛ اٛ اُمّٛو اٛ وَلَّيَمْ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","اَمَّا يٜىٰسُ نٛوتِي، وِعِ، ‏«‏مَرْتَ، مَرْتَ، اَ وَنِّي حٛورٜ مَاطَ دٛوْ فِي طُطُّمْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","اَمَّا فِي غٛعٛ تَنْ يِطَا؞ مَرْيَامَ بٛو سُٻِي کٛ ٻُرِ وٛوطُکِ، طُمْ جَٻْتَتَاکٜ تٛ مَاکٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","وٛنْدٜ ݧَلْندٜ يٜىٰسُ اٜ وَطَ دٛعَارٜ تٛ وٛنْدٜ وِغٜىٰرٜ؞ ندٜ اٛ حٜىٰݧِ دٛعَارٜ ندٜنْ، غٛعٛتٛ ندٜرْ تٛکُّٻٜمٛ وِعِمٛ، ‏«‏مٛودِبّٛ، اٜکِّتِنْمِنْ نٛ مِنْ نغَطِرْتَ دٛعَارٜ، نٛنْ نٛ يَحَيَ غَطٛووٛ بَڤْتِسْمَ اٜکِّتِنِرِ تٛکُّٻٜمٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","يٜىٰسُ وِعِٻٜ، ‏«‏تٛ اٛنْ نغَطَيْ دٛعَارٜ، مبِعٜىٰ، ‏‹‏يَا اَللَّه ݧَاکٛ اَمِنْ مٛ دٛوْ، اِنْدٜ مَاطَ شٜنِيندٜ مَوْنِنٜىٰ، لَامُ مَاطَ وَرَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","حٛکُّمِنْ کٛ مِنْ ݧَامَتَ کٛو ندٜيٜ ݧَلْندٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","يَافَنَمِنْ حَکّٜىٰجِ اَمِنْ، نغَمْ مِنٛنْ مَا اٜ مِنْ نجَافَنٛو کٛو مٛيٜ غَطَنْطٛمِنْ حَکّٜ؞ تَاع اَلُ مِنْ نجَحَ تٛ مِنْ نغَطَتَ حَکّٜ؞›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","ندٜنْ اٛ حٛکِّٻٜ مِسَالُ، اٛ وِعِ، ‏«‏تٛ غٛعٛتٛ ندٜرْ مٛوطٛنْ يَحِي تٛ حِغٛ مُوطُمْ شَکَ جٜمَّ وِعِمٛ، ‏‹‏حِغٛ، وُپَمْ مبُرٛودِحٛ تَتٛ، ");
INSERT INTO fuv_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","نغَمْ حِغٛ اَمْ اٜ دٛوْ يَادُ يَالٛيِي وَالَ اٜ وُرٛ اَمْ، رَا بٛو مِ وَلَا کٛ کٛکَّيْمٛمِ اٛ ݧَامَ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","سٜيْ اٛ نٛوتِي دَغَ ندٜرْ سُودُ، اٛ وِعِ، ‏‹‏تَاع وَنَّمْ، نغَمْ طُمْ يَادَکٜ طُمْ مَٻِّي دَمُّغَلْ، ندٜنْ مِنْ اٜ ٻِٻّٜ اَمْ مِنْ نجَادَکٜ مِنْ ڤُکَّکٜ؞ مِ وَاوَتَا اُمَّاکِ جٛونِ مِ حٛکُّمَا غٛطُّمْ؞›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","يٜىٰسُ وِعِ، ‏«‏اٜ مِ وِعَعٛنْ، تٛ اٛ سَلَکٜ اُمَّاکِ اٛ حٛکَّمٛ بُرٛودِ طُمْ نغَمْ حِغَاکُ، اٛ اُمّٛتٛ اٛ حٛکَّمٛطُمْ نغَمْ اٛ وَطِي کَ تٛرَاکِمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","نغَمْ نٛنْ اٜ مِ وِعَعٛنْ، تٛرٜىٰ، طُمْ حٛکَّيْعٛنْ؞ طَٻِّتٜىٰ، اٛنْ کٜٻَيْ؞ شِلْمِنٜىٰ، طُمْ مَٻِّتَنَيْعٛنْ دَمُّغَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","نغَمْ کٛو مٛيٜ تٛرِيطٛ طُمْ حٛکَّيْمٛ، طَٻُّتُطٛ بٛو حٜٻَيْ، ندٜنْ کٛو مٛيٜ شِلْمِنِيطٛ طُمْ مَٻِّتَنَيْمٛ دَمُّغَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","مٛيٜ ندٜرْ مٛوطٛنْ تٛ ٻِطّٛ مُوطُمْ تٛرَکٜمٛ لِنْغُ، اٛ حٛکَّمٛ مبٛودِ؟ ");
INSERT INTO fuv_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","کٛو بٛو تٛ اٛ تٛرَکٜمٛ ٻٛشّٛوندٜ، اٛ حٛکَّمٛ يَارٜ؟ ");
INSERT INTO fuv_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","تٛ اٛنٛنْ کَلُّٻٜ، اٛنْ اَنْدِ نٛ کٛکِّرْتٛنْ ٻِٻّٜ مٛوطٛنْ فِي بٛطُّمْ، حَکّٛ ݧَاکٛ مٛوطٛنْ مٛ دٛوْ!‏ اٛ ٻُرَيْ نٛنْ حٛکُّکِ تٛرِيٻٜمٛ رُوحُ اَللَّه؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","وٛنْدٜ ݧَلْندٜ يٜىٰسُ اٜ وُرْتِنَنَ غٛطّٛ غِنّٛلْ ڤَحٛلْ؞ غَطَ غِنّٛلْ نغٛلْ وُرْتَکٜ، نٜطّٛ اٛنْ فُطِّ مٜتُکِ، سٜيْ يِمْٻٜ طُطْٻٜ کَوْرُتُٻٜ کَيْطِنِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","اَمَّا وٛٻّٜ مَٻّٜ مبِعِ، ‏«‏اٜ بَوْطٜ بَعَلْجَبُلْ لَامِيطٛ غِنِّ اٛ وُرْتِنِرْتَ غِنِّ»‏ ");
INSERT INTO fuv_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","وٛٻّٜ اٜ نغِطِ فٛوندُکِمٛ، نغَمْ نٛنْ ٻٜ مبِعِمٛ اٛ وَطَنَٻٜ غٛطُّمْ کَيْطِنِيطُمْ پِوٛيْطُمْ تٛ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","اَمَّا يٜىٰسُ اٜ اَنْدِ کٛ وٛنِ ندٜرْ ٻٜرْطٜ مَٻّٜ، اٛ وِعِٻٜ، ‏«‏لَامُ فُو شٜنْدِيطُمْ اٜ وَݧْوَݧْتِرَ، طُمْ لَلَّيْ؞ نٛنْ مَا وُرٛ شٜنْدِينغٛ اٜ وَݧْوَݧْتِرَ، نغٛ لَلَّيْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","تٛ لَامُ شٜيْطَنْ سٜنْدَکٜ اٜ وَݧْوَݧْتِرَ، نٛيٜ لَامُ طُمْ دَرٛرْتٛو؟ مِ وِعُ نٛنْ نغَمْ اٛنْ مبِعَ اٜ مِ وُرْتِنَ غِنِّ اٜ سٜمْبٜ بَعَلْجَبُلْ لَامِيطٛ غِنِّ؞ ");
INSERT INTO fuv_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","تٛ اٜ مِ وُرْتِنَ غِنِّ ندٜر بَوْطٜ بَعَلْجَبُلْ، اٜ بَوْطٜ مٛيٜ تٛکُّٻٜعٛنْ مبُرْتِنِرْتَطِ؟ نغَمْ نٛنْ تٛکُّٻٜعٛنْ کٛلَّيْ اٛنْ نغَلَا غٛونغَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","اَمَّا، تٛ اٜ مِ وُرْتِنَ غِنِّ ندٜرْ بَوْطٜ اَللَّه، ندٜنْ لَامُ اَللَّه وَرَنِيعٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","‏«‏تٛ نٜطّٛ شٜمْبِطّٛ جٛغَکٜ کَافَحِ رٜىٰنِي وُرٛ مُوطُمْ، وَلَا کٛ حٜٻَتَ کٛ اٛ وٛودِ فُو؞ ");
INSERT INTO fuv_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","اَمَّا، تٛ غٛطّٛ ٻُرْطٛمٛ سٜمْبٜ وَرَنِيمٛ تٜىٰتَيْ کَافَحِ کِ اٛ مَنْتٛرْتٛو کِنْ، ٻُرْطٛ مٛ سٜمْبٜ اٛنْ سٜنْدَنَيْ وٛٻّٜ جَوْدِ ندِنْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","‏«‏مٛ وٛنْدَا اٜ اَمْ فُو، اٛ غَݧٛ اَمْ؞ مٛ وَلَّايِيَمْ مٛٻْتُکِ فُو، اٛ شَنْکِتٛووٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","‏«‏تٛ غِنّٛلْ وُرْتَکٜ ندٜرْ ٻَنْدُ نٜطّٛ، نغٛلْ يَحَيْ تٛ بِغٜىٰجٜ جٛرْطٜ اٜ نغٛلْ طَٻِّتَ تٛ نغٛلْ سِوْتٛتٛو؞ اَمَّا تٛ نغٛلْ حٜٻَايِ، سٜيْ نغٛلْ وِعَ، ‏‹‏مِ سٛعّٛتٛ وُرٛ نغٛ مبُرْتٛيِيمِ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","تٛ نغٛلْ وَرْتِي، نغٛلْ تَوِي وُرٛ نغٛنْ وُووَامَ نغٛ مٛعِّنَامَ، ");
INSERT INTO fuv_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","سٜيْ نغٛلْ يَحَ نغٛلْ وَدّٛيَ غِنِّ جٛوٜىٰطِطِ ٻُرْطِنغٛلْ حَلُّکِ، طِ نَتَّ طِ نجٛوطٛو طٛنْ؞ ندٜنْ رٜعِرْدٜ نٜطّٛ اٛنْ ٻُرَيْ فُطّٛودٜ مَاکٛ حَلُّکِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","ندٜ يٜىٰسُ وِعِ نٛنْ، غٛطّٛ دٜبّٛ ندٜرْ حَوْرُتُٻٜ نٛدِّ سٜمْبٜىٰ وِعِ، ‏«‏دٜبّٛ دَݧُطٛمَ کٛکُّطٛمَ مُسِنْطَا، اٛ بَرْکِطِنَاطٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","اَمَّا يٜىٰسُ وِعِمٛ، ‏«‏نٛنْ، اَمَّا ٻُرْٻٜ بَرْکِطِنٜىٰکِ نغٛنِ نَنٛوٻٜ وٛلْدٜ اَللَّه اٜ تٛکَّندٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","ندٜ يِمْٻٜ نغَطِ کَ مٛٻْتَاکِ تٛ يٜىٰسُ، اٛ وِعِٻٜ، ‏«‏يِمْٻٜ جَامَنُ طُعُمْ ٻٜ کَلُّٻٜ، اٜ ٻٜ نغِطِ حٛلّٜىٰکِ غٛطُّمْ کَيْطِنِيطُمْ، اَمَّا وَلَا کٛ طُمْ حٛلَّتَٻٜ سٜيْ نِ کٛ حٜٻُنٛو اَنَّبِ اِنُوسَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","کٛ حٜٻِ اَنَّبِ اِنُوسَ حٛلِّي يِمْٻٜ نِينٜبَ اَللَّه لِلٛيِمٛ، نٛنْ مَا کٛ حٜٻَتَيَمْ، مِنْ ٻِي نٜطّٛ، طُمْ حٛلَّيْ يِمْٻٜ جَامَنُ طُعُمْ اَللَّه لِلٛيِيَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","ݧَلْندٜ جَانغٛ، لَامِيطٛ لٜيْدِ فٛمْبِنَ دٜبّٛ اٛ اُمّٛدٛتٛ اٜ يِمْٻٜ جَامَنُ طُعُمْ؞ اٛ حٛلَّ کٛ يِمْٻٜ جَامَنُ طُعُمْ نغَطِ طُمْ وٛوطَا، نغَمْ کَنْکٛ اٛ وَرٛيِي دَغَ ٻَدَاکِ نَنُکِ فَامُ اَنَّبِ سُلٜيْمَانُ؞ رَا بٛو، ٻُرْطٛ اَنَّبِ سُلٜيْمَانُ طٛعٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","اٜ ݧَلْندٜ جَانغٛ يِمْٻٜ نِينٜبَ مَا ٻٜ اُمّٛدٛتٛ اٜ يِمْٻٜ جَامَنُ طُعُمْ، ٻٜ کٛلَّ کٛ يِمْٻٜ جَامَنُ طُعُمْ نغَطِ طُمْ وٛوطَا، نغَمْ کَمْٻٜ ندٜ ٻٜ نَنِ وَعَجُ اَنَّبِ اِنُوسَ ٻٜ تُوبِي، رَا بٛو ٻُرْطٛ اَنَّبِ اِنُوسَ طٛعٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","‏«‏وَلَا غَطَنَيْطٛ فِتِلَارُ حِيتٜ سُوطَندُ کٛو حِڤَّ تُمُّدٜ دٛوْ مَيْرُ؞ سٜيْ نِ اٛ رٜسَندُ دٛوْ دَنْکِ نغَمْ ندُ يٜيْنَنٛو نَتُّطٛ فُو؞ ");
INSERT INTO fuv_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","غِتٜ مَاطَ نغٛنِ فِتِلَارُ ٻَنْدُ مَاطَ؞ تٛ غِتٜ مَاطَ اٜ نجَمْطِ، ٻَنْدُ مَاطَ فُو حٜىٰوَيْ جَيْنغٛلْ، اَمَّا تٛ غِتٜ مَاطَ نجَمْطَا فُو، ٻَنْدُ مَاطَ حٜىٰوَيْ ݧِوْرٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","فَامُ بٛطُّمْ کٛو جَيْنغٛلْ غٛنْغٛلْ ندٜرْ مَاطَ طُمْ ݧِوْرٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","تٛ ٻَنْدُ مَاطَ فُو اٜ حٜىٰوِ جَيْنغٛلْ، تٛ ندُ وَلَا ݧِوْرٜ کٛو سٜطَّ، ندُ يٜيْنٛتٛ کٛو تٛيٜ نٛ جَيْنغٛلْ فِتِلَارُ يٜيْنٛرَنْتٛمَا؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","يٜىٰسُ اٜ ندٜرْ مٜتُکِ سٜيْ غٛطّٛ فَارِسَنْکٜىٰجٛ وِعِمٛ اٛ يَحَ وُرٛ مُوطُمْ اٛ حِرْتٛيٛو؞ يٜىٰسُ يَحِ جٛوطِي فُطِّ ݧَامُکِ ݧَمْندُ؞ ");
INSERT INTO fuv_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","فَارِسَنْکٜىٰجٛ اٛنْ حَيْطِنِ ندٜ يِعِ يٜىٰسُ فُطِّي ݧَامُکِ ݧَمْندُ لٛوتَايِ جُوطٜ مُوطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","سٜيْ يٜىٰسُ وِعِمٛ، ‏«‏اٛنٛنْ فَارِسَنْکٛعٜنْ اٛنْ لَيْٻَ غَطَ نجَرْدُکٛيْ مٛوطٛنْ اٜ لٜعٛيْ مٛوطٛنْ، اَمَّا ندٜرْ مٛوطٛنْ اٛنْ کٜىٰوُٻٜ نغُيْکَ اٜ حَلّٜىٰندٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","اٛنٛنْ حَاݝَاٻٜ!‏ کٛو مٛيٜ اٜ اَنْدِ غَطُطٛ يَاسِ کَنْکٛ وَطِ ندٜرْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","نغَمْ نٛنْ کٛکّٜىٰ ٻٜ نغَلَنَا کٛ وٛنِ ندٜرْ جَرْدُطٜ اٜ لٜعٛيْ مٛوطٛنْ، ندٜنْ طٜ فُو طٜ لَاٻَنَيْعٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","‏«‏اٛنْ مبٛنِي، اٛنٛنْ فَارِسَنْکٛعٜنْ، نغَمْ اٛنْ کٛکِّي اَللَّه جَکَّ حَاکٛحٛيْ نجٛنْغٜتٜىٰکٛيْ، اَمَّا اٛنْ نغَطَنْتَا يِمْٻٜ کٛ حَانِ، اٛنْ نغَلَا يِدّٜ اَللَّه؞ طُعُمْ تَتُمْ اٜ حَانِ نغَطٛنْطُمْ، اَمَّا تٛع اٛنْ اَلُ وَطُکِ کٛ حٛرِي؞ ");
INSERT INTO fuv_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","‏«‏اٛنْ مبٛنِي، اٛنٛنْ فَارِسَنْکٛعٜنْ، نغَمْ اٛنْ نغِطِ جٛوطَاکِ دٛوْ جٛوطٛرْلٜ مَوْٻٜ ندٜرْ شُوطِ دٛعَارٜ، اٛنْ نغِطِ حٛوْنِرٜىٰکِ مَنْغُ ندٜرْ لُومٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","اٛنْ مبٛنِي!‏ اٛنْ نَنْدِ اٜ غٜنَالٜ طٜ نغِعَتَاکٜ، يِمْٻٜ اٜ تٛکَّ دٛوْ مَاجٜ اَنْدَا؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","غٛعٛتٛ ندٜرْ مٛودِٻّٜ اَتَّوْرَ وِعِ يٜىٰسُ، ‏«‏مٛودِبّٛ، ندٜ مبِيطَا نٛنْ، مِنٛنْ مَا اَ حُطِيمِنْ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","يٜىٰسُ وِعِ، ‏«‏اٛنْ مبٛنِي، اٛنٛنْ مَا مٛودِٻّٜ اَتَّوْرَ، نغَمْ اٛنْ نجٛوَنَ يِمْٻٜ دٛݝْلٜ تٜدُّطٜ، اَمَّا اٛنٛنْ کٛو کٛولٜلْ غٛعٛ اٛنْ نغَطَتَا مبَلّٛنْٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","اٛنْ مبٛنِي!‏ نغَمْ اٛنْ مَحَ غٜنَالٜ بٛطّٜ طٜ سِفْتٛرْکِ اَنَّبٛعٜنْ ٻٜ مَامَاجِ مٛوطٛنْ مبَرِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","نٛنْ حٛلِّي کٛ مَامَعٜنْ مٛوطٛنْ نغَطِ وٜلِيعٛنْ، نغَمْ ٻٜ مبَرِي اَنَّبٛعٜنْ، اٛنٛنْ بٛو اٛنْ مَحَنِ اَنَّبٛعٜنْ ٻٜنْ غٜنَالٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","کَنْجُمْ وَطِ اَللَّه وِعِ ندٜرْ اَنْدَلْ مُوطُمْ، ‏‹‏مِ لِلَنَيْٻٜ اَنَّبٛعٜنْ اٜ لِلَاٻٜ، ٻٜ مبَرَ وٛٻّٜ ٻٜ تٛرَّ وٛٻّٜ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","نغَمْ نٛنْ پِيپَمْ اَنَّبٛعٜنْ ندُفَاطَمْ دَغَ فُطّٛودٜ دُونِيَارُ، طُمْ طَٻِّتَيْطَمْ تٛ جُوطٜ يِمْٻٜ جَامَنُ طُعُمْ، ");
INSERT INTO fuv_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","دَغَ پِيپَمْ حَبِيلَ حَا يَاکِ پِيپَمْ اَنَّبِ جَکَارِيَ بَرَاطٛ حَکُّندٜ سُودُ جٛومِرَاوٛ اٜ سَکِّرْدٜ؞ اٜ مِ وِعَعٛنْ غٛونغَ، پِيپَمْجِ طِنْ طٛنْ فُو طُمْ طَٻِّتَيْطِ تٛ جُوطٜ يِمْٻٜ جَامَنُ طُعُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","‏«‏اٛنْ مبٛنِي، اٛنٛنْ مٛودِٻّٜ اَتَّوْرَ، نغَمْ اٛنْ نجٛغَکٜ مَٻِّتِرْغٜلْ دَمُّغَلْ اَنْدَلْ، اٛنٛنْ اٛنْ نَتَّايِ، اٛنْ اَلَايِ وٛٻّٜ نَتِّ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","ندٜ يٜىٰسُ اَلِ طٛنْ، مٛودِٻّٜ اَتَّوْرَ اٜ فَارِسَنْکٛعٜنْ ٻٜرْطٜ مَٻّٜ مٜتِّ دٛوْ مَاکٛ، ٻٜ نغَطِ کَ پَمُکِمٛ پَمْطٜ دٛوْ فِي طُطُّمْ، ");
INSERT INTO fuv_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","نغَمْ ٻٜ نَنَ اٛ وِعِي غٛطُّمْ کٛ حَانَا، ٻٜ کٜٻَ کٛ ٻٜ نَنْغِرْتَمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","اٜ شَرٜلْ نغٜلْ، يِمْٻٜ طُطْٻٜ مٛٻْتِي حَا ٻٜ نغَطِ کَ يَٻْيَٻْتِرْکِ؞ يٜىٰسُ وِعِ تٛکُّٻٜمٛ، ‏«‏ڤَامٜىٰ تٛع نغَرْتٛنْ بٛ فَارِسَنْکٛعٜنْ نغَمْ ٻٜ مُنَافُکِعٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","وَلَا غٛطُّمْ اٛمْبَاطُمْ طُمْ اٛمْتَتَاکٜ، نٛنْ مَا وَلَا غٛطُّمْ شُوطِيطُمْ طُمْ سُورِتَتَاکٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","کٛ مبِيطٛنْ ندٜرْ ݧِوْرٜ فُو، طُمْ نَنَيْطُمْ ݧَلَوْمَ، نٛنْ مَا کٛ مٜتُطٛنْ اٜ سُوطٜ، طُمْ مٜتَيْطُمْ اٜ نجَيْرِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","‏«‏اٜ مِ وِعَعٛنْ، اٛنٛنْ حِغٛوٻٜ اَمْ، تٛع اٛنْ کُلُ وَرٛوٻٜ ٻَنْدُ نٜطّٛ، غَطَ طٛنْ ٻٜ مبَاوَتَا وَطُکِ غٛطُّمْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","اَمَّا مِ وِعَيْعٛنْ مٛ کُلٛتٛنْ؞ کُلٜىٰ اٛنْ طٛنْ بَاوَيْطٛ وَرْکِعٛنْ غَطَ طٛنْ اٛ وَطَعٛنْ ندٜرْ وُرٛ حِيتٜ، اٜ مِ وِعَعٛنْ، کَنْکٛ کُلٛتٛنْ!‏ ");
INSERT INTO fuv_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","‏«‏نَاع شٛلٛيْ نجٛوٛيْ اٜ شٛورٜىٰ جَمْطٜ طِطِ؟ فُو اٜ نٛنْ اَللَّه يٜجِّتَتَا کٛو غٛعٛتٜلْ مَاکٛيْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","کٛو غَاسَ کٛعٜ مٛوطٛنْ مَا فُو کَ لِمَامَ؞ تٛع اٛنْ کُلُ، اٛنْ ٻُرِي شٛلٛيْ طُطْکٛيْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","‏«‏اٜ مِ وِعَعٛنْ، جَٻُطٛيَمْ يٜىٰسٛ يِمْٻٜ فُو، مِنْ ٻِي نٜطّٛ، مِ جَٻَيْمٛ يٜىٰسٛ مَلَاعِکَعٜنْ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","اَمَّا غَݧُطٛيَمْ يٜىٰسٛ يِمْٻٜ، مِ وَݧَيْمٛ يٜىٰسٛ مَلَاعِکَعٜنْ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","‏«‏فُو بِعُطٛ کٛ وٛوطَا دٛوْ ٻِي نٜطّٛ، طُمْ وَاوَيْ يَافَنَاکِمٛ؞ اَمَّا فُو بِعُطٛ کٛ وٛوطَا دٛوْ رُوحُ اَللَّه، اٛ يَافَنْتَاکٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","‏«‏تٛ يِمْٻٜ نجَارِيعٛنْ يٜىٰسٛ مَوْٻٜ اٜ لَامِيٻٜ، تٛع اٛنْ نغَنُّ دٛوْ نٛ مبُرْتِنِرْتٛنْ کٛعٜ مٛوطٛنْ کٛو کٛ مبِعٛتٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","نغَمْ رُوحُ اَللَّه اٜکِّتِنَيْعٛنْ اٜ شَرٜلْ نغٜلْ کٛ حَانِ مبِعٛنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","غٛطّٛ ندٜرْ حَوْرُتُٻٜ وِعِمٛ، ‏«‏مٛودِبّٛ، وِعُ مَوْنِرَاوٛ اَمْ سٜنْدِدَ ندٛنُ اٜ اَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","اَمَّا يٜىٰسُ وِعِمٛ، ‏«‏حِغٛ!‏ مٛيٜ لَمْنِيَمْ دٛوْ مٛوطٛنْ؟ مٛيٜ وَرْتِرِيَمْ شٜنْدَنَيْطٛعٛنْ ندٛنُ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","ندٜنْ اٛ وِعِٻٜ، ‏«‏ڤَامٜىٰ!‏ نغٛطِّتٜىٰ يِدّٜ جَوْدِ دُونِيَارُ، نغَمْ حٜٻُکِ جَوْدِ حٛکَّتَا نٜطّٛ يٛنْکِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","اٛ حٛکِّٻٜ مِسَالُ طُعُمْ، اٛ وِعِ، ‏«‏نغٜسَ غٛطّٛ دِسْکُطٛ يٜىٰطِي نَاع سٜطَّ؞ ");
INSERT INTO fuv_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","اٛ وِعِ حٛورٜ مَاکٛ، ‏‹‏کٛ نغَطَيْمِ؟ مِ وَلَا تٛ ندٜسَيْمِ کٛ ندٜمُمِ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","اٛ وِعِ، ‏‹‏يَوَّا!‏ مِ حٜٻْتِي کٛ نغَطَيْمِ، مِ ڤُسَيْ شُوطِ رٜسُکِ ݧَمْندُ اَمْ، مِ مَحَ غٛطِّ ٻُرْطِطِ مَنْغُ، مِ مٛٻْتَ ݧَمْندُ اَمْ اٜ جَوْدِ اَمْ فُو ندٜرْ مَاجِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","مِ وِعَ حٛورٜ اَمْ ‏«‏اَ وٛودِ فِي طُطُّمْ بٛطُّمْ کٜپَيْطُمَّ دُوٻِ طُطِّ؞ سِوْتَ، ݧَامَا، نجَرَا، نَنَا بٜلْطُمْ؞»‏ ›‏ ");
INSERT INTO fuv_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","اَمَّا اَللَّه وِعِمٛ، ‏‹‏اَ کَاݝَاطٛ!‏ ندٜرْ جٜمَّارٜ ندٜعٜ طُمْ حٛشَّيْ يٛنْکِ مَاطَ؞ مٛيٜ رٛنَتَ کٛ مٛٻْتَنْطَا حٛورٜ مَاطَ؟›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","سٜيْ يٜىٰسُ وِعِٻٜ، ‏«‏کٛو مٛيٜ مٛٻْتَنْطٛ حٛورٜ مُوطُمْ جَوْدِ دُونِيَارُ، ندٜنْ وَلَا کٛ اٛ رٜسِ تٛ اَللَّه، نٛنْ حٜٻَتَمٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","غَطَ طٛنْ، يٜىٰسُ وِعِ تٛکُّٻٜمٛ، ‏«‏نغَمْ نٛنْ اٜ مِ وِعَعٛنْ، تٛع اٛنْ نغَنُّ دٛوْ جٛنْدٜ مٛوطٛنْ، وَاتٛ دٛوْ کٛ ݧَامٛتٛنْ کٛو کٛ نجَرٛتٛنْ کٛو کٛ ٻٛرْنٛتٛوطٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","نغَمْ يٛنْکِ ٻُرِي ݧَمْندُ، ٻَنْدُ بٛو ٻُرِي کٛلْتٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","ندَارٜىٰ دَوْلٜ؞ طٜ اَاوَتَا، طٜ ڤٜعَّتَا، طٜ نغَلَا سُودُ تٛ طٜ مٛٻْتَتَ ݧَمْندُ کٛو تٛ طٜ ندٜسَتَ غٛطُّمْ؛ فُو اٜ نٛنْ اَللَّه اٜ ݧَمْنَطٜ؞ اٛنْ ٻُرِي شٛلِّ دَرَجَ!‏ ");
INSERT INTO fuv_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","مٛيٜ ندٜرْ مٛوطٛنْ تٛ وَنِّي وَاوَتَ ٻٜيْدَنْکِ حٛورٜ مُوطُمْ شَرٜلْ سٜطَّ ندٜرْ بَلْطٜ مُوطُمْ؟ ");
INSERT INTO fuv_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","تٛ اٛنْ مبَاوَتَا وَطُکِ فِي ڤَمَرُمْ طُعُمْ، کٛ وَطَتَ اٛنْ نغَنَّ اٜ کٛ حٛرِي؟ ");
INSERT INTO fuv_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","ندَارٜىٰ ڤِنْدِ نٛ مَوْنِرْتَ؞ ندِ حُوَتَا، ندِ سَݧَتَا کٛلْتٜ؞ فُو اٜ نٛنْ، اٜ مِ وِعَعٛنْ، اَنَّبِ سُلٜيْمَانُ فُو اٜ رِسْکُ مُوطُمْ مٜىٰطَايِ مٛعِّتِنَاکِ بٛ ڤِنْدِ وٛعٛيْرِ ندِعِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","تٛ اَللَّه اٜ مٛعِّتِنِرَ ڤِنْدِ لَدّٜ نِحِ، حَنْدٜ اٜ ندِ طٛنْ، جَانغٛ ندِ وُلٜىٰ، حَکّٛ اٛنٛنْ، اٛ ٻُرَيْ نٛنْ ٻٛرْنُکِعٛنْ، اٛنٛنْ کٛولِيٻٜمٛ سٜطَّ؞ ");
INSERT INTO fuv_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","‏«‏ندٜنْ تٛع اٛنْ نغَطُ ٻٜرْطٜ مٛوطٛنْ دٛوْ کٛ ݧَامَتٛنْ کٛو بٛو کٛ نجَرٛتٛنْ؞ تٛع اٛنْ نغَنُّ کٛعٜ مٛوطٛنْ دٛوْ مَاجُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","نغَمْ اِرِ طُمْ طٛنْ فِي يِمْٻٜ دُونِيَارُ طَٻِّتَتَ؞ ݧَاکٛ مٛوطٛنْ مٛ دٛوْ اٜ اَنْدِ اٛنْ نغِطِ فِي طُمْ طٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","اَمَّا طَٻِّتٜىٰ لَامُ مَاکٛ، ندٜنْ طُمْ ٻٜيْدَنَيْعٛنْ فِي طُعُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","‏«‏اٛنٛنْ اٛرْندٜ اَمْ ڤَمَرْدٜ، تٛع اٛنْ کُلُ، نغَمْ ݧَاکٛ مٛوطٛنْ مٛ دٛوْ اٜ نَنَ بٜلْطُمْ حٛکُّکِعٛنْ لَامُ مُوطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","شٛورٜىٰ کٛ نغٛودُطٛنْ، کٛکّٛنْ ٻٜ نغَلَنَا شٜىٰدٜ طٜنْ؞ ندٜسَنٜىٰ کٛعٜ مٛوطٛنْ جَوْدِ ندِ وٛنَّتَاکٛ، جَوْدِ ندِ دٛوْ ندِ رٜعَتَا؞ تٛنْ غُجّٛ ٻَدَّتَاکٛندِ، ندٜنْ وَلَا مٛوپُ ݧَامَيْنغُندِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","نغَمْ تٛ جَوْدِ مَاطَ وٛنِ، تٛنْ ٻٜرْندٜ مَاطَ مَا سٛعّٛتٛو؞ ");
INSERT INTO fuv_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","‏«‏تَادٜىٰ شِرْيٛوطٛنْ نغَمْ کُوغَلْ اَللَّه، اَلْدٜىٰ فِتِلَاجِ مٛوطٛنْ اٜ حِيتٜ، ");
INSERT INTO fuv_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","بٛ مَشُّٻٜ کٜطِيٻٜ جٛومُ وُرٛ مَٻّٜ وَرْتٛيَ دَغَ حُمْتٛ تٜىٰغَلْ، نغَمْ تٛ اٛ وَرْتٛيِي اٛ سِلْمِنَکٜ، طٛنْ اٜ طٛنْ ٻٜ مَٻِّتَنَمٛ دَمُّغَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","ٻٜ بَرْکِطِنَاٻٜ مَشُّٻٜ ٻٜ جٛومُ وُرٛ مَٻّٜ تَوِ اٜ ندٜىٰنَ تٛ اٛ وَرْتٛيِي؞ اٜ مِ وِعَعٛنْ غٛونغَ، اٛ تَادٛتٛ نغَمْ کُوغَلْ، اٛ جٛطِّنَٻٜ، اٛ وَدَّنَٻٜ ݧَمْندُ؞ ");
INSERT INTO fuv_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","تٛ اٛ وَرْتٛيِي شَکَ جٜمَّ کٛو فَجِرِ، مَشُّٻٜ ٻٜ اٛ تَوِ اٜ ٻٜ شِرْيِ، ٻٜ بَرْکِطِنَاٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","اَمَّا اَنْدٜىٰ طُعُمْ، دَا جٛومُ وُرٛ اٜ اَنْدِ شَرٜلْ کٛ غُجّٛ وَرَتَ، اٛ اَلَتَا اٛ نَتَّنَمٛ وُرٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","اٛنٛنْ مَا دٛولٜ نجٛوطٛوطٛنْ اٛنْ شِرْيِي نغَمْ اٜ شَرٜلْ نغٜلْ اٛنْ اَنْدَا ٻِي نٜطّٛ وَرَتَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","بِيتُرُسْ وِعِ، ‏«‏مٛودِبّٛ، اَ وِعَ مِسَالُ طُعُمْ نغَمْ مِنٛنْ تَنْ کٛو نغَمْ کٛو مٛيٜ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","يٜىٰسُ نٛوتِي وِعِ، ‏«‏مٛيٜ وٛنِ کُوٛووٛ مٛ غٛونغَ مٛ فَامُ، مٛ جٛومُ وُرٛ مُوطُمْ يٛوِ دٛوْ مَشُّٻٜ مُوطُمْ، نغَمْ اٛ حٛکَّٻٜ ݧَمْندُ ندٜرْ شَرٜلْ؟ ");
INSERT INTO fuv_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","اٛ بَرْکِطِنَاطٛ مَشُّطٛ مٛ جٛومُ وُرٛ مُوطُمْ وَرْتِ تَوِ اٜ مٛ وَطَ نٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","اٜ مِ وِعَعٛنْ غٛونغَ، جٛومُ وُرٛ اٛنْ يٛوَيْمٛ دٛوْ جَوْدِ مُوطُمْ فُو؞ ");
INSERT INTO fuv_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","اَمَّا تٛ مَشُّطٛ اٛنْ وِعِي حٛورٜ مُوطُمْ، ‏‹‏جٛومُ وُرٛ اَمْ وَرْتَتَا جٛونِ،›‏ سٜيْ اٛ فُطِّ فِيُکِ مَشُّٻٜ وٛرْٻٜ اٜ رٜوْٻٜ اٜ مٛ ݧَامَ اٜ مٛ يَرَ نجَرُ نَا حٛورٜ مَاکٛ وَيْلِتَکٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","جٛومُ وُرٛ اٛنْ وَرْتَيْ اٜ ݧَلْندٜ ندٜ مَشُّطٛ اٛنْ کَمَّاکِ اٜ شَرٜلْ نغٜلْ اٛ اَنْدَا، اٛ فِيَيْمٛ بٛطُّمْ اٛ وَطَمٛ ندٜرْ ٻٜ نغَلَا غٛونغَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","‏«‏مَشُّطٛ اَنْدُطٛ کٛ جٛومُ وُرٛ مُوطُمْ يِطِ اٛ وَطَ، اَمَّا اٛ سِرْيَاکِ کٛو بٛو اٛ وَطَايِ کٛ جٛومُ وُرٛ اٛنْ يِطِ، طُمْ فِيَيْمٛ بٛطُّمْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","اَمَّا مَشُّطٛ مٛ اَنْدَا کٛ جٛومُ وُرٛ مُوطُمْ يِطِ اٛ وَطَ، تٛ اٛ وَطِي فِي کَلُّطُمْ، طُمْ فِيَيْمٛ سٜطَّ؞ فُو کٛکَّاطٛ طُطُّمْ، طُطُّمْ طُمْ طَٻِّتَتَ تٛ مَاکٛ؞ فُو تَمْبِنَاطٛ طُطُّمْ، اٛ پَمٜتٜىٰطٛ کٛ ٻُرِ طُطْکِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","‏«‏حِيتٜ نغَرٛيْمِ وَطُکِ ندٜرْ دُونِيَارُ، اٜ يِدّٜ اَمْ نغٜ حُٻّٜىٰ جٛونِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","اَمَّا اٜ وٛودِ بَڤْتِسْمَ طُمْ نغَطَنْتٜىٰمِ، مِ وَنِّي نَا طُمْ وَطَنِييَمْطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","اٛنْ کَمِّي مِ وَرٛيِ وَدَّنْکِ دُونِيَارُ جٛنْدٜ جَمْ؟ اٜ مِ وِعَعٛنْ، نَاع نٛنْ، اَمَّا سٜنْدُکِ يِمْٻٜ نغَدُّمِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","دَغَ جٛونِ طُمْ تَوَيْ يِمْٻٜ نجٛوٛ ندٜرْ وُرٛ غٛعٛ ٻٜ کُوشِندِرَا، تَتٛ اُمَّنْتٛ طِطٛ، طِطٛ اُمَّنْتٛ تَتٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","ݧَاکٛ سٜنْدِرَيْ اٜ ٻِطّٛ مُوطُمْ، ٻِطّٛ اٛنْ مَا سٜنْدِرَيْ اٜ ݧَاکٛ مُوطُمْ؞ اِنَّ سٜنْدِرَيْ اٜ ٻِطّٛ مُوطُمْ دٜبّٛ، ٻِطّٛ اٛنْ مَا سٜنْدِرَيْ اٜ اِنَّ مُوطُمْ؞ اٜسِرَاوٛ مَا سٜنْدِرَيْ اٜ اٜسِرَاوٛ مُوطُمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","يٜىٰسُ وِعِ حَوْرُتُٻٜ، ‏«‏تٛ اٛنْ نغِعِي دُولٜ اٜ اُمّٛيٛو دَغَ حِرْنَ، طٛنْ اٜ طٛنْ اٛنْ مبِعَيْ، ‏‹‏ندِيَمْ تٛٻَيْ،›‏ سٜيْ طَمْ تٛٻَ بٛو؞ ");
INSERT INTO fuv_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","تٛ حٜنْدُ فٛمْبِنَ اُمّٛيَکٜ، اٛنْ مبِعَيْ، ‏‹‏طُمْ وَطَيْ نغُلٜىٰنغَ،›‏ سٜيْ طُمْ وَطَ بٛو؞ ");
INSERT INTO fuv_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","اٛنٛنْ مُنَافُکِعٜنْ!‏ اٛنْ مبَاوِ رَارُکِ کٛ وٛنِ اٜ لٜيْدِ اٜ کٛ وٛنِ اٜ دٛوْ اَنْدٛنْ کٛ وَطَتَ، اَمَّا نغَمْ طُمٜ اٛنْ مبَاوَتَا فَامُکِ کٛ وَطَتَ اٜ شَرٜلْ نغٜعٜلْ؟ ");
INSERT INTO fuv_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","‏«‏نغَمْ طُمٜ اٛنْ مبَاوَتَا سُٻَنْکِ کٛعٜ مٛوطٛنْ کٛ حَانِ؟ ");
INSERT INTO fuv_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","تَا يَادَ اٜ غُلّٛيِيطٛمَ يٜىٰسٛ لَامُ، طَٻُّتُ شِرْيٛوتِرٛنْ دٛوْ طَتَلْ؞ تٛ نَاع نٛنْ، اٛ يَارٜتٜ يٜىٰسٛ غَطٛووٛ کِيتَ، غَطٛووٛ کِيتَ وَطُمَا ندٜرْ جُوطٜ تَادِيٻٜ ٻٜ مَٻُّمَا ندٜرْ سُودُ شُرَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","اٜ مِ وِعُمَا، اَ وُرْتَتَاکٛ نَا اَ يٛٻِي فُو شٜىٰدٜ طٜ طُمْ تٛکَّتَمَ کٛو اَنِينِيٜلْ حٛرَتَاکٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","اٜ شَرٜلْ نغٜلْ اٜ وٛودِ وٛٻّٜ طٛنْ بِعُٻٜ يٜىٰسُ کٛ حٜٻِ وٛٻّٜ غَلِلَنْکٛعٜنْ؞ غَلِلَنْکٛعٜنْ ٻٜنْ اٜ کِرْسَنَ اَللَّه شَکِّرِ، سٜيْ بِلَاتُسْ غٛمْنَاجٛ وَطِ طُمْ وَرِٻٜ حَا پِيپَمْ مَٻّٜ حَوْتِي اٜ پِيپَمْ کٛ ٻٜ شَکِّ؞ ");
INSERT INTO fuv_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","يٜىٰسُ نٛوتِي وِعِٻٜ، ‏«‏اٛنْ کَمّٛو غَلِلَنْکٛعٜنْ ٻٜنْ طٛنْ ٻُرِي غَلِلَنْکٛعٜنْ کٛرِيٻٜ فُو حَکّٜ نغَمْ ٻٜ تٛرِّرَامَ نِحِ؟ ");
INSERT INTO fuv_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","اٜ مِ وِعَعٛنْ، نَاع نٛنْ!‏ اَمَّا تٛ نَاع اٛنْ تُوبُ، اٛنٛنْ مَا اٛنْ فُو اٛنْ کَلْکٜتٜىٰٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","کٛو مَا يِمْٻٜ سَڤّٛ اٜ نجٛوٜىٰتَتٛ مَيْٻٜ شَرٜلْ کٛ سُودُ تٛوْندُ ندُ سِلُوَمْ يَنِ دٛوْ مَٻّٜ، اٛنْ کَمّٛو ٻٜ ٻُرِي يِمْٻٜ کٛرِيٻٜ جٛوطِيٻٜ ندٜرْ اُرُشَلِيمَ فُو وَطُکِ حَکّٜ؟ ");
INSERT INTO fuv_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","اٜ مِ وِعَعٛنْ، نَاع نٛنْ!‏ اَمَّا تٛ نَاع اٛنْ تُوبُ، اٛنٛنْ مَا نٛنْ کَلْکِرْتٛنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","سٜيْ اٛ حٛکِّ مِسَالُ طُعُمْ، اٛ وِعِ، ‏«‏غٛطّٛ نٜطّٛ اٜ وٛودِ لٜکِّ اِبِّ ندٜرْ نغٜسَ مُوطُمْ، اٛ يَحِ اٛ يِعَ کٛو اٜ کِ وٛودِ ٻِکّٛيْ، اَمَّا اٛ تَوِ کِ وَلَنَا؞ ");
INSERT INTO fuv_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","نغَمْ نٛنْ اٛ وِعِ نٜطّٛ کُوَنٛووٛمٛ تٛ نغٜسَ کَنْ، ‏‹‏رَا، دُوٻِ تَتِ اٜ مِ وَرَ طَٻُّتُکِ اِبّٜ دٛوْ اِبِّ کِعِ، اَمَّا مِ حٜٻَتَا؞ فٜعُّکِ!‏ نغَمْ طُمٜ کِ سُرَتَ لٜيْدِ اٜ مٜىٰرٜ؟›‏ ");
INSERT INTO fuv_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","کُوٛووٛ تٛ نغٜسَ کَنْ وِعِمٛ، ‏‹‏جٛومُ وُرٛ، ٻٜيْدَنْکِ ندُنْغُ غٛعٛ، مِ مٛعِّنَنَکِ لٜيْدِ، مِ وَطَنَکِ نغٛوبَارِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","تٛ کِ رِمِي ٻِکّٛيْ حِتَاندٜ غَرَيْندٜ، تٛو، وٛوطِي، اَمَّا تٛ کِ رِمَايِ، سٜيْ ڤٜعَّاکِ؞›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","وٛنْدٜ ݧَلْندٜ سِوْتَارٜ يٜىٰسُ اٜ اٜکِّتِنَ ندٜرْ سُودُ دٛعَارٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","اٜ وٛودِ دٜبّٛ طٛنْ غِنّٛلْ اٜ حَٻِّمٛ دُوٻِ سَڤّٛ اٜ جٛوٜىٰتَتِ، اٜ نغٛلْ تُرْنِمٛ، کٛو حٛورٜ مَاکٛ اٛ وَاوَتَا پٜفْتُکِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","ندٜ يٜىٰسُ يِعِمٛ، نٛدِّمٛ حَادٜ، وِعِمٛ، ‏«‏بَنْدِرَاوٛ، اَ حٛيِي دَغَ ݧَوُ مَاطَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","يٜىٰسُ يٛوِ جُوطٜ مُوطُمْ دٛوْ مَاکٛ، طٛنْ اٜ طٛنْ اٛ ٻَنْتِي اٛ فُطِّ مَنْتُکِ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","ٻٜرْندٜ اَرْدِيطٛ سُودُ دٛعَارٜ ندُنْ مٜتِّ نغَمْ يٜىٰسُ يَمْطِتِنِي غٛطّٛ ݧَلْندٜ سِوْتَارٜ؞ نغَمْ مَاجُمْ اٛ وِعِ يِمْٻٜ، ‏«‏اٜ وٛودِ بَلْطٜ جٛوٜىٰغٛعٛ نغَمْ کُوطٜ، نغَرٜىٰ طُمْ يَمْطِتِنَعٛنْ ندٜرْ بَلْطٜ طٜنْ، نَاع نِ ندٜرْ ݧَلْندٜ سِوْتَارٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","سٜيْ يٜىٰسُ نٛوتِي وِعِمٛ، ‏«‏اٛنٛنْ مُنَافُکِعٜنْ!‏ نَاع کٛو مٛيٜ مٛوطٛنْ اٜ فِتَّ نغَارِ مُوطُمْ کٛو مبَبَّ مُوطُمْ ندٜرْ ݧَلْندٜ سِوْتَارٜ يَرْنٛيَنغَ؟ ");
INSERT INTO fuv_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","اٛعٛ دٜبّٛ تَانُ اِبْرَاهِمْ، مٛ شٜيْطَنْ حَٻِّ دُوٻِ سَڤّٛ اٜ جٛوٜىٰتَتِ، حَانَا اٛ فِتّٜىٰ ݧَلْندٜ سِوْتَارٜ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","ندٜ اٛ وِعِ نٛنْ، وَݧْوَݧْٻٜ مَاکٛ فُو شٜمْتِ، اَمَّا يِمْٻٜ نَنِ بٜلْطُمْ اٜ فِي کَيْطِنِيطُمْ فُو طُمْ اٛ وَطَتَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","ندٜنْ يٜىٰسُ وِعِ، ‏«‏طُمٜ لَامُ اَللَّه نَنْدِ؟ کٛ نَنْدِنَيْمِطُمْ؟ ");
INSERT INTO fuv_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","لَامُ اَللَّه اٜ نَنْدِ اٜ غَبّٜلْ مَسْتَتْ نغٜلْ غٛطّٛ حٛشِّ اَاوِ ندٜرْ نغٜسَ مُوطُمْ؞ غَبّٜلْ نغٜلْ فُطِ، وَرْتِ لٜغّٜلْ، شٛلِّ نغَطِ شَٻّٜ دٛوْ لِشٜ مَاکِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","اٛ وِعِ کَدِنْ، ‏«‏طُمٜ نَنْدِنَيْمِ لَامُ اَللَّه؟ ");
INSERT INTO fuv_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","اٜ طُمْ نَنْدِ اٜ پُوفِنِرْطُمْ طُمْ غٛطّٛ دٜبّٛ حٛشِّ لَنْشِندِرِ اٜ شٛنْدِ اَلْکَمَارِ ڤٛوندِرْکٛيْ تَتٛيْ ندِ فُو ندِ پُوفِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","يٜىٰسُ اٜ يَحَ اُرُشَلِيمَ اٛ تٛکِّ غَرِيجٜ اٜ نغَرِحٛيْ اٜ مٛ اٜکِّتِنَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","غٛطّٛ پَمِمٛ وِعِ، ‏«‏مٛودِبّٛ، يِمْٻٜ سٜطَّ تَنْ کِسَتَ؟»‏ اٛ وِعِٻٜ، ");
INSERT INTO fuv_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","‏«‏ندُرْوٜىٰ نَتِّرٛنْ تٛ دَمُّغَلْ ٻِطِّينغَلْ، نغَمْ اٜ مِ وِعَعٛنْ، طُطْٻٜ ندٛولَيْ نغَمْ نَتَّ اَمَّا ٻٜ مبَاوَتَا؞ ");
INSERT INTO fuv_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","تٛ جٛومُ وُرٛ نغٛنْ اُمَّکٜ مَٻِّي دَمُّغَلْ نغَلْ، اٛنْ ندَرٛتٛ يَاسِ اٛنْ ڤِيَ دَمُّغَلْ نغَلْ اٛنْ تٛرٛو اٛنْ مبِعَ، ‏‹‏مٛودِبّٛ، مَٻِّتَنْمِنْ دَمُّغَلْ!‏›‏ اَمَّا اٛ وِعَيْعٛنْ، ‏‹‏مِ اَنْدَاعٛنْ، مِ اَنْدَا تٛ پِوٛيْطٛنْ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","ندٜنْ اٛنْ مبِعَيْ، ‏‹‏مِنْ ݧَمْدِي، مِنْ نجَرْدِي اٜ مَاطَ، اَ اٜکِّتِنِي ندٜرْ غَرِيجٜ اَمِنْ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","اَمَّا اٛ وِعَيْ، ‏‹‏اٜ مِ وِعَعٛنْ، مِ اَنْدَاعٛنْ، مِ اَنْدَا تٛ پِوٛيْطٛنْ؞ شٜنْدِرٜىٰ اٜ اَمْ، اٛنٛنْ کَلُّٻٜ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","تٛ اٛنْ نغِعِي اِبْرَاهِمْ اٜ اِشِيَاکُ اٜ يَاکُبُ اٜ اَنَّبٛعٜنْ فُو ندٜرْ لَامُ اَللَّه، اَمَّا اٛنٛنْ اٛنْ مبُرْتِنَامَ، اٛنْ مبٛيَيْ ݧٜرْپِندِرٛنْ ݧِيپٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","يِمْٻٜ نَاع يَحُودَنْکٛعٜنْ نغَرَيْ دَغَ فُونَ اٜ حِرْنَ اٜ وٛيْلَ اٜ فٛمْبِنَ ٻٜ نجٛوطٛو ٻٜ ݧَامَ ݧَمْندُ حُمْتٛ ندٜرْ لَامُ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","رَطُّمْ، وٛٻّٜ شَکِتِيٻٜ ٻٜ نغَرْتَيْ اَرْتُٻٜ، ندٜنْ وٛٻّٜ اَرْتُٻٜ ٻٜ نغَرْتَيْ شَکِتٛتٛوٻٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","اٜ شَرٜلْ نغٜلْ، وٛٻّٜ فَارِسَنْکٛعٜنْ نغَرِ تٛ يٜىٰسُ مبِعِمٛ، ‏«‏اَلُ طٛعٛ نغَمْ حِرُدُسْ اٜ يِطِ وَرْمَا؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","اٛ وِعِٻٜ، ‏«‏نجَحٜىٰ مبِعٛنْ دِلَارُ ندُنْ طٛنْ، ‏‹‏رَطُّمْ، حَنْدٜ اٜ جَانغٛ مِ وُرْتِنَيْ غِنِّ مِ يَمْطِتِنَيْ ٻٜ نجَمْطَا؞ اٜ ݧَلْندٜ تَتَوْرٜ مِ يٛتِّنَيْ کُوغَلْ اَمْ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","فُو اٜ نٛنْ، دٛولٜ مِ نَنْغَ لَاوٛلْ حَنْدٜ اٜ جَانغٛ اٜ فَٻِّ جَانغٛ، نغَمْ حَانَا طُمْ وَرَ اَنَّبِيجٛ بَنْݧٜ سٜيْ ندٜرْ اُرُشَلِيمَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","‏«‏جَلَّ اُرُشَلِيمَ، اُرُشَلِيمَ اَ وَرِي اَنَّبٛعٜنْ، اَ وَرْدِي لِلٛيَاٻٜ تٛ مَاطَ اٜ کَاپٜ!‏ ندٜ طُطُّمْ اٜ مِ يِطِ مٛٻْتُکِ يِمْٻٜ مَاطَ نٛ غٜرٛوغَلْ مٛٻْتِرْتَ ٻِکّٛيْ مَاغَلْ لٜيْ بِيٜىٰلِ مَاغَلْ، اَمَّا اَ جَٻَايِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","رَطُّمْ، اَللَّه اَلَنَيْعٛنْ وُرٛ شٜنِينغٛ مٛوطٛنْ؞ اٜ مِ وِعَعٛنْ، اٛنْ ڤُطِّتَتَا نغِعٛنْيَمْ، نَا ݧَلْندٜ ندٜ مبِيطٛنْ، ‏‹‏اٛ بَرْکِطِنَاطٛ، غَرٛيْطٛ ندٜرْ اِنْدٜ جٛومِرَاوٛ؞›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","وٛنْدٜ ݧَلْندٜ سِوْتَارٜ يٜىٰسُ يَحِ وُرٛ غٛعٛتٛ ندٜرْ اَرْدِيٻٜ فَارِسَنْکٛعٜنْ نغَمْ اٛ ݧَامَ ݧَمْندُ؞ سٜيْ ٻٜ نغَطِ کَ رَارُکِمٛ، کٛو اٛ وَطَيْ کٛ ٻٜ کٜٻَتَ ٻٜ نَنْغِرَمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","حَادٜ مَاکٛ اٜ وٛودِ غٛطّٛ غٛرْکٛ غٛودُطٛ ݧَوُ ٻُدِّ؞ ");
INSERT INTO fuv_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","يٜىٰسُ پَمِ فَارِسَنْکٛعٜنْ اٜ مٛودِٻّٜ اَتَّوْرَ اٛ وِعِ، ‏«‏دٛوکَ جَٻِي طُمْ يَمْطِتِنَ نٜطّٛ ݧَلْندٜ سِوْتَارٜ کٛ اَاعَ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","اَمَّا ٻٜ نٛوتَاکِ؞ سٜيْ يٜىٰسُ مٜىٰمِ ݧَوْطٛ اٛنْ يَمْطِتِنِمٛ، وِعِمٛ اٛ دِلَّ؞ ");
INSERT INTO fuv_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","ندٜنْ اٛ پَمِٻٜ، اٛ وِعِ، ‏«‏مٛيٜ ندٜرْ مٛوطٛنْ تٛ ٻِطّٛ مُوطُمْ کٛو نغَارِ مُوطُمْ يَنِي ندٜرْ ٻُنْدُ ݧَلْندٜ سِوْتَارٜ اِتّٛيْتَامٛ طٛنْ اٜ طٛنْ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","ٻٜ کٜٻَايِ کٛ ٻٜ مبِعِمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","ندٜ يٜىٰسُ فَامِ کُمْڤِتَاٻٜ ݧَامُکِ ݧَمْندُ طٛنْ فُو اٜ شُٻَ جٛوطَاکِ تٛ مَوْٻٜ نجٛوطٛتٛو، اٛ حٛکِّٻٜ مِسَالُ طُعُمْ، اٛ وِعِ، ");
INSERT INTO fuv_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","‏«‏تٛ غٛطّٛ حُمْڤِتِيمَ حُمْتٛ، تَاع جٛوطَ تٛ مَوْٻٜ نجٛوطٛتٛو؞ طُمْ غَطٛتٛوطُمْ اٛ حُمْڤِتِي غٛطّٛ ٻُرْطٛمَ مَنْغُ؞ ");
INSERT INTO fuv_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ندٜنْ کُمْڤِتٛيْطٛمَ اٛنْ اٛ وَرٛيَيْ اٛ وِعُمَا، ‏‹‏اُمَّ نٜطّٛ اٛعٛ جٛوطٛو؞›‏ نغَمْ نٛنْ بٛو اَ سٜمْتَيْ، نجٛوطٛطَا تٛ جٛوطٛرْغَلْ شَکِتِينغَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","اَمَّا تٛ طُمْ حُمْڤِتِيمَ، جٛوطَ تٛ جٛوطٛرْغَلْ شَکِتِينغَلْ، نغَمْ تٛ کُمْڤِتٛيْطٛمَ وَرٛيِ، اٛ وِعٜتٜ، ‏‹‏حِغٛ، اُمَّ، نجٛوطٛيٛطَا دٛوْ جٛوطٛرْغَلْ مَوْٻٜ؞›‏ نٛنْ حٛکّٜتٜ مَنْغُ يٜىٰسٛ غَرٛيْٻٜ طٛنْ فُو؞ ");
INSERT INTO fuv_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","نغَمْ مَوْنِنْطٛ حٛورٜ مُوطُمْ فُو اٛ لٜسْنٜتٜىٰطٛ، لٜسْنِنْطٛ حٛورٜ مُوطُمْ بٛو اٛ مَوْنِنْتٜىٰطٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","ندٜنْ اٛ وِعِ کُمْڤِتٛيْطٛمٛ، ‏«‏تَا حُمْڤِتَيْ يِمْٻٜ حُمْتٛ تٛ وُرٛ مَاطَ، تَاع حُمْڤُتُ حِغٛوٻٜ مَاطَ تَنْ، کٛو مَوْنِرَاٻٜ اٜ مِݧِرَاٻٜ مَاطَ تَنْ، کٛو بَنْدِرَاٻٜ مَاطَ تَنْ، کٛو ٻٜ کٜدُّطَا رِسْکُٻٜ؞ نغَمْ ٻٜ کُمْڤِتٜتٜ کَمْٻٜ مَا، ٻٜ نغَاتَنْمَا کٛ نغَطَنْطَاٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","اَمَّا تَا وٛودِ حُمْتٛ، حُمْڤُتُ ٻٜ نغَلَنَا، اٜ جَرَاٻٜ، اٜ غُرْغُعٜنْ، اٜ وُمْٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","طُمْ بَرْکِطِنْتٜ، نغَمْ ٻٜ مبَاوَتَا وَاتَنْکِمَ کٛ نغَطَنْطَاٻٜ؞ اَللَّه وَاتَنْتٜ ݧَلْندٜ جَانغٛ، ݧَلْندٜ ندٜ اٛ اُمِّنْتَ مَيْٻٜ غَطُٻٜ جٛنْدٜ وٛوطُندٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","ندٜ غٛطّٛ ندٜرْ جٛوطٛدِيٻٜ اٜ مَاکٛ نَنِ نٛنْ، اٛ وِعِ يٜىٰسُ، ‏«‏نٜطّٛ ݧَامٛووٛ ݧَمْندُ ندٜرْ لَامُ اَللَّه اٛ بَرْکِطِنَاطٛ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","سٜيْ يٜىٰسُ وِعِمٛ، ‏«‏اٜ وٛودِ غٛطّٛ نٜطّٛ شِرْيِيطٛ حُمْتٛ مَنْغٛ اٛ حُمْڤِتِ يِمْٻٜ طُطْٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","ندٜ شَرٜلْ حُمْتٛ نغٛنْ وَطِ، اٛ لِلِ مَشُّطٛ مَاکٛ وِعٛيَ کُمْڤِتَاٻٜ ٻٜنْ، ‏‹‏نغَرٛيٜىٰ، کٛو طُمٜ سِرْيَامَ!‏›‏ ");
INSERT INTO fuv_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","اَمَّا ٻٜ فُو ٻٜ نغَطِ کَ طَٻُّتُکِ نٛ ٻٜ شَلٛرْتٛو نغَمْ ٻٜ نغِطَا يَاکِ؞ اَرَنْدٜىٰجٛ اٛنْ وِعِمٛ، ‏‹‏مِ سٛودِي نغٜسَ، دٛولٜ مِ يَحَ مِ يِعَکَ؞ وَطُ مُݧَلْ، مِ حٜٻَتَا يَاکِ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","طِطَٻٛ وِعِمٛ، ‏‹‏مِ سٛودِي نَعِ دٜمٛوجِ کَنْجِ سَڤّٛ، اٜ مِ يِطِ يَاکِ مِ فٛوندَطِ جٛونِ؞ وَطُ مُݧَلْ مِ حٜٻَتَا يَاکِ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","نٛنْ تَتَٻٛ مَا وِعِ، ‏‹‏مِ نٜىٰٻَايِ کٛ تٜعُمِ، نغَمْ نٛنْ مِ حٜٻَتَا يَاکِ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","مَشُّطٛ اٛنْ سٛعِّي وِعِ جٛومُ وُرٛ مُوطُمْ کٛو طُمٜ؞ ٻٜرْندٜ جٛومُ وُرٛ اٛنْ مٜتِّ، اٛ وِعِ مَشُّطٛ اٛنْ، ‏‹‏يَوْنُ نجَحَا دٛوْ طَتٜ مَوْطٜ اٜ طَتٜ ڤَمَرٜ ندٜرْ غَرِيرِ، نٛدَّنٛوَايَمْ ٻٜ نغَلَنَا، اٜ جَرَاٻٜ، اٜ وُمْٻٜ، اٜ غُرْغُعٜنْ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","غَطَ مَشُّطٛ اٛنْ وَرْتٛيِي وِعِ جٛومُ وُرٛ مُوطُمْ، ‏‹‏کٛ مبِيطَا طُمْ وَطَ وَطَامَ، اَمَّا فُو اٜ نٛنْ نجَيْرِ اٜ حٛرِي؞›‏ ");
INSERT INTO fuv_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","سٜيْ جٛومُ وُرٛ اٛنْ وِعِ مَشُّطٛ اٛنْ، ‏‹‏يَحُ دٛوْ طَتٜ مَوْطٜ اٜ طَتٜ ڤَمَرٜ غَطَ غَرِيرِ، نٛدَّا يِمْٻٜ نغَرٛيَ نَتَّ وُرٛ اَمْ نغَمْ نغٛ حٜىٰوَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","اٜ مِ وِعَعٛنْ، ندٜرْ کُمْڤِتَاٻٜ اَرَنْدٜعٜنْ وَلَا ݧَامَيْطٛ ݧَمْندُ حُمْتٛ اَمْ؞›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","وٛنْدٜ ݧَلْندٜ يِمْٻٜ طُطْٻٜ اٜ نجَادَ اٜ يٜىٰسُ؞ سٜيْ اٛ رَارِٻٜ اٛ وِعِ، ");
INSERT INTO fuv_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","‏«‏غَرٛيْطٛ تٛ اَمْ فُو تٛ ٻُرَايِ يِطُکِيَمْ دٛوْ ݧَاکٛ مُوطُمْ اٜ مَدُوجٛ مُوطُمْ اٜ دٜبّٛ مُوطُمْ اٜ ٻِٻّٜ مُوطُمْ اٜ مَوْنِرَاٻٜ اٜ مِݧِرَاٻٜ مُوطُمْ ‑ حَا مَا اٜ يٛنْکِ مُوطُمْ، اٛ وَاوَتَا وَرْتُکِ تٛکُّطٛيَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","کٛو مٛيٜ تٛ حٛشَّايِ غَافَانغَلْ مُوطُمْ تٛکِّيَمْ وَاوَتَا وَرْتُکِ تٛکُّطٛيَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","مِسَالُ، تٛ غٛطّٛ مٛوطٛنْ اٜ يِطِ مَحُکِ وُرٛ مَنْغٛ، اَيْ اَرَنْدٜ اٛ جٛوطٛتٛ تَوْ اٛ لِمَ کٛ اٛ مَجِّنْتَ، اٛ يِعَ کٛو اٜ مٛ وٛودِ کٛ حٜپَتَمٛ اٛ يٛتِّنَنْغٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","تٛ نَاع نٛنْ، تٛ اٛ فُطِّي مَحُکِنغٛ اٛ وَاوَتَا يٛتِّنْکِنغٛ، غِعُطٛنغٛ فُو جَلَيْمٛ ");
INSERT INTO fuv_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","وِعَ، ‏‹‏رَا نٜطّٛ اٛعٛ فُطِّي مَحُکِ، اَمَّا اٛ وَاوَايِ يٛتِّنْکِ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","کٛو بٛو تٛ لَامِيطٛ غٛودُطٛ سٛوجِعٜنْ 10,000 حٛنِدَيْ اٜ لَامِيطٛ غَرٛيْطٛ حٛنَمٛ اٜ سٛوجِعٜنْ 20,000، اَرَنْدٜ اٛ جٛوطٛتٛ تَوْ اٛ يِعَ کٛو اٜ مٛ وٛودِ سٜمْبٜ حٛنُدُکِ اٜ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","تٛ اٛ يِعِي اٛ وَاوَتَا، اٛ لِلَيْ لِلَاٻٜ تٛ غَرَيْطٛ اٛنْ کٛ اٛ يٛتّٛ، نغَمْ ٻٜ طَٻِّتَ سِرْيٛوتِرْکِ اٜ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","نٛنْ مَا، کٛو مٛيٜ تٛ سٜنْدِرَايِ اٜ کٛ وٛودِ فُو وَاوَتَا وَرْتُکِ تٛکُّطٛيَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","‏«‏لَمْطَمْ طُمْ فِي بٛطُّمْ، اَمَّا تٛ بٜلْطُمْ مَاجَمْ اِتَّکٜ، کٛ وَرْتِرْتَ بٜلْطُمْ مَاجَمْ؟ ");
INSERT INTO fuv_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","وَلَا کٛ طَمْ وَطٜتٜىٰ؞ طَمْ نَفَتَا غٛطُّمْ، سٜيْ نِ طَمْ رُفٜىٰ؞ غٛودُطٛ نٛڤِّ نَنٛوجِ فُو نَنَ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","وٛنْدٜ ݧَلْندٜ جَٻٛوٻٜ شٜىٰدٜ لٜيْدِ اٜ غَطٛوٻٜ حَکّٜ نغَرِ تٛ يٜىٰسُ نغَمْ ٻٜ نَنَ کٛ اٛ وِعَتَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","اَمَّا فَارِسَنْکٛعٜنْ اٜ مٛودِٻّٜ اَتَّوْرَ نغَطِ کَ مٜتِتَاکِ اٜ ٻٜ مبِعَ، ‏«‏نٜطّٛ اٛعٛ اٜ جَٻّٛو غَطٛوٻٜ حَکّٜ حَا مَا اٜ مٛ ݧَمْدَ اٜ مَٻّٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","سٜيْ يٜىٰسُ حٛکِّٻٜ مِسَالُ طُعُمْ، وِعِ، ");
INSERT INTO fuv_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","‏«‏تٛ غٛطّٛ ندٜرْ مٛوطٛنْ اٜ وٛودِ بَالِ 100، غٛعٛ ندٜرْ بَالِ طِنْ مَجِّي، اٛ اَلَيْ کٛرِيطِ اٜ ندُرَ ندٜرْ لَدّٜ، اٛ طَٻِّتٛيَ مَجُّنغَ نغَنْ نَا اٛ حٜٻْتِينغَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","تٛ اٛ حٜٻْتٛيِينغَ، اٛ نَنَيْ بٜلْطُمْ اٛ تٛوٛيَنغَ اٜ دَاندٜ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","تٛ اٛ سٛعَّکٜ وُرٛ، اٛ نٛدَّيْ حِغٛوٻٜ مَاکٛ اٜ ٻٜ اٛ حٜدِّ، اٛ وِعَٻٜ، ‏‹‏مبَلّٜىٰيَمْ نَنْکِ بٜلْطُمْ نغَمْ مِ حٜٻْتِي مبَالَ اَمْ مَجُّنٛونغَ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","اٜ مِ وِعَعٛنْ، بٛ نٛنْ طُمْ ٻُرَيْ نَنْکِ بٜلْطُمْ اٜ تٛنْ دٛوْ تٛ غَطٛووٛ حَکّٜ غٛعٛتٛ تُوبِي سٛعَّکٜ تٛ اَللَّه، دٛوْ يِمْٻٜ 99 ݧُمٛوٻٜ نغَلَا حَکّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","‏«‏مِسَالُ، تٛ دٜبّٛ اٜ وٛودِ جَمْطٜ سَڤّٛ طٜ اَجُرْفَارِ، غٛعٛ مَجِّي، اَيْ اٛ وَطَيْ حِيتٜ اٜ فِتِلَارُ، اٛ وُووَ وُرٛ نغٛنْ، اٛ طَٻِّتَ اٜ سٜىٰسٜ‑سٜىٰسٜ کٛو تٛيٜ نَا اٛ حٜٻْتِي يَمْندٜ مَجُّندٜ ندٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","تٛ اٛ حٜٻْتِيندٜ، اٛ نٛدَّيْ حِغٛوٻٜ مَاکٛ اٜ ٻٜ اٛ حٜدِّ، اٛ وِعَٻٜ، ‏‹‏مبَلّٜىٰيَمْ نَنْکِ بٜلْطُمْ، نغَمْ مِ حٜٻْتِي يَمْندٜ اَمْ مَجُّنٛوندٜ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","اٜ مِ وِعَعٛنْ، بٛ نٛنْ مَلَاعِکَعٜنْ نَنِرْتَ بٜلْطُمْ يٜىٰسٛ اَللَّه تٛ غَطٛووٛ حَکّٜ غٛعٛتٛ اَلِي وَطُکِ حَکّٜ سٛعَّکٜ تٛ اَللَّه؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","کَدِمَا اٛ وِعِ، ‏«‏اٜ وٛودِ غٛطّٛ نٜطّٛ غٛودُطٛ ٻِٻّٜ طِطٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","ڤَمَرٛ اٛنْ وِعِ ݧَاکٛ مُوطُمْ، ‏‹‏بَڤَّ، حٛکَّمْ ندٛنُ اَمْ؞›‏ سٜيْ ݧَاکٛ اٛنْ سٜنْدَنِٻٜ جَوْدِ مُوطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","غَطَ بَلْطٜ سٜطَّ، ڤَمَرٛ اٛنْ حَوْتِ کٛ وٛودِ فُو، اٛ يَحِ لٜيْدِ نغٛطُّندِ، تٛنْ اٛ لَلِّنِ جَوْدِ مَاکٛ ندٜرْ جٛنْدٜ مٜىٰرٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","غَطَ اٛ لَلِّنِي جَوْدِ ندِنْ فُو، طُمْ وَطِ وٜىٰلٛ کَلُّنغٛ ندٜرْ لٜيْدِ ندِنْ، اٛ وَرْتِ مٛ وَلَا کٛو طُمٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","نغَمْ نٛنْ اٛ يَحِ اٛ حُوَنَ غٛطّٛ نٜطّٛ لٜيْدِ ندِنْ، نٜطّٛ اٛنْ يَارِمٛ تٛ اَلَدٜىٰجِ مَاکٛ حٛکِّمٛ کُوغَلْ ݧَمْنُکِطِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","کَيٜىٰجٛ اٛنْ اٜ يِطُنٛو تٛ اٛ حٜٻَيْنٛ اٛ ݧَامَ ݧَمْندُ اَلَدٜىٰجِ، اَمَّا وَلَا کٛکُّطٛمٛ غٛطُّمْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","ندٜ حَکِّيلٛ مَاکٛ وَرْتِ، اٛ وِعِ ندٜرْ ٻٜرْندٜ مَاکٛ، ‏‹‏کُوَنٛوٻٜ ݧَاکٛ اَمْ اٜ نغٛودِ ݧَمْندُ کٜپَيْندُٻٜ حَا ندُ حٛرٛو، اَمَّا مِنْ بٛو اٜ مِ طٛعٛ وٜىٰلٛ ٻَدَکٜ وَرْکِيَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","مِ سٛعّٛتٛ تٛ ݧَاکٛ اَمْ، مِ وِعَمٛ، ‏«‏بَڤَّ، مِ وَطِي حَکّٜ يٜىٰسٛ اَللَّه اٜ يٜىٰسٛ مَاطَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","مِ حٜوْتَايِ طُمْ نٛدَّيَمْ ٻِطّٛ مَاطَ، اٜ مِ تٛرٛمَا اَلَمْ مِ وَرْتَ غٛعٛتٛ ندٜرْ کُوَنٛوٻٜمَ؞»‏ ›‏ ");
INSERT INTO fuv_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","سٜيْ اٛ اُمِّي اٛ سٛعِّي تٛ ݧَاکٛ مَاکٛ؞ ‏«‏کٛ اٛ يٛتّٛو وُرٛ نغٛنْ، ݧَاکٛ مَاکٛ يِعِمٛ يُرْمِنَنِمٛ، دٛغِّ وُوندٛيِيمٛ جَٻِّيمٛ بٛطُّمْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","ٻِطّٛ اٛنْ وِعِمٛ، ‏‹‏بَڤَّ، مِ وَطِي حَکّٜ يٜىٰسٛ اَللَّه اٜ يٜىٰسٛ مَاطَ، جٛونِ مِ حٜوْتَايِ طُمْ نٛدَّيَمْ ٻِطّٛ مَاطَ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","اَمَّا ݧَاکٛ اٛنْ وِعِ مَشُّٻٜ مُوطُمْ، ‏‹‏نجَوْنٜىٰ نغَدّٛنْ لِمْشٜ ٻُرْطٜ وٛوطُکِ، ٻٛرْنٛنْمٛ؞ نغَطَنٜىٰمٛ جَبَّارٜ اٜ حٛوندُ مَاکٛ اٜ ڤَطٜ اٜ کٛيْطٜ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","نغَدّٜىٰ نغَارِ ڤَيْندِ، کِرْسٛنْدِ، ݧَامٜنْ نَنٜنْ بٜلْطُمْ، ");
INSERT INTO fuv_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","نغَمْ ٻِطّٛ اَمْ اٛعٛ، اٛ مَايِينٛ، اَمَّا اٛ اُمَّکٜ، اٛ مَجِّينٛ، اَمَّا اٛ حٜٻْتَامَ!‏›‏ سٜيْ ٻٜ ڤُطِّ ݧَامُکِ، اٜ ٻٜ نَنَ بٜلْطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","‏«‏اٜ شَرٜلْ نغٜلْ مَوْنِرَاوٛ اٛنْ اٜ تٛنْ نغٜسَ؞ سٜيْ اٜ مٛ وَرْتٛيَ، ندٜ اٛ ٻَدِي وُرٛ، اٛ نَنِ اٜ طُمْ فِيَ بَوْطِ اٜ طُمْ وَمَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","سٜيْ اٛ نٛدِّ غٛعٛتٛ ندٜرْ مَشُّٻٜ اٛ پَمِمٛ، اٛ وِعِ، ‏‹‏کٛ وَنْغِ؟›‏ ");
INSERT INTO fuv_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","مَشُّطٛ اٛنْ وِعِمٛ، ‏‹‏مِݧِرَاوٛ مَاطَ وَرْتِ، ݧَاکٛ مَاطَ بٛو حِرْسِي نغَارِ ڤَيْندِ نغَمْ اٛ وَرْتِي جَمْ کٛو کٛ يَنِمٛ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","ٻٜرْندٜ مَوْنِرَاوٛ اٛنْ مٜتِّ اٛ سَلِي نَتُّکِ وُرٛ نغٛنْ؞ ݧَاکٛ اٛنْ وُرْتٛيِي تٛرِيمٛ اٛ نَتَّ؞ ");
INSERT INTO fuv_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","اَمَّا اٛ وِعِ ݧَاکٛ اٛنْ، ‏‹‏رَا، دُوٻِ طُطِّ اٜ مِ حُوَنْمَا بٛ مَشُّطٛ، مِ مٜىٰطَايِ سَلَاکِ کٛ مبِيطَايَمْ، اَمَّا فُو اٜ نٛنْ اَ مٜىٰطَايِ حٛکُّکِيَمْ کٛو دَمْنغٜلْ غٛعٜلْ نغَمْ مِ نَنْدَ بٜلْطُمْ اٜ حِغٛوٻٜ اَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","اَمَّا ندٜ ٻِطّٛ مَاطَ اٛعٛ وَرْتٛيِ، ݧَامُطٛ جَوْدِ مَاطَ دٛوْ تٛکُّکِ رٜوْٻٜ، اَ حِرْسَنِيمٛ نغَارِ ڤَيْندِ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","‏«‏ݧَاکٛ اٛنْ وِعِمٛ، ‏‹‏ٻِطّٛ اَمْ، اَنْ اَ وٛنْدِ اٜ اَمْ کٛو ندٜيٜ، کٛ نغٛودُمِ فُو اَنْ جٜيِطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","اٜ حَانِ نَنٜنْ بٜلْطُمْ، نغَمْ مِݧِرَاوٛ مَاطَ اٛعٛ اٛ مَايِينٛ، اَمَّا جٛونِ اٛ اُمَّکٜ، اٛ مَجِّينٛ، اَمَّا جٛونِ اٛ حٜٻْتَامَ؞›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","يٜىٰسُ وِعِ تٛکُّٻٜمٛ، ‏«‏اٜ وٛودِ غٛطّٛ دِسْکُطٛ جٛوُطٛ غٛطّٛ دٛوْ جَوْدِ مُوطُمْ نغَمْ فَامَنَنْدِ؞ غٛطّٛ وِعِ دِسْکُطٛ اٛنْ، ‏‹‏اٛنْ طٛنْ مٛ نجٛوْطَا دٛوْ جَوْدِ مَاطَ اٜ مٛ وٛنَّندِ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","نغَمْ نٛنْ دِسْکُطٛ اٛنْ نٛدِّمٛ، وِعِمٛ، ‏‹‏کٛ نَنَيْمِ دٛوْ مَاطَ نِحِ؟ وِعَمْ نٛ نجٛغٛرِطَا جَوْدِ اَمْ نغَمْ دَغَ جٛونِ مِ اِتّٜتٜ دٛوْ جَوْدِ اَمْ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","ڤَامَنٛووٛ جَوْدِ اٛنْ وِعِ ندٜرْ ٻٜرْندٜ مُوطُمْ، ‏‹‏نٛ نغَطَيْمِ جٛونِ؟ رَا جٛومُ وُرٛ اَمْ رِيوَيْيَمْ دٛوْ کُوغَلْ نغَعَلْ، رَا بٛو مِ وَلَا سٜمْبٜ رٜمُکِ، مِ سٜمْتَيْ بٛو تٛرَاکِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","يَوَّا!‏ جٛونِ اٜ مِ اَنْدِ نٛ نغَطَيْمِ نغَمْ يِمْٻٜ نجَٻَيَمْ ندٜرْ غُرٜىٰجٜ مَٻّٜ تٛ مِ رِيوَامَ دَغَ کُوغَلْ نغَعَلْ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","سٜيْ اٛ لِلَنِ ٻٜ جٛومُ وُرٛ مَاکٛ تٛکَّتَ ݧَمَاندٜ، اٛ وِعِ اَرَنْدٜىٰجٛ، ‏‹‏نٛ جٛومُ وُرٛ اَمْ تٛکَّتَمَ؟›‏ ");
INSERT INTO fuv_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","اٛ وِعِمٛ، ‏‹‏ڤَالِ نٜبَّمْ جَيْتُنْ 800 تٛکّٜتٜىٰمِ؞›‏ ڤَامَنٛووٛ جَوْدِ اٛنْ وِعِمٛ، ‏‹‏جَٻُ طٜرٜوٛلْ ݧَمَاندٜ مَاطَ، يَوْنُ وِنْدُ 400؞›‏ ");
INSERT INTO fuv_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","ندٜنْ اٛ وِعِ طِطَٻٛ اٛنْ، ‏‹‏اَنْ بٛو، نٛيٜ تٛکّٜتٜطَا؟›‏ اٛ وِعِمٛ، ‏‹‏بُحُوجِ اَلْکَمَارِ 1,000 تٛکّٜتٜىٰمِ؞›‏ اٛ وِعِمٛ، ‏‹‏جَٻُ طٜرٜوٛلْ ݧَمَاندٜ مَاطَ وِنْدُ بُحُوجِ 800؞›‏ ");
INSERT INTO fuv_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","جٛومُ وُرٛ اٛنْ مَنِ ڤَامَنٛووٛ جَوْدِ مٛ وَلَا غٛونغَ اٛنْ، نغَمْ اٜ مٛ وٛودِ پٛيْرٜ؞ مِ حٛکُّعٛنْ مِسَالُ طُعُمْ نغَمْ اَنْدٛنْ يِمْٻٜ ٻٜ تٛکَّايِ اَللَّه ٻُرِي يِمْٻٜ تٛکُّٻٜمٛ پٛيْرٜ دٛوْ فِي دُونِيَارُ؞ ");
INSERT INTO fuv_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","‏«‏اٜ مِ وِعَعٛنْ، کُوتِرٜىٰ جَوْدِ دُونِيَارُ نغَمْ کٜٻٛنْ حِغٛوٻٜ، نغَمْ تٛ جَوْدِ ندِنْ رٜعِي، طُمْ جَٻَعٛنْ ندٜرْ وُرٛ اَللَّه نغٛ حَا اَبَدَا؞ ");
INSERT INTO fuv_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","فُو غَطُطٛ کٛ حَانِ اٜ فِي سٜطَّ، اٛ وَطَيْ کٛ حَانِ اٜ فِي طُطُّمْ؞ نٛنْ مَا مٛ وَلَا غٛونغَ دٛوْ فِي سٜطَّ وَطَتَا غٛونغَ دٛوْ فِي طُطُّمْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","تٛ اٛنْ نغَلَا غٛونغَ اٜ جٛغَاکِ جَوْدِ دُونِيَارُ، مٛيٜ حٛولٛتٛوعٛنْ اٜ جٛغَاکِ جَوْدِ غٛونغَارِ؟ ");
INSERT INTO fuv_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","تٛ اٛنْ نجٛغٛرَاکِ جَوْدِ غٛطّٛ غٛونغَ، مٛيٜ حٛکَّتَعٛنْ کٛ وَرْتَتَ طُمْ مٛوطٛنْ؟ ");
INSERT INTO fuv_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","‏«‏وَلَا مَشُّطٛ بَاوَيْطٛ جَغَّنَاکِ جٛومُ وُرٛعٜنْ طِطٛ؞ کٛو اٛ وَݧَ غٛعٛتٛ اٛ يِطَ غٛعٛتٛ، کٛو اٛ مَوْنِنَ غٛعٛتٛ اٛ يَوَنَ غٛعٛتٛ؞ نٛنْ اٛنٛنْ مَا اٛنْ مبَاوَتَا جَغَّنَاکِ اَللَّه اٜ جَغَّنَاکِ جَوْدِ شَرٜلْ غٛعٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","ندٜ فَارِسَنْکٛعٜنْ نَنِ فُو کٛ اٛ وِعِ، ٻٜ طُرْتِيمٛ نغَمْ ٻٜ غِطْٻٜ شٜىٰدٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","اٛ وِعِٻٜ، ‏«‏اٛنٛنْ نغٛنِ کٛلّٛوٻٜ کٛعٜ مٛوطٛنْ اٛنْ غَطٛوٻٜ کٛ حَانِ يٜىٰسٛ يِمْٻٜ، اَمَّا اَللَّه اٜ اَنْدِ ٻٜرْطٜ مٛوطٛنْ؞ نغَمْ کٛ يِمْٻٜ مَوْنِنْتَ اٜ حَرْمِنِ يٜىٰسٛ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","‏«‏اَتَّوْرَ اٜ دٜفْتٜ اَنَّبٛعٜنْ نغٛنِ کٛ طُمْ وَعَجِنْتَ حَا شَرٜلْ يَحَيَ غَطٛووٛ بَڤْتِسْمَ؞ دَغَ شَرٜلْ نغٜلْ، اٜ طُمْ اَنْدِنَ حَبَرُ بٜلْطُمْ دٛوْ لَامُ اَللَّه، کٛو مٛيٜ اٜ دُرْوَ نغَمْ حٜٻَ نَتُّکِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","اَمَّا فُو اٜ نٛنْ، طُمْ ٻُرَيْ حٛيُکِ دٛوْ اٜ لٜيْ رٜعَ اٜ دٛوْ تٛٻّٜلْ غٛعٜلْ نغٜلْ اَتَّوْرَ مَجِّنٜىٰ؞ ");
INSERT INTO fuv_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","‏«‏کٛو مٛيٜ يٛوفِ دٜبّٛ مُوطُمْ تٜعِ غٛطّٛ، نجٜىٰنُ اٛ وَطَتَ؞ نٜطّٛ تٜعُطٛ جٛوفَاطٛ مَا، نجٜىٰنُ اٛ وَطَتَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","‏«‏اٜ وٛودِ غٛطّٛ دِسْکُطٛ ٻٛرْنٛتٛوطٛ لِمْشٜ طٜ شٜىٰدٜ، اٜ مٛ ݧَامَ کٛ اٛ يِطِ کٛو ندٜيٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","اٜ دَمُّغَلْ وُرٛ مَاکٛ کٛو ندٜيٜ اٜ طُمْ وَدَّ غٛطّٛ مٛ وَلَنَا بِعٜتٜىٰطٛ لِعَاجَرُ اٜ مٛ وٛودِ ڤُتّٜ کٛو تٛيٜ اٜ ٻَنْدُ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","اٜ مٛ يِطِ ݧَامُکِ کٛ يَنِ اٜ لٜيْدِ دَغَ ندٜرْ ݧَمْندُ دِسْکُطٛ اٛنْ؞ کٛ ٻُرِ نٛنْ، کُتِيجِ مَا اٜ نغَرَ اٜ تَحَ ڤُتّٜ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","ندٜ مٛ وَلَنَا اٛنْ مَايِ، مَلَاعِکَعٜنْ نجَارِمٛ اٛ جٛوطٛو حَادٜ اَنَّبِ اِبْرَاهِمْ؞ دِسْکُطٛ اٛنْ مَا مَايِ اٛ اُوَا؞ ");
INSERT INTO fuv_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","اٛ نَتِّنَا حِيتٜ اٜ مٛ يَرَ بٛنٜ، سٜيْ اٛ پٜفْتِ غِتٜ مَاکٛ، اٛ يِعِ لِعَاجَرُ اٜ جٛوطِي حَادٜ اَنَّبِ اِبْرَاهِمْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","اٛ نٛدِّ اِبْرَاهِمْ اٜ سٜمْبٜ، اٛ وِعِ، ‏‹‏يَا اِبْرَاهِمْ، يُرْمِنَنَمْ، لِلٛيْ لِعَاجَرُ مبِعَامٛ اٛ سُووَ حٛوندُ مَاکٛ ندٜرْ ندِيَمْ اٛ فٜوْنَ طٜمْنغَلْ اَمْ نغَمْ اٜ مِ يَرَ بٛنٜ کَلُّطُمْ ندٜرْ حِيتٜ نغٜعٜ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","اِبْرَاهِمْ وِعِمٛ، ‏‹‏ٻِطّٛ اَمْ، سِفْتٛرْ شَرٜلْ کٛ نغٛنّٛطَا دُونِيَارُ اَ حٜٻِي کٛ نغِطَّا فُو، لِعَاجَرُ بٛو يَرِي بٛنٜ کَلُّطُمْ؞ اَمَّا جٛونِ اٜ مٛ نَنَ بٜلْطُمْ طٛعٛ، اَنْ بٛو اَ طٛنْ يَرَ بٛنٜ کَلُّطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","غَطَ نٛنْ، اٜ وٛودِ نغَيْکَ لُغُّکَ حَکُّندٜ مٜىٰطٜنْ؞ وَلَا بَاوَيْطٛ حُولَ دَغَ طٛعٛ يَحَ تٛ نغٛنْطَا، نٛنْ مَا دَغَ تٛ نغٛنْطَا وَلَا بَاوَيْطٛ حُولٛيَ تٛ اَمِنْ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","اَمَّا دِسْکُطٛ اٛنْ وِعِ، ‏‹‏اٜ مِ تٛرٛمَا، بَڤَّ، لِلُ لِعَاجَرُ تٛ وُرٛ ݧَاکٛ اَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","اٜ مِ وٛودِ مِݧِرَاٻٜ نجٛوٛ، اٜ مِ يِطِ اٛ يَحَ اٛ وَغِّنَٻٜ نغَمْ کَمْٻٜ مَا تٛع ٻٜ نغَرَ تٛ نجَرَيْمِ بٛنٜ کَلُّطُمْ طٛعٛ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","اَمَّا اِبْرَاهِمْ وِعِمٛ، ‏‹‏اٜ ٻٜ نغٛودِ اَتَّوْرَ اٜ دٜفْتٜ اَنَّبٛعٜنْ، اَلْ ٻٜ نغَطَ کٛ طٜ مبِعِ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","دِسْکُطٛ اٛنْ وِعِ، ‏‹‏نَاع نٛنْ، يَا اِبْرَاهِمْ، تٛ غٛطّٛ ندٜرْ مَيْٻٜ يَحَنِيٻٜ، ٻٜ تُوبَيْ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","اِبْرَاهِمْ وِعِمٛ، ‏‹‏تٛ ٻٜ نَنَايِ کٛ اَتَّوْرَ اٜ دٜفْتٜ اَنَّبٛعٜنْ مبِعَتَ، ٻٜ نجَٻَتَا کٛ اُمِّيطٛ دَغَ مَيْدٜ وِعِٻٜ؞›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","سٜيْ يٜىٰسُ وِعِ تٛکُّٻٜمٛ، ‏«‏دٛولٜ کٛ وَطَتَ يِمْٻٜ نغَطَ حَکّٜ وَرَ، اَمَّا غَطُطٛ غٛطّٛ وَطِ حَکّٜ يَرَيْ بٛنٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","طُمْ ٻُرَنَيْ نٜطّٛ اٛنْ حَٻَّنٜىٰ کَاپَ نَمٛلْ مَنْغَ اٜ دَاندٜ اٛ فَطّٜىٰ ندٜرْ ندِيَمْ مبٜىٰلَ، دٛوْ اٛ وَطَ غٛعٛتٛ ندٜرْ سُکَاٻٜ ڤَمَرْٻٜ ٻٜعٜ کٛولِيٻٜيَمْ وَطَ حَکّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","ڤَامَنٜىٰ کٛعٜ مٛوطٛنْ؞ ‏«‏تٛ بَنْدِرَاوٛ مَاطَ وَطَنِيمَ کٛ وٛوطَا، مٜتَنْمٛ؞ تٛ اٛ تُوبِي، يَافَنَمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","تٛ اٛ وَطَنِيمَ کٛ وٛوطَا ندٜ جٛوٜىٰطِطِ اٜ ݧَلْندٜ غٛعٛ، ندٜنْ ندٜ جٛوٜىٰطِطِ اٜ مٛ وَرَ تٛ مَاطَ اٜ مٛ وِعَ، ‏‹‏مِ تُوبِي،›‏ دٛولٜ نجَافَنٛطَامٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","لِلَاٻٜ يٜىٰسُ مبِعِمٛ، ‏«‏ٻٜيْدَنْمِنْ حٛولَاکِ اَللَّه!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","يٜىٰسُ نٛوتِي وِعِٻٜ، ‏«‏دَا اٛنْ نغٛودِ حٛولَاکِ فَمْطِرْکِ بٛ غَبّٜلْ مَسْتَتْ، اٛنْ مبَاوَيْ مبِعٛنْ لٜکِّ کِعِ، ‏‹‏طٛوفَ تِغّٛيٛطَا ندٜرْ ندِيَمْ،›‏ سٜيْ کِ وَطَ بٛ کٛ مبِيطٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","‏«‏مٛيٜ ندٜرْ مٛوطٛنْ غٛودُطٛ مَشُّطٛ دٜمَيْطٛ کٛو دُرَيْطٛ بَالِ، تٛ مَشُّطٛ اٛنْ وَرْتٛيِي دَغَ نغٜسَ اٛ وِعَمٛ، ‏‹‏وٛرٛيْ، جٛوطَ ݧَامَا ݧَمْندُ؟›‏ ");
INSERT INTO fuv_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","سَمْ وَلَا بِعٛووٛ نٛنْ، سٜيْ نِ اٛ وِعَمٛ، ‏‹‏ٻٛرْنَ لِمْشٜرٜ دٜفُکِ، ندٜفَنَايَمْ حِرَاندٜ، نغَدَّنَايَمْ، مِ ݧَامَ مِ يَرَ تَوْ، ندٜنْ ݧَامَا نجَرَا؞›‏ ");
INSERT INTO fuv_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","اٛنْ کَمّٛو اٛ يٜتَّيْ مَشُّطٛ اٛنْ نغَمْ اٛ وَطِي کٛ اٛ وِعِ؟ ");
INSERT INTO fuv_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","اَاعَ؞ نٛنْ اٛنٛنْ مَا، تٛ اٛنْ کُوِي کٛ طُمْ وِعِعٛنْ، اٛنْ مبِعَيْ، ‏‹‏مِنْ مَشُّٻٜ ٻٜ نغَلَا بٛتٜ؞ مِنْ نغَطِي کٛ حَانِ مِنْ نغَطَ تَنْ؞›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","يٜىٰسُ اٜ يَحَ اُرُشَلِيمَ، اٛ تٛکِّ کٜىٰرٛلْ لٜيْدِ سَمَارِيَ اٜ لٜيْدِ غَلِيلِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","اٜ مٛ نَتَّ وٛنْغٜلْ غَرِيٜلْ، سٜيْ يِمْٻٜ سَڤّٛ غٛودُٻٜ ݧَوُ ݧَامٛوجُمْ لَرَلْ کَوْرِ اٜ مَاکٛ، ٻٜ ندَرِي تٛ وٛطِّ؞ ");
INSERT INTO fuv_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ٻٜ نٛدِّ اٜ سٜمْبٜ، ٻٜ مبِعِ، ‏«‏يٜىٰسُ!‏ مَوْطٛ!‏ يُرْمِنَنْمِنْ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","ندٜ يٜىٰسُ يِعِٻٜ، اٛ وِعِٻٜ، ‏«‏نجَحٜىٰ اَرْدِيٻٜ دِينَ نغِعَعٛنْ؞»‏ اٜ ٻٜ ندٜرْ يَادُ، سٜيْ ٻٜ نجَمْطِتِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","ندٜ غٛعٛتٛ مَٻّٜ يِعِ يَمْطِتِي، اٛ سٛعِّي اٜ مٛ مَنْتَ اَللَّه اٜ سٜمْبٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","اٛ دِشِّي يٜىٰسٛ يٜىٰسُ، اٛ يٜتِّمٛ؞ کَنْکٛ بٛو اٛ سَمَارِيَنْکٜىٰجٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","يٜىٰسُ وِعِمٛ، ‏«‏نَاع اٛنٛنْ سَڤّٛ نجَمْطِتِ؟ تٛ نجٛوٜىٰنَيٛ ٻٜنْ نغٛنِ؟ ");
INSERT INTO fuv_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","وَلَا مٛ طُمْ حٜٻِ سٛعّٛيِي يٜتِّ اَللَّه سٜيْ کٛطٛ اٛعٛ تَنْ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","سٜيْ اٛ وِعِ سَمَارِيَنْکٜىٰجٛ اٛنْ، ‏«‏اُمَّ ندِلَّا؞ اَ يَمْطِتِي نغَمْ اَ حٛولَکٜيَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","وٛٻّٜ فَارِسَنْکٛعٜنْ پَمِ يٜىٰسُ ٻٜ مبِعِ، ‏«‏ندٜيٜ لَامُ اَللَّه وَرٛيْتَ؟»‏ اٛ وِعِٻٜ، ‏«‏طُمْ يِعَتَا لَامُ اَللَّه اٜ غِتٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","وَلَا بِعٛووٛ، ‏‹‏رَا لَامُ اَللَّه طٛعٛ،›‏ کٛو ‏‹‏رَا لَامُ اَللَّه تٛنْ نِي،›‏ نغَمْ لَامُ اَللَّه اٜ ندٜرْ مٛوطٛنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","سٜيْ اٛ وِعِ تٛکُّٻٜمٛ، ‏«‏بَلْطٜ اٜ نغَرَ کٛ کَاٻٛتٛنْ يِعُکِ ݧَلْندٜ وٛعٛيْرٜ ندٜرْ ݧَلْطٜ ٻِي نٜطّٛ، اَمَّا اٛنْ نغِعَتَا؞ ");
INSERT INTO fuv_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","اٜ شَرٜلْ نغٜلْ يِمْٻٜ مبِعَيْعٛنْ، ‏‹‏رَمّٛ طَاعٜ!‏›‏ کٛو بٛو، ‏‹‏رَمّٛ طٛعٛ!‏›‏ تٛع اٛنْ نجَحُ؞ تٛع اٛنْ تٛکُّٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","نٛ مَپّٜرٜ مَپِّرْتَ يِعٜىٰ کٛو تٛيٜ، نٛنْ غَرْتٛلْ ٻِي نٜطّٛ وَعَتَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","اَمَّا اَرَنْدٜ دٛولٜ اٛ يَرَ تٛرَّ کَلُّکَ، يِمْٻٜ جَامَنُ طُعُمْ نغَݧَمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","کٛ وَطُنٛ ندٜرْ جَامَنُ اَنَّبِ نُحُ، نٛنْ وَطٜتٜىٰ ندٜرْ بَلْطٜ کٛ ٻِي نٜطّٛ وَرْتٛيْتَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","يِمْٻٜ اٜ ݧَامَ، اٜ نجَرَ، اٜ تٜعَ، اٜ تٜعٜىٰ حَا شَرٜلْ کٛ اَنَّبِ نُحُ نَتِّ کٛمِوَلْ مَنْغَلْ، ندِيَمْ وَرِ حَلْکِٻٜ ٻٜ فُو؞ ");
INSERT INTO fuv_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","نٛنْ مَا نٛ طُمْ وَطُنٛ ندٜرْ جَامَنُ لُوتُ؞ يِمْٻٜ اٜ ݧَامَ، اٜ نجَرَ، اٜ شٛودَ، اٜ شٛورَ، اٜ ندٜمَ، اٜ مَحَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","اَمَّا ݧَلْندٜ ندٜ لُوتُ وُرْتِي دَغَ ندٜرْ غَرِيرِ سٛدٛمْ، طُمْ يٛوفٛيِ حِيتٜ اٜ کَاپٜ ݧَامٛوجٜ حِيتٜ دَغَ دٛوْ، نغٜ حَلْکِٻٜ ٻٜ فُو؞ ");
INSERT INTO fuv_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","نٛنْ وَطٜتٜىٰ ݧَلْندٜ ندٜ ٻِي نٜطّٛ وَنْغَتَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","‏«‏اٜ ݧَلْندٜ ندٜنْ غٛنْطٛ دٛوْ سُودُ فُو تٛع جِڤّٛيٛو نغَمْ حٛشُّکِ جَوْدِ مَاکٛ ندٜرْ سُودُ؞ غٛنْطٛ تٛ نغٜسَ بٛو تٛع سٛعّٛو وُرٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","شِفْتٛرٜىٰ دٜبّٛ لُوتُ!‏ ");
INSERT INTO fuv_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","کٛو مٛيٜ طَٻُّتُطٛ حِسْنَ يٛنْکِ مُوطُمْ دُلَّيْکِ، اَمَّا کٛو مٛيٜ دُلِّ يٛنْکِ مُوطُمْ نغَمْ اَمْ حِسْنَيْکِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","اٜ مِ وِعَعٛنْ، اٜ جٜمَّارٜ ندٜنْ يِمْٻٜ طِطٛ ڤُکّٛدٛتٛ دٛوْ لٜىٰسٛ غٛعٛ طُمْ حٛشَّ غٛعٛتٛ، طُمْ اَلَ غٛعٛتٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","رٜوْٻٜ طِطٛ اٜ نَمِدَ، طُمْ حٛشَّ غٛعٛتٛ، طُمْ اَلَ غٛعٛتٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","‏‏يِمْٻٜ طِطٛ اٜ کُوَ ندٜرْ نغٜسَ، طُمْ حٛشَّ غٛعٛتٛ، طُمْ اَلَ غٛعٛتٛ؞‏»‏ ");
INSERT INTO fuv_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","تٛکُّٻٜمٛ مبِعِمٛ، ‏«‏مٛودِبّٛ، تٛيٜ فِي طُعُمْ وَطَتَ؟»‏ اٛ وِعِٻٜ، ‏«‏تٛ بَاتُطُمْ وٛنِ، طٛنْ جِغَاجٜ کَوْرِتَتَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","سٜيْ يٜىٰسُ حٛکِّ تٛکُّٻٜمٛ مِسَالُ طُعُمْ نغَمْ اٛ حٛلَّٻٜ ٻٜ نغَطَ کَ وَطُکِ دٛعَارٜ تٛع ٻٜ شٛمَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","اٛ وِعِ، ‏«‏اٜ وٛنْدِ غَرِيرِ اٜ وٛودِ غٛطّٛ اَلْکَالِيجٛ مٛ حُلَتَا اَللَّه اٛ وَنَّا اٜ يِمْٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","اٜ وٛودِ غٛطّٛ دٜبّٛ ندٜرْ غَرِيرِ ندِنْ غٛرْکٛ مَاکٛ مَايِ؞ کٛو ندٜيٜ اٜ مٛ يَحَ تٛ اَلْکَالِيجٛ اٛنْ اٜ مٛ تٛرٛومٛ اٜ مٛ وِعَ، ‏‹‏وَطُ کٛ حَانِ حَکُّندٜ اَمْ اٜ غَݧٛ اَمْ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","اَلْکَالِيجٛ اٛنْ نٜىٰٻِ جَٻَايِ؞ اَمَّا غَطَ طٛنْ اٛ وِعِ ندٜرْ ٻٜرْندٜ مَاکٛ، ‏‹‏کٛو ندٜ مِ حُلَتَا اَللَّه، کَدِنْ مِ وَنَّا اٜ کٛو مٛيٜ، ");
INSERT INTO fuv_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","اَمَّا نغَمْ دٜبّٛ اٛعٛ اٜ وَنَّيَمْ، مِ وَطَنَيْمٛ کٛ حَانِ، نغَمْ تٛع اٛ وَطَ مِ سٛمَ اٜ غَرٛلْ مَاکٛ؞›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","ندٜنْ يٜىٰسُ وِعِ، ‏«‏نَنٜىٰ کٛ اَلْکَالِيجٛ اٛعٛ مٛ حُلَتَا جٛومِرَاوٛ وِعِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","اٜ يِعُکِ مٛوطٛنْ اَللَّه وَطَنْتَا شُٻَاٻٜ مُوطُمْ تٛرٛتٛوٻٜمٛ جٜمَّ اٜ ݧَلَوْمَ کٛ حَانِ؟ اٛ نٜىٰٻَيْ اٛ وَلَّايِٻٜ؟ ");
INSERT INTO fuv_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","اٜ مِ وِعَعٛنْ، اٛ يَاوَيْ وَطَنْکِٻٜ کٛ حَانِ؞ اَمَّا تٛ ٻِي نٜطّٛ وَرْتٛيِي، اٛ تَوَيْ کٛولِيٻٜمٛ ندٜرْ دُونِيَارُ بٛو؟»‏ ");
INSERT INTO fuv_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","اٜ وٛودِ نغِعٛوٻٜ کٛعٜ مُعّٜنْ ٻٜ غَطٛوٻٜ کٛ اَللَّه يِطِ، اٜ ٻٜ نجَوَنَ وٛٻّٜ؞ يٜىٰسُ حٛکِّٻٜ مِسَالُ طُعُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","اٛ وِعِ، ‏«‏يِمْٻٜ طِطٛ نجَحِ وُرٛ شٜنِينغٛ نغَمْ ٻٜ نغَطَ دٛعَارٜ، غٛعٛتٛ فَارِسَنْکٜىٰجٛ، غٛعٛتٛ بٛو جَٻٛووٛ شٜىٰدٜ لٜيْدِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","فَارِسَنْکٜىٰجٛ اٛنْ دَرِي، وَطِ دٛعَارٜ ندٜرْ ٻٜرْندٜ مُوطُمْ وِعِ، ‏‹‏اَللَّه، مِ يٜتِّيمَ نغَمْ مِ وَطَتَا کٛ وٛٻّٜ يِمْٻٜ نغَطَتَ، بٛ وُيْٻٜ، اٜ غَطٛوٻٜ کٛ وٛوطَا، اٜ غَطٛوٻٜ نجٜىٰنُ، کٛو مَا بٛ جَٻٛووٛ شٜىٰدٜ لٜيْدِ اٛعٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","اٜ مِ سُومٛو ندٜ طِطِ ندٜرْ يٛنْتٛورٜ غٛعٛ، ندٜنْ اٜ مِ اِتَّ جَکَّ ندٜرْ کٛ کٜٻُمِ فُو؞›‏ ");
INSERT INTO fuv_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","اَمَّا جَٻٛووٛ شٜىٰدٜ لٜيْدِ اٛنْ دَرِي تٛ وٛطِّ؞ اٛ رَارَايِ دٛوْ، اٜ مٛ رٛنْدِ جُوطٜ مَاکٛ دٛوْ حٛورٜ، اٜ مٛ وِعَ، ‏‹‏يَا اَللَّه، يُرْمِنَنَمْ، مِ وَطِي حَکّٜ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","اٜ مِ وِعَعٛنْ، جَٻٛووٛ شٜىٰدٜ لٜيْدِ اٛنْ حٛوتِي وُرٛ اٛ جَافَنَاطٛ حَکّٜ مَاکٛ، اَمَّا فَارِسَنْکٜىٰجٛ اٛنْ يَافَنَاکَ؞ نغَمْ کٛو مٛيٜ مَوْنِنْطٛ حٛورٜ مُوطُمْ اٛ ڤَمْطِنْتٜىٰطٛ، ندٜنْ لٜسْتِنْطٛ حٛورٜ مُوطُمْ بٛو اٛ مَوْنِنْتٜىٰطٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","يِمْٻٜ اٜ نغَدَّنَ يٜىٰسُ سُکَحٛيْ مَٻّٜ ڤَمَرٛيْ نغَمْ اٛ بَرْکِطِنَکٛيْ، اَمَّا ندٜ تٛکُّٻٜمٛ نغِعِ نٛنْ، ٻٜ کَٻَنِٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","اَمَّا يٜىٰسُ نٛدِّ سُکَحٛيْ کٛيْ تٛ مُوطُمْ، وِعِ، ‏«‏اَلٜىٰ سُکَحٛيْ ڤَمَرٛيْ نغَرَ تٛ اَمْ؞ تٛع اٛنْ کَطُکٛيْ، نغَمْ غٛودُٻٜ ٻٜرْطٜ اِرِ طٜ مَاکٛيْ نجٜيِ لَامُ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","اٜ مِ وِعَعٛنْ غٛونغَ، کٛو مٛيٜ مٛ جَٻَايِ لَامُ اَللَّه بٛنٛ سُکَيٜلْ ڤَمَرٜلْ، اٛ نَتَّتَا لَامُ طُمْ کٛو سٜطَّ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","سٜيْ غٛطّٛ لَامِيطٛ پَمِمٛ وِعِ، ‏«‏مٛودِبّٛ غٜىٰتٛ، کٛ حَانِ مِ وَطَ مِ حٜٻَ يٛنْکِ کِ رٜعَتَا؟»‏ ");
INSERT INTO fuv_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","يٜىٰسُ نٛوتِي، وِعِمٛ، ‏«‏نغَمْ طُمٜ نٛدِّرْطَايَمْ غٜىٰتٛ؟ وَلَا غٜىٰتٛ سٜيْ اَللَّه تَنْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","اَ اَنْدِ کٛ اَتَّوْرَ وِعِ، ‏‹‏تَاع وَطُ نجٜىٰنُ؞ تَاع وَطُ وَرْحٛورٜ؞ تَاع وُجُّ؞ تَاع حٛکُّ شٜيْدَ فٜوْرٜ؞ حٛکُّ ݧَاکٛ مَاطَ اٜ مَدُوجٛ مَاطَ مَنْغُ؞›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","اٛ وِعِ، ‏«‏اٜ مِ وَطَ فِي طُعُمْ فُو دَغَ اٜ مِ سُکَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","ندٜ يٜىٰسُ نَنِ نٛنْ، وِعِمٛ، ‏«‏حَا جٛونِ حٛرَنِمَا فِي غٛعٛ؞ سٛورُ کٛ نغٛودُطَا فُو، شٜنْدَنَا ٻٜ نغَلَنَا شٜىٰدٜ طٜنْ، ندٜنْ اَ حٜٻَيْ مبَرْجَارِ تٛنْ دٛوْ؞ ندٜنْ نغَرَا، تٛکَّايَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","ندٜ اٛ نَنِ نٛنْ، اٛ نَنَايِ بٜلْطُمْ، نغَمْ اٜ مٛ وٛودِ رِسْکُ طُطُّمْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","يٜىٰسُ رَارِمٛ وِعِ، ‏«‏اٜ طُمْ سَطِ نَاع سٜطَّ دِسْکُطٛ نَتَّ لَامُ اَللَّه!‏ ");
INSERT INTO fuv_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","طُمْ ٻُرَيْ حٛيْکِ نغٜىٰلٛوبَ تٛکَّ ندٜرْ يٛلْندٜ بَاتَلْ دٛوْ دِسْکُطٛ نَتَّ لَامُ اَللَّه؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","نَنُٻٜ کٛ اٛ وِعِ مبِعِمٛ، ‏«‏تٛو، تٛ طُمْ نٛنْ، مٛيٜ حِسَتَ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","يٜىٰسُ وِعِٻٜ، ‏«‏کٛ يِمْٻٜ مبَاوَتَا وَطُکِ، اَللَّه وَاوَيْ وَطُکِطُمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","بِيتُرُسْ وِعِمٛ، ‏«‏رَطُّمْ، مِنْ اَلِي کٛ مِنْ نغٛودِ فُو مِنْ تٛکِّيمَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","يٜىٰسُ وِعِٻٜ، ‏«‏اٜ مِ وِعَعٛنْ غٛونغَ، کٛو مٛيٜ اَلُطٛ وُرٛ مُوطُمْ، کٛو دٜبّٛ مُوطُمْ، کٛو سَکِرَاٻٜ مُوطُمْ، کٛو دَݧٛوٻٜ مُوطُمْ، کٛو ٻِٻّٜ مُوطُمْ، نغَمْ لَامُ اَللَّه، ");
INSERT INTO fuv_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","اٛ حٜٻَيْ کٛ ٻُرِ نٛنْ طُوطُکِ ندٜرْ جَامَنُ طُعُمْ، ندٜنْ تٛ اٛ مَايِي اٛ حٜٻَيْ يٛنْکِ کِ رٜعَتَا؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","سٜيْ يٜىٰسُ نٛدِّ تٛکُّٻٜمٛ سَڤّٛ اٜ طِطٛ، ٻٜ کَکِّتِي اٛ وِعِٻٜ، ‏«‏رَطُّمْ، اٜنْ نجَحَيْ اُرُشَلِيمَ، ندٜنْ کٛو طُمٜ کٛ اَنَّبٛعٜنْ مبِنْدِ دٛوْ ٻِي نٜطّٛ طُمْ حٜىٰوَيْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","طُمْ نَنْغَيْمٛ، طُمْ حٛکِّتِرَمٛ ندٜرْ جُوطٜ حٜىٰفٜرْٻٜ، ٻٜ نجُکِّتَمٛ، ٻٜ کُطَمٛ، ٻٜ تُتَّنَمٛ جٛودٜ، ");
INSERT INTO fuv_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ٻٜ ڤِيَمٛ، ٻٜ مبَرَمٛ؞ ندٜنْ ݧَلْندٜ تَتَوْرٜ اٛ اُمّٛتٛ دَغَ مَيْدٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","تٛکُّٻٜمٛ سَڤّٛ اٜ طِطٛ ٻٜنْ ڤَامَايِ کٛ اٛ وِعِ دٛوْ حٛورٜ مَاکٛ؞ فَامُ طُمْ سُوطَنَکٜٻٜ، ٻٜ کٜٻْتَايِ دٛوْ طُمٜ اٛ مٜتَتَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","ندٜ يٜىٰسُ ٻَدِي يٛتَّاکِ غَرِيرِ جٜرِيکٛ، غٛطّٛ بُمْطٛ اٜ جٛوطِي حَادٜ طَتَلْ اٜ تٛرٛو؞ ");
INSERT INTO fuv_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","ندٜ بُمْطٛ اٛنْ نَنِ يِمْٻٜ طُطْٻٜ اٜ پَٻّٛو، اٛ پَمِ، ‏«‏کٛ وَنْغِ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","ٻٜ مبِعِمٛ، ‏«‏يٜىٰسُ نَجَرَنْکٜىٰجٛ پَٻّٛتٛو؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","اٛ نٛدِّ اٜ سٜمْبٜ، اٛ وِعِ، ‏«‏يٜىٰسُ، ٻِطّٛ دَوْدَ، يُرْمِنَنَمْ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","جَحٛوٻٜ يٜىٰسٛ يٜىٰسُ کَٻَنِمٛ مبِعِمٛ اٛ دٜعِّتَ، اَمَّا اٛ ٻٜيْدِ نٛدُّکِ اٜ سٜمْبٜ، اٜ مٛ وِعَ، ‏«‏ٻِطّٛ دَوْدَ، يُرْمِنَنَمْ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","نغَمْ نٛنْ يٜىٰسُ دَرِي وِعِ طُمْ وَدَّ بُمْطٛ اٛنْ تٛ مَاکٛ؞ ندٜ اٛ ٻَدّٛيِي حَادٜ، يٜىٰسُ پَمِمٛ، وِعِ، ");
INSERT INTO fuv_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","‏«‏طُمٜ نغِطَّا مِ وَطَنْمَا؟»‏ اٛ وِعِ، ‏«‏مٛودِبّٛ، اٜ مِ يِطِ مبُمْتِنَايَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","سٜيْ يٜىٰسُ وِعِمٛ، ‏«‏وُمْتُ!‏ حٛولَارٜ مَاطَ يَمْطِتِنِيمَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","طٛنْ اٜ طٛنْ غِتٜ مَاکٛ مبُمْتِ، اٛ تٛکِّ يٜىٰسُ، اٜ مٛ مَنْتَ اَللَّه؞ ندٜ وٛنْٻٜ طٛنْ فُو نغِعِ کٛ وَطِ، کَمْٻٜ مَا ٻٜ مَنْتِ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","يٜىٰسُ نَتِّ جٜرِيکٛ اٜ مٛ پَٻّٛو ندٜرْ غَرِيرِ ندِنْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","اٜ وٛودِ غٛطّٛ نٜطّٛ تٛنْ مَوْطٛ جَٻٛوٻٜ شٜىٰدٜ لٜيْدِ، بِعٜتٜىٰطٛ جَکَّ، اٛ دِسْکُطٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","اٜ مٛ يِطِ اٛ يِعَ مٛيٜ وٛنِ يٜىٰسُ، اَمَّا اٛ وَاوَايِ نغَمْ يِمْٻٜ طُوطِي، کَدِمَا اٛ دَمُّطٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","سٜيْ اٛ دٛغِّ اٛ اَرْدِي اٛ پٜىٰݝِ لٜکِّ نغَمْ اٛ يِعَ يٜىٰسُ، نغَمْ طٛنْ يٜىٰسُ پِوَتَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","ندٜ يٜىٰسُ يٛتِّي وِغٜىٰرٜ ندٜنْ تِجِّي وِعِمٛ، ‏«‏جَکَّ، يَوْنُ نجِڤّٛيٛطَا نغَمْ حَنْدٜ وُرٛ مَاطَ مبَالَيْمِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","سٜيْ جَکَّ يَوْنِ، جِڤّٛيِي، جَٻِّيمٛ اٜ وٜلْوٜلْتَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","ندٜ يِمْٻٜ نغِعِ يٜىٰسُ يَحِ وُرٛ مَاکٛ، ٻٜ فُو ٻٜ نغَطِ کَ مٜتِتَاکِ اٜ ٻٜ مبِعَ، ‏«‏اٛ وَالَيْ وُرٛ نٜطّٛ غَطٛووٛ حَکّٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","اَمَّا جَکَّ اُمِّي وِعِ يٜىٰسُ، ‏«‏مٛودِبّٛ، مِ حٛکَّيْ ٻٜ نغَلَنَا سٜنْدٜرٜ جَوْدِ اَمْ؞ کَدِمَا تٛ اٜ وٛودِ ٻٜ نجَٻَنْمِ غٛطُّمْ کٛ حَانَا فُو، مِ يٛٻَيْٻٜ کٛ نجَٻَنْمِٻٜ ندٜ نَيِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","يٜىٰسُ وِعِمٛ، ‏«‏حَنْدٜ کِسْندَمْ وَرِي ندٜرْ وُرٛ نغٛعٛ، نغَمْ کَنْکٛ مَا اٛ ٻِطّٛ اِبْرَاهِمْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","نغَمْ ٻِي نٜطّٛ وَرٛيِي طَٻِّتَ کٛ مَجِّ حِسْنَطُمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","اٜ ٻٜ ندٜرْ نَنُکِ کٛ اٛ وِعَتَٻٜ، سٜيْ اٛ حٛکِّٻٜ مِسَالُ طُعُمْ نغَمْ اٛ ٻَدَکٜ اُرُشَلِيمَ، کَدِمَا نغَمْ يِمْٻٜ اٜ کَمّٛو لَامُ اَللَّه وَنْغَيْ طٛنْ اٜ طٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","اٛ وِعِ، ‏«‏غٛطّٛ نٜطّٛ مَوْطٛ يَحَيْ وٛنْدِ غَرِيرِ غٛطُّندِ نغَمْ طُمْ لَمْنَمٛ اٛ سٛعّٛيٛو؞ ");
INSERT INTO fuv_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","اٛ نٛدِّ مَشُّٻٜ مَاکٛ کَمْٻٜ سَڤّٛ، اٛ حٛکِّ کٛو مٛيٜ مَٻّٜ شٜىٰدٜ طٜ کُوٛووٛ حٜٻَتَ ندٜرْ لٜبِّ تَتِ، اٛ وِعِٻٜ، ‏‹‏شٛودٜىٰ شٛورِتٛوطٛنْ اٜ شٜىٰدٜ طٜعٜ نَا مِ وَرْتٛيِي؞›‏ ");
INSERT INTO fuv_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","اَمَّا يِمْٻٜ لٜيْدِ مَاکٛ نغِطَامٛ، سٜيْ ٻٜ لِلِ لِلَاٻٜ غَطَ اٛ دِلِّي ٻٜ مبِعَ، ‏‹‏مِنْ نغِطَا نٜطّٛ اٛعٛ لَامٛو لٜيْدِ اَمِنْ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","‏«‏ندٜ اٛ لَمْنَا اٛ سٛعِّي وُرٛ، اٛ وِعِ طُمْ نٛدَّنَمٛ مَشُّٻٜ ٻٜنْ طٛنْ ٻٜ اٛ حٛکُّنٛو شٜىٰدٜ، نغَمْ اٛ يِعَ ٻٜيْدَارِ نٛيٜ اٛ حٜٻِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","اَرَنْدٜىٰجٛ اٛنْ وَرٛيِ وِعِ، ‏‹‏جٛومُ وُرٛ، شٜىٰدٜ مَاطَ ٻٜيْدَکٜ ندٜ سَڤّٛ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","اٛ وِعِمٛ، ‏‹‏اَ حُوِي بٛطُّمْ، اَ مَشُّطٛ بٛطّٛ؞ ندٜ اَ حٛلِّي غٛونغَ مَاطَ دٛوْ فِي ڤَمَرُمْ، اَ لَامٛتٛ غَرِيجٜ سَڤّٛ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","طِطَٻٛ وَرِ، وِعِمٛ، ‏‹‏جٛومُ وُرٛ، شٜىٰدٜ مَاطَ ٻٜيْدَکٜ ندٜ جٛوِ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","جٛومُ وُرٛ اٛنْ وِعِمٛ، ‏‹‏اَنْ، اَ لَامٛتٛ غَرِيجٜ جٛوِ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","غٛطّٛ وَرٛيِ وِعِ، ‏‹‏جٛومُ وُرٛ، رَا شٜىٰدٜ مَاطَ طٜ کَٻُّمِ ندٜرْ لِمْشٜرٜ شُوطُمِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","اٜ مِ حُلُمَا نغَمْ اَ نٜطّٛ شَطَنْطٛ؛ اَ حٛشَّ کٛ اَ رٜسَايِ، اَ فٜعَّ کٛ اَ اَاوَايِ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","جٛومُ وُرٛ اٛنْ وِعِمٛ، ‏‹‏اَنْ، اَ مَشُّطٛ کَلُّطٛ؞ کٛ مبِيطَا اٜ حٛنْدُکٛ مَاطَ نَنْغِيمَ!‏ اٜ يِيکِ مَاطَ مِ نٜطّٛ شَطَنْطٛ؟ اَ ݧُمَ اٜ مِ حٛشَّ کٛ مِ رٜسَايِ، اٜ مِ فٜعَّ کٛ مِ اَاوَايِ؟ ");
INSERT INTO fuv_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","تٛ طُمْ نٛنْ، کٛ وَطِ اَ رٜسَنَايِيَمْ شٜىٰدٜ تٛ طٜ کُوتِرْتٜىٰ طٜ ٻٜيْدٛو، نغَمْ تٛ مِ وَرْتٛيِي مِ تَوَ طٜ ٻٜيْدَکٜ؟›‏ ");
INSERT INTO fuv_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","اٛ وِعِ دَرِيٻٜ حَادٜ طٛنْ، ‏‹‏نجَٻٜىٰ شٜىٰدٜ طٜنْ تٛ مَاکٛ، کٛکّٛنْطٜ اٛنْ طٛنْ ٻٜيْدُطٛ شٜىٰدٜ مُوطُمْ ندٜ سَڤّٛ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","ٻٜ مبِعِمٛ، ‏‹‏جٛومُ وُرٛ، اَيْ اٛنْ طٛنْ شٜىٰدٜ مَاکٛ ٻُرِي طٜ اٛعٛ طُوطُکِ ندٜ سَڤّٛ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","‏‹‏نٛنْ بٛو اٜ مِ وِعَعٛنْ، فُو غٛودُطٛ طُمْ ٻٜيْدَنَيْمٛ؞ اَمَّا مٛ وَلَا غٛطُّمْ، کٛو کٛ اٛ وٛودِ مَا طُمْ جَٻَيْطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","ٻٜنْ طٛنْ وَݧْوَݧْٻٜ اَمْ بٛو ٻٜ نغِطَا مِ لَامٛو دٛوْ مَٻّٜ، نغَدّٜىٰٻٜ طٛعٛ، مبَرٛنْٻٜ يٜىٰسٛ اَمْ؞›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","ندٜ يٜىٰسُ وِعِ نٛنْ، اٛ نَنْغِ لَاوٛلْ يَاکِ اُرُشَلِيمَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","ندٜ اٛ ٻَدِي غَرِيجٜ بٜتَفَاجِ اٜ بٜتَنِ تٛ حٛشّٜىٰرٜ ندٜ لٜطّٜ جَيْتُنْ، سٜيْ اٛ لِلِ تٛکُّٻٜمٛ طِطٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","اٛ وِعِٻٜ، ‏«‏نجَحٜىٰ ندٜرْ غَرِيٜلْ غٛنْغٜلْ يٜىٰسٛ مٛوطٛنْ؞ اٜ نَتُّکِ مٛوطٛنْ، اٛنْ تَوَيْ مبَبَّ مٛلَ اٜ نغَ حَٻِّي، طُمْ مٜىٰطَايِ وَطَّاکِنغَ؞ ڤِتّٛيٜىٰنغَ نغَدّٛنْغَ طٛعٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","تٛ غٛطّٛ پَمِيعٛنْ کٛ وَطِ ڤِتّٛتٛنْغَ، مبِعٜىٰمٛ، ‏‹‏مٛودِبّٛ اٜ يِطِ حُوتِرْکِنغَ؞›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","سٜيْ لِلَاٻٜ ٻٜنْ نجَحِ تَوِ مبَبَّ نغَنْ نٛنْ نٛ اٛ وِعِرِٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","اٜ ٻٜ ڤِتَّنغَ، سٜيْ جٛومِيغَ وَرِ وِعِٻٜ، ‏«‏نغَمْ طُمٜ ڤِتّٛتٛنْغَ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","ٻٜ مبِعِمٛ، ‏«‏مٛودِبّٛ اٜ يِطِ حُوتِنِرَنغَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","ٻٜ نجَارَنِنغَ يٜىٰسُ، ٻٜ مبٜعِّتِ شُدَّارِ مَٻّٜ دٛوْ مَغَّ، ٻٜ کٛشِّمٛ ٻٜ نجٛوِمٛ دٛوْ مَاغَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","اٜ مٛ ندٜرْ يَادُ دٛوْ مبَبَّ نغَنْ، يِمْٻٜ نغَطِ کَ وٜعُّتُکِ شُدَّارِ مَٻّٜ دٛوْ طَتَلْ نغَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","ندٜ اٛ ٻَدِي اُرُشَلِيمَ تٛ رٜغٛرْدٜ حٛشّٜىٰرٜ ندٜ لٜطّٜ جَيْتُنْ، حَوْرُتُٻٜ تٛکُّٻٜمٛ ڤُطِّ وٜلْوٜلْتُکِ اٜ مَنْتَ اَللَّه اٜ سٜمْبٜ نغَمْ کُوطٜ کُلْنِيطٜ فُو طٜ ٻٜ نغِعِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","اٜ ٻٜ مبِعَ، ‏«‏اٛ بَرْکِطِنَاطٛ لَامِيطٛ غَرٛيْطٛ ندٜرْ اِنْدٜ جٛومِرَاوٛ!‏ جَمْ اٜ تٛنْ دٛوْ، اٜنْ مَوْنِنْ اَللَّه!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","سٜيْ وٛٻّٜ فَارِسَنْکٛعٜنْ ندٜرْ حَوْرُتُٻٜ ٻٜنْ مبِعِ يٜىٰسُ، ‏«‏مٛودِبّٛ، حَٻَنْ تٛکُّٻٜمَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","اٛ وِعِٻٜ، ‏«‏اٜ مِ وِعَعٛنْ، تٛ ٻٜ ندٜعِّتِي، کَاپٜ طٜعٜ مَنْتَيْ اَللَّه اٜ سٜمْبٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","ندٜ يٜىٰسُ ٻَدِّي اُرُشَلِيمَ يِعِ غَرِيرِ ندِنْ، اٛ وٛيَنِندِ، ");
INSERT INTO fuv_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","اٜ مٛ وِعَ، ‏«‏دَا اَ اَنْدُنٛو حَنْدٜ کٛ وَدَّتَ جَمْ!‏ اَمَّا طُمْ سُوطَنَکٜ غِتٜ مَاطَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","نغَمْ بَلْطٜ نغَرٛيَيْ طٜ وَݧْوَݧْٻٜ مَاطَ ڤِلٛتٛمَا ٻٜ ٻِطُّمَا کٛو تٛيٜ مَاطَ، ");
INSERT INTO fuv_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","ٻٜ ندٛعُّمَا اٜ لٜيْدِ، اَنْ اٜ ٻِٻّٜ مَاطَ وٛنْٻٜ ندٜرْ مَاطَ، ٻٜ اَلَتَا وٛنْدٜ حَيْرٜ دٛوْ وٛنْدٜ ندٜرْ مَاطَ، نغَمْ اَ اَنْدِتَايِ شَرٜلْ نغٜلْ اَللَّه وَرِ حِسْنُکِمَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","يٜىٰسُ نَتِّ وُرٛ شٜنِينغٛ، اٛ فُطِّ رِيوُکِ ٻٜ سٛورٜ‑سٛورٜ، ");
INSERT INTO fuv_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","اٛ وِعِٻٜ، ‏«‏طُمْ وِنْدَامَ اَللَّه وِعِ، ‏‹‏طُمْ نٛدِّرَيْ وُرٛ اَمْ وُرٛ دٛعَارٜ،›‏ اَمَّا اٛنْ نغَرْتِرِينغٛ لُورٛ وُيْٻٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","کٛو ندٜيٜ اٜ مٛ اٜکِّتِنَ ندٜرْ وُرٛ شٜنِينغٛ، اَمَّا مَوْٻٜ اَرْدِيٻٜ دِينَ اٜ مٛودِٻّٜ اَتَّوْرَ اٜ اَرْدِيٻٜ يِمْٻٜ اٜ نغَطِ کَ طَٻُّتُکِ نٛ ٻٜ مبَرْدَتَمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","اَمَّا ٻٜ کٜٻَايِ نٛ ٻٜ نَنْغِرْتَمٛ، نغَمْ يِمْٻٜ فُو اٜ کٜتِّندِ اٜ نَنَمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","وٛنْدٜ ݧَلْندٜ، يٜىٰسُ اٜ اٜکِّتِنَ يِمْٻٜ ندٜرْ وُرٛ شٜنِينغٛ، اٜ مٛ وَعَجِنَ حَبَرُ بٜلْطُمْ، سٜيْ مَوْٻٜ اَرْدِيٻٜ دِينَ اٜ مٛودِٻّٜ اَتَّوْرَ اٜ مَوْٻٜ يِمْٻٜ نغَرِ تٛ مَاکٛ، ");
INSERT INTO fuv_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ٻٜ مبِعِمٛ، ‏«‏اٜ لَامُ مٛيٜ نغَطَتَا کُوطٜ طٜعٜ؟ مٛيٜ حٛکُّمَا لَامُ طُمْ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","اٛ وِعِٻٜ، ‏«‏مِنْ مَا مِ پَمَيْعٛنْ، جٛونِ مبِعٜىٰيَمْ، ");
INSERT INTO fuv_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","بَڤْتِسْمَ طُمْ يَحَيَ وَطِ، تٛ اَللَّه طُمْ پِوٛيِ کٛو تٛ يِمْٻٜ طُمْ پِوٛيِ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","سٜيْ ٻٜ مٜدِّ حَکُّندٜ مَٻّٜ، ٻٜ مبِعِ، ‏«‏تٛ اٜنْ مبِعِي، ‏‹‏دَغَ تٛ اَللَّه طُمْ پِوٛيِ،›‏ اٛ وِعَيْ، ‏‹‏کٛ وَطِ اٛنْ جَٻَايِ کٛ اٛ وِعِ؟›‏ ");
INSERT INTO fuv_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","تٛ بٛو اٜنْ مبِعِي، ‏‹‏تٛ يِمْٻٜ طُمْ پِوٛيِ،›‏ يِمْٻٜ ٻٜعٜ فُو کُبٛرْتٛعٜنْ کَاپٜ، نغَمْ ٻٜ نجَٻِي يَحَيَ اٛ اَنَّبِيجٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","نغَمْ نٛنْ ٻٜ مبِعِ يٜىٰسُ، ‏«‏مِنْ اَنْدَا تٛ طُمْ پِوٛيِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","سٜيْ يٜىٰسُ وِعِٻٜ، ‏«‏نٛنْ مِنْ مَا، مِ وِعَتَاعٛنْ کٛو اٜ طُمٜ لَامُ نغَطِرَيْمِ کُوطٜ طٜعٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","سٜيْ يٜىٰسُ فُطِّ حٛکُّکِ يِمْٻٜ مِسَالُ طُعُمْ، اٛ وِعِ، ‏«‏غٛطّٛ نٜطّٛ وَطِ نغٜسَ اِنَبٛوجٜ، اٛ حٛکِّکَ وٛٻّٜ رٜمٛوٻٜ مٛعِّنَکَ، اٛ دِلِّ وٛنْدِ لٜيْدِ اٛ نٜىٰٻِ تٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","ندٜ شَرٜلْ ٻٜنْدُکِ اِنَبٛوجٜ طٜنْ وَطِ، اٛ لِلِ مَشُّطٛ تٛ ٻٜ اٛ حٛکِّ نغٜسَ کَنْ اٛ جَٻٛنٛيَمٛ کٛ ٻٜ نغَادِ ندٜرْ کٛ ٻٜنْدِ؞ سٜيْ ٻٜ ڤِيِ مَشُّطٛ اٛنْ ٻٜ ندِيوِمٛ کٛو کٛ ٻٜ کٛکِّمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","جٛومُ نغٜسَ اٛنْ لِلِ غٛطّٛ مَشُّطٛ کَدِنْ، کَنْکٛ مَا ٻٜ ڤِيِمٛ ٻٜ کُطِ کُطِنِمٛ، ٻٜ شٛعِّمٛ، کٛو کٛ ٻٜ کٛکِّمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","سٜيْ اٛ فُطِّتِ اٛ لِلِ مَشُّطٛ تَتَٻٛ، کَنْکٛ بٛو ٻٜ نَوْنِمٛ ٻٜ مبُرْتِنِمٛ ندٜرْ نغٜسَ کَنْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","سٜيْ جٛومُ نغٜسَ اٛنْ وِعِ، ‏‹‏کٛ نغَطَيْمِ؟ مِ لِلَيْ ٻِطّٛ اَمْ مٛ ٻُرْمِ يِطُکِ؞ اٜ مِ کَمّٛو ٻٜ کٛکَّيْمٛ مَنْغُ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","اَمَّا ندٜ ٻٜ اٛ حٛکِّ نغٜسَ کَنْ نغِعِ ٻِطّٛ جٛومُ نغٜسَ اٛنْ، سٜيْ ٻٜ مبِعِ حَکُّندٜ مَٻّٜ، ‏‹‏تٛو!‏ رَا دٛنٛووٛ نغٜسَ کَنْ؞ نغَرٜىٰ مبَرٜنْمٛ، ندٛنُ نغٜسَ کَنْ وَرْتَ طُمْ مٜىٰطٜنْ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","سٜيْ ٻٜ مبُرْتِنِمٛ ندٜرْ نغٜسَ کَنْ ٻٜ مبَرِمٛ؞ ‏«‏تٛو، کٛ کَمِّيطٛنْ جٛومُ نغٜسَ اٛنْ وَطَنْتَٻٜ؟ ");
INSERT INTO fuv_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","اٛ وَرَيْ اٛ حَلْکَٻٜ، اٛ حٛکَّ وٛٻّٜ نغٜسَ کَنْ؞»‏ ندٜ يِمْٻٜ نَنِ نٛنْ، ٻٜ مبِعِ، ‏«‏اَللَّه حٛيْنَ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","اَمَّا يٜىٰسُ رَارِٻٜ وِعِ، ‏«‏تٛو، کٛ وٛنِ مَعَنَ اَايَارٜ بِعُندٜ:‏ ‏‹‏حَيْرٜ ندٜ مَحٛوٻٜ نغَݧِ، کَيْرٜ وَرْتِ حَيْرٜ ٻُرْندٜ دَرْنُکِ مَادِ؟›‏ ");
INSERT INTO fuv_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","‏«‏کٛو مٛيٜ يَنٛيِ دٛوْ حَيْرٜ ندٜنْ يٜوِ يٜوِنَيْ؛ اَمَّا تٛ حَيْرٜ ندٜنْ يَنِي دٛوْ غٛطّٛ، ندٜ نَمَيْمٛ بٛ شٛنْدِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","مٛودِٻّٜ اَتَّوْرَ اٜ مَوْٻٜ اَرْدِيٻٜ دِينَ اٜ نغِطِ نَنْغَ يٜىٰسُ طٛنْ اٜ طٛنْ، نغَمْ ٻٜ ڤَامِي دٛوْ مَٻّٜ اٛ حٛکِّ مِسَالُ طُعُمْ، اَمَّا اٜ ٻٜ کُلَ يِمْٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","نغَمْ نٛنْ ٻٜ نغَطَنِ يٜىٰسُ غِتٜ، ٻٜ لِلِ وٛٻّٜ نَنْدِتِنْٻٜ اٜ يِمْٻٜ ٻٜ غٛونغَ نغَمْ ٻٜ نَنَ کٛو اٛ وِعَيْ غٛطُّمْ طُمْ ٻٜ کٜٻَتَ ٻٜ نغُلِّرٛيٛومٛ يٜىٰسٛ غٛمْنَاجٛ لٜيْدِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","لِلَاٻٜ ٻٜنْ سٜيْ پَمِ يٜىٰسُ مبِعِ، ‏«‏مٛودِبّٛ، اٜ مِنْ اَنْدِ کٛ مبِعَتَا اٜ کٛ نغَطَتَا طُمْ غٛونغَ، اَ حٛلَّتَا يِدّٜ حٛورٜ، اَ اٜکِّتِنَ لَاوٛلْ اَللَّه اٜ غٛونغَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","اٜ يِيکِ مَاطَ اٜ حَانِ مِنْ نجٛٻَ کَيْسَرْ مَوْطٛ لَامِيٻٜ شٜىٰدٜ لٜيْدِ، کٛو طُمْ حَانَايِ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","اَمَّا يٜىٰسُ اٜ اَنْدِ پٛيْرٜ مَٻّٜ، سٜيْ اٛ وِعِٻٜ، ");
INSERT INTO fuv_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","‏«‏کٛلّٜىٰيَمْ يَمْندٜ اَجُرْفَارِ؞ طٛوْدِ مٛيٜ اٜ اِنْدٜ مٛيٜ وٛنِ دٛوْ مَيْرٜ؟»‏ ٻٜ مبِعِ، ‏«‏طُمْ کَيْسَرْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","اٛ وِعِٻٜ، ‏«‏نغَمْ نٛنْ، کٛکّٜىٰ کَيْسَرْ کٛ وٛنِ طُمْ کَيْسَرْ، ندٜنْ کٛکّٛنْ اَللَّه کٛ وٛنِ طُمْ اَللَّه؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","ٻٜ کٜٻَايِ کٛ ٻٜ نَنْغِرْتَمٛ ندٜرْ کٛ اٛ وِعِٻٜ يٜىٰسٛ يِمْٻٜ، سٜيْ ٻٜ ندٜعِّتِ اٜ ٻٜ کَيْطِنَ اٜ نٛ اٛ نٛوتٛرَنِيٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","سَادُسَنْکٛعٜنْ اٜ مبِعَ وَلَا اُمَّاکِ مَيْٻٜ؞ وٛٻّٜ مَٻّٜ نغَرِ تٛ يٜىٰسُ، ");
INSERT INTO fuv_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","ٻٜ پَمِمٛ، ٻٜ مبِعِ، ‏«‏مٛودِبّٛ، اَنَّبِ مُوسَ وِعِي تٛ نٜطّٛ تٜعِي دٜبّٛ مَايِي دَݧِدَايِ اٜ مَاکٛ، سٜيْ سَکِرَاوٛ مَاکٛ تٜعَمٛ نغَمْ حٜٻَنَ سَکِرَاوٛ مُوطُمْ مَيْطٛ ٻِٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","تٛو، ندٜنّٛ اٜ وٛودِ وٛٻّٜ سَکِرَاٻٜ وٛرْٻٜ نجٛوٜىٰطِطٛ؞ اَفٛ اٛنْ تٜعِ دٜبّٛ، مَايِ، دَݧِدَايِ اٜ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","طِطَٻٛ اٛنْ تٜعِ دٜبّٛ اٛنْ، کَنْکٛ مَا اٛ مَايِ، ٻٜ ندَݧِدَايِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","تَتَٻٛ اٛنْ مَا تٜعِ دٜبّٛ اٛنْ، کَنْکٛ مَا اٛ مَايِ ٻٜ ندَݧِدَايِ؞ نٛنْ سَکِرَاٻٜ نجٛوٜىٰطِطٛ ٻٜنْ طٛنْ ٻٜ فُو ٻٜ تٜعِينٛمٛ، ٻٜ مَايِ، ٻٜ ندَݧِدَايِ اٜ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","غَطَ مَاجُمْ دٜبّٛ اٛنْ مَا مَايِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","تٛو، جٛونِ، ݧَلْندٜ ندٜ مَيْٻٜ اُمّٛتٛو، دٜبّٛ اٛنْ وَرْتَيْ دٜبّٛ مٛيٜ ندٜرْ مَٻّٜ؟ نغَمْ ٻٜ فُو نجٛوٜىٰطِطٛ ٻٜ تٜعِيمٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","يٜىٰسُ نٛوتِي وِعِٻٜ، ‏«‏يِمْٻٜ جَامَنُ طُعُمْ اٜ تٜعِندِرَ، ");
INSERT INTO fuv_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","اَمَّا يِمْٻٜ ٻٜ اَللَّه يِعِ اٜ حَانِ ٻٜ اُمّٛو ݧَلْندٜ جَانغٛ، ݧَلْندٜ ندٜ طُمْ اُمِّنْتَ مَيْٻٜ، وٛرْٻٜ تٜعَتَا، رٜوْٻٜ تٜعَتَاکٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ٻٜ ڤُطِّتَتَا ٻٜ مَايَ، نغَمْ ٻٜ نغَرْتَيْ بٛ مَلَاعِکَعٜنْ؞ ٻٜ ٻِٻّٜ اَللَّه نغَمْ ٻٜ اُمَّکٜ دَغَ مَيْدٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","کٛو ندٜرْ حَبَرُ لٜغّٜلْ غٛودُنغٜلْ حِيتٜ، اَنَّبِ مُوسَ حٛلِّي مَيْٻٜ اُمّٛتٛ، نغَمْ اٛ نٛدِّرِي جٛومِرَاوٛ ‏‹‏اَللَّه مٛ اِبْرَاهِمْ، اَللَّه مٛ اِشِيَاکُ، اَللَّه مٛ يَاکُبُ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","کَنْکٛ نَاع اٛ اَللَّه مَيْٻٜ، اَمَّا اٛ اَللَّه غٛودُٻٜ يٛنْکِ؞ نغَمْ تٛ مَاکٛ، کٛو مٛيٜ اٜ وٛودِ يٛنْکِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","وٛٻّٜ مٛودِٻّٜ اَتَّوْرَ مبِعِمٛ، ‏«‏مٛودِبّٛ، اَ وِعِي غٛونغَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","دَغَ طٛنْ وَلَا غَطُطٛ سٜمْبٜ ٻٜرْندٜ پَمِمٛ وٛنْغٛلْ پَمٛلْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","اَمَّا يٜىٰسُ وِعِٻٜ، ‏«‏نٛ وَطَتَ اٜ ٻٜ مبِعَ اَلْمَسِيحُ طُمْ ٻِطّٛ دَوْدَ؟ ");
INSERT INTO fuv_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","نغَمْ دَوْدَ اٜ حٛورٜ مُوطُمْ وِعِ ندٜرْ دٜفْتٜرٜ جَبُورَ، ‏‹‏جٛومِرَاوٛ وِعِي جٛومِرَاوٛ اَمْ، ‏«‏جٛوطَ تٛ جُنْغٛ اَمْ ݧَامٛ، ");
INSERT INTO fuv_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","نَا مِ وَطِي اَ يَاٻِي وَݧْوَݧْٻٜ مَاطَ؞»‏ ›‏ ");
INSERT INTO fuv_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","دَوْدَ اٜ نٛدِّرَ اَلْمَسِيحُ ‏‹‏جٛومِرَاوٛ؞›‏ نٛ وَطَتَ اٛ وَرْتَ ٻِطّٛ دَوْدَ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","يٜىٰسٛ کٛو مٛيٜ اٛ وِعِ تٛکُّٻٜمٛ، ");
INSERT INTO fuv_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","‏«‏ڤَامَنٜىٰ مٛودِٻّٜ اَتَّوْرَ، غِطُٻٜ يِيلَاکِ اٜ ٻٛرْنِي تٛغّٛحٛ نجُوتُکٛ، غِطُٻٜ حٛوْنِرٜىٰکِ مَنْغُ ندٜرْ لُومٛ؞ اٜ ٻٜ نغِطِ جٛوطَاکِ دٛوْ جٛوطٛرْلٜ مَوْٻٜ ندٜرْ شُوطِ دٛعَارٜ اٜ جٛوطٛرْلٜ مَوْٻٜ تٛ حُمْتٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","کَمْٻٜ نغٛنِ ݧَامٛوٻٜ جَوْدِ رٜوْٻٜ ٻٜ وٛرْٻٜ مُعّٜنْ مَايِ، وَطٛوٻٜ دٛعَاجٜ جُوتُطٜ نغَمْ طُمْ يِعَٻٜ؞ ٻٜ ٻُرَيْ يَرُکِ بٛنٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","يٜىٰسُ پٜفْتِ حٛورٜ مُوطُمْ يِعِ رِسْکُٻٜ اٜ نغَطَ دٛکّٜ مَٻّٜ ندٜرْ تٛ طُمْ حٛکَّتَ شٜىٰدٜ نغَمْ اَللَّه ندٜرْ وُرٛ شٜنِينغٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","سٜيْ اٛ يِعِ غٛطّٛ دٜبّٛ مٛ وَلَنَا مٛ غٛرْکٛ مُوطُمْ مَايِ وَطِي شٜىٰدٜ نجَمْکٛيْ طِطٛيْ کٛيْ نجَمْندِ مبٛطٜىٰرِ ندٜرْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","يٜىٰسُ وِعِ، ‏«‏اٜ مِ وِعَعٛنْ غٛونغَ، اٛعٛ دٜبّٛ مٛ وَلَنَا، کٛ اٛ حٛکِّ ٻُرِي کٛ حٛرِيٻٜ فُو کٛکِّ؞ ");
INSERT INTO fuv_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","نغَمْ حٛرِيٻٜ ٻٜعٜ فُو ٻٜ کٛکِّي سٜطَّ دَغَ ندٜرْ رِسْکُ مَٻّٜ، اَمَّا کَنْکٛ بٛو ندٜرْ شِيَ مَاکٛ اٛ حٛکِّ فُو کٛ اٛ وٛودِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","وٛٻّٜ اٜ مٜتَ دٛوْ نٛ طُمْ مٛعِّنِرِ وُرٛ شٜنِينغٛ اٜ کَاپٜ بٛطّٜ اٜ دٛکّٜ طٜ طُمْ حٛکِّ نغَمْ اَللَّه؞ اَمَّا يٜىٰسُ وِعِ، ");
INSERT INTO fuv_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","‏«‏کٛ نغِعٛتٛنْ طٛعٛ، شَرٜلْ وَرَيْ نغٜلْ وَلَا وٛنْدٜ حَيْرٜ اَلٜتٜىٰندٜ دٛوْ وٛنْدٜ؞ طٜ فُو طُمْ سَنْکِتَيْطٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","ٻٜ پَمِمٛ، ٻٜ مبِعِ، ‏«‏مٛودِبّٛ، ندٜيٜ فِي طُعُمْ وَطَتَ؟ ندٜنْ کٛ حٛلَّتَ فُطُّکِ مَاجُمْ ٻَدَکٜ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","اٛ وِعِ، ‏«‏ڤَامٜىٰ، تٛع طُمْ مَجِّنَعٛنْ؞ نغَمْ يِمْٻٜ طُطْٻٜ نغَرٛيَيْ ندٜرْ اِنْدٜ اَمْ، ٻٜ مبِعَ کَمْٻٜ نغٛنِ مِنْ، ندٜنْ، ‏‹‏شَرٜلْ ٻَدَکٜ!‏›‏ تٛع اٛنْ تٛکُّٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","اَمَّا، تٛ اٛنْ نَنِي حَبَرُ کٛنُوجِ حَکُّندٜ لٜيْطٜ اٜ کٛنُوجِ ندٜرْ لٜيْطٜ، تٛع اٛنْ کُلُ، نغَمْ اَرَنْدٜ دٛولٜ فِي طُعُمْ وَطَ، اَمَّا نٛنْ حٛلَّايِ رٜعُکِ دُونِيَارُ وَرِي؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","ندٜنْ اٛ وِعِٻٜ، ‏«‏لٜݧٛلْ اُمَّنْتٛ لٜݧٛلْ، ندٜنْ لَامُ اُمَّنْتٛ لَامُ؞ ");
INSERT INTO fuv_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","اٜ بِغٜىٰجٜ فٜىٰرٜ‑فٜىٰرٜ طُمْ وَطَيْ دِمْبٛلْ لٜيْدِ شٜمْبِنْغٛلْ، طُمْ وَطَيْ وٜىٰلٛ اٜ ݧَوُوجِ کَلُّطِ؞ طُمْ وَطَيْ فِي مَوْطُمْ کُلْنِيطُمْ اٜ دٛوْ، غَطٛوجُمْ يِمْٻٜ کُلْتٛرَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","اَمَّا کٛ فِي طُعُمْ فُو وَطَ، يِمْٻٜ نَنْغَيْعٛنْ، تٛرَّيْعٛنْ، ٻٜ نغَطَيْعٛنْ ندٜرْ جُوطٜ مَوْٻٜ شُوطِ دٛعَارٜ، ٻٜ نغَطَعٛنْ ندٜرْ شُوطِ شُرَلْ، طُمْ يَارَيْعٛنْ يٜىٰسٛ لَامِيٻٜ اٜ مَوْٻٜ لٜيْدِ، نغَمْ اٛنْ تٛکُّٻٜيَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","طُمْ وَرْتَيْ لَاوٛلْ نٛ کٛکِّرْتٛنْٻٜ حَبَرُ اَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","اَمَّا ڤُکِّنٜىٰ ٻٜرْطٜ مٛوطٛنْ، تٛع اٛنْ نغَنُّ کٛ شَرٜلْ نغٜلْ وَطَ نٛ مبُرْتِنِرْتٛنْ کٛعٜ مٛوطٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","نغَمْ مِ حٛکَّيْعٛنْ بٛلِيطٜ اٜ اَنْدَلْ، حَا وَلَا غٛطّٛ ندٜرْ غَݧٛوٻٜ مٛوطٛنْ بَاوَيْطٛ دٛعُّکِعٛنْ کٛو يٜدُّکِ کٛ مبِيطٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","دَݧٛوٻٜ مٛوطٛنْ اٜ مِݧِرَاٻٜ مٛوطٛنْ اٜ مَوْنِرَاٻٜ مٛوطٛنْ اٜ بَنْدِرَاٻٜ مٛوطٛنْ اٜ حِغٛوٻٜ مٛوطٛنْ، ٻٜ کٛکِّتِرَيْعٛنْ، ندٜنْ ٻٜ مبَرَ وٛٻّٜ مٛوطٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","کٛو مٛيٜ وَݧَيْعٛنْ نغَمْ اٛنْ تٛکُّٻٜيَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","اَمَّا وَلَا لَاسٛلْ کٛعٜ مٛوطٛنْ غٛعٛتٛلْ کَلْکَيْنغٛلْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","تٛ اٛنْ مُݧِي، اٛنْ کٜٻَيْ يٛنْکِ کِ رٜعَتَا؞ ");
INSERT INTO fuv_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","«‏تٛ اٛنْ نغِعِي حٛنٛوٻٜ اٜ ڤِلِي اُرُشَلِيمَ، اَنْدٜىٰ حَلْکُکِ مَيْرِ ٻَدَکٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","ندٜنْ وٛنْٻٜ ندٜرْ لٜيْدِ يَحُودِيَ ندٛغَّ نَتّٛيَ کٛشّٜىٰجٜ، وٛنْٻٜ ندٜرْ غَرِيرِ مَوْندِ بٛو مبُرْتٛوندِ، ندٜنْ وٛنْٻٜ ندٜرْ لَدّٜ تٛع نَتَّ غَرِيرِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","نغَمْ بَلْطٜ طٜنْ طٛنْ طُمْ ‏‹‏بَلْطٜ بٛنٜ،›‏ نغَمْ کٛ وِنْدَا فُو حٜىٰوَيْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","رٜوْٻٜ غٛودُٻٜ دٜىٰطِ اٜ مُسِنْتٜىٰٻٜ ٻٜ تٛرّٛتٛ نَاع سٜطَّ ندٜرْ طٜنْ طٛنْ بَلْطٜ!‏ نغَمْ طُمْ وَطَيْ تٛرَّاجِ کَلُّطِ ندٜرْ دُونِيَارُ، مٛنّٜرٜ اَللَّه جِڤّٛنٛيْتٛ لٜݧٛلْ نغٛعٛلْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","طُمْ وَرْدَيْ وٛٻّٜ اٜ کَافَاجٜ، طُمْ نَنْغَيْ وٛٻّٜ، طُمْ يَارَٻٜ ندٜرْ لٜيْطٜ فُو طُمْ وَرْتِرَٻٜ مَشُّٻٜ؞ لٜݧِ دُونِيَارُ نغَطَيْ کَ سَنْکُتُکِ اُرُشَلِيمَ ٻٜ لَامٛوندِ نَا شَرٜلْ نغٜلْ طُمْ حٛکِّٻٜ وَطِي؞ ");
INSERT INTO fuv_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","‏«‏طُمْ وَطَيْ فِي کُلْنِيطُمْ ندٜرْ نَانغٜ اٜ لٜوْرُ اٜ کٛودٜ؞ يِمْٻٜ وٛنْٻٜ ندٜرْ لٜيْطٜ دُونِيَارُ فُو ٻٜ نغَنَّيْ ٻٜ کُلْتٛرَ، ندٜنْ ٻٜ ندُلَّ کٛ ٻٜ نغَطَتَ نغَمْ حٛنٛنْدٜ شٜمْبِنْدٜ ندٜ غٜىٰلٛوطِ ندِيَمْ مبٜىٰلَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","کُلٛلْ وَطَيْ وٛٻّٜ ڤٜکّٛرَ، نغَمْ کٛ وَرٛيْتَ ندٜرْ دُونِيَارُ، نغَمْ کٛ وٛنِ دٛوْ فُو دِمْبٛتٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","اٜ شَرٜلْ نغٜلْ، ٻٜ نغِعَيْ ٻِي نٜطّٛ اٜ وَرَ ندٜرْ دُولٜ اٜ بَوْطٜ اٜ تٜدُّنغَلْ مَنْغَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","تٛ فِي طُعُمْ فُطِّي وَطُکِ، اُمّٜىٰ ندَرٛوطٛنْ، پٜفْتٛنْ کٛعٜ مٛوطٛنْ ندَارٛنْ دٛوْ، نغَمْ کِسْندَمْ مٛوطٛنْ ٻَدَکٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","اٛ حٛکِّٻٜ مِسَالُ طُعُمْ، اٛ وِعِ، ‏«‏ندَارٜىٰ لٜکِّ اِبِّ اٜ لٜطّٜ کٛرِيطٜ فُو؞ ");
INSERT INTO fuv_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","تٛ اٛنْ نغِعِي طٜ مبِلِتِي، اٛنْ اَنْدِ سٜىٰتٛ ٻَدَکٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","نٛنْ مَا تٛ اٛنْ نغِعِي فِي طُعُمْ اٜ وَطَ، تٛو، اٛنْ اَنْدَيْ لَامُ اَللَّه ٻَدَکٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","‏«‏اٜ مِ وِعَعٛنْ غٛونغَ، جَامَنُ طُعُمْ رٜعَتَا نَا فُو فِي طُعُمْ وَطِي؞ ");
INSERT INTO fuv_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","دٛوْ اٜ لٜيْ پَٻّٛتٛ، اَمَّا بٛلِيطٜ اَمْ پَٻَّتَاکٛ حَا اَبَدَا؞ ");
INSERT INTO fuv_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","‏«‏ڤَامٜىٰ تٛع يَرٜ‑يَرٜ اٜ ݧَامٜ‑ݧَامٜ اٜ وَنُّکِ اٜ کٛ وٛنِ ندٜرْ دُونِيَارُ حٛشَّ ٻٜرْطٜ مٛوطٛنْ، نغَمْ تٛع ݧَلْندٜ ندٜنْ اُدّٛوعٛنْ اٛنْ اَنْدَا؞ ");
INSERT INTO fuv_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","نغَمْ ݧَلْندٜ ندٜنْ وَرَيْ دٛوْ کٛو مٛيٜ مٛ يٛنْکِ ندٜرْ دُونِيَارُ؞ ");
INSERT INTO fuv_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","ڤَامٜىٰ کٛو ندٜيٜ نغَطٛنْ دٛعَارٜ نغَمْ کٜٻٛنْ ندَطٛنْ فِي طُعُمْ غَطَيْطُمْ فُو، ندٜنْ ندَرٛوطٛنْ يٜىٰسٛ ٻِي نٜطّٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","کٛو ندٜيٜ ݧَلْندٜ يٜىٰسُ اٜ اٜکِّتِنَ ندٜرْ وُرٛ شٜنِينغٛ، اَمَّا جٜمَّ اٛ وُرْتٛو اٛ يَحَ دٛوْ حٛشّٜىٰرٜ ندٜ لٜطّٜ جَيْتُنْ اٛ وَالٛيَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","کٛو ندٜيٜ اِلَا سُبَکَ يِمْٻٜ فُو اٜ نجَحَ وُرٛ شٜنِينغٛ نغَمْ نَنُکِمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","تٛو، شَرٜلْ ٻَدَکٜ نغَمْ حُمْتٛ بُرٛودِ طُمْ وَلَا پُوفِنِرْطُمْ بِعٜتٜىٰنغٛ حُمْتٛ سَکِّنْکِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","مَوْٻٜ اَرْدِيٻٜ دِينَ اٜ مٛودِٻّٜ اَتَّوْرَ اٜ طَٻِّتَ نٛ ٻٜ مبَرْدَتَ يٜىٰسُ، نغَمْ اٜ ٻٜ کُلَ يِمْٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","سٜيْ شٜيْطَنْ نَتِّ ٻٜرْندٜ يَحُودَ بِعٜتٜىٰطٛ اِسْکَرِيٛوتِ، غٛعٛتٛ ندٜرْ تٛکُّٻٜ يٜىٰسُ سَڤّٛ اٜ طِطٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","سٜيْ اٛ يَحِ تٛ مَوْٻٜ اَرْدِيٻٜ دِينَ اٜ مَوْٻٜ اَرْدِيٻٜ تَادِيٻٜ وُرٛ شٜنِينغٛ، اٛ مٜدِّ اٜ مَٻّٜ دٛوْ نٛ اٛ حٛکِّتِرْتَ يٜىٰسُ ندٜرْ جُوطٜ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","ٻٜ نَنِ بٜلْطُمْ طُطُّمْ، ٻٜ نغَطِ اَلْکَوَلْ حٛکُّکِمٛ شٜىٰدٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","کَنْکٛ بٛو اٛ جَٻِ، اٛ فُطِّ طَٻُّتُکِ لَاوٛلْ نٛ اٛ حٛکِّتِرْتَ يٜىٰسُ ندٜرْ جُوطٜ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","سٜيْ ݧَلْندٜ وَرِ ندٜ حُمْتٛ بُرٛودِ طُمْ وَلَا پُوفِنِرْطُمْ ندٜ طُمْ حِرْسَتَ کَرٛورِ حُمْتٛ سَکِّنْکِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","نغَمْ نٛنْ يٜىٰسُ لِلِ بِيتُرُسْ اٜ يَحَيَ وِعِٻٜ، ‏«‏نجَحٜىٰ شِرْيَنٜىٰعٜنْ کٛو طُمٜ نغَمْ ݧَامٜنْ حُمْتٛ سَکِّنْکِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","ٻٜ پَمِمٛ ٻٜ مبِعِ، ‏«‏تٛيٜ نغِطَّا مِنْ نجَحَ مِنْ شِرْيٛوطُمْ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","اٛ وِعِٻٜ، ‏«‏رَطُّمْ، اٜ نَتُّکِ مٛوطٛنْ غَرِيرِ، اٛنْ کَوْرَيْ اٜ غٛطّٛ اٜ مٛ رٛنْدِي پٛوغِرْدٜ ندِيَمْ؞ تٛکّٜىٰمٛ يَاکِ وُرٛ نغٛ اٛ نَتَّتَ، ");
INSERT INTO fuv_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","مبِعٛنْ جٛومُ وُرٛ نغٛنْ، ‏‹‏مٛودِبّٛ وِعِي مِنْ پَمُمَا:‏ ‏«‏تٛيٜ سُودُ ندُ ݧَامَيْمِ ݧَمْندُ حُمْتٛ سَکِّنْکِ اٜ تٛکُّٻٜيَمْ؟»‏ ›‏ ");
INSERT INTO fuv_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","اٛ حٛلَّيْعٛنْ سُودُ ندُ دٛوْ، مَوْندُ مٛعِّنَاندُ؞ شِرْيَنٜىٰعٜنْ کٛو طُمٜ طٛنْ نغَمْ ݧَامٜنْ ݧَمْندُ حُمْتٛ سَکِّنْکِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","سٜيْ ٻٜ نجَحِ ٻٜ تَوِ کٛو طُمٜ نٛ يٜىٰسُ وِعِٻٜ، سٜيْ ٻٜ شِرْيِي کٛو طُمٜ نغَمْ حُمْتٛ سَکِّنْکِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","ندٜ شَرٜلْ وَطِ، يٜىٰسُ اٜ تٛکُّٻٜمٛ سَڤّٛ اٜ طِطٛ نجٛوطِي نغَمْ ݧَامَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","سٜيْ اٛ وِعِٻٜ، ‏«‏مِ حَاٻِي ݧَمْدُکِ ݧَمْندُ حُمْتٛ سَکِّنْکِ ندُعُ اٜ مٛوطٛنْ کٛ مِ تٛرّٜىٰ؞ ");
INSERT INTO fuv_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","نغَمْ اٜ مِ وِعَعٛنْ، مِ فُطِّتَتَا ݧَامُکِ ݧَمْندُ حُمْتٛ سَکِّنْکِ سٜيْ تٛ مَعَنَ مَاجُمْ حٜىٰوِي ندٜرْ لَامُ اَللَّه؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","سٜيْ اٛ حٛشِّ اِنَبٛجَمْ ندٜرْ جَرْدُغٜلْ، اٛ يٜتِّ اَللَّه، اٛ وِعِ، ‏«‏نجَٻٜىٰ نغٜعٜلْ شٜنْدٛنْ اِنَبٛجَمْ طَمْ حَکُّندٜ مٛوطٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","نغَمْ اٜ مِ وِعَعٛنْ، مِ فُطِّتَتَا يَرُکِ ندِيَمْ اِنَبٛوجٜ نَا لَامُ اَللَّه وَرٛيِي؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","ندٜنْ اٛ حٛشِّ بُرٛودِ، اٛ يٜتِّ اَللَّه، اٛ سٜنْدِطُمْ، اٛ حٛکِّ تٛکُّٻٜمٛ، اٜ مٛ وِعَ، ‏«‏طُعُمْ طُمْ ٻَنْدُ اَمْ، کٛکَّاندُ نغَمْ مٛوطٛنْ؞ نغَطٜىٰ کَ وَطُکِ نٛنْ نغَمْ سِفْتٛرْکِيَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","نٛنْ مَا، غَطَ ٻٜ کِرْتَکٜ، اٛ حٛشِّ جَرْدُغٜلْ ندِيَمْ اِنَبٛجَمْ، اٛ وِعِ، ‏«‏طَعَمْ وٛنِ اَلْکَوَلْ کٜسَلْ تَبِّتَيْنغَلْ اٜ پِيپَمْ اَمْ ندُفٜتٜىٰطَمْ نغَمْ مٛوطٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","‏«‏اَمَّا، رَطُّمْ، کٛکِّتِرَيْطٛيَمْ اٜ ݧَمْدَ اٜ اَمْ طٛعٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","نغَمْ ٻِي نٜطّٛ مَايَيْ نٛنْ نٛ اَللَّه سُٻِ، اَمَّا کٛکِّتِرَيْطٛمٛ وٛنِي!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","تٛکُّٻٜمٛ ڤُطِّ پَمْپَمْتِرْکِ حَکُّندٜ مَٻّٜ، کٛو طُمْ مٛيٜ ندٜرْ مَٻّٜ وَطَتَ فِي طُعُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","کَدِمَا غٜدِّ اُمِّي حَکُّندٜ مَٻّٜ دٛوْ مٛيٜ ندٜرْ مَٻّٜ وٛنِ مَوْطٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","يٜىٰسُ وِعِٻٜ، ‏«‏لَامِيٻٜ يِمْٻٜ نَاع يَحُودَنْکٛعٜنْ اٜ کٛلَّ يِمْٻٜ مَٻّٜ لَامُ سٜمْبٜ، فُو اٜ نٛنْ اٜ ٻٜ نٛدِّرَ کٛعٜ مَٻّٜ وَلّٛوٻٜ يِمْٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","اَمَّا اٛنٛنْ، تٛع اٛنْ نغَطُ نٛنْ؞ سٜيْ ٻُرْطٛ مَنْغُ ندٜرْ مٛوطٛنْ وَرْتَ بٛ ڤَمَرٛ، ندٜنْ اَرْدِيطٛ وَرْتَ بٛ مَشُّطٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","مٛيٜ ٻُرِ مَنْغُ، جٛوطِيطٛ نغَمْ ݧَامَ کٛو غَدّٛووٛ ݧَمْندُ؟ اَيْ اٛنْ طٛنْ جٛوطِيطٛ وٛنِ مَوْطٛ؞ اَمَّا، اٜ مِ طٛنْ حَکُّندٜ مٛوطٛنْ بٛ مَشُّطٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","‏«‏اٛنٛنْ نغٛنِ دَرٛدِيٻٜ اٜ اَمْ اٜ غٛونغَ ندٜرْ تٛرَّ کَ نجَرُمِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","نٛ ݧَاکٛ اَمْ مٛ دٛوْ حٛکِّرِيَمْ لَامُ، نٛنْ مِنْ مَا، مِ حٛکِّيعٛنْ لَامُ ");
INSERT INTO fuv_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ݧَمْدٛنْ اٜ اَمْ نجَرْدٛنْ اٜ اَمْ ندٜرْ لَامُ اَمْ، ندٜنْ نجٛوطٛوطٛنْ دٛوْ جٛوطٛرْلٜ لَامُ، اٛنْ لَامٛو لٜݧِ اِسْرَاعِيلَ سَڤّٛ اٜ طِطِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","‏«‏سِيمَنْ، سِيمَنْ، رَطُّمْ شٜيْطَنْ پَمِي لَاوٛلْ فٛوندَعٛنْ، بٛو اٛ حٛکَّامَ؞ اٜ مٛ يِطِ اٛ سٜطَعٛنْ نٛ طُمْ سٜطِرْتَ اَلْکَمَارِ اٜ ݧَاندٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","اَمَّا مِ وَطَنِيمَ دٛعَارٜ، سِيمَنْ، نغَمْ تٛع اَلَا حٛولَاکِيَمْ؞ اَنْ بٛو، تَا وَرْتِي تٛ اَمْ، شٜمْبِطِنَا بَنْدِرَاٻٜ مَاطَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","اَمَّا بِيتُرُسْ وِعِمٛ، ‏«‏مٛودِبّٛ، اٜ مِ سِرْيِي يَادُکِ اٜ مَاطَ سُودُ شُرَلْ، حَا اٜ مَيْدٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","يٜىٰسُ وِعِ، ‏«‏اٜ مِ وِعُمَا، بِيتُرُسْ، حَنْدٜ کٛ نجَکَرْدِ حَنَ، اَ وِعَيْ اَ اَنْدَايَمْ ندٜ تَتِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","سٜيْ يٜىٰسُ پَمِٻٜ وِعِ، ‏«‏شَرٜلْ کٛ لِلْمِعٛنْ مبِيمِعٛنْ تٛع اٛنْ نجَادُ اٜ شٜىٰدٜ، تٛع اٛنْ نجَادُ اٜ جَکَارٜ کٛو ڤَطٜ کٛيْطٜ طِطِ، اٜ وٛودِ کٛ ندُلُّطٛنْ؟»‏ ٻٜ مبِعِ، ‏«‏وَلَا؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","اٛ وِعِٻٜ، ‏«‏اَمَّا جٛونِ، غٛودُطٛ شٜىٰدٜ اٜ جَکَارٜ، حٛشَّ؞ مٛ وَلَا کَافَحِ، سٛورَ شُدَّارِ مُوطُمْ سٛودَ غٛعٛتِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","اٜ مِ وِعَعٛنْ، اَايَارٜ ندٜعٜ دٛولٜ حٜىٰوَ دٛوْ اَمْ بِعُندٜ، ‏‹‏طُمْ حٛشَّيْمٛ بٛ کَلُّطٛ،›‏ نغَمْ کٛ وِنْدَا دٛوْ اَمْ ٻَدَکٜ حٜىٰوُکِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","تٛکُّٻٜمٛ مبِعِ، ‏«‏مٛودِبّٛ، رَا کَافَاجٜ طِطِ؞»‏ اٛ وِعِٻٜ، ‏«‏طُمْ حٜپِي نٛنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","يٜىٰسُ وُرْتِي، يَحِ حٛشّٜىٰرٜ ندٜ لٜطّٜ جَيْتُنْ نٛ اٛ وٛووِ، تٛکُّٻٜمٛ مَا اٜ تٛکِّمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","ندٜ ٻٜ نجٛتِّي وِغٜىٰرٜ ندٜنْ، اٛ وِعِٻٜ، ‏«‏نغَطٜىٰ دٛعَارٜ تٛع نجَحٛنْ تٛ نغَطٛتٛنْ حَکّٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","يٜىٰسُ حَکِّتِي کَنُمْ تَنْ کٛ وَطَتَ حُبَاکِ حَيْرٜ، سٜيْ اٛ يَنِ اٜ لٜيْدِ اٜ مٛ حِڤِّي، اٛ وَطِ دٛعَارٜ، اٛ وِعِ، ");
INSERT INTO fuv_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","‏«‏ݧَاکٛ اَمْ مٛ دٛوْ، تَا جَٻِي، اِتَّنَمْ جَرْدُغٜلْ تٛرَّ کَعَ؞ فُو اٜ نٛنْ، نَاع کٛ نغِطُمِ وَطٜتٜىٰ، اَمَّا کٛ نغِطَّا وَطٜىٰ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","سٜيْ مَلَاعِکَاجٛ پِوٛيِ دَغَ دٛوْ وَنْغَنِمٛ سٜمْبِطِنِمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","اٜ مٛ ندٜرْ تٛرَّ کَلُّکَ، نغَمْ نٛنْ اٛ ٻٜيْدِ وَطُکِ دٛعَارٜ؞ اَسَوْرٜ مَاکٛ وَرْتِ بٛ پِيپَمْ اٜ سِمْتَ اٜ لٜيْدِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","ندٜ اٛ يٛتِّنِ دٛعَارٜ، سٜيْ اٛ سٛعِّي تٛ ٻٜنْ طٛنْ تٛکُّٻٜمٛ، اٛ تَوِ اٜ ٻٜ طَانِي نغَمْ وَنَّارٜ وَطِ ٻٜ شٛمِي؞ ");
INSERT INTO fuv_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","اٛ وِعِٻٜ، ‏«‏نغَمْ طُمٜ طَانٛتٛوطٛنْ؟ اُمّٜىٰ، نغَطٜىٰ دٛعَارٜ تٛ طُمْ فٛوندِيعٛنْ تٛع نغَطٛنْ حَکّٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","يٜىٰسُ اٜ مٜتَ، سٜيْ يِمْٻٜ طُطْٻٜ نغَرِ؞ يَحُودَ، غٛعٛتٛ ندٜرْ تٛکُّٻٜمٛ سَڤّٛ اٜ طِطٛ اٜ مٛ اَرْدِيٻٜ؞ يَحُودَ ٻَدِّي يٜىٰسُ نغَمْ حٛوْنَمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","يٜىٰسُ وِعِمٛ، ‏«‏يَحُودَ، اَ حٛکِّتِرَيْ ٻِي نٜطّٛ اٜ حٛوْنُکِ حِغَاکُ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","ندٜ تٛکُّٻٜ يٜىٰسُ نغِعِ کٛ وَطَتَ، ٻٜ مبِعِمٛ، ‏«‏مٛودِبّٛ، مِنْ ڤٜعِّرَٻٜ کَافَاجٜ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","غٛعٛتٛ مَٻّٜ فٜعِّ مَشُّطٛ مَوْطٛ مَوْٻٜ اَرْدِيٻٜ دِينَ اِتَّنِمٛ نٛوْرُ ݧَامٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","اَمَّا يٜىٰسُ وِعِ، ‏«‏اَلٜىٰ!‏ تٛع اٛنْ ٻٜيْدُ!‏»‏ يٜىٰسُ مٜىٰمِ نٛوْرُ نٜطّٛ اٛنْ، يَمْطِتِنِمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","سٜيْ يٜىٰسُ وِعِ مَوْٻٜ، اٜ مَوْٻٜ اَرْدِيٻٜ دِينَ، اٜ مَوْٻٜ تَادِيٻٜ وُرٛ شٜنِينغٛ غَرٛيْٻٜ نَنْغُکِمٛ، ‏«‏اٛنْ نغَرْدٛيِ اٜ کَافَاجٜ اٜ شَبِّ نغَمْ نَنْغٛيْيَمْ بٛ مِ غُجّٛ شَلٛرْطٛ؟ ");
INSERT INTO fuv_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","کٛو ندٜيٜ ݧَلْندٜ اٜ مِ وٛنْدِ اٜ مٛوطٛنْ ندٜرْ وُرٛ شٜنِينغٛ، اٛنْ نَنْغَايِيَمْ؞ اَمَّا جٛونِ طُمْ شَرٜلْ مٛوطٛنْ، اٜ لَامُ ݧِوْرٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","سٜيْ ٻٜ نَنْغِ يٜىٰسُ، ٻٜ ندِلِّدِ اٜ مَاکٛ، ٻٜ نجَارِمٛ وُرٛ مَوْطٛ مَوْٻٜ اَرْدِيٻٜ دِينَ؞ بِيتُرُسْ بٛو اٜ وٛطِّتِ اٜ تٛکِّرِٻٜ غَطَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","ندٜنْ ٻٜ کُٻِّ حِيتٜ شَکَ وُرٛ، ٻٜ نجٛوطِي، بِيتُرُسْ مَا سٜيْ جٛوطِي ندٜرْ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","سٜيْ غٛطّٛ کٛرْطٛ يِعِمٛ اٜ مٛ جٛوطِي اٜ مٛ اِرْفٛو؞ کٛرْطٛ اٛنْ بٛو سُتِيمٛ وِعِ، ‏«‏نٜطّٛ اٛعٛ مَا اٜ وٛنْدِ اٜ يٜىٰسُ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","اَمَّا بِيتُرُسْ يٜدِّ، وِعِ، ‏«‏مِ اَنْدَامٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","غَطَ طٛنْ سٜطَّ غٛطّٛ يِعِمٛ وِعِ، ‏«‏اَنْ مَا، اَ غٛعٛتٛ ندٜرْ تٛکُّٻٜمٛ؞»‏ اَمَّا بِيتُرُسْ وِعِ، ‏«‏حِغٛ، نَاع مِ تٛکُّطٛمٛ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","ندٜ يَوْتِي سٜطَّ، غٛطّٛ مَا وِعِ، ‏«‏سٜکٛ وَلَا نٜطّٛ اٛعٛ مَا اٜ وٛنْدِ اٜ يٜىٰسُ، نغَمْ کَنْکٛ مَا اٛ غَلِلَنْکٜىٰجٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","بِيتُرُسْ وِعِمٛ، ‏«‏حِغٛ، مِ اَنْدَا کٛ مبِعَتَا!‏»‏ طٛنْ اٜ طٛنْ اٜ مٛ ندٜرْ مٜتُکِ، نجَکَرْدِ حَنِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","سٜيْ يٜىٰسُ يٜىٰپِي رَارِ بِيتُرُسْ؞ سٜيْ بِيتُرُسْ سِفْتٛرِ کٛ يٜىٰسُ وِعُنٛومٛ وِعُکِ، ‏«‏حَنْدٜ کٛ نجَکَرْدِ حَنَ، اَ وِعَيْ اَ اَنْدَايَمْ ندٜ تَتِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","سٜيْ اٛ وُرْتِي يَاسِ اٛ وٛيِ بٛجِّ نَوْطِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","سٜيْ يِمْٻٜ جٛغِيٻٜ يٜىٰسُ فُطِّ جُکُّتُکِمٛ، اٜ ٻٜ ڤِيَمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","ٻٜ شُدِّ غِتٜ مَاکٛ ٻٜ نغَطِ کَ پَمُکِمٛ ٻٜ مبِعِ، ‏«‏وَطُ اَنَّبَاکُ!‏ مٛيٜ فِيُمَا؟»‏ ");
INSERT INTO fuv_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","ٻٜ کُطِرِمٛ حَالَاجِ نَوْطِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","ندٜ وٜىٰتِ، کَوْتَلْ مَوْٻٜ کَوْرِتِ اٜ مَوْٻٜ اَرْدِيٻٜ دِينَ اٜ مٛودِٻّٜ اَتَّوْرَ؞ يٜىٰسُ وَدَّا يٜىٰسٛ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","ٻٜ مبِعِمٛ، ‏«‏تٛ اَنْ وٛنِ اَلْمَسِيحُ، وِعُمِنْکَ؞»‏ اَمَّا يٜىٰسُ وِعِٻٜ، ‏«‏تٛ مِ وِعِيعٛنْکَ، اٛنْ نجَٻَتَا؞ ");
INSERT INTO fuv_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","تٛ مِ پَمِيعٛنْ بٛو، اٛنْ نٛوتَنْتَاکٛيَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","اَمَّا دَغَ جٛونِ، ٻِي نٜطّٛ جٛوطٛتٛ اٜ جُنْغٛ ݧَامٛ نغٛ اَللَّه جٛومُ بَوْطٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","ٻٜ فُو ٻٜ مبِعِ، ‏«‏اَنْ، اَ ٻِطّٛ اَللَّه؟»‏ اٛ وِعِٻٜ، ‏«‏نٛنْ نٛ مبِيطٛنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","ٻٜ مبِعِ، ‏«‏اٜنْ نَنِيکَ اٜ حٛنْدُکٛ مَاکٛ جٛونِ؞ اٜ وٛودِ کٛ طَٻِّتٜتٜنْ کَدِنْ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","سٜيْ حَوْرُتُٻٜ ٻٜنْ فُو اُمِّي، نجَارِمٛ يٜىٰسٛ بِلَاتُسْ، غٛمْنَاجٛ لٜيْدِ يَحُودِيَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","ٻٜ ڤُطِّ وُلَّاکِمٛ، اٜ ٻٜ مبِعَ، ‏«‏مِنْ تَوِي نٜطّٛ اٛعٛ اٜ مَجِّنَ لٜݧٛلْ اَمِنْ؞ اٜ مٛ حَطَ طُمْ يٛٻَ کَيْسَرْ مَوْطٛ لَامِيٻٜ شٜىٰدٜ لٜيْدِ، ندٜنْ اٜ مٛ وِعَ وَيْ کَنْکٛ وٛنِ اَلْمَسِيحُ، لَامِيطٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","سٜيْ بِلَاتُسْ پَمِ يٜىٰسُ وِعِ، ‏«‏اَنْ وٛنِ لَامِيطٛ يَحُودَنْکٛعٜنْ؟»‏ يٜىٰسُ نٛوتِي وِعِمٛ، ‏«‏اٜىٰ، اَ وِعِيکَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","بِلَاتُسْ وِعِ مَوْٻٜ اَرْدِيٻٜ دِينَ اٜ حَوْرُتُٻٜ ٻٜنْ، ‏«‏مِ يِعَايِ غٛطُّمْ کَلُّطُمْ طُمْ نَنْغِرْطٛنْ نٜطّٛ اٛعٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","اَمَّا ٻٜ شَلِي کٛ اٛ وِعِ، ٻٜ نغَطِ کَ مٜتُکِ دٛوْ يٜىٰسُ اٜ سٜمْبٜ، اٜ ٻٜ مبِعَ، ‏«‏کٛ اٛ اٜکِّتِنْتَ اٜ حَوْتَ يِمْٻٜ حَوْرٜ ندٜرْ لٜيْدِ يَحُودِيَ فُو؞ اٛ فُطِّي ندٜرْ لٜيْدِ غَلِيلِ، دَغَ تٛنْ حَا طٛعٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","ندٜ بِلَاتُسْ نَنِ نٛنْ، اٛ پَمِ اٛ وِعِ، ‏«‏اٛعٛ نٜطّٛ اٛ غَلِلَنْکٜىٰجٛ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","ندٜ اٛ حٜٻْتِ يٜىٰسُ دَغَ لٜيْ لَامُ حِرُدُسْ پِوٛيِ، اٛ وَطِ طُمْ يَارِمٛ تٛ حِرُدُسْ، نغَمْ اٜ شَرٜلْ نغٜلْ حِرُدُسْ اٜ طٛنْ اٜ اُرُشَلِيمَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","ندٜ حِرُدُسْ يِعِ يٜىٰسُ، اٛ نَنِ بٜلْطُمْ طُطُّمْ، نغَمْ طُمْ نٜىٰٻِي اٜ مٛ يِطِ اٛ يِعَ يٜىٰسُ وَطِي غٛطُّمْ کَيْطِنِيطُمْ، نغَمْ کٛ اٛ نَنِ دٛوْ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","اٛ پَمِ يٜىٰسُ پَمْطٜ طُطّٜ، اَمَّا يٜىٰسُ وِعَايِمٛ غٛطُّمْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","مَوْٻٜ اَرْدِيٻٜ دِينَ اٜ مٛودِٻّٜ اَتَّوْرَ اٜ ندَرِي طٛنْ اٜ مبِعَ اٜ سٜمْبٜ يٜىٰسُ وَطِي کٛ حَلِّ؞ ");
INSERT INTO fuv_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","سٜيْ حِرُدُسْ اٜ سٛوجِعٜنْ مُوطُمْ کُطِمٛ، نجُکِّتِمٛ، ندٜنْ حِرُدُسْ وَطِي طُمْ ٻٛرْنِمٛ کٛلْتٜ لَامِيطٛ، اٛ سٛعِّمٛ تٛ بِلَاتُسْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","اٜ ݧَلْندٜ ندٜنْ حِرُدُسْ اٜ بِلَاتُسْ ٻٜ نغَرْتِ حِغٛوٻٜ، نغَمْ کٛ فِي طُمْ وَطَ ٻٜ مبٜلْدَا؞ ");
INSERT INTO fuv_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","بِلَاتُسْ نٛدِّ مَوْٻٜ اَرْدِيٻٜ دِينَ، اٜ لَامِيٻٜ، اٜ يِمْٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","اٛ وِعِٻٜ، ‏«‏اٛنْ نغَدَّنِييَمْ نٜطّٛ اٛعٛ، اٛنْ مبِعِ اٜ مٛ مَجِّنَ يِمْٻٜ؞ مِ پَمِيمٛ يٜىٰسٛ مٛوطٛنْ، اَمَّا مِ يِعَايِ غٛطُّمْ طُمْ نَنْغِرْطٛنْمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","نٛنْ مَا حِرُدُسْ، نغَمْ اٛ سٛعّٛيِيمٛ تٛ مٜىٰطٜنْ؞ رَا، اٛ وَطَايِ غٛطُّمْ کٛ حَانِ طُمْ وَرَمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","نغَمْ نٛنْ، مِ وَطَيْ طُمْ فِيَمٛ، ندٜنْ مِ يٛوفَمٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","‏‏تٛو، ندٜنْ مَا کٛو ندٜيٜ حِتَاندٜ بِلَاتُسْ اٜ يٛوفَنَٻٜ کَٻَّاطٛ غٛعٛتٛ؞‏ ");
INSERT INTO fuv_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","اَمَّا ٻٜ فُو ٻٜ نغَطِ کَ وِعُکِ اٜ سٜمْبٜ، ‏«‏وَرُ نٜطّٛ اٛعٛ؞ نجٛوفَنَامِنْ بَرَبَّسْ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","بَرَبَّسْ بٛو طُمْ غٛطّٛ مٛ طُمْ وَطِ ندٜرْ سُودُ شُرَلْ نغَمْ اٜ مٛ ندٜرْ يِمْٻٜ کَٻْدُٻٜ اٜ لَامُ ندٜرْ غَرِيرِ، کَدِنْ نغَمْ اٛ وَرِي غٛطّٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","بِلَاتُسْ فُطِّتِ مٜتَنِٻٜ نغَمْ اٜ مٛ يِطِ يٛوفُکِ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","اَمَّا ٻٜ نغَطِ کَ وِعُکِ اٜ سٜمْبٜ، ‏«‏وَرُمٛ!‏ وَرُمٛ دٛوْ غَافَانغَلْ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","بِلَاتُسْ وِعِٻٜ تَتَٻُمْ، ‏«‏نغَمْ طُمٜ؟ طُمٜ کٛ حَلِّ اٛ وَطِ؟ مِ يِعَايِ کٛ اٛ وَطِ کٛ حَانِ طُمْ وَرَمٛ؞ نغَمْ نٛنْ، مِ فِيَيْمٛ، مِ يٛوفَمٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","اَمَّا ٻٜ نغَطِ کَ وِعُکِ اٜ سٜمْبٜ، ‏«‏وَرُمٛ دٛوْ غَافَانغَلْ!‏»‏ بٛلِيطٜ مَٻّٜ شَلٛرِي بِلَاتُسْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","نغَمْ نٛنْ اٛ جَٻِ اٛ وَطَ کٛ ٻٜ مبِعِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","اٛ يٛوفَنِٻٜ نٜطّٛ مٛ ٻٜ نغِطِ اٛ يٛوفَنَٻٜ، غَطَاطٛ ندٜرْ سُودُ شُرَلْ نغَمْ وَرْحٛورٜ اٜ حَٻْدُکِ اٜ لَامُ؞ ندٜنْ اٛ وَطِ يٜىٰسُ ندٜرْ جُوطٜ مَٻّٜ نغَمْ ٻٜ نغَطَنَمٛ کٛ ٻٜ نغِطِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","اٜ ٻٜ اَرْدِنِ يٜىٰسُ، سٜيْ ٻٜ نَنْغِ سِيمَنْ سَايِرَنْکٜىٰجٛ پِوٛيْطٛ ندٜرْ لَدّٜ اٜ نَتّٛيَ غَرِيرِ ندِنْ؞ ٻٜ نجٛوَنِمٛ غَافَانغَلْ، ٻٜ نغَطِ اٛ تٛکِّرِ يٜىٰسُ غَطَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","يِمْٻٜ طُطْٻٜ تٛکِّمٛ، حَوْتِ اٜ وٛٻّٜ رٜوْٻٜ؞ رٜوْٻٜ ٻٜنْ اٜ ندٛوندِي جُوطٜ مُعّٜنْ، اٜ ٻٜ مبٛيَ نغَمْ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","اَمَّا يٜىٰسُ يٜىٰپِيٻٜ وِعِ، ‏«‏رٜوْٻٜ اُرُشَلِيمَ، اَلٜىٰ وٛيَنْکِيَمْ، مبٛيَنٜىٰ کٛعٜ مٛوطٛنْ اٜ ٻِٻّٜ مٛوطٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","نغَمْ بَلْطٜ نغَرٛيَيْ طٜ يِمْٻٜ مبِعَتَ، ‏‹‏ٻٜ بَرْکِطِنَاٻٜ رٜوْٻٜ ٻٜ ندَݧَتَا، ٻٜ دٜىٰطِ مُعّٜنْ مٜىٰطَايِ سَاوُکِ ٻِطّٛ، ٻٜ اٜنْطِ مُعّٜنْ مٜىٰطَايِ مُسِنٜىٰکِ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","اٜ شَرٜلْ نغٜلْ يِمْٻٜ مبِعَيْ کٛشّٜىٰجٜ، ‏‹‏نجَنٛيٜىٰ دٛوْ اَمِنْ!‏›‏ ٻٜ مبِعَ پٛولٜ ‏‹‏شُوطٜىٰمِنْ!‏›‏ ");
INSERT INTO fuv_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","تٛ يِمْٻٜ نغَطِي فِي طُعُمْ شَرٜلْ نغٜلْ لٜکِّ وٛنِ کٜشِّ، کٛ وَطَتَ تٛ کِ يٛورِي؟»‏ ");
INSERT INTO fuv_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","طُمْ اَرْدِنِ يٜىٰسُ اٜ وُيْٻٜ طِطٛ، نغَمْ ٻٜ مبَرٛيَٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","ٻٜ نغَرِ تٛ وٛنْدٜ وِغٜىٰرٜ بِعٜتٜىٰندٜ ‏«‏پِپَلْ حٛورٜ؞»‏ طٛنْ ٻٜ ٻِلِمٛ، ٻٜ ڤِيَنِمٛ کُوسَاجٜ دٛوْ غَافَانغَلْ، کَنْکٛ اٜ وُيْٻٜ طِطٛ ٻٜنْ، غٛعٛتٛ اٜ جُنْغٛ مَاکٛ ݧَامٛ، غٛعٛتٛ اٜ جُنْغٛ مَاکٛ نَنٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","يٜىٰسُ وِعِ، ‏«‏ݧَاکٛ اَمْ مٛ دٛوْ، يَافَنَ بَرٛوٻٜيَمْ نغَمْ ٻٜ اَنْدَا کٛ ٻٜ نغَطَتَ؞»‏ اَمَّا سٛوجِعٜنْ رٛومَ نغَطِ شَاشَ نغَمْ ٻٜ شٜنْدَ کٛلْتٜ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","يِمْٻٜ ندَرِي اٜ ندَارَ، اَرْدِيٻٜ نجُکِّتِمٛ اٜ مبِعَ، ‏«‏اٛ حِسْنِي وٛٻّٜ؞ تٛ کَنْکٛ وٛنِ اَلْمَسِيحُ مٛ اَللَّه سُٻِ، اَلْ اٛ حِسْنَ حٛورٜ مَاکٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","سٛوجِعٜنْ مَا نغَطِ کَ جُکُّتُکِمٛ، ٻٜ پٜىٰݝِ حَادٜ مَاکٛ، ٻٜ کٛکِّمٛ ندِيَمْ اِنَبٛجَمْ لَمُّطَمْ، ٻٜ مبِعِمٛ، ");
INSERT INTO fuv_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","‏«‏تٛ اَنْ وٛنِ لَامِيطٛ يَحُودَنْکٛعٜنْ، حِسْنُ حٛورٜ مَاطَ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","کَدِمَا دٛوْ حٛورٜ غَافَانغَلْ نغَلْ طُمْ تَکِّ اَلّٛوَلْ؞ طُمْ وِنْدِ دٛوْ مَاغَلْ کٛ طُمْ وُلّٛرِيمٛ وِعُکِ، ‏«‏اٛعٛ وٛنِ لَامِيطٛ يَحُودَنْکٛعٜنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","غٛعٛتٛ ندٜرْ وُيْٻٜ طِطٛ ٻِلْدَاٻٜ اٜ مَاکٛ وَطَنِمٛ حَالَ نَوْکَ، وِعِ، ‏«‏نَاع اَنْ وٛنِ اَلْمَسِيحُ؟ حِسْنُ حٛورٜ مَاطَ، ندٜنْ کِسْنَامِنْ، مِنٛنْ مَا!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","اَمَّا غُجّٛ غٛعٛتٛ اٛنْ حَلْٻَنِمٛ، وِعِ، ‏«‏اَ حُلَتَا اَللَّه، اَنْ جَرْدٛووٛ تٛرَّ غٛعٛ اٜ مَاکٛ؟ ");
INSERT INTO fuv_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","اٜنٜنْ اٜنْ کٜٻِي کٛ حَانِ طُمْ وَطَنَعٜنْ، نغَمْ کٛ نغَطّٜنْ وٛوطَا؞ اَمَّا نٜطّٛ اٛعٛ، اٛ وَطَايِ غٛطُّمْ کٛ وٛوطَا؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","ندٜنْ اٛ وِعِ، ‏«‏يٜىٰسُ، تَاع يٜجِّتَمْ شَرٜلْ نغٜلْ نَتُّطَا لَامُ مَاطَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","يٜىٰسُ وِعِمٛ، ‏«‏اٜ مِ وِعُمَا غٛونغَ، حَنْدٜ اَ وٛنْدَيْ اٜ اَمْ ندٜرْ وُرٛ اَللَّه؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","اٜ شَرٜلْ نغٜلْ طُمْ شَکَ ݧَلَوْمَ، اَمَّا سٜيْ ݧِوْرٜ مَٻِّ لٜيْدِ فُو حَا يَاکِ نجَمْندِ تَتِ، ");
INSERT INTO fuv_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","ݧِوْرٜ سُدِّ نَانغٜ؞ سٜيْ وُدٜرٜ شٜنْدُندٜ سُودُ جٛومِرَاوٛ سٜىٰکِ طِطِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","يٜىٰسُ وِعِ اٜ سٜمْبٜ، ‏«‏ݧَاکٛ اَمْ مٛ دٛوْ، مِ حٛکِّي يٛنْکِ اَمْ ندٜرْ جُنْغٛ مَاطَ!‏»‏ ندٜ اٛ وِعِ نٛنْ، اٛ مَايِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","ندٜ مَوْطٛ سٛوجِعٜنْ اٛنْ يِعِ کٛ وَطِ، سٜيْ اٛ مَنْتِ اَللَّه، اٛ وِعِ، ‏«‏غٛونغَ، نٜطّٛ اٛعٛ اٛ اَادِلِيجٛ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","ندٜ يِمْٻٜ فُو مٛٻْتِيٻٜ نغِعَ کٛ وَطَتَ نغِعِ نٛنْ، ٻٜ کٛوتِ اٜ ٻٜ ندٛوندِي جُوطٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","اَمَّا اَنْدُٻٜمٛ فُو اٜ رٜوْٻٜ تٛکّٛيْٻٜمٛ دَغَ غَلِيلِ ندَرِي تٛ وٛطِّ اٜ ندَارَ کٛو طُمٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK23_50‏","072_23_50‏","LUK","23","50‏","51","اٜ وٛودِ غٛطّٛ بِعٜتٜىٰطٛ يُسُفُ دَغَ غَرِيرِ اَرْمَاتِيَ ندٜرْ لٜيْدِ يَحُودَ، اَادِلِيجٛ؞ اٛ غٛعٛتٛ ندٜرْ کَوْتَلْ مَوْٻٜ، اَمَّا اٛ جَٻَايِ کٛ ٻٜ شُٻِ اٜ کٛ ٻٜ نغَطِ؞ اٛ حَاٻِي يِعُکِ غَرٛلْ لَامُ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","کَنْکٛ يَحِ تٛ بِلَاتُسْ، اٛ تٛرِي طُمْ حٛکَّمٛ ٻَنْدُ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","اٛ وَطِ طُمْ جِڤِّنِ ٻَنْدُ ندُنْ دَغَ دٛوْ غَافَانغَلْ، اٛ تَارِرِندُ وُدٜرٜ ندٜ شٜىٰدٜ؞ سٜيْ اٛ فُکِّنٛيِندُ ندٜرْ يٜنَاندٜ وَسَاندٜ ندٜرْ حَيْرٜ، طُمْ مٜىٰطَايِ وَطُکِ غٛطّٛ ندٜرْ مَيْرٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","طُمْ ݧَلْندٜ سِرْيَاکِ، حٛرِي سٜطَّ طُمْ نَتَّ ݧَلْندٜ سِوْتَارٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","رٜوْٻٜ غَرْدُٻٜ اٜ يٜىٰسُ دَغَ لٜيْدِ غَلِيلِ ٻٜ تٛکِّ يُسُفُ، ٻٜ نغِعِ يٜنَاندٜ ندٜنْ، اٜ نٛ طُمْ فُکِّنِرِ ٻَنْدُ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","سٜيْ ٻٜ شٛعِّي وُرٛ، ٻٜ مٛعِّنِ نٜبَّمْ اُرٛوجَمْ، اَمَّا ٻٜ شِوْتِي اٜ ݧَلْندٜ سِوْتَارٜ نٛ اَتَّوْرَ وِعِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","ݧَلْندٜ اَلَلْ سُبَکَ، رٜوْٻٜ ٻٜنْ کٛشِّ نٜبَّمْ اُرٛوجَمْ طَمْ ٻٜ مٛعِّنِ نغَمْ ٻٜ مٛيْتَنَ ٻَنْدُ مَاکٛ، ٻٜ نجَحِ يٜنَاندٜ ندٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","ٻٜ تَوِ حَيْرٜ ندٜنْ تَلِّتَامَ دَغَ دَمُّغَلْ يٜنَاندٜ ندٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","اَمَّا ندٜ ٻٜ نَتِّ، ٻٜ تَوَايِ ٻَنْدُ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","اٜ ٻٜ ندٜرْ وَنَّارٜ دٛوْ فِي طُمْ، سٜيْ بٛ مَپّٜرٜ ٻٜ نغِعِ وٛرْٻٜ طِطٛ اٜ ندَرِي حَادٜ مَٻّٜ؞ اٜ ٻٜ ٻٛرْنِي کٛلْتٜ دَنٜىٰجٜ تَرْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","کُلٛلْ نَنْغِٻٜ، سٜيْ ٻٜ نجَنِ ٻٜ کِڤِّي؞ وٛرْٻٜ ٻٜنْ مبِعِٻٜ، ‏«‏نغَمْ طُمٜ طَٻِّتٛتٛنْ مٛ يٛنْکِ ندٜرْ مَيْٻٜ؟ ");
INSERT INTO fuv_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","اٛ وَلَا طٛعٛ؞ طُمْ اُمِّنِيمٛ دَغَ مَيْدٜ!‏ شِفْتٛرٜىٰ کٛ اٛ وِعُنٛوعٛنْ کٛ اٛ وٛنْدُنٛو اٜ مٛوطٛنْ ندٜرْ لٜيْدِ غَلِيلِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","اٛ وِعِي، ‏‹‏دٛولٜ ٻِي نٜطّٛ حٛکِّتِرٜىٰ ندٜرْ جُوطٜ کَلُّٻٜ، اٛ وَرٜىٰ دٛوْ غَافَانغَلْ، ندٜنْ اٛ اُمّٛو ندٜرْ ݧَلْندٜ تَتَوْرٜ؞›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","سٜيْ ٻٜ شِفْتٛرِ کٛ اٛ وِعُنٛوٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","ٻٜ نغَرْتٛيِ دَغَ يٜنَاندٜ ندٜنْ، ٻٜ مبِعِ تٛکُّٻٜ يٜىٰسُ سَڤّٛ اٜ غٛعٛ، حَا اٜ وٛٻّٜ، کٛ وَطِ فُو؞ ");
INSERT INTO fuv_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","رٜوْٻٜ ٻٜنْ نغٛنِ مَرْيَامَ پِوٛيْطٛ مَغَدَلَ، اٜ يٛوَانَ، اٜ مَرْيَامَ مَدُوجٛ يَاکُبُ، اٜ وٛٻّٜ رٜوْٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","اَمَّا تٛکُّٻٜ يٜىٰسُ نجَٻَايِ کٛ رٜوْٻٜ ٻٜنْ مبِعِٻٜ، ٻٜ نغَرْتِرِ حَالَ کَنْ بٛ تَالٛلْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","بِيتُرُسْ بٛو اُمِّي، دٛغِّ يَحِ يٜنَاندٜ ندٜنْ، يُرْنِيندٜ، غُدٜ طٜ طُمْ تَارِرْنٛو ٻَنْدُ يٜىٰسُ تَنْ اٛ يِعِ؞ اٛ سٛعِّي اٜ مٛ پَمَ حٛورٜ مَاکٛ کٛ وَطِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","اٜ ݧَلْندٜ ندٜنْ تٛکُّٻٜ يٜىٰسُ طِطٛ اٜ نجَحَ وٛنْغٜلْ غَرِيٜلْ بِعٜتٜىٰنغٜلْ اِمَاوُسْ؞ حَکُّندٜ غَرِيٜلْ نغٜلْ اٜ اُرُشَلِيمَ وَطِي مِلْ جٛوٜىٰطِطِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","اٜ ٻٜ نجَحَ اٜ ٻٜ مٜتَ حَکُّندٜ مَٻّٜ دٛوْ کٛ وَطِ فُو؞ ");
INSERT INTO fuv_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","اٜ ٻٜ نغٜوْتَ دٛوْ فِي طُمْ حَکُّندٜ مَٻّٜ، سٜيْ يٜىٰسُ اٜ حٛورٜ مُوطُمْ حٜوْتِيٻٜ وَطِ کَ يَادُکِ اٜ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","اَمَّا اَللَّه وَطِ ٻٜ اَنْدِتَايِمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","يٜىٰسُ پَمِٻٜ وِعِ، ‏«‏دٛوْ طُمٜ نغٜوْتٛتٛنْ ندٜرْ يَادُ مٛوطٛنْ؟»‏ سٜيْ ٻٜ ندَرِي، ٻٜ مبٛنِّ غٜىٰشٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","غٛعٛتٛ مَٻّٜ بِعٜتٜىٰطٛ کِلِيٛوبَسْ وِعِ، ‏«‏اَنْ تَنْ وٛنِ کٛطٛ ندٜرْ اُرُشَلِيمَ مٛ اَنْدَا کٛ وَطِ تٛنْ ندٜرْ بَلْطٜ طٜعٜ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","اٛ وِعِ، ‏«‏طُمٜ وَطِ؟»‏ ٻٜ مبِعِ، ‏«‏کٛ حٜٻِ يٜىٰسُ نَجَرَنْکٜىٰجٛ؞ اٛ اَنَّبِيجٛ غٛودُطٛ بَوْطٜ ندٜرْ بٛلِيطٜ اٜ کُوطٜ يٜىٰسٛ اَللَّه اٜ يِمْٻٜ فُو؞ ");
INSERT INTO fuv_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","مَوْٻٜ اَرْدِيٻٜ دِينَ اٜ اَرْدِيٻٜ مٜىٰطٜنْ نغَطِمٛ ندٜرْ جُوطٜ لَامُ نغَمْ طُمْ وَرَمٛ، ندٜنْ ٻٜ مبَرِمٛ دٛوْ غَافَانغَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","اَمَّا اٜ مِنْ کَمِّنٛو کَنْکٛ وٛنِ رِمْطِنَيْطٛ يِمْٻٜ اِسْرَاعِيلَ؞ کٛ ٻُرِ نٛنْ مَا، حَنْدٜ وٛنِ ݧَلْندٜ تَتَوْرٜ کٛ طُعُمْ فِي فُو وَطِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","کَدِمَا وٛٻّٜ رٜوْٻٜ ندٜرْ اَمِنْ کَيْطِنِيمِنْ؞ ٻٜ نجَحِ تٛ يٜنَاندٜ ندٜنْ حَنْدٜ سُبَکَ، ");
INSERT INTO fuv_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","اَمَّا ٻٜ تَوَايِ ٻَنْدُ مَاکٛ؞ سٜيْ ٻٜ نغَرْتِ ٻٜ مبِعِمِنْ ٻٜ نغِعِي مَلَاعِکَعٜنْ وِعُٻٜ يٜىٰسُ اٜ وٛودِ يٛنْکِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","وٛٻّٜ ٻٜ مِنْ نغٛنْدِ نجَحِ تٛ يٜنَاندٜ ندٜنْ، ٻٜ تَوِندٜ نٛ رٜوْٻٜ ٻٜنْ مبِعِ، اَمَّا کَنْکٛ ٻٜ نغِعَايِمٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","يٜىٰسُ وِعِٻٜ، ‏«‏اٛنْ نغَلَا فَامُ، ٻٜرْطٜ مٛوطٛنْ اٜ نٜىٰٻَ نجَٻَايِ کٛو طُمٜ کٛ اَنَّبٛعٜنْ مبِعُنٛو!‏ ");
INSERT INTO fuv_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","اٛنْ اَنْدَا دٛولٜ اَلْمَسِيحُ يَرَ تٛرَّ نِحِ ندٜنْ نَتَّ تٜدُّنغَلْ مُوطُمْ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","ندٜنْ اٛ فَمْتِنِٻٜ کٛ دٜفْتٜرٜ وِعِ وَطَيْ دٛوْ مَاکٛ، دَغَ اَتَّوْرَ يَاکِ دٜفْتٜ اَنَّبٛعٜنْ فُو؞ ");
INSERT INTO fuv_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","ندٜ ٻٜ ٻَدِي غَرِيٜلْ نغٜلْ ٻٜ نجَحَتَ، سٜيْ يٜىٰسُ وَطِ بٛ پَٻّٛتٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","اَمَّا ٻٜ تٛرِيمٛ ٻٜ مبِعِ، ‏«‏يَالُ مبَالَا تٛ اَمِنْ، نغَمْ نَانغٜ حِيرِي، جٜمَّ وَطِي؞»‏ سٜيْ اٛ يَالِ نغَمْ اٛ وَالَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","شَرٜلْ کٛ ٻٜ ݧَامَتَ ݧَمْندُ، اٛ حٛشِّ بُرٛودِ، اٛ يٜتِّ اَللَّه، اٛ سٜنْدِطُمْ، اٛ حٛکِّٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","سٜيْ اَللَّه مَٻِّتِ غِتٜ مَٻّٜ، ٻٜ اَنْدِتِمٛ؞ طٛنْ اٜ طٛنْ اٛ مَجِّتِ يٜىٰسٛ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","سٜيْ ٻٜ مبِعِ حَکُّندٜ مَٻّٜ، ‏«‏اٜنْ نَنِي بٜلْطُمْ ندٜرْ ٻٜرْطٜ مٜىٰطٜنْ کٛ اٛ مٜتَنَيْنٛوعٜنْ دٛوْ طَتَلْ اٜ مٛ فَمْتِنَعٜنْ دٜفْتٜرٜ شٜنِيندٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","ٻٜ اُمِّي طٛنْ اٜ طٛنْ ٻٜ شٛعِّي اُرُشَلِيمَ؞ ٻٜ تَوِ تٛکُّٻٜ يٜىٰسُ سَڤّٛ اٜ غٛعٛ اٜ وٛنْدُٻٜ اٜ مَٻّٜ اٜ کَوْرِتِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","حَوْرُتُٻٜ ٻٜنْ مبِعِ طِطٛ ٻٜنْ، ‏«‏غٛونغَ، مٛودِبّٛ اُمَّکٜ؞ اٛ وَنْغَنِي سِيمَنْ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","سٜيْ طِطٛ ٻٜنْ مَا مبِعِٻٜ کٛ وَطِ دٛوْ طَتَلْ اٜ نٛ ٻٜ اَنْدِتِرِمٛ ندٜ اٛ سٜنْدِ بُرٛودِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","اٜ ٻٜ ندٜرْ مٜتُکِ حَالَ کَنْ، سٜيْ طٛنْ اٜ طٛنْ يٜىٰسُ اٜ حٛورٜ مُوطُمْ وَنْغِ دَرِي شَکَ مَٻّٜ؞ اٛ وِعِٻٜ، ‏«‏اٜ مِ سِلْمِنٛو؞ جَمْ وٛنْدَ اٜ مٛوطٛنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","ٻٜرْطٜ مَٻّٜ تَپِ، ٻٜ کَمِّي غِنّٛلْ ٻٜ نغِعِ؞ ");
INSERT INTO fuv_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","اَمَّا اٛ وِعِٻٜ، ‏«‏طُمٜ وَنِّعٛنْ؟ نغَمْ طُمٜ نغَطٛتٛنْ سٜکٛ ندٜرْ ٻٜرْطٜ مٛوطٛنْ؟ ");
INSERT INTO fuv_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","ندَارٜىٰ جُوطٜ اَمْ اٜ کٛيْطٜ اَمْ، طُمْ مِنْ اٜ حٛورٜ اَمْ؞ مٜىٰمٜىٰيَمْ نَنٛنْ، اَيْ غِنّٛلْ وَلَا ٻَنْدُ اٜ پِعٜ نٛ نغِيرُطٛنْيَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","ندٜ اٛ وِعِ نٛنْ، اٛ حٛلِّٻٜ جُوطٜ مَاکٛ اٜ کٛيْطٜ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","ٻٜ نجَٻَايِ طُمْ غٛونغَ نغَمْ بٜلْطُمْ اٜ حَيْطِنْکِ؞ سٜيْ اٛ وِعِٻٜ، ‏«‏اٛنْ نغٛودِ غٛطُّمْ کٛ ݧَامٜتٜىٰ طٛعٛ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","سٜيْ ٻٜ کٛکِّمٛ تَيْرٜ لِنْغُ نجُطَانغُ، ");
INSERT INTO fuv_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","اٛ حٛشِّنغُ اٛ ݧَامِ يٜىٰسٛ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","ندٜنْ اٛ وِعِٻٜ، ‏«‏طُعُمْ وٛنِ کٛ مبِينٛومِعٛنْ شَرٜلْ کٛ نغٛنْدُنٛومِ اٜ مٛوطٛنْ:‏ کٛو طُمٜ کٛ وِنْدَا ندٜرْ اَتَّوْرَ، اٜ دٜفْتٜ اَنَّبٛعٜنْ، اٜ جَبُورَ دٛوْ اَمْ دٛولٜ طُمْ حٜىٰوَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","ندٜنْ اٛ مَٻِّتِ فَامُ مَٻّٜ نغَمْ ٻٜ ڤَامَ دٜفْتٜرٜ شٜنِيندٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","اٛ وِعِٻٜ، ‏«‏اَايَارٜ وِعِي:‏ اَلْمَسِيحُ تٛرّٛتٛ، غَطَ بَلْطٜ تَتِ اٛ اُمّٛتٛ دَغَ مَيْدٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","ندٜرْ اِنْدٜ مَاکٛ طُمْ وَعَجِنَيْ تُوبُکِ اٜ يَافَنٜىٰکِ حَکّٜ يَاکِ ندٜرْ لٜݧِ فُو؞ طُمْ فُطَّيْ دَغَ اُرُشَلِيمَ؞ ");
INSERT INTO fuv_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","اٛنٛنْ نغٛنِ اَنْدِنَيْٻٜ وٛٻّٜ فِي طُعُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","رَطُّمْ، مِ لِلْدٛيَيْعٛنْ رُوحُ اَللَّه نٛ ݧَاکٛ اَمْ وَطِ اَلْکَوَلْ؞ نجٛوطٜىٰ ندٜرْ اُرُشَلِيمَ نَا رُوحُ اَللَّه جِڤّٛيَکٜ دٛوْ مٛوطٛنْ حٛکِّيعٛنْ بَوْطٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","يٜىٰسُ اَرْدِيٻٜ ٻٜ مبُرْتِي ندٜرْ اُرُشَلِيمَ يَاکِ وٛنْدٜ وِغٜىٰرٜ حَادٜ غَرِيرِ بٜتَنِ، اٛ پٜفْتِ جُوطٜ مَاکٛ اٛ بَرْکِطِنِٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","اٜ مٛ ندٜرْ بَرْکِطِنْکِٻٜ، سٜيْ اٛ حٛشَّا يَاکِ دٛوْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","ٻٜ مَوْنِنِمٛ، ٻٜ شٛعِّي اُرُشَلِيمَ اٜ ٻٜ نَنَ بٜلْطُمْ طُطُّمْ؞ ");
INSERT INTO fuv_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","کٛو ندٜيٜ ݧَلْندٜ اٜ ٻٜ نجَحَ وُرٛ شٜنِينغٛ اٜ ٻٜ مَنْتَ اَللَّه؞");
INSERT INTO fuv_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","دَغَ کٛ دُونِيَارُ تَغٜىٰ بِعٜتٜىٰطٛ وٛلْدٜ اٜ طٛنْ، اٜ مٛ وٛنْدِ اٜ اَللَّه، ندٜنْ اٛ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","دَغَ کٛ دُونِيَارُ تَغٜىٰ بِعٜتٜىٰطٛ وٛلْدٜ اٛنْ اٜ وٛنْدِ اٜ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","اٛ تَغِي کٛو طُمٜ؞ وَلَا غٛطُّمْ ندٜرْ فُو کٛ تَغَا طُمْ اُمْ تَغِرَايِ لَاوٛلْ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","تٛ مَاکٛ يٛنْکِ پِوٛيِ، ندٜنْ يٛنْکِ کِنْ وٛنِ جَيْنغٛلْ يِمْٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","جَيْنغٛلْ نغٛلْ اٜ وَطِ کَ يٜيْنَاکِ ندٜرْ ݧِوْرٜ، ݧِوْرٜ بٛو وَاوَايِ جَالَاکِنغٛلْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","اٜ وٛودِ غٛطّٛ نٜطّٛ مٛ اَللَّه لِلٛيِ بِعٜتٜىٰطٛ يَحَيَ؞ ");
INSERT INTO fuv_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","اٛ وَرِي اٛ اَنْدِنَ يِمْٻٜ حَبَرُ جَيْنغٛلْ نغٛلْ، نغَمْ اٜ لَاوٛلْ مَاکٛ کٛو مٛيٜ جَٻَ جَيْنغٛلْ نغٛلْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","نَاع کَنْکٛ وٛنِ جَيْنغٛلْ نغٛلْ؞ اٛ وَرٛيِ اٛ اَنْدِنَ حَبَرُ تَنْ دٛوْ مَاغٛلْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","کَنْغٛلْ وٛنِ جَيْنغٛلْ غٛونغَوٛلْ يٜيْنٛتٛونغٛلْ دٛوْ کٛو مٛيٜ؞ نغٛلْ بٛو وَرِي ندٜرْ دُونِيَارُ؞ ");
INSERT INTO fuv_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","بِعٜتٜىٰطٛ وٛلْدٜ اٛنْ ندٜنّٛ اٜ مٛ ندٜرْ دُونِيَارُ؞ کٛو ندٜ کَنْکٛ تَغِ دُونِيَارُ، فُو اٜ نٛنْ دُونِيَارُ اَنْدَامٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","اٛ وَرِي تٛ ٻٜ مَاکٛ، اَمَّا ٻٜ نجَٻَايِمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","اَمَّا فُو جَٻُٻٜمٛ کٛولِيٻٜ اِنْدٜ مَاکٛ، اٛ حٛکِّيٻٜ بَوْطٜ وَرْتُکِ ٻِٻّٜ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","ٻٜ نغَرْتَايِ ٻِٻّٜ اَللَّه نغَمْ ٻٜ ندَݧَامَ نٛ طُمْ دَݧِرْتَ يِمْٻٜ، کٛو نغَمْ يِمْٻٜ نغِطِ نٛنْ وَطَ؞ اَللَّه اٜ حٛورٜ مُوطُمْ وَرْتِرِٻٜ ٻِٻّٜ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","بِعٜتٜىٰطٛ وٛلْدٜ اٛنْ، اٛ وَرْتِي نٜطّٛ، اٛ جٛوطِي ندٜرْ مٜىٰطٜنْ، اٛ کٜوْطٛ يِدّٜ اٜ غٛونغَ؞ اٜنْ نغِعِي تٜدُّنغَلْ مَاکٛ، تٜدُّنغَلْ ٻِطّٛ بَجّٛ پِوٛيْطٛ تٛ ݧَاکٛ مٛ دٛوْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","يَحَيَ حٛکِّي شٜيْدَ دٛوْ مَاکٛ، مٜتِي سٜمْبٜىٰ وِعِي، ‏«‏دٛوْ اٛعٛ مٜتُنٛومِ ندٜ مبِيمِ، ‏‹‏اٛنْ طٛنْ غَرَيْطٛ غَطَ اَمْ اٛ ٻُرِييَمْ مَنْغُ، نغَمْ اٜ مٛ طٛنْ کٛ مِ دَݧٜىٰ؞›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","نغَمْ يِدّٜ مَوْندٜ ندٜ اٛ يِطِعٜنْ، اٛ بَرْکِطِنِيعٜنْ اٜنْ فُو، بَرْکَ دٛوْ بَرْکَ؞ ");
INSERT INTO fuv_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","اَللَّه حٛکِّي اَتَّوْرَ اٜ لَاوٛلْ مُوسَ، اَمَّا اٜ لَاوٛلْ يٜىٰسُ اَلْمَسِيحُ اٛ حٛلِّي يِدّٜ اٜ غٛونغَ؞ ");
INSERT INTO fuv_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","وَلَا نٜطّٛ مٜىٰطُطٛ يِيکِ اَللَّه؞ ٻِطّٛ مَاکٛ بَجّٛ، غٛنْطٛ ندٜرْ ٻٜرْندٜ ݧَاکٛ مٛ دٛوْ، کَنْکٛ حٛلِّعٜنْ نٛ اَللَّه وَعِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","رَا شٜيْدَ طُمْ يَحَيَ حٛکِّ شَرٜلْ کٛ اَرْدِيٻٜ يَحُودَنْکٛعٜنْ ندٜرْ اُرُشَلِيمَ لِلِ وٛٻّٜ اَرْدِيٻٜ دِينَ اٜ لٜىٰوِيَنْکٛعٜنْ تٛ مَاکٛ ٻٜ پَمَمٛ کَنْکٛ اٛ مٛيٜ؞ ");
INSERT INTO fuv_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","اٛ وَݧَايِ نٛوتَاکِٻٜ، اَمَّا اٛ وِعِٻٜ اٜ نجَيْرِ، ‏«‏نَاع مِنْ وٛنِ اَلْمَسِيحُ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","ٻٜ مبِعِمٛ، ‏«‏تٛ نَاع اَنْ وٛنِ اَلْمَسِيحُ، تٛو، اَنْ اَ مٛيٜ؟ اَنْ وٛنِ اِلِيَ؟»‏ يَحَيَ نٛوتِي وِعِٻٜ، ‏«‏کٛو سٜطَّ، نَاع طُمْ مِنْ؞»‏ ٻٜ پَمِمٛ ٻٜ مبِعِ، ‏«‏اَنْ وٛنِ اٛنْ طٛنْ اَنَّبِيجٛ؟»‏ اٛ وِعِ، ‏«‏اَاعَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","سٜيْ ٻٜ مبِعِمٛ، ‏«‏تٛو، وِعُمِنْ، اَنْ، اَ مٛيٜ؟ وِعُمِنْ کٛ مِنْ مبِعَتَ لِلٛيْٻٜمِنْ؞ مٛيٜ نٛدِّرْتَا حٛورٜ مَاطَ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","سٜيْ يَحَيَ وِعِٻٜ کٛ اَنَّبِ اِشَايَ وِعُنٛ، اٛ وِعِ، ‏«‏مِنْ وٛنِ غٛطّٛ نٛدّٛووٛ ندٜرْ لَدّٜ اٜ وِعَ، ‏‹‏ڤٛرْتٜىٰ لَاوٛلْ نغَمْ جٛومِرَاوٛ؞›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","سٜيْ وٛٻّٜ فَارِسَنْکٛعٜنْ ٻٜ طُمْ لِلِ ");
INSERT INTO fuv_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","پَمِمٛ مبِعِ، ‏«‏تٛ نِ نَاع اَنْ وٛنِ اَلْمَسِيحُ، کَدِنْ نَاع اَنْ وٛنِ اِلِيَ، کٛو اٛنْ طٛنْ اَنَّبِيجٛ، نغَمْ طُمٜ نغَطَنْتَا يِمْٻٜ بَڤْتِسْمَ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","يَحَيَ وِعِٻٜ، ‏«‏اٜ مِ وَطِرَ بَڤْتِسْمَ اٜ ندِيَمْ، اَمَّا ندٜرْ مٛوطٛنْ اٜ وٛودِ غٛطّٛ مٛ اٛنْ اَنْدَا، ");
INSERT INTO fuv_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","غَرٛيَيْطٛ غَطَ اَمْ؞ مِ فٛتَايِ فِتُّکِ لٛکُّلِّ ڤَطٜ مَاکٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","فُو طُعُمْ طُمْ وَطِي تٛ بٜتَنِ فٛنْغٛ شَانغٛلْ اُرْدُنْ، تٛ يَحَيَ وَطَتَ بَڤْتِسْمَ؞ ");
INSERT INTO fuv_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","غَطَ طُعُمْ وَطِي ندٜ فِنِ يَحَيَ يِعِ يٜىٰسُ اٜ وَرٛيَ تٛ مُوطُمْ، اٛ وِعِ، ‏«‏رَا کَرٛورِ اَللَّه، اِتَّيْندِ حَکّٜىٰجِ دُونِيَارُ!‏ ");
INSERT INTO fuv_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","اٛعٛ دٛوْ مَاکٛ مٜتَيْنٛومِ ندٜ مبِيمِ، ‏‹‏غٛطّٛ اٜ وَرَ غَطَ اَمْ اٛ ٻُرِييَمْ مَنْغُ، نغَمْ اٜ مٛ طٛنْ کٛ مِ دَݧٜىٰ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","مِنْ اٜ حٛورٜ اَمْ مِ اَنْدَامٛ، اَمَّا مِ وَرِي اٜ مِ وَطِرَ بَڤْتِسْمَ اٜ ندِيَمْ نغَمْ اٛ وَنْغِنَنٜىٰ يِمْٻٜ اِسْرَاعِيلَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","سٜيْ يَحَيَ حٛکِّ شٜيْدَ وِعِ، ‏«‏مِ يِعِي رُوحُ اَللَّه اٜ جِڤّٛيٛو دَغَ دٛوْ بٛ فٛوندُ، طُمْ جٛوطِي دٛوْ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","مِنْ اٜ حٛورٜ اَمْ مِ اَنْدَامٛ، اَمَّا لِلٛيْطٛيَمْ مِ وَطِرَ بَڤْتِسْمَ اٜ ندِيَمْ وِعِيَمْ، ‏‹‏نٜطّٛ مٛ نغِيطَا رُوحُ اَمْ جِڤّٛيَکٜ دَغَ دٛوْ جٛوطِي دٛوْ مَاکٛ، کَنْکٛ وٛنِ غَطِرَيْطٛ بَڤْتِسْمَ اٜ رُوحُ اَمْ؞›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","طٛنْمَا يَحَيَ وِعِ، ‏«‏مِ يِعِيطُمْ، مِ شٜيْدَکٜ کَنْکٛ وٛنِ ٻِطّٛ اَللَّه؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","طٛنْمَا غَطَ طُعُمْ وَطِي ندٜ فِنِ يَحَيَ اٜ دَرِي کَنْکٛ اٜ تٛکُّٻٜمٛ طِطٛ، ");
INSERT INTO fuv_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","سٜيْ اٛ يِعِ يٜىٰسُ اٜ پَٻّٛو، اٛ وِعِ، ‏«‏رَا کَرٛورِ اَللَّه!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","ندٜ تٛکُّٻٜمٛ طِطٛ ٻٜنْ نَنِ اٛ وِعِي نٛنْ، سٜيْ ٻٜ تٛکِّ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","يٜىٰسُ وَيْلِتِي يِعِ اٜ ٻٜ تٛکِّمٛ، اٛ وِعِٻٜ، ‏«‏طُمٜ طَٻِّتٛتٛنْ؟»‏ ٻٜ مبِعِمٛ، ‏«‏رَبِّ، تٛيٜ نجٛوطٛتٛطَا؟»‏ مَعَنَ ‏«‏رَبِّ»‏ وٛنِ ‏«‏مٛودِبّٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","اٛ وِعِٻٜ، ‏«‏نغَرٜىٰ، نغِعٛنْ؞»‏ اٜ شَرٜلْ نغٜلْ طُمْ نجَمْندِ نَيِ اَلَاسَرَ؞ سٜيْ ٻٜ تٛکِّمٛ ٻٜ نغِعِ تٛ اٛ جٛوطٛتٛو، ٻٜ کِرْتِدِ اٜ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","غٛعٛتٛ ندٜرْ يِمْٻٜ طِطٛ نَنْٻٜ کٛ يَحَيَ وِعِ تٛکِّ يٜىٰسُ ٻٜنْ وٛنِ اَنْدِرَاوُسْ مِݧِرَاوٛ سِيمَنْ بِيتُرُسْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","اَرْتُطُمْ اَنْدِرَاوُسْ تَوِ مَوْنِرَاوٛ مَاکٛ سِيمَنْ، اٛ وِعِمٛ، ‏«‏مِنْ کَوْرِي اٜ اَلْمَسِيحُ،»‏ وَاتٛ شُٻَاطٛ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","سٜيْ اٛ يَارِ سِيمَنْ تٛ يٜىٰسُ؞ يٜىٰسُ رَارِ سِيمَنْ اٛنْ وِعِمٛ، ‏«‏اَنْ وٛنِ سِيمَنْ ٻِطّٛ يَحَيَ؞ طُمْ نٛدِّرْتٜ کٜىٰفَسْ؞»‏ مَعَنَ کٜىٰفَسْ وٛنِ بِيتُرُسْ، وَاتٛ ‏«‏حَيْرٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","غَطَ طُعُمْ وَطِي ندٜ فِنِ يٜىٰسُ سُٻِ يَحَ لٜيْدِ غَلِيلِ؞ سٜيْ اٛ تَوِ فِلِبُسْ، اٛ وِعِمٛ، ‏«‏تٛکَّمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","فِلِبُسْ بٛو اٛ نٜطّٛ غَرِيرِ بٜتَسَيْدَ؞ کَيْرِ وٛنِ غَرِيرِ اَنْدِرَاوُسْ اٜ بِيتُرُسْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","سٜيْ فِلِبُسْ يَحِ تَوِ نَتَانِيَلْ وِعِمٛ، ‏«‏مِنْ کَوْرِي اٜ اٛنْ طٛنْ نٜطّٛ مٛ مُوسَ وِنْدِ دٛوْ مُوطُمْ ندٜرْ اَتَّوْرَ، مٛ اَنَّبٛعٜنْ مَا مبِنْدِ دٛوْ مَاکٛ، وَاتٛ يٜىٰسُ ٻِطّٛ يُسُفُ پِوٛيْطٛ غَرِيرِ نَجَرَتْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","نَتَانِيَلْ وِعِ فِلِبُسْ، ‏«‏اٜ يِيکِ مَاطَ غٛطُّمْ بٛطُّمْ وُرْتٛيْتٛ نَجَرَتْ؟»‏ فِلِبُسْ وِعِمٛ، ‏«‏وٛرٛيْ، نغِعَا؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","ندٜ يٜىٰسُ يِعِ نَتَانِيَلْ اٜ وَرٛيَ تٛ مُوطُمْ، سٜيْ مٜتِ دٛوْ مَاکٛ، وِعِ، ‏«‏رَا اِسْرَاعِيلَنْکٜىٰجٛ مٛ غٛونغَ مٛ فٜوَتَا؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","نَتَانِيَلْ پَمِ يٜىٰسُ وِعِ، ‏«‏نٛ وَطِ اَنْدُطَايَمْ؟»‏ يٜىٰسُ وِعِمٛ، ‏«‏مِ يِعِيمَ لٜيْ لٜکِّ اِبِّ کٛ فِلِبُسْ نٛدُّمَا؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","نَتَانِيَلْ وِعِمٛ، ‏«‏مٛودِبّٛ، اَنْ وٛنِ ٻِطّٛ اَللَّه!‏ اَنْ وٛنِ لَامِيطٛ اِسْرَاعِيلَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","يٜىٰسُ وِعِمٛ، ‏«‏اَ حٛولِيَمْ نغَمْ مِ وِعِيمَ مِ يِعِيمَ لٜيْ لٜکِّ اِبِّ؟ اَ يِعَيْ فِي طُطُّمْ ٻُرْطُمْ طُعُمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","سٜيْ يٜىٰسُ ٻٜيْدِ وِيکِٻٜ، ‏«‏اٜ مِ وِعَعٛنْ غٛونغَ، اٛنْ نغِعَيْ دٛوْ مَٻِّتَکٜ، مَلَاعِکَعٜنْ اَللَّه اٜ پٜنْتَ اٜ نجِڤّٛيٛو يٜىٰسٛ ٻِي نٜطّٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","بَلْطٜ طِطِ غَطَ نٛنْ وَطِي طُمْ وَطِ حُمْتٛ تٜىٰغَلْ اٜ غَرِيرِ کَانَ نغٛنْدِ ندٜرْ لٜيْدِ غَلِيلِ؞ مَدُوجٛ يٜىٰسُ بٛو اٜ طٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","يٜىٰسُ اٜ تٛکُّٻٜمٛ مَا کُمْڤِتَامَ حُمْتٛ تٜىٰغَلْ نغَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","ندٜ ندِيَمْ اِنَبٛجَمْ طَمْ حٛٻّٜ نجَرَتَ تٛ حُمْتٛ تٜىٰغَلْ نغَلْ رٜعِ، مَدُوجٛ يٜىٰسُ وِعِمٛ، ‏«‏ندِيَمْ اِنَبٛجَمْ رٜعِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","يٜىٰسُ وِعِمٛ، ‏«‏نغَمْ طُمٜ نَتِّنْطَايَمْ ندٜرْ طُعُمْ؟ شَرٜلْ اَمْ وَطَايِ تَوْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","سٜيْ مَدُوجٛ يٜىٰسُ وِعِ مَشُّٻٜ کُوٛوٻٜ طٛنْ، ‏«‏نغَطٜىٰ کٛو طُمٜ کٛ اٛ وِعِعٛنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","حَادٜ طٛنْ اٜ وٛودِ لٛوطٜ جٛوٜىٰغٛعٛ طٜ کَاپٜ اِرِ لٛوطٜ طٜ يَحُودَنْکٛعٜنْ کُوتِرْتَ لٛوتٛو نغَمْ لَاٻِنْکِ کٛعٜ مَٻّٜ نٛ دِينَ مَٻّٜ وِعِ؞ کٛو ندٜيٜ لٛوندٜ اٜ حٛشَّ ڤَالِ ندِيَمْ 20 يَاکِ 30؞ ");
INSERT INTO fuv_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","سٜيْ يٜىٰسُ وِعِ مَشُّٻٜ ٻٜنْ، ‏«‏کٜبِّنٜىٰ طٜعٜ لٛوطٜ اٜ ندِيَمْ؞»‏ ٻٜ کٜبِّنِطٜ ندِيَمْ نَا کِ طٜ کٜىٰوِ تٜڤْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","سٜيْ اٛ وِعِٻٜ، ‏«‏جٛونِ ݧٜطٜىٰ ندِيَمْ طَمْ سٜطَّ نجَارَنٛنْ ڤَامَنٛووٛ تٜىٰغَلْ نغَلْ؞»‏ سٜيْ ٻٜ نجَارَنِمٛطَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","طَمْ يَادَکٜ طَمْ وَرْتِي اِنَبٛجَمْ، سٜيْ اٛ يَرِطَمْ؞ اٛ اَنْدَا تٛ طَمْ پِوٛيِ، اَمَّا مَشُّٻٜ ݧٜطُٻٜطَمْ اٜ اَنْدِ تٛ طَمْ پِوٛيِ؞ سٜيْ اٛ نٛدِّ اَنْغٛوجٛ اٛنْ، ");
INSERT INTO fuv_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","اٛ وِعِمٛ، ‏«‏کٛو مٛيٜ اٜ اَرْتَ حٛکُّکِ حٛٻّٜ اِنَبٛجَمْ ٻُرْطَمْ وٜلْکِ، غَطَ ٻٜ نجَرِي ٻٜ کَارِي، ندٜنْ اٛ حٛکَّٻٜ اِنَبٛجَمْ طَمْ حٜوْتَايِ اَرَنْدٜجَمْ طَمْ وٜلْکِ؞ اَمَّا اَنْ، اَ اَلِ اِنَبٛجَمْ ٻُرْطَمْ وٜلْکِ طَمْ نَا جٛونِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","کَنْجُمْ وٛنِ فِي کَيْطِنِيطُمْ اَرَنْدٜجُمْ طُمْ يٜىٰسُ وَطِ اٜ غَرِيرِ کَانَ نغٛنْدِ لٜيْدِ غَلِيلِ؞ نٛنْ اٛ حٛلِّرِ تٜدُّنغَلْ مَاکٛ، ندٜنْ تٛکُّٻٜمٛ کٛولِيمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","غَطَ طُعُمْ، يٜىٰسُ يَحِ کَفَرْنَحُمْ، کَنْکٛ اٜ مَدُوجٛ مَاکٛ، اٜ مِݧِرَاٻٜ مَاکٛ، اٜ تٛکُّٻٜمٛ، ٻٜ نجٛوطِي تٛنْ بَلْطٜ سٜطَّ؞ ");
INSERT INTO fuv_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","ندٜ شَرٜلْ ٻَدِي نغٜلْ حُمْتٛ سَکِّنْکِ نغٛ يَحُودَنْکٛعٜنْ، يٜىٰسُ يَحِ اُرُشَلِيمَ؞ ");
INSERT INTO fuv_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","تٛنْ اٜ اُرُشَلِيمَ ندٜرْ وُرٛ شٜنِينغٛ اٛ تَوِ يِمْٻٜ اٜ شٛورَ نَعِ، اٜ بَالِ، اٜ تَتَّبَرَاجِ؞ ندٜنْ اٜ وٛودِ وٛٻّٜ غَيْلِتٛوٻٜ شٜىٰدٜ رٛومَنْکٛعٜنْ يَاکِ شٜىٰدٜ يَحُودَنْکٛعٜنْ، اٜ ٻٜ نجٛوطِي حَادٜ تٜىٰبُرْجِ مَٻّٜ اٜ ٻٜ نغَيْلِتَ شٜىٰدٜ؞ ");
INSERT INTO fuv_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","سٜيْ اٛ وَالِ ٻٛغِّ اٛ وَرْتِرِطِ لٛوسٛلْ، اٛ رِيوِ فُو ٻٜ سٛورٜ‑سٛورٜ دَغَ ندٜرْ وُرٛ شٜنِينغٛ نغٛنْ حَوْتِ اٜ بَالِ مَٻّٜ اٜ نَعِ مَٻّٜ؞ کَدِنْ اٛ سَنْکِتِ شٜىٰدٜ غَيْلِتٛوٻٜ شٜىٰدٜ ٻٜنْ، اٛ دٛعِّ تٜىٰبُرْجِ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","سٜيْ اٛ وِعِ شٛورٛوٻٜ تَتَّبَرَاجِ ٻٜنْ، ‏«‏مبُرْتِنٜىٰطِ طٛعٛ!‏ تٛع اٛنْ نغَرْتِرْ وُرٛ ݧَاکٛ اَمْ لُومٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","تٛکُّٻٜمٛ شِفْتٛرِ کٛ وِنْدَا، ‏«‏يَا اَللَّه، يِدّٜ ندٜ نغِطُمِ وُرٛ مَاطَ اٜ وُلَ ندٜرْ اَمْ بٛ حِيتٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","سٜيْ اَرْدِيٻٜ يَحُودَنْکٛعٜنْ پَمِ يٜىٰسُ ٻٜ مبِعِ، ‏«‏طُمٜ کَيْطِنِيطُمْ نغَطَنْتَامِنْ نغَمْ حٛلُّکِ اَ وٛودِ لَامُ وَطُکِ فِي طُعُمْ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","يٜىٰسُ وِعِٻٜ، ‏«‏ڤُسٜىٰ وُرٛ شٜنِينغٛ نغٛعٛ، ندٜنْ ندٜرْ بَلْطٜ تَتِ مِ مَحِتَيْنغٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","ٻٜ مبِعِمٛ، ‏«‏طُمْ وَطِي دُوٻِ 64 کٛ طُمْ يٛتِّنَ ݧِٻُکِ وُرٛ شٜنِينغٛ نغٛعٛ، اَنْ، اَ وِعِي اَ مَحِتَيْنغٛ ندٜرْ بَلْطٜ تَتِ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","اَمَّا وُرٛ شٜنِينغٛ نغٛ يٜىٰسُ مٜتَتَ دٛوْ مَغّٛ وٛنِ ٻَنْدُ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","غَطَ اٛ اُمِّنَامَ دَغَ مَيْدٜ، سٜيْ تٛکُّٻٜمٛ شِفْتٛرِ کَعَ حَالَ کَ اٛ وِعُنٛ، ندٜنْ ٻٜ نجَٻِ کٛ اَايَاجٜ مبِعِ اٜ کٛ يٜىٰسُ وِعِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","شَرٜلْ نغٜلْ يٜىٰسُ وٛنِ اُرُشَلِيمَ نغَمْ حُمْتٛ سَکِّنْکِ، يِمْٻٜ طُطْٻٜ کٛولِيمٛ نغَمْ ٻٜ نغِعِي کُوطٜ کَيْطِنِيطٜ طٜ اٛ وَطِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","اَمَّا يٜىٰسُ وٜدِّتَنَاکِٻٜ، نغَمْ اٜ مٛ اَنْدِ نغِکُّ نٜطّٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","نَاع نَا غٛطّٛ حٛکِّيمٛ شٜيْدَ دٛوْ يِمْٻٜ، نغَمْ کَنْکٛ اٜ حٛورٜ مَاکٛ اٜ مٛ اَنْدِ کٛ وٛنِ ندٜرْ ٻٜرْندٜ کٛو مٛيٜ؞ ");
INSERT INTO fuv_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","اٜ وٛودِ غٛطّٛ فَارِسَنْکٜىٰجٛ بِعٜتٜىٰطٛ نِکٛودِمُسْ، اٜ مٛ ندٜرْ کَوْتَلْ اَرْدِيٻٜ يَحُودَنْکٛعٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","اٛ يَحِ تٛ يٜىٰسُ جٜمَّ، اٛ وِعِمٛ، ‏«‏مٛودِبّٛ، اٜ مِنْ اَنْدِ اَ مٛودِبّٛ مٛ اَللَّه لِلٛيِ، نغَمْ وَلَا بَاوَيْطٛ وَطَ کُوطٜ کَيْطِنِيطٜ طٜعٜ طٜ نغَطَتَا سٜيْ نِ تٛ اَللَّه اٜ وٛنْدِ اٜ مَاکٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","يٜىٰسُ وِعِمٛ، ‏«‏اٜ مِ وِعُمَا غٛونغَ، وَلَا بَاوَيْطٛ نَتَّ لَامُ اَللَّه سٜيْ تٛ طُمْ فُطِّتِي طُمْ دَݧِيمٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","نِکٛودِمُسْ پَمِمٛ وِعِ، ‏«‏نٛ نٜطّٛ مَوْطٛ دَݧِتِرْتٜىٰ؟ طُمْ وَطَتَاکٛ اٛ سٛعّٛ ندٜرْ رٜىٰدُ مَدُوجٛ مَاکٛ طُمْ فُطِّتَ طُمْ دَݧَمٛ طِطَٻُمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","يٜىٰسُ وِعِمٛ، ‏«‏اٜ مِ وِعُمَا غٛونغَ، وَلَا بَاوَيْطٛ نَتَّ لَامُ اَللَّه سٜيْ نِ تٛ ندِيَمْ اٜ رُوحُ اَللَّه دَݧِيمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","کٛ نٜطّٛ دَݧِ طُمْ نٜطّٛ، اَمَّا کٛ رُوحُ دَݧِ طُمْ رُوحُ؞ ");
INSERT INTO fuv_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","تَاع حَيْطِنْ نغَمْ مِ وِعِيمَ دٛولٜ طُمْ فُطِّتَ طُمْ دَݧُمَا؞ ");
INSERT INTO fuv_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","حٜنْدُ اٜ وِسَ تٛ يِطِرِ، اَ نَنَ سٛنْݧٛ مَيْرُ، اَمَّا اَ اَنْدَا تٛ ندُ پِوٛيِ کٛو تٛ ندُ يَحَتَ؞ نٛنْ مَا طُمْ وٛنْتِندِرِ اٜ کٛو مٛيٜ مٛ رُوحُ اَللَّه دَݧِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","نِکٛودِمُسْ پَمِمٛ وِعِ، ‏«‏نٛ طُعُمْ وَطٛرْتٛو؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","يٜىٰسُ نٛوتِي وِعِمٛ، ‏«‏اَ مٛودِبّٛ مَوْطٛ ندٜرْ اِسْرَاعِيلَ، اَمَّا اَ فَامَايِ طُعُمْ؟ ");
INSERT INTO fuv_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","اٜ مِ وِعُمَا غٛونغَ، اٜ مِنْ مٜتَ دٛوْ کٛ مِنْ اَنْدِ، ندٜنْ اٜ مِنْ کٛکَّ شٜيْدَ دٛوْ کٛ مِنْ نغِعِ، اَمَّا اٛنْ نجَٻَايِ کٛ مِنْ مبِعِعٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","مِ مٜتَنِيعٛنْ دٛوْ فِي دُونِيَارُ، اَمَّا اٛنْ نجَٻَايِ؞ نٛ وَطَتَ نجَٻٛنْ تٛ مِ وِعِيعٛنْ کٛ وٛنِ اٜ دٛوْ؟ ");
INSERT INTO fuv_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","وَلَا مٜىٰطُطٛ يَاکِ دٛوْ سٜيْ نِ اٛنْ طٛنْ پِوٛيْطٛ دَغَ دٛوْ، وَاتٛ ٻِي نٜطّٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","‏«‏نٛنْ نٛ مُوسَ پٜفْتِرِ مبٛودِ غَطِرَاندِ نجَمْندِ مبٛطٜىٰرِ ندٜرْ لَدّٜ، نٛنْ مَا دٛولٜ ٻِي نٜطّٛ پٜفْتٜىٰ، ");
INSERT INTO fuv_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","نغَمْ کٛو مٛيٜ کٛولِيطٛمٛ حٜٻَ يٛنْکِ کِ رٜعَتَا؞ ");
INSERT INTO fuv_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","نغَمْ يِدّٜ ندٜ اَللَّه يِطِ دُونِيَارُ حَا اٛ حٛکِّي ٻِطّٛ مَاکٛ بَجّٛ، نغَمْ کٛو مٛيٜ کٛولِيطٛمٛ تٛع حَلْکَ اَمَّا حٜٻَ يٛنْکِ کِ رٜعَتَا؞ ");
INSERT INTO fuv_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","نغَمْ اَللَّه لِلٛيَايِ ٻِطّٛ مُوطُمْ ندٜرْ دُونِيَارُ نغَمْ اٛ تَپَنَنْدُ کِيتَ؞ اَمَّا اٛ لِلٛيِيمٛ نغَمْ اٛ حِسْنَ دُونِيَارُ اٜ لَاوٛلْ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","‏«‏کٛو مٛيٜ کٛولِيطٛمٛ تَپَنْتَاکٜ کِيتَ، اَمَّا مٛ حٛولَاکِمٛ اٛ يَادَکٜ اٛ تَپَنَامَ کِيتَ، نغَمْ اٛ حٛولَاکِ ٻِطّٛ اَللَّه بَجّٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","رَا کٛ وَطِ اَللَّه تَپَنْتَ يِمْٻٜ کِيتَ:‏ جَيْنغٛلْ وَرِي ندٜرْ دُونِيَارُ، اَمَّا ٻٜ ٻُرِي يِطُکِ ݧِوْرٜ دٛوْ جَيْنغٛلْ، نغَمْ کُوطٜ مَٻّٜ طٜ کَلُّطٜ؞ ");
INSERT INTO fuv_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","کٛو مٛيٜ غَطٛووٛ کٛ حَلِّ وَݧِي جَيْنغٛلْ، ندٜنْ اٛ نَتَّتَا تٛ جَيْنغٛلْ وٛنِ، نغَمْ اٜ مٛ حُلَ تٛع کُوطٜ مَاکٛ کَلُّطٜ مبُرْتِنٜىٰ اٜ نجَيْرِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","اَمَّا کٛو مٛيٜ غَطٛووٛ غٛونغَ اٜ نَتَّ جَيْنغٛلْ، نغَمْ طُمْ يِعَ اٜ نجَيْرِ اٜ مٛ وَطَ کٛ اَللَّه يِطِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","غَطَ طُعُمْ، يٜىٰسُ اٜ تٛکُّٻٜمٛ نجَحِ لَدّٜ لٜيْدِ يَحُودِيَ؞ تٛنْ اٛ جٛوطِي اٛ نٜىٰٻِدِ اٜ تٛکُّٻٜمٛ اٜ مٛ وَطَنَ يِمْٻٜ بَڤْتِسْمَ؞ ");
INSERT INTO fuv_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","يَحَيَ مَا اٜ وَطَنَ يِمْٻٜ بَڤْتِسْمَ اٜ اَيْنٛنْ حَادٜ سَلِمْ، نغَمْ اٜ وٛودِ ندِيَمْ طُطَّمْ تٛنْ؞ يِمْٻٜ نغَطِ کَ يَاکِ تٛ مَاکٛ اٜ مٛ وَطَنَٻٜ بَڤْتِسْمَ؞ ");
INSERT INTO fuv_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","طُعُمْ طُمْ وَطُ کٛ يَحَيَ سُرٜىٰ ندٜرْ سُودُ شُرَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","سٜيْ غٜدِّ اُمِّي حَکُّندٜ تٛکُّٻٜ يَحَيَ اٜ غٛطّٛ يَحُودَنْکٜىٰجٛ دٛوْ لٛوتَاکِ کِ نٜطّٛ وَطَتَ نٛ دِينَ يَحُودَنْکٛعٜنْ وِعِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","تٛکُّٻٜ يَحَيَ نجَحِ تٛ مَاکٛ ٻٜ مبِعِمٛ، ‏«‏مٛودِبّٛ، اٛنْ طٛنْ نٜطّٛ غٛنْدُنٛوطٛ اٜ مَاطَ اٜ فٛنْغٛ شَانغٛلْ اُرْدُنْ، مٛ کٛکُّطَا شٜيْدَ دٛوْ مَاکٛ، تٛو، اٜ مٛ تٛنْ وَطَنَ يِمْٻٜ بَڤْتِسْمَ، کٛو مٛيٜ اٜ يَحَ تٛ مَاکٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","يَحَيَ وِعِٻٜ، ‏«‏وَلَا کٜٻٛووٛ غٛطُّمْ سٜيْ نِ تٛ اَللَّه حٛکِّيمٛطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","اٛنٛنْ اٜ کٛعٜ مٛوطٛنْ اٛنْ شٜيْدُعٜنْ مِ وِعِي، ‏‹‏نَاع مِنْ وٛنِ اَلْمَسِيحُ، اَمَّا مِ لِلٛيَ مِ اَرْتَمٛ وَرْکِ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","اَنْغٛوجٛ جٜيِ ٻَݝَاطٛ؞ حِغٛ اَنْغٛوجٛ اٛنْ دَرِيطٛ اٜ نَنَ کٛ اٛ وِعَتَ، اٛ نَنَيْ بٜلْطُمْ نَاع سٜطَّ تٛ اٛ نَنِي حٛنٛنْدٜ اَنْغٛوجٛ اٛنْ؞ اِرِ بٜلْطُمْ طُمْ حِغٛ اَنْغٛوجٛ اٛنْ نَنِ، اِرِ مَاجُمْ نَنَيْمِ نَاع سٜطَّ جٛونِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","دٛولٜ مَنْغُ يٜىٰسُ وَطَ کَ ٻٜيْدَاکِ، مِنْ بٛو مَنْغُ اَمْ وَطَ کَ اُسْتَاکِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","‏«‏اٛنْ طٛنْ پِوٛيْطٛ دَغَ دٛوْ اٛ ٻُرِي کٛو مٛيٜ مَنْغُ؞ اٛنْ طٛنْ پِوٛيْطٛ دُونِيَارُ، دُونِيَارُ جٜيِمٛ، ندٜنْ اٜ مٛ مٜتَ دٛوْ فِي دُونِيَارُ؞ پِوٛيْطٛ دَغَ دٛوْ اٛنْ اٛ ٻُرِي کٛو مٛيٜ؞ ");
INSERT INTO fuv_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","اٛ مٜتِي دٛوْ کٛ اٛ يِعِ اٜ کٛ اٛ نَنِ، اَمَّا وَلَا جَٻُطٛ کٛ اٛ وِعِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","کٛو مٛيٜ جَٻُطٛ کٛ اٛ وِعِ تَبِّتِنِي جَٻِي کٛ اَللَّه وِعِ طُمْ غٛونغَ؞ ");
INSERT INTO fuv_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","اٛنْ طٛنْ مٛ اَللَّه لِلِ، اٜ مٛ مٜتَ کٛ اَللَّه وِعِ، نغَمْ اَللَّه حٛکِّيمٛ رُوحُ مُوطُمْ کٜىٰرٛلْ وَلَا؞ ");
INSERT INTO fuv_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","ݧَاکٛ مٛ دٛوْ اٜ يِطِ ٻِطّٛ مُوطُمْ، اٛ وَطِي کٛو طُمٜ ندٜرْ جُوطٜ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","کٛو مٛيٜ کٛولِيطٛ ٻِطّٛ اٛنْ اٜ وٛودِ يٛنْکِ کِ رٜعَتَا؞ اَمَّا کٛو مٛيٜ مٛ تٛکَّايِ کٛ ٻِطّٛ اٛنْ وِعِ، اٛ حٜٻَتَا يٛنْکِ کِ رٜعَتَا، اَمَّا مٛنّٜرٜ اَللَّه اٜ دٛوْ مَاکٛ حَا اَبَدَا؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","فَارِسَنْکٛعٜنْ نَنِ حَبَرُ يٜىٰسُ اٜ حٜٻَ تٛکُّٻٜمٛ ٻُرِي يَحَيَ، طٛنْمَا اٜ مٛ وَطَنَ يِمْٻٜ بَڤْتِسْمَ ٻُرِي يَحَيَ، ");
INSERT INTO fuv_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","﴿کٛو ندٜ غٛونغَ نَاع طُمْ يٜىٰسُ اٜ حٛورٜ مُوطُمْ وَطَنْتَ يِمْٻٜ بَڤْتِسْمَ طُمْ، اَمَّا تٛکُّٻٜمٛ نغَطَتَطُمْ؞﴾ ");
INSERT INTO fuv_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","ندٜ يٜىٰسُ نَنِ فَارِسَنْکٛعٜنْ نَنِي حَبَرُ کٛ اٛ وَطَتَ، سٜيْ اٛ اَلِ لٜيْدِ يَحُودِيَ، اٛ سٛعِّي غَلِيلِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","دٛوْ لَاوٛلْ مَاکٛ طُمْ وَرْتَنِمٛ دٛولٜ اٛ تٛکَّ ندٜرْ لٜيْدِ سَمَارِيَ؞ ");
INSERT INTO fuv_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","سٜيْ اٛ يٛتِّي وٛنْدِ غَرِيرِ نغٛنْدِ ندٜرْ لٜيْدِ سَمَارِيَ بِعٜتٜىٰندِ سَيْکَرْ نغٛنْدِ حَادٜ نجَيْرِ ندِ يَاکُبُ حٛکِّ ٻِطّٛ مُوطُمْ اِسُفُ دَغَ ندٜنّٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","اٜ وٛودِ ٻُنْدُ ندُ يَاکُبُ وَسِ اٜ نجَيْرِ ندِنْ؞ يٜىٰسُ بٛو سٛمِي نغَمْ يَادُ اٛ جٛوطِي حَادٜ ٻُنْدُ ندُنْ؞ اٜ شَرٜلْ نغٜلْ طُمْ شَکَ ݧَلَوْمَ؞ ");
INSERT INTO fuv_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","سٜيْ غٛطّٛ سَمَارِيَنْکٜىٰجٛ دٜبّٛ وَرِي پٛوغُکِ، يٜىٰسُ وِعِمٛ، ‏«‏حٛکّٛرَمْ ندِيَمْ مِ يَرَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","اٜ شَرٜلْ نغٜلْ تٛکُّٻٜمٛ نجَادَکٜ نَتِّي ندٜرْ غَرِياِرِ ندِنْ نغَمْ سٛودٛيْکِ ݧَمْندُ؞ ");
INSERT INTO fuv_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","سٜيْ دٜبّٛ اٛنْ وِعِ يٜىٰسُ، ‏«‏اَ يَحُودَنْکٜىٰجٛ، مِنْ بٛو مِ سَمَارِيَنْکٜىٰجٛ؞ نٛيٜ مبِعَتَايَمْ مِ حٛکُّمَا ندِيَمْ نجَرَا؟»‏ اٛ وِعُ نٛنْ نغَمْ وَلَا کٛ حَوْتِ يَحُودَنْکٛعٜنْ اٜ سَمَارِيَنْکٛعٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","يٜىٰسُ وِعِمٛ، ‏«‏دَا اَ اَنْدِ شَاحُ طُمْ اَللَّه يِطِ حٛکُّکِمَ، کَدِنْ دَا اَ اَنْدِ پَمُطٛمَ ندِيَمْ نجَرٜتٜىٰطَمْ، دَا اَ تٛرَکٜمٛ، دَا اٛ حٛکِّيمَ ندِيَمْ کٛکّٛوجَمْ يٛنْکِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","سٜيْ دٜبّٛ اٛنْ وِعِ يٜىٰسُ، ‏«‏مٛودِبّٛ، اَ وَلَا کٛ ݧٜطِرْتَا ندِيَمْ طَمْ، کَدِنْ بٛو ٻُنْدُ ندُنْ اٜ لُغِّ؞ تٛيٜ کٜٻَتَا طَمْ طٛنْ ندِيَمْ کٛکّٛوجَمْ يٛنْکِ؟ ");
INSERT INTO fuv_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","اَ ٻُرِي مَامَ مٜىٰطٜنْ يَاکُبُ کٛکُّطٛعٜنْ ندُعُ ٻُنْدُ؟ کَنْکٛ اٜ ٻِٻّٜ مَاکٛ اٜ مَرْلٜ مَاکٛ فُو ٻٜ نجَرِي ندِيَمْ ٻُنْدُ ندُعُ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","يٜىٰسُ وِعِمٛ، ‏«‏کٛو مٛيٜ جَرْطٛ ندِيَمْ ٻُنْدُ ندُعُ فُطِّتَيْ نَنَ طٛنْکَ، ");
INSERT INTO fuv_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","اَمَّا کٛو مٛيٜ جَرْطٛ ندِيَمْ طَمْ کٛکَّيْمٛومِ اٛ فُطِّتَتَا اٛ نَنَ طٛنْکَ کَدِنْ؞ ندِيَمْ طَمْ کٛکَّيْمٛومِ طَمْ وَرْتَيْ ندٜرْ مَاکٛ ندِيَمْ ٻُلٛوجَمْ کٛکَّيْطَمّٛ يٛنْکِ کِ رٜعَتَا؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","دٜبّٛ اٛنْ وِعِمٛ، ‏«‏مٛودِبّٛ، حٛکَّمْ طَمْ طٛنْ ندِيَمْ نغَمْ تٛع مِ فُطِّتَ مِ نَنَ طٛنْکَ، طٛنْمَا تٛع مِ فُطِّتَ مِ وَرَ طٛعٛ نغَمْ پٛوغُکِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","يٜىٰسُ وِعِمٛ، ‏«‏يَحُ نٛدّٛيَا غٛرْکٛ مَاطَ، نغَرْدٛيٛنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","دٜبّٛ اٛنْ وِعِ، ‏«‏مِ وَلَا غٛرْکٛ؞»‏ يٜىٰسُ وِعِمٛ، ‏«‏اَ وِعِي غٛونغَ ندٜ مبِيطَا اَ وَلَا غٛرْکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","غٛونغَ کَنْ وٛنِ اَ وَطِي تٜىٰلٜ جٛوِ، نٜطّٛ مٛ نجٛوطٛدِطَا جٛونِ بٛو نَاع اٛ غٛرْکٛ مَاطَ؞ کٛ مبِيطَا طُمْ غٛونغَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","دٜبّٛ اٛنْ وِعِ، ‏«‏مٛودِبّٛ، مِ فَامِي اَ اَنَّبِيجٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","مَامَعٜنْ اَمِنْ مَوْنِنِي اَللَّه دٛوْ حٛشّٜىٰرٜ ندٜعٜ، اَمَّا اٛنٛنْ يَحُودَنْکٛعٜنْ اٛنْ مبِعَ اُرُشَلِيمَ وٛنِ تٛ حَانِ طُمْ مَوْنِنَ اَللَّه؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","يٜىٰسُ وِعِمٛ، ‏«‏جَٻُ کٛ مبِعَيْمِ، شَرٜلْ اٜ وَرَ نغٜلْ مَوْنِنْتٛنْ ݧَاکٛ مٛ دٛوْ نَاع دٛوْ حٛشّٜىٰرٜ ندٜعٜ نَاع ندٜرْ اُرُشَلِيمَ؞ ");
INSERT INTO fuv_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","اٛنٛنْ سَمَارِيَنْکٛعٜنْ اٛنْ مَوْنِنَ کٛ اٛنْ اَنْدَا، اَمَّا مِنٛنْ يَحُودَنْکٛعٜنْ اٜ مِنْ مَوْنِنَ کٛ مِنْ اَنْدِ، نغَمْ دَغَ تٛ يَحُودَنْکٛعٜنْ کِسْندَمْ پِوٛيِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","اَمَّا شَرٜلْ اٜ وَرَ، نغٜلْ يَادَکٜ نغٜلْ وَرِي، شَرٜلْ نغٜلْ يِمْٻٜ مَوْنِنٛوٻٜ اَللَّه نٛ حَانِ ٻٜ مَوْنِنَيْ ݧَاکٛ مٛ دٛوْ ندٜرْ غٛونغَ اٜ ندٜرْ بَوْطٜ رُوحُ اَللَّه، نغَمْ اِرِ مَٻّٜ ݧَاکٛ مٛ دٛوْ يِطِ ٻٜ مَوْنِنَمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","اَللَّه اٛ رُوحُ، مَوْنِنٛوٻٜمٛ بٛو دٛولٜ مَوْنِنَمٛ ندٜرْ رُوحُ اٜ غٛونغَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","دٜبّٛ اٛنْ وِعِ يٜىٰسُ، ‏«‏اٜ مِ اَنْدِ اَلْمَسِيحُ اٜ وَرَ، وَاتٛ شُٻَاطٛ اَللَّه؞ تٛ اٛ وَرِي، اٛ وِعَيْمِنْ کٛو طُمٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","سٜيْ يٜىٰسُ وِعِمٛ، ‏«‏مِنْ مٜدّٛووٛ اٜ مَاطَ، مِنْ وٛنِ اَلْمَسِيحُ اٛنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","اٜ نغٜلْ طٛنْ شَرٜلْ تٛکُّٻٜ يٜىٰسُ نغَرْتٛيِ، ٻٜ کَيْطِنِ ندٜ ٻٜ تَوِ اٜ مٛ مٜدَّ اٜ دٜبّٛ؞ اَمَّا وَلَا غٛطّٛ ندٜرْ مَٻّٜ بِيطٛمٛ، ‏«‏کٛ نغِطَّا؟»‏ کٛو، ‏«‏نغَمْ طُمٜ مٜدَّتَا اٜ مَاکٛ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","سٜيْ دٜبّٛ اٛنْ اَلِ پٛوغِرْدٜ مُوطُمْ، سٛعِّي غَرِيرِ وِعِ يِمْٻٜ، ");
INSERT INTO fuv_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","‏«‏نغَرٜىٰ، نغِعٛنْ نٜطّٛ بِيطٛيَمْ کٛو طُمٜ کٛ مٜىٰطُمِ وَطُکِ؞ کٛو کَنْکٛ وٛنِ اَلْمَسِيحُ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","سٜيْ يِمْٻٜ ٻٜنْ اَلِ غَرِيرِ ندِنْ ٻٜ نجَحِ تٛ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","اٜ طُمْ ندٜرْ نٛنْ سٜيْ تٛکُّٻٜمٛ تٛرِيمٛ مبِعِمٛ، ‏«‏مٛودِبّٛ، ݧَامُ غٛطُّمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","اَمَّا اٛ وِعِٻٜ، ‏«‏اٜ مِ وٛودِ ݧَمْندُ ندُ ݧَامَيْمِ، اٛنْ اَنْدَا کٛو طُمٜ دٛوْ مَيْرُ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","سٜيْ تٛکُّٻٜمٛ ڤُطِّ پَمْپَمْتِرْکِ اٜ مبِعَ، ‏«‏کٛو غٛطّٛ وَدَّنِيمٛ ݧَمْندُ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","يٜىٰسُ وِعِٻٜ، ‏«‏ݧَمْندُ اَمْ وٛنِ مِ وَطَ کٛ لِلْطٛيَمْ وِعِيَمْ، مِ يٛتِّنَ کُوغَلْ نغَلْ اٛ حٛکِّيَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","نَاع اٛنْ مبِعَ، ‏‹‏حٛرِي لٜبِّ نَيِ طُمْ اِتَّ کٛ رٜمَا؟›‏ اٜ مِ وِعَعٛنْ، ندَارٜىٰ غٜسٜ بٛطُّمْ؞ کٛ رٜمَا ٻٜنْدِي طُمْ حٜوْتِي اِتّٜىٰکِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","اِتّٛووٛ کٛ رٜمَا اٜ يٛٻٜىٰ، کٛ رٜمَا طُمْ اٛ حَوْرِتَتَ وٛنِ يِمْٻٜ کٜٻٛوٻٜ يٛنْکِ کِ رٜعَتَا، نغَمْ اَاوُطٛ اٜ اِتُّطٛ کٛ ٻٜنْدِ ٻٜ کَوْتَ ٻٜ مبٜلْمبٜلْتَ؞ ");
INSERT INTO fuv_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","کَعَ حَالَ طُمْ غٛونغَ بِيکَ، ‏‹‏غٛطّٛ اَاوِي، غٛطّٛ بٛو اِتِّي کٛ ٻٜنْدِ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","مِ لِلِيعٛنْ اِتّٛنْ کٛ ٻٜنْدِ طُمْ اٛنْ کُوَنَايِ؞ وٛٻّٜ کُوِي نَاع سٜطَّ، اٛنٛنْ بٛو اٛنْ ݧَامِي بٛتٜ کُوغَلْ مَٻّٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","سَمَارِيَنْکٛعٜنْ طُطْٻٜ اٜ ندِنْ طٛنْ غَرِيرِ کٛولِي يٜىٰسُ نغَمْ اٛنْ طٛنْ دٜبّٛ وِعِي، ‏«‏اٛ وِعِييَمْ کٛو طُمٜ طُمْ مٜىٰطُمِ وَطُکِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","نغَمْ نٛنْ، ندٜ سَمَارِيَنْکٛعٜنْ ٻٜنْ نغَرِ تٛ يٜىٰسُ، ٻٜ تٛرِيمٛ اٛ جٛوطٛدٛو اٜ مَٻّٜ؞ سٜيْ اٛ جٛوطٛدِي اٜ مَٻّٜ بَلْطٜ طِطِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","يِمْٻٜ کٛولِيٻٜ يٜىٰسُ ٻٜيْدِي نَاع سٜطَّ نغَمْ بٛلِيطٜ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","ٻٜ مبِعِ دٜبّٛ اٛنْ، ‏«‏جٛونِ مِنْ کٛولَکٜ يٜىٰسُ، نَاع نغَمْ کٛ مبِيطَا تَنْ، اَمَّا نغَمْ مِنٛنْ اٜ کٛعٜ اَمِنْ مِنْ نَنِي کٛ اٛ وِعِ، مِنْ تَبِّتِنِي کَنْکٛ وٛنِ کِسْنٛووٛ دُونِيَارُ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","غَطَ يٜىٰسُ وَطِي بَلْطٜ طِطِ طٛنْ، اٛ دِلِّ غَلِيلِ، ");
INSERT INTO fuv_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","نغَمْ کَنْکٛ اٜ حٛورٜ مَاکٛ اٛ وِعِ، ‏«‏اَنَّبِيجٛ مَوْنِنْتَاکٜ تٛ لٜيْدِ مُوطُمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","ندٜ اٛ يٛتِّي غَلِيلِ، غَلِلَنْکٛعٜنْ نجَٻِّيمٛ، نغَمْ کَمْٻٜ مَا ٻٜ نجَحِينٛ حُمْتٛ سَکِّنْکِ ندٜرْ اُرُشَلِيمَ، ٻٜ نغِعِي فُو کٛ اٛ وَطِ تٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","سٜيْ يٜىٰسُ فُطِّتِ سٛعِّي غَرِيرِ کَانَ نغٛنْدِ ندٜرْ لٜيْدِ غَلِيلِ؞ کَيْرِ وٛنِ تٛ اٛ وَيْلِتِ ندِيَمْ طَمْ وَرْتِ اِنَبٛجَمْ؞ تٛو، ندٜرْ غَرِيرِ کَفَرْنَحُمْ اٜ وٛودِ غٛطّٛ مَوْطٛ ندٜرْ غٛمْنَتِ، ٻِطّٛ مَاکٛ اٜ ݧَوَ؞ ");
INSERT INTO fuv_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","ندٜ نٜطّٛ اٛنْ نَنِ يٜىٰسُ اَلِي لٜيْدِ يَحُودِيَ وَرِي لٜيْدِ غَلِيلِ، اٛ يَحِ تٛ يٜىٰسُ اٛ تٛرِيمٛ اٛ يَحَ کَفَرْنَحُمْ اٛ يَمْطِتِنَ ٻِطّٛ مَاکٛ ٻَدِيطٛ مَايَ؞ ");
INSERT INTO fuv_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","يٜىٰسُ وِعِمٛ، ‏«‏اٛنٛنْ يِمْٻٜ تٛ نَاع اٛنْ نغِعُ مِ وَطِي اَلَامَاجِ اٜ کُوطٜ کَيْطِنِيطٜ، اٛنْ کٛولَتَاکٛيَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","اٛ وِعِ يٜىٰسُ، ‏«‏مٛودِبّٛ، اٜنْ نجَحُ کٛ ٻِطّٛ اَمْ مَايَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","سٜيْ يٜىٰسُ وِعِمٛ، ‏«‏يَحُ، ٻِطّٛ مَاطَ مَايَتَا؞»‏ نٜطّٛ اٛنْ جَٻِ کٛ يٜىٰسُ وِعِمٛ، اٛ دِلِّ؞ ");
INSERT INTO fuv_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","اٜ مٛ دٛوْ لَاوٛلْ سٛعَّاکِ وُرٛ، سٜيْ مَشُّٻٜ مَاکٛ کَوْرِ اٜ مَاکٛ ٻٜ مبِعِمٛ، ‏«‏ٻِطّٛ مَاطَ يَمْطِتِي؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","ندٜ اٛ پَمِٻٜ نغٜلٜ شَرٜلْ ٻِطّٛ اٛنْ يَمْطِتِ، ٻٜ مبِعِمٛ، ‏«‏کٜىٰݧَ نجَمْندِ غٛعٛ ندِ ݧَلَوْمَ جٛنْتٜ طٜنْ نجٛوفِمٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","سٜيْ اٛ فَامِ شَرٜلْ نغٜلْ ٻِطّٛ اٛنْ يَمْطِتِ طُمْ شَرٜلْ نغٜلْ يٜىٰسُ وِعُنٛومٛ، ‏«‏ٻِطّٛ مَاطَ مَايَتَا؞»‏ نغَمْ نٛنْ، کَنْکٛ اٜ فُو وُرٛ مَاکٛ ٻٜ کٛولِي يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","طُعُمْ کَنْجُمْ وٛنِ کَيْطِنِيطُمْ طِطَٻُمْ طُمْ يٜىٰسُ وَطِ تٛ غَلِيلِ؞ اٛ وَطِيطُمْ غَطَ اٛ وَرْتٛيِي دَغَ لٜيْدِ يَحُودِيَ؞ ");
INSERT INTO fuv_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","غَطَ طُعُمْ يٜىٰسُ يَحِ اُرُشَلِيمَ نغَمْ وٛنْغٛ حُمْتٛ دِينَ يَحُودَنْکٛعٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","تٛنْ اُرُشَلِيمَ اٜ وٛودِ نجٛنْغَ ندِيَمْ حَادٜ وٛنْغَلْ دَمُّغَلْ غَرِيرِ ندِنْ بِعٜتٜىٰنغَلْ دَمُّغَلْ بَالِ؞ حَادٜ نجٛنْغَ نغَنْ اٜ وٛودِ رُمڤَاجِ جٛوِ؞ ندٜرْ اِبْرَانِيَنْکٛورٜ اٜ نغَ نٛدِّرٜىٰ بٜتَسْدَ؞ ");
INSERT INTO fuv_vpl VALUES ("JN5_3‏","073_5_3‏","JHN","5","3‏","4","ݧَوْٻٜ طُطْٻٜ اٜ ڤُکّٛو حَادٜ نجٛنْغَ نغَنْ؞ اٜ وٛودِ وُمْٻٜ، اٜ يِمْٻٜ ٻٜ کٛيْطٜ ݧَوْطٜ، اٜ جَرَاٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","اٜ وٛودِ غٛطّٛ نٜطّٛ طٛنْ غَطّٛ دُوٻِ 83 اٜ ݧَوَ؞ ");
INSERT INTO fuv_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","ندٜ يٜىٰسُ يِعِمٛ اٜ مٛ فُکِّي طٛنْ، کَدِنْ اٜ اَنْدِ اٛ نٜىٰٻِي اٜ مٛ فِيدَ اٜ طُمْ طٛنْ ݧَوُ، سٜيْ يٜىٰسُ پَمِمٛ وِعِ، ‏«‏اَ يِطِ طُمْ يَمْطِتِنْمَا؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","ݧَوْطٛ اٛنْ وِعِمٛ، ‏«‏مٛودِبّٛ، مِ وَلَا بَلَّيْطٛيَمْ حٛشَّيَمْ سُووَيَمْ ندٜرْ نجٛنْغَ نغَنْ شَرٜلْ نغٜلْ ندِيَمْ طَمْ لَنْشَا؞ فُو شَرٜلْ نغٜلْ نغِطُمِ نَتُّکِ، سٜيْ غٛطّٛ اَرْتَيَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","سٜيْ يٜىٰسُ وِعِمٛ، ‏«‏اُمَّ کٛشَّا دَاغٛ مَاطَ، نجَاٻَا؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","طٛنْ اٜ طٛنْ نٜطّٛ اٛنْ يَمْطِتِ، حٛشِّ دَاغٛ مُوطُمْ، فُطِّ يَادُ؞ تٛو، ݧَلْندٜ ندٜ فِي طُعُمْ وَطِ طُمْ ݧَلْندٜ سِوْتَارٜ؞ ");
INSERT INTO fuv_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","نغَمْ نٛنْ، اَرْدِيٻٜ يَحُودَنْکٛعٜنْ مبِعِ جَمْطِتِنَاطٛ اٛنْ، ‏«‏حَنْدٜ طُمْ ݧَلْندٜ سِوْتَارٜ، اَتَّوْرَ حَطِي کٛشَّا دَاغٛ مَاطَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","اَمَّا جَمْطِتِنَاطٛ اٛنْ وِعِٻٜ، ‏«‏جَمْطِتِنْطٛيَمْ وِعِيَمْ مِ حٛشَّا دَاغٛ اَمْ مِ ندِلَّا؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","ٻٜ پَمِمٛ ٻٜ مبِعِ، ‏«‏مٛيٜ وٛنِ بِيطٛمَ کٛشَّا دَاغٛ مَاطَ ندِلَّا؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","اَمَّا جَمْطُتُطٛ اٛنْ اَنْدَا مٛيٜ يَمْطِتِنِمٛ، نغَمْ اٜ وٛودِ يِمْٻٜ طُطْٻٜ اٜ وِغٜىٰرٜ ندٜنْ؛ يٜىٰسُ بٛو يَادَکٜ نَتِّي ندٜرْ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","غَطَ نٛنْ يٜىٰسُ تَوِمٛ ندٜرْ وُرٛ شٜنِينغٛ وِعِمٛ، ‏«‏رَا، اَ يَمْطِتِي!‏ اَلُ وَطُکِ حَکّٜ تٛع غٛطُّمْ ٻُرْطُمْ طُعُمْ حَلُّکِ حٜٻُمَا؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","سٜيْ نٜطّٛ اٛنْ يَحِ وِعِ اَرْدِيٻٜ يَحُودَنْکٛعٜنْ يٜىٰسُ يَمْطِتِنِمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","نغَمْ يٜىٰسُ اٜ حُوَ اِرِ کُوطٜ طٜعٜ ݧَلْندٜ سِوْتَارٜ، اَرْدِيٻٜ يَحُودَنْکٛعٜنْ ڤُطِّ حَلَّنْکِمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","يٜىٰسُ بٛو وِعِٻٜ، ‏«‏حَا حَنْدٜ ݧَاکٛ اَمْ اٜ حُوَ، مِنْ مَا اٜ مِ حُوَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","کَعَ حَالَ وَطِ اَرْدِيٻٜ يَحُودَنْکٛعٜنْ ٻٜيْدِ طَٻُّتُکِ لَاوٛلْ نٛ مبَرْدَتَمٛ؞ نغَمْ نَاع دٛوکَ ݧَلْندٜ سِوْتَارٜ تَنْ اٛ يٜوِ، اَمَّا حَا مَا اٛ وِعِي اَللَّه طُمْ ݧَاکٛ مَاکٛ، وَاتٛ اٛ وَرْتِرِي حٛورٜ مَاکٛ غٛعٛ اٜ اَللَّه وٛنْ طٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","يٜىٰسُ نٛوتِي وِعِٻٜ، ‏«‏اٜ مِ وِعَعٛنْ غٛونغَ، ٻِطّٛ اٛنْ وَطَتَا کٛو طُمٜ کَنُمْ تَنْ، کٛ اٛ يِعِ ݧَاکٛ مَاکٛ اٜ وَطَ تَنْ اٛ وَطَتَ، نغَمْ کٛو طُمٜ کٛ ݧَاکٛ اٛنْ وَطَتَ، کَنْجُمْ ٻِطّٛ اٛنْ وَطَتَ؞ ");
INSERT INTO fuv_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","ݧَاکٛ اٛنْ اٜ يِطِ ٻِطّٛ اٛنْ، ندٜنْ فُو کٛ اٛ وَطَتَ اٜ حٛورٜ مَاکٛ اٛ حٛلِّيطُمْ ٻِطّٛ اٛنْ؞ اٛ حٛلَّيْمٛ کُوطٜ مَوْطٜ ٻُرْطٜ طٜعٜ نغَمْ کَيْطِنٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","نٛنْ نٛ ݧَاکٛ اٛنْ اُمِّنِرْتَ مَيْٻٜ حٛکَّٻٜ يٛنْکِ، نٛنْ مَا ٻِطّٛ اٛنْ اٜ حٛکَّ کٛو مٛيٜ مٛ يِطِ يٛنْکِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","ݧَاکٛ اٛنْ وَطَنْتَا کٛو مٛيٜ کِيتَ اٜ حٛورٜ مَاکٛ؞ اٛ حٛکِّ ٻِطّٛ مَاکٛ لَامُ وَطَنْکِ کٛو طُمٜ کِيتَ، ");
INSERT INTO fuv_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","نغَمْ کٛو مٛيٜ مَوْنِنَ ٻِطّٛ اٛنْ نٛنْ نٛ مَوْنِنِرْتَ ݧَاکٛ اٛنْ؞ کٛو مٛيٜ مٛ مَوْنِنَايِ ٻِطّٛ اٛنْ مَوْنِنْتَا ݧَاکٛ لِلٛيْطٛمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","‏«‏اٜ مِ وِعَعٛنْ غٛونغَ، کٛو مٛيٜ نَنْطٛ بٛلِيطٜ اَمْ حٛولِي اٛنْ طٛنْ لِلٛيْطٛيَمْ اٜ وٛودِ يٛنْکِ کِ رٜعَتَا، اٛ تَپَنْتَاکٜ کِيتَ، اٛ يَادَکٜ اٛ پَٻَّکٜ مَيْدٜ اٛ حٜٻِي يٛنْکِ کِ رٜعَتَا؞ ");
INSERT INTO fuv_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","اٜ مِ وِعَ اٛنْ غٛونغَ، شَرٜلْ اٜ وَرَ، شَرٜلْ نغٜلْ يَادَکٜ وَرِي نغٜلْ يِمْٻٜ ٻٜ کٜٻَايِ يٛنْکِ کِ رٜعَتَا نَنَتَ حٛنٛنْدٜ ٻِطّٛ اَللَّه؞ نَنْٻٜ ندٜ نجَٻِ کٛو ندٜ وِعِ کٜٻَيْ يٛنْکِ کِ رٜعَتَا؞ ");
INSERT INTO fuv_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","نٛنْ نٛ ݧَاکٛ اٛنْ وٛودِرِ بَوْطٜ حٛکُّکِ يٛنْکِ، نٛنْ مَا اٛ حٛکِّي ٻِطّٛ اٛنْ بَوْطٜ حٛکُّکِ يٛنْکِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","کَدِنْ اٛ حٛکِّي ٻِطّٛ اٛنْ لَامُ تَپُکِ کِيتَ، نغَمْ اٛ ٻِي نٜطّٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","تٛع اٛنْ کَيْطِنْ اٜ طُعُمْ، نغَمْ شَرٜلْ اٜ وَرَ نغٜلْ فُو مَيْٻٜ غٛنْٻٜ ندٜرْ غٜنَالٜ نَنَتَ حٛنٛنْدٜ ٻِي نٜطّٛ ");
INSERT INTO fuv_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ٻٜ مبُرْتٛيٛو دَغَ ندٜرْ غٜنَالٜ مَٻّٜ؞ غَطُٻٜ کٛ وٛوطِ ٻٜ اُمّٛتٛ ٻٜ کٜٻَ يٛنْکِ کِ رٜعَتَا، ندٜنْ غَطُٻٜ کٛ حَلِّ بٛو ٻٜ اُمّٛتٛ ٻٜ تَپَنٜىٰ کِيتَ؞ ");
INSERT INTO fuv_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","‏«‏مِ وَاوَتَا مِ وَطَ غٛطُّمْ اٜ حٛورٜ اَمْ، اٜ مِ وَطَ کِيتَ نٛ اَللَّه وِعِيَمْ مِ وَطَ تَنْ؞ اٜ مِ وَطَ کِيتَ غٛونغَ، نغَمْ نَاع کٛ وٜلْنَنْتَيَمْ ٻٜرْندٜ نغَطَيْمِ، اَمَّا کٛ وٜلْنَتَ ٻٜرْندٜ اٛنْ طٛنْ لِلْطٛيَمْ نغَطَيْمِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","‏«‏تٛ مِ حٛکِّي شٜيْدَ حٛورٜ اَمْ، طُمْ حٛشَّيْ کٛ مبِيمِ نَاع طُمْ غٛونغَ؞ ");
INSERT INTO fuv_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","اَمَّا اٜ وٛودِ غٛطّٛ کٛکّٛووٛ شٜيْدَ دٛوْ اَمْ، اٜ مِ اَنْدِ شٜيْدَ غٛونغَ اٛ حٛکَّتَ دٛوْ اَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","اٛنْ لِلِ يِمْٻٜ تٛ يَحَيَ، کَنْکٛ بٛو اٛ حٛکِّعٛنْ شٜيْدَ غٛونغَ دٛوْ اَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","نَاع مِ دَرِي دٛوْ شٜيْدَ طُمْ نٜطّٛ حٛکَّتَ، اَمَّا مِ وِعُکَ نغَمْ کِسٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","يَحَيَ اٜ نَنْدِ اٜ فِتِلَارُ کُٻَّيْندُ حٛکَّ جَيْنغٛلْ، ندٜنْ نغَمْ شَرٜلْ سٜطَّ اٛنْ شُٻِي نَنْکِ بٜلْطُمْ جَيْنغٛلْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","اَمَّا اٜ مِ وٛودِ شٜيْدَ دٛوْ اَمْ ٻُرْطُمْ شٜيْدَ طُمْ يَحَيَ حٛکِّ؞ طٜعٜ کُوطٜ طٜ کُوَيْمِ جٛونِ طٜ ݧَاکٛ مٛ دٛوْ حٛکِّيَمْ مِ يٛتِّنَ، اٜ طٜ کٛکَّ شٜيْدَ ݧَاکٛ اٛنْ لِلٛيِيَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","ݧَاکٛ لِلٛيْطٛيَمْ، کَنْکٛ اٜ حٛورٜ مَاکٛ اٛ حٛکِّي شٜيْدَ دٛوْ اَمْ؞ اٛنْ مٜىٰطَايِ نَنْکِ حٛنٛنْدٜ مَاکٛ، اٛنْ مٜىٰطَايِ يِيکِ نٛ اٛ وَعِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","وٛلْدٜ مَاکٛ بٛو وَلَا ندٜرْ ٻٜرْطٜ مٛوطٛنْ نغَمْ اٛنْ کٛولَاکِ مٛ اٛ لِلٛيِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","اٛنْ نجَنْغَ اَايَاجٜ اَللَّه نغَمْ اٛنْ ݧُمَ اٜ لَاوٛلْ مَاجٜ کٜٻٛتٛنْ يٛنْکِ کِ رٜعَتَا؞ طٜعٜ اَايَاجٜ طٜ نجَنْغٛتٛنْ بٛو اٜ طٜ کٛکَّ شٜيْدَ دٛوْ اَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","اَمَّا فُو اٜ نٛنْ اٛنْ نغَݧِي وَرْکِ تٛ اَمْ کٜٻٛنْ يٛنْکِ کِ رٜعَتَا؞ ");
INSERT INTO fuv_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","‏«‏مِ طَٻِّتَتَا مَوْنِنٜىٰکِ دَغَ تٛ يِمْٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","اَمَّا اٜ مِ اَنْدِ اٛنْ نغِطَا اَللَّه ندٜرْ ٻٜرْطٜ مٛوطٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","مِ وَرْدِي اٜ لَامُ ݧَاکٛ اَمْ، اَمَّا اٛنْ نجَٻَايِيَمْ؞ اَمَّا تٛ غٛطّٛ وَرْدِي اٜ لَامُ حٛورٜ مُوطُمْ، اٛنْ نجَٻَيْمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","نٛ وَطَتَ کٛولٛوطٛنْيَمْ تٛ اٛنْ طَٻِّتَ مَنْتِندِرْکِ، اَمَّا اٛنْ ندُرْوَايِ کٜٻٛنْ مَنْتٜىٰکِ دَغَ تٛ اَللَّه؟ کَنْکٛ تَنْ وٛنِ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","تٛع اٛنْ ݧُمُ مِ وُلّٛتٛعٛنْ يٜىٰسٛ ݧَاکٛ اَمْ؞ مُوسَ مٛ نغَطُطٛنْ کَمُّندٜ دٛوْ مُوطُمْ، کَنْکٛ وٛنِ غُلّٛتٛوطٛعٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","دَا اٛنْ کٛولَکٜنٛ مُوسَ اٜ غٛونغَ، دَا اٛنْ کٛولَکٜيَمْ، نغَمْ دٛوْ اَمْ اٛ وِنْدِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","اَمَّا ندٜ اٛنْ نجَٻَايِ کٛ اٛ وِنْدِ، نٛ نجَٻِرْتٛنْ کٛ مبِيمِ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","غَطَ طُعُمْ، يٜىٰسُ يَحِ فٛنْغٛ مبٜىٰلَ غَلِيلِ، وَاتٛ مبٜىٰلَ تِبَارِيَ؞ ");
INSERT INTO fuv_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","يِمْٻٜ طُطْٻٜ تٛکِّمٛ، نغَمْ ٻٜ نغِعِ فِي کَيْطِنِيطُمْ طُمْ اٛ وَطَنِ ٻٜ نجَمْطَا؞ ");
INSERT INTO fuv_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","سٜيْ يٜىٰسُ پٜنْتِ حٛشّٜىٰرٜ جٛوطٛدِي اٜ تٛکُّٻٜمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","اٜ شَرٜلْ نغٜلْ حُمْتٛ سَکِّنْکِ نغٛ يَحُودَنْکٛعٜنْ ٻَدَکٜ؞ ");
INSERT INTO fuv_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","ندٜ يٜىٰسُ رَارِ يِعِ يِمْٻٜ طُطْٻٜ اٜ نغَرَ تٛ مَاکٛ، اٛ وِعِ فِلِبُسْ، ‏«‏تٛيٜ شٛودٜتٜنْ ݧَمْندُ کٜپَيْندُ يِمْٻٜ ٻٜعٜ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","اٛ وِعُ فِلِبُسْ نٛنْ نغَمْ اٛ فٛوندَمٛ، نغَمْ کَنْکٛ اٜ حٛورٜ مَاکٛ اٜ مٛ اَنْدِ کٛ اٛ وَطَتَ؞ ");
INSERT INTO fuv_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","فِلِبُسْ وِعِمٛ، ‏«‏کٛو نجٛٻَارِ ندِ کُوٛووٛ حٜٻَتَ ندٜرْ لٜبِّ جٛوٜىٰتَتِ ندِ حٜپَتَا سٛودُکِ ݧَمْندُ کٜپَيْندُ کٛو مٛيٜ مَٻّٜ حٜٻَ سٜطَّ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","غٛطّٛ ندٜرْ تٛکُّٻٜمٛ بِعٜتٜىٰطٛ اَنْدِرَاوُسْ مِݧِرَاوٛ سِيمَنْ بِيتُرُسْ وِعِمٛ، ");
INSERT INTO fuv_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","‏«‏اٜ وٛودِ غٛطّٛ سُکَ طٛعٛ غٛودُطٛ مبُرٛودِحٛيْ نجٛوٛيْ اٜ لِپِّ طِطِ؞ اَمَّا غٛونغَ کٛو کٛ طُمْ وَطَنْتَ يِمْٻٜ ٻٜعٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","يٜىٰسُ وِعِٻٜ، ‏«‏مبِعٜىٰ يِمْٻٜ نجٛوطٛو؞»‏ وِغٜىٰرٜ ندٜنْ اٜ وٛودِ غٜىٰنٜ طُطّٜ، نغَمْ نٛنْ يِمْٻٜ ٻٜنْ نجٛوطِي دٛوْ مَاجٜ؞ وٛرْٻٜ تَنْ ندٜرْ مَٻّٜ ٻَدَکٜ 5,000؞ ");
INSERT INTO fuv_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","سٜيْ يٜىٰسُ حٛشِّ بُرٛودِ طُمْ، اٛ يٜتِّ اَللَّه، اٛ سٜنْدَنِطُمْ جٛوطِيٻٜ طٛنْ نٛنْ نٛ حٜپَتَٻٜ؞ نٛنْ مَا اٛ وَادِ اٜ لِپِّ طِنْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","ندٜ فُو يِمْٻٜ ٻٜنْ ݧَامِ کَارِ، اٛ وِعِ تٛکُّٻٜمٛ، ‏«‏کَوْرِتٜىٰ کٛ حٛرِي، تٛع طُمْ لَلِّنَ کٛو سٜطَّ مَاجُمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","سٜيْ ٻٜ مٛٻْتِ کٛ حٛرِي دَغَ مبُرٛودِحٛيْ نجٛوٛيْ کٛيْ يِمْٻٜ ݧَامِ کٛرْنِ، ٻٜ کٜبِّنِ کٛنْدٛوجٜ سَڤّٛ اٜ طِطِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","ندٜ يِمْٻٜ نغِعِ فِي کَيْطِنِيطُمْ طُعُمْ طُمْ يٜىٰسُ وَطِ، ٻٜ ڤُطِّ وِيکِ، ‏«‏غٛونغَ اٛعٛ وٛنِ اٛنْ طٛنْ اَنَّبِيجٛ غَرَيْطٛ دُونِيَارُ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","يٜىٰسُ اٜ اَنْدِ اٜ ٻٜ نغِطِ نَنْغُکِمٛ، ٻٜ نغَرْتِرَمٛ لَامِيطٛ اٜ سٜمْبٜ؞ نغَمْ نٛنْ اٛ اَلِٻٜ اٛ پٜنْتِ حٛشّٜىٰرٜ کَنْکٛ تَنْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","ندٜ نَانغٜ حِيرِ، تٛکُّٻٜ يٜىٰسُ نجَحِ مبٜىٰلَ، ");
INSERT INTO fuv_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ٻٜ نَتِّ کٛمِوَلْ، ٻٜ ڤُطِّ حُولُکِ مبٜىٰلَ نغَنْ يَاکِ کَفَرْنَحُمْ؞ اٜ شَرٜلْ نغٜلْ جٜمَّ وَطِي، يٜىٰسُ بٛو وَرٛيَايِ تٛ مَٻّٜ تَوْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","مبٜىٰلَ نغَنْ وَطِ کَ فَلْپُکِ نغَمْ حٜنْدُ شٜمْبِنْدُ اٜ وَطَ؞ ");
INSERT INTO fuv_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","ندٜ ٻٜ نغَطِ يَادُ ندٜرْ مبٜىٰلَ نغَنْ حٜوْتِ مِلْ تَتِ کٛو نَيِ، ٻٜ نغِعِ يٜىٰسُ اٜ يَحَ دٛوْ ندِيَمْ طَمْ اٜ وَرٛيَ تٛ کٛمِوَلْ مَٻّٜ، کُلٛلْ نَنْغِٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","اَمَّا يٜىٰسُ وِعِٻٜ، ‏«‏تٛع اٛنْ کُلُ، طُمْ مِنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","سٜيْ ٻٜ نجَٻِ ٻٜ کٛشِّمٛ ندٜرْ کٛمِوَلْ نغَلْ، طٛنْ اٜ طٛنْ کٛمِوَلْ نغَلْ يٛتِّي تٛ ٻٜ نجِڤّٛتٛو؞ ");
INSERT INTO fuv_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","ندٜ فِنِ، حٛرِيٻٜ غٛنْٻٜ نغٛنْ تٛنْ فٛنْغٛ مبٜىٰلَ تٛ تٛکُّٻٜ يٜىٰسُ نَتِّ کٛمِوَلْ، ٻٜ ڤَامِ کٛمِوَلْ غٛعٛتَلْ تَنْ وٛنْدٛنٛ طٛنْ، ندٜنْ يٜىٰسُ بٛو نَتِّدَايِ کٛمِوَلْ نغَلْ اٜ تٛکُّٻٜمٛ، اَمَّا کَمْٻٜ تَنْ ندِلِّ ندٜرْ مَاغَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","سٜيْ غٛطّٜ کٛمِيجٜ پِوٛيْطٜ تِبَارِيَ نجٛتِّي دَاندٜ مبٜىٰلَ حَادٜ وِغٜىٰرٜ تٛ يِمْٻٜ ݧَامِ بُرٛودِ غَطَ يٜىٰسُ يٜتِّي اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","ندٜ يِمْٻٜ نغِعِ يٜىٰسُ اٜ تٛکُّٻٜمٛ نغَلَا طٛنْ، سٜيْ ٻٜ نَتِّ کٛمِيجٜ طٜنْ، ٻٜ نجَحِ کَفَرْنَحُمْ اٜ ٻٜ طَٻِّتَ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","ندٜ ٻٜ تَوِمٛ فٛنْغٛ مبٜىٰلَ تٛ کَفَرْنَحُمْ، ٻٜ مبِعِمٛ، ‏«‏مٛودِبّٛ، ندٜيٜ نغَرٛيْطَا طٛعٛ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","يٜىٰسُ نٛوتِي وِعِٻٜ، ‏«‏اٜ مِ وِعَعٛنْ غٛونغَ، اٛنْ طَٻِّتَيَمْ نَاع نغَمْ اٛنْ نغِعِي کَيْطِنِيطُمْ طُمْ نغَطُمِ، اَمَّا نغَمْ اٛنْ ݧَامِي بُرٛودِ اٛنْ کَارِي؞ ");
INSERT INTO fuv_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","تٛع اٛنْ کُوَنْ ݧَمْندُ لَلَّيْندُ، اَمَّا کُوَنٜىٰ ݧَمْندُ تَبِّتَيْندُ کٛکَّيْندُ يٛنْکِ کِ رٜعَتَا، ندُ ٻِي نٜطّٛ حٛکَّتَعٛنْ، نغَمْ اَللَّه ݧَاکٛ مٛ دٛوْ وَطَنِيمٛ اَلَامَ کٛلَّيْطُمْ جَٻِيمٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","سٜيْ ٻٜ پَمِ يٜىٰسُ ٻٜ مبِعِ، ‏«‏طُمٜ مِنْ نغَطَتَ نغَمْ مِنْ نغَطَ کٛ اَللَّه يِطِ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","يٜىٰسُ وِعِٻٜ، ‏«‏کٛ اَللَّه يِطِ نغَطٛنْ وٛنِ کٛولٛوطٛنْ اٛنْ طٛنْ مٛ اٛ لِلٛيِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","ٻٜ مبِعِمٛ، ‏«‏طُمٜ کَيْطِنِيطُمْ نغَطَتَا نغَمْ مِنْ نغِعَطُمْ مِنْ کٛولٛمَا؟ طُمٜ نغَطَتَا؟ ");
INSERT INTO fuv_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","مَامَعٜنْ مٜىٰطٜنْ ݧَامِي ݧَمْندُ ندٜرْ لَدّٜ پِوٛيْندُ دَغَ دٛوْ بِعٜتٜىٰندُ مَنَّ، نٛنْ نٛ طُمْ وِنْدِرَا، ‏‹‏اٛ حٛکِّيٻٜ ݧَمْندُ پِوٛيْندُ دَغَ دٛوْ نغَمْ ٻٜ ݧَامَ؞›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","يٜىٰسُ وِعِٻٜ، ‏«‏اٜ مِ وِعَعٛنْ غٛونغَ، نَاع مُوسَ حٛکِّعٛنْ ݧَمْندُ پِوٛيْندُ دَغَ دٛوْ، اَمَّا ݧَاکٛ اَمْ وٛنِ کٛکُّطٛعٛنْ ݧَمْندُ غٛونغَارُ پِوٛيْندُ دَغَ دٛوْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","نغَمْ ݧَمْندُ ندُ اَللَّه حٛکِّ وٛنِ اٛنْ طٛنْ غَرٛيْطٛ دَغَ دٛوْ کٛکّٛووٛ دُونِيَارُ يٛنْکِ کِ رٜعَتَا؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","ٻٜ مبِعِمٛ، ‏«‏مٛودِبّٛ، حٛکُّمِنْ ݧَمْندُ ندُعُ کٛو ندٜيٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","يٜىٰسُ وِعِٻٜ، ‏«‏مِنْ وٛنِ ݧَمْندُ کٛکَّيْندُ يٛنْکِ؞ فُو غَرْطٛ تٛ اَمْ فُطِّتَتَا نَنَ وٜىٰلٛ، فُو کٛولِيطٛيَمْ فُطِّتَتَا نَنَ طٛنْکَ؞ ");
INSERT INTO fuv_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","اَمَّا نٛ مبِيمِعٛنْ، اٛنْ نغِعِييَمْ، فُو اٜ نٛنْ اٛنْ کٛولَاکِيَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","کٛو مٛيٜ مٛ ݧَاکٛ اَمْ حٛکِّيَمْ وَرَيْ تٛ اَمْ، ندٜنْ فُو غَرْطٛ تٛ اَمْ مِ رِيوَتَامٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","نغَمْ مِ وَرٛيِي دَغَ دٛوْ نَاع نغَمْ مِ وَطَ کٛ نغِطُمِ، اَمَّا مِ وَطَ کٛ لِلٛيْطٛيَمْ يِطِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","کٛ لِلٛيْطٛيَمْ يِطِ مِ وَطَ وٛنِ، تٛع مِ دُلَّ کٛو غٛعٛتٛ ندٜرْ ٻٜ اٛ حٛکِّيَمْ، اَمَّا مِ اُمِّنَٻٜ ݧَلْندٜ جَانغٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","نغَمْ کٛ ݧَاکٛ اَمْ يِطِ وٛنِ کٛو مٛيٜ دَارُطٛ ٻِطّٛ اٛنْ حٛولِيمٛ حٜٻَ يٛنْکِ کِ رٜعَتَا، ندٜنْ مِنْ بٛو مِ اُمِّنَيْمٛ ݧَلْندٜ جَانغٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","سٜيْ يَحُودَنْکٛعٜنْ ڤُطِّ مٜتِتَاکِ دٛوْ مَاکٛ، نغَمْ اٛ وِعِي، ‏«‏مِنْ وٛنِ ݧَمْندُ پِوٛيْندُ دَغَ دٛوْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","ٻٜ مبِعِ، ‏«‏نَاع اٛعٛ وٛنِ يٜىٰسُ ٻِطّٛ يُسُفُ؟ اٜنْ اَنْدِ ݧَاکٛ مَاکٛ اٜ مَدُوجٛ مَاکٛ؞ نٛ وَطَتَ جٛونِ اٛ وِعَ دَغَ دٛوْ اٛ پِوٛيِ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","يٜىٰسُ وِعِٻٜ، ‏«‏اَلٜىٰ مٜتِتَاکِ حَکُّندٜ مٛوطٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","وَلَا غَرَيْطٛ تٛ اَمْ سٜيْ تٛ ݧَاکٛ اَمْ لِلٛيْطٛيَمْ وَدِّيمٛ، مِنْ بٛو مِ اُمِّنَيْمٛ ݧَلْندٜ جَانغٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","اَنَّبٛعٜنْ مبِنْدِي وِيکِ، ‏‹‏اَللَّه اٜکِّتِنَيْ کٛو مٛيٜ؞›‏ کٛو مٛيٜ کٜتِّندَنِيطٛ ݧَاکٛ اٛنْ اٜکِّتِي دَغَ تٛ مَاکٛ اٜ وَرَ تٛ اَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","وَلَا مٜىٰطُطٛ يِيکِ ݧَاکٛ اٛنْ سٜيْ نِ اٛنْ طٛنْ پِوٛيْطٛ دَغَ تٛ مَاکٛ، کَنْکٛ تَنْ مٜىٰطِ يِيکِ ݧَاکٛ اٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","اٜ مِ وِعَعٛنْ غٛونغَ، کٛو مٛيٜ کٛولِيطٛيَمْ اٜ وٛودِ يٛنْکِ کِ رٜعَتَا؞ ");
INSERT INTO fuv_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","مِنْ وٛنِ ݧَمْندُ کٛکَّيْندُ يٛنْکِ کِ رٜعَتَا؞ ");
INSERT INTO fuv_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","مَامَعٜنْ مٛوطٛنْ ݧَامِي ‏‹‏مَنَّ،›‏ اَمَّا فُو اٜ نٛنْ ٻٜ مَايِي؞ ");
INSERT INTO fuv_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","اَمَّا رَا ݧَمْندُ پِوٛيْندُ دَغَ دٛوْ، تٛ نٜطّٛ ݧَامِيندُ مَايَتَا؞ ");
INSERT INTO fuv_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","مِنْ وٛنِ ݧَمْندُ کٛکَّيْندُ يٛنْکِ پِوٛيْندُ دَغَ دٛوْ؞ فُو ݧَامُطٛندُ، اٛ جٛوطٛتٛ حَا اَبَدَا؞ ندُعُ ݧَمْندُ طُمْ ٻَنْدُ اَمْ، ندُ کٛکَّيْمِ نغَمْ يِمْٻٜ دُونِيَارُ کٜٻَ يٛنْکِ کِ رٜعَتَا؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","سٜيْ يَحُودَنْکٛعٜنْ ٻٜنْ ڤُطِّ غٜدِّ حَکُّندٜ مَٻّٜ، اٜ ٻٜ مبِعَ، ‏«‏نٛ وَطَتَ نٜطّٛ اٛعٛ حٛکَّعٜنْ ٻَنْدُ مَاکٛ ݧَامٜنْ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","يٜىٰسُ وِعِٻٜ، ‏«‏اٜ مِ وِعَعٛنْ غٛونغَ، تٛ اٛنْ ݧَامَايِ ٻَنْدُ ٻِي نٜطّٛ، کَدِنْ تٛ اٛنْ نجَرَايِ پِيپَمْ مَاکٛ، اٛنْ نغَلَا يٛنْکِ ندٜرْ مٛوطٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","فُو ݧَامُطٛ ٻَنْدُ اَمْ ندٜنْ يَرِ پِيپَمْ اَمْ اٜ وٛودِ يٛنْکِ کِ رٜعَتَا، ندٜنْ مِ اُمِّنَيْمٛ ݧَلْندٜ جَانغٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","نغَمْ ٻَنْدُ اَمْ وٛنِ ݧَمْندُ غٛونغَارُ، پِيپَمْ اَمْ بٛو وٛنِ نجَرَمْ طَمْ غٛونغَ؞ ");
INSERT INTO fuv_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","کٛو مٛيٜ ݧَامِ ٻَنْدُ اَمْ يَرِ پِيپَمْ اَمْ، اٜ مٛ سُمْڤٛوتِرَ اٜ اَمْ، مِنْ مَا اٜ مِ سُمْڤٛوتِرَ اٜ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","نٛنْ نٛ ݧَاکٛ غٛودُطٛ يٛنْکِ لِلِيَمْ، کَدِنْ اٜ مِ وَطَ جٛنْدٜ اَمْ نغَمْ مَاکٛ، نٛنْ مَا فُو ݧَامُطٛ ٻَنْدُ اَمْ وَطَيْ جٛنْدٜ مُوطُمْ نغَمْ اَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","کَنْجُمْ وٛنِ ݧَمْندُ پِوٛيْندُ دَغَ دٛوْ نَاع اِرِ ݧَمْندُ ندُ مَامَعٜنْ مٛوطٛنْ ݧَامِ مَايِ؞ اَمَّا فُو ݧَامُطٛ ݧَمْندُ ندُعُ اٛ حٜٻَيْ يٛنْکِ کِ رٜعَتَا؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","يٜىٰسُ وِعِ طُعُمْ شَرٜلْ کٛ اٛ اٜکِّتِنْتَ ندٜرْ سُودُ دٛعَارٜ تٛ کَفَرْنَحُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","طُطْٻٜ ندٜرْ تٛکُّٻٜمٛ ندٜ نَنِ نٛنْ، ٻٜ مبِعِ، ‏«‏نغٛعٛلْ اٜکِّتِنٛلْ اٜ نغٛلْ سَطِ؞ مٛيٜ فَامَتَنغٛلْ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","اَمَّا يٜىٰسُ اٜ اَنْدِ تٛکُّٻٜمٛ اٜ مٜتِتٛو دٛوْ کٛ اٛ وِعِ، اٛ وِعِٻٜ، ‏«‏اٜکِّتِنٛلْ نغٛعٛلْ وَنِّعٛنْ؟ ");
INSERT INTO fuv_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","کٛ نغَطٛتٛنْ تٛ اٛنْ نغِعِي ٻِي نٜطّٛ اٜ سٛعّٛو تٛ وٛنْدٛنٛ؟ ");
INSERT INTO fuv_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","رُوحُ اَللَّه اٜ حٛکَّ يٛنْکِ؞ ٻَنْدُ نَاع طُمْ غٛطُّمْ؞ حَالَ کَ مٜتَنْمِعٛنْ کَ وَطَيْعٛنْ کٜٻٛنْ رُوحُ اَللَّه کٛکَّيْطُمْ يٛنْکِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","اَمَّا اٜ وٛودِ وٛٻّٜ ندٜرْ مٛوطٛنْ ٻٜ کٛولَاکِيَمْ؞»‏ دَغَ اَرَنْدٜ يٜىٰسُ اٜ اَنْدِ يِمْٻٜ ٻٜ کٛولَاکِمٛ اٜ نٜطّٛ کٛکِّتِرَيْطٛمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","سٜيْ اٛ وِعِٻٜ، ‏«‏کَنْجُمْ وَطِ مبِيمِعٛنْ وَلَا غَرَيْطٛ تٛ اَمْ سٜيْ تٛ ݧَاکٛ مٛ دٛوْ جَٻِي اٛ وَرَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","غَطَ طُعُمْ تٛکُّٻٜمٛ طُطْٻٜ شٜنْدِرِ اٜ مَاکٛ اَلِ تٛکُّکِمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","يٜىٰسُ وِعِ تٛکُّٻٜمٛ سَڤّٛ اٜ طِطٛ، ‏«‏اٛنٛنْ مَا اٛنْ نغِطِ اَلُکِيَمْ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","سِيمَنْ بِيتُرُسْ وِعِمٛ، ‏«‏مٛودِبّٛ، تٛ مٛيٜ مِنْ نجَحَتَ؟ اَنْ وٛودِ بٛلِيطٜ کٛکَّيْطٜ يٛنْکِ کِ رٜعَتَا؞ ");
INSERT INTO fuv_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","مِنْ نجَادَکٜ مِنْ کٛولَکٜمَ، اٜ مِنْ اَنْدِ اَنْ وٛنِ شٜنِيطٛ مٛ اَللَّه؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","سٜيْ يٜىٰسُ وِعِٻٜ، ‏«‏نَاع اٛنٛنْ سَڤّٛ اٜ طِطٛ شُٻُمِ؟ غٛعٛتٛ مٛوطٛنْ اٛ شٜيْطَنْ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","اٜ مٛ مٜتَ دٛوْ يَحُودَ ٻِي سِيمَنْ اِسْکَرِيٛوتِ، کٛو ندٜ اٛ غٛعٛتٛ ندٜرْ تٛکُّٻٜمٛ سَڤّٛ اٜ طِطٛ ٻٜنْ، کَنْکٛ وٛنِ کٛکِّتِرَيْطٛ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","غَطَ طُعُمْ يٜىٰسُ وَطِ کَ يِيلَاکِ ندٜرْ لٜيْدِ غَلِيلِ؞ اٛ يِطَا يِيلَاکِ ندٜرْ لٜيْدِ يَحُودِيَ، نغَمْ اَرْدِيٻٜ يَحُودَنْکٛعٜنْ وٛنْٻٜ تٛنْ اٜ ٻٜ طَٻِّتَ لَاوٛلْ نٛ ٻٜ مبَرِرْتَمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","تٛو، شَرٜلْ حُمْتٛ لُکُرُوجِ نغٛ يَحُودَنْکٛعٜنْ ٻَدَکٜ؞ ");
INSERT INTO fuv_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","نغَمْ نٛنْ مِݧِرَاٻٜ يٜىٰسُ وٛرْٻٜ مبِعِمٛ، ‏«‏اَلُ وِغٜىٰرٜ ندٜعٜ نجَحَا لٜيْدِ يَحُودِيَ، نغَمْ تٛکُّٻٜمَ نغِعَ کُوطٜ طٜ کُوَتَا؞ ");
INSERT INTO fuv_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","فُو غِطّٛ اَنْدٜىٰ اٜ کٛو تٛيٜ حُوَتَا اٜ سُوطٜ؞ ندٜ اَ حُوَ کُوطٜ کَيْطِنِيطٜ اِرِ طٜعٜ، وَنْغِنْ حٛورٜ مَاطَ نغَمْ دُونِيَارُ فُو يِعُمَا؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","کٛو مِݧِرَاٻٜ مَاکٛ ٻٜنْ مَا ٻٜ کٛولَاکِمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","يٜىٰسُ وِعِٻٜ، ‏«‏شَرٜلْ اَمْ وَطَايِ تَوْ، اَمَّا اٛنٛنْ کٛو نغٜلٜ شَرٜلْ نغٜلْ کَانُنغٜلْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","جٛونِ دُونِيَارُ حٜٻَايِ کٛ وَݧِرْتَعٛنْ، اَمَّا اٜ ندُ وَݧِييَمْ نغَمْ اٜ مِ وِعَ کُوطٜ مَيْرُ طٜ کَلُّطٜ؞ ");
INSERT INTO fuv_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","اٛنٛنْ نجَحٜىٰ حُمْتٛ نغٛنْ، مِنْ مِ يَحَتَا، نغَمْ شَرٜلْ اَمْ وَطَايِ تَوْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","غَطَ اٛ وِعِي نٛنْ، اٛ جٛوطِي ندٜرْ لٜيْدِ غَلِيلِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","اَمَّا غَطَ مِݧِرَاٻٜ مَاکٛ نجَحِي حُمْتٛ نغٛنْ، سٜيْ کَنْکٛ مَا اٛ يَحِ نَاع اٜ نجَيْرِ اَمَّا اٜ سُوطٜ؞ ");
INSERT INTO fuv_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","تٛ حُمْتٛ نغٛنْ، اَرْدِيٻٜ يَحُودَنْکٛعٜنْ اٜ طَٻِّتَمٛ، اٜ ٻٜ پَمَ يِمْٻٜ، ‏«‏تٛيٜ اٛ وٛنِ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","ندٜرْ حَوْرِيندٜ ندٜنْ يِمْٻٜ اٜ سٛوندٛوتِرَ دٛوْ مَاکٛ نَاع سٜطَّ؞ وٛٻّٜ اٜ مبِعَ، ‏«‏اٛعٛ نٜطّٛ اٜ وٛودِ نغِکُّ بٛطُّمْ؞»‏ وٛٻّٜ بٛو اٜ مبِعَ، ‏«‏اٜ مٛ پٛيْرَ يِمْٻٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","اَمَّا نغَمْ اٜ ٻٜ کُلَ اَرْدِيٻٜ يَحُودَنْکٛعٜنْ وَلَا مٜتُطٛ دٛوْ مَاکٛ اٜ نجَيْرِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","ندٜ سٜنْدٜرٜ بَلْطٜ حُمْتٛ نغٛنْ پَٻِّي، يٜىٰسُ نَتِّ وُرٛ شٜنِينغٛ فُطِّ اٜکِّتِنْکِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","اَرْدِيٻٜ يَحُودَنْکٛعٜنْ کَيْطِنِ اٜ اٜکِّتِنٛلْ مَاکٛ، ٻٜ مبِعِ، ‏«‏نٛ وَطِ نٜطّٛ اٛعٛ وٛودِرِ اَنْدَلْ نِحِ ندٜ کٛو جَنْدٜ اٛ مٜىٰطَايِ يَاکِ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","يٜىٰسُ وِعِٻٜ، ‏«‏کٛ اٜکِّتِنَيْمِ نَاع طُمْ اٜکِّتِنٛلْ اَمْ، اَمَّا طُمْ اٜکِّتِنٛلْ اٛنْ طٛنْ لِلٛيْطٛيَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","کٛو مٛيٜ شُٻُطٛ وَطَ کٛ اَللَّه يِطِ اٛ اَنْدَيْ کٛو کٛ اٜکِّتِنَيْمِ تٛ اَللَّه طُمْ پِوٛيِ، کٛو کٛ مبِعَيْمِ طُمْ بٛلِيطٜ اَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","کٛو مٛيٜ مٜتٛووٛ بٛلِيطٜ حٛورٜ مُوطُمْ اٜ طَٻِّتَنَ حٛورٜ مُوطُمْ مَنْغُ، اَمَّا کُوٛووٛ نغَمْ مَوْنِنَ اٛنْ طٛنْ لِلٛيْطٛمٛ اٛ نٜطّٛ مٛ غٛونغَ، وَلَا وٛنْدٜ فٜوْرٜ تٛ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","نَاع مُوسَ حٛکِّيعٛنْ اَتَّوْرَ؟ فُو اٜ نٛنْ وَلَا غٛطّٛ مٛوطٛنْ تٛکُّطٛطُمْ؞ نغَمْ طُمٜ نغِطّٛنْ وَرْکِيَمْ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","يِمْٻٜ ٻٜنْ مبِعِمٛ، ‏«‏اَ غِنَّاطٛ!‏ مٛيٜ يِطِ وَرْکِمَ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","يٜىٰسُ وِعِٻٜ، ‏«‏مِ وَطِي کٛ حَيْطِنِي غٛعٛ، اٛنْ فُو اٛنْ کَيْطِنِي؞ ");
INSERT INTO fuv_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","مُوسَ وِعِعٛنْ نغَطٛنْ کَ نَادُکِ ٻِٻّٜ مٛوطٛنْ، اٛنْ نَادَ ݧَلْندٜ سِوْتَارٜ؞ کٛو ندٜ نَاع مُوسَ فُطِّطُمْ، اَمَّا مَامَعٜنْ مٜىٰطٜنْ اَرَنْدٜعٜنْ فُطِّطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","تٛ طُمْ نَادِي ٻِنْغٜلْ ݧَلْندٜ سِوْتَارٜ نغَمْ تٛع طُمْ يٜوَ اَتَّوْرَ مُوسَ، نغَمْ طُمٜ مٛنَّنْتٛنْيَمْ نغَمْ مِ يَمْطِتِنِي ٻَنْدُ نٜطّٛ فُو ݧَلْندٜ سِوْتَارٜ؟ ");
INSERT INTO fuv_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","تٛع اٛنْ نغَطَنْ يِمْٻٜ کِيتَ دٛوْ کٛ غِتٜ نغِعَتَ تَنْ، اَمَّا نغَطٜىٰ کِيتَ غٛونغَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","وٛٻّٜ يِمْٻٜ اُرُشَلِيمَ مبِعِ، ‏«‏نَاع اٛعٛ نٜطّٛ وٛنِ مٛ اَرْدِيٻٜ طَٻِّتَتَ وَرْکِ؟ ");
INSERT INTO fuv_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","رَمّٛ طٛعٛ اٜ مٛ مٜتَ اٜ نجَيْرِ ٻٜ مبِعَايِمٛ غٛطُّمْ؞ اٛنْ ݧُمَ اَرْدِيٻٜ تَبِّتِنِي اٛعٛ نٜطّٛ وٛنِ اَلْمَسِيحُ؟ ");
INSERT INTO fuv_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","اَمَّا اٜنْ اَنْدِ تٛ نٜطّٛ اٛعٛ پِوٛيِ؞ تٛ اَلْمَسِيحُ وَرِي، وَلَا اَنْدَيْطٛ تٛ اٛ پِوٛيِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","يٜىٰسُ اٜ ندٜرْ اٜکِّتِنْکِ ندٜرْ وُرٛ شٜنِينغٛ نغٛنْ، سٜيْ وِعِ اٜ سٜمْبٜ، ‏«‏غٛونغَ، اٛنْ اَنْدِيَمْ، اٛنْ اَنْدِ تٛ پِوٛيْمِ؞ مِ وَرٛيَايِ نغَمْ حٛورٜ اَمْ؞ اَمَّا اٛنْ طٛنْ لِلٛيْطٛيَمْ اٜ مٛ وٛودِ غٛونغَ؞ کَنْکٛ بٛو اٛنْ اَنْدَامٛ، ");
INSERT INTO fuv_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","اَمَّا مِنْ اٜ مِ اَنْدِمٛ، نغَمْ دَغَ تٛ مَاکٛ پِوٛيْمِ، کَنْکٛ لِلٛيِيَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","وٛٻّٜ نغِطِي نَنْغُکِمٛ، اَمَّا وَلَا غَطُطٛ جُنْغٛ دٛوْ مَاکٛ، نغَمْ شَرٜلْ مَاکٛ وَطَايِ تَوْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","اَمَّا فُو اٜ نٛنْ طُطْٻٜ ندٜرْ حَوْرُتُٻٜ ٻٜنْ کٛولِيمٛ مبِعِ، ‏«‏تٛ اَلْمَسِيحُ وَرِي، اٛ وَطَيْ کٛ حَيْطِنِ ٻُرْطُمْ طُمْ نٜطّٛ اٛعٛ وَطِ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","فَارِسَنْکٛعٜنْ نَنِ يِمْٻٜ حَوْرُتُٻٜ اٜ مٜتَ اِرِ حَالَ کَعَ دٛوْ يٜىٰسُ، سٜيْ کَمْٻٜ اٜ مَوْٻٜ اَرْدِيٻٜ دِينَ ٻٜ لِلِ تَادِيٻٜ وُرٛ شٜنِينغٛ نغَمْ نَنْغَمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","يٜىٰسُ وِعِ، ‏«‏مِ جٛوطٛدٛتٛ اٜ مٛوطٛنْ شَرٜلْ سٜطَّ يٜىٰسٛ طٛعٛ، غَطَ طٛنْ مِ سٛعّٛتٛ تٛ لِلٛيْطٛيَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","اٛنْ طَٻِّتَيْيَمْ اٛنْ کٜٻَتَايَمْ، تٛ نغٛنُمِ بٛو اٛنْ مبَاوَتَا يَاکِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","سٜيْ اَرْدِيٻٜ يَحُودَنْکٛعٜنْ مبِعِ حَکُّندٜ مَٻّٜ، ‏«‏تٛيٜ نٜطّٛ اٛعٛ يِطِ يَاکِ تٛ اٜنْ مبَاوَتَا حٜٻُکِمٛ؟ کٛو اٜ مٛ يِطِ يَاکِ ندٜرْ غَرِيجٜ حٜلٜنَنْکٛعٜنْ تٛ يِمْٻٜ مٜىٰطٜنْ نغٛنِ اٛ اٜکِّتِنَ حٜلٜنَنْکٛعٜنْ؟ ");
INSERT INTO fuv_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","طُمٜ اٛ يِطِ وِيکِ ندٜ اٛ وِعِ، ‏‹‏اٛنْ طَٻِّتَيْيَمْ اَمَّا اٛنْ کٜٻَتَايَمْ؞›‏ کَدِنْ کٛ اٛ يِطِ وِيکِ ندٜ اٛ وِعِ، ‏‹‏تٛ نغٛنْمِ اٛنْ مبَاوَتَا يَاکِ؟›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","ݧَلْندٜ ندٜ حُمْتٛ نغٛنْ رٜعَتَ، کَيْرٜ وٛنِ ݧَلْندٜ مَوْندٜ ندٜ حُمْتٛ نغٛنْ؞ اٜ ݧَلْندٜ ندٜنْ يٜىٰسُ اُمِّي، دَرِي، وِعِ اٜ سٜمْبٜ، ‏«‏فُو نَنَيْطٛ طٛنْکَ وَرَ تٛ اَمْ مِ حٛکَّيْمٛ کٛ اٛ يَرَتَ؞ ");
INSERT INTO fuv_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","نٛنْ نٛ طُمْ وِنْدِرَا، ‏‹‏کٛو مٛيٜ کٛولِيطٛيَمْ، شَنْطِ ندِيَمْ کٛکّٛوجَمْ يٛنْکِ وَطَيْ کَ اِلُکِ دَغَ ندٜرْ ٻٜرْندٜ مَاکٛ؞›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","ندٜ يٜىٰسُ وِعِ طُعُمْ، دٛوْ رُوحُ اَللَّه اٛ مٜتَتَ طُمْ کٛولِيٻٜمٛ کٜٻَتَ؞ اٜ نغٜلْ طٛنْ شَرٜلْ اَللَّه حٛکَّايِ رُوحُ مُوطُمْ تَوْ، نغَمْ يٜىٰسُ تٜدِّنَاکَ تَوْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","ندٜ يِمْٻٜ حَوْرُتُٻٜ نَنِ حَالَ کَعَ کَ يٜىٰسُ وِعِ، وٛٻّٜ ندٜرْ مَٻّٜ مبِعِ، ‏«‏اٛعٛ نٜطّٛ، غٛونغَ، اٛ اٛنْ طٛنْ اَنَّبِيجٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","وٛٻّٜ بٛو مبِعِ، ‏«‏کَنْکٛ وٛنِ اَلْمَسِيحُ؞»‏ اَمَّا وٛٻّٜ مبِعِ، ‏«‏نٛ وَطَتَ اَلْمَسِيحُ پِوٛيَ لٜيْدِ غَلِيلِ؟ ");
INSERT INTO fuv_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","‏«‏نَاع اَايَارٜ وِعِي، اَلْمَسِيحُ پِوٛيَيْ دَغَ ندٜرْ لٜݧٛلْ دَوْدَ، ندٜنْ طُمْ دَݧَيْمٛ تٛ بَيْتَلَامِ، غَرِيرِ تٛ دَوْدَ جٛوطِنٛو؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","نغَمْ نٛنْ طُمْ حٜٻِ سٜنْدِندِرْکِ حَکُّندٜ حَوْرُتُٻٜ ٻٜنْ دٛوْ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","وٛٻّٜ اٜ نغِطِ نَنْغُکِمٛ، اَمَّا وَلَا غَطُطٛ جُنْغٛ دٛوْ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","سٜيْ تَادِيٻٜ وُرٛ شٜنِينغٛ ٻٜنْ شٛعِّي تٛ مَوْٻٜ اَرْدِيٻٜ دِينَ اٜ فَارِسَنْکٛعٜنْ؞ مَوْٻٜ ٻٜنْ اٜ فَارِسَنْکٛعٜنْ ٻٜنْ پَمِٻٜ، مبِعِ، ‏«‏نغَمْ طُمٜ اٛنْ نَنْغَايِمٛ نغَدُّطٛنْمٛ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","تَادِيٻٜ ٻٜنْ مبِعِ، ‏«‏وَلَا مٜىٰطُطٛ مٜتِرْکِ نٛ نٜطّٛ اٛعٛ مٜتِرِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","فَارِسَنْکٛعٜنْ مبِعِٻٜ، ‏«‏کٛو اٛنٛنْ مَا اٛ پٛيْرِيعٛنْ؟ ");
INSERT INTO fuv_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","کٛو اٛنْ نغِعِي غٛطّٛ ندٜرْ اَرْدِيٻٜ يَحُودَنْکٛعٜنْ اٜ فَارِسَنْکٛعٜنْ حٛولَکٜمٛ؟ ");
INSERT INTO fuv_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","اَمَّا ٻٜعٜ حَوْرُتُٻٜ ٻٜ اَنْدَا کٛو طُمٜ دٛوْ اَتَّوْرَ، ٻٜ لَانَاٻٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","نِکٛودِمُسْ جَانٛوطٛ تٛ يٜىٰسُ اٛ غٛعٛتٛ ندٜرْ فَارِسَنْکٛعٜنْ ٻٜنْ، اٛ وِعِٻٜ، ");
INSERT INTO fuv_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","‏«‏کٛ اَتَّوْرَ مٜىٰطٜنْ وِعِ وٛنِ اٜنْ نغَطَنْتَا نٜطّٛ کِيتَ نَا طُمْ نَنِي کٛ اٛ وِعِ نغَمْ طُمْ اَنْدَ کٛ اٛ وَطَتَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","ٻٜ مبِعِمٛ، ‏«‏اَنْ مَا غَلِيلِ پِوٛيْطَا؟ جَنْغُ وٛلْدٜ اَللَّه بٛطُّمْ، اَ يِعَيْ وَلَا اَنَّبِيجٛ پِوٛيَيْطٛ دَغَ غَلِيلِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","سٜيْ کٛو مٛيٜ حٛوتِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","اَمَّا يٜىٰسُ يَحِ حٛشّٜىٰرٜ ندٜ لٜطّٜ جَيْتُنْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","ندٜ فِنِ اِلَا سُبَکَ اٛ سٛعِّي وُرٛ شٜنِينغٛ؞ يِمْٻٜ طُطْٻٜ کَوْرِتِ حَادٜ مَاکٛ، اٛ جٛوطِي اٛ فُطِّي اٜکِّتِنْکِٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","سٜيْ مٛودِٻّٜ اَتَّوْرَ اٜ فَارِسَنْکٛعٜنْ نغَدِّ دٜبّٛ نَنْغَاطٛ اٜ وَطَ نجٜىٰنُ؞ ٻٜ نغَطِ دٜبّٛ اٛنْ دَرِي يٜىٰسٛ يِمْٻٜ غٛنْٻٜ طٛنْ فُو؞ ");
INSERT INTO fuv_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","ٻٜ مبِعِ يٜىٰسُ، ‏«‏مٛودِبّٛ، اٛعٛ دٜبّٛ نَنْغَامَ اٜ مٛ وَطَ نجٜىٰنُ؞ ");
INSERT INTO fuv_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","ندٜرْ اَتَّوْرَ مُوسَ وِعِيعٜنْ کُبٛرٛوطٜنْ اِرِ دٜبّٛ اٛعٛ کَاپٜ مبَرٜنْمٛ؞ جٛونِ اَنْ، طُمٜ مبِيطَا؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","ٻٜ پَمُمٛ پَمٛلْ نغٛعٛلْ نغَمْ ٻٜ ڤٛوندَمٛ ٻٜ کٜٻَ کٛ ٻٜ نغُلّٛرْتٛومٛ؞ اَمَّا يٜىٰسُ تُرِي فُطِّ وِنْدِرْکِ حٛوندُ مُوطُمْ اٜ لٜيْدِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","ندٜ ٻٜ نغَطِ کَ پَمُکِمٛ، سٜيْ اٛ اُمِّي، اٛ دَرِي، اٛ وِعِٻٜ، ‏«‏فُو مٛ مٜىٰطَايِ وَطُکِ حَکّٜ ندٜرْ مٛوطٛنْ اَرْتَ حُبَاکِ دٜبّٛ اٛعٛ حَيْرٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","سٜيْ اٛ فُطِّتِ اٛ تُرِي، اٛ وِنْدِ اٜ لٜيْدِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","ندٜ ٻٜ نَنِ کٛ اٛ وِعِ، ٻٜ ندِلِّ غٛعٛتٛ‑غٛعٛتٛ، ندٛتِّعٜنْ اَرْتِ دِلُّکِ؞ طُمْ اَلِ يٜىٰسُ طٛنْ کَنُمْ تَنْ، دٜبّٛ اٛنْ اٜ دَرِي يٜىٰسٛ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","يٜىٰسُ اُمِّي، دَرِي، وِعِمٛ، ‏«‏تٛ ٻٜ نغٛنِ؟ اٜ وٛودِ تَپَنْطٛمَ کِيتَ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","دٜبّٛ اٛنْ نٛوتِي وِعِ، ‏«‏مٛودِبّٛ، وَلَا کٛو غٛعٛتٛ؞»‏ يٜىٰسُ وِعِمٛ، ‏«‏تٛو، مِنْ مَا مِ تَپَنْتَامَ کِيتَ؞ دِلُّ، اَمَّا تَاع فُطُّتُ نغَطَا حَکّٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","يٜىٰسُ فُطِّتِ مٜتَنِ يِمْٻٜ وِعِ، ‏«‏مِنْ وٛنِ جَيْنغٛلْ دُونِيَارُ؞ فُو تٛکُّطٛيَمْ يَحَتَا ندٜرْ ݧِوْرٜ، اَمَّا حٜٻَيْ جَيْنغٛلْ يٛنْکِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","سٜيْ فَارِسَنْکٛعٜنْ مبِعِمٛ، ‏«‏اَ حٛکَّ شٜيْدَ حٛورٜ مَاطَ، کٛ مبِعَتَا نَاع طُمْ غٛونغَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","يٜىٰسُ وِعِٻٜ، ‏«‏کٛو تٛ مِ حٛکِّي شٜيْدَ حٛورٜ اَمْ، کٛ مبِعَيْمِ طُمْ غٛونغَ، نغَمْ اٜ مِ اَنْدِ تٛ پِوٛيْمِ اٜ تٛ نجَحَيْمِ؞ اَمَّا اٛنٛنْ اٛنْ اَنْدَا تٛ پِوٛيْمِ اٜ تٛ نجَحَيْمِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","اٛنْ نغَطَ کِيتَ نٛ يِمْٻٜ دُونِيَارُ نغَطِرْتَ کِيتَ، مِنْ بٛو وَلَا مٛ نغَطَنْمِ کِيتَ؞ ");
INSERT INTO fuv_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","اَمَّا فُو اٜ نٛنْ تٛ مِ وَطِي کِيتَ، کِيتَ اَمْ طُمْ غٛونغَ، نغَمْ نَاع مِنْ تَنْ وَطَتَ کِيتَ کَنْ، اَمَّا مِنْ اٜ ݧَاکٛ اَمْ لِلٛيْطٛيَمْ وَطَتَکَ؞ ");
INSERT INTO fuv_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","ندٜرْ اَتَّوْرَ مٛوطٛنْ طُمْ وِنْدِ وِيکِي شٜيْدَ کَ يِمْٻٜ طِطٛ کٛکِّ اٜ کَ وٛودِ غٛونغَ؞ ");
INSERT INTO fuv_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","اٜ مِ حٛکَّ شٜيْدَ حٛورٜ اَمْ، ندٜنْ ݧَاکٛ اَمْ لِلٛيْطٛيَمْ مَا اٜ حٛکَّ شٜيْدَ اَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","ٻٜ مبِعِمٛ، ‏«‏تٛيٜ ݧَاکٛ مَاطَ اٛنْ وٛنِ؟»‏ يٜىٰسُ وِعِٻٜ، ‏«‏اٛنْ اَنْدَايَمْ، اٛنْ بٛو اَنْدَا ݧَاکٛ اَمْ؞ دَا اٛنْ اَنْدِيَمْ، دَا اٛنْ اَنْدِ ݧَاکٛ اَمْ مَا؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","يٜىٰسُ مٜتِي حَالَ کَعَ شَرٜلْ کٛ اٛ اٜکِّتِنْتَ ندٜرْ وُرٛ شٜنِينغٛ حَادٜ اَکْوَاتِيجِ تٛ طُمْ رٜسَتَ دٛکّٜ نغَمْ اَللَّه؞ اَمَّا وَلَا نَنْغُطٛمٛ نغَمْ شَرٜلْ مَاکٛ وَطَايِ تَوْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","سٜيْ يٜىٰسُ فُطِّتِ وِعِ يِمْٻٜ ٻٜنْ، ‏«‏مِ دِلَّيْ، اٛنْ طَٻِّتَيْيَمْ، اَمَّا اٛنْ مَايَيْ ندٜرْ حَکّٜ مٛوطٛنْ؞ تٛ نجَحَيْمِ بٛو، اٛنْ مبَاوَتَا يَاکِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","طُعُمْ وَطِ اَرْدِيٻٜ يَحُودَنْکٛعٜنْ مبِعِ، ‏«‏اٛ وَرَيْ حٛورٜ مَاکٛ وٛنْ طٛنْ؟ کٛو کَنْجُمْ اٛ يِطِ وِيکِ ندٜ اٛ وِعِ، ‏‹‏تٛ نجَحَيْمِ اٛنْ مبَاوَتَا يَاکِ؟›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","اَمَّا يٜىٰسُ وِعِٻٜ، ‏«‏اٛنٛنْ دَغَ دُونِيَارُ ندُعُ پِوٛيْطٛنْ، مِنْ بٛو دَغَ دٛوْ پِوٛيْمِ؞ اٛنٛنْ دُونِيَارُ جٜيِعٛنْ، مِنْ نَاع دُونِيَارُ جٜيِيَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","مِ وِعِيعٛنْ اٛنْ مَايَيْ ندٜرْ حَکّٜ مٛوطٛنْ، غٛونغَ اٛنْ مَايَيْ ندٜرْ حَکّٜ مٛوطٛنْ سٜيْ نِ تٛ اٛنْ نجَٻِي مِنْ وٛنِ مٛ مبِيمِعٛنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","ٻٜ مبِعِمٛ، ‏«‏اَنْ اَ مٛيٜ؟»‏ يٜىٰسُ وِعِٻٜ، ‏«‏مِنْ وٛنِ اٛنْ طٛنْ مٛ مبِيمِعٛنْ دَغَ اَرَنْدٜ؞ ");
INSERT INTO fuv_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","اٜ وٛودِ فِي طُطُّمْ طُمْ نغِطُمِ وِيکِ دٛوْ مٛوطٛنْ، کَدِنْ اٜ وٛودِ فِي طُطُّمْ طُمْ نغِطُمِ تَپَنْکِعٛنْ کِيتَ دٛوْ مَاجُمْ؞ اَمَّا اٛنْ طٛنْ لِلٛيْطٛيَمْ اٜ وٛودِ غٛونغَ؞ کٛ نَنْمِ تٛ مَاکٛ تَنْ مبِعَيْمِ دُونِيَارُ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","ٻٜ ڤَامَايِ يٜىٰسُ اٜ مٜتَنَٻٜ دٛوْ ݧَاکٛ مٛ دٛوْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","سٜيْ يٜىٰسُ وِعِ، ‏«‏شَرٜلْ نغٜلْ پٜفْتُطٛنْ ٻِي نٜطّٛ، اٛنْ اَنْدَيْ مِنْ وٛنِ اٛنْ طٛنْ مٛ مبِعَيْمِ؞ کَدِنْ اٛنْ اَنْدَيْ فُو کٛ نغَطَيْمِ نَاع اٜ لَامُ اَمْ نغَطِرَيْمِطُمْ، اَمَّا کٛ ݧَاکٛ اَمْ اٜکِّتِنِيَمْ مبِعَيْمِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","اٛنْ طٛنْ لِلٛيْطٛيَمْ اٜ وٛنْدِ اٜ اَمْ، اٛ اَلَايِيَمْ مِنْ تَنْ، نغَمْ کٛو ندٜيٜ اٜ مِ وَطَ کٛ وٜلْنَنْتَمٛ ٻٜرْندٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","شَرٜلْ نغٜلْ يٜىٰسُ وِعَتَ نٛنْ، طُطْٻٜ کٛولِيمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","سٜيْ يٜىٰسُ وِعِ يَحُودَنْکٛعٜنْ کٛولِيٻٜمٛ، ‏«‏تٛ اٛنْ تٛکِّي اٜکِّتِنٛلْ اَمْ، اٛنْ تٛکُّٻٜيَمْ ٻٜ غٛونغَ؞ ");
INSERT INTO fuv_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","ندٜنْ اٛنْ اَنْدَيْ غٛونغَ، غٛونغَ بٛو رِمْطِنَيْعٛنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","ٻٜ مبِعِمٛ، ‏«‏مِنْ تَانِرَاٻٜ اِبْرَاهِمْ، مِنْ مٜىٰطَايِ وَرْتُکِ مَشُّٻٜ غٛطّٛ؞ نٛ وَطَتَ مبِعَا، ‏‹‏طُمْ رِمْطِنَيْمِنْ؟›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","يٜىٰسُ وِعِٻٜ، ‏«‏اٜ مِ وِعَعٛنْ غٛونغَ، کٛو مٛيٜ غَطٛووٛ حَکّٜ اٛ مَشُّطٛ حَکّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","مَشُّطٛ جٛوطَتَاکٛ ندٜرْ وُرٛ حَا اَبَدَا، اَمَّا ٻِطّٛ وٛنِ جٛوطٛتٛوطٛ ندٜرْ مَاغٛ حَا اَبَدَا؞ ");
INSERT INTO fuv_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","نغَمْ نٛنْ تٛ ٻِطّٛ اٛنْ رِمْطِنِيعٛنْ، اٛنْ کٜٻِي رِمْطِنٜىٰکِ کِ غٛونغَ؞ ");
INSERT INTO fuv_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","اٜ مِ اَنْدِ اٛنْ تَانِرَاٻٜ اِبْرَاهِمْ، فُو اٜ نٛنْ اٛنْ طَٻِّتَ وَرْکِيَمْ، نغَمْ اٛنْ نجَٻَايِ اٜکِّتِنٛلْ اَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","اٜ مِ وِعَعٛنْ کٛ نغِيمِ تٛ ݧَاکٛ اَمْ، اٛنٛنْ بٛو اٛنْ نغَطَ کٛ نَنْطٛنْ دَغَ تٛ ݧَاکٛ مٛوطٛنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","ٻٜ مبِعِمٛ، ‏«‏اِبْرَاهِمْ وٛنِ ݧَاکٛ اَمِنْ؞»‏ يٜىٰسُ وِعِٻٜ، ‏«‏دَا اٛنْ ٻِٻّٜ اِبْرَاهِمْ، اٛنْ نغَطَيْ کٛ اِبْرَاهِمْ وَطِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","اَمَّا جٛونِ اٛنْ طَٻِّتَ وَرْکِيَمْ، مِنْ بِيطٛعٛنْ غٛونغَ کَ نَنْمِ دَغَ تٛ اَللَّه؞ طُعُمْ نَاع کَنْجُمْ اِبْرَاهِمْ وَطِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","اٛنْ نغَطَ کٛ ݧَاکٛ مٛوطٛنْ وَطِ؞»‏ ٻٜ مبِعِمٛ، ‏«‏مِنٛنْ نَاع مِنْ جَالُعٜنْ، اَللَّه وٛنِ ݧَاکٛ اَمِنْ، کَنْکٛ تَنْ وٛنِ ݧَاکٛ مٛ مِنْ نغٛودِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","يٜىٰسُ وِعِٻٜ، ‏«‏دَا اَللَّه وٛنِ ݧَاکٛ مٛوطٛنْ، دَا اٛنْ نغِطَيْيَمْ، نغَمْ دَغَ تٛ مَاکٛ پِوٛيْمِ، جٛونِ بٛو اٜ مِ طٛعٛ؞ مِ وَرَايِ نغَمْ حٛورٜ اَمْ، اَمَّا کَنْکٛ لِلٛيِيَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","نغَمْ طُمٜ اٛنْ ڤَامَايِ کٛ مبِيمِ؟ کَنْجُمْ وٛنِ نغَمْ اٛنْ مبَاوَتَا جَٻُکِ وٛلْدٜ اَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","اٛنٛنْ اٛنْ ٻِٻّٜ ݧَاکٛ مٛوطٛنْ شٜيْطَنْ، کٛ نغِطّٛنْ وٛنِ نغَطٛنْ کٛ ݧَاکٛ مٛوطٛنْ يِطِ؞ دَغَ اَرَنْدٜ اٛ غَطٛووٛ وَرْحٛورٜ؞ وَلَا کٛ وَنِّمٛ اٜ غٛونغَ، نغَمْ اٛ وَلَا غٛونغَ؞ تٛ اٛ فٜوِي، طُمْ نغِکُّ مَاکٛ، نغَمْ اٛ ڤٜوٛووٛ، ݧَاکٛ فٜوْرٜ؞ ");
INSERT INTO fuv_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","اَمَّا نغَمْ مِ وِعِ غٛونغَ، اٛنْ کٛولَاکِيَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","مٛيٜ ندٜرْ مٛوطٛنْ وَاوَتَ تَبِّتِنْکِ مِ وَطِي حَکّٜ؟ تٛ نِ غٛونغَ مبِعَيْمِ، نغَمْ طُمٜ اٛنْ کٛولَتَاکٛيَمْ؟ ");
INSERT INTO fuv_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","کٛو مٛيٜ مٛ اَللَّه جٜيِ اٜ نَنَ کٛ اَللَّه وِعِ؞ کٛ حَطِعٛنْ نَنْکِ کٛ مبِيمِ وٛنِ اٛنٛنْ نَاع طُمْ ٻٜ اَللَّه؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","مَوْٻٜ يَحُودَنْکٛعٜنْ نٛوتِي مبِعِمٛ، ‏«‏نَاع طُمْ غٛونغَ مِنْ مبِعِ ندٜ مِنْ مبِعِ اَ سَمَارِيَنْکٜىٰجٛ ندٜنْ اَ وٛودِ غِنّٛلْ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","يٜىٰسُ وِعِٻٜ، ‏«‏مِ وَلَا غِنّٛلْ، اَمَّا ݧَاکٛ اَمْ کٛکَّيْمِ مَنْغُ، اٛنٛنْ بٛو اٛنْ نجَوَنَيَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","مِ طَٻِّتَنْتَا حٛورٜ اَمْ تٜدُّنغَلْ، اَمَّا اٜ وٛودِ غٛطّٛ طَٻِّتَنَيْطٛيَمْنغَلْ، کَنْکٛ وٛنِ غَطَيْطٛ کِيتَ؞ ");
INSERT INTO fuv_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","اٜ مِ وِعَعٛنْ غٛونغَ، فُو غَطٛووٛ کٛ مبِيمِ، اٛ مَايَتَا؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","يَحُودَنْکٛعٜنْ مبِعِمٛ، ‏«‏جٛونِ اٜ مِنْ اَنْدِ اَ وٛودِ غِنّٛلْ؞ اِبْرَاهِمْ مَايِي، نٛنْ مَا اَنَّبٛعٜنْ، اَمَّا اَ وِعِي فُو غَطٛووٛ کٛ مبِيطَا مَايَتَا؞ ");
INSERT INTO fuv_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","اَ ٻُرِي ݧَاکٛ اَمِنْ اِبْرَاهِمْ؟ اٛ مَايِي، نٛنْ مَا اَنَّبٛعٜنْ حٛرِيٻٜ مَايِي؞ مٛيٜ ݧُمَتَا غٛنْطَا؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","يٜىٰسُ نٛوتِي وِعِ، ‏«‏تٛ مِ تٜدِّنِي حٛورٜ اَمْ، تٜدُّنغَلْ اَمْ وَرْتِي مٜىٰرٜ؞ ݧَاکٛ اَمْ مٛ مبِعٛتٛنْ وٛنِ اَللَّه مٛوطٛنْ، کَنْکٛ وٛنِ تٜدِّنْطٛيَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","کٛو ندٜ اٛنْ اَنْدَامٛ، اَمَّا مِنْ اٜ مِ اَنْدِمٛ؞ دَا مِ وِعِينٛعٛنْ مِ اَنْدَامٛ، دَا مِ وَرْتِي ڤٜوٛووٛ بٛ مٛوطٛنْ؞ اَمَّا اٜ مِ اَنْدِمٛ، اٜ مِ تٛکَّ وٛلْدٜ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","ݧَاکٛ مٛوطٛنْ اِبْرَاهِمْ اٜ وٜلْوٜلْتَ تٛ اٛ ݧُمِي دٛوْ ݧَلْندٜ ندٜ نغَرَيْمِ؞ اٛ يِعِيندٜ، اٛ بٛو نَنِي بٜلْطُمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","ٻٜ مبِعِمٛ، ‏«‏اَ حٜوْتَايِ دُوٻِ 50 تَوْ، اَمَّا اَ وِعَ اَ يِعِي اِبْرَاهِمْ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","يٜىٰسُ وِعِٻٜ، ‏«‏اٜ مِ وِعَعٛنْ غٛونغَ، کٛ اِبْرَاهِمْ دَݧٜىٰ اٜ مِ طٛنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","ندٜ اٛ وِعِ نٛنْ، سٜيْ ٻٜ کٛشِّ کَاپٜ نغَمْ ٻٜ کُبٛومٛ، اَمَّا يٜىٰسُ سُوطِ حٛورٜ مُوطُمْ، وُرْتِي ندٜرْ وُرٛ شٜنِينغٛ نغٛنْ دِلِّ؞ ");
INSERT INTO fuv_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","يٜىٰسُ اٜ ندٜرْ يَادُ، سٜيْ اٛ يِعِ نٜطّٛ دَݧَاطٛ اٜ وُمِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","تٛکُّٻٜمٛ پَمِمٛ مبِعِ، ‏«‏مٛودِبّٛ، حَکّٜ مٛيٜ وَطِ طُمْ دَݧِ نٜطّٛ اٛعٛ اٜ وُمِ؟ طُمْ حَکّٜ مَاکٛ کٛو حَکّٜ دَݧٛوٻٜ مَاکٛ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","يٜىٰسُ وِعِ، ‏«‏نَاع نغَمْ حَکّٜ نٜطّٛ اٛعٛ کٛو نغَمْ حَکّٜ دَݧٛوٻٜ مَاکٛ وَطِ اٛ دَݧَا بُمْطٛ؞ اٛ دَݧَا اٜ مٛ وُمِ نغَمْ طُمْ حٛلَّ بَوْطٜ اَللَّه دٛوْ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","دٛولٜ کُوٜنْ کُوطٜ اٛنْ طٛنْ لِلٛيْطٛيَمْ دَغَ نَانغٜ اٜ طٛنْ؞ جٜمَّ ٻَدَکٜ؞ اٜ شَرٜلْ نغٜلْ وَلَا بَاوَيْطٛ حُوَ؞ ");
INSERT INTO fuv_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","تٛ نِ اٜ مِ دُونِيَارُ، مِنْ وٛنِ جَيْنغٛلْ دُونِيَارُ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","غَطَ يٜىٰسُ وِعِي نٛنْ، سٜيْ اٛ تُوتِ جٛودٜ اٜ لٜيْدِ، اٛ جِيٻِرِ لٜيْدِ ندِنْ اٜ مَاجٜ، اٛ حٛشِّندِ، اٛ مٛيْتَنِ نٜطّٛ اٛنْ تٛ غِتٜ؞ ");
INSERT INTO fuv_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","اٛ وِعِمٛ، ‏«‏دِلُّ، شُلْمٛطَا تٛ نجٛنْغَ بِعٜتٜىٰنغَ سِلُوَمْ؞»‏ مَعَنَ سِلُوَمْ وٛنِ ‏«‏لِلَاطٛ؞»‏ سٜيْ نٜطّٛ اٛنْ يَحِ سُلْمِي، وَرْتِ اٜ يِعَ؞ ");
INSERT INTO fuv_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","کٜدُّٻٜ اٜ مَاکٛ اٜ وٛووُٻٜ يِيکِمٛ اٜ مٛ تٛرٛو ندٜنّٛ مبِعِ، ‏«‏نَاع طُمْ نٜطّٛ اٛعٛ وٛنِ جٛوطٛتٛنٛوطٛ اٜ تٛرٛو؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","وٛٻّٜ مبِعِ، ‏«‏طُمْ کَنْکٛ؞»‏ وٛٻّٜ بٛو مبِعِ، ‏«‏نَاع طُمْ کَنْکٛ، طُمْ نَنْدُطٛ اٜ مَاکٛ؞»‏ اَمَّا نٜطّٛ اٛنْ وِعِ، ‏«‏طُمْ مِنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","ٻٜ مبِعِمٛ، ‏«‏نٛ طُمْ وَطِ جٛونِ اَ يِعَ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","اٛ وِعِٻٜ، ‏«‏نٜطّٛ بِعٜتٜىٰطٛ يٜىٰسُ جِيٻِ لٜيْدِ مٛيْتَنِيَمْ تٛ غِتٜ، وِعِيَمْ مِ يَحَ نجٛنْغَ سِلُوَمْ مِ سُلْمٛو؞ سٜيْ نجَحُمِ، شُلْمِيمِ سٜيْ مبُمْتُمِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","ٻٜ پَمِمٛ ٻٜ مبِعِ، ‏«‏تٛ نٜطّٛ اٛعٛ وٛنِ؟»‏ اٛ وِعِٻٜ، ‏«‏مِ اَنْدَا؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","سٜيْ ٻٜ نجَارِ بُمْتُطٛ اٛنْ تٛ فَارِسَنْکٛعٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","تٛو، ݧَلْندٜ ندٜ يٜىٰسُ جِيٻِ لٜيْدِ وُمْتِنِ بُمْطٛ اٛنْ طُمْ ݧَلْندٜ سِوْتَارٜ؞ ");
INSERT INTO fuv_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","فَارِسَنْکٛعٜنْ ٻٜنْ مَا ڤُطِّ پَمُکِ نٜطّٛ اٛنْ نٛ اٛ وُمْتِرِ، اٛ وِعِٻٜ، ‏«‏اٛ وَطُ لٜيْدِ تٛ غِتٜ اَمْ، شُلْمِيمِ، جٛونِ اٜ مِ يِعَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","وٛٻّٜ ندٜرْ فَارِسَنْکٛعٜنْ ٻٜنْ مبِعِ، ‏«‏نٜطّٛ غَطُطٛ فِي طُعُمْ نَاع دَغَ تٛ اَللَّه اٛ پِوٛيِ، نغَمْ اٛ تٛکَّايِ دٛوکَ ݧَلْندٜ سِوْتَارٜ؞»‏ وٛٻّٜ بٛو مبِعِ، ‏«‏نٛ وَطَتَ نٜطّٛ غَطٛووٛ حَکّٜ وَاوَ وَطُکِ اِرِ کَيْطِنِيطُمْ طُعُمْ؟»‏ نغَمْ نٛنْ، فٜىٰرٛوتِرٛلْ نَتِّ حَکُّندٜ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","نغَمْ نٛنْ، ٻٜ ڤُطِّتِ ٻٜ پَمِ نٜطّٛ اٛنْ ٻٜ مبِعِ، ‏«‏طُمٜ مبِعَتَا دٛوْ مَاکٛ، ندٜ اَنْ اٛ وُمْتِنِ؟»‏ نٜطّٛ اٛنْ وِعِ، ‏«‏اٛ اَنَّبِيجٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","اَرْدِيٻٜ يَحُودَنْکٛعٜنْ نجَٻَايِ نٜطّٛ اٛنْ ندٜنّٛ اٛ بُمْطٛ جٛونِ بٛو اٜ مٛ يِعَ، نَاکِ ٻٜ نٛدِّ دَݧٛوٻٜ مَاکٛ، ");
INSERT INTO fuv_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ٻٜ پَمِٻٜ ٻٜ مبِعِ، ‏«‏اٛعٛ طُمْ ٻِطّٛ مٛوطٛنْ مٛ مبِيطٛنْ دَݧَامَ اٜ وُمِ؟ نٛ وَطِ جٛونِ اٜ مٛ يِعَ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","دَݧٛوٻٜ نٜطّٛ اٛنْ مبِعِ، ‏«‏اٜ مِنْ اَنْدِ اٛ ٻِطّٛ اَمِنْ، کَدِنْ مَا اٛ دَݧَامَ اٜ مٛ وُمِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","اَمَّا مِنْ اَنْدَا نٛ وَطِ جٛونِ اٜ مٛ يِعَ، نٛنْ مَا مِنْ اَنْدَا مٛيٜ وُمْتِنِمٛ؞ پَمٜىٰمٛ، نَاع اٛ سُکَ، اٛ وِعَيْعٛنْ کَ اٜ حٛورٜ مَاکٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","دَݧٛوٻٜ نٜطّٛ اٛنْ مبِعِي نٛنْ نغَمْ اٜ ٻٜ کُلَ اَرْدِيٻٜ يَحُودَنْکٛعٜنْ؞ نغَمْ اَرْدِيٻٜ يَحُودَنْکٛعٜنْ ٻٜنْ نجَادَکٜ شِرْيَکٜ وِيکِ کٛو مٛيٜ بِيطٛ يٜىٰسُ وٛنِ اَلْمَسِيحُ طُمْ رِيوَيْمٛ دَغَ ندٜرْ لٜݧٛلْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","کَنْجُمْ وَطِ دَݧٛوٻٜ بُمْتِنَاطٛ اٛنْ مبِعِ، ‏«‏نَاع اٛ سُکَ، پَمٜىٰمٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","سٜيْ اَرْدِيٻٜ ٻٜنْ نٛدِّتِي بُمْتِنَاطٛ اٛنْ، ٻٜ مبِعِمٛ، ‏«‏وِعُ غٛونغَ نغَمْ تٜدِّنَا اَللَّه؞ اٜ مِنْ اَنْدِ نٜطّٛ جَمْطِتِنْطٛمَ اٛ غَطٛووٛ حَکّٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","بُمْتِنَاطٛ اٛنْ وِعِٻٜ، ‏«‏کٛو اٛ غَطٛووٛ حَکّٜ مِ اَنْدَا، فِي غٛعٛ طُمْ اَنْدُمِ وٛنِ ندٜنّٛ مِ بُمْطٛ، جٛونِ بٛو اٜ مِ يِعَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","ٻٜ مبِعِمٛ، ‏«‏طُمٜ اٛ وَطَنْمَا؟ نٛ اٛ مَٻِّتِرِ غِتٜ مَاطَ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","نٜطّٛ اٛنْ وِعِٻٜ، ‏«‏مِ يَادَکٜ مِ وِعِيعٛنْکَ اٛنْ نجَٻَايِ؞ نغَمْ طُمٜ نغِطّٛنْ نَنْکِکَ کَدِنْ؟ کٛو اٛنٛنْ مَا اٛنْ نغِطِ وَرْتُکِ تٛکُّٻٜمٛ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","سٜيْ ٻٜ کُطِمٛ ٻٜ مبِعِ، ‏«‏اَنْ وٛنِ تٛکُّطٛمٛ، اَمَّا مِنٛنْ مِنْ تٛکُّٻٜ مُوسَ!‏ ");
INSERT INTO fuv_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","اٜ مِنْ اَنْدِ اَللَّه مٜتَنِي مُوسَ، اَمَّا نٜطّٛ اٛعٛ مِنْ اَنْدَا تٛ اٛ پِوٛيِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","نٜطّٛ اٛنْ وِعِٻٜ، ‏«‏طُعُمْ طُمْ فِي کَيْطِنِيطُمْ!‏ اٛنْ اَنْدَا تٛ اٛ پِوٛيِ، اَمَّا اٛ وُمْتِنِييَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","اٜنْ اَنْدِ اَللَّه نَنَتَا دٛعَارٜ غَطٛوٻٜ حَکّٜ، اَمَّا اٜ مٛ نَنَ دٛعَارٜ کُلٛووٛمٛ غَطٛووٛ کٛ اٛ يِطِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","دَغَ دُونِيَارُ تَغَا وَلَا مٜىٰطُطٛ نَنُکِ غٛطّٛ وُمْتِنِي نٜطّٛ دَݧَاطٛ اٜ وُمِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","دَا نٜطّٛ اٛعٛ نَاع تٛ اَللَّه اٛ پِوٛيِ، دَا اٛ وَاوَتَا اٛ وَطَ غٛطُّمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","ٻٜ مبِعِمٛ، ‏«‏اَ دَݧَامَ ندٜرْ حَکّٜ اَ مَوْنِي ندٜرْ حَکّٜ، نٛ وَطَتَ اٜکِّتِنَامِنْ؟»‏ سٜيْ ٻٜ ندِيوِمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","يٜىٰسُ نَنِ ٻٜ ندِيوِي نٜطّٛ اٛنْ؞ ندٜ اٛ تَوِ نٜطّٛ اٛنْ، اٛ پَمِمٛ اٛ وِعِ، ‏«‏اَ حٛولَکٜ ٻِي نٜطّٛ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","نٜطّٛ اٛنْ وِعِ، ‏«‏مٛودِبّٛ، مٛيٜ وٛنِ ٻِي نٜطّٛ؟ وِعَمْکَ نغَمْ مِ حٛولٛومٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","يٜىٰسُ وِعِمٛ، ‏«‏اَ يِعِيمٛ، کَنْکٛ وٛنِ مٜدّٛووٛ اٜ مَاطَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","نٜطّٛ اٛنْ وِعِ، ‏«‏مٛودِبّٛ، مِ حٛولَکٜمَ؞»‏ اٛ دِشِّي يٜىٰسٛ يٜىٰسُ، اٛ مَوْنِنِمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","يٜىٰسُ وِعِ، ‏«‏مِ وَرٛيِي دُونِيَارُ ندُعُ نغَمْ وَطُکِ کِيتَ، نغَمْ وُمْٻٜ نغِعَ ندٜنْ غِعٛوٻٜ بٛو نغَرْتَ وُمْٻٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","ندٜ وٛٻّٜ فَارِسَنْکٛعٜنْ غٛنْٻٜ حَادٜ يٜىٰسُ نَنِ اٛ وِعِ طُعُمْ، ٻٜ مبِعِمٛ، ‏«‏مِنٛنْ مَا مِنْ وُمْٻٜ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","يٜىٰسُ وِعِٻٜ، ‏«‏دَا اٛنْ وُمْٻٜ، دَا اٛنْ تَپَنْتَاکٜ کِيتَ کٛو ندٜ اٛنْ نغَطِي حَکّٜ؞ اَمَّا جٛونِ ندٜ مبِعٛتٛنْ اٛنْ نغِعَ، طُمْ تَپَنَيْعٛنْ کِيتَ نغَمْ حَکّٜ مٛوطٛنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","يٜىٰسُ وِعِ، ‏«‏اٜ مِ وِعَعٛنْ غٛونغَ، کٛو مٛيٜ مٛ نَتِّرَايِ حٛغّٛ بَالِ دَمُّغَلْ، اَمَّا اٛ پٜنْتِ حٛغّٛ نغٛنْ اٛ نَتِّ، اٛ غُجّٛ اٛ تٜىٰتٛووٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","نَتِّرْطٛ حٛغّٛ بَالِ دَمُّغَلْ مَاغٛ، کَنْکٛ وٛنِ غَيْنَاکٛ بَالِ طِنْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","دٜىٰنٛووٛ دَمُّغَلْ حٛغّٛ نغٛنْ مَٻِّتَنَيْمٛ دَمُّغَلْ، بَالِ طِنْ بٛو اٜ اَنْدِ حٛنٛنْدٜ مَاکٛ؞ اٜ مٛ نٛدِّرَطِ اِنْطٜ مَاجِ، اٛ اَرْدٛوطِ طِ مبُرْتٛو؞ ");
INSERT INTO fuv_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","تٛ اٛ وُرْتِنِي فُو بَالِ مَاکٛ، اٛ اَرْدٛتٛطِ، طِ تٛکَّيْمٛ، نغَمْ اٜ طِ اَنْدِ حٛنٛنْدٜ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","اَمَّا طِ تٛکَّتَا کٛطٛ، طِ ندٛغَّيْمٛ، نغَمْ طِ اَنْدَا حٛنٛنْدٜ کٛطٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","يٜىٰسُ حٛکِّ يِمْٻٜ مِسَالُ طُعُمْ، اَمَّا ٻٜ ڤَامَايِ کٛ اٛ وِعَتَٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","نغَمْ نٛنْ يٜىٰسُ فُطِّتِ وِعِٻٜ، ‏«‏اٜ مِ وِعَعٛنْ غٛونغَ، مِنْ وٛنِ دَمُّغَلْ بَالِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","فُو اَرْتُٻٜيَمْ وَرْکِ ٻٜ وُيْٻٜ ٻٜ تٜىٰتٛوٻٜ، بَالِ طِنْ بٛو کٜتِّندَنَاکِٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","مِنْ وٛنِ دَمُّغَلْ؞ فُو تٛکِّرْطٛ تٛ اَمْ نَتِّ حِسَيْ، اٛ نَتَّيْ، اٛ وُرْتٛو، اٛ حٜٻَ کٛ اٛ مَرٛرْتٛو؞ ");
INSERT INTO fuv_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","غُجّٛ وَرَيْ تَنْ نغَمْ وُجَّ، وَطَ وَرْحٛورٜ، حَلْکَ؞ مِنْ بٛو مِ وَرٛيِ نغَمْ تٛکِّرْٻٜ تٛ اَمْ کٜٻَ يٛنْکِ، ٻٜ کٜٻَکِ کٜىٰوُکِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","‏«‏مِنْ وٛنِ غَيْنَاکٛ بٛطّٛ؞ غَيْنَاکٛ بٛطّٛ اٜ حٛکَّ يٛنْکِ مُوطُمْ نغَمْ بَالِ مُوطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","نٜطّٛ کٛشَّاطٛ دُرْنغٛلْ نَاع اٛ جٜيْطٛ بَالِ طِنْ؞ تٛ اٛ يِعِي شَافَاندُ اٜ وَرَ، اٛ اَلَيْ بَالِ طِنْ اٛ دٛغَّ؞ شَافَاندُ ندُنْ نَنْغَطِ سَنْکِتَطِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","اٛ دٛغَّيْ نغَمْ اٛ کٛشَّاطٛ دُرْنغٛلْ، وَلَا کٛ وَنِّمٛ اٜ بَالِ طِنْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","مِنْ وٛنِ غَيْنَاکٛ بٛطّٛ؞ اٜ مِ اَنْدِ بَالِ اَمْ، ندٜنْ بَالِ اَمْ اٜ اَنْدِيَمْ، ");
INSERT INTO fuv_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","نٛنْ نٛ ݧَاکٛ اَمْ اَنْدِرِيَمْ، اٜ نٛ اَنْدِرْمٛومِ؞ مِ حٛکِّي يٛنْکِ اَمْ نغَمْ بَالِ طِنْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","اٜ مِ وٛودِ غٛطِّ بَالِ طِ نغَلَا ندٜرْ حٛغّٛ نغٛعٛ؞ دٛولٜ مِ وَدَّطِ کَنْجِ مَا؞ طِ کٜتِّندَنْتٛ حٛنٛنْدٜ اَمْ؞ نغَمْ نٛنْ طِ نغَرْتَيْ اٛرْندٜ غٛعٛ، غَيْنَاکٛ غٛعٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","‏«‏کٛ وَطِ ݧَاکٛ اَمْ مٛ دٛوْ اٜ يِطِيَمْ، کَنْجُمْ وٛنِ مِ حٛکَّيْ يٛنْکِ اَمْ، نغَمْ مِ فُطِّتَ مِ حٛشَّکِ کَدِنْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","وَلَا اِتَّنٛووٛيَمْ يٛنْکِ؞ مِنْ اٜ حٛورٜ اَمْ حٛکَّتَکِ؞ اٜ مِ وٛودِ بَوْطٜ حٛکُّکِکِ، ندٜنْ اٜ مِ وٛودِ بَوْطٜ مِ وَرْتِرَکِ؞ طُعُمْ کَنْجُمْ ݧَاکٛ اَمْ وِعِيَمْ مِ وَطَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","سٜيْ فٜىٰرٛوتِرٛلْ فُطِّتِ نَتِّ حَکُّندٜ يَحُودَنْکٛعٜنْ نغَمْ حَالَ کَعَ؞ ");
INSERT INTO fuv_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","طُطْٻٜ ندٜرْ مَٻّٜ مبِعِ، ‏«‏اٜ مٛ وٛودِ غِنّٛلْ، اٛ کَاݝَاطٛ؞ نغَمْ طُمٜ کٜتِّندَنْتٛوطٛنْمٛ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","وٛٻّٜ بٛو مبِعِ، ‏«‏کَعَ حَالَ نَاع طُمْ کَ نٜطّٛ غٛودُطٛ غِنّٛلْ؞ نٛ وَطَتَ غِنّٛلْ وَاوَ وُمْتِنْکِ بُمْطٛ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","تٛو، طُمْ شَرٜلْ ڤٜىٰوٛلْ، اٜ طُمْ وَطَ حُمْتٛ لَاٻِنْکِ وُرٛ شٜنِينغٛ ندٜرْ اُرُشَلِيمَ؞ ");
INSERT INTO fuv_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","يٜىٰسُ اٜ وٛوسٛو ندٜرْ رُمْڤَارُ سُلٜيْمَانُ ندٜرْ وُرٛ شٜنِينغٛ نغٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","سٜيْ يَحُودَنْکٛعٜنْ کَوْرِتِ ڤِلِيمٛ مبِعِمٛ، ‏«‏حَا ندٜيٜ اَلَتَامِنْ ندٜرْ سٜکٛ؟ تٛ اَنْ وٛنِ اَلْمَسِيحُ وِعُمِنْکَ اٜ نجَيْرِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","يٜىٰسُ وِعِٻٜ، ‏«‏مِ وِعِيعٛنْکَ، اَمَّا اٛنْ کٛولَاکِيَمْ؞ کُوطٜ کَيْطِنِيطٜ طٜ نغَطَيْمِ ندٜرْ اِنْدٜ ݧَاکٛ اَمْ، اٜ طٜ کٛلَّ مِنْ طُمْ مٛيٜ، ");
INSERT INTO fuv_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","اَمَّا اٛنْ کٛولَاکِيَمْ، نغَمْ اٛنٛنْ نَاع اٛنْ بَالِ اَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","بَالِ اَمْ اٜ کٜتِّندَنٛويَمْ؞ اٜ مِ اَنْدِطِ، ندٜنْ اٜ طِ تٛکَّيَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","مِ حٛکِّيطِ يٛنْکِ کِ رٜعَتَا، طِ کَلْکَتَا حَا اَبَدَا، ندٜنْ وَلَا تٜىٰتَيْطٛطِ دَغَ جُنْغٛ اَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","ݧَاکٛ اَمْ کٛکُّطٛيَمْ بَالِ طِنْ، اٛ ٻُرِي کٛو طُمٜ بَوْطٜ، ندٜنْ وَلَا بَاوَيْطٛ تٜىٰتَطِ دَغَ جُنْغٛ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","مِنْ اٜ ݧَاکٛ مٛ دٛوْ مِنْ غٛعٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","سٜيْ يَحُودَنْکٛعٜنْ ڤُطِّتِ کٛشِّ کَاپٜ نغَمْ کُبٛومٛ مبَرَمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","يٜىٰسُ وِعِٻٜ، ‏«‏مِ حٛلِّيعٛنْ کُوطٜ بٛطّٜ طُطّٜ طٜ ݧَاکٛ مٛ دٛوْ حٛکِّيَمْ مِ وَطَ؞ نغَمْ نغَلٜ ندٜرْ مَاجٜ نغِطّٛنْ حُبٛرَاکِيَمْ کَاپٜ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","ٻٜ مبِعِ يٜىٰسُ، ‏«‏نَاع نغَمْ کُوطٜ بٛطّٜ طٜ نغَطُطَا مِنْ کُبٛتٛمَا، اَمَّا نغَمْ حُطُکِ اَللَّه؞ نغَمْ اَنْ اَ نٜطّٛ تَنْ، اَمَّا اَ وَرْتِرَ حٛورٜ مَاطَ اَللَّه؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","يٜىٰسُ وِعِٻٜ، ‏«‏نَاع طُمْ وِنْدَامَ ندٜرْ اَتَّوْرَ مٛوطٛنْ، ‏‹‏مِ وِعِيعٛنْ، اٛنٛنْ اٛنْ اَلَّاجِ؟›‏ ");
INSERT INTO fuv_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","دٜفْتٜرٜ شٜنِيندٜ طُمْ غٛونغَ حَا اَبَدَا، ندٜنْ اَللَّه نٛدِّرِي نَنْٻٜ وٛلْدٜ مُوطُمْ اَلَّاجِ، يِمْٻٜ کٛکَّاٻٜ وٛلْدٜ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","تٛ طُمْ نٛنْ، مِنْ مٛ ݧَاکٛ مٛ دٛوْ سُٻِ نغَمْ کُوغَلْ مَاکٛ لِلٛيِيَمْ ندٜرْ دُونِيَارُ، مِ حُطِي اَللَّه وٛنْ طٛنْ ندٜ مبِيمِ، ‏‹‏مِنْ مِ ٻِطّٛ اَللَّه؟›‏ ");
INSERT INTO fuv_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","تٛ نَاع کُوطٜ ݧَاکٛ اَمْ نغَطَيْمِ، تٛع اٛنْ کٛولَيَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","اَمَّا تٛ اٜ مِ وَطَ کُوطٜ مَاکٛ، کٛو تٛ اٛنْ کٛولَاکِيَمْ، کٛولٜىٰ کُوطٜ طٜنْ، نغَمْ اَنْدٛنْ ڤَامٛنْ ݧَاکٛ مٛ دٛوْ اٜ ندٜرْ اَمْ، مِنْ مَا اٜ مِ ندٜرْ مَاکٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","ٻٜ ڤُطِّتِ ٻٜ ندَرْوِ نَنْغُکِمٛ، اَمَّا اٛ وُرْتِي جُوطٜ مَٻّٜ اٛ دَطِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","سٜيْ يٜىٰسُ دِلِّ حُولِ شَانغٛلْ اُرْدُنْ، وِغٜىٰرٜ تٛ يَحَيَ وَطَيْنٛ بَڤْتِسْمَ، اٛ جٛوطِي طٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","يِمْٻٜ طُطْٻٜ نغَرِ تٛ مَاکٛ، اٜ ٻٜ مبِعَ، ‏«‏يَحَيَ وَطَايِ غٛطُّمْ کَيْطِنِيطُمْ، اَمَّا کٛو طُمٜ طُمْ اٛ وِعِ دٛوْ نٜطّٛ اٛعٛ طُمْ غٛونغَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","يِمْٻٜ طُطْٻٜ کٛولِي يٜىٰسُ طٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","غٛطّٛ نٜطّٛ بِعٜتٜىٰطٛ لِعَاجَرُ شِيَ نجَمُ نَنْغِمٛ؞ غَرِيرِ بٜتَنِ اٛ جٛوطٛتٛو، غَرِيرِ ندِ مَرْيَامَ اٜ مَوْنِرَاوٛ مُوطُمْ مَرْتَ نجٛوطٛتٛو؞ ");
INSERT INTO fuv_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","مَرْيَامَ اٛعٛ، کَنْکٛ وَيْلَنِ کٛيْطٜ يٜىٰسُ نٜبَّمْ اُرٛوجَمْ اٛ مٛيْتِرِطٜ غَاسَ حٛورٜ مَاکٛ؞ لِعَاجَرُ مٛ يَمْطَا اٛنْ، اٛ سَکِرَاوٛ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","سٜيْ مَرْيَامَ اٜ سَکِرَاوٛ مُوطُمْ مَرْتَ ٻٜ لِلَنِ يٜىٰسُ ٻٜ مبِعِ، ‏«‏مٛودِبّٛ، حِغٛ مَاطَ مٛ نغِطَّا يَمْطَا؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","اَمَّا ندٜ يٜىٰسُ نَنِ نٛنْ، اٛ وِعِ، ‏«‏طُعُمْ ݧَوُ طُمْ نَنْغُ لِعَاجَرُ نَاع نغَمْ اٛ مَايَ، اٛ ݧَوُ نغَمْ طُمْ تٜدِّنَ اَللَّه، طُمْ وَرْتَ لَاوٛلْ نٛ ٻِطّٛ اَللَّه تٜدِّنِرْتٜىٰ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","يٜىٰسُ اٜ يِطِ مَرْتَ اٜ مَرْيَامَ اٜ لِعَاجَرُ؞ ");
INSERT INTO fuv_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","فُو اٜ نٛنْ ندٜ اٛ نَنِ لِعَاجَرُ يَمْطَا، سٜيْ اٛ ٻٜيْدِ وَطُکِ بَلْطٜ طِطِ تٛ اٛ وٛنِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","غَطَ مَاجُمْ اٛ وِعِ تٛکُّٻٜمٛ، ‏«‏اٜنْ شٛعّٛ لٜيْدِ يَحُودِيَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","تٛکُّٻٜمٛ مبِعِمٛ، ‏«‏مٛودِبّٛ، نَاع کٛ نٜىٰٻِ يَحُودَنْکٛعٜنْ اٜ نغِطُنٛو حُبٛرَاکِمَ کَاپٜ مبَرُمَا، فُو اٜ نٛنْ اَ يِطِ سٛعَّاکِ تٛنْ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","يٜىٰسُ وِعِٻٜ، ‏«‏نَاع ݧَلْندٜ غٛعٛ اٜ وٛودِ اَوَاجِ سَڤّٛ اٜ طِطِ؟ کٛو مٛيٜ جَحٛووٛ ݧَلَوْمَ فٜغَّتَاکٛ نغَمْ اٜ مٛ يِعِرَ جَيْنغٛلْ دُونِيَارُ ندُعُ؞ ");
INSERT INTO fuv_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","اَمَّا فُو جَحٛووٛ ندٜرْ ݧِوْرٜ اٛ فٜغّٛتٛ، نغَمْ اٛ وَلَا جَيْنغٛلْ ندٜرْ مَاکٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","غَطَ يٜىٰسُ وِعِي نٛنْ، سٜيْ اٛ ٻٜيْدِ وِيکِ، ‏«‏حِغٛ مٜىٰطٜنْ لِعَاجَرُ طَانَکٜ، اَمَّا مِ يَحَيْ مِ فِنْدِنَمٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","تٛکُّٻٜمٛ مبِعِمٛ، ‏«‏مٛودِبّٛ، تٛ نِ اٛ طَانِ، اٛ يَمْطِتَيْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","کٛ يٜىٰسُ وِعَتَ وٛنِ لِعَاجَرُ مَايِي، اَمَّا کَمْٻٜ اٜ ٻٜ ݧُمَ کٛ يٜىٰسُ وِعَتَ وٛنِ اٜ مٛ طَانِي نغَمْ اٛ سِوْتٛو؞ ");
INSERT INTO fuv_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","سٜيْ يٜىٰسُ وِعِٻٜ اٜ نجَيْرِ، ‏«‏لِعَاجَرُ مَايِي؞ ");
INSERT INTO fuv_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","اَمَّا مِ نَنِي بٜلْطُمْ مِ وَلَا تٛنْ، نغَمْ کٛولٛوطٛنْيَمْ؞ اَمَّا اٜنْ نجَحُ تٛ مَاکٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","سٜيْ تٛومَ بِعٜتٜىٰطٛ شِوْتَاطٛ وِعِ تٛکُّٻٜ يٜىٰسُ حٛرِيٻٜ، ‏«‏اٜنْ نجَحُ اٜنٜنْ مَا نغَمْ مَيْدٜنْ اٜ مَاکٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","ندٜ يٜىٰسُ يٛتِّي تَوِ طُمْ يَادَکٜ طُمْ اُوِي لِعَاجَرُ بَلْطٜ نَيِ پَٻِّيطٜ؞ ");
INSERT INTO fuv_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","حَکُّندٜ بٜتَنِ اٜ اُرُشَلِيمَ حٜوْتَايِ مِلْ طِطِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","يَحُودَنْکٛعٜنْ طُطْٻٜ نغَرِ تٛ مَرْتَ اٜ مَرْيَامَ نغَمْ ٻٜ مبَلْتِنَنَٻٜ ٻٜرْطٜ دٛوْ مَيْدٜ سَکِرَاوٛ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","ندٜ مَرْتَ نَنِ يٜىٰسُ اٜ وَرَ، اٛ يَحِ نغَمْ اٛ تَٻّٛيٛومٛ، مَرْيَامَ بٛو جٛوطِي تٛ وُرٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","مَرْتَ تَٻِّي يٜىٰسُ وِعِمٛ، ‏«‏مٛودِبّٛ، دَا اَ طٛنّٛ طٛعٛ، دَا سَکِرَاوٛ اَمْ مَايَايِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","اَمَّا اٜ مِ اَنْدِ کٛو جٛونِ فُو کٛ تٛرِطَا اَللَّه اٛ حٛکّٜتٜطُمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","يٜىٰسُ وِعِمٛ، ‏«‏سَکِرَاوٛ مَاطَ اُمّٛتٛ کَدِنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","مَرْتَ وِعِمٛ، ‏«‏اٜ مِ اَنْدِ اٛ اُمّٛتٛ ݧَلْندٜ جَانغٛ ݧَلْندٜ ندٜ مَيْٻٜ اُمّٛتٛو؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","يٜىٰسُ وِعِمٛ، ‏«‏مِنْ وٛنِ اُمِّنَيْطٛ مَيْٻٜ، مِنْ وٛنِ کٛکَّيْطٛ يٛنْکِ؞ کٛو مٛيٜ کٛولِيطٛيَمْ، کٛو اٛ مَايِي، اٛ فُطِّتَيْ اٛ وَطَ يٛنْکِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","کٛو مٛيٜ غٛودُطٛ يٛنْکِ کٛولِيطٛيَمْ، تٛ اٛ مَايِي اٛ حَلْکَتَا؞ اَ جَٻِي کٛ مبِيمِ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","مَرْتَ وِعِمٛ، ‏«‏اٜىٰ، مٛودِبّٛ، مِ جَٻِي اَنْ وٛنِ اَلْمَسِيحُ، ٻِطّٛ اَللَّه، مٛ طُمْ وِعِ وَرَيْ ندٜرْ دُونِيَارُ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","غَطَ مَرْتَ وِعِي نٛنْ، اٛ يَحِ اٛ نٛدِّ مِݧِرَاوٛ مَاکٛ مَرْيَامَ ٻٜ کَکِّتِ اٛ وِعِمٛ، ‏«‏مٛودِبّٛ اٜ طٛعٛ اٜ مٛ يِطِ يِيکِمَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","ندٜ مَرْيَامَ نَنِ نٛنْ، اُمِّي ندٜرْ يَوْطَارٜ يَحِ تٛ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","يٜىٰسُ بٛو يٛتَّاکِ غَرِيرِ بٜتَنِ تَوْ، اَمَّا اٜ مٛ طٛنْ اٜ وِغٜىٰرٜ تٛ مَرْتَ تَوِمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","يَحُودَنْکٛعٜنْ غٛنْدُٻٜ اٜ مَرْيَامَ ندٜرْ وُرٛ نغَمْ حِنُّکِ، ندٜ ٻٜ نغِعِ مَرْيَامَ اُمَّکٜ جَوْطُمْ وُرْتَکٜ، سٜيْ ٻٜ تٛکِّمٛ، اٜ ٻٜ کَمّٛو اٛ يَحَيْ يٜنَاندٜ اٛ وٛيَ تٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","ندٜ مَرْيَامَ يٛتِّي تٛ يٜىٰسُ وٛنِ يِعِمٛ، دِشِّ، وِعِمٛ، ‏«‏مٛودِبّٛ، دَا اَ طٛعٛ، دَا سَکِرَاوٛ اَمْ مَايَايِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","ندٜ يٜىٰسُ يِعِ اٜ مٛ وٛيَ حَوْتِ اٜ يَحُودَنْکٛعٜنْ غَرْدُٻٜ اٜ مَاکٛ، سٜيْ ٻٜرْندٜ مَاکٛ اُمِّي نَاع سٜطَّ اٛ وَنِّي؞ ");
INSERT INTO fuv_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","اٛ وِعِ، ‏«‏تٛيٜ اُوُطٛنْمٛ؟»‏ ٻٜ مبِعِمٛ، ‏«‏مٛودِبّٛ، وٛرٛيْ، نغِعَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","سٜيْ يٜىٰسُ وٛيِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","يَحُودَنْکٛعٜنْ ٻٜنْ مبِعِ، ‏«‏رَا نٛ اٛ يِطِرِمٛ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","اَمَّا وٛٻّٜ مبِعِ، ‏«‏اٛ وُمْتِنِي بُمْطٛ؞ تٛو، طُمٜ حَطِمٛ وَطُکِ غٛطُّمْ کَطَيْطُمْ نٜطّٛ اٛعٛ مَايُکِ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","يٜىٰسُ فُطِّتِ وَنِّ نَاع سٜطَّ، اٛ يَحِ يٜنَاندٜ ندٜنْ؞ يٜنَاندٜ ندٜنْ بٛو طُمْ لُورٛ حَيْرٜ، حٛنْدُکٛ مَيْرٜ اٜ مَٻِّرَا کَاپَ؞ ");
INSERT INTO fuv_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","يٜىٰسُ وِعِ، ‏«‏اِتّٜىٰ کَاپَ نغَنْ؞»‏ مَرْتَ مَوْنِرَاوٛ مَيْطٛ اٛنْ وِعِ يٜىٰسُ، ‏«‏مٛودِبّٛ، جٛونِ اٜ وٛودِ لُمْنغٛلْ کَلُّنغٛلْ، نغَمْ اٛ وَطِي بَلْطٜ نَيِ دَغَ اٛ مَايِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","سٜيْ يٜىٰسُ وِعِمٛ، ‏«‏نَاع مِ وِعِيمَ تَا حٛولَکٜيَمْ، اَ يِعَيْ تٜدُّنغَلْ اَللَّه؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","سٜيْ ٻٜ اِتِّ کَاپَ نغَنْ دَغَ دَمُّغَلْ يٜنَاندٜ ندٜنْ؞ سٜيْ يٜىٰسُ رَارِ دٛوْ وِعِ، ‏«‏ݧَاکٛ مٛ دٛوْ، مِ يٜتِّيمَ نغَمْ اَ نَنِي دٛعَارٜ اَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","اٜ مِ اَنْدِ اَ نَنَ دٛعَارٜ اَمْ کٛو ندٜيٜ، اَمَّا مِ وِعُ نٛنْ نغَمْ ٻٜيْدَارِ يِمْٻٜ غٛنْٻٜ طٛعٛ، نغَمْ ٻٜ نجَٻَ اَنْ لِلٛيِيَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","غَطَ اٛ وِعِي نٛنْ، اٛ نٛدِّ اٜ سٜمْبٜ، ‏«‏لِعَاجَرُ، وُرْتٛيَ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","سٜيْ مَيْطٛ اٛنْ وُرْتٛيِي دَغَ ندٜرْ يٜنَاندٜ ندٜنْ، ٻَنْدُ مَاکٛ اٜ تَارِرَا وُدٜرٜ، جُوطٜ مَاکٛ اٜ کٛيْطٜ مَاکٛ اٜ کَٻِّرَا لٜفِ، يٜىٰسٛ مَاکٛ بٛو اٜ تَارِرَا لٜفٛلْ فٜىٰرٜ؞ يٜىٰسُ وِعِٻٜ، ‏«‏تَارْتٜىٰمٛ، اَلٛنْمٛ اٛ دِلَّ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","طُطْٻٜ ندٜرْ يَحُودَنْکٛعٜنْ غَرْدُٻٜ اٜ مَرْيَامَ غِعُٻٜ کٛ يٜىٰسُ وَطِ، ٻٜ کٛولِيمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","اَمَّا وٛٻّٜ مَٻّٜ نجَحِ تٛ فَارِسَنْکٛعٜنْ مبِعِٻٜ کٛ يٜىٰسُ وَطِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","نغَمْ نٛنْ، مَوْٻٜ اَرْدِيٻٜ دِينَ اٜ فَارِسَنْکٛعٜنْ ٻٜ نٛدِّ کَوْتَلْ مَوْٻٜ، ٻٜ مبِعِ، ‏«‏طُمٜ نغَطٜتٜنْ؟ نٜطّٛ اٛعٛ اٜ وَطَ کُوطٜ کَيْطِنِيطٜ طُطّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","تٛ اٜنْ اَلِيمٛ اٛ ݧَمْرِي يٜىٰسٛ اٜ وَطُکِ طُعُمْ، کٛو مٛيٜ حٛولٛتٛمٛ، ندٜنْ رٛومَنْکٛعٜنْ نغَرَيْ تٜىٰتَ وُرٛ شٜنِينغٛ مٜىٰطٜنْ اٜ لٜيْدِ مٜىٰطٜنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","اَمَّا غٛعٛتٛ مَٻّٜ بِعٜتٜىٰطٛ کَيَافَ مَوْطٛ مَوْٻٜ اَرْدِيٻٜ دِينَ اٜ طُمْ طٛنْ ندُنْغُ وِعِٻٜ، ‏«‏وَلَا کٛ اَنْدُطٛنْ!‏ ");
INSERT INTO fuv_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","اٛنْ اَنْدَا طُمْ ٻُرَنِيعٛنْ نٜطّٛ غٛعٛتٛ مَايَ نغَمْ کٛو مٛيٜ دٛوْ لٜݧٛلْ يَحُودَنْکٛعٜنْ فُو حَلْکَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","حَالَ کَعَ کَ کَيَافَ وِعِ نَاع طُمْ ݧُمٛ مَاکٛ، اَمَّا ندٜ کَنْکٛ وٛنِ مَوْطٛ مَوْٻٜ اَرْدِيٻٜ دِينَ اٜ طُمْ طٛنْ ندُنْغُ اٛ وَطِ اَنَّبَاکُ وِيکِ يٜىٰسُ مَايَيْ نغَمْ لٜݧٛلْ يَحُودَنْکٛعٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","اٛ مَايَيْ نَاع نغَمْ يَحُودَنْکٛعٜنْ تَنْ، اَمَّا حَا اٜ يِمْٻٜ اَللَّه شَنْکِتِيٻٜ ندٜرْ غٛطّٜ لٜيْطٜ، اٛ حَوْرِتَٻٜ اٛ وَرْتِرَٻٜ غٛعٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","دَغَ ندٜنْ طٛنْ ݧَلْندٜ ٻٜ ندَرْوِ وَرْکِ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","نغَمْ نٛنْ يٜىٰسُ اَلِ يِيلَاکِ ندٜرْ يَحُودَنْکٛعٜنْ اٜ نجَيْرِ؞ اَمَّا اٛ اَلِ طٛنْ اٛ يَحِ وٛنْدٜ وِغٜىٰرٜ حَادٜ کَرٜ اٛ نَتِّ وٛنْدِ غَرِيرِ بِعٜتٜىٰندِ اِفِرَايِمْ، اٛ جٛوطِي طٛنْ، کَنْکٛ اٜ تٛکُّٻٜمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","ندٜ حُمْتٛ سَکِّنْکِ نغٛ يَحُودَنْکٛعٜنْ ٻَدِي، يِمْٻٜ طُطْٻٜ جٛوطٛتٛوٻٜ ندٜرْ نغَرِحٛيْ لَدّٜ ٻٜ ندِلِّ اُرُشَلِيمَ نغَمْ ٻٜ لَاٻِنَ کٛعٜ مَٻّٜ کٛ حُمْتٛ نغٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","ٻٜ نغَطِ کَ طَٻُّتُکِ يٜىٰسُ؞ ندٜ ٻٜ کَوْرِتِ ندٜرْ وُرٛ شٜنِينغٛ، ٻٜ نغَطِ کَ پَمْپَمْتِرْکِ اٜ ٻٜ مبِعَ، ‏«‏طُمٜ نغِيطٛنْ؟ اٛ وَرَيْ حُمْتٛ نغٛعٛ بٛو؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","مَوْٻٜ اَرْدِيٻٜ دِينَ اٜ فَارِسَنْکٛعٜنْ ٻٜ نجَادَکٜ ٻٜ مبِعِي فُو اَنْدُطٛ تٛ يٜىٰسُ وٛنِ، اٛ اَنْدِنَٻٜ نغَمْ ٻٜ نَنْغَمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","بَلْطٜ جٛوٜىٰغٛعٛ کٛ حُمْتٛ سَکِّنْکِ وَطَ، يٜىٰسُ وَرِ بٜتَنِ تٛ لِعَاجَرُ جٛوطٛتٛو، مٛ اٛ اُمِّنِ دَغَ مَيْدٜ؞ ");
INSERT INTO fuv_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","تٛنْ طُمْ جٛنْغَنِ يٜىٰسُ حِرَاندٜ؞ مَرْتَ وٛنِ غٜىٰدُطٛ ݧَمْندُ ندُنْ؞ لِعَاجَرُ بٛو اٛ غٛعٛتٛ ندٜرْ جٛوطِيٻٜ اٜ ݧَمْندَ اٜ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","مَرْيَامَ حٛشِّ جٛلّٛيٜلْ نٜبَّمْ اُرٛوجَمْ طَمْ طُمْ وَطِرِ نَرْدِ غٛودُطَمْ شٜىٰدٜ، اٛ وَيْلِطَمْ دٛوْ کٛيْطٜ يٜىٰسُ، اٛ مٛيْتِرِطٜ غَاسَ حٛورٜ مَاکٛ؞ وُرٛ نغٛنْ حٜىٰوِ اُرْنغٛلْ نٜبَّمْ طَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","اَمَّا يَحُودَ اِسْکَرِيٛوتِ، غٛعٛتٛ ندٜرْ تٛکُّٻٜمٛ، کٛکِّتِرَيْطٛمٛ، وِعِ، ");
INSERT INTO fuv_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","‏«‏نغَمْ طُمٜ طُمْ سٛورَايِ نٜبَّمْ طَعَمْ طُمْ حٛکَّ ٻٜ نغَلَنَا شٜىٰدٜ طٜنْ؟ شٜىٰدٜ مَاجَمْ کٜوْتَيْ شٜىٰدٜ طٜ طُمْ يٛٻَتَ کُوٛووٛ حِتَاندٜ غٛعٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","اٛ وِعُ نٛنْ نَاع نغَمْ اٜ مٛ وَنِّدِ اٜ ٻٜ نغَلَنَا، اَمَّا نغَمْ اٛ غُجّٛ؞ کَنْکٛ وٛنِ دٜسٛووٛ شٜىٰدٜ مَٻّٜ، اٛ بٛو وٛووِ اِتُّکِ شٜىٰدٜ طٜنْ اٜ مٛ حُوتِرَطٜ نغَمْ حٛورٜ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","يٜىٰسُ وِعِ، ‏«‏اَلُ دٜبّٛ اٛعٛ؞ اٛ رٜسُطَمْ نغَمْ ݧَلْندٜ ندٜ اُوٜتٜىٰمِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","کٛو ندٜيٜ اٛنْ نغٛنْدِ اٜ ٻٜ نغَلَنَا ندٜرْ مٛوطٛنْ، اَمَّا مِنْ، شَرٜلْ اٜ وَرَ نغٜلْ اَلَيْمِعٛنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","ندٜ يَحُودَنْکٛعٜنْ طُطْٻٜ نَنِ حَبَرُ يٜىٰسُ اٜ تٛنْ بٜتَنِ، سٜيْ ٻٜ نجَحِ، نَاع نغَمْ يٜىٰسُ تَنْ، اَمَّا نغَمْ ٻٜ نغِعَ لِعَاجَرُ، مٛ اٛ اُمِّنِ دَغَ مَيْدٜ؞ ");
INSERT INTO fuv_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","نغَمْ نٛنْ، مَوْٻٜ اَرْدِيٻٜ دِينَ کَٻِّ وَرْکِ لِعَاجَرُ کَنُمْ مَا، ");
INSERT INTO fuv_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ندٜ نغَمْ مَاکٛ يَحُودَنْکٛعٜنْ طُطْٻٜ اٜ اَلَ دِينَ مَٻّٜ اٜ کٛولٛو يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","ندٜ فِنِ، يِمْٻٜ طُطْٻٜ غَرْٻٜ حُمْتٛ نغٛنْ نَنِ حَبَرُ يٜىٰسُ اٜ دٛوْ لَاوٛلْ وَرْکِ اُرُشَلِيمَ؞ ");
INSERT INTO fuv_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","نغَمْ نٛنْ ٻٜ کٛشِّ لِشٜ دَبِينٛوجٜ ٻٜ مبُرْتِي نغَمْ تَٻّٛيَاکِمٛ، اٜ ٻٜ مبِعَ اٜ سٜمْبٜ، ‏«‏حٛسَانَ!‏ اٛ بَرْکِطِنَاطٛ اٛنْ طٛنْ غَرٛيْطٛ ندٜرْ اِنْدٜ جٛومِرَاوٛ؞ اٛ بَرْکِطِنَاطٛ لَامِيطٛ اِسْرَاعِيلَ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","يٜىٰسُ بٛو حٜٻِ مبَبَّ مٛلَ وَطِّينغَ، نٛنْ نٛ طُمْ وِنْدِرَا، ");
INSERT INTO fuv_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","‏«‏تَاع حُلُ، غَرِيرِ سِحِيٛونَ؞ رَا لَامِيطٛ مَاطَ اٜ وَرَ دٛوْ مبَبَّ مٛلَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","اَرَنْدٜ تٛکُّٻٜمٛ ڤَامَايِ طُعُمْ، اَمَّا غَطَ يٜىٰسُ تٜدِّنَامَ، سٜيْ ٻٜ شِفْتٛرِ طُعُمْ طُمْ وِنْدَا دٛوْ مَاکٛ طُمْ بٛو وَطَنِيمٛطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","غٛنْدُنٛوٻٜ اٜ مَاکٛ شَرٜلْ نغٜلْ اٛ نٛدِّ لِعَاجَرُ دَغَ ندٜرْ يٜنَاندٜ اٛ اُمِّنِمٛ دَغَ مَيْدٜ، ٻٜ ݧَمْرِ يٜىٰسٛ اٜ وِيکِ کٛ وَطِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","يِمْٻٜ طُطْٻٜ نجَحِ تَٻّٛيٛومٛ نغَمْ ٻٜ نَنِي حَبَرُ اٛ وَطِي طُعُمْ فِي کَيْطِنِيطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","سٜيْ فَارِسَنْکٛعٜنْ مبِعِ حَکُّندٜ مَٻّٜ، ‏«‏نغِعٜىٰ، وَلَا کٛ مبَاوٜتٜنْ وَطُکِ، نغَمْ دُونِيَارُ فُو تٛکِّيمٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","اٜ وٛودِ وٛٻّٜ حٜلٜنَنْکٛعٜنْ ندٜرْ جَاٻٜ اُرُشَلِيمَ نغَمْ مَوْنِنْکِ اَللَّه شَرٜلْ حُمْتٛ سَکِّنْکِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","ٻٜ نجَحِ تٛ فِلِبُسْ پِوٛيْطٛ بٜتَسَيْدَ ندٜرْ لٜيْدِ غَلِيلِ، ٻٜ مبِعِمٛ، ‏«‏مٛودِبّٛ، اٜ مِنْ نغِطِ يِيکِ يٜىٰسُ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","فِلِبُسْ يَحِ وِعِکَ اَنْدِرَاوُسْ ٻٜ کَوْتِ ٻٜ نجَحِ ٻٜ مبِعِکَ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","يٜىٰسُ وِعِٻٜ، ‏«‏شَرٜلْ وَرِي نغٜلْ ٻِي نٜطّٛ تٜدِّنْتٜىٰ؞ ");
INSERT INTO fuv_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","اٜ مِ وِعَعٛنْ غٛونغَ، تٛ نَاع غَبّٜلْ اَلْکَمَارِ يَنِ تٛ لٜيْدِ وَاتِ، نغٜلْ جٛوطٛتٛ کَنْغٜلْ تَنْ؞ اَمَّا تٛ نغٜلْ وَاتِي، نغٜلْ رِمَيْ غَبّٜ طُطّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","فُو غِطّٛ يٛنْکِ مُوطُمْ دُلَّيْکِ، ندٜنْ کٛو مٛيٜ غَݧُطٛ يٛنْکِ مُوطُمْ ندٜرْ دُونِيَارُ ندُعُ اٛ حٜٻَيْ يٛنْکِ کِ رٜعَتَا؞ ");
INSERT INTO fuv_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","فُو کُوَنٛووٛيَمْ دٛولٜ تٛکَّيَمْ؞ ندٜنْ تٛ نغٛنْمِ، تٛنْ کُوَنٛووٛيَمْ وٛنَتَ، کَنْکٛ مَا؞ کٛو مٛيٜ کُوَنَيْطٛيَمْ، ݧَاکٛ اَمْ حٛکَّيْمٛ مَنْغُ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","يٜىٰسُ ݧَمْرِ يٜىٰسٛ اٜ وِيکِ، ‏«‏جٛونِ ٻٜرْندٜ اَمْ وَنِّي؞ طُمٜ مبِعَيْمِ؟ مِ وِعَ، ‏‹‏ݧَاکٛ اَمْ، حِسْنَمْ دَغَ شَرٜلْ نغٜعٜلْ؟›‏ نَاع نٛنْ، نغَمْ کَنْجُمْ وَطِ نغَرْمِ شَرٜلْ نغٜعٜلْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","يَا ݧَاکٛ اَمْ، تٜدِّنْ اِنْدٜ مَاطَ!‏»‏ سٜيْ حٛنٛنْدٜ پِوٛيِ دَغَ دٛوْ وِعِ، ‏«‏مِ تٜدِّنِيندٜ، مِ فُطِّتَيْ مِ تٜدِّنَندٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","يِمْٻٜ طُطْٻٜ غٛنْٻٜ طٛنْ نَنِي حٛنٛنْدٜ ندٜنْ؞ وٛٻّٜ مبِعِ طُمْ رِغَّانغٛ، ندٜنْ وٛٻّٜ بٛو مبِعِ، ‏«‏مَلَاعِکَاجٛ مٜتَنِمٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","اَمَّا يٜىٰسُ وِعِٻٜ، ‏«‏حٛنٛنْدٜ ندٜعٜ وَرٛيِ نغَمْ ٻٜيْدَارِ مٛوطٛنْ، نَاع نغَمْ ٻٜيْدَارِ اَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","جٛونِ وٛنِ شَرٜلْ نغٜلْ طُمْ وَطَنْتَ يِمْٻٜ دُونِيَارُ ندُعُ کِيتَ؞ جٛونِ طُمْ رِيوَيْ لَامِيطٛ دُونِيَارُ ندُعُ؞ ");
INSERT INTO fuv_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","اَمَّا مِنْ، تٛ مِ پٜفْتَامَ دٛوْ غَافَانغَلْ، مِ فٛوطَيْ کٛو مٛيٜ تٛ اَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","اٛ وِعُ نٛنْ نغَمْ اٛ حٛلَّ اِرِ مَيْدٜ ندٜ اٛ مَايَتَ؞ ");
INSERT INTO fuv_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","سٜيْ يِمْٻٜ حَوْرُتُٻٜ ٻٜنْ نٛوتِي مبِعِمٛ، ‏«‏اَتَّوْرَ اَلْمَسِيحُ جٛوطٛتٛ حَا اَبَدَا؞ نٛ وَطَتَ مبِعَا دٛولٜ طُمْ پٜفْتَ ٻِي نٜطّٛ دٛوْ؟ طُمْ مٛيٜ مَا نٜىٰ وٛنِ اٛعٛ ٻِي نٜطّٛ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","يٜىٰسُ وِعِٻٜ، ‏«‏جَيْنغٛلْ اٜ وٛنْدِ اٜ مٛوطٛنْ نغَمْ شَرٜلْ سٜطَّ؞ نغَطٜىٰ کَ يَادُ شَرٜلْ نغٜلْ غٛودُطٛنْ جَيْنغٛلْ، نغَمْ تٛع ݧِوْرٜ وَرَ سُدَّعٛنْ؞ فُو جَحٛووٛ ندٜرْ ݧِوْرٜ اَنْدَا تٛ يَحَتَ؞ ");
INSERT INTO fuv_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","نغٜعٜلْ شَرٜلْ نغٜلْ نغٛنْدُطٛنْ اٜ جَيْنغٛلْ، کٛولٜىٰ جَيْنغٛلْ نغٛلْ، نغَمْ نغَرْتٛنْ ٻِٻّٜ جَيْنغٛلْ؞»‏ ندٜ يٜىٰسُ وِعِ نٛنْ، سٜيْ اٛ دِلِّ اٛ سُوطِ حٛورٜ مَاکٛ دَغَ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","کٛو ندٜ يٜىٰسُ وَطِي کٛ حَيْطِنِ طُطُّمْ يٜىٰسٛ مَٻّٜ، فُو اٜ نٛنْ ٻٜ کٛولَاکِمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","طُعُمْ وَطِ نغَمْ طُمْ حٜبِّنَ کٛ اَنَّبِ اِشَايَ وِعِ، ‏«‏جٛومِرَاوٛ، مٛيٜ جَٻِ کٛ مبِيطٜنْ؟ مٛيٜ جٛومِرَاوٛ وَنْغِنَنِ بَوْطٜ مُوطُمْ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","کَنْجُمْ وَطِ ٻٜ کٛولَاکِمٛ، نغَمْ اَنَّبِ اِشَايَ وِعِ طٛنْمَا اَللَّه وِعِ، ");
INSERT INTO fuv_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","‏«‏مِ وُمْنِي غِتٜ مَٻّٜ مِ سَاتِنِي ٻٜرْطٜ مَٻّٜ، نغَمْ تٛع ٻٜ نغِعَ اٜ غِتٜ مَٻّٜ، ٻٜ ڤَامَ ندٜرْ ٻٜرْطٜ مَٻّٜ، ٻٜ شٛعّٛو تٛ اَمْ، مِ يَمْطِتِنَ ٻٜرْطٜ مَٻّٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","اَنَّبِ اِشَايَ وِعُ طُعُمْ نغَمْ ندٜنّٛ اٛ يِعِي تٜدُّنغَلْ يٜىٰسُ، طٛنْمَا اٛ مٜتِي دٛوْ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","فُو اٜ نٛنْ، کٛو ندٜرْ اَرْدِيٻٜ، طُطْٻٜ کٛولِي يٜىٰسُ؞ اَمَّا نغَمْ فَارِسَنْکٛعٜنْ ٻٜ مبِعَايِکَ اٜ نجَيْرِ نغَمْ اٜ ٻٜ کُلَ طُمْ رِيوَٻٜ دَغَ لٜݧٛلْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","نغَمْ ٻٜ ٻُرِي يِطُکِ يِمْٻٜ مَنَٻٜ اٜ دٛوْ اَللَّه مَنَٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","سٜيْ يٜىٰسُ وِعِ اٜ سٜمْبٜ، ‏«‏فُو کٛولِيطٛيَمْ، نَاع مِنْ تَنْ اٛ حٛولِي، اَمَّا فُو اٜ اٛنْ طٛنْ لِلٛيْطٛيَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","فُو غِيطٛيَمْ يِعِ اٛنْ طٛنْ لِلٛيْطٛيَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","مِ وَرِي ندٜرْ دُونِيَارُ ندُعُ بٛ جَيْنغٛلْ، نغَمْ فُو کٛولِيطٛيَمْ تٛع جٛوطٛو ندٜرْ ݧِوْرٜ؞ ");
INSERT INTO fuv_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","فُو نَنْطٛ اٜکِّتِنٛلْ اَمْ تٛکَّايِنغٛلْ، مِ وَطَنْتَامٛ کِيتَ، نغَمْ مِ وَرَايِ وَطَنْکِ دُونِيَارُ کِيتَ، اَمَّا مِ وَرٛيِ نغَمْ حِسْنُکِندُ؞ ");
INSERT INTO fuv_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","فُو غَݧُطٛيَمْ وَݧِ جَٻُکِ اٜکِّتِنٛلْ اَمْ، اٜ وٛودِ غَطَنَيْطٛمٛ کِيتَ؞ وٛلْدٜ ندٜ مٜتُمِ وَطَنَيْمٛ کِيتَ ݧَلْندٜ جَانغٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","نغَمْ مِ مٜتِرَايِ لَامُ اَمْ، ݧَاکٛ مٛ دٛوْ لِلْطٛيَمْ وِعِيَمْ کٛ مبِعَيْمِ اٜ نٛ مبِعِرَيْمِطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","کٛ اٛ وِعِ طُمْ وَطَ، اٜ مِ اَنْدِ طُمْ وَدَّيْ يٛنْکِ کِ رٜعَتَا؞ نغَمْ نٛنْ، فُو کٛ مبِيمِ مِ وِعُطُمْ نٛنْ نٛ ݧَاکٛ اَمْ وِعِيَمْ مِ وِعَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","تٛو، طُمْ ݧَلْندٜ غٛعٛ کٛ طُمْ وَطَ حُمْتٛ سَکِّنْکِ؞ يٜىٰسُ اٜ اَنْدِ شَرٜلْ وَطِي نغٜلْ اٛ اَلَتَ دُونِيَارُ ندُعُ اٛ سٛعّٛو تٛ ݧَاکٛ مٛ دٛوْ؞ يٜىٰسُ اٜ يِطِ يِمْٻٜ مُوطُمْ غٛنْٻٜ ندٜرْ دُونِيَارُ، جٛونِ بٛو اٛ حٛلَّيْٻٜ مَنْغُ يِدّٜ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","يٜىٰسُ اٜ تٛکُّٻٜمٛ اٜ ٻٜ کِرْتٛو؞ شٜيْطَنْ يَادَکٜ وَطِي ݧُمٛ حٛکِّتِرْکِ يٜىٰسُ ندٜرْ ٻٜرْندٜ يَحُودَ اِسْکَرِيٛوتِ ٻِطّٛ سِيمَنْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","يٜىٰسُ اٜ اَنْدِ ݧَاکٛ مٛ دٛوْ وَطِي کٛو طُمٜ ندٜرْ جُوطٜ مُوطُمْ، کَدِنْ اٜ مٛ اَنْدِ دَغَ تٛ اَللَّه اٛ پِوٛيِ، تٛ اَللَّه کَدِنْ اٛ سٛعّٛتٛو؞ ");
INSERT INTO fuv_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","نغَمْ نٛنْ، اٛ اُمِّي دَغَ تٛ ٻٜ ݧَامَتَ ݧَمْندُ، اٛ ٻٛرْتِي تٛغّٛورٜ مَاکٛ، اٛ تَادِي غُدٜلْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","سٜيْ اٛ ݧٜطِ ندِيَمْ ندٜرْ تُمُّدٜ، اٛ فُطِّ لٛوتُکِ کٛيْطٜ تٛکُّٻٜمٛ، اٜ مٛ مٛيْتِرَطٜ غُدٜلْ نغٜلْ اٛ تَادِي؞ ");
INSERT INTO fuv_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","اٛ وَرِ تٛ سِيمَنْ بِيتُرُسْ، سِيمَنْ بِيتُرُسْ وِعِمٛ، ‏«‏مٛودِبّٛ، اَنْ لٛوتَنْتَيَمْ کٛيْطٜ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","يٜىٰسُ وِعِمٛ، ‏«‏جٛونِ اَ فَامَتَا کٛ نغَطَيْمِ، اَمَّا يٜىٰسٛ طٛعٛ اَ فَامَيْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","سٜيْ بِيتُرُسْ وِعِ، ‏«‏اَاعَ!‏ غٛونغَ اَ لٛوتَنْتَايَمْ کٛيْطٜ؞»‏ يٜىٰسُ وِعِمٛ، ‏«‏تٛ مِ لٛوتَنَايِمَ کٛيْطٜ، اَنْ نَاع اَ تٛکُّطٛيَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","سِيمَنْ بِيتُرُسْ وِعِمٛ، ‏«‏مٛودِبّٛ، تَاع لٛوتُ کٛيْطٜ اَمْ تَنْ، حَوْتُ فُو اٜ جُوطٜ اَمْ اٜ حٛورٜ اَمْ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","سٜيْ يٜىٰسُ وِعِ، ‏«‏کٛو مٛيٜ لٛوتِيطٛ، فُو ٻَنْدُ مَاکٛ وَرْتِي لَمْندُ؞ نَاع نَا اٛ فُطِّتِي اٛ لٛوتِي حٛورٜ مَاکٛ، سٜيْ نِ اٛ لٛوتَ کٛيْطٜ مَاکٛ؞ اٛنٛنْ بٛو اٛنْ لَاٻُٻٜ، اَمَّا نَاع اٛنْ فُو مٛوطٛنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","يٜىٰسُ اٜ اَنْدِ کٛکِّتِرَيْطٛمٛ، کَنْجُمْ وَطِ اٛ وِعِ، ‏«‏نَاع اٛنْ فُو نغٛنِ لَاٻُٻٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","غَطَ يٜىٰسُ لٛوتِي کٛيْطٜ مَٻّٜ، اٛ ٻٛرْنِي تٛغّٛورٜ مَاکٛ، اٛ سٛعِّي اٛ جٛوطِي تٛ اٛ وٛنّٛو؞ اٛ وِعِٻٜ، ‏«‏اٛنْ ڤَامِي کٛ نغَطَنْمِعٛنْ جٛونِ؟ ");
INSERT INTO fuv_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","اٛنْ نٛدَّيَمْ مٛودِبّٛ اٜ مَوْطٛ، اٜ طُمْ حَانِ ندٜ نغَطّٛنْ نٛنْ، نغَمْ نٛنْ نغٛنُمِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","جٛونِ، ندٜ مِنْ، مَوْطٛ مٛوطٛنْ اٜ مٛودِبّٛ مٛوطٛنْ، مِ لٛوتِي کٛيْطٜ مٛوطٛنْ، اٛنٛنْ مَا اٜ حَانِ لٛوتِندِرٛنْ کٛيْطٜ؞ ");
INSERT INTO fuv_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","مِ وَطَنِيعٛنْ کٛ اٜکِّتٛتٛوطٛنْ، نغَمْ اٛنٛنْ مَا نغَطَنٛنْ وٛٻّٜ نٛنْ نٛ نغَطَنْمِعٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","اٜ مِ وِعَعٛنْ غٛونغَ، وَلَا مَشُّطٛ ٻُرْطٛ جٜيْطٛمٛ، ندٜنْ وَلَا لِلَاطٛ ٻُرْطٛ لِلْطٛمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","جٛونِ ندٜ اٛنْ اَنْدِ فُو فِي طُعُمْ، اٛنْ بَرْکِطِنَاٻٜ تٛ اٛنْ نغَطِيطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","‏«‏نَاع دٛوْ مٛوطٛنْ اٛنْ فُو مٜتَيْمِ؞ اٜ مِ اَنْدِ ٻٜ شُٻُمِ؞ اَمَّا اَايَارٜ ندٜعٜ دٛولٜ ندٜ حٜىٰوَ بِيندٜ، ‏‹‏نٜطّٛ مٛ ݧَمْدَيْمِ ݧَمْندُ اَمْ وَرْتِي غَݧٛ اَمْ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","اٜ مِ وِعَعٛنْ طُعُمْ جٛونِ کٛ طُمْ وَطَ، نغَمْ تٛ طُمْ وَطِي کٛولٛوطٛنْ، ‏‹‏مِنْ وٛنِ مٛ نغٛنُمِ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","اٜ مِ وِعَعٛنْ غٛونغَ، فُو جَٻُطٛ کٛو مٛيٜ مٛ لِلُمِ جَٻِييَمْ، کَدِنْ فُو جَٻُطٛيَمْ جَٻِي اٛنْ طٛنْ لِلٛيْطٛيَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","غَطَ يٜىٰسُ وِعِي نٛنْ، اٛ وَنِّ نَاع سٜطَّ، سٜيْ اٛ وِعِ اٜ نجَيْرِ، ‏«‏اٜ مِ وِعَعٛنْ غٛونغَ، غٛعٛتٛ ندٜرْ مٛوطٛنْ حٛکِّتِرَيْيَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","سٜيْ تٛکُّٻٜمٛ ندَرْندَرْتِرِ، ٻٜ ڤَامَايِ دٛوْ مٛيٜ مَٻّٜ اٛ مٜتَتَ؞ ");
INSERT INTO fuv_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","غٛعٛتٛ مَٻّٜ مٛ يٜىٰسُ يِطِ نَاع سٜطَّ اٜ جٛوطِي حَادٜ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","سِيمَنْ بِيتُرُسْ سَڤِّيمٛ وِعِ، ‏«‏پَمُ يٜىٰسُ دٛوْ مٛيٜ مٜتَتَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","سٜيْ اٛ ٻَدِّي يٜىٰسُ اٛ وِعِ، ‏«‏مٛودِبّٛ، طُمْ مٛيٜ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","يٜىٰسُ نٛوتِي وِعِ، ‏«‏کَنْکٛ وٛنِ مٛ کٛکَّيْمِ نغٜعٜلْ ݝٛشِّتٜلْ بُرٛودِ غَطَ مِ سُووِينغٜلْ ندٜرْ تُمُّدٜ؞»‏ سٜيْ يٜىٰسُ سُووِ ݝٛشِّتٜلْ بُرٛودِ ندٜرْ تُمُّدٜ، اٛ حٛکِّنغٜلْ يَحُودَ، ٻِي سِيمَنْ اِسْکَرِيٛوتِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","غَطَ يَحُودَ جَٻِي ݝٛشِّتٜلْ نغٜلْ، شٜيْطَنْ نَتِّ ٻٜرْندٜ مَاکٛ؞ يٜىٰسُ وِعِمٛ، ‏«‏يَوْنُ نغَطَا کٛ نغِطَّا وَطُکِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","فُو جٛوطِيٻٜ طٛنْ وَلَا ڤَامُطٛ نغَمْ طُمٜ يٜىٰسُ وِعِمٛ نٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","ندٜ يَحُودَ وٛنِ دٜسٛووٛ شٜىٰدٜ مَٻّٜ، وٛٻّٜ ندٜرْ مَٻّٜ ݧُمِ يٜىٰسُ وِعُمٛ اٛ يَحَ اٛ سٛودَ کٛ ٻٜ کُوتِنِرْتَ ندٜرْ حُمْتٛ، کٛو اٛ حٛکَّ ٻٜ نغَلَنَا غٛطُّمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","غَطَ يَحُودَ جَٻِي بُرٛودِ طُمْ، اٛ وُرْتِي طٛنْ اٜ طٛنْ؞ اٜ شَرٜلْ نغٜلْ طُمْ جٜمَّ؞ ");
INSERT INTO fuv_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","غَطَ يَحُودَ اَلِي طٛنْ، يٜىٰسُ وِعِ، ‏«‏جٛونِ تٜدُّنغَلْ ٻِي نٜطّٛ وَنْغَيْ، ندٜنْ لَاوٛلْ مَاکٛ تٜدُّنغَلْ اَللَّه وَنْغَيْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","تٛ طُمْ تٜدِّنِي اَللَّه لَاوٛلْ مَاکٛ، ندٜنْ اَللَّه اٜ حٛورٜ مُوطُمْ نٛ تٜدِّنَيْ ٻِي نٜطّٛ، اٛ تٜدِّنَيْمٛ نَاع کٛ نٜىٰٻِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","ٻِٻّٜ اَمْ، مِ جٛوطٛدٛتٛ اٜ مٛوطٛنْ شَرٜلْ سٜطَّ تَنْ؞ اٛنْ طَٻِّتَيْيَمْ، اَمَّا کٛ مبِينٛومِ اَرْدِيٻٜ يَحُودَنْکٛعٜنْ، اٛنٛنْ مَا اٜ مِ وِعَعٛنْ نٛنْ جٛونِ، ‏‹‏تٛ نجَحَيْمِ، اٛنْ مبَاوَتَا يَاکِ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","جٛونِ رَا غٛطُّمْ کٜسُمْ طُمْ نغِطُمِ نغَطٛنْ:‏ نغِطِندِرٜىٰ؞ نٛنْ نٛ نغِطِرْمِعٛنْ، اٛنٛنْ مَا سٜيْ نغِطِنْدِرٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","تٛ اٛنْ نغِطِندِرِي، نٛنْ وَطَيْ کٛو مٛيٜ اَنْدَ اٛنٛنْ اٛنْ تٛکُّٻٜيَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","سِيمَنْ بِيتُرُسْ پَمِ يٜىٰسُ وِعِ، ‏«‏مٛودِبّٛ، تٛيٜ نجَحَتَا؟»‏ يٜىٰسُ وِعِمٛ، ‏«‏تٛ نجَحَيْمِ، اَ وَاوَتَا تٛکُّکِيَمْ جٛونِ، اَمَّا يٜىٰسٛ طٛعٛ اَ تٛکَّيْيَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","بِيتُرُسْ وِعِمٛ، ‏«‏مٛودِبّٛ، کٛ حَطَتَ مِ تٛکُّمَا جٛونِ؟ اٜ مِ سِرْيِي مِ مَايَ نغَمْ مَاطَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","يٜىٰسُ نٛوتِي، وِعِ، ‏«‏اَ سِرْيِي مَايَ نغَمْ اَمْ؟ اٜ مِ وِعُمَا غٛونغَ، کٛ نجَکَرْدِ حَنَ، اَ وِعَيْ اَ اَنْدَايَمْ ندٜ تَتِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","يٜىٰسُ وِعِٻٜ، ‏«‏تٛع اٛنْ نغَنُّ ندٜرْ ٻٜرْطٜ مٛوطٛنْ، کٛولٜىٰ اَللَّه، کٛولٜىٰيَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","ندٜرْ وُرٛ ݧَاکٛ اَمْ مٛ دٛوْ اٜ وٛودِ شُوطِ طُطِّ؞ دَا نَاع طُمْ نٛنْ، دَا مِ وِعَيْعٛنْ کَ؞ مِ يَحَيْ تٛنْ مِ سِرْيَنٛوعٛنْ تٛ نجٛوطٛتٛوطٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","تٛ مِ يَحِي، مِ سِرْيَنَکٜعٛنْ تٛ نجٛوطٛتٛوطٛنْ، مِ سٛعّٛيْتٛ، مِ حٛشَّعٛنْ مِ يَارَعٛنْ تٛ اَمْ، نغَمْ اٛنٛنْ مَا نجٛوطٛوطٛنْ تٛ نغٛنْمِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","اٛنْ اَنْدِ لَاوٛلْ جَحَيْنغٛلْ وِغٜىٰرٜ ندٜ نجَحَيْمِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","سٜيْ تٛومَ وِعِمٛ، ‏«‏مٛودِبّٛ، مِنْ اَنْدَا تٛ نجَحَتَا، نٛ مِنْ اَنْدِرْتَ لَاوٛلْ نغٛلْ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","يٜىٰسُ وِعِمٛ، ‏«‏مِنْ وٛنِ لَاوٛلْ، مِنْ وٛنِ غٛونغَ، مِنْ وٛنِ يٛنْکِ؞ وَلَا جَحَيْطٛ تٛ ݧَاکٛ مٛ دٛوْ سٜيْ تٛ تٛکِّييَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","اٛ وِعِٻٜ، ‏«‏دَا اٛنْ اَنْدِيَمْ، دَا اٛنْ اَنْدِ ݧَاکٛ اَمْ مٛ دٛوْ مَا؞ دَغَ جٛونِ اٛنْ اَنْدِمٛ اٛنْ نغِعِيمٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","فِلِبُسْ وِعِمٛ، ‏«‏مٛودِبّٛ، حٛلُّمِنْ ݧَاکٛ مٛ دٛوْ اٛنْ، نٛنْ حٜپِيمِنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","يٜىٰسُ نٛوتِي وِعِ، ‏«‏فِلِبُسْ، کٛ نٜىٰٻِ اٜ مِ وٛنْدِ اٜ مٛوطٛنْ، اَمَّا فُو اٜ نٛنْ اَ اَنْدَايَمْ؟ کٛو مٛيٜ غِيطٛيَمْ يِعِي ݧَاکٛ مٛ دٛوْ؞ نغَمْ طُمٜ مبِعَتَا مِ حٛلَّعٛنْ ݧَاکٛ مٛ دٛوْ؟ ");
INSERT INTO fuv_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","فِلِبُسْ، اَ حٛولَاکِ اٜ مِ ندٜرْ ݧَاکٛ اٛنْ، ندٜنْ ݧَاکٛ اٛنْ اٜ ندٜرْ اَمْ؟ کٛ مبِيمِعٛنْ نَاع بٛلِيطٜ طٜ حٛورٜ اَمْ مبِيمِعٛنْ، اَمَّا ݧَاکٛ مٛ دٛوْ، غٛنْطٛ ندٜرْ اَمْ، کَنُمْ حُوَتَ کُوطٜ مُوطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","نجَٻٜىٰ کٛ مبِيمِ ندٜ مبِيمِ اٜ مِ ندٜرْ ݧَاکٛ مٛ دٛوْ، کَنْکٛ مَا اٜ مٛ ندٜرْ اَمْ؞ تٛ اٛنْ کٛولَاکِ کٛ مبِيمِ، کٛولٜىٰيَمْ نغَمْ کُوطٜ طٜ نغَطُمِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","اٜ مِ وِعَعٛنْ غٛونغَ، کٛو مٛيٜ کٛولِيطٛيَمْ حُوَيْ کُوطٜ طٜ کُوُمِ، حَا مَا اٛ حُوَ کُوطٜ ٻُرْطٜ طٜ کُوُمِ، نغَمْ مِ يَحَيْ تٛ ݧَاکٛ مٛ دٛوْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","مِ وَطَيْ کٛو طُمٜ طُمْ تٛرِيطٛنْ ندٜرْ اِنْدٜ اَمْ، نغَمْ طُمْ يِعَ مَنْغُ ݧَاکٛ مٛ دٛوْ بَرْکَ ٻِطّٛ اٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","تٛ اٛنْ تٛرَکٜيَمْ کٛو طُمٜ ندٜرْ اِنْدٜ اَمْ، مِ وَطَيْطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","‏«‏تٛ اٛنْ نغِطِيَمْ، اٛنْ نغَطَيْ کٛ مبِيمِ نغَطٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","مِ تٛرٛتٛ ݧَاکٛ مٛ دٛوْ، ندٜنْ اٛ حٛکَّيْعٛنْ غٛطُّمْ بَلَّيْطُمْ، جٛوطٛدٛتٛوطُمْ اٜ مٛوطٛنْ حَا اَبَدَا؞ ");
INSERT INTO fuv_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","کَنْکٛ وٛنِ رُوحُ کٛلَّيْطُمْ غٛونغَ؞ يِمْٻٜ دُونِيَارُ ندُعُ نجَٻَتَاطُمْ، نغَمْ ٻٜ نغِعَتَاطُمْ، ٻٜ اَنْدَاطُمْ؞ اَمَّا اٛنٛنْ اٛنْ اَنْدِطُمْ نغَمْ اٜ طُمْ وٛنْدِ اٜ مٛوطٛنْ، ندٜنْ طُمْ جٛوطٛتٛ ندٜرْ مٛوطٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","‏«‏تٛ مِ دِلِّي، مِ اَلَتَاعٛنْ بٛ مَرَايَعٜنْ؞ مِ سٛعّٛيْتٛ تٛ مٛوطٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","يٜىٰسٛ طٛعٛ سٜطَّ، دُونِيَارُ ندُعُ فُطِّتَتَا يِعَيَمْ، اَمَّا اٛنٛنْ اٛنْ نغِعَيْيَمْ؞ نغَمْ اٜ مِ وٛودِ يٛنْکِ، اٛنٛنْ مَا اٛنْ کٜٻَيْ يٛنْکِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","اٜ ندٜنْ طٛنْ ݧَلْندٜ اٛنْ اَنْدَيْ اٜ مِ ندٜرْ ݧَاکٛ اَمْ، ندٜنْ اٛنٛنْ بٛو اٛنْ ندٜرْ اَمْ، مِنْ مَا اٜ مِ ندٜرْ مٛوطٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","‏«‏کٛو مٛيٜ جٛغِيطٛ کٛ مبِيمِ طُمْ وَطَ تٛکِّطُمْ، کَنْکٛ وٛنِ غِطّٛيَمْ؞ فُو غِطّٛيَمْ ݧَاکٛ اَمْ يِطَيْمٛ، ندٜنْ مِنْ مَا مِ يِطَيْمٛ مِ وَنْغِنَنَامٛ حٛورٜ اَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","سٜيْ يَحُودَ ﴿نَاع يَحُودَ اِسْکَرِيٛوتِ﴾ پَمِمٛ، وِعِ، ‏«‏مٛودِبّٛ، کٛ وَطِ شُٻُطَا وَنْغِنَنْکِمِنْ حٛورٜ مَاطَ نَاع يِمْٻٜ دُونِيَارُ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","يٜىٰسُ وِعِ، ‏«‏فُو غِطّٛيَمْ تٛکَّيْ اٜکِّتِنٛلْ اَمْ؞ ݧَاکٛ اَمْ بٛو يِطَيْمٛ، ندٜنْ مِنْ اٜ ݧَاکٛ اَمْ مِنْ نغَرَيْ تٛ مَاکٛ مِنْ جٛوطٛدٛو اٜ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","کٛو مٛيٜ مٛ يِطَايَمْ بٛو تٛکَّتَا اٜکِّتِنٛلْ اَمْ؞ اٜکِّتِنٛلْ نغٛلْ نَنْطٛنْ، نَاع طُمْ نغٛلْ اَمْ، طُمْ نغٛلْ ݧَاکٛ مٛ دٛوْ لِلٛيْطٛيَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","‏«‏مِ وِعُعٛنْ فُو طُعُمْ جٛونِ ندٜ نغٛنْدُمِ اٜ مٛوطٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","اَمَّا اٜ وٛودِ بَلَّيْطُمْ، وَاتٛ رُوحُ اَللَّه طُمْ ݧَاکٛ مٛ دٛوْ لِلٛيْتَ ندٜرْ اِنْدٜ اَمْ؞ طُمْ اٜکِّتِنَيْعٛنْ کٛو طُمٜ، طُمْ سِفْتٛرَنَيْعٛنْ فُو کٛ مبِيمِعٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","‏«‏جَمْ وٛنِ کٛ اَلْدُمِعٛنْ، جَمْ اَمْ کٛکُّمِعٛنْ؞ مِ حٛکِّيعٛنْطُمْ نَاع نٛ يِمْٻٜ دُونِيَارُ کٛکِّرْتَ؞ تٛع اٛنْ اَلُ ٻٜرْطٜ مٛوطٛنْ نغَنَّ، تٛع اٛنْ کُلُ؞ ");
INSERT INTO fuv_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","اٛنْ نَنِي اٜ مِ وِعَ، ‏‹‏مِ دِلَّيْ، اَمَّا مِ وَرْتٛيَيْ تٛ مٛوطٛنْ؞›‏ تٛ اٛنْ نغِطِيَمْ، اٛنْ نَنَيْ بٜلْطُمْ مِ يَحَيْ تٛ ݧَاکٛ مٛ دٛوْ، نغَمْ اٛ ٻُرِييَمْ مَنْغُ؞ ");
INSERT INTO fuv_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","مِ وِعُعٛنْکَ جٛونِ کٛ طُمْ وَطَ، نغَمْ تٛ طُمْ وَطِي نجَٻٛنْ کٛ مبِيمِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","مِ نٜىٰٻَتَا اٜ مِ مٜدَّ اٜ مٛوطٛنْ، نغَمْ لَامِيطٛ دُونِيَارُ ندُعُ اٜ وَرَ؞ اٛ وَلَا بَوْطٜ دٛوْ اَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","اَمَّا دٛولٜ يِمْٻٜ دُونِيَارُ ندُعُ اَنْدَ اٜ مِ يِطِ ݧَاکٛ مٛ دٛوْ، کَدِنْ اٜ مِ وَطَ کٛو طُمٜ کٛ اٛ وِعِيَمْ مِ وَطَ؞ اُمّٜىٰ ندِلّٜنْ، اَلٜنْ وِغٜىٰرٜ ندٜعٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","‏«‏مِنْ وٛنِ لَيٛلْ اِنَبٛحِ غٛونغَوٛلْ، ندٜنْ ݧَاکٛ اَمْ وٛنِ ڤَامَنَيْطٛنغٛلْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","اٛ اِتَّيْ کٛو نغَلٜ لِسَلْ اَمْ نغَلْ رِمَتَا، ندٜنْ اٛ مٛعِّنَيْ کٛو نغَلٜ لِسَلْ دِمٛووَلْ، نغَمْ نغَلْ ٻٜيْدَ رِمُکِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","وٛلْدٜ ندٜ مٜتَنْمِعٛنْ يَادَکٜ وَرْتِرِيعٛنْ لَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","نجٛوطٜىٰ اٛنْ نجٛکّٛوتِرِ اٜ اَمْ، ندٜنْ مِنْ مَا مِ جٛوطٛتٛ اٜ مِ جٛکّٛوتِرِ اٜ مٛوطٛنْ؞ لِسَلْ وَاوَتَا رِمَ کَنُمْ تَنْ، سٜيْ تٛ نغَلْ جٛکّٛوتِرِي اٜ لَيٛلْ؞ نٛنْ اٛنٛنْ مَا اٛنْ مبَاوَتَا نغَطٛنْ غٛطُّمْ طُمْ اَللَّه يِطِ سٜيْ تٛ اٛنْ نجٛکّٛوتِرِي اٜ اَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","‏«‏مِنْ وٛنِ لَيٛلْ اِنَبٛحِ، اٛنٛنْ نغٛنِ لِشٜ مَاغٛلْ؞ کٛو مٛيٜ جٛوطِيطٛ اٜ جٛکّٛوتِرِ اٜ اَمْ، مِنْ مَا اٜ مِ جٛکّٛوتِرِ اٜ مَاکٛ، اٛ وَرْتَيْ بٛ لِسَلْ دِمَيْنغَلْ ٻِکّٛيْ طُطْکٛيْ؞ نغَمْ تٛ نَاع اٛنْ کَوْتُ اٜ اَمْ، اٛنْ مبَاوَتَا نغَطٛنْ غٛطُّمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","فُو نٜطّٛ مٛ جٛکّٛتِرَايِ اٜ اَمْ، اٜ مٛ نَنْدِ اٜ لِسَلْ ڤٜعِّتَانغَلْ يٛورِ؞ اِرِ نغَلْ طٛنْ لِسَلْ اٜ نغَلْ حٛشّٜىٰ نغَلْ حُبِنٜىٰ ندٜرْ حِيتٜ نغَلْ وُلَ؞ ");
INSERT INTO fuv_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","تٛ اٛنْ نجٛکّٛوتِرِي اٜ اَمْ ندٜنْ بٛلِيطٜ اَمْ اٜ نجٛکّٛوتِرِ اٜ مٛوطٛنْ، تٛرٜىٰ کٛو طُمٜ طُمْ نغِطّٛنْ، طُمْ حٛکَّيْعٛنْ طُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","کٛ تٜدِّنْتَ ݧَاکٛ اَمْ وٛنِ نغَطٛنْ کٛ اٛ يِطِ ندٜ طُطُّمْ؞ کَنْجُمْ حٛلَّتَ اٛنْ تٛکُّٻٜيَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","نٛنْ نٛ ݧَاکٛ مٛ دٛوْ يِطِرِيَمْ، نٛنْ مِنْ مَا اٜ مِ يِطِعٛنْ؞ نجٛوطٜىٰ ندٜرْ يِدّٜ اَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","تٛ اٛنْ نغَطِي کٛ مبِيمِ طُمْ وَطَ، اٛنْ نجٛوطٛتٛ ندٜرْ يِدّٜ اَمْ، نٛنْ نٛ نغَطِرْمِ کٛ ݧَاکٛ اَمْ مٛ دٛوْ وِعِ طُمْ وَطَ نجٛوطِيمِ ندٜرْ يِدّٜ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","‏«‏مِ وِعُعٛنْ طُعُمْ نغَمْ نَنٛنْ بٜلْطُمْ ندٜرْ ٻٜرْطٜ مٛوطٛنْ اِرِ طُمْ اَمْ، ندٜنْ بٜلْطُمْ طُمْ وَرْتَ کٜوْطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","کٛ نغِنْمِ نغَطٛنْ وٛنِ نغِطِنْدِرٛنْ نٛنْ نٛ نغِطِرْمِعٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","وَلَا يِدّٜ ٻُرْندٜ ندٜعٜ، وَاتٛ نٜطّٛ حٛکَّ يٛنْکِ مُوطُمْ نغَمْ حِغٛوٻٜ مُوطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","اٛنٛنْ نغٛنِ حِغٛوٻٜ اَمْ تٛ اٛنْ نغَطِي کٛ مبِيمِ طُمْ وَطَ؞ ");
INSERT INTO fuv_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","مِ فُطِّتَتَا مِ نٛدِّرَعٛنْ مَشُّٻٜ، نغَمْ مَشُّطٛ اَنْدَا کٛ جٜيْطٛمٛ وَطَتَ؞ اَمَّا مِ نٛدِّيعٛنْ حِغٛوٻٜ، نغَمْ مِ اَنْدِنِيعٛنْ کٛو طُمٜ طُمْ نَنْمِ تٛ ݧَاکٛ اَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","نَاع اٛنٛنْ شُٻِيَمْ، مِنْ سُٻِعٛنْ حٛکِّعٛنْ کُوغَلْ نجَحٛنْ نغَطٛنْ غٛطُّمْ طُمْ اَللَّه يِطِ تَبِتَيْطُمْ؞ ندٜنْ ݧَاکٛ مٛ دٛوْ حٛکَّيْعٛنْ کٛو طُمٜ طُمْ تٛرِيطٛنْمٛ ندٜرْ اِنْدٜ اَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","کٛ مبِيمِ نغَطٛنْ وٛنِ، نغِطِندِرٜىٰ؞ ");
INSERT INTO fuv_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","‏«‏تٛ يِمْٻٜ دُونِيَارُ نغَݧِيعٛنْ، اَنْدٜىٰ مِنْ ٻٜ اَرْتِ وَݧُکِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","دَا دُونِيَارُ ندُعُ جٜيِعٛنْ، دَا ندُ يِطَيْعٛنْ نٛ ندُ يِطِرِ ٻٜ مَيْرُ؞ اَمَّا مِ سُٻِيعٛنْ دَغَ ندٜرْ دُونِيَارُ، نغَمْ اٛنٛنْ نَاع طُمْ ٻٜ دُونِيَارُ؞ کَنْجُمْ وَطِ يِمْٻٜ مَيْرُ نغَݧِعٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","ݧُمٜىٰ کٛ مبِينٛومِعٛنْ، ‏‹‏وَلَا مَشُّطٛ ٻُرْطٛ جٜيْطٛمٛ؞›‏ تٛ يِمْٻٜ دُونِيَارُ تٛرِّييَمْ، اٛنٛنْ مَا ٻٜ تٛرَّيْعٛنْ؞ تٛ ٻٜ تٛکِّي اٜکِّتِنٛلْ اَمْ، اٛنٛنْ مَا ٻٜ تٛکَّيْ اٜکِّتِنٛلْ مٛوطٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","اَمَّا ٻٜ نغَطَنَيْعٛنْ فُو فِي طُعُمْ نغَمْ اٛنٛنْ طُمْ ٻٜ اَمْ، نغَمْ ٻٜ اَنْدَا اٛنْ طٛنْ لِلٛيْطٛيَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","دَا مِ وَرَايِ مٜتَنْمِٻٜ، دَا ٻٜ نغَلَا حَکّٜ؞ اَمَّا جٛونِ ٻٜ نغَلَا کٛ ٻٜ مبِعَتَ نغَمْ حَکّٜ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","کٛو مٛيٜ غَݧُطٛيَمْ وَݧِي ݧَاکٛ اَمْ مَا؞ ");
INSERT INTO fuv_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","دَا مِ وَطَايِنٛ کُوطٜ طٜ غٛطّٛ مٜىٰطَايِ وَطُکِ ندٜرْ مَٻّٜ، دَا ٻٜ نغَلَا حَکّٜ؞ اَمَّا جٛونِ ٻٜ نغِعِي کُوطٜ کَيْطِنِيطٜ طٜعٜ، فُو اٜ نٛنْ ٻٜ نغَݧِييَمْ مِنْ اٜ ݧَاکٛ اَمْ مٛ دٛوْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","طُعُمْ طُمْ وَطُ نغَمْ طُمْ حٜبِّنَ کٛ وِنْدَا ندٜرْ اَتَّوْرَ مَٻّٜ، ‏‹‏ٻٜ نغَݧِييَمْ وَلَا دَلِيلَ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","‏«‏بَلَّيْطُمْ وَرَيْ، وَاتٛ رُوحُ اَللَّه کٛلَّيْطُمْ غٛونغَ، طُمْ لِلٛيَيْمِ دَغَ تٛ ݧَاکٛ مٛ دٛوْ؞ تٛ طُمْ وَرِي، طُمْ حٛکَّيْ شٜيْدَ دٛوْ اَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","اٛنٛنْ مَا دٛولٜ کٛکّٛنْ شٜيْدَ دٛوْ اَمْ نغَمْ اٛنْ نغٛنْدِ اٜ اَمْ دَغَ اَرَنْدٜ؞ ");
INSERT INTO fuv_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","‏«‏مِ وِعُ فُو طُعُمْ نغَمْ تٛع اَلٛنْ حٛولَاکِيَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","طُمْ رِيوَيْعٛنْ دَغَ ندٜرْ لٜݧٛلْ؞ غٛونغَ، شَرٜلْ اٜ وَرَ نغٜلْ کٛو مٛيٜ بَرْطٛعٛنْ ݧُمَيْ اَللَّه حُوَنْتَ؞ ");
INSERT INTO fuv_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","يِمْٻٜ نغَطَنَيْعٛنْ نٛنْ نغَمْ ٻٜ اَنْدَا ݧَاکٛ مٛ دٛوْ، ٻٜ اَنْدَايَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","اَمَّا مِ وِعُعٛنْکَ نغَمْ تٛ شَرٜلْ نغٜلْ وَطِي شِفْتٛرٛنْ کٛ مبِيمِعٛنْ؞ مِ وِعَايِعٛنْکَ دَغَ اَرَنْدٜ نغَمْ اٜ مِ وٛنْدِ اٜ مٛوطٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","‏«‏جٛونِ مِ سٛعّٛتٛ تٛ اٛنْ طٛنْ لِلٛيْطٛيَمْ، فُو اٜ نٛنْ ندٜرْ مٛوطٛنْ وَلَا پَمُطٛيَمْ تٛ نجَحَيْمِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","جٛونِ ٻٜرْطٜ مٛوطٛنْ نغَنِّي نغَمْ مِ وِعِيعٛنْ فُو فِي طُعُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","اَمَّا اٜ مِ وِعَعٛنْ غٛونغَ، نغَمْ ٻٜيْدَارِ مٛوطٛنْ ندِلَّيْمِ؞ نغَمْ تٛ مِ دِلَّايِ، طُمْ طٛنْ بَلَّيْطُمْ وَرَنْتَاعٛنْ؞ اَمَّا تٛ مِ دِلِّي، مِ لِلٛيَيْطُمْ تٛ مٛوطٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","تٛ طُمْ وَرٛيِي، طُمْ حٛلَّيْ يِمْٻٜ دُونِيَارُ ٻٜ ڤَامَايِ بٛطُّمْ کٛ وٛنِ حَکّٜ، اٜ اَادِلَاکُ اَللَّه، اٜ کِيتَ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","ٻٜ ڤَامَايِ کٛ وٛنِ حَکّٜ، نغَمْ ٻٜ کٛولَاکِيَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","ٻٜ ڤَامَايِ کٛ وٛنِ اَادِلَاکُ، نغَمْ مِ سٛعّٛتٛ تٛ ݧَاکٛ مٛ دٛوْ، ندٜنْ اٛنْ ڤُطِّتَتَا نغِعٛنْيَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ٻٜ ڤَامَايِ کٛ وٛنِ کِيتَ اَللَّه، نغَمْ لَامِيطٛ دُونِيَارُ ندُعُ يَادَکٜ تَپَنَامَ کِيتَ؞ ");
INSERT INTO fuv_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","‏«‏اٜ مِ وٛودِ فِي طُطُّمْ طُمْ نغِطُمِ وِيکِعٛنْ، اَمَّا جٛونِ طُمْ تٜدَّنَيْعٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","اَمَّا شَرٜلْ نغٜلْ رُوحُ اَللَّه کٛلَّيْطُمْ غٛونغَ وَرِي، طُمْ اَنْدِنَيْعٛنْ غٛونغَ فُو؞ طُمْ مٜتَتَا بٛلِيطٜ طٜ حٛورٜ مَاجُمْ، کٛ طُمْ نَنِ تَنْ طُمْ مٜتَتَ، ندٜنْ طُمْ وِعَيْعٛنْ کٛ وَطَتَ يٜىٰسٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","رُوحُ طُمْ حٛشَّيْ کٛ مبِيمِ طُمْ وِعَعٛنْکَ، نٛنْ طُمْ حٛلِّرْتَ تٜدُّنغَلْ اَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","فُو کٛ ݧَاکٛ مٛ دٛوْ وٛودِ، مِنْ جٜيِطُمْ؞ کَنْجُمْ وَطِ مبِيمِ رُوحُ مَاکٛ حٛشَّيْ کٛ مبِيمِ طُمْ وِعَعٛنْکَ؞ ");
INSERT INTO fuv_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","‏«‏يٜىٰسٛ طٛعٛ سٜطَّ اٛنْ نغِعَتَايَمْ، ندٜنْ غَطَ شَرٜلْ سٜطَّ اٛنْ نغِعَيْيَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","وٛٻّٜ ندٜرْ تٛکُّٻٜمٛ نغَطِ کَ پَمْپَمْتِرْکِ اٜ ٻٜ مبِعَ، ‏«‏کٛ اٛ يِطِ وِيکِ ندٜ اٛ وِعِعٜنْ يٜىٰسٛ طٛعٛ سٜطَّ اٜنْ نغِعَتَامٛ، ندٜنْ غَطَ شَرٜلْ سٜطَّ اٜنْ نغِعَيْمٛ؟ کَدِنْ اٛ وِعِ نغَمْ اٛ يَحَيْ تٛ ݧَاکٛ مٛ دٛوْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","ٻٜ مبِعِ، ‏«‏کٛ اٛ يِطِ وِيکِ ندٜ اٛ وِعِ، ‏‹‏شَرٜلْ سٜطَّ؟›‏ اٜنْ اَنْدَا کٛ اٛ يِطِ وِيکِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","يٜىٰسُ اٜ اَنْدِ اٜ ٻٜ نغِطِ ٻٜ پَمَمٛ دٛوْ مَاجُمْ، نغَمْ نٛنْ اٛ وِعِٻٜ، ‏«‏اٛنْ مٜدَّ حَکُّندٜ مٛوطٛنْ دٛوْ مَعَنَ کٛ مبِيمِ ندٜ مبِيمِ، ‏‹‏يٜىٰسٛ طٛعٛ اٛنْ نغِعَتَايَمْ، ندٜنْ غَطَ شَرٜلْ سٜطَّ اٛنْ نغِعَيْيَمْ؟›‏ ");
INSERT INTO fuv_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","اٜ مِ وِعَعٛنْ غٛونغَ، اٛنْ مبٛيَيْ، اٛنْ نغَنَّيْ، اَمَّا يِمْٻٜ دُونِيَارُ مبٜلْمبٜلْتَيْ؞ اٛنْ نَنَيْ نَوْطُمْ ٻٜرْندٜ، اَمَّا نَوْطُمْ ٻٜرْندٜ ندٜنْ وَرْتَيْ بٜلْطُمْ ٻٜرْندٜ؞ ");
INSERT INTO fuv_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","شَرٜلْ نغٜلْ دٜبّٛ دَݧَتَ اٛ نَنَيْ نَوْطُمْ، نغَمْ شَرٜلْ يَرْکِ بٛنٜ مَاکٛ وَرِي؞ اَمَّا تٛ اٛ دَݧِي ٻِنْغٜلْ مَاکٛ، اٛ يٜجِّتَيْ تٛرَّ کَ اٛ يَرِ، نغَمْ نَنْکِ بٜلْطُمْ ٻِنْغٜلْ دَݧَامَ ندٜرْ دُونِيَارُ؞ ");
INSERT INTO fuv_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","نٛنْ طُمْ وٛنِ تٛ مٛوطٛنْ؞ جٛونِ طُمْ شَرٜلْ نغٜلْ نَنٛتٛنْ نَوْطُمْ ٻٜرْندٜ، اَمَّا مِ فُطِّتَيْ مِ يِعَعٛنْ، ندٜنْ اٛنْ مبٜلْمبٜلْتَيْ؞ وَلَا بَاوَيْطٛ اِتَّنَعٛنْ بٜلْطُمْ ٻٜرْندٜ؞ ");
INSERT INTO fuv_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","‏«‏اٜ ندٜنْ طٛنْ ݧَلْندٜ، اٛنْ تٛرَتَاکٛيَمْ غٛطُّمْ؞ اٜ مِ وِعَعٛنْ غٛونغَ، کٛو طُمٜ طُمْ تٛرِيطٛنْ ݧَاکٛ مٛ دٛوْ ندٜرْ اِنْدٜ اَمْ، اٛ حٛکَّيْعٛنْ طُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","حَا جٛونِ اٛنْ تٛرَاکِ غٛطُّمْ ندٜرْ اِنْدٜ اَمْ؞ تٛرٜىٰ اٛنْ کٜٻَيْ، نغَمْ وٜلْوٜلٛ مٛوطٛنْ حٜىٰوَ؞ ");
INSERT INTO fuv_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","‏«‏مِ حُوتِرِي مِسَالُ مِ وِعِيعٛنْ فُو طُعُمْ؞ اَمَّا شَرٜلْ اٜ وَرَ نغٜلْ مِ مٜتِرَنْتَاعٛنْ مِسَالُ، اَمَّا مِ مٜتَنَيْعٛنْ اٜ نجَيْرِ دٛوْ ݧَاکٛ مٛ دٛوْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","اٜ ندٜنْ طٛنْ ݧَلْندٜ اٛنْ تٛرٛتٛ ندٜرْ اِنْدٜ اَمْ؞ مِ وِعَايِعٛنْ مِ تٛرٛتٛمٛ نغَمْ مٛوطٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","نغَمْ ݧَاکٛ مٛ دٛوْ کَنْکٛ اٜ حٛورٜ مَاکٛ اٜ مٛ يِطِعٛنْ؞ اٜ مٛ يِطِعٛنْ نغَمْ اٛنْ نغِطِيَمْ، ندٜنْ اٛنْ کٛولَکٜ دَغَ تٛ مَاکٛ پِوٛيْمِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","مِ پِوٛيِي تٛ مَاکٛ مِ وَرِ دُونِيَارُ، ندٜنْ جٛونِ مِ اَلَيْ دُونِيَارُ مِ پٜىٰݝَيْ تٛ مَاکٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","سٜيْ تٛکُّٻٜ يٜىٰسُ مبِعِمٛ، ‏«‏جٛونِ اَ مٜتَ اٜ نجَيْرِ اَ حُوتِرْتَا مِسَالُ؞ ");
INSERT INTO fuv_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","جٛونِ اٜ مِنْ اَنْدِ اَ اَنْدِ کٛو طُمٜ، نَاع نَا غٛطّٛ پَمِيمَ پَمْطٜ؞ طُعُمْ وَطِي مِنْ نجَٻِ دَغَ تٛ اَللَّه پِوٛيْطَا؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","يٜىٰسُ وِعِٻٜ، ‏«‏جٛونِ اٛنْ کٛولَکٜيَمْ؟ ");
INSERT INTO fuv_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","شَرٜلْ اٜ وَرَ نغٜلْ يَادَکٜ نغٜلْ وَرِ نغٜلْ طُمْ سَنْکِتَتَعٛنْ، کٛو مٛيٜ سٛعّٛو وُرٛ مُوطُمْ؞ اٛنْ اَلَيْيَمْ مِنْ تَنْ؞ اَمَّا نَاع طُمْ مِنْ تَنْ، نغَمْ ݧَاکٛ مٛ دٛوْ اٜ وٛنْدِ اٜ اَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","مِ وِعُعٛنْ طُعُمْ نغَمْ کٜٻٛنْ بٜلْطُمْ ٻٜرْندٜ بَرْکَ سُمْڤٛوتِرْکِ اٜ اَمْ؞ ندٜرْ دُونِيَارُ ندُعُ اٛنْ نجَرَيْ تٛرَّ؞ اَمَّا تٛع اٛنْ نغَنُّ، مِ حٜٻِي جَالٛرْغَلْ دٛوْ دُونِيَارُ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","غَطَ يٜىٰسُ يٛتِّنِي وِيکِ بٛلِيطٜ طٜعٜ، اٛ رَارِ دٛوْ اٛ وِعِ، ‏«‏ݧَاکٛ اَمْ، شَرٜلْ وَرِي؞ مَوْنِنْ ٻِطّٛ مَاطَ، نغَمْ ٻِطّٛ مَاطَ تٜدِّنِيمَ؞ ");
INSERT INTO fuv_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","نغَمْ اَ حٛکِّيمٛ لَامُ دٛوْ يِمْٻٜ فُو، نغَمْ اٛ حٛکَّ فُو ٻٜ کٛکُّطَامٛ يٛنْکِ کِ رٜعَتَا؞ ");
INSERT INTO fuv_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","يٛنْکِ کِ رٜعَتَا وٛنِ ٻٜ اَنْدُمَا، اَنْ تَنْ وٛنِ اَللَّه غٛونغَاجٛ، ندٜنْ ٻٜ اَنْدَ يٜىٰسُ اَلْمَسِيحُ مٛ لِلٛيْطَا؞ ");
INSERT INTO fuv_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","مِ تٜدِّنِيمَ ندٜرْ دُونِيَارُ، مِ يٛتِّنِي کُوغَلْ نغَلْ کٛکُّطَايَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","ݧَاکٛ اَمْ، جٛونِ تٜدِّنَمْ يٜىٰسٛ مَاطَ تٜدُّنغَلْ نغَلْ نغٛودُنٛومِ يٜىٰسٛ مَاطَ کٛ دُونِيَارُ تَغٜىٰ؞ ");
INSERT INTO fuv_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","‏«‏مِ اَنْدِنِي حَبَرُ مَاطَ تٛ ٻٜنْ طٛنْ ٻٜ کٛکُّطَايَمْ دَغَ ندٜرْ دُونِيَارُ؞ اَنْ جٜيِٻٜ، ندٜنْ اَ حٛکِّييَمْٻٜ، کَدِنْ اٜ ٻٜ تٛکِّ وٛلْدٜ مَاطَ؞ ");
INSERT INTO fuv_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","جٛونِ اٜ ٻٜ اَنْدِ کٛو طُمٜ طُمْ کٛکُّطَايَمْ تٛ مَاطَ طُمْ پِوٛيِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","مِ وِعِيٻٜ بٛلِيطٜ طٜ مبِيطَايَمْ، ٻٜ بٛو نجَٻِيطٜ؞ ٻٜ اَنْدِي طُمْ غٛونغَ تٛ مَاطَ پِوٛيْمِ، ندٜنْ ٻٜ کٛولَکٜ اَنْ لِلٛيِيَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","‏«‏اٜ مِ وَطَنَٻٜ دٛعَارٜ؞ نَاع يِمْٻٜ دُونِيَارُ نغَطَنَيْمِ دٛعَارٜ، اَمَّا ٻٜنْ طٛنْ ٻٜ کٛکُّطَايَمْ، نغَمْ اَنْ جٜيِٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","فُو ٻٜ نغٛودُمِ اَنْ جٜيِٻٜ، ندٜنْ فُو ٻٜ نغٛودُطَا مِنْ جٜيِٻٜ، ندٜنْ مِ تٜدِّنَامَ بَرْکَ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","جٛونِ نَاع کٛ نٜىٰٻِ مِ اَلَيْ دُونِيَارُ مِ وَرٛيَ تٛ مَاطَ، اَمَّا کَمْٻٜ اٜ ٻٜ ندٜرْ دُونِيَارُ؞ ݧَاکٛ اَمْ شٜنِيطٛ، سُرِرْٻٜ بَوْطٜ اِنْدٜ مَاطَ، اِنْدٜ ندٜ کٛکُّطَايَمْ، نغَمْ ٻٜ نغَرْتَ غٛعٛ نٛنْ نٛ اَنْ اٜ مِنْ اٜنْ غٛعٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","کٛ نغٛنْدُنٛومِ اٜ مَٻّٜ مِ سُرِرِيٻٜ بَوْطٜ اِنْدٜ مَاطَ، اِنْدٜ ندٜ کٛکُّطَايَمْ؞ مِ رٜىٰنِيٻٜ، وَلَا کٛو غٛعٛتٛ مَٻّٜ مَجُّطٛ، سٜيْ نِ نٜطّٛ کَلْکَتٜىٰطٛ نغَمْ کٛ اَايَارٜ وِعِ حٜىٰوَ؞ ");
INSERT INTO fuv_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","جٛونِ اٜ مِ وَرٛيَ تٛ مَاطَ؞ مِ وِعُ فُو طُعُمْ شَرٜلْ نغٜعٜلْ نغٜلْ نغٛنْمِ ندٜرْ دُونِيَارُ نغَمْ ٻٜ نَنَ اِرِ بٜلْطُمْ ٻٜرْندٜ طُمْ نَنَيْمِ ٻٜ نَنَ طُمْ کٜوْطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","مِ وِعِيٻٜ وٛلْدٜ مَاطَ؞ دُونِيَارُ وَݧِيٻٜ، نغَمْ نَاع دُونِيَارُ جٜيِٻٜ، نٛنْ نٛ مِنْ مَا نَاع دُونِيَارُ جٜيِيَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","نَاع اٜ مِ تٛرٛمَا نغَمْ اِتَّاٻٜ ندٜرْ دُونِيَارُ، اَمَّا اٜ مِ تٛرٛمَا نغَمْ شُرَاٻٜ دَغَ اٛنْ طٛنْ کَلُّطٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","دُونِيَارُ جٜيَايِٻٜ نٛنْ نٛ مِنْ مَا دُونِيَارُ جٜيَايِيَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","وَرْتِرْٻٜ يِمْٻٜ مَاطَ لَاوٛلْ غٛونغَ مَاطَ؞ وٛلْدٜ مَاطَ وٛنِ غٛونغَ؞ ");
INSERT INTO fuv_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","نٛنْ نٛ لِلِرٛيْطَايَمْ ندٜرْ دُونِيَارُ، مِنْ مَا مِ لِلِيٻٜ ندٜرْ دُونِيَارُ؞ ");
INSERT INTO fuv_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","مِ حٛکِّيمَ حٛورٜ اَمْ نغَمْ مَٻّٜ، نغَمْ کَمْٻٜ مَا ٻٜ کٛکُّمَا کٛعٜ مَٻّٜ اٜ غٛونغَ؞ ");
INSERT INTO fuv_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","‏«‏نَاع کَمْٻٜ تَنْ نغَطَنَيْمِ دٛعَارٜ، اَمَّا فُو اٜ ٻٜنْ طٛنْ کٛولٛتٛوٻٜيَمْ لَاوٛلْ وَعَجُ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","اٜ مِ وَطَ دٛعَارٜ ٻٜ فُو مَٻّٜ ٻٜ نغَرْتَ غٛعٛ؞ ݧَاکٛ اَمْ اٜ مِ تٛرٛمَا، ٻٜ کٜٻَ ٻٜ شُمْڤٛوتِرَ اٜ مٜىٰطٜنْ نٛنْ نٛ شُمڤٛوتِرْتٜنْ، نغَمْ دُونِيَارُ جَٻَ اَنْ لِلٛيِيَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","مِ حٛکِّيٻٜ تٜدُّنغَلْ اِرِ نغَلْ کٛکُّطَايَمْ، نغَمْ ٻٜ نغَرْتَ غٛعٛ، نٛنْ نٛ مِنْ اٜ اَنْ اٜنْ غٛعٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","اٜ مِ سُمْڤٛوتِرَ اٜ مَٻّٜ ندٜنْ اٜنْ شُمْڤٛوتِرَ نغَمْ ٻٜ نغَرْتَ غٛعٛ ندٜرْ کٛو طُمٜ، نغَمْ دُونِيَارُ اَنْدَ اَنْ لِلِيَمْ، کَدِنْ اَ يِطِٻٜ نٛنْ نٛ نغِطِرْطَايَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","‏«‏يَا ݧَاکٛ اَمْ مٛ دٛوْ، اٜ مِ يِطِ ٻٜنْ طٛنْ ٻٜ کٛکُّطَايَمْ ٻٜ نغٛنْدَ اٜ اَمْ تٛ نغٛنْمِ، ٻٜ نغِعَ تٜدُّنغَلْ اَمْ، تٜدُّنغَلْ نغَلْ کٛکُّطَايَمْ نغَمْ اَ يِطِيَمْ کٛ دُونِيَارُ تَغٜىٰ؞ ");
INSERT INTO fuv_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","يَا ݧَاکٛ اَمْ اَادِلِيجٛ، يِمْٻٜ دُونِيَارُ اَنْدَامَ، اَمَّا مِنْ اٜ مِ اَنْدُمَا، ندٜنْ اٜ ٻٜ اَنْدِ اَنْ لِلٛيِيَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","مِ اَنْدِنِيٻٜ حَبَرُ مَاطَ، ندٜنْ مِ ݧَمْرَيْ يٜىٰسٛ اٜ اَنْدِنْکِ حَبَرُ مَاطَ، نغَمْ يِدّٜ ندٜ کٛلَّتَايَمْ جٛوطٛو ندٜرْ ٻٜرْطٜ مَٻّٜ، ندٜنْ مِنْ اٜ حٛورٜ اَمْ مِ سُمْڤٛوتِرَ اٜ مَٻّٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","غَطَ يٜىٰسُ يٛتِّنِي ندٜعٜ دٛعَارٜ، اٛ دِلِّدِ اٜ تٛکُّٻٜمٛ ٻٜ کُولِ لُغّٜرٜ کِدِرٛنْ؞ ٻٜ نجَحِ وٛنْدٜ وِغٜىٰرٜ غٛودُندٜ نغٜسَ لٜطّٜ جَيْتُنْ، ٻٜ نَتِّ ندٜرْ لٜطّٜ طٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","تٛو، يَحُودَ کٛکِّتِرَيْطٛ يٜىٰسُ اٜ اَنْدِ وِغٜىٰرٜ ندٜنْ، نغَمْ ندٜ طُطُّمْ يٜىٰسُ اٜ حَوْرَ اٜ تٛکُّٻٜمٛ تٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","سٜيْ يَحُودَ يَحِ نغٜسَ کَنْ اٜ اَرْدِي کَوْتَلْ سٛوجِعٜنْ رٛومَ، اٜ وٛٻّٜ تَادِيٻٜ وُرٛ شٜنِينغٛ ٻٜ مَوْٻٜ اَرْدِيٻٜ دِينَ اٜ فَارِسَنْکٛعٜنْ لِلِ؞ اٜ ٻٜ نجٛغِي فِتِلَاجِ، اٜ جَمٜ حِيتٜ، اٜ کٛ طُمْ حٛنِرْتَ؞ ");
INSERT INTO fuv_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","يٜىٰسُ ندٜ اٜ اَنْدِ فُو کٛ حٜٻَتَمٛ، اٛ دَرِي يٜىٰسٛ مَٻّٜ اٛ پَمِٻٜ، اٛ وِعِ، ‏«‏طُمْ مٛيٜ طَٻِّتٛتٛنْ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","ٻٜ مبِعِ، ‏«‏يٜىٰسُ نَجَرَنْکٜىٰجٛ؞»‏ اٛ وِعِٻٜ، ‏«‏طُمْ مِنْ؞»‏ يَحُودَ کٛکِّتِرَيْطٛمٛ بٛو اٜ دَرٛدِي اٜ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","ندٜ يٜىٰسُ وِعِٻٜ، ‏«‏طُمْ مِنْ،»‏ ٻٜ شٛعّٛرِي غَطَ ٻٜ نجَنِ اٜ لٜيْدِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","سٜيْ يٜىٰسُ فُطِّتِ پَمِٻٜ وِعِ، ‏«‏مٛيٜ طَٻِّتٛتٛنْ؟»‏ ٻٜ مبِعِ، ‏«‏يٜىٰسُ نَجَرَنْکٜىٰجٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","اٛ وِعِٻٜ، ‏«‏مِ يَادَکٜ مِ وِعِيعٛنْ طُمْ مِنْ؞ تٛ نِ مِنْ طَٻِّتٛتٛنْ، اَلٜىٰ يِمْٻٜ ٻٜعٜ ندِلَّ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","اٛ وِعُ نٛنْ نغَمْ کٛ اٛ وِعُنٛ حٜىٰوَ، ‏«‏مِ دُلَّايِ کٛو غٛعٛتٛ ندٜرْ ٻٜنْ طٛنْ ٻٜ کٛکُّطَايَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","سِيمَنْ بِيتُرُسْ اٜ وٛودِ کَافَحِ، سٜيْ سٛلْتِکِ فٜعِّ مَشُّطٛ مَوْطٛ مَوْٻٜ اَرْدِيٻٜ دِينَ اِتَّنِمٛ نٛوْرُ ݧَامٛ؞ اِنْدٜ مَشُّطٛ اٛنْ مَلْکُسْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","سٜيْ يٜىٰسُ وِعِ بِيتُرُسْ، ‏«‏وَتُّ کَافَحِ مَاطَ ندٜرْ حٛلْغٛ مَاکِ؞ اَ ݧُمَ مِ يَرَتَا جَرْدُغٜلْ تٛرَّ کَ ݧَاکٛ اَمْ حٛکَّتَيَمْ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","سٜيْ سٛوجِعٜنْ رٛومَ اٜ اَرْدِيطٛٻٜ اٜ تَادِيٻٜ وُرٛ شٜنِينغٛ نَنْغِ يٜىٰسُ، ٻٜ کَٻِّمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","اَرَنْدٜ ٻٜ نجَارِمٛ تٛ حَنَانَ اٜسِرَاوٛ کَيَافَ؞ کَيَافَ اٛنْ وٛنِ مَوْطٛ مَوْٻٜ اَرْدِيٻٜ دِينَ اٜ طُنْ طٛنْ ندُنْغُ؞ ");
INSERT INTO fuv_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","کَنْکٛ وٛنِ کٛکُّطٛ اَرْدِيٻٜ يَحُودَنْکٛعٜنْ شَاوٛرِ وِيکِ، طُمْ ٻُرِي نٜطّٛ غٛعٛتٛ مَايَ نغَمْ کٛو مٛيٜ؞ ");
INSERT INTO fuv_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","سِيمَنْ بِيتُرُسْ اٜ غٛطّٛ تٛکُّطٛ يٜىٰسُ ٻٜ تٛکِّ يٜىٰسُ؞ ندٜ اٛنْ طٛنْ تٛکُّطٛ يٜىٰسُ غٛعٛتٛ اٛنْ مَوْطٛ مَوْٻٜ اَرْدِيٻٜ دِينَ اٜ اَنْدِمٛ، سٜيْ اٛ يَادِ اٜ يٜىٰسُ تٛ نجَيْرِ وُرٛ مَوْطٛ مَوْٻٜ اَرْدِيٻٜ دِينَ اٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","اَمَّا بِيتُرُسْ دَرِي يَاسِ تٛ دَمُّغَلْ وُرٛ نغٛنْ؞ سٜيْ اٛنْ طٛنْ تٛکُّطٛ يٜىٰسُ مٛ مَوْطٛ مَوْٻٜ اَرْدِيٻٜ دِينَ اَنْدِ، اٛ وُرْتِي يَاسِ، اٛ مٜتَنِ دٜبّٛ ڤَامَنٛووٛ دَمُّغَلْ نغَلْ، اٛ نَتِّنِ بِيتُرُسْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","سٜيْ دٜبّٛ ڤَامَنٛووٛ دَمُّغَلْ اٛنْ وِعِ بِيتُرُسْ، ‏«‏اَنْ، نَاع اَ غٛعٛتٛ ندٜرْ تٛکُّٻٜ اٛنْ طٛنْ نٜطّٛ؟»‏ بِيتُرُسْ وِعِ، ‏«‏کٛو سٜطَّ، نَاع مِ تٛکُّطٛمٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","اٜ شَرٜلْ نغٜلْ اٜ وٛودِ ڤٜىٰوٛلْ، نغَمْ نٛنْ مَشُّٻٜ اٜ تَادِيٻٜ وُرٛ شٜنِينغٛ کُٻِّ حِيتٜ، اٜ ٻٜ ڤِلِينغٜ، اٜ ٻٜ اِرْفٛو؞ سٜيْ بِيتُرُسْ کَنُمْ مَا ٻَدِّي دَرِي ندٜرْ مَٻّٜ اٜ اِرْفٛو؞ ");
INSERT INTO fuv_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","سٜيْ مَوْطٛ مَوْٻٜ اَرْدِيٻٜ دِينَ پَمِ يٜىٰسُ دٛوْ تٛکُّٻٜمٛ اٜ دٛوْ اٜکِّتِنٛلْ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","يٜىٰسُ وِعِمٛ، ‏«‏کٛو ندٜيٜ اٜ مِ مٜتَنَ کٛو مٛيٜ اٜ نجَيْرِ؞ کٛو ندٜيٜ اٜ مِ اٜکِّتِنَ اٜکِّتِنٛلْ اَمْ ندٜرْ شُوطِ دٛعَارٜ اٜ ندٜرْ وُرٛ شٜنِينغٛ تٛ فُو يَحُودَنْکٛعٜنْ کَوْرَتَ؞ مِ مٜىٰطَايِ وِيکِ غٛطُّمْ اٜ سُوطٜ؞ ");
INSERT INTO fuv_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","نغَمْ طُمٜ پَمَتَايَمْ پَمْطٜ طٜعٜ؟ پَمُ يِمْٻٜ نَنْٻٜ اٜکِّتِنٛلْ اَمْ؞ غٛونغَ اٜ ٻٜ اَنْدِ کٛ مبِيمِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","ندٜ يٜىٰسُ وِعِ نٛنْ، غٛعٛتٛ ندٜرْ تَادِيٻٜ دَرِيطٛ حَادٜ مَاکٛ حٜلِّمٛ تٛ وٛلٛ، وِعِ، ‏«‏نٛنْ مٜتِرَنْتَا مَوْطٛ مَوْٻٜ اَرْدِيٻٜ دِينَ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","يٜىٰسُ وِعِمٛ، ‏«‏تٛ نِ مِ وِعِي غٛطُّمْ طُمْ حَانَا، وِعُکَ کٛو مٛيٜ طٛعٛ؞ اَمَّا تٛ کٛ مبِيمِ طُمْ غٛونغَ، نغَمْ طُمٜ کٜلُّطَايَمْ تٛ وٛلٛ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","سٜيْ حَنَانَ وَطِ طُمْ سٛعِّ يٜىٰسُ تٛ کَيَافَ مَوْطٛ مَوْٻٜ اَرْدِيٻٜ دِينَ، اٜ مٛ حَٻِّي؞ ");
INSERT INTO fuv_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","بِيتُرُسْ اٜ دَرِي طٛنْ اٜ اِرْفٛو، سٜيْ وٛٻّٜ مبِعِمٛ، ‏«‏اَنْ مَا، نَاع اَ غٛعٛتٛ ندٜرْ تٛکُّٻٜ اٛنْ طٛنْ نٜطّٛ؟»‏ اَمَّا بِيتُرُسْ يٜدِّ وِعِ، ‏«‏نَاع مِ تٛکُّطٛمٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","غٛعٛتٛ ندٜرْ مَشُّٻٜ مَوْطٛ مَوْٻٜ اَرْدِيٻٜ دِينَ بَنْدِرَاوٛ نٜطّٛ مٛ بِيتُرُسْ اِتَّنِ نٛوْرُ اٛ وِعِ بِيتُرُسْ، ‏«‏نَاع مِ يِيدِيمَ اٜ مَاکٛ تٛنْ ندٜرْ نغٜسَ لٜطّٜ جَيْتُنْ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","بِيتُرُسْ فُطِّتِ وِعِ، ‏«‏نَاع طُمْ مِنْ؞»‏ اٜ مٛ وِعَکَ نجَکَرْدِ حَنِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","سٜيْ يَحُودَنْکٛعٜنْ کٛشِّ يٜىٰسُ دَغَ وُرٛ کَيَافَ ٻٜ نجَارِمٛ لَامٛرْدٜ غٛمْنَاجٛ رٛومَنْکٜىٰجٛ؞ اٜ شَرٜلْ نغٜلْ طُمْ اِلَا سُبَکَ؞ اَرْدِيٻٜ يَحُودَنْکٛعٜنْ نَتَّايِ لَامٛرْدٜ ندٜنْ، نغَمْ تٛع ٻٜ نغَرْتَ ٻٜ لَاٻَا، ٻٜ کَطٜىٰ ݧَامُکِ ݧَمْندُ حُمْتٛ سَکِّنْکِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","نغَمْ نٛنْ، بِلَاتُسْ وُرْتِي يَحِ تٛ مَٻّٜ پَمِٻٜ، وِعِ، ‏«‏طُمٜ نغُلّٛرْتٛوطٛنْ نٜطّٛ اٛعٛ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","ٻٜ مبِعِمٛ، ‏«‏دَا نَاع اٛ غَطٛووٛ کٛ حَلِّ، دَا مِنْ نغَدَّايِمٛ تٛ مَاطَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","بِلَاتُسْ وِعِٻٜ، ‏«‏اٛنٛنْ اٜ کٛعٜ مٛوطٛنْ کٛشّٜىٰمٛ نغَطَنٛنْمٛ کِيتَ نٛ دٛوکَ مٛوطٛنْ وِعِ؞»‏ ٻٜ مبِعِمٛ، ‏«‏اٛنٛنْ رٛومَنْکٛعٜنْ اٛنْ اَلَتَامِنْ مِنْ تَپَنَ غٛطّٛ کِيتَ مَيْدٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","طُعُمْ وَطُ نغَمْ طُمْ حٜبِّنَ کٛ يٜىٰسُ وِعُنٛ دٛوْ اِرِ مَيْدٜ ندٜ مَايَتَ؞ ");
INSERT INTO fuv_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","سٜيْ بِلَاتُسْ سٛعِّي ندٜرْ لَامٛرْدٜ، اٛ نٛدِّ يٜىٰسُ، اٛ پَمِمٛ اٛ وِعِ، ‏«‏اَنْ وٛنِ لَامِيطٛ يَحُودَنْکٛعٜنْ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","يٜىٰسُ نٛوتِي، وِعِ، ‏«‏نغٛعٛلْ پَمٛلْ تٛ مَاطَ نغٛلْ پِوِ، کٛو وٛٻّٜ کٛکُّمَا حَبَرُ اَمْ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","بِلَاتُسْ وِعِ، ‏«‏اَ ݧُمَ مِ يَحُودَنْکٜىٰجٛ؟ طُمْ لٜݧٛلْ مَاطَ اٜ مَوْٻٜ اَرْدِيٻٜ دِينَ نغَدُّمَا تٛ اَمْ؞ طُمٜ نغَطُطَا؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","يٜىٰسُ وِعِ، ‏«‏لَامُ اَمْ نَاع دَغَ ندُعُ دُونِيَارُ طُمْ پِوٛيِ؞ دَا لَامُ اَمْ دَغَ مَيْرُ طُمْ پِوٛيِ، دَا تٛکُّٻٜيَمْ کٛنَيْ نغَمْ ٻٜ کَطَ طُمْ نَنْغَيَمْ طُمْ وَطَيَمْ ندٜرْ جُوطٜ اَرْدِيٻٜ يَحُودَنْکٛعٜنْ؞ اَمَّا لَامُ اَمْ نَاع دَغَ ندُعُ دُونِيَارُ طُمْ پِوٛيِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","سٜيْ بِلَاتُسْ پَمِمٛ وِعِ، ‏«‏تٛو، اَنْ، اَ لَامِيطٛ وٛنْ طٛنْ؟»‏ يٜىٰسُ نٛوتِي، وِعِ، ‏«‏اَ وِعِي مِ لَامِيطٛ؞ نغَمْ طُعُمْ طُمْ دَݧِيَمْ، ندٜنْ نغَمْ مَاجُمْ نغَرْمِ ندٜرْ دُونِيَارُ نغَمْ مِ مٜتَ دٛوْ کٛ وٛنِ غٛونغَ؞ کٛو مٛيٜ غِطّٛ غٛونغَ تٛکَّيْ کٛ مبِيمِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","بِلَاتُسْ پَمِمٛ وِعِ، ‏«‏طُمٜ وٛنِ غٛونغَ؟»‏ غَطَ بِلَاتُسْ وِعِي نٛنْ فُطِّتِ وُرْتِي يَاسِ تٛ يَحُودَنْکٛعٜنْ وِعِٻٜ، ‏«‏مِ تَوْرَايِمٛ غٛطُّمْ کَلُّطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","اَمَّا طُمْ ندٛنُ مٛوطٛنْ مِ يٛوفَنَعٛنْ شُرَاطٛ غٛعٛتٛ شَرٜلْ حُمْتٛ سَکِّنْکِ؞ اٛنْ نغِطِ مِ يٛوفَنَعٛنْ لَامِيطٛ يَحُودَنْکٛعٜنْ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","ٻٜ نٛوتِي ٻٜ مبِعِ اٜ سٜمْبٜ، ‏«‏نَاع اٛعٛ نجٛوفَنْتَامِنْ، يٛوفَنْمِنْ بَرَبَّسْ!‏»‏ بَرَبَّسْ اٛنْ بٛو اٛ غٛعٛتٛ ندٜرْ کَٻْدٛوٻٜ اٜ لَامُ؞ ");
INSERT INTO fuv_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","سٜيْ بِلَاتُسْ وَطِ يٜىٰسُ فِيَا لٛوشِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","سٛوجِعٜنْ مبَالِ غِيفٛلْ غِعٜ، ٻٜ تَارَنِمٛنغٛلْ تٛ حٛورٜ، ندٜنْ ٻٜ ٻٛرْنِمٛ اِرِ تٛغّٛورٜ لَامِيٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ٻٜ نغَطِ کَ يَاکِ يٜىٰسٛ مَاکٛ، اٜ ٻٜ مبِعَ، ‏«‏اَللَّه رٜىٰنٜ، لَامِيطٛ يَحُودَنْکٛعٜنْ!‏»‏ ندٜنْ اٜ ٻٜ ڤِيَمٛ تٛ يٜىٰسٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","بِلَاتُسْ فُطِّتِ وُرْتِي يَاسِ وِعِ يَحُودَنْکٛعٜنْ، ‏«‏ندَارٜىٰ، مِ وُرْتِنَنَيْعٛنْ مٛ طٛعٛ نغَمْ اَنْدٛنْ مِ تَوْرَايِمٛ غٛطُّمْ کَلُّطُمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","ندٜ يٜىٰسُ وُرْتِنَا اٜ تَارَنَا غِيفٛلْ غِعٜ تٛ حٛورٜ ندٜنْ اٜ ٻٛرْنِي تٛغّٛورٜ اِرِ ندٜ لَامِيٻٜ، سٜيْ بِلَاتُسْ وِعِٻٜ، ‏«‏رَا نٜطّٛ اٛنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","ندٜ مَوْٻٜ اَرْدِيٻٜ دِينَ اٜ تَادِيٻٜ وُرٛ شٜنِينغٛ نغِعِمٛ، ٻٜ مبِعِ اٜ سٜمْبٜ، ‏«‏وَرُمٛ!‏ وَرُمٛ دٛوْ غَافَانغَلْ!‏»‏ اَمَّا بِلَاتُسْ وِعِٻٜ، ‏«‏اٛنٛنْ کٛشّٜىٰمٛ مبَرٛنْمٛ؞ مِنْ مِ تَوْرَايِمٛ غٛطُّمْ کَلُّطُمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","سٜيْ يَحُودَنْکٛعٜنْ مبِعِمٛ، ‏«‏اٜ مِنْ نغٛودِ دٛوکَ، کَدِنْ نٛنْ نٛ دٛوکَ طُمْ وِعِ دٛولٜ اٛ وَرٜىٰ، نغَمْ اٜ مٛ وِعَ کَنْکٛ وٛنِ ٻِطّٛ اَللَّه؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","ندٜ بِلَاتُسْ نَنِ نٛنْ، سٜيْ کُلٛلْ ٻٜيْدِ نَنْغُکِمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","سٜيْ اٛ سٛعِّي ندٜرْ لَامٛرْدٜ اٛ پَمِ يٜىٰسُ اٛ وِعِ، ‏«‏تٛيٜ پِوٛيْطَا؟»‏ اَمَّا يٜىٰسُ نٛوتَاکِمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","بِلَاتُسْ وِعِمٛ، ‏«‏اَ وَݧُ مٜتَنْکِيَمْ؟ اَ اَنْدَا اٜ مِ وٛودِ لَامُ مِ يٛوفُمَا، کَدِنْ اٜ مِ وٛودِ لَامُ مِ وَطَ طُمْ وَرُمَا دٛوْ غَافَانغَلْ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","يٜىٰسُ نٛوتِي وِعِ، ‏«‏اَ وَلَا لَامُ دٛوْ اَمْ تٛ نَاع جٛومِرَاوٛ حٛکُّمَا؞ نغَمْ نٛنْ، نٜطّٛ غَطُطٛيَمْ ندٜرْ جُنْغٛ مَاطَ وَطِي حَکّٜ ٻُرْطُمْ حَلُّکِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","ندٜ بِلَاتُسْ نَنِ نٛنْ، اٛ طَٻِّتِ لَاوٛلْ نٛ اٛ يٛوفِرْتَ يٜىٰسُ، اَمَّا يَحُودَنْکٛعٜنْ نغَطِ کَ وِيکِ اٜ سٜمْبٜ، ‏«‏تَا يٛوفِي نٜطّٛ اٛعٛ، نَاع اَ حِغٛ کَيْسَرْ!‏ فُو نٛدِّرٛووٛ حٛورٜ مُوطُمْ لَامِيطٛ اٛ غَݧٛ کَيْسَرْ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","ندٜ بِلَاتُسْ نَنِ حَالَ کَعَ، اٛ وُرْتِنِ يٜىٰسُ، اٛ جٛوطِي دٛوْ جٛوطٛرْغَلْ کِيتَ تٛ وِغٜىٰرٜ بِعٜتٜىٰندٜ ‏«‏حَيْرٜ شٜحَاندٜ؞»‏ ندٜرْ اِبْرَانِيَنْکٛورٜ وِغٜىٰرٜ ندٜنْ اٜ نٛدِّرٜىٰ غَبَّاتَ؞ ");
INSERT INTO fuv_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","اٜ شَرٜلْ نغٜلْ طُمْ شَکَ ݧَلَوْمَ ݧَلْندٜ سِرْيَاکِ حُمْتٛ سَکِّنْکِ؞ بِلَاتُسْ وِعِ يَحُودَنْکٛعٜنْ ٻٜنْ، ‏«‏رَا لَامِيطٛ مٛوطٛنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","ٻٜ مبِعِ بِلَاتُسْ اٜ سٜمْبٜ، ‏«‏وَرُمٛ!‏ وَرُمٛ دٛوْ غَافَانغَلْ!‏»‏ بِلَاتُسْ وِعِٻٜ، ‏«‏اٛنْ نغِطِ مِ وَرَ لَامِيطٛ مٛوطٛنْ دٛوْ غَافَانغَلْ؟»‏ سٜيْ مَوْٻٜ اَرْدِيٻٜ دِينَ نٛوتِي مبِعِ، ‏«‏مِنْ نغَلَا غٛطّٛ لَامِيطٛ سٜيْ کَيْسَرْ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","سٜيْ بِلَاتُسْ وَطِ يٜىٰسُ ندٜرْ جُوطٜ مَٻّٜ نغَمْ ٻٜ مبَرَمٛ دٛوْ غَافَانغَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","سٜيْ ٻٜ ندِلِّدِ اٜ يٜىٰسُ، اٜ مٛ وَکِّي غَافَانغَلْ مَاکٛ اٜ حٛورٜ مَاکٛ؞ ٻٜ مبُرْتِي يَاسِ غَرِيرِ يَاکِ وِغٜىٰرٜ بِعٜتٜىٰندٜ وِغٜىٰرٜ پِپَلْ حٛورٜ؞ ندٜرْ اِبْرَانِيَنْکٛورٜ وِغٜىٰرٜ ندٜنْ اٜ نٛدِّرٜىٰ غٛلْغٛوتَ؞ ");
INSERT INTO fuv_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","تٛ وِغٜىٰرٜ ندٜنْ ٻٜ ڤِيَنِ يٜىٰسُ کُوسَاجٜ دٛوْ غَافَانغَلْ حَوْتِ اٜ يِمْٻٜ طِطٛ؞ ٻٜ ٻِلِ غٛعٛتٛ اٜ غَافَانغَلْ جُنْغٛ يٜىٰسُ ݧَامٛ، ندٜنْ غٛعٛتٛ اٜ غَافَانغَلْ جُنْغٛ يٜىٰسُ نَنٛ، يٜىٰسُ اٜ شَکَ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","بِلَاتُسْ وِنْدِ دٛوْ اَلّٛوَلْ اٛ وَطِ طُمْ تَکِّنغَلْ حٛورٜ غَافَانغَلْ يٜىٰسُ؞ کٛ اٛ وِنْدِ وٛنِ، ‏«‏يٜىٰسُ نَجَرَنْکٜىٰجٛ لَامِيطٛ يَحُودَنْکٛعٜنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","يَحُودَنْکٛعٜنْ طُطْٻٜ نجَنْغِ کٛ اٛ وِنْدِ، نغَمْ وِغٜىٰرٜ تٛ يٜىٰسُ وَرَا حَادٜ غَرِيرِ وٛنِ؞ کٛ اٛ وِنْدِ اٛ وِنْدُطُمْ ندٜرْ اِبْرَانِيَنْکٛورٜ، اٜ رٛومَنْکٛورٜ، اٜ حٜلٜنَنْکٛورٜ؞ ");
INSERT INTO fuv_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","مَوْٻٜ اَرْدِيٻٜ دِينَ مبِعِ بِلَاتُسْ، ‏«‏تَاع وِنْدُ ‏‹‏لَامِيطٛ يَحُودَنْکٛعٜنْ،›‏ اَمَّا وِنْدُ نٜطّٛ اٛعٛ وِعِي کَنْکٛ وٛنِ لَامِيطٛ يَحُودَنْکٛعٜنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","بِلَاتُسْ وِعِ، ‏«‏کٛ مبِنْدُمِ جٛوطَکٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","غَطَ سٛوجِعٜنْ ٻٜنْ ڤِيَنِي يٜىٰسُ کُوسَاجٜ دٛوْ غَافَانغَلْ، سٜيْ ٻٜ کٛشِّ کٛلْتٜ مَاکٛ، ٻٜ شٜنْدِطٜ شٜنْدٜ نَيِ، کٛو مٛيٜ سٛوجِيجٛ جٛغِي سٜنْدٜرٜ غٛعٛ؞ کَدِنْ ٻٜ کٛشِّ تٛغّٛورٜ مَاکٛ؞ تٛغّٛورٜ ندٜنْ ݧٛعَاکَ ندٜ سَݧَاندٜ دَغَ دٛوْ يَاکِ لٜيْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","سٛوجِعٜنْ ٻٜنْ مبِعِ حَکُّندٜ مَٻّٜ، ‏«‏تٛع اٜنْ شٜىٰکُندٜ، اٜنْ نغَطُ شَاشَ دٛوْ مَيْرٜ نغِعٜنْ مٛيٜ ݧَامَتَندٜ؞»‏ طُعُمْ وَطُ نغَمْ کٛ اَايَارٜ وِعِ حٜىٰوَ:‏ ‏«‏ٻٜ شٜنْدِي کٛلْتٜ اَمْ حَکُّندٜ مَٻّٜ؛ ٻٜ نغَادِي شَاشَ اٜ تٛغّٛورٜ اَمْ؞»‏ طُعُمْ کَنْجُمْ وٛنِ کٛ سٛوجِعٜنْ ٻٜنْ نغَطِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","دَرِيٻٜ حَادٜ غَافَانغَلْ يٜىٰسُ کَمْٻٜ نغٛنِ مَدُوجٛ مَاکٛ، اٜ سَکِرَاوٛ مَدُوجٛ مَاکٛ دٜبّٛ، اٜ مَرْيَامَ دٜبّٛ کِلٛوبَسْ، اٜ مَرْيَامَ پِوٛيْطٛ مَغَدَلَ؞ ");
INSERT INTO fuv_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","ندٜ يٜىٰسُ يِعِ مَدُوجٛ مُوطُمْ اٜ دَرِي طٛنْ اٜ تٛکُّطٛمٛ مٛ اٛ يِطِ نَاع سٜطَّ؞ سٜيْ اٛ وِعِ مَدُوجٛ مَاکٛ، ‏«‏رَا ٻِطّٛ مَاطَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","ندٜنْ اٛ وِعِ اٛنْ طٛنْ تٛکُّطٛمٛ، ‏«‏رَا مَدُوجٛ مَاطَ؞»‏ دَغَ شَرٜلْ نغٜلْ تٛکُّطٛمٛ اٛنْ حٛشِّ مَرْيَامَ جٛوطِي تٛ وُرٛ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","غَطَ مَاجُمْ، يٜىٰسُ اٜ اَنْدِ کٛو طُمٜ يٛتِّنَامَ؞ نغَمْ کٛ اَايَارٜ وِعِ حٜىٰوَ، اٛ وِعِ، ‏«‏اٜ مِ نَنَ طٛنْکَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","اٜ وٛودِ تُمُّدٜ طٛنْ اٜ ندٜ حٜىٰوِ ندِيَمْ اِنَبٛجَمْ لَمُّطَمْ؞ سٜيْ سٛوجِعٜنْ ٻٜنْ شُووِ سٛوسٛوَ ندٜرْ مَاجَمْ، ٻٜ طِيسِنغَ تٛ سَوْرُ حِسٛڤْ، ٻٜ پٜفْتِندُ يَاکِ حٛنْدُکٛ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","ندٜ يٜىٰسُ يَرِ ندِيَمْ اِنَبٛجَمْ طَمْ، اٛ وِعِ، ‏«‏طُمْ يٛتِّنَامَ؞»‏ سٜيْ اٛ تُرْنِ حٛورٜ مَاکٛ اٛ يٛوفِ يٛنْکِ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","طُمْ ݧَلْندٜ سِرْيَاکِ، ندٜنْ تٛ فِنِ طُمْ ݧَلْندٜ سِوْتَارٜ؞ نغَمْ اَرْدِيٻٜ يَحُودَنْکٛعٜنْ نغِطَا ٻَلِّ طِنْ اَلٜىٰ دٛوْ غَافَالٜ ݧَلْندٜ سِوْتَارٜ، سٜيْ ٻٜ تٛرِي بِلَاتُسْ وَطَ طُمْ يٜوَ کٛيْطٜ يٜىٰسُ اٜ کٛيْطٜ يِمْٻٜ طِطٛ ٻٜنْ، ندٜنْ ٻَلِّ طِنْ نجِڤِّنٜىٰ؞ ");
INSERT INTO fuv_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","نغَمْ نٛنْ سٛوجِعٜنْ ٻٜنْ نجَحِ تٛ غَافَالٜ طٜنْ؞ ٻٜ نغٜوِ کٛيْطٜ اَرَنْدٜىٰجٛ، ندٜنْ ٻٜ نغٜوِ کٛيْطٜ طِطَٻٛ اٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","اَمَّا ندٜ ٻٜ نغَرِ تٛ يٜىٰسُ ٻٜ نغِعِ اٛ يَادَکٜ اٛ مَايِي، ٻٜ نغٜوَايِ کٛيْطٜ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","اَمَّا غٛعٛتٛ ندٜرْ سٛوجِعٜنْ ٻٜنْ يُوِرِ يٜىٰسُ لَبّٛ تٛ بٜشّٜ، طٛنْ اٜ طٛنْ پِيپَمْ اٜ ندِيَمْ وُرْتِي؞ ");
INSERT INTO fuv_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","غِيطٛ طُعُمْ شَرٜلْ کٛ طُمْ وَطِ، کَنْکٛ حٛکِّي شٜيْدَ دٛوْ مَاجُمْ، نغَمْ اٛنٛنْ مَا کٛولٛوطٛنْ؞ شٜيْدَ مَاکٛ بٛو طُمْ غٛونغَ، اٜ مٛ اَنْدِ غٛونغَ اٛ مٜتِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","طُعُمْ وَطُ نغَمْ کٛ اَايَارٜ وِعِ حٜىٰوَ، ‏«‏وَلَا پِپَلْ مَاکٛ غٜوٜتٜىٰنغَلْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","کَدِنْ وٛنْدٜ اَايَارٜ وِعِي، ‏«‏ٻٜ ندَارَيْ مٛ ٻٜ نجُوِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","غَطَ طُعُمْ وَطِي، يُسُفُ پِوٛيْطٛ غَرِيرِ اَرْمَاتِيَ تٛرِي بِلَاتُسْ حٛکَّمٛ ٻَنْدُ يٜىٰسُ؞ يُسُفُ اٛنْ اٛ تٛکُّطٛ يٜىٰسُ، اَمَّا اٜ سُوطٜ نغَمْ اٜ مٛ حُلَ اَرْدِيٻٜ يَحُودَنْکٛعٜنْ؞ بِلَاتُسْ جَٻِ، کَنْکٛ بٛو اٛ يَحِ اٛ وَطِ طُمْ جِڤِّنِ ٻَنْدُ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","نِکٛودِمُسْ جَحُنٛوطٛ تٛ يٜىٰسُ جٜمَّ يَادِ اٜ يُسُفُ اٛنْ؞ اٛ يَادِ اٜ نٜبَّمْ مُرْ اٜ اَلٛسْ اٜ طَمْ جِلِّندِرِ، طَمْ حٜوْتَيْ کِلٛ 30؞ ");
INSERT INTO fuv_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","يِمْٻٜ طِطٛ ٻٜنْ کٛشِّ ٻَنْدُ يٜىٰسُ ٻٜ تَارَنِندُ غُدٜ طٜ شٜىٰدٜ حَوْتِ اٜ مُرْ اٜ اَلٛسْ نٛ يَحُودَنْکٛعٜنْ نغَطَتَ تٛ ٻٜ اُوَيْ مَيْطٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","تٛ وِغٜىٰرٜ ندٜ يٜىٰسُ وَرَا دٛوْ غَافَانغَلْ، اٜ وٛودِ نغٜسَ؞ ندٜرْ مَاکَ اٜ وٛودِ يٜنَاندٜ حٜيْرٜ وَسَاندٜ ندٜرْ حَيْرٜ طُمْ مٜىٰطَايِ وَطُکِ غٛطّٛ ندٜرْ مَيْرٜ؞ ");
INSERT INTO fuv_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","تٛو، ندٜ طُمْ ݧَلْندٜ سِرْيَاکِ ندٜ يَحُودَنْکٛعٜنْ شِرْيٛتٛو ݧَلْندٜ سِوْتَارٜ، ندٜنْ نغَمْ يٜنَاندٜ ندٜنْ حَادٜ ندٜ وٛنِ، ٻٜ اُوِ يٜىٰسُ ندٜرْ مَيْرٜ؞ ");
INSERT INTO fuv_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","ݧَلْندٜ اَلَلْ اِلَا سُبَکَ دَغَ ݧِوْرٜ اٜ حٛرِي مَرْيَامَ پِوٛيْطٛ مَغَدَلَ يَحِ يٜنَاندٜ ندٜنْ تَوِ حَيْرٜ ندٜ طُمْ مَٻِّرِ يٜنَاندٜ ندٜنْ تَلِّتَامَ دَغَ دَمُّغَلْ يٜنَاندٜ ندٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","سٜيْ اٛ دٛغِّ اٛ يَحِ تٛ سِيمَنْ بِيتُرُسْ اٜ اٛنْ طٛنْ تٛکُّطٛ يٜىٰسُ مٛ يٜىٰسُ يِطِ نَاع سٜطَّ، اٛ وِعِٻٜ، ‏«‏ٻٜ کٛشِّي ٻَنْدُ يٜىٰسُ دَغَ ندٜرْ يٜنَاندٜ!‏ مِنْ اَنْدَا تٛ ٻٜ ندٜسِمٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","سٜيْ بِيتُرُسْ اٜ اٛنْ طٛنْ مٛ يٜىٰسُ ٻُرِ يِطُکِ ٻٜ نجَحِ يٜنَاندٜ ندٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","ٻٜ فُو طِطٛ اٜ ٻٜ ندٛغَّ، اَمَّا اٛنْ طٛنْ مٛ يٜىٰسُ ٻُرِ يِطُکِ ٻُرِي بِيتُرُسْ دٛغُّدُ اٛ اَرْتِمٛ يٛتَّاکِ يٜنَاندٜ ندٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","اٛ تُرِي اٛ يُرْنِي يٜنَاندٜ ندٜنْ اٛ يِعِ غُدٜ طٜ طُمْ تَارِرْنٛو ٻَنْدُ يٜىٰسُ، اَمَّا اٛ نَتَّايِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","سٜيْ سِيمَنْ بِيتُرُسْ تٛکِّرْطٛمٛ غَطَ يٛتِّي، نَتِّ يٜنَاندٜ ندٜنْ؞ اٛ يِعِ غُدٜ طٜنْ اٜ ندٜسِي طٛنْ، ");
INSERT INTO fuv_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","اٜ لٜفٛلْ نغٛلْ طُمْ تَارَنِ حٛورٜ يٜىٰسُ؞ لٜفٛلْ نغٛلْ اٜ حَکِّتِي اٜ غُدٜ طٜنْ، کَنْغٛلْ تَنْ اٜ نغٛلْ تَغِّي؞ ");
INSERT INTO fuv_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","سٜيْ اٛنْ طٛنْ مٛ يٜىٰسُ ٻُرِ يِطُکِ اَرْتُطٛ يٛتَّاکِ يٜنَاندٜ ندٜنْ، کَنْکٛ مَا اٛ نَتِّ، اٛ يِعَنِ غِتٜ مَاکٛ، اٛ جَٻِ يٜىٰسُ اُمَّکٜ دَغَ مَيْدٜ؞ ");
INSERT INTO fuv_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","حَا جٛونِ ٻٜ ڤَامَايِ اَايَارٜ بِيندٜ دٛولٜ يٜىٰسُ اُمّٛو دَغَ مَيْدٜ؞ ");
INSERT INTO fuv_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","سٜيْ تٛکُّٻٜ يٜىٰسُ ٻٜنْ شٛعِّ غُرٜ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","مَرْيَامَ اٜ دَرِي يَاسِ يٜنَاندٜ ندٜنْ اٜ وٛيَ؞ اٜ مٛ ندٜرْ وٛيُکِ، سٜيْ اٛ تُرِي اٛ يُرْنِي يٜنَاندٜ ندٜنْ، ");
INSERT INTO fuv_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","اٛ يِعِ مَلَاعِکَعٜنْ طِطٛ اٜ ٻٜ ٻٛرْنِي کٛلْتٜ دَنٜىٰجٜ، اٜ ٻٜ نجٛوطِي تٛ ٻَنْدُ يٜىٰسُ فُکِّنَا ندٜنّٛ؞ غٛعٛتٛ اٜ جٛوطِي تٛ حٛورٜ يٜىٰسُ وٛنْدٛنٛو، غٛعٛتٛ بٛو اٜ جٛوطِي تٛ کٛيْطٜ مَاکٛ غٛنْدٛنٛو؞ ");
INSERT INTO fuv_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","ٻٜ پَمِ مَرْيَامَ اٛنْ ٻٜ مبِعِ، ‏«‏نغَمْ طُمٜ مبٛيَتَا؟»‏ اٛ وِعِٻٜ، ‏«‏ٻٜ کٛشِّي ٻَنْدُ مٛودِبّٛ اَمْ، مِ اَنْدَا تٛ ٻٜ ندٜسِمٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","سٜيْ اٛ يٜىٰپِي اٛ يِعِ يٜىٰسُ اٜ دَرِي طٛنْ، اَمَّا اٛ اَنْدِتَايِ طُمْ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","يٜىٰسُ پَمِمٛ وِعِ، ‏«‏نغَمْ طُمٜ مبٛيَتَا؟ مٛيٜ طَٻِّتَتَا؟»‏ مَرْيَامَ اٜ ݧُمَ طُمْ ڤَامَنٛووٛ نغٜسَ کَنْ، نغَمْ نٛنْ اٛ وِعِمٛ، ‏«‏مٛودِبّٛ، تٛ اَنْ حٛشِّمٛ، وِعَمْ تٛ ندٜسُطَامٛ مِ يَحَيْ مِ حٛشَّمٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","يٜىٰسُ وِعِمٛ، ‏«‏مَرْيَامَ؞»‏ سٜيْ اٛ وَيْلِتِي اٛ رَارِمٛ اٛ وِعِ ندٜرْ اِبْرَانِيَنْکٛورٜ، ‏«‏رَبّٛنِ!‏»‏ مَعَنَ مَاجُمْ وٛنِ ‏«‏مٛودِبّٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","يٜىٰسُ وِعِمٛ، ‏«‏تَاع جٛغَيَمْ، نغَمْ مِ پٜىٰݝَايِ تٛ ݧَاکٛ اَمْ مٛ دٛوْ تَوْ؞ اَمَّا سٛعَّ تٛ بَنْدِرَاٻٜ اَمْ مبِعَاٻٜ مِ پٜىٰݝَيْ تٛ ݧَاکٛ اَمْ، ݧَاکٛ مٛوطٛنْ، اَللَّه اَمْ، اَللَّه مٛوطٛنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","سٜيْ مَرْيَامَ پِوٛيْطٛ مَغَدَلَ يَحِ تٛ تٛکُّٻٜ يٜىٰسُ وِعِٻٜ، ‏«‏مِ يِعِي يٜىٰسُ!‏»‏ سٜيْ اٛ طِيوِتَنِٻٜ کٛ اٛ وِعِمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","طُمْ ݧَلْندٜ اَلَلْ؞ ندٜ نَانغٜ حِيرِ، تٛکُّٻٜ يٜىٰسُ کَوْرِتِ، ٻٜ مَٻِّ دَمُّغَلْ نغَمْ اٜ ٻٜ کُلَ اَرْدِيٻٜ يَحُودَنْکٛعٜنْ؞ طٛنْ اٜ طٛنْ يٜىٰسُ وَنْغِ دَرِي شَکَ مَٻّٜ، وِعِ، ‏«‏اٜ مِ سِلْمِنٛو؞ جَمْ وٛنْدَ اٜ مٛوطٛنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","غَطَ اٛ وِعِ نٛنْ، اٛ حٛلِّٻٜ جُوطٜ مَاکٛ اٜ بٜشّٜ مَاکٛ؞ سٜيْ تٛکُّٻٜمٛ نَنِ بٜلْطُمْ نَاع سٜطَّ ندٜ ٻٜ نغِعِمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","يٜىٰسُ فُطِّتِ وِعِ، ‏«‏جَمْ وٛنْدَ اٜ مٛوطٛنْ!‏ نٛنْ نٛ ݧَاکٛ مٛ دٛوْ لِلِرِيَمْ، نٛنْ مِنْ مَا اٜ مِ لِلَعٛنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","ندٜ اٛ وِعِ نٛنْ، سٜيْ اٛ فُوفِ دٛوْ مَٻّٜ اٛ وِعِٻٜ، ‏«‏نجَٻٜىٰ رُوحُ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","تٛ اٛنْ نجَافَنَکٜ يِمْٻٜ حَکّٜ، ٻٜ نجَافَنَامَ، تٛ بٛو اٛنْ نجَافَنَاکِٻٜ، ٻٜ نجَافَنَاکَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","غٛعٛتٛ ندٜرْ تٛکُّٻٜ يٜىٰسُ، بِعٜتٜىٰطٛ تٛومَ ﴿طٛنْمَا اٜ مٛ وِعٜىٰ شِوْتَاطٛ﴾، اٛ وٛنْدَا اٜ مَٻّٜ شَرٜلْ کٛ يٜىٰسُ وَرِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","سٜيْ تٛکُّٻٜ يٜىٰسُ حٛرِيٻٜ مبِعِمٛ، ‏«‏مِنْ نغِعِي يٜىٰسُ؞»‏ اَمَّا تٛومَ وِعِٻٜ، ‏«‏سٜيْ تٛ مِ يِعِي جُلٛوطٜ جُوطٜ مَاکٛ تٛ اٛ فِيَنَا کُوسَاجٜ ندٜنْ مِ وَطَ حٛوندُ اَمْ ندٜرْ جُلٛوطٜ طٜنْ، ندٜنْ مِ وَطَ جُنْغٛ اَمْ ندٜرْ يُلْندٜ بٜشّٜ مَاکٛ تٛ اٛ يُوِرَا لَبّٛ، تٛ نَاع نٛنْ، مِ جَٻَتَا کٛ مبِيطٛنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","يٛنْتٛورٜ غٛعٛ غَطَ مَاجُمْ، تٛکُّٻٜ يٜىٰسُ اٜ ندٜرْ وُرٛ نغٛنْ کَدِنْ، تٛومَ مَا اٜ وٛنْدِ اٜ مَٻّٜ؞ کٛو ندٜ اٜ ٻٜ مَٻِّ دَمُّطٜ، طٛنْ اٜ طٛنْ يٜىٰسُ وَنْغِ دَرِي حَکُّندٜ مَٻّٜ وِعِ، ‏«‏جَمْ وٛنْدَ اٜ مٛوطٛنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","سٜيْ اٛ وِعِ تٛومَ، ‏«‏رَا جُوطٜ اَمْ؞ وَطُ حٛوندُ مَاطَ ندٜرْ جُلٛوطٜ طٜنْ؞ فٛرْتُ جُنْغٛ مَاطَ نغَطَانغٛ ندٜرْ يُلْندٜ بٜشّٜ اَمْ؞ اَلُ وَطُکِ سٜکٛ، حٛولَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","سٜيْ تٛومَ وِعِمٛ، ‏«‏جٛومِرَاوٛ اَمْ، اَللَّه اَمْ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","يٜىٰسُ وِعِمٛ، ‏«‏اَ حٛولِيَمْ نغَمْ اَ يِعِييَمْ؟ ٻٜ بَرْکِطِنَاٻٜ يِمْٻٜ ٻٜ نغِعَايِيَمْ، فُو اٜ نٛنْ ٻٜ کٛولَکٜيَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","يٜىٰسُ وَطِي کٛ حَيْطِنِي فٜىٰرٜ‑فٜىٰرٜ طُطُّمْ يٜىٰسٛ تٛکُّٻٜمٛ طُمْ وِنْدَاکَ ندٜرْ طٜرٜوٛلْ نغٛعٛلْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","اَمَّا طُعُمْ طُمْ وِنْدَا نغَمْ کٛولٛوطٛنْ يٜىٰسُ وٛنِ اَلْمَسِيحُ ٻِطّٛ اَللَّه، ندٜنْ لَاوٛلْ حٛولَاکِمٛ کٜٻٛنْ يٛنْکِ کِ رٜعَتَا بَرْکَ اِنْدٜ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","غَطَ فُو فِي طُعُمْ يٜىٰسُ فُطِّتِ وَنْغَنِ تٛکُّٻٜمٛ تٛ دَاندٜ مبٜىٰلَ تِبَارِيَ؞ رَا نٛ اٛ وَنْغِنِرِ حٛورٜ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","سِيمَنْ بِيتُرُسْ، اٜ تٛومَ بِعٜتٜىٰطٛ شِوْتَاطٛ، اٜ نَتَانِيَلْ پِوٛيْطٛ کَانَ ندٜرْ لٜيْدِ غَلِيلِ، اٜ ٻِٻّٜ جَبَدِ، اٜ وٛٻّٜ تٛکُّٻٜ يٜىٰسُ طِطٛ ٻٜ فُو اٜ ٻٜ کَوْرِتِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","سٜيْ سِيمَنْ بِيتُرُسْ وِعِ حٛرِيٻٜ، ‏«‏مِ يَحَيْ نَنْغٛيْکِ لِپِّ؞»‏ ٻٜ مبِعِمٛ، ‏«‏مِنْ نجَادَيْ اٜ مَاطَ؞»‏ سٜيْ ٻٜ نجَحِ ٻٜ نَتِّ کٛمِوَلْ، اَمَّا ندٜنْ طٛنْ جٜمَّارٜ وَلَا کٛ ٻٜ نَنْغِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","نَانغٜ اٜ وُرْتٛيٛو، سٜيْ يٜىٰسُ دَرِي دَاندٜ مبٜىٰلَ نغَنْ، اَمَّا ٻٜ اَنْدَا طُمْ کَنْکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","سٜيْ يٜىٰسُ وِعِٻٜ، ‏«‏بَنْدِرَاٻٜ، اٛنْ نغٛودِ لِپِّ؟»‏ ٻٜ مبِعِمٛ، ‏«‏مِنْ نغَلَا؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","اٛ وِعِٻٜ، ‏«‏نغَطٜىٰ نَنْغِرْطُمْ لِپِّ مٛوطٛنْ تٛ ݧَامٛ کٛمِوَلْ مٛوطٛنْ، اٛنْ نَنْغَيْ لِپِّ؞»‏ ندٜ ٻٜ نغَطِ نٛنْ، ٻٜ مبَاوَايِ نَتِّنْکِ نَنْغِرْطُمْ لِپِّ طُمْ ندٜرْ کٛمِوَلْ نغَلْ، نغَمْ لِپِّ طُطِّ؞ ");
INSERT INTO fuv_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","سٜيْ اٛنْ طٛنْ تٛکُّطٛ يٜىٰسُ مٛ يٜىٰسُ يِطِ نَاع سٜطَّ، وِعِ بِيتُرُسْ، ‏«‏طُمْ جٛومِرَاوٛ؞»‏ ندٜ بِيتُرُسْ نَنِ طُمْ جٛومِرَاوٛ، اٛ تَادِي تٛغّٛورٜ مَاکٛ نغَمْ اٛ ٻٛرْتَکٜنٛ نغَمْ کُوغَلْ، اٛ دِوِ ندٜرْ ندِيَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","تٛکُّٻٜ يٜىٰسُ حٛرِيٻٜ ندَرِي ندٜرْ کٛمِوَلْ نغَلْ، اٜ ٻٜ ڤٛوطَ نَنْغِرْطُمْ لِپِّ طُمْ اٜ طُمْ حٜىٰوِ لِپِّ، نغَمْ اٜ ٻٜ حَادٜ دَاندٜ مبٜىٰلَ نغَنْ کٛ وَطَتَ جَاٻَنْطٜ 300؞ ");
INSERT INTO fuv_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","ندٜ ٻٜ نجٛتِّي تٛ دَاندٜ ندِيَمْ، ٻٜ نغِعِ دٛشّٜ حِيتٜ اٜ لِپِّ دٛوْ مَاجٜ اٜ بُرٛودِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","يٜىٰسُ وِعِٻٜ، ‏«‏نغَدّٜىٰ غٛطِّ لِپِّ طِ نَنْغُطٛنْ جٛونِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","سٜيْ سِيمَنْ بِيتُرُسْ نَتِّي ندٜرْ کٛمِوَلْ نغَلْ، اٛ فٛوطِ نَنْغِرْطُمْ لِپِّ طُمْ يَاکِ تٛ نجَارٜىٰندِ اٜ طُمْ حٜىٰوِ لِپِّ 351 مَوْطِ؞ کٛو ندٜ اٜ طِ طُوطِ، نَنْغِرْطُمْ طُمْ سٜىٰکَايِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","يٜىٰسُ وِعِٻٜ، ‏«‏نغَرٜىٰ، نغٜوٛنْ کٛوپٜ؞»‏ وَلَا غٛطّٛ ندٜرْ تٛکُّٻٜمٛ غَطّٛ سٜمْبٜ ٻٜرْندٜ پَمَمٛ، ‏«‏اَنْ اَ مٛيٜ؟»‏ نغَمْ اٜ ٻٜ اَنْدِ طُمْ جٛومِرَاوٛ؞ ");
INSERT INTO fuv_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","يٜىٰسُ حٛشِّ بُرٛودِ طُمْ، حٛکِّٻٜطُمْ، کَدِنْ اٛ حٛشِّ لِپِّ طِنْ، اٛ حٛکِّٻٜطِ؞ ");
INSERT INTO fuv_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","طُعُمْ کَنْجُمْ وٛنِ تَتَٻُمْ يٜىٰسُ اٜ وَنْغَنَ تٛکُّٻٜمٛ غَطَ اٛ اُمِّنَامَ دَغَ مَيْدٜ؞ ");
INSERT INTO fuv_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","غَطَ ٻٜ نجٛتِّنِي ݧَامُکِ، يٜىٰسُ پَمِ سِيمَنْ بِيتُرُسْ وِعِ، ‏«‏سِيمَنْ ٻِي يَحَيَ، اَ ٻُرِي حٛرِيٻٜ ٻٜعٜ يِطُکِيَمْ؟»‏ بِيتُرُسْ وِعِ، ‏«‏اٜىٰ، جٛومِرَاوٛ، اَ اَنْدِ اٜ مِ يِطُمَا؞»‏ يٜىٰسُ وِعِمٛ، ‏«‏دُرُ بَالِ اَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","يٜىٰسُ فُطِّتِ پَمِمٛ طِطَٻُمْ وِعِ، ‏«‏سِيمَنْ ٻِي يَحَيَ، اَ يِطِيَمْ؟»‏ اٛ وِعِ، ‏«‏اٜىٰ، جٛومِرَاوٛ، اَ اَنْدِ اٜ مِ يِطُمَا؞»‏ يٜىٰسُ وِعِمٛ، ‏«‏فَامَنْ بَالِ اَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","يٜىٰسُ پَمِمٛ تَتَٻُمْ وِعِ، ‏«‏سِيمَنْ، ٻِي يَحَيَ، اَ يِطِيَمْ؟»‏ بِيتُرُسْ وَنِّ نغَمْ يٜىٰسُ پَمِمٛ تَتَٻُمْ، ‏«‏اَ يِطِيَمْ؟»‏ نغَمْ نٛنْ اٛ وِعِمٛ، ‏«‏جٛومِرَاوٛ، اَ اَنْدِ کٛو طُمٜ؞ اَ اَنْدِ اٜ مِ يِطُمَا؞»‏ يٜىٰسُ وِعِمٛ، ‏«‏دُرُ بَالِ اَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","اٜ مِ وِعُمَا غٛونغَ، کٛ نغٛنّٛطَا سُکَ اَ ٻٛرْنَ حٛورٜ مَاطَ نجَحَا تٛ نغِطَّا؞ اَمَّا تَا نَوْيِي، اَ فٛرْتَيْ جُوطٜ مَاطَ غٛطّٛ ٻٛرْنُمَا اٛ يَارُمَا وِغٜىٰرٜ ندٜ اَ يِطَا يَاکِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","يٜىٰسُ وِعُ طُعُمْ نغَمْ حٛلَّ اِرِ مَيْدٜ ندٜ بِيتُرُسْ وَطَتَ نغَمْ مَوْنِنْکِ اَللَّه؞ سٜيْ يٜىٰسُ وِعِمٛ، ‏«‏تٛکَّمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","بِيتُرُسْ وَيْلِتِي يِعِ اٛنْ طٛنْ تٛکُّطٛ يٜىٰسُ مٛ يٜىٰسُ يِطِ نَاع سٜطَّ اٜ تٛکِّٻٜ؞ کَنْکٛ وٛنِ اٛنْ طٛنْ جٛوطِيطٛ حَادٜ يٜىٰسُ کٛ ٻٜ ݧَامِ کِرْتَارِ، بِيطٛ، ‏«‏مٛودِبّٛ، طُمْ مٛيٜ حٛکِّتِرْتَمَ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","ندٜ بِيتُرُسْ يِعِمٛ، پَمِ يٜىٰسُ وِعِ، ‏«‏جٛومِرَاوٛ، طُمٜ حٜٻَتَمٛ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","يٜىٰسُ وِعِمٛ، ‏«‏تٛ اٜ مِ يِطِ اٛ جٛوطٛدٛو اٜ يٛنْکِ نَا شَرٜلْ نغٜلْ نغَرْتٛيْمِ، کٛ وَنُّمَا؟ اَنْ نِ، تٛکَّمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","نغَمْ يٜىٰسُ وِعِ نٛنْ، سٜيْ حَبَرُ سَنْکِتِي ندٜرْ تٛکُّٻٜمٛ وِيکِ اٛعٛ تٛکُّطٛ يٜىٰسُ اٛ مَايَتَا؞ اَمَّا يٜىٰسُ وِعَايِ اٛ مَايَتَا؞ کٛ اٛ وِعِ وٛنِ، ‏«‏تٛ اٜ مِ يِطِ اٛ جٛوطٛدٛو اٜ يٛنْکِ نَا شَرٜلْ نغٜلْ نغَرْتٛيْمِ، کٛ وَنُّمَا؟»‏ ");
INSERT INTO fuv_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","اٛعٛ وٛنِ اٛنْ طٛنْ تٛکُّطٛ يٜىٰسُ اٜ مٛ حٛکَّ شٜيْدَ دٛوْ فُو فِي طُعُمْ ندٜنْ اٛ وِنْدِيطُمْ؞ اٜنْ اَنْدِ بٛو شٜيْدَ مَاکٛ طُمْ غٛونغَ؞ ");
INSERT INTO fuv_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","کَدِنْ اٜ وٛودِ فِي طُطُّمْ طُمْ يٜىٰسُ وَطِ؞ تٛ طُمْ وِنْدَامَ طُمْ فُو غٛعٛ اٜ غٛعٛ، اٜ مِ ݧُمَ فُو دُونِيَارُ وَلَا نجَيْرِ تٛ طُمْ رٜسَتَ دٜفْتٜ بِنْدٜتٜىٰطٜ؞");
INSERT INTO fuv_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","يَا تِيٛوفِلُسْ مَوْطٛ، ندٜرْ دٜفْتٜرٜ اَمْ اَرَنْدٜىٰرٜ، مِ وِنْدِينٛ دٛوْ کٛو طُمٜ کٛ يٜىٰسُ وَطِ اٜ کٛ اٛ اٜکِّتِنِ، ");
INSERT INTO fuv_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","حَا يَاکِ ݧَلْندٜ ندٜ اٛ حٛشَّا يَاکِ دٛوْ؞ کٛ اٛ حٛشّٜىٰ يَاکِ دٛوْ، اٛ اٜکِّتِنِي لِلَاٻٜ ٻٜ اٛ سُٻِ ندٜرْ بَوْطٜ رُوحُ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","غَطَ اٛ تٛرَّامَ اٛ وَرَامَ، اٛ اُمِّي دَغَ مَيْدٜ اٛ وَنْغَنِٻٜ؞ اٜ طَتٜ طُطّٜ اٛ حٛلِّٻٜ اٜ مٛ فٛوفَ؞ اٛ وَطِي بَلْطٜ 40 اٜ مٛ وَنْغَنَٻٜ، اٜ مٛ اٜکِّتِنَٻٜ دٛوْ لَامُ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","شَرٜلْ کٛ اٛ وٛنْدِ اٜ مَٻّٜ، اٛ وِعِٻٜ، ‏«‏تٛع اٛنْ اَلُ اُرُشَلِيمَ، اَمَّا کٜطٜىٰ نَا ݧَاکٛ مٜىٰطٜنْ مٛ دٛوْ حٜبِّنِي اَلْکَوَلْ نغَلْ اٛ وَطَنِعٛنْ نغَلْ مبِيمِعٛنْ؞ کَنْغَلْ وٛنِ حٛکُّکِعٛنْ رُوحُ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","يَحَيَ وَطَنِي يِمْٻٜ بَڤْتِسْمَ اٜ ندِيَمْ، اَمَّا ندٜرْ بَلْطٜ سٜطَّ، اٛنٛنْ اَللَّه وَطِرَنَيْعٛنْ بَڤْتِسْمَ اٜ رُوحُ مَاکٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","ندٜ تٛکُّٻٜمٛ فُو کَوْرِتِ، سٜيْ ٻٜ پَمِمٛ، ٻٜ مبِعِ، ‏«‏جٛومِرَاوٛ، جٛونِ نغَرْتِرَنْتَا اِسْرَاعِيلَ لَامُ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","اَمَّا يٜىٰسُ وِعِٻٜ، ‏«‏اَنْدُکِ شَرٜلْ اٜ جَامَنُوجِ طِ ݧَاکٛ مٜىٰطٜنْ مٛ دٛوْ سِرْيِي ندٜرْ لَامُ مُوطُمْ نَاع اُمْ طُمْ مٛوطٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","اَمَّا تٛ رُوحُ اَللَّه جِڤّٛيَکٜ دٛوْ مٛوطٛنْ، اٛنْ کٜٻَيْ بَوْطٜ، اٛنْ نغَرْتَيْ کٛکَّيْٻٜ وٛٻّٜ حَبَرُ اَمْ ندٜرْ اُرُشَلِيمَ، اٜ لٜيْدِ يَحُودِيَ فُو، اٜ لٜيْدِ سَمَارِيَ، حَا کٜىٰرٛلْ دُونِيَارُ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","غَطَ اٛ وِعِي نٛنْ، اٛ حٛشَّا يَاکِ دٛوْ؞ اٜ ٻٜ ندَارَمٛ حَا دُولٜ شُدِّمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","اٜ ٻٜ تِجِّي اٜ ٻٜ ندَارَمٛ اٜ مٛ فَعِ دٛوْ، سٜيْ رَا وٛرْٻٜ طِطٛ ٻٜ کٛلْتٜ دَنٜىٰجٜ مبَنْغِي حَادٜ مَٻّٜ اٜ ندَرِي؞ ");
INSERT INTO fuv_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","وٛرْٻٜ ٻٜنْ مبِعِٻٜ، ‏«‏اٛنٛنْ يِمْٻٜ غَلِيلِ، نغَمْ طُمٜ ندَرِيطٛنْ طٛعٛ اٛنْ ندَارَ دٛوْ؟ يٜىٰسُ اٛنْ طٛنْ کٛشَّاطٛ ندٜرْ مٛوطٛنْ يَاکِ دٛوْ، اٛ سٛعّٛيْتٛ نٛنْ نٛ نغِيرُطٛنْ اٛ حٛشِّرَامَ دٛوْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","سٜيْ ٻٜ نجِڤّٛيِي دَغَ دٛوْ حٛشّٜىٰرٜ ندٜ لٜطّٜ جَيْتُنْ، ٻٜ کٛوتِ اُرُشَلِيمَ؞ حَکُّندٜ حٛشّٜىٰرٜ ندٜنْ اٜ اُرُشَلِيمَ طُمْ ٻُرَايِ مِلْ غٛعٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","ندٜ ٻٜ نَتِّ غَرِيرِ ندِنْ، ٻٜ پٜنْتِ سُودُ دٛوْ تٛ ٻٜ کَوْرِتَتَ؞ لِلَاٻٜ ٻٜنْ نغٛنِ:‏ بِيتُرُسْ، اٜ يَحَيَ، اٜ يَاکُبُ، اٜ اَنْدِرَاوُسْ، اٜ فِلِبُسْ، اٜ تٛومَ، اٜ بَتِلٛومِ، اٜ مَاتِيُ، اٜ يَاکُبُ ٻِي حَلْفَ، اٜ سِيمَنْ جَلٛوتِ ");
INSERT INTO fuv_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","ٻٜ فُو، اٜ ٻٜ کَوْرِتَ ٻٜ نغَطَ دٛعَارٜ اٜ ٻٜرْندٜ غٛعٛ، کَمْٻٜ اٜ مَرْيَامَ مَدُوجٛ يٜىٰسُ اٜ مِݧِرَاٻٜ يٜىٰسُ وٛرْٻٜ، اٜ وٛٻّٜ رٜوْٻٜ طٛنْمَا؞ ");
INSERT INTO fuv_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","ندٜرْ بَلْطٜ طٜنْ، کَوْتَلْ کٛولِيٻٜ يٜىٰسُ يَارِي يِمْٻٜ 120؞ سٜيْ بِيتُرُسْ اُمِّي، دَرِي يٜىٰسٛ مَٻّٜ، وِعِ، ");
INSERT INTO fuv_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","‏«‏بَنْدِرَاٻٜ، رُوحُ اَللَّه مٜتِينٛ دَغَ حٛنْدُکٛ دَوْدَ دٛوْ يَحُودَ، کٛلُّطٛ نَنْغٛوٻٜ يٜىٰسُ لَاوٛلْ نٛ نَنْغِرْتَمٛ؞ دٛولٜ اَايَاجٜ طٜنْ کٜىٰوَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","يَحُودَ اٛ کُودَيْنٛوطٛ اٜ مٜىٰطٜنْ ندٜرْ کُوغَلْ جٛومِرَاوٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","﴿اٛ سٛودِ نغٜسَ اٜ شٜىٰدٜ طٜ اٛ يٛٻَا نغَمْ کُوغَلْ کَلُّنغَلْ نغَلْ اٛ وَطِ، اٛ يَنِ ندٜرْ مَاکَ، رٜىٰدُ مَاکٛ ڤُسِ، تٜتٜکِّ مَاکٛ فُو ندُفِ اٜ لٜيْدِ، اٛ مَايِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","يِمْٻٜ اُرُشَلِيمَ فُو نَنِي حَبَرُ طُمْ؞ کَنْجُمْ وَطِ ٻٜ نٛدِّرِ نغٜسَ کَنْ ندٜرْ طٜمْنغَلْ مَٻّٜ اَکٜلْدَمَ وَاتٛ ‏«‏نغٜسَ پِيپَمْ؞»‏﴾ ");
INSERT INTO fuv_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","‏«‏نغَمْ طُمْ وِنْدَامَ ندٜرْ دٜفْتٜرٜ جَبُورَ دٛوْ مَاکٛ وِعُکِ، ‏‹‏اَلْ وُرٛ مَاکٛ وَرْتَ وِنْدٜ، تٛع کٛو مٛيٜ جٛوطٛو ندٜرْ مَاغٛ؞›‏ کَدِمَا وٛنْدٜ اَايَارٜ وِعِي، ‏‹‏اَلْ غٛطّٛ حٛشَّ کُوغَلْ اَرْدَارٜ مَاکٛ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("AC1_21‏","074_1_21‏","ACT","1","21‏","22","‏«‏اٜ حَانِ شُٻٜنْ غٛعٛتٛ دَغَ ندٜرْ غٛنْدُنٛوٻٜ اٜ مٜىٰطٜنْ شَرٜلْ کٛ يٜىٰسُ جٛومِرَاوٛ وٛنْدِ اٜ مٜىٰطٜنْ دَغَ شَرٜلْ کٛ يَحَيَ وَطَنِ يِمْٻٜ بَڤْتِسْمَ يَاکِ ݧَلْندٜ ندٜ يٜىٰسُ حٛشَّا ندٜرْ مٜىٰطٜنْ، نغَمْ اٛ وَرْتَ کٛکِّدٛووٛ حَبَرُ اُمَّاکِ يٜىٰسُ اٜ مٜىٰطٜنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","دَغَ طٛنْ، سٜيْ ٻٜ ندَرْنِ وٛرْٻٜ طِطٛ:‏ مَاتِيَسْ اٜ يُسُفُ بَرْسَبَ بِعٜتٜىٰطٛ جُسْتُسْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","ٻٜ نغَطِ دٛعَارٜ، ٻٜ مبِعِ، ‏«‏جٛومِرَاوٛ، اَنْ اَنْدُطٛ ٻٜرْطٜ يِمْٻٜ فُو، حٛلُّمِنْ مٛ شُٻُطَا دَغَ ندٜرْ يِمْٻٜ طِطٛ ٻٜعٜ، ");
INSERT INTO fuv_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","نغَمْ اٛ حُوَ کُوغَلْ لِلَاٻٜ نغَلْ يَحُودَ اَلِ؞ نغَمْ يَحُودَ يَحِي وِغٜىٰرٜ تٛ حَانَنِمٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","سٜيْ ٻٜ نغَطِ شُٻٛلْ حَکُّندٜ يِمْٻٜ طِطٛ ٻٜنْ؞ شُٻَاطٛ اٛنْ وٛنِ مَاتِيَسْ؞ اٛ نَتِّنَا ندٜرْ لِلَاٻٜ سَڤّٛ اٜ غٛعٛ ٻٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","ندٜ حُمْتٛ ٻٜنْدٛلْ اَلْکَمَارِ وَطِ، تٛکُّٻٜ يٜىٰسُ فُو کَوْرِتِ وِغٜىٰرٜ غٛعٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","طٛنْ اٜ طٛنْ ٻٜ نَنِ اِيدٛ پِوٛيِي دَغَ دٛوْ بٛ حٜنْدُ شٜمْبِنْدُ؞ اِيدٛ نغٛنْ حٜىٰوِ وُرٛ نغٛ ٻٜ نغٛنِ ندٜرْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","سٜيْ غٛطُّمْ نَنْدُطُمْ اٜ طٜمْطٜ حِيتٜ وَنْغِ؞ طٜ شَنْکِتِي، طٜ کٛطِ دٛوْ حٛورٜ کٛو مٛيٜ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","سٜيْ ٻٜ فُو ٻٜ کٜىٰوِ رُوحُ اَللَّه، ٻٜ ڤُطِّ مٜتُکِ ندٜرْ طٜمْطٜ فٜىٰرٜ‑فٜىٰرٜ نٛ رُوحُ حٛکِّرِٻٜ بَوْطٜ مٜتُکِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","اٜ وٛودِ يَحُودَنْکٛعٜنْ جٛوطِيٻٜ ندٜرْ اُرُشَلِيمَ پِوٛيْٻٜ دَغَ کٛو طٜيٜ لٜيْطٜ دُونِيَارُ کُلٛوٻٜ جٛومِرَاوٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","ندٜ ٻٜ نَنِ اِيدٛ نغٛنْ، ٻٜ فُو ٻٜ کَوْرِتِ؞ فِي طُمْ حُلْنِيٻٜ، ٻٜ ندُلِّ کٛ ٻٜ نغَطَتَ، نغَمْ ٻٜ نَنِي لِلَاٻٜ اٜ مٜتَ ندٜرْ طٜمْنغَلْ کٛو مٛيٜ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","فِي طُمْ حَيْطِنِٻٜ نَاع سٜطَّ، ٻٜ مبِعِ، ‏«‏ٻٜعٜ مٜتٛوٻٜ نَاع ٻٜ غَلِلَنْکٛعٜنْ؟ ");
INSERT INTO fuv_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","ندٜنْ نٛ طُمْ وَطِ کٛو مٛيٜ ندٜرْ مٜىٰطٜنْ اٜ نَنَ کٛ ٻٜ مبِعَتَ ندٜرْ طٜمْنغَلْ مُوطُمْ؟ ");
INSERT INTO fuv_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","رَا ندٜرْ مٜىٰطٜنْ اٜ وٛودِ فَرْتِيَنْکٛعٜنْ اٜ مَدِيَنْکٛعٜنْ اٜ اٜلَامِيَنْکٛعٜنْ، اٜ يِمْٻٜ مٜسٛفٛتَامِيَ، اٜ وٛٻّٜ دَغَ ندٜرْ لٜيْطٜ يَحُودِيَ اٜ کَفَدٛوکِيَ اٜ فَنْتُسْ اٜ اَاسِيَ، ");
INSERT INTO fuv_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","اٜ يِمْٻٜ فِرِيجِيَ اٜ بَمْفِيلِيَ اٜ لٜيْدِ مَسَرْ اٜ لٜيْدِ لِبِيَ حَادٜ سَايِرِنْ اٜ پِوٛيْٻٜ رٛومَ، ");
INSERT INTO fuv_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","يَحُودَنْکٛعٜنْ اٜ وٛٻّٜ جَٻُٻٜ دِينَ يَحُودَنْکٛعٜنْ، اٜ وٛٻّٜ دَغَ کِرِتِ، اٜ لَارَبَنْکٛعٜنْ؞ اَمَّا فُو اٜ نٛنْ، اٜنْ فُو اٜنْ نَنَ يِمْٻٜ ٻٜعٜ اٜ مٜتَ ندٜرْ طٜمْطٜ مٜىٰطٜنْ دٛوْ کُوطٜ مَوْطٜ طٜ اَللَّه وَطِ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","ٻٜ فُو فِي طُمْ حَيْطِنِٻٜ، ٻٜ نجِيٻٛوتِرِ، ٻٜ نغَطِ کَ پَمْپَمْتِرْکِ، اٜ ٻٜ مبِعَ، ‏«‏طُمٜ وٛنِ مَعَنَ فِي طُعُمْ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","اَمَّا وٛٻّٜ نجَلِ تٛکُّٻٜ يٜىٰسُ مبِعِ، ‏«‏ندِيَمْ اِنَبٛجَمْ ٻٜ نجَرِ، ٻٜ نغِلْتِي!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","سٜيْ بِيتُرُسْ اُمِّي، کَنْکٛ اٜ لِلَاٻٜ سَڤّٛ اٜ غٛعٛ، ٻٜ ندَرِي، اٛ پٜفْتِ حٛنٛنْدٜ مَاکٛ، اٛ وِعِ حَوْرُتُٻٜ ٻٜنْ، ‏«‏اٛنٛنْ يَحُودَنْکٛعٜنْ اٜ جٛوطِيٻٜ ندٜرْ اُرُشَلِيمَ فُو، نَنٜىٰ کٛ مبِعَيْمِعٛنْ؞ مِ حٛکَّيْعٛنْ مَعَنَ فِي طُعُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","يِمْٻٜ ٻٜعٜ نَاع ٻٜ جَرُٻٜ نٛ کَمِّيطٛنْ، نغَمْ جٛونِ طُمْ سُبَکَ نجَمْندِ جٛوٜىٰنَيِ!‏ ");
INSERT INTO fuv_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","اَمَّا رَا کٛ اَنَّبِ يٛوٜلْ وِعِ اَللَّه وِعِي، ");
INSERT INTO fuv_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‏‹‏ندٜرْ بَلْطٜ شَکِتِيطٜ کٛ دُونِيَارُ رٜعَ، مِ حٛکَّيْ يِمْٻٜ فُو رُوحُ اَمْ؞ ٻِٻّٜ مٛوطٛنْ وٛرْٻٜ اٜ رٜوْٻٜ ٻٜ نغَعَجِنَيْ حَبَرُ اَمْ، کٛرِعٜنْ مٛوطٛنْ نغِعَيْ وَحَيُ، ندٛتِّعٜنْ مٛوطٛنْ کٛيْطَيْ کٛيْطِ پِوٛيْطِ تٛ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","مِ حٛکَّيْ مَشُّٻٜ اَمْ وٛرْٻٜ اٜ رٜوْٻٜ رُوحُ اَمْ ندٜرْ بَلْطٜ طٜنْ، ٻٜ نغَعَجِنَيْ حَبَرُ اَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","مِ حٛلَّيْ فِي کُلْنِيطُمْ اٜ دٛوْ؛ ندٜرْ دُونِيَارُ بٛو مِ وَطَيْ اَلَامَاجِ کُلْنِيطِ، وَاتٛ پِيپَمْ اٜ حِيتٜ اٜ شُرْکَ ٻَلٜحَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","نَانغٜ وَرْتَيْ ݧِوْرٜ، لٜوْرُ بٛو وٛوجَيْ بٛ پِيپَمْ؞ فُو فِي طُعُمْ وَطَيْ کٛ ݧَلْندٜ جٛومِرَاوٛ مَوْندٜ تٜدُّندٜ وَرَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","ندٜرْ بَلْطٜ طٜنْ، کٛو مٛيٜ تٛرِيطٛ جٛومِرَاوٛ حِسْنَمٛ، جٛومِرَاوٛ حِسْنَيْمٛ؞›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","طٛنْمَا بِيتُرُسْ وِعِ، ‏«‏يِمْٻٜ اِسْرَاعِيلَ، نَنٜىٰ بٛلِيطٜ طٜعٜ:‏ اَللَّه حٛلِّيعٛنْ اٛ سُٻِي يٜىٰسُ نَجَرَنْکٜىٰجٛ نغَمْ اٛ حٛکِّيمٛ بَوْطٜ حُوُکِ کُوطٜ مَوْطٜ اٜ کُوطٜ کَيْطِنِيطٜ اٜ اَلَامَاجِ طِ اٛ وَطِ ندٜرْ مٛوطٛنْ؞ اٛنٛنْ اٜ کٛعٜ مٛوطٛنْ اٛنْ اَنْدِ کٛ وَطِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","فُو اٜ نٛنْ اٛنْ کٛکِّتِرِيمٛ ندٜرْ جُوطٜ کَلُّٻٜ؞ اٛنْ نغَطِي ٻٜ ٻِلِيمٛ دٛوْ غَافَانغَلْ، ٻٜ مبَرِمٛ؞ فُو اٜ نٛنْ، نٛنْ اَللَّه سِرْيٛرِي فِي طُمْ وَطِرَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","اَمَّا اَللَّه اُمِّنِيمٛ دَغَ مَيْدٜ، وُرْتِنِيمٛ يٜنَاندٜ، نغَمْ مَيْدٜ وَاوَتَا جٛغَاکِمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","نغَمْ اَنَّبِ دَوْدَ مٜتِي دٛوْ يٜىٰسُ اَلْمَسِيحُ وِعِي، ‏‹‏کٛو ندٜيٜ اٜ مِ يِعَ جٛومِرَاوٛ يٜىٰسٛ اَمْ، وَلَا کٛ کُلَيْمِ نغَمْ اٜ مٛ وٛنْدِ اٜ اَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","نغَمْ مَاجُمْ ٻٜرْندٜ اَمْ اٜ نَنَ بٜلْطُمْ اٜ مِ وٜلْوٜلْتَ، کٛو ندٜ مِ نٜطّٛ مَايَيْطٛ مِ جٛوطٛدٛتٛ اٜ ٻٜرْندٜ وَالْتِيندٜ، ");
INSERT INTO fuv_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","نغَمْ اَ اَلَتَا يٛنْکِ اَمْ ندٜرْ يٜنَاندٜ، اَ اَلَتَايَمْ، مِنْ شٜنِيطٛ مَاطَ مِ ݧٛلَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","اَ حٛلِّييَمْ طَتٜ طٜ تٛکَّيْمِ مِ حٜٻَ يٛنْکِ، تَا وٛنْدِ اٜ اَمْ مِ نَنَيْ بٜلْطُمْ طُطُّمْ؞›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","بِيتُرُسْ ٻٜيْدِي وِعُکِ، ‏«‏بَنْدِرَاٻٜ، اَلْ مِ وِعَعٛنْ غٛونغَ؞ مَامَ مٜىٰطٜنْ دَوْدَ مَايِي اٛ اُوَامَ، يٜنَاندٜ مَاکٛ اٜ طٛعٛ حَا حَنْدٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","اٛ اَنَّبِيجٛ، اٜ مٛ اَنْدِ اَللَّه وَطَنِيمٛ اَلْکَوَلْ حُنِي وِعُکِ غٛطّٛ دَغَ ندٜرْ لٜݧٛلْ مَاکٛ وَرْتَيْ لَامِيطٛ، وَاتٛ اَلْمَسِيحُ؞ ");
INSERT INTO fuv_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","اٛ يِعِي کٛ وَرٛيْتَ يٜىٰسٛ، اٛ مٜتِي دٛوْ اُمَّاکِ اَلْمَسِيحُ دَغَ مَيْدٜ؞ اٛ وِعِي اَللَّه اَلَتَا اَلْمَسِيحُ ندٜرْ يٜنَاندٜ، ٻَنْدُ مَاکٛ بٛو ݧٛلَتَا؞ ");
INSERT INTO fuv_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","اَلْمَسِيحُ اٛنْ وٛنِ يٜىٰسُ مٛ اَللَّه اُمِّنِ دَغَ مَيْدٜ؞ مِنْ فُو اٜ مِنْ شٜيْدِيطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","اَللَّه مَوْنِنِيمٛ، جٛوطِنِيمٛ اٜ جُنْغٛ مُوطُمْ ݧَامٛ حٛکِّمٛ رُوحُ مُوطُمْ نٛ اٛ وَطُنٛو اَلْکَوَلْ؞ کَنْکٛ بٛو اٛ حٛکِّيمِنْطُمْ؞ کَنْجُمْ وٛنِ کٛ نغِعٛتٛنْ اٜ کٛ نَنٛتٛنْ جٛونِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","نغَمْ دَوْدَ يَحَايِ وُرٛ جٛومِرَاوٛ تٛنْ دٛوْ، اَمَّا اٛ وِعِي، ‏‹‏جٛومِرَاوٛ مٜتَنِي اَلْمَسِيحُ جٜيْطٛيَمْ، وِعِي، جٛوطَ اٜ جُنْغٛ اَمْ ݧَامٛ، ");
INSERT INTO fuv_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","نَا مِ وَطِي وَݧْوَݧْٻٜ مَاطَ نغَرْتِي تٛ نجٛوَتَا کٛيْطٜ مَاطَ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","‏«‏نغَمْ مَاجُمْ اٜ حَانِ يِمْٻٜ اِسْرَاعِيلَ فُو تَبِّتِنَ اَللَّه سُٻِي يٜىٰسُ مٛ مبَرْطٛنْ دٛوْ غَافَانغَلْ وَرْتَ اَلْمَسِيحُ جٜيْطٛ لَامُ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","ندٜ ٻٜ نَنِ بٛلِيطٜ طٜنْ، ٻٜرْطٜ مَٻّٜ تَپِ، ٻٜ مبِعِ بِيتُرُسْ اٜ لِلَاٻٜ حٛرِيٻٜ، ‏«‏بَنْدِرَاٻٜ، طُمٜ مِنْ نغَطَتَ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","بِيتُرُسْ وِعِ، ‏«‏کٛو مٛيٜ مٛوطٛنْ تُوبَ وَطَنٜىٰ بَڤْتِسْمَ ندٜرْ اِنْدٜ يٜىٰسُ اَلْمَسِيحُ نغَمْ کٜٻٛنْ يَافَنٜىٰکِ حَکّٜ مٛوطٛنْ؞ ندٜنْ اَللَّه حٛکَّيْعٛنْ رُوحُ مُوطُمْ شَاحُ؞ ");
INSERT INTO fuv_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","نغَمْ اَللَّه وَطِي اَلْکَوَلْ مُوطُمْ نغَمْ مٛوطٛنْ، اٜ ٻِٻّٜ مٛوطٛنْ حَا اٜ يِمْٻٜ وٛطُّٻٜ، اٜ کٛو مٛيٜ مٛ اَللَّه مٜىٰطٜنْ نٛدِّ وَرَ تٛ مُوطُمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","غَطَ مَاجُمْ اٛ وَغِّنِٻٜ اٜ بٛلِيطٜ طُطّٜ، اٜ مٛ تٛرٛوٻٜ، اٜ مٛ وِعَ، ‏«‏کِسْنٜىٰ کٛعٜ مٛوطٛنْ دَغَ جَامَنُ کَلُّطُمْ طُعُمْ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","فُو جَٻُٻٜ کٛ بِيتُرُسْ وِعِ ٻٜ نغَطَنَا بَڤْتِسْمَ؞ ݧَلْندٜ ندٜنْ حَادٜ يِمْٻٜ 3,000 ٻٜيْدِي ندٜرْ کَوْتَلْ کٛولِيٻٜ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","ٻٜ نغَطِ کَ تٛکُّکِ اٜکِّتِنٛلْ لِلَاٻٜ، اٜ ٻٜ شُمْڤٛوتِرَ، اٜ ٻٜ ݧَمْدَ، اٜ ٻٜ نغَادَ دٛعَارٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","کُلٛلْ نَنْغِ کٛو مٛيٜ، نغَمْ اَللَّه اٜ وَطَ اَلَامَاجِ کَيْطِنِيطِ طُطِّ دَغَ جُوطٜ لِلَاٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","فُو کٛولِيٻٜ يٜىٰسُ کَوْتِ حٛورٜ، اٜ ٻٜ شٜنْدَ فُو کٛ ٻٜ نغٛودِ حَکُّندٜ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","ٻٜ شٛورِ غٜسٜ مَٻّٜ اٜ کٛ ٻٜ نغٛودِ، ٻٜ شٜنْدَنِ کٛو مٛيٜ مَٻّٜ فُو کٛ حَانِ نغَمْ مُوطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","کٛو ندٜيٜ ݧَلْندٜ اٜ ٻٜ کَوْرِتَ ندٜرْ وُرٛ شٜنِينغٛ؞ اٜ ٻٜ ݧَمْدَ ندٜرْ غُرٜ مَٻّٜ اٜ ٻٜرْطٜ لَٻْطٜ اٜ وٜلْوٜلٛ مَنْغٛ، ");
INSERT INTO fuv_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","اٜ ٻٜ مَنْتَ اَللَّه؞ يِمْٻٜ فُو اٜ نغِطِٻٜ؞ کٛو ندٜيٜ ݧَلْندٜ بٛو جٛومِرَاوٛ اٜ ٻٜيْدَنَٻٜ تُوبٛوٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","وٛنْدٜ ݧَلْندٜ بِيتُرُسْ اٜ يَحَيَ اٜ نجَحَ وُرٛ شٜنِينغٛ شَرٜلْ دٛعَارٜ، نجَمْندِ تَتِ ندِ ݧَلَوْمَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","اٜ وٛودِ غٛطّٛ نٜطّٛ دَغَ اٛ دَݧَا اٛ جَرَاطٛ، اٜ مٛ جٛوطِي اٜ دَمُّغَلْ وُرٛ شٜنِينغٛ بِعٜتٜىٰنغَلْ دَمُّغَلْ بٛنْغَلْ؞ کٛو ندٜيٜ ݧَلْندٜ يِمْٻٜ مَاکٛ اٜ نجَارَمٛ تٛ دَمُّغَلْ نغَلْ نغَمْ اٛ تٛرٛو نَتّٛوٻٜ وُرٛ شٜنِينغٛ شٜىٰدٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","تٛو، ندٜ اٛ يِعِ بِيتُرُسْ اٜ يَحَيَ اٜ نَتَّ، سٜيْ اٛ تٛرِيٻٜ شٜىٰدٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","ٻٜ شُتِيمٛ، بِيتُرُسْ وِعِمٛ، ‏«‏رَارُمِنْ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","اٛ رَارِٻٜ اٜ مٛ کَمّٛو حٜٻُکِ غٛطُّمْ تٛ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","بِيتُرُسْ وِعِمٛ، ‏«‏مِ وَلَا شٜىٰدٜ، اَمَّا مِ حٛکّٜتٜ کٛ نغٛودُمِ؞ ندٜرْ اِنْدٜ يٜىٰسُ اَلْمَسِيحُ نَجَرَنْکٜىٰجٛ، اٜ مِ وِعِمَا، اُمَّ، نجَاٻَا!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","سٜيْ بِيتُرُسْ نَنْغِ جُنْغٛ مَاکٛ ݧَامٛ دَرْنِمٛ؞ طٛنْ اٜ طٛنْ کٛيْطٜ مَاکٛ شٜمْبِطِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","اٛ دِوِ اٛ فُطِّ يَادُ؞ اٛ نَتِّدِ اٜ مَٻّٜ ندٜرْ وُرٛ شٜنِينغٛ؞ اٜ مٛ يَحَ، اٜ مٛ دِوَ، اٜ مٛ يٜتَّ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","يِمْٻٜ فُو نغِعِمٛ اٜ مٛ يِيلٛو، اٜ مٛ يٜتَّ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ٻٜ اَنْدِتِي کَنْکٛ وٛنِ جٛوطٛتٛوطٛ اٜ دَمُّغَلْ بٛنْغَلْ نغَلْ وُرٛ شٜنِينغٛ اٜ تٛرٛو يِمْٻٜ شٜىٰدٜ؞ ٻٜ فُو ٻٜ کَيْطِنِ نَاع سٜطَّ کٛ طُوطِ دٛوْ کٛ حٜٻِ نٜطّٛ اٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","جَرَاطٛ جَمْطِتِنَاطٛ اٛنْ اٜ جٛغٛوتِرِ اٜ بِيتُرُسْ اٜ يَحَيَ ندٜرْ رُمْڤَارُ مَوْندُ بِعٜتٜىٰندُ رُمْڤَارُ سُلٜيْمَانُ، سٜيْ يِمْٻٜ طُطْٻٜ ندٛغّٛيِ کَوْرِتِ تٛ مَٻّٜ اٜ کَيْطِنَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","ندٜ بِيتُرُسْ يِعِ يِمْٻٜ کَوْرِتِي، سٜيْ اٛ وِعِٻٜ، ‏«‏اٛنٛنْ بَنْدِرَاٻٜ اَمْ اِسْرَاعِيلَنْکٛعٜنْ، نغَمْ طُمٜ کَيْطِنْتٛنْ؟ نغَمْ طُمٜ ندَارٛتٛنْمِنْ؟ اٛنْ کَمِّي اٜ بَوْطٜ اَمِنْ کٛو نغَمْ تِينَارٜ اَمِنْ دٛوْ تٛکُّکِ اَللَّه مِنْ نجَمْطِتِنِرِ جَرَاطٛ اٛعٛ؟ ");
INSERT INTO fuv_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","اَللَّه مٛ اِبْرَاهِمْ اٜ اِشِيَاکُ اٜ يَاکُبُ، اَللَّه مٛ مَامَعٜنْ مٜىٰطٜنْ، اٛ تٜدِّنِي مَشُّطٛ مَاکٛ يٜىٰسُ؞ اَمَّا کَنْکٛ وٛنِ مٛ کٛکِّتِرْنٛوطٛنْ نغَمْ اٛ وَرٜىٰ؞ اٛنْ نغَݧِيمٛ يٜىٰسٛ بِلَاتُسْ کٛو ندٜ بِلَاتُسْ اٜ يِطِ يٛوفُکِمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","اٛ شٜنِيطٛ اَادِلِيجٛ، اَمَّا اٛنْ نغَݧِيمٛ، اٛنْ تٛرَکٜ بِلَاتُسْ يٛوفَنَعٛنْ غَطّٛ وَرْحٛورٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","اٛنْ مبَرِي کٛکَّيْطٛ يٛنْکِ، اَمَّا اَللَّه اُمِّنِيمٛ دَغَ مَيْدٜ؞ مِنٛنْ بٛو، مِنْ شٜيْدُعٜنْ مَاجُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","نغَمْ دَغَ ندٜرْ بَوْطٜ غٛنْطٜ ندٜرْ اِنْدٜ يٜىٰسُ، نٜطّٛ جَرَاطٛ اٛعٛ مٛ نغِعٛتٛنْ مٛ اَنْدُطٛنْ حٜٻِ نجَمُ؞ نغَمْ حٛولَاکِ اِنْدٜ يٜىٰسُ وَطِ اٛ حٜٻِ نجَمُ يٜىٰسٛ مٛوطٛنْ، اٛنْ فُو اٛنْ شٜيْدُعٜنْ مَاجُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","‏«‏جٛونِ بَنْدِرَاٻٜ اَمْ، اٜ مِ اَنْدِ کٛ نغَطَنْطٛنْ يٜىٰسُ اٛنٛنْ اٜ مَوْٻٜ مٛوطٛنْ اٛنْ نغَطُطُمْ نغَمْ شِيَ اَنْدَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","نٛنْ اَللَّه حٜبِّنِرِ کٛ اَنَّبٛعٜنْ مُوطُمْ فُو مبِعِ کٛ نٜىٰٻِ، ٻٜ مبِعِي اَلْمَسِيحُ تٛرّٛتٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","نغَمْ نٛنْ، تُوبٜىٰ، شٛعّٛوطٛنْ تٛ جٛومِرَاوٛ نغَمْ اٛ يَافَنٛوعٛنْ حَکّٜ مٛوطٛنْ، اٛ سٜمْبِطِنَعٛنْ ندٜرْ تٛکُّکِمٛ، ");
INSERT INTO fuv_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","اٛ وَرْتِرَنَعٛنْ يٜىٰسُ اَلْمَسِيحُ مٛ اٛ وَطَنِعٛنْ اَلْکَوَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","دٛولٜ يٜىٰسُ جٛوطٛو ندٜرْ وُرٛ اَللَّه تٛنْ دٛوْ حَا يَاکِ شَرٜلْ نغٜلْ اَللَّه وَرْتِرْتَ کٛو طُمٜ کٜسُمْ، نٛ اٛ وِعُنٛو ندٜرْ کٛنْدُطٜ اَنَّبٛعٜنْ مَاکٛ شٜنِيٻٜ دَغَ ندٜنّٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","نغَمْ مُوسَ وِعِي، ‏‹‏اَللَّه جٛومِرَاوٛ مٛوطٛنْ لِلْدٛنٛيَيْعٛنْ اَنَّبِيجٛ دَغَ ندٜرْ مٛوطٛنْ نٛنْ نٛ اٛ لِلْدٛيِيَمْ تٛ مٛوطٛنْ؞ نجَٻٜىٰ کٛو طُمٜ کٛ اٛ وِعَتَعٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","نٜطّٛ فُو مٛ جَٻَايِ اَنَّبِيجٛ اٛنْ، طُمْ وُرْتِنَيْمٛ ندٜرْ يِمْٻٜ اَللَّه اٛ حَلْکٜىٰ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","اَنَّبٛعٜنْ فُو دَغَ سَمَاعِلَ حَا يَاکِ اَنَّبٛعٜنْ تٛکُّٻٜ غَطَ مَاکٛ، ٻٜ فُو ٻٜ مٜتِي دٛوْ کٛ وَطَتَ ندٜرْ بَلْطٜ طٜعٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","فُو اَنَّبَاکُوجِ طِ اَنَّبٛعٜنْ نغَطِ طِ نغَطَ نغَمْ مٛوطٛنْ؞ اٛنٛنْ نغٛنِ رٛنٛوٻٜ اَلْکَوَلْ نغَلْ اَللَّه وَطَنِ مَامَعٜنْ مٜىٰطٜنْ ندٜ اٛ وِعِ اِبْرَاهِمْ، ‏‹‏دَغَ دَݧْنغٛلْ مَاطَ مِ بَرْکِطِنَيْ لٜپِّ دُونِيَارُ فُو؞›‏ ");
INSERT INTO fuv_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","ندٜ اَللَّه سُٻِ يٜىٰسُ مَشُّطٛ مَاکٛ، اٛ اَرْتِي لِلٛيْکِمٛ تٛ مٛوطٛنْ نغَمْ اٛ بَرْکِطِنَعٛنْ، اٛ وَيْلِتَ کٛو مٛيٜ مٛوطٛنْ اَلَ کُوغَلْ مُوطُمْ کَلُّنغَلْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","بِيتُرُسْ اٜ يَحَيَ اٜ مٜدَّ اٜ يِمْٻٜ، سٜيْ اَرْدِيٻٜ دِينَ اٜ مَوْطٛ تَادِيٻٜ وُرٛ شٜنِينغٛ اٜ سَادُسَنْکٛعٜنْ نغَرِ تٛ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","ٻٜرْطٜ مَٻّٜ اٜ مٜتِّ نغَمْ بِيتُرُسْ اٜ يَحَيَ اٜ نغَعَجِنَ وِعُکِ يِمْٻٜ مَيْٻٜ اُمّٛدٛتٛ اٜ يٛنْکِ، نغَمْ يٜىٰسُ اُمَّکٜ دَغَ مَيْدٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","نغَمْ مَاجُمْ ٻٜ نَنْغِٻٜ، ٻٜ مَٻِّٻٜ ندٜرْ سُودُ شُرَلْ حَا سُبَکَ، نغَمْ حِيرِي کٛ ٻٜ نَنْغِٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","طُطْٻٜ ندٜرْ نَنْٻٜ وَعَجُ مَٻّٜ تٛکِّ يٜىٰسُ، حَا طُوطٛرَلْ تٛکُّٻٜ يٜىٰسُ وَطِ يِمْٻٜ 5,000؞ ");
INSERT INTO fuv_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","ندٜ فِنِ، اَرْدِيٻٜ اٜ مَوْٻٜ اٜ مٛودِٻّٜ اَتَّوْرَ کَوْرِتِ اٜ اُرُشَلِيمَ، ");
INSERT INTO fuv_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","کَمْٻٜ اٜ حَنَانَ مَوْطٛ مَوْٻٜ اَرْدِيٻٜ دِينَ، اٜ کَيَافَ، اٜ يَحَيَ، اٜ اَلِجَنْدَ، اٜ وٛٻّٜ ندٜرْ بَنْدِرَاٻٜ حَنَانَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","ٻٜ ندَرْنِ بِيتُرُسْ اٜ يَحَيَ يٜىٰسٛ مَٻّٜ، ٻٜ پَمِٻٜ ٻٜ مبِعِ، ‏«‏اٜ اِرِ طٜيٜ بَوْطٜ، کٛو ندٜرْ اِنْدٜ مٛيٜ نجَمْطِتِنِرْطٛنْ جَرَاطٛ اٛنْ طٛنْ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","بِيتُرُسْ اٜ حٜىٰوِ رُوحُ اَللَّه، وِعِٻٜ، ‏«‏اٛنٛنْ اَرْدِيٻٜ يِمْٻٜ اٜ مَوْٻٜ، ");
INSERT INTO fuv_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","حَنْدٜ اٛنْ پَمَمِنْ دٛوْ فِي بٛطُّمْ طُمْ مِنْ نغَطَنِ اٛعٛ جَرَاطٛ اٜ نٛ اٛ يَمْطِتِنِرَا؞ ");
INSERT INTO fuv_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ندَرٜىٰ مِ وِعَعٛنْ اٛنٛنْ يِمْٻٜ اِسْرَاعِيلَ فُو، نٜطّٛ اٛعٛ جَمْطِتِنَاطٛ، دَرِيطٛ يٜىٰسٛ مٛوطٛنْ طٛعٛ، اٛ يَمْطِتِنَ ندٜرْ اِنْدٜ يٜىٰسُ اَلْمَسِيحُ نَجَرَنْکٜىٰجٛ مٛ مبَرْطٛنْ دٛوْ غَافَانغَلْ، مٛ اَللَّه اُمِّنِ دَغَ مَيْدٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","کَنْکٛ وٛنِ مٛ جٛومِرَاوٛ وِعِ ندٜرْ دٜفْتٜرٜ شٜنِيندٜ، ‏‹‏حَيْرٜ ندٜ مَحٛوٻٜ نغَݧِ، کَيْرٜ وَرْتِ حَيْرٜ ٻُرْندٜ دَرْنُکِ مَادِ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","تٛ مَاکٛ تَنْ کِسْندَمْ حٜٻٜتٜىٰ، نغَمْ وَلَا وٛنْدٜ اِنْدٜ فٜىٰرٜ ندٜرْ دُونِيَارُ ندٜ اَللَّه حٛکِّ ندٜ طُمْ حِسِرْتَ تٛ نَاع اِنْدٜ يٜىٰسُ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","مَوْٻٜ ٻٜنْ کَيْطِنِ ندٜ ٻٜ نغِعِ بِيتُرُسْ اٜ يَحَيَ اٜ مٜتَ ٻٜرْندٜ غٛعٛ، حَکّٛ ندٜ ٻٜ نَنِ ٻٜ لَدّٜعٜنْ، نَاع ٻٜ جَنْغُٻٜ؞ سٜيْ ٻٜ ڤَامِ بِيتُرُسْ اٜ يَحَيَ اٜ ٻٜ نجَادَيْنٛو اٜ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","اَمَّا ٻٜ کٜٻَايِ کٛ ٻٜ مبِعِ نغَمْ نٜطّٛ مٛ بِيتُرُسْ اٜ يَحَيَ يَمْطِتِنِ اٜ دَرٛدِي اٜ مَٻّٜ طٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","ٻٜ مبِعِ بِيتُرُسْ اٜ يَحَيَ مبُرْتٛو يَاسِ؞ ٻٜ نغَطِ شَاوٛرِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","اٜ ٻٜ مبِعَ حَکُّندٜ مَٻّٜ، ‏«‏کٛ نغَطَنْتٜنْ ٻٜعٜ يِمْٻٜ؟ اٜنْ مبَاوَتَا يٜدُّکِ کٛ ٻٜ نغَطِ نغَمْ کٛو مٛيٜ جٛوطِيطٛ ندٜرْ اُرُشَلِيمَ نَنِي ٻٜ نغَطِي فِي کَيْطِنِيطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","اَمَّا نغَمْ حَطُکِ حَالَ کَنْ سَنْکِتَاکِ ندٜرْ يِمْٻٜ، سٜيْ مبَغِّنٜنْٻٜ تٛع ٻٜ ڤُطِّتَ ٻٜ مٜتَنَ غٛطّٛ دٛوْ اِنْدٜ يٜىٰسُ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","سٜيْ ٻٜ نٛدِّتِي بِيتُرُسْ اٜ يَحَيَ ندٜرْ سُودُ ندُنْ، ٻٜ مبِعِٻٜ تٛع ٻٜ ڤُطِّتَ ٻٜ مٜتَنَ غٛطّٛ کٛو ٻٜ اٜکِّتِنَ غٛطّٛ ندٜرْ اِنْدٜ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","اَمَّا بِيتُرُسْ اٜ يَحَيَ مبِعِٻٜ، ‏«‏اٛنٛنْ اٜ کٛعٜ مٛوطٛنْ، شُٻٜىٰ طُمٜ ٻُرِ وٛوطُکِ يٜىٰسٛ اَللَّه، مِنْ نغَطَ کٛ نغِطّٛنْ کٛو مِنْ نغَطَ کٛ اَللَّه يِطِ؟ ");
INSERT INTO fuv_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","مِنٛنْ کَمْ، مِنْ مبَاوَتَا مِنْ اَلَ مٜتُکِ دٛوْ کٛ مِنْ نغِعِ اٜ غِتٜ اَمِنْ اٜ کٛ مِنْ نَنِ اٜ نٛڤِّ اَمِنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","مَوْٻٜ اَرْدِيٻٜ دِينَ اٜ مَوْٻٜ يِمْٻٜ ٻٜيْدِ وَغِّنْکِ بِيتُرُسْ اٜ يَحَيَ؞ غَطَ مَاجُمْ ٻٜ نجٛوفِٻٜ، ٻٜ کٜٻَايِ لَاوٛلْ نٛ ٻٜ تٛرِّرْتَٻٜ نغَمْ يِمْٻٜ فُو اٜ مَنْتَ اَللَّه دٛوْ فِي کَيْطِنِيطُمْ طُمْ ٻٜ نغَطِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","نٜطّٛ جَمْطِتِنَاطٛ اٛنْ اٛ ٻُرِي دُوٻِ 40؞ ");
INSERT INTO fuv_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","ندٜ بِيتُرُسْ اٜ يَحَيَ نجٛوفَا ٻٜ شٛعِّي تٛ بَنْدِرَاٻٜ مَٻّٜ تٛکُّٻٜ يٜىٰسُ ٻٜ طِيوِتَنِٻٜ فُو کٛ مَوْٻٜ اَرْدِيٻٜ دِينَ اٜ مَوْٻٜ مبِعِٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","ندٜ تٛکُّٻٜ يٜىٰسُ ٻٜنْ نَنِ نٛنْ، ٻٜ فُو ٻٜ اُمِّي ٻٜ نغَطِ دٛعَارٜ اٜ ٻٜرْندٜ وٛعٛيْرٜ، ٻٜ مبِعِ، ‏«‏يَا جٛومِرَاوٛ، تَغُطٛ دٛوْ اٜ لٜيْ اٜ مَايٛ اٜ کٛ وٛنِ ندٜرْ مَاجُمْ فُو، ");
INSERT INTO fuv_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","اَنْ مٜتِ اٜ حٛنْدُکٛ مَامَ اَمِنْ دَوْدَ مَشُّطٛ مَاطَ ندٜرْ رُوحُ اَللَّه اٛ وِعِ، ‏‹‏نغَمْ طُمٜ يِمْٻٜ نَاع يَحُودَنْکٛعٜنْ مٜتِّنِ ٻٜرْطٜ مَٻّٜ نَاع سٜطَّ؟ نغَمْ طُمٜ يِمْٻٜ ݧُمِ ݧُمٛوجِ مٜىٰرٜ؟ ");
INSERT INTO fuv_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","لَامِيٻٜ دُونِيَارُ شِرْيَکٜ حَوْرٜ، اَرْدِيٻٜ کَوْرِتِي نغَمْ ٻٜ کٛنَ جٛومِرَاوٛ اٜ اَلْمَسِيحُ مَاکٛ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","رَا بٛو، ندٜرْ غَرِيرِ ندِعِ حِرُدُسْ اٜ بِلَاتُسْ اٜ يِمْٻٜ اِسْرَاعِيلَ اٜ غٛطِّ لٜپِّ ٻٜ کَوْتِي کٛعٜ مَٻّٜ ٻٜ نغَݧِي يٜىٰسُ، مَشُّطٛ مَاطَ شٜنِيطٛ مٛ شُٻُطَا، ");
INSERT INTO fuv_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","نغَمْ فُو کٛ ٻٜ کُوِ دَغَ اَرَنْدٜ اٜ بَوْطٜ مَاطَ اَ سِرْيَکٜنٛ نٛنْ طُمْ وَارَتَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","جٛونِ جٛومِرَاوٛ، اَ نَنِي بٛلِيطٜ مَٻّٜ کَلُّطٜ، حٛکُّ مَشُّٻٜ مَاطَ سٜمْبٜ وَعَجِنْکِ بٛلِيطٜ مَاطَ کُلٛلْ وَلَا، ");
INSERT INTO fuv_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","حٛلُّ بَوْطٜ مَاطَ، يَمْطِتِنْ ݧَوْٻٜ، وَطُ اَلَامَاجِ اٜ کُوطٜ کَيْطِنِيطٜ ندٜرْ اِنْدٜ يٜىٰسُ مَشُّطٛ مَاطَ شٜنِيطٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","ندٜ ٻٜ نجٛتِّنِ دٛعَارٜ وُرٛ نغٛ ٻٜ کَوْرِتِ دِمْبِي؞ ٻٜ فُو ٻٜ کٜىٰوِ رُوحُ اَللَّه، ٻٜ نغَعَجِنِ وٛلْدٜ اَللَّه کُلٛلْ وَلَا؞ ");
INSERT INTO fuv_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","فُو کٛولِيٻٜ يٜىٰسُ ٻٜرْطٜ مَٻّٜ اٜ حَکِّيلٛ مَٻّٜ وَرْتِ غٛعٛ؞ وَلَا بِعٛووٛ کَنُمْ جٜيِ کٛ وٛودِ، اٜ ٻٜ شٜنْدَ کٛو طُمٜ طُمْ ٻٜ نغٛودِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","لِلَاٻٜ ٻٜنْ ندٜرْ بَوْطٜ ٻٜ نغَطِ کَ وَعَجِنْکِ اُمَّاکِ يٜىٰسُ جٛومِرَاوٛ دَغَ مَيْدٜ؞ کٛو مٛيٜ مَٻّٜ اٜ وٛنْدِ اٜ بَرْکَ اَللَّه مَوْطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC4_34‏","074_4_34‏","ACT","4","34‏","35","وَلَا کٛو مٛيٜ ندٜرْ مَٻّٜ دُلُّطٛ غٛطُّمْ، نغَمْ غٛودُٻٜ غٜسٜ اٜ غُرٜ فُو شٛورِيطٜ کٛکِّي لِلَاٻٜ شٜىٰدٜ طٜنْ نغَمْ ٻٜ کٛکَّ کٛو مٛيٜ مٛ وَلَنَا ندٜرْ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","اٜ وٛودِ غٛطّٛ لٜىٰوِيَنْکٜىٰجٛ، نٜطّٛ لٜيْدِ سَيِيفُرُسْ بِعٜتٜىٰطٛ يُسُفُ، مٛ لِلَاٻٜ نٛدِّرْتَ بَرْنَبَ ﴿مَعَنَ اِنْدٜ مَاکٛ وٛنِ شٜمْبِطِنٛووٛ ٻٜرْطٜ﴾، ");
INSERT INTO fuv_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","اٛ سٛورِ نغٜسَ مَاکٛ، اٛ حٛکِّ لِلَاٻٜ شٜىٰدٜ طٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","اَمَّا اٜ وٛودِ غٛطّٛ بِعٜتٜىٰطٛ حَنَانِيَ اٜ دٜبّٛ مَاکٛ سَفِيرَتُ؞ کَنْکٛ مَا اٛ سٛورِ نغٜسَ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","اٛ سٜنْدِ شٜىٰدٜ طٜنْ اٜ اَنْدَلْ دٜبّٛ مَاکٛ؞ اٛ سُوطِ غٛطّٜ اٛ يَارِ کٛرِيطٜ اٛ حٛکِّ لِلَاٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","بِيتُرُسْ وِعِمٛ، ‏«‏حَنَانِيَ، نغَمْ طُمٜ اَلُطَا شٜيْطَنْ نَتِّ ٻٜرْندٜ مَاطَ حَا ڤٜوَنْطَا رُوحُ اَللَّه، شُوطُطَا غٛطّٜ شٜىٰدٜ ندٜرْ شٜىٰدٜ نغٜسَ کَنْ؟ ");
INSERT INTO fuv_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","کٛ شٛورُطَا طُمْ، نَاع اُمْ طُمْ مَاطَ؟ ندٜ شٛورُطَاطُمْ نَاع اَنْ جٜيِ شٜىٰدٜ طٜنْ؟ کٛ وَطِ نغَطُطَا نٛنْ؟ نَاع يِمْٻٜ ڤٜوَنْطَا، اَمَّا اَللَّه ڤٜوَنْطَا؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","ندٜ حَنَانِيَ نَنِ بٛلِيطٜ طٜنْ، اٛ يَنِ اٛ مَايِ؞ کُلٛلْ مَنْغٛلْ نَنْغِ نَنْٻٜ حَبَرُ طُمْ فُو؞ ");
INSERT INTO fuv_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","وٛٻّٜ کَيٜعٜنْ اُمِّي، تَارِ ٻَنْدُ مَاکٛ اٜ غُدٜ، کٛشِّمٛ، مبُرْتِنِمٛ يَاسِ، اُوٛيِمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","غَطَ اَوَاجِ تَتِ سٜيْ رَا دٜبّٛ مَاکٛ وَرِ نَتّٛيِ؞ اٛ اَنْدَا کٛ وَطِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","بِيتُرُسْ وِعِمٛ، ‏«‏وِعَمْ، طٜعٜ شٜىٰدٜ کَنْجٜ تَنْ شٛورُطٛنْ نغٜسَ مٛوطٛنْ؟»‏ اٛ وِعِ، ‏«‏اٜىٰ، طُمْ نٛنْ مِنْ شٛورِکَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","ندٜنْ بِيتُرُسْ وِعِمٛ، ‏«‏نغَمْ طُمٜ کَوْتُطٛنْ حٛورٜ نغَمْ فٛوندُکِ رُوحُ جٛومِرَاوٛ؟ رَا، اُوٛيْٻٜ غٛرْکٛ مَاطَ طٛنْ نغَرَ، جٛونِ ٻٜ کٛشّٜتٜ اَنْ مَا!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","طٛنْ اٜ طٛنْ کَنْکٛ مَا اٛ يَنِ حَادٜ کٛيْطٜ بِيتُرُسْ، اٛ مَايِ؞ کَيٜعٜنْ ٻٜنْ نَتِّ تَوِ اٛ مَيْطٛ، ٻٜ کٛشِّمٛ ٻٜ مبُرْتِنِمٛ، ٻٜ اُوٛيِمٛ حَادٜ غٛرْکٛ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","کُلٛلْ مَنْغٛلْ نَنْغِ کَوْتَلْ تٛکُّٻٜ يٜىٰسُ اٜ نَنْٻٜ حَبَرُ طُمْ فُو؞ ");
INSERT INTO fuv_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","لِلَاٻٜ نغَطِ اَلَامَاجِ اٜ کُوطٜ کَيْطِنِيطٜ طُطّٜ ندٜرْ يِمْٻٜ؞ کٛولِيٻٜ يٜىٰسُ فُو اٜ کَوْرِتَ ندٜرْ رُمْڤَارُ سُلٜيْمَانُ مَوْندُ ندٜرْ ݧُمٛ غٛعٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","کٛو مٛيٜ مٛ وَلَا ندٜرْ کَوْتَلْ مَٻّٜ اٜ حُلَ نَتُّکِٻٜ، کٛو ندٜ کٛو مٛيٜ اٜ حٛکَّٻٜ مَنْغُ نَاع سٜطَّ؞ ");
INSERT INTO fuv_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","فُو اٜ نٛنْ کٛو ندٜيٜ يِمْٻٜ طُطْٻٜ، وٛرْٻٜ اٜ رٜوْٻٜ، اٜ ٻٜيْدٛو ندٜرْ تٛکُّٻٜ يٜىٰسُ، ");
INSERT INTO fuv_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","حَا طُمْ وَرْتِ يِمْٻٜ اٜ کٛشّٛيَ ݧَوْٻٜ، اٜ ٻٜ مبُرْتِنٛيَٻٜ دٛوْ طَتٜ، اٜ ٻٜ ڤُکِّنَٻٜ دٛوْ لٜىٰشٜ اٜ دَاغٜ، نغَمْ تٛ بِيتُرُسْ وَرِي کٛو طٛوْدِ مَاکٛ مَا تَنْ مٜىٰمَ وٛٻّٜ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","يِمْٻٜ طُطْٻٜ دَغَ نغَرِحٛيْ ڤِلِيکٛيْ اُرُشَلِيمَ مَا نغَدِّنغَدِّنِ ݧَوْٻٜ اٜ غٛودُٻٜ غِنِّ؞ ٻٜ فُو بٛو ٻٜ نجَمْطِتِنَا؞ ");
INSERT INTO fuv_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","ندٜنْ مَوْطٛ مَوْٻٜ اَرْدِيٻٜ دِينَ اٜ وٛنْدُٻٜ اٜ مَاکٛ، وَاتٛ سَادُسَنْکٛعٜنْ، ٻٜ اُمِّنِ لَوْلِيرُ کَلُّندُ؞ ");
INSERT INTO fuv_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","ٻٜ نَنْغِ لِلَاٻٜ، ٻٜ مَٻِّٻٜ ندٜرْ سُودُ شُرَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","اَمَّا ندٜرْ جٜمَّارٜ ندٜنْ مَلَاعِکَاجٛ جٛومِرَاوٛ وَرِ مَٻِّتَنِ لِلَاٻٜ ٻٜنْ دَمُّطٜ سُودُ شُرَلْ ندُنْ، وُرْتِنِٻٜ، وِعِٻٜ، ");
INSERT INTO fuv_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","‏«‏نجَحٜىٰ ندَرٜىٰ ندٜرْ وُرٛ شٜنِينغٛ، کٛکّٛنْ کٛو مٛيٜ حَبَرُ يٛنْکِ کٜسُمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","ندٜ ٻٜ نَنِ نٛنْ، ٻٜ نَتّٛيِ ندٜرْ وُرٛ شٜنِينغٛ سُبَکَ، طٛنْ اٜ طٛنْ ٻٜ ڤُطِّ اٜکِّتِنْکِ؞ مَوْطٛ مَوْٻٜ اَرْدِيٻٜ دِينَ اٜ وٛنْدُٻٜ اٜ مَاکٛ نٛدِّ کَوْتَلْ مَوْٻٜ اٜ اَرْدِيٻٜ يَحُودَنْکٛعٜنْ فُو؞ ٻٜ مبِعِ طُمْ وُرْتِنٛيَ لِلَاٻٜ ٻٜنْ دَغَ ندٜرْ سُودُ شُرَلْ، ٻٜ نغَدّٜىٰ؞ ");
INSERT INTO fuv_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","اَمَّا ندٜ تَادِيٻٜ نجَحِ، ٻٜ تَوَايِ لِلَاٻٜ ٻٜنْ ندٜرْ سُودُ ندُنْ؞ سٜيْ ٻٜ شٛعِّي، ٻٜ مبِعِ مَوْٻٜ ٻٜنْ، ");
INSERT INTO fuv_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","‏«‏مِنْ تَوِي سُودُ شُرَلْ ندُنْ اٜ مَٻِّي، تَادِيٻٜ اٜ ندَرِي اٜ ندٜىٰنَ دَمُّطٜ طٜنْ، اَمَّا ندٜ مِنْ مَٻِّتِ، مِنْ تَوَايِ کٛو غٛعٛتٛ ندٜرْ مَٻّٜ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","ندٜ مَوْطٛ تَادِيٻٜ وُرٛ شٜنِينغٛ اٜ مَوْٻٜ اَرْدِيٻٜ دِينَ نَنِ نٛنْ، طُمْ وَنِّيٻٜ، ٻٜ اَنْدَا نٛ فِي طُمْ وَرْتَتَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","سٜيْ غٛطّٛ وَرِ، وِعِٻٜ، ‏«‏يِمْٻٜ ٻٜ مَٻُّطٛنْ ندٜرْ سُودُ شُرَلْ اٜ ٻٜ تٛنْ ندٜرْ وُرٛ شٜنِينغٛ اٜ ٻٜ نغَعَجِنَنَ يِمْٻٜ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","ندٜنْ مَوْطٛ تَادِيٻٜ اٛنْ يَادِ اٜ تَادِيٻٜ، ٻٜ نغَدِّ لِلَاٻٜ ٻٜنْ؞ اَمَّا ٻٜ نغَدِّرَايِٻٜ اٜ سٜمْبٜ، نغَمْ اٜ ٻٜ کُلَ تٛ يِمْٻٜ کُبٛرٛوٻٜ اٜ کَاپٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","ندٜ ٻٜ نغَدِّٻٜ، ٻٜ ندَرْنِٻٜ يٜىٰسٛ کَوْتَلْ مَوْٻٜ؞ مَوْطٛ مَوْٻٜ اَرْدِيٻٜ دِينَ پَمْتِٻٜ، ");
INSERT INTO fuv_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","وِعِ، ‏«‏مِنْ کَطِيعٛنْ اٜکِّتِنْکِ دٛوْ اِنْدٜ يٜىٰسُ، اَمَّا اٛنْ شَنْکِتِي وَعَجُ مٛوطٛنْ ندٜرْ اُرُشَلِيمَ فُو؞ کَدِمَا اٛنْ نغِطِ يٛوَنْکِمِنْ حَکّٜ پِيپَمْ وَرُکِمٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","بِيتُرُسْ اٜ لِلَاٻٜ نٛوتِي، مبِعِ، ‏«‏دٛولٜ مِنْ تٛکَّ کٛ اَللَّه وِعِ، نَاع کٛ يِمْٻٜ مبِعِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","اَللَّه مٛ مَامَعٜنْ مٜىٰطٜنْ اُمِّنِي يٜىٰسُ دَغَ مَيْدٜ، غَطَ اٛنْ مبَرِيمٛ دٛوْ غَافَانغَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","اَللَّه حٛکِّيمٛ مَنْغُ، جٛعِّنِيمٛ اٜ جُنْغٛ مُوطُمْ ݧَامٛ، وَرْتِرِيمٛ لَامِيطٛ اٜ کِسْنٛووٛ، نغَمْ يِمْٻٜ اِسْرَاعِيلَ تُوبَ، ٻٜ کٜٻَ يَافَنٜىٰکِ حَکّٜ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","مِنٛنْ نغٛنِ شٜيْدِيٻٜ فِي طُعُمْ، مِنٛنْ اٜ رُوحُ اَللَّه طُمْ اَللَّه حٛکِّ يِمْٻٜ غَطٛوٻٜ کٛ اٛ وِعِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","ندٜ مَوْٻٜ ٻٜنْ نَنِ نٛنْ، ٻٜرْطٜ مَٻّٜ مٜتِّ نَاع سٜطَّ، ٻٜ نغِطِي ٻٜ مبَرَ لِلَاٻٜ ٻٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","اَمَّا غٛطّٛ بِعٜتٜىٰطٛ غَمَالِيَ اُمِّي دَرِي شَکَ کَوْتَلْ مَوْٻٜ؞ کَنْکٛ اٛ فَارِسَنْکٜىٰجٛ اٛ مٛودِبّٛ اَتَّوْرَ، يِمْٻٜ فُو اٜ کٛکَّمٛ مَنْغُ؞ اٛ وِعِ طُمْ وُرْتِنَ لِلَاٻٜ ٻٜنْ يَاسِ شَرٜلْ سٜطَّ؞ ");
INSERT INTO fuv_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","غَطَ ٻٜ مبُرْتِنَامَ، اٛ وِعِ کَوْتَلْ نغَلْ، ‏«‏اٛنٛنْ بَنْدِرَاٻٜ اَمْ اِسْرَاعِيلَنْکٛعٜنْ، ندٜىٰنٜىٰ کٛعٜ مٛوطٛنْ دٛوْ کٛ نغِطّٛنْ وَطَنْکِ يِمْٻٜ ٻٜعٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","کٛ نٜىٰٻَايِ غٛطّٛ بِعٜتٜىٰطٛ تُدَسْ وَنْغِي؞ اٛ حٛشِّي حٛورٜ مَاکٛ بٛ اٛ مَوْطٛ؞ يِمْٻٜ کٛ وَطِ 400 تٛکِّمٛ؞ تٛو، اٛ وَرَامَ، تٛکُّنٛوٻٜمٛ فُو شَنْکِتَکٜ، وَلَا کٛو غٛعٛتٛ دَرِيطٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","غَطَ مَاکٛ، يَحُودَ غَلِلَنْکٜىٰجٛ وَرِي شَرٜلْ کٛ غٛمْنَتِ لِمَتَ يِمْٻٜ، يِمْٻٜ طُطْٻٜ تٛکِّيمٛ؞ کَنْکٛ مَا اٛ وَرَامَ، تٛکُّٻٜمٛ فُو شَنْکِتَکٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","جٛونِ، اٜ مِ وِعَعٛنْ، نغٛطِّتٜىٰ يِمْٻٜ ٻٜعٜ، اَلٜىٰٻٜ؞ نغَمْ تٛ ݧُمٛوجِ مَٻّٜ اٜ کُوغَلْ مَٻّٜ پِوِي تٛ يِمْٻٜ، طُمْ لَلَّيْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","اَمَّا تٛ طُمْ پِوٛيِي تٛ اَللَّه، ندٜنْ کَمْ اٛنْ مبَاوَتَا سَنْکُتُکِطُمْ؞ ڤَامٜىٰ تٛع کَٻْدٛنْ اٜ اَللَّه!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","مَوْٻٜ ٻٜنْ نجَٻِ کٛ اٛ وِعِ؞ ٻٜ نٛدِّتِ لِلَاٻٜ ٻٜنْ، ٻٜ ڤِيِٻٜ، ٻٜ مبِعِٻٜ تٛع ٻٜ ٻٜيْدَ مٜتُکِ دٛوْ اِنْدٜ يٜىٰسُ؞ ندٜنْ ٻٜ نجٛوفِٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","لِلَاٻٜ ٻٜنْ مبُرْتٛيِي ندٜرْ کَوْتَلْ مَوْٻٜ اٜ وٜلْوٜلٛ نغَمْ اَللَّه مَوْنِنِيٻٜ حَا ٻٜ کٜوْتِي سٜمْتِنٜىٰکِ نغَمْ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","کٛو ندٜيٜ ݧَلْندٜ اٜ ٻٜ نغَعَجِنَ حَبَرُ بٜلْطُمْ وِعُکِ يٜىٰسُ وٛنِ اَلْمَسِيحُ، اٜ ٻٜ اٜکِّتِنَ ندٜرْ وُرٛ شٜنِينغٛ اٜ ندٜرْ غُرٜ فُو؞ ");
INSERT INTO fuv_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","ندٜرْ بَلْطٜ طٜنْ، تٛکُّٻٜ يٜىٰسُ اٜ ٻٜيْدَ طُطْکِ؞ سٜيْ يَحُودَنْکٛعٜنْ مٜتٛوٻٜ حٜلٜنَنْکٛورٜ مٜتِتَنِ يَحُودَنْکٛعٜنْ مٜتٛوٻٜ اِبْرَانِيَنْکٛورٜ، نغَمْ رٜوْٻٜ مَٻّٜ ٻٜ وٛرْٻٜ مُعّٜنْ مَايِ کٛکَّتَاکٜ کٛ حَانِ کٛکّٜىٰ ندٜرْ ݧَمْندُ ندُ طُمْ وٛووِ يٜىٰدُکِ کٛو ندٜيٜ ݧَلْندٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","سٜيْ لِلَاٻٜ سَڤّٛ اٜ طِطٛ نٛدِّ کَوْتَلْ تٛکُّٻٜ يٜىٰسُ فُو، ٻٜ مبِعِ، ‏«‏مِنٛنْ، طُمْ حَانَايِ مِنْ اَلَ وَعَجِنْکِ وٛلْدٜ اَللَّه نغَمْ سٜنْدُکِ ݧَمْندُ؞ ");
INSERT INTO fuv_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","نغَمْ نٛنْ، بَنْدِرَاٻٜ، شُٻٜىٰ وٛرْٻٜ نجٛوٜىٰطِطٛ ندٜرْ مٛوطٛنْ ٻٜ طُمْ حٛولِي کٜىٰوُٻٜ رُوحُ اَللَّه، غٛودُٻٜ فَامُ نغَمْ مِنْ کٛکَّٻٜ کُوغَلْ نغَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","اَمَّا مِنٛنْ، مِنْ نغَطَيْ کَ وَطُکِ دٛعَارٜ اٜ مِنْ اٜکِّتِنَ وٛلْدٜ اَللَّه؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","حَالَ کَنْ بٛو وٜلِي کَوْتَلْ تٛکُّٻٜ يٜىٰسُ فُو؞ ندٜنْ ٻٜ شُٻِ اِسْتِفَانُسْ، نٜطّٛ کٛولِيطٛ جٛومِرَاوٛ، کٜىٰوُطٛ رُوحُ اَللَّه، کَنْکٛ اٜ فِلِبُسْ اٜ بُرٛکٛرَسْ اٜ نِکَنٛ اٜ تِمٛنْ اٜ بَرْمٜنَسْ اٜ نِکٛلَسْ پِوٛيْطٛ اَنْتَاکِيَ، نَتُّطٛ دِينَ يَحُودَنْکٛعٜنْ کَنْکٛ نَاع اٛ يَحُودَنْکٜىٰجٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","ٻٜ نغَدِّٻٜ يٜىٰسٛ لِلَاٻٜ؞ سٜيْ لِلَاٻٜ ٻٜنْ نجٛوَنِٻٜ جُوطٜ، نغَطَنِٻٜ دٛعَارٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","وٛلْدٜ اَللَّه بٛو ٻٜيْدِ سَنْکِتَاکِ؞ تٛکُّٻٜ يٜىٰسُ اٜ ٻٜيْدَ طُوطُکِ ندٜرْ غَرِيرِ اُرُشَلِيمَ، حَا اَرْدِيٻٜ دِينَ طُطْٻٜ تٛکِّ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","اَللَّه بَرْکِطِنِ اِسْتِفَانُسْ حٛکِّمٛ بَوْطٜ وَطُکِ کُوطٜ مَوْطٜ کَيْطِنِيطٜ اٜ اَلَامَاجِ ندٜرْ يِمْٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","اَمَّا اٜ وٛودِ وٛٻّٜ ندٜرْ سُودُ دٛعَارٜ بِعٜتٜىٰندُ سُودُ رِمْطِنَاٻٜ، اٜ وٛٻّٜ پِوٛيْٻٜ غَرِيرِ سَايِرِنْ اٜ غَرِيرِ اَلِجَندِيرِيَ اٜ لٜيْدِ کِلِيکِيَ اٜ لٜيْدِ اَاسِيَ، ٻٜ اُمَّنِيمٛ اٜ ٻٜ نغٜدّٛوتِرَ اٜ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","اَمَّا ٻٜ ندُلِّ نٛ ٻٜ نجَالٛرْتٛومٛ نغَمْ اٜ مٛ مٜتِرَ فَامُ اٜ رُوحُ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","سٜيْ ٻٜ کٛکِّ وٛٻّٜ شٜىٰدٜ اٜ سُوطٜ نغَمْ ٻٜ مبِعَ ٻٜ نَنِي اٜ مٛ حُطَ مُوسَ اٜ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","نٛنْ ٻٜ اُمِّنِرِ ٻٜرْطٜ يِمْٻٜ اٜ مَوْٻٜ اٜ مٛودِٻّٜ اَتَّوْرَ؞ سٜيْ ٻٜ نَنْغِ اِسْتِفَانُسْ، ٻٜ نجَارِمٛ يٜىٰسٛ کَوْتَلْ مَوْٻٜ، ");
INSERT INTO fuv_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","ٻٜ نغَدِّ شٜيْدُعٜنْ فٜوْرٜ؞ شٜيْدُعٜنْ ٻٜنْ مبِعِ، ‏«‏کٛو ندٜيٜ نٜطّٛ اٛعٛ اٜ مٜتَ کَلُّکَ دٛوْ وُرٛ شٜنِينغٛ اٜ اَتَّوْرَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","مِنْ نَنِي اٜ مٛ وِعَ يٜىٰسُ نَجَرَنْکٜىٰجٛ سَنْکِتَيْ وُرٛ شٜنِينغٛ، اٛ وَيْلِتَيْ ندٛنُوجِ طِ مُوسَ حٛکِّعٜنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","سٜيْ فُو جٛوطِيٻٜ ندٜرْ کَوْتَلْ نغَلْ شُتِي اِسْتِفَانُسْ، ٻٜ نغِعِ يٜىٰسٛ مَاکٛ وَرْتِي بٛ يٜىٰسٛ مَلَاعِکَاجٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","ندٜنْ مَوْطٛ مَوْٻٜ اَرْدِيٻٜ دِينَ پَمِ اِسْتِفَانُسْ وِعِ، ‏«‏کٛ ٻٜ مبِعِ دٛوْ مَاطَ طُمْ غٛونغَ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","سٜيْ اِسْتِفَانُسْ وِعِ، ‏«‏بَنْدِرَاٻٜ اَمْ اٜ دَݧٛوٻٜ اَمْ، نَنٜىٰ کٛ مبِعَيْمِ!‏ اَللَّه جٛومُ مَنْغُ وَنْغَنِي مَامَ مٜىٰطٜنْ اِبْرَاهِمْ شَرٜلْ کٛ اٛ وٛنّٛو لٜيْدِ مٜسٛفٛتَامِيَ، کٛ اٛ جٛوطٛو لٜيْدِ حَرَنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","اَللَّه وِعِمٛ، ‏‹‏وُرْتَ لٜيْدِ مَاطَ اٜ يِمْٻٜ مَاطَ، نجَحَا لٜيْدِ ندِ کٛلَّيْمَامِ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","ندٜنْ اِبْرَاهِمْ وُرْتِي لٜيْدِ کَلْدِيَ، اٛ يَحِ اٛ جٛوطِي ندٜرْ لٜيْدِ حَرَنْ؞ غَطَ مَيْدٜ ݧَاکٛ مَاکٛ، اَللَّه اُمِّنِمٛ طٛنْمَا يَارِمٛ ندٜرْ لٜيْدِ ندِ نجٛوطِيطٛنْ جٛونِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","اَللَّه حٛکَّايِمٛ ندٛنُ لٜيْدِ ندِنْ کٛو يَاٻَندٜ وٛعٛيْرٜ، اَمَّا اٛ وَطَنِيمٛ اَلْکَوَلْ حٛکُّکِمٛندِ، ندِ وَرْتَ ندِ مَاکٛ، کَنْکٛ اٜ ٻِٻّٜ مَاکٛ، کٛو ندٜ اٛ وَلَا ٻِطّٛ اٜ شَرٜلْ نغٜلْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","طُعُمْ وٛنِ کٛ اَللَّه وِعِمٛ، ‏‹‏ٻِٻّٜ ٻِٻّٜىٰجِ مَاطَ نجَحَيْ لٜيْدِ وٛٻّٜ؞ يِمْٻٜ لٜيْدِ ندِنْ نغَرْتِرَٻٜ مَشُّٻٜ، ٻٜ تٛرَّٻٜ دُوٻِ 400؞ ");
INSERT INTO fuv_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","اَمَّا مِ تٛرَّيْ ٻٜنْ طٛنْ يِمْٻٜ غَرْتِرْٻٜ ٻِٻّٜ ٻِٻّٜىٰجِ مَاطَ مَشُّٻٜ؞ غَطَ مَاجُمْ ٻٜ مبُرْتٛتٛ لٜيْدِ ندِنْ ٻٜ مَوْنِنَيَمْ ندٜرْ لٜيْدِ ندِعِ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","ندٜنْ اَللَّه وَطَنِ اِبْرَاهِمْ اَلْکَوَلْ؞ نَادُکِ وٛنِ کٛ حٛلَّتَ اٛ جَٻِي اَلْکَوَلْ نغَلْ؞ ندٜ اِبْرَاهِمْ دَݧِ اِشِيَاکُ، غَطَ بَلْطٜ جٛوٜىٰتَتِ اٛ نَادِمٛ؞ نٛنْ اِشِيَاکُ مَا نَادِ يَاکُبُ؞ يَاکُبُ مَا نَادِ ٻِٻّٜ مُوطُمْ سَڤّٛ اٜ طِطٛ، کَمْٻٜ نغٛنِ مَامَعٜنْ مٜىٰطٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","‏«‏مَامَعٜنْ مٜىٰطٜنْ نَنِ لَوْلِيرُ اِسُفُ، ٻٜ شٛورِمٛ اٛ وَرْتِ مَشُّطٛ ندٜرْ لٜيْدِ مَسَرْ؞ اَمَّا اَللَّه اٜ وٛنْدِ اٜ مَاکٛ، ");
INSERT INTO fuv_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","حِسْنِمٛ دَغَ تٛرَّاجِ فُو، حٛکِّمٛ فَامُ حَا فِرعَوْنَ لَامِيطٛ مَسَرْ اَنْدِ کَ مَاکٛ؞ فِرعَوْنَ وَرْتِرِمٛ مَوْطٛ ندٜرْ لٜيْدِ مَسَرْ حَا دٛوْ وُرٛ مُوطُمْ فُو؞ ");
INSERT INTO fuv_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","سٜيْ وٜىٰلٛ کَلُّنغٛ وَطِ ندٜرْ لٜيْدِ مَسَرْ اٜ لٜيْدِ کَنْعَانَ فُو؞ نغٛ تٛرِّ يِمْٻٜ حَا مَامَعٜنْ مٜىٰطٜنْ ندُلِّ کٛ ݧَامَتَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","ندٜ يَاکُبُ نَنِ اٜ وٛودِ ݧَمْندُ ندٜرْ لٜيْدِ مَسَرْ، اٛ لِلِ مَامَعٜنْ مٜىٰطٜنْ تٛنْ؞ اَرَنْدٜ ٻٜ نجَحِ ٻٜ نغَرْتِ، سٜيْ ٻٜ شٛعِّي کَدِنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","اٜ يَادُ مَٻّٜ طِطَوْرُ، اِسُفُ حٛلِّٻٜ اٛ سَکِرَاوٛ مَٻّٜ؞ فِرعَوْنَ بٛو اَنْدِ بَنْدِرَاٻٜ اِسُفُ؞ ");
INSERT INTO fuv_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","ندٜنْ اِسُفُ لِلِٻٜ ٻٜ نغَدّٛيَ ݧَاکٛ مَاکٛ يَاکُبُ اٜ وُرٛ مُوطُمْ فُو؞ طُطْکِ مَٻّٜ وَطِي يِمْٻٜ 75؞ ");
INSERT INTO fuv_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","سٜيْ يَاکُبُ يَحِ لٜيْدِ مَسَرْ؞ اٛ مَايِ تٛنْ، کَنْکٛ اٜ مَامَعٜنْ مٜىٰطٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","ٻٜ نجَارَا شٜىٰکٜمْ، ٻٜ اُوَا تٛنْ ندٜرْ يٜنَاندٜ ندٜ اِبْرَاهِمْ سٛودُنٛو تٛ ٻِٻّٜ حَمٛرْ اٜ اَجُرْفَارِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","‏«‏ندٜ اَلْکَوَلْ نغَلْ اَللَّه وَطَنِ اِبْرَاهِمْ ٻَدِي حٜىٰوُکِ، يِمْٻٜ اِبْرَانِيَنْکٛعٜنْ طُوطِ ندٜرْ لٜيْدِ مَسَرْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","اٜ شَرٜلْ نغٜلْ غٛطّٛ وَرْتِ لَامِيطٛ لٜيْدِ مَسَرْ مٛ اَنْدَا اِسُفُ؞ ");
INSERT INTO fuv_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","لَامِيطٛ اٛنْ حَلَّنِ لٜݧٛلْ مٜىٰطٜنْ، اٛ تٛرِّ مَامَعٜنْ مٜىٰطٜنْ اٛ دٛولِٻٜ ٻٜ کُبِنَ ٻِکّٛيْ مَٻّٜ نغَمْ کٛيْ مَايَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","ندٜرْ شَرٜلْ نغٜلْ مُوسَ دَݧَا، اٛ ٻِنْغٜلْ بٛنْغٜلْ نَاع سٜطَّ؞ نغٜلْ رٜىٰنَا ندٜرْ وُرٛ ݧَاکٛ مَاغٜلْ لٜبِّ تَتِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","ندٜ نغٜلْ حُبِنَا، ٻِي فِرعَوْنَ دٜبّٛ حٛشِّنغٜلْ، وَرْتِرِنغٜلْ ٻِنْغٜلْ مُوطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","سٜيْ طُمْ جَنْغِنِ مُوسَ اٛنْ اَنْدَلْ مَسَرَنْکٛعٜنْ فُو، اٛ وَرْتِ بَوْطٛ حَالَ اٜ کُوطٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","‏«‏ندٜ مُوسَ وَطِ دُوٻِ 40، اٛ يَحِ تٛ لٜݧٛلْ مَاکٛ، ٻِٻّٜ اِسْرَاعِيلَ نغَمْ اٛ يِعَ نٛ ٻٜ نغٛنْتِندِرِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","ندٜ اٛ يِعِ غٛطّٛ مَسَرَنْکٜىٰجٛ اٜ تٛرَّ غٛطّٛ اِسْرَاعِيلَنْکٜىٰجٛ، اٛ وَلِّ اِسْرَاعِيلَنْکٜىٰجٛ تٛرّٜتٜىٰطٛ اٛنْ، اٛ فِيِ مَسَرَنْکٜىٰجٛ اٛنْ، اٛ وَرِمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","اٛ ݧُمِ بَنْدِرَاٻٜ مَاکٛ اَندِتَيْ اَللَّه حُوتِرَيْمٛ نغَمْ حِسْنَٻٜ دَغَ جُنْغٛ مَسَرَنْکٛعٜنْ، اَمَّا ٻٜ اَنْدِتَايِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","ندٜ فِنِ اٛ تَوِ اِسْرَاعِيلَنْکٛعٜنْ طِطٛ اٜ کَٻَ؞ اٛ يِطِي اٛ سِرْيٛوتِرَٻٜ، اٛ وِعِٻٜ، ‏‹‏حِغٛوٻٜ اَمْ، اٛنٛنْ اٛنْ بَنْدِرَاٻٜ!‏ نغَمْ طُمٜ کَلَّنْتٛنْ کٛعٜ مٛوطٛنْ؟›‏ ");
INSERT INTO fuv_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","اَمَّا تٛرَّيْطٛ غٛعٛتٛ اٛنْ تُرْتِي مُوسَ وُتُّدُ، وِعِمٛ، ‏‹‏مٛيٜ وَرْتِرْمَا اَرْدِيطٛ اٜ کِيتٛتٛوطٛ دٛوْ اَمِنْ؟ ");
INSERT INTO fuv_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","مِنْ مَا، اَ يِطِ مبَرَايَمْ نٛ مبَرْدُطَا مَسَرَنْکٜىٰجٛ کٜىٰݧَ؟›‏ ");
INSERT INTO fuv_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","ندٜ مُوسَ نَنِ نٛنْ دٛغِّ يَحِ لٜيْدِ مِدِيَنْ؞ تٛنْ اٛ دَݧَنَا ٻِٻّٜ وٛرْٻٜ طِطٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","‏«‏غَطَ اٛ وَطِي دُوٻِ 40 تٛنْ، مَلَاعِکَاجٛ وَنْغَنِمٛ ندٜرْ طٜمْنغَلْ حِيتٜ دٛوْ لٜغّٜلْ ندٜرْ لَدّٜ، حَادٜ حٛشّٜىٰرٜ سِنَيْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","ندٜ مُوسَ يِعِ نٛنْ طُمْ حَيْطِنِيمٛ، اٜ مٛ ٻَتّٛو نغَمْ اٛ رَارَ، سٜيْ اٛ نَنِ حٛنٛنْدٜ جٛومِرَاوٛ وِعِي، ");
INSERT INTO fuv_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‏‹‏مِنْ وٛنِ اَللَّه مَامَعٜنْ مَاطَ، اَللَّه اِبْرَاهِمْ اٜ اِشِيَاکُ اٜ يَاکُبُ؞›‏ مُوسَ دَرِي اٜ دِوْنَ، حُلِ رَارُکِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","جٛومِرَاوٛ وِعِمٛ، ‏‹‏اِتُّ ڤَطٜ مَاطَ، نغَمْ وِغٜىٰرٜ تٛ ندَرِطَا ندٜ شٜنِيندٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","مِ يِعِي تٛرَّ يِمْٻٜ اَمْ وٛنْٻٜ لٜيْدِ مَسَرْ، مِ نَنِي بٛجِّ مَٻّٜ؞ جٛونِ مِ جِڤّٛيَکٜ نغَمْ حِسْنُکِٻٜ؞ وَرْ مِ لِلْمَا لٜيْدِ مَسَرْ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","‏«‏مُوسَ مٛ ٻِٻّٜ اِسْرَاعِيلَ نغَݧُنٛو مبِعِ، ‏‹‏مٛيٜ وَرْتِرْمَا اَرْدِيطٛ اٜ کِيتٛتٛوطٛ دٛوْ اَمِنْ؟›‏ کَنْکٛ وٛنِ مٛ اَللَّه لِلٛيِ، وَرْتِرِمٛ اَرْدِيطٛ اٜ جٛوفَيْطٛٻٜ دَغَ مَشُّنغَاکُ اٜ بَلَّلْ مَلَاعِکَاجٛ وَنْغَنّٛوطٛمٛ ندٜرْ لٜغّٜلْ نغٜلْ حِيتٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","کَنْکٛ اَرْدِيٻٜ، ٻٜ مبُرْتِي لٜيْدِ مَسَرْ؞ اٛ وَطِي کُوطٜ کَيْطِنِيطٜ اٜ اَلَامَاجِ ندٜرْ لٜيْدِ مَسَرْ اٜ ندٜرْ مَايٛ وٛطٜوٛ اٜ ندٜرْ لَدّٜ جٛرْندٜ دُوٻِ 40؞ ");
INSERT INTO fuv_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","مُوسَ اٛنْ کَنْکٛ وٛنِ بِيطٛ ٻِٻّٜ اِسْرَاعِيلَ، ‏‹‏اَللَّه لِلْدٛيَيْعٛنْ اَنَّبِيجٛ بٛ اَمْ، دَغَ ندٜرْ بَنْدِرَاٻٜ مٛوطٛنْ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","مُوسَ اٛنْ اٜ مٛ ندٜرْ کَوْتَلْ مَامَعٜنْ مٜىٰطٜنْ ندٜرْ لَدّٜ، اٜ مٛ وٛنْدِ اٜ مَلَاعِکَاجٛ مٜتَنْطٛمٛ دٛوْ حٛشّٜىٰرٜ سِنَيْ؞ کَنْکٛ اَللَّه حٛکِّ حَبَرُ وٛلْدٜ کٛکَّيْندٜ يٛنْکِ نغَمْ اٛ وَدَّنَعٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","‏«‏اَمَّا مَامَعٜنْ مٜىٰطٜنْ نجَٻَايِ تٛکُّکِ کٛ اٛ وِعِ؞ ٻٜ شَلَنِيمٛ، ٻٜرْطٜ مَٻّٜ شٛعِّي مَسَرْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","ٻٜ مبِعِ هَرُونَ، ‏‹‏وَطَنْعٜنْ اَلَّاجِ اَرْدٛتٛوطِعٜنْ، نغَمْ اٜنْ اَنْدَا کٛ حٜٻِ مُوسَ بُرْتِنٛيْطٛعٜنْ لٜيْدِ مَسَرْ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","ندٜرْ بَلْطٜ طٜنْ ٻٜ نغَطِ غَغٜلْ جِينَارِ، ٻٜ نغَرْتِرِنغٜلْ اَلَّح مَٻّٜ، ٻٜ کِرْسَنِنغٜلْ شَکِّرِ، ٻٜ نغَطِ حُمْتٛ نغَمْ مَوْنِنْکِ کٛ ٻٜ نغَطِ اٜ جُوطٜ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","نغَمْ نٛنْ اَللَّه وَيْلِتَنِٻٜ ٻَاوٛ، اَلِٻٜ ٻٜ مَوْنِنَ کٛودٜ، نٛنْ نٛ طُمْ وِنْدِرَا ندٜرْ دٜفْتٜرٜ اَنَّبٛعٜنْ وِعُکِ:‏ ‏‹‏اٛنٛنْ يِمْٻٜ اِسْرَاعِيلَ، دُوٻِ 40 طِ نغَطّٛنْ ندٜرْ لَدّٜ، مِنْ کِرْسَنْطٛنْ مَرْلٜ شَکَّنْطٛنْ؟ ");
INSERT INTO fuv_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","اَاعَ، نَاع طُمْ مِنْ؞ اٛنْ ندٛوندَکٜ لُکُرُ اَلَّح مٛوطٛنْ مٛلٜکْ، کَنْغَ اٜ اَلَّح حٛودٜرٜ مٛوطٛنْ بِعٜتٜىٰندٜ رِفَنْ، اَلَّاجِ طِ نغَطّٛنْ نغَمْ مَوْنِنْکِ!‏ نغَمْ مَاجُمْ مِ رِيوَيْعٛنْ، مِ يَارَعٛنْ تٛنْ لٜيْدِ بَابِيلَ؞›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","اِسْتِفَانُسْ ٻٜيْدِ مٜتُکِ، وِعِ، ‏«‏ندٜنّٛ مَامَعٜنْ مٜىٰطٜنْ اٜ نغٛودِ لُکُرُ تٛ طُمْ حَوْرَتَ اٜ اَللَّه ندٜرْ لَدّٜ؞ کَيْرُ حٛلَّتَ اَللَّه اٜ وٛنْدِ اٜ مَٻّٜ؞ لُکُرُ طُمْ وَطِرَامَ نٛنْ نٛ اَللَّه تِندِنِرِ مُوسَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","مَامَعٜنْ مٜىٰطٜنْ ٻٜنْ ندٛنِ لُکُرُ طُمْ؞ ٻٜ ندِلِّدِ اٜ مَاجُمْ شَرٜلْ کٛ جٛوشُوَ اَرْدِيٻٜ؞ ٻٜ نَتِّنِطُمْ لٜيْدِ ندِ ٻٜ نجَٻِ دَغَ تٛ لٜپِّ طِ اَللَّه رِيوِ يٜىٰسٛ مَٻّٜ؞ لُکُرُ طُمْ بٛو اٜ طٛنْ حَا جَامَنُ دَوْدَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","دَوْدَ حٜٻِ يِدّٜ اَللَّه مٛ يَاکُبُ، اٛ تٛرِي مَحُکِ سُودُ نغَمْ مَوْنِنْکِ اَللَّه اٛنْ، اَمَّا اٛ حٜٻَايِ مَحُکِندُ؞ ");
INSERT INTO fuv_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","اَمَّا ٻِطّٛ مَاکٛ سُلٜيْمَانُ مَحِندُ؞ ");
INSERT INTO fuv_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","‏«‏اَللَّه جٛومُ مَنْغُ جٛوطَتَاکٛ ندٜرْ شُوطِ طِ يِمْٻٜ مَحِ، نٛنْ نٛ اَنَّبِيجٛ وِعِ جٛومِرَاوٛ وِعِي، ");
INSERT INTO fuv_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‏‹‏دٛوْ وٛنِ جٛوطٛرْغَلْ لَامُ اَمْ، لٜيْدِ وٛنِ تٛ نجٛوَيْمِ کٛيْطٜ اَمْ؞ اِرِ ندُيٜ سُودُ مَحَنْتٛنْيَمْ؟ ندٜيٜ وِغٜىٰرٜ شِوْتٛتٛومِ؟ ");
INSERT INTO fuv_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","نَاع اٜ بَوْطٜ اَمْ تَغِرْمِ طُمْ طٛنْ فُو؟›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","اِسْتِفَانُسْ ٻٜيْدِ مٜتُکِ، وِعِ، ‏«‏اٛنٛنْ ٻٜ کٛعٜ شَاتُطٜ ٻٜ ٻٜرْطٜ کٜىٰفٜرْطٜ، ٻٜ نٛڤِّ غَݧُطِ نَنُکِ حَالَ جٛومِرَاوٛ!‏ کٛو ندٜيٜ اٛنْ کَٻْدَ اٜ رُوحُ اَللَّه نٛنْ نٛ مَامَعٜنْ مٛوطٛنْ نغَطُنٛو؞ ");
INSERT INTO fuv_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","مٛيٜ اَنَّبِيجٛ وٛنِ مٛ مَامَعٜنْ مٛوطٛنْ تٛرَّايِ؟ حَا مَا ٻٜ مبَرِي وِعُنٛوٻٜ اَادِلِيجٛ اٛنْ وَرَيْ؞ جٛونِ اٛنٛنْ اٜ کٛعٜ مٛوطٛنْ اٛنْ ݧَامِي اَمَانَ مَاکٛ، اٛنْ مبَرِيمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","اٛنٛنْ اٛنْ کٜٻِي اَتَّوْرَ دَغَ جُوطٜ مَلَاعِکَعٜنْ دَغَ ندٜنّٛ، اَمَّا اٛنْ تٛکَّايِطُمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","ندٜ کَوْتَلْ مَوْٻٜ يَحُودَنْکٛعٜنْ نَنِ حَالَ کَنْ، ٻٜرْطٜ مَٻّٜ مٜتِّ ٻٜ ندَرِي اٜ ٻٜ ݝَتّٛو؞ ");
INSERT INTO fuv_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","اَمَّا کَنْکٛ، اٜ مٛ حٜىٰوِ رُوحُ اَللَّه، اٛ تِجِّي دٛوْ اٛ يِعِ تٜدُّنغَلْ اَللَّه، اٛ يِعِ يٜىٰسُ اٜ دَرِي اٜ جُنْغٛ اَللَّه ݧَامٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","اٛ وِعِ، ‏«‏رَا!‏ اٜ مِ يِعَ دٛوْ اٜ مَٻِّتِي، ٻِي نٜطّٛ اٜ دَرِي اٜ جُنْغٛ اَللَّه ݧَامٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","سٜيْ ٻٜ فُو ٻٜ نغُلِّ سٜمْبٜىٰ، ٻٜ شُکِّ نٛڤِّ مَٻّٜ؞ طٛنْ اٜ طٛنْ، ٻٜ مَکِّيمٛ، ٻٜ نَنْغِمٛ، ");
INSERT INTO fuv_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ٻٜ مبُرْتِنِمٛ غَرِيرِ، ٻٜ کُبٛرِيمٛ اٜ کَاپٜ، ٻٜ ٻٛرْتِي کٛلْتٜ مَٻّٜ ٻٜ ندٜسِطٜ تٛ غٛطّٛ کَيٜىٰجٛ بِعٜتٜىٰطٛ شَاوُلُ نغَمْ ٻٜ کُبٛومٛ بٛطُّمْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","اٜ ٻٜ کُبٛرٛومٛ کَاپٜ، کَنْکٛ بٛو اٜ مٛ وَطَ دٛعَارٜ اٜ مٛ وِعَ، ‏«‏يَا يٜىٰسُ جٛومِرَاوٛ، جَٻُ يٛنْکِ اَمْ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","ندٜنْ اٛ دِشِّي، اٛ وُلِّ اٜ سٜمْبٜ اٜ مٛ وِعَ، ‏«‏يَا جٛومِرَاوٛ، تَاع يٛوَنْٻٜ طُعُمْ حَکّٜ!‏»‏ ندٜ اٛ وِعِ نٛنْ، اٛ مَايِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","شَاوُلُ بٛو جَٻِي طُمْ وَرِ اِسْتِفَانُسْ؞ دَغَ ݧَلْندٜ ندٜنْ، تٛرَّ مَوْکَ وَرَنِ کَوْتَلْ تٛکُّٻٜ يٜىٰسُ وٛنْٻٜ اُرُشَلِيمَ؞ ٻٜ فُو ٻٜ شَنْکِتِي ندٜرْ لٜيْطٜ يَحُودِيَ اٜ سَمَارِيَ، سٜيْ لِلَاٻٜ تَنْ کٛرِي ندٜرْ اُرُشَلِيمَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","وٛٻّٜ کُلٛوٻٜ اَللَّه اُوِ اِسْتِفَانُسْ، ٻٜ مبٛيَنِ مَيْدٜ مَاکٛ بٛجِّ نَوْطِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","اَمَّا شَاوُلُ اُمَّنِي کَوْتَلْ تٛکُّٻٜ يٜىٰسُ، وَطِ کَ سَنْکُتُکِٻٜ؞ اٜ مٛ نَتَّ وُرٛ‑وُرٛ، اٜ مٛ نَنْغَ تٛکُّٻٜ يٜىٰسُ وٛرْٻٜ اٜ رٜوْٻٜ، اٜ مٛ دَسَٻٜ، اٜ مٛ مَٻَّٻٜ ندٜرْ سُودُ شُرَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","ندٜنْ شَنْکِتَاٻٜ نغَطِ کَ يِيلَاکِ اٜ نغَعَجِنَ حَبَرُ بٜلْطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","فِلِبُسْ بٛو يَحِ وٛنْدِ غَرِيرِ ندٜرْ لٜيْدِ سَمَارِيَ، اٜ مٛ وَعَجِنَنَٻٜ حَبَرُ اَلْمَسِيحُ؞ ");
INSERT INTO fuv_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","ندٜ يِمْٻٜ فُو نَنِ، نغِعِ اَلَامَاجِ کَيْطِنِيطِ طِ فِلِبُسْ وَطِ، ٻٜ شٛعِّ حَکِّيلٛ مَٻّٜ دٛوْ کٛ اٛ وِعِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","نغَمْ يِمْٻٜ طُطْٻٜ مبُرْتِنَنَامَ غِنِّ اٜ طِ نغُلَّ سٜمْبٜىٰ، ندٜنْ جَرَاٻٜ اٜ لَپٛوٻٜ طُطْٻٜ نجَمْطِتِنَا؞ ");
INSERT INTO fuv_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","نغَمْ نٛنْ طُمْ نَنِ وٜلْوٜلٛ طُطْنغٛ ندٜرْ غَرِيرِ ندِنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","ندٜرْ غَرِيرِ ندِنْ بٛو اٜ وٛودِ غٛطّٛ نٜطّٛ بِعٜتٜىٰطٛ سِيمَنْ، اٛ دَرْنٛووٛ؞ اٜ مٛ حَيْطِنَ سَمَارِيَنْکٛعٜنْ نَاع سٜطَّ اٜ کُوطٜ مَاکٛ، اٜ مٛ وِعَ حٛورٜ مَاکٛ اٛ مَوْطٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","يِمْٻٜ فُو دَغَ مَوْٻٜ حَا سُکَاٻٜ نجَٻِي کٛ اٛ وِعَتَ، اٜ ٻٜ مبِعَ، ‏«‏نٜطّٛ اٛعٛ اٜ وٛودِ بَوْطٜ اَللَّه بِعٜتٜىٰطٜ بَوْطٜ مَوْطٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","ٻٜ تٛکُّمٛ نغَمْ اٛ نٜىٰٻِي اٜ مٛ حَيْطِنَٻٜ اٜ سِحِرِيجِ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","اَمَّا ندٜ ٻٜ نجَٻِ حَبَرُ بٜلْطُمْ طُمْ فِلِبُسْ وَعَجِنَنْتَٻٜ دٛوْ لَامُ اَللَّه اٜ اِنْدٜ يٜىٰسُ اَلْمَسِيحُ، وٛرْٻٜ اٜ رٜوْٻٜ فُو نغَطَنَا بَڤْتِسْمَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","حَا سِيمَنْ مَا اٜ حٛورٜ مُوطُمْ تٛکِّ يٜىٰسُ؞ غَطَ اٛ وَطَنَامَ بَڤْتِسْمَ، اٛ تٛکِّ فِلِبُسْ حَادٜ، اٛ حَيْطِنِي ندٜ اٛ يِعِ اَلَامَاجِ اٜ کُوطٜ کَيْطِنِيطٜ مَوْطٜ طٜ فِلِبُسْ وَطِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","ندٜ لِلَاٻٜ وٛنْٻٜ اُرُشَلِيمَ نَنِ سَمَارِيَنْکٛعٜنْ نجَٻِي وٛلْدٜ اَللَّه، سٜيْ ٻٜ لِلِ بِيتُرُسْ اٜ يَحَيَ تٛ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","ندٜ ٻٜ نجٛتِّي، ٻٜ تٛرِي اَللَّه حٛکَّ سَمَارِيَنْکٛعٜنْ ٻٜنْ رُوحُ مُوطُمْ، ");
INSERT INTO fuv_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","نغَمْ ٻٜ نغَطَنَامَ بَڤْتِسْمَ ندٜرْ اِنْدٜ يٜىٰسُ جٛومِرَاوٛ تَنْ، اَمَّا رُوحُ اَللَّه جِڤّٛيَاکِ دٛوْ کٛو مٛيٜ مَٻّٜ تَوْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","سٜيْ بِيتُرُسْ اٜ يَحَيَ نجٛوِ جُوطٜ مُعّٜنْ دٛوْ مَٻّٜ، ٻٜ کٜٻِ رُوحُ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","ندٜ سِيمَنْ يِعِ يٛوُکِ جُوطٜ لِلَاٻٜ دٛوْ تٛکُّٻٜ يٜىٰسُ اٜ حٛکَّ رُوحُ اَللَّه، اٛ وَدَّنِٻٜ شٜىٰدٜ، ");
INSERT INTO fuv_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","اٛ وِعِ، ‏«‏کٛکّٜىٰيَمْ، مِنْ مَا بَوْطٜ طٜنْ، نغَمْ مٛ نجٛوَنْمِ جُوطٜ فُو حٜٻَ رُوحُ اَللَّه؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","اَمَّا بِيتُرُسْ وِعِمٛ، ‏«‏اَنْ اٜ شٜىٰدٜ مَاطَ کَلْکِدٜىٰ، نغَمْ اَ ݧُمِي اَ وَاوَيْ سٛودُکِ دٛکَّلْ اَللَّه اٜ شٜىٰدٜ!‏ ");
INSERT INTO fuv_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","اَ وَلَا غٜطَلْ ندٜرْ کُوغَلْ نغَعَلْ، نغَمْ ٻٜرْندٜ مَاطَ لَاٻَايِ يٜىٰسٛ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","تُوبُ دَغَ حَلّٜىٰندٜ مَاطَ، تٛرَ جٛومِرَاوٛ يَافَنٛمَا ݧُمٛوجِ مَاطَ کَلُّطِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","نغَمْ مِ يِعِي اَ وٛودِ ٻٜرْندٜ ٻَلٜىٰرٜ، حَلّٜىٰندٜ طُوطَنِيمَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","سِيمَنْ وِعِمٛ، ‏«‏تٛرَنٜىٰيَمْ جٛومِرَاوٛ، نغَمْ تٛع کٛ مبِيطَا حٜٻَيَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","غَطَ بِيتُرُسْ اٜ يَحَيَ تَبِّتِنَنِي سَمَارِيَنْکٛعٜنْ دٛوْ يٜىٰسُ، ٻٜ نغَعَجِنَنِٻٜ وٛلْدٜ جٛومِرَاوٛ؞ ندٜ اٜ ٻٜ دٛوْ لَاوٛلْ حٛوتُکِ اُرُشَلِيمَ، ٻٜ نغَعَجِنِ حَبَرُ بٜلْطُمْ ندٜرْ نغَرِحٛيْ سَمَارِيَ طُطْکٛيْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","سٜيْ غٛطّٛ مَلَاعِکَاجٛ جٛومِرَاوٛ وِعِ فِلِبُسْ، ‏«‏اُمَّ دِلِّرْ فٛمْبِنَ تٛکَّا طَتَلْ پِوٛيْنغَلْ اُرُشَلِيمَ يَاکِ غَاجَ، طَتَلْ لَدّٜوَلْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","سٜيْ فِلِبُسْ اُمِّي دِلِّ؞ اٜ مٛ دٛوْ لَاوٛلْ اٛ حَوْرِ اٜ غٛطّٛ نٜطّٛ لٜيْدِ اِتِيٛوفِيَ تَڤَّاطٛ؞ نٜطّٛ اٛنْ اٜ وٛودِ لَامُ مَوْطُمْ ندٜرْ لَامٛرْدٜ لَامِيطٛ دٜبّٛ بِعٜتٜىٰطٛ کَندِسْ؞ کَنْکٛ وٛنِ دٜسٛووٛ شٜىٰدٜ لَامِيطٛ اٛنْ؞ اٛ يَحُنٛ اُرُشَلِيمَ نغَمْ مَوْنِنْکِ جٛومِرَاوٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","اٜ مٛ حٛوتَ، اٜ مٛ جٛوطِي ندٜرْ کٜىٰکٜ ڤُشِّ، اٜ مٛ جَنْغَ دٜفْتٜرٜ اَنَّبِ اِشَايَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","رُوحُ اَللَّه وِعِ فِلِبُسْ، ‏«‏يَحُ، ٻَدّٛطَا کٜىٰکٜ ڤُشِّ طُمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","سٜيْ فِلِبُسْ دٛغِّ يَحِ تٛ مَاکٛ، نَنِ اٜ مٛ جَنْغَ دٜفْتٜرٜ اَنَّبِ اِشَايَ؞ فِلِبُسْ پَمِمٛ، وِعِ، ‏«‏اَ فَامَ کٛ نجَنْغَتَا بٛو؟»‏ ");
INSERT INTO fuv_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","نٜطّٛ اٛنْ وِعِمٛ، ‏«‏نٛيٜ ڤَامِرَيْمِ ندٜ وَلَا ڤَمْتِنَيْطٛيَمْ؟»‏ اٛ تٛرِي فِلِبُسْ نَتَّ جٛوطٛدٛو اٜ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","رَا اَايَاجٜ طٜ اٛ جَنْغَتَ ندٜرْ دٜفْتٜرٜ ندٜنْ:‏ ‏«‏اٛ فٛوطَامَ بٛ مبَالَ کِرْسٛيْتٜىٰنغَ؞ نٛ ٻِي مبَالَ دٜعِّتِرْتَ تٛ جُنْغٛ تَپٛووٛ لٜىٰٻٜ مَاغَ، نٛنْ اٛ دٜعِّتِرِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","ٻٜ شٜمْتِنِمٛ، ٻٜ نغَطَنَايِمٛ کِيتَ غٛونغَ؞ مٛيٜ وَاوَتَ حٛکُّکِ حَبَرُ ٻِٻّٜ مَاکٛ؟ نغَمْ يٛنْکِ مَاکٛ اِتَّامَ دَغَ ندٜرْ دُونِيَارُ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","اِتِيٛوفِيَنْکٜىٰجٛ اٛنْ وِعِ فِلِبُسْ، ‏«‏وِعَمْ دٛوْ مٛيٜ اَنَّبِيجٛ اٛعٛ مٜتِ حَالَ کَعَ، دٛوْ حٛورٜ مَاکٛ کٛو دٛوْ غٛطّٛ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","سٜيْ فِلِبُسْ فُطِّ مٜتَنْکِمٛ دٛوْ اَايَاجٜ طٜنْ، اٜ وَعَجِنَنَمٛ حَبَرُ بٜلْطُمْ دٛوْ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","اٜ ٻٜ ندٜرْ يَادُ ٻٜ نجٛتِّي تٛ ندِيَمْ وٛنِ؞ سٜيْ نٜطّٛ اٛنْ وِعِ، ‏«‏رَا ندِيَمْ!‏ کٛ حَطَتَ طُمْ وَطَنَيَمْ بَڤْتِسْمَ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","‏‏فِلِبُسْ وِعِمٛ، ‏«‏تَا حٛولَکٜ يٜىٰسُ اٜ ٻٜرْندٜ غٛعٛ، وَلَا کٛ حَطَتَ طُمْ وَطَنْمَا بَڤْتِسْمَ؞»‏ سٜيْ نٜطّٛ اٛنْ وِعِ، ‏«‏مِ جَٻِي يٜىٰسُ اَلْمَسِيحُ اٛ ٻِي اَللَّه؞»‏‏ ");
INSERT INTO fuv_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","اٛ وِعِ طُمْ دَرْنَ کٜىٰکٜ ڤُشِّ طُمْ؞ ٻٜ فُو طِطٛ ٻٜ نجِڤِّي، ٻٜ نَتِّ ندٜرْ ندِيَمْ طَمْ؞ فِلِبُسْ وَطَنِمٛ بَڤْتِسْمَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","ندٜ ٻٜ مبُرْتِي ندِيَمْ طَمْ، سٜيْ رُوحُ جٛومِرَاوٛ حٛشِّ فِلِبُسْ؞ نٜطّٛ اٛنْ فُطِّتَايِ يِعُکِمٛ، اٛ ݧَمْرِ يٜىٰسٛ اٜ يَادُ، اٜ مٛ نَنَ بٜلْطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","اَمَّا فِلِبُسْ يِعِ حٛورٜ مُوطُمْ اٜ غَرِيرِ اَجٛتُسْ؞ دٛوْ لَاوٛلْ اٛ وَطِ کَ وَعَجِنْکِ حَبَرُ بٜلْطُمْ اٜ کٛو ندِيٜ غَرِيرِ حَا اٛ يٛتِّي کَيْسَارِيَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","ندٜرْ شَرٜلْ نغٜلْ بٛو، شَاوُلُ اٜ ٻٜيْدَ تٛرُّکِ تٛکُّٻٜ يٜىٰسُ، اٜ مٛ يِطِ وَرْکِٻٜ؞ سٜيْ اٛ يَحِ تٛ مَوْطٛ مَوْٻٜ اَرْدِيٻٜ دِينَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","اٛ تٛرِيمٛ اٛ وِنْدَنَمٛ طٜرٜوٛلْ نغٛلْ اٛ حٛلَّتَ مَوْٻٜ شُوطِ دٛعَارٜ غٛنْطِ غَرِيرِ دِمَسْکُ، وِيکِ تٛ اٛ تَوِي تٛکُّٻٜ لَاوٛلْ يٜىٰسُ تٛنْ، وٛرْٻٜ کٛو رٜوْٻٜ، اٛ نَنْغَٻٜ، اٛ حَٻَّٻٜ، اٛ يَارَٻٜ غَرِيرِ اُرُشَلِيمَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","اٜ مٛ دٛوْ لَاوٛلْ اٛ ٻَدَکٜ يٛتَّاکِ غَرِيرِ دِمَسْکُ، اٛ اَنْدَا اٛ اَنْدِتَا سٜيْ رَا جَيْنغٛلْ دَغَ دٛوْ يٜيْنَنِيمٛ فِلِيمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","اٛ يَنِ اٜ لٜيْدِ، اٛ نَنِ حٛنٛنْدٜ اٜ وِعَمٛ، ‏«‏شَاوُلُ، شَاوُلُ، نغَمْ طُمٜ تٛرَّتَايَمْ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","شَاوُلُ وِعِ، ‏«‏مَوْطٛ، اَنْ طُمْ مٛيٜ؟»‏ حٛنٛنْدٜ ندٜنْ وِعِمٛ، ‏«‏مِنْ وٛنِ يٜىٰسُ مٛ تٛرَّتَا؞ ");
INSERT INTO fuv_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","اُمَّ نَتُّ ندٜرْ غَرِيرِ؞ طُمْ وِعٜتٜ کٛ حَانِ نغَطَا؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","حِغٛوٻٜ يَادُ مَاکٛ نَنِي حٛنٛنْدٜ ندٜنْ، اَمَّا ٻٜ نغِعَايِ کٛو مٛيٜ؞ ٻٜ ندَرِي، ٻٜ ندُلِّ کٛ ٻٜ مبِعَتَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","شَاوُلُ اُمِّي دَرِي فٜىٰرِ غِتٜ مُوطُمْ، اَمَّا يِعَتَا؞ ندٜنْ اٛ جٛغَنَا جُنْغٛ، اٛ نَتِّنَا غَرِيرِ دِمَسْکُ؞ ");
INSERT INTO fuv_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","اٛ وَطِ بَلْطٜ تَتِ اٜ مٛ وُمِ، اٛ يَرَايِ اٛ ݧَامَايِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","اٜ وٛودِ غٛطّٛ تٛکُّطٛ يٜىٰسُ ندٜرْ غَرِيرِ ندِنْ بِعٜتٜىٰطٛ حَنَانِيَ؞ جٛومِرَاوٛ نٛدِّمٛ ندٜرْ کٛيْطٛلْ، وِعِمٛ، ‏«‏حَنَانِيَ!‏»‏ اٛ وِعِ، ‏«‏نَعَمْ، جٛومِرَاوٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","جٛومِرَاوٛ وِعِمٛ، ‏«‏اُمَّ تٛکَّا لَاوٛلْ بِعٜتٜىٰنغٛلْ لَاوٛلْ ڤٛرْتِينغٛلْ، نجَحَا وُرٛ يَحُودَ، نغٜيْنَا غٛطّٛ بِعٜتٜىٰطٛ شَاوُلُ پِوٛيْطٛ غَرِيرِ تَرْسُسْ؞ نغَمْ اٜ مٛ طٛنْ وَطَ دٛعَارٜ، ");
INSERT INTO fuv_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","حَا مَا ندٜرْ کٛيْطٛلْ اٛ يِعِي نٜطّٛ بِعٜتٜىٰطٛ حَنَانِيَ نَتّٛيِي، يٛوِي جُوطٜ مُوطُمْ دٛوْ مَاکٛ نغَمْ اٛ وُمْتَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","اَمَّا حَنَانِيَ وِعِمٛ، ‏«‏جٛومِرَاوٛ، مِ نَنِي يِمْٻٜ طُطْٻٜ کٛکِّي حَبَرُ نٜطّٛ اٛنْ، اٜ تٛرَّاجِ طُطِّ طِ اٛ تٛرِّ يِمْٻٜ مَاطَ وٛنْٻٜ اُرُشَلِيمَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","اٛ وَرْدِي اٜ طٜرٜوٛلْ طٛعٛ دَغَ تٛ مَوْٻٜ اَرْدِيٻٜ دِينَ، نغَمْ اٛ نَنْغَ نٛدِّرَاٻٜ اِنْدٜ مَاطَ فُو؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","اَمَّا جٛومِرَاوٛ وِعِمٛ، ‏«‏يَحُ نغَطَا کٛ مبِيمَامِ، نغَمْ مِ سُٻِيمٛ اٛ حُوَنَيَمْ، اٛ اَنْدِنَ اِنْدٜ اَمْ يٜىٰسٛ يِمْٻٜ نَاع يَحُودَنْکٛعٜنْ اٜ لَامِيٻٜ مَٻّٜ، اٜ اِسْرَاعِيلَنْکٛعٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","مِنْ اٜ حٛورٜ اَمْ مِ حٛلَّيْمٛ دٛولٜ اٛ تٛرّٜىٰ تٛرَّاجِ طُطِّ نغَمْ اِنْدٜ اَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","ندٜنْ حَنَانِيَ يَحِ، نَتِّ وُرٛ نغٛ شَاوُلُ وٛنِ، يٛوِ جُوطٜ مُوطُمْ دٛوْ مَاکٛ، وِعِمٛ، ‏«‏بَنْدِرَاوٛ اَمْ شَاوُلُ، يٜىٰسُ جٛومِرَاوٛ وَنْغَنْطٛمَ دٛوْ لَاوٛلْ نغٛلْ نغَرْدُطَا، اٛ لِلٛيِييَمْ نغَمْ مبُمْتَا، کٜٻَا رُوحُ اَللَّه؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","طٛنْ اٜ طٛنْ، غٛطُّمْ بٛ کٛٻٜ مبُرْتِي ندٜرْ غِتٜ شَاوُلُ؞ اٛ وُمْتِ، اٛ اُمِّي، اٛ وَطَنَا بَڤْتِسْمَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","سٜيْ اٛ ݧَامِ ݧَمْندُ، اٛ حٜٻِ سٜمْبٜ؞ دَغَ طٛنْ اٛ وَالِ بَلْطٜ سٜطَّ تٛ تٛکُّٻٜ يٜىٰسُ وٛنْٻٜ غَرِيرِ دِمَسْکُ ندِنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","طٛنْ اٜ طٛنْ شَاوُلُ فُطِّ وَعَجِنْکِ حَبَرُ يٜىٰسُ ندٜرْ شُوطِ دٛعَارٜ؞ اٛ وِعِ غٛونغَ يٜىٰسُ وٛنِ ٻِطّٛ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","طُمْ حَيْطِنِي نَنْٻٜمٛ فُو، ٻٜ مبِعِ، ‏«‏نَاع کَنْکٛ وٛنِ تٛرَّيْنٛوطٛ کٛولِيٻٜ يٜىٰسُ وٛنْٻٜ ندٜرْ غَرِيرِ اُرُشَلِيمَ؟ نَاع اٛ وَرٛيِ طٛعٛ نغَمْ اٛ حَٻَّٻٜ اٛ يَارَٻٜ تٛ مَوْٻٜ اَرْدِيٻٜ دِينَ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","اَمَّا شَاوُلُ ٻٜيْدِ سٜمْبُطُکِ ندٜرْ وَعَجِنْکِ، حَا طُمْ جِيٻِ حَکِّيلٛوجِ يَحُودَنْکٛعٜنْ جٛوطِيٻٜ دِمَسْکُ فُو، نغَمْ ٻٜ کٜٻَايِ کٛ ٻٜ مبِعِمٛ ندٜ اٛ تَبِّتِنَنِٻٜ يٜىٰسُ وٛنِ اَلْمَسِيحُ؞ ");
INSERT INTO fuv_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","سٜيْ غَطَ بَلْطٜ طُطّٜ، يَحُودَنْکٛعٜنْ ندَرْوِ دَبَرٜ نٛ مبَرْدَتَ شَاوُلُ؞ ");
INSERT INTO fuv_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","شَاوُلُ بٛو اَنْدِتِ دَبَرٜ مَٻّٜ؞ جٜمَّ اٜ ݧَلَوْمَ فُو اٜ ٻٜ ندٜىٰنَ دَمُّطٜ غَرِيرِ نغَمْ ٻٜ کٜٻَ نٛ ٻٜ مبَرِرْتَمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","اَمَّا حِغٛوٻٜ مَاکٛ کٛشِّمٛ جٜمَّ، نغَطِمٛ ندٜرْ سٛمْڤٛورٜ، ٻٜ نجِڤِّنِرِمٛ يٛلْندٜ مَادِ ڤِلِيندِ غَرِيرِ ندِنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","ندٜ شَاوُلُ وَرْتِ اُرُشَلِيمَ اٛ يِطِي نَتُّکِ تٛکُّٻٜ يٜىٰسُ، اَمَّا ٻٜ فُو ٻٜ کُلِمٛ، ٻٜ نجَٻَايِ اٛ وَرْتِي تٛکُّطٛ يٜىٰسُ اٜ غٛونغَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","اَمَّا بَرْنَبَ يَارِمٛ تٛ لِلَاٻٜ، طِيوِتِٻٜ نٛ شَاوُلُ يِعِرِ جٛومِرَاوٛ اٜ نٛ جٛومِرَاوٛ مٜتِرَنِمٛ دٛوْ لَاوٛلْ، اٜ نٛ اٛ وَعَجِنِرِ حَبَرُ يٜىٰسُ اٜ غَرِيرِ دِمَسْکُ کُلٛلْ وَلَا؞ ");
INSERT INTO fuv_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","نغَمْ نٛنْ شَاوُلُ جٛوطٛدِي اٜ لِلَاٻٜ، اٜ مٛ يِيلٛدٛو اٜ مَٻّٜ ندٜرْ غَرِيرِ اُرُشَلِيمَ، اٜ مٛ اٜکِّتِنَ حَبَرُ جٛومِرَاوٛ اٜ ٻٜرْندٜ غٛعٛ، کُلٛلْ وَلَا؞ ");
INSERT INTO fuv_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","اٜ مٛ وَعَجِنَنَ يَحُودَنْکٛعٜنْ مٜتٛوٻٜ حٜلٜنَنْکٛورٜ، اٜ مٛ يٜدّٛوتِرَ اٜ مَٻّٜ، اَمَّا کَمْٻٜ اٜ ٻٜ طَٻِّتَ نٛ ٻٜ مبَرْدَتَمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","ندٜ تٛکُّٻٜ يٜىٰسُ نَنِ حَبَرُ طُمْ، ٻٜ نجَارِ شَاوُلُ غَرِيرِ کَيْسَارِيَ؞ ٻٜ نَتِّنِمٛ کٛمِوَلْ ٻٜ شٛعِّمٛ تَرْسُسْ غَرِيرِ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","غَطَ مَاجُمْ کَوْتَلْ تٛکُّٻٜ يٜىٰسُ ندٜرْ لٜيْطٜ يَحُودِيَ اٜ غَلِيلِ اٜ سَمَارِيَ فُو کٜٻِ جٛنْدٜ جَمْ؞ رُوحُ اَللَّه وَلِّٻٜ، ٻٜ شٜمْبِطِ، ٻٜ ٻٜيْدِ کُلٛلْ جٛومِرَاوٛ، ٻٜ طُوطِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","تٛو، ندٜ بِيتُرُسْ يِيلِي ندٜرْ لٜيْدِ ندِنْ فُو، سٜيْ جِڤِّي تٛ تٛکُّٻٜ يٜىٰسُ وٛنْٻٜ غَرِيرِ لِدَّ؞ ");
INSERT INTO fuv_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","طٛنْ اٛ تَوِ غٛطّٛ ݧَوْطٛ بِعٜتٜىٰطٛ اِنِيَسْ مٛ ٻَنْدُ مُوطُمْ فُو وَاتِي؞ اٛ وَطِي دُوٻِ جٛوٜىٰتَتِ اٜ مٛ فُکِّي؞ ");
INSERT INTO fuv_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","بِيتُرُسْ وِعِمٛ، ‏«‏اِنِيَسْ، يٜىٰسُ اَلْمَسِيحُ يَمْطِتِنِيمَ!‏ اُمَّ تَغُّ مبٜعِّتَارِ مَاطَ!‏»‏ طٛنْ اٜ طٛنْ اٛ اُمِّي؞ ");
INSERT INTO fuv_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","ندٜ وٛنْٻٜ غَرِيرِ لِدَّ اٜ وٛنْٻٜ لٜيْدِ شَرٛنْ فُو نغِعِ کٛ وَطِ، ٻٜ تُوبِ ٻٜ تٛکِّ جٛومِرَاوٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","ندٜرْ غَرِيرِ جٛفَّ بٛو اٜ وٛودِ غٛطّٛ دٜبّٛ تٛکُّطٛ يٜىٰسُ بِعٜتٜىٰطٛ تَبِيتَ؞ ﴿مَعَنَ تَبِيتَ ندٜرْ حٜلٜنَنْکٛورٜ وٛنِ دٛوکَسْ، وَاتٛ لٜلْوَ؞﴾اٜ مٛ حُوَ کُوطٜ بٛطّٜ، اٜ مٛ وَلَّ ٻٜ نغَلَنَا؞ ");
INSERT INTO fuv_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","ندٜرْ بَلْطٜ طٜنْ اٛ ݧَوِ، اٛ مَايِ؞ ٻٜ لٛوتِمٛ، ٻٜ ڤُکِّنِمٛ ندٜرْ سُودُ دٛوْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","غَرِيرِ جٛفَّ وٛطِّدَا اٜ غَرِيرِ لِدَّ؞ نغَمْ مَاجُمْ ندٜ تٛکُّٻٜ يٜىٰسُ نَنِ بِيتُرُسْ اٜ تٛنْ، ٻٜ لِلِ وٛرْٻٜ طِطٛ نجَحِ تٛرِيمٛ اٛ وَرَ تٛ مَٻّٜ جَوْطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","بِيتُرُسْ اُمِّي، يَادِ اٜ مَٻّٜ؞ ندٜ اٛ وَرِ، ٻٜ پٜنْتِنِمٛ سُودُ دٛوْ؞ رٜوْٻٜ ٻٜ وٛرْٻٜ مُعّٜنْ مَايِ فُو ٻَدِّيمٛ، ٻٜ ندَرِي اٜ ٻٜ مبٛيَ، اٜ ٻٜ کٛلَّمٛ تٛغّٛوجٜ اٜ غٛطّٜ کٛلْتٜ طٜ دٛوکَسْ ݧٛوتَنِٻٜ کٛ اٛ وٛنْدُنٛو اٜ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","سٜيْ بِيتُرُسْ وُرْتِنِ يِمْٻٜ فُو ندٜرْ سُودُ ندُنْ، اٛ دِشِّي اٛ وَطِ دٛعَارٜ؞ غَطَ مَاجُمْ اٛ وَيْلِتِي اٛ رَارِ ٻَنْدُ ندُنْ، اٛ وِعِ، ‏«‏تَبِيتَ، اُمَّ!‏»‏ سٜيْ تَبِيتَ فٜىٰرِ غِتٜ مُوطُمْ؞ ندٜ اٛ يِعِ بِيتُرُسْ بٛو، اٛ اُمِّي اٛ جٛوطِي؞ ");
INSERT INTO fuv_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","سٜيْ بِيتُرُسْ نَنْغِ جُنْغٛ مَاکٛ، اُمِّنِمٛ؞ غَطَ مَاجُمْ اٛ نٛدِّ رٜوْٻٜ ٻٜ وٛرْٻٜ مُعّٜنْ مَايِ اٜ کٛولِيٻٜ يٜىٰسُ ٻٜنْ، اٛ حٛلِّٻٜ تَبِيتَ اٜ فٛوفَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","حَبَرُ طُمْ نَنَامَ ندٜرْ غَرِيرِ جٛفَّ فُو، حَا طُطْٻٜ کٛولِي جٛومِرَاوٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","بِيتُرُسْ بٛو وَطِي بَلْطٜ طُطّٜ اٜ مٛ جٛوطِي ندٜرْ غَرِيرِ جٛفَّ تٛ وُرٛ ڤِيٛووٛ لَرٜ بِعٜتٜىٰطٛ سِيمَنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","اٜ وٛودِ غٛطّٛ نٜطّٛ بِعٜتٜىٰطٛ کٛنٜىٰلِيُسْ غٛنْطٛ غَرِيرِ کَيْسَارِيَ؞ اٛ مَوْطٛ ندٜرْ کَوْتَلْ سٛوجِعٜنْ بِعٜتٜىٰنغَلْ نغَلْ اِتَالِيَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","اٛ کُلٛووٛ اَللَّه، کَنْکٛ اٜ وُرٛ مَاکٛ فُو؞ اٜ مٛ وَلَّ يَحُودَنْکٛعٜنْ ٻٜ نغَلَنَا نَاع سٜطَّ، اٜ مٛ تٛرٛو اَللَّه کٛو نغٜلٜ شَرٜلْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","وٛنْدٜ ݧَلْندٜ حَادٜ نجَمْندِ تَتِ ندِ ݧَلَوْمَ اٛ يِعِ وَحَيُ؞ ندٜرْ وَحَيُ طُمْ اٛ يِعِ مَلَاعِکَاجٛ بُرْتَنِيطٛمٛ اٜ نجَيْرِ، وِعِمٛ، ‏«‏کٛنٜىٰلِيُسْ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","اٛ رَارِ مَلَاعِکَاجٛ اٛنْ ندٜرْ کُلٛلْ، اٛ وِعِمٛ، ‏«‏نَعَمْ، مَوْطٛ؟»‏ مَلَاعِکَاجٛ اٛنْ وِعِمٛ، ‏«‏اَللَّه نَنِي دٛعَاجٜ مَاطَ اٛ يِعِي کٛ کٛکَّتَا ٻٜ نغَلَنَا؞ ");
INSERT INTO fuv_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","جٛونِ لِلُ وٛٻّٜ نجَحَ غَرِيرِ جٛفَّ ٻٜ نٛدّٛيَ غٛطّٛ بِعٜتٜىٰطٛ سِيمَنْ بِيتُرُسْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","اٜ مٛ طٛنْ جٛوطِي اٜ وُرٛ سِيمَنْ ڤِيٛووٛ لَرٜ مٛ وُرٛ مُوطُمْ وٛنِ حَادٜ مَايٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","ندٜ مَلَاعِکَاجٛ اٛنْ دِلِّ، کٛنٜىٰلِيُسْ نٛدِّ کُوَنٛوٻٜمٛ طِطٛ اٜ سٛوجِيجٛ غٛعٛتٛ کُلٛووٛ اَللَّه غٛنْطٛ لٜيْ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","اٛ طِيوِتَنِٻٜ کٛ مَلَاعِکَاجٛ وِعِمٛ فُو، اٛ لِلِٻٜ ٻٜ نجَحَ غَرِيرِ جٛفَّ؞ ");
INSERT INTO fuv_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","ندٜ فِنِ اٜ ٻٜ دٛوْ لَاوٛلْ، شَکَ ݧَلَوْمَ اٜ ٻٜ حَادٜ غَرِيرِ جٛفَّ، اٜ شَرٜلْ نغٜلْ بِيتُرُسْ پٜنْتِ دٛوْ سُودُ نغَمْ وَطُکِ دٛعَارٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","سٜيْ وٜىٰلٛ نَنْغِمٛ، اٛ وِعِ طُمْ دٜفَنَمٛ ݧَمْندُ؞ اٜ طُمْ ندٜرْ سِرْيَنَاکِمٛ ݧَمْندُ، سٜيْ اٛ يِعِ وَحَيُ؞ ");
INSERT INTO fuv_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","اٛ يِعِ دٛوْ اٜ مَٻِّتِي، غٛطُّمْ نَنْدُطُمْ اٜ وُدٜرٜ مَوْندٜ اٜ طُمْ جِڤِّنِرٛيٜىٰ غُتُّلِّ مَاجُمْ نَيِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","ندٜرْ مَاجُمْ بٛو اٜ وٛودِ مَرْلٜ فٜىٰرٜ‑فٜىٰرٜ طٜ کٛيْطٜ نَيِ، اٜ دَسٛتٛوطٜ، اٜ شٛلِّ؞ ");
INSERT INTO fuv_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","سٜيْ اٛ نَنِ وٛنْدٜ حٛنٛنْدٜ اٜ وِعَمٛ، ‏«‏بِيتُرُسْ، اُمَّ، نَنْغُ، کِرْسَا، ݧَامَا!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","اَمَّا بِيتُرُسْ نٛوتِي وِعِ، ‏«‏اَاعَ، جٛومِرَاوٛ!‏ مِ مٜىٰطَايِ ݧَامُکِ کٛ حَرْمِنِي کٛو کٛ لَاٻَايِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","حٛنٛنْدٜ ندٜنْ ٻٜيْدِ وِعُکِمٛ، ‏«‏تَاع حَرْمِنْ کٛ اَللَّه لَاٻِنِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","طُمْ وَطِ نٛنْ ندٜ تَتِ؞ ندٜنْ کٛ اٛ يِعِ طُمْ سٛعَّا يَاکِ دٛوْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","بِيتُرُسْ اٜ ندٜرْ ݧُمُکِ دٛوْ مَعَنَ وَحَيُ طُمْ اٛ يِعِ؞ اٜ شَرٜلْ نغٜلْ، وٛرْٻٜ ٻٜ کٛنٜىٰلِيُسْ لِلٛيِ اٜ نغٜيْنَ وُرٛ سِيمَنْ؞ ٻٜ نغَرِ، ٻٜ ندَرِي اٜ دَمُّغَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","ٻٜ شِلْمِنِي، ٻٜ پَمِ، ٻٜ مبِعِ کٛو طٛعٛ سِيمَنْ بِعٜتٜىٰطٛ بِيتُرُسْ وٛنِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","بِيتُرُسْ اٜ ندٜرْ ݧُمُکِ دٛوْ کٛ اٛ يِعِ، سٜيْ رُوحُ اَللَّه وِعِمٛ، ‏«‏رَا يِمْٻٜ تَتٛ اٜ طَٻُّتُمَا؞ ");
INSERT INTO fuv_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","اُمَّ جِڤَّ، نجَادَا اٜ مَٻّٜ؞ تَاع حُلُ، نغَمْ مِنْ لِلٛيِٻٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","بِيتُرُسْ جِڤِّي، وِعِ لِلٛيَاٻٜ ٻٜنْ، ‏«‏مِنْ وٛنِ مٛ طَٻِّتٛتٛنْ؞ طُمٜ وَدِّعٛنْ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","ٻٜ مبِعِمٛ، ‏«‏کٛنٜىٰلِيُسْ مَوْطٛ سٛوجِعٜنْ لِلٛيِمِنْ؞ اٛ اَادِلِيجٛ، کُلٛووٛ اَللَّه، مٛ لٜݧٛلْ يَحُودَنْکٛعٜنْ فُو مَنَتَ؞ مَلَاعِکَاجٛ شٜنِيطٛ وَنْغَنِيمٛ وِعِيمٛ اٛ نٛدُّمَا نغَرَا وُرٛ مَاکٛ، نغَمْ اٛ نَنَ کٛ مبِعَتَامٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","سٜيْ بِيتُرُسْ جَٻِّيٻٜ، حٛکِّٻٜ تٛ ٻٜ مبَالَتَ ندٜرْ وُرٛ نغٛنْ؞ ندٜ فِنِ، اٛ اُمِّي اٛ دِلِّدِ اٜ مَٻّٜ؞ وٛٻّٜ ندٜرْ تٛکُّٻٜ يٜىٰسُ وٛنْٻٜ جٛفَّ تٛکِّٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","ندٜ فِنْتِ ٻٜ نجٛتِّي غَرِيرِ کَيْسَارِيَ؞ ندٜنْ مَا کٛنٜىٰلِيُسْ اٜ کَمّٛو غَرٛلْ مَٻّٜ، اٛ حَوْرِتِ بَنْدِرَاٻٜ مَاکٛ اٜ حِغٛوٻٜ مَاکٛ اٜ ٻٜ کٜطِيٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","اٜ نَتُّکِ بِيتُرُسْ وُرٛ نغٛنْ، کٛنٜىٰلِيُسْ جَٻِّيمٛ، دِشِّي يٜىٰسٛ مَاکٛ مَوْنِنِمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","اَمَّا بِيتُرُسْ اُمِّنِمٛ، وِعِ، ‏«‏اُمَّ؞ مِنْ مِ نٜطّٛ تَنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","بِيتُرُسْ اٜ مٜدَّ اٜ مَاکٛ، حَا ٻٜ نَتِّ ندٜرْ وُرٛ، ٻٜ تَوِ يِمْٻٜ طُطْٻٜ اٜ کَوْرِتِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","سٜيْ بِيتُرُسْ وِعِٻٜ، ‏«‏اٛنٛنْ اٜ کٛعٜ مٛوطٛنْ اٛنْ اَنْدِ دِينَ اَمِنْ حَطِي يَحُودَنْکٜىٰجٛ حَوْتُکِ حٛورٜ اٜ غٛطّٛ نَاع يَحُودَنْکٜىٰجٛ کٛو نَتُّکِ وُرٛ مَاکٛ؞ اَمَّا اَللَّه حٛلِّييَمْ تٛع مِ وِعَ کٛو مٛيٜ نٛ کَرْمِنِيطٛ کٛو لَاٻَا؞ ");
INSERT INTO fuv_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","نغَمْ نٛنْ ندٜ لِلٛنٛيْطٛنْيَمْ، مِ وَرِي مِ سَلَاکِ؞ جٛونِ اٜ مِ يِطِ نَنُکِ کٛ نٛدَّنْطٛنْيَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","سٜيْ کٛنٜىٰلِيُسْ وِعِمٛ، ‏«‏بَلْطٜ نَيِ پَٻِّيطٜ اٜ مِ وَطَ دٛعَارٜ ندٜرْ وُرٛ اَمْ نجَمْندِ تَتِ بٛ جٛونِ؞ سٜيْ رَا، نٜطّٛ مٛ کٛلْتٜ طٜلْکِتٛتٛوطٜ وَرِي، اٛ دَرِي يٜىٰسٛ اَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","اٛ وِعِيَمْ، ‏‹‏کٛنٜىٰلِيُسْ، اَللَّه نَنِي دٛعَاجٜ مَاطَ اٛ جَٻِي سَدَکَاجِ مَاطَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","لِلُ غٛطّٛ غَرِيرِ جٛفَّ، نٛدَّا غٛطّٛ بِعٜتٜىٰطٛ سِيمَنْ بِيتُرُسْ غٛنْطٛ وُرٛ غٛطّٛ ڤِيٛووٛ لَرٜ بِعٜتٜىٰطٛ سِيمَنْ، مٛ وُرٛ مُوطُمْ وٛنِ حَادٜ مَايٛ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","طٛنْ اٜ طٛنْ لِلْمِ تٛ مَاطَ؞ مِ نَنِي بٜلْطُمْ غَرٛلْ مَاطَ؞ جٛونِ مِنْ فُو اٜ مِنْ طٛعٛ يٜىٰسٛ اَللَّه نغَمْ مِنْ نَنَ کٛ جٛومِرَاوٛ وِعِمَا مبِعَامِنْ فُو؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","ندٜنْ بِيتُرُسْ فُطِّ مٜتَنْکِٻٜ وِعِ، ‏«‏جٛونِ غٛونغَ اٜ مِ اَنْدِ اَللَّه حٛلَّتَا فٜىٰرٛوتِرٛلْ حَکُّندٜ يِمْٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","تٛ غٛطّٛ حُلِيمٛ، حُوِي کٛ وٛوطِ، اَللَّه جَٻَيْمٛ کٛو طُمْ اِرِ نغٛلٜ لٜݧٛلْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","اٛنْ اَنْدِ حَبَرُ طُمْ اَللَّه لِلْدٛيِ اِسْرَاعِيلَنْکٛعٜنْ؞ کَنْجُمْ وٛنِ ٻٜ نغَعَجِنَ حَبَرُ بٜلْطُمْ، طُمْ جَمْ کٜٻَاطُمْ بَرْکَ يٜىٰسُ اَلْمَسِيحُ؞ کَنْکٛ وٛنِ جٛومِرَاوٛ يِمْٻٜ فُو؞ ");
INSERT INTO fuv_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","اٛنْ اَنْدِ نٛ حَبَرُ طُمْ سَنْکِتٛرِي کٛو تٛيٜ ندٜرْ لٜيْدِ يَحُودِيَ؞ طُمْ فُطِّي دَغَ لٜيْدِ غَلِيلِ غَطَ يَحَيَ وَطِي وَعَجُ دٛوْ بَڤْتِسْمَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","اٛنْ اَنْدِ نٛ اَللَّه سُٻِرِ يٜىٰسُ نَجَرَنْکٜىٰجٛ، اٜ نٛ اٛ حٛکِّرِمٛ بَوْطٜ رُوحُ مَاکٛ؞ اٛنْ اَنْدِ نٛ يٜىٰسُ يِيلٛرِي ندٜرْ غَرِيجٜ فُو اٜ مٛ حُوَ کُوطٜ بٛطّٜ، اٜ مٛ يَمْطِتِنَ ٻٜ شٜيْطَنْ تٛرَّتَ فُو نغَمْ اَللَّه اٜ وٛنْدِ اٜ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","مِنٛنْ مِنْ شٜيْدُعٜنْ کٛ اٛ حُوِ ندٜرْ لٜيْدِ يَحُودِيَ اٜ ندٜرْ غَرِيرِ اُرُشَلِيمَ فُو؞ ٻٜ ٻِلِمٛ دٛوْ غَافَانغَلْ، ٻٜ مبَرِمٛ، ");
INSERT INTO fuv_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","اَمَّا اَللَّه اُمِّنِمٛ دَغَ مَيْدٜ ݧَلْندٜ تَتَوْرٜ، وَنْغِنِمٛ ندٜرْ يِمْٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","اٛ وَنْغَنَايِ يِمْٻٜ فُو، اَمَّا اٛ وَنْغَنِيمِنْ مِنٛنْ شٜيْدُعٜنْ ٻٜ اَللَّه اَرْتِ سُٻُکِ؞ مِنٛنْ نغٛنِ ݧَمْندُٻٜ اٜ مَاکٛ نجَرْدِ اٜ مَاکٛ غَطَ اٛ اُمَّکٜ دَغَ مَيْدٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","اٛ وِعِمِنْ مِنْ نغَعَجِنَنَ يِمْٻٜ، مِنْ تَبِّتِنَنَٻٜ يٜىٰسُ وٛنِ مٛ اَللَّه وَرْتِرِ کِيتٛتٛوطٛ مَيْٻٜ اٜ ٻٜ يٛنْکِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","اَنَّبٛعٜنْ فُو مٜتِي دٛوْ مَاکٛ ٻٜ مبِعِي کٛولِيطٛمٛ فُو حٜٻَيْ يَافَنٜىٰکِ حَکّٜ مُوطُمْ بَرْکَ اِنْدٜ مَاکٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","بِيتُرُسْ اٜ ندٜرْ مٜتَنْکِٻٜ، سٜيْ رُوحُ اَللَّه جِڤِّي دٛوْ نَنٛوٻٜمٛ فُو؞ ");
INSERT INTO fuv_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","يَحُودَنْکٛعٜنْ کٛولِيٻٜ يٜىٰسُ غَرْدُٻٜ اٜ بِيتُرُسْ کَيْطِنِي ندٜ ٻٜ نغِعِ نٛ اَللَّه حٛکِّرِ يِمْٻٜ نَاع يَحُودَنْکٛعٜنْ رُوحُ مُوطُمْ، ");
INSERT INTO fuv_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","نغَمْ ٻٜ نَنِي يِمْٻٜ ٻٜنْ اٜ مٜتِرَ طٜمْطٜ طٜ ٻٜ اَنْدَا، اٜ نغٜتَّ اَللَّه؞ سٜيْ بِيتُرُسْ وِعِ، ");
INSERT INTO fuv_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","‏«‏يِمْٻٜ ٻٜعٜ کٜٻِي رُوحُ اَللَّه نٛ کٜٻِرْطٜنْطُمْ؞ طُمٜ حَطَتَ ٻٜ نغَطَنٜىٰ بَڤْتِسْمَ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","نغَمْ نٛنْ اٛ وَطِ ٻٜ نغَطَنٜىٰ بَڤْتِسْمَ ندٜرْ اِنْدٜ يٜىٰسُ اَلْمَسِيحُ؞ غَطَ مَاجُمْ، ٻٜ تٛرِيمٛ اٛ جٛوطٛو تٛ مَٻّٜ بَلْطٜ سٜطَّ؞ ");
INSERT INTO fuv_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","لِلَاٻٜ اٜ تٛکُّٻٜ يٜىٰسُ وٛنْٻٜ لٜيْدِ يَحُودِيَ فُو ٻٜ نَنِي حَبَرُ يِمْٻٜ نَاع يَحُودَنْکٛعٜنْ نجَٻِي وٛلْدٜ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","ندٜ بِيتُرُسْ يَحِ اُرُشَلِيمَ، يَحُودَنْکٛعٜنْ کٛولِيٻٜ يٜىٰسُ دَرِيٻٜ دٛوْ ندٛنُ مُعّٜنْ نغُ نَادُکِ ٻٜ مبِعِ کٛ اٛ وَطِ طُمْ وٛوطَا، ");
INSERT INTO fuv_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","اٜ ٻٜ مبِعَ، ‏«‏نغَمْ طُمٜ نَتُّطَا ندٜرْ وُرٛ يِمْٻٜ ٻٜ نَادَاکَ، حَا اَ ݧَمْدِي اٜ مَٻّٜ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","بِيتُرُسْ طِيوِتَنِٻٜ نٛ کٛو طُمٜ فُطِّرِ، اٛ وِعِٻٜ، ");
INSERT INTO fuv_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","‏«‏کٛ نغٛنّٛومِ ندٜرْ غَرِيرِ جٛفَّ اٜ مِ وَطَ دٛعَارٜ، مِ يِعِي وَحَيُ؞ ندٜرْ وَحَيُ طُمْ مِ يِعِي غٛطُّمْ اٜ جِڤّٛيٛو دَغَ دٛوْ؞ اٜ طُمْ نَنْدِ اٜ وُدٜرٜ مَوْندٜ کَٻَّاندٜ اٜ غُتُّلِّ نَيِ؞ طُمْ پِوٛيِ دَغَ دٛوْ اٜ طُمْ جِڤِّنٛيٜىٰ تٛ اَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","ندٜ ندَارُمِ ندٜرْ مَاجُمْ، سٜيْ نغِيمِ مَرْلٜ طٜ کٛيْطٜ نَيِ اٜ دِيوٜ لَدّٜ اٜ دَسٛتٛوطٜ اٜ شٛلِّ ندٜرْ مَيْرٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","سٜيْ نَنْمِ حٛنٛنْدٜ اٜ وِعَيَمْ، ‏‹‏بِيتُرُسْ، اُمَّ، نَنْغُ، کِرْسَا، ݧَامَا!‏›‏ ");
INSERT INTO fuv_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","مبِعُمِ، ‏‹‏اَاعَ، جٛومِرَاوٛ!‏ مِ مٜىٰطَايِ ݧَامُکِ کٛ حَرْمِنِي کٛو کٛ لَاٻَايِ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","حٛنٛنْدٜ ندٜنْ فُطِّتِ وِعِيَمْ، ‏‹‏تَاع حَرْمِنْ کٛ اَللَّه لَاٻِنِ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","طُمْ وَطِ نٛنْ ندٜ تَتِ؞ غَطَ نٛنْ طُمْ فُو طُمْ سٛعَّا دٛوْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","اٜ شَرٜلْ نغٜلْ، وٛرْٻٜ تَتٛ لِلٛيَاٻٜ تٛ اَمْ دَغَ کَيْسَارِيَ نجٛتِّي وُرٛ تٛ نغٛنْمِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","رُوحُ اَللَّه وِعِيَمْ مِ يَادَ اٜ مَٻّٜ تٛع مِ وَطَ سٜکٛ؞ ٻٜعٜ تٛکُّٻٜ يٜىٰسُ جٛوٜىٰغٛعٛ نجَادِ اٜ اَمْ، مِنْ نَتِّدِ وُرٛ کٛنٜىٰلِيُسْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","اٛ وِعِمِنْ نٛ اٛ يِعِرِ مَلَاعِکَاجٛ غَرْطٛ وُرٛ مَاکٛ وِعِمٛ، ‏‹‏لِلُ غٛطّٛ غَرِيرِ جٛفَّ، نٛدَّا غٛطّٛ بِعٜتٜىٰطٛ سِيمَنْ بِيتُرُسْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","اٛ وِعٜتٜ نٛ کٜٻْرَتَا کِسْندَمْ، اَنْ اٜ وُرٛ مَاطَ فُو؞›‏ ");
INSERT INTO fuv_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","ندٜ ڤُطُّمِ مٜتُکِ، سٜيْ رُوحُ اَللَّه جِڤِّي دٛوْ مَٻّٜ نٛنْ نٛ طُمْ جِڤّٛرِي دٛوْ مٜىٰطٜنْ اَرَنْدٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","سٜيْ شِفْتٛرْمِ کٛ جٛومِرَاوٛ وِعُنٛو وِعُکِ، ‏‹‏يَحَيَ وَطَنِي يِمْٻٜ بَڤْتِسْمَ اٜ ندِيَمْ، اَمَّا اٛنٛنْ، اَللَّه وَطِرَنَيْعٛنْ بَڤْتِسْمَ اٜ رُوحُ مُوطُمْ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","تٛ اَللَّه حٛکِّيٻٜ دٛکَّلْ نغَلْ اٛ حٛکِّعٜنْ ندٜ کٛولِيطٜنْ يٜىٰسُ اَلْمَسِيحُ جٛومِرَاوٛ، تٛو، مِنْ مِ مٛيٜ کَطَيْمِ کٛ اَللَّه يِطِ وَطُکِ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","ندٜ ٻٜ نَنِ کٛ اٛ وِعِ، ٻٜ ندٜعِّتِ، ٻٜ مَنْتِ اَللَّه، ٻٜ مبِعِ، ‏«‏اَللَّه وَطَنِي يِمْٻٜ نَاع يَحُودَنْکٛعٜنْ لَاوٛلْ تُوبُکِ نغَمْ ٻٜ کِسَ ٻٜ کٜٻَ يٛنْکِ کِ رٜعَتَا؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","وٛٻّٜ تٛکُّٻٜ يٜىٰسُ شَنْکِتَامَ نغَمْ تٛرَّاجِ طِ ٻٜ تٛرَّا غَطَ طُمْ وَرِي اِسْتِفَانُسْ؞ وٛٻّٜ نجَحِ فِنِيکِيَ، وٛٻّٜ نجَحِ سَيِيفُرُسْ، وٛٻّٜ بٛو نجَحِ اَنْتَاکِيَ؞ اٜ ٻٜ نغَعَجِنَ ندٜرْ يَحُودَنْکٛعٜنْ تَنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","اَمَّا وٛٻّٜ ندٜرْ مَٻّٜ پِوٛيْٻٜ سَيِيفُرُسْ اٜ سَايِرِنْ نَتِّ غَرِيرِ اَنْتَاکِيَ، اٜ ٻٜ نغَعَجِنَ حَبَرُ بٜلْطُمْ طُمْ يٜىٰسُ جٛومِرَاوٛ ندٜرْ يِمْٻٜ نَاع يَحُودَنْکٛعٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","جٛومِرَاوٛ بٛو اٜ وٛنْدِ اٜ مَٻّٜ؛ يِمْٻٜ طُطْٻٜ تُوبِ نغَيْلِتِي تٛ جٛومِرَاوٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","کَوْتَلْ تٛکُّٻٜ يٜىٰسُ وٛنْٻٜ اُرُشَلِيمَ بٛو نَنِي حَبَرُ کٛ وَطِ تٛنْ اَنْتَاکِيَ، سٜيْ ٻٜ لِلِ بَرْنَبَ تٛ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","ندٜ بَرْنَبَ وَرِ يِعِ نٛ اَللَّه بَرْکِطِنِرِ يِمْٻٜ نَاع يَحُودَنْکٛعٜنْ تٛکُّٻٜ يٜىٰسُ، اٛ نَنِ بٜلْطُمْ، اٛ سٜمْبِطِنِٻٜ ٻٜ ندَرٛو دٛوْ کٛ ٻٜ کٛولِي، ٻٜ تٛکَّ جٛومِرَاوٛ اٜ ٻٜرْندٜ غٛعٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","نغَمْ بَرْنَبَ اٛ نٜطّٛ مٛ نغِکُّ بٛطُّمْ، کٜوْطٛ رُوحُ اَللَّه کٛولِيطٛ جٛومِرَاوٛ؞ سٜيْ يِمْٻٜ طُطْٻٜ تُوبِ تٛکِّ جٛومِرَاوٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","غَطَ نٛنْ، بَرْنَبَ يَحِ غَرِيرِ تَرْسُسْ نغَمْ طَٻُّتُکِ شَاوُلُ؞ ");
INSERT INTO fuv_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","ندٜ اٛ تَوِمٛ، اٛ يَارِمٛ غَرِيرِ اَنْتَاکِيَ؞ ٻٜ نجٛوطٛدِي اٜ کَوْتَلْ تٛکُّٻٜ يٜىٰسُ وٛنْٻٜ تٛنْ حِتَاندٜ وٛعٛيْرٜ، اٜ ٻٜ اٜکِّتِنَ يِمْٻٜ طُطْٻٜ؞ اٜ اَنْتَاکِيَ طُمْ فُطِّ نٛدِّرْکِ تٛکُّٻٜ يٜىٰسُ مَسِيحِيَنْکٛعٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","ندٜرْ بَلْطٜ طٜنْ، وٛٻّٜ اَنَّبٛعٜنْ پِوٛيِ اُرُشَلِيمَ نغَرِ اَنْتَاکِيَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","غٛعٛتٛ ندٜرْ مَٻّٜ بِعٜتٜىٰطٛ اَغَبُسْ اُمِّي دَرِي وَطِ اَنَّبَاکُ اٜ بَوْطٜ رُوحُ اَللَّه، وِعِ وٜىٰلٛ کَلُّنغٛ وَطَيْ ندٜرْ دُونِيَارُ فُو؞ نغٛ بٛو وَطِ ندٜرْ شَرٜلْ لَامِيطٛ مَوْطٛ بِعٜتٜىٰطٛ کَلَوْدِيُسْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","سٜيْ تٛکُّٻٜ يٜىٰسُ ڤُطِّ حَوْرُتُکِ شٜىٰدٜ، کٛو مٛيٜ وَدَّ کٛ وَاوِ وَدُّکِ، نغَمْ ٻٜ مبَلَّ بَنْدِرَاٻٜ مَٻّٜ وٛنْٻٜ لٜيْدِ يَحُودِيَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","ندٜ ٻٜ کَوْرِتِ بَلَّلْ نغَلْ، سٜيْ ٻٜ لِلْدِنغَلْ اٜ جُنْغٛ بَرْنَبَ اٜ شَاوُلُ، ٻٜ نجَارَنغَلْ تٛ مَوْٻٜ کَوْتَلْ تٛکُّٻٜ يٜىٰسُ تٛنْ اُرُشَلِيمَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","ندٜرْ شَرٜلْ نغٜلْ، حِرُدُسْ لَامِيطٛ فُطِّ تٛرُّکِ وٛٻّٜ ندٜرْ تٛکُّٻٜ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","اٛ نَنْغِ يَاکُبُ مِݧِرَاوٛ يَحَيَ، اٛ وَطِ طُمْ وَرْدِمٛ کَافَحِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","ندٜ اٛ يِعِ کٛ اٛ وَطِ وٜلِي يَحُودَنْکٛعٜنْ، اٛ نَنْغِ بِيتُرُسْ؞ نَنْغُکِ کِنْ بٛو وَرِ دٜي‑دٜيْ اٜ شَرٜلْ حُمْتٛ بُرٛودِ طُمْ وَلَا پُوفِنِرْطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","غَطَ اٛ نَنْغِيمٛ، اٛ مَٻِّمٛ ندٜرْ سُودُ شُرَلْ، اٛ وَطِ مٛٻْطٜ سٛوجِعٜنْ نَيِ طٜ سٛوجِعٜنْ نَيٛ‑نَيٛ ٻٜ ندٜىٰنَمٛ؞ اٜ مٛ يِطِ وَدُّکِمٛ يٜىٰسٛ يِمْٻٜ غَطَ حُمْتٛ نغٛنْ اٛ وَطَنَمٛ کِيتَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","بِيتُرُسْ مَٻَّا ندٜرْ سُودُ شُرَلْ، اَمَّا کَوْتَلْ تٛکُّٻٜ يٜىٰسُ نغَطِ کَ وَطَنْکِمٛ دٛعَارٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","ندٜرْ جٜمَّارٜ ندٜ حِرُدُسْ ݧُمِ وُرْتِنْکِ بِيتُرُسْ، وَطَنَمٛ کٛ يِطِ تٛ وٜىٰتِ، بِيتُرُسْ اٜ طَانِي حَکُّندٜ سٛوجِعٜنْ طِطٛ، اٜ مٛ حَٻّٛرِي ٻٛغِّ نجَمْندِ؞ رٜىٰنٛوٻٜ بٛو اٜ ندٜىٰنِ دَمُّطٜ سُودُ شُرَلْ ندُنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","طٛنْ اٜ طٛنْ مَلَاعِکَاجٛ جٛومِرَاوٛ وَنْغَنِمٛ، جَيْنغٛلْ يٜيْنِي ندٜرْ سُودُ ندُنْ فُو؞ اٛ دِمْبِ بِيتُرُسْ، اٛ فِندِنِمٛ، اٛ وِعِ، ‏«‏يَوْنُ، اُمَّ!‏»‏ سٜيْ ٻٛغِّ نجَمْندِ طِطُمْ حَٻِّرِ جُوطٜ مَاکٛ تَپِ، طِ نجَنِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","مَلَاعِکَاجٛ اٛنْ وِعِمٛ، ‏«‏تَادَ تَادٛرْدٜ مَاطَ، فَطَ ڤَطٜ مَاطَ؞»‏ ندٜ بِيتُرُسْ وَطِ نٛنْ، مَلَاعِکَاجٛ اٛنْ وِعِمٛ، ‏«‏وَانَ شُدَّارِ مَاطَ، تٛکَّمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","بِيتُرُسْ وُرْتِي، تٛکِّمٛ؞ اٛ اَنْدَا کٛ مَلَاعِکَاجٛ اٛنْ وَطَتَ طُمْ غٛونغَ؛ اٛ کَمِّ طُمْ وَحَيُ؞ ");
INSERT INTO fuv_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","ندٜ ٻٜ پَٻِّي رٜىٰنٛوٻٜ اَرَنْدٜعٜنْ اٜ شَکِتِيٻٜ، ٻٜ نغَرِ دَمُّغَلْ نجَمْندِ دَارَيْنغَلْ غَرِيرِ؞ نغَلْ مَٻِّتِي اٜ حٛورٜ مَاغَلْ يٜىٰسٛ مَٻّٜ، سٜيْ ٻٜ مبُرْتِي، ٻٜ نَنْغِ لَاوٛلْ؞ اٜ ٻٜ نجَحَ، سٜيْ طٛنْ اٜ طٛنْ مَلَاعِکَاجٛ اٛنْ مَجِّتَنِمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","ندٜنْ حَکِّيلٛ بِيتُرُسْ وَرْتِ، اٛ وِعِ، ‏«‏جٛونِ مِ تَبِّتِنِي جٛومِرَاوٛ لِلٛيِي مَلَاعِکَاجٛ مُوطُمْ نغَمْ حِسْنَيَمْ دَغَ جُنْغٛ حِرُدُسْ اٜ ݧُمٛوجِ يَحُودَنْکٛعٜنْ کَلُّطِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","ندٜ اٛ اَنْدِتِ نٛنْ، اٛ يَحِ وُرٛ مَرْيَامَ، مَدُوجٛ يَحَيَ بِعٜتٜىٰطٛ مَرْکُسْ، تٛنْ تٛ يِمْٻٜ طُطْٻٜ کَوْرِتِ اٜ نغَطَ دٛعَارٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","ندٜ بِيتُرُسْ فِيِ دَمُّغَلْ وُرٛ نغٛنْ، کٛرْطٛ بِعٜتٜىٰطٛ رٛودَ وَرِ دَمُّغَلْ نغَلْ نغَمْ يِعَ طُمْ مٛيٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","ندٜ اٛ اَنْدِتِ حٛنٛنْدٜ بِيتُرُسْ، اٛ نَنِ بٜلْطُمْ حَا اٛ يٜجِّتِ مَٻِّتَنْکِمٛ دَمُّغَلْ؞ اٛ حَٻْتِي اٛ سٛعِّي ندٜرْ، اٛ وِعِٻٜ طُمْ بِيتُرُسْ دَرِي يَاسِ دَمُّغَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","ٻٜ مبِعِمٛ، ‏«‏اَ کَاݝَاطٛ!‏»‏ اَمَّا اٛ ٻٜيْدِ وِعُکِ طُمْ بِيتُرُسْ؞ طٛنْمَا ٻٜ مبِعِمٛ، ‏«‏طُمْ مَلَاعِکَاجٛ مَاکٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","اَمَّا بِيتُرُسْ دَرِي اٜ فِيَ دَمُّغَلْ؞ ندٜ ٻٜ مَٻِّتَنِمٛ ٻٜ نغِعِمٛ، طُمْ حَيْطِنِيٻٜ نَاع سٜطَّ؞ ");
INSERT INTO fuv_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","اٛ پٜفْتَنِٻٜ جُنْغٛ نغَمْ ٻٜ ندٜعِّتَ، اٛ وِعِٻٜ نٛ جٛومِرَاوٛ وُرْتِنِرِمٛ ندٜرْ سُودُ شُرَلْ، اٛ وِعِ، ‏«‏کٛکّٜىٰ يَاکُبُ حَبَرُ طُعُمْ، اٜ تٛکُّٻٜ يٜىٰسُ حٛرِيٻٜ فُو؞»‏ غَطَ مَاجُمْ اٛ وُرْتِي، اٛ يَحِ وٛنْدٜ وِغٜىٰرٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","ندٜ وٜىٰتِ، وٜمْبٜرٜ مَوْندٜ نَنْغِ سٛوجِعٜنْ ٻٜنْ نغَمْ ٻٜ اَنْدَا تٛ بِيتُرُسْ وٛنِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","ندٜ حِرُدُسْ طَٻِّتِ بِيتُرُسْ حٜٻْتَايِمٛ، وَطِ طُمْ پَمَ سٛوجِعٜنْ رٜىٰنٛوٻٜ ٻٜنْ طُمْ وَرَٻٜ؞ غَطَ مَاجُمْ حِرُدُسْ اَلِ لٜيْدِ يَحُودِيَ، اٛ يَحِ غَرِيرِ کَيْسَارِيَ، اٛ نٜىٰٻِ تٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","حِرُدُسْ اٜ مٛنَّنَ يِمْٻٜ غَرِيجٜ تَايَ اٜ سِدٛنْ؞ سٜيْ يِمْٻٜ غَرِيجٜ طٜنْ کَوْرِتِ نجَحِ تٛ مَاکٛ؞ ٻٜ اَرْتِ نَرُّکِ اٜ مَوْطٛ کُوَنٛوٻٜ حِرُدُسْ بِعٜتٜىٰطٛ بِلَسْتُسْ؞ ندٜنْ ٻٜ نجَحِ تٛ حِرُدُسْ، ٻٜ تٛرِي جٛنْدٜ جَمْ حَکُّندٜ مَٻّٜ، نغَمْ ندٜرْ لٜيْدِ مَاکٛ ٻٜ کٜٻَتَ ݧَمْندُ؞ ");
INSERT INTO fuv_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","ندٜ ݧَلْندٜ ندٜ اٛ رٜسَنِٻٜ وَرِ، حِرُدُسْ ٻٛرْنِي کٛلْتٜ لَامُ، جٛوطِي دٛوْ جٛوطٛرْغَلْ لَامُ، اٛ مٜتَنِٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","سٜيْ ٻٜ مٜتِ سٜمْبٜىٰ، ٻٜ مبِعِ، ‏«‏طُعُمْ طُمْ حٛنٛنْدٜ اَلَّح، نَاع طُمْ حٛنٛنْدٜ نٜطّٛ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","طٛنْ اٜ طٛنْ مَلَاعِکَاجٛ جٛومِرَاوٛ يٛوفٛنٛيِمٛ ݧَوُ نغَمْ اٛ مَوْنِنَايِ اَللَّه؞ غِلْپِ نغَطِ کَ ݧَامُکِمٛ حَا اٛ مَايِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","اَمَّا حَالَ اَللَّه يَحِ يٜىٰسٛ، ٻٜيْدِ سَنْکِتَاکِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","ندٜ بَرْنَبَ اٜ شَاوُلُ کٜىٰݧِ کُوغَلْ مُعّٜنْ ندٜرْ اُرُشَلِيمَ، ٻٜ کٛوتِدِ اٜ يَحَيَ بِعٜتٜىٰطٛ مَرْکُسْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","ندٜرْ کَوْتَلْ تٛکُّٻٜ يٜىٰسُ وٛنْٻٜ غَرِيرِ اَنْتَاکِيَ اٜ وٛودِ اَنَّبٛعٜنْ اٜ اٜکِّتِنٛوٻٜ، کَمْٻٜ نغٛنِ بَرْنَبَ اٜ سَامِنُ بِعٜتٜىٰطٛ ٻَلٜىٰجٛ، اٜ لُوسِيُسْ سَايِرَنْکٜىٰجٛ، اٜ مَنَيٜنْ مَوْنُدُطٛ اٜ حِرُدُسْ لَامِيطٛ، اٜ شَاوُلُ؞ ");
INSERT INTO fuv_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","وٛنْدٜ ݧَلْندٜ اٜ ٻٜ مَوْنِنَ جٛومِرَاوٛ اٜ ٻٜ شُومٛو، سٜيْ رُوحُ اَللَّه وِعِٻٜ، ‏«‏کَکِّتَنٜىٰيَمْ بَرْنَبَ اٜ شَاوُلُ نغَمْ کُوغَلْ نغَلْ نٛدُّمِٻٜ ٻٜ نغَطَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","غَطَ ٻٜ شُومَکٜ ٻٜ نغَطِي دٛعَارٜ، ٻٜ نجٛوَنِ بَرْنَبَ اٜ شَاوُلُ جُوطٜ ٻٜ مبَرْکِطِنِٻٜ، ٻٜ طٛفْتِٻٜ ٻٜ ندِلِّ؞ ");
INSERT INTO fuv_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","غَطَ رُوحُ اَللَّه لِلِي بَرْنَبَ اٜ شَاوُلُ، ٻٜ نجَحِ غَرِيرِ سَلُوکِيَ، دَغَ تٛنْ ٻٜ نَتِّ کٛمِوَلْ ٻٜ نجَحِ لٜيْدِ سَيِيفُرُسْ نغٛنْدِ شَکَ ندِيَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","ندٜ ٻٜ نجٛتِّي سَلَمِسْ، ٻٜ نغَعَجِنِ وٛلْدٜ اَللَّه طٛنْ ندٜرْ شُوطِ دٛعَارٜ يَحُودَنْکٛعٜنْ؞ يَحَيَ بِعٜتٜىٰطٛ مَرْکُسْ بٛو اٜ وٛنْدِ اٜ مَٻّٜ، اٜ مٛ وَلَّٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","ٻٜ نغِيلِي ندٜرْ لٜيْدِ سَيِيفُرُسْ نغٛنْدِ شَکَ ندِيَمْ حَا ٻٜ نغَرِ غَرِيرِ بَافٛسْ؞ تٛنْ ٻٜ کَوْرِ اٜ غٛطّٛ يَحُودَنْکٜىٰجٛ دَرْنٛووٛ بِعٜتٜىٰطٛ بَر‑جٛوشُوَ؞ اٛ اَنَّبِيجٛ فٜوْرٜ، ");
INSERT INTO fuv_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","غٛنْدُطٛ اٜ غٛمْنَاجٛ لٜيْدِ ندِنْ؞ اِنْدٜ غٛمْنَاجٛ اٛنْ سَرْجِيُسْ بُلُسْ، اٛ نٜطّٛ غٛودُطٛ فَامُ؞ اٛ نٛدِّ بَرْنَبَ اٜ شَاوُلُ نغَمْ اٜ مٛ يِطِ نَنُکِ وٛلْدٜ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","اَمَّا بَر‑جٛوشُوَ اٛنْ بِعٜتٜىٰطٛ اَلِمَسْ، اٛ جَٻَايِ لِلَاٻٜ ٻٜنْ؞ ﴿مَعَنَ اَلِمَسْ وٛنِ دَرْنٛووٛ نغَمْ اٛ دَرْنٛووٛ؞﴾اٜ مٛ يِطِ حَطُکِ غٛمْنَاجٛ اٛنْ جَٻَ وٛلْدٜ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","سٜيْ شَاوُلُ، بِعٜتٜىٰطٛ بُلُسْ، کٜىٰوُطٛ رُوحُ اَللَّه، سُتِيمٛ، ");
INSERT INTO fuv_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","وِعِمٛ، ‏«‏اَنْ ٻِي شٜيْطَنْ، اَ غَݧٛ کٛو طُمٜ بٛطُّمْ، کٜىٰوُطٛ پٛيْرٜ کَلُّندٜ اٜ نغَݧَاندِ؞ اَ يِطِ وَيْلُتُکِ غٛونغَ جٛومِرَاوٛ کَ وَرْتَ فٜوْرٜ؟ ");
INSERT INTO fuv_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","جٛونِ جٛومِرَاوٛ نٛ تٛرّٜتٜ، اَ وُمَيْ، اَ يِعَتَا نَانغٜ نَا طُمْ حٛشِّي شَرٜلْ؞»‏ طٛنْ اٜ طٛنْ وٛنْدٜ ݧِوْرٜ سُدِّ غِتٜ اَلِمَسْ اٛ وُمِ؞ اٛ وَطِ کَ مبُمْبُمْتُکِ، اٜ مٛ طَٻِّتَ جٛغَنْتٛوطٛمٛ جُنْغٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","ندٜ غٛمْنَاجٛ اٛنْ يِعِ کٛ وَطِ، اٛ جَٻِ يٜىٰسُ، نغَمْ اٛ حَيْطِنِي اٜ اٜکِّتِنٛلْ نغٛلْ دٛوْ جٛومِرَاوٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","سٜيْ بُلُسْ اٜ ٻٜ اٛ يَادَتَ نَتِّ کٛمِوَلْ دَغَ غَرِيرِ بَافٛسْ، ٻٜ نجَحِ فٜرْغَ ندٜرْ لٜيْدِ بَمْفِيلِيَ؞ اَمَّا يَحَيَ مَرْکُسْ اَلِٻٜ سٛعِّي اُرُشَلِيمَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","ٻٜ پَٻِّي فٜرْغَ، ٻٜ نجَحِ غَرِيرِ اَنْتَاکِيَ ندٜرْ لٜيْدِ بِسِيدِيَ؞ ݧَلْندٜ سِوْتَارٜ ٻٜ نَتِّ سُودُ دٛعَارٜ ٻٜ نجٛوطِي؞ ");
INSERT INTO fuv_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","غَطَ طُمْ جَنْغِي اَتَّوْرَ اٜ دٜفْتٜ اَنَّبٛعٜنْ، سٜيْ اَرْدِيٻٜ سُودُ دٛعَارٜ ندُنْ لِلِ غٛطّٛ وِعَٻٜ، ‏«‏بَنْدِرَاٻٜ، تٛ اٛنْ نغٛودِ بٛلِيطٜ طٜ شٜمْبِطِنِرْتٛنْ يِمْٻٜ، مبِعٜىٰٻٜکَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","سٜيْ بُلُسْ اُمِّي، پٜفْتِ جُنْغٛ مُوطُمْ، وِعِ، ‏«‏اٛنٛنْ بَنْدِرَاٻٜ اَمْ اِسْرَاعِيلَنْکٛعٜنْ اٜ حٛرِيٻٜ کُلٛوٻٜ اَللَّه، نَنٜىٰ کٛ مبِعَيْمِعٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","اَللَّه مٛ اِسْرَاعِيلَنْکٛعٜنْ اٛ سُٻِي مَامَعٜنْ مٜىٰطٜنْ، اٛ مَوْنِنِي لٜݧٛلْ مَٻّٜ کٛ نغٛلْ وٛنّٛو لٜيْدِ مَسَرْ، کَدِمَا اٛ وُرْتِنِيٻٜ لٜيْدِ ندِنْ اٜ بَوْطٜ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","اٛ مُݧَنِيٻٜ دُوٻِ 40 ندٜرْ لَدّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","غَطَ اٛ حَلْکِي لٜپِّ جٛوٜىٰطِطِ جٛوطِنٛوطِ ندٜرْ لٜيْدِ کَنْعَانَ، اٛ حٛکِّٻٜ ندٛنُ لٜيْدِ ندِنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","فِي طُعُمْ فُو وَطِي ندٜرْ دُوٻِ 450؞ غَطَ مَاجُمْ، اٛ سُٻَنِٻٜ غَطٛوٻٜ کِيتَ حَا يَاکِ جَامَنُ اَنَّبِ سَمَاعِلَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","‏«‏غَطَ طٛنْ ٻٜ تٛرِي اَللَّه حٛکَّٻٜ لَامِيطٛ؞ سٜيْ اَللَّه حٛکِّٻٜ شَاوُلُ، ٻِي کِسْ، پِوٛيْطٛ لٜݧٛلْ بِلِيَامِنُ؞ اٛ لَامِيٻٜ دُوٻِ 40؞ ");
INSERT INTO fuv_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","ندٜ جٛومِرَاوٛ جِڤِّنِ شَاوُلُ دٛوْ لَامُ، اٛ لَمْنِ دَوْدَ؞ دٛوْ دَوْدَ اٛنْ بٛو اٛ وِعِ، ‏‹‏مِ يِعِي دَوْدَ ٻِي جٜىٰسِ، اٛ نٜطّٛ ڤُکَّنِيطٛيَمْ تٛ ٻٜرْندٜ، غَطَيْطٛ کٛ نغِطْمِ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","دَغَ ندٜرْ لٜݧٛلْ دَوْدَ اٛنْ اَللَّه وُرْتِنِ يٜىٰسُ، کِسْنٛووٛ اِسْرَاعِيلَ نٛنْ نٛ اٛ وَارُنٛو اَلْکَوَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","ندٜنْ کٛ يٜىٰسُ فُطَّ کُوغَلْ مُوطُمْ، يَحَيَ وَعَجِنَنِي لٜݧٛلْ اِسْرَاعِيلَ فُو ٻٜ تُوبَ، ٻٜ نغَطَنٜىٰ بَڤْتِسْمَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","ندٜ يَحَيَ ٻَدِي حٜىٰݧُکِ کُوغَلْ مُوطُمْ، اٛ وِعِ، ‏‹‏مِنْ نَاع طُمْ اٛنْ طٛنْ مٛ کَمِّيطٛنْ؞ اَمَّا اٜ وٛودِ غَرَيْطٛ غَطَ اَمْ، مٛ مِ فٛتَايِ فِتُّکِ کٛو ٻٛغِّ ڤَطٜ مَاکٛ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","‏«‏اٛنٛنْ بَنْدِرَاٻٜ اَمْ، لٜݧٛلْ اِبْرَاهِمْ، اٜ اٛنٛنْ کُلٛوٻٜ اَللَّه وٛنْٻٜ ندٜرْ مٜىٰطٜنْ!‏ اٜنٜنْ طُمْ وَدَّنِ حَبَرُ کِسْندَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","وٛنْٻٜ اُرُشَلِيمَ اٜ مَوْٻٜ مَٻّٜ فُو اَنْدِتَايِ يٜىٰسُ اٛ مٛيٜ؞ ٻٜ ڤَامَايِ بٛلِيطٜ اَنَّبٛعٜنْ جَنْغٜتٜىٰطٜ ݧَلْندٜ سِوْتَارٜ فُو ندٜرْ شُوطِ دٛعَارٜ؞ اَمَّا فُو اٜ نٛنْ، ٻٜ کٜبِّنِ کٛ اَنَّبٛعٜنْ ٻٜنْ مبِعِ ندٜ ٻٜ مبَرِ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","کٛو ندٜ ٻٜ کٜٻَايِ دَلِيلَ وَطَنْکِمٛ کِيتَ مَيْدٜ، فُو اٜ نٛنْ ٻٜ تٛرَکٜ بِلَاتُسْ وَرَمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","ندٜنْ غَطَ ٻٜ کٜبِّنِي کٛ دٜفْتٜرٜ وِعِ دٛوْ مَاکٛ فُو، ٻٜ نجِڤِّنِ ٻَنْدُ مَاکٛ دَغَ دٛوْ غَافَانغَلْ، ٻٜ نغَطِندُ ندٜرْ يٜنَاندٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","اَمَّا اَللَّه اُمِّنِيمٛ دَغَ مَيْدٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","بَلْطٜ طُطّٜ اٜ مٛ وَنْغَنَ وٛنْدُنٛوٻٜ اٜ مَاکٛ، تٛکُّٻٜمٛ دَغَ لٜيْدِ غَلِيلِ يَاکِ اُرُشَلِيمَ؞ جٛونِ کَمْٻٜ ٻٜ نغَرْتِي اَنْدِنٛوٻٜمٛ يٜىٰسٛ يِمْٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","مِنْ نغَدَّنِيعٛنْ حَبَرُ بٜلْطُمْ طُمْ اَللَّه وَطَنّٛو مَامَعٜنْ مٜىٰطٜنْ اَلْکَوَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","اَللَّه حٜبِّنَنِيعٜنْ اَلْکَوَلْ نغَلْ، اٜنٜنْ ٻِٻّٜ مَٻّٜ، ندٜ اٛ اُمِّنِ يٜىٰسُ دَغَ مَيْدٜ؞ کَدِمَا نٛنْ نٛ طُمْ وِنْدِرَا ندٜرْ دٜفْتٜرٜ جَبُورَ سُورَوٛلْ طِطَٻٛلْ وِعُکِ، ‏‹‏اَنْ، اَ ٻِطّٛ اَمْ، حَنْدٜ مِ وَرْتِي ݧَاکٛ مَاطَ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","اَللَّه اُمِّنِي يٜىٰسُ دَغَ مَيْدٜ اٛ اَلَتَا ٻَنْدُ مَاکٛ ݧٛلَ ندٜرْ يٜنَاندٜ؞ نٛنْ نٛ اٛ وِعُنٛو:‏ ‏‹‏مِ حٛکَّيْعٛنْ بَرْکَ شٜنِيطُمْ تَبِّتَيْطُمْ، طُمْ نغَطَنْمِ دَوْدَ اَلْکَوَلْ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","کَدِمَا بَنْݧٜ ندٜرْ جَبُورَ وِعِ، ‏‹‏اَ اَلَتَا شٜنِيطٛ مَاطَ ݧٛلَ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","دَوْدَ حُوِي کٛ اَللَّه يِطِ ندٜرْ جَامَنُ مُوطُمْ؞ غَطَ مَاجُمْ اٛ مَايِ، اٛ اُوَا حَادٜ مَامَعٜنْ مَاکٛ، اٛ ݧٛلِي؞ ");
INSERT INTO fuv_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","اَمَّا مٛ اَللَّه اُمِّنِ دَغَ مَيْدٜ ݧٛلَايِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","بَنْدِرَاٻٜ اَمْ، سٜيْ اَنْدٛنْ اٜ مِنْ نغَعَجِنَنَعٛنْ حَبَرُ يَافَنٜىٰکِ حَکّٜ بَرْکَ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","کٛولِيطٛمٛ فُو، اٛ رِمْطِنَيْمٛ دَغَ حَکّٜ طُمْ اَتَّوْرَ وَاوَايِ رِمْطِنْکِطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","نغَمْ مَاجُمْ، ڤَامٜىٰ تٛع کٛ اَنَّبٛعٜنْ مبِعِ حٜٻَعٛنْ؞ نغَمْ ٻٜ مبِعِي، ");
INSERT INTO fuv_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‏‹‏رَطُّمْ، اٛنٛنْ يَوَنْٻٜ کُوطٜ جٛومِرَاوٛ، اٛنْ کَيْطِنَيْ، اٛنْ کَلْکَيْ!‏ نغَمْ مِ وَطَيْ غٛطُّمْ ندٜرْ جَامَنُ مٛوطٛنْ، طُمْ اٛنْ نجَٻَتَا کٛو دَا غٛطّٛ فَمْتِنِيعٛنْطُمْ!‏›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","تٛو، بُلُسْ اٜ بَرْنَبَ اٜ مبُرْتٛو سُودُ دٛعَارٜ ندُنْ، سٜيْ يِمْٻٜ تٛرِيٻٜ ٻٜ شٛعّٛيٛو ݧَلْندٜ سِوْتَارٜ وَرَيْندٜ، ٻٜ ٻٜيْدَ مٜتَنْکِٻٜ حَالَ کَنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","غَطَ يِمْٻٜ ٻٜنْ شَنْکِتَکٜ، يَحُودَنْکٛعٜنْ طُطْٻٜ اٜ نَتُّٻٜ ندٜرْ دِينَ مَٻّٜ تٛکِّ بُلُسْ اٜ بَرْنَبَ؞ کَمْٻٜ بٛو ٻٜ مٜتَنِٻٜ، اٜ ٻٜ شٜمْبِطِنَٻٜ ٻٜ نغَطَ کَ تٛکُّکِ اَللَّه نغَمْ ندٜرْ يِدّٜ مَاکٛ اٛ وَلَّٻٜ ٻٜ نغَطَ کٛ اٛ يِطِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","ندٜ ݧَلْندٜ سِوْتَارٜ يَلْتِ، ٻُرْٻٜ طُوطُکِ ندٜرْ غَرِيرِ ندِنْ نغَرِ نغَمْ نَنُکِ وٛلْدٜ جٛومِرَاوٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","اَمَّا ندٜ يَحُودَنْکٛعٜنْ نغِعِ مٛٻْدٜ يِمْٻٜ طُطْٻٜ، ٻٜ نَنِ لَوْلِيرُ، ٻٜ نغَطِ کَ يٜدُّکِ کٛ بُلُسْ اٜکِّتِنْتَ، اٜ ٻٜ کُطَمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","اَمَّا بُلُسْ اٜ بَرْنَبَ مٜتَنِٻٜ کُلٛلْ وَلَا مبِعِ، ‏«‏دٛولٜ مِنْ اَرْتَ وَعَجِنَنْکِعٛنْ وٛلْدٜ اَللَّه اٛنٛنْ يَحُودَنْکٛعٜنْ؞ اَمَّا نغَمْ اٛنْ شَلَکٜندٜ، اٛنْ کٛلِّي اٛنْ ڤٛتَايِ حٜٻُکِ يٛنْکِ کِ رٜعَتَا؞ نغَمْ نٛنْ مِنْ نجَحَيْ تٛ لٜپِّ طِ نَاع يَحُودَنْکٛعٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","نغَمْ کَنْجُمْ وٛنِ کٛ جٛومِرَاوٛ وِعِ مِنْ نغَطَ، ندٜ اٛ وِعِ، ‏‹‏مِ وَطِيمَ نغَرْتَا جَيْنغٛلْ تٛ لٜپِّ نَاع يَحُودَنْکٛعٜنْ، نغَمْ نغَدَّنَا دُونِيَارُ فُو کِسْندَمْ؞›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","ندٜ يِمْٻٜ نَاع يَحُودَنْکٛعٜنْ نَنِ نٛنْ، ٻٜ نَنِ بٜلْطُمْ، ٻٜ تٜدِّنِ وٛلْدٜ جٛومِرَاوٛ؞ ندٜنْ ٻٜنْ طٛنْ ٻٜ اَللَّه سِرْيَنِي حٜٻُکِ يٛنْکِ کِ رٜعَتَا تٛکِّ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","وٛلْدٜ جٛومِرَاوٛ بٛو سَنْکِتِي کٛو تٛيٜ ندٜرْ لٜيْدِ ندِنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","اَمَّا اَرْدِيٻٜ يَحُودَنْکٛعٜنْ نغَطِ رٜوْٻٜ کُلٛوٻٜ اَللَّه ٻٜ طُمْ مَوْنِنْتَ، اٜ اَرْدِيٻٜ غَرِيرِ ندِنْ نغَݧَ بُلُسْ اٜ بَرْنَبَ، سٜيْ ٻٜ نغَطِ طُمْ فُطِّ تٛرُّکِ بُلُسْ اٜ بَرْنَبَ، ٻٜ ندِيوِٻٜ دَغَ ندٜرْ غَرِيرِ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","نغَمْ نٛنْ بُلُسْ اٜ بَرْنَبَ ڤِطِّ سٛلَّارٜ ڤَطٜ مَٻّٜ نغَمْ حٛلُّکِ يِمْٻٜ ٻٜنْ نغَطِي حَکّٜ، ندٜنْ ٻٜ ندِلِّ غَرِيرِ اِکٛونِيَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","اَمَّا تٛکُّٻٜ يٜىٰسُ وٛنْٻٜ اَنْتَاکِيَ نَنِ بٜلْطُمْ نَاع سٜطَّ، اٜ ٻٜ کٜىٰوِ رُوحُ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","تٛو، ندٜ بُلُسْ اٜ بَرْنَبَ نجٛتِّي اِکٛونِيَ، ٻٜ نَتِّ ندٜرْ سُودُ دٛعَارٜ نٛنْ نٛ ٻٜ مبٛووِ وَطُکِ؞ ٻٜ نغَعَجِنِ حَا طُطْٻٜ ندٜرْ يَحُودَنْکٛعٜنْ اٜ غٛطِّ لٜپِّ کٛولِي يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","اَمَّا يَحُودَنْکٛعٜنْ غَݧُٻٜ کٛولٛو يٜىٰسُ اُمِّنِ ٻٜرْطٜ يِمْٻٜ نَاع يَحُودَنْکٛعٜنْ نغَمْ ٻٜ نغَݧَ تٛکُّٻٜ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","فُو اٜ نٛنْ بُلُسْ اٜ بَرْنَبَ نٜىٰٻِ تٛنْ، اٜ ٻٜ نغَعَجِنَ ٻٜرْندٜ غٛعٛ دٛوْ جٛومِرَاوٛ کٛلُّطٛ کٛ ٻٜ نغَعَجِنْتَ طُمْ غٛونغَ ندٜ اٛ حٛکِّٻٜ بَوْطٜ وَطُکِ اَلَامَاجِ اٜ کُوطٜ کَيْطِنِيطٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","اَمَّا يِمْٻٜ اِکٛونِيَ شٜنْدِي طِطِ؞ وٛٻّٜ تٛکِّ يَحُودَنْکٛعٜنْ، وٛٻّٜ بٛو تٛکِّ لِلَاٻٜ ٻٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","سٜيْ يِمْٻٜ نَاع يَحُودَنْکٛعٜنْ اٜ يَحُودَنْکٛعٜنْ اٜ اَرْدِيٻٜ مَٻّٜ فُو ٻٜ کَوْتِ حٛنْدُکٛ ٻٜ اُمَّنٛو لِلَاٻٜ ٻٜ کُبٛرٛوٻٜ اٜ کَاپٜ حَا ٻٜ مبَرَٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","ندٜ لِلَاٻٜ ٻٜنْ نَنِ نٛنْ، سٜيْ ٻٜ ندٛغِّ يَاکِ غَرِيرِ لِسْتِرَ اٜ غَرِيرِ دَرْبٜ ندٜرْ لٜيْدِ لِکٛونِيَ، اٜ لَدّٜ غَرِيجٜ طٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","تٛنْ ٻٜ نغَعَجِنِ حَبَرُ بٜلْطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","ندٜرْ غَرِيرِ لِسْتِرَ اٜ وٛودِ غٛطّٛ جَرَاطٛ؞ دَغَ اٛ دَݧَا اٛ مٜىٰطَايِ دَرٛرَاکِ کٛيْطٜ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","وٛنْدٜ ݧَلْندٜ اٜ مٛ حٜتِّندَنٛو وَعَجِنْکِ بُلُسْ، سٜيْ بُلُسْ سُتِيمٛ، يِعِ اٜ مٛ وٛودِ حٛولَارٜ کٜوْتُندٜ اٛ يَمْطِتِنٜىٰ؞ ");
INSERT INTO fuv_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","سٜيْ اٛ وِعِ اٜ سٜمْبٜ، ‏«‏اُمَّ ندَرٛطَا!‏»‏ طٛنْ اٜ طٛنْ نٜطّٛ اٛنْ اُمِّي فُطِّ يَادُ؞ ");
INSERT INTO fuv_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","ندٜ يِمْٻٜ حَوْرُتُٻٜ نغِعِ کٛ بُلُسْ وَطِ، ٻٜ مبِعِ سٜمْبٜىٰ ندٜرْ طٜمْنغَلْ مَٻّٜ نغَلْ لِکٛونِيَارٜ، ‏«‏اَلَّاجِ نجِڤَّنَکٜعٜنْ ندٜرْ نَنْدِ يِمْٻٜ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","ٻٜ نٛدِّرِ بَرْنَبَ جٜىٰوُسْ، ٻٜ نٛدِّرِ بُلُسْ حٜرْمٜسْ، نغَمْ کَنْکٛ وٛنِ ٻُرْطٛ مٜتُکِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","وُرٛ تٛ طُمْ مَوْنِنْتَ اَلَّح مَٻّٜ بِعٜتٜىٰطُمْ جٜىٰوُسْ تٛ دَمُّغَلْ غَرِيرِ ندِنْ نغٛ وٛنِ؞ سٜيْ اَرْدِيطٛ دِينَ جٜىٰوُسْ وَدِّ غَعِ اٜ ڤِنْدِ تٛ دَمُّغَلْ نغَلْ؞ کَنْکٛ اٜ حَوْرُتُٻٜ طُطْٻٜ اٜ ٻٜ نغِطِ سَکَّنْکِ لِلَاٻٜ ٻٜنْ شَکِّرِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","اَمَّا ندٜ بَرْنَبَ اٜ بُلُسْ نَنِ نٛنْ، ٻٜ شٜىٰکِ کٛلْتٜ مَٻّٜ نغَمْ ٻٜ نغَنِّي؞ ٻٜ کَٻْتِي ٻٜ نَتِّ ندٜرْ يِمْٻٜ ٻٜنْ، ٻٜ مبِعِ اٜ سٜمْبٜ، ");
INSERT INTO fuv_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","‏«‏نغَمْ طُمٜ نغَطٛتٛنْ نِحِ؟ مِنٛنْ يِمْٻٜ بٛ مٛوطٛنْ؞ اٜ مِنْ نغَعَجِنَنَعٛنْ حَبَرُ بٜلْطُمْ نغَمْ تُوبٛنْ، اَلٛنْ طٜعٜ کُوطٜ مٜىٰرٜ، نغَيْلِتٛيٛوطٛنْ تٛ اَللَّه مٛ يٛنْکِ، تَغُطٛ دٛوْ اٜ لٜيْ اٜ مَايٛ اٜ کٛ وٛنِ ندٜرْ مَاجُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","ندٜرْ جَامَنُوجِ پَٻِّيطِ اَللَّه اَلِي لٜپِّ دُونِيَارُ فُو تٛکَّ طَتٜ طٜ نغِطِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","فُو اٜ نٛنْ، اٛ اَلَايِ حٛلُّکِ يِمْٻٜ حٛورٜ مَاکٛ ندٜرْ کُوطٜ بٛطّٜ طٜ اٛ وَطَتَ؞ اٜ مٛ حٛکَّعٛنْ ندِيَمْ دَغَ دٛوْ، اٜ مٛ ٻٜنْدِنَنَعٛنْ غٜسٜ ندٜرْ شَرٜلْ کَانُنغٜلْ، اٜ مٛ حٛکَّعٛنْ ݧَمْندُ، اٜ مٛ وٜلْنَ ٻٜرْطٜ مٛوطٛنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","اَمَّا فُو اٜ بٛلِيطٜ طٜعٜ، لِلَاٻٜ ٻٜنْ تٛرَّکٜ کٛ کَطَ يِمْٻٜ ٻٜنْ حِرْسَنْکِٻٜ شَکِّرِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","غَطَ مَاجُمْ يَحُودَنْکٛعٜنْ نغَرِ دَغَ اَنْتَاکِيَ اٜ اِکٛونِيَ؞ ٻٜ ڤٛوطِ حَکِّيلٛ يِمْٻٜ، حَا ٻٜ کُبٛرِي بُلُسْ اٜ کَاپٜ؞ سٜيْ ٻٜ ندَسِمٛ ٻٜ نجَارِمٛ غَطَ غَرِيرِ، نغَمْ اٜ ٻٜ کَمِّي اٛ مَايِي؞ ");
INSERT INTO fuv_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","اَمَّا ندٜ تٛکُّٻٜ يٜىٰسُ نغَرِ ڤِلِيمٛ، اٛ اُمِّي، اٛ نَتِّ ندٜرْ غَرِيرِ؞ ندٜ فِنِ، اٛ دِلِّدِ اٜ بَرْنَبَ غَرِيرِ دَرْبٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","بُلُسْ اٜ بَرْنَبَ نغَعَجِنِ حَبَرُ بٜلْطُمْ تٛنْ دَرْبٜ، ٻٜ کٜٻِ تٛکُّٻٜ يٜىٰسُ طُطْٻٜ؞ غَطَ مَاجُمْ ٻٜ شٛعِّي لِسْتِرَ اٜ اِکٛونِيَ اٜ اَنْتَاکِيَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","اٜ ٻٜ شٜمْبِطِنَ ٻٜرْطٜ تٛکُّٻٜ يٜىٰسُ، اٜ ٻٜ مبَغِّنَٻٜ ٻٜ ندَرٛو اٜ سٜمْبٜ ندٜرْ تٛکُّکِ يٜىٰسُ؞ ٻٜ مبِعِٻٜ، ‏«‏سٜيْ اٜ تٛرَّاجِ طُطِّ کٜٻٜتٜنْ نَتُّکِ لَامُ اَللَّه؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","ندٜرْ کٛو نغَلٜ کَوْتَلْ تٛکُّٻٜ يٜىٰسُ، ٻٜ شُٻَنِٻٜ مَوْٻٜ؞ ندٜرْ سُومَيٜىٰرٜ اٜ دٛعَارٜ، ٻٜ نغَطِ شُٻَاٻٜ ٻٜنْ ندٜرْ جُنْغٛ جٛومِرَاوٛ مٛ ٻٜ کٛولِي؞ ");
INSERT INTO fuv_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","ندٜ ٻٜ کُولِ لٜيْدِ بِسِيدِيَ، ٻٜ نغَرِ لٜيْدِ بَمْفِيلِيَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","ندٜ ٻٜ نغَعَجِنِ وٛلْدٜ اَللَّه ندٜرْ غَرِيرِ فٜرْغَ، سٜيْ ٻٜ ندِلِّرِ غَرِيرِ اَتَالِيَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","دَغَ تٛنْ ٻٜ نَتِّ کٛمِوَلْ، ٻٜ کٛوتِ اَنْتَاکِيَ، نغَمْ ٻٜ نجٛتِّنِي کُوغَلْ نغَلْ ٻٜ نغِطِ وَطُکِ ندٜرْ يَادُ ندُنْ؞ اَنْتَاکِيَ وٛنِ غَرِيرِ ندِ تٛکُّٻٜ يٜىٰسُ نغٛنِ غَطَنْٻٜٻٜ دٛعَارٜ اَللَّه بَرْکِطِنَٻٜ وَلَّٻٜ ندٜرْ يَادُ ندُنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","ندٜ ٻٜ نجٛتِّي، ٻٜ کَوْرِتِ کَوْتَلْ تٛکُّٻٜ يٜىٰسُ، ٻٜ طِيوِتَنِٻٜ کٛ اَللَّه وَطِ لَاوٛلْ مَٻّٜ، اٜ نٛ اٛ مَٻِّتِرَنِ لٜپِّ طِ نَاع يَحُودَنْکٛعٜنْ دَمُّغَلْ حٛولَاکِ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","ٻٜ مبَالِ بَلْطٜ طُطّٜ تٛنْ ندٜرْ تٛکُّٻٜ يٜىٰسُ ٻٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","سٜيْ وٛٻّٜ يِمْٻٜ پِوٛيِ لٜيْدِ يَحُودِيَ نغَرِ غَرِيرِ اَنْتَاکِيَ، اٜ ٻٜ اٜکِّتِنَ تٛکُّٻٜ يٜىٰسُ، اٜ ٻٜ مبِعَ، ‏«‏تٛ اٛنْ نَادَاکَ نٛنْ نٛ اَتَّوْرَ وِعِ اٛنْ کِسَتَا؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","بُلُسْ اٜ بَرْنَبَ نغٜدّٛوتِرِ اٜ مَٻّٜ غٜدِّ نَوْطِ؞ سٜيْ کٛولِيٻٜ يٜىٰسُ وٛنْٻٜ اَنْتَاکِيَ شُٻِ بُلُسْ اٜ بَرْنَبَ اٜ وٛٻّٜ ندٜرْ مَٻّٜ، ٻٜ لِلِٻٜ اُرُشَلِيمَ نغَمْ ٻٜ مٜدَّ اٜ لِلَاٻٜ اٜ مَوْٻٜ وٛنْٻٜ تٛنْ دٛوْ حَالَ کَنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","سٜيْ تٛکُّٻٜ يٜىٰسُ ٻٜنْ طٛفْتِٻٜ ٻٜ نَنْغِ لَاوٛلْ يَاکِ لٜيْطٜ فِنِيکِيَ اٜ سَمَارِيَ، اٜ ٻٜ کٛکَّ تٛکُّٻٜ يٜىٰسُ حَبَرُ تُوبُکِ يِمْٻٜ نَاع يَحُودَنْکٛعٜنْ؞ تٛکُّٻٜ يٜىٰسُ فُو نَنِ بٜلْطُمْ حَبَرُ طُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","ندٜ ٻٜ نجٛتِّي اُرُشَلِيمَ، کَوْتَلْ تٛکُّٻٜ يٜىٰسُ اٜ لِلَاٻٜ اٜ مَوْٻٜ ٻٜنْ نجَٻِّيٻٜ؞ ندٜنْ بُلُسْ اٜ بَرْنَبَ طِيوِتَنِٻٜ فُو کٛ اَللَّه حُوتِنِرِٻٜ ٻٜ نغَطِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","اَمَّا وٛٻّٜ کٛولِيٻٜ يٜىٰسُ ندٜرْ فَارِسَنْکٛعٜنْ اُمِّي، مبِعِ، ‏«‏دٛولٜ تٛکُّٻٜ يٜىٰسُ نَاع يَحُودَنْکٛعٜنْ نَادٜىٰ، ٻٜ مبِعٜىٰ ٻٜ تٛکَّ کٛ اَتَّوْرَ وِعِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","سٜيْ لِلَاٻٜ اٜ مَوْٻٜ کَوْرِتِ نغَمْ ٻٜ مٜدَّ دٛوْ حَالَ کَنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","ندٜ ٻٜ نٜىٰٻِ اٜ ٻٜ فٛطْفٛطْتِرَ دٛوْ فِي طُمْ، بِيتُرُسْ اُمِّي وِعِٻٜ، ‏«‏بَنْدِرَاٻٜ، اٛنْ اَنْدِ کٛ نٜىٰٻِ اَللَّه سُٻِييَمْ ندٜرْ مٛوطٛنْ مِ وَعَجِنَ حَبَرُ بٜلْطُمْ ندٜرْ لٜپِّ طِ نَاع يَحُودَنْکٛعٜنْ، نغَمْ ٻٜ نَنَ ٻٜ نغَرْتَ تٛکُّٻٜ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","اَللَّه اَنْدُطٛ ٻٜرْطٜ يِمْٻٜ فُو حٛلِّي اٛ جَٻِيٻٜ ندٜ اٛ حٛکِّٻٜ رُوحُ مَاکٛ نٛنْ نٛ اٛ حٛکِّرِعٜنْطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","اٛ فٜىٰرٛوتِرَايِعٜنْ اٜ مَٻّٜ، نغَمْ اٛ يَافَنَکٜٻٜ حَکّٜ ندٜ ٻٜ کٛولِي يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","جٛونِ، نغَمْ طُمٜ ڤٛوندٛتٛنْ اَللَّه اٛنْ نجٛوَنَ تٛکُّٻٜ يٜىٰسُ دٛنْغَلْ نغَلْ اٜنْ مبَاوَايِ رٛنْدَاکِ، اٜنٜنْ اٜ مَامَعٜنْ مٜىٰطٜنْ؟ ");
INSERT INTO fuv_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","اَاعَ!‏ نٛنْ نٛ تٛکِّرْطٜنْ يٜىٰسُ جٛومِرَاوٛ کٜٻْطٜنْ کِسْندَمْ بَرْکَ يِدّٜ مَاکٛ، نٛنْ کَمْٻٜ مَا ٻٜ کِسْرَتَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","حَوْرُتُٻٜ فُو ندٜعِّتِ کٜتِّندَنِي کٛ بَرْنَبَ اٜ بُلُسْ مبِعَتَٻٜ دٛوْ نٛ اَللَّه حُوتِنِرِٻٜ وَطِ اَلَامَاجِ اٜ کُوطٜ کَيْطِنِيطٜ ندٜرْ لٜپِّ طِ نَاع يَحُودَنْکٛعٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","ندٜ ٻٜ کٜىٰݧِ مٜتُکِ، سٜيْ يَاکُبُ وِعِ، ‏«‏بَنْدِرَاٻٜ، نَنٜىٰ کٛ مبِعَيْمِعٛنْ!‏ ");
INSERT INTO fuv_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","جٛونِ سِيمَنْ يٛتِّنِ طِيوِتَنْکِعٜنْ نٛ اَللَّه سُٻِرِ وٛٻّٜ ندٜرْ لٜپِّ طِ نَاع يَحُودَنْکٛعٜنْ، وَرْتِرِٻٜ يِمْٻٜ مُوطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","طُمْ فٛتِّدِي اٜ کٛ اَنَّبٛعٜنْ مبِنْدُنٛو، ٻٜ مبِعِي، ");
INSERT INTO fuv_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‏‹‏اَللَّه وِعِي، ‏«‏غَطَ مَاجُمْ، مِ سٛعّٛيْتٛ، مِ مَحِتٛتٛو وُرٛ دَوْدَ سَنْکِتَانغٛ؞ مِ مَحِتٛونغٛ، مِ دَرْنَنغٛ کَدِمَا، ");
INSERT INTO fuv_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","نغَمْ يِمْٻٜ حٛرِيٻٜ فُو طَٻِّتَ جٛومِرَاوٛ، فُو اٜ يِمْٻٜ نَاع يَحُودَنْکٛعٜنْ نٛدِّرْتٜىٰٻٜ اِنْدٜ اَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","نٛنْ جٛومِرَاوٛ وِعِ، اَنْدِنْطٛ فِي طُعُمْ کٛ نٜىٰٻِ؞»‏ ›‏ ");
INSERT INTO fuv_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","‏«‏تٛو، نغَمْ مَاجُمْ مِنْ اٜ يِيکِ اَمْ، تٛع اٜنْ نغَنُّ يِمْٻٜ نَاع يَحُودَنْکٛعٜنْ نغَيْلِتٛيِيٻٜ تٛ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","اٜنْ مبِنْدَنْٻٜ طٜرٜوٛلْ تٛع ٻٜ ݧَامَ ݧَمْندُ حَرْمِنِيندُ ندُ طُمْ حِرْسَنِ اَلَّاجِ، تٛع ٻٜ نغَطَ نجٜىٰنُ، تٛع ٻٜ ݧَامَ کٛ مٛيْلَنَا دَاندٜ کٛو کٛ سَاطِ کٛو پِيپَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","نغَمْ کٛ نٜىٰٻِ اٜ طُمْ وَعَجِنَ اَتَّوْرَ اٜ کٛو ندِيٜ غَرِيرِ، اٜ طُمْ جَنْغَطُمْ کٛو ندٜيٜ ݧَلْندٜ سِوْتَارٜ ندٜرْ شُوطِ دٛعَارٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","سٜيْ لِلَاٻٜ اٜ مَوْٻٜ اٜ کَوْتَلْ تٛکُّٻٜ يٜىٰسُ فُو ندَرْوِ سُٻُکِ وٛٻّٜ دَغَ ندٜرْ مَٻّٜ نغَمْ ٻٜ لِلَٻٜ غَرِيرِ اَنْتَاکِيَ، ٻٜ نجَادَ اٜ بُلُسْ اٜ بَرْنَبَ؞ ٻٜ شُٻِ مَوْٻٜ طِطٛ ندٜرْ مَٻّٜ:‏ يَحُودَ، بِعٜتٜىٰطٛ بَرْسَبَ، اٜ سِيلَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","ٻٜ کٛکِّٻٜ طٜرٜوٛلْ بِينغٛلْ:‏ ‏«‏دَغَ بَنْدِرَاٻٜ مٛوطٛنْ لِلَاٻٜ اٜ مَوْٻٜ، اٜ مِنْ کٛوْنَعٛنْ، اٛنٛنْ بَنْدِرَاٻٜ اَمِنْ دَغَ غٛطِّ لٜپِّ غٛنْطِ ندٜرْ غَرِيرِ اَنْتَاکِيَ اٜ ندٜرْ لٜيْطٜ سِيرِيَ اٜ کِلِيکِيَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","مِنْ نَنِي حَبَرُ وٛٻّٜ ندٜرْ اَمِنْ اُمِّنَنِيعٛنْ حَکِّيلٛ اٜ مٜتٜمٜتٜىٰجِ مَٻّٜ اٜ ٻٜ نغَنَّعٛنْ، کٛو ندٜ نَاع مِنٛنْ لِلِٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","کَنْجُمْ وَطِ مِنْ کَوْرِتِ کٛعٜ اَمِنْ مِنْ ندَرْوِ سُٻُکِ وٛٻّٜ ندٜرْ اَمِنْ مِنْ لِلٛيَٻٜ تٛ مٛوطٛنْ، حَوْتِ اٜ بَرْنَبَ اٜ بُلُسْ حِغٛوٻٜ اَمِنْ، ");
INSERT INTO fuv_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","شٛورُٻٜ يٛنْکِيجِ مَٻّٜ نغَمْ حُوَنْکِ جٛومِرَاوٛ مٜىٰطٜنْ يٜىٰسُ اَلْمَسِيحُ؞ ");
INSERT INTO fuv_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","نغَمْ نٛنْ مِنْ لِلٛيِ يَحُودَ اٜ سِيلَ ٻٜ مٜدَّ اٜ مٛوطٛنْ حٛنْدُکٛ اٜ حٛنْدُکٛ دٛوْ کٛ مِنْ مبِنْدَنِعٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","طُمْ دَرْوُکِ رُوحُ اَللَّه اٜ اَمِنْ، تٛع مِنْ نجٛوَنَعٛنْ وٛنْغَلْ تٜدّٛرَلْ، سٜيْ نِ طُعُمْ نَنْغُطُمْ دٛولٜ:‏ ");
INSERT INTO fuv_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","تٛع اٛنْ ݧَامُ کٛ طُمْ سَکَّنِ غُنْکِيجِ کٛو کٛ سَاطِ کٛو کٛ طُمْ مٛيْلَنِ دَاندٜ کٛو پِيپَمْ، ندٜنْ تٛع اٛنْ نغَطُ نجٜىٰنُ؞ تٛ اٛنْ شُرِي کٛعٜ مٛوطٛنْ اٜ وَطُکِ فِي طُعُمْ اٛنْ نغَطِي بٛطُّمْ؞ اَللَّه وَلَّعٜنْ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","سٜيْ ٻٜ لِلِٻٜ يَاکِ اَنْتَاکِيَ؞ ندٜ ٻٜ نجٛتِّي تٛنْ، ٻٜ کَوْرِتِ تٛکُّٻٜ يٜىٰسُ، ٻٜ کٛکِّٻٜ طٜرٜوٛلْ نغٛلْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","ندٜ تٛکُّٻٜ يٜىٰسُ وٛنْٻٜ اَنْتَاکِيَ نجَنْغِنغٛلْ، ٻٜ نَنِ بٜلْطُمْ نغَمْ نغٛلْ سٜمْبِطِنِيٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","ندٜ يَحُودَ اٜ سِيلَ ٻٜ اَنَّبٛعٜنْ، ٻٜ شٜمْبِطِنِ ٻٜرْطٜ تٛکُّٻٜ يٜىٰسُ، ٻٜ مبَغِّنِٻٜ دٛوْ فِي طُطُّمْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","غَطَ ٻٜ مبَالِي بَلْطٜ تٛنْ، ٻٜ طٛفْتَا ٻٜ مبَرْکِطِنِٻٜ، ٻٜ شٛعِّي تٛ لِلٛيْٻٜٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","‏‏اَمَّا سِيلَ جٛوطِي طٛنْ؞‏ ");
INSERT INTO fuv_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","بُلُسْ اٜ بَرْنَبَ بٛو نجٛوطِي ندٜرْ اَنْتَاکِيَ اٜ يِمْٻٜ طُطْٻٜ اٜ ٻٜ اٜکِّتِنَ، اٜ ٻٜ نغَعَجِنَ وٛلْدٜ جٛومِرَاوٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","غَطَ بَلْطٜ سٜطَّ بُلُسْ وِعِ بَرْنَبَ، ‏«‏اٜنْ شٛعّٛ غَرِيجٜ تٛ نغَعَجِنّٛوطٜنْ وٛلْدٜ جٛومِرَاوٛ، ندَارٜنْ نٛ تٛکُّٻٜ يٜىٰسُ نغٛنْتِندِرِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","بَرْنَبَ اٜ يِطِ ٻٜ نجَادَ اٜ يَحَيَ بِعٜتٜىٰطٛ مَرْکُسْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","اَمَّا بُلُسْ يِعِ طُمْ حَانَايِ، نغَمْ مَرْکُسْ سٜنْدِرِينٛ اٜ مَٻّٜ اٜ لٜيْدِ بَمْفِيلِيَ، اٛ حٜىٰݧَايِ کُوغَلْ نغَلْ اٛ فُطِّدِ اٜ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","ٻٜ نغٜدّٛوتِرِ نَاع سٜطَّ حَا غٜدِّ طِنْ نجَارِٻٜ اٜ سٜنْدِرْکِ؞ بَرْنَبَ حٛشِّ مَرْکُسْ، ٻٜ نَتِّ کٛمِوَلْ يَاکِ سَيِيفُرُسْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","اَمَّا بُلُسْ سُٻِ سِيلَ، دِلِّدِ اٜ مَاکٛ؞ تٛکُّٻٜ يٜىٰسُ نغَطِٻٜ ندٜرْ جُنْغٛ جٛومِرَاوٛ نغَمْ اٛ رٜىٰنَٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","سٜيْ ٻٜ تٛکِّ ندٜرْ لٜيْطٜ سِيرِيَ اٜ کِلِيکِيَ، اٜ ٻٜ شٜمْبِطِنَ تٛکُّٻٜ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","بُلُسْ يَحِ غَرِيرِ دَرْبٜ اٜ غَرِيرِ لِسْتِرَ؞ تٛ لِسْتِرَ بٛو اٜ وٛودِ غٛطّٛ کٛولِيطٛ يٜىٰسُ بِعٜتٜىٰطٛ تِمٛوتِ؞ مَدُوجٛ مَاکٛ نٛ يَحُودَنْکٜىٰجٛ تٛکُّطٛ يٜىٰسُ، ݧَاکٛ مَاکٛ بٛو نٛ حٜلٜنَنْکٜىٰجٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","تٛکُّٻٜ يٜىٰسُ وٛنْٻٜ لِسْتِرَ اٜ اِکٛونِيَ اٜ مٜتَ حَالَ مبٛطْکَ دٛوْ تِمٛوتِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","بُلُسْ اٜ يِطِ يَادُکِ اٜ مَاکٛ، نغَمْ مَاجُمْ اٛ نَادِمٛ؛ نغَمْ يَحُودَنْکٛعٜنْ وٛنْٻٜ بِغٜىٰجٜ طٜنْ فُو اٜ اَنْدِ ݧَاکٛ تِمٛوتِ نٛ حٜلٜنَنْکٜىٰجٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","غَرِيجٜ تٛ ٻٜ نجَالِ فُو، اٜ ٻٜ مبِعَ تٛکُّٻٜ يٜىٰسُ کٛ لِلَاٻٜ اٜ مَوْٻٜ وٛنْٻٜ اُرُشَلِيمَ ندَرْنِ نغَمْ ٻٜ تٛکَّطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","نٛنْ تٛکُّٻٜ يٜىٰسُ ٻٜيْدِ سٜمْبٜ ندٜرْ حٛولَاکِ يٜىٰسُ، اٜ ٻٜ ٻٜيْدَ طُوطُکِ کٛو ندٜيٜ ݧَلْندٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","رُوحُ اَللَّه حَطِٻٜ وَعَجِنْکِ وٛلْدٜ اَللَّه ندٜرْ لٜيْدِ اَاسِيَ، نغَمْ نٛنْ ٻٜ ندِلِّ لٜيْطٜ فِرِيجِيَ اٜ غَلَاتِيَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","ندٜ ٻٜ نغَرِ کٜىٰرٛلْ لٜيْدِ مِيسِيَ، ٻٜ نغِطِي يَاکِ لٜيْدِ بِتِينِيَ، اَمَّا رُوحُ يٜىٰسُ، وَاتٛ رُوحُ اَللَّه، جَٻَايِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","نغَمْ مَاجُمْ، ٻٜ تٛکِّرِ ندٜرْ لٜيْدِ مِيسِيَ، ٻٜ نجَحِ غَرِيرِ بِعٜتٜىٰندِ تٛورُوَسْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","ندٜرْ جٜمَّارٜ ندٜنْ بُلُسْ حٛيْطِ؞ اٛ يِعِي نٜطّٛ مَکِدٛونِيَ اٜ دَرِي اٜ تٛرٛومٛ اٜ وِعَ، ‏«‏وٛرٛيْ مَکِدٛونِيَ، مبَلَّامِنْ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","ندٜ بُلُسْ حٛيْطِ کٛيْطٛلْ نغٛلْ، طٛنْ اٜ طٛنْ مِنْ ندَرْوِ يَاکِ مَکِدٛونِيَ، نغَمْ مِنْ اَنْدِتِي اَللَّه نٛدِّيمِنْ مِنْ نغَعَجِنَنَٻٜ حَبَرُ بٜلْطُمْ کَمْٻٜ مَا؞ ");
INSERT INTO fuv_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","مِنْ نَتِّ کٛمِوَلْ اٜ تٛورُوَسْ، مِنْ نجَحِ حَا سَمُتَرْکِيَ؞ ندٜ فِنِ مِنْ نجَحِ نِيَافٛلِسْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","دَغَ طٛنْ مِنْ نجَحِ فِلِبِ، غَرِيرِ مَوْندِ ندٜرْ لٜيْدِ مَکِدٛونِيَ نغٛنْدِ لٜيْ لَامُ رٛومَنْکٛعٜنْ؞ مِنْ مبَالِ بَلْطٜ تٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","ݧَلْندٜ سِوْتَارٜ، مِنْ مبُرْتِي غَرِيرِ ندِنْ مِنْ نجَحِ رٜغٛرْدٜ شَانغٛلْ، نغَمْ اٜ مِنْ کَمِّي اٜ وٛودِ وِغٜىٰرٜ تٛ يَحُودَنْکٛعٜنْ نغَطَتَ دٛعَارٜ تٛنْ؞ تٛنْ مِنْ تَوِ رٜوْٻٜ اٜ کَوْرِتِ؞ مِنْ نجٛوطِي، اٜ مِنْ مٜدَّ اٜ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","ندٜرْ مَٻّٜ اٜ وٛودِ غٛطّٛ دٜبّٛ بِعٜتٜىٰطٛ لِيدِيَ، پِوٛيْطٛ غَرِيرِ تَيَاتِرَ کُلٛووٛ اَللَّه؞ اٜ مٛ سٛورَ کٛلْتٜ بٛطٜىٰجٜ طٜ شٜىٰدٜ؞ جٛومِرَاوٛ مَٻِّتِ ٻٜرْندٜ مَاکٛ اٛ حٜتِّندَنِي کٛ بُلُسْ وِعَتَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","غَطَ کَنْکٛ اٜ وُرٛ مَاکٛ فُو ٻٜ نغَطَنَامَ بَڤْتِسْمَ، سٜيْ اٛ تٛرِيمِنْ، اٛ وِعِ، ‏«‏تٛ اٛنْ جَٻِي مِ کٛولِيطٛ جٛومِرَاوٛ اٜ غٛونغَ، نغَرٜىٰ نجٛوطٛوطٛنْ تٛ وُرٛ اَمْ؞»‏ اٛ اٜسْتِمِنْ مِنْ نجِڤّٛو تٛ مَاکٛ، سٜيْ مِنْ نجِڤِّي؞ ");
INSERT INTO fuv_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","وٛنْدٜ ݧَلْندٜ اٜ مِنْ نجَحَ تٛ طُمْ وَطَتَ دٛعَارٜ، سٜيْ مِنْ کَوْرِ اٜ غٛطّٛ کٛرْطٛ؞ کٛرْطٛ اٛنْ اٛ دَرْنٛووٛ، اٜ مٛ حٜٻَنَ جٜيْٻٜمٛ شٜىٰدٜ طُطّٜ اٜ کُوغَلْ مَاکٛ نغَلْ رَرْنُکِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","سٜيْ اٛ وَطِ کَ تٛکُّکِمِنْ، مِنٛنْ اٜ بُلُسْ، اٜ مٛ وُلَّ، اٜ مٛ وِعَ، ‏«‏يِمْٻٜ ٻٜعٜ ٻٜ کُوَنٛوٻٜ اَللَّه مَوْطٛ!‏ اٜ ٻٜ اَنْدِنَعٛنْ لَاوٛلْ کِسْندَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","اٛ وَطِ بَلْطٜ طُطّٜ اٜ مٛ وَطَ نٛنْ حَا بُلُسْ ٻٜرْنِ، يٜىٰپِيمٛ، وِعِ غِنّٛلْ نغٛلْ، ‏«‏ندٜرْ اِنْدٜ يٜىٰسُ اَلْمَسِيحُ، اٜ مِ وِعِمَا وُرْتَ ندٜرْ مَاکٛ!‏»‏ طٛنْ اٜ طٛنْ غِنّٛلْ نغٛلْ وُرْتِيمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","ندٜ جٛومِرَاٻٜ مَاکٛ نغِعِ لَاوٛلْ حٜٻُکِ شٜىٰدٜ مَٻّٜ تٛ کٛرْطٛ اٛنْ دَرَکٜ، ٻٜ نَنْغِ بُلُسْ اٜ سِيلَ، ٻٜ ندَسِٻٜ ٻٜ نجَارِيٻٜ لُومٛ، تٛنْ تٛ مَوْٻٜ غَرِيرِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","ٻٜ نجَارِٻٜ يٜىٰسٛ مَوْٻٜ غَرِيرِ ندِنْ، ٻٜ مبِعِ، ‏«‏ٻٜعٜ يِمْٻٜ طِطٛ ٻٜ يَحُودَنْکٛعٜنْ، اٜ ٻٜ اُمِّنَ حَکِّيلٛ يِمْٻٜ غَرِيرِ مٜىٰطٜنْ نَاع سٜطَّ؞ ");
INSERT INTO fuv_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","اٜ ٻٜ اٜکِّتِنَ ندٛنُوجِ طِ حَانَا نجَٻٜنْ کٛو تٛکّٜنْ، نغَمْ اٜنٜنْ اٜنْ رٛومَنْکٛعٜنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","يِمْٻٜ طُطْٻٜ کَوْرِتِ دٛوْ مَٻّٜ؞ مَوْٻٜ غَرِيرِ نغَطِ طُمْ ٻٛرْتِٻٜ طُمْ فِيِٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","غَطَ ٻٜ ڤِيَامَ ڤِيطٜ کَلُّطٜ، ٻٜ مَٻَّا ندٜرْ سُودُ شُرَلْ؞ مَوْٻٜ ٻٜنْ مبِعِ دٜىٰنٛووٛ سُودُ شُرَلْ رٜىٰنَٻٜ بٛطُّمْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","کَنْکٛ بٛو، ندٜ اٛ نَنِ نٛنْ، اٛ نَتِّنِٻٜ ندٜرْ سُودُ شُرَلْ شَکَارُ، اٛ حَٻِّ کٛيْطٜ مَٻّٜ حَکُّندٜ لٜطّٜ طِطِ مَوْطٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","شَکَ جٜمَّ، بُلُسْ اٜ سِيلَ اٜ ٻٜ نغَطَ دٛعَارٜ اٜ ٻٜ مَنْتَ اَللَّه اٜ غِمِ؞ نَنْغَاٻٜ حٛرِيٻٜ اٜ کٜتِّندَنِي کٛ ٻٜ مبِعَتَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","طٛنْ اٜ طٛنْ لٜيْدِ دِمْبِي دِمْبَاکِ مَوْکِ، حَا فُطّٛودٜ سُودُ شُرَلْ ندُنْ دِمْبِي؞ دَمُّطٜ طٜنْ فُو مَٻِّتِي، ٻٛغِّ نجَمْندِ طِ طُمْ حَٻِّرِ وٛنْٻٜ ندٜرْ سُودُ شُرَلْ ندُنْ فُو تَپِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","ندٜ دٜىٰنٛووٛ سُودُ شُرَلْ اٛنْ حُيْلِي، اٛ يِعِ دَمُّطٜ طٜنْ فُو اٜ مَٻِّتِي، اٛ کَمِّ مَٻَّاٻٜ فُو ندٛغِّي؞ نغَمْ مَاجُمْ اٛ سٛرْتِ کَافَحِ نغَمْ اٛ وَرَ حٛورٜ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","سٜيْ بُلُسْ نٛدِّ اٜ سٜمْبٜ، وِعِ، ‏«‏تَاع وَرُ حٛورٜ مَاطَ؞ مِنْ فُو اٜ مِنْ طٛنْ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","دٜىٰنٛووٛ اٛنْ وِعِ حٛکّٜىٰ فِتِلَارُ، اٛ دٛغِّ اٛ نَتِّ تٛ بُلُسْ اٜ سِيلَ نغٛنِ، اٛ دِشِّي يٜىٰسٛ مَٻّٜ، اٜ مٛ دِوْنَ نغَمْ کُلٛلْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","ندٜنْ اٛ وُرْتِنِٻٜ، اٛ وِعِٻٜ، ‏«‏مٛودِٻّٜ، کٛ نغَطَيْمِ مِ حِسَ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","ٻٜ نٛوتِي ٻٜ مبِعِ، ‏«‏حٛولَ يٜىٰسُ جٛومِرَاوٛ، اَنْ اٜ وُرٛ مَاطَ فُو، اٛنْ کِسَيْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","ٻٜ مٜتَنِمٛ وٛلْدٜ جٛومِرَاوٛ، کَنْکٛ اٜ وُرٛ مَاکٛ فُو؞ ");
INSERT INTO fuv_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","ندٜرْ جٜمَّارٜ ندٜنْ، اٛ وُرْتِنِٻٜ، اٛ لٛوتَنِٻٜ نَوْنٛوطٜ؞ اٜ نغٜلْ طٛنْ شَرٜلْ اٛ وَطَنَا بَڤْتِسْمَ، کَنْکٛ اٜ وُرٛ مَاکٛ فُو؞ ");
INSERT INTO fuv_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","ندٜنْ اٛ يَارِ بُلُسْ اٜ سِيلَ وُرٛ مَاکٛ، اٛ حٛکِّٻٜ ݧَمْندُ؞ کَنْکٛ اٜ وُرٛ مَاکٛ فُو ٻٜ نَنِ بٜلْطُمْ نغَمْ ٻٜ نغَرْتِي کٛولِيٻٜ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","ندٜ وٜىٰتِ، مَوْٻٜ غَرِيرِ ندِنْ لِلٛيِ تَادِيٻٜ مبِعَ دٜىٰنٛووٛ اٛنْ اٛ يٛوفَ بُلُسْ اٜ سِيلَ ندِلَّ؞ ");
INSERT INTO fuv_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","سٜيْ دٜىٰنٛووٛ اٛنْ وِعِ بُلُسْ، ‏«‏مَوْٻٜ لِلٛيِي مبِعِ طُمْ يٛوفَعٛنْ؞ نغَمْ نٛنْ مبُرْتٜىٰ جٛونِ، نجَحٛنْ جَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","اَمَّا بُلُسْ وِعِمٛ، ‏«‏ٻٜ نغَطِي طُمْ فِيِيمِنْ يٜىٰسٛ يِمْٻٜ دَغَ مِنْ نغَطَنَاکَ کِيتَ، ٻٜ مَٻِّيمِنْ ندٜرْ سُودُ شُرَلْ؞ مِنٛنْ بٛو، مِنْ رٛومَنْکٛعٜنْ؞ ندٜنْ جٛونِ ٻٜ مبُرْتِنَمِنْ اٜ سُوطٜ؟ طُمْ وَطَتَاکٛ سَمْ!‏ دٛولٜ کَمْٻٜ اٜ کٛعٜ مَٻّٜ، ٻٜ نغَرَ طٛعٛ ٻٜ مبُرْتِنَمِنْ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","سٜيْ تَادِيٻٜ ٻٜنْ نجَحِ طِيوِتَنِ مَوْٻٜ غَرِيرِ حَالَ کَنْ؞ ندٜ ٻٜ نَنِ بُلُسْ اٜ سِيلَ ٻٜ رٛومَنْکٛعٜنْ، ٻٜ کُلِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","ٻٜ نجَحِ ٻٜ تُوبَنِٻٜ، ٻٜ مبُرْتِنِٻٜ سُودُ شُرَلْ ندُنْ؞ ٻٜ تٛرِيٻٜ ٻٜ مبُرْتٛو غَرِيرِ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","ندٜ بُلُسْ اٜ سِيلَ مبُرْتِي سُودُ شُرَلْ ندُنْ، ٻٜ نَتِّ وُرٛ لِيدِيَ؞ ٻٜ نغِيدِ اٜ تٛکُّٻٜ يٜىٰسُ، ٻٜ شٜمْبِطِنِ ٻٜرْطٜ مَٻّٜ؞ غَطَ مَاجُمْ ٻٜ ندِلِّ؞ ");
INSERT INTO fuv_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","ندٜ بُلُسْ اٜ سِيلَ تٛکِّ لَاوٛلْ تٛکُّنغٛلْ ندٜرْ غَرِيجٜ اَمْڤِبٛلِسْ اٜ اَفٛلٛونِيَ، سٜيْ ٻٜ نغَرِ تَسَلٛونِکَ؞ غَرِيرِ ندِنْ اٜ وٛودِ سُودُ دٛعَارٜ يَحُودَنْکٛعٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","سٜيْ بُلُسْ نَتِّ ندٜرْ سُودُ دٛعَارٜ ندُنْ نٛنْ نٛ اٛ وٛووِ وَطُکِ؞ اٛ وَطِ يٛنْتٛوجٜ تَتِ ݧَلْندٜ سِوْتَارٜ فُو اٜ مٛ نَتَّ سُودُ دٛعَارٜ ندُنْ اٜ مٛ مٜدَّ اٜ مَٻّٜ دٛوْ دٜفْتٜرٜ شٜنِيندٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","اٜ مٛ فَمْتِنَٻٜ اٜ مٛ تَبِّتِنَنَٻٜ ندٜرْ دٜفْتٜرٜ شٜنِيندٜ وِعُکِ دٛولٜ اَلْمَسِيحُ تٛرّٜىٰ، ندٜنْ اٛ اُمّٛو دَغَ مَيْدٜ؞ اٛ وِعِٻٜ، ‏«‏يٜىٰسُ اٛعٛ مٛ نغَعَجِنَنَيْمِعٛنْ حَبَرُ مَاکٛ، کَنْکٛ وٛنِ اَلْمَسِيحُ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","وٛٻّٜ ندٜرْ يَحُودَنْکٛعٜنْ نجَٻِکَ، ٻٜ تٛکِّ بُلُسْ اٜ سِيلَ، کَمْٻٜ اٜ يِمْٻٜ نَاع يَحُودَنْکٛعٜنْ طُطْٻٜ کُلٛوٻٜ اَللَّه، حَوْتِ اٜ رٜوْٻٜ طُطْٻٜ غٛودُٻٜ مَنْغُ؞ ");
INSERT INTO fuv_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","اَمَّا وٛٻّٜ يَحُودَنْکٛعٜنْ ٻٜ کٛولَاکِ يٜىٰسُ نَنِ لَوْلِيرُ بُلُسْ اٜ سِيلَ؞ سٜيْ ٻٜ کَوْرِتِ سُکَحٛ مٜىٰرٜحٛ، نغِيلٛتٛوکٛ ندٜرْ لُومٛ؞ ٻٜ اُمِّنَنِ فُو يِمْٻٜ غَرِيرِ ندِنْ حَکِّيلٛ؞ ٻٜ نَتِّ وُرٛ جَاسٛنْ، اٜ ٻٜ طَٻِّتَ بُلُسْ اٜ سِيلَ نغَمْ ٻٜ نجَارَٻٜ يٜىٰسٛ يِمْٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","ندٜ ٻٜ کٜٻْتَايِ بُلُسْ اٜ سِيلَ، ٻٜ ندَسٛيِ جَاسٛنْ اٜ وٛٻّٜ تٛکُّٻٜ يٜىٰسُ، ٻٜ نغَدِّٻٜ يٜىٰسٛ مَوْٻٜ غَرِيرِ، اٜ ٻٜ مبِعَ اٜ سٜمْبٜ، ‏«‏رَا يِمْٻٜ کَطٛوٻٜ جٛنْدٜ جَمْ کٛو تٛيٜ، رَا ٻٜ نغَرِي حَا طٛعٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","جَاسٛنْ بٛو جِڤِّنِيٻٜ ندٜرْ وُرٛ مُوطُمْ!‏ ٻٜ فُو ٻٜ تٛکَّتَا کٛ کَيْسَرْ لَامِيطٛ وِعِ، اٜ ٻٜ مبِعَ اٜ وٛودِ غٛطّٛ لَامِيطٛ بِعٜتٜىٰطٛ يٜىٰسُ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","ندٜ يِمْٻٜ غَرِيرِ ندِنْ اٜ مَوْٻٜ مَٻّٜ نَنِ نٛنْ، حَکِّيلٛ مَٻّٜ اُمِّي؞ ");
INSERT INTO fuv_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","مَوْٻٜ ٻٜنْ نغَطِ جَاسٛنْ اٜ ٻٜ اٛ نَنْغِدَا نجٛٻِ شٜىٰدٜ، ندٜنْ ٻٜ نجٛوفِٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","ندٜ جٜمَّ وَطِ، تٛکُّٻٜ يٜىٰسُ نغَطِ بُلُسْ اٜ سِيلَ نجَحَ غَرِيرِ بِيرِيَ؞ ندٜ ٻٜ نجٛتِّي غَرِيرِ ندِنْ، ٻٜ نجَحِ سُودُ دٛعَارٜ يَحُودَنْکٛعٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","يِمْٻٜ غَرِيرِ بِيرِيَ ٻُرِي يِمْٻٜ تَسَلٛونِکَ نغِکُّ بٛطُّمْ نغَمْ ٻٜ نجَٻِي حَبَرُ طُمْ بُلُسْ وَدَّنِٻٜ اٜ جُوطٜ طِطِ؞ اٜ ٻٜ لِنْشِتَ دٜفْتٜرٜ شٜنِيندٜ کٛو ندٜيٜ ݧَلْندٜ، نغَمْ ٻٜ نغِعَ کٛو کٛ بُلُسْ اٜکِّتِنْتَٻٜ طُمْ غٛونغَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","يَحُودَنْکٛعٜنْ طُطْٻٜ نجَٻِ وٛلْدٜ جٛومِرَاوٛ، حَا اٜ رٜوْٻٜ حٜلٜنَنْکٛعٜنْ غٛودُٻٜ مَنْغُ اٜ وٛرْٻٜ حٜلٜنَنْکٛعٜنْ طُطْٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","ندٜ يَحُودَنْکٛعٜنْ تَسَلٛونِکَ نَنِ بُلُسْ وَعَجِنِي وٛلْدٜ اَللَّه ندٜرْ غَرِيرِ بِيرِيَ، ٻٜ نجَحِ تٛنْ مَا، ٻٜ اُمِّنِ حَکِّيلٛ يِمْٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","طٛنْ اٜ طٛنْ تٛکُّٻٜ يٜىٰسُ نغَطِ بُلُسْ حُولَ فٛنْغٛ مَايٛ، اَمَّا سِيلَ اٜ تِمٛوتِ نجٛوطِي ندٜرْ غَرِيرِ ندِنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","طٛفْتُٻٜ بُلُسْ بٛو نجَادِ اٜ مَاکٛ ندٜرْ کٛمِوَلْ حَا غَرِيرِ اَتِنَ؞ ندٜ ٻٜ نجٛتِّي تٛنْ، بُلُسْ لِلٛيِٻٜ ٻٜ مبِعَ سِيلَ اٜ تِمٛوتِ نغَرَ تٛ مَاکٛ ندٜرْ يَوْطَارٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","شَرٜلْ کٛ بُلُسْ اٜ رٜنْتِ غَرٛلْ سِيلَ اٜ تِمٛوتِ اٜ غَرِيرِ اَتِنَ، ٻٜرْندٜ مَاکٛ نَاوِي نَاع سٜطَّ ندٜ اٛ يِعِ نٛ غَرِيرِ ندِنْ حٜىٰوِرِ غُنْکِيجِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","نغَمْ مَاجُمْ اٜ مٛ يٜدّٛوتِرَ اٜ يَحُودَنْکٛعٜنْ اٜ وٛٻّٜ نَاع يَحُودَنْکٛعٜنْ کُلٛوٻٜ اَللَّه ندٜرْ سُودُ دٛعَارٜ؞ طٛنْمَا کٛو ندٜيٜ اٜ مٛ وَطَ نٛنْ ندٜرْ لُومٛ اٜ ٻٜ اٛ حَوْرِ طٛنْ فُو؞ ");
INSERT INTO fuv_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","سٜيْ وٛٻّٜ غٛودُٻٜ اَنْدَلْ بِعٜتٜىٰٻٜ اَبِکُورِعٜنْ اٜ سِتٛوکِعٜنْ مٜدِّ اٜ مَاکٛ؞ وٛٻّٜ مَٻّٜ اٜ مبِعَ، ‏«‏طُمٜ اٛعٛ مَوْنِنٛووٛ حٛورٜ مٛ اَنْدَا کٛو طُمٜ يِطِ وِعُکِ؟»‏ وٛٻّٜ مبِعِ، ‏«‏اٜ مِنْ نغِعَ بٛ اٛ غَعَجِنٛووٛ حَبَرُ اَلَّاجِ غٛطّٜ لٜيْطٜ؞»‏ ٻٜ مبِعُ نٛنْ نغَمْ اٜ مٛ وَعَجِنَ حَبَرُ يٜىٰسُ اٜ اُمَّاکِ مَيْٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","نغَمْ نٛنْ ٻٜ نجَارِمٛ يٜىٰسٛ مَوْٻٜ غَرِيرِ تٛ وِغٜىٰرٜ بِعٜتٜىٰندٜ پٛلْدٜ اَرَاسَ، ٻٜ مبِعِمٛ، ‏«‏اٜ مِنْ نغِطِ اَنْدُکِ اٜکِّتِنٛلْ کٜسٛلْ نغٛلْ اٜکِّتِنْتَا، ");
INSERT INTO fuv_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","نغَمْ اَ وَدِّي فِي طُمْ مِنْ مٜىٰطَايِ نَنُکِ؞ اٜ مِنْ نغِطِ اَنْدُکِ مَعَنَ مَاجُمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","يِمْٻٜ غَرِيرِ اَتِنَ اٜ حٛٻّٜ جٛوطِيٻٜ طٛنْ وَلَا کٛ ٻٜ ٻُرِ يِطُکِ بٛ نَنُکِ فِي کٜسُمْ ٻٜ مٜتَ دٛوْ مَاجُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","سٜيْ بُلُسْ دَرِي يٜىٰسٛ مَوْٻٜ ٻٜنْ تٛ پٛلْدٜ اَرَاسَ، اٛ وِعِ، ‏«‏اٛنٛنْ يِمْٻٜ اَتِنَ، مِ يِعِي اٜ کٛو نغٛلٜ لَاوٛلْ اٛنْ غِطُٻٜ تٛکُّکِ دِينَ نَاع سٜطَّ، ");
INSERT INTO fuv_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","نغَمْ ندٜ نغِيلِيمِ ندٜرْ غَرِيرِ مٛوطٛنْ، اٜ مِ رَارَ بِغٜىٰجٜ دِينَ مٛوطٛنْ حَا مِ يِعِ سَکِّرْدٜ، طُمْ وِنْدِ دٛوْ مَيْرٜ ‏‹‏نغَمْ اَللَّه مٛ اَنْدَاکَ؞›‏ تٛو، اٛنْ طٛنْ مٛ مَوْنِنْتٛنْ ندٜرْ شِيَ اَنْدَلْ، کَنْکٛ نغِطُمِ اَنْدِنْکِعٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","اَللَّه تَغُطٛ دُونِيَارُ اٜ کٛ وٛنِ ندٜرْ مَيْرُ فُو، کَنْکٛ وٛنِ جٛومُ دٛوْ اٜ لٜيْ؞ اٛ جٛوطَتَاکٛ ندٜرْ شُوطِ مَحِرَاطِ جُوطٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","کَنْکٛ اٛ يِطَا بَلَّلْ نٜطّٛ؞ وَلَا کٛو طُمٜ کٛ يِمْٻٜ مبَاوَتَ وَطَنْکِمٛ، نغَمْ کَنْکٛ حٛکَّتَ يِمْٻٜ يٛنْکِ اٜ فٛوفَانغٛ اٜ کٛو طُمٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","دَغَ تٛ نٜطّٛ غٛعٛتٛ اَللَّه تَغِ لٜپِّ فُو، اٛ جٛوطِنِطِ ندٜرْ دُونِيَارُ؞ اٛ دَرْنِ شَرٜلْ نغٜلْ ٻٜ نغَطَتَ کٜىٰرٛلْ جٛنْدٜ مَٻّٜ فُو؞ ");
INSERT INTO fuv_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","اَللَّه وَطِي طُعُمْ نغَمْ ٻٜ طَٻِّتَمٛ طُمْ غَطٛتٛوطُمْ ٻٜ مبُمْبُنْتَ ٻٜ کٜٻَمٛ، کٛو ندٜ اٛ وٛطَّا کٛو مٛيٜ مٜىٰطٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","نغَمْ غٛطّٛ وِعِ، ‏‹‏يٛنْکِ مٜىٰطٜنْ اٜ يَادُ مٜىٰطٜنْ اٜ جٛنْدٜ مٜىٰطٜنْ طُمْ فُو تٛ مَاکٛ طُمْ پِوٛيِ؞›‏ نٛنْ نٛ وٛٻّٜ غِمٛوٻٜ مٛوطٛنْ مبِعِ، ‏‹‏غٛونغَ اٜنٜنْ مَا، اٜنْ لٜݧٛلْ مَاکٛ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","تٛو، ندٜ اٜنْ لٜݧٛلْ اَللَّه، حَانَايِ کَمّٛوطٜنْ اٜ مٛ نَنْدِ اٜ غٛطُّمْ غَطِرَاطُمْ اٜ جِينَارِ کٛو اٜ اَجُرْفَارِ کٛو اٜ حَيْرٜ شٜحَاندٜ، کٛو اٜ کٛ نٜطّٛ وَطِرِ ݧُمٛ مُوطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","اَللَّه مُݧَنِي يِمْٻٜ کٛ ٻٜ نغٛنّٛو ندٜرْ شِيَ اَنْدَلْ؞ اَمَّا جٛونِ، اٜ مٛ وِعَ يِمْٻٜ فُو کٛو تٛيٜ ٻٜ تُوبَ، ");
INSERT INTO fuv_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","نغَمْ اٛ سِرْيَکٜ ݧَلْندٜ ندٜ اٛ وَطَنْتَ دُونِيَارُ کِيتَ ندٜرْ غٛونغَ؞ اٛ وَطَيْ شُٻَاطٛ مَاکٛ وَطَ کِيتَ کَنْ؞ اٛ تَبِّتِنَنِيطُمْ يِمْٻٜ فُو ندٜ اٛ اُمِّنِمٛ دَغَ مَيْدٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","ندٜ ٻٜ نَنِ بُلُسْ اٜ مٜتَ دٛوْ اُمَّاکِ مَيْٻٜ، وٛٻّٜ نجَلِمٛ، وٛٻّٜ بٛو مبِعِ، ‏«‏اٜ مِنْ نغِطِ ٻٜيْدَا مٜتَنْکِمِنْ دٛوْ فِي طُعُمْ وٛنْدٜ ݧَلْندٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","سٜيْ بُلُسْ دِلِّ اَلِٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","اَمَّا وٛٻّٜ نجَٻِ کٛ بُلُسْ وِعِ ٻٜ تٛکِّ يٜىٰسُ؞ ندٜرْ مَٻّٜ اٜ وٛودِ غٛطّٛ غٛنْطٛ ندٜرْ کَوْتَلْ پٛلْدٜ اَرَاسَ بِعٜتٜىٰطٛ دِيٛنِيسِيُسْ، کَنْکٛ اٜ دٜبّٛ بِعٜتٜىٰطٛ دَمَارِسْ، ندٜنْ اٜ وٛٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","غَطَ مَاجُمْ، بُلُسْ اَلِ اَتِنَ، يَحِ کٛرِنْتِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","تٛنْ اٛ تَوِ غٛطّٛ يَحُودَنْکٜىٰجٛ بِعٜتٜىٰطٛ اَکِيلَ، کَنْکٛ اٜ دٜبّٛ مَاکٛ بِعٜتٜىٰطٛ بِرِسْکِلَ، پِوٛيْٻٜ لٜيْدِ فَنْتُسْ؞ ٻٜ نٜىٰٻَايِ کٛ ٻٜ پِوٛيِ لٜيْدِ اِتَالِيَ، نغَمْ کَلَوْدِيُسْ، مَوْطٛ لَامِيٻٜ لٜيْطٜ رٛومَ، وِعِ يَحُودَنْکٛعٜنْ فُو مبُرْتٛو غَرِيرِ رٛومَ؞ بُلُسْ يَحِ تٛ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","اٛ جٛوطِي تٛ مَٻّٜ، اٜ مٛ حُودَ اٜ مَٻّٜ نغَمْ کَنْکٛ اٛ ݧٛوتٛووٛ شُدَّحٛ لُکُرُوجِ بٛنٛ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","کٛو ندٜيٜ ݧَلْندٜ سِوْتَارٜ، بُلُسْ اٜ يٜدّٛوتِرَ اٜ يِمْٻٜ ندٜرْ سُودُ دٛعَارٜ، اٜ مٛ فٛوطَ حَکِّيلٛ يَحُودَنْکٛعٜنْ اٜ يِمْٻٜ نَاع يَحُودَنْکٛعٜنْ نغَمْ ٻٜ تٛکَّ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","ندٜ سِيلَ اٜ تِمٛوتِ پِوٛيِ لٜيْدِ مَکِدٛونِيَ نجٛتِّي غَرِيرِ کٛرِنْتِ، بُلُسْ حٛشِّ شَرٜلْ مُوطُمْ فُو نغَمْ وَعَجِنْکِ اٜ تَبِّتِنَنْکِ يَحُودَنْکٛعٜنْ يٜىٰسُ وٛنِ اَلْمَسِيحُ؞ ");
INSERT INTO fuv_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","اَمَّا ندٜ ٻٜ نغٜدِّمٛ، ٻٜ کُطِمٛ؞ سٜيْ اٛ فِطِّ سٛلَّارٜ کٛلْتٜ مَاکٛ، اٛ وِعِٻٜ، ‏«‏مِ وُرْتَکٜ حَکّٜ مٛوطٛنْ!‏ پِيپَمْ مٛوطٛنْ اٜ دٛوْ کٛعٜ مٛوطٛنْ؞ دَغَ حَنْدٜ، تٛ يِمْٻٜ نَاع يَحُودَنْکٛعٜنْ نجَحَيْمِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","اٛ وُرْتِي اٛ اَلِ سُودُ دٛعَارٜ ندُنْ، اٛ يَحِ وُرٛ غٛطّٛ مَوْنِنٛووٛ اَللَّه، بِعٜتٜىٰطٛ تِيتِيُسْ جُسْتُسْ، مٛ وُرٛ مُوطُمْ وٛنِ حَادٜ سُودُ دٛعَارٜ ندُنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","کِرِبُسْ، مَوْطٛ سُودُ دٛعَارٜ ندُنْ، کَنْکٛ اٜ وُرٛ مَاکٛ فُو ٻٜ تٛکِّ يٜىٰسُ؞ طُطْٻٜ دَغَ ندٜرْ کٛرِنْتِيَنْکٛعٜنْ نَنْٻٜ وَعَجُ بُلُسْ مَا تٛکِّ يٜىٰسُ، ٻٜ نغَطَنَا بَڤْتِسْمَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","وٛنْدٜ جٜمَّارٜ جٛومِرَاوٛ مٜدِّ اٜ بُلُسْ ندٜرْ وَحَيُ، وِعِمٛ، ‏«‏تَاع حُلُ!‏ وَعَجِنْ حَبَرُ اَمْ، تَاع دٜعُّتُ، ");
INSERT INTO fuv_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","نغَمْ اٜ مِ وٛنْدِ اٜ مَاطَ؞ وَلَا بَاوَيْطٛ وَطَنْکِمَ غٛطُّمْ، نغَمْ اٜ مِ وٛودِ يِمْٻٜ طُطْٻٜ ندٜرْ غَرِيرِ ندِعِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","نغَمْ نٛنْ بُلُسْ جٛوطٛدِي اٜ مَٻّٜ حِتَاندٜ غٛعٛ اٜ لٜبِّ جٛوٜىٰغٛعٛ، اٜ مٛ اٜکِّتِنَٻٜ وٛلْدٜ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","اَمَّا شَرٜلْ کٛ غَالِيٛ لَامٛتٛو لٜيْدِ اَکَايَ، يَحُودَنْکٛعٜنْ کَوْتِ کٛعٜ، نَنْغِ بُلُسْ، نجَارِمٛ يٜىٰسٛ لَامُ؞ ");
INSERT INTO fuv_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","ٻٜ نغُلِّيمٛ، ٻٜ مبِعِ، ‏«‏نٜطّٛ اٛعٛ اٜ فٛوطَ يِمْٻٜ نغَمْ ٻٜ تٛکَّ اَللَّه دٛوْ لَاوٛلْ نغٛلْ اَتَّوْرَ حَطِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","بُلُسْ اٜ يِطِ مٜتَنْکِٻٜ وٛنْ طٛنْ، سٜيْ غَالِيٛ وِعِٻٜ، ‏«‏اٛنٛنْ يَحُودَنْکٛعٜنْ، دَا طُمْ غٛطُّمْ کٛ وٛوطَا کٛو کُوغَلْ کَلُّنغَلْ اٛ وَطِ، دَا مِ جَٻَيْ کٛ مبِيطٛنْ دٛوْ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","اَمَّا ندٜ طُمْ غٜدِّ دٛوْ دِينَ مٛوطٛنْ، اٜ اِنْطٜ، اٜ دٛوکَ مٛوطٛنْ، اٛنٛنْ اٜ کٛعٜ مٛوطٛنْ نغَطَنٜىٰمٛ کِيتَ؞ مِنْ کَمْ، مِ وَطَنْتَا اِرِ طُعُمْ فِي کِيتَ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","سٜيْ اٛ رِيوِٻٜ دَغَ ندٜرْ سُودُ کِيتَ ندُنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","سٜيْ ٻٜ نَنْغِ سٛسْتَانُسْ، مَوْطٛ سُودُ دٛعَارٜ ندُنْ، ٻٜ ڤِيِمٛ يٜىٰسٛ دَمُّغَلْ سُودُ کِيتَ ندُنْ؞ اَمَّا غَالِيٛ وَنَّايِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","غَطَ بُلُسْ ٻٜيْدِي بَلْطٜ سٜطَّ تٛ کٛرِنْتِ، اٛ اَلِ تٛکُّٻٜ يٜىٰسُ، اٛ نَتِّ کٛمِوَلْ جَحَيْنغَلْ لٜيْدِ سِيرِيَ، کَنْکٛ اٜ بِرِسْکِلَ اٜ اَکِيلَ؞ اٛ فٜمْبِ اٜ کَنْکِيرِيَ نغَمْ اٛ وَطِي اَلْکَوَلْ يٜىٰسٛ جٛومِرَاوٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","ندٜ ٻٜ نجٛتِّي غَرِيرِ اَافِسَ، طٛنْ بُلُسْ اَلِ بِرِسْکِلَ اٜ اَکِيلَ؞ کَنْکٛ اٛ نَتِّ سُودُ دٛعَارٜ، اٜ مٛ مٜدَّ اٜ يَحُودَنْکٛعٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","ٻٜ تٛرِيمٛ اٛ ٻٜيْدَ جٛوطَاکِ بَلْطٜ سٜطَّ تٛ مَٻّٜ، اَمَّا اٛ جَٻَايِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","ندٜ اٛ وَرِ سٜنْدِرْکِ اٜ مَٻّٜ، اٛ وِعِ، ‏«‏مِ سٛعّٛيْتٛ تٛ مٛوطٛنْ تٛ اَللَّه جَٻِي؞»‏ اٛ نَتِّ کٛمِوَلْ، اٛ دِلِّ؞ ");
INSERT INTO fuv_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","ندٜ اٛ يٛتِّي غَرِيرِ کَيْسَارِيَ، اٛ پَٻِّي يَاکِ اُرُشَلِيمَ اٛ حٛوْنِ تٛکُّٻٜ يٜىٰسُ؞ سٜيْ اٛ يَحِ اَنْتَاکِيَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","غَطَ اٛ وَطِي بَلْطٜ تٛنْ، اٛ دِلِّ اٛ تٛکِّ ندٜرْ لٜيْطٜ غَلَاتِيَ اٜ فِرِيجِيَ، اٜ مٛ سٜمْبِطِنَ تٛکُّٻٜ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","اٜ شَرٜلْ نغٜلْ سٜيْ غٛطّٛ يَحُودَنْکٜىٰجٛ بِعٜتٜىٰطٛ اَفٛولٛسْ نٜطّٛ غَرِيرِ اَلِجَندِيرِيَ وَرِ غَرِيرِ اَافِسَ؞ نٜطّٛ اٛنْ اٛ بَوْطٛ مٜتُکِ، اٛ اَنْدُطٛ وٛلْدٜ اَللَّه نَاع سٜطَّ؞ ");
INSERT INTO fuv_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","اٛ اٜکِّتِنَامَ لَاوٛلْ يٜىٰسُ بٛطُّمْ؞ اٜ مٛ وَعَجِنَ حَبَرُ يٜىٰسُ ندٜرْ وٜلْوٜلٛ، اٜ مٛ وَعَجِنَ بٛطُّمْ، کٛو ندٜ بَڤْتِسْمَ يَحَيَ تَنْ اٛ اَنْدِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","سٜيْ اٛ فُطِّ وَعَجِنْکِ اٜ سٜمْبٜ مَاکٛ فُو ندٜرْ سُودُ دٛعَارٜ؞ ندٜ بِرِسْکِلَ اٜ اَکِيلَ نَنِمٛ، ٻٜ نٛدِّمٛ وُتُّدُ غٛعٛ، ٻٜ ٻٜيْدِ فَمْتِنْکِمٛ لَاوٛلْ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","ندٜ اَفٛولٛسْ يِطِ حُولُکِ يَحَ لٜيْدِ اَکَايَ، تٛکُّٻٜ يٜىٰسُ مبَلِّمٛ مبِنْدَنِ تٛکُّٻٜ يٜىٰسُ وٛنْٻٜ تٛنْ طٜرٜوٛلْ نغَمْ ٻٜ نجَٻّٛومٛ جُوطٜ طِطِ؞ ندٜ اٛ يٛتِّي تٛنْ، اٛ وَرْتِ وَلِّرّٜ مَوْندٜ تٛ يِمْٻٜ غَرْتُٻٜ تٛکُّٻٜ يٜىٰسُ بَرْکَ يِدّٜ جٛومِرَاوٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","اٛ يٜدّٛوتِرِ اٜ يَحُودَنْکٛعٜنْ اٛ دٛعِّٻٜ يٜىٰسٛ يِمْٻٜ فُو، نغَمْ اٛ حٛلِّيٻٜ ندٜرْ دٜفْتٜرٜ شٜنِيندٜ يٜىٰسُ وٛنِ اَلْمَسِيحُ؞ ");
INSERT INTO fuv_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","شَرٜلْ کٛ اَفٛولٛسْ وٛنِ غَرِيرِ کٛرِنْتِ، بُلُسْ تٛکِّ لَاوٛلْ پِوْرُنغٛلْ ندٜرْ کٛشّٜىٰجٜ، اٛ يَحِ اَافِسَ؞ تٛنْ اٛ تَوِ وٛٻّٜ تٛکُّٻٜ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","اٛ پَمِٻٜ، اٛ وِعِ، ‏«‏کٛو اٛنْ کٜٻِي رُوحُ اَللَّه ندٜ نغَرْتُطٛنْ تٛکُّٻٜ يٜىٰسُ؟»‏ ٻٜ نٛوتِي، ٻٜ مبِعِمٛ، ‏«‏مِنْ مٜىٰطَايِ نَنُکِ حَبَرُ رُوحُ اَللَّه؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","اٛ وِعِٻٜ، ‏«‏اِرِ طُمٜ بَڤْتِسْمَ نغَطَنَاطٛنْ؟»‏ ٻٜ مبِعِ، ‏«‏بَڤْتِسْمَ يَحَيَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","بُلُسْ وِعِ، ‏«‏يَحَيَ وَطِي بَڤْتِسْمَ تُوبُکِ؞ اٜ مٛ وِعَ يِمْٻٜ کٛولٛو غٛطّٛ غَرَيْطٛ غَطَ مَاکٛ، وَاتٛ يٜىٰسُ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","ندٜ ٻٜ نَنِ نٛنْ، ٻٜ نغَطَنَا بَڤْتِسْمَ ندٜرْ اِنْدٜ يٜىٰسُ جٛومِرَاوٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","ندٜ بُلُسْ يٛوِ جُوطٜ مُوطُمْ دٛوْ مَٻّٜ، رُوحُ اَللَّه جِڤّٛيِي دٛوْ مَٻّٜ، ٻٜ مٜتِ ندٜرْ طٜمْطٜ طٜ ٻٜ اَنْدَا، ٻٜ ڤُطِّ وَعَجِنْکِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","طُطْکِ مَٻّٜ وَطِي يِمْٻٜ سَڤّٛ اٜ طِطٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","بُلُسْ وَطِ لٜبِّ تَتِ اٜ مٛ وَعَجِنَنَ يَحُودَنْکٛعٜنْ ندٜرْ سُودُ دٛعَارٜ اٜ سٜمْبٜ مَاکٛ فُو، کُلٛلْ وَلَا؞ اٜ مٛ مٜدَّ اٜ مَٻّٜ، اٜ مٛ فٛوطَ حَکِّيلٛ مَٻّٜ حَا اٛ اَنْدِنِٻٜ حَبَرُ لَامُ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","اَمَّا ندٜرْ مَٻّٜ اٜ وٛودِ ٻٜ کٛعٜ جٛرْطٜ؞ ٻٜ نغَݧِ حٛولَاکِ يٜىٰسُ، ٻٜ مٜتِ حَالَ کَلُّکَ دٛوْ لَاوٛلْ يٜىٰسُ يٜىٰسٛ يِمْٻٜ فُو؞ نغَمْ مَاجُمْ بُلُسْ سٜنْدِرِ اٜ مَٻّٜ، اٛ حٛشِّ تٛکُّٻٜ يٜىٰسُ؞ کٛو ندٜيٜ ݧَلْندٜ اٜ مٛ اٜکِّتِنَ ندٜرْ سُودُ جَنْغِرْدٜ تِرَانُسْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","اٛ وَطِ کَ وَطُکِ نٛنْ دُوٻِ طِطِ حَا يَحُودَنْکٛعٜنْ اٜ لٜپِّ اَاسِيَ فُو نَنِ حَالَ جٛومِرَاوٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","اَللَّه وَطِ کُوطٜ کَيْطِنِيطٜ مَوْطٜ دَغَ جُوطٜ بُلُسْ طٜ طُمْ مٜىٰطَايِ يِعُکِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","حَا مَا لٜفٛيْ اٜ کٛلْتٜ مٜىٰمُطٜ ٻَنْدُ مَاکٛ فُو اٜ نجَارَنٜىٰ ݧَوْٻٜ، اٜ ٻٜ نجَمْطِتَ، غِنِّ مَا مبُرْتٛو ندٜرْ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","تٛو، اٜ وٛودِ وٛٻّٜ يَحُودَنْکٛعٜنْ يِيلٛتٛوٻٜ نغَمْ وُرْتِنَنْکِ غِنَّاٻٜ غِنِّ؞ وٛٻّٜ مَٻّٜ ڤٛوندِي حُوتِرْکِ اِنْدٜ يٜىٰسُ جٛومِرَاوٛ، اٜ ٻٜ مبِعَ غِنِّ طِنْ، ‏«‏ندٜرْ اِنْدٜ يٜىٰسُ مٛ بُلُسْ وَعَجِنْتَ اٜ مِنْ مبِعَعٛنْ مبُرْتٜىٰ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","ٻِٻّٜ غٛطّٛ مَوْطٛ اَرْدِيٻٜ دِينَ يَحُودَنْکٛعٜنْ بِعٜتٜىٰطٛ سِيبَ کَمْٻٜ نجٛوٜىٰطِطٛ اٜ نغَطَ نٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","اَمَّا غِنّٛلْ نغٛلْ وِعِٻٜ، ‏«‏اٜ مِ اَنْدِ يٜىٰسُ، اٜ مِ اَنْدِ بُلُسْ، اَمَّا اٛنٛنْ، اٛنْ ٻٜيٜ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","غِنَّاطٛ اٛنْ يَنَنِٻٜ، نَوْنِٻٜ، جَالِيٻٜ حَا ٻٜ مبُرْتِي وُرٛ نغٛنْ، اٜ ٻٜ ندٛغَّ ٻٜ ٻٛرْنَاکِ ٻٜ فُو ٻٜ نَوْنٛوطٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","حَبَرُ مَاجُمْ سَنْکِتِي ندٜرْ يَحُودَنْکٛعٜنْ اٜ يِمْٻٜ نَاع يَحُودَنْکٛعٜنْ جٛوطِيٻٜ ندٜرْ غَرِيرِ اَافِسَ؞ کُلٛلْ نَنْغِٻٜ، ٻٜ فُو؞ اِنْدٜ يٜىٰسُ بٛو حٜٻِي مَوْنِنٜىٰکِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","يِمْٻٜ طُطْٻٜ غَرْتُٻٜ تٛکُّٻٜ يٜىٰسُ نغَرِ مبِعِ اٜ نجَيْرِ فُو کُوطٜ کَلُّطٜ طٜ ٻٜ کُوُنٛو؞ ");
INSERT INTO fuv_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","دَرْنٛوٻٜ طُطْٻٜ کَوْرِتِ طٜرٜىٰجِ مَٻّٜ، ٻٜ نغُلِطِ يٜىٰسٛ يِمْٻٜ؞ ندٜ ٻٜ لِمِ شٜىٰدٜ مَاجِ، طٜ نجَارِي شٜىٰدٜ اَجُرْفَارِ 50,000؞ ");
INSERT INTO fuv_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","نٛنْ حَبَرُ يٜىٰسُ ٻٜيْدِ سَنْکِتٛرَاکِ کٛو تٛيٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","غَطَ فِي طُمْ طٛنْ فُو، بُلُسْ سُٻِ تٛکَّ لَاوٛلْ لٜيْطٜ مَکِدٛونِيَ اٜ اَکَايَ يَاکِ اُرُشَلِيمَ؞ اٛ وِعِ، ‏«‏غَطَ مِ يَحِي تٛنْ، دٛولٜ مِ يَحَ غَرِيرِ رٛومَ مَا؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","سٜيْ اٛ لِلِ وَلَّيْٻٜمٛ طِطٛ، تِمٛوتِ اٜ اٜرَسْتُسْ، ٻٜ نجَحَ لٜيْدِ مَکِدٛونِيَ؞ کَنْکٛ بٛو اٛ وَالِ بَلْطٜ ندٜرْ لٜيْدِ اَاسِيَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","اٜ شَرٜلْ نغٜلْ حَوْرٜ مَوْندٜ اُمِّي ندٜرْ اَافِسَ دٛوْ لَاوٛلْ جٛومِرَاوٛ نغٛلْ بُلُسْ اٜکِّتِنْتَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","اٜ وٛودِ غٛطّٛ بَعِلّٛ اَجُرْفَارِ بِعٜتٜىٰطٛ دِمِتِيرِيُسْ؞ اٜ مٛ وَطَ شُوطِ ڤَمَرِ طِ مَوْنِنْکِ اَلَّح مَٻّٜ طِ اَجُرْفَارِ نَنْدُطِ اٜ شُوطِ غُنْکِ مَٻّٜ دٜبُمْ بِعٜتٜىٰطُمْ اَرْتٜمِسْ؞ نَاع شٜىٰدٜ سٜطَّ اٛ حٜٻَنْتَٻٜ، کَنْکٛ اٜ ٻٜ اٛ حُودَتَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","سٜيْ اٛ حَوْرِتِ ٻٜ اٛ حُودَتَ ٻٜنْ اٜ وٛٻّٜ غَطٛوٻٜ اِرِ کُوغَلْ نغَلْ، اٛ وِعِٻٜ، ‏«‏بَنْدِرَاٻٜ اَمْ، اٛنْ اَنْدِ کُوغَلْ نغَعَلْ اٜ وَدَّنَعٜنْ شٜىٰدٜ طُطّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","کَدِمَا اٛنْ نَنِي، اٛنْ نغِعِي کٛ بُلُسْ وَطَتَ؞ اٜ مٛ سٜلْنَ يِمْٻٜ طُطْٻٜ، نَاع طٛعٛ ندٜرْ غَرِيرِ اَافِسَ تَنْ، اَمَّا حَا ندٜرْ لٜيْدِ اَاسِيَ فُو؞ اٜ مٛ وِعَٻٜ اَلَّاجِ طِ يِمْٻٜ نغَطِ اٜ جُوطٜ مَٻّٜ، نَاع طِ غٛونغَاجِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","تٛ اٜنْ اَلْدِيمٛ نٛنْ، يِمْٻٜ مبٛنَّيْ اِنْدٜ کُوغَلْ مٜىٰطٜنْ؞ نَاع کَنْجُمْ تَنْ، طٛنْمَا ٻٜ مبٛنَّيْ اِنْدٜ سُودُ مَوْنِنْکِ اَلَّح مٜىٰطٜنْ اَرْتٜمِسْ مَوْطٛ؞ ندٜنْ ٻٜ اَلَيْ تٜدِّنْکِمٛ، کَنْکٛ مٛ جٛوطِيٻٜ لٜيْدِ اَاسِيَ اٜ دُونِيَارُ ندُعُ فُو مَوْنِنْتَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","ندٜ ٻٜ نَنِ نٛنْ، ٻٜرْطٜ مَٻّٜ مٜتِّ، ٻٜ نغُلِّ، اٜ ٻٜ مبِعَ، ‏«‏اَرْتٜمِسْ مٛ اَافِسَ کَنْکٛ وٛنِ مَوْطٛ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","حَکِّيلٛ يِمْٻٜ غَرِيرِ ندِنْ فُو اُمِّي، ٻٜ نجَحِ ٻٜ نَنْغِ غَايُسْ اٜ اَرِسْتَرْکُسْ، يِمْٻٜ مَکِدٛونِيَ، جَادٛوٻٜ اٜ بُلُسْ؞ ٻٜ ندَسِٻٜ، ٻٜ نجَارِٻٜ نجَيْرِ تٛ يِمْٻٜ غَرِيرِ کَوْرِتَتَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","بُلُسْ اٜ يِطِ نَتُّکِ ندٜرْ مٛٻْتٛرْدٜ ندٜنْ، اَمَّا تٛکُّٻٜ يٜىٰسُ کَطِمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","حَا اٜ وٛٻّٜ ندٜرْ مَوْٻٜ لٜيْدِ اَاسِيَ، حِغٛوٻٜ مَاکٛ، لِلٛنٛيِمٛ تٛرِيمٛ تٛع اٛ نَتَّ وِغٜىٰرٜ ندٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","اٜ شَرٜلْ نغٜلْ، حَکِّيلٛ حَوْرُتُٻٜ فُو جِيٻَکٜ؞ کٛو مٛيٜ اٜ کَ وِعَتَ، نغَمْ طُطْٻٜ ندٜرْ مَٻّٜ اَنْدَا کٛ حَوْرِتِٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","يَحُودَنْکٛعٜنْ نغَرْتِرِ اَلِجَنْدَ مٜتٛووٛ نغَمْ مَٻّٜ؞ وٛٻّٜ ندٜرْ حَوْرُتُٻٜ ٻٜنْ مبِعِمٛ اٛ مٜتَ؞ سٜيْ اَلِجَنْدَ پٜفْتِ جُنْغٛ نغَمْ ٻٜ ندٜعِّتَ اٛ مٜتَنَٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","اَمَّا ندٜ ٻٜ اَنْدِتِ اٛ يَحُودَنْکٜىٰجٛ، ٻٜ نغَطِ اَوَاجِ طِطِ اٜ ٻٜ مبِعَ اٜ سٜمْبٜ، ‏«‏اَرْتٜمِسْ مٛ اَافِسَ کَنْکٛ وٛنِ مَوْطٛ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","اَمَّا ندٜ بِنْدٛووٛ غَرِيرِ ندِنْ دٜعِّتِنِٻٜ، اٛ وِعِٻٜ، ‏«‏اٛنٛنْ اَافِسَنْکٛعٜنْ، کٛو مٛيٜ اٜ اَنْدِ طٛعٛ اَافِسَ وٛنِ تٛ طُمْ رٜىٰنَتَ سُودُ مَوْنِنْکِ اَرْتٜمِسْ مَوْطٛ اٜ حَيْرٜ مَاکٛ جَنٛيْندٜ دَغَ دٛوْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","وَلَا بَاوَيْطٛ يٜدُّکِطُمْ؞ نغَمْ نٛنْ اٜ حَانِ ڤُکِّنٛنْ ٻٜرْطٜ مٛوطٛنْ، ڤَامٜىٰ اٜ کٛ نغَطٛتٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","يِمْٻٜ ٻٜ نغَدُّطٛنْ طٛعٛ ٻٜ نغُجَّايِ کٛو طُمٜ ندٜرْ سُودُ دٛعَارٜ، ٻٜ کُطَايِ اَلَّح مٜىٰطٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","تٛ دِمِتِيرِيُسْ اٜ ٻٜ اٛ حُودَتَ اٜ نغِطِ وُلَّاکِ غٛطّٛ، سُودُ کِيتَ اٜ مَٻِّتِي، اٜ وٛودِ غَطٛوٻٜ کِيتَ، سٜيْ ٻٜ نغُلّٛيٛو تٛنْ!‏ ");
INSERT INTO fuv_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","تٛ بٛو اٜ وٛودِ غٛطُّمْ کٛ نغِطّٛنْ ٻُرْطُمْ نٛنْ، سٜيْ نجَارٛنْطُمْ تٛ مَوْٻٜ غَرِيرِ طُمْ مٛعِّنٜىٰ؞ ");
INSERT INTO fuv_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","حَنْدٜ اٜنْ ندٜرْ شَطُّمْ، طُمْ وُلّٛرْتٛعٜنْ اُمِّنْکِ حَکِّيلٛ؞ وَلَا بٛو کٛ کٜٻٜتٜنْ مبِعٜنْ دٛوْ حَوْرٜ اُمِّيندٜ حَنْدٜ؞ اٜنْ مبَاوَتَا کٛکّٜنْ شٜيْدَ غٜىٰتُمْ اُمِّنْطُمْ حَوْرٜ ندٜنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","ندٜ اٛ وِعِ نٛنْ، اٛ وِعِ يِمْٻٜ ٻٜنْ شَنْکِتٛو؞ ");
INSERT INTO fuv_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","ندٜ کٛو طُمٜ وَلْتِي، بُلُسْ حَوْرِتِ تٛکُّٻٜ يٜىٰسُ، سٜمْبِطِنِ ٻٜرْطٜ مَٻّٜ؞ غَطَ اٛ جَٻّٛوتِرِ اٜ مَٻّٜ، اٛ دِلِّ لٜيْدِ مَکِدٛونِيَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","اٛ تٛکِّ ندٜرْ لٜيْدِ ندِنْ، اٜ مٛ سٜمْبِطِنَ ٻٜرْطٜ يِمْٻٜ اٜ بٛلِيطٜ طُطّٜ؞ ندٜنْ اٛ يٛتِّي لٜيْدِ حٜلٜنَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","اٛ وَطِ لٜبِّ تَتِ تٛنْ؞ شَرٜلْ کٛ اٛ سِرْيٛتٛو نَتُّکِ کٛمِوَلْ يَاکِ لٜيْدِ سِيرِيَ، سٜيْ اٛ نَنِ حَبَرُ يَحُودَنْکٛعٜنْ ندَرْوِي وَرُکِمٛ؞ نغَمْ نٛنْ، اٛ سُٻِ سٛعّٛرَاکِ لَاوٛلْ مَکِدٛونِيَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","اٛ يَادِ اٜ سُفَاتَ ٻِي فَارُسْ مٛ غَرِيرِ بِيرِيَ، اٜ اَرِسْتَرْکُسْ اٜ سَکُندُسْ ٻٜ غَرِيرِ تَسَلٛونِکَ، اٜ غَايُسْ مٛ غَرِيرِ دَرْبٜ، اٜ تِمٛوتِ اٜ تِيکِکُسْ اٜ تُرٛوفِمُسْ ٻٜ لٜيْطٜ اَاسِيَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","ٻٜ اَرْتِمِنْ يَاکِ غَرِيرِ تٛورُوَسْ، ٻٜ ندٜنْتِمِنْ تٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","غَطَ حُمْتٛ بُرٛودِ طُمْ وَلَا پُوفِنِرْطُمْ، مِنْ نَتِّ کٛمِوَلْ تٛ غَرِيرِ فِلِبِ؞ غَطَ بَلْطٜ جٛوِ مِنْ نجٛتِّي تٛ مَٻّٜ اٜ غَرِيرِ تٛورُوَسْ، مِنْ نغَطِ بَلْطٜ جٛوٜىٰطِطِ تٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","ݧَلْندٜ سِوْتَارٜ مِنْ کَوْرِتِ نغَمْ سٜنْدُکِ بُرٛودِ، سٜيْ بُلُسْ وَطِ کَ مٜتَنْکِ يِمْٻٜ حَا شَکَ جٜمَّ، نغَمْ اٜ مٛ يِطِ دِلُّکِ تٛ فِنِي؞ ");
INSERT INTO fuv_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","ندٜرْ سُودُ دٛوْ تٛ مِنْ کَوْرِتِ اٜ وٛودِ فِتِلَاجِ طُطِّ؞ ");
INSERT INTO fuv_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","غٛطّٛ کَيٜىٰجٛ بِعٜتٜىٰطٛ يُوتِکُسْ اٜ جٛوطِي دٛوْ يٛلْندٜ سُودُ؞ بُلُسْ جُوتِنِ حَالَ مُوطُمْ حَا کَيٜىٰجٛ اٛنْ فُطِّ ݝٛݝُکِ؞ طٜيْنغٛلْ تٜدُّنغٛلْ نَنْغِمٛ، اٛ يَنٛيِ دَغَ تٛنْ دٛوْ سُودُ تَتَوْرُ؞ کٛ ٻٜ کٛشَّمٛ فُو، اٛ مَايِي؞ ");
INSERT INTO fuv_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","اَمَّا بُلُسْ جِڤِّي، يَحِ، تُرِي دٛوْ مَاکٛ، وُوندِيمٛ اٜ جُوطٜ مُوطُمْ، وِعِ، ‏«‏تٛع اٛنْ کُلُ!‏ اٜ مٛ وٛودِ يٛنْکِ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","سٜيْ بُلُسْ پٜنْتِتِ، سٜنْدِ بُرٛودِ، ݧَامِ؞ غَطَ مَاجُمْ اٛ ݧَمْرِ يٜىٰسٛ اٜ مٜتَنْکِٻٜ حَا وٜىٰتِ، ندٜنْ اٛ دِلِّ؞ ");
INSERT INTO fuv_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","ٻٜ کٛوتِدِ اٜ کَيٜىٰجٛ اٛنْ، اٜ مٛ فٛوفَ؞ نٛنْ سٜمْبِطِنِي ٻٜرْطٜ مَٻّٜ نَاع سٜطَّ؞ ");
INSERT INTO fuv_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","بُلُسْ سُٻِ تٛکَّ طَتَلْ يَحَ اَاسُسْ؞ مِنٛنْ بٛو، مِنْ نَتِّ کٛمِوَلْ نغَمْ اٜ مٛ يِطِ نَا مِنْ نجَحِي تٛنْ مِنْ کٛشَّمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","ندٜ اٛ تَوِمِنْ تٛ غَرِيرِ اَاسُسْ، مِنْ کٛشِّمٛ ندٜرْ کٛمِوَلْ، مِنْ نجَحِ غَرِيرِ مِتِلِنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","طٛنْمَا مِنْ اُمّٛيِي تٛنْ ندٜرْ کٛمِوَلْ، ندٜ فِنِ مِنْ نجٛتِّي کِيٛسْ؞ ݧَلْندٜ طِطَوْرٜ مِنْ نجٛتِّي سَامٛسْ، ندٜرْ ݧَلْندٜ تَتَوْرٜ بٛو مِنْ نجٛتِّي مِلِتُسْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","بُلُسْ يِطَا دَرَاکِ ندٜرْ اَافِسَ، نغَمْ اٛ يِطَا نٜىٰٻُکِ ندٜرْ اَاسِيَ؞ اٜ مٛ يِطِ يٛتَّاکِ اُرُشَلِيمَ کٛ ݧَلْندٜ حُمْتٛ ٻٜنْدٛلْ اَلْکَمَارِ وَرَ، تٛ طُمْ وَطٛتٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","دَغَ غَرِيرِ مِلِتُسْ، بُلُسْ لِلٛنٛيِ مَوْٻٜ تٛکُّٻٜ يٜىٰسُ وٛنْٻٜ اَافِسَ ٻٜ نغَرَ تٛ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","ندٜ ٻٜ نغَرِ، اٛ وِعِٻٜ، ‏«‏اٛنٛنْ اٜ کٛعٜ مٛوطٛنْ اٛنْ اَنْدِ نٛ نجٛوطٛرِيمِ ندٜرْ مٛوطٛنْ دَغَ ݧَلْندٜ ندٜ ڤُطُّمِ نَتُّکِ لٜيْدِ اَاسِيَ وَرْکِ حَنْدٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","مِ حُوَنِي جٛومِرَاوٛ ندٜرْ لٜسْتِنْکِ حٛورٜ اٜ غٛنْطِ طُطِّ، کٛو ندٜ مِ يَرِي تٛرَّاجِ طُطِّ اٜ جُوطٜ يَحُودَنْکٛعٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","اٛنْ اَنْدِ مِ سُوطَايِعٛنْ کٛو طُمٜ کٛ وَلَّتَعٛنْ؞ مِ وَعَجِنَنِيعٛنْ، مِ اٜکِّتِنِيعٛنْ يٜىٰسٛ يِمْٻٜ فُو، حَا ندٜرْ غُرٜ مٛوطٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","مِ وَغِّنِي يَحُودَنْکٛعٜنْ اٜ يِمْٻٜ نَاع يَحُودَنْکٛعٜنْ فُو ٻٜ تُوبَنَ اَللَّه، ٻٜ کٛولٛو جٛومِرَاوٛ مٜىٰطٜنْ يٜىٰسُ اَلْمَسِيحُ؞ ");
INSERT INTO fuv_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","رُوحُ اَللَّه حٛلِّييَمْ مِ يَحَ اُرُشَلِيمَ جٛونِ؞ مِ اَنْدَا کٛ حٜٻَتَيَمْ تٛنْ، ");
INSERT INTO fuv_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","سٜيْ نِ رُوحُ اَللَّه وِعِييَمْ ندٜرْ غَرِيرِ ندِ نجَالُمِ فُو حَٻّٜىٰکِ اٜ تٛرَّ اٜ حٜطِييَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","اَمَّا مِ حٛشَّايِ يٛنْکِ اَمْ بٛنٛ غٛطُّمْ غٜىٰتُمْ، تٛ نِ مِ حٜٻِي مِ حٜىٰݧِي کُوغَلْ نغَلْ يٜىٰسُ جٛومِرَاوٛ حٛکِّيَمْ، وَاتٛ وَعَجِنْکِ حَبَرُ بٜلْطُمْ طُمْ يِدّٜ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","‏«‏مِ يِيلَکٜ ندٜرْ مٛوطٛنْ، اٜ مِ وَعَجِنَنَعٛنْ حَبَرُ لَامُ جٛومِرَاوٛ؞ جٛونِ، اٜ مِ اَنْدِ اٛنْ ڤُطِّتَتَا يِعُکِيَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","نغَمْ نٛنْ اٜ مِ وِعَعٛنْ حَنْدٜ تٛ غٛطّٛ ندٜرْ مٛوطٛنْ سٜلِي لَاوٛلْ غٛونغَ، حَکّٜ مَاکٛ وَلَا دٛوْ اَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","نغَمْ مِ وَعَجِنَنِيعٛنْ کٛ اَللَّه يِطِ فُو، مِ سُوطَايِعٛنْ کٛو طُمٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","ڤَامَنٜىٰ کٛعٜ مٛوطٛنْ، ندٜىٰنٛنْ اٛرْندٜ ندٜ رُوحُ اَللَّه حٛکِّعٛنْ؞ نغَرْتٜىٰ وٛيْنَاٻٜ کَوْتَلْ يِمْٻٜ اَللَّه، ٻٜ اٛ سٛودِرِ اٜ مَيْدٜ ٻِطّٛ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","اٜ مِ اَنْدِ غَطَ مِ اَلِي طٛعٛ يِمْٻٜ کَلُّٻٜ بٛ شَافَالِ نٛ نَتَّيْ ندٜرْ مٛوطٛنْ، کَدِمَا بٛو ٻٜ اَلَتَا اٛرْندٜ ندٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","حَا ندٜرْ مٛوطٛنْ مَا، وٛٻّٜ اُمّٛتٛ اٜ اٜکِّتِنَ اٜکِّتِنٛلْ فٜوْرٜ نغَمْ ٻٜ ڤٛوطٛيَ تٛکُّٻٜ يٜىٰسُ تٛکَّٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","نغَمْ نٛنْ، ڤَامٜىٰ، شِفْتٛرٜىٰ دُوٻِ تَتِ نغَطُمِ، جٜمَّ اٜ ݧَلَوْمَ، اٜ مِ وَغِّنَ کٛو مٛيٜ مٛوطٛنْ فُو حَا اٜ غٛنْطِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","‏«‏جٛونِ، مِ وَطِيعٛنْ ندٜرْ جُنْغٛ اَللَّه اٜ وٛلْدٜ مَاکٛ، بَاوَيْندٜ سٜمْبِطِنْکِعٛنْ حٛکَّعٛنْ ندٛنُ نغُ اٛ رٜسَنِ شٜنِيٻٜ مَاکٛ فُو؞ ");
INSERT INTO fuv_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","مِ مٜىٰطَايِ يِطُکِ شٜىٰدٜ غٛطّٛ کٛو کٛلْتٜ غٛطّٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","اٛنٛنْ اٜ کٛعٜ مٛوطٛنْ، اٛنْ اَنْدِ مِ حُوتِرِي جُوطٜ اَمْ نغَمْ مِ وَلَّ حٛورٜ اَمْ اٜ وٛنْدُٻٜ اٜ اَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","مِ حٛلِّيعٛنْ مِسَالُ ندٜرْ کٛ نغَطُمِ فُو؞ نٛنْ حَانِ نغَطٛنْ نغَمْ مبَلّٛنْ تَمْڤُٻٜ؞ شِفْتٛرٜىٰ بٛلِيطٜ طٜ يٜىٰسُ جٛومِرَاوٛ وِعِ اٜ حٛورٜ مُوطُمْ، ‏‹‏کٛکّٛووٛ ٻُرِي جَٻٛووٛ بَرْکَ؞›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","ندٜ بُلُسْ يٛتِّنِ بٛلِيطٜ مُوطُمْ، سٜيْ کَنْکٛ اٜ مَٻّٜ ٻٜ فُو ٻٜ ندِشِّي ٻٜ نغَطِ دٛعَارٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","ٻٜ فُو ٻٜ مبٛيِ بٛجِّ طُطِّ، ٻٜ نغُوندِ بُلُسْ ٻٜ نجَٻّٛتِرِ اٜ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","کٛ ٻُرِ وَنُّکِٻٜ وٛنِ ندٜ اٛ وِعِٻٜ ٻٜ ڤُطِّتَتَا ٻٜ نغِعَمٛ؞ سٜيْ ٻٜ طٛفْتِمٛ ٻٜ نجَارِمٛ تٛ کٛمِوَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","ندٜ مِنْ شٜنْدِرِ اٜ مَٻّٜ، مِنْ نَتِّ کٛمِوَلْ، مِنْ نجَحِ لٜيْدِ کٛسْ؞ ندٜ وٜىٰتِ، مِنْ نجَحِ لٜيْدِ رٛودٛسْ، دَغَ تٛنْ مِنْ نجَحِ غَرِيرِ فَاتِرَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","طٛنْ مِنْ تَوِ کٛمِوَلْ جَحَيْنغَلْ لٜيْدِ فِنِيکِيَ، سٜيْ مِنْ نَتِّنغَلْ، مِنْ ندِلِّ؞ ");
INSERT INTO fuv_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","مِنْ کَيْنِي لٜيْدِ نغٛنْدِ شَکَ ندِيَمْ بِعٜتٜىٰندِ سَيِيفُرُسْ مِنْ تٛکِّ فٛمْبِنَ مَيْرِ، مِنْ اُمَّنِي لٜيْدِ سِيرِيَ؞ مِنْ نجٛتِّ غَرِيرِ تَايَ، تٛنْ تٛ طُمْ جِڤِّنَنْتَ کٛمِوَلْ اَمِنْ دٛݝْلٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","مِنْ تَوِ تٛکُّٻٜ يٜىٰسُ تٛنْ، مِنْ نجٛوطٛدِي اٜ مَٻّٜ بَلْطٜ جٛوٜىٰطِطِ؞ ندٜرْ بَوْطٜ رُوحُ اَللَّه ٻٜ مبِعِ بُلُسْ تٛع اٛ يَحَ اُرُشَلِيمَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","اَمَّا ندٜ يٛنْتٛورٜ ندٜنْ حٜىٰݧِ، مِنْ شٛعِّي تٛ کٛمِوَلْ؞ ٻٜ فُو ٻٜ طٛفْتِمِنْ، کَمْٻٜ اٜ رٜوْٻٜ مَٻّٜ اٜ ٻِکّٛيْ مَٻّٜ، حَا مِنْ مبُرْتِي غَرِيرِ؞ مِنْ ندِشِّي دَاندٜ مَايٛ، مِنْ نغَطِ دٛعَارٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","ندٜ مِنْ شٜنْدِرِ، مِنٛنْ مِنْ نَتِّ کٛمِوَلْ، کَمْٻٜ بٛو ٻٜ شٛعِّي غُرٜ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","مِنْ اَلِ غَرِيرِ تَايَ مِنْ دِلِّ ندٜرْ کٛمِوَلْ نغَلْ، مِنْ نجٛتِّ غَرِيرِ تٛلٜمَيِسْ؞ مِنْ تَوِ تٛکُّٻٜ يٜىٰسُ تٛنْ، مِنْ مبَالِ تٛ مَٻّٜ وَلْندٜ وٛعٛيْرٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","ندٜ فِنِ مِنْ اَلِ طٛنْ، مِنْ نجَحِ غَرِيرِ کَيْسَارِيَ؞ مِنْ نَتِّ وُرٛ فِلِبُسْ غَعَجِنٛووٛ حَبَرُ بٜلْطُمْ، مِنْ نجِڤِّي تٛ مَاکٛ؞ کَنْکٛ اٛ غٛعٛتٛ ندٜرْ ٻٜنْ طٛنْ نجٛوٜىٰطِطٛ ٻٜ طُمْ سُٻِ نغَمْ کُوَنَ تٛکُّٻٜ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","اٜ مٛ وٛودِ ٻِٻّٜ رٜوْٻٜ نَيٛ ٻٜ تٜعَاکَ، غَطٛوٻٜ اَنَّبَاکُ؞ ");
INSERT INTO fuv_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","غَطَ مِنْ نجٛوطَکٜ طٛنْ بَلْطٜ سٜطَّ، غٛطّٛ اَنَّبِيجٛ بِعٜتٜىٰطٛ اَغَبُسْ وَرِ دَغَ لٜيْدِ يَحُودِيَ وَرِ تٛ اَمِنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","اٛ حٛشِّ تَادٛرْدٜ بُلُسْ، اٛ حَٻِّ جُوطٜ مَاکٛ اٜ کٛيْطٜ مَاکٛ، اٛ وِعِ، ‏«‏رُوحُ اَللَّه وِعِي نِحِ يَحُودَنْکٛعٜنْ وٛنْٻٜ اُرُشَلِيمَ کَٻِّرْتَ جٛومُ تَادٛرْدٜ ندٜعٜ، ٻٜ نغَطَمٛ ندٜرْ جُوطٜ يِمْٻٜ نَاع يَحُودَنْکٛعٜنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","ندٜ مِنْ نَنِ کٛ اٛ وِعِ، مِنٛنْ اٜ وٛنْٻٜ طٛنْ فُو، مِنْ تٛرِي بُلُسْ تٛع يَحَ اُرُشَلِيمَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","بُلُسْ نٛوتِي، وِعِمِنْ، ‏«‏اَلٜىٰ بٛجِّ، تٛع اٛنْ نغٜوَنَمْ ٻٜرْندٜ!‏ اٜ مِ سِرْيِي نَاع مِ حَٻّٜىٰ تَنْ، اَمَّا حَا مِ مَايَ تٛنْ اُرُشَلِيمَ نغَمْ اِنْدٜ يٜىٰسُ جٛومِرَاوٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","ندٜ مِنْ اَنْدِتِ مِنْ مبَاوَتَا وَيْلُتُکِ ݧُمٛ مَاکٛ، مِنْ ندٜعِّتِ، مِنْ مبِعِ، ‏«‏جٛومِرَاوٛ وَطَ نٛ يِطِ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","غَطَ مِنْ نغَطِي بَلْطٜ سٜطَّ تٛنْ، مِنْ شِرْيِي يَاکِ اُرُشَلِيمَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","وٛٻّٜ ندٜرْ تٛکُّٻٜ يٜىٰسُ دَغَ کَيْسَارِيَ طٛفْتِمِنْ، ٻٜ نجَارِمِنْ وُرٛ غٛطّٛ نٜطّٛ بِعٜتٜىٰطٛ مَنَاسٛنْ پِوٛيْطٛ سَيِيفُرُسْ؞ کَنْکٛ اٛ غٛعٛتٛ ندٜرْ تٛکُّٻٜ يٜىٰسُ اَرَنْدٜعٜنْ مٛ مِنْ نجِڤّٛتٛ تٛ وُرٛ مُوطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","ندٜ مِنْ نجٛتِّي اُرُشَلِيمَ، تٛکُّٻٜ يٜىٰسُ نجَٻِّمِنْ ندٜرْ وٜلْوٜلٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","ندٜ وٜىٰتِ مِنْ نجَادِ اٜ بُلُسْ تٛ يَاکُبُ؞ مَوْٻٜ کَوْتَلْ تٛکُّٻٜ يٜىٰسُ فُو اٜ طٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","غَطَ بُلُسْ حٛوْنِيٻٜ، اٛ وِعِٻٜ کٛو طُمٜ کٛ اَللَّه حُوِ دَغَ جُوطٜ مَاکٛ ندٜرْ يِمْٻٜ نَاع يَحُودَنْکٛعٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","ندٜ ٻٜ نَنِ کٛ اٛ وِعِ، ٻٜ نغٜتِّ اَللَّه؞ ٻٜ مبِعِ بُلُسْ، ‏«‏اَنْ بَنْدِرَاوٛ اَمِنْ، اَ يِعِي نٛ يَحُودَنْکٛعٜنْ تٛکُّٻٜ يٜىٰسُ طُوطِرِ، ٻٜ فُو اٜ ٻٜ تِينِ تٛکُّکِ اَتَّوْرَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","ٻٜ نَنِي اَ اٜکِّتِنَ يَحُودَنْکٛعٜنْ وٛنْٻٜ ندٜرْ غٛطِّ لٜپِّ اَلَ تٛکُّکِ اَتَّوْرَ، اَ وِعَ تٛع ٻٜ نَادَ ٻِکّٛيْ مَٻّٜ، تٛع ٻٜ تٛکَّ ندٛنُ يَحُودَنْکٛعٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","نٛيٜ نغَطٜتٜنْ؟ نغَمْ اٜ مِنْ اَنْدِ ٻٜ نَنَيْ اَ وَرِي طٛعٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","جٛونِ وَطُ کٛ مِنْ مبِعَتَمَ؞ طٛعٛ اٜ وٛودِ وٛرْٻٜ نَيٛ غَطَنْٻٜ اَللَّه اَلْکَوَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","يَادُ اٜ مَٻّٜ، نغَطٛنْ کٛ دِينَ يَحُودَنْکٛعٜنْ وِعِ نغَطٜنْ نغَمْ نغَرْتٛنْ لَاٻُٻٜ يٜىٰسٛ جٛومِرَاوٛ؞ ندٜنْ کٛکَّا کٛ حَانِ ٻٜ کٛکَّ نغَمْ ٻٜ ڤٜمْبٜىٰ؞ نٛنْ حٛلَّيْ يِمْٻٜ کٛ نَنَتَ فُو دٛوْ مَاطَ نَاع طُمْ غٛونغَ؞ ٻٜ اَنْدَيْ کَدِمَا اَنْ اٜ حٛورٜ مَاطَ، اَ تٛکِّ اَتَّوْرَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","اَمَّا کٛولِيٻٜ يٜىٰسُ پِوٛيْٻٜ غٛطِّ لٜپِّ، مِنْ مبِنْدَنِيٻٜ تٛع ٻٜ ݧَامَ کٛ حِرْسَنَا غُنْکِيجِ اٜ کٛ سَاطِ اٜ کٛ مٛيْلَنَا دَاندٜ، کٛو پِيپَمْ، ندٜنْ تٛع ٻٜ نغَطَ نجٜىٰنُ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","سٜيْ بُلُسْ حٛشِّ وٛرْٻٜ نَيٛ ٻٜنْ يَادِ اٜ مَٻّٜ؞ ندٜ فِنِ ٻٜ نغَطِ کٛ دِينَ يَحُودَنْکٛعٜنْ وِعِ ٻٜ نغَطَ نغَمْ وَرْتُکِ لَاٻُٻٜ؞ سٜيْ اٛ نَتِّ وُرٛ شٜنِينغٛ، اٛ وِعِ اَرْدِيٻٜ دِينَ ݧَلْندٜ ندٜ بَلْطٜ لَاٻِنْکِ مَٻّٜ کٜىٰݧَتَ، ݧَلْندٜ ندٜ طُمْ حِرْسَتَ شَکِّرِ نغَمْ کٛو مٛيٜ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","ندٜ بَلْطٜ جٛوٜىٰطِطِ طٜنْ ٻَدِي حٜىٰوُکِ، وٛٻّٜ يَحُودَنْکٛعٜنْ پِوٛيْٻٜ لٜيْدِ اَاسِيَ نغِعِ بُلُسْ ندٜرْ وُرٛ شٜنِينغٛ؞ سٜيْ ٻٜ اُمِّنِ حَکِّيلٛ حَوْرُتُٻٜ طٛنْ فُو، ٻٜ نَنْغِمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","ٻٜ نغُلِّ ٻٜ مبِعِ، ‏«‏اِسْرَاعِيلَنْکٛعٜنْ، مبَلّٜىٰمِنْ!‏ رَا نٜطّٛ جَحٛووٛ کٛو تٛيٜ اٜ اٜکِّتِنَ يِمْٻٜ اٜ وِعَ لٜݧٛلْ مٜىٰطٜنْ اٜ اَتَّوْرَ مٜىٰطٜنْ اٜ وُرٛ شٜنِينغٛ نغٛعٛ وَلَا کٛ نَفِ؞ جٛونِ مَا اٛ وٛنِّي وِغٜىٰرٜ شٜنِيندٜ نغَمْ اٛ وَدِّي يِمْٻٜ نَاع يَحُودَنْکٛعٜنْ ندٜرْ وُرٛ شٜنِينغٛ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","ٻٜ مبِعُ نٛنْ نغَمْ ٻٜ نغِيدِينٛ بُلُسْ اٜ تُرٛوفِمُسْ نٜطّٛ اَافِسَ ندٜرْ غَرِيرِ ندِنْ؞ اٜ ٻٜ کَمِّي بُلُسْ نَتِّنِيمٛ ندٜرْ وُرٛ شٜنِينغٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","حَکِّيلٛ يِمْٻٜ غَرِيرِ ندِنْ فُو اُمِّي؞ يِمْٻٜ اٜ مبُرْتٛيٛو کٛو تٛيٜ اٜ ندٛغّٛيَ اٜ نغَرَ؞ ٻٜ نَنْغِ بُلُسْ ٻٜ ندَسِمٛ ٻٜ مبُرْتِنِمٛ وُرٛ شٜنِينغٛ؞ طٛنْ اٜ طٛنْ دَمُّطٜ مَاغٛ فُو مَٻَّا؞ ");
INSERT INTO fuv_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","اٜ ٻٜ شِرْيٛ ٻٜ مبَرَ بُلُسْ، سٜيْ مَوْطٛ سٛوجِعٜنْ رٛومَ نَنِ حَبَرُ حَکِّيلٛ يِمْٻٜ اُرُشَلِيمَ فُو اُمَّکٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","طٛنْ اٜ طٛنْ، اٛ حٛشِّ سٛوجِعٜنْ اٜ مَوْٻٜ مَٻّٜ، اٛ اُمَّنِي کَوْرُتُٻٜ ٻٜنْ؞ ندٜ يِمْٻٜ ٻٜنْ نغِيدِمٛ اٜ سٛوجِعٜنْ، طٛنْ اٜ طٛنْ ٻٜ اَلِ فِيکِ بُلُسْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","مَوْطٛ اٛنْ ٻَتِّي بُلُسْ وِعِ اٛ نَنْغٜىٰ اٛ حَٻِّرٜىٰ ٻٛغِّ نجَمْندِ طِطِ؞ ندٜنْ اٛ پَمِ بُلُسْ کَنْکٛ اٛ مٛيٜ، طُمٜ اٛ وَطِ؟ ");
INSERT INTO fuv_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","يِمْٻٜ ٻٜنْ بٛو اٜ نغُلَّ؞ کٛو مٛيٜ اٜ کَ وِعَتَ حَا اٛ دُلِّ غٛونغَ حَالَ کَنْ؞ سٜيْ اٛ وِعِ بُلُسْ يَارٜىٰ وُرٛ سٛوجِعٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","ندٜ ٻٜ نجٛتِّي پٜنْتِرْطُمْ وُرٛ نغٛنْ، سٛوجِعٜنْ پٜفْتِمٛ دٛوْ نغَمْ يِمْٻٜ ٻٜنْ طُوطِي؞ ");
INSERT INTO fuv_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","يِمْٻٜ طُطْٻٜ ٻٜنْ اٜ تٛکِّمٛ اٜ ٻٜ نغُلَّ اٜ ٻٜ مبِعَ، ‏«‏مبَرٜىٰمٛ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","ندٜ ٻٜ نغَرِ نَتِّنْکِمٛ وُرٛ سٛوجِعٜنْ ٻٜنْ، بُلُسْ وِعِ مَوْطٛ اٛنْ، ‏«‏کٛو اَ جَٻَيْ مِ مٜدَّ اٜ مَاطَ؟»‏ مَوْطٛ سٛوجِعٜنْ اٛنْ وِعِ بُلُسْ ‏«‏اَشٜىٰ، اَ وَاوِ حٜلٜنَنْکٛورٜ؟ ");
INSERT INTO fuv_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","نَاع اَنْ وٛنِ مَسَرَنْکٜىٰجٛ اُمِّنْطٛ حَوْرٜ کٛ نٜىٰٻَايِ، حَا حَوْرِتِ يِمْٻٜ کَلُّٻٜ ندٜرْ لَدّٜ کٜوْتُٻٜ 4,000؟»‏ ");
INSERT INTO fuv_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","بُلُسْ وِعِ، ‏«‏مِنْ مِ يَحُودَنْکٜىٰجٛ دَݧَاطٛ ندٜرْ غَرِيرِ مَوْندِ بِعٜتٜىٰندِ تَرْسُسْ ندٜرْ لٜيْدِ کِلِيکِيَ؞ اٜ مِ تٛرٛمَا اَلَايَمْ مِ مٜدَّ اٜ يِمْٻٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","سٜيْ مَوْطٛ سٛوجِعٜنْ اٛنْ جَٻِ اٛ مٜدَّ اٜ مَٻّٜ؞ سٜيْ بُلُسْ دَرِي دٛوْ پٜنْتِرْطُمْ سُودُ، اٛ پٜفْتَنِ يِمْٻٜ ٻٜنْ جُنْغٛ نغَمْ ٻٜ ندٜعِّتَ؞ ندٜ ٻٜ ندٜعِّتِ، اٛ مٜتِرَنِٻٜ طٜمْنغَلْ اِبْرَانِيَنْکٛورٜ، اٛ وِعِ، ");
INSERT INTO fuv_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","‏«‏اٛنٛنْ بَنْدِرَاٻٜ اَمْ اٜ دَݧٛوٻٜ اَمْ، کٜتِّندَنٜىٰيَمْ مِ وِعَعٛنْ غٛونغَ دٛوْ کٛ نغُلّٛرِيطٛنْيَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","ندٜ ٻٜ نَنِ اٜ مٛ مٜتِرَنَٻٜ اِبْرَانِيَنْکٛورٜ ٻٜ ٻٜيْدِ دٜعُّتُکِ؞ ندٜنْ اٛ وِعِٻٜ، ");
INSERT INTO fuv_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","‏«‏مِنْ مِ يَحُودَنْکٜىٰجٛ دَݧَاطٛ غَرِيرِ تَرْسُسْ ندٜرْ لٜيْدِ کِلِيکِيَ؞ اَمَّا طٛعٛ اُرُشَلِيمَ مَوْنُمِ؞ غَمَالِيَ وٛنِ مٛودِبّٛ اَمْ؞ کَنْکٛ جَنْغِنِيَمْ اَتَّوْرَ مَامَعٜنْ مٜىٰطٜنْ؞ اٜ مِ تٛکِّ اَللَّه اٜ ٻٜرْندٜ غٛعٛ نٛنْ نٛ تٛکِّرْطٛنْمٛ حَنْدٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","مِ تٛرِّينٛ تٛکُّٻٜ لَاوٛلْ يٜىٰسُ حَا مِ وَرِي وٛٻّٜ؞ مِ نَنْغِي وٛرْٻٜ حَا اٜ رٜوْٻٜ، مِ مَٻِّيٻٜ ندٜرْ سُودُ شُرَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","مَوْطٛ مَوْٻٜ اَرْدِيٻٜ دِينَ اٜ کَوْتَلْ مَوْٻٜ بٛو ٻٜ مبَاوَيْ تَبِّتِنَنْکِعٛنْ کٛ مبِيمِعٛنْ طُمْ غٛونغَ؞ دَغَ تٛ مَٻّٜ کٜٻُمِ طٜرٜىٰجِ يَاکِ تٛ يَحُودَنْکٛعٜنْ وٛنْٻٜ غَرِيرِ دِمَسْکُ؞ مِ يَحِ تٛنْ نَنْغٛيْکِ تٛکُّٻٜ يٜىٰسُ، مِ وَدَّٻٜ اُرُشَلِيمَ نغَمْ ٻٜ تٛرّٜىٰ؞ ");
INSERT INTO fuv_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","‏«‏اٜ مِ دٛوْ لَاوٛلْ يَاکِ دِمَسْکُ، ندٜ ٻَدِيمِ غَرِيرِ ندِنْ، شَکَ ݧَلَوْمَ مِ اَنْدَا مِ اَنْدِتَا سٜيْ وٛنْغٛلْ جَيْنغٛلْ دَنٜوٛلْ تَرْ پِوٛيِ دَغَ دٛوْ يٜيْنَنِييَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","سٜيْ نجَنُمِ اٜ لٜيْدِ، نَنْمِ وٛنْدٜ حٛنٛنْدٜ اٜ وِعَيَمْ، ‏‹‏شَاوُلُ، شَاوُلُ، نغَمْ طُمٜ تٛرَّتَايَمْ؟›‏ ");
INSERT INTO fuv_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","نٛوتِيمِ مبِيمِ، ‏‹‏مَوْطٛ، اَنْ طُمْ مٛيٜ؟›‏ اٛ وِعِيَمْ، ‏‹‏مِنْ وٛنِ يٜىٰسُ نَجَرَنْکٜىٰجٛ مٛ تٛرَّتَا؞›‏ ");
INSERT INTO fuv_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","وٛنْدُٻٜ اٜ اَمْ نغِعِ جَيْنغٛلْ نغٛلْ، اَمَّا ٻٜ نَنَايِ حٛنٛنْدٜ مٜتَنَيْطٛيَمْ اٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","ندٜنْ مبِيمِ، ‏‹‏جٛومِرَاوٛ، کٛ نغِطَّا مِ وَطَ؟›‏ اٛ وِعِيَمْ، ‏‹‏اُمَّ نجَحَا دِمَسْکُ؞ تٛنْ طُمْ وِعَتَمَ کٛ نغَطَتَا فُو؞›‏ ");
INSERT INTO fuv_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","وٛنْدُٻٜ اٜ اَمْ نجٛغَنِييَمْ جُوطٜ حَا ندٜرْ غَرِيرِ دِمَسْکُ، نغَمْ جَيْنغٛلْ نغٛلْ وُمْنِييَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","‏«‏ندٜرْ غَرِيرِ ندِنْ اٜ وٛودِ غٛطّٛ نٜطّٛ بِعٜتٜىٰطٛ حَنَانِيَ، کُلٛووٛ جٛومِرَاوٛ، تٛکُّطٛ اَتَّوْرَ، مٛ يَحُودَنْکٛعٜنْ جٛوطِيٻٜ تٛنْ فُو مَنَتَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","اٛ وَرِ اٛ دَرِي يٜىٰسٛ اَمْ، اٛ وِعِيَمْ، ‏‹‏بَنْدِرَاوٛ اَمْ شَاوُلُ، وُمْتُ!‏›‏ طٛنْ اٜ طٛنْ مبُمْتُمِ نغِيمٛومِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","اٛ وِعِيَمْ، ‏‹‏اَللَّه مٛ مَامَعٜنْ مٜىٰطٜنْ سُٻِيمَ نغَمْ اَنْدَا کٛ اٛ يِطِ وَطُکِ، نغِعَا اَادِلِيجٛ مَاکٛ، نَنَا کٛ اٛ وِعَتَ اٜ حٛنْدُکٛ مَاکٛ، ");
INSERT INTO fuv_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","نغَمْ اَنْ اَندِنْتَمٛ يٜىٰسٛ يِمْٻٜ فُو دٛوْ کٛ نغِيطَا اٜ کٛ نَنْطَا؞ ");
INSERT INTO fuv_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","جٛونِ، طُمٜ ندٜنْتُطَا؟ اُمَّ طُمْ وَطَنْمَا بَڤْتِسْمَ، تٛرٛطَا اَللَّه يَافَنٛمَا حَکّٜ مَاطَ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","‏«‏غَطَ مِ وَرْتِي اُرُشَلِيمَ، اٜ مِ وَطَ دٛعَارٜ ندٜرْ وُرٛ شٜنِينغٛ، سٜيْ نغِيمِ وَحَيُ؞ ");
INSERT INTO fuv_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","ندٜرْ وَحَيُ طُمْ، مِ يِعِ جٛومِرَاوٛ اٜ وِعَيَمْ، ‏‹‏يَوْنُ، وُرْتَ اُرُشَلِيمَ، نغَمْ يِمْٻٜ طٛعٛ نجَٻَتَا کٛ مبِعَتَا دٛوْ اَمْ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","ندٜنْ نٛوتِيمِ مبِيمِ، ‏‹‏جٛومِرَاوٛ، کَمْٻٜ اٜ کٛعٜ مَٻّٜ اٜ ٻٜ اَنْدِ مِ نَتِّي ندٜرْ شُوطِ دٛعَارٜ فُو، مِ نَنْغِي تٛکُّٻٜ يٜىٰسُ، مِ ڤِيِيٻٜ، مِ مَٻِّيٻٜ ندٜرْ سُودُ شُرَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","ندٜ اِسْتِفَانُسْ مٜتَنَيْطٛ يِمْٻٜ دٛوْ مَاطَ وَرَا، مِنْ اٜ حٛورٜ اَمْ مِ جَٻِي وَرُکِمٛ، مِنْ رٜىٰنِ کٛلْتٜ بَرْٻٜمٛ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","جٛومِرَاوٛ وِعِيَمْ، ‏‹‏اُمَّ، مِ لِلٜتٜ تٛ وٛطِّ ندٜرْ لٜپِّ طِ نَاع يَحُودَنْکٛعٜنْ؞›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","يِمْٻٜ ٻٜنْ اٜ کٜتِّندَنِي بُلُسْ نَاکِ اٛ وِعِ کَعَ حَالَ؞ سٜيْ ٻٜ نغُلِّ سٜمْبٜىٰ، ٻٜ مبِعِ، ‏«‏مبَرٜىٰمٛ، اِتّٜىٰمٛ دَغَ ندٜرْ دُونِيَارُ ندُعُ!‏ اٛ حَانَايِ اَلْدٜىٰکِ اٜ يٛنْکِ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","اٜ ٻٜ نغُلَّ، اٜ ٻٜ ٻٛرْتٛو کٛلْتٜ مَٻّٜ، اٜ ٻٜ نٛکَّ مبُلْمبُلْدِ اٜ ٻٜ شَنْکِتَندِ دٛوْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","سٜيْ مَوْطٛ سٛوجِعٜنْ اٛنْ وِعِ طُمْ يَارَ بُلُسْ ندٜرْ وُرٛ سٛوجِعٜنْ، ٻٜ ڤِيَمٛ نغَمْ ٻٜ اَنْدَ کٛ وَطِ يِمْٻٜ ٻٜنْ نغُلِّرْتَ دٛوْ مَاکٛ نِحِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","ندٜ ٻٜ کَٻِّمٛ نغَمْ ٻٜ ڤِيَمٛ، سٜيْ بُلُسْ وِعِ اَرْدِيطٛ غٛنْطٛ طٛنْ، ‏«‏کٛو اٛنْ نغٛودِ لَامُ فِيکِ رٛومَنْکٜىٰجٛ مٛ وَطَنَاکَ کِيتَ تَوْ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","ندٜ اَرْدِيطٛ اٛنْ نَنِ نٛنْ، اٛ يَحِ تٛ مَوْطٛ مَاکٛ، اٛ وِعِ، ‏«‏طُمٜ نغِطَّا وَطَنْکِمٛ؟ نغَمْ نٜطّٛ اٛنْ اٛ رٛومَنْکٜىٰجٛ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","سٜيْ مَوْطٛ سٛوجِعٜنْ اٛنْ وَرِ تٛ بُلُسْ، پَمِمٛ وِعِ، ‏«‏وِعَمْ غٛونغَ، اَ رٛومَنْکٜىٰجٛ؟»‏ بُلُسْ نٛوتِي، وِعِ، ‏«‏اٜىٰ، مِ رٛومَنْکٜىٰجٛ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","اٛ وِعِ بُلُسْ، ‏«‏مِنْ، اٜ شٜىٰدٜ طُطّٜ کٜٻُمِ وَرْتُکِ رٛومَنْکٜىٰجٛ؞»‏ بُلُسْ وِعِمٛ، ‏«‏مِنْ بٛو مِ رٛومَنْکٜىٰجٛ نغَمْ دَݧٛوٻٜ اَمْ نغَرْتِي رٛومَنْکٛعٜنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","طٛنْ اٜ طٛنْ شِرْيِنٛوٻٜ فِيکِمٛ اَلِمٛ؞ مَوْطٛ اٛنْ حُلِ، نغَمْ اٛ اَنْدِتِي بُلُسْ نٛ رٛومَنْکٜىٰجٛ، رَطُّمْ حَا ٻٜ کَٻِّرِيمٛ ٻٛغِّ نجَمْندِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","تٛو، مَوْطٛ سٛوجِعٜنْ اٛنْ اٜ يِطِ اَنْدُکِ کٛ وَطِ يَحُودَنْکٛعٜنْ نغُلّٛيِي بُلُسْ؞ نغَمْ نٛنْ، ندٜ وٜىٰتِ اٛ وَطِ طُمْ فِتِّ بُلُسْ اٛ نٛدِّ مَوْٻٜ اَرْدِيٻٜ دِينَ اٜ کَوْتَلْ مَوْٻٜ فُو ٻٜ کَوْرِتَ؞ اٛ وَدِّ بُلُسْ يٜىٰسٛ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","بُلُسْ سُتِي کَوْتَلْ مَوْٻٜ، وِعِٻٜ، ‏«‏بَنْدِرَاٻٜ اَمْ، اٜ ٻٜرْندٜ لَاٻُندٜ تٛکِّرْمِ اَللَّه دَغَ اَرَنْدٜ حَا وَرْکِ حَنْدٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","سٜيْ حَنَانِيَ، مَوْطٛ مَوْٻٜ اَرْدِيٻٜ دِينَ وِعِ دَرِيٻٜ حَادٜ بُلُسْ ڤِيَ حٛنْدُکٛ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","سٜيْ بُلُسْ وِعِمٛ، ‏«‏اَنْ مَا اَللَّه فِيٜتٜ، اَنْ مُنَافُکِيجٛ!‏ اَ جٛوطِ نغَمْ نغَطَنَايَمْ کِيتَ دٛوْ دٛوکَ اَتَّوْرَ، اَمَّا اَنْ اَ يٜوِي دٛوکَ طُمْ نغَمْ اَ وِعِ مِ فِيٜىٰ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","دَرِيٻٜ حَادٜ مَاکٛ مبِعِمٛ، ‏«‏اَ حُطُ مَوْطٛ مَوْٻٜ اَرْدِيٻٜ دِينَ مٛ اَللَّه سُٻِ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","بُلُسْ وِعِ، ‏«‏بَنْدِرَاٻٜ اَمْ، مِ اَنْدَا اٛ مَوْطٛ مَوْٻٜ اَرْدِيٻٜ دِينَ، نغَمْ اَايَارٜ وِعِي، ‏‹‏تَاع حُطُ اَرْدِيطٛ لٜݧٛلْ!‏›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","ندٜ بُلُسْ اَنْدِتِ وٛٻّٜ ندٜرْ کَوْتَلْ نغَلْ ٻٜ سَادُسَنْکٛعٜنْ، وٛٻّٜ ندٜرْ مَٻّٜ بٛو ٻٜ فَارِسَنْکٛعٜنْ، اٛ وِعِ اٜ سٜمْبٜ، ‏«‏بَنْدِرَاٻٜ اَمْ، مِنْ مِ فَارِسَنْکٜىٰجٛ، ٻِي فَارِسَنْکٛعٜنْ؞ مِ وُلَّ دٛوْ کَمُّندٜ ندٜ نغٛودُمِ دٛوْ اُمَّاکِ مَيْٻٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","ندٜ اٛ وِعِ نٛنْ، سٜيْ فَارِسَنْکٛعٜنْ اٜ سَادُسَنْکٛعٜنْ ڤُطِّ يٜدّٛوتِرْکِ؞ کَوْتَلْ نغَلْ سٜنْدِي طِطِ، ");
INSERT INTO fuv_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","نغَمْ سَادُسَنْکٛعٜنْ مبِعِ اُمَّاکِ مَيْٻٜ وَلَا، مَلَاعِکَعٜنْ نغَلَا، رُوحُوجِ نغَلَا، اَمَّا فَارِسَنْکٛعٜنْ اٜ مبِعَ طُمْ فُو تَتُمْ اٜ طُمْ وٛودِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","غٜدِّ ٻٜيْدِ اُمَّاکِ؞ وٛٻّٜ دَغَ ندٜرْ مٛودِٻّٜ اَتَّوْرَ ندٜرْ فَارِسَنْکٛعٜنْ ندَرِ، اُمِّنِ غٜدِّ کَلُّطِ، ٻٜ مبِعِ، ‏«‏مِنْ نغِعَايِ غٛطُّمْ کٛ حَلِّ کٛ نٜطّٛ اٛعٛ وَطِ؞ طُمْ غَطٛتٛوطُمْ رُوحُ کٛو مَلَاعِکَاجٛ مٜدِّي اٜ مَاکٛ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","غٜدِّ طِنْ نغَرْتِ کَلُّطِ حَا مَوْطٛ سٛوجِعٜنْ اٛنْ حُلِ تٛ بُلُسْ شِشِّتٜىٰ؞ نغَمْ نٛنْ اٛ وِعِ سٛوجِعٜنْ مَاکٛ نجَحَ تٜىٰتٛيَ بُلُسْ تٛ يِمْٻٜ اٜ سٜمْبٜ، ٻٜ نجَارَمٛ وُرٛ سٛوجِعٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","ندٜرْ جٜمَّارٜ ندٜنْ جٛومِرَاوٛ وَنْغِ حَادٜ بُلُسْ، وِعِمٛ، ‏«‏تَاع حُلُ!‏ نٛنْ نٛ اَندِنِرْطَا حَبَرُ اَمْ ندٜرْ اُرُشَلِيمَ، دٛولٜ نغَطَا نٛنْ ندٜرْ غَرِيرِ رٛومَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","ندٜ وٜىٰتِ، وٛٻّٜ يَحُودَنْکٛعٜنْ کَوْتِ کٛعٜ، ٻٜ کُنِي وِيکِ ٻٜ نجَرَتَا ٻٜ ݧَامَتَا سٜيْ تٛ ٻٜ مبَرِي بُلُسْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","کَٻُّٻٜ دَبَرٜ ندٜنْ ٻُرِي يِمْٻٜ 40؞ ");
INSERT INTO fuv_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","ٻٜ نجَحِ تٛ مَوْٻٜ اَرْدِيٻٜ دِينَ اٜ مَوْٻٜ، ٻٜ مبِعِٻٜ، ‏«‏مِنْ کُنَنَکٜ اَللَّه مِنْ نجَرَتَا مِنْ ݧَامَتَا، سٜيْ تٛ مِنْ مبَرِي بُلُسْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","جٛونِ، اٛنٛنْ اٜ کَوْتَلْ مَوْٻٜ، مبِعٜىٰ مَوْطٛ سٛوجِعٜنْ اٛ وَدَّنَعٛنْ بُلُسْ، نغَطٛنْ بٛ اٛنْ نغِطِ ٻٜيْدٛنْ نَنُکِ کٛ اٛ وِعَتَ؞ مِنٛنْ بٛو، اٜ مِنْ شِرْيِي وَرُکِمٛ کٛ اٛ يٛتّٛو تٛ مٛوطٛنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","اَمَّا ٻِي مِݧِرَاوٛ بُلُسْ دٜبّٛ نَنِي کٛ طُمْ شِرْيِي؞ نغَمْ نٛنْ اٛ يَحِ تٛ وُرٛ سٛوجِعٜنْ نغٛنْ، اٛ نَتِّ، اٛ وِعِکَ بُلُسْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","سٜيْ بُلُسْ نٛدِّ غٛعٛتٛ ندٜرْ اَرْدِيٻٜ سٛوجِعٜنْ، وِعِمٛ، ‏«‏يَارُ کَيٜىٰجٛ اٛعٛ تٛ مَوْطٛ مٛوطٛنْ، نغَمْ اٜ مٛ وٛودِ کٛ اٛ وِعَتَمٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","سٜيْ اَرْدِيطٛ سٛوجِعٜنْ اٛنْ يَارِمٛ تٛ مَوْطٛ اٛنْ، اٛ وِعِمٛ، ‏«‏نَنْغَاطٛ بِعٜتٜىٰطٛ بُلُسْ نٛدِّيَمْ، تٛرِييَمْ مِ وَدَّ کَيٜىٰجٛ اٛعٛ تٛ مَاطَ، نغَمْ اٜ وٛودِ کٛ اٛ وِعَتَمَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","مَوْطٛ اٛنْ نَنْغِ جُنْغٛ مَاکٛ، فٛوطِمٛ وُتُّدُ، پَمِمٛ، وِعِمٛ، ‏«‏طُمٜ نغِطَّا وِعُکِيَمْ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","کَيٜىٰجٛ اٛنْ نٛوتِي، وِعِ، ‏«‏اَرْدِيٻٜ يَحُودَنْکٛعٜنْ کَوْتِي حٛورٜ جَانغٛ ٻٜ تٛرٜتٜ نجَارَنَاٻٜ بُلُسْ يٜىٰسٛ کَوْتَلْ مَوْٻٜ، ٻٜ نغَطَيْ بٛ اٜ ٻٜ نغِطِ ٻٜ ٻٜيْدَ نَنُکِ کٛ اٛ وِعَتَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","اَمَّا تَاع جَٻُ کٛ ٻٜ مبِعِ!‏ نغَمْ کٛ ٻُرِ يِمْٻٜ 40 ندٜرْ مَٻّٜ شِرْيَکٜ تَٻَّاکِمٛ دٛوْ لَاوٛلْ؞ ٻٜ فُو ٻٜ کُنَکٜ ٻٜ نجَرَتَا ٻٜ ݧَامَتَا سٜيْ تٛ ٻٜ مبَرِيمٛ؞ جٛونِ ٻٜ شِرْيَکٜ، اٜ ٻٜ کٜطِي کٛ نغَطَتَا؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","مَوْطٛ اٛنْ وِعِ کَيٜىٰجٛ اٛنْ، ‏«‏تَاع وِعُ کٛو مٛيٜ اَ وِعِييَمْکَ؞»‏ سٜيْ اٛ اَلِ کَيٜىٰجٛ اٛنْ دِلِّ؞ ");
INSERT INTO fuv_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","سٜيْ مَوْطٛ سٛوجِعٜنْ اٛنْ نٛدِّ اَرْدِيٻٜ سٛوجِعٜنْ مُوطُمْ طِطٛ، وِعِٻٜ، ‏«‏شِرْيٜىٰ سٛوجِعٜنْ 200 اٜ سٛوجِعٜنْ وَطّٛتٛوٻٜ ڤُشِّ کَمْٻٜ 70 اٜ سٛوجِعٜنْ جٛغٛتٛوٻٜ لَبّٜ 200، نَنْغٛنْ لَاوٛلْ يَاکِ غَرِيرِ کَيْسَارِيَ نجَمْندِ جٛوٜىٰنَيِ حَنْدٜ جٜمَّ؞ ");
INSERT INTO fuv_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","شِرْيٜىٰ ڤُشِّ طِ بُلُسْ وَطّٛتٛو نجَارٛنْمٛ جَمْ تٛ فٜلِسْ غٛمْنَاجٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","مَوْطٛ اٛنْ وِنْدِ طٜرٜوٛلْ، وِعِ، ");
INSERT INTO fuv_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","‏«‏مِنْ، کَلَوْدِيُسْ لِسِيَ، اٜ مِ حٛوْنُمَا، يَا فٜلِسْ، لَامِيطٛ مَوْطٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","نٜطّٛ مٛ لِلْدٛيْمَامِ، اَرْدِيٻٜ يَحُودَنْکٛعٜنْ نَنْغِيمٛ، اٜ نغِطِ وَرْکِمٛ؞ ندٜ طُمْ وِعِيَمْ اٛ رٛومَنْکٜىٰجٛ، مِ يَادِي اٜ سٛوجِعٜنْ، تٜىٰتُمٛومِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","ندٜ اٜ مِ يِطِ اَنْدُکِ کٛ ٻٜ نغُلّٛرِيمٛ، نجَارُمٛومِ يٜىٰسٛ کَوْتَلْ مَوْٻٜ يَحُودَنْکٛعٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","مِ تَوِي دٛوْ دٛوکَ مَٻّٜ تَنْ ٻٜ نغُلّٛرِيمٛ، اَمَّا کٛ ٻٜ نغُلّٛرِيمٛ حٜوْتَايِ اٛ وَرٜىٰ کٛو اٛ مَٻّٜىٰ ندٜرْ سُودُ شُرَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","ندٜ طُمْ وِعِيَمْ يَحُودَنْکٛعٜنْ شِرْيَکٜ دَبَرٜ وَرُکِمٛ، طٛنْ اٜ طٛنْ مِ لِلْدٛيِيمٛ تٛ مَاطَ؞ مِ وِعِ غُلّٛيِيٻٜمٛ نجَحَ مبِعَ کٛ اٛ وَطِ يٜىٰسٛ مَاطَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","سٛوجِعٜنْ ٻٜنْ نغَطِ کٛ مَوْطٛ مَٻّٜ وِعِٻٜ، ٻٜ کٛشِّ بُلُسْ جٜمَّ، ٻٜ نجَارِمٛ غَرِيرِ اَنْتِفَاتِرِسْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","ندٜ فِنِ، سٛوجِعٜنْ غَرْٻٜ اٜ کٛيْطٜ شٛعِّي وُرٛ سٛوجِعٜنْ؞ ٻٜ اَلْدِ بُلُسْ اٜ سٛوجِعٜنْ وَطّٛتٛوٻٜ ڤُشِّ نجَادَ اٜ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","ندٜ سٛوجِعٜنْ وَطِّيٻٜ ڤُشِّ ٻٜنْ نجٛتِّي کَيْسَارِيَ، ٻٜ کٛکِّ غٛمْنَاجٛ اٛنْ طٜرٜوٛلْ نغٛلْ، ٻٜ اَلِ بُلُسْ تٛ جُنْغٛ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","ندٜ غٛمْنَاجٛ اٛنْ جَنْغِ طٜرٜوٛلْ نغٛلْ، اٛ پَمِ ندِيٜ لٜيْدِ بُلُسْ دَݧَا؞ ندٜ اٛ نَنِ بُلُسْ نٛ نٜطّٛ لٜيْدِ کِلِيکِيَ، ");
INSERT INTO fuv_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","اٛ وِعِمٛ، ‏«‏مِ نَنَيْ کٛ مبِعَتَا تٛ غُلِّيٻٜمَ نغَرِي؞»‏ سٜيْ اٛ وِعِ رٜىٰنٛوٻٜ ندٜىٰنَ بُلُسْ ندٜرْ لَامٛرْدٜ ندٜ حِرُدُسْ مَحِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","غَطَ بَلْطٜ جٛوِ، حَنَانِيَ، مَوْطٛ مَوْٻٜ اَرْدِيٻٜ دِينَ، وَرِ کَيْسَارِيَ؞ اٜ مٛ وٛنْدِ اٜ وٛٻّٜ مَوْٻٜ اٜ غٛطّٛ لَوْيَاجٛ بِعٜتٜىٰطٛ تَرْتُلُسْ؞ ٻٜ نغُلِّي بُلُسْ يٜىٰسٛ فٜلِسْ غٛمْنَاجٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","ندٜ طُمْ وَدِّ بُلُسْ، تَرْتُلُسْ فُطِّ مٜتُکِ دٛوْ مَاکٛ اٜ وِعَ، ‏«‏اَللَّه رٜىٰنٜ، لَامِيطٛ مَوْطٛ!‏ لَامُ مَاطَ وَدَّنِيمِنْ جٛنْدٜ جَمْ نَاع سٜطَّ، کَدِمَا اَ مٛعِّنِي کٛ حَانِ مٛعِّنٜىٰکِ، کٛ لٜيْدِ ندِعِ ٻٜيْدٛرْتٛو، اَنْ وَطِطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","طُمْ فُو دَغَ تٛ مَاطَ مِنْ کٜٻِطُمْ، مِنْ نغٜتِّيمَ نَاع سٜطَّ؞ ");
INSERT INTO fuv_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","مِ يِطَا جُوتِنَنْکِمَ بٛلِيطٜ، اَمَّا اٜ مِ تٛرٛمَا تَا جَٻِي حٜتِّندَنَمِنْ سٜطَّ؞ ");
INSERT INTO fuv_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","مِنْ تَوِي نٜطّٛ اٛعٛ نٛ کَلُّطٛ نَاع سٜطَّ، غَدّٛووٛ حَوْرٜ حَکُّندٜ يَحُودَنْکٛعٜنْ ندٜرْ دُونِيَارُ فُو؞ اٛ مَوْطٛ ندٜرْ دِينَ نَجَرَنْکٛعٜنْ، وَاتٛ تٛکُّٻٜ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","حَا مَا اٛ فُطِّي لَلِّنْکِ وُرٛ شٜنِينغٛ، کَنْجُمْ وَطِ مِنْ نَنْغِمٛ؞ ‏‏مِنْ نغِطِي وَطَنْکِمٛ کِيتَ اَمِنْ، ");
INSERT INTO fuv_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","اَمَّا لِسِيَ مَوْطٛ سٛوجِعٜنْ تٜىٰتِمٛ تٛ جُوطٜ اَمِنْ اٜ سٜمْبٜ، ");
INSERT INTO fuv_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","اٛ وِعِ وُلّٛيِيٻٜمٛ نغَرَ يٜىٰسٛ مَاطَ؞‏ اَنْ اٜ حٛورٜ مَاطَ، پَمُمٛ، اَ نَنَيْ بٛطُّمْ کٛ مِنْ نغُلّٛرِيمٛ فُو؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","يَحُودَنْکٛعٜنْ غَرْدُٻٜ اٜ مَاکٛ کَوْتِ مبِعِ کٛ اٛ وِعِ فُو طُمْ غٛونغَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","سٜيْ فٜلِسْ غٛمْنَاجٛ حٛلِّ بُلُسْ مٜتَ، سٜيْ بُلُسْ وِعِمٛ، ‏«‏اٜ مِ اَنْدِ اَ وَطِي دُوٻِ طُطِّ اَ وَطَنَ يِمْٻٜ لٜيْدِ ندِعِ کِيتَ؞ نغَمْ مَاجُمْ اٜ مِ نَنَ بٜلْطُمْ وِعُکِمَ کٛ يِمْٻٜ ٻٜعٜ نغُلّٛرِييَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","طُمْ ٻُرَايِ بَلْطٜ سَڤّٛ اٜ طِطِ کٛ نجَامِ اُرُشَلِيمَ نغَمْ مِ مَوْنِنَ جٛومِرَاوٛ؞ تَا طَٻِّتِي کٛو طُمٜ، اَ تَوَيْ نٛنْ طُمْ وٛنْتِندِرِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","وَلَا تَوُطٛيَمْ اٜ مِ يٜدّٛوتِرَ اٜ غٛطّٛ کٛو اٜ مِ اُمِّنَ حَکِّيلٛ يِمْٻٜ، کٛو ندٜرْ وُرٛ شٜنِينغٛ، کٛو ندٜرْ شُوطِ دٛعَارٜ، کٛو ندٜرْ غَرِيرِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","ٻٜ مبَاوَتَا تَبِّتِنَنْکِمَ کٛ ٻٜ نغُلّٛرِييَمْ جٛونِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","اٜ مِ اَنْدِ اٜ ٻٜ مبِعَ لَاوٛلْ يٜىٰسُ نغٛلْ تٛکُّمِ طُمْ فٜوْرٜ، اَمَّا اٜ مِ مَوْنِنَ اَللَّه مٛ مَامَعٜنْ اَمِنْ، اٜ مِ حٛولِي کٛ وِنْدَا ندٜرْ اَتَّوْرَ اٜ دٜفْتٜ اَنَّبٛعٜنْ فُو؞ ");
INSERT INTO fuv_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","طٛنْمَا اٜ مِ وَطِ کَمُّندٜ اَمْ تٛ اَللَّه، نٛ کَمْٻٜ مَا ٻٜ نغَطِرِ کَمُّندٜ مَٻّٜ دٛوْ مَاکٛ، وِعُکِ مَيْٻٜ اَادِلِعٜنْ اٜ کَلُّٻٜ فُو ٻٜ اُمّٛتٛ دَغَ مَيْدٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","کَنْجُمْ وَطِ کٛو ندٜيٜ ݧَلْندٜ اٜ مِ يِطِ جٛوطٛدَاکِ اٜ ٻٜرْندٜ لَاٻُندٜ يٜىٰسٛ اَللَّه اٜ يٜىٰسٛ يِمْٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","‏«‏مِ وَطِي دُوٻِ سٜطَّ اٜ لٜيْطٜ يَاسِ؞ غَطَ طٛنْ مِ سٛعَّکٜ اُرُشَلِيمَ نغَمْ يَارَنْکِ ٻٜ نغَلَنَا دٛکَّلْ اٜ سَکَّنْکِ جٛومِرَاوٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","اٜ مِ ندٜرْ وَطُکِ کٛ دِينَ اَمِنْ وِعِ مِ وَطَ نغَمْ مِ وَرْتَ لَاٻُطٛ يٜىٰسٛ جٛومِرَاوٛ، سٜيْ ٻٜ تَوِيَمْ ندٜرْ وُرٛ شٜنِينغٛ؞ مِ وٛنْدَا اٜ يِمْٻٜ طُطْٻٜ، مِ اُمِّنَايِ حَکِّيلٛ کٛو مٛيٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","اَمَّا اٜ وٛودِ وٛٻّٜ يَحُودَنْکٛعٜنْ طٛنْ پِوٛيْٻٜ لٜيْدِ اَاسِيَ، کَمْٻٜ کَانِ نغَرَ نغُلّٛويَمْ يٜىٰسٛ مَاطَ، تٛ اٜ وٛودِ کٛ ٻٜ نغُلّٛرْتٛويَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","کٛو بٛو ٻٜعٜ وٛنْٻٜ طٛعٛ سٜيْ ٻٜ مبِعَ فِي کَلُّطُمْ طُمْ ٻٜ تَوْرِيَمْ شَرٜلْ کٛ ندَرِيمِ يٜىٰسٛ کَوْتَلْ مَوْٻٜ، ");
INSERT INTO fuv_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","سٜيْ نِ حَالَ نغٛعٛتَ تَنْ کَ مبِيمِ ندٜ ندَرِيمِ يٜىٰسٛ مَٻّٜ، وِعُکِ، ‏‹‏اٛنْ نغَطَنَيَمْ کِيتَ حَنْدٜ نغَمْ مِ جَٻِي مَيْٻٜ اُمّٛتٛ دَغَ مَيْدٜ!‏›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","ندٜ فٜلِسْ نَنِ نٛنْ اٛ پٜفْتِ حَالَ کَنْ، نغَمْ اٜ مٛ اَنْدِ لَاوٛلْ يٜىٰسُ بٛطُّمْ؞ اٛ وِعِ، ‏«‏سٜيْ تٛ لِسِيَ مَوْطٛ سٛوجِعٜنْ وَرِي، مِ تَپَنَعٛنْ کِيتَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","اٛ وِعِ اَرْدِيطٛ سٛوجِعٜنْ سُرَ بُلُسْ، اَمَّا تٛع اٛ حَطَمٛ وٜدِّتَاکِ، اٛ اَلَ حِغٛوٻٜ مَاکٛ مبَلَّمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","غَطَ بَلْطٜ سٜطَّ فٜلِسْ وَرْدِ اٜ دٜبّٛ مُوطُمْ، يَحُودَنْکٜىٰجٛ بِعٜتٜىٰطٛ دُرُوسِلَ؞ اٛ لِلِ بُلُسْ نٛدّٛيٜىٰ اٛ نَنَ کٛ اٛ وِعَتَ دٛوْ حٛولَاکِ يٜىٰسُ اَلْمَسِيحُ؞ ");
INSERT INTO fuv_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","اَمَّا ندٜ بُلُسْ وَطِ کَ مٜتُکِ دٛوْ اَادِلَاکُ اٜ سُرُکِ حٛورٜ اٜ ݧَلْندٜ جَانغٛ، سٜيْ فٜلِسْ حُلِ، وِعِ، ‏«‏جٛونِ طُمْ حٜپِي؞ يَحُ!‏ تٛ مِ حٜٻِي شَرٜلْ، مِ نٛدّٜتٜ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","اٜ مٛ کَمِّي بُلُسْ حٛکَّيْمٛ شٜىٰدٜ؞ کَنْجُمْ وَطِ کٛو ندٜيٜ اٜ مٛ نٛدَّمٛ نغَمْ ٻٜ مٜدَّ؞ ");
INSERT INTO fuv_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","غَطَ دُوٻِ طِطِ، فٜلِسْ جِڤِّي، فٛکِيُسْ فٜسْتُسْ وَرْتِ غٛمْنَاجٛ؞ ندٜ فٜلِسْ اٜ يِطِ وٜلْنَنْکِ يَحُودَنْکٛعٜنْ ٻٜرْطٜ، اٛ اَلِ بُلُسْ ندٜرْ سُودُ شُرَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","بَلْطٜ تَتِ غَطَ فٜسْتُسْ وَرِي ندٜرْ لٜيْدِ ندِنْ نغَمْ فُطُّکِ کُوغَلْ لَامُ مُوطُمْ، اٛ اُمِّي دَغَ کَيْسَارِيَ، اٛ يَحِ اُرُشَلِيمَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","تٛنْ مَوْٻٜ اَرْدِيٻٜ دِينَ اٜ اَرْدِيٻٜ يَحُودَنْکٛعٜنْ نغُلِّي بُلُسْ تٛ مَاکٛ؞ ٻٜ تٛرِيمٛ ");
INSERT INTO fuv_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","اٛ وَدَّنَٻٜ بُلُسْ اُرُشَلِيمَ، نغَمْ ٻٜ نغَطِي دَبَرٜ نٛ ٻٜ مبَرْدَتَمٛ دٛوْ لَاوٛلْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","فٜسْتُسْ وِعِٻٜ، ‏«‏بُلُسْ اٜ تٛنْ مَٻِّي ندٜرْ سُودُ شُرَلْ غَرِيرِ کَيْسَارِيَ؞ مِنْ اٜ حٛورٜ اَمْ مِ سٛعّٛتٛ تٛنْ نَاع کٛ نٜىٰٻِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","نغَمْ مَاجُمْ، سٜيْ مَوْٻٜ مٛوطٛنْ نجَادَ اٜ اَمْ کَيْسَارِيَ، ٻٜ نغُلّٛومٛ تٛنْ تٛ اٜ وٛودِ غٛطُّمْ کَلُّطُمْ طُمْ اٛ وَطِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","فٜسْتُسْ جٛوطِي تٛ مَٻّٜ کٛ ٻَدِي بَلْطٜ جٛوٜىٰتَتِ کٛو سَڤّٛ؞ غَطَ مَاجُمْ اٛ سٛعِّي غَرِيرِ کَيْسَارِيَ؞ ندٜ وٜىٰتِ، اٛ جٛوطِي دٛوْ جٛوطٛرْغَلْ کِيتَ، اٛ وِعِ بُلُسْ وَدّٜىٰ؞ ");
INSERT INTO fuv_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","ندٜ بُلُسْ وَرِ، يَحُودَنْکٛعٜنْ پِوٛيْٻٜ اُرُشَلِيمَ ڤِلِيمٛ، ٻٜ نغُلّٛرِيمٛ غُلَّالِ طُطِّ کَلُّطِ، طِ ٻٜ مبَاوَايِ تَبِّتِنْکِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","اَمَّا بُلُسْ وِعِٻٜ، ‏«‏مِ وَطَايِ کٛ اَتَّوْرَ حَطِ، کٛو کٛ حَانَا دٛوْ وُرٛ شٜنِينغٛ، کٛو بٛو دٛوْ کَيْسَرْ لَامِيطٛ رٛومَنْکٛعٜنْ مَوْطٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","اَمَّا فٜسْتُسْ اٜ يِطِ وٜلْنَنْکِ يَحُودَنْکٛعٜنْ ٻٜرْندٜ، نغَمْ نٛنْ اٛ پَمِ بُلُسْ، اٛ وِعِ، ‏«‏اَ جَٻَيْ نجَحَا اُرُشَلِيمَ نغَمْ مِ وَطَنْمَا کِيتَ تٛنْ دٛوْ کٛ طُمْ وُلّٛرْتٛمَا؟»‏ ");
INSERT INTO fuv_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","بُلُسْ نٛوتِي، وِعِ، ‏«‏جٛونِ اٜ مِ دَرِي يٜىٰسٛ جٛوطٛرْغَلْ کِيتَ لٜيْ لَامُ کَيْسَرْ لَامِيطٛ رٛومَنْکٛعٜنْ مَوْطٛ تٛ حَانِ مِ وَطَنٜىٰ کِيتَ؞ مِ وَطَنَايِ يَحُودَنْکٛعٜنْ غٛطُّمْ کٛ وٛوطَا؞ اَنْ اٜ حٛورٜ مَاطَ اَ اَنْدِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","تٛ مِ وَطِي غٛطُّمْ کٛ حٜوْتِ مِ وَرٜىٰ، مِ سَلَتَاکٛ وَرٜىٰکِ؞ اَمَّا تٛ کٛ ٻٜ نغُلّٛرِييَمْ نَاع طُمْ غٛونغَ، وَلَا بَاوَيْطٛ وَطُکِيَمْ اٜ جُوطٜ مَٻّٜ؞ اٜ مِ يِطِ مِ وَطَنٜىٰ کِيتَ يٜىٰسٛ کَيْسَرْ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","غَطَ فٜسْتُسْ مٜدِّي اٜ کٛکّٛوٻٜمٛ شَاوٛرِ، اٛ وِعِ بُلُسْ، ‏«‏ندٜ اَ تٛرَکٜ کِيتَ مَاطَ يَارٜىٰ تٛ کَيْسَرْ، طُمْ يَارٜتٜ تٛ مَاکٛ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","بَلْطٜ سٜطَّ غَطَ مَاجُمْ، غٛطّٛ لَامِيطٛ بِعٜتٜىٰطٛ اَغَرِفَ اٜ مَوْنِرَاوٛ مَاکٛ دٜبّٛ بِعٜتٜىٰطٛ بَنِسْ ٻٜ نغَرِ غَرِيرِ کَيْسَارِيَ نغَمْ ٻٜ نجَٻّٛو فٜسْتُسْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","ندٜ ٻٜ مبَالِ تٛنْ بَلْطٜ سٜطَّ، فٜسْتُسْ حٛکِّ لَامِيطٛ اٛنْ حَبَرُ بُلُسْ، اٛ وِعِ، ‏«‏اٜ وٛودِ غٛطّٛ نٜطّٛ مٛ فٜلِسْ لَامِيطٛ اَلِ طٛعٛ ندٜرْ سُودُ شُرَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","کٛ نجَامِ اُرُشَلِيمَ، مَوْٻٜ اَرْدِيٻٜ دِينَ اٜ مَوْٻٜ يَحُودَنْکٛعٜنْ نغُلِّيمٛ تٛ اَمْ، ٻٜ تٛرِييَمْ مِ تَپَنَمٛ کِيتَ وَرٜىٰکِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","نٛوتِيمِ، مبِيمِٻٜ، اٜنٜنْ رٛومَنْکٛعٜنْ اٜنْ نغَطَنْتَا غٛطّٛ کِيتَ تٛ غُلِّيطٛمٛ وَلَا طٛنْ، ندٜنْ نَاع اٛ حٛکَّامَ شَرٜلْ نغَمْ اٛ وُرْتِنَ حٛورٜ مَاکٛ دٛوْ کٛ طُمْ وُلّٛرِيمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","تٛو، ندٜ نغَرْدُمِ اٜ مَٻّٜ طٛعٛ، مِ وٛنَّايِ شَرٜلْ کٛو سٜطَّ؞ ندٜ فِنِ نجٛوطِيمِ دٛوْ جٛوطٛرْغَلْ کِيتَ، مبِيمِ نٜطّٛ اٛنْ وَدّٜىٰ؞ ");
INSERT INTO fuv_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","ندٜ غُلِّيٻٜمٛ ندَرِي، ٻٜ نغُلّٛرَاکِمٛ غٛطُّمْ کَلُّطُمْ نٛ کَمِّنٛومِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","سٜيْ غٜدِّ تَنْ ٻٜ نغَادِ اٜ مَاکٛ دٛوْ بٛلِيطٜ دِينَ مَٻّٜ، اٜ غٛطّٛ مَيْطٛ بِعٜتٜىٰطٛ يٜىٰسُ، مٛ بُلُسْ وِعَتَ اٜ فٛوفَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","مِنْ بٛو، ندٜ مِ اَنْدَا نٛ نغَطَنَيْمِ حَالَ کَنْ، پَمُمٛومِ تٛ اٛ جَٻِي اٛ يَحَ اُرُشَلِيمَ اٛ وَطَنٜىٰ کِيتَ تٛنْ دٛوْ کٛ طُمْ وُلّٛرْتٛومٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","اَمَّا ندٜ اٛ تٛرِييَمْ اٛ اَلٜىٰ ندٜرْ جُوطٜ سٛوجِعٜنْ نَا کَيْسَرْ وَطَنِيمٛ کِيتَ، مبِيمِ اٛ سُرٜىٰ تٛنْ نَا شَرٜلْ نغٜلْ لِلْدَيْمٛومِ تٛ کَيْسَرْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","ندٜنْ اَغَرِفَ وِعِ فٜسْتُسْ، ‏«‏مِنْ اٜ حٛورٜ اَمْ، اٜ مِ يِطِ نَنْکِ کٛ نٜطّٛ اٛعٛ وِعَتَ؞»‏ فٜسْتُسْ وِعِمٛ، ‏«‏اَ نَنَيْ کٛ اٛ وِعَتَ جَانغٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","ندٜ فِنِ اَغَرِفَ اٜ بَنِسْ نغَرِ ندٜرْ لَامُ مَوْطُمْ، ٻٜ نَتِّ ندٜرْ سُودُ کِيتَ، کَمْٻٜ اٜ مَوْٻٜ سٛوجِعٜنْ اٜ اَرْدِيٻٜ غَرِيرِ ندِنْ فُو؞ ندٜنْ فٜسْتُسْ وِعِ بُلُسْ وَدّٜىٰ، سٜيْ اٛ وَدَّا؞ ");
INSERT INTO fuv_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","فٜسْتُسْ وِعِ، ‏«‏اَنْ اَغَرِفَ لَامِيطٛ اٜ يِمْٻٜ حَوْرُتُٻٜ طٛعٛ!‏ اٛنْ نغِعِي نٜطّٛ مٛ يَحُودَنْکٛعٜنْ فُو نغُلِّي تٛ اَمْ ندٜرْ اُرُشَلِيمَ حَا اٜ طٛعٛ، اٜ ٻٜ مبِعَ اٜ سٜمْبٜ اٛ حَانَا اَلْدٜىٰکِ اٜ يٛنْکِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","اَمَّا مِ تَوِي اٛ وَطَايِ غٛطُّمْ کٛ حَانِ اٛ وَرٜىٰ؞ اَمَّا ندٜ کَنْکٛ اٜ حٛورٜ مَاکٛ اٛ تٛرَکٜ کِيتَ مَاکٛ يَارٜىٰ تٛ کَيْسَرْ، مِ سُٻِي لِلْدُکِمٛ تٛ کَيْسَرْ لَامِيطٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","اَمَّا مِ وَلَا حَالَ ندَرِيکَ دٛوْ مَاکٛ کٛ حَانِ مِ وِنْدَنَ لَامِيطٛ اٛنْ؞ کَنْجُمْ وَطِ نغَدُّمٛومِ طٛعٛ يٜىٰسٛ مٛوطٛنْ اٛنْ فُو، کٛ ٻُرِ مَا يٜىٰسٛ مَاطَ اَنْ، اَغَرِفَ لَامِيطٛ، نغَمْ تٛ اٜنْ طَٻِّتِي کٛو طُمٜ مِ حٜٻَ کٛ مبِنْدُمِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","نغَمْ اٜ يِيکِ اَمْ، طُمْ لَاٻَنَايَمْ مِ يَارَ نَنْغَاطٛ تٛ لَامِيطٛ مَوْطٛ، مِ حٜٻَايِ فِي جَمُمْ طُمْ اٛ نَنْغِرَا؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","ندٜنْ اَغَرِفَ وِعِ بُلُسْ، ‏«‏مِ اَلِيمَ وِعُ کٛ نغِطَّا وِعُکِ؞»‏ سٜيْ بُلُسْ پٜفْتِ جُنْغٛ فُطِّ وُرْتِنْکِ حٛورٜ مُوطُمْ، وِعِ، ");
INSERT INTO fuv_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","‏«‏اَللَّه رٜىٰنٜ، اَغَرِفَ لَامِيطٛ؞ مِ نَنِي بٜلْطُمْ ندٜ کٜٻُمِ شَرٜلْ مٜتُکِ نغَمْ مِ وُرْتِنَ حٛورٜ اَمْ يٜىٰسٛ مَاطَ حَنْدٜ دٛوْ کٛ يَحُودَنْکٛعٜنْ نغُلّٛرِييَمْ فُو، ");
INSERT INTO fuv_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","نغَمْ اَ اَنْدِ ندٛنُوجِ يَحُودَنْکٛعٜنْ اٜ غٜدِّ اَمِنْ فُو؞ نغَمْ مَاجُمْ اٜ مِ تٛرٛمَا، حٜتِّندَنَيَمْ ندٜرْ مُݧَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","‏«‏يَحُودَنْکٛعٜنْ فُو اٜ اَنْدِ جٛنْدٜ اَمْ دَغَ کٛ مِ سُکَيٜلْ ڤَمَرٜلْ؞ اٜ ٻٜ اَنْدِ نٛ نجٛوطٛرِيمِ ندٜرْ لٜيْدِ اَمْ اٜ ندٜرْ اُرُشَلِيمَ فُو؞ ");
INSERT INTO fuv_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","کَمْٻٜ اٜ کٛعٜ مَٻّٜ، تٛ ٻٜ نجَٻِي وَطُکِ شٜيْدَ اَمْ، اٜ ٻٜ اَنْدِ دَغَ اَرَنْدٜ مِ غٛعٛتٛ ندٜرْ تٛکُّٻٜ لَاوٛلْ دِينَ اَمِنْ ٻُرْنغٛلْ سَطُکِ نغٛلْ فَارِسَنْکٛعٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","جٛونِ، اٜ مِ دَرِي طٛعٛ يٜىٰسٛ مٛوطٛنْ اٜ مِ وَطَنٜىٰ کِيتَ نغَمْ کَمُّندٜ اَمْ دٛوْ حٜٻُکِ اَلْکَوَلْ نغَلْ اَللَّه وَطَنِ مَامَعٜنْ اَمِنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","لٜپِّ اَمِنْ سَڤّٛ اٜ طِطِ فُو اٜ ندٜنْتِ ندٜرْ کَمُّندٜ حٜٻُکِ اَلْکَوَلْ نغَلْ، کَنْجُمْ وَطِ اٜ ٻٜ مَوْنِنَ اَللَّه جٜمَّ اٜ ݧَلَوْمَ؞ اَللَّه رٜىٰنٜ، نغَمْ اٜ مِ وٛودِ کَمُّندٜ ندٜنْ وَطِ يَحُودَنْکٛعٜنْ نغُلِّييَمْ!‏ ");
INSERT INTO fuv_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","نغَمْ طُمٜ کَمِّيطٛنْ اَللَّه وَاوَتَا اُمِّنْکِ مَيْٻٜ؟ ");
INSERT INTO fuv_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","‏«‏مِنْ اٜ حٛورٜ اَمْ، ندٜنّٛ مِ کَمَّکٜ اٜ حَانِ مِ وَطَ کٛ مبَاوَيْمِ وَطُکِ نغَمْ مِ وٛنَّ اِنْدٜ يٜىٰسُ نَجَرَنْکٜىٰجٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","کَنْجُمْ نغَطُمِ ندٜرْ اُرُشَلِيمَ؞ مَوْٻٜ اَرْدِيٻٜ دِينَ کٛکِّييَمْ لَامُ مِ مَٻَّ تٛکُّٻٜ يٜىٰسُ؞ مِ مَٻِّ طُطْٻٜ ندٜرْ سُودُ شُرَلْ؞ ندٜ ٻٜ تَپَنَا کِيتَ وَرٜىٰکِ، مِ جَٻِيطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","مِ تٛرِّيٻٜ ندٜ طُطُّمْ ندٜرْ شُوطِ دٛعَارٜ فُو؞ اٜ مِ وَطَٻٜ ٻٜ نغَݧَ تٛکُّکِ يٜىٰسُ؞ مِ حَلَّنِيٻٜ نَاع سٜطَّ حَا اٜ مِ طَٻِّتَٻٜ ندٜرْ غَرِيجٜ غٛطّٜ لٜيْطٜ، اٜ مِ تٛرَّٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","‏«‏ندٜ مَوْٻٜ اَرْدِيٻٜ دِينَ کٛکِّيَمْ لَامُ نَنْغُکِ تٛکُّٻٜ يٜىٰسُ تٛ غَرِيرِ دِمَسْکُ سٜيْ ندِلُّمِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","اَللَّه رٜىٰنٜ، اٜ مِ دٛوْ لَاوٛلْ شَکَ ݧَلَوْمَ، سٜيْ نغِيمِ جَيْنغٛلْ پِوٛيِي دَغَ دٛوْ نغٛلْ ٻُرِي جَيْنغٛلْ نَانغٜ نغٛلْ يٜيْنِي دٛوْ اَمِنْ، مِنْ اٜ ٻٜ نجَادَيْمِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","غَطَ مِنْ فُو مِنْ نجَنِي اٜ لٜيْدِ، سٜيْ نَنْمِ حٛنٛنْدٜ اٜ وِعَيَمْ ندٜرْ اِبْرَانِيَنْکٛورٜ، ‏‹‏شَاوُلُ، شَاوُلُ، نغَمْ طُمٜ تٛرَّتَايَمْ؟ اَ تٛرَّ حٛورٜ مَاطَ اٜ مٜىٰرٜ ندٜ نغَݧُطَايَمْ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","نٛوتِيمِ مبِيمِ، ‏‹‏مَوْطٛ، اَنْ طُمْ مٛيٜ؟›‏ جٛومِرَاوٛ وِعِ، ‏‹‏مِنْ وٛنِ يٜىٰسُ مٛ تٛرَّتَا؞ ");
INSERT INTO fuv_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","اُمَّ دَرَ؞ مِ وَنْغَنٜ نغَمْ مِ سُٻُمَا نغَرْتَا کُوَنَيْطٛيَمْ، شٜيْدِنَا کٛ نغِيطَا دٛوْ اَمْ جٛونِ اٜ کٛ کٛلَّيْمَامِ يٜىٰسٛ طٛعٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","مِ حِسْنٜتٜ دَغَ جُوطٜ يَحُودَنْکٛعٜنْ اٜ يِمْٻٜ نَاع يَحُودَنْکٛعٜنْ، ٻٜ لِلَيْمَامِ تٛ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","اَ وُمْتِنَيْٻٜ، ٻٜ مبُرْتٛيٛ ندٜرْ ݧِوْرٜ، ٻٜ نغَرْتَ ندٜرْ جَيْنغٛلْ، ٻٜ مبُرْتٛو ندٜرْ لَامُ شٜيْطَنْ، ٻٜ شٛعّٛو تٛ اَللَّه، نغَمْ ٻٜ کٜٻَ يَافَنٜىٰکِ حَکّٜ، ٻٜ نَتَّ ندٜرْ يِمْٻٜ غَرْتُٻٜ شٜنِيٻٜ نغَمْ ٻٜ کٛولَکٜيَمْ؞›‏ ");
INSERT INTO fuv_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","‏«‏اَللَّه رٜىٰنٜ، اَغَرِفَ لَامِيطٛ، کَنْجُمْ وَطِ مِ سَلَاکِ وَطُکِ کٛ نغِيمِ ندٜرْ وَحَيُ دَغَ دٛوْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","اَرَنْدٜ مِ وَعَجِنَنِي يِمْٻٜ دِمَسْکُ، ندٜنْ اٜ يِمْٻٜ اُرُشَلِيمَ اٜ لٜيْدِ يَحُودِيَ فُو؞ غَطَ نٛنْ تٛکُّمِ ندٜرْ يِمْٻٜ نَاع يَحُودَنْکٛعٜنْ، مبِيمِٻٜ ٻٜ تُوبَ، ٻٜ نغَيْلِتٛيٛو تٛ اَللَّه، ٻٜ کُوَ کُوطٜ کٛلَّيْطٜ ٻٜ تُوبِي؞ ");
INSERT INTO fuv_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","کَنْجُمْ وَطِ يَحُودَنْکٛعٜنْ نَنْغِيَمْ ندٜرْ وُرٛ شٜنِينغٛ، ٻٜ ٻَدِي وَرْکِيَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","اَمَّا اَللَّه اٜ وَلَّيَمْ حَا حَنْدٜ؞ نغَمْ نٛنْ اٜ مِ دَرِي طٛعٛ اٜ مِ مٜتَنَعٛنْ غٛونغَ يٜىٰسٛ مَوْٻٜ اٜ ڤَمَرْٻٜ فُو؞ مِ وِعَايِ کٛو طُمٜ سٜيْ کٛ مُوسَ اٜ اَنَّبٛعٜنْ حٛرِيٻٜ مبِعِ وَطَيْ، ");
INSERT INTO fuv_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","وَاتٛ اَلْمَسِيحُ تٛرّٛتٛ، ندٜنْ اٛ وَرْتَ اَرْتُطٛ اُمَّاکِ دَغَ مَيْدٜ، نغَمْ اٛ وَدَّ جَيْنغٛلْ تٛ يَحُودَنْکٛعٜنْ اٜ يِمْٻٜ نَاع يَحُودَنْکٛعٜنْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","بُلُسْ اٜ ندٜرْ مٜتُکِ، سٜيْ فٜسْتُسْ پٜفْتِ حٛنٛنْدٜ، وِعِ، ‏«‏بُلُسْ، حٛورٜ مَاطَ وَيْلِتَکٜ!‏ طُوطُکِ اَنْدَلْ مَاطَ حَاݝِيمَ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","اَمَّا بُلُسْ وِعِ، ‏«‏اَللَّه رٜىٰنٜ، فٜسْتُسْ، مِ حَاݝَاکِ؞ کٛ مبِيمِ طُمْ غٛونغَ شٜمْبِطْکَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","اَغَرِفَ لَامِيطٛ اٜ اَنْدِ فِي طُعُمْ فُو؞ کَنْجُمْ وَطِ مِ حُلَايِ مٜتُکِ يٜىٰسٛ مَاکٛ؞ مِ تَبِّتِنِي اٜ مٛ اَنْدِ کٛو طُمٜ نٛ وٛنْتِندِرِ، نغَمْ طُمْ وَطَاکَ اٜ سُوطٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","اَغَرِفَ لَامِيطٛ!‏ اَ جَٻِي کٛ اَنَّبٛعٜنْ مبِنْدِ؟ اٜ مِ اَنْدِ اَ جَٻِي!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","اَغَرِفَ وِعِ بُلُسْ، ‏«‏ندٜرْ شَرٜلْ سٜطَّ نغٜعٜلْ اَ ݧُمَ اَ وَاوَيْ وَرْتِرْکِيَمْ تٛکُّطٛ يٜىٰسُ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","بُلُسْ وِعِمٛ، ‏«‏کٛو ندٜرْ شَرٜلْ سٜطَّ، کٛو نَاع ندٜرْ شَرٜلْ سٜطَّ، اٜ مِ تٛرٛو اَللَّه نغَمْ مَاطَ اَنْ اٜ نَنْٻٜيَمْ حَنْدٜ فُو نغَرْتٛنْ کٛ نغَرْتُمِ، اَمَّا نَاع اٜ طِعِ ٻٛغِّ نجَمْندِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","ندٜنْ اَغَرِفَ اٜ فٜسْتُسْ اٜ بَنِسْ اٜ جٛوطٛدِيٻٜ اٜ مَٻّٜ فُو اُمِّي، ندِلِّ؞ ");
INSERT INTO fuv_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","ندٜ ٻٜ مبُرْتِي وُرٛ نغٛنْ، ٻٜ مبِعِ حَکُّندٜ مَٻّٜ، ‏«‏نٜطّٛ اٛعٛ وَطَايِ کٛ حٜوْتِ اٛ وَرٜىٰ کٛو اٛ مَٻّٜ ندٜرْ سُودُ شُرَلْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","سٜيْ اَغَرِفَ وِعِ فٜسْتُسْ، ‏«‏دَا نٜطّٛ اٛعٛ وِعَايِنٛ کِيتَ مَاکٛ يَارٜىٰ تٛ کَيْسَرْ، دَا اٛ يٛوفَامَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","ندٜ طُمْ سُٻِ مِنْ نجَحَ لٜيْدِ اِتَالِيَ ندٜرْ کٛمِوَلْ، سٜيْ بُلُسْ اٜ وٛٻّٜ نَنْغَاٻٜ نغَطَا ندٜرْ جُنْغٛ مَوْطٛ سٛوجِعٜنْ بِعٜتٜىٰطٛ جُولِيٛسْ؞ کَنْکٛ وٛنِ اَرْدِيطٛ کَوْتَلْ سٛوجِعٜنْ بِعٜتٜىٰنغَلْ سٛوجِعٜنْ کَيْسَرْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","مِنْ نَتِّ کٛمِوَلْ پِوٛيْنغَلْ اَدِرَمِتِييُمْ جَحَيْنغَلْ غَرِيجٜ غٛنْطٜ فٛنْغٛ مَايٛ ندٜرْ لٜيْدِ اَاسِيَ؛ مِنْ ندِلِّ؞ اٜ مِنْ نغٛنْدِ اٜ اَرِسْتَرْکُسْ، نٜطّٛ لٜيْدِ مَکِدٛونِيَ پِوٛيْطٛ غَرِيرِ تَسَلٛونِکَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","ندٜ فِنِ مِنْ نجٛتِّي غَرِيرِ سِدٛنْ؞ جُولِيٛسْ نَنِ جُرُمْطُمْ بُلُسْ؛ اٛ جَٻِ بُلُسْ يَحَ تٛ حِغٛوٻٜ مَاکٛ نغَمْ ٻٜ مبَلَّمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","ندٜ مِنْ اُمِّي طٛنْ، مِنْ تٛکِّ فُونَ لٜيْدِ سَيِيفُرُسْ نغٛنْدِ شَکَ ندِيَمْ، نغَمْ حٜنْدُ سٜمْبِطِرَا تٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","مِنْ کُلْتِ مَايٛ نغٛ حَادٜ کِلِيکِيَ اٜ بَمْفِيلِيَ، مِنْ نجٛتِّي غَرِيرِ مِرَ ندٜرْ لٜيْدِ لِيکِيَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","تٛنْ اَرْدِيطٛ سٛوجِعٜنْ اٛنْ حٜٻَنِمِنْ کٛمِوَلْ پِوٛيْنغَلْ اَلِجَندِيرِيَ اُمَّنِينغَلْ اِتَالِيَ، اٛ تِّنِمِنْغَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","بَلْطٜ طُطّٜ کٛمِوَلْ اَمِنْ وَطِ اٜ يَارَ سٜىٰسٜ‑سٜىٰسٜ؞ اٜ بٛنٜ مِنْ نجٛتّٛرِي حَادٜ غَرِيرِ کِنِدُسْ؞ ندٜ حٜنْدُ حَطِمِنْ يَاکِ يٜىٰسٛ، سٜيْ مِنْ تٛکِّرِ فٛمْبِنَ حَا مِنْ نجٛتِّ کِرِتِ، لٜيْدِ نغٛنْدِ شَکَ ندِيَمْ؞ ندٜ مِنْ پَٻِّي حَادٜ سَلْمٛنِ مِنْ تٛکِّرِ فٛنْغٛ کِرِتِ تٛنْ تٛ حٜنْدُ سٜمْبِطِرَا؞ ");
INSERT INTO fuv_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","اٜ بٛنٜ مِنْ پَٻّٛرِي، مِنْ نجٛتِّي وِغٜىٰرٜ بِعٜتٜىٰندٜ جِڤّٛرْدٜ بٛنْدٜ حَادٜ غَرِيرِ لَاسِيَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","مِنْ مبٛنِّ شَرٜلْ طُنغٜلْ حَا ݧَلْندٜ حُمْتٛ اِتُّکِ حَکّٜ پَٻِّي؞ ندٜرْ شَرٜلْ نغٜلْ يَادُ ندٜرْ کٛمِوَلْ اٜ سَطِ نَاع سٜطَّ؞ نغَمْ مَاجُمْ بُلُسْ حٛکِّ شَاوٛرِ، ");
INSERT INTO fuv_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","اٛ وِعِ، ‏«‏بَنْدِرَاٻٜ، مِ يِعِي کٛمِوَلْ نغَلْ اٜ کٛ وٛنِ ندٜرْ مَاغَلْ فُو وٛنّٛتٛ؞ نَاع کَنْجُمْ تَنْ، اَمَّا حَا اٜ اٜنٜنْ مَا اٜنْ کَلْکَيْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","اَمَّا مَوْطٛ سٛوجِعٜنْ ٻُرِي جَٻُکِ حَالَ جٛومُ کٛمِوَلْ نغَلْ اٜ ڤٛوطٛووٛ نغَلْ دٛوْ حَالَ بُلُسْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","جِڤّٛرْدٜ کٛمِيجٜ تٛ مِنْ نغٛنِ وٛوطَا ندٜرْ ندُنْغُ؞ نغَمْ نٛنْ طُطْٻٜ وٛنْٻٜ ندٜرْ کٛمِوَلْ نغَلْ ٻُرِي يِطُکِ مِنْ نجَحَ فِنِکِ نغَمْ مِنْ ندُومَ تٛنْ، تٛ طُمْ وَطٛتٛ؞ فِنِکِ وٛنِ جِڤّٛرْدٜ کٛمِيجٜ ندٜرْ لٜيْدِ کِرِتِ، دَارَيْندٜ لٛکِرّٜ حِرْنَا اٜ وٛيْلَ اٜ لٛکِرّٜ حِرْنَا اٜ فٛمْبِنَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","ندٜ حٜنْدُ فٛمْبِنَ فُطِّ وِسُکِ سٜىٰسٜ‑سٜىٰسٜ، حُوٛوٻٜ ندٜرْ کٛمِوَلْ نغَلْ کَمِّي ٻٜ مبَاوَيْ يَاکِ تٛ ٻٜ نغِطِ؞ ٻٜ اِتّٛيِ نجَمْنغَ دَرْنِرْغَ کٛمِوَلْ نغَلْ، مِنْ تٛکِّ حَادٜ فٛنْغٛ لٜيْدِ کِرِتِ، مِنْ ندِلِّ؞ ");
INSERT INTO fuv_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","اَمَّا غَطَ مَاجُمْ سٜطَّ، حٜنْدُ مَوْندُ بِعٜتٜىٰندُ حٜنْدُ لٛکِرّٜ وٛيْلَ اٜ فُونَ اُمّٛيِي دَغَ لٜيْدِ کِرِتِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","حٜنْدُ ندُنْ تَٻِّي کٛمِوَلْ نغَلْ حَا مِنْ مبَاوَايِ تٛکُّکِ ندٜرْ مَيْرُ؞ نغَمْ نٛنْ، مِنْ اَلِندُ ندُ دِلِّدِ اٜ مَاغَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","ندٜ مِنْ تٛکِّ حَادٜ وٛنْدِ لٜيْدِ ڤَمَرْدِ نغٛنْدِ شَکَ ندِيَمْ بِعٜتٜىٰندِ کَوْدَ، ندِ اُسْتَنِمِنْ حٜنْدُ؞ اٜ بٛنٜ مِنْ ڤٛوطِرٛيِ کٛمِوَلْ ڤَمَرَلْ، ");
INSERT INTO fuv_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","مِنْ نَتِّنِنغَلْ ندٜرْ کٛمِوَلْ مَنْغَلْ؞ ندٜنْ ٻٜ نغَطِ ٻٛغِّ لٜيْ کٛمِوَلْ مَنْغَلْ نغَلْ، ٻٜ کَٻِّنغَلْ، نغَمْ تٛع نغَلْ فٜشّٛو؞ اٜ ٻٜ کُلَ تٛع نغَلْ نُفَ ندٜرْ نجَارٜىٰندِ ندٜرْ ندِيَمْ حَادٜ سِرْتِسْ؞ نغَمْ نٛنْ ٻٜ نجِڤِّنِ غُدٜ غَطَيْطٜ کٛمِوَلْ دِلَّ، ٻٜ اَلِ حٜنْدُ دِلِّدِ اٜ مَاغَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","حٜنْدُ شٜمْبِنْدُ ندُنْ وَطِ کَ فِيکِ؞ نغَمْ نٛنْ ندٜ فِنِ ٻٜ ڤُطِّ حُبِنْکِ کٛ وٛنِ ندٜرْ کٛمِوَلْ نغَلْ ندٜرْ ندِيَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","ندٜرْ ݧَلْندٜ تَتَوْرٜ، کَمْٻٜ اٜ کٛعٜ مَٻّٜ ٻٜ کُبِنِ کٛ ٻٜ کُوتِرْتَ ندٜرْ کٛمِوَلْ نغَلْ ندٜرْ ندِيَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","بَلْطٜ طُطّٜ مِنْ نغِعَايِ نَانغٜ اٜ کٛودٜ، نغَمْ حٜنْدُ ندُنْ وَطِي کَ فَلْپِنْکِ مَايٛ نغٛنْ سٜمْبٜىٰ حَا مِنْ اِتِّ کَمُّندٜ حِسُکِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","غَطَ ٻٜ نغَطِي بَلْطٜ ٻٜ ݧَامَايِ، بُلُسْ دَرِي يٜىٰسٛ مَٻّٜ، وِعِ، ‏«‏دَا اٛنْ نجَٻِينٛ حَالَ اَمْ، دَا اٛنْ اَلَايِ کِرِتِ، دَا تٛرَّ کَعَ اٜ دُلّٜرٜ ندٜعٜ حٜٻَايِعٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","اَمَّا جٛونِ اٜ مِ تٛرٛوعٛنْ، شٜمْبِطِنٜىٰ ٻٜرْطٜ مٛوطٛنْ، نغَمْ کٛو غٛعٛتٛ ندٜرْ مٛوطٛنْ حَلْکَتَا، سٜيْ کٛمِوَلْ نغَعَلْ تَنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","اَللَّه جٜيْطٛيَمْ مٛ مَوْنِنَيْمِ لِلٛيِي مَلَاعِکَاجٛ مُوطُمْ، اٛ وَرِي تٛ اَمْ جٜمَّ؞ ");
INSERT INTO fuv_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","اٛ وِعِيَمْ، ‏‹‏بُلُسْ، تَاع حُلُ، اَ دَرٛتٛ يٜىٰسٛ کَيْسَرْ لَامِيطٛ رٛومَنْکٛعٜنْ مَوْطٛ؞ کَدِمَا، بَرْکَ مَاطَ اَللَّه حِسْنَيْ يِمْٻٜ وٛنْدُٻٜ اٜ مَاطَ ندٜرْ کٛمِوَلْ فُو؞›‏ ");
INSERT INTO fuv_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","نغَمْ نٛنْ، شٜمْبِطِنٜىٰ ٻٜرْطٜ مٛوطٛنْ، نغَمْ اٜ مِ حٛولِي اَللَّه، کٛ اٛ وِعِيَمْ طُمْ وَرْتَيْ غٛونغَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","اَمَّا دٛولٜ حٜنْدُ نٛ يَارَيْعٜنْ ندٜرْ وٛنْدِ لٜيْدِ نغٛنْدِ ندٜرْ ندِيَمْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","ندٜرْ جٜمَّارٜ سَڤّٛ اٜ نَيَوْرٜ، ندٜ حٜنْدُ وَطِ کَ دِلُّدُکِ اٜ اَمِنْ ندٜرْ مَايٛ اَدِيرِيَ، شَکَ جٜمَّ حُوٛوٻٜ ندٜرْ کٛمِوَلْ نغَلْ اٜ کَمِّي مِنْ ٻَدَکٜ لٜيْدِ، ");
INSERT INTO fuv_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","سٜيْ ٻٜ نغَطِ ٻٛغّٛلْ ڤٛوندِرْنغٛلْ لُغُّکِ ندِيَمْ ٻٜ نغِعِ لُغُّکِ ندِيَمْ طَمْ کٛيْطٜ 40؞ مِنْ ٻٜيْدِ يٜىٰسٛ سٜطَّ، ٻٜ ڤٛوندِ کَدِمَا، ٻٜ نغِعِ لُغُّکِ مَاجَمْ حَادٜ کٛيْطٜ 30؞ ");
INSERT INTO fuv_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","ٻٜ کُلِ تٛ کٛمِوَلْ نغَلْ فِيَ حَيْرٜ، نغَمْ نٛنْ ٻٜ نغَطِ نجَمْکٛ نَيٛ ندَرْنِرْکٛ کٛمِوَلْ ندٜرْ ندِيَمْ طَمْ غَطَ مَاغَلْ، ٻٜ نغَطِ کَ وَطُکِ دٛعَارٜ غَرِ وٜىٰتَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","ندٜنْ کُوٛوٻٜ ندٜرْ کٛمِوَلْ نغَلْ اٜ ٻٜ نغِطِ وُرْتَاکِنغَلْ ٻٜ ندَطَ، سٜيْ ٻٜ نجِڤِّنِ کٛمِوَلْ ڤَمَرَلْ ندٜرْ ندِيَمْ، ٻٜ نغَطِ بٛ ٻٜ نجِڤِّنَيْ نجَمْکٛ ندَرْنِرْکٛ دَغَ يٜىٰسٛ کٛمِوَلْ مَنْغَلْ نغَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","سٜيْ بُلُسْ وِعِ سٛوجِعٜنْ ٻٜنْ اٜ مَوْطٛ مَٻّٜ، ‏«‏تٛ يِمْٻٜ ٻٜعٜ ندَرَاکِ ندٜرْ کٛمِوَلْ نغَعَلْ اٛنْ کِسَتَا؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","سٜيْ سٛوجِعٜنْ ٻٜنْ تَپِ ٻٛغِّ جٛغِيطِ کٛمِوَلْ ڤَمَرَلْ نغَلْ، ٻٜ اَلِنغَلْ نغَلْ تٛکِّ ندِيَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","ندٜ غَرِ ٻَدِي وٜىٰتُکِ، بُلُسْ تٛرِيٻٜ ٻٜ فُو ٻٜ ݧَامَ ݧَمْندُ؞ اٛ وِعِ، ‏«‏حَنْدٜ وٛنِ ݧَلْندٜ سَڤّٛ اٜ نَيَوْرٜ اٛنْ ݧَامَايِ غٛطُّمْ نغَمْ وَنَّارٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","نغَمْ نٛنْ اٜ مِ تٛرٛوعٛنْ، ݧَامٜىٰ نغَمْ کِسٛنْ، نغَمْ کٛو لَاسٛلْ حٛورٜ غٛعٛتٛ ندٜرْ مٛوطٛنْ حَلْکَتَا؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","ندٜ اٛ وِعِ نٛنْ، اٛ حٛشِّ بُرٛودِ، اٛ يٜتِّ اَللَّه يٜىٰسٛ مَٻّٜ ٻٜ فُو، اٛ ݝَڤِّتِطُمْ اٛ فُطِّ ݧَامُکِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","سٜيْ ٻٜرْطٜ مَٻّٜ شٜمْبِطِ، کَمْٻٜ مَا ٻٜ کٛشِّ ٻٜ ݧَامِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","مِنٛنْ وٛنْٻٜ ندٜرْ کٛمِوَلْ نغَلْ، مِنْ نغَطِي يِمْٻٜ 276؞ ");
INSERT INTO fuv_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","ندٜ ٻٜ ݧَامِ ٻٜ کَارِ، ٻٜ کٛشِّ بُحُوجِ اَلْکَمَارِ غٛنْطِ ندٜرْ کٛمِوَلْ نغَلْ، ٻٜ ڤَطِّطِ ندٜرْ ندِيَمْ نغَمْ ٻٜ اُسْتَنَنْغَلْ تٜدُّطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","ندٜ وٜىٰتِ حُوٛوٻٜ ندٜرْ کٛمِوَلْ نغَلْ اَنْدِتَايِ لٜيْدِ ندِ ٻٜ نجٛتِّ؞ ٻٜ کَيْنِي وِغٜىٰرٜ غٛودُندٜ نجَارٜىٰندِ؞ ٻٜ نغِطِي يَارُکِ کٛمِوَلْ نغَلْ تٛنْ تٛ ٻٜ مبَاوِي؞ ");
INSERT INTO fuv_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","سٜيْ ٻٜ تَپِ ٻٛغِّ نجَمْکٛ ندَرْنِرْکٛ کٛمِوَلْ نغَلْ، ٻٜ اَلِطِ ندٜرْ ندِيَمْ؞ طٛنْمَا ٻٜ ڤِتِّ ٻٛغِّ طِطُمْ حَٻِّرِ ڤٛوطِرْطُمْ کٛمِوَلْ نغَلْ؞ غَطَ مَاجُمْ، ٻٜ پٜفْتِ وُدٜرٜ وٛنْدٜ اٜ حٛورٜ کٛمِوَلْ نغَلْ، نغَمْ حٜنْدُ فَارَنغَلْ يٜىٰسٛ، يَارَنغَلْ دَاندٜ ندِيَمْ طَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","اَمَّا کٛمِوَلْ نغَلْ فِيِ مٛٻْدٜ نجَارٜىٰندِ ندٜرْ ندِيَمْ، حٛورٜ مَاغَلْ نُفِ، نغَلْ دَرِي طٛنْ؞ غٜىٰلٛوطِ ندِيَمْ نغَطِ کَ ڤِيُکِ غَطَ مَاغَلْ حَا نغَلْ ڤُسِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","سٛوجِعٜنْ وٛنْٻٜ ندٜرْ مَاغَلْ شِرْيِي دَبَرٜ نٛ ٻٜ مبَرْدَتَ شُرَاٻٜ وٛنْٻٜ ندٜرْ کٛمِوَلْ نغَلْ، نغَمْ تٛع غٛطّٛ ندٜرْ مَٻّٜ يِنٛو دَطَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","اَمَّا ندٜ مَوْطٛ سٛوجِعٜنْ اٛنْ اٜ يِطِ حِسْنُکِ بُلُسْ، اٛ حَطِٻٜ وَطُکِ کٛ ٻٜ شِرْيِي، اٛ وِعِ بَوْٻٜ ندِيَمْ اَرْتَ نَتُّکِ ندٜرْ مَاجَمْ، مبُرْتٛو؞ ");
INSERT INTO fuv_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","ندٜنْ حٛرِيٻٜ بٛو مبَطّٛو لٜطّٜ کٛمِوَلْ نغَلْ اٜ ڤٜشّٜ مَاغَلْ؞ نٛنْ مِنْ فُو مِنْ نغَطِ مِنْ مبُرْتِي جَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","ندٜ مِنْ کِسِ، مِنْ نَنِ اِنْدٜ لٜيْدِ نغٛنْدِ شَکَ ندِيَمْ ندِنْ اٜ وِعٜىٰ مَلْتَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","يِمْٻٜ لٜيْدِ ندِنْ نجَٻِّيمِنْ بٛطُّمْ؞ ٻٜ کُٻَّنِمِنْ حِيتٜ، نغَمْ ندِيَمْ اٜ وَطَ، ندٜنْ اٜ وٛودِ ڤٜىٰوٛلْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","بُلُسْ حَوْرِتِ لٜطّٜ اٜ مٛ وَطَطٜ ندٜرْ حِيتٜ نغٜنْ، سٜيْ غُلْطُمْ حِيتٜ نغٜنْ وُرْتِنِ مبٛودِ ندٜرْ مَاجٜ، ندِ فٜعِّمٛ اٜ جُنْغٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","ندٜ يِمْٻٜ ٻٜنْ نغِعِ مبٛودِ ندِنْ اٜ جٛغِي جُنْغٛ بُلُسْ، ٻٜ مبِعِ حَکُّندٜ مَٻّٜ، ‏«‏غٛونغَ نٜطّٛ اٛعٛ اٛ غَطٛووٛ وَرْحٛورٜ؞ کٛو ندٜ اٛ حِسِي دَغَ مَايٛ، اَمَّا فُو اٜ نٛنْ اَلَّح مٜىٰطٜنْ دٜبّٛ تَپٛووٛ کِيتَ اَلْدَتَامٛ اٜ يٛنْکِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","اَمَّا بُلُسْ فِطِّ مبٛودِ ندِنْ ندٜرْ حِيتٜ نغٜنْ، اٛ نَنَايِ نَوْطُمْ کٛو سٜطَّ؞ ");
INSERT INTO fuv_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","اٜ ٻٜ کَمِّي جُنْغٛ مَاکٛ نٛ ٻُوتَيْ، کٛو اٛ يَنَ طٛنْ اٜ طٛنْ اٛ مَايَ؞ اَمَّا ندٜ يَوْتِي ٻٜ نغِعِ وَلَا کٛ يَنِمٛ، ٻٜ نغَيْلِتِ ݧُمٛلْ مَٻّٜ، ٻٜ مبِعِ، ‏«‏اٛعٛ، اٛ اَلَّح فٜىٰرٜ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","حَادٜ وِغٜىٰرٜ ندٜنْ اٜ وٛودِ غٜسٜ مَوْطٛ لٜيْدِ ندِنْ، بِعٜتٜىٰطٛ فُبِلِيُسْ؞ اٛ جَٻِّيمِنْ بٛطُّمْ، اٛ جِڤِّنِمِنْ تٛ وُرٛ مَاکٛ بَلْطٜ تَتِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","ݧَاکٛ مَاکٛ اٜ فُکِّي فِيدَ اٜ جٛنْتٜ کَلُّطٜ اٜ دٛغّٛلْ رٜىٰدُ؞ بُلُسْ يَحِ تٛ مَاکٛ، يٛوِ جُوطٜ مُوطُمْ دٛوْ مَاکٛ، وَطَنِمٛ دٛعَارٜ، اٛ يَمْطِتِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","غَطَ مَاجُمْ، ݧَوْٻٜ حٛرِيٻٜ ندٜرْ لٜيْدِ ندِنْ نغَرِ تٛ بُلُسْ، اٛ يَمْطِتِنِٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","ٻٜ مَوْنِنِمِنْ نَاع سٜطَّ؞ ندٜ مِنْ نغَرِ دِلُّکِ، ٻٜ کٛکِّمِنْ کٛ مِنْ نغِطِ فُو نغَمْ يَادُ؞ ");
INSERT INTO fuv_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","غَطَ لٜبِّ تَتِ، مِنْ نَتِّ ندٜرْ کٛمِوَلْ پِوٛيْنغَلْ اَلِجَندِيرِيَ نٛدِّرْتٜىٰنغَلْ وٛرْٻٜ شِوْتَاٻٜ دُومُنغَلْ ندٜرْ لٜيْدِ مَلْتَ، مِنْ ندِلِّ؞ ");
INSERT INTO fuv_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","مِنْ نجٛتِّي غَرِيرِ بِعٜتٜىٰندِ سِرَکُسْ، مِنْ نغَطِ بَلْطٜ تَتِ تٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","دَغَ طٛنْ مِنْ نَتِّ کٛمِوَلْ، مِنْ ڤِلِي حَا مِنْ نجٛتِّي غَرِيرِ رِغِيُمْ؞ ندٜ فِنِ حٜنْدُ فٛمْبِنَ فُطِّ وِسُکِ؞ ندٜرْ بَلْطٜ طِطِ مِنْ نغَرِ غَرِيرِ فُتِيٛولِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","مِنْ تَوِ تٛکُّٻٜ يٜىٰسُ تٛنْ؞ ٻٜ تٛرِيمِنْ مِنْ نجٛوطٛو تٛ مَٻّٜ يٛنْتٛورٜ غٛعٛ؞ ندٜنْ مِنْ نجٛتّٛيِي غَرِيرِ رٛومَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","ندٜ تٛکُّٻٜ يٜىٰسُ وٛنْٻٜ رٛومَ نَنِ حَبَرُ غَرٛلْ اَمِنْ، ٻٜ نجَحِ لُومٛ اَافِيُسْ اٜ وٛنْدٜ وِغٜىٰرٜ بِعٜتٜىٰندٜ غُرٜ حٛٻّٜ تَتِ نغَمْ جَٻَّاکِمِنْ؞ ندٜ بُلُسْ يِعِٻٜ، اٛ يٜتِّ اَللَّه، ٻٜرْندٜ مَاکٛ سٜمْبِطِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","ندٜ مِنْ نغَرِ غَرِيرِ رٛومَ، طُمْ اَلِ بُلُسْ جِڤِّي ندٜرْ وُرٛ نغٛ طُمْ يٛٻَتَ طُمْ وَالَ، کَنْکٛ اٜ سٛوجِيجٛ دٜىٰنَيْطٛمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","بَلْطٜ تَتِ غَطَ مِنْ نغَرِي، بُلُسْ نٛدِّ مَوْٻٜ يَحُودَنْکٛعٜنْ؞ ندٜ ٻٜ کَوْرِتِ، اٛ وِعِٻٜ، ‏«‏بَنْدِرَاٻٜ!‏ کٛو ندٜ مِ وَطَنَايِ يِمْٻٜ مٜىٰطٜنْ کٛ حَانَايِ، مِ وٛنَّايِ ندٛنُوجِ مَامَعٜنْ مٜىٰطٜنْ، اَمَّا مِ نَنْغَامَ اٜ اُرُشَلِيمَ، مِ وَطَامَ ندٜرْ جُوطٜ رٛومَنْکٛعٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","ٻٜ پَمِيَمْ کٛ نغَطُمِ؞ ٻٜ تَوِي مِ وَطَايِ غٛطُّمْ کٛ حٜوْتِ مِ وَرٜىٰ، نغَمْ نٛنْ ٻٜ نغِطِ يٛوفُکِيَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","اَمَّا ندٜ يَحُودَنْکٛعٜنْ غٛنْٻٜ طٛنْ نجَٻَايِ مِ يٛوفٜىٰ، طُمْ نَنْغِ مِ تٛرٛو کِيتَ اَمْ وَدّٜىٰ تٛ کَيْسَرْ، کٛو ندٜ مِ وَلَا کٛ نغُلّٛرْتٛومِ لٜݧٛلْ اَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","کَنْجُمْ وَطِ نٛدُّمِعٛنْ نغَمْ مِ يِعَعٛنْ، مِ مٜدَّ اٜ مٛوطٛنْ؞ نغَمْ کَمُّندٜ اِسْرَاعِيلَنْکٛعٜنْ کَٻِّرَامِ ٻٛغِّ نجَمْندِ طِعِ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","يَحُودَنْکٛعٜنْ ٻٜنْ مبِعِمٛ، ‏«‏مِنْ کٜٻَايِ طٜرٜوٛلْ دَغَ لٜيْدِ يَحُودِيَ کٛلَّيْنغٛلْمِنْ حَبَرُ مَاطَ؞ کَدِمَا بٛو وَلَا کٛو غٛعٛتٛ ندٜرْ بَنْدِرَاٻٜ اَمِنْ غَرْطٛ وِعِمِنْ حَبَرُ طُمْ وٛوطَا دٛوْ مَاطَ؞ ");
INSERT INTO fuv_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","اَمَّا اٜ مِنْ نغِطِ مبِعَامِنْ ݧُمٛ مَاطَ، نغَمْ اٜ مِنْ اَنْدِ يِمْٻٜ کٛو تٛيٜ اٜ نغٜدَّ دِينَ کَ تٛکُّطَا؞»‏ ");
INSERT INTO fuv_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","ٻٜ ندٜسِ ݧَلْندٜ ندٜ ٻٜ شٛعّٛيْتٛو تٛ مَاکٛ؞ ندٜ ݧَلْندٜ ندٜنْ وَرِ، يِمْٻٜ طُطْٻٜ نغَرِ، کَوْرِتِ تٛ بُلُسْ جِڤِّي؞ اِلَا سُبَکَ حَا اَلَاسَرَ اٜ مٛ وَعَجِنَنَٻٜ، اٜ مٛ حٛکَّٻٜ حَبَرُ لَامُ اَللَّه؞ اٜ مٛ حٛلَّٻٜ حَبَرُ يٜىٰسُ ندٜرْ اَتَّوْرَ اٜ ندٜرْ دٜفْتٜ اَنَّبٛعٜنْ نغَمْ اٛ فٛوطَٻٜ ٻٜ تٛکَّ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","وٛٻّٜ ندٜرْ مَٻّٜ نجَٻِ کٛ اٛ وِعِ، وٛٻّٜ بٛو نجَٻَايِ؞ ");
INSERT INTO fuv_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","نغَمْ نٛنْ ٻٜ نغٜدّٛوتِرِ حَکُّندٜ مَٻّٜ، ٻٜ ڤُطِّ سَنْکِتَاکِ؞ اَمَّا بُلُسْ وِعِٻٜ، ‏«‏رُوحُ اَللَّه وِعِي غٛونغَ ندٜ مٜتَنِ مَامَعٜنْ مٛوطٛنْ دَغَ حٛنْدُکٛ اَنَّبِ اِشَايَ، ");
INSERT INTO fuv_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","اٛ وِعِ، ‏‹‏يَحُ تٛ يِمْٻٜ ٻٜعٜ مبِعَاٻٜ:‏ کٛو ندٜيٜ اٛنْ نَنَيْ، اَمَّا اٛنْ ڤَامَتَا؞ اٛنْ ندَارَيْ، اَمَّا اٛنْ نغِعَتَا؞ ");
INSERT INTO fuv_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","نغَمْ ٻٜرْطٜ لٜݧٛلْ نغٛعٛلْ نجٛورِي؞ ٻٜ شُکِّي نٛڤِّ مَٻّٜ، ٻٜ مَٻِّي غِتٜ مَٻّٜ، نغَمْ تٛع ٻٜ نغِعَ اٜ غِتٜ مَٻّٜ، تٛع نٛڤِّ مَٻّٜ نَنَ، تٛع ٻٜرْطٜ مَٻّٜ ڤَامَ، حَا ٻٜ نغَرْتَ تٛ اَمْ، مِ يَمْطِتِنَٻٜ؞›‏ »‏ ");
INSERT INTO fuv_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","بُلُسْ ٻٜيْدِ مٜتُکِ، وِعِ، ‏«‏سٜيْ ڤَامٛنْ، اَللَّه لِلْدِي کِسْندَمْ مُوطُمْ تٛ يِمْٻٜ نَاع يَحُودَنْکٛعٜنْ؞ کَمْٻٜ بٛو ٻٜ نجَٻَيْطُمْ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","‏‏ندٜ بُلُسْ وِعِ نٛنْ، يَحُودَنْکٛعٜنْ مبُرْتِي اٜ نغٜدّٛوتِرَ حَکُّندٜ مَٻّٜ نَاع سٜطَّ؞‏ ");
INSERT INTO fuv_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","بُلُسْ بٛو جٛوطِي دُوٻِ طِطِ ندٜرْ وُرٛ نغٛ طُمْ يٛٻَتَ طُمْ وَالَ؞ اٛ يٛٻَنِ حٛورٜ مَاکٛ؞ اٜ مٛ جَٻّٛو کٛو مٛيٜ غَرْطٛ تٛ مَاکٛ، ");
INSERT INTO fuv_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","اٜ مٛ وَعَجِنَنَٻٜ حَبَرُ لَامُ اَللَّه، اٜ مٛ اٜکِّتِنَٻٜ حَبَرُ يٜىٰسُ اَلْمَسِيحُ جٛومِرَاوٛ اٜ سٜمْبٜ، وَلَا کَطُطٛمٛ؞");
INSERT INTO fuv_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","مِنْ بُلُسْ وِنْدِ طٜرٜوٛلْ نغٛعٛلْ؞ مِ مَشُّطٛ يٜىٰسُ اَلْمَسِيحُ لِلَاطٛ مَاکٛ شُٻَاطٛ مٛ اَللَّه نٛدِّ وَعَجِنَ حَبَرُ بٜلْطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","حَبَرُ بٜلْطُمْ طُمْ اٛ وَطِ اَلْکَوَلْ کٛ نٜىٰٻِ دَغَ تٛ کٛنْدُطٜ اَنَّبٛعٜنْ مَاکٛ ندٜرْ دٜفْتٜرٜ شٜنِيندٜ؞ ");
INSERT INTO fuv_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","حَبَرُ طُعُمْ طُمْ دٛوْ ٻِطّٛ مَاکٛ جٛومِرَاوٛ مٜىٰطٜنْ يٜىٰسُ اَلْمَسِيحُ؞ ندٜرْ ٻَنْدُ کَنْکٛ دَغَ لٜݧٛلْ دَوْدَ؞ ");
INSERT INTO fuv_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","اَمَّا اَللَّه حٛلِّي اٜ بَوْطٜ مَوْطٜ يٜىٰسُ اَلْمَسِيحُ جٛومِرَاوٛ مٜىٰطٜنْ اٛ ٻِطّٛ مَاکٛ ندٜ اٛ اُمِّنِمٛ دَغَ مَيْدٜ بَرْکَ رُوحُ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","بَرْکَ يٜىٰسُ اَلْمَسِيحُ اٜ نغَمْ اِنْدٜ مَاکٛ، اَللَّه بَرْکِطِنِييَمْ وَرْتِرِييَمْ لِلَاطٛ نغَمْ لٜݧِ دُونِيَارُ فُو حٛولٛومٛ تٛکَّ کٛ اٛ وِعِ؞ ");
INSERT INTO fuv_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","طُعُمْ حَوْتِي اٜ مٛوطٛنْ اٛنٛنْ ٻٜ اَللَّه نٛدِّ نغَمْ نغَرْتَ ٻٜ يٜىٰسُ اَلْمَسِيحُ؞ ");
INSERT INTO fuv_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","اٜ مِ حٛوْنَعٛنْ اٛنْ فُو مٛوطٛنْ غٛنْٻٜ غَرِيرِ رٛومَ، اٛنٛنْ ٻٜ اَللَّه يِطِ نٛدِّ نغَمْ ٻٜ نغَرْتَ يِمْٻٜ مُوطُمْ؞ اَللَّه ݧَاکٛ مٜىٰطٜنْ اٜ جٛومِرَاوٛ مٜىٰطٜنْ يٜىٰسُ اَلْمَسِيحُ بَرْکِطِنَعٛنْ حٛکَّعٛنْ جَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","اَرَنْدٜ، اٜ مِ يٜتَّ اَللَّه اَمْ بَرْکَ يٜىٰسُ اَلْمَسِيحُ نغَمْ مٛوطٛنْ اٛنْ فُو، نغَمْ دُونِيَارُ فُو اٜ نَنَ حَبَرُ نٛ کٛولٛرِيطٛنْ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","اَللَّه مٛ کُوَنَيْمِ کُوغَلْ وَعَجِنْکِ حَبَرُ بٜلْطُمْ دٛوْ ٻِطّٛ مَاکٛ اٜ ٻٜرْندٜ اَمْ فُو، کَنْکٛ وٛنِ شٜيْدُوجٛ اَمْ، کٛو ندٜيٜ مِ يٜجِّتَتَاعٛنْ ندٜرْ دٛعَارٜ اَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","اٜ مِ تٛرٛو اَللَّه تٛ اٛ جَٻِي اٛ مَٻِّتَنَيَمْ لَاوٛلْ مِ يَحَ تٛ مٛوطٛنْ جٛونِ؞ ");
INSERT INTO fuv_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","اٜ مِ يِطِ يِيکِعٛنْ نَاع سٜطَّ نغَمْ مِ وَلَّعٛنْ کٜٻٛنْ بَرْکَ غٛنْطُمْ ندٜرْ رُوحُ اَللَّه شٜمْبِطِنَيْطُمْعٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","کٛ نغِطُمِ وٛنِ شٜمْبِطِندِرٜنْ؛ حٛولَارٜ اَمْ سٜمْبِطِنَعٛنْ، ندٜنْ حٛولَارٜ مٛوطٛنْ سٜمْبِطِنَيَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","بَنْدِرَاٻٜ اَمْ، اٜ مِ يِطِ اَنْدٛنْ ندٜ طُطُّمْ اٜ مِ سِرْيٛو يَاکِ تٛ مٛوطٛنْ، اَمَّا کٛو ندٜيٜ غٛطُّمْ اٜ حَطَيَمْ يَاکِ؞ اٜ مِ يِطِ مِ حٜٻَ تٛکُّٻٜ يٜىٰسُ ندٜرْ مٛوطٛنْ، نٛنْ نٛ کٜٻِرْمِ تٛکُّٻٜ يٜىٰسُ ندٜرْ غٛطِّ لٜݧِ؞ ");
INSERT INTO fuv_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","اٜ وٛودِ تٜدّٛرَلْ دٛوْ اَمْ، تٜدّٛرَلْ يِمْٻٜ غَرِيرِ اٜ لَدّٜعٜنْ، اٜ جَنْغُٻٜ اٜ ٻٜ نجَنْغَايِ؞ ");
INSERT INTO fuv_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","نغَمْ مَاجُمْ، مِ حَاٻِي وَعَجِنَنْکِعٛنْ حَبَرُ بٜلْطُمْ اٛنٛنْ مَا جٛوطِيٻٜ غَرِيرِ رٛومَ؞ ");
INSERT INTO fuv_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","مِ نَنَتَا شٜمْتُطُمْ وَعَجِنْکِ حَبَرُ بٜلْطُمْ، نغَمْ طُمْ بَوْطٜ اَللَّه بَاوَيْطٜ حِسْنَ کٛو مٛيٜ کٛولِيطٛمٛ؞ اَرَنْدٜ طُمْ اَنْدِنِيطُمْ يَحُودَنْکٛعٜنْ، ندٜنْ سٜيْ يِمْٻٜ نَاع يَحُودَنْکٛعٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","نغَمْ حَبَرُ بٜلْطُمْ اٜ حٛلَّ اَادِلَاکُ اَللَّه کٜٻٜتٜىٰطُمْ بَرْکَ حٛولَاکِ يٜىٰسُ تَنْ؞ نٛنْ نٛ طُمْ وِنْدِرَا، ‏«‏اَادِلِيجٛ اٛ وَطَيْ جٛنْدٜ حٛولَاکِ اَللَّه؞»‏ ");
INSERT INTO fuv_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","مٛنّٜرٜ اَللَّه اٜ وَنْغَ دَغَ دٛوْ دٛوْ يِمْٻٜ ٻٜ کُلَتَا اَللَّه اٜ دٛوْ کُوطٜ مَٻّٜ کَلُّطٜ طٜ ٻٜ ݧٛعِّرْتَ غٛونغَ؞ ");
INSERT INTO fuv_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","نغَمْ کٛ طُمْ وَاوَتَ اَنْدُکِ دٛوْ اَللَّه، اٜ نجَيْرِ طُمْ وٛنِ تٛ مَٻّٜ، نغَمْ اَللَّه حٛلِّيٻٜطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","نغَمْ دَغَ فُطّٛودٜ تَغُکِ دُونِيَارُ، نغِکُّ اَللَّه طُمْ يِعَتَاکٜ، اٜ نجَيْرِ طُمْ وٛنِ، وَاتٛ بَوْطٜ مَاکٛ تَبِتَيْطٜ، اٜ کٛ حٛلِّ اٛ اَللَّه؞ طُمْ يِعَامَ اٜ نجَيْرِ ندٜرْ کٛ اٛ تَغِ؞ نغَمْ مَاجُمْ، يِمْٻٜ نغَلَا کٛ مبِعَ؞ ");
INSERT INTO fuv_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","کٛو ندٜ اٜ ٻٜ اَنْدِ اَللَّه، ٻٜ مَوْنِنَايِمٛ بٛ اَللَّه کٛو ٻٜ نغٜتَّمٛ، اَمَّا ݧُمٛ مَٻّٜ وَرْتِي مٜىٰرٜ، ٻٜرْطٜ مَٻّٜ طٜ مبَاوَتَا فَامُکِ غٛونغَ طٜ کٜىٰوِ ݧِوْرٜ؞ ");
INSERT INTO fuv_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","اٜ ٻٜ مبِعَ اٜ ٻٜ نغٛودِ پٛيْرٜ، اَمَّا ٻٜ نغَرْتِي حَاݝَاٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","اَللَّه تَبِتَيْطٛ حَانِ ٻٜ مَوْنِنَ، اَمَّا اٜ ٻٜ مَوْنِنَ غُنْکِيجِ غَطَاطِ ندٜرْ نَنْدِ نٜطّٛ مَايَيْطٛ، اٜ ندٜرْ نَنْدِ شٛلِّ، اٜ ندٜرْ نَنْدِ مَرْلٜ، اٜ ندٜرْ نَنْدِ کٛ دَسٛتٛو؞ ");
INSERT INTO fuv_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","نغَمْ نٛنْ، اَللَّه اَلِيٻٜ ٻٜ تٛکَّ سُونٛوجِ ٻٜرْطٜ مَٻّٜ نٜفْنِيطِ نغَمْ ٻٜ نغَطِندِرَ کٛ سٜمْتِنِي اٜ ٻَلِّ مَٻّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","ٻٜ نغَيْلِتِ غٛونغَ اَللَّه وَرْتِ فٜوْرٜ؞ اٜ ٻٜ مَوْنِنَ کٛ تَغَا حَا اٜ ٻٜ کُوَنَطُمْ، اَمَّا اَللَّه تَغٛووٛ تَنْ حَانِ ٻٜ مَوْنِنَ؞ کَنْکٛ وٛنِ کَانُطٛ مَنْتٜىٰکِ حَا اَبَدَا!‏ اَامِنْ؞ ");
INSERT INTO fuv_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","نغَمْ نٛنْ، اَللَّه اَلِٻٜ ٻٜ تٛکَّ سُونٛوجِ مَٻّٜ شٜمْتِنِيطِ؞ رٜوْٻٜ مَٻّٜ نغَيْلِتِ کٛ طُمْ اَنْدِ، رٜوْٻٜ اٜ مبَلْدَ اٜ رٜوْٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","نٛنْ مَا وٛرْٻٜ اَلِ کٛ طُمْ اَنْدِ، ٻٜ اَلِ وَلْدُکِ اٜ رٜوْٻٜ، سُونٛ وٛرْٻٜ نَنْغِٻٜ؞ وٛرْٻٜ اٜ مبَلْدَ اٜ وٛرْٻٜ؞ نغَمْ نٜفْنِيطُمْ طُمْ ٻٜ نغَطَتَ، ٻٜ کٜٻِ حَلْکٜرٜ نٛ حَانَنِٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","ندٜ ٻٜ نغَݧِي ٻٜ اَنْدَ اَللَّه، اَللَّه اَلِيٻٜ ٻٜ تٛکَّ ݧُمٛوجِ کَلُّطِ نغَمْ ٻٜ نغَطَ کٛ حَانَا طُمْ وَطَ؞ ");
INSERT INTO fuv_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","اٜ ٻٜ کٜىٰوِ کٛو اِرِ طُمٜ فِي طُمْ وٛوطَا، اٜ حَلّٜىٰندٜ، اٜ يِطُکِ کٛ ٻٜ نجٜيَايِ، اٜ نغِکُّ کَلُّطُمْ، اٜ لَوْلِيرُ، اٜ وَرٜ‑وَرٜ، اٜ حَوْرٜ، اٜ مَجِّنْکِ يِمْٻٜ، اٜ ٻٜرْطٜ ٻَلٜىٰجٜ؞ اٜ ٻٜ مٜتَ دٛوْ وٛٻّٜ، ");
INSERT INTO fuv_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","اٜ ٻٜ مٜتَ کَلُّکَ دٛوْ وٛٻّٜ، اٜ ٻٜ نغَݧَ اَللَّه، اٜ ٻٜ کٛلَّ مَنْغُ، اٜ ٻٜ نغٛودِ مَنْغُ حٛورٜ، مَوْنِنٛوٻٜ کٛعٜ مَٻّٜ، اٜ ٻٜ طَٻِّتَ لَاوٛلْ وَطُکِ کٛ حَلِّ، ٻٜ مَوْنِنْتَا دَݧٛوٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","ٻٜ نغَلَا حَکِّيلٛ، ٻٜ کٜبِّنْتَا اَلْکَوَلْ، ٻٜ نغَلَا يِدّٜ، ٻٜ نجُرْمِنَنْتَا يِمْٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","اٜ ٻٜ اَنْدِ اَللَّه وِعِي يِمْٻٜ غَطٛوٻٜ اِرِ کُوطٜ طٜنْ طٛنْ اٜ حَانِ ٻٜ کَلْکٜىٰ؞ فُو اٜ نٛنْ، نَاع کُوطٜ طٜنْ تَنْ ٻٜ نغَطَتَ، حَا مَا اٜ ٻٜ مبِعَ غَطٛوٻٜ کُوطٜ طٜنْ اٜ نغَطَ کٛ وٛوطِ؞ ");
INSERT INTO fuv_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","نغَمْ نٛنْ، اَنْ، شَڤّٛتٛوطٛ کٛ وٛوطَا طُمْ غٛطّٛ وَطِ، اَ وَلَا کٛ مبِعَتَا، کٛو اَنْ اَ مٛيٜ؞ نغَمْ فُو شَرٜلْ کٛ شَڤّٛتٛطَا کٛ وٛوطَا طُمْ غٛطّٛ وَطِ، اَ وَطَنَ حٛورٜ مَاطَ کِيتَ؞ نغَمْ کٛ وٛوطَا طُمْ شَڤّٛرْتٛطَا غٛطّٛ، کَنْجُمْ نغَطَتَا اَنْ مَا؞ ");
INSERT INTO fuv_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","اٜنْ اَنْدِ کِيتَ اَللَّه طُمْ غٛونغَ دٛوْ غَطٛوٻٜ اِرِ طُمْ طٛنْ فِي؞ ");
INSERT INTO fuv_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","اَ ݧُمَ اَنْ، اَ حِسَيْ کِيتَ اَللَّه، ندٜ اَ وَطَ کٛ وٛوطَا طُمْ شَڤّٛرْتٛطَا وٛٻّٜ؟ ");
INSERT INTO fuv_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","کٛو اَنْ اَ يَوَنَ يِدّٜ اَللَّه مَوْندٜ، اٜ شِيَ يَاوُکِ مٛنّٜرٜ مَاکٛ، اٜ مُݧَلْ مَاکٛ؟ اَ اَنْدَا يِدّٜ اَللَّه اٜ فٛوطُمَا تُوبَا؟ ");
INSERT INTO fuv_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","اَمَّا ٻٜرْندٜ مَاطَ ندٜ شَاتُندٜ غَݧُندٜ تُوبُکِ؞ نغَمْ نٛنْ، اَ حَوْرِتَنَ حٛورٜ مَاطَ مٛنّٜرٜ اَللَّه، ݧَلْندٜ مٛنّٜرٜ مَاکٛ ندٜ اٛ وَطَتَ کِيتَ غٛونغَ؞ ");
INSERT INTO fuv_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","نغَمْ اٛ وَاتَنَيْ کٛو مٛيٜ کٛ فٛتِّدِ اٜ کٛ وَطِ؞ ");
INSERT INTO fuv_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","يِمْٻٜ مُݧُٻٜ ندٜرْ وَطُکِ کٛ وٛوطِ، طَٻُّتُٻٜ تٜدُّنغَلْ اٜ مَنْغُ اٜ يٛنْکِ کِ رٜعَتَا، کَمْٻٜ اَللَّه حٛکَّتَ يٛنْکِ کِ رٜعَتَا؞ ");
INSERT INTO fuv_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","اَمَّا يِمْٻٜ غِطَنْٻٜ کٛعٜ مَٻّٜ تَنْ غَݧُٻٜ غٛونغَ تٛکِّ کٛ وٛوطَا، ٻٜ کَوْرَيْ اٜ مٛنّٜرٜ اَللَّه اٜ حَلْکٜرٜ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","کٛو مٛيٜ غَطٛووٛ کٛ حَلِّ يَرَيْ تٛرَّ اٜ بٛنٜ، کٛو مٛيٜ، يَحُودَنْکٛعٜنْ اٜ يِمْٻٜ نَاع يَحُودَنْکٛعٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","اَمَّا فُو يِمْٻٜ غَطٛوٻٜ بٛطُّمْ، اَللَّه وَطَيْ ٻٜ کٜٻَ تٜدُّنغَلْ، اٜ مَنْغُ، اٜ جَمْ؛ اَرَنْدٜ يَحُودَنْکٛعٜنْ، ندٜنْ سٜيْ يِمْٻٜ نَاع يَحُودَنْکٛعٜنْ، ");
INSERT INTO fuv_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","نغَمْ اَللَّه حٛلَّتَا فٜىٰرٛوتِرٛلْ؞ ");
INSERT INTO fuv_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","کٛو مٛيٜ غَطّٛ حَکّٜ، تٛ اٛ وَلَا لٜيْ اَتَّوْرَ، اٛ وَطَنْتَاکٜ کِيتَ دٛوْ کٛ اَتَّوْرَ وِعِ؞ اَمَّا کٛو مٛيٜ غٛنْطٛ لٜيْ اَتَّوْرَ، تٛ وَطِي حَکّٜ، طُمْ وَطَنَيْمٛ کِيتَ دٛوْ کٛ اَتَّوْرَ وِعِ؞ ");
INSERT INTO fuv_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","نغَمْ نَاع نَنٛوٻٜ کٛ اَتَّوْرَ وِعِ نغٛنِ اَادِلِعٜنْ يٜىٰسٛ اَللَّه، اَمَّا تٛکُّٻٜ کٛ طُمْ وِعِ، کَمْٻٜ نٛدِّرْتٜىٰ اَادِلِعٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","تٛ يِمْٻٜ نَاع يَحُودَنْکٛعٜنْ ٻٜ نغَلَا اَتَّوْرَ نغَطِي کٛ اَتَّوْرَ وِعِ ندٜرْ يِدّٜ کٛعٜ مَٻّٜ، ٻٜ کٛلِّي اٜ ٻٜ اَنْدِ کٛ حَانِ طُمْ وَطَ، کٛو ندٜ ٻٜ نغَلَا اَتَّوْرَ؞ ");
INSERT INTO fuv_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","ٻٜ کٛلِّي کٛ اَتَّوْرَ وِعِ طُمْ وَطَ اٜ وِنْدِي ندٜرْ ٻٜرْطٜ مَٻّٜ؞ ٻٜرْطٜ مَٻّٜ مَا اٜ کٛلَّ طُمْ غٛونغَ، نغَمْ بَنْݧٜ ݧُمٛ مَٻّٜ اٜ حٛلَّٻٜ ٻٜ نغَطِي کٛ وٛوطَا، بَنْݧٜ بٛو اٜ نغٛ سُرَنَٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","نٛنْ نٛ حَبَرُ بٜلْطُمْ طُمْ نغَعَجِنْمِ وِعِ، نٛنْ وَطَيْ ݧَلْندٜ ندٜ اَللَّه وَطَنْتَ ݧُمٛوجِ شُوطِيطِ طِ يِمْٻٜ کِيتَ لَاوٛلْ يٜىٰسُ اَلْمَسِيحُ؞ ");
INSERT INTO fuv_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","اَمَّا تَا نٛدِّرَ حٛورٜ مَاطَ يَحُودَنْکٜىٰجٛ، تَا مَنْتٛرٛو اَتَّوْرَ، تَا فِيَ غَبَارٜ دٛوْ سُمْڤٛ مَاطَ اٜ اَللَّه، ");
INSERT INTO fuv_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","تَا اَنْدِ کٛ اَللَّه يِطِ نغَطَا، تَا سُٻِي کٛ ٻُرِ وٛوطُکِ نغَمْ اَ اٜکِّتِنَامَ اَتَّوْرَ، ");
INSERT INTO fuv_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","تَا تَبِّتِنِي اَنْ وٛنِ کٛلَّيْطٛ بُمْطٛ لَاوٛلْ، اَنْ وٛنِ جَيْنغٛلْ نغَمْ غٛنْٻٜ ندٜرْ ݧِوْرٜ، ");
INSERT INTO fuv_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","تَا اٜکِّتِنٛووٛ ٻٜ نغَلَا اَنْدَلْ کٛ حَانِ، تَا اٜکِّتِنٛووٛ سُکَاٻٜ، تَا تَبِّتِنِي اَ اَنْدِ کٛو طُمٜ، ندٜنْ فُو کٛ مبِعَتَا طُمْ غٛونغَ نغَمْ اَ وٛودِ اَتَّوْرَ – ");
INSERT INTO fuv_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","اَنْ اٜکِّتِنٛووٛ وٛٻّٜ، اَ اٜکِّتِنْتَا حٛورٜ مَاطَ؟ اَنْ نغَعَجِنٛووٛ دٛوْ طُمْ اَلَ نغُيْکَ، اَنْ اَ وُجَّتَا؟ ");
INSERT INTO fuv_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","اَنْ بِعٛووٛ تٛع يِمْٻٜ نغَطَ نجٜىٰنُ، اَنْ اَ وَطَتَا نجٜىٰنُ؟ اَنْ نٜفٛووٛ غُنْکِيجِ، اَنْ اَ وُجَّتَا ندٜرْ سُودُ غُنْکِيجِ؟ ");
INSERT INTO fuv_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","اَنْ ڤِيٛووٛ غَبَارٜ دٛوْ دٛوکَ اَللَّه، اَ يَوَنْتَا اَللَّه لَاوٛلْ يٜوُکِ دٛوکَ مَاکٛ؟ ");
INSERT INTO fuv_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","نٛنْ نٛ طُمْ وِنْدِرَا، ‏«‏نغَمْ مٛوطٛنْ يَحُودَنْکٛعٜنْ، يِمْٻٜ نَاع يَحُودَنْکٛعٜنْ اٜ مٜتَ حَالَ کَلُّکَ دٛوْ اَللَّه؞»‏ ");
INSERT INTO fuv_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","تَا تٛکِّي کٛ اَتَّوْرَ وِعِ، نَادُکِ مَاطَ اٜ نَفِ؞ اَمَّا تَا يٜوِي کٛ اَتَّوْرَ وِعِ، نَادُکِ مَاطَ وَرْتِي بٛ اَ نَادَاکَ؞ ");
INSERT INTO fuv_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","تٛ نٜطّٛ مٛ نَادَاکَ تٛکِّي کٛ اَتَّوْرَ وِعِ، نَاع اَللَّه يِعَيْمٛ بٛ اٛ نَادَاطٛ؟ ");
INSERT INTO fuv_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","نٜطّٛ مٛ نَادَاکَ، تٛ اٛ تٛکِّي اَتَّوْرَ، اٛ حٛلَّيْ اٛنْ نغَطِي کٛ وٛوطَا، نغَمْ اٛنْ نغٜوِ اَتَّوْرَ کٛو ندٜ اٛنْ نغٛودِطُمْ بِنْدَاطُمْ ندٜنْ اٛنْ نَادَاٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","يَحُودَنْکٜىٰجٛ مٛ غٛونغَ نَاع اٛ يَحُودَنْکٜىٰجٛ اٜ ٻَنْدُ تَنْ، کَدِنْ نَادُکِ کِ غٛونغَ نَاع اٜ ٻَنْدُ تَنْ کِ وٛنِ، کٛو اٜ تَپُکِ لَرَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","نغَمْ مَاجُمْ، يَحُودَنْکٜىٰجٛ مٛ غٛونغَ، کَنْکٛ وٛنِ يَحُودَنْکٜىٰجٛ دَغَ ندٜرْ ٻٜرْندٜ، ندٜنْ نَادُکِ کِ غٛونغَ، کَنْکِ وٛنِ نَادُکِ ٻٜرْندٜ کِ رُوحُ وَطَتَ، نَاع نغَمْ تٛکُّکِ اَتَّوْرَ بِنْدَاطُمْ؞ اِرِ اٛعٛ نٜطّٛ نَاع يِمْٻٜ مَنْتَتَمٛ، اَللَّه مَنْتَتَمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","طُمٜ يَحُودَنْکٛعٜنْ ٻُرْدِ يِمْٻٜ نَاع يَحُودَنْکٛعٜنْ؟ طُمٜ نَادُکِ نَفَتَ؟ ");
INSERT INTO fuv_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","اٜ طُمْ وٛوطِ نَاع سٜطَّ اٜ طَتٜ طُطّٜ؞ اَرَنْدٜ، يَحُودَنْکٛعٜنْ طُمْ حٛکِّ بٛلِيطٜ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","غٛونغَ، وٛٻّٜ مَٻّٜ کٛولَاکِ اَللَّه؞ اَمَّا شِيَ حٛولَاکِ مَٻّٜ وَاوَيْ وَرْتِرَ اَللَّه مٛ حٜبِّنْتَا اَلْکَوَلْ مُوطُمْ؟ ");
INSERT INTO fuv_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","غٛونغَ طُمْ وَاوَتَا!‏ اَللَّه اٛ غٛودُطٛ غٛونغَ، کٛو ندٜ کٛو مٛيٜ نٜطّٛ اٛ ڤٜوٛووٛ؞ نٛنْ نٛ طُمْ وِنْدِرَا، ‏«‏نغَمْ طُمْ تَبِّتِنَ حَالَ مَاطَ اٜ وٛودِ غٛونغَ، ندٜنْ ندٜرْ کِيتَ کٜٻَا جَالٛرْغَلْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","اَمَّا تٛ شِيَ اَادِلَاکُ مٜىٰطٜنْ وَرْتِي لَاوٛلْ تَبِّتِنْکِ اَادِلَاکُ اَللَّه، طُمٜ مبِعٜتٜنْ؟ اٜنْ مبَاوَيْ وِيکِ اَللَّه وَلَا اَادِلَاکُ تٛ اٛ تٛرِّيعٜنْ؟ ﴿اٜ مِ مٜتَ طٛعٛ نٛ يِمْٻٜ مٜتِرْتَ؞﴾ ");
INSERT INTO fuv_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","طُعُمْ وَطَتَاکٛ!‏ تٛ اَللَّه وَلَا اَادِلَاکُ، نٛ اٛ وَطِرَنْتَ دُونِيَارُ کِيتَ؟ ");
INSERT INTO fuv_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","طُمْ غَطٛتٛوطُمْ غٛطّٛ وِعَ، ‏«‏تٛ شِيَ غٛونغَ اَمْ وَلِّي يِمْٻٜ نغِعَ غٛونغَ اَللَّه اٜ نجَيْرِ حَا ٻٜ مَوْنِنِمٛ، نغَمْ طُمٜ حَا جٛونِ اٜ طُمْ وَطَنَيَمْ کِيتَ دٛوْ مِنْ مِ غَطٛووٛ حَکّٜ؟»‏ ");
INSERT INTO fuv_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","تٛ نٜطّٛ اٜ ݧُمِرَ نٛنْ، اٛ وِعَيْ، ‏«‏اٜنْ نغَطُ کٛ وٛوطَا نغَمْ طُمْ وَرْتَ لَاوٛلْ وُرْتِنْکِ غٛطُّمْ بٛطُّمْ؞»‏ غٛونغَ، وٛٻّٜ يِمْٻٜ اٜ مبِعَ اٜنْ مبِعَ نٛنْ، اَمَّا نَاع طُمْ غٛونغَ، طُمْ حُطُکِ تَنْ؞ طُمْ وَطَنَيْٻٜ کِيتَ نٛ حَانَنِٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","تٛو، طُمٜ مبِعٜتٜنْ؟ اٜنٜنْ يَحُودَنْکٛعٜنْ اٜنْ ٻُرِي يِمْٻٜ نَاع يَحُودَنْکٛعٜنْ وٛنْ طٛنْ؟ غٛونغَ نَاع نٛنْ؞ مِ يَادَکٜ مِ حٛلِّي وِيکِ يَحُودَنْکٛعٜنْ اٜ يِمْٻٜ نَاع يَحُودَنْکٛعٜنْ ٻٜ فُو لٜيْ لَامُ حَکّٜ ٻٜ نغٛنِ؞ ");
INSERT INTO fuv_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","نٛنْ نٛ طُمْ وِنْدِرَا، ‏«‏وَلَا نٜطّٛ اَادِلِيجٛ، وَلَا کٛو غٛعٛتٛ، ");
INSERT INTO fuv_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","وَلَا غٛودُطٛ فَامُ، وَلَا طَٻُّتُطٛ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","يِمْٻٜ فُو نغَيْلِتَنِي اَللَّه ٻَاوٛ، ٻٜ نغَرْتِي وَلَا کٛ ٻٜ نَفِ؞ وَلَا غَطٛووٛ کٛ وٛوطِ، وَلَا کٛو غٛعٛتٛ؞ ");
INSERT INTO fuv_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","کٛنْدُطٜ مَٻّٜ طُمْ يٜنَاندٜ اٛمْتِيندٜ؞ اٜ ٻٜ کُوتِرَ طٜمْطٜ مَٻّٜ نغَمْ مَجِّنْکِ يِمْٻٜ اٜ فٜوْرٜ؞ بٛلِيطٜ ");
INSERT INTO fuv_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","کٛنْدُطٜ مَٻّٜ اٜ کٜىٰوِ کُلّٜ اٜ بٛلِيطٜ نَوْطٜ؞ ");
INSERT INTO fuv_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","اٜ ٻٜ نجَاوَ وَرُکِ يِمْٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","فُو تٛ ٻٜ نجَحِ، حَلْکٜرٜ اٜ تٛرَّ اٜ تٛکِّٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","ٻٜ اَنْدَا لَاوٛلْ وَدُّکِ جَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","ٻٜ نغَلَا کُلٛلْ اَللَّه؞»‏ ");
INSERT INTO fuv_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","جٛونِ اٜنْ اَنْدِ کٛو طُمٜ کٛ اَتَّوْرَ وِعِ، طُمْ وِعَ نغَمْ ٻٜنْ طٛنْ غٛنْٻٜ لٜيْ اَتَّوْرَ، نغَمْ کٛو مٛيٜ مَٻَّ حٛنْدُکٛ مُوطُمْ، کَدِنْ فُو يِمْٻٜ دُونِيَارُ اَنْدَ لٜيْ کِيتَ اَللَّه ٻٜ نغٛنِ؞ ");
INSERT INTO fuv_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","نغَمْ وَلَا نٜطّٛ نٛدّٜتٜىٰطٛ اَادِلِيجٛ يٜىٰسٛ اَللَّه نغَمْ تٛکُّکِ اَتَّوْرَ، نغَمْ کٛ اَتَّوْرَ وَطَتَ وٛنِ طُمْ حٛلَّ نٜطّٛ حَکّٜ مُوطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","اَمَّا جٛونِ اَللَّه وُرْتِنِي لَاوٛلْ نغٛلْ طُمْ تٛکَّتَ طُمْ وَرْتَ اَادِلِيجٛ يٜىٰسٛ مَاکٛ؞ طُمْ حٜٻَتَا اَادِلَاکُ طُمْ نغَمْ تٛکُّکِ اَتَّوْرَ؞ اَتَّوْرَ اٜ اَنَّبٛعٜنْ کٛکِّي شٜيْدَ دٛوْ مَاجُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","طُعُمْ اَادِلَاکُ اَللَّه اٜ طُمْ حٜٻٜىٰ بَرْکَ حٛولَاکِ يٜىٰسُ اَلْمَسِيحُ؞ فُو کٛولِيطٛ يٜىٰسُ، اَللَّه وَرْتِرَيْمٛ اَادِلِيجٛ، نغَمْ اٛ حٛلَّتَا فٜىٰرٛوتِرٛلْ؞ ");
INSERT INTO fuv_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","کٛو مٛيٜ نٜطّٛ وَطِ حَکّٜ وٛطِّتَکٜ کٛ اَللَّه يِطِ اٛ وَطَ؞ ");
INSERT INTO fuv_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","اَمَّا جٛونِ اَللَّه وَرْتِرِيعٜنْ اَادِلِعٜنْ؞ اٛ وَطَنِيعٜنْ نٛنْ شَاحُ نغَمْ يِدّٜ مَاکٛ بَرْکَ رِمْطِنْکِ کٜٻٜتٜىٰکِ لَاوٛلْ يٜىٰسُ اَلْمَسِيحُ؞ ");
INSERT INTO fuv_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","اَللَّه لِلِي يٜىٰسُ اَلْمَسِيحُ وَرْتَ شَکِّرِ، نغَمْ تٛ يِمْٻٜ کٛولَکٜمٛ طُمْ يَافَنٛوٻٜ حَکّٜ مَٻّٜ بَرْکَ پِيپَمْ مَاکٛ؞ اَللَّه وَطِي طُعُمْ نغَمْ حٛلَّ اَادِلَاکُ مُوطُمْ؞ نغَمْ ندٜنّٛ اٛ مُݧَنِي غَطُٻٜ حَکّٜ اٛ تَپَنَايِٻٜ کِيتَ؞ ");
INSERT INTO fuv_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","اٛ وَطُ نٛنْ نغَمْ اٜ شَرٜلْ نغٜلْ اٛ حٛلَّ کَنْکٛ اٜ حٛورٜ مَاکٛ اٛ اَادِلِيجٛ، ندٜنْ اٜ مٛ وَطَ کٛو مٛيٜ کٛولِيطٛ يٜىٰسُ وَرْتَ اَادِلِيجٛ؞ ");
INSERT INTO fuv_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","نغَمْ نٛنْ، وَلَا غٛطُّمْ طُمْ غٛطّٛ مَنْتٛرْتٛو؞ نغَمْ طُمٜ؟ نغَمْ اٜنْ نغَرْتَايِ اَادِلِعٜنْ نغَمْ کُوطٜ مٜىٰطٜنْ، سٜيْ نِ نغَمْ اٜنْ کٛولَکٜ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","نغَمْ اٜنْ اَنْدِ نٜطّٛ وَرْتَيْ اَادِلِيجٛ يٜىٰسٛ اَللَّه تٛ حٛولَکٜ يٜىٰسُ، نَاع نغَمْ تٛکُّکِ اَتَّوْرَ؞ ");
INSERT INTO fuv_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","کٛو اَللَّه اٛ اَللَّه يَحُودَنْکٛعٜنْ تَنْ؟ نَاع فُو کَنْکٛ وٛنِ اَللَّه يِمْٻٜ نَاع يَحُودَنْکٛعٜنْ؟ غٛونغَ، اٛ اَللَّه يِمْٻٜ نَاع يَحُودَنْکٛعٜنْ، کَمْٻٜ مَا؞ ");
INSERT INTO fuv_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","اَللَّه اٛ غٛعٛتٛ، غَرْتِرَيْطٛ يَحُودَنْکٛعٜنْ اَادِلِعٜنْ يٜىٰسٛ مَاکٛ تٛ ٻٜ کٛولَکٜ يٜىٰسُ؞ نٛنْ مَا يِمْٻٜ نَاع يَحُودَنْکٛعٜنْ، اٛ وَرْتِرَيْٻٜ اَادِلِعٜنْ تٛ ٻٜ کٛولَکٜ يٜىٰسُ؞ ");
INSERT INTO fuv_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","تٛ طُمْ نٛنْ، اٜنْ اَلَيْ تٛکُّکِ اَتَّوْرَ نغَمْ اٜنْ کٛولَکٜ يٜىٰسُ؟ طُمْ وَطَتَاکٛ!‏ سٜيْ نِ، اٜنْ تَبِّتِنَطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","تٛو، طُمٜ مبِعٜتٜنْ دٛوْ اِبْرَاهِمْ، مَامَ مٜىٰطٜنْ؟ ");
INSERT INTO fuv_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","تٛ اَللَّه وَرْتِرِي اِبْرَاهِمْ اَادِلِيجٛ نغَمْ کٛ اٛ وَطِ، اٛ حٜٻَيْ کٛ اٛ مَنْتٛرْتٛو، اَمَّا نَاع يٜىٰسٛ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","اَايَارٜ وِعِ، ‏«‏اِبْرَاهِمْ حٛولَکٜ اَللَّه؛ نغَمْ مَاجُمْ اَللَّه وِعِ اٛ اَادِلِيجٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","نٜطّٛ کُوٛووٛ نغَمْ يٛٻٜىٰ، طُمْ حٛشَّتَا کٛ اٛ يٛٻَا بٛ شَاحُ، اَمَّا بٛ غٛطُّمْ طُمْ اٛ حٜٻَنِ حٛورٜ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","نٜطّٛ مٛ وَطَايِ ٻٜرْندٜ مُوطُمْ دٛوْ کُوطٜ مُوطُمْ، اَمَّا اٛ وَطِ ٻٜرْندٜ مَاکٛ دٛوْ اَللَّه غَطٛووٛ غَطٛوٻٜ حَکّٜ نغَرْتَ اَادِلِعٜنْ، طُمْ نٛدَّيْ حٛولَاکِ مَاکٛ اَادِلَاکُ؞ ");
INSERT INTO fuv_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","نٛنْ دَوْدَ وِعِ ندٜ اٛ مٜتِ دٛوْ نٜطّٛ بَرْکِطِنَاطٛ مٛ اَللَّه نٛدِّ اَادِلِيجٛ نَاع نغَمْ کُوطٜ مَاکٛ؞ اٛ وِعِي، ");
INSERT INTO fuv_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","‏«‏ٻٜ بَرْکِطِنَاٻٜ يِمْٻٜ ٻٜ طُمْ يَافَنِي کٛ وٛوطَا طُمْ ٻٜ نغَطِ، ٻٜ حَکّٜ مُعّٜنْ نجَافَا؞ ");
INSERT INTO fuv_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","اٛ بَرْکِطِنَاطٛ مٛ جٛومِرَاوٛ لِمَتَا حَکّٜ مَاکٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","تٛو، بَرْکَ طُعُمْ، يَحُودَنْکٛعٜنْ تَنْ کٜٻَتَطُمْ، کٛو حَا اٜ يِمْٻٜ نَاع يَحُودَنْکٛعٜنْ؟ اٜنْ مبِعِي، ‏«‏اِبْرَاهِمْ حٛولَکٜ اَللَّه؛ نغَمْ مَاجُمْ اَللَّه وِعِ اٛ اَادِلِيجٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","ندٜيٜ فِي طُعُمْ وَطِ؟ کٛ اِبْرَاهِمْ نَادٜىٰ، کٛو غَطَ اٛ نَادَامَ؟ کٛ اٛ نَادٜىٰ طُمْ وَطِ، نَاع غَطَ اٛ نَادَامَ؞ ");
INSERT INTO fuv_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","نَادُکِ کِ اٛ وَطَنَا وٛنِ اَلَامَ کٛلُّطُمْ اَللَّه جَٻِي اٛ اَادِلِيجٛ نغَمْ اٛ حٛولَکٜمٛ کٛ اٛ نَادٜىٰ؞ نغَمْ مَاجُمْ، اِبْرَاهِمْ وٛنِ ݧَاکٛ کٛو مٛيٜ کٛولِيطٛ اَللَّه مٛ اَللَّه وَرْتِرِ اَادِلِيجٛ، کٛو اٛ نَادَاکَ؞ ");
INSERT INTO fuv_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","نٛنْ مَا کَنْکٛ وٛنِ ݧَاکٛ ٻٜنْ طٛنْ نَادَاٻٜ، نَاع نغَمْ ٻٜ نَادَاٻٜ، اَمَّا نغَمْ ٻٜ کٛولَکٜ اَللَّه اِرِ حٛولَاکِ کِ اٛ وٛودِ کٛ اٛ نَادٜىٰ؞ ");
INSERT INTO fuv_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","اَللَّه وَطَنِي اِبْرَاهِمْ اٜ ٻِٻّٜ ٻِٻّٜىٰجِ مَاکٛ اَلْکَوَلْ وِيکِ کَمْٻٜ ندٛنَتَ دُونِيَارُ؞ اَللَّه وَطِي اَلْکَوَلْ نغَعَلْ نَاع نغَمْ اِبْرَاهِمْ اٜ تٛکَّ کٛ اَتَّوْرَ وِعِ، اَمَّا نغَمْ اَادِلَاکُ کٜٻٜتٜىٰطُمْ بَرْکَ حٛولَاکِ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","تٛ تٛکّٛوٻٜ اَتَّوْرَ نغٛنِ دٛنٛوٻٜ دُونِيَارُ، حٛولَارٜ نٜطّٛ وَرْتِي مٜىٰرٜ، ندٜنْ اَلْکَوَلْ اَللَّه وَرْتِي کٛو کٛ نَفِ؞ ");
INSERT INTO fuv_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","اَتَّوْرَ اٜ وَدَّ مٛنّٜرٜ اَللَّه، اَمَّا فُو تٛ دٛوکَ وَلَا، نَاع نٛ طُمْ وَطَتَ طُمْ يٜوَ دٛوکَ؞ ");
INSERT INTO fuv_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","نغَمْ نٛنْ، يِمْٻٜ کٛولِيٻٜ اَللَّه نغٛنِ کٜٻٛوٻٜ کٛ اٛ وَطِ اَلْکَوَلْ، نغَمْ طُمْ حٜٻَ کٛ اٛ وَطِ اَلْکَوَلْ شَاحُ، ندٜنْ فُو ٻِٻّٜ ٻِٻّٜىٰجِ اِبْرَاهِمْ تَبِّتِنَ حٜٻُکِطُمْ، نَاع تٛکّٛوٻٜ اَتَّوْرَ تَنْ، اَمَّا حَا اٜ کٛولِيٻٜ اَللَّه نٛنْ نٛ اِبْرَاهِمْ حٛولٛرِيمٛ؞ نغَمْ اِبْرَاهِمْ وٛنِ ݧَاکٛ مٜىٰطٜنْ اٜنْ فُو؞ ");
INSERT INTO fuv_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","نٛنْ نٛ طُمْ وِنْدِرَا، ‏«‏مِ وَرْتِرِيمَ ݧَاکٛ لٜݧِ طُطِّ؞»‏ کَنْکٛ وٛنِ ݧَاکٛ مٜىٰطٜنْ يٜىٰسٛ اَللَّه مٛ اٛ حٛولِي، اَللَّه کٛکّٛووٛ مَيْٻٜ يٛنْکِ، نٛدّٛووٛ کٛ وَلَا سٜيْ طُمْ وَنْغَ؞ ");
INSERT INTO fuv_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","اِبْرَاهِمْ حٛولَکٜ اَللَّه، اٛ وَطِي کَمُّندٜ کٛو ندٜ وَلَا دَلِيلَ وَطُکِ کَمُّندٜ مَاکٛ؞ نغَمْ مَاجُمْ، اٛ وَرْتِي ‏«‏ݧَاکٛ لٜݧِ طُطِّ،»‏ نٛنْ نٛ اٛ وِعَا، ‏«‏تَانِرَاٻٜ مَاطَ طُوطِرَيْ بٛ کٛودٜ دٛوْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","اٛ اَلَايِ حٛولَاکِ اَللَّه، کٛو ندٜ اٛ يِعِ ٻَنْدُ مَاکٛ سٛمِي نغَمْ اٛ ٻَدَکٜ دُوٻِ 100، ندٜنْ دٜبّٛ مَاکٛ سَارَتُ دَݧَتَا؞ ");
INSERT INTO fuv_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","اٛ وَطَايِ سٜکٛ دٛوْ کٛ اَللَّه وَطَنِمٛ اَلْکَوَلْ، اَمَّا اٛ ٻٜيْدِي حٛولَاکِ اَللَّه، اٛ مَنْتِيمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","اٛ تَبِّتِنِي اَللَّه وَاوَيْ وَطَ کٛ وَطِ اَلْکَوَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","نغَمْ اِبْرَاهِمْ حٛولَکٜ اَللَّه، ‏«‏اَللَّه وِعِ اٛ اَادِلِيجٛ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","بٛلِيطٜ بِيطٜ ‏«‏اَللَّه وِعِ اٛ اَادِلِيجٛ،»‏ نَاع نغَمْ مَاکٛ تَنْ طٜ مبِنْدَا؞ ");
INSERT INTO fuv_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","طٜ مبِنْدَامَ نغَمْ مٜىٰطٜنْ اٜنٜنْ مَا ٻٜ اَللَّه وَرْتِرْتَ اَادِلِعٜنْ، اٜنٜنْ کٛولِيٻٜ اُمِّنْطٛ يٜىٰسُ جٛومِرَاوٛ مٜىٰطٜنْ دَغَ مَيْدٜ؞ ");
INSERT INTO fuv_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","اٛ وَرَامَ نغَمْ حَکّٜ مٜىٰطٜنْ، ندٜنْ اٛ اُمِّنَامَ دَغَ مَيْدٜ نغَمْ نغَرْتٜنْ اَادِلِعٜنْ يٜىٰسٛ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","نغَمْ نٛنْ، ندٜ اَللَّه وَرْتِرِعٜنْ اَادِلِعٜنْ نغَمْ اٜنْ کٛولَکٜ يٜىٰسُ اَلْمَسِيحُ، اٜنْ شِرْيٛوتِرِي اٜ اَللَّه بَرْکَ جٛومِرَاوٛ مٜىٰطٜنْ يٜىٰسُ اَلْمَسِيحُ؞ ");
INSERT INTO fuv_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","بَرْکَ مَاکٛ کٜٻُطٜنْ لَاوٛلْ حٜٻُکِ طُعُمْ شَاحُ اَللَّه طُمْ غٛنْطٜنْ ندٜرْ جٛونِ؞ طٛنْمَا اٜنْ مبٜلْمبٜلْتَ نغَمْ اٜنْ تَبِّتِنِي اَللَّه حٛلَّيْعٜنْ تٜدُّنغَلْ مُوطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","نَاع نٛنْ تَنْ، حَا مَا اٜنْ مبٜلْمبٜلْتَ ندٜرْ تٛرَّاجِ طِ نجَرٜتٜنْ، نغَمْ اٜنْ اَنْدِ يَرُکِ تٛرَّاجِ اٜ وَدَّ مُݧَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","تٛ اٜنْ مُݧِي ندٜرْ تٛرَّ، اٜنْ کٜٻَيْ نغِکُّ طُمْ اَللَّه يِطِ، تٛ اٛ يِطِي نغِکُّ مٜىٰطٜنْ، نٛنْ وَطَيْ نغَطٜنْ کَمُّندٜ؞ ");
INSERT INTO fuv_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","کَمُّندٜ ندٜنْ سٜمْتِنْتَاعٜنْ، نغَمْ اَللَّه حٛلِّعٜنْ اٜ مٛ يِطِعٜنْ ندٜرْ ٻٜرْطٜ مٜىٰطٜنْ بَرْکَ رُوحُ مَاکٛ، طُمْ اٛ حٛکِّعٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","ندٜرْ شَرٜلْ نغٜلْ تَمْڤُطٜنْ، اَلْمَسِيحُ مَايِي نغَمْ غَطٛوٻٜ حَکّٜ ندٜرْ شَرٜلْ نغٜلْ اَللَّه سُٻِ؞ ");
INSERT INTO fuv_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","اٜ طُمْ سَطِ غٛطّٛ مَايَ نغَمْ اَادِلِيجٛ؞ سٜيْ نِ طُمْ غَطٛتٛوطُمْ غٛطّٛ وَطَ سٜمْبٜ ٻٜرْندٜ مَايَ نغَمْ نٜطّٛ مٛ نغِکُّ بٛطُّمْ؞ ");
INSERT INTO fuv_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","اَمَّا لَاوٛلْ نغٛلْ اَللَّه حٛلِّيعٜنْ يِدّٜ مَاکٛ وٛنِ، شَرٜلْ کٛ نغٛنْطٜنْ ندٜرْ حَکّٜ، اَلْمَسِيحُ مَايِي نغَمْ مٜىٰطٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","ندٜ جٛونِ اٜنْ نغَرْتِي اَادِلِعٜنْ بَرْکَ پِيپَمْ اَلْمَسِيحُ، فِي ٻُرْطُمْ تَبُّتُکِ وٛنِ اٛ حِسْنَيْعٜنْ دَغَ مٛنّٜرٜ اَللَّه غَرَيْندٜ؞ ");
INSERT INTO fuv_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","ندٜنّٛ اٜنْ وَݧْوَݧْٻٜ اَللَّه، اَمَّا طُمْ سِرْيٛوتِرِيعٜنْ اٜ مَاکٛ بَرْکَ مَيْدٜ ٻِطّٛ مَاکٛ؞ جٛونِ ندٜ اٜنْ شِرْيٛوتِرِي اٜ اَللَّه، اٜنْ ٻُرَيْ تَبِّتِنْکِ اَلْمَسِيحُ حِسْنَيْعٜنْ نغَمْ اٜ مٛ فٛوفَ؞ ");
INSERT INTO fuv_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","اَمَّا نَاع کَنْجُمْ تَنْ، حَا مَا اٜنْ نَنَ بٜلْطُمْ نغَمْ کٛ اَللَّه وَطِ بَرْکَ جٛومِرَاوٛ مٜىٰطٜنْ يٜىٰسُ اَلْمَسِيحُ، شِرْيٛوتِرْطٛعٜنْ اٜ اَللَّه جٛونِ؞ ");
INSERT INTO fuv_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","حَکّٜ نَتِّي ندٜرْ دُونِيَارُ ندُعُ لَاوٛلْ نٜطّٛ غٛعٛتٛ؞ حَکّٜ طُمْ اٛ وَطِ نغَدِّي مَيْدٜ؞ نٛنْ کٛو مٛيٜ وَرْتِي مَايَيْطٛ، نغَمْ کٛو مٛيٜ وَطِي حَکّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","غٛونغَ، کٛ اَتَّوْرَ وَدّٜىٰ، حَکّٜ اٜ طٛنْ ندٜرْ دُونِيَارُ، اَمَّا اَللَّه جٛغَتَاکٛ حَکّٜ نٜطّٛ ندٜرْ ٻٜرْندٜ مُوطُمْ تٛ دٛوکَ وَلَا؞ ");
INSERT INTO fuv_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","فُو اٜ نٛنْ، دَغَ جَامَنُ اَادَمُ يَاکِ جَامَنُ مُوسَ، مَيْدٜ لَامَکٜ دٛوْ کٛو مٛيٜ، حَا اٜ دٛوْ يِمْٻٜ ٻٜ نغَطَايِ حَکّٜ اِرِ طُمْ اَادَمُ وَطِ؞ اَادَمُ وٛنِ مِسَالُ اٛنْ طٛنْ غَرَيْطٛ؞ ");
INSERT INTO fuv_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","اَمَّا شَاحُ طُمْ اَللَّه حٛکَّتَ طُمْ نَنْدَا اٜ حَکّٜ اَادَمُ؞ يِمْٻٜ طُطْٻٜ مَايِي نغَمْ حَکّٜ نٜطّٛ غٛعٛتٛ، اَمَّا يِدّٜ اَللَّه ٻُرِي مَوْنُکِ نَاع سٜطَّ، نٛنْ مَا شَاحُ طُمْ اٛ حٛکَّتَ يِمْٻٜ طُطْٻٜ بَرْکَ نٜطّٛ غٛعٛتٛ، وَاتٛ يٜىٰسُ اَلْمَسِيحُ؞ ");
INSERT INTO fuv_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","شَاحُ اَللَّه اٜ فٜىٰرٛوتِرِ اٜ کٛ حَکّٜ طُمْ نٜطّٛ غٛعٛتٛ فٛوطِ؞ نغَمْ کِيتَ اَللَّه تٛکُّطُمْ غَطَ حَکّٜ طُمْ اَادَمُ وَطِ وٛنِ کِيتَ حَلْکٜرٜ، اَمَّا شَاحُ طُمْ اَللَّه حٛکِّ، کَنْجُمْ طُمْ وَرْتِرِعٜنْ اَادِلِعٜنْ کٛو ندٜ اٜنْ نغَطِي حَکّٜ نَاع سٜطَّ؞ ");
INSERT INTO fuv_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","نغَمْ حَکّٜ طُمْ نٜطّٛ غٛعٛتٛ وَطِ، مَيْدٜ فُطِّ لَامَاکِ دٛوْ کٛو مٛيٜ؞ اَمَّا لَامُ طُمْ، طُمْ حٜوْتَايِ کٛو طُمٜ تٛ طُمْ حَوْتَامَ اٜ لَامُ طُمْ نٜطّٛ غٛعٛتٛ وَدِّ، وَاتٛ يٜىٰسُ اَلْمَسِيحُ؞ کٛو مٛيٜ مٛ اَللَّه حٛلِّ يِدّٜ مَوْندٜ وَرْتِرِيمٛ اَادِلِيجٛ شَاحُ، اٛ حٜٻَيْ جَالٛرْغَلْ دٛوْ حَکّٜ بَرْکَ اَلْمَسِيحُ؞ ");
INSERT INTO fuv_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","نغَمْ نٛنْ، نٛنْ نٛ حَکّٜ نٜطّٛ غٛعٛتٛ فٛوطِرَنِ فُو يِمْٻٜ کِيتَ حَلْکٜرٜ، نٛنْ مَا کُوغَلْ اَادِلَاکُ نغَلْ نٜطّٛ غٛعٛتٛ وَطِ وَرْتِرِي يِمْٻٜ طُطْٻٜ اَادِلِعٜنْ حٛکِّيٻٜ يٛنْکِ کٜسِ؞ ");
INSERT INTO fuv_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","نٛنْ نٛ يِمْٻٜ طُطْٻٜ نغَرْتِ غَطٛوٻٜ حَکّٜ نغَمْ نٜطّٛ غٛعٛتٛ وَݧِي کٛ اَللَّه وِعِ، نٛنْ مَا يِمْٻٜ طُطْٻٜ نغَرْتَيْ اَادِلِعٜنْ نغَمْ نٜطّٛ غٛعٛتٛ وَطِي کٛ اَللَّه يِطِ؞ ");
INSERT INTO fuv_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","اَتَّوْرَ وَدَّامَ نغَمْ کٛ وٛوطَا طُمْ يِمْٻٜ نغَطَتَ وُرْتٛو اٜ نجَيْرِ؞ اَمَّا فُو تٛ حَکّٜ ٻٜيْدِي، سٜيْ يِدّٜ اَللَّه ٻُرَ ٻٜيْدَاکِ؞ ");
INSERT INTO fuv_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","حَکّٜ لَامَکٜ يِمْٻٜ نغَمْ طُمْ ڤٛوطَنِيٻٜ مَيْدٜ؞ اَمَّا جٛونِ يِدّٜ اَللَّه اٜ لَامٛو لَاوٛلْ اَادِلَاکُ، ندٜنْ اَللَّه جَٻِيعٜنْ بَرْکَ يٜىٰسُ اَلْمَسِيحُ جٛومِرَاوٛ مٜىٰطٜنْ؞ نٛنْ وَطَيْ کٜٻٜنْ يٛنْکِ کِ رٜعَتَا؞ ");
INSERT INTO fuv_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","تٛو، طُمٜ مبِعٜتٜنْ؟ اٜنْ نغَطَيْ کَ وَطُکِ حَکّٜ نغَمْ يِدّٜ اَللَّه ٻٜيْدٛو؟ ");
INSERT INTO fuv_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","غٛونغَ نَاع نٛنْ!‏ حَانَا ݧَمْرٜنْ يٜىٰسٛ اٜ وَطُکِ حَکّٜ، نغَمْ اٜنْ نجَادَکٜ اٜنْ نغَرْتِي بٛ مَيْٻٜ تٛ حَکّٜ؞ نٛ وَطَتَ کَدِنْ اٜنْ ݧَمْرَ يٜىٰسٛ اٜ جٛنْدٜ ندٜرْ حَکّٜ؟ ");
INSERT INTO fuv_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","غٛونغَ اٛنْ اَنْدِ ندٜ طُمْ وَطَنِيعٜنْ بَڤْتِسْمَ نغَمْ شُمْڤٛوتِرٜنْ اٜ يٜىٰسُ اَلْمَسِيحُ، اٜنْ نغَطَنَ بَڤْتِسْمَ نغَمْ اٜنْ مَيْدِ اٜ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","نغَمْ نٛنْ، بَڤْتِسْمَ طُمْ اُمْ وَطَنِعٜنْ بٛ طُمْ اُوُدُعٜنْ اٜ مَاکٛ، ندٜنْ اٜنْ نغَرْتِي غٛعٛ اٜ مَاکٛ ندٜرْ مَيْدٜ مَاکٛ، نغَمْ، نٛنْ نٛ تٜدُّنغَلْ ݧَاکٛ مٜىٰطٜنْ مٛ دٛوْ اُمِّنِرِ اَلْمَسِيحُ دَغَ مَيْدٜ، نٛنْ اٜنٜنْ مَا اٜنْ نغَطُ جٛنْدٜ حٜيْرٜ؞ ");
INSERT INTO fuv_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","نغَمْ تٛ اٜنْ نغَرْتِي غٛعٛ اٜ اَلْمَسِيحُ ندٜرْ مَيْدٜ اِرِ ندٜ مَاکٛ، نٛنْ مَا اٜنْ تَبِّتِنِي اٜنْ نغَرْتَيْ غٛعٛ اٜ مَاکٛ ندٜرْ اُمَّاکِ دَغَ مَيْدٜ نٛ اٛ اُمّٛرِي؞ ");
INSERT INTO fuv_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","اٜنْ اَنْدِ نغِکُّ مٜىٰطٜنْ طُمْ ندٜنّٛ طُمْ وَرْدَامَ اٜ اَلْمَسِيحُ دٛوْ غَافَانغَلْ، نغَمْ ٻَنْدُ مٜىٰطٜنْ ندُ حَکّٜ حَلْکٜىٰ، نغَمْ تٛع ڤُطِّتٜنْ نغَرْتٜنْ مَشُّٻٜ حَکّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","نغَمْ فُو مَيْطٛ، حَکّٜ وَلَا بَوْطٜ دٛوْ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","تٛ اٜنْ مَيْدِي اٜ اَلْمَسِيحُ، اٜنْ تَبِّتِنِي اٜنْ نجٛوطٛدٛتٛ اٜ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","نغَمْ اٜنْ اَنْدِ اَلْمَسِيحُ اُمِّنَامَ دَغَ مَيْدٜ، ندٜنْ اٛ فُطِّتَتَا اٛ مَايَ کَدِنْ؞ مَيْدٜ فُطِّتَتَا حٜٻَ بَوْطٜ دٛوْ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","مَيْدٜ ندٜ اٛ مَايِ اٛ مَايُ ندٜ غٛعٛ نغَمْ اٛ يٜوَ سٜمْبٜ حَکّٜ حَا اَبَدَا، ندٜنْ جٛنْدٜ ندٜ اٛ وَطَتَ جٛونِ اٜ مٛ وَطَندٜ ندٜرْ سُمْڤٛوتِرْکِ اٜ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","نٛنْ اٛنٛنْ مَا، دٛولٜ کٛشّٜىٰ کٛعٜ مٛوطٛنْ بٛ مَيْٻٜ ٻٜ بَوْطٜ حَکّٜ لَامَاکِ دٛوْ مَٻّٜ، اَمَّا جٛونِ اٛنْ نغَطَ جٛنْدٜ نغَمْ نغَطٛنْ کٛ اَللَّه يِطِ بَرْکَ سُمْڤٛوتِرْکِ اٜ يٜىٰسُ اَلْمَسِيحُ؞ ");
INSERT INTO fuv_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","نغَمْ نٛنْ، تٛع اٛنْ اَلُ حَکّٜ لَامٛو دٛوْ ٻَلِّ مٛوطٛنْ مَايَيْطِ حَا تٛکّٛنْ کٛ سُونٛ ٻَلِّ مٛوطٛنْ نغِطِ؞ ");
INSERT INTO fuv_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","تٛع اٛنْ ڤُطُّتُ اَلَنٛنْ حَکّٜ وٛنْدٜ جٛکّٛودٜ ٻَنْدُ مٛوطٛنْ ندٜ حُوتِرٜىٰ فِي کَلُّطُمْ؞ اَمَّا کٛکّٜىٰ اَللَّه کٛعٜ مٛوطٛنْ بٛ يِمْٻٜ ٻٜ طُمْ اُمِّنِ دَغَ مَيْدٜ يَاکِ يٛنْکِ، ندٜنْ کٛکّٛنْمٛ فُو کٛعٜ مٛوطٛنْ نغَمْ اٛ حُوتِرَعٛنْ کُوطٜ اَادِلَاکُ؞ ");
INSERT INTO fuv_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","نغَمْ حَکّٜ حٜٻَتَا جَالٛرْغَلْ دٛوْ مٛوطٛنْ، ندٜ نَاع لٜيْ اَتَّوْرَ نغٛنْطٛنْ، اَمَّا لٜيْ يِدّٜ اَللَّه نغٛنْطٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","طُمٜ نغَطٜتٜنْ؟ اٜنْ نغَطَيْ حَکّٜ نغَمْ لٜيْ يِدّٜ اَللَّه غٛنْطٜنْ نَاع لٜيْ اَتَّوْرَ؟ تٛع اٜنْ نغَطُ نٛنْ!‏ ");
INSERT INTO fuv_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","غٛونغَ اٛنْ اَنْدِ تٛ اٛنْ تٛکِّي کٛ غٛطّٛ وِعِعٛنْ نٛ مَشُّٻٜ نغَطَتَ، اٛنْ نغَرْتِي مَشُّٻٜ اٛنْ طٛنْ مٛ نغَطٛتٛنْ کٛ وِعِ، کٛو حَکّٜ ڤٛوطَيْطُمْ مَيْدٜ، کٛو وَطُکِ کٛ اَللَّه يِطِ غَرْتِرَيْطُمْ نٜطّٛ اَادِلِيجٛ؞ ");
INSERT INTO fuv_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","اَمَّا يٜتّٛورٜ تَبِّتَنَ اَللَّه، نغَمْ ندٜنّٛ اٛنْ مَشُّٻٜ حَکّٜ، اَمَّا جٛونِ اٛنْ تٛکَّ اٜکِّتِنٛلْ نغٛلْ طُمْ اٜکِّتِنِعٛنْ اٜ ٻٜرْطٜ مٛوطٛنْ فُو؞ ");
INSERT INTO fuv_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","اٛنْ ندِمْطِنَامَ دَغَ وَطُکِ حَکّٜ، اٛنْ نغَرْتِي مَشُّٻٜ اَادِلَاکُ؞ ");
INSERT INTO fuv_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","اٜ مِ حُوتِرَ بٛلِيطٜ طٜ شَطَا نغَمْ اٛنْ شٜمْبِطَا؞ ندٜنّٛ اٛنْ نغَرْتِرِي کٛعٜ مٛوطٛنْ مَشُّٻٜ وَطُکِ فِي نٜفْنِيطُمْ اٜ فِي کَلُّطُمْ غَطُطُمْ کَ ٻٜيْدَاکِ نَاع سٜطَّ؞ نٛنْ مَا، جٛونِ نغَرْتِرٜىٰ کٛعٜ مٛوطٛنْ مَشُّٻٜ اَادِلَاکُ نغَمْ نغَطٛنْ جٛنْدٜ شٜنِيندٜ؞ ");
INSERT INTO fuv_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","کٛ نغٛنّٛوطٛنْ مَشُّٻٜ حَکّٜ، وَلَا کٛ وَنِّعٛنْ اٜ کُوطٜ اَادِلَاکُ؞ ");
INSERT INTO fuv_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","ندِيٜ ٻٜيْدَارِ کٜٻُطٛنْ ندٜرْ کٛ نغَطَيْنٛوطٛنْ ندٜنّٛ طُمْ شٜمْتٛتٛنْ جٛونِ؟ کٛ فِي طُمْ طٛنْ فٛوطَتَ وٛنِ مَيْدٜ!‏ ");
INSERT INTO fuv_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","اَمَّا جٛونِ ندٜ طُمْ رِمْطِنِيعٛنْ دَغَ حَکّٜ، ندٜنْ اٛنْ نغَرْتِي مَشُّٻٜ اَللَّه، ٻٜيْدَارِ ندِ کٜٻٛتٛنْ وٛنِ جٛنْدٜ لَمْندٜ، ندٜنْ اٜ رٜعِرْدٜ کٜٻٛنْ يٛنْکِ کِ رٜعَتَا؞ ");
INSERT INTO fuv_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","نغَمْ نجٛٻَارِ حَکّٜ طُمْ مَيْدٜ، اَمَّا شَاحُ اَللَّه وٛنِ يٛنْکِ کِ رٜعَتَا کٜٻٜتٜىٰکِ بَرْکَ سُمْڤٛوتِرْکِ اٜ يٜىٰسُ اَلْمَسِيحُ جٛومِرَاوٛ مٜىٰطٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","بَنْدِرَاٻٜ اَمْ، ندٜ اٛنْ فُو اٛنْ اَنْدِ دٛوکَ، اٛنْ ڤَامَيْ کٛ نغِطْمِ وِيکِ؞ دٛوکَ اٜ لَامٛو دٛوْ نٜطّٛ تٛ اٜ مٛ فٛوفَ تَنْ؞ ");
INSERT INTO fuv_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","مِسَالُ، دٜبّٛ تٜىٰغَلْ دٛوکَ حَٻِّيمٛ اٜ غٛرْکٛ مَاکٛ تٛ نِ غٛرْکٛ اٛنْ اٜ فٛوفَ؞ اَمَّا تٛ غٛرْکٛ اٛنْ مَايِي، دٜبّٛ اٛنْ فِتَّکٜ دَغَ دٛوکَ کَٻِّندِرْطُمّٛ اٜ غٛرْکٛ اٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","نغَمْ نٛنْ، تٛ غٛرْکٛ مَاکٛ اٜ فٛوفَ اٛ جٛوطٛدِي اٜ غٛرْکٛ فٜىٰرٜ، طُمْ نٛدِّرَيْمٛ غَطٛووٛ نجٜىٰنُ؞ اَمَّا تٛ غٛرْکٛ مَاکٛ مَايِي، دٛوکَ يٛوفِيمٛ، ندٜنْ تٛ اٛ تٜىٰرِي اٜ غٛطّٛ فٜىٰرٜ، نَاع نجٜىٰنُ اٛ وَطَتَ؞ ");
INSERT INTO fuv_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","بَنْدِرَاٻٜ اَمْ، دٛوْ اَتَّوْرَ، اٛنْ نغَرْتِي بٛ مَيْٻٜ بَرْکَ مَيْدٜ اَلْمَسِيحُ دٛوْ غَافَانغَلْ، نغَمْ نغَرْتٛنْ ٻٜ غٛطّٛ جٜيِ؞ جٛونِ جٜيْطٛعٛنْ وٛنِ اَلْمَسِيحُ اُمِّيطٛ دَغَ مَيْدٜ، نغَمْ نغَرْتٜنْ کُوٛوٻٜ ندٜرْ کُوغَلْ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","شَرٜلْ کٛ نغَطٜتٜنْ کٛ ٻَلِّ مٜىٰطٜنْ نغِطِ، سُونٛوجِ ڤٛوطَيْطِ حَکّٜ، طِ ٻٜيْدِي سٜمْبٜ ندٜرْ مٜىٰطٜنْ کٛ نَنْطٜنْ ندٜرْ اَتَّوْرَ، اٜ طِ کُوَ ندٜرْ ٻَلِّ مٜىٰطٜنْ نغَمْ کُوٜنْ کٛ فٛوطَنْتَعٜنْ مَيْدٜ؞ ");
INSERT INTO fuv_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","اَمَّا جٛونِ اٜنْ ندِمْطِنَامَ دَغَ اَتَّوْرَ غَرْتِرْطُمْعٜنْ مَشُّٻٜ، نغَمْ اٜنْ مَيْدِي اٜ اَلْمَسِيحُ؞ جٛونِ اٜنْ کُوَنَ اَللَّه ندٜرْ لَاوٛلْ کٜسٛلْ نغٛلْ رُوحُ مَاکٛ، نَاع ندٜرْ تٛکُّکِ لَاوٛلْ کِينغٛلْ نغٛلْ دٛوکَ بِنْدَاطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","طُمٜ مبِعٜتٜنْ کَدِنْ؟ اَتَّوْرَ طُمْ حَکّٜ؟ غٛونغَ نَاع نٛنْ!‏ اَمَّا دَا اَتَّوْرَ وَلَا، دَا مِ اَنْدَا کٛ وٛنِ حَکّٜ؞ دَا اَتَّوْرَ وِعَايِنٛ، ‏«‏تَاع يِطُ فِي طُمْ اَ جٜيَايِ،»‏ دَا مِ اَنْدَا يِطُکِ فِي طُمْ مِ جٜيَايِ وٛوطَا؞ ");
INSERT INTO fuv_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","اَمَّا حَکّٜ حٜٻِي لَاوٛلْ ندٜرْ دٛوکَ فٛوطَنِييَمْ کٛو اِرِ نغٛيٜ سُونٛ يِطُکِ فِي طُمْ مِ جٜيَايِ؞ نغَمْ تٛ دٛوکَ وَلَا، سٜمْبٜ حَکّٜ وَاتِي؞ ");
INSERT INTO fuv_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","ندٜنّٛ کٛ مِ اَنْدَا کٛ دٛوکَ حَطِ، اٜ مِ ݧُمَ مِ وَلَا حَکّٜ؞ اَمَّا ندٜ اَنْدُمِطُمْ، سٜيْ ڤَامُمِ مِ يٜوِيطُمْ، مِ غَطٛووٛ حَکّٜ، ندٜنْ اَنْدُمِ يٜىٰسٛ اَللَّه مِ مَيْطٛ؞ ");
INSERT INTO fuv_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","دٛوکَ کَانُطُمْ حٛلَّيَمْ لَاوٛلْ نغٛلْ تٛکَّيْمِ مِ حٜٻَ يٛنْکِ کِ رٜعَتَا، طُمْ فٛوطَنِييَمْ حَلْکٜرٜ؞ ");
INSERT INTO fuv_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","حَکّٜ کٜٻِي لَاوٛلْ ندٜرْ دٛوکَ، طُمْ کُوتِرِيطُمْ، طُمْ پٛيْرِييَمْ، طُمْ فٛوطَنِييَمْ حَلْکٜرٜ؞ ");
INSERT INTO fuv_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","نغَمْ نٛنْ، اَتَّوْرَ دَغَ تٛ اَللَّه طُمْ پِوٛيِ، نٛنْ مَا دٛوکَ دَغَ تٛ اَللَّه طُمْ پِوٛيِ، اٜ طُمْ وِعَ کٛ حَانِ، اٜ طُمْ وٛوطِ؞ ");
INSERT INTO fuv_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","تٛو، طُمْ طٛنْ دٛوکَ بٛطُّمْ طُمْ فٛوطَنِييَمْ حَلْکٜرٜ وٛنْ طٛنْ؟ نَاع نٛنْ!‏ اَمَّا نغَمْ حَکّٜ اَنْدٜىٰ طُمْ حَکّٜ، طُمْ ڤٛوطَنِييَمْ حَلْکٜرٜ لَاوٛلْ طُمْ طٛنْ دٛوکَ بٛطُّمْ، نغَمْ اٜ لَاوٛلْ دٛوکَ حَکّٜ وَرْتَ فِي کَلُّطُمْ نَاع سٜطَّ؞ ");
INSERT INTO fuv_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","اٜنْ اَنْدِ اَتَّوْرَ طُمْ کُوغَلْ رُوحُ اَللَّه، اَمَّا مِنْ مِ نٜطّٛ تَنْ، مِ مَشُّطٛ حَکّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","مِ فَامَايِ نغَمْ طُمٜ نغَطَيْمِ کٛ نغَطَيْمِ؞ نغَمْ مِ وَطَتَا کٛ نغِطُمِ وَطُکِ، اَمَّا اٜ مِ وَطَ کٛ نغَݧُمِ؞ ");
INSERT INTO fuv_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","تٛ مِ وَطِي کٛ مِ يِطَا وَطُکِ، نٛنْ حٛلِّي مِ جَٻِي اَتَّوْرَ اٜ وٛوطِ؞ ");
INSERT INTO fuv_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","نغَمْ نٛنْ، نَاع طُمْ مِنْ وَطَتَطُمْ، اَمَّا طُمْ حَکّٜ غٛنْطُمْ ندٜرْ اَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","اٜ مِ اَنْدِ وَلَا غٛطُّمْ بٛطُّمْ ندٜرْ اَمْ، وَاتٛ ندٜرْ نغِکُّ اَمْ طُمْ حَکّٜ؞ اٜ مِ يِطِ وَطُکِ فِي بٛطُّمْ، اَمَّا مِ وَاوَتَا وَطُکِطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","مِ وَطَتَا فِي بٛطُّمْ طُمْ نغِطُمِ وَطُکِ، اَمَّا اٜ مِ وَطَ فِي کَلُّطُمْ طُمْ مِ يِطَا وَطُکِ؞ ");
INSERT INTO fuv_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","تٛو، تٛ مِ وَطِي کٛ مِ يِطَا وَطُکِ، نٛنْ حٛلِّي نَاع طُمْ مِنْ وَطَتَطُمْ، اَمَّا طُمْ حَکّٜ غٛنْطُمْ ندٜرْ اَمْ وَطَتَطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","طُمْ وَرْتَنِييَمْ نغِکُّ، فُو شَرٜلْ کٛ نغِطُمِ وَطُکِ غٛطُّمْ بٛطُّمْ، سٜيْ غٛطُّمْ کَلُّطُمْ غٛنْطُمْ ندٜرْ اَمْ حَطَيَمْ وَطُکِطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","دَغَ ندٜرْ ٻٜرْندٜ اَمْ اٜ مِ نَنَ بٜلْطُمْ دٛوکَ پِوٛيْطُمْ دَغَ تٛ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","اَمَّا ندٜرْ ٻَنْدُ اَمْ مِ يِعِي غٛطُّمْ دٛوکَ فٜىٰرٜ اٜ حٛنِدَ اٜ دٛوکَ طُمْ ٻٜرْندٜ اَمْ يِطِ؞ طُمْ وَرْتِرِييَمْ مَشُّطٛ حَکّٜ غٛنْطُمْ ندٜرْ ٻَنْدُ اَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","مِ نٜطّٛ جُرْمِنِيطٛ!‏ مٛيٜ حِسْنَتَيَمْ دَغَ ندُعُ ٻَنْدُ اَمْ ڤٛوطَنَيْندُيَمْ حَلْکٜرٜ؟ ");
INSERT INTO fuv_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","يٜتّٛورٜ تَبِّتَ تٛ اَللَّه بَرْکَ جٛومِرَاوٛ مٜىٰطٜنْ يٜىٰسُ اَلْمَسِيحُ!‏ نغَمْ نٛنْ، مِنْ اٜ حٛورٜ اَمْ ندٜرْ ٻٜرْندٜ اَمْ مِ مَشُّطٛ دٛوکَ اَللَّه، اَمَّا نغَمْ نغِکُّ اَمْ طُمْ حَکّٜ مِ مَشُّطٛ حَکّٜ؞ ");
INSERT INTO fuv_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","نغَمْ نٛنْ، جٛونِ طُمْ تَپَنْتَا ٻٜنْ طٛنْ شُمْڤٛوتِرٛوٻٜ اٜ يٜىٰسُ اَلْمَسِيحُ کِيتَ حَلْکٜرٜ؞ ");
INSERT INTO fuv_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","نغَمْ دٛوکَ رُوحُ اَللَّه کٛکّٛوجُمْ يٛنْکِ ندٜرْ سُمْڤٛوتِرْکِ اٜ يٜىٰسُ رِمْطِنِييَمْ دَغَ بَوْطٜ حَکّٜ لَامٛتٛوطُمْعٜنْ ڤٛوطَنَيْطُمْعٜنْ حَلْکٜرٜ؞ ");
INSERT INTO fuv_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","کٛ اَتَّوْرَ وَاوَايِ وَطُکِ، نغَمْ نغِکُّ حَکّٜ طُمْ نٜطّٛ وٛودِ، اَللَّه وَطِيطُمْ؞ ندٜ اٛ لِلِ ٻِطّٛ مَاکٛ ندٜرْ نَنْدِ ٻَنْدُ مٜىٰطٜنْ ندُ حَکّٜ نغَمْ اٛ وَرْتَ شَکِّرِ نغَمْ حَکّٜ مٜىٰطٜنْ، اٛ سَنْکِتِي لَامُ حَکّٜ ندٜرْ ٻَنْدُ؞ ");
INSERT INTO fuv_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","اَللَّه وَطِي طُعُمْ نغَمْ مبَاوٜنْ وَطُکِ فُو کُوطٜ اَادِلَاکُ طٜ اَتَّوْرَ وِعِ طُمْ وَطَ، اٜنٜنْ تٛکّٛوٻٜ کٛ رُوحُ اَللَّه وِعِ، نَاع کٛ ٻَلِّ مٜىٰطٜنْ نغِطِ؞ ");
INSERT INTO fuv_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","يِمْٻٜ غَطٛوٻٜ کٛ ٻَلِّ مَٻّٜ نغِطِ، اٜ ٻٜ نجٛوَ ٻٜرْطٜ مَٻّٜ دٛوْ کٛ ٻَلِّ مَٻّٜ نغِطِ؞ اَمَّا يِمْٻٜ غَطٛوٻٜ کٛ رُوحُ اَللَّه وِعِ، اٜ ٻٜ نجٛوَ ٻٜرْطٜ مَٻّٜ دٛوْ کٛ رُوحُ اَللَّه يِطِ؞ ");
INSERT INTO fuv_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","يٛوُکِ ٻٜرْندٜ دٛوْ کٛ ٻَنْدُ يِطِ اٜ طُمْ فٛوطَ حَلْکٜرٜ، اَمَّا يٛوُکِ ٻٜرْندٜ دٛوْ کٛ رُوحُ اَللَّه يِطِ اٜ طُمْ وَدَّ يٛنْکِ اٜ جَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","نغَمْ يٛوُکِ ٻٜرْندٜ دٛوْ کٛ ٻَنْدُ يِطِ طُمْ وَݧُکِ اَللَّه، طُمْ تٛکَّتَا کٛ دٛوکَ اَللَّه وِعِ، طُمْ وَاوَتَا وَطُکِطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","يِمْٻٜ غَطٛوٻٜ کٛ ٻَلِّ مَٻّٜ نغِطِ ٻٜ مبَاوَتَا وٜلْنَنْکِ اَللَّه ٻٜرْندٜ؞ ");
INSERT INTO fuv_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","اَمَّا اٛنٛنْ اٛنْ نغَطَتَا کٛ ٻَلِّ مٛوطٛنْ نغِطِ؞ اٛنْ نغَطَ کٛ رُوحُ اَللَّه وِعِ، تٛ نِ طُمْ غٛونغَ رُوحُ اَللَّه اٜ جٛوطِي ندٜرْ ٻٜرْطٜ مٛوطٛنْ؞ کٛو مٛيٜ تٛ وَلَا رُوحُ اَلْمَسِيحُ، نَاع اَلْمَسِيحُ جٜيِمٛ؞ ");
INSERT INTO fuv_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","اَمَّا تٛ اَلْمَسِيحُ اٜ جٛوطِي ندٜرْ ٻٜرْطٜ مٛوطٛنْ، کٛو ندٜ ٻَلِّ مٛوطٛنْ مَايَيْ نغَمْ حَکّٜ، فُو اٜ نٛنْ رُوحُ اَللَّه حٛکَّيْعٛنْ يٛنْکِ، نغَمْ اٛنْ نغَرْتِرَامَ اَادِلِعٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","تٛ رُوحُ اَللَّه اُمِّنْطٛ يٜىٰسُ دَغَ مَيْدٜ اٜ جٛوطٛو ندٜرْ ٻٜرْطٜ مٛوطٛنْ، اٛنْ طٛنْ اُمِّنْطٛ اَلْمَسِيحُ دَغَ مَيْدٜ حٛکَّيْ ٻَلِّ مٛوطٛنْ مَايَيْطِ يٛنْکِ بَرْکَ رُوحُ مَاکٛ جٛوطِيطُمْ ندٜرْ ٻٜرْطٜ مٛوطٛنْ؞ ");
INSERT INTO fuv_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","نغَمْ نٛنْ بَنْدِرَاٻٜ اَمْ، اٜ وٛودِ غٛطُّمْ طُمْ نغَطٜتٜنْ دٛولٜ، اَمَّا کَنْجُمْ نَاع طُمْ تٛکُّکِ کٛ ٻَلِّ مٜىٰطٜنْ نغِطِ؞ ");
INSERT INTO fuv_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","نغَمْ تٛ اٛنْ نغَطَ جٛنْدٜ نٛ ٻَلِّ مٛوطٛنْ نغِطِرِ، اٛنْ مَايَيْ؞ اَمَّا بَرْکَ رُوحُ اَللَّه، تٛ اٛنْ مبَرِي کُوطٜ طٜ ٻَلِّ مٛوطٛنْ نغِطِ وَطُکِ، اٛنْ کٜٻَيْ يٛنْکِ کِ رٜعَتَا؞ ");
INSERT INTO fuv_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","نغَمْ فُو يِمْٻٜ ٻٜ رُوحُ اَللَّه تٛکِّنْتَ ٻٜ ٻِٻّٜ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","نغَمْ اَللَّه حٛکَّايِعٛنْ رُوحُ غَرْتِرَيْطُمْعٛنْ مَشُّٻٜ حَا ڤُطِّتٛنْ نغَطٛنْ جٛنْدٜ ندٜرْ کُلٛلْ، اَمَّا اٛ حٛکُّعٛنْ رُوحُ غَرْتِرَيْطُمْعٛنْ ٻِٻّٜ مَاکٛ؞ بَرْکَ رُوحُ طُمْ اٜنْ مبَاوَيْ نٛدّٜنْ اَللَّه ‏«‏اَبَّ! ݧَاکٛ مٜىٰطٜنْ!‏»‏ ");
INSERT INTO fuv_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","رُوحُ اَللَّه اٜ حٛورٜ مَاجُمْ حَوْتِ اٜ ٻٜرْطٜ مٜىٰطٜنْ تَبِّتِنْتَ اٜنٜنْ اٜنْ ٻِٻّٜ اَللَّه؞ ");
INSERT INTO fuv_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","جٛونِ ندٜ اٜنْ ٻِٻّٜ، اٜنْ نغَرْتِي دٛنٛوٻٜ؞ اٜنْ ندٛنَيْ فِي بٛطُّمْ طُمْ اَللَّه رٜسَنِ يِمْٻٜ مَاکٛ، کَدِنْ اٜنْ دٛنِدٛوٻٜ اٜ اَلْمَسِيحُ، تٛ نِ اٜنْ نجَرْدِي تٛرَّ اٜ مَاکٛ نغَمْ کٜٻٜنْ تٜدُّنغَلْ حَوْتِ اٜ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","مِ تَبِّتِنِي تٛرَّ کَ نجَرٜتٜنْ جٛونِ کَ حٜوْتَايِ کَ حَوْتٜىٰ اٜ تٜدُّنغَلْ نغَلْ طُمْ تٜدِّنْتَعٜنْ طٛعٛ يٜىٰسٛ؞ ");
INSERT INTO fuv_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","فُو کٛ تَغَا اٜ حٜطِي اٜ حَاٻِ نغَمْ يِعَ اَللَّه وَنْغِنِي ٻِٻّٜ مُوطُمْ؞ ");
INSERT INTO fuv_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","نغَمْ کٛ تَغَا وَرْتِرَامَ مٜىٰرٜ، نَاع نغَمْ يِدّٜ مَاجُمْ، اَمَّا نٛنْ اَللَّه يِطِرِ طُمْ وَطٛرٛو؞ فُو اٜ نٛنْ اٜ وٛودِ کَمُّندٜ، ");
INSERT INTO fuv_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","نغَمْ کٛ تَغَا اٜ حٛورٜ مَاجُمْ طُمْ دِمْطِنْتٜىٰطُمْ دَغَ مَشُّنغَاکُ ݧٛلُکِ، طُمْ حٜٻَ رِمْطِنٜىٰکِ اٜ تٜدِّنٜىٰکِ طُمْ يِمْٻٜ اَللَّه نجٜيِ؞ ");
INSERT INTO fuv_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","اٜنْ اَنْدِ حَا جٛونِ فُو کٛ تَغَا اٜ اٛتَّ نغَمْ نَوْطُمْ نٛ دٜبّٛ ڤِيدٛووٛ اٜ نَوْطُمْ دَݧْنغٛلْ اٛتِّرْتَ؞ ");
INSERT INTO fuv_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","اَمَّا نَاع کٛ تَغَا تَنْ اٛتَّتَ، حَا مَا اٜ اٜنٜنْ؞ اٜنٜنْ غٛودُٻٜ رُوحُ اَللَّه، دٛکَّلْ مَاکٛ اَرَنْدٜوَلْ ندٜرْ کٛ اٛ حٛکَّتَعٜنْ، اٜنْ اٛتَّ ندٜرْ ٻٜرْطٜ مٜىٰطٜنْ، اٜنْ کَاٻِي اَللَّه وَرْتِرَعٜنْ ٻِٻّٜ مَاکٛ، طٛنْمَا اٛ رِمْطِنَ ٻَلِّ مٜىٰطٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","دَغَ شَرٜلْ کٛ طُمْ حِسْنِعٜنْ نغٛودُطٜنْ کَمُّندٜ ندٜعٜ؞ اَمَّا تٛ اٜنْ نغِعَ کٛ کَمِّيطٜنْ، نَاع طُمْ کَمُّندٜ وٛنْ طٛنْ؞ مٛيٜ وَطَتَ کَمُّندٜ دٛوْ کٛ يَادِ حٜٻِ؟ ");
INSERT INTO fuv_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","اَمَّا تٛ اٜنْ نغَطَ کَمُّندٜ دٛوْ غٛطُّمْ طُمْ اٜنْ نغِعَتَا، اٜنْ کٜطٛطُمْ ندٜرْ مُݧَلْ؞ ");
INSERT INTO fuv_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","نٛنْ مَا، رُوحُ اَللَّه اٜ وَلَّعٜنْ تٛ تَمْڤُطٜنْ؞ نغَمْ اٜنْ اَنْدَا نٛ حَانِ نغَطِرٜنْ دٛعَارٜ، اَمَّا رُوحُ اَللَّه اٜ حٛورٜ مَاجُمْ اٜ تٛرٛو اَللَّه نغَمْ مٜىٰطٜنْ شَرٜلْ نغٜلْ ندُلُّطٜنْ کٛ مبِعٜتٜنْ اٜنْ اٛتَّ؞ ");
INSERT INTO fuv_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","ندٜنْ اَللَّه اَنْدُطٛ کٛ وٛنِ ندٜرْ ٻٜرْطٜ مٜىٰطٜنْ، اٜ مٛ اَنْدِ کٛ رُوحُ يِطِ، نغَمْ رُوحُ اٜ تٛرٛو اَللَّه نغَمْ يِمْٻٜ مَاکٛ نٛنْ نٛ اٛ يِطِرِ؞ ");
INSERT INTO fuv_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","اٜنْ اَنْدِ ندٜرْ کٛو طُمٜ اَللَّه اٜ حُوَ نغَمْ ٻٜيْدَارِ يِمْٻٜ غِطْٻٜمٛ، ٻٜ اٛ سُٻِ نٛنْ نٛ اٛ يِطِرِ؞ ");
INSERT INTO fuv_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","اَللَّه اٜ اَندِٻٜ دَغَ اَرَنْدٜ اٛ سُٻِيٻٜ کٛ دُونِيَارُ تَغٜىٰ نغَمْ ٻٜ نغَرْتَ بٛ ٻِطّٛ مَاکٛ، نغَمْ ٻِطّٛ اٛنْ وَرْتَ اَفٛ ندٜرْ بَنْدِرَاٻٜ طُطْٻٜ؞ ");
INSERT INTO fuv_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","ٻٜنْ طٛنْ ٻٜ اٛ سُٻِ، اٛ نٛدِّيٻٜ، اٛ وَرْتِرِيٻٜ اَادِلِعٜنْ، اٛ نَتِّنِيٻٜ تٜدُّنغَلْ مَاکٛ؞ ");
INSERT INTO fuv_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","طُمٜ مبِعٜتٜنْ دٛوْ فِي طُعُمْ؟ تٛ اَللَّه اٜ وٛنْدِ اٜ مٜىٰطٜنْ، مٛيٜ وَاوَتَ حٜٻَ جَالٛرْغَلْ دٛوْ مٜىٰطٜنْ؟ ");
INSERT INTO fuv_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","اَللَّه حَطَايِ ٻِطّٛ مُوطُمْ يَرْکِ تٛرَّ، اَمَّا اٛ حٛکِّيمٛ نغَمْ اٛ سَکّٜىٰ نغَمْ مٜىٰطٜنْ اٜنْ فُو؞ ندٜ اٛ وَطِي نٛنْ، اٛ حٛکَّتَاعٜنْ کٛو طُمٜ شَاحُ؟ ");
INSERT INTO fuv_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","مٛيٜ وَاوَتَ وُلَّاکِ يِمْٻٜ ٻٜ اَللَّه سُٻِ؟ طُمْ اَللَّه اٜ حٛورٜ مُوطُمْ وَرْتِرِٻٜ اَادِلِعٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","مٛيٜ وَاوَتَ تَپَنْکِٻٜ کِيتَ؟ وَلَا!‏ يٜىٰسُ اَلْمَسِيحُ مَايِي، کٛ ٻُرِ وٛنِ اٛ اُمِّنَامَ دَغَ مَيْدٜ، اٜ مٛ تٛنْ جٛوطِي تٛ جُنْغٛ ݧَامٛ نغٛ اَللَّه، کَدِنْ اٜ مٛ تٛرٛو اَللَّه نغَمْ مٜىٰطٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","طُمٜ وَاوَتَ سٜنْدَعٜنْ اٜ يِدّٜ ندٜ اَلْمَسِيحُ يِطِعٜنْ؟ طُمْ تٛرَّ کَلُّکَ، کٛو بٛنٜ، کٛو حَلّٜىٰندٜ يِمْٻٜ، کٛو وٜىٰلٛ، کٛو شِيَ کٛلْتٜ، کٛو نغَݧَاندِ يِمْٻٜ، کٛو مَيْدٜ؟ ");
INSERT INTO fuv_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","نٛنْ نٛ طُمْ وِنْدِرَا، ‏«‏نغَمْ مَاطَ کٛو ندٜيٜ ݧَلْندٜ اٜ طُمْ طَٻِّتَ وَرْکِمِنْ؛ طُمْ حٛشِّيمِنْ بٛ بَالِ طِ طُمْ حِرْسَتَ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","نَاع نٛنْ، ندٜرْ فُو فِي طُعُمْ اٜنْ کٜٻِي جَالٛرْغَلْ بَرْکَ اَلْمَسِيحُ غِطّٛعٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","نغَمْ مِ تَبِّتِنِي وَلَا کٛ وَاوَتَ حَطَ اَلْمَسِيحُ يِطُکِعٜنْ، کٛو مَيْدٜ، کٛو يٛنْکِ، کٛو مَلَاعِکَعٜنْ، کٛو کٛ لَامٛتٛو دٛوْ، کٛو جَامَنُ طُعُمْ، کٛو جَامَنُ غَرَيْطُمْ، کٛو بَوْطٜ، ");
INSERT INTO fuv_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","کٛو کٛ وٛنِ اٜ دٛوْ، کٛو کٛ وٛنِ اٜ لٜيْ، وَلَا غٛطُّمْ ندٜرْ فُو کٛ تَغَا بَاوَيْطُمْ حَطَ اَللَّه يِطُکِعٜنْ يِدّٜ ندٜ اٛ حٛلَّتَعٜنْ بَرْکَ يٜىٰسُ اَلْمَسِيحُ جٛومِرَاوٛ مٜىٰطٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","کٛ مبِعَيْمِ طُمْ غٛونغَ؞ اَلْمَسِيحُ جٜيِيَمْ، نغَمْ نٛنْ مِ فٜوَتَا؞ رُوحُ اَللَّه اٜ لَامٛو ٻٜرْندٜ اَمْ ندٜ تَبِّتِنَنِييَمْ کٛ مبِعَيْمِ نَاع طُمْ فٜوْرٜ؞ ");
INSERT INTO fuv_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","اٜ مِ وَنِّي نَاع سٜطَّ، ندٜنْ نَوْطُمْ ٻٜرْندٜ اَمْ وَلَا رٜعِرْدٜ نغَمْ بَنْدِرَاٻٜ اَمْ يَحُودَنْکٛعٜنْ؞ ");
INSERT INTO fuv_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","دَا مِنْ اٜ حٛورٜ اَمْ مِ لَانٜىٰ طُمْ سٜنْدَيَمْ اٜ اَلْمَسِيحُ نغَمْ لٜݧٛلْ اَمْ کٜٻَ کِسْندَمْ؞ ");
INSERT INTO fuv_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","کَمْٻٜ نغٛنِ اِسْرَاعِيلَنْکٛعٜنْ، ٻٜ اَللَّه وَرْتِرِ ٻِٻّٜ مُوطُمْ؞ اٛ وَنْغِنَنِيٻٜ تٜدُّنغَلْ مَاکٛ، اٛ وَطَنِيٻٜ اَلْکَوَلْجِ، اٛ حٛکِّيٻٜ اَتَّوْرَ، اٛ حٛلِّيٻٜ نٛ ٻٜ مَوْنِنِرْتَمٛ مَوْنِنْکِ کِ غٛونغَ، ندٜنْ اٛ وَطَنِيٻٜ اَلْکَوَلْجِ طُطِّ؞ ");
INSERT INTO fuv_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","ٻٜ پِوٛيِ دَغَ مَامَعٜنْ يَحُودَنْکٛعٜنْ مَوْٻٜ اَنْدَاٻٜ، ندٜنْ دَغَ لٜݧٛلْ مَٻّٜ اَلْمَسِيحُ وَرٛيِ ندٜرْ ٻَنْدُ؞ اَللَّه لَامٛتٛوطٛ کٛو طُمٜ مَنْتٜىٰ حَا اَبَدَا!‏ اَامِنْ؞ ");
INSERT INTO fuv_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","نَاع اٜ مِ وِعَ اَللَّه حٜبِّنَايِ اَلْکَوَلْ مُوطُمْ؞ نغَمْ نَاع فُو اِسْرَاعِيلَنْکٛعٜنْ نغٛنِ يِمْٻٜ اَللَّه ٻٜ غٛونغَ؞ ");
INSERT INTO fuv_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","طٛنْمَا نَاع فُو ٻِٻّٜ ٻِٻّٜىٰجِ اِبْرَاهِمْ نغٛنِ ٻِٻّٜ اَللَّه؞ اَمَّا اَللَّه وِعِي اِبْرَاهِمْ، ‏«‏بَرْکَ اِشِيَاکُ کٜٻَتَا ٻِٻّٜ ٻِٻّٜىٰجِ ٻٜ نغَطَنْمَامِ اَلْکَوَلْ؞»‏ ");
INSERT INTO fuv_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","طُعُمْ حٛ