﻿USE sofia;
DROP TABLE IF EXISTS sofia.fuhbkf_vpl;
CREATE TABLE fuhbkf_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES fuhbkf_vpl WRITE;
INSERT INTO fuhbkf_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Inan binndi kollooji inɗe maamiraaɓe Iisaa Almasiihu, dimaaɗo ley lenyol Daawda, taan Ibrahiima: ");
INSERT INTO fuhbkf_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ibrahiima rimi Isiyaaka. Isiyaaka rimi Yaakuuba. Yaakuuba rimi Yahuuda e minyiraaɓe muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yahuuda rimi Fares e Sera. Ɓeen ngoni ɓe o rimdi e Tamar. Fares rimi Hesruuna. Hesruuna rimi Aram. ");
INSERT INTO fuhbkf_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram rimi Aminadaabu. Aminadaabu rimi Naasuuna. Naasuuna rimi Salmon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon rimi Bo'as, mo o rimdi e Rahabu. Bo'as rimi Obet, mo o rimdi e Ruttu. Obet rimi Yesa. ");
INSERT INTO fuhbkf_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yesa rimi Daawda kaananke oon. Daawda rimi Suleymaana. Oon woni mo o rimdi e dee Uriya-no. ");
INSERT INTO fuhbkf_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Suleymaana rimi Robo'am. Robo'am rimi Abiya. Abiya rimi Asa. ");
INSERT INTO fuhbkf_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa rimi Yosafat. Yosafat rimi Yoram. Yoram rimi Usiya. ");
INSERT INTO fuhbkf_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usiya rimi Yotam. Yotam rimi Akas. Akas rimi Hesekiya. ");
INSERT INTO fuhbkf_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekiya rimi Manasa. Manasa rimi Amon. Amon rimi Yosiya. ");
INSERT INTO fuhbkf_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosiya rimi Yekoniya e minyiraaɓe muuɗum. Ɗum hawrii e jamaanu mo Alhuudiyankooɓe njaalanoo, njaaraa Baabiila. ");
INSERT INTO fuhbkf_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Caggal ɓe njaaraama Baabiila, Yekoniya rimi Seyaltiyel. Seyaltiyel rimi Sorobabel. ");
INSERT INTO fuhbkf_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Sorobabel rimi Abiihudu. Abiihudu rimi Eliyakim. Eliyakim rimi Asoro. ");
INSERT INTO fuhbkf_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asoro rimi Sadok. Sadok rimi Akim. Akim rimi Eliyuda. ");
INSERT INTO fuhbkf_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliyuda rimi Eliyasar. Eliyasar rimi Mattan. Mattan rimi Yaakuuba. ");
INSERT INTO fuhbkf_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yaakuuba rimi Yuusufi, jom suudu Mariyama. Mariyama woni inna Iisaa bi'eteeɗo Almasiihu oon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ndelle ɗum hawrii e jamaanuuji sappo e nay illa Ibrahiima faa yottii Daawda. Illa e Daawda faa yottii nde Alhuudiyankooɓe konanoo njaaraa Baabiila ndeen fu, wo jamaanuuji sappo e nay hawrata. Wooɗi du, illa nde Alhuudiyankooɓe konanoo njaaraa Baabiila faa garol Almasiihu ndeen, wo jamaanuuji sappo e nay hawrata. ");
INSERT INTO fuhbkf_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Inan no Iisaa Almasiihu rimiraa: Mariyama inniiko oon wo kaɓɓanaaɗo Yuusufi. Ammaa fadde makko e suddeede, tawi o reedirii saabe baawɗe Ruuhu Ceniiɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yuusufi kaɓɓanɗo mo oon wo neɗɗo ponnditiiɗo, yiɗaa semtinde mo, anniyake fiirtude kaɓɓal ngaal e suuraare. ");
INSERT INTO fuhbkf_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Nde o miilotonoo ɗum ndeen, maleyka Joomiraaɗo wari to makko ley koyɗol, wi'i mo: —Yuusufi, taan Daawda, taa hulu ɓaŋude Mariyama, sabo ɓinngel ngel saawi ngeel e Ruuhu Ceniiɗo ƴuuri. ");
INSERT INTO fuhbkf_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","O riman ɓiɗɗo gorko. Inndiraa mo Iisaa, sabo wo kanko hisinta yimɓe makko e hakkeeji muɓɓen. ");
INSERT INTO fuhbkf_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ɗum fuu, ɗum waɗii faa haala ka Laamɗo yottini annabaajo kaan tabita nde wi'unoo: ");
INSERT INTO fuhbkf_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«Surbaajo mo anndaa gorko reedan, rima ɓiɗɗo gorko. O inndirte Imanuwel.» Maanaa innde ndeen wo: «Laamɗo ina wondi e meeɗen». ");
INSERT INTO fuhbkf_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Nde Yuusufi finunoo ndeen, waɗi no maleyka Joomiraaɗo wi'iri ɗum noon. O ɓaŋi Mariyama, ");
INSERT INTO fuhbkf_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","ammaa o wondaay e muuɗum faa rimi ɓiɗɗo gorko. Yuusufi inndiri ɓiɗɗo oon Iisaa. ");
INSERT INTO fuhbkf_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Iisaa rimaama Baytilaama ley leydi Yahuudiya e jamaanu laamu Hirudus. Jom'en anndal ƴuuri lettugal, ngari Urusaliima. ");
INSERT INTO fuhbkf_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Nde ɓe ngarnoo ndeen, ɓe mbi'i: —Toy kaananke Alhuudiyankooɓe dimaaɗo joonin oon woni? Min nji'ii hoodere makko ɓangii lettugal, min ngarii sujidande mo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Nde Hirudus kaananke oon nannoo ɗum fu, huli, kam e yimɓe Urusaliima fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","O noddi hooreeɓe almaami'en e jannginooɓe Tawreeta ɓeen fuu, o ƴami ɗum'en toy Almasiihu oon jeyi rimeede. ");
INSERT INTO fuhbkf_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ɓe njaabii mo, ɓe mbi'i: —Baytilaama ley leydi Yahuudiya, sabo inan ko annabaajo winndunoo: ");
INSERT INTO fuhbkf_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","«Aan, Baytilaama, leydi Yahuudiya, tannyoral a wanaa wuro famaro hakkunde gure Yahuudiya mawɗe ɗeen. Sabo ardotooɗo ƴuuran e maaɗa, garoowo faa dura yimɓe am, Israa'iilankooɓe.» ");
INSERT INTO fuhbkf_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ndeen Hirudus noddi jom'en anndal ɓeen e cuncukka, ƴami ɓe wakkati mo hoodere ndeen ɓangi. Ɓe paamini mo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Caggal ɗuum, o neli ɓe Baytilaama. O wi'ii ɓe: —Njehee, kumpitowoɗon kabaaru cukalel ngeel faa tannyoron. Si on nji'ii ngel fu, ngaron kumpiton kam faa miin du mi yaha, mi sujidanowa ngel. ");
INSERT INTO fuhbkf_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Nde ɓe nannoo ko kaananke oon haali ɗuum ndeen, ɓe ndilli. Hoodere nde ɓe njiinoo lettugal ndeen ardii ɓe yaade. Nde ardii ɓe faa nde yottii ɗo cukalel ngeel woni ɗoon, de nde darii. ");
INSERT INTO fuhbkf_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ko ɓe nji'i hoodere ndeen ɗuum, ɓe ceyii seyo manngo sanne. ");
INSERT INTO fuhbkf_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ɓe naati ley suudu nduun, ɓe nji'i cukalel ngeel e inniigel Mariyama. Ɓe kippii e leydi, ɓe cujidani ngel. Ɓe njaltini gineeji maɓɓe, ɓe teddiniri ngel kaŋŋe e sii uurdi mbelndi e ɗakke uurɗe bi'eteeɗe miiri. ");
INSERT INTO fuhbkf_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Caggal ɗuum, Laamɗo gongini ɓe ley koyɗol taa ɓe njeccoo to Hirudus. Ndelle ɓe kootiri leydi maɓɓe laawol gonngol. ");
INSERT INTO fuhbkf_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Nde jom'en anndal ɓeen ndillunoo fu, maleyka Joomiraaɗo wari e Yuusufi ley koyɗol, wi'i ɗum: —Umma, hooƴu cukalel ngel e inna muuɗum, ndoggaa njahaa Misira. Keddoɗaa toon faa nde mbi'oymaami ngartaa. Sabo Hirudus filoto cukalel ngel faa wara ngel. ");
INSERT INTO fuhbkf_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Yuusufi ummii jemma, hooƴi cukalel ngeel e inniigel, de ɓe ndilliri Misira. ");
INSERT INTO fuhbkf_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","O heddii toon faa Hirudus maayi, faa haala ka Laamɗo yottini annabaajo kaan tabita nde wi'unoo: «Mi noddii ɓiyam wurtoo ley Misira.» ");
INSERT INTO fuhbkf_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Nde Hirudus faamunoo jom'en anndal ɓeen njambake ɗum ndeen, tikki sanne. O yamiri cukaloy ngoroy Baytilaama e ɗakkol muuɗum fuu mbaree, gilla keccoy faa ngaɗukoy duuɓi ɗiɗi. O waɗii ɗum fodde wakkatiiji ɗi jom'en anndal ɓeen kokki mo ɗiin. ");
INSERT INTO fuhbkf_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Noon haala ka annabi Yeremiya haalnoo kaan tabitiri nde wi'unoo: ");
INSERT INTO fuhbkf_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«Wullaango nanaama ley wuro Rama, bojji e uumaali ɗuuɗɗi: Rahiina ina woya cukaloy muuɗum, jaɓaay ɓerndem waaltinee, sabo koy keddaaki.» ");
INSERT INTO fuhbkf_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Caggal maayde Hirudus, maleyka Joomiraaɗo wari e Yuusufi to leydi Misira toon e ley koyɗol, ");
INSERT INTO fuhbkf_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","wi'i ɗum: —Umma, hooƴu cukalel ngel e inna muuɗum, njeccoɗon leydi Israa'iila, sabo yiɗunooɓe warude suka oon ɓeen maayii. ");
INSERT INTO fuhbkf_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Yuusufi ummii, hooƴi cukalel ngeel e inniigel, ɓe kooti leydi Israa'iila. ");
INSERT INTO fuhbkf_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ammaa o nanii Arkalaawu loomtii bammum Hirudus, laamake leydi Yahuudiya, de o huli yahude toon. O sappaa e ley koyɗol faa o yehi leydi Galili. ");
INSERT INTO fuhbkf_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","O hoɗowi wuro wi'eteengo Nasaraatu. Noon ɗum laatorii faa ko annabaaɓe mbi'unoo ɗuum tabita: «O wi'ete Nasaraatuujo.» ");
INSERT INTO fuhbkf_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","E jamaanu oon, Yaayaa lootoowo lootagal batisima ɓangi. Imo gooyna ley ladde Yahuudiya, imo wi'a: ");
INSERT INTO fuhbkf_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","—Tuubee, sabo laamu Laamɗo ɓadake. ");
INSERT INTO fuhbkf_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Oon woni mo annabi Esaaya sappinoo, nde wi'unoo: «Daande ina ƴeewnoo ley ladde ina wi'a: Moƴƴinee laawol Joomiraaɗo, ndartinee ɗati makko!» ");
INSERT INTO fuhbkf_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yaayaa ina ɓornii kaddungal canyiraangal leeɓi geelooɗi, ina haɓɓii kaɓɓorgol nguru. Nyaamdu makko wo baɓɓatti e njuumndi ladde. ");
INSERT INTO fuhbkf_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Yimɓe ƴuuri Urusaliima e leydi Yahuudiya e seraaji gooruwol Urdun fuu, ngari to makko. ");
INSERT INTO fuhbkf_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Iɓe kaalta hakkeeji maɓɓe, de Yaayaa ina loota ɓe lootagal batisima ley gooruwol Urdun. ");
INSERT INTO fuhbkf_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ko o yi'i Farisa'en e Saduki'en heewɓe na ngara faa lootee lootagal batisima ɗuum, o wi'i ɗum'en: —Onon ɓiɓɓe bolle! Moy sappani on ndoggon tikkere Laamɗo waroore? ");
INSERT INTO fuhbkf_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ngollee golleeji kawrooji e tuubugol. ");
INSERT INTO fuhbkf_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Taa kooloɗon on kisan saabe wo on taaniraaɓe Ibrahiima. Sabo miɗo wi'a on: Laamɗo ina waawi waylitinde kaaƴe ɗe laatoo ɓiɓɓe Ibrahiima! ");
INSERT INTO fuhbkf_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Joonin, jammbere ƴeptaama faa soppa ɗaɗi leɗɗe. Ndelle, lekki fuu ki rimataa ɓiɓɓe lobbuɓe, soppete, faɗɗee ley yiite. ");
INSERT INTO fuhbkf_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Miin, ndiyam lootirammi on batisima faa hollita on tuubii. Ammaa garoowo caggal am oon, kam ɓuri kam baawɗe. Mi fotaay fay ɓortude ɗum paɗe muuɗum. Oon lootirta on batisima Ruuhu Ceniiɗo e yiite. ");
INSERT INTO fuhbkf_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","O segilake faa o ƴaroo nyaamri makko faa laaɓa. O hawrundura nyaamri makko ley beembal, de nyaande ndeen o wuldan ɗum yiite nge nyifataa. ");
INSERT INTO fuhbkf_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Wakkati oon, Iisaa ƴuuri Galili, wari gooruwol Urdun to Yaayaa, faa Yaayaa loota ɗum lootagal batisima. ");
INSERT INTO fuhbkf_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ammaa Yaayaa muuyi salaade ɗum, wi'i mo: —Aan haani lootude kam. De noy ngardataa to am, miin, faa mi loote? ");
INSERT INTO fuhbkf_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Iisaa jaabii mo, wi'i: —Accu ɗum laatoroo noon joonin, sabo noon kaanɗen hiɓɓinirde ko dartii fuu. Ndeen o jaɓi. ");
INSERT INTO fuhbkf_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Nde Iisaa lootanoo, ina wurtoo ndiyam ɗaam fu, wakkati oon pay kammu omtii. O yi'i Ruuhu Laamɗo ina jippoo hono wuugaandu, ina wara dow makko. ");
INSERT INTO fuhbkf_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Wakkati oon du, daande ƴuuri dow kammu, wi'i: —O woni Ɓiyam mo korsinmi, mo ceyortoomi. ");
INSERT INTO fuhbkf_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Wakkati oon, Ruuhu Laamɗo yaari Iisaa ley ladde, faa Ibiliisa jarriboo mo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Iisaa waɗi balɗe capanɗe nay ina suumii jemma e nyalooma fuu. Caggal ɗuum, o yolbi. ");
INSERT INTO fuhbkf_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ndeen, Jarribotooɗo oon ɓattitii mo, wi'i mo: —Si a Ɓii Laamɗo, yamir kaaƴe ɗe laatoo nyaamdu. ");
INSERT INTO fuhbkf_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","De Iisaa jaabii mo, wi'i: —Ina winndaa: «Wanaa e nyaamdu tan neɗɗo wuurdata. Ko neɗɗo wuurdata dey, wo e haala fuu ka Laamɗo haali.» ");
INSERT INTO fuhbkf_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Caggal ɗuum, Ibiliisa yaari mo Urusaliima ngalluure seniinde ndeen, darni mo dow to ɓuri toowde e suudu dewal mawndu, ");
INSERT INTO fuhbkf_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","wi'i mo: —Si a Ɓii Laamɗo, fittu njippoɗaa e leydi. Sabo ina winndaa: «Laamɗo yamiran maleyka'en muuɗum njaɓɓe e juuɗe muɓɓen taa koyngal maa fiyoo e hayre.» ");
INSERT INTO fuhbkf_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Iisaa jaabii mo, wi'i: —Ina winndaa katin: «Taa ndaartinda Laamɗo, Joomiraaɗo maa.» ");
INSERT INTO fuhbkf_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Katin Ibiliisa yaari mo dow waamnde toownde sanne, holli mo laamuuji adunaaru fuu e darja muɓɓen, ");
INSERT INTO fuhbkf_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","wi'i mo: —Mi hokkete ɗum ɗo fuu si a hippake, a sujidanii kam. ");
INSERT INTO fuhbkf_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Iisaa wi'i mo: —Woɗɗam Seyɗaani! Sabo ina winndaa: «Wo Laamɗo Joomiraaɗo maa kaanɗaa sujidande, kam tan kaanɗaa rewude.» ");
INSERT INTO fuhbkf_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ndeen Ibiliisa seli mo. Wakkati oon, maleyka'en ngari to makko, ina ngollana mo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Nde Iisaa nannoo Yaayaa uddaama ley kasu ndeen, o yeccii leydi Galili. ");
INSERT INTO fuhbkf_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ammaa o jooɗaaki Nasaraatu katin, de o hoɗowi Kafarnahum wuro ɗakkiingo maayo ley leydi Jabulon, kam e Naftali. ");
INSERT INTO fuhbkf_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ɗum waɗii faa haala ka annabi Esaaya haalnoo kaan tabita nde wi'unoo: ");
INSERT INTO fuhbkf_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«Leydi Jabulon e leydi Naftali dow laawol jahoowol maayo manngo, caggal Urdun, ley leydi Galili, joonnde yimɓe ɓe nganaa Alhuudiya'en, ");
INSERT INTO fuhbkf_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","yimɓe wonɓe e nimre nji'ii annoora mawɗo. Wuurɓe e ley leydi niɓɓundi nimre maayde, annoora yaynanii ɗum'en.» ");
INSERT INTO fuhbkf_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Gilla ndeen, Iisaa fuɗɗi waajaade ina wi'a: —Tuubee, sabo laamu Laamɗo ɓadake. ");
INSERT INTO fuhbkf_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Iisaa ina yaha hunnduko maayo Galili, de yi'i sakiraaɓe ɗiɗo, Simon bi'eteeɗo Piyeer e sakiike mum Andire. Iɓe paɗɗa fiiliiji maɓɓe ley maayo ngoon. Wo ɓe nanngooɓe liƴƴi. ");
INSERT INTO fuhbkf_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Iisaa wi'i ɓe: —Njokkee kam, mi waɗan on filotooɓe yimɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Wakkati oon ɓe njoppi fiiliiji maɓɓe ɗiin, ɓe njokki mo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","O yehi yeeso, o yi'i katin sakiraaɓe ɗiɗo woɓɓe, Yaakuuba e Yuhanna, ɓiɓɓe Jebede. Kam'en e baaba muɓɓen Jebede ina ngoni ley laana, ina moƴƴintina fiiliiji muɓɓen. O noddi ɗum'en. ");
INSERT INTO fuhbkf_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Wakkati oon pay, ɓe njoppi laana kaan, ɓe njoppi baabiiɓe du, ɓe njokki mo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Iisaa yiiltii ley leydi Galili fuu. Imo waajoo e ley cuuɗi maɓɓe baajorɗi, imo gooyna Kabaaru Lobbo haala laamu Laamɗo, imo danna sii nyawuuji e male fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Kabaaru makko sankitii ley leydi Siiriya fuu. Yimɓe na ngadda nyawɓe nyawuuji feere feere e male fuu to makko. Woɓɓe wo wonduɓe e ginnaaji, woɓɓe jom'en dabidabiije, woɓɓe du wo jom'en ɓalli-mbaatuɗi. O danni ɗum'en. ");
INSERT INTO fuhbkf_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Jamaa keewɗo sanne jokki mo. Wo ɓe ƴuuruɓe Galili e leydi mbi'eteendi Galluuje Sappo e Urusaliima e Yahuudiya e caggal gooruwol Urdun. ");
INSERT INTO fuhbkf_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Iisaa yi'i jamaa keewɗo oon de ƴeeŋi dow waamnde, jooɗii. Taalibaaɓe muuɗum ɓeen ɓattitii ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","O fuɗɗi waajaade ɓe, o wi'i: ");
INSERT INTO fuhbkf_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Barke woodanii annditinɓe yonkiiji muɓɓen ina lokkiɗi, sabo kamɓe njeyi laamu Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Barke woodanii suniiɓe, sabo Laamɗo waaltinan ɓerɗe muɓɓen. ");
INSERT INTO fuhbkf_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Barke woodanii leeƴinkiniiɓe, sabo kamɓe ndonata adunaaru. ");
INSERT INTO fuhbkf_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Barke woodanii filotooɓe fonnditaare hono no yolbuɓe e ɗomɗuɓe pilortoo neema, sabo ɓe kaaran, ɓe ɗomɗitan. ");
INSERT INTO fuhbkf_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Barke woodanii yurmotooɓe, sabo Laamɗo yurmoto ɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Barke woodanii laaɓuɓe ɓerɗe, sabo ɓe nji'an Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Barke woodanii waddooɓe jam, sabo ɓe noddirte ɓiɓɓe Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Barke woodanii torraaɓe saabe fonnditaare, sabo kamɓe njeyi laamu Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Barke woodanii on si yimɓe mbonkake on, torrii on, njowii on sii bonanda fuu saabe am. ");
INSERT INTO fuhbkf_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ceyee, mbeltee, sabo mbarjaari mawndi ina doomi on dow kammu. Sabo hono noon annabaaɓe artiiɓe on ɓeen torriraa. ");
INSERT INTO fuhbkf_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","—Onon, wo on lamɗam adunaaru ndu. Ammaa si lamɗam selii lamsude, ɗume lamsinta ɗam katin? Ɗam nafataa fay huunde! Ɗam faɗɗete yaasin, yimɓe njaaɓa ɗam. ");
INSERT INTO fuhbkf_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Wo on annoora adunaaru. Ngalluure nyiɓaande dow waamnde waawaa suuɗaade. ");
INSERT INTO fuhbkf_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Fay gooto huɓɓataa lampal, de hippa ɗum kaakol. Ko waɗata dey, ɓilan ngal, ngal yaynana gonɗo e suudu nduun fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Hono noon annoora mooɗon haani yaynirde yeeso yimɓe, faa nji'a golleeji lobbi ɗi ngaɗoton, de njetta Baaba mooɗon gonɗo dow kammuuli oon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","—Taa cikkee mi warii faa mi itta jamirooje Tawreeta naa haala annabaaɓe. Mi waraay faa mi itta ɗum. Mi warii faa mi hiɓɓina ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Goonga kaalanammi on: sini kammu e leydi ina keddii, fay toɓɓel maa masel tosataake ley Tawreeta faa ɗum fuu ɗum tabita. ");
INSERT INTO fuhbkf_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ɗum le, boofuɗo ko ɓuri fuu famɗude e jamirooje ɗeen, de janngini woɓɓe faa ngaɗa noon, joomum laatoto ɓurɗo famɗude e laamu Laamɗo. Ammaa neɗɗo fuu jokkuɗo Tawreeta oon, de janngini woɓɓe ngaɗa noon, joomum laatoto mawɗo e laamu Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Sabo miɗo haalana on: si on ɓuraay jannginooɓe Tawreeta e Farisa'en fonnditaare fu, on naatataa e ley laamu Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","—On nanii maamiraaɓe meeɗen ɓeen mbi'anooma: «Taa waɗu war-hoore, gaɗuɗo war-hoore fuu ina haani sareede.» ");
INSERT INTO fuhbkf_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Miin kaa miɗo wi'a on: tikkanɗo sakiike muuɗum fuu, ina haani sareede. Bi'uɗo sakiike muuɗum wo cuubaaɗo fu, ina jeyi darneede yeeso sariya laamu. Katin du, neɗɗo fuu biiɗo mo wo o jiiɓiiɗo, ina haani naatude yiite jahannama. ");
INSERT INTO fuhbkf_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ndelle, si a warii e hirsirde faa ngaɗa sadaka, de miccitiɗaa wakkati oon sakiike maa ina joganii maa ko metti, ");
INSERT INTO fuhbkf_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","njoppaa sadaka maa oon ɗoon, njahaa njaafundurowaa e sakiike maa oon tafon, ndeen ngartaa ngaɗaa sadaka maa oon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Si a haɓii e goɗɗo, de oɗon njaada sariya fu, karoɗaa ndewritaa e joomum fadde mooɗon yottaade, taa o watte e juuɗe carotooɗo, de oon watte e junngo doomoowo kasu, de uddeɗaa e kasu. ");
INSERT INTO fuhbkf_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Goonga kaalanammi on: abada a wurtataako si a yoɓaay ko ndeweteɗaa ɗuum faa laaɓi. ");
INSERT INTO fuhbkf_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","—On nanii wi'anooma: «Taa waɗu jeenu!» ");
INSERT INTO fuhbkf_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Miin kaa miɗo wi'a on: ƴeewruɗo debbo janano muuyo fuu, jeenii e ley ɓernde mum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ndelle, si yitere maa nyaamre luttinte, ittu nde, paɗɗaa nde to woɗɗi! Ceedaa e tergal maa gootal ɓuri moƴƴande ma diina ɓanndu maa nduun fuu faɗɗee e jahannama. ");
INSERT INTO fuhbkf_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Si junngo maa nyaamo luttinte, taƴu ngo, paɗɗaa ngo to woɗɗi: ceedaa e tergal maa gootal ɓuri moƴƴande ma diina ɓanndu maa nduun fuu naata jahannama. ");
INSERT INTO fuhbkf_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","—Wi'anooma katin: «Ceeruɗo deekum fuu, hokka ɗum talkuru ceergal.» ");
INSERT INTO fuhbkf_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Miin kaa miɗo wi'a on: neɗɗo fuu ceeruɗo deekum de tawi o wanaa jeenoowo, si o ɓaŋowaama, gorko ceeruɗo mo oon waɗii mo jeenoowo. Neɗɗo fuu ɓaŋuɗo debbo ceeraaɗo, kam du jeenii. ");
INSERT INTO fuhbkf_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","—On nanii katin, maamiraaɓe meeɗen mbi'anooma: «Taa fiirtu hunayeere maa, tabintinaa nde yeeso Joomiraaɗo.» ");
INSERT INTO fuhbkf_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Miin kaa miɗo wi'a on: taa kunoɗon fey. Taa kunoroɗon kammu, sabo wo jooɗorgal Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Taa kunoroɗon leydi, sabo wo njaaɓirdi koyɗe makko, naa Urusaliima, sabo wo ngalluure Kaananke mawɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Taa kunoroɗaa hoore maa, sabo a waawaa rawninde naa ɓawlinde fay leeɓol mayre gootol. ");
INSERT INTO fuhbkf_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Mbi'aa «ayyo» naa «a'aa» tan. Ko faltii ɗuum fuu, wo to Bonɗo oon ƴuuri. ");
INSERT INTO fuhbkf_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","—On nanii wi'anooma: «Yitere yomnitorte yitere, nyiinde yomnitorte nyiinde.» ");
INSERT INTO fuhbkf_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Miin kaa miɗo wi'a on: taa njomnitee gaɗuɗo on ko boni. Si goɗɗo feenyii ma gere nyaamo fu, acca ɗum feenya gere nano oon du. ");
INSERT INTO fuhbkf_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Si goɗɗo wullake ma faa teeta forgo maa, accu ɗum yaada e saaya maa jaangol du. ");
INSERT INTO fuhbkf_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Si goɗɗo tilsinanii ma ronndaade donngal yaadu kilomeetere, ronnda ngal yaadu kilooji ɗiɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Si goɗɗo ŋaarake ma, hokku ɗum. Si goɗɗo wi'ii mbuƴoɗaa ɗum fu, taa salana ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","—On nanii wi'anooma: «Njiɗaa gondo maa, mbanyaa ganyo ma.» ");
INSERT INTO fuhbkf_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Miin kaa miɗo wi'a on: njiɗee wayɓe on, ndu'anoɗon torrooɓe on. ");
INSERT INTO fuhbkf_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Worrude hono noon hollata wo on ɓiɓɓe Baaba mooɗon gonɗo dow kammuuli. Sabo no o fuɗinirta naange makko dow bonɓe, noon du o fuɗinirta nge dow moƴƴuɓe. No o tomnirta dow fonnditiiɓe, noon du o tomnirta dow oonyiiɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Si yiɗuɓe on tan njiɗoton, mbarjaari ndiye keɓoton? Fay nanngooɓe lampo ɓeen du ina ngaɗira noon! ");
INSERT INTO fuhbkf_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Si sakiraaɓe mooɗon tan njowtoton, ɗume senndi on e woɓɓe? Fay heeferɓe ɓeen ina ngaɗira noon! ");
INSERT INTO fuhbkf_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ndelle, laatoɗon hiɓɓuɓe, hono no Baaba mooɗon gonɗo dow kammuuli oon hiɓɓiri ni. ");
INSERT INTO fuhbkf_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","—Tinnee taa ngaɗiron golleeji mooɗon lobbi faa yimɓe nji'a on. Si on ngaɗii ɗum fu, on keɓataa mbarjaari to Baaba mooɗon gonɗo dow kammuuli oon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ndelle, si aɗa itta jakka, taa feeka faa yimɓe nji'e. Wo hono noon munaafiki'en ɓeen ngaɗata ley cuuɗi baajorɗi e dow laabi faa yimɓe mana ɗum'en. Goonga kaalanammi on, ɓe keɓii mbarjaari maɓɓe faa timmi. ");
INSERT INTO fuhbkf_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Aan kaa, si aɗa itta jakka fu, taa nano maa faama ko nyaamo maa waɗata. ");
INSERT INTO fuhbkf_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ndeen jakka maa oon laatoto ko suuɗii, de Baabiraaɗo maa ji'oowo ko suuɗii oon yoɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","—Si oɗon ndu'oo, taa ngaɗon no munaafiki'en ni. Kamɓe, iɓe njiɗi daraade ley cuuɗi baajorɗi e hakkunde to laabi kawrata, de ɓe ngaɗa du'aare yalla yimɓe fuu ina nji'a ɓe. Goonga kaalanammi on, ɓe keɓii mbarjaari maɓɓe faa timmi. ");
INSERT INTO fuhbkf_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Onon kaa, nde ndu'otoɗon fuu, naaton ley cuuɗi mon, ommbon dammbugal, de ŋaaroɗon Baaba mon e suuraare. Ndeen, Baaba mon ji'oowo ko suuɗii oon, yoɓan on. ");
INSERT INTO fuhbkf_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Si oɗon ndu'oo, taa kebbinee haalaaji ɓoli ɗi ngalaa nafaa hono no yimɓe ɓe anndaa Laamɗo ɓeen ngaɗata ni. Iɓe miilii Laamɗo jaabanto ɓe si ɓe kebbinii haala. ");
INSERT INTO fuhbkf_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Taa nyemmbitee ɓe, sabo Baaba mooɗon ina anndi ko kaajaɗon gilla on nyaagaaki ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Onon le, inan no ndu'ortoɗon: Baaba amin gonɗo dow kammuuli, innde maa laatoo seniinde. ");
INSERT INTO fuhbkf_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Laamu maa wara. Muuyɗe maa ngaɗee dow leydi ɗo hono no ngaɗirtee dow kammuuli ni. ");
INSERT INTO fuhbkf_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Kokkaa min hannden nyaamdu heƴooru min. ");
INSERT INTO fuhbkf_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Njaafonoɗaa min hakkeeji amin, hono no min njaafortoo waɗooɓe min hakkeeji ni. ");
INSERT INTO fuhbkf_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Taa accu min njarribee, ammaa hisin min e Bonɗo oon. Sabo laamu e baawɗe e teddeengal ina ngoodani maa faa abada. Aamiina. ");
INSERT INTO fuhbkf_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ndelle, si on njaafake waɗooɓe on hakkeeji, Baaba mooɗon gonɗo dow kammuuli oon du yaafoto on. ");
INSERT INTO fuhbkf_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ammaa si on njaafataako toonyiiɓe on, Baaba mooɗon oon du yaafataako hakkeeji mooɗon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","—Si on cuumake, taa njurminkinee hono munaafiki'en ɓeen: ɓe ɓalinto, yalla yimɓe fuu ina anndita ɓe suumiiɓe. Goonga kaalanammi on: ɓe keɓii mbarjaari maɓɓe faa timmi. ");
INSERT INTO fuhbkf_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Aan kaa, si a suumake, mbujaa hoore maa, culmaa yeeso maa, ");
INSERT INTO fuhbkf_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","taa paamina yimɓe a cuumiiɗo. Baaba maaɗa gonɗo ley suuraare oon tan anndata. Wooɗi du Baaba maa ji'oowo ko ngaɗuɗaa e suuraare oon, yoɓete. ");
INSERT INTO fuhbkf_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","—Taa ndesanon ko'e mon jawdi adunaaru, ɗo mooƴu e puundi mbonnata, ɗo wuyɓe kelata gampuuje de mbujja. ");
INSERT INTO fuhbkf_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ndesanon ko'e mon jawdi dow kammu, ɗo fay huunde bonnataa, wanaa mooƴu wanaa puundi, ɗo wuyɓe kelataa gampuuje sakko mbujja. ");
INSERT INTO fuhbkf_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Sabo ɗo jawdi maa woni fuu, ɗoon ɓernde maa du wonata. ");
INSERT INTO fuhbkf_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","—Gite ngoni lampal ɓanndu. Si gite maa ina mbooɗi, ɓanndu maa fuu heewan annoora. ");
INSERT INTO fuhbkf_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ammaa si ɗe mbooɗaa, ɓanndu maa fuu heewan nimre. Ndelle, si ko hokkata ɓanndu maa annoora ɗuum laatake nimre fu, nimre ndeen na tekki koy! ");
INSERT INTO fuhbkf_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","—Fay gooto waawaa gollande joomiraaɓe ɗiɗo, sabo joomum wanyan gooto, de yiɗa keddiiɗo oon, maa du nanngunduran e gooto, de yawa keddiiɗo oon. On mbaawaa gollande Laamɗo e jawdi fuu nde wootere. ");
INSERT INTO fuhbkf_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ɗum le, miɗo wi'a on: taa kaɓɓu-ko'u wona e mooɗon e dow nguurndam mon - ko nyaamoton e ko njaroton. Taa ɓalli mooɗon du kaɓɓu on ko'e e ko ɓornotoɗon. Sabo nguurndam ina ɓuri nyaamdu, ɓanndu du ina ɓuri koltal, naa wanaa? ");
INSERT INTO fuhbkf_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ndaaree pooli piirooji ɗi: ɗi aawataa, ɗi taƴataa, ɗi ndesataa faa'e, ammaa Baaba mooɗon gonɗo dow kammuuli oon ina nyaamna ɗi. Onon le, wanaa oɗon ɓuri pooli teddude to woɗɗi? ");
INSERT INTO fuhbkf_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Moy e mooɗon waawi ɓeydude balɗe muuɗum fay nyalooma gooto saabe ko haɓɓi ɗum hoore? ");
INSERT INTO fuhbkf_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ko waɗi de kolte na kaɓɓi on ko'e? Ndaaree pinndiiji ladde no ɗi mawnirta: ɗi ngollataa, ɗi mottataa. ");
INSERT INTO fuhbkf_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Miɗo haalana on: fay Suleymaana e darja muuɗum fuu holtiraay hono gootel e majji ni. ");
INSERT INTO fuhbkf_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Si Laamɗo ina holtinira noon huɗo taweteeko ley ladde hannden, faɗɗeteeko e yiite jaango, wanaa o holtinan on faa ɓura noon, onon famɗuɓe hoolaare! ");
INSERT INTO fuhbkf_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ndelle, taa ko'e mon kaɓɓoo faa mbi'on: «Ɗume nyaameten? Ɗume njareten? Ɗume ɓornotoɗen?» ");
INSERT INTO fuhbkf_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Sabo kulle ɗee fuu wo ko yimɓe ɓe anndaa Laamɗo pilotoo. Si goonga, Baaba mon gonɗo dow kammuuli oon ina anndi ɗum fuu iɗum tilsani on. ");
INSERT INTO fuhbkf_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ndelle, piloɗon laamu Laamɗo tafon, kam e fonnditaare muuɗum. Ndeen ko heddii ɗuum fuu, on ɓeydante ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ndelle, taa jaango haɓɓa on ko'e, sabo jaango du wardan e ko muuɗum. Nyannde fuu, donngal muuɗum ina heƴa ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","—Taa kiitee, on kiitataake. ");
INSERT INTO fuhbkf_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Sabo no kiitortoɗon woɓɓe, noon onon du kiitorteɗon. Katin du ko etiranton woɓɓe, wo ɗuum etiranteɗon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ko waɗi de aɗa yi'a kuɗol ley yitere sakiike maa, de aan le, a taykataako leggal gonngal e ley yitere maa ndeen? ");
INSERT INTO fuhbkf_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Noy mbaawruɗaa wi'ude sakiike maa: «Sakiike, accu mi ittane kuɗol gonngol e yitere maa ngol», de aan le, wo leggal woni ley yitere maa ndeen? ");
INSERT INTO fuhbkf_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Munaafiki, ittu leggal gonngal e yitere maa ngaal tafon. Ndeen jiiɗe maa laaɓan, faa keɓaa ittaa kuɗol gonngol e yitere sakiike maa ngool. ");
INSERT INTO fuhbkf_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Taa kokkee dawaaɗi ko senii, sabo ɗi njeccoto, ɗi ŋata on. Taa cankitee kaaƴe mooɗon dime yeeso girooji, sabo ɗi njaaɓan ɗe. ");
INSERT INTO fuhbkf_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","—Ŋaaree, on keɓan. Pilee, on njiitan. Calminee, on omtante. ");
INSERT INTO fuhbkf_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Sabo ŋaariiɗo fuu heɓan. Piliiɗo fuu yiitan. Calminɗo fuu omtante. ");
INSERT INTO fuhbkf_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Moy e mooɗon hokkata ɓiyum hayre si ŋaarake ɗum buuru? ");
INSERT INTO fuhbkf_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Naa ŋaaroo ɗum liingu de hokka ɗum mboddi? ");
INSERT INTO fuhbkf_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","No mbonirɗon ni fuu, oɗon anndi no kokkirton ɓiɓɓe mon kulle lobbe, sakko Baaba mooɗon gonɗo dow kammuuli oon. Imo hokka ŋaariiɗo mo fuu ko moƴƴi. ");
INSERT INTO fuhbkf_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Ndelle, ley huunde fuu, ngaɗanee woɓɓe ko njiɗɗon ɓe ngaɗana on. Sabo ɗum pay woni ko Tawreeta Muusaa e dewte annabaaɓe ɗeen njamiri. ");
INSERT INTO fuhbkf_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","—Naatiree dammbugal paaɗungal! Sabo dammbugal naatirgal halkere ina yaaji, laawol muuɗum ngool ina hoyi, jokkooɓe ngol ɓeen du ina keewi. ");
INSERT INTO fuhbkf_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ammaa dammbugal naatirgal nguurndam ngaal ina faaɗi, laawol muuɗum ngool ina ɓillii, yiitooɓe ɗum du wo seeɗa. ");
INSERT INTO fuhbkf_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","—Tinnee e annabaaɓe fewreeɓe. Si ɓe ngarii to mooɗon fu, iɓe nga'i hono baali, de si goonga, wo ɓe cuuli jolbuɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Golle maɓɓe annditirton ɓe hono no lekki annditirtee ɓiɓɓe muuɗum ni. Cabiije ɓorataake e ngi'eehi, ƴibbe du ɓorataake e nyakkaɓere. ");
INSERT INTO fuhbkf_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Lekki lobbi fuu, wo ɓiɓɓe lobbuɓe rimata, de lekki mbonki kaa, wo ɓiɓɓe bonɓe rimata. ");
INSERT INTO fuhbkf_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Lekki lobbi waawataa rimude ɓiɓɓe bonɓe, wooɗi du lekki mbonki waawataa rimude ɓiɓɓe lobbuɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Lekki fuu ki rimataa ɓiɓɓe lobbuɓe soppete, faɗɗee e yiite. ");
INSERT INTO fuhbkf_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ndelle, golle maɓɓe annditirton ɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","—Wanaa wi'ooɓe kam «Joomam, Joomam» ɓeen fuu naatata e laamu Laamɗo. Ammaa wo waɗooɓe muuyɗe Baaba am gonɗo dow kammuuli oon, ɓeen ngoni naatooɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Nyannde darngal, heewɓe mbi'an kam: «Joomam, Joomam! Wanaa e innde maa min mbaajorii naa? Wanaa e innde maa min ndiiwri ginnaaji naa? Wanaa e innde maa min ngaɗiri kaayeefiiji keewɗi naa?» ");
INSERT INTO fuhbkf_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ndeen mbi'ammi ɓe: «Abada mi anndaano on. Mboɗɗee kam, onon waɗooɓe ko boni!» ");
INSERT INTO fuhbkf_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","—Ndelle, neɗɗo fuu kettindiiɗo haalaaji am ɗi de jokki ɗi, nanndan e jom hakkillo nyiɓuɗo suudu muuɗum dow hayre. ");
INSERT INTO fuhbkf_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ƴuwoonde toɓi, gooruuji mbubbi, keni mawɗi mbifi e mayru. Ɗum fuu ndu saamaay, sabo ndu joƴƴinaama dow hayre. ");
INSERT INTO fuhbkf_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ammaa neɗɗo fuu kettindiiɗo haalaaji am ɗi de jokkaay ɗi, ina nanndi e mo walaa hakkillo, nyiɓuɗo suudu muuɗum dow njaareendi. ");
INSERT INTO fuhbkf_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ƴuwoonde toɓi, gooruuji mbubbi, keni mawɗi mbifi e mayru. Ndu saami faa ndu halki ndu fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Nde Iisaa tilinoo e haalaaji ɗiin ndeen, jama'aaje ɗeen kaaynaama sanne e waaju makko oon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Sabo o waajorake ɓe no jom baawɗe ni, wanaa hono jannginooɓe maɓɓe Tawreeta. ");
INSERT INTO fuhbkf_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ko Iisaa jippii waamnde ndeen ɗuum, jamaa keewɗo jokki ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Wakkati oon, gorko ceppinɗo ɓattitii ɗum, hippii yeeso muuɗum, wi'i: —Joomam, si a muuyii fu, aɗa waawi dannude kam faa mi laaɓa. ");
INSERT INTO fuhbkf_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Iisaa foorti junngo mum, meemi mo, wi'i: —Mi muuyii, daɗu. Wakkati oon pay, gorko oon daɗi ceppam muuɗum, laaɓi. ");
INSERT INTO fuhbkf_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Caggal ɗuum, Iisaa wi'i mo: —Tinna taa kaalanaa ɗum fay gooto. Ammaa yahu holloy hoore maa almaami, ngaɗaa sadaka mo Muusaa yamiri oon, faa faamina ɓe a daɗii. ");
INSERT INTO fuhbkf_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Nde Iisaa naatannoo Kafarnahum ndeen, hooreejo sordaasiiɓe ɓattitii ɗum, ŋaarii ɗum mballa, wi'i: ");
INSERT INTO fuhbkf_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","—Moodibbo, golloowo am ina waalii ley suudu, sellaa faa junngo e koyngal fuu ɓantataako. Imo torrii sanne! ");
INSERT INTO fuhbkf_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Iisaa wi'i mo: —Mi waran, mi dannowa mo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ammaa hooreejo sordaasiiɓe oon jaabii, wi'i: —Moodibbo, miin, mi hewtaay ko naataa ley suudu am. Ammaa si a haalii haala ngoota tan, golloowo am oon daɗan. ");
INSERT INTO fuhbkf_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Miin e hoore am, wo mi dawranaaɗo, de miɗo dawrana sordaasiiɓe du. Si mi wi'ii gooto maɓɓe yaha fu, yahan. Si mi wi'ii goɗɗo wara, waran. Si mi wi'ii maccuɗo am waɗa huunde, waɗan. ");
INSERT INTO fuhbkf_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Nde Iisaa nannoo ɗum ndeen, ɗum haaynii ɗum sanne, wi'i jokkuɓe ɗum ɓeen: —Goonga kaalanammi on, mi yi'aay goonɗinal hono ngal sellude e Israa'iilanke fay gooto. ");
INSERT INTO fuhbkf_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Miɗo haalana on, heewɓe ƴuuran lettugal e gorgal, njooɗodoo e Ibrahiima e Isiyaaka e Yaakuuba, ɓe nyaamda ley laamu Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ammaa haannooɓe naatude laamu ɓeen, paɗɗete ley nimre wonnde yaasin ndeen. Toon bojji e ŋerƴundurde nyiiƴe ngoni. ");
INSERT INTO fuhbkf_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Caggal ɗuum, Iisaa wi'i hooreejo sordaasiiɓe oon: —Hootu. Ɗum laatane hono no ngoonɗinirɗaa ni. Wakkati oon jaati, golloowo hooreejo sordaasiiɓe oon daɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Iisaa yehi galle Piyeer, tawi esoo Piyeer debbo ina fukkii wo jontaaɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Iisaa meemi junngo makko, de o daɗi e jontere makko. O ummii, o weerni Iisaa. ");
INSERT INTO fuhbkf_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Nde hiirnoo fu, Iisaa waddanaa yimɓe heewɓe ɓe ginnaaji ngoni e muɓɓen. Konngol makko tan o riiwri ɗi, o danni nyawɓe ɓeen fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ɗum laatorake noon faa ko annabi Esaaya haalnoo ɗuum tabita nde wi'unoo: «O ittii tampiriiji meeɗen, o ronndake nyawuuji meeɗen.» ");
INSERT INTO fuhbkf_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Nde Iisaa yi'unoo jamaa oon ina fiilii ɗum ndeen, yamiri ɓe peƴƴita maayo ngoon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Jannginoowo Tawreeta gooto ɓattii, wi'i mo: —Moodibbo, to njahataa fuu mi jokkete. ");
INSERT INTO fuhbkf_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Iisaa wi'i mo: —Baagaaji ina njogii gayɗe, pooli du ina njogii cuuɗi, ammaa Ɓii Neɗɗo walaa fay nokku ɗo fukkina hoore muuɗum fowta. ");
INSERT INTO fuhbkf_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Goɗɗo, jeyaaɗo e taalibaaɓe ɓeen, wi'i mo: —Joomam, accu mi yaha mi uwowa baaba am tafon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","O jaabii oon, o wi'i: —Jokkam, accu maayɓe uwa maayɓe muɓɓen. ");
INSERT INTO fuhbkf_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ndeen Iisaa naati laana, taalibaaɓe muuɗum njokki ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Wakkati gooto, ƴuwoonde ummodii e henndu mawndu dow maayo ngoon faa bempeƴƴe ina udda laana kaan. Tawi Iisaa kaa ina ɗaanii. ");
INSERT INTO fuhbkf_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Taalibaaɓe ɓeen ɓattii mo, pindini mo, iɓe mbi'a: —Joomii amin, dannu min! Inani miɗen kalka! ");
INSERT INTO fuhbkf_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","O jaabii ɓe, o wi'i: —Ko waɗi de kulɗon? Onon famɗuɓe hoolaare! Wakkati oon, o ummii, o sappani henndu e bempeƴƴe maayo ɗeen e semmbe. Ɗum fuu ɗum deƴƴinii siw! ");
INSERT INTO fuhbkf_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ɗum haaynii taalibaaɓe ɓeen! Iɓe mbi'a: —Gorko o wo moy de fay keni e ndiyam ina ɗowtanoo ɗum? ");
INSERT INTO fuhbkf_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Nde Iisaa feƴƴitinnoo maayo fu, heetti e leydi yimɓe Gadara. Ɗoon worɓe ɗiɗo wonduɓe e ginnaaji njalti ley caabeeje, kawri e makko. Iɓe nyanngunoo faa fay gooto suusaano rewude laawol ngool. ");
INSERT INTO fuhbkf_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ɓe keddii iɓe nduka iɓe mbi'a: —Ɓii Laamɗo, ɗume njiɗɗaa waɗude min? Yalla a warii ɗo faa torraa min, gilla wakkati podaaɗo oon yottaaki naa? ");
INSERT INTO fuhbkf_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Coggal girooji manngal ina dura ɗakkol ɗoon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ginnaaji ɗiin ŋaarii mo, mbi'i: —Si riiwude min njiɗɗaa, accu min naatowa e coggal girooji ngal. ");
INSERT INTO fuhbkf_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","O wi'i ɗi: —Njehee! Ginnaaji ɗiin njalti, naatowi e girooji ɗiin. Wakkati oon, coggal ngaal fuu doggi, tellitii dow waamnde, saami ley maayo, halki. ");
INSERT INTO fuhbkf_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Durooɓe ɓeen ndoggi kooti ngalluure toon, kaalowi ko waɗi ɗuum fuu e kabaaru wondunooɓe e ginnaaji ɓeen du. ");
INSERT INTO fuhbkf_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Wakkati oon, yimɓe ngalluure ndeen fuu njalti, kawritowi to Iisaa. Nde ɓe nji'unoo mo ndeen, ɓe nyaagii mo o yalta leydi maɓɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Iisaa naati laana, feƴƴiti, warti wuro muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Yimɓe ngaddani ɗum gorko mo ɓanndu waatundu ina fukkinaa e daɗɗo. Nde o yi'unoo goonɗinal maɓɓe ngaal fu, o wi'i mo ɓanndu waatundu oon: —Ɓinngel am, sellin ɓernde maa. Hakkeeji maa njaafaama. ");
INSERT INTO fuhbkf_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Wakkati oon, jannginooɓe Tawreeta yogaaɓe miilii e ko'e muɓɓen: «Gorko o ina mbonkoo Laamɗo!» ");
INSERT INTO fuhbkf_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Iisaa faami miilooji maɓɓe, de wi'i ɓe: —Ɗume waɗi de oɗon miiloo miilooji bonɗi ɗi e ɓerɗe mooɗon? ");
INSERT INTO fuhbkf_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ɗume ɓuri hoyude? Yalla wi'ude hakkeeji makko njaafaama, naa wi'ude o ummoo, o yaha? ");
INSERT INTO fuhbkf_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ammaa, faa mi faamina on Ɓii Neɗɗo ina jogii baawɗe yaafaade hakkeeji ley adunaaru ndu... Ndeen, o wi'i mo ɓanndu waatundu oon: —Umma, hooƴu daɗɗo maa, kootaa suudu maa! ");
INSERT INTO fuhbkf_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Gorko oon ummii, hooti suudu muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Nde jama'aaje ɗeen njiinoo ɗum ndeen, kuli, ina njetta Laamɗo saabe ko hokki ɓii-Aadama baawɗe gaaɗe nii ɗe. ");
INSERT INTO fuhbkf_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Iisaa dilli ɗoon. E ley yaadu muuɗum, yi'i gorko bi'eteeɗo Matta ina jooɗii e suudu to lampo nanngetee. O wi'i ɗum: —Jokkam. Matta ummii, jokki mo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Caggal ɗuum, imo nyaama ley suudu Matta. Nanngooɓe lampo heewɓe e luttuɓe woɓɓe ngari njooɗii ina nyaamda e makko, kanko e taalibaaɓe makko. ");
INSERT INTO fuhbkf_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Farisa'en ɓeen nji'i ɗum, de na mbi'a taalibaaɓe makko ɓeen: —Ɗume waɗi de moodibbo mooɗon ina nyaamda e nanngooɓe lampo e luttuɓe woɓɓe? ");
INSERT INTO fuhbkf_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Iisaa nani ɗum, wi'i ɓe: —Wanaa celluɗo haajaa cawroowo. Wo nyawɗo haajaa cawroowo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Njehee, ekitee ko Dewtere Laamɗo wi'i: «Wo yurmeende njiɗumi, wanaa sadaka duppeteeɗo.» Sabo mi waraay faa mi nodda dartiiɓe. Wo luttuɓe ngarumi noddude. ");
INSERT INTO fuhbkf_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Wakkati oon, taalibaaɓe Yaayaa ngari to Iisaa, ƴami ɗum: —Ko waɗi de minen e Farisa'en miɗen cuumoo, de taalibaaɓe maa ɓeen kaa cuumataako? ");
INSERT INTO fuhbkf_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","O jaabii ɓe, o wi'i: —Yalla warɓe ɓangal ina mbaawi sunaade si ɓaŋuɗo ina wondi e muɓɓen naa? Ammaa nyalaaɗe ngaran ɗe ɓaŋuɗo oon ittetee hakkunde maɓɓe. E balɗe ɗeen, ɓe cuumoto. ");
INSERT INTO fuhbkf_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Fay gooto fidataa tekkere heyre e kaddungal kiinngal. Sabo tekkere heyre ndeen fooɗan kaddungal kiinngal ngaal, de ceekol ngool ɓeydoo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Katin du cabijam kesam loowataake e sumalleeji kiiɗɗi. Si ɗuum waɗii, sumalleeji ɗiin pusan, cabijam ɗam rufa, de sumalleeji ɗiin mbona. Ndelle cabijam kesam e sumalleeji kesi loowetee, faa ɗum fuu ɗum reenoo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Nde Iisaa haalannoo ɗum ndeen, hooreejo suudu waajordu gooto yottii, hippii yeeso muuɗum, wi'i: —Ɓiyam debbo heddaaki joonin pay. Ammaa war, yowu junngo maa dow makko, ndeen o ummitoto. ");
INSERT INTO fuhbkf_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Iisaa ummii jokki mo, kam e taalibaaɓe muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","E ley yaadu maɓɓe, debbo gooto mo ƴiiƴam muuɗum taccataa ko waɗata duuɓi sappo e ɗiɗi, ƴuuri gaɗa Iisaa, meemi kommbol saaya muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","O waɗii noon sabo o miilake e ɓernde makko: «Si mi heɓii fay meemude saaya makko tan, mi daɗan.» ");
INSERT INTO fuhbkf_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Iisaa yeeƴii, yi'i mo, wi'i: —Banndam debbo, sellin ɓernde maa. Goonɗinal maa dannii ma. Wakkati oon pay, debbo oon daɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Nde Iisaa yottinoo suudu hooreejo waajordu oon fu, yi'i fuufooɓe cereeli wonɓe to maayɗo toon e yimɓe heewɓe woyooɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","O wi'i ɗum'en: —Mburtee, sabo suka debbo o maayaay, wo ɗaani tan. De yimɓe ɓeen njalnorii mo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Nde ɓe njaltinanoo yaasin fu, o naati ley suudu nduun, o nanngi junngo suka debbo oon, de ummii. ");
INSERT INTO fuhbkf_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Kabaaru oon sankitii e leydi ndiin fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Nde Iisaa dillannoo toon ndeen, wumɓe ɗiɗo njokki ɗum, ina ƴeewnoo ina mbi'a: —Taan Daawda, yurma min! ");
INSERT INTO fuhbkf_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Nde o naatunoo suudu fu, wumɓe ɓeen ngari to makko. O ƴami ɗum'en, o wi'i: —Oɗon ngoonɗini miɗo waawi wallude on naa? Ɓe njaabii mo, ɓe mbi'i: —Joomii amin, miɗen ngoonɗini. ");
INSERT INTO fuhbkf_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Wakkati oon, o meemi gite maɓɓe, o wi'i: —Ɗum laatanoo on hono no ngoonɗinirɗon noon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Wakkati oon fu, ɓe mbumti. O gongini ɓe, o wi'i ɓe: —Taa kaalanee ɗum fay gooto. ");
INSERT INTO fuhbkf_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ammaa ɓe njehi ɓe caakowi kabaaru Iisaa e leydi ndiin fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Wakkati mo wumtinaaɓe ɓeen ndillannoo oon, Iisaa waddanaa katin gorko mo ginnaaru muumɗini. ");
INSERT INTO fuhbkf_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","O riiwi ginnaaru nduun tan, de muumo oon fuɗɗi haalude. Ɗum haaynii jama'aaje ɗeen fuu, ina mbi'a: —Hono ɗum yi'aaka e Israa'iila abada! ");
INSERT INTO fuhbkf_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ammaa Farisa'en wonɓe ɗoon mbi'i: —Wo hooreejo ginnaaji oon hokki mo baawɗe riiwude ginnaaji. ");
INSERT INTO fuhbkf_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Iisaa ina yiiltoo e galluuje e gure fuu, ina waajoo e ley cuuɗi baajorɗi, ina gooyna Kabaaru Lobbo dow laamu Laamɗo. Imo danna nyawuuji e male fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ko o yi'i yimɓe ɓeen ɗuum, o yurmii ɗum'en sanne, sabo wo tampuɓe, ɓilliiɓe hono baali ɗi ngalaa duroowo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Wakkati oon, o wi'i taalibaaɓe makko ɓeen: —Gese ɓennduɗe ina keewi, ammaa taƴooɓe keewaa. ");
INSERT INTO fuhbkf_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ndelle, ŋaaree Jom tayri nulda taƴooɓe ley gese muuɗum ɗeen. ");
INSERT INTO fuhbkf_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Iisaa noddi taalibaaɓe muuɗum sappo e ɗiɗo ɓeen, hokki ɗum'en baawɗe riiwude ginnaaji e dannude sii nyawuuji e male fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Inan inɗe nulaaɓe sappo e ɗiɗo ɓeen: arano maɓɓe wo Simon bi'eteeɗo Piyeer e Andire minyum, Yaakuuba ɓii Jebede e Yuhanna minyum, ");
INSERT INTO fuhbkf_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipu e Bartolome, Tomaa e Matta nanngoowo lampo oon, Yaakuuba ɓii Alfaa, kam e Tadde, ");
INSERT INTO fuhbkf_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon kiranoowo suudu baaba e Yahuuda Isikariyotto jambotooɗo mo oon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Iisaa nuli ɓe sappo e ɗiɗo, wi'i ɓe: —Taa njehee to yimɓe ɓe nganaa Alhuudiyankooɓe. Katin du taa naatee galluuje Samariya. ");
INSERT INTO fuhbkf_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ammaa njehee to suudu Israa'iila'en laatiiɓe hono baali majjuɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","To njahaton fuu, ngooynon mbi'on «laamu Laamɗo ɓadake!» ");
INSERT INTO fuhbkf_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ndannon nyawɓe, ummintinon maayɓe, ndannon seppinɓe, ndiiwon ginnaaji. On keɓirii moƴƴere nde wo dokkal, kokkitiron nde du wo dokkal. ");
INSERT INTO fuhbkf_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Taa kooƴee kaŋŋe naa cardi naa buuɗi ley jiibaaji mooɗon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Taa njaadee e fay mbasu naa saayaaji ɗiɗi. Taa njaadee e paɗe naa cabbi. Sabo dey, golloowo fuu ina haandi e nyaamdu muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Si tawii on ngarii ley ngalluure naa wuro, piloɗon beero lobbo, wooɗi keddoɗon to beero mon ɗoon faa nde ndilloton. ");
INSERT INTO fuhbkf_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Si oɗon naata ley galle, calminon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Si suudu nduun ina haandi e majjum, jam mooɗon wonda e mayru. Ammaa si ndu haandaa e majjum, jam mooɗon warta to mooɗon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Si ina woodi galle naa wuro ɗo on njaɓɓaaka naa on kettindanaaka fu, njalton to maɓɓe, piɗɗon sollaare maɓɓe wonnde e koyɗe mon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Goonga kaalanammi on: nyannde darngal, jukkungo wuro ngoon ɓuran ngo galluuje Sodoma e Gomoora bonde. ");
INSERT INTO fuhbkf_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","—Kettindee! Miɗo nula on hono wo on baali hakkunde pobbi ni. Ndelle, ƴoƴiron hono bolle, wooɗi newroɗon hono buugaali du. ");
INSERT INTO fuhbkf_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Tinnoɗon e yimɓe ɓeen, sabo ɓe njaaran on to carorɗe, ɓe piyan on dorri ley cuuɗi maɓɓe baajorɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","On njaarete yeeso sarotooɓe e kaanankooɓe saabe am, faa laatanoɗon kam seedeeɓe yeeso muɓɓen e yeeso lenyi ɗi nganaa Alhuudiya'en ɗiin. ");
INSERT INTO fuhbkf_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Si on ndarnaama e sarorde, taa mbemmbeɗon no kaaldoton naa ko kaaloton. Sabo on kokkete haalaaji ɗi kaanɗon haalude wakkati oon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ko kaaloton ɗuum ƴuurataa e mooɗon, ammaa wo Ruuhu Baaba mooɗon oon haalata ley mooɗon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Neɗɗo hokkitiran sakiike mum waree, baaba du hokkitiran ɓiyum. Ɓiɓɓe ummanto saaraaɓe muɓɓen, ngaɗa faa ɓe mbaree. ");
INSERT INTO fuhbkf_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Yimɓe fuu mbanyan on saabe am. Ammaa tinnitiiɗo faa yottii timmoode fu, kam hisintee. ");
INSERT INTO fuhbkf_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Si on torraama e wuro wooto, ndogganee wonngo. Miɗo haalana on goonga: on timmintaa gure Israa'iila ɗeen fuu faa ɗo Ɓii Neɗɗo warti. ");
INSERT INTO fuhbkf_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Taalibbo ɓuraa moodibbom, maccuɗo du ɓuraa joomum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ina heƴa ko taalibbo laatoo hono moodibbom, maccuɗo du laatoo hono joomum. Si ɓe inndirii kam, miin jom wuro «Beeljebul mawɗo ginnaaji» fu, tilay ɓe inndiran on, onon yimɓe wuro du noon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","—Ndelle, taa kulee yimɓe. Walaa fuu ko suddii ko sudditataake, walaa ko suuɗii ko ɓangintaake. ");
INSERT INTO fuhbkf_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ko kaalanammi on e nimre ɗuum, kaaltee ɗum e annoora. Ko nyo'anteɗon ɗuum, ngooynee ɗum faa dow cuuɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Taa kulee warooɓe ɓanndu, de mbaawanaa yonkiiji. Wo Laamɗo kaanɗon hulude. Kam woni baawɗo halkude ɓanndu e yonki fuu ley jahannama. ");
INSERT INTO fuhbkf_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Wanaa pooloy ɗiɗoy ina coottee mbuuɗu ngootu tan naa? Ammaa e noon fu, fay gootel e makkoy yanataa e leydi tawa wanaa e muuyɗe Baaba mooɗon oon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Wooɗi onon, fay leeɓi ko'e mon fuu wo limaaɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ndelle, taa kulee, sabo onon le, oɗon ɓuri pooli keewɗi teddude. ");
INSERT INTO fuhbkf_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Neɗɗo fuu jaɓanɗo kam yeeso yimɓe, miin du, mi jaɓan ɗum yeeso Baaba am gonɗo dow kammuuli oon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ammaa caliiɗo kam yeeso yimɓe fuu, miin du, mi saloto ɗum yeeso Baaba am gonɗo dow kammuuli oon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","—Taa miilee jam ngardumi ley adunaaru. Mi wardaay jam. Wo kaafaahi ngardumi. ");
INSERT INTO fuhbkf_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Mi warii faa mi sennda ɓiɗɗo gorko e bammum, ɓiɗɗo debbo e inna mum, debbo ɓaŋaaɗo e esum debbo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Koreeji neɗɗo laatoto wayɓe ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Korsinɗo inna mum naa bammum faa ɓuri kam fuu, fotaa laataade taalibbo am. Korsinɗo ɓiyum gorko naa debbo faa ɓuri kam fuu, fotaa laataade taalibbo am. ");
INSERT INTO fuhbkf_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Mo wakkaaki leggal muuɗum palaangal de jokki kam fu, fotaa laataade taalibbo am. ");
INSERT INTO fuhbkf_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Piliiɗo heɓtude yonki muuɗum fuu, mursan ki, ammaa mursuɗo ki saabe am fu, hewtan ki. ");
INSERT INTO fuhbkf_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","—Jaɓɓiiɗo on fuu jaɓɓake kam, jaɓɓiiɗo kam fuu jaɓɓake Nulɗo kam oon du. ");
INSERT INTO fuhbkf_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Jaɓɓiiɗo annabaajo saabe o annabaajo fuu, heɓan mbarjaari ndi annabaajo fodanaa ndiin. Jaɓɓiiɗo neɗɗo ponnditiiɗo saabe o ponnditiiɗo fuu, heɓan mbarjaari ndi ponnditiiɗo fodanaa ndiin. ");
INSERT INTO fuhbkf_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Goonga kaalanammi on: neɗɗo fuu kokkuɗo ɓurɗo famɗude e taalibaaɓe am fay horde-loonde ndiyam peewɗam saabe wo o taalibaajo am fu, waasataa heɓude mbarjaari muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Nde Iisaa tilinoo yamirde taalibaaɓe muuɗum sappo e ɗiɗo ndeen, dilli ɗoon, yehi jannginoyde e waajowaade ley galluuje piiliiɗe ɗoon ɗeen. ");
INSERT INTO fuhbkf_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yaayaa ina woni ley kasu. O nani ko Almasiihu gollata, de o nuli taalibaaɓe makko ɓeen to muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ɓe njehi ɓe lamndii ɗum: —Yalla aan woni kaanɗo warude oon, naa min ndooman goɗɗo? ");
INSERT INTO fuhbkf_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Iisaa jaabii ɓe, wi'i: —Njehee, kaalanowee Yaayaa ko nanɗon e ko njiiɗon: ");
INSERT INTO fuhbkf_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","wumɓe ina mbumta, bonnguuɓe ina njaha e koyɗe muɓɓen, seppinɓe ina cellinee, faaɗuɓe ina paaɗita, maayɓe ina ummintinee, talkaaɓe du ina kaalanee Kabaaru Lobbo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Barke woodanii mo yoppaay goonɗinde kam. ");
INSERT INTO fuhbkf_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Nde nulaaɓe Yaayaa ɓeen ndillannoo ndeen, Iisaa fuɗɗi haalande jamaa oon haala Yaayaa, wi'i ɗum'en: —Ko njaaɗon ley ladde ɗuum, wo faa ndaarowon ɗume? Yalla huɗo ko henndu dimmbata naa? ");
INSERT INTO fuhbkf_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ndelle, ɗume njaaɗon faa ndaarowon? Gorko nyaaƴoowo naa? Si goonga, nyaaƴooɓe wo ley galleeji kaanankooɓe tawetee. ");
INSERT INTO fuhbkf_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ndelle, ɗume ndaaroyɗon? Annabaajo naa? Goonga! Miɗo haalana on, imo ɓuri annabaajo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Kanko woni mo Laamɗo haali kabaaru muuɗum ley Binndi, wi'i: «Ndaaree, mi ardinante nulaaɗo am moƴƴinane laawol.» ");
INSERT INTO fuhbkf_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Goonga kaalanammi on: dimoowo fuu rimaay ɓurɗo Yaayaa lootoowo lootagal batisima oon. Tawi le, ɓurɗo famɗude ley laamu Laamɗo oon na ɓuri mo teddude. ");
INSERT INTO fuhbkf_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Gilla Yaayaa lootoowo lootagal batisima fuɗɗi waajaade, laamu Laamɗo ina fooɗoroo yeeso, de laawol muuɗum na tiiɗi. Nyannguɓe du na kabda e maggu. ");
INSERT INTO fuhbkf_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Tawreeta Muusaa e annabaaɓe fuu cappake laamu nguun faa yottii jamaanu Yaayaa. ");
INSERT INTO fuhbkf_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Si oɗon njaɓa haala maɓɓe, Yaayaa woni annabi Iliyaasa mo garol muuɗum sappaa oon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Jom nowru fuu nana. ");
INSERT INTO fuhbkf_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Ɗume mbaawumi nanndinde yimɓe jamaanu o? Iɓe nanndi e sukaaɓe jooɗiiɓe e taliyaaje luumo, na nodda yigiraaɓe muɓɓen, na mbi'a: ");
INSERT INTO fuhbkf_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","«Min puufanii on cereeli, de on mbamaay. Min mboyanii on jimi bojji, de on mboyaay.» ");
INSERT INTO fuhbkf_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Sabo Yaayaa warii, wo cuumotooɗo, yarataa doro, de yimɓe na mbi'a wo gonduɗo e ginnaaru. ");
INSERT INTO fuhbkf_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ɓii Neɗɗo du warii ina nyaama, ina yara, de yimɓe na mbi'a: «Ndaar neɗɗo o, kakkilanɗo nyaamude e yarude tan, yigoo nanngooɓe lampo e luttuɓe woɓɓe!» Ammaa ko hakkillo Laamɗo gollata ɗuum ina holla wo ngo goonga. ");
INSERT INTO fuhbkf_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Caggal ɗuum, Iisaa fuɗɗi felude gure ɗe o ɓuri waɗude kaayeefiiji e ley muɓɓen ɗeen, sabo wonɓe ley gure ɗeen tuubaay. O wi'i: ");
INSERT INTO fuhbkf_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—Bone woodanii ma, aan Korasin! Bone woodanii ma, aan Baytisayda! Sabo si kaayeefiiji gaɗanooɗi e ley mooɗon ɗiin ngaɗanooma Tirus e Sidon fu, tawete wonɓe toon ɓeen tuubiino law. Tawete ɓe ɓornakeno tekke bootooji, ɓe njooɗakeno ley ndoondi faa ɓe kolla ɓe tuubii. ");
INSERT INTO fuhbkf_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Saabe ɗum, miɗo wi'a on: nyannde darngal, jukkungo mooɗon ɓuran ngo Tirus e Sidon ngoon bonde. ");
INSERT INTO fuhbkf_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Aan du Kafarnahum, aɗa miiloo a toownete faa yaha kammu naa? A leeƴinte faa kettaa ley maayɓe. Sabo si kaayeefiiji gaɗanooɗi e ley maaɗa ɗiin ngaɗanooma Sodoma fu, tawete wuro ngoon heddotono faa joonin. ");
INSERT INTO fuhbkf_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Saabe ɗum, miɗo wi'a on: nyannde darngal, jukkungo mooɗon ɓuran ngo Sodoma ngoon bonde. ");
INSERT INTO fuhbkf_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Wakkati oon, Iisaa adi haala, wi'i: —Baaba, jom kammu e leydi, mi yettii ma, sabo a suuɗii kulle ɗe jom'en hakkillo e jom'en anndal, de ɓanginanɗaa ɗe cukaloy. ");
INSERT INTO fuhbkf_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ayyo, noon jaati Baaba, sabo ɗum weli maa. ");
INSERT INTO fuhbkf_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Baaba am wattii huunde fuu ley junngo am. Fay gooto anndaa Ɓiɗɗo oon si wanaa Baabiiwo. Fay gooto anndaa Baabiiwo du si wanaa Ɓiɗɗo, e mo Ɓiɗɗo oon muuyi ɓanginande. ");
INSERT INTO fuhbkf_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Onon tampuɓe, ronndiiɓe doŋle tedduɗe, on fuu ngaree to am faa mi fowtina on. ");
INSERT INTO fuhbkf_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Leeƴinee ko'e mon ley hoorewaaku am faa mi ɗowa on, accon mi janngina on. Sabo mi keesindiiɗo jom ɓernde leeƴunde, yonkiiji mooɗon keɓan powtiri. ");
INSERT INTO fuhbkf_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Sabo ko njamirammi on ɗuum ina hoyi ronndaade, donngal am du ina huyfi. ");
INSERT INTO fuhbkf_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Wakkati oon, Iisaa e taalibaaɓe muuɗum ina ceeka gese nyannde fowteteende. Taalibaaɓe makko njolbi, de na itta cammeeji alkama, ina ƴakka. ");
INSERT INTO fuhbkf_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Nde Farisa'en ɓeen nji'unoo ɗum ndeen, ina mbi'a mo: —Ndaaru, taalibaaɓe maa ɓeen ina ngolla ko haɗaa golleede nyalaande fowteteende! ");
INSERT INTO fuhbkf_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","O jaabii ɓe, o wi'i: —Yalla on njanngaay ko Daawda waɗi nde yolbunoo, kam e yaadiraaɓe muuɗum naa? ");
INSERT INTO fuhbkf_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","O naati e ley hukum ceniiɗo, kanko e yaadiraaɓe makko, de ɓe nyaami buuru cakkaaɗo. Wooɗi, ɓe ngalaano laawol nyaamude ɗum, almaami'en tan njeyi nyaamude ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Maa du, on njanngaay e ley Tawreeta Muusaa no almaami'en ngollirta ley suudu dewal mawndu nduun fay nyannde fowteteende naa? Iɓe lutta yamiroore nyannde ndeen, de ɗum felataa ɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Miɗo wi'a on: ko ɓuri suudu dewal mawndu ina ɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Si on paamiino ko haala Laamɗo ka fiirtata: «Yurmeende njiɗumi, wanaa sadaka duppeteeɗo», on carataakono laaɓuɓe ɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Sabo Ɓii Neɗɗo kam jeyi nyannde fowteteende. ");
INSERT INTO fuhbkf_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Iisaa dilli ɗoon, naatowi suudu maɓɓe waajordu. ");
INSERT INTO fuhbkf_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Gorko mo junngo waanngo ina woni ɗoon. Wonɓe ɗoon ɓeen ina piloo ko pelira Iisaa, de ɓe ƴami ɗum: —Yalla dannude goɗɗo nyannde fowteteende haɗaaka naa? ");
INSERT INTO fuhbkf_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","O jaabii ɓe, o wi'i: —Si gooto mooɗon ina jogii mbaalu ngootu, de ngu saamii ley luggere nyalaande fowteteende fu, wanaa joomum yaltinowan ngu naa? ");
INSERT INTO fuhbkf_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Oɗon anndi neɗɗo ina ɓuri mbaalu ɗo woɗɗi! Ndelle, ina daganii waɗande neɗɗo ko wooɗi nyannde fowteteende. ");
INSERT INTO fuhbkf_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Caggal ɗuum, o wi'i gorko oon: —Foortu junngo maa! O foorti ngo tan, ngo daɗi faa ngo warti hono no heddiingo ngoon noon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Farisa'en ɓeen njalti, kawriti faa ndawrida no mbarda Iisaa. ");
INSERT INTO fuhbkf_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Nde Iisaa nannoo ɗum ndeen, dilli nokku oon, de yimɓe heewɓe njokki mo. O danni nyawɓe ley muɓɓen fuu, ");
INSERT INTO fuhbkf_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","o sappani ɗum'en taa kumpita fay gooto kabaaru makko. ");
INSERT INTO fuhbkf_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ɗum waɗi faa ko annabi Esaaya haalnoo ɗuum tabita nde wi'unoo: ");
INSERT INTO fuhbkf_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","«Inan golloowo am mo cuɓiimi. Miɗo horsini mo, Imo wela ɓernde am. Mi jippinan Ruuhu am dow makko, o gooynanan lenyi laawol fonnditaare. ");
INSERT INTO fuhbkf_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","O waɗataa kalala, o dukataa. Daande makko nanataake dow laabi. ");
INSERT INTO fuhbkf_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","O helataa fay ƴommbal oonyiingal, o nyifataa fay lampal ngal fooyre muuɗum famɗi faa ɗo o hokki fonnditaare jaalagol. ");
INSERT INTO fuhbkf_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Lenyi ɗiin fuu njowan jikke muɓɓen dow makko.» ");
INSERT INTO fuhbkf_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ndeen, gorko mo ginnaaru wumni muumɗini waddaa to Iisaa, de danni ɗum faa na haala, na yi'a. ");
INSERT INTO fuhbkf_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ɗum haaynii jama'aaje ɗeen fuu, de keddii ina mbi'a: —Ɗum le, wo taan Daawda oon woni ɗo naa? ");
INSERT INTO fuhbkf_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ammaa nde Farisa'en ɓeen nannoo ɗum ndeen, mbi'i: —Si gorko o na riiwa ginnaaji fu, wo e baawɗe Beeljebul, hooreejo majji o riiwrata ɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Iisaa na anndi miilooji maɓɓe, de wi'i ɓe: —Laamu fuu pecciingu ina haɓa, halkan. Katin du, si wuro naa galle feccake ina haɓa fu, heddataako. ");
INSERT INTO fuhbkf_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Si Seyɗaani riiwii ginnaaji muuɗum, feccii hoore mum. Ndelle, noy laamu muuɗum heddortoo? ");
INSERT INTO fuhbkf_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Si tawii miin miɗo riiwra ginnaaji e baawɗe Beeljebul, jokkuɓe on ɓeen le, wo e baawɗe moy ndiiwrata ɗi? Ndelle golleeji maɓɓe jaati ina kolla on ngaldaa e goonga! ");
INSERT INTO fuhbkf_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ammaa si Ruuhu Laamɗo ndiiwrammi ginnaaji, ɗum ina holla laamu Laamɗo warii to mooɗon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Iisaa ɓeydi, wi'i: —Fay gooto waawaa naatude galle gorko jom semmbe faa teeta jawdi muuɗum, sanaa artoo haɓɓa joomum tafon. Ndeen ina waawi hooƴude ko woni ley suudu muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Mo waldaa e am fuu wo ganyo am. Mo wallataa kam mi hawrundura fuu, wo cankitoowo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Saabe ɗuum, miɗo wi'a on: yimɓe ina mbaawi yaafeede hakkeeji muɓɓen e mbonkaaji muɓɓen fuu. Ammaa mbonkiiɗo Ruuhu Ceniiɗo fu yaafataake. ");
INSERT INTO fuhbkf_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Neɗɗo fuu kaalɗo ko boni e dow Ɓii Neɗɗo, ina waawi yaafeede. Ammaa neɗɗo fuu kaalɗo ko boni dow Ruuhu Ceniiɗo, yaafataake joonin, yaafataake wakkati garoowo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","—Si lekki na wooɗi fu, ɓiɓɓe muuɗum mbooɗan. Si lekki wooɗaa du, ɓiɓɓe muuɗum mbooɗataa. Sabo lekki fuu, wo ɓiɓɓe mum annditirtee. ");
INSERT INTO fuhbkf_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Onon ɓiɓɓe bolle! Noy mbaawirton haalude ko wooɗi tawee on bonɓe? Sabo ko heewi e ley ɓernde fu, wo ɗuum hunnduko wurtinta. ");
INSERT INTO fuhbkf_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Neɗɗo moƴƴo, ko moƴƴi ko resii ley ɓernde muuɗum, ɗuum wurtinta. Neɗɗo bonɗo du, ko boni ko resii ley ɓernde muuɗum, ɗuum wurtinta. ");
INSERT INTO fuhbkf_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Miɗo wi'a on: nyannde darngal yimɓe kaaltan haalaaji laaliiɗi ɗi kaalnoo fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Sabo e haalaaji maaɗa carirteɗaa wo a ponnditiiɗo maa a jukketeeɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Caggal ɗuum, jannginooɓe Tawreeta woɓɓe, e Farisa'en mbi'i Iisaa: —Moodibbo, miɗen njiɗi kollaa min maande holloore Laamɗo nuli ma. ");
INSERT INTO fuhbkf_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","O jaabii ɓe, o wi'i: —Wo jamaanu bonɗo, tuunɗo filotoo holleede maande. Ammaa maande fuu o hollataake si wanaa maande annabi Yuunusa ndeen. ");
INSERT INTO fuhbkf_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Sabo no Yuunusa waɗiri balɗe tati jemma e nyalooma ley reedu liingu manngu ni, hono noon Ɓii Neɗɗo du waɗirta balɗe tati jemma e nyalooma faa ley leydi. ");
INSERT INTO fuhbkf_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Nyannde darngal, worɓe Niniwe ummodoto e yimɓe jamaanu o, kiitodoo e muɓɓen, de liɓa ɗum'en. Sabo worɓe Niniwe tuubii nde nannoo waaju Yuunusa ndeen. Haya, ɓurɗo Yuunusa ina ɗo! ");
INSERT INTO fuhbkf_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Nyannde darngal, kaananke debbo leydi horɗoore oon ummodoto e yimɓe jamaanu o, hiitodoo e muɓɓen, de liɓa ɗum'en. Sabo o ƴuwii hoore leydi, o wari faa o hettindoo haalaaji Suleymaana kebbinaaɗi hakkilantaaku. Haya, ɓurɗo Suleymaana ina ɗo! ");
INSERT INTO fuhbkf_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","—Si ginnaaru wurtake e neɗɗo fu, ndu yiiltoyto e nokkuuje joorɗe indu filoo ɗo ndu ŋootta, de ndu heɓataa. ");
INSERT INTO fuhbkf_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ndeen ndu wi'a: «Mi yeccoto suudu am ndu eggunoomi e muuɗum nduun.» Nde ndu warti fu, ndu tawan suudu nduun wo ɓoldu, fiisaama, moƴƴinaama. ");
INSERT INTO fuhbkf_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ndeen ndu yaha, ndu waddowa ginnaaji jeɗɗi ɓurɗi ndu bonde. Ɗi naata, ɗi koɗa ley toon. Nii cakitte neɗɗo oon ɓurdata arande muuɗum bonde. Nii du yimɓe jamaanu bonɗo o laatortoo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Nde Iisaa haaldannoo e jamaa oon ndeen, inna muuɗum e minyiraaɓe muuɗum worɓe njottii. Ɓe ndarii yaasin, iɓe njiɗi yi'ude mo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Goɗɗo wi'i mo: —Inan inna maa e minyiraaɓe maa ina ndarii yaasin, ina njiɗi yi'ude ma. ");
INSERT INTO fuhbkf_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","O jaabii neɗɗo oon, o wi'i ɗum: —Moy woni inna am? Ɓeye ngoni minyiraaɓe am? ");
INSERT INTO fuhbkf_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","O sappii taalibaaɓe makko ɓeen, o wi'i: —Inan inna am e minyiraaɓe am. ");
INSERT INTO fuhbkf_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Sabo wo gaɗoowo muuyɗe Baaba am gonɗo dow kammuuli oon, kam woni minyam gorko naa minyam debbo naa inna am. ");
INSERT INTO fuhbkf_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ley nyalooma oon, Iisaa na wonnoo ley suudu de yalti, jooɗowii daande maayo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Jama'aaje keewɗe ngari, piilii mo faa o naati laana ndiyam, o jooɗii ley makka. Yimɓe ɓeen fuu ndarii to daande ndiyam ɗaam. ");
INSERT INTO fuhbkf_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","O banndani ɓe banndi keewɗi. Imo wi'a: —Aawoowo yalti faa saaka aawdi. ");
INSERT INTO fuhbkf_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","E ley aawugol ngool, aawdi ngondi ndiin saami e laawol, de pooli ngari cuɓi ndi. ");
INSERT INTO fuhbkf_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Yoga mayri saami e korokaaƴe ɗo leydi heewaa. Ndi fuɗi law sabo leydi ndiin ɗuuɗaa. ");
INSERT INTO fuhbkf_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Kaa nde naange wulnoo ndeen, ndi ɗayli, ndi yoori sabo ndi waɗaay ɗaɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Yoga mayri saami ɗo kebbe puɗata. Kebbe ɗeen mawni, ɓilli ndi. ");
INSERT INTO fuhbkf_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Yoga mayri saami e leydi lobbiri. Ndi fuɗi, ndi rimi: yoga ɓeydake kile hemre, yoga capanɗe jeegom, yoga capanɗe tati. ");
INSERT INTO fuhbkf_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Jom nowru fuu nana! ");
INSERT INTO fuhbkf_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Wakkati oon, taalibaaɓe ɓeen ɓattii Iisaa ƴami mo, mbi'i: —Ɗume waɗi de aɗa haalirana yimɓe banndi? ");
INSERT INTO fuhbkf_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","O jaabii ɓe, o wi'i: —Onon, on kokkaama faamude ko suuɗii e kabaaru laamu Laamɗo. De kamɓe kaa, ɓe kokkaaka ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Sabo neɗɗo fuu jogiiɗo paamal dow laamu Laamɗo, ɓeydante faa heewa. Ammaa mo walaa paamal oon, fay seeɗa ko jogii ɗuum, teetete. ");
INSERT INTO fuhbkf_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ɗum waɗi de miɗo haalirana ɓe banndi, sabo iɓe ndaara, de ɓe nji'ataa, iɓe kettindoo du, de ɓe nanataa, ɓe paamataa. ");
INSERT INTO fuhbkf_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Noon ko annabi Esaaya haali ɗuum tabitiri dow maɓɓe nde wi'unoo: «On nanan faa wooɗa, de on paamataa. On ndaaran faa laaɓa, de on nji'ataa. ");
INSERT INTO fuhbkf_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Sabo yimɓe lenyol ngol na njoori ɓerɗe: Ɓe cukkii noppi maɓɓe, ɓe muɓɓii gite maɓɓe, taa gite maɓɓe nji'a, taa noppi maɓɓe nana, taa hakkillooji maɓɓe paama, taa ɓe tuuba, de mi danna ɓe.» ");
INSERT INTO fuhbkf_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ammaa onon, barke woodanii on: gite mooɗon ina nji'a, noppi mooɗon du ina nana! ");
INSERT INTO fuhbkf_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Goonga kaalanammi on: annabaaɓe heewɓe e fonnditiiɓe heewɓe muuyiino yi'ude ko nji'oton ɗuum, de ɓe nji'aay. Ɓe muuyiino nanude ko nanoton ɗuum, de ɓe nanaay. ");
INSERT INTO fuhbkf_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","—Ndelle, kettindee maanaa banndol aawoowo ngol. ");
INSERT INTO fuhbkf_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Neɗɗo fuu nanɗo haala laamu Laamɗo de tawi faamaay ɗum, bonɗo oon waran, itta ko aawaa e ɓernde muuɗum. Kabaaru neɗɗo oon ina nanndi e aawdi caamundi sera laawol ndiin. ");
INSERT INTO fuhbkf_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Kabaaru aawdi caamundi e korokaaƴe ndiin, ina nanndi e neɗɗo nanoowo konngol ngool de jaɓɓoroo ngol seyo wakkati oon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ammaa ngol walaa ɗaɗi e neɗɗo oon. O nanngan ngol wakkati seeɗa tan. Nde ɓillaare naa torra hewti mo saabe konngol ngool fu, o yoppan ngol wakkati gooto. ");
INSERT INTO fuhbkf_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Kabaaru aawdi caamundi e kebbe ndiin, ina nanndi e neɗɗo nanoowo konngol ngool, de kaɓɓu-ko'u adunaaru e eytugol jawdi ɓilla ngol, ngol laatoo dimarol. ");
INSERT INTO fuhbkf_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ammaa kabaaru aawdi caamundi e leydi lobbiri ndiin, ɓeen ngoni nanooɓe konngol ngool de paama ngol. Wakkati oon, ɓe ndiman ɓiɓɓe: yoga hemre, yoga capanɗe jeegom, yoga capanɗe tati. ");
INSERT INTO fuhbkf_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Iisaa haalani ɓe banndol gonngol, wi'i: —Inan no laamu Laamɗo nanndi: wo hono gorko aawuɗo aawdi lobbiri ley ngesa muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ammaa nde yimɓe fuu ɗaaninoo ndeen, ganyo makko wari, aawi huɗo bonko e ley ngesa makko alkama ngaan, de dilli. ");
INSERT INTO fuhbkf_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Nde aawdi ndiin fuɗunoo faa rimi fu, huɗo bonko koon du ɓangi. ");
INSERT INTO fuhbkf_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Maccuɓe ɓeen njehi mbi'owi jom ngesa oon: «Joomii amin, wanaa aawdi lobbiri aawuɗaa e ngesa maa nga naa? Ndelle toy huɗo koon ƴuuri?» ");
INSERT INTO fuhbkf_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","O jaabii ɓe, o wi'i: «Wo ganyo gomma waɗi ɗum.» De maccuɓe ɓeen ƴami mo, mbi'i: «Aɗa yiɗi min njaha min ɗoofowa huɗo koon naa?» ");
INSERT INTO fuhbkf_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ammaa o jaabii ɓe, o wi'i: «A'aa. Si oɗon ɗoofa huɗo bonko koon fu, hasii on ɗoofidan e alkama oon du. ");
INSERT INTO fuhbkf_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Accidee ko e alkama oon faa tayri. Ndeen, mi wi'an taƴooɓe ɓeen ɗoofa ko tafon, ɓe ngaɗa ko kaɓɓe faa ko wulee. Si ɓe ngaɗii ɗum fuu, ɓe taƴa alkama oon. Ndeen ɓe kawrundura ɗum ley beembal am.» ");
INSERT INTO fuhbkf_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Iisaa haalani ɓe banndol gonngol, wi'i: —Laamu Laamɗo ina nanndi e gabbel lekki mutaari ngel neɗɗo hooƴi, de aawi ley ngesa muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Gabbel ngeel ɓuri gabbe fuu famɗude, ammaa si ngel fuɗii fu, ngel ɓuran leɗɗe sardiŋe fuu. Ngel laatoto lekki faa pooli ngara nyiɓa cuuɗi muɓɓen e licce makki. ");
INSERT INTO fuhbkf_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","O banndani ɓe banndol gonngol, o wi'i: —Laamu Laamɗo ina nanndi e rabilla mo debbo hooƴi, diibunduri e etirɗe conndi tati mawɗe faa ɗum fuu ɗum ƴuufi. ");
INSERT INTO fuhbkf_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ɗum fuu, Iisaa banndanii jama'aaje ɗeen. Walaa fuu ko o haalani yimɓe si wanaa e banndol. ");
INSERT INTO fuhbkf_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","O waɗirii noon faa haala ka annabaajo haalnoo kaan tabita nde wi'unoo: «Mi haaldanan ɓe banndi, mi haalanan ɓe kulle cuuɗaaɗe gilla adunaaru joƴƴinaaka.» ");
INSERT INTO fuhbkf_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Caggal ɗuum, Iisaa yoppi yimɓe ɓeen, naati ley suudu. Taalibaaɓe muuɗum ɓeen ɓattii ɗum, mbi'i ɗum: —Fiirtan min banndol huɗo ley ngesa ngool. ");
INSERT INTO fuhbkf_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","O jaabii ɓe, o wi'i: —Aawɗo aawdi lobbiri ndiin oon woni Ɓii Neɗɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ngesa ngaan woni adunaaru ndu. Aawdi lobbiri ndiin wo ɓiɓɓe laamu Laamɗo. Huɗo bonko koon wo ɓiɓɓe bonɗo oon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ganyo aawɗo huɗo bonko oon wo Ibiliisa. Tayri ndiin wo timmoode adunaaru, taƴooɓe ɓeen wo maleyka'en. ");
INSERT INTO fuhbkf_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Hono no huɗo bonko ittirtee faɗɗee e yiite ni, noon timmoode adunaaru laatortoo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ɓii Neɗɗo nulan maleyka'en muuɗum, itta luttinooɓe woɓɓe e waɗooɓe ko boni fuu e ley laamu muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ɓe paɗɗa ɗum'en e yiite jahannama. Toon bojji e ŋerƴundurde nyiiƴe ngoni. ");
INSERT INTO fuhbkf_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ammaa wakkati oon, fonnditiiɓe ɓeen njalbiran hono naange e ley laamu Baaba muɓɓen. Jom nowru fuu, nana! ");
INSERT INTO fuhbkf_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","—Laamu Laamɗo ina nanndi e jawdi cuuɗiindi e ley ngesa. Gorko gomma ukkii e mayri, de suuɗi ndi katin. E ley seyo makko, o yehi, o sonnowi ko o joginoo fuu, de o soodi ngesa ngaan. ");
INSERT INTO fuhbkf_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Laamu Laamɗo na nanndi katin hono luumotooɗo pilotooɗo kaaƴe dime. ");
INSERT INTO fuhbkf_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Si joomum yi'ii hayre rimre heewunde coggu, yahan sonna ko jogii fuu de sooda hayre ndeen. ");
INSERT INTO fuhbkf_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","—Laamu Laamɗo ina wa'i katin hono fiil paɗɗaaɗo e maayo, de nanngi sii liƴƴi fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Nde fiil oon heewunoo fu, filotooɓe liƴƴi ɓeen pooɗiri ɗum to daande ndiyam. Ɓe njooɗii iɓe cennda liƴƴi ɗiin. Liƴƴi lobbi ina ngattee ley kandeeje, bonɗi ɗiin du ina paɗɗee. ");
INSERT INTO fuhbkf_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Hono noon timmoode adunaaru laatortoo. Maleyka'en ngaran cennda bonɓe e moƴƴuɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ɓe paɗɗa bonɓe ɓeen e ley yiite jahannama. Toon bojji e ŋerƴundurde nyiiƴe ngoni. ");
INSERT INTO fuhbkf_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Iisaa ƴami ɓe, wi'i: —On paamii ɗum fuu naa? Ɓe njaabii, ɓe mbi'i: —Ayyo, min paamii. ");
INSERT INTO fuhbkf_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Caggal ɗuum, o wi'i ɓe: —Jannginoowo Tawreeta fuu laatiiɗo taalibbo ley laamu Laamɗo, ina nanndi e jom galle jaltinoowo kulle kese e kulle kiiɗɗe e ley resirde muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Nde Iisaa tilinoo e banndi ɗiin ndeen, dilli ɗoon, ");
INSERT INTO fuhbkf_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","de hooti wuro ngo mawni ngoon. Imo waajoo e suudu maɓɓe waajordu. Ɗum haaynii yimɓe hettindotooɓe ɓeen sanne, keddii ina mbi'a: —Faa toy o heɓi hakkillo ngo? Noy o heɓiri baawɗe waɗude kaayeefiiji ɗi? ");
INSERT INTO fuhbkf_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Yalla wanaa kanko woni ɓii cehoowo leɗɗe oon naa? Wanaa Mariyama woni inniiko naa? Yalla o wanaa mawnoo Yaakuuba e Yuusufi e Simon e Yahuuda naa? ");
INSERT INTO fuhbkf_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Wanaa enen e minyiraaɓe makko rewɓe koddi? Ndelle, toy o heɓi ɗum fuu? ");
INSERT INTO fuhbkf_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ɗum saabanii ɓe salaade mo. Caggal ɗuum, o wi'i ɓe: —Annabaajo ina teddinee e nokku fuu, si wanaa e ley wuro muuɗum, e ley suudu muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Iisaa waɗaay ɗoon kaayeefiiji keewɗi sabo ɓe ngoonɗinaay ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Wakkati oon, Hirudus hooreejo leydi Galili oon nani kabaaru Iisaa ina haalee. ");
INSERT INTO fuhbkf_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","O wi'i gollooɓe makko: —Ɗum wo Yaayaa lootoowo lootagal batisima! Wo kanko iirtii! Ɗum waɗi de imo jogii baawɗe waɗude kaayeefiiji. ");
INSERT INTO fuhbkf_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Tawi Hirudus yamiriino Yaayaa nanngee, haɓɓee, uddee ley kasu. O waɗii ɗum saabe debbo bi'eteeɗo Hirudiya, jom suudu mawniiko bi'eteeɗo Filipu. ");
INSERT INTO fuhbkf_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Sabo Yaayaa ina wi'annoo Hirudus: —Daganaaki ma teetaa Hirudiya, sabo o dee mawna. ");
INSERT INTO fuhbkf_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Hirudus na yiɗunoo warude mo ammaa suusaano yimɓe ɓeen, sabo ɓe fuu iɓe njogorii Yaayaa wo annabaajo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ɗum le, nyannde miccitagol rimeede Hirudus, ɓii Hirudiya debbo wami yeeso noddaaɓe ɓeen. Hirudus weltii sanne, ");
INSERT INTO fuhbkf_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","faa hunii hokkan mo huunde fuu ko o ŋaarii ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Surbaajo oon jokki haala inna muuɗum, wi'i Hirudus: —Waddanam ɗo hoore Yaayaa lootoowo lootagal batisima oon e ley le'al! ");
INSERT INTO fuhbkf_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ɗum metti ɓernde Hirudus. Ammaa saabe ko hunii ɗuum e saabe noddaaɓe ɓeen, yamiri surbaajo oon hokkee ko ŋaarii ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","O nuli goɗɗo yaha taƴowa hoore Yaayaa ley kasu toon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Hoore ndeen taƴaa tummbaa ley le'al, de hokkaa suka debbo oon. Kam du hokkowi nde inna muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Taalibaaɓe Yaayaa ɓeen ngari kooƴi ɓanndu nduun, uwoyi. Caggal ɗuum, ɓe njehi, ɓe kaalanowi Iisaa ko waɗi ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Nde Iisaa nannoo kabaaru maayde Yaayaa ndeen, dilli ɗoon, naati laana ndiyam. O fonndii nokku perwuɗo, kanko tan. Nde yimɓe nannoo ɗum fu, njalti e galluuje ɗeen, takkii daande maayo ngoon, njokki mo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Nde o yaltunoo e laana kaan ndeen, o yi'i jamaa keewɗo. O yurmii ɗum'en sanne, o danni nyawɓe wonɓe ley muɓɓen. ");
INSERT INTO fuhbkf_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Nde hiirunoo ndeen, taalibaaɓe ɓeen ɓattitii Iisaa, mbi'i ɗum: —Joonin kaa hiirii. Nokku o du wo ladde. Mbi'aa jamaa oon yaha, naatowa gure faa coodowa ko nyaama toon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","O jaabii ɓe, o wi'i: —Fotaa ko ɓe njaha. Onon e ko'e mooɗon, kokkee ɓe ko ɓe nyaama. ");
INSERT INTO fuhbkf_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ɓe njaabii mo, ɓe mbi'i: —Buuruuje joy e liƴƴi ɗiɗi tan min njogii. ");
INSERT INTO fuhbkf_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","O wi'i ɓe: —Ngaddanee kam ɗum ga. ");
INSERT INTO fuhbkf_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","O yamiri yimɓe ɓeen njooɗoo dow huɗo. O hooƴi buuruuje joy ɗeen e liƴƴi ɗiɗi ɗiin, de o tiggitii kammu, o yetti Laamɗo. O taƴi buuru oon, o hokki taalibaaɓe ɓeen kokka jamaa oon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ɓe fuu ɓe nyaami faa ɓe kaari. Taalibaaɓe ɓeen kawrunduri kelte keddiiɗe ɗeen, kebbini kandeeje sappo e ɗiɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Nyaamuɓe ɓeen ina ngaɗa hono worɓe ujunaaje njoyo ko waldaa e rewɓe e sukaaɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Wakkati oon ni, o yamiri taalibaaɓe ɓeen naata laana kaan, ardoo peƴƴita maayo ngoon, faa o waynoo jamaa oon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Caggal o waynake jamaa oon, o ƴeeŋowi dow waamnde faa o waɗa du'aare kanko tan. Naange yanii, tawi kanko tan woni toon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ndeen tawi laana kaan woɗɗowake ley ndiyam toon. Bempeƴƴe ina piya ka, sabo ika hawra e henndu. ");
INSERT INTO fuhbkf_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Nde ɓadinoo weetude ndeen, imo wara to taalibaaɓe ɓeen, imo yaha e koyɗe dow ndiyam ɗaam. ");
INSERT INTO fuhbkf_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ammaa nde ɓe nji'unoo mo imo yaha dow ndiyam ɗaam fu, nesiiji maɓɓe taƴi, ɓe mbi'i: —Wo ɗum mbeelu! Ɓe mbaaydiri kulol. ");
INSERT INTO fuhbkf_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Wakkati oon fu, Iisaa wi'i ɓe: —Cellinee ɓerɗe mon! Wo miin. Taa kulee! ");
INSERT INTO fuhbkf_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Piyeer jaabii mo, wi'i: —Joomam, si wo aan fu, njamiraa kam mi wara to maa dow ndiyam ɗam. ");
INSERT INTO fuhbkf_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Iisaa jaabii mo, wi'i: —War! Piyeer yalti laana kaan, ina yaha dow ndiyam ɗaam, ina fonndii to Iisaa. ");
INSERT INTO fuhbkf_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ammaa nde o yi'unoo henndu nduun sattii ndeen, o huli. O fuɗɗi yoolaade. O wulli, o wi'i: —Joomam, hisinam! ");
INSERT INTO fuhbkf_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Wakkati oon fu, Iisaa foorti junngo mum, nanngi mo, wi'i: —Hey pamɗuɗo goonɗinal. Ko waɗi cikkitirɗaa? ");
INSERT INTO fuhbkf_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Caggal ɗuum ɓe ɗiɗo fuu, ɓe naati laana kaan. Wakkati oon, henndu nduun darii. ");
INSERT INTO fuhbkf_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ndeen taalibaaɓe wonɓe ley laana kaan ɓeen cujidani mo, mbi'i: —Tannyoral, aan woni Ɓii Laamɗo! ");
INSERT INTO fuhbkf_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ɓe peƴƴiti maayo ngoon, ɓe njottii leydi Genesaret. ");
INSERT INTO fuhbkf_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Worɓe nokku oon annditi mo, kaalani leydi ndiin fuu garol makko. Yimɓe ɓeen ngaddani mo nyawɓe muɓɓen fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ɓe nyaagii mo o acca nyawɓe ɓeen meema fay si wo kommbol saaya makko tan. Meemuɗo ngol du fuu daɗii. ");
INSERT INTO fuhbkf_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Farisa'en e jannginooɓe Tawreeta ƴuuri Urusaliima, ngari to Iisaa ƴami ɗum, mbi'i: ");
INSERT INTO fuhbkf_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—Ɗume waɗi de taalibaaɓe maa ɓeen ina lutta al'aadaaji maamiraaɓe meeɗen ɗiin? Sabo ɓe lootataa juuɗe maɓɓe fadde maɓɓe e nyaamude. ");
INSERT INTO fuhbkf_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Iisaa jaabii ɓe, wi'i: —Onon le, ɗume waɗi de oɗon lutta yamiroore Laamɗo ndeen faa njokkon al'aada mooɗon? ");
INSERT INTO fuhbkf_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Sabo Laamɗo wi'ii: «Teddin bammaa e inna maa.» O wi'i katin: «Kuɗuɗo bammum naa inna mum, wareede laatoo jukkungo muuɗum.» ");
INSERT INTO fuhbkf_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ammaa onon le, oɗon mbi'a ina heƴa si neɗɗo wi'ii bammum naa inna mum: «Ko kaannoomi wallirde ma ɗuum wo ngeɗu Laamɗo». ");
INSERT INTO fuhbkf_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ko mbi'oton noon ɗuum, oɗon kaɗa yimɓe teddinde saaraaɓe muɓɓen katin. Hono noon tosirton konngol Laamɗo, faa njokkon al'aada mooɗon! ");
INSERT INTO fuhbkf_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Onon munaafiki'en! Annabi Esaaya woofaay fey nde sappinoo on, wi'unoo: ");
INSERT INTO fuhbkf_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","«Laamɗo wi'ii: Lenyol ngol ina teddina kam e kunnduɗe muɓɓen, ammaa ɓerɗe muɓɓen ina mboɗɗii kam. ");
INSERT INTO fuhbkf_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ko ɓe ndewata kam ɗuum walaa nafaa fey. Si goonga, janndeeji ɗi ɓe njannginta ɗiin wo jamirooje yimɓe tan.» ");
INSERT INTO fuhbkf_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Wakkati oon, Iisaa noddi jamaa oon, wi'i ɗum: —Kettindee, paamee: ");
INSERT INTO fuhbkf_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","wanaa ko naatata e hunnduko neɗɗo ɗuum tuuninta ɗum. Wo ko wurtotoo e hunnduko ɗuum tuuninta ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Wakkati oon, taalibaaɓe ɓeen ɓattitii mo, mbi'i mo: —Yalla aɗa anndi haalaaji maa ɗiin metti Farisa'en ɓeen naa? ");
INSERT INTO fuhbkf_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","O jaabii, o wi'i: —Funngo fuu ngo Baaba am gonɗo dow kammu oon aawaay, ɗoofete. ");
INSERT INTO fuhbkf_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Accee ɓe. Wo ɓe wumɓe ɗowooɓe wumɓe! Si bumɗo ɗowii bumɗo fu, ɓe ɗiɗo fuu ɓe caaman ley luggere. ");
INSERT INTO fuhbkf_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Piyeer jaabii, wi'i mo: —Fiirtan min haala tuundi kaan. ");
INSERT INTO fuhbkf_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Iisaa wi'i: —Onon du, faa joonin ɗum laaɓanaay on naa? ");
INSERT INTO fuhbkf_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","On paamaay ko naati e hunnduko fuu yahan ley reedu, de ɗum yalta yaasin? ");
INSERT INTO fuhbkf_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ammaa ko wurtoto e hunnduko ɗuum e ɓernde ƴuurata. Wo ɗuum jaati tuuninta neɗɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Sabo e ɓernde neɗɗo miilooji bonɗi e waɗude war-hoore e jeenu e fijirde e nguyka e seedaade fewre e mbonka fuu ƴuurata. ");
INSERT INTO fuhbkf_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ɗum woni ko tuuninta neɗɗo. Ammaa nyaamude tawee lootaay juuɗe muuɗum no al'aada wi'iri ni tuunintaa neɗɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Caggal ɗuum, Iisaa dilli ɗoon, fonndii seraaji Tirus e Sidon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Debbo jeyaaɗo Kanaana koɗuɗo e leydi ndiin wari to makko, wulli, wi'i: —Joomam, taan Daawda, yurmam! Ɓiyam debbo ginnaaru ina woni e muuɗum, ina torra ɗum sanne! ");
INSERT INTO fuhbkf_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ammaa Iisaa jaabaaki mo fay huunde. Taalibaaɓe makko ɓeen ɓattitii mo, mbi'i mo: —Riiwu mo. O jokku en, imo wulla tan. ");
INSERT INTO fuhbkf_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Iisaa jaabii, wi'i: —Mi nulaaka si wanaa e baali suudu Israa'iila majjuɗi ɗiin. ");
INSERT INTO fuhbkf_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ammaa debbo oon wari, sujidi yeeso makko, wi'i: —Joomam, wallam! ");
INSERT INTO fuhbkf_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Iisaa jaabii, wi'i: —Hooƴude nyaamdu sukaaɓe, de faɗɗana dawaaɗi wooɗaa. ");
INSERT INTO fuhbkf_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Debbo oon wi'i: —Goonga, Joomam. De dawaaɗi du na nyaama nyaamdu ndu joom muɓɓen saamdinta nduun. ");
INSERT INTO fuhbkf_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ndeen, Iisaa jaabii mo, wi'i: —Hey debbo, goonɗinal maa ngal ina mawni! Wo ɗum laatane hono no njiɗirɗaa noon. Wakkati oon jaati, ɓiyiiko debbo oon daɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Iisaa dilli ɗoon, takkii daande maayo Galili. O ƴeeŋi waamnde, o jooɗii toon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Yimɓe heewɓe ngari to makko, ngaddi bonnguuɓe e wumɓe e woyɓe e muumɓe, kam e nyawɓe woɓɓe heewɓe. Ɓe ɓattini ɗum'en yeeso makko, de o danni ɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ɗum haaynii yimɓe ɓeen sanne nde nji'unoo muumɓe ina kaala, woyɓe ndaɗi, bonnguuɓe ina njaha e koyɗe muɓɓen, wumɓe ina nji'a. Yimɓe ɓeen ina njetta Laamɗo Israa'iila. ");
INSERT INTO fuhbkf_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Iisaa noddi taalibaaɓe muuɗum ɓeen, wi'i ɗum'en: —Yimɓe ɓe ina njurminii kam, sabo hannden woni balɗe tati iɓe ngondi e am, de ɓe ngalaa ko ɓe nyaama. Mi yiɗaa yoppude ɓe ndilla tawee ɓe nyaamaay, sabo hasii yolbere liɓowan ɓe dow laawol. ");
INSERT INTO fuhbkf_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Taalibaaɓe makko ɓeen mbi'i mo: —E ley ladde ɗo toy keɓeten ko nyaamnen jamaa hono o? ");
INSERT INTO fuhbkf_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","O ƴami ɓe, o wi'i: —Buuruuje foti njogiɗon? Ɓe njaabii mo, ɓe mbi'i: —Jeɗɗi, kam e liƴƴoy seeɗa min njogii. ");
INSERT INTO fuhbkf_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Caggal ɗuum, o yamiri jamaa oon jooɗoo e leydi. ");
INSERT INTO fuhbkf_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","O hooƴi buuruuje jeɗɗi ɗeen e liƴƴoy kooy. O yetti Laamɗo, o taƴi ɗe, o hokki taalibaaɓe ɓeen kokka ɗum jamaa oon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ɓe fuu ɓe nyaami faa ɓe kaari. Taalibaaɓe ɓeen kawrunduri kedde ɗeen. Ɗe keewi kandeeje jeɗɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Nyaamuɓe ɓeen wo worɓe ujunaaje nayo, ko waldaa e rewɓe e sukaaɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Caggal Iisaa waynake yimɓe ɓeen, naati laana, yehi leydi Magadan. ");
INSERT INTO fuhbkf_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Farisa'en e Saduki'en ngari to Iisaa faa ndaartindoo ɗum. Ɓe ŋaarii ɗum holla ɓe maande ƴuuroore dow kammu. ");
INSERT INTO fuhbkf_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","O jaabii ɓe, o wi'i: —Si naange yanii kammu ina wojji fu, on mbi'an welan. ");
INSERT INTO fuhbkf_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Fajiri du, si kammu ina wojji ina niɓɓi, on mbi'an ƴuwoonde toɓan. Oɗon mbaawi senndude alhaaliiji kammu, ammaa on mbaawaa senndude maandeeji wakkatiiji ɗiin! ");
INSERT INTO fuhbkf_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Wo jamaanu bonɗo, tuunɗo filotoo holleede maande. Ammaa maande fuu o hollataake, si wanaa maande annabi Yuunusa ndeen. Caggal ɗuum, o yoppi ɓe ɗoon, o dilli. ");
INSERT INTO fuhbkf_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Nde taalibaaɓe ɓeen peƴƴitannoo maayo ngoon ndeen, tawi njeggitii yooɓaade buuru. ");
INSERT INTO fuhbkf_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Iisaa wi'i ɓe: —Kakkilee, ndeentee e rabilla Farisa'en e Saduki'en oon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Taalibaaɓe ɓeen ina mbi'undura: —Wo saabe ko en njooɓaaki buuru ɗuum waɗi imo wi'a ni. ");
INSERT INTO fuhbkf_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Iisaa faami ko ɓe kaalata ɗuum, wi'i ɓe: —Ɗume waɗi de oɗon kaalda hakkunde mooɗon haala njooɓaari buuru? Onon famɗuɓe hoolaare! ");
INSERT INTO fuhbkf_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Yalla faa joonin on paamaay? Yalla on miccitaaki buuruuje joy ɗe peccanmi worɓe ujunaaje njoyo ɗeen, e kandeeje ɗe kebbinɗon kedde ɗeen? ");
INSERT INTO fuhbkf_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Yalla on miccitaaki katin buuruuje jeɗɗi ɗe peccanmi worɓe ujunaaje nayo ɗeen, e kandeeje ɗe kebbinɗon kedde ɗeen? ");
INSERT INTO fuhbkf_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Noy waɗi de on paamaay wanaa haala buuru kaalanammi on? Ndeentoɗon e rabilla Farisa'en e Saduki'en oon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ndeen taalibaaɓe ɓeen paami o wi'aay ɓe ndeentoo e ko ƴuufinta buuru ɗuum, ammaa ɓe ndeentoo e ko Farisa'en e Saduki'en njannginta ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Iisaa yehi leydi Kaysariya Filipu. Toon o ƴami taalibaaɓe makko ɓeen, o wi'i: —Moy yimɓe mbi'ata Ɓii Neɗɗo oon woni? ");
INSERT INTO fuhbkf_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ɓe njaabii, ɓe mbi'i: —Woɓɓe ina mbi'a wo a Yaayaa lootoowo lootagal batisima. Woɓɓe du ina mbi'a wo a annabi Iliyaasa. Woɓɓe katin du ina mbi'a wo a annabi Yeremiya naa gooto e annabaaɓe ɓeen. ");
INSERT INTO fuhbkf_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","O wi'i ɓe: —Onon le, moy mbi'oton ngonumi? ");
INSERT INTO fuhbkf_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simon Piyeer jaabii mo, wi'i: —Wo a Almasiihu, Ɓii Laamɗo buurɗo oon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ndeen Iisaa wi'i mo: —Barke woodanii maa, aan Simon ɓii Yuunusa. Sabo wanaa ɓii-Aadama anndini ma ɗum, wo Baaba am gonɗo dow kammuuli oon anndini ma ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Miin du, miɗo wi'e Piyeer (ɗum na fiirta «Hayre»). Dow hayre ndeen nyiɓammi kawrital am goonɗinɓe ngaal. Fay maayde e semmbe laakara fuu walaa ko waawi e maggal. ");
INSERT INTO fuhbkf_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Mi hokkete cokitirɗe laamu Laamɗo: huunde fuu ko kaɗuɗaa dow leydi, haɗete dow kammu. Huunde fuu ko njaɓuɗaa dow leydi, jaɓete dow kammu. ");
INSERT INTO fuhbkf_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ndeen, Iisaa sappani taalibaaɓe muuɗum ɓeen taa kaalana fay gooto yalla kam woni Almasiihu. ");
INSERT INTO fuhbkf_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Gilla wakkati oon, Iisaa fuɗɗi anndinde taalibaaɓe muuɗum ɓeen ina tilsani ɗum yaha Urusaliima. Toon mawɓe yimɓe e hooreeɓe almaami'en e jannginooɓe Tawreeta torran ɗum sanne, de ngaɗa waree. De nyannde tataɓerde ndeen o iirtoto. ");
INSERT INTO fuhbkf_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ndeen Piyeer toowtini mo de fuɗɗi felude mo e haalaaji makko ɗiin, wi'i: —Wo Laamɗo reene Joomam! Ɗum hewtataako ma! ");
INSERT INTO fuhbkf_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","De Iisaa kaa yeeƴii, wi'i Piyeer: —Woɗɗam aan Seyɗaani! Aɗa fergina kam e laawol am, sabo miilooji maa ɗiin ƴuuraay to Laamɗo, wo to yimɓe ɗi ƴuuri! ");
INSERT INTO fuhbkf_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Caggal ɗuum, o wi'i taalibaaɓe makko ɓeen: —Muuyɗo jokkude kam fuu, sela ndaarude hoore muuɗum, hooƴa leggal muuɗum palaangal, jokka kam. ");
INSERT INTO fuhbkf_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Sabo muuyɗo dannude yonki muuɗum fu, mursan ki. Ammaa mursuɗo ki saabe am fu, heɓtan ki. ");
INSERT INTO fuhbkf_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ɗume heɓude adunaaru ndu fuu nafata neɗɗo, si mursii yonki muuɗum? Yalla ina woodi ko neɗɗo waawi hokkitirde faa danna yonki muuɗum naa? ");
INSERT INTO fuhbkf_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Sabo Ɓii Neɗɗo oon wardan e maleyka'en muuɗum e ley teddeengal Baaba muuɗum. Wakkati oon, o barjoto mono fuu ko fotata e golle muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Goonga kaalanammi on: yoga e wonɓe ɗo maayataa tawee nji'aay Ɓii Neɗɗo ina warda e laamu muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Balɗe jeegom caggal ɗuum, Iisaa yaadi e Piyeer e sakiraaɓe ɗiɗo Yaakuuba e Yuhanna, o toowtidi e muɓɓen dow waamnde toownde. ");
INSERT INTO fuhbkf_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ɗoon alhaali makko waylitii yeeso maɓɓe. Yeeso makko ina jalba hono naange, kaddule makko du ndawni far hono annoora. ");
INSERT INTO fuhbkf_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Inan, Muusaa e Iliyaasa ɓangani ɓe, ina kaalda e makko. ");
INSERT INTO fuhbkf_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Piyeer wi'i Iisaa: —Joomam, gonal amin ɗo ina wooɗi. Si aɗa yiɗi fu, mi darnan hukumuuji tati: aan gooto, Muusaa gooto, Iliyaasa du gooto. ");
INSERT INTO fuhbkf_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","O tilaaki e haalude, faa ruulde jalboore suddi ɓe. Daande ƴuuri ley ruulde ndeen, wi'i: —O woni Ɓiyam mo korsinmi, mo ceyortoomi. Kettindanee mo! ");
INSERT INTO fuhbkf_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Nde taalibaaɓe ɓeen nannoo daande ndeen fu, kippi geese muɓɓen e leydi. Ɓe kuli sanne. ");
INSERT INTO fuhbkf_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Iisaa ɓattitii, meemi ɓe, wi'i: —Ummee, taa kulee. ");
INSERT INTO fuhbkf_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Wakkati oon, ɓe ɓanti gite maɓɓe, de ɓe nji'aay fay gooto si wanaa Iisaa tan. ");
INSERT INTO fuhbkf_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","E ley ko ɓe njippotoo waamnde ndeen ɗuum, Iisaa sappani ɓe, wi'i: —Taa kaalanee fay gooto ko nji'uɗon ɗuum faa wakkati nde Ɓii Neɗɗo ummitii e hakkunde maayɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Caggal ɗuum, taalibaaɓe ɓeen ƴami mo, mbi'i: —Ɗume waɗi de jannginooɓe Tawreeta ina mbi'a tilay annabi Iliyaasa artoo Almasiihu warude? ");
INSERT INTO fuhbkf_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","O jaabii ɓe, o wi'i: —Goonga, Iliyaasa artoto warude, moƴƴintinoo huunde fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ammaa miɗo wi'a on: Iliyaasa warii faa faltake, de ɓe annditaay ɗum, ɓe ngollii ɗum ko ɓe muuyi fuu. Hono noon ɓe torrirta Ɓii Neɗɗo oon du. ");
INSERT INTO fuhbkf_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ndeen taalibaaɓe ɓeen paami wo haala Yaayaa lootoowo lootagal batisima o haalanta ɗum'en. ");
INSERT INTO fuhbkf_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Nde ɓe ngartunoo to jamaa oon ndeen, gorko gomma ɓattitii mo, hofii yeeso makko, ");
INSERT INTO fuhbkf_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","wi'i: —Joomam, yurma ɓiyam gorko! O dabidabiyaajo, imo tampi sanne. Wakkatiiji keewɗi imo saama e yiite naa e ndiyam. ");
INSERT INTO fuhbkf_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Mi yaarii mo to taalibaaɓe maaɗa de ɓe kunngii dannude mo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Iisaa ɓattitii, wi'i: —Hey yimɓe jamaanu bonɗo mo walaa goonɗinal! Faa ndey ngondammi e mooɗon? Faa ndey keddotoomi munyande on? Ngaddanee kam suka o ɗo! ");
INSERT INTO fuhbkf_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","O sappani ginnaaru nduun e semmbe. Ndu yalti suka oon. Wakkati oon ni, suka oon daɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Caggal ɗuum, taalibaaɓe ɓeen toowtidi e makko, ƴami mo, mbi'i: —Ɗume waɗi de min kunngii riiwude ginnaaru nduun? ");
INSERT INTO fuhbkf_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Iisaa jaabii ɓe, wi'i: —Saabe oɗon pamɗi goonɗinal waɗi ɗum. Goonga kaalanammi on: si goonɗinal mooɗon fotii fay no gabbel lekki mutaari ni, si on mbi'ii waamnde nde: «Ƴuw ɗo, njahaa to», nde ƴuwan. Fay huunde on kunngataako waɗude.  ");
INSERT INTO fuhbkf_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Caggal ɗuum, Iisaa e taalibaaɓe muuɗum kawri katin ley leydi Galili. Iisaa wi'i ɓe: —Ɓii Neɗɗo wattete e juuɗe yimɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ɓe mbaran ɗum, de nyannde tataɓerde ndeen iirtoto. Haala kaan metti taalibaaɓe ɓeen sanne. ");
INSERT INTO fuhbkf_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Nde Iisaa e taalibaaɓe mum njottinoo Kafarnahum ndeen, nanngooɓe lampo suudu dewal mawndu ɓeen ɓattii Piyeer, mbi'i ɗum: —Yalla moodibbo mooɗon oon yoɓataa lampo suudu dewal mawndu naa? ");
INSERT INTO fuhbkf_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Piyeer jaabii, wi'i: —Imo yoɓa. Ko Piyeer naati suudu nduun ɗuum, fadde muuɗum heɓude haala, Iisaa wi'i: —Simon, ɗume miiliɗaa? Kaanankooɓe adunaaru ɓeen, moy ɓe ndoonyata? Moy ɓe njomnotoo lampo? Ɓiɓɓe laamu naa weerɓe? ");
INSERT INTO fuhbkf_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Piyeer jaabii, wi'i: —Wo weerɓe. Iisaa wi'i mo: —Ndelle, ɓiɓɓe laamu ɓeen wo rimɓe, njoɓataa. ");
INSERT INTO fuhbkf_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ammaa, en njiɗaa mettinde ɓerɗe yimɓe ɓeen. Yahu to maayo toon, paɗɗaa jammbuure maa e ley ndiyam ɗaam. Liingu ngu artiɗaa nanngude fu, njaltinaa ɗum. Si a omtii hunnduko mum, a tawan toon mbuuɗu cardi kiɓɓinoowu lampo meeɗen. Ittaa ɗum, njoɓanowaa en, enen ɗiɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Wakkati oon, taalibaaɓe ɓeen ɓattitii Iisaa, ƴami ɗum, mbi'i: —Moy ɓuri teddude ley laamu Laamɗo? ");
INSERT INTO fuhbkf_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Iisaa noddi cukalel, darni ngel yeeso maɓɓe, ");
INSERT INTO fuhbkf_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","wi'i: — Goonga kaalanammi on: sini on mbaylitaaki faa nanndon e cukaloy, on naatataa ley laamu Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Leeƴinɗo hoorem faa nanndi e cukalel ngel, kam woni ɓurɗo teddude ley laamu Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Neɗɗo fuu jaɓɓiiɗo cukalel gootel hono ngel e innde am, wo miin jaɓɓii. ");
INSERT INTO fuhbkf_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","—Neɗɗo fuu luttinɗo gootel e cukaloy goonɗinkoy kam koy, ko ɓuri moƴƴande joomum hayre teddunde haɓɓee e daande mum, yoolee ley to ɓuri luggude e maayo manngo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Bone woodanii adunaaru ndu saabe kulle luttinooje yimɓe ɗeen! Tilay kulle ɗeen ngaɗa, ammaa bone woodanii laatiiɗo sabaabu majje! ");
INSERT INTO fuhbkf_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Si tawii junngo maa naa koyngal maa luttinte, taƴaa ɗum, paɗɗaa. Naatidaa e junngo wooto naa koyngal gootal ley nguurndam nduumiiɗam ɓuri moƴƴande ma diina faɗɗeede e yiite duumiinge tawee a kiɓɓuɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Si tawii yitere maa luttinte, ittu nde, paɗɗaa. Sabo naataa nguurndam nduumiiɗam a ɗokko, ɓuri moƴƴande ma diina paɗɗeɗaa e yiite jahannama a kiɓɓuɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","—Ndeentee e yawude fay gootel e cukaloy koy. Sabo miɗo wi'a on: maleyka'en makkoy wonɓe dow kammuuli ɓeen, wakkati fuu ina ngoni yeeso Baaba am gonɗo dow kammuuli oon, ina nji'a ɗum.  ");
INSERT INTO fuhbkf_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Ɗume miilotoɗon? Si neɗɗo ina jogii baali hemre de ngootu lalli, wanaa yoppan capanɗe jeenay e jeenay ɗiin ley ferro, de filowoo majjungu nguun naa? ");
INSERT INTO fuhbkf_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Goonga kaalanammi on: si o yiitii ngu, o seyorto ngu faa ɓura capanɗe jeenay e jeenay ɗi lallaay ɗiin. ");
INSERT INTO fuhbkf_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Hono noon Baaba mooɗon gonɗo dow kammuuli oon du yiɗiraa fay gootel e cukaloy koy majja. ");
INSERT INTO fuhbkf_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","—Si sakiike maa toonyake ma, njahaa to muuɗum kollitaa ɗum toonya muuɗum oon tawee onon ɗiɗo tan. Si o jaɓanii ma, a hewtii sakiike maa. ");
INSERT INTO fuhbkf_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ammaa si o jaɓaay, njaadaa e neɗɗo gooto naa yimɓe ɗiɗo, hono no Binndi ɗiin mbiiri: «haala fuu daroo dow seedaaku yimɓe ɗiɗo naa tato.» ");
INSERT INTO fuhbkf_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Si o jaɓanaay ma, kaalanaa ɗum kawrital goonɗinɓe ngaal. Si o salake jaɓande kawrital goonɗinɓe ngaal, njogoroɗaa mo keefeero naa nanngoowo lampo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Goonga kaalanammi on: huunde fuu ko kaɗuɗon dow leydi, haɗete dow kammu. Huunde fuu ko njaɓuɗon dow leydi, jaɓete dow kammu. ");
INSERT INTO fuhbkf_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Miɗo haalana on katin: si ɗiɗo mooɗon ndewrii ley adunaaru ga dow ko ŋaarotoo Laamɗo fuu, Baaba am gonɗo dow kammuuli waɗanan on ko ŋaariɗon ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Sabo nde ɗiɗo naa tato kawriti e innde am fuu, miin du, miɗo woni hakkunde muɓɓen ɗoon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ndeen Piyeer ɓattitii Iisaa, ƴami ɗum: —Joomam, si banndam toonyake kam fu, kile foti kaanumi yaafaade ɗum? Yalla kile jeɗɗi naa? ");
INSERT INTO fuhbkf_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Iisaa jaabii mo, wi'i: —Mi wi'aay ma kile jeɗɗi tan. Njaafoɗaa ɗum kile capanɗe jeɗɗi faa nde jeɗɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Iisaa ɓeydi wi'i: —Inan no laamu Laamɗo nanndi: wo hono kaananke gooto anniyiiɗo ƴamtude gollooɓe muuɗum nyamaande. ");
INSERT INTO fuhbkf_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Nde o fuɗɗunoo ƴamtude fu, o waddanaa golloowo gooto mo o rewata miliyooji. ");
INSERT INTO fuhbkf_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Gorko oon walaa ceede ko yoɓa mo. Ɗum le, kaananke oon yamiri o sonnee, kanko e deekiiko e sukaaɓe makko e ko o jogii fuu, faa yoɓa nyamaande ndeen. ");
INSERT INTO fuhbkf_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Golloowo oon hippii yeeso kaananke oon, nyaagii ɗum, wi'i: «Munyanam, mi yoɓete fuu!» ");
INSERT INTO fuhbkf_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Kaananke oon yurmii mo, yaafanii mo nyamaande ndeen, yoppi mo o dilli. ");
INSERT INTO fuhbkf_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Golloowo oon yalti, hawri e gollidoowo muuɗum joganiiɗo ɗum ceede seeɗa. O nanngi ɗum daande, imo ɗeɗɗa, o wi'i: «Yoɓam ceede am!» ");
INSERT INTO fuhbkf_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Gollidoowo makko oon hippii e leydi, nyaagii mo, wi'i: «Munyanam, mi yoɓete!» ");
INSERT INTO fuhbkf_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ammaa o jaɓaay. O uddowi ɗum e kasu, faa ɗo yoɓi nyamaande ndeen fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Nde gollooɓe heddiiɓe ɓeen nji'unoo ɗum ndeen, mettaa sanne, njehi kaalanowi ɗum kaananke oon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ndeen, kaananke oon noddi golloowo oon, wi'i ɗum: «A golloowo bonɗo! Nde nyaaginoɗaa kam ndeen, mi yaafanake ma ko ndewanmaami ɗuum fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Aan du, a haanaano yurmaade jaado maa oon hono no njurmorimaami ni naa?» ");
INSERT INTO fuhbkf_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Kaananke oon tikki sanne, watti mo e juuɗe jukkotooɓe, faa ɗo o yoɓi nyamaande ndeen faa laaɓi. Iisaa ɓeydi, wi'i: ");
INSERT INTO fuhbkf_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","—Hono noon Baaba am gonɗo dow kammu oon waɗata neɗɗo fuu e mooɗon mo yaaforaaki sakiike mum ɓernde laaɓunde. ");
INSERT INTO fuhbkf_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Nde Iisaa tilinoo e waajuuji ɗiin ndeen, dilli Galili yehi leydi Yahuudiya, caggal gooruwol Urdun. ");
INSERT INTO fuhbkf_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Yimɓe heewɓe njokki mo. O danni toon nyawɓe muɓɓen. ");
INSERT INTO fuhbkf_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Farisa'en woɓɓe ngari to makko faa ndaartindoo mo, ƴami mo: —Yalla ina daganii gorko seerude deekum e sabaabu tawaaɗo fuu naa? ");
INSERT INTO fuhbkf_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","O jaabii, o wi'i: —Yalla on njanngaay ko Binndi ɗiin mbi'i? E fuɗɗoode Laamɗo tagii ɓe, waɗii ɓe gorko e debbo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","O wi'i: «Ɗum saabii de gorko yoppan inna mum e bammum, nanngundura e deekum, ɓe ɗiɗo fuu ɓe laatoo neɗɗo gooto.» ");
INSERT INTO fuhbkf_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Nii woni ɓe nganaa ɗiɗo katin, ɓe ɓanndu wooturu. Ndelle, taa neɗɗo sennda ko Laamɗo hawrunduri. ");
INSERT INTO fuhbkf_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ɓe ƴami mo, ɓe mbi'i: —Ndelle ko waɗi de Muusaa yamiri gorko hokka deekum talkuru ceergal si na seera ɗum? ");
INSERT INTO fuhbkf_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","O jaabii ɓe, o wi'i: —Wo saabe on yoorɓe ɓerɗe, ɗuum waɗi de Muusaa hokki on laawol ceeron rewɓe mooɗon. Ammaa ley fuɗɗoode, wanaa noon worrunoo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Miɗo wi'a on: si neɗɗo seerii deekum de wanaa saabe jeenu, si ɓaŋii debbo goɗɗo fu, jeenii. ");
INSERT INTO fuhbkf_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Taalibaaɓe makko ɓeen mbi'i mo: —Si wo nii hakkunde gorko e deekum worri, tawee neɗɗo ɓaŋaay ɗuum ɓuri wooɗude. ");
INSERT INTO fuhbkf_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Iisaa jaabii ɓe, wi'i: —Wanaa yimɓe fuu mbaawi jaɓude haala ka, sanaa ɓe Laamɗo hokki baawɗe majjum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Daliiliiji kaɗooji worɓe ɓaŋude ina ngoodi. Sabo woɓɓe ndimaama wo waatoraaɓe. Woɓɓe wo soortaaɓe. Woɓɓe du, kam'en kaɗi ko'e muɓɓen ɓaŋude faa ngollana laamu Laamɗo. Neɗɗo fuu jardiiɗo tindinoore ndeen, waɗa nde! ");
INSERT INTO fuhbkf_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Caggal ɗuum, woɓɓe ngaddi cukaloy to Iisaa faa yowa juuɗe muuɗum dow makkoy, de du'anoo koy. Ammaa taalibaaɓe ɓeen ndukani yimɓe ɓeen. ");
INSERT INTO fuhbkf_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ndeen Iisaa wi'i: —Accee cukaloy koy ngara to am. Taa kaɗee koy, sabo wo nannduɓe e makkoy ɓeen njeyi laamu Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","O yowi junngo makko dow makkoy, o barkini koy. Ndeen o dilli ɗoon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Gorko gomma ɓattitii Iisaa, ƴami ɗum, wi'i: —Moodibbo, huunde lobbere ndeye kaanumi waɗude faa mi heɓa nguurndam nduumiiɗam? ");
INSERT INTO fuhbkf_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Iisaa wi'i mo: —Ko waɗi de lamndiɗaa kam dow huunde lobbere? Laamɗo tan woni lobbo! Si aɗa yiɗi naatude e nguurndam, jokku jamirooje. ");
INSERT INTO fuhbkf_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Gorko oon ƴami Iisaa, wi'i: —Jamirooje ɗeye njokkammi? Iisaa jaabii, wi'i: —Taa waɗu war-hoore, taa jeenu, taa wujju, taa seeda fewre, ");
INSERT INTO fuhbkf_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","teddin inna maa e bammaa, njiɗiraa gondo maa no njiɗirɗaa hoore maa ni. ");
INSERT INTO fuhbkf_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Suka jokolle oon wi'i mo: —Miɗo haybi ɗum fuu. Ɗume heddii katin? ");
INSERT INTO fuhbkf_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Iisaa wi'i mo: —Si aɗa yiɗi hiɓɓude, yahu sonnoy ko njogiɗaa fuu, kokkaa ceede ɗeen talkaaɓe. Ndeen a heɓan mbarjaari dow kammu. De ngaraa, njokkaa kam. ");
INSERT INTO fuhbkf_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Nde suka jokolle oon nannoo haalaaji ɗiin ndeen, dillidi e mettorgal, sabo wo jom jawdi sanne. ");
INSERT INTO fuhbkf_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ndeen, Iisaa wi'i taalibaaɓe muuɗum ɓeen: —Goonga kaalanammi on: naatugol jom jawdi ley laamu Laamɗo ina tiiɗi! ");
INSERT INTO fuhbkf_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Miɗo haalana on du: ngeelooba naata wudde battal ɓuri hoyude diina jom jawdi naata laamu Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Nde taalibaaɓe ɓeen nannoo haala kaan ndeen, ɗum haaynii ɗum'en sanne. Iɓe mbi'a: —Ndelle, moy woni kisoowo? ");
INSERT INTO fuhbkf_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","O ndaari ɓe, o wi'i: —Yimɓe mbaawanaa ɗum, ammaa walaa fuu ko Laamɗo waawanaa. ");
INSERT INTO fuhbkf_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Piyeer hooƴi haala, wi'i mo: —Minen, min njoppii fuu, min njokkii ma. Ɗume min keɓoyta? ");
INSERT INTO fuhbkf_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Iisaa wi'i ɓe: —Goonga kaalanammi on: si Ɓii Neɗɗo oon jooɗake e jooɗorgal laamu muuɗum teddungal ley adunaaru heyru, onon sappo e ɗiɗo jokkuɓe kam ɓee du, on njooɗoto dow jooɗorɗe laamu, caroɗon lenyi Israa'iila sappo e ɗiɗi ɗiin. ");
INSERT INTO fuhbkf_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Neɗɗo fuu joppuɗo suudu mum, naa sakiraaɓe mum worɓe e rewɓe, naa inna mum, naa bammum, naa sukaaɓe mum, naa gese mum saabe am fu, heɓan ko ɓuri ɗum kile hemre, katin du heɓan nguurndam nduumiiɗam. ");
INSERT INTO fuhbkf_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ammaa ardiiɓe heewɓe laatoto gaɗaaɓe. Gaɗaaɓe heewɓe du laatoto ardiiɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","—Inan no laamu Laamɗo nanndi: wo hono jom ngesa cabiije jaltuɗo gilla fajiri faa hooƴa gollooɓe ngolla ngesa muuɗum cabiije. ");
INSERT INTO fuhbkf_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","O heɓi gollooɓe, o rewri e muɓɓen njobdi nyalooma, mbuuɗu cardi hono no woowri noon. O yaari ɓe ngesa makko. ");
INSERT INTO fuhbkf_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Wakkati nyawlal naange, o yalti katin. O yi'i woɓɓe ley luumo ɓe ngalaa golle. ");
INSERT INTO fuhbkf_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","O wi'i ɓe: «Njehee onon du ngollowon to ngesa am cabiije toon. Mi yoɓan on ko haani yoɓeede.» ");
INSERT INTO fuhbkf_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ɓeen du njehi toon. Jom ngesa oon yalti, waɗi noon katin hakkunde naange e caggal sallifana. ");
INSERT INTO fuhbkf_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Caggal ɗuum, o yalti katin wakkati laasara. O tawi woɓɓe ina keddii to luumo toon. O wi'i ɗum'en: «Ɗume waɗi de nyalluɗon ɗo on ngollaay fay huunde?» ");
INSERT INTO fuhbkf_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ɓe njaabii mo, ɓe mbi'i: «Fay gooto hooƴaay min golle.» O wi'i ɓe: «Njehee onon du ngollowon to ngesa am cabiije ngaan.» ");
INSERT INTO fuhbkf_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Nde hiirnoo fu, jom ngesa oon wi'i howruujo mum oon: «Noddu gollooɓe ɓeen de njoɓaa ɗum'en. Artoroɗaa sakitiiɓe waddeede ɓeen, de cakitoroɗaa artiiɓe ɓeen.» ");
INSERT INTO fuhbkf_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Waddaaɓe laasara ɓeen ngari, mono e muɓɓen fuu hokkaa mbuuɗu cardi. ");
INSERT INTO fuhbkf_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Artinooɓe ɓeen du ngari, cikki njoɓete ko ɓuri ɗum. Ammaa kam'en du, mono e muɓɓen fuu hokkaa mbuuɗu cardi. ");
INSERT INTO fuhbkf_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Nde ɓe njoɓanoo ɗum ndeen, iɓe ŋurŋurta jom ngesa oon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Iɓe mbi'a: «Ɓee ɗo seeɗa tan ngolli, de ɓe ponndaama e amin njobdi. Minen kaa, wo min nyallu, miɗen ngolla ley naange wulnge!» ");
INSERT INTO fuhbkf_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Jom ngesa oon jaabii gooto maɓɓe, wi'i: «Neɗɗo am, mi waɗaay ma fuu ko boni. Wanaa en ndewrii mi hooƴire mbuuɗu cardi nyalooma naa? ");
INSERT INTO fuhbkf_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ndelle, jaɓu njobdi maa, njahaa. Mi muuyii hokkude cakitiiɗo oon ko kokkumaami ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Wanaa ko weli kam ngaɗammi ceede am naa? Naa a hirii saabe moƴƴere am?» ");
INSERT INTO fuhbkf_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Iisaa wi'i: —Hono nii gaɗaaɓe laatorto ardiiɓe, ardiiɓe du laatoto gaɗaaɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Iisaa e taalibaaɓe sappo e ɗiɗo ɓeen ina ƴeeŋa, ina njaha Urusaliima. E laawol ngool, Iisaa toowtini ɓe feere, wi'i: ");
INSERT INTO fuhbkf_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Inani eɗen njaha Urusaliima. Ɗoon Ɓii Neɗɗo wattetee e juuɗe hooreeɓe almaami'en e jannginooɓe Tawreeta. Ɓe caroo mo sariya maayde. ");
INSERT INTO fuhbkf_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ɓe ngatta mo e juuɗe yimɓe ɓe nganaa Alhuudiya'en. Kam'en du njalnoroo mo, piya mo dorri, tonta mo e leggal palaangal faa o maaya. De nyannde tataɓerde ndeen o iirtoto. ");
INSERT INTO fuhbkf_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ndeen, inna ɓiɓɓe Jebede ɓattini sukaaɓe muuɗum Iisaa. O sujidi yeeso Iisaa faa o ŋaaroo ɗum huunde. ");
INSERT INTO fuhbkf_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Iisaa wi'i mo: —Ɗume njiɗɗaa? Debbo oon jaabii mo, wi'i: —Miɗo yiɗi ngaɗaa faa ɓiɓɓe am worɓe ɗiɗo ɓe njooɗoo ɗakkol maa ley laamu maa, gooto gere nyaamo maa, gooto du gere nano maa. ");
INSERT INTO fuhbkf_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Iisaa jaabii, wi'i: —On anndaa ko ŋaarotoɗon. Yalla oɗon mbaawi yardude horde mettunde nde njardammi ndeen naa? Ɓe njaabii mo, ɓe mbi'i: —Miɗen mbaawi. ");
INSERT INTO fuhbkf_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","O wi'i ɓe: —Goonga, on njardan nde. Ammaa jooɗaade gere nyaamo am naa nano am, wanaa miin yamirta ɗum. Jooɗorɗe ɗeen, wo ɓe Baaba am moƴƴinani ɓeen njeyi. ");
INSERT INTO fuhbkf_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Nde taalibaaɓe sappo heddiiɓe ɓeen nannoo ɗum ndeen, ɓernani sakiraaɓe ɗiɗo ɓeen. ");
INSERT INTO fuhbkf_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ndeen Iisaa noddi ɓe fuu, wi'i ɓe: —Oɗon anndi laamiiɓe leyɗe adunaaru ina laamorii ɗum'en doole. Mawɓe ɓeen du ina kolla yimɓe ɓeen baawɗe. ");
INSERT INTO fuhbkf_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Onon kaa, ɗum waɗataa hakkunde mooɗon. Jiɗɗo laataade tedduɗo hakkunde mooɗon fuu, ina haani laataade golloowo mooɗon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Katin du, jiɗɗo ardaade e mooɗon fuu, ina haani laataade maccuɗo mooɗon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Noon du, Ɓii Neɗɗo waraay faa gollanee, ammaa warii faa gollana yimɓe, de hokka yonki muuɗum faa laatoo coottitaari ndimɗinoori heewɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Nde Iisaa e taalibaaɓe muuɗum njaltannoo Yeriko ndeen, jamaa keewɗo jokki ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Wumɓe ɗiɗo ina njooɗii e sera laawol ngool. Ɓe nani Iisaa ina faltoo, de ɓe puɗɗi ƴeewnaade, iɓe mbi'a: —Taan Daawda, yurma min! ");
INSERT INTO fuhbkf_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Jamaa oon jawani ɓe, wi'i ɓe ndeƴƴinoo. Ammaa ɓe ɓeydi ƴeewnaade iɓe mbi'a: —Joomii amin, taan Daawda, yurma min! ");
INSERT INTO fuhbkf_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Iisaa darii, noddi ɓe, wi'i: —Ɗume njiɗuɗon mi waɗana on? ");
INSERT INTO fuhbkf_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ɓe njaabii mo, ɓe mbi'i: —Joomii amin, min mbumta. ");
INSERT INTO fuhbkf_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Iisaa yurmii ɓe, meemi gite maɓɓe. Wakkati oon pay, ɓe mbumti. Ndeen ɓe njokki ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ko Iisaa e taalibaaɓe muuɗum ɓadii Urusaliima ɗuum, njottii Baytifaaji dow waamnde wi'eteende Jaytun. Iisaa nuli taalibaaɓe ɗiɗo, ");
INSERT INTO fuhbkf_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","wi'i ɓe: —Njehee naatowee ngalluure wonnde yeeso mooɗon ndeen. Nde njottiɗon fu, on tawan toon araawa e mola muuɗum ina kaɓɓii. Kaɓɓiton ɗi, ngaddanon kam. ");
INSERT INTO fuhbkf_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Si won ko goɗɗo ƴami on e majjum, njaaboɗon ɗum joomii amin ina haajaa ɗi, de nultiran ɗi law. ");
INSERT INTO fuhbkf_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ɗum waɗi faa ko annabaajo haalnoo ɗuum tabita nde wi'unoo: ");
INSERT INTO fuhbkf_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«Mbi'ee yimɓe ngalluure Siyona: Ndaaree, inan kaananke mooɗon ina wara to mooɗon, ina leeƴinkinii, ina waɗɗii mola, ɓii mbaɗɗeteenga.» ");
INSERT INTO fuhbkf_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Wakkati oon, taalibaaɓe ɓeen njehi ngaɗowi ko Iisaa yamiri ɗum'en. ");
INSERT INTO fuhbkf_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ɓe ngaddi araawa ngaan e mola muuɗum. Ɓe njowi e majji saayaaji maɓɓe, de Iisaa waɗɗii. ");
INSERT INTO fuhbkf_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ko ɓuri heewude e jamaa oon weerti saayaaji muɓɓen dow laawol. Woɓɓe kelti licce leɗɗe, mbeerti ɗe dow laawol ngool. ");
INSERT INTO fuhbkf_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Jama'aaje gonɗe yeeso Iisaa ɗeen e jokkuɗe caggal makko fuu ina ilina, ina mbi'a: —Jettooje ngoodanii Taan Daawda! Barke woodanii garɗo e dow innde Joomiraaɗo! Jettooje ngoodanii Laamɗo faa dow kammuuli! ");
INSERT INTO fuhbkf_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Nde o naatunoo Urusaliima fu, ngalluure ndeen fuu iirii, na saaƴa. Iɓe mbi'a: —Gorko o wo moy? ");
INSERT INTO fuhbkf_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Jamaa oon jaabii: —Wo annabi Iisaa, ƴuuruɗo Nasaraatu ley leydi Galili. ");
INSERT INTO fuhbkf_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Iisaa naati taliyaare suudu dewal mawndu nduun. Ɗoon o riiwi soodooɓe e soottooɓe wonɓe ley toon fuu. O liɓi taabaaje weccooɓe ceede e jooɗorɗe soottooɓe buugaali. ");
INSERT INTO fuhbkf_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ndeen o wi'i ɓe: —Ley Binndi ɗiin Laamɗo wi'i: «Suudu am inndirte suudu waɗirdu du'aare.» Iisaa ɓeydi, wi'i: —Onon kaa, oɗon ngaɗa ndu «suuɗirdu yanooɓe!» ");
INSERT INTO fuhbkf_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Wumɓe e bonnguuɓe ngari to makko e ley suudu dewal mawndu nduun, de o danni ɗum'en. ");
INSERT INTO fuhbkf_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Hooreeɓe almaami'en e jannginooɓe Tawreeta ɓeen nji'ii kulle kaayniiɗe ɗe o waɗata. Ɓe nani du sukaaɓe ina ilina e ley suudu dewal mawndu ina mbi'a: —Jettooje ngoodanii Taan Daawda! Ɗum fuu ɗum metti ɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ɓe mbi'i Iisaa: —A nanii ko cukaloy koy mbi'ata ɗuum naa? O wi'i ɓe: —Mi nanii. Yalla abada on janngaay ɗum ɗo: «A waɗii faa kunnduɗe sukaaɓe famarɓe e musinooɓe ina njette»? ");
INSERT INTO fuhbkf_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Caggal ɗuum, o seedi e maɓɓe. O yalti ngalluure ndeen, o yehi Baytaniya, o waalowi toon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Gilla fajiri Iisaa ina yeccoo ngalluure toon, tawi ina yolbi. ");
INSERT INTO fuhbkf_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","O haynii ƴibbi e sera laawol, o fanti ki. Ammaa o tawraay ki faa'e si wanaa haako. Wakkati oon, o wi'i ki: —Taa a rimu abada katin! Wakkati oon pay, ƴibbi kiin yoori koloŋ. ");
INSERT INTO fuhbkf_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Nde taalibaaɓe ɓeen nji'unoo ɗum fu, ɗum haaynii ɗum'en. Ɓe ƴami Iisaa, ɓe mbi'i: —Noy waɗi de ƴibbi ki yoordi wakkati gooto ni? ");
INSERT INTO fuhbkf_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Iisaa jaabii ɓe, wi'i: —Goonga kaalanammi on: si oɗon ngoonɗini on cikkitiraay fu, on ngaɗan ko ɓuri ko ngaɗumi ƴibbi ki ɗuum. On mbaawan wi'ude fay waamnde nde: «Ɗoofa, saamoy ley maayo», de laatoroo noon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Si oɗon ngoonɗini, ko ŋaariɗon e ley du'aare fuu on keɓan ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Iisaa naati suudu dewal mawndu nduun. Nde o waajotonoo ndeen, hooreeɓe almaami'en e mawɓe Alhuudiyankooɓe ɓeen ɓattii mo, ƴami, mbi'i: —Laamu nguye hokki ma baawɗe gollude ko ngollataa ɗum? Moy hokki ma laawol ngollaa ɗum? ");
INSERT INTO fuhbkf_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Iisaa jaabii ɓe, wi'i: —Miin du, huunde wootere tan ƴamammi on. Si on njaabake kam, mi haalanan on kokkuɗo kam laawol mi golla ko ngollammi ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Toy lootagal batisima Yaayaa ngaal ƴuuri? To Laamɗo naa to yimɓe? Ndeen heddii iɓe ndawrida hakkunde maɓɓe, iɓe mbi'a: —Si en mbi'ii to Laamɗo fu, o ƴaman en ko waɗi de en ngoonɗinaay Yaayaa? ");
INSERT INTO fuhbkf_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ammaa si en mbi'ii to yimɓe, kulen ko jamaa o waɗata en, sabo yimɓe ɓeen fuu ina njogorii Yaayaa wo annabaajo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ɓe njaabii Iisaa, ɓe mbi'i: —Min anndaa. Iisaa du jaabii ɓe, wi'i: —Haya miin du, mi haalantaa on baawɗe ɗeye ngollirammi ko ngollammi ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Iisaa ɓeydi wi'i: —Ɗume miilotoɗon e banndol ngol: gorko gomma ina joginoo ɓiɓɓe worɓe ɗiɗo. O ɓattitii arandeejo oon, o wi'i ɗum: «Ɓinngel am, yahu golloy hannden to ngesa cabiije toon.» ");
INSERT INTO fuhbkf_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ɓiɗɗo oon jaabii, wi'i yahataa. Ammaa caggal ɗuum, mimsiti yehi. ");
INSERT INTO fuhbkf_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Baabiiwo oon ɓattitii ɗiɗaɓo oon, wi'i ɗum ko wi'unoo arandeejo oon ɗuum. Oon kaa jaabii, wi'i: «Wooɗi Baaba», ammaa yahaay. ");
INSERT INTO fuhbkf_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Moy e maɓɓe waɗi ko bammum muuyi ɗuum? Ɓe njaabii, ɓe mbi'i: —Arandeejo oon. Ndeen, Iisaa wi'i ɓe: —Goonga kaalanammi on: nanngooɓe lampo e rewɓe woykuruuɓe ɓeen artoyto on naatude e laamu Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Sabo Yaayaa warii to mooɗon, hollii on laawol fonnditaare, de on ngoonɗinaay ɗum. Ammaa nanngooɓe lampo e rewɓe woykuruuɓe ɓeen ngoonɗinii mo. Fay nde njiinoɗon ɗum ndeen, on mimsitaay ngoonɗinɗon ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","—Kettindee banndol gonngol: neɗɗo gomma darni ngesa cabiije, fiiltini nga hoggo, wasi luggere ɓoosirde cabijam. O nyiɓi suudu toowndu faa o haynoo ko warata e ngesa ngaan. Caggal ɗuum, o halfini nga remooɓe, de o waɗi jahaangal. ");
INSERT INTO fuhbkf_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Faa ɓoreede cabiije yottii, de o neli gollooɓe makko to remooɓe ɓeen toon, ɓe ngaddanowa mo ngeɗu makko e ɓiɓɓe cabiije ɗeen. ");
INSERT INTO fuhbkf_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ammaa remooɓe ɓeen nanngi gollooɓe makko ɓeen, piyi gooto, mbari gooto, limni gooto kaaƴe. ");
INSERT INTO fuhbkf_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Jom ngesa oon neli e maɓɓe gollooɓe ɓurɓe arandeeɓe ɓeen heewude. Remooɓe ɓeen ngaɗi ɓe no ngaɗunoo arandeeɓe ɓeen noon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","De sakitii o neli ɓiyiiko gorko to maɓɓe, o wi'i: «Ɓe njaagoto ɓiyam oon.» ");
INSERT INTO fuhbkf_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ammaa nde remooɓe ɓeen nji'unoo ɓiyiiko oon ndeen, mbi'unduri hakkunde muɓɓen «O woni donoowo hoggo ngo. Ngaree mbaren mo, keddoroɗen ngesa nga!» ");
INSERT INTO fuhbkf_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Wakkati oon, ɓe nanngi mo, ɓe paɗɗi mo to gaɗa ngesa toon, ɓe mbari mo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Joonin le, si jom ngesa cabiije oon warii, noy o waɗata remooɓe ɓeen? ");
INSERT INTO fuhbkf_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ɓe njaabii mo, ɓe mbi'i: —O halkiran bonɓe ɓeen no boniri. O halfinan ngesa ngaan remooɓe woɓɓe hokkooɓe mo ngeɗu makko e ɓiɓɓe magga wakkati nga ɓoraa. ");
INSERT INTO fuhbkf_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Caggal ɗuum, Iisaa wi'i ɓe: —Yalla on njanngaay ko winndaa ley Binndi ɗiin ɗuum naa? «Hayre nde nyiɓooɓe ɓeen calii ndeen, wo kayre laatii hoore nyimngo ngoon. Ɗum wo golle Joomiraaɗo, wo ɗum haaynde e jiiɗe meeɗen!» ");
INSERT INTO fuhbkf_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Saabe ɗum, miɗo wi'a on: laamu Laamɗo ittete e mooɗon, hokkee yimɓe waɗooɓe ko haani e maggu. ");
INSERT INTO fuhbkf_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Caamuɗo dow hayre ndeen fuu, helan. Mo nde saami dow muuɗum du, ɗiggan. ");
INSERT INTO fuhbkf_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Nde hooreeɓe almaami'en e Farisa'en ɓeen nannoo banndi makko ɗiin, paamii wo kabaaru muɓɓen o banndi. ");
INSERT INTO fuhbkf_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Iɓe piloo no ɓe nanngira mo, ammaa ɓe kulii yimɓe, sabo yimɓe ɓeen ina njogorii mo annabaajo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Iisaa banndani ɓe katin, wi'i ɓe: ");
INSERT INTO fuhbkf_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Inan no laamu Laamɗo nanndi: wo hono kaananke ɓaŋnoowo ɓiyum gorko, waɗani ɗum neema ɓangal. ");
INSERT INTO fuhbkf_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","O neli maccuɓe makko noddowa yimɓe ɓangal ngaal, ammaa noddaaɓe ɓeen calii warude. ");
INSERT INTO fuhbkf_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","O neli katin maccuɓe woɓɓe, o wi'i ɗum'en: «Mbi'ee noddaaɓe ɓeen nyaamdu nduun moƴƴinaama faa wooɗi. Mi hirsii ga'i e nyalbi payɗi. Fuu segilaama. Ɓe ngara, ɓe nootoo weltaare ɓangal nde.» ");
INSERT INTO fuhbkf_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ammaa noddaaɓe ɓeen kiisaaki mo, naati haajuuji muɓɓen: o yehi ndaaroyde ngesa muuɗum, o du luumooji muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Heddiiɓe ɓeen nanngi maccuɓe ɓeen, torri ɓe, mbari ɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Kaananke oon tikki, neli sordaasiiɓe muuɗum mbarowi waruɓe nulaaɓe ɓeen, mbuli wuro muɓɓen. ");
INSERT INTO fuhbkf_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Caggal ɗuum, o wi'i maccuɓe makko ɓeen: «Nyaamdu ɓangal nduun moƴƴinaama, ammaa noddaaɓe ɓeen kaandaa e nyaamude ndu. ");
INSERT INTO fuhbkf_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ɗum le, njehee dow laabi mawɗi ɗiin, noddon neɗɗo fuu mo kawruɗon wara nyaama nyaamdu ɓangal ndu.» ");
INSERT INTO fuhbkf_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Maccuɓe ɓeen njehi dow laabi ɗiin, noddi yimɓe ɓe kawri toon fuu gilla e bonɓe faa e moƴƴuɓe faa galle jom ɓangal oon heewi yimɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Nde kaananke oon naatunoo faa ndaara noddaaɓe ɓeen ndeen, o haynii gorko mo ɓornaaki kaddule ɓangal ngaal. ");
INSERT INTO fuhbkf_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","O wi'i ɗum: «Neɗɗo am, noy naatirɗaa ɗo tawi a ɓornaaki kaddule ɓangal?» De oon deƴƴinii. ");
INSERT INTO fuhbkf_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ndeen, kaananke oon wi'i gollooɓe ɓeen: «Kaɓɓee juuɗe makko e koyɗe makko, paɗɗon mo e ley nimre yaasin ndeen. Toon bojji e ŋerƴundurde nyiiƴe ngoni.» ");
INSERT INTO fuhbkf_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Iisaa heddii na wi'a: —Noddaaɓe ina keewi ammaa suɓaaɓe ina pamɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Farisa'en njehi ndawridowi no nanngira Iisaa e ley haala muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ɓe neli yoga e taalibaaɓe maɓɓe e jokkuɓe Hirudus to Iisaa. Nulaaɓe ɓeen mbi'i mo: —Moodibbo, miɗen anndi a goongante: aɗa jannginira laawol Laamɗo ngol goonga. A hulataa fay gooto, sabo a ɓurdintaa yimɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ndelle, haalan min ɗume miiliɗaa: yalla ina dagii min kokka kaananke Roma mawɗo oon lampo naa dagaaki? ");
INSERT INTO fuhbkf_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ammaa Iisaa ina anndi anniyaaji maɓɓe bonɗi ɗiin. O wi'i ɓe: —Onon munaafiki'en! Ɗume waɗi de oɗon tuufina kam? ");
INSERT INTO fuhbkf_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Kollee kam mbuuɗu njoɓeteengu lampo. Ɓe ngaddani mo mbuuɗu cardi ngootu. ");
INSERT INTO fuhbkf_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","O ƴami ɓe, o wi'i: —Natal moy e innde moy woni ɗo? ");
INSERT INTO fuhbkf_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ɓe njaabii mo, ɓe mbi'i: —Kaananke Roma. O wi'i ɓe: —Ndelle, kokkee kaananke Roma oon ko jeyi, kokkon Laamɗo du ko jeyi. ");
INSERT INTO fuhbkf_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Nde ɓe nannoo jaabu oon fu, ɗum haaynii ɓe. Ɓe celi mo, ɓe ndilli. ");
INSERT INTO fuhbkf_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","E ley nyalooma oon, woɓɓe ley waalde Saduki'en ngari to Iisaa. Kam'en ngoni yeddooɓe ummital. ");
INSERT INTO fuhbkf_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Ɓe ƴami mo, ɓe mbi'i: —Moodibbo, Muusaa wi'i: «Si neɗɗo maayii heɓaay ɓiɗɗo, minyum naa mawnum dewla debbo joppaaɗo oon, faa heɓana ɗum ɓeyngu.» ");
INSERT INTO fuhbkf_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ina woodunoo hakkunde amin sakiraaɓe worɓe njeɗɗo. Arandeejo oon dewli, maayi heɓaay ɓiɗɗo. Minyiiko hooƴi debbo oon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Kam du maayi heɓaay ɓiɗɗo. Tataɓo oon du jokki, faa ɓe njeɗɗo fuu ɓe maayi. ");
INSERT INTO fuhbkf_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Caggal maɓɓe ɓe fuu, debbo oon du maayi. ");
INSERT INTO fuhbkf_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ndelle nyannde ummital, moy e njeɗɗo ɓeen laatotoo goroo debbo oon? Sabo ɓe fuu ɓe ndewliino mo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Iisaa jaabii ɓe, wi'i: —On woofuɓe, sabo on anndaa Binndi ɗiin, on anndaa baawɗe Laamɗo du. ");
INSERT INTO fuhbkf_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Sabo si maayɓe ummitake, worɓe ɓaŋataa, rewɓe ɓaŋataake. Ɓe laatoto hono maleyka'en wonɓe dow kammu ni. ");
INSERT INTO fuhbkf_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Wooɗi, e haala ummital maayɓe, yalla on njanngaay ko Laamɗo wi'i on ɗuum naa? O wi'i: ");
INSERT INTO fuhbkf_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","«Miin woni Laamɗo Ibrahiima, Laamɗo Isiyaaka, Laamɗo Yaakuuba.» Laamɗo wo Laamɗo wuurɓe, wanaa Laamɗo maayɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Nde jamaa keewɗo oon nannoo waaju makko oon fu, ɗum haaynii ɗum'en sanne. ");
INSERT INTO fuhbkf_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Nde Farisa'en ɓeen nannoo Iisaa deƴƴinirii Saduki'en ɓeen e haala fu, ɓe kawriti. ");
INSERT INTO fuhbkf_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Gooto maɓɓe jannginoowo Tawreeta na yiɗi tuufinde mo, ƴami mo, wi'i: ");
INSERT INTO fuhbkf_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Moodibbo, ndeye woni yamiroore ɓurnde fuu manngu e ley Tawreeta? ");
INSERT INTO fuhbkf_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Iisaa jaabii mo, wi'i: —Yiɗir Laamɗo Joomiraaɗo maa e ɓernde maa fuu e yonki maa fuu e hakkillo maa fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Nde woni yamiroore arandeere, ɓurnde fuu manngu. ");
INSERT INTO fuhbkf_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Inan yamiroore ɗiɗaɓerde hono mayre: «Njiɗiraa gondo maa no njiɗirɗaa hoore maa ni.» ");
INSERT INTO fuhbkf_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Tawreeta Muusaa e dewte annabaaɓe ɗeen fuu e jamirooje ɗiɗi ɗeen njowii. ");
INSERT INTO fuhbkf_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ko Farisa'en ɓeen kawriti toon ɗuum, Iisaa ƴami ɓe, wi'i: ");
INSERT INTO fuhbkf_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—Ɗume miiluɗon e Almasiihu oon? Wo o taan moy? Ɓe njaabii, ɓe mbi'i: —O taan Daawda. ");
INSERT INTO fuhbkf_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","O wi'i ɓe: —Ko Daawda haaliri baawɗe Ruuhu ɗuum, noy noddiri Almasiihu «Joomiraaɗo»? Sabo o wi'ii: ");
INSERT INTO fuhbkf_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","«Joomiraaɗo wi'i Joomam: Jooɗa gere nyaamo am, faa mi waɗa njaaɓaa wayɓe ma.» ");
INSERT INTO fuhbkf_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Wooɗi, Daawda ina noddira mo «Joomam». Ndelle noy o laatortoo taanum? ");
INSERT INTO fuhbkf_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ɓe fuu ɓe kunngii jaabaade mo faa'e. Caggal nyannde ndeen, fay gooto suusaay ƴamude mo ƴamɗe goɗɗe katin. ");
INSERT INTO fuhbkf_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ndeen, Iisaa haalani jama'aaje ɗeen e taalibaaɓe muuɗum ɓeen, wi'i: ");
INSERT INTO fuhbkf_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Jannginooɓe Tawreeta e Farisa'en ɓeen kalfinaama njanngina Tawreeta Muusaa. ");
INSERT INTO fuhbkf_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Saabe ɗuum, oɗon kaani jaɓande ɓe, ngaɗon huunde fuu ko ɓe mbi'i on. Ammaa taa nyemmbiton golle maɓɓe, sabo ɓe ngaɗataa ko ɓe mbaajotoo ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ɓe kaɓɓan doŋle tedduɗe, ɓe mbakkina yimɓe, ammaa ɓe njiɗaa meemirde ɗe fay e hoore honndu faa ɓe mballa ɗum'en. ");
INSERT INTO fuhbkf_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Huunde fuu ko ɓe ngaɗata, ɓe ngaɗiran ɗum faa ɓe nji'ee. Ɗum waɗi de iɓe kaɓɓa talki mawɗi, iɓe njuutina bukki saayaaji maɓɓe faa ina ndaasoo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Iɓe njiɗi jooɗorɗe ɓurɗe teddude si ɓe noddaama e nokkuuje nyaamdu tedduɗe. Iɓe njiɗi jooɗorɗe ɓurɗe teddude ley cuuɗi baajorɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Iɓe njiɗi jowteede jowtaali tedduɗi ley luumooji e noddireede «Moodibbo». ");
INSERT INTO fuhbkf_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ammaa onon kaa, taa njaɓee noddireede «Moodibbo», sabo Moodibbo gooto tan njogiɗon. Onon, on fuu wo on sakiraaɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Taa mbi'ee fay gooto «Baabiiwo» e adunaaru. Sabo Baabiiwo gooto tan njogiɗon, gonɗo dow kammu oon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Taa njaɓee noddireede «Hooreejo». Sabo Hooreejo gooto tan njogiɗon, oon woni Almasiihu. ");
INSERT INTO fuhbkf_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ɓurɗo teddude hakkunde mooɗon laatoo golloowo mooɗon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Toownuɗo hoore muuɗum fuu, leeƴinte. Leeƴinɗo hoore muuɗum fuu, toownete. ");
INSERT INTO fuhbkf_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Bone woodanii on onon jannginooɓe Tawreeta e Farisa'en, munaafiki'en! Oɗon cokana yimɓe dammbugal laamu Laamɗo ngaal. On naatataa, on accataa naatooɓe naata.  ");
INSERT INTO fuhbkf_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Bone woodanii on, onon jannginooɓe Tawreeta e Farisa'en, munaafiki'en! Oɗon njiiloo e leyɗe, oɗon peƴƴita maayooji faa keɓon tuubuɗo gooto. Si on keɓii ɗum fu, oɗon ngaɗa ɗum ɓii jahannama faa bura on bonde kile ɗiɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Bone woodanii on, onon wumɓe ɗowooɓe yimɓe! Oɗon mbi'a: «Si neɗɗo hunorake suudu dewal mawndu nduun fu wo ɓolum, ammaa si hunorake kaŋŋe suudu dewal mawndu oon, hunayeere mum nanngan ɗum.» ");
INSERT INTO fuhbkf_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Majjuɓe, wumɓe! Ɗume ɓuri teddude: kaŋŋe oon naa suudu laaɓinooru kaŋŋe oon nduun? ");
INSERT INTO fuhbkf_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Oɗon mbi'a katin: «Si neɗɗo hunorake hirsirde ndeen fu wo ɓolum, ammaa si hunorake sadaka gonɗo dow mayre oon, hunayeere mum nanngan ɗum.» ");
INSERT INTO fuhbkf_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Wumɓe! Ɗume ɓuri teddude: sadaka oon naa hirsirde laaɓinoore sadaka oon ndeen? ");
INSERT INTO fuhbkf_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ndelle, neɗɗo fuu kunoriiɗo hirsirde ndeen, hunorake nde, kayre e huunde fuu ko yowii e mayre. ");
INSERT INTO fuhbkf_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Neɗɗo fuu kunoriiɗo suudu dewal mawndu nduun, hunorake ndu, kayru e Laamɗo gonɗo ley mayru oon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Neɗɗo fuu kunoriiɗo kammu, hunorake jooɗorgal Laamɗo ngaal e Jooɗiiɗo e maggal oon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Bone woodanii on, onon jannginooɓe Tawreeta e Farisa'en, munaafiki'en! Oɗon ittana Laamɗo jakka fay naanaa e haakorooji mooɗon goɗɗi, ammaa oɗon njeeboo ko ɓuri fuu teddude e Jamirooje ɗeen. Ɗum woni gollirde dartaare e yurmeende e goonɗinal. Wo kanjum kaannoɗon waɗude tawee on njoppaay ko heddii ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Onon wumɓe ɗowooɓe yimɓe! Si mbuubu saamii e njaram mooɗon, on ciiwan itton ɗum, de oɗon moɗa ngeelooba! ");
INSERT INTO fuhbkf_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Bone woodanii on, onon jannginooɓe Tawreeta e Farisa'en, munaafiki'en! Oɗon lawƴa caggal kore e caggal kaake, de ley majje ina heewi ko hemraa nguyka e muuyo bonngo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Farisanke bumɗo! Lawƴu ley kore tafon, ndeen caggal toon du laaɓan. ");
INSERT INTO fuhbkf_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Bone woodanii on, onon jannginooɓe Tawreeta e Farisa'en, munaafiki'en! Oɗon nanndi e caabeeje dawninaaɗe, ɗe dow muɓɓen wooɗi, tawee ley muɓɓen ina heewi ƴi'e maayɓe e ko tuuni fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Onon du, wo hono noon nannduɗon: e jiiɗe gite oɗon nanndi e fonnditiiɓe, ammaa ley mooɗon ina wi'i pet naafikaaku e oonyaare. ");
INSERT INTO fuhbkf_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Bone woodanii on, onon jannginooɓe Tawreeta e Farisa'en, munaafiki'en! Oɗon moƴƴintinoo caabeeje annabaaɓe, oɗon ŋarɗina caabeeje fonnditiiɓe woɓɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Oɗon mbi'a: «Sini min kawriino e jamaanu maamiraaɓe amin, min ndufidataano e maɓɓe ƴiiƴam annabaaɓe.» ");
INSERT INTO fuhbkf_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ndelle, oɗon ceedanoo ko'e mooɗon wo on ɓiɓɓe warannooɓe annabaaɓe ɓeen. ");
INSERT INTO fuhbkf_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ndelle, njottinee ko maamiraaɓe mooɗon puɗɗunoo! ");
INSERT INTO fuhbkf_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Onon bolle, ɓiɓɓe poosoke! Walaa fuu no ndaɗiron halkere jahannama. ");
INSERT INTO fuhbkf_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ɗum waɗi de miɗo nulda on annabaaɓe e jom'en hakkillo e jannginooɓe. On mbaran woɓɓe maɓɓe, tonton woɓɓe maɓɓe, piyon woɓɓe maɓɓe dorri e ley cuuɗi mon baajorɗi, ndiiwon ɗum'en hakkunde wuro e wuro. ");
INSERT INTO fuhbkf_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Njomnitaari ƴiiƴam fonnditiiɓe ndufaaɗam e adunaaru ndu ɗaam fuu yeccoto dow mooɗon, gilla yonki Haabiila ponnditiiɗo oon faa yonki Jakariyaa ɓii Barakiya mo mbarnoɗon hakkunde suudu dewal mawndu e hirsirde oon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Goonga kaalanammi on: jukkungo majjum fuu saaman dow yimɓe jamaanu o! ");
INSERT INTO fuhbkf_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","—Kay Urusaliima, Urusaliima! Aɗa wara annabaaɓe, aɗa warda nulaaɓe to maa kaaƴe! Kile keewɗe njiɗumi hawrundurde ɓiɓɓe maa hono no cofal hawrundurta coppi muuɗum ley bippeele mum ni. De on njaɓaay. ");
INSERT INTO fuhbkf_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Paamon, Laamɗo yoppidii on e suudu mon, wo ndu winnde. ");
INSERT INTO fuhbkf_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Miɗo wi'a on: gilla joonin, on nji'ataa kam katin si wanaa faa wakkati mo mbi'oyton: «Barke woodanii garɗo e dow innde Joomiraaɗo!» ");
INSERT INTO fuhbkf_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Nde Iisaa yaltunoo suudu dewal mawndu ina yaha ndeen, taalibaaɓe muuɗum ɓattitii ɗum, kolli ɗum nyimngo ley galle mayru. ");
INSERT INTO fuhbkf_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","O wi'i ɓe: —On nji'ii kujje ɗe fuu naa? Goonga kaalanammi on: fay hayre wootere heddataako ina yowii dow wonnde. Fuu wurjinte. ");
INSERT INTO fuhbkf_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Caggal ɗuum, Iisaa jooɗowii dow waamnde wi'eteende Jaytun. Taalibaaɓe muuɗum ngari to muuɗum kam'en tan, mbi'i ɗum: —Humpitin min nde ɗum waɗata. Maande ndeye hollata gartol maa, kam e timmoode adunaaru? ");
INSERT INTO fuhbkf_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Iisaa jaabii ɓe, wi'i: —Ndeentee taa fay gooto wosina on e goonga. ");
INSERT INTO fuhbkf_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Sabo heewɓe ngardan e innde am, ina mbiitoo: «Miin woni Almasiihu oon.» Ɓe mbosinan yimɓe heewɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","On nanan kabaaru bolwole gaɗaaɗe e anniyaaɗe, ammaa taa kulee! Ina tilsi ɗum waɗa, de ɗum wanaa timmoode tafon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Lenyol habdan e lenyol, laamu habdan e laamu. Rafooji ngaɗan, leydi dimmboto e nokkuuje feere feere. ");
INSERT INTO fuhbkf_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ɗum kaa fuu wo hono fuɗɗoode ŋatawere ɓeynoowo ni. ");
INSERT INTO fuhbkf_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Ndeen, yimɓe njaaran on careɗon faa torreɗon, mbareɗon. Lenyi ɗiin fuu mbanyan on saabe am. ");
INSERT INTO fuhbkf_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Wakkati oon, heewɓe pergoto njoppa goonɗinal muɓɓen, ina njambundura, ina mbanyunduri. ");
INSERT INTO fuhbkf_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Annabaaɓe fewreeɓe heewɓe ɓangan, kiila heewɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Bonandaaji keewan faa njinngu yimɓe heewɓe ɓuytoo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ammaa tinnitiiɗo faa yottii timmoode fu, kam hisintee. ");
INSERT INTO fuhbkf_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Kabaaru Lobbo haala laamu Laamɗo o gooynete e adunaaru ndu fuu, faa lenyi fuu keɓa seedaaku nguun. Ndeen adunaaru timmata. ");
INSERT INTO fuhbkf_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","—On nji'an «huunde nyiddiniinde bonnoore» nde annabi Daniyiila haalnoo kabaaru muuɗum. Huunde ndeen darnete dow nokkuure seniinde ndeen. (Jannguɗo ɗum fuu, faama maanaa majjum.) ");
INSERT INTO fuhbkf_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ndeen, tawaaɓe ley Yahuudiya fuu ndoggira baamle. ");
INSERT INTO fuhbkf_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Tawaaɗo dow suudu, taa wi'a jippoto hooƴa gineeji ley suudu muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Tawaaɗo ngesa, taa yeccoo faa hooƴowa saaya muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Kay, debereedu'en e musinteeɓe njaran torra ley balɗe ɗeen! ");
INSERT INTO fuhbkf_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ŋaaree Laamɗo taa doggudu mooɗon laatoo wakkati dabbunde naa nyalaande fowteteende. ");
INSERT INTO fuhbkf_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Sabo ndeen, torra mawɗo waɗan mo hono muuɗum waɗaay gilla fuɗɗoode adunaaru faa joonin, wooɗi du hono muuɗum waɗataa abada katin. ");
INSERT INTO fuhbkf_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Sini tawiino balɗe ɗeen ndaɓɓinɗinaaka, fay gooto hisataano. Ammaa Laamɗo raɓɓinɗinii ɗe saabe suɓaaɓe muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Wakkati oon, si goɗɗo wi'ii on: «Ndaaree! Inan Almasiihu ɗo», naa «Inani mo to», taa ngoonɗinee. ");
INSERT INTO fuhbkf_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Sabo almasiihu'en fewreeɓe e annabaaɓe fewreeɓe ɓangowan, ngaɗa maandeeji mawɗi e kaayeefiiji faa majjina fay suɓaaɓe ɓeen, si na laatoo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Paamee wooɗa. Mi haalanii on gilla ɗum waraay. ");
INSERT INTO fuhbkf_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Si yimɓe mbi'ii on: «Inani mo ley ladde», taa njehee. Naa si ɓe mbi'ii: «Inani mo ley cuuɗi toon», taa ngoonɗinee. ");
INSERT INTO fuhbkf_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Si goonga, no maƴƴere yaynirta e kammu gilla lettugal faa gorgal ni, hono noon Ɓii Neɗɗo wardata. ");
INSERT INTO fuhbkf_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","To ko saaɗi woni fuu, toon jigaaje kawritata. ");
INSERT INTO fuhbkf_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","—Wakkati gooto, caggal torra balɗe ɗeen, naange niɓɓan, lewru selan yaynude, koode kammu caaman, kulle gonɗe dow kammu ɗeen ndimmboto. ");
INSERT INTO fuhbkf_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Wakkati oon, maande Ɓii Neɗɗo oon ɓangan dow kammu, lenyi adunaaru ɗiin fuu mboyan mettorgal. Ɓe nji'an Ɓii Neɗɗo oon, ina wara e duule, ina warda e baawɗe e teddeengal manngal. ");
INSERT INTO fuhbkf_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Buututal manngal fuufete, de o nula maleyka'en makko lettugal e gorgal, horɗoore e soɓɓiire, kawrundura suɓaaɓe makko ɓeen gilla to adunaaru fuɗɗi faa to haaɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Ekitee ko ƴibbi hollata: si licce makki keyɗitii, haakorooji makki du mbilitii fu, oɗon anndi ndunngu ɓadake. ");
INSERT INTO fuhbkf_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Noon du, si on nji'ii kulle ɗeen fuu, annditon wakkati oon ɓadake, imo woni e dammbugal galle. ");
INSERT INTO fuhbkf_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Goonga kaalanammi on: jamaanu o timmataa tawee kulle ɗeen fuu ngaɗaay. ");
INSERT INTO fuhbkf_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Kammu e leydi timman, de haalaaji am kaa timmataa abada. ");
INSERT INTO fuhbkf_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","—Ammaa nyalaande ndeen e wakkati oon fay gooto anndaa ɗum, wanaa maleyka'en wonɓe dow kammuuli, wanaa Ɓiɗɗo oon. Walaa annduɗo ɗum si wanaa Baabiiwo oon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Hono no laatorinoo wakkati Nuuhu, noon du laatortoo si Ɓii Neɗɗo warii. ");
INSERT INTO fuhbkf_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","E ley nyalaaɗe ɗeen fadde ilam tuufaandu ɗaam warude, yimɓe ina nyaama, ina njara, ina ɓaŋa, ina ɓaŋee, faa nyannde Nuuhu naati laana kaan. ");
INSERT INTO fuhbkf_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ɓe paamaay faa'e faa ilam tuufaandu ɗaam wari, yooli ɓe fuu. Garol Ɓii Neɗɗo du, hono noon laatortoo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Wakkati oon, worɓe ɗiɗo tawdete ley ngesa. Gooto muɓɓen hooƴete, gooto du yoppee. ");
INSERT INTO fuhbkf_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Rewɓe ɗiɗo undooɓe tawete dow unirde. Gooto muɓɓen hooƴete, gooto du yoppee. ");
INSERT INTO fuhbkf_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ndelle, kakkilon, sabo on anndaa wakkati mo Joomiraaɗo mon warata. ");
INSERT INTO fuhbkf_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Paamee ɗum ɗo: si jom galle ina anndunoo wakkati mo gujjo warata ley jemma, waalan hakkilde, yoppataano o naata suudu muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ndelle, onon du cegilee, sabo Ɓii Neɗɗo waran e wakkati mo on miilaaki. ");
INSERT INTO fuhbkf_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","—Ndelle, moy woni golloowo koolniiɗo, jom hakkillo? Oon woni mo joomum halfini gollooɓe muuɗum faa hokka ɗum'en nyaamdu muɓɓen e wakkati kaanɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Barke woodanii golloowo mo joomum warti, tawi ina waɗa no yamiraa noon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Goonga kaalanammi on: joomiiko oon halfinan mo jawdi muuɗum fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ammaa si golloowo oon wo bonɗo, wi'ii ley ɓernde mum joomum ɓooyan wartaay, ");
INSERT INTO fuhbkf_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","de fuɗɗi ina fiya banndiraaɓe muuɗum gollooɓe, ina nyaamda ina yarda e sulotooɓe, ");
INSERT INTO fuhbkf_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ndeen kaa, joomiiko wartan nyalooma mo o anndaa e wakkati mo o miilaaki. ");
INSERT INTO fuhbkf_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Joomiiko oon jukkoto mo jukkungo naawngo, watta mo hakkunde munaafiki'en. Toon bojji e ŋerƴundurde nyiiƴe ngoni. ");
INSERT INTO fuhbkf_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","—Inan no laamu Laamɗo nanndi: wo hono surbaaɓe sappo hooƴuɓe fitillaaji muɓɓen de njehi faa njaɓɓowoo ɓaŋuɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Njoyo maɓɓe ngalaa hakkillo, njoyo maɓɓe du ina ngoodi hakkillo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ɓe ngalaa hakkillo ɓeen kooƴi fitillaaji tawi njooɓaaki nebbam. ");
INSERT INTO fuhbkf_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Jom'en hakkillo ɓeen kaa njaadi paali nebbam e fitillaaji muɓɓen. ");
INSERT INTO fuhbkf_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Nde ɓaŋuɗo oon jenngunoo waraay ndeen, ɓe fuu ɓe ŋoŋi, ɓe ɗaanii. ");
INSERT INTO fuhbkf_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Faa hakkunde jemma, ƴeewnaango nanaa, wi'i: «Inan ɓaŋuɗo oon! Njaltee! Njaɓɓowee mo!» ");
INSERT INTO fuhbkf_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ndeen surbaaɓe ɓeen fuu pini, ina moƴƴina fitillaaji muɓɓen. ");
INSERT INTO fuhbkf_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Surbaaɓe ɓe ngalaa hakkillo ɓeen mbi'i jom'en hakkillo ɓeen: «Njeɗee min nebbam mooɗon ɗaam, sabo inan fitillaaji amin ina nyifa.» ");
INSERT INTO fuhbkf_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Jom'en hakkillo ɓeen njaabii, mbi'i: «Gasataa, sabo ko min njogii ɗuum heƴataa en, en fuu. Njehee to sonnooɓe, coodowon!» ");
INSERT INTO fuhbkf_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ko ɓe njehi faa ɓe coodowa nebbam ɗuum, ɓaŋuɗo oon yottii. Segilinooɓe ɓeen naatidi e makko e ley suudu weltaare nduun, de dammbugal ngaal ommbaa. ");
INSERT INTO fuhbkf_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Faa ɓooyi seeɗa, surbaaɓe heddiiɓe ɓe cegilaaki ɓeen ngarti, keddii ina nodda, ina mbi'a: «Joomii amin, joomii amin, omtan min!» ");
INSERT INTO fuhbkf_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ammaa o jaabii ɓe, o wi'i: «Goonga kaalanammi on: mi anndaa on.» ");
INSERT INTO fuhbkf_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Iisaa sakitii wi'i: —Kakkilon ndelle, sabo on anndaa nyalaande naa wakkati mo Ɓii Neɗɗo wartata oon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","—Laamu Laamɗo ina nanndi e gorko cegiliiɗo faa dilla, noddi maccuɓe mum, de halfini ɗum'en jawdi mum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","O halfini gooto maɓɓe mutakal kaŋŋe keme joy, goɗɗo keme ɗiɗi, tataɓo oon hemre, mono fuu ko fotata e muuɗum. Caggal ɗuum, o dilli. Wakkati oon ni, ");
INSERT INTO fuhbkf_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","kalfinaaɗo mutakal kaŋŋe keme joy oon yehi luumorii ɗum, heɓi mutakal keme joy goɗɗe. ");
INSERT INTO fuhbkf_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Jom keme ɗiɗi oon du waɗi noon, tinii kam du mutakal keme ɗiɗi goɗɗe. ");
INSERT INTO fuhbkf_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ammaa jom mutakal hemre oon yehi wasowi ngayka, uwi toon ko joomum oon hokkunoo ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Faa ɓooyi caggal majjum, joomii ɓe oon warti, noddi ɓe, faa ndaara hiisa ceede ɗeen. ");
INSERT INTO fuhbkf_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Kalfinaaɗo mutakal kaŋŋe keme joy oon wari, waddi mutakal keme joy goɗɗe, wi'i: «Joomam, a halfinii kam mutakal keme joy. Ndaar, mi tinorake ɗe mutakal keme joy goɗɗe.» ");
INSERT INTO fuhbkf_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Joomiiko oon wi'i mo: «Gasii. Wo a maccuɗo lobbo, koolniiɗo. Saabe a hoolnake e ko famɗi, mi halfinte ko heewi. War naatu faa ceyodoɗen!» ");
INSERT INTO fuhbkf_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Kalfinaaɗo mutakal keme ɗiɗi oon wari kam du, wi'i: «Joomam, a halfinii kam mutakal kaŋŋe keme ɗiɗi. Ndaar, mi tinorake ɗe mutakal keme ɗiɗi goɗɗe.» ");
INSERT INTO fuhbkf_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Joomiiko oon wi'i mo: «Gasii. Wo a maccuɗo lobbo, koolniiɗo. Saabe a hoolnake e ko famɗi, mi halfinte ko heewi. War naatu faa ceyodoɗen!» ");
INSERT INTO fuhbkf_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Kalfinaaɗo mutakal kaŋŋe hemre oon wari kam du, wi'i: «Joomam, miɗo anndunoo a gorko tiiɗuɗo alhaali: aɗa taƴa ko a aawaay, aɗa hawrundura to a sarkaay aawdi. ");
INSERT INTO fuhbkf_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Saabe ɗum, kulumi, njahumi iroymi kaŋŋe maa oon. Haya, inan giney maa.» ");
INSERT INTO fuhbkf_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Joomiiko jaabii mo, wi'i: «Maccuɗo bonɗo, jaayɗo! Aɗa anndunoo miɗo taƴa ko mi aawaay, miɗo hawrundura to mi saakaay aawdi. ");
INSERT INTO fuhbkf_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ndelle, aɗa haannoo wattude kaŋŋe am oon to tinooɓe buuɗi, faa danya ko tinoriimi si mi wartii. ");
INSERT INTO fuhbkf_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Joonin, teetee mo mutakal hemre kaŋŋe oon, kokkon ɗum jom mutakal kaŋŋe keme joy oon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Sabo jogiiɗo fuu ɓeydante faa heewa. Ammaa mo walaa oon, fay seeɗa ko jogii ɗuum teetete. ");
INSERT INTO fuhbkf_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Maccuɗo jaayɗo oon kaa, paɗɗee ɗum yaasin e ley nimre ndeen. Toon bojji e ŋerƴundurde nyiiƴe ngoni.» ");
INSERT INTO fuhbkf_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","—Nde Ɓii Neɗɗo wardi e teddeengal muuɗum, kam e maleyka'en fuu, jooɗoto e jooɗorgal laamu muuɗum teddungal ngaal. ");
INSERT INTO fuhbkf_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Yimɓe adunaaru ɓeen fuu kawrundurte yeeso makko, o sennda ɓe hono no duroowo senndirta baali e be'i ni: ");
INSERT INTO fuhbkf_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","o heedina baali ɗiin e junngo makko nyaamo, o heedina be'i ɗiin e junngo makko nano. ");
INSERT INTO fuhbkf_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ndeen Kaananke oon wi'ata wonɓe junngo mum nyaamo ɓeen: «Ngaree, onon ɓe Baaba am barkini, njaɓee laamu mo ndesanaɗon gilla e fuɗɗoode adunaaru ndu. ");
INSERT INTO fuhbkf_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Sabo mi yolbiino, de on nyaamnii kam. Mi ɗomɗiino, de on njarnii kam. Mi laatakeno beero, de on njaɓɓake kam. ");
INSERT INTO fuhbkf_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Mi holiino, de on koltinii kam. Mi nyawiino, de on cawrii kam. Mi uddanooma ley kasu, de on ndaarowii kam.» ");
INSERT INTO fuhbkf_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","E wakkati oon, fonnditiiɓe ɓeen njaabotoo mo, mbi'a: «Joomiraaɗo, ndey min nji'i aɗa yolbi, de min nyaamni ma naa aɗa ɗomɗi, de min njarni ma? ");
INSERT INTO fuhbkf_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ndey min nji'i a beero, de min njaɓɓii ma, naa a kolɗo, de min koltini maa? ");
INSERT INTO fuhbkf_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ndey min nji'i a nyawɗo naa a uddaaɗo ley kasu, de min ngari ndaarude ma?» ");
INSERT INTO fuhbkf_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Kaananke oon jaaboto ɓe wi'a: «Goonga kaalanammi on: ko ngaɗanɗon gooto e ɓurɗo famɗude ley sakiraaɓe am ɓeen fu, wo miin ngaɗanɗon.» ");
INSERT INTO fuhbkf_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Caggal ɗuum, o wi'an wonɓe junngo makko nano ɓeen: «Mboɗɗee kam, onon huɗaaɓe Laamɗo! Njehee ley yiite duumiinge nge Laamɗo resani Ibiliisa e maleyka'en muuɗum ngeen! ");
INSERT INTO fuhbkf_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Sabo mi yolbiino, de on nyaamnaay kam. Mi ɗomɗiino, de on njarnaay kam. ");
INSERT INTO fuhbkf_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Mi weeriino, de on njippinaay kam. Mi holiino, de on koltinaay kam. Mi nyawiino, mi uddanooma, de on ngaraay ndaarude kam.» ");
INSERT INTO fuhbkf_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ndeen, ɓe njaaboto mo kamɓe du, ɓe mbi'a: «Joomiraaɗo, ndey min nji'i aɗa yolbi naa aɗa ɗomɗi naa aɗa weeri naa aɗa holi naa aɗa nyawi naa aɗa ommbaa ley kasu, de min mballaay ma?» ");
INSERT INTO fuhbkf_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","O jaaboto ɓe, o wi'a: «Goonga kaalanammi on: ko on ngaɗanaay gooto e ɓurɓe famɗude ɓee ɗo ɗuum, wo miin woni on ngaɗanaay.» ");
INSERT INTO fuhbkf_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ndeen, ɓe njahan ley jukkungo duumiingo, de fonnditiiɓe ɓeen keɓa nguurndam nduumiiɗam. ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Nde Iisaa timminnoo waajuuji ɗiin fuu, wi'i taalibaaɓe muuɗum ɓeen: ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Oɗon anndi balɗe ɗiɗi keddanii en e iidi Faltagol, de Ɓii Neɗɗo hokkitirte faa tontee e leggal palaangal. ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","E wakkati oon, hooreeɓe almaami'en e mawɓe Alhuudiyankooɓe ɓeen kawritowi galle Almaami Mawɗo bi'eteeɗo Kayafas. ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ɓe fuu ɓe ndawridi faa ɓe nanngira Iisaa hiila, ɓe mbara ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ammaa ɓe mbi'i: —Taa ngaɗen ɗum ley iidi ndi de yimɓe muurta. ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Tawi Iisaa ina woni ley Baytaniya to suudu Simon noddirteeɗo ceppinɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Debbo gomma ɓattitii ɗum ina jogii faandu nebbam uurɗam, tiiɗuɗam coggu sanne. O tawi Iisaa ina nyaama, o joori ɗam dow hoore muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Nde taalibaaɓe ɓeen nji'unoo ɗum ndeen, mettaa, ina mbi'a: —Ɗume saabii de nebbam ɗaam bonniraa ni? ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Iɗam waawnoo sonneede ceede keewɗe, de ceede ɗeen kokkee talkaaɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Iisaa faamii ko ɓe kaalata ɗuum, wi'i ɓe: —Ko waɗi de oɗon torra debbo o? O gollanii kam gollal lobbal. ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Si goonga, talkaaɓe ina tawdee e mooɗon wakkati fuu. De miin kaa, mi tawdataake e mooɗon wakkati fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","O joorii nebbam uurɗam ɗam dow ɓanndu am faa o segilanoo kam uweede. ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Goonga kaalanammi on: ɗo Kabaaru Lobbo waajaa e adunaaru ndu fuu, ko debbo o waɗi ɗuum fillitete, faa o miccitee. ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ndeen Yahuuda Isikariyotto, gooto e taalibaaɓe sappo e ɗiɗo ɓeen, yehi to hooreeɓe almaami'en, ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","wi'i ɗum'en: —Ɗume kokkoton kam si mi waddanii on Iisaa? Ndeen ɓe njoɓi mo buuɗi cardi capanɗe tati. ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Gilla ndeen, Yahuuda ina filoo wakkati faa jamboo Iisaa. ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Nyalaande go'aɓerde iidi buuru mo wattaaka rabilla, taalibaaɓe ɓeen ngari, ƴami Iisaa, mbi'i ɗum: —Toy njiɗɗaa min cegilanowe hiraande iidi Faltagol ndeen? ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","O jaabii ɓe, o wi'i: —Njehee ngalluure toon, naaton suudu maani, mbi'on ɗum: «Moodibbo wi'i wakkati muuɗum yonii. Wo to suudu maaɗa waɗata iidi Faltagol, kam e taalibaaɓe muuɗum.» ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Taalibaaɓe ɓeen ngaɗi ko Iisaa yamiri ɗum'en, cegilii hiraande ndeen. ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Nde hiirnoo fu, Iisaa jooɗodii e taalibaaɓe sappo e ɗiɗo ɓeen faa ɓe kiirtoo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Nde ɓe kiirtotonoo ndeen, o wi'i: —Goonga kaalanammi on: gooto mooɗon jamboto kam. ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ɓe cunii sanne, heddii iɓe ƴamira mo gooto gooto, mono fuu ina wi'a: —Joomam, kori wanaa miin? ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","O jaabii, o wi'i: —Cuuwidinɗo e am junngo muuɗum ley le'al ngal, oon jambotoo kam. ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Tilay Ɓii Neɗɗo yoppira adunaaru no haaliraa ley Binndi ɗiin ni. Ammaa bone woodanii jambotooɗo Ɓii Neɗɗo oon! Gorko oon, si rimaakano fey ɓuri woodde e muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yahuuda jamboytooɗo mo oon hooƴi haala, ƴami mo, wi'i: —Moodibbo, kori wanaa miin? O jaabii ɗum, o wi'i: —Aan e hoore maa haali. ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Nde ɓe nyaamannoo ndeen, Iisaa hooƴi buuru, yetti Laamɗo, heltii, hokki taalibaaɓe muuɗum ɓeen, wi'i: —Njaɓee, nyaamee. Ɗum woni ɓanndu am. ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Caggal ɗuum, o hooƴi horde cabijam, o yetti Laamɗo, o hokki ɓe, o wi'i: —Njaree, on fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ɗum woni ƴiiƴam am tabintinoojam amaana Laamɗo. Ɗam rufete saabe heewɓe faa hakkeeji muɓɓen njaafee. ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Miɗo haalana on: mi yarataa cabijam ɗam katin si wanaa nyannde nde njardowammi e mooɗon kesam ley laamu Baaba am. ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Caggal ɓe njimii Jabuura, ɓe njalti, ɓe njehi dow waamnde wi'eteende Jaytun. ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Wakkati oon, Iisaa wi'i ɓe: —Ley jemma o, on fuu on njoppan kam, sabo ina winndaa: «Mi fiyan duroowo piiɗe maayde, de coggal baali ngaal sankitoo.» Iisaa ɓeydi, wi'i: ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","—Ammaa nde iirtinowaami fu, mi artoyto on Galili. ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ndeen Piyeer hooƴi haala, wi'i mo: —Fay si ɓe fuu ɓe njoppi ma, miin kaa abada mi yoppataa ma. ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Iisaa jaabii mo, wi'i: —Goonga kaalanammaami: jemma o pay, fadde ndontoori joggude a wi'an a anndaa kam kile tati. ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Piyeer wi'i mo: —Fay si tilsi mi maaydan e maaɗa, abada mi wi'ataa mi anndaa ma. Taalibaaɓe ɓeen fuu mbi'i hono noon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Caggal ɗuum, Iisaa yottodii e maɓɓe nokku bi'eteeɗo Geccemane, wi'i ɓe: —Njooɗee ɗo, faa mi yaha mi waɗowa du'aare. ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","O yaadi e Piyeer e ɓiɓɓe Jebede ɗiɗo ɓeen, ɓernde makko fuɗɗi maatude mettorgal e kaaɗeefi. ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Wakkati oon, o wi'i ɓe: —Mettorgal ina mawni e am sanne faa ina nesa warude kam. Keddee ɗo, ndoomidee e am, kakkilen. ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","O toowti seeɗa, o hippi yeeso makko e leydi, imo du'oo, imo wi'a: —Baabiiwo, si tawii ina laatoo, woɗɗinam horde torra nde. Ammaa taa laatoroo no muuyirmi, laatoroo no muuyirɗaa aan. ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","O warti, o tawi iɓe ɗaanii. O wi'i Piyeer: —On ngalaa semmbe faa ndoomidon e am fay haddi wawtu gooto naa? ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Kakkilee, ndu'ee, taa on njarribe. Sabo hakkillo ina heewi anniya lobbo, ammaa terɗe ina lokkiɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","O yehi katin, o du'ii, o wi'i: —Baabiiwo, si tawii horde bone nde waawaa woɗɗineede si wanaa mi yara ɗum fu, muuyɗe maa laatoo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","O warti, o tawi ɓe ɗaantake, sabo ɗoyngol maɓɓe na teddi sanne. ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","O yehi katin, o du'ii tataɓerde hono no o du'orinoo ni. ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Caggal ɗuum, o warti to taalibaaɓe ɓeen, o wi'i ɗum'en: —On ɗaani, oɗon ŋootta naa? Ndaaree, wakkati o yottake! Ɓii Neɗɗo wattete e juuɗe luttuɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ummee njehen! Inan jambotooɗo kam oon ina ɓattitii. ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","O tilaaki haalude, faa Yahuuda, gooto e sappo e ɗiɗo ɓeen, yottii ina wondi e yimɓe heewɓe jogiiɓe kaafaaje e cabbi. Wo ɓe nulaaɓe hooreeɓe almaami'en e mawɓe Alhuudiyankooɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Jambotooɗo mo oon hokkiino ɓe filnde, wi'i: —Mo mucciimi fu, oon woni kanko. Nanngon ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Wakkati oon pay, Yahuuda ɓattitii Iisaa, wi'i ɗum: —Foofoo Moodibbo! O muccii ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Iisaa jaabii mo, wi'i: —Giɗo am, waɗu ko waddi maa ɗuum. Wakkati oon, ɓe ɓattitii Iisaa, ɓe nanngi ɗum, ɓe tiigii ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Gooto e wonduɓe e Iisaa ɓeen soorti kaafaahi mum, soppi maccuɗo Almaami Mawɗo, taƴi nowru muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ndeen, Iisaa wi'i mo: —Soornu kaafaahi maa ki e hulgo muuɗum, sabo kamreteeɗo kaafaahi fuu, kaafaahi halkata ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Maa du aɗa miila joonin mi waawaa noddude Baaba am nulda kam ko ɓuri konuuji sappo e ɗiɗi maleyka'en naa? ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ammaa si ɗum laatorake noon, noy ko winndaa e ley Binndi ɗiin ɗuum tabitirta? Ɗi mbi'ii sanaa ɗum laatoroo noon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","E wakkati oon, o wi'i jamaa oon: —Ko waɗi de ngarduɗon e kaafaaje e cabbi faa nanngon kam hono wo mi gujjo? Nyannde fuu miɗo jooɗinoo ley suudu dewal mawndu nduun, miɗo janngina, de on nanngaay kam. ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ammaa ɗum fuu waɗan faa Binndi annabaaɓe ɗiin tabita. Ndeen, taalibaaɓe ɓeen fuu njoppi mo, ndoggi. ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Nannguɓe Iisaa ɓeen njaari ɗum to Kayafas Almaami Mawɗo oon. Tawi jannginooɓe Tawreeta e mawɓe lenyol ɓeen kawritii toon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Piyeer le, ina jokki mo to toowti seeɗa, faa e taliyaare galle Almaami Mawɗo oon. O naati ley galle oon, o jooɗodii e doomooɓe ɓeen faa o yi'a no ɗum sakitortoo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Wooɗi, hooreeɓe almaami'en e jeyaaɓe e waalde Saahiiɓe ndeen fuu ina piloo fewre nde pelda Iisaa faa waree, ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","de ɓe keɓaay. Fay ko heewɓe ngari seedanaade mo pene ɗuum, sabaabu baawɗo warude mo fuu walaa. Sakitii, worɓe ɗiɗo ngari, ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","mbi'i: —Kanko wi'unoo imo waawi liɓude suudu dewal Laamɗo, de o nyiɓtoo ndu ley balɗe tati. ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Almaami Mawɗo oon ummii, wi'i Iisaa: Walaa ko njaabotoɗaa naa? Ko yimɓe ɓe ceedante ɗuum wo ɗume? ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ɗum fuu imo deƴƴinii. Almaami Mawɗo oon wi'i mo: —Miɗo yamire e innde Laamɗo buurɗo, kaalanaa min si tawii aan woni Almasiihu, Ɓii Laamɗo oon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","O jaabii ɗum, o wi'i: —Aan e hoore maa haali. Katin, miɗo wi'a on: gilla joonin, on nji'an Ɓii Neɗɗo ina jooɗii gere nyaamo Jom baawɗe oon. O warowan dow duule kammu. ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Haalaaji makko ɗiin metti Almaami Mawɗo oon faa seeki kaddule muuɗum, wi'i: —O mbonkake Laamɗo! Walaa fuu ko kaajaraɗen seedeeɓe katin! On narrii noppi mooɗon ko o mbonkii Laamɗo ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ɗume miiliɗon? Ɓe njaabii, ɓe mbi'i: —Imo haani wareede. ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Caggal ɗuum, ɓe tutti e yeeso makko, ɓe culkii mo. Woɓɓe maɓɓe ina peenya mo, ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ina mbi'a: —Hey Almasiihu! Si a annabaajo, haalan min moy fiyi ma! ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Tawi Piyeer ina jooɗii yaasin suudu nduun ley taliyaare galle oon. Gooto e horɓe wonɓe ɗoon ɓattitii mo, wi'i: —Aan, aɗa wondunoo e Iisaa Galilinkeejo oon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","O yeddi ɗum hakkunde yimɓe fuu, o wi'i: —Mi faamaay ko kaalataa ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Caggal ɗuum, o fonndii to dammbugal galle toon. Korɗo goɗɗo yi'i mo, wi'i wonɓe ɗoon ɓeen: —Gorko o ina wondunoo e Iisaa Nasaraatuujo oon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Piyeer yeddi katin, wi'i: —Mi hunake, mi anndaa gorko o. ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Faa ɓooyti seeɗa, dariiɓe ɗoon ɓeen ɓattii Piyeer, mbi'i ɗum: —Tannyoral, aan du wo a gooto maɓɓe, sabo ɗemngal maa ngal hollii to ƴuuruɗaa. ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","E ley ɗuum, Piyeer fuɗɗi hunaade e huttaade, ina wi'a: —Mi anndaa gorko o! Wakkati oon pay, ndontoori joggi. ");
INSERT INTO fuhbkf_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","De Piyeer miccitii ko Iisaa wi'unoo ɗuum: «Fadde ndontoori joggude, a wi'an a anndaa kam kile tati.» O wurtii yaasin, imo woya bojji cattuɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Gilla fajiri, hooreeɓe almaami'en e mawɓe lenyol ɓeen fuu kawriti, ndarni anniya warude Iisaa. ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ɓe kaɓɓi mo, ɓe njaari mo, ɓe ngatti mo e juuɗe Pilaatu goforneer oon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Nde Yahuuda jambiiɗo Iisaa oon yi'unoo no Iisaa saroraa wo bareteeɗo fu, mimsiti. O wartiri buuɗi cardi capanɗe tati ɗiin to hooreeɓe almaami'en e mawɓe lenyol ɓeen. ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","O wi'i ɗum'en: —Mi luttii ko njambiimi mo walaa feloore ɗuum! Ɓe njaabii mo, ɓe mbi'i: —Ko jomi min? Wo aan ɗum woodani. ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yahuuda faɗɗi ceede ɗeen ley suudu dewal mawndu nduun, dilli. Ndeen yehi, hooƴi ɓoggol, waritowii. ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Hooreeɓe almaami'en ɓeen kooƴi ceede ɗeen, mbi'i: —Dagaaki ceede ɗe ngattee ley keesu oon, sabo wo ɗum njobdi ƴiiƴam. ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ɓe ndawridi dow majjum, de ɓe kooƴi ceede ɗeen, ɓe coodi ngesa mahoowo looɗe, ɓe ngaɗi nga caabeeje weerɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ɗum waɗi de ngesa ngaan ina wi'ee «Ngesa Ƴiiƴam» faa hannden. ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Noon haala ka annabi Yeremiya haalnoo kaan tabintiniraa nde wi'unoo: «Ɓe kooƴii buuɗi cardi capanɗe tati, coggu mo yimɓe Israa'iila kiisorii yonki makko, ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ɓe coodi ɗum ngesa mahoowo looɗe, hono no Joomiraaɗo yamiri kam ni.» ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Iisaa darii yeeso goforneer oon. Oon ƴami mo, wi'i: —Aan woni kaananke Alhuudiyankooɓe oon naa? O jaabii, o wi'i: —Aan e hoore maa haali. ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ammaa nde hooreeɓe almaami'en e mawɓe lenyol ɓeen pelannoo mo ndeen, o nootaaki fay huunde. ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ndeen Pilaatu wi'i mo: —A nanataa ko ɓe ceedante ɗuum fuu naa? ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ammaa o jaabaaki faa'e. Ɗum haaynii goforneer oon sanne. ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Wakkati Iidi Faltagol fuu, goforneer oon ina woowi yoofande yimɓe ɓeen kasuujo gooto mo njiɗi yoofaneede. ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Wakkati oon, ina woodi kasuujo jom innde, bi'eteeɗo Iisaa Barabas. ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","E ley ko jamaa oon hawriti ɗuum, Pilaatu ƴami ɓe, wi'i: —Moy njiɗuɗon mi yoofana on: Iisaa Barabas naa Iisaa bi'eteeɗo Almasiihu oon? ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Si goonga, Pilaatu faamii wo kiram waɗi de ɓe kokkitiri Iisaa. ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Katin du, wakkati o jooɗinoo ley sarordu oon, jom suudu makko neli e makko, wi'i: —Celaa gorko ponnditiiɗo oon, sabo jemma hankin koyɗi makko tampinii kam sanne. ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Hooreeɓe almaami'en e mawɓe lenyol ɓeen ndunƴi jamaa oon nyaagoo Pilaatu yoofana ɓe Barabas, de wara Iisaa. ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Goforneer oon ƴamtindii ɓe: —Moy e ɗiɗo ɓeen njiɗuɗon mi yoofana on? Ɓe njaabii, ɓe mbi'i: —Barabas! ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilaatu ƴami ɓe, wi'i: —Ndelle, noy ngaɗammi Iisaa bi'eteeɗo Almasiihu oon? Ɓe fuu ɓe njaabii, ɓe mbi'i: —Tontu mo e leggal palaangal! ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","O ƴami ɓe, o wi'i: —Ɗume o waɗi ko boni? De ɓe ɓeydi ƴeewnaade semmbe, iɓe mbi'a: —Tontu mo e leggal palaangal! ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ndeen Pilaatu yi'i walaa ko waawi, tawi du muurtere ina ummoo. O hooƴi ndiyam, o looti juuɗe makko yeeso yimɓe ɓeen, o wi'i ɓe: —Miin kaa, baka am walaa e rufugol ƴiiƴam gorko o. Wo onon ɗum woodani. ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ɓe fuu ɓe njaabii, ɓe mbi'i: —Ƴiiƴam makko ina yowii dow amin, minen e ɓiɓɓe amin! ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ndeen, Pilaatu yoofani ɓe Barabas, de yamiri Iisaa fiyee dorri. Caggal ɗuum, o hokkitiri ɗum tontowee e leggal palaangal. ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Sordaasiiɓe goforneer ɓeen njaari Iisaa to galle laamorde ley huɓeere toon. Ɓe ngaddi fedde sordaasiiɓe ɓeen fuu piilii mo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ɓe ɓorti mo kaddule makko, ɓe ɓorni mo saaya mboɗeeha. ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Caggal ɗuum, ɓe canyi taarde gi'e, ɓe kippi e hoore makko, ɓe ngatti loosol e junngo makko nyaamo. Ndeen ɓe kofii yeeso makko, iɓe njalnoroo mo, iɓe mbi'a: —Foofoo, kaananke Alhuudiyankooɓe! ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ɓe tutti dow makko, ɓe kooƴi loosol ngool iɓe piya mo hoore. ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Nde ɓe tilinoo jalnoraade mo ndeen, ɓe itti saaya kaan, ɓe ɓorni mo kaddule makko. Ndeen ɓe njaari mo faa ɓe tontowa mo e leggal palaangal. ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Nde ɓe njaltannoo ngalluure ndeen fu, ɓe kawri e gorko jeyaaɗo Sireene bi'eteeɗo Simon. Sordaasiiɓe ɓeen ndoolɗi mo o wakkoo leggal Iisaa palaangal ngaal. ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ɓe njottowii nokku bi'eteeɗo Golgata (maanaa majjum woni «Nokku Laalagal Hoore»). ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ɓe kokki Iisaa cabijam njillunduraaɗam e kaankaanngel faa o yara. Nde o meeɗunoo ɗum ndeen, o salii yarude. ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Nde ɓe tontunoo mo e leggal palaangal ndeen, ɓe pecciri kaddule makko cumnal. ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Caggal ɗuum, ɓe njooɗii toon iɓe ndooma mo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ɓe mbinndi sabaabu ko tonti mo, ɓe takki ɗum ɗo tiimtude hoore makko ɗoon. Binndi dow maggal na mbi'a: O wo Iisaa, Kaananke Alhuudiyankooɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Tawi du, yanooɓe ɗiɗo tontidaa e makko, gooto gere nyaamo makko, gooto du gere nano makko. ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Yimɓe faltotooɓe ɗoon ɓeen ina njenna mo, ina ndimmba ko'e muɓɓen, ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ina mbi'a: —Aan liɓoowo suudu dewal mawndu de nyiɓtoo ndu ley balɗe tati, dannu hoore maa! Si wo a Ɓii Laamɗo, jippa leggal palaangal ngal! ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Hono noon, hooreeɓe almaami'en e jannginooɓe Tawreeta e mawɓe lenyol ɓeen fuu ina njalnoroo mo, ina mbi'a: ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—O dannii woɓɓe, de o waawaa dannude hoore makko. Wo o kaananke Israa'iila. Jonle, o jippoo leggal palaangal ngal, faa ngoonɗinen mo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","O halfinii hoore makko Laamɗo. Laamɗo hisina mo joonin si na yiɗi mo. Sabo o wi'ii wo o Ɓii Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Yanooɓe tontaaɓe ɗakkol makko ɓeen du ina mbonkoroo mo noon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Gilla hakkunde naange, nimre waɗi e leydi fuu faa wakkati yamnde tati kiiral naange. ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Wakkati yamnde tati kiiral naange, Iisaa feekii feekaango toowngo, wi'i: — Eli, Eli, lama sabaktani? (Ɗum na fiirta «Laamɗo am, Laamɗo am! Ɗume saabii de njoppuɗaa kam?») ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Nde woɓɓe dariiɓe toon ɓeen nannoo ɗum ndeen, mbi'i: —Wo annabi Iliyaasa o noddata! ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Wakkati oon ni, gooto doggi waddowi tekkere, suuwi nde e ndiyam lammuɗam, haɓɓi nde e loosol. De o fonndini hunnduko Iisaa faa muyta. ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ammaa heddiiɓe ɓeen mbi'i: —Yoppu. Ndaaren yalla Iliyaasa waran danna mo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Caggal ɗuum, Iisaa feekii feekaango toowngo katin, de yoofi yonki muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Wakkati oon, lefol paliingol ley suudu dewal mawndu ngool seekii gilla dow faa ley, laatii taƴe ɗiɗi. Leydi dimmbii, kaaƴe ceekii. ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Caabeeje udditii, de seniiɓe maaynooɓe heewɓe iirtii. ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Caggal ko Iisaa iirtii ɗuum, ɓe njalti e caabeeje ɗeen, ɓe naati ngalluure seniinde ndeen. Yimɓe heewɓe nji'i ɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Sordaasiiɓe doomuɓe Iisaa ɓeen e hooreejo muɓɓen nji'ii no leydi dimmborii e ko waɗi ɗuum fuu. Ɓe kuli sanne, ɓe mbi'i: —Si goonga ni, o wo Ɓii Laamɗo! ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Rewɓe heewɓe ina ngoni to toowti, ina kaynoo. Wo ɓe jokkunooɓe Iisaa gilla Galili faa ɓe ngollana ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Mariyama mo Magdala e Mariyama inna Yaakuuba e Yuusufi, kam e inna ɓiɓɓe Jebede ina ngoni hakkunde maɓɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Nde hiirnoo fu, gorko jom jawdi jeyaaɗo Arimatiya wari. Imo wi'ee Yuusufi. Kam du wo taalibaajo Iisaa. ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","O yehi to Pilaatu, o ŋaarii ɗum ɓanndu Iisaa. Pilaatu yamiri o hokkee ndu. ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","O hooƴi ɓanndu nduun, o fiili ɗum e kasanke keso. ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","O watti ɗum e saabeere heyre nde o wasannoo hoore makko e hayre. Caggal ɗuum, o talliti hayre teddunde, o uddiri dammbugal saabeere ndeen, o dilli. ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mariyama mo Magdala e Mariyama goɗɗo oon ina njooɗii ɗoon, ina kucciti e saabeere ndeen. ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Jaango majjum wo nyalaande fowteteende. Hooreeɓe almaami'en e Farisa'en kawriti to Pilaatu, ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","mbi'i ɗum: —Joomii amin, min miccitake kiiloowo yimɓe oon wi'iino nde wuurnoo ndeen, balɗe tati caggal maayde muuɗum iirtoto. ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ndelle, njamiraa saabeere ndeen doomee faa nyalooma tataɓo oon faltoo, taa taalibaaɓe makko ngara mbujja ɓanndu makko mbi'a yimɓe ɓeen o ummitake hakkunde maayɓe. Ndeen kaa, hiila cakitiika kaan ɓuran arandeeha kaan bonde. ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilaatu wi'i ɓe: —Inan sordaasi'en ndaarooɓe. Njehee, kooƴee ɗum'en, ndoomira saabeere ndeen no mbaawiri fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ɓe njehi hayboyde saabeere ndeen: ɓe takki ommboode ndeen, ɓe ngaɗi maande dow mayre, ɓe ndarni ɗoon sordaasiiɓe ndaarooɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Nde nyalaande fowteteende ndeen faltinoo fu, gilla naange fuɗaay nyannde alan, Mariyama mo Magdala e Mariyama goɗɗo oon njehi ndaaroyde saabeere ndeen. ");
INSERT INTO fuhbkf_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","De inan, leydi dimmbii semmbe. Maleyka Joomiraaɗo ƴuuri dow kammu jippii, talliti hayre ndeen jooɗii dow mayre. ");
INSERT INTO fuhbkf_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Imo jalbira hono maƴƴere, kaddule makko du ina ndawni far, hono jalbugol daandorgal ni. ");
INSERT INTO fuhbkf_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Doomooɓe ɓeen kuli sanne faa ina ndiwna, laatii hono maayɓe ni. ");
INSERT INTO fuhbkf_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Maleyka oon wi'i rewɓe ɓeen: —Onon kaa, taa kulee! Miɗo anndi Iisaa tontanooɗo oon pilotoɗon. ");
INSERT INTO fuhbkf_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","O walaa ɗo, o ummitake hono no o wiirunoo ni. Ngaree, ndaaree nokku ɗo o waalinoo ɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","De kenyoɗon, njahon, kumpitowon taalibaaɓe makko ɓeen o ummitake e maayde. Wooɗi, joonin o artoyto on Galili. Toon nji'oyton mo. Ɗum njoginoomi faa mi haalana on. ");
INSERT INTO fuhbkf_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Rewɓe ɗiɗo ɓeen kenyii, ndilli to saabeere toon, iɓe keewi kulol e seyo manngo. Ɓe ndoggi yaade faa ɓe kaalanowa taalibaaɓe makko ɓeen kabaaru o. ");
INSERT INTO fuhbkf_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Wakkati oon ni, Iisaa hawri e maɓɓe, wi'i ɓe: —Foofoo! Ɓe ɓattitii mo, ɓe nanngi koyɗe makko, ɓe cujidani mo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ndeen, o wi'i ɓe: —Taa kulee! Njehee mbi'owee taalibaaɓe am ɓeen njaha Galili. Toon ɓe nji'oyta kam. ");
INSERT INTO fuhbkf_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Nde rewɓe ɓeen ndillannoo ndeen, woɓɓe e sordaasiiɓe ndaarooɓe saabeere ɓeen kooti ngalluure toon, kaalani hooreeɓe almaami'en ɓeen ko waɗi ɗuum fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Hooreeɓe almaami'en ɓeen kawriti e mawɓe yimɓe. Ɓe ndawridi faa ɓe kokka sordaasiiɓe ɓeen ceede keewɗe. ");
INSERT INTO fuhbkf_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ɓe mbi'i ɗum'en: —Mbi'on taalibaaɓe makko ɓeen ngarii jemma tawi oɗon ɗaanii, de mbujji mo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Si goforneer oon nanii ɗum fu, min koomtan ɗum, min keedana on e torra fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Sordaasiiɓe ɓeen nanngi ceede ɗeen, ngaɗi no mbiiraa noon. Nii du haala kaan fillortee hakkunde Alhuudiyankooɓe faa hannden. ");
INSERT INTO fuhbkf_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Taalibaaɓe sappo e ngo'o ɓeen njehi Galili to dow waamnde nde Iisaa tindinnoo ɗum'en ndeen. ");
INSERT INTO fuhbkf_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Nde ɓe nji'unoo mo ndeen, ɓe cujidani mo, ammaa woɓɓe maɓɓe cikkitirii. ");
INSERT INTO fuhbkf_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","O ɓattitii, o wi'i ɓe: —Mi hokkaama baawɗe fuu dow kammu e leydi. ");
INSERT INTO fuhbkf_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ndelle, njehee to lenyi yimɓe fuu, ngaɗon ɗum'en taalibaaɓe am, lootiron ɓe lootagal batisima e innde Baabiiwo e Ɓiɗɗo e Ruuhu Ceniiɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Njannginon ɓe ɓe njokka ko njamirmi on ɗuum fuu. Anndee, miɗo wondi e mooɗon nyannde fuu faa ɗo adunaaru timmi.");
INSERT INTO fuhbkf_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ɗum woni fuɗɗoode Kabaaru Lobbo haala Iisaa Almasiihu Ɓii Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ina winndaa e dewtere annabi Esaaya: «Laamɗo wi'ii: Ndaaree, mi ardinante nulaaɗo am moƴƴinane laawol. ");
INSERT INTO fuhbkf_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Daande ina ƴeewnoo ley ladde na wi'a: Moƴƴinee laawol Joomiraaɗo, ndartinee ɗati makko.» ");
INSERT INTO fuhbkf_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Nulaaɗo oon woni Yaayaa lootoowo lootagal batisima. O ɓangii ley ladde, imo gooyna yimɓe tuuba, lootiree lootagal batisima faa hakkeeji muɓɓen njaafee. ");
INSERT INTO fuhbkf_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Yimɓe leydi Yahuudiya e yimɓe Urusaliima fuu ngari to makko. Iɓe kaalta hakkeeji maɓɓe, de Yaayaa ina loota ɓe lootagal batisima ley gooruwol Urdun. ");
INSERT INTO fuhbkf_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yaayaa ina ɓornii kaddule gaɗiraaɗe leeɓi geelooɗi, ina haɓɓii kaɓɓorgol nguru, ina wuuri baɓɓatti e njuumndi ladde. ");
INSERT INTO fuhbkf_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Imo waajoroo daande toownde, imo wi'a: —Ɓurɗo kam baawɗe waran gaɗa am, mi fotaay fay turaade mi haɓɓita ɓoggi paɗe makko. ");
INSERT INTO fuhbkf_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Miin, ndiyam batisima lootirmi on, de kanko kaa, Ruuhu Ceniiɗo o lootirta on. ");
INSERT INTO fuhbkf_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ley balɗe ɗeen, Iisaa ƴuuri Nasaraatu ley leydi Galili, wari, de Yaayaa looti mo lootagal batisima ley gooruwol Urdun. ");
INSERT INTO fuhbkf_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Wakkati mo o wurtotonoo ndiyam ɗaam oon, o yi'i kammu na udditii, o yi'i Ruuhu Ceniiɗo ina jippoo e makko hono no wuugaandu ni. ");
INSERT INTO fuhbkf_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ndeen daande ƴuuri dow kammu, wi'i: —Aan woni Ɓiyam mo korsinmi, aan ceyortoomi. ");
INSERT INTO fuhbkf_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Wakkati oon fu, Ruuhu Laamɗo yaari mo ley ladde. ");
INSERT INTO fuhbkf_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","O waɗi toon balɗe capanɗe nay, Seyɗaani ina jarriboo mo. Imo woni hakkunde kulle ladde, maleyka'en ina ngollana mo. ");
INSERT INTO fuhbkf_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Caggal uddeede Yaayaa ley kasu, Iisaa yehi Galili ina waajoo Kabaaru Lobbo haala Laamɗo, ");
INSERT INTO fuhbkf_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","ina wi'a: —Wakkati warii, laamu Laamɗo ɓadake. Tuubee, ngoonɗinee Kabaaru Lobbo. ");
INSERT INTO fuhbkf_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Iisaa ina yaha hunnduko maayo Galili, ɗoon yi'i Simon e minyum Andire ina paɗɗa fiiliiji muɓɓen ley maayo ngoon. Wo ɓe nanngooɓe liƴƴi. ");
INSERT INTO fuhbkf_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Iisaa wi'i ɓe: —Njokkee kam, mi waɗan on filotooɓe yimɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Wakkati oon ɓe njoppi fiiliiji maɓɓe ɗiin, ɓe njokki mo. ");
INSERT INTO fuhbkf_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","O yehi yeeso seeɗa, o yi'i Yaakuuba ɓii Jebede e minyum Yuhanna ley laana muɓɓen ina moƴƴintina fiiliiji. ");
INSERT INTO fuhbkf_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Wakkati oon fu, o noddi ɓe. Ɓe njoppi baabiiɓe Jebede, kam e gollooɓe muuɗum ley laana kaan, ɓe njokki mo. ");
INSERT INTO fuhbkf_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Caggal ɗuum, ɓe njehi ngalluure Kafarnahum. Nyannde fowteteende, Iisaa naati suudu waajordu, fuɗɗi waajaade. ");
INSERT INTO fuhbkf_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Tawaaɓe ɗoon ɓeen kaaynaa e waaju makko oon, sabo o waajorake ɓe no jom baawɗe ni, wanaa hono jannginooɓe Tawreeta. ");
INSERT INTO fuhbkf_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Gorko gonduɗo e ginnaaru ina woni e waajordu nduun, wulli, ");
INSERT INTO fuhbkf_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","wi'i: —Aan Iisaa mo Nasaraatu, ɗume jomi ma e amin? A warii faa kalkaa min naa? Miɗo anndi ko ngonɗaa, a Ceniiɗo ƴuuruɗo to Laamɗo! ");
INSERT INTO fuhbkf_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Iisaa sappani ginnaaru nduun e semmbe, wi'i: —Deƴƴina, yaltu e makko! ");
INSERT INTO fuhbkf_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ginnaaru nduun dimmbi gorko oon semmbe, feekii feekaango toowngo, yalti e makko. ");
INSERT INTO fuhbkf_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Jamaa oon fuu ɗum haaynii ɗum, heddii ina ƴamundura: —Ɗum wo ɗume? Ɗum wo anndal kesal koy! Imo yamira fay ginnaaji de iɗi ɗowtanoo mo. ");
INSERT INTO fuhbkf_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Wakkati gooto kabaaru makko sankitii ley leydi Galili fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Nde ɓe njaltunoo waajordu nduun ndeen, ɓe njehi wuro Simon e Andire. Yaakuuba e Yuhanna njaadi e maɓɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Esoo Simon debbo ina fukkii wo jontaaɗo. Iisaa yottii tan, haalanaa haala makko, ");
INSERT INTO fuhbkf_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","ɓattitii mo, nanngi junngo makko, ummini mo. Wakkati oon o daɗi e jontere makko, de o weerni ɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Wakkati futuro nde naange yannoo fuu, yimɓe ngaddani Iisaa nyawɓe e wonduɓe e ginnaaji fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ngalluure ndeen fuu hawriti to dammbugal ngaal. ");
INSERT INTO fuhbkf_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","O danni nyawɓe heewɓe, nyawɓe nyawuuji ɗi kawtaa sii. O riiwi ginnaaji keewɗi, o accataa ɗi kaala, sabo iɗi anndi mo o woni. ");
INSERT INTO fuhbkf_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Jaango majjum, Iisaa hejji gilla law, yehi nokku perwuɗo ina waɗa toon du'aare. ");
INSERT INTO fuhbkf_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simon e wonduɓe e muuɗum ina piloo mo. ");
INSERT INTO fuhbkf_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Nde ɓe njiinoo mo ndeen, ɓe mbi'i mo: —Yimɓe fuu ina pile. ");
INSERT INTO fuhbkf_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Iisaa wi'i ɓe: —En njaha ley gure ɓadiiɗe ɗeen faa mi waajoo toon du, sabo wo ɗuum waddi kam. ");
INSERT INTO fuhbkf_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","O yehi ley leydi Galili fuu, imo waajoo ley cuuɗi maɓɓe baajorɗi, imo riiwa ginnaaji. ");
INSERT INTO fuhbkf_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Gorko ceppinɗo wari dikkinii yeeso makko, nyaagii mo, wi'i: —Si a muuyii fu, aɗa waawi dannude kam faa mi laaɓa. ");
INSERT INTO fuhbkf_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Iisaa yurmii mo, foorti junngo muuɗum, meemi mo, wi'i: —Mi muuyii, daɗu! ");
INSERT INTO fuhbkf_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Wakkati oon, ceppam ɗaam dilli e gorko oon, o daɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Wakkati oon fu, Iisaa yoppi mo de gongini mo, ");
INSERT INTO fuhbkf_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","wi'i: —Tinna, taa humpitin fay gooto. Ammaa yahu holloy hoore maa almaami, ngaɗanaa laaɓugol maa ngol sadaka mo Muusaa yamiri oon, faa faamina ɓe a daɗii. ");
INSERT INTO fuhbkf_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ammaa kanko, ko o dillu ɗoon fu, o fuɗɗi sankitinde kabaaru oon. Ɗum waɗi de Iisaa waawaa naatude galluuje si yimɓe paamanii ɗum. O heddii ladde, yimɓe ina ƴuura tatteeji fuu ina ngara to makko. ");
INSERT INTO fuhbkf_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Gaɗa balɗe seeɗa, Iisaa warti ngalluure Kafarnahum. Yimɓe nani o wartii imo woni ley suudu. ");
INSERT INTO fuhbkf_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Jamaa keewɗo hawriti ley suudu ɗoon faa nokkuure fuu heddaaki, fay yaasin dammbugal toon. Heddii imo waajoo ɓe konngol Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Yimɓe ngari, ngaddani mo gorko mo ɓanndu waatundu. Worɓe nayo na ndonndii ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","De ɓe kunngii yottinde mo to Iisaa saabe jamaa oon. Ndelle ɓe ƴeeŋi dow suudu nduun, ɓe njuli dow ɗo fotata e Iisaa, de ɓe njippiniri ɗoon mo ɓanndu waatundu oon, tawi ina fukkinaa e daɗɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Nde Iisaa yiinoo goonɗinal maɓɓe ndeen, wi'i mo ɓanndu waatundu oon: —Ɓinngel am, hakkeeji maa njaafaama. ");
INSERT INTO fuhbkf_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Jannginooɓe Tawreeta jooɗinooɓe ɗoon ɓeen ina miiloo e ɓerɗe muɓɓen: ");
INSERT INTO fuhbkf_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«Ko waɗi gorko o na haalira hono ni? O mbonkake Laamɗo! Moy waawi yaafaade hakkeeji sanaa Laamɗo gooto oon?» ");
INSERT INTO fuhbkf_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Iisaa faami wakkati oon miilooji maɓɓe, wi'i ɓe: —Ɗume waɗi de oɗon miiloo miilooji gaaɗi ni e ɓerɗe mooɗon? ");
INSERT INTO fuhbkf_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ɗume ɓuri hoyude? Yalla wi'ude mo ɓanndum waati hakkeeji muuɗum njaafaama, naa wi'ude ɗum ummoo, hooƴa daɗɗo muuɗum, yaha? ");
INSERT INTO fuhbkf_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ammaa, faa mi faamina on Ɓii Neɗɗo ina jogii baawɗe yaafaade hakkeeji ley adunaaru ndu... Ndeen, o wi'i mo ɓanndu waatundu oon: ");
INSERT INTO fuhbkf_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Miɗo haalane: umma, hooƴu daɗɗo maa, kootaa suudu maa. ");
INSERT INTO fuhbkf_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Wakkati oon gorko oon ummii, hooƴi daɗɗo mum, dilli yeeso yimɓe ɓeen fuu. Ɓe fuu ɗum haaynii ɓe, ɓe keddii iɓe njetta Laamɗo, iɓe mbi'a: —Min nji'aay hono ɗum abada! ");
INSERT INTO fuhbkf_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Iisaa yeccitii to maayo toon. Jamaa oon fuu tawi mo toon, imo waajoo ɗum'en. ");
INSERT INTO fuhbkf_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Nde o yahannoo ndeen, o yi'i Lewi ɓii Alfaa ina jooɗii e suudu to lampo nanngetee, o wi'i ɗum: —Jokkam! Lewi ummii, jokki mo. ");
INSERT INTO fuhbkf_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Nde Iisaa nyaamannoo e ley suudu Lewi ndeen, nanngooɓe lampo heewɓe e luttuɓe woɓɓe na njooɗii, ina nyaamda e makko, kanko e taalibaaɓe makko. Sabo yimɓe heewɓe ina njokki Iisaa. ");
INSERT INTO fuhbkf_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Jannginooɓe Tawreeta jeyaaɓe e waalde Farisa'en nji'i Iisaa ina nyaamda e yimɓe ɓeen, mbi'i taalibaaɓe makko ɓeen: —Ko waɗi de imo nyaamda e nanngooɓe lampo e luttuɓe woɓɓe? ");
INSERT INTO fuhbkf_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Nde o nannoo ɗum ndeen, o wi'i ɓe: —Wanaa selluɓe kaajaa cawroowo, wo nyawɓe kaajaa cawroowo. Mi waraay faa mi nodda dartiiɓe. Wo luttuɓe ngarumi noddude. ");
INSERT INTO fuhbkf_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Taalibaaɓe Yaayaa e Farisa'en ina cuumoo. E ley ɗuum, yimɓe ngari, ƴami Iisaa: —Ko waɗi de taalibaaɓe Yaayaa e taalibaaɓe Farisa'en ina cuumoo, de ɓe maa ɓeen cuumataako? ");
INSERT INTO fuhbkf_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","O jaabii ɓe, o wi'i: —Yalla warɓe ɓangal ina mbaawi suumaade tawa ɓaŋuɗo oon ina wondi e muɓɓen naa? Mbaawaa. Sini ɓaŋuɗo oon ina wondi e maɓɓe, ɓe cuumataako. ");
INSERT INTO fuhbkf_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ammaa balɗe ngaran ɗe ɓaŋuɗo oon ittetee e hakkunde maɓɓe. E balɗe ɗeen ɓe cuumotoo. ");
INSERT INTO fuhbkf_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Fay gooto fidataa tekkere heyre e kaddungal kiinngal. Si ɗum waɗii, tekkere heyre ndeen fooɗan kaddungal kiinngal ngaal, de ceekol ngool ɓeydoo. ");
INSERT INTO fuhbkf_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Katin du fay gooto loowataa cabijam kesam e sumalleeji kiiɗɗi. Si ɗum waɗii fu, cabijam ɗaam fusan ɗi, kanjam e sumalleeji ɗiin fuu mbona. Cabijam kesam e sumalleeji kesi loowetee! ");
INSERT INTO fuhbkf_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Waɗiino e nyalaande fowteteende wootere, Iisaa ina rewi ley gese. Taalibaaɓe muuɗum ina itta cammeeji alkama e laawol ngool. ");
INSERT INTO fuhbkf_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ndeen Farisa'en mbi'i mo: —Ndaaru, ɗume waɗi de taalibaaɓe maa ɓe ina ngolla ko haɗaa golleede nyannde fowteteende? ");
INSERT INTO fuhbkf_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","O jaabii ɓe, o wi'i: —Yalla on njanngaay ko Daawda waɗi nde yolbunoo na haajaa ko nyaametee, kam e yaadiraaɓe muuɗum naa? ");
INSERT INTO fuhbkf_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","O naati hukum Laamɗo e ley jamaanu Almaami Mawɗo bi'eteeɗo Abiyatar, o nyaami buuru cakkaaɗo oon, o hokki yaadiraaɓe makko du. Tawi le, wo almaami'en tan njeyi nyaamude buuru oon. ");
INSERT INTO fuhbkf_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Iisaa wi'i ɓe katin: —Nyalaande fowteteende ndeen wo saabe neɗɗo waɗiraa, wanaa neɗɗo waɗiraa saabe nyalaande fowteteende ndeen. ");
INSERT INTO fuhbkf_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ndelle fay nyannde fowteteende ndeen, Ɓii Neɗɗo woni joomum. ");
INSERT INTO fuhbkf_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Iisaa naati ley suudu waajordu nduun katin, o tawi toon gorko mo junngo waanngo. ");
INSERT INTO fuhbkf_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Yimɓe wonɓe ɗoon ɓeen na taykoo Iisaa, iɓe ndaara yalla dannan gorko oon ley nyalaande fowteteende ndeen, faa ɓe keɓa ko ɓe pelira ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Iisaa wi'i mo junngo waanngo oon: —Umma, dara hakkunde maɓɓe! ");
INSERT INTO fuhbkf_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Caggal ɗuum, o ƴami ɓe: —Ɗume dagii nyannde fowteteende, gollude ko wooɗi naa gollude ko boni? Dannude neɗɗo naa warude ɗum? Ammaa ɓe njaabaaki. ");
INSERT INTO fuhbkf_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Iisaa ƴeewri ɓe tikkere, yoorgol ɓerɗe maɓɓe ngool woyni yonki makko. O wi'i gorko oon: —Foortu junngo maa! Oon foorti ngo tan, ngo daɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Wakkati oon, Farisa'en ɓeen njalti, njooɗodii e daraniiɓe Hirudus faa ndawrida no mbarda Iisaa. ");
INSERT INTO fuhbkf_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Caggal ɗuum, Iisaa e taalibaaɓe muuɗum dilli ɗoon, njehi maayo. Jamaa keewɗo ƴuuruɗo Galili jokki mo. ");
INSERT INTO fuhbkf_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Yimɓe heewɓe, ƴuuruɓe Yahuudiya e Urusaliima e Idumiya e leydi lettugal Urdun e seraaji Tirus e Sidon, nani ko o waɗata ɗuum, ngari to makko. ");
INSERT INTO fuhbkf_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Iisaa wi'i taalibaaɓe muuɗum ɓeen pilanoo ɗum laana taa jamaa oon ɓilla ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Saabe ko o dannata heewɓe ɗuum waɗi de nyawɓe ɓeen fuu kenyanii mo faa meema mo. ");
INSERT INTO fuhbkf_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Wakkati mo ginnaaji nji'i mo fu, ina kippoo, ina ƴeewnoo, ina mbi'a: —Aan a Ɓii Laamɗo! ");
INSERT INTO fuhbkf_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Imo sappana ɓe sanne taa ɓe kumpita fay gooto kabaaru makko. ");
INSERT INTO fuhbkf_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Caggal ɗuum, Iisaa ƴeeŋowi dow waamnde, noddi ɓe muuyi, de ɓe ngari to muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","O suɓii sappo e ɗiɗo, faa ngonda e makko, o nula ɗum'en mbaajowoo, ");
INSERT INTO fuhbkf_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","wooɗi o hokka ɗum'en baawɗe riiwude ginnaaji. ");
INSERT INTO fuhbkf_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Inan inɗe sappo e ɗiɗo ɓe o suɓii ɓeen: Simon mo o innditiri Piyeer ");
INSERT INTO fuhbkf_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","e Yaakuuba e minyum bi'eteeɗo Yuhanna, ɓiɓɓe Jebede ɓe o innditiri Bowanerges ɓeen, (maanaa majjum woni «Ɓiɓɓe Riggaango»), ");
INSERT INTO fuhbkf_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","kam e Andire e Filipu e Bartolome e Matta e Tomaa e Yaakuuba ɓii Alfaa e Tadde e Simon kiranoowo suudu baaba ");
INSERT INTO fuhbkf_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","e Yahuuda Isikariyotto jambotooɗo mo oon. ");
INSERT INTO fuhbkf_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Caggal ɗuum, o hooti. Jamaa hawriti dow makko katin faa kanko e taalibaaɓe makko ɓe kunngii heɓude no ɓe nyaamira. ");
INSERT INTO fuhbkf_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Nde sakiraaɓe makko nannoo ɗum ndeen, ngarani mo, sabo wi'aama hoore makko waylitake. ");
INSERT INTO fuhbkf_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Jannginooɓe Tawreeta ƴuurnooɓe Urusaliima ngari, mbi'i: —Beeljebul, hooreejo ginnaaji oon woni e makko. Wo kam hokki mo baawɗe riiwude ginnaaji ɗiin. ");
INSERT INTO fuhbkf_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","De Iisaa noddi ɓe ɓe ngara to muuɗum, banndani ɓe, wi'i: —Noy Seyɗaani waawirta riiwude hoore muuɗum? ");
INSERT INTO fuhbkf_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Si laamu feccake ina habda fu, laamu nguun waawataa heddaade. ");
INSERT INTO fuhbkf_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Katin du si galle feccake ina habda fu, galle oon waawataa heddaade. ");
INSERT INTO fuhbkf_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ndelle, si Seyɗaani feccake ina haɓa e hoore mum fu, waawataa heddaade, wo ɗum timmoode muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Iisaa jokkintini wi'i: —Fay gooto waawaa naatude ley galle gorko jom semmbe de hooƴa jawdi muuɗum. Sanaa artoo haɓɓa joomum tafon, ndeen ina waawi hooƴude ko woni ley suudu muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Goonga kaalanammi on: yimɓe ina mbaawi yaafeede hakkeeji muɓɓen fuu e mbonkaaji ɗi ɓe mbonkii Laamɗo fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Kaa mbonkiiɗo Ruuhu Ceniiɗo oon yaafataake abada. Hakke joomum heddoto dow muuɗum faa abada. ");
INSERT INTO fuhbkf_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Iisaa wi'irii noon saabe ko ɓe mbi'i imo wondi e ginnaaru ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Inna Iisaa e minyiraaɓe Iisaa worɓe ngari, ndarii yaasin suudu ɗoon, de neli o noddee. ");
INSERT INTO fuhbkf_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ɗo jamaa oon fiilii mo ɗoon, ɓe mbi'i mo: —Inna maa e minyiraaɓe maa na ngoni yaasin, ina kaajaa ma. ");
INSERT INTO fuhbkf_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","O jaabii, o wi'i: —Moy woni inna am e minyiraaɓe am? ");
INSERT INTO fuhbkf_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","O ndaari jooɗiiɓe ina piilii mo ɓeen, o wi'i: —Inan inna am e minyiraaɓe am. ");
INSERT INTO fuhbkf_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Sabo gaɗoowo muuyɗe Laamɗo, kam woni minyam gorko naa minyam debbo naa inna am. ");
INSERT INTO fuhbkf_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Iisaa ina waajoo hunnduko maayo ngoon katin. Jamaa keewɗo fiilii mo faa o naati laana ndiyam, o jooɗii ley makka. Jamaa oon fuu ina woni hunnduko maayo ngoon. ");
INSERT INTO fuhbkf_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Imo waajoroo ɓe e banndi keewɗi, imo wi'a ɓe: ");
INSERT INTO fuhbkf_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Kettindee! Aawoowo yalti faa saaka aawdi. ");
INSERT INTO fuhbkf_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","E ley aawugol ngool, aawdi ngondi saami e laawol, de pooli ngari cuɓi ndi. ");
INSERT INTO fuhbkf_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Yoga mayri saami e korokaaƴe ɗo leydi heewaa, ndi fuɗi law, sabo leydi ndiin ɗuuɗaa. ");
INSERT INTO fuhbkf_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ammaa nde naange wulnoo fu, ndi ɗayli, ndi yoori sabo ndi waɗaay ɗaɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Yoga mayri saami ɗo kebbe puɗata. Kebbe ɗeen mawni, ɓilli ndi, ndi rimaay. ");
INSERT INTO fuhbkf_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Yoga mayri saami e leydi lobbiri, fuɗi, mawni, rimi: yoga ɓeydake kile capanɗe tati, yoga capanɗe jeegom, yoga hemre. ");
INSERT INTO fuhbkf_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Caggal ɗuum, o wi'i: —Jom nowru nanooru fuu, nana! ");
INSERT INTO fuhbkf_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Nde Iisaa toowtunoo yimɓe ɓeen fu, taalibaaɓe sappo e ɗiɗo ɓeen e yimɓe fiiliiɓe mo ɓeen ƴami mo e dow banndi ɗiin. ");
INSERT INTO fuhbkf_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","O wi'i ɓe: —Onon, on kokkaama faamude ko suuɗii e kabaaru laamu Laamɗo. De wonɓe yaasin ɓeen, huunde fuu sanaa mbanndanee. ");
INSERT INTO fuhbkf_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ɗum waɗi de: «ina ndaara faa wooɗa tawa nji'ataa, ina nana faa laaɓa tawa paamataa, faa taa ɓe tuuba de ɓe njaafee.» ");
INSERT INTO fuhbkf_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","O wi'i ɓe: —On paamaay banndol ngol naa? Noy paamirton banndi goɗɗi ɗiin fuu ndelle? ");
INSERT INTO fuhbkf_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Aawoowo oon wo konngol Laamɗo aawata. ");
INSERT INTO fuhbkf_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Aawdi caamundi sera laawol ndiin wo nanɓe konngol ngool, de wakkati oon fu Seyɗaani wara, itta ko aawaa e maɓɓe ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Aawaandi dow korokaaƴe ndiin woni nanɓe ngol, de njaɓɓorii ngol seyo wakkati gooto. ");
INSERT INTO fuhbkf_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ammaa ngol walaa ɗaɗi e maɓɓe, wakkati seeɗa tan ngol wonata e maɓɓe. Nde ɓillaare naa torra hewti ɓe saabe konngol ngool fu, ɓe njoppan ngol wakkati gooto. ");
INSERT INTO fuhbkf_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Aawaandi ley kebbe ndiin woni nanɓe ngol, ");
INSERT INTO fuhbkf_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ammaa kaɓɓu-ko'u adunaaru e eytugol jawdi, kam e muuyɗe yonki goɗɗe naatan ɓe, ɓilla ngol, ngol laatoo dimarol. ");
INSERT INTO fuhbkf_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Kaa ɗo aawdi ndiin saami e leydi lobbiri ɗoon, ɓeen ngoni nanooɓe konngol ngool de njaɓa ngol. Ɓe ndiman: yoga sowoo kile capanɗe tati, yoga capanɗe jeegom, yoga hemre. ");
INSERT INTO fuhbkf_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Caggal ɗuum, Iisaa wi'i ɓe: —Yalla won fuu kuɓɓoowo lampal de hippa ɗum kaakol, naa soorna ɗum ley leeso naa? Wanaa ɓilan ngal naa? ");
INSERT INTO fuhbkf_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Walaa fuu ko suuɗii ko funtintaake, walaa ko waɗiraa suuraare ko wurtintaake yaasin. ");
INSERT INTO fuhbkf_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Jom nowru nanooru fuu nana! ");
INSERT INTO fuhbkf_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","O wi'i ɓe katin: —Tinnee e no nanirton haalaaji am ɗi! Sabo ko etiranton woɓɓe, wo ɗuum etiranteɗon, wooɗi on ɓeydante du. ");
INSERT INTO fuhbkf_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Sabo neɗɗo fuu jogiiɗo paamal dow laamu Laamɗo ɓeydante. Ammaa mo walaa paamal oon, fay seeɗa ko jogii ɗuum teetete. ");
INSERT INTO fuhbkf_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","O wi'i katin: —Laamu Laamɗo ina wa'i hono neɗɗo caakuɗo aawdi e ngesa muuɗum ni. ");
INSERT INTO fuhbkf_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ɓaawo ɗum, imo ɗaanoo jemma imo ummoo nyalooma, no laatorii fuu aawdi ndiin fuɗan, mawna, tawa joomum anndaa no ndi mawniri. ");
INSERT INTO fuhbkf_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Leydi ndiin fuɗinta aawdi ndiin, ndi waɗa gulle, wutaandu jokka, de caggal ɗuum, wutaandu nduun waɗa gabbe. ");
INSERT INTO fuhbkf_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Si ko aawaa ɗuum ɓenndii, taƴee, sabo wakkati muuɗum yottake. ");
INSERT INTO fuhbkf_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","O jokkintini o wi'i: —Ɗume nanndinten e laamu Laamɗo? Banndol ngole mbanndirten ngu? ");
INSERT INTO fuhbkf_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Laamu Laamɗo ina nanndi e gabbel lekki mutaari. Kam ɓuri gabbe fuu famɗude. ");
INSERT INTO fuhbkf_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","De si ngel aawaama fu, ngel mawnan faa ngel ɓura leɗɗe sardiŋe fuu. Ki waɗan licce mawɗe ɗe ɗowki faa pooli mbaawa nyiɓude cuuɗi muɓɓen e majje. ");
INSERT INTO fuhbkf_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Iisaa waajorake yimɓe ɓeen konngol Laamɗo ngool e banndi keewɗi gaaɗi noon, haddi ko ɓe mbaawi faamude. ");
INSERT INTO fuhbkf_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Walaa fuu ko o haalani ɓe si wanaa e banndol. Ammaa nde o toowtidi e taalibaaɓe makko ɓeen fuu, imo fiirtana ɗum'en banndi ɗiin fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Kiiral naange nyalooma oon, Iisaa wi'i taalibaaɓe muuɗum ɓeen: —En peƴƴita, keedowen gere ooto maayo. ");
INSERT INTO fuhbkf_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ɓe njoppi jamaa oon, ɓe tawti mo e laana ka o wonnoo e muuɗum kaan, ɓe ndunnyi. Laanaaji goɗɗi du ina njokki mo. ");
INSERT INTO fuhbkf_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Henndu sattundu ummii, bempeƴƴe ummii ina piya laana kaan, faa ka hesi heewude ndiyam. ");
INSERT INTO fuhbkf_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Iisaa ina ɗaanii gaɗa laana toon, imo wawlii wawlaare. Ɓe pindini mo, ɓe mbi'i mo: —Moodibbo, a hillaaka ko min kalkata ɗum naa? ");
INSERT INTO fuhbkf_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","O ummii, o sappani henndu nduun e semmbe, o wi'i maayo ngoon: —Deƴƴina! Dara! Henndu nduun deƴƴinii, fuu waɗi siw. ");
INSERT INTO fuhbkf_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Caggal ɗuum, o wi'i ɓe: —Ko waɗi de kulɗon? Faa hannden on ngalaa hoolaare naa? ");
INSERT INTO fuhbkf_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ɓe kuli kulol cattungol, heddii iɓe mbi'undura: —O wo moy de fay henndu e ndiyam ina ɗowtanoo ɗum? ");
INSERT INTO fuhbkf_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Caggal ɗuum, ɓe njottii gere ooto maayo ngoon, to leydi Gerasa'en. ");
INSERT INTO fuhbkf_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Nde Iisaa wurtinoo laana kaan ndeen, gonduɗo e ginnaaru ƴuuri ley caabeeje, hawri e makko. ");
INSERT INTO fuhbkf_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ley caabeeje ɗeen o jooɗinoo. Fay gooto waawaa haɓɓude mo, sabo fay callali kaɓɓataa mo. ");
INSERT INTO fuhbkf_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Sabo imo woownoo geƴƴireede geƴƴelle e callali, ammaa imo taƴa callali ɗiin, imo hela geƴƴelle ɗeen. Fay gooto du semmbem hewtaay faa nannga mo. ");
INSERT INTO fuhbkf_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Nyannde fuu, jemma e nyalooma ley caabeeje e baamle o woni, imo wulla imo seekitoroo kaaƴe. ");
INSERT INTO fuhbkf_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Nde o haccinoo Iisaa faa to woɗɗi ndeen, o doggiri to muuɗum, o sujidani ɗum, ");
INSERT INTO fuhbkf_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","o wulli faa toowi, o wi'i: —Iisaa Ɓii Laamɗo Toowɗo, ɗume njiɗɗaa waɗude kam? Hunanam saabe Laamɗo, a torrataa kam! ");
INSERT INTO fuhbkf_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","O wi'ii noon sabo Iisaa wi'unoo mo: —Aan ginnaaru, yaltu e makko. ");
INSERT INTO fuhbkf_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Iisaa ƴami mo, wi'i: —Noy mbi'eteɗaa? Ndu jaabii, ndu wi'i: —Jamaa mbi'eteemi, sabo miɗen keewi. ");
INSERT INTO fuhbkf_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ndu nyaagii Iisaa sanne, taa wurtina ɗi leydi ndiin. ");
INSERT INTO fuhbkf_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Coggal girooji manngal ina dura ɗoon e dow waamnde. ");
INSERT INTO fuhbkf_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ginnaaji ɗiin ŋaarii mo o acca ɗum'en naata e ley girooji ɗiin. ");
INSERT INTO fuhbkf_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","O jaɓani ɗi. Ginnaaji ɗiin njalti, naati e girooji ɗiin. Coggal ngaal fuu doggi, tellitii dow waamnde ndeen, saami ley maayo ngoon, yoolii. Iɗi ngaɗa hono ujunaaje ɗiɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Durooɓe ɓeen ndoggi kaalanowi ɗum yimɓe ngalluure ndeen e seraaji mum. Yimɓe ɓeen njehi faa ndaarowa ko waɗi ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Nde ɓe ngarnoo to Iisaa ndeen, ɓe nji'i gorko gondunooɗo e ginnaaji oon ina jooɗii ina ɓornii kaddule, hakkillo muuɗum du wartii. De kulol nanngi ɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Yiinooɓe ɗum ɓeen kaalani ɓe ko hewtinoo gondunooɗo e ginnaaji oon e girooji ɗiin. ");
INSERT INTO fuhbkf_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ndeen ɓe puɗɗi nyaagaade Iisaa dillana ɓe leydi maɓɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Nde o naatannoo laana kaan ndeen, gondunooɗo e ginnaaji oon nyaagii mo o acca ɗum jokka mo. ");
INSERT INTO fuhbkf_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","O salanii oon, o wi'i ɗum: —Hootu suudu maa to koreeji maa, kaalanaa ɓe ko Joomiraaɗo waɗani ma e no o yurmorii ma. ");
INSERT INTO fuhbkf_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","O yehi imo gooyna e leydi mbi'eteendi Galluuje Sappo ndiin ko Iisaa waɗani mo. Ɓe fuu ɗum haaynii ɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Nde Iisaa naatunoo laana yeccii gere ooto maayo ndeen, jamaa keewɗo fiilii ɗum katin ɗakkol maayo ɗoon. ");
INSERT INTO fuhbkf_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ndeen gooto e hooreeɓe suudu waajordu bi'eteeɗo Jayrus wari, yi'i Iisaa tan, hippii e koyɗe muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","O nyaagii ɗum o haali faa heewi, o wi'i: —Ɓiyam debbo ina habda e yonki. War yowu junngo maa dow makko, faa o daɗa, o wuura! ");
INSERT INTO fuhbkf_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Iisaa yaadi e makko. Jamaa keewɗo jokki ɗum faa ina ɓilla ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ina woodi ɗoon debbo mo ƴiiƴam muuɗum taccataa ko waɗata duuɓi sappo e ɗiɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","O tampii sanne, o yehii to sawrooɓe heewɓe faa jawdi makko timmi. Ɗum fuu samtanaay mo, nyawu nguun ɓeydoto tan. ");
INSERT INTO fuhbkf_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","O nani haala Iisaa ina haalee, o naati e jamaa oon. Imo miiloo si o heɓii o meemii saaya muuɗum tan o daɗan. O ƴuuri gaɗa Iisaa, o meemi saaya muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Wakkati oon ƴiiƴam makko darii, de o maati e terɗe makko o daɗii. ");
INSERT INTO fuhbkf_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Wakkati oon fu, Iisaa du maati won baawɗe ƴuuruɗe e muuɗum, yeeƴii hakkunde jamaa oon, wi'i: —Moy meemi saaya am? ");
INSERT INTO fuhbkf_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Taalibaaɓe makko ɓeen mbi'i mo: —A yi'ii inan jamaa ina ɓilli ma, de aɗa ƴama moy meemi ma? ");
INSERT INTO fuhbkf_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Kaa imo ƴeewa gereeji fuu, faa o yi'a meemuɗo mo oon. ");
INSERT INTO fuhbkf_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Debbo oon ina diwna no foti hulude sabo ina anndi ko waɗi, wari, hippii yeeso makko, haalani mo goonga. ");
INSERT INTO fuhbkf_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Iisaa wi'i mo: —Banndam debbo, goonɗinal maa dannii ma. Yahu e jam! A daɗii e nyawu maa! ");
INSERT INTO fuhbkf_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","O tilaaki haalde, faa woɓɓe ƴuuruɓe to suudu Jayrus hooreejo waajordu oon mbi'i ɗum: —Ɓiya heddaaki. Haanaa tampinaa Moodibbo o katin! ");
INSERT INTO fuhbkf_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Kaa Iisaa hiisaaki haala maɓɓe, wi'i Jayrus: —Taa hulu, goonɗin tan! ");
INSERT INTO fuhbkf_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","O accaay fay gooto yaada e makko si wanaa Piyeer e Yaakuuba e Yuhanna minyoo Yaakuuba oon. ");
INSERT INTO fuhbkf_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ɓe njottii suudu hooreejo waajordu oon. O tawi ɗoon jamaa, yimɓe ina mboya, ina mbulla semmbe. ");
INSERT INTO fuhbkf_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Nde o naatunoo ndeen, o wi'i ɓe: —Ɗume woni bojji ɗi e duko ko? Suka o maayaay, wo o ɗaani tan. ");
INSERT INTO fuhbkf_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ɓe njalnorii haala makko. Ndeen o wurtini ɓe fuu, o hooƴi baaba suka oon e inna muuɗum e taalibaaɓe makko tato ɓe o wondi, ɓe naati suudu to suka oon tawaa toon. ");
INSERT INTO fuhbkf_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","O nanngi junngo mum, o wi'i: — Talita kuumii! (Ɗum na fiirta «Suka debbo, umma!») ");
INSERT INTO fuhbkf_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Wakkati oon fu suka oon ummii, ina yaha. Duuɓi makko wo sappo e ɗiɗi. Ɗum haaynii yimɓe ɓeen sanne. ");
INSERT INTO fuhbkf_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Iisaa tindini ɓe sanne taa ɓe paamina ɗum fay gooto. O wi'i ɓe kokka suka oon ko nyaametee. ");
INSERT INTO fuhbkf_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Iisaa dilli nokku oon, hooti wuro ngo mawni ngoon. Taalibaaɓe muuɗum njokki ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Nde nyalaande fowteteende yottinoo ndeen, o fuɗɗi waajaade ley suudu waajordu nduun. Nanɓe waaju makko ɓeen, ɗum haaynii ɗum'en, heddii ina mbi'a: —Toy o heɓi ɗum? Noy o heɓiri hakkillo ngo? Ndaar! Noy neɗɗo waawiri waɗirde kaayeefiiji ɗi? ");
INSERT INTO fuhbkf_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Yalla wanaa kanko woni cehoowo leɗɗe, ɓii Mariyama naa? Wanaa o mawnoo Yaakuuba e Yuusufi e Yahuuda e Simon? Wanaa enen e banndiraaɓe makko rewɓe koddi naa? Ɗum saabanii ɓe salaade mo. ");
INSERT INTO fuhbkf_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Wakkati oon, o wi'i ɓe: —Annabaajo ina teddinee e nokku fuu si wanaa e ley wuro muuɗum e hakkunde rimdaaɓe muuɗum e ley suudu mum. ");
INSERT INTO fuhbkf_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Iisaa heɓaay waɗude ɗoon fay kaayeefi gooto, si wanaa ko yowi junngo muuɗum e nyawɓe seeɗa, danni ɗum'en. ");
INSERT INTO fuhbkf_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","De ko ɓe ngoonɗinaay mo ɗuum haaynake mo. Caggal ɗuum, Iisaa yiiltii e gure piiliiɗe ɗoon ɗeen, ina waajoo. ");
INSERT INTO fuhbkf_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","O noddi taalibaaɓe sappo e ɗiɗo ɓeen, o nuliri ɗum'en ɗiɗo ɗiɗo. O hokki ɓe baawɗe riiwude ginnaaji, ");
INSERT INTO fuhbkf_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","o wi'i ɓe taa ɓe njaada e fay huunde si wanaa cabbi. Taa ɓe kooƴa buuru naa mbasu naa kaalisi e ley njiibaaji maɓɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","O yamiri ɓe ɓe ɓornoo paɗe, de taa ɓe kooƴa saayaaji ɗiɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","O wi'i ɓe katin: —Galle fuu mo njippiɗon, keddoɗon ɗoon faa nde ndilloton e nokku oon. ");
INSERT INTO fuhbkf_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Si on ngarii e nokkuure de yimɓe njaɓɓaaki on naa kettindanaaki on, ndillon toon, piɗɗon sollaare maɓɓe wonnde e koyɗe mon faa laatanoo ɓe seedee e dow bonanda maɓɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ɓe njehi, ɓe mbaajii yimɓe ɓeen tuuba, ");
INSERT INTO fuhbkf_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","ɓe ndiiwi ginnaaji keewɗi, ɓe ngatti nebbam dow ko'e nyawɓe heewɓe ɓe cellini ɗum'en. ");
INSERT INTO fuhbkf_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Hirudus, kaananke oon, nani haala Iisaa ina haalee, sabo innde Iisaa sankitake faa yaaji. Woɓɓe ina mbi'a wo o Yaayaa lootoowo lootagal batisima oon ummitii e maayde, ɗuum waɗi de imo jogii baawɗe waɗude kaayeefiiji. ");
INSERT INTO fuhbkf_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Woɓɓe ina mbi'a wo o annabi Iliyaasa. Woɓɓe du ina mbi'a wo o annabaajo hono annabaaɓe arandeeɓe ɓeen ni. ");
INSERT INTO fuhbkf_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Nde Hirudus nannoo ɗum ndeen, wi'i: —Yaayaa mo taƴunoomi hoore mum oon, kam iirtii! ");
INSERT INTO fuhbkf_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Tawi Hirudus yamiriino Yaayaa nanngee, haɓɓee, uddee ley kasu. O waɗii ɗum saabe Hirudiya jom suudu mawniiko bi'eteeɗo Filipu mo o ɓaŋunoo oon. ");
INSERT INTO fuhbkf_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Sabo Yaayaa ina wi'annoo mo: —Daganaaki ma teetaa jom suudu mawna. ");
INSERT INTO fuhbkf_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Hirudiya mettaa e Yaayaa faa ina yiɗi o waree, de heɓaay laawol, ");
INSERT INTO fuhbkf_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","sabo Hirudus ina hulannoo Yaayaa, ina anndunoo o gorko ponnditiiɗo, ceniiɗo. Ɗum waɗi de imo haybannoo ɗum. Si o hettindake haala muuɗum fu, hakkillo makko jiiɓoto, wooɗi du imo yiɗi hettindanaade ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ammaa, Hirudiya heɓi laawol warude mo nyannde rimeede Hirudus wartunoo. Hirudus waɗani howruuɓe muuɗum e hooreeɓe sordaasiiɓe ɓeen e inndee-anndee'en Galili ɓeen fuu hiraande mawnde. ");
INSERT INTO fuhbkf_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ɓii Hirudiya debbo naati ina wama. Ɗum weli Hirudus e jooɗodiiɓe e muuɗum fuu. O wi'i suka debbo oon: —Haalanam ko njiɗɗaa faa mi waɗane. ");
INSERT INTO fuhbkf_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","O hunanii ɗum, o wi'i o hokkan ɗum huunde fuu ko nyaagii mo, fay si tawi wo feccere laamu makko. ");
INSERT INTO fuhbkf_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","De suka debbo oon yalti, wi'i inna muuɗum: —Ɗume kaanumi nyaagaade mo? Inniiko oon jaabii mo, wi'i: —Nyaaga mo hoore Yaayaa lootoowo lootagal batisima oon! ");
INSERT INTO fuhbkf_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Suka debbo oon henyii, yeccii to kaananke oon, nyaagii ɗum, wi'i: —Ko njiɗumi, ngaddanaa kam joonin joonin wo hoore Yaayaa lootoowo lootagal batisima oon e ley le'al! ");
INSERT INTO fuhbkf_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ɓernde Hirudus metti sanne. Ammaa saabe ko hunii ɗuum e saabe noddaaɓe ɓeen, o yiɗaa yaltude e konngol makko ngool. ");
INSERT INTO fuhbkf_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Wakkati oon o neli gooto e sordaasiiɓe doomooɓe mo ɓeen, o yamiri ɗum waddowa hoore Yaayaa. Sordaasi oon yeccii, naati ley kasu toon, taƴi hoore Yaayaa, ");
INSERT INTO fuhbkf_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","tummbi ley le'al, waddi, hokki suka debbo oon. Suka debbo oon du hokki inna mum. ");
INSERT INTO fuhbkf_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Nde taalibaaɓe Yaayaa ɓeen nannoo ɗum ndeen, ngari kooƴi ɓanndu makko nduun, ngattowi ɗum e saabeere. ");
INSERT INTO fuhbkf_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Nulaaɓe ɓeen ngarti to Iisaa, kaalani ɗum ko ngaɗi ɗuum e ko mbaajii ɗuum fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","O wi'i ɓe: —En njaha nokkuure ferwunde, keɓon fowtinaade seeɗa. Ko o wi'i noon ɗuum wo saabe yaha-warta yimɓe na heewi ɗoon, faa kanko e taalibaaɓe makko ɓeen, ɓe kunngii heɓude fay no ɓe nyaamira. ");
INSERT INTO fuhbkf_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ɓe njehi ɓe naatowi laana, ɓe peƴƴiti, ɓe toowti kamɓe tan e nokku perwuɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Yimɓe heewɓe nji'ii iɓe njaha, annditi to ɓe ponndii. Heewɓe ƴuuri e gure ɗeen fuu, kenyanii to ɓe ponndii toon, arti ɓe yottaade. ");
INSERT INTO fuhbkf_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Nde o yaltunoo e laana kaan ndeen, o yi'i jamaa keewɗo. O yurmii ɓe sanne, sabo iɓe nga'i hono no baali ɗi ngalaa duroowo ni. O heddii imo waajoo ɓe kulle keewɗe. ");
INSERT INTO fuhbkf_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Nde hiirunoo ndeen, taalibaaɓe ɓeen ɓattitii mo, mbi'i: —Joonin hiirii, katin du nokku o wo ladde ɓolde. ");
INSERT INTO fuhbkf_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Mbi'aa jamaa o sankitoo e gure e nokkuuje ɓadiiɗe ɗo faa coodowa ko nyaama. ");
INSERT INTO fuhbkf_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","O jaabii ɓe, o wi'i: —Onon e ko'e mooɗon, kokkee ɓe ko ɓe nyaama! Ndeen ɓe ƴami mo, ɓe mbi'i: —Ndelle aɗa yiɗi min kooƴa buuɗi cardi keme ɗiɗi min coodanowa ɓe buuru ko ɓe nyaama? ");
INSERT INTO fuhbkf_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Wakkati oon, o wi'i ɓe: —Noy foti buuruuje ɗe njogiɗon? Njehee ndaarowee! Nde ɓe njahunoo ɓe kumpitowii ndeen, ɓe mbi'i mo: —Buuruuje joy e liƴƴi ɗiɗi min njogii. ");
INSERT INTO fuhbkf_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","O yamiri taalibaaɓe ɓeen njoƴƴinira jamaa oon feere feere dow huɗo hecco. ");
INSERT INTO fuhbkf_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ɓe njooɗorii feere feere, hemre hemre, e capanɗe njoyo njoyo. ");
INSERT INTO fuhbkf_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","O hooƴi buuruuje joy ɗeen e liƴƴi ɗiɗi ɗiin, o tiggitii kammu, o yetti Laamɗo. O heltii buuru oon, o hokki taalibaaɓe makko peccana yimɓe ɓeen. Hono noon liƴƴi ɗiɗi ɗiin du. ");
INSERT INTO fuhbkf_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ɓe fuu ɓe nyaami faa ɓe kaari. ");
INSERT INTO fuhbkf_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Taalibaaɓe ɓeen kawrunduri kedde buuru e liƴƴi ɗeen, kebbini kandeeje sappo e ɗiɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Nyaamuɓe buuru oon ɓeen, fay worɓe tan ngaɗii hono ujunaaje njoyo. ");
INSERT INTO fuhbkf_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Wakkati oon fu, Iisaa yamiri taalibaaɓe muuɗum naata laana kaan, ardoo ɗum peƴƴita njaha Baytisayda gere ooto maayo ngoon. Kanko du, o waynoo jamaa oon tafon. ");
INSERT INTO fuhbkf_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Nde o seedunoo e jamaa oon ndeen, o ƴeeŋowi dow waamnde faa o waɗa du'aare. ");
INSERT INTO fuhbkf_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Nde jemma warnoo ndeen, tawi laana kaan ina woni hakkunde maayo toon, Iisaa tan heddii e leydi. ");
INSERT INTO fuhbkf_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","O sooynii taalibaaɓe ɓeen ina cummba ko mbaawi fuu, sabo wo ɓe hawrooɓe e henndu. Nde ɓadinoo weetude ndeen, o wari to maɓɓe imo yaha e koyɗe dow ndiyam ɗaam, faa o hesi faltaade ɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Kaa nde ɓe njiinoo mo imo yaha e dow ndiyam ɗaam ndeen, ɓe cikki wo ɗum mbeelu, ɓe keddii iɓe mbaayda, ");
INSERT INTO fuhbkf_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","sabo ɓe fuu, nde ɓe njiinoo mo ndeen, nesiiji maɓɓe taƴi. Wakkati oon Iisaa wi'i ɓe: —Cellinee ɓerɗe mon! Wo miin. Taa kulee! ");
INSERT INTO fuhbkf_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","O naati laana kaan, o tawti ɓe, de henndu nduun darii. Ɗum haaynii ɓe sanne. ");
INSERT INTO fuhbkf_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ɓe paamaayno haaynde nde Iisaa waɗiri buuru oon ndeen, sabo ɓe wumɓe ɓerɗe. ");
INSERT INTO fuhbkf_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ɓe peƴƴiti maayo ngoon, ɓe njottii leydi Genesaret, ɓe ndarii ɗoon. ");
INSERT INTO fuhbkf_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Wakkati ɓe njalti e laana kaan ndeen, yimɓe ɓeen annditi mo, ");
INSERT INTO fuhbkf_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","cankitii e seraaji ɗiin fuu, ina njowa nyawɓe muɓɓen e dow daɗɗooji, ina ngadda nokku fuu ɗo nani imo woni. ");
INSERT INTO fuhbkf_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Katin du ɗo Iisaa tawaa fuu, gilla e ley gure faa e galluuje faa e ladde, yimɓe ɓeen ngaddan nyawɓe muɓɓen e taliyaaje, ina ŋaaroo mo o acca ɓe meema fay si wo kommbol saaya makko. Meemuɗo ngol du fuu daɗii. ");
INSERT INTO fuhbkf_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Farisa'en e jannginooɓe Tawreeta woɓɓe ƴuuruɓe Urusaliima piilii Iisaa. ");
INSERT INTO fuhbkf_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ɓe nji'i taalibaaɓe makko woɓɓe ina nyaamira juuɗe tuunɗe, ɗum woni tawa lootiraay no tawaangal maɓɓe worri ni. ");
INSERT INTO fuhbkf_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Sabo Farisa'en e Alhuudiyankooɓe fuu nyaamataa si lootaay juuɗe muɓɓen faa laaɓa, al'aada maamiraaɓe maɓɓe oon ɓe njokki. ");
INSERT INTO fuhbkf_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Si ɓe ngartii luumo, ɓe nyaamataa si ɓe lootaaki. Iɓe njogii al'aadaaji goɗɗi keewɗi ɗi ɓe njokki, ko wa'i hono lawƴude kore e potiije e taasaaje gaɗiraaɗe njamndi. ");
INSERT INTO fuhbkf_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Wakkati oon, Farisa'en e jannginooɓe Tawreeta ƴami Iisaa, mbi'i: —Ɗume waɗi de taalibaaɓe maa ɓeen ndewataa al'aadaaji maamiraaɓe meeɗen, ina nyaamira juuɗe tuunɗe? ");
INSERT INTO fuhbkf_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","O jaabii ɓe, o wi'i: —Annabi Esaaya woofaay fey nde sappinoo on. Wo on munaafiki'en, hono no winndiraa: «Lenyol ngol ina teddina kam e kunnduɗe muɓɓen, ammaa ɓerɗe muɓɓen ina mboɗɗii kam. ");
INSERT INTO fuhbkf_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ɓolum ɓe ndewata kam. Si goonga, janndeeji ɗi ɓe njannginta ɗiin wo jamirooje yimɓe tan.» ");
INSERT INTO fuhbkf_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Iisaa jokkintini, wi'i: —Oɗon acca jamirooje Laamɗo, de oɗon njokka al'aadaaji yimɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Oɗon calanoo yamiroore Laamɗo faa laaɓa, faa keɓon ndarnon al'aada mooɗon! ");
INSERT INTO fuhbkf_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Sabo Muusaa wi'i: «Teddin bammaa e inna maa.» O wi'i katin: «Kuɗuɗo bammum naa inna mum, wareede laatoo jukkungo muuɗum.» ");
INSERT INTO fuhbkf_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","De onon le, oɗon mbi'a ina heƴa si neɗɗo wi'ii bammum naa inna mum: «Ko kaannoomi wallirde ma ɗuum wo Korbaan» (Korbaan ina fiirta «Sadaka Laamɗo»). ");
INSERT INTO fuhbkf_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ko mbi'oton noon ɗuum, oɗon kaɗa yimɓe wallude baabiraaɓe muɓɓen naa inniraaɓe muɓɓen katin. ");
INSERT INTO fuhbkf_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Hono noon tosirton konngol Laamɗo e al'aadaaji ɗi ndonundurton ɗiin. Katin du oɗon ngaɗa kulle keewɗe gaaɗe noon. ");
INSERT INTO fuhbkf_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Caggal ɗuum, Iisaa nodditi jamaa oon, wi'i ɗum: —Kettindanee kam, on fuu, paamee: ");
INSERT INTO fuhbkf_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Fay huunde naatataa e neɗɗo de tuunina ɗum. De wo ko ƴuurata ley neɗɗo ɗuum tuuninta ɗum.  ");
INSERT INTO fuhbkf_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Nde Iisaa seedunoo e jamaa oon de naatowi ley suudu ndeen, taalibaaɓe muuɗum ɓeen ƴami ɗum maanaa banndol ngol. ");
INSERT INTO fuhbkf_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","O wi'i ɓe: —Onon du, on paamaay naa? On paamaay ko ƴuurata yaasin de naata e hunnduko neɗɗo ɗuum, wanaa ɗuum tuuninta joomum? ");
INSERT INTO fuhbkf_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Sabo ɗum naataay e ɓernde joomum. Wo reedu mum tan ɗum naati, wooɗi du ɗum yaltan. E haalaaji ɗiin Iisaa holliri nyaamdu fuu na laaɓi. ");
INSERT INTO fuhbkf_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","O wi'i katin: —Ko wurtotoo e ley ɓernde neɗɗo ɗuum, wo kam tuuninta joomum. ");
INSERT INTO fuhbkf_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Sabo e ɓernde neɗɗo miilooji bonɗi ƴuurata, kam e fijirde e nguyka e war-hoore e ");
INSERT INTO fuhbkf_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","jeenu e eelgal e bonanda e jamba e golleeji terɗe cemtiniiɗi e muuyɗe bonɗe e mbonka e mawninkinaare e majjere. ");
INSERT INTO fuhbkf_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Kujje bonɗe ɗeen fuu e ɓernde ƴuurata, de tuunina neɗɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Iisaa dilli ɗoon fonndii leydi Tirus. O jippii e suudu gomma. O yiɗaa fay gooto faama toon o woni, ammaa o waawaano suuɗaade. ");
INSERT INTO fuhbkf_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Wakkati oon, debbo gomma mo ɓinngel muuɗum dewel wondi e ginnaaru, nani haala makko ina haalee, wari hippii ɗakkol koyɗe makko. ");
INSERT INTO fuhbkf_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Debbo oon wanaa Alhuudiyanke, wo to Finiki ley leydi Siiriya o rimaa. O nyaagii Iisaa itta ginnaaru nduun e ɓiyiiko oon. ");
INSERT INTO fuhbkf_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Kaa Iisaa wi'i mo: —Accu sukaaɓe ɓeen kaara tafon. Sabo hooƴude nyaamdu sukaaɓe de faɗɗana dawaaɗi wooɗaa. ");
INSERT INTO fuhbkf_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Debbo oon jaabii mo, wi'i: —Goonga Joomam, ammaa dawaaɗi doomooji du ina nyaama ko sukaaɓe caamdinta ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Wakkati oon, Iisaa wi'i mo: —Saabe ko njaabiɗaa jaabu o, hootu, ginnaaru nduun wurtake e ɓiya oon. ");
INSERT INTO fuhbkf_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","O hooti, o tawi ɓiyiiko oon ina fukkii dow leeso, ginnaaru nduun yaltii e muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Iisaa dilli leydi Tirus, rewi leydi Sidon, e leydi mbi'eteendi Galluuje Sappo ndiin, warti maayo Galili. ");
INSERT INTO fuhbkf_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","O waddanaa gorko paho mo haala muuɗum laaɓaa, o nyaagaa o yowa junngo makko e dow muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Wakkati oon, Iisaa toowtini mo jamaa oon, watti kolli muuɗum e noppi makko, tutti, meemiri tutte ɗeen ɗemngal makko. ");
INSERT INTO fuhbkf_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Caggal ɗuum, o tiggitii kammu, o uumi, o wi'i paho oon: — Efata! (Ɗum na fiirta «Cukkitee!») ");
INSERT INTO fuhbkf_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Wakkati oon, noppi gorko oon cukkitii, ɗemngal muuɗum yoppaa, heddii ina haalira no wooɗiri. ");
INSERT INTO fuhbkf_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Iisaa yamiri yimɓe ɓeen taa ɓe kaalana huunde nde fay gooto. Ammaa fay ko o haɗata ɓe dow majjum, iɓe ɓeyda haalde ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ɗum haaynii ɓe faa yottii kaaddi, iɓe mbi'a: —Golleeji makko fuu na mbooɗi. Imo faaɗintina faaɗuɓe, imo muumɗintina muumɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ley balɗe ɗeen, jamaa keewɗo hawriti katin. E ley ko ɓe ngalaa ko ɓe nyaama, Iisaa noddi taalibaaɓe muuɗum ɓeen, wi'i ɗum'en: ");
INSERT INTO fuhbkf_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Yimɓe ɓe ina njurminii kam, sabo hannden woni balɗe tati iɓe ngondi e am, de ɓe ngalaa ko ɓe nyaama. ");
INSERT INTO fuhbkf_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Si mi yoppii ɓe koota tawee ɓe nyaamaay, yolbere liɓowan ɓe dow laawol. Sabo woɓɓe maɓɓe ƴuurii to woɗɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Taalibaaɓe makko ɓeen njaabii mo, mbi'i: —Toy neɗɗo heɓata ko nyaamnata yimɓe ɓe ley ladde nde? ");
INSERT INTO fuhbkf_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","O ƴami taalibaaɓe makko ɓeen, o wi'i: —Noy foti buuruuje ɗe njogiɗon? Ɓe mbi'i mo: —Jeɗɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","De o yamiri jamaa oon jooɗoo e leydi. O hooƴi buuruuje jeɗɗi ɗeen, o yetti Laamɗo, o heltii ɗe, o hokki taalibaaɓe makko ɓeen peccana jamaa oon. Ɓe ngaɗiri noon. ");
INSERT INTO fuhbkf_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Iɓe njogii katin liƴƴoy pamaroy seeɗa. Iisaa yetti Laamɗo dow makkoy, wi'i taalibaaɓe muuɗum ɓeen pecca koy, kankoy du. ");
INSERT INTO fuhbkf_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ɓe nyaami faa ɓe kaari. Taalibaaɓe ɓeen kawrunduri kedde ɗeen. Ɗe keewi kandeeje jeɗɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Iɓe ngaɗa worɓe ujunaaje nayo. Caggal ɗuum, Iisaa yoppi ɓe, ");
INSERT INTO fuhbkf_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","naatidi e taalibaaɓe muuɗum laana wakkati oon, feƴƴiti, yehi leydi Dalmanuuta. ");
INSERT INTO fuhbkf_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Farisa'en ɓeen ngari, puɗɗi yeddundurde e Iisaa. Ɓe ŋaarii mo o holla ɓe maande ƴuuroore dow kammu faa ɓe ndaartindoo mo. ");
INSERT INTO fuhbkf_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Iisaa uumi, wi'i: —Ɗume waɗi de yimɓe jamaanu hannden o ina piloo holleede maande? Goonga kaalanammi on: fay maande wootere on keɓataa! ");
INSERT INTO fuhbkf_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Caggal ɗuum, o seedi e maɓɓe, o naati laana kaan, o fonndii gere ooto maayo. ");
INSERT INTO fuhbkf_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Taalibaaɓe ɓeen njeggiti yooɓaade buuru, si wanaa buuruwal gootal tan ɓe njogii ley laana kaan. ");
INSERT INTO fuhbkf_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Wakkati oon, o tindini ɓe, o wi'i: —Kakkilee, ndeentee e rabilla Farisa'en e mo Hirudus oon. ");
INSERT INTO fuhbkf_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Taalibaaɓe ɓeen ina kaalda ina mbi'a ko njooɓaaki buuru ɗuum waɗi de o wi'iri noon. ");
INSERT INTO fuhbkf_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Iisaa annditi ko ɓe kaalata ɗuum, wi'i ɓe: —Ko waɗi de oɗon kaalda hakkunde mooɗon on njooɓaaki buuru? Yalla faa joonin on annditaay, on paamaay? Naa on wumɓe ɓerɗe? ");
INSERT INTO fuhbkf_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Oɗon njogii gite, de on nji'ataa naa? Oɗon njogii noppi, de on nanataa naa? Yalla on miccitaaki ");
INSERT INTO fuhbkf_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","nde peccanmi worɓe ujunaaje njoyo buuruuje joy ndeen, kandeeje foti kebbinɗon kedde ɗeen? Ɓe njaabii mo, ɓe mbi'i: —Kandeeje sappo e ɗiɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","O ƴami ɓe katin, o wi'i: —Nde peccanmi worɓe ujunaaje nayo buuruuje jeɗɗi ndeen, kandeeje foti kebbinɗon kedde ɗeen? Ɓe njaabii mo, ɓe mbi'i: —Kandeeje jeɗɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ndeen o wi'i ɓe: —Faa joonin on paamaay naa? ");
INSERT INTO fuhbkf_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ɓe njottii Baytisayda. Ɗoon yimɓe ngaddani Iisaa bumɗo, ɓe nyaagii ɗum meema mo. ");
INSERT INTO fuhbkf_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","O nanngi junngo bumɗo oon, o yaari ɗum yaasin wuro ngoon. Caggal ɗuum, o tutti e gite muuɗum, o yowi juuɗe makko e muuɗum, o ƴami ɗum, o wi'i: —Won ko nji'ataa naa? ");
INSERT INTO fuhbkf_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Bumɗo oon feerti gite mum, wi'i: —Miɗo yi'a yimɓe, de iɓe nga'ani kam hono leɗɗe jahooje ni. ");
INSERT INTO fuhbkf_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Iisaa yowi juuɗe muuɗum e gite makko katin. Ndeen gorko oon feerti gite mum, tawi wumtii faa wooɗi, jiiɗe muuɗum na laaɓi. ");
INSERT INTO fuhbkf_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Iisaa wi'i mo: —Hootu, de taa njeccoɗaa ley wuro ngo. ");
INSERT INTO fuhbkf_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Caggal ɗuum, Iisaa e taalibaaɓe muuɗum ponndii gure gonɗe ɗakkol Kaysariya Filipu. Dow laawol ngool, o ƴami ɓe: —Moy yimɓe mbi'ata ngonumi? ");
INSERT INTO fuhbkf_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ɓe njaabii mo, ɓe mbi'i: —Woɓɓe ina mbi'a wo a Yaayaa lootoowo lootagal batisima. Woɓɓe ina mbi'a wo a annabi Iliyaasa. Woɓɓe du ina mbi'a wo a gooto e ley annabaaɓe ɓeen. ");
INSERT INTO fuhbkf_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","O ƴami ɓe, o wi'i: —Onon le, moy mbi'oton ngonumi? Piyeer jaabii mo, wi'i: —Wo a Almasiihu. ");
INSERT INTO fuhbkf_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Wakkati oon, o sappani ɓe sanne taa ɓe kaalana ɗum fay gooto. ");
INSERT INTO fuhbkf_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","O fuɗɗi faaminde ɓe: —Ina tilsi Ɓii Neɗɗo torree torraaji keewɗi. Mawɓe yimɓe e hooreeɓe almaami'en e jannginooɓe Tawreeta caloto mo. O warete, de gaɗa balɗe tati fuu o iirtoto. ");
INSERT INTO fuhbkf_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","O haalani ɓe ɗum faa laaɓi, de Piyeer toowtini mo, fuɗɗi felude mo dow haalaaji makko ɗiin. ");
INSERT INTO fuhbkf_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Iisaa kaa, hucciti e taalibaaɓe muuɗum, ndaari ɓe, de feli Piyeer, wi'i: —Woɗɗam aan Seyɗaani! Sabo miilooji maa ɗiin ƴuuraay to Laamɗo, wo to yimɓe ɗi ƴuuri. ");
INSERT INTO fuhbkf_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Caggal ɗuum, o noddi jamaa oon e taalibaaɓe makko ɓeen, o wi'i ɗum'en: —Muuyɗo jokkude kam fuu, sela ndaarude hoore muuɗum, de hooƴa leggal muuɗum palaangal, jokka kam. ");
INSERT INTO fuhbkf_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Sabo muuyɗo dannude yonki muuɗum, mursan ki. Ammaa mursuɗo ki saabe am e saabe Kabaaru Lobbo oon fu, dannan ki. ");
INSERT INTO fuhbkf_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ɗume heɓude adunaaru ndu fuu nafata neɗɗo si tawii mursii yonki muuɗum? ");
INSERT INTO fuhbkf_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Yalla ina woodi ko neɗɗo waawi hokkitirde faa danna yonki muuɗum naa? ");
INSERT INTO fuhbkf_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Cemtirɗo kam miin e haalaaji am e ley jamaanu tuunɗo luttuɗo Laamɗo o, miin, Ɓii Neɗɗo du, mi semtiran ɗum nde ngartidoymi e maleyka'en seniiɓe e ley teddeengal Baaba am. ");
INSERT INTO fuhbkf_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","O wi'i ɓe katin: —Goonga kaalanammi on: yoga e wonɓe ɗo ɓe maayataa tawee nji'aay laamu Laamɗo ina warda e baawɗe. ");
INSERT INTO fuhbkf_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Balɗe jeegom caggal ɗuum, Iisaa yaadi e Piyeer e Yaakuuba e Yuhanna, o toowtidi e muɓɓen dow waamnde toownde, kam'en tan. Ɗoon alhaali makko waylitii yeeso maɓɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Kaddule makko njalbi, ndawni far, faa dawninoowo fay gooto waawaa rawninirde noon e adunaaru ndu. ");
INSERT INTO fuhbkf_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Iliyaasa e Muusaa ɓangani ɓe, ina kaalda e makko. ");
INSERT INTO fuhbkf_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ndeen Piyeer wi'i mo: —Moodibbo, gonal amin ɗo ina wooɗi. Accu min ndarna hukumuuji tati: aan gooto, Muusaa gooto, Iliyaasa du gooto. ");
INSERT INTO fuhbkf_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","O anndaa ko o haalata, sabo kulol manngol naatii ɓe, kamɓe taalibaaɓe ɓeen. ");
INSERT INTO fuhbkf_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ruulde wari suddi ɓe. Daande ƴuuri e ley ruulde ndeen ina wi'a: —O woni Ɓiyam mo korsinmi. Kettindanee mo! ");
INSERT INTO fuhbkf_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Wakkati oon, taalibaaɓe ɓeen ƴeewi gereeji fuu, de nji'aay fay gooto si wanaa Iisaa tan. ");
INSERT INTO fuhbkf_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","E ley ko ɓe njippotoo waamnde ndeen ɗuum, o yamiri ɓe taa ɓe kaalana fay gooto ko ɓe nji'i ɗuum faa wakkati nde Ɓii Neɗɗo iirtii e hakkunde maayɓe ndeen. ");
INSERT INTO fuhbkf_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ɓe njaɓi konngol ngol, de ɓe keddii iɓe ƴamundura hakkunde maɓɓe ɗume woni maanaa iirtaade e hakkunde maayɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Caggal ɗuum, ɓe ƴami mo, ɓe mbi'i: —Ɗume waɗi de jannginooɓe Tawreeta ina mbi'a tilay annabi Iliyaasa artoo Almasiihu warude? ");
INSERT INTO fuhbkf_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","O jaabii ɓe: —Goonga, Iliyaasa artoto warude tafon moƴƴintinoo huunde fuu. Ndelle ko waɗi de Binndi ɗiin mbi'i ina tilsi Ɓii Neɗɗo torree torraaji keewɗi, huyfinee? ");
INSERT INTO fuhbkf_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Miɗo haalana on: Iliyaasa wariino, de ɓe ngolli ɗum ko ɓe muuyi fuu, hono no haala makko haaliraa e Binndi ɗiin ni. ");
INSERT INTO fuhbkf_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Nde ɓe ngartunoo to taalibaaɓe heddinooɓe ɓeen fu, ɓe nji'i jamaa keewɗo ina fiilii ɗum'en, jannginooɓe Tawreeta ɓeen ina njeddundura e muɓɓen. ");
INSERT INTO fuhbkf_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Wakkati yimɓe ɓeen nji'unoo Iisaa fu, ɗum haaynii ɓe. Ɓe ndoggi ɓe njaɓɓowii mo. ");
INSERT INTO fuhbkf_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","O ƴami ɓe, o wi'i: —Ɗume njeddundurton e maɓɓe? ");
INSERT INTO fuhbkf_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Gorko gooto ley jamaa oon jaabii mo, wi'i: —Moodibbo, mi gaddanɗo ma ɓiyam gorko mo ginnaaru muumɗini. ");
INSERT INTO fuhbkf_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ɗo ginnaaru nduun ummorii mo fuu, liɓan mo e leydi, hunnduko makko ina wurtina nguufo, imo ŋerƴundura nyiiƴe makko, o yoora koloŋ. Mi nyaagake taalibaaɓe maa ɓeen ndiiwa ndu, de ɓe kunngii. ");
INSERT INTO fuhbkf_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Iisaa wi'i yimɓe ɓeen: —Hey onon yimɓe jamaanu hanndeejo ɓe ngalaa goonɗinal! Faa ndey ngondammi e mooɗon? Faa ndey keddotoomi munyande on? Ngaddanee kam suka oon! ");
INSERT INTO fuhbkf_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","O waddanaa suka oon. Nde ginnaaru nduun yi'unoo Iisaa ndeen, dimmbi suka oon, liɓi ɗum, heddii suka oon ina talloo e leydi, hunnduko muuɗum ina wurtina nguufo. ");
INSERT INTO fuhbkf_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Iisaa ƴami baaba suka oon, wi'i: —Gilla ndey ɗum heɓi mo? Baaba oon jaabii, wi'i: —Gilla imo famɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Katin du wakkati fuu ginnaaru nduun ina liɓa mo ley yiite naa ley ndiyam faa halka mo. De si tawii won ko mbaawɗaa fu, njurmoɗaa min, mballaa min! ");
INSERT INTO fuhbkf_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Iisaa wi'i mo: —Si miɗo waawi mbiiɗaa? Huunde fuu ina waawi laatanaade goonɗinɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Wakkati oon, baaba suka oon ƴeewnii, wi'i: —Mi goonɗinii, de wallam, sabo goonɗinde ina tiiɗi kam! ");
INSERT INTO fuhbkf_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Nde Iisaa yi'unoo jamaa oon ina dogga warde ndeen, sappani ginnaaru nduun e semmbe, wi'i ndu: —Ginnaaru muumɗinooru faaɗinooru, miɗo yamire mburtoɗaa e suka o, taa naatu mo abada katin! ");
INSERT INTO fuhbkf_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ginnaaru nduun feekii, dimmbi suka oon semmbe, de yalti e makko. Heddii imo wa'i hono maayɗo, faa ko heewi e wonnooɓe ɗoon ɓeen ina mbi'a o maayii. ");
INSERT INTO fuhbkf_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ammaa Iisaa nanngi junngo makko, ummini mo tan, o darii. ");
INSERT INTO fuhbkf_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Caggal ɗuum Iisaa naati suudu de taalibaaɓe muuɗum ɓeen toowtidi e muuɗum, ƴami ɗum, mbi'i: —Ɗume waɗi de min kunngii riiwude ginnaaru nduun? ");
INSERT INTO fuhbkf_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","O jaabii: —Ginnaaru nduun, sii muuɗum riiwirtaake si wanaa du'aare. ");
INSERT INTO fuhbkf_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ɓe ndilli ɗoon, ɓe ceeki leydi Galili. O yiɗaa fay gooto faama ɗum, ");
INSERT INTO fuhbkf_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","sabo imo waajoo taalibaaɓe makko ɓeen. Imo wi'a ɗum'en: —Ɓii Neɗɗo wattete e juuɗe yimɓe. Ɓe mbaran ɗum, de caggal balɗe tati fu, iirtoto. ");
INSERT INTO fuhbkf_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ammaa taalibaaɓe ɓeen paamaay maanaa haala kaan, de kuli ƴamude mo du. ");
INSERT INTO fuhbkf_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ɓe njottii Kafarnahum. Nde ɓe njippinoo suudu weerdude maɓɓe fu, o ƴami taalibaaɓe makko, o wi'i: —Ɗume njeddundurɗon dow laawol? ");
INSERT INTO fuhbkf_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ɓe ndeƴƴinii, sabo ko ɓe njeddunduri dow laawol dey, wo moy woni ɓurɗo teddude hakkunde maɓɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ndeen Iisaa jooɗii, noddi taalibaaɓe sappo e ɗiɗo ɓeen, wi'i ɗum'en: —Muuyɗo ardaade fuu, gaɗa heddiiɓe ɓeen heedata, laatoo golloowo maɓɓe ɓe fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Caggal ɗuum, o nanngi junngo cukalel gomma, o darni ngel yeeso maɓɓe, o mumbilii ngel, o wi'i ɓe: ");
INSERT INTO fuhbkf_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Neɗɗo fuu jaɓɓiiɗo cukalel gootel hono ngel e innde am, wo miin jaɓɓii. Katin du jaɓɓiiɗo kam fuu, wanaa miin tan jaɓɓii, jaɓɓake Nulɗo kam oon du. ");
INSERT INTO fuhbkf_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yuhanna wi'i mo: —Moodibbo, min nji'ii gorko gooto ina riiwra ginnaaji e innde maa, de min kaɗi mo, sabo o waldaa e meeɗen. ");
INSERT INTO fuhbkf_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ammaa Iisaa wi'i: —Taa kaɗee mo ɗum, sabo fay gooto waawaa waɗirde kaayeefiiji e innde am, de sakitoo mbonkoo kam wakkati oon. ");
INSERT INTO fuhbkf_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Sabo mo salaaki en fuu ina wondi e meeɗen. ");
INSERT INTO fuhbkf_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Goonga kaalanammi on: neɗɗo fuu kokkuɗo on horde ndiyam saabe on yimɓe Almasiihu, waasataa heɓude mbarjaari muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Neɗɗo fuu luttinɗo gootel e cukaloy goonɗinkoy kam koy, ko ɓuri woodde e joomum wo hayre teddunde haɓɓee e daande mum, faɗɗee e maayo manngo. ");
INSERT INTO fuhbkf_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Si tawii junngo maa luttinte, taƴu ngo. Naataa e nguurndam nduumiiɗam a nyakuɗo ɓuri moƴƴande ma diina naatude e jahannama yiite nge nyifataa tawee a kiɓɓuɗo.  ");
INSERT INTO fuhbkf_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Si tawii koyngal maa luttinte, taƴu ngal. Naataa ley nguurndam nduumiiɗam tawee wo a nyakuɗo ɓuri moƴƴande ma diina faɗɗeede e yiite duumiinge tawee a kiɓɓuɗo.  ");
INSERT INTO fuhbkf_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Katin du si yitere maa luttinte, ittu nde. Sabo naataa e laamu Laamɗo a ɗokko ɓuri moƴƴande ma diina paɗɗeɗaa e jahannama a kiɓɓuɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ɗoon, «gilɗi muuɗum mbaatataa, yiite muuɗum du nyifataa.» ");
INSERT INTO fuhbkf_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Yiite lamsinan mono fuu hono lamɗam ni. ");
INSERT INTO fuhbkf_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Lamɗam wo huunde lobbere, de si ɗam selii lamsude, noy lamsinirton ɗam katin? Hakkunde mooɗon laatoɗon hono lamɗam ni, ngondon e jam. ");
INSERT INTO fuhbkf_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Iisaa dilli ɗoon, yehi leydi Yahuudiya, de feƴƴiti yehi lettugal gooruwol Urdun. Yimɓe heewɓe piilii mo, de imo waajoo ɗum'en katin hono no o woowrunoo ni. ");
INSERT INTO fuhbkf_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Farisa'en woɓɓe ngari faa ndaartindoo mo, ƴami mo: —Yalla ina daganii gorko seerude deekum naa? ");
INSERT INTO fuhbkf_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","O jaabii ɓe: —Ɗume Muusaa yamiri on? ");
INSERT INTO fuhbkf_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ɓe njaabii, ɓe mbi'i: —Muusaa jaɓii si gorko na seera deekum fu, winnda talkuru ceergal de seera ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Iisaa wi'i ɓe: —Wo saabe on yoorɓe ɓerɗe, ɗuum waɗi de Muusaa winndani on yamiroore nde. ");
INSERT INTO fuhbkf_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Kaa gilla e fuɗɗoode, «Laamɗo tagii ɓe, waɗii ɓe gorko e debbo. ");
INSERT INTO fuhbkf_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ɗum waɗi de gorko yoppan inna mum e bammum, nanngundura e deekum, ");
INSERT INTO fuhbkf_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ɓe ɗiɗo fuu ɓe laatoo neɗɗo gooto.» Nii woni ɓe nganaa ɗiɗo katin, ɓe ɓanndu wooturu. ");
INSERT INTO fuhbkf_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ndelle, taa neɗɗo sennda ko Laamɗo hawrunduri. ");
INSERT INTO fuhbkf_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Nde ɓe kootunoo ndeen, taalibaaɓe makko ɓeen ƴami mo haala majjum. ");
INSERT INTO fuhbkf_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","O wi'i ɓe: —Si neɗɗo seerii deekum de ɓaŋi goɗɗo fuu, jeenii. ");
INSERT INTO fuhbkf_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Hono noon du, si debbo seedii e gorum, de gorko goɗɗo ɓaŋi ɗum, debbo oon du jeenii. ");
INSERT INTO fuhbkf_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Yimɓe ina ngadda cukaloy to Iisaa, faa meema koy, de taalibaaɓe ɓeen ndukani ɗum'en. ");
INSERT INTO fuhbkf_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Nde o yiinoo ɗum ndeen, o ɓerni, o wi'i taalibaaɓe ɓeen: —Accee cukaloy koy ngara to am. Taa kaɗee koy, sabo wo nannduɓe e makkoy ɓeen njeyi laamu Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Goonga kaalanammi on: mo jaɓiraay laamu Laamɗo hono no cukalel ni fuu, naatataa ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Caggal ɗuum, o mumbilii cukaloy koy, o yowi junngo makko e makkoy, o barkini koy. ");
INSERT INTO fuhbkf_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Nde Iisaa nanngunoo laawol fu, gorko gomma doggiri to makko, hofii yeeso makko, ƴami mo, wi'i: —Moodibbo lobbo, ɗume kaanumi waɗude faa mi heɓa nguurndam nduumiiɗam? ");
INSERT INTO fuhbkf_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Iisaa wi'i mo: —Ko waɗi de aɗa noddira kam lobbo? Lobbo walaa si wanaa gooto, oon woni Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Aɗa anndi jamirooje: «Taa waɗu war-hoore, taa jeenu, taa wujju, taa seeda fewre, taa toonya, teddin inna maa e bammaa.» ");
INSERT INTO fuhbkf_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Gorko oon jaabii mo, wi'i: —Moodibbo, miɗo hayba ɗum fuu gilla e cukaaku am. ");
INSERT INTO fuhbkf_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ndeen Iisaa ndaari mo, yiɗi mo, wi'i mo: —Huunde wootere ina nyakani maa: yahu sonnoy ko njogiɗaa ɗuum fuu, kokkaa ceede ɗeen talkaaɓe. Ndeen, a heɓan mbarjaari dow kammu. De ngaraa, njokkaa kam. ");
INSERT INTO fuhbkf_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ammaa nde gorko oon nannoo haalaaji ɗiin ndeen, ɓalinii, dillidi e mettorgal, sabo o jom jawdi sanne. ");
INSERT INTO fuhbkf_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Iisaa ƴeewi gereeji fuu de wi'i taalibaaɓe mum ɓeen: —Naatugol joomiraaɓe jawdi ley laamu Laamɗo ina tiiɗi koy! ");
INSERT INTO fuhbkf_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Haalaaji ɗiin kaaynii taalibaaɓe ɓeen sanne. O ɓeydi katin, o wi'i ɓe: —Sukaaɓe am, naatude e laamu Laamɗo ina tiiɗi koy! ");
INSERT INTO fuhbkf_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Sabo ngeelooba naata wudde battal ɓuri hoyude diina jom jawdi naata laamu Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ɗum ɓeydi haaynaade taalibaaɓe ɓeen, keddii ina ƴamundura hakkunde muɓɓen ina mbi'a: —Ndelle, moy woni kisoowo? ");
INSERT INTO fuhbkf_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","O ndaari ɓe, o wi'i: —Yimɓe mbaawanaa ɗum, ammaa Laamɗo ina waawi. Sabo walaa fuu ko Laamɗo waawanaa. ");
INSERT INTO fuhbkf_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ndeen, Piyeer wi'i mo: —Ndaar, minen min njoppii huunde fuu min njokkii ma! ");
INSERT INTO fuhbkf_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","O jaabii ɗum, o wi'i: —Goonga kaalanammi on: neɗɗo fuu joppuɗo suudu muuɗum, naa sakiraaɓe muuɗum worɓe e rewɓe, naa inna mum, naa bammum, naa sukaaɓe mum, naa gese muuɗum saabe am e saabe Kabaaru Lobbo ");
INSERT INTO fuhbkf_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","heɓan ko ɓuri ɗum kile hemre e aduna mo ngonɗen e muuɗum joonin o: joomum heɓan cuuɗi e sakiraaɓe worɓe e sakiraaɓe rewɓe e inniraaɓe e sukaaɓe e gese, o torrete du. E ley wakkati garoowo oon du, joomum heɓan nguurndam nduumiiɗam. ");
INSERT INTO fuhbkf_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ammaa ardiiɓe heewɓe laatoto gaɗaaɓe, gaɗaaɓe ɓeen du laatoto ardiiɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Iɓe ngoni e laawol faa ɓe njaha Urusaliima. Iisaa na ardii ɓe, tawi taalibaaɓe ɓeen ina mbemmbii, jokkuɓe ɗum'en ɓeen du kulii. O noddi taalibaaɓe sappo e ɗiɗo ɓeen, o fuɗɗi haalande ɗum'en ko hewtata mo. ");
INSERT INTO fuhbkf_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","O wi'i ɓe: —Inani eɗen njaha Urusaliima. Ɗoon Ɓii Neɗɗo wattetee e juuɗe hooreeɓe almaami'en e jannginooɓe Tawreeta. Ɓe caroto mo sariya maayde, de ɓe ngatta mo e juuɗe yimɓe ɓe nganaa Alhuudiya'en. ");
INSERT INTO fuhbkf_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ɓeen njalnoroo mo, tutta dow makko, piya mo dorri, mbara mo. De balɗe tati caggal majjum, o ummitoto. ");
INSERT INTO fuhbkf_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Caggal ɗuum, Yaakuuba e Yuhanna ɓiɓɓe Jebede ɓeen ngari to Iisaa, mbi'i ɗum: —Moodibbo, won ko min njiɗi nyaagaade ma. Miɗen njiɗi ngaɗanaa min ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","O wi'i ɓe: —Ɗume njiɗuɗon mi waɗana on? ");
INSERT INTO fuhbkf_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ɓe njaabii mo: —Nduŋanoɗaa min min njooɗodoo e maaɗa, gooto gere nyaamo maa, gooto du gere nano maa e ley darja laamu maaɗa. ");
INSERT INTO fuhbkf_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","O jaabii ɓe, o wi'i: —On anndaa ko ŋaarotoɗon. Yalla oɗon mbaawi yardude horde mettunde nde njardammi ndeen, naa looteede lootagal batisima naawngal ngal looteteemi ngaal naa? ");
INSERT INTO fuhbkf_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ɓe njaabii mo, ɓe mbi'i: —Miɗen mbaawi. O wi'i ɓe: —On njardan horde nde njardammi ndeen, on keɓan lootagal batisima ngal looteteemi ngaal. ");
INSERT INTO fuhbkf_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ammaa jooɗaade gere nyaamo am naa gere nano am wanaa miin yamirta ɗum. Jooɗorɗe ɗeen, wo ɓe Laamɗo moƴƴinani ɓeen njeyi. ");
INSERT INTO fuhbkf_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Nde taalibaaɓe sappo heddiiɓe ɓeen nannoo ɗum ndeen, ɓernani Yaakuuba e Yuhanna. ");
INSERT INTO fuhbkf_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Iisaa noddi ɓe fuu, wi'i: —Oɗon anndi laamiiɓe leyɗe adunaaru ina laamorii ɗum'en doole. Mawɓe ɓeen du ina kolla yimɓe ɓeen baawɗe. ");
INSERT INTO fuhbkf_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Onon kaa, ɗum waɗataa hakkunde mooɗon. Jiɗɗo laataade tedduɗo hakkunde mooɗon fuu, ina haani laataade golloowo mooɗon. ");
INSERT INTO fuhbkf_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Katin du, jiɗɗo ardaade e mooɗon fuu, ina haani laataade maccuɗo mooɗon, on fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Sabo fay Ɓii Neɗɗo waraay faa gollanee, ammaa warii faa gollana yimɓe, de hokka yonki muuɗum faa laatoo coottitaari ndimɗinoori heewɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ɓe njottii Yeriko. Nde Iisaa yaltannoo ngalluure ndeen, kam e taalibaaɓe muuɗum e jamaa keewɗo, ɓe tawi bumɗo bi'eteeɗo Bartime ɓii Time ina jooɗii ina garbina ɗakkol laawol ngool. ");
INSERT INTO fuhbkf_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Nde o nannoo wo Iisaa Nasaraatuujo oon faltotoo ɗoon ndeen, o fuɗɗi ƴeewnaade imo wi'a: —Iisaa, taan Daawda, yurmam! ");
INSERT INTO fuhbkf_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Yimɓe heewɓe ina njawana mo ina mbi'a o deƴƴinoo, ammaa o ɓeydi ƴeewnaade sanne, imo wi'a: —Taan Daawda, yurmam! ");
INSERT INTO fuhbkf_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Iisaa darii, wi'i: —Noddee mo. Ndeen, ɓe noddi bumɗo oon, ɓe mbi'i ɗum: —Sellin ɓernde maa, umma! O noddii ma. ");
INSERT INTO fuhbkf_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","O gurbitii, o faɗɗi saaya makko, o wari to Iisaa. ");
INSERT INTO fuhbkf_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Iisaa ƴami mo, wi'i: —Ɗume njiɗɗaa mi waɗane? Bumɗo oon jaabii mo, wi'i: —Moodibbo, mi wumta. ");
INSERT INTO fuhbkf_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Iisaa wi'i mo: —Yahu, goonɗinal maa dannii ma. Wakkati oon o wumti, o jokki Iisaa, iɓe njaha dow laawol. ");
INSERT INTO fuhbkf_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ko Iisaa e taalibaaɓe muuɗum ɓadii Urusaliima ɗuum, njottii Baytifaaji e Baytaniya dow waamnde wi'eteende Jaytun. Iisaa nuli taalibaaɓe muuɗum ɗiɗo, ");
INSERT INTO fuhbkf_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","wi'i ɓe: —Njehee naatowee wuro wonngo yeeso mooɗon ngo. Wakkati oon fu, on tawan mola araawa nga fay gooto waɗɗaaki abada ina haɓɓii. Kaɓɓiton nga, ngaddon nga ɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Si goɗɗo ƴamii on ɗume ngaɗoton nga, njaaboɗon mbi'on Joomii amin ina haajaa nga, de nultiran nga law. ");
INSERT INTO fuhbkf_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ɓe njehi, ɓe tawi mola ngaan ina haɓɓii yaasin ɗakkol dammbugal, ɓe kaɓɓiti nga. ");
INSERT INTO fuhbkf_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Yoga e darinooɓe ɗoon ɓeen ƴami ɓe: —Ɗume ngolloton ɗo? Ko waɗi oɗon kaɓɓita mola nga? ");
INSERT INTO fuhbkf_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ɓe njaaborii ɓeen no Iisaa wiirunoo ɓe noon. Ɓeen njoppi ɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ɓe njaarani Iisaa mola ngaan, ɓe njowi saayaaji maɓɓe dow magga, o waɗɗii. ");
INSERT INTO fuhbkf_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Yimɓe heewɓe mbeerti saayaaji muɓɓen dow laawol. Woɓɓe kelti licce leɗɗe ɗakkol toon, mbeerti ɗe e laawol ngool. ");
INSERT INTO fuhbkf_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ardiiɓe mo e heeduɓe gaɗa makko ɓeen na ƴeewnoo na mbi'a: —Jettooje e barke ngoodanii garɗo e dow innde Joomiraaɗo! ");
INSERT INTO fuhbkf_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Barke woodanii laamu maami en Daawda, laamu ngaroowu nguun! Jettooje ngoodanii Laamɗo dow kammuuli! ");
INSERT INTO fuhbkf_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Iisaa hewti ley Urusaliima, naatowi suudu dewal mawndu nduun, de ndaari fuu ko woni ley mayru. Ammaa saabe hiirii, o yehi Baytaniya kanko e sappo e ɗiɗo ɓeen. ");
INSERT INTO fuhbkf_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Jaango majjum, caggal ɓe ndawii Baytaniya, tawi imo yolbi. ");
INSERT INTO fuhbkf_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","O haccii ƴibbi mbilitinki, o yehi ƴeewoyde yalla imo tawra ki ɓiɓɓe. Nde o yottinoo ki ndeen, o tawaay e makki si wanaa haakorooji. Sabo wakkati oon wanaa wakkati rimugol ƴibbe. ");
INSERT INTO fuhbkf_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","O wi'i ƴibbi kiin: —Taa fay gooto nyaama ɓiɓɓe maa abada katin! Taalibaaɓe makko ɓeen nani ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Nde ɓe njottinoo Urusaliima fu, Iisaa naati taliyaare suudu dewal mawndu nduun, de fuɗɗi riiwude soodooɓe e soottooɓe wonɓe ley toon. O liɓi taabaaje weccooɓe ceede e jooɗorɗe soottooɓe buugaali. ");
INSERT INTO fuhbkf_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","O accaay fay gooto rewi ley taliyaare suudu dewal mawndu nduun ina ronndii gineeji. ");
INSERT INTO fuhbkf_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ndeen o waajii ɓe: —Yalla wanaa ina winndaa: «Suudu am inndirte suudu waɗirdu du'aare lenyi fuu!» Onon kaa, on ngaɗii ndu suuɗirdu yanooɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Hooreeɓe almaami'en e jannginooɓe Tawreeta nani ɗum, pilii no mbardata mo. Ɓe kuli mo, sabo waaju makko oon naatii jamaa oo sanne. ");
INSERT INTO fuhbkf_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Nde hiirnoo fu, kanko e taalibaaɓe makko, ɓe njalti ngalluure ndeen. ");
INSERT INTO fuhbkf_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Fajiri jaango majjum, iɓe paltoroo to ƴibbi kiin toon, ɓe nji'i ki yoorii koloŋ faa yottii ɗaɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Piyeer miccitii, wi'i mo: —Moodibbo, ndaar! Ƴibbi ki kuɗunoɗaa kiin yoorii. ");
INSERT INTO fuhbkf_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Iisaa jaabii ɓe, wi'i: —Ngoonɗinee Laamɗo! ");
INSERT INTO fuhbkf_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Goonga kaalanammi on: neɗɗo fuu biiɗo waamnde nde: «Ɗoofa, saamoy ley maayo», si sikkitiraay ley ɓernde muuɗum, de goonɗini ko wi'i ɗuum laatoto fu, waɗante ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ɗum waɗi de miɗo wi'a on: ko ŋaariɗon e ley du'aare fuu, ngoonɗinee on keɓii ɗum, ndeen on ngaɗante ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Nde ndariɗon faa ngaɗon du'aare fuu, si won gaɗunooɗo on huunde fu, njaafoɗon ɗum, faa Baaba mooɗon gonɗo dow kammu oon yaafanoo on hakkeeji mooɗon onon du.  ");
INSERT INTO fuhbkf_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ɓe ngarti Urusaliima katin. E ley ko o yiiltotoo ley suudu dewal mawndu ɗuum, hooreeɓe almaami'en e jannginooɓe Tawreeta e mawɓe ɓattitii mo ");
INSERT INTO fuhbkf_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ƴami mo: —Laamu nguye hokki ma baawɗe gollude ko ngollataa ɗum? Moy hokki ma laawol ngollaa ɗum? ");
INSERT INTO fuhbkf_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Iisaa wi'i ɓe: —Mi ƴaman on huunde wootere. Njaaboɗon kam, de mi haalana on kokkuɗo kam laawol mi golla ko ngollammi ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Lootagal batisima Yaayaa ngaal, to Laamɗo ƴuuri naa to yimɓe? Njaabee kam! ");
INSERT INTO fuhbkf_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ɓe ndawridi hakkunde maɓɓe, ɓe mbi'i: —Si en mbi'ii to Laamɗo, o ƴaman en ndelle ko waɗi de en ngoonɗinaay Yaayaa? ");
INSERT INTO fuhbkf_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Yalla en mbi'an to yimɓe naa? Iɓe kula yimɓe ɓeen sabo ɓe fuu iɓe njogorii Yaayaa wo annabaajo goongaajo. ");
INSERT INTO fuhbkf_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ɓe njaabii Iisaa, ɓe mbi'i: —Min anndaa. Iisaa wi'i ɓe: —Haya miin du, mi haalantaa on baawɗe ɗeye ngollirammi ko ngollammi ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Iisaa fuɗɗi haalude, banndani ɓe, wi'i: —Neɗɗo gomma waɗii ngesa cabiije. O fiiltini nga hoggo, o wasi luggere ɓoosirde, o nyiɓi suudu toowndu faa o haynoo ko warata e ngesa ngaan. Caggal ɗuum, o halfini nga remooɓe, de o waɗi jahaangal. ");
INSERT INTO fuhbkf_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Nde ɓoreede cabiije yottinoo fu, o neli golloowo makko to remooɓe ɓeen toon, ɓe ngaddana mo ngeɗu makko e ɓiɓɓe cabiije ɗeen. ");
INSERT INTO fuhbkf_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ɓe nanngi nelaaɗo oon, ɓe piyi ɗum, ɓe njeccini ɗum juuɗe ɓole. ");
INSERT INTO fuhbkf_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","O neli e maɓɓe golloowo makko goɗɗo. Ɓe kuyfini ɗum, ɓe eli ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","O neli katin golloowo tataɓo, de ɓe mbari ɗum. Woɓɓe heewɓe nuliraama hono noon: ɓe piyi woɓɓe, ɓe mbari woɓɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Joonin kaa gooto tan o heddorii, ɓiyiiko korsuɗo oon. Sakitii o neli oon du e maɓɓe, o wi'i: «Ɓe njaagoto ɓiyam oon.» ");
INSERT INTO fuhbkf_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ammaa remooɓe ɓeen mbi'unduri hakkunde muɓɓen: «O woni donoowo oon. Ngaree mbaren mo, faa kewten ngesa ngaan!» ");
INSERT INTO fuhbkf_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ɓe nanngi ɓiɗɗo oon, ɓe mbari ɗum, ɓe paɗɗi ɗum to gaɗa ngesa toon. ");
INSERT INTO fuhbkf_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Joonin le, noy jom ngesa oon waɗata? O waran, o halka remooɓe ɓeen, o halfina ngesa ngaan woɓɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Yalla on njanngaay ko winndaa ley Binndi ɗiin ɗuum naa? «Hayre nde nyiɓooɓe ɓeen calii ndeen, wo kayre laatii hoore nyimngo ngoon. ");
INSERT INTO fuhbkf_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ɗum wo golle Joomiraaɗo, wo ɗum haaynde e jiiɗe meeɗen!» ");
INSERT INTO fuhbkf_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Hooreeɓe Alhuudiyankooɓe pilii no nanngira Iisaa, sabo ɓe paamii banndol ngol wo kamɓe sappii. De ɓe cuusaay jamaa oon. Ɓe njoppi mo, ɓe ndilli. ");
INSERT INTO fuhbkf_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Hooreeɓe ɓeen neli e makko Farisa'en woɓɓe e daraniiɓe Hirudus faa keɓa tuufira mo e konngol makko. ");
INSERT INTO fuhbkf_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ɓe ngari, ɓe mbi'i mo: —Moodibbo, miɗen anndi a goongante. A hulataa fay gooto, sabo a ɓurdintaa yimɓe, aɗa jannginira laawol Laamɗo ngol goonga. Yalla ina dagii min kokka kaananke Roma mawɗo oon lampo naa dagaaki? Min kokka mo naa taa min kokka mo? ");
INSERT INTO fuhbkf_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ammaa Iisaa annditii naafikaaku maɓɓe. O wi'i ɓe: —Ɗume waɗi de oɗon tuufina kam? Ngaddanee kam mbuuɗu cardi faa mi yi'a ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ɓe ngaddani mo. O ƴami ɓe: —Natal moy e innde moy woni ɗo? Ɓe mbi'i mo: —Kaananke Roma. ");
INSERT INTO fuhbkf_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ndeen o jaabii ɓe, o wi'i: —Ndelle kokkee kaananke Roma ko jeyi, kokkon Laamɗo du ko jeyi. Ko Iisaa jaabii ɗuum haaynii ɓe sanne. ");
INSERT INTO fuhbkf_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Saduki'en woɓɓe ngari to makko. Kam'en ngoni yeddooɓe ummital. Ɓe ƴami mo, ɓe mbi'i: ");
INSERT INTO fuhbkf_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Moodibbo, Muusaa yamirii en si neɗɗo ɓaŋii debbo, maayii tawii heɓaay ɓiɗɗo fu, minyum naa mawnum dewla debbo joppaaɗo oon faa heɓana maayɗo oon ɓeyngu. ");
INSERT INTO fuhbkf_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Waɗii rimdaaɓe njeɗɗo. Arandeejo oon ɓaŋi debbo de maayi, heɓaay ɓiɗɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ɗiɗaɓo oon dewli debbo oon, kam du maayi heɓaay ɓiɗɗo. Tataɓo oon du waɗi hono noon. ");
INSERT INTO fuhbkf_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Hono nii njeɗɗo ɓeen fuu ɓaŋiri mo, keɓaay ɓiɗɗo. Caggal maɓɓe ɓe fuu, debbo oon du maayi. ");
INSERT INTO fuhbkf_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ndelle, nyannde ummital, moy e maɓɓe laatotoo goroo debbo oon? Sabo ɓe njeɗɗo fuu ɓe ɓaŋiino mo. ");
INSERT INTO fuhbkf_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Iisaa jaabii ɓe, wi'i: —On woofuɓe, on anndaa Binndi ɗiin, on anndaa baawɗe Laamɗo du. ");
INSERT INTO fuhbkf_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Sabo si maayɓe ummitake fu, worɓe ɓaŋataa, rewɓe ɓaŋataake. Ɓe laatoto hono maleyka'en wonɓe dow kammu ɓeen ni. ");
INSERT INTO fuhbkf_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Wooɗi, ko maayɓe ummitotoo ɗuum, on njanngaay e dewtere Muusaa ley taariki wuumoore huɓɓoore, hono no Laamɗo haaldiri e makko, wi'i: «Miin woni Laamɗo Ibrahiima, Laamɗo Isiyaaka, Laamɗo Yaakuuba»? ");
INSERT INTO fuhbkf_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Laamɗo wo Laamɗo wuurɓe, wanaa Laamɗo maayɓe. On mboofii sanne. ");
INSERT INTO fuhbkf_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Jannginoowo Tawreeta gooto ɓattitii Iisaa, tawi naniino jeddi maɓɓe, e no o jaaborii Saduki'en ɓeen faa wooɗi, ƴami mo: —E jamirooje ɗeen fuu, ndeye ɓuri manngu? ");
INSERT INTO fuhbkf_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Iisaa jaabii mo: —Ɓurnde fuu manngu e jamirooje ɗeen wo nde ɗo: «Hettinda Israa'iila, Laamɗo Joomiraaɗo meeɗen oon tan woni Joomiraaɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Yiɗir Laamɗo Joomiraaɗo maa e ɓernde maa fuu e yonki maa fuu e hakkillo maa fuu e semmbe maa fuu.» ");
INSERT INTO fuhbkf_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ɗiɗaɓerde ndeen wo hono mayre, kayre woni: «Njiɗiraa gondo maa no njiɗirɗaa hoore maa ni.» Walaa fuu yamiroore ɓurnde ɗiɗi ɗeen manngu. ");
INSERT INTO fuhbkf_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","33","Jannginoowo Tawreeta oon wi'i mo: —Moodibbo! A haalii goonga ko mbiiɗaa Laamɗo tan woni Joomiraaɗo, katin du Laamɗo goɗɗo walaa si wanaa kanko. E yiɗirde Laamɗo e ɓerndem fuu e hakkillom fuu e semmbem fuu, e yiɗirde gondo mum hono no yiɗiri hoore mum ni, kanjum ɓuri sadakaaji duppeteeɗi e kirsamaaji fuu! Haala maa ina selli sanne. ");
INSERT INTO fuhbkf_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Nde Iisaa yi'unoo o jaaborake hakkilantaaku ndeen, wi'i mo: —A woɗɗaa e laamu Laamɗo. Caggal ɗuum, fay gooto suusaay ƴamude Iisaa ƴamɗe goɗɗe katin. ");
INSERT INTO fuhbkf_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Nde Iisaa waajotoo ley suudu dewal mawndu ndeen, wi'i: —Noy jannginooɓe Tawreeta ɓeen mbaawri wiide Almasiihu oon wo taan Daawda? ");
INSERT INTO fuhbkf_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Sabo Daawda e hoore muuɗum wi'irii Ruuhu Ceniiɗo: «Joomiraaɗo wi'i Joomam: Jooɗa gere nyaamo am, faa mi waɗa njaaɓaa wayɓe ma.» ");
INSERT INTO fuhbkf_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Daawda e hoore muuɗum ina noddira Almasiihu oon «Joomam». Ndelle, noy o laatortoo taanum? Jamaa keewɗo ina hettindanii Iisaa e seyo. ");
INSERT INTO fuhbkf_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","E ley waajagol makko ngool, o wi'i ɓe: —Tinnee e jannginooɓe Tawreeta yiɗuɓe yiilodaade e saayaaji mawɗi e jowteede jowtaali tedduɗi ley luumooji, ");
INSERT INTO fuhbkf_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","fooɗantooɓe jooɗorɗe ɓurɗe teddude ley cuuɗi baajorɗi e nokkuuje tedduɗe to nyaamduuji. ");
INSERT INTO fuhbkf_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Iɓe nyaama jawdi rewɓe talkaaɓe ɓe goriraaɓe muɓɓen maayi, de ɓe njuutina du'aawuuji maɓɓe faa ɓe nanndinkinoo e lobbuɓe. Kamɓe, jukkungo naawngo ɓurata jippineede dow muɓɓen. ");
INSERT INTO fuhbkf_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Iisaa jooɗii hucciti e keesu suudu dewal mawndu nduun, yi'i no jamaa oon wattirta kaalisi e keesu oon noon. Joomiraaɓe jawdi heewɓe ngatti kaalisi keewɗo ley keesu oon. ");
INSERT INTO fuhbkf_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ndeen debbo talkaajo mo gorum maayi wari, watti buuɗi ɗiɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Iisaa noddi taalibaaɓe muuɗum ɓeen, wi'i ɗum'en: —Goonga kaalanammi on: ko debbo talkaajo o watti e ley keesu ɗuum ɓuri ko ɓeen fuu ngatti ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Sabo ɓe fuu, wo ko bonnantaa ɓe fay huunde tan ɓe ngatti. Ammaa debbo o kaa, e ley talkaaku muuɗum watti haddi ko joginoo faa wuurda ɗuum fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Nde o wurtotonoo suudu dewal mawndu ndeen, taalibaajo makko gooto wi'i mo: —Moodibbo, ndaar, kaaƴe ɗe e nyimngo ngo fuu no ŋarɗiri! ");
INSERT INTO fuhbkf_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Iisaa jaabii mo, wi'i: —A yi'ii nyimngo ngo no foti mawnude naa? Fay hayre wootere heddataako ɗo ina yowii dow wonnde. Fuu wurjinte. ");
INSERT INTO fuhbkf_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","O jooɗowii dow waamnde wi'eteende Jaytun, o hucciti e suudu dewal mawndu nduun. Piyeer e Yaakuuba e Yuhanna e Andire toowtidi e makko, ƴami mo, mbi'i: ");
INSERT INTO fuhbkf_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Anndin min nde ɗum waɗata. Maande ndeye hollata waɗugol kulle ɗeen fuu? ");
INSERT INTO fuhbkf_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Iisaa jaabii ɓe wi'i: —Ndeentee taa fay gooto wosina on e goonga. ");
INSERT INTO fuhbkf_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Heewɓe ngardan e innde am, ina mbiitoo: «Miin woni kanko.» Ɓe mbosinan yimɓe heewɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Si on nanii kabaaru woldeeji ɓadiiɗi, si on kaalanaama woldeeji boɗɗuɗi, taa kulee. Ina tilsi ɗum waɗa, de ɗum wanaa timmoode tafon. ");
INSERT INTO fuhbkf_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Lenyol habdan e lenyol, laamu habdan e laamu, leydi dimmboto e nokkuuje feere feere, rafooji du ngaɗan. Ɗum fuu laatoto hono fuɗɗoode ŋatawere ɓeynoowo ni. ");
INSERT INTO fuhbkf_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Ndeenee ko'e mooɗon, sabo yimɓe njaaran on to carorɗe, on piyete ley cuuɗi baajorɗi. Ɓe ndarna on yeeso hooreeɓe e kaanankooɓe saabe am, faa laatanoɗon kam seedeeɓe yeeso maɓɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ina tilsi Kabaaru Lobbo oon waajee lenyi ɗiin fuu tafon. ");
INSERT INTO fuhbkf_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Nde ɓe njaarii on faa ɓe kokkitira on, taa mbemmbeɗon dow ko kaaloton. Nde wakkati majjum wari fuu, on keɓan ko kaalon. Sabo wanaa onon kaalata, wo Ruuhu Ceniiɗo haalata. ");
INSERT INTO fuhbkf_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Neɗɗo hokkitiran sakiike muuɗum waree, baabiiwo du hokkitiran ɓiyum. Ɓiɓɓe ummanto saaraaɓe muɓɓen, ngaɗa faa ɓe mbaree. ");
INSERT INTO fuhbkf_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Yimɓe fuu mbanyan on saabe am. Ammaa tinnitiiɗo faa yottii timmoode fu, kam hisintee. ");
INSERT INTO fuhbkf_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Wakkati waran nde nji'oton «huunde nyiddiniinde bonnoore» ina woni ɗo haanaa wonde. (Jannguɗo ɗum fuu, faama maanaa majjum.) Ndeen, tawaaɓe ley Yahuudiya fuu ndoggira baamle. ");
INSERT INTO fuhbkf_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Tawaaɗo dow suudu, taa jippoo fey de wi'a naatan faa hooƴa huunde ley suudu muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Tawaaɗo ngesa, taa yeccoo faa hooƴowa saaya muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Kay, debereedu'en e musinteeɓe njaran torra ley balɗe ɗeen! ");
INSERT INTO fuhbkf_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ŋaaree Laamɗo taa ɗum waɗa wakkati dabbunde. ");
INSERT INTO fuhbkf_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Sabo ley balɗe ɗeen torra waɗan mo hono muuɗum waɗaay gilla fuɗɗoode adunaaru ndu Laamɗo tagi nduun faa joonin, wooɗi du hono muuɗum waɗataa abada katin. ");
INSERT INTO fuhbkf_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Sini Joomiraaɗo raɓɓinɗinaayno balɗe ɗeen, fay gooto hisataano. Ammaa o raɓɓinɗinirii ɗe saabe suɓaaɓe makko ɓeen. ");
INSERT INTO fuhbkf_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Wakkati oon, si goɗɗo wi'ii on: «Ndaaree! Inan Almasiihu ɗo», naa «Inani mo to», taa ngoonɗinee. ");
INSERT INTO fuhbkf_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Sabo almasiihu'en fewreeɓe e annabaaɓe fewreeɓe ɓangowan, ngaɗa maandeeji e kaayeefiiji faa majjina fay suɓaaɓe ɓeen, si na laatoo. ");
INSERT INTO fuhbkf_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ndelle, kakkilon! Mi haalanii on huunde fuu gilla ɗum waraay. ");
INSERT INTO fuhbkf_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","—Ammaa e ley balɗe ɗeen, caggal torra oon, naange niɓɓan, lewru selan yaynude, ");
INSERT INTO fuhbkf_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","koode kammu caaman, kulle gonɗe dow kammu ɗeen ndimmboto. ");
INSERT INTO fuhbkf_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Wakkati oon, Ɓii Neɗɗo oon yi'ete ina wara e duule, ina warda e baawɗe mawɗe e teddeengal. ");
INSERT INTO fuhbkf_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","O nulan maleyka'en makko lettugal e gorgal, horɗoore e soɓɓiire, kawrundura suɓaaɓe makko ɓeen gilla to adunaaru fuɗɗi faa to haaɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Ekitee ko ƴibbi hollata: si licce makki keyɗitii, haakorooji makki mbilitii, oɗon anndi ndunngu ɓadake. ");
INSERT INTO fuhbkf_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Noon du, si on nji'ii kulle ɗeen ina ngaɗa, annditon wakkati oon ɓadake, ina woni e dammbugal galle. ");
INSERT INTO fuhbkf_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Goonga kaalanammi on: jamaanu o timmataa tawee kulle ɗeen fuu ngaɗaay. ");
INSERT INTO fuhbkf_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Kammu e leydi timman, de haalaaji am kaa timmataa abada. ");
INSERT INTO fuhbkf_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Kaa nyalaande ndeen e wakkati oon fay gooto anndaa ɗum. Wanaa maleyka'en wonɓe dow kammu, wanaa Ɓiɗɗo oon. Walaa annduɗo ɗum si wanaa Baabiiwo oon. ");
INSERT INTO fuhbkf_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Kakkilee, tinnoɗon e majjum, sabo on anndaa wakkati mo o warata. ");
INSERT INTO fuhbkf_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Iɗum wa'i hono gorko cegiliiɗo faa dilla, yalti suudu muuɗum, hokki maccuɓe mum mono fuu golle mum, yamiri doomoowo dammbugal oon tinnoo dooma. ");
INSERT INTO fuhbkf_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ndelle, kakkilon, sabo on anndaa nde jom galle oon wartata: ina waawi laataade kiiral naange, naa hakkunde jemma, naa wakkati nde dontooje njoggata, naa fajiri. ");
INSERT INTO fuhbkf_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Taa o juha on de o tawa oɗon ɗaanii! ");
INSERT INTO fuhbkf_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ko kaalanammi on ɗuum, miɗo haalana yimɓe fuu: kakkilon! ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Balɗe ɗiɗi keddanii iidi Faltagol e iidi buuru mo wattaaka rabilla. Hooreeɓe almaami'en e jannginooɓe Tawreeta pilii nanngirde Iisaa e hiila faa keɓa mbara ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","De ɓe mbi'i: —Taa ngaɗen ɗum ley iidi ndi de yimɓe muurta. ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Wakkati oon Iisaa ina woni ley Baytaniya, ɗo suudu Simon noddirteeɗo ceppinɗo oon. O jooɗii faa o nyaama. Debbo gomma naati ina jogii faandu nebbam laaɓuɗam, uurɗam, tiiɗuɗam coggu sanne. Debbo oon heli faandu nduun, joori nebbam ɗaam dow hoore makko. ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Yoga e wonnooɓe toon ɓeen mettaa, mbi'unduri hakkunde muɓɓen: —Ɗume saabii de nebbam ɗaam bonniraa ni? ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Iɗam waawnoo sonneede ko ɓuri buuɗi cardi keme tati, de hokkee talkaaɓe! Heddii iɓe pela debbo oon. ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ammaa Iisaa wi'i: —Celee mo! Ko waɗi de oɗon torra mo? O gollanii kam gollal lobbal. ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Si goonga, talkaaɓe ina tawdee e mooɗon wakkati fuu, nde muuyɗon fuu oɗon mbaawi waɗande ɗum'en moƴƴere. De miin kaa, mi tawdataake e mooɗon wakkati fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","O waɗii ko o waawi: o joorii nebbam uurɗam ɗam dow ɓanndu am faa mi segilanoo saabeere. ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Goonga kaalanammi on: ɗo Kabaaru Lobbo waajaa e adunaaru ndu fuu, ko debbo o waɗi ɗuum fillitete, faa o miccitee. ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Yahuuda Isikariyotto, gooto e taalibaaɓe sappo e ɗiɗo ɓeen, yehi to hooreeɓe almaami'en faa watta Iisaa e juuɗe muɓɓen. ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Nde ɓe nannoo ɗum ndeen, ɓe ceyii, ɓe aadii ɓe njoɓan mo ceede. Wakkati oon, imo fiya dabare no o jambortoo Iisaa. ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Nyannde arande iidi buuru mo wattaaka rabilla, nde ɓe kirsata dammuuli iidi Faltagol ndeen, taalibaaɓe Iisaa ƴami ɗum, mbi'i: —Toy njiɗɗaa min njaha min cegilanowe hiraande iidi Faltagol ndeen? ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","O nuli taalibaaɓe makko ɗiɗo, o wi'i ɗum'en: —Njehee ngalluure toon, on kawran toon e gorko ina ronndii loonde ndiyam. Njokkon ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Suudu ndu o naati fuu, mbi'on jom galle oon: «Moodibbo ƴamii suudu nduye nyaamdata e taalibaaɓe mum ɓeen hiraande iidi Faltagol?» ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","O hollan on suudu sooro mawndu moƴƴinaandu. Wo dow toon cegilantoɗon en hiraande ndeen. ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Taalibaaɓe ɗiɗo ɓeen njehi, naatowi ngalluure ndeen, ɓe tawri hono no o wi'iri ɓe noon. Toon ɓe cegilanii hiraande iidi Faltagol ndeen. ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Nde hiirnoo fuu, Iisaa wardi e sappo e ɗiɗo ɓeen. ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Wakkati ɓe njooɗinoo iɓe nyaama fu, Iisaa wi'i: —Goonga kaalanammi on: gooto mooɗon jamboto kam, imo nyaamda e am joonin. ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ɗum laatanii ɓe kaɓɓu-ko'u, ɓe puɗɗi ƴamirde mo gooto gooto, iɓe mbi'a: —Kori wanaa miin? ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","O jaabii ɓe, o wi'i: —Wo gooto mooɗon, onon sappo e ɗiɗo ɓe, cuuwidinɗo e am junngo e le'al ngal. ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Tilay Ɓii Neɗɗo yoppira adunaaru no haaliraa ley Binndi ɗiin ni. Ammaa bone woodanii jambotooɗo Ɓii Neɗɗo oon! Gorko oon, si rimaakano fey ɓuri woodde e muuɗum! ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Nde ɓe nyaamannoo ndeen, Iisaa hooƴi buuru, yetti Laamɗo, heltii, hokki ɓe, wi'i: —Njaɓee, ɗum wo ɓanndu am. ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Caggal ɗuum, o hooƴi horde cabijam, o yetti Laamɗo, o hokki ɓe, ɓe fuu ɓe njari. ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","O wi'i ɓe: —Ɗum wo ƴiiƴam am, tabintinoojam amaana Laamɗo, ndufeteeɗam saabe heewɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Goonga kaalanammi on: mi yarataa cabijam katin si wanaa nyannde njaroymi kesam e ley laamu Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Caggal ɓe njimii Jabuura, ɓe njalti, ɓe njehi dow waamnde wi'eteende Jaytun. ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Iisaa wi'i ɓe: —On fuu on njoppan kam, sabo ina winndaa: «Mi fiyan duroowo piiɗe maayde, de baali ɗiin cankitoo.» ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ammaa caggal mi iirtake, mi artoyto on Galili. ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Piyeer wi'i mo: —Fay si ɓe fuu ɓe njoppi ma, miin kaa mi yoppataa ma. ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Iisaa wi'i mo: —Goonga kaalanammaami: jemma hannden o pay, fadde ndontoori e joggude kile ɗiɗi a wi'an a anndaa kam kile tati. ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","De Piyeer haali, tekkini daande, wi'i: —Fay si tilsi mi maaydan e maaɗa, abada mi wi'ataa mi anndaa ma. Taalibaaɓe ɓeen fuu mbi'i hono noon. ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ɓe njottii nokku bi'eteeɗo Geccemane, de Iisaa wi'i taalibaaɓe muuɗum ɓeen: —Njooɗee ɗo, faa mi waɗowa du'aare. ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","O yaadi e Piyeer e Yaakuuba e Yuhanna. Ɓernde makko fuɗɗi maatude kulol e kaaɗeefi. ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","O wi'i ɓe: —Mettorgal ina mawni e am sanne faa ina nesa warude kam. Keddee ɗo, ndoomee, kakkilee. ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","O toowti seeɗa, o hippii e leydi, o du'ii yalla imo daɗa e wakkati naawɗo oon si na laatoo. ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","O wi'i: —Abba! Aɗa waawi huunde fuu, woɗɗinam horde torra nde. Ammaa taa laatoo ko muuyumi, ɗum laatoo ko muuyuɗaa. ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","O warti, o tawi iɓe ɗaanii. O wi'i Piyeer: —Simon, a ɗaani naa? A walaa semmbe doomude fay haddi wawtu gooto naa? ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Kakkilee, ndu'ee, faa taa on njarribe. Sabo hakkillo ina heewi anniya lobbo, ammaa terɗe ina lokkiɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","O yehi katin, o du'orii no arande ni. ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","O warti, o tawi ɓe ɗaantake, sabo ɗoyngol maɓɓe na teddi sanne. Ɓe kunngii anndude ko ɓe njaabotoo mo. ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","O warti tataɓerde, o wi'i ɓe: —Faa joonin on ɗaani, oɗon ŋootta naa? Heƴii. Wakkati oon warii. Joonin, Ɓii Neɗɗo wattete e juuɗe luttuɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ummee njehen! Inan jambotooɗo kam oon ina ɓattitii. ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","O tilaaki e haalde ɗum, de Yahuuda, gooto e sappo e ɗiɗo ɓeen, yottii ina wondi e yimɓe heewɓe jogiiɓe kaafaaje e cabbi. Wo ɓe nulaaɓe hooreeɓe almaami'en, e jannginooɓe Tawreeta, e mawɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Jambotooɗo mo oon hokkiino ɓe filnde, wi'i: —Mo mucciimi fu, oon woni kanko. Nanngon ɗum, njaaron ɗum kawjoɗon ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Yahuuda yottii tan, ɓattitii Iisaa, wi'i ɗum: —Moodibbo! O muccii ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ndeen ɓe tuggi juuɗe maɓɓe dow Iisaa, ɓe nanngi ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Gooto e darinooɓe ɗoon ɓeen, soorti kaafaahi muuɗum, soppi maccuɗo Almaami Mawɗo, taƴi nowru muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Iisaa wi'i ɓe: —On ngardii e kaafaaje e cabbi hono wo mi ardiiɗo muurtere naa? ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Nyannde fuu miɗo wondunoo e mooɗon ley suudu dewal mawndu nduun miɗo waajoo, de on nanngaay kam. Ammaa tilay ko Binndi ɗiin mbi'i ɗuum tabita. ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ndeen, taalibaaɓe ɓeen fuu njoppi mo, ndoggi. ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Jokolle mo ɓornaaki na waanii disaare tan, jokki mo. Ɓe nanngi ɗum, ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","de yoppi disaare ndeen, doggi ɓanndu ɓoldu. ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ɓe njaari Iisaa to Almaami Mawɗo oon, tawi hooreeɓe almaami'en e mawɓe e jannginooɓe Tawreeta fuu ina kawriti. ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Piyeer ina jokki mo to toowti faa naati ley taliyaare galle Almaami Mawɗo. O jooɗodii e doomooɓe ɗakkol yiite, imo ƴuuloo. ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Wooɗi, hooreeɓe almaami'en e jeyaaɓe e waalde Saahiiɓe ndeen fuu ina piloo ko pelira Iisaa faa waree, de ɓe keɓaay. ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Heewɓe ina pela mo dow fewre, ammaa haalaaji muɓɓen ina luttunduri. ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Woɓɓe maɓɓe peli mo, mbi'i: ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Min nanii imo wi'a: «Mi liɓan suudu dewal mawndu mahiraandu juuɗe nduun, de ley balɗe tati mi nyiɓa suudu dewal wonndu ndu mahiraaka juuɗe.» ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Kaa e ɗum du, pelooje maɓɓe ɗeen ina luttunduri. ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Almaami Mawɗo oon ummii, darii hakkunde jamaa oon, ƴami Iisaa: —Walaa ko njaabotoɗaa naa? Ko yimɓe ɓe ceedante ɗuum wo ɗume? ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ɗum fuu imo deƴƴinii, o jaabaaki fay huunde. Almaami Mawɗo oon ina ƴama mo katin, ina wi'a: —Yalla aan woni Almasiihu, ɓii mo jettooje ngoodani oon naa? ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","O jaabii, o wi'i: —Miin woni kanko. On nji'an Ɓii Neɗɗo ina jooɗii gere nyaamo Jom baawɗe oon, ina warda e duule kammu. ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ɗuum metti Almaami Mawɗo oon faa seeki kaddule muuɗum, wi'i: —En kaajaaka seedeeɓe katin. ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","On narrii noppi mooɗon ko o mbonkii Laamɗo ɗuum. Ɗume miiliɗon? Ɓe fuu ɓe mbi'i imo haani wareede. ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Woɓɓe maɓɓe puɗɗi tuttude dow makko. Ɓe cuddi yeeso makko, iɓe piya mo, iɓe mbi'a mo: —Hey annabaajo! Haalan min moy fiyi ma! Ndeen doomooɓe ɓeen du nanngi mo, ina peenya mo. ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","E ley ko Piyeer woni ley taliyaare galle oon, gooto e horɓe Almaami Mawɗo oon yottii. ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Nde o yiinoo Piyeer ina ƴuuloo ndeen, o taykii ɗum, o wi'i: —Aan, aɗa wondunoo e Iisaa Nasaraatuujo oon. ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Piyeer yeddi mo, wi'i: —Miin kaa mi anndaa, mi faamataa ko kaalataa ɗuum. Caggal ɗuum, Piyeer yehi naatowi bolongal galle ngaal. Ndeen ndontoori joggi. ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Nde korɗo oon yiinoo mo katin fu, haalani dariiɓe ɗoon ɓeen, wi'i: —Oo wo gooto maɓɓe! ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Piyeer yeddi katin. Faa ɓooyti seeɗa, dariiɓe ɗoon ɓeen mbi'i Piyeer: —Tannyoral, a gooto maɓɓe, sabo a Galilinkeejo. ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Kanko du, o fuɗɗi hunaade e huttaade, imo wi'a: —Mi anndaa gorko mo kaaloton haala mum oon fey! ");
INSERT INTO fuhbkf_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Wakkati oon pay, ndontoori joggi ɗiɗaɓerde, de Piyeer miccitii ko Iisaa wi'unoo ɗuum: «Fadde ndontoori e joggude kile ɗiɗi, a wi'an a anndaa kam kile tati.» Ɓernde Piyeer metti dow majjum, heddii ina woya. ");
INSERT INTO fuhbkf_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Nde naange fuɗunoo fu, hooreeɓe almaami'en e jannginooɓe Tawreeta e waalde Saahiiɓe ndeen fuu, tawti mawɓe du, ɓe fuu ɓe ndawridi. Ɓe kaɓɓi Iisaa, ɓe njaari ɗum, ɓe ngatti ɗum e juuɗe Pilaatu goforneer oon. ");
INSERT INTO fuhbkf_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilaatu ƴami mo, wi'i: —Aan woni kaananke Alhuudiyankooɓe oon naa? O jaabii, o wi'i: —Aan e hoore maa haali. ");
INSERT INTO fuhbkf_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Hooreeɓe almaami'en ɓeen ina pelda mo kulle keewɗe. ");
INSERT INTO fuhbkf_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilaatu ƴami mo katin: —Walaa ko njaabotoɗaa naa? A nanaay ko ɓe peldete ɗuum fuu naa? ");
INSERT INTO fuhbkf_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ammaa Iisaa jaabaaki fay huunde, faa ɗum haaynii Pilaatu. ");
INSERT INTO fuhbkf_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Iidi Faltagol fuu, goforneer oon ina woowi yoofande yimɓe ɓeen kasuujo gooto mo cuɓii. ");
INSERT INTO fuhbkf_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Tawi gorko bi'eteeɗo Barabas muurtidiino e woɓɓe faa ɓe mbari neɗɗo. Wakkati oon, iɓe uddaa e kasu saabe ko ɓe ngaɗi ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Jamaa oon njehowi to Pilaatu woni toon, naati e nyaagaade ɗum waɗana ɓe ko woownoo waɗande ɓe ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","O jaabii ɓe, o wi'i: —Oɗon njiɗi mi yoofana on kaananke Alhuudiyankooɓe oon naa? ");
INSERT INTO fuhbkf_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Sabo o faamii hooreeɓe almaami'en ɓeen kiram waɗi de kokkitiri mo. ");
INSERT INTO fuhbkf_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","De hooreeɓe ɓeen ndunƴi jamaa oon nyaagoo Pilaatu yoofana ɓe Barabas, ɗum ɓurani ɓe yoofa Iisaa. ");
INSERT INTO fuhbkf_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilaatu jaabii katin, wi'i ɓe: —Ndelle, ɗume njiɗuɗon mi waɗa mo mbi'oton kaananke Alhuudiyankooɓe oon? ");
INSERT INTO fuhbkf_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ɓe ƴeewnii, ɓe mbi'i: —Tontu mo e leggal palaangal! ");
INSERT INTO fuhbkf_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilaatu ƴami ɓe: —Ɗume o waɗi ko boni? De ɓe ɓeydi ƴeewnaade semmbe: —Tontu mo e leggal palaangal! ");
INSERT INTO fuhbkf_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Saabe Pilaatu ina yiɗi welnude ɓerɗe jamaa oon, yoofani ɗum'en Barabas. Caggal ɗuum, o yamiri Iisaa fiyee dorri, de o hokkitiri ɗum tontowee e leggal palaangal. ");
INSERT INTO fuhbkf_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Sordaasiiɓe ɓeen njaari mo nannowi mo ley galle laamorde toon, kawrunduri sordaasiiɓe heddiiɓe ɓeen fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ɓe ɓorni mo saaya mboɗeeha, ɓe canyi taarde gi'e ɓe kippi e hoore makko. ");
INSERT INTO fuhbkf_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ɓe puɗɗi salminde mo, iɓe mbi'a: —Foofoo, kaananke Alhuudiyankooɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Iɓe piira hoore makko loosol, iɓe tutta mo, iɓe ndikkinoo, iɓe cujidana mo. ");
INSERT INTO fuhbkf_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Nde ɓe tilinoo jalnoraade mo ndeen, ɓe itti saaya mboɗeeha kaan, ɓe ɓorni mo kaddule makko. Ndeen ɓe njaari mo yaasin faa ɓe tontowa mo e leggal palaangal. ");
INSERT INTO fuhbkf_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Gorko gooto bi'eteeɗo Simon, jeyaaɗo Sireene, baaba Alesandere e Rufus, ina ƴuura ley ladde ina faltoo ɗoon. Sordaasiiɓe ɓeen ndoolɗi mo o wakkoo leggal Iisaa palaangal ngaal. ");
INSERT INTO fuhbkf_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ɓe njaari Iisaa nokku bi'eteeɗo Golgata (maanaa majjum woni «Nokku Laalagal Hoore»). ");
INSERT INTO fuhbkf_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ɓe ngaddani mo cabijam njillunduraaɗam e ɗakke kaaɗuɗe faa o yara, de o jaɓaay. ");
INSERT INTO fuhbkf_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ɓe tonti mo e leggal palaangal. Ɓe pecciri kaddule makko cumnal, ɓe ndaara ko mono fuu heɓata. ");
INSERT INTO fuhbkf_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Nde ɓe tontata mo ndeen, wo wakkati yamnde jeenay beetee. ");
INSERT INTO fuhbkf_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ɓe mbinndi e alluwal tiimtude hoore makko sabaabu ko o tontiraa. Binndi dow maggal na mbi'a: Kaananke Alhuudiyankooɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ɓe tontidi mo e yanooɓe ɗiɗo, gooto gere nyaamo makko, gooto du gere nano makko.  ");
INSERT INTO fuhbkf_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Yimɓe faltotooɓe ɗoon ɓeen ina njenna mo, ina ndimmba ko'e muɓɓen, ina mbi'a: —Hey! Liɓoowo suudu dewal mawndu de nyiɓtoo ndu ley balɗe tati, ");
INSERT INTO fuhbkf_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","dannu hoore maa, jippa leggal palaangal ngal! ");
INSERT INTO fuhbkf_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Hono noon, hooreeɓe almaami'en ɓeen du ina njalnoroo mo. Kamɓe e jannginooɓe Tawreeta, iɓe mbi'undura hakkunde maɓɓe: —O hisinii woɓɓe, de o waawaa hisinde hoore makko! ");
INSERT INTO fuhbkf_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kanko woni Almasiihu kaananke Israa'iila oon. Jonle, o jippoo leggal palaangal ngal, faa nji'en de ngoonɗinen! Ɗiɗo tontidaaɓe e makko ɓeen du ina mbonkoroo mo noon. ");
INSERT INTO fuhbkf_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Wakkati hakkunde naange, nimre waɗi e leydi fuu faa wakkati yamnde tati kiiral naange. ");
INSERT INTO fuhbkf_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","E ley yamnde tati kiiral naange ndeen, Iisaa feekii feekaango toowngo, wi'i: — Eloy, eloy, lama sabaktani? (Ɗum na fiirta «Laamɗo am, Laamɗo am! Ɗume saabii de njoppuɗaa kam?») ");
INSERT INTO fuhbkf_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Nde woɓɓe dariiɓe toon ɓeen nannoo ɗum ndeen, mbi'i: —Inan, imo nodda annabi Iliyaasa! ");
INSERT INTO fuhbkf_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ndeen goɗɗo maɓɓe doggi, suuwowi tekkere ley ndiyam lammuɗam, haɓɓi nde e loosol. De o fonndini hunnduko Iisaa faa muyta, o wi'i: —En njoppa mo, ndaaren yalla Iliyaasa waran jippina mo! ");
INSERT INTO fuhbkf_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Caggal ɗuum, Iisaa feekii feekaango toowngo katin, de seedi e yonki. ");
INSERT INTO fuhbkf_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Lefol paliingol ley suudu dewal mawndu ngool seekii gilla dow faa ley, laatii taƴe ɗiɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Mawɗo sordaasiiɓe darinooɗo yeeso makko oon yi'i no o dilliri adunaaru ni, de wi'i: —Si goonga ni, neɗɗo o wo Ɓii Laamɗo! ");
INSERT INTO fuhbkf_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Rewɓe woɓɓe ina toowti, ina kaynoo. Mariyama mo Magdala e Salome e Mariyama inna Yaakuuba pamarel e Yuusufi ina ngoni hakkunde maɓɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ɓeen njokkannoo mo ina ngollana mo nde o wonnoo Galili ndeen. Rewɓe woɓɓe heewɓe du ina ngoni ɗoon, yaadunooɓe e makko Urusaliima. ");
INSERT INTO fuhbkf_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ko hiiri ɗuum, tawi hawrii e wakkati segilagol, sabo nyalaande fowteteende ɓadake naatude. ");
INSERT INTO fuhbkf_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Gooto tedduɗo e waaldeere Saahiiɓe, bi'eteeɗo Yuusufi mo Arimatiya, wari. Kanko du imo heɗii ɓangugol laamu Laamɗo. O hulaay yaade to Pilaatu o ŋaaroo ɗum ɓanndu Iisaa. ");
INSERT INTO fuhbkf_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ko Iisaa maayi law ɗuum, haaynii Pilaatu, noddi mawɗo sordaasiiɓe, ƴami ɗum yalla wo goonga o maayii. ");
INSERT INTO fuhbkf_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Nde mawɗo sordaasiiɓe oon haalannoo ɗum Pilaatu ndeen, acci Yuusufi hooƴa ɓanndu nduun. ");
INSERT INTO fuhbkf_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yuusufi soodi kasanke, jippini ɓanndu Iisaa nduun, fiili ɗum e kasanke oon, de watti ɗum e saabeere wasaande ley hayre. Caggal ɗuum, o talliti hayre, o uddiri dammbugal saabeere ndeen. ");
INSERT INTO fuhbkf_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mariyama mo Magdala e Mariyama inna Yuusufi nji'i to o wattaa toon. ");
INSERT INTO fuhbkf_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Nde nyalaande fowteteende faltinoo ndeen, Mariyama mo Magdala e Salome e Mariyama inna Yaakuuba coodi nebbeele uurɗe faa njaha, ngatta e ɓanndu Iisaa. ");
INSERT INTO fuhbkf_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Nyannde go'aɓerde e jeɗɗiire ndeen, rewɓe ɓeen ngari to saabeere ndeen illa law, wakkati puɗal naange. ");
INSERT INTO fuhbkf_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Iɓe mbi'undura: —Moy tallitanta en hayre wonnde e dammbugal saabeere ndeen? ");
INSERT INTO fuhbkf_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ammaa nde ɓe ɓantunoo gite maɓɓe ndeen, ɓe nji'i hayre ndeen tallitaama. Inde mawni sanne. ");
INSERT INTO fuhbkf_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Wakkati ɓe naatunoo e saabeere ndeen, ɓe nji'i jokolle ina jooɗii gere nyaamo ina ɓornii saaya ndaneeha, de ɓe kuli. ");
INSERT INTO fuhbkf_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","O wi'i ɓe: —Taa kulee! Oɗon piloo Iisaa Nasaraatuujo tontanooɗo oon. O iirtake, o walaa ɗo. Inan nokku ɗo o wattanoo ɗoon. ");
INSERT INTO fuhbkf_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Joonin kaa, njehee, mbi'owee taalibaaɓe makko ɓeen e Piyeer o artoyto on Galili. Toon nji'oyton mo, hono no o wiirunoo on noon. ");
INSERT INTO fuhbkf_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Rewɓe ɓeen njalti saabeere ndeen, ndoggi. Iɓe ndiwna kulol, iɓe mbemmbii sanne. Ɓe kaalanaay fay gooto huunde ndeen no ɓe poti hulude. ———————————————— ");
INSERT INTO fuhbkf_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Illa fajiri nyannde go'aɓerde e jeɗɗiire, Iisaa iirtake. Caggal ko o iirtii ɗuum, o artii o ɓangi e Mariyama jeyaaɗo Magdala mo o riiwnoo ginnaaji jeɗɗi e muuɗum oon. ");
INSERT INTO fuhbkf_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Mariyama yehi humpitoyde kabaaru oon wondunooɓe e Iisaa ɓeen, tawi iɓe cunii iɓe mboya. ");
INSERT INTO fuhbkf_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ammaa ko ɓe nani o iirtake e ko Mariyama yi'i mo ɗuum fu, ɓe ngoonɗinaay ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Caggal ɗuum, o ɓangi e ɗiɗo maɓɓe e tagaadi ngonndi, iɓe nanngi laawol jahoowol ladde. ");
INSERT INTO fuhbkf_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Kamɓe du, ɓe ngarti ɓe kumpiti heddiiɓe ɓeen, de ɓeen ngoonɗinaay ɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Sakitii, o ɓangi e taalibaaɓe sappo e ngo'o ɓeen wakkati mo ɓe nyaamata. O feliri ɓe rafi goonɗinal maɓɓe e yoorde ɓerɗe maɓɓe, sabo ɓe ngoonɗinaay yiiɓe mo caggal ummitagol makko ɓeen. ");
INSERT INTO fuhbkf_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","O wi'i ɓe: —Njehee ley adunaaru ndu fuu, mbaajoɗon tagaaɗo fuu Kabaaru Lobbo o. ");
INSERT INTO fuhbkf_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Goonɗinɗo de lootaa lootagal batisima fu, hisinte. Mo goonɗinaay jukkete. ");
INSERT INTO fuhbkf_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Kaayeefiiji ɗi ina ngoodani goonɗinɓe ɓeen: ɓe ndiiwran ginnaaji saabe am, ɓe kaalan ɗemle kese, ");
INSERT INTO fuhbkf_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ɓe nanngiran bolle e juuɗe maɓɓe. Fay si ɓe njari poson, fay huunde waɗataa ɓe. Ɓe njowan juuɗe maɓɓe e nyawɓe de cella. ");
INSERT INTO fuhbkf_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Gaɗa Iisaa Joomiraaɗo haaldii e maɓɓe, ƴeentinaa dow kammu, jooɗii gere nyaamo Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","De kamɓe kaa, ɓe njehi iɓe mbaajowoo ley nokkuuje fuu. Joomiraaɗo ina wondi e maɓɓe, tabintiniri konngol ngol e maandeeji kaayniiɗi jaadooji e maggol.");
INSERT INTO fuhbkf_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Yimɓe heewɓe pilake fillitaade kulle tabitinɗe hakkunde meeɗen. ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ɓe mbinndii ko seediiɓe gilla fuɗɗoode ɓeen kaalani en. Seediiɓe ɓeen ngoni halfinaaɓe faa anndina konngol ngool. ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Tawfilus tedduɗo, mi taykake kulle ɗeen fuu faa wooɗi gilla arande, mi tawii na hawrani kam miin du faa mi winndane, mi fiirtane ɗum faa laaɓa no ɗum waɗiri, ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","faa keɓaa tannyoral jannde nde njannginaɗaa ndeen wo goonga. ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Wakkati jamaanu Hirudus, kaananke Yahuudiya, na woodi almaami gomma bi'eteeɗo Jakariyaa. Imo jeyaa e waaldeere Abiya, ɓii Haaruuna. Dee Jakariyaa du wo ƴuwdi Haaruuna, innde muuɗum wo Elisabet. ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ɓe ɗiɗo fuu ɓe fonnditiiɓe to Laamɗo. Iɓe njokki jamirooje Joomiraaɗo e sariyaaji muuɗum fuu. Feloore fuu walaa e maɓɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ɓe keɓaay ɓiɗɗo, sabo Elisabet wo dimaro. Ɓe ɗiɗo fuu ɓe naywii du. ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Nyannde gomma, Jakariyaa ina golla golle muuɗum yottinde sadakaaji yeeso Laamɗo, sabo wakkati oon wo waaldeere makko jeyti gollal ngaal. ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ley al'aada almaami'en iɓe mboownoo waɗude cumnal. Wo nii Jakariyaa suɓiraa faa naata nokkuure seniinde wonnde ley suudu dewal mawndu, de ura toon ure. ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Jamaa oon fuu darii yaasin ina waɗa du'aare wakkati mo ure ɗeen mbuletee. ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Wakkati oon maleyka Joomiraaɗo ɓangani mo, ina darii gere nyaamo nokkuure urirde ndeen. ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Nde Jakariyaa yi'unoo maleyka oon ndeen, nesim taƴi, kulol nanngi ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Maleyka oon wi'i mo: —Jakariyaa taa hulu, sabo du'aare maa jaabaama. Deeka Elisabet rimante ɓiɗɗo gorko, inndiraa ɗum Yaayaa. ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ɓiɗɗo oon waddante seyo manngo, heewɓe ceyorto rimeede makko, ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","sabo o laatoto tedduɗo yeeso Joomiraaɗo. O yarataa doro, o yarataa huunde fuu ko sulinta. O heewan Ruuhu Ceniiɗo gilla e ley reedu inniiko. ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","O wartiran ɓiɓɓe Israa'iila heewɓe to Laamɗo Joomiraaɗo muɓɓen. ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","O artoto Joomiraaɗo warde, o wonda e ruuhu e baawɗe ɗe annabi Iliyaasa heɓunoo, faa o wartira ɓerɗe baabiraaɓe to ɓiɓɓe muɓɓen, faa o wartira saliiɓe du e hakkillooji dartiiɓe, faa moƴƴinana yimɓe segilaniiɓe garol Joomiraaɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Jakariyaa ƴami maleyka oon, wi'i: —Noy paamirammi ɗum wo goonga? Sabo miin mi naywii, deekam oon du waɗi duuɓi. ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Maleyka oon jaabii mo, wi'i: —Miin woni Jibiriilu ɗakkiiɗo Laamɗo, mi nulaaɗo to maaɗa faa mi haalane kabaaru lobbo o. ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ndelle joonin a muumɗan. A haalataa si wanaa wakkati mo ɗum tabiti, sabo a goonɗinaay haala am. Haala am ka tabitowan nde wakkati majjum wari. ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Tawi yimɓe ɓeen ina keɗii Jakariyaa, ina haaynii ɗum'en ko o ɓooyi ley suudu dewal mawndu ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Nde o wurtinoo ndeen, o hunngii haaldude e maɓɓe. Ɓe paami won ko o hollaa ley suudu dewal mawndu nduun. Imo haalda e maɓɓe muummumre, o heddii o waawaa haalde. ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Nde balɗe golle makko tilinoo ndeen, o hooti suudu makko. ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Caggal balɗe ɗeen, Elisabet deekiiko oon hooƴi reedu, dammbii haddi lebbi joy, ina wi'a: ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","—Ɗum woni ko Joomiraaɗo waɗani kam. O taykake kam, o ittanii kam dukkuru hakkunde yimɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ley lewru Elisabet jeegaɓurdu nduun, Laamɗo nuli maleyka Jibiriilu e wuro wi'eteengo Nasaraatu ley leydi Galili, ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","to surbaajo mo taan Daawda bi'eteeɗo Yuusufi haɓɓani. Surbaajo oon ina wi'ee Mariyama. ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Maleyka oon naati ɗo Mariyama woni ɗoon, wi'i ɗum: —Aan e jam, keɓuɗo moƴƴere Joomiraaɗo. Joomiraaɗo ina wondi e maaɗa. ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Haala kaan wemmbi Mariyama sanne, ina miiloo ɗume jowtaango ngo fiirtata. ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","De maleyka oon wi'i mo: —Taa hulu, Mariyama! Sabo a heɓii moƴƴere ƴuurunde e Laamɗo, ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","a hooƴan reedu, ndimaa ɓiɗɗo gorko, inndiraa ɗum Iisaa. ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ɓiɗɗo oon laatoto tedduɗo, o noddirte Ɓii Laamɗo Toowɗo. Laamɗo Joomiraaɗo hokkan mo laamu maamiiko Daawda. ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","O laamoto ƴuwdi Yaakuuba faa abada, laamu makko walaa timmoode. ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mariyama wi'i maleyka oon: —Noy ɗum laatortoo, sabo mi anndaa gorko? ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Maleyka oon jaabii mo, wi'i: —Ruuhu Ceniiɗo jippoto e maaɗa, baawɗe Laamɗo Toowɗo cuddete. Saabe ɗuum, ɓiɗɗo mo ndimataa oon inndirte Ceniiɗo, Ɓii Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ndaar, sakiike maa Elisabet du hooƴii reedu ley nayeewu muuɗum, o riman ɓiɗɗo gorko. Imo wi'enoo wo o dimaro, de joonin kaa imo wondi e reedu lewru jeegaɓurdu, ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","sabo walaa fuu ko Laamɗo waawaa. ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Wakkati oon, Mariyama wi'i: —Inani kam, miin korɗo Joomiraaɗo, ɗum laatoranoo kam no mbiiruɗaa ni. Ndeen maleyka oon dilli to makko. ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","E ley balɗe ɗeen, Mariyama ummii, yehi law to wuro gomma wonngo ley baamle Yahuudiya. ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","O naati suudu Jakariyaa, o jowti Elisabet. ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Nde Elisabet nannoo jowtaango makko ndeen, ɓiɗɗo gonɗo e reedu muuɗum oon dimmbii. Ndeen Elisabet hebbinaa Ruuhu Ceniiɗo, ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ƴeewnii e daande toownde, wi'i: —A barkinaaɗo hakkunde rewɓe! Ɓiɗɗo mo ndeeduɗaa o du wo barkinaaɗo! ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Miin, wo mi ɗume faa inna Joomiraaɗo wari to am? ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ndaar, nde jowtaango maa yottinoo nowru am ndeen, ɓiɗɗo gonɗo e reedu am oon dimmborake kuyam. ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Barke woodanii ma, aan goonɗinɗo ko Joomiraaɗo haalani maa ɗuum tabitan. ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mariyama wi'i: —Yonki am ina mana Joomiraaɗo! ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ɓernde am ina heewi seyo e dow Laamɗo Kisinoowo kam, ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","sabo o yurmake kam, miin, korɗo makko leeƴuɗo. Gilla joonin jamaanuuji fuu noddiran kam barkinaaɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Sabo Jom baawɗe waɗanii kam kulle mawɗe! Innde muuɗum wo seniinde. ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Yurmeende muuɗum ina woni dow hulooɓe ɗum jamaanu dow jamaanu. ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","O gollii golleeji mawɗi e semmbe junngo makko, o sankitii mawninkiniiɓe e anniyaaji muɓɓen. ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","O saamdinii kaanankooɓe e laamuuji muɓɓen, o toownii leeƴuɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","O haarnirii yolbuɓe kulle lobbe, o yoppii jom'en jawdi juuɗe ɓole. ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","O wallii yimɓe Israa'iila, maccuɓe makko ɓeen, sabo o yeggitaay ko o haaldunoo e maamiraaɓe meeɗen, yurmaade Ibrahiima e ƴuwdi muuɗum faa abada. ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mariyama waddi e Elisabet ko waɗata lebbi tati de yeccii suudu muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Wakkati ndimu Elisabet yottii, o rimi ɓiɗɗo gorko. ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Hoddiiɓe makko e sakiraaɓe makko nani yurmeende mawnde nde Joomiraaɗo waɗani mo ndeen, ceyodii e makko. ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Nde cukalel ngeel waɗunoo nyalaaɗe jeetati ndeen, ɓe ngari taadude ngel. Iɓe njiɗunoo inndirde ngel innde baabiigel Jakariyaa, ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ammaa inniigel jaɓaay, wi'i ngel inndiree Yaayaa. ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ɓe mbi'i ɗum: —Yimɓe maa fuu walaa inndiraaɗo innde nde. ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ɓe ƴami baabiigel e muummumre, noy yiɗi ɓiyum oon inndiree. ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Jakariyaa ƴamani alluwal, winndi dow maggal: «Yaayaa woni innde maggel.» Ɓe fuu ɗum haaynii ɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Wakkati oon pay, hunnduko Jakariyaa yoppaa, ɗemngal mum haɓɓitaa, ina haala, ina yetta Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Kulol nanngi hoddiiɓe makko ɓeen fuu. Katin du yimɓe ley baamle Yahuudiya fuu ina kaala kabaaruuji ɗiin. ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Nanɓe ɗum ɓeen fuu ndesi ɗum e ley ɓerɗe muɓɓen, ina mbi'a: «Ndelle ɗume cukalel ngel laatoytoo?» Sabo ɓe nji'ii junngo Joomiraaɗo ina woni dow maggel. ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Jakariyaa, baaba cukalel ngeel, heewi Ruuhu Ceniiɗo, haaldi annabaaku, wi'i: ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","—Jettooje ngoodanii Joomiraaɗo, Laamɗo Israa'iila, sabo warii walli yimɓe muuɗum, rimɗini ɗum'en. ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","O waddanii en Kisinoowo jom semmbe ƴuwɗo e suudu Daawda, maccuɗo makko. ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ɗum fuu ɗum laatorii hono no o haalirnoo e kunnduɗe annabaaɓe makko seniiɓe gilla arande - ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","o wi'i o hisinan en e habdiiɓe men, e juuɗe wayɓe en fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Nii o yottiniri yurmeende nde o aadaninoo maamiraaɓe men ndeen, o miccitake amaana makko ceniiɗo, ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","hunayeere nde o hunanii maammen Ibrahiima, o hokkan en ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","danneede e juuɗe wayɓe en faa ngolliranen mo rafi kulol, ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ndewen mo ley senaare e dartaare yeeso makko haddi nguurndam meeɗen fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Aan du cukalel, a noddirte annabaajo Laamɗo Toowɗo, sabo a artoto Joomiraaɗo warde faa moƴƴinanaa mo laabi makko, ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","faa anndinaa yimɓe makko laawol kisindam ley ko o yaafotoo hakkeeji muɓɓen. ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Saabe Laamɗo meeɗen wo keewɗo yurmeende, Jayngol ƴuurungol dow ina wara to meeɗen, ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","faa yaynana wonɓe ley nimre e kulol maayde, de rewna koyɗe men dow laawol jam. ");
INSERT INTO fuhbkf_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Suka oon ina mawna, hakkillo muuɗum ina ɓeydoo. O jooɗii ley ladde faa wakkati mo o ɓanginaa e Israa'iila. ");
INSERT INTO fuhbkf_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","E ley balɗe ɗeen, Agustus kaananke mawɗo yamiri limgal waɗee ley laamu Roma fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Kangal woni limgal arandeyal, kawrungal e laamu Kiriniyus goforneer leydi Siiriya. ");
INSERT INTO fuhbkf_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Yimɓe fuu njehi winndowaade, mono fuu e wuro muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yuusufi du dilli Nasaraatu ley leydi Galili, faa yaha wuro Daawda wi'eteengo Baytilaama ley leydi Yahuudiya, sabo e lenyol Daawda jaati o ƴuuri. ");
INSERT INTO fuhbkf_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","O yehi toon winndowaade, kanko e Mariyama kaɓɓanaaɗo makko, deeduɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","E ley gonal maɓɓe toon, wakkati ndimu Mariyama yottii. ");
INSERT INTO fuhbkf_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","O rimi afo makko, o saawi ɗum e kaddule, o fukkini ɗum ley akalawal, sabo ɓe keɓaay nokkuure ley jipporde ndeen. ");
INSERT INTO fuhbkf_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Durooɓe ina ngoni ley seraaji ɗiin, na ndooma dammuuli muɓɓen jemma. ");
INSERT INTO fuhbkf_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Maleyka Joomiraaɗo ɓangani ɓe, darja Joomiraaɗo ɗelkoowo fiilii ɓe. Kulol manngol nanngi ɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","De maleyka oon wi'i ɓe: —Taa kulee! Sabo miɗo haalana on Kabaaru Lobbo laatantooɗo yimɓe fuu seyo manngo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Hannden on ndimanaama Kisinoowo ley wuro Daawda. Kanko woni Almasiihu, kanko woni Joomiraaɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Inan maande majjum: on tawan cukalel keccel ina saawaa e kaddule, ina fukkinaa ley akalawal. ");
INSERT INTO fuhbkf_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Wakkati gooto, maleyka'en heewɓe ƴuuri dow kammu, tawti maleyka artiiɗo oon, ina njetta Laamɗo, ina mbi'a: ");
INSERT INTO fuhbkf_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","—Manngu woodanii Laamɗo faa dow kammuuli, dow leydi du jam woodanii yimɓe ɓe o horsini. ");
INSERT INTO fuhbkf_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Nde maleyka'en ɓeen ceedunoo e maɓɓe, de ƴeenti dow kammu ndeen, durooɓe ɓeen ina mbi'undura: —En njaha Baytilaama, ndaaren ko waɗi, ko Joomiraaɗo anndini en ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ɓe karii, ɓe njehi, ɓe tawi toon Mariyama e Yuusufi e cukalel keccel ngeel, ingel fukkinaa ley akalawal. ");
INSERT INTO fuhbkf_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Nde ɓe njiinoo ngel ndeen, ɓe kaalti ko maleyka oon haalani ɓe dow maggel ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Nanɓe haala durooɓe ɓeen fuu, haaynde nanngi ɗum'en. ");
INSERT INTO fuhbkf_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","De Mariyama kaa ina resi ɗum fuu e ɓerndem, ina miiloo ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Durooɓe ɓeen njeccii, ina teddina Laamɗo, ina njetta ɗum saabe ko ɓe nani e ko ɓe nji'i fuu. Sabo ɗum fuu ɗum laatorake no maleyka oon wiirunoo ɓe noon. ");
INSERT INTO fuhbkf_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Nde cukalel ngeel waɗunoo nyalaaɗe jeetati ndeen, ngel taadaa, ngel inndiraa Iisaa. Ɗum woni innde nde maleyka oon haalannoo Mariyama gilla reedaay ndeen. ");
INSERT INTO fuhbkf_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Nde balɗe laaɓugol Mariyama yottinoo, hono no Tawreeta Muusaa yamiri, ɓe njaari suka oon Urusaliima faa ɓe kalfina mo Joomiraaɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Sabo wo hono noon winndiraa e Tawreeta Joomiraaɗo: «Ɓiɗɗo gorko afo fuu, Joomiraaɗo jeyi.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ɓe ngaɗi du sadaka kirsamaari hono no Joomiraaɗo yamiri ni: ɓiɓɓe buugaali ɗiɗi naa nyaabe ɗiɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Gorko gomma ina wonnoo Urusaliima, ina wi'ee Simeyon. Ruuhu Ceniiɗo ina woni e makko. O gorko dartiiɗo, kulɗo Laamɗo, imo heɗii wakkati mo gonɗi Israa'iila mooytetee. ");
INSERT INTO fuhbkf_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ruuhu Ceniiɗo anndinii mo o maayataa si o yi'aay Almasiihu Joomiraaɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Joonin Ruuhu nanni mo ley suudu dewal mawndu nduun wakkati mo saaraaɓe ɓeen ngaddi suka oon faa ngaɗana ɗum ko Tawreeta yamiri. ");
INSERT INTO fuhbkf_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeyon jaɓi mo, mumbilii mo, ina yetta Laamɗo, ina wi'a: ");
INSERT INTO fuhbkf_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","—Joonin Joomiraaɗo, haala maaɗa kaan tabitii. Aɗa waawi hooƴude maccuɗo maaɗa e jam, ");
INSERT INTO fuhbkf_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","sabo mi yiirii gite am kisindam maaɗa ");
INSERT INTO fuhbkf_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ɗam cegiliɗaa yeeso yimɓe fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ɗam woni annoora jaynanoowo lenyi adunaaru fuu, annoora darjinoowo lenyol maa Israa'iila du. ");
INSERT INTO fuhbkf_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ko haalaa dow makko ɗuum, haaynii baabiiko e inniiko. ");
INSERT INTO fuhbkf_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeyon barkini ɓe, wi'i Mariyama, inniiko: —Suka o warii faa laatoo sabaabu saamugol woɓɓe e ummagol woɓɓe ley Israa'iila. O laatoto maande nde yimɓe calotoo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Hono nii o ɓanginirta miilooji ɓerɗe heewɓe. Aan e hoore maa, mettorgal yuwan ɓernde maa hono kaafaahi. ");
INSERT INTO fuhbkf_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Annabaajo debbo bi'eteeɗo Anna ina ɗoon kam du. Wo o ɓii Fanuwel, jeyaaɗo e suudu Aser. O naywii sanne. O ɓaŋaama e surbaaku makko, o wondi e goriiko duuɓi jeɗɗi, ");
INSERT INTO fuhbkf_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","de maayi. O heddii o walaa goriiwo. Joonin duuɓi makko ina ngaɗa capanɗe jeetati e nay. O dillataa suudu dewal mawndu nduun fey, imo rewra Joomiraaɗo suumayeere e du'aare, jemma e nyalooma fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","E wakkati oon pay, kanko du o wari, imo yetta Laamɗo, imo haalana heɗiiɓe garol dimɗinoowo Urusaliima ɓeen fuu kabaaru suka oon. ");
INSERT INTO fuhbkf_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Nde ɓe njottinnoo huunde fuu ko Tawreeta Joomiraaɗo yamiri ndeen, ɓe njeccii wuro maɓɓe Nasaraatu ley leydi Galili. ");
INSERT INTO fuhbkf_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Suka oon ina mawna, semmbe muuɗum e hakkillo mum ina ɓeydoo. Moƴƴere Laamɗo ina woni e makko. ");
INSERT INTO fuhbkf_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Hitaande fuu, saaraaɓe Iisaa ina njaha Urusaliima wakkati iidi Faltagol. ");
INSERT INTO fuhbkf_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Nde Iisaa waɗunoo duuɓi sappo e ɗiɗi ndeen, ɓe njehi Urusaliima no ɓe mboowri noon. ");
INSERT INTO fuhbkf_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Nde iidi ndiin tilinoo ndeen, ɓe njeccii ɓe kooti, ammaa Iisaa ɓiyiiɓe oon heddake Urusaliima, tawi ɓe paamaay. ");
INSERT INTO fuhbkf_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ɓe cikkii imo wondi e yaadiraaɓe maɓɓe ɓeen. Ɓe njehi nyalooma kiɓɓuɗo, iɓe piloo mo hakkunde yimɓe maɓɓe e anndaaɓe maɓɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ammaa ɓe njiitaay mo, ɓe njeccitii Urusaliima filowaade mo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Balɗe tati gaɗa ɗum, ɓe tawi mo ley suudu dewal mawndu. Imo jooɗii hakkunde jannginooɓe, imo hettindanii ɗum'en, imo ƴamtindoo ɗum'en. ");
INSERT INTO fuhbkf_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Hettindaniiɓe mo ɓeen fuu kaaynaa hakkillo makko e jaabagol makko. ");
INSERT INTO fuhbkf_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Nde saaraaɓe makko nji'unoo mo ndeen, haaynde nanngi ɗum'en. Inniiko wi'i mo: —Ɓinngel, ko saabii ngaɗuɗaa min ni? Inan, miin e baaba maa fuu, filagol ma haɓɓii min ko'e. ");
INSERT INTO fuhbkf_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","O jaabii ɓe, o wi'i: —Ko waɗi oɗon piloono kam? Yalla on paamaay ina tilsi mi wona ley suudu Baaba am naa? ");
INSERT INTO fuhbkf_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ammaa ɓe paamaay haala ka o haalani ɓe kaan. ");
INSERT INTO fuhbkf_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Caggal ɗuum, o jippodii e maɓɓe. Ɓe koondi Nasaraatu, o ɗowtanii ɓe. Inniiko ina resi kulle ɗeen fuu e ɓernde muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Iisaa ina mawna, hakkillo muuɗum ina ɓeydoo, Laamɗo e yimɓe ina korsini mo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Konngol Laamɗo warii to Yaayaa, ɓii Jakariyaa oon, ley ladde. Ɗum hawrii e hitaande sappo e joyaɓerde laamu Tibeer kaananke mawɗo. Ndeen Pontiyu Pilaatu wonnoo goforneer Yahuudiya, Hirudus du ina laamii Galili. Sakiike mum bi'eteeɗo Filipu ina laamii leydi Ituriya e Tarakoniti, Lisaniya du ina laamii leydi Abileen. Ɗum hawrii e nde Annas e Kayafas laatinoo hooreeɓe almaami'en. ");
INSERT INTO fuhbkf_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yaayaa yiiltii e seraaji gooruwol Urdun fuu, ina gooyna yimɓe tuuba, lootiree lootagal batisima faa hakkeeji muɓɓen njaafee. ");
INSERT INTO fuhbkf_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Wo hono noon winndiraa ley dewtere haalaaji annabi Esaaya: «Daande ina ƴeewnoo ley ladde ina wi'a: Moƴƴinee laawol Joomiraaɗo, ndartinee laabi makko! ");
INSERT INTO fuhbkf_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Luggere fuu uwete, baamle e tile fuu leeƴinee, laabi oonyiiɗi fuu ndartinee, laabi bonɗi fuu moƴƴintinee! ");
INSERT INTO fuhbkf_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Neɗɗo fuu yi'an kisindam ƴuuruɗam to Laamɗo.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Yimɓe heewɓe ina ngara to Yaayaa faa lootiree lootagal batisima. De imo wi'a ɓe: —Onon ɓiɓɓe bolle! Moy sappani on ndoggon tikkere Laamɗo waroore? ");
INSERT INTO fuhbkf_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ngollee golleeji kawrooji e tuubugol. Taa kooloɗon on kisan saabe wo on taaniraaɓe Ibrahiima. Sabo miɗo wi'a on, Laamɗo ina waawi waylitinde kaaƴe ɗe laatoo ɓiɓɓe Ibrahiima! ");
INSERT INTO fuhbkf_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Joonin jammbere ƴeptaama faa soppa ɗaɗi leɗɗe. Ndelle, lekki fuu ki rimataa ɓiɓɓe lobbuɓe, soppete, faɗɗee ley yiite. ");
INSERT INTO fuhbkf_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Yimɓe ɓeen ina ƴama mo: —Ndelle ɗume min njeyi waɗude? ");
INSERT INTO fuhbkf_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","O jaabii ɓe, o wi'i: —Neɗɗo fuu jogiiɗo saayaaji ɗiɗi, hokka ngoota kaan mo walaa, neɗɗo fuu jogiiɗo nyaamdu du waɗa noon. ");
INSERT INTO fuhbkf_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Nanngooɓe lampo ngari kam'en du faa lootee lootagal batisima, mbi'i mo: —Moodibbo, ɗume min njeyi waɗude? ");
INSERT INTO fuhbkf_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","O jaabii ɓe, o wi'i: —Taa paltinon ko njamiraɗon nanngon ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Sordaasiiɓe du ƴami mo kam'en du, mbi'i: —Minen le, ɗume min njeyi waɗude? O wi'i ɓe: —Taa njanee fay gooto, taa pewanon fay gooto, kennyitoroɗon njobdi mon. ");
INSERT INTO fuhbkf_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Tawi yimɓe fuu ina keɗii Almasiihu, mono fuu ina miiloo e ɓernde muuɗum yalla wanaa Yaayaa woni Almasiihu oon. ");
INSERT INTO fuhbkf_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yaayaa jaabii ɓe fuu, wi'i: —Miin, ndiyam lootirammi on lootagal batisima, ammaa ɓurɗo kam baawɗe ina wara. Mi fotaay fay e haɓɓitinde ɓoggi paɗe makko. Kanko kaa, wo Ruuhu Ceniiɗo e yiite o lootirta on batisima. ");
INSERT INTO fuhbkf_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Imo jogii ƴarorgal e junngo makko faa o ƴaroo nyaamri makko faa laaɓa, o hawrundura nyaamri ndiin ley beembal makko, de nyaande ndeen o wuldan ɗum yiite nge nyifataa. ");
INSERT INTO fuhbkf_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Tawi Yaayaa tindinii yimɓe kulle keewɗe, ina waajoo ɗum'en Kabaaru Lobbo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Kaa Hirudus, laamiiɗo oon, imo felannoo ɗum sabo ɓaŋii Hirudiya, dee mawnum, ɗuum e kulle goɗɗe bonɗe fuu ɗe waɗannoo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Hirudus ɓeydi bone goɗɗo katin, uddi Yaayaa ley kasu. ");
INSERT INTO fuhbkf_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ɗo yimɓe fuu lootaa lootagal batisima ɗoon, Iisaa du lootaa. Wakkati mo o du'otoo oon, kammu udditii, ");
INSERT INTO fuhbkf_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ruuhu Ceniiɗo jippii dow makko ina wa'i hono wuugaandu. Daande ƴuuri dow kammu, wi'i: —Aan woni Ɓiyam mo korsinmi, aan ceyortoomi. ");
INSERT INTO fuhbkf_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Nde Iisaa fuɗɗannoo golle muuɗum ndeen, duuɓi muuɗum ina ngaɗa capanɗe tati. E ley miilooji yimɓe, Iisaa wo ɓii Yuusufi. Yuusufi du wo ɓii Eli, ");
INSERT INTO fuhbkf_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli ɓii Matat, Matat ɓii Lewi, Lewi ɓii Melki, Melki ɓii Yannay, Yannay ɓii Yuusufi, ");
INSERT INTO fuhbkf_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yuusufi ɓii Matatiya, Matatiya ɓii Amos, Amos ɓii Nahum, Nahum ɓii Hesili, Hesili ɓii Naggay, ");
INSERT INTO fuhbkf_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Naggay ɓii Maata, Maata ɓii Matatiya, Matatiya ɓii Semey, Semey ɓii Yosek, Yosek ɓii Yahuuda, ");
INSERT INTO fuhbkf_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yahuuda ɓii Yohanan, Yohanan ɓii Resa, Resa ɓii Jorobaabel, Jorobaabel ɓii Seyaltiyel, Seyaltiyel ɓii Neri, ");
INSERT INTO fuhbkf_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri ɓii Melki, Melki ɓii Addi, Addi ɓii Kasam, Kasam ɓii Elmadam, Elmadam ɓii Eri, ");
INSERT INTO fuhbkf_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Eri ɓii Iisaa, Iisaa ɓii Eliyeser, Eliyeser ɓii Yorim, Yorim ɓii Matat, Matat ɓii Lewi, ");
INSERT INTO fuhbkf_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lewi ɓii Simeyon, Simeyon ɓii Yahuuda, Yahuuda ɓii Yuusufi, Yuusufi ɓii Yonam, Yonam ɓii Eliyakim, ");
INSERT INTO fuhbkf_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliyakim ɓii Meleya, Meleya ɓii Menna, Menna ɓii Matata, Matata ɓii Natan, Natan ɓii Daawda, ");
INSERT INTO fuhbkf_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Daawda ɓii Yesa, Yesa ɓii Obet, Obet ɓii Bo'as, Bo'as ɓii Salmon, Salmon ɓii Naasuuna, ");
INSERT INTO fuhbkf_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasuuna ɓii Aminadaabu, Aminadaabu ɓii Adamin, Adamin ɓii Aram, Aram ɓii Hesruuna, Hesruuna ɓii Fares, Fares ɓii Yahuuda, ");
INSERT INTO fuhbkf_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yahuuda ɓii Yaakuuba, Yaakuuba ɓii Isiyaaka, Isiyaaka ɓii Ibrahiima, Ibrahiima ɓii Tara, Tara ɓii Nahor, ");
INSERT INTO fuhbkf_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor ɓii Seruku, Seruku ɓii Reyu, Reyu ɓii Pelek, Pelek ɓii Eber, Eber ɓii Sala, ");
INSERT INTO fuhbkf_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala ɓii Kaynam, Kaynam ɓii Arfasada, Arfasada ɓii Sem, Sem ɓii Nuuhu, Nuuhu ɓii Lamek, ");
INSERT INTO fuhbkf_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek ɓii Matusala, Matusala ɓii Henok, Henok ɓii Yaret, Yaret ɓii Maleliyel, Maleliyel ɓii Kaynam, ");
INSERT INTO fuhbkf_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kaynam ɓii Enos, Enos ɓii Set, Set ɓii Aadama, Aadama mo Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Iisaa ƴuuri gooruwol Urdun, ina heewi Ruuhu Ceniiɗo. Ruuhu oon yaari mo ley ladde. ");
INSERT INTO fuhbkf_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ibiliisa ina wondi e makko toon balɗe capanɗe nay, ina jarriboo mo. Fay huunde o nyaamaay e ley nyalaaɗe ɗeen fuu. Caggal ɗuum, o yolbi. ");
INSERT INTO fuhbkf_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ibiliisa wi'i mo: —Si a Ɓii Laamɗo, njamiraa hayre nde laatoo nyaamdu. ");
INSERT INTO fuhbkf_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Iisaa jaabii mo wi'i: —Ina winndaa: «Wanaa e nyaamdu tan neɗɗo wuurdata.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ibiliisa yaari mo nokku toowɗo, holli mo laamuuji adunaaru fuu wakkati gooto, ");
INSERT INTO fuhbkf_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","de wi'i mo: —Mi hokkete baawɗe dow ɗum fuu e darja mum, sabo miin hokkaa ɗum, miɗo waawi hokkude mo muuymi. ");
INSERT INTO fuhbkf_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Si a sujidanii kam, ɗum fuu wo aan jeyi. ");
INSERT INTO fuhbkf_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Iisaa jaabii mo, wi'i: —Ina winndaa: «Wo Laamɗo, Joomiraaɗo maa kaanɗaa sujidande, kam tan kaanɗaa rewude.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ndeen Ibiliisa yaari mo Urusaliima, darni mo dow to ɓuri toowde e suudu dewal mawndu, wi'i mo: —Si a Ɓii Laamɗo, fittu njippoɗaa e leydi, ");
INSERT INTO fuhbkf_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","sabo ina winndaa: «O yamiran maleyka'en makko ndeene.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ina winndaa du: «Ɓe njaɓɓete e juuɗe maɓɓe, taa koyngal maa fiyoo e hayre.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Iisaa jaabii mo, wi'i: —Ina winndaa: «Taa ndaartinda Laamɗo, Joomiraaɗo maa.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Nde Ibiliisa tilinoo e jarribaade mo ndeen, seli mo faa wakkati goɗɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Iisaa yeccii leydi Galili, semmbe Ruuhu ina wondi e muuɗum, kabaaru muuɗum sankitii e leydi ndiin fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Imo waajoo ley cuuɗi Alhuudiyankooɓe baajorɗi, yimɓe fuu ina teddina mo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","O yehi Nasaraatu to o mawni toon, o naati ley suudu waajordu nyannde fowteteende hono no o woowri noon. O ummii faa o jannga. ");
INSERT INTO fuhbkf_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","O hokkaa dewtere annabi Esaaya. O weerti nde, o tawi nokkuure ina winndaa: ");
INSERT INTO fuhbkf_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«Ruuhu Joomiraaɗo ina woni e am, sabo o suɓake kam faa mi faamina talkaaɓe Kabaaru Lobbo. O nulii kam faa mi gooynana nanngaaɓe yoofeede muɓɓen, wumɓe du wumtineede muɓɓen, torraaɓe du yoppeede muɓɓen, ");
INSERT INTO fuhbkf_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","faa mi gooyna hitaande nde Joomiraaɗo hollata moƴƴere muuɗum ndeen warii.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Caggal ɗuum, o taggi dewtere ndeen, o hokki nde golloowo ley suudu waajordu oon, o jooɗii. Wonɓe toon ɓeen fuu tufi mo gite. ");
INSERT INTO fuhbkf_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ndeen o fuɗɗi wi'ude ɓe: —Hannden, Binndi ɗi nanɗon ɗiin tabitii. ");
INSERT INTO fuhbkf_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ɓe fuu iɓe kaala haala makko lobba, katin du haalaaji lobbi jaltuɗi e hunnduko makko ɗiin ina kaaynii ɓe. Iɓe mbi'a: —Wanaa o woni ɓii Yuusufi oon? ");
INSERT INTO fuhbkf_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","O wi'i ɓe: —Sikke fuu walaa on kaalanan kam banndol ngol: «Cawroowo, sawru hoore maa.» On mbi'an mi waɗa ko nanɗon mi waɗii Kafarnahum ɗuum e ley wuro am ɗo du. ");
INSERT INTO fuhbkf_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","O wi'i katin: —Goonga kaalanammi on: annabaajo fay gooto jaɓantaake ley wuro muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Goonga kaalanammi on, rewɓe ɓe goriraaɓe muɓɓen maayi ina keewnoo ley Israa'iila e jamaanu annabi Iliyaasa, wakkati nde ƴuwoonde toɓaay e leydi ndiin faa waɗi duuɓi tati e lebbi jeegom. Ndeen rafo manngo waɗii e leydi ndiin fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ammaa annabi Iliyaasa nulaaka e fay gooto maɓɓe, si wanaa e debbo gooto mo gorum maayi, jeyaaɗo Sarepta leydi Sidon. ");
INSERT INTO fuhbkf_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Katin du, seppinɓe ina keewnoo Israa'iila e jamaanu annabi Elisa, de fay gooto maɓɓe dannaaka, si wanaa Na'aman jeyaaɗo e leydi Siiriya. ");
INSERT INTO fuhbkf_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Nde yimɓe wonɓe e ley suudu waajordu nduun nannoo haala kaan ndeen, tikki sanne, ");
INSERT INTO fuhbkf_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","ummii, mburtini Iisaa faa e gaɗa wuro, njaari ɗum faa sera waamnde ɗo huɓeere maɓɓe ndeen nyiɓaa ɗoon, faa paɗɗa mo ley. ");
INSERT INTO fuhbkf_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ammaa o rewi hakkunde maɓɓe, o dilli. ");
INSERT INTO fuhbkf_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Iisaa yehi ngalluure Kafarnahum ley leydi Galili, imo waajoo yimɓe nyannde fowteteende. ");
INSERT INTO fuhbkf_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ɓe kaaynaa sanne e waaju makko oon, sabo imo haalda e baawɗe. ");
INSERT INTO fuhbkf_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Gorko mo ginnaaru bonndu woni e muuɗum ina woni ley waajordu nduun, ƴeewnii faa toowi, wi'i: ");
INSERT INTO fuhbkf_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Aan Iisaa mo Nasaraatu, ɗume jomi ma e amin? A warii faa kalkaa min naa? Miɗo anndi ko ngonɗaa, a Ceniiɗo ƴuuruɗo to Laamɗo! ");
INSERT INTO fuhbkf_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Iisaa sappani ginnaaru nduun e semmbe, wi'i: —Deƴƴina, yaltu e makko! Ndu liɓi neɗɗo oon hakkunde yimɓe fuu, ndu yalti e muuɗum, tawi ndu nawnaay ɗum fey. ");
INSERT INTO fuhbkf_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ɓe fuu ɗum haaynii ɓe, iɓe ƴamundura hakkunde maɓɓe: —Ko woni haala ka? Ginnaaji bonɗi ɗiin, imo yamira ɗi baawɗe e semmbe, de iɗi mburtoo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Kabaaru Iisaa sankitii e seraaji ɗiin fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Nde o wurtinoo waajordu nduun ndeen, o naati suudu Simon. Esoo Simon debbo ina wondi e jontere naawnde. Ɓe ŋaarii mo o walla ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","O turii dow muuɗum, o sappani jontere ndeen e semmbe, de jontere ndeen yoppi ɗum. Wakkati oon ni, debbo oon ummii, jaɓɓii ɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Wakkati nde naange saamannoo, jogiiɗo nyawɗo fuu waddi ɗum to makko. Nyawɓe siyiiji nyawuuji fuu ngaddaa. O yowi juuɗe makko dow maɓɓe ɓe fuu gooto gooto, o danni ɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ginnaaji bonɗi ina mburtoo e yimɓe heewɓe iɗi ƴeewnoo, iɗi mbi'a: —Aan woni Ɓii Laamɗo! Imo sappana ginnaaji ɗiin e semmbe, o accataa ɗi kaala, sabo iɗi anndi kanko woni Almasiihu. ");
INSERT INTO fuhbkf_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Nde weetunoo fu, Iisaa wurtii, yehi nokku perwuɗo. Jamaa oon ina filoo mo. Ɓe ngari to makko, iɓe tefa taa o seeda e maɓɓe fey. ");
INSERT INTO fuhbkf_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ammaa o wi'i ɓe: —Ina tilsi mi ɓangina Kabaaru Lobbo dow laamu Laamɗo e galluuje goɗɗe. Sabo wo ɗuum nuliraami. ");
INSERT INTO fuhbkf_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","O yehi, imo waajoo ley cuuɗi baajorɗi ley leydi Yahuudiya. ");
INSERT INTO fuhbkf_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Nyannde wootere Iisaa ina darii hunnduko maayo Genesaret, jamaa ina ɓillundura ɗakkol makko faa hettindoo haala Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","O yi'i laanaaji ɗiɗi ina ndarii ɗakkol maayo ngoon. Tawi nanngooɓe liƴƴi ɓeen mburtake ley majji, ina lonna fiiliiji muɓɓen. ");
INSERT INTO fuhbkf_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","O naati ngoota laanaaji ɗiin, ka Simon kaan. O ŋaarii ɗum dirbina ka, ka naata ndiyam seeɗa. O jooɗii ley laana kaan, imo waajoo jama'aaje ɗeen. ");
INSERT INTO fuhbkf_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Nde o selnoo waajaade ndeen, o wi'i Simon: —Njehee to luggi, paɗɗee fiiliiji mon faa nanngon liƴƴi. ");
INSERT INTO fuhbkf_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simon jaabii, wi'i: —Joomam, min mbaalii miɗen piloo liƴƴi, min keɓaay fay huunde. Ammaa saabe haala maa, mi faɗɗan fiiliiji ɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Nde ɓe paɗɗunoo ɗi ndeen, ɓe nanngi liƴƴi faa keewi, faa fiiliiji maɓɓe ina ceekoo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ɓe noddi wondiiɓe maɓɓe wonɓe ley laana ngokka, ngara mballa ɓe. Ɓeen ngari, ɓe kebbini laanaaji ɗiɗi ɗiin fuu faa ɗi nesi yoolaade. ");
INSERT INTO fuhbkf_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Nde Simon Piyeer yi'unoo ɗum fu, dikkinii yeeso makko, wi'i mo: —Joomam, woɗɗam, sabo wo mi neɗɗo luttuɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","O wi'ii ɗum sabo kanko e wondiiɓe makko ɓeen fuu, ɓe kaaynaama saabe keewal liƴƴi ɗi ɓe nanngi ɗiin. ");
INSERT INTO fuhbkf_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Hono noon Yaakuuba e Yuhanna ɓiɓɓe Jebede wonduɓe e Simon ɓeen du kaayniraa. Ammaa Iisaa wi'i Simon: —Taa hulu, gilla joonin a laatoto pilotooɗo yimɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Nde ɓe njottinnoo laanaaji maɓɓe leydi ndeen, ɓe njoppi ɗum fuu, ɓe njokki Iisaa. ");
INSERT INTO fuhbkf_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Wakkati Iisaa wonnoo ley ngalluure gomma, gorko ceppinɗo sanne wari. Gorko oon yi'i Iisaa, sujidi e leydi yeeso muuɗum, na ŋaaroo: —Joomam, si a muuyii fu, aɗa waawi dannude kam faa mi laaɓa. ");
INSERT INTO fuhbkf_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Iisaa foorti junngo mum, meemi mo, wi'i: —Mi muuyii, daɗu! Wakkati oon ceppam ɗam ƴuwi e makko. ");
INSERT INTO fuhbkf_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","De Iisaa yamiri mo taa o haalana ɗum fay gooto, ammaa wi'i mo: —Yahu holloy hoore maa almaami, ngaɗanaa laaɓugol maa ngol sadaka mo Muusaa yamiri oon, faa faamina ɓe a daɗii. ");
INSERT INTO fuhbkf_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","De fay ko Iisaa haɗi mo haalude ɗuum, kabaaru muuɗum ɓeydii sankitaade. Jama'aaje keewɗe ina ngara, ina kawrita faa kettindanoo mo, wooɗi du ndannee e nyawuuji muɓɓen. ");
INSERT INTO fuhbkf_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ammaa imo toowta sera nokkuuje perwuɗe, imo waɗa du'aare. ");
INSERT INTO fuhbkf_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Nyannde gomma Iisaa ina waajoo. Farisa'en e jannginooɓe Tawreeta Muusaa, ƴuuruɓe gure Galili e Yahuudiya, kam e Urusaliima fuu, ina njooɗii. Baawɗe Joomiraaɗo ina ngoni e makko, imo danna nyawɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Wakkati oon, woɓɓe ngaddi gorko mo ɓanndu waatundu ina fukkinaa e daɗɗo, ina piloo nannude ɗum faa pukkina ɗum yeeso makko. ");
INSERT INTO fuhbkf_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Kaa nde ɓe kunnginoo nannude mo saabe jamaa oon, ɓe ƴeeŋi dow suudu nduun, ɓe njuli ndu, de ɓe njippini gorko oon e daɗɗo mum fuu hakkunde yimɓe ɓeen yeeso Iisaa. ");
INSERT INTO fuhbkf_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Nde o yi'unoo goonɗinal maɓɓe ndeen, o wi'i mo ɓanndu waatundu oon: —Gorko, hakkeeji maa njaafaama. ");
INSERT INTO fuhbkf_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Jannginooɓe Tawreeta e Farisa'en ɓeen ina miiloo hakkunde muɓɓen ina mbi'a: «Oo wo moy kaaloowo karmuɗi? Moy waawi yaafaade hakkeeji si wanaa Laamɗo?» ");
INSERT INTO fuhbkf_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Iisaa faami miilooji maɓɓe, de jaabii ɓe, wi'i: —Ko waɗi oɗon miiloo miilooji gaaɗi ni e ɓerɗe mooɗon? ");
INSERT INTO fuhbkf_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ɗume ɓuri hoyude? Wi'ude hakkeeji makko njaafaama, naa wi'ude o ummoo, o yaha? ");
INSERT INTO fuhbkf_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ammaa faa paamon Ɓii Neɗɗo ina jogii baawɗe e adunaaru ndu yaafaade hakkeeji... Ndeen o wi'i mo ɓanndu waatundu oon: —Miɗo haalane: umma, hooƴu daɗɗo maa, kootaa suudu maa. ");
INSERT INTO fuhbkf_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Wakkati gooto, mo ɓanndu waatundu oon ummii yeeso yimɓe fuu, hooƴi daɗɗo muuɗum, hooti suudu mum, ina teddina Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Haaynde nanngi yimɓe ɓeen fuu, iɓe teddina Laamɗo. Ɓe kuli sanne, ɓe mbi'i: —Hannden en nji'ii kaayeefiiji koy! ");
INSERT INTO fuhbkf_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Caggal ɗuum, Iisaa wurtii, yi'i nanngoowo lampo gooto ina wi'ee Lewi ina jooɗii e suudu nanngooɓe lampo. O wi'i ɗum: —Jokkam. ");
INSERT INTO fuhbkf_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lewi yoppi ɗum fuu, ummii, jokki mo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Lewi waɗani mo weltaare mawnde ley suudu mum. Nanngooɓe lampo heewɓe e yimɓe woɓɓe ina nyaamda e maɓɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Farisa'en e jannginooɓe Tawreeta ɓeen ina mbuyka, ina mbi'a taalibaaɓe makko ɓeen: —Ko waɗi oɗon nyaamda, oɗon njarda e nanngooɓe lampo e luttuɓe woɓɓe? ");
INSERT INTO fuhbkf_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Iisaa jaabii ɓe, wi'i: —Wanaa selluɓe kaajaa cawroowo, wo nyawɓe kaajaa cawroowo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Mi waraay faa mi nodda dartiiɓe. Wo luttuɓe noddammi faa tuuba. ");
INSERT INTO fuhbkf_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ɓe mbi'i mo: —Taalibaaɓe Yaayaa ina cuumoo sanne ina ngaɗa du'aare, hono noon taalibaaɓe Farisa'en ɓeen du ngaɗata. Ammaa ɓe maa ɓeen ina nyaama ina njara. ");
INSERT INTO fuhbkf_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","O wi'i ɓe: —Yalla oɗon mbaawi suuminde warɓe ɓangal, tawa ɓaŋuɗo oon ina wondi e muɓɓen naa? ");
INSERT INTO fuhbkf_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ammaa balɗe ngaran nde ɓaŋuɗo oon ittetee hakkunde maɓɓe. E balɗe ɗeen ɓe cuumoto. ");
INSERT INTO fuhbkf_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","O banndani ɓe banndol katin: —Fay gooto ittataa tayre e kaddungal kesal faa moƴƴinira kiinngal. Si ɗum waɗii, joomum bonnan kesal ngaal, tawee tayre ittaande ndeen yaadataa e kiinngal ngaal. ");
INSERT INTO fuhbkf_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Katin du, fay gooto loowataa cabijam kesam ley sumalleeji kiiɗɗi. Si ɗum waɗii, cabijam kesam ɗaam fusan ɗi, rufa, sumalleeji ɗiin mbona. ");
INSERT INTO fuhbkf_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ndelle sanaa cabijam kesam loowee e ley sumalleeji kesi. ");
INSERT INTO fuhbkf_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Fay gooto muuyataa cabijam kesam si yarii kiiɗɗam, sabo wi'an kiiɗɗam ɗaam ɓuri welde. ");
INSERT INTO fuhbkf_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Waɗiino e nyannde fowteteende wootere, Iisaa ina rewi ley gese. Taalibaaɓe makko ina itta cammeeji alkama, ina molma ina ƴakka. ");
INSERT INTO fuhbkf_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Kaa Farisa'en woɓɓe mbi'i ɓe: —Ko waɗi oɗon ngolla ko haɗaa golleede nyannde fowteteende? ");
INSERT INTO fuhbkf_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Iisaa jaabii ɓe, wi'i: —Yalla on njanngaay ko Daawda waɗi nde yolbunoo, kam e yaadiraaɓe muuɗum naa? ");
INSERT INTO fuhbkf_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","O naati hukum Laamɗo, o nyaami buuru cakkaaɗo oon, o hokki yaadiraaɓe makko du. Tawi le, wo almaami'en tan njeyi nyaamude buuru oon. ");
INSERT INTO fuhbkf_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Iisaa wi'i ɓe katin: —Ɓii Neɗɗo kam jeyi nyannde fowteteende. ");
INSERT INTO fuhbkf_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Nyalaande fowteteende wonnde, o naati suudu waajordu imo waajoo. Gorko mo junngo muuɗum nyaamo waati na ɗoon. ");
INSERT INTO fuhbkf_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Jannginooɓe Tawreeta e Farisa'en ina taykoo Iisaa. Iɓe ndaara yalla o dannan gorko oon nyannde fowteteende ndeen, faa ɓe keɓa ko ɓe pelira mo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ammaa Iisaa annditii miilooji maɓɓe. O wi'i mo junngo waanngo oon: —Umma, dara hakkunde yimɓe! Gorko oon ummii, darii. ");
INSERT INTO fuhbkf_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ndeen Iisaa wi'i ɓe: —Miɗo ƴama on: ɗume dagii nyannde fowteteende, gollude ko wooɗi naa gollude ko boni? Dannude neɗɗo naa halkude ɗum? ");
INSERT INTO fuhbkf_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Wakkati oon, o ndaari ɓe fuu, o wi'i mo junngom waati oon: —Foortu junngo maa! Oon foorti ngo tan, ngo daɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ammaa yimɓe ɓeen tikkii sanne, iɓe ndawrida no ɓe ngaɗata Iisaa. ");
INSERT INTO fuhbkf_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","E ley balɗe ɗeen, Iisaa wurtii, yehi dow waamnde faa du'oo. O waali imo haalda e Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Nde weetunoo ndeen, o noddi taalibaaɓe makko ɓeen, o suɓii sappo e ɗiɗo hakkunde muɓɓen, o inndiri ɗum'en nulaaɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Kamɓe ngoni: Simon mo o inndiri Piyeer, Andire minyum, Yaakuuba, Yuhanna, Filipu, Bartolome, ");
INSERT INTO fuhbkf_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matta, Tomaa, Yaakuuba ɓii Alfaa, Simon bi'eteeɗo Kiranoowo suudu baaba, ");
INSERT INTO fuhbkf_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","e Yahuuda ɓii Yaakuuba, kam e Yahuuda Isikariyotto, jambotooɗo mo oon. ");
INSERT INTO fuhbkf_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","O jippodii e maɓɓe, o darii e nokkuure yaajunde, kanko e taalibaaɓe makko heewɓe. Jamaa keewɗo ƴuurɗo nokkuuje leydi Yahuudiya fuu na ɗoon, kam e Urusaliima, e gure ɗakkol maayo manngo gilla Tirus faa e Sidon. ");
INSERT INTO fuhbkf_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ɓe ngari faa ɓe kettindanoo mo, wooɗi du ɓe ndannee e nyawuuji maɓɓe. Ɓe ginnaaji bonɗi torri du, ndannaama. ");
INSERT INTO fuhbkf_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Yimɓe ɓeen fuu ina piloo meemude mo, sabo baawɗe ina mburtoo e makko ina ndanna yimɓe ɓeen fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Wakkati oon, o ɓanti gite makko o ndaari taalibaaɓe makko ɓeen, o wi'i: —Barke woodanii on, onon talkaaɓe, sabo onon njeyi laamu Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Barke woodanii on, onon yolbuɓe joonin, sabo on kaaran. Barke woodanii on, onon woyooɓe joonin, sabo on mbeltoyto. ");
INSERT INTO fuhbkf_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Barke woodanii on si yimɓe mbanyii on, ndiiwii on, njennii on, mbonnii inɗe mon saabe Ɓii Neɗɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ceyoɗon nyannde ndeen, pittiron seyo, sabo mbarjaari mawndi ina woodani on dow kammu. Hono noon maamiraaɓe maɓɓe ngaɗannoo annabaaɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ammaa bone woodanii on, onon joomiraaɓe jawdi, sabo on keɓii mbelirka mon. ");
INSERT INTO fuhbkf_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Bone woodanii on, onon haarɓe joonin, sabo on njolban. Bone woodanii on, onon jalooɓe joonin, sabo on cunoyto, on mboyan. ");
INSERT INTO fuhbkf_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Bone woodanii on, si yimɓe fuu manii on, sabo hono noon maamiraaɓe maɓɓe ngaɗannoo annabaaɓe fewreeɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","—Ammaa onon hettindaniiɓe kam ɓeen, miɗo wi'a on: njiɗee wayɓe on, ngaɗanon wanyuɓe on moƴƴere. ");
INSERT INTO fuhbkf_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Mbarkinee huɗooɓe on, ndu'anoɗon torrooɓe on du. ");
INSERT INTO fuhbkf_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Si goɗɗo feenyii ma, hokku ɗum feenya gere goɗɗo oon du. Si goɗɗo teetii ma saaya maa jaangol, taa haɗu ɗum forgo maa du. ");
INSERT INTO fuhbkf_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ŋaariiɗo ma fuu, kokkaa ɗum. Teetuɗo ma gineeji maa, taa ƴamtu ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ngaɗanee woɓɓe ko njiɗɗon ɓe ngaɗana on. ");
INSERT INTO fuhbkf_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Si yiɗuɓe on tan njiɗoton, barke oye keɓoton? Fay luttuɓe ina njiɗi yiɗuɓe ɗum'en. ");
INSERT INTO fuhbkf_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Si waɗanooɓe on moƴƴere tan ngaɗanton moƴƴere, barke oye keɓoton? Fay luttuɓe ɓeen hono noon ngaɗata. ");
INSERT INTO fuhbkf_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Si ɓe miiliɗon hemrude tan nyamlotoɗon, barke oye keɓoton? Fay luttuɓe ina nyamloo luttuɓe hono muɓɓen, faa njoɓee nyamaande muɓɓen. ");
INSERT INTO fuhbkf_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Onon le, njiɗee wayɓe on, ngaɗon moƴƴere, nyamloɗon tawee on miilaaki yoɓeede fey. Ndeen, on keɓan mbarjaari mawndi, on laatoto ɓiɓɓe Laamɗo Toowɗo, sabo oon ina waɗana bonnooɓe moƴƴere, ina waɗana bonɓe du. ");
INSERT INTO fuhbkf_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Laatee yurmotooɓe, hono no Baaba mooɗon yurmortoo noon. ");
INSERT INTO fuhbkf_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","—Taa kiitee, on kiitataake. Taa njukkee, on njukkataake. Njaafee, on njaafete. ");
INSERT INTO fuhbkf_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Kokkee, on kokkete etirgal lobbal, dimmbaangal de ɗibbaa faa ƴolii, ina rufa, saawee e kaddule mooɗon. Sabo etirgal ngal etirton, wo ngaal etiranteɗon. ");
INSERT INTO fuhbkf_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","O banndani ɓe banndol du, o wi'i: —Bumɗo ina waawi ɗowude bumɗo naa? Si ɗum waɗii, wanaa ɓe ɗiɗo fuu, ɓe caaman ley luggere naa? ");
INSERT INTO fuhbkf_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Taalibbo ɓuraa moodibbom, de taalibbo kiɓɓuɗo laatoto hono moodibbom. ");
INSERT INTO fuhbkf_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ko waɗi de aɗa yi'a kuɗol ley yitere sakiike maa, de aan le, a taykataako leggal gonngal e ley yitere maa ndeen? ");
INSERT INTO fuhbkf_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Noy mbaawrataa wiide sakiike maa: «Sakiike, accu mi ittane kuɗol gonngol e yitere maa ngol», tawee aan le, a yi'ataa leggal gonngal e ley yitere maa ndeen? Munaafiki, ittu leggal gonngal ley yitere maa ngaal tafon. Ndeen jiiɗe maa laaɓan, faa keɓaa ittaa kuɗol gonngol ley yitere sakiike maa ngool. ");
INSERT INTO fuhbkf_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","—Lekki lobbi rimataa ɓiɓɓe bonɓe, lekki mbonki du rimataa ɓiɓɓe lobbuɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Sabo lekki fuu, wo ɓiɓɓe muuɗum annditirtee. Ƴibbe ɓorataake e ngi'eehi, cabiije du ɓorataake e kebbe. ");
INSERT INTO fuhbkf_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Neɗɗo moƴƴo, ko moƴƴi ko resii ley ɓernde muuɗum, ɗuum wurtinta. Neɗɗo bonɗo du, ko boni ko resii ley ɓernde muuɗum, ɗuum wurtinta. Sabo ko heewi ley ɓernde ɗuum, hunnduko wurtinta. ");
INSERT INTO fuhbkf_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","—Ko waɗi oɗon noddira kam «Joomam, Joomam» de on ngaɗataa ko mbiimi? ");
INSERT INTO fuhbkf_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Neɗɗo fuu garɗo to am de hettindii haalaaji am, jokki ɗi, mi hollan on mo o nanndi: ");
INSERT INTO fuhbkf_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Joomum ina nanndi e neɗɗo nyiɓuɗo suudu, wasi leydi ndiin faa yottii hayre, joƴƴini ndu dow mayre. Ndeen ƴuwoonde mawnde toɓi faa gooruwol heewi, fiyi e suudu nduun, ammaa hunngii dimmbude ndu, sabo ndu nyiɓaama faa wooɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Kaa kettindiiɗo haala am, si jokkaay, ina nanndi hono nyiɓuɗo suudu dow leydi mo wasanaay ɗum joƴƴinirde. Gooruwol bubboowol fiyi e suudu nduun, de wakkati gooto ndu saami. Suudu nduun halki halkere mawnde sanne. ");
INSERT INTO fuhbkf_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Nde Iisaa selnoo waajaade hettindaniiɓe ɗum ɓeen fu, yehi Kafarnahum. ");
INSERT INTO fuhbkf_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Mawɗo sordaasi'en gooto, golloowo muuɗum korsuɗo nyawi faa ina habda e yonki. ");
INSERT INTO fuhbkf_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Mawɗo oon nani kabaaru Iisaa. O neli mawɓe Alhuudiyankooɓe to Iisaa, wara, danna golloowo makko oon. ");
INSERT INTO fuhbkf_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ɓe ngari to makko, iɓe ŋaaroo mo sanne sanne, iɓe mbi'a: —Imo haani waɗaneede ɗum, ");
INSERT INTO fuhbkf_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","sabo imo yiɗi lenyol men, katin du kanko nyiɓi suudu men waajordu. ");
INSERT INTO fuhbkf_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Iisaa ina yaada e maɓɓe faa ɓe ɓadii suudu mawɗo oon. Ndeen mawɗo oon neli yimɓe muuɗum to Iisaa, wi'i ɗum: —Moodibbo, taa tampin hoore maa, sabo miin, mi hewtaay ko naataa ley suudu am. ");
INSERT INTO fuhbkf_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ɗum waɗi du miiliimi mi fotaay yaade to maa. Ammaa haalu haala maa tan, ndeen golloowo am oon daɗan. ");
INSERT INTO fuhbkf_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Miin e hoore am, wo mi laamaaɗo, de miɗo dawrana sordaasiiɓe du. Si mi wi'ii gooto maɓɓe yaha fu, yahan. Si mi wi'ii goɗɗo wara, waran. Si mi wi'ii maccuɗo am waɗa huunde, waɗan. ");
INSERT INTO fuhbkf_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Nde Iisaa nannoo haala kaan ndeen, ɗum haaynii ɗum, de hucciti e yimɓe jokkuɓe ɗum ɓeen, wi'i: —Miɗo haalana on, mi yi'aay hono ngal goonɗinal sellude fay ley Israa'iila'en. ");
INSERT INTO fuhbkf_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Nde nulaaɓe ɓeen njeccinoo wuro toon ndeen, tawi golloowo oon sellii. ");
INSERT INTO fuhbkf_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Gaɗa majjum, o yehi wuro wi'eteengo Nayin. Taalibaaɓe makko e yimɓe heewɓe ina njaada e makko. ");
INSERT INTO fuhbkf_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Nde o ɓattinoo dammbugal wuro ngoon ndeen, o hawri e maayɗo, ina wurtinee. Wo bajjo mo bammum maayi, inna mum ɓaŋaaka katin. Yimɓe wuro ngoon heewɓe ina njaada e inniiwo oon. ");
INSERT INTO fuhbkf_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Nde Iisaa yi'unoo inniiwo oon fu, yurmii ɗum sanne, wi'i: —Taa woy! ");
INSERT INTO fuhbkf_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Iisaa ɓattitii, meemi leggal kooƴirgal maayɓe ngaal. Tiigiiɓe ngal ɓeen ndarii. O wi'i: —Suka jokolle, miɗo wi'e: Umma! ");
INSERT INTO fuhbkf_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Maayɗo oon ummii jooɗii, fuɗɗi haalude. Iisaa hokkiti mo inniiko. ");
INSERT INTO fuhbkf_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Kulol nanngi yimɓe ɓeen fuu, iɓe teddina Laamɗo, iɓe mbi'a: —Annabaajo mawɗo ɓangii e ley meeɗen! Laamɗo warii ina walla yimɓe muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Kabaaru Iisaa oon sankitii e leydi Yahuudiya e seraaji muuɗum fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Taalibaaɓe Yaayaa kumpiti ɗum kabaaru oon fuu. Yaayaa noddi ɗiɗo muɓɓen, ");
INSERT INTO fuhbkf_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","nuli ɗum'en to Iisaa, ƴamowa ɗum yalla kam woni kaanɗo warude oon, naa ɓe ndooman goɗɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Worɓe ɗiɗo ɓeen ngari to makko, mbi'i mo: —Yaayaa lootoowo lootagal batisima nuli min e maaɗa, min ƴame yalla aan woni kaanɗo warude oon, naa min ndooman goɗɗo? ");
INSERT INTO fuhbkf_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Wakkati oon pay, tawi o dannii yimɓe heewɓe e nyawuuji ɗi kawtaa sii, o riiwii ginnaaji bonɗi, o wumtinii wumɓe heewɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","O jaabii ɓe, o wi'i: —Njehee kaaltanowee Yaayaa ko njiiɗon e ko nanɗon: wumɓe ina mbumta, bonnguuɓe ina njaha e koyɗe muɓɓen, seppinɓe ina cellinee, faaɗuɓe ina paaɗita, maayɓe ina ummintinee, talkaaɓe du ina kaalanee Kabaaru Lobbo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Barke woodanii mo yoppaay goonɗinde kam. ");
INSERT INTO fuhbkf_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Nde nulaaɓe ɓeen kootunoo ndeen, Iisaa fuɗɗi haalande jamaa oon haala Yaayaa, wi'i ɗum'en: —Ko njaaɗon ley ladde ɗuum, wo faa ndaarowon ɗume? Yalla huɗo ko henndu dimmbata naa? ");
INSERT INTO fuhbkf_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ndelle ɗume njaaɗon faa ndaarowon? Gorko nyaaƴoowo naa? Si goonga, ɓornotooɓe kaddule lobbe de mbuura nguurndam lobbam ɓeen, ley cuuɗi kaanankooɓe tawetee. ");
INSERT INTO fuhbkf_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ndelle, ɗume ndaaroyɗon? Annabaajo naa? Goonga! Miɗo haalana on, imo ɓuri annabaajo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Kanko woni mo Laamɗo haali kabaaru muuɗum ley Binndi, wi'i: «Ndaaree, mi ardinante nulaaɗo am moƴƴinane laawol.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Miɗo haalana on, dimoowo fuu rimaay ɓurɗo Yaayaa. Tawi le, ɓurɗo fuu famɗude ley laamu Laamɗo oon na ɓuri mo teddude. ");
INSERT INTO fuhbkf_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Yimɓe hettindaniiɓe mo ɓeen fuu, fay nanngooɓe lampo ɓeen, njaɓii konngol Laamɗo ko Yaayaa looti ɗum'en lootagal batisima ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ammaa Farisa'en e jannginooɓe Tawreeta njoppii muuyo Laamɗo ko ɓe njaɓaay looteede e junngo Yaayaa ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ndelle, ɗume nanndinammi yimɓe jamaanu o? Ɓeye o nanndi? ");
INSERT INTO fuhbkf_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Iɓe nanndi e sukaaɓe jooɗiiɓe ley taliyaare luumo, ina noddundura, ina mbi'a: «Min puufanii on cereeli, de on mbamaay. Min mboyanii on jimi bojji, de on mboyaay.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Sabo Yaayaa lootoowo lootagal batisima warii, nyaamataa ɓii jalo, yarataa doro du, de oɗon mbi'a ina wondi e ginnaaru. ");
INSERT INTO fuhbkf_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","De Ɓii Neɗɗo warii, ina nyaama ina yara, de oɗon mbi'a, «Ndaar neɗɗo o, kakkilanɗo nyaamude e yarude tan, yigoo nanngooɓe lampo e luttuɓe woɓɓe.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ammaa jaɓuɓe hakkillo Laamɗo ɓeen fuu ina laamni wo ngo goonga. ");
INSERT INTO fuhbkf_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Gooto e Farisa'en ɓeen noddi mo faa ɓe nyaamda. O naati suudu Farisaajo oon, o jooɗii faa o nyaama. ");
INSERT INTO fuhbkf_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Debbo pijoowo ina woni ley wuro ngoon. Ko o nani Iisaa ina woni ley suudu Farisaajo oon ina nyaama ɗuum, o waddi faandu nebbam uurɗam. ");
INSERT INTO fuhbkf_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","O hetti caggal Iisaa ɗakkol koyɗe muuɗum, imo woya, imo leppinira koyɗe mum gonɗi makko, imo mooytira ɗe sukundu makko. Imo muccoo ɗe, imo joora nebbam ɗaam dow majje. ");
INSERT INTO fuhbkf_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Nde Farisaajo nodduɗo mo oon yiinoo ɗum ndeen, wi'i e ley ɓernde mum: «Si neɗɗo o wo annabaajo, o annditan moy woni debbo meemoowo mo oon, o faaman wo pijoowo.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Iisaa haaldi e Simon Farisaajo oon, wi'i: —Simon, miɗo woodi goɗɗum ko njiɗumi haalande ma. O jaabii: —Haal, Moodibbo! ");
INSERT INTO fuhbkf_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Iisaa wi'i: —Nyamlotooɗo gomma ina rewannoo yimɓe ɗiɗo, gooto oon buuɗi cardi keme joy, gooto du buuɗi cardi capanɗe joy. ");
INSERT INTO fuhbkf_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Kaa nde tawanoo ɓe ngalaa ko ɓe njoɓa mo ndeen, o yaafanii ɓe ɗiɗo fuu. Ndelle, moy e maɓɓe ɓuri yiɗude mo? ");
INSERT INTO fuhbkf_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon jaabii: —Miɗo miila mo o yaafanii kaalisi keewɗo oon. Iisaa wi'i mo: —A haalii goonga! ");
INSERT INTO fuhbkf_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ndeen o hucciti e debbo oon, o wi'i Simon: —A yi'ii debbo o naa? Mi naatii suudu maa, a hokkaay kam ndiyam mi loota koyɗe am. Ammaa kanko kaa, o lootirii koyɗe am e gonɗi makko, de o mooytiri ɗe sukundu makko. ");
INSERT INTO fuhbkf_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Aan, a muccaaki kam, de kanko kaa, gilla naatumi, o selaay muccaade koyɗe am. ");
INSERT INTO fuhbkf_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","A wattaay nebbam dow hoore am, de kanko kaa, o joorii nebbam uurɗam dow koyɗe am. ");
INSERT INTO fuhbkf_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ɗum waɗi miɗo wi'e: hakkeeji makko no keewiri fuu njaafaama, ndelle njinngu makko ina mawni. De jaafanaaɗo seeɗa, njinngu muuɗum heewaa. ");
INSERT INTO fuhbkf_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ndeen o wi'i debbo oon: —Hakkeeji maa njaafaama. ");
INSERT INTO fuhbkf_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Nyaamdooɓe e makko ɓeen puɗɗi ƴamundurde hakkunde muɓɓen: «Moy woni o neɗɗo, jottiiɗo faa yaafaade hakkeeji?» ");
INSERT INTO fuhbkf_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","O wi'i debbo oon: —Goonɗinal maa hisinii ma. Yahu e jam. ");
INSERT INTO fuhbkf_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Caggal ɗuum, Iisaa ina yiiltoo ley galluuje e gure, ina gooyna, ina haala Kabaaru Lobbo dow laamu Laamɗo. Taalibaaɓe makko sappo e ɗiɗo ɓeen ina ngondi e makko, ");
INSERT INTO fuhbkf_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","kam'en e rewɓe dannaaɓe e nyawuuji muɓɓen, e ɓe ginnaaji bonɗi du ndiiwaa e muɓɓen. Ɓeen ngoni Mariyama innditirteeɗo Magdala mo ginnaaji jeɗɗi mburtinaa e muuɗum, ");
INSERT INTO fuhbkf_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","e Yowanna, dee howruujo Hirudus bi'eteeɗo Huja, kam e Susaana, e rewɓe woɓɓe heewɓe. Ɓe fuu ɓe mballirii Iisaa e taalibaaɓe mum jawdi maɓɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Yimɓe ƴuuri e gure ɗeen fuu ina ngara to makko. Nde jamaa keewɗo oon fiilinoo mo ndeen, o banndani ɓe banndol ngol, o wi'i: ");
INSERT INTO fuhbkf_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Aawoowo wurtii faa saaka aawdi muuɗum. E ley aawugol ngool, aawdi ngondi saami e laawol, yaaɓaa, de pooli ngari, cuɓi ndi. ");
INSERT INTO fuhbkf_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Yoga mayri saami ley korokaaƴe, fuɗi, yoori, sabo nokku oon darnataa ndiyam. ");
INSERT INTO fuhbkf_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Yoga mayri saami to kebbe puɗata. Ndi mawnidi e majje, de kebbe ɗeen ɓilli ndi. ");
INSERT INTO fuhbkf_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Yoga mayri saami e leydi lobbiri, fuɗi, rimi, wabbere fuu ɓeydii kile hemre. Nde o haalnoo ɗum ndeen, o ɓanti daande makko, o wi'i: —Jom nowru nanooru fuu, nana! ");
INSERT INTO fuhbkf_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Taalibaaɓe makko ɓeen ƴami mo: —Ɗume banndol ngol fiirtata? ");
INSERT INTO fuhbkf_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","O wi'i ɓe: —Onon, on kokkaama faamude ko suuɗii e laamu Laamɗo. De heddiiɓe ɓeen kaa, e banndi kaalirantee, faa «ndaara, tawa nji'ataa, nana, tawa paamataa.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Inan maanaa banndol ngol: aawdi ndiin wo konngol Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ngondi sera laawol ndiin woni nanooɓe ngol, de Ibiliisa wara, itta ngol e ɓerɗe muɓɓen taa ngoonɗina de kisa. ");
INSERT INTO fuhbkf_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ngondi dow korokaaƴe ndiin woni nanooɓe ngol, njaɓɓoroo ngol seyo, de ɓe ngalaa ɗaɗi ley maggol. Wakkati seeɗa tan ɓe ngoonɗinta. Nde ndaartindagol wari fuu, ɓe njoppan. ");
INSERT INTO fuhbkf_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Caamundi ley kebbe ndiin woni nanooɓe konngol ngool, ammaa ley mawnugol muɓɓen ndeen kaɓɓu-ko'u e jawdi e mbelirka adunaaru ɓillan ɗum'en, kunngoo rimude. ");
INSERT INTO fuhbkf_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ammaa ɗo aawdi ndiin saami e leydi lobbiri ɗoon, ɓeen ngoni nanirooɓe konngol ngool ɓerɗe belɗe laaɓuɗe. Ley tinnitaare ɓe tiigoo ngol faa ngol rima. ");
INSERT INTO fuhbkf_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","—Fay gooto huɓɓataa lampal de hippa ɗum tummbude naa soorna ɗum ley leeso. Ko waɗata dey, ɓilan ngal faa ngal yaynana naatooɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Sabo walaa fuu ko suuɗii ko funtintaake, walaa ko suuɗii du ko annditataake, wurtinee yaasin. ");
INSERT INTO fuhbkf_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ndelle, tinnee no nanirɗon ni, sabo neɗɗo fuu jogiiɗo paamal dow laamu Laamɗo, ɓeydante. Ammaa mo walaa paamal oon, fay ko miilata ina jogii ɗuum, teetete. ");
INSERT INTO fuhbkf_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Inna Iisaa e minyiraaɓe muuɗum ngari to muuɗum, de ɓe mbaawaay ɓattaade ɗum saabe jamaa. ");
INSERT INTO fuhbkf_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","O haalanaa inniiko e minyiraaɓe makko ina ndarii yaasin, ina njiɗi yi'ude mo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","De o jaabii, o wi'i: —Inna am e minyiraaɓe am wo nanooɓe haala Laamɗo, de ɗowtanoo ka ɓeen. ");
INSERT INTO fuhbkf_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Nyannde gomma Iisaa e taalibaaɓe muuɗum naati laana. O wi'i ɓe: —En peƴƴita, njehen gere ooto maayo ngo. Ɓe ndunnyi. ");
INSERT INTO fuhbkf_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ko ɓe peƴƴitata ɗuum, o ɗaanii. Wakkati oon, henndu mawndu ummii dow maayo, ndiyam ina naata laana kaan faa ka nesi yoolaade. ");
INSERT INTO fuhbkf_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ɓe ɓattitii, iɓe pindina mo iɓe mbi'a: —Joomii amin, joomii amin, inani miɗen kalka! O fini, o sappani henndu e bempeƴƴe ɗeen e semmbe, de ɗum fuu ɗum darii, ɗum deƴƴinii. ");
INSERT INTO fuhbkf_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ndeen o wi'i ɓe: —Toy goonɗinal mon woni? Ɓe kuli, ɗum haaynii ɓe, iɓe mbi'undura: —O wo moy ndelle? Imo yamira fay keni e ndiyam de ɗum fuu iɗum ɗowtanoo mo! ");
INSERT INTO fuhbkf_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Gaɗa ɗuum ɓe njottowii leydi Gerasa'en, kuccundurndi e leydi Galili. ");
INSERT INTO fuhbkf_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Nde o jippinoo laana kaan ndeen, gorko gonduɗo e ginnaaji jeyaaɗo e wuro ngoon hawri e makko. Gorko oon wo joppuɗo kaddule muuɗum ko ɓooyi, o jooɗaaki ley wuro, imo woni ley caabeeje. ");
INSERT INTO fuhbkf_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ko o yi'i Iisaa ɗuum, o halɓi, o hippii yeeso muuɗum, o haali faa toowi, o wi'i: —Iisaa, Ɓii Laamɗo Toowɗo, ɗume njiɗɗaa waɗude kam? Miɗo nyaage, taa torram. ");
INSERT INTO fuhbkf_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","O wi'iri noon sabo Iisaa yamirii ginnaaru bonndu nduun wurtoo e makko. Kile keewɗe indu warti-wartinannoo e makko, indu nannga mo. Imo haɓɓirenoo callali, juuɗe e koyɗe fuu, de imo taƴa ɗi, ginnaaru nduun ina yaara mo ley ladde. ");
INSERT INTO fuhbkf_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Iisaa ƴami mo, wi'i: —Noy mbi'eteɗaa? O jaabii: —Miɗo wi'ee Jamaa. Sabo ginnaaji keewɗi ina ngoni e makko. ");
INSERT INTO fuhbkf_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Iɗi nyaagoo Iisaa taa yamira ɗi ɗi naatowa ley ɓunndu torra. ");
INSERT INTO fuhbkf_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Tawi coggal girooji manngal ina dura dow waamnde ɗoon. Ginnaaji ɗiin ŋaarii mo o acca ɗi ɗi naatowa e ley girooji ɗiin. O acci ɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ɗi njalti e neɗɗo oon, ɗi naati e ley girooji ɗiin. Coggal ngaal fuu doggi, tellitii dow waamnde ndeen, naati maayo, yoolii. ");
INSERT INTO fuhbkf_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Nde durooɓe ɓeen njiinoo ko waɗi ɗuum fu, ɓe ndoggi, ɓe kaalanowi ɗum yimɓe ngalluure ndeen e seraaji muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ɓeen ngari ndaarude ko waɗi ɗuum. Nde ɓe njottinoo Iisaa ndeen, ɓe tawi gondunooɗo e ginnaaji oon ina jooɗii ɗakkol makko, ina ɓornii kaddule, hakkillom wartii. De kulol nanngi ɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Yiinooɓe ɗum ɓeen kaalani yimɓe no gondunooɗo e ginnaaji oon danniraa. ");
INSERT INTO fuhbkf_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Yimɓe leydi Gerasa fuu ŋaarii Iisaa dillana ɗum'en leydi muɓɓen, sabo kulol manngol nanngii ɗum'en. O naati laana, o dilli. ");
INSERT INTO fuhbkf_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Mo ginnaaji ndiiwaa e muuɗum oon, ŋaarii Iisaa sanne, acca o jokka ɗum. Ammaa Iisaa yeccini mo, wi'i: ");
INSERT INTO fuhbkf_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Hootu suudu maa, kaalanaa yimɓe maa ko Laamɗo waɗani maa. O yehi, o gooyni e wuro ngoon fuu ko Iisaa waɗani mo ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Nde Iisaa wartunoo ndeen, jamaa oon jakkitii ɗum, sabo yimɓe fuu ina ndoomunoo ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Wakkati oon, gorko bi'eteeɗo Jayrus, hooreejo suudu waajordu, wari to makko, hippii ɗakkol koyɗe makko, ŋaarii mo o wara suudu mum. ");
INSERT INTO fuhbkf_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Ɓiyum debbo bajjo, ina habda e yonki. Duuɓi muuɗum na ngaɗa hono sappo e ɗiɗi. E ley ko Iisaa yahata toon ɗuum, yimɓe na ɓilli ɗum sanne. ");
INSERT INTO fuhbkf_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Debbo gooto, mo ƴiiƴam muuɗum taccataa ko waɗata duuɓi sappo e ɗiɗi, ina tawaa toon. O hantii jawdi makko fuu to sawrooɓe, ammaa fay gooto waawaay dannude mo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","O ƴuuri gaɗa Iisaa, o meemi kommbol saaya mum. Wakkati oon ƴiiƴam makko tacci. ");
INSERT INTO fuhbkf_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Iisaa wi'i: —Moy meemi kam? Fay gooto jaabaaki, de Piyeer wi'i: —Joomam, hakkunde yimɓe ngonɗaa, iɓe ɓilli ma. ");
INSERT INTO fuhbkf_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Iisaa wi'i: —Goɗɗo meemii kam, sabo mi maatii baawɗe njaltii e am. ");
INSERT INTO fuhbkf_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Nde debbo oon annditinnoo ɗum suuɗataako fu, wari ina diwna, hippii yeeso makko, haali hakkunde yimɓe fuu ko waɗi de meemi mo, e no daɗiri wakkati gooto. ");
INSERT INTO fuhbkf_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Iisaa wi'i mo: —Banndam debbo, goonɗinal maa dannii ma. Yahu e jam. ");
INSERT INTO fuhbkf_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","O tilaaki haalde, faa goɗɗo ƴuuri to wuro hooreejo suudu waajordu oon, wi'i ɗum: —Ɓiya heddaaki, taa tampin Moodibbo o katin. ");
INSERT INTO fuhbkf_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ammaa nde Iisaa nannoo ɗum fu, wi'i hooreejo suudu waajordu oon: —Taa hulu, goonɗin tan, ɓiya oon daɗan. ");
INSERT INTO fuhbkf_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Nde o yottinoo suudu hooreejo oon fu, o accaay fay gooto naadda e makko, si wanaa Piyeer e Yuhanna e Yaakuuba e baaba suka oon e inna muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Yimɓe ɓeen fuu ina mboya suka oon, ina piira ɓerɗe muɓɓen mettorgal. O wi'i ɓe: —Taa mboyee sabo o maayaay, wo o ɗaani tan. ");
INSERT INTO fuhbkf_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ndeen ɓe njalnorii mo, sabo iɓe anndi o maayii. ");
INSERT INTO fuhbkf_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Iisaa nanngi junngo suka oon, ɓanti daande muuɗum, wi'i: —Suka, umma! ");
INSERT INTO fuhbkf_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Yonki makko warti, o ummii wakkati oon pay. Iisaa yamiri ɓe kokka mo ko o nyaama. ");
INSERT INTO fuhbkf_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ɗum haaynii saaraaɓe suka oon. O gongini ɓe taa ɓe kaalana fay gooto ko waɗi ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Iisaa noddi taalibaaɓe muuɗum sappo e ɗiɗo ɓeen, hokki ɗum'en semmbe e baawɗe riiwude ginnaaji e dannude nyawuuji. ");
INSERT INTO fuhbkf_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","O nuli ɓe ɓe ngooyna kabaaru laamu Laamɗo, ɓe ndanna nyawɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","O wi'i ɓe: —Taa njaadee e fay huunde, wanaa sawru, wanaa mbasu, wanaa nyaamdu, wanaa buuɗi. Katin du taa adon saayaaji ɗiɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Galle mo njippiɗon fuu, keddoɗon ɗoon faa nde ndilloton wuro ngoon. ");
INSERT INTO fuhbkf_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Wuro fuu ngo on njaɓɓaaka e muuɗum, si oɗon mburtoo ɗum, piɗɗon sollaare maɓɓe wonnde e koyɗe mon, faa laatanoo ɓe seedee e dow bonanda maɓɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ɓe ndilli, iɓe ngaɗa wuro e wuro, iɓe mbaajoo Kabaaru Lobbo, iɓe ndanna nyawɓe wonɓe ley nokkuuje ɗeen fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Hirudus, laamiiɗo oon, nde nannoo ko Iisaa waɗi fuu, hakkillo mum jiiɓii. Sabo woɓɓe ina mbi'a Yaayaa lootoowo lootagal batisima oon ummitii e maayde, ");
INSERT INTO fuhbkf_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","woɓɓe ina mbi'a annabi Iliyaasa ɓangi, woɓɓe katin ina mbi'a gooto e annabaaɓe arandeeɓe ɓeen ummitii. ");
INSERT INTO fuhbkf_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Hirudus wi'i: —Mi taƴii hoore Yaayaa. Moy woni o mo nanammi kabaaru muuɗum ga'uɗo hono noon? Imo filoo yi'ude ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Nulaaɓe ɓeen ngarti. Ɓe kaalani Iisaa ko ɓe ngaɗi ɗuum fuu. O yaadi e maɓɓe wuro wi'eteengo Baytisayda, o toowtidi e maɓɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Jama'aaje ɗeen nani ɗum, njokki mo. O jakkitii ɓe, imo haalana ɓe kabaaru laamu Laamɗo, imo danna ley maɓɓe haajaaɓe danneede. ");
INSERT INTO fuhbkf_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Naange fuɗɗi hiirude. Sappo e ɗiɗo ɓeen ɓattitii mo, mbi'i mo: —Mbi'aa jamaa o yaha ley gure e nokkuuje ɓadiiɗe, faa keɓa to njippoo e to nyaama, sabo ɗo wo ladde ɓolde. ");
INSERT INTO fuhbkf_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ammaa o wi'i ɓe: —Onon e ko'e mooɗon, kokkee ɓe ko ɓe nyaama! Ɓe mbi'i mo: —Buuruuje joy e liƴƴi ɗiɗi tan min njogii, si wanaa min njaha, min coodanowa yimɓe ɓe fuu nyaamdu. ");
INSERT INTO fuhbkf_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Sabo yimɓe ɓeen ina ngaɗa hono worɓe ujunaaje njoyo baka rewɓe e sukaaɓe ngalaa. O wi'i taalibaaɓe makko ɓeen: —Njoƴƴiniree ɓe feccere feccere, wootere fuu capanɗe njoyo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ɓe ngaɗiri noon, ɓe njoƴƴini ɓe fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","O hooƴi buuruuje joy ɗeen e liƴƴi ɗiɗi ɗiin, o tiggitii kammu, o yetti Laamɗo. O heltii buuru oon e liƴƴi ɗiin, o hokki taalibaaɓe ɓeen peccana jamaa oon. ");
INSERT INTO fuhbkf_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ɓe fuu ɓe nyaami faa ɓe kaari. Taalibaaɓe ɓeen kawrunduri kelte keddiiɗe ɗeen, kebbini kandeeje sappo e ɗiɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Nyannde gomma imo toowtidi e taalibaaɓe makko, imo waɗa du'aare. O ƴami ɓe, o wi'i: —Moy jama'aaje mbi'ata ngonumi? ");
INSERT INTO fuhbkf_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ɓe njaabii mo, ɓe mbi'i: —Woɓɓe ina mbi'a wo a Yaayaa lootoowo lootagal batisima. Woɓɓe du ina mbi'a wo a annabi Iliyaasa. Woɓɓe katin du ina mbi'a wo a gooto e annabaaɓe arandeeɓe ɓeen ummitii. ");
INSERT INTO fuhbkf_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","O ƴami ɓe: —Onon le, moy mbi'oton ngonumi? Piyeer jaabii mo, wi'i: —Wo a Almasiihu Laamɗo! ");
INSERT INTO fuhbkf_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","O sappani ɓe e semmbe taa ɓe kaalana ɗum fay gooto. ");
INSERT INTO fuhbkf_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","O ɓeydi, o wi'i: —Ina tilsi Ɓii Neɗɗo torree torraaji keewɗi. Mawɓe yimɓe e almaami'en e jannginooɓe Tawreeta caloto mo. O warete, de nyannde tataɓerde o iirtoto. ");
INSERT INTO fuhbkf_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Gaɗa ɗum o wi'i ɓe fuu: —Muuyɗo jokkude kam fuu, sela ndaarude hoore muuɗum, hooƴa leggal muuɗum palaangal nyannde fuu, jokka kam. ");
INSERT INTO fuhbkf_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Sabo muuyɗo dannude yonki muuɗum, mursan ki. Ammaa mursuɗo ki saabe am, dannan ki. ");
INSERT INTO fuhbkf_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ɗume heɓude adunaaru ndu fuu nafata neɗɗo si halkii yonki muuɗum naa mursii hoore muuɗum? ");
INSERT INTO fuhbkf_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Cemtirɗo kam, miin e haalaaji am fuu, miin Ɓii Neɗɗo du, mi semtiran ɗum nde ngartidoymi e teddeengal am e teddeengal Baaba am e maleyka'en seniiɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Goonga kaalanammi on: yoga e wonɓe ɗo ɓe maayataa, tawee nji'aay laamu Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Hono balɗe jeetati gaɗa ko Iisaa haali haalaaji ɗiin, o yaari Piyeer e Yuhanna e Yaakuuba dow waamnde faa o waɗa du'aare. ");
INSERT INTO fuhbkf_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Nde o du'otonoo ndeen, yeeso makko waylitii, kaddule makko ndawni far faa ina njalba. ");
INSERT INTO fuhbkf_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Inan worɓe ɗiɗo ɓangi, ina kaalda e makko. Wo Muusaa e Iliyaasa. ");
INSERT INTO fuhbkf_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ɓe ɓangidi e darja mawɗo, iɓe kaala dow dillugol makko adunaaru ngol o ɓadii tabintinde to Urusaliima ngool. ");
INSERT INTO fuhbkf_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Tawi Piyeer e wonduɓe e muuɗum ɓeen wo ɗaaniiɓe ɗoyngol teddungol. Kaa ɓe pinii, ɓe nji'i darja makko, ɓe nji'i worɓe ɗiɗo wonduɓe e makko ɓeen. ");
INSERT INTO fuhbkf_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Nde yimɓe ɗiɗo ɓeen ceedannoo e makko ndeen, Piyeer wi'i mo: —Joomam, gonal amin ɗo ina wooɗi. Accu min ndarna hukumuuji tati: aan gooto, Muusaa gooto, Iliyaasa du gooto. O anndaa ko o haalata. ");
INSERT INTO fuhbkf_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Nde o haalannoo ɗum ndeen, ruulde wari, suddi ɓe. Nde ruulde ndeen suddunoo ɓe fu, taalibaaɓe ɓeen kuli sanne. ");
INSERT INTO fuhbkf_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Daande ƴuuri e ley ruulde ndeen, wi'i: —O woni Ɓiyam cuɓaaɗo. Kettindanee mo! ");
INSERT INTO fuhbkf_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Nde daande ndeen tilinoo fu, Iisaa kam tan tawaa toon. Taalibaaɓe ɓeen cuuɗi kabaaru oon. Ley balɗe ɗeen, ɓe kaalanaay fay gooto ko ɓe nji'i ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Jaango majjum, nde ɓe njippinoo waamnde ndeen, jamaa keewɗo jakkitii mo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","E ley jamaa oon, gorko gooto ƴeewnii, wi'i: —Moodibbo, miɗo nyaage, tinna ndaaranam ɓiyam gorko, sabo kam tan ngoodumi. ");
INSERT INTO fuhbkf_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ginnaaru ina nannga mo, o feekoo wakkati gooto, imo diwna faa hunnduko makko wurtina nguufo. Ndu yoppataa mo si wanaa terɗe makko fuu nawnoo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Mi nyaagake taalibaaɓe maa ɓeen ndiiwa ndu, de ɓe kunngii. ");
INSERT INTO fuhbkf_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Iisaa jaabii, wi'i: —Hey jamaanu bonɗo mo walaa goonɗinal. Faa ndey ngondammi e mooɗon? Faa ndey keddotoomi munyande on? Waddanam suka maa o ɗo! ");
INSERT INTO fuhbkf_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Nde suka oon warannoo ndeen, ginnaaru nduun liɓi ɗum e leydi, heddii ina diwnina ɗum. Ndeen Iisaa sappani ginnaaru nduun e semmbe, danni suka oon, hokkiti ɗum baaba muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ɗum haaynii yimɓe ɓeen fuu sanne saabe baawɗe Laamɗo mawɗe ɗeen. E ley ko jamaa oon fuu haaynaa e golle Iisaa ɗuum, o wi'i taalibaaɓe makko ɓeen: ");
INSERT INTO fuhbkf_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Onon le, omtee noppi mon, nanon ko kaalammi: Ɓii Neɗɗo wattete e juuɗe yimɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ammaa ɓe paamaay haala kaan, maanaa makka ina suuɗanii ɓe, faa ɓe kunngii annditinde ka. Ɓe kulii ƴamtindaade mo dow makka du. ");
INSERT INTO fuhbkf_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ndeen taalibaaɓe ɓeen ina njeddundura moy ɓuri teddude hakkunde muɓɓen. ");
INSERT INTO fuhbkf_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Iisaa annditi ko ɓe miilotoo ley ɓerɗe maɓɓe. O hooƴi cukalel, o darni ngel ɗakkol makko, ");
INSERT INTO fuhbkf_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","o wi'i ɓe: —Neɗɗo fuu jaɓɓiiɗo cukalel ngel e innde am, wo miin jaɓɓii. Jaɓɓiiɗo kam du, jaɓɓake Nulɗo kam. Sabo ɓurɗo famɗude hakkunde mooɗon fuu, kam woni tedduɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yuhanna haali, wi'i: —Joomam, min nji'ii gorko gooto ina riiwra ginnaaji e innde maa, de min kaɗi mo, sabo o waldaa e meeɗen. ");
INSERT INTO fuhbkf_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Iisaa wi'i mo: —Taa kaɗee mo ɗum, sabo mo salaaki on fuu ina wondi e mooɗon. ");
INSERT INTO fuhbkf_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Nde wakkati ƴeentugol Iisaa dow kammu ɓadinoo fu, siini yahan Urusaliima, ");
INSERT INTO fuhbkf_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","nuli nulaaɓe ardoo ɗum. Nulaaɓe ɓeen naati ley wuro Samariyankooɓe wooto faa cegilanoo mo weerdude. ");
INSERT INTO fuhbkf_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ammaa wuro ngoon jaɓɓaaki mo, sabo Urusaliima o fa'i. ");
INSERT INTO fuhbkf_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Nde Yaakuuba e Yuhanna nji'unoo ɗum ndeen, mbi'i: —Joomii amin, yalla aɗa yiɗi min njamira yiite ƴuura dow kammu wula ɓe naa? ");
INSERT INTO fuhbkf_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ndeen Iisaa hucciti e maɓɓe, feli ɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Caggal ɗuum ɓe njehi wuro wonngo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","E ley jahaangal maɓɓe ngaal, goɗɗo wi'i mo: —To njahataa fuu mi jokkete. ");
INSERT INTO fuhbkf_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Iisaa wi'i mo: —Baagaaji ina njogii gayɗe, pooli du ina njogii cuuɗi, ammaa Ɓii Neɗɗo walaa fay nokku ɗo fukkina hoore muuɗum fowta. ");
INSERT INTO fuhbkf_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","O wi'i goɗɗo katin: —Jokkam! Oon jaabii mo, wi'i: —Joomam, accu mi yaha mi uwowa baaba am tafon. ");
INSERT INTO fuhbkf_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Iisaa wi'i mo: —Accu maayɓe uwa maayɓe muɓɓen. Aan kaa, yahu mbaajoɗaa kabaaru laamu Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Goɗɗo katin wi'i mo: —Joomam, mi jokkete, de accu mi waynowoo yimɓe am tafon. ");
INSERT INTO fuhbkf_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Iisaa jaabii mo, wi'i: —Neɗɗo fuu nannguɗo jalo sari de na yeeƴoo, walaa ko nafata ley laamu Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Caggal ɗuum, Iisaa suɓii katin capanɗe njeɗɗo e ɗiɗo, nuldi ɓe ɗiɗo ɗiɗo, ɓe ardoo ɗum e wuro fuu e nokku fuu to o anniyii yaade, kanko e hoore makko. ");
INSERT INTO fuhbkf_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","O wi'i ɓe: —Gese ɓennduɗe ina keewi, ammaa taƴooɓe keewaa. Ndelle, ŋaaree Jom tayri nulda taƴooɓe ley gese muuɗum ɗeen. ");
INSERT INTO fuhbkf_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Njehee. Si goonga miɗo nula on hono wo on ɓiɓɓe baali hakkunde pobbi. ");
INSERT INTO fuhbkf_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Taa kooƴee dannga, naa mbasu, naa paɗe. Taa njowton fay gooto e dow laawol. ");
INSERT INTO fuhbkf_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Galle mo naatoton fuu, njowton joomum tafon, mbi'on: «Wo jam wondu e galle o!» ");
INSERT INTO fuhbkf_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Si neɗɗo jom jam na woni ɗoon, du'aare mon hewtan ɗum. Ammaa si walaa, du'aare mon wartan e mooɗon. ");
INSERT INTO fuhbkf_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Njippoɗon e galle oon. Ko ɓe kokki on fuu nyaamon, njaron, sabo golloowo ina haandi e njobdi muuɗum. Taa ngaɗon naata-wurtoo ley galleeji. ");
INSERT INTO fuhbkf_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Wuro fuu ngo naatuɗon, si on njaɓɓaama, nyaamon ko kokkaɗon fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ndannon nyawɓe wonɓe ɗoon, mbi'on yimɓe wuro ɓeen: «laamu Laamɗo ɓadake on.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Wuro fuu ngo naatuɗon, si on njaɓɓaaka ley maggo, mburtoɗon e laabi mum, mbi'on: ");
INSERT INTO fuhbkf_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","«Min piɗɗanii on fay colla wuro mooɗon takkuɗo e koyɗe amin. Ammaa anndee: laamu Laamɗo ɓadake.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Miɗo haalana on: Nyannde darngal, jukkungo wuro ngoon ɓuran ngo Sodoma ngoon bonde. ");
INSERT INTO fuhbkf_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Bone woodanii ma, aan Korasin! Bone woodanii ma, aan Baytisayda! Sabo si kaayeefiiji gaɗanooɗi e ley mooɗon ɗiin ngaɗanooma Tirus e Sidon fu, tawete wonɓe toon ɓeen tuubiino law. Tawete ɓe ɓornakeno tekke bootooji, ɓe njooɗakeno ley ndoondi, faa ɓe kolla ɓe tuubii. ");
INSERT INTO fuhbkf_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Saabe ɗuum, nyannde darngal, jukkungo mooɗon ɓuran ngo Tirus e Sidon ngoon bonde. ");
INSERT INTO fuhbkf_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Aan du Kafarnahum, aɗa miiloo a toownete faa yaha kammu naa? A leeƴinte faa kettaa ley maayɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","O haalani taalibaaɓe makko katin: —Kettindaniiɗo on fuu, miin hettindanii. Calaniiɗo on fuu, miin salanii. Calaniiɗo kam fuu, salanake Nulɗo kam oon du. ");
INSERT INTO fuhbkf_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Capanɗe njeɗɗo e ɗiɗo ɓeen ngartidi e seyo, mbi'i: —Joomii amin, fay ginnaaji bonɗi ɗiin ɗowtanake min saabe innde maa. ");
INSERT INTO fuhbkf_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","O wi'i ɓe: —Mi yi'ii Seyɗaani ina ƴuura dow kammu, ina saama hono maƴƴere. ");
INSERT INTO fuhbkf_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Nanee, mi hokkii on baawɗe yaaɓude bolle e jahe, mi hokkii on jaalaade baawɗe ganyo fuu. Huunde fuu torrataa on fes. ");
INSERT INTO fuhbkf_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ammaa taa ceyoree ko ginnaaji ɗowtanii on ɗuum. Ceyoree ko inɗe mon mbinndaa dow kammu ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Wakkati oon, Ruuhu Ceniiɗo hebbini Iisaa seyo. Iisaa wi'i: —Baaba, jom kammu e leydi, mi yettii ma, sabo a suuɗii kulle ɗe jom'en hakkillo e jom'en anndal, de ɓanginanɗaa ɗe cukaloy. Ayyo, noon jaati Baaba, sabo ɗuum weli maa. ");
INSERT INTO fuhbkf_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Baaba am wattii huunde fuu ley junngo am. Fay gooto anndaa Ɓiɗɗo si wanaa Baabiiwo. Fay gooto anndaa Baabiiwo du si wanaa Ɓiɗɗo, e mo Ɓiɗɗo oon muuyi ɓanginande. ");
INSERT INTO fuhbkf_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ndeen Iisaa hucciti e taalibaaɓe ɓeen, haalani ɗum'en kam'en tan, wi'i: —Barke woodanii gite jiiɗe ko nji'oton ɗuum! ");
INSERT INTO fuhbkf_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Sabo miɗo wi'a on, annabaaɓe heewɓe e kaanankooɓe heewɓe na njiɗunoo yi'ude ko nji'oton ɗuum, de ɓe nji'aay. Iɓe njiɗunoo nanude ko nanoton ɗuum, de ɓe nanaay. ");
INSERT INTO fuhbkf_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ndeen, jannginoowo Tawreeta gooto ummii faa ndaartindoo mo, wi'i: —Moodibbo, noy kaanumi waɗude faa mi heɓa nguurndam nduumiiɗam? ");
INSERT INTO fuhbkf_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Iisaa jaabii mo, wi'i: —Ɗume winndaa ley Tawreeta? Ɗume njanngataa ley toon? ");
INSERT INTO fuhbkf_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Jannginoowo Tawreeta oon jaabii, wi'i: —Njiɗiraa Laamɗo, Joomiraaɗo maa e ɓernde maa fuu e yonki maa fuu e semmbe maa fuu e hakkillo maa fuu. Njiɗiraa gondo maa no njiɗirɗaa hoore maa ni. ");
INSERT INTO fuhbkf_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Iisaa wi'i mo: —Jaabu maa o wooɗii. Waɗu noon, ndeen a wuuran! ");
INSERT INTO fuhbkf_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Kaa jannginoowo Tawreeta oon ina yiɗi heedude e goonga, wi'i mo: —Moy woni gondo am? ");
INSERT INTO fuhbkf_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Iisaa jaabii mo, wi'i: —Gorko gomma ƴuurii Urusaliima, ina yaha Yeriko, hawri e yanooɓe. Ɓe ɓorti mo, ɓe piyi mo faa ɓe mbayri mo imo ɓadii maayde. ");
INSERT INTO fuhbkf_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Tawi almaami gooto ina wara dow laawol ngool. Nde o yi'unoo janaaɗo oon ina waalii ɗoon fu, o wosii ɗum, o faltii. ");
INSERT INTO fuhbkf_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Noon Lewinke gomma du wari nokku oon. Nde yi'unoo mo fu, wosii mo, faltii. ");
INSERT INTO fuhbkf_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ammaa Samariyanke jahoowo wari to makko, yi'i mo, yurmii mo, ");
INSERT INTO fuhbkf_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","ɓattii mo, sawriri barme makko ɗeen nebbam e cabijam, fiili ɗum leppi. Caggal ɗuum, o waɗɗini ɗum araawa makko, o yaari ɗum nokkuure to weerɓe njippotoo, o hinnii ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Jaango majjum, o itti buuɗi cardi ɗiɗi, o hokki jom weerdude oon, o wi'i ɗum: «Hinna mo. Si o nyaamii ko ɓuri ɗum, nde ngartumi fu, mi yoɓete.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Nde Iisaa hantunoo banndol ngol ndeen, wi'i: —E miilo maa, moy e tato ɓeen laatii gondo janaaɗo oon? ");
INSERT INTO fuhbkf_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Jannginoowo Tawreeta oon jaabii, wi'i: —Jurmiiɗo mo oon. Iisaa wi'i mo: —Aan du, yahu, waɗoy hono noon! ");
INSERT INTO fuhbkf_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","E jahaangal maɓɓe ngaal, Iisaa fanti wuro wooto, de debbo bi'eteeɗo Marta jippini ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta ina woodi minyiiwo bi'eteeɗo Mariyama. Oon ina jooɗii ɗakkol koyɗe Iisaa, ina hettindii haala muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","De Marta le, golleeji muuɗum keewɗi ɗiin tan ngoni e hakkillo muuɗum, wari, wi'i: —Joomam, a hillaaka ko minyam o yoppidi kam e golleeji ɗi ɗuum naa? Wi'u mo, o walla kam! ");
INSERT INTO fuhbkf_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Iisaa jaabii mo, wi'i: —Marta, Marta, aɗa tampina hoore maa e kujje keewɗe, aɗa jiiɓa hakkillo maa. ");
INSERT INTO fuhbkf_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ammaa huunde wootere tan woni ko haani. Ko Mariyama suɓii ɗuum wo ngeɗu lobbu, o teetataake ɗum du. ");
INSERT INTO fuhbkf_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Nyannde gomma, Iisaa ina du'oo e nokku gomma. Nde o tilinoo ndeen, gooto e taalibaaɓe makko ɓeen wi'i mo: —Joomii amin, janngin min no min ndu'ortoo, hono no Yaayaa jannginiri taalibaaɓe muuɗum noon. ");
INSERT INTO fuhbkf_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","O wi'i ɓe: —Nde ndu'otoɗon fuu, mbi'on: «Baabiiwo, innde maa laatoo seniinde, laamu maa wara. ");
INSERT INTO fuhbkf_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Kokkoraa min nyannde fuu nyaamdu heƴooru min. ");
INSERT INTO fuhbkf_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Njaafonoɗaa min hakkeeji amin, sabo minen du miɗen njaafoo waɗooɓe min hakkeeji fuu. Taa accu min njarribee.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","O wi'i ɓe katin: —Si gooto mon yehii to yigoo muuɗum hakkunde jemma, wi'ii ɗum: «Yigoo am, nyamlam buuruuje tati, ");
INSERT INTO fuhbkf_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","sabo yigoo am gonɗo e laawol jippake wuro am, de mi walaa ko mi hokka ɗum», ");
INSERT INTO fuhbkf_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","yalla yigoo maa oon jaabete ley galle toon, wi'e: «Taa torram, sabo dammbugal ngal sokaama, miin e sukaaɓe am du min pukkake, mi waawaa ummaade faa mi hokke fay huunde»? ");
INSERT INTO fuhbkf_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Miɗo wi'a on, fay si o ummaaki o hokkire saabe wo a yigiiko, o ummoto, o hokke haddi ko kaajaɗaa ɗuum, taa o hersa. ");
INSERT INTO fuhbkf_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Miin, miɗo wi'a on: ŋaaree, on keɓan. Pilee, on njiitan. Calminee, on omtante. ");
INSERT INTO fuhbkf_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Sabo ŋaariiɗo fuu heɓan. Piliiɗo fuu yiitan. Calminɗo fuu omtante. ");
INSERT INTO fuhbkf_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Moy e mooɗon woni baabiiwo mo ɓiyum ŋaarotoo liingu, de hokka ɗum mboddi? ");
INSERT INTO fuhbkf_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Naa ŋaaroo ɗum ɓoccoonde, de hokka ɗum yaare? ");
INSERT INTO fuhbkf_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ndelle no mbonirɗon nii fuu, oɗon anndi no kokkirton ɓiɓɓe mooɗon kulle lobbe, sakko Baaba mooɗon gonɗo dow kammuuli. Ŋaariiɗo mo fuu, o hokkan ɗum Ruuhu Ceniiɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Nyannde gomma, Iisaa ina riiwa ginnaaru muumɗinndu goɗɗo. Nde ginnaaru nduun wurtinoo ndeen, muumo oon fuɗɗi haalude. Ɗum haaynii jama'aaje ɗeen. ");
INSERT INTO fuhbkf_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","De woɓɓe maɓɓe ina mbi'a: —Wo e baawɗe Beeljebul, hooreejo ginnaaji oon, o riiwrata ginnaaji. ");
INSERT INTO fuhbkf_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Woɓɓe ŋaarii mo maande ƴuuroore dow kammu faa ndaartindoo mo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Kanko le, imo anndi miilooji maɓɓe, o wi'i ɓe: —Laamu fuu pecciingu ina habda, halkan. Katin du, si galle feccake na habda fu, cankitoto. ");
INSERT INTO fuhbkf_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Si Seyɗaani e hoore mum feccake fu, noy laamu mum heddortoo? Miɗo wi'a on ɗum saabe ko mbiiɗon wo e baawɗe Beeljebul ndiiwrammi ginnaaji ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Si tawii miin miɗo riiwra ginnaaji e baawɗe Beeljebul, jokkuɓe on ɓeen le, moy ndiiwrata ɗi? Ndelle golle maɓɓe jaati kollata on ngalaa e goonga! ");
INSERT INTO fuhbkf_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ammaa si tawii junngo Laamɗo ndiiwrammi ginnaaji, ɗum ina holla laamu Laamɗo warii to mooɗon. ");
INSERT INTO fuhbkf_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Gorko jom semmbe tiigiiɗo kaɓitirɗe, si haybii galle mum, jawdi mum reenoto. ");
INSERT INTO fuhbkf_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ammaa si ɓurɗo ɗum semmbe warii to muuɗum, jaalake ɗum fu, teetan ɗum kaɓitirɗe mum ɗe yownoo hoolaare muuɗum dow muɓɓen ɗeen, fecca jawdi muuɗum ndiin e woɓɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Mo waldaa e am fuu, wo ganyo am. Mo wallataa kam mi hawrundura fuu, wo cankitoowo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Si ginnaaru wurtake e neɗɗo fu, ndu yiiltoyto e nokkuuje joorɗe indu filoo ɗo ndu ŋootta, de ndu heɓataa. Ndeen ndu wi'an: «Mi yeccoto suudu am ndu eggunoomi e muuɗum nduun.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Nde ndu warti fu, ndu tawan suudu nduun fiisaama, moƴƴinaama. ");
INSERT INTO fuhbkf_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ndeen, ndu yahan, ndu waddowa ginnaaji jeɗɗi ɓurɗi ndu bonde. Ɗi naata, ɗi koɗa ley toon. Nii cakitte neɗɗo oon ɓurdata arande muuɗum bonde. ");
INSERT INTO fuhbkf_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Nde o haalannoo ɗum ndeen, debbo gooto ley jamaa oon ƴepti daande muuɗum, wi'i: —Barke woodanii debbo deeduɗo ma mo muynuɗaa! ");
INSERT INTO fuhbkf_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ammaa Iisaa jaabii, wi'i: —Nanooɓe haala Laamɗo de njokki ka ɓeen, kam'en ɓuri heɓude barke! ");
INSERT INTO fuhbkf_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Wakkati mo jama'aaje ɗeen ɓillunduri e makko ndeen, o fuɗɗi wi'ude: —Yimɓe jamaanu o ɓeen wo yimɓe bonɓe. Iɓe piloo maande, de ɓe kokkataake si wanaa maande annabi Yuunusa ndeen. ");
INSERT INTO fuhbkf_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Sabo no Yuunusa laatoranii Niniwenkooɓe maande ni, hono noon Ɓii Neɗɗo du laatorantoo yimɓe jamaanu o maande. ");
INSERT INTO fuhbkf_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Nyannde darngal, kaananke debbo leydi horɗoore ummodoto e worɓe jamaanu o, hiitodoo e muɓɓen, de liɓa ɗum'en. Sabo o ƴuwii faa hoore leydi, o warii faa o hettindoo haalaaji Suleymaana kebbinaaɗi hakkilantaaku. Haya, ɓurɗo Suleymaana ina ɗo! ");
INSERT INTO fuhbkf_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Yimɓe Niniwe du ummodoto e yimɓe jamaanu o nyannde darngal, kiitodoo e muɓɓen, liɓa ɗum'en. Sabo ɓe tuubii gilla nde ɓe nannoo waaju Yuunusa ndeen. De inan, ɓurɗo Yuunusa ina ɗo! ");
INSERT INTO fuhbkf_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","—Fay gooto huɓɓataa lampal, de suuɗa ɗum naa hippa ɗum kaakol. Ko waɗata dey, ngal ɓilete, faa ngal yaynana naatooɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Gite maa ngoni lampal ɓanndu maa. Si gite maa ina mbooɗi, ɓanndu maa fuu heewan annoora. Ammaa si ɗe mbooɗaa, ɓanndu maa fuu heewan nimre. ");
INSERT INTO fuhbkf_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ndelle, haybu, taa annoora gonɗo e maaɗa oon niɓɓa. ");
INSERT INTO fuhbkf_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Sabo si ɓanndu maa fuu heewii annoora, tawa faa'e e mayru walaa e nimre, ndu fuu ndu heewan annoora hono no lampal yaynirante noon. ");
INSERT INTO fuhbkf_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Nde Iisaa tilinoo haalde ndeen, Farisaajo gooto noddi ɗum faa wottodoo e muuɗum. O naatowi, o jooɗii faa o nyaama. ");
INSERT INTO fuhbkf_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Farisaajo oon, ɗum haaynii ɗum nde yi'unoo o fuɗɗii nyaamude tawi o lootaay juuɗe makko. ");
INSERT INTO fuhbkf_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","De Iisaa wi'i mo: —Onon Farisa'en, oɗon lawƴa caggal kore e caggal kaake, tawee le, ɓerɗe mooɗon ina keewi nguyka e bonanda! ");
INSERT INTO fuhbkf_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Onon majjuɓe! Wanaa Taguɗo dow oon tagi ley du naa? ");
INSERT INTO fuhbkf_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Cakkee ko woni ley kore e kaake ɗeen. Ndeen, ko heddii ɗuum fuu laatanto on ko laaɓi. ");
INSERT INTO fuhbkf_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Bone woodanii on, onon Farisa'en! Sabo oɗon ittana Laamɗo jakka naanaa e jakka haako lekkoy ngokkoy e ko aawoton fuu. Kaa oɗon kuyfini dartaare, oɗon kuyfini yidde Laamɗo. Wo kanjum kaannoɗon waɗude tawee on njoppaay ko heddii ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Bone woodanii on, onon Farisa'en! Sabo oɗon njiɗi jooɗaade nokkuuje tedduɗe ley cuuɗi baajorɗi, oɗon njiɗi salmineede e nokkuuje ɗe yimɓe keewi. ");
INSERT INTO fuhbkf_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Bone woodanii on! Sabo oɗon nanndi hono caabeeje ɗe ngalaa maande, ɗe yimɓe njahata dow muɓɓen, tawee anndaa. ");
INSERT INTO fuhbkf_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Gooto e jannginooɓe Tawreeta jaabii Iisaa, wi'i: —Moodibbo, no kaalirtaa ni, na huyfina min, minen du. ");
INSERT INTO fuhbkf_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","O jaabii, o wi'i: —Onon jannginooɓe Tawreeta du, bone woodanii on! Sabo oɗon ndonnda yimɓe doŋle tedduɗe, tawee onon e ko'e mon, on meemirtaa ɗe fay e hoore honndu mooɗon. ");
INSERT INTO fuhbkf_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Bone woodanii on, sabo oɗon moƴƴintinoo caabeeje annabaaɓe ɓe maamiraaɓe mon mbarnoo ɓeen. ");
INSERT INTO fuhbkf_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ndelle oɗon ceedoo golle maɓɓe ɗeen ina mbeli on. Sabo kamɓe, ɓe mbarii annabaaɓe, onon du, oɗon moƴƴintinoo caabeeje muɓɓen! ");
INSERT INTO fuhbkf_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ɗum le, Laamɗo hakkilanteejo wi'i: «Mi nuldan ɓe annabaaɓe e nulaaɓe, ɓe mbara yoga, ɓe torra yoga.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ɗum waɗi de ƴiiƴam annabaaɓe ndufaaɗam gilla e fuɗɗoode adunaaru ɗaam, ina yomnitoree e yimɓe jamaanu o, ");
INSERT INTO fuhbkf_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","gilla e ƴiiƴam Haabiila faa e ƴiiƴam Jakariyaa baraaɗo hakkunde hirsirde e suudu dewal mawndu nduun. Miɗo haalana on goonga: ɗum fuu ɗum yomnitorte e jamaanu o. ");
INSERT INTO fuhbkf_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Bone woodanii on, onon jannginooɓe Tawreeta! Sabo on teetii cokitirgal anndal. Onon e ko'e mon on naataay, de yiɗuɓe naatude ɓeen du, on accaay naata. ");
INSERT INTO fuhbkf_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Nde Iisaa dillunoo ɗoon, jannginooɓe Tawreeta e Farisa'en ina ɓernani ɗum sanne sanne. Iɓe ƴama mo kulle keewɗe, ");
INSERT INTO fuhbkf_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","heddii iɓe tuufa mo faa ɓe keɓa e hunnduko makko ko ɓe nanngira mo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Wakkati oon yimɓe ujunaaje sowre kawriti faa ina njaaɓundura. Ndeen Iisaa wi'i taalibaaɓe mum ɓeen: —Ndeentee e rabilla Farisa'en, ɗum woni naafikaare. ");
INSERT INTO fuhbkf_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Walaa fuu ko suddii ko sudditataake, walaa ko suuɗii ko ɓangintaake. ");
INSERT INTO fuhbkf_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ɗum waɗi huunde fuu ko kaalɗon ley nimre nanete ley annoora. Katin du ko cowndiɗon ley cuuɗi ommbaaɗi fuu, gooynete faa dow cuuɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Miɗo haalana on, onon yigiraaɓe am: taa kulee warooɓe ɓanndu de walaa fuu ko mbaawi gaɗa ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Mi hollan on mo kaanɗon hulde: kulon baroowo neɗɗo, jogiiɗo baawɗe nannude ɗum ley jahannama. Goonga, miɗo wi'a on: oon kaanɗon hulude! ");
INSERT INTO fuhbkf_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Wanaa pooloy njoyoy ina coottee buuɗi ɗiɗi tan naa? Ammaa fay e noon, Laamɗo yeggitataa fay gootel e makkoy. ");
INSERT INTO fuhbkf_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ko ɓuri noon du, fay ngaasa ko'e mooɗon fuu limaama faa laaɓi. Ndelle, taa kulee, sabo oɗon ɓuri pooli keewɗi teddude. ");
INSERT INTO fuhbkf_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Miɗo wi'a on: neɗɗo fuu jaɓanɗo kam yeeso yimɓe, miin Ɓii Neɗɗo du mi jaɓan ɗum yeeso maleyka'en Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ammaa caliiɗo kam yeeso yimɓe, salete yeeso maleyka'en Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Neɗɗo fuu kaalɗo ko boni e dow Ɓii Neɗɗo, ina waawi yaafeede. Ammaa mbonkiiɗo Ruuhu Ceniiɗo yaafataake. ");
INSERT INTO fuhbkf_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Nde yimɓe njaari on to cuuɗi baajorɗi naa yeeso hooreeɓe naa laamiiɓe taa mbemmbeɗon ko njaabotoɗon, naa ko kaaloton, ");
INSERT INTO fuhbkf_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","sabo Ruuhu Ceniiɗo anndinan on wakkati oon ko kaanɗon haalde. ");
INSERT INTO fuhbkf_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Goɗɗo ley jamaa oon wi'i: —Moodibbo, wi'u mawnam o hokka kam ngeɗu am e ndongu amin. ");
INSERT INTO fuhbkf_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","O jaabii ɗum, o wi'i: — Hey gorko, moy waɗi kam carotooɗo mon naa peccoowo jawdi mon? ");
INSERT INTO fuhbkf_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","O wi'i jamaa oon: —Tinnee ndeentee e eelgal jawdi fuu, sabo wanaa jawdi wuurnata neɗɗo, fay si tawaa wo jom jawdi. ");
INSERT INTO fuhbkf_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","O banndani ɓe banndol, o wi'i: —Jom jawdi gomma, gese muuɗum mbooɗiino sanne. ");
INSERT INTO fuhbkf_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Imo miiloo e hoore makko: «Noy ngaɗammi? Sabo mi walaa fuu ɗo mi resa nyaamri am ndi. ");
INSERT INTO fuhbkf_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ayyo, nii ngaɗammi: mi liɓan beembe am ɗeen, mi nyiɓa goɗɗe ɓurɗe ɗe manngu, mi resa nyaamri am ndi e jawdi am fuu toon. ");
INSERT INTO fuhbkf_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","De mi wi'a e hoore am: A heɓii jawdi mbaawndi jogaade ma duuɓi keewɗi. Fowtu, nyaamaa, njaraa, mbeltoɗaa.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ammaa Laamɗo wi'i mo: «Aan pamɗuɗo hakkillo! Yonki maa ittete e jemma o. Moy adata ko paggiɗaa ɗuum?» ");
INSERT INTO fuhbkf_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Nii woni sifa neɗɗo fuu pagganiiɗo hoore muuɗum jawdi, de wanaa jom jawdi yeeso Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ndeen o wi'i taalibaaɓe makko ɓeen: —Ɗum waɗi miɗo wi'a on: taa nguurndam mon haɓɓa on ko'e e ko nyaamoton. Taa ɓalli mon du kaɓɓa on ko'e e ko ɓornotoɗon. ");
INSERT INTO fuhbkf_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Sabo nguurndam ina ɓuri nyaamdu, ɓanndu du ina ɓuri koltal. ");
INSERT INTO fuhbkf_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Taykee dowdaake le: ɗe aawataa, ɗe taƴataa, ɗe ngalaa resirde, ɗe ngalaa beembe, ammaa Laamɗo ina nyaamna ɗe. Onon, oɗon ɓuri pooli ɗiin to woɗɗi! ");
INSERT INTO fuhbkf_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Moy e mooɗon waawi ɓeydude balɗe muuɗum fay nyalooma gooto saabe kaɓɓu-ko'u muuɗum? ");
INSERT INTO fuhbkf_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ndelle, si tawii on mbaawaa waɗude fay hono ɗum e famɗude, ko waɗi oɗon kaɓɓi ko'e mon e dow ko heddii ɗuum? ");
INSERT INTO fuhbkf_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ƴeewee pinndiiji no mawnirta. Ɗi tampataa, ɗi mottataa. Ammaa miɗo wi'a on, fay Suleymaana e darja muuɗum fuu holtiraay hono gootel e majji ni. ");
INSERT INTO fuhbkf_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Laamɗo ina holtinira ni huɗo wonko ley ladde hannden, faɗɗeteeko e yiite jaango, sakko onon, onon famɗuɓe hoolaare! ");
INSERT INTO fuhbkf_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Taa kilnee filaade ko nyaametee e ko yaretee, taa ɗum haɓɓa on ko'e! ");
INSERT INTO fuhbkf_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Sabo kulle ɗeen fuu, wo yimɓe adunaaru pilotoo ɗe. De Baaba mon ina anndi oɗon kaajaa ɗe. ");
INSERT INTO fuhbkf_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ammaa piloɗon laamu Laamɗo, ndeen on ɓeydante ko heddii ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Taa kulee, onon coggal pamaral, sabo Baaba mooɗon ina seyorii hokkude on laamu muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Connee jawdi mon fuu, cakkon. Moƴƴinanee ko'e mon danngaaji ɗi mbonataa, njogoɗon jawdi ngonndi dow kammu ndi timmataa, ndi gujjo ɓadataako, mooƴu du bonnataa. ");
INSERT INTO fuhbkf_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Sabo ɗo jawdi mooɗon woni fuu, ɗoon ɓerɗe mooɗon du ngonata. ");
INSERT INTO fuhbkf_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","—Kaɓɓee kaɓɓorɗi mon faa ngollon, kuɓɓee lampe mon. ");
INSERT INTO fuhbkf_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Laatee hono yimɓe segilaniiɓe jakkitaade jom muɓɓen nde wartata weltaare ɓangal, faa omtanon ɗum wakkati nde yottii salmini fu. ");
INSERT INTO fuhbkf_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Barke woodanii maccuɓe ɓe jom muɓɓen tawi ina kakkilani ɗum. Goonga kaalanammi on: o haɓɓoto kaɓɓorgol makko saabe golle, o joƴƴina ɓe faa ɓe nyaama, o wara o gollana ɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Si o wartii hakkunde jemma, naa hejjere fu, barke woodanii ɓe o tawri noon ɓeen. ");
INSERT INTO fuhbkf_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Paamee ɗum ɗo: si jom galle ina anndunoo wakkati mo gujjo warata, yoppataano o naata suudu muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Onon du, cegilee, sabo Ɓii Neɗɗo waran e wakkati mo on miilaaki. ");
INSERT INTO fuhbkf_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Piyeer wi'i mo: —Joomam, banndol ngol le, wo minen tan kaaldataa naa yimɓe fuu? ");
INSERT INTO fuhbkf_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Iisaa jaabii, wi'i: —Moy woni golloowo koolniiɗo, jom hakkillo, mo joomum halfinta gollooɓe mum faa hokka ɓe ngeɗu maɓɓe nyaamdu e wakkati kaanɗo? ");
INSERT INTO fuhbkf_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Barke woodanii golloowo mo joomum warti, tawi ina waɗa noon. ");
INSERT INTO fuhbkf_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Goonga kaalanammi on: joomiiko oon halfinan mo jawdi muuɗum fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ammaa si golloowo oon wi'ii ley ɓernde mum joomum oon ɓooyii wartaay, de fuɗɗi ina fiya maccuɓe e horɓe, ina nyaama ina yara ina suloo, ");
INSERT INTO fuhbkf_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ndeen kaa, joomiiko wartan nyalooma mo o anndaa e wakkati mo o miilaaki. Joomiiko oon jukkoto mo jukkungo naawngo, watta mo hakkunde ɓe ngoonɗinaay. ");
INSERT INTO fuhbkf_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Golloowo annduɗo ko joomum yiɗi, de segilaaki, gollaay ko joomum yiɗi fu, fiyete ɓoggi keewɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Kaa mo anndaa ko joomum yiɗi, de waɗi ko jeyi fiyeede, fiyete ɓoggi seeɗa. Kokkaaɗo ko ɗuuɗi, ƴamete ko ɗuuɗi. Kalfinaaɗo ko heewi, ƴamete ko ɓuri heewde. ");
INSERT INTO fuhbkf_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","—Mi warii faa mi faɗɗa yiite e leydi ndi. Miɗo heppi nge huɓɓa law! ");
INSERT INTO fuhbkf_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ina woodi lootagal batisima naawngal ngal looteteemi. Miɗo torroo faa ɗum tabita! ");
INSERT INTO fuhbkf_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Oɗon miiloo wo jam ngardumi adunaaru naa? Wanaa! Miɗo wi'a on: ko ngardumi dey, wo senndude. ");
INSERT INTO fuhbkf_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Gilla joonin yimɓe njoyo wonduɓe ley wuro wooto ceedan, tato kabdan e ɗiɗo, ɗiɗo kabdan e tato. ");
INSERT INTO fuhbkf_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Baaba habdan e ɓiyum gorko, ɓiɗɗo gorko du habdan e bammum, inna habdan e ɓiyum debbo, ɓiɗɗo debbo du habdan e inna muuɗum, esiyo debbo habdan e dee ɓiyum, dee ɓiɗɗo du habdan e esum debbo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Iisaa wi'i jama'aaje ɗeen katin: —Si on nji'ii ruulde ina ƴuura gorgal tan, on mbi'an nde toɓan. Laatorto hono noon du. ");
INSERT INTO fuhbkf_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Si henndu horɗoore wifii, on mbi'an wulan jaw. Ɗum laatorto noon du. ");
INSERT INTO fuhbkf_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Onon munaafiki'en! Oɗon mbaawi senndude alhaali leydi e kammu. Ko waɗi de on mbaawaa senndude alhaaliiji jamaanu o? ");
INSERT INTO fuhbkf_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Ko waɗi on mbaawaa annditande ko'e mon ko fonnditii? ");
INSERT INTO fuhbkf_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Si aɗa yaada e kabdo maa faa cardowon, fila rewritinde e makko gilla e dow laawol, taa o yaare to carotooɗo, de carotooɗo oon hokke doomoowo kasu, de doomoowo oon du udde ley kasu. ");
INSERT INTO fuhbkf_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Miɗo haalane: abada a wurtataako, si a yoɓaay ko ndeweteɗaa ɗuum faa laaɓi. ");
INSERT INTO fuhbkf_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Wakkati oon, woɓɓe ngari kaalani Iisaa ko hewtii Galilinkooɓe woɓɓe. Ɓe mbi'i Pilaatu jillundurii ƴiiƴam maɓɓe e ƴiiƴam sadakaaji maɓɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Iisaa jaabii ɓe, wi'i: —Yalla oɗon miiloo kamɓe ɓuri luttude diina e Galilinkooɓe heddiiɓe ɓeen fuu naa? Oɗon miiloo wo saabe ɗuum waɗi de ɓe torriraa noon naa? ");
INSERT INTO fuhbkf_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Miɗo haalana on: wanaa noon. De si on tuubaay, on fuu hono noon kalkirton. ");
INSERT INTO fuhbkf_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Oɗon miccoo yimɓe sappo e njetto ɓe suudu Silowam toowndu nduun saami dow muɓɓen faa maayi ɓeen. Yalla oɗon miiloo kamɓe ɓuri yimɓe Urusaliima fuu junuuba naa? ");
INSERT INTO fuhbkf_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Miɗo haalana on: wanaa noon. De si on tuubaay, on fuu hono noon kalkirton. ");
INSERT INTO fuhbkf_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ndeen o banndani ɓe banndol ngol, o wi'i: —Ƴibbi ngooti ina wonnoo ley ngesa neɗɗo gomma. O wari ɓorude ki, de o tawraay ki fay huunde. ");
INSERT INTO fuhbkf_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","O wi'i golloowo ngesa oon: «Nii woni duuɓi tati miɗo wara filaade ɓiɓɓe ƴibbi ki, de mi tawaay. Soppu ki! Ko waɗi iki itta semmbe leydi ndi?» ");
INSERT INTO fuhbkf_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Golloowo oon wi'i mo: «Joomam, accu ki ɗo faa mawuuri. Ɗo e ndeen, mi reman mi fiiltina ki, mi watta birgi. ");
INSERT INTO fuhbkf_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ina hasii ki riman ɗo e mawuuri. Si ki rimaay du, coppaa ki.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Nyannde fowteteende gomma, Iisaa ina waajoo ley suudu waajordu wooturu. ");
INSERT INTO fuhbkf_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Debbo gomma mo ginnaaru nyawni ko waɗi duuɓi sappo e jeetati ina tawaa ɗoon. O turiiɗo tan, o waawaa dartaade fey. ");
INSERT INTO fuhbkf_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Nde Iisaa yi'unoo mo ndeen, noddi mo, wi'i mo: —Banndam debbo, a daɗii nyawu maa ngu. ");
INSERT INTO fuhbkf_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Iisaa yowi juuɗe mum dow makko, de wakkati gooto o dartii cet, imo yetta Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","De hooreejo suudu waajordu nduun na mettaa ko Iisaa danni goɗɗo nyannde fowteteende ɗuum, wi'i yimɓe ɓeen: —Balɗe jeegom jeyɗe golleede ina ngoodi. E ley balɗe ɗeen kaanɗon warude ndanneɗon, wanaa nyannde fowteteende. ");
INSERT INTO fuhbkf_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Iisaa jaabii mo, wi'i: —Onon munaafiki'en! Wanaa mono e mooɗon fuu ina haɓɓita ngaari muuɗum naa araawa muuɗum nyannde fowteteende yarnowa ɗum naa? ");
INSERT INTO fuhbkf_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Debbo o wo taan Ibrahiima, mo Seyɗaani haɓɓiri duuɓi sappo e jeetati. Wanaa imo jeyi haɓɓiteede nyannde fowteteende naa? ");
INSERT INTO fuhbkf_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Nde o haalannoo ɗum ndeen, wayɓe mo ɓeen fuu cemti. De jamaa oon fuu ina ceyii e dow kaayeefiiji ɗi o waɗata ɗiin. ");
INSERT INTO fuhbkf_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Iisaa wi'i: —Noy laamu Laamɗo wa'i? Ɗume nanndinammi ɗum? ");
INSERT INTO fuhbkf_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Laamu Laamɗo ina nanndi e gabbel lekki mutaari ngel neɗɗo hooƴi, aawi ley sardiŋe muuɗum. Aawdi ndiin fuɗi, laatii lekki faa pooli piirooji nyiɓi cuuɗi muɓɓen e licce makki. ");
INSERT INTO fuhbkf_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","O wi'i katin: —Ɗume nanndinammi e laamu Laamɗo? ");
INSERT INTO fuhbkf_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ina nanndi e rabilla mo debbo hooƴi, diibunduri e etirɗe conndi tati mawɗe faa ɗum fuu ɗum ƴuufi. ");
INSERT INTO fuhbkf_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Iisaa ina rewa ley galluuje e ley gure fuu, ina waajoo, ina fonndii Urusaliima. ");
INSERT INTO fuhbkf_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Neɗɗo gomma ƴami mo: —Joomam, yimɓe seeɗa tan kisata naa? O wi'i ɓe: ");
INSERT INTO fuhbkf_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Ndurwee naatiron dammbugal paaɗungal sabo miɗo wi'a on: heewɓe tefan naatude, de kunngoo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Si jom galle oon ummake, sokii dammbugal muuɗum, tawi onon oɗon keddii yaasin, oɗon calmina, oɗon mbi'a: «Joomii amin, omtan min», ndeen o jaaboto on: «Mi anndaa to njeyaɗon!» ");
INSERT INTO fuhbkf_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ndeen, on puɗɗan wiide: «Min nyaamdii e maa, min njardii e maa, a waajake dow laabi amin.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ndeen o jaaboto on: «Mi anndaa to njeyaɗon. Mboɗɗee kam, onon waɗooɓe ko boni!» ");
INSERT INTO fuhbkf_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","On mboyan, on nyerƴunduran nyiiƴe nde nji'oton Ibrahiima e Isiyaaka e Yaakuuba, kam'en e annabaaɓe fuu ley laamu Laamɗo, tawa onon on faɗɗaaɓe yaasin. ");
INSERT INTO fuhbkf_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Yimɓe ƴuuran lettugal e gorgal, horɗoore e soɓɓiire, njooɗoo nyaamda ley laamu Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Goonga ni, sakitiiɓe woɓɓe ardoto, ardiiɓe woɓɓe du cakitoto. ");
INSERT INTO fuhbkf_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Wakkati oon, Farisa'en woɓɓe ngari, mbi'i mo: —Dillu ɗo, njahaa e yaadu maa, sabo Hirudus kaananke oon ina muuyi warude ma. ");
INSERT INTO fuhbkf_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","O wi'i ɓe: —Njehee mbi'owee baagayel ngeel: «Ndaar, mi riiwan ginnaaji, mi dannan nyawɓe hannden e jaango. De nyannde tataɓerde mi yottinan golle am. ");
INSERT INTO fuhbkf_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ammaa ina tilsi mi yaha hannden e jaango e faɓɓi-jaango, sabo annabaajo haanaa maayde si wanaa ley Urusaliima.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Kay Urusaliima, Urusaliima! Aɗa wara annabaaɓe, aɗa warda nulaaɓe to maa kaaƴe! Kile keewɗe njiɗumi hawrundurde ɓiɓɓe maa hono no cofal hawrundurta coppi muuɗum ley bippeele muuɗum ni. De on njaɓaay. ");
INSERT INTO fuhbkf_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Paamon, Laamɗo yoppidii on e suudu mon. Miɗo wi'a on: on nji'ataa kam katin si wanaa faa wakkati mo mbi'oyton: «Barke woodanii garɗo e dow innde Joomiraaɗo!» ");
INSERT INTO fuhbkf_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Nyalaande fowteteende gomma, Iisaa naatii suudu hooreejo Farisa'en gooto faa nyaama. Wonɓe toon ɓeen ina taykoo mo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Gorko ɓuutuɗo ina tawaa yeeso makko ɗoon. ");
INSERT INTO fuhbkf_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Iisaa haaldi e jannginooɓe Tawreeta e Farisa'en, wi'i ɗum'en: —Dannude nyawɗo nyalaande fowteteende, ina dagii naa dagaaki? ");
INSERT INTO fuhbkf_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","De ɓe keddii iɓe ndeƴƴinii. Iisaa tuggi nyawɗo oon, danni ɗum, de yoppi ɗum dilli. ");
INSERT INTO fuhbkf_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ndeen o wi'i ɓe: —Moy e mooɗon ɓiyum naa ngaari mum saamata ley ɓunndu de hunngoo wurtinde ɗum law law, fay si ɗum nyalaande fowteteende? ");
INSERT INTO fuhbkf_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ɓe kunngii jaabaade fay huunde e dow majjum. ");
INSERT INTO fuhbkf_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Wakkati Iisaa yi'i noddaaɓe ɓeen ina cuɓoo nokkuuje ɓurɗe teddude, o banndani ɓe, o wi'i: ");
INSERT INTO fuhbkf_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Si a noddaama ɓangal fu, taa jooɗa e joonnde ɓurnde teddude. Sabo ɓurɗo ma teddude ina waawi warude, ");
INSERT INTO fuhbkf_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","de nodduɗo ma oon wara, wi'e: «Hokku ooɗo jooɗorgal ngal!» Ndeen a semtan, kooƴaa joonnde ɓurnde leeƴude ndeen. ");
INSERT INTO fuhbkf_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ammaa si a noddaama ɓangal fu, njooɗoɗaa to leeƴi, faa nodduɗo ma oon wara, wi'e: «Yigoo am, hewtu dow to wooɗi toon!» Ndeen, ɗum laatante teddeengal yeeso jooɗodiiɓe maa ɓeen fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Sabo mawninkiniiɗo fuu, leeƴinte, leeƴinkiniiɗo du teddinte. ");
INSERT INTO fuhbkf_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","O wi'i nodduɗo mo oon du: —Si aɗa nodda yimɓe mbottaari naa hiraande, taa noddu yigiraaɓe naa banndiraaɓe naa sakiraaɓe naa hoddiiɓe maa jogiiɓe jawdi. Hasii ɓe nodditete de ɗum laatoo njobdi maa. ");
INSERT INTO fuhbkf_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Jonkaa si a waɗii weltaare fu, noddaa talkaaɓe e woyɓe e bonnguuɓe e wumɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ndeen, a barkinte, sabo ɓeen ngalaa ko njoɓire. A yoɓete nyannde dartiiɓe ummintinaa. ");
INSERT INTO fuhbkf_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Gooto e nyaamooɓe ɓeen, nde nannoo haala ka ndeen, wi'i mo: —Barke woodanii nyaamoowo ley laamu Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Iisaa wi'i mo: —Gorko gomma waɗii nyaamdu mawndu, noddi yimɓe faa heewi. ");
INSERT INTO fuhbkf_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Wakkati nyaamdu nduun segilinoo fu, o neli maccuɗo makko to yimɓe ɓeen, wi'a: «Ngaree, nyaamduuji ɗiin cegilaama.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ɓe fuu, ɓe puɗɗi saloraade gooto gooto. Goɗɗo maɓɓe wi'i: «Mi soodii ngesa, ina tilsi mi yaha mi ndaarowa nga, miɗo ŋaare njaafoɗaa kam.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Goɗɗo du wi'i: «Mi soodii ga'i demooji sappo. Mi yahan mi ndaarowa ɗi, miɗo ŋaare njaafoɗaa kam.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Goɗɗo katin wi'i: «Mi ɓaŋuɗo kesum, ɗuum waɗi de mi heɓataa warude.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Maccuɗo oon warti, haalani ɗum joomum. Oon ɓerni, wi'i mo: «Yahu law ley nokkuuje e dow laabi ngalluure nde, ngaddaa talkaaɓe e woyɓe e wumɓe e bonnguuɓe.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Maccuɗo oon warti, wi'i: «Joomam, ko mbiiɗaa ɗuum fuu waɗaama, de faa joonin nokkuure ina heddii.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ndeen joomiiko oon wi'i mo: «Yahu dow laabi jaajuɗi e paaɗuɗi, ndoolɗaa yimɓe ngara naata, faa suudu am ndu heewa. ");
INSERT INTO fuhbkf_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Sabo miɗo wi'a on: fay gooto e ɓe noddunoomi ɓeen meeɗataa nyaamdu am ndu.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Yimɓe heewɓe ina njaada e Iisaa. O hucciti e maɓɓe, o wi'i ɓe: ");
INSERT INTO fuhbkf_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Garɗo to am fuu, sanaa mi ɓurana ɗum bammum e inna muuɗum e jom suudu muuɗum e sukaaɓe muuɗum e minyiraaɓe mum e mawniraaɓe mum, mi ɓurana ɗum fay hoore muuɗum. Si wanaa noon fu, joomum waawaa laataade taalibaajo am. ");
INSERT INTO fuhbkf_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Katin du, mo wakkaaki leggal muuɗum palaangal de jokki kam fuu, waawaa laataade taalibaajo am. ");
INSERT INTO fuhbkf_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Si won muuyɗo e mooɗon nyiɓude suudu toowndu, wanaa joomum jooɗoto tafon, hiisoo ko haajaa, de ndaara yalla na jogii ko tannyata ndu naa? ");
INSERT INTO fuhbkf_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Si wanaa noon, si joomum joƴƴinii de waawaay tannyude, jiiɗo ndu fuu jalan ɗum, ");
INSERT INTO fuhbkf_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","wi'a: «Neɗɗo o fuɗɗii nyiɓude, de hunngii tannyude!» ");
INSERT INTO fuhbkf_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Katin, si kaananke yehii faa habdowa e kaananke goɗɗo, wanaa o jooɗoto tafon o fonnda yalla worɓe makko ujunaaje sappo ɓeen ina mbaawi habdude e jogiiɗo worɓe ujunaaje noogayo? ");
INSERT INTO fuhbkf_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Si tawii o waawaa, o nulan yimɓe to joomum gilla ɓattaaki, faa jam waɗa hakkunde maɓɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Hono noon, fay gooto mooɗon waawaa laataade taalibaajo am si yoppaay ko jogii fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Lamɗam ina wooɗi, ammaa si ɗam selii lamsude, ɗume lamsinta ɗam katin? ");
INSERT INTO fuhbkf_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Walaa fuu ko ɗam nafata, wanaa e leydi, wanaa e birgi. Ɗam faɗɗete yaasin. Jom nowru nanooru fuu, nana. ");
INSERT INTO fuhbkf_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Nanngooɓe lampo e luttuɓe woɓɓe fuu ina ɓadii mo faa kettindanoo mo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Farisa'en e jannginooɓe Tawreeta ina ŋormoo, ina mbi'a: —Gorko o ina jaɓɓoo luttuɓe, ina nyaamda e muɓɓen! ");
INSERT INTO fuhbkf_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ndeen o banndani ɓe banndol ngol, o wi'i: ");
INSERT INTO fuhbkf_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Si gooto mooɗon ina jogii baali hemre, de ngootu lalli, wanaa yoppan capanɗe jeenay e jeenay ɗiin fuu ley ladde, de filowoo lallungu nguun faa yiita ɗum naa? ");
INSERT INTO fuhbkf_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Si o yiitii ɗum fu, o towiran ɗum seyo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Nde o warti galle makko fuu, o noddan yigiraaɓe makko e hoddiiɓe makko, o wi'a ɗum'en: «Ceyodee e am, sabo mi yiitii mbaalu am lallunoongu.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Miɗo haalana on: hono noon seyo laatortoo dow kammuuli si luttoowo gooto tuubii. Ingo ɓuri seyo capanɗe njeenayo e njeenayo dartiiɓe ɓe kaajaaka tuubude. ");
INSERT INTO fuhbkf_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","—Katin du, si debbo ina jogii buuɗi cardi sappo, de ngootu lalli fu, wanaa o huɓɓan lampal, o fiisoo galle oon, o filoroo hakkillo faa o yiita ɗum naa? ");
INSERT INTO fuhbkf_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Nde o yiiti ɗum fu, o hawrunduran yigiraaɓe makko e hoddiiɓe makko, o wi'a: «Ceyodee e am, sabo mi yiitii mbuuɗu am lallunoongu.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Miɗo haalana on: hono noon maleyka'en Laamɗo ceyortoo, si luttuɗo gooto tuubii. ");
INSERT INTO fuhbkf_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Iisaa wi'i katin: —Gorko gomma ina woodunoo ɓiɓɓe worɓe ɗiɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Minyiiwo oon wi'i bammum: «Baaba, hokkam ngeɗu am e jawdi ndi.» Ndelle, baabiiko oon fecci jawdi muuɗum ndiin hakkunde maɓɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Faa waɗi balɗe seeɗa, minyiiwo oon hawrunduri ko jogii fuu, dilli, yehi leydi mboɗɗundi. Toon o bonniri ngeɗu makko nguun fuu e fijirde. ");
INSERT INTO fuhbkf_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Nde o hantunoo ndi fuu ndeen, rafo bonngo waɗi e leydi ndiin, o fuɗɗi tampude. ");
INSERT INTO fuhbkf_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","O yehi o takkowii e gorko jeyaaɗo e leydi ndiin. Oon nuli mo gese mum faa o duranowa ɗum girooji muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Imo muuyi nyaamude fay nyaamdu girooji ɗiin, ammaa fay gooto hokkataa mo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ndeen hakkillo makko warti, o wi'i e hoore makko: «Gollanooɓe baaba am nyaaman faa kedda, inani kam ɗo, miɗo maaya rafo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Mi ummoto, mi hoota to baaba am, mi wi'a ɗum: Baaba, mi toonyake jom kammuuli, mi toonyake ma aan du, ");
INSERT INTO fuhbkf_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","mi haandaa e fay wi'eede ɓiya katin. Ndelle, jogoram hono wo mi gooto e gollooɓe maa ɓeen!» ");
INSERT INTO fuhbkf_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Jonle o ummii, o fonndii to baabiiko. Gilla imo woni to woɗɗi, baabiiko oon haccii mo, yurmii mo sanne, doggi, gorfi mo, muccii mo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ɓiɗɗo oon wi'i mo: «Baaba, mi toonyake jom kammuuli, mi toonyake ma, mi haandaa e fay wi'eede ɓiya katin!» ");
INSERT INTO fuhbkf_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","De baabiiko oon wi'i maccuɓe muuɗum: «Karee, ngaddowee saaya ɓurka fuu woodde ɓornon mo! Ngatton hootonnde e honndu makko, ngatton paɗe e koyɗe makko. ");
INSERT INTO fuhbkf_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ngaddon ngaari payndi du, kirson ɗum faa nyaamen, mbeltoɗen! ");
INSERT INTO fuhbkf_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Sabo ɓiyam o, o maaynooɗo de o ummitii, o majjunooɗo de o yiitaa.» Nii ɓe puɗɗiri weltaare. ");
INSERT INTO fuhbkf_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Wakkati oon, ɓiɗɗo mawniiwo oon ina woni ley ngesa. Nde wartannoo faa ɓadii wuro ndeen, nani jimi fijo e dippaali. ");
INSERT INTO fuhbkf_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","O noddi gooto e gollooɓe ɓeen, o ƴami ɗum ko woni duko ko. ");
INSERT INTO fuhbkf_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Oon wi'i mo: «Minya oon warti de bammaa hirsani mo ngaari payndi, sabo o wartii, imo reenii.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ndeen mawniiwo oon tikki, salii naatude galle oon. Baabiiko oon wurtii, ina sura mo faa o naata. ");
INSERT INTO fuhbkf_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","O jaabii baabiiko, o wi'i: «Ndaar, duuɓi keewɗi miɗo gollane, fay nde wootere mi salaaki yamiroore maa. Ammaa ɗum e laataade fuu, abada a hokkaay kam miin kaa fay damngel faa mi weltodoo e yigiraaɓe am. ");
INSERT INTO fuhbkf_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","De ɓiya nyaamruɗo jawdi maa e rewɓe fijooɓe oon kaa, ko warti, a hirsanii ɗum ngaari payndi.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Baabiiko wi'i mo: «Ɓinngel am, abada enen ngondi, ko njeymi fuu, wo aan jeyi. ");
INSERT INTO fuhbkf_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ina haani ceyoɗen, mbeltoɗen. Sabo minya oon, o maaynooɗo de o ummitii, o majjunooɗo de o yiitaa.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Iisaa wi'i taalibaaɓe mum ɓeen katin: —Jom jawdi gomma halfiniino howruujo muuɗum jawdi. O haalanaa howruujo oon ina bonna jawdi makko. ");
INSERT INTO fuhbkf_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","O noddi ɗum, o wi'i: «Ko nanumi e maaɗa ɗuum wo ɗume? War, hiisa ko kalfinaɗaa ɗuum, sabo a waawaa halfineede katin.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Howruujo oon wi'i e hoore muuɗum: «Noy ngaɗammi? Sabo joomam ittan kam e golle. Mi walaa semmbe remude, miɗo semta ŋaaraade. ");
INSERT INTO fuhbkf_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ayyo! Miɗo anndi no ngaɗammi, faa yimɓe njaɓɓitoo kam e ley cuuɗi muɓɓen si mi ɓortaama golle.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Jonle o noddi ɓe joomiiko rewata nyamaale ɓeen, gooto gooto. O wi'i arandeejo oon: «Noy foti joomam rewete?» ");
INSERT INTO fuhbkf_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Oon wi'i mo: «Paali hemre nebbam ndeweteemi.» Howruujo oon wi'i mo: «Hooƴu talkuru maa nyamaale, hara, jooɗa mbinndaa capanɗe joy.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","O wi'i goɗɗo katin: «Aan le, noy foti ndeweteɗaa?» Oon wi'i mo: «Bootooji alkama hemre.» O wi'i oon: «Hooƴu talkuru maa nyamaale, mbinndaa bootooji capanɗe jeetati.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Jom howruujo oonyiiɗo oon mani ɗum saabe ƴoyre muuɗum. Sabo yimɓe adunaaru ɓeen ɓuri yimɓe annoora gollirde ƴoyre hakkunde muɓɓen. ");
INSERT INTO fuhbkf_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Miin, miɗo wi'a on: Pilanee ko'e mon yigiraaɓe, piloree ɓe jawdi adunaaru faa nde ndi hantii fu, njaɓɓiteɗon ley nguurndam nduumiiɗam. ");
INSERT INTO fuhbkf_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Koolniiɗo e ko famɗi, hoolnoto e ko mawni du. Mo laamnaay ko famɗi, laamnataa ko mawni du. ");
INSERT INTO fuhbkf_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ndelle, si on kollaay hoolaare e jawdi adunaaru ndi, moy halfinta on jawdi ngoongalaari ndiin? ");
INSERT INTO fuhbkf_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Katin du si on kollaay hoolaare e jawdi njananndi, moy hokkata on ko njeyɗon ɗuum? ");
INSERT INTO fuhbkf_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Maccuɗo fay gooto waawaa gollande joomiraaɓe ɗiɗo. Sabo wanyan gooto, de yiɗa keddiiɗo oon, maa du nanngunduran e gooto, de yawa keddiiɗo oon. On mbaawaa gollande Laamɗo e jawdi fuu nde wootere. ");
INSERT INTO fuhbkf_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Farisa'en, yiɗuɓe ceede ɓeen, ina kettindii ɗum fuu, ina njala mo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Iisaa wi'i ɓe: —Onon le, oɗon moƴƴina ko'e mooɗon yeeso yimɓe, ammaa Laamɗo ina anndi ɓerɗe mon. Sabo ko yimɓe teddinta ɗuum, ina nyiddinii to Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Tawreeta e annabaaɓe ina ngoodunoo faa warude wakkati Yaayaa. Gilla e Yaayaa Kabaaru Lobbo laamu Laamɗo ina ɓanginee. Mono fuu ina durwa naatude ley maggu. ");
INSERT INTO fuhbkf_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ammaa e noon fu, timmugol kammu e leydi ɓuri hoyude diina ittude toɓɓel gootel e ley Tawreeta oon. ");
INSERT INTO fuhbkf_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Neɗɗo fuu ceeruɗo deekum de ɓaŋi goɗɗo, jeenii. Katin du neɗɗo fuu ɓaŋuɗo debbo ceeraaɗo, jeenii. ");
INSERT INTO fuhbkf_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","—Ina woodunoo gorko gomma jom jawdi ɓornotooɗo kaddule boɗeeje ɗaatuɗe, buurduɗo nyannde fuu e weltaare e mbelirka. ");
INSERT INTO fuhbkf_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Talkaajo gomma keewɗo ɓuuye, bi'eteeɗo Laajaru, ina fukkoo dammbugal galle makko. ");
INSERT INTO fuhbkf_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Imo muuynoo nyaamude kedde jom jawdi oon. Fay dawaaɗi ina ngara ina metta ɓuuye makko ɗeen. ");
INSERT INTO fuhbkf_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Talkaajo oon maayi, maleyka'en njaari ɗum faa to Ibrahiima. Jom jawdi oon kam du maayi, uwaa. ");
INSERT INTO fuhbkf_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ley nokkuure maayɓe imo torroo, o ɓanti gite makko, o haccii Ibrahiima to woɗɗi, Laajaru ina woni ɗakkol muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","O ƴeewnii o wi'i: «Baaba am Ibrahiima, yurmam, nulu Laajaru, suuwa hoore honndu muuɗum ley ndiyam, de wara feewnana kam ɗemngal am. Sabo mi torrake sanne ley yiite nge.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ammaa Ibrahiima wi'i: «Ɓinngel am, miccita a heɓii kulle lobbe e ley nguurndam maaɗa, Laajaru kaa wo bone tan heɓi. Joonin, kanko o heɓii hinneede ɗo, de aan torroɗaa. ");
INSERT INTO fuhbkf_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ko ɓuri ɗum du fuu, luggere mawnde woni hakkunde amin e mooɗon. Ndelle si won yiɗuɓe ƴuurude to amin njaha to mooɗon, naa ƴuurude to mooɗon ngara to amin, tawan mbaawaa.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Jom jawdi oon wi'i: «Ndelle baaba, miɗo nyaage, nulu Laajaru suudu baaba am, ");
INSERT INTO fuhbkf_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","sabo miɗo woodi sakiraaɓe worɓe njoyo, faa o gongina ɓe taa ɓe ngara e nokku torra o.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ammaa Ibrahiima wi'i mo: «Iɓe njogii haala Muusaa e haalaaji annabaaɓe, accu ɓe kettindanoo ɗi.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","O jaabii ɗum: «Wanaa noon, baaba am Ibrahiima! De si goɗɗo ƴuurii hakkunde maayɓe yehi to maɓɓe fu, ɓe tuuban.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ibrahiima wi'i mo: «Si ɓe kettindanaaki Muusaa e annabaaɓe, fay si goɗɗo ummitii e maayɓe, ɓe ngoonɗintaa.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Iisaa wi'i taalibaaɓe muuɗum ɓeen: —Sikke walaa ko fergata yimɓe faa luttina ɗum'en waran, ammaa bone woodanii laatiiɗo sabaabu majjum. ");
INSERT INTO fuhbkf_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Hayre teddunde haɓɓee e daande joomum faɗɗee ley maayo manngo, ɗum ɓuri woodde diina luttinde gootel e cukaloy koy. ");
INSERT INTO fuhbkf_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Kaybee ko'e mooɗon: si sakiike maa luttii, pelaa ɗum. Si tuubii, njaafoɗaa ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Si o toonyake ma kile jeɗɗi e ley nyalooma gooto, de o warti to maa kile jeɗɗi imo tuubane, njaafoɗaa mo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Nulaaɓe ɓeen mbi'i Iisaa: —Ɓeydan min goonɗinal. ");
INSERT INTO fuhbkf_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Iisaa jaabii, wi'i: —Si goonɗinal mooɗon fotii fay no gabbel lekki mutaari ni, si on mbi'ii lekki kiiɗo ɗoofoo, darowoo ley maayo, ki jaɓanan on. ");
INSERT INTO fuhbkf_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Moy e mooɗon maccuɗo muuɗum demoowo naa duroowo ƴuurata ladde, warta, de wi'a ɗum: «Hara jooɗa, nyaamu»? ");
INSERT INTO fuhbkf_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Walaa! A wi'an mo: «Waɗanam nyaamdu, haɓɓa kaddule maa de ngollanaa kam faa mi nyaama mi yara, de sakitoo aan du nyaamaa njaraa.» Wanaa noon worri naa? ");
INSERT INTO fuhbkf_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Yalla a yettan maccuɗo oon saabe waɗii ko njamirɗaa ɗuum naa? ");
INSERT INTO fuhbkf_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Onon du hono noon. Si on ngaɗii huunde fuu ko njamiraɗon, mbi'ee: «Min maccuɓe tan, ko min njeyi waɗude ni min ngaɗi.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Nde Iisaa yahannoo Urusaliima ndeen, rewi hakkunde leyɗe Samariya e Galili. ");
INSERT INTO fuhbkf_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","O wari faa o naata wuro wonngo, de seppinɓe sappo ngari to makko, ndarii to toowti, ");
INSERT INTO fuhbkf_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ƴeewnii, mbi'i: —Iisaa, joomii amin, yurma min! ");
INSERT INTO fuhbkf_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Nde o yiinoo ɓe ndeen, o wi'i ɓe: —Njehee, kollowee ko'e mon almaami'en ɓeen. E ley yaadu maɓɓe nduun ɓe cellinaama. ");
INSERT INTO fuhbkf_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Gooto maɓɓe, nde yi'unoo daɗii ndeen, yeccii, ina teddina Laamɗo e daande toownde. ");
INSERT INTO fuhbkf_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","O sujidi e leydi ɗakkol koyɗe Iisaa, imo yetta ɗum. Oon wo Samariyanke. ");
INSERT INTO fuhbkf_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Iisaa jaabii, wi'i: —Wanaa sappo ɓeen fuu ndaɗii naa? Toy njeenayo ɓeen le ngoni? ");
INSERT INTO fuhbkf_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ndelle walaa fuu jecciiɗo faa teddina Laamɗo si wanaa janano o naa? ");
INSERT INTO fuhbkf_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ndeen, o wi'i gorko oon: —Umma, yahu, goonɗinal maa dannii ma. ");
INSERT INTO fuhbkf_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Farisa'en ɓeen ƴami Iisaa ndey laamu Laamɗo warata. O jaabii ɓe, o wi'i: —No laamu Laamɗo wardata noon, yi'ataake. ");
INSERT INTO fuhbkf_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Fay gooto waawaa wiide inani ɗum naa inana ɗum, sabo anndee, laamu Laamɗo ina woni hakkunde mooɗon. ");
INSERT INTO fuhbkf_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ndeen o wi'i taalibaaɓe makko: —Wakkati waran mo muuyoton yiide fay nyannde wootere e ley nyalaaɗe Ɓii Neɗɗo, de on nji'ataa. ");
INSERT INTO fuhbkf_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","On mbi'ete: «inani o to» naa «inani o ga», de taa njehee, taa njokkee ɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Sabo hono no maƴƴere yaynirta illa hoore kammu ɗo faa yaade hoore kammu to, hono noon Ɓii Neɗɗo laatortoo nyannde gartol muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ammaa ko artii ɗum, ina tilsi o torree torraaji keewɗi, yimɓe jamaanu o du caloto mo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Hono no laatorinoo wakkati Nuuhu oon, noon du nyalaaɗe Ɓii Neɗɗo laatortoo: ");
INSERT INTO fuhbkf_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","yimɓe ina nyaama, ina njara, ina ɓaŋa, ina ɓaŋee, faa nyannde Nuuhu naati laana kaan. De ilam tuufaandu ɗaam wari, halki ɓe fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Laatoto hono no wakkati Luudu noon du, yimɓe ina nyaama, ina njara, ina cooda, ina conna, ina aawa, ina nyiɓa. ");
INSERT INTO fuhbkf_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ammaa nyannde nde Luudu wurtinoo Sodoma ndeen, Laamɗo tomni yiite e sitti, halki ɓe fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Hono noon nyannde ɓangugol Ɓii Neɗɗo du laatortoo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Nyannde ndeen, si neɗɗo ina woni dow suudu, de gineeji mum ina ngoni ley suudu fu, taa wi'a jippanto ɗi. Tawaaɗo ngesa du, taa yeccoo faa hooƴa ko woni ley wuro. ");
INSERT INTO fuhbkf_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Miccitee dee Luudu oon. ");
INSERT INTO fuhbkf_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Neɗɗo fuu piliiɗo reenude yonki muuɗum, mursan ki, de neɗɗo fuu mursuɗo ki, reenan ki. ");
INSERT INTO fuhbkf_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Miɗo haalana on: ley jemma oon, yimɓe ɗiɗo fukkodiiɓe dow sekko wooto, gooto muɓɓen hooƴete, de gooto yoppee. ");
INSERT INTO fuhbkf_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Rewɓe ɗiɗo undooɓe, gooto muɓɓen hooƴete, de gooto yoppee.  ");
INSERT INTO fuhbkf_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Worɓe ɗiɗo wonɓe ley ngesa ngoota, gooto muɓɓen hooƴete, de gooto yoppee. ");
INSERT INTO fuhbkf_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Taalibaaɓe ɓeen njaabii, mbi'i mo: —Joomii amin, toy ɗum waɗata? O wi'i ɓe: —To ko saaɗi woni fuu, toon jigaaje kawritata. ");
INSERT INTO fuhbkf_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Iisaa banndani ɓe banndol faa hollita ɓe ina tilsi ɓe keddodoo e du'aare, taa ɓe njoppa saabe tampiri. ");
INSERT INTO fuhbkf_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","O wi'i: —Ina woodunoo e wuro gomma carotooɗo mo hulataa Laamɗo, yaagataako fay gooto. ");
INSERT INTO fuhbkf_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Debbo mo gorum maayi ina woni ley wuro ngoon, ina wara to carotooɗo oon, ina wi'a: «Saranam hakkunde am e kabdo am.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Carotooɗo oon jaɓaay faa ɓooyi. De sakitii o wi'i e hoore makko: «Fay si taweede mi hulataa Laamɗo mi yaagataako fay gooto du, ");
INSERT INTO fuhbkf_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","sabo debbo o na torra kam, mi saranto mo, faa o sela warude imo sukka noppi am.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Caggal ɗuum Iisaa wi'i: —On nanii ko carotooɗo bonɗo oon wi'i naa? ");
INSERT INTO fuhbkf_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","De wanaa Laamɗo na walla suɓaaɓe muuɗum wullitotooɓe ɗum jemma e nyalooma ɓeen fuu faa ɓe keɓa sariya maɓɓe naa? O jaabataako ɓe law naa? ");
INSERT INTO fuhbkf_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Miɗo haalana on: o saranto ɓe law. Ammaa wakkati Ɓii Neɗɗo wartowi, yalla o tawan goonɗinɓe mo ley adunaaru naa? ");
INSERT INTO fuhbkf_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Iisaa banndani yimɓe jogoriiɓe ko'e muɓɓen wo dartiiɓe de njawi woɓɓe, haalani ɓe banndol ngol, wi'i: ");
INSERT INTO fuhbkf_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Worɓe ɗiɗo naati suudu dewal mawndu faa ngaɗa du'aare. Gooto wo Farisaajo, gooto du wo nanngoowo lampo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farisaajo oon darii ina du'oroo ley ɓernde muuɗum hono ni: «Laamɗo, mi yettii ma ko mi nanndaay e yimɓe woɓɓe laatiiɓe wuyɓe e bonɓe e jeenooɓe, e hono nanngoowo lampo o du. ");
INSERT INTO fuhbkf_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Miɗo suumoo e ley jeɗɗiire fuu kile ɗiɗi, miɗo itta jakka e huunde fuu ko keɓumi.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Nanngoowo lampo oon darii to toowti, suusaay fay tiggitaade kammu, ina guɓɓoo ɓerndem, na wi'a: «Laamɗo yurmam, mi jom hakke.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Miɗo wi'a on: kanko hooti wo o jaafaaɗo, wanaa ooto. Sabo mawninkiniiɗo fuu leeƴinte, leeƴinkiniiɗo du toownete. ");
INSERT INTO fuhbkf_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ina woodi waddooɓe to Iisaa cukaloy, faa o meema koy. Nde taalibaaɓe ɓeen nji'unoo ɗum ndeen, ina ndukana yimɓe ɓeen. ");
INSERT INTO fuhbkf_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ammaa Iisaa noddi koy, ina wi'a: —Accee cukaloy koy ngara to am. Taa kaɗee koy, sabo wo nannduɓe e makkoy ɓeen njeyi laamu Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Goonga kaalanammi on: mo jaɓiraay laamu Laamɗo hono no cukalel ni fuu, naatataa ɗum! ");
INSERT INTO fuhbkf_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Gooto ley hooreeɓe Alhuudiyankooɓe ƴami mo, wi'i: —Moodibbo lobbo, ɗume kaanumi waɗude faa mi heɓa nguurndam nduumiiɗam? ");
INSERT INTO fuhbkf_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Iisaa wi'i mo: —Ko waɗi de aɗa noddira kam lobbo? Lobbo walaa si wanaa gooto, oon woni Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Aɗa anndi jamirooje: «Taa jeenu, taa waɗu war-hoore, taa wujju, taa seeda fewre, teddin inna maa e bammaa.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Hooreejo oon jaabii, wi'i: —Miɗo hayba ɗum fuu gilla e cukaaku am. ");
INSERT INTO fuhbkf_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Nde Iisaa nannoo ɗum ndeen, wi'i mo: —Huunde wootere heddanii ma tafon: sonnu ko njogiɗaa ɗuum fuu, kokkaa ceede ɗeen talkaaɓe. Ndeen, a heɓan mbarjaari dow kammu. De ngaraa, njokkaa kam. ");
INSERT INTO fuhbkf_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Nde o nannoo ɗum ndeen, o sunii, sabo wo o jom jawdi keewndi. ");
INSERT INTO fuhbkf_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Iisaa ndaari mo, wi'i: —Naatugol joomiraaɓe jawdi ley laamu Laamɗo ina tiiɗi koy! ");
INSERT INTO fuhbkf_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Si goonga, ngeelooba naata wudde battal ɓuri hoyude diina jom jawdi naata laamu Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Hettindaniiɓe mo ɓeen mbi'i: —Ndelle, moy woni kisoowo? ");
INSERT INTO fuhbkf_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Iisaa jaabii: —Ko yimɓe mbaawaa ɗuum, Laamɗo kaa na waawi. ");
INSERT INTO fuhbkf_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ndeen Piyeer wi'i: —Ndaar, minen min njoppii ko min njogii ɗuum fuu, min njokkii ma. ");
INSERT INTO fuhbkf_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","O wi'i ɓe: —Goonga kaalanammi on: joppuɗo wuro muuɗum, naa deekum, naa sakiraaɓe muuɗum, naa saaraaɓe mum, naa sukaaɓe mum saabe laamu Laamɗo, ");
INSERT INTO fuhbkf_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","heɓan ɗum kile keewɗe e wakkati mo ngonɗen e muuɗum joonin o, heɓan nguurndam nduumiiɗam e ley wakkati garoowo oon du. ");
INSERT INTO fuhbkf_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Iisaa noddi taalibaaɓe muuɗum sappo e ɗiɗo ɓeen, wi'i ɗum'en: —Inani eɗen njaha Urusaliima. Ko annabaaɓe mbinndunoo e dow Ɓii Neɗɗo ɗuum fuu, tabitan. ");
INSERT INTO fuhbkf_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Sabo o wattete e juuɗe ɓe nganaa Alhuudiyankooɓe, ɓe njalnoroo mo, ɓe torra mo, ɓe tutta dow makko, ");
INSERT INTO fuhbkf_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ɓe piya mo dorri, ɓe mbara mo. De nyannde tataɓerde, o ummitoto. ");
INSERT INTO fuhbkf_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Taalibaaɓe ɓeen paamaay haala kaan fes. Maanaa makka na suuɗanii ɓe, ɓe annditaay ko o haali ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Nde Iisaa ɓattinoo Yeriko ndeen, tawi bumɗo ina jooɗii ɗakkol laawol ngool, ina garbina. ");
INSERT INTO fuhbkf_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","O maati jamaa ina faltoo, de o ƴami ɗum wo ɗume. ");
INSERT INTO fuhbkf_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ɓe mbi'i mo: —Iisaa mo Nasaraatu faltotoo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","O ƴeewnii, o wi'i: —Iisaa, taan Daawda, yurmam! ");
INSERT INTO fuhbkf_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ardiiɓe ɓeen ina njawana mo faa o deƴƴinoo. Ammaa o ɓeydi ƴeewnaade sanne, imo wi'a: —Taan Daawda, yurmam! ");
INSERT INTO fuhbkf_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Iisaa darii yamiri ɓe ngadda mo to muuɗum. Nde o ɓattinoo ndeen, Iisaa ƴami mo: ");
INSERT INTO fuhbkf_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—Ɗume njiɗɗaa mi waɗane? O wi'i: —Joomam, mi wumta! ");
INSERT INTO fuhbkf_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Iisaa wi'i mo: —Wumtu, goonɗinal maa dannii ma. ");
INSERT INTO fuhbkf_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Wakkati gooto o wumti, o jokki ɗum, imo teddina Laamɗo. Nde yimɓe ɓeen nji'unoo ɗum ndeen, njetti Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Iisaa naati Yeriko, ina rewi ley wuro ngoon. ");
INSERT INTO fuhbkf_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Gorko bi'eteeɗo Jakayus ina woni ley toon. O hooreejo nanngooɓe lampo, wo o jom jawdi du. ");
INSERT INTO fuhbkf_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Imo filoo yiide moy woni Iisaa, de o hunngii saabe jamaa oon, sabo wo o daɓɓo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","O doggi, o arditii, o ƴeeŋi lekki hono ƴibbi ɗo Iisaa rewata ɗoon faa o yi'a ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Nde Iisaa yottinoo nokkuure ndeen, tiggitii, wi'i mo: —Jakayus, hara jippa, sabo ina tilsi mi weera wuro maa hannden. ");
INSERT INTO fuhbkf_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Jakayus harii jippii, jakkitorii mo seyo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Yiiɓe ɗum ɓeen fuu ina ŋurŋurta, ina mbi'a: —O weeranowii luttoowo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","De Jakayus darii, wi'i Iisaa: —Joomam, hettina, mi hokkan feccere jawdi am fuu talkaaɓe. Si won mo teetumi huunde, mi yoɓan ɗum kile nay. ");
INSERT INTO fuhbkf_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Iisaa wi'i: —Hannden, kisindam naatii galle o, sabo kanko du wo o taan Ibrahiima! ");
INSERT INTO fuhbkf_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Sabo Ɓii Neɗɗo warii filaade majjuɓe faa hisina ɗum'en. ");
INSERT INTO fuhbkf_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ko yimɓe ɓeen kettindii ɗuum, Iisaa ɓeydi haala, banndani ɓe banndol gonngol, sabo o ɓattake Urusaliima. Katin du yimɓe miilii laamu Laamɗo ɓangan joonin joonin. ");
INSERT INTO fuhbkf_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ndelle, o wi'i: —Gorko dimo tedduɗo yehi leydi mboɗɗundi faa hokkee laamu, de gaɗa ɗuum warta. ");
INSERT INTO fuhbkf_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","O noddi maccuɓe makko sappo, o hokki mono e maɓɓe fuu mbuuɗu kaŋŋe, o wi'i ɗum'en: «Ngolliree ɗum faa mi warta.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ammaa yimɓe leydi ndiin njiɗaa mo, ɓe ummini nulaaɓe gaɗa makko, ɓe mbi'i: «Min njiɗaa o laamoo min.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Nde o hokkanoo laamu, o warti ndeen, o yamiri o noddanee maccuɓe ɓe o halfini jawdi ɓeen. Imo yiɗi faamude ko mono e maɓɓe fuu heɓi e ko golliri ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Arandeejo oon wari, wi'i: «Joomam, mbuuɗu maa nguun tinake buuɗi sappo.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","O wi'i ɗum: «Gasii sanne, maccuɗo lobbo. Sabo a hoolnake e ko famɗi, a laamoto dow galluuje sappo.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ɗiɗaɓo oon wari, wi'i: «Joomam, mbuuɗu maa tinake buuɗi joy.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","O wi'i: «Aan du, a laamoto dow galluuje joy.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Caggal ɗuum keddiiɗo oon wari, wi'i: «Joomam, inan mbuuɗu maa, mi saawii ɗum e tekkere ");
INSERT INTO fuhbkf_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","sabo miɗo hule. Sabo a gorko tiiɗuɗo alhaali, aɗa hooƴa ko a resaay, aɗa taƴa ko a aawaay.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","O wi'i ɗum: «Dara! Haalaaji maa jaati carortomaami, aan maccuɗo bonɗo. Aɗa anndunoo mi gorko tiiɗuɗo alhaali, mi hooƴan ko mi resaay, mi taƴan ko mi aawaay. ");
INSERT INTO fuhbkf_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ndelle ko waɗi a wattaay jawdi am ndi to tinooɓe buuɗi, faa nde ngartumi fu mi jaɓida ndi e tino mayri fuu?» ");
INSERT INTO fuhbkf_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ndeen joomiiko oon wi'i tawaaɓe ɗoon ɓeen: «Teetee mo mbuuɗu ngu, de kokkon ɗum jom buuɗi sappo oon.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ɓe mbi'i mo: «Joomii amin, kanko, imo jogii buuɗi sappo.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","O wi'i: «Miɗo haalana on, jogiiɗo fuu ɓeydante. Ammaa mo walaa oon, fay seeɗa ko jogii ɗuum, teetete. ");
INSERT INTO fuhbkf_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","De wayɓe kam ɓe njiɗaa mi laamoo ɗum'en ɓeen, ngaddee ɓe ɗo, mbaron ɓe yeeso am.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Nde Iisaa haalnoo ɗum ndeen, ardii, fonndii Urusaliima. ");
INSERT INTO fuhbkf_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Nde o ɓattinoo gure Baytifaaji e Baytaniya gonɗe dow waamnde wi'eteende Jaytun, o nuli taalibaaɓe makko ɗiɗo, ");
INSERT INTO fuhbkf_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","o wi'i ɓe: —Njehee, naatowee wuro wonngo yeeso mon ngo, on tawan mola araawa nga fay gooto waɗɗaaki abada ina haɓɓii. Kaɓɓiton nga, ngaddon nga ɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Si goɗɗo ƴamii on, «Ko waɗi oɗon kaɓɓita nga?», mbi'on: «Joomii amin ina haajaa nga.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Nulaaɓe ɓeen njehi, tawri no o wi'iri ɗum'en noon. ");
INSERT INTO fuhbkf_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","E ley haɓɓitingol maɓɓe mola nga, jeyɓe mola nga ɓeen mbi'i: —Ɗume kaɓɓitanton mola nga? ");
INSERT INTO fuhbkf_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ɓe njaabii, ɓe mbi'i: —Joomii amin haajaa nga. ");
INSERT INTO fuhbkf_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ɓe njaari nga to Iisaa, ɓe njowi saayaaji maɓɓe dow mola nga, ɓe mbaɗɗini Iisaa dow magga. ");
INSERT INTO fuhbkf_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","No o yaarata noon, ɓe mbeerti saayaaji maɓɓe dow laawol ngool. ");
INSERT INTO fuhbkf_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Joonin o ɓadake Urusaliima to jippitorde waamnde Jaytun. Taalibaaɓe heewɓe ɓeen fuu ina keewi seyo, puɗɗi ina njetta Laamɗo e daaɗe toowɗe, saabe kaayeefiiji ɗi ɓe nji'unoo ɗiin fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Iɓe mbi'a: —Barke woodanii kaananke garɗo e dow innde Joomiraaɗo! Jam won dow kammu. Manngu woodanii Laamɗo faa dow kammuuli! ");
INSERT INTO fuhbkf_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Yoga e Farisa'en tawaaɓe ley jamaa oon ɓeen mbi'i mo: —Moodibbo, haɗu taalibaaɓe maa ɓeen dukude! ");
INSERT INTO fuhbkf_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","O jaabii ɓe, o wi'i: —Miɗo haalana on, si kamɓe ɓe, ɓe ndeƴƴinake fu, wo kaaƴe ɗe ƴeewnotoo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Iisaa ɓattii ngalluure ndeen. Nde o ndaarunoo nde fu, o woyi nde, ");
INSERT INTO fuhbkf_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","o wi'i: —Miɗo muuyi tawee hannden aɗa anndunoo aan du ko hokkete jam! De joonin kaa, ɗum suuɗaama e gite maa. ");
INSERT INTO fuhbkf_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Balɗe ngaran ɗe wayɓe ma ƴolata leydi ngaɗa ƴeeŋirɗe, piile, ɓille gereeji fuu, ");
INSERT INTO fuhbkf_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","niise, kalke aan e ɓiɓɓe maa fuu. Ɓe njoppantaa ma fay hayre wootere dow wonnde, sabo a annditaay wakkati mo Laamɗo wari wallude ma. ");
INSERT INTO fuhbkf_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Iisaa naati ley suudu dewal mawndu nduun, fuɗɗi riiwude luumotooɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Imo wi'a ɗum'en: —Ina winndaa: «Suudu am laatoto waɗirdu du'aare». Onon kaa, on ngaɗii ndu suuɗirdu yanooɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Iisaa ina waajoo nyannde fuu ley suudu dewal mawndu nduun. Hooreeɓe almaami'en e jannginooɓe Tawreeta e mawɓe lenyol ngool ɓeen ina piloo no mbardata mo, ");
INSERT INTO fuhbkf_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","ammaa ɓe kunngake heɓude laawol sabo yimɓe ɓeen ina ngattani haalaaji makko ɗiin hakkillo sanne. ");
INSERT INTO fuhbkf_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","E ley balɗe ɗeen nyannde gomma Iisaa ina janngina yimɓe ina waajoo Kabaaru Lobbo ley suudu dewal mawndu. Hooreeɓe almaami'en e jannginooɓe Tawreeta e mawɓe yimɓe ngari to makko, ");
INSERT INTO fuhbkf_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","mbi'i mo: —Haalan min: Laamu nguye hokki ma baawɗe gollude ko ngollataa ɗum? Moy hokki ma laawol ngollaa ɗum? ");
INSERT INTO fuhbkf_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Iisaa jaabii ɓe, wi'i: —Miin du huunde wootere tan ƴamammi on. Njaaboɗon kam ɗum: ");
INSERT INTO fuhbkf_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","lootagal batisima Yaayaa ngaal, wo to Laamɗo ƴuuri naa to yimɓe? ");
INSERT INTO fuhbkf_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ɓe paamiri hakkunde maɓɓe, ɓe mbi'i: —Si en mbi'ii wo to Laamɗo, o ƴaman en ko waɗi de en ngoonɗinaay Yaayaa? ");
INSERT INTO fuhbkf_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","De si en mbi'ii wo to yimɓe, yimɓe ɓe fuu limnan en kaaƴe, sabo ɓe fuu ɓe tannyorii Yaayaa wo annabaajo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Nii ɓe njaaborii ɓe mbi'i ɓe paamaay to lootagal batisima Yaayaa ƴuuri. ");
INSERT INTO fuhbkf_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Iisaa wi'i ɓe: —Haya miin du, mi haalantaa on baawɗe ɗeye ngollirammi ko ngollammi ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Iisaa fuɗɗi banndande yimɓe banndol ngol, wi'i: —Neɗɗo gomma darni ngesa cabiije, halfini nga remooɓe, de waɗi jahaangal, ɓooyi wartaay. ");
INSERT INTO fuhbkf_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Nde ɓoreede cabiije yottinoo fu, o nuli golloowo makko to remooɓe ɓeen toon faa jaɓa ngeɗu makko ɓiɓɓe cabiije ɗeen. Ndeen remooɓe ɓeen piyi nulaaɗo oon, njeccini ɗum juuɗe ɓole. ");
INSERT INTO fuhbkf_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","O nuli to maɓɓe golloowo goɗɗo. Ɓe piyi oon du, ɓe kuyfini ɗum, ɓe njeccini ɗum juuɗe ɓole. ");
INSERT INTO fuhbkf_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","O nuli katin golloowo tataɓo. Ɓe mbarmini ɗum, ɓe ndiiwi ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Wakkati oon, jom ngesa oon wi'i: «Noy ngaɗammi? Mi nelan ɓiyam gorko mo korsinmi, hasii ɓe njaagoto mo!» ");
INSERT INTO fuhbkf_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ammaa nde remooɓe ɓeen nji'unoo ɓiɗɗo oon ndeen, iɓe mbi'undura: «O woni donoowo oon. En mbara ɗum, kewten ngesa nga!» ");
INSERT INTO fuhbkf_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ɓe paɗɗi mo faa gaɗa ngesa toon, ɓe mbari mo. Joonin le, noy jom ngesa oon waɗata ɓe? ");
INSERT INTO fuhbkf_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","O waran, o halka remooɓe ɓeen, o halfina ngesa ngaan woɓɓe. Nde yimɓe ɓeen nannoo ɗum ndeen, mbi'i: —Taa ɗum laatoo! ");
INSERT INTO fuhbkf_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Iisaa ndaari ɓe, wi'i: —Ndelle, ɗume woni maanaa ko winndaa ɗuum: «Hayre nde nyiɓooɓe ɓeen calii ndeen, wo kayre laatii hoore nyimngo ngoon»? ");
INSERT INTO fuhbkf_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Caamuɗo dow hayre ndeen fuu, helan. Mo nde saami dow muuɗum du, ɗiggan. ");
INSERT INTO fuhbkf_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Jannginooɓe Tawreeta e hooreeɓe almaami'en paamii banndol ngol wo kam'en sappii. Ɓe pilii no ɓe nanngira Iisaa wakkati oon, ammaa ɓe kulii yimɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ɓe taykii Iisaa. Ɓe nuli horooɓe nanndinkiniiɓe e lobbuɓe, yalla ina keɓira laawol no nanngirta mo e haala makko, faa ngatta mo ley juuɗe laamu, saroo mo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ɓeen ƴami mo: —Moodibbo, miɗen anndi ko kaalataa ɗuum e ko mbaajotoɗaa ɗuum ina fonnditii, miɗen anndi a ɓurdintaa fay gooto, aɗa jannginira laawol Laamɗo ngol goonga. ");
INSERT INTO fuhbkf_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Yalla ina daganii min min kokka kaananke Roma mawɗo oon lampo naa dagaaki? ");
INSERT INTO fuhbkf_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ammaa o annditii hiila maɓɓe ka, o wi'i ɓe: ");
INSERT INTO fuhbkf_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—Kollee kam mbuuɗu cardi! Natal moy e innde moy woni ɗo? Ɓe mbi'i: —Kaananke Roma! ");
INSERT INTO fuhbkf_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ndeen o wi'i ɓe: —Ndelle kokkee kaananke Roma oon ko jeyi, kokkon Laamɗo du ko jeyi. ");
INSERT INTO fuhbkf_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ɓe kunngii nanngirde mo e ko o haalata yeeso yimɓe ɗuum. Jaabu makko oon haaynii ɓe, ɓe ndeƴƴinii. ");
INSERT INTO fuhbkf_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Woɓɓe e Saduki'en ngari to makko. Ɓeen ngoni yeddooɓe ummital. Ɓe ƴami mo, ɓe mbi'i: ");
INSERT INTO fuhbkf_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Moodibbo, Muusaa yamirii en, si neɗɗo ɓaŋii debbo, maayii, heɓaay ɓiɗɗo, minyum naa mawnum dewla debbo joppaaɗo oon faa heɓana maayɗo oon ɓeyngu. ");
INSERT INTO fuhbkf_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ina woodunoo rimdaaɓe njeɗɗo. Arandeejo oon ɓaŋi debbo, maayi, heɓaay ɓiɗɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ɗiɗaɓo oon dewli debbo oon, maayi, ");
INSERT INTO fuhbkf_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","tataɓo oon jokkiti. Hono noon njeɗɗo ɓeen fuu ɓaŋiri mo, keɓaay ɓiɗɗo, maayi. ");
INSERT INTO fuhbkf_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","De sakitii, debbo oon du maayi. ");
INSERT INTO fuhbkf_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ndelle, nyannde ummital, moy e maɓɓe laatotoo goroo debbo oon? Sabo ɓe njeɗɗo fuu ɓe ɓaŋiino mo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Iisaa jaabii ɓe, wi'i: —Yimɓe jamaanu o ina ɓaŋa, ina ɓaŋee. ");
INSERT INTO fuhbkf_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ammaa fotuɓe heɓude ummitagol e nguurndam garoojam ɓeen, ɓaŋataa, ɓaŋataake, ");
INSERT INTO fuhbkf_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","sabo ɓe mbaawaa maayde katin. Ɓe laatake hono maleyka'en noon. Wo ɓe ɓiɓɓe Laamɗo, sabo ɓe ummintinaaɓe e maayde. ");
INSERT INTO fuhbkf_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Wooɗi ko maayɓe ummitotoo ɗuum, fay Muusaa sappake ɗum ley taariki wuumoore huɓɓoore. Sabo toon o noddiri Joomiraaɗo Laamɗo Ibrahiima e Isiyaaka e Yaakuuba. ");
INSERT INTO fuhbkf_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Laamɗo wanaa Laamɗo maayɓe, wo o Laamɗo wuurɓe. Sabo to makko yimɓe fuu wo wuurɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Woɓɓe e jannginooɓe Tawreeta, mbi'i: —Moodibbo, a haalii goonga. ");
INSERT INTO fuhbkf_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Caggal ɗuum ɓe cuusaay ƴamude mo ƴamɗe goɗɗe katin. ");
INSERT INTO fuhbkf_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Iisaa wi'i ɓe: —Noy ɓe mbaawri wiide Almasiihu wo taan Daawda? ");
INSERT INTO fuhbkf_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Daawda e hoore muuɗum wi'i ley dewtere Jabuura: «Joomiraaɗo wi'i Joomam: Jooɗa gere nyaamo am, ");
INSERT INTO fuhbkf_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","faa mi waɗa njaaɓaa wayɓe ma.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Daawda ina noddira mo «Joomam». Ndelle, noy o laatortoo taanum? ");
INSERT INTO fuhbkf_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","E ley ko yimɓe ɓeen fuu kettindanii mo, o wi'i taalibaaɓe makko ɓeen: ");
INSERT INTO fuhbkf_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Ndeentee e jannginooɓe Tawreeta yiɗuɓe yiilodaade e saayaaji mawɗi e jowteede jowtaali tedduɗi ley luumooji, fooɗantooɓe jooɗorɗe ɓurɗe teddude ley cuuɗi baajorɗi e nokkuuje tedduɗe to nyaamduuji. ");
INSERT INTO fuhbkf_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Iɓe nyaama jawdi rewɓe talkaaɓe ɓe goriraaɓe muɓɓen maayi, de ɓe njuutina du'aawuuji maɓɓe faa ɓe nanndinkinoo e lobbuɓe. Kamɓe, jukkungo naawngo ɓurata jippineede dow muɓɓen. ");
INSERT INTO fuhbkf_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Iisaa ƴepti gite muuɗum, yi'i joomiraaɓe jawdi ina ngatta sadakaaji muɓɓen e keesu sadaka. ");
INSERT INTO fuhbkf_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","O yi'i debbo talkaajo mo gorum maayi, kam du ina watta toon buuɗi ɗiɗi, ");
INSERT INTO fuhbkf_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","de o wi'i: —Goonga kaalanammi on: debbo talkaajo o, ko watti ɗuum, ɓuri ko ɓe fuu ɓe ngatti. ");
INSERT INTO fuhbkf_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Sabo ɓe fuu, wo ko bonnantaa ɓe fay huunde tan ɓe ngattiri hono dokke. Ammaa debbo o kaa, e ley talkaaku muuɗum, watti haddi ko joginoo faa wuurda ɗuum fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ina woodi woɓɓe ina kaala haala suudu dewal mawndu nduun, e no ndu ŋarɗiniraa kaaƴe e kulle cakkaaɗe. Ndeen Iisaa wi'i: ");
INSERT INTO fuhbkf_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Ko nji'oton ɗuum, wakkati waran nde fay hayre wootere heddataako ɗo ina yowii dow wonnde. Fuu wurjinte. ");
INSERT INTO fuhbkf_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ɓe ƴami mo, ɓe mbi'i: —Moodibbo, anndin min nde ɗum waɗata. Maande ndeye hollata kulle ɗeen ɓadake waɗude? ");
INSERT INTO fuhbkf_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","O wi'i: —Ndeentee taa mbosineɗon e goonga. Heewɓe ngardan e innde am, ina mbiitoo: «Miin woni kanko», ina mbi'a du: «Wakkati oon ɓadake.» Taa njokkee ɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Nde nanoyɗon woldeeji e muurtereeji, taa kulee. Sabo tilay ɗum waɗa tafon, ammaa ɗum wanaa timmoode wakkati oon. ");
INSERT INTO fuhbkf_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","O heddii imo wi'a ɓe: —Lenyol habdan e lenyol, laamu habdan e laamu. ");
INSERT INTO fuhbkf_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Dimmbanɗe leydi mawɗe ngaɗan, rafooji e nyawuuji bonɗi du ngaran e nokkuuje feere feere. Kulle kulɓiniiɗe e sifaaji mawɗi ƴuuran dow kammu. ");
INSERT INTO fuhbkf_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ammaa gilla ɗum fuu waɗaay, yimɓe nanngan on, torreɗon, njaareɗon to cuuɗi baajorɗi e kasuuji. Ɓe ngadda on yeeso kaanankooɓe e hooreeɓe saabe innde am. ");
INSERT INTO fuhbkf_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ɗum hokkan on laawol seedanaade kam. ");
INSERT INTO fuhbkf_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Piɓee anniya e ɓerɗe mon on miilataako ko njaabotoɗon. ");
INSERT INTO fuhbkf_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Sabo mi hokkan on waawde haala, mi hokkan on hakkilantaaku ko wayɓe on ɓeen fuu mbaawaa salaade naa yeddude. ");
INSERT INTO fuhbkf_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Fay saaraaɓe mon e sakiraaɓe mon e koreeji mon e yigiraaɓe mon njammboto on, mbara woɓɓe mooɗon. ");
INSERT INTO fuhbkf_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Yimɓe fuu mbanyan on saabe am, ");
INSERT INTO fuhbkf_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","ammaa fay leembol ko'e mooɗon halkataa. ");
INSERT INTO fuhbkf_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Tinnitaare mooɗon ndannirton yonkiiji mon. ");
INSERT INTO fuhbkf_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","—Nde nji'uɗon konuuji ina piiloo Urusaliima fuu, anndon halkeede mayre ɓadake. ");
INSERT INTO fuhbkf_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Wakkati oon, tawaaɓe leydi Yahuudiya fuu, ndoggira baamle. Tawaaɓe ley ngalluure nde fuu, njalta e mayre. Tawaaɓe ladde du, taa naata ngalluure ndeen. ");
INSERT INTO fuhbkf_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Sabo balɗe ɗeen wo balɗe yomnitagol, faa ko winndaa ɗuum fuu tabita. ");
INSERT INTO fuhbkf_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Kay, debereedu'en e musinteeɓe njaran torra ley balɗe ɗeen! Sabo torraaji mawɗi njanan e leydi ndi, tikkere Laamɗo jippoto e lenyol ngol. ");
INSERT INTO fuhbkf_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ɓe camminirte kaafaahi, ɓe nanngee, ɓe njaaree hakkunde lenyi fuu. Lenyi ndampan Urusaliima faa nde wakkati dawrugol muɓɓen timmiri no fodoraa. ");
INSERT INTO fuhbkf_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Sifaaji ngaɗan dow naange e lewru e koode. Ley adunaaru du kulol waɗan e leyɗe ɗeen. Ɗe fuu ɗe mbemmboto saabe feekaango maayo manngo e bempeƴƴe muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Yimɓe pekkoran saabe kulol si miilake dow ko waroyta e adunaaru ndu, sabo fay baawɗe kammu ɗeen ndimmboto. ");
INSERT INTO fuhbkf_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Wakkati oon, yimɓe ɓeen nji'an Ɓii Neɗɗo ina wara e duule, ina warda e baawɗe e teddeengal manngal. ");
INSERT INTO fuhbkf_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Onon, si ɗum fuɗɗii waɗude, tiggitoɗon, ɓanton ko'e mooɗon, sabo Laamɗo ɓadake rimɗinde on. ");
INSERT INTO fuhbkf_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Caggal ɗuum, o banndani ɓe banndol ngol, o wi'i: —Ndaaree ƴibbi e leɗɗe goɗɗe ɗe fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Si on nji'ii ɗe mbilitii, oɗon anndi ndunngu ɓadake. ");
INSERT INTO fuhbkf_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Noon du, si on nji'ii kulle ɗeen ina ngaɗa, annditon laamu Laamɗo ɓadake. ");
INSERT INTO fuhbkf_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Goonga kaalanammi on: jamaanu o timmataa, tawee kulle ɗeen fuu ngaɗaay. ");
INSERT INTO fuhbkf_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Kammu e leydi timman, de haalaaji am kaa timmataa abada. ");
INSERT INTO fuhbkf_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","—Ndeenee ko'e mon taa yidde fijo suloowo e sulargol doro e kaɓɓu-ko'u adunaaru njowoo dow ɓerɗe mon de nyannde ndeen juha on ");
INSERT INTO fuhbkf_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","hono tuugol. Sabo inde wara dow yimɓe adunaaru fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ndelle, kakkilon wakkati fuu, ngaɗon du'aare, faa keɓon daɗude e kulle gaɗooje ɗeen fuu, mbaawon daraade yeeso Ɓii Neɗɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Nyalooma fuu, Iisaa ina waajoo ley suudu dewal mawndu, de jemma, o wurtoo, o waalowa dow waamnde wi'eteende Jaytun. ");
INSERT INTO fuhbkf_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Yimɓe fuu ina njaha to suudu dewal mawndu illa fajiri faa kettindanoo mo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Wakkati iidi buuru mo wattaaka rabilla ndiin ɓadake. Ɗum woni iidi nyannde Faltagol. ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Hooreeɓe almaami'en e jannginooɓe Tawreeta ɓeen ina piloo no mbarda Iisaa, de si goonga iɓe kula yimɓe ɓeen. ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ndeen Seyɗaani naati Yahuuda bi'eteeɗo Isikariyotto, gooto e sappo e ɗiɗo ɓeen. ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","O yehi o haaldowi e hooreeɓe almaami'en e doomooɓe suudu dewal mawndu no o wattirta Iisaa e juuɗe muɓɓen. ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ɓe ceyii, ɓe ndewri ɓe kokkan mo ceede. ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","O jaɓi, imo filoo wakkati mo o jambotoo Iisaa e cuncukka, tawa jamaa oon faamaay. ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Nyalaande iidi buuru mo wattaaka rabilla yottake. Wo nyalaande nde dammuuli iidi Faltagol njeyi hirseede. ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Iisaa nuli Piyeer e Yuhanna, wi'i ɗum'en: —Njehee cegilanee en hiraande iidi Faltagol faa nyaamen. ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ɓe ƴami mo: —Toy njiɗɗaa min cegiloo nde? ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","O wi'i ɓe: —Ndaaree, si on naatii ngalluure nde, on kawran toon e gorko, ina ronndii loonde ndiyam. Njokkon mo faa e suudu ɗo o naatata ɗoon, ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","mbi'on jom galle oon: «Moodibbo na ƴame toy woni suudu ndu nyaamdata e taalibaaɓe mum ɓeen iidi Faltagol?» ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","O hollan on suudu sooro mawndu moƴƴinaandu. Wo dow toon cegilotoɗon hiraande ndeen. ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ɓe njehi, ɓe tawi hono no o wi'iri ɓe noon, ɓe cegilanii hiraande iidi Faltagol ndeen. ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Nde wakkati oon yottinoo ndeen, o jooɗii kanko e sappo e ɗiɗo ɓeen. ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","O wi'i ɓe: —Miɗo muuyi nyaamdude e mooɗon hiraande iidi Faltagol nde sanne, gilla mi torraaka. ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Sabo miɗo wi'a on, mi nyaamataa nde katin faa nyannde nde ɗum tabiti ley laamu Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","O hooƴi horde, o yetti Laamɗo, o wi'i: —Njaɓee ɗum, peccee ɗum hakkunde mooɗon, ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","sabo miɗo wi'a on, illa joonin mi yarataa cabijam katin faa nde laamu Laamɗo wari. ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Katin, o hooƴi buuru, o yetti Laamɗo, o heltii, o hokki ɓe, o wi'i: —Ɗum wo ɓanndu am hokkaandu saabe mooɗon. Ngaɗon ɗum faa miccitoɗon kam. ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Hono noon du, nde ɓe tilinoo e hiraande ndeen, o hooƴi horde cabijam, o hokki ɓe, o wi'i: —Horde nde woni amaana keso tabintiniraaɗo ƴiiƴam am ndufeteeɗam saabe mooɗon. ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ammaa paamee, jambotooɗo kam oon ina nyaamda e am e le'al gootal. ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Tilay Ɓii Neɗɗo yoppira adunaaru hono no fodoranaa noon. Ammaa bone woodanii jambotooɗo mo oon! ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ndeen ɓe puɗɗi ƴamundurde hakkunde maɓɓe moy e maɓɓe waɗata huunde ndeen. ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Jeddi ngaɗi hakkunde maɓɓe du e dow moy ɓuri teddude. ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Iisaa wi'i ɓe: —Kaanankooɓe leyɗe ina ndawrana jaalaaɓe muɓɓen. Jom'en doole dow yimɓe ɓeen du ina njiɗi noddireede wallooɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Onon kaa, wanaa hono noon. Sanaa ɓurɗo teddude e mooɗon laatoo hono cukalel, ardiiɗo du laatoo hono golloowo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Sabo moy ɓuri teddude, jooɗiiɗo faa nyaama naa golloowo gaddoowo nyaamdu? Wanaa nyaamoowo oon ɓuri naa? De miin kaa, miɗo woni hakkunde mooɗon hono golloowo oon. ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Onon ngoni heddodiiɓe e am ley torraaji am. ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Saabe ɗuum, miin du, mi hokkii on laamu hono no Baaba am hokkiri kam laamu ni, ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","faa nyaamon, njaron to nyaamirde am ley laamu am. On njooɗoto dow jooɗorɗe laamu, caroɗon lenyi Israa'iila sappo e ɗiɗi ɗiin. ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Simon, Simon, Seyɗaani nyaagake heɓude on faa seɗa on hono no alkama seɗirtee ni. ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ammaa mi du'anake ma taa goonɗinal maa mursee. Aan le, nde ngartoyɗaa to am, cemmbinɗinaa sakiraaɓe maa. ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Piyeer wi'i mo: —Joomam, miɗo segilii yaadude e maaɗa ley kasu e wardeede e maaɗa! ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","De Iisaa wi'i: —Miɗo haalane, Piyeer, fadde ndontoori e joggude hannden tawan a wi'ii kile tati a anndaa kam. ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","O wi'i ɓe katin: —Nde nulunoomi on ndeen, on kooƴaay dannga e mbasu e paɗe, won ko nyakani on naa? Ɓe mbi'i: —Walaa! ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","O wi'i ɓe: —Joonin kaa, jogiiɗo dannga hooƴa, jogiiɗo mbasu hooƴa, mo walaa kaafaahi du, sootta saaya muuɗum sooda ngooti. ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Sabo ina winndaa, «O limaama ley bonɓe.» Miɗo haalana on: ina tilsi ɗum tabita dow am. Sabo ko winndaa dow am fuu tabitan. ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ɓe mbi'i: —Joomii amin, inan kaafaaje ɗiɗi! O wi'i ɓe: —Heƴii! ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Iisaa wurtii, fonndii waamnde Jaytun no woowri noon. Taalibaaɓe makko ɓeen njokki mo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Nde o yottinoo nokkuure ndeen, o wi'i ɓe: —Ndu'ee faa taa naaton ley jarribe. ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Caggal ɗuum, o toowti ɓe ko waɗata hono limnere hayre. O hofii, imo waɗa du'aare, ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","imo wi'a: —Baaba, si a muuyii, woɗɗinam horde torra nde. Ammaa taa ɗum laatoroo muuyo am, ɗum laatoroo muuyo maa aan! ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Wakkati oon, maleyka ƴuuruɗo dow kammu ɓangi e makko, semmbini mo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ley mettorgal ɓernde makko o ɓeydi tekkinde du'aare makko, nguli makko laatii hono toɓɓe ƴiiƴam ina simta e leydi. ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Nde o hantunoo du'aare ndeen, o yeccii to taalibaaɓe makko ɓeen, o tawi iɓe ɗaanii saabe mettorgal ɓerɗe maɓɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","O wi'i ɓe: —Ko waɗi de oɗon ɗaanii? Ummee ndu'ee, faa taa naaton ley jarribe! ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Imo woni e haala ka faa jamaa wari. Bi'eteeɗo Yahuuda, gooto e sappo e ɗiɗo ɓeen, ardii ɓe de ɓattitii Iisaa faa muccoo ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","De Iisaa wi'i mo: —Yahuuda, muccaango njammbortoɗaa Ɓii Neɗɗo naa? ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Nde wonduɓe e Iisaa ɓeen nji'unoo ko anniyii laataade fu, mbi'i: —Joomii amin, min coppa ɓe kaafaaje naa? ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ndeen gooto maɓɓe soppi maccuɗo Almaami Mawɗo, taƴi nowru muuɗum nyaamru. ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Iisaa jaabii, wi'i: —Celdee ni. De o meemi nowru maccuɗo oon, o danni ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Iisaa haalani warɓe faa nannga ɗum ɓeen, hooreeɓe almaami'en e doomooɓe suudu dewal mawndu e mawɓe Alhuudiya'en ɓeen, wi'i: —On ngardii e kaafaaje e cabbi hono wo mi gujjo! ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Nyannde fuu miɗo wondunoo e mooɗon ley suudu dewal mawndu, on njowaay junngo dow am. Ammaa joonin wo wakkati mon, joonin wo wakkati mo nimre laamii. ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ɓe nanngi Iisaa, ɓe njaari ɗum faa ley galle Almaami Mawɗo. Piyeer ina jokki to toowti. ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Tawi yiite na huɓɓaa hakkunde taliyaare galle oon, Piyeer wari jooɗodii e ƴuulotooɓe ɗoon. ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Korɗo gooto yi'i imo hucciti e jayngol, ndaari mo faa wooɗi, wi'i: —O du na wondunoo e makko. ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","De Piyeer yeddi mo, wi'i: —Hey debbo, mi anndaa mo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Nde ɓooytunoo seeɗa, goɗɗo yi'i mo, wi'i: —Aan du e maɓɓe njeyaɗaa! De Piyeer wi'i: —Hey gorko, mi wanaa! ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Faa waɗi yamnde wootere gaɗa ɗuum, goɗɗo katin siini dow haala kaan, wi'i: —Goonga ni, gorko o ina wondunoo e makko, sabo kam du wo Galilinkeejo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","De Piyeer jaabii, wi'i: —Gorko, mi faamataa ko kaalataa ɗuum! O selaay haalude, faa ndontoori joggi. ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Iisaa hucciti e Piyeer, ndaari ɗum. Ndeen Piyeer miccitii haala ka Iisaa haalannoo ɗum kaan: «Fadde ndontoori e joggude hannden, a wi'an kile tati a anndaa kam.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","O wurtii yaasin, imo woya bojji cattuɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Yimɓe nannguɓe Iisaa ɓeen ina njalnoroo ɗum, ina piya ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ɓe cuddi yeeso makko, iɓe ƴama mo, iɓe mbi'a: —Hey annabaajo! Haalan min moy fiyi ma! ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Heddii iɓe njenna mo jennooje goɗɗe keewɗe. ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Nde weetunoo ndeen, yimɓe Saahiiɓe ɓeen kawriti, ɓeen ngoni mawɓe lenyol maɓɓe e hooreeɓe almaami'en e jannginooɓe Tawreeta. Iisaa waddaa yeeso maɓɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ɓe mbi'i ɗum: —Si aan woni Almasiihu haalan min. O wi'i ɓe: —Fay si mbiimi on noon du, on njaɓataa. ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Si mi ƴamii on du, on njaabataako. ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ammaa gilla joonin, Ɓii Neɗɗo jooɗoyto gere nyaamo Laamɗo, Jom baawɗe. ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ɓe fuu ɓe mbi'i: —Ndelle aan woni Ɓii Laamɗo naa? O wi'i ɓe: —Onon e ko'e mon kaali, wo miin jaati. ");
INSERT INTO fuhbkf_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Jonle ɓe mbi'i: —En kaajaaka seedaaku katin, sabo ko o haali e hunnduko makko ɗuum, en fuu en nanii. ");
INSERT INTO fuhbkf_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Caggal ɗuum, yimɓe Saahiiɓe ɓeen fuu ummii, njaari Iisaa to Pilaatu hooreejo oon. ");
INSERT INTO fuhbkf_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ɓe puɗɗi iɓe pela mo, iɓe mbi'a: —Gorko o min tawi ina wosina lenyol amin, ina haɗa ɗum'en yoɓude kaananke mawɗo oon lampo, ina wi'a hoore muuɗum wo Almasiihu, kaananke. ");
INSERT INTO fuhbkf_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilaatu ƴami mo, wi'i: —Aan woni kaananke Alhuudiyankooɓe naa? Iisaa jaabii, wi'i: —Aan e hoore maa haali. ");
INSERT INTO fuhbkf_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilaatu jaabii, wi'i hooreeɓe almaami'en e jamaa oon fuu: —Mi yi'aay fuu feloore e makko. ");
INSERT INTO fuhbkf_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ammaa ɓe ciini e haala maɓɓe sanne, iɓe mbi'a: —Ko o waajotoo ɗuum ina waddundura yimɓe ley leydi Yahuudiya fuu, gilla Galili to o fuɗɗiri toon faa e ɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Wakkati Pilaatu nannoo ɗum, ƴami yalla gorko o wo Galilinkeejo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Nde o faamunoo Iisaa na ƴuura e ley laamu Hirudus ndeen, o nuldi ɗum Hirudus. Sabo ley balɗe ɗeen tawi Hirudus ina woni ley Urusaliima. ");
INSERT INTO fuhbkf_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Nde Hirudus yi'unoo Iisaa ndeen, ɓerndem weli sanne, sabo ɓooyii ko yiɗunoo yiide mo saabe ko nanannoo dow makko ɗuum. Katin du ina yeloo yiide mo imo waɗa ko haaynii. ");
INSERT INTO fuhbkf_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","O ƴami ɗum ƴamɗe keewɗe, de Iisaa jaabaaki fay huunde. ");
INSERT INTO fuhbkf_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Hooreeɓe almaami'en e jannginooɓe Tawreeta na ndarii ɗoon, ina pelda mo no mbaawri fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Hirudus du huyfini mo, jalnorii mo, kam e sordaasiiɓe muuɗum, ɓorni mo saaya lobba, nultiri mo Pilaatu. ");
INSERT INTO fuhbkf_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Nyannde ndeen Pilaatu e Hirudus laatii yigiraaɓe, arande ɓe wanyundurnooɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilaatu noddi hooreeɓe almaami'en e mawɓe Alhuudiyankooɓe ɓeen e yimɓe fuu, ");
INSERT INTO fuhbkf_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","wi'i ɗum'en: —On ngaddanii kam neɗɗo o hono wo o bosinoowo yimɓe. Ndaaree, mi ƴamii mo yeeso mon, de ley ko peloton mo ɗuum fuu, mi tawaay fuu sabaabu jukkotooɗo mo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Hirudus du yi'aay faa'e e makko, sabo yeccinii mo to meeɗen. Paamee, gorko o waɗaay fay huunde ko jeyi warude ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ndelle, mi fiyan mo, mi yoppa mo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ina tilsi wakkati iidi Faltagol fuu Pilaatu yoofana ɓe kasunke gooto. ");
INSERT INTO fuhbkf_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ɓe fuu ɓe ndukidi daande wootere, ɓe mbi'i: —War mo, njoofanaa min Barabas! ");
INSERT INTO fuhbkf_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabas le wo uddanooɗo e kasu saabe muurtere waɗunoonde e ngalluure ndeen, e saabe war-hoore. ");
INSERT INTO fuhbkf_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilaatu haaldi e maɓɓe ɗiɗaɓerde saabe muuyo muuɗum yoofude Iisaa. ");
INSERT INTO fuhbkf_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ammaa ɓe keddii iɓe nduka, iɓe mbi'a: —Tontu mo! Tontu mo e leggal palaangal! ");
INSERT INTO fuhbkf_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilaatu wi'i ɓe tataɓerde: —Ɗume o waɗi ko boni? Mi tawaay e makko sabaabu fuu ko haani warude mo! Ndelle, mi fiyan mo, mi yoppa mo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ammaa ɓe ɓeydi feekaade peekaali mawɗi, iɓe mbi'a o tontee. Peekaali maɓɓe ɗiin njaaltii Pilaatu. ");
INSERT INTO fuhbkf_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","O hokki ɓe laawol faa ko ɓe ŋaarii ɗuum laatoo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","O yoofani ɓe mo ɓe ŋaarii yoofaneede oon, kam woni uddanooɗo ley kasu saabe muurtere e war-hoore. De Iisaa kaa, o watti ɗum e muuyɗe maɓɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Nde ɓe njaarannoo mo ndeen, ɓe nanngi gorko jeyaaɗo Sireene bi'eteeɗo Simon, ƴuuruɗo ley ladde. Ɓe mbakkini ɗum leggal palaangal ngaal faa jokka caggal Iisaa, yaara ngal. ");
INSERT INTO fuhbkf_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Yimɓe heewɓe na njokki ɗum. Rewɓe du ina ngoni ley maɓɓe, ina mboya ina piira ɓerɗe muɓɓen mettorgal saabe majjum. ");
INSERT INTO fuhbkf_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Iisaa hucciti e rewɓe ɓeen, wi'i ɗum'en: —Rewɓe Urusaliima, taa mboyee kam, ammaa mboyee ko'e mooɗon e ɓiɓɓe mon! ");
INSERT INTO fuhbkf_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Sabo dey, balɗe ngaran nde yimɓe mbi'ata: «Barke woodanii rewɓe rimarɓe e ɓe ndeedaay e enɗi ɗi musinaaka.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ndeen, yimɓe mbi'an baamle caama dow muɓɓen, mbi'a tile udda ɗum'en. ");
INSERT INTO fuhbkf_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Sabo si ɓe ngaɗii nii gilla liccal ngal wo keccal, noy laatoytoo si ngal yoorii? ");
INSERT INTO fuhbkf_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ɓe njaaridi Iisaa e yimɓe ɗiɗo bonɓe. Ɓeen du wo wareteeɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Nde ɓe njottinoo nokkuure wi'eteende Laalagal Hoore ndeen, ɓe tonti mo e leggal palaangal, kanko e bonɓe ɗiɗo ɓeen, gooto gere nyaamo makko, gooto du gere nano makko. ");
INSERT INTO fuhbkf_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","O wi'i: —Baaba, yaafa ɓe sabo ɓe anndaa ko ɓe ngaɗata. Ndeen ɓe pecciri kaddule makko cumnal. ");
INSERT INTO fuhbkf_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Yimɓe ndarii ɗoon ina ndaara. Hooreeɓe ɓeen du ndarii ina njalnoroo mo, ina mbi'a: —O hisinii woɓɓe, o hisina hoore makko si o Almasiihu, Cuɓaaɗo Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Sordaasiiɓe ɓeen du njalnorii mo. Ɓe ɓattii, ɓe kokki mo ndiyam lammuɗam, ");
INSERT INTO fuhbkf_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","iɓe mbi'a: —Si aan woni kaananke Alhuudiyankooɓe oon, hisin hoore maa! ");
INSERT INTO fuhbkf_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Tawi du alluwal takkaama dow hoore makko. Binndi dow maggal na mbi'a: O wo Kaananke Alhuudiyankooɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Gooto e bonɓe ɗiɗo tontidaaɓe e makko ɓeen ina mbonkoo mo, ina wi'a: —Wanaa aan woni Almasiihu naa? Hisin hoore maa, de kisinaa min minen du! ");
INSERT INTO fuhbkf_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ammaa gooto oon feli oyo oon, wi'i: —A hulataa Laamɗo naa? Aan e makko fuu, on potu jukkungo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Enen, jukkungo meeɗen wo goonga jaati, sabo ko foti e ko ngolluɗen tan njoɓeteɗen. De kanko kaa, o waɗaay fay huunde ko boni. ");
INSERT INTO fuhbkf_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ndeen o wi'i: —Iisaa, miccitoɗaa kam wakkati ngartoyɗaa e laamu maa. ");
INSERT INTO fuhbkf_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Iisaa wi'i mo: —Goonga kaalanammaami: hannden jaati a wondowan e am ley aljanna. ");
INSERT INTO fuhbkf_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Wakkati hakkunde naange, nimre waɗi e leydi fuu faa wakkati yamnde tati kiiral naange. ");
INSERT INTO fuhbkf_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Naange niɓɓi, lefol paliingol ley suudu dewal mawndu ngool seekii ceeke ɗiɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Iisaa feekii feekaango manngo, wi'i: —Baaba, mi wattii yonki am ki ley junngo maa. Gaɗa o haalii ɗum, o seedi e yonki. ");
INSERT INTO fuhbkf_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Caggal mawɗo sordaasi'en oon yi'ii ko laatii ɗuum, yetti Laamɗo, wi'i: —Goonga, neɗɗo o wo dartiiɗo! ");
INSERT INTO fuhbkf_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Jamaa garuɗo ndaarude mo oon fuu yi'ii ko waɗi ɗuum. Ɓe njeccii, iɓe piya ɓerɗe maɓɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ammaa annduɓe mo ɓeen fuu, ina ndarii to toowti ina ndaara ɗum fuu. Rewɓe jokkunooɓe mo gilla leydi Galili ɓeen ina ngoni ley maɓɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ina woodi gorko bi'eteeɗo Yuusufi jeyaaɗo e waaldeere Saahiiɓe ndeen, wo o gorko lobbo, dartiiɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Kanko o jaɓaay ko Saahiiɓe ɓeen kaali e ko ɓe ngolli. Imo ƴuura Arimatiya, ngalluure ley leydi Yahuudiya. Imo heɗii ɓangugol laamu Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","O yehi to Pilaatu, o ŋaarii ɗum ɓanndu Iisaa, ");
INSERT INTO fuhbkf_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","o jippini ɗum e leggal ngaal, o fiili ɗum e kasanke, o watti ɗum ley saabeere wasaande ley hayre, ɗo fay gooto wattaaka. ");
INSERT INTO fuhbkf_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ɗum hawrii e nyannde segilanteende tawi nyannde fowteteende ɓadake fuɗɗude. ");
INSERT INTO fuhbkf_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Rewɓe wondunooɓe e Iisaa gilla Galili ɓeen njokki Yuusufi, nji'i saabeere ndeen e no o wattiraa ley mayre. ");
INSERT INTO fuhbkf_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ɓe kooti, ɓe moƴƴinowi nebbeele uurɗe e turaaje. Caggal ɗuum, ɓe powti nyannde fowteteende hono no yamiroore ndeen wi'iri. ");
INSERT INTO fuhbkf_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Gilla puɗal naange nyannde go'aɓerde e jeɗɗiire, rewɓe ɓeen ponndii to saabeere toon, ɓe kooƴii nebbeele uurɗe ɗe ɓe moƴƴinnoo ɗeen. ");
INSERT INTO fuhbkf_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ɓe tawi hayre ndeen tallitaama, ittaama e dammbugal saabeere ndeen. ");
INSERT INTO fuhbkf_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ammaa nde ɓe naatunoo ndeen, ɓe tawaay ɓanndu Iisaa, joomii ɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","E ley no hakkillooji maɓɓe mbemmborii noon, inan worɓe ɗiɗo punti, ina ndarii yeeso maɓɓe, ina ɓornii kaddule jalbooje. ");
INSERT INTO fuhbkf_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Kulol nanngi ɓe, ɓe leeƴini geese maɓɓe e leydi. Wakkati oon worɓe ɓeen mbi'i ɓe: —Ko waɗi oɗon piloo buurɗo hakkunde maayɓe? ");
INSERT INTO fuhbkf_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","O walaa ɗo, o ummitake. Miccitee ko o haalannoo on leydi Galili ɗuum ");
INSERT INTO fuhbkf_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","nde o wi'unoo: «Ina tilsi Ɓii Neɗɗo wattee e juuɗe luttuɓe, de tontee e leggal palaangal, de ummitoo nyannde tataɓerde.» ");
INSERT INTO fuhbkf_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ndeen ɓe miccii haala Iisaa kaan. ");
INSERT INTO fuhbkf_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ɓe ƴuwi to saabeere toon, ɓe njeccii, ɓe kaalanowi ɗum sappo e ngo'o ɓeen e wonduɓe e muɓɓen fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Rewɓe ɓeen ngoni: Mariyama mo Magdala, e Yowanna, e Mariyama inna Yaakuuba e rewɓe wonduɓe e muɓɓen. Ɓe kaalani ɗum nulaaɓe ɓeen. ");
INSERT INTO fuhbkf_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Nulaaɓe ɓeen ndaardi haala maɓɓe kaan hono njiiɓiika, njaɓaay goonɗinde ɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","De Piyeer kaa ummii, doggi, yehi saabeere toon. Nde o yuurninoo ley mayre ndeen, kasanke oon tan o yi'i. O yeccii wuro, imo wemmbii saabe ko waɗi ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Nyalooma oon pay, ɗiɗo e ley taalibaaɓe ɓeen kooƴi laawol wuro wi'eteengo Emayus. Hakkunde wuro ngoon e Urusaliima ina waɗa kilooji sappo e go'o. ");
INSERT INTO fuhbkf_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Iɓe pillodoo e dow ko waɗi ɗuum fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","E ley filla maɓɓe ɗo ɓe kokkundurta hakkillooji ɗoon, Iisaa e hoore muuɗum hewti ɓe, ina yaada e maɓɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ammaa gite maɓɓe uddaa taa ɓe anndita mo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","O wi'i ɓe: —Ɗume pillotoɗon e jahaangal mooɗon ngal? Ɓe ndarii, ɓerɗe maɓɓe metti. ");
INSERT INTO fuhbkf_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Gooto maɓɓe bi'eteeɗo Kiliyopas jaabii mo, wi'i: —Ndelle hakkunde weerɓe Urusaliima wo aan tan woni mo faamaay ko waɗi toon ley balɗe ɗe naa? ");
INSERT INTO fuhbkf_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","O wi'i ɓe: —Ɗume? Ɓe mbi'i mo: —Ko waɗi e Iisaa Nasaraatuujo oon. Wo o annabaajo, jom baawɗe ley haala makko e golle makko yeeso Laamɗo e yimɓe fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","De hooreeɓe almaami'en e mawɓe meeɗen ngatti mo ley juuɗe laamu faa o jukkee jukkungo maayde, tonti mo e leggal palaangal. ");
INSERT INTO fuhbkf_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Min cikkiino kanko rimɗinta Israa'iila. Ammaa katin du, hannden woni nyalooma tataɓo ko ɗum waɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Wooɗi rewɓe amin woɓɓe du ngaɗii min kaayeefi. Ɓe njehii to saabeere toon illa fajiri, ");
INSERT INTO fuhbkf_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","de ɓe tawaay ɓanndu makko toon. Ɓe ngarti, ɓe mbi'i maleyka'en ɓanganii ɓe, mbi'i imo wuuri. ");
INSERT INTO fuhbkf_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Caggal ɗuum, woɓɓe amin njehi to saabeere toon, tawri no rewɓe ɓeen mbiiri noon, de ɓe nji'aay mo kanko kaa. ");
INSERT INTO fuhbkf_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ndeen Iisaa wi'i ɓe: —Hey onon famɗuɓe hakkillo! Ɓerɗe mooɗon njaawaa goonɗinde ko annabaaɓe kaali fuu! ");
INSERT INTO fuhbkf_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Wanaa ina tilsi Almasiihu torree de naata ley teddeengal muuɗum naa? ");
INSERT INTO fuhbkf_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ndeen o faamini ɓe ko Binndi Ceniiɗi ɗiin fuu kaali dow makko, gilla e Tawreeta Muusaa faa e dewte annabaaɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Nde ɓe ɓattinoo wuro ngo ɓe ponndii ngoon ndeen, o waɗi hono o jiɗɗo faltaade. ");
INSERT INTO fuhbkf_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ammaa ɓe nyaagii mo, ɓe mbi'i: —Heddoda e amin, sabo hiirii, jemma warii. O naati, o jippodii e maɓɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Nde ɓe njooɗinoo iɓe nyaama ndeen, o hooƴi buuru, o yetti Laamɗo, o heltii buuru oon, o hokki ɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ndeen gite maɓɓe peertii, ɓe annditi mo. Wakkati oon o lalli e gite maɓɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ndeen iɓe mbi'undura hakkunde maɓɓe: —Wanaa ɓerɗe men na mbeli, na muuyi nanude sanne nde o haaldannoo e meeɗen dow laawol ndeen, imo faamina en Binndi ɗiin naa? ");
INSERT INTO fuhbkf_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Wakkati oon, ɓe ummii ɓe njeccii Urusaliima. Ɓe tawtowi toon sappo e ngo'o ɓeen, ina kawriti e yaadiraaɓe muɓɓen. ");
INSERT INTO fuhbkf_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ɓeen mbi'i ɓe: —Goonga, Iisaa Joomiraaɗo ummitake, o ɓanganii Simon. ");
INSERT INTO fuhbkf_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ɗiɗo ɓeen du kaalani ɓe ko waɗi e laawol muɓɓen, e no ɓe annditiri Iisaa nde heltunoo buuru ndeen. ");
INSERT INTO fuhbkf_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Nde ɓe kaalannoo ɗum ndeen, Iisaa funti darii hakkunde maɓɓe, wi'i ɓe: —Jam wondu e mooɗon! ");
INSERT INTO fuhbkf_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Nesiiji maɓɓe taƴi, ɓe kuli, ɓe miilii ko ɓe nji'ata ɗuum wo mbeelu. ");
INSERT INTO fuhbkf_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","De o wi'i ɓe: —Ɗume kulɗon? Ko waɗi oɗon cikkitira ley ɓerɗe mon? ");
INSERT INTO fuhbkf_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ndaaree juuɗe am e koyɗe am, wo miin jaati. Meemee kam, ndaaron. Sabo mbeelu walaa teewu, walaa ƴi'e hono no njiiruɗon kam ni. ");
INSERT INTO fuhbkf_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Nde o haalunoo ɗum ndeen, o holli ɓe newe juuɗe makko e koyɗe makko. ");
INSERT INTO fuhbkf_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","E ley ko ɓe kunngii goonɗinde saabe seyo maɓɓe e kaayeefi, o wi'i ɓe: —Oɗon ngoodi ɗo ko nyaametee naa? ");
INSERT INTO fuhbkf_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ɓe ngaddani mo tayre liingu nduppaangu. ");
INSERT INTO fuhbkf_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","O jaɓi nde, o nyaami yeeso maɓɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Caggal ɗuum, o wi'i ɓe: —Ko winndaa ley Tawreeta Muusaa e dewte annabaaɓe e Jabuura dow am ɗuum fuu, ina tilsi ɗum tabita. Kulle ɗeen jaati ngoni ko kaalannoomi on nde ngondunoomi e mooɗon ndeen. ");
INSERT INTO fuhbkf_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Wakkati oon, o omti hakkillooji maɓɓe faa ɓe paama Binndi ɗiin. ");
INSERT INTO fuhbkf_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","O wi'i ɓe: —Ina winndaa Almasiihu torrete faa maaya, ummitoto hakkunde maayɓe nyannde tataɓerde, ");
INSERT INTO fuhbkf_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","de tuubugol e yaafagol hakkeeji gooynete e lenyi fuu saabe innde makko. Ɗum fuɗɗan gilla Urusaliima. ");
INSERT INTO fuhbkf_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Onon ngoni seedotooɓe kulle ɗeen! ");
INSERT INTO fuhbkf_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Miin, mi nuldan on ko Baaba aadii ɗuum. Onon kaa, keddee ley ngalluure nde, faa nde baawɗe gonɗe dow ɗeen njippii e mooɗon. ");
INSERT INTO fuhbkf_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","O yaari ɓe faa ɗakkol Baytaniya, o ƴepti juuɗe makko, o barkini ɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Wakkati mo o barkini ɓe oon, o seedi e maɓɓe, o ƴeentinaa dow kammu. ");
INSERT INTO fuhbkf_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ɓe cujidani mo. Caggal ɗuum, ɓe njeccodii Urusaliima e seyo manngo. ");
INSERT INTO fuhbkf_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Wakkati fuu iɓe tawee ley suudu dewal mawndu, iɓe njetta Laamɗo.");
INSERT INTO fuhbkf_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Gillama e fuɗɗoode bi'eteeɗo Konngol ina woni. Bi'eteeɗo Konngol oon ina wondi e Laamɗo, wo o Laamɗo du. ");
INSERT INTO fuhbkf_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Imo wondi e Laamɗo gilla fuɗɗoode. ");
INSERT INTO fuhbkf_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","E makko Laamɗo tagiri huunde fuu. Fay huunde tagaaka si wanaa e makko. ");
INSERT INTO fuhbkf_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","E makko nguurndam woni, nguurndam ɗaam laatanii yimɓe annoora. ");
INSERT INTO fuhbkf_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Annoora oon ina yayna ley nimre. Nimre ndeen du waawaay jaalaade o. ");
INSERT INTO fuhbkf_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ina woodi neɗɗo mo Laamɗo nuli bi'eteeɗo Yaayaa. ");
INSERT INTO fuhbkf_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","O warii faa o seedanoo annoora oon, faa yimɓe fuu ngoonɗinira saabe makko. ");
INSERT INTO fuhbkf_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Wanaa kanko woni annoora oon, de o warii faa o seedanoo annoora oon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Oon woni annoora goongalaajo garɗo ley adunaaru faa yaynana yimɓe fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Bi'eteeɗo Konngol oon ina woni ley adunaaru, wo e makko adunaaru ndu tagiraa, de adunaaru nduun kaa annditaay mo. ");
INSERT INTO fuhbkf_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","O warii to jeydaaɓe makko, de jeydaaɓe makko ɓeen njaɓɓaaki mo. ");
INSERT INTO fuhbkf_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ammaa jaɓɓiiɓe mo de ngoonɗini mo ɓeen, o hokkii ɗum'en baawɗe laataade ɓiɓɓe Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Wo ɓe rimiraaɓe ko wanaa e ƴiiƴam, ko wanaa muuyo terɗe, ko wanaa muuyo gorko du, ammaa ɓe rimiraaɓe e baawɗe Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Konngol ngool laatii neɗɗo jom terɗe de jooɗii hakkunde meeɗen. Min nji'ii darja makko, darja mo Bajjo hemrata Baabiiwo. Ley darja makko oon Baabiiwo ɓanginiri keewal hinney e goonga muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yaayaa seedanake mo, ƴeewnii, wi'i: —Kanko woni mo kaalannoomi haala muuɗum oon nde mbi'unoomi: «Caggal am ardiiɗo kam waran, sabo imo woni gilla mi tagaaka.» ");
INSERT INTO fuhbkf_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","No hinney makko foti heewude, en fuu en keɓii, hinney dow hinney. ");
INSERT INTO fuhbkf_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Saabe Muusaa keɓirɗen jamirooje, ammaa hinney e goonga wo saabe Iisaa Almasiihu heɓiraa. ");
INSERT INTO fuhbkf_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Fay gooto yi'aay Laamɗo abada. Ammaa Ɓiɗɗo bajjo gonduɗo e Baabiiwo oon, kam humpiti en mo. ");
INSERT INTO fuhbkf_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Alhuudiyankooɓe Urusaliima neli Lewinkooɓe e almaami'en to Yaayaa ƴama ɗum kam wo moy. ");
INSERT INTO fuhbkf_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","O salaaki jaabaade ɓe, o haalani ɓe faa laaɓi: —Miin, mi wanaa Almasiihu. ");
INSERT INTO fuhbkf_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ɓe ƴami mo, ɓe mbi'i: —Aan, wo a moy? A annabi Iliyaasa naa? O wi'i: —Mi wanaa. Ɓe mbi'i mo: —Wo a Annabaajo oon naa? O wi'i: —Mi wanaa! ");
INSERT INTO fuhbkf_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ɓe mbi'i mo: —Wo a moy ndelle? Haalan min ko min kaaltanowa neluɓe min ɓeen. Moy mbi'ataa laatiɗaa? ");
INSERT INTO fuhbkf_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","O jaabii, o wi'i: —Wo mi ƴeewnotooɗo ley ladde miɗo wi'a: «moƴƴintinee laawol Joomiraaɗo», hono no annabi Esaaya wi'iri ni. ");
INSERT INTO fuhbkf_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ndeen nulaaɓe ƴuuruɓe to Farisa'en ɓeen ");
INSERT INTO fuhbkf_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ƴami mo: —Ko waɗi aɗa loota yimɓe lootagal batisima, si tawii a wanaa Almasiihu a wanaa Iliyaasa a wanaa Annabaajo oon? ");
INSERT INTO fuhbkf_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yaayaa jaabii ɓe, wi'i: —Miin, miɗo loota lootagal batisima, de na woodi dariiɗo hakkunde mooɗon mo on anndaa. ");
INSERT INTO fuhbkf_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Kanko, o waran caggal am. Miin, mi fotaa fay haɓɓitinde ɓoggi paɗe makko. ");
INSERT INTO fuhbkf_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ɗum fuu waɗii Baytaniya lettugal gooruwol Urdun, ɗo Yaayaa lootata yimɓe lootagal batisima ɗoon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Jaango majjum, Yaayaa yi'i Iisaa ina wara to muuɗum, wi'ii: —Inan jawgel Laamɗo donndotoongel hakkeeji adunaaru. ");
INSERT INTO fuhbkf_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ɗum woni ko mbi'unoomi e makko: «Neɗɗo waran gaɗa am, ardiiɗo kam, sabo imo woni gilla mi walaa.» ");
INSERT INTO fuhbkf_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Miin, mi anndaano mo, ammaa mi warii miɗo loota lootagal batisima faa o ɓangana Israa'iilankooɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Yaayaa seedii, wi'i: —Mi yi'ii Ruuhu ina wa'i hono wuugaandu ina ƴuura dow kammu ina jippoo faa hoɗi dow makko. ");
INSERT INTO fuhbkf_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Miin, mi anndaano mo. Ammaa Nulɗo kam mi loota lootagal batisima oon, kam wi'i kam: «Mo nji'uɗaa Ruuhu ina jippoo dow muuɗum oon, kam woni lootoowo lootagal batisima e Ruuhu Ceniiɗo.» ");
INSERT INTO fuhbkf_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Miin, mi yi'ii, mi seedake kanko woni Ɓii Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Jaango majjum katin Yaayaa ina darodii e taalibaaɓe muuɗum ɗiɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","O yi'i Iisaa ina faltoo, o wi'i: —Inan jawgel Laamɗo! ");
INSERT INTO fuhbkf_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Taalibaaɓe ɗiɗo ɓeen nani ko o haali ɗuum, njokki Iisaa. ");
INSERT INTO fuhbkf_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Iisaa yeeƴii, yi'i iɓe njokki ɗum, wi'i ɓe: —Ɗume pilotoɗon? Ɓe njaabii, ɓe mbi'i: — Rabbi (ɗum na fiirta «Moodibbo»), toy njooɗiɗaa? ");
INSERT INTO fuhbkf_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","O wi'i ɓe: —Ngaree ndaaree! Ndeen ɓe ngari, ɓe nji'i ɗo o jooɗii ɗoon. Wakkati oon wo yamnde nay laasara. Ɓe ngondi e makko ko heddii e nyalaande ndeen. ");
INSERT INTO fuhbkf_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andire sakiike Simon Piyeer oon wo gooto e ɗiɗo nanɓe haala Yaayaa de njokki Iisaa. ");
INSERT INTO fuhbkf_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ko Andire artii e waɗude fu wo filowaade sakiike muuɗum Simon oon. O wi'i ɗum: —Min nji'ii Almasiihu (ɗum na fiirta «Mo Laamɗo suɓii»). ");
INSERT INTO fuhbkf_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","O yaari ɗum to Iisaa. Iisaa ndaari Simon, wi'i ɗum: —Aan Simon ɓii Yuhanna, caggal joonin a inndirte Kefas. (Kefas e Piyeer fuu wo gootum. Maanaa inɗe ɗeen wo «Hayre».) ");
INSERT INTO fuhbkf_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Jaango majjum, Iisaa anniyii yaade Galili. O hawri e Filipu, o wi'i ɗum: —Jokkam! ");
INSERT INTO fuhbkf_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipu ina jeyaa Baytisayda, ngalluure nde Andire e Piyeer fuu njeyaa e muuɗum ndeen. ");
INSERT INTO fuhbkf_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filipu hawri e Natanayel, wi'i ɗum: —Min nji'ii mo haala muuɗum winndaa ley Tawreeta Muusaa e ley dewte annabaaɓe oon. Wo Iisaa Nasaraatuujo ɓii Yuusufi oon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanayel wi'i mo: —Yalla ko wooɗi ina waawi ƴuurude Nasaraatu naa? Filipu jaabii mo, wi'i: —War ndaar! ");
INSERT INTO fuhbkf_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Iisaa yi'i Natanayel ina fonndii ɗum, de haali haala makko wi'i: —Inan Israa'iilanke jaati, mo hiila fuu walaa e muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanayel wi'i mo: —Toy annduɗaa kam? Iisaa jaabii mo, wi'i: —Mi yi'ii ma ley ƴibbi gilla Filipu noddaay ma. ");
INSERT INTO fuhbkf_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanayel jaabii, wi'i: —Moodibbo, wo a Ɓii Laamɗo, wo a kaananke Israa'iila! ");
INSERT INTO fuhbkf_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Iisaa jaabii mo, wi'i: —Saabe mi wi'ii mi yi'ii ma ley ƴibbi ɗuum tan ngoonɗinirɗaa naa? A yi'an ko ɓuri ɗum haaynaade. ");
INSERT INTO fuhbkf_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ndeen o wi'i Natanayel: —Goonga kaalanammi on: on nji'an kammu ina udditoo, on nji'an maleyka'en Laamɗo ina ƴeeŋa ina njippoo dow Ɓii Neɗɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Balɗe ɗiɗi caggal ɗuum, ɓangal waɗi ley ngalluure wi'eteende Kaana ley leydi Galili. Inna Iisaa ina tawaa toon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Iisaa e taalibaaɓe muuɗum du noddaama ngara kawra e ɓangal ngaal. ");
INSERT INTO fuhbkf_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Nde cabijam maɓɓe timmunoo ndeen, inna Iisaa wi'i: —Ɓe ngalaa cabijam. ");
INSERT INTO fuhbkf_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Iisaa jaabii mo, wi'i: —Debbo, ɗume ɗum waɗata en? Wakkati am yonaay tafon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Inniiko wi'i gollooɓe ɓeen: —Ko o yamiri on fuu, ngaɗon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ɗoon ina woodi looɗe kaaƴe jeegom, ndee fuu na hooƴa liitereeji capanɗe jeetati faa yottoo hemre e noogay. Looɗe ɗeen wo faa Alhuudiyankooɓe lootoroo saabe diina. ");
INSERT INTO fuhbkf_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Iisaa wi'i ɓe: —Kebbinee looɗe ɗeen ndiyam. Ɓe kebbini ɗe faa ɗe keewi. ");
INSERT INTO fuhbkf_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","O wi'i ɓe: —Joonin kaa, nyeɗee ɗam njaaranee hooreejo ɓangal oon. Ɓe njaari. ");
INSERT INTO fuhbkf_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Nde hooreejo oon meeɗunoo ndiyam mbaylitaaɗam cabijam ɗaam ndeen, annditaay to ɗam ittaa. De gollooɓe nyeɗuɓe ndiyam ɗaam ɓeen kaa ina anndi. O noddi ɓaŋuɗo oon, ");
INSERT INTO fuhbkf_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","o wi'i ɗum: —Yimɓe fuu cabijam mbelɗam mboowi artoraade. Nde yimɓe njari faa heewi fu, ndeen ɗam welaa ɗaam du yaretee. De aan kaa, aɗa resi mbelɗam ɗam faa joonin. ");
INSERT INTO fuhbkf_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Nii Iisaa golliri maande muuɗum haayniinde arandeere ley ngalluure Kaana ley leydi Galili. O ɓangini teddeengal makko, taalibaaɓe makko ɓeen ngoonɗini mo. ");
INSERT INTO fuhbkf_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Caggal ɗuum, o dilli Kaana, o yehi ngalluure wi'eteende Kafarnahum, kanko e inniiko e minyiraaɓe makko e taalibaaɓe makko. Ɓe ngoni toon balɗe seeɗa. ");
INSERT INTO fuhbkf_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Nde iidi Alhuudiyankooɓe mbi'eteendi Faltagol ɓadinoo ndeen, Iisaa yehi Urusaliima. ");
INSERT INTO fuhbkf_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","To taliyaare suudu dewal mawndu toon o tawi luumotooɓe ga'i e baali e buugaali e weccooɓe ceede ina njooɗii. ");
INSERT INTO fuhbkf_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","O sowi ɓoggi, o waɗi dorowol, o riiwi ɓe fuu ɓe mburtoo suudu dewal mawndu nduun, kamɓe e ga'i maɓɓe e baali maɓɓe. O sankiti ceede weccooɓe ɓeen, o hippi taabaaje maɓɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","O wi'i soottooɓe buugaali ɓeen: —Ittee ɗum ɗo! Taa ngaɗon suudu Baaba am ndu suudu luumo! ");
INSERT INTO fuhbkf_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Taalibaaɓe makko ɓeen miccitii ko Binndi ɗiin mbi'i ɗuum: «Hirande suudu maa laatanake kam kaɓɓu-ko'u.» ");
INSERT INTO fuhbkf_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ndeen hooreeɓe Alhuudiyankooɓe mbi'i mo: —Haaynde ndeye kollataa min aɗa foti waɗude ko ngaɗuɗaa ɗuum? ");
INSERT INTO fuhbkf_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Iisaa jaabii ɓe, wi'i: —Liɓee suudu dewal ndu. Si on liɓii ndu, on nji'an miɗo nyiɓtoo ndu ley balɗe tati. ");
INSERT INTO fuhbkf_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ɓe njaabii mo: —Suudu ndu nyiɓiraama duuɓi capanɗe nay e jeegom. De aan, a nyiɓtoto ndu ley balɗe tati naa? ");
INSERT INTO fuhbkf_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ammaa ko Iisaa wi'i suudu nduun ɗuum, wo hoore muuɗum sappii. ");
INSERT INTO fuhbkf_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Nde Iisaa ummitinoo ndeen, taalibaaɓe muuɗum ɓeen miccitii ko haalnoo ɗum. Ɓe ngoonɗini ko Binndi ɗiin mbi'i ɗuum e haala ka o haalnoo kaan. ");
INSERT INTO fuhbkf_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Nde Iisaa wonnoo Urusaliima iidi Faltagol ndeen, heewɓe ngoonɗinii mo sabo nji'ii kaayeefiiji ɗi o waɗi ɗiin. ");
INSERT INTO fuhbkf_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ammaa Iisaa hoolaaki ɓe faa hokkita ɓe hoore muuɗum, sabo imo anndi ɓe fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Walaa ko fay gooto seedanoo mo ko woni e ɓiɓɓe-Aadama, sabo imo anndi ko woni e muɓɓen. ");
INSERT INTO fuhbkf_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ina woodi gorko Farisaajo bi'eteeɗo Nikodemu, gooto e hooreeɓe Alhuudiyankooɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Gorko oon yehi to Iisaa jemma, wi'i ɗum: —Moodibbo, miɗen anndi a jannginoowo ƴuuruɗo to Laamɗo, sabo fay gooto waawaa waɗude maandeeji kaayniiɗi ɗi ngaɗataa ɗiin si Laamɗo waldaa e muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Iisaa jaabii mo, wi'i: —Goonga kaalanammaami: fay gooto waawaa yi'ude laamu Laamɗo tawee rimtaaka katin. ");
INSERT INTO fuhbkf_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodemu wi'i mo: —Noy mawɗo waawiri rimtireede? Imo waawi yeccaade e reedu inniiko, de o rimee katin naa? ");
INSERT INTO fuhbkf_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Iisaa jaabii mo, wi'i: —Goonga kaalanammaami: si wanaa neɗɗo rimtiree ndiyam e Ruuhu fu waawaa naatude laamu Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ko ɓii-Aadama rimata ɗuum wo ɓii-Aadama. Ko Ruuhu oon du rimata wo ruuhu. ");
INSERT INTO fuhbkf_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Taa ɗum haayne saabe mi wi'ii ma sanaa ndimteɗon katin. ");
INSERT INTO fuhbkf_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Henndu ina wifira ɗo muuyri fuu. Aɗa nana bifi mayru, de a anndaa to ndu ƴuuri, a anndaa to ndu yahata. Hono noon dimraaɗo Ruuhu oon du worri. ");
INSERT INTO fuhbkf_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodemu wi'i mo: —Noy ɗum laatortoo? ");
INSERT INTO fuhbkf_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Iisaa jaabii mo, wi'i: —Wo a jannginoowo mawɗo ley Israa'iila de a anndaa ɗum naa? ");
INSERT INTO fuhbkf_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Goonga kaalanammaami: minen, ko min anndi min kaalata, ko min nji'i min ceedotoo, de onon le, on njaɓataa seedaaku amin. ");
INSERT INTO fuhbkf_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Si on ngoonɗintaa nde kaalanammi on haala kulle adunankooje fu, noy ngoonɗinirton si miɗo haalana on haala kulle dow kammu? ");
INSERT INTO fuhbkf_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Fay gooto ƴeeŋaay dow kammu, si wanaa ƴuuruɗo dow kammu oon, ɗum woni Ɓii Neɗɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Hono no Muusaa toowniri mboddi njamndi mboɗeeri ley ladde ni, sanaa Ɓii Neɗɗo du toowniree hono noon, ");
INSERT INTO fuhbkf_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","faa goonɗinɗo mo fuu heɓa nguurndam nduumiiɗam. ");
INSERT INTO fuhbkf_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Sabo Laamɗo ina yiɗi yimɓe adunaaru faa hokkitiri Ɓiyum bajjo, faa goonɗinɗo oon fuu taa halka ammaa heɓa nguurndam nduumiiɗam. ");
INSERT INTO fuhbkf_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Laamɗo nuliraay Ɓiyum oon e adunaaru faa Ɓiyum oon saroo adunaaru ndu. Ko o nuliraa dey, faa yimɓe adunaaru kisira saabe makko. ");
INSERT INTO fuhbkf_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Goonɗinɗo mo fuu sarataake. Mo goonɗinaay mo fuu saraama gilla joonin, sabo goonɗinaay Ɓii Laamɗo bajjo oon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Inan sariya oon: annoora warii e adunaaru, de yimɓe cuɓii nimre dow annoora sabo golleeji muɓɓen wo bonɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Bonɗo tagu yiɗaa annoora, ɓattataako ɗum saabe hulde taa golleeji muuɗum bonɗi ɗiin ɓangu. ");
INSERT INTO fuhbkf_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ammaa goongante waran e annoora faa golleeji ɗi waɗiri saabe Laamɗo ɗiin ɓanga. ");
INSERT INTO fuhbkf_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Caggal ɗuum, Iisaa yaadi e taalibaaɓe muuɗum leydi Yahuudiya. O ɓooytidi e maɓɓe toon, imo loota yimɓe lootagal batisima. ");
INSERT INTO fuhbkf_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yaayaa du ina loota yimɓe lootagal batisima to Aynon toon ɗakkol Salim, sabo ndiyam ina heewi toon. Yimɓe ina ngara ina lootiree ndiyam ɗaam. ");
INSERT INTO fuhbkf_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Tawi Yaayaa nanngaaka wattaa ley kasu tafon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Taalibaaɓe Yaayaa ɓeen njeddunduri e Alhuudiyanke haala laaɓal. ");
INSERT INTO fuhbkf_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ɓe njehi to Yaayaa, ɓe mbi'i ɗum: —Moodibbo, gorko gondunooɗo e maa gere ooto gooruwol Urdun mo ceedaniɗaa oon, kanko du imo loota yimɓe lootagal batisima, de yimɓe fuu ina njaha to makko. ");
INSERT INTO fuhbkf_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yaayaa jaabii ɓe, wi'i: —Neɗɗo waawaa heɓude fay huunde si wanaa ko Laamɗo hokki ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Onon e ko'e mon, on seedeeɓe am mi wi'ii mi wanaa Almasiihu, de miɗo artii mo nuleede. ");
INSERT INTO fuhbkf_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Gaddanaaɗo debbo ɓaŋaaɗo, kam woni ɓaŋuɗo. Dammbodiiɗo e gorko oon ina darii, ina hettindii. Si o nanii daande ɓaŋuɗo oon, o seyoto sanne. Nii seyo am ngoon hiɓɓiri. ");
INSERT INTO fuhbkf_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Na tilsi kanko o toowa, de miin le mi leeƴa. ");
INSERT INTO fuhbkf_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ƴuuruɗo dow oon, kam woni dow huunde fuu. Ƴuuruɗo e leydi wo jeyaaɗo e leydi, ina haala haalaaji jeyaaɗo e leydi. Ƴuuruɗo dow kammu oon, kam woni dow huunde fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ko o yi'i e ko o nani o seedotoo, de yimɓe kaa jaɓataa seedaaku makko. ");
INSERT INTO fuhbkf_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Jaɓuɗo seedaaku makko oon, laaɓinii Laamɗo wo goongante. ");
INSERT INTO fuhbkf_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Mo Laamɗo nuli oon, wo ko Laamɗo haali ɗuum haaltata, sabo Laamɗo hokkii mo Ruuhu mo walaa haddi. ");
INSERT INTO fuhbkf_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Baabiiwo oon ina yiɗi Ɓiɗɗo oon faa watti huunde fuu e junngo makko. ");
INSERT INTO fuhbkf_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Goonɗinɗo Ɓiɗɗo oon heɓii nguurndam nduumiiɗam. Mo goonɗinaay Ɓiɗɗo oon heɓataa ɗam, tikkere Laamɗo du ina heddii e muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Farisa'en nanii wi'aama Iisaa ina loota yimɓe lootagal batisima, ina heɓa taalibaaɓe faa ɓuri Yaayaa. ");
INSERT INTO fuhbkf_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Tawi Iisaa e hoore muuɗum kaa lootaay fay gooto, wo taalibaaɓe muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Nde Iisaa nannoo ko haalanoo e muuɗum fu, dilli leydi Yahuudiya, yeccii leydi Galili. ");
INSERT INTO fuhbkf_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Sanaa o rewa ley leydi Samariya. ");
INSERT INTO fuhbkf_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","O yottii ngalluure Samariya wi'eteende Sikar ɗakkol ngesa nga Yaakuuba hokkunoo ɓiyum Yuusufi ngaan. ");
INSERT INTO fuhbkf_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ɗoon ɓunndu Yaakuuba nduun woni. Tawi Iisaa tampii du e jahaangal ngaal, de jooɗii daande ɓunndu nduun faa fowta. Wakkati oon wo hakkunde naange. ");
INSERT INTO fuhbkf_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Samariyanke debbo wari ƴoogude. Iisaa wi'i mo: —Hokkam ndiyam, mi yara! ");
INSERT INTO fuhbkf_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Tawi taalibaaɓe makko ɓeen njehii ley ngalluure toon faa coodowa nyaamdu. ");
INSERT INTO fuhbkf_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Debbo oon wi'i Iisaa: —Noy waɗi de aan, Alhuudiyanke, aɗa ŋaaroo kam miin, Samariyanke, ndiyam faa njaraa? Sabo Alhuudiyankooɓe e Samariyankooɓe wo harmundurɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Iisaa jaabii mo, wi'i: —Si aɗa anndunoo no dokke Laamɗo poti, e bi'uɗo ma kokkaa ɗum ndiyam yara oon, a nyaagotono mo, o hokke ndiyam nguurndam njaraa. ");
INSERT INTO fuhbkf_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Debbo oon wi'i mo: —Joomam, a walaa cafirgal. Ɓunndu ndu ina luggi. Toy keɓataa ndiyam nguurndam ɗaam? ");
INSERT INTO fuhbkf_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Aan, aɗa ɓuri maama amin Yaakuuba kokkuɗo min ɓunndu ndu oon teddude naa? Kanko e ɓiɓɓe makko e daabaaji makko fuu, e mayru ɓe njaratano. ");
INSERT INTO fuhbkf_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Iisaa jaabii mo: —Neɗɗo fuu jarɗo ndiyam ɗam ɗomɗan katin, ");
INSERT INTO fuhbkf_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","ammaa jarɗo ndiyam ɗam kokkammi ɗaam fuu, ɗomɗataa faa abada. Sabo ndiyam ɗam kokkammi ɗaam laatanto ɗum ndiyam iloojam mbuurnoojam ɗum nguurndam nduumiiɗam. ");
INSERT INTO fuhbkf_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Debbo oon wi'i: —Joomam, hokkam ndiyam ɗaam taa mi ɗomɗa katin, sakko mi wartana ƴoogude ɗo katin. ");
INSERT INTO fuhbkf_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Iisaa wi'i mo: —Yahu noddoy gora, ngardon! ");
INSERT INTO fuhbkf_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Debbo oon jaabii mo: —Mi walaa goriiwo. Iisaa wi'i mo: —A haalii goonga ko mbiiɗaa a walaa goriiwo ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","A ɓaŋanooma worɓe njoyo. Mo ngonduɗaa joonin oon du, wanaa gora. A haalii goonga. ");
INSERT INTO fuhbkf_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Debbo oon wi'i mo: —Joomam, laaɓanii kam a annabaajo. ");
INSERT INTO fuhbkf_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Maamiraaɓe amin ndewii Laamɗo dow waamnde nde, de onon Alhuudiyankooɓe kaa, oɗon mbi'a to Urusaliima tan Laamɗo haani reweede. ");
INSERT INTO fuhbkf_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Iisaa wi'i mo: —Banndam debbo, goonɗinam: wakkati waran, nde ndewoton Baabiiwo tawee wanaa e waamnde nde, wanaa Urusaliima. ");
INSERT INTO fuhbkf_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Onon Samariyankooɓe, oɗon ndewa ko on anndaa, de minen Alhuudiyankooɓe, ko min anndi min ndewata, sabo kisindam to Alhuudiyankooɓe ƴuurata. ");
INSERT INTO fuhbkf_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Wakkati ina wara, yottake jaati, nde rewirooɓe Laamɗo goonga ɓeen ndewirta ɗum Ruuhu e goonga. Wo rewooɓe hono ɓeen Baabiiwo filotoo. ");
INSERT INTO fuhbkf_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Laamɗo wo Ruuhu. Rewooɓe mo ɓeen sanaa ndewira mo ruuhu e goonga. ");
INSERT INTO fuhbkf_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Debbo oon wi'i: —Miɗo anndi Cuɓaaɗo bi'eteeɗo Almasiihu oon wo garoowo. Nde o wari fu, o humpitan min huunde fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Iisaa wi'i mo: —Wo ɗum miin, mo kaaldataa oon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Wakkati oon fu, taalibaaɓe makko ɓeen njottii. Ko Iisaa haaldata e debbo oon ɗuum haaynii ɓe, de fay gooto maɓɓe ƴamaay mo ɗume o haajaa e debbo oon naa ko waɗi imo haalda e muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ndeen debbo oon yoppi loonde muuɗum toon, fornyii wuro haalanowi yimɓe, wi'i: ");
INSERT INTO fuhbkf_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Ngaree ndaaree gorko kaaltanɗo kam ko ngaɗunoomi fuu. Yalla wanaa kanko woni Almasiihu naa? ");
INSERT INTO fuhbkf_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ɓe njalti ngalluure, ɓe ponndii to Iisaa. ");
INSERT INTO fuhbkf_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Wakkati oon, taalibaaɓe ɓeen nyaagii mo, ina mbi'a: —Moodibbo, tinna nyaamu! ");
INSERT INTO fuhbkf_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","O jaabii ɓe, o wi'i: —Miɗo jogii ko mi nyaama ko on anndaa. ");
INSERT INTO fuhbkf_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Taalibaaɓe ɓeen ina ƴamundura: —Ɗum le, won gaddanɗo mo ko nyaametee naa? ");
INSERT INTO fuhbkf_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Iisaa wi'i ɓe: —Nyaamdu am wo waɗude muuyɗe Nulɗo kam oon e yottinde golle muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Onon, oɗon mbi'a: «Faa hannden lebbi nay de tayri wara.» De miin kaa miɗo wi'a on: ƴeptee gite mon, ƴeewee gese fuu ɓenndii, njonii taƴeede. ");
INSERT INTO fuhbkf_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Taƴoowo heɓan mbarjaari, resana nyaamri ndi nguurndam nduumiiɗam, faa aawuɗo e taƴuɗo fuu ceyodoo. ");
INSERT INTO fuhbkf_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ɗum tabintinta banndol bi'oowol: «Goɗɗo ina aawa, goɗɗo ina taƴa.» ");
INSERT INTO fuhbkf_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Mi nulii on taƴowon ngesa nga on tampanaay. Woɓɓe tampi, de oɗon mbeltii e tampiri muɓɓen. ");
INSERT INTO fuhbkf_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Samariyankooɓe heewɓe ley ngalluure ndeen ngoonɗinii Iisaa saabe haala debbo ceediiɗo de wi'i: «O haaltanii kam ko ngaɗunoomi fuu.» ");
INSERT INTO fuhbkf_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Nde Samariyankooɓe ɓeen njottinoo Iisaa ndeen, nyaagii mo o wonda e muɓɓen. O waɗi ɗoon balɗe ɗiɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Yimɓe heewɓe ngoonɗini mo katin saabe konngol makko. ");
INSERT INTO fuhbkf_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ɓe mbi'i debbo oon: —Joonin, wanaa saabe haalaaji maa ɗiin tan min ngoonɗiniri. Ko min ngoonɗiniri dey, minen e ko'e amin, min nanii konngol makko, min annditii kanko jaati woni Kisinoowo adunaaru. ");
INSERT INTO fuhbkf_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Caggal balɗe ɗiɗi ɗeen, o dilli ɗoon, o yehi Galili. ");
INSERT INTO fuhbkf_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Kanko e hoore makko o seedake: «Annabaajo teddintaake e ley wuro muuɗum.» ");
INSERT INTO fuhbkf_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Nde o yottinoo Galili ndeen, Galilinkooɓe njaɓɓorii mo juuɗe ɗiɗi, sabo kamɓe du ɓe njehiino iidi Urusaliima, ɓe nji'iino ko o gollunoo ley iidi ndiin ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ndeen Iisaa warti Kaana ley leydi Galili, ɗo o waylitinnoo ndiyam o waɗi ɗam cabijam ɗoon. Ina woodi howruujo kaananke gomma mo ɓiyum sellaa ley Kafarnahum. ");
INSERT INTO fuhbkf_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Nde howruujo oon nannoo Iisaa ƴuurii Yahuudiya wartii Galili fu, yehi to Iisaa, nyaagii ɗum jippoo dannanowa ɗum ɓiyum ɓadiiɗo maayde. ");
INSERT INTO fuhbkf_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Iisaa wi'i mo: —Si on nji'aay maandeeji e kaayeefiiji fu, on ngoonɗintaa. ");
INSERT INTO fuhbkf_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Howruujo kaananke oon wi'i mo: —Joomam, en njaha gilla ɓiyam oon maayaay. ");
INSERT INTO fuhbkf_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Iisaa wi'i mo: —Hootu, ɓiya daɗii. Gorko oon goonɗini ko Iisaa wi'i ɗum, hooti. ");
INSERT INTO fuhbkf_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ko o hootata ɗuum, gollooɓe makko kawrowi e makko dow laawol, kaalani mo, mbi'i: —Ɓiya oon daɗii. ");
INSERT INTO fuhbkf_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","O ƴami ɓe wakkati oye suka o samtanaa. Ɓe mbi'i mo: —Yamnde go'o ɓadagol sallifana keeŋan jontere ndeen yoppi mo. ");
INSERT INTO fuhbkf_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Baaba suka oon annditi wakkati oon jaati Iisaa wi'unoo ɗum: «Ɓiya oon daɗii!» Nii kanko e koreeji makko fuu ɓe ngoonɗiniri Iisaa. ");
INSERT INTO fuhbkf_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ɗum woni maande ɗiɗaɓerde nde Iisaa golli leydi Galili. O waɗii ɗum nde o ƴuurnoo leydi Yahuudiya. ");
INSERT INTO fuhbkf_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Caggal ɗuum, iidi Alhuudiyankooɓe ina waɗa. Iisaa yehi Urusaliima faa fota e iidi ndiin. ");
INSERT INTO fuhbkf_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ley Urusaliima toon, ɗakkol dammbugal wuro bi'eteengal Dammbugal Baali ngaal, ina woodi luggere ndiyam. Inde wi'ee Baytijata e ibraninkoore. Danɗe joy ina piilii nde. ");
INSERT INTO fuhbkf_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Nyawɓe heewɓe ina pukkii ley danɗe ɗeen: wumɓe e bonnguuɓe e ɓe ɓalli muɓɓen fuu mbaati.  ");
INSERT INTO fuhbkf_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Gorko nyawruɗo duuɓi capanɗe tati e jeetati ina woni ɗoon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Iisaa yi'i imo fukkii, annditi o ɓooydii e nyawu nguun, ƴami mo: —Aɗa yiɗi sellude naa? ");
INSERT INTO fuhbkf_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Nyawɗo oon jaabii mo, wi'i: —Joomam, mi walaa fay gooto balloowo kam naatude ley luggere nde wakkati ndiyam mayre iirii. Nde piliimi naatude fuu, tawan goɗɗo artake kam. ");
INSERT INTO fuhbkf_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Iisaa wi'i mo: —Umma, hooƴu daɗɗo maa, yahu! ");
INSERT INTO fuhbkf_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Wakkati oon fu, gorko oon daɗi, hooƴi daɗɗo mum fuɗɗiti yaade. Ɗum hawrii e nyalaande fowteteende. ");
INSERT INTO fuhbkf_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Saabe majjubm hooreeɓe Alhuudiyankooɓe mbi'i cellinaaɗo oon: —Hannden wo nyalaande fowteteende, daganaaki ma ndonndoɗaa daɗɗo maa. ");
INSERT INTO fuhbkf_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","O jaabii ɓe, o wi'i: —Cellinɗo kam oon, kam wi'i kam mi hooƴa daɗɗo am mi yaha. ");
INSERT INTO fuhbkf_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ɓe ƴami mo: —Moy woni biiɗo ma kooƴaa daɗɗo maa njahaa oon? ");
INSERT INTO fuhbkf_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ammaa cellinaaɗo oon faamaay fuu wo moy, sabo tawii Iisaa soorake ley jamaa keewɗo gonɗo ɗoon oon, dilli. ");
INSERT INTO fuhbkf_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Caggal ɗuum, Iisaa hawri e dannaaɗo oon ley suudu dewal mawndu nduun, wi'i mo: —Ndaaru, joonin kaa, a daɗii. Taa luttu katin de ko ɓuri ɗum bonde heɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Gorko oon yehi haalanowi hooreeɓe Alhuudiyankooɓe ɓeen wo Iisaa woni cellinɗo ɗum oon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ndeen hooreeɓe Alhuudiyankooɓe puɗɗi torrude Iisaa sabo waɗii ɗum nyalaande fowteteende. ");
INSERT INTO fuhbkf_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Iisaa wi'i ɓe: —Baaba am ina golla faa joonin, miin du, miɗo golla. ");
INSERT INTO fuhbkf_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ndeen hooreeɓe Alhuudiyankooɓe ɓeydi filaade warude mo, wanaa saabe ko o lutti nyannde fowteteende ndeen ɗuum tan, ammaa ko o wi'i Laamɗo wo baabiiko ɗuum du. O fonndii hoore makko e Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Iisaa wi'i ɓe: —Goonga kaalanammi on: Ɓiɗɗo waawaa gollude fay huunde kam tan, sanaa ko yi'i Baabiiwo ina golla. Sabo ko Baabiiwo oon gollata ɗuum, Ɓiɗɗo du gollata. ");
INSERT INTO fuhbkf_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Sabo Baabiiwo ina yiɗi Ɓiɗɗo oon, ina holla ɗum huunde fuu ko gollata. O hollan ɗum golleeji ɓurɗi ɗii ɗo fuu semmbe faa haaynoo on. ");
INSERT INTO fuhbkf_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Sabo hono no Baabiiwo ummintinirta maayɓe de hokka ɗum'en nguurndam ni, noon Ɓiɗɗo du hokkirta nguurndam mo muuyi hokkude. ");
INSERT INTO fuhbkf_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Baabiiwo, kam kaa sarataako fay gooto. O wattii sariya oon fuu e junngo Ɓiɗɗo, ");
INSERT INTO fuhbkf_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","faa yimɓe fuu teddinira Ɓiɗɗo oon hono no teddinirta Baabiiwo oon ni. Neɗɗo fuu mo teddinaay Ɓiɗɗo oon, teddinaay Baabiiwo nulɗo mo oon du. ");
INSERT INTO fuhbkf_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Goonga kaalanammi on: nanɗo haala am de goonɗini Nulɗo kam oon heɓii nguurndam nduumiiɗam. O sarataake, o diwii maayde, o naatii nguurndam. ");
INSERT INTO fuhbkf_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Goonga kaalanammi on: wakkati ina wara, o yottake jaati, wakkati mo maayɓe nanata daande Ɓii Laamɗo oon. Nanɓe ɓeen mbuuran. ");
INSERT INTO fuhbkf_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Hono no Baabiiwo oon wuurniri hoore muuɗum nii, hono noon o hokkiri Ɓiɗɗo oon du baawɗe wuurnira hoore muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","O hokkii ɗum baawɗe saraade, sabo wo Ɓii Neɗɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Taa ɗum haaynoo on. Wakkati waran mo maayɓe wonɓe ley caabeeje fuu nanata daande makko, ");
INSERT INTO fuhbkf_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","de njalta. Golluɓe golleeji lobbi ummitanoo nguurndam, golluɓe golleeji bonɗi ummitanoo sariya. ");
INSERT INTO fuhbkf_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Miin, walaa fuu ko mbaawumi gollude e hoore am. Ko nanumi ɗuum carotoomi. Sariya am ina dartii, sabo mi filataako muuyɗe am, wo muuyɗe Nulɗo kam oon pilotoomi. ");
INSERT INTO fuhbkf_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","—Si mi seedanake hoore am, seedaaku am sellataa. ");
INSERT INTO fuhbkf_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ina woodi goɗɗo ceedantooɗo kam. Miɗo anndi seedaaku ngu o seedantoo kam nguun wo goonga. ");
INSERT INTO fuhbkf_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Onon, on neliino yimɓe to Yaayaa. Kam du seedake goonga. ");
INSERT INTO fuhbkf_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Miin kaa, mi haajaaka seedaaku ɓii-Aadama, de miɗo haalana on kabaaru seedaaku Yaayaa nguun faa kison. ");
INSERT INTO fuhbkf_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yaayaa laatake lampal kuɓɓoowal, jaynoowal. On njaɓii weltaade e annoora makko faa ɓooyti seeɗa. ");
INSERT INTO fuhbkf_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Miin, miɗo jogii seedaaku ɓurngu ngu Yaayaa nguun semmbe: golleeji ɗi Baabiiwo yamiri kam mi golla ɗiin, kanji jaati ceedantoo kam Baabiiwo nuli kam. ");
INSERT INTO fuhbkf_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Katin du, Baabiiwo nulɗo kam oon, kam e hoorem seedantoo kam. Abada on nanaay daande makko, abada on nji'aay mo, ");
INSERT INTO fuhbkf_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","haala makko du walaa e mooɗon, sabo on ngoonɗinaay mo o nuli oon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Oɗon taykoo Binndi sabo on miilii on keɓan e majji nguurndam nduumiiɗam. De wo kanji jaati ceedantoo kam. ");
INSERT INTO fuhbkf_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ammaa on njaɓaay warude to am faa keɓon nguurndam. ");
INSERT INTO fuhbkf_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Mi filataako manooje yimɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","De miɗo anndi on, miɗo anndi njinngu Laamɗo walaa e mooɗon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Miin, mi wardii saabe innde Baaba am, de on njaɓɓaaki kam. Kaa si goɗɗo wardii saabe hoore muuɗum fu, on njaɓɓoto ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Oɗon manundura, de on pilataako manooje ƴuurooje to Laamɗo gooto. Ndelle noy mbaawruɗon goonɗinirde? ");
INSERT INTO fuhbkf_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Taa miilee wo miin felata on to Baabiiwo. Wo Muusaa mo njowuɗon jikke mooɗon dow muuɗum oon, kam felata on. ");
INSERT INTO fuhbkf_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Sini on ngoonɗiniino Muusaa, on ngoonɗinan kam miin du, sabo wo miin o sappii e binndi makko. ");
INSERT INTO fuhbkf_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","De si on ngoonɗinaay ko Muusaa winndi ɗuum, noy ngoonɗinirton haala am? ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Caggal ɗuum, Iisaa feƴƴiti maayo Galili wi'eteengo Tiberiyas. ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Jamaa keewɗo ina jokki mo sabo ɓe nji'ii kaayeefiiji ɗi o waɗunoo nde o sellinnoo nyawɓe ɓeen ndeen. ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Iisaa ƴeeŋi dow waamnde, jooɗodii toon e taalibaaɓe muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Tawi iidi Alhuudiyankooɓe mbi'eteendi Faltagol ndiin ɓadake. ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Iisaa ɓanti gite muuɗum, haccii jamaa keewɗo ina wara to muuɗum. O wi'i Filipu: —Toy coodeten nyaamdu ko nyaamnata ɓee fuu? ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Tawi wo faa o ndaartindoo Filipu o wiirii noon, sabo imo anndi ko o anniyii gollude. ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipu jaabii mo: —Buuru buuɗi cardi keme ɗiɗi heƴataa ɓe faa mono e maɓɓe fuu heɓa seeɗa. ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Taalibbo makko goɗɗo, bi'eteeɗo Andire minyoo Simon Piyeer, wi'i mo: ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Inan, suka gorko gooto ina jogii buuruuje joy e liƴƴi ɗiɗi, de ɗume ɗum nafirta yimɓe heewɓe hono ɓe? ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Iisaa wi'i: —Mbi'ee ɓe njooɗoo! Tawi nokku oon ina heewi huɗo. Ɓe njooɗii ɗoon, fay worɓe tan na ngaɗa hono ujunaaje njoyo. ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Iisaa hooƴi buuruuje ɗeen, yetti Laamɗo, hokki taalibaaɓe muuɗum ɓeen. Ɓeen du kokki jooɗiiɓe ɓeen. Noon o waɗi liƴƴi ɗiin du. Yimɓe fuu nyaami faa kaari. ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Nde ɓe kaarnoo ndeen, Iisaa wi'i taalibaaɓe muuɗum: —Kawrunduree kedde ɗe taa fay huunde bona. ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ɓe kawrunduri kedde taƴe buuruuje joy ɗe nyaamnooɓe ɓeen keddi ɗeen, ɗe keewi kandeeje sappo e ɗiɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Nde yimɓe ɓeen njiinoo maande haayniinde nde Iisaa golli ndeen, mbi'i: —Kanko jaati woni Annabaajo cappanooɗo ina wara e adunaaru ndu! ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Iisaa annditi iɓe cegilii nanngirde ɗum doole faa ɓe ngaɗa ɗum kaananke. Ndelle dilli ɗoon, ƴeeŋi dow waamnde kam tan. ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Nde hiirnoo fu, taalibaaɓe Iisaa ndegii e maayo. ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ɓe naati laana faa ɓe peƴƴita, ɓe njaha Kafarnahum. Jemma warii, tawi Iisaa hewtaay ɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Henndu mawndu ina wifa, bempeƴƴe ummii. ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Tawi ɓe ndorbake laana kaan faa ɓe keɓi hono kilooji joy naa jeegom. Wakkati oon, ɓe kaynii Iisaa ina wara e koyɗe muuɗum dow ndiyam ɗaam, ina ɓattii ɓe, de ɓe kuli sanne. ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Iisaa wi'i ɓe: —Wo miin. Taa kulee! ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ndeen ɓe muuyi o naata laana kaan. De wakkati oon fu ka yottii nokku ɗo ɓe ponndinoo ɗoon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Jaango majjum, jamaa keddinooɗo gere ooto maayo ngoon oon paami laana ngoota tan wonnoo toon. Ɓe nji'ii du Iisaa naatidaay e taalibaaɓe muuɗum laana kaan. Ɓe nji'ii taalibaaɓe ɓeen tan ndillidi e makka. ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Laanaaji goɗɗi ƴuuruɗi Tiberiyas ngarii ɗakkol ɗo Iisaa yettunoo Laamɗo de nyaamni yimɓe buuru ɗoon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Nde jamaa oon yiinoo Iisaa e taalibaaɓe muuɗum fuu ngalaa ɗoon ndeen, ɓe naati laanaaji ɗiin, ɓe ponndii Kafarnahum faa ɓe pilowoo Iisaa. ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Nde ɓe tawnoo Iisaa gere ooto maayo ndeen, ɓe mbi'i ɗum: —Moodibbo, ndey ngarɗaa ɗo? ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Iisaa jaabii ɓe: —Goonga kaalanammi on: wanaa saabe ko njiiɗon maandeeji kaayniiɗi ɗuum pilortoɗon kam. Ko pilortoɗon kam dey, saabe on nyaamiino buuru faa kaarɗon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Taa ngollanee nyaamdu murseteendu. Ko kaanɗon gollande dey, nyaamdu heddotoondu wuurnooru yimɓe nguurndam nduumiiɗam. Nyaamdu nduun wo Ɓii Neɗɗo hokkata on. Sabo Laamɗo Baabiiwo oon waɗi maande muuɗum e makko. ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ndeen ɓe ƴami mo: —Ɗume min ngaɗata faa min ngolla golleeji ɗi Laamɗo yiɗi? ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Iisaa jaabii ɓe: —Gollal ngal Laamɗo yiɗi ngaal woni ngoonɗinon mo o nuli. ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ɓe njaabii mo: —Haaynde ndeye ngaɗataa faa min nji'a, de min ngoonɗine? Ɗume ngollataa? ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Maamiraaɓe amin nyaamii nyaamdu wi'eteendu «manna» ley ladde, hono no winndiraa ni: «O hokkii ɓe nyaamdu ƴuurundu dow kammu faa ɓe nyaama.» ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Iisaa jaabii ɓe: —Goonga kaalanammi on: wanaa Muusaa hokki on nyaamdu ƴuurundu dow kammu nduun. Wo Baaba am, kam woni kokkoowo on nyaamdu goongalaaru ƴuurundu dow kammu. ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Sabo nyaamdu ndu Laamɗo hokkata nduun woni ƴuurooru dow kammu, hokkooru yimɓe adunaaru nguurndam. ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ɓe mbi'i mo: —Joomii amin, hokku min nyannde fuu nyaamdu nduun. ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Iisaa wi'i ɓe: —Miin woni nyaamdu wuurnooru. Garɗo to am fuu, yolbataa abada. Goonɗinɗo kam fuu ɗomɗataa abada. ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Mi wi'ii on: on nji'ii kam, de on ngoonɗinaay. ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Mo Baabiiwo hokki kam fuu, waran to am. Garɗo to am fuu, mi riiwataa ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Sabo wanaa faa mi waɗa muuyɗe am ƴuurirmi dow kammu, wo faa mi waɗa muuyɗe Nulɗo kam oon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Inan muuyɗe Nulɗo kam oon: taa fay gooto ɓe o hokki kam ɓeen majja, de mi ummintinan ɗum'en nyalaande sakitotoonde. ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Inan muuyɗe Baaba am oon: neɗɗo fuu ndaarɗo Ɓiɗɗo oon de goonɗini ɗum heɓan nguurndam nduumiiɗam, mi ummintinan ɗum nyalaande sakitotoonde. ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Hooreeɓe Alhuudiyankooɓe ɓeen ina ŋormoo haala makko sabo o wi'ii «Miin woni nyaamdu ƴuurundu dow kammu nduun.» ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ɓe mbi'i: —Oo le, wanaa Iisaa ɓii Yuusufi mo annduɗen inna muuɗum e bammum oon naa? Noy o wiirata wo dow kammu o ƴuuri? ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Iisaa wi'i ɓe: —Taa ŋormee hakkunde mooɗon! ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Fay gooto waawaa warude to am si Baabiiwo nulɗo kam oon fooɗaay ɗum. Garɗo to am fuu, mi ummintinan ɗum nyalaande sakitotoonde. ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ina winndaa ley dewte annabaaɓe: «Ɓe fuu, Laamɗo anndinan ɓe.» Neɗɗo fuu kettindaniiɗo Baabiiwo oon de faami, waran to am. ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Fay gooto yi'aay Baabiiwo, si wanaa ƴuuruɗo to muuɗum oon. Kanko tan yi'i Baabiiwo. ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Goonga kaalanammi on: goonɗinɗo kam, heɓii nguurndam nduumiiɗam. ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Miin woni nyaamdu wuurnooru. ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Maamiraaɓe mooɗon nyaamiino «manna» ley ladde. Ɗum fuu ɗum haɗaay ɓe maayde. ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ammaa ndu joonin ndu ɗo wo nyaamdu ƴuurundu dow kammu, faa si neɗɗo nyaamii ndu, maayataa. ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Miin woni nyaamdu wuurnooru ƴuurundu dow kammu. Si neɗɗo nyaamii nyaamdu nduun fu, wuuran faa abada. Nyaamdu ndu kokkammi nduun wo terɗe am, faa yimɓe adunaaru keɓa nguurndam. ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ndeen Alhuudiyankooɓe puɗɗi dukidinde ko mbaawi fuu e dow haala kaan, ina mbi'a: —Noy o waawiri hokkude en terɗe makko faa nyaamen? ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Iisaa jaabii ɓe: —Goonga kaalanammi on: si on nyaamaay terɗe Ɓii Neɗɗo, on njaraay ƴiiƴam muuɗum, nguurndam walanaa on. ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Neɗɗo fuu nyaamɗo terɗe am de yari ƴiiƴam am heɓii nguurndam nduumiiɗam. Miin du mi ummintinan ɗum nyalaande sakitotoonde. ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Sabo terɗe am wo nyaamdu jaati, ƴiiƴam am du wo njaram jaati. ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Neɗɗo fuu nyaamɗo teewu am de yari ƴiiƴam am ina woni e am, miin du miɗo woni e muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Hono no Baabiiwo nulɗo kam oon laatorii buurɗo, de miin du miɗo wuuri saabe muuɗum, noon du nyaamɗo kam fuu wuurdata saabe am. ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Kayru woni nyaamdu ƴuurundu dow kammu: ndu waldaa e ndu maamiraaɓe mooɗon nyaamunoo de maayi nduun. Nyaamɗo nduun nyaamdu wuuran faa abada. ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Iisaa waajii waajuuji ɗi ley waajordu Kafarnahum. ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Nde taalibaaɓe makko ɓeen nannoo ɗum ndeen, heewɓe muɓɓen mbi'i: —Waajuuji ɗi njoorii sanne. Moy waawi hettindaade ɗi? ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Iisaa faamii e ley ɓernde muuɗum taalibaaɓe mum ɓeen ina ŋormoo ɗum, de wi'i ɓe: —Yalla ɗum fonnditanaaki on faa ina nesa wosinde on naa? ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ndelle si on nji'ii Ɓii Neɗɗo ƴeeŋtii to wonnoo toon, noy ngaɗoton? ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ruuhu, kam hokkata nguurndam. Terɗe ɓii-Aadama kaa nafataa fay huunde. Haalaaji ɗi kaalanmi on ɗiin, kanji ngoni ruuhu, kanji ngoni nguurndam. ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","De ina woodi ley mooɗon ɓe ngoonɗinaay. Tawi Iisaa ina anndi gilla e fuɗɗoode ɓe ngoonɗintaa ɗum ɓeen e jambotooɗo ɗum oon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","O ɓeydi, o wi'i: —Ɗum waɗi de mbiimi on: fay gooto waawaa warude to am si Baabiiwo hokkaay ɗum no warda. ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Caggal ɗuum, heewɓe e taalibaaɓe makko ɓeen ndilli, jokkiti mo. ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ndeen Iisaa wi'i sappo e ɗiɗo ɓeen: —Onon du, oɗon njiɗi dillude naa? ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simon Piyeer jaabii mo: —Joomam, to moy min njahata? Sabo wo haalaaji kokkooji nguurndam nduumiiɗam njogiɗaa. ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Min ngoonɗinii, miɗen anndi a Ceniiɗo ƴuuruɗo to Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Iisaa wi'i: —Onon sappo e ɗiɗo ɓe, wanaa miin suɓii on naa? De gooto mooɗon wo seyɗaani. ");
INSERT INTO fuhbkf_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Haala ka o haali kaan wo Yahuuda ɓii Simon Isikariyotto. Oon woni jambotooɗo mo oon, gooto e sappo e ɗiɗo ɓeen. ");
INSERT INTO fuhbkf_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Caggal ɗuum, Iisaa yiilii ley Galili. O muuyaay yiiltaade ley Yahuudiya sabo hooreeɓe Alhuudiyankooɓe ina piloo faa mbara mo. ");
INSERT INTO fuhbkf_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Tawi iidi Alhuudiyankooɓe mbi'eteendi Hukumuuji ɓadake. ");
INSERT INTO fuhbkf_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Minyiraaɓe Iisaa worɓe mbi'i ɗum: —Dillu ɗo, njahaa Yahuudiya faa taalibaaɓe maa ɓeen nji'a golleeji ɗi ngollataa ɗiin. ");
INSERT INTO fuhbkf_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Fay gooto suuɗataa ko gollata si ina yiɗi anndeede. Si aɗa golla golleeji ɗiin, ɓanginan yimɓe fuu wo a moy. ");
INSERT INTO fuhbkf_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Tawi fay minyiraaɓe makko ɓeen du ngoonɗinaay mo. ");
INSERT INTO fuhbkf_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Iisaa wi'i ɓe: —Wakkati am waraay tafon, onon le, wakkati fuu wo wakkati mon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Yimɓe adunaaru mbaawaa wanyude on, de miin kaa iɓe mbanyi kam, sabo miɗo seedii golleeji maɓɓe ɗi mbooɗaa. ");
INSERT INTO fuhbkf_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Onon kaa, njehee iidi ndiin. Miin kaa mi yahataa ndi sabo wakkati am yottaaki tafon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","O haalani ɓe ɗum tan, o heddii Galili. ");
INSERT INTO fuhbkf_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Nde minyiraaɓe Iisaa ɓeen njahunoo iidi ndiin ndeen, Iisaa du yehi toon, de o ɓanginaay hoore makko, o suuɗii. ");
INSERT INTO fuhbkf_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Hooreeɓe Alhuudiyankooɓe ina piloo mo ley jamaa iidi ndiin, ina mbi'a: —Toy o woni? ");
INSERT INTO fuhbkf_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Yimɓe heewɓe ina njeddundura dow haala makko. Woɓɓe ina mbi'a: —O neɗɗo lobbo! Woɓɓe du ina mbi'a: —O wanaa koy, o majjinoowo yimɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ammaa fay gooto suusaay haalde haala makko faa nanee, sabo iɓe kula hooreeɓe Alhuudiyankooɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Nde iidi ndiin feccirnoo fu, tawi Iisaa fuɗɗii waajaade ley suudu dewal mawndu. ");
INSERT INTO fuhbkf_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ɗum haaynii Alhuudiyankooɓe sanne, ɓe mbi'i: —Noy gorko mo janngaay o anndiri Binndi ɗiin ni? ");
INSERT INTO fuhbkf_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Iisaa jaabii ɓe, wi'i: —Waaju mo mbaajotoomi o, ƴuurataa e am, wo to Nulɗo kam oon o ƴuurata. ");
INSERT INTO fuhbkf_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Si neɗɗo muuyii gollude muuyɗe Laamɗo, annditan yalla waajuuji am ɗi to Laamɗo ƴuuri, naa wo haala am tan. ");
INSERT INTO fuhbkf_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Baajortooɗo haalaaji ƴuurɗi e muuɗum oon ina filoo mawninde hoore muuɗum. Ammaa mawninoowo nulɗo ɗum oon wo goongalaajo, oonyaare walaa e muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Wanaa Muusaa hokkii on dewtere Tawreeta naa? Ammaa fay gooto mooɗon jokkataa jamirooje ɗeen. Ko waɗi de oɗon piloo warude kam? ");
INSERT INTO fuhbkf_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Yimɓe ɓeen njaabii mo: —Aan, a kaaŋaaɗo. Moy filotoo warude ma? ");
INSERT INTO fuhbkf_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Iisaa jaabii ɓe, wi'i: —Huunde wootere tan ngaɗumi, de ɗum haaynake on, on fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Muusaa yamiri on taadagol. De ɗum ƴuuraay to Muusaa, wo to maamiraaɓe meeɗen ɗum ƴuuri. Oɗon taada neɗɗo fay nyalaande fowteteende. ");
INSERT INTO fuhbkf_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Sini neɗɗo ina taadee nyannde fowteteende faa taa lutton jamirooje Muusaa, ɗume tikkiranton kam saabe mi dannii neɗɗo faa laatoo kiɓɓuɗo nyalaande fowteteende? ");
INSERT INTO fuhbkf_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Taa cariree huunde e alhaali muuɗum, de cariree goonga. ");
INSERT INTO fuhbkf_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Woɓɓe ley yimɓe Urusaliima mbi'i: —Wanaa o woni mo ɓe pilotoo warude oon naa? ");
INSERT INTO fuhbkf_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Inani mo, imo waajoo yeeso yimɓe fuu de ɓe mbi'ataa mo fay huunde. Yalla mawɓe ɓeen tannyorii kanko woni Almasiihu jaati naa? ");
INSERT INTO fuhbkf_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ooɗo kaa, eɗen anndi ɗo ƴuurata, ammaa nde Almasiihu oon warata, fay gooto anndataa to ƴuurata. ");
INSERT INTO fuhbkf_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Tawi Iisaa ina waajoo ley suudu dewal mawndu nduun. O ƴeewnii, o wi'i: —Oɗon anndi kam, oɗon anndi ɗo ƴuurammi? Wanaa miin waddi hoore am. Nulɗo kam oon wo goongaajo, de onon kaa, on anndaa ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Miin kaa, miɗo anndi ɗum sabo to muuɗum ƴuurumi. Wo kam du nuli kam. ");
INSERT INTO fuhbkf_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ndeen ɓe pilii nanngude mo, de fay gooto meemaay mo, sabo wakkati makko waraay tafon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ammaa e noon fu, heewɓe ley jamaa oon ngoonɗinii mo, mbi'i: —Si Almasiihu warii fu, yalla gollan maandeeji kaayniiɗi ɓurɗi ɗi gorko o golli ɗiin naa? ");
INSERT INTO fuhbkf_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Farisa'en nani ko yimɓe ɓeen cifoto e dow Iisaa ɗuum. Hooreeɓe almaami'en e Farisa'en neli doomooɓe suudu dewal mawndu nduun nannga mo. ");
INSERT INTO fuhbkf_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ndeen Iisaa wi'i: —Miin, miɗo wondi e mooɗon seeɗa tafon. Caggal ɗuum, mi fornyoto to Nulɗo kam oon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","On piloto kam, de on njiitataa kam, sabo on mbaawaa yaade to ngonammi toon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Alhuudiyankooɓe ƴamunduri: —Toy o yahata faa tawee en mbaawaa yiitude mo? Yalla o yahan to yimɓe meeɗen ferduɓe ley yimɓe Geres, o waajoo ɗum'en naa? ");
INSERT INTO fuhbkf_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","O wi'i en piloto mo, en njiitataa mo, sabo en mbaawaa yaade to o tawetee toon. Ɗume woni maanaa haala kaa? ");
INSERT INTO fuhbkf_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Nyalaande sakitotoonde teddunde e iidi, Iisaa darii, ƴeewnii, wi'i: —Neɗɗo fuu ɗomɗuɗo wara to am, yara. ");
INSERT INTO fuhbkf_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Neɗɗo fuu goonɗinɗo kam, bubbirɗi ndiyam mbuurnoojam ilan ley ɓernde muuɗum, hono no winndiraa e Binndi ɗi ni. ");
INSERT INTO fuhbkf_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ko o haali ɗuum wo haala Ruuhu mo goonɗinɗo mo fuu heɓata. Ndeen Ruuhu waraay, sabo Iisaa teddinaaka to Laamɗo tafon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Nde keewal jamaa oon nannoo haala kaan ndeen, mbi'i: —Kanko jaati woni Annabaajo oon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Woɓɓe mbi'i: —Kanko woni Almasiihu. Woɓɓe katin mbi'i: —Almasiihu, wo Galili ƴuurata naa? ");
INSERT INTO fuhbkf_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Binndi ɗiin mbi'ii e lenyol Daawda Almasiihu ƴuurata, ley wuro Baytilaama ngo Daawda ƴuuri e muuɗum ngoon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Jamaa oon feccii saabe makko. ");
INSERT INTO fuhbkf_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Woɓɓe maɓɓe ina njiɗi nanngude mo, ammaa fay gooto yowaay junngom dow makko. ");
INSERT INTO fuhbkf_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Doomooɓe suudu dewal mawndu ɓeen ngarti to hooreeɓe almaami'en e Farisa'en. Ɓeen mbi'i doomooɓe ɓeen: —Ko waɗi de on ngaddaay mo? ");
INSERT INTO fuhbkf_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Doomooɓe ɓeen njaabii ɓe, mbi'i: —Abada fay gooto waajoraaki no gorko o waajortoo ni. ");
INSERT INTO fuhbkf_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Farisa'en njaabii ɓe, mbi'i: —Onon du on majjinaama naa? ");
INSERT INTO fuhbkf_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Yalla na woodi fuu goonɗinɗo mo hakkunde hooreeɓe Alhuudiyankooɓe maa Farisa'en naa? ");
INSERT INTO fuhbkf_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Yimɓe ɓe paamaay jamirooje Muusaa, wo ɓe huɗaaɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Gooto e Farisa'en bi'eteeɗo Nikodemu, jahunooɗo to Iisaa jemma oon, wi'i ɓe: ");
INSERT INTO fuhbkf_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Yalla sariya meeɗen ina saroo neɗɗo tawee hettindanaaka ko wi'i, anndaaka ko golli naa? ");
INSERT INTO fuhbkf_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ɓe njaabii mo, ɓe mbi'i: —Aan du, a Galilinkeejo naa? Tayka Binndi ɗiin, a yi'an annabaajo fuu ƴuurataa Galili. ");
INSERT INTO fuhbkf_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Caggal ɗuum, mono fuu hooti suudu muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ndeen Iisaa ƴeeŋowi waamnde wi'eteende Jaytun. ");
INSERT INTO fuhbkf_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Gilla puɗal naange o warti ley suudu dewal mawndu. Jamaa oon fuu wari. O jooɗii, imo waajoo ɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Jannginooɓe Tawreeta e Farisa'en ngaddani mo debbo nanngaaɗo e jeenu. Ɓe ndarni ɗum hakkunde jamaa oon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ɓe mbi'i Iisaa: —Moodibbo, debbo o wo nanngaaɗo ina jeena. ");
INSERT INTO fuhbkf_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Muusaa yamirii min ley Tawreeta min mbarda hono ɓeen rewɓe kaaƴe. Aan le, ɗume mbi'ataa? ");
INSERT INTO fuhbkf_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ɓe kaaldi nii faa ɓe tuufina mo, faa ɓe keɓa ko ɓe pelda mo. Iisaa kaa turii, ina diidira honndu muuɗum leydi. ");
INSERT INTO fuhbkf_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ɓe keddii iɓe ƴama mo. Ndeen Iisaa turtii, wi'i ɓe: —Neɗɗo mooɗon mo luttaay abada artoo limnude mo hayre. ");
INSERT INTO fuhbkf_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","O turii katin, imo diida e leydi. ");
INSERT INTO fuhbkf_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Nde ɓe nannoo ɗum ndeen, ɓe ndilliri gooto gooto. Nayeeɓe ɓeen fuu artii dillude faa heddii Iisaa tan e debbo oon na darii hakkunde taliyaare ɗoon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Iisaa turtii, wi'i mo: —Banndam debbo, toy felooɓe ma ɓeen ngoni? Fay gooto jukkaaki ma naa? ");
INSERT INTO fuhbkf_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","O jaabii, o wi'i: —Joomam, fay gooto. Iisaa wi'i mo: —Miin du, mi jukkataako ma. Yahu, taa luttaa katin. ");
INSERT INTO fuhbkf_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Iisaa waajii ɓe katin, wi'i: —Miin woni annoora adunaaru ndu. Jokkuɗo kam fuu heɓan annoora nguurndam, yahataa ley nimre. ");
INSERT INTO fuhbkf_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ndeen Farisa'en mbi'i mo: —Aɗa seedanoo hoore maa, ndelle seedaaku maa sellataa. ");
INSERT INTO fuhbkf_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Iisaa jaabii ɓe, wi'i: —Fay si ceedaniimi hoore am, seedaaku am wo goonga, sabo miɗo anndi ɗo ƴuurumi, miɗo anndi to njahammi du. Onon le, on anndaa ɗo ƴuurumi, on anndaa to njahammi. ");
INSERT INTO fuhbkf_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Onon, no njiiruɗon yimɓe noon carortoɗon ɗum'en. Miin kaa, mi sarataako fay gooto. ");
INSERT INTO fuhbkf_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Fay si miɗo saroo, sariya am wo goonga, sabo mi sarataako miin tan, Baabiiwo nulɗo kam oon ina wondi e am. ");
INSERT INTO fuhbkf_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ina winndaa e ley Tawreeta mooɗon: seedaaku yimɓe ɗiɗo wo goonga. ");
INSERT INTO fuhbkf_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Miin, miɗo seedanoo hoore am. Baabiiwo nulɗo kam oon du, ina seedanoo kam. ");
INSERT INTO fuhbkf_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ɓe mbi'i mo: —Toy Baaba maa oon woni? Iisaa jaabii, wi'i: —On anndaa kam miin, sakko Baaba am. Si oɗon anndunoo kam, on anndanno Baaba am du. ");
INSERT INTO fuhbkf_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Iisaa haali haalaaji ɗiin nde waajotonoo ley suudu dewal mawndu, nokku ɗo keesuwal sadakaaji ngaal woni ɗoon. Fay gooto nanngaay mo, sabo wakkati makko yottaaki tafon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Iisaa wi'i ɓe katin: —Inan miɗo dilla, de on piloto kam, ammaa on maaydan e hakkeeji mooɗon. On mbaawaa yaade to njahammi toon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ndeen Alhuudiyankooɓe mbi'i: —Ko o wi'i en mbaawaa yaade to o yahata toon, ɗum le, wo o bartoytooɗo naa? ");
INSERT INTO fuhbkf_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Iisaa wi'i ɓe: —Onon, wo ley njeyaɗon. Miin le, wo dow njeyaami. Onon, e adunaaru njeyaɗon, de miin kaa, mi jeyaaka e mayru. ");
INSERT INTO fuhbkf_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ɗum waɗi de mbiimi on: on maaydan e hakkeeji mon. Sabo si on ngoonɗinaay miin woni mo ngonumi oon, on maaydan e hakkeeji mon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ɓe mbi'i mo: —Aan wo a moy? Iisaa jaabii: —Ko mbi'unoomi on gilla arande ɗuum ngonumi. ");
INSERT INTO fuhbkf_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Miɗo joganii on ko heewi ko haaletee e ko saretee. Wooɗi Nulɗo kam oon wo goongante. Ko narrunoomi mo ɗuum kaalanammi yimɓe adunaaru. ");
INSERT INTO fuhbkf_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ɓe paamaay wo haala Baabiiwo o haalanta ɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ndeen Iisaa wi'i ɓe: —Nde Ɓii Neɗɗo toownaa fuu, ndeen paamoton miin woni mo ngonumi oon. On paaman du mi waɗirtaa fay huunde e hoore am, ammaa ko Baabiiwo anndini kam, wo ɗuum kaalammi. ");
INSERT INTO fuhbkf_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Nulɗo kam oon ina wondi e am, o yoppaay kam mi perwuɗo, sabo ko weli mo tan ngaɗammi wakkati fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Nde Iisaa haalannoo haalaaji ɗi ndeen, heewɓe ngoonɗinii ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ndeen Iisaa wi'i Alhuudiyankooɓe goonɗinɓe ɗum ɓeen: —Si oɗon keddii e konngol am, wo on taalibaaɓe am jaati. ");
INSERT INTO fuhbkf_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ndeen anndoton goonga. Goonga oon du rimɗinan on. ");
INSERT INTO fuhbkf_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ɓe njaabii mo: —Minen, min ƴuwdi Ibrahiima, abada fay gooto maraay min. Noy mbiirataa min ndimɗan? ");
INSERT INTO fuhbkf_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Iisaa jaabii ɓe, wi'i: —Goonga kaalanammi on: luttoowo fuu wo maccuɗo luttal. ");
INSERT INTO fuhbkf_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Maccuɗo tabitataa ley wuro, de ɓiɗɗo tabitan ley maggo faa abada. ");
INSERT INTO fuhbkf_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Si Ɓiɗɗo rimɗinii on, on laatoto rimɓe laaɓuɓe tal. ");
INSERT INTO fuhbkf_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Miɗo anndi on ƴuwdi Ibrahiima, ammaa oɗon piloo warude kam sabo waaju am naataay on. ");
INSERT INTO fuhbkf_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Miin, ko njiirumi Baaba am mbaajotoomi. Onon, ko narruɗon baaba mooɗon ngaɗoton. ");
INSERT INTO fuhbkf_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ɓe njaabii mo, ɓe mbi'i: —Ibrahiima woni baaba amin. Iisaa wi'i ɓe: —Si wo on ƴuwdi Ibrahiima fu on ngollan golle Ibrahiima. ");
INSERT INTO fuhbkf_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","De joonin oɗon piloo warude kam, miin kaalanɗo on goonga mo narrumi Laamɗo oon. Ibrahiima kaa waɗaayno hono ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Onon le, wo golle baaba mooɗon ngolloton. Ɓe mbi'i mo: —Minen, min nganaa jaali. Baaba gooto min njogii, kam woni Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Iisaa wi'i ɓe: —Si Laamɗo wonnoo baaba mooɗon fu, on njiɗanno kam, sabo to Laamɗo ƴuurumi, de ngarumi. Mi waddaay hoore am, wo kanko nuli kam. ");
INSERT INTO fuhbkf_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ko waɗi de on paamataa haala am? Wo sabo on mbaawaa nanude ko kaalammi ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Onon, Ibiliisa woni baaba mooɗon. Muuyɗe baaba mooɗon ngolloton. O gaɗoowo bar-ko'e gilla fuɗɗoode. O walaa e goonga sabo goonga walaa e makko. Si o fenii fu, jikku makko tan o waɗi, sabo wo o penoowo, wo o baaba fewre du. ");
INSERT INTO fuhbkf_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","De miin, saabe miɗo haala goonga waɗi de on ngoonɗinaay kam. ");
INSERT INTO fuhbkf_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Moy e mooɗon waawi felirde kam hakkeeji? Si mi haalii goonga, ko waɗi de on ngoonɗintaa kam? ");
INSERT INTO fuhbkf_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Neɗɗo Laamɗo hettintoo haala Laamɗo. Onon le, on kettintaako sabo on nganaa yimɓe Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Alhuudiyankooɓe mbi'i mo: —Wanaa min kaalii goonga ko min mbi'i a Samariyanke, a gonduɗo e ginnaaru naa? ");
INSERT INTO fuhbkf_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Iisaa jaabii, wi'i: —Mi wanaa gonduɗo e ginnaaru, miɗo teddina Baaba am. Onon, oɗon kuyfina kam. ");
INSERT INTO fuhbkf_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Miin, mi filantaako hoore am teddeengal. Ina woodi pilantooɗo kam ngal. Oon woni carotooɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Goonga kaalanammi on: neɗɗo fuu jokkuɗo konngol am maayataa abada. ");
INSERT INTO fuhbkf_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Alhuudiyankooɓe mbi'i mo: —Joonin kaa laaɓanii min a gonduɗo e ginnaaru. Ibrahiima e annabaaɓe fuu maayii, de aan kaa, aɗa wi'a neɗɗo fuu jokkuɗo konngol maa, meeɗataa ɗeɗɗere maayde. ");
INSERT INTO fuhbkf_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Yalla aɗa ɓuri baaba amin Ibrahiima naa? Oon le maayii, annabaaɓe du maayii. Ɗume cikkuɗaa ngonɗaa? ");
INSERT INTO fuhbkf_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Iisaa jaabii ɓe, wi'i: —Miin, si hoore am mawninammi, manngu am wo ɓolum. Baaba am mo mbi'oton Laamɗo mooɗon oon, kam mawninta kam. ");
INSERT INTO fuhbkf_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","On anndaa mo. Miin kaa, miɗo anndi mo. Si mi wi'ii mi anndaa mo, mi laatake penoowo hono mooɗon. Miɗo anndi mo, miɗo jokki konngol makko. ");
INSERT INTO fuhbkf_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Baaba mooɗon Ibrahiima ina seyorinoo yi'ude nyalaande am. O yi'ii nde, wooɗi o seyake. ");
INSERT INTO fuhbkf_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Alhuudiyankooɓe mbi'i mo: —Fay duuɓi capanɗe joy a heɓaay tafon, de a yi'ii Ibrahiima naa? ");
INSERT INTO fuhbkf_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Iisaa jaabii ɓe: —Goonga kaalanammi on: gilla Ibrahiima tagaaka, miin, miɗo woni. ");
INSERT INTO fuhbkf_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Nde Iisaa wi'unoo ɗum fu, ɓe kooƴi kaaƴe faa ɓe limna ɗum. Ammaa o uddii ley yimɓe, o yalti suudu dewal mawndu nduun. ");
INSERT INTO fuhbkf_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Nde Iisaa yahannoo ndeen yi'i gorko dimdaaɗo e mbumndam. ");
INSERT INTO fuhbkf_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Taalibaaɓe makko ƴami mo: —Moodibbo, moy lutti de o rimdaa e mbumndam, kanko naa saaraaɓe makko? ");
INSERT INTO fuhbkf_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Iisaa jaabii ɓe, wi'i: —Wanaa kanko lutti, wanaa saaraaɓe makko du. Ammaa ɗum waɗii faa baawɗe Laamɗo ɓanga e makko. ");
INSERT INTO fuhbkf_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ɓaawo nyalooma ina heddii, ina haani ngollen golle Nulɗo kam, sabo jemma waran nde fay gooto waawaa gollude. ");
INSERT INTO fuhbkf_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","E ley ko keddiimi e adunaaru ndu, miin woni annoora mayru. ");
INSERT INTO fuhbkf_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Nde o haalnoo ɗum ndeen, o tutti e leydi, o diibunduri tutte ɗeen e loope, o wuji e gite bumɗo oon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","O wi'i ɗum: —Yahu sulmowa luggere wi'eteende Silowam (maanaa majjum woni «Nulaaɗo»). O sulmowii, o warti imo yi'a. ");
INSERT INTO fuhbkf_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Hoddiiɓe makko, kamɓe e yi'annooɓe mo imo garbina ɓeen, mbi'i: —Yalla wanaa oo woni jooɗinooɗo ina garbina oon naa? ");
INSERT INTO fuhbkf_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Woɓɓe maɓɓe mbi'i: —Ɗum kanko! Woɓɓe du mbi'i: —Wanaa! Wo nanndi makko! Gorko oon e hoore muuɗum wi'i: —Wo miin jaati! ");
INSERT INTO fuhbkf_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ɓe mbi'i mo: —Noy mbumtirɗaa? ");
INSERT INTO fuhbkf_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","O jaabii: —Gorko bi'eteeɗo Iisaa diibunduri loope, wuji e gite am, wi'i kam mi yaha luggere Silowam mi sulmowoo, de culmowiimi, mbumtumi. ");
INSERT INTO fuhbkf_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ɓe mbi'i mo: —Toy gorko oon woni? O wi'i: —Mi anndaa. ");
INSERT INTO fuhbkf_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ndeen ɓe njaari bumnooɗo oon to Farisa'en. ");
INSERT INTO fuhbkf_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Nde Iisaa diibundurnoo loope de wumtini mo ndeen, wo nyalaande fowteteende. ");
INSERT INTO fuhbkf_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ndeen Farisa'en du ƴami mo: —Noy mbumtirɗaa? O wi'i ɓe: —O wujii loope e gite am, culmiimi de mbumtumi. ");
INSERT INTO fuhbkf_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Farisa'en woɓɓe mbi'i: —Gorko oon ƴuuraay to Laamɗo sabo o jokkaay yamiroore nyalaande fowteteende. Woɓɓe mbi'i: —Noy neɗɗo jom hakke waawiri waɗirde kaayeefiiji hono ɗi? Ndelle ɓe luuri dow majjum. ");
INSERT INTO fuhbkf_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Farisa'en ɓeen ƴami bumnooɗo oon katin: —Aan le, ɗume mbi'ataa dow makko, e ko o wumtini ma ɗuum? O jaabii ɓe, o wi'i: —Wo o annabaajo. ");
INSERT INTO fuhbkf_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ammaa e ɗuum fuu hooreeɓe Alhuudiyankooɓe ɓeen njaɓaay wo o bumnooɗo de o wumtinaa faa ɓe noddi saaraaɓe makko. ");
INSERT INTO fuhbkf_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ɓe ƴami ɗum'en: —Ooɗo wo ɓiɗɗo mooɗon naa? Mbiiɗon wo e mbumndam o rimdaa naa? Ndelle noy o wumtiri joonin? ");
INSERT INTO fuhbkf_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Saaraaɓe ɓeen njaabii, mbi'i: —Miɗen anndi o ɓii amin, e mbumndam du o rimdaa. ");
INSERT INTO fuhbkf_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ammaa no o wumtiri joonin, min anndaa. Min anndaa du moy wumtini mo. Kanko du o mawɗo, ƴamee mo! Imo waawi jaabanaade hoore makko. ");
INSERT INTO fuhbkf_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Saaraaɓe makko mbi'ii noon sabo iɓe kula hooreeɓe Alhuudiyankooɓe. Sabo dey, tawi hooreeɓe ɓeen ndewrii mbi'i neɗɗo fuu biiɗo Iisaa woni Almasiihu oon, riiwete wurtoo waajordu. ");
INSERT INTO fuhbkf_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ɗum waɗi de saaraaɓe makko ɓeen mbi'i: «O mawɗo, ƴamee mo!» ");
INSERT INTO fuhbkf_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Farisa'en nodditi bumnooɗo oon, mbi'i mo: —Teddin Laamɗo, haalu goonga! Minen kaa miɗen anndi gorko oon wo jom hakke. ");
INSERT INTO fuhbkf_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","O jaabii ɓe, o wi'i: —Si o jom hakke du, miin kaa, mi anndaa. Gootel tan anndumi: mi bumnooɗo, de joonin mi wumtii. ");
INSERT INTO fuhbkf_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ɓe mbi'i mo: —Ɗume o waɗi e maaɗa? Noy o wumtiniri ma? ");
INSERT INTO fuhbkf_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","O jaabii ɓe: —Mi haalaniino on ɗum, de on njaɓaay. Ko waɗi de oɗon njiɗi hettindaade ɗum katin? Yalla onon du, oɗon njiɗi laataade taalibaaɓe makko naa? ");
INSERT INTO fuhbkf_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ɓe njenni mo, de ɓe mbi'i mo: —Aan woni taalibaajo makko! Minen kaa, min taalibaaɓe Muusaa. ");
INSERT INTO fuhbkf_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Minen, miɗen anndi Laamɗo haaldii e Muusaa, de kanko kaa, min anndaa fay to o ƴuurata. ");
INSERT INTO fuhbkf_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Gorko oon jaabii ɓe, wi'i: —Hey, ko haaynii! O wumtinii kam. Onon, oɗon mbi'a on anndaa to o ƴuurata! ");
INSERT INTO fuhbkf_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Eɗen anndi Laamɗo jaabantaako luttuɓe, ammaa imo jaabanoo kulɗo mo, gaɗoowo muuyɗe makko. ");
INSERT INTO fuhbkf_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Abada nanaaka bumtinɗo dimdaaɗo e mbumndam. ");
INSERT INTO fuhbkf_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Si wanaa to Laamɗo gorko oon ƴuuri, o waawataa waɗude faa'e. ");
INSERT INTO fuhbkf_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ɓe mbi'i mo: —Aan le, a fuu ley hakkeeji ndimeɗaa! De aɗa waajoo min naa? Ɓe mburtini mo yaasin. ");
INSERT INTO fuhbkf_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Iisaa nani ɓe mburtinii mo, yi'i mo katin, ƴami mo: —Aan le, aɗa goonɗini Ɓii Neɗɗo oon naa? ");
INSERT INTO fuhbkf_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","O jaabii, o wi'i: —Joomam, moy woni oon faa mi goonɗina ɗum? ");
INSERT INTO fuhbkf_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Iisaa wi'i mo: —A yi'ii mo. Kaaldoowo e maaɗa oon woni kanko. ");
INSERT INTO fuhbkf_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","O wi'i: —Joomam, miɗo goonɗini! O sujidani ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ndeen Iisaa wi'i mo: —Saraade waddi kam ley adunaaru ndu, faa wumɓe nji'a, yi'ooɓe du mbuma. ");
INSERT INTO fuhbkf_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Farisa'en tawanooɓe ɗoon ɓeen, nani haala kaan, de ƴami mo: —Minen le, min wumɓe naa? ");
INSERT INTO fuhbkf_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Iisaa jaabii ɓe, wi'i: —Si on wumɓe, on ngalaano hakke. De ko mbiiɗon joonin oɗon nji'a ɗuum, hakke mooɗon heddake. ");
INSERT INTO fuhbkf_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","—Goonga kaalanammi on: neɗɗo fuu naatuɗo hoggo baali de naatiraay dammbugal wo gujjo, wo janoowo. ");
INSERT INTO fuhbkf_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ammaa naatirɗo dammbugal oon, kam woni duroowo baali ɗiin. ");
INSERT INTO fuhbkf_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Kayboowo dammbugal oon udditanan mo, baali ɗiin kettindoo daande makko. O noddira baali makko ɗiin, mbaalu fuu e innde muuɗum, o wurtina ɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Nde o wurtini ɗi fuu, o ardoto ɗi de ɗi njokka mo, sabo iɗi anndi daande makko. ");
INSERT INTO fuhbkf_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ɗi njokkataa janano, ɗi ndoggan ɗum sabo ɗi anndaa daande muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Iisaa banndani ɓe banndol ngol, de ɓe paamaay ko o muuyiri ngol. ");
INSERT INTO fuhbkf_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Iisaa wi'i ɓe katin: —Goonga kaalanammi on, miin woni dammbugal hoggo baali. ");
INSERT INTO fuhbkf_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Artiiɓe kam warude ɓeen fuu wo wuyɓe, wo yanooɓe, ammaa baali ɗiin kettindanaaki ɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Miin woni dammbugal. Neɗɗo fuu naatirɗo kam, hisan, naatan, yaltan, heɓan durdude. ");
INSERT INTO fuhbkf_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Gujjo warataa si wanaa faa wujja, hirsa, bonna. Miin kaa, mi warii faa yimɓe keɓa nguurndam, ɓe mbuura nguurndam kiɓɓuɗam ɗam fay huunde nyakaay. ");
INSERT INTO fuhbkf_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Miin woni duroowo lobbo. Duroowo lobbo woni kokkoowo yonki muuɗum saabe baali muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Adaaɗo durngo le, walaa ko wonani ɗum e dammuuli ɗiin. Si yi'ii suundu fu, yoppan ɗi dogga. Suundu nduun nannga ko nanngata, keddiiɗi ɗiin du caakoo. ");
INSERT INTO fuhbkf_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Adaaɗo durngo oon doggan yoppa ɗi sabo o joɓeteeɗo tan, o hillaaka e majji. ");
INSERT INTO fuhbkf_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Miin woni duroowo lobbo. Miɗo anndi baali am, baali am du ina anndi kam. ");
INSERT INTO fuhbkf_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Hono noon du Baabiiwo anndiri kam, miin du miɗo anndi ɗum. Mi hokkitiran yonki am saabe baali am ɗiin. ");
INSERT INTO fuhbkf_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Miɗo jogii baali goɗɗi katin ɗi ngalaa ley hoggo ngoon. Ɗiin du sanaa mi wadda ɗi. Ɗi kettindoo daande am, ɗi fuu ɗi laatoo coggal gootal, duroowo gooto. ");
INSERT INTO fuhbkf_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Baabiiwo ina yiɗi kam sabo mi hokkan yonki am, de sakitoo mi hewta ki katin. ");
INSERT INTO fuhbkf_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Fay gooto ittantaa kam ki. Miin e hoore am hokkitirta ki. Miɗo jogii baawɗe hokkitirde ki. Miɗo jogii baawɗe wartirde ki. Yamiroore nde ƴuuri to Baaba am. ");
INSERT INTO fuhbkf_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Haalaaji ɗiin ɓeydi waddundurde Alhuudiyankooɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Heewɓe maɓɓe ina mbi'a: —Wo o gonduɗo e ginnaaru, wo o kaaŋaaɗo. Ko waɗi de oɗon kettindanoo mo? ");
INSERT INTO fuhbkf_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","De woɓɓe du ina mbi'a: —Waajuuji ɗii le nganaa waajuuji gonduɗo e ginnaaru. Yalla ginnaaru ina waawi wumtinde bumɗo naa? ");
INSERT INTO fuhbkf_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Wakkati oon iidi miccinoori laamnugol suudu dewal mawndu waɗii Urusaliima. Ɗum hawrii e dabbunde. ");
INSERT INTO fuhbkf_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ɗo suudu dewal mawndu ɗoon, Iisaa ina yiiltoo ley danki Suleymaana kiin. ");
INSERT INTO fuhbkf_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ndeen Alhuudiyankooɓe piilii mo, mbi'i mo: —Faa ndey ittantaa min wemmbere? Haalan min faa laaɓa, aan woni Almasiihu naa? ");
INSERT INTO fuhbkf_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Iisaa jaabii ɓe: —Mi haalanii on, de on ngoonɗinaay. Golleeji ɗi ngollirmi e innde Baaba am ɗiin, kanji ceedantoo kam. ");
INSERT INTO fuhbkf_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Onon le, on ngoonɗinaay sabo on nganaa baali am. ");
INSERT INTO fuhbkf_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Baali am ina kettindoo daande am. Miɗo anndi ɗi, iɗi njokka kam. ");
INSERT INTO fuhbkf_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Miɗo hokka ɗi nguurndam nduumiiɗam, ɗi mbaatataa abada. Fay gooto ittataa ɗi e junngo am. ");
INSERT INTO fuhbkf_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Baabiiwo kokkuɗo kam ɗi oon ɓuri huunde fuu teddude. Fay gooto waawaa ittude ɗi e junngo Baaba am. ");
INSERT INTO fuhbkf_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Miin e Baabiiwo, wo min gootum. ");
INSERT INTO fuhbkf_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Alhuudiyankooɓe kooƴi kaaƴe katin faa paɗɗa mo. ");
INSERT INTO fuhbkf_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Iisaa wi'i ɓe: —Mi gollii yeeso mooɗon golleeji lobbi keewɗi ƴuuruɗi e Baabiiwo. E ley golleeji ɗiin, saabe oye e majji paɗɗirton kam kaaƴe? ");
INSERT INTO fuhbkf_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Alhuudiyankooɓe ɓeen njaabii mo: —Wanaa saabe golleeji lobbi min paɗɗirte kaaƴe, de wo saabe ko mbonkotoɗaa Laamɗo ɗuum. Aan wo a neɗɗo, de a waɗii hoore maa a Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Iisaa jaabii ɓe: —Yalla winndaaka ley Dewtere mon toon: Laamɗo wi'ii «onon on laamɗo'en»? ");
INSERT INTO fuhbkf_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Laamɗo noddirii ɓe haaldi ɓeen laamɗo'en. Ko Binndi ɗiin mbi'i ɗuum sottataa. ");
INSERT INTO fuhbkf_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Baabiiwo suɓii kam, seni kam de nuli kam e adunaaru ndu. Ndelle noy mbiiroton mi mbonkake Laamɗo saabe ko mbiimi mi Ɓii Laamɗo? ");
INSERT INTO fuhbkf_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Si mi gollaay golleeji Baaba am, taa ngoonɗinee kam. ");
INSERT INTO fuhbkf_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","De si miɗo golla ɗi, fay si on ngoonɗintaa kam, ngoonɗinee golleeji ɗi faa anndon, faa paamon Baabiiwo ina woni e am, miin du miɗo woni e muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ɓe pilii nanngude mo katin de o hisi e juuɗe maɓɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","O yehi gere ooto gooruwol Urdun nokku ɗo Yaayaa lootannoo lootagal batisima arande ɗoon katin, o ɓooyti toon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Yimɓe heewɓe ngari to makko, mbi'i: —Yaayaa waɗaay maande haayniinde fay wootere. De ko o haali e gorko oon ɗuum fuu goonɗii. ");
INSERT INTO fuhbkf_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Yimɓe heewɓe ngoonɗini Iisaa toon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Gorko nyawɗo bi'eteeɗo Laajaru ina woni wuro Baytaniya, kam e banndiraaɓe muuɗum rewɓe Mariyama e Marta. ");
INSERT INTO fuhbkf_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mariyama oon woni joornooɗo nebbam uurɗam dow Joomiiwo de mooytiri koyɗe makko sukundu muuɗum. Laajaru nyawɗo oon wo sakiike makko gorko. ");
INSERT INTO fuhbkf_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Banndiraaɓe makko rewɓe ɓeen neli e Iisaa, mbi'i: —Joomii amin, yigoo maa mo korsinɗaa oon nyawii. ");
INSERT INTO fuhbkf_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Nde Iisaa nannoo ɗum ndeen, wi'i: —Nyawu ngu wanaa nyawu saate. Nyawu ngu wo tabintinoowu manngu Laamɗo, faa Ɓii Laamɗo mawninee saabe maggu. ");
INSERT INTO fuhbkf_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Iisaa ina horsini Laajaru e banndiraaɓe muuɗum rewɓe, Marta e Mariyama. ");
INSERT INTO fuhbkf_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ko o nani Laajaru sellaa ɗuum fu, haɗaay mo jooɗaade ɗo o wonnoo ɗoon faa waɗi balɗe ɗiɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Caggal ɗuum, o wi'i taalibaaɓe makko: —En pornyoo Yahuudiya! ");
INSERT INTO fuhbkf_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Taalibaaɓe ɓeen njaabii mo, mbi'i: —Moodibbo, ɓooyaa fey ko Alhuudiyankooɓe pilii wardude ma kaaƴe toon, de a fornyoto toon katin naa? ");
INSERT INTO fuhbkf_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Iisaa jaabii, wi'i: —Wanaa wakkatiiji sappo e ɗiɗi ngoni ley nyalooma naa? Si neɗɗo ina yaha nyalooma fu, fergataako sabo ina yi'a annoora adunaaru ndu. ");
INSERT INTO fuhbkf_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ammaa si neɗɗo ina yaha jemma fu, fergoto sabo annoora walaa e muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Gaɗa o haalii haalaaji ɗiin, o wi'i ɓe: —Yigoo men Laajaru ɗaanake, mi yahan mi findinowa mo. ");
INSERT INTO fuhbkf_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Taalibaaɓe ɓeen mbi'i: —Joomii amin, si tawii wo o ɗaani ni, o daɗan. ");
INSERT INTO fuhbkf_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ammaa wo haala maayde Laajaru o haali. Kamɓe ɓe miilii wo haala ɗoyngol o haali. ");
INSERT INTO fuhbkf_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Iisaa laaɓinani ɓe: —Laajaru heddaaki! ");
INSERT INTO fuhbkf_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Mi seyorake saabe mooɗon ko mi tawaaka toon ɗuum faa ngoonɗinon. Wooɗi jonkaa, en njaha to makko. ");
INSERT INTO fuhbkf_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ndeen Tomaa noddirteeɗo Funereejo oon wi'i taalibaaɓe woɓɓe ɓeen: —En njaada e Joomii en enen du faa maayden e muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Nde Iisaa yottinoo toon fu, tawi waɗii balɗe nay ko Laajaru uwiraa. ");
INSERT INTO fuhbkf_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Hakkunde Baytaniya e Urusaliima ɓuraa hono kilooji tati. ");
INSERT INTO fuhbkf_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Alhuudiyankooɓe heewɓe ngari to Mariyama e Marta faa mbaaltina ɓerɗe muɓɓen e maayde sakiike muɓɓen. ");
INSERT INTO fuhbkf_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Nde Marta nannoo Iisaa ina wara ndeen, yehi jakkitowii ɗum. Mariyama kaa heddii ley suudu toon na jooɗii. ");
INSERT INTO fuhbkf_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta wi'i Iisaa: —Joomam, sini aɗa wonnoo ɗo, minyam gorko oon maayataano. ");
INSERT INTO fuhbkf_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","De fay joonin du miɗo anndi huunde fuu ko ŋaariɗaa Laamɗo, waɗante. ");
INSERT INTO fuhbkf_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Iisaa wi'i mo: —Minya gorko oon ummitoto. ");
INSERT INTO fuhbkf_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta wi'i: —Miɗo anndi o ummitoto nyannde ummital, nyalaande sakitotoonde. ");
INSERT INTO fuhbkf_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Iisaa wi'i mo: —Miin woni ummital, miin woni nguurndam. Neɗɗo fuu goonɗinɗo kam, fay si maayi, wuuran. ");
INSERT INTO fuhbkf_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Goonɗinɗo kam de heɓi nguurndam saabe am fu, maayataa abada. Aɗa goonɗini ɗum naa? ");
INSERT INTO fuhbkf_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","O jaabii, o wi'i: —Ayyo Joomam! Miɗo goonɗini aan woni Almasiihu Ɓii Laamɗo bi'anooɗo waran ley adunaaru ndu oon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Nde Marta haalnoo ɗum fu, yehi noddowi minyum Mariyama, haalani ɗum, wi'i: —Moodibbo warii, imo nodde. ");
INSERT INTO fuhbkf_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Nde Mariyama nannoo ɗum ndeen, henyii law, nootowii. ");
INSERT INTO fuhbkf_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Tawi ɗum fuu Iisaa naataayno wuro ngoon tafon. Imo heddii ɗo Marta jakkitinoo mo ɗoon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Alhuudiyankooɓe ina ngondi e Mariyama ley suudu, ina mbaaltina ɓernde muuɗum. Ɓe nji'i o gurbitii, o yalti. Ɓe njokki mo. Ɓe miilii o woyowan dow saabeere toon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mariyama yottii ɗo Iisaa woni ɗoon, yi'i mo tan, hippii ɗakkol koyɗe makko, wi'i mo: —Joomam, sini aɗa wonnoo ɗo, minyam gorko oon maayataano. ");
INSERT INTO fuhbkf_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Nde Iisaa yiinoo Mariyama e Alhuudiyankooɓe wonduɓe e muuɗum ɓeen ina mboya ndeen, ɓernde muuɗum hecciɗi sanne, torrii sanne. ");
INSERT INTO fuhbkf_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","O wi'i: —Toy ndesuɗon mo? Ɓe njaabii: —Joomii amin, war ndaar! ");
INSERT INTO fuhbkf_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Iisaa woyi. ");
INSERT INTO fuhbkf_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Alhuudiyankooɓe ɓeen mbi'i: —Ndaaree no o foti horsinirde mo. ");
INSERT INTO fuhbkf_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Woɓɓe maɓɓe mbi'i: —Imo woodunoo baawɗe wumtinde bumɗo, de o waawaa haɗude Laajaru maayde naa? ");
INSERT INTO fuhbkf_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ɓernde Iisaa hecciɗi katin, yehi tiimoyde saabeere ndeen. Saabeere ndeen wo loho uddiraako hayre. ");
INSERT INTO fuhbkf_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Iisaa wi'i: —Ittee hayre ndeen! Marta, sakiike maayɗo oon, wi'i mo: —Joomam, tawan o luuɓii joonin, sabo hannden woni balɗe nay ko o wattiraa toon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Iisaa jaabii mo: —Yalla mi wi'aay ma, si a goonɗinii, a yi'an manngu Laamɗo? ");
INSERT INTO fuhbkf_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ɓe itti hayre ndeen. Iisaa tiggitii kammu, wi'i: —Baabiiwo, miɗo yettire ko njaabaniɗaa kam ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Miin kaa, miɗo anndi nyannde fuu aɗa jaabanoo kam. Ammaa wo saabe yimɓe fiiliiɓe kam ɓeen waɗi de kaaldirmi ni, faa ɓe ngoonɗina aan nuli kam. ");
INSERT INTO fuhbkf_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Caggal haalaaji ɗiin, o ƴeewnii semmbe, o wi'i: —Laajaru, wurta yaasin! ");
INSERT INTO fuhbkf_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Maayɗo oon wurtii, juuɗe muuɗum e koyɗe mum ina piilaa leppi, yeeso muuɗum du ina suddii. Iisaa wi'i ɓe: —Kaɓɓitee mo, njoppon mo o yaha! ");
INSERT INTO fuhbkf_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Heewɓe e Alhuudiyankooɓe warnooɓe to Mariyama ɓeen nji'i ko Iisaa waɗi ɗuum, de ngoonɗini ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ammaa woɓɓe maɓɓe njehi to Farisa'en, kaaltani ɗum'en ko Iisaa waɗi ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ndeen Farisa'en e hooreeɓe almaami'en kawrunduri waalde Saahiiɓe ndeen, mbi'i: —Gorko o ina waɗa kaayeefiiji keewɗi. Noy ngaɗeten? ");
INSERT INTO fuhbkf_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Si en njoppirii mo nii fu, jamaa oon fuu goonɗinan mo. Ndeen kaa, Romankooɓe ngaran mbonna nokku meeɗen ceniiɗo e lenyol meeɗen ngol. ");
INSERT INTO fuhbkf_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Gooto maɓɓe bi'eteeɗo Kayafas, laatiiɗo Almaami Mawɗo e hitaande ndeen, wi'i ɓe: —Onon kaa on anndaa fay huunde. ");
INSERT INTO fuhbkf_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","On anndaa neɗɗo gooto maayana yimɓe fuu ɓuri wooɗude e meeɗen diina lenyol meeɗen fuu halka. ");
INSERT INTO fuhbkf_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Tawi ko o haali ɗuum ƴuuraay e hoore makko, ammaa saabe wo o Almaami Mawɗo hitaande ndeen, o sappake sanaa Iisaa maayana lenyol ngool. ");
INSERT INTO fuhbkf_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","De wanaa lenyol ngool tan o maayanta. Ko o maayanta dey wo ɓiɓɓe Laamɗo sankitiiɓe ɓeen fuu faa o hawrundura ɗum'en laatoo gootum. ");
INSERT INTO fuhbkf_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Gilla nyalooma oon, ɓe ndawridi faa ɓe mbara mo. ");
INSERT INTO fuhbkf_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ɗum waɗi de Iisaa seli yiiltaade hakkunde Alhuudiyankooɓe. O ƴuwi ɗo o wonnoo ɗoon, o yehi ngalluure wi'eteende Efrayim hettunde e ladde. O jooɗodii toon e taalibaaɓe makko. ");
INSERT INTO fuhbkf_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Tawi iidi Alhuudiyankooɓe mbi'eteendi Faltagol ndiin ɓadake. Heewɓe e yimɓe leydi ndiin njehi Urusaliima faa laamna ko'e muɓɓen gilla iidi ndiin yottaaki. ");
INSERT INTO fuhbkf_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Iɓe piloo Iisaa. Iɓe keddii ley suudu dewal mawndu nduun, iɓe kaalda, iɓe mbi'a: —Oɗon miiloo o waran e iidi ndiin naa on miilaaki? ");
INSERT INTO fuhbkf_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Tawi hooreeɓe almaami'en e Farisa'en njamiriino neɗɗo fuu annduɗo to o woni haala faa o nanngee. ");
INSERT INTO fuhbkf_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Balɗe jeegom fadde iidi Faltagol yottaade, Iisaa yehi Baytaniya ɗo Laajaru mo o iirtinnoo e maayde oon jeyaa ɗoon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ɓe ndefani mo nyaamdu ɗoon. Marta gollani ɓe, Laajaru du wo gooto e nyaamdooɓe e Iisaa ɓeen. ");
INSERT INTO fuhbkf_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ndeen Mariyama hooƴi feccere liitere nebbam laaɓuɗam, uurɗam, tiiɗuɗam coggu, joori ɗam dow koyɗe Iisaa, mooytiri ɗe sukundu muuɗum. Suudu nduun fuu heewi uurngol nebbam ɗaam. ");
INSERT INTO fuhbkf_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Gooto e taalibaaɓe Iisaa ɓeen, ɗum woni Yahuuda Isikariyotto jambotooɗo mo oon, wi'i: ");
INSERT INTO fuhbkf_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—Ko waɗi de nebbam ɗam sonnaaka buuɗi cardi keme tati, hokkee talkaaɓe? ");
INSERT INTO fuhbkf_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","O wiiraay noon saabe imo yurmoo talkaaɓe, ammaa saabe wo o gujjo waɗi de o wi'i noon. Kanko woni kawjotooɗo dannga jawdi maɓɓe, imo woowi wujjude ko resaa ley toon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Iisaa wi'i: —Celee debbo o. O resii ɗam faa nyannde ngatteteemi e saabeere. ");
INSERT INTO fuhbkf_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Si goonga, talkaaɓe ina tawdee e mooɗon wakkati fuu. De miin kaa, mi tawdataake e mooɗon wakkati fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Alhuudiyankooɓe heewɓe paami Iisaa ina woni Baytaniya, njehi toon. Wanaa saabe Iisaa tan ɓe njahani toon, wo faa ɓe nji'a Laajaru iirtinaaɗo oon du. ");
INSERT INTO fuhbkf_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ndeen hooreeɓe almaami'en ndawridi mbaran Laajaru du, ");
INSERT INTO fuhbkf_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","sabo Alhuudiyankooɓe heewɓe na cela jokkude ɓe ina ngoonɗina Iisaa saabe Laajaru. ");
INSERT INTO fuhbkf_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Jaango majjum, jamaa keewɗo wari hawrude e iidi ndiin nani Iisaa wo garoowo Urusaliima. ");
INSERT INTO fuhbkf_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ɓe kooƴi licce tamarooje, ɓe njakkitowii mo. Iɓe ƴeewnoo, iɓe mbi'a: —Jettooje e barke ngoodanii garɗo e dow innde Joomiraaɗo oon! Jettooje ngoodanii mo, kanko kaananke Israa'iila! ");
INSERT INTO fuhbkf_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Iisaa heɓi molel araawa, waɗɗii ngel. Ɗum foti e ko Binndi ɗiin mbi'i: ");
INSERT INTO fuhbkf_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","«Taa kulee onon yimɓe ngalluure Siyona! Ndaaree, kaananke mooɗon ina wara, ina waɗɗii molel araawa.» ");
INSERT INTO fuhbkf_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Wakkati oon taalibaaɓe makko ɓeen paamaayno ko ɗum woni. Ammaa gaɗa Iisaa teddinaama, ɓe miccitii ko sappanoo e dow makko ley Binndi ɗiin ɗuum e no ɗum fuu ɗum hawriri e ko yimɓe ɓeen ngaɗani mo. ");
INSERT INTO fuhbkf_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Jamaa tawdanooɗo e Iisaa nde noddunoo Laajaru e ley saabeere de iirtinii ɗum ndeen, kam'en du ina kumpita yimɓe kabaaru oon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ɗuum waɗi de yimɓe heewɓe njehi njakkitowii mo sabo ɓe nanii o waɗii maande haayniinde ndeen. ");
INSERT INTO fuhbkf_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ndeen Farisa'en mbi'unduri: —On nji'ii, walaa fuu ko mbaawanɗen mo. Ndaaree no aduna oo fuu jokkiri mo. ");
INSERT INTO fuhbkf_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Wooɗi, ina woodi ƴuuruɓe leydi Geres tawaaɓe hakkunde warɓe Urusaliima faa ndewa Laamɗo ley balɗe iidi ɗeen. ");
INSERT INTO fuhbkf_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ɓe ɓattitii Filipu jeyaaɗo Baytisayda ley leydi Galili, ɓe mbi'i ɗum: —Joomii amin, miɗen njiɗi yi'ude Iisaa. ");
INSERT INTO fuhbkf_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filipu yehi haalanowi Andire. Ɓe njottinowi haala kaan Iisaa. ");
INSERT INTO fuhbkf_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Iisaa jaabii ɓe, wi'i: —Wakkati mo Laamɗo hollata teddeengal Ɓii Neɗɗo oon yottake. ");
INSERT INTO fuhbkf_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Goonga kaalanammi on: si wabbere alkama uwake e leydi de nyolaay fu, heddoto wo wabbere wootere. Ammaa si nde uwake e leydi nde nyolii fu, nde riman faa heewa. ");
INSERT INTO fuhbkf_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Neɗɗo fuu jiɗɗo yonki muuɗum, mursan ki, ammaa jeebiiɗo yonki mum e adunaaru ndu, damman ki, heɓan nguurndam nduumiiɗam. ");
INSERT INTO fuhbkf_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Si neɗɗo ina yiɗi gollande kam fuu, jokka kam. Ɗo ngonumi fuu, ɗoon golloowo am du wonata. Baabiiwo teddinan gollanoowo kam. ");
INSERT INTO fuhbkf_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","—Joonin ɓernde am torrake. Ɗume mbi'ammi? Mi wi'an Abba hisinam e wakkati o naa? Mi waawaa wi'ude noon sabo wakkati o ni waddi kam. ");
INSERT INTO fuhbkf_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Abba, mawnin innde maa. Ndeen daande ƴuuri dow kammu wi'i: —Mi mawninii nde, mi mawninan nde katin. ");
INSERT INTO fuhbkf_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Nde yimɓe darinooɓe ɗoon ɓeen nannoo daande ndeen, mbi'i ɗum wo riggaango kammu. Woɓɓe mbi'i: —Maleyka haaldi e makko! ");
INSERT INTO fuhbkf_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Iisaa wi'i ɓe: —Wanaa saabe am daande ndeen wardi, wo saabe mooɗon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Joonin adunaaru ndu sarete. Joonin laamiiɗo adunaaru bonɗo oon faɗɗete yaasin. ");
INSERT INTO fuhbkf_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Miin le, si mi toownaama e leydi ndi, mi fooɗan yimɓe fuu ngara to am. ");
INSERT INTO fuhbkf_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Tawi haalaaji ɗiin o sapporii no o maayrata. ");
INSERT INTO fuhbkf_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Yimɓe ɓeen njaabii mo, mbi'i: —Tawreeta oon anndinii min Almasiihu wo duumotooɗo. Noy aan mbiirataa sanaa Ɓii Neɗɗo oon toownee? Moy woni Ɓii Neɗɗo oon? ");
INSERT INTO fuhbkf_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Iisaa jaabii ɓe, wi'i: —Annoora ina wondi e mooɗon wakkati seeɗa tafon. Njahon gilla annoora ina heddii e mooɗon, taa nimre hippoo on. Jahoowo ley nimre anndaa ɗo yahata. ");
INSERT INTO fuhbkf_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ngoonɗinee annoora gilla imo wondi e mooɗon yalla oɗon laatoo ɓiɓɓe annoora. Iisaa haalu ɗum tan, yehi suuɗowii ɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Maandeeji kaayniiɗi ɗi o waɗi yeeso maɓɓe ɗiin fuu, waɗaay de ɓe ngoonɗini mo, ");
INSERT INTO fuhbkf_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","faa haala annabi Esaaya kaan tabita: «Joomiraaɗo, moy goonɗini waaju amin oon? Moy ɓanginanaa baawɗe Joomiraaɗo?» ");
INSERT INTO fuhbkf_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ɓe mbaawaano goonɗinde, sabo Esaaya wi'iino du: ");
INSERT INTO fuhbkf_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","«Laamɗo wumnii gite maɓɓe, yoornii ɓerɗe maɓɓe, taa gite maɓɓe nji'a, taa ɓerɗe maɓɓe paama, taa ɓe tuuba, de o danna ɓe.» ");
INSERT INTO fuhbkf_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Esaaya wi'ii ɗum nde yiinoo darja Iisaa, de haali haala makko. ");
INSERT INTO fuhbkf_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ammaa ɗum fuu e laataade, hooreeɓe Alhuudiyankooɓe heewɓe ngoonɗinii Iisaa. De wo saabe Farisa'en waɗi de ɓe kuli hollude ɓe ngoonɗinii taa ɓe mburtinee ley waajordu. ");
INSERT INTO fuhbkf_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Sabo yimɓe mana ɓe, ɗum ɓurani ɓe Laamɗo mana ɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Iisaa ƴeewnii, wi'i: —Goonɗinɗo kam, wanaa miin tan goonɗini, ammaa goonɗinii Nulɗo kam oon du. ");
INSERT INTO fuhbkf_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Neɗɗo fuu jiiɗo kam, yi'ii Nulɗo kam oon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Miin, mi warii ley adunaaru ndu wo mi annoora, faa goonɗinɗo kam fuu taa heddoo ley nimre. ");
INSERT INTO fuhbkf_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Si neɗɗo nanii waaju am de jokkaay ɗum fu, wanaa miin sarotoo ɗum. Sabo mi waraay faa mi saroo adunaaru, ammaa wo faa mi hisina ndu ngardumi. ");
INSERT INTO fuhbkf_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Caliiɗo kam de jaɓaay waajuuji am fu, ina jogii carotooɗo. Haala ka kaalumi kaan sarotoo ɗum nyalaande sakitotoonde. ");
INSERT INTO fuhbkf_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Sabo ko kaalumi ɗuum ƴuuraay e am. Baabiiwo nulɗo kam oon hokki kam yamiroore ko kaalammi e ko mbaajotoomi. ");
INSERT INTO fuhbkf_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Miɗo anndi yamiroore makko ina hokka nguurndam nduumiiɗam. Ɗuum waɗi de ko kaalumi ɗuum fuu, wo ko Baabiiwo wi'i kam mi haala. ");
INSERT INTO fuhbkf_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Gilla iidi Faltagol yottaaki, Iisaa ina anndi wakkati mo dillata adunaaru faa yeccoo to Baabiiwo oon warii. To adunaaru ga imo yiɗi yimɓe makko, imo yiɗi ɓe kaddi njinngu fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Wakkati mo ɓe kiirtotoo oon, Ibiliisa watti e ɓernde Yahuuda ɓii Simon Isikariyotto jambaade mo. ");
INSERT INTO fuhbkf_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Iisaa na anndi Baabiiwo wattii huunde fuu e junngo muuɗum, ina anndi to Laamɗo ƴuuri, to Laamɗo yeccotoo du. ");
INSERT INTO fuhbkf_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","O ummii e hiraande ndeen, o ɓortii saaya makko, o hooƴi gudel, o fiili e makko. ");
INSERT INTO fuhbkf_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ndeen o wayli ndiyam e kaakol lootorkol, o naati e lootude koyɗe taalibaaɓe makko, imo yiggira ɗe gudel ngel o fiilii ngeel. ");
INSERT INTO fuhbkf_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Nde o yottinoo Simon Piyeer ndeen, wi'i mo: —Joomam, aan lootata koyɗe am naa? ");
INSERT INTO fuhbkf_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Iisaa jaabii mo, wi'i: —A faamaay ko ngaɗammi ɗuum tafon, de a faamowan caggal joonin. ");
INSERT INTO fuhbkf_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Piyeer wi'i mo: —A lootataa koyɗe am abada! Iisaa jaabii mo, wi'i: —Si mi lootanaay ma koyɗe maa fu, a walaa ngeɗu to am. ");
INSERT INTO fuhbkf_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simon Piyeer wi'i mo: —Joomam! Si wo noon, taa haaɗu e koyɗe am tan, lootu juuɗe am e hoore am du. ");
INSERT INTO fuhbkf_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Iisaa wi'i mo: —Lootiiɗo fuu wo laaɓuɗo. Walaa ko lootee si wanaa koyɗe muuɗum tan. Onon on laaɓuɓe, de wanaa on fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Tawi imo anndi jambotooɗo mo oon. Ɗum waɗi de o wi'i wanaa on fuu ngoni laaɓuɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Nde Iisaa lootunoo koyɗe maɓɓe ndeen, hooƴi saaya muuɗum, ɓornii, jooɗii katin, wi'i ɓe: —On paamii ko ngaɗumi on ɗuum naa? ");
INSERT INTO fuhbkf_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Oɗon noddira kam «Moodibbo», oɗon noddira kam «Joomam». Ko mbi'oton ɗuum wo goonga, sabo ɗuum ngonumi. ");
INSERT INTO fuhbkf_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ndelle, miin Joomii on, miin Moodibbo, mi lootii koyɗe mon, tilay onon du lootunduron koyɗe. ");
INSERT INTO fuhbkf_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ko ngaɗumi on ɗuum wo tindinoore faa onon du, ngaɗunduron hono ko ngaɗumi on ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Goonga kaalanammi on: maccuɗo ɓuraa joomum teddude, nulaaɗo du ɓuraa nulɗo ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Joonin kaa on paamii ɗum. Sini on njokkirii noon fu, barke na woodanii on. ");
INSERT INTO fuhbkf_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Wanaa haala mon on fuu kaalumi. Miɗo anndi ɓe cuɓiimi ɓeen, de sanaa ko Binndi ɗiin mbi'i ɗuum tabita: «Nyaamduɗo e am oon, kam latiri kam teppere muuɗum.» ");
INSERT INTO fuhbkf_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Gilla joonin miɗo haalana on ɗum, fadde majjum e yottaade, faa nde ɗum yottii fuu, ngoonɗinon miin woni mo ngonumi. ");
INSERT INTO fuhbkf_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Goonga kaalanammi on: neɗɗo fuu jaɓɓiiɗo mo nulumi, jaɓɓake kam. Neɗɗo fuu jaɓɓiiɗo kam, jaɓɓake Nulɗo kam oon du. ");
INSERT INTO fuhbkf_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Caggal Iisaa haalii haalaaji ɗi fu, ɓernde muuɗum metti sanne, wi'i: —Goonga kaalanammi on: gooto mooɗon jamboto kam. ");
INSERT INTO fuhbkf_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Taalibaaɓe ɓeen ƴeewunduri. Ɓe paamaay mo o haalata haala mum. ");
INSERT INTO fuhbkf_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Gooto e taalibaaɓe ɓeen, mo Iisaa horsini oon, ina jooɗii ɗakkol muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simon Piyeer tamƴani mo gite o ƴama Iisaa haala moy haalata. ");
INSERT INTO fuhbkf_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Taalibbo oon wahii ɗakkol makko, wi'i: —Joomam, ɗum wo moye mbi'ataa? ");
INSERT INTO fuhbkf_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Iisaa jaabii, wi'i: —Mo kokkammi lonngere nde cuuwammi nde oon. O suuwi nde, o hokki Yahuuda ɓii Simon Isikariyotto oon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Nde Yahuuda jaɓunoo lonngere ndeen, Seyɗaani naati ɗum. Iisaa wi'i mo: —Waɗu ko ngaɗataa ɗuum law! ");
INSERT INTO fuhbkf_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Tawi fay gooto e jooɗiiɓe ɗoon ɓeen faamaay ko Iisaa haalani mo ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Sabo ko Yahuuda tiigii dannga ceede maɓɓe ɗuum, yoga miilii Iisaa wi'i o somonowoo iidi, naa danya ko o hokki talkaaɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Nde Yahuuda nanngunoo lonngere ndeen fu, yalti wakkati oon pay. Wo ɗum jemma. ");
INSERT INTO fuhbkf_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Nde Yahuuda wurtinoo ndeen, Iisaa wi'i: —Joonin Ɓii Neɗɗo teddinaama, Laamɗo du teddiniraama saabe makko. ");
INSERT INTO fuhbkf_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Si Laamɗo teddiniraama saabe makko, kam du teddinan mo e hoore muuɗum, teddinan mo law. ");
INSERT INTO fuhbkf_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Sukaaɓe am, miɗo wondi e mooɗon seeɗa tafon. On piloto kam. Miɗo wi'a on joonin hono ko mbi'unoomi Alhuudiyankooɓe: on mbaawaa yaade to njahammi toon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Miɗo hokka on yamiroore heyre: njiɗunduree! Hono no njiɗirmi on ni, onon du njiɗunduron noon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Wo noon yimɓe fuu annditirta wo on taalibaaɓe am, ko njiɗundurɗon ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simon Piyeer wi'i mo: —Joomam, toy njahataa? Iisaa jaabii mo: —To njahammi joonin toon, a waawaa jokkude kam. De caggal joonin a jokkowan kam! ");
INSERT INTO fuhbkf_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Piyeer wi'i mo: —Joomam, ko waɗi de mi waawaa jokkude ma joonin? Yonki am kokkitirammi saabe maaɗa. ");
INSERT INTO fuhbkf_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Iisaa jaabii mo: —Yalla a hokkitiran yonki maa saabe am naa? Goonga kaalanammaami: fadde ndontoori e joggude a wi'an a anndaa kam kile tati. ");
INSERT INTO fuhbkf_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Iisaa wi'i taalibaaɓe muuɗum ɓeen: —Taa umminee hakkillooji mon. Ngoonɗinee Laamɗo, ngoonɗinee kam miin du. ");
INSERT INTO fuhbkf_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Cuuɗi keewɗi ina ngoni ley wuro Baaba am. Si ɗum wanaano goonga mi haalantaa on ɗum. Mi yahan, mi moƴƴinanowa on nokku toon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ndelle, si mi moƴƴinanowii on nokku, mi wartan katin mi hooƴa on faa onon du ngonon to ngonammi toon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Oɗon anndi laawol njahoowol to njahammi toon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomaa wi'i mo: —Joomii amin, min anndaa to njahataa, noy min anndirta laawol muuɗum? ");
INSERT INTO fuhbkf_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Iisaa jaabii mo: —Miin woni laawol, miin woni goonga, miin woni nguurndam. Fay gooto waawaa yahude to Baabiiwo si rewaay to am. ");
INSERT INTO fuhbkf_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Si oɗon anndi kam, on anndan Baaba am oon du. Gilla joonin oɗon anndi mo, on nji'ii mo du. ");
INSERT INTO fuhbkf_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filipu wi'i mo: —Joomii amin, hollu min Baabiiwo, ɗuum ina heƴa min. ");
INSERT INTO fuhbkf_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Iisaa wi'i mo: —Filipu, no ngondirmi e mooɗon faa ɓooyi nii fuu, de faa hannden a anndaay kam naa? Jiiɗo kam fuu, yi'ii Baabiiwo. Noy mbiirataa: «Hollu min Baabiiwo»? ");
INSERT INTO fuhbkf_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Yalla a goonɗinaay miɗo woni e Baabiiwo, Baabiiwo du ina woni e am naa? Waajuuji ɗi mbaajiimi on ɗiin fuu, ƴuuraay e hoore am. Wo Baabiiwo gonɗo e am oon gollata golle muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ngoonɗinee kam ko mbiimi miɗo woni ley Baabiiwo, Baabiiwo du ina woni ley am. Fay si on ngoonɗinaay haala ka, ngoonɗiniron kam saabe golleeji ɗiin. ");
INSERT INTO fuhbkf_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Goonga kaalanammi on: neɗɗo fuu goonɗinɗo kam, kam du gollan golleeji ɗi ngollammi ɗiin, gollan ko ɓuri ɗi, sabo mi yahan to Baaba am. ");
INSERT INTO fuhbkf_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Mi waɗanan on huunde fuu ko ŋaariɗon Laamɗo saabe am. Mi waɗan ɗum faa Baabiiwo teddiniree saabe Ɓiɗɗo oon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Si won ko ŋaariɗon Laamɗo saabe am, mi waɗanan on. ");
INSERT INTO fuhbkf_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","—Si oɗon njiɗi kam, on njokkan jamirooje am. ");
INSERT INTO fuhbkf_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Mi nyaagoto Baabiiwo hokka on Ballo goɗɗo, wonda e mooɗon faa abada. ");
INSERT INTO fuhbkf_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Oon woni Ruuhu Goonga. Adunaaru waawaa jaɓude mo, sabo nji'ataa mo, anndaa mo. Onon le, oɗon anndi mo sabo imo wondi e mooɗon, o heddoto ley mooɗon du. ");
INSERT INTO fuhbkf_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Mi yoppataa on wo on atiime'en. Mi wartowan to mooɗon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Si ɓooytii seeɗa aduna oo yi'ataa kam katin. De onon kaa, on nji'an kam. Saabe miɗo wuuri, onon du on mbuuran. ");
INSERT INTO fuhbkf_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Nyannde ndeen on paaman miɗo woni ley Baabiiwo, oɗon ngoni e am, miɗo woni e mooɗon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Neɗɗo fuu tiigiiɗo jamirooje am de jokki ɗe, kam woni jiɗɗo kam. Jiɗɗo kam, Baaba am yiɗan ɗum. Miin du, mi yiɗan ɗum, mi ɓanginanan ɗum hoore am. ");
INSERT INTO fuhbkf_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yahuuda, mo wanaa Yahuuda Isikariyotto oon, jaabii mo, wi'i: —Joomam, noy ɓanginirantaa min hoore maa, tawee a ɓanganaay adunaaru? ");
INSERT INTO fuhbkf_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Iisaa jaabii mo, wi'i: —Si neɗɗo ina yiɗi kam, jokkan haala am. Baaba am du yiɗan ɗum. Miin e Baaba am oon min ngaran to muuɗum min njooɗodoo e muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Neɗɗo fuu mo yiɗaa kam, jokkataa haala am. Haala ka nanoton kaan, ka wanaa haala am, wo ka haala Baabiiwo nulɗo kam oon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Ɗum kaalanammi on gilla miɗo tawdaa e mooɗon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ruuhu Ceniiɗo, Balloowo on mo Baabiiwo nuldata on e dow innde am oon, kam anndinta on kulle fuu. O miccintinan on ko mbaajinoomi on ɗuum fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Jam njoppidammi on, jam am kokkammi on. Miin, mi hokkirtaa on no aduna oo hokkirta on ni. Taa umminee hakkillooji mon, taa kulee. ");
INSERT INTO fuhbkf_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","On nanii ko mbiimi on: «mi yahan, de caggal ɗuum mi warta to mooɗon.» Si on njiɗii kam fu, on ceyoto ko njahammi to Baabiiwo, sabo Baabiiwo ɓuri kam teddude. ");
INSERT INTO fuhbkf_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Mi haalanii on joonin gilla ɗum waraay, faa si ɗum warii fu, ngoonɗinon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Mi haaldataa e mooɗon ko heewi katin, sabo laamiiɗo adunaaru bonɗo oon ina wara. Fay huunde o waawanaa kam. ");
INSERT INTO fuhbkf_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ammaa ko Baabiiwo yamiri kam, wo ɗuum ngaɗammi, faa adunaaru faama miɗo yiɗi ɗum. Ummee, ndillen ɗo! ");
INSERT INTO fuhbkf_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","—Miin woni cabiihi ngoongalaahi, Baaba am woni jom ngesa cabiije. ");
INSERT INTO fuhbkf_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Liccal am dimaral fuu o taƴan ɗum. Dimoowal du fuu, o saltoto ɗum faa ɓeyda rimude. ");
INSERT INTO fuhbkf_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Onon du, gilla joonin on laaɓuɓe saabe waaju mo mbaajiimi on oon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ngonee e am, miin du mi wonan e mooɗon. Hono no liccal cabiihi waawiraa rimude e hoore muuɗum sanaa tawee ingal woni e cabiihi ni, hono noon onon du, on mbaawaa rimude si on ngonaay e am. ");
INSERT INTO fuhbkf_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Miin woni cabiihi, onon ngoni licce. Neɗɗo fuu gonɗo e am, tawi miin du miɗo woni e muuɗum, riman faa heewa. On mbaawaa waɗude fay huunde si on ngalaa e am. ");
INSERT INTO fuhbkf_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Neɗɗo fuu mo wonaay e am, faɗɗete yaasin hono no liccal taƴaangal ni, de yoora. Licce joorɗe ɗeen kawrundurte, paɗɗee ley yiite, ɗe kuɓɓa. ");
INSERT INTO fuhbkf_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Si oɗon ngoni e am, waaju am du ina woni e mooɗon fu, nyaagee Laamɗo ko muuyɗon fuu on keɓan. ");
INSERT INTO fuhbkf_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Si on ndimii faa heewii, ɗuum hollan wo on taalibaaɓe am. Ndeen Baaba am mawninte. ");
INSERT INTO fuhbkf_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Hono no Baabiiwo yiɗiri kam noon, miin du njiɗirmi on. Ngonee ley njinngu am. ");
INSERT INTO fuhbkf_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Si on njokkii jamirooje am, on ngonan ley njinngu am hono no njokkirmi jamirooje Baaba am de ngonumi e njinngu muuɗum ni. ");
INSERT INTO fuhbkf_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Mi waajake on ɗum faa seyo am wona ley mooɗon, de seyo mon ngoon laatoo hiɓɓungo. ");
INSERT INTO fuhbkf_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Inan yamiroore am: njiɗunduree hono no njiɗirmi on ni. ");
INSERT INTO fuhbkf_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Huunde fuu ɓuraa njinngu ngu ɗo mawnude: neɗɗo hokkitira yonki muuɗum saabe yigiraaɓe muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Onon, wo on yigiraaɓe am, si on ngaɗii ko njamirmi on ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Mi noddirtaa on maccuɓe katin sabo maccuɗo anndaa ko joomum gollata. De mi noddirii on yigiraaɓe, sabo ko narrumi Baaba am ɗuum fuu, mi anndinii on. ");
INSERT INTO fuhbkf_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Wanaa onon cuɓii kam, wo miin suɓii on de yamiri on njahon ndimowon ɓiɓɓe, de ɓiɓɓe mooɗon keddoo, faa Baabiiwo hokka on huunde fuu ko nyaagoriɗon saabe am. ");
INSERT INTO fuhbkf_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Inan ko njamirammi on: njiɗunduree. ");
INSERT INTO fuhbkf_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","—Si yimɓe adunaaru ɓeen ina mbanyi on fu, anndee, miin ɓe artii wanyude. ");
INSERT INTO fuhbkf_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Sini on laatakeno adunankooɓe fu, ɓe njiɗanno on. Ammaa on nganaa adunankooɓe. Mi suɓake on mi senndii on e yimɓe adunaaru. Ɗum saabanii ɓe wanyude on. ");
INSERT INTO fuhbkf_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Miccitee ko mbi'unoomi on ɗuum: «Maccuɗo ɓuraa joomum.» Si ɓe torrii kam, ɓe torran on, onon du. Si ɓe njokkii haala am, ɓe njokkan haala mooɗon kaan du. ");
INSERT INTO fuhbkf_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ɓe ngaɗiranan on ɗum fuu saabe am, sabo ɓe anndaa Nulɗo kam oon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Si mi waraayno, mbaajiimi ɓe, ɓe ngalaano hakke. De joonin kaa mi warii, mi waajake ɓe, ɓe ngalaa geldol fuu e dow hakkeeji maɓɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Neɗɗo fuu banyuɗo kam, wanyii Baaba am oon du. ");
INSERT INTO fuhbkf_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Mi gollii golleeji yeeso maɓɓe ɗi fay gooto gollaay. Si mi gollaayno kujje ɗeen fu, ɓe ngalaano hakke. Ammaa joonin ɓe nji'ii ɗe fuu, de iɓe keddii iɓe mbanyi kam, miin e Baaba am. ");
INSERT INTO fuhbkf_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ɗum waɗii faa tabintina ko winndaa ley Tawreeta maɓɓe: «Ɓe mbanyii kam ɓolum.» ");
INSERT INTO fuhbkf_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Ruuhu Goonga ƴuuroowo to Baabiiwo, Balloowo on mo nuldammi on oon, nde wari fu, kam seedantoo kam. ");
INSERT INTO fuhbkf_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Onon du, on ceedanto kam sabo oɗon ngondi e am gilla fuɗɗoode. ");
INSERT INTO fuhbkf_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","—Mi waajake on ɗum faa taa njoppon goonɗinal. ");
INSERT INTO fuhbkf_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ɓe mburtinan on cuuɗi baajorɗi. Wakkati warowan nde barɗo on fuu miilotoo waɗii ko weli Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ɓe ngaɗan ɗum sabo ɓe anndaa Baabiiwo oon, ɓe anndaa kam miin du. ");
INSERT INTO fuhbkf_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Mi waajake on ɗum, faa nde wakkati oon waroyi fu, miccoɗon mi haalaniino on ɗum. —Mi haalanaay on gilla arande sabo miɗo wondi e mooɗon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Joonin inan miɗo yeccoo to Nulɗo kam oon, de fay gooto mooɗon ƴamaay kam to njahammi. ");
INSERT INTO fuhbkf_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","On cunake sanne saabe ko kaalanmi on ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ɗum fuu e laataade, miɗo haalana on goonga: mi yaha ni ɓuri nafude on. Sabo si mi yahaay, Balloowo on oon warataa to mooɗon. De si mi yehii, mi nuldan on mo. ");
INSERT INTO fuhbkf_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Si o warii fu, o laaɓinanan yimɓe adunaaru dow hakkeeji muɓɓen e dow fonnditaare e sariya. ");
INSERT INTO fuhbkf_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Dow hakkeeji, sabo ɓe ngoonɗinaay kam. ");
INSERT INTO fuhbkf_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Dow fonnditaare, sabo miɗo yeccoo to Baabiiwo oon, on nji'ataa kam katin. ");
INSERT INTO fuhbkf_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Dow sariya du, sabo laamiiɗo adunaaru bonɗo oon saraama. ");
INSERT INTO fuhbkf_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Miɗo jogii ko heewi katin ko mi waajoo on, ammaa on mbaawtataa ɗum joonin. ");
INSERT INTO fuhbkf_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Nde Ruuhu Goonga oon wari fuu, ɗowan on faa paamon goonga fuu. Sabo ko o haalata ɗuum wanaa e makko ƴuurata. Wo ko o nani o haalanta on, o humpitan on ko waroyta. ");
INSERT INTO fuhbkf_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","O teddinan kam, sabo o hooƴan ko njeymi ɗuum, de o humpita on. ");
INSERT INTO fuhbkf_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ko Baabiiwo oon jogii fuu, miin jeyi. Ɗum waɗi mbiimi o humpitan on ko o heɓi e am ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","—Si ɓooytii seeɗa, on nji'ataa kam, de si ɓooytowii seeɗa katin, on nji'owan kam. ");
INSERT INTO fuhbkf_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Yoga e taalibaaɓe makko ɓeen ƴamunduri, mbi'i: —Ɗume woni maanaa haala makko ko o wi'i «si ɓooytii seeɗa, on nji'ataa kam de si ɓooytowii seeɗa fu, on nji'owan kam katin»? Ɗume woni maanaa ko o wi'i «sabo mi yahan to Baabiiwo» ɗuum? ");
INSERT INTO fuhbkf_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ɓe mbi'i: —«Si ɓooytii seeɗa», ɗume ɗum fiirtata? Min paamaay ko o wi'i ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Iisaa faamii iɓe njiɗi lamndaade ɗum, de wi'i ɓe: —Oɗon ƴamundura maanaa haala am ka: «Si ɓooytii seeɗa on nji'ataa kam, de si ɓooytowii seeɗa fu, on nji'owan kam katin.» ");
INSERT INTO fuhbkf_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Goonga kaalanammi on: on mboyan, on mboytoto, tawee yimɓe adunaaru ɓeen ina ceyii. On cunoto, ammaa cunu mooɗon waylitoto seyo. ");
INSERT INTO fuhbkf_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Si debbo na rima fu, ɓernde muuɗum mettan sabo wakkati muuɗum warii. Ammaa si cukalel ngel rimaama fu, o miccitataako naawalla ndimu makko saabe seyo ko o heɓi ɓiɗɗo ley adunaaru ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Onon du hono noon cunortoɗon joonin, ammaa mi yiitan on katin, de ɓerɗe mooɗon ceyoo sanne. Ndeen fay gooto waawaa bonnude seyo mooɗon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Nyannde ndeen, on ƴamataa kam fay huunde. Goonga kaalanammi on: huunde fuu ko nyaagiɗon Baabiiwo oon, hokkiran on saabe am. ");
INSERT INTO fuhbkf_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Faa joonin, walaa fuu ko nyaagoriɗon saabe am. Nyaagee, on keɓan, faa seyo mooɗon heewa. ");
INSERT INTO fuhbkf_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","—Ko kaalanmi on joonin ɗuum wo haala kippaaka. De wakkati waran mo mi hippataa haala. Ndeen kaa mi haalanan on haala Baabiiwo faa laaɓa. ");
INSERT INTO fuhbkf_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Nyannde ndeen on nyaagorto Laamɗo saabe am. Mi wi'aay mi nyaaganto on Baabiiwo, ");
INSERT INTO fuhbkf_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","sabo Baabiiwo e hoore muuɗum ina yiɗi on. O yiɗirii on saabe ko njiɗuɗon kam, on ngoonɗinii to Laamɗo ƴuurumi. ");
INSERT INTO fuhbkf_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Mi ƴuurii to Baabiiwo, mi warii e adunaaru. Joonin miɗo dilla adunaaru ndu, mi yeccoo to Baabiiwo. ");
INSERT INTO fuhbkf_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Taalibaaɓe makko mbi'i mo: —Joonin kaa, a haalii faa laaɓi, walaa fuu ko kippuɗaa. ");
INSERT INTO fuhbkf_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Joonin kaa, min paamii aɗa anndi huunde fuu, a haajaaka fay gooto ƴame. Saabe ɗuum waɗi de min ngoonɗini wo a ƴuuruɗo to Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Iisaa jaabii ɓe, wi'i: —Joonin, on ngoonɗinii naa? ");
INSERT INTO fuhbkf_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Wakkati ina wara, o warii joonin, ɗo on fuu caakotoɗon, mono fuu hoota suudu muuɗum, njoppon kam mi perwuɗo. Ammaa mi wanaa perwuɗo, sabo Baabiiwo oon ina wondi e am. ");
INSERT INTO fuhbkf_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Mi haalanii on ɗum, faa keɓon jam ley gondal am. Ley adunaaru ndu on keɓan torra, ammaa cemmbinee ɓerɗe mon, sabo miin, mi jaalake adunaaru ndu! ");
INSERT INTO fuhbkf_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Nde Iisaa waajinoo waajuuji ɗiin ndeen, tiggitii kammu, wi'i: —Baabiiwo, wakkati oon warii, teddin Ɓiya, faa Ɓiya oon du teddine. ");
INSERT INTO fuhbkf_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Sabo a hokkii mo baawɗe dow neɗɗo fuu, faa o hokka ɓe kokkuɗaa mo ɓeen fuu nguurndam nduumiiɗam. ");
INSERT INTO fuhbkf_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Nguurndam nduumiiɗam wo anndude ma, aan Laamɗo gooto goongaajo oon, e anndude Iisaa Almasiihu mo nulɗaa oon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Mi teddinii ma e dow leydi ndi, mi yottinii gollal ngal kokkuɗaa kam mi golla ngaal. ");
INSERT INTO fuhbkf_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Joonin kaa, Baabiiwo, teddinam yeeso maa darja mo ngoodunoomi to maaɗa gilla adunaaru ndu tagaaka. ");
INSERT INTO fuhbkf_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Yimɓe ɓe kokkuɗaa kam e adunaaru ndu ɓeen, mi ɓanginanii ɗum'en innde maa. Aan jeyi ɓe, a hokkii kam ɓe, iɓe njokki haala maa. ");
INSERT INTO fuhbkf_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Joonin kaa, ɓe anndii ko kokkuɗaa kam ɗuum fuu to maaɗa ƴuuri, ");
INSERT INTO fuhbkf_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","sabo mi haaltanii ɓe haalaaji ɗi kokkuɗaa kam ɗiin. Ɓe njaɓii ɗi, ɓe keɓii tannyoral wo to maaɗa ƴuurumi, ɓe ngoonɗinii aan nuli kam. ");
INSERT INTO fuhbkf_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Miɗo nyaage saabe maɓɓe. Mi nyaagataako saabe adunaaru nduun, miɗo nyaagoo saabe ɓe kokkuɗaa kam ɓeen, sabo aan jeyi ɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ɓe njeymi fuu, wo aan jeyi, ɓe njeyɗaa fuu, wo miin jeyi. Mi teddiniraama saabe maɓɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Joonin mi heddataako ley adunaaru katin. To maaɗa njahammi. De kamɓe kaa, ɓe keddoto e mayru. Aan Baabiiwo Ceniiɗo, reenir ɓe baawɗe innde maaɗa nde kokkuɗaa kam ndeen, faa ɓe laatoo gootum hono no meeɗen ni. ");
INSERT INTO fuhbkf_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Nde ngondunoomi e maɓɓe ley adunaaru ndu ndeen, mi reenirii ɓe baawɗe innde maa nde kokkuɗaa kam ndeen, mi tinnake e maɓɓe. Fay gooto halkaay si wanaa jeyɗo halkude oon, faa ko sappaa e Binndi ɗiin ɗuum tabita. ");
INSERT INTO fuhbkf_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Joonin kaa miɗo wara to maaɗa. Miɗo haala haalaaji ɗi gilla miɗo heddii e adunaaru ndu tafon, faa seyo am heewa ley maɓɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Mi yottinanii ɓe haala maa. Adunaaru ndu wanyii ɓe, sabo ɓe njeyaaka e mayru, hono no miin du mi jeyiraaka e mayru ni. ");
INSERT INTO fuhbkf_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Mi nyaagaaki ittaa ɓe e adunaaru ndu, de miɗo nyaage ndeenaa ɓe e bonɗo oon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ɓe njeyaaka e adunaaru ndu, hono no miin du mi jeyiraaka e mayru ni. ");
INSERT INTO fuhbkf_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ceniraa ɓe e goonga. Haala maa woni goonga. ");
INSERT INTO fuhbkf_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Hono no nulirɗaa kam e adunaaru ndu noon, miin du nulirmi ɓe e mayru. ");
INSERT INTO fuhbkf_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Miɗo senira hoore am saabe maɓɓe, faa kamɓe du ɓe laatoo seniraaɓe goonga. ");
INSERT INTO fuhbkf_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Wanaa saabe maɓɓe tan nyaagantomaami. Miɗo nyaaganoo du saabe goonɗinirɓe kam e waajuuji maɓɓe ɓeen. ");
INSERT INTO fuhbkf_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Miɗo nyaage faa ɓe fuu ɓe laatoo gootum. Hono no aan Baabiiwo ngonirɗaa e am noon, e miin du ngonirmi e maaɗa, kamɓe du ɓe ngona e meeɗen, faa adunaaru ndu goonɗina aan nuli kam. ");
INSERT INTO fuhbkf_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Mi hokkii ɓe teddeengal ngal kokkuɗaa kam ngaal, faa ɓe laatoo gootum, hono no laatoriɗen gootum ni, ");
INSERT INTO fuhbkf_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","miin e maɓɓe, aan du e am. Ɗum wo faa ɓe laatodoo gooto kiɓɓuɗo. Ndeen adunaaru ndu faaman aan nuli kam, ndu faaman du aɗa yiɗi ɓe hono no njiɗirɗaa kam ni. ");
INSERT INTO fuhbkf_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Baabiiwo, miɗo yiɗi ɓe kokkuɗaa kam ɓeen ngonda e am nokku fuu ɗo tawaami, faa ɓe nji'a teddeengal ngal kokkuɗaa kam ngaal sabo a yiɗii kam gilla adunaaru ndu joƴƴinaaka. ");
INSERT INTO fuhbkf_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Baabiiwo ponnditiiɗo, adunaaru ndu anndaa ma, de miin kaa miɗo anndi ma. Ɓee ɗo du ina anndi aan nuli kam. ");
INSERT INTO fuhbkf_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Mi anndinii ɓe ko ngonɗaa, mi ɓeydan anndinde ɓe, faa njinngu ngu njiɗɗaa kam nguun wona e maɓɓe, miin du mi wona e maɓɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Nde Iisaa du'inoo ɗum fu, yaadi e taalibaaɓe muuɗum, peƴƴiti gooruwol bi'eteengol Kedoron. Toon na woodi nokku keewɗo leɗɗe. Ɓe naati toon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yahuuda jambotooɗo mo oon ina anndi nokku oon, sabo Iisaa e taalibaaɓe muuɗum ina mboowi hawritinde toon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Yahuuda yaari oorngal sordaasiiɓe e gollooɓe ƴuuruɓe to hooreeɓe almaami'en e Farisa'en. Ɓe ngari toon, iɓe njogii fitillaaji e jaynorɗe e kaɓitirɗe. ");
INSERT INTO fuhbkf_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Iisaa ina anndi ko warata e muuɗum fuu, jakkitii ɓe, wi'i: —Moy pilotoɗon? ");
INSERT INTO fuhbkf_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ɓe njaabii mo: —Iisaa Nasaraatuujo oon. O wi'i ɓe: —Wo miin. Yahuuda jambotooɗo mo oon du ina darii ɗoon ina wondi e maɓɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Nde Iisaa wi'unoo «Wo miin» ndeen, ɓe njaatiri gaɗa ɓe caami e leydi. ");
INSERT INTO fuhbkf_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Iisaa ƴami ɓe katin: —Moy pilotoɗon? Ɓe njaabii, ɓe mbi'i: —Iisaa Nasaraatuujo oon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Iisaa wi'i ɓe: —Mi wi'ii on, wo miin! Si wo miin pilotoɗon, accee ɓee kaa njaha. ");
INSERT INTO fuhbkf_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Noon ɗum laatorii, faa haala Iisaa kaan tabita: «Mi lallinaay fay gooto e ɓe kokkuɗaa kam ɓeen.» ");
INSERT INTO fuhbkf_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simon Piyeer ina jogii kaafaahi, soorti ki, soppi maccuɗo Almaami Mawɗo nowru nyaamru faa ndu taƴi. Golloowo oon ina wi'ee Malkus. ");
INSERT INTO fuhbkf_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ndeen Iisaa wi'i Piyeer: —Soornu kaafaahi maa ki e hulgo muuɗum. Aɗa miilii mi yardataa horde torra nde Baabiiwo hokki kam ndeen naa? ");
INSERT INTO fuhbkf_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ɗoon sordaasiiɓe e mawɗo muɓɓen e gollanooɓe hooreeɓe Alhuudiyankooɓe nanngi Iisaa, kaɓɓi ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ɓe njaari ɗum to Annas tafon. Annas wo esoo Kayafas laatiiɗo Almaami Mawɗo ley hitaande ndeen. ");
INSERT INTO fuhbkf_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Tawi kanko Kayafas oon dawrannoo hooreeɓe Alhuudiyankooɓe dabare, tindini ɓe, wi'i: ko ɓuri woodde e yimɓe lenyol ngol, neɗɗo gooto maayana ɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simon Piyeer e taalibaajo goɗɗo njokki Iisaa. Taalibaajo oon ina anndunduri e Almaami Mawɗo oon, ɗuum waɗi de o heɓi naaddude e Iisaa galle Almaami Mawɗo oon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Piyeer kaa darii yaasin to dammbugal toon. Taalibaajo anndundurɗo e Almaami Mawɗo oon, yalti haaldi e debbo doomoowo dammbugal ngaal oon, nanni Piyeer. ");
INSERT INTO fuhbkf_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Korɗo doomoowo dammbugal oon ƴami Piyeer: —Aan le, a wanaa gooto e taalibaaɓe gorko oon naa? Piyeer jaabii mo, wi'i: —Mi wanaa! ");
INSERT INTO fuhbkf_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Tawi gollooɓe e doomooɓe kuɓɓiino yiite ina ƴuuloo sabo jaangol ina woodi. Piyeer du na darodii e maɓɓe ina ƴuuloo. ");
INSERT INTO fuhbkf_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ndeen Almaami Mawɗo oon ƴami Iisaa haala taalibaaɓe muuɗum e waaju mum. ");
INSERT INTO fuhbkf_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Iisaa jaabii mo, wi'i: —Mi ɓanginanii adunaaru ndu waaju am. Wakkati fuu miɗo waajoo ley cuuɗi baajorɗi e ley suudu dewal mawndu to Alhuudiyankooɓe fuu kawritata toon. Walaa fuu ko kaaldumi cuncukka. ");
INSERT INTO fuhbkf_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ko saabii aɗa ƴama kam? Ƴamu hettindaniiɓe kam ɓeen. Kamɓe kaa, iɓe anndi ko mbaajiimi ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Nde Iisaa haalnoo ɗum ndeen, gooto e doomooɓe ɓeen feenyi ɗum, wi'i: —Nii njaabortoɗaa Almaami Mawɗo naa? ");
INSERT INTO fuhbkf_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Iisaa jaabii mo, wi'i: —Si ko boni mbiimi, haalanam ko boni e majjum. Si tawii ko wooɗi mbiimi du, ko waɗi de piiɗaa kam? ");
INSERT INTO fuhbkf_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ndeen Annas nuldi mo to Kayafas Almaami Mawɗo oon, imo haɓɓaa. ");
INSERT INTO fuhbkf_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simon Piyeer ina darii toon ina ƴuuloo. Ɓe mbi'i mo: —Aan, a wanaa gooto e taalibaaɓe makko ɓeen naa? O yeddi, o wi'i: —Mi wanaa! ");
INSERT INTO fuhbkf_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Gooto e gollooɓe Almaami Mawɗo oon, sakiike mo Piyeer taƴunoo nowru muuɗum oon, wi'i: —Wanaa mi yiidii ma e makko ley nokku keewɗo leɗɗe toon naa? ");
INSERT INTO fuhbkf_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Piyeer yeddi katin, de wakkati oon pay, ndontoori joggi. ");
INSERT INTO fuhbkf_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Caggal ɗuum, ɓe itti Iisaa to Kayafas gilla fajiri kecco, ɓe njaari mo to laamordu goforneer oon. Yaaruɓe mo ɓeen naataay suudu nduun, sabo si ɓe naatiino fu, ɓe tuunan e ley diina, de ɓe mbaawaa nyaamude nyaamdu iidi Faltagol nduun. ");
INSERT INTO fuhbkf_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Pilaatu, goforneer oon, yalti yehi to maɓɓe yaasin toon, wi'i ɓe: —Ɗume peldoton gorko o? ");
INSERT INTO fuhbkf_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ɓe njaabii mo: —Si o gollaayno ko boni, min ngaddataano mo to maaɗa. ");
INSERT INTO fuhbkf_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ndeen Pilaatu wi'i ɓe: —Njaaree mo, caroɗon mo sariya mooɗon. Alhuudiyankooɓe ɓeen njaabii: —Laamu hokkaay min laawol warude fay gooto. ");
INSERT INTO fuhbkf_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Nii haala ka Iisaa haalnoo dow maayde muuɗum kaan tabitiri. ");
INSERT INTO fuhbkf_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilaatu yeccii naati laamordu nduun, noddi Iisaa, wi'i ɗum: —Aan woni kaananke Alhuudiyankooɓe oon naa? ");
INSERT INTO fuhbkf_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Iisaa jaabii mo, wi'i: —Aan e hoore maa wi'i noon naa woɓɓe narruɗaa? ");
INSERT INTO fuhbkf_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilaatu jaabii mo: —Miin, mi Alhuudiyanke naa? Ɗume ngaɗuɗaa de lenyol maa e hooreeɓe almaami'en ngaddi ma to am? ");
INSERT INTO fuhbkf_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Iisaa jaabii, wi'i: —Laamu am jeyaaka e adunaaru ndu. Sini ingu jeyanoo e adunaaru ndu, gollooɓe am kaɓanno taa mi naata juuɗe hooreeɓe Alhuudiyankooɓe. De si goonga laamu am ƴuuraay e adunaaru ndu. ");
INSERT INTO fuhbkf_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ndeen Pilaatu wi'i mo: —Ndelle, a kaananke naa? Iisaa jaabii, wi'i: —Aan e hoore maa haali, wo mi kaananke. Walaa fuu ko ndimiraami de ngarmi ley adunaaru ndu si wanaa faa mi seedoo goonga. Neɗɗo fuu jiɗɗo goonga, ina nana daande am. ");
INSERT INTO fuhbkf_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilaatu wi'i mo: —Goonga? Ɗume woni goonga? Nde Pilaatu ƴamunoo ɗum fu, yalti katin, tawtowi Alhuudiyankooɓe ɓeen to yaasin toon, wi'i ɓe: —Mi heɓaay feloore fay wootere e makko. ");
INSERT INTO fuhbkf_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Kaa ley al'aada mooɗon, iidi Faltagol fuu miɗo yoofana on kasunke gooto. Oɗon njiɗi mi yoofana on kaananke Alhuudiyankooɓe oon naa? ");
INSERT INTO fuhbkf_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ɓe fuu ɓe peekii, ɓe mbi'i: —Wanaa oon, Barabas min njiɗi. Barabas le wo muurtunooɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ndeen Pilaatu yamiri Iisaa nanngee, fiyee dorri. ");
INSERT INTO fuhbkf_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Sordaasiiɓe ɓeen canyi taarde gi'e, kippi e hoore makko, ɓorni mo saaya mboɗeeha. ");
INSERT INTO fuhbkf_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ɓe ɓattitii mo, iɓe mbi'a: —Foofoo, kaananke Alhuudiyankooɓe! Iɓe peenya mo. ");
INSERT INTO fuhbkf_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilaatu yalti katin, wi'i Alhuudiyankooɓe ɓeen: —Mi wurtinan mo faa anndon mi heɓaay feloore fay wootere e makko. ");
INSERT INTO fuhbkf_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ndeen Iisaa wurtinaa yaasin ina hippii taarde gi'e ndeen, ina ɓornii saaya mboɗeeha kaan. Pilaatu wi'i ɓe: —Inan gorko oo! ");
INSERT INTO fuhbkf_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Nde hooreeɓe almaami'en e gollooɓe muɓɓen ɓeen njiinoo mo ndeen, peekii mbi'i: —Tontu mo e leggal palaangal! Tontu mo e leggal palaangal! Pilaatu wi'i ɓe: —Nanngee mo onon tonton mo, sabo miin kaa, mi heɓaay feloore e makko. ");
INSERT INTO fuhbkf_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Alhuudiyankooɓe njaabii mo: —O luttii sariya amin. E ley sariya amin oon kaa tilay o waree, sabo o waɗii hoore makko o Ɓii Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Nde Pilaatu nannoo haala kaan ndeen, kulol muuɗum ɓeydii. ");
INSERT INTO fuhbkf_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","O naati suudu nduun katin o wi'i Iisaa: —Toy ƴuurataa? Iisaa jaabaaki mo fay huunde. ");
INSERT INTO fuhbkf_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ndeen Pilaatu wi'i mo: —Yalla a haaldataa e am naa? Yalla a anndaa miɗo waawi yoppude ma, miɗo waawi tontude ma? ");
INSERT INTO fuhbkf_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Iisaa jaabii mo, wi'i: —Si wanaa Laamɗo hokki ma baawɗe, a waawanaa kam fay huunde. Ɗuum waɗi de gattuɗo kam e junngo maaɗa oon ina ɓuri maa hakkeeji. ");
INSERT INTO fuhbkf_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Gilla ndeen Pilaatu ina filoo yoppude mo. Ɗum waɗi de Alhuudiyankooɓe ina peekoo, ina mbi'a: —Sini a yoppii mo, a wanaa yigoo kaananke Roma mawɗo oon. Neɗɗo fuu gaɗuɗo hoore muuɗum kaananke wo ganyo kaananke Roma. ");
INSERT INTO fuhbkf_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Nde Pilaatu nannoo haalaaji ɗiin ndeen, wurtini Iisaa, jooɗii dow jooɗorgal sariya, nokku bi'eteeɗo Kaaƴe Cehaaɗe (e ibraninkoore na wi'ee Gabbata). ");
INSERT INTO fuhbkf_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ndeen wo nyannde segilanteende iidi Faltagol, wakkati hakkunde naange. Pilaatu wi'i Alhuudiyankooɓe: —Inan kaananke mooɗon! ");
INSERT INTO fuhbkf_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ɓe ƴeewnii semmbe: —War mo! War mo! Tontu mo e leggal palaangal! Pilaatu jaabii, wi'i: —Mi tonta kaananke mooɗon oon naa? Hooreeɓe almaami'en ɓeen mbi'i: —Min ngalaa kaananke si wanaa kaananke Roma mawɗo oon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ndeen o hokki ɓe Iisaa faa ɓe tontowa ɗum. Ndelle sordaasiiɓe ɓeen nanngi Iisaa, njaadi e muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Iisaa yalti ina ronndii leggal muuɗum palaangal faa yottii nokku bi'eteeɗo Laalagal Hoore (e ibraninkoore na wi'ee Golgata). ");
INSERT INTO fuhbkf_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ɗoon ɓe tontidi mo e woɓɓe ɗiɗo: oo gere nano, oo du gere nyaamo, Iisaa ina tummbii. ");
INSERT INTO fuhbkf_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilaatu yamiri ɓe mbinnda e alluwal, ɓe takka ngal e leggal palaangal ngaal. Binndi dow maggal na mbi'a: Iisaa Nasaraatuujo, Kaananke Alhuudiyankooɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Alhuudiyankooɓe heewɓe njanngi binndi ɗiin sabo ɗo Iisaa tontaa ɗoon woɗɗaa ngalluure ndeen. Alluwal ngaal winndaama e ibraninkoore e geresankoore e romankoore. ");
INSERT INTO fuhbkf_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ndeen hooreeɓe almaami'en ɓeen mbi'i Pilaatu: —Taa winndu: «Kaananke Alhuudiyankooɓe», winndu: «o wi'ii kanko woni kaananke Alhuudiyankooɓe». ");
INSERT INTO fuhbkf_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilaatu jaabii: —Ko mbinndumi ɗuum winndaama, tilake. ");
INSERT INTO fuhbkf_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Nde sordaasiiɓe ɓeen tilinoo tontude Iisaa ndeen, pecci kaddule makko pecce nay. Mono fuu hooƴi feccere muuɗum. Ɓe kooƴi saaya makko du. Saaya kaan walaa nyoogol. Ka fuu ka lefol gootol. ");
INSERT INTO fuhbkf_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Sordaasiiɓe ɓeen kaaldi: —Taa ceeken saaya ka. Ngaɗen ka cumnal, ndaaren moy heɓata ka. Ɗum waɗii, faa ko sappaa e Binndi ɗiin ɗuum tabita: «Ɓe peccii kaddule am hakkunde maɓɓe, ɓe ngaɗii saaya am cumnal.» Noon sordaasiiɓe ɓeen ngaɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Inna Iisaa, e sakiike inna muuɗum debbo, e Mariyama dee Kolopa, e Mariyama mo Magdala ina ndarii ɗakkol leggal ngal Iisaa tontaa e muuɗum ngaal. ");
INSERT INTO fuhbkf_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Iisaa yi'i inna muuɗum e taalibaajo muuɗum korsuɗo oon ina ndarodii, wi'i inna mum: —Inna, inan ɓiya! ");
INSERT INTO fuhbkf_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ndeen o wi'i taalibaajo oon: —Inan inna maaɗa. Gilla wakkati oon taalibaajo oon yaari Mariyama wuro muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Caggal ɗuum, Iisaa anndi walaa fuu ko heddii. Faa tabintina ko Binndi ɗiin mbi'i ɗuum, o wi'i: —Mi ɗomɗii! ");
INSERT INTO fuhbkf_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Loongel keewngel ndiyam lammuɗam ina woni ɗoon. Ɓe cuuwi tekkere e ndiyam lammuɗam ɗaam, ɓe kaɓɓi e loosol lekki hisop, ɓe ɓattini e hunnduko makko. ");
INSERT INTO fuhbkf_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Nde Iisaa meeɗunoo ɗam ndeen, wi'i: —Tilake! O turi hoore makko, o yoofi yonki makko. ");
INSERT INTO fuhbkf_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ndeen wo nyannde segilanteende iidi. Hooreeɓe Alhuudiyankooɓe nyaagii Pilaatu faa koyɗe tontaaɓe ɓeen kelee, de ɓe adee, taa terɗe ɗeen keddoo e leɗɗe ɗeen nyalaande fowteteende. Sabo nyannde ndeen wo teddunde. ");
INSERT INTO fuhbkf_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ndelle sordaasiiɓe ɓeen ngari, keli korre worɓe ɗiɗo tontidanooɓe e Iisaa ɓeen. ");
INSERT INTO fuhbkf_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ammaa nde ɓe njottinoo Iisaa ndeen, ɓe tawi o maayii. Ɗum waɗi de ɓe kelaay korre makko. ");
INSERT INTO fuhbkf_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","De gooto e sordaasiiɓe ɓeen yuwi Iisaa labbo e wuttudu. Wakkati oon fu, ƴiiƴam e ndiyam njuppii. ");
INSERT INTO fuhbkf_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Neɗɗo ceediiɗo ɗum oon yi'i ɗum. Seedaaku makko du wo goonga. Kaalɗo oon ina anndi haalii goonga, faa onon du, ngoonɗinon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ɗum fuu waɗii, faa ko Binndi ɗiin mbi'i ɗuum tabita: «Fay gootal e ƴi'e makko helataake.» ");
INSERT INTO fuhbkf_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ɗi mbi'i katin: «Ɓe ndaaran mo ɓe njuwnoo oon.» ");
INSERT INTO fuhbkf_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Caggal ɗuum, Yuusufi Arimatiyanke nyaagii Pilaatu faa hooƴa ɓanndu Iisaa. Pilaatu jaɓani mo ɗum. O hooƴi ndu. Tawi Yuusufi oon wo taalibaajo Iisaa e cuncukka, sabo imo hula hooreeɓe Alhuudiyankooɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodemu jaanooɗo to Iisaa jemma oon du wari, waddi urdiiji jillunduraaɗi bi'eteeɗi miiri e alowe. Teddeefi majjum wo hono kilooji capanɗe tati e ɗiɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Kamɓe ɗiɗo ɓe kooƴi ɓanndu Iisaa, ɓe piili ndu e kasanke gattaaɗo urdiiji ɗiin hono no Alhuudiyankooɓe mboowiri uwirde maayɓe muɓɓen ni. ");
INSERT INTO fuhbkf_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ɗo Iisaa tontanoo ɗoon ina woodi nokku keewɗo leɗɗe. Ley nokku oon ina woodi saabeere heyre ɗo fay gooto wattaaka abada. ");
INSERT INTO fuhbkf_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ɓe ngatti ɓanndu Iisaa ley saabeere ndeen sabo nyannde ndeen wo nyannde nde Alhuudiyankooɓe cegilantoo nyannde fowteteende, de saabeere ndeen ina ɓadii ɗo Iisaa tontanoo ɗoon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Nyannde alan, go'aɓerde e jeɗɗiire ndeen, Mariyama mo Magdala hejji, yehi to saabeere toon. O tawi hayre uddiranoonde saabeere ndeen tallitaama. ");
INSERT INTO fuhbkf_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","O doggi, o yehi to Simon Piyeer e taalibaajo mo Iisaa horsinnoo oon, o wi'i ɓe: —Ɓe ittii Joomii en e saabeere ndeen, mi anndaa fuu ɗo ɓe ngatti mo. ");
INSERT INTO fuhbkf_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Piyeer e taalibaajo oon njalti, njehi to saabeere toon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ɓe ɗiɗo fuu, iɓe ndogga. Taalibaajo oon daɗi Piyeer, artii ɗum e saabeere ndeen. ");
INSERT INTO fuhbkf_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","O yuurnii, o yi'i kasanke oon wo ɓolo, de o naataay. ");
INSERT INTO fuhbkf_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simon Piyeer, kam kaa nde yottinoo fu, naati, tawi kasanke oon ina waalii. ");
INSERT INTO fuhbkf_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Lefol piilanoongol e hoore Iisaa ngool tawdaaka e kasanke oon, ngol tawaama ingol sowii e feere maggol. ");
INSERT INTO fuhbkf_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ndeen taalibaajo artinooɗo yottaade oon, kam du naati, yi'i, goonɗini. ");
INSERT INTO fuhbkf_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Tawi ɓe paamaayno tafon ko Binndi ɗiin mbi'i ina tilsi Iisaa ummitoo e maayde. ");
INSERT INTO fuhbkf_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Caggal ɗuum, taalibaaɓe ɗiɗo ɓeen kooti. ");
INSERT INTO fuhbkf_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Mariyama le ina darii ɗo dammbugal saabeere ɗoon, ina woya. O turii, o yuurnii ley saabeere ndeen. ");
INSERT INTO fuhbkf_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","O yi'i maleyka'en ɗiɗo ɓe kaddule daneeje ina njooɗii ɗo ɓanndu Iisaa nduun wonnoo ɗoon, gooto faro hoore, gooto oon du faro koyɗe. ");
INSERT INTO fuhbkf_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Maleyka'en ɓeen mbi'i mo: —Banndam debbo, ɗume mboyataa? O jaabii ɓe, o wi'i: —Ɓe ittii Joomam ɗo, de mi anndaa fuu to ɓe ngattowi ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Nde o haalnoo haala kaan ndeen, o waylitii, o yi'i Iisaa ina darii, de o annditaay ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Iisaa wi'i mo: —Banndam debbo, ɗume mboyataa? Moy pilotoɗaa? Mariyama miilii wo golloowo nokku oon haaldata e muuɗum, wi'i mo: —Joomam, si aan itti mo ɗo, haalanam ɗo ngattuɗaa mo, faa mi hooƴa mo. ");
INSERT INTO fuhbkf_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Iisaa wi'i mo: —Mariyama! O yeeƴii, o wi'i e ibraninkoore: — Rabbunii! (ɗum na fiirta «Moodibbo»). ");
INSERT INTO fuhbkf_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Iisaa wi'i mo: —Taa meemam, sabo mi ƴeeŋaay to Baabiiwo tafon. Yahu to sakiraaɓe am, mbi'aa ɓe mi ƴeeŋan mi yaha to Baaba am, wo Baaba mooɗon du, to Laamɗo am, wo Laamɗo mooɗon du. ");
INSERT INTO fuhbkf_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Mariyama mo Magdala haalanowi taalibaaɓe ɓeen, wi'i ɓe: —Mi yi'ii Joomii en oon. O haalani ɓe ko Iisaa haalani mo ɗuum fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Nde kiiral naange alan warnoo ndeen, taalibaaɓe Iisaa ɓeen na ngoni ley suudu na cokitii saabe kulol hooreeɓe Alhuudiyankooɓe. Ndeen Iisaa wari darii hakkunde maɓɓe, wi'i ɓe: —Jam wondu e mooɗon! ");
INSERT INTO fuhbkf_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Nde o jowtunoo ɓe ndeen, o holli ɓe newe juuɗe makko e wuttudu makko. Taalibaaɓe ɓeen ceyii nde njiinoo Joomiraaɗo ndeen. ");
INSERT INTO fuhbkf_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Caggal ɗuum Iisaa wi'i ɓe katin: —Onon e jam! Hono no Baabiiwo nuliri kam ni, miin du nulirammi on. ");
INSERT INTO fuhbkf_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Nde o haalnoo haalaaji ɗiin ndeen, o fuufi dow maɓɓe, o wi'i: —Njaɓee Ruuhu Ceniiɗo! ");
INSERT INTO fuhbkf_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Mo njaafaniɗon hakkeeji muuɗum, yaafanaama ɗi. Mo on njaafanaaki hakkeeji muuɗum du, yaafantaake ɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","De Tomaa noddirteeɗo Funereejo, gooto e sappo e ɗiɗo ɓeen, tawaaka ɗoon nde Iisaa ɓangunoo hakkunde maɓɓe ndeen. ");
INSERT INTO fuhbkf_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Taalibaaɓe ɓeen mbi'i mo: —Min nji'ii Joomii en! O jaabii ɓe: —Si mi yi'aay batite tontanɗe ɗeen e newe makko, de mi watta honndu am e majje, mi watta junngo am e wuttudu makko fu, abada mi goonɗintaa. ");
INSERT INTO fuhbkf_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Jeɗɗiire wootere caggal ɗuum, taalibaaɓe ɓeen kawriti katin. Tomaa ina wondi e maɓɓe. Gampuuje ɗeen fuu ina cokii. Iisaa ɓangi, darii hakkunde maɓɓe, wi'i: —Onon e jam! ");
INSERT INTO fuhbkf_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","O wi'i Tomaa: —Wattu ɗo honndu maa, ndaar juuɗe am. Ɓattin junngo maa, wattu ngo e wuttudu am. Sel sikkitirde, goonɗin tan. ");
INSERT INTO fuhbkf_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomaa jaabii, wi'i mo: —Joomam, Laamɗo am! ");
INSERT INTO fuhbkf_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Iisaa wi'i mo: —Saabe ko njiiɗaa kam ɗuum waɗi de ngoonɗinɗaa. Barke woodanii ɓe nji'aay kam de ngoonɗini. ");
INSERT INTO fuhbkf_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Iisaa waɗi yeeso taalibaaɓe muuɗum maandeeji kaayniiɗi goɗɗi keewɗi ɗi mbinndaaka ley dewtere nde. ");
INSERT INTO fuhbkf_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ɗi ɗo mbinndaama, faa ngoonɗinon Iisaa woni Almasiihu Ɓii Laamɗo, faa si on ngoonɗinii, keɓon nguurndam saabe makko. ");
INSERT INTO fuhbkf_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Caggal ɗuum, Iisaa ɓangani taalibaaɓe muuɗum ɓeen katin sera maayo Tiberiyas. Inan no o ɓangiri: ");
INSERT INTO fuhbkf_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simon Piyeer e Tomaa noddirteeɗo Funereejo oon e Natanayel mo Kaana leydi Galili e ɓiɓɓe Jebede worɓe ɓeen e taalibaaɓe woɓɓe ɗiɗo, ɓe fuu iɓe tawdaa toon. ");
INSERT INTO fuhbkf_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simon Piyeer wi'i ɓe: —Mi yahan nanngoyde liƴƴi. Ɓe mbi'i mo: —Minen du, min njaadan e maa. Ɓe njalti, ɓe naatowi laana ndiyam. Jemma oon, ɓe keɓaay fay huunde. ");
INSERT INTO fuhbkf_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Nde pooyngol feccinoo ndeen, tawi Iisaa na darii to hunnduko maayo ngoon, ammaa taalibaaɓe ɓeen annditaay yalla wo ɗum Iisaa. ");
INSERT INTO fuhbkf_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","O wi'i ɓe: —Hey banndiraaɓe, yalla on keɓii ko nyaametee naa? Ɓe mbi'i: —Min ngalaa. ");
INSERT INTO fuhbkf_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","O wi'i ɓe: —Paɗɗee fiil oon gere nyaamo laana ka, on keɓan. Ndelle ɓe paɗɗi fiil oon. Ɓe keɓi liƴƴi faa ɓe kunngii suuwtude o. ");
INSERT INTO fuhbkf_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Taalibaajo mo Iisaa horsini oon wi'i Piyeer: —Wo ɗum Joomiraaɗo! Nde Simon Piyeer nannoo ɗum wo joomiraaɗo ndeen, ɓornii saaya muuɗum, sabo o ɓortinooɗo ley laana toon. O fitti o fiyii e ndiyam ɗaam. ");
INSERT INTO fuhbkf_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Taalibaaɓe heddiiɓe ɓeen ngaddi laana kaan, ina ndaasa fiil keewɗo liƴƴi oon. Tawi ɓe mboɗɗaa e hunnduko ndiyam ɗaam ɓuraa hono piye keme ɗiɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Nde ɓe njippinoo laana kaan ndeen, ɓe nji'i liƴƴi ina njowii dow ƴulɓe yiite, ɓe nji'i buuru du. ");
INSERT INTO fuhbkf_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Iisaa wi'i ɓe: —Ngaddee yoga e liƴƴi ɗi nannguɗon joonin ɗiin. ");
INSERT INTO fuhbkf_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simon Piyeer naati laana kaan, fooɗi fiil oon faa wurtini yaasin. O keewɗo liƴƴi mawɗi. Liƴƴi ɗiin wo hemre e capanɗe joy e tati. No ɗi poti heewude nii fuu, fiil oon seekaaki. ");
INSERT INTO fuhbkf_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Iisaa wi'i ɓe: —Ngaree, nyaamee! Fay gooto e taalibaaɓe ɓeen suusaay ƴamude mo «Aan wo a moy?» Ɓe fuu ɓe annditii wo ɗum Joomiraaɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ndeen Iisaa wari, hooƴi buuru e liƴƴi, hokki ɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ngol woni tataɓol ko Iisaa ɓangani taalibaaɓe muuɗum gaɗa ummitagol muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Nde ɓe tilinoo e fummude ndeen, Iisaa wi'i Simon Piyeer: —Simon ɓii Yuhanna, aɗa ɓuri ɓee ɗo yiɗude kam naa? O jaabii, o wi'i: —Goonga, Joomam, aɗa anndi miɗo yiɗi ma. Iisaa wi'i mo: —Nyaamnaa mbaaloy am kooy! ");
INSERT INTO fuhbkf_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Iisaa wi'i mo katin: —Simon, ɓii Yuhanna, aɗa yiɗi kam naa? O jaabii, o wi'i: —Goonga, Joomam, aɗa anndi miɗo yiɗi ma! Iisaa wi'i mo: —Nduraa baali am ɗiin! ");
INSERT INTO fuhbkf_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Iisaa wi'i mo katin: —Simon, ɓii Yuhanna, aɗa yiɗi kam naa? Piyeer sunii sabo joonin woni kilol tataɓol ko Iisaa wi'i mo «Aɗa yiɗi kam naa?» Piyeer wi'i mo: —Joomam, aɗa anndi huunde fuu, aɗa anndi miɗo yiɗi ma. Iisaa wi'i mo: —Nyaamnaa baali am ɗiin! ");
INSERT INTO fuhbkf_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Goonga kaalanammaami, e njokollaaku maa a ɓornake kaddule maa, a yehii to njiɗɗaa fuu. Ammaa si a naywii fu, a foortan juuɗe maa, de goɗɗo ɓorne ɗe, yaare to a yiɗaa. ");
INSERT INTO fuhbkf_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","E haalaaji ɗiin Iisaa sapporii no Piyeer maayrata e no teddinirta Laamɗo. Nde o haalnoo ɗum ndeen, o wi'i ɗum: —Jokkam! ");
INSERT INTO fuhbkf_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Piyeer yeeƴii, yi'i taalibaajo mo Iisaa horsini oon ina jokki ɗum'en. Oon woni bahinooɗo ɗakkol Iisaa nde ɓe kirtotonoo ndeen, de wi'i: «Joomam, moy woni jambotooɗo ma oon?» ");
INSERT INTO fuhbkf_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Nde Piyeer yiinoo taalibaajo oon ndeen, wi'i Iisaa: —Joomam, noy oo le wattinirta? ");
INSERT INTO fuhbkf_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Iisaa jaabii mo, wi'i: —Si miɗo muuyani mo nguurndam faa nde ngartoymi, ɗume jomi ma e majjum? Aan kaa, jokkam tan. ");
INSERT INTO fuhbkf_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ndelle haala ka sankitii hakkunde goonɗinɓe Iisaa ina mbi'a taalibaajo oon maayataa. Ammaa Iisaa wi'aay o maayataa, ko o wi'i dey: «Si miɗo muuyani mo nguurndam faa nde ngartoymi, ɗume jomi ma e majjum?» ");
INSERT INTO fuhbkf_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Oon woni taalibaajo ceediiɗo kulle ɗeen de winndi ɗe. Eɗen anndi du seedaaku makko oon wo goonga. ");
INSERT INTO fuhbkf_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Iisaa waɗi kulle goɗɗe keewɗe katin. Si ɗe mbinndiranooma gootel gootel, miɗo miiloo dewte ɗeen keƴidataano ley adunaaru ndu.");
INSERT INTO fuhbkf_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Banndam Tawfilus, e ley dewtere am arandeere ndeen, mi winndii ko Iisaa fuɗɗi gollude e waajaade fuu, ");
INSERT INTO fuhbkf_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","faa nyannde ƴeentinaa ndeen. Gilla nde o ƴeentinaakano ndeen o haaldii e nulaaɓe ɓe o suɓinoo ɓeen, o tindiniri ɗum'en e baawɗe Ruuhu Ceniiɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Caggal nde o torranoo ndeen, o hollitii ɓe hoore makko. O hollirii ɓe e daliiliiji keewɗi imo wuuri. O wondi e maɓɓe balɗe capanɗe nay, imo haalana ɓe kabaaru laamu Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Nyannde gomma imo nyaamda e maɓɓe, o tindini ɓe taa ɓe mboɗɗoo Urusaliima, ammaa ɓe keɗoo aadi Baabiiwo ndi ɓe narri mo ndiin. O wi'i: ");
INSERT INTO fuhbkf_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","—Yaayaa na lootirannoo yimɓe batisima e ndiyam, de onon, ley balɗe seeɗa, on lootirte batisima e Ruuhu Ceniiɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ɓe fuu ɓe kawriti, iɓe ƴama mo, iɓe mbi'a: —Joomiraaɗo, wo joonin ngartirtaa laamu Israa'iila naa? ");
INSERT INTO fuhbkf_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Iisaa jaabii ɓe, wi'i: —On mbaawaa anndude jamaanuuji e wakkatiiji ɗi Baabiiwo darniri baawɗe muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ammaa nde Ruuhu Ceniiɗo wari jippii e mooɗon fu, on keɓan baawɗe, de laatoɗon seedee'en humpitooɓe kabaaru am ley Urusaliima e ley leydi Yahuudiya fuu, kam e Samariya, faa to adunaaru haaɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Nde o haalnoo ɗum ndeen, o ƴeentinaa. Ɓe tiggitii, iɓe ndaara faa ruulde suddi mo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ɗo ɓe tiggitotoo kammu iɓe ndaara imo ƴeentinee ɗoon, inan worɓe ɗiɗo ɓe kaddule daneeje punti, ndarodii e maɓɓe, ");
INSERT INTO fuhbkf_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","mbi'i: —Galilinkooɓe, ko waɗi de ndariɗon, oɗon tiggitoo kammu? Iisaa ittaaɗo e mooɗon de ƴeentinaa dow kammu oon wartan. O wartiran hono no njiiruɗon imo ƴeentiniraa dow kammu noon. ");
INSERT INTO fuhbkf_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ndeen nulaaɓe ɓeen ndilli waamnde wi'eteende Jaytun ɗoon, ɓe njeccii Urusaliima. Toon e Urusaliima na waɗa kilomeetere gooto. ");
INSERT INTO fuhbkf_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Nde ɓe njottinoo fu, ɓe ƴeeŋowi suudu dowuuru to ɓe mbeerunoo toon. Piyeer e Yuhanna e Yaakuuba e Andire e Filipu e Tomaa e Bartolome e Matta e Yaakuuba ɓii Alfaa e Simon kiranoowo suudu baaba e Yahuuda ɓii Yaakuuba fuu tawaama ɗoon. ");
INSERT INTO fuhbkf_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ɓe fuu ɓe kawriti, ɓe laatii ɓernde wootere, iɓe tinnii e du'aare, kamɓe e minyiraaɓe Iisaa e Mariyama inna Iisaa e rewɓe woɓɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ley balɗe ɗeen, goonɗinɓe ko waɗata hono hemre e noogay kawriti. Piyeer ummii, darii hakkunde maɓɓe, wi'i: ");
INSERT INTO fuhbkf_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","—Sakiraaɓe, ina tilsi ko woni e Binndi ɗiin tabita dow Yahuuda, kolluɗo nannguɓe Iisaa laawol oon. Ruuhu Ceniiɗo haalii dow majjum e hunnduko Daawda. ");
INSERT INTO fuhbkf_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yahuuda na hiisenoo e meeɗen, o heɓii ngeɗu makko e gollal ngal ngollanten Joomiraaɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Kaalisi mo o yeenanoo e gollal makko bonngal ngaal, o soodi ɗum ngesa. O boɓɓii ley magga, reedu makko seekii, teketti makko fuu mburtii, ndufi. ");
INSERT INTO fuhbkf_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Yimɓe Urusaliima fuu nani ɗum. Ɗum waɗi de ɓe inndiri ngesa ngaan Akeldama. E ley ɗemngal maɓɓe iɗum fiirta «Ngesa Ƴiiƴam». ");
INSERT INTO fuhbkf_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Si goonga du, dewtere Jabuura haalii e dow majjum, wi'i: «Wuro makko laatoo winnde, taa fay gooto hoɗa toon.» Ina winndaa du: «Goɗɗo loomta mo.» ");
INSERT INTO fuhbkf_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Wooɗi ndelle, tilay goɗɗo loomta mo, tawee wo gonduɗo e meeɗen ko juuti wakkati mo Joomiraaɗo men Iisaa wondunoo e meeɗen ndeen. ");
INSERT INTO fuhbkf_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Ɗum wo gilla nde Yaayaa lootunoo mo lootagal batisima faa yaade nyannde nde o ƴeentinaa dow kammu ndeen. Gorko oon laatodoto e meeɗen seedee ummitagol Iisaa. ");
INSERT INTO fuhbkf_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ndeen ɓe ndarni worɓe ɗiɗo: Yuusufi bi'eteeɗo Barasaba coowirteeɗo Yustus, kam e Matiyas. ");
INSERT INTO fuhbkf_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ɓe ndu'ii, ɓe mbi'i: —Joomiraaɗo, aan annduɗo ɓerɗe yimɓe fuu, faamin min mo cuɓiɗaa e ɓee ɗo ɗiɗo ");
INSERT INTO fuhbkf_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","faa ronndoo gollal nulal, loomta Yahuuda joppuɗo ɗum de yehi nokku to jeyi yahude toon. ");
INSERT INTO fuhbkf_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ɓe ngaɗi cumnal maɓɓe. Cumnal ngaal hawri e Matiyas. O hiisodaa e nulaaɓe sappo e ngo'o ɓeen. ");
INSERT INTO fuhbkf_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Nde iidi ɓenndal alkama warnoo ndeen, tawi goonɗinɓe Iisaa ɓeen fuu ina kawriti nokku gooto. ");
INSERT INTO fuhbkf_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Wakkati gooto, sawtu ga'uɗo hono henndu mawndu ƴuuri dow kammu, heewi suudu ɗo ɓe njooɗii ɗoon fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ko wa'i hono ɗemle yiite ni ɓangani ɓe. Ɗe peccii, ɗe njowii dow mono e maɓɓe fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ɓe fuu ɓe keewi Ruuhu Ceniiɗo, ɓe puɗɗi haalude ɗemle janane no Ruuhu oon hokkiri ɓe kaalda noon. ");
INSERT INTO fuhbkf_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Tawi worɓe Alhuudiyankooɓe hulɓe Laamɗo ƴuuruɓe e leyɗe adunaaru fuu ina njooɗii Urusaliima. ");
INSERT INTO fuhbkf_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Nde sawtu oon waɗunoo ndeen, jamaa oon fuu hawriti. Ɗum jiiɓii hakkillooji maɓɓe, sabo mono fuu nanii ɗemngal muuɗum ina haalee. ");
INSERT INTO fuhbkf_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ɓe fuu ɓe mbemmbaa, ɗum haaynii ɓe, iɓe mbi'undura: —Haalooɓe ɓe fuu nganaa Galilinkooɓe naa? ");
INSERT INTO fuhbkf_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ndelle, noy mono e meeɗen fuu nanirta ko ɓe kaalata e ɗemngal ngal muyni? ");
INSERT INTO fuhbkf_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","En Partiyankooɓe e Mediyankooɓe e Elamiyankooɓe, en jooɗiiɓe Mesopotami, kam e Yahuudiya e Kapadokiya e Ponta e Aasiya ");
INSERT INTO fuhbkf_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","e Firigiya e Pamfiliya e Misira e leyɗe sera Libiya ɗakkol Sireene. Woɓɓe meeɗen ƴuurii Roma. En Alhuudiyankooɓe, kam e naatuɓe diina Alhuudiyankooɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Woɓɓe katin ƴuurii Kereta, woɓɓe ƴuurii leydi Arabiya. Ammaa ɗum e laataade fuu, en fuu eɗen nana iɓe kaala haala golleeji mawɗi ɗi Laamɗo waɗi ɗiin. Iɓe kaala ɗum fuu e ɗemle meeɗen! ");
INSERT INTO fuhbkf_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ɗum haaynii ɓe ɓe fuu, ɗum haɓɓi ɓe ko'e, iɓe ƴamundura: —Ɗume woni maanaa majjum? ");
INSERT INTO fuhbkf_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Woɓɓe ina njalnoroo goonɗinɓe ɓeen, ina mbi'a: —Ɓe kaaru doro de ɓe culii! ");
INSERT INTO fuhbkf_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ndeen Piyeer darodii e sappo e ngo'o ɓeen, ɓanti daande muuɗum, de wi'i jamaa oon: —Onon Alhuudiyankooɓe e jooɗiiɓe Urusaliima fuu, kettinee haala am de paamon kabaaru gaɗuɗo oon. ");
INSERT INTO fuhbkf_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Yimɓe ɓe nganaa suliiɓe hono no miilortoɗon ni. Joonin fay yamnde jeenay beetee faltaaki, sakko neɗɗo yara faa suloo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ammaa ɗum warii faa tabintina ko annabi Jowiila wi'i: ");
INSERT INTO fuhbkf_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","«Laamɗo wi'ii: E ley balɗe cakitotooɗe ɗe mi jippinan Ruuhu am dow tagaaɓe fuu. Ɓiɓɓe mooɗon worɓe e rewɓe kaaliran annabaaku. Jokolɓe mooɗon nji'an holleede, nayeeɓe mooɗon koyɗinte. ");
INSERT INTO fuhbkf_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Wooɗi gollooɓe am worɓe e rewɓe du, mi jippinan Ruuhu am dow muɓɓen e ley balɗe ɗeen, ɓe kaaldan annabaaku. ");
INSERT INTO fuhbkf_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Mi waɗan kaayeefiiji dow kammu, mi waɗan maandeeji kaayniiɗi dow leydi, ɗi laatoo ƴiiƴam e yiite e cuurki. ");
INSERT INTO fuhbkf_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Fadde nyalaande gartol Joomiraaɗo mawnde teddunde ndeen warude, naange niɓɓinte, lewru du wojjan hono no ƴiiƴam ni. ");
INSERT INTO fuhbkf_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ndeen, neɗɗo fuu nodduɗo innde Joomiraaɗo hisinte.» ");
INSERT INTO fuhbkf_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Piyeer wi'i katin: —Israa'iilankooɓe, kettinee haalaaji ɗi: Iisaa Nasaraatuujo oon wo neɗɗo mo Laamɗo laaɓinani on wo ƴuurɗo e muuɗum. Laamɗo hokki ɗum baawɗe, hokki ɗum waɗude kaayeefiiji e maandeeji kaayniiɗi hakkunde mooɗon, hono no onon e ko'e mon anndirɗon ni. ");
INSERT INTO fuhbkf_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Neɗɗo oon, Laamɗo muuynoo gilla arande wattee e juuɗe mon. Onon le, on nduŋanake mo yimɓe ɓe anndaa jamirooje, on tontii mo, on mbarii mo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ammaa Laamɗo iirtinii mo, itti mo e naawalla maayde, sabo maayde ndeen waawaano tiigaade mo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Si goonga du, inan ko Daawda haali dow makko, wi'i: «Wakkati fuu miɗo yi'a Joomiraaɗo na wondi e am. Imo woni gere nyaamo am, faa taa mi diwna kulol. ");
INSERT INTO fuhbkf_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Saabe majjum ɓernde am seyake, ɗemngal am na mana, faa ɓanndu am du waaltoo dow jikke celluɗo, ");
INSERT INTO fuhbkf_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","sabo a yoppataa yonki am hakkunde maayɓe, a accataa Ceniiɗo maa oon nyola. ");
INSERT INTO fuhbkf_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","A anndinii kam laabi nguurndam, a hebbinan kam seyo sabo aɗa wondi e am.» ");
INSERT INTO fuhbkf_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Piyeer ɓeydi katin, wi'i: —Sakiraaɓe, miɗo haalana on laaɓal haala maami en Daawda: o maayii, o uwaama, saabeere makko ndeen ina woni ɗo meeɗen ɗo faa hannden. ");
INSERT INTO fuhbkf_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ammaa wo o annabaajo, imo anndi Laamɗo hunanake mo gooto e taaniraaɓe makko loomtan laamu makko. ");
INSERT INTO fuhbkf_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","O yi'ii ko warata, o haali haala ummitagol Almasiihu. O wi'i yonki muuɗum accataake hakkunde maayɓe, ɓanndu muuɗum du nyolataa. ");
INSERT INTO fuhbkf_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Oon woni Iisaa mo Laamɗo ummintini, min fuu miɗen ceedii. ");
INSERT INTO fuhbkf_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Laamɗo ɓantii mo, heedinii mo gere nyaamo muuɗum. O heɓi e Baabiiwo Ruuhu Ceniiɗo hono no aadorinoo noon, o saaki ɗum. Joonin oɗon nji'a ɗum, oɗon nana ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Sabo Daawda meeɗaay ƴeentude dow kammu, ammaa wi'ii: «Joomiraaɗo wi'i Joomam: Jooɗa gere nyaamo am, ");
INSERT INTO fuhbkf_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","faa mi waɗa njaaɓaa wayɓe ma.» ");
INSERT INTO fuhbkf_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Lenyol Israa'iila fuu tannyora: Iisaa mo tontuɗon e leggal palaangal oon, Laamɗo waɗii ɗum Joomiraaɗo, waɗii ɗum Almasiihu. ");
INSERT INTO fuhbkf_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Nde ɓe nannoo haala kaan ndeen, ka yuwi ɓerɗe maɓɓe sanne, ɓe mbi'i Piyeer e nulaaɓe heddiiɓe ɓeen: —Sakiraaɓe, ɗume min kaani waɗude? ");
INSERT INTO fuhbkf_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Piyeer jaabii ɓe, wi'i: —Tuubee, gooto mooɗon fuu lootiree lootagal batisima e innde Iisaa Almasiihu, faa lutti mooɗon njaafee. Ndeen Laamɗo hokkan on Ruuhu Ceniiɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Sabo Laamɗo waɗanii on aadi, onon e ɓiɓɓe mooɗon e yimɓe woɗɗuɓe fuu. Indi woodani neɗɗo mo Laamɗo Joomiraaɗo meeɗen noddi fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Caggal ɗuum, Piyeer gongini ɓe haalaaji goɗɗi keewɗi, ina waajoo ɓe, ina wi'a: —Ndeenee ko'e mon e yimɓe jamaanu oonyiiɗo o. ");
INSERT INTO fuhbkf_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Jaɓuɓe haala makko ɓeen lootaa lootagal batisima. Nyannde ndeen, yimɓe hono ujunaaje tato naati e kawrital goonɗinɓe ngaal. ");
INSERT INTO fuhbkf_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Iɓe tinnoo e waaju nulaaɓe ɓeen, iɓe nanngunduri e gondal goonɗinɓe ngaal, iɓe keltoo buuru, iɓe ngaɗida du'aawuuji. ");
INSERT INTO fuhbkf_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Kulol naati e mono fuu, sabo nulaaɓe ɓeen ina ngaɗa kaayeefiiji e maandeeji kaayniiɗi keewɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Goonɗinɓe ɓeen fuu na kawti. Ko ɓe njogii fuu, wo ɓe kawtu. ");
INSERT INTO fuhbkf_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Iɓe conna jawdi maɓɓe, iɓe kokka mono fuu ko haajaa. ");
INSERT INTO fuhbkf_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Nyannde fuu ɓe kawritan ley suudu dewal mawndu nduun, iɓe laatii ɓernde wootere. Iɓe keltoo buuru, iɓe nyaamda ley cuuɗi maɓɓe e seyo e ɓerɗe laaɓuɗe. ");
INSERT INTO fuhbkf_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Iɓe njetta Laamɗo, yimɓe fuu ina njiɗi ɓe. Nyannde fuu Joomiraaɗo ina ɓeydana kawrital ngaal hisinaaɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Piyeer e Yuhanna naaddi ley suudu dewal mawndu wakkati du'aare yamnde tati. ");
INSERT INTO fuhbkf_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Tawi gorko dimdaaɗo e bonngaaku ina yaaree to dammbugal suudu dewal mawndu bi'eteengal Dammbugal Lobbal. Nyannde fuu yimɓe makko ina njoƴƴina mo ɗoon faa o garbina naatooɓe suudu dewal mawndu ɓeen sadaka. ");
INSERT INTO fuhbkf_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Nde o yi'unoo Piyeer e Yuhanna ina naata ndeen, o garbini ɗum'en. ");
INSERT INTO fuhbkf_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ɓe ndaari mo, de Piyeer wi'i: —Ndaaru min! ");
INSERT INTO fuhbkf_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Gorko oon ndaari ɓe faa wooɗi, sabo na miilii hemrude ɓe huunde. ");
INSERT INTO fuhbkf_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","De Piyeer wi'i: —Mi walaa cardi, mi walaa kaŋŋe, ammaa mi hokkete ko njogiimi ɗuum: e dow innde Iisaa Almasiihu Nasaraatuujo oon, umma yahu! ");
INSERT INTO fuhbkf_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","O nanngi junngo muuɗum nyaamo, o ummini ɗum. Wakkati gooto, koyɗe muuɗum e kolɓule mum celli. ");
INSERT INTO fuhbkf_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","O gurbitii, o darii, imo yaha! O naatidi e maɓɓe ley suudu dewal mawndu nduun, imo yaha, imo fitta, imo yetta Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Yimɓe ɓeen fuu nji'i mo, imo yaha, imo yetta Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ɓe annditi wo kanko jooɗotonoo to dammbugal bi'eteengal Lobbal ngaal ina garbina. Kaayeefi e wemmbere nanngi ɓe sanne saabe ko o heɓi ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Neɗɗo oon na takkii Piyeer e Yuhanna ɗoon sanne. Yimɓe ɓeen fuu ndoggi, kawriti e maɓɓe to danki mbi'eteeki danki Suleymaana no huunde nde foti haaynaade ɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Nde Piyeer yiinoo ɗum fu, wi'i yimɓe ɓeen: —Israa'iilankooɓe, ko waɗi de iɗum haaynii on? Ko waɗi de oɗon tufi min gite? Si goonga, wanaa baawɗe amin naa kulol amin Laamɗo waɗi de gorko o ina yaha e koyɗe muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Laamɗo Ibrahiima e Isiyaaka e Yaakuuba, Laamɗo maamiraaɓe meeɗen, teddini golloowo muuɗum Iisaa. Onon kaa, on ngattii mo e juuɗe laamu, on calake mo yeeso Pilaatu, fay si taweede Pilaatu ina yiɗi yoofude mo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Onon, on calake Ceniiɗo Ponnditiiɗo oon. On nyaagake njoppaneɗon gaɗɗo war-hoore. ");
INSERT INTO fuhbkf_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Jom Nguurndam oon mbaruɗon. Ammaa Laamɗo iirtini mo e maayde. Miɗen ceedii ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Wo saabe goonɗinal Iisaa e baawɗe innde muuɗum waɗi de gorko o daɗi. Oɗon nji'a mo, oɗon anndi no o worrunoo du. Ayyo, hoolaare Iisaa ndeen waɗi de o laatii celluɗo kiɓɓuɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Wooɗi, sakiraaɓe, ko onon e hooreeɓe mooɗon ngaɗuɗon Almasiihu ɗuum, miɗo anndi wo saabe majjere tan. ");
INSERT INTO fuhbkf_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ammaa hono noon Laamɗo tabintiniri ko annabaaɓe muuɗum fuu kaali ɗuum: Almasiihu torroto. ");
INSERT INTO fuhbkf_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ndelle tuubee, ngarton, faa lutti mooɗon mooytee. ");
INSERT INTO fuhbkf_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ndeen Joomiraaɗo waddanan on wakkatiiji powtiri e ndakam. O nuldan on Almasiihu mo o suɓanii on gilla arande, oon woni Iisaa. ");
INSERT INTO fuhbkf_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ina tilsi o heddoo dow kammu faa nde Laamɗo heyɗintini kulle ɗeen fuu, no annabaaɓe seniiɓe ɓeen kaaldunoo haala majjum gilla arande noon. ");
INSERT INTO fuhbkf_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Sabo Muusaa wi'ii: «Laamɗo Joomiraaɗo mooɗon nuldan on annabaajo hono am, sakiike mooɗon. Njaɓon huunde fuu ko o haalanta on. ");
INSERT INTO fuhbkf_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Neɗɗo fuu mo jaɓanaay annabaajo oon, yaltinte e yimɓe Laamɗo, de halkee.» ");
INSERT INTO fuhbkf_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Gilla e Samuwiila faa e annabaaɓe warɓe caggal muuɗum, ɓe fuu ɓe kaalii haala nyalaaɗe ɗe. ");
INSERT INTO fuhbkf_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Onon ngoni ronooɓe annabaaɓe ɓeen, onon ngoni ronooɓe amaana mo Laamɗo nanngani maamiraaɓe men ɓeen nde wi'unoo Ibrahiima: «Wo e ƴuwdi maa lenyi adunaaru ndu fuu keɓirta barke.» ");
INSERT INTO fuhbkf_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Nde Laamɗo ummintinnoo Iisaa golloowo muuɗum oon fu, wo e mooɗon o artii nulde ɗum. O nuli ɗum faa o barkina on e ley ko o ooncata mono fuu yoppa golleeji muuɗum bonɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Nde Piyeer e Yuhanna kaaldannoo e yimɓe ɓeen ndeen, almaami'en e mawɗo ndaarooɓe suudu dewal mawndu, kam e Saduki'en, ngari to maɓɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Iɓe mettaa sabo Piyeer e Yuhanna ina njanngina yimɓe ina mbaajoo ɗum'en Laamɗo umminan maayɓe sabo iirtinii Iisaa. ");
INSERT INTO fuhbkf_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ɓe nanngi ɓeen, ɓe ommbi ɗum'en e kasu faa jaango muuɗum, sabo tawii hiiriino. ");
INSERT INTO fuhbkf_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ammaa yimɓe heewɓe e nanɓe waaju oon ɓeen ngoonɗinii, faa waɗi hono worɓe ujunaaje njoyo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Jaango majjum, hooreeɓe maɓɓe e mawɓe e jannginooɓe Tawreeta kawritowi Urusaliima. ");
INSERT INTO fuhbkf_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Almaami Mawɗo bi'eteeɗo Annas na tawaa toon, wooɗi du Kayafas e Yuhanna e Alesandere e ƴuwdi hooreeɓe almaami'en ndiin fuu na toon. ");
INSERT INTO fuhbkf_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ɓe ndarni Piyeer e Yuhanna yeeso maɓɓe, ɓe ƴami ɗum'en e dow baawɗe ɗeye naa innde ndeye ɓe celliniri bonnguujo oon. ");
INSERT INTO fuhbkf_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ndeen, Piyeer keewɗo Ruuhu Ceniiɗo wi'i ɓe: —Hooreeɓe yimɓe e mawɓe, ");
INSERT INTO fuhbkf_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","si on ƴamtii min hannden moƴƴere nde min ngaɗani bonnguujo o fu, on ƴamii min no o danniraa, ");
INSERT INTO fuhbkf_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","oɗon njeyi anndineede ɗum ɗo, onon e Israa'iilankooɓe fuu: Wo saabe Iisaa Almasiihu Nasaraatuujo gorko o darorii yeeso mooɗon wo daɗuɗo. On tontiino Iisaa oon, ammaa Laamɗo iirtinii ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Kam woni mo Joomiraaɗo wi'i: «Hayre nde onon nyiɓooɓe caliɗon, wo kayre laatii hoore nyimngo ngoon.» ");
INSERT INTO fuhbkf_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Kisindam heɓirtaake e goɗɗo fay gooto. Laamɗo hokkaay yimɓe innde wonnde fuu ley adunaaru ndu faa keɓiren kisindam. ");
INSERT INTO fuhbkf_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Nde waalde Saahiiɓe yi'unoo cuusal Piyeer e Yuhanna fu, ɗum haaynii ɓe, sabo ɓe paamii ɓeen wo laddeeɓe, nganaa jannguɓe. Ɓe annditi ɓeen ina ngondunoo e Iisaa. ");
INSERT INTO fuhbkf_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ammaa nde ɓe njiinoo gorko cellinaaɗo oon ina darii yeeso maɓɓe, walaa fuu ko ɓe mbaawi yeddude. ");
INSERT INTO fuhbkf_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ɓe njamiri Piyeer e Yuhanna njalta sarorde ndeen. Iɓe ndawrida, ");
INSERT INTO fuhbkf_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","iɓe mbi'a: —Ɗume ngaɗeten worɓe ɗiɗo ɓe? Si goonga, wonɓe Urusaliima fuu tabintinii ɓe ngaɗii maande haayniinde. Katin du en mbaawaa yeddude ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Joonin kaa, ɗum haanaa sankitaade e ley yimɓe. Ndelle cappanen ɓe, kaɗen ɓe haalande fay gooto innde Iisaa ndeen. ");
INSERT INTO fuhbkf_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ndeen ɓe nodditi ɗum'en katin, ɓe cappani ɗum'en taa mbaajoo, taa njanngina innde Iisaa fey. ");
INSERT INTO fuhbkf_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ammaa Piyeer e Yuhanna njaabii ɓe, mbi'i: —Onon e ko'e mooɗon ndaaree ko ɓuri woodde yeeso Laamɗo, min ɗowtanoo on, naa min ɗowtanoo Laamɗo? ");
INSERT INTO fuhbkf_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Minen kaa, min mbaawaa selude haalde ko min njiiri gite amin e ko min naniri noppi amin. ");
INSERT INTO fuhbkf_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ɓe cappani ɗum'en katin, de ɓe njoofi ɗum'en. Ɓe keɓaay fuu ko ɓe njukkoroo ɗum'en, sabo yimɓe ɓeen fuu na njetta Laamɗo dow ko waɗi ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Danniraaɗo haaynde ndeen oon, duuɓi muuɗum ina ɓuri capanɗe nay. ");
INSERT INTO fuhbkf_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Nde Piyeer e Yuhanna njoppanoo ndeen, njeccii to yimɓe muɓɓen, kaalani ɓe ko hooreeɓe almaami'en e mawɓe mbi'i ɗum'en fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Nde ɓe nannoo ɗum ndeen, ɓe ƴepti daaɗe maɓɓe to Laamɗo e ɓernde wootere, ɓe mbi'i: —Laamɗo Joomiraaɗo, aan tagi kammu e leydi e maayo manngo e ko woni e muɓɓen fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Aan du haaliri dow baawɗe Ruuhu Ceniiɗo e hunnduko maama amin Daawda, golloowo maa oon, de wi'i: «Ko saabii de lenyi na peekoroo mawnitaare? Ko saabii de yimɓe na miiloo miilooji ɓoli? ");
INSERT INTO fuhbkf_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Kaanankooɓe adunaaru ndaranake wolde, ardiiɓe kawriti faa kaɓa e Joomiraaɗo e Almasiihu muuɗum.» ");
INSERT INTO fuhbkf_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Ɗum wo goonga, sabo ley ngalluure ndeen Hirudus e Pontiyu Pilaatu nanngunduri e Israa'iilankooɓe e lenyi goɗɗi faa kaɓa e Iisaa, golloowo maa ceniiɗo mo cuɓiɗaa oon. ");
INSERT INTO fuhbkf_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Hono nii ɓe ngolliri ko podinoɗaa baawɗe maa e muuyɗe maa fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Joonin Joomiraaɗo, ndaar gidi maɓɓe ɗiin. Kokkaa gollooɓe maa waajoraade haala maa e cuusal manngal. ");
INSERT INTO fuhbkf_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ɓangin baawɗe maa, ndannaa nyawɓe, ngaɗaa maandeeji kaayniiɗi e kaayeefiiji saabe Iisaa, golloowo maaɗa ceniiɗo oon. ");
INSERT INTO fuhbkf_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Nde ɓe tilinoo nyaagaade Laamɗo ndeen, nokkuure ɗo ɓe kawriti ɗoon dimmbii. Ɓe fuu ɓe kebbinaa Ruuhu Ceniiɗo, iɓe mbaajoo konngol Laamɗo e cuusal. ");
INSERT INTO fuhbkf_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Jamaa goonɗinɓe oon fuu wo ɓernde wootere, wo hakkillo wooto. Ko ɓe njogii fuu ɓe kawtu. Fay gooto maɓɓe wi'ataa fay huunde e jawdi muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Nulaaɓe ɓeen ina ceedoroo ummitagol Iisaa Joomiraaɗo e baawɗe mawɗe. Moƴƴere mawnde ina woni e maɓɓe ɓe fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Fay gooto maɓɓe waasaay, sabo jogiiɓe gese e galleeji fuu ina conna, ina ngadda ceede ɗeen to nulaaɓe. Ndeen mono e maɓɓe fuu ina hokkee ko haajaa. ");
INSERT INTO fuhbkf_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ina woodi ɗoon goɗɗo bi'eteeɗo Yuusufi, mo nulaaɓe ɓeen coowirannoo Barnabas (ɗum na fiirta «Ɓii cellinoowo ɓerɗe»). Wo o ƴuuruɗo e lenyol Lewi, dimaaɗo Kipirus. ");
INSERT INTO fuhbkf_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Imo woodunoo ngesa. O sonni nga, o waddi ceede ɗeen to nulaaɓe ɓeen. ");
INSERT INTO fuhbkf_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Gorko gomma bi'eteeɗo Ananiyas e deekum Safiira, kam'en du conni ngesa muɓɓen. ");
INSERT INTO fuhbkf_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","O suuɗi feccere ceede ɗeen, tawi deekiiko oon ina anndi. O yaari ko heddii ɗuum, o hokki nulaaɓe ɓeen. ");
INSERT INTO fuhbkf_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Piyeer wi'i: —Ananiyas, ko waɗi de Seyɗaani heewi ɓernde maa faa penanɗaa Ruuhu Ceniiɗo, cuuɗuɗaa feccere coggu ngesa ngaan? ");
INSERT INTO fuhbkf_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Wo aan e hoore maa jeynoo nga. Ko connuɗaa nga ɗuum du, wo aan jeyi ceede ɗeen. Ndelle ko waɗi de anniyiɗaa waɗude ni? Wanaa yimɓe penanɗaa koy, wo Laamɗo penanɗaa! ");
INSERT INTO fuhbkf_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Nde Ananiyas nannoo haala kaan fu, saami, maayii. Ɗum laatanii nanɓe ɗum ɓeen fuu kulol manngol. ");
INSERT INTO fuhbkf_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Jokolɓe ummii, ngatti mo e kasanke, ndonndii mo, njaltini yaasin, uwi mo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Hono leeruuji tati caggal ɗuum, deekiiko naati, tawi nanaay ko waɗi ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Piyeer wi'i mo: —Haalanam yalla wo ɗum jaati connuɗon ngesa mooɗon ngaan naa? O wi'i: —Ayyo, nii foti. ");
INSERT INTO fuhbkf_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ndeen Piyeer wi'i mo: —Noy de aan e gora dewruɗon faa ndaartindoɗon Ruuhu Joomiraaɗo? Inan, uwoyɓe gora ina ngara, faa ɓe njaare, aan du! ");
INSERT INTO fuhbkf_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","De wakkati gooto, kanko du, o saami yeeso Piyeer, wo o maayɗo. Jokolɓe ɓeen naati, tawi o maayii. Ɓe ndonndii mo, ɓe njaltini yaasin, ɓe uwi mo ɗakkol goriiko. ");
INSERT INTO fuhbkf_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Kulol manngol nanngi kawrital goonɗinɓe e nanɓe ɗum fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Nulaaɓe ɓeen ina ngaɗa maandeeji kaayniiɗi e kaayeefiiji keewɗi hakkunde yimɓe. Tawi goonɗinɓe ɓeen fuu ina kawrita ley danki Suleymaana kiin, ɓe fuu ɓe ɓernde wootere. ");
INSERT INTO fuhbkf_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Yimɓe heddiiɓe ɓeen, fay gooto e muɓɓen suusaa hawtude e maɓɓe. Ammaa yimɓe ɗoon na teddina ɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Goonɗinɓe Joomiraaɗo ɓeen ina ɓeydoroo yimɓe heewɓe, worɓe e rewɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Faa ɗum hewtini yimɓe waddoyde nyawɓe, iɓe mburtina ɗum'en dow laabi, iɓe mballina ɗum'en e dow leese e daage, faa nde Piyeer waroyi fu, ɗowki muuɗum meema yoga maɓɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Yimɓe heewɓe ƴuuri e gure piiliiɗe Urusaliima, ngaddi nyawɓe e wonduɓe e ginnaaji. Ɓeen fuu ndannaa. ");
INSERT INTO fuhbkf_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ndeen, Almaami Mawɗo e battaa'en muuɗum ɓeen, ɗum woni Saduki'en, keewi kiram. ");
INSERT INTO fuhbkf_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ɓe nanngi nulaaɓe ɓeen, ɓe ommbi ɗum'en ley kasu. ");
INSERT INTO fuhbkf_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ammaa e jemma oon, maleyka Joomiraaɗo gooto omti dammbuɗe kasu ɗeen, wurtini ɓe, wi'i: ");
INSERT INTO fuhbkf_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","—Njehee ndarowee ley suudu dewal mawndu toon, mbaajoɗon yimɓe haala nguurndam goongalajam ɗam fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Nde ɓe nannoo ko maleyka oon wi'i fu, ɓe njehi, ɓe naatowi suudu dewal mawndu nduun gilla fajiri, iɓe njanngina. Ndeen Almaami Mawɗo oon e battaa'en muuɗum noddi waalde Saahiiɓe e mawɓe Israa'iila fuu batu. Ɓe njamiri nulaaɓe ɓeen ittowee to kasu toon, ngaddee. ");
INSERT INTO fuhbkf_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ammaa nde doomooɓe ɓeen njottinoo ndeen, tawaay ɓe e ley kasu toon. Ɓe njeccii, ɓe kaaltani waalde Saahiiɓe ɓeen, ɓe mbi'i: ");
INSERT INTO fuhbkf_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","—Min tawii kasu nguun ina uddii ina sokii, doomooɓe ɓeen ina keddii yaasin ina kuccunduri e dammbuɗe ɗeen, ammaa nde min udditinnoo ndeen, min tawaay fay gooto ley toon. ");
INSERT INTO fuhbkf_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Nde mawɗo doomooɓe suudu dewal mawndu oon e hooreeɓe almaami'en ɓeen nannoo ɗum fu, ɓe mbemmbaa, ɓe kunngii faamude fuu ko ɗum waawi laataade. ");
INSERT INTO fuhbkf_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ndeen goɗɗo wari, humpiti ɓe, wi'i: —Inan, worɓe ɓe ommbunoɗon ley kasu ɓeen, ina ndarii ley suudu dewal mawndu, ina njanngina yimɓe! ");
INSERT INTO fuhbkf_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ndeen, mawɗo doomooɓe oon yaadi e doomooɓe ɓeen, ngartiri nulaaɓe ɓeen. Ammaa ɓe ngaɗiraay ɗum doole sabo iɓe kula taa yimɓe paɗɗa ɓe kaaƴe. ");
INSERT INTO fuhbkf_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Nde ɓe ngartirnoo nulaaɓe ɓeen fu, ɓe ndarni ɗum'en yeeso waalde Saahiiɓe ndeen. Almaami Mawɗo oon ƴami ɓe, ");
INSERT INTO fuhbkf_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","wi'i: —Min cappanii on sappannde sattunde, taa mbaajoɗon e innde gorko oon. De ndaaree ko ngaɗuɗon! On cankitii waaju mooɗon oon ley Urusaliima fuu. Katin du, oɗon njiɗi yowude dow amin wareede gorko oon. ");
INSERT INTO fuhbkf_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Piyeer e nulaaɓe ɓeen njaabii, mbi'i: —Ina tilsi neɗɗo ɗowtanoo Laamɗo, wanaa yimɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Laamɗo maamiraaɓe meeɗen iirtinii Iisaa mo tontuɗon e leggal de mbarɗon ɗum oon. ");
INSERT INTO fuhbkf_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Wo kanko Laamɗo teddini faa toowni, de joƴƴini mo gere nyaamo muuɗum. Laamɗo waɗi mo hooreejo, waɗi mo kisinoowo faa o hokka Israa'iilankooɓe no tuubira, faa keɓa yaafaneede lutti muɓɓen. ");
INSERT INTO fuhbkf_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Minen ngoni seedeeɓe kabaaruuji ɗiin. Ruuhu Ceniiɗo mo Laamɗo hokki ɗowtaniiɓe ɗum du na seedii ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Nde waalde Saahiiɓe ɓeen nannoo ɗum ndeen, tikki sanne, anniyii warude ɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ammaa ina woodi toon gorko jeyaaɗo e waalde Farisa'en bi'eteeɗo Gamaliyel, jannginoowo Tawreeta Muusaa, tedduɗo e yimɓe fuu. Gorko oon ummii, darii hakkunde waalde Saahiiɓe ndeen, yamiri nulaaɓe ɓeen njaltinee seeɗa. ");
INSERT INTO fuhbkf_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Caggal ɗuum, o wi'i ɓe: —Israa'iilankooɓe, ndeenee ko'e mon e yimɓe ɓe, e ko anniyiɗon waɗude ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ɓooyaay ko Tewdas ɓangunoo. Imo jogorinoo hoore makko won ko o laatii. Ko waɗata yimɓe keme nayo ina njokkunoo mo. O waraama, jokkunooɓe mo ɓeen fuu cankitake, de ɗum fuu laatake ɓolum. ");
INSERT INTO fuhbkf_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Caggal makko, Yahuuda Galilinkeejo oon wariino wakkati limgal. Yimɓe heewɓe njokki ɗum. Kam du halkaa, jokkuɓe ɗum ɓeen fuu cankitii. ");
INSERT INTO fuhbkf_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Joonin, miɗo haalana on: accee yimɓe ɓeen, celon ɓe. Sabo si anniyaaji maɓɓe e golle maɓɓe to yimɓe ƴuuri fu, ɗum fiirtoto. ");
INSERT INTO fuhbkf_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ammaa si tawii to Laamɗo ɗum ƴuuri du, on mbaawaa sakkaade ɗum. Kaybee, taa on kaɓu e Laamɗo! ");
INSERT INTO fuhbkf_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Waalde Saahiiɓe ndeen jaɓi dabare makko. Ɓe nodditi nulaaɓe ɓeen, ɓe piyi ɗum'en, ɓe cappani ɗum'en taa kaala e dow innde Iisaa katin, ɓe njoofi ɗum'en. ");
INSERT INTO fuhbkf_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Nulaaɓe ɓeen ndilli yeeso waalde Saahiiɓe ndeen. Ɓe ceyii sabo Laamɗo ndaardii ɓe iɓe poti huyfineede saabe innde Iisaa. ");
INSERT INTO fuhbkf_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Nyannde fuu ɓe njoppaay waajaade e jannginde Kabaaru Lobbo haala Iisaa Almasiihu kaan ley suudu dewal mawndu e ley galleeji. ");
INSERT INTO fuhbkf_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","E balɗe ɗeen, tawi taalibaaɓe ɓeen ina ɓeydoo heewude. Alhuudiyankooɓe haalooɓe geresankoore mbuykani Alhuudiyankooɓe haalooɓe ibraninkoore, mbi'i kam'en kaa, rewɓe muɓɓen ɓe goriraaɓe muɓɓen maayi ɓeen njeɗataake ko njeyi heɓude e neema nyannde fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Nulaaɓe sappo e ɗiɗo ɓeen noddi jamaa goonɗinɓe oon fuu, mbi'i: —Min kaanaa yoppude konngol Laamɗo faa min peccana yimɓe nyaamdu. ");
INSERT INTO fuhbkf_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Sakiraaɓe, cuɓee hakkunde mooɗon worɓe njeɗɗo anndiraaɓe ko wooɗi, heewɓe Ruuhu Ceniiɗo e hakkillo, faa min kalfina ɗum'en gollal ngaal. ");
INSERT INTO fuhbkf_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Minen kaa, accon min tinnoo e du'aare e waajaade konngol Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Haala kaan weli goonɗinɓe ɓeen fuu. Ndeen ɓe cuɓii Etiyen, gorko keewɗo goonɗinal e Ruuhu Ceniiɗo, kam e Filipu e Porokor e Nikanor e Timon e Parmena e Nikolas, jeyaaɗo Antiyoki naatuɗo e diina Alhuudiyankooɓe oon. ");
INSERT INTO fuhbkf_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ɓe ngaddi suɓaaɓe ɓeen yeeso nulaaɓe. Ɓeen njowi juuɗe muɓɓen e dow maɓɓe, ndu'anii ɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Konngol Laamɗo ina yaaja yaade. Taalibaaɓe ina ɓeydoo heewude sanne e ley Urusaliima. Almaami'en heewɓe ngoonɗini Iisaa. ");
INSERT INTO fuhbkf_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Etiyen, kebbinaaɗo moƴƴere e baawɗe Laamɗo oon, ina waɗa kaayeefiiji e maandeeji kaayniiɗi mawɗi hakkunde yimɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ammaa yimɓe woɓɓe ngari ndukidi e Etiyen. Ɓeen ngoni jeyaaɓe e waajordu wi'eteendu waajordu rimɗinaaɓe. Ley maɓɓe ina woodi ƴuuruɓe Sireene e Alesandiri e Silisi e Aasiya. ");
INSERT INTO fuhbkf_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ammaa ɓe kunngii jaalaade mo sabo imo haalda e maɓɓe hakkilantaaku e Ruuhu. ");
INSERT INTO fuhbkf_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ndeen ɓe nyoƴƴi yimɓe mbi'a nanii imo mbonkoo Muusaa e Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Nii ɓe umminiri hakkillooji jamaa oon e mawɓe ɓeen e jannginooɓe Tawreeta ɓeen. Ɓe ngari, ɓe nanngi Etiyen, ɓe njaari ɗum to waalde Saahiiɓe toon. ");
INSERT INTO fuhbkf_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ɓe ngaddi seedeeɓe fewreeɓe, ina mbi'a: —Gorko o selataa wi'ude ko boni dow wuro seniingo ngo e Tawreeta Muusaa. ");
INSERT INTO fuhbkf_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Min nanii imo wi'a Iisaa Nasaraatuujo oon liɓan suudu ndu, de waylita al'aadaaji ɗi Muusaa yoppidi en ɗiin. ");
INSERT INTO fuhbkf_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Saahiiɓe jooɗiiɓe ɗoon ɓeen fuu ndaari Etiyen faa wooɗi, nji'i yeeso makko ina wa'i hono yeeso maleyka ni. ");
INSERT INTO fuhbkf_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ndeen Almaami Mawɗo oon ƴami Etiyen: —Yalla ko ɓe mbi'i ɗuum, wo noon worri naa? ");
INSERT INTO fuhbkf_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Etiyen jaabii, wi'i: —Sakiraaɓe e baabiraaɓe, kettindanee kam! Laamɗo jom teddeengal oon ɓanganii maami en Ibrahiima nde wonnoo leydi Mesopotami, fadde muuɗum hoɗoyde Haran, ");
INSERT INTO fuhbkf_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","wi'i ɗum: «Eggu e leydi maa e lenyol maa, njahaa e leydi ndi kollanmaami ndiin.» ");
INSERT INTO fuhbkf_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ndeen Ibrahiima dilli leydi Kaldiya, yehi hoɗowi Haran. Caggal maayde bammum, Laamɗo eggini ɗum ɗoon, waddi ɗum e leydi ndi koɗuɗon e muuɗum joonin ndi. ");
INSERT INTO fuhbkf_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Laamɗo hokkaay mo e leydi ndi tafon, fay taaɓannde. Ammaa aadake hokkude mo ndi, ndi laatoo halal makko, kanko e ƴuwdi makko, fay si taweede o walaa ɓiɗɗo tafon. ");
INSERT INTO fuhbkf_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Inan ko Laamɗo wi'i: «ƴuwdi maa feran jooɗowoo leydi njananndi, maree, torree duuɓi keme nay. ");
INSERT INTO fuhbkf_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ammaa leydi marundi ɓe ndiin, mi jukkoto ndi. Caggal ɗuum, ɓe njaltan leydi ndiin, ɓe teddina kam e nokku ooɗo.» Wo noon Laamɗo wi'i. ");
INSERT INTO fuhbkf_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ndeen Laamɗo haɓɓidi e Ibrahiima amaana. Taadagol laatii maande amaana oon. Hono noon, ko Ibrahiima heɓi Isiyaaka ɗuum, taadi ɗum nde waɗunoo balɗe jeetati. Hono noon Isiyaaka taadiri Yaakuuba. Hono noon Yaakuuba du waɗiri ɓiɓɓe muuɗum sappo e ɗiɗo, laatiiɓe maamiraaɓe lenyi meeɗen sappo e ɗiɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Maamiraaɓe ɓeen kaasidii Yuusufi, conni ɗum Misira. Ammaa Laamɗo ina wondi e makko, ");
INSERT INTO fuhbkf_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","hisini mo e torraaji ɗi o torraa fuu, hokki mo moƴƴere e hakkilantaaku yeeso Fira'awna kaananke Misira oon. Oon waɗi mo dawranoowo galle muuɗum e Misira fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Ndeen rafo waɗi ley Misira e Kanaana fuu. Ɓillaare mawni faa maamiraaɓe meeɗen kunngii nyaamdu. ");
INSERT INTO fuhbkf_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Nde Yaakuuba nannoo nyaamri ina woni ley Misira ndeen, neli toon maamiraaɓe meeɗen. Ɓe njehi, ɓe ngarti. ");
INSERT INTO fuhbkf_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Nde ɓe njeccinoo Misira ɗiɗaɓerde fu, Yuusufi anndintinii sakiraaɓe muuɗum ɓeen hoore mum. Suudu baaba Yuusufi du ɓangani Fira'awna. ");
INSERT INTO fuhbkf_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ndeen Yuusufi neli noddanee bammum Yaakuuba e koreeji muuɗum fuu. Wo ɓe yimɓe capanɗe njeɗɗo e njoyo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Yaakuuba nootowii Yuusufi Misira. O maayi toon, kanko e maamiraaɓe meeɗen ɓeen. ");
INSERT INTO fuhbkf_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ɓe njaaraa Sikem, ɓe uwaa e saabeere nde Ibrahiima soorunoo e ɓiɓɓe Hamor buuɗi cardi to Sikem toon. ");
INSERT INTO fuhbkf_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Nde amaana mo Laamɗo waɗannoo Ibrahiima ɓadinoo yottaade ndeen, Ibraninkooɓe keewi ley Misira. ");
INSERT INTO fuhbkf_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Wakkati oon, kaananke goɗɗo mo anndaano Yuusufi laamii Misira. ");
INSERT INTO fuhbkf_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Kaananke oon hiili lenyol meeɗen, torri maamiraaɓe meeɗen faa tilsinani ɓe ɓe njoppa cukaloy maɓɓe faa maaya. ");
INSERT INTO fuhbkf_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ley wakkati oon, Muusaa rimaa, wo korsuɗo Laamɗo. O muyninaa lebbi tati ley galle baabiiko. ");
INSERT INTO fuhbkf_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Nde o yoppanoo ndeen, ɓii Fira'awna debbo hooƴi mo, jogorii mo ɓiyum. ");
INSERT INTO fuhbkf_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Hono noon Muusaa janngiri anndal Misirankooɓe fuu, o laatii barkinaaɗo e haalaaji e golle fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Nde Muusaa heɓunoo duuɓi capanɗe nay ndeen, muuyi wallude sakiraaɓe muuɗum ɓiɓɓe Israa'iila. ");
INSERT INTO fuhbkf_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","O yi'i Misiranke ina toonyoo gooto maɓɓe. O yomnitanii neɗɗo makko oon ko toonyaa ɗuum, o fiyi Misiranke oon, o wari ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Imo sikka sakiraaɓe makko ɓeen paaman Laamɗo ina hisinira ɗum'en e makko, de ɓe paamaay. ");
INSERT INTO fuhbkf_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Jaango majjum o tawdi ɗiɗo maɓɓe ina kaɓa. O tefi rewrintinde ɓe, o wi'i: «Yigiraaɓe am, onon, on sakiraaɓe! Ɗume waɗi de oɗon kaɓa?» ");
INSERT INTO fuhbkf_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ndeen toonyiiɗo gondo muuɗum oon dunƴi mo, wi'i: «Moy waɗi ma hooreejo naa carotooɗo amin? ");
INSERT INTO fuhbkf_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ɗum le a jiɗuɗo warude kam no mbardunoɗaa Misiranke oon keeŋan naa?» ");
INSERT INTO fuhbkf_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Muusaa doggi saabe konngol ngool, de laatowii janano ley leydi Madiyan. O heɓi toon ɓiɓɓe worɓe ɗiɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Nde o hiɓɓinnoo toon duuɓi capanɗe nay ndeen, maleyka ɓangi e makko e ley ɗemle yiite e wuumoore huɓɓoore, ley ladde ɗakkol waamnde wi'eteende Sinayi. ");
INSERT INTO fuhbkf_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Nde Muusaa yi'unoo ɗum ndeen, ɗum haaynii ɗum. Imo ɓattitoo faa o ndaara, de daande Joomiraaɗo wi'i: ");
INSERT INTO fuhbkf_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","«Miin woni Laamɗo maamiraaɓe maaɗa, Ibrahiima e Isiyaaka e Yaakuuba.» De Muusaa na diwna, suusaa ndaarude toon katin. ");
INSERT INTO fuhbkf_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Joomiraaɗo wi'i mo: «Ɓorta paɗe maa, sabo nokkuure ɗo ndariɗaa ɗoon wo seniinde. ");
INSERT INTO fuhbkf_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Mi yi'ii torra kewtiiɗo yimɓe am ɓeen to Misira, mi nanii uumaali maɓɓe. Mi jippake faa mi ɓillita ɓe. Joonin le, war, mi nule Misira.» ");
INSERT INTO fuhbkf_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Muusaa mo ɓe calanii de ɓe mbi'i: «Moy waɗi ma hooreejo naa carotooɗo?», wo oon Laamɗo nuli. Laamɗo waɗi ɗum hooreejo e kisinoowo, waɗi ɗum e junngo maleyka ɓangannooɗo ɗum e ley wuumoore oon. ");
INSERT INTO fuhbkf_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Kanko wurtini ɓe, o waɗi kaayeefiiji e maandeeji kaayniiɗi ley leydi Misira e ley maayo Maaliya e ley ladde duuɓi capanɗe nay. ");
INSERT INTO fuhbkf_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Oon woni Muusaa biiɗo ɓiɓɓe Israa'iila: «Laamɗo nuldan on annabaajo hono am, sakiike mooɗon.» ");
INSERT INTO fuhbkf_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Nde ɓe kawritinnoo ley ladde ndeen, wo kanko wondi e maleyka kaaldunooɗo e makko to waamnde wi'eteende Sinayi. Kanko laatii jottinoowo ɗum fuu to maamiraaɓe meeɗen. Wo kanko heɓi haalaaji buurnooji faa o hokka en. ");
INSERT INTO fuhbkf_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Ammaa maamiraaɓe meeɗen njaɓaay ɗowtanaade mo. Ɓe calanii mo, hakkillooji maɓɓe pornyii Misira. ");
INSERT INTO fuhbkf_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ɓe mbi'i Haaruuna: «Waɗan en tooruuji ardotooɗi en, sabo en anndaa ko hewtii Muusaa jaltinnooɗo en leydi Misira oon.» ");
INSERT INTO fuhbkf_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ley balɗe ɗeen, ɓe tafi tooru nanndundu hono ga'el. Ɓe ngaɗani ndu kirsamaari, iɓe ngaɗa weltaare saabe golle juuɗe maɓɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ndeen Laamɗo tottitii ɓe, yoppiri ɓe rewude koode kammu, hono no winndiraa e dewtere annabaaɓe: «Hey lenyol Israa'iila! Duuɓi capanɗe nay ɗi ngaɗuɗon ley ladde ɗiin, on ngaɗanii kam sadakaaji e kirsamaaji naa? ");
INSERT INTO fuhbkf_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","On ngaɗaay. On ndonndake hukum ɗo tooru mooɗon Molok resaa, kam e tooru ndu ngaɗuɗon hoodere mon wi'eteende Refan, nate ɗe moƴƴinɗon faa cujidanon ɗum'en! Ɗum waɗi de miɗo eggina on, faa njaareɗon caggal Baabiila.» ");
INSERT INTO fuhbkf_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Etiyen ɓeydi katin: —Maamiraaɓe meeɗen ɓeen ina njoginoo hukum seedaaku ley ladde. Hukum oon moƴƴiniraama hono no Laamɗo tindiniri Muusaa, e sifa mo o holli ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Maamiraaɓe meeɗen ndoni hukum oon. Ɓe eggidi e makko wakkati mo Yoosuwa ardinoo ɓe. Ɓe nanni ɗum leydi ndi ɓe teeti e lenyi ɗi Laamɗo riiwi ɗiin. Ɗum worri noon faa jamaanu Daawda. ");
INSERT INTO fuhbkf_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Daawda heɓi moƴƴere Laamɗo, o nyaagii ɗum faa yardoo o nyiɓana Laamɗo Yaakuuba joonnde. ");
INSERT INTO fuhbkf_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","De wo Suleymaana, kam nyiɓi suudu nduun. ");
INSERT INTO fuhbkf_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Ammaa Laamɗo Toowɗo oon jooɗataako e cuuɗi ɗi yimɓe nyiɓi, hono no annabaajo wi'iri: ");
INSERT INTO fuhbkf_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","«Joomiraaɗo wi'i: Kammu wo jooɗorgal am, leydi woni to koyɗe am njaaɓata. Suudu nduye nyiɓanton kam? E nokku oye powtintoomi? ");
INSERT INTO fuhbkf_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Wanaa miin tagiri kulle ɗeen fuu baawɗe am naa?» ");
INSERT INTO fuhbkf_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Etiyen ɓeydi katin, wi'i: —Onon sattuɓe, yoorɓe ɓerɗe, faaɗinkiniiɓe! Abada on celaay salanaade Ruuhu Ceniiɗo! On laatake hono maamiraaɓe mooɗon ɓeen ni. ");
INSERT INTO fuhbkf_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Moy woni annabaajo mo maamiraaɓe mooɗon torraay? Ɓe mbarii haalannooɓe haala garol Ponnditiiɗo. Joonin onon e ko'e mooɗon du, on njambake Ponnditiiɗo oon, on mbarii ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","On keɓii Tawreeta Muusaa mo maleyka'en njippini de on njokkaay ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Nde Saahiiɓe ɓeen nannoo haalaaji ɗiin fu, ɓe tikkani mo sanne sanne faa iɓe nyerƴundura nyiiƴe maɓɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ammaa kanko kebbinaaɗo Ruuhu Ceniiɗo oon, o tiggitii kammu, o yi'i manngu Laamɗo, o yi'i Iisaa ina darii gere nyaamo Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","O wi'i: —Ndaaree! Miɗo yi'a kammu ina udditii, Ɓii Neɗɗo ina darii gere nyaamo Laamɗo! ");
INSERT INTO fuhbkf_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ɓe mbulli semmbe, ɓe cukki noppi maɓɓe, ɓe fuu ɓe ngurbitanii mo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ɓe mburtini mo ngalluure ndeen, ɓe limni mo kaaƴe. Seedeeɓe ɓeen ɓortii saayaaji muɓɓen dowuuji, mballini ɗakkol koyɗe jokolle bi'eteeɗo Sool. ");
INSERT INTO fuhbkf_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Wakkati mo ɓe limnata Etiyen kaaƴe oon, du'ii, wi'i: —Iisaa Joomiraaɗo, inan yonki am, jaɓu ki! ");
INSERT INTO fuhbkf_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ndeen, o hofii, o feekii faa toowi, o wi'i: —Joomiraaɗo, taa rewta ɓe e hakke o! Nde o haalnoo ɗum ndeen, o maayi. ");
INSERT INTO fuhbkf_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sool ina yardii ko ɓe mbari Etiyen ɗuum. Nyalooma oon, torra mawɗo hewtii kawrital goonɗinɓe wonɓe Urusaliima toon. Ɓe fuu ɓe cankitii ley leyɗe Yahuudiya e Samariya, si wanaa nulaaɓe ɓeen. ");
INSERT INTO fuhbkf_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Worɓe hulɓe Laamɗo uwi Etiyen, mboyi ɗum bojji keewɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Sool kaa yehi na halka kawrital goonɗinɓe ngaal. Imo naata cuuɗi, imo nannga worɓe e rewɓe, imo daasa ɗum'en, imo uddowa ɗum'en ley kasu. ");
INSERT INTO fuhbkf_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ammaa sankitiiɓe ɓeen naati e yiilaade ina mbaajoo Kabaaru Lobbo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filipu du yehi ngalluure wonnde ley leydi Samariya, ina waajoo yimɓe kabaaru Almasiihu. ");
INSERT INTO fuhbkf_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Yimɓe toon heewɓe nani kabaaru maandeeji kaayniiɗi ɗi Filipu waɗi, wooɗi nji'i ɗum du. Ndelle ɓe kettindii waaju makko faa wooɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Wonduɓe e ginnaaji heewɓe, ginnaaji ɗiin njaltiri bullaali mawɗi. Heewɓe ɓe ɓalli muɓɓen mbaati ndaɗi, kam'en e bonnguuɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ɗum laatanii ngalluure ndeen seyo manngo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Gorko bi'eteeɗo Simon ina wonnoo ley ngalluure ndeen. Imo gollannoo ndaggadaaku, imo haayninoo Samariyankooɓe sanne, imo wiitoo wo o neɗɗo mawɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Yimɓe ɓeen fuu ina njaɓani mo, gilla suka faa mawɗo. Ɓe mbi'i: —Gorko o jogii baawɗe Laamɗo bi'eteeɗe «Baawɗe mawɗe». ");
INSERT INTO fuhbkf_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ɓe njokkii mo ko ɓooyi sabo imo haayninoo ɓe e dabare makko. ");
INSERT INTO fuhbkf_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ammaa nde Filipu waajinoo ɓe Kabaaru Lobbo haala laamu Laamɗo e haala Iisaa Almasiihu ndeen, ɓe ngoonɗini. Worɓe e rewɓe du lootaa lootagal batisima. ");
INSERT INTO fuhbkf_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simon e hoore muuɗum goonɗini, kam du. Nde o batisaa ndeen, o takkunduri e Filipu. O yi'i maandeeji kaayniiɗi e kaayeefiiji mawɗi gaɗaaɗi ɗiin, de ɗum haaynii mo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Nulaaɓe wonɓe Urusaliima ɓeen nani Samariyankooɓe ngoonɗinii konngol Laamɗo. Ɓe nuldi ɗum'en Piyeer e Yuhanna. ");
INSERT INTO fuhbkf_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Nde ɓeen njottinoo ndeen, ndu'anii ɓe faa ɓe keɓa Ruuhu Ceniiɗo, ");
INSERT INTO fuhbkf_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","sabo Ruuhu Ceniiɗo jippaaki e dow fay gooto maɓɓe tafon. Wo dow innde Iisaa Joomiraaɗo oon tan ɓe mbatisiraa. ");
INSERT INTO fuhbkf_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ndeen Piyeer e Yuhanna njowi juuɗe muɓɓen dow maɓɓe de ɓe keɓi Ruuhu Ceniiɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Nde Simon yi'unoo Piyeer e Yuhanna ina njowi juuɗe muɓɓen dow maɓɓe ina kokka ɓe Ruuhu Ceniiɗo ndeen, inndani ɓe ceede, ");
INSERT INTO fuhbkf_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","wi'i: —Kokkee kam miin du baawɗe ɗe faa mo njowumi juuɗe am e dow muuɗum fuu heɓa Ruuhu Ceniiɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ndeen Piyeer jaabii mo, wi'i: —Wo Laamɗo halke, aan e cardi maa, sabo a miilii dokkal Laamɗo na heɓiree ceede! ");
INSERT INTO fuhbkf_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","A walaa ngeɗu ley golle amin, ɗum walanaa ma, sabo ɓernde maa fonnditaaki to Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Tuubu, wurta e bonanda maa oon, nyaagoɗaa Joomiraaɗo yalla imo yaafe e anniya maa bonɗo oon. ");
INSERT INTO fuhbkf_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Sabo mi yi'ii ma a kaaɗuɗo ɓernde, hakke maa haɓɓii ma. ");
INSERT INTO fuhbkf_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simon jaabii, wi'i: —Nyaaganee kam Joomiraaɗo taa fay huunde e ko mbiiɗon ɗuum hewtoo kam. ");
INSERT INTO fuhbkf_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Wooɗi, Piyeer e Yuhanna ceedanii Almasiihu, mbaajii konngol Joomiraaɗo toon. Caggal ɗuum, ɓe njeccii Urusaliima. Dow laawol ngool du, iɓe mbaajoo Kabaaru Lobbo oon e gure Samariya keewɗe. ");
INSERT INTO fuhbkf_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Maleyka Joomiraaɗo wi'i Filipu: —Umma, yaaru horɗoore, kooƴaa laawol jeewniingol ƴuuroowol Urusaliima ina fonndii Gaaja ngool. ");
INSERT INTO fuhbkf_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","O ummii, o yehi. O hawri e gorko Etiyopiyanke. Gorko oon wo howruujo Kandasa. Maanaa Kandasa wo «laamiiɗo debbo Etiyopi». Wo o coortaaɗo, kayboowo beembal jawdi kaananke debbo oon. Tawi o yehiino Urusaliima sujidande Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Ko o wartata ɗuum, imo jooɗii e dow torkooru makko puccu, imo jannga ley dewtere annabi Esaaya. ");
INSERT INTO fuhbkf_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ruuhu wi'i Filipu: —Ɓatta, samnda torkooru nduun. ");
INSERT INTO fuhbkf_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filipu doggi hewti ndu, nani imo jannga dewtere annabi Esaaya, de wi'i mo: —Ndelle aɗa faama ko njanngataa ɗuum naa? ");
INSERT INTO fuhbkf_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Gorko oon jaabii, wi'i: —Noy paamirammi si fay gooto fiirtanaay kam? O nyaagii Filipu ƴeeŋa jooɗodoo e makko. ");
INSERT INTO fuhbkf_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Inan aayaaje ɗe o janngi ley dewtere ndeen: «O yaaraama hono mbaalu kirsoyteengu ni. No baalel deƴƴinortoo yeeso kesoowo leeɓi muuɗum ni, hono noon o muɓɓiri hunnduko makko. ");
INSERT INTO fuhbkf_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ɓe leeƴinii mo, ɓe carii mo sariya bonɗo. Moy waawi fillaade filla ƴuwdi makko? Sabo ɓe ittii yonki makko ley adunaaru ga.» ");
INSERT INTO fuhbkf_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Howruujo oon wi'i Filipu: —Miɗo ŋaare, haalanam dow moy annabaajo oon haalata haala ka. Wo dow hoore muuɗum naa wo goɗɗo? ");
INSERT INTO fuhbkf_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ndeen Filipu fuɗɗi haalude dow aayaaje ɗeen, de waajii mo Kabaaru Lobbo haala Iisaa. ");
INSERT INTO fuhbkf_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Iɓe njokki laawol maɓɓe ngool faa ɓe nji'i ndiyam. Howruujo oon wi'i: —Inan ndiyam! Ɗume haɗata kam looteede lootagal batisima? ");
INSERT INTO fuhbkf_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filipu wi'i: —Si tawii aɗa goonɗini e ɓernde laaɓunde fu, walaa ko haɗete batiseede. O jaabii, o wi'i: —Miɗo goonɗini Iisaa Almasiihu woni Ɓii Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","O yamiri torkooru nduun daroo. Ɓe ɗiɗo fuu ɓe njippii, ɓe naati ndiyam ɗaam. Filipu looti mo lootagal batisima. ");
INSERT INTO fuhbkf_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Nde ɓe mburtinoo ndiyam ɗam ndeen, Ruuhu Joomiraaɗo hooƴi Filipu. Howruujo oon yiitaay mo katin, jokki laawol muuɗum, ina seyii. ");
INSERT INTO fuhbkf_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filipu tawowaa Ajootus. Gilla ɗoon faa Kaysariya, wuro fuu ngo o wari e muuɗum, o waajoto Kabaaru Lobbo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Sool ina heddii na haala haalaaji kulɓiniiɗi dow taalibaaɓe Joomiraaɗo ɓeen, na wi'a o waran ɗum'en. O yehi to Almaami Mawɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","O ŋaarii ɗum ɗerewol yamiroore nannoore mo cuuɗi Alhuudiyankooɓe baajorɗi gonɗi Damas. Hono nii, si o tawii toon yimɓe jokkuɓe laawol Iisaa, gorko e debbo fuu, o nannga ɗum'en, o haɓɓa, o yaara Urusaliima. ");
INSERT INTO fuhbkf_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Nde o yahunoo faa o ɓattitii Damas ndeen, wakkati gooto annoora ƴuuri dow kammu fiilii mo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","O saami e leydi, o nani daande ina wi'a mo: —Sool, Sool, ko waɗi de aɗa torra kam? ");
INSERT INTO fuhbkf_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sool ƴami: —Aan wo a moy, joomam? Nde o ƴamunoo ɗum fu, jaabu wari e makko: —Miin, wo mi Iisaa mo torrataa oon. ");
INSERT INTO fuhbkf_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Umma naatu e ley ngalluure ndeen. Ɓe kaalante ko tilsi ngaɗaa. ");
INSERT INTO fuhbkf_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Worɓe wonduɓe e makko ɓeen nani daande ndeen ammaa nji'aay fay gooto. Ɓe ndarii, ɓe mbemmbaa faa ɓe muumɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sool ummii e leydi, ina feerti gite muuɗum ammaa yi'ataa fay huunde. Ndeen o ɗowaa, o nannaa Damas. ");
INSERT INTO fuhbkf_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","O waɗi balɗe tati o bumɗo. O nyaamaay, o yaraay. ");
INSERT INTO fuhbkf_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ley Damas ɗoon ina woodi taalibaajo bi'eteeɗo Ananiyas. E ley holleede, Joomiraaɗo noddi ɗum, wi'i: —Ananiyas! O jaabii, o wi'i: —Naam, Joomiraaɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Joomiraaɗo wi'i mo: —Umma rewu laawol bi'eteengol Dartiingol, naataa galle Yahuuda, piloɗaa gorko bi'eteeɗo Sool, jeyaaɗo Tarsus, sabo joonin imo waɗa du'aare. ");
INSERT INTO fuhbkf_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","O yi'i e ley holleede gorko bi'eteeɗo Ananiyas ina naata, ina yowa juuɗe muuɗum e makko faa o wumta. ");
INSERT INTO fuhbkf_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananiyas jaabii, wi'i: —Joomiraaɗo, mi narrii yimɓe heewɓe haala gorko o e torraaji keewɗi ɗi o waɗi seniiɓe maa wonɓe Urusaliima. ");
INSERT INTO fuhbkf_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","O wardii ɗo e yamiroore hooreeɓe almaami'en, faa o haɓɓa noddooɓe innde maa fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ammaa Joomiraaɗo wi'i mo: —Yahu waɗoy no mbiimi ni, sabo mi suɓake gorko o faa o gollana kam. O anndina lenyi e kaanankooɓe e ɓiɓɓe Israa'iila du innde am. ");
INSERT INTO fuhbkf_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Mi hollan mo na tilsi o torree torraaji keewɗi saabe am. ");
INSERT INTO fuhbkf_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ndeen, Ananiyas yehi, naatowi suudu nduun, yowi juuɗe muuɗum e makko, wi'i: —Sakiike am Sool, Joomiraaɗo meeɗen Iisaa ɓangannooɗo ma e laawol nde ngarannoɗaa oon, nulii kam faa mbumtaa, keewaa Ruuhu Ceniiɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Wakkati oon fu, huunde wa'unde hono koɓolaaje nii hoɓɓitii e gite Sool. O wumti, o ummii, de o lootaa lootagal batisima. ");
INSERT INTO fuhbkf_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","O nyaami, de semmbe makko warti. O heddodii e taalibaaɓe wonɓe Damas ɓeen balɗe seeɗa. ");
INSERT INTO fuhbkf_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Wakkati oon fu, Sool fuɗɗi waajaade ley cuuɗi baajorɗi. Imo wi'a Iisaa jaati woni Ɓii Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ɗum haaynii hettindaniiɓe mo ɓeen fuu, mbi'i: —Wanaa kanko wonnoo torrannooɗo goonɗinɓe Iisaa wonɓe ley Urusaliima oon naa? Wanaa faa o haɓɓa goonɗinɓe o yaara ɗum'en to hooreeɓe almaami'en waddi mo ɗo naa? ");
INSERT INTO fuhbkf_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","De Sool ina heddii na ɓeydoroo semmbe e ley waaju muuɗum oon, faa ɗum jiiɓi Alhuudiyankooɓe wonɓe Damas ɓeen fuu. O laaɓinani ɓe Iisaa woni Almasiihu oon. ");
INSERT INTO fuhbkf_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Balɗe njehi, ngarti, Alhuudiyankooɓe ndawridi faa mbara Sool. ");
INSERT INTO fuhbkf_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Sool humpitii dabare maɓɓe ndeen. Yimɓe ina kayba dammbuɗe ngalluure ndeen jemma e nyalooma fuu, faa ɓe keɓa no ɓe mbarda mo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Jemma gooto taalibaaɓe makko kooƴi mo, ngatti mo e hanndeere, kaɓɓi ɓoggol, njaltiniri mo kokuwol piiliingol ngalluure ngool. ");
INSERT INTO fuhbkf_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Nde Sool warnoo Urusaliima ndeen, muuyi hawritinde e taalibaaɓe Iisaa ɓeen. Ammaa ɓe fuu iɓe kula mo, ɓe koolaaki yalla o laatake taalibbo Iisaa goonga goonga. ");
INSERT INTO fuhbkf_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ndeen Barnabas yaari mo to nulaaɓe ɓeen, haalani ɗum'en no o yiiri Joomiraaɗo ina haalda e makko e laawol ngool, e no o waajorii haala Iisaa e cuusal ley Damas toon. ");
INSERT INTO fuhbkf_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Caggal ɗuum, Sool wondi e maɓɓe, ina naata ina wurtoo ley galleeji maɓɓe Urusaliima, ina waajoroo haala Joomiraaɗo e cuusal. ");
INSERT INTO fuhbkf_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Imo haalda e Alhuudiyankooɓe haalannooɓe geresankoore ɓeen, imo yeddundura e maɓɓe, de kamɓe kaa iɓe piloo warude mo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Nde sakiraaɓe makko goonɗinɓe ɓeen annditinnoo ɗum ndeen, njaari Sool Kaysariya. Caggal ɗuum, ɓe neli mo Tarsus. ");
INSERT INTO fuhbkf_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ndeen kawrital goonɗinɓe ngaal heɓi jam ley Yahuudiya e Galili, kam e Samariya fuu. Ngal ɓeydi semmbe, ngal yehi yeeso e kulol Joomiraaɗo, ngal ɓeydii heewude saabe ballal Ruuhu Ceniiɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Piyeer ina yiiloo e ley leydi ndiin fuu. O jippanii seniiɓe wonɓe Lidda ɓeen du. ");
INSERT INTO fuhbkf_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","O tawi toon gorko nyawɗo mo ɓanndu muuɗum fuu waati, bi'eteeɗo Eneya. O waɗii duuɓi jeetati imo waalii. ");
INSERT INTO fuhbkf_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Piyeer wi'i mo: —Eneya, Iisaa Almasiihu dannii ma! Umma, moƴƴin daɗɗo maa! Wakkati oon pay, o ummii. ");
INSERT INTO fuhbkf_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Wonɓe Lidda e ngenndi Saron fuu nji'i mo, de tuubani Joomiraaɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ley wuro Joffe ina woodi taalibaajo debbo bi'eteeɗo Tabita (maanaa majjum woni «Lewla»). Ɗum woni Dorkas e geresankoore. Imo golla golleeji lobbi, imo waɗana talkaaɓe moƴƴere. ");
INSERT INTO fuhbkf_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","E balɗe ɗeen o nyawi, o maayi. O lootaa, de o wallinaa ley suudu sooro tafon. ");
INSERT INTO fuhbkf_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Wuro Joffe ngoon woɗɗunduraa e Lidda, wooɗi du, taalibaaɓe ɓeen nani Piyeer ina woni to Lidda toon. Ndelle ɓe neli worɓe ɗiɗo ŋaaroo mo o yottoo ɗum'en law. ");
INSERT INTO fuhbkf_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Piyeer ummii, yaadi e maɓɓe. Nde ɓe njottinoo ndeen, ɓe njaari mo ley suudu sooro toon. Rewɓe talka'en ɓe goriraaɓe muɓɓen maayi ɓeen fuu ɓattii ɗum ina mboya, ina kolla ɗum saayaaji e kaddule goɗɗe ɗe Dorkas nyo'unoo nde wondunoo e muɓɓen ndeen. ");
INSERT INTO fuhbkf_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Piyeer wurtini yimɓe ɓeen fuu, hofii, ina du'oo. Caggal ɗuum, hucciti e maayɗo oon, wi'i: —Tabita, umma! Ndeen Tabita feerti gite muuɗum, yi'i Piyeer, ummii jooɗii. ");
INSERT INTO fuhbkf_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Piyeer nanngi junngo makko, ummini mo. Caggal ɗuum, o noddi seniiɓe ɓeen e rewɓe talkaaɓe ɓeen, o holli ɗum'en Tabita wo buurɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ɗum nanaama e ley Joffe fuu, heewɓe ngoonɗini Joomiraaɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Piyeer ɓooyti Joffe balɗe keewɗe to ceeloowo guri bi'eteeɗo Simon. ");
INSERT INTO fuhbkf_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ley Kaysariya ina woodi gorko bi'eteeɗo Korneliyus. O mawɗo fedde sordaasi'en wi'eteende «fedde Italiyankooɓe». ");
INSERT INTO fuhbkf_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","O tinniiɗo e diina, kanko e koreeji makko fuu ɓe hulɓe Laamɗo. Imo sakkana Alhuudiyankooɓe sadakaaji keewɗi, imo waɗa du'aare to Laamɗo wakkati fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Nyannde gomma wakkati yamnde tati, o yi'i e ley holleede maleyka ina naata suudu makko. Maleyka oon ina wi'a mo: —Korneliyus! ");
INSERT INTO fuhbkf_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","O ndaari ɗum faa wooɗi, o huli, o wi'i ɗum: —Joomam, ɗume? Maleyka oon wi'i mo: —Du'aawuuji maa e sadakaaji ɗi ngaɗanɗaa talkaaɓe ɗiin ina mbeli Laamɗo. Laamɗo yeggitaay ma. ");
INSERT INTO fuhbkf_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Nulu joonin worɓe to wuro Joffe, faa noddowa Simon, bi'eteeɗo Piyeer. ");
INSERT INTO fuhbkf_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Imo jippii to ceeloowo guri bi'eteeɗo Simon, mo suudu muuɗum hetti e maayo manngo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Nde maleyka kaaldannooɗo e makko oon dillunoo ndeen, o noddi gollooɓe makko ɗiɗo e sordaasi gooto kulɗo Laamɗo jeyaaɗo e howruuɓe makko. ");
INSERT INTO fuhbkf_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","O haalani ɓe ko maleyka oon wi'i ɗuum fuu, o neli ɓe Joffe. ");
INSERT INTO fuhbkf_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Jaango majjum, iɓe ngoni e laawol. Nde worɓe tato ɓeen ɓattinoo wuro ngoon ndeen, Piyeer ƴeeŋi dow suudu ɗo weeri ɗoon wakkati hakkunde naange faa waɗa du'aare. ");
INSERT INTO fuhbkf_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","O yolbii sanne, imo yiɗi nyaamude. Nde ɓe moƴƴinanta o nyaamdu ndeen, Laamɗo holli mo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","O yi'i kammu udditii, de huunde wa'unde hono disaare mawnde ina jippinee e leydi. Coɓɓuli muuɗum nay fuu ina kaɓɓaa. ");
INSERT INTO fuhbkf_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Sii daabaaji fuu ɗi koyɗe nay, e kulle ladooje, kam e sii pooli fuu ina ngoni e mayre. ");
INSERT INTO fuhbkf_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Daande wi'i mo: —Piyeer, umma, hirsu, nyaam! ");
INSERT INTO fuhbkf_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Piyeer wi'i: —A'aa, abada Joomiraaɗo! Abada mi nyaamaay ko harmi naa ko tuuni. ");
INSERT INTO fuhbkf_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Daande ndeen wi'i mo katin: —Taa harmin ko Laamɗo laaɓini. ");
INSERT INTO fuhbkf_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ɗum waɗi noon kile tati. Ndeen disaare ndeen ƴeentinaa dow kammu. ");
INSERT INTO fuhbkf_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Piyeer ina wemmbii dow ko hollaa ɗuum, ko ɗum fiirtata. Tawi worɓe ɓe Korneliyus nelunoo ɓeen, ƴamiino galle Simon, de joonin ɓe ngari. Ɓe ndarii e dammbugal. ");
INSERT INTO fuhbkf_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ɓe noddi, ɓe ƴami yalla Simon bi'eteeɗo Piyeer ɗoon jippii. ");
INSERT INTO fuhbkf_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Piyeer ina heddii na miiloo dow ko yi'i ɗuum, faa Ruuhu wi'i ɗum: —Worɓe tato ina pile. ");
INSERT INTO fuhbkf_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Umma, jippa, njaadaa e maɓɓe tawa a sikkitiraay, sabo miin nuli ɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Piyeer jippii, wi'i worɓe ɓeen: —Inani kam, miin woni mo pilotoɗon oon. Ɗume waddi on? ");
INSERT INTO fuhbkf_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ɓe njaabii, ɓe mbi'i: —Korneliyus mawɗo sordaasi'en neli min. O gorko dartiiɗo, kulɗo Laamɗo, mo lenyol Alhuudiyankooɓe fuu seedanii moƴƴere. Maleyka ceniiɗo yamirii mo min nodde, ngaraa suudu makko, faa o nana waaju maaɗa. ");
INSERT INTO fuhbkf_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Piyeer silmini ɓe, weerni ɓe jemma oon. Jaango majjum, o ummii, o dillidi e maɓɓe. Sakiraaɓe woɓɓe jeyaaɓe Joffe njaadi e makko. ");
INSERT INTO fuhbkf_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Jaango majjum katin ɓe njottii ngalluure Kaysariya. Korneliyus ina heɗinoo ɓe, noddi sakiraaɓe muuɗum e yigiraaɓe muuɗum ɓadiiɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Nde Piyeer naatannoo ndeen, Korneliyus jaɓɓii ɗum, sujidani ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","De Piyeer ummini mo, wi'i: —Umma, sabo miin du mi neɗɗo tan. ");
INSERT INTO fuhbkf_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Piyeer ina haalda e makko, faa ɓe naati suudu nduun, tawi toon yimɓe heewɓe ina kawriti. ");
INSERT INTO fuhbkf_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","O wi'i ɓe: —Oɗon anndi daganaaki Alhuudiyanke jokkundura e mo wanaa Alhuudiyanke, naa weerande ɗum. Ammaa Laamɗo hollii kam taa mi ndaarda fay gooto karmuɗo naa tuunɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ɗum waɗi nde nelanɗon kam ndeen, mi warii, mi salaaki. Ɗum le, kaalanee kam, saabe ɗume noddirɗon kam? ");
INSERT INTO fuhbkf_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Korneliyus jaabii, wi'i: —Hannden woni balɗe nay, miɗo waɗa du'aare ley suudu am e wakkati hono o, yamnde tati ni, faa gorko mo kaddule jalbooje wari, darii yeeso am, ");
INSERT INTO fuhbkf_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","wi'i: «Korneliyus, Laamɗo jaabanake ma du'aawuuji maa e sadakaaji maa. ");
INSERT INTO fuhbkf_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Joonin, nulu e wuro wi'eteengo Joffe, noddaneɗaa Simon, bi'eteeɗo Piyeer. Imo jippii to ceeloowo guri bi'eteeɗo Simon, mo suudu muuɗum hetti e maayo manngo.» ");
INSERT INTO fuhbkf_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ɗum waɗi de nelumi noddoweɗaa wakkati oon. A gaynii ko ngarɗaa ɗuum. Joonin min fuu inani min yeeso Laamɗo faa min kettindoo ko Joomiraaɗo yamiri ma mbaajoɗaa min fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ndeen Piyeer fuɗɗi haalude, wi'i: —Joonin mi yi'ii goonga jaati Laamɗo ɓurdintaa yimɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Neɗɗo kuloowo mo, gaɗoowo ko fonnditii, o jaɓan ɗum ko lenyol muuɗum laatii fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Oɗon anndi konngol ngol Laamɗo nuldi ɓiɓɓe Israa'iila ngool. Konngol lobbol ngool na holla jam na heɓiree saabe Iisaa Almasiihu, kam woni Joomiraaɗo yimɓe fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Oɗon anndi kabaaru o huuɓii leydi Yahuudiya fuu. Ɗum fuɗɗii gilla Galili, caggal ko Yaayaa waajii yimɓe loote batisima. ");
INSERT INTO fuhbkf_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Oɗon anndi no Laamɗo suɓorii Iisaa Nasaraatuujo oon, no jippiniri e muuɗum Ruuhu Ceniiɗo e baawɗe. Oɗon anndi no Iisaa yiilorii e nokkuuje fuu ina golla golleeji lobbi, ina danna ɓe Ibiliisa jaalii na torra fuu, sabo Laamɗo ina wondi e muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Minen, min seedeeɓe ko o golli Yahuudiya e ko o golli Urusaliima fuu. Ɓe ɓili o e leggal palaangal, ɓe mbari mo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ammaa Laamɗo iirtinii mo nyannde tataɓerde, de ɓangini mo hakkunde amin. ");
INSERT INTO fuhbkf_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Kaa wanaa yimɓe fuu o ɓangani. O ɓanganii seedeeɓe ɓe Laamɗo artii suɓaade ɓeen, minen nyaamduɓe e makko de njardi e makko caggal iirtagol makko ɓeen. ");
INSERT INTO fuhbkf_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","O yamirii min mbaajoo yimɓe, min ceedoo kanko woni mo Laamɗo waɗi carotooɗo wuurɓe e maayɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Kanko du woni mo annabaaɓe fuu ceedanii, mbi'i goonɗinɗo mo fuu heɓan yaafaneede hakkeeji muuɗum saabe innde makko. ");
INSERT INTO fuhbkf_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Wakkati Piyeer waajotoo waaju oon ndeen, Ruuhu Ceniiɗo jippii e hettindiiɓe ɓeen fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Alhuudiyankooɓe goonɗinɓe wardunooɓe e Piyeer ɓeen fuu ɗum haaynii ɗum'en, no dokkal Ruuhu Ceniiɗo ngaal saakorii e yimɓe ɓe nganaa Alhuudiyankooɓe ni. ");
INSERT INTO fuhbkf_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Sabo iɓe nana yimɓe ɓeen ina kaala e ɗemle janane, na njetta Laamɗo. Ndeen, Piyeer jaabii, wi'i: ");
INSERT INTO fuhbkf_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","—Yimɓe ɓeen keɓii Ruuhu Ceniiɗo hono no meeɗen ni. Moy waawi haɗude ɓe looteede lootagal batisima? ");
INSERT INTO fuhbkf_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","O yamiri ɓe mbatisiree e innde Iisaa Almasiihu. Caggal ɗuum, ɓe nyaagii mo o wonda e maɓɓe balɗe seeɗa. ");
INSERT INTO fuhbkf_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Nulaaɓe e sakiraaɓe wonɓe Yahuudiya ɓeen nani yimɓe ɓe nganaa Alhuudiyankooɓe du keɓii konngol Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Nde Piyeer ƴeentunoo Urusaliima fu, goonɗinɓe tilsinɓe taadagol ɓeen peli ɗum, ");
INSERT INTO fuhbkf_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","mbi'i: —A jippanake yimɓe ɓe taadaaki, a nyaamdii e muɓɓen! ");
INSERT INTO fuhbkf_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ndeen Piyeer haalani ɓe ko waɗi ɗuum gilla e fuɗɗoode faa e timmoode, wi'i: ");
INSERT INTO fuhbkf_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","—Wuro Joffe ngonnoomi, miɗo du'oo faa nji'umi e ley holleede huunde ɓanganii kam. Huunde wa'unde hono disaare mawnde nde coɓɓuli muuɗum nay fuu kaɓɓaa, ina jippinee ƴuuwde e kammu warde to am. ");
INSERT INTO fuhbkf_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Taykiimi nde faa wooɗi, nji'umi daabaaji fuu ɗi koyɗe nay, e kulle ladde e ladooje e sii pooli fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Nanumi daande ina wi'a kam: «Piyeer, umma, hirsu, nyaam!» ");
INSERT INTO fuhbkf_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Mbiimi: «A'aa, abada Joomiraaɗo! Abada mi nyaamaay ko harmi naa ko tuuni.» ");
INSERT INTO fuhbkf_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Daande dow kammu ndeen jaabitii kam katin, wi'i: «Taa harmin ko Laamɗo laaɓini.» ");
INSERT INTO fuhbkf_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ɗum waɗi noon kile tati. Caggal ɗuum, kulle ɗeen fuu ƴeentinaa dow kammu. ");
INSERT INTO fuhbkf_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","De wakkati oon pay, worɓe tato nulaaɓe to am ƴuuruɓe Kaysariya ngari to suudu ɗo min ngonnoo ɗoon. ");
INSERT INTO fuhbkf_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ruuhu Ceniiɗo wi'i kam mi yaada e maɓɓe taa mi sikkitira fay huunde. Sakiraaɓe njeegomo ɓee ɗo njaadi e am, de min naaddi suudu Korneliyus. ");
INSERT INTO fuhbkf_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","O haalani min no o yiiri maleyka ina darii ley suudu makko ina wi'a mo: «Nulu e wuro wi'eteengo Joffe noddaneɗaa Simon bi'eteeɗo Piyeer. ");
INSERT INTO fuhbkf_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","O haalante haalaaji kisinoowo ma, aan e koreeji maa fuu.» ");
INSERT INTO fuhbkf_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Nde puɗɗumi haalude ndeen, Ruuhu Ceniiɗo jippii e maɓɓe hono no jipporinoo e meeɗen arande ni. ");
INSERT INTO fuhbkf_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ndeen, miccitiimi konngol ngol Joomiraaɗo wi'unoo: «Yaayaa batisirannoo ndiyam, ammaa onon, on mbatisirte Ruuhu Ceniiɗo.» ");
INSERT INTO fuhbkf_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Si Laamɗo fonndii en e maɓɓe, hokkii ɓe ko hokkunoo en ɗuum nde ngoonɗinnoɗen Joommen Iisaa Almasiihu ndeen, ndelle miin wo mi moy? Yalla miɗo waawi haɗude Laamɗo naa? ");
INSERT INTO fuhbkf_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Nde ɓe nannoo ɗum ndeen, ɓe ndeƴƴinii, iɓe njetta Laamɗo, iɓe mbi'a: —Laamɗo tuubinii yimɓe ɓe nganaa Alhuudiyankooɓe du faa keɓa nguurndam ngoongalajam. ");
INSERT INTO fuhbkf_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Nde Etiyen waranoo ndeen, goonɗinɓe torraama faa cankitii. Woɓɓe njehi faa Finisi e Kipirus e Antiyoki. Iɓe mbaajoo Alhuudiyankooɓe tan konngol ngool. ");
INSERT INTO fuhbkf_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ammaa goonɗinɓe woɓɓe ƴuurooɓe Kipirus e Sireene naati Antiyoki ina mbaajoo Kabaaru Lobbo haala Iisaa Joomiraaɗo oon hakkunde Geresankooɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Baawɗe Joomiraaɗo ina ngondi e maɓɓe. Yimɓe heewɓe ngoonɗini, tuubi, ngarti to Joomiraaɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Kawrital goonɗinɓe wonɓe Urusaliima ngaal nani kabaaru gaɗuɗo Antiyoki oon, neli toon Barnabas. ");
INSERT INTO fuhbkf_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Nde oon yottinoo de yi'i e maɓɓe moƴƴere Laamɗo fu, seyii, tindini ɓe fuu ɓe tinnoo, ɓe tabita e Joomiraaɗo e ɓerɗe laaɓuɗe. ");
INSERT INTO fuhbkf_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabas wo gorko lobbo, kebbinaaɗo Ruuhu Ceniiɗo e goonɗinal. Jamaa keewɗo goonɗini Joomiraaɗo saabe makko. ");
INSERT INTO fuhbkf_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Caggal ɗuum, Barnabas yehi Tarsus faa filowoo Sool. ");
INSERT INTO fuhbkf_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Nde o yiitunoo ɗum ndeen, o yaari ɗum Antiyoki. Ɓe ngondi e kawrital goonɗinɓe wonɓe toon ɓeen hitaande hiɓɓunde, ɓe njanngini yimɓe heewɓe. Taalibaaɓe wonɓe Antiyoki ɓeen artii fuu wi'eede Almasiyankooɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","E balɗe ɗeen, annabaaɓe ley goonɗinɓe ƴuurii Urusaliima ngari Antiyoki. ");
INSERT INTO fuhbkf_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Gooto maɓɓe bi'eteeɗo Agabus, ummii, darii, holliri saabe Ruuhu rafo manngo waɗan ley laamu Roma fuu. (Wooɗi, rafo ngoon waɗii e laamu kaananke mawɗo bi'eteeɗo Kalawdiyus.) ");
INSERT INTO fuhbkf_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Taalibaaɓe ɓeen anniyii hawrundurde mballa, mono fuu ko waawi, faa ɓe nelda sakiraaɓe maɓɓe wonɓe Yahuudiya ɓeen. ");
INSERT INTO fuhbkf_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ɓe ngaɗi ɗum, ɓe nuldi mballa kaan e juuɗe Barnabas e Sool faa kokkowa mawɓe kawrital Urusaliima. ");
INSERT INTO fuhbkf_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Wakkati oon, kaananke bi'eteeɗo Hirudus fuɗɗi torrude woɓɓe ley kawrital goonɗinɓe ngaal. ");
INSERT INTO fuhbkf_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","O yamiri Yaakuuba sakiike Yuhanna oon wardee kaafaahi. ");
INSERT INTO fuhbkf_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Nde o yiinoo iɗum weli Alhuudiyankooɓe ndeen, o nanngi Piyeer du. Ɗum hawri e wakkati iidi buuru mo wattaaka rabilla. ");
INSERT INTO fuhbkf_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Nde o nanngunoo Piyeer ndeen, o ommbi ɗum ley kasu. O yamiri pecce sordaasiiɓe nay loomtundura e haybugol ɗum, fedde fuu yimɓe nayo. O anniyii yaarude ɗum yeeso yimɓe fuu, si iidi Faltagol tilake. ");
INSERT INTO fuhbkf_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ɗum waɗi de Piyeer haybaa e ley kasu nguun, ammaa kawrital goonɗinɓe ngal selaay nyaaganaade mo Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Nde Hirudus anniyinoo yaarude mo sariya ndeen, jemma oon imo ɗaanii hakkunde sordaasiiɓe ɗiɗo, imo haɓɓiraa callali ɗiɗi. Ndaarooɓe woɓɓe du ina kayba dammbugal kasu ɗoon. ");
INSERT INTO fuhbkf_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Wakkati oon, maleyka Joomiraaɗo wari to makko, annoora yayni ley suudu nduun. Maleyka meemi mo, findini mo, wi'i: —Umma law! Ndeen callali ɗiin kaɓɓitii, ƴuwi e juuɗe makko, caami. ");
INSERT INTO fuhbkf_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Maleyka oon wi'i mo: —Haɓɓa kaɓɓorgol maa, ɓorna paɗe maa. Piyeer waɗiri noon. Maleyka oon wi'i mo: —Waana suddamaare maa, njokkaa kam. ");
INSERT INTO fuhbkf_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Piyeer wurtii, jokki mo, de o faamaay ko maleyka oon waɗata ɗuum wo goonga. Imo miiloo wo o yi'u ɗum ley holleede. ");
INSERT INTO fuhbkf_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ɓe paltii kayboowo arandeejo oon e ɗiɗaɓo fuu. Ɓe njottii dammbugal njamndi naarrugal ngalluure ndeen. Ngal omtanii hoore maggal yeeso maɓɓe. Ɓe njalti, ɓe njokki laawol ngool. Wakkati oon, maleyka oon seedi e makko. ");
INSERT INTO fuhbkf_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Hakkillo Piyeer warti, wi'i: —Joonin mi tannyorii Joomiraaɗo nuli maleyka muuɗum, faa hisina kam e junngo Hirudus e ko Alhuudiyankooɓe njelinoo faa mi waɗee fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Nde o faamunoo ko waɗi fu, o yehi suudu Mariyama, inna Yuhanna bi'eteeɗo Marku. Toon yimɓe heewɓe kawriti ina ngaɗa du'aare. ");
INSERT INTO fuhbkf_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Nde Piyeer gokkinoo dammbugal galle toon ndeen, golloowo debbo bi'eteeɗo Roda ɓattitii faa ndaara wo moy. ");
INSERT INTO fuhbkf_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Nde o annditinnoo daande Piyeer ndeen, o yeggiti omtude dammbugal ngaal no o foti seyaade. O doggi, o naatowi, o humpiti ɓe wo Piyeer darii dammbugal toon. ");
INSERT INTO fuhbkf_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ɓe mbi'i mo: —A kaaŋaaɗo! Ammaa imo heddii siinude sikke walaa wo ɗum Piyeer. Ɓe mbi'i katin: —Ɗum wo maleyka makko. ");
INSERT INTO fuhbkf_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","De ɗum fuu Piyeer ina heddii ina gokkoo. Nde ɓe udditinnoo, ɓe njiinoo mo ndeen, ɗum haaynii ɓe sanne. ");
INSERT INTO fuhbkf_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","O huncani ɓe junngo faa ɓe ndeƴƴinoo, o fillanii ɓe no Joomiraaɗo yaltiniri mo kasu, o wi'i: —Kaalanee ɗum Yaakuuba, kam e sakiraaɓe woɓɓe ɓeen. Caggal ɗuum, o yalti, o yehi nokku goɗɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Nde weetunoo fu, fitina mawɗo ummii hakkunde sordaasiiɓe ɓeen. Iɓe ƴamundura noy Piyeer waɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Hirudus yamiri ɓe piloo ɓe nannga mo, ammaa ɓe njiitaay mo. Ndelle o ƴami ndaarooɓe ɓeen ko laatii, de o yamiri ɓe mbaree. Caggal ɗuum, Hirudus jippii Yahuudiya, yehi Kaysariya jooɗowii toon. ");
INSERT INTO fuhbkf_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Hirudus tikkani yimɓe Tirus e Sidon. De yimɓe ɓeen kaa muuyaay noon, sabo wo leydi makko ndiin ɓe keɓata nyaamdu. Ndelle ɓe ndawridi, ɓe nuli woɓɓe nyaagoo faa ɓe ndewra e makko. Ɓe paamiri e Bilastus dawranoowo gollooɓe kaananke. ");
INSERT INTO fuhbkf_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Ɓe itti nyalaande faa ɓe kaalda e Hirudus kaananke oon. Nde nyannde ndeen yottinoo fu, o ɓornii kaddule kaananke, o jooɗii dow jooɗorgal laamu, o haaldi e maɓɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Yimɓe ɓeen peekii, mbi'i: —Ɗum wo daande laamɗo, wanaa daande neɗɗo! ");
INSERT INTO fuhbkf_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Wakkati oon fu, maleyka Joomiraaɗo fiyi Hirudus, sabo o hokkitaay Laamɗo teddeengal muuɗum. O ƴumi gilɗi, o maayi. ");
INSERT INTO fuhbkf_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ammaa konngol Laamɗo ngool ina yaara yeeso, ina ɓeyda sankitaade. ");
INSERT INTO fuhbkf_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Nde Barnabas e Sool tilinoo e golle muɓɓen Urusaliima fu, ɓe njeccodii e Yuhanna bi'eteeɗo Marku. ");
INSERT INTO fuhbkf_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Annabaaɓe e jannginooɓe ina ngoni ley kawrital goonɗinɓe gonngal Antiyoki ngaal. Kamɓe ngoni Barnabas e Simeyon noddirteeɗo Ɓaleejo e Lukiyus mo Sireene e Manahen, mawnidinɗo e Hirudus hooreejo leydi oon, kam e Sool. ");
INSERT INTO fuhbkf_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Nyannde gomma iɓe teddina Joomiraaɗo tawi iɓe ngondi e suumayeere, ndeen Ruuhu Ceniiɗo wi'i ɓe: —Cenndanee kam Barnabas e Sool saabe gollal ngal noddirmi ɓe ngaal. ");
INSERT INTO fuhbkf_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Caggal suumayeere e du'aare maɓɓe, ɓe njowi juuɗe maɓɓe e dow yimɓe ɗiɗo ɓeen, ɓe nuli ɗum'en. ");
INSERT INTO fuhbkf_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Nii Ruuhu Ceniiɗo nuliri ɓe. Ɓe njehi Selewkiya, ɓe naati laana maayo manngo ɓe ponndii ruunde Kipirus. ");
INSERT INTO fuhbkf_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Nde ɓe njottinoo Salamis dow ruunde ndeen, ɓe mbaajii konngol Laamɗo ley cuuɗi Alhuudiyankooɓe baajorɗi. Yuhanna bi'eteeɗo Marku ina wondi e maɓɓe, ina walla ɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Ɓe peƴƴiti ruunde ndeen faa ɓe njottii ngalluure wi'eteende Pafos. Toon ɓe tawi daggada Alhuudiyanke bi'eteeɗo Bar-Iisaa, biitotooɗo wo annabaajo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Wo o howruujo kaananke bi'eteeɗo Sergiya Pool. Oon wo jom hakkillo. O noddi Barnabas e Sool sabo imo yiɗi nanude konngol Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ammaa Elimas mo inndem fiirtata «daggada» oon salake ɓe. Imo filoo bonnitinde goonɗinal kaananke oon. ");
INSERT INTO fuhbkf_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ndeen Sool bi'eteeɗo Pool, kebbinaaɗo Ruuhu Ceniiɗo, ndaari mo faa wooɗi, ");
INSERT INTO fuhbkf_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","wi'i: —Ɓii Ibiliisa! Aan keewɗo jamba e hiila, ganyo ko laaɓi fuu! A selataa oonyude laabi Joomiraaɗo ponnditiiɗi naa? ");
INSERT INTO fuhbkf_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Joonin jukkungo Joomiraaɗo saaman e maaɗa, a wuman, a yi'ataa naange faa sarɗi oon yottoo. Wakkati oon ni, gite makko cuddini, ɗe niɓɓi. Imo memmemta, imo filoo ɗowoowo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Nde kaananke oon yi'unoo ko waɗi ɗuum ndeen, goonɗini Iisaa. Waaju haala Joomiraaɗo kaan haaynake ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pool e yaadiraaɓe muuɗum naati laana maayo manngo, ndilli Pafos, njottii Perge ley leydi Pamfiliya. Ɗoon Yuhanna bi'eteeɗo Marku seedi e maɓɓe, yeccii Urusaliima. ");
INSERT INTO fuhbkf_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ɓe ndilli Perge, ɓe ngari Antiyoki ley leydi Pisidiya. Ɓe naati waajordu nyalaande fowteteende, ɓe njooɗii. ");
INSERT INTO fuhbkf_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Caggal janngeede Tawreeta Muusaa e dewte annabaaɓe, hooreeɓe waajordu nduun neli ɓe noddee ɓe ngara yeeso muɓɓen. Ɓe mbi'i: —Sakiraaɓe, si oɗon njogii haala cemmbinooha yimɓe ɗo fu, kaalee. ");
INSERT INTO fuhbkf_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pool ummii, hunci junngo muuɗum faa ɓe kakkilana ɗum, wi'i: —Israa'iilankooɓe e hulɓe Laamɗo woɓɓe, kettinee: ");
INSERT INTO fuhbkf_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Laamɗo Israa'iilankooɓe oon suɓake maamiraaɓe meeɗen, teddinii lenyol maɓɓe nde ngol hoɗoynoo leydi Misira ndeen. O yaltiniri ɓe toon baawɗe makko. ");
INSERT INTO fuhbkf_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","O munyanii ɓe ley ladde faa waɗi duuɓi capanɗe nay. ");
INSERT INTO fuhbkf_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Caggal ko o halki lenyi jeɗɗi e ley leydi Kanaana, o hokki ndi yimɓe makko ndona ndi. ");
INSERT INTO fuhbkf_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ko ɓe ngoni ley Misira faa warde ko ɓe naati leydi Kanaana fu waɗii hono duuɓi keme nay e capanɗe joy. Caggal ɗuum, o hokki ɓe sarotooɓe faa jamaanu annabi Samuwiila. ");
INSERT INTO fuhbkf_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Nde ɗum faltinoo ndeen, ɓe nyaagii Laamɗo hokka ɓe kaananke. Laamɗo hokki ɓe Sawulu ɓii Kis ƴuuruɗo e lenyol Benyamin. Oon laamii ɓe duuɓi capanɗe nay. ");
INSERT INTO fuhbkf_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Ndeen Laamɗo ɓorti Sawulu, hokki Daawda laamu. O haali kabaaru muuɗum, o wi'i: «Mi heɓii Daawda ɓii Yesa gorko belnoowo ɓernde am, gaɗoowo muuyɗe am fuu.» ");
INSERT INTO fuhbkf_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","E ƴuwdi makko Laamɗo wurtini Iisaa, kisinoowo Israa'iila no aadorinoo noon. ");
INSERT INTO fuhbkf_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Fadde Iisaa warude, Yaayaa waajake yimɓe Israa'iila fuu tuuba, lootee lootagal batisima. ");
INSERT INTO fuhbkf_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Katin, nde Yaayaa timminannoo golle muuɗum ndeen, wi'i ɓe: «Mi wanaa mo miiloton ngonumi oon. Ammaa ina woodi garoowo caggal am, mo mi fotaay fay e haɓɓitinde ɓoggi paɗe muuɗum.» ");
INSERT INTO fuhbkf_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Sakiraaɓe, onon ƴuwdi Ibrahiima e hulɓe Laamɗo woɓɓe, wo enen nuldaa kabaaru kisinoowo o. ");
INSERT INTO fuhbkf_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Sabo wonɓe Urusaliima ɓeen e hooreeɓe muɓɓen fuu annditaay Iisaa. Katin du ɓe paamaay haalaaji annabaaɓe janngeteeɗi nyalaande fowteteende fuu. Annabaaɓe ɓeen mbi'ii Iisaa sarete. Ko ɓe carii mo ɗuum, ɓe tabintinii haalaaji ɗiin. ");
INSERT INTO fuhbkf_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Fay si taweede ɓe keɓaay daliili fuu no ɓe mbarda mo, ɓe nyaagake Pilaatu o waree. ");
INSERT INTO fuhbkf_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Nde ɓe ngollunoo ko Binndi ɗiin mbi'i e makko ɗuum faa hiɓɓi ndeen, ɓe njippini mo e leggal palaangal, ɓe ngaɗi mo e saabeere. ");
INSERT INTO fuhbkf_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ammaa Laamɗo iirtinii mo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Balɗe keewɗe o ɓangani wondunooɓe e makko ɓeen gilla Galili faa Urusaliima. Ɓeen ngoni seedantooɓe mo yeeso yimɓe joonin. ");
INSERT INTO fuhbkf_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Minen, miɗen ngaddana on Kabaaru Lobbo: ko Laamɗo aadaninoo maamiraaɓe meeɗen ɗuum, ");
INSERT INTO fuhbkf_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","yottinanii en, enen taaniraaɓe muɓɓen. O waɗii ɗum e ley ko o iirtini Iisaa. Noon winndiraa ley jimol Jabuura suura ɗiɗi: «Wo a ɓiyam, hannden mi laatake Baaba maa.» ");
INSERT INTO fuhbkf_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Katin du, Laamɗo iirtinii mo e hakkunde maayɓe, accaay ɓanndu makko nyoli. Noon haaldunoo nde wi'unoo: «Mi hokkan on barkeeji ceniiɗi ɗi mbonataa, ɗi podaninoomi Daawda ɗiin.» ");
INSERT INTO fuhbkf_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ɗum waɗi de o wi'i e Jabuura suura goɗɗo: «A accataa Ceniiɗo maa nyola.» ");
INSERT INTO fuhbkf_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Daawda gollii ko Laamɗo muuyi golla e jamaanu muuɗum. Caggal ɗuum, o maayi. Ɓanndu makko hawrunduraa e maamiraaɓe makko, ndu nyoli. ");
INSERT INTO fuhbkf_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ammaa mo Laamɗo iirtini oon nyolaay. ");
INSERT INTO fuhbkf_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Sakiraaɓe, anndee wo saabe makko de mbaajaɗon yaafeede hakkeeji. ");
INSERT INTO fuhbkf_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Tawreeta Muusaa waawaa waɗude neɗɗo ponnditiiɗo. De kanko kaa, goonɗinɗo mo fuu, o ndaardan ɗum ponnditiiɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Ɗum le, kaybee taa ko annabaaɓe cappinoo ɗuum hewtoo on: ");
INSERT INTO fuhbkf_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","«Onon jalnortooɓe golle am, ndaaree, de ɗum haaynoo on, de kalkon! Sabo mi waɗan goɗɗum e ley wakkati mooɗon, mo on ngoonɗintaa fay si neɗɗo haalannoo on.» ");
INSERT INTO fuhbkf_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Caggal Pool e Barnabas njaltii waajordu nduun, jamaa oon nyaagii ɓe ɓe ngarta fowteteende waroore, faa ɓe njaha yeeso e waaju maɓɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Caggal ko kawrital ngaal waɗi ɗuum, Alhuudiyankooɓe heewɓe e naatuɓe e diina muɓɓen njokki Pool e Barnabas. Ɓeen ɗiɗo fuu ina kaalda e maɓɓe, ina tindina ɓe ɓe keddoo e moƴƴere Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Fowteteende jokkunde ndeen, yimɓe ngalluure ndeen fuu kawriti faa kettinoo konngol Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ammaa nde Alhuudiyankooɓe ɓeen njiinoo jamaa oon ndeen, kiram naati ɓe. Iɓe njedda ko Pool waajotoo ɗuum, iɓe njenna ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Ndeen Pool e Barnabas kaaldirani ɓe tannyoral, mbi'i: —Waajibi onon min artotoo haalande konngol Laamɗo ngol. Ammaa saabe on paɗɗii ngol, on ndaardaay ko'e mooɗon oɗon poti heɓude nguurndam nduumiiɗam, min njahan to yimɓe ɓe nganaa Alhuudiyankooɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Sabo inan ko Joomiraaɗo yamiri min: «Mi darnii ma faa laatanoɗaa lenyi ɗiin annoora, faa kisinaa haddi adunaaru ndu fuu.» ");
INSERT INTO fuhbkf_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Nde yimɓe lenyi goɗɗi ɗiin nannoo haalaaji ɗiin ndeen, ceyii, teddini konngol Joomiraaɗo ngool. Ɓe Laamɗo suɓanii nguurndam nduumiiɗam ɓeen fuu ngoonɗini. ");
INSERT INTO fuhbkf_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Konngol Joomiraaɗo ngool sankitii e leydi ndiin fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ammaa Alhuudiyankooɓe ɓeen ummini hakkillooji rewɓe rewooɓe Laamɗo saahiiɓe, kam e mawɓe ngalluure ndeen. Ɓe ummini torra dow Pool e Barnabas, ɓe ndiiwi ɗum'en leydi maɓɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Kam'en du piɗɗi colla koyɗe muɓɓen e maɓɓe, de njehi Ikoniya. ");
INSERT INTO fuhbkf_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Taalibaaɓe ɓeen kebbinaa seyo e Ruuhu Ceniiɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ley Ikoniya du Pool e Barnabas naati e ley waajordu Alhuudiyankooɓe. Ley ko ɓe mbaajii ɗuum, Alhuudiyankooɓe e yimɓe lenyi goɗɗi heewɓe ngoonɗini. ");
INSERT INTO fuhbkf_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ammaa Alhuudiyankooɓe saliiɓe goonɗinde ɓeen ummini hakkillooji lenyi goɗɗi, mbonni ɓerɗe muɓɓen faa mbanya sakiraaɓe goonɗinɓe ɓeen. ");
INSERT INTO fuhbkf_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ammaa ɗum fuu haɗaay ɓe ɓooyude toon, iɓe mbaajoroo haala Joomiraaɗo cuusal, iɓe kolla hinney Joomiraaɗo. Yimɓe ɓeen annditii ko ɓe mbaajotoo ɗuum wo goonga, sabo Laamɗo hokki ɓe baawɗe waɗude maandeeji kaayniiɗi e golleeji kaayniiɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Yimɓe wuro ngoon peccii: woɓɓe keedani Alhuudiyankooɓe, woɓɓe du keedani nulaaɓe ɓeen. ");
INSERT INTO fuhbkf_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Yimɓe lenyi goɗɗi e Alhuudiyankooɓe e ardiiɓe muɓɓen anniyii torrude ɓe e wardude ɓe kaaƴe. ");
INSERT INTO fuhbkf_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Nde ɓe maatunoo ɗum ndeen, ɓe ndoggani Listara e Derbe e gure seraaji muɓɓen ley leydi Likoniya. ");
INSERT INTO fuhbkf_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Toon du iɓe mbaajoo Kabaaru Lobbo oon. ");
INSERT INTO fuhbkf_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ley Listara ɗoon ina woodi gorko bonnguujo, dimdaaɗo e bonngaaku. Abada o yahaay e koyɗe makko. ");
INSERT INTO fuhbkf_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Imo hettinii waaju Pool. Pool ndaari mo, yi'i o goonɗinii faa imo waawi danneede, ");
INSERT INTO fuhbkf_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","haali semmbe, wi'i: —Umma, dara e koyɗe maa! Gorko oon gurbitii, darii, ina yaha. ");
INSERT INTO fuhbkf_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Nde yimɓe ɓeen njiinoo ko Pool waɗi ɗuum ndeen, mbulli, mbi'i e ley haala Likoniya'en: —Alla'en njippake dow meeɗen, na nanndinkinii e yimɓe! ");
INSERT INTO fuhbkf_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ɓe inndiri Barnabas «Jewus», ɓe inndiri Pool du «Hermes», sabo Pool wonnoo kaaloowo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Suudu tooru maɓɓe wi'eteendu Jewus ina woni yaasin ngalluure toon. Almaami oon ƴuuri toon waddi ga'i maysiniraaɗi pinndi to dammbuɗe narruɗe ngalluure toon. Kanko e yimɓe ɓeen ina njiɗi waɗude ɗi kirsamaaji. ");
INSERT INTO fuhbkf_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Ammaa nde Barnabas e Pool nannoo ɗum ndeen, ɗum metti ɗum'en faa ceeki kaddule muɓɓen, kenyanii jamaa oon ina peekoo, ");
INSERT INTO fuhbkf_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","ina mbi'a: —Worɓe, ɗume ngaɗoton ɗo? Minen du min yimɓe hono mooɗon. Miɗen mbaajoo Kabaaru Lobbo oon faa tuubon, celon golleeji ɓoli ɗi, ngarton e Laamɗo buurɗo, taguɗo kammu e leydi e maayo manngo e ko woni e muɓɓen fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","E jamaanuuji paltiiɗi ɗiin o accii lenyi fuu njokka laabi muɓɓen. ");
INSERT INTO fuhbkf_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","E ɗum fuu, imo golla ko wooɗi faa ɗum seedanoo mbooɗirka makko. Imo tomnana on ƴuwoonde, imo ɓenndinana on nyaamri e wakkati muuɗum. Imo waaltinira hakkillooji mon nyaamdu e seyo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","No Pool e Barnabas mbaajorii nii fu, faa hannden wo e semmbe kaɗiri jamaa oon hirsande ɗum'en ga'i ɗiin. ");
INSERT INTO fuhbkf_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Caggal ɗuum, Alhuudiyankooɓe ƴuuri Antiyoki e Ikoniya. Ɓe keɓi hakkillooji yimɓe ɓeen faa limni Pool kaaƴe. Ɓe ndaasi ɗum, ɓe njoppowi ɗum faa caggal wuro ngoon, sabo ɓe miilii wo maayɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ammaa nde taalibaaɓe ɓeen ngarnoo piilii mo ndeen, o ummii, o soƴƴitii ley wuro ngoon. Jaango majjum, o yaadi e Barnabas wuro wi'eteengo Derbe. ");
INSERT INTO fuhbkf_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Nde ɓe mbaajinoo toon Kabaaru Lobbo fu, yimɓe heewɓe laatii taalibaaɓe Iisaa. Caggal ɗuum, ɓe njeccii Listara e Ikoniya, kam e Antiyoki. ");
INSERT INTO fuhbkf_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Iɓe ɓeydana taalibaaɓe semmbe, iɓe tindina ɗum'en keddoo e goonɗinal, iɓe mbi'a: —Sanaa tampen tampiriiji keewɗi fadde men e naatude laamu Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","E ley kawrite goonɗinɓe ɗeen fuu, ɓe cuɓanii ɗum'en mawɓe. Caggal ɗuum, ɓe cuumii, ɓe ndu'ii, ɓe kalfini ɗum'en Joomiraaɗo mo ɓe ngoonɗini oon. ");
INSERT INTO fuhbkf_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Nde ɓe ceekunoo leydi Pisidiya ndeen, ɓe ngari leydi Pamfiliya. ");
INSERT INTO fuhbkf_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Ɓe mbaajii konngol ngol ley wuro Perge. Caggal ɗuum, ɓe njippowii Ataliya. ");
INSERT INTO fuhbkf_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Toon ɓe naati laana maayo manngo, ɓe pornyii Antiyoki ɗo ɓe kalfinanoo moƴƴere Laamɗo faa ɓe ngolla gollal ngal ɓe tilii ngaal. ");
INSERT INTO fuhbkf_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Nde ɓe njottinoo ndeen, ɓe kawrunduri yimɓe kawrital goonɗinɓe ngaal, ɓe kaalani ngal no Laamɗo nawtorii ɓe, no o omtirani yimɓe ɓe nganaa Alhuudiyankooɓe dammbugal goonɗinal. ");
INSERT INTO fuhbkf_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ɓe keddii ɗoon faa ɓooyti, iɓe ngondi e taalibaaɓe ɓeen. ");
INSERT INTO fuhbkf_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Yimɓe woɓɓe ƴuuri Yahuudiya ngari Antiyoki, ina njanngina sakiraaɓe ɓeen, ina mbi'a: —Si on taadiraaka hono no Muusaa wi'iri noon fu, on kisataa. ");
INSERT INTO fuhbkf_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pool e Barnabas pooɗunduri e maɓɓe, ndukidi e maɓɓe faa tiiɗi. Ndelle ɓe tabintini nelde Pool e Barnabas e yimɓe woɓɓe faa Urusaliima, ɓe kaaldowa e nulaaɓe e mawɓe goonɗinɓe ɓeen dow majjum. ");
INSERT INTO fuhbkf_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ndelle kawrital goonɗinɓe ngaal neli ɓe. Ɓe peƴƴiti leyɗe Finisi e Samariya, iɓe kaalana goonɗinɓe toon haala tuubugol yimɓe ɓe nganaa Alhuudiyankooɓe. Ɗum laatanii sakiraaɓe ɓeen fuu seyo manngo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Nde ɓe njottinoo Urusaliima ndeen, kawrital goonɗinɓe ngaal e nulaaɓe e mawɓe ɓeen njaɓɓii ɓe. Ɓe kaalani ɗum'en ko Laamɗo gollitiri ɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ammaa woɓɓe ley goonɗinɓe jeyaaɓe e fedde Farisa'en ummii, mbi'i: —Waajibi ɓe taadee, ɓe njamiree jokkude Tawreeta Muusaa. ");
INSERT INTO fuhbkf_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Nulaaɓe e mawɓe ɓeen kawriti faa ndaara haala kaan. ");
INSERT INTO fuhbkf_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Caggal ko haalaaji ɗiin keewii, Piyeer ummii, wi'i ɓe: —Sakiraaɓe, oɗon anndi Laamɗo suɓake kam e ley mooɗon gilla ko ɓooyi. O suɓake kam faa mi waajoo Kabaaru Lobbo oon hakkunde yimɓe ɓe nganaa Alhuudiyankooɓe, faa ɓe nana, ɓe ngoonɗina. ");
INSERT INTO fuhbkf_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Laamɗo annduɗo ɓerɗe oon hollii jaɓanii ɓe, nde hokkunoo ɓe Ruuhu Ceniiɗo hono no meeɗen ni. ");
INSERT INTO fuhbkf_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Walaa fuu ko o senndiri en e maɓɓe, e ley ko o laaɓiniri ɓerɗe maɓɓe e goonɗinal. ");
INSERT INTO fuhbkf_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Joonin, ko waɗi de oɗon ndaartindoo Laamɗo? Oɗon njowa e taalibaaɓe ɓeen donngal ngal enen e maamiraaɓe meeɗen fuu en mbaawaay ronndaade. ");
INSERT INTO fuhbkf_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","A'aa. Wo moƴƴere Joomiraaɗo meeɗen Iisaa de tannyorɗen hisineede. Hono noon kamɓe du. ");
INSERT INTO fuhbkf_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Kawrital ngaal fuu deƴƴinii siw, ina hettinii ko Barnabas e Pool pillotoo no Laamɗo hokkiri ɗum'en waɗude maandeeji kaayniiɗi e kaayeefiiji hakkunde lenyi goɗɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Nde ɓe kettinnoo haalaaji ɗiin faa wooɗi fu, Yaakuuba ɓeydi haala, wi'i: —Sakiraaɓe, kettinanee kam! ");
INSERT INTO fuhbkf_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simon humpitii en no Laamɗo artorii hakkilande yimɓe ɓe nganaa Alhuudiyankooɓe, faa waɗa ɗum'en yimɓe muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ɗum hawrii e haalaaji annabaaɓe ɗiin, hono no winndiraa ni: ");
INSERT INTO fuhbkf_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","«Joomiraaɗo wi'i: Caggal ɗuum, mi wartan, mi nyiɓtoo suudu Daawda saamundu nduun, mi fonndita ko boni e mayru, mi darna ndu katin, ");
INSERT INTO fuhbkf_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","faa yimɓe heddiiɓe fuu tewta Joomiraaɗo, lenyi ɗi noddammi fuu, faa laatoo yimɓe am. ");
INSERT INTO fuhbkf_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Joomiraaɗo tabintinɗo kulle ɗe anndunoo waɗan gilla arande, kam wi'i noon.» ");
INSERT INTO fuhbkf_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Ɗum saabii miin kaa ko nji'umi, taa tiiɗinanen lenyi goɗɗi tuubuɗi ngarti e Laamɗo ɗiin. ");
INSERT INTO fuhbkf_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Ammaa mbinndanen ɓe ɓe ndeentoo e ko tooruuji tuunini e jeenu e nyaamude ko saaɗi e nyaamude ƴiiƴam. ");
INSERT INTO fuhbkf_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Gilla e jamaanuuji ɓooyɗi, Tawreeta Muusaa ina jannginee ley gure ɗeen fuu, iɓe njannga ɗum nyalaande fowteteende fuu ley cuuɗi baajorɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Ndeen nulaaɓe ɓeen e mawɓe e kawrital goonɗinɓe ngaal fuu paamiri faa cuɓoo worɓe e ley muɓɓen faa nela ɗum'en Antiyoki, ɓe njaada e Pool e Barnabas. Ɓe cuɓii Yahuuda bi'eteeɗo Barasaba, kam e Silas. Ɗiɗo ɓeen fuu wo ardiiɓe ley sakiraaɓe goonɗinɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Inan ɓataaki ki ɓe kokki ɗum'en: Minen sakiraaɓe mooɗon nulaaɓe e mawɓe, miɗen njowta on, onon sakiraaɓe amin lenyi goɗɗi gonɗi Antiyoki e Siiriya e Silisi. ");
INSERT INTO fuhbkf_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Min nanii yimɓe ƴuuruɓe to amin mettinirii ɓerɗe mooɗon haalaaji, njiiɓii hakkillooji mooɗon. Minen le, min njamiraay ɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Min ndawridii, min paamiri min cuɓoo worɓe faa min nela ɗum'en to mooɗon, ɓe njaada e yigiraaɓe amin horsuɓe Barnabas e Pool, ");
INSERT INTO fuhbkf_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","farritinɓe yonkiiji muɓɓen saabe Joommen Iisaa Almasiihu. ");
INSERT INTO fuhbkf_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Ɗum waɗi de min neli Yahuuda e Silas, paamina on ko min mbinndi e mooɗon ɗuum hunnduko e hunnduko. ");
INSERT INTO fuhbkf_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Minen e Ruuhu Ceniiɗo, min anniyake taa min njowa on doŋle tedduɗe si wanaa ko tilsi ɗuum: ");
INSERT INTO fuhbkf_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","ndeentoɗon e kirsanaaɗi tooruuji e ƴiiƴam e ko saaɗi e jeenu. Si on ndeenii ko'e mooɗon e kujje ɗe, on ngaɗii ko wooɗi. Laamɗo reena en! ");
INSERT INTO fuhbkf_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Wooɗi, ɓe kokkaa laawol, ɓe njehi Antiyoki. Nde ɓe njottinoo ndeen, ɓe kawrunduri kawrital goonɗinɓe ngaal, ɓe kokki ngal ɓataaki kiin. ");
INSERT INTO fuhbkf_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Nde ɓeen janngunoo ki ndeen, ceyii sabo haalaaji ɗiin cemmbinii ɓerɗe muɓɓen. ");
INSERT INTO fuhbkf_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yahuuda e Silas wo annabaaɓe. Ɓe mbaaltiniri ɓerɗe sakiraaɓe e haalaaji keewɗi, ɓe cemmbini ɗum'en. ");
INSERT INTO fuhbkf_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Nde ɓe ɓooytunoo toon seeɗa fu, ɓe ceedi e sakiraaɓe ɓeen e dow jam, ɓe njeccii to nelnooɓe ɓe toon.  ");
INSERT INTO fuhbkf_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","De Silas, kam kaa, heddii toon. ");
INSERT INTO fuhbkf_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pool e Barnabas keddii ley Antiyoki ɗoon. Kam'en e woɓɓe heewɓe ina njanngina ina mbaajoo konngol Joomiraaɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Caggal balɗe seeɗa, Pool wi'i Barnabas: —Njeccoɗen e gure ɗe mbaajinoɗen konngol Joomiraaɗo ɗeen fuu, njippanoɗen sakiraaɓe meeɗen ɓeen, ndaaren no ɓe ngorri. ");
INSERT INTO fuhbkf_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabas ina yiɗi ɓe njaada e Yuhanna bi'eteeɗo Marku. ");
INSERT INTO fuhbkf_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","De Pool kaa muuyaay ɓe njaada e gorko oon, sabo oon seediino e maɓɓe Pamfiliya, yaadaay e maɓɓe faa gollida e maɓɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Barnabas e Pool luuri faa ceedi. Mono e maɓɓe fuu suɓii neɗɗo goɗɗo. Barnabas yaadi e Marku, naati laana maayo, fonndii ruunde Kipirus. ");
INSERT INTO fuhbkf_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pool du suɓii yaadude e Silas. Sakiraaɓe ɓeen kalfinii ɓe e hinney Joomiraaɗo de ɓe ndilli. ");
INSERT INTO fuhbkf_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Ɓe ndewi leyɗe Siiriya e Silisi, iɓe cemmbina kawrite goonɗinɓe ɗeen. ");
INSERT INTO fuhbkf_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pool wari Derbe. Caggal ɗuum, o yottii Listara. Goonɗinɗo bi'eteeɗo Timote ina tawaa ɗoon. Inniiko wo Alhuudiyanke goonɗinɗo, de baabiiko wo neɗɗo ƴuuruɗo Geres. ");
INSERT INTO fuhbkf_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Sakiraaɓe wonɓe Listara e Ikoniya ɓeen ina ceedanoo mo wo o lobbo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pool ina yiɗi faa o yaada e muɓɓen. Ndelle yaari mo faa o taadee tafon, sabo Alhuudiyankooɓe wonɓe e leyɗe ɗeen ɓeen fuu ina anndi baabiiko wo ƴuuruɗo Geres. ");
INSERT INTO fuhbkf_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Ley gure ɗe ɓe peƴƴiti ɗeen, iɓe njottinana goonɗinɓe jamirooje ɗe nulaaɓe e mawɓe wonɓe Urusaliima ɓeen kolli ɓe njokka. ");
INSERT INTO fuhbkf_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Hono noon, kawrite goonɗinɓe ɗeen ina ɓeydoo semmbe ley goonɗinal, ina ɓeydoo heewude nyannde fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Ruuhu Ceniiɗo haɗi ɓe waajaade konngol ngol ley Aasiya. Saabe majjum ɓe ndewi leydi Firigiya e leydi Galaatiya. ");
INSERT INTO fuhbkf_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Nde ɓe ngarnoo keerol Misiya ndeen, ɓe pilii yaade Bitiniya, ammaa Ruuhu Iisaa accaay ɓe naata. ");
INSERT INTO fuhbkf_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Saabe ɗuum, ɓe paltii Misiya, ɓe naati e wuro wi'eteengo Torowas. ");
INSERT INTO fuhbkf_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Jemma oon, Pool heɓi holleede. O yi'i gorko Makedoniyanke ina darii, ina nyaagoo mo ina wi'a: —Ngaraa Makedoniya, mballaa min! ");
INSERT INTO fuhbkf_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Nde Pool yiinoo ko hollaa ɗum ndeen, wakkati oon ni, filii yahude Makedoniya. Min tannyorii Laamɗo noddii min faa min mbaajoo ɓe Kabaaru Lobbo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Hono noon, min naati laana maayo ƴuuruka Torowas, min ponndii ruunde Samotaras. Jaango majjum, min ponndii Neyapolis. ");
INSERT INTO fuhbkf_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Min ƴuwi ɗoon, min ponndii Filipi. Filipi wo ngalluure mawnde e leydi Makedoniya nde Romankooɓe ndawranta. Min ngaɗi balɗe seeɗa ɗoon. ");
INSERT INTO fuhbkf_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Nyalaande fowteteende, min njaltiri wuro ngoon hedde daande maayo to min miili Alhuudiyankooɓe na mboownoo waɗude du'aare. Min tawi ɗoon rewɓe ina kawriti. Min njooɗii, min mbaajii ɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Gooto maɓɓe wo debbo jokkuɗo Laamɗo bi'eteeɗo Lidiya. Wo o connoowo kaddule boɗeeje, jeyaaɗo ngalluure wi'eteende Tiyatira. Imo hettindii waaju oon, de Joomiraaɗo omti ɓernde makko faa o jaɓa ko Pool waajotoo ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Kanko e koreeji makko fuu ɓe lootaa lootagal batisima. Caggal ɗuum, o nyaagii min, o wi'i: —Si oɗon tiigorii kam mi goonɗinɗo Joomiraaɗo fu, ngaree suudu am, mbeeranon kam. O tilsinani min faa min njaɓi. ");
INSERT INTO fuhbkf_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Nyannde wootere miɗen njaha to nokkuure waɗirde du'aare. Korɗo gonduɗo e ginnaaru hawriti e amin. Wo o ji'oowo ko warata. Joomiraaɓe makko keɓii kaalisi keewɗo e ndaggadaaku makko nguun. ");
INSERT INTO fuhbkf_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","O jokki min, minen e Pool, imo feekoo, imo wi'a: —Yimɓe ɓe wo gollanooɓe Laamɗo Toowɗo! Iɓe mbaajoo on laawol kisindam! ");
INSERT INTO fuhbkf_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Balɗe keewɗe imo waɗa noon faa ɓernde Pool ummii, hucciti e makko, wi'i ginnaaru nduun: —Saabe Iisaa Almasiihu, yaltu e debbo o! Ginnaaru nduun yalti wakkati oon pay. ");
INSERT INTO fuhbkf_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Nde joomiraaɓe korɗo oon paamunoo laawol muɓɓen hemrude ceede e makko timmii fu, nanngi Pool e Silas, ndaasi ɗum'en ngaddi faa ley luumo yeeso sarotooɓe wuro ngoon. ");
INSERT INTO fuhbkf_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Ndeen ɓe njaari ɗum'en to hooreeɓe, ɓe mbi'i: —Worɓe ɗiɗo ɓe wo Alhuudiyankooɓe. Iɓe ngadda baasi e wuro meeɗen ngo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Iɓe mbaajoo al'aadaaji ɗi ndaganaaki en njaɓen naa ngollen, sabo en Romankooɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Jamaa oon ummanii ɓe. Hooreeɓe ɓeen njamiri ɓe ɓortee kaddule maɓɓe, de ɓe piiree loosi. ");
INSERT INTO fuhbkf_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Ɓe piyaa faa naawi, ɓe paɗɗaa ley kasu. Hooreeɓe ɓeen njamiri kayboowo kasu oon hayba ɓe faa wooɗa. ");
INSERT INTO fuhbkf_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Oon le, nde heɓunoo yamiroore ndeen fu, nanni ɓe e ley suudu kasu hakkundeeru. O geƴƴiri koyɗe maɓɓe geƴƴelle leɗɗe. ");
INSERT INTO fuhbkf_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Hakkunde jemma oon, Pool e Silas ina ngaɗa du'aare, ina njimana Laamɗo. Kasunkooɓe woɓɓe ɓeen du ina kettindanii ɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","De wakkati gooto, leydi dimmbii dimmbagol manngol faa joƴƴinirɗe kasu ɗeen njergii. Wakkati oon du, dammbuɗe ɗeen fuu omtii, geƴƴelle kasunkooɓe ɗeen fuu kaɓɓitii. ");
INSERT INTO fuhbkf_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Nde kayboowo oon finnoo de yi'i dammbuɗe kasu ɗeen ina omtii fu, soorti kaafaahi muuɗum faa waritoo, miilii kasunkooɓe ɓeen ndoggii. ");
INSERT INTO fuhbkf_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Pool ƴeewnii faa toowi, wi'i mo: —Taa waɗu hoore maa ko boni, min fuu ɗo min ngoni! ");
INSERT INTO fuhbkf_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Ndeen kayboowo oon ŋaarii jaynorgol. O doggiri kasu to Pool e Silas ngoni toon, o hippii yeeso muɓɓen, heddii imo diwna. ");
INSERT INTO fuhbkf_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Caggal ɗuum, o wurtini ɓe, o wi'i ɓe: —Joomiraaɓe, noy kaanumi waɗude faa mi hisa? ");
INSERT INTO fuhbkf_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ɓe njaabii mo, ɓe mbi'i: —Goonɗin Iisaa Joomiraaɗo, ndeen a hisan, aan e koreeji maa fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ɓe mbaajii mo konngol Joomiraaɗo, kanko e koreeji makko fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Faa ɓooyti seeɗa, ley jemma oon o yaari ɓe, o lootowi barme maɓɓe. Wakkati oon du o lootaa lootagal batisima, kanko e koreeji makko fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","O nanni Pool e Silas suudu makko, o hokki ɗum'en nyaamdu. Kanko e koreeji makko fuu ɓe ceyii sabo ɓe keɓii goonɗinde Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Nde weetunoo ndeen, hooreeɓe Romankooɓe neli yimɓe laamu mbi'a kayboowo oon yoppa worɓe ɗiɗo ɓeen. ");
INSERT INTO fuhbkf_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Kayboowo oon haalanowi ɗum Pool, wi'i: —Hooreeɓe ɓeen nulii njoppeɗon. Mburtee joonin, njehee e jam. ");
INSERT INTO fuhbkf_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ammaa Pool jaabii, wi'i: —Ɓe njamirii min piyee yeeso yimɓe tawa min caraaka, fay si min ɗiɗo fuu min Romankooɓe. Ɓe nanni min e kasu. Joonin ɓe njaltiniran min cuncukka naa? Ɗum kaa laatataako. Sanaa kamɓe e ko'e maɓɓe, ɓe ngara ɓe njaltina min! ");
INSERT INTO fuhbkf_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Yimɓe laamu ɓeen kaaltani hooreeɓe Romankooɓe ɓeen haala kaan. Ɓeen kuli nde nannoo Pool e Silas wo Romankooɓe ndeen. ");
INSERT INTO fuhbkf_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Ɓe njehi, ɓe curowi ɗum'en, ɓe mburtini ɗum'en kasu toon. Ɓe nyaagii ɗum'en ndilla wuro ngoon. ");
INSERT INTO fuhbkf_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Nde Pool e Silas njaltunoo e kasu ndeen, naati galle Lidiya. Ɓe nji'i sakiraaɓe ɓeen, ɓe cemmbini ɓerɗe muɓɓen. Caggal ɗuum, ɓe ndilli. ");
INSERT INTO fuhbkf_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pool e Silas peƴƴiti Amfipolis e Apoloni faa njottii Tesaloniiki. Ina woodi waajordu Alhuudiyankooɓe toon du. ");
INSERT INTO fuhbkf_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pool waɗi no woowri, naati ley waajordu nduun. Nyalaaɗe powteteeɗe tati imo liddundura e maɓɓe imo fiirtana ɓe Binndi ɗiin. ");
INSERT INTO fuhbkf_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","O fiirtani ɓe, o holli ɓe ina tilsunoo Almasiihu oon torree, ummintinee e maayde. O wi'i ɓe: —Iisaa mo mbaajotoomi on haala muuɗum oon, kam woni Almasiihu. ");
INSERT INTO fuhbkf_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Woɓɓe maɓɓe tannyori ɗum goonga, njokki mo, kanko Pool, e Silas. Yimɓe Geresankooɓe rewooɓe Laamɗo heewɓe e rewɓe saahiiɓe ɗuuɗuɓe du njokki ɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Alhuudiyankooɓe ɓe nganaa goonɗinɓe ɓeen kiri Pool e Silas, nanngi yimɓe huyfuɓe yiilotooɓe ley luumo, kawrunduri ɗum'en. Ɓe njirkiti ngalluure ndeen fuu. Ɓe naati e galle Yason, iɓe piloo Pool e Silas faa ɓe njaara ɗum'en yeeso yimɓe wuro. ");
INSERT INTO fuhbkf_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Nde ɓe kunnginoo yiitude ɗum'en ndeen, ɓe ndaasi Yason e sakiraaɓe woɓɓe, ɓe ngaddi ɗum'en to sarotooɓe ngalluure ndeen, iɓe peekoo, iɓe mbi'a: —Yimɓe umminooɓe baasi e aduna o fuu ngarii ɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Yason weerni ɗum'en! Ɓe fuu ko ɓe ngaɗata ɗuum ina luttunduri e sariya kaananke Roma mawɗo oon. Iɓe mbi'a kaananke goɗɗo ina woodi, bi'eteeɗo Iisaa. ");
INSERT INTO fuhbkf_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Haalaaji ɗiin njirkiti jamaa oon e sarotooɓe ngalluure ndeen. ");
INSERT INTO fuhbkf_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Sarotooɓe ɓeen njomnii Yason e wonduɓe e muuɗum ɓeen, njaɓi buuɗi ɗiin, de njoofi ɗum'en. ");
INSERT INTO fuhbkf_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Jemma oon pay, sakiraaɓe ɓeen neli Pool e Silas Bereya. Nde ɓe njottinoo ndeen, ɓe njehi to waajordu Alhuudiyankooɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Yimɓe wonɓe ɗoon ina ɓuri Alhuudiyankooɓe wonɓe Tesaloniiki ɓeen jikku lobbo. Ɓe njakkitorii konngol Pool ngool e juuɗe ɗiɗi. Iɓe piloo ley Binndi ɗiin nyannde fuu faa ɓe ndaara yalla ko Pool waajii ɗuum wo goonga. ");
INSERT INTO fuhbkf_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Heewɓe e maɓɓe ngoonɗini, kam e rewɓe Geresankooɓe saahiiɓe e worɓe Geresankooɓe heewɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Nde Alhuudiyankooɓe Tesaloniiki paamunoo Pool waajake konngol Laamɗo ley Bereya ndeen, ɓe ngari toon, ɓe njirkiti jamaa oon, ɓe ummini hakkillooji muɓɓen. ");
INSERT INTO fuhbkf_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Wakkati oon fu, sakiraaɓe ɓeen neli Pool to maayo manngo faa hooƴa laana, de Silas e Timote keddii ɗoon. ");
INSERT INTO fuhbkf_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Ɗowtuɓe Pool ɓeen njaadi e muuɗum faa Ateena. Pool yeccini ɓe Bereya faa ɓe kaalana Silas e Timote ngara to muuɗum law. ");
INSERT INTO fuhbkf_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Pool ina doomi ɓe Ateena fadde maɓɓe warude. Ɓernde muuɗum naawi sanne ko yi'i no ngalluure ndeen foti heewde tooruuji noon. ");
INSERT INTO fuhbkf_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Ɗum waɗi de o haaldi e Alhuudiyankooɓe e rewooɓe Laamɗo wonɓe ley waajordu nduun. Nyannde fuu imo haalda e yimɓe wuro ngoon taliyaare to ɓe kawritata toon. ");
INSERT INTO fuhbkf_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Woɓɓe ley filotooɓe paamal wi'eteeɓe Epikuri'en e Sitoyko'en njaabunduri e makko. Woɓɓe ina mbi'a: —Ɗume borbortoowo o haalata? Woɓɓe du ina mbi'a: —Imo nanndi e baajotooɗo haala tooruuji janani. Walaa ko ɓe mbiiri noon si wanaa haala Iisaa e ummital maayɓe o waajinoo ɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Ndeen ɓe kooƴi Pool, ɓe njaari ɗum waamnde to kawrital Areyopagus waɗata. Ɓe mbi'i ɗum: —Miɗen njiɗi anndude diina keso mo mbaajotoɗaa oon. ");
INSERT INTO fuhbkf_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Si goonga, aɗa toɓɓa e noppi amin haalaaji ɗi min mboowaa nanude. Miɗen njiɗi anndude maanaa majji. ");
INSERT INTO fuhbkf_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Tawi Ateenankooɓe e jananɓe jooɗiiɓe toon ɓeen ngollataa huunde fuu si wanaa hettindaade huunde heyre naa fillitaade nde. ");
INSERT INTO fuhbkf_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Ndeen Pool darii hakkunde kawrital Areyopagus, wi'i: —Ateenankooɓe, mi yi'ii on yiɗuɓe diina mooɗon sanne. ");
INSERT INTO fuhbkf_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Sabo ko njiiltiimi e ngalluure mooɗon ɗuum, mi yi'ii cuuɗi mooɗon dewirɗi, mi tawii ina winndaa e ittirde sadaka wootere: «Saabe Alla mo anndaaka». Ndelle, Alla mo on anndaa oon, kam mbaajotoomi on. ");
INSERT INTO fuhbkf_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Laamɗo taguɗo adunaaru e ko woni e muuɗum fuu oon, kam woni jom kammu e leydi. O jooɗataako ley cuuɗi nyiɓiraaɗi juuɗe. ");
INSERT INTO fuhbkf_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","O haajaaka yimɓe ngollana mo fay huunde, sabo kanko hokkata tageefo ngoon fuu nguurndam e foofaango e huunde fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","E neɗɗo gooto Laamɗo wurtiniri lenyi ɗiin fuu, joƴƴini ɗum'en e adunaaru ndu. Gilla ɗum waɗaay, o darnii wakkatiiji e keeri koɗorɗe muɓɓen. ");
INSERT INTO fuhbkf_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Laamɗo waɗii ɗum faa ɓe piloo ɗum, ɓe memmemta faa ɓe njiita ɗum. E ɗum fuu o woɗɗaaki fay gooto e meeɗen. ");
INSERT INTO fuhbkf_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Kam waɗi de eɗen mbuura, eɗen njaha, eɗen ngoni ɗo. Hono noon du yimooɓe mooɗon woɓɓe mbi'i: «Enen du, en ƴuwdi makko.» ");
INSERT INTO fuhbkf_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Sabo en ƴuwdi makko, en kaanaa miilaade imo nanndi e tooru moƴƴiniraandu kaŋŋe naa cardi naa hayre sehaande, nde neɗɗo moƴƴinirta nyeenyal e hakkillo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Laamɗo rewtidaaki yimɓe nde ngonnoo ley majjere ndeen. Joonin, o yamirii yimɓe fuu tuuba ɗo tawaa fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Sabo o waɗii nyannde nde o sarotoo adunaaru ndu e fonnditaare. O sarortoo ɗum e neɗɗo mo o suɓii oon. O hollii yimɓe fuu ɗum wo goonga nde o ummintinnoo neɗɗo oon e maayde. ");
INSERT INTO fuhbkf_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Nde ɓe nannoo Pool ina waajoo haala ummital maayɓe ndeen, woɓɓe na njalnoroo mo, de woɓɓe na mbi'a: —Min kettindoto waaju maa o nyannde wonnde. ");
INSERT INTO fuhbkf_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Nii Pool wurtorii ley maɓɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Woɓɓe njokki mo, ngoonɗini. Gooto maɓɓe ina wi'ee Diyonisiyus, jeyaaɗo e kawrital Areyopagus. Kam e debbo bi'eteeɗo Damaris, e woɓɓe katin du ngoonɗini. ");
INSERT INTO fuhbkf_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Caggal ɗuum, Pool dilli Ateena, yehi Korintu. ");
INSERT INTO fuhbkf_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","O tawi toon Alhuudiyanke bi'eteeɗo Akila, jeyaaɗo leydi mbi'eteendi Ponta. Ɓooyaay ko oon e deekum bi'eteeɗo Pirisilla ƴuuri Itali, sabo Kalawdiyus kaananke mawɗo oon yamiriino Alhuudiyankooɓe fuu mburtoo Roma. Pool yehi ndaarude ɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","O wondi e maɓɓe ɗoon, imo gollida e maɓɓe sabo wo o gaɗoowo hukumuuji hono no maɓɓe ni. ");
INSERT INTO fuhbkf_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Nyalaande fowteteende fuu, Pool ina liddundura e Alhuudiyankooɓe e Geresankooɓe ley waajordu. Imo filoo faa ɓe ngoonɗina. ");
INSERT INTO fuhbkf_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Nde Silas e Timote ƴuurnoo Makedoniya njottii Korintu ndeen, Pool watti hakkillo muuɗum fuu e waajaade, ina seedanoo Alhuudiyankooɓe ɓeen Iisaa woni Almasiihu. ");
INSERT INTO fuhbkf_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ammaa saabe ko ɓe calanii mo, iɓe njenna mo, o fiɗɗi kaddule makko, o wi'i ɓe: —Si Laamɗo jukkake on fu, wo feloore mooɗon! Miin kaa, mi walaa feloore. Gilla joonin mi yahan to ɓe nganaa Alhuudiyankooɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","O dilli ɗoon, o yehi to gorko jokkuɗo Laamɗo, bi'eteeɗo Tiitu Yustus, mo galle muuɗum takkii e waajordu nduun. ");
INSERT INTO fuhbkf_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Kirispus, hooreejo waajordu nduun oon, kam e koreeji muuɗum fuu ngoonɗini Joomiraaɗo. Heewɓe e Korintunkooɓe hettindiiɓe ɓeen ngoonɗini, de lootaa lootagal batisima. ");
INSERT INTO fuhbkf_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Jemma gooto Joomiraaɗo haaldi e Pool ley holleede, wi'i: —Taa hulu, taa deƴƴina. Waaja, ");
INSERT INTO fuhbkf_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","sabo miɗo wondi e maaɗa. Fay gooto waawaa torrude ma. Miɗo woodi yimɓe heewɓe ley ngalluure nde. ");
INSERT INTO fuhbkf_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Pool jooɗii hakkunde maɓɓe hitaande e lebbi jeegom, ina janngina ɓe konngol Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Nde Galliyo laaminoo leydi Akaya ndeen, Alhuudiyankooɓe paamiri, ummanii Pool, njaari ɗum suudu sariya, ");
INSERT INTO fuhbkf_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","peli ɗum, mbi'i: —Gorko o na nannga hakkillooji yimɓe faa ndewra Laamɗo e laawol ngol wanaa Tawreeta Muusaa. ");
INSERT INTO fuhbkf_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pool anniyii faa jaaboo ɓe, de Galliyo wi'i Alhuudiyankooɓe ɓeen: —Alhuudiyankooɓe, si tawii wo toonya naa gollal bonngal o waɗi on, mi jaɓanan on ko mbullitiɗon dow makko ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ammaa wo ɗum jeddi dow haalaaji diina mooɗon e inɗe tan. Wo jeddi dow sariya mooɗon onon. Ndelle sanaa caroɗon onon e ko'e mooɗon. Miin kaa, mi sarataako kulle ɗeen! ");
INSERT INTO fuhbkf_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Caggal ɗuum, o wurtini ɓe suudu sariya nduun. ");
INSERT INTO fuhbkf_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Joonin le, ɓe fuu ɓe nanngi Sosteni, hooreejo waajordu nduun, ɓe piyi ɗum yeeso suudu sariya ɗoon. Ammaa e ɗum fuu Galliyo hillaaka fey. ");
INSERT INTO fuhbkf_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pool ɓooyti ɗoon balɗe keewɗe. Caggal ɗuum, o waynunduri e sakiraaɓe ɓeen, o naati laana, o fonndii Siiriya, kanko e Pirisilla e Akila. Fadde makko naatude laana kaan, o laɓi hoore makko nokku bi'eteeɗo Kankiriya saabe ko o hunii Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Ɓe njottii Efeesu. Pool yoppi ɗoon Pirisilla e Akila. Kam kaa naati waajordu ina liddundura e Alhuudiyankooɓe ɓeen. ");
INSERT INTO fuhbkf_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Ɓe nyaagii mo o wonda e maɓɓe, de o jaɓaay. ");
INSERT INTO fuhbkf_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Nde o waynundurannoo e maɓɓe ndeen, o wi'i: —Mi wartowan to mooɗon si Laamɗo jaɓii. O naati laana, o dilli Efeesu. ");
INSERT INTO fuhbkf_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","O yehi faa o yottii Kaysariya, de o ƴeenti Urusaliima faa o jowta kawrital goonɗinɓe ngaal. Caggal ɗuum, o yehi Antiyoki. ");
INSERT INTO fuhbkf_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Pool ɓooyti toon seeɗa de dilli. O feƴƴiti leydi Galaatiya e leydi Firigiya, imo yaha imo semmbina ɓerɗe taalibaaɓe toon fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Alhuudiyanke bi'eteeɗo Apolos, dimaaɗo Alesandiri, wari Efeesu. Wo o baawɗo haala, annduɗo Binndi ɗiin, ");
INSERT INTO fuhbkf_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","jannguɗo laawol Joomiraaɗo. Imo teeŋi e waaju sanne, imo janngina kabaaru Iisaa faa laaɓa. De wo lootagal batisima ngal Yaayaa waɗunoo ngaal tan o anndi. ");
INSERT INTO fuhbkf_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Imo waajoroo tannyoral e ley waajordu nduun. Nde Pirisilla e Akila kettindaninoo mo fu, njaari mo, piirtani mo laawol Laamɗo ngool, ɓeydani mo ko o anndaano. ");
INSERT INTO fuhbkf_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Nde Apolos anniyinoo yaade leydi Akaya ndeen, sakiraaɓe ɓeen mballi mo. Ɓe mbinndani taalibaaɓe wonɓe toon ɓeen ɓataaki njaɓɓoo mo faa wooɗa. Nde o yottinoo toon ndeen, o walli goonɗinɓe ɓeen e dow moƴƴere Laamɗo sanne. ");
INSERT INTO fuhbkf_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Sabo imo yedda Alhuudiyankooɓe imo liɓa haala muɓɓen hakkunde yimɓe, imo hollira ɗum'en ley Binndi Ceniiɗi wo Iisaa woni Almasiihu. ");
INSERT INTO fuhbkf_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Nde Apolos wonnoo Korintu ndeen, Pool jokki laawol ley baamle, yehi Efeesu. O tawi toon taalibaaɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","O ƴami ɗum'en, o wi'i: —Nde ngoonɗinnoɗon ndeen yalla on keɓii Ruuhu Ceniiɗo naa? Ɓe njaabii mo: —Min nanaay yalla Ruuhu Ceniiɗo ina woodi du, sakko min keɓa. ");
INSERT INTO fuhbkf_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","O ƴami ɓe, o wi'i: —Ndelle, lootagal batisima ngale keɓuɗon? Ɓe njaabii, ɓe mbi'i: —Lootagal batisima Yaayaa ngaal. ");
INSERT INTO fuhbkf_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pool wi'i: —Yaayaa lootirii yimɓe batisima tuubugol hakke, ina wi'a yimɓe ɓeen ngoonɗina garoowo caggal muuɗum oon, ɗum woni Iisaa. ");
INSERT INTO fuhbkf_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Nde ɓe nannoo ɗum ndeen, ɓe lootaa lootagal batisima dow innde Iisaa Joomiraaɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Nde Pool yownoo juuɗe muuɗum dow maɓɓe fu, Ruuhu Ceniiɗo jippii e maɓɓe, iɓe kaalda ɗemle janane, iɓe kaalda annabaaku. ");
INSERT INTO fuhbkf_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Iɓe ngaɗa hono yimɓe sappo e ɗiɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Pool naati e ley waajordu nduun, ina waajoroo ɓe tannyoral haddi lebbi tati. Imo haalda e maɓɓe, imo liddundura e maɓɓe, imo filoo faaminde ɓe haala laamu Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Ammaa yoorɓe ɓerɗe na ngoni ley maɓɓe, njaɓaay goonɗinde, ina mbonna laawol Joomiraaɗo ngool yeeso yimɓe fuu. Ɗum waɗi de Pool seedi e maɓɓe, yaari taalibaaɓe ɓeen feere, ina waajoo ɗum'en nyannde fuu e ley janngirde neɗɗo bi'eteeɗo Tiranus. ");
INSERT INTO fuhbkf_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","O golliri noon faa hiɓɓi duuɓi ɗiɗi, faa jooɗiiɓe e leydi Aasiya ɓeen fuu nani konngol Joomiraaɗo ngool, gilla e Alhuudiyankooɓe faa e Geresankooɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Laamɗo hokki Pool waɗude kaayeefiiji mawɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Fay tekke e kaddule meemuɗe ɓanndu makko ina njaaree, njowee e dow nyawɓe. Nyawɓe ɓeen ndaɗa e nyawuuji muɓɓen, ginnaaji na mburtoo e muɓɓen. ");
INSERT INTO fuhbkf_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Woɓɓe ley Alhuudiyankooɓe na njiiloo faa ndiiwa ginnaaji. Ɓe pilii riiwrude ɗum'en e innde Iisaa, ɓe mbi'i: —E Innde Iisaa mo Pool waajotoo haala muuɗum oon, njaltee! ");
INSERT INTO fuhbkf_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Gooto e hooreeɓe almaami'en, Alhuudiyanke bi'eteeɗo Sikewa, ɓiɓɓe muuɗum worɓe njeɗɗo ngaɗii noon, ");
INSERT INTO fuhbkf_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","faa ginnaaru jaabii ɗum'en, wi'i: —Miɗo anndi Iisaa, Pool du miɗo anndi haala muuɗum. De onon kaa, wo on ɓeye? ");
INSERT INTO fuhbkf_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Neɗɗo gonduɗo e ginnaaru oon hipporii ɓe semmbe faa jaalii ɓe, torri ɓe faa ɓe ndoggi. Ɓe njalti suudu nduun ɓalli ɓoli barmuɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Kabaaru majjum sankitii hakkunde Alhuudiyankooɓe e Geresankooɓe jooɗiiɓe Efeesu fuu. Kulol nanngi ɓe fuu, innde Iisaa Joomiraaɗo teddinaa. ");
INSERT INTO fuhbkf_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Heewɓe e goonɗinɓe ɓeen ngari, kaalti lutti ɗi ngaɗunoo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Dabarankooɓe heewɓe kawrunduri dewte muɓɓen, mbuli ɗe yeeso yimɓe fuu. Ɓe kiisii coggu majje, ɓe tawi ina waɗa buuɗi cardi ujunaaje capanɗe joy. ");
INSERT INTO fuhbkf_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Hono nii, haala Joomiraaɗo kaan ɓeydorii sankitaade e heewude semmbe. ");
INSERT INTO fuhbkf_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Caggal ɗuum, Pool siini feƴƴitinde Makedoniya e Akaya faa fonndoo Urusaliima. O wi'i: —Si mi tilake toon fu, tilay mi yaha Roma du. ");
INSERT INTO fuhbkf_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","O neli gollidooɓe e makko ɗiɗo, Timote e Erasta, njaha Makedoniya. Kanko kaa, o heddii leydi Aasiya seeɗa. ");
INSERT INTO fuhbkf_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Wakkati oon, fitina mawɗo waɗi saabe laawol Joomiraaɗo ngool. ");
INSERT INTO fuhbkf_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Baylo tafoowo cardi bi'eteeɗo Demetirus ina tafa cuuroy cardi nanndukoy e suudu tooru wi'eteendu Artemis. Imo heɓa e majjum tino heewngo, kanko e gollooɓe makko. ");
INSERT INTO fuhbkf_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","O hawrunduri ɗum'en, kam'en e gollooɓe golle juuɗe hono maɓɓe, o wi'i ɓe: —Yigiraaɓe, oɗon anndi wo e gollal ngal jawdi meeɗen fuu ƴuuri. ");
INSERT INTO fuhbkf_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Oɗon nji'a, oɗon nana no Pool oon heɓiri hakkillo yimɓe heewɓe, ina wosina ɗum'en, wanaa ley Efeesu ɗo tan, ley leyɗe Aasiya fuu. Imo wi'a ɓe kulle deweteeɗe ɗe yimɓe moƴƴiniri juuɗe muɓɓen ɗeen nganaa deweteeɗe. ");
INSERT INTO fuhbkf_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Si jokkirii nii fu, yimɓe mbonnan golle meeɗen. Wanaa ɗum tan, yimɓe ndaardan suudu tooru Artemis nduun du hono ɓolum. Yimɓe celan teddinde tooru meeɗen mawndu ndu wonɓe Aasiya e adunaaru ndu fuu ndewata nduun. ");
INSERT INTO fuhbkf_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Nde ɓe nannoo haalaaji ɗiin ndeen, ɓerɗe maɓɓe kuɓɓi, heddii iɓe peekoo, iɓe mbi'a: —Artemis Efeesunkooɓe wo mawɗo! Artemis Efeesunkooɓe wo mawɗo! ");
INSERT INTO fuhbkf_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Ngalluure ndeen fuu jiiɓii. Jamaa oon fuu doggiri taliyaare fijo ndeen. Ɓe ndaasi Gayus e Aristarka Makedoniyankooɓe, yaadiraaɓe Pool ɓeen. ");
INSERT INTO fuhbkf_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pool ina yiɗi naatude hakkunde jamaa oon, ammaa taalibaaɓe ɓeen kaɗi mo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Woɓɓe ley hooreeɓe leydi Aasiya, yigiraaɓe makko, neli e makko ina nyaagoo mo taa o naata taliyaare toon. ");
INSERT INTO fuhbkf_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Wakkati oon, jamaa oon ina jiiɓii sanne. Ɓee ɗo ina mbullana ɗum, ɓee to ina mbullana ɗum ga. Ko ɓuri heewude e yimɓe ɓeen, anndaa fay ko waddi ɗum'en ɗoon. ");
INSERT INTO fuhbkf_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Yoga e jamaa oon kaaltani haala ka gorko bi'eteeɗo Alesandere mo Alhuudiyankooɓe ɓeen ngaɗi kaaloowo muɓɓen. Alesandere muuyi jakkanaade yimɓe muuɗum ɓeen, de huncani jamaa oon junngo faa haalda e muɓɓen. ");
INSERT INTO fuhbkf_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Ammaa nde ɓe annditinnoo wo o Alhuudiyanke ndeen, ɓe fuu ɓe keddii iɓe ƴeewnoo faa waɗi leeruuji ɗiɗi, iɓe mbi'a: —Artemis Efeesunkooɓe wo mawɗo! ");
INSERT INTO fuhbkf_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Ko sakitii, binndoowo ngalluure ndeen deƴƴini jamaa oon, wi'i: —Onon Efeesunkooɓe, ngalluure Efeesu nde woni hayboore suudu dewal Artemis deweteeɗo mawɗo oon, kam e natal muuɗum ƴuurungal dow kammu ngaal. Yimɓe fuu na anndi ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Fay gooto waawaa yeddude ɗum. Ndelle oɗon njeyi jippinde hakkillooji mooɗon taa ngolliron fay huunde e henyaare. ");
INSERT INTO fuhbkf_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Worɓe ɓe ngadduɗon ɓeen, nganaa wujjooɓe kulle suudu dewal, nganaa yennooɓe deweteeɗo meeɗen oon. ");
INSERT INTO fuhbkf_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Si tawii Demetirus e tafooɓe cardi ɓeen ina ngoodi ko njiɗi wullitaade fu, nyalaaɗe careteeɗe ina ngoodi, sarotooɓe du na ngoodi. ");
INSERT INTO fuhbkf_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","De si na woodi ko pilotoɗon ko ɓuri ɗum fu, wo to kawrital saahiiɓe ɗum saroytee. ");
INSERT INTO fuhbkf_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Eɗen mbaawi felireede muurtere waɗunde hannden ndeen, sabo fitina ga'uɗo nii walaa sabaabu fay gooto. Caggal haalaaji ɗiin, o yoofi jamaa oon sankitii. ");
INSERT INTO fuhbkf_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Nde fitina oon faltinoo ndeen, Pool hawrunduri taalibaaɓe ɓeen, de semmbiniri ɗum'en e haala. Caggal ɗuum, waynii ɗum'en, fonndii Makedoniya. ");
INSERT INTO fuhbkf_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","O yiiltii ley leydi ndiin, imo semmbina yimɓe toon e waajuuji keewɗi. Caggal ɗuum, o yottii Geres. ");
INSERT INTO fuhbkf_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","O waɗi toon lebbi tati. Nde o segilinoo faa o naata laana yaade Siiriya fu, o nani Alhuudiyankooɓe ndawridii faa mbara mo. Ndelle o anniyii yeccoraade laawol Makedoniya. ");
INSERT INTO fuhbkf_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Inan yaadiraaɓe makko: Sopater ɓii Pirrus jeyaaɗo Bereya, e Aristarka e Sekundus jeyaaɓe Tesaloniiki, e Gayus jeyaaɗo Derbe, e Timote. Wooɗi du Tikiku e Torofim jeyaaɓe leydi Aasiya. ");
INSERT INTO fuhbkf_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Ɓeen ardii min, ndoomowi min wuro wi'eteengo Torowas. ");
INSERT INTO fuhbkf_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Minen, min naati laana yaade Filipi caggal iidi buuru mo wattaaka rabilla. E ley balɗe joy min kewti ɓe Torowas, min ngaɗi ɗoon jeɗɗiire. ");
INSERT INTO fuhbkf_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Nyannde arandeere e jeɗɗiire, tawi miɗen kawriti faa min keltoo buuru. Pool ina waajoo yimɓe ɓeen, sabo imo anniyii dillude jaango majjum. O heddii e waaju oon faa hakkunde jemma. ");
INSERT INTO fuhbkf_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Lampe keewɗe ina ngoni e ley suudu dowuuru ndu min kawriti ley muuɗum nduun. ");
INSERT INTO fuhbkf_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Suka jokolle bi'eteeɗo Ewtikus ina jooɗii dow feneetere. Ko Pool juutini waaju muuɗum oon ɗuum, Ewtikus ŋoŋi, faa ɗaanii ɗoyngol teddungol. O saami ƴuuwde e feneetere sooro tataɓo ngoon. Nde ɓe kuncunoo mo ndeen, tawi o maayii. ");
INSERT INTO fuhbkf_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Ammaa Pool jippii, hippii e makko, hooƴi mo e juuɗe muuɗum, wi'i: —Mbaaltee! Yonki makko wartii! ");
INSERT INTO fuhbkf_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Ndeen Pool ƴeenti, heltii buuru, nyaami. Caggal ɗuum, o warti e waaju makko faa weeti, de o dilli. ");
INSERT INTO fuhbkf_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Suka jokolle oon hooraa ina wuuri. Ɗum waaltini ɓerɗe maɓɓe sanne. ");
INSERT INTO fuhbkf_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Minen, min artii yaade, min naati laana yaade Asos ɗo min njeyi nannude Pool, sabo imo anniyii yaarude toon koyɗe. ");
INSERT INTO fuhbkf_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Nde min tawunduri Asos ndeen, min nanni mo laana, min njottii Mitilene. ");
INSERT INTO fuhbkf_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Min ƴuwi ɗoon e laana, min njottowii jaango muuɗum yeeso ruunde Kiyos. Faɓɓi-jaango muuɗum min paltorii ɗakkol ruunde Samos, de faɓɓiti-janngo mum min njottii Miletus. ");
INSERT INTO fuhbkf_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pool anniyii wosaade Efeesu, faa taa ɓooya ley leydi Aasiya ndiin. Imo henyanii yottaade Urusaliima nyannde iidi ɓenndal alkama si tawii na laatoo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Nde Pool wonnoo Miletus ndeen, nelani hooreeɓe kawrital goonɗinɓe Efeesu ɓeen. ");
INSERT INTO fuhbkf_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Nde ɓe ngarnoo ndeen, o wi'i ɓe: —Oɗon anndi no ngorrumi e mooɗon gilla nde koyngal am naatunoo e leydi Aasiya ndi faa warde hannden. ");
INSERT INTO fuhbkf_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Mi golliranii Joomiraaɗo leeƴinkinaare fuu, kam e gonɗi keewɗi e torraaji ɗi Alhuudiyankooɓe umminani kam ɗiin. ");
INSERT INTO fuhbkf_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Oɗon anndi mi suuɗaay on huunde fuu ko nafata on, mi waajake on, mi jannginii on hakkunde yimɓe e ley galleeji mooɗon. ");
INSERT INTO fuhbkf_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Mi tindinii Alhuudiyankooɓe e Geresankooɓe fuu tuubana Laamɗo, ngoonɗina Joomiraaɗo meeɗen Iisaa. ");
INSERT INTO fuhbkf_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Joonin, Ruuhu Ceniiɗo na yaara kam Urusaliima, mi anndaa ko hewtoytoo kam toon. ");
INSERT INTO fuhbkf_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Ko anndumi tan, Ruuhu Ceniiɗo oon na holla kam ley gure ɗeen fuu ina wi'a kam geƴƴelle e torraaji ina ndoomi kam. ");
INSERT INTO fuhbkf_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","De miin kaa, mi hiisaaki nguurndam am e maayde am fuu si mi timminii daɗundurgol, mi heɓii yottinde gollal ngal Iisaa Joomiraaɗo halfini kam ngaal. Gollal ngaal woni seedaade Kabaaru Lobbo haala hinney Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Mi yiilake hakkunde mooɗon, miɗo waajoo haala laamu Laamɗo. De joonin miɗo anndi on nji'oytaa kam katin. ");
INSERT INTO fuhbkf_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Ɗum waɗi de miɗo sappoo on hannden ɗum ɗo: si tawii gooto mooɗon halkii, wanaa feloore am. ");
INSERT INTO fuhbkf_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Sabo mi waajake on anniyaaji Laamɗo fuu, mi suuɗaay on fay huunde. ");
INSERT INTO fuhbkf_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Ndeenee ko'e mooɗon, ndeenon coggal ngal Ruuhu Ceniiɗo halfini on faa kaybon ngaal. Laatoɗon durooɓe kawrital goonɗinɓe Laamɗo, ngal soodiri ƴiiƴam ɓiyum. ");
INSERT INTO fuhbkf_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Miin, miɗo anndi caggal am yimɓe bonɓe cooroto e ley mooɗon hono no pobbi jolbuɗi, katin du ɗi accataa coggal ngaal. ");
INSERT INTO fuhbkf_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Fay e ley mooɗon danyan worɓe ummiiɓe ina mbaajoo waajuuji fewreeji faa pooɗa taalibaaɓe ɓeen njokka ɗum'en. ");
INSERT INTO fuhbkf_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Ɗum le, kakkilon! Miccitoɗon, jemma e nyalooma fuu faa waɗi duuɓi tati, mi selaay tindinirde gooto mooɗon fuu e gonɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Joonin, miɗo halfina on Laamɗo, e konngol hinney muuɗum. Konngol ngool ina waawi semmbinde on e ley goonɗinal mon, hokka on ko resani seniiɓe fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Abada mi muuyaay fay huunde e mooɗon, wanaa cardi, wanaa kaŋŋe, wanaa kaddule. ");
INSERT INTO fuhbkf_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Onon e ko'e mooɗon, oɗon anndi juuɗe am ɗe kumti haajuuji am e haajuuji wonduɓe e am. ");
INSERT INTO fuhbkf_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Mi hollii on e kabaaruuji ɗiin fuu, sanaa ngolliron noon, mballon tampuɓe. E ley ɗuum fuu, miccoɗon ɗii ɗo haalaaji ɗi Joomiraaɗo meeɗen Iisaa haali kam e hoorem: «Kokkuɗo ɓuri kokkaaɗo barke.» ");
INSERT INTO fuhbkf_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Nde Pool tilinoo haalde ɗum ndeen, kam e maɓɓe fuu ɓe kofii, ɓe ndu'ii. ");
INSERT INTO fuhbkf_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Ɓe fuu ɓe mboyi bojji mawɗi, ɓe kippii e Pool, ɓe muccii ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Ko ɓuri mettude ɓe fu, ko o wi'i ɓe nji'ataa mo katin ɗuum. Caggal ɗuum, ɓe ɗowti mo faa o naata laana maayo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Nde min ceedunoo e maɓɓe ndeen, min naati laana maayo, min mbosaaki, min njehi ruunde Kos. Jaango majjum, min njehi ruunde Rodosa. Min ƴuwi ɗoon, min njottii wuro Patara. ");
INSERT INTO fuhbkf_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Min keɓi laana peƴƴitooha yaade leydi Finisi. Min naati, min ndunnyi. ");
INSERT INTO fuhbkf_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Nde min njahunoo faa min kaynii Ruunde Kipirus ɗakkol amin gere nano fu, min ponndii leydi Siiriya. Min njottii toon, min njippii wuro wi'eteengo Tirus. Wo ɗoon laana kaan jippinta gineeji muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Min tawi taalibaaɓe, min ngondi e muɓɓen ɗoon balɗe jeɗɗi. Iɓe mbiira Pool ley Ruuhu Ceniiɗo taa yaha Urusaliima. ");
INSERT INTO fuhbkf_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Nde jeɗɗiire ndeen hiɓɓunoo ndeen, min ndilli. Ɓe fuu ɓe ɗowti min faa min njalti wuro ngoon, kamɓe e rewɓe e sukaaɓe. Min kofii hunnduko maayo manngo, min ndu'ii. ");
INSERT INTO fuhbkf_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Nde min mbaynundurnoo ndeen, minen kaa min naati laana, kamɓe du ɓe njeccii cuuɗi maɓɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Nde min naatunoo laana Tirus min ndilli fu, min njehi Potolemayis. Min njowtowi sakiraaɓe toon, min nyallidi e maɓɓe, min mbaali. ");
INSERT INTO fuhbkf_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Jaango majjum, min ndilli ɗoon, min njehi Kaysariya. Min naatowi suudu Filipu baajotooɗo Kabaaru Lobbo oon, min njippanii ɗum. Wo o gooto hakkunde suɓaaɓe njeɗɗo Urusaliima ɓeen. ");
INSERT INTO fuhbkf_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Imo jogii ɓiɓɓe rewɓe nayo ɓe ɓaŋaaka, haaldooɓe annabaaku. ");
INSERT INTO fuhbkf_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Nde min ngaɗunoo ɗoon balɗe seeɗa fu, annabaajo bi'eteeɗo Agabus ƴuuri Yahuudiya, ");
INSERT INTO fuhbkf_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","wari to amin. O hooƴi kaɓɓorgol Pool, o haɓɓi juuɗe makko e koyɗe makko. O wi'i: —Ruuhu Ceniiɗo wi'i: nii Alhuudiyankooɓe wonɓe Urusaliima ɓeen kaɓɓirta jeyɗo kaɓɓorgol ngol oon, ngatta ɗum e juuɗe yimɓe ɓe nganaa Alhuudiya'en. ");
INSERT INTO fuhbkf_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Nde min nannoo ɗum ndeen, minen e jeyaaɓe ɗoon ɓeen fuu, min nyaagii Pool taa yaha Urusaliima. ");
INSERT INTO fuhbkf_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Pool kaa jaabii, wi'i: —Ɗume waɗi de oɗon mboya, oɗon keccinɗina ɓernde am? Miin, miɗo segilanii ko wanaa haɓɓeede tan, miɗo segilanii fay maayde ley Urusaliima saabe innde Iisaa Joomiraaɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Nde min paamunoo min mbaawaay waylitinde anniya makko ndeen, min celi mo, min mbi'i: —Joomiraaɗo waɗa muuyɗe muuɗum! ");
INSERT INTO fuhbkf_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Nde waɗunoo balɗe seeɗa fu, min cegilii, de min ponndii Urusaliima. ");
INSERT INTO fuhbkf_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Taalibaaɓe Kaysariya woɓɓe njaadi e amin, njaari min galle gorko bi'eteeɗo Manason faa min njippanoo ɗum. Manason wo jeyaaɗo Kipirus, laatiiɗo taalibaajo gilla ko ɓooyi. ");
INSERT INTO fuhbkf_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Nde min njottinoo Urusaliima ndeen, sakiraaɓe ɓeen njaɓɓorii min seyo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Jaango majjum, min njaadi e Pool to Yaakuuba. Mawɓe kawrital goonɗinɓe ɓeen fuu ina tawaa toon. ");
INSERT INTO fuhbkf_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Caggal ko o jowti ɓe ɗuum, o fillitanii ɓe huunde fuu ko Laamɗo waɗani yimɓe ɓe nganaa Alhuudiyankooɓe saabe golle makko. ");
INSERT INTO fuhbkf_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Nde ɓe nannoo ɗum ndeen, ɓe njetti Laamɗo. Ɓe mbi'i Pool: —Sakiike amin, a yi'ii Alhuudiyankooɓe ujunaaje ngoonɗinii. Faa hannden iɓe tinnii e jokkude Tawreeta Muusaa. ");
INSERT INTO fuhbkf_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ɓe kaalanaama aɗa janngina Alhuudiyankooɓe wonɓe hakkunde lenyi goɗɗi njoppa Tawreeta Muusaa, mbiiɗaa taa taada sukaaɓe muɓɓen katin, taa njokka al'aadaaji ɗiin katin. ");
INSERT INTO fuhbkf_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Ndelle, noy ngaɗeten? Sabo tannyoral ɓe nanan a warii. ");
INSERT INTO fuhbkf_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Waɗu ko min kaalante ɗuum. Miɗen njogii ɗo worɓe nayo waɗanɓe Laamɗo hunayeere. ");
INSERT INTO fuhbkf_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Yaadu e maɓɓe, de laamnidaa hoore maa e maɓɓe, njoɓaa ko ɓe kaani yoɓude ɗuum, faa ɓe laɓee. Ndeen yimɓe fuu anndan ko haaletee dow maaɗa ɗuum fuu wanaa goonga. Ɓe anndan aan e hoore maa aɗa jokki Tawreeta Muusaa. ");
INSERT INTO fuhbkf_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Goonɗinɓe ƴuuruɓe e lenyi goɗɗi ɓeen, min mbinndanii ɗum'en ndeentoo e ko hirsanaa tooruuji e ƴiiƴam e ko saaɗi, kam e jeenu. ");
INSERT INTO fuhbkf_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Pool hooƴi worɓe ɓeen, yaadi e muɓɓen. Jaango majjum, o laamnidaa e muɓɓen laaɓal diina. O naati suudu dewal mawndu nduun, o haalani almaami'en ɓeen. O wi'i si nyalaaɗe laamnugol ɗeen kiɓɓii fu, mono e maɓɓe fuu waɗanee sadaka. ");
INSERT INTO fuhbkf_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Nde balɗe jeɗɗi ɗeen ɓadinoo hiɓɓude ndeen, Alhuudiyankooɓe woɓɓe ƴuuruɓe leydi Aasiya nji'i Pool e ley suudu dewal mawndu nduun. Ɓe ummini hakkillooji yimɓe ɓeen fuu, ɓe nanngi mo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Iɓe peekoo, iɓe mbi'a: —Israa'iilankooɓe, mballee min! O woni gorko jannginoowo yimɓe e ley nokkuuje ɗeen fuu ina liddoo yimɓe lenyol meeɗen, ina liddoo Tawreeta meeɗen, ina liddoo nokku ceniiɗo o. Joonin kaa, o waddii fay Geresankooɓe e ley suudu dewal mawndu ndu. O tuuninii nokku ceniiɗo o! ");
INSERT INTO fuhbkf_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Walaa ko ɓe mbiiri noon si wanaa ko ɓe njiinoo Torofim Efeesunke oon ina wondi e Pool ley ngalluure ndeen. Iɓe cikka Pool nanniino mo e ley suudu dewal mawndu nduun. ");
INSERT INTO fuhbkf_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Jirkitaango ngoon huuɓi ngalluure ndeen. Yimɓe ina njaltira tatteeji ɗiin fuu. Ɓe nanngi Pool, ɓe ndaasi ɗum faa ɓe mburtini ɗum suudu dewal mawndu nduun, de ɓe ommbi dammbuɗe ɗeen wakkati oon law. ");
INSERT INTO fuhbkf_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Nde ɓe pilotonoo faa ɓe mbara Pool ndeen, tawi hooreejo sordaasiiɓe oon humpitake Urusaliima fuu jiiɓake. ");
INSERT INTO fuhbkf_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Wakkati oon, o hooƴi sordaasiiɓe e mawɓe muɓɓen, o doggani jamaa oon. Nde yimɓe ɓeen njiinoo mo kanko e sordaasiiɓe ɓeen ndeen, celi fiyude Pool. ");
INSERT INTO fuhbkf_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Hooreejo oon ɓattii Pool, yamiri Pool nanngee, haɓɓiree callali ɗiɗi. O ƴami, —Gorko o wo moy? Ɗume o waɗi? ");
INSERT INTO fuhbkf_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Jamaa oon ina feekoo. Ɓee ina ƴeewnoo ɗum, ɓee to ina ƴeewnoo ɗum to. Duko jiiɓiiko koon haɗi mo faamude. Ndelle o yamiri Pool yaaree ley suudu sooro sordaasiiɓe toon. ");
INSERT INTO fuhbkf_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Nde Pool warnoo faa ƴeeŋa kalikali sooro oon, sordaasiiɓe ɓeen ndonndii mo saabe nyanngere jamaa ndeen, ");
INSERT INTO fuhbkf_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","sabo yimɓe heewɓe ina njokki mo ina peekoo, ina mbi'a: —Ittu yonki makko! ");
INSERT INTO fuhbkf_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Nde sordaasiiɓe ɓeen ngarnoo faa nanna Pool ley sooro muɓɓen ndeen, Pool wi'i hooreejo oon: —Ina daganoo kam mi haalda e maa naa? Oon wi'i mo: —Aa? Aɗa waawi geresankoore naa? ");
INSERT INTO fuhbkf_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Ndelle a wanaa Misiranke gaɗuɗo muurtere ko ɓooyaay oon naa? A wanaa garduɗo e waɗooɓe bar-ko'e ujunaaje nayo, de njaaruɗaa ɗum'en ley ladde naa? ");
INSERT INTO fuhbkf_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pool jaabii, wi'i: —Miin, mi Alhuudiyanke dimaaɗo Tarsus ley leydi Silisi. Ngalluure ndeen wanaa nde anndaaka koy. Miɗo nyaage nduŋanoɗaa kam mi haalda e yimɓe ɓeen. ");
INSERT INTO fuhbkf_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Hooreejo oon duŋanii mo ɗum. Pool darii e dow ƴeentirde ndeen, ɓantani yimɓe ɓeen junngo. Nde ɓe ndeƴƴininoo ndeen, o haali e ibraninkoore, o wi'i: ");
INSERT INTO fuhbkf_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","—Sakiraaɓe e baabiraaɓe, kettinee joonin faa mi seedanoo on mi jeyaa feloore nde njowuɗon dow am. ");
INSERT INTO fuhbkf_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Nde ɓe nannoo wo ibraninkoore o haaldata e maɓɓe fu, deƴƴinaare ndeen ɓeydii katin. O wi'i: ");
INSERT INTO fuhbkf_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","—Wo mi Alhuudiyanke dimaaɗo Tarsus ley leydi Silisi. Ammaa Urusaliima ɗo mawnumi. Gamaliyel wonnoo moodibbo am. Kanko janngini kam Tawreeta maamiraaɓe meeɗen oon faa laaɓi tal. Miɗo jinngana Laamɗo hono no ngorruɗon hannden on fuu ni. ");
INSERT INTO fuhbkf_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Mi torrii jokkuɓe Laawol ngool faa maayi. Mi nanngii worɓe e rewɓe, mi uddii ɗum'en ley kasu. ");
INSERT INTO fuhbkf_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Almaami Mawɗo e waalde Saahiiɓe ɓeen fuu ina ceedanoo kam, kam'en du. Wo e muɓɓen keɓumi ɗerewol faa mi holla sakiraaɓe muɓɓen wonɓe Damas ɓeen. De njahumi faa mi haɓɓowa jokkuɓe laawol Iisaa wonɓe toon ɓeen, faa mi wadda ɗum'en Urusaliima faa njukkee. ");
INSERT INTO fuhbkf_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Wooɗi, miɗo yaha faa ɓadiimi Damas, wakkati hakkunde naange. Wakkati gooto annoora mawɗo ƴuuri dow kammu, yayni, fiilii kam. ");
INSERT INTO fuhbkf_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Caamumi e leydi, nanumi daande ina wi'a kam: «Sool, Sool, ko waɗi de aɗa torra kam?» ");
INSERT INTO fuhbkf_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Njaabiimi, mbiimi: «Aan wo a moy, joomam?» Nde mbi'unoomi noon fu, o wi'i kam: «Miin, wo mi Iisaa Nasaraatuujo mo torrataa oon.» ");
INSERT INTO fuhbkf_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Wonduɓe e am ɓeen nji'i annoora oon, ammaa ɓe nanaay daande haaldunde e am ndeen. ");
INSERT INTO fuhbkf_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Ndeen, mbiimi: «Joomiraaɗo, ɗume ngaɗammi?» Joomiraaɗo wi'i kam: «Umma, yahu Damas. A haalante toon ko Laamɗo anniyii ngaɗaa fuu.» ");
INSERT INTO fuhbkf_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Wonduɓe e am ɓeen ɗowi kam, njaari kam faa ley Damas, sabo ɗelkugol annoora ngool wumnii kam. ");
INSERT INTO fuhbkf_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Ananiyas wo gorko kulɗo Laamɗo, jokkuɗo Tawreeta Muusaa. Alhuudiyankooɓe wonɓe toon fuu ceedanii mo wo o moƴƴo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","O wari, o darii yeeso am, o wi'i kam: «Sool, sakiike am, wumtu!» De wakkati oon ni, mbumtumi, njiimi mo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","O wi'i: «Laamɗo maamiraaɓe meeɗen oon suɓake ma faa paama muuyɗe muuɗum, faa nji'aa Ponnditiiɗo oon, nanaa haala e hunnduko muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Sabo aan seedantoo mo yeeso yimɓe fuu ko njiiɗaa e ko nanuɗaa. ");
INSERT INTO fuhbkf_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Joonin, ɗume ndoomataa katin? Umma, looteɗaa lootagal batisima, de njaaforeɗaa lutti maa e noddude innde Joomiraaɗo.» ");
INSERT INTO fuhbkf_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Caggal mi yeccake Urusaliima, miɗo waɗa du'aare ley suudu dewal mawndu, de won ko njiimi e holleede. ");
INSERT INTO fuhbkf_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Ley holleede oon mi yi'ii Joomiraaɗo, wi'i kam: «Henya law, yaltu Urusaliima, sabo ɓe njaɓataa seedaaku ngu ceedantoɗaa kam nguun.» ");
INSERT INTO fuhbkf_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Njaabiimi, mbiimi: «Joomiraaɗo, iɓe anndi miɗo yahannoo ley cuuɗi baajorɗi ɗiin fuu, miɗo uddannoo miɗo fiyannoo goonɗinɓe ma ɓeen. ");
INSERT INTO fuhbkf_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Nde ƴiiƴam Etiyen seedee maaɗa oon yuppetenoo ndeen, miɗo darii, iɗum weli kam ko o waraa ɗuum. Miin haybannoo kaddule warɓe mo ɓeen.» ");
INSERT INTO fuhbkf_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Joomiraaɗo jaabii kam, wi'i: «Yahu, mi nulete to woɗɗi, to yimɓe ɓe nganaa Alhuudiyankooɓe.» ");
INSERT INTO fuhbkf_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Iɓe kettinanii mo faa o haali haala ka. Ndeen ɓe ƴepti daaɗe maɓɓe, ɓe mbi'i: —Ittu mo e adunaaru ndu! O haanaa wuurude katin! ");
INSERT INTO fuhbkf_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Iɓe peekoo, iɓe njiila saayaaji maɓɓe, iɓe mbicca leydi. ");
INSERT INTO fuhbkf_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Hooreejo oon yamiri Pool yaaree ley suudu sooro muɓɓen ɗoon, lamndoree piiɗe faa ɓe paama ko waɗi de jamaa oon ina wulla e makko hono ni. ");
INSERT INTO fuhbkf_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Nde ɓe kaɓɓannoo mo faa ɓe piya mo ndeen, o wi'i mawɗo sordaasiiɓe gonɗo ɗoon: —Yalla na daganoo on piyon Romanke, sakko mo saraaka naa? ");
INSERT INTO fuhbkf_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Nde mawɗo oon nannoo ɗum ndeen, yehi to hooreejo muɓɓen oon, wi'i: —Aɗa anndi ko nesuɗaa waɗude naa? Gorko oon wo Romanke! ");
INSERT INTO fuhbkf_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Ndeen hooreejo oon wari to Pool, ƴami ɗum, wi'i: —Haalanam, yalla a Romanke naa? Pool jaabii, wi'i: —Wo mi kam! ");
INSERT INTO fuhbkf_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Ndeen hooreejo oon jaabii, wi'i: —Miin kaa, ceede keewɗe njoɓumi de keɓumi laataade Romanke. Pool wi'i mo: —Miin, mi finii tawumi mi kam. ");
INSERT INTO fuhbkf_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Wakkati oon anniyiiɓe fiyude mo faa tilsinana mo haaltude ɓeen acciti. Hooreejo oon huli, sabo anndii Pool wo Romanke wooɗi haɓɓiino ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Jaango majjum, hooreejo oon haɓɓiti Pool, sabo na yiɗi tannyorde ko Alhuudiyankooɓe ɓeen mbullitii ɗum. O yamiri hooreeɓe almaami'en e waalde Saahiiɓe ndeen fuu kawrita. Caggal ɗuum, o waddi Pool, o darni ɗum yeeso maɓɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pool ndaari waalde Saahiiɓe ɓeen, wi'i: —Sakiraaɓe, wo ɓernde nde walaa feloore mbuurdumi yeeso Joomiraaɗo faa yottaade nyalooma hannden o. ");
INSERT INTO fuhbkf_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Ndeen Ananiyas, Almaami Mawɗo oon, yamiri darinooɓe ɗakkol makko ɓeen piya mo hunnduko. ");
INSERT INTO fuhbkf_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Ndeen, Pool wi'i mo: —Laamɗo fiyete, aan kokuwol dawninaangol nanndungol wo lobbol! Aɗa jooɗii faa caroroɗaa kam e Tawreeta Muusaa, de a luttii Tawreeta Muusaa ko njamirɗaa mi fiyee ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Darinooɓe ɗoon ɓeen mbi'i Pool: —Yalla a mbonkoto Almaami Mawɗo mo Laamɗo joƴƴini o naa? ");
INSERT INTO fuhbkf_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pool jaabii, wi'i: —Sakiraaɓe, mi faamaayno yalla wo o Almaami Mawɗo. Si goonga, miɗo anndi ina winndaa: «Taa mbonka hooreejo lenyol maa!» ");
INSERT INTO fuhbkf_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Pool ina anndi woɓɓe ley Saahiiɓe ɓeen wo Saduki'en, woɓɓe muɓɓen du wo Farisa'en. Ndelle ƴeewnii semmbe hakkunde kawrital ɗoon, wi'i: —Sakiraaɓe, miin mi Farisanke, ɓii Farisanke. Wo saabe yowugol jikke e ummital maayɓe carorteemi! ");
INSERT INTO fuhbkf_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Nde o haalnoo ɗum ndeen, Farisa'en e Saduki'en ɓeen njeddunduri, kawrital ngaal feccii. ");
INSERT INTO fuhbkf_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Sabo Saduki'en ina mbi'a ummital walaa, maleyka'en ngalaa, ruuhuuji du ngalaa. Ammaa Farisa'en ina ngoonɗini ɗum fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Duko koon ɓeydii mawnude. Jannginooɓe Tawreeta woɓɓe heedanɓe Farisa'en ɓeen, na ngaɗa kalala mawɗo, ina mbi'a: —Walaa fuu ko boni ko min nji'i e gorko o! Ina waawi taweede ruuhu naa maleyka haaldi e makko! ");
INSERT INTO fuhbkf_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Jeddi ɗiin mawni faa hooreejo sordaasiiɓe oon huli taa ɓe ceeka Pool. Ɗum waɗi de o yamiri sordaasiiɓe njippoo to kawrital toon, itta Pool e juuɗe yimɓe ɓeen, njeccina ɗum to suudu sooro muɓɓen toon. ");
INSERT INTO fuhbkf_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Jemma jokkuɗo oon, Joomiraaɗo ɓangi e Pool, wi'i ɗum: —Sellin ɓernde maa! No ceedoraniɗaa kam Urusaliima noon, na tilsi ceedanoɗaa kam ley Roma du. ");
INSERT INTO fuhbkf_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Nde weetunoo ndeen, Alhuudiyankooɓe ɓeen mbati, kunii nyaamataa njarataa sanaa nde mbari Pool. ");
INSERT INTO fuhbkf_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Batidinɓe ɓeen ina ɓuri worɓe capanɗe nayo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Ɓe njehi to hooreeɓe almaami'en e mawɓe, ɓe mbi'i: —Min kunake hunayeere fay huunde min nyaamataa min njarataa gilla joonin, sanaa nde min mbari Pool. ");
INSERT INTO fuhbkf_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Joonin, onon e waalde Saahiiɓe ɓeen, mbi'ee hooreejo sordaasiiɓe oon waddana on Pool. Mbi'on oɗon njiɗi faamitaade ko o haalata ɗuum. Minen, miɗen cegilii faa min mbara mo gilla o yottaaki. ");
INSERT INTO fuhbkf_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Ɓii sakiike Pool debbo nani ko ɓe anniyii ɗuum, yehi to suudu sordaasiiɓe toon, naati, humpiti Pool. ");
INSERT INTO fuhbkf_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Pool noddi gooto e mawɓe sordaasiiɓe ɓeen, wi'i ɗum: —Yaaru suka gorko o to hooreejo toon, sabo won ko o yiɗi haalande ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Mawɗo sordaasiiɓe oon yaari mo to hooreejo muuɗum toon, wi'i ɗum: —Pool ommbaaɗo oon noddi kam, nyaagii kam mi wadda suka gorko o to maa, sabo won ko o yiɗi haalande ma. ");
INSERT INTO fuhbkf_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Hooreejo oon nanngi junngo makko, toowtidi e makko, de ƴami mo: —Ɗume kaalantaa kam? ");
INSERT INTO fuhbkf_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Suka oon wi'i mo: —Alhuudiyankooɓe ndawridii. Ɓe nanndinkinto e yiɗuɓe faamitaade kabaaru Pool. Ɓe nyaagete jaango ngaddanaa ɓe Pool yeeso waalde Saahiiɓe ndeen. ");
INSERT INTO fuhbkf_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Taa njaɓanaa ɓe! Sabo ko ɓuri worɓe capanɗe nayo na ɗuppinanii mo, kunake nyaamataa njarataa si mbaraay mo. Ɓe cegilake, iɓe ndoomi yamiroore maa. ");
INSERT INTO fuhbkf_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Hooreejo oon wi'i suka gorko oon: —Taa haalan fay gooto yalla a faaminii kam ɗum. O yoppi ɗum dilli. ");
INSERT INTO fuhbkf_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Caggal ɗuum, o noddi mawɓe sordaasiiɓe makko ɗiɗo, o wi'i ɗum'en: —Kawrunduree worɓe keme ɗiɗo e waɗɗiiɓe pucci capanɗe njeɗɗo, kam e jom'en labbe keme ɗiɗo. On fuu, cegilanee yaade Kaysariya wakkati yamnde jeenay jemma. ");
INSERT INTO fuhbkf_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Cegilee pucci faa njaaron Pool e jam, to Filiki goforneer oon. ");
INSERT INTO fuhbkf_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Hooreejo oon winndi ɓataaki ki, wi'i: ");
INSERT INTO fuhbkf_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Miin, Kalawdiyus Lisiya, miɗo jowte, aan Filiki goforneer tedduɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Gorko mo neldumaami o, wo Alhuudiyankooɓe nanngunoo ɗum, anniyii warude ɗum. Nde kumpitinoomi o Romanke ndeen, naatumi, miin e fedde sordaasiiɓe ndeen, ittumi mo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Ngaddumi mo yeeso waalde Saahiiɓe maɓɓe, sabo miɗo yiɗi faamude ko ɓe peldi mo ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Tawumi wo dow sariya maɓɓe tan ɓe peldi mo, de ɗum wanaa huunde waawunde warude mo naa uddude mo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Caggal ɗuum, maatumi Alhuudiyankooɓe ndawridii faa mbara mo. Ɗum waɗi de neldumaami mo wakkati oon. Mi yamirii felooɓe mo ɓeen du njaha to maa, pela mo toon. ");
INSERT INTO fuhbkf_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Sordaasiiɓe ɓeen ngaɗi ko njamiraa ɗuum, kooƴi Pool ley jemma, njaari ɗum faa Antipatiri. ");
INSERT INTO fuhbkf_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Jaango majjum, sordaasiiɓe yaarannooɓe e koyɗe ɓeen njeccii to suudu muɓɓen Urusaliima. Ɓe njoppidi Pool e waɗɗiiɓe pucci ɓeen, njottinowa ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Nde ɓeen njottinoo Kaysariya ndeen, kokki goforneer oon ɓataaki kiin, njoppi Pool e junngo makko. ");
INSERT INTO fuhbkf_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Nde goforneer oon janngunoo ɓataaki kiin fu, ƴami toy Pool jeyaa. Nde nannoo wo Silisi o jeyaa ndeen, ");
INSERT INTO fuhbkf_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","wi'i mo: —Mi nanan haala maa si felooɓe ma ɓeen ngarii. O yamiri Pool doomowee to suudu Hirudus laamordu toon. ");
INSERT INTO fuhbkf_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Balɗe joy caggal ɗuum, Ananiyas Almaami Mawɗo oon yottii Kaysariya. Imo wondi e mawɓe woɓɓe, kam e jannguɗo sariya Roma'en bi'eteeɗo Tertulu. Ɓe peli Pool yeeso goforneer oon. ");
INSERT INTO fuhbkf_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Nde Pool noddanoo ndeen, Tertulu fuɗɗi felude mo yeeso kaananke oon, wi'i: —Filiki kaananke tedduɗo, wo saabe maaɗa de min keɓi jam ɓooyɗo. Wooɗi ko moƴƴinaa ley lenyol ngol du wo haybugol maaɗa waɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Min annditii fuu ko ngaɗuɗaa, yimɓe tatteeji fuu na njettire ɓerɗe belɗe. ");
INSERT INTO fuhbkf_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Mi yiɗaa joonnde ndeen juuta, de miɗo nyaage saabe moƴƴuki maa, kettindanoɗaa min seeɗa. ");
INSERT INTO fuhbkf_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Min tawii gorko o wo daaɓoowo bone sanne. Wo o gaddoowo fitina hakkunde Alhuudiyankooɓe wonɓe ley adunaaru fuu. O ardiiɗo laawol Nasaraatunkooɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","O filake tuuninde suudu dewal mawndu nduun, de min nanngi mo.  ");
INSERT INTO fuhbkf_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Miɗen njiɗi saraade mo sariya amin, tawi Lisiya hooreejo sordaasiiɓe oon ittirii mo semmbe e juuɗe amin, yamiri felooɓe mo ɓeen ngara yeeso maa. ");
INSERT INTO fuhbkf_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Aan e hoore maa, lamndoɗaa mo, paamaa ko min peldi mo ɗuum fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Alhuudiyankooɓe tawaaɓe toon ɓeen keedani kaaloowo oon, mbi'i noon jaati worri. ");
INSERT INTO fuhbkf_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Ndeen Filiki, goforneer oon, hokki Pool laawol faa haala. Pool wi'i: —Miɗo anndi waɗii duuɓi aɗa saroo lenyol ngol. Ɗum waɗi de miɗo seyoroo jakkanaade hoore am. ");
INSERT INTO fuhbkf_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Ɓuraa balɗe sappo e ɗiɗi ko ngarumi Urusaliima faa mi sujidana Laamɗo. Si a taykake fu, a tawan hono noon worri. ");
INSERT INTO fuhbkf_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Fay gooto tawaay kam miɗo dukida e neɗɗo naa miɗo jirkita jamaa, wanaa e ley suudu dewal mawndu nduun, wanaa e ley cuuɗi baajorɗi, wanaa e ley ngalluure ndeen. ");
INSERT INTO fuhbkf_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Ɓe mbaawaa tabintinde ko ɓe peldi kam joonin ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Ammaa miɗo jaɓi yeeso maa: miɗo rewri Laamɗo maamiraaɓe meeɗen oon e laawol ngol ɓe mbi'ata feerewol ngool. Miɗo goonɗini ko winndaa e Tawreeta Muusaa ɗuum e ko winndaa e dewte annabaaɓe ɗuum fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Wooɗi, miɗo tannyori Laamɗo iirtinan fonnditiiɓe e bonɓe fuu, hono no Alhuudiyankooɓe du tannyori ni. ");
INSERT INTO fuhbkf_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Saabe ɗuum miɗo tinnoo wondude e ɓernde nde walaa feloore yeeso Laamɗo e yeeso yimɓe wakkati fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Caggal duuɓi keewɗi, mi wartii faa mi waɗana yimɓe am dokke, mi itta sadakaaji. ");
INSERT INTO fuhbkf_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Wakkati oon ɓe tawi kam e ley suudu dewal mawndu nduun caggal ko ngaɗumi al'aada senagol. Mi waldaa e jamaa, mi waldaa e duko. ");
INSERT INTO fuhbkf_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Alhuudiyankooɓe woɓɓe ƴuuruɓe leydi Aasiya wonnooɓe ɗoon, wo ɓeen kaannoo warude pela kam yeeso maa, si tawii won ko ngaɗumi. ");
INSERT INTO fuhbkf_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Yimɓe ɓee ɗo, sanaa kam'en e ko'e muɓɓen kaala boofi ɗi nji'i e am nde ndarinoomi yeeso waalde Alhuudiyankooɓe Saahiiɓe ndeen. ");
INSERT INTO fuhbkf_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Ɓe mbaawaa wiide mi waɗii faa'e si wanaa konngol gootol ngol ndariimi de ƴeewniimi: «Wo saabe ummital maayɓe waɗi de miɗo saree hannden!» ");
INSERT INTO fuhbkf_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Filiki oon, na anndi laawol Iisaa ngool, hanti haala, wi'i: —Si Lisiya hooreejo sordaasiiɓe oon warii fu, ndeen carotoomi haala mooɗon ka. ");
INSERT INTO fuhbkf_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","O yamiri mawɗo sordaasiiɓe oon hayba Pool, de newnana ɗum, taa haɗa fay gooto e yigiraaɓe muuɗum ɓeen warude walla ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Balɗe seeɗa caggal ɗuum, Filiki wardi e deekum Alhuudiyanke bi'eteeɗo Durusiila. O neli Pool waddowaa, o hettindanii ɗum ina haala haala goonɗinal Iisaa Almasiihu. ");
INSERT INTO fuhbkf_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Kaa nde Pool haalannoo haala fonnditaare e nanngitaare e sariya garoowo ndeen, Filiki huli, wi'i: —Joonin kaa heƴii! Yahu. Nde keɓindiimi fuu, mi nodditete. ");
INSERT INTO fuhbkf_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","O miilii Pool hokkan mo ceede. Ɗum waɗi de imo nodda ɗum kile keewɗe faa ɓe njewtida. ");
INSERT INTO fuhbkf_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Nde waɗunoo duuɓi ɗiɗi fu, Porsiyus Festus loomti Filiki, laatii kaananke. Ammaa Filiki yoppi Pool e ley kasu ɗoon, sabo na yiɗi welnande Alhuudiyankooɓe ɓeen. ");
INSERT INTO fuhbkf_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Balɗe tati caggal ko Festus wari e ley leydi ndiin ɗuum, ƴuwi Kaysariya, yehi Urusaliima. ");
INSERT INTO fuhbkf_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Ɗoon, hooreeɓe almaami'en e ardiiɓe Alhuudiyankooɓe ngari to makko de peli Pool. Ɓe nyaagii mo semmbe ");
INSERT INTO fuhbkf_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","o walla ɓe, o wadda Pool Urusaliima. Ko ɓe mbiiri mo noon dey, iɓe piloo ɗuppinanaade ɗum dow laawol faa ɓe mbara ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Festus jaabii ɓe, wi'i: —Pool ina uddii ley kasu Kaysariya toon. Miin e hoore am du, mi yeccoto wuro ngoon law. ");
INSERT INTO fuhbkf_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Mawɓe mooɗon ngara njaada e am Kaysariya, pela gorko oon si tawii won ko waɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Festus waddaay e maɓɓe ko ɓuri balɗe jeetati naa sappo, de yeccii Kaysariya. Jaango majjum, o jooɗowii to sarorde toon, o yamiri Pool waddee. ");
INSERT INTO fuhbkf_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Nde Pool yottinoo ndeen, Alhuudiyankooɓe ƴuuruɓe Urusaliima ɓeen piilii ɗum, peldi ɗum kulle bonɗe keewɗe. Ammaa ɓe mbaawaay laaɓinde pelooje ɗeen. ");
INSERT INTO fuhbkf_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Ndeen Pool jakkanii hoore muuɗum, ina wi'a: —Mi waɗaay ko boni, wanaa e sariya Alhuudiyankooɓe oon, wanaa e suudu dewal mawndu nduun, wanaa e kaananke Roma mawɗo oon du. ");
INSERT INTO fuhbkf_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Festus ina yiɗi welnande Alhuudiyankooɓe ɓeen. Ndelle ƴami Pool, wi'i: —Aɗa jaɓa yaade Urusaliima faa mi sarowoo toon kabaaru maa oon naa? ");
INSERT INTO fuhbkf_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Nde o ƴamunoo ɗuum fu, Pool jaabii, wi'i: —Wo e sarorde kaananke Roma mawɗo ngonumi, wo ɗo kaanumi sareede. Mi waɗaay Alhuudiyankooɓe ɓeen fuu ko boni. Aan e hoore maa du, aɗa anndi. ");
INSERT INTO fuhbkf_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Si mi waɗii ko boni, ko foti warude kam fu, mi salataako wareede. Ammaa si fay huunde e ko ɓe peldi kam ɗuum wanaa goonga fu, fay gooto waawaa wattude kam e juuɗe maɓɓe. Sariya am faltake ɗo. Wo kaananke Roma mawɗo oon, kam sarotoo kam. ");
INSERT INTO fuhbkf_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Caggal nde Festus haaldunoo e tindinooɓe ɗum ndeen, jaabii Pool, wi'i: —Aɗa yiɗi kaananke Roma mawɗo sare, ndelle a yahan to kaananke Roma mawɗo oon! ");
INSERT INTO fuhbkf_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Balɗe seeɗa caggal ɗuum, Agirippa kaananke oon e Bereniika, sakiike mum debbo, ngari Kaysariya faa njowta Festus. ");
INSERT INTO fuhbkf_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Nde ɓe ɓooytunoo ɗoon balɗe seeɗa fu, Festus haalani kaananke oon haala Pool, wi'i: —Ina woodi gorko mo Filiki yoppi ɗo ley kasu. ");
INSERT INTO fuhbkf_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Nde njahunoomi Urusaliima ndeen, hooreeɓe almaami'en e mawɓe Alhuudiyankooɓe kaalanii kam haala makko, nyaagii kam mi saroo mo o jukkee. ");
INSERT INTO fuhbkf_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Njaabiimi ɓe: Al'aada Romankooɓe jaɓataa saraade neɗɗo si hawritaay e felooɓe ɗum ɓeen. Sanaa tawee ina fotti faa jaaboo ko feldaa ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Ndelle ɓe fuu ɓe ngarii ɗo. Miin le, mi neeɓinaay ɗum fes, sabo jaango majjum njooɗowiimi to sarorde toon, njamirmi gorko oon waddee. ");
INSERT INTO fuhbkf_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Felooɓe mo ɓeen ndarii, kaali, de ɓe ngaddaay fay feloore wootere ko nanndani kam wo bonanda. ");
INSERT INTO fuhbkf_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Ɓe peldii mo haala diina maɓɓe, kam e gooto bi'eteeɗo Iisaa maayɗo, mo Pool wi'ata ina wuuri. ");
INSERT INTO fuhbkf_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Wooɗi miin kaa, mi yi'aay fuu no njiitirammi goonga e haala kaan. Ɗum waɗi de lamndiimi mo yalla imo jaɓa saroweede Urusaliima. ");
INSERT INTO fuhbkf_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Ammaa o nyaagake kabaaru makko wattee e juuɗe kaananke mawɗo oon. Ndelle njamirmi o haybee faa mi heɓa neldude mo kaananke Roma mawɗo oon. ");
INSERT INTO fuhbkf_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agirippa wi'i Festus: —Miɗo yiɗi hettindanaade gorko o, miin e hoore am. Festus wi'i: —A hettindanto mo jaango. ");
INSERT INTO fuhbkf_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Jaango majjum, Agirippa e Bereniika ngardi e ƴukkinaare mawnde, naati e ley sarordu nduun, kam'en e hooreeɓe sordaasiiɓe e mawɓe ngalluure ndeen. Festus yamiri Pool waddee. ");
INSERT INTO fuhbkf_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Nde waddanoo fu, Festus wi'i: —Agirippa kaananke e kawrital tawaaɓe ɗo! On nji'ii gorko o. Alhuudiyankooɓe fuu pelii mo to am ley Urusaliima e ɗo fuu. Iɓe ƴeewnoo, iɓe mbi'a o haanaa yoppeede o wuura. ");
INSERT INTO fuhbkf_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","De miin e hoore am kaa, mi tawii o waɗaay fay huunde ko haani warude mo. Ammaa kanko e hoore makko, o nyaagake sariya makko yaaree faa to kaananke Roma mawɗo oon. Ndelle mi anniyake neldude mo toon. ");
INSERT INTO fuhbkf_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Ammaa mi walaa ko mi winndana kaananke oon dow kabaaru makko. Ɗum waɗi de ngaddumi mo yeeso mooɗon, e ko ɓuri ɗum fuu, yeeso maaɗa aan kaananke Agirippa. Hono nii, si en kettindake haala makko fu, mi heɓan ko mi winnda. ");
INSERT INTO fuhbkf_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Sabo hakkillo am jaɓaay neldude kasunke to kaananke tawee hollitaay ko nanngiraa. ");
INSERT INTO fuhbkf_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Agirippa wi'i Pool: —A hokkaama laawol. Haalu haala maa. Ndeen, Pool ɓanti junngom, jaabii, wi'i: ");
INSERT INTO fuhbkf_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","—Agirippa kaananke, mi seyorake laamnude hoore am yeeso maa hannden ko Alhuudiyankooɓe peldi kam ɗuum fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Aɗa anndi al'aadaaji Alhuudiyankooɓe e haalaaji muɓɓen fuu. Saabe majjum miɗo nyaage, kettindanoɗaa kam e munyal. ");
INSERT INTO fuhbkf_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Alhuudiyankooɓe fuu ina anndi no mbuurdumi gilla mi cukalel. Iɓe anndi no ngorrunoomi e ley yimɓe leydi am e ley Urusaliima fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Iɓe anndi gilla arande, si ɓe njaɓii seedaade: miɗo jokki laawol diina amin ɓurngol tiiɗude ngol, miɗo hiisodaa e Farisa'en. ");
INSERT INTO fuhbkf_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Joonin, mi darake faa mi saree saabe mi yowii jikke am dow amaana mo Laamɗo waɗani maamiraaɓe meeɗen oon. ");
INSERT INTO fuhbkf_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Ƴuwdiiji meeɗen sappo e ɗiɗi ɗiin ina njowi jikke muɓɓen e tabintingol amaana oon, ina ndewira semmbe jemma e nyalooma. Kaananke, wo saabe jikke o Alhuudiyankooɓe peldi kam! ");
INSERT INTO fuhbkf_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Ko waɗi de miiliɗon Laamɗo waawaa iirtinde maayɓe? ");
INSERT INTO fuhbkf_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Miin e hoore am, ley ko faltii mi tannyoriino miɗo haani bonnude innde Iisaa Nasaraatuujo oon, no laatorii fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Wo ɗum pay ngaɗumi Urusaliima du. Hooreeɓe almaami'en ɓeen kokkii kam baawɗe mi udda seniiɓe heewɓe e kasu. Nde ɓe caranoo faa ɓe mbaree ndeen, mi yardake ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Mi torrii ɓe kile keewɗe e cuuɗi baajorɗi ɗiin fuu. Miɗo tilsina ɓe njedda Almasiihu mo ɓe ngoonɗini oon. Tikkere am dow maɓɓe ina mawnunoo sanne, faa miɗo tewna ɓe ley gure janane, miɗo torra ɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Wo hono nii njaarumi Damas. Hooreeɓe almaami'en nelii kam, kokkii kam baawɗe nanngude goonɗinɓe toon. ");
INSERT INTO fuhbkf_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Kaananke, miɗo wonnoo dow laawol wakkati hakkunde naange, nji'umi annoora ina ƴuura dow kammu ina fiiloo kam, miin e yaadiraaɓe am ɓeen fuu. Annoora oon ina ɓuri fay naange jalbude. ");
INSERT INTO fuhbkf_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Min fuu, min caami e leydi. Wakkati oon, nanumi daande ina wi'a kam e ley ibraninkoore: «Sool, Sool, ko waɗi de aɗa torra kam? Si ndemoori wi'ii saloto tufirgel joomum fu, ɓeydan nawnaade.» ");
INSERT INTO fuhbkf_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Njaabiimi, mbiimi: «Aan wo a moy, joomam?» Joomiraaɗo wi'i: «Miin, wo mi Iisaa mo torrataa oon. ");
INSERT INTO fuhbkf_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Umma dara, sabo mi ɓanganii ma, mi suɓake ma faa ngollanaa kam. Wo faa ceedanoɗaa kam ley ko njiiɗaa joonin e ko nji'oytaa si mi ɓangii e maa caggal hannden. ");
INSERT INTO fuhbkf_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Mi reenete e Alhuudiyankooɓe e yimɓe lenyi goɗɗi ɓe nulammaami e muɓɓen joonin ɓeen. ");
INSERT INTO fuhbkf_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Mi nulete faa peertaa gite maɓɓe, ɓe ƴuwa e nimre, ɓe ngarta e annoora, ɓe ƴuwa e baawɗe Seyɗaani, ɓe ngarta e Laamɗo, ɓe keɓa yaafeede hakkeeji maɓɓe, ɓe ndonida e seniiɓe saabe ko ɓe goonɗini kam ɗuum.» ");
INSERT INTO fuhbkf_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Ndelle saabe majjum, kaananke Agirippa, mi salaaki ɗowtanaade ko nji'umi, ko ƴuurani kam dow kammu ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Ɓe artiimi waajaade wo yimɓe Damas e yimɓe Urusaliima e piilol Yahuudiya fuu. Caggal ɗuum, njokkinmi yimɓe lenyi goɗɗi tuuba, ngarta e Laamɗo, ngolla golleeji kollooji tuubii. ");
INSERT INTO fuhbkf_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Saabe ɗuum, Alhuudiyankooɓe nanngiri kam ley suudu dewal mawndu nduun, pilii warude kam. ");
INSERT INTO fuhbkf_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Ammaa Laamɗo wallii kam illa ndeen faa warde hannden. Miɗo seedanoo yimɓe fuu, gilla lo'uɓe faa e tedduɓe. Mi waajataako fay huunde si wanaa ko annabaaɓe e Tawreeta Muusaa mbi'i warowan ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Ɗum woni: Almasiihu torroto faa maaya, de artoo maayɓe ummitaade. De si ummitake fu, waajoto yimɓe meeɗen e lenyi goɗɗi fuu kisindam, ɗam laatanoo ɓe annoora. ");
INSERT INTO fuhbkf_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Nde Pool haalannoo ɗum ndeen, Festus feekii e semmbe, wi'i: —Pool, a haaŋaama! Heewgol maaɗa anndal ngol haaŋii ma! ");
INSERT INTO fuhbkf_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Pool jaabii, wi'i: —Festus tedduɗo, mi haaŋaaka. Ko kaalammi ɗuum wo haalaaji goongaaji, celluɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Agirippa kaananke oon ina anndi kulle ɗeen. Ɗum waɗi de miɗo hoolii haalude ɗum yeeso makko. Si goonga, miɗo tannyori ɗum fuu suuɗanaaki mo, sabo ɗum waɗaay e cuncukka. ");
INSERT INTO fuhbkf_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Kaananke! Aɗa goonɗini annabaaɓe naa? Miɗo anndi aɗa goonɗini! ");
INSERT INTO fuhbkf_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agirippa wi'i Pool: —Aɗa miilii waɗude kam Almasiyankeejo law law hono nii naa? ");
INSERT INTO fuhbkf_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Pool jaabii, wi'i: —Nde yaawi e nde hanndii fuu, ɗum laatoo muuyɗe Laamɗo faa aan e hettindaniiɓe kam joonin fuu laatoɗon hono am, de tawee wanaa e callali gonɗi e am ɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Kaananke oon e goforneer oon e Bereniika e jooɗodinooɓe e muɓɓen fuu ummii. ");
INSERT INTO fuhbkf_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Nde ɓe njaltunoo suudu nduun ndeen, iɓe mbi'undura: —Gorko o waɗaay ko foti warude ɗum naa haɓɓude ɗum callali. ");
INSERT INTO fuhbkf_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agirippa wi'i Festus: —Imo waawnoo yoofeede si o wi'aayno sariya makko faltiniree to kaananke Roma mawɗo oon. ");
INSERT INTO fuhbkf_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Nde yaareede amin Itali e laana tabitinnoo ndeen, Pool e kasunkooɓe woɓɓe ngattaa e junngo mawɗo sordaasiiɓe bi'eteeɗo Yuliyus. Oon wo jeyaaɗo e fedde sordaasiiɓe kaananke Roma mawɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Min naati laana maayo ƴuuruka Adaramati njahooha ina fanta gure ley leydi Aasiya. Min ndunnyi. Miɗen ngondi e Aristarka gorko Makedoniyanke ƴuuruɗo Tesaloniiki. ");
INSERT INTO fuhbkf_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Jaango majjum, min njottii Sidon. Yuliyus waɗani Pool hinney, duŋanii ɗum yaha to yigiraaɓe mum faa mballira ɗum ko haajaa. ");
INSERT INTO fuhbkf_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Nde min ƴuwunoo ɗoon ndeen, min ɓattitowii fonngo ruunde Kipirus, sabo min kawrii e henndu mawndu. ");
INSERT INTO fuhbkf_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Min peƴƴiti maayo manngo ngoon hedde Silisi e Pamfiliya, min njottii Mira ley leydi Lisiya. ");
INSERT INTO fuhbkf_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Ɗoon, mawɗo sordaasiiɓe oon tawi laana ƴuuruka Alesandiri ina fonndii Itali. O nanni min ley makka. ");
INSERT INTO fuhbkf_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Balɗe keewɗe laana amin kaan waɗi ina yaara heese. Semmbe e doole min njottorii wuro Kinidus. Henndu nduun na haɗa min yahude to min ponndii. Ndelle min takkii ruunde Kereta gere to henndu walaa, min panti Salmone. ");
INSERT INTO fuhbkf_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Miɗen takkii senngo, miɗen tampi e yaade. Faa min njottii nokku bi'eteeɗo Jipporde Lobbere nde woɗɗaa e wuro Lasiya. ");
INSERT INTO fuhbkf_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Min ɓooyi sanne faa wakkati iidi nyannde ittugol hakkeeji faltii. Wakkati dabbunde maayo ngoon ina hulɓinii sanne, na tiiɗi laana dilla ndeen. Pool tindini ɓe dow majjum. ");
INSERT INTO fuhbkf_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","O wi'i: —Sakiraaɓe, mi yi'ii jahaangal ngal wo keewungal torra e mursey, wanaa laana ka e gineeji ɗi tan, ina waawi laataade yonkiiji meeɗen du. ");
INSERT INTO fuhbkf_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Ammaa mawɗo sordaasiiɓe oon, wo haala sofeere laana kaan e joomiika ɓuri jaɓude e dow haala Pool. ");
INSERT INTO fuhbkf_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Jipporde laanaaji nde ɓe ngoni e muuɗum ndeen, welaa dabbude. Ɗum waɗi de ɓurɓe heewude ley laana ɓeen mbi'i ɓe njaha ɓe piloo yottaade Fenika faa ɓe ndabba toon. Ɗum wo jipporde wonnde Kereta huccitinde horɗoore-gorgaare e soɓɓiire-gorgaare. ");
INSERT INTO fuhbkf_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Nde henndu seeɗa ƴuurundu horɗoore fuɗɗunoo wifude ndeen, ɓe cikki ɓe mbaawan yottaade to ɓe njiɗi toon. Ɓe ƴeentini jamɗe darnooje laana ɗeen, ɓe takkii e fonngo Kereta, iɓe njaha. ");
INSERT INTO fuhbkf_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Ammaa caggal ɗuum seeɗa, henndu mawndu wi'eteendu henndu soɓɓiire-lettugaare ƴuuri to ruunde toon, jippii. ");
INSERT INTO fuhbkf_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Henndu nduun faddii laana kaan. Min kunngii huccitinde e henndu nduun faa min njaha yeeso. Min acci ika roya. ");
INSERT INTO fuhbkf_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Nde min paltotonoo duungel bi'eteengel Kawda ndeen, min kawri e henndu seeɗa. E ley tampiri, min pooɗi laanayel pamarel ngel min ndaasannoo ngeel. ");
INSERT INTO fuhbkf_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Min ƴepti ngel, min njowi ngel dow laana mawka. Ndeen ɓe kooƴi ɓoggi, ɓe piilii laana mawka kaan. Ɓe njippini jamɗe darnooje laana ɗeen du, ɓe njoppi ika roya, sabo ɓe kulii taa ɓe njanoy e soɓɓundu ruunde Sirta. ");
INSERT INTO fuhbkf_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Henndu nduun ina heddii na wifa min semmbe. Saabe ɗuum, jaango majjum ɓe puɗɗi faɗɗude donngal laana kaan ley maayo manngo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","E nyalooma tataɓo oon, ɓe kooƴi anniya, ɓe paɗɗi fay ginereeji jaarooji laana ley ndiyam ɗiin. ");
INSERT INTO fuhbkf_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Naange e koode du nji'ataake faa waɗi balɗe keewɗe. No henndu nduun foti mawnude, min taƴi jikke amin fuu e hisude. ");
INSERT INTO fuhbkf_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Nde ɓooynoo yimɓe ɓeen keɓaay ko nyaama fu, Pool darii hakkunde maɓɓe, wi'i: —Si on njaɓiino haala am, on ndillaayno Kereta fu, torraaji ɗi e mursey o hewtataakono en. ");
INSERT INTO fuhbkf_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Joonin, miɗo haalana on: cellinee ɓerɗe mon, sabo fay gooto mooɗon mursataa yonki muuɗum, laana ka tan mursetee. ");
INSERT INTO fuhbkf_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Jemma hankin, Laamɗo jeyɗo kam mo ndewammi oon nuli maleyka to am. ");
INSERT INTO fuhbkf_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Maleyka oon wi'i kam: «Pool, taa hulu, tilay a daroto yeeso kaananke Roma mawɗo oon. Laamɗo reenete, aan e yaadiraaɓe maa ɓeen fuu.» ");
INSERT INTO fuhbkf_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Ndelle, cellinee ɓerɗe mon, sabo miɗo hoolii ko Laamɗo haalani kam ɗuum, hono noon jaati worrata. ");
INSERT INTO fuhbkf_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Ammaa tilay en njanowan e ruunde wonnde ley maayo ngo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","E ley jemma sappo e nayaɓo oon, miɗen ndoya ley maayo Adiriyati ngoon faa hannden. Wakkati hakkunde jemma, donnooɓe laana kaan ɓeen cikki ɓadake leydi. ");
INSERT INTO fuhbkf_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Ɓe paɗɗii ɓoggol ponndirgol, ɓe tawi luggeefi kiin wo haddi daranɗe noogay. Ɓe njehi yeeso seeɗa, ɓe paɗɗi katin, ɓe tawi luggeefi kiin wo haddi daranɗe sappo e joy. ");
INSERT INTO fuhbkf_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Ɓe kuli taa ɓe njanoy e kaaƴe. Ndelle ɓe njippini jamɗe nay darnooje laana ɗeen caggal laana kaan, iɓe keppi weetaay. ");
INSERT INTO fuhbkf_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Ndeen gollooɓe laana kaan ɓeen njippini laana pamara kaan e ndiyam, ina njiɗi faa ndilla kam'en tan. Ɓe mbi'i woɓɓe ɓe njippinowan jamɗe to yeeso laana kaan toon faa ndarna ka. ");
INSERT INTO fuhbkf_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Pool wi'i mawɗo oon e sordaasiiɓe ɓeen: —Si yimɓe ɓeen keddaaki e ley laana ka fu, onon, on ndaɗataa. ");
INSERT INTO fuhbkf_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Ndeen sordaasiiɓe ɓeen taƴi ɓoggi nanngunooɗi laana pamara kaan ɗiin, njoppi ngel dilli kangel tan. ");
INSERT INTO fuhbkf_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Nde ɓadinoo weetude ndeen, Pool nyaagii ɓe fuu ɓe nyaama, wi'i: —Hannden woni balɗe sappo e nay oɗon ndoomi on nyaamaay. Oɗon keddii on meeɗaay fay huunde. ");
INSERT INTO fuhbkf_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Ndelle miɗo nyaagoo on sanne, nyaamon. Oɗon kaajaa ɗum faa ndaɗon. Si goonga, fay gooto mooɗon leeɓol hoore muuɗum solataa de saama. ");
INSERT INTO fuhbkf_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Nde o haalnoo ɗum ndeen, o hooƴi buuru, o yetti Laamɗo yeeso maɓɓe ɓe fuu, o heltii, o fuɗɗi nyaamude. ");
INSERT INTO fuhbkf_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Ndeen ɓe fuu ɓerɗe maɓɓe cuusinaa, kamɓe du ɓe kooƴi, ɓe nyaami. ");
INSERT INTO fuhbkf_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Minen wonɓe ley laana kaan ɓeen, min yimɓe keme ɗiɗo e capanɗe njeɗɗo e njeegom. ");
INSERT INTO fuhbkf_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Nde ɓe nyaamnoo faa ɓe kaari ndeen, ɓe kooƴi bootooji alkama gonɗi e laana kaan ɗiin, ɓe paɗɗi ɗi ley maayo manngo faa ɗum huyfintina ka. ");
INSERT INTO fuhbkf_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Nde weetunoo ndeen, ɓe kaynii leydi, de ɓe annditaay ndi. Ɓe nji'i nokkuure njaareendi yaajunde seeɗa. Iɓe njiɗi yaarude toon laana kaan si ɓe mbaawii. ");
INSERT INTO fuhbkf_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Ɓe taƴi jamɗe ɗeen, ɓe njoppi ɗe ley maayo. Ɓe kaɓɓiti ɓoggi kaɓɓaaɗi e ooncirɗe ɗeen du. To hoore laana toon du, ɓe ƴeentini wudere dow, ɓe peerti nde faa henndu nduun dunƴira ka yeeso. Ɓe ponndii daande maayo ngoon. ");
INSERT INTO fuhbkf_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Ndeen laana kaan fiyii e tilde, nufi. Becce makka cokkii e ley njaareendi ndiin faa ka hunngii dimmbaade. Bempeƴƴe du keli caggal makka faa ɗiggi. ");
INSERT INTO fuhbkf_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Sordaasiiɓe ɓeen anniyii warude kasunkooɓe ɓeen taa fay gooto e muɓɓen yinoo de dogga. ");
INSERT INTO fuhbkf_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Ammaa mawɗo sordaasiiɓe oon ina yiɗi dannude Pool. Ndelle o haɗi ɓe waɗude anniya maɓɓe oon. O yamiri waawɓe yinaade ɓeen artoo njinoo mburtowoo, ");
INSERT INTO fuhbkf_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","de heddiiɓe ɓeen du tiigoo kelte laana kaan naa goɗɗum ƴuurɗum e makka. Hono nii min fuu min njottorii leydi e jam. ");
INSERT INTO fuhbkf_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Nde min kisunoo ndeen, min nani ruunde ndeen Malta wi'etee. ");
INSERT INTO fuhbkf_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Jeyaaɓe ɗoon ɓeen njaɓɓorii min caahu mawɗo. Wakkati oon kammu ina toɓa, jaangol du na woodi. Ndelle ɓe kuɓɓani min yiite faa min ƴuuloo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Pool hawrunduri leɗɗe, watti e yiite ngeen. Nguleefi wurtini mboddi e majje, ndi soppi junngo makko. ");
INSERT INTO fuhbkf_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Nde jeyaaɓe ɗoon ɓeen njiinoo mboddi ndiin ina ɓilii e junngo Pool ndeen, mbi'unduri hakkunde muɓɓen: —Tannyoral, gorko o wo gaɗɗo war-hoore. Fay si o daɗi to maayo manngo toon du, sariya accataa mo o wuura. ");
INSERT INTO fuhbkf_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Ndeen o fiɗɗi mboddi ndiin ley yiite, ɗum torraay mo fay huunde. ");
INSERT INTO fuhbkf_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Ɓe miilii o ɓuutan naa o saaman wakkati oon, o maaya. Ammaa nde ɓe keɗinoo faa ɓooyi, ɓe nji'i ɗum torraay mo fay seeɗa fu, hakkillooji maɓɓe mbaylitii e makko. Ɓe mbi'i o wo gooto e alla'en. ");
INSERT INTO fuhbkf_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Pubiliyus, hooreejo ruunde ndeen oon, gese muuɗum ina ngoni sera nokkuure ndeen. O jaɓɓii min faa wooɗi, o weerni min faa haddi balɗe tati, o saahanii min. ");
INSERT INTO fuhbkf_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Tawi baaba Pubiliyus ina fukkii sellaa, wo jontaaɗo, reedu muuɗum du na dogga ƴiiƴam. Pool yehi to makko, du'ii, yowi juuɗe muuɗum e dow makko, danni mo. ");
INSERT INTO fuhbkf_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Nde ɗum waɗunoo ndeen, nyawɓe wonɓe e ruunde ndeen ɓeen ina ngara, na ndannee. ");
INSERT INTO fuhbkf_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Ɓe teddini min teddeengal manngal. Nde min cegilinoo faa min ndilla e laana ndeen, ɓe njooɓini min ko min kaajaa e jahaangal amin. ");
INSERT INTO fuhbkf_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Miɗen ngonnoo toon faa haddi lebbi tati. Ndeen min naati e laana ƴuuruka Alesandiri, ndabbunooka e ruunde ndeen. Min ndilli. Laana kaan ina ŋenyaa ŋenyi tooruuji funereeɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Min njottii wuro wi'eteengo Sirakus, min ngaɗi ɗoon balɗe tati. ");
INSERT INTO fuhbkf_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Min ƴuwi ɗoon, min takkii e daande maayo manngo faa Regiyus. Jaango majjum, henndu horɗoore wifi. E ley balɗe ɗiɗi min njottii Potiyoli. ");
INSERT INTO fuhbkf_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Min tawi toon sakiraaɓe, nyaagii min min ngonda e muɓɓen jeɗɗiire. Ndeen sakitii, min njottowii Roma. ");
INSERT INTO fuhbkf_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Nde sakiraaɓe wonɓe Roma ɓeen nannoo garol amin fu, ngari faa Luumo Abiya e nokku bi'eteeɗo Jipporɗe Tati faa njakkitoo min. Nde Pool yiinoo ɓe ndeen, yetti Laamɗo, ɓeydorii cuusal. ");
INSERT INTO fuhbkf_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Nde min njottinoo Roma ndeen, Pool hokkaa laawol jippoo e feere muuɗum. Sordaasiijo ina hayba ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Balɗe tati caggal ɗuum, Pool noddi mawɓe Alhuudiyankooɓe. Nde ɓe kawritinnoo ndeen, o wi'i ɓe: —Sakiraaɓe! Mi waɗaay fay huunde ko luttundurta kam e yimɓe meeɗen naa aadiiji maamiraaɓe meeɗen. Ammaa mi nanngaama Urusaliima, mi wattaama e juuɗe Romankooɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Ɓeen du ƴamtindake kam, de iɓe muuyunoo yoppude kam, sabo ɓe tawraay kam fay sabaabu gooto kaanɗo warude kam. ");
INSERT INTO fuhbkf_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Ammaa saabe Alhuudiyankooɓe ɓeen calake mi yoppee, ɗum waddani kam nyaagaade sariya am faltiniree to kaananke Roma mawɗo oon. Mi walaa fuu ko mi felda lenyol am. ");
INSERT INTO fuhbkf_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Ɗum waɗi de noddumi on faa mi yi'a on, mi haalana on. Miɗo haɓɓorii callali ɗi saabe mo Israa'iilankooɓe keɗii garol muuɗum oon. ");
INSERT INTO fuhbkf_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Ɓe mbi'i mo: —Min keɓaay ɓataaki ƴuuruki Yahuudiya kaaloohi haala maa. Katin du fay gooto e sakiraaɓe ɓeen waraay humpiti min naa haalani min ko boni ko ngaɗuɗaa. ");
INSERT INTO fuhbkf_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Ammaa miɗen njiɗi kaalanaa min ko njiiɗaa e hakkillo maa, sabo miɗen anndi yimɓe nokkuuje fuu na njedda laawol ngol njokkuɗaa ngool. ");
INSERT INTO fuhbkf_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Ɓe kokkunduri nyalaande nde ɓe ngartoyta. Nyalaande ndeen yottii, heewɓe ngari kawriti to jipporde makko toon. Gilla fajiri faa caggal kiraaɗe imo fiirtana ɓe haala laamu Laamɗo, imo waajoo ɓe. Imo holla ɓe kabaaru Iisaa gonɗo ley Tawreeta Muusaa e ley dewte annabaaɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Woɓɓe maɓɓe njaɓi ko o haali ɗuum, woɓɓe njaɓaay. ");
INSERT INTO fuhbkf_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Nde ɓe cankitotonoo ndeen tawi ɓe ndewraay hakkunde maɓɓe. Ndeen Pool ɓeydi konngol gootol, wi'i: —Ruuhu Ceniiɗo haalii goonga nde haalnoo e hunnduko annabi Esaaya, wi'i maamiraaɓe mooɗon: ");
INSERT INTO fuhbkf_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","«Yahu to lenyol ngol, mbi'aa ɗum: On nanan faa wooɗa, de on paamataa. On ndaaran faa laaɓa, de on nji'ataa. ");
INSERT INTO fuhbkf_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Sabo lenyol ngol ɓernde muuɗum yoorii. Ɓe cukkii noppi maɓɓe, ɓe muɓɓii gite maɓɓe. Si wanaa noon fu gite maɓɓe nji'an, noppi maɓɓe nanan, hakkillooji maɓɓe paaman. Ndeen ɓe ngartan ɓe ndewa kam de mi danna ɓe.» ");
INSERT INTO fuhbkf_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Pool ɓeydi katin, wi'i: —Anndee, kisindam Laamɗo nuldaama yimɓe ɓe nganaa Alhuudiyankooɓe. Kamɓe ɓe kettindoto!  ");
INSERT INTO fuhbkf_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Nde Pool haalnoo haalaaji ɗiin ndeen, Alhuudiyankooɓe ɓeen ndilli ina njeddundura sanne hakkunde muɓɓen. ");
INSERT INTO fuhbkf_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Pool jooɗii suudu to luwi toon duuɓi ɗiɗi kiɓɓuɗi. Imo jaɓɓoo warooɓe ndaarude mo ɓeen fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Imo waajoo laamu Laamɗo. Imo jannginira tannyoral kabaaru Iisaa Almasiihu Joomiraaɗo, walaa fuu ko haɗi mo.");
INSERT INTO fuhbkf_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Ɓataaki ki to am ƴuuri, miin Pool. Mi maccuɗo Iisaa Almasiihu, mi noddaaɗo faa mi laatoo nulaaɗo muuɗum. Wo mi cuɓaaɗo faa mi yottina Kabaaru Laamɗo Lobbo. ");
INSERT INTO fuhbkf_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Kabaaru Lobbo oon wo mo Laamɗo aadinoo gilla e annabaaɓe muuɗum ley Binndi ceniiɗi ɗiin. ");
INSERT INTO fuhbkf_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Kabaaru oon wo haala Ɓiyiiko haalata. Fodde neɗɗaaku muuɗum wo ƴuuruɗo e Daawda. ");
INSERT INTO fuhbkf_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Fodde Ruuhu ceniiɗo du, holliraama wo Ɓii Laamɗo jom baawɗe ko ummitii e maayde ɗuum. Oon woni Joomiraaɗo meeɗen Iisaa Almasiihu. ");
INSERT INTO fuhbkf_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Saabe makko min keɓiri moƴƴere laataade nulaaɓe faa yimɓe ƴuuruɓe e lenyi fuu ngoonɗina mo, ɗowtanoo mo, de innde makko teddinee. ");
INSERT INTO fuhbkf_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Onon du, oɗon njeyaa e maɓɓe, onon ɓe Laamɗo noddi faa kawton e Iisaa Almasiihu ɓeen. ");
INSERT INTO fuhbkf_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Miɗo jowta on fuu, onon wonɓe ley Roma ɓe Laamɗo horsini de noddi faa laatoo seniiɓe. Wo Laamɗo Baaba meeɗen e Joomiraaɗo men Iisaa Almasiihu kokku on moƴƴere e jam. ");
INSERT INTO fuhbkf_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Ko artii fuu, miɗo yetta Laamɗo e dow innde Iisaa Almasiihu saabe mooɗon on fuu, sabo haala goonɗinal mooɗon ina haalee ley adunaaru fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Laamɗo mo ndewammi e ɓernde am fuu e ko ngollanammi Kabaaru Lobbo haala Ɓiyum ɗuum, wo seedee miɗo miccoo on wakkati fuu ");
INSERT INTO fuhbkf_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","e ley du'aawuuji am fuu. Miɗo ŋaaroo Laamɗo newnana kam laawol e ley muuyɗe muuɗum no mi warda to mooɗon. ");
INSERT INTO fuhbkf_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Sabo miɗo yiɗi yi'ude on sanne, faa mi yottinana on dokkal ƴuurungal e Ruuhu faa semmbinɗina on. ");
INSERT INTO fuhbkf_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Wooɗi, ko njiɗumi wi'ude wo faa cemmbunduren ley goonɗinal ngal kawtuɗen ngaal, goonɗinal am semmbina on, ngal mooɗon du semmbina kam. ");
INSERT INTO fuhbkf_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Sakiraaɓe, miɗo yiɗi paamon: kile keewɗe ngaɗumi anniya mi waran to mooɗon de miɗo faddaa faa hannden. Miɗo yiɗi warude faa danya ɓe keɓumi hakkunde mooɗon saabe Almasiihu hono no keɓirmi yimɓe hakkunde lenyi goɗɗi ni. ");
INSERT INTO fuhbkf_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Tilay mi yaha to yimɓe fuu, yimɓe ngallu e wonɓe ladde, to joomiraaɓe anndal e majjuɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Ɗum waɗi de miɗo yiɗi waajaade on Kabaaru Lobbo oon, onon yimɓe Roma du. ");
INSERT INTO fuhbkf_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Mi semtirtaa Kabaaru Lobbo oon, sabo wo o baawɗe Laamɗo faa hisina goonɗinɗo mo fuu: Alhuudiyankooɓe tafon, de caggal ɗuum, lenyi goɗɗi fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Sabo Kabaaru Lobbo oon ina ɓangina no Laamɗo fonnditorii, ina ɓangina wo e goonɗinal tan neɗɗo ndaardetee ponnditiiɗo yeeso Laamɗo, illa fuɗɗoode faa e timmoode. Wo noon Binndi ɗiin mbiiri: «Ponnditiiɗo wuurdan goonɗinal.» ");
INSERT INTO fuhbkf_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Tikkere Laamɗo ina ɓanga illa dow kammu ina jippoo dow luttugol yimɓe e oonyaare muɓɓen fuu. Iɓe kaɗa goonga ɓangude saabe oonyaare maɓɓe ndeen. ");
INSERT INTO fuhbkf_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Si goonga ko neɗɗo waawi anndude e Laamɗo ɗuum ina laaɓani ɓe, sabo Laamɗo hollii ɓe ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Sabo gilla Laamɗo tagi adunaaru ndu faa hannden, golle muuɗum ina ɓangina sifa muuɗum mo yi'ataake oon faa laaɓa, ɗum woni baawɗe makko faa abada ɗeen e no o worri fuu. Saabe ɗuum, yimɓe ɓeen ngalaa ko ɓe njaaboo fey. ");
INSERT INTO fuhbkf_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Fay si taweede iɓe anndi Laamɗo, ɓe teddiniraay ɗum no foti teddinireede noon, ɓe njettaay mo du. Miilooji maɓɓe ɗiin laatake ɓoli, ɓerɗe maɓɓe puuyɗe ɗeen du niɓɓii. ");
INSERT INTO fuhbkf_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Iɓe njaara wo ɓe jom'en hakkillo, jako wo ɓe majjuɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Ɓe loomtinirii teddeengal Laamɗo duumiiɗo oon tooruuji nannduɗi e yimɓe maayooɓe e pooli e kulle ɗe koyɗe nay e daasotooɗe. ");
INSERT INTO fuhbkf_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Saabe ɗuum, Laamɗo yoppidi ɓe e muuyɗe yonkiiji maɓɓe tuunɗe faa ɓe kuyfini ɓalli maɓɓe hakkunde maɓɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Ɓe loomtinirii Laamɗo goongaajo oon e fewre, ɓe teddinii ko tagaa, ɓe ndewi ɗum, ɓe njoppi Taguɗo oon. Oon woni jetteteeɗo faa abada! Aamiina. ");
INSERT INTO fuhbkf_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Saabe ɗuum, Laamɗo yoppidi ɓe e muuyɗe terɗe maɓɓe cemtiniiɗe. Rewɓe maɓɓe ɓeen mbattiti ko haani waɗeede e ɓalli muɓɓen e ko haanaa. ");
INSERT INTO fuhbkf_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Hono noon worɓe ɓeen du njoppi wondude e rewɓe faa naati na muuyundura. Worɓe ina ngaɗundura ko semtinii, de ɓe njomnitoree ley ɓalli maɓɓe fodde majjere maɓɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Saabe ko ɓe miilinoo anndude Laamɗo walaa ko nafata ɗuum, Laamɗo yoppidi ɓe e majjere maɓɓe, faa ɓe ngaɗi ko neɗɗo haanaa waɗude. ");
INSERT INTO fuhbkf_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Iɓe keewi oonyaare e bonanda e eelgal e nganyaandi fuu. Iɓe keewi kiram e war-hoore e pooɗundural e jamba e anniya bonɗo. Wo ɓe nyo'ooɓe yimɓe, ");
INSERT INTO fuhbkf_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","wo ɓe mbonkotooɓe, wanyuɓe Laamɗo. Wo ɓe huyfinooɓe yimɓe, wo ɓe mawninkiniiɓe, mantotooɓe. Iɓe piloo laabi kesi faa ɓe ngaɗa ko boni. Iɓe calanoo saaraaɓe maɓɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Ɓe ngalaa hakkillo, ɓe koolnaaki, ɓe yoorɓe ɓerɗe, ɓe ngalaa yurmeende. ");
INSERT INTO fuhbkf_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Iɓe anndi ko Laamɗo yamiri: gaɗoowo golleeji ɗi fuu ina haani maayde. Ammaa wanaa golleeji ɗiin tan ɓe ngaɗata, iɓe njardoo woɓɓe du ngaɗa ɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Ndelle, aan peloowo woɓɓe oon, mo laatiɗaa fuu a walaa ko njaaboɗaa. Sabo si a felii goɗɗo, aɗa liɓa hoore maa, sabo aan du aɗa waɗa ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Eɗen anndi Laamɗo ina saroo waɗooɓe hono golleeji ɗiin fodde goonga. ");
INSERT INTO fuhbkf_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Aan peloowo waɗooɓe iri golleeji ɗiin tawee hono noon ngaɗirtaa, yalla aɗa sikki a daɗan jukkungo sariya Laamɗo ngoon naa? ");
INSERT INTO fuhbkf_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Naa a jawɗo moƴƴuki Laamɗo mawki kiin, kam e munyal muuɗum e heese muuɗum naa? Yalla a faamaay moƴƴuki muuɗum ina yaare faa tuubaa? ");
INSERT INTO fuhbkf_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Ammaa ko a joorɗo ɓernde, a caliiɗo tuubude ɗuum, aɗa waddana hoore maa tikkere Laamɗo nyannde Laamɗo ɓanginta tikkere muuɗum e sariya mum ponnditiiɗo oon. ");
INSERT INTO fuhbkf_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Sabo Laamɗo barjoto mono fuu golle muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Waɗooɓe ko wooɗi e ley munyal, filotooɓe darja e teddeengal e ko duumotoo ɓeen, keɓan nguurndam nduumiiɗam. ");
INSERT INTO fuhbkf_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Ammaa filotooɓe ko nafata ko'e muɓɓen, saliiɓe goonga de ina kaɓɓii e bonanda ɓeen, jukkungo naawngo keɓata. ");
INSERT INTO fuhbkf_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Torra e ɓillaare ngoodanii gaɗoowo ko boni fuu: Alhuudiyankooɓe tafon, de lenyi goɗɗi njokka. ");
INSERT INTO fuhbkf_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Ammaa darja e teddeengal e jam ngoodanii gaɗoowo ko wooɗi fuu, Alhuudiyankooɓe tafon, de lenyi goɗɗi njokka. ");
INSERT INTO fuhbkf_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Sabo Laamɗo ɓurdintaa yimɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Kala gaɗoowo hakke mo anndaa Tawreeta Muusaa halkan tawa saroraaka Tawreeta oon. Katin du gaɗoowo hakke tawi na anndi Tawreeta, sarorte Tawreeta oon. ");
INSERT INTO fuhbkf_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Yimɓe ndaardataake fonnditiiɓe yeeso Laamɗo e hettindanaade Tawreeta tan. Wo waɗooɓe ko Tawreeta wi'i ɓeen ndaardetee wo fonnditiiɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Ɓe nganaa Alhuudiyankooɓe ɓeen, e rafi muɓɓen anndude Tawreeta fuu, si ɓe ngaɗirii no Tawreeta oon wi'iri ni e ley muuyɗe ko'e maɓɓe, ɓe kollii iɓe njogii Tawreeta e ley hakkillooji maɓɓe fay si ɓe ngalaa Tawreeta Muusaa oon. ");
INSERT INTO fuhbkf_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Ɓe kollii ko Tawreeta Muusaa oon yamiri ɗuum ina winndaa e ɓerɗe maɓɓe. Ɓerɗe maɓɓe ina ceedanoo ɓe, wakkati wakkati miilooji maɓɓe na pela ɓe, wakkati gom du na laamna ɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Ɗum ɓangowan nyannde Laamɗo yamirta Iisaa Almasiihu saroo ko suuɗii ley ɓerɗe ɗuum, no fotirta e Kabaaru Lobbo mo mbaajotoomi oon. ");
INSERT INTO fuhbkf_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Aan, bi'uɗo wo a Alhuudiyanke, aɗa tuugii Tawreeta Muusaa, aɗa mantoroo kawtal maa e Laamɗo, ");
INSERT INTO fuhbkf_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","aɗa anndi muuyɗe Laamɗo, aɗa waawi suɓaade ko wooɗi sabo a jannginaama Tawreeta oon. ");
INSERT INTO fuhbkf_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","A tannyorii wo a ɗowoowo wumɓe, wo a annoora wonɓe e nimre ɓeen. ");
INSERT INTO fuhbkf_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","Aɗa waajoo ɓe njanngaay ɓeen, aɗa janngina sukaaɓe saabe ko njogiɗaa anndal e goonga faa hiɓɓi e ley Tawreeta Muusaa oon ɗuum. ");
INSERT INTO fuhbkf_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Wooɗi ndelle, aɗa tindina woɓɓe, yalla a tindintaa hoore maa naa? Aɗa waajoo taa mbujjee, a wujjataa naa? ");
INSERT INTO fuhbkf_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Aɗa wi'a taa njeenee, a jeenataa naa? Aɗa harmina tooruuji, a wujjataa ley cuuɗi majji toon naa? ");
INSERT INTO fuhbkf_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Aan mantortooɗo Tawreeta, a huyfintaa innde Laamɗo e luttugol maa Tawreeta oon naa? ");
INSERT INTO fuhbkf_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Ɗum waɗi de Binndi ɗiin mbi'i: «Onon ngaɗi de yimɓe ɓe nganaa Alhuudiyankooɓe ɓeen ina mbonkoo innde Laamɗo.» ");
INSERT INTO fuhbkf_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Wooɗi, si aɗa hayba jamirooje Tawreeta, taadagol Alhuudiyankooɓe ina waawi nafude ma. Ammaa si aɗa lutta jamirooje ɗeen, a laatake hono mo taadaaki ni. ");
INSERT INTO fuhbkf_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Si mo taadaaki haybii jamirooje Tawreeta, wanaa Laamɗo ndaardan joomum hono o taadiiɗo nii naa? ");
INSERT INTO fuhbkf_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Mo taadaaki de na hayba Tawreeta Muusaa oon, kam saroyte aan luttuɗo Tawreeta oon, fay si a taadiiɗo annduɗo Binndi ɗiin. ");
INSERT INTO fuhbkf_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Sabo wanaa ko yi'etee ɗuum waɗata neɗɗo Alhuudiyanke jaati, wanaa ko golletee e ɓanndu ɗuum woni taadagol. ");
INSERT INTO fuhbkf_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Wo ko yi'ataake ɗuum waɗata neɗɗo Alhuudiyanke jaati, taadagol du ley ɓernde muuɗum tawetee. Wo Ruuhu gollata ɗum, wanaa binndi. Manoore neɗɗo oon, wanaa to yimɓe ƴuurata, wo to Laamɗo nde ƴuurata. ");
INSERT INTO fuhbkf_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Ndelle, ɗume Alhuudiya'en ɓurdi lenyi goɗɗi? Ɗume woni nafaa taadagol? ");
INSERT INTO fuhbkf_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Ina heewi e alhaaliiji fuu. Ko artii fuu, Laamɗo halfinii ɓe konngol muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Goonga, woɓɓe maɓɓe koolnaaki. Yalla ɗum ina waawi bonnude ko Laamɗo wo koolniiɗo ɗuum naa? ");
INSERT INTO fuhbkf_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Ɗum waawaa koy! Fay si yimɓe fuu wo fewooɓe, tilay Laamɗo kaa annditee wo goongante. Wo hono noon winndiraa: «Fonnditaare maaɗa ina annditee e ko kaalataa ɗuum, si a sardaama du fu, a liɓan.» ");
INSERT INTO fuhbkf_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Ɗo mi haaldan hono no woɓɓe kaaldata ni: si oonyaare meeɗen ina ɓeyda hollude fonnditaare Laamɗo ndeen, noy mbi'eten? Yalla en mbi'an Laamɗo wo oonyiiɗo si jippinii tikkere muuɗum dow meeɗen naa? ");
INSERT INTO fuhbkf_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Fay seeɗa! Sabo si Laamɗo wo oonyiiɗo, noy o sarortoo adunaaru ndu? ");
INSERT INTO fuhbkf_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Goɗɗo na waawi wi'ude faa hannden: si fewre am ɓeydii hollude goongalaaku Laamɗo faa ɗum mawninii teddeengal muuɗum, ko waɗi miɗo saree hono wo mi luttoowo? ");
INSERT INTO fuhbkf_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Si neɗɗo na miilira nii fu, wi'an: «Ngaɗen ko boni faa ko wooɗi funta.» Won mbonkotooɓe ina mbi'a enen du eɗen mbiira noon. Yimɓe ɓeen kaa, jukkungo muɓɓen ina foti e golle muɓɓen. ");
INSERT INTO fuhbkf_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Ndelle, enen Alhuudiyankooɓe ɓeen, eɗen ɓuri yimɓe heddiiɓe naa? En ɓuraa koy. Sabo mi hollii Alhuudiyanke e mo wanaa Alhuudiyanke fuu e ley hakkeeji ngoni. ");
INSERT INTO fuhbkf_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Wo hono no winndiraa: «Walaa fuu ponnditiiɗo, fay gooto, ");
INSERT INTO fuhbkf_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","fay gooto walaa paamal, fay gooto filataako Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Yimɓe fuu mbosake laawol, fuu laatake ɓolɓe. Walaa fuu gaɗoowo ko wooɗi, fay gooto.» ");
INSERT INTO fuhbkf_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","«Kunnduɗe maɓɓe ina nga'i hono caabeeje udditiiɗe ni, ɗemle maɓɓe ina kaala hiila. Toni maɓɓe ina caawi tooke bolle.» ");
INSERT INTO fuhbkf_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","«Kunnduɗe maɓɓe ina keewi kuddi e haalaaji mettuɗi.» ");
INSERT INTO fuhbkf_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","«Koyɗe maɓɓe ina njaawi rufude ƴiiƴam. ");
INSERT INTO fuhbkf_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Bonanda e mettorgal ina njokki ɓe to ɓe njahata fuu, ");
INSERT INTO fuhbkf_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","ɓe anndaa laawol jam.» ");
INSERT INTO fuhbkf_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","«Kulol Laamɗo walaa e ɓerɗe maɓɓe fey.» ");
INSERT INTO fuhbkf_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Eɗen anndi huunde fuu ko Tawreeta Muusaa oon wi'i, wo wonɓe e ley muuɗum ɓeen haaldi, faa kunnduɗe fuu ndeƴƴinoo, de yimɓe adunaaru fuu paama ina poti e hiiteede kiite Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Sabo fay gooto ndaardataake ponnditiiɗo yeeso Laamɗo saabe haybude muuɗum Tawreeta Muusaa. Si goonga, golle Tawreeta oon haaɗii e anndinde yimɓe ko woni hakke. ");
INSERT INTO fuhbkf_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Ammaa joonin Laamɗo ɓanginii no fonnditaare muuɗum heɓirtee ko wanaa haybude Tawreeta Muusaa. Tawreeta oon e dewte annabaaɓe ɗeen kaaliino kabaaru majjum: ");
INSERT INTO fuhbkf_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","o ndaardan goonɗinɓe ɓeen fuu wo fonnditiiɓe saabe goonɗinal muɓɓen Iisaa Almasiihu. Sabo walaa ko senndi yimɓe: ");
INSERT INTO fuhbkf_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","yimɓe fuu luttii, kewtaay yottaade darja Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Ammaa Laamɗo tiigorake ɓe fonnditiiɓe e dokkal saabe hinney muuɗum. O waɗirii ɗum e Iisaa Almasiihu dimɗinɗo ɓe oon. ");
INSERT INTO fuhbkf_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Wo kam Laamɗo waɗi kirsamaari ittoori hakkeeji, faa ittiri hakkeeji goonɗinɓe ɗiin e ƴiiƴam muuɗum. Hono noon Laamɗo holliri fonnditaare muuɗum, fay si jukkaakino luttuɓe arande ");
INSERT INTO fuhbkf_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","saabe munyal muuɗum. O waɗirii ɗum faa o ɓangina fonnditaare makko ley jamaanu mo ngonɗen o, faa o holla wo o ponnditiiɗo, wooɗi du, neɗɗo fuu goonɗinɗo Iisaa, o ndaardan ɗum ponnditiiɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Ndelle, ɗume neɗɗo waawi mantoraade? Walaa! Haybude Tawreeta Muusaa oon waɗi ɗum naa? Wanaa! Goonɗinal tan waɗi ɗum! ");
INSERT INTO fuhbkf_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Sabo miɗen anndi neɗɗo ndaardete ponnditiiɗo saabe goonɗinal muuɗum, wanaa saabe haybugol muuɗum Tawreeta. ");
INSERT INTO fuhbkf_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Naa Laamɗo wo Laamɗo Alhuudiyankooɓe tan naa? Wanaa wo o Laamɗo lenyi goɗɗi ɗiin du naa? Goonga, wo o Laamɗo lenyi goɗɗi ɗiin du. ");
INSERT INTO fuhbkf_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Sabo Laamɗo gooto woodi, ndaardoowo taadiiɓe ɓeen fonnditiiɓe saabe goonɗinal muɓɓen, ɓe taadaaki ɓeen du o ndaardan ɗum'en fonnditiiɓe saabe goonɗinal muɓɓen. ");
INSERT INTO fuhbkf_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Ndelle, min ngaɗii Tawreeta Muusaa oon wo ɓolum saabe goonɗinal naa? Fay seeɗa! Min ɓolɗinaay mo, min tabintinii mo! ");
INSERT INTO fuhbkf_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Ɗume mbi'eten dow Ibrahiima maami en oon? Ɗume o ekitii dow kabaaru oon? ");
INSERT INTO fuhbkf_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Si tawiino o laatake ponnditiiɗo saabe golleeji makko ɗiin, ndeen imo waawunoo mantaade. De yeeso Laamɗo kaa o waawaa mantaade. ");
INSERT INTO fuhbkf_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Sabo Binndi ɗiin mbi'ii: «Ibrahiima goonɗinii Laamɗo, de Laamɗo hiisorii mo saabe majjum wo o ponnditiiɗo.» ");
INSERT INTO fuhbkf_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Wooɗi, si neɗɗo gollii fu, njobdi muuɗum hiisortaake hono moƴƴere, wo ko tilsi yoɓeede. ");
INSERT INTO fuhbkf_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Ammaa yeeso Laamɗo neɗɗo waawaa yowude jikke muuɗum dow golle mum. Sanaa o goonɗina Laamɗo baawɗo nanngirde bonɓe wo fonnditiiɓe oon, ndeen goonɗinal makko hiisete wo fonnditaare. ");
INSERT INTO fuhbkf_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Noon Daawda du haaliri dow barke neɗɗo mo Laamɗo hiisorii ponnditiiɗo baka golleeji ngalaa. O wi'ii: ");
INSERT INTO fuhbkf_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","«Barke woodanii yimɓe ɓe lutti muɓɓen njaafaa, ɓe hakkeeji muɓɓen mooytaa. ");
INSERT INTO fuhbkf_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Barke woodanii neɗɗo fuu mo Joomiraaɗo hiisaaki hakkeeji muuɗum.» ");
INSERT INTO fuhbkf_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Yalla taadiiɓe ɓeen tan njeyi barke oon naa? Yalla ɓe taadaaki ɓeen ngalaa toon naa? En mbi'ii: wo saabe goonɗinal Laamɗo hiisorii Ibrahiima wo ponnditiiɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Ndelle, noy Ibrahiima worrunoo nde ndaardanoo wo ponnditiiɗo ndeen? O taadiiɗo naa o wanaa? Si goonga, o ndaardaama o ponnditiiɗo gilla o taadaaki. ");
INSERT INTO fuhbkf_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Taadagol makko du wo maande holloore fonnditaare makko saabe goonɗinal ngal o woodunoo gilla o taadaaki. Hono noon, o laatorii maama goonɗinɓe ɓe taadaaki ɓeen fuu, faa ɓeen du kiisoree wo fonnditiiɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Kanko woni baaba taadiiɓe du, de ɓe kaaɗaay e taadagol tan. Wo ɓe jokkuɓe laawol makko du, kanko baaba meeɗen Ibrahiima goonɗinɗo Laamɗo gilla taadaaki. ");
INSERT INTO fuhbkf_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Laamɗo aadake hokkude Ibrahiima e ƴuwdi muuɗum adunaaru ndu. Amaana oon daraaki dow ko Ibrahiima jokki Tawreeta oon, ammaa darake dow fonnditaare nde Ibrahiima heɓi saabe goonɗinal muuɗum ndeen. ");
INSERT INTO fuhbkf_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Sabo si amaana oon darake dow jokkugol Tawreeta fu, goonɗinal laatake ɓolal, wooɗi amaana oon du nafataa. ");
INSERT INTO fuhbkf_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Sabo jamirooje Tawreeta ɗeen wo jukkungo Laamɗo ngaddata. De si jamirooje ngalaa fu, lutti du ngalaa. ");
INSERT INTO fuhbkf_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Ndelle, amaana Laamɗo oon wo dow goonɗinal yowii, faa laatoo moƴƴere makko. O tabitan e ƴuwdi Ibrahiima fuu, wanaa hokkaaɓe Tawreeta tan, ammaa goonɗinirɓe no Ibrahiima goonɗiniri ni ɓeen fuu. Kanko woni maama meeɗen en fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Ɗum ina hawra e ko winndaa dow Ibrahiima: «Mi waɗii ma baaba lenyi keewɗi.» Wo noon ɗum laatorii yeeso Laamɗo mo Ibrahiima goonɗini, kokkoowo maayɓe nguurndam, jamiroowo ko walaa ɗuum laatoo. ");
INSERT INTO fuhbkf_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Fay si Ibrahiima walaa daliili dow ko yowa jikke muuɗum heɓude ƴuwdi katin, o heddii imo goonɗini. Wo nii o laatorii baaba lenyi keewɗi no Laamɗo wiirunoo mo ni: «Hono nii ƴuwdi maaɗa fotata.» ");
INSERT INTO fuhbkf_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Ibrahiima duuɓi muuɗum ina ngaɗa hono hemre, ammaa goonɗinal mum lokkiɗaay nde yi'unoo ɓanndu mum naywii, deekum Saaratu oon du naywii, faltake rimude. ");
INSERT INTO fuhbkf_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","O sikkitiraay amaana Laamɗo oon. Ko laatii dey, goonɗinal makko ɓeydii semmbe, o teddini Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","O tannyorii Laamɗo ina waawi tabintinde amaana muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Saabe ɗuum, «Laamɗo hiisorii mo wo o ponnditiiɗo.» ");
INSERT INTO fuhbkf_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Ko Binndi ɗiin mbi'i «Laamɗo hiisorake mo wo o ponnditiiɗo» ɗuum, wanaa saabe makko tan winndiraa. ");
INSERT INTO fuhbkf_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Iɗum winndiraa saabe meeɗen enen du. Laamɗo hiisorto en fonnditiiɓe, enen goonɗinɓe Laamɗo iirtinii Joomiraaɗo meeɗen Iisaa e maayde oon. ");
INSERT INTO fuhbkf_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","O hokkitiraama, o maayi saabe lutti men, de o iirtinaa faa ndaardeɗen fonnditiiɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Ko keɓuɗen ndaardeede fonnditiiɓe saabe goonɗinal ɗuum, waɗii jam hakkunde meeɗen e Laamɗo saabe Joomiraaɗo men Iisaa Almasiihu. ");
INSERT INTO fuhbkf_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Kam udditani en dammbugal hinney Laamɗo mo ngonɗen joonin saabe goonɗinal meeɗen. Ley majjum eɗen ceyoroo jikke wondude e darja Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Wanaa ɗum tan, eɗen ceyoroo torraaji meeɗen du sabo eɗen anndi torraaji ndimata munyal, ");
INSERT INTO fuhbkf_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","munyal du rima ne'aaku, ne'aaku du rima jikke. ");
INSERT INTO fuhbkf_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Jikke oon du waasataake, sabo Ruuhu Ceniiɗo mo kokkaɗen oon hebbinii en njinngu Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Sabo ley wakkati mo Laamɗo suɓii oon, nde tawanoo en ngalaano semmbe ndeen, Almasiihu maayani en, enen luttuɓe Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Ina tiiɗi ko goɗɗo jaɓa maayande neɗɗo fay si wo ponnditiiɗo. Ina hasii goɗɗo suusa maayande lobbo. ");
INSERT INTO fuhbkf_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Ammaa Laamɗo hollii no yiɗiri en ko Almasiihu maayanii en gilla en luttuɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Joonin ko ndaardaɗen en fonnditiiɓe saabe ƴiiƴam makko ɗuum, tannyoral en ndaɗan tikkere Laamɗo du saabe makko. ");
INSERT INTO fuhbkf_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Sabo nde laatinoɗen wayɓe Laamɗo ndeen, Laamɗo rewrintinii en e muuɗum saabe maayde Ɓiyum. Ko ndewrintinaɗen e makko joonin ɗuum, sikke fuu walaa en kisinte saabe nguurndam Ɓiyiiko oon du. ");
INSERT INTO fuhbkf_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","De wanaa ɗuum tan, ammaa eɗen ceyoroo Laamɗo saabe Joomiraaɗo men Iisaa Almasiihu, dewrintinɗo en e Laamɗo oon. ");
INSERT INTO fuhbkf_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Joonin le, wo saabe neɗɗo gooto de hakke naati e adunaaru, wooɗi hakkeeji ɗiin du ngaddi maayde. Noon maayde ndeen yottorii yimɓe fuu, sabo ɓe fuu ɓe luttii. ");
INSERT INTO fuhbkf_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Si goonga, gilla Tawreeta Muusaa oon jippinaaka, hakkeeji ina ngoodi e adunaaru ndu. De si jamirooje Tawreeta ngalaa, hakkeeji kiisataake. ");
INSERT INTO fuhbkf_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Gilla e Aadama faa e Muusaa, walaa fuu mo maayde jaalaaki, fay yimɓe ɓe ngaɗaay hakke iri mo Aadama waɗi nde luttunoo yamiroore Laamɗo. Aadama oon wo alhaali garoowo oon. ");
INSERT INTO fuhbkf_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Ammaa en kaanaa fonndude luttal Aadama e dokkal Laamɗo. Goonga, yimɓe heewɓe maayii saabe luttal neɗɗo gooto. Ammaa hinney Laamɗo, kam e dokkal ngal hokki yimɓe heewɓe saabe neɗɗo gooto ina ɓuri ɗum fuu manngu. Neɗɗo oon woni Iisaa Almasiihu. ");
INSERT INTO fuhbkf_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Katin du en kaanaa fonndude ko dokkal Laamɗo rimata ɗuum e ko luttal neɗɗo gooto rimata ɗuum. Sabo sariya waɗaama dow luttal gootal ngaal, de ɗum waddi jukkungo. Ammaa moƴƴere Laamɗo mawnde wari caggal lutti keewɗi, de ɗum waddi fonnditaare. ");
INSERT INTO fuhbkf_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Wo saabe luttal neɗɗo gooto maayde laamorii yimɓe. Ammaa ɗum waawaa fonndeede e laamagol heɓooɓe moƴƴere Laamɗo heewnde e dokkal fonnditaare ɓeen. Ɓeen laamortoo e nguurndam saabe neɗɗo gooto. Oon woni Iisaa Almasiihu. ");
INSERT INTO fuhbkf_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Ndelle, no luttal neɗɗo gooto waddirani yimɓe fuu jukkungo ni, hono noon du gollal ponnditiingal ngal neɗɗo gooto golli ina laatanoo yimɓe fuu fonnditaare e nguurndam. ");
INSERT INTO fuhbkf_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","No salaare neɗɗo gooto waɗiri yimɓe heewɓe luttuɓe ni, hono noon ɗowtaare neɗɗo gooto du waɗiroyta heewɓe ndaardee fonnditiiɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Tawreeta naatii faa lutti ɓeyda annditeede. Ammaa fay ko lutti keewi ɗuum fu, hinney Laamɗo ɓuri heewude. ");
INSERT INTO fuhbkf_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Hono no luttal laamorii de waddi maayde ni, hono noon hinney Laamɗo oon du laamortoo saabe fonnditaare, faa yaara en to nguurndam nduumiiɗam saabe Iisaa Almasiihu Joomiraaɗo meeɗen. ");
INSERT INTO fuhbkf_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Ndelle, ɗume mbi'eten? En keddoto e hakkeeji yalla hinney Laamɗo ina ɓeydoo naa? ");
INSERT INTO fuhbkf_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Kayto! Ɗum waawaa laataade! En ceedii e hakkeeji faa laatoɗen maayɓe to majji. Ndelle noy mbuurdirten ley majji katin? ");
INSERT INTO fuhbkf_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Oɗon anndi lootagal meeɗen batisima kaɓɓungal en e Iisaa Almasiihu ngaal hawtii en e maayde muuɗum du. ");
INSERT INTO fuhbkf_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Ndelle, e ley lootagal batisima ngaal en maaydii e makko, en uwidaama e makko. Ndeen du, no Almasiihu iirtorii e hakkunde maayɓe saabe baawɗe Baabiiwo tedduɗe ɗeen, enen du en mbuurda noon nguurndam kesam. ");
INSERT INTO fuhbkf_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Sabo si en kawtii e makko ley maayde nanndunde e maayde makko, en kawtan e makko ummitagol nanndungol e ngol makko. ");
INSERT INTO fuhbkf_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Ndelle eɗen paami ɗum ɗo: tomottaaku meeɗen kiinngu nguun tontidaama e makko dow leggal palaangal, faa baawɗe ɓalli men luttooji ɗiin kalka, faa tawee en nganaa maccuɓe hakke katin. ");
INSERT INTO fuhbkf_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Sabo si neɗɗo maayii fu, yaltii e hawju hakke. ");
INSERT INTO fuhbkf_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Ko maayduɗen e Almasiihu ɗuum, eɗen koolii en mbuurdan e makko du. ");
INSERT INTO fuhbkf_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Sabo eɗen anndi ko Almasiihu iirtii e hakkunde maayɓe ɗuum, maayataa katin. Maayde walaa baawɗe dow makko katin. ");
INSERT INTO fuhbkf_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Ko o maayi ɗuum, wo saabe hakkeeji yimɓe nde wootere faa abada. Joonin ko o wuuri ɗuum, wo muuyɗe Laamɗo o wuurani. ");
INSERT INTO fuhbkf_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Hono noon, onon du, laatee maayɓe ɓe hakkeeji laamaaki, de laatanoɗon Laamɗo wuuruɓe e kawtal Iisaa Almasiihu. ");
INSERT INTO fuhbkf_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Ndelle, taa accee hakke laamoo ɓalli mooɗon maayooji ɗiin faa njokkon muuyɗe majji. ");
INSERT INTO fuhbkf_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Taa kokkitiree terɗe ɓalli mon hakke, taa ngaɗon ɗe kaɓitirɗe oonyaare. Kokkee ko'e mon Laamɗo, sabo on iirtinaama e maayde, oɗon mbuuri. Kokkee terɗe mooɗon Laamɗo faa ɗe laatoo kaɓitirɗe fonnditaare. ");
INSERT INTO fuhbkf_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Hakke laamataako on katin, sabo on ngalaa ley jamirooje Tawreeta. Wo ley hinney Laamɗo ngonɗon. ");
INSERT INTO fuhbkf_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Ndelle noy? Yalla en ngaɗan hakke sabo ley hinney ngonɗen wanaa ley Tawreeta naa? Kayto! Ɗum waawaa laataade! ");
INSERT INTO fuhbkf_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","On paamaay naa? Si on kokkii goɗɗo ko'e mon faa ngollanon ɗum, ɗowtanoɗon ɗum fu, on laatake maccuɓe mo ɗowtantoɗon oon. Ndelle, naa on laatake maccuɓe hakke jaaroowo on e maayde, naa on ɗowtanake Laamɗo jaaroowo on e fonnditaare. ");
INSERT INTO fuhbkf_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Ammaa jettooje ngoodanii Laamɗo! Arande wo on maccuɓe hakke, de joonin on laatake jokkirɓe laawol ngol njannginaɗon ngool e ɓerɗe laaɓuɗe. ");
INSERT INTO fuhbkf_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","On ndimɗinaama e hakke, on laatake maccuɓe fonnditaare. ");
INSERT INTO fuhbkf_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Miɗo haalda ɗo no yimɓe paamirta ni saabe lokkaaku mooɗon. Arande oɗon ngattunoo terɗe mon ley hawju tuundi e bonanda faa ko boni ɓeydoo. Joonin kaa, ngaɗiron ɗe noon ley hawju fonnditaare faa ngollon ko senii. ");
INSERT INTO fuhbkf_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Nde ngonnoɗon ley maccungaaku hakke ndeen, on laataakino gollooɓe ɗowtaniiɓe fonnditaare. ");
INSERT INTO fuhbkf_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Nafaa oye keɓuɗon e majjum wakkati oon? Fay huunde, si wanaa ko cemtirton hannden ɗuum, sabo cakitte majjum wo maayde. ");
INSERT INTO fuhbkf_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Ammaa joonin, on ndimɗinaama e maccungaaku hakke, on laatake maccuɓe Laamɗo. Nafaa mo keɓuɗon wo joonnde seniinde, de cakitte majjum du wo nguurndam nduumiiɗam. ");
INSERT INTO fuhbkf_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Sabo njobdi hakke wo maayde, ammaa dokkal Laamɗo wo nguurndam nduumiiɗam e ley kawtal Iisaa Almasiihu Joomiraaɗo meeɗen. ");
INSERT INTO fuhbkf_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Sakiraaɓe, miɗo haalana on onon annduɓe Tawreeta Muusaa. Oɗon anndi jamirooje Tawreeta na ndawrana neɗɗo haddi nguurndam muuɗum tan. ");
INSERT INTO fuhbkf_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Hono nii debbo ɓaŋaaɗo du, jamirooje kaɓɓiri ɗum e gorum oon si gorum oon ina wuuri. Ammaa si gorum oon maayii fu, o haɓɓitaama e jamirooje kaɓɓunooɗe mo ɗeen. ");
INSERT INTO fuhbkf_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Si goɗɗo ɓaŋii mo e ley nguurndam goriiko oon, wi'ete wo o jeenoowo. Ammaa si goriiko oon maayii, jamirooje ɗeen njoppan mo, o wi'ataake jeenoowo si o ɓaŋundurii e gorko goɗɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Sakiraaɓe am, onon du, fodde Tawreeta Muusaa, on laatake maayɓe. On ƴuwii e ley muuɗum saabe ɓanndu Almasiihu tontanaandu on nduun faa njeyaɗon e muuɗum. Kam woni mo Laamɗo iirtini e hakkunde maayɓe oon faa ngollen ko welata Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Wakkati nde ngonnoɗen ley hawju muuyɗe terɗe ndeen, muuyɗe meeɗen bonɗe ɗe Tawreeta ummini ɗeen ina ngolla e ɓalli men faa njaara en to maayde. ");
INSERT INTO fuhbkf_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Ammaa joonin, en ndimɗinaama e Tawreeta. Fodde Tawreeta kaɓɓunooɗo en oon, en laatake maayɓe, faa mbaawen gollande Laamɗo dow laawol kesol ngol Ruuhu muuɗum hawjii, wanaa dow laawol kiinngol ngol binndi njamirnoo. ");
INSERT INTO fuhbkf_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Ndelle, ɗume mbi'eten? Tawreeta Muusaa oon wo hakke naa? Wanaa koy! Ammaa, si Tawreeta walaa fu, mi anndaano ko woni hakke. Sabo mi anndaano ko woni muuyude ko jeyaa si Tawreeta wi'aayno: «Taa muuyu ko a jeyaa!» ");
INSERT INTO fuhbkf_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Ammaa hakke adii ko jamirooje kaɗi ɗuum, de waɗi e am siyiiji muuyɗe terɗe fuu. Sabo si Tawreeta walaano fu, hakke wo huunde waatunde. ");
INSERT INTO fuhbkf_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Miin e hoore am, nde mi anndaano Tawreeta arande ndeen, miɗo wuurnoo, ammaa ko kaɗaaɗi ɗiin ngari ɗuum, hakkeeji laatii buurɗi, ");
INSERT INTO fuhbkf_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","de miin du, maayumi. Jamirooje kaanunooɗe waɗande kam nguurndam ɗeen, laatii jaarooje kam to maayde. ");
INSERT INTO fuhbkf_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Sabo hakke adii kaɗaaɗi ɗiin, de hiili kam, wardi kam ɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Ndelle, Tawreeta Muusaa wo ceniiɗo, jamirooje ɗeen du wo ceniiɗe, wo ponnditiiɗe, wo moƴƴuɗe. ");
INSERT INTO fuhbkf_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Ndelle, yalla ko wooɗi waddanii kam maayde naa? Ɗum waawaa laataade! Wo hakke waɗi ɗum. Hono nii hakke annditirtee wo hakke jaati, sabo o nawtorake ko wooɗi faa rimana kam maayde. Ndelle, jamirooje ɗeen kolli hakke oon wo huunde bonnde faa faltii haddi. ");
INSERT INTO fuhbkf_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Eɗen anndi Tawreeta Muusaa oon to Ruuhu Ceniiɗo ƴuuri. De miin kaa, mi adunanke tan mo hakke dawrani. ");
INSERT INTO fuhbkf_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Sabo mi faamaay ko ngaɗammi ɗuum: ko njiɗumi waɗude ɗuum, mi waɗataa ɗum, de ko mbanyumi ɗuum, wo ɗuum ngaɗammi. ");
INSERT INTO fuhbkf_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Si miɗo waɗa ko mi yiɗaa waɗude ɗuum, ina holla mi jaɓii jamirooje Tawreeta ɗeen ina mbooɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Ndelle, wanaa miin waɗirta noon, wo hakke gonɗo ley am. ");
INSERT INTO fuhbkf_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Miɗo anndi e ley am, ɗum woni e ley ɓanndu am, ko wooɗi walaa e muuɗum. Yiɗude waɗude ko wooɗi ina woni e am, de mi waawaa waɗude ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Mi waɗataa ko wooɗi ko njiɗumi ɗuum, wo ko boni ko mi yiɗaa ɗuum ngaɗammi. ");
INSERT INTO fuhbkf_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Ammaa si mi waɗii ko mi yiɗaa, wanaa miin gollirta noon, wo hakke gonɗo ley am oon. ");
INSERT INTO fuhbkf_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Ko taykiimi dey: wakkati fuu miɗo yiɗi waɗude ko wooɗi, de ko boni ina woni e am, ina haɗa kam. ");
INSERT INTO fuhbkf_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","E ley ɓernde am miɗo seyoroo Jamirooje Laamɗo ɗeen. ");
INSERT INTO fuhbkf_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Ammaa miɗo maata al'aada bonɗo e ley ɓanndu am, ina haɓa e laawol ngol hakkillo am wi'i na wooɗi ngool. Al'aada bonɗo oon ina waɗa kam maccuɗo hakke gonɗo ley ɓanndu am oon. ");
INSERT INTO fuhbkf_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Kay, miɗo yurminii! Moy waawi dannude kam e ɓanndu yaarooru kam to maayde ndu? ");
INSERT INTO fuhbkf_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Jettooje ngoodanii Laamɗo saabe Joomiraaɗo meeɗen Iisaa Almasiihu! Ndelle miin, e ley hakkillo am wo mi maccuɗo jamirooje Laamɗo, ammaa e ɓanndu am wo mi maccuɗo laawol hakke. ");
INSERT INTO fuhbkf_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Joonin kaa, jukkungo fuu walaa e hawtuɓe e Iisaa Almasiihu ɓeen, ");
INSERT INTO fuhbkf_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","sabo baawɗe Ruuhu kokkooje en nguurndam saabe Iisaa Almasiihu ɗeen ndimɗinii en e baawɗe hakke e maayde fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Ko Tawreeta Muusaa waawaayno waɗude saabe lokkaaku ɓalli men, wo ɗuum Laamɗo waɗi. O nuli Ɓiyiiko e ley tagaadi nanndundi e ɓiɓɓe-Aadama jom'en hakkeeji ɓeen faa itta hakke. E ley tagaadi ndiin o jukkii hakke golloowo e ley ɓalli men. ");
INSERT INTO fuhbkf_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Ɗum fuu wo faa laaɓal ngal Tawreeta yamiri ngaal hiɓɓa e dow meeɗen, enen jokkuɓe Ruuhu ɓe nganaa jokkuɓe muuyɗe terɗe ɓeen. ");
INSERT INTO fuhbkf_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Jokkuɓe muuyɗe terɗe ɓeen, muuyɗe terɗe na ndawrana hakkillooji muɓɓen. De jokkuɓe Ruuhu ɓeen, wo Ruuhu dawranta hakkillooji muɓɓen. ");
INSERT INTO fuhbkf_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Hakkillo jokkoowo muuyɗe terɗe muuɗum, na waddana joomum maayde. Hakkillo jokkoowo ko Ruuhu jeyi du, na waddana joomum nguurndam e jam. ");
INSERT INTO fuhbkf_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Sabo hakkillo jokkoowo muuyɗe terɗe muuɗum tan ina wanyi Laamɗo. Joomum ɗowtantaako Jamirooje Laamɗo ɗeen. Si goonga du, waawaa. ");
INSERT INTO fuhbkf_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Jokkuɓe muuyɗe terɗe ɓeen mbaawaa welude Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","De onon le, on njokkataa muuyɗe terɗe, ammaa oɗon njokka Ruuhu, si goonga fu Ruuhu Laamɗo ina woni ley ɓerɗe mooɗon. Neɗɗo fuu mo walaa Ruuhu Almasiihu oon, waldaa e Almasiihu. ");
INSERT INTO fuhbkf_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Kaa si Almasiihu ina woni e mooɗon, fay si taweede ɓalli mon wo maayɗi saabe hakke, yonkiiji mon kaa wo buurɗi saabe on ndaardaama on fonnditiiɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Si Ruuhu Laamɗo ina woni ley ɓerɗe mooɗon, Laamɗo buurtinɗo Iisaa Almasiihu e hakkunde maayɓe oon, hokkan ɓalli mon maayooji ɗiin nguurndam, hokkiran ɗum Ruuhu muuɗum gonɗo ley ɓerɗe mon oon. ");
INSERT INTO fuhbkf_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Ndelle, sakiraaɓe, won ko tilsani en, de ɗum wanaa jokkude muuyɗe terɗe. ");
INSERT INTO fuhbkf_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Sabo si on mbuurdii oɗon njokka muuyɗe terɗe, on maayan. Ammaa si on mbardii muuyɗe ɗeen Ruuhu Laamɗo fu, on mbuuran. ");
INSERT INTO fuhbkf_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Ɓe Ruuhu Laamɗo ɗowata fuu wo ɓiɓɓe Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Laamɗo hokkaay on Ruuhu gaɗoowo on maccuɓe faa ngarton e kulol. O hokkii on Ruuhu gaɗoowo on ɓiɓɓe Laamɗo. Kam waɗata faa noddiren Laamɗo «Abba». ");
INSERT INTO fuhbkf_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Ruuhu oon e hoore muuɗum na hawta e ɓerɗe meeɗen faa laamna en wo en ɓiɓɓe Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Si en ɓiɓɓe, wo en ronooɓe du. En ndonan ko Laamɗo aadinoo ɗuum, en ndondan e Almasiihu du. Sabo sini en njardi torra e makko fu, en keɓidan e makko teddeengal du. ");
INSERT INTO fuhbkf_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Mi hiisake torraaji wakkati joonin mbaawaa fonndeede e teddeengal ngal Laamɗo ɓanginanta en. ");
INSERT INTO fuhbkf_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Si goonga, tagoore fuu ina heppi nyannde nde Laamɗo ɓanginta ɓiɓɓe muuɗum ndeen. ");
INSERT INTO fuhbkf_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Sabo tagoore ndeen ina faddee hiɓɓinde ko nde jeyi gollude. Wanaa e muuyɗe mayre ɗum waɗaa, wo Laamɗo muuynoo ɗum. Ammaa jikke ina heddii, ");
INSERT INTO fuhbkf_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","sabo tagoore ndeen rimɗinte e maccungaaku nyolngu, yaaree e ley ndimaaku e teddeengal ngal ɓiɓɓe Laamɗo ndesanaa. ");
INSERT INTO fuhbkf_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Sabo eɗen anndi, faa joonin tagoore ndeen fuu ina uuma ina tampi e naawalla ŋatawere. ");
INSERT INTO fuhbkf_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Wanaa ko tagaa tan uumata, enen heɓirɓe Ruuhu Laamɗo oon hono dokkal Laamɗo artiingal, enen du eɗen uuma. Eɗen keppi Laamɗo waɗaay en ɓiɓɓe muuɗum, de rimɗina ɓalli men. ");
INSERT INTO fuhbkf_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","En kisinaama, de wo ley jikke dow ko warata tafon. De jikke keɓaaɗo selii laataade jikke, sabo neɗɗo yowataa jikke e dow ko heɓi. ");
INSERT INTO fuhbkf_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Ammaa si eɗen njowi jikke e dow ko en keɓaay tafon, en ndoomiran ɗum munyal. ");
INSERT INTO fuhbkf_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Katin du, Ruuhu waran na walla en e lokkaaku men. Sabo si goonga, en anndaa no kaanɗen waɗirde du'aare ni. Ammaa Ruuhu oon e hoore muuɗum nyaaganto en Laamɗo, nyaagoranoo en uumaali ɓurɗi haalaaji luggude. ");
INSERT INTO fuhbkf_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Laamɗo kumpitiiɗo ko woni ley ɓerɗe men oon du ina anndi anniya Ruuhu, sabo wo e muuyɗe makko Ruuhu oon nyaagirantoo seniiɓe ɓeen. ");
INSERT INTO fuhbkf_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Eɗen anndi Laamɗo ina gollira huunde fuu faa laatanoo yiɗuɓe ɗum ko wooɗi, ɓe o noddi fodde anniya makko. ");
INSERT INTO fuhbkf_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Sabo ɓe Laamɗo anndi gilla tagaaka ɓeen, o fodanake ɗum'en nanndude e Ɓiyiiko oon, faa Ɓiɗɗo oon laatoo afo ardiiɗo dow sakiraaɓe heewɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Katin du ɓe o fodanii ɓeen, o noddii ɗum'en, ɓe o noddi ɓeen, o tiigorake ɗum'en fonnditiiɓe, ɓe o tiigorii fonnditiiɓe ɓeen du, o hokkii ɗum'en ngeɗu muɓɓen e teddeengal makko. ");
INSERT INTO fuhbkf_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Caggal ɗuum fuu, ɗume mbi'eten? Si Laamɗo ina wondi e meeɗen, moy waawani en? ");
INSERT INTO fuhbkf_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Kanko, fay Ɓiyiiko oon e hoore muuɗum o haɗaay en, o hokkitirii ɗum saabe meeɗen en fuu. Si noon woni moƴƴere makko, wanaa o hokkidan en e muuɗum huunde fuu naa? ");
INSERT INTO fuhbkf_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Moy yaarata ɓe Laamɗo suɓii ɓeen sariya? Fay gooto, sabo Laamɗo tiigorake ɓe fonnditiiɓe! ");
INSERT INTO fuhbkf_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Moy waawi felude ɓe yeeso sariya? Fay gooto, sabo Iisaa Almasiihu maayii, ko ɓuri ɗum du, o iirtake. Imo jooɗii gere nyaamo Laamɗo, imo nyaaganoo en. ");
INSERT INTO fuhbkf_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Ɗume waawi senndude en e njinngu Almasiihu? Tiiɗallaaji naa, ɓillaare naa, torra naa, yolbere naa, kolndam naa, masiiba naa, maa kaafaahi naa? ");
INSERT INTO fuhbkf_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Wo hono no Binndi ɗiin mbiiri: «Saabe maaɗa miɗen nesa maayde nyannde fuu, miɗen ndaardee hono baali kirseteeɗi ni.» ");
INSERT INTO fuhbkf_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Ammaa e ley majjum fuu, saabe jiɗɗo en oon, eɗen ɓuri fay jaalotooɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Sabo miɗo tannyori, wanaa maayde, wanaa nguurndam, wanaa maleyka'en, wanaa laamu, wanaa ko wari joonin, wanaa ko waroyta, wanaa semmbe, ");
INSERT INTO fuhbkf_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","wanaa ko woni faa dow, wanaa ko woni faa ley, huunde fuu ko tagaa waawaa senndude en e njinngu ngu Laamɗo waɗani en ley kawtal meeɗen e Joomiraaɗo men Iisaa Almasiihu. ");
INSERT INTO fuhbkf_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Wo goonga kaalammi miin kawtuɗo e Almasiihu, mi fenataa. Ɓernde am nde Ruuhu Ceniiɗo ɗowata ndeen, ina seedanoo kam miɗo haala goonga. ");
INSERT INTO fuhbkf_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","Ɓernde am ina woodi mettorgal cattungal, nde selataa naawude ");
INSERT INTO fuhbkf_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","saabe Alhuudiyankooɓe ɓeen. Mi jaɓanno laataade kuɗaaɗo mi seeda e Almasiihu miin e hoore am si ina nafannoo sakiraaɓe am ɓe kawtumi ƴuwdi ɓeen. ");
INSERT INTO fuhbkf_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Ɓeen ngoni Israa'iila'en. Laamɗo waɗi ɓe ɓiɓɓe muuɗum, holli ɓe teddeengal muuɗum. Kamɓe njeyi aadiiji ɗiin e Tawreeta Muusaa oon. Wo kamɓe Laamɗo anndini no ɓe ndewirta ɗum, kamɓe Laamɗo waɗani amaanaaji muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Kamɓe ƴuuri e maamiraaɓe Israa'iila arandeeɓe ɓeen. Almasiihu du, neɗɗaaku muuɗum ƴuuri e lenyol ngool. Jettooje ngoodanii Laamɗo tiimuɗo huunde fuu faa abada! Aamiina. ");
INSERT INTO fuhbkf_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Ɗum fuu wanaa wi'ude konngol Laamɗo ngool hunngake laataade. Sabo wanaa ƴuuruɓe e Israa'iila ɓeen fuu ngoni Israa'iilankooɓe, ");
INSERT INTO fuhbkf_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","wanaa ƴuuruɓe e Ibrahiima ɓeen fuu ngoni ɓiɓɓe muuɗum jaati. Sabo Laamɗo wi'ii Ibrahiima: «Wo faro Isiyaaka ƴuwdi maa hiisortee.» ");
INSERT INTO fuhbkf_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Inan ko ɗum yiɗi wi'ude: wanaa ɓiɓɓe Ibrahiima rimiraaɓe no yimɓe fuu ndimirtee nii ngoni ɓiɓɓe Laamɗo, ammaa wo rimiraaɓe saabe amaana ɓeen tiigoraa wo ƴuwdi makko. ");
INSERT INTO fuhbkf_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Sabo Laamɗo waɗii amaana e haalaaji ɗiin, wi'i, «Mi wartan e hono wakkati o mawuuri, de Saaratu heɓan ɓiɗɗo gorko.» ");
INSERT INTO fuhbkf_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Wanaa ɗum tan. Ndaaren no Rebeka hooƴiri reedu ɓiɓɓe ɗiɗo du. Baaba maɓɓe wo gooto, Isiyaaka, maami en oon. ");
INSERT INTO fuhbkf_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","12","Gilla ɓiɓɓe ɓeen ndimaaka sakko ɓe ngaɗa ko wooɗi naa ko boni, ndeen Laamɗo wi'i Rebeka: «Mawniiwo oon laatoto maccuɗo minyiiwo oon.» O waɗirii noon faa anniya makko dow suɓagol tabita. Suɓagol makko ngool yowaaki e golle yimɓe, wo e Laamɗo noddoowo oon ngol yowii. ");
INSERT INTO fuhbkf_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Wo noon Binndi ɗiin mbiiri: «Yaakuuba korsinmi, de Isuwa mbanyumi.» ");
INSERT INTO fuhbkf_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Ndelle, ɗume mbi'eten? Laamɗo wo oonyiiɗo naa? Kayto! Fay seeɗa! ");
INSERT INTO fuhbkf_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Inan ko o wi'i Muusaa: «Mi hinnoto mo muuyumi hinnaade, mi yurmoto mo muuyumi yurmaade.» ");
INSERT INTO fuhbkf_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Ndelle, suɓagol makko yowaaki e muuyɗe neɗɗo naa e tinnaare muuɗum, ammaa wo dow Laamɗo jurmotooɗo oon ngol yowii. ");
INSERT INTO fuhbkf_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Sabo e ley Binndi ɗiin, Laamɗo wi'ii Fira'awna: «Ko ngaɗirmaami kaananke dey, faa mi hollira baawɗe am e maaɗa, katin du faa innde am gooynee e adunaaru ndu fuu.» ");
INSERT INTO fuhbkf_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Ndelle, Laamɗo yurmoto mo muuyi, yoornan ɓernde mo muuyi. ");
INSERT INTO fuhbkf_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Ndelle on ƴaman kam: «Si wo noon worri fu, ɗume Laamɗo felirta yimɓe? Moy waawi salaade muuyɗe makko ɗeen?» ");
INSERT INTO fuhbkf_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Aan ɓii-Aadama oon, wo a moy faa njeddaa Laamɗo? Yalla loonde mahaande ina ƴama mahuɗo ɗum oon: «Ko waɗi de mahirɗaa kam ni?»? ");
INSERT INTO fuhbkf_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Mahoowo looɗe ina waawi waɗude e loope ɗeen ko yiɗi fuu: e loopal gootal o maha loonde gollirteende ko teddi, o maha wonnde du gollirteende ko heɓaa fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Wooɗi, fay si taweede Laamɗo muuyi ɓanginde tikkere muuɗum e baawɗe muuɗum, o munyanii ɓe o tikkani ɓeen munyal cattungal, ɗum woni haanduɓe e halkude ɓeen. ");
INSERT INTO fuhbkf_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","O waɗirii noon du faa o ɓangina keewal darja makko dow ɓe o yurmotoo ɓeen, ɓe o segilanii gilla ko ɓooyi faa ngonda e darja makko. ");
INSERT INTO fuhbkf_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Ɗum woni enen ɓe o noddi ɓeen. De wanaa e ley Alhuudiyankooɓe tan, wo e ley lenyi goɗɗi ɗiin du. ");
INSERT INTO fuhbkf_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Ɗum woni ko Laamɗo wi'i e annabi Hoseya: «Yimɓe ɓe nganaa yimɓe am, mi noddiran ɓe yimɓe am, yimɓe ɓe korsinaaka ɓeen, mi noddiran ɓe yimɓe am horsuɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Katin du, nokku ɗo ɓe mbi'etee ɓe nganaa yimɓe am, ɗoon ɓe inndiroytee ɓiɓɓe Laamɗo buurɗo.» ");
INSERT INTO fuhbkf_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Annabi Esaaya du haalii haala Israa'iilankooɓe, wi'i: «Fay si ɓiɓɓe Israa'iila keewiri no njaareendi maayo ni, seeɗa maɓɓe tan hisintee, ");
INSERT INTO fuhbkf_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","sabo Joomiraaɗo tabintinan konngol muuɗum dow adunaaru, hiɓɓinan ngol fuu law.» ");
INSERT INTO fuhbkf_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Katin du wo nii Esaaya wiirunoo gilla arande: «Sini Joomiraaɗo jom baawɗe fuu oon accidaayno en ƴuwdi, tawanno en laatake hono wuro Sodoma ni, en nanndii e wuro Gomoora.» ");
INSERT INTO fuhbkf_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Ndelle, ɗume mbi'eten? Inan ko mbi'eten: yimɓe ɓe nganaa Alhuudiyankooɓe ɓe pilaakino fonnditaare ɓeen, ɓe keɓii fonnditaare, ɗum woni fonnditaare saabe goonɗinal. ");
INSERT INTO fuhbkf_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Ammaa Israa'iilankooɓe pilorake fonnditaare e jokkugol Tawreeta, de ɓe keɓaay fonnditaare ndeen. ");
INSERT INTO fuhbkf_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Ko waɗi? Sabo ɓe piloraaki ɗum goonɗinal, wo e golle maɓɓe ɓe pilorii ɗum. Ndelle ɓe pergake e «hayre fergoore ndeen» ");
INSERT INTO fuhbkf_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","hono no Binndi ɗiin mbiiri ni: «Inan, mi joƴƴinan e Siyona hayre nde yimɓe pergotoo e muuɗum, tefaare liɓoore ɗum'en. De goonɗinɗo nde fuu semtintaake.» ");
INSERT INTO fuhbkf_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Sakiraaɓe, ko muuyumi ley ɓernde am e ko nyaagotoomi Laamɗo wo Israa'iilankooɓe kisinee. ");
INSERT INTO fuhbkf_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Miɗo seedanoo ɓe ɓe njinnganii Laamɗo sanne, de jinngi ɗiin ngaldaa e paamal. ");
INSERT INTO fuhbkf_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Ɓe paamaay fonnditaare nde Laamɗo hokkata ndeen, faa ɓe pilanii ko'e maɓɓe dabare laataade fonnditiiɓe. Ɗuum waɗi de ɓe ɗowtanaaki laawol ngol Laamɗo ndaardata neɗɗo wo ponnditiiɗo ngool. ");
INSERT INTO fuhbkf_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Sabo Almasiihu woni timmoode jamirooje Tawreeta faa goonɗinɗo ɗum fuu ndaardee ponnditiiɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Inan ko Muusaa winndi dow fonnditaare ƴuurunde e Tawreeta ndeen: «Neɗɗo gaɗoowo jamirooje Tawreeta, kam wuurdata saabe majje.» ");
INSERT INTO fuhbkf_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Ammaa inan ko haala Laamɗo wi'i dow fonnditaare ƴuurunde e goonɗinal ndeen: taa wi'u e ɓernde maa «Moy ƴeeŋata dow kammu?» Ɗum woni faa jippina Almasiihu, ");
INSERT INTO fuhbkf_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","naa «Moy yahata laakara?» Ɗum woni faa ummintina Almasiihu e hakkunde maayɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Ndelle, ɗume Binndi ɗiin mbi'i? «Konngol Laamɗo ina ɓadii ma, ingol woni e hunnduko maa, ingol woni e ɓernde maa.» Konngol ngool woni kabaaru goonɗinal ngal min mbaajotoo ngaal. ");
INSERT INTO fuhbkf_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Si a wi'ii e hunnduko maa Iisaa wo Joomiraaɗo, de a goonɗinii e ɓernde maa Laamɗo iirtinii mo e maayde fu, a hisinte. ");
INSERT INTO fuhbkf_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Sabo wo e ɓernde neɗɗo goonɗinta, de Laamɗo ndaardan ɗum ponnditiiɗo. Wo e hunnduko neɗɗo haaldata ko goonɗini, de Laamɗo hisina ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Wo hono Binndi ɗiin mbiiri: «Goonɗinɗo mo fuu semtintaake.» ");
INSERT INTO fuhbkf_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Joonin, walaa ko senndi Alhuudiyanke e mo wanaa Alhuudiyanke. Ɓe fuu Joomii ɓe wo gooto, kam woni kebbinoowo moƴƴereeji muuɗum e noddooɓe ɗum ɓeen fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Sabo «neɗɗo fuu nodduɗo innde Joomiraaɗo, hisinte.» ");
INSERT INTO fuhbkf_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Ammaa noy ɓe keɓirta noddude mo si ɓe ngoonɗinaay mo? Noy ɓe ngoonɗinirta mo si ɓe nanaay kabaaru makko? Noy ɓe nanirta kabaaru makko si baajotooɗo walaa? ");
INSERT INTO fuhbkf_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Noy yimɓe mbaajortoo du si nulaaka? Binndi ɗiin mbi'ii: «Ndaar, koyɗe jottinooje Kabaaru Lobbo na mbelna ɓernde koy!» ");
INSERT INTO fuhbkf_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","De wanaa yimɓe fuu njaɓani Kabaaru Lobbo oon. Annabi Esaaya wi'ii: «Joomiraaɗo, moy goonɗini waaju amin?» ");
INSERT INTO fuhbkf_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Ndelle goonɗinal ina ƴuura e nanude waaju, waaju du ina ƴuura e konngol Almasiihu. ");
INSERT INTO fuhbkf_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","De miɗo ƴama yalla Israa'iilankooɓe nanaay naa? Ɓe nanii koy! Aayaare wi'ii: «Daaɗe maɓɓe nanaama e adunaaru fuu, konngi maɓɓe njottake faa hoore leydi.» ");
INSERT INTO fuhbkf_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Miɗo ƴama katin: Israa'iilankooɓe paamaay naa? Gilla arande Muusaa winndii ko Laamɗo wi'i: «Mi waɗan faa kiron yimɓe ɓe nganaa ƴuwdi goongaari, mi waɗan faa tikkanon ƴuwdi ndi walaa hakkillo.» ");
INSERT INTO fuhbkf_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Ndeen kaa, annabi Esaaya hulaay wi'ude caggal ɗuum: «Yimɓe ɓe pilaakino kam ɓeen njiitii kam, yimɓe ɓe ƴamanaay kam ɓeen du, mi ɓanganii ɗum'en hoore am.» ");
INSERT INTO fuhbkf_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Ammaa to Israa'iila, Laamɗo wi'ii: «Fajiri faa futuro miɗo filoo jaɓɓaade yimɓe saliiɓe, sattuɓe.» ");
INSERT INTO fuhbkf_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Ndelle, miɗo ƴama yalla Laamɗo yoppii yimɓe muuɗum Israa'iilankooɓe ɓeen naa? O yoppaay! Sabo miin e hoore am wo mi Israa'iilanke, wo mi ƴuwdi Ibrahiima, wo e lenyol Benyamin njeyaami. ");
INSERT INTO fuhbkf_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Laamɗo yoppaay yimɓe muuɗum ɓe suɓinoo gilla arande ɓeen. Yalla on anndaa ko Binndi ɗiin mbi'i nde annabi Iliyaasa woyanannoo Israa'iilankooɓe ɓeen to Laamɗo naa? O wi'ii: ");
INSERT INTO fuhbkf_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","«Joomiraaɗo, ɓe mbarii annabaaɓe maa, ɓe kalkii kirsirɗe maa sadaka. Miin tan heddii, de iɓe ndaara no ɓe mbarda kam.» ");
INSERT INTO fuhbkf_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Ammaa ɗume Laamɗo jaabii mo? O wi'ii: «Mi resanii hoore am worɓe ujunaaje njeɗɗo ɓe cujidanaay tooru wi'eteendu Ba'al.» ");
INSERT INTO fuhbkf_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Hono noon, hakkunde yimɓe hannden ɓeen, ina woodi yimɓe seeɗa ɓe Laamɗo suɓorii saabe hinney muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","De si o suɓorake ɓe hinney fu, en anndan o suɓoraaki ɓe saabe golle maɓɓe. Si wo saabe golle maɓɓe fu, hinney Laamɗo oon heddataako laataade hinney katin. ");
INSERT INTO fuhbkf_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Ndelle, ɗume laatii? Ko laatii dey, Israa'iilankooɓe ɓeen keɓaay ko pilotonoo ɗuum, wo ɓe Laamɗo suɓii ɓeen ni keɓi ɗum. Heddiiɓe ɓeen, ɓerɗe muɓɓen njoornaa ");
INSERT INTO fuhbkf_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","hono no winndiraa ni: «Laamɗo uddii hakkillooji maɓɓe, wumnii gite maɓɓe, faaɗinii noppi maɓɓe. Faa hannden noon worri.» ");
INSERT INTO fuhbkf_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Daawda du wi'ii: «Wo rewugol maɓɓe bonngol ngool laatanoo ɓe tuugol faa ɓe njana ley maggol, laatanoo ɓe fergere faa ɓe njukkee. ");
INSERT INTO fuhbkf_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Wo gite maɓɓe niɓɓinee taa ɓe nji'a, wo ɓaawe maɓɓe turee faa abada!» ");
INSERT INTO fuhbkf_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Ndelle, miɗo ƴama: ko Alhuudiyankooɓe ɓeen pergii ɗuum, yalla wo faa ɓe caama faa abada naa? Wanaa koy! De wo saabe lutti maɓɓe ɗiin, yimɓe ɓe nganaa Alhuudiyankooɓe ɓeen keɓiri kisindam, faa Alhuudiyankooɓe ɓeen kira. ");
INSERT INTO fuhbkf_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Si lutti maɓɓe ɗiin laatanake yimɓe adunaaru barke, si mursey maɓɓe du laatanake ɓe nganaa Alhuudiyankooɓe ɓeen barke, barke oon ɓuran ɗum manngu sanne si Alhuudiyankooɓe ɓeen fuu tuubii. ");
INSERT INTO fuhbkf_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Joonin, wo onon yimɓe ɓe nganaa Alhuudiyankooɓe ɓeen kaaldammi: ko laatiimi nulaaɗo e mooɗon ɗuum, miɗo mantoroo gollal ngal kokkaami ngaal ");
INSERT INTO fuhbkf_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","de na hasii mi heɓan waddude kiram e ley lenyol am, faa mi hisina woɓɓe maɓɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Sabo si woɗɗineede Alhuudiyankooɓe waɗi de yimɓe adunaaru ndewrintinaa e Laamɗo fu, ɗume laatoytoo si ɓe njaɓɓowaama? Ɗum laatorto hono wo ɓe yaltuɓe e maayde! ");
INSERT INTO fuhbkf_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Si tamre arandeere sakkaama Laamɗo, tame keddiiɗe ɗeen du cakkaama. Si ɗaɗi lekki cakkaama Laamɗo, licce ɗeen du cakkaama. ");
INSERT INTO fuhbkf_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Joonin le, Israa'iilankooɓe ina nga'i hono no lekki jaytun ki licce muuɗum goɗɗe caltaa. Aan mo wanaa Alhuudiyanke nannduɗo e liccal jaytun laddeehi, a waddaama, a dobaama e jaytun kiin. Nii keɓirɗaa ngeɗu e ko ƴuurata e ɗaɗi jaytun kiin. Aɗa heɓa barke lekki kiin, aɗa mawnida e licce goɗɗe ɗeen. ");
INSERT INTO fuhbkf_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","Saabe majjum, taa mantoɗaa yeeso licce caltaaɗe ɗeen. De si aɗa mantoo fu, miccoɗaa wanaa aan wuurni ɗaɗi ɗiin, wo ɗaɗi ɗiin mbuurni ma. ");
INSERT INTO fuhbkf_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Ina wooɗi tawee aɗa wi'a: «Ko waɗi de licce ɗeen caltaa dey, wo faa miin mi naata, mi dobee ɗo.» ");
INSERT INTO fuhbkf_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Goonga! Ammaa ko ɗe caltiraa dey, wo rafi goonɗinal majje. Aan aɗa heddii e dobeede saabe goonɗinal maa. Ndelle, taa mawninkina, ammaa hulu. ");
INSERT INTO fuhbkf_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Sabo si Laamɗo accaay licce arandeeje ɗeen fu, accataa ma aan du. ");
INSERT INTO fuhbkf_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Ndelle, taykita moƴƴuki Laamɗo e tikkere muuɗum fuu: tikkere makko na woni e saamuɓe ɓeen, de moƴƴuki makko na woni e maaɗa sini aɗa tabiti e moƴƴuki kiin. Si wanaa ɗuum fu, aan du a saltete. ");
INSERT INTO fuhbkf_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Israa'iilankooɓe du, si ɓe njoppii salaare maɓɓe de ɓe ngoonɗini fu, Laamɗo nannan ɓe katin hono no licce ndobirtee e lekki. Sabo Laamɗo ina jogii baawɗe dobude ɓe e lekki kiin katin. ");
INSERT INTO fuhbkf_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Ndelle aan ƴuuruɗo e lekki laddeehi oon, si a saltaama e makki a dobaama e lekki jaytun aawaaki kiin, haala fuu walaa licce ƴuurɗe e lekki aawaaki kiin, si caltanooma ina mbaawi dobeede e inna muɓɓen. ");
INSERT INTO fuhbkf_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Sakiraaɓe, mi yiɗaa ndullon ko suuɗi ɗum ɗo, heɓa taa ndaardon ko'e mon wo on jom'en hakkillo: Israa'iilankooɓe laatake yoorɓe ɓerɗe, de ɗum timman wakkati siyiiji yimɓe ɓe nganaa Alhuudiyankooɓe fuu ngoonɗini, naati laamu Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Hono noon Israa'iilankooɓe ɓeen fuu kisinirtee, no Binndi ɗiin mbiiri ni: «Kisinoowo ƴuuran e Siyona, ittan luttal fuu e ƴuwdi Yaakuuba.» ");
INSERT INTO fuhbkf_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","«Ɗum woni amaana am e maɓɓe wakkati nde mooytammi hakkeeji maɓɓe.» ");
INSERT INTO fuhbkf_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Ko Alhuudiyankooɓe ɓeen njaɓaay Kabaaru Lobbo oon ɗuum, ɓe laatorii wayɓe Laamɗo, ammaa wo ɗum saabe mooɗon faa keɓon Kabaaru oon. De ko Laamɗo suɓii ɓe ɗuum, ɓe laatake ɓe o yiɗi saabe maamiraaɓe maɓɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Wo noon, sabo Laamɗo waylitataa anniya dow mo moƴƴinani dokke muuɗum, e dow mo noddi. ");
INSERT INTO fuhbkf_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Onon yimɓe ɓe nganaa Alhuudiyankooɓe, arande on calakeno Laamɗo, de joonin kaa on keɓii yurmeende saabe sattere Alhuudiyankooɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","Noon du, joonin wo ɓeen calii Laamɗo, de Laamɗo yurmii on. De ɗum laatake faa ɓeen du keɓa yurmeende makko. ");
INSERT INTO fuhbkf_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Sabo Laamɗo uddii yimɓe fuu e ley salaare, faa o yurmoo ɓe fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Hey barkeeji Laamɗo korsuɗi ina keewi! Hakkilantaaku makko e anndal makko ina luggi! Fay gooto waawaa anndude anniyaaji makko. Fay gooto waawaa faamude laabi no o gollirta. ");
INSERT INTO fuhbkf_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","Wo hono noon winndiraa: «Moy anndi miilooji Joomiraaɗo? Moy laatii tindinoowo ɗum?» ");
INSERT INTO fuhbkf_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","«Moy artii hokkude mo sakko o yoɓa ɗum?» ");
INSERT INTO fuhbkf_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Si goonga, huunde fuu e makko ƴuuri, huunde fuu wo kanko tiigii, huunde fuu wo kanko jeyi. Wo teddeengal woodan mo faa abada! Aamiina. ");
INSERT INTO fuhbkf_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Ndelle sakiraaɓe, miɗo nyaagoo on sanne saabe yurmeende Laamɗo, cakkee ko'e mon laatoɗon sadaka buurɗo, ceniiɗo, belɗo Laamɗo. Ɗum woni dewal ngal kaanɗon rewrude mo ngaal. ");
INSERT INTO fuhbkf_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Taa nyemmbitee adunaaru, ammaa accee Laamɗo heyɗintina hakkillooji mon faa ɓerɗe mooɗon mbaylitoo. Ndeen, on mbaawan anndude muuyɗe Laamɗo: ko wooɗi e ko weli mo e ko hiɓɓi. ");
INSERT INTO fuhbkf_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Saabe moƴƴere nde Laamɗo hokki kam ndeen, miɗo wi'a mono e mooɗon fuu: taa njaaree ko'e mooɗon to on njottaaki, ammaa ndaardon ko'e mon e miilooji hakkilantaaku, kawrooji e goonɗinal ngal Laamɗo etani on ngaal. ");
INSERT INTO fuhbkf_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Gooto e meeɗen fuu ina jogii terɗe keewɗe, de terɗe ɗeen fuu kawtaa golle. ");
INSERT INTO fuhbkf_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","Hono noon, enen e keewal meeɗen fuu, wo en neɗɗo gooto e ley kawtal meeɗen e Almasiihu. En fuu eɗen njeydaa no terɗe fuu njeydiraa e ɓanndu ni. ");
INSERT INTO fuhbkf_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","En kokkaama dokke ceeduɗe ɗe Laamɗo hokkiri en moƴƴere muuɗum. Si Laamɗo hokkii neɗɗo haaltude konngol ngol watti e muuɗum, haaltira ngol no fotiri e goonɗinal muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","Mo Laamɗo hokki dokkal wallude woɓɓe, o walla ɓe. Mo o hokki dokkal jannginde, o janngina. ");
INSERT INTO fuhbkf_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","Mo o hokki dokkal semmbinɗina yimɓe, o semmbinɗina ɗum'en. Mo o hokki dokkal moƴƴande woɓɓe du, o hokkira e yardaamuye. Mo o hokki dokkal ardaade, o ardoroo tinnaare. Mo o hokki dokkal yurmeende du, o yurmoroo woɓɓe e seyo. ");
INSERT INTO fuhbkf_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Njinngu mooɗon laatoo ngu waldaa e naafikaaku. Mbanyee ko boni, kaɓɓee e ko wooɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Njiɗunduree njinngu sakiraagu, mono fuu teddina banndum faa ɓurna ɗum hoore muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","Taa accee tinnitaare mon feewa. Ngollanon Joomiraaɗo e ɓerɗe mon fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","Mbeltee e ley jikke mooɗon, munyee torra, tinnee keddodoɗon e du'aare. ");
INSERT INTO fuhbkf_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","Mballee seniiɓe Laamɗo e haajuuji muɓɓen, laatee jaɓɓotooɓe weerɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Mbarkinee torrooɓe on. Mbarkinon ɓe, taa kuɗon ɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Ceyodee e seyiiɓe, mboydee e woyooɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Laatodee miilo wooto. Taa pilee manngu ammaa kawtee ko'e mon e lokkaaɓe. Taa tiigoree ko'e mon on jom'en hakkillo. ");
INSERT INTO fuhbkf_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Si goɗɗo waɗii on ko boni, taa njomnitee ɗum. Kakkilanee waɗude ko yimɓe fuu ndaarata na ŋarɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Si na laatoo, ngondiree e yimɓe fuu e jam. Piloɗon ɗum haddi no mbaawruɗon. ");
INSERT INTO fuhbkf_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Sakiraaɓe horsuɓe, taa njomnitanee ko'e mon. Ko kaanɗon waɗude dey, accee tikkere Laamɗo ndeen yomnitanoo on. Sabo e ley Binndi ɗiin Joomiraaɗo wi'ii: «Miin woni jomnitotooɗo, miin yoɓoyta ɓe.» ");
INSERT INTO fuhbkf_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","Ina winndaa katin: «Si ganyo ma yolbii fu, nyaamnaa ɗum, si ɗomɗii njarnaa ɗum. Si a waɗii nii fu, a waɗan o semta saabe ko o waɗi ko boni ɗuum.» ");
INSERT INTO fuhbkf_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Taa accu ko boni jaale, ammaa jaalora ko boni ɗuum e ko wooɗi. ");
INSERT INTO fuhbkf_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Mono fuu ɗowtanoo laamiiɓe, sabo laamu walaa si wanaa ƴuurungu to Laamɗo. Laamiiɓe fuu wo Laamɗo joƴƴini ɗum'en. ");
INSERT INTO fuhbkf_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Saabe ɗuum, neɗɗo fuu caliiɗo laamu leydi salake ko Laamɗo yamiri. Caliiɗo yamiroore Laamɗo du fooɗanan hoore muuɗum jukkungo. ");
INSERT INTO fuhbkf_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Gaɗoowo ko wooɗi walaa ko huldata hooreeɓe ɓeen, wo gaɗoowo ko boni hulata ɓe. Aɗa yiɗi tawee a hulataa laamiiɓe leydi naa? Ndelle, ngaɗaa ko wooɗi. Ndeen laamu yettete. ");
INSERT INTO fuhbkf_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","Sabo laamiiɓe wo gollanooɓe Laamɗo faa nafe. Ammaa si tawii wo ko boni ngaɗataa, kulaa, sabo wanaa ɓolum laamiiɓe mbakkorii kaafaahi. Wo ɓe gollanooɓe Laamɗo faa ɓe tabintina jukkungo muuɗum dow gaɗoowo ko boni fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Ndelle, tilay ɗowtanoɗon laamiiɓe ɓeen, wanaa saabe hulde jukkeede tan, ammaa faa taa ɓerɗe mon pela on du. ");
INSERT INTO fuhbkf_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Ɗum waɗi de oɗon njoɓa lampo, sabo laamiiɓe ɓeen wo gollanooɓe Laamɗo, hokkuɓe wakkatiiji muɓɓen fuu faa laamoo. ");
INSERT INTO fuhbkf_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Kokkee mono fuu ko jeyi hokkeede. Kokkee lampo mo kaanɗon hokkude lampo, kokkon tino mo kaanɗon hokkude tino. Kulon mo kaanɗon hulude, teddinon mo kaanɗon teddinde. ");
INSERT INTO fuhbkf_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Taa njoganee fay gooto nyamaande. Huunde wootere tan haani laataade nyamaande, ɗum woni yiɗundurde. Sabo jiɗɗo gondo muuɗum fuu, tabintinii jamirooje Tawreeta. ");
INSERT INTO fuhbkf_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","Oɗon anndi kaɗaaɗi ɗii ɗo: «Taa jeenu, taa waɗu war-hoore, taa wujju, taa muuyu ko a jeyaa». Kanji e jamirooje goɗɗe ɗeen fuu ina kawriti e yamiroore wootere. Ndeen woni: «Njiɗiraa gondo maa no njiɗirɗaa hoore maa ni.» ");
INSERT INTO fuhbkf_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Jiɗɗo gondo muuɗum waɗataa ɗum ko boni. Ndelle njinngu na tabintina Tawreeta oon. ");
INSERT INTO fuhbkf_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Taykee kujje ɗeen, sabo oɗon anndi wakkati mo ngonɗen e muuɗum. Wakkati mo kaanɗon finude oon yonii. Sabo joonin kisindam ɓuri ɓadaade en diina nde naatunoɗen e goonɗinal ndeen. ");
INSERT INTO fuhbkf_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","Jemma ɓadake timmude, nyalooma ɓattake. Ndelle, celen gollude golle nimre, kooƴen kaɓitirɗe annoora. ");
INSERT INTO fuhbkf_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","Mbuurden no haaniri, hono no wonɓe ley annoora nyalooma. Wanaa e ley fijirde bonnde e sulagol, wanaa e golleeji ɓalli tuunɗi e rafi semto, wanaa e pooɗundural e kiram. ");
INSERT INTO fuhbkf_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","Ɓornoree Joomiraaɗo meeɗen Iisaa Almasiihu hono no kaddungal ni, taa kilnee muuyɗe terɗe mooɗon, taa nyaamnon ɗe. ");
INSERT INTO fuhbkf_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","Njaɓɓee mo goonɗinal muuɗum lokkiɗi tawa on peldaay ɗum ko miilotoo. ");
INSERT INTO fuhbkf_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","Hasii goɗɗo ina woodi goonɗinal faa na waawi nyaamude huunde fuu, tawee goɗɗo du goonɗinal muuɗum ina lokkiɗi faa nyaamataa teewu. ");
INSERT INTO fuhbkf_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","Nyaamoowo teewu oon taa yawa mo nyaamataa teewu oon. Mo nyaamataa teewu oon taa fela nyaamoowo teewu oon, sabo Laamɗo jaɓɓake mo. ");
INSERT INTO fuhbkf_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","Aan, wo a moy faa pelaa gollanoowo goɗɗo? Yalla imo darii faa wooɗi naa o saamii, ɗum fuu wo donngal joomiiko. O daroto faa wooɗa du, sabo Joomiraaɗo ina woodi baawɗe jogaade mo faa o daroo. ");
INSERT INTO fuhbkf_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Hasii goɗɗo ina jogorii nyalaande wootere ina ɓuri goɗɗe teddude, tawee goɗɗo du ina jogorii nyalaaɗe fuu wo potu. Mono fuu tannyora ko miilotoo ɗum e ley hakkillo muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","Ɓurdinɗo nyalaande oon waɗirii ɗum saabe Joomiraaɗo. Katin du, nyaamoowo ko yiɗi fuu oon waɗirii ɗum saabe Joomiraaɗo, sabo imo yetta Laamɗo. Mo nyaamataa teewu oon du waɗirii ɗum saabe Joomiraaɗo, imo yetta Laamɗo kanko du. ");
INSERT INTO fuhbkf_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","Sabo fay gooto e meeɗen wuurantaa hoore muuɗum, katin du fay gooto e meeɗen maayantaa hoore muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","Si en mbuurii, wo Joomiraaɗo mbuuranɗen. Si en maayii du, wo Joomiraaɗo maayanɗen. Si en mbuurii naa si en maayii fu, wo Joomiraaɗo oon jeyi en. ");
INSERT INTO fuhbkf_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","Sabo Almasiihu maayii, de ummii e maayde faa laatoo Joomiraaɗo wuurɓe e maayɓe fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","Aan, ko waɗi de aɗa fela sakiike maa goonɗinɗo oon? Naa aan, ko waɗi de aɗa yawa sakiike maa goonɗinɗo oon? En fuu, en ndaroyto yeeso sarorde Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","Sabo ina winndaa: «Joomiraaɗo wi'ii: ‹Tannyoree, no tannyorɗon mi buurɗo: Koppi fuu kofanto kam, ɗemle fuu ceedoto miin woni Laamɗo.› » ");
INSERT INTO fuhbkf_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","Ndeen mono e meeɗen fuu jaabanto hoore muuɗum yeeso Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","Ɗum le, taa pelunduren hakkunde meeɗen katin. Kooƴee anniya reentaade e huunde fuu ko waawi fergude sakiike mon naa ko liɓata ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","Saabe kawtal am e Joomiraaɗo men Iisaa miɗo tannyori nyaamdu fuu e hoore muuɗum harmaa. Ammaa si neɗɗo miilii goɗɗum wo karmuɗum, ɗum harmanan ɗum kam kaa. ");
INSERT INTO fuhbkf_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","Si a torrii sakiike maa goonɗinɗo oon saabe ko nyaamuɗaa, a jokkaay laawol njinngu. Taa halku mo Almasiihu maayani dow ko nyaametee. ");
INSERT INTO fuhbkf_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","Ndelle, ko ndaarɗon na wooɗi ɗuum, tinnee taa woɓɓe mbonkoo on saabe majjum. ");
INSERT INTO fuhbkf_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","Sabo laamu Laamɗo wanaa kabaaru nyaamdu naa njaram, wo kabaaru fonnditaare e jam e seyo ley kawtal Ruuhu Ceniiɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","Golliranoowo Almasiihu hono noon fuu, welan Laamɗo, yimɓe du teddinan ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","Ndelle, piloɗen ko ɓeydata jam hakkunde meeɗen. Mono fuu filoo ko semmbinɗinta banndum ley goonɗinal. ");
INSERT INTO fuhbkf_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","Taa mbonnon golle Laamɗo saabe haala nyaamdu. Si goonga, nyaamdu fuu ina laaɓi, ammaa si nyaamdu ndu nyaamataa nduun ina ferga sakiike maa, nyaamude ndu wooɗaa. ");
INSERT INTO fuhbkf_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","Ko wooɗi dey, wo taa nyaamon teewu naa njaron doro, naa ngaɗon huunde fuu ko fergata sakiike mooɗon. ");
INSERT INTO fuhbkf_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","Huunde fuu ko ngoonɗinɗaa, njogoɗaa ɗum hakkunde maa e Laamɗo. Barke woodanii mo sikkitirtaa ko woni e hakkillo muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","Ammaa si neɗɗo waɗii sikki-sakka de nyaami fu, jukkete, sabo joomum nyaamiraay goonɗinal. Huunde fuu ko waldaa e goonɗinal wo luttal. ");
INSERT INTO fuhbkf_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","Enen selluɓe goonɗinal ɓeen, eɗen kaani wallude ɓe goonɗinal muɓɓen lokkiɗi ɓeen. Haanaa ngaɗen ko weli en tan. ");
INSERT INTO fuhbkf_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","Gooto e meeɗen fuu filoo ko welata gondo muuɗum, faa nafa ɗum, de semmbinɗina ɗum ley goonɗinal. ");
INSERT INTO fuhbkf_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","Sabo fay Almasiihu jokkaay mbelirka yonki muuɗum, ammaa laatake no winndiraa ni: «Mbonkaaji mbonkiiɓe ma ɗiin e am njani.» ");
INSERT INTO fuhbkf_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","Ko winndanoo arande e ley Binndi ɗiin ɗuum, winndaama faa janngina en. Iɗi kolla en munyal, iɗi cellina ɓerɗe men, faa keɓen tannyoral ley jikke men. ");
INSERT INTO fuhbkf_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","Laamɗo jom munyal, cellinoowo ɓerɗe oon, hokku on laataade jom'en miilo wooto hono no Iisaa Almasiihu anndiniri on ni. ");
INSERT INTO fuhbkf_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","Noon teddinirton Laamɗo e anniya gooto e daande wootere. Oon woni Baaba Iisaa Almasiihu Joomiraaɗo men. ");
INSERT INTO fuhbkf_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","Njaɓɓunduree no Almasiihu jaɓɓorii on ni, faa Laamɗo teddinee. ");
INSERT INTO fuhbkf_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","Miɗo wi'a on: Almasiihu warii gollani Alhuudiyankooɓe. Ko o gollani ɓe ɗuum hollitii Laamɗo wo koolniiɗo, sabo tabintinii amaanaaji ɗi waɗannoo maamiraaɓe maɓɓe ɗiin. ");
INSERT INTO fuhbkf_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","Wooɗi du, wo faa lenyi goɗɗi ɗiin teddina Laamɗo dow yurmeende muuɗum, hono no winndiraa: «Saabe ɗuum, mi yettete hakkunde lenyi, mi yimante faa teddina innde maa.» ");
INSERT INTO fuhbkf_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","Ina winndaa katin: «Onon lenyi, mbeltodee e yimɓe Joomiraaɗo ɓeen.» ");
INSERT INTO fuhbkf_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","Katin du: «Njettee Joomiraaɗo, onon lenyi fuu! Manee mo, onon siyiiji yimɓe fuu!» ");
INSERT INTO fuhbkf_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","Annabi Esaaya du wi'ii: «ƴuuruɗo e lenyol Yesa warowan, oon ummoytoo faa laamoo lenyi adunaaru. Ɗi njowan jikke majji e makko.» ");
INSERT INTO fuhbkf_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","Laamɗo jom jikke oon hebbin on seyo e jam fuu saabe ko ngoonɗinɗon mo, faa jikke mooɗon ɓeydoo heewude saabe baawɗe Ruuhu Ceniiɗo! ");
INSERT INTO fuhbkf_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","Sakiraaɓe am, miɗo tannyori oɗon keewi mbooɗirka, oɗon keewi anndal, katin du mono fuu na waawi tindinde banndum. ");
INSERT INTO fuhbkf_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","Ammaa ley ɓataaki ki miɗo suusi haalande on haalaaji goɗɗi faa laaɓa faa mi miccintina on ɗi. Mi haaldirii noon saabe moƴƴere nde Laamɗo hokki kam ");
INSERT INTO fuhbkf_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","laataade gollanoowo Iisaa Almasiihu e ley yimɓe ɓe nganaa Alhuudiyankooɓe. Ko mbaajotoomi Kabaaru Lobbo oon ɗuum wo gollal ceniingal faa ɓe nganaa Alhuudiyankooɓe ɓeen laatoo sadaka belɗo Laamɗo mo Ruuhu Ceniiɗo senini. ");
INSERT INTO fuhbkf_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","Ndelle, e kawtal am e Iisaa Almasiihu, miɗo waawi mantoraade golleeji ɗi ngollanmi Laamɗo ɗiin. ");
INSERT INTO fuhbkf_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","Sabo walaa fuu ko cuusumi haalude si wanaa ko baawɗe Almasiihu tabintini e ley golle am faa waddana ɓe nganaa Alhuudiyankooɓe ɓeen ɗowtanaade Laamɗo. O waɗii ɗum ley haala am e ley golle am, ");
INSERT INTO fuhbkf_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","e ley baawɗe maandeeji e kaayeefiiji, fuu dow baawɗe Ruuhu Laamɗo. Hono noon njottinirmi Kabaaru Lobbo haala Almasiihu oon nokkuuje fuu gilla Urusaliima e seraaji muuɗum faa leydi Illiriya. ");
INSERT INTO fuhbkf_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","Katin du, gilla arande anniya am wo waajaade Kabaaru Lobbo ɗo innde Almasiihu yottaakino, faa taa mi nyiɓa dow nyimngo neɗɗo goɗɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","De mi waɗa hono no winndiraa ni: «Ɓe kumpitaakano haala makko ɓeen nji'owan, ɓe nanaayno ɓeen du paamowan.» ");
INSERT INTO fuhbkf_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","Wo gollal waajaade ngaal haɗi kam warude to mooɗon kile keewɗe. ");
INSERT INTO fuhbkf_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","Joonin kaa, gollal ngaal huuɓii leyɗe ɗee ɗo. Katin du waɗii duuɓi keewɗi ko njiɗumi warude to mooɗon. ");
INSERT INTO fuhbkf_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","Miɗo yiɗi fantude to mooɗon si miɗo yaha Espanya. Si mi ndaarii on de ceyodiimi e mooɗon fu, oɗon mbaawi wallude kam e jahaangal am faa mi yottowoo toon. ");
INSERT INTO fuhbkf_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","De joonin kaa mi yahan Urusaliima faa mi walla seniiɓe wonɓe toon. ");
INSERT INTO fuhbkf_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","Sabo kawrite goonɗinɓe gonɗe Makedoniya e Akaya ɗeen anniyake hawrundurde mballa faa kokka talkaaɓe jeyaaɓe e seniiɓe Urusaliima ɓeen. ");
INSERT INTO fuhbkf_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","Ɓe anniyorii ɗum ɓerɗe belɗe, de na tilsani ɓe hono njobdi du. Sabo si Alhuudiyankooɓe ɓeen mballii lenyi goɗɗi ɗiin keɓa ngeɗu e barkeeji Ruuhu fu, lenyi ɗiin du ina kaani wallirde Alhuudiyankooɓe e kujje adunaaru. ");
INSERT INTO fuhbkf_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","Si mi yottinii ɗum, mi hokkii ɓe ko hawrunduraa ɗuum fu, mi yahan Espanya, mi fantan to mooɗon. ");
INSERT INTO fuhbkf_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","Miɗo anndi si mi warii to mooɗon fu, mi wardan e barke Almasiihu keewɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","Sakiraaɓe, saabe Joomiraaɗo meeɗen Iisaa Almasiihu e saabe njinngu ngu Ruuhu oon hokkata nguun, miɗo nyaagoo on sanne: kawton e am e ley du'aawuuji mooɗon to Laamɗo saabe am. ");
INSERT INTO fuhbkf_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","Ŋaaroɗon Laamɗo danna kam e yimɓe ɓe ngoonɗinaay wonɓe Yahuudiya ɓeen, katin du seniiɓe wonɓe Urusaliima ɓeen njaɓɓoo ballal ngal njaaranammi ɗum'en ngaal. ");
INSERT INTO fuhbkf_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","Hono noon, mi yottorto on e ɓernde welnde saabe muuyɗe Laamɗo, de keɓden powtiri seeɗa. ");
INSERT INTO fuhbkf_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","Laamɗo jom jam wondu e mooɗon, on fuu. Aamiina. ");
INSERT INTO fuhbkf_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","Miɗo haalana on kabaaru sakiike meeɗen debbo bi'eteeɗo Febe, gollanoowo kawrital goonɗinɓe gonngal ley Kankiriya oon. ");
INSERT INTO fuhbkf_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","Njaɓɓoroɗon mo ley innde Joomiraaɗo no seniiɓe ɓeen kaaniri njaɓɓoreede ni. Katin du mballee mo e huunde fuu ko o haajaa, sabo o wallii heewɓe, miin du o wallii kam. ");
INSERT INTO fuhbkf_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","Njowtanon kam Pirisilla e Akila, gollidooɓe e am golle Iisaa Almasiihu ɓeen. ");
INSERT INTO fuhbkf_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","Kamɓe nesi mursude yonkiiji maɓɓe faa ɓe ndanna yonki am. Wanaa miin tan yettata ɓe, kawrite goonɗinɓe ɓe nganaa Alhuudiyankooɓe ɗeen fuu ina njetta ɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","Njowtanon kam goonɗinɓe hawrooɓe ley suudu maɓɓe ɓeen fuu. Njowton Epaynetus, giɗo am korsuɗo oon. Kanko artii goonɗinde Almasiihu ley leydi Aasiya fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","Njowton Mariyama tampanɗo on sanne oon. ");
INSERT INTO fuhbkf_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","Njowton Andoronika e Yuniya, banndiraaɓe ɓe uddidanoomi e kasu ɓeen. Wo ɓe nulaaɓe anndaaɓe sanne, katin du kamɓe artii kam goonɗinde Almasiihu. ");
INSERT INTO fuhbkf_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","Njowton Ampiliyaatu mo korsinirmi saabe Joomiraaɗo oon. ");
INSERT INTO fuhbkf_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","Njowton Urbaanu, gollidoowo e meeɗen golle Almasiihu oon, kam e Estaaki giɗo am korsuɗo oon. ");
INSERT INTO fuhbkf_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","Njowton Apeles, tabintinaaɗo wo jokkuɗo Almasiihu e goonga. Njowton yimɓe galle Aristobul. ");
INSERT INTO fuhbkf_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","Njowton Herodiyon banndam oon. Njowton yimɓe galle Narsisi hawtuɓe e Joomiraaɗo ɓeen. ");
INSERT INTO fuhbkf_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","Njowton Tirifena e Tirifosa, rewɓe gollanooɓe Joomiraaɗo ɓeen. Njowton Persis mo korsinmi, oon wo debbo tampuɗo sanne e ley gollande Joomiraaɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","Njowton Rufus mo Joomiraaɗo suɓii oon. Njowton inniiko mo ndaardumi wo inna am ni, miin du. ");
INSERT INTO fuhbkf_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","Njowton Asinkiriti e Felegon e Hermes e Patorooba e Hermasa e goonɗinɓe Iisaa wonduɓe e maɓɓe ɓeen. ");
INSERT INTO fuhbkf_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","Njowton Filoloogu e Yuliya, njowton Nere e sakiikem debbo, kam e Olimpa. Njowton seniiɓe wonduɓe e maɓɓe ɓeen fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","Jowtunduron e jowtaali ceniiɗi. Kawrite goonɗinɓe Almasiihu fuu ina njowta on. ");
INSERT INTO fuhbkf_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","Sakiraaɓe, miɗo ŋaaroo on sanne, kakkilon e waddooɓe ceedaagu. Iɓe perga yimɓe sabo ɓe calake jannde nde keɓuɗon ndeen. Mboɗɗee ɓe! ");
INSERT INTO fuhbkf_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","Sabo yimɓe wa'uɓe hono noon ngollantaa Joomiraaɗo meeɗen Almasiihu. Ko ɓe ngollanta dey, wo deedi maɓɓe. Wo e haalaaji maɓɓe belɗi e manooje maɓɓe jaayɗe ɓe majjinirta hakkillooji yimɓe ɓe anndaa ɓeen. ");
INSERT INTO fuhbkf_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","Onon le, kabaaru ɗowtaare mooɗon yottake yimɓe fuu. Saabe ɗuum miɗo weltoroo on, de miɗo muuyani on laatoɗon jom'en hakkillo e dow ko wooɗi, laatoɗon ɓe ngalaa feloore du e dow ko boni. ");
INSERT INTO fuhbkf_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","Laamɗo jom jam oon waɗan niison Seyɗaani ley teppe mooɗon ko ɓooyataa. Hinney Joomiraaɗo meeɗen Iisaa wondu e mooɗon. ");
INSERT INTO fuhbkf_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","Timote gollidoowo e am oon ina jowta on. Lukiyus e Yason e Sosipatoro banndiraaɓe am ɓeen ina njowta on. ");
INSERT INTO fuhbkf_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","Miin, Tertiyu, binndanɗo Pool ɓataaki ki oon, miɗo jowta on saabe kawtal meeɗen e Joomiraaɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","Gayus, beero am mo kawrital goonɗinɓe ngaal hawrata galle muuɗum oon, ina jowta on. Erasta kalfinaaɗo kaalisi ngalluure nde oon ina jowta on, kam e Kuwartus sakiike meeɗen oon.  ");
INSERT INTO fuhbkf_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","Jettooje ngoodanii Laamɗo baawɗo semmbinde on fodde Kabaaru Lobbo haala Iisaa Almasiihu mo mbaajiimi oon. Kabaaru Lobbo oon wo ɓangugol sirri Laamɗo cuuɗanooɗo gilla arande ");
INSERT INTO fuhbkf_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","de joonin o ɓanginaama. Dewte annabaaɓe anndinii ɗum lenyi ɗiin fuu no Laamɗo duumiiɗo oon yamiri ni, faa ɗi ngoonɗina Laamɗo, ɗi ɗowtanoo ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","Laamɗo kam tan woni hakkilanteejo. Teddeengal woodan mo faa abada saabe Iisaa Almasiihu. Aamiina.");
INSERT INTO fuhbkf_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","Ɓataaki ki to amin ƴuuri, miin Pool, e sakiike meeɗen Sosteni. Miin Pool, mi noddaaɗo saabe muuyɗe Laamɗo faa mi laatoo nulaaɗo Iisaa Almasiihu. ");
INSERT INTO fuhbkf_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","Miɗen njowta kawrital goonɗinɓe Laamɗo gonngal ngalluure Korintu. Laamɗo noddii on faa laatoɗon yimɓe muuɗum seniiɓe, seniraaɓe kawtal Iisaa Almasiihu. O noddii on, onon e noddooɓe innde Joomiraaɗo meeɗen Iisaa Almasiihu ɗo tawaa fuu. Oon woni Joomiraaɗo maɓɓe, wo Joomiraaɗo meeɗen du. ");
INSERT INTO fuhbkf_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","Wo Laamɗo Baaba meeɗen e Joomiraaɗo men Iisaa Almasiihu kokku on moƴƴere e jam. ");
INSERT INTO fuhbkf_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","Miɗo yetta Laamɗo saabe mooɗon wakkati fuu ko hokki on moƴƴere muuɗum ley kawtal Iisaa Almasiihu. ");
INSERT INTO fuhbkf_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","Si goonga, ley kawtal muuɗum on keɓii ko wooɗi fuu e ley haala e ley anndal fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","Seedaaku amin haala Almasiihu tabitii e mooɗon jaati. ");
INSERT INTO fuhbkf_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","Ɗum waɗi de on nyakiraaka dokkal Laamɗo fay gootal e ley ko keɗiɗon gartol Joomiraaɗo meeɗen Iisaa Almasiihu. ");
INSERT INTO fuhbkf_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","Kam hokkata on semmbe faa ɗo adunaaru haaɗi, yalla oɗon laatoo ɓe ngalaa feloore nyannde gartol Joomiraaɗo men Iisaa Almasiihu. ");
INSERT INTO fuhbkf_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","Laamɗo noɗɗuɗo on faa kawton e Ɓiyum Iisaa Almasiihu Joomiraaɗo meeɗen wo koolniiɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","Sakiraaɓe, miɗo nyaagoo on sanne e innde Joomiraaɗo men Iisaa Almasiihu: tiigunduree, laatoɗon daande wootere. Taa peccoɗon, ammaa laatoɗon jogiiɓe hakkillo wooto e anniya gooto faa hiɓɓi. ");
INSERT INTO fuhbkf_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","Sakiraaɓe am, si goonga mi narrii yimɓe suudu Kolowe pooɗundural ina woni hakkunde mooɗon. ");
INSERT INTO fuhbkf_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","Ko njiɗumi wi'ude dey, woɓɓe mooɗon ina mbi'a wo Pool ngoodani, woɓɓe ina mbi'a wo Apolos ngoodani, woɓɓe du ina mbi'a wo Piyeer ngoodani, woɓɓe katin du ina mbi'a wo Almasiihu ngoodani. ");
INSERT INTO fuhbkf_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","Yalla Almasiihu wo pecciiɗo naa? Yalla wo Pool maayani on dow leggal palaangal naa? Wo e innde Pool lootiraɗon lootagal batisima naa? ");
INSERT INTO fuhbkf_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","Miɗo yetta Laamɗo ko mi lootaay fay gooto mooɗon lootagal batisima, si wanaa Kirispus e Gayus. ");
INSERT INTO fuhbkf_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","Hono noon, fay gooto waawaa wi'ude wo e innde am lootiraɗon lootagal batisima. ");
INSERT INTO fuhbkf_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","Ayyo, goonga, mi batisiino katin du galle Estefaana. Ko faltii ɗum, mi anndaa yalla mi batisii goɗɗo katin. ");
INSERT INTO fuhbkf_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","Sabo Almasiihu nulaay kam mi batisa. Ko o nuldi kam dey, mi haala Kabaaru Lobbo oon, tawa wanaa dow haalaaji am nyeenyuɗi ɗum jooɗii, faa taa maayde makko dow leggal palaangal ndeen laatoo ɓolum. ");
INSERT INTO fuhbkf_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","Si goonga, haala maayde Iisaa dow leggal palaangal wo puuyndam to halkooɓe ɓeen, ammaa to meeɗen enen hisinteeɓe ɓeen, wo ka baawɗe Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","Sabo ina winndaa: «Mi bonnan hakkilantaaku jom'en hakkillo, paamal faamuɓe du, mi jiiɓan ngal.» ");
INSERT INTO fuhbkf_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","Ndelle won ko jom hakkillo woni naa? Won ko jannginoowo Tawreeta woni naa? Won ko baawɗo haala e jamaanu o woni naa? Walaa, sabo Laamɗo waylitii hakkilantaaku adunaaru ndu, waɗi ɗum puuyndam. ");
INSERT INTO fuhbkf_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","Yimɓe adunaaru ndu e hakkilantaaku muɓɓen fuu annditaay no Laamɗo holliri hoore muuɗum e ley hakkilantaaku mum. Ɗuum waɗi de Laamɗo muuyi hisinirde goonɗinɓe ɗum ɓeen e waaju amin nannduɗo e puuyndam oon. ");
INSERT INTO fuhbkf_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","Alhuudiyankooɓe ina piloo kaayeefiiji, Geresankooɓe du ina njiɗi hakkilantaaku. ");
INSERT INTO fuhbkf_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","De enen kaa, kabaaru tonteede Almasiihu e leggal palaangal mbaajotoɗen. To Alhuudiyankooɓe wo ɗum haala cemtiniika mettuka, to lenyi goɗɗi du wo ɗum puuyndam. ");
INSERT INTO fuhbkf_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","Ammaa to yimɓe ɓe Laamɗo noddi ley Alhuudiyankooɓe e ley lenyi goɗɗi, Almasiihu wo baawɗe Laamɗo, wo hakkilantaaku Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","Sabo ko nanndi e puuyndam Laamɗo ɗuum ina ɓuri hakkilantaaku ɓiɓɓe-Aadama. Katin du ko nanndi e lokkaaku Laamɗo ɗuum ina ɓuri semmbe ɓiɓɓe-Aadama. ");
INSERT INTO fuhbkf_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","Ndaaree ko'e mooɗon, onon sakiraaɓe ɓe Laamɗo noddi: ɓe yimɓe njogorii wo jom'en hakkillooji keewaa e ley mooɗon, jom'en baawɗe keewaa e ley mooɗon, ƴuuruɓe e lenyi tedduɗi du keewaa e ley mooɗon. ");
INSERT INTO fuhbkf_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","Ammaa Laamɗo suɓake ko adunaaru jogorii wo puuyndam faa huyfina jom'en hakkillo ɓeen. Laamɗo suɓake ko adunaaru jogorii wo lokkaaku faa huyfina ko jogii semmbe. ");
INSERT INTO fuhbkf_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","O suɓake ko hoyi, ko yawnii, ko adunaaru ndu jogorii wo ɓolum ɗuum, faa o waɗa ko tayketee ɗuum laatoo ɓolum. ");
INSERT INTO fuhbkf_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","O waɗii ɗum taa fay gooto mantoo yeeso makko. ");
INSERT INTO fuhbkf_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","Kanko hawti on e Iisaa Almasiihu. Kam laatanii en hakkillo ƴuurungo to Laamɗo, laatanii en fonnditaare e senaare e rimɗineede. ");
INSERT INTO fuhbkf_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","Wo hono nii faa ko Binndi ɗiin mbi'i ɗuum laatoo: «mantotooɗo fuu mantoroo Joomiraaɗo.» ");
INSERT INTO fuhbkf_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","Sakiraaɓe, miin du, nde ngarnoomi to mooɗon faa mi waajoo on goonga Laamɗo tedduɗo ndeen, mi waajoraaki on haalaaji nyeenyal, mi waajoraaki on hakkilantaaku yimɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","Sabo mi anniyakeno mi waajataako on fay huunde si wanaa haala Iisaa Almasiihu e tonteede muuɗum dow leggal palaangal. ");
INSERT INTO fuhbkf_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","Nde ngondunoomi e mooɗon ndeen, miɗo lokkiɗi, miɗo huli sanne faa miɗo diwna. ");
INSERT INTO fuhbkf_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","Haala am e waaju am yowaaki dow nyeenyal haala nanngooha hakkillo. Ko ɗum yowinoo dow muuɗum dey, wo baawɗe ɗe Ruuhu Ceniiɗo hollata ɗeen, ");
INSERT INTO fuhbkf_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","taa goonɗinal mon yowoo dow hakkilantaaku yimɓe, ammaa yowoo dow baawɗe Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","De si goonga, wo hakkilantaaku min mbaajotoo hakkunde mawnuɓe e ley goonɗinal. Wanaa hakkilantaaku adunaaru ndu min mbaajotoo, maa hakkilantaaku jom'en baawɗe halketeeɓe e ley jamaanu o. ");
INSERT INTO fuhbkf_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","Wo hakkilantaaku Laamɗo min mbaajotoo. Hakkilantaaku nguun wo goonga tedduɗo cuuɗaaɗo yimɓe mo Laamɗo fodanii en gilla adunaaru tagaaka faa teddineɗen. ");
INSERT INTO fuhbkf_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","Fay gooto e laamiiɓe adunaaru ɓeen faamanaay hakkilantaaku nguun, sabo sini ɓe paamaniino ɗum fu, ɓe tontataano Joomiraaɗo tedduɗo oon. ");
INSERT INTO fuhbkf_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","Ammaa ɗum laatake hono no winndiraa: «Yitere fuu yi'aay, nowru fuu nanaay, ɓernde fay gooto miilaaki, ko Laamɗo moƴƴinani yiɗuɓe ɗum.» ");
INSERT INTO fuhbkf_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","Enen kaa, Laamɗo hollirii en ɗum Ruuhu muuɗum. Ruuhu oon ina tiima huunde fuu, fay ko luggi to Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","Moy waawi anndude miilooji neɗɗo si wanaa yonki ngonki e muuɗum kiin? Hono noon du, fay gooto anndaa miilooji Laamɗo si wanaa Ruuhu muuɗum oon. ");
INSERT INTO fuhbkf_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","Enen le, en keɓii Ruuhu, de wanaa to adunaaru o ƴuuri, wo to Laamɗo o ƴuuri. En keɓii ɗum faa paamen moƴƴere nde Laamɗo waɗani en ndeen fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","Si miɗen mbaajoo ɗum, min mbaajortaako haalaaji ɗi hakkilantaaku ɓiɓɓe-Aadama kokkata min. Ammaa min mbaajorto haalaaji ɗi Ruuhu oon hokkata min. Miɗen piirtira goongaaji Ruuhu ɗiin e haalaaji ɗi hokkata ɗiin. ");
INSERT INTO fuhbkf_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","Ammaa mo heɓaay Ruuhu Laamɗo oon jaɓataa kulle Ruuhu ɗeen, sabo wo ɗe puuyndam to muuɗum. O waawaa faamude ɗe, sabo Ruuhu oon tan waawi hollude no kulle ɗeen carortee. ");
INSERT INTO fuhbkf_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","De neɗɗo keɓuɗo Ruuhu oon ina waawi saraade huunde fuu ley hakkillo mum, de fay gooto waawaa saraade ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","Wo hono no Binndi ɗiin mbiiri: «Moy anndi miilooji Joomiraaɗo? Moy waawi jannginde ɗum?» De enen kaa, eɗen ngoodi miilo Almasiihu. ");
INSERT INTO fuhbkf_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","Miin kaa, sakiraaɓe, mi waawaay haalirande on hono no kaaldirammi e jogiiɓe Ruuhu Ceniiɗo ni. Ammaa mi haaldiranii on hono wo on jokkuɓe muuyɗe terɗe, hono wo on cukaloy keccoy e ley goonɗinal Almasiihu. ");
INSERT INTO fuhbkf_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","Wo ɓiraaɗam kokkumi on, wanaa nyaamdu tekkundu, sabo on mbaawanaano ndu. Fay joonin du, on mbaawanaa ndu, ");
INSERT INTO fuhbkf_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","sabo wo muuyɗe terɗe mon tan njokkuɗon tafon. Ko kirundural bonngal e kalala woni hakkunde mooɗon ɗuum, wanaa ɗuum ina holla wo muuyɗe terɗe njokkuɗon naa? Ayyo, oɗon laatii hono jokkuɓe adunaaru tan. ");
INSERT INTO fuhbkf_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","Si gooto mooɗon wi'ii Pool heedani, goɗɗo katin wi'ii Apolos heedani, wanaa ɗum ina holla miilooji adunaaru ndu njokkuɗon naa? ");
INSERT INTO fuhbkf_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","Ɗume Apolos woni? Ɗume Pool woni? Min gollanooɓe Laamɗo tan, yaarooɓe on to goonɗinal. Mono fuu gollii ko Joomiraaɗo hokki ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","Miin, mi aawii, Apolos du wiccii, ammaa Laamɗo woni mawninoowo. ");
INSERT INTO fuhbkf_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","Hono noon, aawuɗo oon e jarnuɗo oon fuu nganaa fay huunde. Laamɗo mawninoowo oon tan woni baawɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","Aawuɗo e jarnuɗo fuu potu. Mono e muɓɓen fuu barjete ko fotata e tampiri muuɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","Sabo minen, min gollidooɓe e Laamɗo. Onon wo on ngesa Laamɗo, wo on nyimngo Laamɗo. ");
INSERT INTO fuhbkf_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","E dow moƴƴere nde Laamɗo waɗani kam ndeen, mi wasii joƴƴinirde hono no nyiɓoowo jom hakkillo waɗata ni. Joonin goɗɗo ina nyiɓa e dow mayre. Ammaa mono fuu hakkila no nyimrata. ");
INSERT INTO fuhbkf_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","Fay gooto waawaa wasude joƴƴinirde wonnde, sabo arandeere ndeen tabitii. Kayre woni Iisaa Almasiihu. ");
INSERT INTO fuhbkf_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","Wooɗi, neɗɗo na waawi nyiɓude dow joƴƴinirde ndeen kaŋŋe naa cardi naa kaaƴe dime. Imo waawi nyiɓude leɗɗe naa huɗo naa ƴommbe. ");
INSERT INTO fuhbkf_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","De mono fuu, golle muuɗum ɓanginte nyannde gartol Almasiihu. Sabo ndeen, yiite ɓanginan golle mono fuu, hollan no golleeji ɗiin ngorri. ");
INSERT INTO fuhbkf_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","Mo golle muuɗum heddii ina darii dow joƴƴinirde ndeen, heɓan mbarjaari. ");
INSERT INTO fuhbkf_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","Ammaa mo yiite ngeen nyaami golle muuɗum, waasii mbarjaari mum. Kam e hoorem kaa hisinte, de na wa'i hono peƴƴitinɗo yiite ni. ");
INSERT INTO fuhbkf_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","Yalla on anndaa wo on suudu Laamɗo, wooɗi Ruuhu Laamɗo oon ina woni e mooɗon naa? ");
INSERT INTO fuhbkf_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","Ndelle, neɗɗo fuu kalkuɗo suudu Laamɗo nduun, Laamɗo halkan ɗum. Sabo suudu Laamɗo nduun wo seniindu. Wooɗi, onon ngoni suudu nduun. ");
INSERT INTO fuhbkf_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","Taa fay gooto hiila hoore muuɗum. Si goɗɗo mooɗon miilake ina jogii ko yimɓe adunaaru ndaardata wo hakkillo ɗuum, joomum laatoo puuyɗo, faa heɓa hakkillo jaati. ");
INSERT INTO fuhbkf_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","Sabo hakkilantaaku e adunaaru ndu wo puuyndam yeeso Laamɗo. Wo hono noon winndiraa: «Laamɗo nanngiran jom'en hakkillo ɓeen caral muɓɓen.» ");
INSERT INTO fuhbkf_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","Ina winndaa katin: «Joomiraaɗo ina anndi miilooji jom'en hakkillo ɓeen, wo ɗi ɓoli.» ");
INSERT INTO fuhbkf_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","Ndelle, taa fay gooto mantoroo yimɓe, sabo si goonga onon njeyi huunde fuu: ");
INSERT INTO fuhbkf_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","Pool e Apolos e Piyeer, e adunaaru ndu, e nguurndam e maayde e ko woni joonin e ko warata - fuu onon njeyi. ");
INSERT INTO fuhbkf_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","Onon du, Almasiihu jeyi on. Almasiihu du, Laamɗo jeyi ɗum. ");
INSERT INTO fuhbkf_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","Ndelle, njogoree min wo min gollanooɓe Almasiihu, halfinaaɓe goongaaji Laamɗo cuuɗiiɗi ɗiin. ");
INSERT INTO fuhbkf_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","Wooɗi, halfinaaɓe, ina haani tawee wo hoolniiɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","Miin e hoore am, si on pelii kam, naa si mi darnaama e sarorde ɓiɓɓe-Aadama wi'ooɓe mi wanaa koolniiɗo fu, walanaa kam baasi. Mi sarataako hoore am du. ");
INSERT INTO fuhbkf_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","Si goonga ni, ɓernde am feldaay kam fay huunde. Ammaa wanaa ɗuum waɗata kam ponnditiiɗo. Wo Joomiraaɗo, kam sarotoo kam. ");
INSERT INTO fuhbkf_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","Ndelle, taa caree fay gooto illa wakkati oon yottaaki, illa Joomiraaɗo waraay. Kam yaltinta ko suuɗinoo e nimre, kam ɓanginta anniyaaji ɓerɗe yimɓe. Nyannde ndeen, mono fuu heɓan to Laamɗo jettooje ɗe foti heɓude. ");
INSERT INTO fuhbkf_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","Sakiraaɓe, ko mbiimi dow amin, miin e Apolos, wo saabe mooɗon. Wo faa min ekintina on maanaa haala ka: «Taa ndiwton ko winndaa». Ndeen on mawnintaa neɗɗo gooto e dow heddiiɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","Moy ɓurni on woɓɓe? Ko njogiɗon ɗuum, wanaa Laamɗo hokki on? Si wo noon worri, ko waɗi de oɗon mantoroo ɗum hono ɗum wanaa dokkal Laamɗo? ");
INSERT INTO fuhbkf_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","Woy on kaarii, woy on keɓii jawdi! On laatake laamiiɓe, de ɗum fuu, min laamaaki! Haya, miɗen njiɗi laamoɗon jaati, faa minen du min laamodoo e mooɗon! ");
INSERT INTO fuhbkf_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","Sabo miɗo miilii, minen nulaaɓe, Laamɗo heedinii min caggal hono no saraaɓe sariya wareede ni. Min laatake fijirteeɓe yeeso adunaaru ndu fuu: yeeso maleyka'en e yimɓe fuu. ");
INSERT INTO fuhbkf_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","Minen, wo min fuuyɓe saabe Almasiihu, de onon kaa, wo on jom'en hakkillo ley kawtal Almasiihu. Minen, wo min lokkaaɓe, de onon, wo on jom'en semmbe. Onon, on teddinaaɓe, de minen, min huyfinaaɓe. ");
INSERT INTO fuhbkf_vpl VALUES ("C14_11","076_4_11","1CO","4","11