﻿USE sofia;
DROP TABLE IF EXISTS sofia.fuh_vpl;
CREATE TABLE fuh_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES fuh_vpl WRITE;
INSERT INTO fuh_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ɗum woni inɗe maamiraaɓe Iisa *Almasiihu, jippotooɗo he Daawda e *Ibrahim : ");
INSERT INTO fuh_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","*Ibrahim rimi Isiyaaku. Isiyaaku rimi Yakuuba. Yakuuba rimi *Yahuuda he rimdaaɓe muuɗum. ");
INSERT INTO fuh_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","*Yahuuda he deekum Tamar ndimi Fares he Jara. Fares rimi Hesruuna. Hesruuna rimi Aram. ");
INSERT INTO fuh_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram rimi Aminadaabu. Aminadaabu rimi Naason. Naason rimi Salmon. ");
INSERT INTO fuh_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon he deekum Rahab ndimi Bo'as. Bo'as he deekum Ruut ndimi Obed. Obed rimi Yesa. ");
INSERT INTO fuh_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yesa rimi laamiiɗo Daawda. Daawda he dee-Uriya mo o teetunoo Uriya ndimi Suleymaanu. ");
INSERT INTO fuh_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Suleymaanu rimi Robo'am. Robo'am rimi Abiya. Abiya rimi Asa. ");
INSERT INTO fuh_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa rimi Yusufat. Yusufat rimi Yoram. Yoram rimi Ujiya. ");
INSERT INTO fuh_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ujiya rimi Yotam. Yotam rimi Akas. Akas rimi Hejekiya. ");
INSERT INTO fuh_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hejekiya rimi Manasa. Manasa rimi Amon. Amon rimi Yusiya. ");
INSERT INTO fuh_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Nder jamaanu mo Isra'el honaa faa *Yahudankooɓe njaaraa leydi *Baabiila, Yusiya rimi Yekuniya he rimdaaɓe muuɗum. ");
INSERT INTO fuh_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Nder jonnde maɓɓe nder *Baabiila, Yekuniya rimi Salaatiyel. Salaatiyel rimi Jorobaabiila. ");
INSERT INTO fuh_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Jorobaabiila rimi Abihuda. Abihuda rimi Eliyakim. Eliyakim rimi Ajoro. ");
INSERT INTO fuh_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ajoro rimi Sadok. Sadok rimi Akim. Akim rimi Eliyuda. ");
INSERT INTO fuh_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliyuda rimi Eliyajaaru. Eliyajaaru rimi Maatan. Maatan rimi Yakuuba. ");
INSERT INTO fuh_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakuuba rimi Yusufu, jom ɓaade Mariyaama. Mariyaama woni inna Iisa bi'eteeɗo *Almasiihu. ");
INSERT INTO fuh_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Hakkune *Ibrahim he Daawda walaana jamanuuji sappo he nay. Hakkune jamaanu Daawda warde jamaanu mo Isra'el honaa faa *Yahudankooɓe njaaraa leydi *Baabiila walaana jamanuuji sappo he nay. Hakkune jamaanu mo Isra'el honaa faa *Yahudankooɓe njaaraa leydi *Baabiila warde jamaanu *Almasiihu walaana jamanuuji sappo he nay. ");
INSERT INTO fuh_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","No Iisa *Almasiihu wardi duuniyaaru nii : Mariyaama inna Iisa no nannganaaɗo Yusufu non. Amma fadde makko ɓaŋeede, tawi o saawi nder baawɗe *Ruuhu Ceniiɗo. ");
INSERT INTO fuh_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yusufu mo o nannganaa oon no dartiiɗo, o hiɗaa semtinde mo yeeso himɓe fuu. Nden o anniyi faasitaade kaɓɓal ngaal nder cuccukka. ");
INSERT INTO fuh_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Amma wakkati o wonnoo omo miiloo ɗum ndeen, sey maleykaajo Joomiraawo gom wanngani mo nder koyɗol, wi'i mo : —Yusufu, taan Daawda, taa hulu ɓaŋude Mariyaama, ngam ɓinngel ngel reedu mum o saawi ngeel he *Ruuhu Ceniiɗo ngel ƴuwi. ");
INSERT INTO fuh_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","O riman ɓiɗɗo gorko, inndiraa mo Iisa. Kanko hisinta himɓe makko he hakkeeji mum'en. ");
INSERT INTO fuh_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ɗum fuu, ɗum waɗi ngam humnude haala ka Alla lilunoo annabiijo gom wi'a himɓe : ");
INSERT INTO fuh_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Surbaajo mo anndaa gorko saawan, nden rima ɓiɗɗo gorko. O innditiree Imanuwel. Maana innde ndee woni : « Alla no wondi he meeɗen ». ");
INSERT INTO fuh_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Wakkati Yusufu finunoo, o waɗi ko maleykaajo Joomiraawo oon wi'unoo mo ɗum. O ɓaŋi Mariyaama, ");
INSERT INTO fuh_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","dey o hawtaay he makko naako o rimi ɓiɗɗo gorko oon. Yusufu inndiri mo Iisa. ");
INSERT INTO fuh_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Iisa rimaama Baytilaama, leydi Yahudiya nder jamaanu laamiiɗo *Hirudus. Wakkati mum jom'en anndal gom ƴuwi lettugal, ngari *Ursaliima, ");
INSERT INTO fuh_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","mbi'i : —Toy laamiiɗo *Yahudankooɓe dimaaɗo joonin oon woni ? Min ngi'ii hoodere makko wanngi har lettugal, min ngari sujidande mo. ");
INSERT INTO fuh_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Wakkati laamiiɗo *Hirudus nanunoo habaru oon, ɗum wemmbii mo, kanko he himɓe *Ursaliima fuu. ");
INSERT INTO fuh_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Sey o noddi mawɓe *cakkanooɓe Alla he jannginooɓe *Tawreeta. Ɓe fuu, o ƴami ɓe toy *Almasiihu oon foti rimeede. ");
INSERT INTO fuh_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ɓe njaabii mo, ɓe mbi'i : —Baytilaama nder leydi Yahudiya, ngam non annabiijo gom winndunoo wi'i : ");
INSERT INTO fuh_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Aan, Baytilaama, nder leydi Yahudiya, hakiika caka gure Yahudiya mawɗe ɗeen, a hanaa wuro pamaro. Ngam ardotooɗo gom no ƴuwan nder maaɗa, garoowo dura Isra'ilankooɓe, himɓe am. ");
INSERT INTO fuh_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Sey *Hirudus noddi jom'en anndal ɓeen nder cuccukka, ƴami ɓe wakkati mo hoodere ndeen wanngi. Ɓe kaalani mo. ");
INSERT INTO fuh_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Nden o lili ɓe Baytilaama. O wi'i ɓe : —Njehee, heɓa kakkinkinen dimeeki cukalel ngel. Nde nii on ngi'ii ngel, ngaron kumpitoɗon kam ngam miin duu mi yaha, mi sujidana ngel. ");
INSERT INTO fuh_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Wakkati ɓe nanunoo ko laamiiɗo oon haalannoo ɓe ɗum, ɓe ndilli. Hoodere nde ɓe ngi'unoo har lettugal ndeen, ardii ɓe faa nde yottii dey-dey to cukalel ngel woni, sey nde darii. ");
INSERT INTO fuh_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Wakkati ɓe ngi'unoo hoodere ndeen darinoo, ɓe nani belɗum sanne sanne. ");
INSERT INTO fuh_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ɓe naati nder ɓaade ndeen, sey ɓe ngi'i cukalel ngel he innum Mariyaama. Ɓe turii faa he leydi, ɓe cujidani ngel. Ɓe piirti gineeji maɓɓe, ɓe kokki ngel kanŋe, iri uurdi mbelni gom he ɗakke uurɗe gom. ");
INSERT INTO fuh_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Nden ɓe kootiri laawol feerewol gom ngam Alla holli ɓe nder koyɗol to ɓe coƴƴoo ɓe kaalanowa *Hirudus. ");
INSERT INTO fuh_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Gaɗa dilludu jom'en anndal ɓeen, maleykaajo Joomiraawo gom wanngani Yusufu nder koyɗol, wi'i mo : —Umma, hooƴu cukalel ngel he innum, ndoggon, njehon Misira. Njooɗowoɗon toon sey wakkati mbi'oymaami ngarton, ngam *Hirudus no tefan warde cukalel ngel. ");
INSERT INTO fuh_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Yusufu ummii nder jemma oon, hooƴi cukalel ngel he inniigel, ɓe pa'i Misira. ");
INSERT INTO fuh_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","O jooɗii toon naako *Hirudus maayi. Ɗum waɗi duu ngam humnude haala Alla ka annabiijo makko gom yottini wakkati o wi'unoo : Mi noddi Ɓiyam wurtoo nder Misira. ");
INSERT INTO fuh_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Wakkati *Hirudus faamunoo ko jom'en anndal ɓeen njammbake ɗum, o tikki sanne. O tilsini cukaloy ngoroy ngonkoy nder Baytilaama he takkol mum fuu mbaree, illa keccoy faa warde he ngaɗukoy duuɓi ɗiɗi. O waɗi ɗum dey-dey he wakkati mo jom'en anndal ɓeen kokki mo. ");
INSERT INTO fuh_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Nyannde mum, haala ka annabi Yeremiya haalunoo kaan humnaa wakkati o wi'unoo : ");
INSERT INTO fuh_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Daaɗe nanaama nder Rama, bojji he cimayeeli mawɗi : Rahiilano woya cukaloy muuɗum ngam koy keddaaki, o jaɓaay duu sawrineede. ");
INSERT INTO fuh_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Gaɗa maayde *Hirudus, maleykaajo Joomiraawo gom wanngani Yusufu nder koyɗol toon nder leydi Misira, ");
INSERT INTO fuh_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","wi'i mo : —Umma, hooƴu cukalel ngel he innum, coƴƴoɗon nder leydi *Isra'el, ngam hiɗunooɓe mbara ngel ɓeen maayii. ");
INSERT INTO fuh_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Yusufu ummii, hooƴi cukalel ngel he innum, ngam soƴƴaade *Isra'el. ");
INSERT INTO fuh_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Amma wakkati o nanunoo ko Arkala'us mellaa laamiiɗo leydi Yahudiya nokku bammum *Hirudus, sey o huli yottaade toon. Nden, nder koyɗol kaden, o hollitaa yahde leydi Galili. ");
INSERT INTO fuh_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","O hoɗowi toon nder wuro wi'eteengo Nasaratu, ngam humnude haala ka annabiiɓe mbi'unoo : O wi'etee Nasaratuujo. ");
INSERT INTO fuh_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Duuɓi he duuɓi gaɗa mum, Yahaaya gaɗoowo *batisma wanngi nder ladde yeeruure leydi Yahudiya, omo wi'a himɓe : ");
INSERT INTO fuh_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","—Tuubee, ngam Laamu Alla ɓadake. ");
INSERT INTO fuh_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Kanko woni mo annabi *Esaaya sappinoo, wakkati wi'unoo : —Daane no huuɓa nder ladde yeeruure no wi'a : Ciryanee Joomiraawo laabi ɗi o tokkata, moƴƴinee laabi makko ! ");
INSERT INTO fuh_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Omo ɓornii koltal canyiraangal leeɓi ngolooba. Omo tunndi tunndorgol nguru. Ɓaɓɓatti he njuumri ngoni nyaamdu makko. ");
INSERT INTO fuh_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Himɓe no ƴuwa huɓeere *Ursaliima, he leydi Yahudiya he takkol maayo Urdun fuu, no ngara to makko. ");
INSERT INTO fuh_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Iɓe njardoo yeeso Alla e yeeso himɓe fuu dow hakkeeji maɓɓe, Yahaaya no waɗana ɓe *batisma nder maayo Urdun. ");
INSERT INTO fuh_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Wakkati o hi'unoo *Fariisa'en he *Sadduki'en heewɓe no ngara faa ngaɗanee *batisma, o wi'i ɓe : —Ɓiɓɓe bolle ! Moy wi'ii ndogganon tikkere Alla waroore ? ");
INSERT INTO fuh_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ngaɗee ko hollata on tuubii. ");
INSERT INTO fuh_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Nde on mbi'i nder ɓerɗe mooɗon on jippotooɓe he *Ibrahim, miin mi wi'an on : Alla no waawi waylii kaaƴe ɗee, ɗe laatoo taaniraaɓe *Ibrahim. ");
INSERT INTO fuh_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Joonin, jammbere aagaama ngam soppude ɗaɗi leɗɗe. Ndenne, lekki fuu ki rimataa ɓiɓɓe lobbe, no soppetee, faɗɗee nder hiite. ");
INSERT INTO fuh_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Miin, ndiyam ngaɗirananmi on *batisma ngam hollude ko on tuubii. Amma garoowo gaɗa am oon, no ɓuri kam baawɗe. Mi fotaay baa ɓortude paɗe makko. Kanko, *Ruuhu Ceniiɗo e hiite o waɗiranta on *batisma. ");
INSERT INTO fuh_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Omo jogii ƴarorde makko ngam ƴaraade alkamaari makko faa laaɓa. O hawra gabbe makko, o loowa nder ƴeelu. Nden o wula nyaane ndeen nder hiite nge nyifataa abada. ");
INSERT INTO fuh_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Nder wakkati mum, Iisa wari ƴuwi Galili, o wari dow maayo Urdun to Yahaaya, ngam o waɗanee *batisma. ");
INSERT INTO fuh_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Amma Yahaaya hosi salaade, nden wi'i mo : —Aan haani waɗande kam *batisma. Amma noy ngarirtaa to am, miin, faa mi waɗane *batisma ? ");
INSERT INTO fuh_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Iisa jaabii mo, wi'i : —Accu ɗum laatoroo non joonin, ngam non kaanuɗen humnirde ko dartii fuu. Nden, Yahaaya jaɓi ");
INSERT INTO fuh_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","waɗani Iisa *batisma. Wakkati Iisa ummii dari nder ndiyam ɗam, kammu omti. O hi'i *Ruuhu Alla no jippoo nder nanndi wuugaanu, no wara dow makko. ");
INSERT INTO fuh_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Wakkati mum da, daane gom ƴuwi dow, wi'i : —Oo woni Ɓiyam korsuɗo, mo nananmi belɗum mum. ");
INSERT INTO fuh_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Nder wakkati mum, *Ruuhu Alla ɗowi Iisa nder ladde yeeruure, ngam Ibiliisa sii'oo mo. ");
INSERT INTO fuh_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jemma he nyalooma faa ɗum waɗi balɗe lasooji ɗiɗi, Iisa no suumi, o rafaa. ");
INSERT INTO fuh_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Nden, Cii'otooɗo oon ɓadii mo, wi'i : —Se goonga fuu a *Ɓii-Alla, tilsin kaaƴe ɗee laatoo nyaamdu. ");
INSERT INTO fuh_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Sey Iisa jaabii mo, wi'i : —Dewtere Alla wi'i : Hanaa nyaamdu tan neɗɗo wuurdata, amma haala fuu ƴuwka to Alla. ");
INSERT INTO fuh_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Gaɗa mum, Ibiliisa yaari Iisa nder *Ursaliima huɓeere seniine, darni mo dow hoore *Juulirde mawne. ");
INSERT INTO fuh_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Nden wi'i mo : —Se goonga fuu a *Ɓii-Alla, jikku dow leydi, ngam Dewtere Alla wi'i : Alla tilsinan maleykaaɓe mum taɓɓite to koyngal maaɗa fii he hayre. ");
INSERT INTO fuh_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Sey Iisa jaabii mo, wi'i : —Dewtere Alla wi'i kaden : A sii'ataako Alla Joomiraawo maa. ");
INSERT INTO fuh_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Gaɗa mum Ibiliisa yaari Iisa dow waamnde toowne sanne gom, holli mo laamuuji duuniyaaru fuu he no ɗi ngoodiri darja. ");
INSERT INTO fuh_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Nden wi'i mo kaden : —Mi hokkete ɗi, ɗi fuu, nde nii a hofake, a sujidanii kam. ");
INSERT INTO fuh_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Sey Iisa jaabii mo, wi'i : —Woɗɗam Ibiliisa ! Ngam Dewtere Alla wi'ii : Alla Joomiraawo maa tan kaanɗaa sujidande. Kanko tan kaanɗaa rewude. ");
INSERT INTO fuh_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Nden Ibiliisa dilli acci mo. Maleykaaɓe gom ngari to makko, no ngollana mo. ");
INSERT INTO fuh_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Wakkati Iisa nanunoo ko Yahaaya uddaama, o fa'i Galili. ");
INSERT INTO fuh_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","O eggi Nasaratu, o hoɗowi Kafarnahum takkol peta Galili, ci'e gonɗe nder leykoy Jabulon he Naftali. ");
INSERT INTO fuh_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ɗum waɗi ngam humnude haala ka annabi *Esaaya haalunoo wakkati o wi'unoo : ");
INSERT INTO fuh_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Onon leykoy Jabulon he Naftali ngonkoy takkol peta Galili, ngonkoy gaɗa maayo Urdun, tawaakoy nder leydi Galili, leydi ɓe kanaa *Yahudankooɓe : ");
INSERT INTO fuh_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Wonɓe nder nimre, hi'uɓe jeyngol manngol. Wonɓe nder ɗowdi maayde, jeyngol wanngani ɓe. ");
INSERT INTO fuh_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Nder wakkati oo non, Iisa fuɗɗi waajaade no wi'a : —Tuubee, ngam Laamu Alla ɓadake. ");
INSERT INTO fuh_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Wakkati Iisa gosotonoo daane peta Galili, o hi'i worɓe ɗiɗo nanngooɓe liƴƴi gom, Simon inndirteeɗo Piyer he rimdaaɗo mum Andiire. Iɓe paɗɗa taaruuji maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Nden Iisa wi'i ɓe : —Ngaree, tokkee kam. Mi waɗan on nanngooɓe himɓe. ");
INSERT INTO fuh_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Wakkati mum da ɓe mboppi taaruuji maɓɓe, ɓe tokki mo. ");
INSERT INTO fuh_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","O yehi yeeso, o hi'i kaden rimdaaɓe ɗiɗo gom Yakuuba he Yahaaya he baabiiɓe Jebede, iɓe nder laana, iɓe moƴƴina taaruuji maɓɓe. O noddi ɓe, kamɓe duu. ");
INSERT INTO fuh_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Wakkati mum da ɓe mboppi laana kaan, ɓe acci baabiiɓe, ɓe tokki mo. ");
INSERT INTO fuh_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Iisa tinni no fiiloo nder leydi Galili, omo waajoo nder *baajorɗi maɓɓe. Omo filloo filla *Habaru lobbo, filla Laamu Alla. Omo nyawta iri nyawuuji he iri laruuji fuu. ");
INSERT INTO fuh_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Nden habaru makko sankitii nder leydi Siriya fuu. Himɓe no ngadda nyawɓe mum'en, wonduɓe he nyawuuji feere-fereeji to makko. Woɓɓe no ngondi he ginnaaji, woɓɓe no ngondi he paɗɗe, woɓɓe duu no bonnguuɓe. O nyawti ɓe, ɓe fuu. ");
INSERT INTO fuh_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Jama'aare mawne tokki mo. No woodi ƴuwɓe Galili, ƴuwɓe leydi Gure-sappo, *Ursaliima, Yahudiya, he ƴuwɓe gaɗa maayo Urdun. ");
INSERT INTO fuh_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Wakkati Iisa hi'unoo jama'aare warde ndeen, o ƴeenyi dow waamnde, o jooɗowii. *Aahiiɓe makko ngari to makko. ");
INSERT INTO fuh_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Sey o fuɗɗi waajaade ɓe, o wi'i : ");
INSERT INTO fuh_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—On mbelii ko'e, onon annditinɓe ko oɗon kaani wattude hoolaare mooɗon he Alla, ngam onon njeyi Laamu Alla. ");
INSERT INTO fuh_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","On mbelii ko'e, onon woyooɓe, ngam Alla fukkinan ɓerɗe mon. ");
INSERT INTO fuh_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","On mbelii ko'e, onon leesiniiɓe, ngam Alla ronnan on duuniyaaru. ");
INSERT INTO fuh_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","On mbelii ko'e, onon hiɗuɓe dartinaaku sanne, ngam on kaaran, on ɗomɗitan. ");
INSERT INTO fuh_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","On mbelii ko'e, onon yurmotooɓe, ngam Alla yurmoto on. ");
INSERT INTO fuh_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","On mbelii ko'e, onon laaɓuɓe ɓerɗe, ngam on ngi'an Alla. ");
INSERT INTO fuh_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","On mbelii ko'e, onon waddooɓe jam, ngam on noddirtee ɓiɓɓe Alla. ");
INSERT INTO fuh_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","On mbelii ko'e, onon torraaɓe ngam dartinaaku, ngam onon njeyi Laamu Alla. ");
INSERT INTO fuh_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","On mbelii ko'e nde himɓe njenni on, torrii on, ndeki on iri bononda fuu ngam am. ");
INSERT INTO fuh_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Mbelnee, keewiree welwelo, ngam baraaje mawɗe no ndoomi on dow kammu. Ngam hano non annabiiɓe artuɓe on ɓeen torriraa. ");
INSERT INTO fuh_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","—Onon ngoni lamɗam duuniyaaru nduu. Amma nde ɗam lamsaa, ɗume wattetee kaden ko ɗam lamsa ? Ɗam nafataa baafuy ! Ɗam faɗɗetee yaasin, himɓe njaaɓa ɗam. ");
INSERT INTO fuh_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Onon ngoni jeyngol duuniyaaru nduu. Huɓeere nyiɓaande dow waamnde waawaa suuɗaade. ");
INSERT INTO fuh_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Walaa kuɓɓanɗo fitilla, nden hippa tummbude dow makka. Sey nii joomum ɓila ka, ka yaynana tawaaɗo nder suudu nduun fuu. ");
INSERT INTO fuh_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Hano non jeyngol mooɗon haani yaynirde yeeso himɓe, ngam ɓe ngi'a golleeji lobbi ɗi ngatton, nden ɓe njetta Baabii'on gonɗo dow. ");
INSERT INTO fuh_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","—To miilee mi wari ngam moytude tilsinooje binndaaɗe nder *Tawreeta naa nder dewte annabiiɓe. Mi waraay ngam mi moyta ɗe amma ngam mi humna ɗe. ");
INSERT INTO fuh_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Goonga kaalananmi on : Se nii kammu e leydi no keddii, toɓɓel naa masel moytataake nder *Tawreeta faa ɗum fuu ɗum tabbita. ");
INSERT INTO fuh_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ndenne, neɗɗo fuu jedduɗo ko ɓuri famɗude nder tilsinooje ɗeen, dey ekkitii woɓɓe faa ngaɗa non, joomum laatotoo ɓurɗo famɗude nder Laamu Alla. Amma neɗɗo fuu tokkuɗo *Tawreeta goonga e goonga, dey ekkitii woɓɓe ngaɗa ko winndaa nder mayre, joomum laatoto mawɗo nder Laamu Alla. ");
INSERT INTO fuh_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ngam miɗo haalana on : Se nii on ɓuraay jannginooɓe *Tawreeta he *Fariisa'en fuu dartinaaku, on naatataa nder Laamu Alla. ");
INSERT INTO fuh_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","—On nani maamiraaɓe meeɗen mbi'anooma : To ittu yonki goɗɗo, ittuɗo yonki fuu no haani hiiteede. ");
INSERT INTO fuh_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Amma miin kay, miɗo wi'a on : Tikkanɗo banndum fuu, no haani hiiteede. Neɗɗo fuu bi'uɗo banndum no kaaŋaaɗo, no haani darneede yeeso alkaali. Kaden duu, neɗɗo fuu bi'uɗo banndum no milkaaɗo no haani watteede nder jahannama. ");
INSERT INTO fuh_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ndenne, nde nii a warii dow hirsirde faa ngaɗaa *sadaka, nden miccitiɗaa wakkati mum da ko mettal ɓerne no hakkune maa, aan he bannda : ");
INSERT INTO fuh_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Too ! Accu *sadaka maa toon, njahaa njaafodiron ginan, nden ngartaa ngaɗaa *sadaka maa. ");
INSERT INTO fuh_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Nde goɗɗo felii ma, wakkati njaadoton to sariya, yawɗa tefaa potal hakkune maa, aan e joomum, fadde mooɗon yottaade ngam to o watte nder juuɗe hiitotooɓe. Nden kamɓe duu, ɓe ngatte nder juuɗe doomoowo kasu, uddeɗaa. ");
INSERT INTO fuh_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Goonga kaalananmaami, a wurtataako abada nde a yoɓaay ko tokketeɗaa ɗum faa laaɓa. ");
INSERT INTO fuh_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","—On nani wi'anooma : To yeenu ! ");
INSERT INTO fuh_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Amma miin kay, miɗo wi'a on : Ƴeewuɗo debbo janaano faa suunaa mo, joomum yeenii mo nder ɓerne mum. ");
INSERT INTO fuh_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ndenne, nde hitere maa nyaamo no waɗa ngaɗaa hakke, ittu nde, paɗɗaa nde to woɗɗi ! Ceedaa he mayre no ɓuri moƴƴande ma dina ɓanndu maa fuu faɗɗee nder jahannama. ");
INSERT INTO fuh_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Nde junngo maa nyaamo no waɗa ngaɗaa hakke, taƴu ngo, paɗɗaa ngo to woɗɗi ! Ceedaa he maggo no ɓuri moƴƴande ma dina ɓanndu maa fuu naata jahannama. ");
INSERT INTO fuh_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","—Wi'anooma kaden : Ceerɗo deekum fuu, hokka mo talkuru ceergal. ");
INSERT INTO fuh_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Amma miin kay, miɗo wi'a on : Neɗɗo fuu ceerɗo deekum ko hanaa ngam jeenu, joomum waɗii mo jeenoowo. Neɗɗo fuu ɓaŋuɗo debbo ceeraaɗo, kam duu yeeni. ");
INSERT INTO fuh_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","—On nanii kaden, maamiraaɓe meeɗen mbi'anooma : Taa ummin hunayeere maa, amma sey nii kumnaa ko kunaniɗaa ɗum yeeso Joomiraawo. ");
INSERT INTO fuh_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Amma miin kay, miɗo wi'a on : Taa huna baa. Taa hunoraa kammu, ngam ngu jooɗorgal Alla. ");
INSERT INTO fuh_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Taa hunoraa leydi, ngam ndi yaaɓirde koyɗe makko, naa *Ursaliima, ngam ngo huɓeere Laamiiɗo mawɗo. ");
INSERT INTO fuh_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Taa hunoraa hoore maa, ngam a waawaa rawninde naa ɓawlinde baa leeɓol mayre gootol. ");
INSERT INTO fuh_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Nde nii a jaɓi, mbi'aa tan a jaɓi, nde nii a jaɓaay duu, mbi'aa tan a jaɓaay. Ko ƴaari ɗum, to bonɗo oon ƴuwi. ");
INSERT INTO fuh_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","—On nanii wi'anooma : Hitere yomnitortee hitere, nyiire yomnitortee nyiire. ");
INSERT INTO fuh_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Amma miin kay, miɗo wi'a on : To njomnitee gaɗuɗo on ko boni. Nde goɗɗo feenyii ma dow nyaamo, linnyu mo gooto duu. ");
INSERT INTO fuh_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Nde goɗɗo noddi ma kiite ngam teeta toggoore maa, accu o yaada he jabbaare maa duu. ");
INSERT INTO fuh_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Nde goɗɗo tilsinii ma ronndaade donngal yaadu kilo go'o, ronndaa ngal yahde kilooji ɗiɗi. ");
INSERT INTO fuh_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Nde goɗɗo ƴamii ma, hokku ɗum. Nde goɗɗo wi'ii ma mbuƴoɗaa ɗum, to sala. ");
INSERT INTO fuh_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","—On nanii wi'anooma : Ngiɗaa gondo maa,mbanyaa ganyo maa. ");
INSERT INTO fuh_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Amma miin kay, miɗo wi'a on : Ngiɗee wayɓe mon, ndu'anoɗon torrooɓe on, ");
INSERT INTO fuh_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ngam laatoɗon ɓiɓɓe Baabii'on gonɗo dow. Ngam no o fuɗinirta naange makko dow bonɓe, hano non duu o fuɗinirta nge dow moƴƴuɓe. No o tomnirta ndiyam dow dartiiɓe nii, non duu o tomnirta ɗam dow oonyiiɓe. ");
INSERT INTO fuh_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Nde hiɗuɓe on tan ngiɗɗon, baraaje ɗeye keɓoton ? Baa *jaɓooɓe janngal non ngaɗata ! ");
INSERT INTO fuh_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Nde banndiraaɓe mon tan njewtanton, ndenne ɗume senndi on he ɓeeto ? Baa ɓe anndaa Alla non ngaɗata ! ");
INSERT INTO fuh_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ngam majjum, laatee huuɓuɓe hano Baabii'on kuɓɗo gonɗo dow. ");
INSERT INTO fuh_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","—Tinnee to ngaɗee golleeji lobbi ngam himɓe ngi'a on. Nde on ngaɗii ɗum, on keɓataa baraaje fuu to Baabii'on gonɗo dow. ");
INSERT INTO fuh_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ndenne, nde aɗa sakkana talkaaɓe, taa huuɓu ngam himɓe ngi'e. Non munaafiki'en ngaɗata nder cuuɗi *baajorɗi he dow laabi ngam himɓe mana ɗum'en. Goonga kaalananmi on, ɓe keɓidii baraaje maɓɓe fuu. ");
INSERT INTO fuh_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Amma aan kay, nde nii aɗa sakkana talkaaɓe, to nano maa faamu ko nyaamo maa waɗata. ");
INSERT INTO fuh_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ko cakkataa fuu, sakku ɗum nder cuccukka. *Baabiraawo maa gi'oowo ko suuɗi fuu yoɓete. ");
INSERT INTO fuh_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","—Nde oɗon ndu'oo, to nyemminee munaafiki'en darotooɓe nder cuuɗi *baajorɗi he dow pottirɗi laabi, no ndu'oo ngam himɓe fuu ngi'a ɓe. Goonga kaalananmi on, ɓe keɓidii baraaje maɓɓe fuu. ");
INSERT INTO fuh_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Amma aan kay, wakkati fuu mo ndu'otoɗaa, naatu nder suudu maa, ommba dammbugal ngaal, eelaa *Baabiraawo maa gonduɗo he maa nder nokkuure suuɗiine. Nden, *Baabiraawo maa gi'oowo ko suuɗi fuu, no yoɓete. ");
INSERT INTO fuh_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Nde oɗon ndu'oo, to njuunnee du'aa'uuji mon he haalaaji meereeji ɗi ngalaa fuu nafakka hano no ɓe anndaa Alla ndu'ortoo, miilooɓe kam'en no njaabantee nde nii ɓe ɗunni haalaaji maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","To nyemminee ɓe, ngam Baabii'on no anndi ko kaajaɗon illa on eelaay mo. ");
INSERT INTO fuh_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ndaa no ndu'ortoɗon nii : *Baabiraawo amin gonɗo dow, innde maa seniine teddinee. ");
INSERT INTO fuh_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Laamu maa wara. Muuyɗe maa ngaɗee ɗo dow leydi hano no ɗe ngaɗiraa dow kammu nii. ");
INSERT INTO fuh_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Hoynan min hannden nyaamdu heƴunu ndu min kaajaa. ");
INSERT INTO fuh_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Yaafana min gacceeji amin hano no min njaafonortoo toonyiiɓe min nii. ");
INSERT INTO fuh_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Taa accu min cii'ee, amma hisin min bonɗo oon. Ngam laamu, baawɗe he teddungal no ngonani ma faa abada abadin. Aamiin ! ");
INSERT INTO fuh_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ndenne, nde nii on njaafake toonyiiɓe on, Baabii'on gonɗo dow duu no yaafoto on. ");
INSERT INTO fuh_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Amma nde nii on njaafataako toonyiiɓe on, Baabii'on duu yaafataako gacceeji mon. ");
INSERT INTO fuh_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","—Nde nii oɗon cuumii, to njoofee ɓalli mooɗon, ɓalinoɗon hano munaafiki'en ɓalintooɓe ngam himɓe fuu anndita ko ɓe cuumiiɓe. Goonga kaalananmi on : Ɓe keɓidii baraaje maɓɓe fuu. ");
INSERT INTO fuh_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Amma aan kay, nde nii a suumake, lootu yeeso maa, mbujaa nebbam uurɗam, ");
INSERT INTO fuh_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","to neɗɗo fuu faamu a cuumiiɗo. *Baabiraawo maaɗa gonɗo nder to suuɗi oon tan anndata. Wooɗi duu, *Baabiraawo maa gi'oowo ko ngaɗɗaa nder cuccukka oon, no yoɓete. ");
INSERT INTO fuh_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","—To ndesanee ko'e mooɗon njawdi nder duuniyaaru nduu, to mooƴu he puunyol mbonninta, to wuyɓe kelata ommbooɗe, mbujja. ");
INSERT INTO fuh_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ndesanee ko'e mooɗon njawdi dow kammu, to baafuy bonnataa, mooƴataa, fuunyataa, to wuyɓe duu kelataa ommbooɗe sako mbujja. ");
INSERT INTO fuh_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ngam to njawdi maa woni, toon ɓerne maa duu wonata. ");
INSERT INTO fuh_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","—Gite ngoni fitillaaji ɓanndu. Nde gite maa no mbooɗi, ɓanndu maa fuu no yaynan. ");
INSERT INTO fuh_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Amma nde nii ɗe mbooɗaa, ɓanndu maa fuu no niɓɓan. Ndenne, nde nii jeyngol tawaangol nder ɓanndu maa niɓɓi, sikka fuu walaa nimre ndeen no tekkiɗan ! ");
INSERT INTO fuh_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","—Neɗɗo fuu waawtaa gollande mawɓe ɗiɗo, ngam joomum wanyan gooto, hiɗaa ooto, naa teddina gooto, yawo ooto. On mbaawtaa gollande Alla ngollanon njawdi. ");
INSERT INTO fuh_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ngam majjum waɗi miɗo wi'a on : To cuulee ko'e mooɗon nder mbuurnam mooɗon dow ko nyaamton, ko njarton naa ko ɓornotoɗon. Ngam mbuurnam no ɓuri nyaamdu, ɓanndu duu no ɓuri koltal, naa hanaa ? ");
INSERT INTO fuh_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ndaaree pooli piirooji ɗii : Ɗi aawataa, ɗi kettataa, ɗi ndesataa, amma Baabii'on gonɗo dow nyamnata ɗi. Onon nee, on ɓuraa pooli ɗii teddungal naa ? ");
INSERT INTO fuh_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Moy he mooɗon waawi ɓeydude nyalooma gooto dow balɗe mum ngam hoore mum haɓɓake ? ");
INSERT INTO fuh_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ɗume waɗi ko kolte no cuuli on ? Ndaaree no piindiiji ladde mawnirta : Ɗi ngollataa, ɗi mottataa. ");
INSERT INTO fuh_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Amma miɗo haalana on : Baa Suleymaanu he darjaaji mum fuu holtiraay ko foti gootel nder majji. ");
INSERT INTO fuh_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Nde nii Alla no holtina huɗo taweteeko nder ngesa hannden, taƴeteeko faɗɗee nder hiite jaaŋo, ɗume haɗata mo holtinde on faa ɓura nii, onon famɗuɓe goonɗinol ? ");
INSERT INTO fuh_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ndenne, to ko'e mooɗon kaɓɓo faa mbi'on : « Ɗume nyaameten ? Ɗume njarten ? Ɗume ɓornotoɗen ? » ");
INSERT INTO fuh_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ngam kujje ɗee fuu, ɓe anndaa Alla pilotoo ɗe. Nde goonga, Baabii'on gonɗo dow no anndi ko oɗon kaajaa ɗum, ɗum fuu. ");
INSERT INTO fuh_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ndenne, tefee Laamu Alla he dartinaaku makko ginan, o ɓeydanan on kujje ɗee fuu. ");
INSERT INTO fuh_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Nyalaane fuu he donngal mum. To ko'e mooɗon kaɓɓo ngam jaaŋo, ngam jaaŋo duu no wardan he ko muuɗum. ");
INSERT INTO fuh_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","—To kiitee himɓe, ngam to Alla hiito on. ");
INSERT INTO fuh_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ngam no kiitortoɗon woɓɓe, non onon duu kiiterteɗon. Kaden duu etirgal ngal etirton, kanngal etiranteɗon. ");
INSERT INTO fuh_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ko waɗi ko aɗa hi'a kuɗel nder hitere bannda, amma a hi'ataa bonjariyal gonngal nder nde maaɗa ? ");
INSERT INTO fuh_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Naa noy mbaawɗaa wi'ude bannda : « Accu mi ittane kuɗel gom nder hitere maa », amma aan kay, bonjariyal no nder nde maaɗa ? ");
INSERT INTO fuh_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Munaafiki, ittu bonjariyal tawaangal nder hitere maaɗa ginan heɓa ngi'iraa no wooɗiri, keɓaa no ittirɗaa kuɗel tawaangel nder hitere bannda ngeel. ");
INSERT INTO fuh_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","To kokkee dawaaɗi ko senii, to paɗɗee kaaƴe mooɗon dime yeeso girooji, ngam to ɗi njaaɓu ɗe, dawaaɗi duu mbaylito ŋata on. ");
INSERT INTO fuh_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","—Eelee, on keɓan. Tefee, on ngiitan. Calminee, on omtantee. ");
INSERT INTO fuh_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ngam eeluɗo fuu heɓan. Tefuɗo fuu hiitan. Calminɗo fuu omtantee. ");
INSERT INTO fuh_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Moy nder mooɗon hokkata ɓiyum hayre nde eeli buuru ? ");
INSERT INTO fuh_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Naa hokka mo mboddi se o eeli linngu ? ");
INSERT INTO fuh_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","No mbonirɗon nii fuu, oɗon kokka ɓiɓɓe mooɗon kujje lobbe, sako Baabii'on gonɗo dow. Omo hokka eeluɗo mo fuu ko moƴƴi. ");
INSERT INTO fuh_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Ndenne, ngaɗiranee himɓe no ngiɗɗon ɓe ngaɗana on. Ngam ɗum woni ko *Tawreeta Muusa he dewte annabiiɓe mbi'i. ");
INSERT INTO fuh_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","—Naatiree dammbugal paaɗungal ! Ngam dammbugal halkere no yaaji, laawol maggal no hoyi, tokkooɓe ngol duu no ɗuuɗi. ");
INSERT INTO fuh_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Amma dammbugal mbuurnam no faaɗi, laawol maggal no ɓillii, hiitooɓe ngol duu ɗuuɗaa. ");
INSERT INTO fuh_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","—Tinnee he annabiiɓe fewreeɓe, warooɓe to mooɗon nder nanndi baali, amma nder guri maɓɓe ɓe cuuli dafaaɗi. ");
INSERT INTO fuh_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Har golleeji maɓɓe annditirton ɓe, hano no lekki annditirtee har ɓiɓɓe mum. Cabiije teɓataake he kebbe, ibbe duu teɓataake he tuppe. ");
INSERT INTO fuh_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Lekki lobbi, ɓiɓɓe lobbe rimata. Amma lekki mbonki, ɓiɓɓe bonɗe rimata. ");
INSERT INTO fuh_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Lekki lobbi waawtaa rimude ɓiɓɓe bonɗe. Wooɗi duu, lekki mbonki waawtaa rimude ɓiɓɓe lobbe. ");
INSERT INTO fuh_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Lekki fuu ki rimataa ɓiɓɓe lobbe soppetee, faɗɗee nder hiite. ");
INSERT INTO fuh_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ndenne, har golleeji maɓɓe annditirton ɓe. ");
INSERT INTO fuh_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","—Hanaa wi'ooɓe no mbi'itoo kam Joomiraawo mum'en fuu naatata nder Laamu Alla. Sey waɗooɓe muuyɗe *Baaba am gonɗo dow, ɓeen ngoni naatooɓe nder maggu. ");
INSERT INTO fuh_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Nyannde darŋal, heewɓe mbi'an kam : « Joomiraawo ! Joomiraawo ! Hanaa he innde maa min mbaajori haala Alla ? Hanaa he innde maa min ndiiwiri ginnaaji ? Hanaa he innde maa min ngaɗiri kaayɗe ɗuɗɗe ? » ");
INSERT INTO fuh_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Wakkati mum mbi'anmi ɓe : « Mi anndaa on abada. Mboɗɗee kam, onon waɗooɓe ko boni ! » ");
INSERT INTO fuh_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","—Ndenne, neɗɗo fuu kettiniiɗo haalaaji am, golliri ɗi, nanndan he jom hakkillo nyiɓuɗo suudu mum dow tepaare. ");
INSERT INTO fuh_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ndiyam toɓi, gooruuji mbubbi, keni mawɗi mbifiri semmbe dow mayru. Ɗum fuu ndu saamaay, ngam ndu sinngaama dow tepaare. ");
INSERT INTO fuh_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Amma neɗɗo fuu kettiniiɗo haalaaji am ɗii, dey golliraay ɗi, no nanndi he bahiima, nyiɓuɗo suudu mum dow taasiri. ");
INSERT INTO fuh_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ndiyam toɓi, gooruuji mbubbi, keni mawɗi mbifiri semmbe dow mayru. Ndu saami, ndu sankitii. ");
INSERT INTO fuh_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Wakkati Iisa timminoo waaju mum, ɗum haayɗini jama'aare ndeen sanne. ");
INSERT INTO fuh_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ngam o waajoraaki ɓe hano no jannginooɓe *Tawreeta mbaajorto, amma he baawɗe o waajorii ɓe. ");
INSERT INTO fuh_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Wakkati Iisa jippinoo waamnde ndeen, jama'aare ɗuunde gom tokki mo. ");
INSERT INTO fuh_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Sey gorko ceppinɗo gom ɓattii mo, hofi yeeso makko, wi'i mo : —Moodibbo, nde nii a jaɓi, aɗa waawi yamɗintinde kam. ");
INSERT INTO fuh_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Iisa foorti junngo mum, meemi mo, wi'i : —Mi jaɓi, yamɗitin ! Wakkati mum da, gorko oon yamɗiti. ");
INSERT INTO fuh_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Gaɗa mum, Iisa wi'i mo : —Tinna taa haalan ɗum neɗɗo fuu. Amma yah, holloy hoore maa *cakkanoowo Alla mooɗon, ngaɗaa cakkol ngol *Muusa tilsini waɗee, ngam hollude himɓe ko sikka fuu walaa a yamɗiti. ");
INSERT INTO fuh_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Wakkati Iisa naatannoo Kafarnahum, hooreejo soogeeji *Rooma gom ɓattii mo, eeli mo, wi'i : ");
INSERT INTO fuh_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","—Moodibbo, golloowo am no fukkii nder suudu, sellaa baa seɗɗa faa bonngake. Omo torroo sanne ! ");
INSERT INTO fuh_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Iisa wi'i mo : —Mi waran, mi yamɗintina mo. ");
INSERT INTO fuh_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Amma hooreejo soogeeji oon jaabii, wi'i : —Moodibbo, miin, mi fotaay to naataa ɓaade am. Haala maaɗa tan heƴi, golloowo am yamɗitaa. ");
INSERT INTO fuh_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Miin, miɗo woodi dawranooɓe kam, amma miɗo dawrana soogeeji *Rooma duu. Nde nii mi tilsini gooto nder maɓɓe yaha, o yahan. Nde mi wi'i gooto nder maɓɓe wara, o waran. Nde nii mi wi'i maccuɗo am gom waɗa goɗɗum, o waɗan ɗum. ");
INSERT INTO fuh_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Wakkati Iisa nanunoo haala kaa, ɗum haayɗini mo, o wi'i tokkuɓe mo ɓeen : —Goonga kaalananmi on, baa nii hakkune himɓe *Isra'el fuu, mi hi'aay ir goonɗinol ngool. ");
INSERT INTO fuh_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Miɗo haalana on, heewɓe ƴuwataana lettugal he gorgal, ngara njooɗodoo *Ibrahim, Isiyaaku he Yakuuba, ɓe nyaamda nder Laamu Alla. ");
INSERT INTO fuh_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Amma haanunooɓe naata Laamu ɓeen, paɗɗetee nder nimre niɓɓude. Toon ɓe mboyata, iɓe ŋerƴodira nyiiƴe. ");
INSERT INTO fuh_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Gaɗa mum, Iisa wi'i hooreejo soogeeji oon : —Hootu. Ɗum laatane no ngoonɗinirɗaa. Wakkati mum da, golloowo hooreejo soogeeji *Rooma oon yamɗiti. ");
INSERT INTO fuh_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Wakkati Iisa yehunoo wuro Piyer, tawi esoo Piyer debbo no wondi wulowulo. ");
INSERT INTO fuh_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","O meemi junngo makko, sey wulowulo makko heli, o yamɗiti. O ummii, o jaɓɓii Iisa. ");
INSERT INTO fuh_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Wakkati hiirunoo ndeen, Iisa waddanaa himɓe heewɓe ɓe ginnaaji ngoni dow mum'en. Haala makko tan o riiwri ginnaaji gonɗi dow maɓɓe ɗiin, o nyawti nyawɓe ɓeen fuu. ");
INSERT INTO fuh_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","O waɗi kujje ɗee fuu ngam humnude ko annabi *Esaaya haalunoo wakkati o wi'unoo : Kanko he hoore makko itti torraaji meeɗen, o ronndi nyawuuji meeɗen. ");
INSERT INTO fuh_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Wakkati Iisa hi'unoo jama'aare no fiilii ɗum, sey o wi'i *aahiiɓe makko : —En njolu, ummowoɗen fonngo gooto. ");
INSERT INTO fuh_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Nden jannginoowo *Tawreeta gom ɓadii mo, wi'i : —Moodibbo, mi tokkete to njahataa fuu. ");
INSERT INTO fuh_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Iisa jaabii mo wi'i : —Junkuuji no ngoodi gayɗe, pooli duu no ngoodi cuuɗi, amma *Ɓii-Neɗɗo walaa baa nokku to fukkoo, fowtina hoore mum. ");
INSERT INTO fuh_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Nden *aahiijo makko gom, wi'i mo : —Moodibbo, accu mi mooɓowa baaba am ginan. ");
INSERT INTO fuh_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Iisa jaabii mo, wi'i : —Tokkam, accu maayɓe mooɓa maayɓe mum'en. ");
INSERT INTO fuh_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Iisa naati nder laana, *aahiiɓe makko tokki mo. ");
INSERT INTO fuh_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Say ƴuwonde ummii, henndu mawnu wifi sanne dow peta ngaan, faa benkeƴƴe no ummoo no naata nder laana kaan. Tawi Iisa no ɗaanii. ");
INSERT INTO fuh_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","*Aahiiɓe ɓeen ɓadii mo, pindini mo, iɓe mbi'a : —Moodibbo, dannu en ! En maayan ! ");
INSERT INTO fuh_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Sey o jaabii ɓe, o wi'i : —Ɗume hulƴinta on ? Onon famɗuɓe goonɗinol ! O ummii wakkati mum, o sappii henndu nduun he benkeƴƴe ɗeen. Ɗum fuu ɗum deƴƴiti, ɗum waɗi siw ! ");
INSERT INTO fuh_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ɗum haayɗini *aahiiɓe ɓeen sanne, ɓe tokki iɓe mbi'odira : —Moy woni neɗɗo oo, mo baa keni e ndiyam no ɗowtanoo ɗum ? ");
INSERT INTO fuh_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Wakkati Iisa'en ummii, pedditi peta Galili, panndowi dow fonngo leydi Gadara, sey worɓe ɗiɗo ɓe ginnaaji ngonnoo dow mum'en mburtii nder annyeeje, potti he makko. Iɓe kulƴini sanne faa neɗɗo fuu suusaa tokkude laawol maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ɓe tinni iɓe kuuɓa, iɓe mbi'a : —*Ɓii-Alla, ɗume ngiɗaa waɗude min ? Naa a warii ngam torrude min fadde wakkati podaaɗo oon yottaade ? ");
INSERT INTO fuh_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Tawi sewre girooji mawne gom no toowti ɓe seɗɗa inde dura. ");
INSERT INTO fuh_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ginnaaji ɗiin ŋaarii mo, mbi'i : —Nde riiwude min ngiɗaa, accu min naatowa nder sewre girooji ɗii. ");
INSERT INTO fuh_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Nden Iisa wi'i ɗi : —Naatowee ! Ginnaaji ɗiin mburtii, naatowi nder girooji ɗiin. Wakkati mum da, sewre ndeen fuu doggi no simmitoo waamnde ndeen, iɗi tallitoo, iɗi caamowa nder peta ngaan, iɗi njooloo. ");
INSERT INTO fuh_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Durooɓe ɓeen ndoggi kooti wuro, kaalowi ko hewti ɗum'en. Ɓe pilli habaru himɓe ɓe ginnaaji wonnoo dow mum'en ɓeen duu. ");
INSERT INTO fuh_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Himɓe wuro ngoon fuu mburtii, kawrowi to Iisa. Wakkati ɓe ngi'unoo mo ndeen, ɓe ŋaarii mo o dilla nder leydi maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Iisa naati laana, fedditi peta ngaan, warti siire mum. ");
INSERT INTO fuh_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Himɓe gom ngaddani mo bonnguujo gom no fukkinaa dow kooƴirngal maayɓe. Wakkati o hi'unoo no goonɗinol maɓɓe foti, o wi'i bonnguujo oon : —Higo, fukkin ɓerne maa. Hakkeeji maa njaafaama. ");
INSERT INTO fuh_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Wakkati jannginooɓe *Tawreeta gom nanunoo ɗum sey ɓe mbi'odiri hakkune maɓɓe : —Gorko oo no bonna innde Alla. ");
INSERT INTO fuh_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Amma Iisa faami miilooji maɓɓe, nden wi'i ɓe : —Ɗume waɗi ko oɗon miiloo miilooji bonɗi nder ɓerɗe mooɗon ? ");
INSERT INTO fuh_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Hakkune wi'ude « Hakkeeji makko njaafaama » naa « O ummoo, o yaha », ɗume ɓuri hoyde ? ");
INSERT INTO fuh_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Amma miɗo hiɗi paamon ko *Ɓii-Neɗɗo no jogii baawɗe yaafaade hakkeeji himɓe nder duuniyaaru nduu. Sey o wi'i bonnguujo oon : —Umma, hooƴu kooƴirngal maayɓe ngal ngaddiraɗaa, hootu ! ");
INSERT INTO fuh_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Gorko oon ummii, hooti. ");
INSERT INTO fuh_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Wakkati jama'aare ndeen hi'unoo ɗum, ɓe kuli, ɓe tinni iɓe njetta Alla ngam iri baawɗe ɗe o hokki ɓii-aadama. ");
INSERT INTO fuh_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Wakkati Iisa waɗannoo jahaangal mum, o hi'i gorko gom bi'eteeɗo Matta no jooɗii nder suudu janngal. Sey o wi'i mo : —Tokkam. Sey Matta ummii, tokki mo. ");
INSERT INTO fuh_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Gaɗa mum, nyannde gom Iisa no nyaama nder suudu Matta. Jaɓooɓe janngal gom he ɓooyɓe nder gaɗol hakke gom, kamɓe ɗuɓɓe ngari njooɗii no nyaamda he makko, kanko he *aahiiɓe ɓeen. ");
INSERT INTO fuh_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Wakkati *Fariisa'en ngi'unoo ɗum, mbi'i *aahiiɓe makko : —Ɗume waɗi ko moodibbo mooɗon no nyaamda he *jaɓooɓe janngal, he waɗooɓe hakke ɓee ? ");
INSERT INTO fuh_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Amma wakkati Iisa nanunoo ɗum, wi'i ɓe : —Nyawɗo haajaa cawroowo hanaa jamɗuɗo. ");
INSERT INTO fuh_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Njehee, njanngee ko Dewtere Alla wi'i : Yurmeene ngiɗumi, hanaa *sadaka. Miin, mi waraay noddude miilooɓe kam'en no dartiiɓe, amma mi waraana ngam annduɓe kam'en no waɗooɓe hakke. ");
INSERT INTO fuh_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Gaɗa mum aahiiɓe Yahaaya gaɗoowo *batisma ngari to Iisa, ƴami mo mbi'i : —Ko waɗi minen he *Fariisa'en miɗen cuumoo, amma *aahiiɓe maaɗa kay cuumataako ? ");
INSERT INTO fuh_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Nden Iisa jaabii ɓe, wi'i : —Warɓe ɓanngal no mbaawi ɓalinaade wakkati ɓaŋuɗo oon no wondi he maɓɓe naa ? Amma nyalaaɗe ngaran ɗe ɓaŋuɗo oon suutetee hakkune maɓɓe. Nder balɗe ɗeen, ɓe cuumoto. ");
INSERT INTO fuh_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Neɗɗo fuu nyootataa lefol kesol he koltal kiinngal ngam lefol ngool serkan koltal kiinngal ngaal, cerkol ngool ɓeydoo. ");
INSERT INTO fuh_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Kaden duu cabiijam kesam loowataake nder sumalleeji kiɗɗi. Nde ɗum waɗi, sumalleeji ɗiin pusan, cabiijam ɗaam rufa, sumalleeji ɗiin mbona. Ndenne, cabiijam kesam nder sumalleeji kesi loowetee, faa ɗum fuu ɗum reenoo. ");
INSERT INTO fuh_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Wakkati Iisa haaldannoo he *Fariisa'en, sey hooreejo *waajordu gom nii yottii, hofi yeeso makko, wi'i mo : —Jooni ɓiyam debbo maayi, amma war, yowu junngo maaɗa dow makko, heɓa o ummitoo. ");
INSERT INTO fuh_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Iisa, he *aahiiɓe muuɗum, ummii tokki mo. ");
INSERT INTO fuh_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Dow laawol maɓɓe, sey yeyraajo gom nii gaɗuɗo duuɓi sappo he ɗiɗi ƴiiƴam daranaaki mo. Omo miila nder ɓerne makko, ko nde nii o meemi jabbaare Iisa tan, o nyawtan. O ƴuwri Iisa har gaɗa, o meemi hunnduko jabbaare makko. ");
INSERT INTO fuh_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Iisa yeeƴitii, hi'i mo, wi'i : —Banndam debbo, fukkin hakkillo maaɗa, goonɗinol maa dannii ma. Wakkati mum da, debbo oon daɗi. ");
INSERT INTO fuh_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Wakkati Iisa yottinoo wuro hooreejo *waajordu oon, o hi'i fuufooɓe seeseeji ciryake ngam mooɓoyde maayɗo oon, himɓe gom duu no har ɗo no mboya. ");
INSERT INTO fuh_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","O wi'i ɓe : —Mburtee, suka oo maayaay. O ɗaanii tan. Sey himɓe ɓeen njali jaleeɗe yawaare. ");
INSERT INTO fuh_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Wakkati ɓe njaltintoo mo yaasin ndeen, o naati nder suudu nduun, o nanngi junngo suka oon, sey suka oon ummii. ");
INSERT INTO fuh_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Habaru oon sankitii nder leydi ndiin fuu. ");
INSERT INTO fuh_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Wakkati Iisa dillannoo toon, wumɓe ɗiɗo gom tokki mo, no kuuɓa no mbi'a : —Taan Daawda, yurma min ! ");
INSERT INTO fuh_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Wakkati o naatunoo to o wernoo, wumɓe ɓeen ngari to makko. O ƴami ɓe, o wi'i : —On ngoonɗini ko miɗo waawi wallude on naa ? Ɓe njaabii mo, ɓe mbi'i : —Ayyo Moodibbo, min ngoonɗini. ");
INSERT INTO fuh_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Nden o meemi gite maɓɓe, o wi'i : —Ɗum laatanoo on, no ngoonɗinirɗon nii. ");
INSERT INTO fuh_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ɓe mbumti wakkati mum, nden o fooɗi noppi maɓɓe, o wi'i ɓe : —Tinnee, to kaalanee ɗum neɗɗo fuu. ");
INSERT INTO fuh_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Amma ɓe mburtii tan ɓe cankitowii habaru Iisa nder leydi ndiin fuu. ");
INSERT INTO fuh_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Wakkati wumtinaaɓe ɓeen ndillannoo, Iisa waddanaa gorko gom mo ginnaaru beebi. ");
INSERT INTO fuh_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","O riiwi ginnaaru nduun, sey beebaaɗo oon fuɗɗi no haala. Ɗum haayɗini jama'aare ndeen fuu faa iɓe mbi'a : —Hano ɗum hi'aaka nder *Isra'el abada ! ");
INSERT INTO fuh_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Amma *Fariisa'en ɓeen mbi'i ko hooreejo ginnaaji oon, kam hokki mo baawɗe riiwude ɗi. ");
INSERT INTO fuh_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Illa ɗon Iisa fuɗɗi no fiiloo nder ci'e he gure fuu, omo waajoo nder cuuɗi *baajorɗi, omo filloo filla *Habaru lobbo, filla Laamu Alla. Omo nyawta nyawuuji he laruuji ir iri fuu. ");
INSERT INTO fuh_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Wakkati o hi'unoo jama'aare wonnde gaɗa makko, o nani yurmeene maɓɓe, ngam ɓe tampi, ɓe cuulake sanne hano baali ɗi ngalaa duroowo. ");
INSERT INTO fuh_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Sey o wi'i *aahiiɓe makko ɓeen : —Kettol no ɗuuɗi, hettooɓe ɗuuɗaa. ");
INSERT INTO fuh_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ndenne, eelee Jom kettol lilda hettooɓe ngam kettol mum. ");
INSERT INTO fuh_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Iisa noddi *aahiiɓe muuɗum sappo he ɗiɗo ɓeen, hokki ɓe baawɗe riiwude ginnaaji he nyawtude iri nyawuuji he laruuji fuu. ");
INSERT INTO fuh_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ndaa inɗe *lilaaɓe sappo e ɗiɗo ɓeen nii : Arano maɓɓe woni Simon inndirteeɗo Piyer he minyiiko Andiire, Yakuuba ɓii-Jebede he minyiiko Yahaaya, ");
INSERT INTO fuh_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipa, Bartolome, Tomas, Matta jaɓoowo janngal, Yakuuba ɓii-Alfee, Tadde, ");
INSERT INTO fuh_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon kiranoowo suudu baaba he Yahuuda Iskariyot mo yahde yeeso jammboytoo Iisa oon. ");
INSERT INTO fuh_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Iisa lili *lilaaɓe mum sappo he ɗiɗo ɓeen, o wi'i ɓe : —To njehee to ɓe kanaa *Yahudankooɓe, kaden duu to naatee gure *Samariya. ");
INSERT INTO fuh_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Amma njehee nder ɓaadeeji Isra'ilankooɓe laatiiɓe hano baali majjuɗi ɓeen. ");
INSERT INTO fuh_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","To njehoton fuu, mbaajoɗon mbi'on : « Laamu Alla ɓadake ! » ");
INSERT INTO fuh_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Nyawton nyawɓe, ummintinon maayɓe, nyawton seppinɓe, ndiiwon ginnaaji. Forba keɓuɗon moƴƴere ndee, kokkitiron nde forba. ");
INSERT INTO fuh_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","To njaaree kanŋe, cardi naa ceede gaɗa mooɗon. ");
INSERT INTO fuh_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","To kooƴee basi ɗiɗi naa toggooje ɗiɗi. To kooƴee paɗe naa cabbi, ngam golloowo no haani nyaamdu. ");
INSERT INTO fuh_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Nder siire fuu naa nder wuro fuu ngo ngarɗon nder mum, tefee bernoowo lobbo, wooɗi njooɗoɗon to bernoowo mooɗon faa nyannde ndilloton. ");
INSERT INTO fuh_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Nde oɗon naata nder ɓaade, ndu'oɗon Alla hokka nde jam. ");
INSERT INTO fuh_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Nde nii ɓaade lobbere non, barke du'aa'u mooɗon tabbitan he mayre. Amma nde nii nde lobbiɗaa, nde heɓataa barke du'aa'u mooɗon. ");
INSERT INTO fuh_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Wuro fuu ngo jaɓɓaaki on, naa ngo himɓe mum calii jaɓude haala mooɗon, piɗɗee sollaare koyɗe mooɗon nde nii on mburtake ngo. ");
INSERT INTO fuh_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Goonga kaalananmi on : Nyannde darŋal, kiite wuro ngoon no ɓuran ɗe kuɓeeje *Sodooma e Gomoora naawde. ");
INSERT INTO fuh_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","—Kettinee ! Mi lili on hano baali caka pobbi. Ndenne kakkilanee ko'e mooɗon hano no bolle ngaɗata, laatoɗon jom'en jam hano buugaali. ");
INSERT INTO fuh_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Tinnoɗon he himɓe ɓeen, ngam ɓe ngattan on nder kiite, ɓe ɓoccan on nder *baajorɗi maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","On njaaretee yeeso hooreeɓe he yeeso laamiiɓe ngam sabbu am, ngam ceedonoɗon kam yeeso maɓɓe, kamɓe he ɓe kanaa *Yahudankooɓe. ");
INSERT INTO fuh_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Wakkati ndarnaɗon nder hiitorde fuu, to ko'e mooɗon kaɓɓo dow ko kaaloton. Ngam on kokketee haalaaji ɗi kaanuɗon haalude wakkati mum. ");
INSERT INTO fuh_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","*Ruuhu *Baabiraawo mooɗon, kam haalata nokku mooɗon. ");
INSERT INTO fuh_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Himɓe no kokkitiran sakiraaɓe mum'en mbaree, baaba no hokkitiran ɓiyum. Sukaaɓe no ummanto saarooɓe mum'en, gaɗa dabare ɓe mbaree. ");
INSERT INTO fuh_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ngam am, himɓe fuu mbanyan on. Amma tarsiniiɗo faa yottii he timmoode, joomum no hisintee. ");
INSERT INTO fuh_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Nde nii on torraama nder wuro gom, pa'ee wonngo. Goonga kaalananmi on : On timmintaa gure *Isra'el ɗeen fuu tawa *Ɓii-Neɗɗo wartaay. ");
INSERT INTO fuh_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Walaa *aahiijo ɓurɗo moodibbo mum, naa maccuɗo ɓurɗo joomum. ");
INSERT INTO fuh_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Aahiijo no waawi laatoo hano moodibbo mum, maccuɗo duu laatoo hano joomum. Miin he hoore am ɓe noddiri kam Be'eljebul, mawɗo ginnaaji, sako faa onon banndiraaɓe am. ");
INSERT INTO fuh_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","—Ndenne, to kulee himɓe. Walaa fuu ko suuɗi ko wanngintaake, walaa sirri ndi anndataake. ");
INSERT INTO fuh_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ko kaalanmi on nder nimre, kaalee ɗum nder jeyngol. Ko nyo'anmi on fuu, kaalee ɗum yaasin nder daane toowne. ");
INSERT INTO fuh_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","To kulee warooɓe ɓanndu, ɓe mbaawanaa yonkiiji fuy. Alla kaanɗon hulude. Kanko woni baawɗo halkude ɓanndu he yonki fuu nder jahannama. ");
INSERT INTO fuh_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Pooloy ɗiɗoy no connee tammal gootal. Amma baa gootel nder makkoy saamataa he leydi tawa hanaa nder muuyɗe *Baabiraawo mooɗon. ");
INSERT INTO fuh_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Onon, baa leeɓi ko'e mooɗon fuu no limaaɗi faa laaɓi. ");
INSERT INTO fuh_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ndenne, to kulee, ngam oɗon ɓuri pooloy ɗukkoy koy teddungal. ");
INSERT INTO fuh_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Neɗɗo fuu bi'uɗo no anndi kam yeeso himɓe, miin duu, mi annditan ɗum yeeso *Baaba am gonɗo dow. ");
INSERT INTO fuh_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Amma caliiɗo kam yeeso himɓe fuu, miin duu, mi salanto ɗum yeeso *Baaba am gonɗo dow. ");
INSERT INTO fuh_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","—To miilee ko mi wari ngam waddude jam nder duuniyaaru nduu. Mi waraay ngam waddude jam, amma konu ngarmi waddude. ");
INSERT INTO fuh_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Mi wari ngam mi sennda ɓiɗɗo gorko he bammum, ɓiɗɗo debbo he inna mum, ɓaŋaaɗo he esum debbo. ");
INSERT INTO fuh_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Koreeji neɗɗo laatoo wayɓe mum. ");
INSERT INTO fuh_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Korsinɗo innum naa bammum faa ɓuri kam fuu, fotaay laatoo *aahiijo am. Korsinɗo ɓiyum gorko naa debbo faa ɓuri kam fuu, fotaay laatoo aahiijo am. ");
INSERT INTO fuh_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Mo wakkaaki leggal mum *bardugal, tokki kam fuu, joomum fotaay laatoo *aahiijo am. ");
INSERT INTO fuh_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Tefuɗo hisinde yonki mum fuu, mursan ki. Amma mursuɗo ki ngam am fuu, heɓitan ki. ");
INSERT INTO fuh_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","—Jaɓɓiiɗo on fuu, jaɓɓake kam. Jaɓɓiiɗo kam fuu jaɓɓake lilɗo kam oon. ");
INSERT INTO fuh_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Jaɓɓiiɗo annabiijo ngam o annabiijo Alla, heɓan ir baraaje ɗe annabiijo oon fodanaa ɗeen. Jaɓɓiiɗo neɗɗo dartiiɗo ngam dartinaaku mum, heɓan ir baraaje ɗe dartiiɗo oon fodanaa ɗeen. ");
INSERT INTO fuh_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Goonga kaalananmi on : Neɗɗo fuu kokkuɗo ɓurɗo famɗude nder *aahiiɓe am, baa nii laatoo nyeɗerde ndiyam peewɗam non ngam o aahiijo am, joomum heppataa baraaje muuɗum. ");
INSERT INTO fuh_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Wakkati Iisa haalidinnoo ko hiɗi he *aahiiɓe mum sappo he ɗiɗo ɓeen, sey o ummii o fiilowi nder gure takkol ɗon. Omo janngina himɓe, omo waajoo ɓe. ");
INSERT INTO fuh_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Wakkati mum tawi Yahaaya gaɗoowo *batisma no nder kasu. Sey o nani ko *Almasiihu gollata, nden o lili *aahiiɓe makko he Iisa. ");
INSERT INTO fuh_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ɓe ngari, ɓe ƴami Iisa, ɓe mbi'i : —Aan woni *Almasiihu bi'aaɗo waran oon, naa min ndooma goɗɗo ? ");
INSERT INTO fuh_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Iisa jaabii ɓe, wi'i : —Njehee, kaalanowee Yahaaya ko nanuɗon he ko ngi'uɗon fuu : ");
INSERT INTO fuh_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Wumɓe no mbumtaa, laƴooɓe no njaha faa wooɗa, seppinɓe no nyawtee, pahuɓe no pahitee, maayɓe no ummintinee, talkaaɓe duu no pillanee *Habaru lobbo. ");
INSERT INTO fuh_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Barkinaaɗo woni mo salaaki goonɗinde kam. ");
INSERT INTO fuh_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Wakkati aahiiɓe Yahaaya ɓeen ndillunoo, Iisa fuɗɗi fillanaade jama'aare ndeen filla Yahaaya, o ƴami ɓe, o wi'i : —Ko njaanoɗon nder ladde yeeruure, ɗume ndaaroyɗon ? Huɗo ko henndu wifata ndaaroyɗon ? ");
INSERT INTO fuh_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Naa ɗume njaaɗon daaroyde ? Oɗon miila ngi'on gorko ɓorniiɗo koltal nyaaƴo naa ? Ɓornotooɗo koltal nyaaƴo nder ɓaade laamiiɗo tawetee. ");
INSERT INTO fuh_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ndenne, ɗume ndaaroyɗon ? Naa annabiijo njaaɗon daaroyde ? Too, miɗo haalana on, Yahaaya no ɓuri annabiijo. ");
INSERT INTO fuh_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Kanko woni mo haala Alla wi'i dow mum har hunnduko annabiijo gom : Ndaa, mi ardinan lilaaɗo am moƴƴinane laawol maaɗa. ");
INSERT INTO fuh_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Goonga kaalananmi on : Dimaaɗo waɗaay nder duuniyaaru nduu ɓurɗo Yahaaya gaɗoowo *batisma. Amma fuu nii, ɓurɗo famɗude nder Laamu Alla no ɓuri mo teddude. ");
INSERT INTO fuh_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Illa jamaanu Yahaaya gaɗoowo *batisma warde hannden, himɓe no kaɓa, no nyaamodira dow Laamu Alla sanne. Jom'en semmbe duu no tefa teeta ngu. ");
INSERT INTO fuh_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","*Tawreeta Muusa he dewte annabiiɓe fuu kaali dow Laamu nguun fadde jamaanu Yahaaya warde. ");
INSERT INTO fuh_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Nde nii on njaɓiino haala maɓɓe, Yahaaya woni Eliya, mo garol muuɗum hollaa. ");
INSERT INTO fuh_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Jom nowru fuu nana. ");
INSERT INTO fuh_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Amma he ɗume mbaawmi nanndinde himɓe jamaanu hannden oo ? Iɓe nanndi he sukaaɓe jooɗiiɓe nder luuɓe, no nodda higiraaɓe mum'en, no mbi'a : ");
INSERT INTO fuh_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","« Min puufanii on seeseeji, amma on mbomaay ! Min njimanii on jimi jurminiiɗi, amma on mboyaay ! » ");
INSERT INTO fuh_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ngam wakkati Yahaaya warnoo, omo suumoo, o yarataa cabiijam, amma wi'aama o laddaaɗo. ");
INSERT INTO fuh_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","*Ɓii-Neɗɗo duu wari, no nyaama, no yara, amma wi'aama : « Ndaaree neɗɗo oo, nyaamɗe he jarɗe tan adi hakkillo makko, o higo *jaɓooɓe janngal he waɗooɓe hakke ! » Dey goonɗinɓe anndal Alla no kolla nder mbuurnam mum'en ko laawol Alla no goonga. ");
INSERT INTO fuh_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Nden Iisa fuɗɗi felude himɓe gure ɗe o ɓuri waɗude kaayɗe nder mum, ngam wonɓe nder majje tuubaay. ");
INSERT INTO fuh_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Omo wi'a : —Bone saaman dow maa, aan Korasin ! Bone saaman dow maa, aan Baytisayda ! Ngam nde nii kaayɗe gaɗanooɗe nder mooɗon ɗeen, ngaɗanooma nder Tirus he nder Sidon, tawan wonɓe nder majje tuubinoo ila. Ɓe ɓoornakeno saakuuji, ɓe mbujakeno ndooni, ngam hollude ko ɓe tuubii. ");
INSERT INTO fuh_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ngam majjum, miɗo wi'a on : Nyannde darŋal, kiite mooɗon no ɓuran ɗe Tirus he Sidon naawde. ");
INSERT INTO fuh_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Aan duu Kafarnahum, aɗa miila a townetee faa dow naa ? Too, a leynetee faa laahara. Ngam nde nii kaayɗe gaɗanooɗe nder maaɗa ɗeen, ngaɗanooma nder *Sodooma, nden wuro ngoon no heddotonoo faa joonin. ");
INSERT INTO fuh_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ngam majjum, miɗo wi'a on : Nyannde darŋal, kiite mooɗon no ɓuran ɗe *Sodooma naawde. ");
INSERT INTO fuh_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Nder wakkati mum non Iisa haali, wi'i : —Mi yettii ma, *Baabiraawo jom dow he ley, ngam a suuɗanii jom'en hakkillo he anndal kujje ɗee fuu amma a wannginanii ɗe sukaaɓe famarɓe. ");
INSERT INTO fuh_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Noon non jaati *Baaba, ngam kanƴum welii ma. ");
INSERT INTO fuh_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","*Baaba am watti huune fuu nder juuɗe am. Walaa annduɗo Ɓiɗɗo oon nde hanaa *Baabiraawo oon. Walaa annduɗo *Baabiraawo oon duu nde hanaa Ɓiɗɗo oon, he mo Ɓiɗɗo oon muuyi wannginande *Baaba oon. ");
INSERT INTO fuh_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Onon tampuɓe, ronndiiɓe donle tedduɗe, on fuu ngaree to am, mi fowtinan on. ");
INSERT INTO fuh_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ɗowtanee kam baa ko ɗum hoyaa, accon mi janngina on. Ngam mi leesiniiɗo hoore, ɓerne am duu no feewi, yonkiiji mooɗon keɓan powtiri. ");
INSERT INTO fuh_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ngam ɗowtanaaki am nannduki ko satti no hoyi, donngal am duu no huyfi. ");
INSERT INTO fuh_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Balɗe seɗɗa gaɗa majjum, Iisa he *aahiiɓe muuɗum no peddita gese alkamaaje. Nyannde mum ɗum fototiri he *nyalaane fowteteene, *aahiiɓe ɓeen ndafaa, iɓe mborsoo camme alkama, iɓe ƴakka. ");
INSERT INTO fuh_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Wakkati *Fariisa'en ngi'unoo ɗum ndeen, ɓe mbi'i Iisa : —A hi'i *aahiiɓe maaɗa no ngaɗa ko haɗaa nder *nyalaane fowteteene ! ");
INSERT INTO fuh_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Nden o jaabii ɓe, o wi'i : —On njanngaay ko Daawda waɗunoo wakkati kanko he yaadiraaɓe makko fuu ndafanoo ? ");
INSERT INTO fuh_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","O naatidi he maɓɓe nder suudu Alla. Ɓe nyaami buuru ittanaaɗo Alla oon. Ɓe kaanaa nyaamude mo, *cakkanooɓe Alla tan kaani nyaamude mo. ");
INSERT INTO fuh_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Naa duu, on njanngaay nder *Tawreeta Muusa, ko baa nder *nyalaane fowteteene *cakkanooɓe Alla no ngolla nder *Juulirde mawne ndeen ? Nyannde mum iɓe lutta he tilsinooje nyalaane ndeen, amma ɓe pelirtaake ɗum. ");
INSERT INTO fuh_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Miɗo wi'a on ko ɓuri *Juulirde mawne ndeen no ɗo. ");
INSERT INTO fuh_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Nde nii on paaminoo ko haala Alla kaa fiirtata : Yurmeene ngiɗumi, hanaa *sadaka, nden on ndekataano gacce dow mo gaccaaka. ");
INSERT INTO fuh_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ngam *Ɓii-Neɗɗo woni jom *nyalaane fowteteene. ");
INSERT INTO fuh_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Iisa dilli toon, naatowi nder *waajordu maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Gorko gom mo junngo mum waati no tawa toon. Wonɓe ɗon ɓeen no tefa ko pelirta Iisa, nden ɓe ƴami mo ɓe mbi'i : —*Tawreeta hokki laawol neɗɗo nyawtee nder *nyalaane fowteteene naa hokkaay ? ");
INSERT INTO fuh_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Iisa jaabii ɓe, wi'i : —Alal misaali, oɗon ngoodi mbaalu mon ngootu, dey ngu saama nder luggere nder *nyalaane fowteteene, ndenne on mburtinoyta ngu naa ? ");
INSERT INTO fuh_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Oɗon anndi sanne ko neɗɗo no ɓuri mbaalu teddungal ! Ndenne, no dagii neɗɗo waɗanee ko wooɗi nder *nyalaane fowteteene. ");
INSERT INTO fuh_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Nden o wi'i gorko oon : —Foortu junngo maa ! Oon foorti ngo, ngo yamɗiti, ngo warti hano ngooto. ");
INSERT INTO fuh_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Sey *Fariisa'en mburtii, kawrowi ngam caawodira dow no ɓe mbardata Iisa. ");
INSERT INTO fuh_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Wakkati Iisa heɓunoo habaru majjum, o dilli toon, jama'aare mawne tokki mo. O nyawti nyawɓe ɓeen fuu, ");
INSERT INTO fuh_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","o wi'i ɓe to ɓe kaalan neɗɗo fuu moy o woni. ");
INSERT INTO fuh_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ɗum duu ngam humnude ko annabi *Esaaya haalunoo wakkati o wi'i : ");
INSERT INTO fuh_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Ndaa golloowo am mo cuɓiimi. Omo horsi he am, omo welna ɓerne am. Mi jippinan *Ruuhu am dow makko, o yottinan laawol dartinaaku to lenyol fuu. ");
INSERT INTO fuh_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","O yeddodirtaa he neɗɗo fuu, o olkataa. Daane makko nanataake dow laabi. ");
INSERT INTO fuh_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","O jokkititta ƴommbal kelngal, o nyifataa fitilla ka jeyngol muuɗum famɗi sey nii nyannde o waɗi dartinaaku jaali. ");
INSERT INTO fuh_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Lenyol fuu dekan gokka mum dow makko. ");
INSERT INTO fuh_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Wakkati gorko gom, mo ginnaaru wumni, beebi, waddaa to makko, Iisa nyawti mo. Gorko oon no hi'a, no haala. ");
INSERT INTO fuh_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ɗum haayɗini himɓe ɓeen fuu, nden ɓe tinni iɓe mbi'a : —Gorko oo, sikka fuu walaa o taanu Daawda. ");
INSERT INTO fuh_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Amma wakkati *Fariisa'en nanunoo ɗum ndeen, ɓe mbi'i : —Baawɗe Be'eljebul hooreejo ginnaaji, o riiwrata ɗi. ");
INSERT INTO fuh_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ngam Iisa no anndi miilooji maɓɓe, waɗi o wi'i ɓe : —Laamu fuu feccii ɗiɗi, no ɓoorodira ɓooyataa. Wuro fuu fecciingo naa ɓaade fuu fecciine pecce ɗiɗi, himɓe mum potataa, ɓe cankititto. ");
INSERT INTO fuh_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Nde nii Ibiliisa riiwi ginnaaji muuɗum, feccii hoore mum. Ndenne, noy laamu mum darortoo ? ");
INSERT INTO fuh_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Nde tawi Be'eljebul ndiiwiranmi ginnaaji, aahiiɓe mooɗon, ɗume ndiiwirta ɗi ? Ndenne, golleeji maɓɓe he hoore mum kollata ko on ngalaa goonga ! ");
INSERT INTO fuh_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Amma nde nii *Ruuhu Alla ndiiwiranmi ginnaaji, iɗum holla ko Laamu Alla wari to mooɗon. ");
INSERT INTO fuh_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Neɗɗo fuu waawaa naati wuro jom semmbe, teeta njawdi makko, nde nii hanaa no artu haɓɓi mo non ginan, nden hooƴa njawdi ndiin fuu. ");
INSERT INTO fuh_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Mo wondaa he am fuu no ganyo am. Mo wallataa kam mi hawra, joomum no cankitoowo. ");
INSERT INTO fuh_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ngam majjum, miɗo wi'a on : Hakkeeji himɓe he haalaaji mum'en bonɗi fuu no mbaawi yaafeede. Amma bonnuɗo innde *Ruuhu Ceniiɗo fuu yaafataake. ");
INSERT INTO fuh_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Neɗɗo fuu kaaluɗo ko boni dow *Ɓii-Neɗɗo, joomum no waawi yaafeede. Amma neɗɗo fuu kaaluɗo ko boni dow *Ruuhu Ceniiɗo, yaafataake hannden, yaafataake duu nder wakkati garoowo. ");
INSERT INTO fuh_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","—Nde nii lekki no wooɗi, ɓiɓɓe muuɗum mbooɗan. Nde lekki wooɗaa, ɓiɓɓe muuɗum mbooɗataa. Ngam lekki ɓiɓɓe mum annditirtee. ");
INSERT INTO fuh_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ɓiɓɓe bolle ! Noy mbaawirton haalude ko wooɗi tawee on bonɓe ? Ngam ko heewi nder ɓerne, hunnduko wurtinta. ");
INSERT INTO fuh_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Neɗɗo moƴƴuɗo, ko moƴƴi ko resi nder ɓerne mum, kam hunnduko mum wurtinta. Neɗɗo bonɗo duu, ko boni ko resi nder ɓerne mum, kam hunnduko mum wurtinta. ");
INSERT INTO fuh_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Miɗo wi'a on : Nyannde darŋal, neɗɗo fuu jaaboto ngam haalaaji muuɗum meereeji. ");
INSERT INTO fuh_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ngam neɗɗo fuu haalaaji muuɗum hiitortee. Ndenne, kanƴi ngatta neɗɗo dartiiɗo naa jukketeeɗo. ");
INSERT INTO fuh_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Nyannde gom, jannginooɓe *Tawreeta he *Fariisa'en gom mbi'i Iisa : —Moodibbo, miɗen ngiɗi kollaa min alaama ko Alla lili ma. ");
INSERT INTO fuh_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Iisa jaabii ɓe, wi'i : —Onon himɓe jamaanu bonɗo, mo hulataa Alla. Oɗon ngiɗi holleede alaama. Amma alaama fuu non on kollataake ko ƴaari alaama annabi Yunuusa. ");
INSERT INTO fuh_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ngam no Yunuusa waɗiri balɗe tati jemma he nyalooma nder reedu linngu manngu nguun, hano non *Ɓii-Neɗɗo duu waɗirta balɗe tati jemma he nyalooma nder leydi. ");
INSERT INTO fuh_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Nyannde darŋal, himɓe Niniwe ummodoto he himɓe jamaanu hannden. Ɓe kiitodoo he maɓɓe, ɓe liɓa ɓe, ngam kamɓe, ɓe tuubii wakkati ɓe nanunoo waaju Yunuusa. Haya, ɓurɗo Yunuusa nii ɗo ! ");
INSERT INTO fuh_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Nyannde darŋal, debbo laamiiɗo leydi hoore huɗo gom ummodoto he himɓe jamaanu hannden oo. O hiitodo he maɓɓe, o liɓa ɓe. Debbo oo ƴuwi faa to woɗɗi, wari ngam hettinaade haalaaji Suleymaanu keewɗi hikmaaku. Haya, ɓurɗo Suleymaanu nii ɗo ! ");
INSERT INTO fuh_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","—Nde nii ginnaaru wurtake neɗɗo, ndu yahan indu warta. Ndu tefan nokkuuje joorɗe to ndu fowtata, amma ndu heɓataa. ");
INSERT INTO fuh_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Nden ndu wi'a : « Ndaa, mi soƴƴoto wuro am to ƴuwnoomi. » Nde nii ndu wartii, ndu tawaa, nokkuure ndeen wuuwaama, moƴƴinaama. ");
INSERT INTO fuh_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Nden ndu yaha, ndu waddowa ginnaaji jeɗɗi ɓurɗi ndu bonde gom. Ɗi naata, ɗi koɗa nder wuro ngoon. Sakitoo mbuurnam neɗɗo mo ndu wurtinoo nder mum oon ɓura ɗam arannde ɗam bonde. Nii himɓe jamaanu bonɗo oo laatortoo. ");
INSERT INTO fuh_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Wakkati Iisa haaldannoo he jama'aare ndeen, sey inniiko he minyiraaɓe makko worɓe njottii, ɓe ndarii yaasin. Iɓe ngiɗi hi'ude mo. ");
INSERT INTO fuh_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Sey goɗɗo wi'i mo : —Ndaa, inna maa he rimdaaɓe maaɗa no ndarii yaasin, no ngiɗi ngi'e. ");
INSERT INTO fuh_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","O jaabii neɗɗo oon, o wi'i mo : —Moy woni inna am ? Ɓeye ngoni rimdaaɓe am ? ");
INSERT INTO fuh_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","O sappii *aahiiɓe makko ɓeen, o wi'i : —Ndaaree inna am he rimdaaɓe am nii. ");
INSERT INTO fuh_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Gaɗoowo muuyɗe *Baabiraawo am gonɗo dow, kam woni dimdaaɗo am, kam woni inna am. ");
INSERT INTO fuh_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Nyannde mum, Iisa no wonnoo nder suudu sey o wurtii, o jooɗowii daane peta Galili. ");
INSERT INTO fuh_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Jama'aare mawne gom wari, fiilii mo, ngam majjum o naatowi laana ndiyam o jooɗii. Himɓe ɓeen ndarii hunnduko maayo ngoon. ");
INSERT INTO fuh_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","O haalani ɓe kujje keewɗe nder kippol haala. Omo wi'a : —Aawoowo gom dilli faa aawowa aawdiiri mum. ");
INSERT INTO fuh_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Nder aawre ndeen, gabbe gom caami sera laawol. Nden pooli ngari coppi ɗe. ");
INSERT INTO fuh_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Gere majje caami nder korkaaƴe to leydi ɗuuɗaa. Ɗe puɗilawi ngam luggiɗaa sanne. ");
INSERT INTO fuh_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Amma wakkati naange wulnoo ndeen, ɗe ɗayli, ɗe njoori ngam ɗe ngaɗaay ɗaɗi. ");
INSERT INTO fuh_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Gere majje caami to kebbe puɗata. Kebbe ɗeen mawni, nanngi ɗe. ");
INSERT INTO fuh_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Gere majje duu caami nder leydi lobbiri. Ɗe puɗi, ɗe ndimi : Wassaaŋo gom rimi camme hemre, wonngo lasooji tati, wonngo duu woronja. ");
INSERT INTO fuh_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Jom nowru fuu nana ! ");
INSERT INTO fuh_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Sey *aahiiɓe ɓeen ɓattii, ƴami mo, mbi'i : —Ɗume waɗi ko aɗa haalana ɓe kujje ɗee nder kippol haala ? ");
INSERT INTO fuh_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Nden Iisa jaabii ɓe, wi'i : —Onon, Alla hokkii on baawɗe anndude ko suuɗi dow habaru Laamu muuɗum. Amma kamɓe, ɓe kokkaaka ɗum. ");
INSERT INTO fuh_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ngam jogiiɗo fuu, no ɓeydantee faa heewa. Amma mo walaa oon, baa seɗɗa mo jogii oon, no teetetee. ");
INSERT INTO fuh_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ko waɗi miɗo haalana ɓe kujje ɗee nder kippol haala woni : Baa nde ɓe ndaari, ɓe ngi'ataa, baa nde ɓe kettinake, ɓe nanataa, ɓe paamataa. ");
INSERT INTO fuh_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Hakiika ko annabi *Esaaya haalunoo dow maɓɓe ɗum tabbiti, wakkati wi'unoo ɓe : On nanan faa wooɗa, amma on paamataa. On ndaaran faa wooɗa, amma on ngi'ataa. ");
INSERT INTO fuh_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ngam himɓe lenyol ngool no njoori ɓerɗe : Ɓe cukkii noppi maɓɓe, ɓe maɓɓii gite maɓɓe, ngam to gite maɓɓe ngi'u, to noppi maɓɓe nanu, to hakkillooji maɓɓe paamu, to ɓe tuubu sako mi danna ɓe. ");
INSERT INTO fuh_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Amma onon, on welɓe ko'e. Gite mooɗon ngi'an, noppi mooɗon duu nanan ! ");
INSERT INTO fuh_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Goonga kaalananmi on, annabiiɓe heewɓe he dartiiɓe ɗuɓɓe muuyiino hi'ude ko ngi'oton ɗum, amma ɓe ngi'aay ɗum. Ɓe muuyiino hettinaade ko nanuɗon ɗum, amma ɓe nanaay ɗum. ");
INSERT INTO fuh_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Nden Iisa wi'i *aahiiɓe mum : —Kettinee piirtol kippol haala dow aawoowo ngool nii. ");
INSERT INTO fuh_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Sera laawol to aawdiiri ndiin saami woni nanuɓe haala Laamu Alla, dey paamaay ka. Gaɗa mum bonɗo oon waran, ɗoofa ko aawaa nder ɓerne maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Korkaaƴe to aawdiiri ndiin saami woni nanuɓe haala kaan, njaɓɓorii ka welwelo wakkati mum da. ");
INSERT INTO fuh_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Amma ngam ka waɗaay ɗaɗi nder maɓɓe, ɓe nanngan ka wakkati seɗɗa tan. Nde nii ɓe ɓillake naa nde nii ɓe torraama ngam makka, ɓe mboppan ka wakkati mum da. ");
INSERT INTO fuh_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","To kebbe puɗidi aawdiiri ndiin woni nanuɓe haala kaan, amma sakkulla duuniyaaru he suuno njawdi kuman ka nder maɓɓe, ka laatoo ndimara. ");
INSERT INTO fuh_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Leydi lobbiri to aawdiiri ndiin saami woni nanuɓe haala kaan, paamii ka faa ɓe ngaɗi barke : Woɓɓe kile hemre, woɓɓe kile lasooji tati, woɓɓe duu kile woronja. ");
INSERT INTO fuh_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Iisa waɗani ɓe kippol haala gom, wi'i ɓe : —Ndaa no Laamu Alla nanndi nii : Gorko gom wicci aawdiiri alkama lobbiri nder ngesa muuɗum. ");
INSERT INTO fuh_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Amma wakkati himɓe fuu ɗaaninoo ndeen, ganyo makko gom wari, wicci huɗo bonko nder magga, dilli. ");
INSERT INTO fuh_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Wakkati aawdiiri ndiin fuɗunoo ndeen faa ndi fii camme, huɗo bonko koon wanngi. ");
INSERT INTO fuh_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Maccuɓe jom ngesa oon mbi'owi mo : « Alla sabbinane, hanaa aawdiiri lobbiri aawuɗaa naa ? Ndenne toy huɗo bonko koo ƴuwi ? » ");
INSERT INTO fuh_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","O jaabii ɓe, o wi'i : « Ganyo gom waɗi ɗum. » Nden maccuɓe ɓeen ƴami mo, mbi'i : « Aɗa hiɗi min ɗoofowa ko naa ? » ");
INSERT INTO fuh_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Amma o jaabii ɓe, o wi'i : « Aa'a, ngam nde nii oɗon ɗoofa ko, on ɗoofidan ko he alkama oon. ");
INSERT INTO fuh_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Accidee ko he alkama oon faa kettol. Nden, mi wi'an hettooɓe ɓeen ɗoofa ko ginan, ɓe kaɓɓa ko kaɓɓe kaɓɓe faa ko wulee, nden ɓe ketta alkama oon, ɓe kawra mo nder ƴeelu am. » ");
INSERT INTO fuh_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Iisa waɗani ɓe kippol haala gom, wi'i ɓe : —Laamu Alla no nanndi he wabbere mutaari nde neɗɗo hooƴi, aawi nder ngesa muuɗum. ");
INSERT INTO fuh_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Wabbere ndeen woni ɓurde gabbe fuu famɗude, amma nde nii nde fuɗi, nde ɓuran leɗɗe koogol ngool fuu. Nde laatoto lekki mawki faa pooli ngara nyiɓa cuuɗi mum'en dow licce makki. ");
INSERT INTO fuh_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Iisa waɗani ɓe kippol haala gom kaden, wi'i ɓe : —Laamu Alla no nanndi he ƴuufinirɗum ko debbo budi nder muddiiji conndi alkama tati mawɗi faa ɗum fuu ɗum ƴuufi. ");
INSERT INTO fuh_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Iisa haalani ɓe kujje ɗee fuu nder kippol haala. Walaa fuu ko o haalani ɓe ko hanaa nder kippol haala o haali ɗum. ");
INSERT INTO fuh_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","O waɗiri non duu ngam tabbintinde haala kaa annabiijo gom haalunoo wakkati wi'unoo : Mi haaldan he himɓe nder kippol haala, mi haalanan ɓe kujje cuuɗaaɗe fadde duuniyaaru tageede. ");
INSERT INTO fuh_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Iisa ummii, acci himɓe ɓeen, naatowi nder suudu. *Aahiiɓe makko ɓattii mo, mbi'i mo : —Fiirtan min kippol haala ngool. ");
INSERT INTO fuh_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Nden o jaabii ɓe, o wi'i : —Aawɗo aawdiiri lobbiri ndiin, oon woni *Ɓii-Neɗɗo. ");
INSERT INTO fuh_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ngesa ngaan duu woni duuniyaaru. Aawdiiri lobbiri ndiin woni ɓiɓɓe Laamu Alla. Huɗo bonko koon woni ɓiɓɓe bonɗo oon. ");
INSERT INTO fuh_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ganyo jom ngesa oon woni Ibiliisa. Kettol ngool woni timmoode duuniyaaru, hettooɓe ɓeen ngoni maleykaaɓe. ");
INSERT INTO fuh_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Hano no huɗo koon ittirtee, faɗɗee nder hiite nii, hano non timmoode duuniyaaru duu laatortoo. ");
INSERT INTO fuh_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","*Ɓii-Neɗɗo lilan maleykaaɓe muuɗum, kawra itta nder laamu mum waɗooɓe woɓɓe ngaɗa hakke ɓeen, he waɗooɓe ko boni fuu. ");
INSERT INTO fuh_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ɓe paɗɗee nder kaatane hiite nge nyifataa. Toon ɓe mbuletee, iɓe ŋerƴodira nyiiƴe. ");
INSERT INTO fuh_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Amma wakkati mum, dartiiɓe ɓeen no ƴelkiɗan hano naange nder Laamu *Baabiraawo mum'en. Jom nowru fuu, nana ! ");
INSERT INTO fuh_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Iisa waɗi kippol haala gom wi'i kaden : —Laamu Alla no nanndi he njawdi cuuɗiini nder ngesa. Gorko gom hiiti ndi, suuɗitini, suuɗi kam duu. Nder welwelo makko, o yehi, o sottowi ko o joginoo fuu, nden o soodi ngesa ngaan. ");
INSERT INTO fuh_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Laamu Alla no nanndi kaden he luumotooɗo tefoowo kaaƴe dime. ");
INSERT INTO fuh_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Nde joomum hi'i hayre rimre soodeteene law, joomum no yahan sonnowa ko jogii fuu nden sooda nde. ");
INSERT INTO fuh_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Iisa waɗi kippol haala gom kaden wi'i : —Laamu Alla no nanndi he taaruwol paɗɗaangol nder maayo, dey nanngi iri liƴƴi fuu. ");
INSERT INTO fuh_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Wakkati taaruwol ngool heewunoo, nanngooɓe liƴƴi ɓeen pooɗi ngol faa he hunnduko ndiyam. Ɓe njooɗii, iɓe cennda liƴƴi ɗiin. Liƴƴi lobbi ɗiin no ngattee nder kandeeje, bonɗi ɗiin duu no paɗɗee. ");
INSERT INTO fuh_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Hano non timmoode duuniyaaru ndu laatortoo. Maleykaaɓe ngaran cennda bonɓe he dartiiɓe. ");
INSERT INTO fuh_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ɓe paɗɗan bonɓe ɓeen nder hiite jahannama, toon ɓe mbuletee, iɓe ŋerƴodira nyiiƴe. ");
INSERT INTO fuh_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Iisa ƴami ɓe, wi'i : —On paamii maana ɗum fuu naa ? Nden ɓe njaabii mo, ɓe mbi'i : —Ayyo, min paamii. ");
INSERT INTO fuh_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Sey, o wi'i ɓe : —Jannginoowo *Tawreeta fuu laatiiɗo aahiijo nder Laamu Alla, no nanndi he jom ɓaade keɓoowo nafakka nder kujje kese he kujje kiɗɗe. ");
INSERT INTO fuh_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Wakkati Iisa hanti kippi haala mum, ummii, ");
INSERT INTO fuh_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","hooti nder Nasaratu, wuro ngo o mawnunoo nder mum. Omo waajoo nder *waajordu maɓɓe. Ɗum haayɗini hettinaniiɓe mo ɓeen sanne, ɓe tinni iɓe mbi'a : —Toy o heɓi anndal ngal ? Noy o heɓiri baawɗe waɗude kaayɗe ɗee ? ");
INSERT INTO fuh_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Hanaa ya kanko woni ɓii sekkeejo oon ? Hanaa Mariyaama woni inniiko ? Hanaa kanko woni mawnu Yakuuba, Yusufu, Simon he Yahuuda'en ? ");
INSERT INTO fuh_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Hanaa enen he minyiraaɓe makko rewɓe ngondi ? Ndenne, moy hokki mo anndal ngaal he baawɗe ɗee fuu ? ");
INSERT INTO fuh_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ngam majjum waɗi ɓe calii mo. Amma Iisa wi'i ɓe : —Annabiijo no teddinee nder nokkuuje fuu, dey hanaa nder wuro muuɗum he ɓaade muuɗum. ");
INSERT INTO fuh_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Iisa waɗaay toon kaayɗe ɗuɗɗe ngam ɓe ngoonɗinaay mo. ");
INSERT INTO fuh_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Wakkati *Hirudus, laamiiɗo leydi Galili, nanunoo filla Iisa no waɗee. ");
INSERT INTO fuh_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Sey o wi'i gollooɓe makko : —Yahaaya gaɗoowo *batisma ! Maayɗo oon, kam ummitii. Ngam majjum waɗi, omo jogii baawɗe waɗude kaayɗe. ");
INSERT INTO fuh_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","*Hirudus haɓɓani Hirudiya dee-mawnum Filipa. Sey Yahaaya duu wi'i ɗum daganaaki mo. Ngam majjum *Hirudus duu tilsini Yahaaya nanngee, haɓɓee, uddee nder kasu. ");
INSERT INTO fuh_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","*Hirudus no hiɗi wara Yahaaya amma suusaa, ngam himɓe fuu no mbi'a o annabiijo. ");
INSERT INTO fuh_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ko wakkati nyalaane miccintinoore dimeeki *Hirudus yottinoo, ɓii-Hirudiya debbo womi yeeso noddaaɓe-ngari to juulɗe ɗeen. *Hirudus nani belɗum majjum sanne, ");
INSERT INTO fuh_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","faa hunii no hokkan mo huune fuu ko o eeli ɗum. ");
INSERT INTO fuh_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Surbaajo oon tokki haala innum, wi'i *Hirudus : —Waddanam jooni jooni hoore Yahaaya gaɗoowo *batisma nder le'al ! ");
INSERT INTO fuh_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ɗum naawi ɓerne *Hirudus, amma ko heƴi o huni ɗum yeeso noddaaɓe ɓeen, tilay makko o hokka laawol surbaajo oon hokkee ko ŋaarii ɗum. ");
INSERT INTO fuh_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","O lili goɗɗo yaha nder kasu oon, taƴowa hoore Yahaaya. ");
INSERT INTO fuh_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Hoore ndeen taƴaa, tummbaa nder le'al, nde hokkaa suka debbo oon. Kam duu hokkowi nde innum. ");
INSERT INTO fuh_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Aahiiɓe Yahaaya ɓeen ngari kooƴi ɓanndu makko, mooɓowi. Nden ɓe njehi, ɓe kaalanowi Iisa ko waɗi. ");
INSERT INTO fuh_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Wakkati Iisa nanunoo habaru maayde Yahaaya ndeen, o ummii kanko tan o dilli, o naatowi nder laana ndiyam, o fa'i nokkuure yeewne gom. Wakkati himɓe nanunoo ɗum ndeen, mburtii nder gure takkiiɗe daane peta ngaan, tokki mo. ");
INSERT INTO fuh_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Wakkati o wurtinoo nder laana kaan, o hi'i jama'aare mawne no hawri. Ɓe njurminii mo sanne. O nyawti nyawɓe wonɓe nder maɓɓe fuu. ");
INSERT INTO fuh_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Wakkati hiirunoo ndeen, *aahiiɓe ɓeen ɓattii Iisa, mbi'i mo : —Joonin kay futuro waɗi, nokkuure ndee duu no ladde. Accu jama'aare ndeen yaha, naatowa nder gure ngam coodowa ko nyaamata. ");
INSERT INTO fuh_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Iisa jaabii ɓe, wi'i : —Fotaay ɓe njaha nder gure. Onon he ko'e mooɗon, kokkee ɓe ko ɓe nyaamata. ");
INSERT INTO fuh_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ɓe njaabii mo, ɓe mbi'i : —Buuruuje joy he liƴƴi ɗiɗi tan min njogii. ");
INSERT INTO fuh_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","O wi'i ɓe : —Ngaddanee kam ɗum ɗo. ");
INSERT INTO fuh_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","O wi'i himɓe ɓeen njooɗoo dow huɗo koon. O hooƴi buuruuje joy ɗeen he liƴƴi ɗiɗi ɗiin, o tiggitii, o yetti Alla. O helti buuruuje ɗeen, o hokki *aahiiɓe ɓeen kokka jama'aare ndeen. ");
INSERT INTO fuh_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ɓe fuu ɓe nyaami faa ɓe kaari. *Aahiiɓe ɓeen kawri kelte koddiiɗe ɗeen. Ɗum hebbini kandeeje sappo he ɗiɗi. ");
INSERT INTO fuh_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Nyaamuɓe ɓeen no ngaɗa hano worɓe ujunaaji joy mbaka rewɓe he sukaaɓe ɓeen ngalaa. ");
INSERT INTO fuh_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Wakkati mum da, o hokki laawol *aahiiɓe ɓeen naata nder laana kaan, ardoo, peddita peta ngaan, fadde makko waynaade jama'aare ndeen. ");
INSERT INTO fuh_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Gaɗa waynitaaki jama'aare ndeen, o ƴeenyowi dow waamnde ngam du'aade kanko tan. Naange yani, tawi mo dow mayre. ");
INSERT INTO fuh_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Laana *aahiiɓe ɓeen duu woɗɗowake. Ika dilli yahde ika fotta he henndu, sey benkeƴƴe puɗɗi no piya ka. ");
INSERT INTO fuh_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Wakkati ɓadinoo weetude, o wari to *aahiiɓe ɓeen, omo dilla he koyɗe dow ndiyam ɗaam. ");
INSERT INTO fuh_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Amma wakkati *aahiiɓe ɓeen ngi'unoo omo dilla he koyɗe dow ndiyam ɗaam, ɓerɗe maɓɓe taƴi, ɓe mbi'i : —Mbeelu maayɗo non ! Ɓe kuli kulal manngal. ");
INSERT INTO fuh_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Wakkati mum da Iisa wi'i ɓe : —Pukkinee hakkillooji mooɗon ! Miin non. To kulee ! ");
INSERT INTO fuh_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Sey Piyer jaabii mo, wi'i : —Joomam, nde nii aan non, waɗu mi wara to maa. ");
INSERT INTO fuh_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Iisa jaabii mo, wi'i : —War ! Piyer wurtii laana kaan, no yaaɓa dow ndiyam ɗaam, no fa'i to Iisa. ");
INSERT INTO fuh_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Amma wakkati o hi'unoo henndu nduun sattii sanne ndeen, o huli, sey o fuɗɗi yoolaade, nden o huuɓi, o wi'i : —Joomam, hisinam ! ");
INSERT INTO fuh_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Wakkati mum da, Iisa foorti junngo mum, nanngi mo, wi'i : —Hey pamɗuɗo goonɗinol, ko waɗi cikkuɗaa ? ");
INSERT INTO fuh_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Gaɗa mum ɓe fuu ɗiɗo, ɓe naati laana kaan, sey henndu nduun duu darii. ");
INSERT INTO fuh_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Nden *aahiiɓe wonɓe nder laana kaan cujidani mo, mbi'i : —Hakiika, aan woni *Ɓii-Alla ! ");
INSERT INTO fuh_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Wakkati ɓe pedditinnoo peta ngaan, ɓe njottii leydi Genesaret. ");
INSERT INTO fuh_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Himɓe wuro ngoon fuu annditi mo, ɓe ngaɗi lilaaɓe leydi ndiin fuu haalanee garki makko. Himɓe ɓeen ngaddani mo nyawɓe mum'en fuu. ");
INSERT INTO fuh_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ɓe eeli mo o acca nyawɓe ɓeen meema baa nii hunnduko jabbaare makko tan. Meemuɗo nde fuu nyawti. ");
INSERT INTO fuh_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","*Fariisa'en he jannginooɓe *Tawreeta ƴuwi *Ursaliima, ngari to Iisa ƴami mo, mbi'i : ");
INSERT INTO fuh_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—Ɗume waɗi ko *aahiiɓe maaɗa tokkataa laabi finaa-tawaaji maamiraaɓe meeɗen ? Ɓe lootataa juuɗe maɓɓe fadde maɓɓe nyaamude. ");
INSERT INTO fuh_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Sey Iisa jaabii ɓe, wi'i : —Onon nee, ɗume waɗi ko on tokkataa tilsinooje Alla, oɗon tokka finaa-tawaaji mooɗon ? ");
INSERT INTO fuh_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ngam Alla wi'i : Teddin inna maa he bammaa. O wi'i kaden : Kuɗuɗo innum naa bammum fuu no haani wareede. ");
INSERT INTO fuh_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Amma onon, oɗon njanngina ko neɗɗo no waawi wi'ude innum naa bammum, kam sakkani Alla ko haani wallirde ɓe ɗum. ");
INSERT INTO fuh_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Oɗon mbi'a fotaay joomum teddina saarooɓe muuɗum. Ndenne ngam sabbu finaa-tawaaji mooɗon, oɗon ngartira haala Alla meere ! ");
INSERT INTO fuh_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Munaafiki'en ! *Esaaya woofaay sam wakkati o waɗunoo annabaaku dow mooɗon. ");
INSERT INTO fuh_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Nder maggu Alla wi'i : Himɓe ɓee no mbi'an kam'en no teddina kam, amma ɓerɗe maɓɓe no mboɗɗi kam. ");
INSERT INTO fuh_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Dewal maɓɓe no meere ngam ko ɓe ngoni iɓe njanngina ɗum to ɓiɓɓe aadama ƴuwi. ");
INSERT INTO fuh_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Nden Iisa noddi jama'aare ndeen, wi'i nde : —Kettinee. ");
INSERT INTO fuh_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Paamee ko hanaa ko naatata nder hunnduko neɗɗo, tunninta ɗum, amma ko wurtotoo nder makko. ");
INSERT INTO fuh_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Sey *aahiiɓe ɓeen ɓattii mo, mbi'i : —Aɗa anndi ko haalaaji maaɗa ɗiin metti ɓerɗe *Fariisa'en ? ");
INSERT INTO fuh_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Nden Iisa jaabii ɓe, wi'i : —Wasaango fuu ngo *Baaba am gonɗo dow aawaay, no ɗoofetee. ");
INSERT INTO fuh_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Accee ɓe, ɓe wumɓe ɗowooɓe wumɓe ! Nde bumɗo ɗowi bumɗo, sey ɓe fuu ɗiɗo ɓe caamowan nder ngayka. ");
INSERT INTO fuh_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Sey Piyer wi'i mo : —Fiirtan min banndol ngool. ");
INSERT INTO fuh_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Nden Iisa jaabii mo wi'i : —Onon duu, faa hannden ɗum laaɓanaay on naa ? ");
INSERT INTO fuh_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","On anndaa ko naati nder hunnduko fuu no yahan nder reedu, gaɗa mum ɗum yehee gaɗa wuro naa ? ");
INSERT INTO fuh_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Amma ko wurtotoo nder hunnduko ɗum, nder ɓerne ɗum ƴuwata, kanƴum jaati tunninta neɗɗo. ");
INSERT INTO fuh_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ngam nder ɓerne neɗɗo miilooji bonɗi, uppooji neɗɗo itta yonki, yeena, fija, wujja, seedo dow fewre, he mbonka fuu ƴuwata. ");
INSERT INTO fuh_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ɗum woni ko tunninta neɗɗo. Amma nyaama tawee lootaay juuɗe muuɗum hano no finaa-tawaaji wi'iri ɗum nii tunnintaa neɗɗo. ");
INSERT INTO fuh_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Nyannde gom Iisa ummidii *aahiiɓe mum, fonndi seraaji Tirus he Sidon. ");
INSERT INTO fuh_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Sey Kanananke debbo gom tawaaɗo nder seraaji ɗiin waddi bojji mum to makko, wi'i : —Joomam, taan Daawda, yurmam ! Ɓiyam debbo, ginnaaru woni dow mum, indu torra mo sanne ! ");
INSERT INTO fuh_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Amma Iisa jaabaaki mo. Nden *aahiiɓe ɓeen ɓattii mo, mbi'i : —Riiwu debbo oo, omo nii gaɗa meeɗen, omo wulla. ");
INSERT INTO fuh_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Sey Iisa jaabii ɓe, wi'i : —Ngam baali *Isra'el majjuɗi ɗiin waɗi lilaami. ");
INSERT INTO fuh_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Nden debbo oon wari, sujidi yeeso makko, wi'i : —Joomam, wallam ! ");
INSERT INTO fuh_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Iisa jaabii mo, wi'i : —Hegaaki neɗɗo hooƴa nyaamdu sukaaɓe, faɗɗana dawaaɗi. ");
INSERT INTO fuh_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Debbo oon jaabitii mo, wi'i kaden : —Goonga non, Joomam. Amma dawaaɗi duu no nyaama nyaamdu joomiraaɓe mum'en ɓiltotoondu nder le'e maɓɓe no saama. ");
INSERT INTO fuh_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Nden, Iisa jaabii mo, wi'i : —Goonɗinol maa ngool no mawni ! Ɗum laatane no ngiɗirɗaa fuu. Nder wakkati mum, ɓiyiiko debbo nyawti. ");
INSERT INTO fuh_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Iisa dilli Tirus he Sidon, o tokkitii daane peta Galili yahde. O ƴeenyi waamnde gom, o jooɗowi toon. ");
INSERT INTO fuh_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Himɓe heewɓe ngari to makko, ngaddani mo laƴooɓe, wumɓe, larɗuɓe, pahuɓe, he nyawɓe heewɓe. Ɓe ngaddi ɓe yeeso makko, nden o nyawti ɓe. ");
INSERT INTO fuh_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Wakkati ɓe ngi'unoo pahuɓe ɓeen no kaala, larɗuɓe ɓeen no larɗita, laƴooɓe ɓeen no laƴita, wumnooɓe ɓeen no ngi'a. Ɗum haayɗini ɓe sanne. Ɓe tinni iɓe njetta Alla mo *Isra'el. ");
INSERT INTO fuh_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Iisa noddi *aahiiɓe mum, wi'i ɓe : —Himɓe ɓee no njurminii. Balɗe tati nii hannden ko iɓe ngondi he am, ɓe ngalaa fuu ko nyaamee. Mi hiɗaa ɓe ndilla tawee ɓe nyaamaay, to rafo liɓoy ɓe dow laawol. ");
INSERT INTO fuh_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Nden *aahiiɓe ɓeen mbi'i mo : —Toy keɓeten ko nyamni jama'aare ndee fuu nder ladde yeeruure ndee ? ");
INSERT INTO fuh_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Sey o ƴami ɓe, o wi'i : —Buuruuje foti njogiɗon ? Ɓe njaabii mo, ɓe mbi'i : —Buuruuje jeɗɗi, he likkoy seɗɗa min njogii. ");
INSERT INTO fuh_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Nden o wi'i jama'aare ndeen jooɗoo he leydi. ");
INSERT INTO fuh_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","O hooƴi buuruuje jeɗɗi ɗeen he likkoy koy. O yetti Alla, o helti ɗe, o hokki *aahiiɓe ɓeen, njeddani jama'aare ndeen. ");
INSERT INTO fuh_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ɓe fuu ɓe nyaami faa ɓe kaari. *Aahiiɓe ɓeen kawri kelte ɗeen, ɗe kebbini kandeeje jeɗɗi. ");
INSERT INTO fuh_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Worɓe nyaamuɓe ɓeen tan no ngaɗa ujunaaji nayo, sukaaɓe he rewɓe ɓeen ngalaa nder. ");
INSERT INTO fuh_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Gaɗa Iisa waynii himɓe ɓeen, o naati laana, o fa'i leydi Magadan. ");
INSERT INTO fuh_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","*Fariisa'en he *Sadduki'en gom ngari to Iisa faa tunna mo. Ɓe ŋaarii mo o holla ɓe alaama kaayɗiniiɗo ƴuwɗo dow kolloowo ko Alla lili mo. ");
INSERT INTO fuh_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Nden o jaabii ɓe, o wi'i : —Wakkati naange hiɗi yanude, kammu no wojji, oɗon mbi'a nyalooma jaaŋo oon no welan. ");
INSERT INTO fuh_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Illa beete duu, nde duule boɗeeje ƴeenyi, faa kammu niɓɓi, oɗon mbi'a hannden ndiyam no toɓan. Oɗon mbaawi senndodirde alamaaji kammu, amma on mbaawaa senndodirde alamaaji wakkatiiji ! ");
INSERT INTO fuh_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Himɓe jamaanu bonɗo mo hulataa Alla ngiɗi holleede alaama. Alaama fuu non on kollataake ko ƴaari alaama annabi Yunuusa. Nden o dilli, o acci ɓe. ");
INSERT INTO fuh_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Wakkati *aahiiɓe ɓeen pedditannoo peta Galili, ɓe njeggiti ɓe pantiraay buuru gaɗa maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Nden Iisa wi'i ɓe : —Kakkilee, paddee ko'e mooɗon he ƴuufinirɗum *Fariisa'en he *Sadduki'en oo. ");
INSERT INTO fuh_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Sey *aahiiɓe ɓeen puɗɗi no mbi'odira : —Ngam en pantiraay buuru, waɗi omo wi'a haalaaji ɗii. ");
INSERT INTO fuh_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Iisa faami ko ɓe ngoni iɓe kaala, nden o wi'i ɓe : —Onon famɗuɓe goonɗinol ! Ɗume waɗi oɗon mbi'odira hakkune mooɗon ngam on ngalaa buuru non ? ");
INSERT INTO fuh_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","On paamaay faa hannden ? On njeggitani buuruuje joy, ɗe njeddanmi worɓe ujunaaji joyo ɗeen naa ? Nyannde mum kandeeje foti kebbinirɗon kelte buuru oon ? ");
INSERT INTO fuh_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","On njeggitani kaden buuruuje jeɗɗi, ɗe njeddanmi worɓe ujunaaji nayo ɗeen naa ? Nyannde mum kandeeje foti kebbinirɗon kelte ɗeen ? ");
INSERT INTO fuh_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Noy waɗi ko on paamaay, hanaa haala buuru kaalananmi on ? Mi wi'aana paddoɗon ko'e mooɗon he ƴuufinirɗum *Fariisa'en he *Sadduki'en. ");
INSERT INTO fuh_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Nden *aahiiɓe ɓeen paami ko o wondaa ƴuufinirɗum tawaaɗo nder buuru oon, amma ɓe kakkilo he ko *Fariisa'en he *Sadduki'en njannginta. ");
INSERT INTO fuh_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Wakkati Iisa yottinoo nder leydi Kaysariya Filipi. O ƴami *aahiiɓe makko, o wi'i : —Moy himɓe mbi'ata *Ɓii-Neɗɗo oon woni ? ");
INSERT INTO fuh_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Sey ɓe njaabii mo, ɓe mbi'i : —Woɓɓe no mbi'a a Yahaaya gaɗoowo *batisma. Woɓɓe no mbi'a a Eliya. Woɓɓe duu kaden no mbi'a a Yeremiya naa a gooto nder annabiiɓe. ");
INSERT INTO fuh_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Nden Iisa ƴami ɓe wi'i : —Dey onon nee, moy mbi'oton ngonmi ? ");
INSERT INTO fuh_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Sey Simon Piyer jaabii mo, wi'i : —Aan, a *Almasiihu, *Ɓii-Alla duumiiɗo. ");
INSERT INTO fuh_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Nden Iisa wi'i mo : —Aan Simon ɓii-Yunuusa, a barkinaaɗo. Ngam hanaa ɓii-aadama wannginani ma ɗum, amma *Baabiraawo am gonɗo dow. ");
INSERT INTO fuh_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Miin duu, mi inndirte Piyer, ɗum woni hayre. Dow hayre ndeen nyiɓanmi hawriine goonɗinɓe kam. Maayde naa jahannama he semmbe mum fuu walaa ko waawani nde. ");
INSERT INTO fuh_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Mi hokkete omtirɗe dammbugal Laamu Alla : Huune fuu ko kaɗuɗaa dow leydi, haɗetee dow kammu. Huune fuu ko njaɓuɗaa dow leydi, jaɓetee dow kammu. ");
INSERT INTO fuh_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Nden, Iisa fooɗi noppi maɓɓe wi'i to ɓe kaalan neɗɗo fuu ko kam woni *Almasiihu. ");
INSERT INTO fuh_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Gaɗa tabbintinol ngol Piyer waɗi, Iisa fuɗɗi anndinde *aahiiɓe mum ko no tilsi kam yaha *Ursaliima. To mawɓe *Yahudankooɓe, mawɓe *cakkanooɓe Alla he jannginooɓe *Tawreeta torrata ɗum sanne, nden ɓe mbara ɗum. Balɗe tati gaɗa mum kam ummitittoo. ");
INSERT INTO fuh_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Sey, Piyer fooɗi mo senngo, tinni no haalda he makko, no wi'a : —Alla reene, Joomam ! Ɗum hewtotaako ma sam ! ");
INSERT INTO fuh_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Iisa yeeƴitii Piyer, wi'i : —Woɗɗam, aan Seyɗan ! A fergere dow laawol am, ngam miilooji maaɗa ɗii ƴuwaay to Alla, amma to himɓe ɗi ƴuwi ! ");
INSERT INTO fuh_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Nden Iisa wi'i *aahiiɓe mum : —Muuyɗo tokkude kam fuu, acca daarude hoore mum, hooƴa *leggal bardugal mum, tokka kam. ");
INSERT INTO fuh_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ngam giɗɗo hisinde yonki mum, mursan ki. Amma mursuɗo ki ngam am, heɓitan ki. ");
INSERT INTO fuh_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ɗume keɓol duuniyaaru nduu fuu nafirta neɗɗo, nde joomum mursi yonki mum ? No woodi ko neɗɗo waawi hokkitirde ngam heɓita ki naa ? ");
INSERT INTO fuh_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","*Ɓii-Neɗɗo no wardan he maleykaaɓe mum nder teddungal *Baabiraawo mum. Wakkati mum, o yoɓan neɗɗo fuu ko foti he golle muuɗum. ");
INSERT INTO fuh_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Goonga kaalananmi on : Woɓɓe nder tawaaɓe ɗo hannden maayataa tawee ngi'aay *Ɓii-Neɗɗo no wara nder laamu mum. ");
INSERT INTO fuh_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Balɗe jeegom gaɗa tabbintinol ngol Piyer waɗi, Iisa nyakkodi Piyer, Yakuuba he dimdaaɗo mum Yahaaya dow waamnde toowne gom. ");
INSERT INTO fuh_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Tagaadi makko waylitii yeeso maɓɓe. Yeeso makko no yayna hano naange, kolte makko duu no ƴelkita hano jeyngol. ");
INSERT INTO fuh_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Wakkati mum da *aahiiɓe tato ɓeen ngi'i *Muusa he Eliya mbanngii, iɓe kaalda he makko. ");
INSERT INTO fuh_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Sey Piyer wi'i Iisa : —Joomam, no wooɗi ko tawaaɗen ɗo. Nde nii aɗa hiɗi, mi nyiɓan hukumuuji tati ɗo : Aan worru, *Muusa worru, Eliya worru. ");
INSERT INTO fuh_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Wakkati o haalannoo ndeen sey luuldere ƴelkitoore gom wari suddi ɓe. Daane gom ƴuwi nder luuldere ndeen, wi'i : —Oo woni Ɓiyam mo korsinmi, mo mbelniranmi. Kettinanee mo ! ");
INSERT INTO fuh_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Wakkati *aahiiɓe ɓeen nanunoo daane ndeen, kippi he leydi. Ɓe kuli sanne. ");
INSERT INTO fuh_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Iisa ɓattii ɓe, meemi ɓe, wi'i : —Ummee ! To kulee ! ");
INSERT INTO fuh_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Sey ɓe ɓanti ko'e maɓɓe, ɓe ngi'aay neɗɗo fuu, se hanaa Iisa. ");
INSERT INTO fuh_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Wakkati ɓe njippotonoo waamnde ndeen, Iisa fooɗi noppi maɓɓe, wi'i : —To kaalanee neɗɗo fuu ko ngi'uɗon ɗum, sey wakkati *Ɓii-Neɗɗo ummitii e maayde. ");
INSERT INTO fuh_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Nden *aahiiɓe ɓeen ƴami mo, mbi'i : —Ɗume waɗi ko jannginooɓe *Tawreeta no mbi'a no tilsi Eliya arta *Almasiihu warde ? ");
INSERT INTO fuh_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","O jaabii ɓe, o wi'i : —Goonga non, Eliya artata wara, moƴƴina kujje fuu. ");
INSERT INTO fuh_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Amma miɗo wi'a on : Eliya warii faa yawti, ɓe annditaay mo, ɓe ndaaraay mo goɗɗum. Hano non duu ɓe ndaarataa *Ɓii-Neɗɗo goɗɗum, ɓe torra mo. ");
INSERT INTO fuh_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Nden *aahiiɓe ɓeen paamii ko filla Yahaaya gaɗoowo *batisma o waɗani ɓe. ");
INSERT INTO fuh_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Wakkati Iisa he *aahiiɓe mum ngartunoo to jama'aare ndeen, gorko gom ɓadii mo, hofi yeeso makko, ");
INSERT INTO fuh_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","wi'i : —Moodibbo, yurma ɓiyam gorko oo ! Paɗɗe o woodi, ɗum tampinii mo sanne. Kile keewɗe omo saama nder hiite naa nder ndiyam. ");
INSERT INTO fuh_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Mi yaarii mo to *aahiiɓe maaɗa amma ɓe keppi nyawtude mo. ");
INSERT INTO fuh_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Sey Iisa jaabii mo, wi'i : —Hey onon himɓe jamaanu bonɗo, ɓe ngoonɗinaay ! Faa nde ngondanmi he mooɗon ? Faa nde tinnotoomi miɗo munyana on ? Ngaddanee kam suka oon ɗo ! ");
INSERT INTO fuh_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","O sajiti ginnaaru nduun. Ndu takkiti suka oon. Wakkati mum da suka oon nyawti. ");
INSERT INTO fuh_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Wakkati Iisa wonnoo feere mum, *aahiiɓe ɓeen ɓadii mo, ƴami, mbi'i : —Ɗume waɗi ko minen, min keppi riiwude ginnaaru nduun ? ");
INSERT INTO fuh_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Iisa jaabii ɓe, wi'i : —Ngam oɗon pamɗi goonɗinol. Goonga kaalananmi on : Nde goonɗinol mooɗon no famɗi faa foti gabbel mutaari, nde nii on mbi'i waamnde ndee : « Sottu ɗo, njahaa to », nde sottan. Huune fuu hepportaa on.  ");
INSERT INTO fuh_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Amma iri ginnaaru nduu riiwataako nde hanaa du'aa'u he suumayeere non. ");
INSERT INTO fuh_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Nyannde gom, wakkati Iisa he *aahiiɓe mum pottunoo nder leydi Galili, o wi'i ɓe kaden : —*Ɓii-Neɗɗo no jammbetee, wattee nder juuɗe. ");
INSERT INTO fuh_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","O waree, balɗe tati gaɗa mum, o ummitoo. Haala kaa metti ɓerɗe *aahiiɓe ɓeen sanne. ");
INSERT INTO fuh_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Wakkati Iisa he *aahiiɓe mum njottinoo Kafarnahum, *jaɓooɓe janngal *Juulirde mawne gom ngari to Piyer, mbi'i mo : —Moodibbo mooɗon no yoɓa janngal *Juulirde mawne naa ? ");
INSERT INTO fuh_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Piyer jaabii ɓe, wi'i : —Omo yoɓa. Wakkati Piyer naatannoo nder Juulirde ndeen, fadde makko yeccaade, sey Iisa wi'i mo : —Simon, ɗume miiliɗaa ? Moy haani yoɓande laamiiɓe duuniyaaru janngal ? Ɓiɓɓe leydi naa hoɓɓe ? ");
INSERT INTO fuh_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Nden Piyer jaabii mo, wi'i : —Hoɓɓe. Sey Iisa wi'i mo : —Ndenne, ɓiɓɓe leydi kaanaa yoɓude naa ? ");
INSERT INTO fuh_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Amma, en ngiɗaa mettinde ɓerɗe himɓe ɓee. Yah toon dow peta, paɗɗaa mamaruwol maa. Linngu ngu artuɗaa nanngude nguun, omtu hunnduko maggu. A tawan tammal cardi, joɓoowal janngal meeɗen. Ittaa ngal, njoɓana en, miin he maa. ");
INSERT INTO fuh_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","*Aahiiɓe ɓeen ɓadii Iisa, ƴami mo, mbi'i : —Moy ɓuri teddude nder Laamu Alla ? ");
INSERT INTO fuh_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Nden Iisa noddi cukalel gom, darni yeeso maɓɓe, ");
INSERT INTO fuh_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","wi'i : —Goonga kaalananmi on : Nde nii on mbattitaay, faa nannduɗon he cukaloy koy, on naatataa nder Laamu Alla. ");
INSERT INTO fuh_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Leesinɗo hoore mum faa nanndi he cukalel ngel, kam woni ɓurɗo teddude nder Laamu Alla. ");
INSERT INTO fuh_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Jaɓɓiiɗo suka gooto hano cukalel ngel dow innde am, miin jaati joomum jaɓɓii. ");
INSERT INTO fuh_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Neɗɗo fuu waɗi cukalel gootel goonɗinngel kam waɗa hakke, ko ɓuri moƴƴande joomum woni kaaƴa mannga haɓɓee he daane mum, yoolee nder nokkuure ɓurne luggiɗidde nder maayo. ");
INSERT INTO fuh_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Kaari duuniyaaru nduu no heewi laabi gaɗol bone. Sikka fuu walaa laabi gaɗol ko boni keppataa nder mayru faa abada. Amma bone saama dow neɗɗo fuu laatii sabiili majji ! ");
INSERT INTO fuh_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Se tawi junngo maaɗa naa koyngal maaɗa no waawi waɗa ngaɗaa hakke, taƴa junngo ngoon naa koyngal ngaal paɗɗaa. Naataa nder mbuurnam nduumiiɗam a larɗuɗo no ɓuri moƴƴande ma dina paɗɗeɗaa nder hiite duumiinge tawi aɗa huuɓi. ");
INSERT INTO fuh_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Se tawi hitere maaɗa no waawi waɗa ngaɗaa hakke, itta nde paɗɗaa. Naataa nder mbuurnam nduumiiɗam a ɗokko, no ɓuri moƴƴande ma dina paɗɗideɗaa gite maaɗa ɗiɗi fuu no kuuɓi nder hiite jahannama. ");
INSERT INTO fuh_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Kakkilee to njawee baa gooto nder cukaloy koy. Ngam miɗo wi'a on : Maleykaaɓe makkoy wonɓe dow kammu ɓeen, wakkati fuu iɓe yeeso *Baabiraawo am gonɗo dow, iɓe ngi'a huune fuu.  ");
INSERT INTO fuh_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ngam *Ɓii-Neɗɗo waraana hisinde majjuɓe. ");
INSERT INTO fuh_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","—Ɗume miilotoɗon ? Nde nii tawaama neɗɗo no jogii baali hemre, dey ngootu majjaa, hanaa joomum no accan baali hemre go'o walaa ɗiin nder ferro ɗi ndura, nden tefowa majjungu nguun naa ? ");
INSERT INTO fuh_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Goonga kaalananmi on : Nde nii o hiitii ngu, o welniran ngu faa ngu ɓura hemre go'o walaa ɗiito. ");
INSERT INTO fuh_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Hano non *Baabiraawo mooɗon gonɗo dow oon, hiɗaa baa gooto nder cukaloy koy majjaa. ");
INSERT INTO fuh_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","—Nde nii bannda goonɗinɗo gom waɗani ma gacce, yah to makko, nodda mo feere kollaa mo gacce makko. Nde nii o hettinake, o jaɓi kollitooje maa, a wartiri enɗam hakkune mooɗon. ");
INSERT INTO fuh_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Amma nde nii o jaɓaay, soƴƴa to makko, aan he neɗɗo gom naa njahdaa himɓe ɗiɗo. Ngam seedeeɓe ɗiɗo naa tato tabbintina haala ngaɗaaka fuu. ");
INSERT INTO fuh_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Nde nii o jaɓaay faa hannden, kaalanaa ɗum hawriine goonɗinɓe. Nde nii o salake jaɓude haala hawriine goonɗinɓe kaan, adu mo hano neɗɗo mo anndaa Alla naa jaɓoowo janngal, caliiɗo tuubude. ");
INSERT INTO fuh_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Goonga kaalananmi on : Huune fuu ko kaɗuɗon dow leydi, no haɗetee dow kammu. Huune fuu ko njaɓuɗon dow leydi, no jaɓetee dow kammu. ");
INSERT INTO fuh_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Miɗo haalana on kaden : Nde nii himɓe ɗiɗo nder mooɗon potii dow huune worre nder duuniyaaru faa ŋaarake ɗum Alla, *Baabiraawo am gonɗo dow no jaabanto ɓe ɗum. ");
INSERT INTO fuh_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ngam nokku fuu to himɓe ɗiɗo naa tato kawri dow innde am, miɗo wondi he maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Piyer ɓadii Iisa, ƴami mo wi'i : —Joomam, nde nii banndam waɗanii kam gacce, kile foti kaanumi yaafanaade mo ? Kile jeɗɗi, naa kile foti ? ");
INSERT INTO fuh_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Nden Iisa jaabii mo, wi'i : —Mi wi'aay ma kile jeɗɗi tan. Njaafoɗaa mo kile lasooji tati he sappo faa nde jeɗɗi. ");
INSERT INTO fuh_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ngam majjum waɗi Laamu Alla no nanndinee he laamu laamiiɗo gom, anniyiiɗo lima njawdi mum wondi nder juuɗe gollanooɓe ɗum. ");
INSERT INTO fuh_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Wakkati o fuɗɗunoo limude ndeen, o waddanaa golloowo gom mo o tokkata nyamaane nde golloowo oon waawtaa yoɓi keerol mbuurnam mum fuu. ");
INSERT INTO fuh_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ko gorko oon heppi yoɓidide mo fuu, sey laamiiɗo oon hokki laawol gorko oon, deekum, sukaaɓe mum he ko jogii fuu connee, faa ɗum yoɓa nyamaane ndeen. ");
INSERT INTO fuh_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Sey golloowo oon hofi yeeso laamiiɗo oon, eeli mo, wi'i : « Munyanam, mi yoɓete fuu ! » ");
INSERT INTO fuh_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Nden laamiiɗo oon yurmii mo, yaafanii mo nyamaane ndeen, acci mo o dilli. ");
INSERT INTO fuh_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Amma golloowo oon no wurtorii, sey fotti he mo ɓe ngolliditta gom mo o tokkata nyamaane seɗɗa. O nanngi daane onɗon, o ɗeɗɗi, o wi'i mo : « Yoɓan ceede am ! » ");
INSERT INTO fuh_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Gollidoowo he makko oon hofi yeeso makko, eeli mo, wi'i : « Munyanam, mi yoɓete ! » ");
INSERT INTO fuh_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Amma o jaɓaay. O uddowii mo kasu, sey nde o yoɓi nyamaane ndeen fuu. ");
INSERT INTO fuh_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Wakkati gollooɓe ɓeeto ngi'unoo ɗum ndeen, ɗum metti ɓerɗe maɓɓe sanne. Ɓe njehi ɓe kaalanowi ɗum laamiiɗo oon. ");
INSERT INTO fuh_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Nden, laamiiɗo oon noddi golloowo oon, wi'i mo : « Aan a neɗɗo bonɗo ! Wakkati eelunoɗaa kam, mi yaafanake ma ko tokkanoomaami fuu. ");
INSERT INTO fuh_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ndenne aan, a haanaa yurmaade jaada oo naa, hano no njurmorimaami nii ? » ");
INSERT INTO fuh_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Laamiiɗo oon tikki sanne, nanngi mo portol sey nyannde o yoɓidi nyamaane ndeen fuu faa laaɓi. ");
INSERT INTO fuh_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Non duu *Baabiraawo am gonɗo dow waɗanta gooto mooɗon fuu, caliiɗo yaafaade banndum he ɓerne worre. ");
INSERT INTO fuh_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Wakkati Iisa timminnoo waaju mum, o dilli Galili o fa'i gaɗa maayo Urdun nder leydi Yahudiya. ");
INSERT INTO fuh_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Jama'aare mawne tokki mo, o nyawti nyawɓe maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Fariisa'en gom ngari to makko faa tunna mo. Ɓe ƴami mo ɓe mbi'i : —No dagii gorko seera deekum ngam daliila fuu naa ? ");
INSERT INTO fuh_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Sey o jaabii ɓe, o wi'i : —Ndenne, on njanngaay ko winndaa nder dewte ɗeen naa ? Illa fuɗɗorde Alla tagi himɓe gorko he debbo. ");
INSERT INTO fuh_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ngam majjum waɗi gorko no acca innum e bammum ngam hawtaa he deekum, ɓe fuu ɗiɗo ɓe laatoo ɓanndu worru. ");
INSERT INTO fuh_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ndenne, joonin ɓe kanaa ɗiɗo kaden, amma ɓe go'o. To neɗɗo fuu senndu ko Alla hawri. ");
INSERT INTO fuh_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ɓe ƴami mo kaden, ɓe mbi'i : —Ndenne ɗume waɗi *Muusa tilsini gorko hokka deekum talkuru ceergal, nde no seera mo ? ");
INSERT INTO fuh_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","O jaabii ɓe, o wi'i : —On tiɓɓe-nyireeɓe, ngam majjum waɗi *Muusa hokki on laawol no ceerirton rewɓe mooɗon. Amma illa fuɗɗorde, hanaa non ɗum worri. ");
INSERT INTO fuh_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Miɗo wi'a on : Neɗɗo fuu ceerɗo deekum ko hanaa ngam jeenu, dey ɓaŋi debbo gom, joomum yeeni. ");
INSERT INTO fuh_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Sey *aahiiɓe ɓeen mbi'i mo : —Nde nii hakkune neɗɗo he deekum nii worri, tawee neɗɗo ɓaŋaay mo no ɓuri. ");
INSERT INTO fuh_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Amma Iisa jaabii ɓe, wi'i : —Hanaa neɗɗo fuu waawi jaɓude haala kaa, sey nii mo Alla hiɗani ɗum. ");
INSERT INTO fuh_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Daliila kaɗoowo gorko ɓaŋa no woodi. Ngam goɗɗo rimaama no baatoraaɗo. Goɗɗo no tappaaɗo. Goɗɗo duu, kam haɗi hoore mum ɓaŋude ngam ngollana Laamu Alla. Neɗɗo fuu waawi yardaade he haala kaa, jaɓa ka ! ");
INSERT INTO fuh_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Himɓe ngaddi cukaloy mum'en ngam o yowa juuɗe makko dow makkoy, o du'anoo koy, amma *aahiiɓe ɓeen nduki ɓe. ");
INSERT INTO fuh_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Nden Iisa wi'i ɓe : —Accee cukaloy koy ngara to am. To kaɗee koy, ngam nannduɓe he makkoy njeyii Laamu Alla. ");
INSERT INTO fuh_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","O yowi junngo makko dow makkoy, o du'anii koy, nden o dilli. ");
INSERT INTO fuh_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Iɓe ɗon nii, sey gorko gom ɓadii Iisa, ƴami mo, wi'i : —Moodibbo, yerre ndeye kaanumi waɗude ngam heɓude mbuurnam nduumiiɗam ? ");
INSERT INTO fuh_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Iisa jaabii mo, wi'i : —Ɗume ƴamantaa kam yerre nde kaanuɗaa waɗude ? Alla tan woni jeɗɗuɗo ! Nde aɗa hiɗi naata nder mbuurnam nduumiiɗam, tokku tilsinooje *Tawreeta. ");
INSERT INTO fuh_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Nden gorko oon ƴami mo wi'i kaden : —Tilsinooje *Tawreeta ɗeye tokkanmi ? Iisa jaabii mo, wi'i : —To ittu yonki goɗɗo, to yeenu, to wujju, to seedana fewre. ");
INSERT INTO fuh_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Teddin inna maa he bammaa, ngiɗaa gondo maa no ngiɗirɗaa hoore maa. ");
INSERT INTO fuh_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Suka jokolle oon wi'i mo : —Miɗo waɗa kujje ɗee fuu. Ɗume hoddi kaden ? ");
INSERT INTO fuh_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Sey Iisa wi'i mo : —Nde aɗa hiɗi laatoɗaa kuuɓuɗo, sonnoy ko njogiɗaa fuu, njeddana talkaaɓe, a heɓan baraaje dow. Gaɗa mum, ngaraa tokkaa kam. ");
INSERT INTO fuh_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Jokolle oon no diikuɗo sanne. Wakkati o nanunoo haalaaji ɗii, o ɓalinii, o dillidi mettorgal ɓerne. ");
INSERT INTO fuh_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Gaɗa mum, sey Iisa wi'i *aahiiɓe mum : —Goonga kaalananmi on : Naatol diikuɗo nder Laamu Alla no tiiɗi faa ! ");
INSERT INTO fuh_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Miɗo haalana on duu : Naatol ngolooba nder wudde battal no ɓuri hoyde dina naatol diikuɗo nder Laamu Alla. ");
INSERT INTO fuh_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Wakkati *aahiiɓe ɓeen nanunoo haala kaan, ɗum haayɗini ɓe sanne. Nden ɓe mbi'i : —Ndenne, moy hisata ? ");
INSERT INTO fuh_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","O daari ɓe, o wi'i : —To himɓe ɗum waɗataako naa ? Amma walaa fuu ko hepportaa Alla. ");
INSERT INTO fuh_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Piyer itti hunnduko, wi'i Iisa : —Minen, min mboppii fuu, min tokkii ma. Noy min laatoytoo ? ");
INSERT INTO fuh_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Sey Iisa jaabii, wi'i : —Goonga kaalananmi on : Nder duuniyaaru heyru warooru nduu, nde *Ɓii-Neɗɗo jooɗake dow jooɗorgal laamu mum teddungal, onon sappo he ɗiɗo tokkuɓe kam ɓee, onon duu on njooɗoto dow jooɗorɗe laamiiɓe sappo he ɗiɗi, laamoɗon lenyi *Isra'el sappo e ɗiɗi ɗiin. ");
INSERT INTO fuh_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Kaden neɗɗo fuu boppuɗo ɓaade mum, naa rimdaaɓe mum worɓe naa rewɓe, naa woppi innum naa bammum, naa sukaaɓe mum, naa gese mum ngam am, joomum heɓan ko ɓuri ko woppi ɗum kile hemre. Kaden duu joomum heɓan mbuurnam nduumiiɗam. ");
INSERT INTO fuh_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Amma ardiiɓe heewɓe keedan gaɗa. Gaɗaaɓe ɓeen duu laatoto ardiiɓe. ");
INSERT INTO fuh_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ndaa no Laamu Alla wa'i nii : —Ingu nanndi he jom ngesa cabiije, dilluɗo illa beete faa hooƴowa gollooɓe, gollanooɓe ɗum. ");
INSERT INTO fuh_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","O heɓi ɓe, o fotidi he maɓɓe dow ko nyalooma fuu, o yoɓataana neɗɗo maɓɓe fuu tammal cardi gootal. Nden o yaari ɓe nder ngesa makko. ");
INSERT INTO fuh_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Nyawli seɗɗa, sey o wurtii kaden, o hi'i woɓɓe no njooɗii nder luumo, ɓe ngalaa gollal fuu. ");
INSERT INTO fuh_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","O wi'i ɓe : « Njehee onon duu ngollowon nder ngesa am. Mi yoɓan on ko haani yoɓeede. » ");
INSERT INTO fuh_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ɓeen duu njehi ngollowi. Har caka nyalooma o wurtii kaden, o hi'i woɓɓe, o wi'i ɓe njaha ɓe ngollowa nder ngesa makko. O wurtitii kaden har juura sey o hi'i woɓɓe, o wi'i ɓe kamɓe duu ɓe ngollowa nder ngesa makko. ");
INSERT INTO fuh_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Faa hannden har laasara pewɗo dey-dey yamnde joy, o wurtii kaden. O tawi woɓɓe nder luumo, ɓe ngalaa golle. O wi'i ɓe : « Ko waɗi ko nyalluɗon ɗo on ngollaay ? » ");
INSERT INTO fuh_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ɓe njaabii mo, ɓe mbi'i : « Neɗɗo fuu hooƴaay min golle. » Nden o wi'i ɓe : « Too, njehee onon duu ngollowon nder ngesa am. » ");
INSERT INTO fuh_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Wakkati naange yanunoo ndeen, sey o wi'i golloowo makko gom : « Noddu gollooɓe ɓeen, njoɓaa ɓe. Artir sakitiiɓe warde ɓeen, nden ngayniraa artuɓe ɓeen. » ");
INSERT INTO fuh_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Warɓe laasara pewɗo ɓeen ngari, neɗɗo maɓɓe fuu hokkaa tammal cardi gootal. ");
INSERT INTO fuh_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Artunooɓe ɓeen duu ngari, miili no njoɓetee ko ɓuri non. Amma kamɓe duu, neɗɗo maɓɓe fuu hokkaa tammal cardi gootal. ");
INSERT INTO fuh_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Wakkati ɓe njoɓanoo ndeen, sey ɓe tinni iɓe nguunitoo yeeso jom ngesa oon. ");
INSERT INTO fuh_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Iɓe mbi'a : « Sakitiiɓe warɓe ɓeen yamnde worre tan ngolli, dey njobdi amin fonnee. Minen nyalluɓe no tampa nder naange wulnge ! » ");
INSERT INTO fuh_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Sey jom ngesa oon jaabii gooto nder maɓɓe, wi'i : « Neɗɗo am, mi toonyaaki ma. Hanaa dow tammal cardi gootal kaalduɗen ngam ngollanon kam nyalooma oon fuu naa ? ");
INSERT INTO fuh_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ndenne, jaɓu njobdi maa, tinnoɗaa. Mi muuyi hokkude sakitiiɓe warɓe ɓeen dey-dey ko kokkumaami. ");
INSERT INTO fuh_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Hanaa ko weli kam ngaɗiranmi ceede am naa ? Naa moƴƴere nde ngaɗumi ndeen woni welaay ma ? » ");
INSERT INTO fuh_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Nden Iisa wi'i ɓe : —Non non ardiiɓe ɓeen keedan gaɗa, gaɗaaɓe ɓeen duu laatoo ardiiɓe. ");
INSERT INTO fuh_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Nyannde gom Iisa he *lilaaɓe mum sappo he ɗiɗo ɓeen no pa'i *Ursaliima. Dow laawol, sey o henni ɓe senngo, o wi'i ɓe : ");
INSERT INTO fuh_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Kettinee, eɗen ɗon njaha *Ursaliima. Toon *Ɓii-Neɗɗo wattetee nder juuɗe hooreeɓe *cakkanooɓe Alla he jannginooɓe *Tawreeta. Ɓe kiitoo mo kiite maayde. ");
INSERT INTO fuh_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ɓe ngatta mo nder juuɗe ɓe kanaa *Yahudankooɓe. Kamɓe duu ɓe njawoo mo, ɓe ɓocca mo, ɓe tonta mo dow *leggal bardugal ngam o maaya. Amma nyalaane tataɓere mum o ummitittoo. ");
INSERT INTO fuh_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Inna ɓiɓɓe Jebede ɓattini sukaaɓe mum to Iisa. O sujidi yeeso makko ngam eelude mo. ");
INSERT INTO fuh_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Sey Iisa wi'i mo : —Ɗume ngiɗaa ? Nden yeyraajo oon jaabii mo, wi'i : —Miɗo hiɗi podanoɗaa ɓiɓɓe am worɓe ɗiɗo ɓee, ɓe njooɗoo takkol maaɗa nder laamu maa. Gooto nyaamo maa, ooto nano maa. ");
INSERT INTO fuh_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Nden Iisa jaabii mo, wi'i Yakuuba he Yahaaya : —On anndaa ko eeloton. Oɗon mbaawi yarirde nyeɗerde nde njaranmi ndeen naa ? Ɓe njaabii mo, ɓe mbi'i : —Miɗen mbaawi. ");
INSERT INTO fuh_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","O wi'i ɓe : —Goonga, on njaran nde. Amma jooɗaade nyaamo am naa nano am, hanaa miin woodi baawɗe hokkude ɗum. *Baabiraawo am moƴƴini jooɗorɗe ɗee ngam ɓe o suɓi. ");
INSERT INTO fuh_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Wakkati *lilaaɓe sappo ɓeeto nanunoo ɗum, ɓerɗe maɓɓe metti he ɗiɗo ɓeeto. ");
INSERT INTO fuh_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Nden Iisa noddi ɓe, ɓe fuu wi'i ɓe : —Oɗon anndi ko doole doole laamiiɓe ɓe kanaa *Yahudankooɓe laamorii himɓe mum'en. Mawɓe maɓɓe ɓeen duu kolli baawɗe. ");
INSERT INTO fuh_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Amma onon kay, ɗum waɗataa hakkune mooɗon. Giɗɗo laatoo tedduɗo hakkune mooɗon on fuu, no haani laatoo golloowo mooɗon. ");
INSERT INTO fuh_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Kaden duu, giɗɗo ardaade nder mooɗon, no haani laatoo maccuɗo mooɗon. ");
INSERT INTO fuh_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Noon duu, *Ɓii-Neɗɗo waraay faa gollanee, amma o wari faa o ngollana himɓe fuu, o mursa yonki makko ngam hisinde himɓe heewɓe. ");
INSERT INTO fuh_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Wakkati Iisa he *aahiiɓe mum njawtannoo nder Yeriko, jama'aare mawne no tokki mo. ");
INSERT INTO fuh_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Wumɓe ɗiɗo gom no njooɗii sera laawol. Wakkati ɓe nanunoo no wi'ee Iisa woni no yawta, sey ɓe kuuɓi, iɓe mbi'a : —Moodibbo ! Taan Daawda, yurma min ! ");
INSERT INTO fuh_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Jama'aare ndeen darii no sajitoo he maɓɓe, no wi'a ɓe ndeƴƴita. Sey ɓe tinni iɓe kuuɓa, iɓe mbi'a : —Moodibbo ! Taan Daawda, yurma min ! ");
INSERT INTO fuh_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Iisa darii, noddi ɓe, ƴami ɓe, wi'i : —Ɗume ngiɗuɗon mi waɗana on ? ");
INSERT INTO fuh_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ɓe njaabii mo, ɓe mbi'i : —Moodibbo, miɗen ngiɗi min mbumtaa. ");
INSERT INTO fuh_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Iisa yurmii ɓe, meemi gite maɓɓe. Wakkati mum da ɓe mbumti, ɓe tokki mo. ");
INSERT INTO fuh_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Wakkati Iisa he *aahiiɓe mum njottinoo ci'el Baytifaaji hadde *Ursaliima har waamnde wi'eteene waamnde Jaytun, sey o lili *aahiiɓe makko ɗiɗo gom, ");
INSERT INTO fuh_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","o wi'i ɓe : —Ummee, njehee nder wurel gonngel yeeso mooɗon ngeel. No njottoriɗon, on tawan ara gom no haɓɓii, he ɓiyum. Kaɓɓitee nga, ngaddanon kam ɗi. ");
INSERT INTO fuh_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Nde nii goɗɗo ƴamii on, njaaboɗon mo mbi'on Joomiraawo haajaa ɗi. Dey ɗi ngartirtee law. ");
INSERT INTO fuh_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ɗum waɗi ngam tabbintinde ko annabiijo gom haalunoo wakkati o wi'unoo : ");
INSERT INTO fuh_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Mbi'ee himɓe huɓeere *Siyon : Ndaaree da, laamiiɗo mooɗon no wara to mooɗon, no leesinkini, no waɗɗii ara, ɓinngel mum gorel no tokki. ");
INSERT INTO fuh_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Sey *aahiiɓe ɓeen njehi, ngaɗowi ko o wi'i ɗum'en. ");
INSERT INTO fuh_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ɓe ngaddi ara ngaan he ɓinngel mum. Ɓe ngaɗi kolte maɓɓe jappe, ɓe njowi dow majji, nden Iisa waɗɗii. ");
INSERT INTO fuh_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Himɓe ɗuɓɓe mbeɗɗiti kolte mum'en dow laawol. Woɓɓe duu kelti licce, mbeerti dow maggol. ");
INSERT INTO fuh_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Jama'aare wonnde yeeso Iisa ndeen, he tokkude gaɗa makko fuu no ilina, no mbi'a : —Hosanna  ! Jettooje ngoodani Taan Daawda ! Barkinaaɗo woni garɗo dow innde Joomiraawo ! Jettooje ngoodani Alla Toowɗo ! ");
INSERT INTO fuh_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Wakkati o naatunoo *Ursaliima, huɓeere ndeen fuu iirti. Himɓe no kuuɓa no mbi'a : —Moy woni gorko oo ? ");
INSERT INTO fuh_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Sey jama'aare wonnde gaɗa makko ndeen no jaaboo, no wi'a : —Ay, oo woni annabi Iisa mo Nasaratu nder leydi Galili. ");
INSERT INTO fuh_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Iisa naati jawreeru *Juulirde mawne ndeen. O riiwi soodooɓe he sonnooɓe wonɓe nder mayru fuu. O liɓi teburuuji weccooɓe ceede he jooɗorɗe sonnooɓe buugaali. ");
INSERT INTO fuh_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Nden o wi'i ɓe : —No winndaa nder dewte Alla ko suudu am noddirtee suudu du'aa'u. Amma onon, on ngartiri ndu wumpere wuyɓe ! ");
INSERT INTO fuh_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Wumɓe he laƴooɓe ngari to makko, o nyawti ɓe. ");
INSERT INTO fuh_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Mawɓe *cakkanooɓe Alla he jannginooɓe *Tawreeta ngi'ii kujje kaayɗiniiɗe, ɗe o waɗata. Ɓe nani duu sukaaɓe no ilina nder *Juulirde mawne no mbi'a : —Hosanna  ! Jettooje ngoodani Taan Daawda ! Ɗum tiimi, ɗum metti ɓerɗe maɓɓe faa noy walaa. ");
INSERT INTO fuh_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Sey ɓe mbi'i Iisa : —A nanii ko cukaloy koy mbi'ata naa ? Nden o jaabii ɓe, o wi'i : —Mi nani. Ndenne, on njanngaay baa nde worre nder dewte Alla to winndaa, wi'aa : A waɗi kunndule entaaɓe e musinooɓe no njette  ? ");
INSERT INTO fuh_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Illa ndeen, o seedi he maɓɓe. O dilli nder huɓeere ndeen, o yehi, o waalowi Baytaniya. ");
INSERT INTO fuh_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Beete, wakkati Iisa wartannoo nder huɓeere ndeen, sey o rafaa dow laawol. ");
INSERT INTO fuh_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","O holliri ibbi gom sera laawol ngool. O fanti ki, amma o tawraay ki fuy nde hanaa haako. Nden o huɗi ki, o wi'i : —Taa rimu abada kaden ! Wakkati mum da, ibbi kiin yoorii koƴon. ");
INSERT INTO fuh_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Wakkati *aahiiɓe ɓeen ngi'unoo ɗum, ɗum haayɗini ɓe. Ɓe ƴami mo, ɓe mbi'i : —Noy waɗi ko ibbi kii yoorii, wakkati gooto ? ");
INSERT INTO fuh_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Iisa jaabii ɓe, wi'i : —Goonga kaalananmi on : Nde nii on ngoonɗini, on cikkay, oɗon mbaawi ngaɗi ko ɓuri ko ngaɗumi ibbi kii. On mbaawan wi'ude baa waamnde ndee : « Ɗoofa, saamoy nder maayo », ɗum laato non duu. ");
INSERT INTO fuh_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Nde nii on ngoonɗini, ko eeluɗon nder du'aa'u fuu no jaabetee. ");
INSERT INTO fuh_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Iisa naati nder *Juulirde mawne, omo waajoo. Sey hooreeɓe *cakkanooɓe Alla he mawɓe *Yahudankooɓe ɓadii mo, ƴami mo, mbi'i : —Baawɗe ɗeye ngaɗirtaa kujje ɗee fuu ? Moy hokki ma laawol waɗude ɗe ? ");
INSERT INTO fuh_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Iisa jaabii ɓe, wi'i : —Miin duu, huune worre tan ƴamanmi on. Nde nii on njaabake kam, miin duu, mi haalanan on baawɗe ɗeye ngaɗiranmi kujje ɗee fuu. ");
INSERT INTO fuh_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Alla naa himɓe kokki Yahaaya laawol waɗude *batisma ? Sey iɓe caawodira hakkune maɓɓe, iɓe mbi'a : —Nde nii en mbi'i Alla, o wi'an ko waɗi en ngoonɗinaay Yahaaya ? ");
INSERT INTO fuh_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Amma nde en mbi'i himɓe, too, eɗen kaani kulen jama'aare ndee, ngam himɓe fuu no anndi tabbat Yahaaya no annabiijo. ");
INSERT INTO fuh_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Sey ɓe njaabii, ɓe mbi'i : —Min anndaa. Iisa duu jaabii ɓe, wi'i : —Too, miin duu, mi haalantaa on baawɗe ɗeye ngaɗiranmi kujje ɗee fuu. ");
INSERT INTO fuh_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Iisa wi'i hooreeɓe *Yahudankooɓe ɓeen kaden : —Too ! Ɗume miilotoɗon nder huune ndee : Gorko gom no woodunoo ɓiɓɓe worɓe ɗiɗo. O ɓadii arano oon, o wi'i mo : « Ɓinngel am, yah golloy hannden nder ngesa cabiije meeɗen. » ");
INSERT INTO fuh_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Sey ɓiɗɗo oon jaabii mo, wi'i kam yahataa. Gaɗa mum o nimsiti, o yehi, o gollowi. ");
INSERT INTO fuh_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Nden *Baaba oon ɓadii ɗiɗaɓo oon, wi'i mo ko wi'unoo arano oon. Oon duu jaabii mo, wi'i : « Wooɗi *Baaba, mi yahan. » Amma o yehaay. ");
INSERT INTO fuh_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Nder maɓɓe moy waɗi ko bammum hiɗi ? Nden ɓe njaabii, ɓe mbi'i : —Arano oon. Sey Iisa wi'i ɓe : —Goonga kaalananmi on : Jaɓooɓe janngal he rewɓe fijooɓe no artan on nder Laamu Alla. ");
INSERT INTO fuh_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ngam Yahaaya wari to mooɗon, o holli on laawol dartinaaku, amma on ngoonɗinaay mo. *Jaɓooɓe janngal he rewɓe fijooɓe kam'en ngoonɗini mo. Baa wakkati ngi'unoɗon ɗum ndeen, on tuubaay, ngoonɗinɗon mo. ");
INSERT INTO fuh_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Iisa wi'i hooreeɓe *Yahudankooɓe ɓeen : —Too, kettinee kippol haala gom nii kaden : Neɗɗo gom waɗi ngesa mum cabiije, waɗi koogol fiiltini nga. O wasi luggere ɓoosirde cabiijam ɗaam. O nyiɓi suudu toownu ngam doomooɓe magga. Nden o wuƴi nga remooɓe gom, o waɗi jahaangal. ");
INSERT INTO fuh_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Wakkati teɓol cabiije ɗeen yottinoo, o lili gollooɓe makko gom to remooɓe ɓeen, ngam ɓe ngaddanowa ɗum mbaka mum nder ɓiɓɓe cabiije ɗeen. ");
INSERT INTO fuh_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Amma remooɓe ɓeen nanngi gollooɓe ɓeen, piyi arano oon, mbari ɗiɗaɓo oon, paɗɗi tataɓo oon kaaƴe faa maayi. ");
INSERT INTO fuh_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Jom ngesa oon lili gollooɓe gom kaden, ɓurɓe aranɓe ɓeen ɗuɗde. Remooɓe ɓeen ngaɗi ɓe no ngaɗunoo aranɓe ɓeen. ");
INSERT INTO fuh_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Nden o sakitii, o lili ɓiyiiko gorko he maɓɓe, o wi'i hoore makko : « Ɓe teddinan mo ngam o ɓiyam. » ");
INSERT INTO fuh_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Amma wakkati remooɓe ɓeen ngi'unoo ɓiyiiko ndeen, ɓe mbi'odiri hakkune maɓɓe : « Ma'adalla. Oo nii woni donoowo oon. Ngaree mbaren mo, heɓa ndonen ngesa ngaa ! » ");
INSERT INTO fuh_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Sey ɓe nanngi mo, ɓe mburtini nder ngesa ngaan, ɓe mbari mo. ");
INSERT INTO fuh_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Joonin nee, nde nii jom ngesa cabiije oon wari, noy o waɗata remooɓe ɓee ? ");
INSERT INTO fuh_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ɓe njaabii mo, ɓe mbi'i : —O halkan himɓe bonɓe ɓee no boniri. O halfina ngesa ngaan remooɓe gom, kokkooɓe mo mbaka makko nder ɓiɓɓe magga wakkati teɓol majje. ");
INSERT INTO fuh_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Nden Iisa wi'i ɓe : —Ndenne on njanngaay ko winndaa nder dewte ɗeen, wi'aa naa ? Hayre nde nyiɓooɓe mboppi ndeen, kayre laatii hoore nyibdi ndiin. Ɗum golle Joomiraawo, haayne non duu he giiɗe meeɗen ! ");
INSERT INTO fuh_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ngam majjum miɗo wi'a on : —Laamu Alla no teetetee he juuɗe mooɗon, hokkee waɗirooɓe ngu ko haani. ");
INSERT INTO fuh_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Neɗɗo fuu caamuɗo dow hayre ndeen, helan. Neɗɗo fuu, mo nde saami dow mum, no mornyotoo. ");
INSERT INTO fuh_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Wakkati hooreeɓe *cakkanooɓe Alla he *Fariisa'en nanunoo kippi haala ɗiin, ɓe paami ko filla mum'en o waɗi. ");
INSERT INTO fuh_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ɓe tefi no ɓe nanngirta mo, amma ɓe kuli jama'aare ndeen, ngam nde adii mo o annabiijo. ");
INSERT INTO fuh_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Iisa waɗani ɓe kippol haala gom, wi'i ɓe : ");
INSERT INTO fuh_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Ndaaree no Laamu Alla nanndi nii : Laamiiɗo gom mo ɓiyum ɓaŋi, waɗi nyaamdu ngam batu dewngal ngaal. ");
INSERT INTO fuh_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","O lili gollooɓe makko noddowa noddaaɓe ɓeen ngara ɓe nyaama. Amma noddaaɓe ɓeen calii warde. ");
INSERT INTO fuh_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","O lili kaden gollooɓe gom, o wi'i ɗum'en : « Mbi'ee noddaaɓe ɓeen nyaamdu ɓanngal ngaal moƴƴinaama faa wooɗi. Mi hirsii ga'i he nyalbi payɗi. Ɗum fuu ɗum siryaama. Ɓe ngara, ɓe nootoo kam nder nyalaane welwelo am ndee. » ");
INSERT INTO fuh_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Amma noddaaɓe ɓeen limtaay mo baa, ɓe naati haaju maɓɓe : Oo yehi ngesa mum, ooto duu naati haaju mum. ");
INSERT INTO fuh_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Hoddiiɓe ɓeen nanngi gollooɓe ɓeen, torri ɓe, mbari ɓe. ");
INSERT INTO fuh_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Laamiiɗo oon tikki, lili soogeeji mum mbarowa waruɓe lilaaɓe ɓeen, ɓe mbula wurooji maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Gaɗa mum, o wi'i gollooɓe makko ɓeen : « Nyaamdu welwelo am nduun moƴƴinaama, amma noddaaɓe ɓeen kaandinaaka ndu. ");
INSERT INTO fuh_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ndenne, ummee njehee dow laabi mawɗi, noddon neɗɗo fuu mo pottuɗon wara nyaama. » ");
INSERT INTO fuh_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Gollooɓe ɓeen ummii njehi dow laabi ɗiin, noddi mo ɓe potti fuu. Bonɗo yahde moƴƴuɗo faa wuro jom ɓanngal oon heewi himɓe pet. ");
INSERT INTO fuh_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Wakkati laamiiɗo oon naatunoo faa hi'a noddaaɓe ɓeen, sey o holliri gorko gom mo ɓornaaki kolte ɓanngal ngaal. ");
INSERT INTO fuh_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Nden o wi'i mo : « Higo, noy naatirɗaa ɗo, dey a ɓornaaki kolte ɓanngal ngaal ? » Amma oon wi'aay mo fuy. ");
INSERT INTO fuh_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Sey laamiiɗo oon wi'i gollooɓe mum : « Nanngee mo, kaɓɓee juuɗe makko he koyɗe makko, paɗɗon mo toon yaasin nder nimre. Toon o woyan, omo ŋerƴodira nyiiƴe. » ");
INSERT INTO fuh_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Nden Iisa wi'i : —Noddaaɓe no ɗuuɗi amma suɓaaɓe ɓeen no pamɗi. ");
INSERT INTO fuh_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Iɓe ɗon nii sey *Fariisa'en njehi ndawridowi no tunnirta Iisa ngam nanngude mo nder haalaaji mum. ");
INSERT INTO fuh_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ɓe lili aahiiɓe maɓɓe gom he tokkuɓe *Hirudus to Iisa. Lilaaɓe ɓeen mbi'i Iisa : —Moodibbo, miɗen anndi ko goonga tan kaalataa. Aɗa janngina laawol Alla goonga e goonga. A hulataa neɗɗo fuu, a ɓurdinaay himɓe. ");
INSERT INTO fuh_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ndenne, haalan min se no hegii min kokka laamiiɗo *Rooma mawɗo janngal naa hegaaki ? ");
INSERT INTO fuh_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Amma ngam Iisa no anndi anniyaaji maɓɓe bonɗi ɗiin. O wi'i ɓe : —Onon munafikiiɓe ! Ɗume waɗi ko oɗon tunna kam ? ");
INSERT INTO fuh_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Kollee kam tammal joɓirteengal janngal. Ɓe kolli mo tammal cardi gootal. ");
INSERT INTO fuh_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Nden o ƴami ɓe, o wi'i : —Foto moy he innde moy woni ɗo ? ");
INSERT INTO fuh_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ɓe njaabii mo, ɓe mbi'i : —Laamiiɗo *Rooma. Sey o wi'i ɓe : —Ndenne, kokkee laamiiɗo *Rooma ko jeyi, kokkon Alla duu ko jeyi. ");
INSERT INTO fuh_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Wakkati ɓe nanunoo ko o jaabii ɓe, ɗum haayɗini ɓe. Ɓe acci mo, ɓe ndilli. ");
INSERT INTO fuh_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Nder nyalooma gooto oon, himɓe gom, wonɓe nder hawriine *Sadduki'en ngari to Iisa. Kamɓe ngoni yeddooɓe no mbi'a ko maayɗo fuu ummitittaako. ");
INSERT INTO fuh_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Ɓe ƴami mo, ɓe mbi'i : —Moodibbo, *Muusa wi'iino, nde nii gorko maayi heɓaay ɓiɗɗo, minyum naa mawnum dewla deekiiko ngam heɓana mo jippotooɓe. ");
INSERT INTO fuh_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Waɗinoo worɓe rimdaaɓe jeɗɗo gom. Arano oon dewli, maayi, heɓaay ɓiɗɗo. Minyiiko haɓɓani deekiiko, ");
INSERT INTO fuh_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","kam duu maayi, heɓaay ndimki. Tataɓo oon duu tokki, faa jeɗɗo ɓeen fuu maayi. ");
INSERT INTO fuh_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Gaɗa maayde maɓɓe, debbo oon duu maayi. ");
INSERT INTO fuh_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ndenne, nyannde darŋal, moy nder jeɗɗo ɓeen laatoto goro debbo oo ? Ngam ɓe fuu kaɓɓani mo. ");
INSERT INTO fuh_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Nden Iisa jaabii ɓe, wi'i : —On mboofi, ngam on paamaay ko dewte ɗeen mbi'i, on anndaa duu baawɗe Alla. ");
INSERT INTO fuh_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ngam nyannde maayɓe ummitii, worɓe ndewlataa, rewɓe duu ndewlataake. Himɓe fuu no mbuuran hano no maleykaaɓe mbuurdiri nder kammu. ");
INSERT INTO fuh_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Wooɗi, dow haala ummitaaki maayɓe, ndenne on njanngaay ko Alla wi'i on ɗum naa ? O wi'i : ");
INSERT INTO fuh_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Miin woni Alla *Ibrahim, Alla Isiyaaku, Alla Yakuuba. Nden Iisa ɓeydi wi'ude ɓe : —O Alla wuurɓe, o hanaa Alla maayɓe. ");
INSERT INTO fuh_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Wakkati himɓe nanunoo waaju makko, ɗum haayɗini ɓe sanne. ");
INSERT INTO fuh_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Wakkati *Fariisa'en nanunoo ko Iisa jaalake *Sadduki'en nder yewtere maɓɓe, sey ɓe kawri ngam ndaarodirde kaden. ");
INSERT INTO fuh_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Nden jannginoowo *Tawreeta gom tawaaɗo nder maɓɓe ƴami Iisa ngam tunnude mo, wi'i : ");
INSERT INTO fuh_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Moodibbo, tilsinoore ndeye ɓuri tilsinooje fuu semmbe nder *Tawreeta ? ");
INSERT INTO fuh_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Iisa jaabii mo, wi'i : —Hiɗir Alla Joomiraawo maa he ɓerne maa fuu he yonki maa fuu he hakkillo maa fuu. ");
INSERT INTO fuh_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ɗum woni tilsinoore arandere, kayre duu ɓuri semmbe. ");
INSERT INTO fuh_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ndaa tilsinoore ɗiɗaɓere ndeen nii, ɗe fuu ɗe potu : Ngiɗaa gondo maa no ngiɗirɗaa hoore maa. ");
INSERT INTO fuh_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","*Tawreeta he dewte annabiiɓe ɗeen fuu dow tilsinooje ɗiɗi ɗee tiggii. ");
INSERT INTO fuh_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Wakkati *Fariisa'en kawrunoo nokkuure worre, sey Iisa ƴami ɓe, wi'i : ");
INSERT INTO fuh_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—Ɗume miiliɗon dow *Almasiihu ? O taan moy ? Nden ɓe njaabii mo, ɓe mbi'i : —O taan Daawda. ");
INSERT INTO fuh_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","O wi'i ɓe kaden : —Ndenne, noy Daawda nder baawɗe *Ruuhu Alla noddiri mo Joomam wakkati o wi'unoo : ");
INSERT INTO fuh_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Alla Joomiraawo wi'i Joomiraawo am : War, njooɗaa nyaamo am, faa mi sorna wayɓe maa ley teppere maa. ");
INSERT INTO fuh_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Nde nii Daawda noddiri mo Joomiraawo, ndenne, noy o laatortoo taanum tan ? ");
INSERT INTO fuh_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ɓe fuu ɓe keppi jaabaade mo. Illa nyannde mum, neɗɗo fuu suusaay ƴamude mo goɗɗum kaden. ");
INSERT INTO fuh_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Wakkati jama'aare hawrunoo hadde Iisa, o haalani nde, kayre he *aahiiɓe makko, o wi'i : ");
INSERT INTO fuh_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Jannginooɓe *Tawreeta he *Fariisa'en, kam'en kalfinaa jannginol *Tawreeta Muusa. ");
INSERT INTO fuh_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ngam majjum waɗi, oɗon kaani waɗude huune fuu ko ɓe mbi'i on. Amma to nyemminee golleeji maɓɓe, ngam ɓe ngaɗataa ko ɓe mbaajotoo. ");
INSERT INTO fuh_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Iɓe kaɓɓa donle tedduɗe, ɗe donngal mum'en no tiiɗi, ɓe ndeka dow himɓe. Amma ɓe ngiɗaa meemirde ɗe baa daane honndu maɓɓe ngam wallude ɓe. ");
INSERT INTO fuh_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Huune fuu ko ɓe ngaɗata, ɓe ngaɗan ɗum ngam himɓe ngi'a. Iɓe kaɓɓa talki mawɗi dow tiiɗe maɓɓe he jokkule juuɗe maɓɓe, iɓe njuutina daane kolte maɓɓe faa no ndaasoo. ");
INSERT INTO fuh_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Iɓe ngiɗi jooɗorɗe ɓurɗe teddude nde nii ɓe noddaama batu. Iɓe ngiɗi duu jooɗorɗe ɓurɗe teddude nder *baajorɗi. ");
INSERT INTO fuh_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Iɓe ngiɗi sanneede cannooje tedduɗe nder luuɓe he noddireede « moodibbo ». ");
INSERT INTO fuh_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Amma onon, to njaɓee noddireɗon « moodibbo », ngam Moodibbo gooto tan ngooduɗon. On fuu on banndiraaɓe. ");
INSERT INTO fuh_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","To mbi'ee neɗɗo fuu « baaba » nder duuniyaaru. Ngam *Baabiraawo gooto tan ngooduɗon, gonɗo dow. ");
INSERT INTO fuh_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","To njaɓee noddireɗon « hooreejo ». Ngam Hooreejo gooto tan ngooduɗon, kanko woni *Almasiihu. ");
INSERT INTO fuh_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ɓurɗo teddude hakkune mooɗon laatoo golloowo mooɗon. ");
INSERT INTO fuh_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ƴettuɗo hoore mum dow, no leesintee. Leesinɗo hoore mum, no ƴettetee. ");
INSERT INTO fuh_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Bone saaman dow mooɗon onon jannginooɓe *Tawreeta he *Fariisa'en, munaafiki'en ! Oɗon ommbana himɓe dammbugal Laamu Alla. Onon e ko'e mooɗon, on naatataa. On accataa naatooɓe naata.  ");
INSERT INTO fuh_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Bone saaman dow mooɗon, onon jannginooɓe *Tawreeta he *Fariisa'en, munaafiki'en ! Oɗon nyaama njawdi rewɓe ɓe goriraaɓe mum'en maayi, oɗon njunna du'aa'uuji mooɗon ngam ngi'eɗon. Ngam majjum, on kiitetee kiite naawɗe. ");
INSERT INTO fuh_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Bone saaman dow mooɗon, onon jannginooɓe *Tawreeta he *Fariisa'en, munaafiki'en ! Oɗon piiloo nder leyɗe, oɗon peddita maayooji ngam keɓon neɗɗo gooto tuubuɗo tokki on. Amma nde nii on keɓii mo, sey ngaɗon o laatoo ɓii-jahannama ɓurde on. ");
INSERT INTO fuh_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Bone saaman dow mooɗon, onon wumɓe, ɗowooɓe himɓe ! Oɗon mbi'a : « Nde neɗɗo hunorake *Juulirde mawne ɗum ɓolum, amma nde hunorake kanŋe mayre, hunayeere mum nanngan. » ");
INSERT INTO fuh_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Wumɓe, bahimaaɓe ! Ɗume ɓuri teddude : Kanŋe ɗeen naa Juulirde senɗinoore kanŋe ɗeen ? ");
INSERT INTO fuh_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Oɗon mbi'a kaden : « Nde neɗɗo hunorake sakkirde ɗum ɓolum, amma nde joomum hunorake sadaka gonɗo dow mayre oon, hunayeere mum nanngan. » ");
INSERT INTO fuh_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Wumɓe ! Ɗume ɓuri teddude : Sadaka oon naa sakkirde senɗinoore sadaka oon ? ");
INSERT INTO fuh_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ndenne, neɗɗo fuu kunoriiɗo sakkirde ndeen, hunorake nde, kayre he huune fuu ko yowaa dow mayre. ");
INSERT INTO fuh_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Neɗɗo fuu kunoriiɗo Juulirde ndeen, hunorake nde, kayre he Alla gonɗo nder mayre. ");
INSERT INTO fuh_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Neɗɗo fuu kunoriiɗo kammu, hunorake jooɗorgal Alla ngaal he Jooɗiiɗo dow maggal. ");
INSERT INTO fuh_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Bone saaman dow mooɗon, onon jannginooɓe *Tawreeta he *Fariisa'en, munaafiki'en ! Oɗon ittana Alla *jakka baa dow kaakooli mbelɗi ɗi ndemoton hano mantu, anisa he kume. Amma oɗon njeeboo ko ɓuri huune fuu teddude nder tilsinooje *Tawreeta : Kanƴe ngoni dartinaaku, yurmeene he goonɗinol. Ɗum kaanuɗon waɗude tawee on mboppaay ɗiito duu. ");
INSERT INTO fuh_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Onon wumɓe ardiiɓe himɓe ! Oɗon cuuta buubel, amma oɗon moɗa ngolooba ! ");
INSERT INTO fuh_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Bone saaman dow mooɗon, onon jannginooɓe *Tawreeta he *Fariisa'en, munaafiki'en ! Oɗon lawƴa gaɗa kore e gaɗa le'e mooɗon, amma har nder iɗe keewi golleeji mooɗon bonɗi, gineeji guyka e kiram. ");
INSERT INTO fuh_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Fariisaajo bumɗo ! Lawƴu nder kore ɗeen ginan, nden gaɗa majje duu laaɓan. ");
INSERT INTO fuh_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Bone saaman dow mooɗon, onon jannginooɓe *Tawreeta he *Fariisa'en, munaafiki'en ! Oɗon nanndi he annyeeje dawninaaɗe, ɗe dow mum'en no mbooɗi, tawee nder toon no heewi gi'e maayɓe he ko tuuni fuu. ");
INSERT INTO fuh_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Onon duu, hano non nga'uɗon : He hitere oɗon nanndi dartiiɓe, amma nder mooɗon no heewi pet he munafikaaku he rafi dartinaaku. ");
INSERT INTO fuh_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Bone saaman dow mooɗon, onon jannginooɓe *Tawreeta he *Fariisa'en, munaafiki'en ! Oɗon nyiɓana annabiiɓe annyeeje lobbe, oɗon peɗa annyeeje dartiiɓe. ");
INSERT INTO fuh_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Oɗon mbi'a : « Nde nii min pottiino he jamaanu maamiraaɓe amin, nden min kaɓɓiditaano daane he maɓɓe nder barol annabiiɓe. » ");
INSERT INTO fuh_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Nii kollirɗon ko onon he ko'e mooɗon on jippotooɓe he warunooɓe annabiiɓe. ");
INSERT INTO fuh_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ndenne, kuumnee ko maamiraaɓe mooɗon puɗɗunoo ! ");
INSERT INTO fuh_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Firsooje, ɓiɓɓe bolle bonɗe ! Noy ndaɗirton kiite jahannama ? ");
INSERT INTO fuh_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ngam majjum waɗi miɗo lilda on annabiiɓe, jom'en hikmaaku he jannginooɓe *Tawreeta. On mbaran woɓɓe maɓɓe, tonton woɓɓe nder maɓɓe, ɓoccon woɓɓe maɓɓe nder *baajorɗi mooɗon, oɗon tokkitii ɓe wuro warde wuro oɗon tampina ɓe. ");
INSERT INTO fuh_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ndenne, onon Alla tampinta ngam sabbu yonkiiji dartiiɓe ittaaɗi nder duuniyaaru nduu ɗiin. Illa *Haabiila dartiiɗo oon faa wara he Jakariya ɓii-Barakiya mo mbarnoɗon caka *Juulirde mawne he sakkirde oon. ");
INSERT INTO fuh_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Goonga kaalananmi on : Kiite majjum fuu saaman dow himɓe jamaanu oo ! ");
INSERT INTO fuh_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","—Hey *Ursaliima ! *Ursaliima, huɓeere warude annabiiɓe. A wariri lilaaɓe he maaɗa kaaƴe ! Mi muuyi kile keewɗe hawrude ɓiɓɓe maa hano no gortogal hawrirta coppi mum ley bippoole nii. Amma a jaɓaay. ");
INSERT INTO fuh_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Joonin kam nii ɓaade mooɗon no ɗon no woppee. Neɗɗo fuu jooɗotaako nder, nde laatotoo winnde. ");
INSERT INTO fuh_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Miɗo wi'a on : On ngi'ataa kam illa joonin faa wara wakkati mo mbi'oyton : Barkinaaɗo woni garɗo dow innde Joomiraawo ! ");
INSERT INTO fuh_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Wakkati Iisa wurtinoo nder *Juulirde mawne ndeen, sey *aahiiɓe makko ɓadii mo, kolli mo nyibdi mayre. ");
INSERT INTO fuh_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Nden o haalani ɓe, o wi'i : —On ngi'ii kujje ɗee fuu naa ? Goonga kaalananmi on : Baa hayre worre hoddataako no deki dow wonnde. Ndi fuu ndi liɓetee. ");
INSERT INTO fuh_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Wakkati Iisa jooɗinoo dow waamnde wi'eteene waamnde Jaytun ndeen, sey *aahiiɓe ɓeen ngari to makko kam'en tan, mbi'i mo : —Haalan min nde ɗum waɗata ? Alaama oye hollata gartol maa, he timmoode duuniyaaru ? ");
INSERT INTO fuh_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Nden Iisa jaabii ɓe, wi'i : —Kakkilee to neɗɗo fuu majjina on. ");
INSERT INTO fuh_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ngam heewɓe no ngardan innde am, iɓe mbi'a : « Miin woni *Almasiihu. » Ɓe majjina himɓe heewɓe. ");
INSERT INTO fuh_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","On nanan habaru konuuji naa siri majji, amma to kulee. No tilsi ɗum waɗa, amma ɗum hanaa alaama kolloowo timmoode duuniyaaru. ");
INSERT INTO fuh_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Lenyol habdan he lenyol, laamu habdan he laamu. Rafooji he dimmbaaki leydi ngaɗan nokku nokkuuje. ");
INSERT INTO fuh_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Kujje garooje ɗee fuu, nanndoytaana he fuɗɗorde ŋatawere. ");
INSERT INTO fuh_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Nden nanngeɗon, njaareɗon nder kiitorɗe ngam torreɗon, mbareɗon. Lenyi ɗiin fuu mbanyan on ngam sabbu am. ");
INSERT INTO fuh_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Wakkati mum, heewɓe nder goonɗinɓe pergoto, mboppa goonɗinol mum'en, tinnoo no njammbodira, no mbanyodira. ");
INSERT INTO fuh_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Annabiiɓe fewreeɓe heewɓe mbanngan, kiila himɓe heewɓe. ");
INSERT INTO fuh_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Bonandaaji keewan faa hidde himɓe heewɓe ɓuytoo. ");
INSERT INTO fuh_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Amma tarsiniiɗo faa yottii he timmoode, joomum no hisintee. ");
INSERT INTO fuh_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","*Habaru lobbo filla Laamu Alla no sankitittee nder duuniyaaru fuu, faa o fillee nder lenyol fuu. Nden duuniyaaru timma. ");
INSERT INTO fuh_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","—On ngi'an huune bonde, ɓurne nyiddinaade nde annabi Daniyel haalunoo filla muuɗum. Huune ndee, waddetee nder nokkuure seniine ndeen. (Jannguɗo ɗum fuu faama ɗum no wooɗiri.) ");
INSERT INTO fuh_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Nden tawaaɓe nder Yahudiya fuu ndoggira baamle. ");
INSERT INTO fuh_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Tawaaɗo dow suudu fuu, to jippoo hooƴa ginol gom nder mayru. ");
INSERT INTO fuh_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Tawaaɗo ngesa, to yeeƴito hooƴa koltal mum. ");
INSERT INTO fuh_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Nder balɗe mum bone no saaman dow saawɓe he musinooɓe ! ");
INSERT INTO fuh_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Eelee Alla to doggudu mooɗon nduun fottodir he dunngu naa *nyalaane fowteteene. ");
INSERT INTO fuh_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ngam nder wakkati mum, torra mawka no waɗan kaa hano mum waɗaayno illa fuɗɗorde duuniyaaru faa warde hannden. Iri makka waɗataa kaden duu faa abada. ");
INSERT INTO fuh_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Nde nii tawiino balɗe ɗeen raɓɓinɗinaaka, neɗɗo fuu hisataano. Amma Alla raɓɓinɗinii ɗe ngam suɓaaɓe muuɗum. ");
INSERT INTO fuh_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Nder wakkati mum, nde nii goɗɗo wi'i on, ndaaree *Almasiihu nii ɗo naa too'en, to ngoonɗinee joomum. ");
INSERT INTO fuh_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ngam almasiihuuɓe fewreeɓe he annabiiɓe fewreeɓe mbanngowan, ɓe ngaɗa alamaaji mawɗi he kaayɗe, ngam majjinde baa suɓaaɓe Alla ɓeen, nde nii no waɗoo. ");
INSERT INTO fuh_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Paamee ko mi haalani on ɗum illa ɗum waraay. ");
INSERT INTO fuh_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Nde nii on mbi'aama : « Kanko nii nder ladde yeeruure », to njehee. Naa nde nii ɓe mbi'ii on : « Kanko nii to nder cuuɗi », to ngoonɗinee. ");
INSERT INTO fuh_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Hano no maƴƴere yaynirta nder kammu illa lettugal faa gorgal, hano non *Ɓii-Neɗɗo wardata. ");
INSERT INTO fuh_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","To caangu woni, ɗon jigaaje kawrata. ");
INSERT INTO fuh_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","—Gaɗa saɗɗormaaji nyalaaɗe ɗeen, sey naange niɓɓa, lewru accaa yeynude, koode caama, Alla waɗa baawɗe gonɗe dow fuu ndimmboo. ");
INSERT INTO fuh_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Wakkati mum, alaama *Ɓii-Neɗɗo wanngata dow, ɓerɗe lenyi duuniyaaru fuu mettan. Ɓe ngi'an *Ɓii-Neɗɗo no wara dow duule. Omo warda baawɗe e teddungal manngal. ");
INSERT INTO fuh_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Luwal manngal fuufee, nden o lila maleykaaɓe makko nder kappa kuula duuniyaaru fuu, ɓe kawrowa suɓaaɓe makko, illa hoore leydi ndii faa hoore leydi ndiito. ");
INSERT INTO fuh_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Too, ndaaree ibbi kii, ekkitoɗon goɗɗum he makki. Nde nii licce makki keyɗitii, kaakooli makki mbilitii, oɗon anndi ko dunngu ɓadake. ");
INSERT INTO fuh_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Hano non kaden, nde nii on ngi'ii kujje ɗee fuu no ngara, paamee ko wakkati oon ɓadake, *Ɓii-Neɗɗo no dammbugal wuro. ");
INSERT INTO fuh_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Goonga kaalananmi on : Jamaanu oo timmataa tawee kujje ɗee fuu ngaraay. ");
INSERT INTO fuh_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Kammu e leydi taggan, amma haalaaji am timmataa abada. ");
INSERT INTO fuh_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","—Walaa annduɗo nyalaane ndeen naa wakkati mo ɗum waɗoyta, baa maleykaaɓe wonɓe dow ɓeen, naa Ɓiɗɗo oon anndaa ɗum, sey nii *Baabiraawo oon tan. ");
INSERT INTO fuh_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Hano no ɗum waɗirnoo nder jamaanu Nuhu, hano non gartol *Ɓii-Neɗɗo duu waɗirta. ");
INSERT INTO fuh_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Hano no fadde ndiyam tuufaana warde, himɓe no nyaama, no njara, no ɓaŋa, no ɓaŋee, faa nyannde Nuhu naati laana kaan. ");
INSERT INTO fuh_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ɓe paamaay fuu nder ko ɓe ngoni, naako ndiyam tuufaana wari, yooli ɓe, ɓe fuu. Hano non duu gartol *Ɓii-Neɗɗo, waɗirta. ");
INSERT INTO fuh_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Wakkati mum, worɓe ɗiɗo tawetee nder ngesa. Gooto hooƴee, ooto accee. ");
INSERT INTO fuh_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Rewɓe ɗiɗo tawetee no unida dow boɓi. Gooto hooƴee, ooto accee. ");
INSERT INTO fuh_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ndenne, tinnee heɓa taweɗon on ciryiiɓe, ngam on anndaa wakkati Joomiraawo mooɗon wartoyta. ");
INSERT INTO fuh_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Paamee, ko nde nii jom wuro no anndi wakkati mo gujjo warta nder jemma, nden o ɗaanataakono, o acca oon naata suudu makko. ");
INSERT INTO fuh_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ndenne, onon duu ciryee, to gartol *Ɓii-Neɗɗo juhu on. ");
INSERT INTO fuh_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","—Moy woni golloowo kolniiɗo, jom hakkillo ? Golloowo mo mawɗo mum halfini ɓaade mum, wi'i o hokka maccuɓe mum gom nyaamdu mum'en nder wakkati mo haani. ");
INSERT INTO fuh_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Belɗo hoore woni golloowo mo mawɗo mum warti, tawi no waɗa golle mum. ");
INSERT INTO fuh_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Goonga kaalananmi on : Mawɗo oon no halfinan mo njawdi mum fuu. ");
INSERT INTO fuh_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Amma nde golloowo oon no bonɗo, o wi'annoo hoore makko, mawɗo am wartilawtaa. ");
INSERT INTO fuh_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Sey o fuɗɗa fiyude banndiraaɓe makko gollooɓe. Omo nyaamda, omo yarda he jarooɓe. ");
INSERT INTO fuh_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Too, mawɗo golloowo oo no wartan nyannde nde o miilaaka. ");
INSERT INTO fuh_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Mawɗo makko riiwan mo, fiya mo sawru munafikiiɓe, toon o woyata omo ŋerƴodira nyiiƴe. ");
INSERT INTO fuh_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","—Ndaa Laamu Alla nanndaana he taariihi surbaaɓe sappo, ɓe anndaa worɓe, kooƴuɓe fitillaaji mum'en njehi faa njaɓɓowoo ɓaŋuɗo gom. ");
INSERT INTO fuh_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Nder maɓɓe joyo ngalaa hakkillo, joyo ɓeeto duu no jom'en hakkillo. ");
INSERT INTO fuh_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ɓe ngalaa hakkillo ɓeen kooƴi fitillaaji mum'en amma pantiraay nebbam. ");
INSERT INTO fuh_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Jom'en hakkillo ɓeen kay adi fitillaaji mum'en, ɓe njaldi nebbam nder paali maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ɓaŋuɗo oon jenngi waraay, ɓe fuu ɓe ŋoŋi, sey ɓe ɗaanii. ");
INSERT INTO fuh_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Har caka jemma, kuuɓaali nanaa, no wi'ee : « Ɓaŋuɗo wari ! Ɓaŋuɗo wari ! Ummee njaɓɓowee mo ! » ");
INSERT INTO fuh_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Sey surbaaɓe ɓeen fuu pini, no moƴƴina fitillaaji mum'en. ");
INSERT INTO fuh_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Surbaaɓe ɓe ngalaa hakkillo ɓeen mbi'i jom'en hakkillo ɓeen : « Kokkaree min seɗɗa he nebbam mooɗon, fitillaaji amin no ɗon no nyifa. » ");
INSERT INTO fuh_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Jom'en hakkillo ɓeen njaabii, mbi'i : « Ɗam heƴataa en, en fuu. Njehee to sonnooɓe ɓeen, coodowon no ɓuri ! » ");
INSERT INTO fuh_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Wakkati ɓe mburtii, ɓe coodowi nebbam, sey ɓaŋuɗo oon yottii. Siryiiɓe taɓɓitaade mo ɓeen naatidi he makko nder batu nguun, nden dammbugal ngal ommbaa. ");
INSERT INTO fuh_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ɓooyi seɗɗa gaɗa mum, sey surbaaɓe wurtiiɓe ɓeen ngarti, tawi ingal ommbii. Ɓe tiimi iɓe nodda, iɓe mbi'a : « Moodibbo, Moodibbo ! Omtan min ! » ");
INSERT INTO fuh_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Amma ɓaŋuɗo oon jaabii ɓe, wi'i : « Goonga kaalananmi on : Mi anndaa on. » ");
INSERT INTO fuh_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Nden Iisa sakitii wi'i ɓe : —Kakkilee ndenne, ngam on anndaa nyalaane ndeen naa wakkati oon. ");
INSERT INTO fuh_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","—Laamu Alla no nanndi he gorko gom gaɗuɗo jahaangal, noddi gollooɓe mum, halfini ɓe njawdi mum. ");
INSERT INTO fuh_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Gooto nder maɓɓe o halfini ɗum cabbi kanŋe keme joy, ooto o halfini ɗum cabbi keme ɗiɗi, tataɓo oon cabbi hemre. Neɗɗo maɓɓe fuu dey-dey he ko waawi, gaɗa mum o dilli. ");
INSERT INTO fuh_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Wakkati mum da, kalfinaaɗo cabbi kanŋe keme joy oon yehi luumorii ɗi, heɓi cabbi keme joy gom. ");
INSERT INTO fuh_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Jom keme ɗiɗi oon duu, luumorii ɗi mum, heɓi kam duu cabbi keme ɗiɗi gom. ");
INSERT INTO fuh_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Amma jom cabbi hemre oon kay wasoy ngayka non, ufi ko hokkanoo ɗum fuu. ");
INSERT INTO fuh_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Ɓooyi seɗɗa gaɗa majjum, sey nyannde gom mawɗo maɓɓe warti, noddi ɓe, ngam daara, hiiso ceede ɗeen. ");
INSERT INTO fuh_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Kalfinaaɗo cabbi kanŋe keme joy oon wari, waddi cabbi keme joy gom, wi'i : « Joomam, a halfinii kam cabbi keme joy. Ndaa, mi luumorake ɗi, mi heɓi cabbi keme joy gom. » ");
INSERT INTO fuh_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Sey joomiiko wi'i mo : « Gasii. A golloowo lobbo, kolniiɗo. Ngam a hilnake ko famɗi, mi halfinte ko ɗuuɗi. War naatu, mbelniden ! » ");
INSERT INTO fuh_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Kalfinaaɗo cabbi keme ɗiɗi oon duu wari, wi'i : « Joomam, a halfinii kam cabbi kanŋe keme ɗiɗi. Ndaa, mi lumtorake ɗi, mi heɓi cabbi keme ɗiɗi gom. » ");
INSERT INTO fuh_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Sey joomiiko wi'i mo : « Gasii. A golloowo lobbo, kolniiɗo. Ngam a hilnake ko famɗi, mi halfinte ko ɗuuɗi. War naatu, mbelniden ! » ");
INSERT INTO fuh_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Kalfinaaɗo cabbi kanŋe hemre oon wari, kam duu, wi'i : « Joomam, miɗo anndi a gorko cattuɗo. Aɗa hetta ko a aawaay. Aɗa ɓotta ko a hawraay. ");
INSERT INTO fuh_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ngam majjum waɗi, kulumi, njehumi, ufoymi kanŋe maa. Joonin, ndaa cabbi maaɗa nii. » ");
INSERT INTO fuh_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Sey joomiiko jaabii mo, wi'i : « Bonɗo, jaayɗo ! Janɗo ! Aɗa anndi miɗo hetta ko mi aawaay, miɗo ɓotta ko mi hawraay ? ");
INSERT INTO fuh_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Nde nii a wattiino kanŋe am ɗeen nder banki, faa nde ngartumi, nden ɗe ngaddanan kam riiba. ");
INSERT INTO fuh_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Joonin, teetee cabbi kanŋe hemre ɗiin, kokkon ɗi jom keme joy oon. ");
INSERT INTO fuh_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ngam jogiiɗo fuu no ɓeydantee faa heewa. Amma mo walaa oon, baa seɗɗa mo jogii oon, no teetetee. ");
INSERT INTO fuh_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Paɗɗee golloowo jaayɗo oo yaasin nder nimre. Toon, o tinnotoo omo woya, omo ŋerƴodira nyiiƴe. » ");
INSERT INTO fuh_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","—Wakkati *Ɓii-Neɗɗo wardi he teddungal mum, he maleykaaɓe mum fuu, o jooɗoto dow jooɗorgal laamu makko teddungal. ");
INSERT INTO fuh_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Himɓe duuniyaaru fuu no kawretee yeeso makko, o senndan ɓe, no duroowo senndirta baali he be'i mum. ");
INSERT INTO fuh_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","O wartiran baali ɗiin har junngo makko nyaamo, o wartira be'i ɗiin har nano makko. ");
INSERT INTO fuh_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Wakkati mum Laamiiɗo oon wi'a wonɓe nyaamo makko : « Ngaree, onon ɓe *Baabiraawo am barkini, ndonee laamu ngu ndesanaɗon illa tagol duuniyaaru. ");
INSERT INTO fuh_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ngam mi rafanooma, on nyamnii kam. Mi ɗomɗiino, on njarnii kam. Mi laatakeno beero, on mbernii kam. ");
INSERT INTO fuh_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Mi walaano koltal, on koltinii kam. Mi nyawiino, on kilnake kam. Mi uddanooma, on ndaarowii kam. » ");
INSERT INTO fuh_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Nder wakkati mum, dartiiɓe ɓeen njaabotoo mo, mbi'a : « Joomiraawo, wakkati oye min ngi'ii ndafeɗaa, min nyamnii ma, naa wakkati oye ɗomɗeɗaa, min njarnii ma ? ");
INSERT INTO fuh_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Wakkati oye min ngi'ii a beero, min mbernii ma, naa a walaa koltal, min koltinii ma ? ");
INSERT INTO fuh_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Naa wakkati oye min ngi'ii a nyawɗo naa a uddaama, min ndaarowii ma ? » ");
INSERT INTO fuh_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Sey Laamiiɗo oon jaaboo ɓe wi'a : « Goonga kaalananmi on : Ko ngaɗanɗon gooto nder ɓurɗo famɗude nder banndiraaɓe am fuu, miin ngaɗanɗon. » ");
INSERT INTO fuh_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Gaɗa mum, o wi'an wonɓe nano makko : « Mboɗɗee kam, onon naalaaɓe ! Njehee nder hiite duumiinge, nge Alla resani Ibiliisa he maleykaaɓe tokkuɓe mo ! ");
INSERT INTO fuh_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ngam mi rafaama, on nyamnaay kam. Mi ɗomɗaama, on njarnaay kam. ");
INSERT INTO fuh_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Mi weeraniino on, on njippinaay kam. Mi walaano koltal, on koltinaay kam. Mi nyawiino, mi uddanooma, on ngaraay ndaaruɗon kam. » ");
INSERT INTO fuh_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Sey ɓe njaaboo mo kamɓe duu, ɓe mbi'a : « Joomiraawo, wakkati oye min ngi'ii ndafeɗaa, naa ɗomɗeɗaa, naa mbeeruɗaa, naa a holtaay, naa nyawɗaa, naa uddeɗaa, min mballaay ma ? » ");
INSERT INTO fuh_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Wakkati mum sey o jaaboo ɓe o wi'a : « Goonga kaalananmi on : Ko on ngaɗanaay gooto nder ɓurɓe famɗude ɓee, miin woni on ngaɗanaay. » ");
INSERT INTO fuh_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Himɓe ɓee, ngoni naatooɓe nder torra duumiiɗo, amma dartiiɓe ɓeen duu ngoni keɓooɓe mbuurnam nduumiiɗam. ");
INSERT INTO fuh_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Wakkati Iisa timminnoo waaju mum, o wi'i *aahiiɓe makko : ");
INSERT INTO fuh_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Oɗon anndi ko balɗe ɗiɗi kori he *Juulɗe dimɗinol Isra'ilankooɓe, *Ɓii-Neɗɗo hokkitirtee ngam tontee dow *leggal bardugal. ");
INSERT INTO fuh_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Mawɓe *cakkanooɓe Alla e mawɓe *Yahudankooɓe kawri wuro mawɗo mawɓe *cakkanoowo Alla gom bi'eteeɗo Kayafas. ");
INSERT INTO fuh_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ɓe caawodiri ngam ɓe keɓa no ɓe kiiliri Iisa ɓe nannga, ɓe mbara mo. ");
INSERT INTO fuh_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Amma ɓe mbi'i : —To en ngaɗu ɗum wakkati juulɗe ɗeen, ngam to himɓe murtu. ");
INSERT INTO fuh_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Wakkati Iisa wonnoo Baytaniya nder ɓaade Simon inndirteeɗo Simon Ceppinnga, ");
INSERT INTO fuh_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","debbo gom ɓadii mo no jogii faanu nebbam uurɗam, caadiɗam sanne. O tawi Iisa no nyaama, o joorti ɗam dow hoore makko. ");
INSERT INTO fuh_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Wakkati *aahiiɓe ɓeen ngi'unoo ɗum, ɓerɗe maɓɓe metti, iɓe mbi'a : —Ɗum bonnere, ɗume ɗum nafata ? ");
INSERT INTO fuh_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Iɗam waawi sonneede ceede ɗuɗɗe, ɗe kokkee talkaaɓe. ");
INSERT INTO fuh_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Iisa faami ko ɓe ngoni iɓe kaala, nden o wi'i ɓe : —Ko waɗi ko oɗon torra debbo oo ? Ko o waɗani kam ɗum no wooɗi sanne. ");
INSERT INTO fuh_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Talkaaɓe no tawdee he mooɗon wakkati fuu. Amma miin, mi tawdataake he mooɗon wakkati fuu. ");
INSERT INTO fuh_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","O wuji nebbam uurɗam ɗam he ɓanndu am ngam siryaade mooɓol am. ");
INSERT INTO fuh_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Goonga kaalananmi on, nokku fuu to *Habaru lobbo oo waajaa nder duuniyaaru, ko debbo oo waɗi ɗum no filletee ngam miccitaade he makko. ");
INSERT INTO fuh_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Yahuuda Iskariyot, gooto nder *lilaaɓe sappo e ɗiɗo ɓeen, yehi to mawɓe *cakkanooɓe Alla ɓeen, ");
INSERT INTO fuh_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","wi'i ɓe : —Ɗume kokkoton kam nde nii mi watti Iisa nder juuɗe mooɗon ? Nden ɓe kokki mo tammaaje cardi woronja. ");
INSERT INTO fuh_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Illa nyannde mum, Yahuuda no tefa, no jammborii Iisa. ");
INSERT INTO fuh_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Nyalooma arano *Juulɗe buuru mo walaa ƴuufinirɗum, *aahiiɓe ɓeen ngari to Iisa, ƴami mo, mbi'i : —Toy ngiɗaa min ciryanowe hiraane *Juulɗe dimɗinol Isra'ilankooɓe ? ");
INSERT INTO fuh_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","O jaabii ɓe, o wi'i : —Njehee nder huɓeere to waane, mbi'on mo : « Moodibbo wi'i, wakkati oon yonii. Nder ɓaade maaɗa kam waɗata *Juulɗe dimɗinol Isra'ilankooɓe ɗeen, kanko he *aahiiɓe makko. » ");
INSERT INTO fuh_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Sey *aahiiɓe ɓeen ngaɗi ko Iisa wi'i ɓe, ɓe ciryii hiraane ndeen. ");
INSERT INTO fuh_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Futuro, wakkati naange yanunoo, Iisa jooɗodii he *lilaaɓe sappo e ɗiɗo ɓeen iɓe ndoomi hiraane ndeen. ");
INSERT INTO fuh_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Wakkati ɓe kiirtotonoo ndeen, o wi'i : —Goonga kaalananmi on : Gooto nder mooɗon no jammboto kam. ");
INSERT INTO fuh_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Sey ɓe ɓalinii sanne, ɓe keddii iɓe ƴama mo gooto gooto, neɗɗo fuu no wi'a mo : —Moodibbo, kori hanaa miin non ? ");
INSERT INTO fuh_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","O jaabii ɓe, o wi'i : —Cuuwidiɗɗo he am junngo mum nder le'al ngaal, oon jammbotoo kam. ");
INSERT INTO fuh_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","*Ɓii-Neɗɗo accan duuniyaaru hano no ɗum winndiraa dow makko nder dewte. Amma bone saaman dow jammbotooɗo mo ! Joomum nde nii rimaakano, nden no ɓurananoo ɗum. ");
INSERT INTO fuh_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yahuuda jammboytooɗo mo oon fiirti hunnduko, ƴami mo, wi'i : —Moodibbo, kori hanaa miin non ? O jaabii mo, o wi'i : —Aan haali he hunnduko maa. ");
INSERT INTO fuh_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Wakkati ɓe nyaamannoo ndeen, Iisa hooƴi buuru, yetti Alla, helti mo, hokki *aahiiɓe mum, wi'i : —Njaɓee, nyaamee. Ɗum woni ɓanndu am. ");
INSERT INTO fuh_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Gaɗa mum, o hooƴi nyeɗerde cabiijam, o yetti Alla, o hokki ɓe, o wi'i : —Njaree, on fuu. ");
INSERT INTO fuh_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ɗum woni ƴiiƴam am tabbintinoojam amaana Alla, ƴiiƴam ndufeteeɗam ngam hakkeeji himɓe heewɓe njaafee. ");
INSERT INTO fuh_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Miɗo haalana on : Mi yarataa cabiijam ɗam kaden, sey nii nyannde njardowanmi kesam gom he mooɗon nder Laamu *Baabiraawo am. ");
INSERT INTO fuh_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Gaɗa ɓe njimi jimi *Jabuura, ɓe mburtii, ɓe njehi dow waamnde wi'eteene waamnde Jaytun. ");
INSERT INTO fuh_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Dow waamnde ndeen Iisa wi'i *aahiiɓe sappo e ɗiɗo ɓeen : —Nder jemma oo, on fuu on mboppan kam, ngam no winndaa, wi'aa : Mi fiyan duroowo oon, sewre baali ndeen sankitoo. ");
INSERT INTO fuh_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Sey o wi'i ɓe kaden : —Nde mi ummitake, mi artan on Galili. ");
INSERT INTO fuh_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Nden Piyer itti hunnduko, wi'i mo : —Baa nde nii ɓe fuu ɓe pergake, ɓe mboppi ma, miin kay, abada mi woppataa ma. ");
INSERT INTO fuh_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Iisa jaabii mo, wi'i : —Goonga kaalananmaami : Nder jemma oo, fadde ndontoori jogginde, a wi'an a anndaa kam kile tati ! ");
INSERT INTO fuh_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Sey Piyer wi'i mo : —Baa nde a maayan non, mi maaydan he maaɗa, abada mi wi'ataa mi anndaa ma. Non *aahiiɓe ɓeeto duu mbi'i. ");
INSERT INTO fuh_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Iisa he *aahiiɓe mum ummii, njehi nokkuure wi'eteene Gesemaane, toon o wi'i ɓe : —Njooɗee ɗo, faa mi du'owo. ");
INSERT INTO fuh_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","O yahdi Piyer he ɓiɓɓe Jebede ɗiɗo ɓeen Yakuuba he Yahaaya. Iɓe ɗon nii sey taƴo-taƴo fuɗɗi nanngude mo, ɓillaare naatani mo sanne. ");
INSERT INTO fuh_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Sey o wi'i ɓe : —Bononda ɓerne am ɗuuɗi sanne faa no tefa warude kam. Ndaree ɗo, ndoomee, kakkilee to on ɗaanee. ");
INSERT INTO fuh_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","O woɗɗi ɓe seɗɗa, o turni yeeso makko faa he leydi, omo du'oo, omo wi'a : —*Baaba, nde nii tawi iɗum waɗoo, woɗɗinam nyeɗerde torra kaa. To ɗum laatoo muuyɗe am, amma ɗum laatoo muuyɗe maa aan. ");
INSERT INTO fuh_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Gaɗa mum o warti, o tawi *aahiiɓe makko no ɗaanii. O wi'i Piyer : —Jaa on mbaawaa doomude kam baa nii yamnde worre naa ? ");
INSERT INTO fuh_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ummee, ndu'ee, to on caamu nder cii'aaki. Ɓerne no hiɗi amma ɓanndu tampi. ");
INSERT INTO fuh_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","O soƴƴii kaden, o du'ii, o wi'i : —*Baaba, nde nii tawi nyeɗerde torra kaa waawtaa woɗɗi kam, sey nii mi yarii nde. Too ! Muuyɗe maa laato. ");
INSERT INTO fuh_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","O warti, o tawi iɓe ɗaanii kaden, ɗoyngol maɓɓe moddi sanne. ");
INSERT INTO fuh_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","O soƴƴii kaden, o du'owii nde tataɓere, hano no o du'orinoo illa arannde nii. ");
INSERT INTO fuh_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Gaɗa mum, o warti to *aahiiɓe makko, o wi'i ɓe : —Oɗon ɗaanii, oɗon powta naa ? Ndaaree, wakkati oon yottake ! *Ɓii-Neɗɗo no wattetee nder juuɗe waɗooɓe hakke. ");
INSERT INTO fuh_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ummee, ndillen ! Ndaa, jammbotooɗo kam oon nii, no wara ! ");
INSERT INTO fuh_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Iisa no caka haala, sey Yahuuda, gooto nder *lilaaɓe sappo e ɗiɗo ɓeen, yottii no wondi he jama'aare mawne. Mawɓe *cakkanooɓe Alla he mawɓe *Yahudankooɓe lili ɓe, iɓe njogii takubaaje he cabbi. ");
INSERT INTO fuh_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Tawi Yahuuda jammbotooɗo mo oon tinndinnoo ɓe wi'i : —Mo mbunndotoomi oon kam woni mo. Nanngon mo. ");
INSERT INTO fuh_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","No ɓe njottorii, sey o fa'i to Iisa, o wi'i : —Foofoo, Moodibbo ! Nden o wunndii mo. ");
INSERT INTO fuh_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Iisa jaabii mo, wi'i : —Giɗo am, waɗu ko waddi ma. Wakkati mum da, ɓe ɓadii Iisa, ɓe caami dow makko, ɓe nanngi mo. ");
INSERT INTO fuh_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Gooto nder wondunooɓe he Iisa ɓeen sorti takubaahi mum, soppi gollanoowo mawɗo *cakkanooɓe Alla fuu, taƴi nowru makko. ");
INSERT INTO fuh_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Nden, Iisa wi'i mo : —Soornu takubaahi maa nder hulgo mum, ngam kaɓidoowo he takubaahi fuu, takubaahi warata ɗum. ");
INSERT INTO fuh_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Oɗon miiloo joonin ko mi waawaa tefude balla to *Baaba am naa ? O lilda kam jonnda maleykaaɓe ɓurɓe cefe soogeeji sappo he ɗiɗi. ");
INSERT INTO fuh_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Too, amma nde nii mi waɗi ɗum, noy ko winndaa nder dewte ɗum tabbitirta ? ");
INSERT INTO fuh_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Wakkati mum, o wi'i jama'aare ndeen : —Ko waɗi ngarduɗon takubaaje e cabbi faa nanngon kam hano miin woni mawɗo murtuɓe ? Wakkati fuu miɗo wondunoo he mooɗon nder *Juulirde mawne, miɗo waajoo, on nanngaay kam. ");
INSERT INTO fuh_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Amma ɗum fuu, ɗum waɗan ngam ko dewte annabiiɓe kaali ɗum tabbita. Wakkati *aahiiɓe makko ɓeen nanunoo haalaaji ɗii, ɓe fuu ɓe ndoggi ɓe mboppi Iisa. ");
INSERT INTO fuh_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Nanngunooɓe Iisa ɓeen njaari Iisa to Kayafas mawɗo *cakkanooɓe Alla fuu. Tawi jannginooɓe *Tawreeta he mawɓe Isra'ilankooɓe kawri. ");
INSERT INTO fuh_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Amma Piyer toowti ɓe seɗɗa, tokkitii ɓe, naako nder batamaare ɓaade mawɗo *cakkanooɓe Alla oon. O naati nder ɓaade ndeen, o jooɗii hadde doomooɓe ɓaade ndeen ngam o hi'a no ɗum sakitortoo. ");
INSERT INTO fuh_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Mawɓe *cakkanooɓe Alla he hawriine dawrooɓe no tefa fewre nde peliri Iisa ngam o waree. ");
INSERT INTO fuh_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Himɓe heewɓe ngari seedanaade mo dow fewre, amma ɗum fuu waɗaay ɓe keɓa no ɓe mbarirta mo. Ko sakitii worɓe ɗiɗo gom ngari, ");
INSERT INTO fuh_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","mbi'i : —Kanko wi'unoo omo waawi liɓude Juulirde meeɗen mawne, o nyiɓitoo nde nder balɗe tati. ");
INSERT INTO fuh_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Nden mawɗo *cakkanooɓe Alla oon ummii, wi'i Iisa : —Ɗume njaabotoɗaa dow ko himɓe ɓee mbi'i ? ");
INSERT INTO fuh_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Iisa wi'aay baafuy. Nden mawɗo *cakkanooɓe Alla oon wi'i mo kaden : —Mi eelirii ma innde Alla duumiiɗo, kaalanaa min ko aan a *Almasiihu *Ɓii-Alla. ");
INSERT INTO fuh_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Iisa jaabii mo, wi'i : —Aan, e hoore maaɗa wi'i ka. Kaden, miɗo wi'a on : Illa joonin, on ngi'an *Ɓii-Neɗɗo no jooɗii nyaamo Jom baawɗe, no wara dow duule. ");
INSERT INTO fuh_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Mone majjum wari mawɗo *cakkanooɓe Alla oon faa o serki kolte makko, o wi'i : —O bonni innde Alla ! Walaa fuu ko kaajaɗon seedaade dow makko kaden ! On narrii noppi mooɗon ko o bonni innde Alla. ");
INSERT INTO fuh_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ɗume miiliɗon ? Sey ɓe njaabii, ɓe mbi'i omo haani wareede. ");
INSERT INTO fuh_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Nder maɓɓe woɓɓe kaarti, tutti dow yeeso Iisa, woɓɓe duu luƴƴii mo. ");
INSERT INTO fuh_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Nder maɓɓe woɓɓe peenyii mo, no mbi'a : —Hey *Almasiihu ! Nde nii a annabiijo, haalan min moy fiyi ma ! ");
INSERT INTO fuh_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Piyer no jooɗii yaasin nder batamaare ɓaade ndeen. Sey korɗo ɓaade ndeen gom ɓadii mo, wi'i : —Aan duu, aɗa wondunoo Iisa ɓii-Galili oo. ");
INSERT INTO fuh_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Hakkune himɓe fuu sey Piyer yeddi, wi'i : —Mi faamaay ko kaalataa. ");
INSERT INTO fuh_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Wakkati Piyer fonndinoo har dammbugal ɓaade ndeen, sey korɗo gom hi'i mo, wi'i wonɓe ɗon ɓeen : —Gorko oo no wondunoo he Iisa mo Nasaratu. ");
INSERT INTO fuh_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Sey Piyer yeddi kaden, huni wi'i : —Mi anndaa gorko oo. ");
INSERT INTO fuh_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ɓooyi seɗɗa gaɗa mum, sey dariiɓe ɗon ɓeen ɓadii Piyer, mbi'i mo : —Sikka fuu walaa, nder maɓɓe njeyaɗaa, ngam ɗemngal maaɗa ngal tabbintinta ɗum. ");
INSERT INTO fuh_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Sey Piyer fuɗɗi hunaade no huniitoo no wi'a : —Mi anndaa gorko oo ! Wakkati mum da, ndontoori joggini. ");
INSERT INTO fuh_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Nden Piyer miccitii ko Iisa wi'unoo ɗum : —Fadde ndontoori jogginde, a wi'an a anndaa kam kile tati. Nden Piyer darii yaasin tinni no wulla no wulla. ");
INSERT INTO fuh_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Illa beete, mawɓe *cakkanooɓe Alla he mawɓe *Yahudankooɓe kawri, kaɓɓi anniya mbara Iisa. ");
INSERT INTO fuh_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ɓe kaɓɓi mo, ɓe njaari, ɓe ngatti nder juuɗe Pilaatus kawjiiɗo leydi Yahudiya. ");
INSERT INTO fuh_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Wakkati Yahuuda jammbiiɗo Iisa oon hi'unoo no Iisa hiitira kiite maayde, o nimsiti. O wartiri tammaaje cardi woronja ɗeen to mawɓe *cakkanooɓe Alla he mawɓe *Yahudankooɓe ɓeen. ");
INSERT INTO fuh_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","O wi'i ɗum'en : —Mi waɗi hakke ngam mi jammbake mo waɗaay gacce fuu faa o waree ! Ɓe njaabii mo, ɓe mbi'i : —Ko hilli min ! Aan ɗum daarata. ");
INSERT INTO fuh_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yahuuda faɗɗi tammaaje ɗeen nder *Juulirde mawne ndeen, dilli, hooƴowi ɓoggol, wari hoore mum. ");
INSERT INTO fuh_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Mawɓe *cakkanooɓe Alla ɓeen kooƴi tammaaje ɗeen, mbi'i : —Dagaaki tammaaje ɗe ngattee nder keesuwal, ngam ɗe njobdi ƴiiƴam. ");
INSERT INTO fuh_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Nden ɓe caawodiri dow majje, ɓe kooƴi ɗe, ɓe coodowi nokkuure gom wi'eteene ngesa mahoowo looɗe. Ɓe ngaɗi nga annyeeje ɓe kanaa *Yahudankooɓe. ");
INSERT INTO fuh_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ngam majjum waɗi faa warde hannden ngesa ngaan no wi'ee « Ngesa Ƴiiƴam ». ");
INSERT INTO fuh_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ɗum humnii haala ka annabi Yeremiya haalunoo mbi'unooka : Ɓe kooƴi tammaaje cardi woronja, ceede ɗe himɓe *Isra'el kiisorii yonki makko, ");
INSERT INTO fuh_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ɓe coodiri ɗe ngesa mahoowo looɗe, hano no Joomiraawo wi'iri kam ɗum nii. ");
INSERT INTO fuh_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Iisa darii yeeso Pilaatus kawjiiɗo leydi Yahudiya oon. Oon ƴami mo, wi'i : —Aan a laamiiɗo *Yahudankooɓe naa ? Iisa jaabii mo, wi'i : —Aan, e hoore maaɗa wi'i ka. ");
INSERT INTO fuh_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Amma wakkati mawɓe *cakkanooɓe Alla he mawɓe *Yahudankooɓe pelannoo mo ndeen, o nootaaki ɓe. ");
INSERT INTO fuh_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Nden Pilaatus wi'i mo kaden : —A nanaay ko woni no wi'ee dow maaɗa ɗum fuu naa ? ");
INSERT INTO fuh_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Iisa nootaaki mo baa. Ɗum haayɗini Pilaatus sanne. ");
INSERT INTO fuh_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","He *Juulɗe dimɗinol Isra'ilankooɓe fuu, Pilaatus kawjiiɗo leydi Yahudiya no woowi yoofande *Yahudankooɓe kasunke gooto mo ɓe ngiɗi yoofee. ");
INSERT INTO fuh_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Nder wakkati mum, no woodunoo kasunke bonɗo gom, bi'eteeɗo Iisa Barabas gaɗɗo innde sanne. ");
INSERT INTO fuh_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Wakkati jama'aare ndeen warunoo sey Pilaatus ƴami ɓe, wi'i : —Moy ngiɗuɗon mi yoofana on : Iisa Barabas, naa Iisa bi'oowo kam no *Almasiihu ? ");
INSERT INTO fuh_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ngam hakiika, Pilaatus no anndi ko haasidaaku waɗi ɓe ngaddi Iisa to mum. ");
INSERT INTO fuh_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Wakkati Pilaatus jooɗinoo nder suudu kiite nduun, jom suudu makko lili he makko, wi'i o sela gorko dartiiɗo oo, ngam hankin koyɗi ɗi o waɗi dow makko ɗiin tampinii mo sanne. ");
INSERT INTO fuh_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Mawɓe *cakkanooɓe Alla he mawɓe *Yahudankooɓe uppi jama'aare ndeen, eela Pilaatus yoofana ɓe Barabas, amma o wara Iisa. ");
INSERT INTO fuh_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pilaatus ƴamtinii ɓe, wi'i : —Moy nder ɗiɗo ɓeen ngiɗuɗon mi yoofana on ? Ɓe njaabii mo, ɓe mbi'i : —Barabas ! ");
INSERT INTO fuh_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilaatus ƴami ɓe, wi'i : —Dey noy ngaɗanmi Iisa bi'eteeɗo *Almasiihu oon ? Ɓe fuu ɓe njaabii mo, ɓe mbi'i : —Tontu mo dow *bardugal ! ");
INSERT INTO fuh_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","O ƴami ɓe, o wi'i : —Dey ɗume o waɗi ko foti nii fuu ? Nden ɓe kuuɓi sanne, ɓe mbi'i : —Tontu mo dow *bardugal ! ");
INSERT INTO fuh_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilaatus hi'i walaa fuu ko kam waawi, omo hula duu murtol ummoo. Sey o hooƴi ndiyam, o looti juuɗe makko yeeso himɓe fuu, o wi'i : —Miin kay, juuɗe am ngalaa hen, nder dufol ƴiiƴam gorko oo. Onon ɗum daarata. ");
INSERT INTO fuh_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Nden ɓe fuu ɓe njaabii, ɓe mbi'i : —Hakke dufol ƴiiƴam makko no dow amin, minen he ɓiɓɓe amin ! ");
INSERT INTO fuh_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Nden, Pilaatus yoofani ɓe Barabas, hokki laawol Iisa ɓoccee, gaɗa mum, o tontowee dow *leggal bardugal. ");
INSERT INTO fuh_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Illa ɗon soogeeji kawjiiɗo leydi Yahudiya ɗiin njaari Iisa nder batamaare ɓaade Pilaatus. Ɓe ngaddi sewre soogeeji gom piilii mo. ");
INSERT INTO fuh_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ɓe ɓorti kolte makko, ɓe ɓornii mo alkubbaare woɗeere. ");
INSERT INTO fuh_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ɓe canyi taarde gi'e, ɓe kippi dow hoore makko, ɓe ngatti loocol nder junngo makko nyaamo. Nden ɓe kofi yeeso makko, iɓe njawoo mo iɓe mbi'a : —Alla sabbinane, laamiiɗo *Yahudankooɓe ! ");
INSERT INTO fuh_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ɓe kaarti dow makko, ɓe kooƴi loocol iɓe piya mo dow hoore. ");
INSERT INTO fuh_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Wakkati ɓe njawinoo mo faa heƴi ɓe, ɓe itti alkubbaare ndeen, ɓe ɓornii mo kolte makko. Ɓe njaari mo yaasin faa ɓe tontowa mo. ");
INSERT INTO fuh_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Wakkati ɓe njahannoo ndeen, sey ɓe potti he gorko gom jeyaaɗo Sirene bi'eteeɗo Simon. Soogeeji ɗiin tilsini mo o wakkoo *leggal bardugal Iisa ngaal. ");
INSERT INTO fuh_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","O wakkii ngal faa ɓe njottii nokkuure gom wi'eteene Golgota. Maana Golgota woni « nokkuure laalagal hoore ». ");
INSERT INTO fuh_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Toon ɓe kokki Iisa cabiijam kawrodiriɗam he safaare haaɗune gom ngam o yara. Wakkati o wooɓunoo ɗam ndeen, o salii yarude ɗam. ");
INSERT INTO fuh_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Wakkati ɓe tontunoo mo ndeen, ɓe piyi caaca ngam senndude kolte makko caka maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Gaɗa mum, ɓe njooɗii, ɓe ndoomi mo. ");
INSERT INTO fuh_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Sabaabu gaɗɗo ɓe tonti mo, winndaa dow alluwal ɓe takki ngal dow timtude hoore makko. Ndaa ko winndaa nii : « Oo woni Iisa, Laamiiɗo *Yahudankooɓe. » ");
INSERT INTO fuh_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","O tontidaama he wuyɓe ɗiɗo gom, oo no nyaamo, ooto duu no nano makko. ");
INSERT INTO fuh_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Yawtooɓe har toon ɓeen no njenna mo, no njinnga ko'e mum'en, ");
INSERT INTO fuh_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","no mbi'a : —Aan Liɓoowel *Juulirde mawne, dey nyiɓitoo nde nder balɗe tati, dannu hoore maa ! Nde nii a *Ɓii-Alla, jippa dow *leggal bardugal ngaal ! ");
INSERT INTO fuh_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Noon duu, mawɓe *cakkanooɓe Alla, jannginooɓe *Tawreeta e mawɓe *Yahudankooɓe tinni no njaltinoo mo hakkune mum'en, no mbi'a : ");
INSERT INTO fuh_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—O dannii woɓɓe, dey o waawaa dannude hoore makko. Oo woni Laamiiɗo *Isra'el naa ? Nde nii o jippake joonin joonin, en ngoonɗinan mo ! ");
INSERT INTO fuh_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","O halfinii hoore makko Alla. Too, joonin nde Alla no hiɗi mo, hisinan mo, ngam nii o wi'i o *Ɓii-Alla. ");
INSERT INTO fuh_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Wuyɓe pasotooɓe tontidaaɓe he makko ɓeen duu, no njennira mo non. ");
INSERT INTO fuh_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Caka nyalooma, nimre huuri leydi ndiin fuu faa ɗum waɗi jamɗe tati. ");
INSERT INTO fuh_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Har yamnde tati juura, Iisa fii wullaanu mawnu, wi'i : Eli, Eli, lema sabaktani ? Kam woni : Yaa Alla am ! Yaa Alla am ! Ɗume waɗi ko mboppuɗaa kam ? ");
INSERT INTO fuh_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Wakkati darinooɓe toon ɓeen nanunoo ɗum, woɓɓe nder maɓɓe mbi'i : —Kettinee, omo nii omo nodda Eliya. ");
INSERT INTO fuh_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Sey gooto nder maɓɓe doggi waddowi tekkere, suuwi nder ndiyam lammuɗam gom, haɓɓi nde he loocol, waddi nde hadde hunnduko Iisa ngam Iisa siiɓoo ɗam. ");
INSERT INTO fuh_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Amma hoddiiɓe ɓeeto mbi'i : —Accu ndaaren tawte Eliya waran danna mo. ");
INSERT INTO fuh_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Iisa fii wullaanu mawnu kaden, sey o foofi foofaango makko sakitiingo. ");
INSERT INTO fuh_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Riido palaaɗo nder *Juulirde mawne oon serki illa dow faa ley, laatii pecce ɗiɗi. Leydi ndiin dimmbii, kaaƴe cerki, ");
INSERT INTO fuh_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","annyeeji udditi. Seniiɓe maaynooɓe heewɓe ummitii, ");
INSERT INTO fuh_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","mburtii nder annyeeje mum'en. Gaɗa ummitaaki Iisa, ɓe naatidi nder *Ursaliima wuro seniingo. Himɓe heewɓe ngi'ii ɓe. ");
INSERT INTO fuh_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Soogeeji doomuɗi Iisa ɗiin he hooreejo majji nani no leydi ndiin dimmbiri, ngi'ii duu ko waɗi fuu, kuli sanne, mbi'i : —Sikka fuu walaa, oo *Ɓii-Alla ! ");
INSERT INTO fuh_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Rewɓe heewɓe tokkunooɓe mo, illa Galili ngam ɓe ngollana mo no ndarii to toowti, no ndaara. ");
INSERT INTO fuh_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Nder maɓɓe no tawa Mariyaama mo Magdaala, Mariyaama inna Yakuuba e Yusufu, he inna ɓiɓɓe Jebede. ");
INSERT INTO fuh_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Futuro, gorko jom njawdi gom jeyaaɗo wuro Arimatiya wari. Omo wi'ee Yusufu. Kanko duu, o aahiijo Iisa. ");
INSERT INTO fuh_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","O yehi to Pilaatus, o ŋaarii mo ɓanndu Iisa. Pilaatus hokki laawol o hokkee ndu. ");
INSERT INTO fuh_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","O hooƴi ɓanndu nduun, o fiili ndu nder kasanke. ");
INSERT INTO fuh_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","O watti ndu nder annyeere heyre nde o seɓanii hoore makko nder tepaare mawne gom. Nden o waɗi kaaƴa mannga gom tallitaa, dammbugal annyeere ndeen uddaa, o dilli. ");
INSERT INTO fuh_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mariyaama mo Magdaala he bi'eteeɗo Mariyaama gom no njooɗii, no kuccitii annyeere ndeen. ");
INSERT INTO fuh_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Jaangoore mum woni *nyalaane fowteteene. Mawɓe *cakkanooɓe Alla he *Fariisa'en kawri to Pilaatus, ");
INSERT INTO fuh_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","mbi'i mo : —Alla sabbinane, min miccitake ko kiiloowo himɓe oon, wakkati wuurunoo wi'iino, ko kam no ummitittoo balɗe tati gaɗa maayde mum. ");
INSERT INTO fuh_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ndenne, ngaɗaa annyeere ndeen ndoomee faa balɗe tati ɗeen njawta, ngam to *aahiiɓe makko ngaru, mbujja ɓanndu makko mbi'a himɓe o ummitake e maayde. Nden kay, hiila cakitittooɗo oon, no ɓuran arandeejo oon bonde. ");
INSERT INTO fuh_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Nden Pilaatus jaabii ɓe, wi'i : —Ndaa soogeeji doomooji ɗiin nii. Njehee, ndoomon annyeere ndeen no mbaawruɗon fuu. ");
INSERT INTO fuh_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ɓe njehi, ɓe ndoomowi annyeere ndeen. Ɓe pii kaatimiije laamiiɗo *Rooma dow mayre, ngam faamee se nde fiirtaama. Ɓe ngatti soogeeji ndaara nde. ");
INSERT INTO fuh_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Alal, gaɗa *nyalaane fowteteene ndeen, illa subaka kecco, Mariyaama mo Magdaala he Mariyaama gom njehi ndaarowi annyeere ndeen. ");
INSERT INTO fuh_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Wakkati mum da, leydi dimmbii sanne. Maleykaajo Joomiraawo gom jippii, talliti kaaƴa ngaan jooɗii dow magga. ");
INSERT INTO fuh_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Omo ƴelkiɗaa hano maƴƴere, kolte makko duu no ndawni tarr hano haabu. ");
INSERT INTO fuh_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Doomooɓe ɓeen kuli sanne faa no ndiwna, ɓe laatii hano maayɓe. ");
INSERT INTO fuh_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Sey maleykaajo oon wi'i rewɓe ɓeen : —To kulee ! Miɗo anndi Iisa tontanooɗo oon tefoton. ");
INSERT INTO fuh_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Amma o walaa ɗo, o ummitake hano no o wi'irnoo ɗum nii. Ngaree, ndaaree nokkuure to o fukkinaa nii. ");
INSERT INTO fuh_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Dey njaawɗee, njehee, kumpitowoɗon *aahiiɓe makko mbi'on o ummitake. Wooɗi, joonin o artan on Galili, toon ngi'oyton mo. Ɗum njoginoomi faa mi haalana on. ");
INSERT INTO fuh_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Rewɓe ɗiɗo ɓeen ummii, ndilli to annyeere ndeen. Kulal manngal he welwelo manngo heewi ɓe. Ɓe ndoggi, ɓe kaalanowi *aahiiɓe Iisa ɓeeto habaru oon. ");
INSERT INTO fuh_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Wakkati mum da, Iisa fotti he maɓɓe, wi'i ɓe : —Foofo mooɗon ! Ɓe ɓadii mo, ɓe nanngi koyɗe makko, ɓe cujidani mo. ");
INSERT INTO fuh_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Nden o wi'i ɓe : —To kulee ! Njehee mbi'owee giɗaaɓe am, ɓe njaha Galili. Toon ɓe ngi'oyta kam. ");
INSERT INTO fuh_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Wakkati rewɓe ɓeen ndillannoo ndeen, soogeeji doomuɗi annyeere Iisa ndeen kooti, kaalanowi mawɓe *cakkanooɓe Alla ɓeen huune fuu ko waɗi. ");
INSERT INTO fuh_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Mawɓe *cakkanooɓe Alla he mawɓe *Yahudankooɓe caawodiri, kokki soogeeji ɗiin ceede ɗuɗɗe, ");
INSERT INTO fuh_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","mbi'i : —Mbi'on *aahiiɓe makko ngari nder jemma tawi oɗon ɗaanii. Ɓe mbujji ɓanndu makko. ");
INSERT INTO fuh_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Nde nii haala kaan yehi to kawjiiɗo leydi oon, min keɓan ko min mbi'i ngam suddude on. Min keedana on he torra fuu. ");
INSERT INTO fuh_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Soogeeji ɗiin njaɓi ceede ɗeen, ngaɗi ko mbi'aa. Nii haala kaa fillortee hakkune *Yahudankooɓe faa warde hannden. ");
INSERT INTO fuh_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","*Aahiiɓe sappo he go'o ɓeen njehi Galili, dow waamnde nde Iisa tinndinnoo ɓe ndeen. ");
INSERT INTO fuh_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Wakkati ɓe ngi'unoo mo, ɓe cujidani mo, amma nder maɓɓe woɓɓe duu no cikka. ");
INSERT INTO fuh_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","O ɓadii, o wi'i ɓe : —Mi hokkaama baawɗe fuu tawaaɗe dow e ley. ");
INSERT INTO fuh_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ndenne, njehee nder kappa kuula duuniyaaru fuu, ngaɗee lenyi fuu *aahiiɓe am, ngaɗanon ɓe *batisma dow innde *Baabiraawo, Ɓiɗɗo he *Ruuhu Ceniiɗo. ");
INSERT INTO fuh_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Njannginon ɓe, ɓe tokka ko mbi'umi on ɗum fuu. Paamee ko miɗo wondi he mooɗon wakkati fuu sey nyannde duuniyaaru timmi.");
INSERT INTO fuh_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Filla *Habaru lobbo, habaru dow Iisa *Almasiihu *Ɓii-Alla, filla oo ");
INSERT INTO fuh_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","fuɗɗirii haala Alla tawaaka nder dewtere annabi *Esaaya, mbi'uka : Ndaa, mi ardinan lilaaɗo am moƴƴinane laawol maaɗa. ");
INSERT INTO fuh_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Daane no huuɓa nder ladde yeeruure no wi'a : Ciryanee Joomiraawo laabi ɗi o tokkata, moƴƴinee laabi makko. ");
INSERT INTO fuh_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","6","Yahaaya gaɗoowo *batisma wanngi nder ladde yeeruure. Omo ɓornii koltal canyiraangal leeɓi ngolooba. Omo tunndi tunndorgol nguru. Ɓaɓɓatti he njuumri o wuurdi. Omo nodda himɓe tuuba ngam hakkeeji maɓɓe njaafee, ɓe ngaɗanee *batisma. Himɓe leydi Yahudiya he himɓe huɓeere *Ursaliima no ngara to makko. Iɓe njardoo yeeso Alla e yeeso himɓe fuu dow hakkeeji maɓɓe. Omo waɗana ɓe *batisma nder maayo Urdun. ");
INSERT INTO fuh_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Omo waajoo nder daane toowne, omo wi'a himɓe : —Ɓurɗo kam baawɗe no wara gaɗa am. Miin, mi fotaay baa to turotoomi ngam fiirtude ɓoggi paɗe makko. ");
INSERT INTO fuh_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Miin, ndiyam ngaɗirananmi on *batisma, amma kanko kay, *Ruuhu Ceniiɗo o waɗiranta on *batisma. ");
INSERT INTO fuh_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Nder balɗe Yahaaya waɗanannoo himɓe *batisma, Iisa wari, ƴuwi Nasaratu nder leydi Galili. Yahaaya waɗani mo *batisma nder maayo Urdun. ");
INSERT INTO fuh_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Wakkati o umminoo o darii nder ndiyam ɗam, sey o hi'i kammu omtii, *Ruuhu Alla wari nder nanndi wuugaanu, jippii dow makko. ");
INSERT INTO fuh_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Daane gom ƴuwi dow wi'i : « Aan woni Ɓiyam korsuɗo, aan naniranmi belɗum. » ");
INSERT INTO fuh_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Wakkati mum da, *Ruuhu jippiiɗo dow makko oon, soggi mo yaari nder ladde yeeruure. ");
INSERT INTO fuh_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Balɗe makko lasooji ɗiɗi toon, Ibiliisa no sii'oo mo, omo hakkune dabbaaji ladde, maleykaaɓe no ngollana mo. ");
INSERT INTO fuh_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Balɗe seɗɗa gaɗa uddol Yahaaya, Iisa ummii, yehi Galili. Omo waajoo *Habaru lobbo ƴuwɗo to Alla. ");
INSERT INTO fuh_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Omo wi'a himɓe : —Wakkati doomaaɗo oon yottake, Laamu Alla ɓadake. Tuubee, ngoonɗinee *Habaru lobbo. ");
INSERT INTO fuh_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Nyannde gom, Iisa no fiiloo takkol peta Galili. Sey o hi'i nanngooɓe liƴƴi ɗiɗo gom : Simon inndirteeɗo Piyer he minyum Andiire, no paɗɗa taaruuji mum'en. ");
INSERT INTO fuh_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Sey Iisa wari to maɓɓe wi'i ɓe : —Ngaree, tokkee kam, mi waɗan on nanngooɓe himɓe. ");
INSERT INTO fuh_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Wakkati mum da ɓe mboppi taaruuji maɓɓe, ɓe tokki mo. ");
INSERT INTO fuh_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","O yehi yeeso seɗɗa, sey o hi'i Yakuuba ɓii-Jebede he minyum Yahaaya no nder laana ndiyam mum'en, iɓe moƴƴina taaruuji maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Kamɓe duu no Iisa noddirnoo ɓe, sey ɓe acci baabiiɓe Jebede he gollooɓe mum, ɓe tokki mo ɓe ndilli. ");
INSERT INTO fuh_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Iisa e jaɓuɓe tokkude ɗum njehi Kafarnahum. *Nyalaane fowteteene gom Iisa naati nder *waajordu Kafarnahum, fuɗɗi waajaade. ");
INSERT INTO fuh_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Waaju makko haayɗini hettinaniiɓe mo. Ngam o waajoraaki ɓe hano no jannginooɓe *Tawreeta mbaajorto, amma he baawɗe o waajorii ɓe. ");
INSERT INTO fuh_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Nder *waajordu nduun no tawa gorko gom, mo ginnaaru woni dow mum no tampina. Sey ginnaaru nduun huuɓi, ");
INSERT INTO fuh_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","wi'i : —Iisa mo Nasaratu, ɗume ngiɗaa waɗude min ? A warii faa mbaraa min naa ? Miɗo anndi moy woni ma, a Ceniiɗo ƴuwɗo to Alla ! ");
INSERT INTO fuh_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Sey Iisa laayani ginnaaru nduun, sajiti he mayru wi'i ndu : —Maɓɓu hunnduko maa, takkita mo ! ");
INSERT INTO fuh_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Wakkati mum da ginnaaru nduun dimmbiri gorko oon he semmbe, ndu huuɓi sanne, ndu takkitii mo. ");
INSERT INTO fuh_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ɗum haayɗini jama'aare ndeen fuu. Himɓe tokki, no ƴamodira, no mbi'a : —Ɗume woni ɗum nee kaden ? Ɗume woni anndal kesal jannginiraangal he baawɗe ngaal nee ? Omo dawrana baa ginnaaji, iɗi ɗowtanoo mo duu. ");
INSERT INTO fuh_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Wakkati gooto habaru Iisa sankitii nder leydi Galili fuu. ");
INSERT INTO fuh_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Wakkati Iisa wurtinoo *waajordu Kafarnahum, Yakuuba e Yahaaya tokki mo ɓe njaadi wuro Simon Piyer he Andiire'en. ");
INSERT INTO fuh_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Eso Simon Piyer debbo no fukkii, no wondi wulowulo. No Iisa yottii naatiri ɓaade Simon Piyer, o waɗana filla rafi cellal debbo oon. ");
INSERT INTO fuh_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Iisa yehi to debbo oon, nanngi junngo makko, ummini mo. Wakkati mum da wulowulo ngoon heli, o yamɗiti. O ummii, o jaɓɓii ɓe. ");
INSERT INTO fuh_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Futuro nyannde mum, gaɗa janki naange, himɓe tinni no ngadda nyawɓe mum'en he wonduɓe he ginnaaji to Iisa. ");
INSERT INTO fuh_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Wuro ngoon fuu hawri dammbugal ɓaade Simon'en. ");
INSERT INTO fuh_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Iisa nyawti himɓe heewɓe, nyawɓe nyawuuji feere-fereeji. O riiwi ginnaaji keewɗi. Iɗi anndi mo amma o haɗi ɗi haalude. ");
INSERT INTO fuh_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Iisa ummii illa subaka kecco, wurtii wuro Simon Piyer'en. O yehi nder nokkuure yeewne gom to neɗɗo fuu walaa, o waɗi ko du'aade. ");
INSERT INTO fuh_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simon Piyer he wondunooɓe he mum gom ummii, tinni no tefa mo. ");
INSERT INTO fuh_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Wakkati ɓe ngiitowi to o woni, ɓe ngari ɓe mbi'i mo : —Toy ngonnoɗaa ko himɓe fuu no tefe ? ");
INSERT INTO fuh_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Sey Iisa wi'i ɓe : —En njah nder gure ɓadiiɗe gom, mi waajoo toon duu, ngam majjum waɗi ngarmi. ");
INSERT INTO fuh_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Iisa fiilii leydi Galili fuu. O riiwi ginnaaji dow himɓe. O waajii nder *baajorɗi leydi Galili fuu. ");
INSERT INTO fuh_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Nyannde gom gorko ceppinɗo gom wari, hofi yeeso Iisa, wi'i mo : —Nde nii a jaɓi, aɗa waawi yamɗintinde kam ! ");
INSERT INTO fuh_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yurmeene ceppinɗo oon nanngi Iisa, nden Iisa foorti junngo mum, meemi mo, wi'i : —Mi jaɓi, yamɗitin ! ");
INSERT INTO fuh_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Wakkati mum da, ceppam ɗaam ƴuwi he gorko oon, o nyawti. ");
INSERT INTO fuh_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Iisa sallimii mo, amma fooɗi nowru makko, ");
INSERT INTO fuh_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","wi'i mo : —Hakkila, to haalan ɗum neɗɗo fuu. Umma, yah holloy hoore maa *cakkanoowo Alla mooɗon, ngaɗaa cakkol ngol *Muusa tilsini waɗee, ngam hollude himɓe ko sikka fuu walaa a yamɗiti. ");
INSERT INTO fuh_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Amma no o dilliri to Iisa, o fuɗɗi sankitidde habaru oon. Iisa waɗi wakkati, wurtataako naata huɓeere gom. Himɓe fuu no kollira mo, ngam filla nyawtol ceppinɗo oo sankitake nokku fuu. Nder nokkuuje jeewɗe tan o woni omo jooɗo. Amma ɗum fuu haɗaay jama'aare he jama'aare no ƴuwa nokku fuu no wara to makko. ");
INSERT INTO fuh_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Balɗe seɗɗa gaɗa jonnde Iisa nder nokkuuje jeewɗe, o warti Kafarnahum. Himɓe nani ko o warti, omo nder suudu makko. ");
INSERT INTO fuh_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Jama'aare ɗuunde wari hawri dammbugal makko, faa walaa to neɗɗo tuttata joode baa seɗɗa. Iisa tinni no waajoo ɓe dow haala Alla. ");
INSERT INTO fuh_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Himɓe gom ngari to makko, ɓe ngardi he bonnguujo gom. Worɓe nayo ndoondii mo dow kooƴirngal maayɓe. ");
INSERT INTO fuh_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Jama'aare heewi nokkuure ndeen faa walaa to ɓe tokkira, ɓe njottina bonnguujo oon to Iisa. Sey ɓe ƴeenyi suudu nduun, ɓe kunci ndu dey-dey to fotata he to Iisa darii, ɓe njuri bonnguujo oon, omo foorti dow kooƴirngal maayɓe. ");
INSERT INTO fuh_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Wakkati Iisa hi'unoo no goonɗinol maɓɓe foti, o wi'i bonnguujo oon : —Higo, hakkeeji maa njaafaama. ");
INSERT INTO fuh_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Sey jannginooɓe *Tawreeta jooɗinooɓe ɗon tinni no miiloo nder ɓerɗe mum'en no mbi'a : ");
INSERT INTO fuh_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","—Ɗume waɗi gorko oo no haalira nii ? O bonni innde Alla ! Moy waawi yaafaade hakke se hanaa Alla ? ");
INSERT INTO fuh_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Wakkati mum da Iisa faami miilooji maɓɓe, wi'i ɓe : —Ɗume waɗi ko oɗon miiloo ir miilooji ɗii nder ɓerɗe mooɗon ? ");
INSERT INTO fuh_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ɗume ɓuri hoyde hakkune wi'ude bonnguujo oo : « Hakkeeji mum njaafaama » naa o ummoo, o hooƴa kooƴirngal ngaal, o dilla ? ");
INSERT INTO fuh_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Amma, miɗo hiɗi paamon ko *Ɓii-Neɗɗo no jogii baawɗe yaafaade hakkeeji himɓe nder duuniyaaru nduu. Nden, o wi'i bonnguujo oon : ");
INSERT INTO fuh_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Aan, umma, hooƴu kooƴirngal maayɓe ngal ngaddiraɗaa, kootaa. ");
INSERT INTO fuh_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Wakkati mum da gorko oon ummii yeeso himɓe fuu, hooƴi ngal, dilli. Ɗum haayɗini ɓe, ɓe fuu, ɓe tinni iɓe njetta Alla, iɓe mbi'a : —Abada min ngi'aay ir ɗum ! ");
INSERT INTO fuh_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Iisa ummii wuro, soƴƴii dow peta Galili. Jama'aare no wara to makko, omo waajoo ɓe. ");
INSERT INTO fuh_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Nyannde gom jaɓoowo janngal gom bi'eteeɗo *Lewi ɓii-Alfee no jooɗii nder suudu janngal. Wakkati Iisa yawtannoo, sey hi'i mo, wi'i mo : —Tokkam ! Lewi ummii, tokki mo. ");
INSERT INTO fuh_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Nyannde gom Iisa he *aahiiɓe mum no nyaama nder suudu Lewi. *Jaɓooɓe janngal gom, he ɓooyɓe nder gaɗol hakke, heewɓe no njooɗodii Iisa he *aahiiɓe mum, iɓe nyaamda. Iri maɓɓe heewɓe tokki Iisa. ");
INSERT INTO fuh_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Wakkati jannginooɓe *Tawreeta gom, jeyaaɓe nder hawriine *Fariisa'en, ngi'unoo ɗum, ɓe mbi'i *aahiiɓe Iisa : —Ɗume waɗi omo nyaamda he *jaɓooɓe janngal, he waɗooɓe hakke ɓee ? ");
INSERT INTO fuh_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Wakkati Iisa nanunoo haalaaji maɓɓe, o wi'i ɓe : —Nyawɗo haajaa cawroowo hanaa jamɗuɗo. Mi waraay noddude miilooɓe kam'en no dartiiɓe, amma mi waraana ngam annduɓe kam'en no waɗooɓe hakke. ");
INSERT INTO fuh_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Nyannde gom aahiiɓe Yahaaya gaɗoowo *batisma he *Fariisa'en no cuumii, sey himɓe gom ngari to Iisa, ƴami mo, mbi'i : —Ko waɗi aahiiɓe Yahaaya gaɗoowo *batisma he *aahiiɓe *Fariisa'en no cuumoo, amma *aahiiɓe maaɗa kay cuumataako ? ");
INSERT INTO fuh_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Iisa jaabii ɓe, wi'i : —Warɓe ɓanngal no mbaawi suumaade wakkati ɓaŋuɗo oon wondi he maɓɓe naa ? Nde nii ɓaŋuɗo oon no wondi he maɓɓe, ɓe cuumataako. ");
INSERT INTO fuh_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Amma nyalaaɗe ngaran ɗe ɓaŋuɗo oon suutetee hakkune maɓɓe. Nder balɗe ɗeen ɓe cuumoto. ");
INSERT INTO fuh_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Baa gooto nyootataa lefol kesol he koltal kinngal. Nde joomum waɗi ɗum, lefol kesol ngool serkata koltal kinngal ngaal, cerkol ngool ɓeydoo. ");
INSERT INTO fuh_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Kaden duu, walaa loowoowo cabiijam kesam nder sumalleeji kiɗɗi. Nde joomum waɗii ɗum, cabiijam ɗaam no fusan ɗi, joomum mursa ɗam, kanƴam he sumalleeji ɗiin fuu. Cabiijam kesam nder sumalleeji kesi loowetee ! ");
INSERT INTO fuh_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","*Nyalaane fowteteene gom, Iisa he *aahiiɓe mum ummii, no peddita gese alkamaaje. Iɓe caka yaadu sey *aahiiɓe ɓeen puɗɗi no mborsoo camme ɗeen. ");
INSERT INTO fuh_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Nden *Fariisa'en mbi'i mo : —Ndaa, ko waɗi *aahiiɓe maaɗa no ngaɗa ko haɗaa nder *nyalaane fowteteene ? ");
INSERT INTO fuh_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Iisa jaabii ɓe, wi'i : —Ndenne on njanngaay ko Daawda waɗunoo, wakkati kanko he yaadiraaɓe makko ndafanoo ? ");
INSERT INTO fuh_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Nder jamaanu *cakkanoowo Alla mawɗo gom bi'eteeɗo Abiyatar, Daawda naati nder suudu Alla, o adi buuru ittanaaɗo Alla oon, o nyaami, o hokki mo yaadiraaɓe makko. Tawi duu nder *Tawreeta wi'aama ko *cakkanooɓe Alla tan kaani nyaamude mo. ");
INSERT INTO fuh_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Kaden duu, *nyalaane fowteteene himɓe waɗanaa, amma hanaa himɓe ngaɗaa ngam mayre. ");
INSERT INTO fuh_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ndenne, *Ɓii-Neɗɗo woni jom *nyalaane fowteteene ndeen, kayre he hoore mayre. ");
INSERT INTO fuh_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Nyannde gom Iisa naati *waajordu. Gorko gom mo junngo mum waati no tawa nder mayru. ");
INSERT INTO fuh_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","*Fariisa'en wonɓe nder mayru fuu no kora Iisa, ngi'a nde o nyawtan gorko oon nder *nyalaane fowteteene ndee, nden ɓe keɓa ko ɓe pelirta mo. ");
INSERT INTO fuh_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Iisa wi'i jom junngo waanngo oon ummoo, daroo yeeso himɓe fuu. ");
INSERT INTO fuh_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Sey o ƴami ɓe, o wi'i : —Nder *nyalaane fowteteene ɗume haani waɗeede ? Ko wooɗi naa ko boni ? Dannude neɗɗo naa accude mo o maaya ? Ɓe calii jaabaade mo. ");
INSERT INTO fuh_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Iisa daari ɓe, ɓe fuu, ɓerne makko metti. O wanni ngam tiiɗal nyiraaku maɓɓe. Nden o wi'i gorko oon : —Foortu junngo maa ! Gorko oon foorti junngo mum, ngo yamɗiti. ");
INSERT INTO fuh_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Wakkati *Fariisa'en wonɓe nder *waajordu nduun mburtii, ɓe njehi law law, ɓe caawodirowi he Hirudus'en dow no ɓe mbardata Iisa. ");
INSERT INTO fuh_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Iisa ummii, he *aahiiɓe mum, ɓe ponndi peta Galili. Jama'aare mawne no tokki mo. ");
INSERT INTO fuh_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Nder maɓɓe no tawa ƴuwɓe Galili, *Ursaliima, Yahudiya, Idumiya, lettugal maayo Urdun, he seraaji Tirus he Sidon. Jama'aaje ɗee fuu nani ko o waɗannoo, ɓe ndillowi ɓe ngari to makko. ");
INSERT INTO fuh_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ngam doggude himɓe njaaɓa mo, Iisa waɗi *aahiiɓe mum ngaddana ɗum laanel ndiyam gom. ");
INSERT INTO fuh_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Nyawɓe heewɓe no tefa yottaade mo, meema mo ngam o nyawtiino himɓe ɗuɓɓe. ");
INSERT INTO fuh_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Wakkati fuu mo ɓe ginnaaji bonɗi ngoni dow mum'en, ngi'ii mo, no kofo yeeso makko, no kuuɓa, no mbi'a : —Aan, a *Ɓii-Alla ! ");
INSERT INTO fuh_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Amma omo hajoo ɓe ngam to ɓe mbanngin moy o woni. ");
INSERT INTO fuh_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Nyannde gom Iisa ƴeenyi waamnde, o noddi ɓe o haajaa nder tokkuɓe mo ɓeen, ngara to makko. ");
INSERT INTO fuh_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ɓe ngari to makko, o suɓii sappo e ɗiɗo nder maɓɓe. O waɗi ɓe *lilaaɓe makko, laatiiɓe wakkati fuu no hadde makko. O suɓake ɓe duu ngam omo hiɗi, o lila ɓe, ɓe mbaajowoo himɓe. ");
INSERT INTO fuh_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","O hokki ɓe baawɗe riiwude ginnaaji duu. ");
INSERT INTO fuh_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","*Lilaaɓe makko sappo e ɗiɗo, ɓe o suɓi ɓeen nii : Simon mo o inndiri Piyer, ");
INSERT INTO fuh_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yakuuba ɓii-Jebede he minyum Yahaaya sowirteeɓe Bowanerges kam woni nannduɓe he riggaaŋo, ");
INSERT INTO fuh_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andiire, Filipa, Bartolome, Matta, Tomas, Yakuuba ɓii-Alfee, Tadde, Simon kiranoowo suudu baaba e ");
INSERT INTO fuh_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Yahuuda Iskariyot mo yahde yeeso jammboytoo Iisa. ");
INSERT INTO fuh_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Iisa hooti wuro, jama'aare wari, hawriti dow makko kaden faa kanko he *aahiiɓe makko fuu anndaa no ngatta ko nyaama. ");
INSERT INTO fuh_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Wakkati jeydaaɓe Iisa nanunoo himɓe no mbi'a : « Hoore Iisa sottake », ɓe ngarani mo. ");
INSERT INTO fuh_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Jannginooɓe *Tawreeta ƴuwɓe *Ursaliima gom ngari, no mbi'a Be'eljebul, hooreejo ginnaaji, woni dow makko. Kanko hokki mo baawɗe riiwude ginnaaji ɗiin. ");
INSERT INTO fuh_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Dow haalaaji ɗii, Iisa nootii ɓe, wi'i : —Ibiliisa no waawi riiwude Ibiliisa naa ? ");
INSERT INTO fuh_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Nde nii laamu leydi he hoore mum feccake, feccere worre no habda he ndeeto, leydi ndiin no daroo naa ? ");
INSERT INTO fuh_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Nde wuro senndake, ingo laatoo naa ? ");
INSERT INTO fuh_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Nde nii Ibiliisa no habda he hoore mum, laamu mum feccake, hanti he maggu. ");
INSERT INTO fuh_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Kaden neɗɗo fuu waawaa naati wuro jom semmbe, teeta njawdi makko, nde nii hanaa no artu haɓɓi mo non ginan, nden hooƴa njawdi ndiin fuu. ");
INSERT INTO fuh_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Goonga kaalananmi on hakke he haala yawaare ko waɗanaa Alla fuu no mbaawi yaafeede. ");
INSERT INTO fuh_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Amma neɗɗo fuu bonnuɗo innde *Ruuhu Ceniiɗo, yaafataake abada, ngam hakke duumotooɗo joomum waɗi. ");
INSERT INTO fuh_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Iisa wi'i kujje ɗee fuu ngam himɓe mbi'ii o walanaa hoore makko, ginnaaru o wondi. ");
INSERT INTO fuh_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","32","Jama'aare no jooɗii no fiilii Iisa. Inna Iisa he minyiraaɓe Iisa worɓe ngari, ndarii yaasin. Ɓe ngaɗi lilaaɗo nodda Iisa. Sey himɓe mbi'i Iisa : —Inna maa he rimdaaɓe maa no yaasin, iɓe nodde. ");
INSERT INTO fuh_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Nden Iisa ƴami ɓe, wi'i : —Moy'en ngoni inna am he rimdaaɓe am ? ");
INSERT INTO fuh_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","O daari jooɗiiɓe no piilii mo ɓeen, o wi'i : —Ndaaree inna am e rimdaaɓe am nii. ");
INSERT INTO fuh_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Gaɗoowo muuyɗe Alla, kam woni dimdaaɗo am, kam woni inna am. ");
INSERT INTO fuh_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Iisa soƴƴii nyannde gom dow peta Galili no waajoo. Jama'aare mawne gom wari, fiilii mo. Ɗuuɗol himɓe ngool waɗi o naati laana ndiyam, o jooɗii. Jama'aare ndeen duu no darii hunnduko peta ngaan. ");
INSERT INTO fuh_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Omo waajoroo ɓe kippi haalaaji keewɗi, omo wi'a ɓe : ");
INSERT INTO fuh_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Kettinee ! Aawoowo gom dilli nyannde gom faa aawowa aawdiiri mum. ");
INSERT INTO fuh_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Nder aawre ndeen, gabbe gom caami sera laawol. Nden pooli ngari coppi ɗe. ");
INSERT INTO fuh_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Gere majje caami nder korkaaƴe to leydi ɗuuɗaa. Ɗe puɗilawi ngam luggiɗaa sanne. ");
INSERT INTO fuh_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Amma wakkati naange wulnoo ndeen, ɗe ɗayli, ɗe njoori ngam ɗe ngaɗaay ɗaɗi. ");
INSERT INTO fuh_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Gere majje caami to kebbe puɗata. Kebbe ɗeen mawni, ɓillii ɗe, ɗe ndimaay. ");
INSERT INTO fuh_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Gere majje duu caami nder leydi lobbiri, puɗi, mawni, ndimi. Wassaaŋo gom rimi camme woronja, wonngo lasooji tati, wonngo duu hemre. ");
INSERT INTO fuh_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Jom nowru nanooru fuu, nana ! ");
INSERT INTO fuh_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Wakkati Iisa wonnoo feere mum, *aahiiɓe makko sappo e ɗiɗo ɓeen he woɓɓe nder piiliiɓe mo ƴami mo maana kippol haala ngool. ");
INSERT INTO fuh_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","O jaabii ɓe o wi'i : —Onon, Alla hokkii on baawɗe anndude ko suuɗi dow habaru Laamu mum. Amma ɓe tawaaka hakkune mooɗon kippi haala kaalantee huune fuu. ");
INSERT INTO fuh_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ngam majjum waɗi : Baa nde ɓe ndaari, ɓe ngi'ataa, baa nde ɓe nani, ɓe paamataa, ngam nde nii ɓe paamii, ɓe tuuban, ɓe njaafee. ");
INSERT INTO fuh_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ndenne, nde nii on paamaay kippol haala ngool, noy paamirton ɗiito ? ");
INSERT INTO fuh_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Aawoowo oon, haala Alla aawata. ");
INSERT INTO fuh_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Sera laawol to aawdiiri ndiin saami woni nanuɓe haala Alla, amma wakkati mum da Ibiliisa wari, itti ka nder ɓerɗe maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Korkaaƴe to aawdiiri ndiin saami woni nanuɓe haala Alla, njaɓɓorii ka welwelo wakkati mum da. ");
INSERT INTO fuh_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Amma ngam ka waɗaay ɗaɗi nder maɓɓe, ɓe nanngan ka wakkati seɗɗa tan. Nde nii ɓe ɓillake naa nde ɓe torraama ngam makka, ɓe mboppan ka wakkati mum da. ");
INSERT INTO fuh_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","To kebbe puɗidi aawdiiri ndiin woni nanuɓe haala Alla, ");
INSERT INTO fuh_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","amma sakkulla duuniyaaru, suuno njawdi, he muuyɗe ɓerne naatanta ɓe, kuma haala Alla, ka laatoo ndimara. ");
INSERT INTO fuh_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Leydi lobbiri to aawdiiri ndiin saami woni nanuɓe haala Alla dey njaɓi ka, naforii ka faa ɓe ngaɗi barke : Woɓɓe kile woronja, woɓɓe kile lasooji tati, woɓɓe duu kile hemre. ");
INSERT INTO fuh_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Iisa ɓeydi wi'ude ɓe kaden : —No woodi kuɓɓoowo fitilla dey hippa tummbude dow makka naa sorna ka ley leeso ? Hanaa on ɓilan ka naa ? ");
INSERT INTO fuh_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Huune fuu ko suuɗi no wanngowan nyannde gom. Ko soomaa fuu duu no somtetee. ");
INSERT INTO fuh_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Jom nowru nanooru fuu, nana ! ");
INSERT INTO fuh_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Korkitee noppi mooɗon faa wooɗa ! Etirgal ngal etirton, kanngal etiranteɗon faa duu ɓeydaneɗon. ");
INSERT INTO fuh_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Jogiiɗo fuu no ɓeydantee. Amma mo walaa oon, baa seɗɗa mo jogii oon, no teetetee. ");
INSERT INTO fuh_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","—No Laamu Alla tinndinirtee nii : Ngu nanndaana he neɗɗo biccuɗo aawdiiri mum nder ngesa. ");
INSERT INTO fuh_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Balɗe no njaha, balɗe no ngarta aawdiiri ndiin fuɗi, mawni. Amma neɗɗo oo anndaa baa seɗɗa no waɗi ko ndi mawni. ");
INSERT INTO fuh_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Leydi ndiin funni aawdiiri ndiin, ndi fiyi ƴommbe, wutaanu tokki, gaɗa mum, gabbe tokki. ");
INSERT INTO fuh_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Wakkati ngesa ngaan ɓenndowi, sey neɗɗo oo adi kettirngal mum, hetti nga, ngam nga foti hetteede. ");
INSERT INTO fuh_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","He ɗume mbaawten nanndinde Laamu Alla kaden ? Tinndinoore ndeye tinnidirten ngu ? ");
INSERT INTO fuh_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Laamu Alla no nanndi he wabbere mutaari, ɓurde gabbe fuu famɗude. ");
INSERT INTO fuh_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Amma nde nii nde aawaama, nde fuɗan, nde mawna faa nde laatoo lekki mawki. Lekki kiin waɗa licce mawɗe, ɗe cukka faa pooli no mbaawi nyiɓi cuuɗi mum'en ley majje. ");
INSERT INTO fuh_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Iisa naforake iri kippi haala keewɗi, omo gollira ɗi, dey-dey no jama'aare ndeen waawirta faamude. ");
INSERT INTO fuh_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Walaa fuu ko o haalani ɓe ko hanaa nder kippol haala o haalii ɗum, amma wakkati o tawa kanko tan sey *aahiiɓe ɓeen, omo fiirtana ɓe maana majji. ");
INSERT INTO fuh_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Laasara, Iisa wi'i *aahiiɓe mum : —En pedditin peta ngaa, koɗowen fonngo gooto. ");
INSERT INTO fuh_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ɓe ummii ɓe acci jama'aare ndeen, ɓe naati nder laana ka Iisa wonnoo nder mum kaan, iɓe peddita, laanaaji gom no tokki ɓe. ");
INSERT INTO fuh_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Henndu sattunu gom ummini benkeƴƴe no piya laana kaan faa ka hosi rufude. ");
INSERT INTO fuh_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Iisa no gaɗa, no wahii wawlaare, no ɗaanii. Sey *aahiiɓe ɓeen pindini mo, mbi'i mo : —Moodibbo, a faalaaka maayen naa ? ");
INSERT INTO fuh_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Nden Iisa ummii, sappii henndu nduun, wi'i benkeƴƴe ɗeen : —Fatti ! Ndaree ! Henndu nduun darii, joonkay ɗum waɗi siw nokku fuu. ");
INSERT INTO fuh_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Iisa wi'i *aahiiɓe ɓeen : —Ko waɗi kulirɗon nii ? Noy waɗi on ngoonɗinaay naa ? ");
INSERT INTO fuh_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Kulkulal manngal nanngi ɓe, ɓe tokki iɓe mbi'odira : —Moy woni neɗɗo oo, mo baa henndu e ndiyam no ɗowtanoo ɗum ? ");
INSERT INTO fuh_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Iisa he *aahiiɓe mum ummii, pedditi peta Galili, panndowi dow fonngo leydi Gerasa. ");
INSERT INTO fuh_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Wakkati Iisa jippinoo laana kaan, sey gorko gom mo ginnaaru bondu woni dow mum wurtowi nder annyeeje, no wara har makko. ");
INSERT INTO fuh_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Gorko oo nder annyeeje ɗeen jooɗii. Neɗɗo fuu waawaa haɓɓi mo, ngam baa o haɓɓiraama callali, ɗi nanngataa mo. ");
INSERT INTO fuh_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Himɓe no mbownoo haɓɓirde koyɗe he juuɗe makko callali, o taƴa ɗi, o hela jamɗe ɗeen. Ndenne, neɗɗo fuu waawaa faddii mo. ");
INSERT INTO fuh_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Jemma he nyalooma nder annyeeje naa ley baamle ɗeen o woni, omo huuɓa, omo nawna hoore makko he kaaƴe. ");
INSERT INTO fuh_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Illa to o hollirnoo Iisa, o doggi, o wari, o hofi yeeso Iisa. ");
INSERT INTO fuh_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Nden Iisa wi'i : —Ginnaaru bondu, takkita gorko oo. Sey ginnaaru bondu wonndu dow gorko oon huuɓi daane toowne wi'i Iisa : —Iisa *Ɓii-Alla Toowɗo, ɗume ngiɗaa waɗude kam ? Mi eeli ma ngam sabbu Alla, to torram ! ");
INSERT INTO fuh_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Iisa ƴami ndu, wi'i : —Noy mbi'eteɗaa ? Ndu jaabii mo, ndu wi'i : —Ujunaaji ngam miɗen ɗuuɗi. ");
INSERT INTO fuh_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Nden ɗi ŋaarii Iisa faa noy walaa, to wurtin ɗi nder leydi Gerasa. ");
INSERT INTO fuh_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Nyannde mum ɗum fotodiri, hadde maɓɓe ɗon da, sewre girooji mawne gom no durannoo hoore waamnde. ");
INSERT INTO fuh_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Sey ginnaaji ɗiin ŋaarii mo, o acca ɗum'en naata nder girooji ɗiin. ");
INSERT INTO fuh_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Iisa jaɓi, acci ɗi. Ginnaaji ɗiin takkiti gorko oon, naatowi nder girooji ɗiin. Sewre ndeen fuu doggi, saamowi nder peta Galili ngaan, njoolii. Sewre girooji ndeen no waɗa hano girooji ujunaaji ɗiɗi. ");
INSERT INTO fuh_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Durooɓe majji ndoggi, kaalanowi himɓe wuro ngoon he himɓe seraaji maggo ko hewtii ɗum'en. Himɓe njehi ƴeewowi ko waɗi. ");
INSERT INTO fuh_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ɓe ngari to Iisa, ɓe ngi'i gorko mo ginnaaji ngonnoo dow mum oon no jooɗii hadde Iisa. Omo holti, hakkillo makko duu no huuɓi. Kulal nanngi ɓe. ");
INSERT INTO fuh_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Himɓe ɓe ɗum waɗunoo yeeso mum'en pillanii warɓe ndarii ɓeen huune fuu ko waɗi. ");
INSERT INTO fuh_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Warɓe ɓeen ŋaarii Iisa dilla nder leydi mum'en. ");
INSERT INTO fuh_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Wakkati Iisa naatannoo laana kaan, gorko nyawtaaɗo oon wi'i mo : —Mi eeli ma, accu mi tokke. ");
INSERT INTO fuh_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Iisa jaɓaay, wi'i mo : —Hootu wuro maa nder koreeji maa, kaalanaa ɓe ko Joomiraawo waɗani ma, he no o yurmorii ma. ");
INSERT INTO fuh_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Nden gorko nyawtaaɗo oon dilli, fuɗɗi no sankita habaru oon nder leydi Gure-sappo gonɗe hakkune hoore huɗo he lettugal peta Galili. Ɗum haayɗini himɓe fuu. ");
INSERT INTO fuh_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Iisa naati laana soƴƴitii gaɗa koyɗe mum. Jama'aare mawne gom wari hawri to makko takkol peta Galili. ");
INSERT INTO fuh_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Wakkati Jayrus, gooto nder hooreeɓe *waajordu wuro ngoon, hi'unoo Iisa, o wari, o hofi yeeso Iisa. ");
INSERT INTO fuh_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","O ŋaarii Iisa, o wi'i : —Ɓiyam debbo woni no habda yonki. War ! Yowu junngo maa dow makko, heɓa o daɗa, o wuura ! ");
INSERT INTO fuh_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Iisa ummii tokki Jayrus. Jama'aare mawne tokki mo faa himɓe no njaaɓodira. ");
INSERT INTO fuh_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Debbo gom mo ƴiiƴam sukkitani ko waɗata duuɓi sappo e ɗiɗi no wonnoo hakkune maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","O tampi sanne, o yehi to sawrooɓe heewɓe, ɓe nyaamdi njawdi makko fuu. O heɓaay jam, nyaw nguun no nii no ɓeydoo. ");
INSERT INTO fuh_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","O nani habaru Iisa no waɗee sey o feeri hakkune jama'aare ndeen, ngam omo miila ko nde nii o meemii jabbaare Iisa tan o nyawtan. Sey o ƴuwri Iisa har gaɗa, o meemi jabbaare makko. ");
INSERT INTO fuh_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Wakkati mum da, ƴiiƴam ɗaam darii, o nani jam nder ɓanndu makko. ");
INSERT INTO fuh_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Iisa duu nani semmbe gom ƴuwi he muuɗum. O yeeƴitii hakkune jama'aare ndeen, o wi'i : —Moy meemii jabbaare am ? ");
INSERT INTO fuh_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","*Aahiiɓe makko mbi'i mo : —A hi'i jama'aare hawri, no ɓillii ma dey ƴamaa, mbi'aa moy meemii ma ? ");
INSERT INTO fuh_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Iisa tinni no daara nder fiiliiɓe ɗum ɓeen fuu, ngam hi'a meemuɗo ɗum oon. ");
INSERT INTO fuh_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Debbo meemuɗo Iisa oon huli, no diwna ngam no anndi ko waɗi. O wari, o hofii yeeso Iisa, o haalani mo fuu no waɗi. ");
INSERT INTO fuh_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Nden Iisa wi'i mo : —Banndam debbo, goonɗinol maa danni ma. Yah he jam ! A daɗii nyaw maaɗa. ");
INSERT INTO fuh_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Wakkati Iisa haaldannoo he debbo oon, sey himɓe gom ngari ƴuwi wuro Jayrus, mbi'i Jayrus : —Ko tampintaa moodibbo oo kaden ! Ɓiya heddaaki. ");
INSERT INTO fuh_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Amma Iisa hettinaaki haala maɓɓe, nden o wi'i Jayrus : —Taa hulu, goonɗin tan ! ");
INSERT INTO fuh_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Iisa accaay neɗɗo fuu yaada he mum wuro Jayrus se hanaa Piyer, Yakuuba he minyum Yahaaya. ");
INSERT INTO fuh_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Wakkati ɓe njottinoo wuro Jayrus, Iisa tawi jama'aare. Himɓe no mboya, no cimoo. ");
INSERT INTO fuh_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Nden o naati, o wi'i ɓe : —Ɗume woni bojji ɗii e hakkillo ummiingo ngoo nee ? Suka oon maayaay, o ɗaanii tan. ");
INSERT INTO fuh_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ɓe njali jaleeɗe yawaare. O waɗi ɓe mburtina, ɓe fuu. Nden ɓe naati dow suka oon, kanko Iisa oon, Jayrus e deekum, he *aahiiɓe tato ɓeen. ");
INSERT INTO fuh_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Iisa nanngi junngo suka oon, wi'i mo : —Talita kuum ! Kam woni : « Suka debbo, umma ! » ");
INSERT INTO fuh_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ɓii-Jayrus debbo oo, duuɓi mum sappo e ɗiɗi. O ummii wakkati mum da, omo dilla. Ɗum haaynii himɓe ɓeen sanne sanne. ");
INSERT INTO fuh_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Nden Iisa wi'i to ɓe kaalan ɗum neɗɗo fuu. O wi'i kaden suka oon hokkee ko nyaamee. ");
INSERT INTO fuh_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Iisa he *aahiiɓe mum ndilli wuro Jayrus, pa'i Nasaratu, wuro ngo Iisa mawnunoo nder mum. ");
INSERT INTO fuh_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","*Nyalaane fowteteene jaaƴi, o fuɗɗi waajaade nder *waajordu Nasaratu. Jama'aare hettinaniide waaju makko fuu haayɗinaama. Nden ɓe keddii iɓe mbi'a : —Toy o heɓi kujje ɗee fuu ? Moy hokki mo anndal ? Noy o heɓiri baawɗe waɗude kaayɗe ɗee ? ");
INSERT INTO fuh_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Hanaa ya kanko woni sekkeejo oo ? Hanaa kanko woni ɓii-Mariyaama naa ? Hanaa kanko woni mawnu Yakuuba, Yoses, Yahuuda he Simon'en ? Minyiraaɓe makko rewɓe no ngondi he meeɗen. Kujje ɗee ngaɗi ɓe calii Iisa. ");
INSERT INTO fuh_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Amma Iisa jaabii ɓe wi'i ko annabiijo no teddinee nokku fuu sey nder wuro mum, hakkune rimdaaɓe mum, he nder ɓaade mum'en. ");
INSERT INTO fuh_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ko ƴaari junngo makko ngo o yowi dow nyawɓe gom, o nyawti ɓe, Iisa heɓaay waɗi haayne baa worre ɗon. ");
INSERT INTO fuh_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Rafi goonɗinol maɓɓe haayɗini Iisa sanne. Iisa ummii naati gure cakaaje ɗeen fuu, omo waajoo. ");
INSERT INTO fuh_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Nyannde gom o noddi *lilaaɓe makko sappo e ɗiɗo ɓeen, o liliri ɓe ɗiɗɗiɗo. O hokki ɓe baawɗe riiwude ginnaaji, ");
INSERT INTO fuh_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","o wi'i ɓe : —Nde nii oɗon njaha, to kooƴee huune fuu, se hanaa cabbi mooɗon. To kooƴee nyaamdu, mbasu naa ceede. ");
INSERT INTO fuh_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ɓornee paɗe mooɗon, to ƴaaree toggooje ɗiɗi. ");
INSERT INTO fuh_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Nder wuro fuu ngo ngarɗon, ɓaade fuu nde njippiɗon nder mum, njooɗee nder mayre sey nyannde ndilloton. ");
INSERT INTO fuh_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Nde on ngari nder nokkuure, nde nii himɓe njaɓɓaaki on naa kettinanaaki on, nde nii on ummake ndilludu, piɗɗee sollaare koyɗe mooɗon ngam ɗum laatanoo ɓe seeda gacce maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","*Aahiiɓe ɓeen ummii, njehi no mbaajoo, no mbi'a himɓe tuuba. ");
INSERT INTO fuh_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ɓe ndiiwi ginnaaji ɗuɗɗi, ɓe mbuji himɓe heewɓe nebbam, himɓe ɓeen nyawti. ");
INSERT INTO fuh_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Innde Iisa walaa fuu to yehaay. *Hirudus, laamiiɗo leydi Galili, nani habaru Iisa no waɗee. No woodi wi'ooɓe Yahaaya gaɗoowo *batisma ummitii. Ngam majjum waɗi, omo waɗa kaayɗe. ");
INSERT INTO fuh_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Woɓɓe no mbi'a o Eliya. Woɓɓe duu no mbi'a o annabiijo nii non hano annabiiɓe aranɓe. ");
INSERT INTO fuh_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Wakkati *Hirudus nani haalaaji ɗii, o tinni omo ƴama hoore makko omo wi'a : —Yahaaya mo taƴunoomi hoore mum oon, kam ummitii, naa noy ? ");
INSERT INTO fuh_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","*Hirudus he hoore mum tilsiniino Yahaaya nanngee, haɓɓee, uddee, ngam Yahaaya wi'i mo ɗum daganaaki mo haɓɓande dee-mawniiko Filipa bi'eteeɗo Hirudiya. ");
INSERT INTO fuh_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Hirudiya duu no jogitani Yahaaya ngam sabbu ko o wi'i *Hirudus ɗum. O tefi laawol fuu no o waɗata, o waɗa Yahaaya waree. Amma o heɓaay laawol majjum, ");
INSERT INTO fuh_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ngam *Hirudus no teddina Yahaaya sanne. Omo anndi duu ko Yahaaya gorko ceniiɗo non, dartiiɗo. Omo hakkilii he makko sanne. Haalaaji ɗi Yahaaya haaldata he makko no jiiɓodira hakkillo makko. Amma fuu nii haɗataa omo nana belɗum hettinaade haalaaji Yahaaya. ");
INSERT INTO fuh_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Balɗe no njaha balɗe no ngarta faa nyannde gom ɗum fotodiri he nyalaane nde *Hirudus rimaa. Nyannde mum *Hirudus hawri himɓe ɓadiiɓe ɗum. O hawri hawjiiɓe laamu, o hawri hooreeɓe soogeeji, ngam ɓe kiirto wuro makko. Nyannde mum duu Hirudiya heɓi laawol no waɗata ko Yahaaya waree. ");
INSERT INTO fuh_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Jama'aare ndee fuu wari hawri, sey ɓii-Hirudiya debbo naati no woma. Ɗum weli *Hirudus he warɓe kawri ɓeen fuu. *Hirudus ummii, wi'i suka debbo oon : —Haalanan ko ngiɗaa mi waɗane. ");
INSERT INTO fuh_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","*Hirudus huni, wi'i kam no hokkan suka debbo oo huune fuu ko eeli ɗum, baa se tawi feccere leydi mum non. ");
INSERT INTO fuh_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Suka debbo oon wurtii, wi'i innum : —Ɗume eelanmi ? Nden Hirudiya, inna suka debbo oon jaabii ɓiyum, wi'i : —Hoore Yahaaya gaɗoowo *batisma ! ");
INSERT INTO fuh_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Sey suka debbo oon doggi, yehi to *Hirudus wi'i mo : —Joonin joonin, miɗo hiɗi hoore Yahaaya gaɗoowo *batisma waddee ɗo nder le'al ! ");
INSERT INTO fuh_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Wakkati *Hirudus nanunoo haala kaa, ɓerne makko metti faa hanaa seɗɗa. O hiɗaa egginde haala makko ngam hunayeere nde o waɗi yeeso noddaaɓe ɓeen fuu. ");
INSERT INTO fuh_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Nder soogeeji doomooɓe mo ɓeen, o lili soogeeru gom, taƴowa hoore Yahaaya, waddaa. Soogeeru nduun yehi, taƴi hoore Yahaaya, ");
INSERT INTO fuh_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","tummbi nder le'al, waddi, hokki suka debbo oon. Suka debbo oon duu hokki nde innum. ");
INSERT INTO fuh_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Wakkati aahiiɓe Yahaaya ɓeen nanunoo ɗum, ɓe ngari, ɓe kooƴi ɓanndu Yahaaya, ɓe mooɓowi. ");
INSERT INTO fuh_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Nyannde gom *lilaaɓe sappo e ɗiɗo ɓeen ngari kaalani Iisa, to kam'en mbaajii he ko kam'en ngaɗi. ");
INSERT INTO fuh_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Himɓe no njaha, no ngarta dow maɓɓe faa ɓe keppi fuu to ɓe njooɗoo ɓe nyaama. Sey Iisa wi'i ɓe : —Ngaree njehen to yeewii gom, heɓa baa powton. ");
INSERT INTO fuh_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Nden ɓe naati laana, kamɓe tan, ɓe ndilli. ");
INSERT INTO fuh_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Amma wakkati ɓe ndillannoo, himɓe heewɓe annditii to ɓe pa'i. Nden ɓe ƴuwri seraaji ɗiin fuu, ɓe ndoggi, ɓe artowi ɓe. ");
INSERT INTO fuh_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Wakkati Iisa wurtinoo laana kaan, o hi'i jama'aare ndeen, ɓe njurminii mo sanne, ngam iɓe nanndi baali ɗi ngalaa duroowo. O tinni omo waajoo ɓe ");
INSERT INTO fuh_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","dow kujje keewɗe faa jenngi. Sey *aahiiɓe makko ɓadii, mbi'i mo : —Joonin no ɗon no jennga, nokkuure ndee walaa fuy, ladde non. ");
INSERT INTO fuh_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Accu jama'aare ndeen sankitoo, ɓe naata nder gure he nokkuuje ɓadiiɗe, ngam ɓe coodowa ko nyaamee. ");
INSERT INTO fuh_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Iisa jaabii ɓe, wi'i : —Onon he ko'e mooɗon, kokkee ɓe ko ɓe nyaamata ! Nden ɓe mbi'i : —Aɗa hiɗi min coodanowa ɓe buuru tammaaje cardi keme ɗiɗi ɓe nyaama naa ? ");
INSERT INTO fuh_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Sey Iisa wi'i ɓe : —Njehee ndaarowee, buuruuje foti njogiɗon ? Wakkati ɓe ndaaroynoo, ɓe ngarti ɓe mbi'i Iisa buuruuje joy he liƴƴi ɗiɗi, kam'en njogii. ");
INSERT INTO fuh_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Nden Iisa wi'i *aahiiɓe mum, ɓe njonna jama'aare ndeen cefe cefe dow huɗo hecco ɗon da. ");
INSERT INTO fuh_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","*Aahiiɓe ɓeen njonniri jama'aare ndeen cefe hemre hemre, he cefe woygu woygu. ");
INSERT INTO fuh_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Iisa hooƴi buuruuje joy ɗeen e liƴƴi ɗiɗi ɗiin, tiggitii, yetti Alla. Nden o helti buuruuje ɗeen, o hokki *aahiiɓe ɓeen njeddana himɓe. He liƴƴi ɗiin duu, o waɗiri non. ");
INSERT INTO fuh_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Jama'aare ndeen fuu nyaami faa haari. ");
INSERT INTO fuh_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","*Aahiiɓe ɓeen kawrodiri buuru e liƴƴi koddiiɗum ɗum, ɗum hebbini kandeeje sappo e ɗiɗi. ");
INSERT INTO fuh_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Nyannde mum worɓe ujunaaji joyo nyaami buuru oon. ");
INSERT INTO fuh_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Gaɗa nyamnol worɓe ujunaaji joyo ɓeen, Iisa wi'i *aahiiɓe mum naata laana, peddita ardoo ɗum, njaha fonngo gooto hedde Baytisayda. Kanko duu o sallimoo jama'aare ndeen. ");
INSERT INTO fuh_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","O seedi he jama'aare ndeen, o nyakki waamnde faa o du'oo. ");
INSERT INTO fuh_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Naange yani, laana *aahiiɓe ɓeen no caka peta ngaan. Iisa duu, kam tan no darii dow fonngo ngo ɓe ndillunoo dow mum. ");
INSERT INTO fuh_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Fajiri wakkati Iisa hi'unoo ko laana *aahiiɓe ɓeen no fotta henndu, awƴaaki makka duu no tampinii. Iisa dilli he koyɗe dow ndiyam ɗaam, tayni ɓe. O hewti ɓe, faa omo tefa yawtude he maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Amma wakkati *aahiiɓe ɓeen ngi'unoo mo ndeen, ɓe miili ko mbeelu maayɗo gom non. Ɓerɗe maɓɓe taƴi, ɓe tinni iɓe kuuɓa. Nden Iisa wi'i ɓe : —Pukkinee hakkillooji mooɗon ! To kulee ! Miin non ! ");
INSERT INTO fuh_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","O naati laana kaan, henndu nduun darii. Haayne majjum nanngi *aahiiɓe ɓeen sanne. ");
INSERT INTO fuh_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ngam ɓerɗe maɓɓe no bumɗe, ɓe paamaay maana nyamnol worɓe ujunaaji joyo ɓeen. ");
INSERT INTO fuh_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ɓe pedditi peta ngaan, ɓe njottii leydi Genesaret, ɓe ndarii. ");
INSERT INTO fuh_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Wakkati ɓe mburtii laana kaan, himɓe annditi Iisa. ");
INSERT INTO fuh_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Wonnooɓe toon cankitii nder seraaji ɗiin fuu. Ɓe tinni iɓe ada nyawɓe maɓɓe dow kooƴirɗe maayɓe, iɓe njaara nokku fuu to ɓe nani Iisa woni. ");
INSERT INTO fuh_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Nokku fuu to Iisa yehi, rumtoowo non, siire non naa nder huɓeere non, o tawan himɓe no pukkina nyawɓe mum'en hunnduko luumo, iɓe eela mo, o acca nyawɓe ɓeen meema baa nii hunnduko jabbaare makko non. Nyawɓe heɓuɓe meemii mo ɓeen fuu nyawti. ");
INSERT INTO fuh_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Nyannde gom *Fariisa'en he jannginooɓe *Tawreeta gom ƴuwi *Ursaliima ngari to Iisa. ");
INSERT INTO fuh_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","4","Nder finaa-tawaa *Fariisa'en e *Yahudankooɓe, neɗɗo nyaamataa, lootaay juuɗe mum faa laaɓa. Kaden duu se neɗɗo warti, ƴuwi luumo, nyaamataa se lootaaki. Iɓe ngoodi duu finaa-tawaaji gom ɗi ɓe tokki hano lawƴol kore, ƴogirɗe, nyamruɗe, looɗe, e payanɗe. *Fariisa'en he jannginooɓe *Tawreeta ɓee ngi'ii ko nder *aahiiɓe Iisa woɓɓe lootaay juuɗe mum'en, iɓe nyaamira juuɗe ɗe laaɓaa. ");
INSERT INTO fuh_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Nden ɓe ƴami Iisa, ɓe mbi'i : —Ɗume waɗi *aahiiɓe maaɗa tokkataa finaa-tawaaji maamiraaɓe meeɗen, iɓe nyaamira juuɗe tunnuɗe ? ");
INSERT INTO fuh_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Nden Iisa jaabii ɓe, wi'i : —Munafiki'en ! *Esaaya woofaay sam, wakkati o waɗunoo annabaaku dow mooɗon. Nder maggu Alla wi'i : Himɓe ɓee no mbi'an kam'en no teddina kam, amma ɓerɗe maɓɓe no mboɗɗi kam. ");
INSERT INTO fuh_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Dewal maɓɓe no meere ngam ko ɓe ngoni iɓe njanngina ɗum to ɓiɓɓe aadama ƴuwi. ");
INSERT INTO fuh_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Onon *Fariisa'en, oɗon acca tilsinooje Alla, oɗon tokka finaa-tawaa ɓii-aadama. ");
INSERT INTO fuh_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Oɗon coofi finaa-tawaaji mooɗon he tilsinoore Alla ! ");
INSERT INTO fuh_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ngam nder *Tawreeta, *Muusa wi'i : Teddin inna maa he bammaa. O wi'i kaden duu : Kuɗuɗo innum naa bammum fuu no haani wareede. ");
INSERT INTO fuh_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Amma onon, ɗume mbi'oton, se neɗɗo wi'i innum naa bammum : Ko mbaawmi wallirde ma ɗum no « Korban », ko mi sakkanta Alla. ");
INSERT INTO fuh_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","On mbi'an mo, o accaa waɗande inniiko naa baabiiko fuy naa ? ");
INSERT INTO fuh_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Nii ngaɗirton, oɗon ngartira haala Alla meere ngam finaa-tawaaji mooɗon ɗi njannginton sukaaɓe. Ir majjum re'ataa ngonɗon oɗon ngaɗa. ");
INSERT INTO fuh_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Iisa nodditi jama'aare ndeen wi'i nde : —On fuu, kettinanee kam, paamee ko ");
INSERT INTO fuh_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","huune fuu ko ƴuwi yaasin naati nder ɓanndu neɗɗo hanaa kam watta joomum tunna yeeso Alla. Amma ko wurtotoo nder neɗɗo kam tunninta neɗɗo yeeso Alla.  ");
INSERT INTO fuh_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Jom nowru nanooru fuu nana ! ");
INSERT INTO fuh_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Iisa seedi he jama'aare ndeen, warti wuro. *Aahiiɓe makko ngari, ƴami mo maana ko o wi'i ɗum. ");
INSERT INTO fuh_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Nden o jaabii ɓe o wi'i : —Onon duu, on paamaay naa ? On paamaay ko huune fuu ko ƴuwi yaasin, naati ɓanndu neɗɗo, tunnintaa ɗum. ");
INSERT INTO fuh_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ɗum naataay nder ɓerne joomum, nder reedu joomum tan ɗum naati, nden ɗum yehee gaɗa wuro. Nder haalaaji ɗii, Iisa no holla ko nyaamdu fuu no laaɓi. ");
INSERT INTO fuh_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","O wi'i *aahiiɓe ɓeen kaden : —Ko wurtotoo ɓerne ɓii-aadama, kam tunninta ɗum. ");
INSERT INTO fuh_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ngam nder ɓerne neɗɗo miilooji bonɗi mburtoto hano iri ko semtini, nguyka, ittol yonki, ");
INSERT INTO fuh_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","jeenu, eelgal bonngal, bononda, jammba, golle nyidduɗe, haasidaaku, haala mbonka, mawnitaare, he bahimaare. ");
INSERT INTO fuh_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Golle bonɗe fuu nder ɓerne ƴuwata, kanƴe duu tunninta neɗɗo. ");
INSERT INTO fuh_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Iisa ummii, wari weeri leydi Tirus. O jippii nder ɓaade gom, o hiɗaa neɗɗo fuu faama to o woni. Amma ɗum fuu haɗaay himɓe anndi to o woni. ");
INSERT INTO fuh_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Nder wakkati mum, debbo ɓii-leydi Finisi-Siriya gom, ɓiyum debbo, ginnaaru no dow mum. Debbo oo hanaa Yahudanke, o nani habaru Iisa no waɗee. O ummii, o wari, o hofi yeeso Iisa. O eeli Iisa riiwa ginnaaru wonndu gaɗa ɓiyiiko. ");
INSERT INTO fuh_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Nden Iisa wi'i mo : —Accu sukaaɓe nyaama faa kaara ginan. Ngam hegaaki neɗɗo hooƴa nyaamdu sukaaɓe faɗɗana dawaaɗi. ");
INSERT INTO fuh_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Debbo oon jaabii Iisa, wi'i : —Goonga non, Joomam. Amma dawaaɗi duu no nyaama ko sukaaɓe camninta yeeso mum'en. ");
INSERT INTO fuh_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Sey Iisa wi'i debbo oon : —Ngam njaabaaki maaɗa kii, hootu, ɓiya seedi he ginnaaru nduun. ");
INSERT INTO fuh_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Debbo oon hooti, tawi ɓiyum seedi he ginnaaru nduun, no fukkii dow leeso. ");
INSERT INTO fuh_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Iisa ummii leydi Tirus, fa'i leydi Sidon, nden warti har peta Galili, o naati leydi Gure-sappo. ");
INSERT INTO fuh_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Nder leydi Gure-sappo, o waddanaa gorko paho gom, mo haala mum laaɓaa. O eelaa, o yowa junngo makko dow gorko oon. ");
INSERT INTO fuh_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Iisa hakkiti paho oon he jama'aare ndeen, watti kolli mum nder noppi paho oon, tutti nder junngo mum, meemi ɗemngal makko. ");
INSERT INTO fuh_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","O tiggitii, o uumi, nden o wi'i paho oon nder aramankoore : —Efata ! Kam woni : « Cukkitee ! » ");
INSERT INTO fuh_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Wakkati mum da, noppi gorko oon cukkiti, ɗemngal makko yoofaa, haala makko darti. ");
INSERT INTO fuh_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Nden Iisa wi'i to neɗɗo fuu haalan ɗum goɗɗo. Amma ngam omo haɗa ɓe, waɗi kamɓe duu iɓe ɓeyda sankitidde haala kaan. ");
INSERT INTO fuh_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Haayne nanngi ɓe faa noy walaa, ɓe tinni iɓe mbi'a : —Golle Iisa fuu no mbooɗi, faa yottii to Iisa no waɗa pahuɓe nana, beebeeɓe duu njeccoo. ");
INSERT INTO fuh_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Balɗe tati nii ko jama'aare mawne gom wari hawri to Iisa. Jama'aare ndee walaa fuu ko nyaama. Sey Iisa noddi *aahiiɓe mum, wi'i ɓe : ");
INSERT INTO fuh_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Himɓe ɓee no njurminii, balɗe tati nii hannden ko iɓe ngondi he am, ɓe ngalaa fuu ko ɓe nyaama. ");
INSERT INTO fuh_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Nde nii mi acci, ɓe koota ɓe nyaamaay, ɓe tampan sanne dow laawol. Ngam nder maɓɓe no woodi ƴuwɓe to woɗɗi. ");
INSERT INTO fuh_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Nden *aahiiɓe ɓeen njaabii mo, mbi'i : —Toy keɓeten ko nyamnirten ɓe nder ladde yeeruure ndee ? ");
INSERT INTO fuh_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Iisa ƴami ɓe, wi'i : —Buuruuje foti njogiɗon ? Ɓe njaabii mo, ɓe mbi'i : —Buuruuje jeɗɗi. ");
INSERT INTO fuh_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Nden o wi'i jama'aare ndeen jooɗoo he leydi. O hooƴi buuruuje jeɗɗi ɗeen, o yetti Alla, o helti ɗe, o hokki *aahiiɓe ɓeen njeddani jama'aare ndeen. ");
INSERT INTO fuh_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Iɓe njoginoo kaden likkoy seɗɗa gom. Iisa adi koy, yetti Alla, wi'i *aahiiɓe ɓeen njeddana ɓe koy, kankoy duu. ");
INSERT INTO fuh_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Jama'aare ndeen nyaami faa haari. *Aahiiɓe ɓeen kawri kelte ɗeen, ɗe kebbini kandeeje jeɗɗi. ");
INSERT INTO fuh_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Nyaamuɓe nyannde mum ɓeen, no ngaɗa hano worɓe ujunaaji nayo. Gaɗa mum, Iisa sallimii ɓe, ");
INSERT INTO fuh_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","naddi *aahiiɓe mum laana, fonndi leydi Dalmanuuta. ");
INSERT INTO fuh_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Nyannde gom *Fariisa'en ngari faa tunna Iisa. Ɓe puɗɗi haaldude he makko, ɓe ƴami mo, o holla ɓe alaama kaayɗiniiɗo ƴuwɗo dow kolloowo ko Alla lili mo. ");
INSERT INTO fuh_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Sey Iisa uumi, wi'i ɓe : —Ɗume waɗi ko onon himɓe jamaanu oo, oɗon ngiɗi holleede alaama ? Goonga kaalananmi on, alaama fuu walaa mo kolleteɗon ! ");
INSERT INTO fuh_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Gaɗa haalaaji ɗii walaa ko o ɓeydi, nden o seedi he maɓɓe, o naati laana, o fonndi fonngo gooto. ");
INSERT INTO fuh_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","15","Wakkati Iisa he *aahiiɓe mum ponndinoo fonngo gooto, Iisa fooɗi noppi maɓɓe wi'i ɓe, ɓe kakkilo he ƴuufinirɗum Fariisa'en he ƴuufinirɗum *Hirudus oon. Pooɗol noppi ngool fotodiri ko buuruure worre tan tawaa nder laana maɓɓe. Ɓe njeggiti ko no haani ɓe njalda buuruuje ɗuɗɗe gaɗa maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Sey *aahiiɓe ɓeen puɗɗi no kaalda, no mbi'a : —Naa ngam eɗen njogii buuruure ndee tan, waɗi o haali haala kaa ? ");
INSERT INTO fuh_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Iisa faami ko ɓe kaalata, nden wi'i ɓe : —Ɗume kaaloton hakkune mooɗon, oɗon mbi'a on ngalaa buuru ? Ɗume waɗi ko on paamataa ? Naa ɓerɗe mooɗon mbumu non ? ");
INSERT INTO fuh_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Oɗon ngoodi gite, amma on ngi'ataa ? Oɗon ngoodi noppi, amma on nanataa ? On miccitaaki naa ? ");
INSERT INTO fuh_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Wakkati njeddanmi worɓe ujunaaji joyo ɓeen buuruuje joy ɗeen, kandeeje foti kebbinirɗon ko nyaama hodda ɗum ? Ɓe njaabii mo, ɓe mbi'i : —Kandeeje sappo he ɗiɗi. ");
INSERT INTO fuh_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Iisa ƴami ɓe kaden, wi'i : —Nyannde njeddanmi worɓe ujunaaji nayo buuruuje jeɗɗi ɗeen, kandeeje foti kebbinɗon ko nyaama horii ɗum ? Ɓe njaabii Iisa, ɓe mbi'i : —Kandeeje jeɗɗi. ");
INSERT INTO fuh_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Nden, Iisa wi'i ɓe : —On paamaay faa joonin naa ? ");
INSERT INTO fuh_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Wakkati Iisa he *aahiiɓe mum njottinoo Baytisayda, sey himɓe ngaddani Iisa bumɗo gom. Wadduɓe bumɗo oo, eeli Iisa meema mo. ");
INSERT INTO fuh_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Iisa nanngi junngo bumɗo oon, hakkiti mo he himɓe, yaari mo gaɗa wuro ngoon. O tutti he gite bumɗo oon, o yowi juuɗe makko dow bumɗo oon, o wi'i : —Aɗa hi'a goɗɗum joonin naa ? ");
INSERT INTO fuh_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Sey bumɗo oon feerti gite mum, wi'i : —Miɗo hi'a himɓe, amma iɓe nga'ani kam hano leɗɗe jehooje nii. ");
INSERT INTO fuh_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Iisa yowi juuɗe mum dow gite makko kaden. Gorko oon feerti gite mum, sey wumti faa wooɗi, gite makko laaɓi tarr. ");
INSERT INTO fuh_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Gaɗa mum Iisa wi'i mo : —Hootu, dey to naatu wuro ngoo. ");
INSERT INTO fuh_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Nyannde gom Iisa he *aahiiɓe mum ummii naati nder gure cakaaje Kaysariya Filipi. Dow laawol o ƴami *aahiiɓe makko o wi'i : —Moy himɓe mbi'ata ngonmi ? ");
INSERT INTO fuh_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Nden ɓe njaabii mo, ɓe mbi'i : —No woodi wi'ooɓe a Yahaaya gaɗoowo *batisma, no woodi wi'ooɓe a Eliya, no woodi wi'ooɓe kaden a gooto nder annabiiɓe. ");
INSERT INTO fuh_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","O ƴami ɓe kaden, o wi'i : —Dey onon nee, moy mbi'oton ngonmi ? Sey Piyer jaabii mo, wi'i : —Aan woni *Almasiihu. ");
INSERT INTO fuh_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Nden Iisa fooɗi noppi maɓɓe wi'i to ɓe kaalan ɗum neɗɗo fuu. ");
INSERT INTO fuh_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Wakkati Piyer wi'unoo ko Iisa woni *Almasiihu, Iisa fuɗɗi no famtina *aahiiɓe mum, omo wi'a ɓe ko no tilsi *Ɓii-Neɗɗo torree sanne. Ardiiɓe mawɓe, hooreeɓe *cakkanooɓe Alla he jannginooɓe *Tawreeta tottitoo mo. O waree, nden gaɗa balɗe tati o ummitoo. ");
INSERT INTO fuh_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","O daraaki fuu o suuɗaana ɓe goɗɗum. Sey Piyer fooɗi mo senngo, tinni no haalda he makko dow ko o wi'i ɗum. ");
INSERT INTO fuh_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Nden Iisa hucciti har *aahiiɓe ɓeen, daari ɓe, nduki Piyer, wi'i mo : —Woɗɗam, aan Ibiliisa ! Sabu miilooji maaɗa, ƴuwaay to Alla, to himɓe ɗi ƴuwi. ");
INSERT INTO fuh_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Iisa noddi jama'aare ndeen, *aahiiɓe makko no tawaa nder mayre, o wi'i ɓe : —Muuyɗo tokkude kam fuu, acca daarude hoore mum, hooƴa *leggal mum bardugal, tokka kam. ");
INSERT INTO fuh_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Sabu giɗɗo hisinde yonki mum, mursan ki. Amma mursuɗo ki ngam am he ngam *Habaru lobbo oo, hisinan ki. ");
INSERT INTO fuh_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ɗume keɓol duuniyaaru nduu fuu nafirta neɗɗo, nde joomum mursi yonki mum ? ");
INSERT INTO fuh_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","No woodi ko neɗɗo waawi hokkitirde ngam heɓita ki naa ? ");
INSERT INTO fuh_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Neɗɗo fuu caliiɗo kam, miin he haalaaji am nder jamaanu bonɗo oo, murtuɗo he Alla, miin *Ɓii-Neɗɗo, miin duu, mi saloto joomum wakkati ngartitoymi, miin he maleykaaɓe seniiɓe, teddungal *Baabiraawo am no tokki. ");
INSERT INTO fuh_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","O wi'i ɓe : —Goonga kaalananmi on, nder tawaaɓe ɗo ɓe hannden, woɓɓe maayataa ngi'aay Laamu Alla no warda he baawɗe. ");
INSERT INTO fuh_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Balɗe jeegom gaɗa kollitol no Iisa tokkirtee, Iisa adi Piyer, Yakuuba, he Yahaaya, ɓe ŋabbi waamnde toowne gom. Tagaadi makko waylitii yeeso maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Kolte makko no ƴelkita, ɗe ndawni tar. Walaa lonnoowo koltal baawɗo ɓoosi koltal ngal laaɓa faa ngal rawnira non. ");
INSERT INTO fuh_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","*Aahiiɓe tato ɓeen ngi'ii Eliya he *Muusa mbanngi no kaalda he makko. ");
INSERT INTO fuh_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Kulkulal nanngi *aahiiɓe tato ɓeen fuu faa Piyer tinni no haala fuulu faalaaji gom no wi'a : —Moodibbo, no wooɗi ko tawaaɗen ɗo. Accu min nyiɓa hukumuuji tati ɗo. Aan worru, *Muusa worru, Eliya worru. ");
INSERT INTO fuh_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Luuldere gom wari suddi ɓe, sey daane gom ƴuwi nder luuldere ndeen wi'i : —Oo woni Ɓiyam mo korsinmi. Kettinanee mo ! ");
INSERT INTO fuh_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Nden *aahiiɓe ɓeen ndaari ngi'aay neɗɗo fuu se hanaa Iisa. ");
INSERT INTO fuh_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Wakkati Iisa he *aahiiɓe mum ɓeen njippotonoo waamnde ndeen, Iisa wi'i ɓe to ɓe kaalan neɗɗo fuu ko ɓe ngi'ii sey wakkati *Ɓii-Neɗɗo ummitii e maayde. ");
INSERT INTO fuh_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ɓe njaɓi, amma ɓe keddii, iɓe ƴamodira hakkune maɓɓe maana « ummitaaki ». ");
INSERT INTO fuh_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Nden ɓe ƴami Iisa, ɓe mbi'i : —Ɗume waɗi jannginooɓe *Tawreeta no mbi'a no tilsi Eliya arta *Almasiihu warde ? ");
INSERT INTO fuh_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Sey Iisa jaabii ɓe, wi'i : —Goonga, Eliya artata wara ginan, moƴƴina kujje fuu. Amma ɗume waɗi dewte Alla mbi'i no tilsi *Ɓii-Neɗɗo torree sanne, yennee ? ");
INSERT INTO fuh_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Miɗo haalana on, Eliya wariinoo, himɓe ngaɗanii mo ko ngiɗi hano no dewte Alla pillori ɗum. ");
INSERT INTO fuh_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Wakkati ɓe ngartunoo to *aahiiɓe ɓeeto, ɓe tawi jama'aare mawne no fiilii ɓe. Jannginooɓe *Tawreeta no njeddodira he maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Wonnooɓe nder jama'aare ndeen miilaayno ngi'a Iisa. Wakkati ɓe ngi'unoo mo ɓe nani belɗum, nden ɓe ndoggi ɓe njaɓɓowii mo. ");
INSERT INTO fuh_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","O ƴami ɓe, o wi'i : —Dow ɗume njeddodirton he jannginooɓe *Tawreeta ɓee ? ");
INSERT INTO fuh_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Sey gorko gom fiirti hunnduko, wi'i Iisa : —Moodibbo, mi waddanii ma ɓiyam gorko mo ginnaaru beebi. ");
INSERT INTO fuh_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Wakkati ɗum ummani mo fuu, iɗum liɓa mo, hunnduko makko no wurtina nguufo. Omo ŋerƴodira nyiiƴe, o yoora karaw. Mi eeli *aahiiɓe maaɗa ndiiwa ginnaaru nduun, amma ɓe keppi. ");
INSERT INTO fuh_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Nden Iisa wi'i jama'aare ndeen : —Hey onon himɓe jamaanu ɓe ngoonɗinaay ! Faa nde ngondanmi he mooɗon ? Faa nde tinnotoomi miɗo munyana on ? Ngaddanee kam suka oon ! ");
INSERT INTO fuh_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Iisa waddanaa suka oon. Wakkati ginnaaru nduun hi'unoo Iisa, ndu dimmbi suka oon, ndu liɓi suka oon. O heddi omo tallitoo, hunnduko makko no wurtina nguufo. ");
INSERT INTO fuh_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Iisa ƴami baaba oon, wi'i mo : —Illa nde ɗum heɓi mo ? *Baaba oon jaabii mo, wi'i : —Illa omo famɗi. ");
INSERT INTO fuh_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Kile keewɗe indu liɓa mo nder hiite naa nder ndiyam ngam tefude no ndu warirta mo. Yurma min, mballaa min nde nii aɗa waawi ! ");
INSERT INTO fuh_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Nden Iisa wi'i mo : —Nde nii miɗo waawi mbiiɗaa naa ? Too, huune fuu no hoyani goonɗinɗo. ");
INSERT INTO fuh_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Wakkati mum da, baaba suka oon huuɓi, wi'i : —Mi goonɗini, amma wallam ngam goonɗinol saɗi kam. ");
INSERT INTO fuh_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Wakkati Iisa hi'unoo himɓe no ndogga warde, o sajiti ginnaaru nduun o wi'i : —Aan beebinoowo e pahinoowo, ƴuw gaɗa suka oo, to tokku mo kaden faa abada ! ");
INSERT INTO fuh_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ginnaaru nduun huuɓi, dimmbiri suka oon semmbe semmbe, ƴuwi gaɗa makko. Suka oon wa'i hano maayɗo nii, faa ko heewi nder wonnooɓe ɗon ɓeen no mbi'a o maayi. ");
INSERT INTO fuh_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Iisa nanngi junngo makko, umminii mo, o darii. ");
INSERT INTO fuh_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Wakkati Iisa naatunoo suudu, *aahiiɓe makko ngari ƴami mo, mbi'i : —Ɗume waɗi ko minen, min keppi riiwude ginnaaru nduun ? ");
INSERT INTO fuh_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Nden Iisa jaabii ɓe, wi'i : —Du'aa'u tan, waɗataa neɗɗo riiwa iri ginnaaru nduu. ");
INSERT INTO fuh_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Gaɗa nyawtol suka beebaaɗo oon, Iisa ummidii *aahiiɓe mum, ɓe pedditi leydi Galili. O hiɗaa neɗɗo fuu faama to o woni. ");
INSERT INTO fuh_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Omo waajoo *aahiiɓe makko, omo wi'a ɓe *Ɓii-Neɗɗo no jammbetee, wattee nder juuɗe. O waree, balɗe tati gaɗa mum, o ummitoo. ");
INSERT INTO fuh_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","*Aahiiɓe makko ɓeen paamaay maana haala makko, ɓe kuli duu ƴamude mo. ");
INSERT INTO fuh_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Wakkati Iisa he *aahiiɓe mum njottinoo Kafarnahum, ɓe naati suudu weerirde maɓɓe. Iisa ƴami ɓe, wi'i : —Dow ɗume ngonɗon oɗon njeddodira wakkati ngonnoɗen dow laawol ? ");
INSERT INTO fuh_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Amma ɓe njaabaaki, ngam dow ɓurɗo teddude hakkune maɓɓe ɓe njeddodiri. ");
INSERT INTO fuh_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Iisa jooɗii, noddi ɓe, kamɓe *lilaaɓe sappo e ɗiɗo ɓeen, wi'i ɓe : —Neɗɗo fuu hiɗi ardaade himɓe, tilay sey heeda gaɗa, laatoo golloowo maɓɓe, ɓe fuu. ");
INSERT INTO fuh_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","O nanngi junngo cukalel gom, o darni yeeso maɓɓe, o huufi ngel, ");
INSERT INTO fuh_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","o wi'i ɓe : —Jaɓɓiiɗo suka gooto hano cukalel ngel dow innde am, miin jaati joomum jaɓɓii. Jaɓɓiiɗo kam fuu, hanaa miin tan jaɓɓii, lilɗo kam joomum jaɓɓii. ");
INSERT INTO fuh_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Nden Yahaaya wi'i mo : —Moodibbo, min ngi'ii gorko gom no riiwira innde maa ginnaaji. Min kaɗi mo, ngam o wondaa he meeɗen. ");
INSERT INTO fuh_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Sey Iisa wi'i : —To kaɗee mo, ngam neɗɗo fuu waawaa waɗude haayne gom dow innde am, dey seɗɗa gaɗa mum, sakitoo bonna innde am. ");
INSERT INTO fuh_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Mo wanyaay en, fuu no wondi he meeɗen. ");
INSERT INTO fuh_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Goonga kaalananmi on, neɗɗo fuu kokkuɗo on ndiyam nder nyeɗerde ngam oɗon ngondi he *Almasiihu, joomum heppataa baraaje mum baa seɗɗa. ");
INSERT INTO fuh_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Neɗɗo fuu waɗi gooto nder sukaaɓe goonɗinɓe kam ɓe waɗi hakke, ko ɓurani joomum wodde woni kaaƴa mannga haɓɓee he daane joomum, nden joomum faɗɗee nder maayo. ");
INSERT INTO fuh_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Se tawi junngo maaɗa waɗi ngaɗaa hakke, taƴu ngo. Ngam naatude nder mbuurnam nduumiiɗam he junngo wooto, no ɓuri moƴƴande neɗɗo dina naatirde juuɗe mum ɗiɗi nder jahannama, hiite nge nyifataa abada.  ");
INSERT INTO fuh_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Toon, gilƴi mum mbaatataa, hiite mum duu nyifataa. ");
INSERT INTO fuh_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Se tawi koyngal maa waɗi ngaɗaa hakke, taƴu ngal. Ngam naatude nder mbuurnam nduumiiɗam he koyngal gootal no ɓurani neɗɗo dina faɗɗeede koyɗe mum ɗiɗi fuu no kuuɓi he mum nder jahannama hiite nge nyifataa.  ");
INSERT INTO fuh_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Toon, gilƴi mum mbaatataa, hiite mum duu nyifataa. ");
INSERT INTO fuh_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Se tawi hitere maaɗa waɗi ngaɗaa hakke, ittu nde. Ngam naatude Laamu Alla a ɗokko, no ɓuri moƴƴande ma dina paɗɗideɗaa gite maaɗa ɗiɗi fuu no kuuɓi nder jahannama. ");
INSERT INTO fuh_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Toon, gilƴi mum mbaatataa, hiite mum duu nyifataa. ");
INSERT INTO fuh_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","No nyaamdu gom tilay sey wattanee lamɗam ngam ndu wela, hano non duu himɓe fuu sey hiite tukkee he mum'en heɓa jikkuuji mum'en ngarta lobbi. ");
INSERT INTO fuh_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Lamɗam huune lobbere non, amma nde ɗam lamsaa, ɗume lamsinta ɗam ? Laatee hakkune mooɗon hano lamɗam, ngondon he jam. ");
INSERT INTO fuh_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Iisa dilli Kafarnahum, fa'i gaɗa maayo Urdun nder leydi Yahudiya. Jama'aare wari, fiilii mo, o tinni omo waajoo ɓe hano no o woowrunoo waajoraade ɓe. ");
INSERT INTO fuh_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Sey Fariisa'en gom ngari to makko faa tunna mo, nden ɓe ƴami mo, ɓe mbi'i : —No daganii gorko seera deekum naa dagaaki ? ");
INSERT INTO fuh_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Iisa jaabii ɓe, wi'i : —Ɗume *Muusa tilsini on ngaɗon ? ");
INSERT INTO fuh_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ɓe njaabii, ɓe mbi'i : —*Muusa hokki laawol se gorko no seera deekum, winnda talkuru ceergal makko, nden seera mo. ");
INSERT INTO fuh_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Nden Iisa jaabii ɓe, wi'i : —Ngam on tiɓɓe-nyireeɓe, waɗi *Muusa winndani on tilsinoore ndee. ");
INSERT INTO fuh_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Amma illa fuɗɗorde, wakkati Alla no tagannoo huune fuu, o tagi himɓe gorko he debbo. ");
INSERT INTO fuh_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ngam majjum waɗi ko gorko no acca innum e bammum hawtaa he deekum, ");
INSERT INTO fuh_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ɓe fuu ɗiɗo ɓe laatoo ɓanndu worru. Ndenne joonin, ɓe kanaa ɗiɗo kaden, amma ɓe go'o. ");
INSERT INTO fuh_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","To neɗɗo senndu ko Alla hawri. ");
INSERT INTO fuh_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Wakkati Iisa he *aahiiɓe mum kootunoo, *aahiiɓe ɓeen ƴamti mo maana haala kaan. ");
INSERT INTO fuh_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Sey o wi'i ɓe : —Neɗɗo fuu ceerɗo deekum ɓaŋi goɗɗo, yeeni, ");
INSERT INTO fuh_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","hano non duu, debbo fuu ceeduɗo he gorum, dey ɓaŋa, debbo oon duu yeeni. ");
INSERT INTO fuh_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Nyannde gom himɓe ngaddi cukaloy mum'en to Iisa ngam o yowa juuɗe dow makkoy, amma *aahiiɓe ɓeen nduki ɓe. ");
INSERT INTO fuh_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Wakkati Iisa hi'unoo ɗum, ɗum naawi mo, nden o wi'i *aahiiɓe ɓeen : —Accee cukaloy koy ngara to am. To kaɗee koy, ngam nannduɓe he makkoy njeyi Laamu Alla. ");
INSERT INTO fuh_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Goonga kaalananmi on, mo jaɓɓoraaki Laamu Alla hano no cukalel ngel jaɓɓoraa nii, joomum naatataa nder maggu. ");
INSERT INTO fuh_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Nden o wunndii cukaloy koy, o yowi juuɗe dow makkoy, o barkini koy. ");
INSERT INTO fuh_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Nyannde gom, Iisa no caka yaadu sey gorko gom doggi wari, hofi yeeso makko, wi'i mo : —Moodibbo lobbo, ɗume kaanumi waɗude ngam heɓude mbuurnam nduumiiɗam ? ");
INSERT INTO fuh_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Iisa jaabii mo wi'i : —Ngam ɗume noddirtaa kam lobbo ? Lobbo fuu walaa sey Alla. ");
INSERT INTO fuh_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Aɗa anndi tilsinooje bi'ooje : To ittu yonki goɗɗo, to yeenu, to wujju, to seedana fewre, to toonya. Teddin inna maa e bammaa. Aɗa anndi ɗe naa ? ");
INSERT INTO fuh_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Gorko oon wi'i : —Moodibbo, kujje ɗee fuu miɗo hakkilii he majje illa cukaaku am. ");
INSERT INTO fuh_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Nden Iisa daari mo daarɗe hidde, wi'i mo : —Huune worre tan hoddanii ma. Sonnoy ko njogiɗaa fuu, njeddana talkaaɓe, a heɓan baraaje dow. Gaɗa mum, ngaraa tokkaa kam. ");
INSERT INTO fuh_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Gorko oo no diikuɗo sanne. Wakkati o nanunoo haalaaji ɗii, o ɓalinii, o dillidi mettorgal ɓerne. ");
INSERT INTO fuh_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Iisa daari *aahiiɓe mum, wi'i : —Naatol jom njawdi nder Laamu Alla no tiiɗi faa ! ");
INSERT INTO fuh_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Nanol haala kaa haayɗini *aahiiɓe ɓeen sanne. O wi'i ɓe kaden : —Giɗaaɓe am, naatude Laamu Alla no tiiɗi faa ! ");
INSERT INTO fuh_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ngam naatol ngolooba nder wudde battal no ɓuri hoyde dina naatol jom njawdi nder Laamu Alla. ");
INSERT INTO fuh_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Haayne ɓeydi nanngude *aahiiɓe ɓeen kaden. Ɓe keddii, iɓe ƴamodira hakkune maɓɓe, iɓe mbi'a : —Ndenne, moy hisata ? ");
INSERT INTO fuh_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Iisa daari ɓe, wi'i : —Ko heppori ɓii-aadama hepportaa Alla. Walaa fuu ko hepporta Alla. ");
INSERT INTO fuh_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Sey Piyer fiirti hunnduko wi'i mo : —Minen, min mboppii fuu, min tokki ma ! ");
INSERT INTO fuh_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Iisa jaabii ɓe, wi'i : —Goonga kaalananmi on. Neɗɗo fuu woppi wuro mum, rimdaaɓe mum worɓe naa rewɓe, neɗɗo fuu woppi innum naa bammum, woppi sukaaɓe mum naa gese mum ngam am he ngam *Habaru lobbo oo, ");
INSERT INTO fuh_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","joomum no heɓan ko ɓuri ɗum kile hemre nder duuniyaaru ndu ngonɗen nder muuɗum joonin nduu. Joomum no heɓan cuuɗi, rimdaaɓe worɓe he rewɓe, inniraaɓe, ɓiɓɓe e gese. Joomum no torretee duu nder mayru. Amma nder wakkati garoowo, joomum no heɓan mbuurnam nduumiiɗam. ");
INSERT INTO fuh_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Amma ardiiɓe heewɓe keedan gaɗa. Gaɗaaɓe ɓeen duu laatoto ardiiɓe. ");
INSERT INTO fuh_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Nyannde gom Iisa no ardi *aahiiɓe mum no tokki, iɓe pa'i *Ursaliima. Nder jahaangal maɓɓe ngaal, kulkulal no yaha no warta nder ɓerɗe *aahiiɓe ɓeen he nder ɓerɗe wondunooɓe he maɓɓe fuu. Iisa noddi *lilaaɓe mum sappo he ɗiɗo ɓeen feere, o haalani ɓe ko hewtoytoo mo *Ursaliima. ");
INSERT INTO fuh_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","O wi'i ɓe : —Kettinee, joonin enen nii eɗen njaha *Ursaliima, *Ɓii-Neɗɗo no wattetee nder juuɗe mawɓe *cakkanooɓe Alla he jannginooɓe *Tawreeta. Ɓe ngatta mo nder juuɗe ɓe kanaa *Yahudankooɓe, ɓe kiitoo mo kiite maayde. ");
INSERT INTO fuh_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ɓe njawoo mo, ɓe kartoo ɓe tutta dow makko, ɓe ɓocca mo, ɓe mbara mo. Amma balɗe tati gaɗa mum, o ummitoo. ");
INSERT INTO fuh_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Yakuuba he Yahaaya, ɓiɓɓe Jebede, ngari to Iisa mbi'i mo : —Moodibbo, miɗen ngiɗi min eele goɗɗum. Miɗen ngiɗi ngaɗanaa min ɗum duu. ");
INSERT INTO fuh_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Sey Iisa wi'i ɓe : —Ɗume ngiɗɗon mi waɗana on ? ");
INSERT INTO fuh_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Nden ɓe njaabii mo, ɓe mbi'i : —Nyannde njooɗiɗaa dow jooɗorgal laamu maa ngu darja, accu min njooɗoo takkol maaɗa, gooto nyaamo maa, ooto nano maa. ");
INSERT INTO fuh_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Nden Iisa jaabii ɓe, wi'i : —On anndaa ko eeloton. Oɗon mbaawi yarirde nyeɗerde nde njaranmi ndeen naa ? Oɗon mbaawi munyi waɗaneede *batisma mo ngaɗanteemi oo naa ? ");
INSERT INTO fuh_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ɓe njaabii mo, ɓe mbi'i : —Miɗen mbaawi. Nden Iisa wi'i ɓe : —On njaran nyeɗerde nde njaranmi ndeen, on ngaɗantee *batisma mo ngaɗanteemi oon, ");
INSERT INTO fuh_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","amma jooɗaade nyaamo am naa nano am, hanaa miin woodi baawɗe hokkude ɗum. Alla moƴƴini jooɗorɗe ɗee ngam ɓe o suɓi. ");
INSERT INTO fuh_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Wakkati *aahiiɓe sappo ɓeeto nanunoo ko Yakuuba e Yahaaya ƴamani ko'e mum'en, ɗum monnini ɓe. ");
INSERT INTO fuh_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Sey Iisa noddi ɓe, ɓe fuu, wi'i : —Oɗon anndi doole doole laamiiɓe ɓe kanaa *Yahudankooɓe laamorii himɓe mum'en. Mawɓe maɓɓe ɓeen duu kolli baawɗe. ");
INSERT INTO fuh_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Amma onon kay, ɗum waɗataa hakkune mooɗon. Giɗɗo laatoo tedduɗo hakkune mooɗon, on fuu, no haani laatoo golloowo mooɗon. ");
INSERT INTO fuh_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Kaden duu, giɗɗo ardaade nder mooɗon, no haani laatoo maccuɗo mooɗon, on fuu. ");
INSERT INTO fuh_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","*Ɓii-Neɗɗo he hoore mum waraay faa gollanee, amma o wari faa o ngollana himɓe fuu, o mursa yonki makko ngam hisinde himɓe heewɓe. ");
INSERT INTO fuh_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Iisa he *aahiiɓe mum ngari Yeriko. Wakkati Iisa, *aahiiɓe mum he jama'aare gom umminoo Yeriko no pa'i *Ursaliima, bumɗo gom bi'eteeɗo Bartima'us ɓii-Tima'us no jooɗii no garbina takkol laawol. ");
INSERT INTO fuh_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","O nani no wi'ee Iisa mo Nasaratu woni no yawta, sey o fuɗɗi huuɓude, omo wi'a : —Iisa, taan Daawda, yurmam ! ");
INSERT INTO fuh_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Himɓe heewɓe tokkitii no cajitoo he makko, no mbi'a o deƴƴita, amma kanko duu wakkati mum nii, o huuɓi kaden, o wi'i : —Taan Daawda, yurmam ! ");
INSERT INTO fuh_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Sey Iisa darii, wi'i Bartima'us noddee. Nden, o noddaa o wi'aa : —Haya ! Umma, o wi'i ngaraa ! ");
INSERT INTO fuh_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Bartima'us garbisi, faɗɗi suddamaare mum, wari to Iisa. ");
INSERT INTO fuh_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Iisa ƴami mo, wi'i : —Ɗume ngiɗaa mi waɗane ? Bartima'us jaabii mo, wi'i : —Moodibbo, miɗo hiɗi mi wumta. ");
INSERT INTO fuh_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Sey Iisa wi'i mo : —Yah ! Goonɗinol maaɗa hisinii ma. Wakkati mum da o wumti, o tokki Iisa, ɓe ndilli. ");
INSERT INTO fuh_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Wakkati Iisa he *aahiiɓe mum wonnoo hakkune Baytifaaji he Baytaniya, hedde har waamnde wi'eteene waamnde Jaytun, ɓe mboɗɗaaki *Ursaliima sanne, sey Iisa lili *aahiiɓe mum ɗiɗo gom, ");
INSERT INTO fuh_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","o wi'i ɓe : —Ummee, njehee nder wurel gonngel yeeso mooɗon ngeel. No nattirɗon nder maggel, on tawan ɓinngel ara gom, ngel waɗɗaaka abada gom no haɓɓii. Kaɓɓitee ngel, ngaddanon kam. ");
INSERT INTO fuh_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Nde nii goɗɗo ƴamii on wi'i ngam ɗume waɗi oɗon ngaɗa ɗum, mbi'on Joomiraawo haajaa ngel. Dey o wartiran ngel law. ");
INSERT INTO fuh_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ɓe njehi, ɓe tawi ɓinngel ara ngel no haɓɓii yaasi dammbugal ɓaade ndeen, ɓe kaɓɓiti ngel. ");
INSERT INTO fuh_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Sey wonnooɓe no ndarii ɗon ɓeen ƴami ɓe, mbi'i : —Ɗume ngatton ɗo nii ? Ɗume kaɓɓitanton arel ngeel ? ");
INSERT INTO fuh_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","*Aahiiɓe ɓeen njaaborii ɓe dey-dey no Iisa wi'irnoo ɓe. Himɓe ɓeen acci ɓe, ɓe ndillidi arel ngel. ");
INSERT INTO fuh_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ɓe njaari ngel to Iisa, ɓe mbeɗɗiti kolte maɓɓe dow maggel, Iisa waɗɗii. ");
INSERT INTO fuh_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Dow laawol, himɓe ɗuɓɓe mbeɗɗiti kolte mum'en, woɓɓe kelti licce mbeerti dow maggol. ");
INSERT INTO fuh_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ardiiɓe mo he heedanɓe mo gaɗa no kuuɓa no mbi'a : —Hosanna  !Barkinaaɗo woni garɗo dow innde Joomiraawo ! ");
INSERT INTO fuh_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Barke tabbita he laamu ngaroowu, laamu maama meeɗen Daawda ! Jettooje ngoodani Alla Toowɗo ! ");
INSERT INTO fuh_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Wakkati Iisa naatunoo *Ursaliima, o naati nder *Juulirde mawne. O hi'i huune fuu ko woni nder mayre. Amma ngam naange no yana, o wurtii *Ursaliima, o yehi Baytaniya, kanko he *aahiiɓe makko sappo e ɗiɗo ɓeen. ");
INSERT INTO fuh_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Wakkati Iisa he *aahiiɓe mum ndawannoo Baytaniya no pa'i *Ursaliima, Iisa no nanannoo rafo. ");
INSERT INTO fuh_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Sey toon dow laawol, o holliri ibbi gom ngooduki haako. O yehi, o ƴeewowi nde iki tawdee ɓiɓɓe. Wakkati o yottinoo to makki, fuy non o tawaay he makki se hanaa kaakooli, wakkati dimol ibbe waɗaay. ");
INSERT INTO fuh_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Iisa wi'i ibbi kiin : —To neɗɗo fuu yeeƴito nyaama ɓiɓɓe maa kaden ! *Aahiiɓe makko nani ko o wi'i ki. ");
INSERT INTO fuh_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","No Iisa'en njottorii *Ursaliima, Iisa naati jawreeru Juulirde *Ursaliima mawne, o fuɗɗi omo riiwa soodooɓe e sonnooɓe wonɓe nder mayru. O liɓi teburuuji weccooɓe ceede he jooɗorɗe sonnooɓe buugaali. ");
INSERT INTO fuh_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","O haɗi yaha-warta ɓiɓɓe luumooɓe he donle mum'en nder mayre. ");
INSERT INTO fuh_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","O waajii ɓe o wi'i : —Hanaa no winndii nder dewte, Alla wi'i : Suudu am no inndirtee suudu to lenyi fuu ngarta du'oo ! Amma onon, on ngaɗii ndu wumpere wuyɓe. ");
INSERT INTO fuh_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Mawɓe *cakkanooɓe Alla he jannginooɓe *Tawreeta nani ko o wi'i. Ɓe tefi joonkay no ɓe mbardata mo, amma ɓe kuli mo, ngam waaju makko naatii jama'aare ndeen sanne. ");
INSERT INTO fuh_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Wakkati naange yanunoo Iisa he *aahiiɓe mum mburtii huɓeere *Ursaliima pa'i Baytaniya. ");
INSERT INTO fuh_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Jaangoore kippol teburuuji weccooɓe ceede e sonnooɓe buugaali ɓeen, Iisa'en kejji illa beete coƴƴi *Ursaliima. Wakkati ɓe paani ibbi kiin sey ɓe ngi'ii ko ki yoorii karaw faa he ɗaɗi. ");
INSERT INTO fuh_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Nden Piyer miccitii, wi'i Iisa : —Moodibbo, ndaa ! Ibbi ki kuɗunoɗaa kiin yoorii. ");
INSERT INTO fuh_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Sey Iisa jaabii, wi'i ɓe : —Ngoonɗinee Alla ! ");
INSERT INTO fuh_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Goonga kaalananmi on. Neɗɗo fuu bi'uɗo waamnde ndee ɗoofa, saamoy ley maayo, nde nii joomum goonɗinii nder ɓerne muuɗum, ko kam wi'i ɗum waɗan. Sikka fuu walaa joomum no jaabantee ko wi'i ɗum. ");
INSERT INTO fuh_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ngam majjum waɗi miɗo wi'a on, ko eeluɗon nder du'aa'u fuu, ngoonɗinee ko on keɓii ɗum, on njaabantee ɗum duu. ");
INSERT INTO fuh_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Kaden wakkati fuu mo ndariɗon oɗon du'oo, nde nii no woodi mo njogitaniɗon, njaafanee mo ko o waɗi on ɗum, ngam Baabii'on gonɗo dow yaafanoo on gacceeji mooɗon.  ");
INSERT INTO fuh_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Amma se on njaafaaki, *Baaba mooɗon gonɗo dow oon duu yaafataako hakkeeji mooɗon. ");
INSERT INTO fuh_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Iisa he *aahiiɓe mum ngarti *Ursaliima. Wakkati Iisa fiilotonoo nder *Juulirde *Ursaliima mawne, hooreeɓe *cakkanooɓe Alla, jannginooɓe *Tawreeta he mawɓe *Yahudankooɓe ɓadii mo, ");
INSERT INTO fuh_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ƴami mo mbi'i : —Baawɗe ɗeye ngaɗirtaa kujje ɗee fuu ? Moy hokki ma laawol waɗude ɗe ? ");
INSERT INTO fuh_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Sey Iisa jaabii ɓe, wi'i : —Mi ƴaman on huune worre tan, onon duu. Nde nii on njaabake kam, mi haalanan on baawɗe ɗeye ngaɗiranmi kujje ɗee fuu. ");
INSERT INTO fuh_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Alla naa himɓe kokki Yahaaya laawol waɗude *batisma ? Miɗo hettinanii on ! ");
INSERT INTO fuh_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Sey iɓe caawodira hakkune maɓɓe, iɓe mbi'a : —Nde nii en mbi'i Alla, o wi'an ko waɗi en ngoonɗinaay Yahaaya ? ");
INSERT INTO fuh_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Amma eɗen mbaawi wi'ude himɓe naa ? Ɓe ƴamodiri nde iɓe mbaawi mbi'i nii ngam iɓe kula himɓe. To himɓe fuu, tabbat Yahaaya gaɗoowo *batisma no annabiijo. ");
INSERT INTO fuh_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Sey ɓe njaabii Iisa, ɓe mbi'i : —Min anndaa. Nden Iisa wi'i ɓe : —Too, miin duu, mi haalantaa on baawɗe ɗeye ngaɗiranmi kujje ɗee fuu. ");
INSERT INTO fuh_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Nder *Ursaliima Iisa tinni no haalda *aahiiɓe mum he hooreeɓe *Yahudankooɓe nder kippol haala, omo wi'a : —Neɗɗo gom waɗi ngesa *cabiije. O waɗi koogol o fiiltini nga. O wasi luggere ɓoosirde, o nyiɓi suudu toownu ngam doomooɓe magga. Nden o wuƴi nga remooɓe gom, o waɗi jahaangal. ");
INSERT INTO fuh_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Wakkati teɓol cabiije ɗeen yottinoo, o lili golloowo makko gom jaɓowa mbaka makko to remooɓe ɓeen. ");
INSERT INTO fuh_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Remooɓe ɓeen nanngi lilaaɗo oon, piyi mo, njoofi mo juuɗe ɓole. ");
INSERT INTO fuh_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Jom ngesa kaan liliti golloowo mum gom kaden to maɓɓe. Ɓe eli mo, ɓe njenni mo. ");
INSERT INTO fuh_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Jom ngesa oon lili faa hannden golloowo mum gom kaden, ɓe mbari lilaaɗo oon. O lili gollooɓe makko re'ataa he maɓɓe. Ɓe piyi woɓɓe, ɓe mbari woɓɓe duu. ");
INSERT INTO fuh_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Neɗɗo gooto koraniiɗo mo oon, woni ɓiyiiko korsuɗo. Kanko duu o lili mo he maɓɓe, o wi'i hoore makko : « Ɓe teddinan mo ngam o ɓiyam. » ");
INSERT INTO fuh_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Amma remooɓe ɓeen mbi'odiri hakkune mum'en : « Ma'adalla. Oo nii woni donoowo oon. Ngaree mbaren mo, heɓa ndonen ngesa ngaa ! » ");
INSERT INTO fuh_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Sey ɓe nanngi mo, ɓe mburtini mo nder ngesa ngaan, ɓe mbari mo. ");
INSERT INTO fuh_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Gaɗa pillaaki kippol haala ngool, Iisa ƴami, wi'i : —Too ! Joonin, noy jom ngesa ngaan waɗata ? O waran kanko he hoore makko, o wara remooɓe ɓeen, o halfina ngesa ngaan woɓɓe, naa noy ? ");
INSERT INTO fuh_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","On njanngaay ko winndaa nder dewte ɗeen, wi'aa : Hayre nde nyiɓooɓe ɓeen mboppi ndeen, kayre laatii hoore nyibdi ndiin. ");
INSERT INTO fuh_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ɗum golle Joomiraawo, haayne non duu he giiɗe meeɗen ! ");
INSERT INTO fuh_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Hooreeɓe *Yahudankooɓe tefi no nanngirta Iisa, ngam ɓe paamii ko kippol haala ngool, kamɓe ngol sappii. Amma ɓe cuusaay jama'aare ndeen, ngam majjum waɗi ɓe acci mo, ɓe ndilli. ");
INSERT INTO fuh_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Balɗe no njaha balɗe no ngarta sey nyannde gom *Fariisa'en he himɓe *Hirudus lili *lilaaɓe he Iisa ngam tunna mo nder haalaaji makko. ");
INSERT INTO fuh_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ɓe ngari, ɓe mbi'i mo : —Moodibbo, miɗen anndi ko goonga tan kaalataa. A hulataa neɗɗo fuu, a ɓurdinaay himɓe, aɗa janngina laawol Alla goonga e goonga. No hegii min kokka laamiiɗo *Rooma mawɗo janngal naa hegaaki ? ");
INSERT INTO fuh_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Min kokka mo naa to min kokku mo ? Iisa faamani munafikaare maɓɓe, nden wi'i ɓe : —Ɗume waɗi ko oɗon tunna kam ? Ngaddanee kam tammal cardi, mi hi'a. ");
INSERT INTO fuh_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ɓe ngaddani mo. O ƴami ɓe o wi'i : —Foto moy he innde moy woni ɗo ? Ɓe mbi'i mo : —Laamiiɗo *Rooma. ");
INSERT INTO fuh_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Nden o jaabii ɓe, o wi'i : —Ndenne kokkee laamiiɗo *Rooma ko jeyi, kokkon Alla duu ko jeyi. Ko Iisa jaabii ɗum haaynii ɓe sanne. ");
INSERT INTO fuh_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","*Sadduki'en, kam'en ngoni yeddooɓe no mbi'a ko maayɗo fuu ummitittaako. Nyannde gom, ɓe ummii ɓe ngari to Iisa. ");
INSERT INTO fuh_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Ɓe ƴami mo, ɓe mbi'i : —Moodibbo, *Muusa tilsinii enen *Yahudankooɓe, nde gorko dewli, dey maayi rimaay, minyum naa mawnum dewla deekiiko ngam heɓana mo jippotooɓe. ");
INSERT INTO fuh_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Waɗiino rimdaaɓe jeɗɗo gom. Arano oon dewli debbo mum, dey maayi, rimaay. ");
INSERT INTO fuh_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ɗiɗaɓo oon dewli debbo oon, kam duu maayi rimaay. Tataɓo oon duu waɗi hano non. ");
INSERT INTO fuh_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Rimdaaɓe jeɗɗo ɓeen fuu tokki ndewli debbo oon, baa gooto maɓɓe rimaay. Gaɗa maayde maɓɓe, ɓe fuu, debbo oon duu maayi. ");
INSERT INTO fuh_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Too, nyannde darŋal, moy nder maɓɓe laatoto goro debbo oo ? Ngam ɓe fuu jeɗɗo kaɓɓani mo. ");
INSERT INTO fuh_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Iisa jaabii ɓe, wi'i : —On mboofii, oɗon anndi ngam ɗume ? Ngam on paamaay ko dewte ɗeen mbi'i, on anndaa duu baawɗe Alla. ");
INSERT INTO fuh_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ngam nyannde maayɓe ummitii, worɓe ndewlataa, rewɓe duu ndewlataake. Himɓe fuu no mbuuran hano no maleykaaɓe mbuurdiri nder kammu. ");
INSERT INTO fuh_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Har ko daarata ummitaaki maayɓe, on njanngaay ɗum jaa nder dewtere *Muusa, nder taariihi wuumoore huɓɓoore. Hano no Alla haaldiri he *Muusa nii, wi'i : Miin woni Alla *Ibrahim, Alla Isiyaaku, Alla Yakuuba. ");
INSERT INTO fuh_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Nden Iisa ɓeydi wi'ude ɓe : —O Alla wuurɓe, o hanaa Alla maayɓe. Ndenne, on mboofii sanne sanne. ");
INSERT INTO fuh_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Nyannde gom jannginoowo *Tawreeta gom nani yewtere Iisa he *Sadduki'en. O nani duu ko Iisa jaabake ɓe faa wooɗi. Jannginoowo *Tawreeta oo ɓadii Iisa, ƴami mo wi'i : —Nder tilsinooje ɗee fuu, ndeye ɓuri semmbe ? ");
INSERT INTO fuh_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Nden Iisa jaabii mo, wi'i : —Ɓurne ɗe fuu semmbe woni wi'ude : Hettina *Isra'el ! Alla Joomiraawo meeɗen tan woni Joomiraawo. ");
INSERT INTO fuh_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Hiɗir Alla Joomiraawo maa he ɓerne maa fuu he yonki maa fuu he hakkillo maa fuu he semmbe maa fuu. ");
INSERT INTO fuh_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Tilsinoore ɗiɗaɓere ndeen woni : Ngiɗaa gondo maa no ngiɗirɗaa hoore maa. Walaa fuu tilsinooje ɓurɗe tilsinooje ɗiɗi ɗee semmbe. ");
INSERT INTO fuh_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Nden jannginoowo *Tawreeta oon wi'i mo : —Moodibbo ! A haalii goonga, ko mbi'uɗaa Alla tan woni Joomiraawo, kaden duu Alla gom fuu walaa se hanaa kanko. ");
INSERT INTO fuh_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Hiɗirde Alla he ɓerne mum fuu he hakkillo mum fuu he semmbe mum fuu, he hiɗirde gondo mum hano neɗɗo hiɗiri hoore mum, no ɓuri sadakaaji buleteeɗi he sadakaaji fuu ! ");
INSERT INTO fuh_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Wakkati Iisa hi'unoo ko jannginoowo *Tawreeta oo jaaborake ɗum he hakkillo, nden o wi'i mo : —A woɗɗaa Laamu Alla. Gaɗa jannginoowo *Tawreeta oo, neɗɗo fuu suusaay ƴamude Iisa goɗɗum kaden. ");
INSERT INTO fuh_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Nyannde gom Iisa no waajoo nder *Juulirde *Ursaliima mawne, sey o ƴami, o wi'i : —Noy waɗi jannginooɓe *Tawreeta no mbi'a ko *Almasiihu taan Daawda non ? ");
INSERT INTO fuh_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ngam Daawda he hoore mum haali nder baawɗe *Ruuhu Ceniiɗo wi'i : Alla Joomiraawo wi'i Joomiraawo am : War, njooɗaa nyaamo am, faa mi sorna wayɓe maa ley teppere maa. ");
INSERT INTO fuh_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Daawda he hoore mum inndiri *Almasiihu Joomiraawo mum. Ndenne, noy o laatortoo taaniiko tan ? Jama'aare e jama'aare woni no hettinanii Iisa nder welwelo. ");
INSERT INTO fuh_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Nder waaju makko, o wi'i ɓe : —Tinnee, kakkilee he jannginooɓe *Tawreeta. Iɓe ngiɗi ɓornaade kolte mawɗe. Iɓe ngiɗi sanneede cannooje tedduɗe nder luuɓe. ");
INSERT INTO fuh_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Iɓe ngiɗi jooɗorɗe ɓurɗe teddude nder *baajorɗi. Iɓe ngiɗi jooɗorɗe ɓurɗe teddude nde nii ɓe noddaama batu. ");
INSERT INTO fuh_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Iɓe eyta rewɓe ɓe goriraaɓe mum'en maayi ngam teetude njawdi maɓɓe. Iɓe njunna du'aa'uuji maɓɓe ngam ɓe limtee nder lobbuɓe. Kiite naawɗe ɓe ngaɗantee. ");
INSERT INTO fuh_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Iisa no jooɗii nder *waajordu, omo hucciti he keesuwal mayru. Omo daara no himɓe ngattirta hadiyaaji mum'en nder maggal. Riikuɓe heewɓe ngatti ceede ɗuɗɗe nder maggal. ");
INSERT INTO fuh_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Fotodiri nyannde mum debbo gom mo gorum maayi, mo walaa fuy, wari, watti buuɗoy ɗiɗoy nder maggal. ");
INSERT INTO fuh_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Sey Iisa noddi *aahiiɓe mum, wi'i ɓe : —Goonga kaalananmi on : Debbo oo, ko o watti nder keesuwal ngaal no ɓuri ko ɓeeto fuu ngatti. ");
INSERT INTO fuh_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ngam ko ɓe ngatti nder keesuwal ngaal ɓuytataa fuy nder njawdi maɓɓe. Amma debbo oo, ko o joginoo ngam o wuurda, ɗum o watti nder maggal. ");
INSERT INTO fuh_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Nyannde gom wakkati Iisa wurtinoo nder *Juulirde mawne, aahiijo makko gom wi'i mo : —Moodibbo, ndaa kaaƴo mawko koo, kanko he nyibdiiji booɗuɗi ɗii fuu ! ");
INSERT INTO fuh_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Sey Iisa jaabii mo wi'i : —A hi'i nyibdi ndii, no ndi foti manngu, baa hayre worre hoddataako no deki dow wonnde. Ndi fuu, ndi liɓetee. ");
INSERT INTO fuh_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Nyannde gom Iisa no jooɗii dow waamnde wi'eteene waamnde Jaytun. Omo hucciti har Juulirde *Ursaliima mawne. Sey Piyer, Yakuuba, Yahaaya he Andiire ummii njehi to makko kamɓe tan, ƴami mo, mbi'i : ");
INSERT INTO fuh_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Haalan min nde liɓol ngool waɗata. Alaama oye hi'etee wakkati ɗum hiɗi waɗude ? ");
INSERT INTO fuh_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Sey Iisa jaabii ɓe, wi'i : —Kakkilee to neɗɗo fuu majjina on. ");
INSERT INTO fuh_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Himɓe heewɓe no ngardan innde am, iɓe mbi'a : « Miin woni *Almasiihu. » Ɓe majjina himɓe heewɓe. ");
INSERT INTO fuh_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Nde nii on nani habaru konuuji naa siri majji, to kulee. No tilsi ɗum waɗa, amma ɗum hanaa alaama kolloowo timmoode duuniyaaru. ");
INSERT INTO fuh_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Lenyol habdan he lenyol, laamu habdan he laamu. Dimmbaaki leydi waɗan nokku nokkuuje, rafooji duu ngaɗan. Ɗum nanndaana he fuɗɗorde ŋatawere. ");
INSERT INTO fuh_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Ndeenee ko'e mooɗon, ngam himɓe no njaaran on to hiitotooɓe. Ɓe piyan on nder *baajorɗi maɓɓe. Ɓe ndarna on yeeso hooreeɓe kam e laamiiɓe ngam sabbu am, ngam ceedoɗon yeeso maɓɓe dow *Habaru lobbo oo. ");
INSERT INTO fuh_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","No tilsi *Habaru lobbo oon waajee nder lenyi fuu. ");
INSERT INTO fuh_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Wakkati ɓe nanngoyta on faa ɓe njaara on yeeso hiitotooɓe, to ko'e mooɗon kaɓɓo dow ko kaaloton. Nde wakkati oon warii fuu, on keɓan ko kaaluɗon. Ngam hanaa onon kaalata, *Ruuhu Ceniiɗo haalata. ");
INSERT INTO fuh_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Himɓe no kokkitiran sakiraaɓe mum'en mbaree, baaba no hokkitiran ɓiyum. Sukaaɓe no ummanto saarooɓe mum'en, gaɗa dabare ɓe mbaree. ");
INSERT INTO fuh_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ngam am, himɓe fuu mbanyan on. Amma tarsiniiɗo faa yottii he timmoode, joomum no hisintee. ");
INSERT INTO fuh_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","On ngi'an huune bonde, ɓurne nyiddinaade no waddetee, darnee to nde haanaa darneede. (Jannguɗo ɗum fuu faama ɗum no wooɗiri.) Nden, tawaaɓe nder Yahudiya fuu ndoggira baamle. ");
INSERT INTO fuh_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Tawaaɗo dow suudu, to jippoo wi'a naatan suudu hooƴa goɗɗum. ");
INSERT INTO fuh_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Tawaaɗo ngesa, to yeeƴito hooƴa koltal mum. ");
INSERT INTO fuh_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Nder balɗe mum bone no saaman dow saawɓe he musinooɓe ! ");
INSERT INTO fuh_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Eelee Alla to ɗum fottodir he dunngu. ");
INSERT INTO fuh_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ngam nder wakkati oon ɗon, torra mawka waran. Illa wakkati Alla tagi duuniyaaru faa warde hannden iri makka waɗaayno abada. Iri makka waɗataa kaden duu faa abada. ");
INSERT INTO fuh_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Nde nii Joomiraawo raɓɓinɗinaayno balɗe ɗeen, neɗɗo fuu hisataano. Amma o raɓɓinɗinii ɗe ngam suɓaaɓe makko. ");
INSERT INTO fuh_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Nder wakkati oon, nde nii goɗɗo wi'i on : « Ndaaree *Almasiihu nii ɗo » naa « too'en », to ngoonɗinee joomum. ");
INSERT INTO fuh_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ngam almasiihuuɓe fewreeɓe he annabiiɓe fewreeɓe mbanngowan, ɓe ngaɗa alamaaji e kaayɗe, ngam majjinde baa suɓaaɓe Alla ɓeen, nde nii no waɗoo. ");
INSERT INTO fuh_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ndenne, kakkilee ! Mi haalani on huune fuu illa ɗum waraay. ");
INSERT INTO fuh_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","—Gaɗa saɗɗormaaji nyalaaɗe ɗeen, sey naange niɓɓa, lewru accaa yeynude, ");
INSERT INTO fuh_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","koode caama, Alla waɗa baawɗe gonɗe dow fuu ndimmboo. ");
INSERT INTO fuh_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Wakkati mum, *Ɓii-Neɗɗo no hi'etee, no wara dow duule. Omo warda baawɗe e teddungal manngal. ");
INSERT INTO fuh_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","O lilan maleykaaɓe makko nder kappa kuula duuniyaaru fuu, ɓe kawrowa suɓaaɓe makko illa hoore leydi ndii faa hoore leydi ndiito. ");
INSERT INTO fuh_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Too, ndaaree ibbi kii, ekkitoɗon goɗɗum he makki. Nde nii licce makki keyɗitii, kaakooli makki mbilitii, oɗon anndi ko dunngu ɓadake. ");
INSERT INTO fuh_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Hano non kaden, nde nii on ngi'ii kujje ɗee no ngara, paamee ko wakkati oon ɓadake, *Ɓii-Neɗɗo no dammbugal wuro. ");
INSERT INTO fuh_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Goonga kaalananmi on : Jamaanu oo timmataa tawee kujje ɗee fuu ngaraay. ");
INSERT INTO fuh_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Kammu e leydi taggan, amma haalaaji am timmataa abada. ");
INSERT INTO fuh_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Walaa annduɗo nyalaane ndeen naa wakkati mo ɗum waɗoyta, baa maleykaaɓe wonɓe dow ɓeen, naa Ɓiɗɗo oon anndaa ɗum, sey nii *Baabiraawo oon tan. ");
INSERT INTO fuh_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Kakkilee, tinnee to on ɗaanee ngam on anndaa nde wakkati oon warta. ");
INSERT INTO fuh_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Wakkati oo no wi'ee omo nanndi e gorko gaɗuɗo jahaangal. O acci ɓaade makko nder juuɗe gollooɓe makko. O holli neɗɗo maɓɓe fuu ko hakkiltoo. O wi'i doomoowo dammbugal oon dooma ngal no wooɗiri. ");
INSERT INTO fuh_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ndenne, tinnee heɓa taweɗon on ciryiiɓe, ngam on anndaa wakkati jom ɓaade oon wartoyta. No waawi waɗa o warta futuro naa caka jemma, naa fajiri fadde dontooje jogginde naa illa beete. ");
INSERT INTO fuh_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","To o juhu on, o tawa oɗon ɗaani ! ");
INSERT INTO fuh_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ko kaalananmi on ɗum, kam kaalananmi himɓe fuu : Tinnee to on ɗaanee ! ");
INSERT INTO fuh_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Balɗe ɗiɗi fadde *Juulɗe dimɗinol Isra'ilankooɓe e *Juulɗe buuru mo walaa ƴuufinirɗum, mawɓe *cakkanooɓe Alla e jannginooɓe *Tawreeta no tefa nder cuccukka no nanngirii Iisa, mbara mo. ");
INSERT INTO fuh_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Amma iɓe mbi'odira hakkune maɓɓe : —To en nanngu mo wakkati juulɗe ɗeen, ngam to himɓe murtu. ");
INSERT INTO fuh_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Iisa no Baytaniya nder ɓaade Simon, inndirteeɗo Simon Ceppinnga. Omo jooɗii, omo nyaama, sey debbo gom naati, no jogii faanu nebbam uurɗam, caadiɗam sanne, ɗam hawrodiraaka he huune fuu. Debbo oon heli daane faanu nduun, joorti nebbam ɗaam dow hoore Iisa. ");
INSERT INTO fuh_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Nder himɓe tawaaɓe toon ɓeen, woɓɓe ɓerne mum'en metti, no mbi'odira : —Bonnude iri nebbam ɗaam, ɗume ɗum nafata ? ");
INSERT INTO fuh_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Iɗam waawi sonneede, gollooɓe keme tato njoɓee, naa ceede ɗeen kokkee talkaaɓe ! Ɓe tokki iɓe njanca debbo oon. ");
INSERT INTO fuh_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Sey Iisa wi'i ɓe : —Accee mo ! Ngam ɗume njancoton mo ? Ko o waɗanii kam ɗum no wooɗi sanne. ");
INSERT INTO fuh_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Talkaaɓe no tawdee he mooɗon wakkati fuu, nde muuyɗon fuu oɗon mbaawi waɗande ɓe moƴƴere. Amma miin, mi tawdataake he mooɗon nyannde fuu. ");
INSERT INTO fuh_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","O waɗi ko o waawi. O wuji nebbam uurɗam ɗam he ɓanndu am ngam siryaade mooɓol am. ");
INSERT INTO fuh_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Goonga kaalananmi on : Nokku fuu to *Habaru lobbo oo waajaa nder duuniyaaru, ko debbo oo waɗi ɗum, no filletee, ngam miccitaade he makko. ");
INSERT INTO fuh_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Yahuuda Iskariyot, gooto nder *lilaaɓe sappo e ɗiɗo ɓeen, yehi to mawɓe *cakkanooɓe Alla ngam wattude Iisa nder juuɗe maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ɓe kettinani mo, ɓe nani belɗum, faa ɓe adi alkawal ɓe mbi'i kam'en kokkan mo ceede. Illa wakkati oo, Yahuuda no tefa, no jammborii Iisa. ");
INSERT INTO fuh_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Nyalooma arano *Juulɗe buuru mo walaa ƴuufinirɗum, nyalooma mo ɓe kirsannoo jawɗi ngam *Juulɗe dimɗinol Isra'ilankooɓe, *aahiiɓe Iisa ƴami Iisa, mbi'i : —Toy ngiɗaa min ciryowoo hiraane juulɗe ɗeen ? ");
INSERT INTO fuh_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Iisa lili ɗiɗo nder maɓɓe, wi'i ɓe : —Ummee naatee huɓeere ndee, on pottan gorko gom no ronndi loone ndiyam, tokkon mo. ");
INSERT INTO fuh_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ɓaade nde o naati ndeen, mbi'on joomiire moodibbo lili min, min ƴame toy suudu ndu o nyaamdata he *aahiiɓe makko hiraane juulɗe nduun woni ? ");
INSERT INTO fuh_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Jom ɓaade ndeen hollan on suudu mawnu gom, wonndu no deki dow wonndu. Moƴƴinee ndu, nder mayru ngaɗanton en hiraane ndeen. ");
INSERT INTO fuh_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Sey *aahiiɓe ɗiɗo ɓeen njehi, naatowi huɓeere ndeen. Ɓe ngiiti huune fuu ko Iisa wi'unoo ɓe, ɓe ciryii hiraane ndeen. ");
INSERT INTO fuh_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Futuro, wakkati naange yanunoo, Iisa wardi he *lilaaɓe mum sappo e ɗiɗo ɓeen. ");
INSERT INTO fuh_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Wakkati ɓe kiirtotonoo, Iisa wi'i ɓe : —Goonga kaalananmi on : Hakkune mooɗon, onon nyaamdooɓe he am, gooto nder mooɗon no jammboto kam. ");
INSERT INTO fuh_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ɓe ɓalinii sanne, sey ɓe ƴami mo gooto gooto, ɓe mbi'ii : —Kori hanaa miin non ? ");
INSERT INTO fuh_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Iisa jaabii ɓe, wi'i : —Gooto nder mooɗon, onon sappo e ɗiɗo ɓee, gonɗo no suuwida junngo mum he am nder le'al gootal, oon non. ");
INSERT INTO fuh_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","*Ɓii-Neɗɗo accan duuniyaaru hano no ɗum winndiraa dow makko nder dewte. Amma bone saaman dow jammbotooɗo mo ! Joomum nde nii rimaakano non, nden no ɓuranan ɗum. ");
INSERT INTO fuh_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Wakkati ɓe nyaamannoo ndeen, Iisa hooƴi buuru, yetti Alla, helti mo, hokki ɓe, wi'i : —Njaɓee, ɗum woni ɓanndu am. ");
INSERT INTO fuh_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Gaɗa mum, o hooƴi nyeɗerde cabiijam, o yetti Alla, o hokki ɓe, ɓe fuu ɓe njari. ");
INSERT INTO fuh_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","O wi'i ɓe : —Ɗum woni ƴiiƴam am, ƴiiƴam ndufeteeɗam ngam sabbu himɓe heewɓe, ƴiiƴam tabbintinoojam amaana Alla. ");
INSERT INTO fuh_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Goonga kaalananmi on. Mi yarataa cabiijam kaden, sey nii nder Laamu Alla. ");
INSERT INTO fuh_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Iisa he *aahiiɓe ɓeen njimi jimi *Jabuura, ɓe mburtii, ɓe njehi dow waamnde wi'eteene waamnde Jaytun. ");
INSERT INTO fuh_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Toon Iisa wi'i ɓe : —On fuu, on mboppan kam ndoggon, ngam no winndaa, wi'aa : Mi fiyan duroowo oon, baali ɗiin cankitoo. ");
INSERT INTO fuh_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Amma nde mi ummitake, mi artan on Galili. ");
INSERT INTO fuh_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Sey Piyer itti hunnduko, wi'i mo : —Baa nde nii ɓe fuu ɓe ndoggi ɓe mboppii ma, miin kay, mi woppataa ma. ");
INSERT INTO fuh_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Iisa jaabii mo, wi'i : —Goonga kaalananmaami. Nder jemma oo, fadde ndontoori jogginde kile ɗiɗi, a wi'an a anndaa kam kile tati ! ");
INSERT INTO fuh_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Amma ɗum fuu haɗaay Piyer wi'i mo kaden : —Baa nde a maayan non, mi maaydan he maaɗa, abada mi wi'ataa mi anndaa ma. Non *aahiiɓe ɓeeto duu mbi'i. ");
INSERT INTO fuh_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Iisa he *aahiiɓe mum ngari nokkuure wi'eteene Gesemaane, toon o wi'i ɓe : —Njooɗee ɗo, mi yahan mi du'owo. ");
INSERT INTO fuh_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","O noddi Piyer, Yakuuba e Yahaaya, o yahdi he maɓɓe. Iɓe ɗon nii sey taƴo-taƴo fuɗɗi nanngude mo, ɓillaare naatani mo sanne. ");
INSERT INTO fuh_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Sey o wi'i *aahiiɓe makko : —Bononda ɓerne am ɗuuɗi sanne faa no tefa warude kam. Ndaree ɗo, ndoomee kam, kakkilee to on ɗaanee. ");
INSERT INTO fuh_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","O woɗɗi ɓe seɗɗa, o turni yeeso makko faa he leydi, omo du'oo, omo wi'a : —*Baaba, nde nii tawi iɗum waɗoo, woɗɗinam nyeɗerde torra kaa. ");
INSERT INTO fuh_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Yaa Abba am ! Walaa ko hepporte. Amma to ɗum laatoo muuyɗe am, ɗum laatoo muuyɗe maa aan. ");
INSERT INTO fuh_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Nden o warti, o tawi *aahiiɓe ɓeen no ɗaanii. Sey o wi'i Piyer : —Simon ! Simon ! A ɗaanii naa ? Jaa a waawaa doomude kam baa nii yamnde worre ? ");
INSERT INTO fuh_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ummee, ndu'ee, to on caamu nder cii'aaki. Ɓerne no hiɗi amma ɓanndu tampi. ");
INSERT INTO fuh_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Iisa soƴƴii kaden, du'ii hano no o du'ori arannde nii. ");
INSERT INTO fuh_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","O warti, o tawi iɓe ɗaanii kaden. Ɗoyngol maɓɓe moddi sanne. Ɓe mbaawaa jooɗaade ndoomi, ɓe keppi duu fuu ko ɓe njaabortoo Iisa. ");
INSERT INTO fuh_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Iisa yehi, warti tataɓere mum, o wi'i ɓe kaden : —Faa joonin oɗon ɗaanii, oɗon powta naa ? Too, joonin kay hanti. Wakkati mo *Ɓii-Neɗɗo wattetee nder juuɗe waɗooɓe hakke oon wari. ");
INSERT INTO fuh_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ummee ndillen ! Ndaa, jammbotooɗo kam oon nii, no wara. ");
INSERT INTO fuh_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Iisa no caka haala, sey Yahuuda, gooto nder lilaaɓe makko sappo e ɗiɗo ɓeen, yottii no wondi he himɓe heewɓe. Mawɓe *cakkanooɓe Alla, jannginooɓe *Tawreeta, he mawɓe *Yahudankooɓe gom lili ɓe, iɓe njogii takubaaje he cabbi. ");
INSERT INTO fuh_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Tawi Yahuuda jammbotooɗo mo oon, tinndinnoo ɓe wi'i : —Mo mbunndotoomi oon, kam woni mo. Nanngon mo, njaaron, paddoɗon mo. ");
INSERT INTO fuh_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","No Yahuuda yottorii, fonndi Iisa, wi'i mo : —Moodibbo ! Sey o wunndii mo. ");
INSERT INTO fuh_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Warduɓe he makko, nanngi Iisa. ");
INSERT INTO fuh_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Aahiijo Iisa gom tawaaɗo hadde maɓɓe, sorti takubaahi mum, soppi gollanoowo mawɗo *cakkanooɓe Alla, o taƴi nowru makko. ");
INSERT INTO fuh_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Sey Iisa wi'i ɓe : —Ko waɗi ngarduɗon takubaaje e cabbi faa nanngon kam hano miin woni mawɗo murtuɓe ? ");
INSERT INTO fuh_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Miɗo wondunoo he mooɗon wakkati fuu nder *Juulirde mawne miɗo waajoo. On nanngaay kam, amma tilay ko dewte Alla mbi'i ɗum tabbita. ");
INSERT INTO fuh_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Sey *aahiiɓe ɓeen fuu ndoggi mboppi mo. ");
INSERT INTO fuh_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Jokolle gom no wakkii wudere mum, tokkitii gaɗa koyɗe Iisa. Ɓe tefi ɓe nannga mo, ");
INSERT INTO fuh_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","o woppi wudere makko, o doggi ɓanndu ɓoldu. ");
INSERT INTO fuh_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Nanngunooɓe Iisa ɓeen njaari Iisa to mawɗo *cakkanooɓe Alla fuu. Mawɓe *cakkanooɓe Alla, jannginooɓe *Tawreeta, he mawɓe *Yahudankooɓe gom kawri nokkuure ndeen. ");
INSERT INTO fuh_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Piyer toowti ɓe seɗɗa, tokkitii ɓe naako nder batamaare ɓaade mawɗo *cakkanooɓe Alla oon. Nden kanko duu o wari, o jooɗii hadde doomooɓe ɓaade ɓeen, omo ƴilfoo. ");
INSERT INTO fuh_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Mawɓe *cakkanooɓe Alla he hawriine dawrooɓe no tefa ko peliri Iisa ngam o waree, amma ɓe keɓaay ɗum. ");
INSERT INTO fuh_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Heewɓe no tuuma mo dow fewre, amma haalaaji maɓɓe ngalaa no tokkodira. ");
INSERT INTO fuh_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Nder maɓɓe woɓɓe tuumi mo, mbi'i : ");
INSERT INTO fuh_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Min nani omo wi'a, o liɓan *Juulirde mawne nde himɓe mahiri juuɗe mum'en. Nden nder balɗe tati o nyiɓa juulirde nde junngo fuu mahaay. ");
INSERT INTO fuh_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ɓe potaay baa dow haala ka ɓe mbi'i kaa. ");
INSERT INTO fuh_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Nden mawɗo *cakkanooɓe Alla oon ummii, darii caka jama'aare ndeen, ƴami Iisa wi'i : —No woodi ko njaabotoɗaa dow ko ɓe mbi'i dow maaɗa ɗum naa ? ");
INSERT INTO fuh_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Iisa deƴƴiti, wi'aay baa. Mawɗo *cakkanooɓe Alla oon ƴami mo kaden, wi'i : —Aan woni *Almasiihu, Ɓii-Alla Jom barke naa ? ");
INSERT INTO fuh_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Iisa jaabii mo, wi'i : —Miin non. On ngi'an *Ɓii-Neɗɗo no jooɗii nyaamo Jom baawɗe,no wara dow duule. ");
INSERT INTO fuh_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Sey mawɗo *cakkanooɓe Alla oon ɓerne mum ummii, serki kolte mum, wi'i : —Haala gom no gaɗa kaden ɓurka ka naa ? ");
INSERT INTO fuh_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","On narrii noppi mooɗon ko o bonni innde Alla. Ɗume ngi'uɗon nder huune ndee ? Nden ɓe fuu, ɓe mbi'i omo haani wareede, omo haani wareede. ");
INSERT INTO fuh_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Nder maɓɓe, woɓɓe kaarti tutti dow makko, cuddi yeeso makko, luƴƴii mo, mbi'i mo : —Nde nii a annabiijo, haalan min moy fii ma ! Doomooɓe ɓaade ndeen duu tinni no piya mo. ");
INSERT INTO fuh_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Wakkati Piyer wonnoo nder batamaare ɓaade mawɗo *cakkanooɓe Alla oon, sey gooto nder horɓe ɓaade ndeen yottii. ");
INSERT INTO fuh_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","O hi'i Piyer no ƴilfoo, o ƴeewi Piyer faa wooɗi, o wi'i mo : —Aan duu, aɗa wondunoo Iisa mo Nasaratu. ");
INSERT INTO fuh_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Piyer yeddi, wi'i mo : —Mi anndaa ! Mi faamaay ko kaalataa. No Piyer haaliri haala kaa, sey o ummii, o darowi dammbugal ɓaade ndeen. Wakkati mum da ndontoori joggini. ");
INSERT INTO fuh_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Korɗo oon wurtii, fotti he makko kaden, sey haalani darinooɓe ɗon ɓeen, wi'i ɓe : —Oo duu, no gooto nder maɓɓe ! ");
INSERT INTO fuh_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Piyer yeddi kaden. Ɓooyi seɗɗa gaɗa mum, sey darinooɓe ɗon ɓeen mbi'i mo : —Sikka fuu walaa, nder maɓɓe njeyaɗaa, ngam a ɓii-leydi Galili. ");
INSERT INTO fuh_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Sey Piyer fuɗɗi hunaade. Omo hunoo, omo hutto, omo wi'a : —Mi anndaa gorko mo kaalaton haala mum oo sam ! ");
INSERT INTO fuh_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Wakkati mum da, ndontoori joggini nde ɗiɗaɓere. Sey Piyer miccitii ko Iisa wi'unoo ɗum : « Fadde ndontoori jogginde kile ɗiɗi, a wi'an a anndaa kam kile tati. » Nden Piyer darii yaasin tinni no wulla no wulla. ");
INSERT INTO fuh_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Mawɓe *cakkanooɓe Alla, jannginooɓe *Tawreeta, mawɓe *Yahudankooɓe he tawaaɓe nder hawriine dawrooɓe, kawri illa beete caawodiri. Ɓe kaɓɓi Iisa, ɓe njaari to Pilaatus. ");
INSERT INTO fuh_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Nden Pilaatus ƴami mo, wi'i : —Aan woni laamiiɗo *Yahudankooɓe oon naa ? Iisa jaabii mo, wi'i : —Aan e hoore maa wi'i ka. ");
INSERT INTO fuh_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Sey mawɓe *cakkanooɓe Alla ɓeen tinni no pela Iisa dow kujje keewɗe. ");
INSERT INTO fuh_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilaatus ƴamti Iisa kaden wi'i : —Walaa ko njaabotoɗaa naa ? A nanaay ko ɓe mbi'i dow maaɗa ɗum fuu naa ? ");
INSERT INTO fuh_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Amma Iisa fiirtaay hunnduko, jaabii ɓe. Rafi njaabaaki Iisa kiin haayɗini Pilaatus. ");
INSERT INTO fuh_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","*Juulɗe dimɗinol Isra'ilankooɓe fuu, himɓe no cuɓo kasunke gooto mo yoofantee. ");
INSERT INTO fuh_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","*Juulɗe dimɗinol gom ngari fotodiri, gorko gom bi'eteeɗo Barabas no uddidaa he murtuɓe gom. Murtuɓe ɓee, nder murtol mum'en mbaraana goɗɗo. ");
INSERT INTO fuh_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Nyannde juulɗe ɗee jama'aare wari to Pilaatus, eeli mo o waɗana ɓe ko woowi waɗeede he juulɗe fuu ɗum. Kam woni o yoofana ɓe kasunke gom. ");
INSERT INTO fuh_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Nden o jaabii ɓe, o wi'i : —Oɗon ngiɗi mi yoofana on laamiiɗo *Yahudankooɓe oo naa ? ");
INSERT INTO fuh_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilaatus jaaborake nii ngam no anndi ko haasidaaku waɗi mawɓe *cakkanooɓe Alla ngaddi Iisa to mum. ");
INSERT INTO fuh_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Kamɓe duu tutii jama'aare ndeen wara, eela ɗum kam yoofa Barabas no ɓuri kam yoofa Iisa. ");
INSERT INTO fuh_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilaatus ƴamii ɓe kaden, wi'i : —Ndenne, ɗume ngiɗɗon mi waɗa, mo mbi'oton laamiiɗo *Yahudankooɓe oon nee ? ");
INSERT INTO fuh_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Sey ɓe kuuɓi, ɓe mbi'i : —Tontu mo dow *bardugal ! ");
INSERT INTO fuh_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilaatus ƴami ɓe, wi'i : —Ɗume o waɗi ko foti nii fuu ? Sey ɓe kuuɓi sanne ɓe mbi'i : —Tontu mo dow *bardugal ! ");
INSERT INTO fuh_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilaatus yoofi Barabas ngam welnude ɓerne jama'aare ndeen. O hokki laawol Iisa ɓoccee, tontowee dow *leggal bardugal. ");
INSERT INTO fuh_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Soogeeji ɗiin njaari Iisa nder batamaare ɓaade Pilaatus, ɓe kawri soogeeji ɗiin fuu. ");
INSERT INTO fuh_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ɓe ɓornii Iisa alkubbaare woɗeere gom. Ɓe canyi taarde gi'e, ɓe kippi dow hoore makko. ");
INSERT INTO fuh_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ɓe puɗɗi salminde he makko, iɓe mbi'a : —Alla sabbinane, laamiiɗo *Yahudankooɓe. ");
INSERT INTO fuh_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ɓe piiri mo loocol dow hoore, ɓe kaarti ɓe tutti dow makko. Ɓe kofi yeeso makko, iɓe cujidana mo. ");
INSERT INTO fuh_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Wakkati ɓe njawinoo mo faa heƴi ɓe, ɓe itti alkubbaare ndeen, ɓe ɓornii mo kolte makko. Ɓe njaari mo yaasin faa ɓe tontowa mo. ");
INSERT INTO fuh_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Simon, baaba Skandaaru e Rufus, gorko jeyaaɗo Sirene, no wara no ƴuwa gese sey fotti Iisa he soogeeji ɗiin. Soogeeji ɗiin tilsini mo o wakkoo *leggal bardugal Iisa ngaal. ");
INSERT INTO fuh_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ɓe njaari Iisa nokkuure wi'eteene Golgota. Maana Golgota woni « nokkuure laalagal hoore ». ");
INSERT INTO fuh_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ɓe kokki Iisa cabiijam kawrodiriɗam he ɗakke kaaɗɗe gom ngam o yara, amma o salii. ");
INSERT INTO fuh_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","25","Yamde jeenay subaka, ɓe tonti Iisa dow leggal ngaal. Ɓe piyi kolte makko caaca, ngam ɓe ndaara moy heɓata ɗe. ");
INSERT INTO fuh_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","« Laamiiɗo *Yahudankooɓe » winndaa dow alluwal, ɓe takki ngal dow timtude hoore makko. Ɗum woni sabaabu mo waɗi o tontaa. ");
INSERT INTO fuh_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ɓe tontidi mo he wuyɓe ɗiɗo gom, oo nyaamo makko, ooto nano makko.  ");
INSERT INTO fuh_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ɗum tabbintini ko dewte mbi'ii : O fiyetee sawru bonɓe. ");
INSERT INTO fuh_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Yawtooɓe har toon ɓeen no njenna mo, no njinnga ko'e mum'en, no mbi'a : —Hey ! Liɓowel *Juulirde mawne, dey nyiɓitoo nde nder balɗe tati, ");
INSERT INTO fuh_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","dannu hoore maa. Jippa dow *leggal bardugal ngaal ! ");
INSERT INTO fuh_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Noon duu, mawɓe *cakkanooɓe Alla e jannginooɓe *Tawreeta tinni no njaltinoo mo hakkune mum'en, no mbi'a : —O dannii woɓɓe, dey o waawaa dannude hoore makko ! ");
INSERT INTO fuh_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","*Almasiihu, Laamiiɗo *Isra'el jippoo dow *leggal bardugal ngal joonin joonin. Nde nii en ngi'ii ɗum, en ngoonɗinan mo ! Himɓe ɗiɗo tontidaaɓe he makko ɓeen duu no njenna mo. ");
INSERT INTO fuh_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Nyannde Iisa tontanoo ndeen, caka nyalooma, nimre huuri leydi ndiin fuu faa ɗum waɗi jamɗe tati. ");
INSERT INTO fuh_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Har yamnde tati juura, Iisa fii wullaanu mawnu, wi'i : —Eli, Eli, lema sabaktani ? Kam woni : Yaa Alla am ! Yaa Alla am ! Ɗume waɗi ko mboppuɗaa kam ? ");
INSERT INTO fuh_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Wakkati darinooɓe toon ɓeen nanunoo ɗum, woɓɓe nder maɓɓe mbi'i : —Kettinee, omo nii omo nodda Eliya ! ");
INSERT INTO fuh_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Nden gooto nder maɓɓe doggi, suuwowi tekkere nder ndiyam lammuɗam, haɓɓi he loocol, waddi nde hadde hunnduko Iisa ngam Iisa siiɓoo ɗam. Nden o wi'i : —Accee, ndaaren tawte Eliya no waran jippina mo ! ");
INSERT INTO fuh_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Iisa fii wullaanu mawnu kaden, sey o foofi foofaango makko sakitiingo. ");
INSERT INTO fuh_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Riido palaaɗo nder *Juulirde mawne oon serki illa dow faa ley, laatii pecce ɗiɗi. ");
INSERT INTO fuh_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Hooreejo soogeeji *Rooma darinooɗo yeeso Iisa oon hi'i no Iisa acciri duuniyaaru. Nden o wi'i : —Sikka fuu walaa, neɗɗo oo no *Ɓii-Alla ! ");
INSERT INTO fuh_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Rewɓe gom toowti ɗon seɗɗa, ndarii no ndaara. Nder maɓɓe no tawa : Mariyaama mo Magdaala, Salome he Mariyaama inna Yoses he Yakuuba inndirteeɗo Pamarel. ");
INSERT INTO fuh_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Rewɓe ɓee, tokkunoo Iisa no ngollana mo, wakkati o wonnoo Galili. Rewɓe heewɓe gom duu, yaadunooɓe he makko *Ursaliima no ngonnoo ɗon. ");
INSERT INTO fuh_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Hiiri, fotodiri he jemma *nyalaane fowteteene, himɓe no ciryanoo juulɗe ɗeen. ");
INSERT INTO fuh_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Sey Yusufu mo Arimatiya, tawaaɗo nder hawriine dawrooɓe, neɗɗo non kettinanteeɗo sanne nder mayre, keɗiiɗo banngol Laamu Alla. O hulaay fuu yahde to Pilaatus ngam ŋaaraade mo ɓanndu Iisa. ");
INSERT INTO fuh_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Wakkati Pilaatus nanunoo ko Iisa ɓooyaay dow *bardugal ngal ko maayi, ɗum haaynii mo. Nden o noddi mawɗo soogeeji *Rooma, o ƴami ɗum se goonga fuu Iisa maayi. ");
INSERT INTO fuh_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Wakkati mawɗo soogeeji ɗiin haalannoo mo ɗum, o hokki Yusufu laawol hooƴa ɓanndu Iisa. ");
INSERT INTO fuh_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yusufu soodi kasanke, jippini ɓanndu Iisa, waɗi ndu kasanke. O watti mo nder annyeere seɓaane nder tepaare. Gaɗa mum, o waɗi kaaƴa mannga gom tallitaa, dammbugal annyeere ndeen uddaa. ");
INSERT INTO fuh_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mariyaama mo Magdaala e Mariyaama inna Yoses ngi'ii to Iisa wattaa. ");
INSERT INTO fuh_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","*Nyalaane fowteteene ndeen wari, yawti. Mariyaama mo Magdaala, Salome he Mariyaama inna Yakuuba, coodi uurdiiji faa mbuja ɓanndu Iisa. ");
INSERT INTO fuh_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","3","Dow laawol fadde maɓɓe yottaade, iɓe ƴamodira, iɓe mbi'a : —Moy tallitanta en kaaƴa ngonnga dammbugal annyeere ndeen ? Rewɓe ɓee ngari to annyeere ndeen, alal illa beete. ");
INSERT INTO fuh_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Amma wakkati ɓe njottinoo, ɓe ngi'ii kaaƴa ngaan tallitaama. ");
INSERT INTO fuh_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Wakkati ɓe naatunoo nder annyeere ndeen, sey ɓe ngi'i har nyaamo maɓɓe, jokolle gom no jooɗii, no ɓornii kolte daneeje, sey ɓe kuli. ");
INSERT INTO fuh_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Jokolle oon itti hunnduko wi'i ɓe : —To kulee ! Iisa mo Nasaratu tontanooɗo oon, tefoton. O ummitake, o walaa ɗo. Ndaa nokku to o wattanoo ɗon nii. ");
INSERT INTO fuh_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Joonin sey njehon, mbi'owon Piyer he *aahiiɓe makko ɓeeto ko o artan ɓe Galili. Toon ngi'oyton mo hano no o wi'irnoo on ɗum. ");
INSERT INTO fuh_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Rewɓe ɓeen ndoggi, mburtii, no ndiwna, ɗum wemmbii ɓe sanne. Ɓe kuli sanne faa ɓe keppi haalande ɗum neɗɗo fuu.  ");
INSERT INTO fuh_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Alal, illa subaka wakkati Iisa ummitii, Mariyaama mo Magdaala, mo o riiwunoo ginnaaji jeɗɗi dow mum, kam o arti wanngande. ");
INSERT INTO fuh_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Mariyaama yehi haalanowi wondunooɓe he Iisa ɓeen, o tawi iɓe ɓalinii, iɓe mboya. ");
INSERT INTO fuh_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Amma baa ko Mariyaama wi'i ɓe he hoore mum hi'i mo, ɓe ngoonɗinaay ummitaaki Iisa kiin. ");
INSERT INTO fuh_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Gaɗa Iisa wanngani Mariyaama, *aahiiɓe Iisa ɗiɗo gom no pa'i nguroy gom, kamɓe duu o wannganii ɓe nder nanndi gom. ");
INSERT INTO fuh_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ɓe ngarti ɓe kaalani *aahiiɓe ɓeeto, amma *aahiiɓe ɓeen ngoonɗinaay haala maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ko sakitii, o wanngani *aahiiɓe makko sappo e go'o ɓeen, wakkati ɓe nyaamannoo. O nanaay belɗum rafi goonɗinol e njorki ɓerɗe maɓɓe. O duki ɓe duu ngam ɓe ngoonɗinaay warɓe mbi'i kam'en ngi'ii mo, o ummitake. ");
INSERT INTO fuh_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Nden o wi'i ɓe : —Njehee, mbaajee himɓe dow *Habaru lobbo oo nder kappa kuula duuniyaaru fuu. ");
INSERT INTO fuh_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Neɗɗo fuu goonɗini, waɗana *batisma, joomum no hisintee. Amma neɗɗo fuu mo goonɗinaay no hiitetee. ");
INSERT INTO fuh_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Alamaaji kaayɗiniiɗi gi'eteeɗi he goonɗinɓe nii : Ɓe ndiiwan ginnaaji bonɗi dow innde am. Ɓe ndu'oto nder ɗemle feere feereeje ɗe ɓe meeɗaay haalude. ");
INSERT INTO fuh_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ɓe nanngiran juuɗe maɓɓe bolle. Baa nii ɓe njari tooke, ɗum waɗantaa ɓe huune fuu. Ɓe njowan juuɗe maɓɓe dow nyawɓe, nyawɓe ɓeen nyawtaa. ");
INSERT INTO fuh_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Iisa Joomiraawo meeɗen haalani *aahiiɓe mum kujje ɗee fuu, nden o ƴencinaa dow. O yehi o jooɗowi nyaamo Alla. ");
INSERT INTO fuh_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","*Aahiiɓe makko ɓeen duu cankiti nder duuniyaaru, no mbaajoo nokku fuu. Joomiraawo wondi he maɓɓe, o hokki ɓe baawɗe waɗude kaayɗe ngam tabbintinde ko ɓe mbi'ata fuu to makko ɗum ƴuwi.");
INSERT INTO fuh_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Yaa Tawfilus tedduɗo, himɓe ɗuɓɓe puɗɗi winndude habaru dow ko Iisa waɗi hakkune meeɗen. ");
INSERT INTO fuh_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Habaru mo ɓe mbinndi oo duu, ƴuwaana he kunndule aranɓe seedoriiɓe gite mum'en ko Iisa waɗi. Kamɓe duu laatii halfinaaɓe golle anndinde himɓe haala Alla. ");
INSERT INTO fuh_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Miin duu, mi tewtirii hakkillo am kujje ɗeen fuu ngam mi winnda ɗe dey-dey no ɗe ngaɗiraa. ");
INSERT INTO fuh_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Mi winndanii ma habaru oo ngam tabbintina goongaaku ekkintinol ngol keɓuɗaa. ");
INSERT INTO fuh_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Nder laamu *Hirudus, laamiiɗo leydi Yahudiya, no woodunoo *cakkanoowo Alla gom bi'eteeɗo Jakariya, jeyaaɗo nder hawriine *cakkanooɓe Alla wi'eteene Abiya. Dee-Jakariya no wi'ee Elisabet, o ƴuwi he lenyol Haaruuna. ");
INSERT INTO fuh_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Jakariya e deekum fuu no dartiiɓe yeeso Alla, feloore fuu walaa he maɓɓe. Ɓe tokkuɓe tilsinooje Joomiraawo e farillaaji mum duu. ");
INSERT INTO fuh_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ɓe keɓaay ɓeyŋu, ngam Elisabet no dimaro, ɓe fuu ɗiɗo duu, ɓe naywi. ");
INSERT INTO fuh_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Nder tawaangal *cakkanooɓe Alla, *cakkanoowo Alla gom suɓetee, naata nder *Juulirde mawne ngam waɗude sadakaaji gaɗanteeɗi Alla. Nyannde gom, kuɗel Jakariya suɓaa ngam o naata nder *Juulirde mawne, o wula uurdi nder mayre. ");
INSERT INTO fuh_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Wakkati uurdi ndiin wuletee, jama'aare ndeen fuu darii yaasin no du'oo. ");
INSERT INTO fuh_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Sey maleykaajo Joomiraawo gom wanngani mo, no darii nyaamo urorde ndeen. ");
INSERT INTO fuh_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Wakkati Jakariya hi'unoo maleykaajo oon, hakkillo makko ummii, kulol nanngi mo. ");
INSERT INTO fuh_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Amma maleykaajo oon wi'i mo : —Jakariya, taa hulu, ngam du'aa'u maaɗa jaabaama. Elisabet, jom suudu maa, no rimante ɓiɗɗo gorko, inndiraa mo Yahaaya. ");
INSERT INTO fuh_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Suka dimaaɗo oo no waddante welwelo manngo. Himɓe ɗuɓɓe nanan belɗum dimeeki makko. ");
INSERT INTO fuh_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","O laatoto neɗɗo mawɗo yeeso Joomiraawo. O yarataa cabiijam e ko soptinta hoore fuu. O heewan *Ruuhu Ceniiɗo illa nder reedu inniiko. ");
INSERT INTO fuh_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","O wartiran ɓiɓɓe *Isra'el ɗuɓɓe to Alla Joomiraawo mo ɓe ndewata. ");
INSERT INTO fuh_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","O artan *Almasiihu warde. Nder ir baawɗe Ruuhu Alla ɗe annabi Eliya heɓunoo o wartirta ɓerɗe baabiraaɓe har ɓiɓɓe mum'en, hakkillooji murtuɓe har himɓe dartiiɓe. O siryoo lenyi duu ngam garki Joomiraawo. ");
INSERT INTO fuh_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Jakariya ƴami maleykaajo oon, wi'i mo : —Noy anndiranmi ko mbiiɗaa ɗum no goonga ? Ngam miin, mi naywi, deekam duu, duuɓi mum ɗuuɗi. ");
INSERT INTO fuh_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Maleykaajo oon jaabii mo, wi'i : —Miin woni Jibirilla takkiiɗo Alla, lilaaɗo he maaɗa ngam haalane habaru lobbo oo. ");
INSERT INTO fuh_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Joonin a beebeete, a waawtaa yecci sey nyannde ko mbi'umaami ɗum tabbiti, ngam a goonɗinaay. Amma ɗum tabbitowan nde wakkati majjum waɗi. ");
INSERT INTO fuh_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Himɓe no yaasin no ndoomi Jakariya. Ɗum haayɗini ɓe ko o ɓooyi nder *Juulirde mawne ndeen. ");
INSERT INTO fuh_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Wakkati o wurtinoo, o heppi fuu haaldude he maɓɓe. Nden ɓe paami ko o hi'i ko haayɗini gom nder mayre. O beebii, o darii omo tinndina ɓe he juuɗe. ");
INSERT INTO fuh_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Wakkati golle makko kantunoo, o hooti wuro makko. ");
INSERT INTO fuh_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Balɗe seɗɗa gaɗa mum, deekiiko Elisabet saawi, suuɗii lebbi joy, no wi'a : ");
INSERT INTO fuh_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","—Ndaaree ko Joomiraawo waɗani kam. Nder wakkati mo hiɗi, o hi'i yurmeene am, o ittanii kam mone yeeso himɓe. ");
INSERT INTO fuh_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Nder lewru Elisabet jeegaɓuru, Alla lili maleyka Jibirilla Nasaratu nder leydi Galili. ");
INSERT INTO fuh_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","O lili mo he surbaajo nannganaaɗo Yusufu, ƴuwɗo he lenyol Daawda. Surbaajo oo no wi'ee Mariyaama, o anndaa gorko abada. ");
INSERT INTO fuh_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Jibirilla wari to makko, wi'i mo : —Jam woni, aan keɓuɗo moƴƴere ƴuwne to Alla. Joomiraawo no wondi he maaɗa. ");
INSERT INTO fuh_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Haala Jibirilla ummini hakkillo Mariyaama sanne faa omo ƴama omo ƴamtinoo hoore makko maana sannoore ndee. ");
INSERT INTO fuh_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Jibirilla wi'i mo : —Taa hulu, Mariyaama, ngam a heɓii moƴƴere ƴuwne to Alla. ");
INSERT INTO fuh_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ndaa, a saawan, ndimaa ɓiɗɗo gorko, inndiraa mo Iisa. ");
INSERT INTO fuh_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","O laatoto mawɗo, o noddirtee *Ɓii-Alla Toowɗo. Alla Joomiraawo hokkan mo laamu maamiiko Daawda. ");
INSERT INTO fuh_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","O laamoto dow lenyol Yakuuba faa abada abadin, laamu makko duu walaa keerol. ");
INSERT INTO fuh_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mariyaama ƴami maleyka Jibirilla, wi'i : —Noy ɗum laatortoo, miin mo anndaa gorko sam ? ");
INSERT INTO fuh_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Jibirilla jaabii mo, wi'i : —*Ruuhu Ceniiɗo no jippoto dow maaɗa, baawɗe Alla Toowɗo no huurete. Ngam majjum, ɓiɗɗo ceniiɗo mo ndimataa oon no noddirtee *Ɓii-Alla. ");
INSERT INTO fuh_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ndaa Elisabet, sakiike maa duu saawi. Baa ko o naywi, o riman ɓiɗɗo gorko. Kanko mo himɓe mbi'annoo no dimaro, jooni omo nder lewru makko jeegaɓuru, ");
INSERT INTO fuh_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","ngam walaa fuu ko hepporta Alla. ");
INSERT INTO fuh_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mariyaama jaabii mo, wi'i : —Ndaa, mi korɗo Joomiraawo. Ɗum waɗa he am hano no mbi'irɗaa. Nden maleykaajo oon dilli. ");
INSERT INTO fuh_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Nder balɗe Jibirilla haaldunoo he Mariyaama, nyannde gom Mariyaama ummii dow ko yaawi yehi nder wuro leydi Yahudiya gom tawaango nder baamle. ");
INSERT INTO fuh_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Wakkati o yottinoo, o naati nder hoggo Jakariya, o sanni Elisabet. ");
INSERT INTO fuh_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Wakkati Elisabet nanunoo sannoore Mariyaama ndeen, ɓiyiiko dimmbi nder reedu makko. Elisabet hebbinaa *Ruuhu Ceniiɗo, ");
INSERT INTO fuh_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","o huuɓi daane mawne, o wi'i : —A barkinaaɗo ɓurɗo rewɓe fuu, ɓiɗɗo gonɗo nder reedu maa duu no barkinaaɗo ! ");
INSERT INTO fuh_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Noy potumi, faa inna Joomiraawo am wara to am ? ");
INSERT INTO fuh_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ndaa, wakkati sannoore maa toɓɓinoo nder nowru am, ɓiɗɗo gonɗo nder reedu am dimmborake welwelo. ");
INSERT INTO fuh_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","A belɗo hoore, aan goonɗinɗo kumnol ko Joomiraawo wi'unoo ma ! ");
INSERT INTO fuh_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mariyaama wi'i : —Yonki am no teddina Joomiraawo, ");
INSERT INTO fuh_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ɓerne am duu heewi welwelo Alla Kisinoowo kam, ");
INSERT INTO fuh_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ngam o jaɓi daarude kam, miin korɗo makko leesuɗo. Illa jooni, jamanuuji fuu no noddiran kam belɗo hoore. ");
INSERT INTO fuh_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Ngam Jom baawɗe waɗanii kam kujje mawɗe ! Innde makko no seniine. ");
INSERT INTO fuh_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Yurmeene makko no faa abada dow hulooɓe mo fuu nder jamanuuji fuu. ");
INSERT INTO fuh_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","O waɗi kujje mawɗe he junngo makko semmbiɗingo, o sankitii ɓe ɓerɗe mum'en keewiri mawnitaare. ");
INSERT INTO fuh_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","O jippinii laamiiɓe dow laamu mum'en, leesuɓe duu, o ɓanti ɗum'en. ");
INSERT INTO fuh_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","O harni rafaaɓe kujje lobbe, riikuɓe duu, o soƴƴi ɗum'en juuɗe ɓole. ");
INSERT INTO fuh_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","O walli lenyol *Isra'el, lenyol tawaangol nder golle makko. O yeggitaay alkawal ngal o waɗannoo maamiraaɓe himɓe Isra'el, Ibrahim e jippotooɓe he mum faa abada. ");
INSERT INTO fuh_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mariyaama jooɗodii he Elisabet ko waɗata lebbi tati, nden gaɗa mum o hooti. ");
INSERT INTO fuh_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Wakkati lebbi Elisabet kuuɓunoo, o rimi ɓiɗɗo gorko. ");
INSERT INTO fuh_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Wondiraaɓe makko e koreeji makko fuu nani moƴƴere mawne ndee nde Joomiraawo waɗani mo. Nden ɓe kawri ɓe mbelbeltidi he makko. ");
INSERT INTO fuh_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Wakkati cukalel ngel waɗunoo balɗe jeɗɗi, himɓe ngari juulnol maggel. Ɓe ngiɗiino wattande ngel Jakariya, ");
INSERT INTO fuh_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","amma inniigel jaabii ɓe, wi'i : —Aa'a, ngel wattee Yahaaya. ");
INSERT INTO fuh_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Nden ɓe njaabii Elisabet, ɓe mbi'i : —Nder lenyol maa fuu, walaa inndiraaɗo ir innde ndee. ");
INSERT INTO fuh_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ɓe ƴami baabiigel nder beebeere, noy o hiɗi ngel wattanee. ");
INSERT INTO fuh_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","O wi'i kam hokkee alluwal. O hokkaa ngal nden o winndi dow maggal o wi'i : —Ngel wattanee Yahaaya. Ɗum haayɗini himɓe fuu. ");
INSERT INTO fuh_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Wakkati Jakariya wi'unoo ngel wattanee Yahaaya, wakkati mum da, hunnduko makko fiirtii, ɗemngal makko yoofaa, o fuɗɗi omo haala, omo teddina Alla. ");
INSERT INTO fuh_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Kulal nanngi tawaaɓe seraaji makko fuu. Habaru oon sankitii nder wurooji tawaaɗi nder baamle Yahudiya fuu. ");
INSERT INTO fuh_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Nanuɗo habaru oo fuu jogii mo nder ɓerne mum, tinni no ƴama hoore mum no wi'a : « Ɗume cukalel ngel laatoytoo nde ngel mawni ? » Ngam nde goonga junngo Joomiraawo no wondi he maggel. ");
INSERT INTO fuh_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Jakariya, baaba cukalel ngel heewnaa *Ruuhu Ceniiɗo, nden waɗi annabaaku, wi'i : ");
INSERT INTO fuh_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","—Teddungal laatanoo Joomiraawo, Alla *Isra'el, ngam o walli himɓe makko, o soptini ɓe. ");
INSERT INTO fuh_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","O lildani en Kisinoowo jom semmbe, jippotooɗo he golloowo makko Daawda. ");
INSERT INTO fuh_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ɗum duu woni ko o haalunoo illa arannde har kunndule annabiiɓe makko seniiɓe. ");
INSERT INTO fuh_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","O wi'i o hisinan en honnooɓe en, o soptinan en he juuɗe wayɓe men fuu. ");
INSERT INTO fuh_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","O holli maamiraaɓe men yurmeene o jogake amaana makko ceniiɗo, ");
INSERT INTO fuh_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","amaana mo o hunaninoo maamii'en *Ibrahim. ");
INSERT INTO fuh_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","O soptinan en he juuɗe wayɓe men. Yeeso makko, ndeewen mo nder senaare e dartinaaku keddi balɗe men, kulal fuu tawataake nder ɓerɗe meeɗen. ");
INSERT INTO fuh_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Aan duu, ɓinngel am, a noddirtee annabiijo Alla Toowɗo, ngam a ardoto Joomiraawo moƴƴinana mo laawol makko. ");
INSERT INTO fuh_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Anndinaa himɓe makko laawol kisinam ngam hakkeeji maɓɓe no njaafetee. ");
INSERT INTO fuh_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Alla meeɗen no keewɗo yurmeene mawne, ngam yurmeene makko, o lildowan en jeyngol makko manngol diga dow, ");
INSERT INTO fuh_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ngam ngol yaynana tawaaɓe nder nimre e wonɓe nder ɗowdi maayde, ngol ɗowa en dow laawol jam. ");
INSERT INTO fuh_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Yahaaya no mawna, hakkillo mum no ɓeydoo. O hoɗowi nder ladde yeeruure naako wakkati mo o wanngintee yeeso himɓe *Isra'el oon yottii. ");
INSERT INTO fuh_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Nder balɗe dimeeki Yahaaya gaɗoowo *batisma, Ogustus mawɗo laamiiɓe leydi *Rooma, tilsini jooɗiiɓe nder laamu *Rooma fuu limee. ");
INSERT INTO fuh_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Limngal ngaal duu woni limngal aranal gaɗaangal wakkati Kiriniyus wonnoo guferner leydi Siriya. ");
INSERT INTO fuh_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Neɗɗo fuu yehi nder wuro mum'en ngam limee. ");
INSERT INTO fuh_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Yusufu duu ngam ƴuwi he lenyol Daawda ummii Nasaratu nder leydi Galili, he Mariyaama ƴamaaɗo mum, pa'i Baytilaama nder leydi Yahudiya ngam limoyde ko'e mum'en. Jahaangal maɓɓe ngaal duu fotodiri Mariyaama no caawɗo. ");
INSERT INTO fuh_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Wakkati ɓe njottinoo Baytilaama, ŋatawere nanngi mo. ");
INSERT INTO fuh_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ɓe keɓaay nokku nder suudu nannganaadu weerɓe nduun. Nden ɓe cori ley mayru, toon to dabbaaji kaɓɓetee ɓe njippi. Ɗon o rimi afo makko, o soomi nder wudere lobbere, o fukkini nder akala. ");
INSERT INTO fuh_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Nder jemma mo Iisa rimetee, durooɓe gom ngari no coggina dabbaaji mum'en nder seraaji Baytilaama. ");
INSERT INTO fuh_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Maleykaajo Joomiraawo gom wanngani ɓe, teddungal Joomiraawo yayni ɓe, sey kulal manngal nanngi ɓe. ");
INSERT INTO fuh_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Nden Maleykaajo oon wi'i ɓe : —To kulee, ngam mi waddani on habaru lobbo. Habaru laatantooɗo himɓe fuu welwelo manngo. ");
INSERT INTO fuh_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Hannden nder wuro Daawda on ndimanaama Kisinoowo, kanko woni *Almasiihu, Joomiraawo. ");
INSERT INTO fuh_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ndaaree, ɗum woni alaama mo kokkeɗon : On tawan cukalel keccel no soomaa nder wudere lobbere, no fukkinaa nder akala. ");
INSERT INTO fuh_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Wakkati mum da maleykaaɓe ɗuɓɓe gom duu, ƴuwi dow, ngari, tawi maleykaajo arano oon, nden ɓe fuu ɓe tinni iɓe njetta Alla, iɓe mbi'a : ");
INSERT INTO fuh_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","—Teddungal laatanoo Alla toon dow, jam laatoo dow leydi ngam horsuɓe e makko. ");
INSERT INTO fuh_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Wakkati maleykaaɓe ɓeen ƴeenyunoo dow kammu, sey durooɓe ɓeen mbi'odiri : —En njaha Baytilaama, ndaarowen ko waɗi, ko Joomiraawo anndini en ɗum. ");
INSERT INTO fuh_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Nden ɓe njaawɗi, ɓe njehi, ɓe tawi Mariyaama, Yusufu he cukalel keccel ngeel, ingel fukkinaa nder akala. ");
INSERT INTO fuh_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Wakkati ɓe ngi'unoo cukalel ngeel, ɓe pillii ko maleykaajo oon haalannoo ɓe fuu dow maggel. ");
INSERT INTO fuh_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Nanuɓe ko durooɓe ɓeen mbi'unoo fuu ɗum haayɗini ɗum'en sanne. ");
INSERT INTO fuh_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mariyaama kam duu jogii ko ɓe mbi'i ɗum nder ɓerne mum, tinni no miiloo dow majjum. ");
INSERT INTO fuh_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Durooɓe ɓeen coƴƴiti, no teddina Alla, no njetta mo, ngam ko ɓe nani e ko ɓe ngi'ii ɗum, waɗiri dey-dey no maleykaajo oon wi'irnoo ɓe. ");
INSERT INTO fuh_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Balɗe jeɗɗi gaɗa dimeeki cukalel ngeel, ngel juulnaa, ngel wattanaa Iisa. Innde ndee woni innde nde maleykaajo oon haalannoo Mariyaama illa saawaaynoo reedu maggel. ");
INSERT INTO fuh_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Wakkati balɗe lamnol Mariyaama kuuɓunoo, hano no *Tawreeta Muusa tilsiniri ɗum, Yusufu e Mariyaama njaari Iisa *Ursaliima ngam halfinde mo Joomiraawo. ");
INSERT INTO fuh_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ngam ɗum woni ko Joomiraawo wi'i nder *Tawreeta : Ɓiɗɗo, gorko afo fuu no cuɓanaaɗo Joomiraawo. ");
INSERT INTO fuh_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ɓe ngari sakkude buugaali ɗiɗi naa tantabalaaji pamari ɗiɗi hano no ɗum woni iɗum winndiraa nder *Tawreeta nii. ");
INSERT INTO fuh_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Simeyon, gorko dartiiɗo, tokkuɗo Alla he ɓerne worre, no wonnoo nder wuro *Ursaliima. Omo heɗi wakkati gonɗi *Isra'el moytetee. *Ruuhu Ceniiɗo no wondi he makko. ");
INSERT INTO fuh_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ruuhu oo wannginani mo ko o maayataa o hi'aay *Almasiihu Joomiraawo. ");
INSERT INTO fuh_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Nyannde Yusufu e Mariyaama ngaddunoo Iisa faa ngaɗana mo ko *Tawreeta tilsini, nyannde mum *Ruuhu oon ɗowi Simeyon faa nder *Juulirde mawne. ");
INSERT INTO fuh_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Nden Simeyon adi Iisa temmbi mo, yetti Alla, wi'i : ");
INSERT INTO fuh_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","—Joonin Joomam, accu miin, maccuɗo maa, mi maaya he jam, ngam a jogake haala maa. ");
INSERT INTO fuh_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Mi hi'iri gite am kisinam maaɗa, ");
INSERT INTO fuh_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","kisinam ɗam ciryiɗaa ngam himɓe fuu, ");
INSERT INTO fuh_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","jeyngol bannginaangol ngam lenyi duuniyaaru fuu, jeyngol teddinoowol *Isra'el, lenyol maa. ");
INSERT INTO fuh_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ko haalaa dow cukalel ngeel haayɗini inniigel e baabiigel. ");
INSERT INTO fuh_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeyon barkini ɓe, wi'i inniigel Mariyaama : —Cukalel ngeel, ngel giɗaangel, ngel wari liɓude ɗuɓɓe e umminde ɗuɓɓe nder *Isra'el. Ngel laatoto alaama Alla mo himɓe caloto. ");
INSERT INTO fuh_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ngel wannginan miilooji ɓerɗe himɓe ɗuɓɓe gonɗi no cuuɗi. Aan duu, Mariyaama, naawɗum yuwan ɓerne maa hano no takubaahi yuwirta goɗɗum. ");
INSERT INTO fuh_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Nder wakkati juulnol cukalel ngel nii no woodunoo annabiijo debbo gom bi'eteeɗo Anna, ɓii-Fanu'el, jeyaaɗo he lenyol Asiira. Debbo oo nii naywi sanne. O haɓɓanaama illa omo surbaajo. Duuɓi jeɗɗi gaɗa dewngal makko, goriiko maayi. ");
INSERT INTO fuh_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","O jooɗii o walaa goriiyo faa o naywi, duuɓi makko duu no ngaɗa lasooji-nay e nay (84). O faddaaki koyngal makko abada he *Juulirde mawne. Omo teddina Alla, omo suumoo. Omo du'oo jemma e nyalooma. ");
INSERT INTO fuh_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Nder wakkati mum, kanko duu o wari, omo yetta Alla. Omo haalana heɗiiɓe coptinol *Ursaliima fuu, habaru cukalel ngeel. ");
INSERT INTO fuh_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Wakkati saarooɓe Iisa kumnunoo ko Joomiraawo wi'unoo nder *Tawreeta fuu, ɓe coƴƴi Nasaratu. ");
INSERT INTO fuh_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Cukalel ngeel no mawna no semmbiɗa. Ingel heewaa hakkillo, moƴƴere Alla duu no wondi he maggel. ");
INSERT INTO fuh_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Hitaane fuu he *Juulɗe dimɗinol Isra'ilankooɓe, saarooɓe Iisa no njeha *Ursaliima. ");
INSERT INTO fuh_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Wakkati Iisa wannoo duuɓi sappo e ɗiɗi, ɓe njehi *Ursaliima hano no ɓe mboowrunoo, ɓe njaari Iisa gaɗa maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","44","Ko juulɗe ɗeen timmi, ɓe nanngi laawol wuro. Ɓe miili omo wondi yaadiraaɓe maɓɓe. Jaa ɓe anndaa Iisa no *Ursaliima. Ɓe ngaɗi yaadu nyalooma muɓɓo, nden ɓe puɗɗi iɓe tefa mo hakkune koreeji maɓɓe e anndaaɓe maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Amma ɓe ngiitaay mo. Nden ɓe coƴƴi *Ursaliima ngam tefude mo. ");
INSERT INTO fuh_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Balɗe tati gaɗa mum, ɓe ngiiti mo nder *Juulirde mawne. Omo jooɗii hakkune jannginooɓe *Tawreeta, omo hettinanii ɓe, omo waɗana ɓe ƴamɗe. ");
INSERT INTO fuh_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Nanuɓe ƴamɗe makko, faamo makko e njaabaaki fuu makko ɗum haayɗini ɗum'en. ");
INSERT INTO fuh_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Wakkati saarooɓe makko ngi'unoo mo hakkune jannginooɓe *Tawreeta ɓee, ɗum haayɗini ɓe sanne. Sey inniiko wi'i mo : —Iisa am, no waɗi ko ngaɗɗaa min huune ndee ? Miin e bammaa, hakkillooji amin fuu ummake sanne. Min tinni miɗen tefe. ");
INSERT INTO fuh_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Nden Iisa jaabii ɓe, wi'i : —Ɗume tefanton kam ? On anndaa ko no tilsi mi hinnoo golleeji *Baaba am naa ? ");
INSERT INTO fuh_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Amma saarooɓe ɓeen paamaay haalaaji makko ɗii. ");
INSERT INTO fuh_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Nden o tokki ɓe, ɓe kooti Nasaratu. Omo ɗowtanoo ɓe. Inniiko jogii kujje ɗee fuu nder ɓerne mum. ");
INSERT INTO fuh_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Iisa no mawna, hakkillo mum no ɓeydoo. Omo weli Alla e himɓe fuu. ");
INSERT INTO fuh_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Haala Alla warani Yahaaya, ɓii-Jakariya nder ladde yeeruure. Nder wakkati mum Tiberiya laamiiɗo *Rooma mawɗo no woodi duuɓi sappo e joy dow laamu. Pontiyus Pilaatus hawji leydi Yahudiya. *Hirudus no guferner leydi Galili. Filipa mawnu Hirudus no laamii leydi Ituriya e leydi Tarakonitis. Lisaniyas no laamii leydi Abilene. Annas e Kayafas kam'en ngoni mawɓe *cakkanooɓe Alla fuu. ");
INSERT INTO fuh_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ko nii waɗi haala Alla ka wanngi yahde he makko, sey Yahaaya ummii yehi nder leyɗe tawaaɗe hadde maayo Urdun. Omo nodda himɓe tuuba ngam hakkeeji maɓɓe njaafee, ɓe njaɓa ngaɗanee *batisma ");
INSERT INTO fuh_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","hano no ɗum winndiraa nder dewtere annabi *Esaaya wi'aa : Daane no huuɓa nder ladde yeeruure no wi'a : Ciryee laabi ɗi Joomiraawo tokkata, moƴƴinee ɗi ngam garki makko. ");
INSERT INTO fuh_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Naɗɗere fuu hebbinee, waamnde e ƴolde fuu leynee, guurti oonyiiɗi ndartinee, laabi bonuɗi moƴƴinee. ");
INSERT INTO fuh_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Neɗɗo fuu hi'an kisinam Alla. ");
INSERT INTO fuh_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Himɓe ɗuɓɓe ngari to Yahaaya ngam o waɗana ɓe *batisma. Nden o wi'i ɓe : —Onon ɓiɓɓe bolle ! Moy wi'i ndogganon tikkere Alla waroore ? ");
INSERT INTO fuh_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ngaɗee ko hollata on tuubii. Nde on mbi'i nder ɓerɗe mooɗon on jippotooɓe he *Ibrahim, miin mi wi'an on : Alla no waawi wayli kaaƴe ɗee, ɗe laatoo taaniraaɓe *Ibrahim. ");
INSERT INTO fuh_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Joonin jammbere aagaama ngam soppude ɗaɗi leɗɗe. Ndenne, lekki fuu ki rimataa ɓiɓɓe lobbe, no soppetee, faɗɗee nder hiite. ");
INSERT INTO fuh_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Himɓe ɗuɓɓe ƴami mo, mbi'i : —Ndenne, ɗume min kaani waɗude ? ");
INSERT INTO fuh_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Nden o jaabii ɓe, o wi'i : —Neɗɗo fuu jogiiɗo toggooje ɗiɗi, hokka mo walaa worre. Jogiiɗo nyaamdu duu, waɗa hano non. ");
INSERT INTO fuh_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","*Jaɓooɓe janngal duu ngari faa ngaɗanee *batisma, ɓe ƴami mo, ɓe mbi'i : —Moodibbo, ɗume min kaani waɗude ? ");
INSERT INTO fuh_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Yahaaya jaabii kamɓe duu, wi'i : —To ɓeydee dow ko mbi'aɗon njaɓon. ");
INSERT INTO fuh_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Soogeeji gom duu ƴami mo, mbi'i : —Minen nee, ɗume min kaani waɗude ? O jaabii ɓe, o wi'i : —To teetiree njawdi neɗɗo fuu semmbe semmbe. To tuumee neɗɗo fuu dow fewre ngam njaɓon ceede he mum. Ndaree he njobdi mon. ");
INSERT INTO fuh_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Himɓe kaaɓi ngi'aay *Almasiihu. Neɗɗo fuu no ƴama hoore mum no wi'a naa Yahaaya woni *Almasiihu ? ");
INSERT INTO fuh_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Nden Yahaaya wi'i ɓe : —Miin, ndiyam ngaɗirananmi on *batisma, amma ɓurɗo kam baawɗe no wara. Mi fotaay baa fiirtude ɓoggi paɗe makko. Kanko kay, *Ruuhu Ceniiɗo e hiite o waɗiranta on *batisma. ");
INSERT INTO fuh_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Omo jogii ƴarorde makko ngam ƴaraade alkamaari makko faa laaɓa. O hawra gabbe makko, o loowa nder ƴeelu. Nden o wula nyaane ndeen nder hiite nge nyifataa abada. ");
INSERT INTO fuh_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yahaaya no waajoo himɓe dow *Habaru lobbo, omo hollita ɓe dow kujje ɗuɗɗe. ");
INSERT INTO fuh_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","*Hirudus, teeti mawnum debbo mum bi'eteeɗo Hirudiya. Nden Yahaaya feli mo, o feli mo duu dow kujje bonɗe fuu ɗe o waɗannoo. ");
INSERT INTO fuh_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Sey *Hirudus ɓeydi waɗude bone kaden, o uddi Yahaaya. ");
INSERT INTO fuh_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Wakkati himɓe fuu ngaɗantee *batisma, Iisa duu waɗana *batisma. Wakkati o du'otonoo, sey kammu omtii, ");
INSERT INTO fuh_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","*Ruuhu Ceniiɗo jippii dow makko nder nanndi wuugaanu. Daane gom ƴuwi dow, wi'i : —Aan woni Ɓiyam korsuɗo. Aan naniranmi belɗum. ");
INSERT INTO fuh_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Wakkati Iisa fuɗɗi golle mum, o faanake duuɓi woronja (30). Nder miilooji himɓe Iisa no ɓii-Yusufu. Yusufu duu no ɓii-Eli, ");
INSERT INTO fuh_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli ɓii-Mattat, Mattat ɓii-Lewi, *Lewi ɓii-Melki, Melki ɓii-Yannaay, Yannaay ɓii-Yusufu, ");
INSERT INTO fuh_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yusufu ɓii-Mattatiya, Mattatiya ɓii-Amos, Amos ɓii-Nahum, Nahum ɓii-Hesli, Hesli ɓii-Naggaay, ");
INSERT INTO fuh_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Naggaay ɓii-Maata, Maata ɓii-Mattatiya, Mattatiya ɓii-Semeyin, Semeyin ɓii-Yosek, Yosek ɓii-Yoda, ");
INSERT INTO fuh_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda ɓii-Yowanan, Yowanan ɓii-Resa, Resa ɓii-Jorobaabiila, Jorobaabiila ɓii-Salaatiyel, Salaatiyel ɓii-Neeri, ");
INSERT INTO fuh_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neeri ɓii-Melki, Melki ɓii-Addi, Addi ɓii-Koosam, Koosam ɓii-Elmadam, Elmadam ɓii-Eri, ");
INSERT INTO fuh_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Eri ɓii-Iisa, Iisa ɓii-Eliyeser, Eliyeser ɓii-Yoorim, Yoorim ɓii-Mattat, Mattat ɓii-Lewi, ");
INSERT INTO fuh_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","*Lewi ɓii-Simeyon, Simeyon ɓii-Yahuuda, Yahuuda ɓii-Yusufu, Yusufu ɓii-Yonam, Yonam ɓii-Eliyakim, ");
INSERT INTO fuh_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliyakim ɓii-Meleya, Meleya ɓii-Menna, Menna ɓii-Mattata, Mattata ɓii-Natan, Natan ɓii-Daawda, ");
INSERT INTO fuh_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Daawda ɓii-Yesa, Yesa ɓii-Yobed, Yobed ɓii-Bo'es, Bo'as ɓii-Sala, Sala ɓii-Naason, ");
INSERT INTO fuh_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naason ɓii-Aminadabu, Aminadaabu ɓii-Admin, Admin ɓii-Arni, Arni ɓii-Hesruna, Hesruuna ɓii-Fares, Fares ɓii-Yahuuda, ");
INSERT INTO fuh_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","*Yahuuda ɓii-Yakuuba, Yakuuba ɓii-Isiyaaku, Isiyaaku ɓii-Ibrahim, *Ibrahim ɓii-Tera, Tera ɓii-Nakor, ");
INSERT INTO fuh_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nakor ɓii-Seruku, Seruku ɓii-Ragaw, Ragaw ɓii-Faleka, Faleka ɓii-Eber, Eber ɓii-Sala, ");
INSERT INTO fuh_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala ɓii-Kayinan, Kayinan ɓii-Arfakasada, Arfakasada ɓii-Sem, Sem ɓii-Nuhu, Nuhu ɓii-Lemek, ");
INSERT INTO fuh_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lemek ɓii-Metusela, Metusela ɓii-Enok, Enok ɓii-Yaret, Yaret ɓii-Maleliyel, Maleliyel ɓii-Kayinan, ");
INSERT INTO fuh_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kayinan ɓii-Enos, Enos ɓii-Setu, Setu ɓii-Aadamu, Aadamu ɓii-Alla. ");
INSERT INTO fuh_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Iisa ƴuwi maayo Urdun no heewi *Ruuhu Ceniiɗo. *Ruuhu oon ɗowi mo nder ladde yeeruure. ");
INSERT INTO fuh_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Toon Ibiliisa sii'ii mo balɗe lasooji ɗiɗi. O nyaamaay fuy nder balɗe lasooji ɗiɗi ɗee fuu faa o rafaa. ");
INSERT INTO fuh_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Nden Ibiliisa wi'i mo : —Se goonga fuu a *Ɓii-Alla, tilsin hayre ndee laatoo nyaamdu. ");
INSERT INTO fuh_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Sey Iisa jaabii mo wi'i : —Dewtere Alla wi'i : Hanaa nyaamdu tan neɗɗo wuurdata. ");
INSERT INTO fuh_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Nden Ibiliisa yaari mo nokkuure toowne gom, holli mo nder maƴƴere hitere laamuuji duuniyaaru fuu, ");
INSERT INTO fuh_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","wi'i mo : —Mi hokkete baawɗe dow majji, ɗi fuu, kanƴi e teddungal majji fuu ngam mi hokkaama ɗi. Miɗo waawi hokki ɗi mo muuyanmi fuu. ");
INSERT INTO fuh_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Nde a sujidanii kam, mi hokkete ɗi, ɗii fuu. ");
INSERT INTO fuh_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Sey Iisa jaabii mo, wi'i : —Dewtere Alla wi'i : Alla Joomiraawo maa tan kaanɗaa sujidande. Kanko tan kaanɗaa rewude. ");
INSERT INTO fuh_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Nden Ibiliisa yaari mo huɓeere *Ursaliima, darni mo dow hoore *Juulirde mawne, wi'i mo : —Se goonga fuu a *Ɓii-Alla, jikku, ");
INSERT INTO fuh_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","ngam Dewtere Alla wi'i : Alla tilsinan maleykaaɓe mum ndeene. ");
INSERT INTO fuh_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ɓe taɓɓite to koyngal maaɗa fii he hayre. ");
INSERT INTO fuh_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Sey Iisa jaabii mo, wi'i : —Dewtere Alla wi'i : A sii'ataako Alla Joomiraawo maa. ");
INSERT INTO fuh_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Wakkati Ibiliisa sii'ii mo iri cii'aaki fuu, sey dilli acci mo faa nde gom. ");
INSERT INTO fuh_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Iisa soƴƴii Galili, baawɗe *Ruuhu Ceniiɗo no dow makko. Habaru makko sankitii nder leydi Galili ndiin fuu. ");
INSERT INTO fuh_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Omo waajoo nder *baajorɗi *Yahudankooɓe, himɓe fuu no teddina mo. ");
INSERT INTO fuh_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Nyannde gom Iisa yehi Nasaratu, wuro ngo o mawnunoo nder mum. Nyannde mum ɗum fotodiri *nyalaane fowteteene. O naati *waajordu hano no o woowrunoo. O ummii faa o jannga, ");
INSERT INTO fuh_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","sey o hokkaa dewtere annabi *Esaaya. O taggiti nde, o fotodiri he nokku to winndaa, wi'aa : ");
INSERT INTO fuh_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","—*Ruuhu Joomiraawo no dow am, ngam o suɓake kam, ngam talkaaɓe mbaajee *Habaru lobbo. O lili kam ngam nanngaaɓe kaalanee joofol mum'en, wumɓe duu, bumtinol mum'en, torraaɓe keɓa dimɗinol mum'en. ");
INSERT INTO fuh_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Himɓe duu kaalanee wakkati mo Joomiraawo wannginta moƴƴere mum. ");
INSERT INTO fuh_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","O taggi dewtere ndeen, o hokkiti deenoowo *waajordu nduun, o jooɗii. Wonnooɓe toon fuu puttini gite he makko. ");
INSERT INTO fuh_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Sey o wi'i ɓe : —Ko nanuɗon nder dewtere Alla ndee, tabbiti hannden. ");
INSERT INTO fuh_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ɓe mani mo ɓe fuu. Haalaaji lobbi burtiɗi nder hunnduko makko ɗiin duu haayɗini ɓe. Nden ɓe mbi'i : —Hanaa o ɓii-Yusufu naa ? ");
INSERT INTO fuh_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Iisa wi'i ɓe : —Sikka fuu walaa, on ngaɗanan kam banndol ngool mbi'on : « Cawroowo, sawru hoore maa ». On mbi'an kam kaden : « Ɗo duu wuro maa non. Ndenne, waɗu ko min nani ngaɗɗaa nder Kafarnahum. » ");
INSERT INTO fuh_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Iisa ɓeydi wi'ude ɓe kaden : —Nde goonga miɗo wi'a on, annabiijo fuu jaɓɓataake nder wuro mum. ");
INSERT INTO fuh_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Goonga miɗo haalana on, nder jamaanu annabi Eliya, ɓe goriraaɓe mum'en maayunoo no ɗuuɗi nder leydi *Isra'el. Wakkati ndiyam waɗunoo duuɓi tati e lebbi jeegom toɓaayno, rafo manngo gom waɗiino nder leydi ndiin fuu. ");
INSERT INTO fuh_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Amma Eliya lilaaka he baa gooto maɓɓe, sey he debbo mo gorum maayi gom, debbo jeyaaɗo Sarepta nder leydi Sidon. ");
INSERT INTO fuh_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Nder jamaanu annabi Eliisa, seppinɓe no ɗuuɗunoo nder *Isra'el. Amma baa gooto maɓɓe nyawtaaka, nde hanaa Naaman, jeyaaɗo leydi Siriya. ");
INSERT INTO fuh_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Wakkati wonnooɓe nder *waajordu nduun, nanunoo haala kaa, ka mettini ɓerɗe maɓɓe sanne. ");
INSERT INTO fuh_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ɓe nanngi Iisa ɓe njaari mo gaɗa wuro ngoon. Ɓe njaari mo toon dow hoore waamnde nde dow mum, wuro ngoon nyiɓa, ngam ɓe tutoo mo o saama ley. ");
INSERT INTO fuh_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Amma Iisa feeri hakkune maɓɓe, dilli. ");
INSERT INTO fuh_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Iisa yehi Kafarnahum nder leydi Galili. *Nyalaane fowteteene gom o naati *waajordu omo waajoo. ");
INSERT INTO fuh_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Waaju makko haayɗini ɓe ngam he baawɗe o waajorii ɓe. ");
INSERT INTO fuh_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Gorko gom, mo ginnaaru woni dow mum no tampinaa no tawaa nder *waajordu nduun. Sey ginnaaru nduun huuɓi daane toowne, wi'i : ");
INSERT INTO fuh_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Hey ! Iisa mo Nasaratu, ɗume ngiɗaa waɗude min ? A wari faa mbaraa min naa ? Miɗo anndi moy woni ma. A Ceniiɗo ƴuwɗo to Alla ! ");
INSERT INTO fuh_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Sey Iisa laayani ginnaaru nduun, sajiti he mayru, wi'i : —Maɓɓu hunnduko maa, takkita mo ! Ndu liɓi gorko oon hakkune himɓe. Ndu takkiti mo, walaa to ndu nawni he ɓanndu makko. ");
INSERT INTO fuh_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ɗum haayɗini himɓe ɓeen fuu. Nden ɓe tinni iɓe ƴamodira, iɓe mbi'a : —Iri kaye woni haala kaa ? Ngam haala makko kaa no woodi baawɗe e semmbe. Omo dawrana baa ginnaaji, iɗi takkitoo neɗɗo. ");
INSERT INTO fuh_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Habaru Iisa oo sankitii nder leyɗe ɗeen fuu. ");
INSERT INTO fuh_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Iisa wurtii *waajordu nduun, yehi wuro Simon Piyer. Eso Simon Piyer debbo no wondi wulowulo naawngo, ɓe ƴami Iisa walla mo. ");
INSERT INTO fuh_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Iisa turii dow makko, tilsini wulowulo ngoon hela. Ngo heli, debbo oon yamɗiti, ummii wakkati mum da, jaɓɓii ɓe. ");
INSERT INTO fuh_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ko naange yani, wooduɓe nyawɓe, nyawirɓe nyawuuji ir iriiji fuu ngaddi nyawɓe mum'en to makko. O deki juuɗe makko dow maɓɓe, o yamɗintini ɓe, ɓe fuu, gooto gooto. ");
INSERT INTO fuh_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ginnaaji ɗiin no takkitoo himɓe heewɓe, no kuuɓa, no mbi'a : —Aan woni *Ɓii-Alla. Amma Iisa no sajito he majji, omo haɗa ɗi haalude, ngam iɗi anndi kanko woni *Almasiihu. ");
INSERT INTO fuh_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ko weeti, Iisa wurtii Kafarnahum, yehi nder nokkuure yeewne gom. Himɓe heewɓe tinni no tefa mo faa ngiitowi mo. Ɓe njaɓaay o seeda he maɓɓe kaden. ");
INSERT INTO fuh_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Amma Iisa wi'i ɓe : —No tilsi mi waajoo *Habaru lobbo dow Laamu Alla nder gure feere feereeje. Ngam majjum waɗi lilowaami. ");
INSERT INTO fuh_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Iisa yehi no waajoo nder *baajorɗi leydi Yahudiya. ");
INSERT INTO fuh_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Nyannde gom, Iisa no darii dow fonngo peta Genesaret, jama'aare no dow makko no ɓillodira ngam hettinoo haala Alla. ");
INSERT INTO fuh_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Iisa holliri laanaaji ɗiɗi gom no panndi dow fonngo peta ngaan. Nanngooɓe liƴƴi gom mburtii nder majji no loota taaruuji mum'en. ");
INSERT INTO fuh_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Simon bi'eteeɗo Piyer no tawa nder maɓɓe. Sey Iisa naati nder laana makko, wi'i mo, o awƴoo ka seɗɗa, ɓe mboɗɗoo fonngo ngoon. Iisa jooɗii nder makka tinni no waajoo jama'aare ndeen. ");
INSERT INTO fuh_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Wakkati o hantunoo waaju makko, o wi'i Simon : —Yah to luggiɗi, paɗɗon taaruuji mon, aan e banndiraaɓe maa, nanngon liƴƴi. ");
INSERT INTO fuh_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simon jaabii Iisa, wi'i mo : —Moodibbo, min mbaalii miɗen ngolla, min keɓaay baafuy. Amma ngam a haali, mi faɗɗan taaruuji ɗiin. ");
INSERT INTO fuh_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Wakkati ɓe paɗɗunoo ɗi, ɗi nanngi liƴƴi ɗuɗɗi faa ɗi puɗɗi serkude. ");
INSERT INTO fuh_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Nden ɓe noddi banndiraaɓe maɓɓe gom wonɓe nder laana feereha gom ngara mballira ɓe. Ɓe ngari, ɓe kebbini laanaaji ɗiɗi ɗiin fuu, faa ɗi kosi rufude. ");
INSERT INTO fuh_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Wakkati Simon hi'unoo ɗum, o diccii yeeso Iisa, o wi'i mo : —Moodibbo, woɗɗam, ngam miin mi gaɗoowo hakke. ");
INSERT INTO fuh_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simon haalani Iisa haala kaa ngam kanko e wonduɓe he makko ɓeen fuu, ɗuuɗal liƴƴi nanngaaɗi ɗii haayɗini ɓe. ");
INSERT INTO fuh_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Yakuuba e Yahaaya ɓiɓɓe Jebede gollidooɓe he Simon ɓeen duu, ɗum haayɗini ɓe. Nden Iisa jaabii Simon wi'i mo : —Taa hulu, ɓaawo hannden a laatoto nanngoowo himɓe. ");
INSERT INTO fuh_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Wakkati ɓe panndini laanaaji maɓɓe, ɓe mboppi ɗi, ɗii fuu, ɓe tokki Iisa. ");
INSERT INTO fuh_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Nyannde gom gorko ceppinɗo gom wari, tawi Iisa nder wuro gom. Wakkati o hi'unoo Iisa, o turni yeeso makko faa he leydi, o wi'i mo : —Moodibbo, nde nii a jaɓi, aɗa waawi yamɗintinde kam. ");
INSERT INTO fuh_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Sey Iisa foorti junngo mum, meemi mo, wi'i : —Mi jaɓi, yamɗitin ! Wakkati mum da, gorko oon yamɗiti. ");
INSERT INTO fuh_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Nden Iisa wi'i mo : —To haalan ɗum neɗɗo fuu. Amma yah holloy hoore maa *cakkanoowo Alla, ngaɗaa cakkol ngol *Muusa tilsini waɗee ngam hollude himɓe ko sikka fuu walaa a yamɗiti. ");
INSERT INTO fuh_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Amma baa nii ko Iisa haɗi mo haalande himɓe, habaru oo sankitake nokku fuu. Jama'aare warta, no hawra to makko ngam hettinaade waaju makko e yamɗintineede he nyawuuji mum'en. ");
INSERT INTO fuh_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Iisa duu wakkati warde wakkati no wurto yeha nder nokkuuje jeewɗe ngam du'oo. ");
INSERT INTO fuh_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Nyannde gom Iisa no waajoo, tawi *Fariisa'en e jannginooɓe *Tawreeta, ƴuwɓe gure Galili, Yahudiya, e *Ursaliima fuu no njooɗii ɗoon hadde makko. Baawɗe Alla Joomiraawo no wondi he makko omo yamɗintina nyawɓe. ");
INSERT INTO fuh_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Woɓɓe ngaddi gorko bonnguujo gom no fukkinaa dow kooƴirngal maayɓe. Iɓe tefa nannude mo nder suudu ndu Iisa woni nder mum ngam ɓe pukkina mo yeeso makko. ");
INSERT INTO fuh_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Amma ɓe keɓaay fuu no ɓe nanniri mo ngam jama'aare woodi sanne. Sey ɓe ƴeenyidi he makko dow suudu nduun. Ɓe kunci ndu, ɓe njippini mo caka himɓe fuu yeeso Iisa. Omo fukkii dow kooƴirngal maayɓe ngaal. ");
INSERT INTO fuh_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Wakkati Iisa hi'unoo no goonɗinol maɓɓe foti, o wi'i bonnguujo oon : —Higo, hakkeeji maa njaafaama. ");
INSERT INTO fuh_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Sey jannginooɓe *Tawreeta e *Fariisa'en tinni no mbi'a nder ɓerɗe mum'en : —Ɗume waɗi gorko oo no bonna innde Alla ? Moy waawi yaafaade hakke se hanaa Alla ? ");
INSERT INTO fuh_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Iisa faami miilooji maɓɓe, jaabii ɓe, wi'i : —Ɗume waɗi ko oɗon miiloo ir miilooji ɗii nder ɓerɗe mooɗon ? ");
INSERT INTO fuh_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ɗume ɓuri hoyde hakkune wi'ude bonnguujo oo « Hakkeeji mum njaafaama » naa « O ummoo, o dilla »  ? ");
INSERT INTO fuh_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Amma miɗo hiɗi paamon ko *Ɓii-Neɗɗo no jogii baawɗe yaafaade hakkeeji himɓe nder duuniyaaru nduu. Sey o wi'i bonnguujo oon : —Miɗo haalane : « Umma, hooƴu kooƴirngal maayɓe ngal ngaddireɗaa, hootu. » ");
INSERT INTO fuh_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Wakkati mum da, bonnguujo oon ummii yeeso himɓe fuu, hooƴi kooƴirngal mum, hooti, no yetta Alla. ");
INSERT INTO fuh_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ɗum haayɗini himɓe fuu, ɓe tinni iɓe njetta Alla. Kulal nanngi ɓe, ɓe mbi'ii : —Hannden en ngi'ii haayne. ");
INSERT INTO fuh_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Gaɗa bonngitol gorko oo, Iisa wurtii, hi'i jaɓoowo janngal gom bi'eteeɗo Lewi no jooɗii nder suudu janngal, nden wi'i mo : —Tokkam ! ");
INSERT INTO fuh_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Sey Lewi acci are mum fuu, ummii, tokki mo. ");
INSERT INTO fuh_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Lewi waɗi nyaamduuji ir-iriiji ndefaa wuro mum ngam Iisa. Jaɓooɓe janngal ɗuɓɓe e himɓe gom no nyaamda he maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Sey *Fariisa'en e jannginooɓe maɓɓe puɗɗi no nguuntoo, no mbi'a *aahiiɓe Iisa : —Ɗume waɗi oɗon nyaamda, oɗon njarda he *jaɓooɓe janngal, he waɗooɓe hakke ɓee ? ");
INSERT INTO fuh_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Sey Iisa jaabii ɓe, wi'i : —Nyawɗo haajaa cawroowo hanaa jamɗuɗo. ");
INSERT INTO fuh_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Mi waraay noddude miilooɓe kam'en no dartiiɓe. Mi waraana ngam annduɓe kam'en no waɗooɓe hakke faa ɓe tuuba. ");
INSERT INTO fuh_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","*Fariisa'en gom mbi'i Iisa : —Aahiiɓe Yahaaya gaɗoowo *batisma no cuumoo sanne, iɓe ndu'oo duu, non aahiiɓe amin duu ngaɗata. Amma *aahiiɓe maaɗa kay, no nyaama, no njara ! ");
INSERT INTO fuh_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Iisa jaabii ɓe wi'i : —Oɗon mbaawi suuminde warɓe ɓanngal, wakkati ɓaŋuɗo oon no wondi he maɓɓe naa ? ");
INSERT INTO fuh_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Amma nyalaaɗe ngaran ɗe ɓaŋuɗo oon suutetee hakkune maɓɓe. Nder balɗe ɗeen ɓe cuumoto. ");
INSERT INTO fuh_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Nden Iisa waɗani ɓe kippol haala ngool, wi'i ɓe : —Neɗɗo fuu serkataa koltal kesal, itta lefol he maggal nyoota he koltal kiinngal. Nde joomum waɗi ɗum, no bonnan kesal ngaal, tawa lefol kesol ngool duu yaadaay he kiinngal ngaal. ");
INSERT INTO fuh_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Kaden duu, neɗɗo fuu loowataa cabiijam kesam nder sumalleeji kiɗɗi. Nde joomum waɗi ɗum, cabiijam kesam ɗaam fusan ɗi, ɗam rufa, sumalleeji ɗiin duu mursee. ");
INSERT INTO fuh_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Amma cabiijam kesam nder sumalleeji kesi haani loowee. ");
INSERT INTO fuh_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Neɗɗo fuu yari cabiijam kiɗɗam, hiɗaa kesam, ngam joomum no wi'an kiiɗɗam ɗaam ɓuri welde. ");
INSERT INTO fuh_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","*Nyalaane fowteteene gom, Iisa he *aahiiɓe mum no peddita gese alkamaaje, sey *aahiiɓe ɓeen tinni no mborsoo camme alkama, no molma ɗe, no ƴakka. ");
INSERT INTO fuh_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Nden *Fariisa'en gom mbi'i ɓe : —Ko waɗi oɗon ngaɗa ko haɗaa nder *nyalaane fowteteene ? ");
INSERT INTO fuh_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Sey Iisa jaabii ɓe, wi'i : —On njanngaay ko Daawda waɗunoo wakkati kanko he yaadiraaɓe makko fuu ndafanoo ? ");
INSERT INTO fuh_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","O naati nder suudu Alla, o adi buuru ittanaaɗo Alla oon, o nyaami. O hokki mo yaadiraaɓe makko. *Tawreeta duu wi'aana ko *cakkanooɓe Alla tan kaani nyaamude mo. ");
INSERT INTO fuh_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Iisa wi'i ɓe kaden : —*Ɓii-Neɗɗo woni jom *nyalaane fowteteene. ");
INSERT INTO fuh_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","*Nyalaane fowteteene gom, Iisa naati *waajordu gom omo waajoo. Gorko gom mo junngo mum nyaamo waati no tawa nder mayru. ");
INSERT INTO fuh_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Jannginooɓe *Tawreeta e *Fariisa'en no kora Iisa, ngi'a nde o nyawtan goɗɗo nder *nyalaane fowteteene, nden ɓe keɓa ko ɓe pelirta mo. ");
INSERT INTO fuh_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Amma Iisa no anndi miilooji maɓɓe. Sey o wi'i gorko mo junngo mum waati oon : —Umma, dara yeeso himɓe. Gorko oon ummii, darii. ");
INSERT INTO fuh_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Iisa wi'i jannginooɓe *Tawreeta e *Fariisa'en ɓeen : —Miɗo ƴama on : Nder *nyalaane fowteteene, ɗume haani waɗeede ? Ko wooɗi naa ko boni ? Dannude neɗɗo naa halkude mo ? ");
INSERT INTO fuh_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Iisa daari ɓe, ɓe fuu, nden o wi'i gorko oon : —Foortu junngo maa ! Gorko oon foorti junngo mum, ngo yamɗiti. ");
INSERT INTO fuh_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ɓerne jannginooɓe *Tawreeta e *Fariisa'en metti sanne. Sey ɓe kaaldi caka maɓɓe no ɓe ngaddata he Iisa. ");
INSERT INTO fuh_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Nyannde gom, Iisa ƴeenyi waamnde faa du'oo. O waali omo du'oo. ");
INSERT INTO fuh_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ko weeti sey o noddi *aahiiɓe makko, o suɓii sappo e ɗiɗo nder maɓɓe, o waɗi ɓe *lilaaɓe. ");
INSERT INTO fuh_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simon mo o inndiri Piyer, he minyum Andiire, Yakuuba, Yahaaya, Filipa, Bartolome, ");
INSERT INTO fuh_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matta, Tomas, Yakuuba ɓii-Alfee, Simon kiranoowo suudu baaba, ");
INSERT INTO fuh_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yahuuda ɓii-Yakuuba, kam e Yahuuda Iskariyot, mo yahde yeeso jammboytoo Iisa. *Aahiiɓe sappo e ɗiɗo ɓee ngoni suɓaaɓe ngaɗa *lilaaɓe. ");
INSERT INTO fuh_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Iisa jippodii he maɓɓe waamnde ndeen, darii nder nokkuure yaajune gom. Ɗuɓɓe nder *aahiiɓe makko no tawa toon. Jama'aare ƴuwne leydi Yahudiya, *Ursaliima e gure tiimooje Maayo Manngo, illa Tirus faa Sidon fuu no tawaa nder nokku oo. ");
INSERT INTO fuh_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ɓe ngari ngam hettinaade mo, he ngam ɓe nyawtee duu. Ɓe ginnaaji bonɗi torrunoo, coptinaama. ");
INSERT INTO fuh_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Himɓe ɓee fuu no ngiɗi meemude mo ngam baawɗe no mburtoo nder makko no yamɗintina ɓe, ɓe fuu. ");
INSERT INTO fuh_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Iisa ƴeewi *aahiiɓe mum, wi'i : —On mbelii ko'e, onon talkaaɓe, ngam onon njeyi Laamu Alla. ");
INSERT INTO fuh_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","On mbelii ko'e, onon rafaaɓe jooni, ngam on kaaran. On mbelii ko'e, onon woyooɓe jooni, ngam on njalan. ");
INSERT INTO fuh_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","On mbelii ko'e nde himɓe mbanyii on, mboppi on, njennii on, mbonnii inɗe mooɗon ngam *Ɓii-Neɗɗo. ");
INSERT INTO fuh_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Non maamiraaɓe maɓɓe torrirnoo annabiiɓe artuɓe on. Amma nyannde mum, kuuɓee ngam welwelo. Baraaje mawɗe no ndoomi on nder kammu. ");
INSERT INTO fuh_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","On mbonii, onon riikuɓe, ngam on keɓii mbaka mooɗon. ");
INSERT INTO fuh_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","On mbonii, onon haarɓe jooni, ngam on ndafetee. On mbonii, onon jalooɓe jooni, ngam ɓerɗe mooɗon no mettan, on mboyan. ");
INSERT INTO fuh_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","On mbonii, nde himɓe fuu manii on, ngam non maamiraaɓe maɓɓe ngaɗannoo annabiiɓe fewreeɓe. ");
INSERT INTO fuh_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","—Onon hettinaniiɓe kam, miɗo wi'a on : « Ngiɗee wayɓe mooɗon, ngaɗanee wanyuɓe on ko wooɗi. ");
INSERT INTO fuh_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Eelee Alla mbarkina naalooɓe on, ndu'anee torrooɓe on duu. ");
INSERT INTO fuh_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Nde goɗɗo feenyii ma dow gaɓɓugal, linnyu mo ngalto duu. Se goɗɗo teetii jabbaare maa, taa haɗu mo toggoore maa. ");
INSERT INTO fuh_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ƴamuɗo ma fuu, kokkaa ɗum. Se neɗɗo teeti ko njeyɗaa, accan mo ɗum. ");
INSERT INTO fuh_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ngaɗiranee himɓe no ngiɗɗon ɓe ngaɗana on. ");
INSERT INTO fuh_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Se hiɗuɓe on tan ngiɗoton, baraaje ɗeye keɓoton ? Baa waɗooɓe hakke no ngiɗi hiɗuɓe ɗum'en. ");
INSERT INTO fuh_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Se waɗanooɓe on ko wooɗi tan ngaɗanton ko wooɗi, baraaje ɗeye ngiɗɗon heɓude ? Baa waɗooɓe hakke non ngaɗata. ");
INSERT INTO fuh_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Se ɓe miiliɗon mbaawi yoɓude on tan kokkoton nyamaane, baraaje ɗeye keɓoton ? Baa waɗooɓe hakke no nyalmo waɗooɓe hakke hano mum'en, ngam ɓe njoɓee nyamaane maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Amma onon, ngiɗee wayɓe mooɗon, ngaɗanon ɓe ko wooɗi. Nyalmee tawa on tammaay baafuy he maɓɓe, ngam Alla no wonnana ɓe njettataa, kam'en e bonɓe duu. Nde on ngaɗiri nii on keɓan baraaje mawɗe. On laatoto ɓiɓɓe Alla Toowɗo. ");
INSERT INTO fuh_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Laatee jom'en yurmeene hano no Alla Baabii'on laatori jom yurmeene. » ");
INSERT INTO fuh_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","—To kiitee himɓe, on kiitataake. To ndekee gacce dow woɓɓe, onon duu on ndekantaake gacce. Njaafee himɓe, on njaafetee. ");
INSERT INTO fuh_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Kokkee himɓe, on kokketee. Se on kokkii, on etirantee etirgal lobbal, kebbinaangal faa no rufa. Nden ko hoddi ɗum duu mbanjaneɗon ɗum nder gawargal mooɗon. Ngam etirgal ngal etirton, kanngal etiranteɗon. ");
INSERT INTO fuh_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Gaɗa mum Iisa ɓeydi banndol ngool, o wi'i ɓe : —Bumɗo no waawi ɗowde bumɗo naa ? Se ɗum waɗi, hanaa sey ɓe fuu ɗiɗo, ɓe caamowan nder ngayka naa ? ");
INSERT INTO fuh_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Aahiijo ɓurataa moodibbo mum. Amma aahiijo kumnuɗo jannde mum fuu no laatoto hano moodibbo mum. ");
INSERT INTO fuh_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ko waɗi ko aɗa hi'a kuɗel nder hitere bannda, amma a hi'ataa bonjariyal gonngal nder nde maaɗa ? ");
INSERT INTO fuh_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Noy mbaawirtaa wi'ude bannda : « Banndam, accu mi ittane kuɗel gonngel nder hitere maa », amma aan kay, a hi'ataa bonjariyal tawaangal nder nde maaɗa ? Munaafiki, ittu bonjariyal ngonngal nder hitere maaɗa ginan, ngam ngi'iraa no wooɗiri, nden keɓaa no ittirɗaa kuɗel tawaangel nder hitere bannda ngel. ");
INSERT INTO fuh_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","—Lekki lobbi rimataa ko boni, non duu lekki mbonki rimataa ko wooɗi. ");
INSERT INTO fuh_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ngam lekki fuu no annditiree ɓiɓɓe mum. Ibbe teɓataake he wuumoore gi'e, cabiije teɓataake he kebbe. ");
INSERT INTO fuh_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Neɗɗo moƴƴuɗo, ko moƴƴi ko resii nder ɓerne mum, kam hunnduko mum wurtinta. Neɗɗo bonɗo duu, ko boni ko resii nder ɓerne mum, kam hunnduko mum wurtinta. Ngam ko heewi nder ɓerne neɗɗo, wurtotoo nder hunnduko mum. ");
INSERT INTO fuh_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Iisa wi'i ɓe : —Ɗume waɗi oɗon noddira kam Joomiraawo mooɗon, amma on ngaɗataa ko mbi'umi on ? ");
INSERT INTO fuh_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Neɗɗo fuu garɗo to am hettini haalaaji am, golliri ɗi, mi hollan on no joomum nanndi. ");
INSERT INTO fuh_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Omo nanndi he neɗɗo nyiɓuɗo suudu mum, wasi leydi faa yottii e tepaare, sinngi suudu mum dow mayre. Nde ndiyam toɓi faa ilam wubbi ndu, ɗam waawtaa yinngude ndu, ngam dow tepaare ndu nyiɓaa. ");
INSERT INTO fuh_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Amma kettiniiɗo haalaaji am, golliraay ɗi, no nanndi he nyiɓuɗo suudu dow leydi, dey wasanaay ndu sinngirde. Nde ilam wubbi ndu, wakkati gooto ndu saama, ndu sankitoo, ndu fuu. ");
INSERT INTO fuh_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Wakkati Iisa hantunoo waaju mum, o ummii o naati siire Kafarnahum. ");
INSERT INTO fuh_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Hooreejo soogeeji *Rooma gom no nder siire ndeen. Maccuɗo makko, korsuɗo gom nyawi faa no hosa maayde. ");
INSERT INTO fuh_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Wakkati hooreejo oon nanunoo habaru Iisa no waɗee, sey o lili *Yahudankooɓe dottiiɓe gom to makko, eela mo o wara, o yamɗintina maccuɗo makko oo. ");
INSERT INTO fuh_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Dottiiɓe ɓeen ngari to Iisa, ɓe ŋaarii mo, ɓe ŋaariti mo, ɓe mbi'i : —No haani mballaa neɗɗo oo ");
INSERT INTO fuh_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ngam omo hiɗi lenyol meeɗen, kanko duu nyiɓi *waajordu amin. ");
INSERT INTO fuh_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Nden Iisa yahdi he maɓɓe. Wakkati ɓe ɓadinoo wuro hooreejo oon, sey hooreejo oon waɗi lilaaɓe gom ngari to Iisa, mbi'i mo : —Moodibbo, taa tampin hoore maa, ngam higiimin wi'i ko kam fotaay to naataa ɓaade mum. ");
INSERT INTO fuh_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ngam majjum waɗi kam miilii, ko kam e hoore mum, haani wara to maaɗa. Ndenne, haala maaɗa tan heƴi, maccuɗo makko yamɗitaa. ");
INSERT INTO fuh_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ngam kam e hoore mum, kam no woodi dawranooɓe ɗum, kam duu no dawrana soogeeji *Rooma. Se kam tilsini gooto yaha, o yahan. Se kam wi'i goɗɗo wara, o waran. Se kam wi'i maccuɗo mum waɗa goɗɗum, o waɗan ɗum. ");
INSERT INTO fuh_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Wakkati Iisa nanunoo haala kaa, ɗum haayɗini mo, o yeeƴitii himɓe tokkuɓe mo ɓeen, o wi'i : —Miɗo haalana on, baa nder leydi *Isra'el fuu mi hi'aay ir goonɗinol ngool. ");
INSERT INTO fuh_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Wakkati lilaaɓe ɓeen coƴƴitino, ɓe tawi maccuɗo oon yamɗiti. ");
INSERT INTO fuh_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Iisa ummii Kafarnahum, yehi wuro gom wi'eteengo Nayin. *Aahiiɓe makko e jama'aare mawne gom no tokki mo. ");
INSERT INTO fuh_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Wakkati o ɓadinoo dammbugal wuro ngoon, sey o fotti himɓe gom no ndonndi maayɗo gom faa mooɓowa mo. Maayɗo oo, kam tan innum e bammum ndimi. Baaba oon maayi, inna oon duu haɓɓanaaka. Himɓe Nayin ɗuɓɓe no tokki debbo oon. ");
INSERT INTO fuh_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Wakkati Iisa hi'unoo debbo oo, nani yurmeene makko, wi'i mo : —Taa woy ! ");
INSERT INTO fuh_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Sey Iisa ɓadii, meemi kooƴirngal maayɗo oon. Ronndiiɓe maayɗo oon ndarii, Iisa wi'i : —Jokolle, miɗo wi'e : Ummoɗaa ! ");
INSERT INTO fuh_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Sey maayɗo oon ummii jooɗii, fuɗɗi no haala. Iisa hokkiti mo inniiko. ");
INSERT INTO fuh_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Kulal nanngi himɓe ɓeen fuu, ɓe puɗɗi iɓe teddina Alla, iɓe mbi'a : —Annabiijo mawɗo wanngii hakkune meeɗen. Alla warii wallude himɓe mum. ");
INSERT INTO fuh_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Habaru oo sankitii nder leydi Yahudiya fuu e seraaji mum. ");
INSERT INTO fuh_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ko aahiiɓe Yahaaya gaɗoowo *batisma kaalanowi Yahaaya ko Iisa waɗi. Yahaaya noddi ɗiɗo nder maɓɓe, ");
INSERT INTO fuh_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","lili ɓe to Iisa. O lili ɓe ƴama Iisa nde kanko woni *Almasiihu bi'aaɗo waran oon naa ɓe ndooma goɗɗo ? ");
INSERT INTO fuh_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Nden worɓe ɓeen ngari to Iisa, mbi'i mo : —Yahaaya lili min to maa. O wi'i min ƴame nde aan woni *Almasiihu bi'aaɗo waran oon, naa min ndooma goɗɗo ? ");
INSERT INTO fuh_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Tawi nder wakkati mum Iisa yamɗintini himɓe ɗuɓɓe nyawirɓe nyawuuji feere-fereeji. O riiwi ginnaaji bonɗi. O wumtini wumɓe ɗuɓɓe. ");
INSERT INTO fuh_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Sey Iisa jaabii ɓe, wi'i : —Njehee, kaalanowee Yahaaya ko ngi'uɗon e ko nanuɗon fuu : Wumɓe no mbumta, laƴooɓe no njaha faa wooɗa. Seppinɓe no nyawtee, pahuɓe no pahitee. Maayɓe no ummintinee, talkaaɓe duu no pillanee *Habaru lobbo. ");
INSERT INTO fuh_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Barkinaaɗo woni mo woppaay goonɗinol mum ngam am. ");
INSERT INTO fuh_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Wakkati lilaaɓe Yahaaya ɓeen ndillunoo, Iisa fuɗɗi fillanaade jama'aare ndeen filla Yahaaya, nden o ƴami ɓe, o wi'i : —Ko njaanoɗon nder ladde yeeruure, ɗume ndaaroyɗon ? Huɗo ko henndu wifata ndaaroyɗon, ");
INSERT INTO fuh_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","naa ɗume njaaɗon daaroyde ? Gorko ɓorniiɗo kolte gasuɗe naa ? Ɓornotooɗo koltal gasuŋal e nanoowo belɗum nder ɓaade laamiiɗo tawetee. ");
INSERT INTO fuh_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ndenne, ɗume ndaaroyɗon ? Naa annabiijo njaaɗon daaroyde ? Too, miɗo haalana on, Yahaaya no ɓuri annabiijo. ");
INSERT INTO fuh_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Kanko woni mo haala Alla haalunoo dow mum wi'i : Ndaa, mi ardinan lilaaɗo am moƴƴinane laawol maaɗa. ");
INSERT INTO fuh_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Miɗo haalana on, walaa dimaaɗo nder duuniyaaru nduu ɓurɗo Yahaaya. Amma fuu nii, ɓurɗo famɗude nder Laamu Alla no ɓuri mo teddude. ");
INSERT INTO fuh_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Himɓe fuu nanuɓe ko Iisa wi'i, faa e jaɓooɓe janngal njaɓi ko laawol Alla woni goonga. Kamɓe duu ngoni ɓe Yahaaya waɗani *batisma. ");
INSERT INTO fuh_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Amma *Fariisa'en e jannginooɓe *Tawreeta njaɓaay ko Alla hiɗani ɓe. Kamɓe ngonnoo caliiɓe Yahaaya waɗana ɓe *batisma. ");
INSERT INTO fuh_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Nden Iisa wi'i ɓe kaden : —Ndenne, he ɗume mbaawmi nanndinde himɓe jamaanu hannden oo ? ");
INSERT INTO fuh_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Iɓe nanndi he sukaaɓe jooɗiiɓe nder luumo, no nodda higiraaɓe mum'en, no mbi'a : —Min puufanii on seeseeji, amma on mbomaay ! Min njimani on jimi jurminiiɗi, amma on mboyaay ! ");
INSERT INTO fuh_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Wakkati Yahaaya gaɗoowo *batisma warnoo, o nyaamataa ir nyaamduuji gom, o yarataa cabiijam, amma on mbi'ii o laddaaɗo. ");
INSERT INTO fuh_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","*Ɓii-Neɗɗo duu wari, no nyaama, no yara. On mbi'i nyaamɗe e jarɗe tan adi hakkillo makko. On mbi'i o higo *jaɓooɓe janngal e waɗooɓe hakke. ");
INSERT INTO fuh_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Amma goonɗinɓe hikmaaku Alla, no kolla nder mbuurnam mum'en ko laawol Alla no goonga. ");
INSERT INTO fuh_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Fariisaajo gom noddi Iisa wuro mum ngam ɓe nyaama. Iisa yehi wuro Fariisaajo oon, jooɗii, iɓe nyaamda. ");
INSERT INTO fuh_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Nder wuro ngoon, no woodunoo debbo gom anndiraaɗo pijol. Wakkati o nanunoo Iisa no wuro *Fariisaajo oon, o waddi faanu nebbam uurɗam, ");
INSERT INTO fuh_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","o heedi sera koyɗe Iisa. Omo woya, omo leppinira koyɗe Iisa gonɗi makko. Omo wunndii ɗe, omo moytira ɗe gaasa makko, omo wuja ɗe nebbam. ");
INSERT INTO fuh_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Wakkati Farisaajo noddunooɗo Iisa oon hi'i ɗum, wi'i nder ɓerne mum : —Se nii goonga fuu neɗɗo oo no annabiijo, o anndannoo ko debbo meemoowo mo oo, no gaɗoowo hakke. ");
INSERT INTO fuh_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Sey Iisa haaldi he Fariisaajo oon, wi'i mo : —Simon, no woodi goɗɗum ko kaanumi haalande ma. Simon, Fariisaajo oon, wi'i mo : —Haalanam, Moodibbo ! ");
INSERT INTO fuh_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Nden Iisa wi'i mo : —Nyalmotooɗo gom no tokkannoo himɓe ɗiɗo gom. Gooto, omo tokka ɗum tammaaje cardi keme joy, ooto woygu. ");
INSERT INTO fuh_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Amma ko ɓe keppi yoɓude mo fuu, sey o yaafanii ɓe fuu ɗiɗo nyamaane ndeen. Caka himɓe ɗiɗo ɓee moy ɓurata hiɗude mo nder maɓɓe ? ");
INSERT INTO fuh_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon jaabii mo wi'i : —Miɗo miila mo o accanii nyamaane ɗuunde oon. Sey Iisa wi'i mo : —A haalii goonga ! ");
INSERT INTO fuh_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Iisa yeeƴitii debbo oon, wi'i Simon : —A hi'i debbo oo naa ? Mi naatii hoggo maa, a hokkaay kam ndiyam mi loota koyɗe am. Amma debbo oo, o leppinirii koyɗe am gonɗi mum. Nden kaden o moytirii ɗe gaasa makko. ");
INSERT INTO fuh_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","A wunndaaki kam, amma kanko, illa naatumi, o accaay wunndaade koyɗe am. ");
INSERT INTO fuh_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","A wujaay hoore am nebbam, amma kanko, o wujii koyɗe am nebbam uurɗam. ");
INSERT INTO fuh_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ngam majjum miɗo wi'e : No hakkeeji makko ɗuuɗiri fuu, ɗi njaafaama, ngam o holli hidde mawne. Amma jaafanaaɗo seɗɗa, hidde seɗɗa hollata. ");
INSERT INTO fuh_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Nden Iisa wi'i debbo oon : —Hakkeeji maaɗa njaafaama. ");
INSERT INTO fuh_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Sey nyaamdooɓe he Iisa ɓeen puɗɗi no mbi'a hakkune mum'en : —Moy woni neɗɗo jaafotooɗo baa hakkeeji oo ? ");
INSERT INTO fuh_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Iisa wi'i debbo oon : —Goonɗinol maaɗa hisinii ma. Yah he jam. ");
INSERT INTO fuh_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Iisa no fiiloo nder ci'e e gure fuu, no waajoo filla *Habaru lobbo, filla Laamu Alla. *Lilaaɓe makko sappo e ɗiɗo no ngondi he makko. ");
INSERT INTO fuh_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Rewɓe gom, ɓe o riiwi ginnaaji bonɗi dow mum'en he rewɓe ɓe o yamɗintini e nyawuuji mum'en gom duu, no ngondi he makko : Mariyaama mo Magdaala, mo Iisa riiwunoo ginnaaji jeɗɗi dow mum, ");
INSERT INTO fuh_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Yowanna, dee-Kuja, ardiiɗo gollooɓe laamiiɗo *Hirudus, Susaana, he rewɓe ɗuɓɓe gom. Rewɓe ɓee ngoni rewɓe wattuɓe njawdi mum'en mballiri Iisa e *aahiiɓe mum. ");
INSERT INTO fuh_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Himɓe ƴuwi nder ci'e feere-fereeje ngari kawri, ngaɗi jama'aare mawne fiilii Iisa. Nden o waɗani ɓe kippol haala ngool, o wi'i ɓe : ");
INSERT INTO fuh_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Aawoowo gom dilli faa aawowa aawdiiri mum. Nder aawre ndeen, gabbe gom caami sera laawol, ɗe njaaɓaa. Nden pooli ngari coppi ɗe. ");
INSERT INTO fuh_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Gere majje caami nder korkaaƴe. Ɗe puɗi, amma ɗe njoori, ngam nokkuure ndeen faddataako ndiyam. ");
INSERT INTO fuh_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Gere majje caami to kebbe puɗata. Kebbe ɗeen puɗidi he majje, nanngi ɗe. ");
INSERT INTO fuh_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Gere majje caami nder leydi lobbiri, ɗe puɗi, ɗe ndimi. Wassaaŋo fuu waɗi camme hemre. Wakkati o timmini kippol haala ngool, sey o towni daane, o wi'i : —Jom nowru nanooru fuu, nana ! ");
INSERT INTO fuh_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Sey *aahiiɓe makko ƴami mo mbi'i : —Ɗume woni maana kippol haala ngool ? ");
INSERT INTO fuh_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Nden o wi'i ɓe : —Onon, Alla hokkii on baawɗe anndude ko suuɗi dow habaru Laamu muuɗum. Amma woɓɓe, he kippol haala ɓe kaalirantee ɗum. Baa nde iɓe ndaara, ɓe ngi'ataa. Baa nde ɓe nani, ɓe paamataa. ");
INSERT INTO fuh_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Piirtol kippol haala ngool nii : —Aawdiiri ndiin woni haala Alla. ");
INSERT INTO fuh_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Sera laawol to aawdiiri ndiin saami woni nanuɓe haala kaan. Amma wakkati ɓe nanunoo ka, Ibiliisa waran, itta ka nder ɓerɗe maɓɓe ngam ɓe keppa goonɗinde, sako ɓe kisa. ");
INSERT INTO fuh_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Korkaaƴe to aawdiiri ndiin saami woni nanuɓe haala kaan, njaɓɓorii ka welwelo. Amma ka waɗaay ɗaɗi nder maɓɓe. Wakkati seɗɗa tan ɓe ngoonɗinta. Nde nii ɓe cii'aama seɗɗa tan, ɓe mboppa ka. ");
INSERT INTO fuh_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","To kebbe puɗidi aawdiiri ndiin woni nanuɓe haala kaan amma sakkulla, suuno njawdi e mbelirka duuniyaaru huma ka, ka heppa ɓenndude nder maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Leydi lobbiri to aawdiiri ndiin saami woni nanuɓe ka, njaɓɓori ka ɓerne worre lok. Ɓe munyi munyal manngal faa ɓe ngaɗi barke. ");
INSERT INTO fuh_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","—Walaa kuɓɓoowo fitilla, nden hippira ka le'al naa sorna ka ley leeso. Amma nde neɗɗo huɓɓii fitilla, sey nii ɓila ka ngam ka yaynana naatooɓe. ");
INSERT INTO fuh_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Huune fuu ko suuɗi no wanngowan nyannde gom. Ko soomaa fuu duu no somtetee. ");
INSERT INTO fuh_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ndenne, kakkilee he no nanirton kujje, ngam jogiiɗo fuu no ɓeydantee. Amma mo walaa oon, baa ko miilii no jogii ɗum, no teetetee. ");
INSERT INTO fuh_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Minyiraaɓe Iisa worɓe e inniiɗum'en ngari to Iisa, amma ɓe keɓaay yottaade mo ngam jama'aare woni no fiilii mo. ");
INSERT INTO fuh_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Nden goɗɗo wi'i mo ko inniiko e rimdaaɓe makko no ndarii yaasin no ngiɗi ngi'a mo. ");
INSERT INTO fuh_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Sey o jaabii, o wi'i : —Inna am e rimdaaɓe am ngoni nanooɓe e gollirooɓe haala Alla. ");
INSERT INTO fuh_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Nyannde gom Iisa e *aahiiɓe mum naati nder laana, sey o wi'i *aahiiɓe ɓeen : —En njolu peta ngaa. Sey ɓe njoli. ");
INSERT INTO fuh_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Wakkati ɓe njolannoo, sey ɗoyngol adi mo. Duydi ummii dow peta ngaan, laana maɓɓe heewi ndiyam faa ka hosi rufude. ");
INSERT INTO fuh_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","*Aahiiɓe makko ɓattii mo, pindini mo, mbi'i mo : —Moodibbo, moodibbo, en maayan ! Sey o fini, o sappii henndu nduun e benkeƴƴe ɗeen. Ɗum fuu ɗum darii. Peta ngaan fuu waɗi siw. ");
INSERT INTO fuh_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Nden Iisa wi'i *aahiiɓe ɓeen : —Toy goonɗinol mooɗon ? Ɗum haayɗini ɓe. Ɓe kuli, iɓe mbi'odira : —Moy woni neɗɗo oo, tilsinoowo baa henndu e ndiyam, ɗi ɗowtanoo ɗum oo ? ");
INSERT INTO fuh_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Iisa he *aahiiɓe mum pedditi peta Galili faa panndowa leydi Gerasa. ");
INSERT INTO fuh_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Wakkati ɓe njippinoo gorko gom, jeyaaɗo wuro ngoon, mo ginnaaru bondu woni dow mum, wari to Iisa'en. Gorko oo ɓooydi he ginnaaru nduu faa ndu waɗi o ɓornataako, o eggi nder wuro ngoon o jooɗowi nder annyeeje. ");
INSERT INTO fuh_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Wakkati o hi'unoo Iisa, sey o huuɓi daane toowne, o hofi yeeso Iisa, o wi'i mo : —Iisa, *Ɓii-Alla Toowɗo, ɗume ngiɗaa waɗude kam ? Mi ŋaarake ma, to torram ! ");
INSERT INTO fuh_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ginnaaru nduun no ƴeenyannoo dow gorko oo kile keewɗe. Indu yaara mo faa nder ladde yeeruure. Juuɗe gorko oo e koyɗe mum ɗe fuu kaɓɓiraama callali, amma omo taƴa ɗi. Iisa tilsinii ginnaaru bondu nduun jippoo dow gorko oo. ");
INSERT INTO fuh_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","O ƴami mo, o wi'i : —Noy mbi'eteɗaa ? O jaabii, o wi'i : —Miɗo wi'ee : « Jama'aare ». Ngam ginnaaji ɗuɗɗi ngoni dow makko. ");
INSERT INTO fuh_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Nden ɗi ŋaarii Iisa to o tilsin ɗi ɗi njaha nder ngaykaa laahara nga walaa fuu keerol. ");
INSERT INTO fuh_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Hadde ɗon sewre girooji mawne gom no durannoo dow waamnde. Ginnaaji ɗiin ŋaarii mo o acca ɗi njippowo dow girooji ɗiin. Iisa jaɓi, acci ɗi. ");
INSERT INTO fuh_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ɗi takkiti gorko oon, ɗi njippowi dow girooji ɗiin. Sewre ndeen fuu doggi simmiti waamnde ndeen. Ɗi talliti, ɗi caamowi nder peta ngaan, ɗi njoolii. ");
INSERT INTO fuh_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Wakkati durooɓe girooji ɗiin ngi'ii ɗum, ɓe ndoggi, ɓe kaalanowi himɓe wuro ngoon e himɓe seraaji maggo. ");
INSERT INTO fuh_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Himɓe ɓeen njehi ƴeewowi ko waɗi. Wakkati ɓe njottinoo to Iisa, ɓe tawi laddanooɗo oon no jooɗii hadde koyɗe makko. Omo holti, hakkillo makko duu no huuɓi. Kulal nanngi ɓe. ");
INSERT INTO fuh_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Warɓe ngi'ii gorko oon kaalanowi himɓe no gorko laddanooɗo oon nyawtiniraa. ");
INSERT INTO fuh_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Himɓe leydi Gerasa fuu ŋaarii Iisa dilla nder leydi mum'en, ngam kulal manngal nanngi ɓe. Iisa naati laana, dilli. ");
INSERT INTO fuh_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Wakkati ɓe ndillannoo ndeen gorko mo ginnaaji mum ndiiwaa oon, ŋaarii Iisa acca kam tokka mo. Amma Iisa soƴƴiti mo, wi'i mo : ");
INSERT INTO fuh_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Hootu wuro maa, kaalowa ko Alla waɗani ma fuu. Nden o hooti, o haalanowi wuro ngoon fuu ko Iisa waɗani mo. ");
INSERT INTO fuh_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Wakkati Iisa wartunoo Galili, jama'aare jaɓɓii mo, ngam illa ndeen iɓe ndoomi mo. ");
INSERT INTO fuh_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Sey Jayrus, hooreejo *waajordu oon, wari to Iisa, hofi yeeso makko, ŋaarii mo o wara wuro mum ");
INSERT INTO fuh_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ngam ɓiyum debbo gooto mo o rimi no habda he yonki. Ɓii-Jayrus debbo oo duuɓi mum ngaɗaay sappo e ɗiɗi. Wakkati Iisa fa'uno wuro Jayrus, jama'aare tokki mo faa himɓe no ɓilla mo. ");
INSERT INTO fuh_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Debbo gom, mo tuuni mum heppi taƴude duuɓi sappo e ɗiɗi nii no tawa nder jama'aare ndeen. Ko o joginoo fuu, o watti ɗum ngam o sawree, amma neɗɗo fuu waawaay yamɗintinde mo. ");
INSERT INTO fuh_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Debbo oo ƴuwri Iisa har gaɗa, meemi hunnduko jabbaare makko. Wakkati mum da ƴiiƴam ɗaam taƴi. ");
INSERT INTO fuh_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Iisa wi'i jama'aare ndeen : —Moy meemii kam ? Neɗɗo maɓɓe fuu wi'i hanaa kam non. Sey Piyer wi'i mo : —Moodibbo, himɓe ɗuɓɓe ngatti ma caka. Kamɓe ngoni no ɓille ! ");
INSERT INTO fuh_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Nden Iisa wi'i : —Goɗɗo meemii kam, ngam mi nani baawɗe ƴuwi nder am. ");
INSERT INTO fuh_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Wakkati debbo oon faamunoo ko kam waawtaa suuɗaade, sey o wari omo hoɗɗa, o diccii yeeso Iisa, o haali yeeso himɓe fuu ko waɗi kam meemi Iisa, e no o yamɗitiri wakkati mum da. ");
INSERT INTO fuh_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Nden Iisa wi'i mo : —Banndam debbo, goonɗinol maa danni ma. Yah he jam ! ");
INSERT INTO fuh_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Iisa no caka haala sey goɗɗo ƴuwi wuro Jayrus, wari, wi'i : —Jayrus, ɓiya debbo maayi, fotaay tampinaa moodibbo oo kaden ! ");
INSERT INTO fuh_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Wakkati Iisa nanunoo ɗum, sey wi'i Jayrus : —Taa hulu, goonɗin tan, ɓiya daɗan. ");
INSERT INTO fuh_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Wakkati Iisa yottinoo wuro Jayrus, o accaay neɗɗo fuu nadda he makko, sey nii Piyer, Yahaaya, Yakuuba, baaba suka oon e inna suka oon. ");
INSERT INTO fuh_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Himɓe fuu no cimoo, no mboya suka oon. Nden Iisa wi'i ɓe : —Ɗume woni bojji ɗii ? O maayaay, o ɗaanii tan. ");
INSERT INTO fuh_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ɓe njali, jaleeɗe yawaare ngam iɓe anndi ko suka oon maayi. ");
INSERT INTO fuh_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Iisa nanngi junngo suka oon, towni daane, wi'i : —Suka, umma ! ");
INSERT INTO fuh_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Yonki suka oon warti, wakkati mum da o ummii. Iisa wi'i, ɓe kokka suka oon ko nyaamata. ");
INSERT INTO fuh_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ummintinol suka oon haayɗini saarooɓe suka oon sanne. Amma o wi'i ɓe to ɓe kaalan neɗɗo fuu ko waɗi. ");
INSERT INTO fuh_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Iisa noddi *lilaaɓe mum sappo e ɗiɗo ɓeen. O hokki ɓe semmbe e baawɗe riiwude ginnaaji e nyawtude nyawɓe. ");
INSERT INTO fuh_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Nden o lili ɓe, ɓe mbaajoo dow Laamu Alla, ɓe njamɗintina nyawɓe. ");
INSERT INTO fuh_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","O wi'i ɓe : —To neɗɗo mooɗon fuu yaaru sawru, mbasu, nyaamdu, ceede, naa toggooje ɗiɗi nder jahaangal ngaal. ");
INSERT INTO fuh_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Nder wuro fuu ngo ngarɗon, ɓaade fuu nde njippiɗon nder mum, njooɗee nder mayre sey nyannde ndilloton. ");
INSERT INTO fuh_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Wuro fuu ngo himɓe mum njaɓɓaaki on, nde oɗon mburtoo ngo, piɗɗee sollaare koyɗe mooɗon ngam ɗum laatanoo ɓe seeda gacce maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","*Lilaaɓe ɓeen ndilli, iɓe njaha wuro warde wuro, iɓe mbaajoo *Habaru lobbo, iɓe njamɗintina nyawɓe nokku fuu. ");
INSERT INTO fuh_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Wakkati *Hirudus, laamiiɗo leydi Galili, nanunoo ko Iisa woni no waɗa fuu, hakkillo makko ndiibodiri. O nani woɓɓe no mbi'a Yahaaya gaɗoowo *batisma ummitii, ");
INSERT INTO fuh_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","woɓɓe no mbi'a Eliya wanngi. Woɓɓe duu no mbi'a gooto nder annabiiɓe aranɓe ummitii. ");
INSERT INTO fuh_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Amma *Hirudus wi'i : —Mi taƴi hoore Yahaaya. Moy woni mo nananmi kujje ɗee fuu no kaalee dow mum oo ? Nden o tefi no watta o hi'a Iisa. ");
INSERT INTO fuh_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Wakkati *lilaaɓe ɓeen ngartunoo, ɓe kaalani Iisa ko kam'en ngaɗi fuu. Nden o ummodi kamɓe tan ngam ɓe pa'a har siire Baytisayda. ");
INSERT INTO fuh_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Wakkati jama'aare ndeen nanunoo ɓe ndillan, sey nde tokki mo. Nden o jaɓɓii nde. O waajii nde dow habaru Laamu Alla. O sawri haajaaɓe sawreede duu. ");
INSERT INTO fuh_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Wakkati hiirunoo, *lilaaɓe sappo e ɗiɗo ɓeen ɓattii Iisa, mbi'i mo : —Ɗo nder ladde ngonɗen. Accu jama'aare ndee yaha nder gure e daɗɗooji seraaji ɗii, ngam ɓe keɓa to ɓe njippoo e to ɓe nyaami. ");
INSERT INTO fuh_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Nden Iisa wi'i ɓe : —Onon e ko'e mooɗon, kokkee ɓe ko ɓe nyaamata ! *Aahiiɓe ɓeen njaabii mo, mbi'i : —Ko min njogii fuu ɓuraay buuruuje joy e liƴƴi ɗiɗi. Naa a hiɗaana min coodanowa himɓe ɓee fuu nyaamdu non ? ");
INSERT INTO fuh_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Worɓe tawaaɓe toon tan no ngaɗa worɓe ujunaaji joyo. Nden Iisa wi'i *aahiiɓe mum : —Njonnee ɓe cefe-cefe, sewre fuu waɗa hano himɓe woygu. ");
INSERT INTO fuh_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ɓe njonni ɓe cefe-cefe faa neɗɗo maɓɓe fuu heɓi to jooɗii. ");
INSERT INTO fuh_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Iisa hooƴi buuruuje joy e liƴƴi ɗiɗi ɗiin, tiggitii, yetti Alla. O helti buuruuje ɗeen e liƴƴi ɗiin o hokki *aahiiɓe ɓeen njeddana jama'aare ndeen. ");
INSERT INTO fuh_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Himɓe fuu nyaami faa kaari. Kelte koddiiɗe ɗeen kawra, ɗe kebbini kandeeje sappo e ɗiɗi. ");
INSERT INTO fuh_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Nyannde gom wakkati Iisa wonnoo feere mum no du'oo, *aahiiɓe makko no tawaa hadde makko. Sey Iisa ƴami ɓe, wi'i : —Moy himɓe mbi'ata ngonmi ? ");
INSERT INTO fuh_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Nden ɓe njaabii mo, ɓe mbi'i : —Woɓɓe no mbi'a aan woni Yahaaya gaɗoowo *batisma. Woɓɓe to mum'en, aan woni Eliya. Woɓɓe duu no mbi'a a gooto nder annabiiɓe aranɓe ummitiiɗo. ");
INSERT INTO fuh_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Iisa ƴami ɓe, wi'i : —Dey onon nee, moy mbi'oton ngonmi ? Piyer jaabii mo, wi'i : —Aan woni *Almasiihu mo Alla ! ");
INSERT INTO fuh_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Iisa fooɗi noppi maɓɓe wi'i to ɓe kaalan ɗum neɗɗo fuu. ");
INSERT INTO fuh_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Nden o wi'i ɓe : —No tilsi *Ɓii-Neɗɗo torree sanne. Mawɓe *Yahudankooɓe, hooreeɓe *cakkanooɓe Alla e jannginooɓe *Tawreeta tottitoo mo. O waree, nden o ummitoo nyannde tataɓere. ");
INSERT INTO fuh_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","O wi'i ɓe, ɓe fuu : —Muuyɗo tokkude kam fuu, acca daarude hoore mum, hooƴa *leggal mum bardugal nyannde fuu, tokka kam. ");
INSERT INTO fuh_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ngam giɗɗo hisinde yonki mum, mursan ki. Amma mursuɗo ki ngam am, hisinan ki. ");
INSERT INTO fuh_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ɗume keɓol duuniyaaru nduu fuu nafirta neɗɗo, nde joomum mursi yonki mum ? ");
INSERT INTO fuh_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Miin, *Ɓii-Neɗɗo, caliiɗo kam miin e haalaaji am ɗii fuu yeeso himɓe, mi saloto ɗum nde mi wari nder teddungal am, e nder teddungal *Baaba am e maleykaaɓe mum seniiɓe. ");
INSERT INTO fuh_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Goonga kaalananmi on : Nder tawaaɓe ɗo ɓee hannden, woɓɓe maayataa ngi'aay Laamu Alla. ");
INSERT INTO fuh_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Balɗe jeetati gaɗa ko Iisa wi'i dow hoore mum, o nyakki dow waamnde faa o du'oo. Piyer, Yahaaya e Yakuuba no ngondi he makko. ");
INSERT INTO fuh_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Wakkati o du'otonoo, tagaadi yeeso makko waylitii. Kolte makko ndawni tar faa no ƴelkitoo. ");
INSERT INTO fuh_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Wakkati mum da himɓe ɗiɗo gom, *Muusa e Eliya mbanngi. ");
INSERT INTO fuh_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ɓe mbanngidi teddungal, iɓe kaalda he Iisa. Ɓe kaaldi he makko dow no o humnirta golle makko har maayde makko nder *Ursaliima. ");
INSERT INTO fuh_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Piyer e yaadiraaɓe mum no ɗaanii ɗoyngol maɓɓe moddi. Ko ɓe pini, sey ɓe ngi'ii teddungal Iisa e worɓe ɗiɗo wonduɓe he makko ɓeen. ");
INSERT INTO fuh_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Wakkati himɓe ɗiɗo ɓeen ceedunoo he Iisa, sey Piyer wi'i mo : —Moodibbo, no wooɗi ko tawaaɗen ɗo. Accu min nyiɓa hukumuuji tati : Aan worru, *Muusa worru, Eliya worru. Piyer haaldi he Iisa, amma anndaa ko woni no wi'aa. ");
INSERT INTO fuh_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Wakkati Piyer wonnoo no haala, luuldere gom wari, suddi ɓe. Luuldere jippiine dow maɓɓe ndee waɗi *aahiiɓe ɓeen kuli sanne. ");
INSERT INTO fuh_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Daane gom ƴuwi nder luuldere ndeen, wi'i : —Oo woni Ɓiyam mo cuɓiimi. Kettinanee mo ! ");
INSERT INTO fuh_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ko daane ndeen deƴƴi, Iisa tan ɓe ngi'ii. *Aahiiɓe ɓeen njogii ko waɗi ɗum caka mum'en. Nder balɗe mum walaa mo ɓe kaalani ko ɓe ngi'ii. ");
INSERT INTO fuh_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Jaangoore mbaylitaaki tagaadi Iisa, wakkati Iisa e *aahiiɓe mum tato ɓeen njippinoo waamnde ndeen, jama'aare mawne gom wari jaɓɓii Iisa. ");
INSERT INTO fuh_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Sey nder jama'aare ndeen, gorko gom huuɓi, wi'i : —Moodibbo, mi ŋaarake ma, ƴeewanam ɓiyam gorko oo, kanko tan ndimumi. ");
INSERT INTO fuh_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ginnaaru gom woni dow makko. Nde ndu ƴeenyii mo, ndu dimmba mo, o tinno omo hacca faa nguufo waanjonoo mo. Ndu accataa mo, sey to o nawnake ko ndu yoofa mo. ");
INSERT INTO fuh_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Mi ŋaarake *aahiiɓe maa ndiiwa ndu, amma ɓe keppi. ");
INSERT INTO fuh_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Sey Iisa jaabii mo, wi'i : —Hey onon himɓe jamaanu bonɗo, ɓe ngoonɗinaay ! Faa nde ngondanmi he mooɗon ? Faa nde tinnotoomi miɗo munyana on ? Waddu suka maaɗa ɗo ! ");
INSERT INTO fuh_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Wakkati suka oon ɓadinoo, sey ginnaaru nduun liɓi mo. Ndu tinni indu dimmba mo. Iisa sajiti he mayru ndu takkitoo suka oon. O sawri suka oon, o hokkiti ɗum bammum. ");
INSERT INTO fuh_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Wonɓe toon ɓeen fuu nanngi kunndule mum'en, baawɗe Alla mawɗe haayɗini ɓe. Wakkati Iisa hi'unoo ko golleeji mum ɗii haayɗini jama'aare ndee fuu, sey o wi'i *aahiiɓe makko : ");
INSERT INTO fuh_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Onon, korkitee noppi mon, kettinoɗon ko kaalanmi : *Ɓii-Neɗɗo no jammbetee, wattee nder juuɗe. ");
INSERT INTO fuh_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Amma *aahiiɓe makko paamaay maana haala kaa. Ka laaɓanaay ɓe, iɓe kula duu ƴamude mo. ");
INSERT INTO fuh_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Geddi ummii hakkune *aahiiɓe Iisa dow ɓurɗo teddude nder maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Iisa no anndi ko woni nder ɓerɗe maɓɓe, sey o nanngi junngo cukalel gom, o darni hadde makko, ");
INSERT INTO fuh_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","o wi'i ɓe : —Jaɓɓiiɗo cukalel ngel dow innde am, miin jaɓɓii. Jaɓɓiiɗo kam, jaɓɓake lilɗo kam. Ngam ɓurɗo leesude hakkune mooɗon, kam woni ɓurɗo teddude nder mooɗon. ");
INSERT INTO fuh_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Sey Yahaaya fiirti hunnduko, wi'i : —Moodibbo, min ngi'ii goɗɗo no riiwa ginnaaji bonɗi he innde maa. Min kaɗi mo ngam o wondaa he meeɗen. ");
INSERT INTO fuh_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Iisa jaabii mo, wi'i : —To kaɗee mo, ngam mo yeddaay on fuu, no wondi he mooɗon. ");
INSERT INTO fuh_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Wakkati ƴeencinol Iisa dow kammu ɓadinoo, Iisa e hoore mum adi anniya yahde *Ursaliima. ");
INSERT INTO fuh_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","O lili *lilaaɓe makko ardoo mo. Ɓe ndilli ɓe naatowi nder wuro leydi Samariya gom ngam ɓe ciryanoo Iisa ko haajaa fuu. ");
INSERT INTO fuh_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Amma himɓe wuro ngoon calii jaɓɓaade Iisa ngam ɓe anndi ko *Ursaliima o fa'i. ");
INSERT INTO fuh_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ko Yakuuba e Yahaaya ngi'unoo ɗum, sey ɓe mbi'i : —Moodibbo, aɗa hiɗi min mbi'a hiite ƴuwa dow jippoo nyaama ɓe naa ? ");
INSERT INTO fuh_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Iisa yeeƴitii ɓe, duki ɓe. ");
INSERT INTO fuh_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Sey ɓe njehi wuro feerewo gom. ");
INSERT INTO fuh_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Iisa'en no he laawol sey neɗɗo gom wi'i mo : —Mi tokkete mi yaha to njehataa fuu. ");
INSERT INTO fuh_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Iisa jaabii mo, wi'i : —Junkuuji no ngoodi gayɗe, pooli duu no ngoodi cuuɗi, amma *Ɓii-Neɗɗo walaa baa nokku to fukkoo, fowtina hoore mum. ");
INSERT INTO fuh_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Iisa wi'i goɗɗo : —Tokkam ! Amma neɗɗo oon jaabii mo, wi'i : —Moodibbo, accu mi mooɓowa baaba am ginan. ");
INSERT INTO fuh_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Sey Iisa wi'i mo : —Accu maayɓe mooɓa maayɓe mum'en. Aan kay, yah waajowa habaru Laamu Alla. ");
INSERT INTO fuh_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Goɗɗo wi'i Iisa : —Mi tokkete, Moodibbo. Amma accu mi waynitowo hoggo am ginan. ");
INSERT INTO fuh_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Iisa jaabii neɗɗo oo, wi'i : —Neɗɗo fuu dekuɗo junngo mum dow demirgal, nde yeeƴitake, walaa ko nafataa nder Laamu Alla. ");
INSERT INTO fuh_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Gaɗa ekkintinol dow no Iisa tokkirtee, Iisa suɓii kaden *aahiiɓe lasooji tato e sappo e ɗiɗo, liliri ɗiɗɗiɗo, ɓe ardoo mo nder wuro fuu e nokku fuu to o haani yahde. ");
INSERT INTO fuh_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","O wi'i ɓe : —Ko hettee no ɗuuɗi, hettooɓe ɗuuɗaa. Ndenne, eelee Jom hetto oon lilda hettooɓe nder gese mum. ");
INSERT INTO fuh_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Njehee, mi lilii on he himɓe oɗon nanndi baali hakkune pobbi. ");
INSERT INTO fuh_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","To njaaree baafuy. To njaaree albey, to njaaree mbasu, naa paɗe. Dow laawol, to on cannodiree he himɓe cannodirol juungol. ");
INSERT INTO fuh_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ɓaade nde naatuɗon fuu, cannon joomiinde ginan, mbi'on : « Jam jippoo dow ɓaade ndee. » ");
INSERT INTO fuh_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Nde neɗɗo mo jam non, barke du'aa'u mooɗon tabbitan he makko. Nde o hanaa jom jam duu, o heɓataa barke du'aa'u mooɗon. ");
INSERT INTO fuh_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Njooɗee nder ɓaade nde mbernaɗon. Ko ɓe kokki on fuu nyaamon, njaron, ngam no haani golloowo fuu heɓa njobdi mum. To ngaɗee naata-wurto nder ɓaade fuu. ");
INSERT INTO fuh_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Wuro ngo naatuɗon nder mum fuu, nde on njaɓɓaama, ko ngaddanaɗon fuu nyaamon. ");
INSERT INTO fuh_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Njamɗintinon nyawɓe tawaaɓe toon, mbi'on ɓe : Laamu Alla ɓadake on. ");
INSERT INTO fuh_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Amma wuro fuu ngo naatuɗon, nde on njaɓɓaaka nder maggo, njehee nder laabi maggo, mbi'on : ");
INSERT INTO fuh_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","« Min piɗɗii baa sollaare wuro mooɗon takkinoone he koyɗe amin he mooɗon. Amma anndee ko Laamu Alla ɓadake. » ");
INSERT INTO fuh_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Miɗo haalana on : Nyannde darŋal, kiite wuro ngoon no ɓuran kiite *Sodooma naawde. ");
INSERT INTO fuh_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","O wi'i siire Korasin : —Korasin, a boni ! Bone saaman dow maa, aan Baytisayda ! Nder mooɗon Alla waɗi kujje kaayɗiniiɗe. Ngam nde nii kaayɗe ɗe Alla waɗunoo nder mooɗon ɗeen, o waɗinoo ɗe nder Tirus he nder Sidon, nden tawan wonɓe nder majje tuubinoo ila. Ɓe ɓoornakeno saakuuji, ɓe njooɗakeno nder ndooni, ngam hollude ko ɓe tuubii. ");
INSERT INTO fuh_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ndenne nyannde darŋal, kiite mooɗon no ɓuran kiite Tirus e Sidon naawde. ");
INSERT INTO fuh_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Aan duu Kafarnahum, aɗa miiloo a townetee faa dow naa ? Too, a leynetee faa ley toon nder laahara. ");
INSERT INTO fuh_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Iisa wi'i *aahiiɓe mum kaden : —Kettinaniiɗo on fuu, miin hettinanii. Caliiɗo on fuu, miin salii. Caliiɗo kam duu, salake lilɗo kam. ");
INSERT INTO fuh_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","*Aahiiɓe lasooji tato e sappo e ɗiɗo ɓeen njehi, ngartidi welwelo, mbi'i Iisa : —Moodibbo, baa ginnaaji bonɗi wakkati min tilsinii ɗi dow innde maa, ɗi ɗowtanake min. ");
INSERT INTO fuh_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Iisa jaabii ɓe, wi'i : —Mi hi'i Ibiliisa no ƴuwa nder kammu, no saama hano maƴƴere. ");
INSERT INTO fuh_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Nanee, mi hokkii on baawɗe yaaɓude dow bolle, jahe, e jaalaade baawɗe ganyo fuu. Walaa ko heɓata on. ");
INSERT INTO fuh_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","To mbelnee ngam ginnaaji ɗowtanake on tan, amma mbelnee ngam inɗe mooɗon mbinndaama nder kammu. ");
INSERT INTO fuh_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Nder wakkati mum, *Ruuhu Ceniiɗo hebbini Iisa welwelo. Sey o wi'i : —Mi yettii ma, *Baabiraawo jom dow he ley. A suuɗanii jom'en hakkillo he anndal kujje ɗee fuu, amma a wannginanii ɗe sukaaɓe famarɓe. Mi yetti *Baaba, ngam kanƴum weli ma. ");
INSERT INTO fuh_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","*Baaba am watti huune fuu nder juuɗe am. Walaa annduɗo Ɓiɗɗo oon, nde hanaa *Baabiraawo oon. Walaa annduɗo *Baabiraawo oon duu nde hanaa Ɓiɗɗo oon, he mo Ɓiɗɗo oon muuyi wannginande *Baaba oon. ");
INSERT INTO fuh_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Iisa yeeƴitii *aahiiɓe mum haalani ɓe kamɓe tan, wi'i : —Gite gi'ooje ko ngi'oton, mbelii hoore ! ");
INSERT INTO fuh_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ngam miɗo wi'a on, annabiiɓe e laamiiɓe ɗuɓɓe ngiɗiino ngi'a ko ngi'oton ɗum, amma ɓe ngi'aay ɗum. Ɓe ngiɗiino hettinaade ko nanoton ɗum, amma ɓe nanaay ɗum. ");
INSERT INTO fuh_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Nyannde gom jannginoowo *Tawreeta gom ummii faa tunna Iisa. O wari, o ƴami Iisa, o wi'i : —Moodibbo, ɗume kaanumi waɗude ngam heɓude mbuurnam nduumiiɗam ? ");
INSERT INTO fuh_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Iisa jaabii mo, wi'i : —Ɗume winndaa nder *Tawreeta ? Ɗume njannguɗaa toon ? ");
INSERT INTO fuh_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Sey jannginoowo *Tawreeta oon jaabii, wi'i : —Hiɗir Alla Joomiraawo maa he ɓerne maa fuu he yonki maa fuu he semmbe maa fuu he hakkillo maa fuu. Ngiɗaa gondo maa no ngiɗirɗaa hoore maa. ");
INSERT INTO fuh_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Iisa wi'i mo : —A nootake no wooɗiri. Waɗu non, a wuuran. ");
INSERT INTO fuh_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Amma jannginoowo *Tawreeta oon no hiɗi holla ko kam no woodi goonga, nden wi'i mo : —Ndenne, moy woni gondo am ? ");
INSERT INTO fuh_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Iisa jaabii mo, wi'i : —No woodi gorko gom ƴuwɗo *Ursaliima no yeha Yeriko. Pasotooɓe gom nanngi mo, ɓorti kolte makko, piyi mo, acci mo hano maayɗo. ");
INSERT INTO fuh_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ɗum fotodiri *cakkanoowo Alla gom tokkowi laawol ngool no wara warde. Wakkati o hi'unoo teetaaɗo oon no fukkii, o hammbi mo, o wittii. ");
INSERT INTO fuh_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Noon *Lewinke gom duu wari hi'i mo, hammbi mo, wittii. ");
INSERT INTO fuh_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ɓii-leydi *Samariya gom nder jahaangal mum, tokki laawol ngool, sey wari tawi teetaaɗo oon. Wakkati o hi'i mo, o heewi yurmeene. ");
INSERT INTO fuh_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","O ɓadii mo, o sawriri barme makko nebbam e cabiijam, o fiili ɗe. O waɗɗini mo dow baɗɗu makko. Nden o yaari mo jipporde weerɓe gom, o hinnii mo. ");
INSERT INTO fuh_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Jaangoore mum, o itti tammaaje cardi ɗiɗi, o hokki jom weerirde ndeen, o wi'i mo : « Hiinna mo. Nde ko mbaranɗaa mo ɓuri non, nde mi wartii, mi yoɓete. » ");
INSERT INTO fuh_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Iisa ƴami jannginoowo *Tawreeta oon wi'i mo : —He giiɗe maa, nder himɓe tato ɓee moy laatii gondo teetaaɗo oon ? ");
INSERT INTO fuh_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Jannginoowo *Tawreeta oon jaabii Iisa, wi'i mo : —Kolluɗo mo yurmeene oon. Sey Iisa wi'i mo : —Aan duu, yah, waɗoy hano non ! ");
INSERT INTO fuh_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Iisa e *aahiiɓe mum no nder jahaangal, sey ɓe ngari wuro gom. Debbo gom bi'eteeɗo Marta weerni ɓe. ");
INSERT INTO fuh_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta no woodi minyiraawo mum debbo gom bi'eteeɗo Mariyaama. O jooɗii sera koyɗe Iisa, omo hettinoo haala Iisa. ");
INSERT INTO fuh_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marta no he moƴƴinde ko haani fuu ngam weernude ɓe. Golle ɗeen ɗuuɗiri mo sanne faa o henni hakkillo makko fuu he majje. Sey o wari, o wi'i Iisa : —Joomam a hi'aay ko golle ɗuuɗiri kam non ? Minyam accidi kam golleeji ɗii, walaa ko mbi'uɗaa ? Wi'u o ummoo, o wara, o walla kam. ");
INSERT INTO fuh_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Iisa jaabii mo, wi'i : —Marta, Marta, hakkillo maa fuu ummake, aɗa tampina hoore maa dow kujje ɗuɗɗe. ");
INSERT INTO fuh_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Amma nder majje worre tan nafata. Mariyaama suɓake ko ɓuri nafude ɗum, walaa teetoowo mo ɗum. ");
INSERT INTO fuh_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Nyannde gom Iisa no du'oo nder nokku gom. Wakkati o hantunoo, sey gooto nder *aahiiɓe makko ƴami mo, wi'i : —Moodibbo, janngin min no min ndu'ortoo, hano no Yahaaya gaɗoowo *batisma jannginiri aahiiɓe mum. ");
INSERT INTO fuh_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Nden Iisa jaabii, wi'i ɓe : —Wakkati ndu'otoɗon fuu, mbi'on : « *Baabiraawo, innde maa teddinee. Laamu maa wara. ");
INSERT INTO fuh_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Hoynan min nyaamdu heƴunu ndu min kaajaa nyannde fuu. ");
INSERT INTO fuh_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Yaafana min hakkeeji amin, ngam minen duu, miɗen njaafoo waɗanɓe min gacce. Taa accu min cii'ee. » ");
INSERT INTO fuh_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","O wi'i ɓe kaden : —Se gooto nder mooɗon yehi to giɗo mum caka jemma, wi'i mo : « Giɗo, wuƴam buuruuje tati, ");
INSERT INTO fuh_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Higo am gom woni e jahaangal, o wari o jippake wuro am. Mi walaa ko kokkanmi mo ». ");
INSERT INTO fuh_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Nde giɗo maa oo jaabake ma toon nder suudu mum, wi'i : « Taa torram, mi maɓɓi. Miin e sukaaɓe am duu, min pukkake. Mi waawtaa ummaade mi hokke goɗɗum. » ");
INSERT INTO fuh_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Miɗo wi'a on, baa nde o ummaaki o hokki mo ngam o giɗo makko, o ummoto, o hokka mo ko o haajaa fuu, ngam o accaa sulnande mo. ");
INSERT INTO fuh_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Miin, miɗo wi'a on : —Eelee, on keɓan. Tefee, on ngiitan. Calminee, on omtantee. ");
INSERT INTO fuh_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ngam eeluɗo fuu heɓan, tefuɗo fuu hiitan, calminɗo fuu omtantee. ");
INSERT INTO fuh_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Hakkune mooɗon baaba oye hokkata ɓiyum hayre nde eeli buuru ? Naa hokka mo mboddi se o eeli linngu ? ");
INSERT INTO fuh_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Naa nee hokka mo yaare nde o ƴami woppaane ? ");
INSERT INTO fuh_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Goonga onon, no mbonirɗon nii fuu, oɗon kokka ɓiɓɓe mooɗon kujje lobbe, sako Baabii'on gonɗo dow. Omo hokka eeluɗo mo fuu *Ruuhu Ceniiɗo. ");
INSERT INTO fuh_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ginnaaru bondu gom nanngi neɗɗo gom beebi mo. Nyannde gom, Iisa riiwi ginnaaru bondu nduu dow neɗɗo oo. Ko ndu takkiti neɗɗo mo ndu beebi oon, sey neɗɗo oon fuɗɗi no haala. Ɗum haayɗini jama'aare ndeen. ");
INSERT INTO fuh_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Nden nder jama'aare ndeen, woɓɓe tinni no mbi'a : —Be'eljebul, hooreejo ginnaaji oon, hokki mo baawɗe riiwude ginnaaji ɗiin ! ");
INSERT INTO fuh_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Woɓɓe duu ngam cii'oo mo, muuyi o waɗana ɗum'en alaama kaayɗiniiɗo gom ƴuwɗo dow, kolloowo ko Alla lili mo. ");
INSERT INTO fuh_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Amma Iisa no anndi miilooji maɓɓe, nden o wi'i ɓe : —Laamu fuu senndi pecce ɗiɗi no habda hoore mum, sankititto. Wuro fuu fecciingo duu no sankititto. ");
INSERT INTO fuh_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Nde nii Ibiliisa no habda he hoore mum, noy laamorde mum darortoo ? Ngam on mbi'i he baawɗe Be'eljebul ndiiwiranmi ginnaaji ɗii. ");
INSERT INTO fuh_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Nde tawi Be'eljebul ndiiwiranmi ginnaaji, aahiiɓe mooɗon, ɗume ndiiwirta ɗi ? Ndenne golleeji maɓɓe he hoore mum kollata ko on ngalaa goonga ! ");
INSERT INTO fuh_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Amma nde nii junngo Alla ndiiwiranmi ginnaaji, iɗum holla ko Laamu Alla wari to mooɗon. ");
INSERT INTO fuh_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Gorko jom semmbe nde jogake takubaahi reeni hoggo mum, njawdi mum no reenoto. ");
INSERT INTO fuh_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Amma baa nii ko omo fiira ki gabaare, nde ɓurɗo mo semmbe gom saami dow makko, teetan ki he makko, senndida njawdi makko woɓɓe. ");
INSERT INTO fuh_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Iisa wi'i : —Ndenne mo wondaa he am fuu, no ganyo am. Mo wallataa kam mi hawra duu no cankitoowo. ");
INSERT INTO fuh_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Nde nii ginnaaru wurtake neɗɗo, ndu yahan indu warta. Ndu tefan nokkuuje joorɗe to ndu fowtata, amma ndu heɓataa. Nden ndu wi'a : « Ndaa, mi soƴƴoto wuro am to ƴuwnoomi. » ");
INSERT INTO fuh_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Nde nii ndu wartii, ndu tawtaa nokkuure ndeen wuuwaama, moƴƴinaama. ");
INSERT INTO fuh_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Nden ndu yaha, ndu waddowa ginnaaji jeɗɗi ɓurɗi ndu bonde gom. Ɗi naata, ɗi koɗa nder wuro ngoon. Sakitoo mbuurnam neɗɗo mo ndu wurtinoo nder mum oon ɓura ɗam arannde ɗam bonde. ");
INSERT INTO fuh_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Wakkati Iisa haalannoo haalaaji ɗii, sey nder jama'aare ndeen debbo gom ƴetti daane wi'i : —Debbo dimuɗo ma, musini ma, welii hoore ! ");
INSERT INTO fuh_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Iisa jaabii, wi'i : —Goonga non. Amma nanooɓe haala Alla tokka ka, ko'e mum'en ɓuri welde. ");
INSERT INTO fuh_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Wakkati jama'aare hawrunoo, Iisa wi'i nde : —Himɓe jamaanu oo no himɓe bonɓe. Iɓe ngiɗi ɓe kollee alaama ƴuwɗo to Alla, amma walaa alaama mo ɓe kolletee ko ƴaari alaama annabi Yunuusa. ");
INSERT INTO fuh_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ngam non, no Yunuusa laatorani himɓe Niniwe alaama, hano non duu *Ɓii-Neɗɗo laatoranto himɓe jamaanu oo alaama. ");
INSERT INTO fuh_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Nyannde darŋal, debbo laamiiɗo leydi hoore huɗo gom ummodoto he himɓe jamaanu hannden oo. O hiitodo he maɓɓe, o liɓa ɓe. Debbo oo ƴuwi faa to woɗɗi, wari ngam hettinaade haalaaji Suleymaanu keewɗi hikmaaku. Haya, ɓurɗo Suleymaanu nii ɗo ! ");
INSERT INTO fuh_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Nyannde darŋal, himɓe Niniwe ummodoto he himɓe jamaanu hannden. Ɓe kiitodoo he maɓɓe, ɓe liɓa ɓe, ngam kamɓe, ɓe tuubii wakkati ɓe nanunoo waaju Yunuusa. Haya, ɓurɗo Yunuusa nii ɗo ! ");
INSERT INTO fuh_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Iisa wi'i jama'aare ndeen : —Walaa kuɓɓoowo fitilla dey suuɗa ka naa hippa tummbude dow makka, amma sey nii joomum ɓila ka, ka yaynana naatooɓe. ");
INSERT INTO fuh_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Gite ngoni fitillaaji ɓanndu. Nde gite maa no mbooɗi, ɓanndu maa fuu no yaynan. Amma nde ɗe mbooɗaa, ɓanndu maa fuu no niɓɓan. ");
INSERT INTO fuh_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ndenne, hakkila to jeyngol gonngol he maa ngool niɓɓu. ");
INSERT INTO fuh_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Nde ɓanndu maa fuu heewi jeyngol, nde nimre walaa he mayru baa seɗɗa, ndu yaynan nokku fuu hano no fitilla yaynirtee. ");
INSERT INTO fuh_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Wakkati Iisa timminoo waajoo mum, sey *Fariisaajo gom wi'i o wara o nyaama wuro mum. Iisa naati, jooɗii, fuɗɗi no nyaama. ");
INSERT INTO fuh_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Wakkati o hi'unoo Iisa no nyaama lootaay juuɗe mum, ɗum haayɗini mo. ");
INSERT INTO fuh_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Sey Iisa wi'i mo : —Onon *Fariisa'en, oɗon lawƴa gaɗa kore e gaɗa le'e mooɗon, amma ɓerɗe mooɗon no keewi golleeji bonɗi e hidde guyka ! ");
INSERT INTO fuh_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Famɗuɓe hakkillo ! Tawte hanaa taguɗo gaɗa oon, kam tagi nder duu naa ? ");
INSERT INTO fuh_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Kokkiree talkaaɓe ɓerɗe laaɓuɗe, nden ko hoddii fuu no laaɓanan on. ");
INSERT INTO fuh_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Bone saaman dow mooɗon, onon *Fariisa'en ngam oɗon ittana Alla *jakka koyriiho, haako uurko e ir kaakooli nyaameteeɗi fuu. Amma oɗon njeeboo dartinaaku e hidde Alla. Ɗum duu woni ko kaanuɗon waɗude, tawee on mboppaay ɗiito duu. ");
INSERT INTO fuh_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Bone saaman dow mooɗon, onon *Fariisa'en ! Ngam oɗon ngiɗi jooɗorɗe ɓurɗe teddude nder *baajorɗi. Oɗon ngiɗi sanneede cannooje tedduɗe nder luuɓe duu. ");
INSERT INTO fuh_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Bone saaman dow mooɗon, ngam oɗon nanndi he annyeeje ɗe ngalaa alaama, annyeeje ɗe himɓe njaaɓata dow mum'en anndaay. ");
INSERT INTO fuh_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Sey jannginooɓe *Tawreeta gom jaabii Iisa, mbi'i : —Moodibbo, no ngonɗaa aɗa haalira nii, aɗa ɗon aɗa yenna min, minen duu ! ");
INSERT INTO fuh_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Iisa jaabii, wi'i : —Onon jannginooɓe *Tawreeta duu, bone saaman dow mooɗon ! Ngam oɗon ndeka donle tedduɗe dow himɓe, amma onon e ko'e mooɗon, on meemirtaa ɗe baa daane honndu mooɗon ngam wallude ɓe ! ");
INSERT INTO fuh_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Bone saaman dow mooɗon, ngam on nyiɓi annyeeje annabiiɓe, ɓe maamiraaɓe mooɗon mbari. ");
INSERT INTO fuh_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","He golle ɗee kollirɗon ko golle maamiraaɓe mooɗon mbelii on. Ngam ɓe mbarii ɓe, onon duu, on nyiɓi annyeeje maɓɓe ! ");
INSERT INTO fuh_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ngam majjum waɗi Alla nder hikmaaku mum wi'i : « Mi lilan yahde he maɓɓe annabiiɓe e *lilaaɓe. Ɓe mbara woɓɓe maɓɓe, ɓe torra woɓɓe maɓɓe duu. » ");
INSERT INTO fuh_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ndenne, ƴiiƴam annabiiɓe ndufaaɗam illa fuɗɗorde duuniyaaru, himɓe jamaanu oo no njomnetee ɗam. ");
INSERT INTO fuh_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Goonga kaalananmi on : Illa *Haabiila faa wara he Jakariya baraaɗo hakkune sakkirde e *Juulirde mawne, kiite mum'en fuu caaman dow himɓe jamaanu oo ! ");
INSERT INTO fuh_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Bone saaman dow mooɗon, onon jannginooɓe *Tawreeta ! Ngam on teeti maɓɓitirɗum anndal. On naataay, onon e ko'e mooɗon, hiɗuɓe naata ɓeen duu, on accaay ɓe naata. ");
INSERT INTO fuh_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Wakkati Iisa ƴuwanno toon, jannginooɓe *Tawreeta e *Fariisa'en tinni no tinnana mo sanne. Iɓe ƴama mo dow kujje ɗuɗɗe. ");
INSERT INTO fuh_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Iɓe tunna mo ngam ɓe keɓa ko ɓe nanngiri mo. ");
INSERT INTO fuh_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Himɓe ujunaaji ujunaaji ngari kawri to Iisa faa no njaaɓodira. Sey Iisa wi'i *aahiiɓe mum : —Kakkilee to ngartiree ko'e mooɗon *Fariisa'en, ngam ɓe munafikiiɓe. ");
INSERT INTO fuh_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Walaa fuu ko suuɗi ko wanngintaake, walaa sirri duu ndi anndataake. ");
INSERT INTO fuh_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ko kaaluɗon nder nimre fuu, no nanetee yaasin laaɓɗo. Kaden duu ko nyo'uɗon nder cuuɗi ommbiiɗi fuu, no haaletee yaasin daane toowne. ");
INSERT INTO fuh_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Higiraaɓe am, miɗo haalana on : —To kulee warooɓe on ngam ko ƴaari ɗum walaa fuu ko ɓe mbaawi waɗande on. ");
INSERT INTO fuh_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Mi haalanan on moy kaanuɗon hulude. Kulee Alla ngam gaɗa maayde mooɗon kanko woodi baawɗe bugaade on nder jahannama. Nde goonga, miɗo wi'a on, kanko kaanuɗon hulude. ");
INSERT INTO fuh_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Pooloy njoyoy connataake tammaaje ɗiɗi naa ? Amma ɗum fuu waɗataa Alla yeggita baa gootel nder makkoy. ");
INSERT INTO fuh_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Baa leeɓi ko'e mooɗon fuu no limaaɗi faa laaɓi. Ndenne, to kulee, ngam oɗon ɓuri pooloy ɗukkoy koy teddungal. ");
INSERT INTO fuh_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Miɗo wi'a on : —Miin *Ɓii-Neɗɗo, bi'uɗo no anndi kam yeeso himɓe, miin duu, mi annditan joomum yeeso maleykaaɓe Alla. ");
INSERT INTO fuh_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Amma caliiɗo kam yeeso himɓe fuu, mi saloto ɗum miin duu yeeso maleykaaɓe Alla. ");
INSERT INTO fuh_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Neɗɗo fuu kaaluɗo ko boni dow *Ɓii-Neɗɗo, joomum no waawi yaafeede. Amma bonnuɗo innde *Ruuhu Ceniiɗo yaafataake. ");
INSERT INTO fuh_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Nde on njaaraama nder *baajorɗi, yeeso hooreeɓe naa laamiiɓe, to cuulee dow ko njaabotoɗon, naa ko kaaloton, ");
INSERT INTO fuh_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","ngam nder wakkati mum *Ruuhu Ceniiɗo anndinan on ko kaanuɗon haalude. ");
INSERT INTO fuh_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Nder jama'aare goɗɗo wi'i Iisa : —Moodibbo, wi'u mawnam sennda ndonu baabiimin, hokka kam mbaka am. ");
INSERT INTO fuh_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Sey Iisa jaabii mo, wi'i : —Hey aan ! Moy waɗi kam kiitotooɗo mooɗon naa ceendoowo njawdi mooɗon ? ");
INSERT INTO fuh_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Nden Iisa wi'i jama'aare ndeen : —Kakkilee he suuno njawdi, ngam hanaa njawdi wuurnata neɗɗo, baa nde tawi o diikuɗo sanne. ");
INSERT INTO fuh_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Iisa waɗani ɓe kippol haala ngool, wi'i : —Diikuɗo gom, gese mum ndimi sanne. ");
INSERT INTO fuh_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Sey omo ƴama omo ƴamtinoo hoore makko, omo wi'a : « Noy ngaɗanmi ? Ngam mi walaa fuu to mooɓanmi kaɓɓe am ? ");
INSERT INTO fuh_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ayyo, nii ngaɗanmi ! Mi fiirtan ƴeeli am, mi nyiɓa ɓurɗi manngu gom. Mi loowa kaɓɓe am e njawdi am fuu. ");
INSERT INTO fuh_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Nden mi wi'a hoore am : Mi heɓi njawdi mbaawni jogaade kam duuɓi e duuɓi. Mi fowti, mi nyaama, mi yara, mi nana belɗum. » ");
INSERT INTO fuh_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Amma Alla wi'i mo : « A haaŋaama ! Jemma oo da, mi jaɓan yonki maaɗa. Moy ronata ko kawranɗaa hoore maa ɗum ? » ");
INSERT INTO fuh_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Nden Iisa wi'i ɓe : —Ɗum woni ko hewtotoo neɗɗo fuu hawrani hoore mum njawdi nder duuniyaaru, fadde hawrande hoore mum njawdi yeeso Alla. ");
INSERT INTO fuh_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Gaɗa kippol haala dow diikuɗo ngool, Iisa wi'i *aahiiɓe mum : —Ndenne, miɗo wi'a on : To cuulee ko'e mooɗon nder mbuurnam mooɗon dow ko nyaamton naa dow ko ɓornotoɗon. ");
INSERT INTO fuh_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ngam mbuurnam no ɓuri nyaamdu, ɓanndu duu no ɓuri koltal. ");
INSERT INTO fuh_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ƴeewee gagaaje : Ɗe aawataa, ɗe kettataa. Ɗe ngalaa tukke, ɗe ngalaa ƴeeli, amma Alla no nyamna ɗe. Onon nee, oɗon ɓuri pooli ɗii teddungal ! ");
INSERT INTO fuh_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Moy he mooɗon waawi ɓeydude nyalooma gooto dow balɗe mum ngam hoore mum haɓɓake ? ");
INSERT INTO fuh_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ndenne, nde tawi on mbaawaa waɗude baa ko ɓuri famɗude ɗum, ɗume cuulantoɗon dow ko hoddii ? ");
INSERT INTO fuh_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ƴeewee no piindiiji ladde mawnirta : Ɗi ngollataa, ɗi mottataa. Amma miɗo haalana on : Baa Suleymaanu he darjaaji mum fuu holtiraay ko foti gootel nder majji. ");
INSERT INTO fuh_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Nde nii Alla no holtina huɗo taweteeko nder ngesa hannden, taƴeteeko faɗɗee nder hiite jaaŋo, ɗume haɗata mo holtinde on faa ɓura nii, onon famɗuɓe goonɗinol ? ");
INSERT INTO fuh_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","To cuulanee ko nyaamee e ko yaree. To mbemmbee ko'e mon ngam majjum ! ");
INSERT INTO fuh_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ngam kujje ɗee fuu, tokkuɓe duuniyaaru pilotoo. Nde goonga, Baabii'on no anndi ko oɗon kaajaa ɗum. ");
INSERT INTO fuh_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Amma tefee Laamu Alla, nden Alla ɓeydanan on kujje ɗee fuu. ");
INSERT INTO fuh_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","To kulee, onon sewre famarde, ngam *Baabiraawo mooɗon no nana belɗum hokkude on Laamu mum. ");
INSERT INTO fuh_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Connee ko njogiɗon, cakkon. Ngaɗanee ko'e mon ndesa ka bonataa. Kawron njawdi dow kammu ndi timmataa, ndi gujjo ɓadataako, mooƴu duu bonnataa. ");
INSERT INTO fuh_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ngam to njawdi mon woni, toon ɓerne mon duu wonata. ");
INSERT INTO fuh_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","—Ciryee, tunndoɗon, kuɓɓon fitillaaji mooɗon. ");
INSERT INTO fuh_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Laatee hano gollooɓe siryiiɓe jaɓɓaade joomi ɗum'en wakkati ƴuwata batu. No o yottorii, ɓe omtana mo. ");
INSERT INTO fuh_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Gollooɓe ɓe joomi ɗum'en tawi ɗaanaaki, mbelii ko'e. Miɗo haalana on goonga : O tunndoto, o wara o ngollana ɓe. O rotta, o joɗɗina ɓe nyaama. ");
INSERT INTO fuh_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Nde caka jemma naa nde fajiri non o warti, welɓe ko'e ngoni ɓe o tawi ɗaanaaki. ");
INSERT INTO fuh_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Nde nii jom wuro no anndi wakkati mo gujjo warta, o dooman mo, o haɗa mo naatude suudu makko. ");
INSERT INTO fuh_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Onon duu, ciryee, to gartol *Ɓii-Neɗɗo juhu on. ");
INSERT INTO fuh_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Piyer wi'i Iisa : —Joomam, kippol haala ngool, minen tan ngaɗanɗaa ngol naa himɓe fuu ? ");
INSERT INTO fuh_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Sey Iisa jaabii mo, wi'i : —Moy woni golloowo kolniiɗo, jom hakkillo ? Golloowo mo mawɗo mum halfini hokka maccuɓe mum gom mbaka mum'en nyaamdu nder wakkati mo haani. ");
INSERT INTO fuh_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Belɗo hoore woni golloowo mo mawɗo mum warti, tawi no waɗa golle mum. ");
INSERT INTO fuh_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Goonga kaalananmi on : Mawɗo oon halfinan mo njawdi mum fuu. ");
INSERT INTO fuh_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Amma nde golloowo oon wi'i nder ɓerne mum mawɗo mum wartilawtaa. Sey o fuɗɗa fiyude maccuɓe e horɓe ɓeen. Omo nyaama, omo yara, faa njaram nannga mo. ");
INSERT INTO fuh_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Too, mawɗo golloowo oo no wartan nyannde nde o miilaaka. Mawɗo makko riiwan mo, fiya mo sawru ɓe ngoonɗinaay Alla. ");
INSERT INTO fuh_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Golloowo annduɗo ko joomiiɗum hiɗi, dey siryaaki baafuy, naa gollaay ko joomiiɗum hiɗi, no fiyetee dorri ɗuɗɗi. ");
INSERT INTO fuh_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Amma golloowo mo anndaa ko joomiiɗum hiɗi, se waɗi ko foti fiyeede, no fiyetee dorri seɗɗa. Kokkaaɗo ko ɗuuɗi, no ƴamtetee ko ɗuuɗi. Kalfinaaɗo ko ɗuuɗi, no ƴamtetee ko ɓuri non ɗuudde. ");
INSERT INTO fuh_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","—Mi wari wattude hiite dow leydi ndii. Miɗo hari nge huɓɓa ! ");
INSERT INTO fuh_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","No woodi gaɗol *batisma mo kaanumi waɗaneede. Fadde makko waɗeede, miɗo nder suulaare. ");
INSERT INTO fuh_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Oɗon miila jam ngaddumi nder duuniyaaru naa ? Too, hanaa ! Miɗo wi'a on : Ko ngaddumi woni, ceendiigu. ");
INSERT INTO fuh_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Illa jooni himɓe joyo nder hoggo no ceedan. Tato kabda he ɗiɗo, ɗiɗo kabda he tato. ");
INSERT INTO fuh_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","*Baaba habdan he ɓiyum gorko, ɓiɗɗo gorko habdan he bammum. Inna habdan he ɓiyum debbo, ɓiɗɗo debbo habdan he innum. Esiyo debbo habdan he ɓaŋaaɗo mum, ɓaŋaaɗo habdan he esum debbo. ");
INSERT INTO fuh_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Iisa wi'i jama'aare ndeen : —Nde on ngi'ii ɓalinde har gorgal, dow ko yaawi on mbi'an ndiyam toɓan. Noon duu, ɗum laatorto. ");
INSERT INTO fuh_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Se henndu hoore huɗo wifi, on mbi'an ɗum wulan. Noon duu, ɗum laatorto. ");
INSERT INTO fuh_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Onon munaafiki'en ! Oɗon mbaawi senndude alamaaji leydi e kammu, dey ɗume waɗi on mbaawaa senndude alamaaji wakkati oo ? ");
INSERT INTO fuh_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Ɗume waɗi on mbaawaa anndande ko'e mooɗon ko dartii ? ");
INSERT INTO fuh_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Nde aɗa yaada he kabduɗo maa yeeso kiite, illa dow laawol tefu potal he makko. Nde hanaa non, nde on ngari yeeso kiitotooɗo oon, o wattete nder juuɗe doomoowo kasu, uddeɗaa. ");
INSERT INTO fuh_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Goonga kaalananmi ma, a wurtataako abada nde a yoɓaay ko tokketeɗaa ɗum faa laaɓa. ");
INSERT INTO fuh_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Nder wakkati mo Iisa haalannoo dow no alamaaji gaɗooji cenndodirtee, himɓe gom ngari kaalani mo ko Pilaatus, hooreejo leydi Yahudiya, waɗi ɓiɓɓe leydi Galili gom mbaraa wakkati ɓe ngaɗanannoo Alla sadaka. Ko ɓe mbaraa ƴiiƴeele maɓɓe kawrodiraa he ƴiiƴeele dabbaaji cakkaaɗi ɗiin. ");
INSERT INTO fuh_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Nden Iisa jaabii ɓe, wi'i : —Oɗon miila ko ɓiɓɓe Galili torraaɓe ɓee no ɓuri horiiɓe ɓeen hakke naa ? ");
INSERT INTO fuh_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Too, hanaa. Miɗo haalana on nde on tuubaay, onon duu on kalketee. ");
INSERT INTO fuh_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Oɗon miccitoo he ɓiɓɓe Galili sappo e njeetato, ɓe suudu Silowam toownu saamunoo dow mum'en faa maayi ɓeen, oɗon miila ko kamɓe ɓuri himɓe *Ursaliima fuu waɗude hakke naa ? ");
INSERT INTO fuh_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Miɗo haalana on nde on tuubaay, onon duu on kalketee. ");
INSERT INTO fuh_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Nden Iisa waɗani ɓe kippol haala ngool, wi'i : —Neɗɗo gom no woodunoo ibbi nder ngesa mum. Nyannde gom o wari faa o teɓa ki, amma o tawaay ɓinngel baa gootel he makki. ");
INSERT INTO fuh_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Sey o wi'i kakkiliiɗo ngesa ngaan : « Ndaa, duuɓi tati nii ko hitaane fuu miɗo wara faa mi teɓa ibbi kii, amma mi tawtaa ɓinngel baa gootel he makki. Soppu ki ! Nde walaa ko ki nafirta, ɗume ki waranta en nokkuure ndee fuu. » ");
INSERT INTO fuh_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Nden kakkiliiɗo ngesa ngaan wi'i mo : « Mawɗo am, accu ki hikka tan. Mi wasan senngooji makki fuu, mi watta birgiiri. ");
INSERT INTO fuh_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Tawte ki riman mawuuri. Nde ki rimaay, a waɗan ki soppee. » ");
INSERT INTO fuh_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","*Nyalaane fowteteene gom, Iisa no darii no waajoo nder *waajordu gom. ");
INSERT INTO fuh_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Debbo gom mo ladde larɗini no tawa nder mayru. Duuɓi sappo e jeetati ko debbo oo no turii faa waawtaa dartaade he hoore mum sam. ");
INSERT INTO fuh_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Wakkati Iisa hi'unoo debbo oo, noddi mo, wi'i : —Banndam debbo, a daɗii he nyaw maa. ");
INSERT INTO fuh_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Iisa deki juuɗe mum dow makko. Wakkati mum da, o dartii, omo teddina Alla. ");
INSERT INTO fuh_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Amma hooreejo *waajordu nduun nanaay belɗum majjum baa seɗɗa. Nden o wi'i himɓe ɓeen : —Balɗe jeegom kokkaɗen ngam gollude. Nder balɗe ɗeen kaanuɗon warde ngam yamɗintineede, amma hanaa nder *nyalaane fowteteene. ");
INSERT INTO fuh_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Sey Iisa jaabii mo, wi'i : —Munaafiki'en. Nder *nyalaane fowteteene hanaa neɗɗo mooɗon fuu no fiirta ngaari mum naa dakiya mum e tiggere, yarnowa. ");
INSERT INTO fuh_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Debbo oo no taanu *Ibrahim, mo Ibiliisa haɓɓiri duuɓi sappo e jeetati. O haanaa soptineede nder *nyalaane fowteteene naa ? ");
INSERT INTO fuh_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Wakkati Iisa haalunoo haala kaa, sey wayɓe makko fuu keewi semteene. Amma kujje kaayɗiniiɗe ɗe o waɗi ɗeen mbeli jama'aare ndeen fuu. ");
INSERT INTO fuh_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Nden Iisa wi'i kaden : —He ɗume Laamu Alla nanndi ? Ɗume nanndiniranmi ngu ? ");
INSERT INTO fuh_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Laamu Alla no nanndi he wabbere mutaari nde neɗɗo hooƴi, aawi nder koogol mum. Nde fuɗi, nde laatii lekki faa pooli no nyiɓa cuuɗi dow makki. ");
INSERT INTO fuh_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Iisa wi'i kaden : —Ɗume nanndiniranmi Laamu Alla ? ");
INSERT INTO fuh_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ingu nanndi he ƴuufinirɗum ɗum debbo watti nder muddiiji conndi alkama tati mawɗi, budi faa ɗum fuu ɗum ƴuufi. ");
INSERT INTO fuh_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Iisa no fa'i *Ursaliima. Omo tokka ci'e e gure tawaaɗe dow laawol makko, omo waajoo. ");
INSERT INTO fuh_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Sey goɗɗo ƴamii ɓe, wi'i : —Moodibbo, himɓe seɗɗa tan hisintee naa ? Iisa jaabii mo, wi'i : ");
INSERT INTO fuh_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Ndurwee heɓa naatiron dammbugal paaɗungal. Miɗo wi'a on : Ɗuɓɓe tefan naatude, keppa. ");
INSERT INTO fuh_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ngam wakkati waran mo jom ɓaade oon ummoto ommba dammbugal mum. No ndaroriɗon yaasin, oɗon calmina fuu, oɗon mbi'a : « Moodibbo ! Omtan min. » Jom ɓaade ndeen wi'an on : « Mi anndaa to njeyaɗon ! » ");
INSERT INTO fuh_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Nden, puɗɗon wi'ude mo : « A waajake nder laabi gure amin. Min nyaamdii he maa, min njardii he maa. » ");
INSERT INTO fuh_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Amma o jaaboto on, o wi'a : « Mi anndaa to njeyaɗon. Mboɗɗee kam, onon waɗooɓe ko boni. » ");
INSERT INTO fuh_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Wakkati ngi'uɗon *Ibrahim, Isiyaaku, Yakuuba, e annabiiɓe fuu nder Laamu Alla, onon duu oɗon ndiiwee, oɗon adee oɗon paɗɗee yaasin wakkati mum non mboyoton, oɗon ŋerƴodira nyiiƴe. ");
INSERT INTO fuh_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Himɓe ƴuwan lettugal e gorgal, soɓɓirde e hoore huɗo, ngara njooɗoo nyaamda nder Laamu Alla. ");
INSERT INTO fuh_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Nder wakkati oo non, ardiiɓe ɓeen keedata gaɗa, gaɗaaɓe ɓeen duu laatoo ardiiɓe. ");
INSERT INTO fuh_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Nder wakkati Iisa haalannoo dow Laamu Alla, sey *Fariisa'en gom ngari to makko, mbi'i mo : —Dillu, woɗɗa ɗo, ngam laamiiɗo *Hirudus no hiɗi ware. ");
INSERT INTO fuh_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Sey Iisa jaabii ɓe, wi'i : —Njehee mbi'owee junkuwel ngeel ko hannden e jaaŋo mi riiwan laɗɗe, mi nyawtan nyawɓe. Faɓɓi-jaaŋo timminanmi golle am fuu. ");
INSERT INTO fuh_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Amma no tilsi mi waɗa golle hannden, jaaŋo e faɓɓi-jaaŋo, ngam annabiijo haanaa maayde nokku feere gom mo hanaa *Ursaliima. ");
INSERT INTO fuh_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Hey *Ursaliima ! *Ursaliima, huɓeere warude annabiiɓe. A waririi *lilaaɓe he maaɗa kaaƴe ! Mi muuyi kile keewɗe hawrude ɓiɓɓe maa hano no gortogal hawrirta coppi mum ley bippoole nii. Amma a jaɓaay. ");
INSERT INTO fuh_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Joonin ɓaade mooɗon, kam nii no ɗon no woppee. Neɗɗo fuu jooɗotaako nder mayre. Nde laatotoo winnde. Miɗo wi'a on : On ngi'ataa kam illa joonin faa wara wakkati mo mbi'oyton : Barkinaaɗo woni garɗo dow innde Joomiraawo ! ");
INSERT INTO fuh_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","*Nyalaane fowteteene gom, Iisa naati ɓaade hooreejo *Fariisa'en gom faa nyaama. Wonnooɓe nder ɓaade ndeen no kora mo ƴeewa ko o watta. ");
INSERT INTO fuh_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Gorko mo ɓanndu mum ɓuuti gom, no darii yeeso makko. ");
INSERT INTO fuh_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Sey Iisa ƴami jannginooɓe *Tawreeta e *Fariisa'en gom, wi'i : —Yamɗintinde neɗɗo nder *nyalaane fowteteene, no hegii naa hegaaki ? ");
INSERT INTO fuh_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Amma ɓe nootaaki mo. Nden Iisa deki junngo dow jom ɓuddi oon, yamɗintini mo, acci mo o dilli. ");
INSERT INTO fuh_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Iisa wi'i ɓe kaden : —Moy he mooɗon, ɓiyum naa ngaari mum saamata nder ɓunndu heppa wurtinde ɗum law law, baa nde tawi ɗum waɗaanaa nder *nyalaane fowteteene ? ");
INSERT INTO fuh_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ɓe keppi jaabaade mo kaden. ");
INSERT INTO fuh_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Wakkati Iisa hi'unoo noddaaɓe ɓeen fuu ngari, neɗɗo maɓɓe fuu no suɓo jooɗorɗe ɓurɗe teddude. Sey o fillanii ɓe taariihi oo, o wi'i : ");
INSERT INTO fuh_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Nde nii a noddaama batu, taa jooɗa dow jooɗorgal ɓurngal teddude. Tawte ɓurɗo ma teddude gom waran, ");
INSERT INTO fuh_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","nden jom batu oon waran, wi'e : « Umma, hokku neɗɗo oo jooɗorgal ngaal ! » Cemtaa njooɗowoɗaa dow jooɗorgal ɓurngal leesude gom. ");
INSERT INTO fuh_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","—Amma nde nii a noddaama batu, jooɗowa ley, ngam jom batu oon no waran, wi'e : « Higo, umma, jooɗa dow ! » Ɗum laatane teddungal yeeso noddaaɓe-ngari ɓeen fuu. ");
INSERT INTO fuh_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ngam ƴettuɗo hoore mum dow, no leesintee. Leesinɗo hoore mum, no ƴettetee. ");
INSERT INTO fuh_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Nden o wi'i jom ɓaade, nodduɗo mo oon : —Nde aɗa nodda himɓe bottaari naa hiraane, taa noddu higiraaɓe maa, naa banndiraaɓe maa, naa koreeji maa, naa wonndiraaɓe maa riikuɓe tan. Ngam nde ɓe nodditii ma, ɗum laatotoo njobdi maa. ");
INSERT INTO fuh_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Nde a waɗi batu, noddu talkaaɓe, bonnguuɓe, laƴooɓe e wumɓe. ");
INSERT INTO fuh_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","A welan hoore, ngam ɓe ngalaa ko ɓe njoɓire. A heɓan duu baraaje nyannde ummitaaki dartiiɓe. ");
INSERT INTO fuh_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Wakkati gooto nder nyaamdooɓe he Iisa ɓeen nanunoo ko Iisa wi'i jom ɓaade ndeen, sey o wi'i Iisa : —Nyaamoowo nder batu Laamu Alla, welii hoore. ");
INSERT INTO fuh_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Nden Iisa jaabii mo, wi'i : —Gorko gom waɗi batu manngu, noddi himɓe ɗuɓɓe. ");
INSERT INTO fuh_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Wakkati nyaamdu nduun gasunoo, sey o lili golloowo makko gom wi'owa noddaaɓe-ngara ɓeen, siri batu oon fuu gasi. ");
INSERT INTO fuh_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Sey gooto gooto, ɓe ngaɗi ko eelude mo o accana ɗum'en hakke, o yaafoo ɓe. Arano oon wi'i mo : « Mi soodii ngesa, no tilsi mi yaha mi hi'owa nga, mi ŋaarake ma, yaafam. » ");
INSERT INTO fuh_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ɗiɗaɓo oon duu wi'i mo : « Mi soodii ga'i demooji sappo e demirɗe joy. Miɗo hiɗi sii'aade ɗi, mi ŋaarake ma, yaafam. » ");
INSERT INTO fuh_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Tataɓo oon wi'i kam duu : « Ɓooyaay ko ɓaŋumi, ndenne mi heɓataa wari. » ");
INSERT INTO fuh_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Wakkati golloowo oon warti, haalani mawɗo mum ko wi'aa. Sey jom batu oon ɓerni, wi'i mo : « Yawɗa yah dow laabi mawɗi nder wuro ngoo e nder nokkuuje to himɓe kawrata, noddaana kam talkaaɓe, bonnguuɓe, wumɓe e laƴooɓe. » ");
INSERT INTO fuh_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Nden golloowo oon yehi warti, wi'i : « Alla sabbinane, mi waɗi ko mbi'uɗaa kam fuu. Amma faa jooni nokku no hoddii. » ");
INSERT INTO fuh_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Nden jom batu oon wi'i mo : « Yah dow laabi mawɗi e pamari. Mo keɓuɗaa fuu, tilsina ɗum wara naata, ngam suudu am nduu heewa. ");
INSERT INTO fuh_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nde goonga miɗo wi'a on : Baa gooto nder ɓe noddunoomi ɓee meeɗataa nyaamdu am. » ");
INSERT INTO fuh_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Nyannde gom jama'aare mawne gom no yaada he Iisa, sey Iisa yeeƴitii ɓe, wi'i : ");
INSERT INTO fuh_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Neɗɗo fuu hiɗi tokki kam, nde mi ɓuranaay ɗum : Innum naa bammum, deekum naa sukaaɓe mum, mawniraaɓe mum naa minyiraaɓe mum, nde mi ɓuranaa ɗum hoore mum. Too, joomum waawtaa laataade aahiijo am. ");
INSERT INTO fuh_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Neɗɗo fuu mo wakkaaki *leggal mum bardugal tokki kam, waawtaa laataade aahiijo am. ");
INSERT INTO fuh_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ngam nde hakkune mooɗon no tawa giɗɗo nyiɓa suudu toownu, hanaa sey nde joomum jooɗake ginan, hiiso ko ndu nyaamata ɗum, ƴeewa nde no jogii ko huumnata ndu naa. ");
INSERT INTO fuh_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Nde hanaa non duu, joomum diidan ndu, heppa hantude ndu. Gi'uɗo ndu fuu no yawoto mo, ");
INSERT INTO fuh_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","wi'a : « Ƴeewee neɗɗo oo. O fuɗɗi nyiɓude, o heppi humnude. » ");
INSERT INTO fuh_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Naa, nde laamiiɗo no jogii soogeeji ujunaaji sappo, nde adi niiya honoyde laamiiɗo gooduɗo soogeeji ujunaaji laso. Hanaa sey nde o jooɗake o miiloo goonga fuu omo woodi semmbe jaalaade worɓe ujunaaji laso ɓeen, naa o walaa ? ");
INSERT INTO fuh_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Nde o waawtaa, o waɗan lilaaɓe kaalanowa ɓe illa iɓe mboɗɗii, ngam laawol jam waɗa hakkune maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Hano non duu, neɗɗo mooɗon fuu waawtaa laataade aahiijo am nde woppaay ko jogii fuu. ");
INSERT INTO fuh_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Lamɗam no wooɗi, amma nde ɗam lamsataa, ɗume lamsinta ɗam kaden ? ");
INSERT INTO fuh_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Walaa fuu ko ɗam waawata nafude nder leydi, naa nder birgiiri. Ɗam bugetee yaasin. Jom nowru nanooru fuu, nana ! ");
INSERT INTO fuh_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Nyannde gom *jaɓooɓe janngal he waɗooɓe hakke gom ngari to Iisa ngam kettinoo waaju makko. ");
INSERT INTO fuh_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Sey *Fariisa'en e jannginooɓe *Tawreeta tinni no nguuntoo hakkune mum'en, no mbi'a : —Neɗɗo oo no jaɓɓo waɗooɓe hakke, omo nyaamda he maɓɓe ! ");
INSERT INTO fuh_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Nden Iisa waɗani ɓe kippol haala ngool, wi'i : ");
INSERT INTO fuh_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Nde gooto nder mooɗon no woodi baali hemre, sey ngootu majjaa. O accan baali hemre go'o walaa ɗiin ndura, o tefowa majjungu nguun faa o hiita ngu. ");
INSERT INTO fuh_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Nde o hiitii ngu, o heewa welwelo, nden o wakkoo ngu, o yaara wuro. ");
INSERT INTO fuh_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","O hawra higiraaɓe e wonndiraaɓe makko fuu, o wi'a ɓe : « Accee mbelnen ngam mi hiitii mbaalu am majjunoongu nguun. » ");
INSERT INTO fuh_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Miɗo haalana on : Non welwelo duu waɗirta dow kammu nde nii gaɗoowo hakke gooto tuubii. Welwelo gaɗoowo dow ngoon ɓuran welwelo dartiiɓe hemre go'o walaa, ɓe kaajaaka tuubude. ");
INSERT INTO fuh_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","—Misaali wi'ee joonin debbo gom nii no woodi tammaaje cardi sappo, dey gootal majjoraa mo. Hanaa o huɓɓan fitilla, o wuuwa suudu makko, o tefira ngal hakkillo faa nde o hiitii ngal naa ? ");
INSERT INTO fuh_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Nde o hiiti tammal ngal, o hawran higiraaɓe makko rewɓe e wonndiraaɓe makko rewɓe, o wi'a ɓe : « Accee mbelnen ngam mi hiitii tammal am majjunoongal. » ");
INSERT INTO fuh_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Too, hano non welwelo laatoranto maleykaaɓe Alla, nde nii gaɗoowo hakke gooto tuubii. ");
INSERT INTO fuh_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Iisa wi'i kaden : —Gorko gom no woodunoo ɓiɓɓe worɓe ɗiɗo. ");
INSERT INTO fuh_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Nyannde gom minyiyo oon wi'i baaba mum : « Baaba, hokkam mbaka am nder ndonu amin. » Sey baaba oon senndi njawdi mum hakkune ɓiɓɓe ɓeen. ");
INSERT INTO fuh_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Balɗe seɗɗa gaɗa mum, minyiyo oon hawri ko jogii fuu, dilli, yehi leydi mboɗɗuni gom. O tokkitii fijirde faa o bonni njawdi makko fuu. ");
INSERT INTO fuh_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Wakkati o timminnoo ndi ndeen, rafo manngo gom waɗi nder leydi ndiin. Sey o fuɗɗi naatude nder rafi. ");
INSERT INTO fuh_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","O yehi o takkowi he ɓii-leydi ndiin gom. Ɓii-leydi ndiin, yaari mo nder gese mum, o durowa girooji mum. ");
INSERT INTO fuh_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","O rafaa faa omo tefa nyaamude nyaamdu girooji ɗiin, amma walaa kokkuɗo mo ndu. ");
INSERT INTO fuh_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Sey ɓerne makko warti he wuro, o wi'i hoore makko : « Gollooɓe baaba am no nyaama faa hodda, amma joonin, miin nii ɗo, miɗo maayda rafo. ");
INSERT INTO fuh_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Mi ummoto non, mi hoota hoggo baaba am mi wi'a mo : Baaba, mi waɗi hakke yeeso Alla. Mi waɗi hakke to maaɗa. ");
INSERT INTO fuh_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Mi fotaay baa wi'eede ɓiya. Joonin adan hano golloowo maa ! » ");
INSERT INTO fuh_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Nden o ummii, o fa'i to baabiiko. Illa to woɗɗi, baabiiko holliri mo, nani yurmeene makko sanne. Nden doggi, wunndowii mo. ");
INSERT INTO fuh_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Sey o wi'i baabiiko : « Baaba, mi waɗi hakke yeeso Alla. Mi waɗi hakke to maaɗa. Mi fotaay baa wi'eede ɓiya. » ");
INSERT INTO fuh_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Nden baaba oon wi'i maccuɓe mum gom : « Njehee law, ngaddowee jabbaare ɓurne wooɗude, ɓornon mo. Ngattanon mo hootande he honndu makko, ɓornon mo paɗe. ");
INSERT INTO fuh_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ngaddon ngaari payni, kirson, nyaamen, mbelnen. ");
INSERT INTO fuh_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ngam ɓiyam mo miilunoomi maayi oo no wuuri. Ɓiyam majjunooɗo oo hiitaama. » Nden ɓe puɗɗi welnude. Amma wakkati ɓe mbelnannoo ndeen, mawniraawo oon no gese. ");
INSERT INTO fuh_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Mawniraawo oon ummii gese no warta. Wakkati ɓadinoo, sey nani bawɗi e bomi no ngaɗa nder ɓaade mum'en. ");
INSERT INTO fuh_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","O noddi golloowo maɓɓe gom, o ƴami ko woni no waɗa. ");
INSERT INTO fuh_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Oon jaabii mo wi'i : « Minya warti jam. Baaba maa hirsani mo ngaari payni. » ");
INSERT INTO fuh_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Sey mawniraawo oon ɓerni, salii naatude ɓaade ndeen. Baabiiko wurtii, sawrini mo o naata. ");
INSERT INTO fuh_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Nden o wi'i baabiiko : « Ndaa, mi gollanii ma duuɓi he duuɓi, baa nde worre mi salaaki tilsinooje maa. Baa nde worre a hokkaay kam damngel, miin e higiraaɓe am, min mbelna. ");
INSERT INTO fuh_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Amma ɓiya oo, nyaamuɗo njawdi maa fuu, he rewɓe fijooɓe, warta dey kirsanaa ɗum ngaari payni ndii. » ");
INSERT INTO fuh_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Sey baabiiko jaabii mo, wi'i : « Ɓinngel am, enen ngondi wakkati fuu, ko njeymi fuu, aan jeyii ɗum. ");
INSERT INTO fuh_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Minya mo miilunoomi maayi oo no wuuri. Minya majjunooɗo oo hiitaama. Ndenne, no haani ngaɗen batu, mbelnen. » ");
INSERT INTO fuh_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Nyannde gom Iisa wi'i *aahiiɓe mum : —Diikuɗo gom no woodi kawjotooɗo njawdi mum gom. O haalanaama ko kawjotooɗo njawdi makko oo, no ɗon no bonna njawdi makko. ");
INSERT INTO fuh_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Nden nyannde gom o noddi mo, o wi'i : « Ɗume woni ko nanumi no fillee dow maa ɗum ? War, kiisoɗen ko kalfinmaami, ngam a hawjataako njawdi am kaden. » ");
INSERT INTO fuh_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Sey kawjotooɗo njawdi oon wi'i hoore mum : « Noy ngaɗanmi ? Ngam mawɗo am ittan kam golle. Mi walaa semmbe remude, miɗo semta fiyude mbara. ");
INSERT INTO fuh_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ahaa ! Miɗo anndi no ngaɗanmi ko nde mi ittaama golle, mi heɓa jaɓɓiiɓe kam nder kowle mum'en. » ");
INSERT INTO fuh_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Nden ɓe mawɗo makko tokkata nyamaane ɓeen, o noddi ɗum'en gooto gooto. Arano oon o wi'i ɗum : « Foti mawɗo am tokkete ? » ");
INSERT INTO fuh_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Oon wi'i mo : « Bidooji nebbam hemre tokketeemi. » Nden kawjotooɗo oon wi'i mo : « Hooƴu dewtere maa nyamaane, jooɗa law, mbinndaa woygu. » ");
INSERT INTO fuh_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ɗiɗaɓo oon o wi'i ɗum : « Aan nee, foti tokketeɗaa ? » Oon jaabii mo wi'i : « Saakuuji alkama keme joy tokketeemi. » Sey o wi'i mo kanko duu : « Hooƴu dewtere maa nyamaane, mbinndaa saakuuji keme nay. » ");
INSERT INTO fuh_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ƴoƴe kawjiiɗo njawdi ɗee ngaɗi gorko diikuɗo oon mani mo. Mi hokkii on misaali oo non ngam paamon ko himɓe duuniyaaru no ɓurdi ƴoƴe hakkune mum'en dina himɓe jeyngol. ");
INSERT INTO fuh_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Miin, miɗo wi'a on : Ngolliree njawdi duuniyaaru heɓa keɓon higiraaɓe ngam nde njawdi ndiin re'i njaɓɓeɗon nder wuro Alla ngo faa abada abadin. ");
INSERT INTO fuh_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Kolluɗo aadilaaku nder kujje pamare, hollan aadilaaku nder kujje mawɗe. Kolluɗo jammbi nder kujje pamare, hollan jammbi nder kujje mawɗe duu. ");
INSERT INTO fuh_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ndenne, nde on kollaay aadilaaku nder njawdi duuniyaaru nduu, moy halfinta on njawdi ngooŋaari ? ");
INSERT INTO fuh_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Kaden duu, nde on kollaay aadilaaku nder njawdi jananndi, moy hokkata on ko njeyɗon ? ");
INSERT INTO fuh_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Golloowo fuu waawtaa gollande mawɓe ɗiɗo, ngam joomum wanyan gooto, hiɗaa ooto, naa teddina gooto, yawo ooto. On mbaawtaa gollande Alla ngollanon njawdi. ");
INSERT INTO fuh_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Wakkati *Fariisa'en, suunaaɓe ceede ɓeen nanunoo ɗum, ɓe njaltinii mo. ");
INSERT INTO fuh_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Sey o wi'i ɓe : —Onon, oɗon ngiɗi laataade dartiiɓe yeeso himɓe, amma Alla no anndii ɓerɗe mooɗon. Ngam ko himɓe teddinta hakkune mum'en, kam woni ko harminii yeeso Alla. ");
INSERT INTO fuh_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","*Tawreeta e dewte annabiiɓe ngoni no ndawrana himɓe faa yottii he garki Yahaaya. Amma Yahaaya gaɗoowo *batisma wari, *Habaru lobbo filla dow Laamu Alla no waajee. Neɗɗo fuu no durwa naata nder maggu. ");
INSERT INTO fuh_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Taggol kammu e leydi no ɓuri hoyde dina ittude toɓɓel gootel nder *Tawreeta. ");
INSERT INTO fuh_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Neɗɗo fuu ceerɗo deekum ɓaŋi goɗɗo, yeeni. Kaden duu ɓaŋuɗo debbo ceeraaɗo, kam duu yeeni. ");
INSERT INTO fuh_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","—Waɗiino gorko diikuɗo gom, ɓornotooɗo kolte lobbe, caadiiɗe sanne. Wakkati fuu omo nder weltaare. Omo nyaama ko weli mo. ");
INSERT INTO fuh_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Laajaru, no talka. Ɓanndu makko fuu no ɓuuye. Wakkati fuu omo waddee omo fukkinee dammbugal ɓaade diikuɗo oo. ");
INSERT INTO fuh_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","O wanyaa nyaamude baa ko ƴuwi nder nyaamdu diikuɗo oon, saami dow leydi. Dawaaɗi duu no ngara no metta ɓuuye makko. ");
INSERT INTO fuh_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Nyannde gom sey talka oon maayi. Maleykaaɓe njaari mo to *Ibrahim. Diikuɗo oon duu maayi, ufaa. ");
INSERT INTO fuh_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Omo torroo sanne laahara, sey o ɓanti hoore makko, o holliri *Ibrahim to woɗɗi, Laajaru no hadde mum. ");
INSERT INTO fuh_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Sey diikuɗo oon huuɓi, wi'i : « Hiite ngee torri kam sanne. Maama am *Ibrahim, yurmam. Lilu Laajaru suuwa kollel mum seɗɗa nder ndiyam, o wara o simtina dow ɗemngal am, mi feewa. » ");
INSERT INTO fuh_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Nden *Ibrahim jaabii mo, wi'i : « Ɓinngel am, miccita a heɓiino kujje lobbe nder mbuurnam maa, amma Laajaru kay bone tan yari. Joonin, o heɓan jam, aan duu torroɗaa. ");
INSERT INTO fuh_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Gaɗa mum duu, ngayka mawka tawaa hakkune amin he mooɗon. Ka wattaama ngam hiɗuɓe ummaade to amin, njeha to mooɗon naa hiɗuɓe ƴuwde to mooɗon ngara to amin, keppa yahde. » ");
INSERT INTO fuh_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Nden diikuɗo oon wi'i mo : « Ndenne maama am, mi ŋaarake ma, lilu Laajaru nder hoggo baaba am, ");
INSERT INTO fuh_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ngam miɗo woodi banndiraaɓe worɓe joyo toon, o famtina ɓe, ngam to ɓe ngaru kamɓe duu nder nokkuure heewne torra ndee. » ");
INSERT INTO fuh_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Nden *Ibrahim wi'i mo : « Iɓe njogii *Tawreeta Muusa e dewte annabiiɓe, accu ɓe kettinoo ko ɗe mbi'ataa. » ");
INSERT INTO fuh_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Sey o jaabii *Ibrahim, o wi'i : « Yaa *Ibrahim ! Hettinaade dewte ɗee tan heƴataa. Amma nde goɗɗo ummitake yehi to maɓɓe haalani ɓe, ɓe tuuban. » ");
INSERT INTO fuh_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Nden *Ibrahim wi'i mo : « Nde nii hettinaade haalaaji *Muusa e annabiiɓe heƴaay ɓe tuuba, too, baa nde goɗɗo ummitii yehi to maɓɓe, ɓe ngoonɗintaa. » ");
INSERT INTO fuh_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Nyannde gom Iisa wi'i *aahiiɓe mum : —Sikka walaa no woodi ko tutotoo himɓe ngaɗa hakke. Amma bone saama dow neɗɗo fuu laatii sabiili majjum. ");
INSERT INTO fuh_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Kaaƴa mannga haɓɓee he daane joomum, faɗɗee nder maayo, no ɓuri hoyande joomum, dina waɗude gooto nder cukaloy koy waɗa hakke. ");
INSERT INTO fuh_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ndenne, kakkilee e ko'e mooɗon. Nde banndiraawo maa waɗanii ma hakke, felu mo. Nde o tuubii, njaafoɗaa mo. ");
INSERT INTO fuh_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Nde o waɗanii ma hakke kile jeɗɗi nder nyalooma, nde o wari to maa kile jeɗɗi omo tuubane, yaafa mo. ");
INSERT INTO fuh_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Sey *lilaaɓe ɓeen mbi'i Iisa : —Ɓeydu goonɗinol amin. ");
INSERT INTO fuh_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Iisa jaabii ɓe, wi'i : —Nde goonɗinol mooɗon no famɗi faa foti gabbel mutaari, nde on mbi'ii lekki kii ɗoofo, sinngowoo nder maayo, ki ɗowtanto on. ");
INSERT INTO fuh_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Nder mooɗon moy demoowo naa duroowo mum ƴuwata ladde dey wi'a mo wakkati oon ndaa : « Yaawnu war nyaamu »  ? ");
INSERT INTO fuh_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Hanaa sey joomum wi'a mo : « War, jonngu nyaamdu, ngaddanaa kam mi nyaama mi yara. Nden nyaamowaa, aan duu »  ? ");
INSERT INTO fuh_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Oɗon miila o yettan golloowo oon ngam waɗi ko haani waɗude naa ? ");
INSERT INTO fuh_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Hanaa. Onon duu, nde on ngaɗi huune fuu ko kaanuɗon waɗude, sey mbi'on ko'e mooɗon : « Min maccuɓe tan. Min ngaɗi ko min kaani waɗude. » ");
INSERT INTO fuh_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Wakkati Iisa yehannoo *Ursaliima, o tokki hakkune leydi *Samariya e leydi Galili. ");
INSERT INTO fuh_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","No o naatiri wuro gom, non worɓe seppinɓe sappo gom ngari potti he makko. Ɓe ndarii to toowti, ");
INSERT INTO fuh_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ɓe kuuɓi, ɓe mbi'i : —Iisa, Moodibbo, yurma min ! ");
INSERT INTO fuh_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Wakkati Iisa hi'unoo ɓe, sey o wi'i ɓe : —Njehee, kollowee ɓalli mooɗon *cakkanooɓe Alla. Wakkati ɓe njehannoo, iɓe dow laawol, sey ɓe njamɗiti. ");
INSERT INTO fuh_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Gooto maɓɓe, wakkati hi'unoo kam yamɗiti, soƴƴii. Omo yeha omo teddina Alla he daane toowne. ");
INSERT INTO fuh_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","O wari, o jimminii yeeso Iisa faa he leydi, o yetti mo. Gorko oo no ɓii-leydi *Samariya. ");
INSERT INTO fuh_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Iisa fiirti hunnduko, wi'i : —Tawte hanaa sappo ɓeen fuu njamɗintinaa ? Toy njeenayo ɓeen nee ngoni ? ");
INSERT INTO fuh_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Koɗo oo tan miili soƴƴitaade teddina Alla naa ? ");
INSERT INTO fuh_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Nden Iisa wi'i gorko oon : —Umma dillu, ngam goonɗinol maa dannii ma. ");
INSERT INTO fuh_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","*Fariisa'en gom ƴami Iisa mbi'ii : —Wakkati oye Laamu Alla warta ? Nden o jaabii ɓe, o wi'i : —Hitere hi'ataa no Laamu Alla warirta. ");
INSERT INTO fuh_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Neɗɗo fuu waawaa wi'i ingu ɗoo naa ingu too, ngam Laamu Alla no hakkune mooɗon. ");
INSERT INTO fuh_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Sey Iisa wi'i *aahiiɓe mum : —Wakkati waran mo ngiɗɗon hi'ude *Ɓii-Neɗɗo baa nii nyalooma gooto non, amma on ngi'ataa mo. ");
INSERT INTO fuh_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","On mbi'etee : « Ndaa omo ɗo ! » naa « Ndaa omo too ! » Amma to njehee, to ndoggiree toon. ");
INSERT INTO fuh_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ngam hano no maƴƴere maƴƴirta nder kammu keerol yahde keerol, hano non *Ɓii-Neɗɗo lattoo nyannde gartol mum. ");
INSERT INTO fuh_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Amma no tilsi o torree sanne ginan, himɓe jamaanu oo caloo mo. ");
INSERT INTO fuh_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Hano nii no ɗum waɗirnoo nder jamaanu Nuhu, hano non ɗum waɗan nder balɗe ɗe *Ɓii-Neɗɗo wartoyta. ");
INSERT INTO fuh_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Himɓe no nyaama, no njara, no ɓaŋa, no ɓaŋee, faa nyannde Nuhu naati laana kaan. Nii ndiyam tuufaana wari, halki ɓe, ɓe fuu. ");
INSERT INTO fuh_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Iri majjum duu waɗiino nder jamaanu Luutu. Himɓe no nyaama, no njara, no cooda, no conna, no aawa, no nyiɓa. ");
INSERT INTO fuh_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Amma wakkati Luutu wurtinoo *Sodooma, Alla toɓini norɗe hiite e sinaadar dow maggo. O halki ɓe, ɓe fuu. ");
INSERT INTO fuh_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Non duu ɗum waɗirta nyannde *Ɓii-Neɗɗo wanngata. ");
INSERT INTO fuh_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Nyannde mum, tawaaɗo dow suudu, nde tawi are mum no nder suudu, to jippoo wi'a hooƴan ɗe. Tawaaɗo ngesa, to wi'u hootan wuro. ");
INSERT INTO fuh_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Miccitee ko hewti dee-Luutu. ");
INSERT INTO fuh_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Tefuɗo hisinde yonki mum nder duuniyaaru nduu, mursan ki. Amma mursuɗo ki, hisinan ki. ");
INSERT INTO fuh_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Miɗo haalana on, nder jemma mum, on ngi'an himɓe ɗiɗo fukkiiɓe dow leeso wooto. Gooto hooƴee, ooto accee. ");
INSERT INTO fuh_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Rewɓe ɗiɗo wonɓe no unida nder wowru worru. Gooto hooƴee, ooto accee.  ");
INSERT INTO fuh_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Worɓe ɗiɗo wonɓe nder ngesa ngoota. Gooto hooƴee, ooto accee. ");
INSERT INTO fuh_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Nden *aahiiɓe ɓeen ƴami mo, mbi'i : —Moodibbo, toy ɗum waɗata ? O jaabii ɓe, o wi'i : —To canngu woni, ɗon jigaaje kawrata. ");
INSERT INTO fuh_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Iisa waɗani *aahiiɓe mum kippol haala ngool ngam hollude ɓe ko no haani ɓe tittinkinoo nder waɗude du'aa'u, to ɓe comu waɗude du'aa'u. ");
INSERT INTO fuh_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","O wi'i ɓe : —Wuro gom woodi kiitotooɗo gom mo hulataa Alla. Walaa duu mo o semtataa. ");
INSERT INTO fuh_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Debbo gom mo gorum maayi, no tawaa nder wuro ngoon. Wakkati fuu omo wara to kiitotooɗo oon, omo wi'a mo : « Hiita hakkune am, miin he kabduɗo am. » ");
INSERT INTO fuh_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Kiitotooɗo oon ɓooyi no saloo kiite ɗeen. Ko sakitii sey o wi'i hoore makko : « Mi hulataa Alla, mi semtataa gooto duu. ");
INSERT INTO fuh_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Debbo oo tampinii kam. Mi hiitoto hakkune maɓɓe ngam to o war omo fusana kam noppi wakkati fuu. » ");
INSERT INTO fuh_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Iisa wi'i ɓe kaden : —On nani naa ko kiitotooɗo bonɗo oon wi'i ! ");
INSERT INTO fuh_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","He giiɗe mooɗon, Alla ittataa hakke suɓaaɓe mum, woyooɓe jemma e nyalooma no eela ɗum ɓee fuu naa ? O jaabataako law law bojji maɓɓe naa ? ");
INSERT INTO fuh_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Miɗo wi'a on : O jaaboto ɗi dow ko yaawi. Amma ko ƴamanmi woni nde *Ɓii-Neɗɗo wartowi, tawan goonɗinɓe nder duuniyaaru naa ? ");
INSERT INTO fuh_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","No woodi daarooɓe ko'e mum'en no dartiiɓe, iɓe njawoo woɓɓe duu. Daliila himɓe ɓee waɗi Iisa waɗi kippol haala ngool, wi'i ɓe : ");
INSERT INTO fuh_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Worɓe ɗiɗo naati *Juulirde mawne faa ndu'oo. Gooto no *Fariisaajo, ooto duu no jaɓoowo janngal. ");
INSERT INTO fuh_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Fariisaajo oon darii no du'oo nder ɓerne mum no wi'a : « Alla, mi yettii ma ngam mi laataaki iri himɓe gom, misaali ir wuyɓe, bonɓe, yeenooɓe. Mi yettii ma ko mi laataaki hano jaɓoowo janngal oo duu. ");
INSERT INTO fuh_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Jeɗɗiire fuu miɗo suumo kile ɗiɗi, miɗo itta *jakka dow ko keɓumi fuu. » ");
INSERT INTO fuh_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Jaɓoowo janngal oon no darii to toowti, suusaay baa tiggitaade kammu, nani semteene, no wi'a : « Yaa Alla ! Yurmam, mi gaɗoowo hakke. » ");
INSERT INTO fuh_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Nden Iisa wi'i *aahiiɓe mum : —Miɗo wi'a on, jaɓoowo janngal oon hooti wuro mum, hakkeeji makko njaafaama. Amma Fariisaajo oon hakkeeji mum njaafaaka. Miɗo wi'a on ƴettuɗo hoore mum dow, no leesintee. Leesinɗo hoore mum, no ƴettetee. ");
INSERT INTO fuh_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Nyannde gom himɓe ngaddi cukaloy mum'en keccoy gom to Iisa, ngam o yowa juuɗe dow makkoy. Amma wakkati *aahiiɓe makko ngi'unoo ɗum, ɓe nduki ɓe. ");
INSERT INTO fuh_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Sey Iisa noddi *aahiiɓe mum, wi'i ɓe : —Accee cukaloy koy ngara to am. To kaɗee koy, ngam nannduɓe he makkoy njeyaa nder Laamu Alla. ");
INSERT INTO fuh_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Goonga kaalananmi on, mo jaɓɓoraaki Laamu Alla hano no cukalel ngel jaɓɓoraa nii, joomum naatataa nder maggu. ");
INSERT INTO fuh_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Hooreejo *Yahudankooɓe gom ƴamii Iisa, wi'i : —Moodibbo lobbo, ɗume kaanumi waɗude ngam heɓude mbuurnam nduumiiɗam ? ");
INSERT INTO fuh_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Iisa jaabii mo, wi'i : —Ngam ɗume noddirtaa kam lobbo ? Lobbo fuu walaa sey Alla. ");
INSERT INTO fuh_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Aɗa anndi ko tilsinooje *Tawreeta mbi'ii : To yeenu, to ittu yonki goɗɗo, to wujju, to seedana fewre. Teddin inna maa e bammaa. ");
INSERT INTO fuh_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Sey hooreejo *Yahudankooɓe oon jaabii Iisa, wi'i : —Miɗo tokki kujje ɗee fuu illa nder cukaaku am. ");
INSERT INTO fuh_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Wakkati Iisa nanunoo ɗum, wi'i mo : —Huune worre tan hoddanii ma. Sonnoy ko njogiɗaa fuu, njeddana talkaaɓe, a heɓan baraaje dow. Nden, ngaraa tokkaa kam. ");
INSERT INTO fuh_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Hooreejo *Yahudankooɓe oon no diikuɗo mawɗo. Wakkati o nanunoo haalaaji ɗii, o ɓalinii tik, o dillidi mettorgal ɓerne. ");
INSERT INTO fuh_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Sey Iisa ƴeewi mo, wi'i : —Naatol riikuɓe nder Laamu Alla no tiiɗi faa ! ");
INSERT INTO fuh_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ngam naatol ngolooba nder wudde battal no ɓuri hoyde dina naatol diikuɗo nder Laamu Alla ! ");
INSERT INTO fuh_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Hettinaniiɓe mo mbi'ii : —Ndenne, moy hisataa ? ");
INSERT INTO fuh_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Sey Iisa jaabii ɓe, wi'i : —Ko heppori ɓii-aadama hepportaa Alla. ");
INSERT INTO fuh_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Piyer jaabii, wi'i : —Minen, min mboppi ko min njogii fuu, min tokkii ma ! ");
INSERT INTO fuh_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Sey Iisa wi'i ɓe : —Miɗo haalana on goonga, accuɗo wuro mum, naa deekum, naa rimdaaɓe mum, naa saarooɓe mum, naa sukaaɓe mum ngam Laamu Alla, ");
INSERT INTO fuh_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","no heɓan ko ɓuri ɗum kile ɗuɗɗe nder wakkati mo ngonɗen nder mum jooni. Joomum no heɓan duu mbuurnam nduumiiɗam nder wakkati garoowo oon. ");
INSERT INTO fuh_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Iisa henni *lilaaɓe sappo e ɗiɗo ɓeen senngo, wi'i ɓe : —Kettinee, eɗen ɗon eɗen njaha *Ursaliima. Toon ko annabiiɓe mbinndunoo dow *Ɓii-Neɗɗo fuu, huuɓata. ");
INSERT INTO fuh_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ngam o wattetee nder juuɗe ɓe kanaa *Yahudankooɓe, ɓe njawoo mo, ɓe njenna mo, ɓe tutta dow makko, ");
INSERT INTO fuh_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ɓe piya mo dorri, ɓe mbara mo. Amma nyalaane tataɓere mum o ummitittoo. ");
INSERT INTO fuh_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Amma *aahiiɓe ɓeen paamaay haala kaa sam. Maana makka suuɗanake ɓe, ngam majjum waɗi ɓe paamaay ko o hiɗi wi'ude ɓe. ");
INSERT INTO fuh_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Wakkati Iisa ɓadinoo Yeriko, o tawi bumɗo gom no jooɗii no garbina takkol laawol. ");
INSERT INTO fuh_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Wakkati bumɗo oon nanunoo mbittaaki jama'aare ndeen, sey o ƴami himɓe ko woni no waɗa. ");
INSERT INTO fuh_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Nden ɓe njaabii mo, ɓe mbi'i : —Iisa mo Nasaratu woni no yawta. ");
INSERT INTO fuh_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Nden o huuɓi, o wi'i : —Iisa, taanu Daawda, yurmam ! ");
INSERT INTO fuh_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Wonɓe yeeso jama'aare ɓeen puɗɗi no cajitoo he makko, no mbi'a o deƴƴita. Amma o huuɓi kaden, o wi'i : —Taan Daawda, yurmam ! ");
INSERT INTO fuh_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Iisa darii, wi'i ɓe ngadda mo to mum. Wakkati o ɓadinoo Iisa, Iisa ƴami mo, wi'i : ");
INSERT INTO fuh_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—Ɗume ngiɗaa mi waɗane ? Nden o jaabii, o wi'i : —Moodibbo, miɗo hiɗi mi wumta. ");
INSERT INTO fuh_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Iisa wi'i mo : —Wumtu. Goonɗinol maa danni ma. ");
INSERT INTO fuh_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Wakkati mum da o wumti, o tokki Iisa, omo teddina Alla. Wakkati himɓe ngi'unoo ɗum, ɓe njetti Alla. ");
INSERT INTO fuh_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Iisa naati Yeriko, no feera siire ndeen yahde. ");
INSERT INTO fuh_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Jakayus, hooreejo *jaɓooɓe janngal, gorko diikuɗo no tawaa nder Yeriko. ");
INSERT INTO fuh_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Jakayus no tefa hi'ude nder jama'aare ndeen moy woni Iisa, amma o heppi ngam o daɓɓo. ");
INSERT INTO fuh_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Nden, ngam hi'ude mo, sey o doggi, o arditii jama'aare ndeen. O yehi, o ƴeenyowi ibbi ngonki dow laawol to Iisa wittortoo. ");
INSERT INTO fuh_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Wakkati Iisa yottinoo ibbi kiin o tiggitii, sey o wi'i Jakayus : —Jakayus, yawɗa jippa, ngam no tilsi mi weerane hannden. ");
INSERT INTO fuh_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Jakayus yaawɗi jippii, jaɓɓorii mo welwelo. ");
INSERT INTO fuh_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Wakkati himɓe fuu ngi'unoo ɗum, ɓe puɗɗi iɓe nguuntoo, iɓe mbi'a : —O weeranowi gaɗoowo hakke ! ");
INSERT INTO fuh_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Wakkati ɓe ngari ɓe mbeeri, sey Jakayus ummii darii, wi'i Iisa : —Moodibbo, hettina. Hannden mi hokkan talkaaɓe feccere njawdi am fuu. Nde mi nyaami ceede goɗɗo, mi yoɓitan mo kile nay. ");
INSERT INTO fuh_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Sey Iisa wi'i : —Gorko oo duu, taanu *Ibrahim non. Hannden, kisinam naatii nder hoggo ngoo, ");
INSERT INTO fuh_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","ngam *Ɓii-Neɗɗo wari tefude majjuɓe faa hisina ɓe. ");
INSERT INTO fuh_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Wakkati himɓe ngonnoo no kettinii haala Iisa, sey o waɗani ɓe kippol haala ngool ngam ɓe ɓadake *Ursaliima, iɓe miila ko Laamu Alla no wanngan jooni jooni. ");
INSERT INTO fuh_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Nder kippol haala ngool Iisa wi'i ɓe : —Dimo mawɗo gom yehi nder leydi mboɗɗuni gom faa mellee laamiiɗo mayri, nden warta. ");
INSERT INTO fuh_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Fadde makko dillude, o noddi gollooɓe makko sappo gom. O hokki gooto maɓɓe fuu tammal kanŋe, o wi'i ɓe : « Luumoree ɗe, faa mi warta. » ");
INSERT INTO fuh_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Himɓe leydi makko no mbanyi mo. Ngam majjum waɗi, gaɗa makko ɓe ummini lilaaɓe mbi'owa kam'en ngiɗaa gorko oo laamoo ɗum'en. ");
INSERT INTO fuh_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Amma ɗum fuu haɗaay o mellaa, o warti nder leydi makko. Wakkati o wartunoo, o noddi gollooɓe makko, ɓe o halfinnoo tammaaje kanŋe ɓeen, ngam o annda ko gooto maɓɓe fuu heɓi nder luumaaku mum. ");
INSERT INTO fuh_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Arano oon wari, wi'i : « Joomam, tammal kanŋe maa rimi tammaaje kanŋe sappo. » ");
INSERT INTO fuh_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Sey o wi'i mo : « Gasii, a golloowo lobbo. Ngam a hilnake ko famɗi, mi mellii ma laamiiɗo gure sappo. » ");
INSERT INTO fuh_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ɗiɗaɓo oon ɓadii, wi'i : « Joomam, tammal kanŋe maa rimi tammaaje kanŋe joy. » ");
INSERT INTO fuh_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","O wi'i ɗiɗaɓo oon : « Gasii, aan duu, mi mellii ma laamiiɗo gure joy. » ");
INSERT INTO fuh_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Tataɓo oon wari, wi'i : « Joomam, ndaa tammal kanŋe maa nii. Mi fiɓii ngal nder tekkere mi suuɗi. ");
INSERT INTO fuh_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ngam miɗo hule, sabu a gorko cattuɗo. Aɗa hooƴa ko a resaay. Aɗa hetta ko a aawaay. » ");
INSERT INTO fuh_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Nden gorko diikuɗo oon wi'i mo : « Bonɗo, jaayɗo ! Dara ! Dow haalaaji maa ɗii kiitanmaami. Aɗa anndi ko mi gorko cattuɗo, miɗo hooƴa ko mi resaay, miɗo hetta ko mi aawaay ? ");
INSERT INTO fuh_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Too, ɗume waɗi ko a wattaay ceede am nder banki faa nde ngartumi, nden ɗe ngaddanan kam riiba ? » ");
INSERT INTO fuh_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Nden o wi'i gollooɓe makko ɓeeto : « Teetee tammal kanŋe makko ngaal, kokkon ngal jom tammaaje sappo oon. » ");
INSERT INTO fuh_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Sey ɓe njaabii mo ɓe mbi'i : « Alla sabbinane, mo mbi'uɗaa hokkee oo duu tammaaje kanŋe sappo jogii ! » ");
INSERT INTO fuh_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Sey mawɗo oon wi'i ɓe : « Miɗo haalana on, jogiiɗo fuu ɓeydantee. Amma mo walaa oon, baa seɗɗa mo jogii oon, teetetee. ");
INSERT INTO fuh_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Jooni toy wayɓe am ɓe ngiɗaa mi laamoo ɗum'en ɓeen ngoni ? Ngaddee ɓe ɗo, kirson ɓe yeeso am. » ");
INSERT INTO fuh_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Gaɗa kippol haalaaji ɗii, Iisa ardii *aahiiɓe mum, fa'i *Ursaliima. ");
INSERT INTO fuh_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Wakkati o ɓadinoo nguroy Baytifaaji e Baytaniya hedde har waamnde wi'eteene waamnde Jaytun, sey o lili *aahiiɓe makko ɗiɗo gom, ");
INSERT INTO fuh_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","o wi'i ɓe : —Ummee, njehee nder wurel gonngel yeeso mooɗon ngeel. No nattirɗon nder maggel, on tawan ɓinngel ara gom, ngel waɗɗaaka abada gom no haɓɓii. Kaɓɓitee ngel, ngaddanon kam. ");
INSERT INTO fuh_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Nde nii goɗɗo ƴamii on, wi'i ngam ɗume waɗi oɗon kaɓɓita ngel, mbi'on Joomiraawo haajaa ngel. ");
INSERT INTO fuh_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","*Lilaaɓe ɓeen njehi, tawi huune fuu hano no Iisa tinndiniri ɓe ɗum. ");
INSERT INTO fuh_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Wakkati ɓe kaɓɓitannoo arel ngel, sey joomiingel wi'i ɓe : —Ɗume kaɓɓitanton arel ngeel ? ");
INSERT INTO fuh_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ɓe mbi'i mo : —Joomiraawo haajaa ngel. ");
INSERT INTO fuh_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Nden ɓe njaari ngel to Iisa. Ɓe njowi kolte maɓɓe dow maggel ɓe ngaɗi jappe, ɓe nanngani Iisa waɗɗii dow maggel. ");
INSERT INTO fuh_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Omo yaha, himɓe no mbeɗɗita kolte mum'en dow laawol makko. ");
INSERT INTO fuh_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Wakkati o faani *Ursaliima, ɗoon hadde simmitorde waamnde wi'eteene waamnde Jaytun, goonɗinɓe tokkuɓe mo fuu keewi welwelo, sey ɓe towni daaɗe, iɓe njetta Alla daliila kujje kaayɗiniiɗe ɗe ɓe ngi'ii. ");
INSERT INTO fuh_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Iɓe mbi'a : —Barkinaaɗo woni laamiiɗo gardoowo innde Joomiraawo ! Jam laatoo nder kammu. Teddungal laatanoo Alla Toowɗo ! ");
INSERT INTO fuh_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Sey *Fariisa'en gom tawaaɓe nder jama'aare ndeen mbi'i mo : —Moodibbo, haja *aahiiɓe maa ndeƴƴa ! ");
INSERT INTO fuh_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","O jaabii ɓe, o wi'i : —Miɗo haalana on, nde ɓe ndeƴƴi, kaaƴe ɗee e ko'e mum'en kuuɓan ! ");
INSERT INTO fuh_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Wakkati Iisa hi'unoo huɓeere *Ursaliima, o woyani nde, ");
INSERT INTO fuh_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","o wi'i : —Mi hiɗiino tawee hannden, aan duu, a faami ko hokkete jam. Amma kaari, ɗum suuɗanake gite maaɗa ! ");
INSERT INTO fuh_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Nyalaaɗe no ngaran nde wayɓe maa nyiɓata cuuɗi loope ngam ɓe ƴeenya ɓe piile, ɓe kone, ");
INSERT INTO fuh_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","ɓe pusee, ɓe accataa baa hayre worre no deki dow wonnde nder maaɗa. Ɓe mbare, aan e ɓiɓɓe maaɗa fuu, ngam a annditaay wakkati mo Alla warunoo ngam hisinde ma. ");
INSERT INTO fuh_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Iisa naati jawreeru *Juulirde mawne, fuɗɗi no riiwa sonnooɓe, ");
INSERT INTO fuh_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","no wi'a ɓe : —Ɗum winndaama nder dewte Alla : Suudu am laatoto suudu du'aa'u. Amma onon, on ngaɗii ndu wumpere wuyɓe  ! ");
INSERT INTO fuh_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Iisa no waajoo nyannde fuu nder *Juulirde mawne. Mawɓe *cakkanooɓe Alla e jannginooɓe *Tawreeta e haalooɓe nanee nder lenyol ngool fuu no ndaara no mbardata Iisa. ");
INSERT INTO fuh_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Amma ɓe keppi heɓude laawol fuu, ngam himɓe fuu no ngattani haalaaji makko hakkillo sanne. ");
INSERT INTO fuh_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Nyannde gom Iisa no janngina himɓe nder *Juulirde mawne, omo waajoo ɓe dow *Habaru lobbo. Sey mawɓe *cakkanooɓe Alla gom, jannginooɓe *Tawreeta e mawɓe *Yahudankooɓe gom ngari to makko, ");
INSERT INTO fuh_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","mbi'i mo : —Haalan min, baawɗe ɗeye ngaɗirtaa kujje ɗee fuu ? Moy hokki ma laawol waɗude ɗe ? ");
INSERT INTO fuh_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Nden Iisa jaabii ɓe, wi'i : —Miin duu, huune worre tan ƴamanmi on, njaaboɗon kam : ");
INSERT INTO fuh_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Alla naa himɓe kokki Yahaaya laawol waɗude *batisma ? ");
INSERT INTO fuh_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Sey iɓe caawodira hakkune maɓɓe, iɓe mbi'a : —Nde nii en mbi'ii Alla, o wi'an ko waɗi en ngoonɗinaay Yahaaya ? ");
INSERT INTO fuh_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Amma nde en mbi'ii himɓe, too, himɓe fuu no mbugoto en kaaƴe, ngam ɓe fuu ɓe tabbintini ko Yahaaya no annabiijo. ");
INSERT INTO fuh_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Nden ɓe njaabii Iisa, ɓe mbi'i : —Min anndaa liluɗo mo. ");
INSERT INTO fuh_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Iisa duu wi'i ɓe : —Too, miin duu, mi haalantaa on baawɗe ɗe ngaɗiranmi kujje ɗee. ");
INSERT INTO fuh_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Gaɗa ko Iisa haaldunoo he mawɓe *cakkanooɓe Alla, jannginooɓe *Tawreeta he mawɓe *Yahudankooɓe, o waɗani himɓe kippol haala ngool, o wi'i : —Neɗɗo gom waɗi ngesa *cabiije, nden wuƴi nga remooɓe gom, waɗi jahaangal, o ɓooyi har toon. ");
INSERT INTO fuh_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Wakkati teɓol cabiije ɗeen yottinoo, o lili golloowo makko gom jaɓowa mbaka makko cabiije ɗeen to remooɓe ɓeen. Amma remooɓe ɓeen piyi lilaaɗo oon. O coƴƴitii juuɗe ɓole. ");
INSERT INTO fuh_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","O lili golloowo makko gom kaden to maɓɓe, ɓe piyi oon duu, ɓe njennii mo. O coƴƴitii kanko duu juuɗe ɓole. ");
INSERT INTO fuh_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Jom ngesa oon lili kaden golloowo mum tataɓo gom, ɓe mbarmini mo, ɓe ndiiwi mo. ");
INSERT INTO fuh_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Sey jom ngesa oon wi'i hoore mum : « Joonkay, miɗo anndi no ngaɗanmi. Mi lilan ɓiyam gorko korsuɗo he maɓɓe, tawte ɓe teddinan mo ! » ");
INSERT INTO fuh_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Amma wakkati remooɓe ɓeen ngi'unoo ɓiyiiko, sey ɓe mbi'odiri : « Ma'adalla. Oo woni donoowo ngesa ngaa. Ngaree mbaren mo, heɓa ndonen nga ! » ");
INSERT INTO fuh_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Sey ɓe mburtini mo nder ngesa ngaan, ɓe mbari mo. Too, ɗume miiloton jom ngesa oon waɗata remooɓe ɓee ? ");
INSERT INTO fuh_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Miɗo wi'a on : « O waran, o wara remooɓe ɓeen, nden o halfina ngesa ngaan woɓɓe. » Wakkati himɓe nanunoo kippol haala ngool, ɓe mbi'i : —Alla hiinu en ɗum ! ");
INSERT INTO fuh_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Iisa ƴeewi ɓe, wi'i : —Ndenne, ɗume woni maana ko winndaa nder dewte ɗeen, wi'aa : Hayre nde nyiɓooɓe ɓeen mboppi ndeen, kayre laatii hoore nyibdi ndiin. ");
INSERT INTO fuh_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Iisa ɓeydi wi'ude ɓe kaden : —Neɗɗo fuu caamuɗo dow hayre ndeen, helan. Neɗɗo fuu, mo nde saami dow mum, no mornyotoo. ");
INSERT INTO fuh_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Jannginooɓe *Tawreeta e hooreeɓe *cakkanooɓe Alla paamii ko kippol haala ngool, kam'en ngol sappii. Ɓe muuyiino nanngude mo ɗoon da, amma ɓe kuli himɓe. ");
INSERT INTO fuh_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Jannginooɓe *Tawreeta e hooreeɓe *cakkanooɓe Alla ngattani Iisa hitere. Ɓe lili himɓe gom ngaɗa ko'e mum'en hano dartiiɓe, tunna mo nder haalaaji makko ngam ɓe keɓa laawol no ɓe ngattirta mo nder juuɗe laamu. ");
INSERT INTO fuh_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Lilaaɓe ɓeen ngari to Iisa, ƴami mo, mbi'i : —Moodibbo, miɗen anndi ko kaalataa e ko mbaajotoɗaa fuu no dartii. Miɗen anndi ko a ɓurdinaay himɓe. Aɗa janngina laawol Alla goonga e goonga. ");
INSERT INTO fuh_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","No hegii min kokka laamiiɗo *Rooma mawɗo janngal naa hegaaki ? ");
INSERT INTO fuh_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Amma Iisa annditani ƴoyre maɓɓe, nden wi'i ɓe : ");
INSERT INTO fuh_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—Kollee kam tammal cardi ! Foto moy he innde moy woni ɗo ? Ɓe njaabii, ɓe mbi'i : —Laamiiɗo *Rooma. ");
INSERT INTO fuh_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Nden o wi'i ɓe : —Ndenne kokkee laamiiɗo *Rooma ko jeyi, kokkon Alla duu ko jeyi. ");
INSERT INTO fuh_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ɓe keɓaay fuu ko ɓe tunnirta mo nder ko o wi'i ɓe yeeso himɓe fuu. Nootaaki makko haayɗini ɓe, nden ɓe ndeƴƴiti. ");
INSERT INTO fuh_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","*Sadduki'en, kam'en ngoni yeddooɓe no mbi'a ko maayɗo fuu ummitittaako. Nyannde gom, woɓɓe maɓɓe ummii ngari to Iisa, ƴami mo, mbi'i : ");
INSERT INTO fuh_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Moodibbo, *Muusa tilsini enen *Yahudankooɓe, wi'i : Nde gorko dewli, maayi, heɓaay ɓiɗɗo, minyum naa mawnum dewla deekiiko ngam heɓana mo jippotooɓe. ");
INSERT INTO fuh_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Too, waɗiino rimdaaɓe jeɗɗo gom. Arano oon dewli debbo gom, maayi, heɓaay ɓiɗɗo. ");
INSERT INTO fuh_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ɗiɗaɓo oon dewli debbo oon, kam duu maayi, heɓaay ɓiɗɗo. ");
INSERT INTO fuh_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Tataɓo oon duu tokki, faa jeɗɗo ɓeen fuu maayi. ");
INSERT INTO fuh_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Gaɗa maayde maɓɓe, debbo oon duu maayi. ");
INSERT INTO fuh_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Too, nyannde darŋal, moy nder maɓɓe laatoto goro debbo oo ? Ngam ɓe fuu jeɗɗo kaɓɓani mo. ");
INSERT INTO fuh_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Sey Iisa jaabii ɓe, wi'i : —Nder duuniyaaru nduu worɓe ɓaŋata, rewɓe duu ɓaŋee. ");
INSERT INTO fuh_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Amma ɓe Alla daari fotuɓe keɓa mbuurnam jaaŋo, ummitittooɓe nyannde darŋal, worɓe maɓɓe ndewlataa, rewɓe maɓɓe duu ndewlataake. ");
INSERT INTO fuh_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ɓe maayataa kaden, ngam ɓe laatoto hano maleykaaɓe. Ɓe ɓiɓɓe Alla duu, ngam ɓe ummitake he maayde. ");
INSERT INTO fuh_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","*Muusa he hoore mum wakkati Alla haaldannoo he mum nder taariihi kaaloowo dow wuumoore huɓɓoore, Muusa sappake ko maayɓe no ummitittoo. Ngam toon o noddiri Joomiraawo Alla *Ibrahim, Alla Isiyaaku, Alla Yakuuba. ");
INSERT INTO fuh_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Iisa wi'i ɓe kaden : —Ndenne, Alla hanaa Alla maayɓe, o Alla wuurɓe. Ngam to makko himɓe fuu no wuurɓe. ");
INSERT INTO fuh_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Gere nder jannginooɓe *Tawreeta piirti hunnduko, mbi'ii : —Moodibbo, a haalii goonga. ");
INSERT INTO fuh_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Illa ndeen ɓe cuusaay ƴamude mo goɗɗum kaden. ");
INSERT INTO fuh_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Iisa wi'i ɓe : —Noy himɓe mbaawiri wi'ude ko *Almasiihu no taan Daawda ? ");
INSERT INTO fuh_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Daawda e hoore mum wi'i nder *Jabuura : « Alla Joomiraawo wi'i Joomiraawo am : War, njooɗaa nyaamo am ");
INSERT INTO fuh_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","faa mi sorna wayɓe maa ley teppere maa. » ");
INSERT INTO fuh_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Daawda no noddira mo, « Joomiraawo », ndenne, o hanaa taanu Daawda. ");
INSERT INTO fuh_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Wakkati jama'aare wonnoo no hettinanii Iisa, sey Iisa wi'i *aahiiɓe mum : ");
INSERT INTO fuh_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Tinnee. Kakkilee he jannginooɓe *Tawreeta. Iɓe ngiɗi ɓornaade kolte mawɗe. Iɓe ngiɗi sanneede cannooje tedduɗe nder luuɓe. Iɓe ngiɗi jooɗorɗe ɓurɗe teddude nder *baajorɗi. Iɓe ngiɗi jooɗorɗe ɓurɗe teddude nde nii ɓe noddaama batu. ");
INSERT INTO fuh_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Iɓe eyta rewɓe ɓe goriraaɓe mum'en maayi ngam teetude njawdi maɓɓe. Iɓe njunna du'aa'uuji maɓɓe ngam ɓe limtee nder lobbuɓe. Kiite naawɗe ɓe ngaɗantee. ");
INSERT INTO fuh_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Iisa ɓanti hoore mum nder *Juulirde mawne, sey hi'i riikuɓe gom no ngatta hadiyaaji mum'en nder keesuwal mayre. ");
INSERT INTO fuh_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","O hi'i duu debbo talkaajo gom mo gorum maayi no watta buuɗoy ɗiɗoy nder maggal. ");
INSERT INTO fuh_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Sey o wi'i : —Miɗo haalana on goonga : Ko debbo talkaajo mo gorum maayi oo watti nder keesuwal ɗum, no ɓuri ko ɓeeto fuu ngatti. ");
INSERT INTO fuh_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ngam ɓe fuu, ɓe kokki seɗɗa nder ko ɓe njogii. Amma debbo oo, ko o joginoo ngam o wuurda ɗum, o watti nder maggal. ");
INSERT INTO fuh_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Nder *Juulirde mawne ndeen woɓɓe tinni no kaala dow mayre, no mbi'a ko inde wooɗi ngam nde moƴƴiniraama kaaƴe booɗɗe. Nde feɗiraama sadakaaji ittanaaɗi Alla. Amma Iisa wi'i ɓe : ");
INSERT INTO fuh_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Nder ko ngi'oton ɗum fuu, wakkati waran mo baa hayre mayre worre hoddataako no deki dow wonnde. Nde fuu, nde liɓetee. ");
INSERT INTO fuh_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Nden ɓe ƴami mo, ɓe mbi'i : —Moodibbo, haalan min nde ɗum waɗata. Alaama oye hollata ko kujje ɗee fuu ɓadake ? ");
INSERT INTO fuh_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Sey Iisa jaabii ɓe, wi'i : —Kakkilee to neɗɗo fuu majjina on. Himɓe heewɓe ngardan innde am, mbi'a : « Miin woni *Almasiihu », ɓe mbi'a : « Wakkati oo ɓadake. » To tokkee ɓe. ");
INSERT INTO fuh_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Nde nii on nani habaru konu e murtol no waɗee, to kulee. No tilsi ɗum waɗa ginan, amma ɗum hollataa ko wakkati mum da timmoode duuniyaaru yottake. ");
INSERT INTO fuh_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Iisa tinni no wi'a ɓe : —Lenyol habdan he lenyol, laamu habdan he laamu. ");
INSERT INTO fuh_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Dimmbaaki leydi mawki waɗan. Rafooji e nyawuuji bonɗi ngaɗan nokku nokkuuje. Kujje kulƴiniiɗe e alamaaji mawɗi ngaɗan dow kammu. ");
INSERT INTO fuh_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Amma fadde majjum waɗude, on nanngetee, torreɗon, njaareɗon yeeso laamiiɓe e hooreeɓe, kiiteɗon nder *baajorɗi *Yahudankooɓe, paɗɗeɗon nder kasu ngam sabbu am. ");
INSERT INTO fuh_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ɗum hokkan on laawol seedanaade kam. ");
INSERT INTO fuh_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ndenne, kaɓɓee anniya illa joonin, heɓa no coptinirton ko'e mooɗon to suulu on, ");
INSERT INTO fuh_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ngam mi hokkan on nyenyal haala e anndal faa nder wayɓe mooɗon ɓee fuu walaa baawɗo liɓude naa yeddude on. ");
INSERT INTO fuh_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Baa saarooɓe mooɗon, rimdaaɓe mooɗon, koreeji mooɗon e higiraaɓe mooɗon no njammboto on. Ɓe laatoo daliila maayde woɓɓe mooɗon. ");
INSERT INTO fuh_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Himɓe fuu mbanyan on ngam am. ");
INSERT INTO fuh_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Amma baa leeɓol ko'e mooɗon gootol majjataa. ");
INSERT INTO fuh_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Tittinkinaaku mooɗon keɓirton kisinam. ");
INSERT INTO fuh_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","—Wakkati ngi'uɗon soogeeji piili *Ursaliima, anndon ko cankitol maggo ɓadake. ");
INSERT INTO fuh_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Nder wakkati oo, ɓe ɗum tawi Yahudiya ndoggira baamle. Ɓe ɗum tawi nder huɓeere *Ursaliima, mburto nder mayre. Tawaaɓe nder ladde duu, to naatu nder mayre. ");
INSERT INTO fuh_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ngam nyalaaɗe ɗeen no nyalaaɗe yoptitaade ko winndaa nder dewte Alla fuu no tabbitan. ");
INSERT INTO fuh_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Nder balɗe mum bone saaman dow saawɓe he musinooɓe ! Ngam torraaji mawɗi no caaman dow leydi ndiin. Tikkere Alla no jippoto nder lenyol ngool. ");
INSERT INTO fuh_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Woɓɓe mbardetee takubaaje, woɓɓe nanngee, njaaree hakkune lenyi fuu. Ɓe kanaa *Yahudankooɓe ndampan *Ursaliima, dawranaade faa wakkati mo ɗum fodanaa oon huuɓa. ");
INSERT INTO fuh_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","—Alamaaji no ngaɗan dow naange, ɗi ngaɗan dow lewru e dow koode. Kulkulal nanngan himɓe duuniyaaru duu. Iido maayo ɓaleewo e benkeƴƴe mum mawna faa lenyi ɗii fuu mbemmbee ngam majjum. ");
INSERT INTO fuh_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Nde himɓe miilake ko waroyta nder duuniyaaru, sey kulkulal waɗa ɓe pekkora, ngam baa baawɗe gonɗe dow fuu no ndimmboto. ");
INSERT INTO fuh_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Nder wakkati mum, *Ɓii-Neɗɗo no hi'etee, no wara dow luuldere. Omo warda baawɗe e teddungal manngal. ");
INSERT INTO fuh_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Nde nii ɗum fuɗɗii waɗude, ummoɗon ndaroɗon, ɓanton ko'e mooɗon, ndaaron dow ngam coptinol mooɗon ɓadake. ");
INSERT INTO fuh_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Gaɗa filla alamaaji kollooji gartol makko ngool, Iisa waɗani ɓe tinndinoore ndee, wi'i : —Ndaaree ibbi e leɗɗe koriiɗe fuu. ");
INSERT INTO fuh_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Nde nii on ngi'ii ɗe mbilitii, oɗon anndi ko dunngu ɓadake. ");
INSERT INTO fuh_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Hano non, onon duu, nde nii on ngi'ii kujje ɗee no ngaɗa, paamee ko Laamu Alla ɓadake. ");
INSERT INTO fuh_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Goonga kaalananmi on : Jamaanu oo timmataa tawee kujje ɗee fuu ngaɗaay. ");
INSERT INTO fuh_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Kammu e leydi taggan, amma haalaaji am timmataa abada. ");
INSERT INTO fuh_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","—Ndeenee ko'e mooɗon to accee nyaamdu ada hakkillo mooɗon. To njaree duu faa ko'e mooɗon puɗɗa soptaade. To accee miilooji duuniyaaru cuula on. Nde hanaa non, nyalaane ndeen no juhan on, on anndaay. ");
INSERT INTO fuh_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ngam nyalaane ndee no waran dow yonki fuu nder duuniyaaru. ");
INSERT INTO fuh_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ndenne, kakkilee, ndu'ee wakkati fuu, ngam keɓon semmbe daɗude kujje kaanuɗe waɗude ɗee fuu. Mbaawon daraade duu yeeso *Ɓii-Neɗɗo. ");
INSERT INTO fuh_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Nyalooma, Iisa no waajoo nder *Juulirde mawne, amma nde jemma waɗi, o wurtoo, o waalowa dow waamnde wi'eteene waamnde Jaytun. ");
INSERT INTO fuh_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Illa subaka kecco himɓe fuu no ummoo, no njaha to makko, no tawowaa mo nder Juulirde ndeen ngam hettinaade ko o wi'ata. ");
INSERT INTO fuh_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Wakkati *Juulɗe buuru mo walaa ƴuufinirɗum, juulɗe bi'eteeɗe *Juulɗe dimɗinol Isra'ilankooɓe ɓadinoo, ");
INSERT INTO fuh_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","mawɓe *cakkanooɓe Alla e jannginooɓe *Tawreeta no tefa no mbarirta Iisa, amma iɓe kula himɓe. ");
INSERT INTO fuh_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Sey Ibiliisa naati nder ɓerne Yahuuda inndirteeɗo Iskariyot, gooto nder *lilaaɓe sappo e ɗiɗo ɓeen. ");
INSERT INTO fuh_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Nden o yehi, o haaldowi mawɓe *cakkanooɓe Alla e mawɓe soogeeji kakkiliiɗi he *Juulirde mawne ndeen dow no o wattirta Iisa nder juuɗe maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ɓe nanii belɗum majjum sanne, nden ɓe adi alkawal ko ɓe kokkan mo ceede. ");
INSERT INTO fuh_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yahuuda jaɓi, nden fuɗɗi tefude laawol no o jammbortoo Iisa, tawa himɓe paamaay. ");
INSERT INTO fuh_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","*Juulɗe buuru mo walaa ƴuufinirɗum wari. Nyannde majje himɓe mbownoo hirsude jawɗi ngam waɗude hiraane *Juulɗe dimɗinol Isra'ilankooɓe. ");
INSERT INTO fuh_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Iisa lili Piyer e Yahaaya, wi'i ɓe : —Njehee ciryanee en hiraane *Juulɗe dimɗinol Isra'ilankooɓe, nyaamen. ");
INSERT INTO fuh_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Nden ɓe ƴamii mo, ɓe mbi'i : —Toy ngiɗɗaa min ciryowoo nde ? ");
INSERT INTO fuh_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Iisa jaabii ɓe, wi'i : —Kettinee, nde nii on naati nder huɓeere ndee, on pottan gorko gom no ronndii loone ndiyam. Tokkon mo faa nder ɓaade nde o naatata nder mum. ");
INSERT INTO fuh_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Nden mbi'on jom ɓaade ndeen : « Moodibbo lili min, min ƴame toy suudu ndu o nyaamdata he *aahiiɓe makko hiraane *Juulɗe dimɗinol Isra'ilankooɓe nduun woni ? » ");
INSERT INTO fuh_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","O hollan on suudu mawnu gom, ciryaanu wonndu dow. Toon ciryotoɗon hiraane ndeen. ");
INSERT INTO fuh_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Sey ɓe njehi, ɓe tawi huune fuu dey-dey no Iisa wi'irnoo ɓe. Nden ɓe ciryii hiraane ndeen. ");
INSERT INTO fuh_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Wakkati kiraaɗe ɗeen njottinoo, sey Iisa jooɗodii he *lilaaɓe ɓeen faa ɓe nyaama. ");
INSERT INTO fuh_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Nden o wi'i ɓe : —Mi haaɓii en njooɗidaaki nyaamuɗen hiraane *Juulɗe dimɗinol Isra'ilankooɓe ndee, fadde am torreede. ");
INSERT INTO fuh_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ngam miɗo wi'a on, mi nyaamataa hiraane ndee kaden sey nyannde maana mayre humnaa nder Laamu Alla. ");
INSERT INTO fuh_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Iisa hooƴi nyeɗerde cabiijam, o yetti Alla, o wi'i : —Njaɓee, ceendee hakkune mooɗon ");
INSERT INTO fuh_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","ngam miɗo haalana on, mi yarataa cabiijam kaden, sey wakkati Laamu Alla wari. ");
INSERT INTO fuh_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","O hooƴi buuru, yetti Alla, helti mo, hokki ɓe, wi'i : —Ɗum woni ɓanndu am kokkaanu ngam mooɗon. Ngaɗee iri nii he banndum ngam miccitaade he am. ");
INSERT INTO fuh_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Gaɗa ɓe kiirtake, Iisa hooƴi nyeɗerde cabiijam, yetti Alla, hokki ɓe, wi'i : —Nyeɗerde ndee woni amaana keso tabbintinaaɗo har ƴiiƴam am ndufeteeɗam ngam mooɗon. ");
INSERT INTO fuh_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Amma jammbotooɗo kam oon no ɗo. Omo nyaamda he am nder le'al gootal. ");
INSERT INTO fuh_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","*Ɓii-Neɗɗo accan duuniyaaru hano no ɗum fodira. Amma bone saaman dow jammbotooɗo mo ! ");
INSERT INTO fuh_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Sey *lilaaɓe ɓeen puɗɗi no ƴamodira moy nder mum'en woni gaɗoowo ɗum. ");
INSERT INTO fuh_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Geddi ummii hakkune *aahiiɓe ɓeen dow moy ɓuri teddude nder maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Nden Iisa wi'i ɓe : —Doole doole laamiiɓe ɓe kanaa *Yahudankooɓe laamorii himɓe mum'en. Jom'en baawɗe duu no ngiɗi noddireede lobbuɓe. ");
INSERT INTO fuh_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Amma onon kay, ɗum waɗataa hakkune mooɗon. Accee ɓurɗo teddude hakkune mooɗon laatoo hano ɓurɗo famɗude. Ardiiɗo laatoo hano golloowo. ");
INSERT INTO fuh_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ngam moy ɓuri teddude hakkune jooɗiiɗo faa nyaama naa golloowo gaddoowo nyaamdu oon ? Jooɗiiɗo faa nyaama oon kam woni mawɗo. Amma miin, miɗo hakkune mooɗon hano golloowo. ");
INSERT INTO fuh_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Onon, oɗon ngondi he am wakkati torreteemi fuu. ");
INSERT INTO fuh_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Miin duu, mi hokkii on laamu hano no *Baaba am hokkiri kam ngu, ");
INSERT INTO fuh_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ngam nyaamon, njaron he le'al am nder laamu am. Njooɗoɗon dow jooɗorɗe laamu, kiitoɗon lenyi *Isra'el sappo e ɗiɗi ɗiin. ");
INSERT INTO fuh_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Gaɗa geddi naatuni caka *aahiiɓe ɓeen, sey Iisa wi'i Simon Piyer : —Simon, Simon, Ibiliisa ƴamii baawɗe faa seɗa on hano no alkama seɗirtee. ");
INSERT INTO fuh_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Amma mi du'anake ma ngam to a mursu goonɗinol maa. Aan duu, nde a wartii to am, cemmbinɗinaa banndiraaɓe maa. ");
INSERT INTO fuh_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Piyer jaabii mo wi'i : —Joomam, baa nii mi uddiditee he maaɗa non naa mi wardetee he maaɗa non, miɗo siryi ! ");
INSERT INTO fuh_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Nden Iisa jaabii mo, wi'i : —Miɗo haalane Piyer, nder jemma oo, fadde ndontoori jogginde, a wi'an a anndaa kam kile tati ! ");
INSERT INTO fuh_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Iisa wi'i *aahiiɓe ɓeen : —Wakkati lilunoomi on ko on njaaraayno albey, mbasu e paɗe, no woodi ko ŋakkani on naa ? Sey ɓe njaabii mo ɓe mbi'i : —Walaa ! ");
INSERT INTO fuh_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","O wi'i ɓe kaden : —Amma jooni, gooduɗo albey, hooƴa. Jogiiɗo mbasu, yaara. Mo walaa takubaahi, sonna jabbaare mum sooda ngooti. ");
INSERT INTO fuh_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ngam no winndaa dow am, wi'aa : O fiyetee sawru bonɓe. Miɗo wi'a on : No tilsi ɗum heewtoo kam ngam ko winndaa dow am fuu huuɓaa. ");
INSERT INTO fuh_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Nden ɓe mbi'i mo : —Moodibbo, ndaa takubaaje ɗiɗi nii ! O wi'i ɓe : —Heƴii ! ");
INSERT INTO fuh_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Iisa wurtii huɓeere *Ursaliima, fa'i waamnde wi'eteene waamnde Jaytun hano no o woowiri waɗirde ɗum. *Aahiiɓe makko tokki mo. ");
INSERT INTO fuh_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Wakkati o yottinoo toon, o wi'i ɓe : —Ndu'ee to on caamu nder cii'aaki. ");
INSERT INTO fuh_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Sey o toowtiri ɓe kuule seɗɗa, o hofi, omo du'oo, ");
INSERT INTO fuh_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","omo wi'a : —*Baaba, nde a muuyii, woɗɗinam nyeɗerde torra ndee. To ɗum laatoo muuyɗe am, amma ɗum laatoo muuyɗe maa !  ");
INSERT INTO fuh_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Nden, maleykaajo gom ƴuwɗo dow kammu wanngani mo, ngam semmbinɗina mo. ");
INSERT INTO fuh_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Nder torra makko, o ɓeydi tekkinɗinde du'aa'u makko faa gulinol makko laatii hano toɓɓe ƴiiƴam tinni no simta dow leydi. ");
INSERT INTO fuh_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Wakkati o du'odii, o soƴƴii to *aahiiɓe makko, o tawi iɓe ɗaanii ngam ɓerɗe maɓɓe mboni. ");
INSERT INTO fuh_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Nden o wi'i ɓe : —Ɗume ɗaanantoɗon ? Ummee ndu'ee, to on caamu nder cii'aaki ! ");
INSERT INTO fuh_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Iisa no caka haala, sey jama'aare gom wari. Yahuuda, gooto nder *lilaaɓe sappo e ɗiɗo ɓeen, no ardi. O ɓadii Iisa faa o wunndoo ɗum. ");
INSERT INTO fuh_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Sey Iisa wi'i mo : —Yahuuda, mbunndaaki njammbortoɗaa *Ɓii-Neɗɗo naa ? ");
INSERT INTO fuh_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Wakkati *aahiiɓe Iisa ngi'ii ko hiɗi waɗude, ɓe mbi'i : —Moodibbo, min coppira ɓe takubaaje naa ? ");
INSERT INTO fuh_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Sey gooto maɓɓe soppi gollanoowo mawɗo *cakkanooɓe Alla gom, taƴi nowru makko nyaamo. ");
INSERT INTO fuh_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Nden Iisa jaabii ɓe, wi'i : —Accee nii ! Iisa meemi nowru peƴƴaaɗo oon, o yamɗintini mo. ");
INSERT INTO fuh_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Nden o haalani mawɓe *cakkanooɓe Alla, mawɓe soogeeji kakkiliiɗi *Juulirde mawne ndeen e mawɓe *Yahudankooɓe warɓe nanngude mo ɓeen, o wi'i : —Ko waɗi ngarduɗon takubaaje e cabbi faa nanngon kam hano miin woni mawɗo murtuɓe ? ");
INSERT INTO fuh_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Miɗo wondunoo he mooɗon wakkati fuu nder *Juulirde mawne miɗo waajoo, on ndekaay junngo dow am. Amma jooni wakkati mooɗon non, wakkati mo nimre laamotoo. ");
INSERT INTO fuh_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Iisa nannga, ardinaa faa nder ɓaade mawɗo *cakkanooɓe Alla fuu. Piyer tokkitii ɓe to toowti. ");
INSERT INTO fuh_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Hiite no huɓɓa caka batamaare ɓaade ndeen, himɓe no njooɗii no ngatti nge caka no ƴilfoo. Piyer wari jooɗii hakkune maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Nder jeyngol hiite ngeen, korɗo gom hi'i Piyer no ƴilfoo. Korɗo oon ƴeewi Piyer faa wooɗi, wi'i himɓe : —Neɗɗo oo duu, no wondunoo he Iisa. ");
INSERT INTO fuh_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Nden Piyer yeddi, wi'i mo : —Banndam debbo, mi anndaa mo sam ! ");
INSERT INTO fuh_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ɓooyi seɗɗa gaɗa mum, sey goɗɗo hi'i mo, wi'i mo kaden : —Aan duu, a gooto nder maɓɓe ! Piyer jaabii mo, wi'i : —Higo, hanaa miin non ! ");
INSERT INTO fuh_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Yamde worre gaɗa mum, sey goɗɗo ummini haala kaan kaden, wi'i : —Sikka fuu walaa, omo jeyda he maɓɓe, ngam o ɓii-leydi Galili. ");
INSERT INTO fuh_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Piyer jaabii mo, wi'i : —Higo, mi faamaay ko mbi'uɗaa ! Piyer hantaay haala ko ndontoori joggini. ");
INSERT INTO fuh_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Iisa yeeƴitii, ƴeewi Piyer, sey Piyer miccitii ko Iisa wi'unoo ɗum : —Fadde ndontoori jogginde hannden, a wi'an a anndaa kam kile tati. ");
INSERT INTO fuh_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Piyer wurtii yaasi, tinni no wulla no wullitoo. ");
INSERT INTO fuh_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Jogiiɓe Iisa ɓeen no njawoo Iisa, no piya mo. ");
INSERT INTO fuh_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ɓe cuddi yeeso makko, iɓe ƴama mo, iɓe mbi'a : —Nde nii a annabiijo, haalan min moy fii ma ! ");
INSERT INTO fuh_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ɓe tinni iɓe pamɗina mo, iɓe njenna mo jennooje ir-iriije. ");
INSERT INTO fuh_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Wakkati weetunoo, mawɓe *Yahudankooɓe, mawɓe *cakkanooɓe Alla e jannginooɓe *Tawreeta kawri. Iisa yaaraa yeeso hawriine dawrooɓe. ");
INSERT INTO fuh_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ɓe mbi'i mo : —Nde aan woni *Almasiihu oon, haalan min. Iisa jaabii ɓe, wi'i : —Baa nde mi wi'i on non, on ngoonɗintaa. ");
INSERT INTO fuh_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Nde mi ƴamii on duu, on njaabataako. ");
INSERT INTO fuh_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Amma illa jooni, *Ɓii-Neɗɗo no jooɗoyto nyaamo Alla Jom baawɗe. ");
INSERT INTO fuh_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Sey ɓe fuu ɓe mbi'ii : —Ndenne a *Ɓii-Alla naa ? Iisa jaabii ɓe wi'i : —On kaali ko ngonmi. ");
INSERT INTO fuh_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Nden ɓe mbi'ii : —Seede oye ndoometen kaden ? En fuu en nani ko o haaliri hunnduko makko ! ");
INSERT INTO fuh_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","*Hawriine dawrooɓe ndeen fuu ummii, yaari Iisa to Pilaatus. ");
INSERT INTO fuh_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ɓe puɗɗi iɓe tuuma mo, iɓe mbi'a : —Min tawi neɗɗo oo no majjina lenyol amin, no haɗa laamiiɗo *Rooma mawɗo hokkee janngal. Omo wi'a hoore makko kee, kam woni *Almasiihu, laamiiɗo. ");
INSERT INTO fuh_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Nden Pilaatus ƴamii Iisa, wi'i : —Aan woni laamiiɗo *Yahudankooɓe naa ? Iisa jaabii mo, wi'i : —Aan wi'i ka. ");
INSERT INTO fuh_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilaatus fiirti hunnduko, wi'i hooreeɓe *cakkanooɓe Alla e jama'aare ndeen fuu : —Mi hi'aay daliila fuu he makko ko jukkata mo. ");
INSERT INTO fuh_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ɓe nani ko Pilaatus wi'i, sey ɓe towni daaɗe maɓɓe ɓe ngaɗi ko haalude dow Iisa, iɓe mbi'a : —Ko o waajotoo ɗum no murtina himɓe. O fuɗɗii nder leydi Galili, nden o yawti o yehi nder leydi Yahudiya, joonin o warii faa ɗo. ");
INSERT INTO fuh_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilaatus, ngam haalaaji ɗi tuumuɓe Iisa ɓeen ngaɗi, ƴami himɓe wi'i : —Gorko oo no ɓii-leydi Galili naa ? ");
INSERT INTO fuh_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Wakkati o nanunoo ko Iisa ƴuwaana nder laamu *Hirudus, nden o waɗi Iisa yaaree to *Hirudus, ngam nder balɗe mum, *Hirudus he hoore mum no tawaa *Ursaliima. ");
INSERT INTO fuh_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Wakkati *Hirudus hi'unoo Iisa, nani belɗum sanne, daliila haalaaji ɗi o nanannoo dow mum ɗiin. Illa ko ɓooyii duu o hiɗiino hi'ude mo. Omo hiɗi o hi'a Iisa no waɗa alaama kaayɗiniiɗo. ");
INSERT INTO fuh_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","O ƴami Iisa ƴamɗe ɗuɗɗe, amma Iisa jaabaaki mo baafuy. ");
INSERT INTO fuh_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Mawɓe *cakkanooɓe Alla e jannginooɓe *Tawreeta ndarii, no pelira mo keddi semmbe mum'en. ");
INSERT INTO fuh_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","*Hirudus e soogeeji mum duu njenni mo, njawii mo, ɓornii mo alkubbaare wooɗune sanne gom, coƴƴiti mo to Pilaatus. ");
INSERT INTO fuh_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","*Hirudus e Pilaatus no mbanyidirnoo amma nyannde mum ɓe laatii higiraaɓe. ");
INSERT INTO fuh_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilaatus hawri hooreeɓe *cakkanooɓe Alla, mawɓe *Yahudankooɓe, o hawri himɓe fuu, ");
INSERT INTO fuh_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","o wi'i ɓe : —On ngaddanii kam neɗɗo oo mbi'uɗon oo majjinoowo himɓe. Too, mi ƴamii mo yeeso mooɗon, amma dow ko peluɗon mo ɗum fuu, mi hi'aay daliila ko njukkata mo. ");
INSERT INTO fuh_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","*Hirudus duu hi'aay baafuy he makko, ɗum waɗi o soƴƴitani en mo. Paamee ko gorko oo waɗaay fuu ko foti o waree. ");
INSERT INTO fuh_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ndenne, mi ɓoccan mo, mi yoofa mo.  ");
INSERT INTO fuh_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Tawi he *Juulɗe dimɗinol Isra'ilankooɓe fuu, no tilsi Pilaatus yoofana ɓe uddanooɗo gom. ");
INSERT INTO fuh_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Amma ɓe poti ɓe kuuɓi, ɓe mbi'i : —War mo, njoofanaa min Barabas ! ");
INSERT INTO fuh_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabas uddaama ngam no tawaa nder murtol gaɗunoongol nder huɓeere *Ursaliima, he ngam o wari goɗɗo. ");
INSERT INTO fuh_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilaatus haaldi he maɓɓe kaden ngam omo hiɗi o yoofa Iisa. ");
INSERT INTO fuh_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Amma ɓe puɗɗi, iɓe kuuɓa, iɓe mbi'a : —Tontu mo ! Tontu mo dow *bardugal ! ");
INSERT INTO fuh_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilaatus yeeƴi haaldi he maɓɓe kaden wi'i ɓe : —Ko boni oye o waɗi ko foti nii fuu ? Mi hi'aay daliila fuu ko foti o waree. Ndenne, mi ɓoccan mo, mi yoofa mo. ");
INSERT INTO fuh_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ɓe tinni iɓe kuuɓa sanne, iɓe mbi'a o tontee faa ɓe njaalii Pilaatus. ");
INSERT INTO fuh_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Nden Pilaatus jaɓi waɗande ɓe ko ɓe ƴami. ");
INSERT INTO fuh_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","O yoofani ɓe, uddanooɗo ngam murtol e barol goɗɗo mo ɓe ƴami yoofee oon. Nden o watti Iisa nder juuɗe maɓɓe, faa ɓe ngaɗa mo ko weli ɓe. ");
INSERT INTO fuh_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Wakkati soogeeji ɗiin njaarannoo Iisa, sey ɗi potti Simon mo Sirene no wara no ƴuwa gese. Ɓe nanngi mo ɓe tilsini mo o wakkoo *leggal bardugal Iisa, ɓe mbi'i mo o tokkira Iisa gaɗa gaɗa. ");
INSERT INTO fuh_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Jama'aare tokki Iisa, rewɓe gom no ndeki juuɗe dow ko'e mum'en no mboya ngam makko. ");
INSERT INTO fuh_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Iisa yeeƴitii rewɓe ɓee, wi'i ɓe : —Rewɓe *Ursaliima, to mboyee kam, mboyee ko'e mooɗon e ɓiɓɓe mooɗon ! ");
INSERT INTO fuh_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ngam nyalaaɗe ngaran ɗe himɓe mbi'ata : « On mbeli ko'e onon rewɓe rimarɓe, ɓe deeɗi mum'en caawaay abada, enɗi mum'en musinaay sam. » ");
INSERT INTO fuh_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Nder wakkati mum himɓe mbi'an baamle caama dow mum'en, ɓe mbi'a ƴoole cudda ɗum'en. ");
INSERT INTO fuh_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Nde lekki kecci waɗaama iri nii he banndum noy ki waɗetee nde ki yoorii ? ");
INSERT INTO fuh_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ɓe ardini Iisa he bonɓe ɗiɗo gom ngam ɓe mbardee he makko. ");
INSERT INTO fuh_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Wakkati ɓe njottinoo nokkuure wi'eteene Laalagal hoore, ɓe tonti mo dow *leggal bardugal. Ɓe tonti bonɓe ɗiɗo ɓeen duu, oo nyaamo Iisa, ooto nano. ");
INSERT INTO fuh_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Iisa wi'i : —*Baaba, yaafa ɓe ngam ɓe anndaa ko ɓe ngaɗata. Soogeeji ɗiin piyi caaca ngam senndude kolte makko caka mum'en. ");
INSERT INTO fuh_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Himɓe no ndarii ɗon no ƴeewa. Hooreeɓe *Yahudankooɓe duu puɗɗi no njawoo mo, no mbi'a : —O dannii woɓɓe, jooni o danna hoore makko, nde nii o *Almasiihu, Cuɓaaɗo Alla ! ");
INSERT INTO fuh_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Soogeeji ɗiin duu njawii mo, ngaddani mo ndiyam lammuɗam, ");
INSERT INTO fuh_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","mbi'i mo : —Too, nde nii aan woni Laamiiɗo *Yahudankooɓe, dannu hoore maa ! ");
INSERT INTO fuh_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Dow timtude hoore Iisa ɓe mbinndi dow alluwal : « Oo woni Laamiiɗo *Yahudankooɓe », ɓe takki. ");
INSERT INTO fuh_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Gooto nder tontidaaɓe he makko ɓeen no yenna mo, no wi'a : —Hanaa aan woni *Almasiihu naa ? Dannu hoore maa, ndannaa min, minen duu ! ");
INSERT INTO fuh_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Nden ooto feli banndum, wi'i : —A hulataa Alla naa ? Kiite goote ngaɗanaɗon aan e makko fuu. ");
INSERT INTO fuh_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Enen, en keɓii ko kaanuɗen, kiite meeɗen no goonga jaati. Ko ngolluɗen nii njoɓaɗen. Amma gorko oo waɗaay ko boni fuu. ");
INSERT INTO fuh_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Nden o wi'i : —Iisa, miccitoɗaa kam wakkati ngartuɗaa nder laamu maa. ");
INSERT INTO fuh_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Sey Iisa jaabii mo, wi'i : —Miɗo haalane goonga, hannden jaati a wondan he am nder aljanna. ");
INSERT INTO fuh_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Caka nyalooma, naange niɓɓi. Nimre huuri leydi ndiin fuu faa ɗum waɗi jamɗe tati. Riido palaaɗo nder *Juulirde mawne oon serki caka, laatii pecce ɗiɗi. ");
INSERT INTO fuh_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Iisa huuɓi huuɓaaŋo manngo, wi'i : —*Baaba, mi tummbi yonki am nder juuɗe maa. Gaɗa haalaaji ɗii, o foofi foofaango makko sakitiingo. ");
INSERT INTO fuh_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Wakkati hooreejo soogeeji *Rooma hi'unoo ko waɗi, teddini Alla, wi'i : —Sikka fuu walaa, neɗɗo oo no dartiiɗo ! ");
INSERT INTO fuh_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Himɓe ɗuɓɓe warnooɓe ƴeewi, wakkati ngi'unoo ko waɗi ɗum, coƴƴitii, ndeki juuɗe dow ko'e mum'en no mboya. ");
INSERT INTO fuh_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Amma annduɓe mo ndarii to toowti no ndaara. Rewɓe tokkunooɓe Iisa illa Galili duu no hakkune maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Nder hawriine dawrooɓe no woodi gorko lobbo, dartiiɗo gom, jeyaaɗo Arimatiya nder leydi Yahudiya bi'eteeɗo Yusufu. O haaɓi o hi'aay banngol Laamu Alla. Yusufu jaɓaaynoo laabi ɗi hawriine dawrooɓe ndeen darnunoo, o jaɓaay duu ko nde waɗi. ");
INSERT INTO fuh_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Sey o ummii, o yehi to Pilaatus ngam ŋaaraade mo ɓanndu Iisa. ");
INSERT INTO fuh_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","O waɗi ɓanndu Iisa jippina dow *leggal bardugal. O fiili ndu kasanke, o watti nder annyeere seɓaane nder tepaare gom nde baa gooto fukkinaaka nder mum. ");
INSERT INTO fuh_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ɗum fotodiri aljumaare, *nyalaane fowteteene duu ɓadake. ");
INSERT INTO fuh_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Rewɓe wondunooɓe he Iisa illa Galili tokki Yusufu, ngi'ii annyeere ndeen e no ɓanndu makko wattiraa nder mayre. ");
INSERT INTO fuh_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ɓe kooti wuro, ɓe ciryowii nebbeele uurɗe e turaare ngam wujjude ɓanndu Iisa. Ɓe powti *nyalaane fowteteene hano no *Tawreeta wi'iri ɗum. ");
INSERT INTO fuh_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Alal illa subaka kecco, rewɓe wondunooɓe he Iisa illa Galili ɓeen pa'i to annyeere ndeen. Ɓe njaldi nebbeele uurɗe ɗe ɓe ciryinoo. ");
INSERT INTO fuh_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ɓe ngari, ɓe tawi kaaƴa ommbiranoonga annyeere ndeen tallitaama. ");
INSERT INTO fuh_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Wakkati ɓe naatunoo, ɓe tawaay ɓanndu Iisa Joomiraawo. ");
INSERT INTO fuh_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Hakkillooji maɓɓe ummii, sey worɓe ɗiɗo gom mbanngi yeeso maɓɓe. Iɓe ɓornii kolte ƴelkitittooɗe. ");
INSERT INTO fuh_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Kulal nanngi ɓe, sey ɓe leyni ko'e maɓɓe faa he leydi. Worɓe ɗiɗo ɓeen mbi'i ɓe : —Ko saabi oɗon tefa buurɗo hakkune maayɓe ? ");
INSERT INTO fuh_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","O walaa ɗo, o ummitake. Oɗon miccitoo ko o haalannoo on illa nder leydi Galili naa ? ");
INSERT INTO fuh_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","O wi'i : « No tilsi *Ɓii-Neɗɗo wattee nder juuɗe waɗooɓe hakke, tontee dow *bardugal, nden nyalaane tataɓere mum ummitoo. » ");
INSERT INTO fuh_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Nden ɓe miccitii he haalaaji Iisa ɗiin. ");
INSERT INTO fuh_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ɓe ndilli to annyeere ndeen, ɓe coƴƴitii, ɓe kaalanowi *lilaaɓe sappo e go'o ɓeen he *aahiiɓe ɓeeto. ");
INSERT INTO fuh_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Mariyaama mo Magdaala, Yowanna e Mariyaama inna Yakuuba he rewɓe wondunooɓe he maɓɓe gom kam'en ngoni rewɓe warɓe kaalani *lilaaɓe ɓeen. ");
INSERT INTO fuh_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ɓe kaalani *lilaaɓe ɓeen fuu, amma *lilaaɓe ɓeen adi haala maɓɓe hano meere, ɓe ngoonɗinaay. ");
INSERT INTO fuh_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Nden Piyer ummii, doggi fa'i to annyeere ndeen. Wakkati o yuurninoo nder mayre, kasanke oon tan o hi'i. O hooti nder wemmbere, omo ƴama hoore makko ko waɗi. ");
INSERT INTO fuh_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Alal mo rewɓe ɓeen ngarnoo kaalani *aahiiɓe ɓeen, *aahiiɓe ɗiɗo gom nanngi laawol Emmayus. Hakkune wuro ngoo e *Ursaliima no waɗa yaadu jamɗe ɗiɗi. ");
INSERT INTO fuh_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Iɓe njeha iɓe njewta dow ko waɗi ɗum. ");
INSERT INTO fuh_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Wakkati ɓe njewtannoo, sey Iisa e hoore mum hewtii ɓe, no yaada he maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Amma Alla haɗii ɓe anndita mo. ");
INSERT INTO fuh_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Iisa ƴami ɓe, wi'i : —Dow ɗume ngonɗon oɗon njewta dow laawol ngool ? Sey ɓe ndarii kak, iɓe ɓalinii. ");
INSERT INTO fuh_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Nden Kiliyopas jaabii mo, wi'i : —Ndenne, aan tan woni koɗo nder *Ursaliima mo anndaa ko waɗi nder nyalaaɗe ɗee ? ");
INSERT INTO fuh_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Sey Iisa wi'i ɓe : —Ɗume ? Ɓe mbi'i : —Ko waɗi he Iisa mo Nasaratu ! O annabiijo, jom baawɗe nder ko haalata e ko gollata yeeso Alla e yeeso himɓe fuu. ");
INSERT INTO fuh_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Amma hooreeɓe *cakkanooɓe Alla e mawɓe meeɗen ngatti mo nder juuɗe laamu ngam o jukkee jukkol maayde. Ɓe tonti mo dow *bardugal. ");
INSERT INTO fuh_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Miɗen tammi ko kanko soptinta *Isra'el. Hannden woni nyalooma tataɓo ko ɗum waɗi. ");
INSERT INTO fuh_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Kaden duu, rewɓe hawriine amin gom kaayɗini min. Illa subaka kecco ɓe njehi to annyeere makko, ");
INSERT INTO fuh_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","amma ɓe tawaay ɓanndu makko. Nden ɓe ngarti, ɓe mbi'i maleykaaɓe mbannganii ɗum'en, ɓe mbi'i omo wuuri. ");
INSERT INTO fuh_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Woɓɓe nder amin gom ummii njehi to annyeere ndeen. Ɓe tawi huune fuu hano no rewɓe ɓeen mbi'irnoo min. Amma ɓe ngi'aay mo, kanko e hoore makko. ");
INSERT INTO fuh_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Sey Iisa wi'i ɓe : —Hey onon famɗuɓe hakkillo ! Ɓe njaawaa goonɗinde haala annabiiɓe ! ");
INSERT INTO fuh_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Hanaa no tilsi *Almasiihu torree, fadde mum naatude nder teddungal mum ? ");
INSERT INTO fuh_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Nden Iisa famtini ɓe ko dewte fuu kaalunoo dow mum, illa nder *Tawreeta faa wara nder dewte annabiiɓe. ");
INSERT INTO fuh_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Wakkati ɓe paaniino Emmayus, sey Iisa waɗi hano wittoto. ");
INSERT INTO fuh_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Nden ɓe ŋaarii mo, ɓe mbi'i : —Waalan min, ngam hiiri. Jemma duu naatii. Sey o tokki ɓe, o weerani ɓe. ");
INSERT INTO fuh_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Wakkati ɓe njooɗinoo faa ɓe nyaama, Iisa hooƴi buuru, yetti Alla, helti buuru oon, hokki ɓe. ");
INSERT INTO fuh_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Sey gite maɓɓe peertii, ɓe annditi Iisa. Wakkati mum da o majji yeeso maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Nden ɓe mbi'odiri : —Wakkati o haaldannoo en dow laawol, omo famtina en ko dewte Ceniiɗe mbi'i, en nani belɗum nder ɓerɗe meeɗen. ");
INSERT INTO fuh_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ɓe ummii sabat, ɓe coƴƴi *Ursaliima, ɓe tawtowi *lilaaɓe sappo e go'o ɓeen e wonduɓe he mum'en. ");
INSERT INTO fuh_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Nden ɓe mbi'i kamɓe duu : —Goonga non, Joomiraawo meeɗen ummitake. O wannganii Simon Piyer. ");
INSERT INTO fuh_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Nden *aahiiɓe ɗiɗo ɓeen kaalani ɓe ko waɗunoo dow laawol mum'en fuu. Ɓe kaalani ɓe duu no waɗi ko ɓe annditi mo wakkati o heltannoo buuru oon. ");
INSERT INTO fuh_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Kiliyopas'en no caka haala, sey Iisa e hoore mum wanngi hakkune maɓɓe, wi'i ɓe : —Jam wonda he mooɗon ! ");
INSERT INTO fuh_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ɓerɗe maɓɓe taƴi, ɓe kuli, ɓe miili ko mbeelu maayɗo gom ɓe ngi'ii. ");
INSERT INTO fuh_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Nden Iisa wi'i ɓe : —Ɗume waɗi hakkillooji mon ummi ? Ɗume waɗi sikka no tawaa nder ɓerɗe mooɗon ? ");
INSERT INTO fuh_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ƴeewee juuɗe am e koyɗe am, paamon ko miin nii non. Meemee kam, ƴeewon. Mi hanaa mbeelu maayɗo ngam mbeelu walaa ɓanndu, walaa gi'e. ");
INSERT INTO fuh_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Wakkati o haaldannoo he maɓɓe, o holli ɓe juuɗe e koyɗe makko. ");
INSERT INTO fuh_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Amma ɗum fuu waɗaay ɓe njaɓa ko kanko non ngam iɓe keewi welwelo, haayne majjum duu no tawa he maɓɓe. Iisa ƴami ɓe wi'i : —Oɗon njogii ko nyaamee ɗo naa ? ");
INSERT INTO fuh_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ɓe ngaddani mo ŋoppitto linngu njuɗaangu gom. ");
INSERT INTO fuh_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","O jaɓi ŋo, o nyaami yeeso maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Nden o wi'i ɓe : —Wakkati ngondunoomi he mooɗon, mi wi'iino on no tilsi kujje ɗe *Tawreeta, dewte annabiiɓe e *Jabuura kaali dow am fuu kuuɓa. ");
INSERT INTO fuh_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","O fiirti ko'e maɓɓe, ngam ɓe paama dewte ɗeen. ");
INSERT INTO fuh_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","O wi'i ɓe : —Nii ɗum winndiraa : No tilsi *Almasiihu torree faa maaya, ummitoo nyalaane tataɓere. ");
INSERT INTO fuh_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Nder innde makko duu, lenyi ɗii fuu no mbaajetee faa tuuba keɓa jaafol hakkeeji mum'en. Ɗum fuu, ɗum fuɗɗan nder *Ursaliima. ");
INSERT INTO fuh_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Onon ngoni seedantooɓe kujje ɗee fuu ! ");
INSERT INTO fuh_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Miin, mi lildan *Ruuhu Ceniiɗo mo *Baaba am waɗani on alkawal dow mum. Amma njooɗee nder huɓeere ndee, faa baawɗe gonɗe dow njippoo keewa on, on fuu. ");
INSERT INTO fuh_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Iisa yaari *aahiiɓe ɓeen faa hadde Baytaniya. O ɓanti juuɗe, o barkini ɓe. ");
INSERT INTO fuh_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Wakkati o barkinannoo ɓe, sey o seedi he maɓɓe, o ƴencinaa dow. ");
INSERT INTO fuh_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ɓe cujidani mo, nden ɓe coƴƴi *Ursaliima nder welwelo manngo. ");
INSERT INTO fuh_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Wakkati fuu iɓe tawee nder *Juulirde mawne, iɓe teddina Alla.");
INSERT INTO fuh_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Illa fuɗɗorde Haala no woodi. Haala kaan no wondunoo he Alla, kanka woni Alla. ");
INSERT INTO fuh_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ika wondi he Alla illa fuɗɗorde. ");
INSERT INTO fuh_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","He makka Alla tagiri huune fuu. Huune fuu ko tagaa he makka ƴuwi. ");
INSERT INTO fuh_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Mbuurnam woni he makka, mbuurnam ɗaam laatanii himɓe jeyngol. ");
INSERT INTO fuh_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Jeyngol ngool no yayna nder nimre. Nimre ndee waawaay nyifude ngol. ");
INSERT INTO fuh_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","No woodunoo neɗɗo gom mo Alla lilunoo bi'eteeɗo Yahaaya. ");
INSERT INTO fuh_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","O wari hano seedeejo ngam seedanaade jeyngol ngool, heɓa himɓe fuu ngoonɗina ngol. ");
INSERT INTO fuh_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Hanaa kanko woni jeyngol ngool, amma o wari seedaade dow maggol. ");
INSERT INTO fuh_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Haala kaan woni Jeyngol goongaawol, garngol nder duuniyaaru, jaynanoowol himɓe fuu. ");
INSERT INTO fuh_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ika nder duuniyaaru, sabbu makka duuniyaaru tagaa, amma duuniyaaru annditaay ka. ");
INSERT INTO fuh_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ka warii to lenyol makka, amma lenyol makka jaɓaay ka. ");
INSERT INTO fuh_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Amma jaɓuɓe ka fuu, goonɗinɓe ka ɓeen, ka hokki ɓe baawɗe laataade ɓiɓɓe Alla. ");
INSERT INTO fuh_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ɓe ndimiraaka hano no ɓiɓɓe aadama ndimirtee naa har muuyo neɗɗo, amma dimngol maɓɓe ƴuwi to Alla. ");
INSERT INTO fuh_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Haala kaan laatake neɗɗo. Neɗɗo oon jooɗake hakkune meeɗen, o keewɗo moƴƴere e goonga. Min ngi'ii teddungal makko, hano teddungal ngal Ɓiɗɗo bajjo heɓata to *Baaba mum. ");
INSERT INTO fuh_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yahaaya seedake dow makko, huuɓi, wi'i : —Oo woni mo kaalannoomi on haala mum, mbi'umi : « Gaɗa am, artuɗo kam waran, sabu omo ɗon illa mi walaano ɗon. » ");
INSERT INTO fuh_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ngam ɗuuɗal moƴƴere makko en fuu en keɓii barke dow barke. ");
INSERT INTO fuh_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Sabu *Muusa keɓirɗen *Tawreeta, amma moƴƴere e goonga sabu Iisa *Almasiihu heɓiraa. ");
INSERT INTO fuh_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Baa gooto hi'aay Alla abada, amma Ɓiɗɗo bajjo gonɗo Alla, korsuɗo kawtuɗo he *Baabiraawo, faamini en mo. ");
INSERT INTO fuh_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ɗum woni seede Yahaaya wakkati mawɓe *Yahudankooɓe *Ursaliima lilunoo *cakkanooɓe Alla e *Lewinkooɓe ƴamowa mo, kanko woni moy. ");
INSERT INTO fuh_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","O salaaki jaabaade ɓe amma o haaliranii ɓe no laaɓiri, o wi'i : —Mi hanaa *Almasiihu. ");
INSERT INTO fuh_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ɓe ƴami mo, ɓe mbi'i : —Aan, a moy ? A Eliya naa ? O wi'i : —Mi hanaa. Ɓe mbi'i : —A annabiijo garoowo oon naa ? O jaabii : —Hanaa ! ");
INSERT INTO fuh_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ɓe mbi'i mo : —Ndenne, a moy ? Haalan min ko min kaalanoyta liluɓe min. Ɗume mbiiɗaa dow hoore maa ? ");
INSERT INTO fuh_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","O jaabii, o wi'i : —Miin woni kuuɓoowo nder ladde yeeruure no wi'a : Moƴƴinee laabi Joomiraawo hano no annabi *Esaaya wi'iri nii. ");
INSERT INTO fuh_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Lilaaɓe ɓee to *Fariisa'en ƴuwi. ");
INSERT INTO fuh_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ɓe ƴami mo, ɓe mbi'i : —Ko saabii ko aɗa waɗana himɓe *batisma nder ndiyam tawi a hanaa *Almasiihu. A hanaa Eliya, a hanaa annabiijo oon ? ");
INSERT INTO fuh_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yahaaya jaabii ɓe, wi'i : —Miin, miɗo waɗana himɓe *batisma nder ndiyam, amma no woodi goɗɗo hakkune mon mo on anndaa. ");
INSERT INTO fuh_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Kanko woni garoowo gaɗa am mo mi fotaay baa fiirtude ɓoggi paɗe mum. ");
INSERT INTO fuh_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ɗum fuu ɗum waɗi Baytaniya gaɗa maayo Urdun, to Yahaaya woni no waɗana himɓe *batisma nder ndiyam. ");
INSERT INTO fuh_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Jaangoore mum Yahaaya hi'i Iisa no wara to mum, wi'i : —Ndaaree *Njawdiri Alla ittoori hakkeeji duuniyaaru. ");
INSERT INTO fuh_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ɗum woni ko mbi'unoomi dow makko : « Neɗɗo gom waran gaɗa am, artuɗo kam, sabu omo ɗon illa mi tagaaka. » ");
INSERT INTO fuh_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Miin, mi anndaano mo. Amma mi wari, miɗo waɗana himɓe *batisma nder ndiyam ngam o wanngana himɓe *Isra'el. ");
INSERT INTO fuh_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Yahaaya seedake, wi'i : —Mi hi'i *Ruuhu Alla nder nanndi wuugaanu ƴuwi dow jippii dow makko. ");
INSERT INTO fuh_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Miin, mi anndaano mo. Amma lilɗo kam mi waɗana himɓe *batisma nder ndiyam oon wi'i kam : « Oon mo ngi'ataa *Ruuhu no jippoo dow mum oo, kanko woni gaɗanoowo himɓe *batisma nder *Ruuhu Ceniiɗo. » ");
INSERT INTO fuh_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Miin, mi hi'i, mi seedake kanko woni *Ɓii-Alla. ");
INSERT INTO fuh_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Jaangoore mum kaden Yahaaya no dardii aahiiɓe mum ɗiɗo gom. ");
INSERT INTO fuh_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","O hi'i Iisa no yawta, sey o wi'i : —Ndaaree *Njawdiri Alla ! ");
INSERT INTO fuh_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Aahiiɓe ɗiɗo ɓeen nani ko o haali ɗum, tokkitii Iisa. ");
INSERT INTO fuh_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Iisa yeeƴitii, hi'i iɓe tokki ɗum, wi'i ɓe : —Ɗume tefoton ? Ɓe njaabii, ɓe mbi'i : —Rabbi, toy njooɗotoɗaa ? Rabbi kam woni Moodibbo. ");
INSERT INTO fuh_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Nden o wi'i ɓe : —Ngaree, ƴeewee ! Fotodiri laasara waɗi. Ɓe njehi, ɓe ngi'ii to o jooɗoto, ɓe kiirtidi he makko toon. ");
INSERT INTO fuh_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andiire, minyo Simon Piyer, no tawa nder aahiiɓe ɗiɗo tokkuɓe Iisa wakkati ɓe nanunoo haala Yahaaya. ");
INSERT INTO fuh_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","O wari to Simon Piyer, o wi'i ɗum : —Min ngi'ii *Almasiihu. *Almasiihu maana mum woni « Cuɓaaɗo » oon. ");
INSERT INTO fuh_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","O yaari Simon Piyer to Iisa. Iisa ƴeewi mo, wi'i : —Aan, a Simon ɓii-Yahaaya, a innditirtee Kefas. Maana Kefas e Piyer woni hayre. ");
INSERT INTO fuh_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Jaangoore mum Iisa haɓɓi anniya yahde leydi Galili. O fotti Filipa, o wi'i mo : —Tokkam ! ");
INSERT INTO fuh_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipa no jeyaa Baytisayda, wuro Andiire e Piyer. ");
INSERT INTO fuh_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filipa fotti Natanayel, wi'i mo : —Min ngiidii he oon mo habaru mum winndanoo nder *Tawreeta Muusa e nder dewte annabiiɓe, Iisa ɓii-Yusufu mo Nasaratu. ");
INSERT INTO fuh_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Sey Natanayel wi'i mo : —Ko wooɗi no waawi ƴuwde Nasaratu naa ? Filipa jaabii mo, wi'i : —War, ƴeewu ! ");
INSERT INTO fuh_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Wakkati Iisa hi'unoo Natanayel no wara to mum, sey wi'i : —Oo woni *Isra'ilanke jaati. Jiɓe fuu walaa he makko. ");
INSERT INTO fuh_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nden Natanayel wi'i mo : —Toy annduɗaa kam ? Iisa jaabii mo, wi'i : —Mi hi'i ma ley ibbi illa Filipa noddaay ma. ");
INSERT INTO fuh_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanayel jaabii, wi'i : —Moodibbo, a *Ɓii-Alla. A Laamiiɗo *Isra'el. ");
INSERT INTO fuh_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Iisa jaabii mo, wi'i : —Sabu mi wi'i mi hi'i ma ley ibbi tan ngoonɗinɗaa naa ? A hi'an ko ɓuri ɗum manngu. ");
INSERT INTO fuh_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Nden Iisa ɓeydi wi'ude : —Goonga kaalananmi on : On ngi'an kammu no maɓɓitoo, maleykaaɓe Alla no njippoo no ŋabba dow *Ɓii-Neɗɗo. ");
INSERT INTO fuh_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Balɗe ɗiɗi gaɗa mum, kaɓɓal waɗi Kaana nder leydi Galili. Inna Iisa no tawanoo toon. ");
INSERT INTO fuh_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Iisa e *aahiiɓe mum duu noddaama to maggal. ");
INSERT INTO fuh_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Wakkati cabiijam maɓɓe kaɗɗam hantunoo, sey inna Iisa wi'i Iisa : —Ɓe ngalaa cabiijam. ");
INSERT INTO fuh_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Iisa jaabii mo, wi'i : —Inna day, munyanam. Ɗume ngiɗɗaa mi waɗa ? Wakkati am yonaay ginan. ");
INSERT INTO fuh_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Nden inniiko wi'i gollooɓe ɓeen : —Ngaɗee ko o wi'i on fuu. ");
INSERT INTO fuh_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Looɗe jeegom gaɗiraaɗe kaaƴe gom no tawaa ɗon hadde maɓɓe. Looɗe ɗee ngaɗaama ngam al'aada laaɓinol *Yahudankooɓe. Loone fuu no hooƴa ko watta liitereeji hemre. ");
INSERT INTO fuh_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Iisa wi'i gollooɓe ɓeen : —Kebbinee looɗe ɗee ndiyam. Ɓe kebbini ɗe faa ɗe keewi pet. ");
INSERT INTO fuh_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Sey Iisa wi'i ɓe : —Joonkay, nyeɗee, njaaranee ardiiɗo batu oon. Ɓe nyeɗi ɓe njaarani ardiiɗo oon. ");
INSERT INTO fuh_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ardiiɗo batu oon meeɗi ndiyam mbaylitaaɗam cabiijam ɗaam. O anndaa to ɗam ƴuwii, amma gollooɓe nyeɗuɓe ɗaam kay, no anndi. Nden o noddi ɓaŋuɗo oon, ");
INSERT INTO fuh_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","o wi'i ɗum : —Himɓe fuu cabiijam mbelɗam mboowi fuɗɗirde. Nden nde ɗam fuɗɗi nanngude ɓe, ɗam welaa ɗam waddee. Amma aan, a resi ɓurɗam welde ɗam naako joonin. ");
INSERT INTO fuh_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Alaama kaayɗiniiɗo oo woni alaama kaayɗiniiɗo arano mo Iisa waɗi. O waɗii mo nder wuro Kaana nder leydi Galili. O wanngini teddungal makko. *Aahiiɓe makko ngoonɗinii mo. ");
INSERT INTO fuh_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Gaɗa ɗum Iisa, innum, minyiraaɓe mum he *aahiiɓe mum njehi Kafarnahum. Ɓe njooɗii toon balɗe seɗɗa. ");
INSERT INTO fuh_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Wakkati juulɗe *Yahudankooɓe bi'eteeɗe *Juulɗe dimɗinol Isra'ilankooɓe ɓadinoo, Iisa yehi *Ursaliima. ");
INSERT INTO fuh_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Nder jawreeru *Juulirde Ursaliima mawne Iisa tawi sonnooɓe ga'i, baali e buugaali he weccooɓe ceede no njooɗii. ");
INSERT INTO fuh_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","O sowi ɓoggi, o riiwi ɓe nder *Juulirde mawne ndeen, kamɓe e ga'i maɓɓe e baali maɓɓe fuu. O sankitii ceede weccooɓe ɓeen, o liɓi teburuuji maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","O wi'i sonnooɓe buugaali ɓeen : —Ittee ɗum ɗoo ! To ngaɗee suudu *Baaba am luumorde ! ");
INSERT INTO fuh_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","*Aahiiɓe makko miccitii ko winndanoo nder dewte wi'aa : Kiranol suudu maa no huɓɓa ɓerne am sanne. ");
INSERT INTO fuh_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Nden mawɓe *Yahudankooɓe mbi'i mo : —Ir haayne ndeye mbaawɗaa waɗude ngam hollude min ko a foti waɗude ko ngaɗɗaa ɗum ? ");
INSERT INTO fuh_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Iisa jaabii ɓe, wi'i : —Pusee *Juulirde mawne ndee, mi nyiɓitan nde nder balɗe tati. ");
INSERT INTO fuh_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ɓe mbi'i mo : —Juulirde ndee nyiɓiraama duuɓi lasooji ɗiɗi e jeegom. Dey aan, mbiiɗaa a nyiɓitan nde nder balɗe tati ? ");
INSERT INTO fuh_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Amma Iisa kay fonndaana *Juulirde mawne ndeen e ɓanndu mum. ");
INSERT INTO fuh_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ngam majjum waɗi wakkati Iisa ummitinoo, *aahiiɓe makko miccitii ko o haalunoo ɗum'en. Ɓe ngoonɗini ko winndaa wi'aa nder dewte ɗeen e konngi ɗi o haalunoo. ");
INSERT INTO fuh_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Wakkati Iisa yehunoo *Juulɗe dimɗinol Isra'ilankooɓe nder *Ursaliima, himɓe ɗuɓɓe ngoonɗini mo ngam ɓe ngi'ii alamaaji kaayɗiniiɗi ɗi o waɗi. ");
INSERT INTO fuh_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Iisa hoolaaki ɓe ngam ɓe fuu, omo anndi ɓe sanne. ");
INSERT INTO fuh_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","O haajaaka baa gooto maɓɓe seedanoo mo dow ɓiɓɓe aadama, ngam omo anndi ko woni nder ɓerɗe maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Nder hawriine *Fariisa'en no woodunoo gorko gom bi'eteeɗo Nikodemu. Nikodemu no tawa duu nder hooreeɓe *Yahudankooɓe. ");
INSERT INTO fuh_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Jemma gom o yehi to Iisa, o wi'i ɗum : —Moodibbo, miɗen anndi a moodibbo mo Alla lili. Walaa baawɗo waɗi kaayɗe ɗe ngaɗataa ɗee, nde Alla wondaa he joomum. ");
INSERT INTO fuh_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Sey Iisa jaabii mo, wi'i : —Miɗo haalane goonga : Walaa baawɗo hi'ude Laamu Alla se rimtaaka. ");
INSERT INTO fuh_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodemu ƴami mo, wi'i : —Noy neɗɗo waawi rimiteede gaɗa naywi ? Omo waawi soƴƴaade nder reedu inniiko, o rimitee naa ? ");
INSERT INTO fuh_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Iisa jaabii mo wi'i : —Miɗo haalane goonga : Nde neɗɗo rimtiraaka ndiyam e *Ruuhu Alla, waawtaa naatude nder Laamu Alla. ");
INSERT INTO fuh_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ɓii-aadama rimataana ɓii-aadama. *Ruuhu duu, rimataana ruuhu. ");
INSERT INTO fuh_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","To ɗum haayɗine ngam mi wi'i no tilsi ndimiteɗaa. ");
INSERT INTO fuh_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Henndu no wifa to muuyri fuu. Aɗa nana bifol mayru, amma a anndaa to ndu ƴuwi, a anndaa to ndu fa'i. Hano non dimiraaɗo *Ruuhu Alla duu worri. ");
INSERT INTO fuh_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodemu wi'i mo : —Noy ɗum laatortoo ? ");
INSERT INTO fuh_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Iisa jaabii mo wi'i : —Baa ko a moodibbo *Isra'el mawɗo, a anndaa ɗum naa ? ");
INSERT INTO fuh_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Miɗo haalane goonga : Minen, ko min anndi, min kaalata. Ko min ngi'ii, min ceedantoo. Amma on njaɓataa seede amin. ");
INSERT INTO fuh_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","On ngoonɗinaay nde kaalanmi on dow kujje duuniyaaru. Noy ngoonɗinirton se mi haalanii on dow kujje kammu ? ");
INSERT INTO fuh_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Walaa ŋabbuɗo dow kammu, se hanaa ƴuwɗo dow oon. *Ɓii-Neɗɗo kam duu woni ƴuwɗo dow oon. ");
INSERT INTO fuh_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Hano no *Muusa ɓantiri mboddi gaɗiraani njamndi mboɗeeri nder ladde yeeruure, hano non *Ɓii-Neɗɗo duu ɓantirtee, ");
INSERT INTO fuh_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ngam goonɗinɗo mo fuu heɓa mbuurnam nduumiiɗam. ");
INSERT INTO fuh_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ngam Alla no hiɗi duuniyaaru sanne waɗi o hokkitiri *Ɓiyiiko bajjo, heɓa goonɗinɗo mo fuu to halku, amma heɓa mbuurnam nduumiiɗam. ");
INSERT INTO fuh_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Alla lilaay Ɓiyum nder duuniyaaru ngam o hiitoo ndu, amma ngam ndu hisaa daliila makko. ");
INSERT INTO fuh_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Goonɗinɗo mo fuu hiitataake. Amma mo goonɗinaay mo hiitaama jaati, ngam goonɗinaay *Ɓii-Alla bajjo. ");
INSERT INTO fuh_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ndaa kiite maɓɓe nii : Jeyngol warii nder duuniyaaru, amma himɓe ngam golleeji mum'en bonɗi ngiɗi nimre ɓurde ngol. ");
INSERT INTO fuh_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Bonɗo golle fuu hiɗaa jeyngol, omo wurtoo nder maggol, ngam omo hula to golleeji makko bonɗi mbanngu. ");
INSERT INTO fuh_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Amma golliroowo goonga waran nder jeyngol heɓa golleeji ɗi waɗi ngam Alla ɗii mbanngaa. ");
INSERT INTO fuh_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Gaɗa mum Iisa yahdi *aahiiɓe mum Yahudiya. O joddii he maɓɓe wakkatiyel, omo waɗana himɓe *batisma. ");
INSERT INTO fuh_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yahaaya duu no waɗana himɓe *batisma nokkuure wi'eteene Aynon hadde Salim. Toon ndiyam no ɗuuɗi sanne. Himɓe no njaha toon no ngaɗanee *batisma. ");
INSERT INTO fuh_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Wakkati mum Yahaaya nanngaaka kasu. ");
INSERT INTO fuh_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Sey geddi dow farillaaji laaɓinol ɓanndu naati hakkune aahiiɓe Yahaaya he Yahudanke gom. ");
INSERT INTO fuh_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ɓe njehi to Yahaaya, ɓe mbi'i mo : —Moodibbo, aɗa miccitoo gorko gondunooɗo he maa toon gaɗa maayo Urdun, gorko mo ceedaninoɗaa oon ? Kanko duu, omo waɗana himɓe *batisma. Himɓe fuu no njaha to makko ! ");
INSERT INTO fuh_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Nden Yahaaya jaabii ɓe, wi'i : —Neɗɗo waawtaa heɓude goɗɗum se hanaa Alla hokki ɗum. ");
INSERT INTO fuh_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Onon e ko'e mooɗon, on seedeeɓe am ngam mi wi'i mi hanaa *Almasiihu amma miɗo arti mo lileede. ");
INSERT INTO fuh_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Gaddanaaɗo ɓaŋaaɗo, kam woni ɓaŋuɗo. Higo ɓaŋuɗo oon no darii, no hettinani mo. Se nanii daane makko no welnan sanne. Iri welwelo ngoo nananmi faa noy walaa. ");
INSERT INTO fuh_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","No tilsi Iisa ɓeydoo, miin duu mi ɓuytoo. ");
INSERT INTO fuh_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ƴuwɗo dow oon, no ɓuri huune fuu. Ƴuwɗo nder duuniyaaru oon, duuniyaaru jeyi ɗum. Haala mum duu no haala jeyaaɓe nder mayru. Ƴuwɗo dow kammu oon, kam ɓuri huune fuu. ");
INSERT INTO fuh_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ko o hi'i e ko o nani, kam o seedantoo, amma baa gooto jaɓataa seedaaku makko. ");
INSERT INTO fuh_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Jaɓuɗo seedaaku makko, tabbintini ko Alla no goongaajo. ");
INSERT INTO fuh_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Mo Alla lili fuu, ko Alla haali haalata, ngam Alla hokki mo *Ruuhu mum mo walaa keerol. ");
INSERT INTO fuh_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","*Baabiraawo no hiɗi Ɓiɗɗo oon faa watti huune fuu nder junngo makko. ");
INSERT INTO fuh_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Goonɗinɗo Ɓiɗɗo oon heɓi mbuurnam nduumiiɗam. Amma caliiɗo goonɗinde Ɓiɗɗo oon heɓataa ɗam, mone Alla woodani joomum. ");
INSERT INTO fuh_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","*Fariisa'en nanii Iisa no waɗana himɓe *batisma, omo heɓa *aahiiɓe ɗuɓɓe ɓurde Yahaaya. ");
INSERT INTO fuh_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Amma nde goonga, Iisa e hoore mum kay, waɗanaay baa gooto *batisma. *Aahiiɓe makko tan ngaɗanannoo himɓe *batisma. ");
INSERT INTO fuh_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Wakkati Iisa nanunoo haala *Fariisa'en, o dilli Yahudiya, o soƴƴii Galili. ");
INSERT INTO fuh_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ko o ummii yahde Galili, sey o tokkiri *Samariya. ");
INSERT INTO fuh_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Nder leydi *Samariya, o wari wuro Sikar hadde ngesa nga Yakuuba hokkunoo ɓiyum Yusufu. ");
INSERT INTO fuh_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Nder Sikar, Yakuuba wasiino ɓunndu gom. Caka nyalooma Iisa yottii dow ɓunndu nduun, jahaangal ngaal duu tampinii mo. Nden o jooɗii daane mayru ngam o fowta. ");
INSERT INTO fuh_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","*Aahiiɓe ɓeen duu naati wuro ngoon ngam coodowa ko nyaamee. Sey ɓii-leydi *Samariya debbo gom wari faa ƴooga. Iisa wi'i mo : —Hokkaram ndiyam, mi yara ! ");
INSERT INTO fuh_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Nden debbo oon wi'i mo : —Noy ! Noy aan, Yahudanke, ƴamirtaa kam ndiyam njareteeɗam miin, ɓii-leydi *Samariya debbo ? Ngam potal walaano caka *Yahudankooɓe e himɓe leydi *Samariya. ");
INSERT INTO fuh_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Iisa jaabii mo wi'ii : —Nde aɗa anndi kokkal ngal Alla hokkata he kaden duu nde aɗa anndi duu ƴamuɗo ma ndiyam njareteeɗam, a ƴamannoo mo, o hokke ndiyam buurɗam. ");
INSERT INTO fuh_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Sey debbo oon wi'i mo : —Moodibbo, a walaa cawgal, ɓunndu nduun duu no luggiɗi. Toy keɓataa ndiyam buurɗam ɗaam ? ");
INSERT INTO fuh_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Aɗa ɓuri maama amin Yakuuba accanɗo min ɓunndu nduu manngu naa ? Kanko e hoore makko, ɓiɓɓe makko e dabbaaji makko fuu, njari he mayru. ");
INSERT INTO fuh_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Nden Iisa jaabii mo wi'i : —Neɗɗo fuu jarɗo ndiyam ɗaam, no ɗomɗetee kaden, ");
INSERT INTO fuh_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","amma jarɗo ndiyam ɗam kokkanmi ɗam, ɗomɗataake faa abada. Ngam ndiyam ɗam kokkanmoomi ɗam, no laatanto mo ndiyam iloojam kokkoojam mbuurnam nduumiiɗam. ");
INSERT INTO fuh_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Debbo oon wi'i : —Moodibbo, hokkaram ndiyam ɗam heɓa to mi ɗomɗee kaden, to mi wartu ƴoogude ɗo duu. ");
INSERT INTO fuh_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Iisa wi'i mo : —Yah noddoy gora, ngardon ! ");
INSERT INTO fuh_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Debbo oon jaabii mo wi'i : —Mi walaa goriiyo. Iisa wi'i mo : —Aɗa woodi goonga ko mbiiɗaa a walaa goriiyo. ");
INSERT INTO fuh_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","A waɗiino goriraaɓe joyo. Gorko mo ngonduɗaa joonin oo duu, hanaa gora. Ndenne, a haalii goonga. ");
INSERT INTO fuh_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Debbo oon wi'i mo : —Moodibbo, mi faamii a annabiijo. ");
INSERT INTO fuh_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Maamiraaɓe amin no ndewanno Alla dow waamnde ndee. Amma onon *Yahudankooɓe, oɗon mbi'a *Ursaliima toon Alla haani reweede. ");
INSERT INTO fuh_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Iisa wi'i mo : —Banndam debbo, jaɓu ko kaalananmaami : Wakkati waran, ko hanaa dow waamnde ndee naa *Ursaliima ndewoton *Baabiraawo. ");
INSERT INTO fuh_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Onon ɓiɓɓe leydi *Samariya, oɗon ndewa ko on anndaa, minen *Yahudankooɓe nee, ko min anndi min ndewata, ngam to *Yahudankooɓe kisinam ƴuwata. ");
INSERT INTO fuh_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Wakkati no waran, o wari jaati, nde rewooɓe goonga e goonga no ndewiran *Baabiraawo ruuhu mum'en e goonga. Hano ir rewooɓe ɓee jaati *Baabiraawo hiɗi. ");
INSERT INTO fuh_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Alla no *Ruuhu. Rewooɓe mo ɓeen duu no kaani rewirde mo ruuhu e goonga. ");
INSERT INTO fuh_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Debbo oon wi'i : —Miɗo anndi *Almasiihu waran, kanko woni Cuɓaaɗo Alla. Nde o warii, o faaminan min huune fuu. ");
INSERT INTO fuh_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Iisa wi'i mo : —Miin, kaaldoowo he maa oo, woni mo. ");
INSERT INTO fuh_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ɓe kantaay haala kaan, ko *aahiiɓe ɓeen ngartii tawi ɓe. Ɗum haayɗini *aahiiɓe ɓeen ko Iisa no haalda he debbo oon. Amma baa gooto nder maɓɓe suusaay wi'ude debbo oon : « Ɗume ngiɗaa ? » naa ƴamude Iisa wi'a : « Ɗume kaaldantaa he makko ? » ");
INSERT INTO fuh_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Debbo oon resi loone mum, soƴƴii nder wuro ngoon, haalanowi himɓe wi'i : ");
INSERT INTO fuh_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Ngaree, ƴeewee gorko kaalanɗo kam ko ngaɗunoomi fuu. Naa kanko woni *Almasiihu ? ");
INSERT INTO fuh_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Himɓe mburtii wuro ngoon, njehi to Iisa. ");
INSERT INTO fuh_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Wakkati debbo oon dillunoo *aahiiɓe ɓeen eelii mo mbi'i : —Moodibbo, nyaamu ! ");
INSERT INTO fuh_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Sey o jaabii ɓe o wi'i : —Miɗo jogii nyaamdu ndu on anndaa. ");
INSERT INTO fuh_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","*Aahiiɓe ɓeen tinni no ƴamodira no mbi'a : —Moy woni gaddanɗo mo ko nyaamee ? ");
INSERT INTO fuh_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Iisa wi'i ɓe : —Nyaamdu am woni waɗude muuyo lilɗo kam e humnude golle makko. ");
INSERT INTO fuh_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Onon, oɗon mbi'a : « Lebbi nay koddani kettol. » Amma miin, miɗo wi'a on : Ɓantee gite mon, ƴeewon ko gese ɗeen ɓenndi, ɗe poti hetteede. ");
INSERT INTO fuh_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Kettuɗo fuu no heɓan baraaje, hawran gabbe ngam mbuurnam nduumiiɗam, ngam aawɗo e kettuɗo mbelnida. ");
INSERT INTO fuh_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Iɗum tabbintina banndol bi'ungol : « Goɗɗo no aawa, goɗɗo no hetta. » ");
INSERT INTO fuh_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Mi lilii on kettowon to on ngollaay. To woɓɓe ngolli, onon, on naati nder barke golle maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Nder wuro ngoo, ɓiɓɓe leydi *Samariya ɗuɓɓe ngoonɗinii Iisa ngam haala debbo ceedaniiɗo mo wi'i : —O haalanii kam ko ngaɗunoomi fuu. ");
INSERT INTO fuh_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ngam majjum waɗi wakkati ɓiɓɓe leydi *Samariya njottinoo to Iisa, ɓe ŋaarii mo o jooɗo to maɓɓe. Nden o waɗani ɓe balɗe ɗiɗi. ");
INSERT INTO fuh_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ɗuɓɓe ngari ɓeydake he goonɗinɓe mo wakkati nanunoo haala makko. ");
INSERT INTO fuh_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ɓe mbi'i debbo oon : —Joonin, hanaa ngam haalaaji maaɗa tan min ngoonɗini. Minen e ko'e amin, min nanii haala makko, miɗen anndi ko kanko jaati woni kisinoowo duuniyaaru nduu. ");
INSERT INTO fuh_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Iisa waɗi balɗe ɗiɗi nder wuro leydi *Samariya nden yawtiri leydi Galili, ");
INSERT INTO fuh_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","ngam kanko e hoore makko o wi'i : —Annabiijo teddintaake nder wuro mum. ");
INSERT INTO fuh_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Wakkati o yottinoo Galili, ɓiɓɓe Galili njaɓɓorake mo juuɗe ɗiɗɗiɗi, ngam kamɓe duu ɓe njehiino *Ursaliima to *Juulɗe dimɗinol Isra'ilankooɓe. Ɓe ngi'ii duu ko o gollunoo toon. ");
INSERT INTO fuh_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Sey Iisa warti kaden Kaana, to o waylitinnoo ndiyam, ɗam laatii cabiijam. Fotodiri kawjotooɗo laamu *Rooma nder wuro Kafarnahum ɓiyum gorko yamɗaa. ");
INSERT INTO fuh_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Kawjotooɗo oon nani ko Iisa ƴuwii Yahudiya, wartii Galili. Nden o yehi to Iisa, o ŋaarii ɗum wara yamɗintinowa ɓiyiiko gonɗo no habda he yonki. ");
INSERT INTO fuh_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Iisa wi'i mo : —Abada on ngoonɗintaa, se on ngi'aay alamaaji naa ko haayɗini. ");
INSERT INTO fuh_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Kawjotooɗo oon wi'i mo : —Moodibbo, en njaha illa ɓiyam maayaay. ");
INSERT INTO fuh_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Sey Iisa wi'i mo : —Hootu, ɓiya daɗii ! Gorko oon goonɗini ko Iisa haalani ɗum, dilli. ");
INSERT INTO fuh_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Gollooɓe makko potti mo dow laawol, mbi'i mo : —Ɓiya daɗii ! ");
INSERT INTO fuh_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","O ƴamii ɓe wakkati mo ɓiyiiko yamɗiti. Ɓe njaabii mo ɓe mbi'i : —Keeŋa juura, wulowulo ngoon heli. ");
INSERT INTO fuh_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Baaba oon annditi wakkati oon jaati Iisa wi'i mo : « Ɓiya daɗii ! » Nden kanko e ɓaade makko fuu, ɓe ngoonɗini Iisa. ");
INSERT INTO fuh_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ɗum woni alaama kaayɗiniiɗo ɗiɗaɓo mo Iisa waɗi Galili wakkati o ƴuwnoo Yahudiya. ");
INSERT INTO fuh_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Gaɗa majjum juulɗe *Yahudankooɓe gom no ngaɗa. Iisa yehi *Ursaliima. ");
INSERT INTO fuh_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Toon *Ursaliima, hadde dammbugal bi'eteengal Dammbugal baali, no woodi luggere ndiyam gom inndirteene Baytijata nder ibrankoore. Tendeeje joy no piili nde. ");
INSERT INTO fuh_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Nyawɓe ɗuɓɓe no pukki nder majje : Wumɓe, laƴooɓe e bonnguuɓe. Iɓe ndoomi faa ndiyam ɗaam irtee. ");
INSERT INTO fuh_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Ngam himɓe no miila maleykaajo Alla no jippoo wakkati warde wakkati nder luggere ndee, no irta ndiyam ɗaam. Nyawɗo artuɗo naati nder majjam wakkati ɗam irtaa, no yamɗitan ir nyaw ngu wondi fuu. ");
INSERT INTO fuh_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Gorko nyawirɗo duuɓi woronja e jeetati gom no tawa toon. ");
INSERT INTO fuh_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ko Iisa hi'i omo fukkii, annditi ko o ɓooydii he nyaw nguun, nden ƴamii mo, wi'i : —Aɗa hiɗi yamɗintineede naa ? ");
INSERT INTO fuh_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Nyawɗo oon jaabii mo, wi'i : —Moodibbo, mi walaa balloowo kam mi naata nder luggere ndee wakkati ndiyam ɗam wona no irtee. To mbi'anmi mi yahan fuu, tawan goɗɗo artii kam juurude. ");
INSERT INTO fuh_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Nden Iisa wi'i mo : —Umma, hooƴu daago maa, dillu ! ");
INSERT INTO fuh_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Wakkati mum da gorko oon yamɗiti, hooƴi daago mum, dilli. Ɗum fotodiri he *nyalaane fowteteene. ");
INSERT INTO fuh_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Nden mawɓe *Yahudankooɓe mbi'i jamɗintinaaɗo oon : —Hannden *nyalaane fowteteene non, haanaa ndoondoɗaa daago maa. ");
INSERT INTO fuh_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Sey o jaabii ɓe, o wi'i : —Jamɗintinɗo kam oon wi'i kam hooƴu daago maa, dillu ! ");
INSERT INTO fuh_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ɓe ƴamii mo ɓe mbi'i : —Moy woni neɗɗo bi'uɗo ma kooƴaa daago maa, ndillaa ? ");
INSERT INTO fuh_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Amma jamɗintinaaɗo oon anndaa moy yamɗintini ɗum, ngam Iisa halkii nder jama'aare tawanoone nder nokkuure ndeen. ");
INSERT INTO fuh_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Gaɗa ko Iisa nyawti mo, fotti he makko nder *Juulirde mawne, wi'i mo : —Ƴeewu, joonkay, a yamɗiti. Taa waɗu hakke kaden ngam to ko ɓuri ɗum bonde heɓe. ");
INSERT INTO fuh_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Sey gorko oon yehi haalanowi mawɓe *Yahudankooɓe ko Iisa woni nyawtuɗo mo oon. ");
INSERT INTO fuh_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Mawɓe *Yahudankooɓe puɗɗi habdude Iisa ngam o nyawti gorko oo nder *nyalaane fowteteene. ");
INSERT INTO fuh_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Sey Iisa wi'i ɓe : —*Baaba am no golla faa jooni, miin duu, miɗo golla. ");
INSERT INTO fuh_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Haalaaji ɗi Iisa haali ɗii waɗi mawɓe *Yahudankooɓe adi anniya warude mo. Hanaa ngam o bonnii *nyalaane fowteteene tan, amma ngam o wi'i Alla woni Baabiiko duu. Ndenne o fonnii hoore makko he Alla. ");
INSERT INTO fuh_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Iisa wi'i ɓe : —Miɗo haalana on goonga : Ɓiɗɗo waawaa waɗude baafuy, kam tan, sey ko o hi'i *Baabiraawo no waɗa. Sabu ko *Baabiraawo waɗata fuu, kam Ɓiɗɗo oon duu waɗata. ");
INSERT INTO fuh_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","*Baabiraawo no hiɗi Ɓiɗɗo oon, no holla mo ko waɗata fuu. O hollan mo golleeji ɓurɗi golleeji ɗii fuu manngu heɓa kaayɗineɗon. ");
INSERT INTO fuh_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ngam hano no *Baabiraawo ummitinirta maayɓe wuurna ɓe nii, hano non Ɓiɗɗo oon duu wuurnirta mo muuyi. ");
INSERT INTO fuh_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","*Baabiraawo oon kay, hiitantaako baa gooto, amma o hokkii Ɓiɗɗo oon baawɗe hiitaade huune fuu, ");
INSERT INTO fuh_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ngam himɓe fuu teddina Ɓiɗɗo oon hano no ɓe teddinirta *Baabiraawo. Neɗɗo fuu mo teddinaay Ɓiɗɗo oon, teddintaa *Baabiraawo lilɗo mo oon duu. ");
INSERT INTO fuh_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Miɗo haalana on goonga : Nanuɗo haala am, se goonɗini lilɗo kam oon, heɓi mbuurnam nduumiiɗam. O walaa e kiite kaden, o ƴuwii e maayde, o warii e mbuurnam. ");
INSERT INTO fuh_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Miɗo haalana on goonga : Wakkati no wara, o yottake jaati, nde maayɓe nanata daane *Ɓii-Alla oon. Nanuɓe nde ɓeen mbuuran. ");
INSERT INTO fuh_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Hano no *Baabiraawo laatorii asili mbuurnam, hano non o hokkiri Ɓiɗɗo oon duu baawɗe laataade asili mbuurnam. ");
INSERT INTO fuh_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","O hokkii mo baawɗe hiitaade, ngam kanko woni *Ɓii-Neɗɗo. ");
INSERT INTO fuh_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","To ɗum haayɗin on. Wakkati waran mo maayɓe wonɓe nder annyeeje fuu no nanan daane makko, ");
INSERT INTO fuh_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","mburtoo. Golluɓe golle lobbe ummitanoo mbuurnam, golluɓe ko boni duu ummitanoo kiite. ");
INSERT INTO fuh_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Miin e hoore am, walaa fuu ko mbaawmi waɗude. Ko nanumi ɗum, kiitortoomi. Kiite am no dartii, sabu mi waɗataa muuyo am, amma muuyo lilɗo kam oon ngaɗanmi. ");
INSERT INTO fuh_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","—Nde mi seedanake hoore am, seede am hanaa goonga. ");
INSERT INTO fuh_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Amma goɗɗo seedantoo kam. Miɗo anndi seede makko dow am no goonga. ");
INSERT INTO fuh_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Onon, on lili lilaaɓe to Yahaaya, o seedanake on goonga. ");
INSERT INTO fuh_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Miin, mi haajaaka seede ɓiɓɓe aadama, amma mi wi'i on ɗum ngam kison tan. ");
INSERT INTO fuh_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yahaaya laatakeno hano fitilla kuɓɓaaka, njaynooka. On njaɓi welnude wakkati seɗɗa nder jeyngol makka. ");
INSERT INTO fuh_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Amma miin, miɗo jogii seede dow am ɓurɗo mo Yahaaya manngu : Golleeji ɗi *Baabiraawo tilsini kam mi waɗa ɗii, kanƴi jaati ceedantoo kam ko *Baabiraawo lili kam. ");
INSERT INTO fuh_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","*Baabiraawo lilɗo kam oon e hoore mum seedantoo kam. Abada on nanaay daane makko, abada on ngi'aay mo. ");
INSERT INTO fuh_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Haala makko naataay on, sabu on ngoonɗinaay mo o lili oon. ");
INSERT INTO fuh_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Oɗon pincitoo dewte ngam oɗon miila ko ɗe kokkan on mbuurnam nduumiiɗam. Kanƴe jaati ceedantoo kam. ");
INSERT INTO fuh_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Amma, baa ko non waɗi, on ngiɗaa warde to am faa keɓon mbuurnam. ");
INSERT INTO fuh_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Mi walaa miɗo tefa himɓe mana kam. ");
INSERT INTO fuh_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Miɗo anndi on jaati, miɗo anndi hidde Alla walaa nder ɓerɗe mooɗon. ");
INSERT INTO fuh_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Miin, mi wari dow innde *Baaba am, amma on njaɓɓaaki kam. Dey se goɗɗo wari dow innde mum, on njaɓɓoto ɗum ! ");
INSERT INTO fuh_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Noy ngoonɗinirton, onon giɗuɓe manodirde, tawi on mbaawaay tefude manoore ƴuwne to Alla gooto ? ");
INSERT INTO fuh_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","To miilee hala miin felata on yeeso *Baabiraawo. *Muusa, mo ndekuɗon tammude mooɗon dow mum oon, kam felata on. ");
INSERT INTO fuh_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Nde nii goonga fuu on ngoonɗiniino *Muusa, on ngoonɗinanno kam, miin duu, sabu miin jaati o sappinoo nder dewte makko. ");
INSERT INTO fuh_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Se on ngoonɗinaay ko o winndunoo ɗum, noy ngoonɗinirton haala am ? ");
INSERT INTO fuh_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Balɗe seɗɗa gaɗa juulɗe *Yahudankooɓe gaɗaaɗe Ursaliima, Iisa joli peta Galili wi'eteenga Tiberiya. ");
INSERT INTO fuh_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Jama'aare ɗuunde no tokki mo sabu ɓe ngi'ii kaayɗe ɗe o waɗi wakkati o yamɗintinnoo nyawɓe. ");
INSERT INTO fuh_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Iisa nyakki dow waamnde, jooɗodii he *aahiiɓe mum. ");
INSERT INTO fuh_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Juulɗe *Yahudankooɓe bi'eteeɗe *Juulɗe dimɗinol Isra'ilankooɓe ɓadake. ");
INSERT INTO fuh_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Iisa ɓanti hoore mum, sey holliri jama'aare mawne gom no wara to mum. Nden o wi'i Filipa : —Toy coodoyten nyaamdu ngam himɓe ɓee fuu ? ");
INSERT INTO fuh_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Tawi o fiyi hunnduko Filipa tan o nana ngam omo anndi ko o siini waɗude. ");
INSERT INTO fuh_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipa jaabii mo : —Baa buuru ko tammaaje keme ɗiɗi cooduɗen, woɓɓe nder maɓɓe keɓataa ŋoppitto. ");
INSERT INTO fuh_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Gooto nder *aahiiɓe Iisa bi'eteeɗo Andiire, minyo Simon Piyer, wi'i mo : ");
INSERT INTO fuh_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Suka gorko gom nii jogiiɗo buuruuje joy e liƴƴi ɗiɗi, amma ɗume ɗum nafirta himɓe ɓee fuu ? ");
INSERT INTO fuh_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Nden Iisa wi'i ɓe : —Mbi'ee ɓe, ɓe njooɗoo ! Nokkuure ndeen no heewi huɗo, ɓe njooɗii. Worɓe tawaaɓe nder jama'aare ndee tan no ngaɗa ujunaaji joyo. ");
INSERT INTO fuh_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Iisa hooƴi buuruuje ɗeen, yetti Alla, yeddani wonɓe toon ɓeen. Noon duu o waɗi he liƴƴi ɗiin. O hokki ɓe, ɓe nyaami faa ɓe kaari. ");
INSERT INTO fuh_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Wakkati ɓe nyaamunoo faa ɓe kaari, sey Iisa wi'i *aahiiɓe mum : —Kawree ko hoddi ɗum, to baa ŋoppitto bonu. ");
INSERT INTO fuh_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ɓe kawri ko himɓe nyaami koddi nder buuruuje joy ɗeen, ɗum hebbini kandeeje sappo e ɗiɗi. ");
INSERT INTO fuh_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Wakkati himɓe ɓeen ngi'unoo haayne nde Iisa waɗi, mbi'i : —Kanko jaati woni annabiijo bi'anooɗo no waran nder duuniyaaru. ");
INSERT INTO fuh_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Wakkati Iisa annditinnoo iɓe ngiɗi ɓe ngatta mo semmbe-semmbe nder laamu, sey o dilli. O nyakki waamnde, kanko tan. ");
INSERT INTO fuh_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Nde hiirunoo, *aahiiɓe Iisa njuuri nder peta ngaan. ");
INSERT INTO fuh_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ɓe naati laana faa ɓe njola, yahde Kafarnahum. Jemma fuɗɗii naatude, Iisa duu heewtaaki ɓe. ");
INSERT INTO fuh_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Henndu mawnu no wifa faa benkeƴƴe ummii. ");
INSERT INTO fuh_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ɓe awƴi laana kaan faa ɓe keɓi hano kilooji joy naa jeegom. Nden ɓe kolliri Iisa no dilla he koyɗe mum dow peta ngaan, no fonndii ɓe. Sey ɓe kuli. ");
INSERT INTO fuh_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Amma Iisa wi'i ɓe : —To kulee, miin noon ! ");
INSERT INTO fuh_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ɓe muuyi o naata laana kaan. Amma wakkati mum da ɓe njottii fonngo ngo ɓe pa'i, nden ɓe panndi. ");
INSERT INTO fuh_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Weeti jaangoore mum, jama'aare hoddinoonde gaɗa peta ngaan, paami ko laana goota tan wari nder nokkuure ndee. Ɓe ngi'ii duu ko *aahiiɓe ɓeen tan naati nder makka, awƴii ka, ndilli, Iisa duu naataay ka. *Aahiiɓe ɓeen tan ndilli. ");
INSERT INTO fuh_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Sey laanaaji gom nii ngari ƴuwi Tiberiya, ɗi ngari hadde to ɓe nyaamunoo buuru toon gaɗa ko Iisa yetti Alla nder du'aa'u. ");
INSERT INTO fuh_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Wakkati jama'aare ndeen hi'unoo ko Iisa e *aahiiɓe mum fuu ngalaa toon, ɓe naati laanaaji ɗiin, ɓe pa'i Kafarnahum tefoyde Iisa. ");
INSERT INTO fuh_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Wakkati ɓe tawoynoo Iisa gaɗa peta ngaan, ɓe mbi'i mo : —Moodibbo, nde ngarɗaa ɗoo ? ");
INSERT INTO fuh_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Iisa jaabii ɓe wi'i : —Goonga non, hanaa ngam on ngi'ii kaayɗe ɗe ngaɗaama toon waɗi oɗon tefa kam. Amma ko tefanton kam woni ngam on nyaami faa on kaari. ");
INSERT INTO fuh_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","To ngollanee nyaamdu bonooru. Ngollanee nyaamdu nduumotoonu, kokkooru mbuurnam nduumiiɗam. Kayru woni ndu *Ɓii-Neɗɗo hokkata on, sabu Alla *Baabiraawo deki lammba baawɗe mum dow makko. ");
INSERT INTO fuh_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Nden ɓe ƴami mo : —Ɗume min ngaɗata ko min ngolla golleeji ɗi Alla hiɗi ? ");
INSERT INTO fuh_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Iisa jaabii ɓe, wi'i : —Golle ɗe Alla hiɗi ɗeen ngoni ngoonɗinon mo o lili oon. ");
INSERT INTO fuh_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ɓe njaabii mo, ɓe mbi'i : —Too, haayne ndeye ngaɗataa ngam min ngi'a, min ngoonɗine ? Golle ɗeye ngaɗataa ? ");
INSERT INTO fuh_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Maamiraaɓe amin nder ladde yeeruure nyaamii nyaamdu wi'eteenu *manna, hano no ɗum winndiraa nder dewte wi'aa : O hokkii ɓe nyaamdu ƴuwnu dow kammu. ");
INSERT INTO fuh_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Iisa jaabii ɓe, wi'i : —Miɗo haalana on goonga : Hanaa *Muusa hokkunoo on nyaamdu ƴuwnu dow kammu. Amma *Baaba am hokki on nyaamdu goongaaru ƴuwnu dow kammu. ");
INSERT INTO fuh_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ngam nyaamdu ndu Alla hokkata nduun woni ƴuwooru dow kammu kokkooru duuniyaaru mbuurnam. ");
INSERT INTO fuh_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Sey ɓe mbi'i mo : —Moodibbo, hokku min ir nyaamdu nduu nyannde fuu. ");
INSERT INTO fuh_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Iisa wi'i ɓe : —Miin woni nyaamdu kokkooru mbuurnam. Garɗo to am fuu, rafataake faa abada. Goonɗinɗo kam oon duu ɗomɗataake abada. ");
INSERT INTO fuh_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Amma mi haalaniino on : « On ngi'ii kam, dey on ngoonɗinaay. » ");
INSERT INTO fuh_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Mo *Baabiraawo hokki kam fuu, waran to am. Garɗo to am fuu, mi riiwataa ɗum sam. ");
INSERT INTO fuh_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Sabu hanaa faa mi waɗa muuyo am, waɗi ƴuwmi dow kammu, amma ngam mi waɗa muuyo lilɗo kam oon. ");
INSERT INTO fuh_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ndaa, muuyo lilɗo kam oon nii : To baa gooto nder ɓe o hokki kam ɓeen majju, amma mi ummintina ɓe nyannde darŋal. ");
INSERT INTO fuh_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Muuyo *Baaba am nii : Neɗɗo fuu gi'uɗo Ɓiɗɗo oon, goonɗini mo, heɓan mbuurnam nduumiiɗam. Mi ummintinan ɗum nyannde darŋal. ");
INSERT INTO fuh_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Sey *Yahudankooɓe ɓeen puɗɗi no nguuntoo hakkune mum'en, ngam Iisa wi'i ɓe : « Miin woni nyaamdu ƴuwnu dow kammu nduun. » ");
INSERT INTO fuh_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ɓe mbi'i : —Hanaa Iisa ɓii-Yusufu mo annduɗen innum e bammum on non naa ? Noy o wi'irta hannden dow kammu o ƴuwi ? ");
INSERT INTO fuh_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Nden Iisa wi'i ɓe : —Accee nguuntaade hakkune mooɗon ! ");
INSERT INTO fuh_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Walaa baawɗo warde to am, se *Baabiraawo lilɗo kam oon, fooɗaay mo. Miin duu, mi ummintinan mo nyannde darŋal. ");
INSERT INTO fuh_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ɗum winndaama nder dewte annabiiɓe wi'aa : Ɓe fuu Alla ekkintinii ɓe. Neɗɗo fuu hettinnani ko *Baabiraawo ekkintini, waran to am. ");
INSERT INTO fuh_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Walaa gi'uɗo *Baabiraawo, se hanaa oon ƴuwɗo to makko, kanko tan hi'i *Baabiraawo. ");
INSERT INTO fuh_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Miɗo haalana on goonga : Goonɗinɗo kam fuu, heɓi mbuurnam nduumiiɗam. ");
INSERT INTO fuh_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Miin woni nyaamdu kokkooru mbuurnam. ");
INSERT INTO fuh_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Maamiraaɓe mooɗon nyaamii *manna nder ladde yeeruure, dey haɗaay ɓe maayi. ");
INSERT INTO fuh_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Amma nyaamdu ƴuwnu dow kammu nduun kay, nyaamɗo hen fuu maayataa. ");
INSERT INTO fuh_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Miin woni nyaamdu wuurnu ƴuwnu dow kammu. Nde goɗɗo nyaami he mayru, no wuuran faa abada. Nyaamdu ndu kokkanmi nduun woni ɓanndu am hokkaanu ngam duuniyaaru heɓa mbuurnam. ");
INSERT INTO fuh_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Haala kaa ummini geddi hakkune *Yahudankooɓe, iɓe mbi'a : —Noy o waawri hokkude en ɓanndu makko, nyaamen ? ");
INSERT INTO fuh_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Iisa wi'i ɓe : —Miɗo haalana on goonga : Nde on nyaamaay ɓanndu *Ɓii-Neɗɗo, on njaraay ƴiiƴam mum, mbuurnam walanaa on. ");
INSERT INTO fuh_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Neɗɗo fuu nyaamɗo ɓanndu am, nde yari ƴiiƴam am, heɓi mbuurnam nduumiiɗam. Mi ummitinan ɗum nyannde darŋal. ");
INSERT INTO fuh_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ngam ɓanndu am woni nyaamdu wuurnu, ƴiiƴam am duu woni cemmbam buurɗam. ");
INSERT INTO fuh_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Neɗɗo fuu nyaamɗo ɓanndu am, nde yari ƴiiƴam am, wondi he am, mi wondan he mum. ");
INSERT INTO fuh_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","*Baabiraawo lilɗo kam oon no wuddu mbuurnam. Sabbu makko mbuurumi. Hano non nyaamɗo ɓanndu am fuu no wuuran sabbu am. ");
INSERT INTO fuh_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Nyaamdu ƴuwnu dow kammu nduun nii : Ndu hawtaa he ndu maamiraaɓe mon nyaamunoo nduun, ndu haɗaay ɓe maayde. Nyaamɗo nyaamdu nduu, no wuuran faa abada. ");
INSERT INTO fuh_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Waaju oo, Iisa waɗi nder *waajordu Kafarnahum. ");
INSERT INTO fuh_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Wakkati *aahiiɓe Iisa nanunoo haalaaji ɗii, ɗuɓɓe nder maɓɓe mbi'i : —Konngi ɗii no tiiɗi. Moy waawi jaɓude ɗi ? ");
INSERT INTO fuh_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Iisa he hoore mum faami dow ko *aahiiɓe mum ngoni no nguuntoo, wi'i ɓe : —Ɗum laatanake on fergere naa ? ");
INSERT INTO fuh_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ndenne ɗume waɗata, se on ngi'ii *Ɓii-Neɗɗo ŋabbitii to wonnoo illa arannde ? ");
INSERT INTO fuh_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","*Ruuhu Alla woni ko hokkata mbuurnam, ɓanndu walaa baawɗe baafuy. Konngi ɗi kaalanmi on ɗii ngoni ruuhu, kanƴi ngoni mbuurnam duu. ");
INSERT INTO fuh_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Amma no woodi nder mooɗon ɓe ngoonɗinaay. Tawi illa arannde Iisa no anndunoo ɓe ngoonɗinaay ɓeen e jammboytooɗo mo oon. ");
INSERT INTO fuh_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","O ɓeydi wi'ude : —Ngam majjum mbi'umi on : Baa gooto waawtaa warde to am nde *Baabiraawo waddaay mo. ");
INSERT INTO fuh_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Illa ndeen ɗuɓɓe nder *aahiiɓe makko coƴƴiti, acci tokkude mo. ");
INSERT INTO fuh_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Nden Iisa ƴami *lilaaɓe sappo e ɗiɗo ɓeen wi'i : —Onon duu, oɗon ngiɗi dillude naa ? ");
INSERT INTO fuh_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simon Piyer jaabii mo wi'i : —Joomam, to moy min njahata ? Hanaa aan jogii konngi kokkooji mbuurnam nduumiiɗam naa ? ");
INSERT INTO fuh_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Min ngoonɗinii, miɗen anndi ko aan woni Ceniiɗo ƴuwɗo to Alla. ");
INSERT INTO fuh_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Iisa jaabii ɓe wi'i : —Hanaa miin suɓii on, onon sappo e ɗiɗo ɓee naa ? Amma gooto nder mooɗon no seyɗan. ");
INSERT INTO fuh_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Dow Yahuuda, ɓii-Simon Iskariyot, gooto nder *lilaaɓe sappo e ɗiɗo ɓeen o haali. Kanko woni jammboytooɗo Iisa. ");
INSERT INTO fuh_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Iisa tinni no fiiloo nder leydi Galili. O hiɗaa fiilaade nder leydi Yahudiya ngam mawɓe *Yahudankooɓe no tefa warde mo. ");
INSERT INTO fuh_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Juulɗe *Yahudankooɓe bi'eteeɗe kowaaɗe ɓadake. ");
INSERT INTO fuh_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Sey minyiraaɓe Iisa worɓe mbi'i mo : —Dillu ɗo, njahaa leydi Yahudiya ngam *aahiiɓe maa ngi'a golle ɗe ngaɗataa. ");
INSERT INTO fuh_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Neɗɗo fuu hiɗi anndee, suuɗataa ko waɗata. Nde aɗa waɗa ir golle ɗee, wannginan himɓe hoore maa. ");
INSERT INTO fuh_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Baa minyiraaɓe makko e ko'e mum'en ngoonɗinaay mo. ");
INSERT INTO fuh_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Iisa wi'i ɓe : —Wakkati am yonaay ginan, amma to mooɗon, wakkati fuu no wooɗi. ");
INSERT INTO fuh_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Himɓe duuniyaaru mbaawtaa wanyude on. Amma miin, iɓe mbanyi kam ngam miɗo seedoo ko golleeji maɓɓe no mboni. ");
INSERT INTO fuh_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Onon, njehee to juulɗe ɗeen. Miin, mi yahataa sabu wakkati am yonaay ginan. ");
INSERT INTO fuh_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Gaɗa o haalani ɓe ɗum, o jooɗii nder Galili. ");
INSERT INTO fuh_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Wakkati minyiraaɓe Iisa ndillirii juulɗe ɗeen, Iisa duu njehi to majje amma nder cuccukka, o hollaay hoore makko. ");
INSERT INTO fuh_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Mawɓe *Yahudankooɓe no tefa mo nder jama'aare ndeen, no mbi'a : —Toy o woni ? ");
INSERT INTO fuh_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Himɓe ɗuɓɓe no nguuntoo dow makko. Gere no mbi'a : —Neɗɗo oo o lobbo ! Woɓɓe no mbi'a : —Aa'a, o majjinoowo himɓe. ");
INSERT INTO fuh_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Walaa cuusuɗo towni haali dow makko, sabu iɓe kula mawɓe *Yahudankooɓe. ");
INSERT INTO fuh_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Wakkati Iisa yehunoo tawi juulɗe ɗeen pecciri, o fuɗɗi omo waajoo nder *Juulirde mawne. ");
INSERT INTO fuh_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","*Yahudankooɓe kaayɗinaa, sey ɓe mbi'i : —Noy waɗi ko neɗɗo oo heɓi anndal dewte, kanko mo janngaay ? ");
INSERT INTO fuh_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Iisa jaabii ɓe wi'i : —Waaju mo mbaajotoomi oo, ƴuwaay to am. Amma to lilɗo kam oon, o ƴuwi. ");
INSERT INTO fuh_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Giɗɗo waɗude muuyo Alla fuu, no annditan nde waaju oo to Alla ƴuwi naa to am. ");
INSERT INTO fuh_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Kaaloowo miilo hoore mum, hoore mum tefanta teddungal. Amma tefoowo teddungal lilɗo ɗum, goonga haalata, ko boni fuu walaa he mum. ");
INSERT INTO fuh_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Hanaa *Muusa hokki on *Tawreeta naa ? Amma baa gooto nder mooɗon waɗaay ko *Tawreeta wi'i. Ɗume waɗi oɗon tefa warde kam ? ");
INSERT INTO fuh_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Himɓe njaabii mo, mbi'i : —Aan, a laddaaɗo. Moy tefata warde ma ? ");
INSERT INTO fuh_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Nden Iisa wi'i ɓe : —Gollal gootal tan ngaɗumi, on fuu, on kaayɗinaama. ");
INSERT INTO fuh_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","*Muusa wi'i ngaɗon juulnol. Oɗon njuulna neɗɗo baa *nyalaane fowteteene. Maamiraaɓe mooɗon puɗɗi ngol, hanaa *Muusa fuɗɗi ngol. ");
INSERT INTO fuh_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Nde neɗɗo no juulnee *nyalaane fowteteene ngam to bonnu *Tawreeta Muusa, ɗume tikkanton kam sabu mi yamɗintinii neɗɗo bumbuujo nder *nyalaane fowteteene ? ");
INSERT INTO fuh_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","To on kiitoree no ngiirruɗon, kiitoree goonga. ");
INSERT INTO fuh_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Gere nder himɓe *Ursaliima mbi'i : —Hanaa oo woni mo ɓe tefata warde oon naa ? ");
INSERT INTO fuh_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Amma ndaa, omo darii omo waajoo yeeso himɓe fuu, ɓe mbi'aay mo baafuy. Tawte mawɓe meeɗen potii dow kanko woni *Almasiihu oon ? ");
INSERT INTO fuh_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Oo kay, eɗen anndi to ƴuwi, amma nde *Almasiihu oon wari, baa gooto anndataa to o ƴuwata. ");
INSERT INTO fuh_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Iisa no waajoo nder *Juulirde mawne ndeen, sey o towni daane, o wi'i : —On mbi'ii oɗon anndi kam naa ? Oɗon anndi to ƴuwmi ? Amma hanaa miin waddi hoore am. Lilɗo kam oon woni goongaajo, kanko woni mo on anndaa. ");
INSERT INTO fuh_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Miin, miɗo anndi mo sabu to makko ƴuwmi, kanko lili kam. ");
INSERT INTO fuh_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Nden ɓe tefi nanngude mo, amma junngo baa gooto yottaaki mo, ngam wakkati makko yonaay ginan. ");
INSERT INTO fuh_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ɗuɓɓe nder jama'aare ndee ngoonɗini mo, mbi'i : —Kee nde *Almasiihu oon wari, omo waawi waɗude kaayɗe ɓurɗe ɗe gorko oo waɗi naa ? ");
INSERT INTO fuh_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","*Fariisa'en nani ko himɓe ɓeen ngoni no nguuntoo dow Iisa. Hooreeɓe *cakkanooɓe Alla e *Fariisa'en lili dogariiɓe nannga Iisa. ");
INSERT INTO fuh_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Sey Iisa wi'i ɓe : —Miin, mi wondan he mooɗon wakkati seɗɗa ginan. Gaɗa mum, mi soƴƴoo to lilɗo kam oon. ");
INSERT INTO fuh_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","On tefan kam, amma on ngiitataa kam, ngam on mbaawtaa yahde to ngonmi. ");
INSERT INTO fuh_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Mawɓe *Yahudankooɓe ƴamodiri mbi'i : —Toy o yahata ko en mbaawtaa hiitude mo ? O tefowan himɓe meeɗen sankitiiɓe nder lenyi janaani, o waajoo lenyi ɗii naa ? ");
INSERT INTO fuh_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","O wi'i en tefan mo, en ngiitataa mo, sabu en mbaawtaa yahde to o tawetee toon. Ɗume woni maana haala kaa ? ");
INSERT INTO fuh_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Nyalaane ɓurde teddude nder juulɗe ɗeen fuu woni nyalaane nde juulɗe ɗeen timmata. Nyannde mum Iisa darii huuɓi, wi'i : —Ɗomɗuɗo fuu wara to am, yara. ");
INSERT INTO fuh_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Goonɗinɗo kam fuu, maayooji ndiyam mbuurnoojam no ilan nder ɓerne mum hano no ɗum winndiraa nder dewte nii. ");
INSERT INTO fuh_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Dow *Ruuhu Ceniiɗo Iisa woni no haala. *Ruuhu Ceniiɗo oo kam woni ko goonɗinɗo mo fuu heɓata. Amma wakkati mum *Ruuhu Ceniiɗo hokkaakano ngam Iisa teddinaakano ginan. ");
INSERT INTO fuh_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Wakkati himɓe gom nanunoo haala kaa nder jama'aare ndeen, mbi'i : —Sikka fuu walaa kanko woni annabiijo oon. ");
INSERT INTO fuh_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Woɓɓe duu mbi'i : —Oo nii woni *Almasiihu oon. Amma woɓɓe mbi'i kaden : —*Almasiihu oon ƴuwan Galili naa ? ");
INSERT INTO fuh_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Hanaa Dewtere Alla wi'i ko nder lenyol Daawda *Almasiihu ƴuwata ? Hanaa nde wi'i kaden Baytilaama wuro Daawda o ƴuwata ? ");
INSERT INTO fuh_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Haalaaji jama'aare ndee luurodiri dow Iisa. ");
INSERT INTO fuh_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Nder maɓɓe no woodi hiɗuɓe nanngude mo, amma junngo baa gooto yottaaki mo. ");
INSERT INTO fuh_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Wakkati dogariiɓe ɓeen ngartunoo, hooreeɓe *cakkanooɓe Alla e *Fariisa'en ƴami ɓe, mbi'i : —Ko waɗi on ngaddaay mo ? ");
INSERT INTO fuh_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Dogariiɓe ɓeen njaabii ɓe, mbi'i : —Abada goɗɗo waajoraaki hano no neɗɗo oo waajori. ");
INSERT INTO fuh_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Sey *Fariisa'en njaabii ɓe, mbi'i : —Kaari ! Baa onon duu, on eytaama naa ? ");
INSERT INTO fuh_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Naa on ngi'ii goɗɗo nder hooreeɓe *Yahudankooɓe naa nder *Fariisa'en goonɗinɗo mo non ? ");
INSERT INTO fuh_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Amma jama'aare ndee no kuɗaane, nde anndaa *Tawreeta Muusa ! ");
INSERT INTO fuh_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodemu, gooto nder *Fariisa'en jehunooɗo to Iisa, wi'i ɓe : ");
INSERT INTO fuh_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—*Tawreeta meeɗen waawaa hiitaade neɗɗo nde nanaay ko joomum haali, naa ko waɗi. ");
INSERT INTO fuh_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ɓe njaabii mo, ɓe mbi'i : —Aan duu, a ɓii-Galili naa ? Fincita haala Alla, a hi'an ko annabiijo fuu wanngataa Galili.  ");
INSERT INTO fuh_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Gaɗa majjum neɗɗo fuu hooti wuro mum, ");
INSERT INTO fuh_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Iisa duu yehi waamnde Jaytun. ");
INSERT INTO fuh_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Illa subaka kecco Iisa warti nder *Juulirde mawne ndeen. Himɓe fuu ngari to makko. O jooɗii, omo waajoo ɓe. ");
INSERT INTO fuh_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Jannginooɓe *Tawreeta e *Fariisa'en ngaddi debbo tawaaɗo no yeena gom. Ɓe ndarni mo hakkune jama'aare ndeen. ");
INSERT INTO fuh_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ɓe mbi'i Iisa : —Moodibbo, debbo oo maɓaama no yeena. ");
INSERT INTO fuh_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Too, *Muusa tilsinii min nder *Tawreeta min mbarda ir rewɓe ɓee kaaƴe. Aan nee, ɗume mbiiɗaa ? ");
INSERT INTO fuh_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ɓe ngaɗi ƴamɗe ɗee ngam ɓe tunna mo ɓe keɓa laawol ngol ɓe njukkirta mo. Amma Iisa jimminii no diidira honndu mum dow leydi. ");
INSERT INTO fuh_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Wakkati ɓe tokkiri Iisa ƴamɗe ɗee, nden o ɓanti hoore, o wi'i ɓe : —Mo waɗaay hakke abada nder mooɗon arta bugaade mo hayre. ");
INSERT INTO fuh_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Nden Iisa yeeƴi jimmini, no diida dow leydi. ");
INSERT INTO fuh_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Wakkati ɓe nanunoo ɗum, sey ɓe cortorii gooto gooto. Nayeeɓe ɓeen artii. Iisa he debbo dariiɗo yeeso mum oon tan acca toon. ");
INSERT INTO fuh_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Nden Iisa ɓanti hoore mum, wi'i mo : —Banndam debbo, toy ɓe ngoni ? Walaa jukkuɗo ma naa ? ");
INSERT INTO fuh_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","O jaabii Iisa o wi'i : —Moodibbo, baa gooto. Nden Iisa wi'i mo : —Miin duu, mi jukkataa ma. Yah, amma taa waɗu hakke kaden. ");
INSERT INTO fuh_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Iisa haaldi he himɓe kaden, wi'i : —Miin woni jeyngol duuniyaaru. Tokkuɗo kam fuu, dillataa nder nimre abada, amma no heɓan jeyngol mbuurnam. ");
INSERT INTO fuh_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Sey *Fariisa'en mbi'i mo : —Aan, aɗa seedanoo hoore maa, seede maa hanaa goonga. ");
INSERT INTO fuh_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Iisa jaabii ɓe wi'i : —Baa nde mi seedanake hoore am, seede am no goonga, sabu miɗo anndi to ƴuwmi, miɗo anndi to njahanmi. Amma onon, on anndaa to ƴuwmi, on anndaa to njahanmi. ");
INSERT INTO fuh_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Onon, oɗon kiitoroo dabareeji himɓe, miin kay, mi hiitataako baa gooto. ");
INSERT INTO fuh_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Amma baa nde miɗo hiitoo, kiite am no goonga, sabu mi hiitataako miin tan, *Baabiraawo lilɗo kam oon, no wondi he am. ");
INSERT INTO fuh_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","No winndaa nder *Tawreeta mooɗon wi'aa : Seede himɓe ɗiɗo no goonga. ");
INSERT INTO fuh_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Too, miɗo seedanoo hoore am. *Baabiraawo lilɗo kam oon duu, no seedanoo kam. ");
INSERT INTO fuh_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Sey ɓe mbi'i mo : —Toy *Baaba maa oon woni ? Iisa jaabii ɓe wi'i : —On anndaa kam, on anndaa *Baaba am oon. Se nii oɗon anndunoo kam, on anndannoo *Baaba am oon duu. ");
INSERT INTO fuh_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Iisa haalii konngi ɗii wakkati o waajotonoo nder *Juulirde mawne, hadde to ceede ndesetee. Amma baa ko non waɗi, walaa nannguɗo mo, ngam wakkati makko yonaay ginan. ");
INSERT INTO fuh_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Iisa wi'i ɓe kaden : —Mi yahan, on tefan kam, amma on maaydan he hakkeeji mooɗon. To pa'umi toon, on mbaawtaa yahde toon. ");
INSERT INTO fuh_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Kanƴum waɗi mawɓe *Yahudankooɓe mbi'i : —Tawte o waran hoore makko waɗi o wi'i en mbaawtaa yahde to o fa'i toon ? ");
INSERT INTO fuh_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Iisa wi'i ɓe : —Onon, ley njeyaaɗon, amma miin, dow njeyaami. Onon, nder duuniyaaru nduu njeyaaɗon, amma miin, mi jeyaaka nder mayru. ");
INSERT INTO fuh_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ngam majjum waɗi mbi'umi on : On maaydan he hakkeeji mooɗon. Sabu se on ngoonɗinaay ko Miin woni oon mo ngonmi, on maaydan he hakkeeji mooɗon. ");
INSERT INTO fuh_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Nden ɓe ƴami mo, ɓe mbi'i : —Aan woni moy ? Iisa jaabii ɓe, wi'i : —Miin woni mo mbi'unoomi on ngonmi illa arannde. ");
INSERT INTO fuh_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Onon, kujje ɗuɗɗe no ngoodi ɗe mbaawmi haalude dow mooɗon, mi hiitoo on duu. Amma lilɗo kam oon woni goongaajo. Ko nanumi to makko, kaalananmi duuniyaaru nduu. ");
INSERT INTO fuh_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ɓe paamaay ko dow *Baabiraawo o woni omo haalana ɓe. ");
INSERT INTO fuh_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ɗum waɗi Iisa wi'i ɓe : —Nde on ɓanti *Ɓii-Neɗɗo fuu, on paaman ko Miin woni oon mo ngonmi. Mi waɗataa baafuy ngam hoore am. Ko *Baabiraawo anndini kam tan kaalananmi on. ");
INSERT INTO fuh_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Lilɗo kam oon no wondi he am, o accaay kam feere am, ngam ko weli mo tan ngaɗanmi nyannde fuu. ");
INSERT INTO fuh_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Wakkati Iisa haalirannoo nii, ɗuɓɓe ngoonɗini mo. ");
INSERT INTO fuh_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Iisa wi'i *Yahudankooɓe goonɗinɓe mo ɓeen : —Se on tinnake oɗon njogii haalaaji am, on laatoto *aahiiɓe am goongaaɓe. ");
INSERT INTO fuh_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","On anndan goonga, goonga oon duu no rimɗinan on. ");
INSERT INTO fuh_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ɓe njaabii mo, ɓe mbi'i : —Minen, min jippotooɓe he *Ibrahim, walaa marɗo min abada. Noy mbi'irtaa min ndimɗan ? ");
INSERT INTO fuh_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Iisa jaabii ɓe wi'i : —Miɗo haalana on goonga : Gaɗoowo hakke fuu, no maccuɗo hakke. ");
INSERT INTO fuh_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Abada maccuɗo duumataako nder hoggo, amma ɓiɗɗo no duumoto nder maggo faa abada. ");
INSERT INTO fuh_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ngam majjum, nde Ɓiɗɗo oon rimɗinii on, on laatoto rimɓe goongaaɓe. ");
INSERT INTO fuh_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Miɗo anndi ko on jippotooɓe he *Ibrahim, amma oɗon tefa warde kam, ngam konngi am naataay on. ");
INSERT INTO fuh_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Miin, miɗo haala ko ngiirumi *Baaba am, amma onon, oɗon ngaɗa ko narruɗon baabii'on. ");
INSERT INTO fuh_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ɓe njaabii mo, ɓe mbi'i : —Baabiimin woni *Ibrahim. Iisa wi'i ɓe : —Se nii on jippotooɓe he *Ibrahim, on ngaɗataana golleeji *Ibrahim. ");
INSERT INTO fuh_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Amma jooni oɗon tefa warde kam, miin kaalanɗo on goonga mo narrumi Alla. *Ibrahim kay, waɗaay ir ɗum. ");
INSERT INTO fuh_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Onon, golleeji baabii'on ngaɗoton. Ɓe mbi'i mo : —Minen, min kanaa ɓiɓɓe henndu. *Baabiraawo gooto min ngoodi, kanko woni Alla. ");
INSERT INTO fuh_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Iisa wi'i ɓe : —Se goonga fuu Alla wonnoo Baabii'on, on ngiɗan kam, ngam to Alla ƴuwmi, ngarmi to mooɗon. Mi waddaay hoore am, kanko lili kam. ");
INSERT INTO fuh_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ɗume waɗi ko on paamataa haala am ? On paamataa ka ngam ika daɗi hakkillo mon. ");
INSERT INTO fuh_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Onon, Ibiliisa woni baabii'on. Oɗon ngiɗi waɗude muuyo baabii'on. O baroowo himɓe illa fuɗɗorde. Abada o daraaki dow goonga, ngam goonga walaa he makko. Se o feni, jikku makko non, sabu o penoowo, o baaba fewre. ");
INSERT INTO fuh_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Amma miin, ngam miɗo haala goonga, waɗi ko on ngoonɗinaay kam. ");
INSERT INTO fuh_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Moy e mooɗon waawi seedaade ko mi waɗi hakke ? Ndenne ɗume waɗi se mi haalii goonga, on ngoonɗintaa kam ? ");
INSERT INTO fuh_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Neɗɗo Alla kay no hettintoo haala Alla. Onon nee, on kettintaako ngam on kanaa himɓe Alla. ");
INSERT INTO fuh_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","*Yahudankooɓe mbi'i Iisa : —Hanaa goonga amin ko min mbi'unoo a ɓii-leydi *Samariya, a laddaaɗo ? ");
INSERT INTO fuh_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Iisa jaabii ɓe wi'i : —Mi hanaa laddaaɗo, amma miɗo teddina *Baaba am. Onon, oɗon pamɗina kam. ");
INSERT INTO fuh_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Hanaa miin tefanta hoore am teddungal. No woodi tefanoowo kam ngal, oon woni kiitotooɗo. ");
INSERT INTO fuh_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Goonga kaalananmi on : Jogiiɗo haala am fuu, maayataa abada. ");
INSERT INTO fuh_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Nden *Yahudankooɓe mbi'i mo : —Joonkay min tabbintini ko a laddaaɗo. *Ibrahim e annabiiɓe fuu maayi, dey aan, mbi'aa jogiiɗo haala maa fuu, maayataa abada. ");
INSERT INTO fuh_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","A wonaana aɗa miila ko aɗa ɓuri baabiimin *Ibrahim manngu naa ? O maayi, annabiiɓe duu maayi. Moy ngonɗaa aɗa ada hoore maa nii ? ");
INSERT INTO fuh_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Iisa jaabii ɓe wi'i : —Miin, se hoore am teddinanmi, teddungal am no meere. *Baaba am, mo mbi'oton Alla mooɗon, teddinta kam. ");
INSERT INTO fuh_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Onon, on anndaa mo. Miin, miɗo anndi mo. Nde mi wi'i mi anndaa mo, mi laatake penoowo hano mooɗon. Amma miɗo anndi mo, miɗo jogii haala makko. ");
INSERT INTO fuh_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Baabii'on *Ibrahim no welwelta sanne ngam heɓa hi'a nyalaane am. O hi'i nde, o nani belɗum. ");
INSERT INTO fuh_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","*Yahudankooɓe mbi'i mo : —A waɗaay baa duuɓi woygu ginan, dey mbi'aa a hi'i *Ibrahim ? ");
INSERT INTO fuh_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Iisa wi'i ɓe : —Miɗo haalana on goonga : Illa *Ibrahim rimaaka, miɗo ɗon. ");
INSERT INTO fuh_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ko Iisa haali haala kaa sey ɓe adi kaaƴe faa ɓe mbugoo mo. Amma o moli, o wurtii *Juulirde mawne ndeen. ");
INSERT INTO fuh_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Wakkati Iisa woni no yawta, sey o hi'i gorko dimiraaɗo mbumdam gom. ");
INSERT INTO fuh_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","*Aahiiɓe makko ƴami mo mbi'i : —Moodibbo, ko o rimaa nder mbumdam ɗam, kanko waɗi hakke naa saarooɓe makko ? ");
INSERT INTO fuh_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Iisa jaabii ɓe wi'i : —Hanaa kanko, hanaa saarooɓe makko ngaɗi hakke. Amma ɗum heewtake mo heɓa baawɗe Alla mbannga dow makko. ");
INSERT INTO fuh_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","No tilsi ngaɗen golle lilɗo kam illa nder nyalooma. Ngam nde jemma wari, baa gooto waawaa gollude. ");
INSERT INTO fuh_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Nde miɗo nder duuniyaaru nduu, miin woni jeyngol mayru. ");
INSERT INTO fuh_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Gaɗa o haali haala kaa, sey o tutti dow leydi, o hawrodiri ndi e joode, o wuji e gite bumɗo oon. ");
INSERT INTO fuh_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","O wi'i mo : —Yah lootoy yeeso maa to luggere Silowam. Maana Silowam woni « Lilaaɗo. » O lootowi yeeso makko, o warti, omo hi'a. ");
INSERT INTO fuh_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Wondiraaɓe makko, he anndunooɓe ko o bumɗo piyoowo bara ndenno, mbi'i : —Tawte hanaa oo woni jooɗinooɗo no fiya bara naa ? ");
INSERT INTO fuh_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Woɓɓe mbi'i : —Kanko non ! Woɓɓe duu mbi'i : —Hanaa ! Nanndi makko nii non ! Amma gorko oon e hoore mum wi'i : —Miin nii non ! ");
INSERT INTO fuh_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Nden ɓe ƴami mo ɓe mbi'i : —Noy mbumtirɗaa ? ");
INSERT INTO fuh_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Neɗɗo oon jaabii ɓe wi'i : —Gorko bi'eteeɗo Iisa, waɗi kecciri, wuji e gite am, wi'i kam mi yaha to luggere Silowam, mi lootowa yeeso am. Lootoymi yeeso am, sey mbumtumi. ");
INSERT INTO fuh_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ɓe ƴami mo ɓe mbi'i : —Toy gorko oon woni ? O wi'i : —Mi anndaa ! ");
INSERT INTO fuh_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Nden himɓe njaari bumtinaaɗo oon to *Fariisa'en. ");
INSERT INTO fuh_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Tawi *nyalaane fowteteene non, Iisa waɗunoo kecciri wumtini mo. ");
INSERT INTO fuh_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ngam majjum *Fariisa'en duu ƴami mo no o wumtiri. O jaabii ɓe o wi'i : —O wuji kecciri e gite am, lootumi yeeso am, mbumtumi. ");
INSERT INTO fuh_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Gere nder *Fariisa'en mbi'i : —Gorko oo ƴuwaay to Alla ngam o hoddanaay *nyalaane fowteteene. Amma woɓɓe mbi'i : —Noy gaɗoowo hakke waawi waɗude ir kaayɗe ɗee ? Ɗum waddi rafi potal caka maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Nden *Fariisa'en ƴami bumtinaaɗo oon kaden mbi'i : —Ɗume mbi'ataa dow bumtinɗo ma oon ? O jaabii, o wi'i : —O annabiijo. ");
INSERT INTO fuh_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Mawɓe *Yahudankooɓe ɓeen kay njaɓaay ko o bumnooɗo e ko o wumti jooni, naako ɓe noddi saarooɓe makko. ");
INSERT INTO fuh_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ɓe ƴami ɓe, ɓe mbi'i : —Gorko oo, no ɓiyii'on naa ? On mbi'i ko mbumdam o rimdaa naa ? Ndenne noy waɗi ko o wumti joonin ? ");
INSERT INTO fuh_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Saarooɓe ɓeen njaabii, mbi'i : —Miɗen anndi ko o ɓiyiimin, miɗen anndi duu ko mbumdam o rimdaa. ");
INSERT INTO fuh_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Amma min anndaa noy o wumtiri. Min anndaa bumtinɗo mo oon duu. Ƴamee mo ! Kanko duu o mawɗo. Omo waawi jaabanaade hoore makko. ");
INSERT INTO fuh_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Saarooɓe makko njaaborake nii sabu iɓe kula mawɓe *Yahudankooɓe. Ngam ɓe potii dow ko neɗɗo fuu goonɗini ko Iisa woni *Almasiihu, ɓe ndiiwan joomum nder *waajordu. ");
INSERT INTO fuh_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ngam majjum waɗi saarooɓe ɓeen mbi'i : « O mawɗo. Ƴamee mo ! » ");
INSERT INTO fuh_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","*Fariisa'en nodditi bumtinaaɗo oon, mbi'i mo : —Hulu Alla ! Minen kay, miɗen anndi ko gorko oo no gaɗoowo hakke. ");
INSERT INTO fuh_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","O jaabii ɓe : —Se o gaɗoowo hakke duu, miin kay, mi anndaa. Gootel tan woni ko anndumi : Ndenno mi bumɗo, jooni mi wumti. ");
INSERT INTO fuh_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ɓe ƴamtini mo, ɓe mbi'i : —Ɗume o waɗani ma ? Noy o wumtiniri ma ? ");
INSERT INTO fuh_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","O jaabii ɓe, o wi'i : —Mi haalaniino on ɗum, amma on njaɓaay. Ɗume waɗi oɗon ngiɗi nantude ɗum kaden ? Tawte onon duu, oɗon ngiɗi laataade *aahiiɓe makko non ? ");
INSERT INTO fuh_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ɓe njenni mo, ɓe mbi'i : —Aan nii woni aahiijo makko ! Minen kay, min aahiiɓe *Muusa. ");
INSERT INTO fuh_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Minen, miɗen anndi Alla haaldii he *Muusa, amma neɗɗo oo kay, min anndaa fuu to o ƴuwata. ");
INSERT INTO fuh_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Gorko oon jaabii ɓe, wi'i : —Haba ? Hannden mi hi'i haayne. On anndaa to o ƴuwi, dey o wumtinii kam ! ");
INSERT INTO fuh_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Eɗen anndi Alla hettintaako waɗooɓe hakke, amma omo jaabanoo kuloowo mo, gaɗoowo muuyo makko. ");
INSERT INTO fuh_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Illa fuɗɗam duuniyaaru walaa nanuɗo bumtinɗo dimdaaɗo mbumdam. ");
INSERT INTO fuh_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Se nii hanaa to Alla gorko oo ƴuwi, o waawtaa waɗude baafuy. ");
INSERT INTO fuh_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ɓe njaabii mo : —Aan, laatiiɗo a fuu nder hakke ndimeɗaa, aan waajoto min naa ! Ɓe ndiiwi mo. ");
INSERT INTO fuh_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Iisa nani ɓe ndiiwii mo, sey yehi tawowi mo, wi'i mo : —Aan nee, a goonɗini *Ɓii-Neɗɗo naa ? ");
INSERT INTO fuh_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","O jaabii, o wi'i : —Moodibbo, moy woni *Ɓii-Neɗɗo ? Hollan mo faa mi goonɗina mo ? ");
INSERT INTO fuh_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Nden Iisa wi'i mo : —A hi'i mo, kanko jaati woni no haalda he maa. ");
INSERT INTO fuh_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Sey o jaabii Iisa o wi'i : —Joomiraawo, mi goonɗini. O sujidani Iisa. ");
INSERT INTO fuh_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Nden Iisa wi'i mo : —Mi wari nder duuniyaaru ngam kiite ngaɗaa, wumɓe ngi'a, hi'ooɓe mbumaa. ");
INSERT INTO fuh_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Woɓɓe nder *Fariisa'en wonɓe hadde makko, nanuɓe haala kaa, ƴami mo mbi'i : —Ndenne, min wumɓe naa ? ");
INSERT INTO fuh_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Iisa jaabii ɓe, wi'i : —Se on wumɓe, nden on gaɗataano hakke. Amma ko mbi'uɗon joonin oɗon ngi'a, hakkeeji mooɗon tabbitii. ");
INSERT INTO fuh_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Iisa wi'i : —Miɗo haalana on goonga : Neɗɗo fuu naatoowo hoggo baali dey naatiraay dammbugal, kam woni gujjo, kam woni teetoowo. ");
INSERT INTO fuh_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Amma naatiroowo dammbugal oon woni duroowo baali ɗiin. ");
INSERT INTO fuh_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Deenoowo dammbugal oon no maɓɓitanan mo, baali ɗiin duu no nanan daane makko. O noddiran mbaalu makko fuu he innde mum, o wurtina ɗi yaasi. ");
INSERT INTO fuh_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Nde o wurtini ɗi ɗi fuu, o ardoto, ɗi tokka mo ngam iɗi anndi daane makko. ");
INSERT INTO fuh_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ɗi tokkataa koɗo sam, amma ɗi ndoggan mo sabu ɗi anndaa daane makko. ");
INSERT INTO fuh_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Iisa hippani ɓe haala kaa, amma ɓe paamaay maana makka. ");
INSERT INTO fuh_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","O ɓeydi wi'ude : —Miɗo haalana on goonga, miin woni dammbugal hoggo baali. ");
INSERT INTO fuh_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Artuɓe kam fuu no wuyɓe e teetooɓe, baali ɗiin nanaay daaɗe maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Miin woni dammbugal, neɗɗo fuu naatirɗo kam, hisan, no oornan heɓa duurduɗe, jaaƴina. ");
INSERT INTO fuh_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Gujjo warataana ngam wujja, itta yonki, bonna, amma miin, mi warii faa himɓe keɓa mbuurnam ngam ɓe keɓira ɗam no ɗuuɗiri. ");
INSERT INTO fuh_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Miin woni duroowo lobbo. Duroowo lobbo woni cottoowo yonki mum ngam baali mum. ");
INSERT INTO fuh_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Amma duroowo joɓeteeɗo hanaa duroowo goongaajo. O hanaa jom baali, illa o holliri suunu no wara, o doggan o acca ɗi. Nden ndu saama e majji, ɗi cankitoo. ");
INSERT INTO fuh_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","O doggan ngam o duroowo joɓeteeɗo tan, walaa fuu ko hilli mo he baali ɗiin. ");
INSERT INTO fuh_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Miin woni duroowo lobbo. Miɗo anndi baali am, baali am duu no anndi kam. ");
INSERT INTO fuh_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Hano no *Baabiraawo anndiri kam, non anndirmi *Baabiraawo. Miɗo sotta yonki am ngam baali am. ");
INSERT INTO fuh_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Miɗo woodi baali gom kaden ɗi ngalaa nder hoggo ngoo. Kanƴi duu no tilsi mi waddowa ɗi. Ɗi nanan daane am, ɗi laatoto sewre worre nde duroowo gooto. ");
INSERT INTO fuh_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ko waɗi *Baabiraawo no hiɗi kam woni ngam mi sottan yonki am faa mi heɓita ki kaden. ");
INSERT INTO fuh_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Walaa ittoowo ki, ngam miin e hoore am hokkata ki. Miɗo woodi baawɗe hokkude ki. Miɗo woodi baawɗe heɓtude ki. Ɗum woni tilsinoore nde keɓumi to *Baaba am. ");
INSERT INTO fuh_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Haalaaji ɗii ɓeydi senndude *Yahudankooɓe. ");
INSERT INTO fuh_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ɗuɓɓe nder maɓɓe no mbi'a : —O kaaŋaaɗo kuɓɗo ! Ko saabii oɗon kettinanii mo ? ");
INSERT INTO fuh_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Gere maɓɓe duu mbi'i : —Haala kaa hanaa haala laddaaɗo. Laddaaɗo no waawi wumtinde bumɗo naa ? ");
INSERT INTO fuh_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","*Juulɗe cenɗinol Juulirde mawne ngaɗi *Ursaliima. Ɗum fotodiri he dabbune. ");
INSERT INTO fuh_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Nder *Juulirde mawne ndeen, Iisa no yaha no warta ley danki Suleymaanu. ");
INSERT INTO fuh_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Sey *Yahudankooɓe piili mo, mbi'i : —Faa nde tinnotoɗaa aɗa jogii min nder wemmbere ? Se aan woni *Almasiihu, laaɓinan min. ");
INSERT INTO fuh_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Iisa jaabii ɓe, wi'i : —Mi arti mi haalanii on ɗum, amma on ngoonɗinaay. Golleeji ɗi ngaɗumi dow innde *Baaba am ɗiin, kanƴi jaati ceedantoo kam. ");
INSERT INTO fuh_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Amma onon, on ngoonɗinaay ngam on kanaa baali am. ");
INSERT INTO fuh_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Baali am no nana daane am. Miɗo anndi ɗi, iɗi tokka kam. ");
INSERT INTO fuh_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Miɗo hokka ɗi mbuurnam nduumiiɗam, ɗi mbaatataa abada. Walaa baawɗo teetirde ɗi semmbe semmbe nder junngo am. ");
INSERT INTO fuh_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","*Baabiraawo kokkuɗo kam ɗi oon, no ɓuri huune fuu. Walaa baawɗo teetirde ɗi semmbe semmbe nder junngo *Baabiraawo. ");
INSERT INTO fuh_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Miin e *Baabiraawo fuu, min go'o. ");
INSERT INTO fuh_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Sey *Yahudankooɓe adi kaaƴe faa paɗɗa mo. ");
INSERT INTO fuh_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Amma Iisa wi'i ɓe : —Yeeso mooɗon, baawɗe *Baabiraawo ngaɗirmi golle ɗuɗɗe lobbe sanne ɗe fuu. Nder golle ɗe ngaɗumi ɗe fuu, ngam gollal ngale ngiɗɗon faɗɗude kam kaaƴe ? ");
INSERT INTO fuh_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","*Yahudankooɓe njaabii mo mbi'i : —Hanaa ngam golle lobbe min ngiɗi warirde ma kaaƴe. Ko waɗi miɗen ngiɗi warude ma woni a famɗini Alla. Aan a tagaaɗo, dey a adi hoore maa Alla. ");
INSERT INTO fuh_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Iisa jaabii ɓe, wi'i : —Hanaa no winndaa nder *Tawreeta mooɗon ko Alla wi'i : Onon, on allaaɓe  ? ");
INSERT INTO fuh_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Eɗen anndi ko haala Alla sottataa. Nde Alla noddiri ɓe o suɓii ɓeen « allaaɓe », ");
INSERT INTO fuh_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","too, miin mo Alla senɗini, lili nder duuniyaaru nduu, noy haala am laatortoo pamɗinol Alla ngam mi wi'i : « Miin, mi *Ɓii-Alla »  ? ");
INSERT INTO fuh_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Se nii mi waɗaay golleeji *Baaba am, to ngoonɗinee kam. ");
INSERT INTO fuh_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Amma se miɗo waɗa ɗi, baa se on ngoonɗintaa kam, ngoonɗinee golleeji ɗii, ngam paamon, njaɓon duu no wooɗiri ko *Baabiraawo no wondi he am, miɗo wondi he makko. ");
INSERT INTO fuh_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Nden ɓe tefi nanngude mo kaden. O soptii ɓe. ");
INSERT INTO fuh_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Iisa soƴƴii toon gaɗa maayo Urdun nokkuure to Yahaaya waɗanannoo himɓe *batisma, o jooɗii toon. ");
INSERT INTO fuh_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Himɓe ɗuɓɓe ngari to makko, iɓe mbi'odira : —Yahaaya waɗaay haayne baa wootere. Amma, ko o haali dow gorko oo fuu no goonga. ");
INSERT INTO fuh_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Toon ɗuɓɓe ngoonɗini Iisa. ");
INSERT INTO fuh_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Nder wuro Baytaniya no woodi gorko bi'eteeɗo Laajaru, Laajaru oo yemaaki. Omo woodi sakiraaɓe makko rewɓe ɗiɗo gom, Marta e Mariyaama. ");
INSERT INTO fuh_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mariyaama woni debbo bujunooɗo nebbam uurɗam dow koyɗe Iisa, moytiri ɗe gaasa mum. Too, Mariyaama oo banndum gorko woni Laajaru oo. ");
INSERT INTO fuh_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Sakiraaɓe Laajaru rewɓe ɗiɗo ɓee lili goɗɗo wi'a Iisa : —Moodibbo, war ! Giɗo maaɗa yamɗaa. ");
INSERT INTO fuh_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Nde Iisa nanunoo ɗum, sey wi'i : —Nyaw nguu hanaa nyaw mbaroowu. Amma ngu wari ngam wannginde teddungal Alla, heɓa *Ɓii-Alla oon duu teddinee. ");
INSERT INTO fuh_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Iisa no hiɗi Marta, Mariyaama e sakiike maɓɓe gorko Laajaru. ");
INSERT INTO fuh_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Baa nii ko Iisa nanii Laajaru yamɗaa, ɗum haɗaay mo jooɗaade to o wonnoo toon balɗe ɗiɗi. ");
INSERT INTO fuh_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Gaɗa ɗum o wi'i *aahiiɓe makko : —En coƴƴoo leydi Yahudiya ! ");
INSERT INTO fuh_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","*Aahiiɓe ɓeen mbi'i mo : —Moodibbo, ɓooyaay ko *Yahudankooɓe tefi faɗɗude ma kaaƴe nder leydi ndiin. Toon ngiɗaa soƴƴaade kaden naa ? ");
INSERT INTO fuh_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Iisa jaabii ɓe wi'i : —Hanaa jamɗe sappo e ɗiɗi ngoni nder nyalooma gooto naa ? Dilloowo nyalooma fuu fergataako ngam no hi'a jeyngol duuniyaaru. ");
INSERT INTO fuh_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Amma dilloowo jemma fergoto ngam jeyngol walaa he makko. ");
INSERT INTO fuh_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Gaɗa o haalii haalaaji ɗii, o wi'i ɓe : —Higii'en Laajaru ɗaanake, mi yahan, mi findinowa mo. ");
INSERT INTO fuh_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Nden ɓe mbi'i mo : —Moodibbo, se tawaama o ɗaaniiɗo, ndenne o daɗan. ");
INSERT INTO fuh_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Maayde Laajaru o haalani ɓe. Amma kamɓe kay, ɓe miilataana ko filla ɗoyngol allawol ngool nii o wondi. ");
INSERT INTO fuh_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Nden Iisa laaɓinani ɓe, wi'i : —Laajaru laatake ! ");
INSERT INTO fuh_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Mi nani belɗum ngam mooɗon ko mi tawaaka toon. Ɗum laatanto on sabaabu goonɗinol. Amma en njaha to makko. ");
INSERT INTO fuh_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Nden Tomas bi'eteeɗo Funeejo wi'i *aahiiɓe ɓeeto : —Accee, njehen enen duu baa nde en maaydan he makko non. ");
INSERT INTO fuh_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Wakkati Iisa yottii, tawi Laajaru waɗi balɗe nay he mooɓeede. ");
INSERT INTO fuh_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Hakkune Baytaniya e *Ursaliima ɓuraa kilooji tati. ");
INSERT INTO fuh_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","*Yahudankooɓe ɗuɓɓe ngari kinniri Mariyaama e Marta maayde Laajaru. ");
INSERT INTO fuh_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Wakkati Marta nanunoo Iisa no wara, o acci Mariyaama no jooɗii nder suudu, o yehi o jaɓɓitowii mo. ");
INSERT INTO fuh_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta wi'i Iisa : —Joomam, se nii aɗa wonnoo ɗo, banndam gorko maayataano. ");
INSERT INTO fuh_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Amma miɗo anndi baa joonin, ko ƴamɗaa Alla fuu, o waɗante ɗum. ");
INSERT INTO fuh_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Nden Iisa wi'i mo : —Bannda gorko no ummitoto. ");
INSERT INTO fuh_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta wi'i : —Miɗo anndi ko o ummitittoo nyannde darŋal. ");
INSERT INTO fuh_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Iisa wi'i mo : —Miin woni ummitaaki maayɓe, miin woni mbuurnam duu. Neɗɗo fuu goonɗinɗo kam, baa se maayi, no wuuran. ");
INSERT INTO fuh_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Buurɗo goonɗinɗo kam fuu, maayataa abada. A goonɗini ɗum naa ? ");
INSERT INTO fuh_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marta wi'i mo : —Ayyo, Joomam ! Mi goonɗini aan woni *Almasiihu, *Ɓii-Alla, bannganɗo duuniyaaru nduu. ");
INSERT INTO fuh_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Gaɗa ko o haali ɗum, o yehi o noddowi sakiike makko, Mariyaama. O nyo'ani mo, o wi'i : —Moodibbo oon warii, omo nodde. ");
INSERT INTO fuh_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Illa ko Mariyaama nanunoo ɗum, o yaawɗi o yehi to Iisa. ");
INSERT INTO fuh_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Wakkati mum fuu Iisa naataay wuro ngoon ginan. Omo wonnoo to Marta fottunoo he makko. ");
INSERT INTO fuh_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","*Yahudankooɓe wondunooɓe he Mariyaama nder suudu no cawrina mo, wakkati ɓe ngi'unoo o yaawɗi o wurtii, sey ɓe tokki mo, ngam ɓe miilii to annyeere ndeen o fa'i faa o woyowa. ");
INSERT INTO fuh_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Nde Mariyaama yottii to Iisa woni, illa o hi'i mo, o hofi yeeso makko, o wi'i : —Joomam, se nii aɗa wonnoo ɗo, banndam gorko maayataano. ");
INSERT INTO fuh_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Wakkati Iisa hi'unoo Mariyaama e *Yahudankooɓe wondunooɓe he mum ɓeen no mboya, ɓerne makko metti sanne. ");
INSERT INTO fuh_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","O wi'i : —Toy mooɓuɗon mo ? Ɓe mbi'i mo : —Moodibbo, war, ƴeewu ! ");
INSERT INTO fuh_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Sey Iisa fusi gonɗi. ");
INSERT INTO fuh_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Nden *Yahudankooɓe gom mbi'i : —Ƴeewee no o hiɗiri mo. ");
INSERT INTO fuh_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Amma woɓɓe maɓɓe duu mbi'odiri : —Bumtinɗo bumɗo no waawaa haɗude gorko oo maayde naa ? ");
INSERT INTO fuh_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ɓerne Iisa metti kaden, nden o yehi tiimoyde annyeere ndeen. Annyeere ndeen, lowol maɓɓiraangol hayre non. ");
INSERT INTO fuh_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Nden Iisa wi'i : Ittee hayre ndee ! Marta sakiike maayɗo oon wi'i mo : —Joomam, hannden tawan henndu makko waylake, sabu hannden woni balɗe makko nay he maayde. ");
INSERT INTO fuh_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Iisa jaabii mo, wi'i : —Hanaa mi wi'i ma, se a goonɗini, a hi'an baawɗe Alla naa ? ");
INSERT INTO fuh_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ɓe itti hayre ndeen. Iisa tiggitii, wi'i : —*Baabiraawo, mi yettii ma ngam a hettinake kam. ");
INSERT INTO fuh_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Miin kay, miɗo anndi nyannde fuu aɗa hettinanii kam. Amma mi haaliri nii sabu himɓe dariiɓe ɓee, ngam ɓe ngoonɗina aan lili kam. ");
INSERT INTO fuh_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Gaɗa haalaaji ɗii, o ɓanti daane makko, o huuɓi sanne, o wi'i : —Laajaru, wurta ! ");
INSERT INTO fuh_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Sey maaynooɗo oon wurtii. Juuɗe mum e koyɗe mum no kaɓɓaa leppi, yeeso mum no suddii. Nden Iisa wi'i ɓe : —Piirtee mo o yaha ! ");
INSERT INTO fuh_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ɗuɓɓe nder *Yahudankooɓe warnooɓe to Mariyaama, hi'uɓe ko waɗi, ngoonɗini Iisa. ");
INSERT INTO fuh_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Amma gere maɓɓe njehi to *Fariisa'en, kaalani ɓe ko Iisa waɗi. ");
INSERT INTO fuh_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Nden *Fariisa'en e hooreeɓe *cakkanooɓe Alla ngaɗi hawriine mawne, ɓe mbi'i : —Noy ngatten ? Ngam gorko oo no waɗa kaayɗe ɗuɗɗe. ");
INSERT INTO fuh_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Se en accirii mo nii, ɓe fuu, ɓe ngoonɗinan mo. Nden himɓe *Rooma ngara, nannga *Juulirde meeɗen mawne e lenyol meeɗen. ");
INSERT INTO fuh_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Gooto maɓɓe bi'eteeɗo Kayafas laatiiɗo mawɗo *cakkanooɓe Alla nder hitaane ndeen, wi'i ɓe : —Onon, on anndaa baafuy. ");
INSERT INTO fuh_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","On anndaa ko neɗɗo gooto maayana himɓe fuu no ɓuri wooɗande en dina lenyol ngool fuu halka. ");
INSERT INTO fuh_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Hanaa muuyo makko o haaliri haala kaa, amma annabaaku o waɗi ɗoon. Hitaane ndeen kanko woni mawɗo *cakkanooɓe Alla, nder annabaaku nguu o wi'i ko Iisa no maayanan lenyol ngool. ");
INSERT INTO fuh_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Hanaa lenyol ngool tan o maayanta, amma ngam o hawra ɓiɓɓe Alla sankitiiɓe ɓeen fuu laatoo gootum. ");
INSERT INTO fuh_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Illa nyannde mum, hooreeɓe *Yahudankooɓe caawodiri dow no ɓe mbardata mo. ");
INSERT INTO fuh_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ɗum duu waɗi Iisa acci fiilaade hakkune *Yahudankooɓe. Nden o yehi Efrayim, wuro wonngo har ladde yeeruure. O jooddii he *aahiiɓe makko. ");
INSERT INTO fuh_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Juulɗe *Yahudankooɓe gom bi'eteeɗe *Juulɗe dimɗinol Isra'ilankooɓe ɓadake. Sey himɓe ɗuɓɓe nder leydi ndiin njehi *Ursaliima faa laaɓina ko'e mum fadde juulɗe ɗee fuɗɗude. ");
INSERT INTO fuh_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ɓe ndarii nder *Juulirde mawne ndeen, iɓe tefa Iisa, ɓe mbi'odiri : —Ɗume miiloton ? O waran to juulɗe ɗee naa noy ? ");
INSERT INTO fuh_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Tawi mawɓe *cakkanooɓe Alla e *Fariisa'en kokki tilsinoore wi'ude annduɗo to o woni fuu, haala faa o nanngee. ");
INSERT INTO fuh_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Balɗe jeegom fadde *Juulɗe dimɗinol Isra'ilankooɓe yottaade, Iisa yehi Baytaniya to Laajaru mo o ummintinnoo he maayde oon. ");
INSERT INTO fuh_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ɓe njonngani mo hiraane, Marta woni no yeddana ɓe nde. Laajaru no wondi he nyaamdooɓe he Iisa ɓeen. ");
INSERT INTO fuh_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Nden Mariyaama hooƴi feccere liteereeru nebbam uurɗam, nebbam caadiɗam, ɗam hawrodiraaka he huune fuu, wuji koyɗe Iisa, moytiri ɗe gaasa mum. Suudu nduun fuu uuri. ");
INSERT INTO fuh_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Sey Yahuuda Iskariyot, gooto nder *aahiiɓe ɓeen, jammboytooɗo Iisa, wi'i : ");
INSERT INTO fuh_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—Ɗume waɗi nebbam ɗaam sonnaaka, ceede ɗeen kokkee talkaaɓe ? Ngam ceede majjam no yoɓa gollooɓe keme tato. ");
INSERT INTO fuh_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Hanaa ngam yurmeene talkaaɓe waɗi o wi'i haala kaa, amma ngam o gujjo. Kanko wonnoo jogiiɗo mbasu ceede maɓɓe. Omo wujjanno duu he majje. ");
INSERT INTO fuh_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Amma Iisa wi'i : —Takkita debbo oo. O resi ɗam ngam nyalaane mooɓeteemi. ");
INSERT INTO fuh_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Talkaaɓe no tawdee he mooɗon nyannde fuu. Amma miin, mi tawdataake he mooɗon nyannde fuu. ");
INSERT INTO fuh_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","*Yahudankooɓe ɗuɓɓe nanani Iisa Baytaniya, njehi toon. Hanaa Iisa tan waɗi ɓe njehi toon, ɓe njehi duu ngam ɓe ngi'a Laajaru ummintinaaɗo oon. ");
INSERT INTO fuh_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Mawɓe *cakkanooɓe Alla ngaɗi daane worre ngam warude Laajaru duu. ");
INSERT INTO fuh_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Ngam daliila Laajaru, *Yahudankooɓe ɗuɓɓe ceedi he mawɓe mum'en, ngoonɗini Iisa. ");
INSERT INTO fuh_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Jaangoore mum jama'aare ɗuunde, warde to juulɗe ɗeen, nani ko Iisa no wara *Ursaliima. ");
INSERT INTO fuh_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Sey ɓe taƴi licce dabinaaje, ɓe njaɓɓitowii mo. Iɓe kuuɓa, iɓe mbi'a : —Hosanna !Barkinaaɗo woni garɗo dow innde Joomiraawo, Laamiiɗo *Isra'el ! ");
INSERT INTO fuh_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Iisa duu heɓi arel gom, waɗɗii, hano no ɗum winndiraa nder dewte wi'aa : ");
INSERT INTO fuh_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Himɓe huɓeere *Siyon, to kulee ! Ndaaree da : Laamiiɗo mon no wara, no waɗɗii arel. ");
INSERT INTO fuh_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Arannde fuu *aahiiɓe makko paamaayno ko woni no waɗa. Amma wakkati ɓe ngi'unoo Iisa teddinaa, nden ɓe miccitii ko ɓe ngaɗani mo ɗum fuu winndaanooma dow makko nder dewte. ");
INSERT INTO fuh_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Jama'aare tawanoone toon wakkati o noddanno Laajaru wurtoo nder annyeere ndeen, e ko o ummintini mo fuu ceedake dow ko ɓe ngi'ii ɗum. ");
INSERT INTO fuh_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ɗum duu waɗi himɓe ɗuɓɓe njaɓɓiti mo, wakkati ɓe nanunoo haayne nde o waɗi. ");
INSERT INTO fuh_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Nden *Fariisa'en mbi'odiri : —On ngi'ii, walaa fuu ko mbaawɗen waɗande mo. Duuniyaaru nduu fuu no dogga gaɗa makko. ");
INSERT INTO fuh_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Gerekankooɓe gom ngari *Ursaliima to juulɗe ɗeen ngam ndewa Alla. ");
INSERT INTO fuh_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ɓe ɓattii Filipa jeyaaɗo Baytisayda, nder leydi Galili. Ɓe mbi'i ɗum : —Mawɗo, miɗen ngiɗi min ngi'a Iisa. ");
INSERT INTO fuh_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filipa haalanowi Andiire, ɓe fuu ɗiɗo njehi kaalanowi Iisa. ");
INSERT INTO fuh_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Iisa jaabii ɓe, wi'i : —Wakkati teddinol *Ɓii-Neɗɗo warii. ");
INSERT INTO fuh_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Miɗo haalana on goonga : Wabbere alkama fusataa nder leydi se nde ufaaka. Amma se nde ufaama, nde fusan. Nden nde fuɗan, nde rima faa ɗuuɗa. ");
INSERT INTO fuh_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Giɗɗo yonki mum fuu no mursan ki, jeebiiɗo ki nder duuniyaaru nduu, no heɓan mbuurnam nduumiiɗam. ");
INSERT INTO fuh_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Giɗɗo gollande kam fuu, sey se tokki kam. To ngonmi fuu, ɗon golloowo am duu tawetee. *Baabiraawo no teddinan gollanoowo kam fuu. ");
INSERT INTO fuh_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Joonkay, mi wemmbaama. Ɗume mbi'anmi ? Mi wi'a *Baabiraawo hisinam e wakkati oo naa ? Aa'a, mi waawtaa wi'ude ɗum ngam sabbu wakkati oo jaati ngarmi. ");
INSERT INTO fuh_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","*Baabiraawo, teddin innde maa. Sey daane gom ƴuwi dow, wi'i : —Mi teddiniino nde, mi teddinan nde kaden. ");
INSERT INTO fuh_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Himɓe dariiɓe toon nani ko waɗi, nden mbi'i ɗum riggaaŋo kammu. Woɓɓe mbi'i maleykaajo haaldi he makko. ");
INSERT INTO fuh_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Iisa wi'i ɓe : —Ɓeydaari mooɗon waɗi daane ndee nanaa amma nde nanaaka ngam ɓeydaari am. ");
INSERT INTO fuh_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Joonin woni wakkati kiite duuniyaaru nduu. Joonin, Ibiliisa laamiiɗo duuniyaaru nduu riiwetee. ");
INSERT INTO fuh_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Miin, se mi ƴencinaama dow, mi fooɗan himɓe fuu ngara to am. ");
INSERT INTO fuh_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Iisa haaliri nii ngam hollude no kam maayirta. ");
INSERT INTO fuh_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Nden himɓe ɓeen njaabii mo mbi'i : —Winndaama nder *Tawreeta : *Almasiihu oon maayataa abada. Noy mbi'irtaa *Ɓii-Neɗɗo no ɓantetee dow ? Moy woni *Ɓii-Neɗɗo oo ? ");
INSERT INTO fuh_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Iisa jaabii ɓe : —Oɗon nder jeyngol ginan, amma ɗum ɓooyataa. Ndillee illa oɗon nder jeyngol, ngam to nimre juhu on. Sabu dilloowo nder nimre anndaa fuu to yahata. ");
INSERT INTO fuh_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ngoonɗinee jeyngol illa oɗon nder maggol heɓa laatoɗon ɓiɓɓe jeyngol ngool. Gaɗa Iisa haaliri nii, yehi, suuɗowii. ");
INSERT INTO fuh_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Baa ko o waɗi kaayɗe ɗuɗɗe ɗee fuu yeeso maɓɓe, ɓe ngoonɗinaay mo. ");
INSERT INTO fuh_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ɗum fuu waɗi ngam humnude haala *Esaaya mbi'uka : Joomiraawo, moy goonɗini waaju meeɗen ? Moy Joomiraawo wannginani baawɗe mum ? ");
INSERT INTO fuh_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","*Esaaya haali duu ko waɗi himɓe ɓee mbaawtaa goonɗinde, o wi'i : ");
INSERT INTO fuh_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Alla wumnii ɓe, yoornii ɓerɗe maɓɓe, ngam to gite maɓɓe ngi'u, to ɓerɗe maɓɓe paamu, sako ɓe tuuba faa mi danna ɓe. ");
INSERT INTO fuh_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","*Esaaya wi'i ɗum, ngam o hi'ino teddungal Iisa, o haali dow makko duu. ");
INSERT INTO fuh_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Amma baa ko nii waɗi ɗuɓɓe nder hooreeɓe *Yahudankooɓe ngoonɗinii Iisa. Dey ngam kulal *Fariisa'en waɗi ɓe ceedanaaki mo ngam to ɓe ndiiwee nder *waajordu. ");
INSERT INTO fuh_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Iɓe coofi teddinde himɓe ɓurde teddinde Alla. ");
INSERT INTO fuh_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Nden Iisa huuɓi, wi'i : —Neɗɗo fuu goonɗini kam, hanaa miin tan goonɗini, amma lilɗo kam oon joomum goonɗini. ");
INSERT INTO fuh_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Gi'uɗo kam fuu, hi'i lilɗo kam. ");
INSERT INTO fuh_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Min woni jeyngol, mi wari nder duuniyaaru heɓa goonɗinɗo kam fuu to tawee nder nimre. ");
INSERT INTO fuh_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Nde goɗɗo nani haalaaji am, goonɗinaay, hanaa miin hiitoto mo. Ngam mi waraay hiitaade duuniyaaru nduu, amma mi wari faa mi hisina ndu. ");
INSERT INTO fuh_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Caliiɗo kam jaɓataa haalaaji am, heɓi ko hiitoto ɗum. Haala ka kaalumi kaa, kanka hiitoto joomum nyannde darŋal. ");
INSERT INTO fuh_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Mi walaa miɗo haala muuyo hoore am, amma *Baabiraawo lilɗo kam, kam hokki kam ko kaalanmi e ko mbaajotoomi. ");
INSERT INTO fuh_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Miɗo anndi ko waaju mo o halfini kam oo no hokka mbuurnam nduumiiɗam faa abada. Ngam majjum waɗi ko kaalumi fuu, miɗo haalira ɗum, hano no *Baabiraawo haalirani kam ɗum. ");
INSERT INTO fuh_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Fadde *Juulɗe dimɗinol Isra'ilankooɓe yottaade, Iisa anndi ko wakkati mo o dillata nder duuniyaaru o soƴƴoo to *Baabiraawo yottake. Omo hiɗi himɓe makko wonɓe nder duuniyaaru, omo hiɗi ɓe keerol baawɗe makko. ");
INSERT INTO fuh_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Wakkati Iisa e *aahiiɓe mum ngoni no kiirtoo, tawi Ibiliisa re'i watti anniya jammbaade mo nder ɓerne Yahuuda Iskariyot ɓii-Simon. ");
INSERT INTO fuh_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Iisa no anndi ko Alla watti huune fuu nder junngo mum. Omo anndi duu to Alla kam ƴuwi, to Alla kam soƴƴoto. ");
INSERT INTO fuh_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","O ummii, o ɓorti jabbaare makko, o hooƴi lefol, o tuundi. ");
INSERT INTO fuh_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Nden o wanji ndiyam nder tummbude, o fuɗɗi lootude koyɗe *aahiiɓe makko, omo moytira ɗe lefol ngol o tuundi. ");
INSERT INTO fuh_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Wakkati o yottinoo to Simon Piyer, Simon Piyer wi'i mo : —Joomam, aan lootata koyɗe am ? ");
INSERT INTO fuh_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Iisa jaabii mo wi'i : —A faamataa ko ngaɗanmi jooni, amma a faamowan yeeso seɗɗa. ");
INSERT INTO fuh_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Piyer wi'i mo : —A lootataa koyɗe am abada ! Iisa jaabii mo : —Se nii mi lootaay ɗe, a walaa mbaka to am. ");
INSERT INTO fuh_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Sey Simon Piyer wi'i mo : —Joomam ! Se non ɗum worri, taa haaɗu he koyɗe am tan, lootu juuɗe am e hoore am duu. ");
INSERT INTO fuh_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Iisa wi'i mo : —Lootiiɗo fuu no laaɓuɗo. Koyɗe makko tan o haajaa lootude. Onon on laaɓuɓe, amma hanaa on fuu. ");
INSERT INTO fuh_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Iisa no anndi jammbotooɗo ɗum, kam waɗi o wi'i hanaa ɓe fuu ngoni laaɓuɓe. ");
INSERT INTO fuh_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Nde Iisa lootidinnoo koyɗe maɓɓe, o hooƴi jabbaare makko, o jooɗii, nden o wi'i : —On paamii ko ngaɗanmi on ɗum ? ");
INSERT INTO fuh_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Oɗon noddira kam Moodibbo e Joomiraawo. On penaay, sabu miin woni ɗum fuu. ");
INSERT INTO fuh_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ndenne, se miin gonɗo Joomiraawo e Moodibbo mooɗon, se mi lootii koyɗe mooɗon, onon duu oɗon kaani lootodirde koyɗe. ");
INSERT INTO fuh_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ko kollumi on ɗum no laawol non ngam onon duu ngaɗon hano ko ngaɗanmi on ɗum. ");
INSERT INTO fuh_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Miɗo haalana on goonga, maccuɗo ɓurataa joomum, lilaaɗo ɓurataa lilɗo ɗum. ");
INSERT INTO fuh_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Jooni ko annduɗon ɗum, se on ngollirii ɗum, on mbelii ko'e. ");
INSERT INTO fuh_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","—Mi walaa miɗo haalda he mooɗon, on fuu, miɗo anndi ɓe cuɓiimi. Amma no tilsi ko winndaa nder dewte ɗum huuɓa, kam woni : Junngo nyaamdoowo he am ngoon fiyi kam. ");
INSERT INTO fuh_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Miɗo haalana on ɗum illa jooni fadde majjum yottaade, ngam nde ɗum yottake fuu, ngoonɗinon ko « Miin woni oon mo ngonmi »  ! ");
INSERT INTO fuh_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Miɗo haalana on goonga : Neɗɗo fuu jaɓɓiiɗo mo lilumi, miin jaɓɓii. Neɗɗo fuu jaɓɓiiɗo kam, jaɓɓake lilɗo kam oon duu. ");
INSERT INTO fuh_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Gaɗa ko o haaliri nii, ɓerne makko metti sanne, o wi'i : —Goonga kaalananmi on : Gooto nder mooɗon jammboto kam. ");
INSERT INTO fuh_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","*Aahiiɓe ɓeen ƴeewodiri, ɓe anndaa dow moy o woni omo haala. ");
INSERT INTO fuh_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Gooto nder *aahiiɓe ɓeen mo Iisa hiɗi oon, no wahinoo hadde makko. ");
INSERT INTO fuh_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simon Piyer fiyani mo hitere ngam o ƴama Iisa moy o wondi. ");
INSERT INTO fuh_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Nden aahiijo oon ɓaggi Iisa, ƴami mo : —Joomam, moy non ? ");
INSERT INTO fuh_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Iisa jaabii mo wi'i : —Mi suuwan ŋoppitto buuru, mo kokkanmi ngo, woni mo. Nden o hooƴi ngo, o suuwi, o hokki Yahuuda Iskariyot, ɓii-Simon. ");
INSERT INTO fuh_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Illa o jaɓi ŋoppitto ngoon Ibiliisa naati nder ɓerne makko. Iisa wi'i mo : —Waɗu ko ngaɗataa law law ! ");
INSERT INTO fuh_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Nder wahinooɓe toon ɓeen baa gooto faamaay ngam ɗume o haali ɗum. ");
INSERT INTO fuh_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ngam Yahuuda no joginoo mbasu ceede nguun, woɓɓe miili ko Iisa lili mo o soodowa ko ɓe kaajaa ngam juulɗe ɗeen, naa kaden ngam o heɓa ko o hokki talkaaɓe. ");
INSERT INTO fuh_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yahuuda jaɓi ŋoppitto ngoon tan, wurtii. Tawi jemma naati. ");
INSERT INTO fuh_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Nde Yahuuda wurtinoo, Iisa wi'i : —Joonkay *Ɓii-Neɗɗo teddinaama, Alla duu teddinaama ngam makko. ");
INSERT INTO fuh_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Se Alla teddinaama ngam makko, Alla e hoore mum duu no teddinan mo. Alla teddinan mo jooni jooni. ");
INSERT INTO fuh_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Sukaaɓe am, no hoddanii kam wakkati seɗɗa mo ngondanmi he mooɗon. On tefan kam, amma hano no mbi'irnoomi mawɓe *Yahudankooɓe mbaawtaa yahde to pa'umi toon, non, onon duu, mbi'iranmi on ɗum jooni. ");
INSERT INTO fuh_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Miɗo hokka on tilsinoore heyre : Ngiɗodiree ! Hano no ngiɗirmi on nii, onon duu ngiɗodiree ! ");
INSERT INTO fuh_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Nde hidde no hakkune mooɗon, ɗum waɗan himɓe fuu anndita ko on *aahiiɓe am. ");
INSERT INTO fuh_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simon Piyer wi'i mo : —Joomam, toy njahataa ? Iisa jaabii mo wi'i : —To pa'umi toon, a waawtaa tokkude kam jooni. Amma yahde yeeso a tokkan kam ! ");
INSERT INTO fuh_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Piyer wi'i mo : —Joomam, ngam ɗume waɗi ko mi waawtaa tokkude ma joonin ? Mi siryake mursude yonki am sabu maaɗa. ");
INSERT INTO fuh_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Iisa jaabii, wi'i : —A siryake mursude yonki maa sabu am naa ? Goonga kaalananmaami : Fadde ndontoori jogginde, a wi'an a anndaa kam kile tati ! ");
INSERT INTO fuh_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Iisa wi'i *aahiiɓe mum : —To accee ɓerɗe mon mbona, ngoonɗinee Alla, ngoonɗinon kam, miin duu. ");
INSERT INTO fuh_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Cuuɗi ɗuɗɗi no nder hoggo *Baaba am. Mi yahan toon, mi siryanoo on nokkuure. Se hanaa goonga non, mi haalantaa on ɗum. ");
INSERT INTO fuh_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ndenne, nde mi siryanake on nokkuure, mi wartanan on, mi yaara on ngam to ngonmi fuu, ngonden. ");
INSERT INTO fuh_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Oɗon anndi laawol jehoowol to njahanmi toon. ");
INSERT INTO fuh_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Sey Tomas wi'i mo : —Joomam, min anndaa to njahataa. Noy min anndirta laawol ngol ? ");
INSERT INTO fuh_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Iisa jaabii mo wi'i : —Miin woni laawol, miin woni goonga, miin woni mbuurnam duu. Walaa jehoowo to *Baabiraawo se tokkiraay to am. ");
INSERT INTO fuh_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Se oɗon anndunoo kam, on anndannoo *Baaba am duu. Illa jooni oɗon anndi mo, on ngi'ii mo. ");
INSERT INTO fuh_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filipa wi'i mo : —Joomam, hollu min *Baabiraawo, ɗum ɗon tan heƴii min. ");
INSERT INTO fuh_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Iisa wi'i mo : —Filipa, no ɓooydirmi he mooɗon nii fuu, a anndaa kam naa ? A anndaa ko giiɗo kam fuu, hi'i *Baabiraawo naa ? Noy mbaawɗaa wi'ude hollu min *Baabiraawo ? ");
INSERT INTO fuh_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","A goonɗinaay ko miɗo hawti he *Baabiraawo, *Baabiraawo duu no hawti he am naa ? Haalaaji ɗi kaalanmi on ɗi fuu, ƴuwaay to am. *Baabiraawo gonduɗo he am, waɗata golle mum. ");
INSERT INTO fuh_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ngoonɗinee kam se mi wi'i : Miɗo hawti he *Baabiraawo, *Baabiraawo duu no hawti he am. Baa se on ngoonɗinaay haala am, ngoonɗinee ngam golle am. ");
INSERT INTO fuh_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Miɗo haalana on goonga : Neɗɗo fuu goonɗinɗo kam, no waɗan golleeji ɗi ngaɗumi ɗii. O waɗan baa ko ɓuri ɗi sabu mi yahan to *Baabiraawo. ");
INSERT INTO fuh_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Mi waɗanan on huune fuu ko eelirɗon innde am. Mi waɗan ɗum ngam *Baabiraawo teddinee sabu Ɓiɗɗo oon. ");
INSERT INTO fuh_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ko eelirɗon innde am fuu, mi waɗan ɗum. ");
INSERT INTO fuh_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","—Se oɗon ngiɗi kam, on tokkan tilsinooje am. ");
INSERT INTO fuh_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Mi ŋaaroto *Baabiraawo hokka on Balloowo gom. O wondan he mooɗon faa abada. ");
INSERT INTO fuh_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Kanko woni *Ruuhu goonga. Duuniyaaru nduu waawtaa jaɓude mo, ngam ndu hi'ataa mo, ndu anndaa mo. Amma onon, oɗon anndi mo sabu omo jooddii he mooɗon, o wondan he mooɗon. ");
INSERT INTO fuh_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Mi accataa on, onon tan hano alatuumi'en, mi wartanan on. ");
INSERT INTO fuh_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Se ɓooyii seɗɗa duuniyaaru nduu hi'ataa kam. Amma onon, on ngi'an kam, sabu mi buurɗo, onon duu on mbuuran. ");
INSERT INTO fuh_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Nyannde mum on paaman ko miɗo hawti he *Baabiraawo, oɗon kawti he am, miɗo hawti he mooɗon. ");
INSERT INTO fuh_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Annduɗo tilsinooje am, nden golliri ɗe, kam woni giɗɗo kam. Giɗɗo kam, *Baaba am hiɗan ɗum. Miin duu, mi hiɗan mo, mi wannganan mo. ");
INSERT INTO fuh_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Nden Yahuuda, mo hanaa Yahuuda Iskariyot, wi'i Iisa : —Joomam, noy ɗum laatorto mbannganaa min, tawee a wanngantaa duuniyaaru fuu ? ");
INSERT INTO fuh_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Iisa jaabii mo wi'i : —Giɗɗo kam fuu no golliran haala am, *Baaba am duu hiɗan ɗum. Miin e *Baabiraawo, min ngardan to joomum, min cinnga jooɗorɗe amin to makko. ");
INSERT INTO fuh_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Neɗɗo fuu mo hiɗaa kam, gollirta haala am. Haala ka nanoton kaa ƴuwaay to am, amma ka ƴuwaana to *Baabiraawo lilɗo kam. ");
INSERT INTO fuh_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Ɗum fuu, mi haalanii on ɗum, illa miɗo wondi he mooɗon. ");
INSERT INTO fuh_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Balloowo oon, woni *Ruuhu Ceniiɗo, mo *Baabiraawo lildanta on dow innde am, kanko anndinta on kujje fuu. O miccintinan on ko kaalannoomi on fuu. ");
INSERT INTO fuh_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Jam accidanmi on, mi hokkan on jam am. Hanaa hano no duuniyaaru nduu hokkirta on, kokkiranmi on. To hakkillo mon ummoo, to kulee. ");
INSERT INTO fuh_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","On nanii nii ko mbi'umi on : Mi yahan, mi wartan to mooɗon. Se oɗon ngiɗunoo kam, on mbelnan dow jaaki am to *Baabiraawo, sabu kanko ɓuri kam manngu. ");
INSERT INTO fuh_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Too, miɗo haalana on joonin, illa ɗum waraay ginan, ngam se ɗum warii, ngoonɗinon. ");
INSERT INTO fuh_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Gaɗa hannden mi haaldataa he mooɗon sanne, sabu Ibiliisa laamiiɗo duuniyaaru no wara. O waawanaa kam baafuy. ");
INSERT INTO fuh_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Amma sey duuniyaaru nduu annda ko miɗo hiɗi *Baabiraawo, ndu annda duu ko miɗo waɗa ko *Baabiraawo tilsini kam. Ummee, ndillen ɗo. ");
INSERT INTO fuh_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","—Miin woni cabiihi goongaahi, *Baabiraawo woni demoowo ngesa cabiije. ");
INSERT INTO fuh_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Liccal am ngal rimataa fuu, o taƴan ngal. Dimoowal fuu, o saltoto ngal, ngam ngal ɓeyda rimude. ");
INSERT INTO fuh_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Onon, jooni jaati laaɓuɗon sabu waaju mo ngaɗanmi on. ");
INSERT INTO fuh_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Kawtee he am, miin duu mi hawtan he mon. Liccal fuu waawtaa rimde feere mum nde ngal sinngaaki he cabiihi kiin, hano non, onon duu on mbaawtaa waɗude ko woodi barke se on kawtaay he am. ");
INSERT INTO fuh_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Miin woni cabiihi kiin, onon ngoni licce ɗeen. Se neɗɗo hawti he am, miin duu mi hawtan he mum, o waɗan ko ɗuuɗi ko woodi barke. Sabu on mbaawtaa waɗude baafuy se ɗum ƴuwaay to am. ");
INSERT INTO fuh_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Mo hawtaay he am, no faɗɗetee nder ladde hano liccal jorngal. Licce joorɗe ɗeen no kawretee, paɗɗee nder hiite, mbulee. ");
INSERT INTO fuh_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Se on kawti he am, se waaju am duu no duumii nder mon, nden kay ko ƴamuɗon fuu, on keɓan. ");
INSERT INTO fuh_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Se on ngaɗi ko ɗuuɗi ko woodi barke, ɗum hollan ko on laatake *aahiiɓe am. Ndenne *Baaba am teddinaama. ");
INSERT INTO fuh_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Hano no *Baabiraawo hiɗiri kam nii, hano non ngiɗirmi on. Kawtee nder hidde am. ");
INSERT INTO fuh_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Se on tokkii tilsinooje am, on kawtan nder hidde am, hano no kawtirmi nder hidde *Baaba am nii, ngam mi tokki tilsinooje makko. ");
INSERT INTO fuh_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Mi haalanii on ɗum ngam welwelo am jooɗo nder mon, nden welwelo mon duu huuɓa. ");
INSERT INTO fuh_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Tilsinoore am woni ngiɗodiron hano no ngiɗirmi on nii. ");
INSERT INTO fuh_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Walaa hidde fotune neɗɗo sotta yonki mum ngam higiraaɓe mum. ");
INSERT INTO fuh_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Se on ngaɗii ko tilsinmi on, onon ngoni higiraaɓe am. ");
INSERT INTO fuh_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Mi yeeƴataako mi noddira on maccuɓe kaden, sabu maccuɗo anndaa ko joomum waɗata. Amma mi noddiran on higiraaɓe sabu mi anndinii on ko narrumi *Baaba am fuu. ");
INSERT INTO fuh_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Hanaa onon cuɓii kam, amma miin suɓii on. Mi lilii on faa njehon, ngaɗon ko woodi barke, barke mon duu duumoo. Nden *Baabiraawo hokkan on ko ŋaariɗon mo fuu nder innde am. ");
INSERT INTO fuh_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ndenne, ko tilsinanmi on woni ngiɗodiron. ");
INSERT INTO fuh_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","—Se duuniyaaru nduu wanyii on, anndee ko miin ndu artii wanyude. ");
INSERT INTO fuh_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Se nii on laatakeno ɓe duuniyaaru, duuniyaaru hiɗanno ko jeyi. Amma on njeyaaka he mayru. Miin suɓii on, senndi on he duuniyaaru nduu. Ngam majjum waɗi ndu wanyi on. ");
INSERT INTO fuh_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Miccitee ko mbi'unoomi on : « Maccuɗo ɓurataa joomum. » Se ɓe torrii kam, ɓe torran on, onon duu. Se ɓe njogake haala am, ɓe njogoto haalaaji mooɗon. ");
INSERT INTO fuh_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Amma kujje ɗee fuu, ɓe ngaɗan on ɗe sabu innde am, ngam ɓe anndaa lilɗo kam. ");
INSERT INTO fuh_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Nde mi waraayno kaaldumi he maɓɓe, hakkeeji maɓɓe limataakeno. Amma jooni ɓe ngalaa no ɓe kisirta hakkeeji maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Banyuɗo kam fuu wanyii *Baabiraawo duu. ");
INSERT INTO fuh_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Nde mi waɗaayno golleeji ɗi neɗɗo fuu meeɗaay waɗude hakkune maɓɓe, hakkeeji maɓɓe limataakeno. Amma jooni ɓe ngi'ii ɗi, ɗi fuu, baa ko non waɗi, ɓe accaay wanyude kam, miin e *Baabiraawo. ");
INSERT INTO fuh_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Amma ɗum waɗi ngam humnude ko winndaano nder *Tawreeta maɓɓe, wi'aa : Ɓe mbanyii kam ngam meere. ");
INSERT INTO fuh_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Nde Balloowo mo lildanmi on warii, kanko woni *Ruuhu goonga ƴuwoowo to *Baabiraawo, kanko seedantoo kam. ");
INSERT INTO fuh_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Onon duu, on ceedanto kam sabu oɗon ngondi he am illa fuɗɗorde. ");
INSERT INTO fuh_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","—Mi haalanii on ɗum fuu ngam to on pergo. ");
INSERT INTO fuh_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ɓe ndiiwan on nder *baajorɗi. Wakkati waran, ko barɗo on fuu miilan waɗi ko Alla hiɗi. ");
INSERT INTO fuh_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ɓe ngaɗan non sabu ɓe anndaa *Baabiraawo, ɓe anndaa kam, miin duu. ");
INSERT INTO fuh_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Mi haalanii on ɗum, ngam nde wakkati oon wari, miccitoɗon ko mi haalaniino on ɗum. —Mi haalanaay on kujje ɗee illa arannde sabu miɗo wondunoo he mooɗon. ");
INSERT INTO fuh_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Joonin miɗo ɗon miɗo hoota to liluɗo kam oon, dey baa gooto nder mooɗon ƴamataa kam to njahanmi. ");
INSERT INTO fuh_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Amma ɓerɗe mooɗon metti ngam mi haalanii on kujje ɗee fuu. ");
INSERT INTO fuh_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Amma nder ɗum fuu, miɗo haalana on goonga, yahdu am ɓuri wooɗande on. Nde mi yahaay, Balloowo oon warataa to mooɗon. Amma nde mi yehi, mi lildanan on mo. ");
INSERT INTO fuh_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Nde o warii, o faamtinan himɓe duuniyaaru nduu ko ɓe mboofi har ko daarta hakke, foccitaare e kiite. ");
INSERT INTO fuh_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Har ko daarta hakke, ɓe mboofi ngam ɓe ngoonɗinaay kam. ");
INSERT INTO fuh_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Har ko daarta foccitaare, ɓe mboofi ngam ɓe paamaay coƴƴitaaki am to *Baabiraawo kolloohi foccitaare am. On ngi'ataa kam kaden. ");
INSERT INTO fuh_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Har ko daarta kiite, ɓe mboofi ngam ɓe paamaay ko Ibiliisa laamiiɗo duuniyaaru re'i hiitaama. ");
INSERT INTO fuh_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Miɗo woodi kujje ɗuɗɗe ɗe kaalananmi on, amma on mbaawtaa faamude ɗe joonin. ");
INSERT INTO fuh_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Wakkati *Ruuhu goonga oon wari, o ɗowan on nder goonga oon fuu, ngam o haaldataa he muuyo hoore makko, amma o haalanan on ko o nani, o wannginanan on ko warata fuu. ");
INSERT INTO fuh_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","O haalanan on ko o nani to am fuu, hano non o wannginirta teddungal am. ");
INSERT INTO fuh_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ko *Baaba am jeyii fuu, miin jeyii, ngam majjum waɗi mbi'umi ko *Ruuhu goonga oon no faaminan on ko o nani to am fuu. ");
INSERT INTO fuh_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","—Nder wakkati seɗɗa on ngi'ataa kam, nder wakkati seɗɗa kaden on ngi'an kam. ");
INSERT INTO fuh_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Gere nder *aahiiɓe makko ƴamodiri, mbi'i : —Ɗume woni maana haala makko kaa : « Nder wakkati seɗɗa on ngi'ataa kam, nder wakkati seɗɗa kaden on ngi'an kam ? » E ko o wi'i : « Ngam mi yahan to *Baabiraawo ? » ");
INSERT INTO fuh_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ɓe mbi'odiri : —Ɗume woni maana haala kaa : « Nder wakkati seɗɗa »  ? Min paamaay ko ɗum hiɗi wi'ude ɗo. ");
INSERT INTO fuh_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Iisa faami iɓe ngiɗi ƴamude ɗum, wi'i ɓe : —Oɗon ƴamodira maana haala am kaa : « Nder wakkati seɗɗa on ngi'ataa kam, nder wakkati seɗɗa kaden on ngi'an kam. » ");
INSERT INTO fuh_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Miɗo haalana on goonga : Onon, on mboyan, on mboytoto, tawaa duuniyaaru nduu no nder welwelo. Ɓerɗe mon no mettan, amma mettal ɓerɗe mooɗon no waylititto welwelo. ");
INSERT INTO fuh_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Nde ŋatawere caawɗo yottake, o nanan naawɗum sanne ngam wakkati torra makko wari. Amma nde o rimii, o yeggitan torra makko, o welnan ngam cukalel kesel naati duuniyaaru. ");
INSERT INTO fuh_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Onon duu hano non nanirton naawɗum jooni, amma en ngiidowan. Wakkati mum, on nanan belɗum, kaden walaa baawɗo ittude welwelo mooɗon. ");
INSERT INTO fuh_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Nyannde mum, on ƴamataa kam dow baafuy. Miɗo haalana on goonga, ko ŋaariɗon *Baabiraawo dow innde am fuu on kokketee. ");
INSERT INTO fuh_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Faa joonin, walaa fuu ko eeluɗon dow innde am. Ŋaaree, on keɓan ngam welwelo mooɗon huuɓa. ");
INSERT INTO fuh_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","—Ko kaalanmi on ɗum fuu nder haala kippaaka kaalirmi ɗum. Amma wakkati waran ko mi hippataa haala, no laaɓiri kaalirananmi on dow *Baabiraawo. ");
INSERT INTO fuh_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Nyannde mum on ŋaaroto *Baabiraawo he innde am. Mi wi'aay mi ŋaaranto on *Baabiraawo, ");
INSERT INTO fuh_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","ngam *Baabiraawo he hoore mum no hiɗi on. Omo hiɗi on sabu oɗon ngiɗi kam, on ngoonɗinii to Alla ƴuwumi. ");
INSERT INTO fuh_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Mi ƴuwii to *Baabiraawo, mi warii nder duuniyaaru. Jooni duu mi accan duuniyaaru mi soƴƴoo to *Baabiraawo. ");
INSERT INTO fuh_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Sey *aahiiɓe makko mbi'i mo : —Joonkay, a haalii faa laaɓii, a acci hippude haalaaji maa. ");
INSERT INTO fuh_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Joonin miɗen anndi ko walaa fuu ko suuɗanii ma, sabu aɗa anndi ko neɗɗo ƴamata illa o ƴamaay ma. Ɗum waɗi min ngoonɗini ko a ƴuwɗo to Alla. ");
INSERT INTO fuh_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Iisa jaabii ɓe wi'i : —Joonkay ! On ngoonɗinii naa ? ");
INSERT INTO fuh_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Too, wakkati no wara, wakkati oon yottake, nde on fuu on cankitoto, neɗɗo fuu dogga hoota wuro mum, joofon kam, miin tan. Amma mi wonaa miin tan, sabu *Baabiraawo no wondi he am. ");
INSERT INTO fuh_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Mi haalanii on ɗum, ngam keɓon jam nder kawtal mooɗon he am. Oɗon ngondi he torra nder duuniyaaru. Amma cemmbiɗee, sabu mi jaalake duuniyaaru. ");
INSERT INTO fuh_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Wakkati Iisa laaɓinani *aahiiɓe mum to fa'i, sey o tiggitii kammu, o wi'i : —*Baabiraawo, wakkati oo yonii, wanngin teddungal Ɓiya, faa Ɓiya duu wanngina teddungal maa. ");
INSERT INTO fuh_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","A hokkii mo baawɗe dow himɓe fuu, ngam o hokka, ɓe kokkuɗaa mo fuu mbuurnam nduumiiɗam. ");
INSERT INTO fuh_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Mbuurnam nduumiiɗam woni ɓe annde, aan Alla gooto goongaajo, ɓe annda mo lilɗaa oon duu, Iisa *Almasiihu. ");
INSERT INTO fuh_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Mi teddinii ma nder duuniyaaru, mi humnii golle ɗe kokkuɗaa kam mi golla. ");
INSERT INTO fuh_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Joonkay, *Baabiraawo, teddinam teddungal ngal ngoodunoomi to maaɗa illa duuniyaaru tagaaka. ");
INSERT INTO fuh_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Mi wannginii ma to himɓe duuniyaaru ɓe kokkuɗaa kam. Aan jeynoo ɓe, a hokkii kam ɓe. Ɓe tokki haala maa. ");
INSERT INTO fuh_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Joonkay, ɓe anndii ko kokkuɗaa kam fuu, to maaɗa ɗum ƴuwi. ");
INSERT INTO fuh_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Mi yottinanii ɓe haala ka kaalanɗaa kam kaan. Ɓe njaɓi ka, ɓe tabbitinii ko to maaɗa ƴuwumi, ɓe ngoonɗinii aan lili kam. ");
INSERT INTO fuh_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ngam maɓɓe ndu'otoomi. Mi du'ataako ngam duuniyaaru nduu. Amma miɗo du'oo ngam ɓe kokkuɗaa kam ɓee, sabu aan jeyii ɓe. ");
INSERT INTO fuh_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Huune fuu ko njeymi, aan jeyii ɗum, huune fuu ko njeyɗaa, miin jeyii ɗum. Teddungal am wanngi hakkune maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Mi jooɗotaako nder duuniyaaru, mi wartan to maaɗa. Amma kamɓe, iɓe nder duuniyaaru. Aan *Baabiraawo Ceniiɗo, reenir ɓe innde maaɗa nde kokkuɗaa kam, ngam ɓe laatoo gooto hano no laatoriɗen gooto. ");
INSERT INTO fuh_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Wakkati ngondunoomi he maɓɓe nder duuniyaaru, mi reenirii ɓe innde nde kokkuɗaa kam. Mi reenii ɓe, baa gooto halkaay se hanaa kalkuɗo ngam ko sappaa wi'aa nder dewte ɗum huuɓaa. ");
INSERT INTO fuh_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Joonkay miɗo fa'i to maa. Miɗo haala haalaaji ɗii illa miɗo nder duuniyaaru ngam welwelo am heewa nder ɓerɗe maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Mi haalanii ɓe haala maa. Amma duuniyaaru wanyii ɓe, sabu ɓe njeyaaka nder duuniyaaru, hano no mi jeyiraaka nder duuniyaaru nii. ");
INSERT INTO fuh_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Mi ŋaaraaki mburtinaa ɓe nder duuniyaaru, amma miɗo eela ndeenaa ɓe e bonɗo. ");
INSERT INTO fuh_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ɓe njeyaaka nder duuniyaaru, hano no mi jeyiraaka nder duuniyaaru nii. ");
INSERT INTO fuh_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Haala maa woni goonga. Ndenne, senɗinir ɓe goonga oon. ");
INSERT INTO fuh_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Hano no lilirɗaa kam nder duuniyaaru nii, non miin duu lilirmi ɓe nder duuniyaaru. ");
INSERT INTO fuh_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Miin e hoore am mi hokkii ma hoore am ngam kamɓe duu ɓe kokka ko'e maɓɓe nder goonga. ");
INSERT INTO fuh_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Hanaa sabu maɓɓe tan ndu'otoomi. Amma miɗo du'oo duu sabu goonɗinɓe kam har waaju maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","*Baabiraawo, miɗo eela ngam ɓe laatoo gootum. Ɓe kawta e meeɗen hano no kawtirɗaa he am, e no kawtirmi he maa. Ɓe fuu ɓe laatoo gootum heɓa duuniyaaru goonɗina aan lili kam. ");
INSERT INTO fuh_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Miin, mi hokkii ɓe teddungal ngal kokkuɗaa kam, ngam ɓe laatoo gootum, hano no laatoriɗen gootum nii. ");
INSERT INTO fuh_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Miɗo wondi he maɓɓe, aɗa wondi he am, ngam ɓe laatoo gootum, faa duuniyaaru annda ko aan lili kam. Aɗa hiɗi ɓe duu hano no ngiɗirɗaa kam nii. ");
INSERT INTO fuh_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","*Baabiraawo, miɗo hiɗi ɓe kokkuɗaa kam ɓeen tawee to ngonmi fuu ngam ɓe ngi'a teddungal ngal kokkuɗaa kam ngaal, sabu a hiɗii kam illa duuniyaaru diidaaka. ");
INSERT INTO fuh_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","*Baabiraawo dartiiɗo, duuniyaaru anndaa ma, amma miin kay miɗo anndii ma, ɓeeɗo duu anndii aan lili kam. ");
INSERT INTO fuh_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Mi anndinii ɓe ma. Mi anndinan ɓe ma kaden ngam hidde nde ngiɗirɗaa kam tawee nder maɓɓe, miin duu mi wonda he maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Gaɗa du'aa'u oo, Iisa yahdi he *aahiiɓe mum gaɗa gooruwol bi'eteengol Kedoron. Toon no woodi koogol gom, o naddi he *aahiiɓe makko nder maggol. ");
INSERT INTO fuh_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yahuuda jammbotooɗo mo oon no anndi nokkuure ndee, sabu Iisa e *aahiiɓe mum no mboowi yahde toon. ");
INSERT INTO fuh_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Yahuuda ardii oorngal soogeeji e dogariiɓe ƴuwɓe to *cakkanooɓe Alla e *Fariisa'en gom. Ɓe naati koogol ngool, iɓe njogii yulbaaji, fitillaaji e kaɓirɗe. ");
INSERT INTO fuh_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Tawi Iisa no anndi huune fuu ko heɓata ɗum, taɓɓitii ɓe, wi'i : —Moy tefoton ? ");
INSERT INTO fuh_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ɓe njaabii mo, ɓe mbi'i : —Iisa mo Nasaratu. Nden o wi'i ɓe : —Miin non ! Yahuuda jammbotooɗo mo oon no dardii he maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Nde Iisa wi'unoo « Miin non ! » Ɓe coƴƴorii gaɗa, ɓe caami e leydi. ");
INSERT INTO fuh_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Iisa ƴamii ɓe kaden wi'i : —Moy tefoton ? Ɓe njaabii, ɓe mbi'i : —Iisa mo Nasaratu. ");
INSERT INTO fuh_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Iisa jaabii ɓe wi'i : —Mi wi'i on, miin non. Se miin tefoton, accee himɓe am kay ndilla. ");
INSERT INTO fuh_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Noon ɗum laatorii ngam haala Iisa kaa tabbita : « Walaa kalkuɗo nder ɓe kokkuɗaa kam ɓeen. » ");
INSERT INTO fuh_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Nden Simon Piyer no joginoo takubaahi gom, sorti ki, soppi Malkus gollanoowo mawɗo *cakkanooɓe Alla gom, taƴi nowru makko nyaamo. ");
INSERT INTO fuh_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Sey Iisa wi'i Piyer : —Wattu takubaahi maa nder hulgo mum. No tilsi mi yara nyeɗerde torra nde *Baabiraawo fodanii kam. ");
INSERT INTO fuh_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Oorngal soogeeji e hooreejo mum, kam e dogariiɓe *Yahudankooɓe nanngi Iisa, kaɓɓi mo. ");
INSERT INTO fuh_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ɓe artii yaarude mo to Annas, esoo Kayafas. Nder hitaane ndeen, Kayafas woni mawɗo *cakkanooɓe Alla fuu. ");
INSERT INTO fuh_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayafas faamtiniino mawɓe *Yahudankooɓe ko no ɓuri wooɗude, neɗɗo gooto maayana himɓe fuu. ");
INSERT INTO fuh_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simon Piyer e aahiijo gom tokki Iisa. Ko nii waɗi mawɗo *cakkanooɓe Alla oon no anndi aahiijo oon, sey aahiijo oon naddi he Iisa nder hoggo mawɗo *cakkanooɓe Alla oon. ");
INSERT INTO fuh_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Amma Piyer darii dammbugal ɓaade ndeen. Aahiijo anndaaɗo oon, wurtii haaldi he korɗo deenoowo dammbugal oon, nden debbo oon acci Piyer naati hoggo ngoon. ");
INSERT INTO fuh_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Korɗo deenoowo oon wi'i mo : —Aan nee, a hanaa gooto nder *aahiiɓe gorko oo naa ? Piyer jaabii mo : —Mi hanaa ! ");
INSERT INTO fuh_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Tawi jaaŋol waɗi. Gollooɓe e dogariiɓe ɓeen kuɓɓi hiite no ƴilfoo. Piyer duu darii hadde maɓɓe no ƴilfoo. ");
INSERT INTO fuh_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Mawɗo *cakkanooɓe Alla fuu ƴamii Iisa dow *aahiiɓe mum e dow ko o waajotoo. ");
INSERT INTO fuh_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Iisa jaabii mo : —Mi wannginanii duuniyaaru nduu fuu waaju am. Mi waajake nder cuuɗi *baajorɗi e nder *Juulirde mawne to *Yahudankooɓe kawrata nyannde fuu. Walaa fuu ko kaalumi nder cuccukka. ");
INSERT INTO fuh_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ko saabii aɗa ƴama kam ? Ƴamu hettinaniiɓe kam ko kaalannoomi ɓe. Iɓe anndi ko kaalumi. ");
INSERT INTO fuh_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Wakkati o wi'unoo nii, gooto nder dogariiɓe ɓeen no darii ɗon feenyii Iisa wi'i : —Nii nootortoɗaa mawɗo *cakkanooɓe Alla naa ? ");
INSERT INTO fuh_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Iisa jaabii mo : —Se ko boni kaalumi, haalu ko bonni ko kaalumi. Se tawi ko wooɗi kaalumi, ɗume piyanɗaa kam ? ");
INSERT INTO fuh_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Nden Annas lildi mo to Kayafas mawɗo *cakkanooɓe Alla fuu gom, tawi omo haɓɓii. ");
INSERT INTO fuh_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simon Piyer no ƴilfoo toon, sey ɓe mbi'i mo : —Aan, a gooto nder *aahiiɓe makko naa ? Piyer yeddi, wi'i : —Mi hanaa ! ");
INSERT INTO fuh_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Gooto nder gollooɓe mawɗo *cakkanooɓe Alla fuu, sakiike mo Piyer taƴunoo nowru mum oon, wi'i mo : —Mi hiidaayno ma he makko too nder koogol naa ? ");
INSERT INTO fuh_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Piyer yeddi kaden. Wakkati mum da, ndontoori joggini. ");
INSERT INTO fuh_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Jaangoore mum illa subaka kecco ɓe itti Iisa to Kayafas, ɓe njaari mo hoggo Pilaatus, kawjotooɗo leydi Yahudiya. Yaaruɓe mo ɓeen naataay hoggo ngoon ngam to ɓe tunnin ko'e maɓɓe, ɓe kaɗee nyaamude nyaamdu *Juulɗe dimɗinol Isra'ilankooɓe nduun. ");
INSERT INTO fuh_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Pilaatus yehi tawowi ɓe yaasin, wi'i : —Ɗume pelirton gorko oo ? ");
INSERT INTO fuh_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ɓe njaabii mo ɓe mbi'i : —Se nii o gollataano ko boni, min ngaddataano mo to maa. ");
INSERT INTO fuh_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Sey Pilaatus wi'i ɓe : —Njaaree mo, kiitoroɗon mo *Tawreeta mooɗon. Nden ɓe mbi'i mo : —Min kokkaaka laawol hiitanaade goɗɗo kiite maayde. ");
INSERT INTO fuh_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ɗum tabbintini haala ka Iisa wi'unoo wakkati o haalunoo dow no o maayirta. ");
INSERT INTO fuh_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilaatus soƴƴii nder hoggo mum, noddi Iisa, wi'i mo : —Aan, a laamiiɗo *Yahudankooɓe naa ? ");
INSERT INTO fuh_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Iisa jaabii mo wi'i : —Haala kaa he becce maa ittuɗaa ka naa woɓɓe narruɗaa ka ? ");
INSERT INTO fuh_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilaatus jaabii mo wi'i : —Miin, mi Yahudanke naa ? Himɓe lenyol maa e mawɓe *cakkanooɓe Alla ngaddi ma to am. Ɗume ngaɗɗaa ? ");
INSERT INTO fuh_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Iisa jaabii wi'i : —Laamu am hanaa laamu duuniyaaru. Se nii ngu laamu duuniyaaru, *aahiiɓe am no kaɓan ngam to mi naatu juuɗe mawɓe *Yahudankooɓe. Amma jooni laamu am hanaa laamu ɗo non. ");
INSERT INTO fuh_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Nden Pilaatus wi'i mo : —Ndenne, a laamiiɗo naa ? Iisa jaabii mo wi'i : —Aan wi'i ka. Ngam majjum ndimaami, mi warii nder duuniyaaru ngam mi seedanoo goonga. Giɗɗo goonga fuu, nanan haala am. ");
INSERT INTO fuh_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilaatus ƴami mo : —Ɗume woni goonga ? Nden Pilaatus wurtii kaden, o tawowi mawɓe *Yahudankooɓe ɓeen yaasin, o wi'i ɓe : —Mi heɓaay feloore baa worre nde nanngiranmi gorko oo. ");
INSERT INTO fuh_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Oɗon mboowi *Juulɗe dimɗinol Isra'ilankooɓe fuu mi yoofana on kasunke gooto. Oɗon ngiɗi mi yoofana on laamiiɗo *Yahudankooɓe naa ? ");
INSERT INTO fuh_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Sey ɓe puɗɗi huuɓude, iɓe mbi'a : —Hanaa kanko, Barabas. Tawi Barabas nee no murtuɗo he gomnati. ");
INSERT INTO fuh_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pilaatus tilsini Iisa ɓoccowee. ");
INSERT INTO fuh_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Soogeeji canyi taarde gi'e, kippi dow hoore makko. Ɓe ngattani mo alkubbaare woɗeere. ");
INSERT INTO fuh_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ɓe ɓadii mo, iɓe mbi'a : —Alla sabbinane, laamiiɗo *Yahudankooɓe ! Iɓe peenya mo. ");
INSERT INTO fuh_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilaatus wurtii kaden, wi'i *Yahudankooɓe ɓeen : —Mi wurtinanan on mo, ngam anndon mi heɓaay feloore fuu nde nanngiranmoomi. ");
INSERT INTO fuh_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Iisa wurtii taarde gi'e no hippaa dow hoore mum. Omo watti alkubbaare woɗeere. Pilaatus wi'i ɓe : —Ndaaree neɗɗo oo ! ");
INSERT INTO fuh_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Wakkati mawɓe *cakkanooɓe Alla e dogariiɓe ɓeen ngi'unoo mo, ɓe kuuɓi ɓe mbi'i : —Tontu mo ! Tontu mo dow *bardugal ! Nden Pilaatus wi'i ɓe : —Nanngee mo onon, tonton mo, sabu miin kay, mi heɓaay feloore e makko. ");
INSERT INTO fuh_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","*Yahudankooɓe njaabii mo mbi'i : —Nder *Tawreeta amin, omo haani wareede, sabu o adi hoore makko *Ɓii-Alla. ");
INSERT INTO fuh_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Nde Pilaatus nanunoo haala kaa, o ɓeydi hulude. ");
INSERT INTO fuh_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","O naati nder ɓaade, o wi'i Iisa : —Aan, toy ƴuwɗaa ? Iisa jaabaaki mo baa. ");
INSERT INTO fuh_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Nden Pilaatus wi'i mo : —A jaabataako kam naa ? Tawte a anndaa ko miɗo woodi baawɗe yoofude ma, e baawɗe tontude ma naa ? ");
INSERT INTO fuh_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Iisa jaabii mo wi'i : —Walaa fuu ko mbaawanɗaa kam, se hanaa ko fodaa ɗum. Sabu gattuɗo kam nder junngo maa oon, ɓuri ma waɗude hakke. ");
INSERT INTO fuh_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Illa wakkati oo, Pilaatus no tefa yoofude mo. Amma *Yahudankooɓe no kuuɓa, no mbi'a : —Se nii a yoofii mo, a hanaa giɗo laamiiɗo *Rooma mawɗo. Sabu aduɗo hoore mum laamiiɗo fuu, no ganyo laamiiɗo *Rooma mawɗo. ");
INSERT INTO fuh_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Illa wakkati Pilaatus nanunoo haalaaji ɗii, o wurtini Iisa, o jooɗii dow jooɗorgal kiitotooɗo nder nokkuure wi'eteene « Hayre seɓaane », nokkuure inndirteene « Gabbata » nder ibrankoore. ");
INSERT INTO fuh_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Nyalaane fadde *Juulɗe dimɗinol Isra'ilankooɓe waɗa, har caka nyalooma, Pilaatus wi'i *Yahudankooɓe : —Laamiiɗo mooɗon nii ! ");
INSERT INTO fuh_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ɓe kuuɓi ɓe mbi'i : —Waru mo ! Waru mo ! Tontu mo dow *bardugal ! Pilaatus jaabii wi'i : —Mi tonta laamiiɗo mooɗon naa ? Mawɓe *cakkanooɓe Alla mbi'i : —Min ngalaa laamiiɗo se hanaa laamiiɗo *Rooma mawɗo ! ");
INSERT INTO fuh_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Nden o watti Iisa nder juuɗe maɓɓe ngam tontowee dow *leggal bardugal. Soogeeji nanngi Iisa. ");
INSERT INTO fuh_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Iisa wurtii no ronndii *leggal mum bardugal. Ɓe paadi mo gaɗa wuro toon to wi'etee nder ibrankoore Golgota naa mbi'en Laalagal hoore. ");
INSERT INTO fuh_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Toon ɓe tontidi mo himɓe ɗiɗo gom : Oo no nano, ooto no nyaamo Iisa. ");
INSERT INTO fuh_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilaatus waɗi ɗum winndaa dow alluwal : « Iisa mo Nasaratu, Laamiiɗo *Yahudankooɓe », o tilsini ngal takkee dow *leggal bardugal ngaal. ");
INSERT INTO fuh_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ɗuɓɓe nder *Yahudankooɓe njanngi binndi ndii sabu to Iisa tontaa toon woɗɗaa wuro ngoon. Alluwal ngaal winndaama nder ibrankoore, romankoore e gerekankoore. ");
INSERT INTO fuh_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Mawɓe *cakkanooɓe Alla mbi'i Pilaatus : —Taa winndu « O laamiiɗo *Yahudankooɓe », amma winndu : « Kanko wi'i o laamiiɗo *Yahudankooɓe. » ");
INSERT INTO fuh_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilaatus jaabii ɓe wi'i : —Ko mbinndumi ɗum, winndake. ");
INSERT INTO fuh_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Nde soogeeji ɗiin kantunoo tontude Iisa, ɗi cenndi kolte makko cenndanɗe nay, neɗɗo fuu hooƴi mbaka mum. Ɓe adi jabbaare makko ngaɗiraane lefol gootol, jabbaare ndee walaa nyoogol illa dow faa ley. ");
INSERT INTO fuh_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Soogeeji ɗiin kaaldi, potti, mbi'i : —To en cerku nde. En piya nde caaca, ƴeewen nyaamoowo nde. Ɓe ngaɗi non ngam humnude ko sappanoo nder dewte mbi'u ɗum : Ɓe cenndii kolte am hakkune maɓɓe, ɓe piyi jabbaare am caaca. Nii soogeeji ɗiin ngaɗi. ");
INSERT INTO fuh_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Inna Iisa e minyum debbo, Mariyaama dee-Kolopas e Mariyaama mo Magdaala no ndarii hadde leggal, ngal Iisa tontaa dow mum ngaal. ");
INSERT INTO fuh_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Iisa hi'i innum e aahiijo mo o hiɗi oon no ndardii. O wi'i inniiko : —Inna, ɓiya nii ! ");
INSERT INTO fuh_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Gaɗa mum, o wi'i aahiijo oon : —Inna maa nii. Illa nyannde mum, aahiijo oo yaari Mariyaama wuro mum. ");
INSERT INTO fuh_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Gaɗa ko Iisa anndii walaa fuu ko hoddi, ngam ko wari nder dewte ɗum tabbita, o wi'i : —Mi ɗomɗii. ");
INSERT INTO fuh_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Loone heewne ndiyam lammuɗam no wonnoo toon. Sey ɓe cuuwi tekkere nder ndiyam lammuɗam ɗam, ɓe kaɓɓi e loocol isop, ɓe ngaddi nde hadde hunnduko Iisa. ");
INSERT INTO fuh_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Wakkati Iisa siiɓinoo ndiyam lammuɗam ɗaam, wi'i : —Ɗum hanti ! O turni hoore, o foofi foofaango makko sakitiingo. ");
INSERT INTO fuh_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Tawi nyalaane siri juulɗe non. *Yahudankooɓe ngiɗaa ɓalli tontaaɓe ɓeen tawee dow leɗɗe ɗeen nder *nyalaane fowteteene, sabu nyalaane ndee no teddi sanne. Ɗum waɗi, ɓe ƴamii Pilaatus koyɗe tontaaɓe ɓeen kelee, ɓe kooƴee. ");
INSERT INTO fuh_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Soogeeji ɗiin ngari, keli koyɗe worɓe ɗiɗo tontidaaɓe he Iisa ɓeen. ");
INSERT INTO fuh_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Amma wakkati ɓe njottinoo to Iisa, ɓe tawi o maayi, ngam majjum waɗi, ɓe kelaay koyɗe makko. ");
INSERT INTO fuh_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Amma gooto nder soogeeji ɗiin yuwi Iisa nder wuttudu. Wakkati mum da ƴiiƴam e ndiyam ili. ");
INSERT INTO fuh_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ceediiɗo kujje ɗee hi'i ɗe, seedanake goonga. O haalii goonga ngam onon duu ngoonɗinon. ");
INSERT INTO fuh_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ɗum fuu waɗii ngam ko sappaa nder dewte ɗee huuɓa : Baa gi'al makko gootal helataake. ");
INSERT INTO fuh_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Aayaare gom duu wi'i : Ɓe ndaaran mo ɓe njuwi oon. ");
INSERT INTO fuh_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Gaɗa mum, Yusufu mo Arimatiya, kam duu no aahiijo Iisa nder cuccukka ngam omo hulanno *Yahudankooɓe, o ƴamii Pilaatus hokka mo ɓanndu Iisa. Pilaatus jaɓii, Yusufu wari hooƴi ndu. ");
INSERT INTO fuh_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodemu, artunooɗo yahde to Iisa nder jemma, kam duu wari waddi ɗakke uurɗe kawrodiraaɗe he leɗɗe uurɗe, ko waɗata kilooji woronja. ");
INSERT INTO fuh_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ɓe kooƴi ɓanndu Iisa, ɓe piili ndu leppi, cuuwaaɗi nder uurdi hano no *Yahudankooɓe mboowi waɗude nde no mooɓa maayɗo nii. ");
INSERT INTO fuh_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","No woodunoo koogol takkol to Iisa tontanoo toon. Nder maggol no woodi annyeere heyre nde baa gooto mooɓaaka nder mum. ");
INSERT INTO fuh_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ngam annyeere ndeen ɓuri ɓadaade e ngam *nyalaane fowteteene no hiɗi naatude, sey ɓe ngatti ɓanndu Iisa toon. ");
INSERT INTO fuh_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Alal Mariyaama mo Magdaala hejji illa nder nimre, yehi tuumtowii annyeere Iisa. O tawi kaaƴa ommbiranoonga annyeere ndeen tallitaama. ");
INSERT INTO fuh_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Sey o doggi, o yehi to Simon Piyer e aahiijo mo Iisa hiɗi oon, o wi'i ɓe : —Ɓe itti ɓanndu Iisa nder annyeere ndeen, min anndaa duu to ɓe ngatti ndu. ");
INSERT INTO fuh_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Piyer e aahiijo gom mburtii pa'i to annyeere ndeen. ");
INSERT INTO fuh_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ɓe fuu ɗiɗo iɓe ndogga. Aahiijo ooto daɗi Piyer, artii mo yottaade to annyeere ndeen. ");
INSERT INTO fuh_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","O turii o yuurni, o hi'i leppi ɗiin no dekodiri, amma o naataay. ");
INSERT INTO fuh_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simon Piyer yottii, naati, tawi leppi ɗiin no njoowii. ");
INSERT INTO fuh_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Lefol piilanoongol e hoore makko ngool wondaa he leppi ɗiin. Ngol tawaama ingol taggii feere maggol. ");
INSERT INTO fuh_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Nden aahiijo artuɗo warde oon, kam duu naati, hi'i ɗum, goonɗini. ");
INSERT INTO fuh_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Tawi faa hannden ɓe paamaay ko sappanoo nder dewte mbi'u ɗum Iisa no haani ummitaade. ");
INSERT INTO fuh_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Gaɗa mum *aahiiɓe ɓeen kooti. ");
INSERT INTO fuh_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Mariyaama hootaay no darii yaasin, no huybiti har annyeere ndeen, no woya. O turii, omo yuurnoo ley annyeere ndeen. ");
INSERT INTO fuh_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Sey o hi'i maleykaaɓe ɗiɗo ɓorniiɓe kolte daneeje no njooɗii to Iisa fukkinanoo : Gooto har hoore, ooto har koyɗe. ");
INSERT INTO fuh_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Maleykaaɓe ɓeen ƴami mo mbi'i : —Debbo, ɗume mboyataa ? O jaabii ɓe o wi'i : —Ɓe adi Joomam, mi anndaa to o yaaraa. ");
INSERT INTO fuh_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Wakkati o hantunoo haala kaa, o yeeƴitii, sey o hi'i Iisa no darii, amma o annditaay mo. ");
INSERT INTO fuh_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Iisa wi'i mo : —Banndam debbo, ɗume mboyataa ? Moy tefataa ? Amma Mariyaama miili ko gonɗo no haalda he mum oon woni golloowo nder koogol ngool, nden o wi'i mo : —Gorko mawɗo, se aan hooƴi mo, haalanan to njaaruɗaa mo, faa mi hooƴowa mo. ");
INSERT INTO fuh_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Iisa wi'i mo : —Mariyaama ! Mariyaama waylitii, daari mo, wi'i nder ibrankoore : —Rabbuni kam woni « Moodibbo ». ");
INSERT INTO fuh_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Iisa wi'i mo : —Taa jogam, sabu mi ƴeenyaay to *Baaba am ginan. Yah to banndiraaɓe am, mbi'aa ɓe : « Mi yahan to *Baaba am, *Baabiraawo mon, Alla am, Alla mon. » ");
INSERT INTO fuh_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Mariyaama mo Magdaala yehi to *aahiiɓe ɓeen, wi'i : —Mi hi'i Joomiraawo. Nden, o haalani ɓe ko Iisa wi'i mo fuu. ");
INSERT INTO fuh_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Alal laasara peewɗo, *aahiiɓe Iisa fuu kawri nder suudu, maɓɓi dammbule ɗeen sabu kulal mawɓe *Yahudankooɓe, sey Iisa wanngi hakkune maɓɓe, wi'i ɓe : —Jam wonda he mooɗon ! ");
INSERT INTO fuh_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Gaɗa haala kaa, o holli ɓe juuɗe makko e wuttudu makko. *Aahiiɓe ɓeen nanii belɗum nde ngi'unoo mo. ");
INSERT INTO fuh_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Nden Iisa wi'i ɓe kaden : —Jam wonda he mooɗon. Hano no *Baabiraawo liliri kam non, liliranmi on. ");
INSERT INTO fuh_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Wakkati o hantunoo haalaaji ɗii, o fuufi dow maɓɓe, o wi'i : —Njaɓee *Ruuhu Ceniiɗo. ");
INSERT INTO fuh_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Mo njaafiɗon fuu, yaafaama, mo on njaafaaki duu, yaafataake. ");
INSERT INTO fuh_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tomas bi'eteeɗo Funeejo, gooto nder *lilaaɓe sappo e ɗiɗo ɓeen, walaano ɗoon wakkati Iisa wanngunoo. ");
INSERT INTO fuh_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Sey *aahiiɓe ɓeen mbi'i mo : —Min ngi'ii Joomiraawo ! O jaabii ɓe o wi'i : —Se mi hi'aay tontanɗe ɗeen he juuɗe makko, mi watta honndu am nder majje, mi loowa junngo am nder wuttudu makko, mi goonɗintaa sam. ");
INSERT INTO fuh_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Jeɗɗiire gaɗa mum, *aahiiɓe ɓeen kawri kaden nder suudu, indu maɓɓii, Tomas no wondi he maɓɓe. Dammbule ɗeen fuu no maɓɓii, sey Iisa wanngi hakkune maɓɓe, wi'i ɓe : —Jam wonda he mooɗon ! ");
INSERT INTO fuh_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","O wi'i Tomas : —Wattu honndu maa ɗo, ƴeewu juuɗe am. Loowu junngo maa nder wuttudu am. Accu sikka, goonɗin tan. ");
INSERT INTO fuh_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomas jaabii mo wi'i : —Joomam, Alla am. ");
INSERT INTO fuh_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Iisa wi'i mo : —Ngam a hi'i kam, a goonɗinii. Too, ɓe ngi'aay kam se ngoonɗinii kam, kamɓe ngoni welɓe hoore. ");
INSERT INTO fuh_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Iisa waɗi kujje kaayɗiniiɗe ɗuɗɗe yeeso *aahiiɓe mum ɗe mbinndaaka nder dewtere ndee. ");
INSERT INTO fuh_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Amma dewtere ndee winndaama ngam ngoonɗinon ko Iisa woni *Almasiihu *Ɓii-Alla, ngam se on ngoonɗinii ɗum, keɓon mbuurnam daliila makko. ");
INSERT INTO fuh_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Gaɗa bannganol Tomas ngool Iisa wannganii *aahiiɓe mum hadde peta Tiberiya. Ndaa no o wanngiri nii : ");
INSERT INTO fuh_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simon Piyer, Tomas bi'eteeɗo Funeejo, Natanayel mo wuro Kaana nder leydi Galili, ɓiɓɓe Jebede worɓe e *aahiiɓe ɗiɗo gom, no tawaa toon. ");
INSERT INTO fuh_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Sey Simon Piyer wi'i ɓe : —Mi nanngowan liƴƴi. Ɓe mbi'i : —Minen duu, min njahdan he maa. Ɓe njehi, ɓe naatowi laana. Jemma oon, ɓe keɓaay baafuy. ");
INSERT INTO fuh_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Wakkati pooyngol umminoo, Iisa wari darii fonngo maayo ngoon, amma *aahiiɓe ɓeen anndaay hala kanko non. ");
INSERT INTO fuh_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Sey Iisa wi'i ɓe : —Sukaaɓe, on keɓii liƴƴi ? Ɓe njaabii mo ɓe mbi'i : —Min keɓaay ! ");
INSERT INTO fuh_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Nden o wi'i ɓe : —Paɗɗee taaruwol ngool nyaamo laana kaan, on keɓan. Ko ɓe paɗɗi ngol, ɓe keɓi liƴƴi ɗuɗɗi faa ɓe keppi naatinde ngol nder laana kaan. ");
INSERT INTO fuh_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Aahiijo mo Iisa hiɗi oon wi'i Simon Piyer : —Joomiraawo non ! Nde Simon Piyer nanunoo Joomiraawo non, o hooƴi jabbaare makko, o ɓornii sabu o ɓoortakeno, o fitti, o jikki nder ndiyam ɗaam. ");
INSERT INTO fuh_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Amma *aahiiɓe ɓeeto ngardi he laana kaan, iɓe ndaasa taaruwol keewngol liƴƴi ngool. Ɓe mboɗɗaaki fonngo ngoon ko waɗata kuule hemre. ");
INSERT INTO fuh_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Wakkati ɓe ƴeenyunoo fonngo ngoon, ɓe ngi'ii pette, liƴƴi no ndekii dow mum. Ɓe ngi'ii buuru duu no resii. ");
INSERT INTO fuh_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Iisa wi'i ɓe : —Ngaddee seɗɗa nder liƴƴi ɗi nannguɗon ɗiin. ");
INSERT INTO fuh_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simon Piyer naati laana kaan, fooɗi taaruwol keewngol liƴƴi mawɗi ngool. Liƴƴi hemre e woygu e tati ngol ƴeenyini. No ɗi keewiri nii fuu, taaruwol ngool serkaay. ");
INSERT INTO fuh_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Iisa wi'i ɓe : —Ngaree, pummee ! Nden ɓe annditi mo amma baa gooto nder *aahiiɓe ɓeen suusaay ƴamude mo wi'aa : « Aan woni moy ? » ");
INSERT INTO fuh_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Nden Iisa ɓadii, o hooƴi buuru o hokki ɓe. O hokki ɓe liƴƴi ɗiin duu. ");
INSERT INTO fuh_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ɗum woni tataɓere nde Iisa wanngani *aahiiɓe mum gaɗa ummitaaki mum. ");
INSERT INTO fuh_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Gaɗa pummaari, Iisa wi'i Simon Piyer : —Simon ɓii-Yahaaya, aɗa ɓuri ɓe hidde kam naa ? Piyer jaabii mo wi'i : —Ayyo ! Joomam, aɗa anndi miɗo hiɗi ma. Nden Iisa wi'i mo : —Duru ɓiɓɓe baali am ! ");
INSERT INTO fuh_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Iisa wi'i mo kaden : —Simon, ɓii-Yahaaya, aɗa hiɗi kam naa ? O jaabii mo o wi'i : Ayyo ! Joomam, aɗa anndi miɗo hiɗi ma ! Nden Iisa wi'i mo : —Duru baali am ! ");
INSERT INTO fuh_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Iisa wi'i mo kaden : —Simon, ɓii-Yahaaya, aɗa hiɗi kam naa ? Sey ɓerne Piyer metti, sabu o wi'i mo nde tati : « Aɗa hiɗi kam naa ? » Piyer wi'i mo : —Joomiraawo, aɗa faamani huune fuu, aɗa anndi duu miɗo hiɗi ma. Iisa wi'i mo : —Duru baali am. ");
INSERT INTO fuh_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Mi haalante goonga, nder njokollaaku maa, a haɓɓanan hoore maa duhol, njahaa to welii ma. Amma nde a naywi, a ɓantan juuɗe maa, kaɓɓaneɗaa duhol maa njaareɗaa to welaa ma. ");
INSERT INTO fuh_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Iisa wi'i haalaaji ɗii ngam hollude no Piyer maayirta, e no o teddinirta Alla. Gaɗa ɗum, o wi'i Piyer : —Tokkam. ");
INSERT INTO fuh_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Piyer yeeƴitii, hi'i aahiijo mo Iisa hiɗi oon no tokki ɓe. Aahiijo oo woni gonnooɗo no wahi hadde Iisa wakkati ɓe kiirtotonoo. Kanko ɓagginoo ƴami Iisa, wi'i : « Moy woni jammbotooɗo ma ? » ");
INSERT INTO fuh_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Wakkati Piyer hi'unoo mo, wi'i Iisa : —Joomam, oo nee ɗume o laatoto ? ");
INSERT INTO fuh_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Iisa jaabii mo wi'i : —Se mi hiɗii o wuura faa mi warta, ko hilli ma ? Aan kay, tokkam tan ! ");
INSERT INTO fuh_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Haala kaan sankitii hakkune goonɗinɓe Iisa fuu ko *aahiijo oo maayataa, amma Iisa wi'aay o maayataa. O wi'aana tan : « Se mi hiɗii o wuura faa mi warta, ko hilli ma ? » ");
INSERT INTO fuh_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Aahiijo oo woni aahiijo ceedaniiɗo kujje ɗee ko winndi ɗee, eɗen anndi duu ko seede makko no goonga. ");
INSERT INTO fuh_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Iisa waɗi kujje ɗuɗɗe gom duu laatiiɗe se mbinndanooma gootel, gootel, miɗo miila duuniyaaru nduu waawaa hooƴude dewte majje.");
INSERT INTO fuh_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Banndam Tawfilus, nder dewtere am arandeere, mi winndanii ma dow ko Iisa fuɗɗiri e ko o waajii illa arannde ");
INSERT INTO fuh_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","faa wara nyalaane nde o ƴeencinaa. Fadde makko ƴeencineede, nder baawɗe *Ruuhu Ceniiɗo o fooɗi hakkillo *lilaaɓe makko ɓe o suɓinoo, o tinndini ɓe. ");
INSERT INTO fuh_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Gaɗa torraaji makko, he maayde makko, nder alamaaji ɗuɗɗi tabbintinooji ummitaaki makko o wanngani ɓe, omo wuuri. Omo haalda he maɓɓe dow Laamu Alla duu. O waɗi ɗum, ɗum fuu, nder balɗe lasooji ɗiɗi. ");
INSERT INTO fuh_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Nyannde gom wakkati o nyaamidanoo he maɓɓe o fooɗi hakkillo maɓɓe o wi'i ɓe : —To ndillee nder *Ursaliima, amma njooɗee keɗoɗon alkawal ƴuwanngal to *Baaba am ngal kaalanannoomi on, ");
INSERT INTO fuh_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","mbi'umi : « Yahaaya, ndiyam waɗiranannoo himɓe *batisma, amma onon nder balɗe seɗɗa, *batisma mooɗon, *Ruuhu Ceniiɗo waɗirtee. » ");
INSERT INTO fuh_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Nden *lilaaɓe ɓeen kawri, ƴami mo, mbi'i : —Joomiraawo, jooni ngartirta laamu *Isra'el naa ? ");
INSERT INTO fuh_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Iisa jaabii ɓe wi'i : —On ngalaa baawɗe anndude hitaane naa wakkati mo Alla *Baabiraawo darni nder baawɗe hoore mum. ");
INSERT INTO fuh_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Amma wakkati *Ruuhu Ceniiɗo jippoto dow mooɗon, on keɓan baawɗe. On laatoto seedantooɓe kam nder *Ursaliima, nder leydi Yahudiya, nder leydi *Samariya fuu, happa ɗon faa hulna duuniyaaru fuu. ");
INSERT INTO fuh_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Wakkati o hantunoo haalaaji ɗii, ɓe fuu iɓe ndaara mo faa o ƴencinaa. Luuldere gom wari senndi mo he gite maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Wakkati ɓe tiggitinoo, iɓe ndaara omo ƴeencinee ndeen, worɓe ɗiɗo gom ɓorniiɓe kolte daneeje mbanngi he maɓɓe, ");
INSERT INTO fuh_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","mbi'i ɓe : —Hey, onon ɓiɓɓe Galili, ɗume waɗi ko oɗon nii oɗon tiggitii dow ? Iisa gooto dilluɗo hakkune mooɗon oon, ƴeencinaaɗo oo, wartan. O wartitan hano no ngi'irɗon mo, wakkati o ƴeencintenoo. ");
INSERT INTO fuh_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Nden *lilaaɓe ɓeen njippi waamnde wi'eteene waamnde Jaytun ngarti nder *Ursaliima. Waamnde ndeen yahde *Ursaliima ɓuraay kilo go'o. ");
INSERT INTO fuh_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Wakkati ɓe ngartunoo nder huɓeere ndeen, ɓe ƴeenyi ɓe naatowi nder suudu dowuuru to ɓe mbowunoo weerde. Piyer, Yahaaya, Yakuuba, Andiire, Filipa, Tomas, Bartolome, Matta, Yakuuba ɓii-Alfee, Simon kiranoowo suudu baaba, e Yahuuda ɓii-Yakuuba no tawa nder maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ɓe fuu ɓe poti ɓe ngaɗi daane worre, kamɓe he inna Iisa, minyiraaɓe Iisa he rewɓe gom, ɓe tinni iɓe ndu'oo. ");
INSERT INTO fuh_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Nder balɗe mum hawriine gom waɗi. Goonɗinɓe waɗooɓe hano himɓe hemre he laso kawri. Piyer ummii, darii hakkune maɓɓe wi'i : ");
INSERT INTO fuh_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","17","—Banndiraaɓe, no tilsi ko *Ruuhu Ceniiɗo haalunoo nder Dewtere Alla Seniine har hunnduko Daawda ɗum tabbita. Dow Yahuuda *Ruuhu Ceniiɗo haali, wakkati o wi'unoo : « Omo limenoo nder meeɗen, o heɓi mbaka makko nder gollal ngal ngolleten ». Yahuuda kam ardi nannguɓe Iisa. ( ");
INSERT INTO fuh_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Ceede ɗe o yoɓaa ngam gollal makko nyiddungal ngaal, o soodiri ngesa. Toon o saamiri hoore hoore, reedu makko fusi, teketti makko ndufi, o maayi. ");
INSERT INTO fuh_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Habaru oo sankitii nder *Ursaliima fuu, ngesa ngaan inndiraa Akeldama nder ɗemngal maɓɓe, kam woni « Ngesa nga Ƴiiƴam ».) ");
INSERT INTO fuh_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ngam ɗum winndaa nder dewtere *Jabuura wi'aa : Wuro makko laatoo winnde, to neɗɗo fuu hoɗu toon. No winndaa kaden : Neɗɗo gom naata nokku makko. ");
INSERT INTO fuh_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Ndenne, no tilsi goɗɗo suɓee ngam seedaade dow ummitaaki Iisa *Almasiihu Joomiraawo meeɗen. Neɗɗo oo duu no haani laatoo neɗɗo gondunooɗo he meeɗen illa wakkati mo Yahaaya waɗani Iisa *batisma faa warde nyalaane nde Iisa ƴeencinaa. ");
INSERT INTO fuh_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Sey goonɗinɓe ɓeen ndarni haala dow himɓe ɗiɗo : Yusufu Barsabas inndirteeɗo Yustus, he Mattiyas. ");
INSERT INTO fuh_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ɓe ndu'i, ɓe piirti hunnduko, ɓe mbi'i : —Joomiraawo, aan annduɗo ɓerne neɗɗo fuu, hollu min, moy cuɓiɗaa nder himɓe ɗiɗo ɓee, ");
INSERT INTO fuh_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ngam ada gollal lilaaku ngal Yahuuda acci, yehi nanngowi golle ɗe o haani. ");
INSERT INTO fuh_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ɓe cuɓi, cuɓaaki kiin saami dow Mattiyas. Nden o ɓeydaa he *lilaaɓe sappo e go'o ɓeen. ");
INSERT INTO fuh_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Wakkati Juulɗe kettol alkamaari bi'eteeɗe Pentakota njottinoo, goonɗinɓe ɓeen fuu kawri nokkuure worre. ");
INSERT INTO fuh_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Sey olko gom ƴuwi dow, nanndungo olko henndu mawnu, wari heewni suudu ndu ɓe kawri nder mum nduun. ");
INSERT INTO fuh_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Nden goɗɗum nannduɗum he ɗemle hiite wanngi, sankitii, jippowi dow neɗɗo maɓɓe fuu. ");
INSERT INTO fuh_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ɓe fuu ɓe keewi *Ruuhu Ceniiɗo, ɓe puɗɗi iɓe kaala nder ɗemle feere-fereeje hano no *Ruuhu Ceniiɗo hokkiri ɓe baawɗe haalirde. ");
INSERT INTO fuh_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Nder huɓeere *Ursaliima no woodunoo *Yahudankooɓe hulooɓe Alla gom, ƴuwɓe nder sera-seraaji duuniyaaru fuu. ");
INSERT INTO fuh_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Wakkati ɓe nanunoo olko ngoon, ɓe mbemmbaa, ɓe ndoggi, ɓe pa'i to *lilaaɓe ɓeen. Neɗɗo maɓɓe fuu no nana goonɗinɓe ɓeen no kaala nder ɗemngal mum. ");
INSERT INTO fuh_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Huune ndee haayɗini ɓe, ɗum naati ɓalli maɓɓe sanne, sey ɓe tokki, iɓe ƴamodira iɓe mbi'a : —Himɓe ɓee, ɓe kanaa ɓiɓɓe Galili naa ? ");
INSERT INTO fuh_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Noy waɗi ko neɗɗo meeɗen fuu no nana ko ɓe kaalata nder ɗemngal mum ? ");
INSERT INTO fuh_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Nder meeɗen no tawa Partiyankooɓe, Mediyankooɓe, Elamiyankooɓe, no woodi jooɗiiɓe Mesopotamiya, Yahudiya, Kapadokiya, Pontus he Asiya, ");
INSERT INTO fuh_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Firigiya, Pamfiliya, Misira, leyɗe Libiya hedde har Sirene. Gere meeɗen ƴuwi nder leydi *Rooma, ");
INSERT INTO fuh_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","woɓɓe ƴuwi duune Kereta, woɓɓe duu ƴuwi leydi Arabiya. Woɓɓe nder meeɗen no *Yahudankooɓe, woɓɓe duu no tuubuɓe njaɓi diina *Yahudankooɓe. Enen wonɓe ɗo, eɗen nana ko ɓe kaalata nder ɗemle meeɗen dow kaayɗe ɗe Alla waɗi. ");
INSERT INTO fuh_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ɗum haayɗini ɓe, ɗum hooƴi hakkillooji maɓɓe sanne, faa iɓe ƴamodira, iɓe mbi'a : —Ɗume woni maana ɗum naa ɗum to ? ");
INSERT INTO fuh_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Amma woɓɓe nder maɓɓe duu no njala goonɗinɓe ɓeen, no mbi'odira : —Cabiijam ɓe njari faa ɗam soptini hakkillooji maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Piyer ummii, ndarii, kanko he *lilaaɓe sappo e go'o ɓeen, o ɓanti daane makko o wi'i : —Onon *Yahudankooɓe he tawaaɓe nder *Ursaliima, kettinee ! Korkitee noppi mooɗon heɓa paamon ko won no waɗa. ");
INSERT INTO fuh_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Himɓe ɓee, ko'e maɓɓe coptaaki hano no miilirɗon ngam jamɗe jeenay subaka ngonɗen joonin ! ");
INSERT INTO fuh_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Amma ɗum waɗi ngam tabbintinande en ko annabi Yo'el haalunoo nder annabaaku mum. Nder maggu Alla wi'i : ");
INSERT INTO fuh_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Nder jamaanu cakitittooɗo, mi jippinan *Ruuhu am dow ɓii-aadama fuu. Ɓiɓɓe mooɗon worɓe he rewɓe no ngaɗan annabaaku. Sukaaɓe mooɗon jokolɓe no kolletee ko waɗata. Nayeeɓe mooɗon duu no koyɗan koyɗi ƴuwɗi to am. ");
INSERT INTO fuh_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Nder balɗe mum mi jippinan *Ruuhu am dow gollooɓe am worɓe he rewɓe. Ɓe ngaɗan annabaaku. ");
INSERT INTO fuh_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Mi waɗan kujje kaayɗiniiɗe dow kammu, he alamaaji duu dow leydi. Ƴiiƴam, hiite he cuurki ɓaleehi mbanngan. ");
INSERT INTO fuh_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Fadde nyalaane mawne, nyalaane teddude, nyalaane Joomiraawo ndee warde, naange no niɓɓan, lewru duu wojja hano ƴiiƴam. ");
INSERT INTO fuh_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Wakkati mum neɗɗo fuu noddi innde Joomiraawo, joomum no heɓan kisinam. ");
INSERT INTO fuh_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","—Onon Isra'ilankooɓe, kettinee, Iisa mo Nasaratu woni mo Alla suɓii, hokki baawɗe waɗude kujje kaayɗiniiɗe, he alamaaji ɗuɗɗi hakkune mooɗon. Onon e ko'e mooɗon, oɗon anndi ko waɗi. ");
INSERT INTO fuh_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Gorko oo, nanngaaɗo, wattaa nder juuɗe bonɗe, tontaaɗo dow *leggal bardugal hano no Alla waadori ɗum nder muuyɗe mum. ");
INSERT INTO fuh_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Alla ummintinii mo, soptini mo he baawɗe maayde ngam maayde waawaa faddaade mo. ");
INSERT INTO fuh_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Se goonga Daawda winndinoo dow makko wi'i : Wakkati fuu miɗo hi'a Joomiraawo yeeso am, mi diwnirtaa kulkulal ngam omo nyaamo am. ");
INSERT INTO fuh_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ngam majjum ɓerne am no nder welwelo, hunnduko am no mana mo. Ɓanndu am duu no jooɗoto nder gokka, ");
INSERT INTO fuh_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","ngam Joomiraawo, a accataa yonki am nder annyeere. A accataa Ceniiɗo maa nyola. ");
INSERT INTO fuh_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","A hollii kam laabi jaarooji to mbuurnam. Wondude he maaɗa no heewnira kam welwelo. ");
INSERT INTO fuh_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","—Banndiraaɓe, ko kaalananmi on ɗum dow maamii'en Daawda, se goonga, o maayi, o ufaama, annyeere makko no ɗon faa warde hannden. ");
INSERT INTO fuh_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ngam Alla waɗi mo annabiijo, omo anndi duu ko Alla hunake, waɗanii mo amaana, wi'i ko kam no dekan gooto nder jippotooɓe he makko dow jooɗorgal laamu. ");
INSERT INTO fuh_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Daawda hi'i ummitaaki Iisa *Almasiihu, o haali dow makki o wi'i : Yonki makko accaaka nder annyeere, ɓanndu makko nyolaay. ");
INSERT INTO fuh_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","En fuu eɗen ceedi ko Alla ummintinii Iisa mo ngonmi miɗo haala dow mum oon. ");
INSERT INTO fuh_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Alla teddini Iisa, joonnii mo nyaamo mum, hokki mo *Ruuhu mum Ceniiɗo mo alkawal mum ngaɗanaɗen oon. Iisa duu jippini mo dow amin hano no ngonɗon oɗon ngi'ira ɗum, oɗon nana ɗum hannden. ");
INSERT INTO fuh_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Daawda ƴeencinaaka amma o wi'i kanko he hoore makko : Alla Joomiraawo wi'i Joomiraawo am : War, njooɗaa nyaamo am, ");
INSERT INTO fuh_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","faa mi sorna wayɓe maa ley teppere maa. ");
INSERT INTO fuh_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","—Ndenne Isra'ilankooɓe fuu, no kaani paama ko sikka fuu walaa Iisa mo tontuɗon oo, kanko Alla waɗi Joomiraawo, o waɗi mo duu *Almasiihu. ");
INSERT INTO fuh_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Wakkati ɓe nanunoo haalaaji ɗii fuu, ɗum suuli ɓerɗe maɓɓe sanne, nden ɓe mbi'i Piyer he *lilaaɓe ɓeeto : —Banndiraaɓe ɗume min ngaɗata ? ");
INSERT INTO fuh_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Piyer jaabii ɓe wi'i : —Tuubee, neɗɗo mooɗon fuu waɗanee *batisma dow innde Iisa *Almasiihu, ngam hakkeeji mooɗon njaafee, nden Alla jippina *Ruuhu Ceniiɗo, kokkal mum dow mooɗon. ");
INSERT INTO fuh_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Alla waɗi alkawal oo ngam mooɗon, ngam ɓiɓɓe mooɗon, he himɓe wonɓe to woɗɗi. O waɗaama duu ngam neɗɗo fuu mo Alla Joomiraawo meeɗen noddi. ");
INSERT INTO fuh_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Piyer haalanii ɓe haalaaji ɗuɗɗi ngam ɓe paama, ɓe cemmbiɗaa. O wi'i ɓe ndogga, ɓe ndaɗa jamaanu bonɗo oo. ");
INSERT INTO fuh_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Jaɓuɓe haala makko fuu ngaɗanaama *batisma. Nyannde mum, himɓe waɗooɓe hano himɓe ujunaaji tato ngari ɓeydi he hawriine goonɗinɓe ndeen. ");
INSERT INTO fuh_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Iɓe kettinoo waaju *lilaaɓe ɓeen nde hennon fuu, iɓe nanngodira nder hawriine maɓɓe, iɓe cennda buuru, iɓe ngaɗida du'aa'u. ");
INSERT INTO fuh_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ngam sabbu kaayɗe ɗuɗɗe ɗe *lilaaɓe ɓeen ngoni no ngaɗa nder baawɗe Alla, kulal Alla nanngi neɗɗo maɓɓe fuu. ");
INSERT INTO fuh_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Goonɗinɓe ɓeen fuu kawri laatii inna gooto baaba gooto. Neɗɗo maɓɓe fuu no hokkara banndum he ko woodi. ");
INSERT INTO fuh_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ɓe conni ko ɓe ngoodi fuu, ɓe cenndi ceede ɗeen caka maɓɓe, neɗɗo maɓɓe fuu heɓi keddi ko heƴata ɗum. ");
INSERT INTO fuh_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Wakkati fuu iɓe ngara, iɓe kawra nder Juuliirde Alla mawne. Iɓe cennda buuru nder cuuɗi maɓɓe, iɓe nyaamda nder welwelo he ɓerne worre. ");
INSERT INTO fuh_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Iɓe njetta Alla, iɓe mbeegina himɓe. Nyannde fuu Joomiraawo no ɓeyda himɓe nder hawriine maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Nyalooma gom har yamnde tati, Piyer he Yahaaya no njahda Juulirde Alla mawne ngam du'aade. ");
INSERT INTO fuh_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Hadde dammbugal mayre, dammbugal inndirteengal dammbugal Wodde, gorko gom bonnguɗo illa dimeeki mum no tawee ɗon wakkati fuu. Nyannde fuu omo waddee, omo jonnee yeeso maggal, ngam o garbina he naatooɓe ɓeen. ");
INSERT INTO fuh_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Wakkati bonnguujo oon hi'unoo Piyer he Yahaaya no naata, o eeli ɓe, ɓe cakkana mo. ");
INSERT INTO fuh_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Piyer he Yahaaya tiimi mo, nden Piyer wi'i mo : —Ndaaru min ! ");
INSERT INTO fuh_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","O daari ɓe faa wooɗi ngam omo miila ko o heɓan goɗɗum he maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Sey Piyer wi'i mo : —Mi walaa kanŋe, mi walaa cardi, amma mi hokkete ko ngoodumi. Dow innde Iisa *Almasiihu mo Nasaratu, umma, dillu. ");
INSERT INTO fuh_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Nden Piyer nanngi junngo makko nyaamo, faa ummina mo. Wakkati mum da koyɗe makko cemmbiɗi. ");
INSERT INTO fuh_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","O garbisi, o darii, o fuɗɗi omo dilla. O tokki ɓe o naati Juulirde ndeen, omo dilla, omo fitta, omo yetta Alla. ");
INSERT INTO fuh_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Himɓe fuu ngi'ii omo dilla, omo yetta Alla. ");
INSERT INTO fuh_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ɓe annditii ko kanko woni garbinoowo yeeso dammbugal Wodde ngaal, ɗum haayɗini ɓe sanne, ɗum haɓɓi ko'e maɓɓe duu. ");
INSERT INTO fuh_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Bonnguujo oon woɗɗaaki Piyer e Yahaaya. Ɗum haayɗini himɓe fuu, ɓe ndoggi, ɓe ngari, ɓe kawri to maɓɓe ley danki Suleymaanu, hadde batamaare *Juulirde mawne. ");
INSERT INTO fuh_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Wakkati Piyer hi'unoo ɗum, o wi'i jama'aare ndeen : —Isra'ilankooɓe, ɗume waɗi ko yamɗintinol ngool no haayɗina on ? Ɗume waɗi ko oɗon ƴeewa min, hano har semmbe amin naa har tokkol amin Alla he ɓerne worre waɗi gorko oo no dillira koyɗe mum ? ");
INSERT INTO fuh_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Alla *Ibrahim, Alla Isiyaaku e Alla Yakuuba, Alla maamiraaɓe meeɗen, teddinii Iisa Golloowo mum. Amma onon, on ngattii mo nder juuɗe hooreeɓe leydi, on calake mo yeeso Pilaatus, baa ko o muuyi yoofude mo. ");
INSERT INTO fuh_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","On calake Ceniiɗo Dartiiɗo, dey ƴamuɗon njoofaneɗon ittoowo yonki nokku makko. ");
INSERT INTO fuh_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","On mbari Wuddu Mbuurnam, amma Alla ummintini mo. Miɗen ceedii ɗum. ");
INSERT INTO fuh_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Baawɗe innde Iisa he goonɗinol mum yamɗintini neɗɗo oo mo ngi'uɗon, mo annduɗon no wuurirnoo. Goonɗinde Iisa hokki mo jam ɓanndu hano no ngi'irton mo nii. ");
INSERT INTO fuh_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Too banndiraaɓe, miɗo anndi ko nder rafi anndal ngaɗuɗon golle ɗee, onon he ardiiɓe mooɗon fuu. ");
INSERT INTO fuh_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Amma Alla humni haala ka o wi'unoo har kunndule annabiiɓe makko dow Iisa, wakkati ɓe mbi'unoo ko *Almasiihu no torretee. ");
INSERT INTO fuh_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ndenne tuubee, ngartee he Alla ngam hakkeeji mooɗon moytee. ");
INSERT INTO fuh_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Joomiraawo hokka on wakkatiiji powtiri, o lilda on Iisa, *Almasiihu mo o fodani on. ");
INSERT INTO fuh_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Jooni Iisa no haani jooɗoo dow, sey nyannde Alla heyɗintini huune fuu hano no annabiiɓe makko kaaliri ɗum illa ko ɓooyi. ");
INSERT INTO fuh_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ngam *Muusa wi'i : Alla Joomiraawo mooɗon no suɓoto gooto nder mooɗon waɗa annabiijo. O lila mo hano no o liliroy kam. Kettinee huune fuu ko o wi'ata on. ");
INSERT INTO fuh_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Neɗɗo fuu mo jaɓaay ko o wi'i, no ittetee nder himɓe Alla. ");
INSERT INTO fuh_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Annabiiɓe fuu illa Samuwiila faa wara he waruɓe gaɗa makko fuu ngaɗi annabaaku dow nyalaaɗe ɗee. ");
INSERT INTO fuh_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Onon ngoni donuɓe annabaaku nguu, he amaana mo Alla watti hakkune mum he *Ibrahim wakkati o wi'unoo mo : Duuniyaaru fuu no barkintee ngam sabbu jippotooɓe he maaɗa. ");
INSERT INTO fuh_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Onon Alla arti wannginande Golloowo mum wakkati o ummintinii mo, ngam o barkina on, neɗɗo mooɗon fuu woppa golleeji mum bonɗi. ");
INSERT INTO fuh_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Wakkati Piyer e Yahaaya kaaldannoo jama'aare ndeen, *cakkanooɓe Alla he hooreejo doomooɓe Juulirde Alla mawne ndeen, he *Sadduki'en njotti. ");
INSERT INTO fuh_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ɗum metti ɓerɗe maɓɓe faa noy walaa, ngam ɓe ngi'ii Piyer he Yahaaya no mbaajoo, no njanngina himɓe, no mbi'a har Iisa, Alla no ummintina maayɓe. ");
INSERT INTO fuh_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Nden ɓe nanngi ɓe, ɓe uddowi faa weeta ngam jenngi sanne wakkati mum. ");
INSERT INTO fuh_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Amma himɓe ɗuɓɓe nder hettiniiɓe waaju oon ngoonɗinii. Iɓe ngaɗa hano himɓe ujunaaji joyo. ");
INSERT INTO fuh_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Jaangoore mum wooduɓe ardaŋal, mawɓe *Yahudankooɓe, he jannginooɓe *Tawreeta kawri nder *Ursaliima. ");
INSERT INTO fuh_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Nder hawriine ndeen no tawa Annas mawɗo *cakkanooɓe Alla fuu, Kayafas, Yahaaya, Skandaaru e jippotooɓe he mawɓe *cakkanooɓe Alla. ");
INSERT INTO fuh_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ɓe noddi Piyer e Yahaaya, ɓe ƴami ɓe, ɓe mbi'i : —Baawɗe ɗeye naa dow innde moy nyawtirɗon gorko oo ? ");
INSERT INTO fuh_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Nden Piyer heewi *Ruuhu Ceniiɗo, wi'i ɓe : —Onon wooduɓe ardaŋal he mawɓe *Yahudankooɓe, ");
INSERT INTO fuh_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","on ƴamii min hannden dow moƴƴere nde gorko oo hokkaa, he no waɗi ko o bonngiti. ");
INSERT INTO fuh_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Too, paamee ko gorko gonɗo yeeso mooɗon oo, bonngiti dow innde Iisa *Almasiihu mo Nasaratu, mo Alla ummintinii, gaɗa ko onon tontuɗon mo dow *leggal bardugal. ");
INSERT INTO fuh_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Iisa woni Hayre nde onon nyiɓooɓe mboppi, kayre duu laatii hoore nyibdi ndiin. ");
INSERT INTO fuh_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","To Iisa tan kisinam ƴuwata. Ngam hakkune ɓiɓɓe aadama, innde fuu walaa nde Alla hokki nde kaanirɗen hisinireede, nde hanaa innde makko. ");
INSERT INTO fuh_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Wakkati ardiiɓe ɓeen ngi'unoo cuusal Piyer e Yahaaya, ɗum haayɗini ɓe. Ɓe paamii ko Piyer e Yahaaya himɓe ladde non, ɓe njanngaay. Ɓe paamii duu ko himɓe wonduɓe he Iisa non. ");
INSERT INTO fuh_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Wakkati ɓe ngi'unoo bonngitaaɗo oon no darii hadde maɓɓe, ɓe keppi fuu ko ɓe mbi'a kaden. ");
INSERT INTO fuh_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ɓe mbi'i Piyer e Yahaaya mburtinee, nden ɓe caawodiri, ");
INSERT INTO fuh_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","ɓe mbi'i : —Noy ngatten worɓe ɓee ? Ngam sikka fuu walaa *Ursaliima fuu nani haayne nde ɓe ngaɗi, en mbaawaa yeddude duu. ");
INSERT INTO fuh_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Amma joonin ngam to habaru oo sankitoo hakkune himɓe, en pooɗu noppi maɓɓe, kaɗen ɓe haaldude himɓe dow innde Iisa. ");
INSERT INTO fuh_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Nden ɓe noddi Piyer e Yahaaya, ɓe tilsini ɗum'en ɓe mbi'i, to ɓe pilloo sam-sam, to ɓe mbaajoo neɗɗo fuu dow innde Iisa kaden. ");
INSERT INTO fuh_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Amma Piyer e Yahaaya njaabii ɓe mbi'i : —Too, laasibee ndaaree hakkune mooɗon he Alla, ɗume ɓuri hegaade, min tokka ko mbi'uɗon naa min tokka ko Alla wi'i ? ");
INSERT INTO fuh_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ngam no tilsi he amin, min ceedo dow ko min ngi'ii e dow ko min nani. ");
INSERT INTO fuh_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ardiiɓe ɓeen pooɗi noppi maɓɓe kaden, nden njoofi ɓe. Ɓe keppi fuu heɓude laawol jukkude ɓe ngam himɓe wonɓe ɗon fuu no njetta Alla ngam ko waɗi ɗum. ");
INSERT INTO fuh_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Bonngitaaɗo oon ɓuran duuɓi lasooji ɗiɗi. ");
INSERT INTO fuh_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Wakkati ɓe njoofanoo, Piyer e Yahaaya coƴƴi to banndiraaɓe mum'en. Ɓe pillanii ɓe huune fuu ko ardiiɓe ɓeen mbi'i. ");
INSERT INTO fuh_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Wakkati ɓe nanunoo haalaaji ɗiin, kamɓe duu, ɓe ummii he ɓerne worre ɓe ngaɗi du'aa'u, ɓe mbi'i : —Yaa Joomiraawo, aan taguɗo dow e ley, aan taguɗo maayo e huune fuu ko tawa nder mum. ");
INSERT INTO fuh_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Aan mo nder baawɗe mum, nder *Ruuhu mum waɗi maamiimin Daawda golloowo mum, wi'i : Ɗume waɗi hakkillo leyɗe fuu ummii ? Lenyi fuu no ngaɗa haɓɓi-daane meere meere ? ");
INSERT INTO fuh_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ɗume waɗi laamiiɓe duuniyaaru no ciryoo konu ? Ardiiɓe no caawodira dow Joomiraawo he *Almasiihu mum. ");
INSERT INTO fuh_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","—Tabbat sikka fuu walaa nder huɓeere ndee non, *Hirudus, Pontiyus Pilaatus, lenyi gom he Isra'ilankooɓe ngaddi hunnduko wooto dow Iisa, golloowo maaɗa ceniiɗo mo cuɓiɗaa. ");
INSERT INTO fuh_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ɓe kawri, ɓe kumni ko podinooɗaa nder baawɗe maaɗa he ko muuyɗaa fuu. ");
INSERT INTO fuh_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Yaa Joomiraawo, jooni, ƴeewu haalaaji maɓɓe bonɗi ɗii, kokkaa gollooɓe maaɗa cuusal haalude haalaaji maaɗa. ");
INSERT INTO fuh_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Wanngin baawɗe maaɗa, heɓa himɓe njamɗitaa, kujje kaayɗiniiɗe he alamaaji ngi'ee ngam sabbu innde Iisa, golloowo maaɗa ceniiɗo. ");
INSERT INTO fuh_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Wakkati ɓe kantunoo du'aa'u maɓɓe, nokkuure nde ɓe tawanoo nder mum ndeen yinngi. Ɓe fuu ɓe keewi *Ruuhu Ceniiɗo, ɓe ɓeydi suusude, ɓe tinni iɓe mbaajoo haala Alla. ");
INSERT INTO fuh_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Goonɗinɓe ɓeen fuu, laatii inna gooto baaba gooto. Iɓe cennda ko ɓe ngoodi fuu, walaa fuu bi'oowo kam tan jeyii ginol ngool naa kam jeyaa ngol. ");
INSERT INTO fuh_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Nder baawɗe mawɗe *lilaaɓe ɓeen ngoni no ceedoro dow ummitaaki Iisa Joomiraawo, Alla duu no barkina ɓe sanne. ");
INSERT INTO fuh_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Nder maɓɓe, walaa fuu keppuɗo goɗɗum. Gooduɗo ngesa naa suudu fuu, sonnii, ");
INSERT INTO fuh_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","watti ceede ɗeen nder juuɗe *lilaaɓe ɓeen. Ɓe cenndi, ngam neɗɗo fuu fiirta haaju mum. ");
INSERT INTO fuh_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Nder sonnuɓe ɓeen no tawa Lewinke gom, ƴuwɗo duune Kipurus bi'eteeɗo Yusufu mo *lilaaɓe ɓeen coowirta Barnabas, kam woni cemmbinɗinoowo ɓerɗe himɓe. ");
INSERT INTO fuh_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","O sonni ngesa makko, o watti ceede magga nder juuɗe *lilaaɓe ɓeen. ");
INSERT INTO fuh_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Nyannde gom, gorko gom bi'eteeɗo Ananiyas e deekum Safira conni ngesa mum'en. ");
INSERT INTO fuh_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Sey Ananiyas saawodiri he deekiiko, nden o fecci ceede magga, o suuɗi feccere gom, o wattowi feccere ndeeto nder juuɗe *lilaaɓe ɓeen. ");
INSERT INTO fuh_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Wakkati o waddi ceede ɗeen, sey Piyer wi'i mo : —Ananiyas ɗume waɗi accuɗaa Seyɗan naati nder ɓerne maa, penanɗaa *Ruuhu Ceniiɗo, peccuɗaa ceede ɗeen cuuɗuɗaa feccere majje ? ");
INSERT INTO fuh_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ko a sonnaayno ngesa ngaa, aan jeynoo nga, hannden duu ko connuɗaa nga, aan jeyii ceede magga. Noy waɗi ko ngaɗɗaa ir huune ndee ? Hanaa ɓiɓɓe aadama penanɗaa amma Alla he hoore mum penanɗaa. ");
INSERT INTO fuh_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Wakkati Ananiyas nanunoo haala kaa, o fooɗaay koyngal ko o maayi. Kulal manngal nanngi nanuɓe haala kaan. ");
INSERT INTO fuh_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Jokolɓe ngari, ngatti mo nder kasanke, mooɓowi. ");
INSERT INTO fuh_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Janɗe tati gaɗa mum, jom suudu makko kam duu wari amma anndaayno ko waɗi. ");
INSERT INTO fuh_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Sey Piyer ƴami mo wi'i : —Ceede ɗe connuɗon ngesa mooɗon ɗeen tan nii naa ? Safira jaabii mo wi'i : —Ayyo, keddi majje nii non. ");
INSERT INTO fuh_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Nden Piyer wi'i mo : —Noy waɗi ko aan he gora kaɓɓuɗon daane, cii'iɗon *Ruuhu Joomiraawo. Ndaa, ufoyɓe gora nii no ngarta, ɓe ufoyte, aan duu ! ");
INSERT INTO fuh_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Wakkati mum da debbo oon duu fooɗaay koyngal ko maayi. Jokolɓe ɓeen naati, ɓe tawi o maayi. Ɓe adi mo, ɓe ufowi hadde goriiko. ");
INSERT INTO fuh_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Kulal manngal nanngi goonɗinɗo Iisa fuu tawaaɗo nder *Ursaliima, he himɓe heewɓe nanunooɓe haala kaan. ");
INSERT INTO fuh_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","*Lilaaɓe ɓeen ngaɗi alamaaji he kujje keewɗe kaayɗiniiɗe hakkune himɓe. Goonɗinɓe Iisa ɓeen fuu no kawra ley danki Suleymaanu. ");
INSERT INTO fuh_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Neɗɗo fuu mo walaa nder hawriine maɓɓe suusaa yottaade to maɓɓe amma no teddina ɓe faa hanaa seɗɗa. ");
INSERT INTO fuh_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Jama'aare, worɓe e rewɓe ngoonɗini Joomiraawo. Iɓe ngara, iɓe ɓeydoo he goonɗinɓe ɓeen. ");
INSERT INTO fuh_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ɗum yottii joonkay faa to dow laabi, himɓe tinni no ngadda nyawɓe mum'en. Iɓe pukkina ɓe dow leece naa dow daage ngam ɗowdi Piyer tokka dow maɓɓe wakkati o yawtata. ");
INSERT INTO fuh_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Himɓe tawaaɓe nder gure piiliiɗe *Ursaliima no ngadda nyawɓe mum'en he ɓe ginnaaji bonɗi culnani. Ɓe fuu duu nyawti. ");
INSERT INTO fuh_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Wakkati mawɗo *cakkanooɓe Alla e *Sadduki'en ngi'unoo ko *lilaaɓe ɓeen ngoni no ngolla, ɓerɗe maɓɓe keewi kiram. ");
INSERT INTO fuh_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Sey ɓe ngaɗi *lilaaɓe ɓeen nanngaa, uddaa. ");
INSERT INTO fuh_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Amma nder jemma mum, Maleykaajo Joomiraawo gom omti dammbugal kasu ngaal, wurtini ɓe, ");
INSERT INTO fuh_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","nden wi'i ɓe : —Naatowee nder Juulirde Alla mawne, mbaajoɗon himɓe dow mbuurnam kesam. ");
INSERT INTO fuh_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Wakkati ɓe nanunoo haala kaa, illa subaka ɓe naatowi nder Juuliirde ndeen, ɓe puɗɗi waajaade himɓe. Mawɗo *cakkanooɓe Alla he wondunooɓe he mum ɓeen, noddi mawɓe *Yahudankooɓe ngam ɓe caawodira. Nden ɓe kokki doomooɓe *Juulirde mawne ndeen laawol ittowa *lilaaɓe ɓeen nder kasu, ngadda ɓe. ");
INSERT INTO fuh_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Amma wakkati ɓe njottinoo, ɓe tawaay *lilaaɓe ɓeen toon. Ɓe coƴƴi ɓe kaalanowi hawriine dawrooɓe ndeen, ɓe mbi'i : ");
INSERT INTO fuh_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","—Min tawi kasu oon no maɓɓi no wooɗiri, reenooɓe kasu ɓeen duu no ndarii nokkuuje mum'en. Amma wakkati dammbugal ngaal fiirtanoo, baa gooto maɓɓe tawaaka nder kasu oon. ");
INSERT INTO fuh_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Wakkati mawɗo doomooɓe *Juulirde mawne ndeen he mawɓe *cakkanooɓe Alla ɓeen nanunoo haalaaji ɗiin, ɗum haɓɓi ko'e maɓɓe, ɓe tinni iɓe ƴamodira ko ɗum rimanta ɓe. ");
INSERT INTO fuh_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Iɓe ɗon nii, sey goɗɗo wari, wi'i ɓe : —Ɓe udduɗon ɓeen, no nder *Juulirde mawne no mbaajoo. ");
INSERT INTO fuh_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Nden mawɗo doomooɓe ɓeen he himɓe mum njehi ngaddowi *lilaaɓe ɓeen. Amma ɓe ngaɗiraay ɗum semmbe semmbe ngam iɓe kula to himɓe paɗɗu ɓe kaaƴe. ");
INSERT INTO fuh_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Wakkati ɓe ngaddanoo yeeso hawriine dawrooɓe ndeen, mawɗo *cakkanooɓe Alla oon ƴami ɓe wi'i : ");
INSERT INTO fuh_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—Min kaɗi on waajaade sam dow innde gorko oo, amma on calake. Oɗon mbaajoo himɓe. Filla waaju mooɗon no nokku fuu to neɗɗo tokki nder *Ursaliima. Oɗon tefa dekude gacce dufol ƴiiƴam makko dow amin. ");
INSERT INTO fuh_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Nden Piyer he *lilaaɓe ɓeeto njaabii mo mbi'i : —Neɗɗo tokka ko Alla wi'i no ɓuri neɗɗo tokka ko himɓe mbi'i. ");
INSERT INTO fuh_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Alla maamiraaɓe meeɗen, ummintini Iisa mo ngaɗɗon tontaa, wara dow *leggal bardugal. ");
INSERT INTO fuh_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Alla ƴeencini mo, joonni nyaamo mum. Alla waɗi mo laamiiɗo e kisinoowo ngam Isra'ilankooɓe keɓa laawol no tuubiri, hakkeeji mum'en duu njaafee. ");
INSERT INTO fuh_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Minen he *Ruuhu Ceniiɗo mo Alla hokki tokkuɓe ko o wi'i fuu, min ceedake dow kujje ɗee. ");
INSERT INTO fuh_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Wakkati mawɓe ɓeen nanunoo haalaaji ɗiin, ɓe tikki sanne faa ɓe ngiɗiino warude ɓe. ");
INSERT INTO fuh_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Amma nder hawriine ndeen no tawa Fariisaajo gom bi'eteeɗo Gamaliyel, jannginoowo *Tawreeta mawɗo, mo haala mum no jaɓee. Sey o ummii, o ndarii, o wi'i *lilaaɓe ɓeen mburtinee wakkati seɗɗa. ");
INSERT INTO fuh_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Nden o fooɗi noppi dawrooɓe ɓeen, o wi'i : —Onon Isra'ilankooɓe, kakkilee faa he ko ngiɗɗon wadde himɓe ɓee. ");
INSERT INTO fuh_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ko ɓooyaay da en ngi'iino neɗɗo gom bi'eteeɗo Tewdas, miiluɗo kam no goɗɗum. Himɓe waɗooɓe hano keme nayo tokkii mo. Amma ɗum fuu haɗaay kanko he hoore makko o waraama, tokkuɓe mo ɓeen duu cankitaama, walaa fuu koddiiɗo nder maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Gaɗa majjum, hitaane limngal waɗeteeno ndeen, en ngi'ii duu ɓii-Galili gom bi'eteeɗo Yahuuda kam duu, wari murtinii himɓe ɗuɓɓe, kanko duu o waraama, tokkuɓe mo ɓeen duu cankitaa. ");
INSERT INTO fuh_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Jooni, ko ngiɗumi haalande on woni mboɗɗee himɓe ɓee, accon ɓe ndilla. Ngam nde nii tawaama anniyaaji ɗii he golleeji maɓɓe ɗii fuu no ƴoƴe ɓiɓɓe aadama, fotaay junngo gom sankita ɗum, ɗum sankitanto hoore majjum. ");
INSERT INTO fuh_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Amma nde nii goonga e goonga to Alla ɗum ƴuwi, too on mbaawaa kabdi he maɓɓe, kakkilee to kabdee he Alla ! ");
INSERT INTO fuh_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Hawriine ndeen jaɓi kollitooje makko, amma ɓe ngaɗi *lilaaɓe ɓeen ɓoccaa, ɓe kaɗi ɓe haalude dow innde Iisa, nden ɓe njoofaa. ");
INSERT INTO fuh_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","*Lilaaɓe ɓeen mburtii no nana belɗum ngam ɓe poti torreede ngam sabbu Iisa. ");
INSERT INTO fuh_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Illa nyannde mum, ɓe tinni iɓe mbaajoo nder *Juulirde mawne. Iɓe njaha nder cuuɗi himɓe, iɓe mbaajoo *Habaru lobbo haala Iisa *Almasiihu. ");
INSERT INTO fuh_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Nder balɗe mum aahiiɓe ɓeen no nii no ɓeydoo yahde. Sey *Yahudankooɓe haalooɓe gerekankoore no mbullira *Yahudankooɓe haalooɓe ibrankoore. Iɓe mbullira ɓeen, iɓe mbi'a ko ɓe goriraaɓe mum'en maayi wonɓe nder mum'en ngalaa no keɓa mbaka mum'en nyaamdu wonndu no senndee nyannde fuu. ");
INSERT INTO fuh_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Nyannde gom *lilaaɓe sappo e ɗiɗo ɓeen kawri goonɗinɓe ɓeen fuu mbi'i ɓe : —Ɗum hegaaki min acca waaju haala Alla, min cenndana himɓe nyaamdu. ");
INSERT INTO fuh_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ngam majjum waɗi banndiraaɓe, miɗen ngiɗi ndaaron hakkune mooɗon, cuɓoɗon worɓe jeɗɗo anndiraaɓe golle lobbe, heewɓe *Ruuhu Ceniiɗo he hakkillo ngam ɓe kalfinee golle cenndol nyaamdu ɗeen. ");
INSERT INTO fuh_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Dey accon min, min njaara golle amin yeeso, min tittinkinoo nder du'aa'u e waaju haala Alla. ");
INSERT INTO fuh_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Haala kaa weli jama'aare ndeen fuu. Ɓe cuɓi Etiyen keewɗo goonɗinol e *Ruuhu Ceniiɗo, Filipa, Porokorus, Nikanor, Timon, Parmenas he Nikolas mo Antiyokiya tuubuɗo jaɓi diina *Yahudankooɓe. ");
INSERT INTO fuh_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Suɓaaɓe jeɗɗo ɓeen ngaddaa yeeso *lilaaɓe ɓeen, ɓe njowi juuɗe dow maɓɓe, ɓe ngaɗani ɓe du'aa'u. ");
INSERT INTO fuh_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Haala Alla no sankitoo yahde, *lilaaɓe ɓeen duu no ɓeydoo sanne nder *Ursaliima, *cakkanooɓe Alla ɗuɓɓe ngoonɗini Iisa. ");
INSERT INTO fuh_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Etiyen keewɗo moƴƴere he baawɗe Alla no waɗa kaayɗe e alamaaji mawɗi hakkune himɓe. ");
INSERT INTO fuh_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Amma himɓe *waajordu inndirteenu *waajordu rimɗinaaɓe, ngari puɗɗi yeddodirde he makko. Nder maɓɓe no tawa ƴuwɓe nder leydi Sirene, leydi Alekasandiire, Silisi e Asiya. ");
INSERT INTO fuh_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Amma ɓe keppi jaalaade mo ngam omo haalda he maɓɓe nder hakkillo e *Ruuhu Ceniiɗo. ");
INSERT INTO fuh_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Nden ɓe kokki himɓe ceede nder cuccukka, mbi'a ko kam'en nani omo bonna innde *Muusa he innde Alla. ");
INSERT INTO fuh_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ɓe uppi himɓe he mawɓe mum'en fuu, he jannginooɓe *Tawreeta. Sey ɓe nanngi Etiyen, ɓe njaari yeeso hawriine dawrooɓe. ");
INSERT INTO fuh_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ɓe ngaddi seedeeɓe fewreeɓe gom, no mbi'a : —Gorko oo accaay bonnude innde Juulirde Alla Seniine e *Tawreeta Muusa. ");
INSERT INTO fuh_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Min nani omo wi'a Iisa mo Nasaratu no sankitan Juulirde ndeen, o waylitan finaa-tawaaji ɗi *Muusa holli en ɗiin. ");
INSERT INTO fuh_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Jooɗiiɓe nder hawriine ndeen fuu no puttini gite mum'en dow Etiyen no ndaara mo, sey ɓe ngi'ii yeeso makko no nanndana ɓe hano yeeso maleykaajo. ");
INSERT INTO fuh_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Mawɗo *cakkanooɓe Alla tawaaɗo nder hawriine dawrooɓe ndeen ƴami Etiyen wi'i : —Ko mbi'eɗaa ɗum no goonga naa ? ");
INSERT INTO fuh_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Nden Etiyen jaabii mo wi'i : —Baabiraaɓe e banndiraaɓe am, accee hakke kettinanee kam. Alla jom teddungal wanngani maamii'en *Ibrahim wakkati o wonnoo nder leydi Mesopotamiya fadde makko jooɗowaade nder wuro Haran. ");
INSERT INTO fuh_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","O wi'i mo : Wurta nder leydi maa, nder lenyol maa, njahaa nder leydi ndi kollanmaami. ");
INSERT INTO fuh_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","—Nden *Ibrahim dilli nder leydi Kaldiya, o jooɗowi nder wuro Haran. Gaɗa maayde baabiiko, o dilli toon o wari nder leydi ndi ngonɗon nder mum hannden ndii. ");
INSERT INTO fuh_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Alla ronnaay mo, baa kuulal naa yabbere nder mayri. Amma Alla waɗi alkawal hokkude mo leydi ndii, ndi laatoo halal-mulal makko, kanko e jippotooɓe he makko. Dey nder wakkati mum, *Ibrahim walaano ɓiɗɗo baa gooto. ");
INSERT INTO fuh_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Alla wi'i mo kaden : Jippotooɓe he maaɗa no peran koɗowa nder leydi gom, ɓe torree duuɓi keme nay, ɓe ngaɗee maccuɓe. ");
INSERT INTO fuh_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Amma mi jukkan leydi torrundi ɓe, waɗi ɓe maccuɓe. Nden ɓe ngarta nder nokkuure ndee, ɓe teddina kam. ");
INSERT INTO fuh_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Alla haɓɓidii *Ibrahim amaana, juulnol laatii alaama kolloowo amaana oon. Ngam majjum waɗi *Ibrahim juulni Isiyaaku balɗe jeɗɗi gaɗa dimeeki mum. Isiyaaku duu juulni Yakuuba, Yakuuba kam duu juulni ɓiɓɓe mum worɓe sappo e ɗiɗo, laatiiɓe maamiraaɓe meeɗen. ");
INSERT INTO fuh_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Maamiraaɓe meeɗen nder haasidaaku mum'en nanngi Yusufu, connani yehooɓe Misira gom, amma Alla no wondi he makko. ");
INSERT INTO fuh_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Alla soptini mo he torraaji makko fuu, moƴƴani mo hokki mo hakkillo yeeso Firawna, laamiiɗo Misira. Firawna ardini Yusufu, dawrana ko watta nder ɓaade mum he ko waɗetee nder Misira fuu. ");
INSERT INTO fuh_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Nder jamaanu ardaaki makko, rafo manngo gom waɗi nder kappa kuula leydi Misira e leydi Kanaana. Ngo torri himɓe sanne, maamiraaɓe meeɗen ngalaa fuu ko nyaamata. ");
INSERT INTO fuh_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Wakkati Yakuuba nanunoo ko Misira no woodi nyaamdu, lili ɓiɓɓe mum. Maamiraaɓe meeɗen coodowa nyaamdu. Ɓe njehi, ɓe ngarti. ");
INSERT INTO fuh_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Nder coƴƴitaaki maɓɓe ɗiɗaɓi, Yusufu wannginani ɓe hoore mum. Nii waɗi ko Firawna duu anndi lenyol Yusufu. ");
INSERT INTO fuh_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Nden Yusufu lilani bammum Yakuuba he koreeji mum, himɓe lasooji tato e sappo he joyo ngara Misira. ");
INSERT INTO fuh_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Nden Yakuuba he koreeji mum ngari Misira. O jooɗii toon faa ɓe maayi gooto gooto, kanko he ɓiɓɓe makko, maamiraaɓe meeɗen. ");
INSERT INTO fuh_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Nder ngesa nga *Ibrahim soodunoo he ɓiɓɓe Hamor nder wuro Sikem, toon ɓe mooɓaa. ");
INSERT INTO fuh_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Nde wakkati mo Alla humnannoo ko wi'unoo *Ibrahim ɗum yottinoo, Ibrankooɓe ɗuuɗi sanne nder leydi Misira. ");
INSERT INTO fuh_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Nder wakkati mum duu, laamiiɗo gom, mo anndaa Yusufu, mellaa nder Misira. ");
INSERT INTO fuh_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Laamiiɗo oon ƴoyni lenyol meeɗen, torri maamiraaɓe men, tilsinii ɓe, ɓe mboppa cukaloy maɓɓe maaya. ");
INSERT INTO fuh_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Nder wakkati mum *Muusa rimaa, omo horsi he Alla. Lebbi tati tan o waɗi wuro baabiiko, nden kanko duu o woppaa. ");
INSERT INTO fuh_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Wakkati o woppanoo, ɓii-Firawna debbo hooƴi mo, jogii hano ɓiyum reedu. ");
INSERT INTO fuh_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","*Muusa ekkita hikmaaku Misirankooɓe fuu, o laatii neɗɗo baawɗo haala e golle. ");
INSERT INTO fuh_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Wakkati *Muusa waɗunoo duuɓi lasooji ɗiɗi, nyannde gom o anniyi tuntowaade banndiraaɓe makko Isra'ilankooɓe. ");
INSERT INTO fuh_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Sey o hi'i Misiranke gom no torra Isra'ilanke gom, o tettini mo, o wari Misiranke oon ngam yoptanaade banndiiko. ");
INSERT INTO fuh_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","*Muusa no miila ko banndiraaɓe mum no paamowan ko har junngo mum Alla hisinirta ɓe, amma ɓe paamaay. ");
INSERT INTO fuh_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Jaangoore mum *Muusa hi'i Isra'ilankooɓe ɗiɗo gom no kaɓa. Nden o tefi fonnude ɓe, sey o ƴami ɓe, o wi'i : « Hey ! Onon, on banndiraaɓe ! Ɗume waɗi oɗon piyodira ? » ");
INSERT INTO fuh_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Sey gonɗo no torra banndum oon tutii *Muusa wi'i mo : Moy watti ma ardoɗaa min naa kiitoɗaa min ? ");
INSERT INTO fuh_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Naa miin duu, aɗa hiɗi mbaraa kam non, no mbarirɗaa Misiranke oo keeŋa ? ");
INSERT INTO fuh_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Wakkati *Muusa nanunoo haalaaji ɗii, doggi, suuɗowi nder leydi Madiyan, to o rimi ɓiɓɓe worɓe ɗiɗo. ");
INSERT INTO fuh_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Duuɓi lasooji ɗiɗi gaɗa mum, maleykaajo gom wanngani *Muusa nder ladde yeeruure, takkol waamnde *Sinayi nder ɗemle hiite wuumoore gom wonnde no jaɓa. ");
INSERT INTO fuh_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Wakkati o hi'unoo ɗum, ɗum haayɗini mo. Wakkati o ummii faa o daarowa ɗum, sey o nani daane Alla wi'i mo : ");
INSERT INTO fuh_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Miin woni Alla maamiraaɓe maaɗa, Alla mo *Ibrahim, Isiyaaku e Yakuuba tokkunoo. Sey *Muusa huli, darii, no diwna faa waawtaa daari wuumoore ndeen. ");
INSERT INTO fuh_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Nden Joomiraawo wi'i mo : Ɓortu paɗe maa, ngam nokkuure nde ndariɗaa dow mum ndee no seniine. ");
INSERT INTO fuh_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Mi hi'i torra himɓe am wonɓe nder leydi Misira. Mi nani duu uumaali maɓɓe. Mi wari ngam soptinde ɓe. Jooni war, mi lile nder Misira. ");
INSERT INTO fuh_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","*Muusa mo Isra'ilankooɓe calinoo faa mbi'i moy watti mo o ardoo ɓe naa o hiitoo ɓe, kanko nii Alla lili he maɓɓe. Har hunnduko maleykaajo bannganɗo mo, Alla waɗi mo ardiiɗo e coptinoowo maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","*Muusa oon duu nii, wurtini ɓe nder leydi Misira. Nder duuɓi lasooji ɗiɗi, o waɗi kaayɗe e alamaaji gom nder Misira, nder maayo Maaliya he nder ladde yeeruure. ");
INSERT INTO fuh_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","*Muusa gooto oon duu wi'unoo Isra'ilankooɓe : Alla no lildan on annabiijo gom hano am, burtotooɗo hakkune mooɗon. ");
INSERT INTO fuh_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Wakkati jama'aare ndeen hawrunoo nder ladde yeeruure, *Muusa laatii naatuɗo hakkune maamiraaɓe meeɗen he maleykaajo bannganɗo mo dow waamnde *Sinayi. Kanko duu heɓi haalaaji kokkooji mbuurnam, hokki en ɗi. ");
INSERT INTO fuh_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Amma maamiraaɓe men tokkaay ko o wi'i. Ɓe calii mo, hakkillooji maɓɓe fuu kuybiti har Misira. ");
INSERT INTO fuh_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Nden ɓe mbi'i Haaruuna waɗana ɓe tooruure ardotoone ɓe ngam hakiika *Muusa wurtini ɓe nder Misira amma ɓe anndaa fuu ko heɓi mo. ");
INSERT INTO fuh_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Nder balɗe mum ɓe ngaɗi ga'el gom, ngel laatii tooruure maɓɓe. Ɓe ngaɗani ngel *sadaka, ɓe nani belɗum golle juuɗe maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Amma Alla duu tottiti ɓe, acci ɓe, ɓe ndewa koode hano no ɗum winndiraa nder dewtere annabiiɓe. Alla wi'i nder mayre : Onon himɓe *Isra'el, duuɓi lasooji ɗiɗi ɗii fuu ɗi ngaɗuɗon nder ladde yeeruure, on cakkanii kam ndabba naa on ngaɗanii kam *sadaka gom ? ");
INSERT INTO fuh_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Aa'a. On ndonndaakina hukumuuru Moloko, tooruure mon e Refan, hoodere nde ndewuɗon, ngam ndewon tooruuje ɗee, waɗi ngaɗuɗon ɗe. Miin duu, mi waɗan nanngeɗon, njaareɗon nder leydi *Baabiila. ");
INSERT INTO fuh_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","—Nder ladde yeeruure ndeen, maamiraaɓe meeɗen no ngoodunoo *hukumuuru, nyiɓaanu hano no Alla tinndiniri *Muusa nyiɓol mayru nii. Kayru hollata Alla no wondi he maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","*Hukumuuru ndu maamiraaɓe meeɗen ndoni, kayru ɓe njaari nder leydi ndi ɓe koni, ɓe teeti he lenyi gom ɗi Alla riiwi yeeso maɓɓe nder ardaaki Yosu'a. Ndu jooɗake faa nder jamaanu Daawda, ");
INSERT INTO fuh_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","keɓuɗo moƴƴere Alla Yakuuba. Daawda tefi laawol he makko ngam nyiɓande mo suudu nder mayri, ");
INSERT INTO fuh_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","amma Suleymaanu nyiɓi ndu. ");
INSERT INTO fuh_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Dey Alla Toowɗo jooɗotaako nder suudu ndu ɓiɓɓe aadama nyiɓi hano no o wi'iri ɗum har kunndule annabiiɓe, wakkati o wi'unoo : ");
INSERT INTO fuh_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Kammu woni jooɗorde laamu am leydi woni njaaɓirdi koyɗe am. Suudu nduye, nyiɓanton kam ? Toy woni nokkuure nde powtanmi ? ");
INSERT INTO fuh_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Hanaa junngo am tagi huune fuu naa ? ");
INSERT INTO fuh_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","—Onon tiɓɓe-nyiireeɓe, ɓe ɓerɗe mum'en tottiti Alla, ɓe noppi mum'en cukki. Wakkati fuu oɗon caloo *Ruuhu Ceniiɗo, onon he maamiraaɓe mooɗon on fuu on go'o. ");
INSERT INTO fuh_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Annabiijo oye non maamiraaɓe mooɗon torraay ? Ɓe mbari duu annabiiɓe, haalunooɓe illa hanaa hannden dow garki Dartiiɗo, gorko oo mo njammbiɗon, mbarɗon. ");
INSERT INTO fuh_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Onon keɓuɓe *Tawreeta he juuɗe maleykaaɓe, on njogaaki nde. ");
INSERT INTO fuh_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Wakkati hawriine dawrooɓe ndeen nanunoo haalaaji Etiyen ɗii, ɓe nani mone makko sanne sanne faa iɓe ƴakkana mo nyiiƴe. ");
INSERT INTO fuh_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Amma Etiyen keewɗo *Ruuhu Ceniiɗo, ndarii no tiggitii kammu. Sey o hi'i teddungal Alla, o hi'i Iisa no ndarii nyaamo Alla. ");
INSERT INTO fuh_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Nden o wi'i : —Ndaa ! Kammu nii no udditii, miɗo hollira *Ɓii-Neɗɗo no darii nyaamo Alla. ");
INSERT INTO fuh_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ɓe cukki noppi maɓɓe, ɓe kuuɓi sanne, ɓe fuu, ɓe pa'i mo. ");
INSERT INTO fuh_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ɓe pooɗi mo, ɓe mburtini nder huɓeere ndeen. Nden ɓe tinni iɓe paɗɗira mo kaaƴe faa ɓe mbara mo. Seediiɓe ɗum ɓorti kolte mum'en kalfini jokolle gom bi'eteeɗo Sol. ");
INSERT INTO fuh_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Wakkati ɓe ngonnoo iɓe paɗɗira mo kaaƴe, o du'ii, o wi'i : —Yaa Iisa Joomam ! Jaɓɓa yonki am ! ");
INSERT INTO fuh_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Nden o dicci, o huuɓi, o wi'i : —Yaa Joomiraawo ! To nanngir ɓe hakke oo. Nden yonki makko saami. ");
INSERT INTO fuh_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sol yardake he barol Etiyen. Nyannde maayde Etiyen, nyannde mum nder huɓeere *Ursaliima torra mawka fuɗɗani hawriine goonɗinɓe Iisa. Goonɗinɓe ɓeen fuu ndoggi cankiti nder leydi Yahudiya e leydi *Samariya acci *lilaaɓe ɓeen tan. ");
INSERT INTO fuh_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Worɓe hulooɓe Alla gom mooɓi Etiyen, ɓe nani naawɗum maayde makko, ɓe mboyi sanne. ");
INSERT INTO fuh_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Amma Sol kay, no durwa sankita hawriine goonɗinɓe Iisa. Omo naata suudu yahde suudu, omo nannga semmbe semmbe gorko e debbo maɓɓe, omo udda. ");
INSERT INTO fuh_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Goonɗinɓe sankitaaɓe ɓeen tinni no mbaajoo *Habaru lobbo oon nokku fuu to ɓe njehi. ");
INSERT INTO fuh_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Nder wakkati mum Filipa yehi nder huɓeere *Samariya mawne gom omo waajoo himɓe filla Iisa *Almasiihu. ");
INSERT INTO fuh_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Wakkati ɓe ngi'unoo kaayɗe e kujje ɗe o woni omo waɗa, himɓe fuu no ngara no kettino waaju makko he hakkillo. ");
INSERT INTO fuh_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Himɓe heewɓe nder maɓɓe, woodunooɓe ginnaaji bonɗi, ginnaaji ɗiin no kacca sanne no njippo dow maɓɓe, bonnguuɓe ɗuɓɓe, he laƴooɓe njamɗiti. ");
INSERT INTO fuh_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ɗum laatii welwelo manngo nder huɓeere ndeen. ");
INSERT INTO fuh_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Nder wakkati mum, gorko gom bi'eteeɗo Simon no tawa nder huɓeere ndeen. Omo waɗa dobo-dobooji, iɗum haayɗina himɓe, omo ada hoore makko no o goɗɗum. ");
INSERT INTO fuh_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Himɓe fuu, gorko yahde debbo no teddina mo no mbi'a : —Golle gorko oo no baawɗe Alla bi'eteeɗe Baawɗe Mawɗe. ");
INSERT INTO fuh_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Iɓe kettinanoo mo sanne ngam ɗum ɓooyi ko golleeji makko no kaayɗina ɓe. ");
INSERT INTO fuh_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Amma wakkati ɓe ngoonɗinnoo *Habaru lobbo dow filla Laamu Alla he dow filla Iisa *Almasiihu, Habaru mo Filipa woni no waajoo oon, gorko yahde debbo maɓɓe tinni no hokka hoore mum no waɗanee *batisma. ");
INSERT INTO fuh_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simon duu goonɗini, waɗana *batisma. O woɗɗaaki Filipa kaden. Omo hi'a kaayɗe he alamaaji ɗi Filipa woni no waɗa, ɗum haayɗini mo. ");
INSERT INTO fuh_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","*Lilaaɓe wonɓe nder *Ursaliima nani ko himɓe *Samariya ngoonɗini haala Alla, nden ɓe lili Piyer e Yahaaya to maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Wakkati ɓe njottinoo nder leydi *Samariya, ɓe njippi to goonɗinɓe ɓeen. Ɓe ndu'ani ɓe heɓa *Ruuhu Ceniiɗo jippoo dow maɓɓe, ");
INSERT INTO fuh_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","ngam *Ruuhu Ceniiɗo jippaaki dow baa gooto maɓɓe ginan. Dow innde Iisa Joomiraawo tan ɓe ngaɗana *batisma. ");
INSERT INTO fuh_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Nden Piyer e Yahaaya njowi juuɗe dow maɓɓe, sey *Ruuhu Ceniiɗo jippii dow maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Wakkati Simon hi'unoo *lilaaɓe ɓeen njowi juuɗe mum'en dow goonɗinɓe ɓeen, *Ruuhu Ceniiɗo duu jippii dow maɓɓe, o waddi ceede. ");
INSERT INTO fuh_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","O wi'i ɓe : —Miin duu, kokkaree he baawɗe ɗee, ngam mo ndekumi juuɗe dow mum fuu heɓa *Ruuhu Ceniiɗo oo. ");
INSERT INTO fuh_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Amma Piyer jaabii mo wi'i : —Aɗa miila ko ceede coodirtaa kokkal Alla ngal naa ? Alla halke, aan e ceede maa fuu. ");
INSERT INTO fuh_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","A walaa mbaka fuu, a ronataa duu gollal ngal, ngam ɓerne maa dartinaaki yeeso Alla. ");
INSERT INTO fuh_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Tuubu ngam dabareeji maa bonɗi, eela Alla, tawte o yaafante iri anniyaaji maa ɗii. ");
INSERT INTO fuh_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ngam mi hi'i ɓerne maa no ɓawli sanne, a maccuɗo hakke duu. ");
INSERT INTO fuh_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Nden Simon jaabii ɓe wi'i : —Too, onon he ko'e mon, ndu'anee kam, eelanon kam Joomiraawo ngam baa gootel nder ko mbi'uɗon ɗum fuu to heewtoo kam. ");
INSERT INTO fuh_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Wakkati ɓe ngayni tabbintinande ɓiɓɓe leydi *Samariya haala goonɗinol Iisa, he waajaade haala Joomiraawo, ɓe coƴƴi *Ursaliima. Iɓe njaha, iɓe mbaajoo *Habaru lobbo oon nder wurooji *Samariya ɗuɗɗi tawaaɗi dow laawol maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Nyannde gom Maleykaajo Joomiraawo gom wanngani Filipa wi'i mo : —Umma, yah har hoore huɗo, tokka laawol boppaangol ngool, laawol ƴuwrowol *Ursaliima no yaha Gaaja. ");
INSERT INTO fuh_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Filipa ummii, dilli. Wakkati o yehannoo ndeen, sey o fotti he Etiyopiyanke gom, jehunooɗo *Ursaliima ngam teddinde Alla no warta no ƴuwa *Ursaliima. Gorko oo no mantaaɗo, kanko duu hakkilii ceede Kandake, debbo laamiiɗo leydi Etiyopiya. ");
INSERT INTO fuh_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Wakkati o hootanoo, omo jooɗii nder torko pucci makko, omo jannga dewtere annabi *Esaaya. ");
INSERT INTO fuh_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Sey *Ruuhu Alla wi'i Filipa : —Doggu, hewtowa jom torko oo. ");
INSERT INTO fuh_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Nden Filipa doggi hewtowi mo. Wakkati o yottinoo, sey o nani gorko oon no jannga ko annabi *Esaaya winndunoo nder dewtere mum. Nden Filipa ƴami gorko oon wi'i mo : —Aɗa faama ko ngonɗaa aɗa jannga ɗum naa ? ");
INSERT INTO fuh_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Nden gorko oon jaabii mo wi'i : —Noy paamiranmi ɗum, nde goɗɗo famtinaay kam ? Sey o wi'i Filipa ŋabba jooɗo hadde makko. ");
INSERT INTO fuh_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Aayaaje ɗe o wonnoo omo jannga nder dewtere ɗeen nii : Omo nanndi he mbaalu njaareetengu hirsirde. Hano jawngel deƴƴungel, no maɓɓi hunnduko, wakkati ngel femmbetee. ");
INSERT INTO fuh_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ɓe cemtini mo, o hiitanaaka e goonga. Moy waawi fillaade habaru jippotooɓe he makko, ngam ɓe itti yonki makko nder duuniyaaru nduu. ");
INSERT INTO fuh_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Nden Etiyopiyanke oon ƴami Filipa wi'i : —Famtina. Dow moy aayaaje ɗee ngoni no kaala ? Annabiijo oon he hoore mum ɗe ngondi naa neɗɗo fereejo gom. ");
INSERT INTO fuh_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Sey Filipa fuɗɗi famtinde mo maana majji faa o yottii he *Habaru Iisa lobbo oon. ");
INSERT INTO fuh_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Iɓe njaha yahde faa ɓe njottii feto gom, sey Etiyopiyanke oon wi'i Filipa : —Ndaa ndiyam nii. Ɗume waawi haɗude, mi waɗanee *batisma ?  ");
INSERT INTO fuh_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Sey Filipa jaabii mo wi'i : —Nde nii a goonɗini he ɓerne worre, aɗa waawi waɗaneede *batisma. Etiyopiyanke oon wi'i mo : —Mi goonɗini ko Iisa *Almasiihu no *ɓii-Alla. ");
INSERT INTO fuh_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Nden o wi'i torko oon darnee. Ɓe njippi nder ndiyam ɗam, Filipa waɗani mo *batisma. ");
INSERT INTO fuh_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Wakkati ɓe mburtotonoo nder ndiyam ɗam, sey *Ruuhu Joomiraawo adi Filipa. Gorko oon yeeƴitaaki hi'i mo kaden, tokki laawol mum nder welwelo. ");
INSERT INTO fuh_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filipa duu yehi Ajotus. Omo yaha, omo waajoo wurooji tawaaɗi dow laawol makko fuu faa o yottii nder wuro wi'eteengo Kaysariya. ");
INSERT INTO fuh_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Sol no torra *aahiiɓe Joomiraawo ɓeen sanne, faa omo wi'a o waran ɓe. Nyannde gom o yehi o tawowi mawɗo *cakkanooɓe Alla ɓeen fuu, ");
INSERT INTO fuh_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","o ƴami mo, o winnda ɗerol hokkude mo laawol naatude cuuɗi *baajorɗi huɓeere Damas ngam nanngude gorko e debbo tokkuɓe laawol Iisa *Almasiihu, o uddowa ɗum'en nder kasu *Ursaliima. ");
INSERT INTO fuh_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Wakkati o wonnoo dow laawol Damas faa o faani huɓeere ndeen, sey jeyngol gom ƴuwi dow huuri mo. ");
INSERT INTO fuh_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","O saami, sey o nani daane gom no wi'a mo : —Sol ! Sol ! Ɗume waɗi aɗa torra kam ? ");
INSERT INTO fuh_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Nden o jaabii nde o wi'i : —Aan woni moy Joomiraawo ? Daane ndeen nooti mo wi'i : —Miin woni Iisa mo ngonɗaa aɗa torra. ");
INSERT INTO fuh_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Amma jooni, umma naatu nder huɓeere ndee, toon kaalanteɗaa ko kaanuɗaa waɗude. ");
INSERT INTO fuh_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ɗowtuɓe mo fuu ndarii no ndaara, keppi fuu ko mbi'ata. Ɓe nani daane ndeen kay, amma ɓe ngi'aay neɗɗo fuu. ");
INSERT INTO fuh_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sol ummii darii, no futtina gite amma o hi'ataa yeeso makko baa seɗɗa. Ɓe nanngi junngo makko, ɓe ɗowi mo faa nder huɓeere Damas. ");
INSERT INTO fuh_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Balɗe tati o waawtaa hi'i, o nyaamata, o yarataa. ");
INSERT INTO fuh_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Nder Damas no tawanoo aahiijo Iisa gom bi'eteeɗo Ananiyas. Joomiraawo wannginani mo, wi'i mo : —Ananiyas ! O jaabii, o wi'i : —Miin nii, Joomiraawo ! ");
INSERT INTO fuh_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Nden Joomiraawo wi'i mo : —Umma jooni jooni, njahaa dow beddawol bi'eteengol Laawol Portiingol. Naataa ɓaade Yahuuda, ƴamaa moy woni bi'eteeɗo Sol ƴuwɗo Tarsus. Jooni to o woni fuu, omo ɗon omo du'oo. ");
INSERT INTO fuh_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Mi wannginani mo, o hi'i gorko gom bi'eteeɗo Ananiyas no deka juuɗe mum dow makko ngam o hepta gite makko. Aan duu woni gorko oo. ");
INSERT INTO fuh_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananiyas jaabii wi'i : —Joomiraawo, himɓe heewɓe kaalani kam, bone fuu mo gorko oo waɗani goonɗinɓe maa nder *Ursaliima. ");
INSERT INTO fuh_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","O heɓi duu to mawɓe *cakkanooɓe Alla laawol garki nder wuro ngoo ngam nanngude noddoowo innde maa fuu. ");
INSERT INTO fuh_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Nden Joomiraawo wi'i : —Ananiyas, umma, yah ngam mi suɓake gorko oo ngollana kam. O waajoo innde am hakkune lenyi ɗuɗɗi e laamiiɓe mum'en. O waajoo nde duu hakkune Isra'ilankooɓe. ");
INSERT INTO fuh_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Mi hollan mo kaden duu ko no tilsi o torree torraaji keewɗi ngam sabbu am. ");
INSERT INTO fuh_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Nden Ananiyas ummii yehi ɓaade Yahuuda, naatowi nder suudu ndu Sol weeri nder mum. O deki juuɗe makko dow Sol o wi'i mo : —Banndam, Iisa Joomiraawo meeɗen bannganɗo ma dow laawol oo wakkati ngarannoɗaa ndeen, lili kam ngam mbumtaa, keewa *Ruuhu Ceniiɗo. ");
INSERT INTO fuh_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Wakkati mum da koɓitte gom koɓɓiti, ƴuwi he gite makko caami. O hepti gite makko. O ummii, o darii, o waɗana *batisma. ");
INSERT INTO fuh_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","O nyaami, nden semmbe makko warti. Sol jooɗii to *aahiiɓe Damas balɗe seɗɗa. ");
INSERT INTO fuh_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Nder balɗe mum, omo naata nder *baajorɗi Damas omo waajoo, omo wi'a Iisa no *Ɓii-Alla. ");
INSERT INTO fuh_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Nanuɗo haala kaa fuu, ɗum haayɗina ɗum. Nden ƴama hoore mum wi'a : —Hanaa yaa gorko oo wonnoo no torra faa noy walaa goonɗinɓe Iisa nder *Ursaliima ? Naa o waru non yaa goonga e goonga ngam eytude ɓe, o nannga ɓe o yaara to mawɓe *cakkanooɓe Alla ? ");
INSERT INTO fuh_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Wakkati fuu mo o waajotoo, omo holla himɓe wuro ngoon, ko sikka fuu walaa Iisa woni *Almasiihu Alla faa joonkay ɓe mbaawtaa mbi'i goɗɗum kaden. ");
INSERT INTO fuh_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Balɗe no njeha, balɗe no ngarta, sey nyannde gom *Yahudankooɓe kawri ngaɗi haɓɓi-daane ngam mbara Sol. ");
INSERT INTO fuh_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Nden ɓe ngaɗi dammbule wuro ngoon fuu ndoomee jemma e nyalooma ngam ɓe nannga mo, ɓe mbara. Amma Sol heɓi habaru haɓɓi-daane maɓɓe ndeen. ");
INSERT INTO fuh_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Sey jemma gom aahiiɓe makko adi mo ngatti nder hanndeere, njaari mo senngo birniyol wuro ngoon juri mo yaasin. ");
INSERT INTO fuh_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Wakkati Sol warnoo nder *Ursaliima, o tefi jooɗaade nder hawriine *aahiiɓe Iisa gom amma ɓe koolaaki mo. Ɓe fuu iɓe kula mo ngam ɓe tabbintinaay goonga e goonga ko o aahiijo Iisa. ");
INSERT INTO fuh_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Nden Barnabas adi mo, yaari to *lilaaɓe ɓeen. O fillanii ɓe fuu noy Sol hi'iri Joomiraawo, he no Joomiraawo haaldiri he makko dow laawol Damas. Barnabas fillanii ɓe duu ko Sol hulaay hitere fuu, o waajake dow innde Iisa nder huɓeere Damas goonga e goonga. ");
INSERT INTO fuh_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Illa nyannde mum Sol jooɗii hakkune maɓɓe, omo fiilido he maɓɓe, omo waajoo dow innde Iisa nder *Ursaliima he ɓerne worre. ");
INSERT INTO fuh_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Omo waajoo *Yahudankooɓe haalooɓe gerekankoore, omo yeddodira he maɓɓe, kamɓe duu iɓe tefa warude mo. ");
INSERT INTO fuh_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Wakkati banndiraaɓe makko goonɗinɓe Iisa nanunoo ɗum, ɓe njaari mo nder huɓeere Kaysariya, nden ɓe lili mo Tarsus. ");
INSERT INTO fuh_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Illa wakkati mum hawriine goonɗinɓe Iisa heɓi jam nder leydi Yahudiya, Galili e *Samariya fuu. Hawriine maɓɓe no ɓeydoo yahde, inde semmbiɗa. Inde ɓeyda kulal Joomiraawo, inde ɓeyda himɓe, *Ruuhu Ceniiɗo no wondi he maɓɓe no semmbinɗina ɓe. ");
INSERT INTO fuh_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Wakkati Piyer wonnoo no fiiloo hakkune leydi *Samariya he leydi Yahudiya, o weerani goonɗinɓe Iisa wonɓe nder huɓeere Lidda. ");
INSERT INTO fuh_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Nyannde mum o tawi Ayne'as, gorko bonngiriiɗo duuɓi jeetati no fukkii dow daago mum. ");
INSERT INTO fuh_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Sey Piyer wi'i mo : —Ayne'as, Iisa *Almasiihu nyawti ma ! Umma, taggu daago maa. Sey o ummii. ");
INSERT INTO fuh_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Wakkati himɓe Lidda he himɓe leydi Saron ngi'unoo mo, ɓe fuu ɓe tuubii ɓe ngoonɗini Joomiraawo. ");
INSERT INTO fuh_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Nder huɓeere Yoppe, no woodunoo aahiijo Iisa debbo gom bi'eteeɗo Tabita, Dorkas nder gerekankoore, kam woni « lella ». Wallude talkaaɓe e gollude ko wooɗi tan debbo oo anndira. ");
INSERT INTO fuh_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Nder balɗe Piyer wonnoo nder Lidda no fiiloo, debbo oo jontaa, maayi. O lootaa, o wattowaa nder suudu wonndu dow gom. ");
INSERT INTO fuh_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Yoppe woɗɗaa Lidda. Wakkati *aahiiɓe Iisa ɓeen nanunoo ko Piyer no nder Lidda, sey ɓe ummini worɓe ɗiɗo gom njaha mbi'owa mo, o yaawɗo o wara Yoppe. ");
INSERT INTO fuh_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Worɓe ɓeen njottini lilal ngal, nden Piyer ummii tokki ɓe. Wakkati o yottinoo ndeen, ɓe njaari mo to maayɗo oon. Rewɓe ɓe goriraaɓe mum'en maayi gom ɓadii no mbulla, no kolla kolte ɗe maayɗo oon waɗannoo ɓe. ");
INSERT INTO fuh_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Piyer wi'i himɓe fuu mburtinee, o hofi, o du'i, o huybiti har maayɗo oon, wi'i mo : —Tabita, umma ! Sey Tabita fiirti gite mum, hi'i Piyer, ummii, jooɗii. ");
INSERT INTO fuh_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Nden Piyer nanngi junngo makko, darni mo. Piyer noddi ɓe goriraaɓe mum'en maayi ɓeen e worɓe goonɗinɓe tawaaɓe ɗon ɓeen, holli ɓe Tabita no foofaa. ");
INSERT INTO fuh_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Habaru oon sankitii nder huɓeere Yoppe fuu, walaa fuu mo nanaay mo. Himɓe ɗuɓɓe ngoonɗini Joomiraawo. ");
INSERT INTO fuh_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Piyer jooɗii balɗe seɗɗa nder Yoppe nder ɓaade gargasaajo gom bi'eteeɗo Simon. ");
INSERT INTO fuh_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Nder Kaysariya no tawa gorko gom bi'eteeɗo Korneliyus, mawɗo sewre soogeeji inndirteene « nde Italiya ». ");
INSERT INTO fuh_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Korneliyus no wakkiliiɗo he Alla. Kanko he koreeji makko fuu, ɓe hulooɓe Alla. Omo walla faa noy walaa *Yahudankooɓe ɓe ngalaa, omo du'oo, omo eela Alla wakkati fuu. ");
INSERT INTO fuh_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Nyannde gom, nyalooma har yamnde tati maleykaajo gom wanngani mo, wari no wi'a mo : —Korneliyus ! ");
INSERT INTO fuh_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","O darii o daari maleykaajo oon faa wooɗi, omo diwna, o jaabii o wi'i : —Joomam, ɗume ngiɗaa ? Nden maleykaajo oon wi'i mo : —Joomiraawo jaabake du'aa'uuji maa, omo hi'a duu balla ka ngonɗaa aɗa waɗana talkaaɓe. O yeggitaay ma. ");
INSERT INTO fuh_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Joonin waɗu lilaaɓe njeha Yoppe noddowa Simon inndirteeɗo Piyer. ");
INSERT INTO fuh_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Omo wuro gargasaajo bi'eteeɗo Simon, mo wuro mum tawa daane maayo. ");
INSERT INTO fuh_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Wakkati maleykaajo oon dillunoo, Korneliyus noddi gollooɓe mum ɗiɗo gom, he soogeeru kulooru Alla gom wonndu wuro makko. ");
INSERT INTO fuh_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","O fillani ɓe ko maleykaajo oon wi'unoo mo fuu, nden o lili ɓe Yoppe. ");
INSERT INTO fuh_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Jaangoore dilludu lilaaɓe Korneliyus, wakkati ɓe ngonnoo dow laawol faa ɓe paani Yoppe. Caka nyalooma, fotodiri Piyer duu ƴeenyi dow suudu to o weerunoo faa o du'oo. ");
INSERT INTO fuh_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Wakkati o wonnoo omo du'oo, rafo nanngi mo sanne faa omo suuna nyaamdu. Wakkati o waɗantenoo nyaamdu ndeen, sey Alla wannginani mo, ");
INSERT INTO fuh_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","o hi'i kammu maɓɓiti, goɗɗum nannduɗum he guda mannga no jippinee, yahde har makko. Kunndule majjum nay ɗeen fuu no njogaa. ");
INSERT INTO fuh_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Nder mayre no tawa dabbaaji iri iriiji fuu : Dabbaaji ɗi koyɗe nay, ɓodooji, he pooli iri iriiji fuu. ");
INSERT INTO fuh_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Sey daane gom wi'i mo : —Piyer, umma, hirsu, nyaama ! ");
INSERT INTO fuh_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Nden Piyer jaabii, wi'i : —Aa'a, Joomam ! Abada mi nyaamaay ko harmi naa ko nyiddinii yeeso Alla. ");
INSERT INTO fuh_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Sey daane ndeen wi'i mo kaden : —Ko Alla harminaay, to hooƴu ɗum ko harmi. ");
INSERT INTO fuh_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ɗum waɗi faa nde tati. Sey guda ngaan ƴencinaa. ");
INSERT INTO fuh_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Huune ndee wemmbii Piyer. O tinni omo ƴama hoore makko maana ko o hi'i ɗum. Wakkati o ƴamannoo hoore makko maana ko o hi'i ɗum, tawi lilaaɓe Korneliyus ɓeen tefiino faa ngiiti wuro Simon gargasaajo oon. Kamɓe duu nii no ndarii dammbugal makko. ");
INSERT INTO fuh_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ɓe calmini ɓe ƴami se Piyer no ɗon. ");
INSERT INTO fuh_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Sey *Ruuhu Ceniiɗo wi'i Piyer : —Worɓe tato gom nii no ƴamane, ");
INSERT INTO fuh_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","njippaa yah to maɓɓe, to dara fuu mbi'a goɗɗum, miin waɗi ɓe lilaa he maaɗa. ");
INSERT INTO fuh_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Nden Piyer jippii, wari to worɓe ɓeen, o wi'i ɓe : —Miin woni Piyer mo ƴamanton. Jam nda waddi on ɗo ? ");
INSERT INTO fuh_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Nden ɓe mbi'i mo : —Korneliyus, mawɗo soogeeji *Rooma kam lili min. Gorko non dartiiɗo, kuloowo Alla. Filla golle makko lobbe no dow ɗemle *Yahudankooɓe fuu. Maleykaajo ceniiɗo gom wanngani mo, wi'i, o waɗa lilaaɓe noddowee ngam no woodi ko mbi'ata mo. ");
INSERT INTO fuh_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Nden Piyer weerni ɓe. Jaangoore mum, o ummii, o tokki ɓe, ɓe pa'idi Kaysariya. *Yahudankooɓe goonɗinɓe Iisa gom jeyaaɓe Yoppe ɗowtiri mo, ɓe njahdi Kaysariya. ");
INSERT INTO fuh_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Faɓɓi-jaangoore mum Piyer he ɗowtirɓe ɗum njottii Kaysariya. Ɓe tawi Korneliyus hawri lenyi mum he higiraaɓe mum fuu, iɓe keɗi Piyer. ");
INSERT INTO fuh_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Wakkati Piyer naatannoo ndeen, Korneliyus ummii jaɓɓitii mo, sujidani mo. ");
INSERT INTO fuh_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Sey Piyer nanngi mo ummini, wi'i : —Umma, miin he hoore am mi ɓii-aadama. ");
INSERT INTO fuh_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Nden ɓe puɗɗi iɓe njewta. Piyer e Korneliyus naati nder ɓaade, sey Piyer tawi jama'aare no hawri no doomi ɗum. ");
INSERT INTO fuh_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Nden o wi'i ɓe : —Onon he ko'e mooɗon, oɗon anndi ko no harmi Yahudanke hawta he lenyol gom naa yaha wuro mo hanaa Yahudanke. Amma miin, Alla hollii kam ko neɗɗo fuu haana wi'ude goɗɗo no karmuɗo naa no nyiddiniiɗo yeeso mum. ");
INSERT INTO fuh_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ngam majjum waɗi wakkati liluɗon mi noddowee, mi daraaki fuu mi wi'a goɗɗum. Joonin, miin nii, miɗo hiɗi mi faama ko waɗi noddanɗon kam ? ");
INSERT INTO fuh_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Korneliyus jaabii, wi'i : —Balɗe nay nii, nyannde gom har yamnde tati nyalooma, miɗo nder suudu am, caka du'aa'u, sey gorko ɓorniiɗo kolte ƴelkitooje gom wanngi yeeso am. ");
INSERT INTO fuh_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Gorko oon wi'i kam : « Korneliyus, Alla jaabake du'aa'uuji maa, o hi'i duu ko ngonɗaa aɗa waɗana talkaaɓe. ");
INSERT INTO fuh_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Waɗu lilaaɓe njahaa Yoppe noddowa Simon inndirteeɗo Piyer. Omo daane maayo, wuro gargasaajo bi'eteeɗo Simon. » ");
INSERT INTO fuh_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ngam majjum waɗi ngaɗumi noddeɗaa, mi daraaki fuu ndoomumi goɗɗum. A wonnii duu ko ngarɗaa. Joonin min fuu miɗen ɗo ngam hettinaade ko mbi'ataa min nder ko Joomiraawo holli ma fuu. ");
INSERT INTO fuh_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Nden Piyer itti hunnduko, wi'i : —Joonin, tabbat sikka fuu walaa, Alla walanaa oo naa ooto. ");
INSERT INTO fuh_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Neɗɗo fuu huli Joomiraawo, teddini mo, waɗi ko wooɗi he ko dartii, joomum welan Alla. ");
INSERT INTO fuh_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Alla lildi haala mum dow ɓiɓɓe *Isra'el fuu. O waɗani ɓe filla *Habaru lobbo, Habaru jom jam har Iisa *Almasiihu, Joomiraawo himɓe fuu. ");
INSERT INTO fuh_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Oɗon anndi ko waɗi nder leydi Galili faa sankitii nder leydi Yahudiya fuu gaɗa waaju he batismaaji ɗi Yahaaya waɗani himɓe. ");
INSERT INTO fuh_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Oɗon anndi no Alla jippiniri baawɗe *Ruuhu Ceniiɗo dow Iisa mo Nasaratu. Oɗon anndi duu no Iisa fiilori nder leydi ndiin fuu no golla golleeji lobbi, no soptina wonɓe nder maccangaaku Ibiliisa. Iisa waɗi kujje ɗee fuu ngam Alla no wondi he makko. ");
INSERT INTO fuh_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Minen, min ceedake ko o waɗi fuu nder leydi Yahudiya he nder *Ursaliima. Ɓe tontii mo dow *leggal bardugal, ɓe mbari mo. ");
INSERT INTO fuh_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Amma balɗe tati gaɗa mum Alla ummintini mo, hokki mo baawɗe wanngande himɓe. ");
INSERT INTO fuh_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Amma o wannganaay neɗɗo fuu nde hanaa minen, ɓe Alla suɓii ngam seedanaade mo. Min nyaamdi, min njardii he makko gaɗa ummitaaki makko. ");
INSERT INTO fuh_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","O wi'i min duu, min mbaajoo himɓe, min kolla ɓe ko kanko Alla suɓii waɗi kiitotooɗo wuurɓe he maayɓe. ");
INSERT INTO fuh_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Annabiiɓe fuu kaali dow makko mbi'i neɗɗo fuu goonɗini mo, hakkeeji mum no njaafetee ngam sabbu makko. ");
INSERT INTO fuh_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Wakkati Piyer wonnoo no waajoo, sey *Ruuhu Ceniiɗo jippii dow hettiniiɓe ɓeen fuu. ");
INSERT INTO fuh_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Keɓal *Ruuhu Ceniiɗo ɓe kanaa *Yahudankooɓe ngaal, haayɗini *Yahudankooɓe goonɗinɓe tokki Piyer ngari ɓeen. ");
INSERT INTO fuh_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Ɓe nani, ɓe kanaa *Yahudankooɓe ɓeen no njetta Alla nder ɗemle ɗe ɓe meeɗaay nanude. Nden Piyer jaabii ɓe, wi'i : ");
INSERT INTO fuh_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","—Jooni himɓe ɓee, ɓe ngi'oton, keɓi *Ruuhu Ceniiɗo mo keɓunoɗen. No woodi baawɗo haɗude ɓe ngaɗanee *batisma naa ? ");
INSERT INTO fuh_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Nden Piyer hokki laawol ɓe ngaɗanee *batisma nder innde Iisa *Almasiihu. Gaɗa gaɗol *batisma ngool, ɓe eeli Piyer jooɗo, waɗana ɓe balɗe seɗɗa. ");
INSERT INTO fuh_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","*Lilaaɓe ɓeen he goonɗinɓe tawaaɓe nder leydi Yahudiya nani ko ɓe kanaa *Yahudankooɓe duu njaɓi haala Alla. ");
INSERT INTO fuh_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Wakkati Piyer wartunoo *Ursaliima, *Yahudankooɓe goonɗinɓe, tiiɗuɓe he juulnol janci mo, ");
INSERT INTO fuh_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","mbi'i : —A weerani ɓe njulnaaka, a nyaamdi he maɓɓe ! ");
INSERT INTO fuh_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Nden Piyer fillani ɓe no ɗum waɗiri, o wi'i ɓe : ");
INSERT INTO fuh_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","—Nder Yoppe, nyannde gom, wakkati ngonnoomi, miɗo du'oo, sey kollaami goɗɗum nannduɗum he guda gom. Kunndule magga nay fuu no njogaa, ɗum ƴuwi dow, iɗum fa'i har am. ");
INSERT INTO fuh_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ndariimi, tiimumi ɗum faa wooɗi, sey ngi'umi dabbaaji ɗi koyɗe nay, dabbaaji ɓodooji e pooli ir iriiji nder majjum. ");
INSERT INTO fuh_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Nden nanumi daane gom no wi'a kam : « Piyer, umma, hirsu, nyaamu ! » ");
INSERT INTO fuh_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Njaabiimi nde mbi'umi : « Joomam ! Abada abadilla mi nyaamaay ko harmi naa ko nyiddinii yeeso Alla. » ");
INSERT INTO fuh_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Sey nde wi'i kam kaden : « Ko Alla harminaay, to hooƴu ɗum ko harmi. » ");
INSERT INTO fuh_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Kile tati iɗum waɗa, nden guda ngaan ƴeenyina dow. ");
INSERT INTO fuh_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Nder wakkati mum, worɓe tato gom ƴuwi faa Kaysariya ngari to am. ");
INSERT INTO fuh_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Sey *Ruuhu Ceniiɗo wi'i to mi daroo fuu mi wi'a goɗɗum, mi ummoo, mi yahda he maɓɓe tan. Nden min njahdi Kaysariya, min naati faa nder ɓaade Korneliyus. Worɓe goonɗinɓe jeegom gom tokki min. ");
INSERT INTO fuh_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Wakkati min fuu min ngonnoo nder ɓaade makko, o fillanii min no o hi'iri maleykaajo bannganɗo mo caka mayre, wi'i mo o waɗa mi noddowee. ");
INSERT INTO fuh_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Mi wara mi waajoo, waaju kisinoowo mo kanko he ɓaade makko. ");
INSERT INTO fuh_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Wakkati puɗɗumi waajaade, sey *Ruuhu Ceniiɗo jippii dow maɓɓe hano no o jipporinoo dow amin illa arannde. ");
INSERT INTO fuh_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Nden miccitiimi he ko Joomiraawo wi'i, wakkati o wi'unoo : « Yahaaya, ndiyam waɗiranannoo himɓe *batisma. Amma onon, *batisma mooɗon, *Ruuhu Ceniiɗo waɗirtee. » ");
INSERT INTO fuh_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Nde nii Alla hokki ɓe huune fuu ko o hokkunoo min wakkati min ngoonɗinnoo Iisa *Almasiihu Joomiraawo meeɗen. Ndenne noy potumi faa mi heppora Alla, mi fonna hoore am he makko ? ");
INSERT INTO fuh_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Wakkati *Yahudankooɓe goonɗinɓe ɓeen nanunoo haalaaji ɗii, ɓe fuu ɓe peewi. Nden ɓe tinni, iɓe njetta Alla, iɓe mbi'a : —Jaa ! Alla hokki ɓe kanaa *Yahudankooɓe duu laawol tuubude he heɓude mbuurnam nduumiiɗam. ");
INSERT INTO fuh_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Torra umminooka faa Etiyen waraa kaan, sankitii goonɗinɓe heewɓe. Nder maɓɓe woɓɓe njehi Finisi, Kipurus, Antiyokiya Siriya. Iɓe mbaajoo *Yahudankooɓe tan dow habaru Iisa *Almasiihu. ");
INSERT INTO fuh_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Amma goonɗinɓe gom duu ƴuwi Kipurus he Sirene ngari Antiyokiya no mbaajoo ɓe kanaa *Yahudankooɓe dow *Habaru lobbo, habaru Iisa Joomiraawo. ");
INSERT INTO fuh_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Junngo Joomiraawo no dow maɓɓe. Himɓe heewɓe tuubii ngoonɗini. ");
INSERT INTO fuh_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Wakkati hawriine goonɗinɓe *Ursaliima nanunoo ko waɗi Antiyokiya, ɓe cuɓi Barnabas, ɓe lili toon. ");
INSERT INTO fuh_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","24","Barnabas neɗɗo lobbo non, keewɗo *Ruuhu Ceniiɗo he goonɗinol. Wakkati o yottinoo Antiyokiya, o hi'i no Alla barkiniri goonɗinɓe ɓeen, o nani belɗum majjum. O holliti ɓe, o semmbinɗini ɓe ngam ɓe tittinkinoo nder hoolaade Alla. Himɓe heewɓe ngoonɗini, ngari ɓeydi he goonɗinɓe illa arannde ɓeen. ");
INSERT INTO fuh_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Barnabas ummii Antiyokiya fa'i Tarsus ngam tefoyde Sol. ");
INSERT INTO fuh_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Wakkati o hiitunoo Sol, o ardii mo, ɓe ngari Antiyokiya. Ɓe njooɗii hitaane muɓɓere hakkune hawriine *aahiiɓe Iisa, ɓe njanngini himɓe heewɓe. Nder Antiyokiya goonɗinɓe ɓeen puɗɗa noddireede tokkuɓe *Almasiihu. ");
INSERT INTO fuh_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Nder balɗe mum, annabiiɓe ɗuɓɓe ummake *Ursaliima ngari Antiyokiya. ");
INSERT INTO fuh_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Nder baawɗe *Ruuhu Ceniiɗo, Agabus gooto nder maɓɓe, ummii, wi'i rafo manngo no waɗan nder duuniyaaru fuu. Ir maggo waɗinoo nder jamaanu laamiiɗo *Rooma bi'eteeɗo Kalawdiyus. ");
INSERT INTO fuh_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","*Aahiiɓe wonɓe leydi Antiyokiya, anniyi wallude banndiraaɓe mum'en tawaaɓe nder leydi Yahudiya, neɗɗo maɓɓe fuu keddi baawɗe mum. ");
INSERT INTO fuh_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ɓe adi keddi ko ɓe mbaawi hokkude, ɓe ngatti nder juuɗe Barnabas e Sol ngam ɓe njaara ɓe kokkowa mawɓe hawriine goonɗinɓe Iisa wonnde *Ursaliima. ");
INSERT INTO fuh_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Nder wakkati mo Pol e Barnabas njaarannoo balla goonɗinɓe Antiyokiya nder *Ursaliima, *Hirudus laamiiɗo Yahudiya fuɗɗi, kam duu, torrude goonɗinɓe Iisa gom. ");
INSERT INTO fuh_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","O waɗi Yakuuba mawnu Yahaaya soppira takubaahi, waraa. ");
INSERT INTO fuh_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Wakkati o hi'unoo ko torrol goonɗinɓe ngool no weli *Yahudankooɓe, o nanngi Piyer duu o uddi. Uddol Piyer ngool fottodiri he *Juulɗe buuru mo walaa ƴuufinirɗum. ");
INSERT INTO fuh_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","O watti cefe soogeeji nay paddo Piyer, sewre fuu soogeeji nay. O adi duu anniya hiitaade mo yeeso himɓe fuu, gaɗa *Juulɗe dimɗinol Isra'ilankooɓe. ");
INSERT INTO fuh_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Piyer faddaa, amma hawriine goonɗinɓe ndeen duu tinni no du'anoo mo. ");
INSERT INTO fuh_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Jemma mo *Hirudus waaldiri anniya ko nde weeti fuu kam no hiitoto Piyer, Piyer no fukkii no ɗaanii hakkune soogeeji ɗiɗi. Omo haɓɓiraa callali ɗiɗi, daarooɓe dammbule kasu ɓeen duu no ndarii no ndooma ɗe. ");
INSERT INTO fuh_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Sonnyo fuu waɗaay, sey Maleykaajo Joomiraawo gom wanngani Piyer, jeyngol gom waɗi nder cuurel to o faddaa. Maleykaajo oon meemi wecco makko, findini mo, wi'i o ummoo law law. Callali ɗiin piirti, ƴuwi he juuɗe makko, caami. ");
INSERT INTO fuh_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Maleykaajo oon wi'i mo kaden : —Tunnda, kaɓɓa paɗe maa. Piyer ummii, tunndi, haɓɓi paɗe mum. Nden maleykaajo oon wi'iti mo : —Wattu alkubbaare maa, tokkaa kam. ");
INSERT INTO fuh_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Piyer watti alkubbaare mum ummii tokki maleykaajo oon wurtii. O faamaay fuu ko woni no waɗa. Ɗum wa'ani mo hano koyɗol nii. ");
INSERT INTO fuh_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ɓe njawti doomoowo arano oon, ɗiɗaɓo oon, nden ɓe njotti dammbugal njamndi daroowal huɓeere ndeen. Wakkati ɓe ndarinoo yeeso maggal, sey ngal omtanii hoore maggal. Ɓe mburtii, ɓe njehi yeeso seɗɗa sey maleykaajo oon majjani mo. ");
INSERT INTO fuh_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Wakkati Piyer faamanoynoo hoore mum, o wi'i : —Sikka fuu walaa, Joomiraawo lili maleykaajo mum, wara soptina he juuɗe *Hirudus e ko *Yahudankooɓe ndoomi heewtoo kam. ");
INSERT INTO fuh_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Nden o ummii, o yehi to jama'aare hawrata no waɗa du'aa'u nder ɓaade Mariyaama, inna Yahaaya inndirteeɗo Markus. ");
INSERT INTO fuh_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Piyer darii dammbugal salmini. Debbo golloowo gom bi'eteeɗo Roda ɓattii, faa daara moy woni dammbugal. ");
INSERT INTO fuh_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Wakkati o annditinnoo daane Piyer, o heewi welwelo faa o yeggiti omtande mo. O doggi, o haalanowi wonɓe nder suudu ɓeen, o wi'i ɓe Piyer woni no darii dammbugal no salmina. ");
INSERT INTO fuh_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Sey ɓe mbi'i o kaaŋaaɗo. O tokki omo wi'a ko hanaa fuu goɗɗo non, Piyer nii woni dammbugal. Nden ɓe mbi'i tawte maleykaajo duroowo makko non. ");
INSERT INTO fuh_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Piyer tinni no salmina. Wakkati ɓe omtunoo dammbugal ngaal, sey ɓe ngi'ii Piyer, ɗum haayɗini ɓe. ");
INSERT INTO fuh_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","O deki honndu dow hunnduko makko ngam wi'ude ɓe ndeƴƴita. O fillanii ɓe no Joomiraawo wurtiniri mo nder kasu oon. O wi'i ɓe kaalana Yakuuba he goonɗinɓe ɓeeto fuu. Nden o wurtii, o yehi to goonɗinɓe gom. ");
INSERT INTO fuh_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Wakkati weetunoo, burtaaki Piyer kiin ummini faa noy walaa hakkillo soogeeji ɗiin. Ɓe tinni iɓe ƴamodira toy Piyer naati. ");
INSERT INTO fuh_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","*Hirudus waɗi o tefee nokku fuu amma o hiitaaka. O noddi soogeeji ɗiin, o ƴami ko waɗi. Nden o hokki laawol ɗi nanngee ɗi mbaree. Ɗi nanngaa, ɗi mbaraa. Gaɗa mum *Hirudus ummii Yahudiya, hoɗowi Kaysariya balɗe seɗɗa. ");
INSERT INTO fuh_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Waɗiino wakkati ko *Hirudus fotaa he ci'e Tirus he Sidon. Mbuurnam ci'e ɗeen fuu ngalaana no keɓee nder leydi makko. Nyannde gom himɓe gom nder ci'e ɗee, ummii faa ngara to *Hirudus ngam tefa potal. Tawi ɓe narriino he mawɗo faada *Hirudus bi'eteeɗo Bilastus. ");
INSERT INTO fuh_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Nyannde ɓe pottannoo, *Hirudus ɓornii kolte mum laamu, jooɗii no haalda he maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Huune fuu nanaaka sey ɓe kuuɓi, iɓe mbi'a : —Daane ndee, hanaa daane tagaaɗo, daane deweteeɗo non ! ");
INSERT INTO fuh_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Wakkati mum da, maleykaajo Joomiraawo gom fiyi mo, ngam o teddinaay Alla. Gilƴi tinni no nyaama mo faa o maayi. ");
INSERT INTO fuh_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Haala Alla no waajee yahde, ika sankitoo nokku fuu. ");
INSERT INTO fuh_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Wakkati Barnabas e Sol timminnoo golle mum'en nder *Ursaliima, Yahaaya inndirteeɗo Markus tokki ɓe, ɓe kootidi. ");
INSERT INTO fuh_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Nder hawriine goonɗinɓe wonnde Antiyokiya no tawa annabiiɓe e jannginooɓe gom, Barnabas, Simeyon inndirteeɗo Ɓaleejo, Lukiyus mo Sirene, Sol e Manahen, mo he laamiiɗo *Hirudus ummodi nokku ngootu. ");
INSERT INTO fuh_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Nyannde gom wakkati ɓe teddinannoo Joomiraawo, iɓe cuumi nyannde mum, sey *Ruuhu Ceniiɗo wi'i ɓe : —Cuɓanee kam Barnabas e Sol ngam golle ɗe noddanmi ɓe. ");
INSERT INTO fuh_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Wakkati ɓe kumtinoo, ɓe ndu'ii, ɓe njowi juuɗe maɓɓe dow Barnabas e Sol, ɓe callimi ɓe, ɓe ndilli. ");
INSERT INTO fuh_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","*Ruuhu Ceniiɗo lili Barnabas e Sol nder duune Kipurus. Wakkati ɓe njehannoo, ɓe tokkiri har Selewkiya, ɓe naatowi laana ndiyam, ɓe ponndi Kipurus. ");
INSERT INTO fuh_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Wakkati ɓe njottinoo Salamis, ɓe mbaajii haala Alla nder *baajorɗi *Yahudankooɓe. Yahaaya inndirteeɗo Markus no wondi he maɓɓe no walla ɓe. ");
INSERT INTO fuh_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Ɓe piili duune ndeen fuu faa ɓe njottii Pafos. Nder Pafos ɓe potti he Bar-Iisa, Yahudanke gaɗoowo dobo-dobooji, aduɗo hoore mum hano annabiijo. ");
INSERT INTO fuh_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Bar-Iisa no wondi he laamiiɗo Sergiyus Polus, gorko jom hakkillo. Nyannde gom Sergiyus Polus noddi Barnabas e Sol ngam hettinaade haala Alla. ");
INSERT INTO fuh_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Amma Elimas gaɗoowo dobo-dobooji, mo maana innde mum woni « jom dobo-dobooji » nder gerekankoore, no tefa haɗude ɗum. O hiɗaa laamiiɗo oon hettinanoo ɓe faa goonɗina. ");
INSERT INTO fuh_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Sol gooto, lilidaaɗo he Barnabas, no inndiree Pol. O heewi *Ruuhu Ceniiɗo, o daari Elimas faa wooɗi, ");
INSERT INTO fuh_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","o wi'i : —Hey ƴoyre ! Jammbotoongel, aan Seyɗan ganyo Alla, ganyo ko wooɗi ! Nde celataa bonude laabi Joomiraawo ? ");
INSERT INTO fuh_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Jooni sawru Joomiraawo saaman dow maa, mbumaa. A waɗan balɗe, a hi'aay jeyngol naange. Wakkati mum da nimre huuri mo, gite makko ngi'ataa fuy. Omo memmemta, omo tefa ɗowoo mo. ");
INSERT INTO fuh_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Waaju haala Joomiraawo oo naati ɓerne laamiiɗo Sergiyus Polus sanne. Wakkati o hi'unoo ko waɗi, o tuubii, o goonɗini Iisa. ");
INSERT INTO fuh_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pol he wondunooɓe he mum ummii naati laana ndiyam Pafos, ponndi Perga nder leydi Pamfiliya. Yahaaya inndirteeɗo Markus seedi he maɓɓe, soƴƴii *Ursaliima. ");
INSERT INTO fuh_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Amma Pol he horiiɓe ɓeen ummii Perga, ngari Antiyokiya nder leydi Pisidiya. *Nyalaane fowteteene gom Pol'en naati *waajordu njooɗii. ");
INSERT INTO fuh_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Wakkati ɓe kantunoo jannde aayaaje gom nder *Tawreeta he nder dewte annabiiɓe, hooreeɓe *waajordu nduun ngaɗi lilaaɓe ngari mbi'i Pol'en : —Banndiraaɓe, nde nii oɗon ngoodi ko mbi'oton himɓe hawruɓe hannden nder *waajordu nduun ngam semmbinɗinde ɓe, oɗon mbaawi wi'ude ɗum jooni. ");
INSERT INTO fuh_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Sey Pol ummii, darii sappii ɓe wi'i : —Onon *Isra'ilankooɓe he onon hulooɓe Alla, kettinee ko mbi'anmi on. ");
INSERT INTO fuh_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Wakkati maamiraaɓe meeɗen ngonnoo Misira, Alla mo Isra'ilankooɓe ngoonɗini suɓii ɓe mawnini ɓe. Nder baawɗe makko duu o wurtiniri ɓe nder mayri. ");
INSERT INTO fuh_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Wakkati ɓe ngaɗunoo duuɓi lasooji ɗiɗi nder ladde yeeruure, kanko nyamni ɓe, yarni ɓe. ");
INSERT INTO fuh_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Nder leydi Kanaana o moyti lenyi jeɗɗi, o hokki ɓe ndi, ɓe ndona ");
INSERT INTO fuh_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","ko watta duuɓi keme nay e woygu (450). Illa duuɓi keme nay e woygu ɗiin faa wara he jamaanu annabi Samuwiila, Alla hokki ɓe hiitotooɓe gom. ");
INSERT INTO fuh_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Maamiraaɓe meeɗen eeli mo o hokka ɗum'en laamiiɗo. O hokki ɓe Sawulu ɓii-Kis jippotooɗo he Benyamin, mari ɓe duuɓi lasooji ɗiɗi. ");
INSERT INTO fuh_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Wakkati Alla teeti laamu Sawulu, o suɓii Daawda laamoo ɓe. O haali dow Daawda, o wi'i : Mi hi'i ko Daawda ɓii-Yesa, gorko non pottanɗo ɓerne am, gaɗoowo muuyɗe am fuu. ");
INSERT INTO fuh_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Nder jippotooɓe he Daawda Iisa ƴuwi. Kanko duu Alla waɗi Kisinoowo Isra'ilankooɓe hano no o wi'irnoo ɗum nii. ");
INSERT INTO fuh_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Fadde Iisa warde, Yahaaya gaɗoowo *batisma watti daane he himɓe *Isra'el fuu o wi'i, ɓe tuuba, ɓe ngaɗanee *batisma. ");
INSERT INTO fuh_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Wakkati Yahaaya gaɗoowo *batisma timminnoo golle mum, wi'i ko kam hanaa neɗɗo mo ɓe ndoomi garki mum oon. Gaɗa mum neɗɗo oon warta, kam fotaay duu baa fiirtude ɓoggi paɗe makko. ");
INSERT INTO fuh_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Banndiraaɓe, onon jippotooɓe he *Ibrahim he hulooɓe Alla, enen habaru kisinam oo lildanaa. ");
INSERT INTO fuh_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Himɓe *Ursaliima he mawɓe mum'en annditaay moy woni Iisa. Wakkati ɓe kiitotonoo Iisa, ɓe kumni haalaaji annabiiɓe ɗi ɓe njanngata *nyalaane fowteteene fuu. ");
INSERT INTO fuh_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Baa nii ko ɓe keɓaayno feloore fuu he makko, ɓe eeli Pilaatus waɗa o waree. ");
INSERT INTO fuh_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Wakkati ɓe kumnunoo ko dewte kaalunoo dow Iisa, o jippinaa dow *leggal bardugal, o mooɓaa. ");
INSERT INTO fuh_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Amma Alla ummintinii mo. ");
INSERT INTO fuh_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","O waɗi balɗe omo wanngana wondunooɓe he makko illa Galili faa wara *Ursaliima, laatiiɓe seedantooɓe mo hannden yeeso himɓe. ");
INSERT INTO fuh_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Minen he ko'e amin, miɗen kaalana on dow *Habaru lobbo oo, mo Alla fodaninoo maamiraaɓe meeɗen. ");
INSERT INTO fuh_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Wakkati Alla ummintinnoo Iisa, o humni fodoore ndee ngam meeɗen en fuu, enen jippotooɓe he maɓɓe. Ngam no winndaa nder *Jabuura suura ɗiɗi : Aan woni Ɓiyam, ɓaawo hannden miin woni Bammaa. ");
INSERT INTO fuh_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Kaden duu, Alla wi'iino kam no ummintinan mo, kam accataa ɓanndu makko nyola. Nii woni no o haaliri ɗum : Mi hokkan on barke ceniiɗe, barke goongaaje ɗe podaniimi Daawda. ");
INSERT INTO fuh_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ngam majjum waɗi Daawda wi'i nder aayaare *Jabuura gom : —A accataa ceniiɗo maa nyola nder annyeere. ");
INSERT INTO fuh_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Daawda gollani Alla, maayi, mooɓaa hadde annyeeje maamiraaɓe mum. Ɓanndu makko nyoli, ");
INSERT INTO fuh_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","amma mo Alla ummintini oon kay, ɓanndu mum nyolaay. ");
INSERT INTO fuh_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Banndiraaɓe, paamee ko dow filla moytol hakkeeji daliila Iisa min mbaajii on. Neɗɗo fuu goonɗini mo no soptinte he maccangaaku hakke, ngu *Tawreeta waawaay soptinde on he mum. ");
INSERT INTO fuh_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Kakkilee to ko winndaa nder dewte annabiiɓe ɗum waɗu he mooɗon : ");
INSERT INTO fuh_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Kettinee onon yawiiɓe Alla, ɗum laatanto on haayne, kalkon ! Ngam mi waɗan gollal nder mbuurnam mooɗon, ngal baa nde goɗɗo fillanii on, on njaɓataa. ");
INSERT INTO fuh_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Wakkati Pol e Barnabas mburtii *waajordu nduun, jama'aare ndeen eeli ɓe, ɓe ngarta *nyalaane fowteteene waroore, ɓe mbaajoo ir waaju oo. ");
INSERT INTO fuh_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Gaɗa cankitaaki hawriine ndeen, *Yahudankooɓe ɗuɓɓe e tuubuɓe gom, njaɓi diina *Yahudankooɓe, tokki Pol e Barnabas. Pol e Barnabas njewtani ɓe, cemmbinɗini ɓe ngam ɓe ɓeyda feŋaade he Alla moƴƴuɗo. ");
INSERT INTO fuh_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Wakkati *nyalaane fowteteene ndeen wartunoo, ɗuuɗal himɓe wuro ngoon fuu ngari kettini waaju Pol e Barnabas. ");
INSERT INTO fuh_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Wakkati *Yahudankooɓe ɓeen ngi'unoo jama'aare ndeen, haasidaaku naatani ɓe. Ɓe tinni iɓe njeddodira he Pol'en, iɓe njanca haalaaji Pol. ");
INSERT INTO fuh_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Sey caka jama'aare ndeen, Pol e Barnabas acci kulal fuu, mbi'i ɓe : —Waajibi, onon haala Alla kaa haani haalaneede. On calake ka, ngam oɗon miila ko on kaandaa mbuurnam nduumiiɗam. Ndenne, min coƴƴoto to ɓe kanaa *Yahudankooɓe, min kaalana ɓe ka. ");
INSERT INTO fuh_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Ngam kanƴum woni ko Joomiraawo wi'i min ngaɗa, wakkati o wi'unoo : Mi suɓake ma laatoɗaa jeyngol duuniyaaru, ngaddaa kisinam nder kappa kuula mayru fuu. ");
INSERT INTO fuh_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Wakkati ɓe kanaa *Yahudankooɓe nanunoo haala kaa, ɓe nanii belɗum. Ɓe tinni iɓe teddina haala Alla. Himɓe fuu, ɓe Alla fodi laatoo goonɗinɓe nyannde mum, ngoonɗini. ");
INSERT INTO fuh_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Haala Joomiraawo sankitii nder leydi ndiin fuu. ");
INSERT INTO fuh_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","*Yahudankooɓe uppi rewɓe e worɓe, haalooɓe nanee nder wuro ngoon tokkuɓe diina maɓɓe, ngam ɓe torra Pol e Barnabas. Ɓe ndiiwi Pol e Barnabas nder leydi ndiin. ");
INSERT INTO fuh_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Wakkati Pol e Barnabas ndillannoo, ɓe piɗɗi sollaare koyɗe maɓɓe dow wuro ngoon, ɓe pa'i Ikoniyum. ");
INSERT INTO fuh_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Aahiiɓe wonɓe Antiyokiya Pisidiya keewi belɗum ɓerne e *Ruuhu Ceniiɗo. ");
INSERT INTO fuh_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Nder Ikoniyum Pol e Barnabas naati nder *waajordu *Yahudankooɓe mbaajii. Waaju maɓɓe oo nafi sanne faa *Yahudankooɓe he ɓe kanaa *Yahudankooɓe heewɓe ngoonɗini. ");
INSERT INTO fuh_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Amma *Yahudankooɓe horiiɓe ɓe ngoonɗinaay ngatti miilooji bonɗi nder ɓerɗe ɓe kanaa *Yahudankooɓe ngam ɓe mbanya banndiraaɓe maɓɓe goonɗinɓe. ");
INSERT INTO fuh_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Amma ɗum fuu waɗaay Pol'en ndilla, ɓe ɓooyi Ikoniyum, iɓe mbaajoro cuusal haala Joomiraawo moƴƴuka. Iɓe kooli Joomiraawo, omo hokka ɓe baawɗe waɗude alamaaji e kujje kaayɗiniiɗe. Omo holla ɓe duu ko goonga nii ɓe ngoni iɓe mbaajoo. ");
INSERT INTO fuh_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Nder huɓeere ndeen himɓe cenndi, woɓɓe no ngaɗa *Yahudankooɓe ɓeen, woɓɓe duu no tokki *lilaaɓe ɓeen. ");
INSERT INTO fuh_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","*Yahudankooɓe, ɓe kanaa *Yahudankooɓe e mawɓe mum'en, fuu ciryii torrude Pol e Barnabas, ɓe paɗɗa ɓe kaaƴe, ɓe mbara. ");
INSERT INTO fuh_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Wakkati Pol e Barnabas paamunoo ɗum, ɓe ndoggi ɓe pa'i ci'e Listira e Derbe nder leydi Likoniya e gure piiliiɗe ɗum. ");
INSERT INTO fuh_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Ɓe mbaajii *Habaru lobbo oon. ");
INSERT INTO fuh_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Nder Listira no woodunoo gorko bonngiiɗo illa nder cukaaku mum. O yaaɓaay koyngal baa nde worre, o dilla. ");
INSERT INTO fuh_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Nyannde gom o wari, o jooɗii, omo hettini ko Pol woni no wi'a. Pol ƴetti gite daari mo faa wooɗi, sey hi'i ko goonɗinol gorko oo no waawi waɗa o nyawta. ");
INSERT INTO fuh_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Pol toowni daane wi'i mo : —Umma, dara dow koyɗe maa ! Sey gorko oon garbisi, darii, no yaha. ");
INSERT INTO fuh_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Wakkati jama'aare hi'unoo ɗum ɓe kuuɓi iɓe mbi'a nder likoniyankoore : —Deweteeɓe gom njippi, mbayliti, laatii tagaaɓe ngari to amin ! ");
INSERT INTO fuh_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Nden ɓe noddiri Barnabas « Jewus », Pol duu « Hermes », ngam kanko Pol woni ɓurɗo haalude. ");
INSERT INTO fuh_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Suudu rewirde Jewus no tawa dammbugal huɓeere ndeen. Cakkanoowo tooruure inndiraane Jewus oon wari, waddi ga'i peɗiraaɗi pinni. O darni ɗi dammbule mayru. Omo hiɗi, kanko he jama'aare ndeen, ngaɗana Pol e Barnabas sadakaaji hano no ɓe ngaɗiranta deweteeɓe maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Wakkati Barnabas e Pol nanunoo ɗum, ɓe cerki kolte maɓɓe, ngam hollude mettal ɓerɗe maɓɓe. Ɓe ndoggi, ɓe naatowi nder jama'aare ndeen, ");
INSERT INTO fuh_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","iɓe mbi'a : —Ɗume ngatton huune ndee fuu ? Min tagaaɓe hano mooɗon. Min ngaraana waajaade oon dow *Habaru lobbo, mboppon filla dewol tooruuje ɗe ngalanaa oon fuu nafakka gom. Kuybiton har Alla Duumiiɗo, taguɗo dow e ley, taguɗo diyeele e ko tawa nder gootel majji fuu. ");
INSERT INTO fuh_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Nder jamanuuji bittiiɗi, o acci neɗɗo fuu tokki ko weli ɗum. ");
INSERT INTO fuh_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Amma ɗum fuu haɗaay mo wannginde moƴƴe makko nder ko o waɗata fuu. Kanko jippinanta on dunngu mbarkinaangu. Omo nyamna on faa kaaron, omo welna ɓerɗe mooɗon. ");
INSERT INTO fuh_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Da cat he walaa hawli Barnabas e Pol keɓii kaɗi jama'aare ndeen hirsande ɓe sadakaaji ɗiin. ");
INSERT INTO fuh_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","*Yahudankooɓe gom ngari, ƴuwi Antiyokiya he Ikoniyum. Ɓe pooɗi hakkillooji himɓe ɓeen faa ɓe mbaawi ɗum'en. Nden ɓe murtini jama'aare ndeen, nde tinni inde faɗɗira Pol kaaƴe. Wakkati jama'aare ndeen miili o maayi, nden o daasaa, o yaaraa gaɗa wuro. ");
INSERT INTO fuh_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Wakkati *aahiiɓe ɓeen kawrunoo dow makko, o ummii, o naati nder huɓeere ndeen. Ɓe mbaali toon faa weeti, nden kanko e Barnabas pa'i Derbe. ");
INSERT INTO fuh_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Pol e Barnabas mbaajake *Habaru lobbo nder Derbe. Himɓe heewɓe laatii *aahiiɓe Iisa. Gaɗa ɓe mbaajake nder Derbe, ɓe paɗɗiti dow koyɗe maɓɓe. Ɓe njehi Listira, Ikoniyum, he Antiyokiya. ");
INSERT INTO fuh_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Pol e Barnabas cemmbinɗini ɓerɗe goonɗinɓe, ngam ɓe tittinkinoo nder goonɗinol maɓɓe, iɓe mbi'a ɓe : —Nde haana en tampu non faa noy walaa, en naatata nder Laamu Alla. ");
INSERT INTO fuh_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Hawriine goonɗinɓe fuu, ɓe cuɓani ɗum ardiiɓe mum. Ɓe cuumi, ɓe ndu'i, ɓe kalfini ardiiɓe ɓeen Joomiraawo mo ɓe ngoonɗini. ");
INSERT INTO fuh_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Dow laawol maɓɓe ɓe panti nder Pisidiya, ɓe ngari leydi Pamfiliya. ");
INSERT INTO fuh_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Ɓe mbaajii nder wuro Perga, nden ɓe njippowi nder Ataliya. ");
INSERT INTO fuh_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Toon ɓe naati laana ndiyam, ɓe pa'i Antiyokiya Siriya. Nder Siriya, moƴƴere Alla eelaa wondaa he maɓɓe ngam golle ɗe ɓe ngayni ɗeen. ");
INSERT INTO fuh_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Wakkati ɓe ngartunoo, ɓe kawri goonɗinɓe ɓeen fuu, ɓe kaalani ɗum'en huune fuu ko Alla waɗi he maɓɓe, he no o fiirtirani ɓe kanaa *Yahudankooɓe laawol goonɗinde. ");
INSERT INTO fuh_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ɓe njoddi he aahiiɓe wonɓe Antiyokiya ɓeen faa ɓooyi. ");
INSERT INTO fuh_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Himɓe gom ƴuwi Yahudiya ngari Antiyokiya Siriya, no mbaajoo goonɗinɓe no mbi'a : —Neɗɗo fuu, mo juulnaaka hano no *Muusa haaliri ɗum, heɓataa kisinam. ");
INSERT INTO fuh_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pol e Barnabas pooɗodiri sanne he maɓɓe dow ko ɓe mbi'i nder waaju oo. Sey ɗum waɗi Pol, Barnabas e goonɗinɓe Antiyokiya gom ummoo, njeha *Ursaliima to *lilaaɓe ɓeeto e ardiiɓe kawriiɗe goonɗinɓe ngam keɓowa hoore haala kaa. ");
INSERT INTO fuh_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Hawriine goonɗinɓe Antiyokiya hokki ɓe jooɓaari keƴuni, nden ɓe ndilli. Pol, Barnabas e wondunooɓe he maɓɓe nder jahaangal ngaal, pedditi leyɗe Finisi e *Samariya. Iɓe njaha, iɓe pillanoo goonɗinɓe tawaaɓe nder nokkuuje ɗeen, no ɓe kanaa *Yahudankooɓe tuubiri, tokki Joomiraawo. Haala kaa weli goonɗinɓe ɓeen fuu. ");
INSERT INTO fuh_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Wakkati ɓe njottinoo nder *Ursaliima, hawriine goonɗinɓe *Ursaliima, *lilaaɓe ɓeen he ardiiɓe kawriiɗe goonɗinɓe taɓɓitii ɓe. Pol'en pillanii ɓe huune fuu ko kam'en ngaɗi nder baawɗe ɗe Alla hokki ɗum'en. ");
INSERT INTO fuh_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Amma *Fariisa'en goonɗinɓe gom ummii, mbi'i : —Tilay sey nii ɓe kanaa *Yahudankooɓe njulnee, tilsinee tokka *Tawreeta. ");
INSERT INTO fuh_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","*Lilaaɓe ɓeen e ardiiɓe kawriiɗe goonɗinɓe ɓeen njooɗii, ndaari haala kaan ngam hiitude hoore makka. ");
INSERT INTO fuh_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ɓe neeɓi, iɓe caawodira faa ɓooyi. Nden Simon Piyer ummii, wi'i ɓe : —Banndiraaɓe, oɗon anndi ko Alla suɓii kam illa ko ɓooyi mi waajoo *Habaru lobbo hakkune ɓe kanaa *Yahudankooɓe, ngam ɓe tuuba, ɓe ngoonɗina. ");
INSERT INTO fuh_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Wakkati Alla annduɗo ɓerne ɓii-aadama hokkunoo ɓe *Ruuhu Ceniiɗo hano no o hokkirnoo en mo, o holli ko kam jaɓi tuubu maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Walaa fuu ko o senndiri en he maɓɓe. O lamni ɓerɗe maɓɓe ngam ɓe tuubii, ɓe ngoonɗini. ");
INSERT INTO fuh_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Joonin, ko waɗi oɗon ngiɗi sii'aade haala Alla ? Oɗon tefa njowon donngal dow aahiiɓe makko, donngal ngal enen he maamiraaɓe meeɗen en fuu en mbaawaay ronndaade. ");
INSERT INTO fuh_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Enen he maɓɓe, en fuu en ngoonɗini ko ngam sabbu moƴƴere Iisa Joomiraawo waɗi keɓuɗen kisinam. ");
INSERT INTO fuh_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Hawriine ndeen fuu waɗi siw. Ɓe kettini Pol e Barnabas no pillo no Alla hokkiri ɗum'en baawɗe waɗude kaayɗe e alamaaji ɗuɗɗi hakkune ɓe kanaa *Yahudankooɓe. ");
INSERT INTO fuh_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Wakkati ɓe ngaynunoo haala maɓɓe, Yakuuba wi'i : —Kettinee banndiraaɓe ! Kettinanee kam ! ");
INSERT INTO fuh_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simon Piyer haalani en ko illa arannde no Alla holliri ɓe kanaa *Yahudankooɓe hidde mum, har cuɓaaki himɓe ngaɗaaki hakkune maɓɓe ngam ɓe laatoo himɓe mum. ");
INSERT INTO fuh_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Haalaaji annabiiɓe duu njardake dow majjum, ngam har kunndule maɓɓe Joomiraawo wi'i : ");
INSERT INTO fuh_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Mi wartan, gaɗa mum, mi nyiɓitoo suudu Daawda saamunu nduun. Mi fonndita ko boni fuu nder mayru, mi darna ndu, ");
INSERT INTO fuh_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","18","ngam horiiɓe fuu tefa kam, lenyol fuu ngool noddumi laatoo halal am. Ɗum woni ko Joomiraawo anndinɗo ko kujje ɗee fuu ngaɗan illa fil'ajal, wi'i. ");
INSERT INTO fuh_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","—Ngam majjum waɗi, miin kay ko ngi'umi woni to en tinnan ɓe kanaa *Yahudankooɓe tuubuɓe tokki Alla. ");
INSERT INTO fuh_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Amma mbinndanen ɓe ko ɓe kaanaa nyaamude tewu ngu laaɓaa, tewu cakkanaangu tooruuje. Ɓe paddo ko'e maɓɓe he jeenu he golle jaayɗe he ko nanndi he mum, to ɓe nyaamu ko saaɗi, to ɓe nyaamu ƴiiƴam. ");
INSERT INTO fuh_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Ngam illa ko ɓooyi *Tawreeta no waajee nder gure fuu, no jannginee nder *baajorɗi *nyalaane fowteteene fuu. ");
INSERT INTO fuh_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","*Lilaaɓe ɓeen, ardiiɓe kawriiɗe goonɗinɓe Iisa he goonɗinɓe ɓeen fuu narrii, cuɓi hakkune mum'en goonɗinɓe ɗowtiranɓe Pol e Barnabas Antiyokiya Siriya. Nder suɓaaɓe ɓeen no tawa hooreeɓe ɗiɗo, Yahuuda inndirteeɗo Barsabas e Silas. ");
INSERT INTO fuh_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ɓe kokkaa ɗerol ngool. Nder maggol ɓe mbinndi, ɓe mbi'i : —Minen, *lilaaɓe e ardiiɓe kawriiɗe goonɗinɓe Iisa, gonɗe nder *Ursaliima miɗen canna on, onon ɓe kanaa *Yahudankooɓe goonɗinɓe Iisa tawaaɓe nder Antiyokiya, Siriya e leydi Silisi fuu. ");
INSERT INTO fuh_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Min nani ko himɓe gom ƴuwi nder wurooji amin ngari culnani on. Ɓe ummini hakkillooji mooɗon, baa ko min kokkaay ɓe laawol ɓe ngara ɓe kaalana on iri haalaaji ɗii. ");
INSERT INTO fuh_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Ngam majjum waɗi min kawri, min ngaɗi daane worre, min adi worɓe ɗiɗo ɓee, ɓe ɗowtira Barnabas e Pol higiraaɓe amin horsuɓe, ");
INSERT INTO fuh_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","connuɓe yonkiiji mum'en ngam sabbu Iisa *Almasiihu Joomiraawo meeɗen. ");
INSERT INTO fuh_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Min lili Yahuuda e Silas he mooɗon ngam ɓe njanngana on ko winndaa nder ɗerol ngool. ");
INSERT INTO fuh_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","*Ruuhu Ceniiɗo hawri he amin, min potti dow ko haana ndekeɗon donngal fuu ngal tawaaka nder tilsinooje bi'uɗe : ");
INSERT INTO fuh_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","To nyaamee tewu cakkanaangu tooruuje, to nyaamee ƴiiƴam, to nyaamee ko saaɗi, paddee ko'e mooɗon he jeenu he golle jaayɗe ko nanndi he mum. Nde nii on mboɗɗake kujje ɗee, too, on ngaɗi ko wooɗi. Jam wonda he mooɗon. ");
INSERT INTO fuh_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Nden ɗum waynodiri he worɓe ɓeen, ɓe tokki Pol'en ɓe pa'i Antiyokiya. Wakkati ɓe njottinoo Antiyokiya, ɓe kawri goonɗinɓe wuro ngoon fuu. Ɓe linnyi ɓe ɗerol ngool. ");
INSERT INTO fuh_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Wakkati ɓe njanngana ngol, ɓe nani belɗum maggol ngam ngol semmbinɗini ɓe sanne. ");
INSERT INTO fuh_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yahuuda e Silas, ɓe annabiiɓe duu. Ɓe mbaajii goonɗinɓe ɓeen sanne ngam semmbinɗinde ɓe nder goonɗinol maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Ɓe ngaddi he maɓɓe balɗe. Nden nyannde gom ɗum waynodiri he maɓɓe, ɓe koota jam.  ");
INSERT INTO fuh_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Amma Silas kay ndillaay. ");
INSERT INTO fuh_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pol e Barnabas duu njooɗii toon. Kamɓe he himɓe heewɓe gom, njanngini, mbaajii haala Joomiraawo. ");
INSERT INTO fuh_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Balɗe seɗɗa gaɗa waaju maɓɓe, nyannde gom Pol ummii, wi'i Barnabas : —En tuntowoo nokkuuje ɗe mbaajiɗen ngi'en no banndiraaɓe meeɗen ngontiri. ");
INSERT INTO fuh_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabas hiɗiino Yahaaya inndirteeɗo Markus tokka ɗum'en yaha. ");
INSERT INTO fuh_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Amma Pol jaɓaay ngam wakkati ɓe ngonnoo Pamfiliya, Markus dilli acci ɓe. Illa ndeen o yeeƴitaaki ɗowtirde ɓe kaden nder jahaale maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Pol e Barnabas njeddodiri sanne, amma ɓe potaay faa ɓe ceedi. Barnabas adi Markus, ɓe naati laana ndiyam, ɓe ponndi duune Kipurus. ");
INSERT INTO fuh_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pol duu adi Silas. Goonɗinɓe wuro ngoon eeli moƴƴere Joomiraawo wonda he maɓɓe, nden ɓe ndilli. ");
INSERT INTO fuh_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Ɓe pa'i leyɗe Siriya e Silisi. Iɓe njaha, iɓe cemmbinɗina kawriiɗe goonɗinɓe. ");
INSERT INTO fuh_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Jahaangal Pol e Silas yaari ɓe gure Derbe e Listira. Nder Listira no tawa aahiijo Iisa gom, mo innum no Yahudanke tuubuɗo goonɗini Iisa, bammum duu no Gerekanke. Gorko oo no wi'ee Timote. ");
INSERT INTO fuh_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Goonɗinɓe wonɓe nder Listira e Ikoniyum fuu no mana mo sanne. ");
INSERT INTO fuh_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pol no hiɗi jahdal makko. O juulni mo ngam *Yahudankooɓe tawaaɓe nder leydi ndiin fuu no anndi ko baabiiko no Gerekanke. ");
INSERT INTO fuh_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Nder ci'e fuu ɗe ɓe panti, iɓe kaalana goonɗinɓe majje laabi adaaɗi nder hawriine waɗaane *Ursaliima caka ardiiɓe goonɗinɓe he *lilaaɓe ɓeen. Iɓe mbi'a ɓe, ɓe tokka laabi ɗiin. ");
INSERT INTO fuh_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Kawriiɗe goonɗinɓe ci'e ɗeen no ɓeydoo wakkati fuu, goonɗinɓe majje duu no ɓeyda semmbiɗidde nder goonɗinol mum'en. ");
INSERT INTO fuh_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Wakkati *Ruuhu Ceniiɗo haɗunoo Pol'en waajaade *Habaru lobbo nder leydi Asiya, ɓe tokki nder leyɗe Firigiya e Galatiya ɓe ngari leydi Misiya. ");
INSERT INTO fuh_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Wakkati ɓe ngarnoo he keerol Misiya, ɓe kosi yahde leydi Bitiniya. Amma *Ruuhu Iisa, *Ruuhu Ceniiɗo, faddi ɓe. ");
INSERT INTO fuh_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Nden ɓe tokki nder Misiya ɓe ngari Torowas. ");
INSERT INTO fuh_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Nder jemma mum, Pol hoyɗi. O hi'i Makedoniyanke gom no eela mo, no wi'a : —War nder Makedoniya, paaboɗaa min ! ");
INSERT INTO fuh_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Wakkati Pol waɗunoo koyɗol ngool, law law min he Pol'en min tefi yahde Makedoniya, ngam min tabbintini ko Alla noddi min, min mbaajoo *Habaru lobbo toon. ");
INSERT INTO fuh_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Nyannde gom min ummii Torowas, min naati laana ndiyam, min ponndi duune Samotaras. Min mbaali, jaangoore mum min pa'i Neyapolis. ");
INSERT INTO fuh_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Min ummii Neyapolis, min ponndi Filipi, huɓeere Makedoniya mawne nde leydi Rooma ndawranta. Min ngaɗi mbalkoy nder mayre. ");
INSERT INTO fuh_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","*Nyalaane fowteteene gom min mburtii huɓeere ndeen, min njehi daane maayo. Ngam miɗen miila min ngiitannoo du'orde *Yahudankooɓe toon. Min njooɗii daane maggo, min kaaldi he rewɓe kawruɓe toon gom. ");
INSERT INTO fuh_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Nder maɓɓe no tawa debbo gom, bi'eteeɗo Lidiya, debbo kuloowo Alla, ƴuwɗo huɓeere Tiyatira wari no sonna gude boɗeeje, gude caadiiɗe. Omo jooɗii, omo hettini waaju amin, sey Joomiraawo omti ɓerne makko heɓa o goonɗina ko Pol woni no waajoo. ");
INSERT INTO fuh_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Kanko e koreeji makko fuu ngaɗana *batisma. Gaɗa mum, o eeli min, o wi'i : —Nde nii on njaɓi ko mi goonɗini Joomiraawo, naatee nder ɓaade am, mbeeranon kam. O tinnani min faa min njaɓi. ");
INSERT INTO fuh_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Nyannde gom wakkati min njehannoo to himɓe kawrata ngaɗa du'aa'u, min potti korɗo gom mo ginnaaru bondu gom woni gaɗa mum. Ngam mayru, debbo oo no anndi ko waɗoyta jaaŋo. Rimɓe makko no naforoo mo, no tefa ceede. ");
INSERT INTO fuh_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","O tokki min, min e Pol, o tinni omo huuɓa, omo wi'a : —Himɓe ɓee, ɓe gollanooɓe Alla Toowɗo non. Laawol kisinam ɓe ngoni iɓe mbaajoo. ");
INSERT INTO fuh_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Debbo oo waɗi balɗe no haala haala kaa. Haala ka heƴi Pol, sey Pol wonƴiti wi'i ginnaaru nduun : —Nder innde Iisa *Almasiihu ƴuwu gaɗa makko ! Wakkati mum da ndu ƴuwi gaɗa debbo oon. ");
INSERT INTO fuh_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Wakkati joomiraaɓe makko ɓeen ngi'unoo ko laawol njawdi mum'en hanti, ɓe nanngi Pol e Silas, ɓe njaari yeeso mawɓe huɓeere ndeen. ");
INSERT INTO fuh_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Ɓe ngaddi ɓe yeeso hiitotooɓe, ɓe mbi'i : —*Yahudankooɓe, worɓe ɓee, no ɗon no ngatta fitina nder huɓeere meeɗen. ");
INSERT INTO fuh_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Ɓe ngalaana iɓe mbaajoo finaa-tawaaji karmuɗi to meeɗen, enen ɓiɓɓe leydi *Rooma. ");
INSERT INTO fuh_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Wakkati mum da jama'aare ummodi he maɓɓe. Hiitotooɓe ɓeen ngaɗi kolte maɓɓe ittaa, ɓe ɓoccaa, ");
INSERT INTO fuh_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","ɓe uddaa. Nden ɓe mbi'i doomoowo kasu oon, dooma ɓe faa wooɗa. ");
INSERT INTO fuh_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Wakkati ɓe kokkunoo mo tilsinoore ndee, o watti ɓe faa nder yeesooru kasu oon. O tummbi koyɗe maɓɓe caka lekko tedduko gom, o haɓɓiri callali faa tiiɗi. ");
INSERT INTO fuh_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Caka jemma, Pol e Silas no du'oo, no njimana Alla. Kasunkooɓe gom duu no kettinanii ɓe. ");
INSERT INTO fuh_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Huune fuu nanaaka, sey leydi dimmbii sanne, faa joƴƴinirɗe kasu ɗeen njinngi. Wakkati mum da dammbule kasu ɗeen fuu omtii, callali ɗi kasunkooɓe ɓeen kaɓɓiraa, fuu kaɓɓitii. ");
INSERT INTO fuh_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Wakkati doomoowo oon finunoo, o hi'i dammbule kasu ɗeen fuu no omtii. O miili kasunkooɓe ɓeen fuu ndoggi, ndilli. Sey o sorti takubaahi faa o wara hoore makko. ");
INSERT INTO fuh_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Nden Pol huuɓi he makko, wi'i mo : —To nawnu hoore maa ! Min fuu miɗen ɗon. ");
INSERT INTO fuh_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Wakkati o nanunoo daane ndeen, sey o wi'i, o hokkee yeynirngal. O doggi, o naati nder cuurel to Pol e Silas ngoni. O hofi yeeso Pol e Silas, omo weɗa kak kak. ");
INSERT INTO fuh_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","O wurtini ɓe, nden o ƴami ɓe, o wi'i : —Moodiɓɓe ! Noy ngaɗanmi ko mi hisaa ? ");
INSERT INTO fuh_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Nden ɓe njaabii mo, ɓe mbi'i : —Goonɗin Iisa Joomiraawo, aan he koreeji maa, on fuu, on kisintee. ");
INSERT INTO fuh_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","33","Nder jemma mum, o wurtini ɓe, o looti putte maɓɓe. Ɓe mbaajii mo, kanko he koreeji makko fuu, ɓe ngaɗani ɓe *batisma. ");
INSERT INTO fuh_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Nden o yaari Pol e Silas, nder suudu makko, o hokki ɓe nyaamdu. Kanko e koreeji makko fuu nani belɗum ngam ɓe ngoonɗini Alla. ");
INSERT INTO fuh_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Waali weeti, hiitotooɓe ɓeen lili soogeeji kaalana doomoowo kasu oon, mbi'i Pol e Silas njoofee. ");
INSERT INTO fuh_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Nden doomoowo oon wari wi'i Pol : —Hiitotooɓe ɓeen njoofi on. Jooni oɗon mbaawi mburtii, njehee he jam. ");
INSERT INTO fuh_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Amma Pol fiirti hunnduko, wi'i : —Ɓe ngaɗi min ɓocca caka jama'aare, min kiitanaaka, nden ɓe uddi min nder kasu. Minen duu min ɓiɓɓe leydi *Rooma non. Ɓe nannii min nder kasu, joonin ɓe mburtinan min nder cuccukka naa ? Ɗum waɗataako sam. Tilay kamɓe he ko'e maɓɓe, ɓe ngara ɓe mburtina min ! ");
INSERT INTO fuh_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Nden lilaaɓe ɓeen pillanowi ɗum hiitotooɓe ɓeen. Wakkati ɓe nanunoo ko Pol e Silas no ɓiɓɓe leydi *Rooma, ɓe kuli. ");
INSERT INTO fuh_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Ɓe njehi, ɓe tuubonowi Pol'en. Ɓe njoofi ɓe, amma ɓe eeli ɓe, ɓe ndilla nder huɓeere ndeen. ");
INSERT INTO fuh_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Wakkati ɓe njoofunoo ɓe, Pol e Silas njehi wuro Lidiya, ɓe kawri goonɗinɓe huɓeere ndeen fuu, ɓe cemmbinɗini ɓe, nden ɓe ndilli. ");
INSERT INTO fuh_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pol e Silas ummii Filipi, tokkiri Amifipolis e Apolloni ngari nder Tesalonika, to *Yahudankooɓe ngoodunoo *waajordu. ");
INSERT INTO fuh_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pol naati hano no woowrunoo nder *waajordu Tesalonika. Nyalaaɗe powteteeɗe tati, o naati, omo haalda he himɓe tawaaɓe nder mayru dow Dewtere Seniine. ");
INSERT INTO fuh_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Omo famtina ɓe, omo holla ɓe duu ko Dewtere Seniine wi'i no haani *Almasiihu oon torree, nden o ummintinee. Omo wi'a ɓe ko Iisa oo woni *Almasiihu oon. ");
INSERT INTO fuh_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Nder maɓɓe, woɓɓe ngoonɗini tokki Pol e Silas. Gerekankooɓe heewɓe hulooɓe Alla, he rewɓe heewɓe haalooɓe nanee, tokki ɓe. ");
INSERT INTO fuh_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ɗum monnini *Yahudankooɓe ɓe ngoonɗinaay ɓeen. Ɓe kawri himɓe ɓe limaaka no goɗɗum nder leydi ndiin, ummina fitina nokku fuu nder huɓeere ndeen. Himɓe ɓee, njehi wuro Yason, ɓe tefi Pol e Silas faa ɓe njaara ɓe yeeso mawɓe huɓeere ndeen. ");
INSERT INTO fuh_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Amma ɓe ngiitaay ɓe. Nden ɓe nanngi Yason, he banndiraaɓe mum gom, ɓe njaari yeeso hiitotooɓe ɓeen. Iɓe kuuɓa, iɓe mbi'a : —Himɓe ɓee, umminii hakkillooji duuniyaaru fuu, hannden kamɓe nii wuro meeɗen. ");
INSERT INTO fuh_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Yason weerni ɓe wuro mum ! Iɓe ngaɗa kujje ɗe njahdataa he laabi laamorde meeɗen. Ngam iɓe mbi'a ko no woodi laamiiɗo gom bi'eteeɗo Iisa ko hanaa laamiiɗo meeɗen. ");
INSERT INTO fuh_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Haalaaji kaalaaɗi ɗii ummini hakkillo hiitotooɓe ɓeen, he wonɓe nder huɓeere ndeen. ");
INSERT INTO fuh_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Yason he nanngidaaɓe he mum ɓeen ngaɗaa njoɓi, nden ko ɓe njoofaa. ");
INSERT INTO fuh_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Wakkati jenngunoo, goonɗinɓe gom mballi Pol e Silas mburtii Tesalonika, pa'i Bereya. Wakkati ɓe njottinoo Bereya, ɓe naati *waajordu *Yahudankooɓe gom. ");
INSERT INTO fuh_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","*Yahudankooɓe Bereya no ɓuri *Yahudankooɓe Tesalonika jikku ngasungu. Ɓe njaɓɓori haala kaan juuɗe ɗiɗɗiɗi. Wakkati fuu iɓe njannga dewtere Alla ngam faamude se haalaaji Pol he ko dewtere Alla wi'i no njahda. ");
INSERT INTO fuh_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Heewɓe nder maɓɓe ngoonɗini Alla. Nder Gerekankooɓe duu worɓe ɗuɓɓe, he rewɓe heewɓe haalooɓe nanee, fuu ngoonɗini. ");
INSERT INTO fuh_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Wakkati *Yahudankooɓe Tesalonika ɓeen nanunoo ko Pol waajake haala Alla nder Bereya, ɓe ummii Tesalonika ɓe ngari Bereya. Ɓe kuɓɓi hiite hakkune himɓe, ɓe uppi ɓe ngam ɓe murta. ");
INSERT INTO fuh_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Wakkati mum da, goonɗinɓe Bereya adi Pol njaari daane maayo, ngam o acca wuro ngoon. Amma Silas e Timote kay, njooɗii. ");
INSERT INTO fuh_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Pol e ɗowtirɓe ɗum, naati laana ndiyam ngari Ateena. Nden o lili ɓe, ɓe mbi'a Silas e Timote jaawɗo law law ngara tawa mo Ateena. ");
INSERT INTO fuh_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Wakkati Pol doomannoo Silas e Timote nder huɓeere Ateena, ɓerne makko nyawi sanne ngam huɓeere ndeen no heewi tooruuje. ");
INSERT INTO fuh_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Nder *waajordu Ateena, omo yewtida he *Yahudankooɓe, he ɓe kanaa *Yahudankooɓe kulooɓe Alla. Wakkatiiji gom omo haalda he himɓe nder hiirirde. ");
INSERT INTO fuh_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Nder Ateena jom'en annde luggiɗiɗɗe gom wi'eteeɓe Epikuri'en he Sitoyko'en kaaldi he makko. Wakkati ɓe nanannoo Pol no waajoo dow Iisa e ummitaaki mum, nder maɓɓe woɓɓe no mbi'a : —Ɗume olkoowo oo woni no wi'a ? Woɓɓe duu no mbi'a : —Iɗum nanndi filla diina leyɗe gom. ");
INSERT INTO fuh_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Ɓe adi mo ɓe njaari nokkuure wi'eteene Areyopagus, ɓe ƴami mo ɓe mbi'i : —Aɗa waawi famtinde min maana jannginooje kese ɗee, ɗe ngonɗaa aɗa janngina ? ");
INSERT INTO fuh_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Ngam aɗa haala dow ko min anndaa e ko min meeɗaay nanude abada. Miɗen ngiɗi min paama maana majje. ");
INSERT INTO fuh_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Ngam ɓiɓɓe wuro he hoɓɓe tawaaɓe nder Ateena fuu no njewta naa no kettinoo haalaaji kesi ɗii. ");
INSERT INTO fuh_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Sey Pol ummii darii caka hawriine Areyopagus, wi'i : —Jama'aare, himɓe Ateena, mi hi'i ko diina no nder ɓerɗe mooɗon sanne. ");
INSERT INTO fuh_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Ngam wakkati piiliimi huɓeere mooɗon, mi hi'i kujje ɗe ndewoton, mi hi'i duu no winndaa dow sakkirde mooɗon gom : « *Sakkirde deweteeɗo mo anndaaka. » Too miin, mi wari haalande on filla mo ndewoton baa nde tawaama on anndaa mo. ");
INSERT INTO fuh_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Alla taguɗo duuniyaaru, he ko woni nder mayru fuu, kam woni jom dow e ley. O walaa nder juulirɗe mawɗe nyiɓiraaɗe juuɗe ɓiɓɓe aadama. ");
INSERT INTO fuh_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Walaa fuu ko neɗɗo waawi wallirde mo o wuura, ngam walaa ko njaccani mo. Kanko woni kokkuɗo neɗɗo mbuurnam, foofaango he ko hoddi. ");
INSERT INTO fuh_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","He neɗɗo gooto o itti lenyi ɗuɗɗi, ɗi mbuura nokku fuu dow leydi. O diidi keeri caka leyɗe, o waɗi wakkati fuu he wakkaade mum. ");
INSERT INTO fuh_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Alla waɗaana kujje ɗee fuu ngam himɓe tefa mo. Tawte ɓe memmemtan faa ɓe ngiitowa mo, baa ko o woɗɗaaki neɗɗo meeɗen fuu. ");
INSERT INTO fuh_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Ngam baawɗo haala gom wi'i : « Kanko waɗi eɗen mbuura, eɗen ndilla, yonki duu no nder meeɗen. » Waawɓe haala nder mooɗon gom duu, goonga non mbi'i : « Enen duu, to makko ƴuwɗen. » ");
INSERT INTO fuh_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Ndenne, nde nii enen duu to makko ƴuwɗen, en kaana nanndinde mo he goɗɗum miilaaɗum waɗiraa kanŋe naa cardi naa golle juuɗe ɓiɓɓe aadama. ");
INSERT INTO fuh_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Alla nanngirtaa himɓe wakkati ɓe ngonnoo nder majjere. Amma joonin, o wi'i neɗɗo to tawaa fuu tuuba. ");
INSERT INTO fuh_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Ngam o itti nyalaane nde o hiitotoo duuniyaaru nduu he dartinaaku. O suɓake kiitotooɗo oon. Wakkati o ummintinnoo neɗɗo mo o suɓii oo, o holli goonga e goonga ko neɗɗo oo woni kiitotooɗo oon. ");
INSERT INTO fuh_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Wakkati Gerekankooɓe ɓeen nanunoo ko Alla no waawi ummintina maayɓe, nder maɓɓe woɓɓe no njaltinoo Pol, woɓɓe duu no mbi'a : —Nyannde gom min kettinto haala maa. ");
INSERT INTO fuh_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Nden Pol dilli to maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Nder Gerekankooɓe ɓeen woɓɓe njaɓi tokki Pol, laatii goonɗinɓe. Nder jaɓuɓe tokki ɓeen, no tawa Diyonisiyus jeyaaɗo nder hawriine Areyopagus, debbo gom bi'eteeɗo Damaris, he himɓe gom. ");
INSERT INTO fuh_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Pol ummii Ateena dilli fa'i huɓeere Korintu. ");
INSERT INTO fuh_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Wakkati o yottinoo Korintu, o fotti Yahudanke Pontus gom bi'eteeɗo Akilas, he deekum Piriskilla, warɓe ƴuwi *Rooma, ngam Kalawdiyus, laamiiɗo *Rooma mawɗo wi'i *Yahudankooɓe fuu mburtoo huɓeere mum. Pol higodiri he maɓɓe, ");
INSERT INTO fuh_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","jooɗii, ngollidi he maɓɓe, ngam ɓe fuu ɓe waɗooɓe hukumuuji. ");
INSERT INTO fuh_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","*Nyalaane fowteteene fuu omo yewtida *Yahudankooɓe e Gerekankooɓe nder *waajordu Korintu dow haala Alla. Omo fooɗa hakkillooji maɓɓe, omo tefa jaalaade ɓe, ɓe ngoonɗina Iisa. ");
INSERT INTO fuh_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Garki Silas e Timote ƴuwde Makedoniya, hokki Pol laawol wattude semmbe mum fuu he golle waaju, he tabbintinande *Yahudankooɓe ko Iisa woni *Almasiihu. ");
INSERT INTO fuh_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","O waajii ɓe amma ɓe calii. Ɓe njeddodiri he makko, ɓe tinni iɓe njenna mo. Nden o ummii, o fiɗɗi kolte makko, o wi'i ɓe : —Juuɗe am he koyɗe am ngalaa hen ! Se on kalki, onon anndani ko'e mon. Ɓaawo hannden mi wartataa to mooɗon, to ɓe kanaa *Yahudankooɓe pa'anmi. ");
INSERT INTO fuh_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Pol wurtii *waajordu nduun, yehi takkol mayru, wuro mo hanaa Yahudanke gom bi'eteeɗo Titiyus Yustus, gorko kuloowo Alla. ");
INSERT INTO fuh_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Kirispus, hooreejo *waajordu nduun, he koreeji mum fuu, ngoonɗini Joomiraawo. Himɓe Korintu ɗuɓɓe hettinaniiɓe Pol, ngoonɗini, ngaɗana *batisma. ");
INSERT INTO fuh_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","10","Jemma gom, Joomiraawo wannginani Pol nder koyɗol, wi'i mo : —Taa hulu, to deƴƴitin, neɗɗo fuu waawanaama goɗɗum, ngam miɗo wondi he maaɗa. Tinna waaja, ngam miɗo woodi himɓe heewɓe nder huɓeere ndee. ");
INSERT INTO fuh_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Pol waɗi hitaane he feccere hakkune maɓɓe, omo waajoo, omo janngina haala Alla. ");
INSERT INTO fuh_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Nder jamaanu mo Galliyon ardinoo leydi Akaya, *Yahudankooɓe ngaɗi haɓɓi-daane dow Pol, ɓe nanngi mo, ɓe njaari yeeso hiitotooɓe leydi ndiin. ");
INSERT INTO fuh_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Ɓe peli mo, ɓe mbi'i : —Neɗɗo oo no tefa waylita ko'e himɓe, ɓe ndewa Alla dow laabi ɗi njahdataa he tilsinooje *Tawreeta. ");
INSERT INTO fuh_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pol fiirti hunnduko wi'i no yeccoto, sey Galliyon wi'i *Yahudankooɓe ɓeen : —Onon *Yahudankooɓe, nde nii tawanooma kiite goɗɗum ko dartaaki naa kiite gollal bonngal gom non, nden mi hiitanto on. ");
INSERT INTO fuh_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Amma jooni ko nii geddi dow filla karfeeje, filla inɗe he tilsinooje *Tawreeta non, ɗum daarataa kam. Mi waawaa hiitanii on. ");
INSERT INTO fuh_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","O riiwi ɓe nder hiitordu nduun. ");
INSERT INTO fuh_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Sey ɓe nanngi Sostenes, hooreejo *waajordu Korintu, ɓe ɓocci mo yeeso jama'aare tawaane nder hiitordu nduun. Amma ɗum fuu waɗaay Galliyon wi'a goɗɗum. ");
INSERT INTO fuh_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pol waɗi balɗe nder Korintu no wondi he goonɗinɓe ɓeen. Nden nyannde gom o waynodiri he maɓɓe, o naddi Piriskilla he Akilas laana ndiyam, ɓe pa'i Siriya. Nder Kenkereya Pol tokki finaa-tawaa *Yahudankooɓe, o femmbi hoore makko ngam hunayeere nde o waɗannoo Alla. ");
INSERT INTO fuh_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Wakkati ɓe njottinoo Efeesu, Pol seedi he Piriskilla e Akilas, naatowi nder *waajordu gom. O yewtidi *Yahudankooɓe gom. ");
INSERT INTO fuh_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","*Yahudankooɓe ɓeen eeli mo, o waɗana ɓe mbalkoy amma o jaɓaay. ");
INSERT INTO fuh_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","O wayni ɓe, o wi'i : —Nde Alla jaɓi nyannde gom mi wartan to mooɗon. Nden o naati laana ndiyam, o dilli Efeesu, ");
INSERT INTO fuh_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","o yottowi Kaysariya. O nyakki *Ursaliima, o sanni hawriine goonɗinɓe Iisa. Jahaangal Pol tataɓal Pol ummii *Ursaliima, yehi Antiyokiya. ");
INSERT INTO fuh_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","O waɗi balɗe seɗɗa nder Antiyokiya, nden o dilli. O tokkiri nder Galatiya he Firigiya, omo yaha omo ɓeyda semmbinɗinde aahiiɓe ɓeen fuu. ");
INSERT INTO fuh_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Yahudanke dimaaɗo Alekasandiire bi'eteeɗo Apolos, wari Efeesu. Apolos, neɗɗo baawɗo haala non, jom anndal manngal dow Dewtere Alla. ");
INSERT INTO fuh_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","O janngi laabi tokkol Joomiraawo fuu. Haala Alla no ɓula nder ɓerne makko. Omo waajoroo goonga e goonga huune fuu ko daarata Iisa *Almasiihu baa nii ko *batisma Yahaaya tan o anndi. ");
INSERT INTO fuh_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","O tinni omo waajoroo ɓerne worre. Wakkati Piriskilla e Akilas nanunoo haalaaji makko, ɓe adi mo, ɓe njaari wuro maɓɓe, ɓe pamtini mo faa wooɗi laawol tokkol Alla. ");
INSERT INTO fuh_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Wakkati Apolos waɗunoo haaju yahde leydi Akaya, banndiraaɓe makko goonɗinɓe cemmbinɗini mo, mbinndani *aahiiɓe tawaaɓe toon ɓeen ɗerol ngam ɓe taɓɓitoo mo no wooɗiri. O wari Akaya, nder baawɗe moƴƴere Alla o nafii sanne goonɗinɓe wonɓe Akaya. ");
INSERT INTO fuh_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Ngam waawde haala, omo yedda *Yahudankooɓe, omo liɓa ɓe yeeso himɓe. Omo tuugo dow haalaaji dewte Ceniiɗe, omo holla himɓe ko sikka fuu walaa Iisa woni *Almasiihu mo Joomiraawo suɓii. ");
INSERT INTO fuh_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Wakkati Apolos wonnoo huɓeere Korintu nder leydi Akaya, Pol ummii fedditi baamle cakantaraaje ɗeen, wari Efeesu. Nder Efeesu o tawi aahiiɓe gom, ");
INSERT INTO fuh_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","o ƴami ɓe, o wi'i : —On keɓiino *Ruuhu Ceniiɗo wakkati ngoonɗinoɗon naa ? Nden ɓe njaabii mo, ɓe mbi'i : —Min meeɗaay nanude filla *Ruuhu Ceniiɗo. ");
INSERT INTO fuh_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Pol ƴami ɓe, wi'i kaden : —Ndenne, ir *batisma oye ngaɗanaɗon ? Ɓe njaabii, ɓe mbi'i : —Ir *batisma Yahaaya. ");
INSERT INTO fuh_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pol wi'i ɓe kaden : —Yahaaya no waɗana tuubuɓe *batisma. Omo wi'a ɓiɓɓe *Isra'el tuuba, goonɗina garoowo gaɗa mum. Garoowo gaɗa makko oo woni Iisa. ");
INSERT INTO fuh_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Wakkati ɓe nanunoo haalaaji Pol ɗii, ɓe ngaɗanaa *batisma dow innde Iisa Joomiraawo. ");
INSERT INTO fuh_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Nden Pol deki juuɗe dow maɓɓe. *Ruuhu Ceniiɗo jippii dow maɓɓe, iɓe kaala nder ɗemle feere-fereeje, iɓe ngaɗa annabaaku. ");
INSERT INTO fuh_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Nyannde mum, ɓe *Ruuhu Ceniiɗo jippii dow mum'en no ngaɗa worɓe sappo he ɗiɗo. ");
INSERT INTO fuh_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Lebbi tati, nyannde fuu Pol no naata nder *waajordu *Yahudankooɓe, omo waajoroo ɓerne worre. Omo haalda he hettinaniiɓe mo goonga e goonga, omo fooɗa hakkillooji maɓɓe, omo famtina ɓe dow filla Laamu Alla. ");
INSERT INTO fuh_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Amma tiɓɓe-nyireeɓe gom no tawa hakkune aahiiɓe ɓeen, ɓe calii goonɗinde, ɓe tinni iɓe njaltinoo laawol Iisa *Almasiihu yeeso jama'aare ndeen. Nden Pol dilli accani ɓe nokkuure ndeen. O dillidi he goonɗinɓe jaɓuɓe tokki Iisa ɓeen. Omo janngina ɓe nyannde fuu nder janngirde Tiranus. ");
INSERT INTO fuh_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Duuɓi ɗiɗi omo waajoo faa Yahudanke he mo hanaa Yahudanke leydi Asiya fuu nani haala Joomiraawo. ");
INSERT INTO fuh_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Alla waɗi kaayɗe ɗuɗɗe har juuɗe Pol. ");
INSERT INTO fuh_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Baa tekkere naa koltal meemungal ɓanndu Pol no adee yaaree, yowee dow nyawɓe, ɓe nyawta. Woodunooɓe ginnaaji, ginnaaji ɗiin no njippo, no takkitoo ɓe. ");
INSERT INTO fuh_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Nder *Yahudankooɓe, woɓɓe no piiloo nokku warde nokku iɓe ngollira innde Iisa. Iɓe ndiiwa ginnaaji bonɗi dow nyawɓe, iɓe mbi'a : —Nder barke innde Iisa, mo Pol waajotoo haala mum, njippee, takkitee neɗɗo oo ! ");
INSERT INTO fuh_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Mawɗo *cakkanooɓe Alla gom, Yahudanke bi'eteeɗo Sikewas, ɓiɓɓe mum worɓe jeɗɗo no nder waɗooɓe ir golle ɗee. ");
INSERT INTO fuh_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Nyannde gom, ginnaaru gom jaabii ɓe, wi'i : —Miɗo anndi Iisa, Pol duu miɗo anndi ɗum. Amma onon, on moy'en ? ");
INSERT INTO fuh_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Huune fuu hi'aaka, sey mo ginnaaru nduun woni dow mum oon hippii ɓe, tirfi ɓe semmbe semmbe faa jaali ɓe. O torri ɓe faa ɓe ndoggi, ɓe mburtii suudu nduun ɓalli ɓoli, ɓalli maɓɓe fuu no barmanɗe. ");
INSERT INTO fuh_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Jooɗiiɓe Efeesu fuu, Yahudanke he mo hanaa Yahudanke, nani ko waɗi. Kulkulal manngal nanngi ɓe, ɓe fuu, ɓe tinni iɓe teddina innde Iisa Joomiraawo. ");
INSERT INTO fuh_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Fuɗɗuɓe goonɗinde ɓeen ngari, no towna daane no kaala gacce ɗe ngaɗunoo. ");
INSERT INTO fuh_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Jom'en dobo-dobooji heewɓe ɓotti dewte mum'en, mbuli yeeso himɓe fuu. Dimma ceede dewte bulaaɗe ɗeen, no ngaɗa tammaaje cardi ujunaaji woygu. ");
INSERT INTO fuh_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Nii waɗi ko haala Joomiraawo sankitii, kaa ɓeydi semmbe har baawɗe makko. ");
INSERT INTO fuh_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Gaɗa fii ɓiɓɓe Sikewas, Pol anniyi tokkira Makedoniya e Akaya, nden wara *Ursaliima. O wi'i duu : —Nde nii mi yottake *Ursaliima, tilay mi yaha *Rooma. ");
INSERT INTO fuh_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Sey o lili Timote e Erastus, gollidooɓe he makko gom nder Makedoniya, kanko duu, o jooɗii Asiya balɗe seɗɗa. ");
INSERT INTO fuh_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Gaɗa dilludu Timote e Erastus, Pol tinni no janngina nder huɓeere ndeen. Nyannde gom, ngam sabbu laawol Iisa *Almasiihu ngol Pol woni no janngina, fitina mawɗo gom ummii nder Efeesu. ");
INSERT INTO fuh_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Bahillo ciiwoowo cardi gom bi'eteeɗo Demetirus no siiwa cuuroy cardi nanndukoy he suudu to Artemis, tooruure maɓɓe rewetee. Golle ɗee no ngaddana mo ceede sanne, kanko he siiwooɓe ɓeen fuu. ");
INSERT INTO fuh_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Nyannde gom, o hawri gollidooɓe he makko, he waɗooɓe ir golle ɗee, o wi'i ɓe : —Banndiraaɓe, oɗon anndi ko nder golle ɗee, keɓal meeɗen tawa. ");
INSERT INTO fuh_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Oɗon ngi'a, oɗon nana ko woni no waɗa. Pol wi'i himɓe heewɓe ko tooruuje ɗee, ɗe ngonɗen eɗen ngaɗa kanaa goonga. Hanaa nder Efeesu ɗo tan o wi'i ɗum, amma nder leydi Asiya fuu. Himɓe heewɓe njaɓi haala makko. O wi'i duu ko kujje deweteeɗe, moƴƴiniraaɗe juuɗe ɓiɓɓe aadama kanaa ko neɗɗo rewata. ");
INSERT INTO fuh_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Nde nii ɗum soƴƴoraaki gaɗa fuu, too ɗum biisan en. Himɓe tottitittoo Artemis tooruure teddinaane, nde leydi Asiya e duuniyaaru fuu rewi. Ɓe mboppa suudu dewal mayre. ");
INSERT INTO fuh_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Haalaaji Demetirus ɗii uppi wahilɓe ɓeen fuu. Ɓe tinni iɓe kuuɓa, iɓe mbi'a : —Artemis nder Efeesu, deweteeɗo mawɗo non ! Artemis nder Efeesu, deweteeɗo mawɗo non ! ");
INSERT INTO fuh_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Fitina oo sankitii nder huɓeere ndeen fuu. Ɓe nanngi yahdiraaɓe Pol, Gayus e Aristarkus ɓiɓɓe leydi Makedoniya, ɓe pa'idi ɓe hiirirde Efeesu. ");
INSERT INTO fuh_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pol hiɗiino haalda he jama'aare ndeen amma *aahiiɓe ɓeen kaɗi mo. ");
INSERT INTO fuh_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Gollooɓe mawɓe wonɓe leydi Asiya, laatiiɓe higiraaɓe makko ngaɗii baa lilaaɗo wi'a mo to o fantu hiirirde ndeen. ");
INSERT INTO fuh_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Jama'aare ndeen njiiɓi, woɓɓe no kuuɓa no mbi'a ɗum, woɓɓe duu ko kuuɓata no mbi'a no feere, faa ko heewi anndaa ko waddi ɗum'en. Na'i nii ndiggi gaɗa be'i. ");
INSERT INTO fuh_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Nder jama'aare ndeen, woɓɓe njehi kaalanowi Skandaaru, gorko mo *Yahudankooɓe ardini. Skandaaru ɓanti junngo ngam wi'ude kam no hiɗi haalda he jama'aare ndeen. ");
INSERT INTO fuh_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Amma wakkati jama'aare ndeen faamunoo ko kanko he hoore makko o Yahudanke, ɓe tinni iɓe kuuɓa faa ɗum waɗi jamɗe ɗiɗi iɓe pota, iɓe mbi'a : —Artemis nder Efeesu, deweteeɗo mawɗo non ! ");
INSERT INTO fuh_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Nden hunnduko ardiiɗo huɓeere ndeen heɓi deƴƴini ɓe, wi'i : —Ɓii-Efeesu walaa mo anndaa, ko Efeesu woni hijjorde dewooɓe Artemis, deweteeɗo mawɗo. Hayre makko ƴuwne dow nder Efeesu woni. Neɗɗo fuu duu no anndani ɗum. ");
INSERT INTO fuh_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Walaa baawɗo yeddi haala kaa. Ndenne oɗon kaani ndeƴƴon, pukkinon hakkillooji mooɗon. ");
INSERT INTO fuh_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Worɓe ɓee, ɓe ngadduɗon ɗo, mbujjaay gineeji Artemis, ɓe njennaay mo duu. ");
INSERT INTO fuh_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Nde nii Demetirus he banndiraaɓe mum siiwooɓe cardi no ngoodi ko njukkirta goɗɗo, no woodi to ɓe kaani ɓe njaha, he wakkati mo ɓe kaani yahde. To hiitotooɓe ɓe kaani yahde amma hanaa ɗo. ");
INSERT INTO fuh_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Nde nii tawaama duu oɗon ngoodi ko ngiɗɗon kaalon naa ƴamon, ɗum ndaretee nder hawriine laamu. ");
INSERT INTO fuh_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Ngam nde nii en kakkilaaki, en adetee hano hiɗuɓe murtude. Walaa fuu ko waawi hollude goongaaku kawrol mooɗon ɗo. En ngalaa duu ko woodi semmbe ko kaaleten nde nii en ƴamaama. Ndenne kootee, mi sallimake on. ");
INSERT INTO fuh_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Haalaaji ɗii ngoni ko hunndukoojo ardiiɗo Efeesu haalani ɓe ko ɓe cankitii. ");
INSERT INTO fuh_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Wakkati fitina Efeesu oon hantunoo, Pol hawri aahiiɓe ɓeen, semmbinɗini ɓe, nden wayni ɓe, dilli fa'i Makedoniya. ");
INSERT INTO fuh_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Wakkati o warunoo Makedoniya, o semmbinɗini goonɗinɓe toon ɓeen har yewtereeji makko keewɗi. Nden o dilli o fa'i leydi Geres. ");
INSERT INTO fuh_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","O jooɗii Geres lebbi tati. Wakkati o naatannoo laana yahde Siriya, o nani ko *Yahudankooɓe ngaɗi haɓɓi-daane dow makko. Nden o anniyi soƴƴaade Makedoniya. ");
INSERT INTO fuh_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Omo wondi Sopater ɓii-Pirrus jeyaaɗo Bereya, Aristarkus, Sekundus jeyaaɓe Tesalonika, Gayus jeyaaɗo Derbe. Timote, Tikikus e Torofimus jeyaaɓe leydi Asiya duu no ngondi he makko. ");
INSERT INTO fuh_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Ɓe ngoni ardiiɓe, ndoomowi min, minen e Pol nder Torowas. ");
INSERT INTO fuh_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Gaɗa *Juulɗe buuru mo walaa ƴuufinirɗum, min ummii, min naati laana yahde Filipi. Balɗe joy gaɗa mum min kewti Torowas, min ngaɗi jeɗɗiire toon. ");
INSERT INTO fuh_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","8","Asawe futuro wakkati min nyaamannoo hiraane seniine, min fuu, min kawri nder suudu dowuuru, miɗen nyaama. Fitillaaji ɗuɗɗi kuɓɓaa nder mayru. Sey Pol kaanuɗo dilla nde weeti alal, ummii no waajoo faa yottii caka jemma. ");
INSERT INTO fuh_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Pol junni waaju mum sanne, tawi jokolle gom bi'eteeɗo Ewtikus no jooɗii dow finetere. O ŋoŋi faa o ɗaanii. Ɗoyngol makko moddi sey o ɓiltii illa finetere suudu tataɓuru nduun, o saami. Ko himɓe ngara ada mo, tawi o maayi. ");
INSERT INTO fuh_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Nden Pol jippii, turii dow makko, wunndii mo, no wi'a himɓe pukkina hakkillooji mum'en, o maayaay, nden ummintini mo he maayde. ");
INSERT INTO fuh_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Pol ƴeenyi, taƴi buuru, nyaami, warti, waajii faa weeti, nden dilli. ");
INSERT INTO fuh_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Jokolle oon horraa no wuuri. Ɗum fukkini ɓerɗe maɓɓe sanne. ");
INSERT INTO fuh_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Pol anniyi yahde Asos he koyɗe, nden min ardi, min naati laana yahde Asos to Pol tawoyta min. ");
INSERT INTO fuh_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Wakkati o tawi min Asos, min naddi laana, min pa'i Mitilene. ");
INSERT INTO fuh_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Min ummii Mitilene, jaangoore mum min ngari daane duune Kiyos. Min ummii Kiyos, weeti min ngari takkol duune Samos. Min ummii Samos, min ndilli nyalooma gooto, nden min ngari Miletus. ");
INSERT INTO fuh_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pol hiɗaa daraade Efeesu, ngam to o ɓooyu nder Asiya. Omo hari, nyalaane Juulɗe kettol alkamaari bi'eteeɗe Pentakota ngara, tawa omo *Ursaliima. ");
INSERT INTO fuh_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Nder Miletus Pol waɗi lilaaɓe noddowa ardiiɓe hawriine goonɗinɓe Efeesu. ");
INSERT INTO fuh_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Wakkati ɓe ngarnoo, o wi'i ɓe : —Oɗon anndi, illa hanaa hannden no njooɗoriimi hakkune mooɗon illa garki am arani nder Asiya. ");
INSERT INTO fuh_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Mi gollani Joomiraawo nder leesinaaku, nder mettal ɓerne e torra, wakkati haɓɓi-daaneeji *Yahudankooɓe gaɗaaɗi dow am. ");
INSERT INTO fuh_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Oɗon anndi ko mi suuɗaay on, huune fuu waawde nafude on. Mi waajake on, mi janngini on hakkune himɓe he nder ɓaadeeji mooɗon. ");
INSERT INTO fuh_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Mi holli Yahudanke e mo hanaa Yahudanke fuu tuuba, ngoonɗina Iisa Joomiraawo meeɗen. ");
INSERT INTO fuh_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Joonin, *Ruuhu Ceniiɗo tilsini kam mi yaha *Ursaliima, mi anndaa ko hewtoytoo kam toon. ");
INSERT INTO fuh_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Amma ko anndumi woni, nder huɓeere fuu, *Ruuhu Ceniiɗo hollii kam ko torra e kasu ndoomi kam. ");
INSERT INTO fuh_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Amma miin kay, mi daaraay yonki am goɗɗum. Golle waajaade *Habaru lobbo he moƴƴere Alla, ko Iisa Joomiraawo meeɗen halfini kam, kam woni ko ngiɗumi humnude no wooɗiri. ");
INSERT INTO fuh_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Jooni miɗo anndi ko on ngi'ataa kam kaden, onon ɓe hakkune mum'en mbaajiimi *Habaru lobbo oo. ");
INSERT INTO fuh_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Ngam majjum waɗi nder daane toowne, miɗo wi'a on : Nde gooto nder mooɗon seli laawol, hanaa gacce am non. ");
INSERT INTO fuh_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Ngam mi waajake on dow siri mo Alla waɗani ɓiɓɓe aadama fuu, walaa fuu ko cuuɗumi on. ");
INSERT INTO fuh_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Kakkilee he ko'e mooɗon, ndeenee njawdi ndi *Ruuhu Ceniiɗo halfini on. Laatoɗon durooɓe hawriine goonɗinɓe Alla. Iisa mursi yonki mum ngam hisinde nde. ");
INSERT INTO fuh_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Miɗo anndi ko gaɗa am ir bonɓe ɓee, ɓe guri dawaaɗi, keppataa naatude hakkune mooɗon, ɓe accataa hawriine ndeen duu. ");
INSERT INTO fuh_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Baa hakkune mooɗon, no waɗan fenooɓe ngam pooɗa *aahiiɓe gom tokka ɗum'en. ");
INSERT INTO fuh_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Kakkilee ndenne, miccitee ko duuɓi tati nii, jemma e nyalooma miɗo fooɗa noppi mooɗon dow maɓɓe. Miɗo woyana on ɗum wakkati fuu. ");
INSERT INTO fuh_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Jooni, mi halfini on he Alla e haala mum moƴƴuka. Haala ngooduka baawɗe sinngude hawriine mooɗon. Har makka duu Alla no waawi hokki on ndonngu ngu o fodani seniiɓe makko. ");
INSERT INTO fuh_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Mi suunaaka ceede, kanŋe naa koltal neɗɗo mooɗon fuu. ");
INSERT INTO fuh_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Oɗon anndi ko juuɗe am ngollirmi faa keɓumi ko mbuuriranmi he ko fiirti haajuuji wonduɓe he am. ");
INSERT INTO fuh_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Mi holli on duu ko oɗon kaani gollude ngam wallude ɓe ngalaa baawɗe. Mi holli on duu ko oɗon kaani miccitaade haalaaji ɗi Iisa Joomiraawo meeɗen haali, wakkati o wi'unoo : « Kokkuɗo no ɓuran kokkaaɗo welwelo. » ");
INSERT INTO fuh_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Nden Pol hofidii he maɓɓe, du'ii. ");
INSERT INTO fuh_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Ɗum nanngi ɓerɗe maɓɓe faa gonɗi no mbanjanoo ɓe. Ɓe kippi dow makko, iɓe mbunndoo mo ngam hollude mo enɗam. ");
INSERT INTO fuh_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Ɓerɗe maɓɓe mboni. Amma ko ɓuri bonnude ɓerɗe maɓɓe woni ko Pol wi'i ɓe ngi'ataa ɗum kaden. Ɓe ɗowtiri mo faa to laana kaan. ");
INSERT INTO fuh_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Wakkati min ceedunoo he maɓɓe, min naati laana ndiyam, min pa'i duune Kos. Jaangoore mum min ummii Kos, min ngari duune Rodos. Min ƴuwi Rodos, min ngari Patara. ");
INSERT INTO fuh_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Nder Patara min tawi laana gom njehooka Finisi. Nden min naati ka, min ndilli. ");
INSERT INTO fuh_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Wakkati min njottinoo to neɗɗo hollirta duune Kipurus, min acci nde nano amin, min pa'i har leydi Siriya. Wakkati min ngarnoo Tirus, min ndarii ɗon ngam laana kaan no haani jippinde gineeji gom. ");
INSERT INTO fuh_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Nder Tirus, min tawi *aahiiɓe gom, min njoddii he maɓɓe jeɗɗiire. Nder baawɗe *Ruuhu Ceniiɗo iɓe mbi'a Pol to yehu *Ursaliima. ");
INSERT INTO fuh_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Wakkati jeɗɗiire amin huuɓunoo, min nanngi laawol. Goonɗinɓe Tirus ɓeen ɗowtiri min : Kamɓe, deekiraaɓe maɓɓe e ɓiɓɓe maɓɓe fuu faa min mburtii huɓeere ndeen. Minen he maɓɓe, min fuu min kofi daane maayo ngoon, min ndu'ii. ");
INSERT INTO fuh_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Min mbaynodiri he maɓɓe, min naati laana, kamɓe duu ɓe coƴƴi gaɗa koyɗe maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Wakkati min ngarnoo nder Potolemayis, min cannowi goonɗinɓe tawaaɓe nder huɓeere ndeen. Min nyallidi he maɓɓe, nyalooma oon fuu. ");
INSERT INTO fuh_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Jaangoore mum, min ummii Potolemayis, min ngari Kaysariya. Min njippi wuro baajotooɗo *Habaru lobbo gom bi'eteeɗo Filipa, gooto nder jeɗɗo suɓaaɓe nder *Ursaliima. ");
INSERT INTO fuh_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Filipa no woodi ɓiɓɓe rewɓe nayo, surbaaɓe waɗooɓe annabaaku. ");
INSERT INTO fuh_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Min ngaɗi balɗe toon. Nder balɗe mum, annabiijo gom bi'eteeɗo Agabus ƴuwi Yahudiya, ");
INSERT INTO fuh_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","wari tawi min Kaysariya, o adi tunndorgol Pol, o haɓɓi koyɗe makko e juuɗe makko, o wi'i : —Ɗum woni ko *Ruuhu Ceniiɗo wi'i : « Nder huɓeere *Ursaliima *Yahudankooɓe no nanngan jom tunndorgol ngool, kaɓɓa mo hano no kaɓɓirmi hoore am nii, nden ɓe ngatta mo nder juuɗe ɓe kanaa *Yahudankooɓe. » ");
INSERT INTO fuh_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Wakkati min nanunoo haala kaa, minen he himɓe Kaysariya, min eeli Pol to yaha *Ursaliima. ");
INSERT INTO fuh_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Amma o jaabii, o wi'i : —Ɗume waɗi ko oɗon mboya ? Accee to on taƴee ɓerne am. Mi hulataa haɓɓeede naa wareede nder *Ursaliima ngam sabbu Iisa Joomiraawo meeɗen. ");
INSERT INTO fuh_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Ngam min mbaawaay surude mo, min tinnanaay mo, amma min mbi'i : —Joomiraawo wonnu. ");
INSERT INTO fuh_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Wakkati min ngaɗunoo balɗe seɗɗa nder Kaysariya, min ciryii, nden min pa'i *Ursaliima. ");
INSERT INTO fuh_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","*Aahiiɓe gom ɗowtiri min, ɓe njaari min to Manason jeyaaɗo Kipurus, aahiijo Iisa arano gom. Kanko haani werna min. ");
INSERT INTO fuh_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Wakkati min njottinoo *Ursaliima, goonɗinɓe huɓeere ndeen taɓɓitii min no wooɗiri. ");
INSERT INTO fuh_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Jaangoore mum, ardiiɓe kawrital goonɗinɓe kawri wuro Yakuuba, Pol tokki min yehi toon. ");
INSERT INTO fuh_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Pol sanni tawaaɓe toon fuu, nden fillanii ɓe huune fuu ko Alla waɗi hakkune ɓe kanaa *Yahudankooɓe daliila golle mum. ");
INSERT INTO fuh_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Wakkati ɓe nanunoo haalaaji ɗii, ɓe teddini Alla. Nden ɓe mbi'i Pol : —A hi'i naa banndiraawo, *Yahudankooɓe ujunaaji ujunaaji ngoonɗini Iisa, amma iɓe ngiɗi tokkol *Tawreeta sanne. ");
INSERT INTO fuh_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ɓe nani duu, ko a waajake *Yahudankooɓe jooɗiiɓe nokku nokkuuje fuu ngam ɓe mboppa *Tawreeta, mbi'uɗaa ɓe to ɓe njuulnu sukaaɓe maɓɓe, to ɓe tokku finaa-tawaaji maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Ɗume ngatten jooni ? Tabbat ɓe nanan ko a wari, aɗa ɗo. ");
INSERT INTO fuh_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Ndenne waɗu ko min mbi'ete. Himɓe nayo gom nii wonɓe hakkune amin, waɗanɓe Alla alkawal. ");
INSERT INTO fuh_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Adu ɓe yaaru, ngaɗidon gaba go'o ko *Tawreeta wi'i waɗee ngam laataade laaɓuɓe. Njoɓaa ɓe pemmbee, ɓe laatoo laaɓuɓe. Nde nii a waɗi kujje ɗee, too no faametee ko woni no wi'ee dow maaɗa ɗum baa gootel hanaa goonga. Amma aan he hoore maa a tokkuɗo *Tawreeta. ");
INSERT INTO fuh_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Har ko ndaarata goonɗinɓe Iisa ɓe kanaa *Yahudankooɓe, min mbinndanii ɓe dow ko min kawri, min njardii kam woni : Ɓe kaanaa nyaamude tewu cakkanaangu tooruuje, ƴiiƴam, ko saaɗi, ɓe paddo ko'e maɓɓe he golle jaayɗe hano jeenu. ");
INSERT INTO fuh_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Nden Pol yahdi he worɓe ɓeen. Jaangoore mum, ɓe ngaɗidi huune fuu ko diina *Yahudankooɓe tilsini ngam laaɓinde hoore mum. Gaɗa majjum o yehi nder *Juulirde mawne, o haalani himɓe nyalaane nde laaɓinol ngool timmata, he wakkati mo sadaka neɗɗo maɓɓe fuu waɗetee. ");
INSERT INTO fuh_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Wakkati jeɗɗiire laaɓinol ngool ɓadinoo huuɓude, sey *Yahudankooɓe gom ƴuwɓe Asiya ngi'ii Pol nder *Juulirde mawne ndeen. Ɓe uppi jama'aare ndeen nannga mo. ");
INSERT INTO fuh_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Iɓe kuuɓa, iɓe mbi'a : —Isra'ilankooɓe ! Paabee, nanngee neɗɗo gonɗo no waajoo nokku fuu no wi'a ko lenyi meeɗen, *Tawreeta e Juulirde meeɗen mawne kanaa goonga. Kanko nii naatidi he ɓe kanaa *Yahudankooɓe nder Juulirde meeɗen. Ɓe tunnini nokkuure meeɗen seniine ! ");
INSERT INTO fuh_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Ngam ɓe ngi'idi Pol e Torofimus jeyaaɗo Efeesu nder *Ursaliima, iɓe miila duu ko Pol nannii mo nder Juulirde ndeen. ");
INSERT INTO fuh_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Himɓe *Ursaliima fuu ummii ngari. Ɓe nanngi Pol, ɓe mburtini ɓaade *Juulirde mawne ndeen. Ɓe ommbii law law dammbule ɓaade ndeen. ");
INSERT INTO fuh_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Wakkati ɓe tefannoo warude mo, himɓe gom ndoggi kaalanowi mawɗo soogeeji *Rooma mbi'i ko *Ursaliima fuu irbodiri. ");
INSERT INTO fuh_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Nden o ummii sabbat, o hooƴi soogeeji gom e mawɓe mum'en, o fa'i to jama'aare ndeen. Wakkati himɓe kollirnoo mawɗo soogeeji ɗiin he soogeeji mum, ɓe acci piiɗe Pol. ");
INSERT INTO fuh_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Mawɗo soogeeji ɗiin ɓadii Pol, hokki callali ɗiɗi, wi'i Pol nanngee, haɓɓiree ɗi. Nden o ƴami jama'aare ndeen, moy woni gorko oo ? Ɗume o waɗi ? ");
INSERT INTO fuh_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Nder jama'aare ndeen woɓɓe no mbi'a ɗum, woɓɓe duu no mbi'a ɗumtoo. Olko himɓe haɗi hooreejo soogeeji ɗiin faamude hoore haalaaji maɓɓe. Nden o wi'i Pol yaaree nder kaliyol soogeeji gom. ");
INSERT INTO fuh_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","36","Sey himɓe fuu tokki Pol, no kuuɓa, no mbi'a : —Mbaree mo ! Mbaree mo ! Wakkati Pol yottinoo ƴencirgal suudu nduun, ngam sabbu fitina jama'aare ndeen, soogeeji ɗiin ƴetti mo nanni nder mayru. ");
INSERT INTO fuh_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Wakkati Pol nannetenoo nder kaliyol soogeeji ngool, sey o wi'i hooreejo maggol nder gerekankoore : —Miɗo waawi yeccaade naa ? Nden o jaabii Pol, o wi'i : —Oo ? Aɗa waawi gerekankoore naa ? ");
INSERT INTO fuh_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Ndenne hanaa aan woni ɓii-Misira, mo balɗe jawtuɗe murtini himɓe, ardi murtuɓe ujunaaji nayo, naddi he maɓɓe nder ladde yeeruure ? ");
INSERT INTO fuh_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pol wi'i mo : —Miin, mi Yahudanke Tarsus, huɓeere nde suuɗaaki, nder leydi Silisi. Mi eeli ma, acca mi haalda he himɓe ɓee. ");
INSERT INTO fuh_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Nden hooreejo soogeeji ɗiin hokki mo laawol haaldude he maɓɓe. Pol darii dow ƴencirgal ngal, ɓantani jama'aare ndeen junngo wi'i ɓe kettinoo. Wakkati himɓe fuu ndeƴƴunoo, Pol fuɗɗi haala mum nder aramankoore, wi'i : ");
INSERT INTO fuh_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","—Banndiraaɓe am e baabiraaɓe am, kettinee ko ngiɗumi haalande on ngam lamnude hoore am. ");
INSERT INTO fuh_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Wakkati ɓe nanunoo Pol haali aramankoore, ɓe ngaɗi siw ɓe ndeƴƴiti. Pol itti hunnduko wi'i : ");
INSERT INTO fuh_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","—Miin, mi Yahudanke, mi rimaama Tarsus nder leydi Silisi. Amma *Ursaliima mawnumi. Gamaliyel janngini kam. To makko njanngumi *Tawreeta faa laaɓi tar. Miɗo wakkili he Alla hano no mbakkiliriɗon on fuu hannden he makko. ");
INSERT INTO fuh_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Mi jooɗake miɗo torra tokkuɓe laawol Iisa *Almasiihu faa ɗum yottani ɓe he maayde. Mi nanngi worɓe e rewɓe goonɗinɓe Iisa, mi uddi. ");
INSERT INTO fuh_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Mawɗo *cakkanooɓe Alla e mawɓe hawriine goonɗinɓe Iisa fuu no ceedanoo kam, kam'en duu. Kamɓe he ko'e maɓɓe kokki kam ɗerol ngam mi heɓa laawol yahde to banndiraaɓe meeɗen *Yahudankooɓe wonɓe Damas. Nden njehumi ngam haɓɓoyde goonɗinɓe Iisa, mi wadda ɓe *Ursaliima ɓe njukkee. ");
INSERT INTO fuh_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Wooɗi, ummiimi, pa'umi Damas faa ɓadiimi. Caka nyalooma, wakkati gooto, sey annuura mawɗo gom ƴuwi dow, saami dow am, fiilii kam. ");
INSERT INTO fuh_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Caamumi, sey nanumi daane gom no wi'a kam : « Sol ! Sol ! Ko waɗi aɗa torra kam ? » ");
INSERT INTO fuh_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Nden njaabiimi, mbi'umi : « Joomiraawo ! Aan woni moy ? » Sey nde wi'i kam : « Miin woni Iisa mo Nasaratu, mo ngonɗaa aɗa torra oon. » ");
INSERT INTO fuh_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","10","Nden, mbi'umi : « Joomiraawo, ɗume ngaɗanmi ? » Sey Joomiraawo wi'i kam : « Umma, yehu Damas. Toon, a haalantee fuu ko haani ngaɗaa. » Wonduɓe he am ɓeen ngi'ii annuura oon, amma ɓe nanaay daane haaldude he am ndeen. ");
INSERT INTO fuh_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Ƴelkitol annuura ngool wumni kam, nden ɓe ɗowi kam, ɓe njaari nder Damas. ");
INSERT INTO fuh_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Nder Damas no tawa gorko kuloowo Alla gom, tokkuɗo *Tawreeta bi'eteeɗo Ananiyas. Filla golle makko lobbe no dow ɗemle *Yahudankooɓe Damas fuu. ");
INSERT INTO fuh_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Sey o wari, o darii yeeso am, o wi'i kam : « Banndam Sol, wumtu ! » Wakkati mum da, mbumtumi, ngi'umoomi. ");
INSERT INTO fuh_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Nden o wi'i kam : « Alla maamiraaɓe meeɗen suɓake ma ngam paama muuyɗe mum, ngi'aa Dartiiɗo, nanaa daane makko, ");
INSERT INTO fuh_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","ngam a seedantoo mo yeeso himɓe fuu dow ko ngi'uɗaa e ko nanuɗaa. ");
INSERT INTO fuh_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Joonin, ko ndoomuɗaa ! Umma, ngaɗaneɗaa *batisma, nodda innde Joomiraawo hakkeeji maaɗa njaafee. » ");
INSERT INTO fuh_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Wakkati coƴƴiimi *Ursaliima, nyannde gom miɗo du'oo nder Juulirde *Ursaliima mawne, sey kollaami, ngi'umi, ");
INSERT INTO fuh_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Joomiraawo no wi'a kam : « Yawɗa, mburtoɗaa *Ursaliima, ngam himɓe huɓeere ndeen njaɓataa seedaaku fuu ngu ngaɗata dow am. » ");
INSERT INTO fuh_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Nden njaabiimi, mbi'umi : « Yaa Joomiraawo, iɓe anndi ko miɗo naatannoo nder *baajorɗi, miɗo nannga himɓe, miɗo udda. Miɗo fiya ɓe ngam ɓe ngoonɗini ma. ");
INSERT INTO fuh_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Nyannde Etiyen goonɗinɗo ma waraa, miɗo darii, maayde makko welii kam. Miin duu doomi kolte warɓe mo ɓeen. » ");
INSERT INTO fuh_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Sey Joomiraawo jaabii kam, wi'i kaden : « Umma, wurta, mi lilete faa to woɗɗi, to ɓe kanaa *Yahudankooɓe. » ");
INSERT INTO fuh_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Wakkati jama'aare ndeen nanunoo konngol « mi lilete faa to woɗɗi, to ɓe kanaa *Yahudankooɓe » wurtii nder hunnduko Pol, sey ɓe ƴetti daaɗe maɓɓe dow, ɓe poti, ɓe mbi'i : —Mbaree mo, ittee mo nder duuniyaaru nduu ! O haanaa wuurude sam ! ");
INSERT INTO fuh_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Ɓe tinni, iɓe kuuɓa, iɓe itta kolte maɓɓe, iɓe mbicca leydi. ");
INSERT INTO fuh_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Nden hooreejo soogeeji leydi *Rooma hokki laawol Pol yaaree nder kaliyol mum'en, o ɓoccee heɓa faamee ko waɗi jama'aare ndeen no huuɓa ngam makko. ");
INSERT INTO fuh_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Wakkati ɓe kaɓɓunoo Pol faa o ɓoccee, sey o wi'i soogeeru mawnu wonndu ɗon gom : —Ɓii-Rooma mo hiitanaaka ngiɗɗon ɓoccude fa. Iɗum dagii duu nii ? ");
INSERT INTO fuh_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Wakkati soogeeru nduun nanunoo ko Pol wi'i ɗum, o yehi to mawɗo maɓɓe, o wi'i : —Aɗa anndi ko anniyiɗaa wadde naa ? Gorko oo no ɓii-Rooma ! ");
INSERT INTO fuh_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Nden mawɗo soogeeji ɗiin wari to Pol, ƴami mo, wi'i : —Mbiiɗaa a ɓii-Rooma naa ? Pol jaabii mo, wi'i : —Ayyo, mi ɓii-Rooma ! ");
INSERT INTO fuh_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Nden mawɗo soogeeji ɗiin, wi'i mo : —Ceede re'ataa njoɓumi ko laatiimi ɓii-Rooma. Sey Pol wi'i mo : —Miin, mi fini tawumi mi ɓii-Rooma. ");
INSERT INTO fuh_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Nden anniyiiɓe ɓocca Pol ɓeen takkiti mo. Wakkati hooreejo soogeeji ɗiin duu faamoynoo ko ɓii-Rooma nanngi haɓɓi, kulkulal nanngi mo faa noy walaa. ");
INSERT INTO fuh_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Nyannde mawɗo soogeeji *Rooma faamunoo ko Pol no ɓii-Rooma, o naati tefude maana ko waɗi mawɓe *Yahudankooɓe no tuuma Pol. Jaangoore mum, o noddi mawɓe *cakkanooɓe Alla e hawriine hiitotooɓe potta. O waɗi Pol haɓɓitee waddee daroo yeeso maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pol wari darii yeeso hawriine ndeen, wi'i : —Banndiraaɓe, nyannde ummiimi warde hannden mbuurnam am fuu mi wattaana ɗum naa nder golle Joomiraawo, nder miilo lamngo. ");
INSERT INTO fuh_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Sey Ananiyas, mawɗo *cakkanooɓe Alla wi'i dariiɓe hadde Pol ɓeen, teɓɓa hunnduko Pol. ");
INSERT INTO fuh_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Nden Pol jaabii Ananiyas wi'i mo : —Aan Alla teɓɓata, aan ŋata-fuufowel ! Aan ! Aɗa jooɗii faa kiitoɗaa kam dow tilsinooje *Tawreeta, dey piirta hunnduko mbi'aa mi fiyee. Haalanam toy ɗum winndaa naa ɗum wi'aa nder *Tawreeta ? ");
INSERT INTO fuh_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Darinooɓe hadde makko ɓeen ndoofi mbi'i mo : —Mawɗo *cakkanooɓe Alla, mo Alla suɓii njennataa naa ? ");
INSERT INTO fuh_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pol jaabii ɓe, wi'i : —Banndiraaɓe, mi faamaay ko o mawɗo *cakkanooɓe Alla. Miɗo anndi ko no winndaa wi'aa : To yennu ardiiɗo mooɗon ! ");
INSERT INTO fuh_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Pol no anndi ko nder hiitotooɓe ɓeen, woɓɓe no *Sadduki'en, woɓɓe no *Fariisa'en, ngam majjum waɗi nder daane toowne, o wi'i : —Banndiraaɓe, miin mi Farisaajo, ɓii-Farisaajo. Ngam mi tabbintini ko ummitaaki no goonga, waɗi miɗo hiitee ! ");
INSERT INTO fuh_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Wakkati Pol haalunoo haala kaa, geddi ummii hakkune *Fariisa'en e *Sadduki'en, sey hawriine ndeen fecci. ");
INSERT INTO fuh_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","*Sadduki'en no mbi'a ko ummitaaki walaa, maleykaaɓe ngalaa, ruuhuuji duu ngalaa. *Fariisa'en duu no ngoonɗini ko kujje ɗee fuu no ngoodi. ");
INSERT INTO fuh_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Ɓe tinni iɓe olka, faa olko maɓɓe mawni. Sey jannginooɓe *Tawreeta gom wonduɓe he *Fariisa'en, ndoofi no mbi'a : —Walaa fuu ko boni ko min ngi'ii he gorko oo ! No waawi taweede ruuhu naa maleykaajo haaldi he makko ! ");
INSERT INTO fuh_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Geddi ndiin mawni hakkune maɓɓe faa mawɗo soogeeji ɗiin huli to ɓe ciccitta Pol. Sey o waɗi soogeeji ɗiin njippoo, itta Pol nder juuɗe himɓe ɓeen, njaara mo nder kaliyol mum'en. ");
INSERT INTO fuh_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Pol nannaa nder kaliyol ngool. Joomiraawo wanngani mo nder jemma, wi'i mo : —Taa hulu ! No ceedoraniɗaa kam *Ursaliima nii, no tilsi duu ceedanoɗaa kam nder *Rooma. ");
INSERT INTO fuh_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Pol waali nder kaliyol soogeeji *Rooma, weeti *Yahudankooɓe gom duu kawri ngaɗi haɓɓi-daane, kuni ko kam'en nyaamataa, kam'en njarataa se hanaa kam'en keɓu mbari Pol non. ");
INSERT INTO fuh_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","*Yahudankooɓe kuniiɓe ɓeen ɓuri lasooji ɗiɗo. ");
INSERT INTO fuh_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Ɓe ummii ɓe njehi to mawɓe *cakkanooɓe Alla e mawɓe *Yahudankooɓe, ɓe mbi'i ɗum'en : —Min kunorake Alla ko min nyaamataa, min njarataa, se hanaa min keɓu Pol min mbari non. ");
INSERT INTO fuh_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Joonin, onon he hawriine dawrooɓe, ummee njehee to mawɗo soogeeji *Rooma mbi'on mo, o waɗa Pol waddee, ƴamon ƴamton mo, ngam kiite makko ngaɗa no haaniri. Minen duu, min mbaran mo fadde makko yottaade to mooɗon. ");
INSERT INTO fuh_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Ɓii sakiike Pol debbo nani filla haɓɓi-daane ndeen, sey o yehi nder kaliyol soogeeji ngool, o naati, o haalani Pol filla haɓɓi-daane ndeen fuu. ");
INSERT INTO fuh_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Pol noddi soogeeru mawnu gom, wi'i ndu : —Miɗo hiɗi njaaranaa kam suka gorko oo to mawɗo mooɗon, ngam no woodi ko o hiɗi haalande mo. ");
INSERT INTO fuh_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Soogeeru mawnu nduun yaari mo to mawɗo mum'en, wi'i mo : —Uddaaɗo bi'eteeɗo Pol eeli kam mi wadda suka gorko oo to maaɗa, ngam no woodi ko o hiɗi haalande ma. ");
INSERT INTO fuh_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Nden mawɗo soogeeji oon nanngi junngo suka oon, towtidi seɗɗa he makko, ƴami mo wi'i : —Ɗume ngiɗaa kaalanaa kam ? ");
INSERT INTO fuh_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Sey suka oon fiirti hunnduko, wi'i mo : —*Yahudankooɓe gom kawri faa ngara eele jaaŋo ngadanaa ɗum'en Pol yeeso hawriine dawrooɓe. Ɓe mbi'etee ko kam'en no ngiɗi daarude fii Pol oon no wooɗiri. ");
INSERT INTO fuh_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Amma to njaɓu. Ngam ko waɗata, *Yahudankooɓe lasooji ɗiɗo tunnan Pol. Ɓe kunorake Alla ko ɓe nyaamataa, ɓe njarataa nde kam'en mbaraay Pol. Jooni ɓe ciryake, ko mbi'ataa tan ɓe ndoomi. ");
INSERT INTO fuh_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Nden hooreejo soogeeji oon wi'i suka gorko oon : —War hootu dey ŋata hunnduko maa deƴƴa, taa haalan baa gooto ko mbi'uɗaa kam ɗum. ");
INSERT INTO fuh_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Wakkati mawɗo soogeeji *Rooma nannoo ko suka oon wi'unoo ɗum dow haɓɓi-daane mo *Yahudankooɓe ngaɗi dow Pol, o noddi soogeeji makko mawɗi ɗiɗi gom, o wi'i ɗi : —Kawree worɓe keme ɗiɗo, waɗɗotooɓe pucci lasooji tati e sappo e jom'en labbe keme ɗiɗo. Ciryoɗon jamɗe jeenay hannden jemma, ");
INSERT INTO fuh_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","kirkinon pucci, njaaron Pol no wooɗiri yeeso Filiki guferner Kaysariya. ");
INSERT INTO fuh_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","O winndi ɗerol o hokki ɓe. Nder maggol o wi'i : ");
INSERT INTO fuh_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","—Filiki guferner tedduɗo, miin Kalawdiyus Lisiya, miɗo yewte. ");
INSERT INTO fuh_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Gorko mo lildanmaami oo, *Yahudankooɓe nanngi mo, kuni sey mbara mo. Wakkati paamoymi o ɓii-Rooma, naatumi, miin e sewre soogeeji am, coptinmoomi. ");
INSERT INTO fuh_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Ngam miɗo hiɗi faamude ko ɓe pelirta mo, nanngumoomi ngaddumi yeeso hawriine dawrooɓe. ");
INSERT INTO fuh_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Sey tawumi ko dow fii *Tawreeta maɓɓe tan, ɓe pelirta mo, ndenne gacce makko fotaay o waree naa o uddee. ");
INSERT INTO fuh_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Gaɗa mum, nanumi kaden *Yahudankooɓe kawri, ngaɗi haɓɓi-daane faa mbara mo. Ɗum waɗi ko lildumoomi jooni to maa. Mi tilsini felooɓe mo ɓeen duu ngara to maa, pela mo toon. ");
INSERT INTO fuh_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Soogeeji ɗiin ngaɗi ko mbi'aa. Ɓe ciryii, ɓe mburtodi Pol jamɗe jeenay jemma mum, ɓe njaari mo faa Antipatiris. ");
INSERT INTO fuh_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Waali weeti jaangoore mum, worɓe keme ɗiɗo ɓeen e jom'en labbe ɓeen coƴƴi *Ursaliima nder kaliyol mum'en. Waɗɗiiɓe pucci ɓeen njaari Pol Kaysariya. ");
INSERT INTO fuh_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Wakkati ɓe njottinoo Kaysariya ndeen, ɓe kokki guferner oon ɗerol binndaangol ngool, ɓe ngatti Pol nder juuɗe makko. ");
INSERT INTO fuh_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Guferner oon janngi ɗerol ngool, nden ƴami Pol wi'i : « Toy njeyaɗaa ? » Pol jaabii mo wi'i : « Leydi Silisi. » ");
INSERT INTO fuh_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Nden o wi'i Pol : —Mi noddete nde nii felooɓe ma ngari. O hokki laawol Pol faddee nder laamorde *Hirudus. ");
INSERT INTO fuh_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Balɗe joy gaɗa garki Pol nder Kaysariya, Ananiyas mawɗo *cakkanooɓe Alla kam duu wari nder Kaysariya. Omo wondi he mawɓe gom, omo wondi duu he Tertullus neɗɗo jannguɗo laabi kiite leydi *Rooma ngam tettinde himɓe nder kiite. Ɓe fuu ɓe ngaraana ngam felude Pol yeeso guferner oon. ");
INSERT INTO fuh_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Pol noddaa wari darii yeeso Filiki. Tertullus fuɗɗi felude mo, fiirti hunnduko wi'i : —Alla sabbinane guferner ! Sabbu maaɗa, e laabi kesi ɗi ndarnuɗaa nder jamaanu maaɗa waɗi jam jippii hakkune amin. ");
INSERT INTO fuh_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Nokku fuu aɗa yettee jettooje ɗe ngalaa keerol. ");
INSERT INTO fuh_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Jooni nii to mi junnu haala, mi ŋaarake ma, kettinoɗaa min seɗɗa. ");
INSERT INTO fuh_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Min taykake min ndaari sey min tawi ko gorko oo no bonɗo faa hanaa seɗɗa. Neɗɗo oo kuɓɓoowo fitina non hakkune *Yahudankooɓe to ɓe tawa fuu. O ardiiɗo sewre diina himɓe Nasaratu. ");
INSERT INTO fuh_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","O waɗi no waɗee fuu ngam o liɓa darja *Juulirde amin mawne. Ɗum waɗi min nanngi mo. Min ngiɗiino hiitanaade mo dow laabi kiite amin, ");
INSERT INTO fuh_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","amma Lisiya mawɗo soogeeji *Rooma teeti mo semmbe semmbe nder juuɗe amin, ");
INSERT INTO fuh_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","hokki laawol felooɓe mo ɓeen ngara, pela mo to maa. Aan he hoore maa, aɗa waawi ƴami mo, ngam paama goonga e goonga ko waɗi miɗen pela mo. ");
INSERT INTO fuh_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","*Yahudankooɓe tawaaɓe toon ɓeen tokkitii haala Tertullus, mbi'i goonga nii Tertullus haali. ");
INSERT INTO fuh_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Guferner Filiki wonƴiti har Pol hokki mo laawol haalude. Pol fiirti hunnduko wi'i : —Hanaa hannden tan, amma illa ko ɓooyi miɗo anndi ko aan woni kiitantooɗo leydi amin. Ngam majjum waɗi ko sikka fuu walaa miɗo waawi tettinde hoore am yeeso maa nder kiite ɗee. ");
INSERT INTO fuh_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Mi ɓuraay balɗe sappo e ɗiɗi he warde nder *Ursaliima ngam rewude Alla. Nde nii a taykake, a faaman ko mi ɓuraay non. ");
INSERT INTO fuh_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Walaa tawɗo kam nder *Juulirde mawne, nder *baajorɗi naa to gom nder huɓeere *Ursaliima, miɗo yeddodira he goɗɗo naa miɗo uppa jama'aare murta. ");
INSERT INTO fuh_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Huune fuu ko ɓe tuumiri kam, nder maɓɓe walaa baawɗo tabbintinde ɗum. ");
INSERT INTO fuh_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Amma jooni yeeso maa, he daane toowne, miɗo anndi ko mi waraana rewude Alla maamiraaɓe amin dow laawol Alla. To maɓɓe laawol ngool hanaa goonga, ngol sewre diina tan. Amma miin, mi goonɗini ko winndaa fuu nder *Tawreeta e nder dewte annabiiɓe, ");
INSERT INTO fuh_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","kam woni ko Alla accataa maayɗo baa gooto. O ummintinan dartiiɓe, o ummintinan bonɓe duu. Huune ndee duu mi tabbintinti ɗum, tuumooɓe kam ɓee duu tabbintini ɗum. ");
INSERT INTO fuh_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Ngam majjum waɗi wakkati fuu miɗo dartii nder miilo laaɓuŋo ngo felataa kam yeeso Alla he yeeso himɓe. ");
INSERT INTO fuh_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Ko wayri kam ɗo waɗi duuɓi. Mi wari jooni yeddande himɓe amin kokke he waɗande Alla sadakaaji. ");
INSERT INTO fuh_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Nder *Juulirde mawne toon ngonmi ko ɓe tawi kam. Mi gayni golle laaɓinol am fuu, mi wondaa fuu he jama'aare gom. Fitina fuu duu waɗaay. ");
INSERT INTO fuh_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Amma *Yahudankooɓe Asiya no ngonnoo nder Juulirde ndeen. Nde nii iɓe ngoodunoo ko ɓe pelirta kam, kamɓe kaani ngara pela kam yeeso maa. ");
INSERT INTO fuh_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Naa wakkati ngaddaami yeeso hiitorde maɓɓe, himɓe wonɓe ɗo nanngiri kam gacce gom ? Nde nii ɓe nanngiri kam gacce gom, ɓe kaala. ");
INSERT INTO fuh_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Yeeso hawriine dawrooɓe nder daane toowne mi wi'i ko mi tabbintini ko Alla no ummintinan maayɓe. Haala ka kaalumi kaa tan woni no waɗa mi hiitee yeeso maaɗa naa ? ");
INSERT INTO fuh_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Guferner oon no anndi laawol Iisa *Almasiihu, ngam majjum waɗi o itti hunnduko o wi'i Pol'en : —Mi hiitotoo fii mooɗon oo wakkati Lisiya, mawɗo soogeeji *Rooma, wari. Kiite ɗeen eggina faa nyannde gom. ");
INSERT INTO fuh_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","O hokki laawol mawɗo soogeeji ɗiin faddoo Pol, amma to o haɓɓee. To higiraaɓe makko duu kaɗee tuntaade mo. ");
INSERT INTO fuh_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Pol waɗi balɗe no uddii. Nyannde gom guferner Filiki wardi he deekum Yahudanke bi'eteeɗo Durusilla ngam tuntaade Pol. Filiki waɗi Pol noddaa, o hettini Pol no haala dow filla goonɗinde Iisa *Almasiihu. ");
INSERT INTO fuh_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Nden Pol tinni no famtina dow noy neɗɗo wuurirta ngam wela Alla. Noy neɗɗo watta ko waawa hoore mum. O wi'i duu ko Alla no hiitoto duuniyaaru fuu. Sey Filiki huli, wi'i Pol : —Heƴi hannden kay ! Jooni soƴƴa jooɗowa. Wakkati keɓumi daama fuu, mi waɗan noddeɗaa. ");
INSERT INTO fuh_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Filiki no miila ko Pol soodan hunnduko mum waɗi o ƴuwtaa dow makko. Wakkati warde wakkati omo nodda mo ngam ɓe njewtida. ");
INSERT INTO fuh_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Pol waɗi duuɓi ɗiɗi no uddii. Sey nyannde gom Filiki ittaa guferner, Porsiyus Festus naati nokku makko. Amma ngam welnude ɓerɗe *Yahudankooɓe Filiki dilli, acci Pol no uddii. ");
INSERT INTO fuh_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Balɗe tati gaɗa garki Festus ngam fuɗɗude golle gufernaaku, o ummii Kaysariya o wari *Ursaliima. ");
INSERT INTO fuh_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Mawɓe *cakkanooɓe Alla e ardiiɓe *Yahudankooɓe gom ngari peli Pol yeeso makko. ");
INSERT INTO fuh_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Ɓe eeli mo o waɗa Pol waddee *Ursaliima ngam ɓe ciryake *Yahudankooɓe warooɓe Pol gom, ɓe ndesi dow laawol. ");
INSERT INTO fuh_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Amma Festus jaabii ɓe wi'i : —Pol no uddii nder Kaysariya. Mi ɓooyataa *Ursaliima, miin he hoore am mi soƴƴoto Kaysariya. ");
INSERT INTO fuh_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Mawɓe mooɗon ngara min njaada, nde tawi Pol waɗi ko foti feleede, ɓe pela mo. ");
INSERT INTO fuh_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Guferner Festus waɗidaayna he maɓɓe balɗe jeetati naa balɗe sappo nder *Ursaliima, nden soƴƴii Kaysariya. Nder Kaysariya o waali, weeti jaangoore mum, o waɗi Pol waddee nder hiirirde ndeen ngam hiitanaade mo. ");
INSERT INTO fuh_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Pol wari, nden mawɓe *Yahudankooɓe warɓe ƴuwi *Ursaliima ngatti mo caka tinni no pelira mo gacce keewɗe. Amma ɓe mbaawaa tabbintinde baa worre nder majje. ");
INSERT INTO fuh_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Pol ummii ngam tettinde hoore mum wi'i : —Walaa gacce ɗe ngaɗumi, daarooje *Tawreeta naa ƴeewooje *Juulirde mawne. Mi waɗanaay laamiiɗo *Rooma gacce fuu. ");
INSERT INTO fuh_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Amma ngam welnude ɓerɗe *Yahudankooɓe ɓeen, Festus ƴami Pol, wi'i : —Aɗa hiɗi yahde *Ursaliima, kiiteneɗaa toon yeeso am ? ");
INSERT INTO fuh_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Nden Pol jaabii, wi'i : —Nder sarɗorde Kaysar laamiiɗo *Rooma mawɗo ngonmi, ɗon duu kaanaami hiitaneede. Walaa gacce ɗe ngaɗanmi *Yahudankooɓe, aan he hoore maa aɗa anndani ɗum. ");
INSERT INTO fuh_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Nde nii mi nanngiraama gacce gom naa mi waɗi ko foti wareede mi salaaki wareede. Amma goonga fuu walaa nder ko ɓe peliri kam. Ndenne, walaa gooduɗo laawol watta kam nder juuɗe maɓɓe. Miɗo eela kiite am ɗee njaaree yeeso Kaysar. ");
INSERT INTO fuh_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Guferner Festus yewtidi saawidirooɓe mum, nden wi'i Pol : —A eeli kiite maa njaaree yeeso Kaysar. Yeeso Kaysar kiite maa njaaretee. ");
INSERT INTO fuh_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Guferner Festus adi laawol yaarude kiite Pol yeeso Kaysar, balɗe seɗɗa gaɗa mum, laamiiɗo Agirippa e mawnum debbo bi'eteeɗo Bernike, ngari Kaysariya ngam barkitaade Festus. ");
INSERT INTO fuh_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Ɓe ngaɗi balɗe Kaysariya iɓe njewtana Festus. Nyannde gom Festus waɗani Agirippa filla Pol, wi'i : —Gorko gom, mo Filiki acci no ɗo, no uddii nder Kaysariya. ");
INSERT INTO fuh_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Nder njaaki am *Ursaliima mawɓe *cakkanooɓe Alla e mawɓe *Yahudankooɓe ngari peli mo to am, ɓe eeli kam mi taƴa kiite makko. ");
INSERT INTO fuh_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Njaabiimi ɓe, mbi'umi : Nder leydi *Rooma, min mboowaay hiitanaade pelaaɗo fuu nde hanaa omo darii felooɓe mo ɓeen duu nii no darii. O hokkee laawol tefude tettinde hoore makko. ");
INSERT INTO fuh_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Mawɓe *cakkanooɓe Alla e ardiiɓe *Yahudankooɓe gom tokki kam ngari ɗo. Miin duu, mi jooɗaaki fuu ndoomumi goɗɗum. Waali weeti nyannde ɓe ngarnoo, ngaɗumi o waddee nder hiirirde ngam hiitanaade mo. ");
INSERT INTO fuh_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Warɓe ngam felude mo ɓeen ngari, ndarii. Mi miilii ko iɓe ngoodi daliila mawɗo mo ɓe pelirta mo. Amma kas ! ");
INSERT INTO fuh_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Dow filla laabi diina maɓɓe e dow fii neɗɗo gom bi'eteeɗo Iisa, ɓe tinni iɓe pelira mo. Neɗɗo bi'eteeɗo Iisa oo maayi amma Pol no wi'a omo wuuri. ");
INSERT INTO fuh_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Ɗum wemmbii kam, mi anndaa fuu ko mbi'anmi. Nden ƴamumi Pol nde no jaɓa kiite mum ngaɗaa *Ursaliima. ");
INSERT INTO fuh_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Amma o eeli kam kiite makko ngattee nder juuɗe Kaysar. Wakkati o eelunoo kam ndeen, mbi'umi o faddee ginan. Nde keɓumi laawol fuu mi daaran no ngaɗanmi o yaaree to Kaysar. ");
INSERT INTO fuh_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Sey Agirippa jaabii Festus, wi'i mo : —Miin he hoore am, miɗo hiɗi mi narra nowru am ko gorko oo wi'ata. Nden Festus wi'i mo : —Jaaŋo o waran, a nanan ko o wi'ata. ");
INSERT INTO fuh_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Waali weeti, Agirippa e mawnum debbo Bernike, ngari no ƴuggini, ɓe naati nder hiirirde to kiite Pol ngaɗetee. Soogeeji mawɗi he mawɓe huɓeere ndeen no tokki. Festus waɗi Pol waddaa. ");
INSERT INTO fuh_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Nden o wi'i : —Laamiiɗo Agirippa e onon tawaaɓe ɗo, on ngi'ii gorko oo, kanko woni mo *Yahudankooɓe fuu ngari peli to am nder *Ursaliima. On ngi'ii ɓe ngari ɗo duu ɓe peli mo, ɓe mbi'i : Barol woni dow makko. ");
INSERT INTO fuh_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Amma miin he hoore am, mi hi'aay ko o waɗi ko foti wareede. Kanko he hoore makko, eeli kam kiite makko njaaree to Kaysar. Miin duu mbi'umi kiite makko no njaaretee to Kaysar. ");
INSERT INTO fuh_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Amma mi walaa fuu haala tabbitikka dow makko, ka mbinndananmi ɓurɗo baawɗe nder *Rooma fuu. Ngam majjum waɗi ngaddumoomi yeeso mooɗon. Mi waddi mo duu yeeso maaɗa, aan Agirippa. Ƴamu mo, aan he hoore maaɗa. Nden miin duu, mi heɓan ko mbinndananmi Kaysar. ");
INSERT INTO fuh_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Ngam he giiɗe am yaarude kasunke yeeso Kaysar, neɗɗo winndaay ngam famtinde ko waɗi o felaa, huune non nde hegaaki. ");
INSERT INTO fuh_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Pol no darii nder hiirirde ndeen, sey Agirippa wi'i mo : —A hokkaama laawol haalude. Haalu haala maa. Nden, Pol ɓanti junngo mum, jaabii, wi'i : ");
INSERT INTO fuh_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","—Laamiiɗo, mi nani belɗum sanne hannden ngam heɓude laawol daraade yeeso maaɗa faa mi tettina hoore am dow ko *Yahudankooɓe pelirta kam ɗum fuu. ");
INSERT INTO fuh_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Aɗa anndi finaa-tawaaji *Yahudankooɓe, aɗa anndi duu geddi fuu wondi hakkune maɓɓe e himɓe. Ngam majjum waɗi miɗo eele, ngatta munyal kettinoɗaa kam. ");
INSERT INTO fuh_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","*Yahudankooɓe fuu no anndi no mbuurdumi illa cukaaku am. Iɓe anndi no njooɗoriimi fuu nder suudu baaba am he nder *Ursaliima. ");
INSERT INTO fuh_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Iɓe anndi, nde nii ɓe calaaki seedaade, ko illa arannde mi tokkuɗo laawol diina amin, laawol ɓurngol tiiɗude faa miɗo limtee nder *Fariisa'en. ");
INSERT INTO fuh_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Joonin, miin nii miɗo hiitee ngam mi watti gokka am dow fodoore nde Alla waɗani maamiraaɓe meeɗen. ");
INSERT INTO fuh_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Lenyi meeɗen sappo e ɗiɗi ɗiin fuu no ngatti gokka mum'en dow tabbintinde alkawal Alla ngaal. Jemma e nyalooma, iɗi tittinkini nder dewol Alla ngam heewtaade fodoore ndee. Laamiiɗo, ngam sabbu gokka kaa waɗi *Yahudankooɓe no pela kam ! ");
INSERT INTO fuh_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Ko waɗi onon *Yahudankooɓe, oɗon miila ko Alla waawaa ummitinde maayɓe ? ");
INSERT INTO fuh_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Miin he hoore am, nder balɗe jawtuɗe mi miiliino ko no haani no ngaɗan mi fuu, mi bonna innde Iisa mo Nasaratu. ");
INSERT INTO fuh_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Kujje ɗee fuu ngoni ko ngaɗumi nder huɓeere *Ursaliima. Mawɓe *cakkanooɓe Alla kokki kam laawol mi udda goonɗinɓe heewɓe. Wakkati ɓe kiitantenoo faa ɓe mbaree, mi jaɓi ɓe mbaree. ");
INSERT INTO fuh_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Mi torri ɓe kile keewɗe nder *baajorɗi. Miɗo tilsina ɓe, ɓe kaala haalaaji mettuɗi dow *Almasiihu mo ɓe ngoonɗini oon. Miɗo nanannoo mone maɓɓe sanne sanne, faa miɗo tayna ɓe nder gure janaane, miɗo torra ɓe. ");
INSERT INTO fuh_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Nyannde gom mawɓe *cakkanooɓe Alla kokki kam laawol nanngude goonɗinɓe Iisa nder huɓeere Damas sey ummiimi njehumi Damas. ");
INSERT INTO fuh_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Laamiiɗo, miɗo wonnoo dow laawol Damas caka nyalooma, sey ngi'umi jeyngol gom, ingol ɓuri naange yeynude. Ngol ƴuwi dow, ngol fiilii kam, miin he yaadiraaɓe am fuu. ");
INSERT INTO fuh_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Min fuu, min caami. Wakkati min fuu min ngonnoo e leydi, sey nanumi daane gom no wi'a kam nder Ibrankoore : « Sol ! Sol ! Ko waɗi aɗa torra kam ? Nde mbanyuɗaa kam, a torri hoore maaɗa ngam meere. » ");
INSERT INTO fuh_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Nden njaabiimi, mbi'umi : « Joomiraawo ! Aan woni moy ? » Daane ndeen wi'i kam : « Miin woni Iisa mo ngonɗaa aɗa torra. ");
INSERT INTO fuh_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Umma, dara, ngam mi wanngani ma, mi suɓake ma ngam ngollanaa kam, ceedanoɗaa kam nder ko ngi'uɗaa joonin dow am he ko ngi'oyta nde mi wanngi he maa yahde yeeso. ");
INSERT INTO fuh_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Mi reenete he *Yahudankooɓe, mi reenete he lenyol gom ngol lilanmaami he mum'en joonin. ");
INSERT INTO fuh_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Mi lilete ngam piirta gite maɓɓe, ɓe ƴuwa nder nimre, ɓe ngarta nder jeyngol. Ɓe copto baawɗe Ibiliisa, ɓe naata Laamu Alla. Ɓe keɓa hakkeeji maɓɓe njaafee, kamɓe he seniiɓe kawtida ndonu ngam ɓe ngoonɗini kam. » ");
INSERT INTO fuh_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Ngam majjum laamiiɗo, mi salaaki ɗowtanaade ko ngi'umi, ƴuwanɗum kam dow. ");
INSERT INTO fuh_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Ɓe artumi waajaade ɓeen ngoni himɓe Damas, himɓe *Ursaliima he fiiliiɓe leydi Yahudiya fuu. Gaɗa mum, tokkinmi himɓe lenyi gom. Mbi'umi ɓe, ɓe tuuba, ɓe ngarta he Alla. Ɓe ngolla golle kollooje ɓe tuubii. ");
INSERT INTO fuh_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Ngam majjum waɗi *Yahudankooɓe nanngi kam nder *Juulirde mawne, ɓe tefi warude kam. ");
INSERT INTO fuh_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Amma Alla wallii kam illa nyannde mum faa warde hannden. Ngam majjum waɗi miɗo ɗo hannden ngam haalande mawɗo yahde pamaro goonga. Mi waajataako huune fuu nde hanaa ko annabiiɓe he Muusa mbi'unoo no warowan. ");
INSERT INTO fuh_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Kanƴum woni : *Almasiihu no torretee faa maaya, o arta maayɓe ummitaade, o waajoo lenyi meeɗen he lenyi gom fuu dow kisinam, ɗam laatanoo ɓe jeyngol. ");
INSERT INTO fuh_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Wakkati Pol haalannoo ndeen, sey Festus hacci he makko, wi'i : —Pol, a haaŋaama ! Anndal maaɗa ngal haaŋii ma ! ");
INSERT INTO fuh_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Nden Pol jaabii mo, wi'i : —Sabbuŋo maaɗa juuta, mi haaŋaaka. Ko kaalanmi ɗum no goonga. Hakkillo am soptaay baa. ");
INSERT INTO fuh_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Agirippa no anndani ɗum, ngam majjum waɗi miɗo suusi haalude ɗum yeeso makko. Nde goonga, mi tabbintini ko ɗum suuɗanaaki mo, ngam ɗum waɗaaka nder cuccukka. ");
INSERT INTO fuh_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Laamiiɗo ! A goonɗini annabiiɓe naa ? Miɗo anndi ko a goonɗini ! ");
INSERT INTO fuh_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Sey Agirippa wi'i Pol : —Ndenne nder wakkati seɗɗa oo, aɗa hiɗi ngaɗaa kam law law goonɗinɗo *Almasiihu naa ? ");
INSERT INTO fuh_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Nden Pol jaabii mo, wi'i : —Juuti neeɓi miɗo eela Alla, aan he hettinaniiɓe kam joonin on fuu laatoɗon hano am, amma tawee callali ɗi ngalaa he mooɗon. ");
INSERT INTO fuh_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Laamiiɗo oon, guferner oon, Bernike he jooɗodinooɓe he maɓɓe ɓeen fuu ummii. ");
INSERT INTO fuh_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Wakkati ɓe mburtinoo ndeen, iɓe mbi'odira : —Gorko oo waɗaay ko foti wareede naa ko foti haɓɓireede callali. ");
INSERT INTO fuh_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Sey Agirippa wi'i Festus : —Omo waawi yoofeede nde nii o wi'aayno kiite makko njaaree to Kaysar, laamiiɗo *Rooma mawɗo. ");
INSERT INTO fuh_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Wakkati njaaki amin leydi Italiya tabbitinnoo ndeen, Pol e kasunkooɓe gom ngattaa nder junngo Yuliyus, mawɗo soogeeji gonɗo nder sewre soogeeji Kaysar. ");
INSERT INTO fuh_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Min naati laana ndiyam ƴuwka Adaramatiya, kaanuka fanta gure leydi Asiya, gure tawaaɗe dow hunnduko ndiyam. Miɗen ngondi he Aristarkus gorko jeyaaɗo leydi Makedoniya, ƴuwɗo Tesalonika. Min ndilli Kaysariya, ");
INSERT INTO fuh_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","jaangoore mum weeti, tawi min njottake Sidon. Yuliyus nani yurmeene Pol, hokki mo laawol tuntowaade higiraaɓe makko wonɓe nder Sidon ngam ɓe keɓa ko ɓe mballiri mo. ");
INSERT INTO fuh_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Wakkati min ƴuwnoo Sidon, henndu mawnu woni no njaɓɓitoo min. Nden min tokkiri fonngo duune Kipurus. ");
INSERT INTO fuh_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Min pedditi hedde har Silisi e Pamfiliya. Min njottii Mira nder leydi Lisiya. ");
INSERT INTO fuh_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Mira toon, Yuliyus tawi laana ƴuwka Alekasandiire no fonndi Italiya. O nanni min nder makka. ");
INSERT INTO fuh_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Min ngaɗi balɗe, laana amin no yaha heese heese. Da cat he walaa hawli ko min njottii Kinidus. Henndu nduun haɗi min, min tokka to min kaani tokkirde. Nden min takki fonngo duune Kereta har to henndu walaa, min panti Salmoni. ");
INSERT INTO fuh_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Da cat ko min njottii nokkuure wi'eteene Jipporde Lobbere, nde woɗɗaa Lasiya. ");
INSERT INTO fuh_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Ngam min ɓooyi sanne dow laawol, jahaangal ngaal duu no hulƴinii jooni. Wakkati Juulɗe moytol hakkeeji ngari, faa njawti. Nden Pol holliti ɓe wi'i : ");
INSERT INTO fuh_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","—Banndiraaɓe, mi hi'i ko jahaangal meeɗen ngal no keewngal torra he balaa'u. Hanaa ngam laana kaa he gineeji ɗii tan, amma enen he ko'e meeɗen duu no waawi laataade mursen yonkiiji meeɗen. ");
INSERT INTO fuh_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Yuliyus, mawɗo soogeeji oon, hoolaaki hollitoore Pol ndeen. Sey o hettinani ko mawɗo awƴooɓe laana kaan he joomiika mbi'i. ");
INSERT INTO fuh_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Ɗuuɗal himɓe tawaaɓe nder laana kaan ngiɗaa dabba nder jipporde ndeen ngam ɗon welaa dabbude. Nden ɓe mbi'i kam'en tefowa yottaade Fenikisa ngam dabbude toon. Fenikisa jipporde laanaaji non wonnde Kereta huccitidde caka hoore huɗo he gorgal, he caka soɓɓirde he gorgal. ");
INSERT INTO fuh_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Kenel hoore-huɗowel gom fuɗɗi no wifa, gollooɓe nder laana kaan miili ko kam'en mbaawan yottaade Fenikisa. Ɓe ƴeencini jamɗe darnooje laana ɗeen, ɓe takki fonngo Kereta, iɓe njaha yahde. ");
INSERT INTO fuh_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Amma wakkati seɗɗa gaɗa mum, sey henndu mawnu gom ƴuwanndu soɓɓirde huccitidde lettugal, ummiroy semmbe semmbe illa duune Kereta. ");
INSERT INTO fuh_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Henndu nduun taɓɓiti laana kaan faddii ka, min acci ka, ika doya yahde. ");
INSERT INTO fuh_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Wakkati min njawtunoo duungel Kawda, semmbe mayru ɓuyti seɗɗa. Da cat ko min keɓi, min pooɗi ngel, min ngartiri laanel pamarel ngel hadde laana mawka kaan. ");
INSERT INTO fuh_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Sey gollooɓe ɓeen ƴetti ngel, njowi dow laana mawka kaan. Nden ɓe kooƴi ɓoggi, ɓe piilii laana mawka kaan. Ngam hulude to ɓe nufoy dow fonngo nder soɓɓirde Libiya, ɓe njippini guda ngaɗoowa laana kaan dilla, ɓe acci ika doya yahde. ");
INSERT INTO fuh_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Henndu nduun tokki no yonka min faa jaangoore mum ɓe puɗɗi iɓe paɗɗa donle laana kaan nder maayo ngoon. ");
INSERT INTO fuh_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Faɓɓi jaangoore mum, kamɓe he ko'e maɓɓe adi gineeji gollirɗi maɓɓe paɗɗi nder maayo ngoon. ");
INSERT INTO fuh_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Naange he koode ngaɗi balɗe ngi'ataake. Henndu nduun tinni no wifa, faa min itti gokka kisol fuu nder ɓerɗe amin. ");
INSERT INTO fuh_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Min ngaɗi balɗe, min nyaamaay. Sey nyannde gom Pol ummii darii hakkune jama'aare fuu, wi'i : —Nde nii on njaɓiino haala am, on ndillataano Kereta, torraaji ɗii he mursere ndee duu hewtotaako on. ");
INSERT INTO fuh_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Joonin, ko kaalananmi on woni pukkinee hakkillooji mooɗon, baa gooto nder mooɗon mursataa yonki mum, laana kaa tan mursetee. ");
INSERT INTO fuh_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Hankin, Alla jeyɗo kam mo ndewanmi, lili maleykaajo gom he am. ");
INSERT INTO fuh_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Maleykaajo oon wi'i kam : « Pol, taa hulu, walaa ko waawi haɗude ma darowaade yeeso Kaysar. Alla reenete, aan he yaadiraaɓe maaɗa ɓeen fuu. » ");
INSERT INTO fuh_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Ndenne, pukkinee hakkillooji mooɗon, ngam miɗo hooli ko Alla haalani kam ɗum. Tabbat ko o wi'i ɗum waɗan. ");
INSERT INTO fuh_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Amma paamee faa ko tilay nufen dow duune gom. ");
INSERT INTO fuh_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Min ngaɗi jemmaaji sappo e nay, miɗen ndoya nder maayo Cakawo. Caka jemma sappo e nayaɓo oon, awƴooɓe laana kaan miili ko kam'en ɓadake leydi gom. ");
INSERT INTO fuh_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Ɓe paɗɗi ɓoggol ettirgol luggiɗirka ndiyam, ɓe tawi luggiɗirka kaan no waɗa gabaaje laso. Yeeso seɗɗa kaden, ɓe paɗɗi ngol, ɓe tawi luggiɗirka kaan no keddi gabaaje sappo he joy. ");
INSERT INTO fuh_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Ɓe kuli to ɓe caamoy dow kaaƴe. Nden ɓe njippini har gaɗa jamɗe nay darnooje laana kaan, iɓe keɗi Alla holla ɓe beete. ");
INSERT INTO fuh_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Wakkati gollooɓe nder laana kaan njippinoo laanel pamarel ngel dow ndiyam, faa ɓe ndilla kamɓe tan, sey ɓe peni ɓe mbi'i woɓɓe ko kam'en no njippinowan jamɗe yeesooje darnooje laana kaan. ");
INSERT INTO fuh_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Nden Pol wi'i mawɗo soogeeji oon, he soogeeji mum : —Nde nii ɓe ndillii ɓe acci on nder laana kaa, to baa gooto mooɗon daɗataa. ");
INSERT INTO fuh_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Wakkati soogeeji ɗiin nanunoo ko o wi'i ɗum, sey ɓe taƴi ɓoggi ɗi laanel ngel haɓɓiraa, ɓe acci ngel ingel dilla yahde kanngel tan. ");
INSERT INTO fuh_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Woɗɗa weetude, sey Pol eeli ɓe, ɓe fuu ɓe nyaama, o wi'i ɓe : —Hannden woni balɗe sappo he nay, on nyaamaay. Oɗon ndoomi ko watta. ");
INSERT INTO fuh_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Mi eeli on, ngaree, nyaamee ngam kison. Fakat baa leeɓol hoore gooto mooɗon solataa sako saama. ");
INSERT INTO fuh_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Wakkati o haaldannoo he maɓɓe ndeen, o hooƴi buuru, o yetti Alla yeeso maɓɓe, ɓe fuu. O helti, o fuɗɗi nyaamude. ");
INSERT INTO fuh_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Sey ɓe fuu hakkillooji maɓɓe pukki. Ɓe kooƴi, kamɓe duu buuruuje ɗeen iɓe nyaama. ");
INSERT INTO fuh_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Minen tawaaɓe nder laana kaan, miɗen ngaɗa himɓe keme ɗiɗo e lasooji tato e sappo he jeegom (276). ");
INSERT INTO fuh_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Wakkati ɓe nyaamunoo faa ɓe kaari ndeen, sey ɓe kooƴi saakuuji alkama gonɗi nder laana kaan, ɓe paɗɗi nder maayo heɓa ɗum huyfinan ka. ");
INSERT INTO fuh_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Wakkati weetunoo, awƴooɓe laana kaan anndaa toy kam'en tawa amma ɓe kolliri fonngo gom to maayo ngoon waɗi hano luuro nii. Iɓe ngiɗi hoɗoyde toon he laana kaan, nde no waɗoo. ");
INSERT INTO fuh_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Nden ɓe taƴi ɓoggi jamɗe darnooje laana ɗeen, ɓe njoofi nder ndiyam. Ɓe kaɓɓiti ɓoggi awƴirngel laana kaan. Ɓe adi awƴirngel ngel, ɓe ƴenciniri wudere waɗoore ka yaha, ɓe peerti nde. Nden ɓe ponndi fonngo maayo ngoon, henndu no tutooka, ika doya yahde. ");
INSERT INTO fuh_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Ɓe njottii to taasiri gom, sey laana kaan fiyi he tilde gom. Hoore makka irii nder tilde ndeen faa ka sonnyataa. Semmbe benkeƴƴe ɗeen tinni no cerka ka har gaɗa. ");
INSERT INTO fuh_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Soogeeji gonɗi nder laana kaan ciryii warude kasunkooɓe wonɓe nder makka heɓa to baa gooto maɓɓe doggu. ");
INSERT INTO fuh_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Amma ngam Yuliyus mawɗo soogeeji ɗiin no hiɗi danna Pol, sey o itti ɓe dow anniya maɓɓe. Nden o hokki laawol waawɓe yinaade ɓeen arta njinoo mburtowoo. ");
INSERT INTO fuh_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Hoddiiɓe ɓeen duu tiigoo dow koɓitte laana kaan naa goɗɗum ƴuwɗum he makka. Nii waɗi ko min fuu min keɓi yottaade fonngo ngoon jam he seho. ");
INSERT INTO fuh_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Wakkati min kisunoo sarri maayo ngoon, nden min nani ko innde duune nde min ngari ndeen woni Malta. ");
INSERT INTO fuh_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Himɓe tawaaɓe dow mayre njaɓɓorii min teddirka. Ndiyam no toɓa, jaangol duu no woodi. Nden ɓe kuɓɓani min hiite min ƴilfoo. ");
INSERT INTO fuh_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Pol hawri leɗɗe, faɗɗi nder magge. Nguleeki magge waɗi mboddi tawani nder majje gom wurtii, soppi Pol he junngo. ");
INSERT INTO fuh_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Wakkati himɓe duune ndeen ngi'unoo mboddi ndiin no ɓilii he junngo Pol, sey ɓe mbi'odiri hakkune maɓɓe : —Tabbat gorko oo no ittoowo yonki non. Baa nii ko o hisi sarri maayo ngoo, kiite caami dow makko, ɗe accataa mo o wuura. ");
INSERT INTO fuh_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Pol fiɗɗi junngo mum, sey mboddi ndiin saami nder hiite ngeen. Meentol ngool torraay mo baa seɗɗa. ");
INSERT INTO fuh_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Ɓe miili o ɓuutan naa o saaman wakkati mum da, o maaya. Ɓe keɗi faa ɓooyi, ɓe ngi'ii ɗum torraay mo baa seɗɗa. Nden ɓe mbayli anniyaaji maɓɓe iɓe mbi'a : Deweteeɗo gom non ! ");
INSERT INTO fuh_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Ɗon da hadde amin gese Pubiliyus, hooreejo duune ndeen, no kolliree. O wari, o jaɓɓii min no wooɗiri. O weerni min balɗe tati, omo hakkilii he amin. ");
INSERT INTO fuh_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Baabiiko no fukkii sellaa. O jontaaɗo, omo wondi wulowulo manngo, reedu makko no fiyaa, omo doggina ƴiiƴam. Pol ummii yehi to makko, du'ii, yowi juuɗe mum dow makko, o yamɗiti. ");
INSERT INTO fuh_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Wakkati baaba Pubiliyus yamɗitinnoo, nyawɓe duune ndeen fuu no ngara no nyawto to Pol. ");
INSERT INTO fuh_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Himɓe duune ndeen teddini min ir teddungal fuu. Wakkati min ciryinoo dillude, ɓe ngaddani min jooɓaari. Nder mayri ɓe ngatti huune fuu ko min kaajaa ngam jahaangal amin. ");
INSERT INTO fuh_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Miɗen ngonnoo Malta faa lebbi tati. Nyannde gom min naati laana ƴuwka Alekasandiire, ndabbunooka Malta, inndirteeka inɗe tooruuje funeeɓe worɓe Kastor e Polukisa, min ndilli. ");
INSERT INTO fuh_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Wakkati min ndillunoo Malta min ngari huɓeere Sirakus. Min ngaɗi balɗe tati nder mayre. ");
INSERT INTO fuh_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Min ndilli Sirakus, min takki daane maayo Cakawo, min ngari Regiyum. Jaangoore mum, henndu hoore huɗooru gom no wifa. Balɗe ɗiɗi tan min ngaɗi ko min njottowi Potiyoli. ");
INSERT INTO fuh_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Nder Potiyoli, min tawi banndiraaɓe goonɗinɓe gom eeluɓe min, min ngaɗana ɗum'en jeɗɗiire. Gaɗa jeɗɗiire amin nder Potiyoli, min ummii, min njehi *Rooma. ");
INSERT INTO fuh_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Wakkati banndiraaɓe amin gom wonɓe *Rooma nanunoo garki amin, ɓe ummii ɓe ngari luumo Abiya he nokkuure wi'eteene Jipporɗe Tati ngam jaɓɓitaade min. Wakkati Pol hi'unoo ɓe, o yetti Alla, o ɓeydi suusude. ");
INSERT INTO fuh_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Min ummodi he maɓɓe min ngardi *Rooma. Wakkati min njottinoo *Rooma, Pol hokkaa laawol jippoo feere mum, soogeeru gom dooma mo. ");
INSERT INTO fuh_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Balɗe tati gaɗa garki amin nder *Rooma, Pol noddi mawɓe *Yahudankooɓe ngara jipporde mum. Wakkati ɓe kawrunoo to Pol, Pol wi'i ɓe : —Banndiraaɓe ! Baa nii ko mi waɗanaay himɓe meeɗen gacce fuu, mi yaaɓaay duu laawol finaa-tawaaji maamiraaɓe meeɗen baa gootol, mi nanngaama *Ursaliima, mi wattaama nder juuɗe hooreeɓe leydi *Rooma. ");
INSERT INTO fuh_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Wakkati hooreeɓe leydi ndiin ƴami ƴamtinii kam, ɓe ngiɗiino yoofude kam, ngam ɓe tawraay kam fuu goɗɗum kaanuɗum waɗa mi waree. ");
INSERT INTO fuh_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Amma *Yahudankooɓe *Ursaliima calii. Ngam majjum waɗi tilay am, baa nii ko mi hiɗaa felude himɓe am, mi ƴama kiite am njaaree yeeso Kaysar. ");
INSERT INTO fuh_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Ɗum woni sabiili gaɗɗo mi noddi on ngam fillanaade on. Oɗon anndi gokka Isra'ilankooɓe, ngam gokka kaa waɗi kaɓɓiraami callali ɗii. ");
INSERT INTO fuh_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Sey mawɓe *Yahudankooɓe njaabii mo, mbi'i : —Minen, min keɓaay fuu ɗerol gom ƴuwngol Yahudiya garngol dow innde maa. Nder banndiraaɓe amin baa gooto waraay, waɗani min filla maaɗa naa haalana min ko boni gom dow maaɗa. ");
INSERT INTO fuh_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Amma ko min ngiɗi woni aan he hoore maaɗa kaalanaa min ko miiluɗaa. Ngam minen, miɗen anndi ko nokku fuu no woodi himɓe jancooɓe sewre diina maa. ");
INSERT INTO fuh_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Nden mawɓe *Yahudankooɓe kokki Pol nyalaane nde ɓe ngartoyta to makko. Wakkati nyalaane nde ɓe mbi'unoo ɓe ngartan ndeen yottii, *Yahudankooɓe heewɓe ngari to Pol weeri. Illa subaka kecco faa gaɗa kiraaɗe, Pol no waajoo ɓe dow filla Laamu Alla. Omo tuugo dow *Tawreeta Muusa he dewte annabiiɓe, ngam ɓe ngoonɗina Iisa. ");
INSERT INTO fuh_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Nder maɓɓe woɓɓe njaɓi ko o haalani ɗum'en, woɓɓe duu njaɓaay. ");
INSERT INTO fuh_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Ɓe pooɗodiri hakkune maɓɓe, faa ɓe puɗɗi sankitaade, sey Pol wi'i ɓe : —Goonga *Ruuhu Ceniiɗo haali, wakkati o wi'unoo maamiraaɓe mooɗon har hunnduko annabi *Esaaya : ");
INSERT INTO fuh_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Yehu to lenyol ngool, mbi'aa : On nanan faa wooɗa, amma on paamataa. On ndaaran faa wooɗa, amma on ngi'ataa. ");
INSERT INTO fuh_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Ngam himɓe lenyol ngool no njoori ɓerɗe : Ɓe cukkii noppi maɓɓe, ɓe maɓɓii gite maɓɓe. Ngam to gite maɓɓe ngi'u, to noppi maɓɓe nanu, to hakkillooji maɓɓe paamu, to ɓe tuubu sako mi danna ɓe. ");
INSERT INTO fuh_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Pol wi'i ɓe kaden : —Paamee ko Alla lildi kisinam mum to ɓe kanaa *Yahudankooɓe, ngam kamɓe kay ɓe kettinto !  ");
INSERT INTO fuh_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Wakkati Pol haalannoo haalaaji ɗii, *Yahudankooɓe ɓeen ndilli, tinni no njeddodira sanne hakkune mum'en. ");
INSERT INTO fuh_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Pol jooɗii duuɓi ɗiɗi nder suudu ndu o luwi. Omo jaɓɓoo warooɓe no ndaara mo fuu. ");
INSERT INTO fuh_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Nder cuusal manngal omo waajoo dow Laamu Alla, omo janngina *Habaru Iisa *Almasiihu Joomiraawo. Walaa fuu ko waawi haɗi mo.");
INSERT INTO fuh_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Miin Pol, maccuɗo Iisa *Almasiihu, mo Alla noddi ngam laatoo lilaaɗo makko. Miin mo Alla suɓii, waajoo *Habaru lobbo filla dow Iisa *Almasiihu winndi ɗerol ngool. ");
INSERT INTO fuh_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","*Habaru lobbo mo mbaajotoomi oo woni habaru mo illa fil'ajal Alla fodaninoo en nder dewte ceniiɗe har kunndule annabiiɓe mum. ");
INSERT INTO fuh_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Habaru oo walaana no haala dow Ɓiyiiko, Iisa *Almasiihu Joomiraawo meeɗen, mo har ɓii-aadamaaku wurtaakina nder lenyol Daawda. ");
INSERT INTO fuh_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Amma har *Ruuhu Ceniiɗo tabbintinaama ko o *Ɓii-Alla, wakkati mo nder baawɗe *Ruuhu Ceniiɗo o ummintina he maayde. ");
INSERT INTO fuh_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Alla barkinɗini kam waɗi kam lilaaɗo dow innde Iisa *Almasiihu heɓa ɓe kanaa *Yahudankooɓe fuu ngoonɗina mo tokka ko o wi'i ɗum'en. ");
INSERT INTO fuh_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Onon, ɓe Alla noddi warta tokkuɓe Iisa *Almasiihu, onon duu, oɗon limtee nder maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","On fuu wonɓe *Rooma, ɓe Alla horsini, noddi ɗum'en ngam ngartaa himɓe mum, miɗo sanna on. Alla *Baabiraawo meeɗen, he Iisa *Almasiihu Joomiraawo meeɗen hokka on jam e moƴƴere. ");
INSERT INTO fuh_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Duuniyaaru fuu nani filla goonɗinol mooɗon. Ngam majjum waɗi, miɗo yetta Alla daliila Iisa *Almasiihu ngam mooɗon. ");
INSERT INTO fuh_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Alla, mo ngollananmi he ɓerne am fuu, nder waaju *Habaru lobbo, habaru Ɓiyiiko, no anndi ko nder du'aa'u am fuu, miɗo miccitoo he mooɗon. ");
INSERT INTO fuh_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Miɗo eela Alla, nde hiɗi, jaɓi hoynana kam laawol no mi warirta to mooɗon. ");
INSERT INTO fuh_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Miɗo hiɗi hi'ude on sanne ngam mi walla on keɓon kokkal ngal *Ruuhu Ceniiɗo hokkata heɓa cemmbiɗon. ");
INSERT INTO fuh_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Kaden, miɗo hiɗi mi tawee hakkune mooɗon faa cemmbinɗinodiren nder goonɗinol ngol kawtuɗen ngool. ");
INSERT INTO fuh_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Banndiraaɓe, miɗo hiɗi paamon ko mi siryake kile keewɗe ngam warde to mooɗon amma faa warde hannden mi heɓaay laawol majjum. Miɗo hiɗi golle am ngaɗa barke hakkune mooɗon hano no ɗe ngaɗiri barke hakkune woɓɓe. ");
INSERT INTO fuh_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Waajibi non, teddorgal yahde to himɓe fuu no dow gi'al daane am. Teddorgal yahde to tawaaɓe nder huɓeere naa nder ladde, teddorgal yahde to jannguɓe he ɓe njanngaay, ɗum fuu no dow am. ");
INSERT INTO fuh_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Ndenne, daliila kujje ɗee fuu waɗi, miɗo hari warde waajaade on *Habaru lobbo oo, onon tawaaɓe *Rooma. ");
INSERT INTO fuh_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Waaju *Habaru lobbo hanaa semteene non to am, ngam *Habaru lobbo oo woni baawɗe Alla jottinooje goonɗinɗo fuu he kisinam. Arannde nii *Yahudankooɓe, nden ɓe kanaa *Yahudankooɓe. ");
INSERT INTO fuh_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Ngam *Habaru lobbo wanngini dartinaaku ƴuwngu to Alla keɓeteengu daliila goonɗinol tan. Ngam nii woni no ɗum winndiraa wi'aa : Jom dartinaaku wuuran daliila goonɗinol mum. ");
INSERT INTO fuh_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Illa dow, Alla wanngini tikkere mum ngam ɓiɓɓe aadama ngaɗi hakke, iɓe nder gaɗol oonyaare. Har oonyaare maɓɓe duu iɓe kaɗa goonga wanngude. ");
INSERT INTO fuh_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Nde goonga, ko neɗɗo waawi anndude dow Alla fuu no laaɓani ɓe. Alla he hoore mum holli ɓe ɗum. ");
INSERT INTO fuh_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Goonga non ko woni he makko fuu hitere waawaa hi'ude ɗum. Amma illa fuɗɗorde o holli ko kam no Alla. O holli baawɗe makko dow ko o tagi fuu. Ngam majjum waɗi nde nii ɗum taykaama, ɗum daaraama ɓe ngalaa ko ɓe mbi'a. ");
INSERT INTO fuh_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Baa nii ko iɓe anndi Alla, ɗum fuu waɗaay ɓe njetta mo, ɓe teddina mo no foti o teddiniree. Ɓe tokkitii taykaaki meere faa ɓe mbini, ko'e maɓɓe mbaati, ɓerɗe maɓɓe duu niɓɓi. ");
INSERT INTO fuh_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Iɓe mbi'a ko kam'en no jom'en hakkillo, jaa ɓe haaŋaaɓe. ");
INSERT INTO fuh_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Fadde maɓɓe rewude Alla jom teddungal, Duumiiɗo faa abada abadin, tooruuje gaɗaaɗe nder nanndi neɗɗo maayoowo, naa pooli, naa dabbaaji, naa bolle, ɓe tinni iɓe ndewa. ");
INSERT INTO fuh_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Ngam majjum waɗi Alla duu acci ɓe tokki muuyɗe ɓerɗe maɓɓe tunnuɗe faa ɓe pekiti ɓalli maɓɓe he tuuni jeenu. ");
INSERT INTO fuh_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Ɓe mbattiti goonga Alla he fewre. Ɓe teddini ko tagaa ɗum, ɓe ndewi ɗum. Ɓe mboppi Taguɗo huune fuu oon, potuɗo yetteede faa abada ! Teddungal laatanoo mo faa abada abadin. Aamiin ! ");
INSERT INTO fuh_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Ngam majjum Alla acci, ɓe tokka muuyɗe ɓerɗe maɓɓe, ɓe ngaɗa ko waɗude ko semtini. Rewɓe maɓɓe acci ko dagii, ko anndanoo, kam woni debbo hawra he gorko, rewɓe maɓɓe hakkune mum'en tefodirta. ");
INSERT INTO fuh_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Non duu worɓe maɓɓe acci ko dagii ko anndanoo, kam woni gorko hawra he debbo, worɓe maɓɓe hakkune mum'en tefodirta. Nii waɗi ko ɓe pooɗani ko'e maɓɓe kiite potuɗe dey-dey he golle maɓɓe nyidduɗe. ");
INSERT INTO fuh_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Ko nii ɓe calii wondude he anndal Alla, Alla duu accidi ɓe he hakkillooji maɓɓe benbaaɗi ɗi ngalaa fuu nafakka gom, ɓe ngaɗi ko haanaa waɗeede. ");
INSERT INTO fuh_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Iɓe keewi iri rafi dartinaaku fuu, iri haasidaaku fuu he ir caɗal fuu. Iɓe keewi borondi, suuno, ittodirol yonki, he habdo. Iɓe keewi ƴoyre he iri laru fuu, nyo'oore bonnoore innde he rafi herseene. ");
INSERT INTO fuh_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","Iɓe mbi'odira haalaaji bonɗi, ɓe wayɓe Alla, ɓe toonyotooɓe, ɓe ƴettooɓe ko'e, ɓe hiɗuɓe innde. Iɓe nyenyi nder gaɗol bone. Iɓe murta he saarooɓe maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Ɓe ngalaa basiira, haala maɓɓe yottataako, ɓe koolnaaki, ɓe ngalaa yurmeene fuu. ");
INSERT INTO fuh_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Baa nii ko iɓe anndi ko Alla wi'i waɗooɓe iri golleeji ɗi fuu maayde woni mbaka mum'en, ɓe accaay waɗude ko boni. Iɓe njardii duu he waɗooɓe ko boni. ");
INSERT INTO fuh_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Ko nii waɗi ɓii-aadama fuu no woodi anndal dow dartinaaku Alla, ndenne aan peloowo goɗɗo, baa nii a moy non, walaa fuu no coptirtoɗaa. Ndenne, nde a felii goɗɗo, a liɓi hoore maa ngam aan he hoore maaɗa aɗa waɗa kujje ɗee. ");
INSERT INTO fuh_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Eɗen anndi ko kiite ɗe Alla taƴi fuu no poti dey-dey he waɗooɓe golle bonɗe. ");
INSERT INTO fuh_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Aan peloowo waɗooɓe golle bonɗe, tawi duu aan he hoore maaɗa aɗa waɗa ir majje, he giiɗe maaɗa aɗa miila ko a hisan kiite Alla naa ? ");
INSERT INTO fuh_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Naa a yawi ɗuuɗal moƴƴere Alla, munyal makko, he ko o yaawaa bonude he maaɗa ? Ndenne a anndaa ko moƴƴere Alla no waɗa tuuba ? ");
INSERT INTO fuh_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Amma tiiɗal nyiraaku he ɓerne ɓaleeraaku maaɗa waɗi kawranɗaa hoore maa kiite gonɗe no ndoomi ma nyannde fuu tikkere Alla wanngi. Nyalaane ndee nder mum kiite makko dartiiɗe wanngintee. ");
INSERT INTO fuh_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Alla yoɓan neɗɗo fuu dow golle mum. ");
INSERT INTO fuh_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Tittinkiniiɓe ngolli ko wooɗi ngam tefude teddungal, darja e mbuurnam nduumiiɗam, ɓee ngoni ɓe Alla hokkata laawol wuurdude he mum faa abada abidin. ");
INSERT INTO fuh_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Amma hiɗuɓe ko'e mum'en tan calii goonga, peŋi he waɗude bononda, tikkere he mone ngoni mbaka maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Torra he ɓillaare ngoodani gaɗoowo ko boni fuu. *Yahudankooɓe artiree ginan, nden ko ɓe kanaa *Yahudankooɓe tokkinee. ");
INSERT INTO fuh_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Amma darja, teddungal e jam ngoni mbaka gaɗoowo ko wooɗi fuu. *Yahudankooɓe artiree ginan, nden ko ɓe kanaa *Yahudankooɓe tokkinee. ");
INSERT INTO fuh_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Ngam Alla walaa hedran-hedran. ");
INSERT INTO fuh_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Neɗɗo fuu waɗi hakke ngam anndaa ko winndaa nder *Tawreeta, joomum no hiitetee kiite maayde baa nii ko anndaano *Tawreeta. Neɗɗo fuu anndi ko *Tawreeta wi'i, dey waɗi hakke, no waɗantee kiite dey-dey dow ko *Tawreeta wi'i. ");
INSERT INTO fuh_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Hanaa nanuɓe ko *Tawreeta wi'i ngoni jom'en dartinaaku yeeso Alla, amma tokkuɓe ngolli ko nde wi'i, kam'en ngoni jom'en dartinaaku yeeso Alla. ");
INSERT INTO fuh_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Mo hanaa Yahudanke, baa nii anndaa ko *Tawreeta wi'i, nde nii waɗi ko *Tawreeta tilsini waɗee nder rafi anndal mum, too ɗum no holla ko joomum no anndi ko haani waɗeede, baa nii ko anndaano ko *Tawreeta wi'i. ");
INSERT INTO fuh_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Ko o waɗi ɗum no holla ko *Tawreeta wi'i fuu no winndaa nder ɓerne makko. Hanaa nder ɓerne makko tan, iɗum winndaa duu nder ɓerne neɗɗo fuu mo hanaa Yahudanke. Ɓerɗe maɓɓe no kolla ko ɗum goonga ngam wakkatiiji gom miilooji maɓɓe no pela ɓe, wakkatiiji gom duu iɗi lamna ɓe. ");
INSERT INTO fuh_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Ngam majjum waɗi hano no *Habaru lobbo mo ngonmi miɗo waajoo wi'iri ɗum, non ɗum laatoytoo nyannde Alla tokkirta har Iisa *Almasiihu hiito ko suuɗi fuu nder ɓerɗe himɓe. ");
INSERT INTO fuh_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Aan, bi'oowo aan he hoore maa, a Yahudanke. Aan mo wakkili hoore mum he *Tawreeta, aan piyoowo gabaare dow kawtal mum he Alla. ");
INSERT INTO fuh_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Aan annduɗo muuyɗe Alla, aan mo nder nawtoraade he ko *Tawreeta wi'i waawi suɓaade ko wooɗi. ");
INSERT INTO fuh_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Aan tabbintinɗo ko aɗa waawi ɗowi bumɗo, aan tabbintinɗo ko a jeyngol ngam yeynanande wonɓe nder nimre. ");
INSERT INTO fuh_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","Aan ekkintinoowo ɓe ngalaa anndal, jannginoowo sukaaɓe ngam aɗa jogii goonga he anndal kuuɓungal tawaangal nder *Tawreeta. ");
INSERT INTO fuh_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Aan ekkintinoowo woɓɓe, a ekkintintaa hoore maaɗa. Aɗa fooɗa noppi himɓe to ɓe mbujju, amma aan he hoore maaɗa aɗa wujja. ");
INSERT INTO fuh_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Aɗa fooɗa noppi himɓe ngam to ɓe jeenu, amma aan aɗa yeena. Aɗa harmini tooruuje, amma aɗa wujja nder cuuɗi majje. ");
INSERT INTO fuh_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Aɗa fiira *Tawreeta gabaare, amma a ɗowtantaako ko nde wi'i. Ndenne, a hokkaay Alla teddungal mum. ");
INSERT INTO fuh_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Ngam no winndaa wi'aa : Daliila mooɗon waɗi ko ɓe kanaa *Yahudankooɓe no mbonna innde Alla. ");
INSERT INTO fuh_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Tabbat juulnol no nafee, nde nii a ɗowtaniiɗo ko *Tawreeta wi'i. Amma nde nii a hanaa ɗowtaniiɗo ko *Tawreeta wi'i, baa nii ko a juulnaaɗo, aan he mo juulnaaka fuu no go'o. ");
INSERT INTO fuh_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Alal misaali mo juulnaaka gom no ɗowtanoo ko *Tawreeta wi'i, Alla daarata joomum hano no juulnaaɗo naa ? ");
INSERT INTO fuh_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Mo juulnaaka oo, ɗowtaniiɗo ko *Tawreeta wi'i oo, kam waɗante kiite. Aan juulnaaɗo, jogiiɗo *Tawreeta muɓɓo binndaaɗo amma no murta he ko *Tawreeta wi'i. ");
INSERT INTO fuh_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Yahudanke goonga e goonga hanaa mo dow ɓanndu mum tan hollata ko kam no Yahudanke, kaden juulnol goonga e goonga hanaa juulnol ngol waɗetee dow ɓanndu gorko. ");
INSERT INTO fuh_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Ndenne, Yahudanke goonga e goonga woni laatiiɗo Yahudanke nder ɓerne mum. Juulnol goonga e goonga woni juulnol ngol *Ruuhu Alla waɗata nder ɓerne neɗɗo. Juulnol ngool ƴuwaay nder tilsinooje binndaaɗe. Ir neɗɗo oo Alla manata ɗum, hanaa ɓii-aadama. ");
INSERT INTO fuh_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Ndenne, nde nii woni no waɗa, nafakka kaye Yahudanke woodi ? Ɗume juulnol nafiri ? ");
INSERT INTO fuh_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Nde en etii en ndaari nder laabi keewɗi, ko Yahudanke ɓurdi mo hanaa Yahudanke no ɗuuɗi. Misaali seɗɗa gom nii, *Yahudankooɓe Alla halfini haala mum. ");
INSERT INTO fuh_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Goonga non, woɓɓe nder maɓɓe kolaaki Alla, amma baa nii ko ɓe koolaaki mo, ɗum waawaa bonnude fuy nder ko Alla no kolniiɗo. ");
INSERT INTO fuh_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Ndenne, neɗɗo fuu faama ko Alla woni goonga, himɓe ngoni fenooɓe. Hano no ɗum winndiraa wi'aa : Aan Alla nde a haali, neɗɗo fuu no anndi ko a haali goonga. Nde a felaama duu, aan hepta goonga. ");
INSERT INTO fuh_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Nde nii rafi dartinaaku meeɗen no laatoo laawol tabbintinol dartinaaku Alla, ndenne ɗume woodi ko mbi'eten kaden ? Nde nii Alla jippinii tikkere mum dow meeɗen, en mbi'an ko o hanaa jom dartinaaku naa ? Ko mi wi'i ɗum no miiloo ɓii-aadama. ");
INSERT INTO fuh_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","En mbaawaa wi'ude ɗum he Alla, ngam nde nii Alla hanaa jom dartinaaku, noy o hiitorto duuniyaaru ? ");
INSERT INTO fuh_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Nde fewre am walli himɓe ngi'a goonga Alla yaasin laaɓɗo, nde nde waɗi ɓe teddina mo, ndenne ɗume waɗi hannden miɗo hiitee hano mi gaɗoowo hakke ? ");
INSERT INTO fuh_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Nde nii non, sey tinnoɗen nder waɗude ko wooɗaa ngam ɗum laatoo laawol wurtinde ko wooɗi. Goonga non woɓɓe no mbi'an ko en mbi'iri nii amma ɗum hanaa goonga, ɗum kuddi tan. Ir himɓe ɓee no ngaɗantee kiite dey-dey golle mum'en. ");
INSERT INTO fuh_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Enen *Yahudankooɓe, ɗume mbi'eten ? Eɗen ɓuri ɓe kanaa *Yahudankooɓe naa ? Too, en ɓuraa ɓe baa fuy ! En artiino en mbi'i ko Yahudanke he mo hanaa Yahudanke fuu no nder maccangaaku hakke. ");
INSERT INTO fuh_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Hano no ɗum winndiraa wi'aa : Jom dartinaaku walaa, baa gooto. ");
INSERT INTO fuh_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Walaa gooto, gooduɗo faamu, naa gooto tefoowo yeeso Alla. ");
INSERT INTO fuh_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Ɓe fuu ɓe mbinake Ɓe fuu ɓe mboni. Walaa baa gooto gaɗoowo ko wooɗi. Baa gooto walaa. ");
INSERT INTO fuh_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Kunndule maɓɓe no nanndi he annyeeje omtiiɗe. Iɓe nawtoro ɗemle belɗe ngam hiilude himɓe. Toni maɓɓe no keewi tooke hano firsoori. ");
INSERT INTO fuh_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Kunndule maɓɓe no keewi kuddi he haalaaji mettuɗi. ");
INSERT INTO fuh_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Koyɗe maɓɓe no karganoo rufude ƴiiƴam. ");
INSERT INTO fuh_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","To ɓe pa'i fuu, bononda e mettorgal ɓerne no tokki ɓe, ");
INSERT INTO fuh_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","ɓe anndaa laawol waɗude jam. ");
INSERT INTO fuh_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Kulol Alla walaa nder ɓerɗe maɓɓe baa seɗɗa. ");
INSERT INTO fuh_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Eɗen anndi huune fuu ko *Tawreeta wi'i, nde wi'aanaa ɗum na ngam wonɓe no ɗowtanoo ko nde wi'i. Neɗɗo fuu waawaa wi'ude ko kam waɗaay hakke. Ndenne, himɓe fuu no kaani paama ko kam'en ngaɗi hakke yeeso Alla. ");
INSERT INTO fuh_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Walaa tokkuɗo ko *Tawreeta wi'i daaroyteeɗo jom dartinaaku yeeso Alla, ngam no tokki *Tawreeta. *Tawreeta waɗataa neɗɗo jom dartinaaku amma nde hollataana himɓe ɗume woni hakke. ");
INSERT INTO fuh_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Alla wanngini hannden laawol keɓol dartinaaku mum. Dartinaaku nguu hanaa har *Tawreeta, ngu heɓirtee baa nii ko *Tawreeta he dewte annabiiɓe ceedanake ngu. ");
INSERT INTO fuh_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Dartinaaku ƴuwngu to Alla nguu no heɓee daliila goonɗinde Iisa *Almasiihu. Neɗɗo fuu goonɗini *Almasiihu, Alla wartiran ɗum jom dartinaaku. Alla walaa hedran-hedran. ");
INSERT INTO fuh_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Himɓe fuu ngaɗi hakke, ɓe fuu ɓe mbaawaa keɓi dartinaaku Alla. ");
INSERT INTO fuh_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Amma joonin Alla wartiri neɗɗo meeɗen fuu jom dartinaaku daliila moƴƴere nde o waɗani en forba. Hakke neɗɗo meeɗen fuu moytaama yeeso makko nder barke dimɗinol ngol *Almasiihu waɗani en. ");
INSERT INTO fuh_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Alla lili mo ngam o laatoo *sadaka heɓa neɗɗo fuu goonɗini mo hakke mum moytee daliila ƴiiƴam makko. Alla waɗi ɗum ngam hollude dartinaaku mum, ngam ndenno o munyaniino waɗooɓe hakke. Kiite fuu non o taƴanaay ɓe. ");
INSERT INTO fuh_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Alla waɗi nii nder wakkati oo ngam hollude ko he hoore mum no jom dartinaaku, kaden duu o waɗan neɗɗo fuu goonɗini Iisa jom dartinaaku. ");
INSERT INTO fuh_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Ndenne, walaa ko neɗɗo fiyira gabaare wi'a kam no goɗɗum. Ɗume waɗi ko ɗum walaa ? Ɗum walaa ngam hanaa golle meeɗen waɗata en jom'en dartinaaku. Goonɗinol Iisa kam wartirta en jom'en dartinaaku. ");
INSERT INTO fuh_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Ngam eɗen anndi ko neɗɗo no wartiree jom dartinaaku yeeso Alla ngam no goonɗinɗo amma hanaa ngam no tokkuɗo *Tawreeta. ");
INSERT INTO fuh_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Naa Alla, no Alla *Yahudankooɓe tan ? Naa o hanaa Alla ɓe kanaa *Yahudankooɓe ? Nde goonga, o Alla ɓe kanaa *Yahudankooɓe duu. ");
INSERT INTO fuh_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Alla, o gooto. Kanko duu waɗata juulnaaɓe jom'en dartinaaku ngam ɓe goonɗinɓe Iisa. Kanko duu waɗata ɓe njuulnaaka jom'en dartinaaku ngam ɓe goonɗinɓe Iisa. ");
INSERT INTO fuh_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Nde nii en ngoonɗini Iisa, ndenne en ngartiri *Tawreeta meere, naa noy ? Aa'a, en ngartiraay nde meere, en tabbintinan nde non. ");
INSERT INTO fuh_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Ɗume mbi'eten dow *Ibrahim maama meeɗen ? Ɗume o heɓiri hoore makko kanko tan ? ");
INSERT INTO fuh_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Nde nii o heɓiino nder golle makko, laawol laataade jom dartinaaku yeeso Alla, o heɓannoo goɗɗum ko o fiyirta gabaare yeeso woɓɓe, amma hanaa yeeso Alla. ");
INSERT INTO fuh_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","No winndaa wi'aa : *Ibrahim goonɗini Alla, ngam majjum waɗi, Alla adi mo jom dartinaaku. ");
INSERT INTO fuh_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Njobdi golloowo limtataake hano moƴƴere non, nde o hokkaa. Amma njobdi makko ndii, no tilsi non o hokkee ndi. ");
INSERT INTO fuh_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Neɗɗo fuu watti gokka goonɗini Alla, gartiroowo jom hakke jom dartinaaku yeeso mum, dey wattaay gokka mum dow gollal mum, too daliila goonɗinol neɗɗo oo, Alla adan mo jom dartinaaku. ");
INSERT INTO fuh_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Ɗum wonnoo ko Daawda hiɗunoo haalude wakkati o haalunoo dow neɗɗo mo Alla barkini noddi mo jom dartinaaku ko hanaa ngam golle mum lobbe. ");
INSERT INTO fuh_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","Daawda wi'i : Belɗo hoore woni mo gacce mum ittaa, mo hakke mum yaafaa ! ");
INSERT INTO fuh_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Belɗo hoore woni neɗɗo mo Joomiraawo limataa gacce mum kaden. ");
INSERT INTO fuh_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Too ! *Yahudankooɓe tan njeyii barke ɗee naa ? Ɓe kanaa *Yahudankooɓe ngalaa mbaka nder majje naa ? En mbi'ii goonɗinol *Ibrahim waɗi Alla wi'i o jom dartinaaku. ");
INSERT INTO fuh_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Nde Alla wi'i o jom dartinaaku ? Illa o juulnaaka naa gaɗa juulnol makko ? Illa o juulnaaka Alla wi'i ɗum hanaa gaɗa juulnol makko. ");
INSERT INTO fuh_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Amma wakkati o juulnaa ndeen, juulnol makko ngool laatake alaama mo seedantoo mo ko o jom dartinaaku har goonɗinol illa o juulnakaano. Ngam majjum waɗi *Ibrahim laatii baaba goonɗinɓe Alla fuu, adaaɓe jom'en dartinaaku, baa nii ko ɓe njuulnaaka. ");
INSERT INTO fuh_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Nii duu waɗi ko *Ibrahim laatii baaba juulnaaɓe, hanaa ngam ɓe juulnaaɓe tan amma ngam ɓe ngoonɗini Alla hano no *Ibrahim goonɗiniri illa o juulnaaka. ");
INSERT INTO fuh_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Alkawal ndonngu duuniyaaru ngu Alla waɗani *Ibrahim he jippotooɓe he mum hanaa ngam ɓe tokki ko *Tawreeta wi'i o waɗaa. O waɗaakana daliila dartinaaku keɓeteengu har goonɗinol. ");
INSERT INTO fuh_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Nde nii tokkol *Tawreeta waɗata neɗɗo donoowo duuniyaaru, ndenne goonɗinol neɗɗo warti meere, alkawal ngal Alla waɗi ngaal duu walaa ko nafirta. ");
INSERT INTO fuh_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","*Tawreeta, tikkere Alla tan waddata. Amma nde nii *Tawreeta walaano, gaɗol hakke duu walaano. ");
INSERT INTO fuh_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Ngam majjum waɗi sey nde neɗɗo goonɗini ko rona fodoore Alla ndee. Ndonngu fodoore ndee duu no forba. Ɗum duu ngam hokkude jippotooɓe he *Ibrahim fuu laawol heɓude ndonngu ngu. Hanaa tokkuɓe *Tawreeta tan, baa goonɗinɓe hano no *Ibrahim maama himɓe fuu goonɗiniri. ");
INSERT INTO fuh_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Hano no ɗum winndiraa wi'aa : Mi waɗi laatoɗaa baaba lenyi ɗuuɗɗi. Ndenne ɗum tabbintini amaana oon yeeso Alla mo *Ibrahim goonɗini, Alla ummintinoowo maayɓe, mo nawtortaako goɗɗum, taga goɗɗum. ");
INSERT INTO fuh_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","*Ibrahim deki tammude mum dow Alla baa nii ko wakkati mum o walaano tammude fuu. O goonɗini ngam majjum waɗi o laatii baaba lenyi ɗuɗɗi. Hano no ɗum winndiraa wi'aa : Jippotooɓe he maaɗa ɗuuɗan hano koode kammu. ");
INSERT INTO fuh_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Wakkati mum *Ibrahim walaana duuɓi hemre, baa nii ko o hi'i semmbe ɓanndu makko hanti, Saratu duuɓi ɓeyŋu mum yawti, ɗum fuu waɗaay o soƴƴoroo gaɗa nder goonɗinol makko. ");
INSERT INTO fuh_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","O sikkaay alkawal ngal Alla waɗani mo, o accaa goonɗinde Alla. Amma goonɗinol makko semmbinɗini mo, o teddini Alla. ");
INSERT INTO fuh_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","O tabbintini ko Alla no woodi baawɗe humnude alkawal mum. ");
INSERT INTO fuh_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Ɗum waɗi *Ibrahim daliila goonɗinol mum Alla adi mo jom dartinaaku. ");
INSERT INTO fuh_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Ko winndaa wi'aa o jom dartinaaku hanaa kanko tan wondaa. ");
INSERT INTO fuh_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Amma ɗum winndaama ngam meeɗen, enen ɓe Alla wartiri jom'en dartinaaku, enen goonɗinɓe ummintinɗo Iisa Joomiraawo meeɗen. ");
INSERT INTO fuh_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Daliila hakkeeji meeɗen waɗi Iisa waraa, nden o ummintinaa he maayde ngam adeɗen jom'en dartinaaku yeeso Alla. ");
INSERT INTO fuh_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Ko nii en keɓii wartireede jom'en dartinaaku yeeso Alla har goonɗinol meeɗen, potal naati hakkune meeɗen he Alla daliila Iisa *Almasiihu Joomiraawo meeɗen. ");
INSERT INTO fuh_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Har goonɗinol meeɗen, kanko Iisa oon, o udditani en dammbugal keɓol moƴƴere Alla mo ngonɗen nder mum joonin. Eɗen nana belɗum ngam eɗen ngatti gokka heɓude teddungal Alla. ");
INSERT INTO fuh_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Hanaa ɗum tan, eɗen nana belɗum torraaji ɗi njarten ngam eɗen anndi ko jarɗe torra no ekkintina en dow munyal. ");
INSERT INTO fuh_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","Nde neɗɗo no munya torra, munyal mum rimataana aadilaaku, aadilaaku duu rimataana tammude. ");
INSERT INTO fuh_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Tammude ndeen duu semtintaa en ngam Alla loowi hidde mum sanne nder ɓerɗe meeɗen har *Ruuhu Ceniiɗo mo o hokki en. ");
INSERT INTO fuh_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Nder wakkati mo tampuɗen, dey-dey wakkati mo Alla suɓii, *Almasiihu maayi ngam sabbu waɗooɓe hakke. ");
INSERT INTO fuh_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","No tiiɗi, goɗɗo jaɓa mursa yonki mum ngam sabbu goɗɗo, baa nii nde tawi neɗɗo oo no jom dartinaaku. Amma tawte no waɗoo goɗɗo nyoƴƴa ɓerne mum mursa yonki mum ngam makko. ");
INSERT INTO fuh_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Amma Alla holli en hidde mum ngam wakkati ngonnoɗen waɗooɓe hakke, *Almasiihu maayanii en. ");
INSERT INTO fuh_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Joonin ko ngartiraɗen jom'en dartinaaku daliila ƴiiƴam *Almasiihu, ndenne tabbat o hisinan en tikkere Alla. ");
INSERT INTO fuh_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Ndenno en wayɓe Alla amma hannden potal warti hakkune meeɗen he makko daliila maayde Ɓiyiiko. Joonin ko potal no hakkune meeɗen he Alla en tabbintini ko Alla hisinan en ngam Ɓiyiiko no wuuri. ");
INSERT INTO fuh_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Eɗen nana belɗum Alla hanaa ngam potal ngaal tan, amma eɗen nana belɗum ngam Iisa *Almasiihu Joomiraawo meeɗen waɗi joonin keɓuɗen potal ngaal. ");
INSERT INTO fuh_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Hakke daliila neɗɗo gooto naatiri duuniyaaru. Hakke ɗe neɗɗo oo waɗi, waddi maayde. Nii waɗi ko maayde no dow gi'al daane neɗɗo fuu ngam walaa mo waɗaay hakke. ");
INSERT INTO fuh_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Tabbat fadde *Tawreeta jippineede, hakke no nder duuniyaaru. Amma wakkati *Tawreeta walaano Alla nanngirtaa himɓe hakkeeji mum'en. ");
INSERT INTO fuh_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Illa jamaanu Aadamu warde jamaanu *Muusa maayde woodi jaalorgal dow himɓe fuu. Inde dow gi'al daane neɗɗo fuu baa mo waɗaay hakke ir hakke ɗe Aadamu waɗi wakkati o murtunoo he tilsinoore Alla. Aadamu woni alaama tinndinoowo garoowo oon. ");
INSERT INTO fuh_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Moƴƴere nde Alla hokkata no seedi he hakke mo Aadamu waɗi. Himɓe ɗuɓɓe maayi daliila hakke ɗe neɗɗo gooto waɗi. Amma moƴƴere nde Alla hokkata himɓe heewɓe daliila Iisa *Almasiihu tan no mawni faa hanaa seɗɗa. ");
INSERT INTO fuh_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Amma, kokkal ngal Alla hokkata no seedi he hakke neɗɗo gooto oo, ngam kiite ɗe Alla taƴani neɗɗo gooto oo waɗi en jom'en hakke. Amma moƴƴere nde Alla waɗi forba daliila hakkeeji ɗi nde'ataa woni wartirde neɗɗo fuu jom dartinaaku. ");
INSERT INTO fuh_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Nde nii goonga fuu daliila hakke neɗɗo gooto maayde ŋabbi gi'al daane himɓe fuu. Ndenne, sikka fuu walaa ko heɓuɓe moƴƴere mawne ngam wartireede jom'en dartinaaku, laamodoto he Alla, mbuurda he makko daliila Iisa *Almasiihu gooto oo. ");
INSERT INTO fuh_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Ndenne, no hakke neɗɗo gooto dekkiri maayde dow gi'al daane neɗɗo fuu, hano non duu gollal jom dartinaaku gooto waɗata himɓe cfuu jom'en dartinaaku. Har gollal ngaal, ɓe fuu ɓe keɓi mbuurnam. ");
INSERT INTO fuh_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Hano no himɓe heewɓe laatori waɗooɓe hakke daliila gaɗol hakke neɗɗo gooto, hano non duu himɓe heewɓe ngartan jom'en dartinaaku daliila ɗowtanaaki neɗɗo gooto. ");
INSERT INTO fuh_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Daliila gaɗuɗo *Tawreeta waddaa woni himɓe fuu mbaawa hi'ude no kam'en ngaɗiri hakke sanne. Wakkati fuu mo gaɗol hakke semmbe mum ɓeydi, sey moƴƴere Alla ɓura ɗum ɗuuɗude. ");
INSERT INTO fuh_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Ngam majjum waɗi hano no ndenno hakke laamorii har maayde, non hannden moƴƴere Alla duu woodiri baawɗe wartirde himɓe jom'en dartinaaku. Nii watta ko keɓen mbuurnam nduumiiɗam faa abada daliila Iisa *Almasiihu Joomiraawo meeɗen. ");
INSERT INTO fuh_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Ndenne, ɗume mbi'eten ɗo joonin ? En tinnotoo nder waɗude hakke heɓa moƴƴere Alla ɓeydoo naa noy ? ");
INSERT INTO fuh_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Toy nee, hitere fuu seedataako ɗum. To hakke en maayɓe, en ceedi he mayre, haanaa tinnoɗen eɗen ngaɗa hakke. ");
INSERT INTO fuh_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Ndenne, on anndaa ko *batisma meeɗen peŋuɗo en he Iisa *Almasiihu he hoore mum, feŋi en he maayde makko duu ? ");
INSERT INTO fuh_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Ndenne har *batisma meeɗen, hano nii en ufidaaɓe he makko heɓa hano no o ummintiniraa he maayde nder baawɗe Alla, enen duu naaten nder mbuurnam kesam. ");
INSERT INTO fuh_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Ngam enen he makko, en fuu en kawti maayde worre, en tabbintinii ko en kawtidan duu he makko ummitaaki gooti. ");
INSERT INTO fuh_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Eɗen anndi duu ko jikku meeɗen kiinngu tontidaa he makko dow *bardugal. Ndenne, hakke gonnooɗe he meeɗen ɗeen moytaama. Joonin en coptake maccangaaku hakke, ");
INSERT INTO fuh_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","ngam maayɗo fuu rimɗinaama he maccangaaku hakke. ");
INSERT INTO fuh_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Ko nii waɗi, enen en maaydi he makko, tabbat non en mbuurdan he makko. ");
INSERT INTO fuh_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Ngam eɗen anndi ko waɗi *Almasiihu ummitii he maayde, o maayataa kaden. Maayde walaa baawɗe gom fuu dow makko kaden. ");
INSERT INTO fuh_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","*Almasiihu maayi, maayde makko gaba go'o hakkiti hakke he makko. Joonin omo wuuri, omo wondi he Alla. ");
INSERT INTO fuh_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Hano non, onon duu, adee ko'e mooɗon hano on maayɓe, ɓe hakke walaa baawɗe gom fuu dow mum'en, mbuuron no Alla hiɗiri nder kawtal mooɗon he Iisa *Almasiihu. ");
INSERT INTO fuh_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Ndenne, to accee hakke heɓa baawɗe fuu dow ɓalli mooɗon maayooji tokkon muuyɗe majji. ");
INSERT INTO fuh_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","To adee terɗe ɓalli mooɗon kokkon hakke ɗe laatoo ko waawi nawtoreede ngam waɗude ko boni. Amma kokkee ko'e mooɗon Alla dey-dey no haaniri hano on ummintinaaɓe he maayde, ngartiraa he mbuurnam. Nawtoree terɗe ɓalli mooɗon ngam waɗude ko woodi dartinaaku. ");
INSERT INTO fuh_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Hakke heɓataa jaalorgal fuu dow mooɗon kaden ngam hanaa nder laamu *Tawreeta ngonɗon amma nder laamu moƴƴere Alla ngonɗon. ");
INSERT INTO fuh_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Ndenne noy non ? En ngaɗan hakke ngam eɗen nder moƴƴere Alla, en ngalaa nder laamu *Tawreeta naa ? Hitere fuu seedataako ɗum ! ");
INSERT INTO fuh_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","On anndaa ko nde on kokki ko'e mooɗon goɗɗo ngam ɗowtanoɗon joomum, on laatake maccuɗo joomum. Ndenne, nde nii on maccuɓe hakke, hakke yaarataana on na to maayde. Nde nii on maccuɓe Alla, Alla waɗa on jom'en dartinaaku ngam oɗon ɗowtanoo ɗum. ");
INSERT INTO fuh_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Yettoore woodani Alla. Ndenno on maccuɓe hakke, amma hannden on ɗowtanake ekkintinooje gaɗanaaɗe himɓe fuu he ɓerne worre. ");
INSERT INTO fuh_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","On ndimɗinaama he hakke, on laatake maccuɓe dartinaaku. ");
INSERT INTO fuh_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Miɗo haalda he mooɗon ɗo no paamirton ngam on cemmbiɗaa. Ndenno on ngartiriino ko'e mooɗon maccuɓe terɗe ɓanndu ngaɗuɗon ko nyiddinii, walaa ko fonnditi nder mbuurnam mooɗon. Ko ɗum rimani on woni murtol he Alla. Joonin ko ngaɗoton woni, ngatton terɗe mooɗon fuu nder laawol dartinaaku hano on maccuɓe maggu, ko ɗum rimanoyta on woni senaare. ");
INSERT INTO fuh_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Wakkati ngonnoɗon nder maccangaaku hakke, on paalaaka he gaɗol golle dartinaaku. ");
INSERT INTO fuh_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Ɓeydaari ndiye keɓuɗon nder golle mooɗon ? Hannden semteene tan haɓɓi ko'e mooɗon ngam maayde woni ko ɗe ndimani on. ");
INSERT INTO fuh_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Amma joonin, ko on ndimɗinaama he maccangaaku hakke, on laatake maccuɓe Alla. Ɓeydaari ndi keɓuɗon woni senaare, nde timmirde mum woni mbuurnam nduumiiɗam. ");
INSERT INTO fuh_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Ngam njobdi hakke woni maayde, amma moƴƴere nde Alla hokkata forba ndeen woni mbuurnam nduumiiɗam nder kawtal he Iisa *Almasiihu Joomiraawo meeɗen. ");
INSERT INTO fuh_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Banndiraaɓe, on fuu on annduɓe ko wi'aa nder *Tawreeta. Ndenne, oɗon mbaawi faamude ko ngiɗumi haalude. Wakkati neɗɗo wuuri tan, *Tawreeta woodi baawɗe dawrande ɗum. ");
INSERT INTO fuh_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Alal misaali debbo kaɓɓanaaɗo, nde nii gorum no wuuri, *Tawreeta haɓɓodirii ɓe. Amma nyannde fuu goriiko maayi, ɓoggi dewngal kaɓɓuɗi mo he goriiko taƴi. ");
INSERT INTO fuh_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Amma nde goriiko maayaay faa gorko gom haɓɓani mo, no wi'etee o jeenoowo non. Amma nde goriiko maayi, ɓoggi dewngal makko ɗi taƴi. Nde gorko gom haɓɓani mo, o wi'ataake jeenoowo. ");
INSERT INTO fuh_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Banndiraaɓe misaali oo, no misaali yahde he mooɗon. Onon duu, daliila maayde Iisa *Almasiihu, on laatake maayɓe to *Tawreeta. Ndenne, walaa fuu ko wondi on he *Tawreeta, on kawtaana he neɗɗo maaynooɗo ummintina ngam ngaɗen ko woodi barke yeeso Alla. ");
INSERT INTO fuh_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Wakkati tokkunoɗen muuyɗe ɓalli meeɗen, *Tawreeta semmbinɗini muuyɗe ɗeen ngam ngollen ko rimanta en maayde. ");
INSERT INTO fuh_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Amma daliila en maaydi he *Almasiihu, en ndimɗinaama he *Tawreeta gaɗuɗo en maccuɓe. Joonin en njoofi laawol meeɗen kiinngol, laawol *Tawreeta, eɗen ngollana Alla dow laawol kesol gom, laawol *Ruuhu makko. ");
INSERT INTO fuh_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Too, ɗume mbi'eten ɗo ? *Tawreeta he hoore mum no hakke naa ? Nowru fuu nanataa ɗum. Nde hanaa daliila *Tawreeta, mi waawaa anndi ɗume woni hakke. Nde *Tawreeta wi'aay to suuna ko goɗɗo, nden mi anndataano ko woni suuno. ");
INSERT INTO fuh_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Amma hakke heɓi laawol nder tilsinooje *Tawreeta uppi kam nder ir suuno fuu. Ngam nde *Tawreeta walaano, semmbe hakke waati. ");
INSERT INTO fuh_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Miin he hoore am, wakkati mi anndaano *Tawreeta, miɗo wuurunoo, amma wakkati anndunoomi ko haɗaa, hakke waɗi yonki, miin duu maayumi. ");
INSERT INTO fuh_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Tilsinooje *Tawreeta kaanuɗe hollude kam laawol ngol tokkanmi ko mi heɓa mbuurnam nduumiiɗam, tilsinooje *Tawreeta ɗe pooɗani-kam maayde. ");
INSERT INTO fuh_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Hakke heɓi laawol, nawtori tilsinooje *Tawreeta, ƴoyni kam, wari kam. ");
INSERT INTO fuh_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Tabbat *Tawreeta he hoore mum no senii, tilsinooje mayre duu no cenii. Iɗe moƴƴi, iɗe ngoodi dartinaaku. ");
INSERT INTO fuh_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Ndenne, ko wooɗi ɗum kanƴum waddani kam maayde naa ? Aa'a ! Hakke waddani kam maayde ndeen. Har tilsinooje *Tawreeta lobbe ɗee, hakke rimani kam maayde ngam ɗum hi'a ko hakke no wannga nder baawɗe mawɗe. ");
INSERT INTO fuh_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Eɗen anndi nii ko *Tawreeta ƴuwaana to *Ruuhu Alla, amma miin kay, mi nanndaana he accidaaɗo he hoore mum, mi maccuɗo hakke. ");
INSERT INTO fuh_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Mi anndanaa ko ngaɗanmi ngam hanaa ko ngiɗumi waɗude kam mi woni miɗo waɗa. Kaden ko mbanyumi kam mi woni miɗo waɗa. ");
INSERT INTO fuh_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Nde nii miɗo waɗa ko mi hiɗaa waɗude, mi holli ko mi jaɓi ko *Tawreeta no wooɗi. ");
INSERT INTO fuh_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Ndenne, hanaa min woni no waɗa ɗum, amma hakke gonɗe nder am ɗeen ngoni no waɗa ɗum. ");
INSERT INTO fuh_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Miɗo anndi duu ko wooɗi fuu walaa nder jikku am, ngam anniya waɗude ko wooɗi no nder ɓerne am amma mi waawaa waɗude ɗum. ");
INSERT INTO fuh_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Mi waɗataa ko wooɗi fuu ko ngiɗumi waɗude, amma ko boni ko mi hiɗaa waɗude kam woni ko ngaɗanmi. ");
INSERT INTO fuh_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Nde nii miɗo waɗa ko mi hiɗaa waɗude, ndenne iɗum holla ko hanaa miin woni no waɗa ɗum, amma hakke gonɗe nder am ngoni no waɗa ɗum. ");
INSERT INTO fuh_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Wakkati taykiimi fuu, miɗo hiɗi waɗude ko wooɗi, amma hakke no wondi he am no haɗa kam waɗude ɗum. ");
INSERT INTO fuh_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Nder ɓerne am miɗo nana belɗum tilsinooje *Tawreeta. ");
INSERT INTO fuh_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Amma nder terɗe ɓanndu am fuu mi hi'i tilsinoore gom no habda he tilsinoore nde hakkillo am holli kam no wooɗi. Tilsinoore ndee no waɗa kam maccuɗo hakke gonɗe nder ɓanndu am. ");
INSERT INTO fuh_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Kaari, miɗo yurminii ! Moy hisinta kam sarri ɓanndu yaarooru he maayde nde hanaa Alla ? ");
INSERT INTO fuh_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Jettooje ngoodani Alla daliila Iisa *Almasiihu Joomiraawo meeɗen ! Ndenne miin, nder hakkillo am mi maccuɗo *Tawreeta, amma ngam jikku no hakke, mi maccuɗo hakke. ");
INSERT INTO fuh_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Joonin kiite fuu ngalaa dow daane wonduɓe he Iisa *Almasiihu. ");
INSERT INTO fuh_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Nde en ngondi he *Almasiihu tilsinoore *Ruuhu Alla hokkata en mbuurnam. Inde rimɗina en he laamu hakke, inde rimɗina en duu he maayde. ");
INSERT INTO fuh_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","*Tawreeta waawaayno rimɗinde en ngam nder ɓii-aadamaaku meeɗen en ngalaa semmbe ɗowtanaade ko wi'aa nder mayre amma Alla rimɗini en. O lili Ɓiyiiko nder duuniyaaru ngam rimɗina en. O wari nder ɓanndu nanndunu he ɓanndu waɗooɓe hakke ngam o laatoo *sadaka ngam hakke. O sankita semmbe hakke gonɗo nder ɓalli meeɗen. ");
INSERT INTO fuh_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Alla waɗi ɗum ngam enen tokkuɓe ko *Ruuhu Alla wi'i hanaa tokkuɓe muuyɗe ɓalli mum'en, mbaawen waɗude golle dartinaaku ɗe *Tawreeta wi'i. ");
INSERT INTO fuh_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Tokkuɗo muuyɗe ɓanndu, muuyɗe ɓanndu ndawranta hakkillo mum. Amma tokkuɗo *Ruuhu, Ruuhu dawranta hakkillo mum. ");
INSERT INTO fuh_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Neɗɗo fuu tokki giɗaale ɓerne mum, maayde woni ko mum. Amma neɗɗo fuu tokki ko *Ruuhu Alla wi'i heɓan mbuurnam, heɓan jam. ");
INSERT INTO fuh_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Ngam dekude ɓerne mum dow giɗaale ɓanndu no wanyude Alla. Ɗe ɗowtanaaki *Tawreeta, ɗe mbaawaa duu ɗowtanaade nde. ");
INSERT INTO fuh_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Tokkuɗo muuyɗe ɓanndu waawaa welude Alla. ");
INSERT INTO fuh_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Amma onon, on tokkaay muuyɗe ɓanndu. On tokkaana muuyɗe *Ruuhu Alla ngam *Ruuhu Alla oo no tawa nder mooɗon. Nde neɗɗo walaa *Ruuhu *Almasiihu, *Almasiihu njeyaa ɗum. ");
INSERT INTO fuh_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Nde nii *Almasiihu no nder ɓerɗe mooɗon, baa nii ko ɓanndu mooɗon no maayooru daliila hakke, *Ruuhu makko no hokkan on mbuurnam ngam on jom'en dartinaaku yeeso Alla. ");
INSERT INTO fuh_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Nde *Ruuhu mo ummintini Iisa *Almasiihu he maayde no nder ɓerɗe mooɗon, ummintinɗo Iisa oo hokkan ɓalli mooɗon maayooji ɗii mbuurnam. O hokkiran ɗam *Ruuhu makko gonɗo nder ɓerɗe mooɗon. ");
INSERT INTO fuh_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Ngam majjum waɗi banndiraaɓe, no woodi nyamaane gom wonnde dow daaɗe meeɗen, amma hanaa muuyɗe ɓalli meeɗen tokki en nyamaane ndee. Ndenne, haanaa tokken muuyɗe ɓalli meeɗen. ");
INSERT INTO fuh_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Ngam nde nii oɗon tokkitii muuyɗe ɓalli mooɗon, on maayan. Amma nde nii on nawtorake *Ruuhu Alla barɗo muuyɗe ɓalli mooɗon, on keɓan mbuurnam nduumiiɗam. ");
INSERT INTO fuh_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Mo *Ruuhu Alla ɗowata fuu no *ɓii-Alla. ");
INSERT INTO fuh_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Alla hokkaay on *Ruuhu gaɗoowo on maccuɓe, kulkulal heewa on. Amma o hokkaana on naa *Ruuhu gaɗoowo on ɓiɓɓe makko. *Ruuhu mo daliila mum noddirten mo Abba. ");
INSERT INTO fuh_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","*Ruuhu Alla he hoore mum no wi'a en nder ɓerɗe meeɗen ko en ɓiɓɓe Alla. ");
INSERT INTO fuh_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Nde nii en ɓiɓɓe Alla, eɗen ngoodi mbaka nder ndonu ngu o fodani himɓe makko. En ndonidan he *Almasiihu kujje lobbe ɗe o heɓi fuu. Tabbat, nde nii en kawtidi he *Almasiihu torra, en kawtidan duu he makko teddungal. ");
INSERT INTO fuh_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Mi tabbintini ko walaa no neɗɗo waawi fonnude torra meeɗen hannden he teddungal ngal Alla wannginanta en yahde yeeso. ");
INSERT INTO fuh_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Nde goonga, ko tagaa fuu no haaɓa hi'aay nyalaane nde Alla wannginta ɓiɓɓe mum. ");
INSERT INTO fuh_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Ko tagaa fuu saami nder juuɗe laamu ngu walaa fuu darja gom. Hanaa ko tagaa ɗum suɓii naatude nder juuɗe ɗee amma Alla he hoore mum watti ɗum nder majje. Amma baa ko nii he banndum waɗi, laawol tammude no ɗon ngol ittaaka. ");
INSERT INTO fuh_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","Ko tagaa fuu no rimɗintee he maccangaaku semmbe bonnooje, ɗum heɓa mbaka nder teddungal ɓiɓɓe Alla. ");
INSERT INTO fuh_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Eɗen anndi duu ko faa warde hannden, ko tagaa fuu no otta dow e ley hano debbo mo ŋatawere nanngi. ");
INSERT INTO fuh_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Hanaa ko tagaa tan woni no otta. Enen he ko'e meeɗen eɗen otta, enen keɓuɓe *Ruuhu Alla, *Ruuhu laatiiɗo huune arannde nder kujje ɗe Alla hokkata en. Eɗen otta nder ɓerɗe meeɗen, en kaaɓi Alla waɗaay en ɓiɓɓe muuɗum, o rimɗina ɓalli meeɗen duu. ");
INSERT INTO fuh_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","En kisinaama ngam eɗen ngoodi tammude tan. Amma nde nii en ngi'ii ko ngattuɗen tammude meeɗen dow mum, ndenne ko min tammi ɗum hanaa tammude meeɗen kaden. Moy wattata tammude mum he ko arti heɓi ? ");
INSERT INTO fuh_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Amma nde nii en ngatti tammude dow ko en keɓaay, too, en keɗoto ɗum, munyen. ");
INSERT INTO fuh_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Munyal wallan en non, *Ruuhu kam duu waran walla en nder jaccere meeɗen. Ngam nde goonga, en anndaa ko kaanuɗen du'aade. Amma *Ruuhu Alla he hoore mum eelanta en Alla wakkati fuu mo keppuɗen ko mbi'en. O uumanan en nder uumaali ɓurɗi haalaaji luggiɗidde. ");
INSERT INTO fuh_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Alla gi'oowo ko tawa nder ɓerne neɗɗo duu no anndi anniya *Ruuhu mum, ngam *Ruuhu Alla no eelana himɓe makko dey-dey he muuyɗe makko. ");
INSERT INTO fuh_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Eɗen anndi duu ko Alla waɗata fuu omo waɗa ɗum ngam ɗum laatanoo hiɗuɓe mo moƴƴere. Woodanɓe mo hidde ɓee, o noddi ɓe, no o hiɗiri. ");
INSERT INTO fuh_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Ɓe Alla artunoo suɓii ɓeen, o suɓake ɓe fadde duuniyaaru tageede, kamɓe duu o wartiri feere ngam ɓe ngarta hano Ɓiyiiko heɓa Ɓiyiiko duu laatoo afo hakkune rimdaaɓe mum heewɓe. ");
INSERT INTO fuh_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Ɓe o artunoo o suɓii ɓeen kamɓe ngoni ɓe o noddi. Ɓe o noddi ɓeen ngoni ɓe o wartiri jom'en dartinaaku yeeso makko. Heɓuɓe wartireede jom'en dartinaaku yeeso makko ɓeen, kam'en o hokki teddungal. ");
INSERT INTO fuh_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Nde Alla no wondi he meeɗen, moy waawi heɓude jaalorgal dow meeɗen ? Ndenne ɗume mbi'eten dow fii oo ? ");
INSERT INTO fuh_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Alla mo haɗaay Ɓiyum mursa yonki mum ngam meeɗen no waawa saloo moƴƴande en ko eeluɗen mo fuu naa ? ");
INSERT INTO fuh_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Moy waawi felude ɓe Alla suɓi ? Walaa, Alla he hoore mum wartiri ɓe jom'en dartinaaku ! ");
INSERT INTO fuh_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Moy waawi hiitii ɓe ? Walaa ! Iisa *Almasiihu maayi, kaden duu o ummitake. Omo jooɗii nyaamo Alla, omo eelana en Alla. ");
INSERT INTO fuh_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Ɗume waawi senndude en he hidde *Almasiihu ? Saɗornam naa ɓillaare naa torra naa rafo naa rafi goɗɗum naa masiiba naa takubaahi ? ");
INSERT INTO fuh_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","No winndaa wi'aa : Ngam maaɗa miɗen ɓadii maayde. Nyannde fuu, miɗen ndaaree, hano baali kirseteeɗi. ");
INSERT INTO fuh_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Amma nder fii fuu ko hewti en, enen ngoni heɓuɓe jaalorgal daliila giɗɗo en. ");
INSERT INTO fuh_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Ngam mi tabbintini ko hanaa maayde, hanaa mbuurnam, hanaa maleykaaɓe, hanaa ko laami dow, hanaa hannden, hanaa jaaŋo, hanaa semmbe, ");
INSERT INTO fuh_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","hanaa ko tawa faa dow, hanaa duu ko tawa faa ley, huune fuu ko tagaa waawaa senndude en he hidde nde Alla waɗani en daliila kawtal meeɗen he Iisa *Almasiihu Joomiraawo meeɗen. ");
INSERT INTO fuh_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Ko ngiɗumi wi'ude ɗum tabbat ɗum goonga ngam miɗo wondi he *Almasiihu. Nder ɓerne am duu, mi tabbintini ko *Ruuhu Ceniiɗo no seedanoo kam ko kaalan mi ɗum tabbat no goonga. ");
INSERT INTO fuh_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","Wakkati fuu mettorgal he naawɗum ɓerne no he am faa noy walaa. ");
INSERT INTO fuh_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Nde nii laawol no woodi, mi naalee, mi senndee he *Almasiihu ngam banndiraaɓe am keɓa kisinam. ");
INSERT INTO fuh_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Kamɓe ngoni lenyol Isra'ilankooɓe ɓe Alla wartiri ɓiɓɓe mum. Alla wannginani ɓe teddungal mum, o haɓɓidi amaana he maɓɓe, o hokki ɓe *Tawreeta, o holli ɓe no ɓe ndewirta mo, o waɗani ɓe alkawaliiji. ");
INSERT INTO fuh_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","O itti ɓe he maamiraaɓe *Yahudankooɓe mawɓe anndaaɓe. *Almasiihu har ɓii-aadamaaku mum ƴuwi he lenyol ngool. Kanko woni Alla laamiiɗo dow huune fuu. Jettooje ngoodani mo faa abada. Aamiin ! ");
INSERT INTO fuh_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Hanaa ngam wi'ude ko Alla humnaay alkawal mum, ngam hanaa jippotooɓe he *Isra'el fuu ngoni ɓiɓɓe *Isra'el. ");
INSERT INTO fuh_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Kaden duu hanaa jippotooɓe he *Ibrahim fuu ngoni ɓiɓɓe ɓe Alla fodanii *Ibrahim. Ngam Alla wi'i *Ibrahim : Har Isiyaaku keɓirtaa jippotooɓe he maaɗa ɓe podanimaami. ");
INSERT INTO fuh_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Ndenne, hanaa ɓiɓɓe wurtiiɓe nder duhol *Ibrahim fuu ngoni ɓiɓɓe Alla. Amma rimaaɓe daliila alkawal mo Alla waɗi, ɓeen ngoni jippotooɓe he makko. ");
INSERT INTO fuh_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Ngam Alla waɗanii mo alkawal wi'i : Mi wartan wuro maaɗa mawuuri nder wakkati oo, mi tawan deeka Saratu heɓi ɓiɗɗo gorko. ");
INSERT INTO fuh_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Hanaa misaali oo tan woodi, funeeɓe Rebeeka, Yakuuba e Isuwa. Isiyaaku maamii'en rimi ɓe. ");
INSERT INTO fuh_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","12","Illa ɓe ndimaaka Alla wi'i Rebeeka : Minyiiyo oon maran mawnum. Ɗum tabbiti duu fadde maɓɓe waɗude ko wooɗi naa ko boni. Alla wi'i haala kaa ngam hollude cuɓeteeɗo oon no suɓetee non hanaa ngam golle ɗe waɗataa, amma joomum no suɓetee non ngam onɗon Alla noddoowo neɗɗo fuu hiɗi. ");
INSERT INTO fuh_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Hano no ɗum winndiraa wi'aa : Yakuuba korsinmi, amma Isuwa mbanyumi. ");
INSERT INTO fuh_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Ndenne, ɗume mbi'eten ? En mbi'an Alla waɗaay dey-dey naa ? Abada ! ");
INSERT INTO fuh_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Ngam o wi'i *Muusa : Mi moƴƴanan mo ngiɗumi moƴƴande, mi yurmoto mo ngiɗumi yurmaade. ");
INSERT INTO fuh_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Ndenne, Alla suɓataako neɗɗo ngam joomum no hiɗi o suɓoo ɗum naa ngam joomum no tittinkini. Amma o suɓoto joomum ngam omo yurmoo ɗum. ");
INSERT INTO fuh_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Ngam no winndaa wi'aa Alla wi'i Firawna : Mi waɗi ma laamiiɗo ngam daliila maaɗa, mi holla baawɗe am, innde am gooynee nokku fuu nder duuniyaaru. ");
INSERT INTO fuh_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Ndenne, Alla yurmoto mo hiɗi, yorna ɓerne mo hiɗi. ");
INSERT INTO fuh_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Hakkune mooɗon goɗɗo ƴaman kam wi'a : « Nde nii Alla no yurmoo mo hiɗi, yorna ɓerne mo hiɗi, ɗume Alla felirta himɓe ? Moy waawi salaade muuyɗe makko ? » ");
INSERT INTO fuh_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Aan ɓii-aadama, aan a moy faa njeddaa Alla ? Ko mahaa no waawi wi'ude mahuɗo ɗum Ko waɗi mahirɗaa kam nii ? ");
INSERT INTO fuh_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Mahoowo looɗe no waawi waɗirde loopal ko hiɗi fuu. Loopal gootal ngal o mahirta loone ngam nde golliree nder golle lobbe sanne. O maha wonnde duu ngam nde golliree nder golle ɗe ngalaa darja baa seɗɗa. ");
INSERT INTO fuh_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Nii woni no golle Alla nga'i. O hiɗiino hollude tikkere makko, nden o holla baawɗe makko. Amma himɓe haanuɓe tikkere makko, wonɓe dow laawol hiitaneede ɓeen, o munyii ɓe munyal manngal. ");
INSERT INTO fuh_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","O waɗi ɗum duu ngam o wannginana ɓe o nanta yurmeene mum'en ɓeen teddungal makko ngal walaa keerol. ");
INSERT INTO fuh_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Enen duu ngoni ɓe o nanta yurmeene mum'en ɓeen. O noddaay en hakkune *Yahudankooɓe tan. O noddi en duu hakkune ɓe kanaa *Yahudankooɓe. ");
INSERT INTO fuh_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Ɗum woni ko Alla haali nder dewtere Hose'a : Himɓe ɓe kanaa himɓe am, mi noddiran ɓe himɓe am. Ɓe mi horsinaay, mi noddiran ɓe himɓe am horsuɓe. ");
INSERT INTO fuh_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","To ɓe mbi'aa, ɓe kanaa himɓe am, ɓe inndirtee ɓiɓɓe Alla duumiiɗo. ");
INSERT INTO fuh_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","*Esaaya kam duu haali sanne dow ɓiɓɓe *Isra'el, wi'i : Baa ɓiɓɓe *Isra'el ɗuuɗi faa poti no taasiri maayo, nder maɓɓe seɗɗa tan hisintee. ");
INSERT INTO fuh_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","Ngam Joomiraawo tabbintinan haala mum dow duuniyaaru. O humnan ka duu law-law. ");
INSERT INTO fuh_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Hano no *Esaaya waɗirnoo annabaaku wi'i : Nde nii Alla Joomiraawo dawranoowo huune fuu accaayno himɓe seɗɗa nder lenyol meeɗen, nden en laatakeno ir *Sodooma, en nanndiino he *Gomoora. ");
INSERT INTO fuh_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Ɗume mbi'eten nde nii ɓe kanaa *Yahudankooɓe, ɓe tarsinaaki fuu tefi dartinaaku yeeso Alla keɓi dartinaaku ? Dartinaaku ngu ɓe keɓi nguu, ir dartinaaku keɓirteengu har goonɗinol non. ");
INSERT INTO fuh_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Amma ɓiɓɓe *Isra'el tefuɓe dartinaaku har tokkol *Tawreeta, keɓaay ngu. ");
INSERT INTO fuh_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Ko waɗi ? Ɓe miilaaki ko goonɗinol hokkata ɓe ngu. Amma ko ɓe miili woni golle maɓɓe kokkata ɓe ngu. Ɓe pergi he hayre fergoore neɗɗo ndeen. ");
INSERT INTO fuh_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","Hano no ɗum winndiraa wi'aa : Mi resan nder *Siyon hayre fergoore himɓe. Nde waɗa ɓe caama. Amma neɗɗo fuu goonɗini mo, semtataa abada. ");
INSERT INTO fuh_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Banndiraaɓe, ko ɓurmi hidde fuu kam woni ɓiɓɓe *Isra'el fuu keɓa kisinam. Ɗum duu woni du'aa'u mo ndu'ananmi ɓe nder ɓerne am, mi eela Alla. ");
INSERT INTO fuh_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Miɗo seedanoo ɓe, wi'ude ko sikka fuu walaa ɓe kokki ko'e maɓɓe he ɓerne worre ɓe ngollana Alla. Amma kokkol ko'e maɓɓe ngool sinngaaki dow anndal. ");
INSERT INTO fuh_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Ɓe anndaa laawol ngol neɗɗo tokkata ko Alla wartira ɗum jom dartinaaku. Ɓe ndawrani ko'e maɓɓe laawol ngol ɓe tokkata ngam laataade jom'en dartinaaku yeeso Alla. Ɓe cuɓaaki tokkude laawol ngol Alla darni ngam wartirde himɓe jom'en dartinaaku. ");
INSERT INTO fuh_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","*Almasiihu wari humni *Tawreeta ngam goonɗinɗo mo fuu wartiree jom dartinaaku. ");
INSERT INTO fuh_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","*Muusa winndi dow dartinaaku ƴuwngu nder *Tawreeta wi'i : Neɗɗo fuu ɗowtani ko tilsinooje *Tawreeta wi'i, wuuran daliila majjum. ");
INSERT INTO fuh_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Amma ndaa ko haala Alla wi'i dow laataade jom dartinaaku daliila goonɗinol neɗɗo nii : To wi'u nder ɓerne maa moy waawi ƴeenyi dow kammu ? *Almasiihu jippaaki naa ? ");
INSERT INTO fuh_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","Naa kaden : Moy jippina nder ngaykaa laahara nga walaa fuu keerol ? *Almasiihu ummintinaaka he maayde naa ? ");
INSERT INTO fuh_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Ko winndaa wi'aa woni : Haala Alla no hadde maaɗa, ika nder hunnduko maaɗa, ika nder ɓerne maaɗa. Haala Alla ka woni waaju goonɗinol, mo min ngoni miɗen ngaɗa. ");
INSERT INTO fuh_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Ngam nde nii a yardake a wi'i aan he hoore maaɗa ko Iisa no Joomiraawo, ngoonɗinaa nder ɓerne maaɗa ko Alla ummintinii mo he maayde, a hisintee. ");
INSERT INTO fuh_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Goonɗinde nder ɓerne no waɗa Alla wartira neɗɗo jom dartinaaku. Fiirtude hunnduko mum yeeso himɓe fuu wi'a Iisa *Almasiihu woni Joomiraawo mum no holla ko neɗɗo heɓi kisinam. ");
INSERT INTO fuh_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Ngam no winndaa wi'aa : Goonɗinɗo mo fuu semtataa. ");
INSERT INTO fuh_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Joonin, walaa ko senndi Yahudanke he mo hanaa Yahudanke. Joomiraawo gooto jeyii ɓe. Omo barkinɗina faa noy walaa neɗɗo fuu eeluɗo mo. ");
INSERT INTO fuh_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Ngam no winndaa wi'aa : Neɗɗo fuu eeli Joomiraawo hisina ɗum, o hisinan ɗum. ");
INSERT INTO fuh_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Amma noy waɗata neɗɗo eela mo nde goonɗinaay ? Noy neɗɗo goonɗinirta mo, nde nii neɗɗo nanaay filla makko ? Noy neɗɗo nanirta filla makko, nde nii baajotooɗo walaa ? ");
INSERT INTO fuh_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Noy neɗɗo waajortoo, nde nii lilaaka ? No winndaa wi'aa : Belɗum ɓerne non, gi'ol garki koyɗe jottinooje *Habaru lobbo. ");
INSERT INTO fuh_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Amma hanaa himɓe fuu ngoonɗini *Habaru lobbo oon. *Esaaya wi'i : Yaa Joomiraawo, moy goonɗini waaju amin ? ");
INSERT INTO fuh_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Ngam majjum waɗi sey to neɗɗo hettinake waaju ko goonɗina. Waaju oo duu, o waaju dow *Almasiihu. ");
INSERT INTO fuh_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Mi ƴaman on, goonga fuu ɓiɓɓe *Isra'el nanaay mo naa ? Ɓe nani ngam no winndaa wi'aa : Daaɗe *lilaaɓe Alla nanaama nder leyɗe fuu, waaju maɓɓe fiilake kappa kuula duuniyaaru fuu. ");
INSERT INTO fuh_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Miɗo ƴama kaden, ɓiɓɓe *Isra'el paamaay naa ? Arannde nii har hunnduko *Muusa, Alla haali, wi'i : Mi waɗan kiron, ɓe kanaa jeyaaɓe am, mi waɗan tikkanon lenyol ngool walaa anndal. ");
INSERT INTO fuh_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Nden *Esaaya hulaay wi'ude Alla wi'i : Ɓe tefaayno kam, ngiiti kam. Ɓe ƴamanaayno kam ɓeen duu, mi wannginanii ɗum'en hoore am. ");
INSERT INTO fuh_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Amma har ko daarata ɓiɓɓe *Isra'el, Alla wi'i : Jemma e nyalooma, juuɗe am no peerti, ngam jaɓɓaade himɓe am, yorɓe-ko'e, saliiɓe ɗowtanaade kam. ");
INSERT INTO fuh_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Too, mi ƴami on : « Alla woppi ɓiɓɓe *Isra'el fuu naa ? » Hitere fuu hi'ataa ɗum. Miin he hoore am, mi ɓii-Isra'el, mi jippotooɗo *Ibrahim, mi ƴuwi nder lenyol Benyamin. ");
INSERT INTO fuh_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Alla woppaay himɓe mum ɓe suɓinoo illa arannde. Oɗon anndi ko winndaa wi'aa dow Eliya nder dewte Alla. No winndaa wi'aa ko Eliya wulliri ɓiɓɓe *Isra'el to Alla, wi'i : ");
INSERT INTO fuh_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","Yaa Joomiraawo, ɓe mbarii annabiiɓe maaɗa, ɓe cankitii nokkuuje ɗe dow mum'en sadakaaji maaɗa mbuletee. Miin tan hori, miin duu iɓe tefa warde kam. ");
INSERT INTO fuh_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Amma ko Alla jaabii mo wi'i nii : Mi resani hoore am worɓe ujunaaji jeɗɗo, ɓe cujidanaay Ba'al. ");
INSERT INTO fuh_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Non ɗum wa'i hannden duu. Hakkune himɓe, no tawa himɓe seɗɗa ɓe Alla suɓii daliila moƴƴere mum. ");
INSERT INTO fuh_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Cuɓaaki ki Alla suɓii neɗɗo daliila moƴƴere mum hanaa cuɓaaki ngaɗaaki daliila golle neɗɗo non. Ngam nde nii daliila golle neɗɗo Alla waɗi ki, nden moƴƴere makko laatataakono forba. ");
INSERT INTO fuh_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Ndenne, noy waɗi ? Ɓiɓɓe *Isra'el keɓaay ko tefunoo. Amma ɓe Alla suɓii hakkune maɓɓe, keɓi ko tefannoo, horiiɓe ɓeen duu ɓe fuu ɓe ngarti yorɓe-ko'e. ");
INSERT INTO fuh_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","Ngam no winndaa wi'aa : Alla wartirii ɓe wemmbaaɓe. Iɓe ngoodi gite, amma ɓe ngi'ataa, iɓe ngoodi noppi amma ɓe nanataa. Nii duu ɗum njooɗori he maɓɓe faa warde hannden. ");
INSERT INTO fuh_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Daawda duu wi'i : Alla wan juulɗe maɓɓe laatanoo ɓe tunnirgal, ɓe caama nder maggal, Alla wan ɓe pergo, fergere maɓɓe fooɗana ɓe kiite ɗe ɓe kaani. ");
INSERT INTO fuh_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Gite maɓɓe niɓɓa ngam to ɓe ngi'u. Alla wan ɓaawe torra ɓe, ɓe keppa turtaade faa abada. ");
INSERT INTO fuh_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Mi ƴaman on kaden : « Ko *Yahudankooɓe perginoo caami ɗum, ɓe caamu ko ɓe ummitittaako non, naa noy ? » Abada. Fergere maɓɓe laatani ɓe kanaa *Yahudankooɓe daliila keɓol kisinam. Alla waɗi ɗum duu heɓa *Yahudankooɓe kiraa. ");
INSERT INTO fuh_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Nde nii fergere maɓɓe waddani duuniyaaru barke, nde nii mursere maɓɓe duu waddani ɓe kanaa *Yahudankooɓe barke, ndenne noy barke keɓoyteeɗe nyannde fuu kappa kuula *Yahudankooɓe fuu tuubii, wa'ata ? ");
INSERT INTO fuh_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Joonin, onon ɓe kanaa *Yahudankooɓe ngondaami. Ko laatiimi lilaaɗo yahde he ɓe kanaa *Yahudankooɓe ɗum, mi nanngiran golle ɗe kokkaami ɗee juuɗe ɗiɗɗiɗi. ");
INSERT INTO fuh_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","Mi nanngiran ɗe juuɗe ɗiɗɗiɗi ngam ɓeydude kiram banndiraaɓe *Yahudankooɓe, mi hisina woɓɓe nder maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Nde nii kakkitol *Yahudankooɓe ngool waddi potal hakkune Alla he duuniyaaru, ndenne noy wartirde ɓe he laawol Alla wa'ata ? Ɗum wa'ataana hano ummitaaki he maayde. ");
INSERT INTO fuh_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Nde nii conndi buuru budaama faa cabbi buuru arani ɗiin cakkaama ngam Alla, ndenne cabbi buuru ɗiin fuu cakkaa ngam Alla. Nde nii Alla jeyii ɗaɗi lekki, ndenne calɗi makki fuu kanko jeyii ɗum. ");
INSERT INTO fuh_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Accee mi hokka on misaali oo. *Yahudankooɓe no nga'i hano jaytuuhi hilnaaki faa wooɗi. Aan mo hanaa Yahudanke duu aɗa wa'i hano liccal gariiri jaytuuhi. A taƴaama, ngaddeɗaa, kaɓɓeɗaa he jaytuuhi demanaaki faa wooɗi. Ndenne nyaamdu lobburu fuu, ndu licce makki mbaawi heɓude ngam mbuura, aɗa waawi heɓi ɗum. ");
INSERT INTO fuh_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","Amma tinna to wi'u a fiiran ɗum gabaare, mbi'aa ko a goɗɗum yeeso maɓɓe. Aɗa hiɗi piya gabaare mbi'aa a goɗɗum naa ? To yeggitin dow ɗaɗi makki ngonɗaa, hanaa ɗaɗi makki ngoni dow maaɗa. ");
INSERT INTO fuh_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","A wi'an : « Licce jaytuuhi aawaaɗe mbudditaama heɓa miin, liccal gariiri jaytuuhi ngal, mi waddee, mi haɓɓee nokku majje. » ");
INSERT INTO fuh_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Goonga ! Amma ngam rafi goonɗinol waɗi ɗe mbudditaa, ɗe ittaa, aan duu daliila goonɗinol maaɗa waɗi keɓuɗaa laawol jooɗaade aɗa haɓɓi he tunnduuru majje. Ndenne, to fiyu gabaare maa mbi'aa ko a goɗɗum, hakkila hulu Alla tan. ");
INSERT INTO fuh_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Ngam ko waɗi Alla accaay licce arane ɗeen waɗan o accataa ma, aan duu. ");
INSERT INTO fuh_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Ndenne, tayka moƴƴuki Alla, taykoɗaa tikkere makko duu ƴeewa : Tikkere makko no dow fergiiɓe caami, moƴƴuki makko no wondi he maaɗa, nde nii a tabbitii nder moƴƴuki makko kiin. Nde hanaa non, aan duu a saltetee. ");
INSERT INTO fuh_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Ɓiɓɓe *Isra'el duu, nde nii ɓe mboppi tiiɗal nyiraaku maɓɓe, ɓe ngoonɗini, Alla wartiran ɓe he jaytuuhi kiin. Ngam Alla no woodi baawɗe wartirde ɓe he makki. ");
INSERT INTO fuh_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Onon ɓe kanaa *Yahudankooɓe, onon tinndiniraaɓe liccal gariiri jaytuuhi, gaddaangal haɓɓaa he tunnduuru jaytuuhi aawaaki kiin. Ko ɗum waddi liccal gariiri ngal, ɗum haɓɓi he tunnduuru jaytuuhi aawaaki ɗum. Hegaaki ngal haɓɓee he tunnduuru makki. *Yahudankooɓe ngoni licce makki goonga e goonga, ndenne dow ko yaawi Alla haɓirta ɗe he makki. ");
INSERT INTO fuh_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Banndiraaɓe, mi hiɗaa kepon faamude siri Alla mo woni no suuɗi ɗo ngam to on piyee gabaaje mooɗon mbi'on on goɗɗum. Ɓiɓɓe *Isra'el heewɓe ɓerɗe mum'en njoori, faa heewɓe nder ɓe kanaa *Yahudankooɓe ngoonɗini, ngari kebbini Laamu Alla. ");
INSERT INTO fuh_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Nii waɗata ɓiɓɓe *Isra'el fuu kisinee, hano no ɗum winndiraa wi'aa : Kisinoowo ƴuwan *Siyon. O hakkitan rafi tokkude Alla nder ɓerɗe jippotooɓe he Yakuuba. ");
INSERT INTO fuh_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Ɗum woni amaana am he maɓɓe, wakkati mo moytanmi hakkeeji maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","*Yahudankooɓe ngarti wayɓe Alla, ngam ɓe tottitake *Habaru lobbo, ɗum laatii ɓeydaari mooɗon. Baa nii ko ɓe ngarti wayɓe Alla, Alla suɓake ɓe, waɗi ɓe himɓe mum. Omo hiɗi ɓe daliila maamiraaɓe maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Alla waylataa anniya mum dow mo o moƴƴani kokkal makko, he dow mo o noddi. ");
INSERT INTO fuh_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Onon ɓe kanaa *Yahudankooɓe, ndenno nii on tottitakeno Alla, amma hannden on keɓi yurmeene Alla ngam *Yahudankooɓe tottitake mo. ");
INSERT INTO fuh_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","Noon duu, joonin *Yahudankooɓe ngartii tottitiiɓe Alla ngam ɓe keɓa yurmeene Alla, nde Alla holli on. ");
INSERT INTO fuh_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Alla tinnanaay himɓe leesinanoo ɗum ngam hollude ɓe yurmeene mum. ");
INSERT INTO fuh_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Hey barkeeji Alla korsuɗi no ɗuuɗi no mawni ! Hikma makko he anndal makko no luggiɗɗi sanne ! Neɗɗo fuu waawaa anndude anniyaaji makko. Neɗɗo fuu waawaa faami no o gollirta. ");
INSERT INTO fuh_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","Ngam no winndaa wi'aa : Moy anndi miilooji Joomiraawo ? Moy waawi hollita mo ? ");
INSERT INTO fuh_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","Moy arti hokki mo goɗɗum, faa ɗum laatoo tilaay o yoɓa joomum ? ");
INSERT INTO fuh_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Nde goonga, kanko tagi huune fuu. Huune fuu to makko ƴuwi, kanko duu jeyii huune fuu. Teddungal woodani Alla faa abada. Aamiin ! ");
INSERT INTO fuh_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Banndiraaɓe, miɗo eela on ngam barke yurmeene nde Alla holli en, kokkee ko'e mooɗon Alla hano *sadaka ciryaaɗo ngam golle makko, *sadaka ceniiɗo, belɗo ɓerne makko. Ɗum woni laawol ngol tokkoton ngam rewude Alla no haaniri. ");
INSERT INTO fuh_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","To nyemminee duuniyaaru nduu, accee Alla heyɗintina hakkillooji mooɗon heɓa ɓerɗe mooɗon mbaylitoo, mbaawon anndude ko yaadata he muuyɗe Alla kam woni ko wooɗi, ko huuɓi he ko weli mo. ");
INSERT INTO fuh_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Daliila moƴƴere nde Alla waɗani kam, miɗo wi'a neɗɗo mooɗon fuu, to yaaru hoore mum to yottaaki. Neɗɗo fuu eta hoore mum daara no wa'i. Kam woni neɗɗo eta hoore mum dey-dey etirgal goonɗinol ngal Alla hokki ɗum. ");
INSERT INTO fuh_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Neɗɗo meeɗen fuu no woodi terde ɓanndu, terde fuu he gollal mum. ");
INSERT INTO fuh_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","Baa nii ko eɗen ɗuuɗi, enen he ɗuuɗal meeɗen fuu, nder kawtal meeɗen he *Almasiihu, en ɓanndu worru, en fuu eɗen njokkodiri yahde. Neɗɗo meeɗen fuu no terde ɓanndu. ");
INSERT INTO fuh_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","En kokkaama kokke feere-fereeje ɗe *Ruuhu Alla hokkata. Nde nii Alla waɗi kokkal meeɗen no kokkal waɗude annabaaku, too en ngaɗu annabaaku meeɗen dey-dey no ngoonɗinirɗen Iisa. ");
INSERT INTO fuh_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","Mo Alla hokki kokkal wallude woɓɓe, walla ɓe. Mo Alla hokki kokkal jannginde, janngina. ");
INSERT INTO fuh_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","Mo Alla hokki kokkal semmbinɗinde himɓe, semmbinɗina himɓe. Mo Alla hokki kokkal moƴƴande himɓe, moƴƴana himɓe he ɓerne worre. Mo Alla hokki kokkal ardaaki, ardoroo tinaare. Mo Alla hokki kokkal yurmaade himɓe duu, yeha waɗa golle mum he ɓerne welne. ");
INSERT INTO fuh_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Hidde mooɗon laatoo hidde goonga e goonga. Ndoggee waɗude ko boni, tiɓinee ko wooɗi. ");
INSERT INTO fuh_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Ngiɗodiree he ɓerne worre hano on banndiraaɓe. Neɗɗo mooɗon fuu teddina banndum faa ɓurna ɗum hoore muuɗum. ");
INSERT INTO fuh_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","To accee yannde nannga on amma njagganee Joomiraawo hano maccuɓe, ngollanee Joomiraawo he ɓerne worre. ");
INSERT INTO fuh_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","Nanee belɗum daliila tammude mooɗon. Munyee torra, tinnee he waɗude du'aa'u. ");
INSERT INTO fuh_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","Cenndee ko njogiɗon kokkaron himɓe Alla hiɗuɓe walleede, laatee weernooɓe himɓe. ");
INSERT INTO fuh_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Mbarkinɗinee torrooɓe on. To kuɗee ɓe, amma mbarkinɗinee ɓe. ");
INSERT INTO fuh_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Nanidee belɗum he nanooɓe belɗum, mboydee he woyooɓe. ");
INSERT INTO fuh_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Laatee daane worre, to ndonndee ko'e amma laatee leesiniiɓe nder ko ngatton fuu. To adee ko'e mooɗon hano marɓe hikmaaku. ");
INSERT INTO fuh_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Nde goɗɗo waɗi on gacce, to njottitee. Ndurwee tawee ko ngaɗon fuu laatoo ko dartii yeeso himɓe fuu. ");
INSERT INTO fuh_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Nde no heɓo, njooɗodoɗon jam he himɓe fuu, nde nii onon ngoni waddooɓe jam. ");
INSERT INTO fuh_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Banndiraaɓe am horsuɓe, nde nii on ngaɗaama ko metti, to njoptitanee ko'e mooɗon. Accee Alla watta tikkere mum yoptanoo on. Ngam no winndaa wi'aa Joomiraawo wi'i : Miin jeyii yoptitaade, mi yoɓan neɗɗo fuu dey-dey ko haani. ");
INSERT INTO fuh_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","No winndaa wi'aa kaden Joomiraawo wi'i : Nde ganyo maaɗa rafaama, nyamnu mo. Nde nii o ɗomɗaama, yarnu mo. Nde nii a waɗani mo kujje ɗee, too hano nii pette ɓottuɗaa, njoowuɗaa dow hoore makko. ");
INSERT INTO fuh_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","To accu gaɗol ko boni jaale, amma waɗu ko wooɗi, njaaloɗaa gaɗol ko boni. ");
INSERT INTO fuh_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Neɗɗo fuu ɗowtanoo ardiiɗo mum, ngam ardaŋal walaa ngal hanaa to Alla ngal ƴuwi. Ardiiɗo fuu, Alla ardini ɗum. ");
INSERT INTO fuh_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Ndenne, neɗɗo fuu salii ardaŋal leydi mum salake ko Alla wi'i. Caliiɗo ko Alla wi'i duu fooɗanan hoore mum kiite. ");
INSERT INTO fuh_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Neɗɗo gaɗoowo ko wooɗi walaa ko huldata ardiiɓe kiite leydi mum. Amma nde neɗɗo waɗi ko boni, ndenne tilay neɗɗo hula ɓe. Aɗa hiɗi acca hulude ardiiɓe leydi naa ? Ndenne, waɗu ko wooɗi. Nde nii a waɗi ko wooɗi fuu, ɓe njettete. ");
INSERT INTO fuh_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","Ardiiɓe no gollanooɓe Alla ngam wattude ma waɗude ko wooɗi. Amma nde nii waɗude ko boni woni gollal maaɗa, too hulu ɓe, ngam meere waɗaay iɓe njogii cabbi fiyude waɗuɓe ko boni. Nder jukkol gaɗuɗo ko boni iɓe mbanngina tikkere nde Alla woodani gaɗoowo ko boni. ");
INSERT INTO fuh_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Ndenne, no haani ɗowtanoɗon ardiiɓe, hanaa ngam kulol kiite tan, amma ngam to ɓerɗe mooɗon pelu on. ");
INSERT INTO fuh_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Ngam majjum waɗi oɗon njoɓa janngal. Ardiiɓe *jaɓooɓe janngal ngaal duu, Alla ardini ɓe ngam ɓe ngollana ɗum wakkati fuu. ");
INSERT INTO fuh_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Njoɓee neɗɗo fuu ko tokkata on. Nde nii janngal mooɗon, onon he ko'e mooɗon kaanuɗon yoɓude, njoɓee ngal. Nde janngal gineeji mooɗon kaanuɗon yoɓude duu, too njoɓee ngal, foti ko hen non fuu. Ɗowtanee mo kaanuɗon ɗowtanaade, teddinon mo kaanuɗon teddinde. ");
INSERT INTO fuh_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","To njaɓee neɗɗo fuu tokka on nyamaane. Nyamaane worre tan haani naatude hakkune mooɗon, onon goonɗinɓe, nyamaane nde woni hiɗodirde. Ngam neɗɗo fuu hiɗi gondo mum, humni ko *Tawreeta wi'i. ");
INSERT INTO fuh_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","Ngam no winndaa wi'aa nder *Tawreeta : To yeenu, to ittu yonki goɗɗo, to wujju, to suuna ko goɗɗo. Tilsinooje ɗee he koriiɗe ɗeen fuu kawra nder tilsinoore wi'ude : Ngiɗaa gondo maa no ngiɗirɗaa hoore maa. ");
INSERT INTO fuh_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Neɗɗo fuu woodi hidde nder ɓerne mum waawaa waɗani gondo mum ko boni. Ndenne, hidde no humna ko *Tawreeta wi'i. ");
INSERT INTO fuh_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Taykee kujje ɗee fuu ngam oɗon anndi wakkati mo ngonɗen nder mum. Wakkati mo kaanuɗon finude oon waɗi. Joonin kisinam ɓuri ɓadaade en dina wakkati mo puɗɗuɗen goonɗinde. ");
INSERT INTO fuh_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","Jemma woɗɗini, woɗɗaa weetude, ndenne en mboɗɗoo golle bonɗe, ɓornoɗen kaɓorɗe meeɗen annuura. ");
INSERT INTO fuh_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","Mbuuren mbuurnam wonɓe nder jeyngol, mboɗɗoɗen nyaamɗe he yaru-yaru ɗuɗɗo. En mboɗɗoo jeenu he golle nyiddiniiɗe. En mboɗɗoo pooɗodirol he haasidaaku. ");
INSERT INTO fuh_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","Nder jikku meeɗen he nder ko mbi'eten fuu, en nyemmin Iisa *Almasiihu Joomiraawo meeɗen. To en tokkito belɗum ɓerɗe meeɗen accen suuno bonngo heewa mbuurnam meeɗen. ");
INSERT INTO fuh_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","Njaɓɓee mo goonɗinol muuɗum semmbiɗaa, to nanngiree mo duu, baa nde nii tawi ko o miili no feere, ko onon duu miiliɗon no feere. ");
INSERT INTO fuh_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","Alal-misaali, goɗɗo ngam ɓenndi nder goonɗinol no miila ko no dagii kam nyaama ko heɓi fuu. Amma goɗɗo ngam ɓenndaay nder goonɗinol nyaamataa ko heɓi fuu, ɓiɓɓe kaliyol tan nyaamata. ");
INSERT INTO fuh_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","Nyaamoowo ko heɓi fuu oon, to felu mo nyaamataa ko heɓi fuu oon. Mo nyaamataa ko heɓi fuu oon duu to felu nyaamoowo ko heɓi fuu oon, ngam nyaamoowo ko heɓi fuu oon, Alla jaɓɓake mo. ");
INSERT INTO fuh_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","Aan woni moy faa mbi'aa gollanoowo goɗɗo gollal mum wooɗaay ? Mawɗo makko haani wi'ude ko o waɗi ɗum no wooɗi naa ɗum wooɗaa. Mo peluɗaa oo no tittinkinto ngam Joomiraawo woni balla makko. ");
INSERT INTO fuh_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Goɗɗo no hi'a ko nyalaane gom ɓuri nyalaaɗe fuu teddude. Goɗɗo duu to mum nyalaaɗe ɗeen fuu no potu. Neɗɗo fuu tabbintina ɗum nder ɓerne mum. ");
INSERT INTO fuh_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","Peerodirɗo nyalaaɗe oon, ɓurdina ɗe ngam teddinde Joomiraawo. Kaden duu, nyaamoowo ko heɓi fuu, nyaama ko heɓi fuu ngam teddinde Joomiraawo, joomum yetta Alla. Mo nyaamataa ko heɓi fuu oon duu, suɓo nyaama ko hiɗi ngam teddinde Joomiraawo, joomum yetta Alla duu. ");
INSERT INTO fuh_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","Hakkune meeɗen walaa gonɗo no wuura ngam ɓeydaari hoore mum tan. Walaa duu maayanɗo ngam ɓeydaari hoore muuɗum tan. ");
INSERT INTO fuh_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","Nde en mbuuri, Joomiraawo mbuuranɗen. Nde en maayi duu, Joomiraawo maayanɗen. Ndenne, nde en mbuuri naa nde en maayi, Joomiraawo nii jeyii en. ");
INSERT INTO fuh_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","*Almasiihu maayaana ummitii ngam o laatoo Joomiraawo wuurɓe he maayɓe fuu. ");
INSERT INTO fuh_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","Nde nii non, aan mo nyaamataa ko heɓi fuu oon, ɗume waɗi aɗa wi'a bannda waɗi ko wooɗaa ? Naa aan, nyaamoowo ko heɓi fuu oon, ɗume waɗi aɗa yawo bannda mo nyaamataa ko heɓi fuu oo ? En fuu, en ndaroyto yeeso Alla, o hiito en. ");
INSERT INTO fuh_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","Ngam no winndaa wi'aa : Mi hunorake hoore am, miin Joomiraawo, howru fuu hofoto yeeso am, ɗemngal fuu jaɓan wi'a miin woni Alla. ");
INSERT INTO fuh_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","Ndenne, neɗɗo meeɗen fuu haalan ko kam waɗi nder mbuurnam mum yeeso Alla. ");
INSERT INTO fuh_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","Neɗɗo meeɗen fuu acca dekande banndum waɗude ko wooɗaa. Ko kaanuɗen waɗude woni faddaade ko'e meeɗen he huune fuu ko waawi fergude banndiraaɓe meeɗen, naa uppude ɓe, ɓe ngaɗa ko wooɗaa. ");
INSERT INTO fuh_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","Miɗo anndi, mi tabbintini duu, ko nder kawtal meeɗen he Iisa *Almasiihu Joomiraawo meeɗen, walaa ko harmi, he hoore mum. Amma nde neɗɗo miili ko huune ndee no harmi, ɗum harmanan joomum. ");
INSERT INTO fuh_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","Nde a torri bannda goonɗinɗo ngam ko nyaamata, a tokkaay laawol hidde. Hakkila ngam ko nyaamata to laatoo laawol halkere bannda mo *Almasiihu maayi daliila mum. ");
INSERT INTO fuh_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","Tinna to ko ndaaruɗaa no wooɗi ɗum, laatoo ko bannda goonɗinɗo jancirtee. ");
INSERT INTO fuh_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","Ngam Laamu Alla hanaa filla nyaamdu naa jarɗe tan. Laamu Alla filla dartinaaku, jam he seyo non keɓeten har kawtal meeɗen he *Ruuhu Ceniiɗo. ");
INSERT INTO fuh_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","Neɗɗo fuu gollani *Almasiihu nder iri nii he banndum welan Alla, himɓe duu teddinan ɗum. ");
INSERT INTO fuh_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","Ndenne, en tefu ko ɓeydata jam hakkune meeɗen. Neɗɗo fuu tefa ko semmbinɗinta goonɗinol banndum. ");
INSERT INTO fuh_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","To mbonnee golle Alla ngam filla nyaamdu. Nde goonga, nyaamdu fuu harmaa. Amma nde nii nyaamdu ndu nyaamata no laatoo fergere bannda goonɗinɗo, too wooɗaa, nyaama nyaamdu ndu omo hi'a. ");
INSERT INTO fuh_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","Alal misaali ko ɓuri woni, to neɗɗo fuu nyaamu naa yaru naa mbi'en to neɗɗo fuu waɗu ko fergata banndum goonɗinɗo waɗa hakke. ");
INSERT INTO fuh_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","Joga hakkune maaɗa he Alla tabbintinol ngol goonɗinol maaɗa hokki ma. Belɗo hoore woni mo ɓerne mum felataa ɗum nder ko woni no waɗa fuu. ");
INSERT INTO fuh_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","Amma neɗɗo fuu sikki nyaamdu, dey nyaami ndu no jukkaaɗo, ngam nyaamiraay ndu goonɗinol. Huune fuu ko ɓerne maaɗa fukkaaki he mum, no hakke. ");
INSERT INTO fuh_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","Enen, ɓe goonɗinol mum'en semmbiɗi, no haani munyen jikku ɓe goonɗinol mum'en semmbiɗaa. To en tefu ko weli en tan. ");
INSERT INTO fuh_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","Neɗɗo meeɗen fuu tefa ko welata ɓerne banndum goonɗinɗo ngam semmbinɗina mo nder goonɗinol makko. ");
INSERT INTO fuh_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","Ngam *Almasiihu he hoore mum tokkaay mbelirka yonki mum, amma hano no ɗum winndiraa wi'aa : Jennooje, yennuɓe ma fuu, dow am saami. ");
INSERT INTO fuh_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","Huune fuu ko winndanoo illa arannde nder dewte Alla, winndaama ngam ekkintinde en. Ɗum winndaama duu ngam keɓen tammude daliila tittinkinaaku he munyal ngal Dewtere Alla hokkata en. ");
INSERT INTO fuh_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","Alla marɗo munyal, cemmbinɗinoowo ɓerɗe hokku on laawol laataade daane worre dow laawol Iisa *Almasiihu. ");
INSERT INTO fuh_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","O hokka on laawol ngool heɓa he ɓerne worre ngaɗon daane worre teddinon Alla *Baaba Iisa *Almasiihu Joomiraawo meeɗen. ");
INSERT INTO fuh_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","Njaɓɓodiree no *Almasiihu jaɓɓori on heɓa Alla teddinee. ");
INSERT INTO fuh_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","Miɗo wi'a on ko arannde fuu ngam Alla no kolniiɗo waɗi *Almasiihu laatii gollanoowo *Yahudankooɓe ngam humnude alkawal ngal Alla waɗannoo maamiraaɓe maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","O wari duu ngam ɓe kanaa *Yahudankooɓe teddina Alla ngam Alla no jom yurmeene, hano no ɗum winndiraa wi'aa : Hakkune ɓe kanaa *Yahudankooɓe mi wi'an ko a Joomiraawo, mi yimante ngam teddinde innde maaɗa. ");
INSERT INTO fuh_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","No winndaa kaden wi'aa : Onon ɓe kanaa *Yahudankooɓe, tokkee himɓe Alla nanon belɗum. ");
INSERT INTO fuh_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","Winndaama duu wi'aa : Onon ɓe kanaa *Yahudankooɓe, on fuu, njettee Joomiraawo ! Neɗɗo fuu, yima teddungal makko ! ");
INSERT INTO fuh_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","*Esaaya duu wi'i : Jippotooɗo he Yesa gom warowan, kanko ummoto laamoo ɓe kanaa *Yahudankooɓe. Ɓe ngattan gokka maɓɓe fuu dow makko. ");
INSERT INTO fuh_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","Alla Jom gokka hebbina on welwelo, hokka on jam ngam barke goonɗinol mooɗon, keewon tammude nder baawɗe *Ruuhu Ceniiɗo. ");
INSERT INTO fuh_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","Banndiraaɓe am, sikka fuu walaa to am, on keewɓe jikku lobbu, oɗon keewi anndal, kaden neɗɗo mooɗon fuu no waawi ekkintini banndum faa wooɗa. ");
INSERT INTO fuh_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","Amma nder ɗerol am ngol mbinndanmi on ngool, mi hulaay miccintinde on ko njanngunoɗon. Mi waɗi ɗum duu ngam moƴƴere nde Alla hokki kam. ");
INSERT INTO fuh_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","O waɗi kam gollanoowo Iisa *Almasiihu hakkune ɓe kanaa *Yahudankooɓe. O waɗi kam *cakkanoowo Alla he baajotooɗo *Habaru makko lobbo. Ndenne, ɓe kanaa *Yahudankooɓe mbaawan laataade ir *sadaka mo *Ruuhu Ceniiɗo wartiri feere, ngam wela Alla. ");
INSERT INTO fuh_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","Ndenne, daliila kawtal am he Iisa *Almasiihu, miɗo waawi fiyude gabaare dow golle ɗe ngollananmi Alla. ");
INSERT INTO fuh_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","Mi suusaa wi'i goɗɗum ko ƴaari golle *Almasiihu ɗe o walliri kam ngaɗumi. O wallii kam heɓa ɓe kanaa *Yahudankooɓe tokka haala Alla daliila golle am e waaju am, ");
INSERT INTO fuh_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","daliila alamaaji kaayɗiniiɗi gooduɗi baawɗe daliila baawɗe ɗe *Ruuhu Alla jogii. Mi waajake *Habaru lobbo, filla *Almasiihu nanngaa illa *Ursaliima faa tukka he leydi Illirikum. ");
INSERT INTO fuh_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","Ko wonnoo nder ɓerne am woni waajaade *Habaru lobbo, filla *Almasiihu, nder nokkuuje ɗe himɓe meeɗaay nanude filla oo no waɗee ngam to mi nyiɓu dow diidol nyibdi ngol goɗɗo diidi. ");
INSERT INTO fuh_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","Mi tokkiraana hano no ɗum winndiraa wi'aa : Ɓe mbaajaakano baa nde worre filla makko, ngi'owan mo, ɓe nanaayno filla makko duu paamowan. ");
INSERT INTO fuh_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","Kile keewɗe, mi muuyi yottaade to mooɗon amma waajaade *Habaru lobbo to waajaakano haɗi kam warde to mooɗon. ");
INSERT INTO fuh_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","Joonin golle am hakkune ɓe meeɗaay nanude filla *Almasiihu kanti. Duuɓi re'ataa nii ko mi haaɓi mi hi'aay on. ");
INSERT INTO fuh_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","Mi anniyake hannden tuntowaade on. Nyannde fuu ummiimi yahde leydi Espaniya, miɗo hiɗi mi fanta to mooɗon. Nde mi wari, mi waɗan balɗe hakkune mooɗon. Nde mi hi'i on faa hakkillo am fukkake, miɗo hiɗi mi heɓa balla yottowaade Espaniya. ");
INSERT INTO fuh_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","Amma joonin mi yahan *Ursaliima ngam walloyde himɓe Alla wonɓe nder huɓeere ndee, ");
INSERT INTO fuh_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","ngam goonɗinɓe wonɓe Makedoniya e Akaya anniyake hawrude balla ngam ɓe kokka talkaaɓe wonɓe hakkune himɓe Alla nder *Ursaliima. ");
INSERT INTO fuh_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","Ɓe anniyake wallude ɓe amma nde goonga ɗum hanaa balla, ɗum yoɓitaade nyamaane moƴƴere. Goonɗinɓe Makedoniya he Akaya kanaa *Yahudankooɓe amma ɓe keɓi moƴƴere he barke *Ruuhu ɗe Alla waɗani *Yahudankooɓe alkawal mum. Ndenne, no haani ɓe ngatta njawdi maɓɓe ɓe mballira *Yahudankooɓe *Ursaliima. ");
INSERT INTO fuh_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","Nyannde fuu njottinmi balla kawraaka kaa, mi fantan on fadde am yahde Espaniya. ");
INSERT INTO fuh_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","Miɗo tabbintini ko nde nii mi wari to mooɗon, *Almasiihu barkinan on faa noy walaa daliila barke garki am to mooɗon. ");
INSERT INTO fuh_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","Banndiraaɓe, mi eeli on ngam barke Iisa *Almasiihu Joomiraawo meeɗen, mi eeli on ngam barke hidde nde *Ruuhu Alla hokkata : Kawree mballon kam nder durwo am, nder du'aa'u, eelanon kam Alla sanne. ");
INSERT INTO fuh_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","Eelon Alla hiina kam sarri himɓe Yahudiya ɓe kanaa goonɗinɓe. Ndu'ee heɓa goonɗinɓe wonɓe *Ursaliima njaɓira balla ka njaranmi kaa he ɓerne worre. ");
INSERT INTO fuh_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","Nde Alla jaɓi du'aa'uuji mooɗon, mi yottoto to mooɗon he ɓerne welne, mi jooɗo mi fowta hakkune mooɗon. ");
INSERT INTO fuh_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","Alla Jom jam wonda he mooɗon, on fuu. Aamiin ! ");
INSERT INTO fuh_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","Miɗo hiɗi mi wi'a on ko Fiibi, banndii'en debbo, golloowo hakkune goonɗinɓe Kenkereya no debbo jom goonga. ");
INSERT INTO fuh_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","Njaɓɓoree mo nder innde Joomiraawo hano no himɓe Alla kaaniri. Mballiree mo huune fuu ko o haajaa, ngam o walli heewɓe, miin he hoore am, o wallii kam. ");
INSERT INTO fuh_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","Miɗo yewta Piriskilla he Akilas, ɓe miin he mum'en kawtidi golle Iisa *Almasiihu. ");
INSERT INTO fuh_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","Ɓe kosi mursude yonkiiji maɓɓe ngam dannude yonki am. Hanaa miin tan yetti ɓe, kawriiɗe goonɗinɓe ɓe kanaa *Yahudankooɓe fuu njetti ɓe. ");
INSERT INTO fuh_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","Miɗo yewta goonɗinɓe warooɓe no kawra nder suudu maɓɓe. Miɗo yewta Epaynetus, giɗo am korsuɗo. Kanko arti goonɗinde *Almasiihu nder leydi Asiya. ");
INSERT INTO fuh_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","Miɗo yewta Mariyaama tampanɗo on sanne. ");
INSERT INTO fuh_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","Mi yewti Andaronikus he Yuniyas, *Yahudankooɓe uddidaaɓe he am. Lilaaɓe mawɓe anndaaɓe sanne non, iɓe arti kam goonɗinde *Almasiihu. ");
INSERT INTO fuh_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","Mi yewti Ampiliyaatus, korsuɗo he am daliila Joomiraawo. ");
INSERT INTO fuh_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","Miɗo yewta Urbanus, mo kawtuɗen golle *Almasiihu, mi yeggitaay Estakis giɗo am korsuɗo. ");
INSERT INTO fuh_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","Mi yewti Apeles, kolluɗo ko kam no tokkuɗo *Almasiihu goonga e goonga. Mi yewti himɓe wuro Aristobulus. ");
INSERT INTO fuh_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","Mi yewti Herodiyon banndam Yahudanke. Mi yewti himɓe wuro Narsisi goonɗinɓe Joomiraawo. ");
INSERT INTO fuh_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","Mi yewti Tirifena he Tirifosa, rewɓe gollanooɓe Joomiraawo. Miɗo yewta Persis mo korsinmi, debbo tampuɗo sanne nder gollal Joomiraawo. ");
INSERT INTO fuh_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","Mi yewti Rufus cuɓaaɗo Joomiraawo. Mi yewti inniiko laatiiɗo inna am, miin duu. ");
INSERT INTO fuh_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","Mi yewti Asinkiritus, Felegon, Hermes, Patorobas he Hermas, mi yewti goonɗinɓe Iisa wonduɓe he maɓɓe fuu. ");
INSERT INTO fuh_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","Mi yewti Filologus he Yuliya, njewtanee kam Nireyus he sakiike mum debbo, mi yewti Olimpas. Miɗo yewta duu himɓe Alla wonduɓe he maɓɓe fuu. ");
INSERT INTO fuh_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","Mbundodiree hakkune mooɗon nder hidde he enɗam. Kawriiɗe goonɗinɓe *Almasiihu fuu no njewta on. ");
INSERT INTO fuh_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","Banndiraaɓe, miɗo fooɗa hakkillo mooɗon, miɗo eela on, kakkiloɗon he wattooɓe pooɗodirol hakkune mooɗon. Himɓe tefuɓe perga on itta on dow ko ekkintinaɗon. Mboɗɗee himɓe ɓee, ");
INSERT INTO fuh_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","ngam ɓe ngalaa iɓe ngollana *Almasiihu Joomiraawo meeɗen. Deeɗi maɓɓe tan ɓe ngollanta. Haalaaji mbelɗi he fewre, ɓe eytirta hakkillo kettinaniiɗo ɓe naa mo anndal mum luggiɗaa. ");
INSERT INTO fuh_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","Onon nee, filla ɗowtanaaki mooɗon walaa fuu to yehaay, ngam majjum miɗo nana belɗum daliila mooɗon. Mi hiɗaana ngarton jom'en hakkillo, anndon ko wooɗi, mboɗɗoɗon waɗude ko wooɗaa. ");
INSERT INTO fuh_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","Ɓooyataa, Alla Jom jam waɗan Seyɗan mornyo ley teppe mooɗon. Moƴƴere Iisa *Almasiihu Joomiraawo meeɗen wonda he mooɗon ! ");
INSERT INTO fuh_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","Timote gollidoowo he am no yewta on. Lukiyus, Yason he Sosipatoros banndiraaɓe am *Yahudankooɓe no njewta on. ");
INSERT INTO fuh_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","Miin, Tertiyus, binndanɗo Pol ɗerol ngool, miɗo yewta on daliila kawtal meeɗen he Joomiraawo. ");
INSERT INTO fuh_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","Gayus, bernuɗo kam no yewta on, wuro makko goonɗinɓe fuu kawrata. Erastus kalfinaaɗo ceede huɓeere Korintu no yewta on. Banndii'en Kuwartus no yewta on.  ");
INSERT INTO fuh_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","Moƴƴere Iisa *Almasiihu Joomiraawo meeɗen wonda he mooɗon, on fuu. Aamiin ! ");
INSERT INTO fuh_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","Jettooje ngoodani Alla, gooduɗo baawɗe semmbinɗinde on daliila *Habaru lobbo, filla Iisa *Almasiihu mo mbaajotoomi. Har *Habaru lobbo, Alla waɗi siri cuuɗaaɗo illa fil'ajal wannginee. ");
INSERT INTO fuh_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","Amma hannden siri oo wannginaama yahde he ɓe kanaa *Yahudankooɓe har dewte ɗe annabiiɓe mbinndi hano no Alla Duumiiɗo wi'iri ɓe mbinndira ɗe ngam ɓe kanaa *Yahudankooɓe ngoonɗina Alla, ɗowtanoo mo. ");
INSERT INTO fuh_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","Teddungal laatanoo Alla Jom hikmaaku. Teddungal woodani mo faa abada har Iisa *Almasiihu. Aamiin !");
INSERT INTO fuh_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","Miin Pol mo, Alla suɓii waɗi lilaaɗo Iisa *Almasiihu e banndi'en Sostenes, minen mbinndani on ɗerol ngool, ");
INSERT INTO fuh_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","onon hawriine goonɗinɓe Alla wonnde huɓeere Korintu, hawriine nde nder kawtal mum he *Almasiihu, Alla noddi ɗum wartiri feere ngam wartude seniiɓe. Miɗen njewta on, on fuu. Min mbinndii ɗerol ngool duu ngam noddooɓe innde Iisa *Almasiihu Joomiraawo meeɗen, to ɓe tawa fuu. Iisa *Almasiihu gooto oo nii woni Joomiraawo meeɗen, kanko oon duu woni Joomiraawo maɓɓe. ");
INSERT INTO fuh_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","Alla *Baabiraawo he Iisa *Almasiihu Joomiraawo meeɗen hokku on jam e moƴƴere. ");
INSERT INTO fuh_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","Wakkati fuu miɗo yetta Alla ngam mooɗon. Daliila yettoore am ndee woni moƴƴere nde o hokki on har Iisa *Almasiihu. ");
INSERT INTO fuh_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","Kawtal mooɗon he Iisa *Almasiihu barkinii on dow laawol iri ngool hen non fuu. On diikiɗii nder iri haala fuu, he nder iri anndal fuu, ");
INSERT INTO fuh_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","dey-dey no seedaaku *Almasiihu tabbintiniraa hakkune mooɗon. ");
INSERT INTO fuh_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","Ndenne, onon keɗiiɓe gartol Iisa *Almasiihu Joomiraawo meeɗen, walaa kokkal ngal ŋakkani on nder kokke ɗe *Ruuhu Alla hokkata goonɗinɗo. ");
INSERT INTO fuh_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","Kanko Iisa *Almasiihu oon semmbinɗinta on faa nyannde huune fuu timmi. Ndenne, neɗɗo fuu heɓataa ko feliri on nyannde fuu Iisa warti. ");
INSERT INTO fuh_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","Alla no kolniiɗo, kanko duu noddi on kawton he Ɓiyiiko Iisa *Almasiihu Joomiraawo meeɗen. ");
INSERT INTO fuh_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","Banndiraaɓe, ko eelanmi on woni ngam barke Iisa *Almasiihu Joomiraawo meeɗen, nanngodiron, laatee hunnduko wooto. To accee pooɗodirol gom fuu naata hakkune mooɗon. Ngaɗee daane worre, miilooji mooɗon duu laatoo miilo wooto. ");
INSERT INTO fuh_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","Banndiraaɓe am, se goonga koreeji debbo bi'eteeɗo Kolowe mbi'i kam ko pooɗodirol no hakkune mooɗon. ");
INSERT INTO fuh_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","Ko ngiɗumi wi'ude ɗo