﻿USE sofia;
DROP TABLE IF EXISTS sofia.fuf_vpl;
CREATE TABLE fuf_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES fuf_vpl WRITE;
INSERT INTO fuf_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Taariika iwdi Iisaa *Almasiihu mo Daawuuda mo Ibraahiima. ");
INSERT INTO fuf_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ko Ibraahiima jibini Issaaqa, Issaaqa jibini Yaaquuba, Yaaquuba jibini Yahuuda e musiɓɓe mun ɓen, ");
INSERT INTO fuf_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yahuuda kadi jibini Faarisa e Zaaraha, tawi yumma ɓen no wi'ee Tamaaru. Faarisa jibini Hasruunu, Hasruunu jibini Araama, ");
INSERT INTO fuf_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Araama jibini Ammiina-Daaba, Ammiina-Daaba jibini Nahasuuna, Nahasuuna jibini Salmaana, ");
INSERT INTO fuf_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Raabi* jibinani Salmaana Bo'aaza, Rugiyata jibinani Bo'aaza Obiida, Obiida jibini Yassaa'u, ");
INSERT INTO fuf_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yassaa'u jibini Daawuuda lanɗo on, oo wonnooɗo ɓeyngu Uriyaa jibinani mo kanko Daawuuda Sulaymaana. ");
INSERT INTO fuf_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Sulaymaana jibini Rahabaama, Rahabaama jibini Abiiya. Abiiya jibini Asaa, ");
INSERT INTO fuf_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asaa jibini Yuhusaafata, Yuhusaafata jibini Yuuraama, Yuuraama jibini Uziiya, ");
INSERT INTO fuf_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uziiya jibini Yotaana, Yotaana jibini Ahaaza, Ahaaza jibini Hazikiiya, ");
INSERT INTO fuf_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hazikiiya jibini Manase, Manase jibini Amuunu, Amuunu jibini Yuusiya, ");
INSERT INTO fuf_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yuusiya jibini Yeekoniya e musiɓɓe mun ɓen fewndo egginegol naɓee *Baabiila. ");
INSERT INTO fuf_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ɓawto egginegol naɓee Baabiila ngol, Yeekoniya jibini Sa'alti'iila, Sa'alti'iila jibini Zarubaabila, ");
INSERT INTO fuf_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zarubaabila jibini Abiyuuda, Abiyuuda jibini Alyaqiima, Alyaqiima jibini Aazuru, ");
INSERT INTO fuf_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Aazuru jibini Saduuqa, Saduuqa jibini Akiima, Akiima jibini Eliyuuda. ");
INSERT INTO fuf_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliyuuda jibini Eliyaasaru, Eliyaasaru jibini Mataana, Mataana jibini Yaaquuba. ");
INSERT INTO fuf_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yaaquuba jibini Yuusufu moodibbo Mariyama on, on jibinnooɗo Iisaa wi'aaɗo Almasiihu on. ");
INSERT INTO fuf_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Gila e Ibraahiima haa e Daawuuda, fow mun hawri jamaanuuji sappoo e nay. Gila e Daawuuda kadi haa e egginegol naɓee Baabiila hawri jamaanuuji sappoo e nay. Gila egginegol naɓee Baabiila kadi haa e Almasiihu on ko jamaanuuji sappoo e nay. ");
INSERT INTO fuf_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","E hino no Iisaa Almasiihu on jibiniraa. Tawi ko Yuusufu ƴami Mariyama yumma makko. Ado ɓe yiidude, tawi kanko jiwo on ko o sowiiɗo e dow bawgal *Ruuhu Seniiɗo on. ");
INSERT INTO fuf_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Tawi Yuusufu, on ƴamuɗo mo, ko gorko feewuɗo, hari o faalaaka mo wirtude, o miijii accitugol mo e nder gundoo. ");
INSERT INTO fuf_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Nde tawnoo himo miijii ɗun, malaa'ikaajo Joomiraaɗo on feeɲani mo e koyɗol, wi'i mo: «Yuusufu mo Daawuuda, wota a hulu ƴettugol Mariyama, o wona ɓeyngu maa, ko fii ɓiɗɗo mo o saawi on ko immorde e Ruuhu Seniiɗo on. ");
INSERT INTO fuf_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","O heɓoyay ɓiɗɗo, innoyaa mo Iisaa, ko fii ko kanko dandoyta jamaa makko on lette junuubaaji maɓɓe ɗin.» ");
INSERT INTO fuf_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ɗun fow waɗiri fii ko Joomiraaɗo on daalirnoo annabaajo on kon no laatora, wonde: ");
INSERT INTO fuf_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«Awa, jiwo mo andaali gorko on reeday, o firtoo boobo gorko, o innee Imanu'iila.» Ko woni firo ɗun ko: ‹Alla no wondi e men.› ");
INSERT INTO fuf_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ɓay kanko Yuusufu o finii, o waɗi ko malaa'ikaajo Joomiraaɗo on yamiri mo kon, o ƴetti ɓeyngu makko, o addi ka makko. ");
INSERT INTO fuf_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Kono laatii o yiidaali e debbo on haa nde o firtinoo on ɓiɗɗo gorko, o inni mo Iisaa. ");
INSERT INTO fuf_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ɓay wonii Iisaa jibinaama Bayti-Lahiimi, ɗun ko e nder diiwal *Yahuuda fewndo laamu *Heroodu, onsay gandiɗuɓe iwri funnaange ari *Yerusalaam, ");
INSERT INTO fuf_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ɓe wi'i: «Ko honto oo lanɗo *Yahuudiyankeeɓe arɗo e jibineede woni? Ko fii men yi'ii hoodere makko nden ka funnaange, men arii sujjangol mo.» ");
INSERT INTO fuf_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ɓay kanko Heroodu lanɗo on o nanii ɗun, o jiiɓii, o jiiɓodi e ɓe Yerusalaam ɓen fow. ");
INSERT INTO fuf_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Onsay o mottindiri hooreeɓe *yottinooɓe sadaka ɓen fow e jannooɓe fii Sariya on fii landagol ɓe ko honto *Almasiihu on haanaa jibinireede. ");
INSERT INTO fuf_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ɓen wi'i mo: «Ko Bayti-Lahiimi e nder ngal diiwal Yahuuda. Ko fii e hino ko annabaajo on windi kon: ");
INSERT INTO fuf_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‹Ko an yo koɗolun Bayti-Lahiimi, jeyaakun e nder leydi bolondaa Yahuuda, hinaa a gasoohun hayfineede e yeeso ɗiya koɗooli hittuɗi e nder Yahuuda. Ko fii lanɗo yaltay e maa ko ardoo jamaa an *Isra'iila on.› » ");
INSERT INTO fuf_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Onsay Heroodu noddi ɓen gandiɗuɓe e gundoo, o torii ɓe yo ɓe tentinan mo saa'i mo hoodere nden feeɲi e mun on. ");
INSERT INTO fuf_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Onsay o immini ɓe Bayti-Lahiimi, o wi'i ɓe: «Yahee humpitoyoɗon no laaɓiri fii kun paykun. Si on yi'oyii kun, humpiton mi min kadi, mi yaha mi sujjana kun.» ");
INSERT INTO fuf_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ɓay wonii ɓe nanii ko lanɗo on wi'i kon, ɓe yahi. Tawi hoodere nde ɓe yi'unoo ka funnaange nden no wontirde yeeso maɓɓe. Ɓay wonii nde hewtii fewndo ka paykun kun woni ɗon, nde darii. ");
INSERT INTO fuf_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ɓay kamɓe gandiɗuɓe ɓen ɓe yiitii hoodere nden, ɓe heewi weltaare. ");
INSERT INTO fuf_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Onsay ɓe naati ka suudu, ɓe yi'i paykun kun e yumma mun Mariyama, ɓe jiccii, ɓe sujjani kun. E hoore ɗun ɓe yaltini jawle maɓɓe, ɓe okkori kun kaŋŋe e urngallo no wi'ee libaana e *mirri. ");
INSERT INTO fuf_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Onsay Allaahu on andini ɓe e koyɗol wonde hita ɓe yiltito ka Heroodu. Ɓe rewti laawol goo, ɓe hooti ka leydi maɓɓe. ");
INSERT INTO fuf_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ɓay wonii ɓen gandiɗuɓe yahii, malaa'ikaajo Joomiraaɗo on feeɲani Yuusufu e koyɗol, o wi'i mo: «Immo, ƴettaa paykun kun e yumma mun, dogaa yahaa *Misira, wonaa ton haa nde mi wi'i yo a artu woo. Ko fii Heroodu ɗaɓɓitoyay paykun kun fii warugol kun.» ");
INSERT INTO fuf_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Yuusufu immii jemma, ƴetti paykun kun e yumma mun, yahi Misira. ");
INSERT INTO fuf_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","O woni ton haa Heroodu maayi. Ko nii ko Joomiraaɗo on daalirnoo annabaajo on kon laatori, wonde: «Mi noddii Ɓiɗɗo an on yo o yaltu Misira.» ");
INSERT INTO fuf_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ɓay Heroodu yi'ii wonde gandiɗuɓe ɓen janfike mo, o tikki. Onsay o yamiri yo ɓe waroy kala paykun gorun kun duuɓi ɗiɗi maa jaasukun ɗun wonkun e nder Bayti-Lahiimi e koɗoloy takkiikoy ɗon koy, ɗun yaadi e saa'i mo gandiɗuɓe ɓen feɲɲinannoo mo on. ");
INSERT INTO fuf_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ko nii ko daaliranoo annabi Yeremiiya kon laatori, wonde: ");
INSERT INTO fuf_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«Hito nanike ka wi'etee ɗon Raama: wullaandu e sowru tiiɗundu. Tawi ko Raahiilu woni wullude ɓiɓɓe mun ɓen, o jaɓaano yarlineede, ko fii ɓe woodaaka han kadi.» ");
INSERT INTO fuf_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ɓay wonii Heroodu maayii, malaa'ikaajo Joomiraaɗo on feeɲani Yuusufu e koyɗol Misira, ");
INSERT INTO fuf_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","o wi'i mo: «Immo, ƴettaa paykun kun e yumma mun, yiltitoɗaa leydi Isra'iila, ko fii faalanooɓe warude paykun kun ɓen maayii.» ");
INSERT INTO fuf_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Onsay Yuusufu ƴetti paykun kun e yumma mun, o yahi leydi Isra'iila. ");
INSERT INTO fuf_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Kono o nani wonde Arkalaawu laamike diiwal Yahuuda ngal lonto ben mun Heroodu, o huli wonoygol ton. Allaahu on ɓanginani mo e koyɗol, o yaari e ngal diiwal Jaliilu, ");
INSERT INTO fuf_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","o wonoyi e saare no wi'ee Naasirata, fii no ko daaliranoo annabaaɓe ɓen kon laatora, wonde: «O noddoyte Naasirayankoojo.» ");
INSERT INTO fuf_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ko e on saa'i ɗon, Yaayaa *lootoowo maande tuubuubuyee on feeɲi, tawi himo waajoo ka wulaa diiwal Yahuuda, ");
INSERT INTO fuf_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","himo wi'a: «Tuubee, ko fii laamu kammu ngun ɓadike!» ");
INSERT INTO fuf_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Tawi ko fii makko annabi *Isaaya wowlunoo, o wi'i: «Kaa hawa ko hawa ewnotooɗo ka wulaa, wi'a: ‹Moƴƴinee laawol Joomiraaɗo on, fewnon juri makko ɗin!› » ");
INSERT INTO fuf_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Tawi dolokke Yaayaa on ko leeɓi ngelooba, dattol keeci makko ɗin ko guri. Tawi ko kanu e njuuri buruure o ɲaamata. ");
INSERT INTO fuf_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Hoɗuɓe Yerusalaam ɓen e ɓe ka diiwal Yahuuda ɓen fow e koɗooli hunduɗi Yurdayniwol ɗin fow ari e makko. ");
INSERT INTO fuf_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ɓe qirritii junuubaaji maɓɓe ɗin, o looti ɓe maande tuubuubuyee ka maayo Yurdayniwol. ");
INSERT INTO fuf_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ɓay o yi'ii *Fariisiyaaɓe e *Sadduusiyaaɓe buy no arude fii *lootegol maande tuubuubuyee, o wi'i ɓe: «Ko onon yo iwdi kuura! Ko hombo tindini on dogugol tikkere aroyaynde nden? ");
INSERT INTO fuf_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Awa yo kuuɗe mon ɗen hollu wonde on tuubii. ");
INSERT INTO fuf_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Hara on hooloraali wi'ugol wonde ko Ibraahiima woni maama mon, ko fii mi andinii on, Alla no waawi wattude ɗee kaaƴe ɗoo ɓiɓɓe Ibraahiima. ");
INSERT INTO fuf_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Toode teenirde nden no waalii ka binde leɗɗe. Kala leggal ngal rimataa ɓiɓɓe moƴƴuɓe, ngal soppete, ngal bugee ka yiite! ");
INSERT INTO fuf_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","«Min ko ndiyan mi woni on lootirde maande tuubuubuyee. Kono on aroyoowo ɓaawo an no ɓuri lan doole, awa kadi mi hewtaa hay solugol paɗe makko ɗen. On non ko *Ruuhu Seniiɗo on e yiite o lootirta on. ");
INSERT INTO fuf_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Himo jogii feeteewo makko ngon ka jungo ko o hentinira bete makko on, o mooɓa ɲaametee on ka beembal makko, o sunnira foron on yiite nge ɗaanotaako.» ");
INSERT INTO fuf_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Onsay Iisaa iwri Jaliilu, o ari Yurdayniwol ka Yaayaa, fii yo on lootu mo. ");
INSERT INTO fuf_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Kono Yaayaa salii, wi'i: «Ko min haani arude yo a lootan! Kono an a arii yo mi loote!» ");
INSERT INTO fuf_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Kono Iisaa jaabii mo wi'i: «Accu wonira non, ko fii ko nii haanirani en timmingol peewal ngal fow.» Ko e hoore ɗun Yaayaa jaɓi mo lootude. ");
INSERT INTO fuf_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","No Iisaa gayniranoo looteede, o ƴawi ka ndiyan, tun kammu ngun udditii, o yi'i Ruuhu Allaahu on no tippora e makko wa gabooru. ");
INSERT INTO fuf_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Onsay hawa nanii ka kammu, no wi'a: «Ko oo woni Ɓiɗɗo an Yiɗaaɗo, mo mi weltori on!» ");
INSERT INTO fuf_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ɓawto ɗun, Ruuhu Allaahu on nawri Iisaa ka wulaa fii no Ibuliisa ndarndora mo. ");
INSERT INTO fuf_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","O hoori balɗe cappanɗe nay, jemma e ɲalorma. Ɓawto ɗun o weelaa. ");
INSERT INTO fuf_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ndarndotooɗo on ɓadii mo, wi'i: «Si tawii ko a *Ɓiɗɗo Alla, yamir ɗee kaaƴe yo ɗe wontu ɲaametee.» ");
INSERT INTO fuf_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Iisaa jaabii: «No windii wondema: ‹Neɗɗo hinaa ɲaametee tun wuurirta, kono ko kala konguɗi iwruɗi ka Alla.› » ");
INSERT INTO fuf_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ibuliisa nawri mo kadi ka saare hormorde, ɗun ko Yerusalaam, o joɗɗinoyi mo ka hoore warɲakere *juulirde mawnde, o wi'i mo: ");
INSERT INTO fuf_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","«Si tawii ko a Ɓiɗɗo Alla, hocco ɗon cikkoɗaa ka leydi, ko fii no windii wondema: ‹O yamiray malaa'ikaaɓe makko ɓen fii maa, ɓe tamboro-maa juuɗe maɓɓe ɗen, fii wota koyngal maa ngal feggo e hayre.› » ");
INSERT INTO fuf_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Iisaa jaabii mo wi'i: «No windii kadi wondema: ‹Wota a ndarndo Joomiraaɗo on, on Alla maa.› » ");
INSERT INTO fuf_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ibuliisa nawri mo kadi e fello toowungo fota, o holli mo laamateeriiji aduna on fow e darja mun. ");
INSERT INTO fuf_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","O wi'i mo: «Mi okkete ɗun fow si a jiccike, a sujjanii lan.» ");
INSERT INTO fuf_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Iisaa jaabii, wi'i: «Pottito, yo Ibuliisa, ko fii no windii: ‹Ko Alla Joomiraaɗo maa on sujjantaa, rewaa mo kanko tun.› » ");
INSERT INTO fuf_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Onsay Ibuliisa pottitii mo. Ɓawto ɗun malaa'ikaaɓe ɓadii Iisaa fii kurkanagol mo. ");
INSERT INTO fuf_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ɓay Iisaa andii Yaayaa wattaama e joge, o yahi Jaliilu. ");
INSERT INTO fuf_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","O eggi Naasirata, o yahi, o hoɗoyi Kafernahuum ka daande weendu ka kernidi ɗon e Zabuluunu e Naftali, ");
INSERT INTO fuf_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","fii no ko daaliranoo annabi Isaaya kon laatora, wonde: ");
INSERT INTO fuf_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«Ko an yo leydi Zabuluunu e Naftali leyɗe wonɗe ka daande weendu, gaɗa Yurdayniwol, ɗun ko Jaliilu ka ɗiya leƴƴi hoɗi e mun. ");
INSERT INTO fuf_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Oo jamaa wonɗo e nder niwre yi'ii ndaygu moolanaangu, e hoore ɓen jooɗiiɓe e ndin leydi ndi ɗowdi mayde woni e mun, ndaygu jalbanii ɓe.» ");
INSERT INTO fuf_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Gila ɗun Iisaa fuɗɗii waajaade, wi'a: «Tuubee, ko fii laamu kammu ngun ɓadike!» ");
INSERT INTO fuf_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","E nder ko o yiilotoo e daande *Weendu Jaliilu ndun kon, o yi'i musiɓɓe ɗiɗo no bugoo *jalaaji ka weendu, tawi ɓen ko yungooɓe: goɗɗo on no wi'ee Sim'uunu, mo o jammoyta Petruusu, oya on no wi'ee Andaraawu, miɲɲiraawo makko kanko Sim'uunu on. ");
INSERT INTO fuf_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","O wi'i ɓe: «Jokkee lan, mi wattay on yungooɓe yimɓe.» ");
INSERT INTO fuf_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ɗon kisan ɓe acciti jalaaji ɗin, ɓe jokki mo. ");
INSERT INTO fuf_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","E nder yaadu maɓɓe ndun, Iisaa yi'i musiɓɓe ɗiɗo goo kadi, tawi ɓen ko Yaaquuba e miɲan mun Yuuhanna, ɓen ko ɓiɓɓe Zabadii. Tawi ɓen no wondi e ben mun Zabadii ka nder laana, hiɓe moƴƴintina jalaaji maɓɓe. Kanko Iisaa o noddi ɓe. ");
INSERT INTO fuf_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ɗon kisan ɓe acci ɗon laana kan e ben maɓɓe, ɓe jokki mo. ");
INSERT INTO fuf_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Tawi Iisaa no yiiloo e nder Jaliilu fow, janna ka nder juulirɗe, waajoo fii Kibaaru Moƴƴo *laamu Alla ngun, e himo ɲawndora kala noone ɲabbeeli e nawnaaje yimɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Fii makko andii e nder Sirii on fow. O addanaa kala tampirɗo nawnaare e noonee muuseendiiji e ɓe jinna e iirotooɓe e maaya-ɓanduuɓe, o ndikkini ɓe. ");
INSERT INTO fuf_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Jamaa moolanaaɗo iwruɗo Jaliilu e *Dekapooli e Yerusalaam e diiwal Yahuuda ngal e ɓe gaɗa Yurdayniwol jokki mo. ");
INSERT INTO fuf_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ɓay Iisaa yi'ii jamaa on, o ƴawi ka fello, o jooɗii, taalibaaɓe makko ɓen kadi ɓadii mo. ");
INSERT INTO fuf_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Onsay o woni e jannugol jamaa on, wi'a: ");
INSERT INTO fuf_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«Yondiniiɓe ka ɓernde ɓen ko malaaɓe, ɓay laamu kammu ngun ko kamɓe wonani. ");
INSERT INTO fuf_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Yoomuɓe ɓen ko malaaɓe, ɓay ɓerɗe maɓɓe ɓuttinoyte. ");
INSERT INTO fuf_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Newiiɓe ɓen ko malaaɓe, ɓay ɓe ronoyay leydi ndin. ");
INSERT INTO fuf_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Weelaaɓe ɗonɗaa peewal ɓen ko malaaɓe, ɓay ɓe harnoyte. ");
INSERT INTO fuf_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Yurmeteeɓe ɓen ko malaaɓe, ɓay ɓe yurminoyte. ");
INSERT INTO fuf_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Laaɓa-ɓerndeeɓe ɓen ko malaaɓe, ɓay ɓe yi'oyay Alla. ");
INSERT INTO fuf_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ɓuttinooɓe ɓen ko malaaɓe, ɓay ɓe noddiroyte ɓiɓɓe Alla. ");
INSERT INTO fuf_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Cukketeeɓe sabu peewal ngal ko malaaɓe, ɓay laamu kammu ngun ko kamɓe wonani. ");
INSERT INTO fuf_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","«On wonay malaaɓe nde ɓe yenni on e nde ɓe cukkii on e nde ɓe fawi penaale e kala bone e hoore mon sabu an. ");
INSERT INTO fuf_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Weltee, wonon e nder welo-welo, ɓay hiɗon maranaa njoddi mawndi ka kammu, ko fii ko nii ɓe cukkornoo annabaaɓe adinooɓe on ɓen. ");
INSERT INTO fuf_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","«Ko onon woni lanɗan aduna on. Kono si dakamme majjan on iwii, haray ko honno dakamme majjan on wattirtee? Haray ɗan alaa nafa fus si hinaa bugegol ka yaasi, ɗan yaaɓee. ");
INSERT INTO fuf_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","«Ko onon woni ndaygu aduna on. Si saare wonii e hoore fello, haray nde waawetaake suuɗeede. ");
INSERT INTO fuf_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Hay gooto huɓɓintaa lampu, hippa mo e miran, kono o waɗay mo e kene, o ndayginana kala wonɗo ka nder suudu. ");
INSERT INTO fuf_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Yo ndaygu mon ngun jalbir nii yeeso yimɓe ɓen, fii no ɓe yi'ira kuuɗe mon moƴƴe ɗen, ɓe mawnina Ben mon Wonɗo ka kammu on.» ");
INSERT INTO fuf_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","«Wota on sikku ko mi arani ko fii firtugol Sariya on maa ko annabaaɓe ɓen wi'i kon. Min mi ardaali fii firtugol ɗi, kono ko fii laatingol ɗi. ");
INSERT INTO fuf_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ka haqiiqa mi andinii on, haa kammu ngun e leydi ndin muta, ko hay ciifun e toɓɓere iwataa e nder bindol Sariya on, haa fow laatoo. ");
INSERT INTO fuf_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Kala non bonnuɗo gootel e ɓurngel fanɗude e yamirooje ɗen, janni kadi yimɓe ɓen warrugol wano non, o innete ɓurɗo fanɗude e laamateeri kammu ngun. Kono kala ɗoftiiɗo janni, on innete tedduɗo e nder laamateeri kammu ngun. ");
INSERT INTO fuf_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Awa mi andinii on, si peewal mon ngal ɓuraali ngal jannooɓe fii Sariya on ɓen ngal e ngal *Fariisiyaaɓe ɓen ngal, on naatataa ka laamateeri kammu few. ");
INSERT INTO fuf_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","«On nanii wonde maamaaɓe men ɓen wi'ano: ‹Wota a ittu hoore, kala on ittuɗo hoore ɲaawete.› ");
INSERT INTO fuf_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Kono min mi wi'ay on, kala tikkanɗo musiɗɗo mun ɲaawete. Kala wi'uɗo musiɗɗo mun kadi ‹komoojo› ɲaawete yeeso dental fewjooɓe ɓen. Kala non wi'uɗo musiɗɗo mun ‹la'iifu› haray no e laawol yiite jahannama. ");
INSERT INTO fuf_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","«Si hiɗa sakkaade ka juulirde, a anditii ɗon wonde musiɗɗo maa no monoran-maa goɗɗun, ");
INSERT INTO fuf_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","haray accu ɗon ittugol sadaka maa on, yahaa taho moƴƴintinoyaa hakkunde maa e musiɗɗo maa on, si araa non ittaa sadaka maa on. ");
INSERT INTO fuf_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","«Eto no faamondiriraa e mo haɓiduɗaa on kisan fewndo wonuɗon ka ɗatal, fii wota on mo haɓiduɗaa watte e juuɗe ɲaawoowo on, on ɲaawoowo kadi watte e juuɗe suufaajo on, on waɗe ka kaso. ");
INSERT INTO fuf_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ko fii ka haqiiqa mi andinii ma, a yaltataa ɗon fannamaa a yoɓaali mbuuɗu sakkitoro on. ");
INSERT INTO fuf_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","«On nanii kadi wi'aama wonde: ‹wota a jeenu.› ");
INSERT INTO fuf_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Kono min mi wi'ay on, kala ndaaruɗo debbo fii himmangol mo, haray ontigi jeenii mo ka ɓernde mun. ");
INSERT INTO fuf_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Si tawii yiitere maa ɲaamere nden wonay sabu haa feggoɗaa, haray awu nde, bugoɗaa nde ka woɗɗiti-maa. Ko fii no ɓuru-maa moƴƴande ka teral maa gootal hayra, edii ka ɓandu maa ndun fow bugee ka jahannama. ");
INSERT INTO fuf_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Si tawii jungo maa ɲaamo ngon kadi wonay sabu haa feggoɗaa, haray taƴu ngo, bugoɗaa ka woɗɗiti-maa. Ko fii no ɓuru-maa moƴƴande ka teral maa gootal hayra edii ka ɓandu maa ndun fow yaha ka jahannama. ");
INSERT INTO fuf_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","«Wi'aama kadi, kala on accituɗo ɓeyngu mun haray yo o waɗan mo kaydi sertigal. ");
INSERT INTO fuf_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Kono min mi wi'ay on, kala on accituɗo ɓeyngu mun, si hinaa hara on jeenu, haray o waɗii mo jeenoowo. Kala non kadi ƴettuɗo debbo seedaaɗo haray onɗon kadi jeenii. ");
INSERT INTO fuf_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","«On nanii kadi wonde maamaaɓe men ɓen wi'ano: ‹Wota mo firta woondoore, hunnu woondooje ɗe woondanɗaa Joomiraaɗo on ɗen.› ");
INSERT INTO fuf_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Kono min mi wi'ay on, wota on woondu toode, wota on woondir kammu ngun, ko fii ko ngu jullere laamu Alla. ");
INSERT INTO fuf_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Wota on woondir kadi leydi ndin, ko fii ko ndi ndaɗɗudi tundaaje makko ɗen, maa woondiron Yerusalaam, ko fii ko saare Lanɗo Mawɗo on non. ");
INSERT INTO fuf_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Wota mo woondira hoore mun nden kadi, ko fii on waawaa rawninde maa ɓawlinde hay cukulol gootol. ");
INSERT INTO fuf_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Yo ‹hiiyii› mon on wonu ‹hiiyii›, ‹oo'o› mon on wona ‹oo'o.› Ko ɓeyditaa e ɗun woo, haray ko e Ibuliisa iwri. ");
INSERT INTO fuf_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","«On nanii kadi wi'aama wonde: ‹ko yiitere yoɓirtee yiitere, ɲiire yoɓiree ɲiire.› ");
INSERT INTO fuf_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Kono min mi wi'ay on, wota mo dartoo bonɗo, awa kadi mo bantike ma e waɓɓugo ɲaamo, tuɗan mo ngoya kadi. ");
INSERT INTO fuf_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","On mo faala-maa naɓude ka ɲaawoore fii ƴettugol ma fokiya on, accidu mo e waramba on kadi. ");
INSERT INTO fuf_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","On mo karhu-maa kadi rondanagol mo dongal, naɓaa yeru sagara gooto, naɓan mo yeru sagara ɗiɗi. ");
INSERT INTO fuf_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Okkor on toriiɗo ma, wota a huccu kadi on faalaaɗo ma ɲawlaade. ");
INSERT INTO fuf_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","«On nanii kadi wi'aama wonde: ‹Yo a yiɗu giɗo maa, aɲaa gaɲo maa.› ");
INSERT INTO fuf_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Kono min mi wi'ay on: yiɗee ayɓe mon ɓen, toranoɗon wonɓe cukkaade on ɓen, ");
INSERT INTO fuf_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ɗun on wonay ɓiɓɓe Ben mon Wonɗo ka kammu on. Ko fii himo fuɗinana bonɓe ɓen e moƴƴuɓe ɓen naange makko ngen, himo saaƴinana kadi feewuɓe ɓen e ɓe feewaa ɓen ndiyan ɗan. ");
INSERT INTO fuf_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Si tawii non ko yiɗuɓe on ɓen tun yiɗuɗon, haray ko mbarjaari hondi heɓoyton? E hinaa ƴantirooɓe sagalle janfa ɓen kadi ko non warrata? ");
INSERT INTO fuf_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Si tawii ko musiɓɓe mon ɓen tun hiwrotoɗon, haray ko honɗun waɗuɗon ko ɓeyditii? Hinaa ɓe gomɗinaa ɓen kadi ko non warrata? ");
INSERT INTO fuf_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Awa wonee timmuɓe wano Ben mon kammuyankeejo on woniri Timmuɗo non.» ");
INSERT INTO fuf_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","«Reenee e waɗirgol golle mon moƴƴe ɗen yiingo. Si hinaa ɗun on heɓataa njoddi ka Ben mon Wonɗo ka kammu on. ");
INSERT INTO fuf_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","«Nde hiɗon okkora miskinɓe ɓen, wota on wuttu *liite yeeso mon wano faasiqiiɓe ɓen gerdata non ka juulirɗe e ka ɗate fii no yimɓe ɓen mantira ɓe. Ko fii ka haqiiqa mi andinii on ɓe hendike mbarjaari maɓɓe ndin. ");
INSERT INTO fuf_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Nde hiɗon okkora miskinɓe ɓen, wota jungo mon nano ngon andu ko ɲaamo ngon waɗi kon, ");
INSERT INTO fuf_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","fii no dokkal mon ngal wonira e gundoo, ɗun Ben mon, on Yi'oowo ko yi'otaako, jonnitoyay on mbarjaari mon ndin. ");
INSERT INTO fuf_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","«Nde hiɗon juula kadi wota on wa'u wa faasiqiiɓe ɓen, ɓen yiɗuɓe juulugol hara no darii ka nder juulirɗe e ka sera ballaŋe fii hollitagol yimɓe ɓen. Ko fii, ka haqiiqa mi andinii on, ɓe hendike mbarjaari maɓɓe ndin. ");
INSERT INTO fuf_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Kono onon, nde hiɗon juula, naatee ka nder cuuɗi mon, ombon baafe mon ɗen, juulon e Ben mon mo yi'otaako on. Ɗun, Ben mon Yi'oowo ko yi'otaako kon, jonnitoyay on mbarjaari mon ndin. ");
INSERT INTO fuf_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","«Nde hiɗon juula, wota on fillifillinno haalaaji ɗuuɗuɗi wano ɓe wonaa Yahuudiyanke ɓen non, ko fii ɓen no sikka ko no ɓe ɗuɗɗiniri haalaaji woo ɓe jaɓirantee. ");
INSERT INTO fuf_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Wota on nandintino e maɓɓe, ko fii Ben mon no andi ko honɗun faalaɗon ado on toraade mo. ");
INSERT INTO fuf_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","«Ko nii haanuɗon tororde Alla: ‹Baaba amen Wonɗo ka kammu, yo innde maa nden hormore, ");
INSERT INTO fuf_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","yo laamu maa ngun feeɲu, yo faale maa on waɗu ka aduna wano woniri non ka kammuuli. ");
INSERT INTO fuf_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Okkor men hande ɲaametee haananɗo men on. ");
INSERT INTO fuf_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Yaafanoɗaa men bonnereeji amen ɗin, wano menen kadi men yaaforani bonnuɓe men ɓen non. ");
INSERT INTO fuf_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Wota a naadu men e jarrabuyee, kono jattin men Bonɗo on. Ko fii ko an heerori laamu e bawgal e mangu, haa poomaa. Aamiina.› ");
INSERT INTO fuf_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","«Si on yaafanike yimɓe ɓen bonnereeji maɓɓe ɗin, haray Baaba mon kammuyankeejo on yaafanto on onon kadi bonnereeji mon ɗin. ");
INSERT INTO fuf_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Kono si on yaafanaaki yimɓe ɓen, haray Ben mon kadi yaafantaako on bonnereeji mon ɗin. ");
INSERT INTO fuf_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","«Nde hiɗon hoora, wota on ɲirɓin geece mon ɗen wa faasiqiiɓe ɓen, ko fii kamɓe ɓe waylay geece maɓɓe ɗen fii hollugol yimɓe ɓen wonde hiɓe hoori. Ka haqiiqa mi andinii on, kamɓe ɓe hendike mbarjaari maɓɓe ndin. ");
INSERT INTO fuf_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Kono onon, nde hiɗon hoora, urnee ko'e mon ɗen, looton geece mon ɗen, ");
INSERT INTO fuf_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","fii wota on hollu yimɓe ɓen wonde hiɗon hoori, hara ko Ben mon mo yi'otaako on tun yi'i kon ko waɗuɗon e nder gundoo. Ɗun, Ben mon Yi'oowo ko yi'otaako on, jonnitay on mbarjaari mon ndin.» ");
INSERT INTO fuf_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«Wota on mooɓu jawle ka hoore leydi, ka ɗe bonirta wuɗugol e kornugol, e ka wuyɓe fusata ƴetta. ");
INSERT INTO fuf_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Kono mooɓee ɗe ka kammu ka ɗe wuɗataa e ka ɗe kornataa e ka wuyɓe fusataa ƴetta. ");
INSERT INTO fuf_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ko fii ko ka keyee mon on woni woo, ɓernde mon nden wonata. ");
INSERT INTO fuf_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","«Ko yiitere woni ndaygu ɓandu. Si tawii yiitere nden no selli, haray ɓandu ndun fow no ndaygi. ");
INSERT INTO fuf_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","On mo yiitere mun ɲawi, haray ɓandu ontigi ndun fow no e nder niwre. Si tawii non ngun ndaygu wongu e ontigi ko niwre, haray ko embere honto nden niwre mawni! ");
INSERT INTO fuf_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","«Hay gooto waawataa gollande jeyɓe ɗun ɗiɗo, ko si o aɲay oya, o yiɗa oya, maa o haɓɓoo e oya, o itta bote e oya. Ko ɗun waɗi si on waawataa rewude Alla rewon jawdi. ");
INSERT INTO fuf_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","«Ko ɗun waɗi si mi wi'ay on: wota on aanu fii ko ɲaamon maa ko yaron e nder ngurndan mon ɗan, maa fii ko ɓornon ɓalli mon ɗin. Taw si hinaa ngurndan ɓuri neema, awa kadi ɓandu ɓuri koltu? ");
INSERT INTO fuf_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ndaaree colli ɗin ka kammu: ɗi sankataa, ɗi wa'ataa, ɗi mooɓataa hay huunde e nder caagaaje, kono Ben mon Kammuyankeejo on no wurni ɗi. E taw si on ɓuraa ɗi hittude? ");
INSERT INTO fuf_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ko hombo e mon, e nder annde mun, waawata ɓeydude ngurndan mun ɗan beru sogonal gootal? ");
INSERT INTO fuf_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","«E ko honɗun aananton fii conci? Ndaaree no ɗii piindiiji ka gese fuɗirta njanɗa: hara-le ɗi gollataa, ɗi saɲɲataa. ");
INSERT INTO fuf_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Kono non mi andinii on, hay Sulaymaana e nder darja mun on fow holtiraali hay wa wootiri e majji. ");
INSERT INTO fuf_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Si tawii non Allaahu on no holtinirde non hay huɗo wonuko hande ka ngesa kon, bugoyteeko jango ka yiite kon, hara o ronkay waɗande on ko ɓuri ɗun, onon ɓee fanɗa-gomɗinalɓe? ");
INSERT INTO fuf_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Awa wota on aanu haa wi'on: ‹ko honɗun men ɲaamata?› maa: ‹ko honɗun men yarata?› maa: ‹ko honɗun men ɓornotoo?› ");
INSERT INTO fuf_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ɗun, ko ɓe gomɗinaa ɓen ɗaɓɓata ɗun. Kono Ben mon Kammuyankeejo on no andi hiɗon handi e ɗun. ");
INSERT INTO fuf_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Kono ɗaɓɓee taho laamu makko ngun e peewal makko ngal, ɗin piiji fow ɓeydanoyte on. ");
INSERT INTO fuf_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Awa wota on aanu fii jango, ko fii jango aananay hoore mun. Ɲalaande bee arday e maapunde mun.» ");
INSERT INTO fuf_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","«Wota on ɲaawu fii wota on ɲaawe. ");
INSERT INTO fuf_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ko fii, ko wano ɲaawirɗon non ɲaawirteɗon, e ko sariyaare nde etirɗon nden etiranteɗon. ");
INSERT INTO fuf_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","«Ko honno yiirataa lojol wongol ka yiitere musiɗɗo maa on, hara a yi'aali falimawal wongal ka yiitere maa ngal? ");
INSERT INTO fuf_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ko honno wawrataa wi'ude musiɗɗo maa on: ‹Accu mi ittane lojol ngol ka yiitere maa›, e hara falimawal no ka yiitere maa an? ");
INSERT INTO fuf_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ko an yo faasiqiijo, ittu taho falimawal wongal ka yiitere maa ngal, onsay non a yi'ay no ittiranaa musiɗɗo maa on lojol wongol ka yiitere makko ngol. ");
INSERT INTO fuf_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","«Wota on ƴettu ko hormortee kon, jonnon bareeji ɗin, fii wota ɗi yiltito ɗi ƴakka on. Wota on bugo kadi koɗe mon lambiri ɗen yeeso koseeji ɗin, sakko ɗi yaaɓa ɗe. ");
INSERT INTO fuf_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","«Toree, on okkorte. Ɗaɓɓee, on heɓay. Hoɗɗee, on udditante. ");
INSERT INTO fuf_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ko fii kala toriiɗo okkorte, kala ɗaɓɓuɗo heɓay, awa kadi kala on hoɗɗiiɗo udditante. ");
INSERT INTO fuf_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","«Ko hombo e mon, ɓiɗɗo mun torotoo ɗun bireedi, ontigi jonna mo hayre? ");
INSERT INTO fuf_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Maa o toroo mo lingii, ontigi jonna mo mboddi? ");
INSERT INTO fuf_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Si tawii non hay onon bonɓe ɓen hiɗon waawi waɗande ɓiɓɓe mon ɓen piiji moƴƴi, haray ko haa honto Ben mon Wonɗo ka kammu on okkorta ɓen toriiɓe mo moƴƴereeji! ");
INSERT INTO fuf_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Waɗanee yimɓe ɓen wano faaliraɗon yo ɓe waɗan on non. Ko fii ko ɗun Sariya on e annabaaɓe ɓen wi'i.» ");
INSERT INTO fuf_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","«Naatiree ka dambugal faaɗungal. Ko fii dambugal nawrayngal e hayrannde ngal ko yaajungal. Ɗatal nawrayngal e hayrannde ngal kadi ko weeɓungal, awa-le ɗuuɗuɓe naatiray ɗon. ");
INSERT INTO fuf_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Kono dambugal nawrayngal e ngurndan ngal e ɗatal nawrayngal e ngurndan ngal ko faaɗuɗe, kono ko seeɗaaɓe heɓata ɗen.» ");
INSERT INTO fuf_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","«Awa reenee e waɗitiiɓe annaba ɓen, ko fii ɓe arday e mon wa baali, kono hara ka nder ko ɓe caapaali hunƴuɗi. ");
INSERT INTO fuf_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ko kuuɗe maɓɓe ɗen anditirton ɓe. E hara en ittay sungala e hoore bulle-koɲon, maa ƴibbe e hoore bulle-baali? ");
INSERT INTO fuf_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Kala leggal moƴƴal ko ɓiɓɓe moƴƴuɓe rimata, kono leggal bongal ko ɓiɓɓe bonɓe rimata. ");
INSERT INTO fuf_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Leggal moƴƴal waawataa rimude ɓiɓɓe ɓonɓe, leggal bongal kadi waawataa rimude ɓiɓɓe moƴƴuɓe. ");
INSERT INTO fuf_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kala leggal ngal rimataa ɓiɓɓe moƴƴuɓe ko soppeteengal bugee ka yiite. ");
INSERT INTO fuf_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Awa ko kuuɗe maɓɓe ɗen anditirton ɓe. ");
INSERT INTO fuf_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","«Hinaa wi'ooɓe lan ‹Koohoojo, Koohoojo› ɓen fow naatata ka laamateeri kammu, kono ko waɗayɓe ko Baaba an Wonɗo ka kammu on faalaa kon tun. ");
INSERT INTO fuf_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Nden ɲande, buy wi'oyay lan: ‹Koohoojo, Koohoojo! Taw si hinaa e innde maa men haaliraynoo ko Alla longini men, men raɗora kadi jinnaaji e innde maa, men waɗa kadi kaawakeeji moƴƴi buy e innde maa?› ");
INSERT INTO fuf_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Onsay mi wi'oyay ɓe: ‹Mi andaano on few. Pottitee lan, yo onon waɗooɓe ko boni!› ");
INSERT INTO fuf_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","«Awa kala nanuɗo ɗii konguɗi an, huutori ɗi, wa'ay wa faamuɗo, darnuɗo suudu mun e hoore fetere. ");
INSERT INTO fuf_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ndiyan ɗan saaƴi, waameeji ɗin ari, keneeli ɗin wifi, ɗin piyii e ndun suudu, ndu ronka yanude, ko fii hari ko e fetere ndu darii. ");
INSERT INTO fuf_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Kono kala nanuɗo konguɗi an ɗin, huutoraali ɗi, on no wa'i wa njofoojo darnuɗo suudu mun e hoore njaare. ");
INSERT INTO fuf_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ndiyan ɗan saaƴi, waameeji ɗin ari, keneeli ɗin wifi, ɗin piyii e ndun suudu, ndu yani, yanal tiiɗungal.» ");
INSERT INTO fuf_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ɓay wonii Iisaa timminii yewtere mun nden, jamaa on ŋalɗi fii ko o jannaynoo kon, ");
INSERT INTO fuf_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ko fii hari himo jannirde ɓe bawgal, hara wonaa wano jannooɓe fii Sariya on ɓen janniraynoo non. ");
INSERT INTO fuf_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ɓay wonii Iisaa tippike ka fello, jamaa moolanaaɗo jokki mo. ");
INSERT INTO fuf_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Onsay mo ɗamajan ari jiccii yeeso makko, wi'i: «Koohoojo, si hiɗon faalaa, hiɗon waawi lan sellinde, mi laaɓa.» ");
INSERT INTO fuf_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Iisaa fonti jungo mun ngon, meemi mo, wi'i: «Miɗo faalaa, laato selluɗo, laaɓaa.» Ɗon kisan o selli ɗamajan ɗan, o laaɓi. ");
INSERT INTO fuf_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","E hoore ɗun Iisaa wi'i mo: «Reeno wota a wowlan ɗun hay gooto, kono yahu hollitoyoɗaa *yottinoowo sadaka on, ittaa sadaka wano Muusaa yamiri non, fii yo ɗun wonan ɓe seedee.» ");
INSERT INTO fuf_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ɓay wonii Iisaa naatii Kafernahuum, hooreejo suufaaɓe teemedere ɓadii mo, jeeji, ");
INSERT INTO fuf_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","wi'i: «Koohoojo, kurkaadu an ndun no waalii ka suudu, ɓandu makko ndun no maayi, awa kadi himo tampi fota.» ");
INSERT INTO fuf_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Iisaa wi'i mo: «Mi yahay, mi sellina mo.» ");
INSERT INTO fuf_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Onsay kanko hooreejo suufaaɓe ɓen o jaabii mo, o wi'i: «Koohoojo, mi foddaa e mo'on ka suudu an. Kono maakee tun kongol gootol, kurkaadu an ndun ndikkay. ");
INSERT INTO fuf_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ko fii min tigi, ko mi wonɗo e ley kongol hooreeɓe goo, min kadi miɗo mari suufaaɓe wonɓe e ley kongol an. Si mi wi'ii goɗɗo e ɓen ‹yahu›, o yahay. Si mi wi'ii oya on ‹aru›, o aray. Awa kadi si mi wi'ii kurkaadu an ndun ‹waɗu ɗun›, ndu waɗay.» ");
INSERT INTO fuf_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ɓay Iisaa nanii ɗun, o ŋalɗi, o wi'i jokkuɓe mo ɓen: «Ka haqiiqa mi andinii on, hay ka *Isra'iila'en mi yi'aali neɗɗo gomɗinirɗo wa oo. ");
INSERT INTO fuf_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Mi andinii on, ɗuuɗuɓe iwroyay funnaange e hirnaange, ɓe nafodoya e Ibraahiima e Issaaqa e Yaaquuba ka laamateeri kammu. ");
INSERT INTO fuf_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Kono haanunooɓe ronude laamateeri ndin ɓen bugete ka niwre ka ɓuri woɗɗude, ka wullaandu e ŋatindiro ɲiiƴe woni ton.» ");
INSERT INTO fuf_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Onsay Iisaa wi'i on hooreejo suufaaɓe ɓen: «Yahu, yo ɗun wonirane wano gomɗinirɗaa non.» E on saa'i tigi kurkaadu ndun sellinaa. ");
INSERT INTO fuf_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ɓawto ɗun Iisaa yahi ka galle Petruusu, o tawi esiraawo Petruusu suddiiɗo on no waalii nawnaare nguli-ɓandu. ");
INSERT INTO fuf_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","O meemi jungo on ngon, nguli-ɓandu kin yalti e makko. Onsay on immii, o woni e kurkanagol Iisaa. ");
INSERT INTO fuf_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ɓay niɓɓii, ɓe addani mo ɗuuɗuɓe ɓe jinna nangi, o raɗori ɗin jinnaaji kongol makko ngol, o sellini nawnuɓe ɓen fow. ");
INSERT INTO fuf_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ko nii ko daaliranoo annabi Isaaya kon laatori, wonde: «O ƴettii nawnaaje men ɗen, o fawtike ɲabbeeli men ɗin.» ");
INSERT INTO fuf_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ɓay Iisaa yi'ii jamaa hunduɗo mo on, o yamiri taalibaaɓe makko ɓen yo ɓe lumbitu gaɗa. ");
INSERT INTO fuf_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Jannoowo fii Sariya on goo ɓadii mo, wi'i: «Karamoko'en, mi jokkete kala ka yaaruɗaa.» ");
INSERT INTO fuf_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Iisaa jaabii mo wi'i: «Ndoni ɗin no mari gayɗe mun, awa kadi colli ɗin ka weeyo no mari ɲakkaaji mun, kono *Ɓii-Aaden on kan alaa hay ka fowtina hoore mun nden.» ");
INSERT INTO fuf_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Goɗɗo e taalibaaɓe ɓen wi'i mo: «Koohoojo, newnanee lan taho mi yaha, mi wattinoya ben an en.» ");
INSERT INTO fuf_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Kono Iisaa jaabii mo, wi'i: «Jokkan, accaa mayɓe ɓen wattina mayɓe mun ɓen.» ");
INSERT INTO fuf_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ɓawto ɗun Iisaa bakii ka laana, taalibaaɓe makko ɓen kadi jokki mo. ");
INSERT INTO fuf_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Onsay waabiliire tiiɗunde wondunde e hendu tippii ka weendu haa morlooɗe ndiyan ɗen watti diwude laana kan, tawi kanko himo ɗaanii. ");
INSERT INTO fuf_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ɓe ari, ɓe findini mo, ɓe wi'i: «Koohoojo, dandu en, en mulay woni!» ");
INSERT INTO fuf_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","O wi'i ɓe: «Ko fii honɗun hulanɗon, onon ɓee fanɗa-gomɗinalɓe?» Onsay o immii, o toŋani hendu ndun e morlooɗe ndiyan ɗen, deeƴaango tiiɗungo waɗi. ");
INSERT INTO fuf_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ɓen ŋalɗi fota, ɓe wi'indiri: «Ko hombo woni oo? Ko fii hay keneeli ɗin e baharu on ɗoftoto mo!» ");
INSERT INTO fuf_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ɓay wonii o hewtoyii gaɗa weendu ndun, ɗun ko e ndii leydi ɓee Gadariyankooɓe, jinnaaɓe ɗiɗo sortii ka berɗe, ari fottugol e makko. Tawi hakkee ko ɓen hulɓinii, hay gooto suusataano rewude ɗon. ");
INSERT INTO fuf_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ɓen sonki e makko, ɓe wi'i: «Ko honɗun faalanaɗaa men, an oo *Ɓiɗɗo Alla. E hara ko arduɗaa ɗoo ko fii lettugol men hara saa'i on hewtaali?» ");
INSERT INTO fuf_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Tawi wuro kose moolanaango no ooraynoo ka woɗɗitii ɓe. ");
INSERT INTO fuf_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Onsay jinnaaji ɗin jeeji mo, ɗi wi'i: «Si a raɗoto men, nawru men e ngoo wuro kose.» ");
INSERT INTO fuf_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","O wi'i ɗi: «Yahee!» Onsay ɗi yalti e ɓen, ɗi naatoyi e nder ɗin koseeji. Tun, koseeji ɗin fow giddi ka falo, ɗi unoyii ka weendu, ɗi muli ka nder ndiyan. ");
INSERT INTO fuf_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ornaynooɓe ɗi ɓen dogi, yahi ka saare, fillitoyii ko waɗi kon fow, tentinii ko heɓi ɓen jinnanooɓe kon. ");
INSERT INTO fuf_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Onsay yimɓe saare nden fow yalti fii fottugol e Iisaa. Nde ɓe yiirunoo mo, ɓe jeeji mo woɗɗitagol leydi maɓɓe ndin. ");
INSERT INTO fuf_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ɓawto ɗun Iisaa bakii ɗon e laana, o lumboyi weendu ndun, o yahi ka saare makko. ");
INSERT INTO fuf_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ɓe addani mo maaya-ɓanduujo waaliiɗo e ɓoggi-dimborɗi. Ɓay Iisaa yi'ii gomɗinal maɓɓe ngal, o wi'i maaya-ɓanduujo on: «Wakkilo yo boobo an. Junuubaaji maa ɗin yaafaama.» ");
INSERT INTO fuf_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Onsay woɓɓe e jannooɓe fii Sariya on wi'indiri: «Oo neɗɗo no hoynude Alla!» ");
INSERT INTO fuf_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Nde tawnoo Iisaa no andi miijooji maɓɓe ɗin, o wi'i ɓe: «Ko honɗun joganiɗon ɗii miijooji bonɗi ka ɓerɗe mon? ");
INSERT INTO fuf_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Enee, hakkunde wi'ugol ‹junuubaaji maa ɗin yaafaama› e ‹immo yahaa›, ko honɗun e ɗii ɗoo ɓuri weeɓude? ");
INSERT INTO fuf_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Fii no andiron wonde *Ɓii-Aaden on no mari bawgal ka aduna ɗoo fii yaafagol junuubaaji», o wi'i jukkuɗo on: «Immo ƴettaa ɓoggi-dimborɗi maa ɗin, hootaa ka maa.» ");
INSERT INTO fuf_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","On immii, o hooti ka makko. ");
INSERT INTO fuf_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ɓay jamaa on yi'ii ɗun, ɓe huli, ɓe mawnini Alla, on yeɗuɗo yimɓe ɓen sifa ngal bawgal. ");
INSERT INTO fuf_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Wa ko Iisaa iwata ɗon, o yi'i goɗɗo no wi'ee Matta no jooɗii ka ƴantirde sagalle. O wi'i mo: «Aru, jokkaa mi!» Kanko Matta o immii, o jokki mo. ");
INSERT INTO fuf_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ɓawto ɗun, Iisaa jooɗii fii ɲaamugol ka suudu Matta, tawi *ƴantooɓe sagalle e junuubankeeɓe ɗuuɗuɓe no jooɗodi e makko, wondude e taalibaaɓe makko ɓen. ");
INSERT INTO fuf_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ɓay *Fariisiyaaɓe ɓen yi'ii ɗun, ɓe wi'i taalibaaɓe makko ɓen: «E ko fii honɗun karamoko mon ɲaamidanta e ƴantooɓe sagalle ɓen e junuubanke'en?» ");
INSERT INTO fuf_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ɓay wonii Iisaa nanii ɗun, o wi'i: «Hinaa selluɓe ɓen hatonjini e ɲawndoowo, kono ko ɲawɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Allaahu non no daali: ‹Ko yurmeende mi faalaa, wonaa sadaka.› Awa, yahee andinoyoɗon ko woni firo ɗun. Ko fii min, wonaa noddugol feewuɓe ɓen mi arani, kono ko junuubankeeɓe ɓen.» ");
INSERT INTO fuf_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Onsay taalibaaɓe Yaayaa ɓen ari e Iisaa, ɓe wi'i mo: «Ko fii honɗun menen e Fariisiyaaɓe ɓen men hooranta, hara taalibaaɓe maa ɓen kan alaa hoorude?» ");
INSERT INTO fuf_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Iisaa jaabii ɓe wi'i: «Taw si njaatigiiɓe jom jomba no haani yoomude yeru hiɓe wondi e jom jomba? Ɲalaaɗe aroyay nde jom jomba pottinaa e hakkunde maɓɓe, onsay ɓe hooray. ");
INSERT INTO fuf_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Hay gooto ƴettataa ceelol bagi keso, walkira dolokke kiɗɗo. Ko fii ceelol ngol pooɗay dolokke on, haa wuddere nden ɓurta yaajude. ");
INSERT INTO fuf_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Njaram kesan men loowetaake e nder bootooji guri kiɗɗi. Si hinaa ɗun, guri ɗin seekoto, njaram ɗan hibba, bootooji guri ɗin kadi bona. Kono njaram kesan ko e nder bootooji guri kesi loowetee, ɗi fow ɗi maroda.» ");
INSERT INTO fuf_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Wa fewndo ko Iisaa yewtata ɓe ɗii konguɗi, hooreejo goo hewti, jiccii yeeso makko, wi'i: «Jiwo an on maayii jooni jooni! Kono aree *fawon juuɗe mon ɗen e hoore makko, o wuuritay.» ");
INSERT INTO fuf_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Iisaa e taalibaaɓe mun ɓen immii jokki mo. ");
INSERT INTO fuf_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Onsay debbo wonnooɗo soncaade gila duuɓi sappoo e ɗiɗi ari wontiri ɓaawo Iisaa, o meemi kombol dolokke makko on. ");
INSERT INTO fuf_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ko fii hari on debbo no miijoo wonde: «Si mi waawii tun meemude dolokke makko on, mi ndikkay.» ");
INSERT INTO fuf_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Onsay Iisaa yeƴƴitii. Ɓay o yi'ii mo, o wi'i: «Wakkilo, yo jiwo an! Gomɗinal maa ngal sellinii ma.» On debbo selli e on saa'i tigi. ");
INSERT INTO fuf_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ɓay Iisaa hewtii ka suudu on hooreejo, o yi'ii ko wuttooɓe ceri ɓen e jamaa on woni e nder jiiɓoldu kon, ");
INSERT INTO fuf_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","o wi'i ɓe: «Pottitee, jiwo on maayaali, o ɗaani.» Ɓe jali mo. ");
INSERT INTO fuf_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ɓay wonii jamaa on yaltinaama, onsay o naati, o nangi jungo jiwo on, jiwo on immii. ");
INSERT INTO fuf_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Fii ɗun andii e leydi ndin fow. ");
INSERT INTO fuf_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Wa ko Iisaa iwata ɗon, bumɓe ɗiɗo jokki mo, no ewnoo wi'a: «Yurminee men, yo ɓii Daawuuda!» ");
INSERT INTO fuf_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ɓay o hewtii ka suudu, bumɓe ɓen ɓadii mo. Iisaa wi'i ɓe: «Hiɗon sikka miɗo waawi waɗude ɗun?» Ɓe jaabii mo: «Hiiyii, yaa an Koohoojo.» ");
INSERT INTO fuf_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Onsay o meemi ɓe gite ɗen, o wi'i: «Yo ɗun woniran on wano gomɗinirɗon non.» ");
INSERT INTO fuf_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Gite maɓɓe ɗen wunti. Iisaa yamiri ɓe ɗunɗoo, o sattini, o wi'i: «Reenee wota gooto andu.» ");
INSERT INTO fuf_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Kono nde ɓe yaltirnoo, ɓe nangi e fillagol e nder leydi ndin fow ko Iisaa waɗani ɓe kon. ");
INSERT INTO fuf_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Wa ko Iisaa e taalibaaɓe mun ɓen fokkitata, ɓe addani mo mboboojo mo jinna nangi. ");
INSERT INTO fuf_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ɓay wonii jinnawii ngin raɗaama, mboboojo on wowli. E nder ko jamaa on ŋalɗi kon, ɓe wi'i: «Haa hande sifa ɗun yi'aaka e leydi Isra'iila ndin!» ");
INSERT INTO fuf_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Kono Fariisiyaaɓe ɓen kaɲun wi'i: «Ko tippude e lanɗo jinnaaji ɗin o woni raɗorde jinnaaji ɗin.» ");
INSERT INTO fuf_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Tawi Iisaa no yiilotonoo e ca'e ɗen fow e koɗooli ɗin, janna ka nder juulirɗe maɓɓe, waajoo fii Kibaaru Moƴƴo *laamu Alla ngun, ɲawnda kadi kala nawnaaje e ɲabbeeli. ");
INSERT INTO fuf_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ɓay o yi'ii jamaa on, o yurmaa, ko fii hari hiɓe aybi, hiɓe ŋakkiraa ballo wa baali ɗi alaa ngaynaako. ");
INSERT INTO fuf_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Onsay o wi'i taalibaaɓe makko ɓen: «Baagol ngol no ɗuuɗi, kono wa'ooɓe ɓen ɗuuɗaa. ");
INSERT INTO fuf_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Awa jooni, toree non Jom baagol ngol yo o addu wa'ooɓe ka baagol makko.» ");
INSERT INTO fuf_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ɓawto ɗun, Iisaa noddi *sahaabaaɓe makko ɓen sappoo e ɗiɗo, o okki ɓe bawgal raɗagol jinnaaji ɗin e sellingol kala ɲaw e kala nawnaare. ");
INSERT INTO fuf_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","E hino inɗe ɓen sahaabaaɓe sappoo e ɗiɗo: arano on e maɓɓe ko Sim'uunu, jammaaɗo on Petruusu, e Andaraawu neene-gooto makko on, e Yaaquuba mo Zabadii, e Yuuhanna neene-gooto on on, ");
INSERT INTO fuf_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","e Filiipu e Bartolomaawu e Tooma e Matta, ƴantaynooɗo sagalle on, e Yaaquuba mo Alfaa, e Taddaawu, ");
INSERT INTO fuf_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","e Sim'uunu tawdaaɗo e fedde *Zelotiiɓe ɓen, e Yudaasi Iskariiyu, janfoytooɗo mo on. ");
INSERT INTO fuf_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ko ɓee sappoo e ɗiɗooɓe ɗoo Iisaa immini ɓawto o yamirde ɓe ɗunɗoo: «Wota on yaaru ka ɓe wonaa Yahuudiyanke ɓen e wota on naatu ka ca'e Samariyankeeɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Kono yaaree ka baali suudu *Isra'iila majjuɗi ɗin. ");
INSERT INTO fuf_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","E nder yaadu mon ndun, waajoɗon wonde laamu kammu ngun ɓadike. ");
INSERT INTO fuf_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ɲawndon ɲawɓe ɓen, immintinon mayɓe ɓen, sellinon ɓe ɗamajan ɓen, ɓe laaɓa, raɗoɗon jinnaaji ɗin. On hendike ɗun e hoore on ittaa hay huunde, onon kadi okkee ɗun, hara on ittinaali hay huunde. ");
INSERT INTO fuf_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Wota on datto kaŋŋe maa kaalisi maa sila, yooɓoɗon, ");
INSERT INTO fuf_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","maa bonfo fii yaadu ndun, maa dolokkaaji ɗiɗi, maa paɗe, maa tuggordu. Ko fii golloowo no handi e ɲaametee mun. ");
INSERT INTO fuf_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","«Kala saare maa hoɗo ka naatuɗon, andee si tawii no woodi ɗon goɗɗo hebuliiɗo jaɓugol on, haray weeree ka makko haa nde hiɗon yaha. ");
INSERT INTO fuf_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Nde hiɗon naata e suudu, salminee. ");
INSERT INTO fuf_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Si yimɓe ndun suudu jaɓii on, haray yo ɓuttu mon on wonu e maɓɓe, kono si tawii ɓe jaɓaali on, haray yo ɓuttu mon on artan on. ");
INSERT INTO fuf_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Si tawii non on jaɓaaka, maa konguɗi mon ɗin heɗaaka, haray yaltee e ndun suudu maa e nden saare, honkon mbullaari teppe mon ɗen. ");
INSERT INTO fuf_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ka haqiiqa mi andinii on, ɲande ɲaawoore nden ko ɗee ca'e Saduuma e *Amuura ɓuretee hoynaneede edii nden saare ɗon. ");
INSERT INTO fuf_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","«Jooni miɗo imminirde on wa baali e hakkunde caapaali, awa reenoree wa mboddi, neworon wa gabooji. ");
INSERT INTO fuf_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Reenoɗon e yimɓe ɓen, ko fii ɓe naɓoyay on ka ɲaawirɗi, ɓe foccoya on ka juulirɗe maɓɓe. ");
INSERT INTO fuf_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","On naɓete ka yeesooɓe ɓen e ka lamɓe ɓen sabu an, seeditoɗon fii an yeeso maɓɓe, kamɓe e ɓe wonaa Yahuudiyanke ɓen. ");
INSERT INTO fuf_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","«Kono tuma ɓe watti on e joge, wota on jiɓoyo ko honno haalirton maa ko wi'on. Ko fii ko wowloyton kon longinte on e on saa'i tigi. ");
INSERT INTO fuf_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ko fii wonaa onon yewtoyta, kono ko Ruuhu Ben mon on yewtiroyta on. ");
INSERT INTO fuf_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ko fii goɗɗo ƴettoyay musiɗɗo mun, watta mo e joge fii yo o ware, baabaajo kadi warra non ɓiɗɗo mun. Fayɓe ɓen kadi hawtanoyoo mawɓe mun ɓen, ɓe wona sabu haa ɓe waree. ");
INSERT INTO fuf_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Fow aɲoyay on sabu innde an nden. Kono mo ŋaɲɲike ɗun haa ka lannoode, o dandoyte. ");
INSERT INTO fuf_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Kono si on cukkaama e ndee saare ɗoo, dogee yaaron e wonnde goo. Ko fii ka haqiiqa mi andinii on, on waawataa yahude e ca'e Isra'iilayanke ɗen fow ado *Ɓii-Aaden on arude. ");
INSERT INTO fuf_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","«Awa taalibaajo ɓuraa karamoko mun, wano non kadi kurkaadu ɓuraa jeyɗo ɗun. ");
INSERT INTO fuf_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Yonanii taalibaajo ka o wa'a wa karamoko makko, kurkaadu ndun kadi wa'a wa jom mun. Si ɓe jammii non jom suudu ndun *Balzabuula, haray ko haa honto non ɓe jammata yimɓe suudu makko ndun! ");
INSERT INTO fuf_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Awa wota on hulu ɓe few, ko fii alaa ko suuɗii ko feeɲataa, awa kadi alaa gundoo mo andotaako. ");
INSERT INTO fuf_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ko mi wowlani on kon ka niwre, feɲɲinee ɗun tumbere ɲalorma. Ko sowndaɗon kon kadi, ewnee ɗun ka warɲakke. ");
INSERT INTO fuf_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Awa wota on hulu warooɓe ɓandu ɓen, hara waawataa warude wonkii. Kono hulee waawuɗo mulude wonkii e ɓandu on ka jahannama. ");
INSERT INTO fuf_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Hinaa seresereeji ɗiɗi no yeeyee tammaaru wooturu? Kono hay wooturu yanataa e leydi e ɓaawo muyɗe Ben mon. ");
INSERT INTO fuf_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Onon e hoore mon, hay cukuli ko'e mon ɗen fow no limaa. ");
INSERT INTO fuf_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Awa, wota on hulu, ko fii hiɗon ɓuri seresereeji buy hittude ka Alla. ");
INSERT INTO fuf_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","«Ko ɗun waɗi, kala qirritiiɗo fii an yeeso yimɓe ɓen, min kadi mi qirritoyto fii makko yeeso Ben an Wonɗo ka kammu on. ");
INSERT INTO fuf_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Kono kala yedduɗo fii an yeeso yimɓe ɓen, min kadi mi yeddoyay fii makko yeeso Ben an Wonɗo ka kammu on. ");
INSERT INTO fuf_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","«Wota on sikku ko addugol ɓuttu e oo aduna mi arani. Wonaa ɓuttu mi addi, kono ko kaafa. ");
INSERT INTO fuf_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ko mi arani ko liddondiral: gorko e ben mun liddondira, jiwo e yumma mun liddondira, jiwo e esiraawo mun debbo liddondira. ");
INSERT INTO fuf_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Yimɓe suudu ontigi ndun wona ayɓe makko. ");
INSERT INTO fuf_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","«Kala yiɗuɗo ben mun maa yumma mun ɓuri lan min, haray ontigi foddaa e an. Kala yiɗuɗo kadi ɓiɗɗo mun gorko maa ɓiɗɗo mun jiwo ɓuri lan, haray ontigi foddaa e an. ");
INSERT INTO fuf_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Kala mo ƴettaali leggal mun altindiraangal* ngal, jokkimmi, haray ontigi foddaa e an. ");
INSERT INTO fuf_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Kala faalaaɗo dandude ngurndan mun ɗan, ɗan hayriray mo, kala non mo ngurndan mun ɗan hayriraa sabu an min, o hettoyay ɗan. ");
INSERT INTO fuf_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","«Kala jaɓuɗo on haray jaɓii lan, kala non jaɓuɗo lan haray o jaɓii Nuluɗo lan on. ");
INSERT INTO fuf_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Kala jaɓuɗo annabaajo sabu on ko annabaajo, o heɓay mbarjaari annabaajo. Kala jaɓuɗo feewuɗo sabu on ko feewuɗo, o heɓay mbarjaari feewuɗo. ");
INSERT INTO fuf_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ka haqiiqa mi andinii on, kala okkorɗo goɗɗo e koy taalibahoy an ndiyan ɓuuɓuɗan, sabu kun ko taalibahun an, o faɗataa mbarjaari makko ndin few.» ");
INSERT INTO fuf_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ɓay wonii Iisaa gaynii yamirde *sahaabaaɓe makko ɓen sappoo e ɗiɗo, o iwi ɗon, o yahi e ca'e diiwal ngal fii jannugol waajoo. ");
INSERT INTO fuf_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Fewndo Yaayaa woni ka nder kaso, o nani fii kuuɗe *Almasiihu on no wowlee. Onsay o immini taalibaaɓe makko ɓen ");
INSERT INTO fuf_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ko landoyoo mo, wi'a: «Taw si ko onon woni haanuɗo arude on, kaa hara yo men habbo goɗɗo goo?» ");
INSERT INTO fuf_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Iisaa jaabii ɓe wi'i: «Yahee fillitanoɗon Yaayaa ko yi'uɗon kon e ko nanuɗon kon, ");
INSERT INTO fuf_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","wonde: bumɓe ɓen yi'ii, boofooɓe ɓen yahii, ɓe ɗamajan ɓen sellinaama laaɓii, pahiɗuɓe ɓen nanii, mayɓe no immintineede, Kibaaru Moƴƴo on no feɲɲinaneede miskinɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Kala mo feggaaki e an ko malaaɗo.» ");
INSERT INTO fuf_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ɓay ɓe yiltitike, onsay Iisaa fuɗɗii yewtude jamaa on fii Yaayaa, o landii ɓe ɗunɗoo, o wi'i: «Ko honɗun yahunoɗon ndaaroygol ka wulaa? Hara ko kuɗol ngol hendu ndun dimbata? ");
INSERT INTO fuf_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Kaa ko honɗun yahunoɗon ndaarugol? Ko neɗɗo ɓorniiɗo conci dimi? Ndaaree, ɓee ɓorniiɓe conci dimi no e nder galleeji laamu. ");
INSERT INTO fuf_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ko honɗun non yahunoɗon ndaarugol? Ko annabaajo? Hiiyii, min mi wi'ay on, ko ko ɓuri annabaajo. ");
INSERT INTO fuf_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ko oo ɗoo woni mo fii mun windii on, wonde: ‹Awa, miɗo imminde nulaaɗo an on yeeso maa, fii ko fertano-maa laawol maa ngol.› ");
INSERT INTO fuf_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","«Ko fii ka haqiiqa mi andinii on, alaa mo suddiiɗo jibini ɓurɗo Yaayaa *lootoowo maande tuubuubuyee on. Kono non ɓurɗo fanɗude on ka laamateeri kammu no ɓuri mo teddude. ");
INSERT INTO fuf_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Gila e Yaayaa lootoowo maande tuubuubuyee on haa hande laamu kammu ngun no yaarude yeeso e nder doole, tawi doolooɓe ɓen no etaade fii halorgol ngu. ");
INSERT INTO fuf_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ko fii ko haa e Yaayaa annabaaɓe ɓen fow e Sariya on haalunoo ko Alla longini ɗun. ");
INSERT INTO fuf_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Si hiɗon faalaa jaɓude ɗun, ko kanko woni Iiliiya, on haanunooɗo arude. ");
INSERT INTO fuf_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Mo no mari noppi yo nanu! ");
INSERT INTO fuf_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","«Hara ko e honɗun mi eɓɓindirta nguu jamaanu? Hingu nandi e fayɓe, jooɗiiɓe e kubitirde, hara ɓen no noddindira, wi'a: ");
INSERT INTO fuf_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‹Men wuttanii on ceri, on amaali, men yimanii on gimɗi yurmuɗi, on wullaali!› ");
INSERT INTO fuf_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ko fii Yaayaa arno, o ɲaamataano, o yarataano ko mandilinta, wi'uɗon: ‹On ko mo jinna!› ");
INSERT INTO fuf_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ɓii-Aaden* on kadi arii no ɲaama no yara, wi'uɗon: ‹On ko reereɗuɗo, yaroowo, welduɗo e ƴantooɓe sagalle e junuubanke'en!› Kono kuuɗe faamu Allaahu on ɗen hollay wonde ko ngu feewungu.» ");
INSERT INTO fuf_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Onsay Iisaa woni e felugol ca'e ɗe o ɓuri waɗude kaawakeeji moƴƴi e mun ɗen, sabu ko ɗe tuubaali kon, ");
INSERT INTO fuf_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","o wi'i: «Bone wonanii ndee saare Kuuraziin e ndee saare Bayti-Sa'iida! Ko fii si tawno ɗii kaawakeeji moƴƴi waɗunooɗi ka mon ko non waɗirnoo e ɗee ca'e Tiiri e Siduuna, harayno neeɓii ko jeyaaɓe e ɗen ca'e ɓornii conci heynorɗi, ɓe wujitii ndoondi fii hollugol wonde ɓe tuubii. ");
INSERT INTO fuf_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ko ɗun waɗi si mi wi'ay on, ɲande ɲaawoore nden ko Tiiri e Siduuna ɓuretee hoynaneede edii onon. ");
INSERT INTO fuf_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Onon non, ɓee ɓe Kafernahuum, hiɗon sikka fii mon ɓantete haa ka aljanna? Oo'o, on bugete ka jahannama. Ko fii si tawno ɗii kaawakeeji moƴƴi waɗuɗi e maa waɗirno non e ndee saare wi'eteende *Saduuma, harayno haa hande hinde woodaa. ");
INSERT INTO fuf_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ko ɗun waɗi si mi wi'ay on, ɲande ɲaawoore nden ko ndee saare Saduuma ɓuretee hoynaneede edii ndee saare ɗoo.» ");
INSERT INTO fuf_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","E on saa'i ɗon, Iisaa ƴetti haala kan, o wi'i: «Mi yettii ma yo Baaba, Jom leydi e kammu, fii koo ko wirnanɗaa ɗun ɓen faamuɓe e ɓee gandiɗuɓe, feɲɲinanɗaa ɗun ɓee fayɓe. ");
INSERT INTO fuf_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Hiiyii, ko fii ko ɗun wonnoo yiɗi maa on, yo Baaba. ");
INSERT INTO fuf_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","«Awa, Baaba an wattii fow e juuɗe an. Awa kadi hay gooto andaa Ɓiɗɗo on si hinaa Baabaajo on, wano tawiri non kadi hay gooto andaa Baabaajo on si hinaa Ɓiɗɗo on e on mo Ɓiɗɗo on faalaa mo feɲɲinande. ");
INSERT INTO fuf_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","«Aree e an, on fow, yo rondiiɓe ko teddi haa ronki, mi fowtina on. ");
INSERT INTO fuf_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Jaɓon yankinanagol ko mi fawi on kon, jaɓon janndeeji an ɗin. Ko fii min ko mi newiiɗo, yankiniiɗo kadi e ɓernde, ɗun on heɓay fowtunde fii wonkiiji mon ɗin. ");
INSERT INTO fuf_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ko fii ko mi fawata on kon no weli naɓude, awa dongal ngal mi fawata on ngal ko hayfungal.» ");
INSERT INTO fuf_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","E on saa'i ɗon, tawi Iisaa no rewude e gese ngawri ɲande aseweere nden, ɗun ko *ɲalaande fowteteende nden. Tawi taalibaaɓe makko ɓen no woocora cawti ɗen gese, worsa ɗi ɲaama, ko fii hari hiɓe weelaa. ");
INSERT INTO fuf_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ɓay *Fariisiyaaɓe ɓen yi'ii ɗun, ɓe wi'i mo kanko Iisaa: «E hino taalibaaɓe maa ɓen no waɗude ko dagaaki e ɲalaande fowteteende nden!» ");
INSERT INTO fuf_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Kono Iisaa jaabii ɓe, wi'i: «Hara on jangaali ko Daawuuda waɗunoo kon fewndo o weelaa, kanko e yimɓe wondunooɓe e makko ɓen? ");
INSERT INTO fuf_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","O naati ka nder suudu Alla, onsay ɓe ɲaami bireediije weeɓitaaɗe fii sadaka ɗen, ɗe tawata hinaa kanko, hinaa ɓe o wondunoo ɓen daganinoo ɲaamugol, kono ko *yottinooɓe sadaka ɓen tun daganinoo ɲaamugol ɗe. ");
INSERT INTO fuf_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Kaa on jangaali ka Sariya wonde e aseweeje ɗen hooreeɓe yottinooɓe sadaka ɓen no bonna Sariya ɲalaande fowteteende nden ka nder *juulirde mawnde, hara fawaaki ɓe? ");
INSERT INTO fuf_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Kono mi andinii on, ɓurɗo juulirde mawnde nden no ɗoo. ");
INSERT INTO fuf_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Allaahu on no daali: ‹Ko yurmeende mi faalaa, wonaa sadaka.› Si hiɗon andunoo ko ɗun firi, on felataano yimɓe ɓe bonnaa. ");
INSERT INTO fuf_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ko fii ko *Ɓii-Aaden on woni jom ɲalaande fowteteende nden. ");
INSERT INTO fuf_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Onsay o iwi ɗon, o naatoyi ka nder juulirde maɓɓe. ");
INSERT INTO fuf_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Tawi maaya-jungoojo no nder ton. Nde tawnoo hiɓe faalaa tooɲude Iisaa, ɓe landii mo, ɓe wi'i: «E hara no dagii ka goɗɗo ɲawndee e asewe?» ");
INSERT INTO fuf_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","O jaabii ɓe, o wi'i: «Ko hombo e mon, si no mari baalii gootii, ngin ara e yanude e ngayka e aseweere, hara o ronkay ngii nangude, ƴawna? ");
INSERT INTO fuf_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","E ko haa honto non neɗɗo hitti ɓuri baalii! Awa no dagii waɗugol ko moƴƴi ɲande ɲalaande fowteteende nden.» ");
INSERT INTO fuf_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Onsay o wi'i on neɗɗo: «Fontu jungo maa ngon.» On fonti ngo, ngo selliri wa ngoya. ");
INSERT INTO fuf_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Onsay Fariisiyaaɓe ɓen yalti, fewjodi no ɓe warira mo. ");
INSERT INTO fuf_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ɓay Iisaa faamii nden eɓɓoore maɓɓe, o iwi ɗon. Buy jokki mo, o sellini ɓe fow. ");
INSERT INTO fuf_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","O yamiri ɓe wota ɓe feɲɲin fii makko, ");
INSERT INTO fuf_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","fii no ko daaliranoo annabi Isaaya kon laatora, wonde: ");
INSERT INTO fuf_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","«E hino kurkaadu an ndu mi suɓii ndun, on yiɗaaɗo an mo mi weltori. Mi waɗay Ruuhu an on e makko, o feɲɲinanoya leƴƴi ɗin peewal ngal. ");
INSERT INTO fuf_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","O yeddondiroytaa e goɗɗo, o sonkoytaa, e hay gooto nanoytaa hito makko ka ballaŋe. ");
INSERT INTO fuf_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","O heloytaa kuɗol ɓaƴƴungol, o roccinoytaa sarbu wonɗo e suurude, haa o folna peewal ngal. ");
INSERT INTO fuf_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Onsay leƴƴi ɗin tanƴinoroyay innde makko nden.» ");
INSERT INTO fuf_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ɓawto ɗun ɓe addani mo mo jinna nangi, tawi on ko mboboojo bunɗo, o sellini mo. Onsay on mboboojo wowli, yi'i. ");
INSERT INTO fuf_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Tawi ɗun no ŋalɗini jamaa on fota, ɓe wi'i: «Taw si ko oo woni *Almasiihu mo Daawuuda?» ");
INSERT INTO fuf_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ɓay Fariisiyaaɓe ɓen nanii ɗun, ɓe wi'i: «Oo neɗɗo ko e innde *Balzabuula lanɗo jinnaaji ɗin tun o woni raɗorde jinnaaji ɗin!» ");
INSERT INTO fuf_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Nde tawnoo Iisaa no andi ko ɓe miijii, o wi'i ɓe: «Kala laamateeri liddondirndi, kayri tigi ndi caabay. E kala saare maa suudu, si liddondirii kaɲun tigi, haray waawataa tabitude. ");
INSERT INTO fuf_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Si tawii non Ibuliisa raɗike Ibuliisa, o liddike hoore makko kanko tigi. Haray ko honno laamateeri makko ndin tabitirta? ");
INSERT INTO fuf_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Si tawii non min ko tippude e Balzabuula mi woni raɗorde jinnaaji ɗin, haray ɓe mon ɓen non ko tippude e hombo woni ɗi raɗorde? Ko ɗun waɗi si kamɓe tigi ɓe ɲaawoyay on. ");
INSERT INTO fuf_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Kono si tawii ko tippude e Ruuhu Alla on mi woni raɗorde jinnaaji ɗin, haray *laamu Alla ngun arii haa e mon. ");
INSERT INTO fuf_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","«Maa ko honno goɗɗo waawirta naatude e nder suudu neɗɗo dolnuɗo, mooɓa keyeeji on ɗin, ado o haɓɓude on neɗɗo dolnuɗo taho. Ko onsay doo o waawata mooɓude ko woni ka suudu on kon. ");
INSERT INTO fuf_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Awa, kala mo aldaa e an haray ko gaɲo an, awa kadi kala mo wallataa lan mooɓitude haray ko saakoowo. ");
INSERT INTO fuf_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","«Ko ɗun waɗi si mi wi'ay on, kala junuubu maa hoyre yaafante yimɓe ɓen, kono hoyre hoynuɗo Ruuhu Alla on yaafetaake few. ");
INSERT INTO fuf_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Kala wowluɗo Ɓii-Aaden on ko boni, no ara ka yaafanee. Kono kala wowluɗo *Ruuhu Seniiɗo on ko boni, o yaafantaake e oo aduna fewndiiɗo ɗoo, e aroyoowo on kadi.» ");
INSERT INTO fuf_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","«Si leggal no moƴƴi, haray ɓiɓɓe maggal on no moƴƴi. Si leggal moƴƴaa, haray ɓiɓɓe maggal on moƴƴaa. Ko fii leggal kala no anditiree ɓiɓɓe mun ɓen. ");
INSERT INTO fuf_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ko onon yo iwdi kuura! Ko honno wowlirton ko moƴƴi, hara ko on bonɓe? Ko fii ko ko heewi e ɓernde woo hunduko wowlata. ");
INSERT INTO fuf_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Neɗɗo moƴƴo on yaltinay moƴƴere ka moƴƴuki mun, neɗɗo bonɗo on kadi yaltina bonki ka bonki mun. ");
INSERT INTO fuf_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Awa mi andinii on, ɲande ɲaawoore nden yimɓe ɓen hasborte kala konguɗi mehi ɗi ɓe wowlaynoo. ");
INSERT INTO fuf_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ko fii ko konguɗi maa ɗin ɲaawirteɗaa feewuɗo maa bonɗo.» ");
INSERT INTO fuf_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Onsay woɓɓe e jannooɓe fii Sariya on e Fariisiyaaɓe ɓen ƴetti haala kan, wi'i: «Karamoko, meɗen faalaa yo a waɗan men maande hawniinde, men yi'a.» ");
INSERT INTO fuf_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","O jaabii ɓe, o wi'i: «Jamaanu bonngu jinoowu no ɗaɓɓa maande, kono ngu jonnetaake maande si hinaa sifa ndee nde annabi Yuunusa. ");
INSERT INTO fuf_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ko fii ko wano Yuunusa wonirnoo ka nder reedu lingii njanii ngin non balɗe tati, ko wano non Ɓii-Aaden on wonirta ka nder leydi balɗe tati. ");
INSERT INTO fuf_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Awa kadi ɲande ɲaawoore nden, nde yimɓe nguu jamaanu ɗoo no ɲaawee woo, yimɓe *Niinawa ɓen kadi immoyto, ɲaawoya ɓe sabu kon ko ɓe heɗinoo ngun waaju Yuunusa, ɓe tuubi, hara-le ɓurɗo Yuunusa no ɗoo. ");
INSERT INTO fuf_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ɲande ɲaawoore nden, nde yimɓe nguu jamaanu ɗoo no ɲaawee woo, onsay oo debbo laaminooɗo ndii leydi hikkorndi ka sengo ɲaamo immoyto, ɲaawoya ɓe sabu iwugol mo haa ka kattudi leyɗe, ara heɗitoo ngun faamu Sulaymaana, hara-le ɓurɗo Sulaymaana no ɗoo. ");
INSERT INTO fuf_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","«Nde jinnawii yalti e neɗɗo woo, ngii hammiray ka wulaa, hara hingii ɗaɓɓa nokkuure fowtorde. Si ngii tawii ngii heɓaali, ");
INSERT INTO fuf_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ngii wi'ay: ‹Yo mi yiltito ka suudu ka mi iwnoo ɗon.› Nde ngii hewtiti, ngii tawa ndun suudu fittaama laɓɓinaama. ");
INSERT INTO fuf_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Onsay ngii yahay, ngii ɗaɓɓoya jinnaaji jeeɗiɗi ɓurɗi ngii hunƴude, ɗi naata ɗon, ɗi hoɗa. Onsay sakkitorde on neɗɗo ɓuray aranun ɗun bonude. Ko wano non woniranta nguu jamaanu bonngu.» ");
INSERT INTO fuf_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","E nder ko Iisaa yewtata jamaa on kon, tawi yumma makko e yumma-gootooɓe makko ɓen no darii ka yaasi, no faalaa yiidude e makko. ");
INSERT INTO fuf_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Onsay goɗɗo wi'i mo: «Yumma mon e yumma-gootooɓe mon ɓen no darii ka yaasi, hiɓe faalaa on yewtude.» ");
INSERT INTO fuf_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Kono Iisaa jaabii mo, wi'i: «Ko hombo woni yumma an e ko homɓe woni yumma-gootooɓe an ɓen?» ");
INSERT INTO fuf_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Onsay o sappii taalibaaɓe makko ɓen, o wi'i: «E hino yumma an e yumma-gootooɓe an ɓen. ");
INSERT INTO fuf_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ko fii kala waɗuɗo faale Ben an Wonɗo ka kammu on, haray ko on woni yumma-gooto an on e bandiraawo an on e yumma an.» ");
INSERT INTO fuf_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Nden ɲande Iisaa yalti ka suudu, o jooɗoyii ka daande weendu. ");
INSERT INTO fuf_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Hakkee ko jamaa mooɓinooɗo takko makko on ɗuuɗi, o bakii e laakun, o jooɗii, tawi jamaa on fow kaɲun no ka daande weendu. ");
INSERT INTO fuf_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","O yewtiri ɓe piiji buy mise, o wi'i: «Ko remoowo yaltunoo sankugol. ");
INSERT INTO fuf_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","E nder ko o sankata kon, gabbe goo yani ka ɗatal, colli ɗin ari moɗi ɗe. ");
INSERT INTO fuf_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Goɗɗe ɗen yani e hoore kaaƴe, ka leydi ɗuuɗaa. Ɗe fuɗi heɲa sabu ɗewlugol leydi ndin. ");
INSERT INTO fuf_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ɓay naange ngen yaltii, ɗe sumi, ɗe yoori, sabu angal ka ɗaɗi ɗin siŋoo. ");
INSERT INTO fuf_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Goɗɗe goo kadi yani ka sooƴoore, ɗe fuɗidi e mayre, sooƴoore nden moɗi ɗe. ");
INSERT INTO fuf_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Goɗɗe goo yani ka leydi moƴƴiri. Ɗe fuɗi, ɗe rimi, cawti goo gabbe teemedere, cawti goo gabbe cappanɗe jeegoo, cawti goo gabbe cappanɗe tati. ");
INSERT INTO fuf_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Mo no mari noppi yo nanu!» ");
INSERT INTO fuf_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Onsay taalibaaɓe ɓen ɓadii mo, wi'i: «Ko fii honɗun yewtiranton ɓe mise?» ");
INSERT INTO fuf_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Iisaa jaabii ɓe, wi'i: «Onon on yeɗaama andugol gundooji laamu kammu ngun, kono kamɓe ɓe yeɗaaka ɗun. ");
INSERT INTO fuf_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ko fii ko marɗo ɓeydantee haa ɗuuɗa, kono mo maraa on jaɓitante hay yeru ko o mari kon. ");
INSERT INTO fuf_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ko waɗi si miɗo yewtirde ɓe mise, ko ɓay hiɓe ndaara, kono ɓe yi'ataa, hiɓe jentoo, kono ɓe nanataa, ɓe faamataa. ");
INSERT INTO fuf_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Fii ko Alla longinnoo Isaaya kon no laatora e maɓɓe, wonde: ‹Pellet hiɗon nana, kono on faamataa few. Pellet hiɗon ndaara, kono on yi'ataa few. ");
INSERT INTO fuf_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ko fii ɗee ɓerɗe oo jamaa wonii yooruɗe. Ɓe uddii noppi maɓɓe ɗin, awa kadi ɓe ombii gite ɗen, sakko ɓe yiira gite maɓɓe ɗen, maa ɓe nanira noppi maɓɓe ɗin, maa ɓe faamira ɓerɗe maɓɓe ɗen, haa ɓe tuuba, mi sellina ɓe.› ");
INSERT INTO fuf_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","«Onon non, gite mon ɗen malii ko fii hiɗe yi'ude, noppi mon ɗin malii ko fii hiɗi nanude. ");
INSERT INTO fuf_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ko fii ka haqiiqa mi andinii on, annabaaɓe e feewuɓe buy faalano yi'ude koo ko wonɗon yi'ude, kono ɓe yi'aali. Ɓe faalano kadi nanude koo ko wonɗon nanude, kono ɓe nanaali. ");
INSERT INTO fuf_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","«Kono onon, heɗee firo ngal misal remoowo on. ");
INSERT INTO fuf_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Nde goɗɗo heɗii daalol *laamu Alla ngun, ronki ngol faamude, bonɗo on aray, itta ko aawaa kon ka ɓernde makko. Ɗun no wa'i wa nde awdi sankaandi ndin saami ka ɗatal. ");
INSERT INTO fuf_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Nde awdi sankaandi ndin saami ka kaaƴe, ɗun no wa'i wa nde goɗɗo nani daalol ngol, o jaɓa ngol heɲa e nder weltaare. ");
INSERT INTO fuf_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Kono o alaa ɗaɗi, ko fii hinaa o tabituɗo. Nde satteendeeji maa cukkeede aroyi sabu jokkugol makko daalol ngol, o tertoto kisan. ");
INSERT INTO fuf_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Nde awdi sankaandi ndin saami ka sooƴoore, ɗun no wa'i wa nde goɗɗo nani daalol ngol, hara ngol rimataa e makko ko fii haray ngol moɗiraama anndeeji aduna e ɗayniro jawle. ");
INSERT INTO fuf_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Nde awdi sankaandi ndin saami ka leydi moƴƴiri, ɗun no wa'i wa nde goɗɗo nani daalol ngol, faami, ngol rimi e makko, woɓɓe ɓen laabi teemedere, woɓɓe ɓen laabi cappanɗe jeegoo, ɓeya ɓen laabi cappanɗe tati.» ");
INSERT INTO fuf_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Iisaa addani ɓe misal goo kadi, o wi'i ɓe: «Laamu kammu ngun no wa'i wa nde aaden sanki awdi moƴƴiri e ngesa mun. ");
INSERT INTO fuf_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Kono wa ko yimɓe ɓen ɗaanii, gaɲo makko on ari, sanki kenkesama ka ngesa makko ngawri, o yahi. ");
INSERT INTO fuf_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ɓay wonii ngawri ndin fuɗii haa mawnii sawtii, kenkesama on kadi yaltiti. ");
INSERT INTO fuf_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","«Kurkaaduuɓe jom suudu ndun ari, wi'i mo: ‹Jom amen, e hinaa awdi moƴƴiri sankuɗon ka ngesa mon? E hara ko honto oo kenkesama iwri?› ");
INSERT INTO fuf_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","«O jaabii ɓe, o wi'i: ‹Ko gaɲo waɗi ɗun.› «Onsay kurkaaduuɓe ɓen wi'i mo: ‹Hiɗon faalaa yo men yahu men ɓoroya ɗun?› ");
INSERT INTO fuf_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","«O jaabii ɓe: ‹Oo'o, fii wota on ɓoror ngawri ndin nde hiɗon ɓora kenkesama on. ");
INSERT INTO fuf_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Accee ɗi njanɗida haa ka baagol. Si baagol ngol fewndike, mi wi'ay wa'ooɓe ɓen yo ɓe ɓoru taho kenkesama on, ɓe haɓɓira ba'e ba'e fii ko sunnee, ɓe mooɓa ngawri ndin ka tumusuuje an.› » ");
INSERT INTO fuf_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Iisaa addani ɓe misal goo kadi, o wi'i ɓe: «Laamu kammu ngun no wa'i wa abbere bene, nde goɗɗo ƴetti, aawi e ngesa mun. ");
INSERT INTO fuf_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Pellet, ko nden ɓuri fanɗude e ko aawetee kon fow, kono nde nde fuɗi, haray ko nden ɓuri mawnude kala ko tutetee e naakoo, nde wonta leggal haa ka tawata colli ɗin ka weeyo aray, hoɗa e calɗi maggal on.» ");
INSERT INTO fuf_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Iisaa addani ɓe ngal misal ɗoo kadi, o wi'i ɓe: «Laamu kammu ngun no wa'i wa lewen mo debbo ƴetti, jillindiri e sariyaare tati condi farin, o piya ɗun, on lewen wona sabu ɗun fow ƴura.» ");
INSERT INTO fuf_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Iisaa yewtiri ɗun jamaa on mise. O yewtirtaano ɓe si wonaa mise, ");
INSERT INTO fuf_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","fii no ko daaliranoo annabaajo on kon laatora, wonde: «Mi udditay hunduko an kon fii yewtirgol mise, mi feɲɲina piiji suuɗinooɗi gila ka fuɗɗoode.» ");
INSERT INTO fuf_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Onsay Iisaa acci ɗon jamaa on, o naati ka suudu. Taalibaaɓe makko ɓen ɓadii mo, ɓe wi'i: «Sifanee men ngal misal kenkesama ka ngesa.» ");
INSERT INTO fuf_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","O jaabii ɓe, o wi'i: «Sankuɗo awdi moƴƴiri on ko *Ɓii-Aaden on. ");
INSERT INTO fuf_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ngesa mban ko aduna on. Awdi moƴƴiri ndin, ko ɓen woni ɓiɓɓe laamateeri ndin. Kenkesama on non ko ɓen woni ɓiɓɓe bonɗo on. ");
INSERT INTO fuf_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Gaɲo sankuɗo kenkesama on, ko on woni Ibuliisa. Baagol ngol non ko lannoode aduna on, wa'ooɓe ɓen ko ɓen woni malaa'ikaaɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Wano kenkesama on ɓorirtee non fii bugegol ka yiite, ko non woniroyta nde aduna on lanni. ");
INSERT INTO fuf_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ɓii-Aaden on imminoyay malaa'ikaaɓe mun ɓen ko suuta e nder laamateeri makko ndin fegginayɓe ɓen fow e waɗooɓe ko boni ɓen, ");
INSERT INTO fuf_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ɓe bugoo ɓe ka nder beembal yiite ka wullaandu e ŋatindiro ɲiiƴe woni ton. ");
INSERT INTO fuf_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Kono feewuɓe ɓen jalbiroyay wa naange ka nder laamateeri Ben maɓɓe. Mo no mari noppi, yo nanu!» ");
INSERT INTO fuf_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Iisaa wi'i kadi: «Laamu kammu ngun no wa'i wa keyee suuɗiiɗo e nder ngesa mo neɗɗo goo arata yi'a suuɗa. E nder weltaare makko nden o yaha, o yeeya kala ko o jogii, o sooda mban ngesa. ");
INSERT INTO fuf_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","«Laamu kammu ngun no wa'i kadi wa njulaajo wonɗo ɗaɓɓude lambiri. ");
INSERT INTO fuf_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ɓay o yi'ii satta-cogguure, o yahi, o yeeyiti kala ko o jeynoo, o soodi nde. ");
INSERT INTO fuf_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","«Laamu kammu ngun no wa'i kadi wa *jalaaji bugaaɗi e nder maayo, mooɓi noone liƴƴi fow. ");
INSERT INTO fuf_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ɓay ɗi heewii, ɗi pooɗaa ka pencen, jooɗaa. Moƴƴi ɗin ƴettaa wattaa ka miranji, bonɗi ɗin bugaa. ");
INSERT INTO fuf_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ko non kadi woniroyta nde aduna on lanni. Malaa'ikaaɓe ɓen yahoyay sendindira bonɓe ɓen e moƴƴuɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ɓe bugoo bonɓe ɓen ka beembal yiite ka wullaandu e ŋatindiro ɲiiƴe woni ton. ");
INSERT INTO fuf_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","«E hara on faamii ɗun fow?» Ɓe jaabii: «Hiiyii!» ");
INSERT INTO fuf_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","O wi'i ɓe kadi: «Ko ɗun waɗi, kala jannoowo jamaa on fii Sariya on, si no jannaa fii laamu kammu ngun, no wa'i wa nde jom suudu no yaltina e nder marga mun keyeeji kesi e kiɗɗi.» ");
INSERT INTO fuf_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ɓay wonii Iisaa gaynii ɗee mise, o iwi ɗon. ");
INSERT INTO fuf_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Iisaa yahi ka o ne'aa ɗon, ɗun ko Naasirata, o woni e waajagol ka nder juulirde maɓɓe. Ɗun ŋalɗini ɓe haa ɓe wi'i: «Ko honto nguu faamu e ɗii kaawakeeji moƴƴi iwrani mo? ");
INSERT INTO fuf_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","E hinaa ɓiɗɗo minisiyeejo on nii? Hinaa yumma makko wi'etee Mariyama? E hara neene-gootooɓe makko ɓen hinaa Yaaquuba e Yuusufu e Sim'uunu e Yuudu? ");
INSERT INTO fuf_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","E hinaa bandiraaɓe makko ɓen fow no wondi e men? E hara ko honto ɗun fow iwrani mo?» ");
INSERT INTO fuf_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ɗun haɗi ɓe gomɗingol mo. Kono Iisaa wi'i ɓe: «Annabaajo ko ka leydi mun tun e ka ɓeynguure mun yawaa.» ");
INSERT INTO fuf_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Laatii o waɗaali ɗon kaawakeeji moƴƴi buy sabu angal gomɗinal maɓɓe ngal. ");
INSERT INTO fuf_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ko e on saa'i ɗon, *Heroodu lanɗo diiwal Jaliilu ngal nani fii Iisaa no wowlee. ");
INSERT INTO fuf_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","O wi'i kurkaaduuɓe makko ɓen: «Ko Yaayaa lootaynooɗo maande tuubuubuyee on nii! O immitike e hakkunde mayɓe ɓen! Ko ɗun waɗi si himo mari bawgal waɗugol kaawakeeji moƴƴi!» ");
INSERT INTO fuf_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ko Heroodu wi'irnoo ɗun ko ɓay hari o nangiino Yaayaa, o jolkii mo, o waɗii e kaso sabu oo debbo wi'eteeɗo Heroodiiya, ɓeyngu Filiipu, yumma-gooto makko on nun kanko Heroodu, ");
INSERT INTO fuf_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","ko fii hari Yaayaa wi'ii mo kanko Heroodu wonde daganaaki mo ka o ƴetta on debbo. ");
INSERT INTO fuf_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","O faalaa mo warude, kono o huli jamaa on, ko fii hari hiɓe jogori Yaayaa wa annabaajo. ");
INSERT INTO fuf_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Kono e nder ɲalaande anditugol jibineede makko nden kanko Heroodu, jiwo Heroodiiya on ami e hakkunde saatinaaɓe ɓen. Ɗun weli Heroodu ");
INSERT INTO fuf_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","haa o fodi on jiwo e hoore woondoore wonde o waɗanay mo kala ko o torii mo fewndo ɗon. ");
INSERT INTO fuf_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Tippude e ko yumma makko kanko jiwo on lowi mo kon, on jiwo wi'i: «Jonnan ɗoo hoore Yaayaa lootoowo maande tuubuubuyee on nden, hara hinde tumbaa e miran.» ");
INSERT INTO fuf_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Onsay lanɗo on aani. Kono sabu woondooje makko ɗen, e ɓe o saatinnoo ɓen, o yamiri yo nde jonne mo. ");
INSERT INTO fuf_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","O immini ko taƴoya hoore Yaayaa nden ka kaso, ");
INSERT INTO fuf_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","nde addaa e miran, ɗun jonnaa jiwo on, kanko kadi o naɓani nde yumma makko. ");
INSERT INTO fuf_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Onsay taalibaaɓe Yaayaa ɓen ari, ƴetti furee makko on, surroyi. Ɓe yahi, ɓe humpitoyi Iisaa. ");
INSERT INTO fuf_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ɓay Iisaa nanii ɗun, o iwi ɗon e laana ndiyan, kanko tun o yahi e nokkuure wulɗinnde. Jamaa on humpitii ɗun, ɓe iwi ka ca'e, ɓe seppi, ɓe jokki mo. ");
INSERT INTO fuf_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ɓay o iwii ka laana, o yi'i jamaa moolanaaɗo, o yurmaa ɓe, o ɲawndi ɲawɓe wonnooɓe ɗon ɓen. ");
INSERT INTO fuf_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ɓay niɓɓii, taalibaaɓe ɓen ɓadii mo, wi'i: «Ɗoo ko nokkuure wulɗinnde nii, ɲallal ngal pooɗike. Accitee jamaa on, ɓe yaha ka koɗooli, ɓe ɗaɓɓa ko ɓe ɲaama.» ");
INSERT INTO fuf_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Iisaa jaabii ɓe, wi'i: «Jaraa ka ɓe yaha. Onon tigi okkoree ɓe ko ɓe ɲaama.» ");
INSERT INTO fuf_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Kono ɓe wi'i mo: «Ko bireediije jowi e liƴƴi ɗiɗi pet men mari ɗoo!» ");
INSERT INTO fuf_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Kanko kadi o wi'i ɓe: «Addanee lan ɗunɗoo.» ");
INSERT INTO fuf_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Onsay o yamiri jamaaji ɗin yo ɓe jooɗo ka huɗo. O ƴetti bireediije ɗen jowi e liƴƴi ɗin ɗiɗi, o ɓanti gite ɗen, o fewtini ka kammu. O du'ii, o taƴiti bireedi on, o jonni taalibaaɓe ɓen, taalibaaɓe ɓen hewtini jamaa on. ");
INSERT INTO fuf_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Fow ɲaami haa haari. Ɓe mooɓiti debeeje sappoo e ɗiɗi tew kunte ko lutti. ");
INSERT INTO fuf_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Tawi ɓen ɲaamuɓe ko wa ɓe worɓe guluuje njowo, hara rewɓe e fayɓe lintaaka. ");
INSERT INTO fuf_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ɓawto ɗun kisan, Iisaa yamiri taalibaaɓe mun ɓen yo ɓe bako ka laana, ɓe hikkoo yeeso makko, ɓe lumba gaɗa fewndo o yiltata jamaa on. ");
INSERT INTO fuf_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ɓay wonii o yiltii ɓe, o ƴawi ka fello fii juulugol toroo ka weddii. Ɓay niɓɓii, tawi ko kanko tun woni ɗon. ");
INSERT INTO fuf_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Tawi laana kan woɗɗitorii leydi ndin wa palanɗe teemeɗɗe, awa kadi morlooɗe ndiyan ɗan no piyaade e makka, ko fii hari hika tiindondiri e hendu ndun. ");
INSERT INTO fuf_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ka subaka, Iisaa sutori e maɓɓe, himo seppa ka hoore ndiyan. ");
INSERT INTO fuf_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ɓay taalibaaɓe ɓen yi'ii himo seppa ka hoore ndiyan, ɓe huli, ɓe wi'i: «Ko mbeelu!» E nder kulol maɓɓe ngol ɓe sonki. ");
INSERT INTO fuf_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Iisaa wi'i ɓe kisan: «Hoolee, ko min nii! Wota on hulu!» ");
INSERT INTO fuf_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Onsay Petruusu jaabii mo, wi'i: «Si tawii ko onon, yo Koohoojo, yamiree lan yo mi rewu ka hoore ndiyan, mi yaha ka wonɗon ton.» ");
INSERT INTO fuf_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Iisaa wi'i mo: «Aru!» Onsay Petruusu tippii ka laana, o seppi ka hoore ndiyan, o yahi fottoygol e Iisaa. ");
INSERT INTO fuf_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Kono ɓay o yi'ii ko hendu ndun tiiɗi kon, o huli. Tun o fuɗɗii mutude, o sonki, o wi'i: «Dandee lan, yo Koohoojo!» ");
INSERT INTO fuf_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Iisaa fonti jungo mun ngon, nangi mo, o wi'i: «Ko an yo fanɗa-gomɗinaljo, ko honɗun sikkitantoɗaa?» ");
INSERT INTO fuf_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Onsay ɓe ƴawi ka laana, hendu ndun deƴƴiti. ");
INSERT INTO fuf_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Wonnooɓe ka laana ɓen sujjani mo, wi'i: «Ka haqiiqa, ko a *Ɓiɗɗo Alla!» ");
INSERT INTO fuf_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ɓay ɓe gaynii lumbude weendu ndun, ɓe hewti Jaani-Saarata. ");
INSERT INTO fuf_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Yimɓe nden nokkuure anditi Iisaa, ɓe nuli e baŋŋeeji ɗon ɗin fow. Ɓe addani mo ɲawɓe ɓen fow, ");
INSERT INTO fuf_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","ɓe jeeji mo yo o newnan ɓe tun ɓe meema kombol dolokke makko on, onsay meemunooɓe mo ɓen fow ndikki. ");
INSERT INTO fuf_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Onsay *Fariisiyaaɓe e jannooɓe fii Sariya on iwri Yerusalaam, ari tawi Iisaa, ɓe landii mo, ɓe wi'i: ");
INSERT INTO fuf_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«Ko fii honɗun taalibaaɓe maa ɓen jaggitanta naamuuji mawɓe ɓen? Ko fii ɓe sooɗotaako nde hiɓe ɲaama.» ");
INSERT INTO fuf_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","O jaabii ɓe, o wi'i: «Onon non ko honɗun jaggitanton yamirooje Alla ɗen sabu naamuuji mon ɗin? ");
INSERT INTO fuf_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ko fii Allaahu on no daali: ‹Teddin yumma maa e ben maa›, awa kadi: ‹on mo huɗi ben mun maa yumma mun donkinirte mayde.› ");
INSERT INTO fuf_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Kono onon, hiɗon wi'a wonde kala wi'uɗo ben mun maa yumma mun: ‹mi yeɗii Alla ko mi nafiraynoo on kon›, ");
INSERT INTO fuf_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","haray fawaaki ontigi wallugol ben mun maa yumma mun. Si ko nii, haray on mehinɗinii daaluyee Alla on sabu naamu mon on. ");
INSERT INTO fuf_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ko onon yo faasiqiiɓe, Isaaya no haalunoo ko Alla longini mo fii mon moƴƴa, o wi'i: ");
INSERT INTO fuf_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‹Oo jamaa ko ka toni mun woni lan mawninde, kono ɓerɗe maɓɓe ɗen no woɗɗondiri e an fota. ");
INSERT INTO fuf_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ko e nder meere ɓe woni lan rewude, janndeeji ɗi ɓe woni jannude ɗin ko ɗi yimɓe ɓen sinci.› » ");
INSERT INTO fuf_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Onsay Iisaa noddi jamaa on e makko, o wi'i ɓe: «Heɗee, faamon. ");
INSERT INTO fuf_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Hinaa ko naatiri ka hunduko tuuninta neɗɗo, kono ko ko yaltirta ka hunduko kon tuuninta neɗɗo.» ");
INSERT INTO fuf_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Onsay taalibaaɓe makko ɓen ɓadii mo, wi'i: «Hiɗon andi Fariisiyaaɓe ɓen mettinii sabu nanugol ngol kongol?» ");
INSERT INTO fuf_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","O jaabii ɓe, o wi'i: «Kala ko tutaa, ko tawi hinaa Ben an Kammuyankeejo on tuti, ɓorete. ");
INSERT INTO fuf_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Tertee ɓe, ko bumɓe woni ɗowude bumɓe. Si bunɗo non ɗowii bunɗo, ɓe ɗiɗoo non ɓe yanay e nder ngayka.» ");
INSERT INTO fuf_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Petruusu ƴetti haala kan, wi'i: «Sifanee men fii ngal misal.» ");
INSERT INTO fuf_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Iisaa wi'i mo: «E onon kadi haa jooni ko on ɓe alaa faamu? ");
INSERT INTO fuf_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","E on andaa kala ko naati ka hunduko ko ka nder reedu yahata, ɓawto ɗun hawkoyee ka weddii? ");
INSERT INTO fuf_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Kono ko yaltiri ka hunduko kon ko ka ɓernde iwri, e ko ɗun-le tuuninta neɗɗo. ");
INSERT INTO fuf_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ko fii, ko e nder ɓernde neɗɗo miijooji bonɗi yaltata, kaɲun e waru-hoore e jinaa e cagayaagal e nguyka e seeditagol fenaande e hoyre. ");
INSERT INTO fuf_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ko ɗun woni ko tuuninta neɗɗo. Kono ɲaamugol hara sooɗaaki, ɗun tuunintaa neɗɗo.» ");
INSERT INTO fuf_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ɓay Iisaa iwii e nden nokkuure, o yahi e ndii leydi ɗee ca'e Tiiri e Siduuna. ");
INSERT INTO fuf_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Tun, debbo Kanaaniyankeejo hoɗuɗo ɗon ari tawi mo, no ewnoo, wi'a: «Koohoojo, ɓii Daawuuda, yurminee lan! Jinna no tampini jiwo an on no hawnori!» ");
INSERT INTO fuf_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Laatii kanko Iisaa o jaabaaki mo hay kongol. Taalibaaɓe makko ɓen ɓadii mo, wi'i: «Yiltee oo debbo, ko fii himo sonkude ɓaawo men.» ");
INSERT INTO fuf_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","O jaabii, o wi'i: «Ko fii ko baali suudu Isra'iila majjuɗi ɗin tun mi addiraa.» ");
INSERT INTO fuf_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Kono kanko debbo on o ari, o jiccii yeeso makko e hoore himo wi'a: «Koohoojo, faabee lan!» ");
INSERT INTO fuf_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","O jaabii debbo on, o wi'i: «Moƴƴaa ka bireedi paykoy koy ƴettee, buganee bareeji ɗin.» ");
INSERT INTO fuf_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Debbo on jaabii: «Hiiyii, Koohoojo, kono hay bareeji ɗin ɲaamay ko iwata ka taabal jom majji, saama kon.» ");
INSERT INTO fuf_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Onsay Iisaa jaabii mo, wi'i: «Debbo, gomɗinal maa ngal no tiiɗi. Yo wonirane no faaliraɗaa non.» E on saa'i tigi jiwo makko on ndikki. ");
INSERT INTO fuf_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ɓay feƴƴii e ɗun, Iisaa iwi e nden nokkuure, o takkii sera *Weendu Jaliilu ndun. O ƴawoyi ɗon e fello, o jooɗii. ");
INSERT INTO fuf_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Jamaa moolanaaɗo kadi ɓadii mo, wondude e boofooɓe e bumɓe e laƴooɓe e pahiɗuɓe-mbobiɗi e ɲawɓe goo buy. Ɓe wallini ɓen e ley koyɗe makko, o sellini ɓe. ");
INSERT INTO fuf_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ɓay jamaa on yi'ii pahiɗuɓe-mbobiɗi ɓen wowlii, laƴooɓe ɓen kadi hettii cellal, boofooɓe ɓen yahii, bumɓe ɓen yi'ii, ɓe ŋalɗi, ɓe mawnini Alla Isra'iilayankeeɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Onsay Iisaa noddi taalibaaɓe mun ɓen, o wi'i: «Oo jamaa no yurmammi, wonii nii balɗe tati hiɓe wondi e an, ɓe alaa ko ɓe ɲaama. Mi faalaaka ɓe yiltude hiɓe weelaa, sakko ɓe lo'a ka laawol.» ");
INSERT INTO fuf_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Kono taalibaaɓe ɓen wi'i mo: «Ko honto men heɓata bireedi ko yonata oo jamaa ɗoo fow e ndee nokkuure wulɗinnde?» ");
INSERT INTO fuf_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Iisaa landii ɓe, wi'i: «Ko bireediije jelu marɗon?» Ɓe jaabii mo, ɓe wi'i: «Ko bireediije jeeɗiɗi e likkoy tosokoy seeɗa.» ");
INSERT INTO fuf_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Onsay o torii jamaa on jooɗagol ka leydi. ");
INSERT INTO fuf_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ɓay o ƴettii bireediije ɗen jeeɗiɗi e liƴƴi ɗin, o jarnii Alla, o taƴiti, o woni e jonnugol taalibaaɓe makko ɓen, taalibaaɓe ɓen kadi hewtini jamaa on. ");
INSERT INTO fuf_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Fow ɲaami haa haari, mooɓitaa debeeje jeeɗiɗi tew ko lutti. ");
INSERT INTO fuf_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Tawi ɓen ɲaamuɓe ko ɓe worɓe guluuje nayo, hara rewɓe e fayɓe lintaaka. ");
INSERT INTO fuf_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ɓawto ɗun o yilti jamaa on, o bakii e laana, o yahi e ndii leydi Magaduuna. ");
INSERT INTO fuf_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Onsay *Fariisiyaaɓe ɓen e *Sadduusiyaaɓe ɓen ɓadii mo kanko Iisaa fii ndarndagol mo, ɓe torii mo yo o hollu ɓe maande iwrunde ka kammu. ");
INSERT INTO fuf_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Iisaa jaabii ɓe, wi'i: «Kiikiiɗe on wi'ay: ‹Yaasi on hentoto, fii ko kammu ngun wojji kon.› ");
INSERT INTO fuf_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Bimbi kadi wi'on: ‹Hande wundinay, ko fii kammu ngun no wojji ɓawli.› Hiɗon waawi faamude fii ko feeɲi ka kammu kon, kono on waawataa faamude fii maandeeji saa'iiji ɗin? ");
INSERT INTO fuf_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Jamaanu bonngu jinoowu no ɗaɓɓa maande, kono ngu jonnetaake maande goo, si hinaa sifa ndee nde Yuunusa.» Onsay o acci ɓe ɗon, o yahi. ");
INSERT INTO fuf_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ko ɓe lumbitata, taalibaaɓe ɓen yejjiti ƴettorde bireedi. ");
INSERT INTO fuf_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Iisaa wi'i ɓe: «Reenee fota e lewen Fariisiyaaɓe ɓen e Sadduusiyaaɓe ɓen!» ");
INSERT INTO fuf_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Taalibaaɓe ɓen wi'indiri: «Ko o wi'iri ɗun, ko fii en ƴettaali bireedi.» ");
INSERT INTO fuf_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ɓay Iisaa andii ɗun, o wi'i ɓe: «Ko fii honɗun wi'anɗon ɗun, onon ɓee fanɗa-gomɗinalɓe? Ko fii on ƴettaali bireedi? ");
INSERT INTO fuf_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Jaka on faamaali haa jooni, on anditaali fii bireediije jowi senditananooɗe worɓe guluuje njowo ɗen, e ko debeeje jelu artirnoɗon ko lutti? ");
INSERT INTO fuf_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","E bireediije ɗen jeeɗiɗi senditananooɗe worɓe guluuje nayo ɗen, e yeru debeeje ko artirnoɗon ko lutti? ");
INSERT INTO fuf_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ko honno woniri on faamaali wonde hinaa fii bireedi mi wowlani on? Kono reenee e lewen Fariisiyaaɓe ɓen e Sadduusiyaaɓe ɓen!» ");
INSERT INTO fuf_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Onsay ɓe faami ko o inni yo ɓe reeno, ko e jannde Fariisiyaaɓe ɓen e Sadduusiyaaɓe ɓen, hinaa e lewen waɗeteeɗo e bireedi. ");
INSERT INTO fuf_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Nde Iisaa naatunoo Seezariiya-Filiipu, o landii taalibaaɓe makko ɓen ngal landal ɗoo, o wi'i: «E wi'i yimɓe ɓen, ko hombo woni *Ɓii-Aaden on?» ");
INSERT INTO fuf_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ɓe jaabii mo, ɓe wi'i: «Woɓɓe no wi'a ko onon woni Yaayaa lootaynooɗo on, woɓɓe kadi no wi'a ko onon woni Iiliiya, woɓɓe goo kadi no wi'a ko onon woni Yeremiiya maa goɗɗo goo e annabaaɓe ɓen.» ");
INSERT INTO fuf_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","O wi'i ɓe: «Onon non wi'uɗon ko hombo woni lan min?» ");
INSERT INTO fuf_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Sim'uunu Petruusu jaabii mo wi'i: «Ko onon woni *Almasiihu on, on *Ɓiɗɗo Alla Wuuruɗo on!» ");
INSERT INTO fuf_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Iisaa ƴettiti haala kan, wi'i mo: «A malii, yo Sim'uunu mo Yuunusa, ko fii hinaa ɓandu e ƴiiƴan feɲɲinan-maa ɗun, kono ko Ben an, on Wonɗo ka kammu. ");
INSERT INTO fuf_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Min non mi wi'ii an Petruusu, ko a fetere. Ko e hoore ndee fetere mi darnata *moftal an ngal, hay doole jahannama foolataa ngal. ");
INSERT INTO fuf_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Awa kadi mi jonnoyte saabiije laamateeri kammu ngun: ko toŋuɗaa ka leydi woo haray toŋaama ka kammu, ko jaɓuɗaa ka leydi woo haray jaɓaama ka kammu.» ");
INSERT INTO fuf_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Onsay o yamiri taalibaaɓe ɓen, o tentini, wota ɓe wowlan hay gooto wonde ko kanko woni Almasiihu on. ");
INSERT INTO fuf_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Gila nden ɲande, Iisaa fuɗɗii hollude taalibaaɓe mun ɓen wonde ko bee o yaha Yerusalaam, o tampinoyee fota immorde e mawɓe ɓen e hooreeɓe *yottinooɓe sadaka ɓen e jannooɓe fii Sariya on ɓen, o waree, o immintinoyee ka ɲalaande tammere. ");
INSERT INTO fuf_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Onsay Petruusu pottini mo sera, o woni mo e felugol wi'a: «Yo Allaahu on reenu on, yo Koohoojo, hara ɗun hewtaali on!» ");
INSERT INTO fuf_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Kono Iisaa yeƴƴitii, wi'i Petruusu: «Yilto ɓaawo an, yo Ibuliisa, ɓay an ko a fegginoowo lan! Ko fii miijooji maa ɗin hinaa ɗi Alla, kono ko ɗi yimɓe ɓen!» ");
INSERT INTO fuf_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Onsay Iisaa wi'i taalibaaɓe mun ɓen: «Kala faalaaɗo jokkude lan, yo o hayfintino, o ƴetta *leggal makko altindiraangal ngal, o jokkammi. ");
INSERT INTO fuf_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Kala faalaaɗo dandude ngurndan mun, ɗan hayriray mo, kono kala non mo ngurndan mun hayriraa sabu an min, o hettay ɗan. ");
INSERT INTO fuf_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","E ko nafa honɗun woodani neɗɗo heɓugol aduna on fow, hayra wonkii mun kin? Maa ko honɗun neɗɗo ittata fii sottugol wonkii mun kin? ");
INSERT INTO fuf_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ko fii Ɓii-Aaden on ardoyay e mangural Ben mun ngal, wondude e malaa'ikaaɓe mun ɓen, o jonnita mo kala njoddi kuuɗe mun. ");
INSERT INTO fuf_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ka haqiiqa mi andinii on, no woodi woɓɓe e mon onon wonɓe ɗoo ɓen, ɓe maayataa ado ɓe yi'ude Ɓii-Aaden on no arda e laamu mun ngun.» ");
INSERT INTO fuf_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Balɗe jeegoo ɓawto ɗun, Iisaa ƴetti Petruusu e Yaaquuba e Yuuhanna neene-gooto Yaaquuba on, o naɓi ɓe kamɓe tun e hoore fello toowungo. ");
INSERT INTO fuf_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Mbaadi makko ndin waylii yeeso maɓɓe, yeeso makko ngon jalbiri wa naange, conci makko ɗin kadi rawniri wa ndaygu. ");
INSERT INTO fuf_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Muusaa e Iiliiya feeɲani ɓe, tawi hiɓe yewtida e makko kanko Iisaa. ");
INSERT INTO fuf_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Onsay Petruusu ƴetti haala kan, o wi'i Iisaa: «Koohoojo, no moƴƴi ka wonen ɗoo. Si hiɗon faalaa toode mi darnay ɗoo togooji tati, onon wonndu, Muusaa wonndu, Iiliiya kadi wonndu.» ");
INSERT INTO fuf_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Wa fewndo ko o wowlata ɗun, duulere jalbunde tippii buumi ɓe. Onsay hawa yalti ka duulere, wi'i: «Oo ɗoo ko Ɓiɗɗo an yiɗaaɗo, mo mi weltori on. Heɗitee mo!» ");
INSERT INTO fuf_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ɓay wonii kamɓe taalibaaɓe ɓen ɓe nanii ɗun, ɓe heɓi kulol tiiɗungol, ɓe suuyi, ɓe sujji. ");
INSERT INTO fuf_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Kono Iisaa ɓadii, meemi ɓe, o wi'i: «Immee! Wota on hulu!» ");
INSERT INTO fuf_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Onsay ɓe ɓanti gite ɗen, ɓe tawi ɓe yi'itaali hay gooto, si hinaa Iisaa tun. ");
INSERT INTO fuf_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","E nder ko ɓe tippotoo kon ka fello, Iisaa yamiri ɓe, wi'i: «Wota on wowlan hay gooto fii ko yi'uɗon kon, haa nde *Ɓii-Aaden on immintinaa e hakkunde mayɓe ɓen woo.» ");
INSERT INTO fuf_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Onsay taalibaaɓe ɓen landii mo, ɓe wi'i: «Ko fii honɗun jannooɓe fii Sariya on ɓen wi'anta wonde ko Iiliiya haani arude taho?» ");
INSERT INTO fuf_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","O jaabii ɓe, o wi'i: «Ko goonga Iiliiya aray, wattitoo fow. ");
INSERT INTO fuf_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Kono mi andinii on Iiliiya ariino, kono ɓe anditaali mo, ɓe waɗiri mo no ɓe faaliraa non. Ko wano non kadi ɓe tampinirta Ɓii-Aaden on.» ");
INSERT INTO fuf_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Onsay taalibaaɓe ɓen faami wonde ko fii Yaayaa lootaynooɗo maande tuubuubuyee on o yewti ɓe. ");
INSERT INTO fuf_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ɓay wonii ɓe hewtii takko jamaa on, onsay gorko goo ari jiccii yeeso Iisaa, o wi'i: ");
INSERT INTO fuf_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","«Koohoojo, yurminee ɓiɗɗo an on. Ko o iirotooɗo, himo tampi fota. Soono woo o yanay ka yiite e ka ndiyan. ");
INSERT INTO fuf_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Mi addii mo ka taalibaaɓe mon ɓen, kono ɓe waawaali mo ɲawndude.» ");
INSERT INTO fuf_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Iisaa jaabii, wi'i: «Onon ko on jamaanu ɓoyliingu ngu gomɗinaa. Ko haa honde tuma mi wondata e mon? E ko haa honde tuma mi muɲɲantoo on? Addanee lan mo ɗoo.» ");
INSERT INTO fuf_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Iisaa toŋani jinnawii ngin, ngii yalti e paykun kun, kun ndikki e on saa'i tigi. ");
INSERT INTO fuf_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Onsay taalibaaɓe ɓen gundii Iisaa, wi'i mo: «Ko fii honɗun menen men waawaali raɗaade ngii jinnawii?» ");
INSERT INTO fuf_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Iisaa jaabii ɓe, wi'i: «Ko sabu ko gomɗinal mon ngal fanɗi kon. Ko fii ka haqiiqa mi andinii on, hay si tawii gomɗinal mon ngal no fota e abbere bene, si on wi'iino ngoo fello: ‹Iwu ɗoo!›, ngo iwayno. Harayno hay huunde alaa ko ronkaynoɗon. ");
INSERT INTO fuf_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Kono sifa ngii jinnawii, ko toraare Alla e hoorugol tun yaltinta ngii.» ");
INSERT INTO fuf_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ɲande goo tawi Iisaa e taalibaaɓe mun ɓen no mottondiri Jaliilu, o wi'i ɓe: «Ɓii-Aaden on wattete e juuɗe yimɓe ɓen, ");
INSERT INTO fuf_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ɓe wara mo, ka ɲalaande tammere o immintinoyee.» Ɗun aanini ɓe fota. ");
INSERT INTO fuf_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Fewndo ko ɓe naatata Kafernahuum, ƴantooɓe sagalle fii *juulirde mawnde nden ari, ɓe tawi Petruusu, ɓe landii mo, ɓe wi'i: «E hara karamoko mon yoɓataa sagalle fii juulirde mawnde nden?» ");
INSERT INTO fuf_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Kono o jaabii ɓe, o wi'i: «Oo'o, ɓe yoɓay!» Ɓay wonii Petruusu naatii ka suudu, Iisaa attii mo landaade, o wi'i: «Sim'uunu, ko honɗun sikkuɗaa? Ko hombo lamɓe leydi ƴantata sagalle? Ko ɓiɓɓe maɓɓe ɓen kaa ko heddiiɓe ɓen?» ");
INSERT INTO fuf_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","O jaabii mo, o wi'i: «Ko heddiiɓe ɓen.» Iisaa wi'i mo: «Awa yoɓugol ɗun fawaaki ɓiɓɓe ɓen kan. ");
INSERT INTO fuf_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Kono fii wota en mettin ɓerɗe ɓen ƴantooɓe sagalle, yahu ka weendu, bugoɗaa ndolinwal maa ngal ka ndiyan, nangaa lingii adiingii moɗude ngin, udditaa hunduko maggii on, a taway ton tammaaru kaalisi ndu mbuuɗi nay. Ƴettaa ndu, jonnaa ɓen ƴantooɓe fii sagalle men ɗen enen ɗiɗo.» ");
INSERT INTO fuf_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","E on saa'i ɗon taalibaaɓe ɓen ɓadii mo kanko Iisaa, ɓe wi'i mo: «Ko hombo ɓuri teddude ka laamu kammu ngun?» ");
INSERT INTO fuf_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Onsay Iisaa noddi paykun, o joɗɗini kun hakkunde maɓɓe, ");
INSERT INTO fuf_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","o wi'i: «Ka haqiiqa mi andinii on, si on waylaali jikku mon on, wa'on wa paykoy, on naatataa few ka laamu kammu. ");
INSERT INTO fuf_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ko ɗun waɗi, kala jippinɗo hoore mun, wa'i wa kun paykun ɗoo, o wonay ɓurɗo teddude on ka laamu kammu. ");
INSERT INTO fuf_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Awa kadi kala jaɓuɗo paykun wa kun ɗoo, e innde an, haray ko min tigi o jaɓi. ");
INSERT INTO fuf_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Kono on mo woni sabu feggingol gokkun e koy paykoy gomɗinkoy lan, haray ko ɓuri mo moƴƴande ko kolmbireede tuntere hayre, o bugee ka ndanka baharu. ");
INSERT INTO fuf_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","«Bone wonanii oo aduna sabu ɗii piiji fegginayɗi. Ko fii bee pegge waɗa, kono bone wonanii on neɗɗo wonɗo sabu haa ɗun waɗi! ");
INSERT INTO fuf_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Si tawii jungo maa ngon maa koyngal maa ngal wonay sabu ko feggin-maa, haray taƴu ɗe, bugoɗaa ka woɗɗiti-maa. Ko fii no ɓuru-maa moƴƴande ka naataa ka ngurndan, hara ko a taƴa-jungoojo maa taƴa-koyngaljo, edii a jogaade koyɗe ɗiɗi maa juuɗe ɗiɗi bugeɗaa ka yiite poomayankeewe. ");
INSERT INTO fuf_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Si tawii-le ko yiitere maa nden wonata sabu ko feggin-maa, haray awu nde, bugoɗaa ka woɗɗiti-maa. Ko fii no ɓuru-maa moƴƴande ka naataa ka ngurndan hara ko mo a yiitere wootere, edii a jogaade gite ɗiɗi, bugeɗaa ka yiite jahannama.» ");
INSERT INTO fuf_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","«Wota on hayfin hay gootun e koy paykoy. Ko fii mi andinii on, malaa'ikaaɓe makkoy on ka kammu no darii tabiti yeeso Ben an Wonɗo ka kammu on. ");
INSERT INTO fuf_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ko fii ko addi *Ɓii-Aaden on, ko fii dandugol majjuɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","«Ko honɗun sikkuɗon? Si goɗɗo no mari baali teemedere, si gootii e ɗin majjii, e hara o accataa ɗiya cappanɗe jeenay e jeenay ka hoore fello, o ɗaɓɓitoya ngiya majjungii? ");
INSERT INTO fuf_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Si o aru ngii e yiitude, ka haqiiqa mi andinii on, o weltoray ngii ɓuri ɗiya cappanɗe jeenay e jeenay ɗi majjaali. ");
INSERT INTO fuf_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ko wano non, hinaa e sago Ben mon Wonɗo ka kammu on si gooto e ɓee fayɓe no majja.» ");
INSERT INTO fuf_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","«Si musiɗɗo maa fawɲike e maa, yahu yiidaa e makko, hara ko an tun kanko tun. Si o jaɓanii ma, haray a hettii musiɗɗo maa on. ");
INSERT INTO fuf_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Kono si o jaɓanaali ma, haray ɗaɓɓu gooto maa ɗiɗo, wattidaa e maa, fii kala ko yewtaa yo ɲaawiroye konguɗi seedeeɓe ɗiɗo maa tato. ");
INSERT INTO fuf_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Si o jaɓanaali ɓenɗon kadi, haray yeeto *moftal ngal. Si o jaɓanaali non moftal ngal kadi, haray yo o jogore wa mo gomɗinaa maa wa ƴantiroowo sagalle janfa. ");
INSERT INTO fuf_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","«Ko fii ka haqiiqa mi andinii on, ko toŋuɗon ka leydi woo haray toŋaama ka kammu, e ko jaɓuɗon ka leydi woo haray jaɓaama ka kammu. ");
INSERT INTO fuf_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ka haqiiqa mi andinii on kadi, si ɗiɗo e hakkunde mon nanondirii ka hoore leydi fii toragol kala ko woni, Ben an Wonɗo ka kammu on okkay ɓe ɗun. ");
INSERT INTO fuf_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ko fii ka ɗiɗo maa tato mottondiri e innde an woo, haray miɗo hakkunde maɓɓe.» ");
INSERT INTO fuf_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Onsay Petruusu ɓadii, wi'i mo: «Koohoojo, ko haa laabi jelu mi haani yaafaade musiɗɗo an, si himo fawɲaade e an? Ko haa laabi jeeɗiɗi?» ");
INSERT INTO fuf_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Iisaa jaabii mo: «Mi wi'aali ma dey ko haa laabi jeeɗiɗi, kono ko haa cappanɗe jeeɗiɗi laabi jeeɗiɗi. ");
INSERT INTO fuf_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ko ɗun waɗi, laamu kammu ngun no wa'i wa lanɗo faalanooɗo yo jiyaaɓe mun hunito ɗun. ");
INSERT INTO fuf_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","No on lanɗo fuɗɗornoo, ɓe addani mo goɗɗo joganiiɗo mo ujune kaalisi. ");
INSERT INTO fuf_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Nde tawnoo alaa ko o yoɓira, jom makko yamiri yo o yeeyite, kanko e ɓeyngu makko e ɓiɓɓe makko ɓen e kala ko o joginoo, ɲamaande nden yoɓee. ");
INSERT INTO fuf_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","«Onsay jiyaaɗo on suuyi ka leydi, jiccii yeeso makko, wi'i: ‹Koohoojo, muɲɲanee lan, mi yoɓay on fow!› ");
INSERT INTO fuf_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Jom makko yurmaa mo, o yaafanii mo ɲamaande nden, o acciti mo, o yahi. ");
INSERT INTO fuf_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","«Ko on jiyaaɗo yaltata ɗon, o yiidi e ɗimmoojo makko goo, joganiiɗo mo *dinaruuji teemedere. O nangi mo, o ɗeɗɗi, e hoore himo wi'a: ‹Yoɓan ko joganiɗaa mi kon!› ");
INSERT INTO fuf_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","On ɗimmoojo makko yani e ley koyɗe makko, jeeji mo, wi'i: ‹Muɲɲano lan, mi yoɓete!› ");
INSERT INTO fuf_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Kono o jaɓaali. O naɓi mo, o sokoyi haa o yoɓa mo ko o joganii mo kon. ");
INSERT INTO fuf_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ɓay ɗimmooɓe makko ɓen yi'ii kon ko waɗi, ɓe aani fota, ɓe yahi, ɓe fillitanii jom maɓɓe ko waɗi kon fow. ");
INSERT INTO fuf_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","«Onsay jom maɓɓe noddi on jiyaaɗo, o wi'i mo: ‹Ko an, yo jiyaaɗo bonɗo, mi yaafanike ma ɲamaande maa nden fow, ɓay a jeejii lan. ");
INSERT INTO fuf_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","An kadi a waawataano yurmeede ɗimmoojo maa on, wano mi yurmira-maa non?› ");
INSERT INTO fuf_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Jom makko tikki, o wattidi mo e lettooɓe ɓen haa nde o yoɓi ko o ɲawlii kon fow woo. ");
INSERT INTO fuf_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ko nii Ben an Kammuyankeejo on waɗirta on, si mo kala e mon yaafanaaki musiɗɗo mun on ka ɓernde mun.» ");
INSERT INTO fuf_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ɓay wonii Iisaa gaynii ɗin yewtereeji, o iwi Jaliilu ɗon, o ari ka seraaji diiwal Yahuuda gaɗa Yurdayniwol. ");
INSERT INTO fuf_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Jamaa moolanaaɗo jokki mo. O sellini ɓe ɗon. ");
INSERT INTO fuf_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Onsay *Fariisiyaaɓe goo ɓadii mo fii ndarndagol mo, ɓe wi'i: «E hara no daganii goɗɗo accitugol ɓeyngu mun fii ko woni woo?» ");
INSERT INTO fuf_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","O jaabii ɓe, o wi'i: «On jangaali wonde ka fuɗɗoode, Taguɗo on tagii ɓe, o waɗi ɓe gorko e debbo, ");
INSERT INTO fuf_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","o daali: ‹Ko ɗun waɗi si gorko selay ben mun e yumma mun, humoo e ɓeyngu mun, onsay kamɓe ɗiɗo ɓe wona gooto.› ");
INSERT INTO fuf_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ɗun haray hinaa ɓe ɗiɗo hande kadi, kono ko gooto. Awa wota goɗɗo sendindir ko Alla hawtindiri kon.» ");
INSERT INTO fuf_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Kono Fariisiyaaɓe ɓen landii mo, wi'i: «Ko honɗun non Muusaa yamirani accitoowo ɓeyngu mun woo yo waɗan mo kaydi sertigal, si o accita mo?» ");
INSERT INTO fuf_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Kanko Iisaa o jaabii ɓe, o wi'i: «Ko sabu cattal mon ɓernde ngal waɗi si Muusaa newnani on accitugol rewɓe mon ɓen, kono ka fuɗɗoode hari hinaa non. ");
INSERT INTO fuf_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Kono mi andinii on, kala accituɗo ɓeyngu mun ƴetti goɗɗo goo, si wonaa hara on jeenu, haray ontigi jeenii.» ");
INSERT INTO fuf_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Onsay taalibaaɓe makko ɓen wi'i mo: «Si tawii ko nii woniri hakkunde gorko e debbo, haray nafa alaa himo tigga.» ");
INSERT INTO fuf_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","O jaabii ɓe, o wi'i: «Wonaa fow jaɓata ngol kongol, kono ko yeɗaaɓe ɗun ɓen tun. ");
INSERT INTO fuf_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ko fii no woodi mayraaɓe hara ko heɓidaaɓe e mun, no woodi woɓɓe kadi hara ko ɓe ɓujaaɓe, no woodi woɓɓe kadi hara ko ruuɗiiɓe fii laamu kammu ngun. On waawuɗo jaɓude yo jaɓu!» ");
INSERT INTO fuf_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Onsay yimɓe ɓen addani mo paykoy, fii yo o *fawu juuɗe makko ɗen e makkoy, o du'anoo koy, kono taalibaaɓe ɓen toŋani ɓen. ");
INSERT INTO fuf_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Iisaa wi'i: «Tertee paykoy koy, wota on haɗu koy arugol e an, ko fii laamu kammu ngun ko sifa makkoy wonani.» ");
INSERT INTO fuf_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Onsay o fawi juuɗe makko ɗen e makkoy, o du'anii koy, o iwi ɗon. ");
INSERT INTO fuf_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Goɗɗo goo kadi ɓadii Iisaa, wi'i mo: «Karamoko, hara ko honɗun e ko moƴƴi mi haani waɗude fii yo mi heɓoy *ngurndan poomayankejan ɗan?» ");
INSERT INTO fuf_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Onsay Iisaa jaabii mo, wi'i: «Ko fii honɗun landortaa mi fii ko moƴƴi kon? Ko gooto pet moƴƴi. Si hiɗa faalaa naatude aljanna, ɗofto yamirooje ɗen.» ");
INSERT INTO fuf_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","O jaabii: «Honɗe?» Iisaa jaabii mo: «Wota a ittu hoore, wota a jeenu, wota a seedito fenaande, wota a wujju, ");
INSERT INTO fuf_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","teddinaa kadi yumma maa e ben maa, yiɗiraa ɲokondo maa on wano yiɗirɗaa hoore maa non.» ");
INSERT INTO fuf_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","On suka wi'i mo: «Miɗo waɗude ɗun fow. E hara ko honɗun ŋakkanimmi kadi?» ");
INSERT INTO fuf_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Iisaa wi'i mo: «Si hiɗa faalaa wonude timmuɗo, yahu yeeyitaa ko marɗaa kon, okkaa miskinɓe ɓen, ɗun wonanoyte keyee ka kammuuli, onsay araa jokkaa mi.» ");
INSERT INTO fuf_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ɓay on suka nanii ɗin konguɗi, o yahi himo aani, ko fii hari himo alɗi fota. ");
INSERT INTO fuf_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Onsay Iisaa wi'i taalibaaɓe mun ɓen: «Ka haqiiqa mi andinii on, no sattani jom jawle ka o naata ka laamu kammu. ");
INSERT INTO fuf_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Mi andinii on kadi, no ɓuri weeɓande ngelooba ka mba rewa e wuddere meselal edii ka jom jawle naata ka *laamu Alla.» ");
INSERT INTO fuf_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ɓay taalibaaɓe ɓen nanii ɗun, ɓe ŋalɗi fota, ɓe wi'i: «E hara ko hombo dandoytee?» ");
INSERT INTO fuf_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Iisaa ndaari ɓe, wi'i: «Ɗun waawantaako neɗɗanke, kono fow no waawanoo Alla.» ");
INSERT INTO fuf_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Onsay Petruusu ƴetti haala kan, wi'i mo: «Awa e hino, men accii ko men jeyi kon fow, men jokkii on. Ko honno non woniranoyta men?» ");
INSERT INTO fuf_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Iisaa jaabii ɓe, wi'i: «Ka haqiiqa mi andinii on, nde *Ɓii-Aaden on jooɗii ka jullere mun laamu darjinnde, tuma nde kala huunde no heyɗintinee, onon jokkunooɓe lan ɓen kadi, on jooɗoyto e julle laamu sappoo e ɗiɗi, laamoyoɗon *bolondaaji Isra'iila ɗin sappoo e ɗiɗi. ");
INSERT INTO fuf_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Awa kadi kala accuɗo suudu mun ndun e musiɓɓe mun ɓen e bandiraaɓe mun ɓen e yumma mun e ben mun e ɓiɓɓe mun ɓen e gese mun ɗen sabu innde an nden, o heɓoyay ko ɓuri ɗun laabi teemedere ka aduna ɗoo, o ronoyay kadi ngurndan poomayankejan ɗan. ");
INSERT INTO fuf_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Kono wonɓe yeeso buy wontiroyay ɓaawo, ɓaawooɓe ɓen wontiroya yeeso.» ");
INSERT INTO fuf_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","«Ko fii laamu kammu ngun no wa'i wa jom galle, yaltuɗo bimbi law fii ƴettugol gollooɓe ko golla ka ngesa mun *wiiɲu. ");
INSERT INTO fuf_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ɓe fotti e njoddi, ɲallal kala *dinaruuru. Onsay o immini ɓe ka ngesa makko wiiɲu. ");
INSERT INTO fuf_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","O yaltoyi ka walluhaa, o yi'i woɓɓe ka fottirde, tawi ɓen alaa waɗude hay huunde. ");
INSERT INTO fuf_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","O wi'i ɓen: ‹Onon kadi yahee ka ngesa an wiiɲu, mi yoɓiray on no haaniri.› Ɓen yahi. ");
INSERT INTO fuf_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","O yaltoyi kadi ka ado fanaa e ka ɓaawo fanaa, o waɗiri wano non. ");
INSERT INTO fuf_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","O yaltoyi kadi ka alansaraa, o tawi woɓɓe ka fottirde kadi, o wi'i ɓen: ‹Ko fii honɗun ɲallanɗon ɗoo, hay huunde on alaa waɗude?› ");
INSERT INTO fuf_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ɓen jaabii mo, ɓe wi'i: ‹Ko fii men heɓaali golle.› O wi'i ɓen kadi: ‹Awa, yahee ka ngesa an wiiɲu.› ");
INSERT INTO fuf_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","«Ɓay niɓɓii, jom ngesa wiiɲu mban wi'i mbatulaajo mun on: ‹Noddu gollooɓe ɓen, yoɓaa ɓe njoddi maɓɓe ndin. Fuɗɗoraa ƴettaaɓe sakkitorun ɓen, sakkitoraa adaaɓe ƴetteede ɓen.› ");
INSERT INTO fuf_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ƴettaaɓe ka alansaraa ɓen ari, mo kala e maɓɓe hendii dinaruuru. ");
INSERT INTO fuf_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Attaaɓe ƴetteede ɓen kadi ari, e hoore no sikka heɓay ko ɓuri ɗun. Kono kamɓe kadi mo bee e maɓɓe hendii dinaruuru. ");
INSERT INTO fuf_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ɓay ɓe hendike, ɓe ŋurŋurti jom galle on, ");
INSERT INTO fuf_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ɓe wi'i: ‹Ɓee sakkitiiɓe arude ko saa'i gooto pet golli! A fonnii ɓe e amen, menen ɓee tuɗiiɓe yangi e nguleendi ɲallal ngal peetu?› ");
INSERT INTO fuf_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","O jaabii goɗɗo e maɓɓe, o wi'i: ‹Njaatigi an, mi janfaaki ma, hinaa en fottuno dinaruuru? ");
INSERT INTO fuf_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ƴettu ko maa kon, yahaa. Ko e yiɗi an waɗi si miɗo jonnude sakkitiiɗo arude on wa ko maa kon. ");
INSERT INTO fuf_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","E hara mi newnanaaka waɗirgol ko mi jeyi kon no mi faaliraa woo? Kaa ko fii miɗo moƴƴi ndaarirtaa mi gite bonɗe?› ");
INSERT INTO fuf_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","«Ko wano nii kadi ɓaawooɓe ɓen wontiroyta yeeso, yeesooɓe ɓen kadi wontiroya ɓaawo.» ");
INSERT INTO fuf_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Fewndo ko ɓe yahata Yerusalaam, Iisaa pottini taalibaaɓe mun ɓen sappoo e ɗiɗo sera, o wi'i ɓe: ");
INSERT INTO fuf_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«Awa hiɗen yahude Yerusalaam. Ɓii-Aaden on wattete e juuɗe hooreeɓe *yottinooɓe sadaka ɓen e jannooɓe fii Sariya on ɓen, ɓe happana mo wareede. ");
INSERT INTO fuf_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ɓe watta mo e juuɗe ɓe wonaa Yahuudiyanke ɓen, ɓen jala mo, ɓe focca mo, ɓe fempa. Ɓawto ɗun o immintinoyee ka ɲalaande tammere.» ");
INSERT INTO fuf_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Onsay yumma fayɓe Zabadii ɓen e ɓiɓɓe mun ɓen ɓadii Iisaa, ɓe jiccii fii toragol mo. ");
INSERT INTO fuf_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Kanko Iisaa o wi'i mo: «Ko honɗun faalaɗaa?» Kanko debbo on o jaabii mo, o wi'i: «Yamiree yo ɓee ɓiɓɓe an ɗoo ɗiɗo jooɗoyo ka laamateeri mon, goɗɗo on wonira ka ɲaamo mon, oya on ka nano mon.» ");
INSERT INTO fuf_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Iisaa jaabii ɓe, wi'i: «On andaa ko wonɗon lan toraade. E hara on waaway yarirde jardukun tampere kun mi yarirta kun?» Ɓe jaabii: «Men waaway.» ");
INSERT INTO fuf_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","O wi'i ɓe: «Ko goonga on yariray jardukun an kun. Kono fii jooɗoyagol ka ɲaamo an maa ka nano an, hinaa min yeɗata ɗun, kono ko Ben an yeɗata ɗun ɓe o eɓɓani fii ɗun ɓen.» ");
INSERT INTO fuf_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ɓay ɓeya taalibaaɓe sappo nanii ɗun, ɓe seytinani ɓen neene-gootooɓe ɗiɗo. ");
INSERT INTO fuf_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Onsay Iisaa noddi ɓe, o wi'i: «Hiɗon andi hooreeɓe ɗiya leƴƴi no laamori ɗi doole, awa kadi lamɓe maɓɓe ɓen no feƴƴintini laamu ngun e hoore maɓɓe. ");
INSERT INTO fuf_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Kono onon, wota on wa'u wa ɓen. Kala faalaaɗo wonde tedduɗo e hakkunde mon, yo wonu kurkaadu mon. ");
INSERT INTO fuf_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Awa kadi kala faalaaɗo wonde yeesoojo e hakkunde mon, yo wonu maccuɗo mon. ");
INSERT INTO fuf_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ko wano non, *Ɓii-Aaden on ardaali fii kurkanegol, kono ko fii kurkanagol, okkitira ngurndan mun ɗan fii cottudi ɗuuɗuɓe.» ");
INSERT INTO fuf_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ɓay wonii ɓe yaltii Yeerikoo, jamaa ɗuuɗuɗo jokki mo kanko Iisaa. ");
INSERT INTO fuf_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Tawi bumɓe ɗiɗo no jooɗii ka sera laawol. Ɓe nani wonde Iisaa no feƴƴude, ɓe ewnii, ɓe wi'i: «Yurminee men, yo Koohoojo, ɓii Daawuuda!» ");
INSERT INTO fuf_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Jamaa on feli ɓe fii yo ɓe fanku. Kono ɓe ɓurti ewnaade, wi'a: «Yurminee men, yo Koohoojo, ɓii Daawuuda!» ");
INSERT INTO fuf_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Onsay Iisaa dartii, o noddi ɓe, o wi'i: «Ko honɗun faalaɗon yo mi waɗan on?» ");
INSERT INTO fuf_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ɓe wi'i mo: «Ko yo men wuntu, yo Koohoojo!» ");
INSERT INTO fuf_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Iisaa yurmaa ɓe, o meemi gite maɓɓe ɗen. Ɓe wunti kisan, ɓe jokki mo. ");
INSERT INTO fuf_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ɓay wonii ɓe ɓadike Yerusalaam haa ɓe hewtii Bayti-Faazii, ɗun ko takko Fello *Zaytuuni ngon, kanko Iisaa o nuli taalibaaɓe makko ɗiɗo, ");
INSERT INTO fuf_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","o wi'i ɓe: «Yahee e ngoo hoɗo wongo yeeso mon ɗoo, on taway ɗon kisan mbabba no humii, hara himba wondi e mbabun mabba. Hunton ɗi, addanon mi. ");
INSERT INTO fuf_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Si goɗɗo aru on e landaade goɗɗun, on wi'ay mo: ‹Ko haaju Koohoojo on yani e majji.› Onsay o accay ɗi ara.» ");
INSERT INTO fuf_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ɗun waɗiri fii ko daaliranoo annabaajo on kon no laatora: ");
INSERT INTO fuf_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«Wi'u jamaa *Siyuuna on: ‹E hino lanɗo maa on ka arata e maa, himo waɗɗii mbabba, himo ƴawi e hoore mbabun keccun, e hoore ɓikkun mbabba, himo heewi newaare.› » ");
INSERT INTO fuf_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Taalibaaɓe ɓen yahi, waɗi ko Iisaa yamiri ɓe kon. ");
INSERT INTO fuf_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ɓe addoyi mbabba mban e mbabun mabba on. Ɓe ndaɗɗani mo conci maɓɓe ɗin e hoore majji, o jooɗii ɗon. ");
INSERT INTO fuf_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Tawi yimɓe ɗuuɗuɓe e nder jamaa on no ndaɗɗanaynoo mo conci mun ɗin ka laawol, woɓɓe ɓen taƴa calɗi leɗɗe ɗen, ndaɗɗana mo ka laawol. ");
INSERT INTO fuf_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Tawi jamaa hikkornooɗo yeeso e iwtirnooɗo ɓaawo Iisaa on no ewnaade, wi'a: «Hosannaa*, yo ɓii Daawuuda! Yo barki wonan oo wonɗo arude e innde Joomiraaɗo on, darja ɓurɗo toowude wonanii ma.» ");
INSERT INTO fuf_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ɓay wonii o naatii Yerusalaam, saare nden fow memminii, wi'i: «Ko hombo woni oo?» ");
INSERT INTO fuf_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Jamaa on jaabii, wi'i: «Ko annabi Iisaa oo jeyaaɗo Naasirata, ɗun ko e nder Jaliilu.» ");
INSERT INTO fuf_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ɓay wonii Iisaa naatii ka dingiral *juulirde mawnde, o raɗii yeeyaynooɓe ton ɓen fow e soodaynooɓe ɓen. O wayliti taabe waɗaynooɓe sensa-sensita ɓen, e julle yeeyaynooɓe gabooji ɓen, ");
INSERT INTO fuf_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","hara himo wi'ora ɓe: «No windii: ‹Suudu an ndun innoyte suudu torordu Alla›, kono onon on wattii ndu fammeere wuyɓe!» ");
INSERT INTO fuf_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Tawi bumɓe e laƴooɓe no ɓadaade mo ka juulirde, o sellina ɓe. ");
INSERT INTO fuf_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Kono ɓay hooreeɓe *yottinooɓe sadaka ɓen e jannooɓe fii Sariya on ɓen yi'ii kaawakeeji moƴƴi ɗi o waɗi ɗin, e ko fayɓe ɓen ewnotoo kon ka juulirde mawnde wi'a «Hosannaa*, yo ɓii Daawuuda», ɓe seytini, ");
INSERT INTO fuf_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ɓe wi'i mo: «A nanii ko ɓe woni wi'ude kon?» Iisaa jaabii ɓe: «Hiiyii, e hara haa hande on jangaali ɗii konguɗi wonde: ‹Ko kundule fayɓe ɓen e muynooɓe ɓen heɓirtaa mantoore?› » ");
INSERT INTO fuf_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","O acci ɓe ɗon, o yalti saare nden, o yahi *Betanii, o waali ton. ");
INSERT INTO fuf_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ko Iisaa yiltitotoo ka saare bimbi, o weelaa. ");
INSERT INTO fuf_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","O yi'i ƴibbehi ka laawol, o ɓadii ki. Kono ko kaaki tun o tawi e makki. Onsay o wi'i ki: «A rimitataa hande kadi.» E on saa'i ɗon kisan ƴibbehi kin yoori. ");
INSERT INTO fuf_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ɓay taalibaaɓe ɓen yi'ii ɗun, ɓe ŋalɗi, ɓe wi'i: «Ko honno kii ƴibbehi yooriri kisan?» ");
INSERT INTO fuf_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Onsay Iisaa jaabii ɓe, wi'i: «Ka haqiiqa mi andinii on, si tawii hiɗon gomɗini, hara on sikkitaaki, wonaa ko waɗaa e kii ƴibbehi kon tun waɗoton. Kono kadi, si on wi'ii ngoo fello yo ngo ɓoro ɗoo, ngo yaha ka baharu, ɗun waɗay. ");
INSERT INTO fuf_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Kala ko landorɗon gomɗinal e nder toragol Alla, on heɓay.» ");
INSERT INTO fuf_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ɓawto ɗun Iisaa naati ka juulirde mawnde. E nder ko o jannata kon, hooreeɓe yottinooɓe sadaka ɓen e mawɓe jamaa on ari, wi'i mo: «Ko e ley kongol hombo wonɗaa waɗude ɗun, e ko e ley kongol hombo wonɗaa?» ");
INSERT INTO fuf_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Iisaa jaabii ɓe, wi'i: «Min kadi mi landoto on huunde wootere. Si on jaabike lan, onsay mi yeetoto on ko e ley kongol hombo mi woni waɗirde ɗun. ");
INSERT INTO fuf_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","E hara lootugol ko Yaayaa lootaynoo yimɓe ɓen kon, ko honto iwri: ko ka arsi, kaa ko e neɗɗanke?» Kono ɓe wi'indiri: «Si en jaabike mo ko ka arsi iwri, o wi'ay en ko honɗun haɗunoo gomɗinen mo? ");
INSERT INTO fuf_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Si en jaabike mo-le ko e neɗɗanke ɗun iwri, haray hulen jamaa on.» (Ko fii fow no jogori Yaayaa wa annabaajo.) ");
INSERT INTO fuf_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Onsay ɓe jaabii Iisaa: «Men andaa!» Kanko kadi o wi'i ɓe: «Min kadi mi wowlantaa on ko e ley kongol hombo mi woni waɗirde ɗun.» ");
INSERT INTO fuf_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Iisaa wi'i ɓe kadi: «Ko honɗun miijiɗon e ɗunɗoo? Hari goɗɗo no mari ɓiɓɓe ɗiɗo. O wi'i arano on e ɓen: ‹Ɓiɗɗo an, yahu golloyaa hande ka ngesa an *wiiɲu.› ");
INSERT INTO fuf_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","On jaabii mo wi'i: ‹Mi woniraa!› Ɓawto ɗun o ninsiti, o yahi ka ngesa. ");
INSERT INTO fuf_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ben maɓɓe ɓadii ɗimmo on kadi, o yamiriri on kadi wano non. Onɗon jaabii wi'i: ‹Miɗo woniri ɗun, yo baaben!› Kono o yahaali. ");
INSERT INTO fuf_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ko hombo e ɓen ɗiɗo waɗi faale baaba mun on?» Ɓe jaabii mo, ɓe wi'i: «Ko arano on.» Iisaa kadi wi'i ɓe: «Ka haqiiqa mi andinii on, ƴantirooɓe sagalle janfa ɓen e cagaaɓe ɓen attike on ka *laamu Alla. ");
INSERT INTO fuf_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ko fii Yaayaa ariino e laawol feewungol, ronkuɗon mo gomɗinde. Kono ƴantirooɓe sagalle janfa ɓen e cagaaɓe ɓen gomɗini mo. Onon non, ɓen yi'unooɓe ɗun, on tuubaano ɓawto ɗun, gomɗinɗon mo.» ");
INSERT INTO fuf_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","«Heɗee kadi misal goo: No woodunoo jom galleejo, tutunooɗo *wiiɲu. O howi tutateeri ndin, o jasi ngayka fii ka wiiɲu on oƴƴee, o waɗi bente ka reenoowo on wona, o halfini ndi remooɓe wiiɲu ɓen, o yahi safaari. ");
INSERT INTO fuf_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ɓay saa'i soɲitugol wiiɲu on hewtii, o immini kurkaaɗi makko haa e remooɓe wiiɲu ɓen fii yo ɓe jonnu ɓe ɓiɓɓe wiiɲu. ");
INSERT INTO fuf_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","«Kono ɓen remooɓe wiiɲu hendii ɗin kurkaaɗi, piyi goɗɗo on, wari oya, ɓe ferii goɗɗo goo kaaƴe. ");
INSERT INTO fuf_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","O immini kurkaaɗi makko goo kadi ɓurɓe ɓeya aranun ɗuuɗude, remooɓe wiiɲu ɓen waɗiri ɓenɗon kadi wano non. ");
INSERT INTO fuf_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ka sakkitorun o immini ɓiɗɗo makko on haa e maɓɓe, himo wi'a: ‹Ɓe teddinay ɓiɗɗo an on.› ");
INSERT INTO fuf_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Kono ɓay remooɓe wiiɲu ɓen yi'ii ɓiɗɗo on, ɓe wi'indiri: ‹Ko oo woni ronoowo on! Aree waren mo, ɗun en hendoto ndondi makko ndin.› ");
INSERT INTO fuf_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Onsay ɓe nangi mo, ɓe naɓi ka ɓaawo tutateeri wiiɲu, ɓe wari.» ");
INSERT INTO fuf_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Iisaa wi'i kadi: «Jooni non, nde jom tutateeri wiiɲu ndin ari, ko honɗun o waɗata ɓen remooɓe wiiɲu?» ");
INSERT INTO fuf_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ɓen hooreeɓe jaabii mo, ɓe wi'i: «O re'iray ɓen bonɓe no yurmiri, onsay o halfina tutateeri ndin remooɓe goo, hara ko jonnitooɓe mo ɓiɓɓe wiiɲu ɓen ka dabbunde.» ");
INSERT INTO fuf_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Onsay Iisaa wi'i ɓe: «E hara on jangaali haa hande ko bindi ɗin wi'i kon? Ko fii hiɗi wi'i wonde: ‹Hayre nde mahooɓe ɓen hawkunoo nden wontii hittunde ka soɓɓundu. Ɗun ko e Joomiraaɗo on iwri, ɗun no hawnii e gite men!› ");
INSERT INTO fuf_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","«Ko ɗun waɗi si mi wi'ay on, laamu Alla ngun ƴettitante on, ngu yeɗee jamaa waɗayɗo ko Alla yiɗi kon. ");
INSERT INTO fuf_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Awa kala yanuɗo e nden hayre, o lancoto, kala kadi mo nde yani e hoore mun, o muncoto.» ");
INSERT INTO fuf_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ɓay hooreeɓe yottinooɓe sadaka ɓen e *Fariisiyaaɓe ɓen nanii ɗen mise, ɓe andi ko fii maɓɓe Iisaa woni wowlude. ");
INSERT INTO fuf_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ɓe woni e ɗaɓɓugol feere no ɓe nangira mo, kono hari hiɓe huli jamaa on, ko fii hari jamaa on no jogori mo wa annabaajo. ");
INSERT INTO fuf_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Iisaa yewtiri ɓe kadi misal, o wi'i ɓe: ");
INSERT INTO fuf_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«Laamu Alla ngun no wa'i wa lanɗo, waɗuɗo caatal fii peera ɓiɗɗo mun. ");
INSERT INTO fuf_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","O nuli kurkaaɗi makko ɗin yo noddoy saatinaaɓe ɓen ka caatal. Kono tawi ɓen faalaaka arude. ");
INSERT INTO fuf_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","O nuli kadi kurkaaɗi goo, o wi'i: ‹Yahee wi'on saatinaaɓe ɓen: Mi eɓɓindike fii caate ɗen. Ga'oy an koy e daabeeji an fayuɗi ɗin hirsaama. Fow gasii. Aree ka caatal!› ");
INSERT INTO fuf_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Kono ɓe foygiti fii ngal caatal, ɓe yahi, oya on ka ngesa mun, goɗɗo on ka ngeygu mun. ");
INSERT INTO fuf_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ɓeya heddiiɓe nangi kurkaaɗi ɗin, tampini, wari. ");
INSERT INTO fuf_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Lanɗo on tikki. O immini suufaaɓe makko ɓen, o muloyi ɓen ittuɓe ko'e, o sunni saare maɓɓe nden. ");
INSERT INTO fuf_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Onsay o wi'i kurkaaɗi makko ɗin: ‹Caatal ngal fewndike, kono saatinanooɓe ɓen handaa e mun. ");
INSERT INTO fuf_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Jooni, yahee ka ɗate-cele, saatinon kala mo yi'uɗon ton ka caatal!› ");
INSERT INTO fuf_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Onsay kurkaaɗi makko ɗin yahi ka ɗate, ɓe mottindiri kala ɓe ɓe tawnoo ton, bonɓe e moƴƴuɓe, haa suudu ka caatal ngal waɗata ɗon heewi yimɓe. ");
INSERT INTO fuf_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ɓay lanɗo on arii yi'ugol aruɓe tawegol ɓen, o haynii ɗon goɗɗo mo ɓornaaki conci peera. ");
INSERT INTO fuf_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Lanɗo on wi'i mo: ‹Njaatigi an, ko honno waawirɗaa arude ɗoo, a ɓornaaki conci peera?› On neɗɗo fanki. ");
INSERT INTO fuf_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Onsay lanɗo on wi'i kurkaaɗi ɗin: ‹Haɓɓee mo juuɗe e koyɗe, bugoɗon mo ka niwre ka ɓuri woɗɗude, ka wullaandu e ŋatindiro ɲiiƴe woni ton!› ");
INSERT INTO fuf_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ko fii noddaaɓe ɓen no ɗuuɗi, kono ko seeɗaaɓe suɓaa.» ");
INSERT INTO fuf_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Onsay *Fariisiyaaɓe ɓen yahi, fewjodi fii no ɓe nangira Iisaa konguɗi makko ɗin. ");
INSERT INTO fuf_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ɓe immini e makko taalibaaɓe maɓɓe ɓen, e yimɓe *Heroodu ɓen, ɓen wi'i mo: «Karamoko, meɗen andi ko on nunɗuɓe, hiɗon jannirde laawol Alla ngol goonga, awa kadi on ɗenƴotaako hay gooto, ko fii on ɓurdindinaa yimɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Yeetee men jooni ko miijiɗon: E hara no haani ka men yoɓa lanɗo mawɗo Roomu on sagalle, kaa haanaa?» ");
INSERT INTO fuf_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Kono nde tawnoo Iisaa no andi miijooji maɓɓe bonɗi ɗin, o jaabii ɓe, o wi'i: «Ko fii honɗun ndarndorton mi, faasiqiiɓe? ");
INSERT INTO fuf_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Hollee lan wuundu yoɓeteendu sagalle.» Onsay ɓe yeeɓani mo *dinaruuru. ");
INSERT INTO fuf_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","O landii ɓe, o wi'i: «Ko nandolla hombo e bindi hombo woni e mayru?» ");
INSERT INTO fuf_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ɓe jaabii: «Ko lanɗo mawɗo Roomu on.» Onsay o wi'i ɓe: «Jonnitee lanɗo mawɗo Roomu on ko makko kon, jonniton Alla kadi ko mun kon.» ");
INSERT INTO fuf_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ɓe ŋalɗi fii kon ko ɓe nani, ɓe acci mo ɗon, ɓe yahi. ");
INSERT INTO fuf_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Nden ɲande tigi *Sadduusiyaaɓe, wi'uɓe wonde ummutal alaa ɓen, ari landii Iisaa, ");
INSERT INTO fuf_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","ɓe wi'i mo: «Karamoko'en, Muusaa no wi'i wonde si goɗɗo maayii, o accaali ɓiɓɓe, haray miɲɲiraawo makko on no haani ƴettude on keynguujo mo o acci, fii no o heɓirana on kotiraawo makko jurriya. ");
INSERT INTO fuf_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Tawi no woodunoo hakkunde amen ɓiɓɓe njeeɗiɗo. Arano on jombi, maayi. Nde tawnoo o accaali jurriya, miɲan makko roni debbo on. ");
INSERT INTO fuf_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ɗimmo on kadi woniri wano non, tammo on kadi wano non, haa ɓe njeeɗiɗoo non ɓe timmi. ");
INSERT INTO fuf_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ɓawto maɓɓe ɓe fow, debbo on kadi maayi. ");
INSERT INTO fuf_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ɓay hari ɓen njeeɗiɗoo non resii on debbo, ko hombo e ɓen on debbo wontanoyta ka ummutal?» ");
INSERT INTO fuf_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Iisaa jaabii ɓe, wi'i: «Hiɗon e nder palji, ko fii on alaa faamude bindi ɗin, on alaa faamude kadi bawgal Alla ngal. ");
INSERT INTO fuf_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ko fii ka ummutal, worɓe ɓen resataa, rewɓe ɓen kadi resetaake, kono ɓe wa'ay wa malaa'ikaaɓe ɓen ka kammuuli. ");
INSERT INTO fuf_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","E on jangaali ko Alla daalani on kon fii ummutal mayɓe ɓen, wonde: ");
INSERT INTO fuf_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‹Ko min woni Alla Ibraahiima e Alla Issaaqa e Alla Yaaquuba›? Awa Alla wonaa Alla mayɓe ɓen, kono ko o Alla wurɓe ɓen.» ");
INSERT INTO fuf_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Jamaa heɗinooɗo on ŋalɗi fii janndeeji ɗi Iisaa jannaynoo ɗin. ");
INSERT INTO fuf_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ɓay Fariisiyaaɓe ɓen humpitike wonde o fankinii Sadduusiyaaɓe ɓen, ɓe mottondiri. ");
INSERT INTO fuf_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Goɗɗo e maɓɓe, waawuɗo fii Sariya on, landii mo ɗunɗoo fii ndarndagol mo, o wi'i: ");
INSERT INTO fuf_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«Karamoko'en, ko yamiroore honde ɓuri mawnude ka Sariya?» ");
INSERT INTO fuf_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Iisaa jaabii mo, wi'i: «Yo a yiɗir Alla Joomiraaɗo maa on ɓernde maa nden fow e wonkii maa kin fow e hakkil maa kin fow. ");
INSERT INTO fuf_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ko ɗun woni yamiroore aranere nden e mawnde nden. ");
INSERT INTO fuf_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","E hino ɗimmere nden ko wa mayre: Yo a yiɗir ɲokondo maa on wano yiɗirɗaa hoore maa non. ");
INSERT INTO fuf_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ko e ɗee yamirooje ɗoo ɗiɗi Sariya on fow e annabaaɓe ɓen tippi.» ");
INSERT INTO fuf_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Nde tawnoo Fariisiyaaɓe ɓen no mooɓondiri, Iisaa landii ɓe ɗunɗoo, ");
INSERT INTO fuf_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","o wi'i: «Ko honɗun miijiɗon fii *Almasiihu on, ko o jurriya hombo?» Ɓe jaabii mo: «Ko Daawuuda.» ");
INSERT INTO fuf_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Onsay Iisaa wi'i ɓe: «Ko honno Daawuuda noddiri mo Joomi? Ɓay ko Ruuhu Allaahu on ardii mo fewndo o wi'i: ");
INSERT INTO fuf_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‹Joomiraaɗo on daalani Joomi an on: Jooɗor ka sengo an ɲaamo, haa mi waɗa ayɓe maa ɓen ka ley teppe maa.› ");
INSERT INTO fuf_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","«Si Daawuuda tigi wi'ii Almasiihu on ‹Joomi›, haray ko honno non Almasiihu on woniri jurriya makko?» ");
INSERT INTO fuf_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Laatii hay gooto waawaali mo jaabaade hay kongol. Gila nden ɲande hay gooto suusaali landaade mo. ");
INSERT INTO fuf_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Onsay Iisaa yewti jamaa on e taalibaaɓe mun ɓen, ");
INSERT INTO fuf_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","o wi'i: «Ko jannooɓe fii Sariya on ɓen e *Fariisiyaaɓe ɓen newnanaa jannugol fii Sariya Muusaa on. ");
INSERT INTO fuf_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Awa ɗoftee, waɗon kala ko ɓe wi'i on, hara on waɗiraali wa kuuɗe maɓɓe ɗen. Ko fii ɓe wowlay, hara ɓe waɗataa. ");
INSERT INTO fuf_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Hiɓe haɓɓa dolle tedduɗe, mettuɗe naɓude, ɓe fawa ɗe e hoore balbe yimɓe ɓen, hara kamɓe tigi ɓe faalaaka ɗe memminirde hay hoore hondu fii wallugol ɓe. ");
INSERT INTO fuf_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Kuuɗe maɓɓe ɗe ɓe waɗata ɗen fow ko fii yo yimɓe ɓen yi'an ɓe. Awa kadi hiɓe yaɲɲa *paaloy bindi maɓɓe koy, ɓe juutina binsanji conci maɓɓe. ");
INSERT INTO fuf_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Hiɓe yiɗi ndaɗɗule arane ɗen ka nafagol e saffeeji arani ɗin ka juulirɗe, ");
INSERT INTO fuf_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","e hiwreede ka fottirɗe. Hiɓe yiɗi kadi yo yimɓe ɓen noddir ɓe karamoko'en. ");
INSERT INTO fuf_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Kono onon, wota on waɗu haa noddeɗon karamoko, ko fii ko gooto woni Karamoko mon, onon on fow ko on musiɓɓe. ");
INSERT INTO fuf_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Awa kadi, wota on noddu hay gooto baaba ka hoore leydi ɗoo, ko fii ko gooto woni Ben mon, ɗun-le ko on Wonɗo ka kammu. ");
INSERT INTO fuf_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Wota on waɗu haa noddeɗon yeesoojo, ko fii ko gooto woni Yeesoojo mon on, on-le ko *Almasiihu on. ");
INSERT INTO fuf_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Yo ɓurɗo teddude on e hakkunde mon wonu kurkaadu mon. ");
INSERT INTO fuf_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ko fii mawnintiniiɗo woo jippinoyte, jippinɗo hoore mun woo kadi mawninoyte. ");
INSERT INTO fuf_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","«Bone wonanii on, yo faasiqiiɓe, ɗun ko onon jannooɓe fii Sariya on e Fariisiyaaɓe ɓen, ɓay hiɗon falande yimɓe ɓen laamu kammu ngun, hara on naatataa, on accataa faalaaɓe naatude ɓen naata. ");
INSERT INTO fuf_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","«Bone wonanii on, yo faasiqiiɓe, ɗun ko onon jannooɓe fii Sariya on e Fariisiyaaɓe ɓen, ɓay hiɗon jatta galleeji keynguuɓe, hiɗon juutina julɗe fii yiingo. Sabu ɗun on heɓoyay ɲaawooje ɓurɗe sattuɗe. ");
INSERT INTO fuf_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","«Bone wonanii on, yo faasiqiiɓe, ɗun ko onon jannooɓe fii Sariya on e Fariisiyaaɓe ɓen, ɓay hiɗon jinda ka baharu e ka leydi fii silmingol gooto. Nde on silmi, waɗon mo ɓiɗɗo jahannama nde laabi ɗiɗi ɓuri ko mon kon! ");
INSERT INTO fuf_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","«Bone wonanii on, yo bumɓe ɗowooɓe, wi'a: ‹Si goɗɗo woondirii *juulirde mawnde nden, haray hinaa huunde. Kono si goɗɗo woondirii kaŋŋe juulirde mawnde nden, haray ɗun farlike mo.› ");
INSERT INTO fuf_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ko onon yo njofooɓe e bumɓe! Ko honɗun ɓuri mawnude hakkunde kaŋŋe ɗen e juulirde mawnde laɓɓinnde kaŋŋe ɗen nden? ");
INSERT INTO fuf_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Maaɗun hiɗon wi'a: Si goɗɗo woondirii *layyorde nden, haray ɗun hinaa huunde, kono si goɗɗo woondirii ko sakkaa kon ka hoore layyorde, haray ɗun farlike mo. ");
INSERT INTO fuf_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ko onon yo bumɓe, ko honɗun ɓuri mawnude hakkunde ko sakkaa kon e layyorde laɓɓinaynde ko sakkaa kon? ");
INSERT INTO fuf_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Awa, kala on woondirɗo layyorde nden, haray o woondirii nde, kayre e kala ko woni e mayre. ");
INSERT INTO fuf_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Awa kadi kala woondirɗo juulirde mawnde nden, haray o woondirii nde, kayre e Hoɗuɗo e mayre on. ");
INSERT INTO fuf_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Kala woondirɗo kammu ngun kadi, haray o woondirii jullere laamu Alla nden e Jooɗiiɗo e mayre on. ");
INSERT INTO fuf_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","«Bone wonanii on, yo faasiqiiɓe, ɗun ko onon jannooɓe fii Sariya on e Fariisiyaaɓe ɓen, ɓay hiɗon ittana naana e suukooran e ɲamaku farilla, hara hiɗon welsindanii ko ɓuri hittude kon ka Sariya, ɗun ko peewal ngal e yurmeende nden e sella-findeyaagal ngal. Hara-le ko ɗun haanunoɗon jokkude, tawa kadi on welsindaaki e ko heddii kon. ");
INSERT INTO fuf_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ko onon yo bumɓe ɗowooɓe, sukkitooɓe buubii ka yarata, hara-le on moɗay ngelooba! ");
INSERT INTO fuf_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","«Bone wonanii on, yo faasiqiiɓe, ɗun ko onon jannooɓe fii Sariya on e Fariisiyaaɓe ɓen, ɓay ko ɓaawo miranji ɗin tun laɓɓinton, hara hiɗi heewi miile e angal waawugol hoore mun. ");
INSERT INTO fuf_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ko onon yo Fariisiyaaɓe bumɓe, adee laɓɓinon taho nder miranji ɗin, fii no ɓaawo on kadi laaɓira. ");
INSERT INTO fuf_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","«Bone wonanii on, yo faasiqiiɓe, ɗun ko onon jannooɓe fii Sariya on e Fariisiyaaɓe ɓen, ɓay hiɗon wa'i wa genaale rawninaaɗe fotuɗe e kene, hara nder majje on no heewi tew ƴi'e mayɓe e kala noone tuundi. ");
INSERT INTO fuf_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Onon kadi ko nii! Ka kene hiɗon wa'ani yimɓe ɓen wa feewuɓe, kono hara ka nder hiɗon heewi faasiqankaaku e angal peewal. ");
INSERT INTO fuf_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","«Bone wonanii on, yo faasiqiiɓe, ɗun ko onon jannooɓe fii Sariya on e Fariisiyaaɓe ɓen, ɓay hiɗon maha maandina genaale annabaaɓe ɓen, para kadi maandeeji genaale feewuɓe ɓen, ");
INSERT INTO fuf_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","hara kadi hiɗon wi'a: ‹Si tawno meɗen woodanoo e tawnde baabiraaɓe amen ɓen, men wontidataano e maɓɓe fii hibbugol ƴiiƴan annabaaɓe ɓen.› ");
INSERT INTO fuf_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ko nii wonɗon seeditorde e hoore mon tigi, wonde ko on ɓiɓɓe ɓen warunooɓe annabaaɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Awa juurinee sariyaare baabiraaɓe mon ɓen! ");
INSERT INTO fuf_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","«Ko onon, yo bolle, iwdi kuura! Ko honno non daɗirton donkinireede jahannama? ");
INSERT INTO fuf_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ko ɗun waɗi si miɗo naɓande on annabaaɓe e faamuɓe e jannooɓe, waroyon woɓɓe, fempon woɓɓe, foccon ɓeya ka juulirɗe mon, cukkoɗon ɓe gila e saare heɓi e saare, ");
INSERT INTO fuf_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","fii yo ƴiiƴan kala feewuɗo hibbaaɗan yantu e hoore mon, ɗun non ko gila e ƴiiƴan Haabiila ɗan, on feewuɗo, haa addani e ƴiiƴan Zakariyaa, oo ɓiɗɗo oo wi'eteeɗo Berekiiya, on mo warunoɗon hakkunde layyorde nden e juulirde mawnde nden, ");
INSERT INTO fuf_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","ko fii ka haqiiqa mi andinii on, ɗun fow yantoyay e hoore nguu jamaanu. ");
INSERT INTO fuf_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","«Ee Yerusalaam! Ee Yerusalaam! Ko an yo saare sahinbinoore annabaaɓe, wariroore nelaaɓe e mun kaaƴe! Ko haa honto mi faalanoo mooɓude ɓee fayɓe maa wano gertogal mooɓirta coppi e ley gabitti mun, e hin-le on jaɓaali ɗun! ");
INSERT INTO fuf_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Awa nokkuure mon nden eggaama, nde caabii! ");
INSERT INTO fuf_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ko fii mi andinii on, on yiitataa lan haa ɲande wi'oyton: ‹Yo barki wonan oo wonɗo arude e innde Joomiraaɗo on!› » ");
INSERT INTO fuf_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ɓay wonii Iisaa fokkitii yaltude ka *juulirde mawnde, taalibaaɓe makko ɓen ɓadii mo fii hollugol mo darnoodi juulirde nden. ");
INSERT INTO fuf_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Kono o jaabii ɓe, o wi'i: «On yi'ii ɗun fow? Ka haqiiqa mi andinii on, hay hayre e hoore hayre luttoytaa ɗoo ko lancaaka.» ");
INSERT INTO fuf_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Onsay o jooɗoyii ka Fello *Zaytuuni. Taalibaaɓe ɓen ari tawi mo e gundoo, ɓe wi'i mo: «Yeetee men, ko honde tuma ɗun waɗoyta, e ko honɗun wonoyta maande aroygol mon ngol e lannoode aduna on?» ");
INSERT INTO fuf_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Iisaa jaabii ɓe, wi'i: «Reenee fii wota gooto faljin on, ");
INSERT INTO fuf_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","ko fii buy aroyay ɓaarora innde an nden, hara no wi'a ko kaɲun woni *Almasiihu on. Awa ɓen faljinoyay yimɓe ɗuuɗuɓe. ");
INSERT INTO fuf_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","On nanoyay kadi fii hareeji no wowlee, e haalaaji fii gereeji. Awa wota on hulu, ko fii bee ɗun waɗa. Kono hinaa ɗon wonata lannoode nden. ");
INSERT INTO fuf_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Hareeji kadi waɗoyay hakkunde leƴƴi ɗin. Laamateeriiji ɗin kadi immondirana, nokkeeli goo heegeeji waɗa, kaɲun e dimbanɗe leydi. ");
INSERT INTO fuf_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Kono ko ɗun fow wonata fuɗɗoode sattendeeji nanditayɗi e muuseendi ŋata ɗin. ");
INSERT INTO fuf_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","«Awa ɓe wattoyay on e juuɗe tampinooɓe ɓen, ɓe wara on. Leƴƴi ɗin fow kadi aɲa on sabu innde an nden. ");
INSERT INTO fuf_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Buy seloyay gomɗinal ngal, ɓe janfondira, ɓe aɲindira. ");
INSERT INTO fuf_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Awa waɗitiiɓe annaba ɗuuɗuɓe yaltitoyay, ɓe faljina yimɓe buy. ");
INSERT INTO fuf_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Sabu ɓeydagol angal peewal ngal, giggol ɗuuɗuɓe ɗuytoyto, ");
INSERT INTO fuf_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","kono kala ŋaɲɲiiɗo haa ka lannoode, o dandoyte. ");
INSERT INTO fuf_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Oo Kibaaru Moƴƴo fii *laamu Alla ngun feɲɲinte e aduna on fow, fii no leƴƴi ɗin fow nanira seeditoore nden. Ko onsay aduna on lannata. ");
INSERT INTO fuf_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","«Awa, nde yi'uɗon huunde harmunde caabinaynde nde annabi Danu'iila wowlunoo fii mun nden daakanike nokkuure hormorde nden woo, (haray yo jangoowo on faamu), ");
INSERT INTO fuf_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","onsay yo hoɗuɓe ka diiwal Yahuuda ɓen dogir ka pelle. ");
INSERT INTO fuf_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","On wonɗo ka fowtorde hoore suudu mun wota tippano ko woni kon ka nder suudu. ");
INSERT INTO fuf_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","On wonɗo kadi ka ngesa wota yiltito fii ƴettugol dolokke mun on. ");
INSERT INTO fuf_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","E nder ɗen balɗe ɗon, bone wonanay sowiiɓe ɓen e muyninayɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Awa toree fii wota ndun dogudu mon ardu ndungu maa e *ɲalaande fowteteende e mun nden. ");
INSERT INTO fuf_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ko fii onsay satteende mawnde waɗay, nde sifa mun waɗaali gila aduna dawi haa hande, e nde ɓuri mun waɗitataa han kadi. ");
INSERT INTO fuf_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Si tawno ɗen ɲalaaɗe raɓɓinɗinanooka, hay gooto daɗataano. Kono sabu suɓaaɓe ɓen, ɗen ɲalaaɗe raɓɓinɗinte. ");
INSERT INTO fuf_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","«Awa si goɗɗo aru on e wi'oyde wonde: ‹Almasiihu on no ɗoo!› maa ‹himo ɗaa!›, wota on hoolo mo. ");
INSERT INTO fuf_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ko fii waɗitiiɓe almasiihu e waɗitiiɓe annaba feeɲoyay, ɓe waɗoya maandeeji njani e kaawakeeji fii no ɓe faljinira hay suɓaaɓe ɓen, si no gasaynoo. ");
INSERT INTO fuf_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Awa mi *hiitanike on fii ɗun. ");
INSERT INTO fuf_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","«Awa si ɓe wi'ii on: ‹E hino himo ka wulaa›, wota on yahu, maa: ‹Himo ka nder cuuɗi›, wota on hoolo! ");
INSERT INTO fuf_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Awa ko wano maƴande maƴirta non iwra ka funnaange, jalba haa ka hirnaange, ko wano non ardu *Ɓii-Aaden on woniroyta. ");
INSERT INTO fuf_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ko ka ko maayi kon woni woo, jigaaje ɗen mooɓotoo. ");
INSERT INTO fuf_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","«Kisan ɓawto satteende ɗen ɲalaaɗe, ‹Naange ngen niɓɓitay, tawa lewru ndun jalbataa, koode ɗen ka kammu kadi yana, ko tiiɗi kon ka kammu kadi dimboyoo.› ");
INSERT INTO fuf_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","«Ko onsay maande Ɓii-Aaden on feeɲata ka kammu, bolondaaji ɗin fow ka hoore leydi fesa, ɓe yi'oya non Ɓii-Aaden on no ara e duule iwrude ka kammu, hara himo arda e bawgal e mangural mawngal. ");
INSERT INTO fuf_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Onsay o nuliroya malaa'ikaaɓe makko ɓen hito moolanaango *liital, ɓe mooɓa suɓaaɓe makko ɓen, gila funnaange heɓi hirnaange e gila nano heɓi ɲaamo, gila ka kammuuli ɗin fuɗɗi haa ka ɗi haaɗi. ");
INSERT INTO fuf_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","«Yo misal ƴibbehi kin wonan on gandal. Nde calɗi makki ɗin hecciɗiri, ɗi wiliti, on andanay hoore mon wonde setto ngon ɓadike. ");
INSERT INTO fuf_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ko wano non kadi, no yiiruɗon ɗii piiji fow no waɗa woo, haray andee wonde Ɓii-Aaden on ɓadike ka dambugal. ");
INSERT INTO fuf_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ka haqiiqa mi andinii on, ɗun fow waɗay ado nguu jamaanu feƴƴude. ");
INSERT INTO fuf_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Kammu ngun e leydi ndin feƴƴay, kono min konguɗi an ɗin feƴƴataa.» ");
INSERT INTO fuf_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","«Kono hay gooto andaa fii nden ɲalaande e on saa'i, hinaa hay malaa'ikaaɓe ɓen ka kammuuli, hinaa hay Ɓiɗɗo on, kono ko Baabaajo on tun andi fii nden ɲalaande e on saa'i. ");
INSERT INTO fuf_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ko waɗunoo kon fewndo jamaanu Nuuhu, waɗoyay kadi ka ɲalaaɗe ado artugol Ɓii-Aaden on. ");
INSERT INTO fuf_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ko fii, e ɗee ɲalaaɗe ado waamere nden waɗude, hari yimɓe ɓen no ɲaamaynoo yara, no jomba jombanee, haa ɲande Nuuhu naatunoo ka laana. ");
INSERT INTO fuf_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ɓe sogitaaki hay huunde haa nde waamere nden arnoo, nde yooli ɓe ɓe fow. Ko wano non woniroyta ardu Ɓii-Aaden on. ");
INSERT INTO fuf_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","«Onsay yimɓe ɗiɗo wonduɓe e ngesa woota, goɗɗo e maɓɓe ƴettete, oya on lutta. ");
INSERT INTO fuf_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Wano non kadi, rewɓe ɗiɗo wonɓe unidude, goɗɗo e maɓɓe ƴettete, oya on lutta. ");
INSERT INTO fuf_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Awa wattanee yiila, ko fii on andaa ko e ɲalaande honde Joomiraaɗo mon on aroyta. ");
INSERT INTO fuf_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ko fii andee fota, si tawno jom galle no andunoo nde ngujjo on araynoo wujjugol e nder jemma on, o wattanayno yiila, hara o accaali galle makko ɗen fusee. ");
INSERT INTO fuf_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ko ɗun waɗi, onon kadi hebilee, ko fii Ɓii-Aaden on aroyay e saa'i nde on sogitaaki.» ");
INSERT INTO fuf_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","«Hara ko jiyaaɗo hombo reeniiɗo holniiɗo woni ko jom mun halfinta neemingol kurkaaɗi mun ɗin e saa'i haanuɗo? ");
INSERT INTO fuf_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Maloore wonanii on jiyaaɗo, mo jom mun ari tawi no jokkiri non. ");
INSERT INTO fuf_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ka haqiiqa mi andinii on, o halfinay mo jawle makko ɗen fow. ");
INSERT INTO fuf_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Kono si tawii on jiyaaɗo ko bonɗo, wi'oowo: ‹Jom an neeɓii araali›, ");
INSERT INTO fuf_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","onsay, o nangana tilfugol ɗimmooɓe makko ɓen, hara kanko himo ɲaama yarida e mandilooɓe ɓen, ");
INSERT INTO fuf_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","jom on jiyaaɗo aray nde on jiyaaɗo sabbaaki mo, e saa'i mo o sogitaaki, ");
INSERT INTO fuf_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","o letta mo lette sattuɗe, o waɗa mo ka faasiqiiɓe ɓen waɗetee ton, ka wullaandu e ŋatindiro ɲiiƴe woni ton. ");
INSERT INTO fuf_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","«Awa laamu kammu ngun no wa'i wa nde jiwɓe sappo ƴetti lampuuji mun, yahi fii fottoygol e jom jomba. ");
INSERT INTO fuf_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Tawi njowo e maɓɓe ko njofooɓe, ɓeya njowo ko faamuɓe. ");
INSERT INTO fuf_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ko njofooɓe ɓen ƴettata lampuuji mun ɗin, ɓe ronki naɓorde nebban ko ɓe huɓɓinira ɗi, ");
INSERT INTO fuf_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","kono faamuɓe ɓen kaɲun ardi e lampuuji e tindohoy nebban. ");
INSERT INTO fuf_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Nde tawnoo jom jomba neeɓii, fow soƴƴii ɗaanii. ");
INSERT INTO fuf_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","«Ɓay wonii tumbere jemma, ewnaa: ‹E hino jom jomba! Yaltee fii jaɓɓagol mo!› ");
INSERT INTO fuf_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Onsay ɓen jiwɓe immii, ɓe eɓɓindanii lampuuji maɓɓe ɗin. ");
INSERT INTO fuf_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Njofooɓe ɓen wi'i faamuɓe ɓen: ‹Okkoree men nebban, ko fii lampuuji amen ɗin no e fii ɗaanagol!› ");
INSERT INTO fuf_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Faamuɓe ɓen jaabii ɓe, wi'i: ‹Oo'o, ɗan yonataa! Yahee soodoyon ka yeeyooɓe ɓen.› ");
INSERT INTO fuf_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","«Fewndo ko ɓe yahi soodoygol, jom jomba hewti. Hebulinooɓe ɓen naatidi e makko ka peera, baafe ɗen ombaa. ");
INSERT INTO fuf_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ɓay nettii, ɓeya jiwɓe kadi ari, ɓe wi'i: ‹Koohoojo, Koohoojo, udditanee men!› ");
INSERT INTO fuf_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Kono o jaabii ɓe, o wi'i: ‹Ka haqiiqa, mi andaa on!› » ");
INSERT INTO fuf_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Onsay Iisaa wi'i: «Awa wattanee yiila, ko fii on andaa ɲalaande e saa'i nde mi arata.» ");
INSERT INTO fuf_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","«Laamu Alla ngun no wa'i kadi wa neɗɗo fokkituɗo safaari. O noddi kurkaduuɓe mun, o halfini ɓe jawle makko ɗen. ");
INSERT INTO fuf_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","O jonni goɗɗo on *talanji jowi, o jonni oya talanji ɗiɗi, o jonni tammo on talanru wooturu, mo bee e taaqa mun, onsay o yahi e safaari makko. ");
INSERT INTO fuf_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ɗon kisan hendiiɗo talanji jowi ɗin yahi gollitiroyi ɗi, o heɓoyi talanji jowi e hoore majji. ");
INSERT INTO fuf_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Wano non kadi hendiiɗo talanji ɗiɗi on, o heɓi e hoore majji talanji ɗiɗi. ");
INSERT INTO fuf_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Kono hendinooɗo talanru wooturu on, o yahi, o jasi ngayka, o iri mbuuɗi jom makko ɗin. ");
INSERT INTO fuf_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","«Ɓay neeɓoyii, jom ɓen kurkaaduuɓe arti. O landitii ɓe ko honno ɓe golliri. ");
INSERT INTO fuf_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Hendinooɗo talanji jowi on ɓadii, o addidi ɗi e talanji jowi goo kadi, o wi'i: ‹Koohoojo, on acciranno talanji jowi, awa e hino talanji jowi kadi ko mi heɓi e hoore majji kon.› ");
INSERT INTO fuf_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Jom makko wi'i mo: ‹A waɗii ko moƴƴi, yo kurkaaduujo moƴƴo holniiɗo. Ko fii a nunɗii e hoore ko fanɗi, mi waɗete e hoore ko ɗuuɗi. Weltodu e jom maa!› ");
INSERT INTO fuf_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","«Hendinooɗo talanji ɗiɗi on kaɲun kadi ɓadii, wi'i: ‹Koohoojo, on acciranno talanji ɗiɗi, e hino talanji ɗiɗi ko mi heɓi e hoore majji kon.› ");
INSERT INTO fuf_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Jom makko wi'i mo: ‹A waɗii ko moƴƴi, yo kurkaaduujo moƴƴo holniiɗo. Ko fii a nunɗii e hoore ko fanɗi, mi waɗete e hoore ko ɗuuɗi. Weltodu e jom maa!› ");
INSERT INTO fuf_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","«Hendinooɗo talanru wooturu on kaɲun kadi ɓadii, wi'i: ‹Koohoojo, ɓay miɗo andunoo ko a neɗɗo sattuɗo fii, soɲitoowo ko a aawaa e wa'oowo ko a sankaa, ");
INSERT INTO fuf_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","mi huli, mi yahi, mi iroyi talanru maa ndun ka nder leydi. E hino ndu, jaɓu ko jeyɗaa kon.› ");
INSERT INTO fuf_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","«Jom makko jaabii mo wi'i: ‹Ko an yo jiyaaɗo bonɗo puyɗo! E hiɗa andunoo mi soɲitay ko mi aawaa, maa mi wa'ay ko mi sankaa? ");
INSERT INTO fuf_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Awa, hiɗa haanunoo accude mbuuɗi an ɗin e juuɗe gollitirooɓe ɗi ɓen, ɗun, nde mi artunoo woo, mi hettayno ɗi mi jeynoo ɗin e hoore tono!› ");
INSERT INTO fuf_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","«Onsay jom makko wi'i: ‹Jaɓitee ɗi e juuɗe makko, jonnon ɗi oo jogiiɗo talanji sappo ɗin! ");
INSERT INTO fuf_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ko fii ko marɗo on ɓeydantee haa ɗuuɗa, kono mo maraa on jaɓitante hay yeru ko o mari kon. ");
INSERT INTO fuf_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Awa, jiyaaɗo fussaaqiijo on, bugee mo ka niwre ka ɓuri woɗɗude, ka wullaandu e ŋatindiro ɲiiƴe woni ton!› » ");
INSERT INTO fuf_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","«Tuma *Ɓii-Aaden on ardoyi e mangural mun ngal, wondude e malaa'ikaaɓe ɓen fow, o jooɗoyto ka jullere makko laamu darjinnde. ");
INSERT INTO fuf_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Onsay leƴƴi ɗin fow mottindirte yeeso makko. O sendindira yimɓe ɓen, wano ngaynaako sendindirirta baali e be'i. ");
INSERT INTO fuf_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","O waɗira baali ɗin ka sengo makko ɲaamo, be'i ɗin ka sengo makko nano. ");
INSERT INTO fuf_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","«Onsay Lanɗo on wi'ay wonirɓe ka sengo mun ɲaamo ɓen: ‹Aree, yo ɓe Ben an barkini! Hendoɗon ndondi laamateeri eɓɓananoondi on ndin gila ka fuɗɗoode aduna on. ");
INSERT INTO fuf_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ko fii mi weelano, okkorɗon mi ko mi ɲaama, mi ɗonɗano, okkorɗon mi ko mi yara, mi wonno koɗo, wernuɗon mi, ");
INSERT INTO fuf_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","mi holi, holtinɗon mi, mi ɲawi, dankiɗon mi, mi sokaa, ndaaruɗon mi.› ");
INSERT INTO fuf_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","«Onsay feewuɓe ɓen jaaboyto mo, wi'a: ‹Joomi, ko honde tuma men yi'u-maa hiɗa weelaa, men okkor-maa ko ɲaamaa, maa ka ɗonɗaɗaa, men okkor-maa ko yaraa? ");
INSERT INTO fuf_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","E ko honde tuma men yi'u-maa ko a koɗo, men wernu-maa, e ka holuɗaa, men holtin-maa? ");
INSERT INTO fuf_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","E ko honde tuma men yi'u-maa hiɗa nawni, maa hiɗa sokii, men yahi e maa?› ");
INSERT INTO fuf_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Onsay Lanɗo on jaaboto ɓe, wi'a: ‹Ka haqiiqa mi andinii on, nde tawnoo on waɗanii ɗun ɓurɗo fanɗude e musiɓɓe an ɓen, tawi ko min waɗanɗon ɗun.› ");
INSERT INTO fuf_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","«Ɓawto ɗun o wi'a wontirɓe ka nano makko ɓen: ‹Pottitee lan, yo huɗaaɓe, yahee ka yiite poomayankeewe eɓɓanaange Ibuliisa e malaa'ikaaɓe mun. ");
INSERT INTO fuf_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ko fii mi weelano, on okkoraano lan ko mi ɲaama, mi ɗonɗaa, on okkoraali lan mi yara, ");
INSERT INTO fuf_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","mi woni koɗo, on wernaali lan, mi holi, on holtinaali lan, mi nawni, mi sokaa, on ndaaraali lan!› ");
INSERT INTO fuf_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","«Onsay kamɓe kadi ɓe jaaboyto, ɓe wi'a: ‹Joomi, ko honde tuma men yi'u-maa hiɗa weelaa, maa hiɗa ɗonɗaa, maa ko a koɗo, maa hiɗa holi, maa hiɗa nawni, maa e kaso, men wallaali ma?› ");
INSERT INTO fuf_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","«Onsay o jaaboyto ɓe, o wi'a: ‹Ka haqiiqa mi andinii on, nde tawnoo on waɗanaali ɗun goɗɗo e ɓee ɓurɓe fanɗude, tawi ko min woni on waɗanaali ɗun!› ");
INSERT INTO fuf_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ɓen non nawrete ka lette poomayankeeje. Kono feewuɓe ɓen nawrete ka *ngurndan poomayankejan.» ");
INSERT INTO fuf_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ɓay wonii Iisaa gaynii ɗin yewtereeji fow, o wi'i taalibaaɓe makko ɓen: ");
INSERT INTO fuf_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«Hiɗon andi si balɗe ɗiɗi feƴƴi, *Juldeere Yawtaneede nden waɗay, awa *Ɓii-Aaden on wattete e joge fii yo o fempe e *leggal altindiraangal.» ");
INSERT INTO fuf_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Tawi onsay hooreeɓe *yottinooɓe sadaka ɓen e mawɓe jamaa on no mooɓondiri ka nder tata yottinoowo mawɗo sadaka on, ɗun ko oo wi'eteeɗo Qayaafa. ");
INSERT INTO fuf_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ɓe haldi nangirgol Iisaa ƴoyre, ɓe wara. ");
INSERT INTO fuf_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Kono fow e mun ɓe wi'i: «Hinaa ka fewndo juldeere, fii wota murtaldu waɗu e hakkunde jamaa on.» ");
INSERT INTO fuf_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Nde tawnoo Iisaa no ka saare *Betanii, ka suudu Sim'uunu, oo nawnunooɗo ɗamajan, ");
INSERT INTO fuf_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","debbo ari tawi mo kanko Iisaa. Tawi on debbo no jogii tindohun hayre daneere tew angiri satta-cogguuri. Wa fewndo ko Iisaa jooɗii fii nafagol, kanko debbo on o juuri angiri ndin ka hoore Iisaa. ");
INSERT INTO fuf_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ɓay wonii taalibaaɓe ɓen yi'ii ɗun, ɓe seytini, ɓe wi'i: «Ko honɗun woni nafa ndee bonnere? ");
INSERT INTO fuf_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","En waawayno yeeyude ndii angiri ko satti, jonna coggu mayri on miskinɓe ɓen.» ");
INSERT INTO fuf_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ɓay Iisaa andii ɗun, o wi'i ɓe: «Ko honɗun sattinanton oo debbo? Ko fii ko kuugal moƴƴal o waɗanimmi. ");
INSERT INTO fuf_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Miskinɓe ɓen kan, hiɗon wondi e maɓɓe soono woo, kono min, on wondataa e an soono woo. ");
INSERT INTO fuf_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ko o hibbiri ndii angiri ka ɓandu an, ko fii no mi hebulanora surreede. ");
INSERT INTO fuf_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ka haqiiqa mi andinii on, kala ka oo Kibaaru Moƴƴo feɲɲinaa e aduna on, fii koo ko oo debbo waɗi kadi sifete, o anditanee.» ");
INSERT INTO fuf_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Onsay goɗɗo e *sahaabaaɓe Iisaa ɓen sappoo e ɗiɗo, ɗun ko Yudaasi Iskariiyu, yahi ka hooreeɓe yottinooɓe sadaka ɓen, ");
INSERT INTO fuf_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","o wi'i: «Ko honɗun waawoton mi okkude, mi watta Iisaa e juuɗe mon?» Ɓe limani mo tammaaji cappanɗe tati kaalisi. ");
INSERT INTO fuf_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Gila ontuma himo ɗaɓɓude feere no o wattira Iisaa e juuɗe maɓɓe. ");
INSERT INTO fuf_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ka ɲallal aranal *Juldeere Bireedi ɗe Aldaa e Lewen ɗen, taalibaaɓe ɓen ari, wi'i Iisaa: «Ko honto faalaɗon yo men moƴƴinanoy on nafakka Juldeere Yawtaneede nden?» ");
INSERT INTO fuf_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","O jaabii ɓe, o wi'i: «Yahee ka saare haa ka kaariijo, wi'on mo: ‹Karamoko'en wi'ii woo: Saa'i maɓɓe on ɓadike, ko ka mon ɓe juulidata e taalibaaɓe maɓɓe ɓen Juldeere Yawtaneede nden.› » ");
INSERT INTO fuf_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Taalibaaɓe ɓen waɗoyi ko Iisaa yamiri ɓe kon, ɓe moƴƴini nafakka juldeere nden. ");
INSERT INTO fuf_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ɓay niɓɓii, kanko Iisaa o ɓadii fii nafagol, wondude e sappoo e ɗiɗooɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","E nder ko ɓe ɲaamata kon, o wi'i: «Ka haqiiqa mi andinii on, goɗɗo e mon janfoto lan.» ");
INSERT INTO fuf_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ɓe aani fota. Onsay mo bee e maɓɓe woni e wi'ugol mo: «E hara Koohoojo, ko min?» ");
INSERT INTO fuf_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","O jaabii ɓe, o wi'i: «Ko on mo mi yollidi jungo e miran gooto janfotoo lan. ");
INSERT INTO fuf_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Awa Ɓii-Aaden on no yahude wano fii makko windori non, kono bone wonanii on janfotooɗo Ɓii-Aaden on. Ko ɓurnoo moƴƴande on neɗɗo ko si o jibinanooka!» ");
INSERT INTO fuf_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Onsay Yudaasi, ɗun ko janfotooɗo mo on, ƴetti haala kan, wi'i: «Karamoko'en, e hara ko min?» Iisaa jaabii: «Ko wano wi'irɗaa non!» ");
INSERT INTO fuf_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","E nder ko ɓe ɲaamata kon, Iisaa ƴetti bireedi. Ɓay o gaynii du'aade, o taƴiti, o jonni taalibaaɓe ɓen, e hoore himo wi'a: «Jaɓee ɲaamon, ɗunɗoo ko ɓandu an ndun nii.» ");
INSERT INTO fuf_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","O ƴetti kadi jardukun waɗorkun njaram, o jarni Alla, o jonni ɓe, e hoore himo wi'a: «On fow yaree. ");
INSERT INTO fuf_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ko fii ɗun ko ƴiiƴan an ɗan nii, ƴiiƴan *ahadi hibboyteeɗan ɗan fii yaafuyee junuubaaji ɗuuɗuɓe. ");
INSERT INTO fuf_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Mi andinii on, mi yaritataa hande kadi njaram ɓiɓɓe *wiiɲu haa ɲande mi yaridoyta e mon njaram wiiɲu kesan ka laamateeri Baaba an.» ");
INSERT INTO fuf_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ɓay wonii ɓe beytii beyti Zabuura, ɓe yahi ka Fello *Zaytuuni. ");
INSERT INTO fuf_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Onsay Iisaa wi'i ɓe: «E nder oo jemma, on fow on selay lan, ko fii no windii: ‹Mi waray ngaynaako on, wuro baali ngon saakoo.› ");
INSERT INTO fuf_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Kono tuma mi immintinaa, mi hikkanto on yeeso, tawoyon mi Jaliilu.» ");
INSERT INTO fuf_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Onsay Petruusu ƴetti haala kan, wi'i mo: «Hay si fow selay on, min non mi selataa on few.» ");
INSERT INTO fuf_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Onsay Iisaa jaabii mo, wi'i: «Ka haqiiqa mi andinii ma, e oo jemma tigi, ado ndonto ƴoggude, haray a yeddii fii an laabi tati.» ");
INSERT INTO fuf_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Petruusu jaabii mo kadi, wi'i: «Hay si tawii bee mi maayida e mon, mi yeddataa fii mon few!» Taalibaaɓe ɓen fow kadi wi'iri non. ");
INSERT INTO fuf_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ɓawto ɗun Iisaa yaadi e maɓɓe e ndee nokkuure wi'eteende *Jatsaymaani, o wi'i taalibaaɓe ɓen: «Jooɗee ɗoo haa mi woɗɗitoo fii toragol.» ");
INSERT INTO fuf_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","O naɓori Petruusu e ɓiɓɓe Zabadii ɓen ɗiɗo. Onsay o fuɗɗii heɓude annde e sokola, ");
INSERT INTO fuf_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","o wi'i ɓe: «Wonkii an kin no aani haa e mayde. Wonee ɗoo, hiiren.» ");
INSERT INTO fuf_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Onsay o yahi yeeso seeɗa, o sujji, o torori nii, o wi'i: «Baaba an, si no gasa, yo kun jardukun tampere pottito lan. Kono non wota faale an on waɗu, kono yo faale maa on waɗu.» ");
INSERT INTO fuf_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","O artoyi e taalibaaɓe ɓen, o tawi ɓe ɗaanike. O wi'i Petruusu: «Jaka on waawaali hiiridude e an hay saa'i gooto? ");
INSERT INTO fuf_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Hiiree toroɗon fii wota on naatu e jarrabi. Wonkii kin no yiɗi waɗugol ko moƴƴi, kono ɓandu ndun no lo'i.» ");
INSERT INTO fuf_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","O woɗɗitii ɓe kadi ɗimmun, o torori nii, o wi'i: «Baaba an, si tawii gasataa ka kun jardukun tampere pottitoo lan, hara mi yaraali kun, yo faale maa on waɗu.» ");
INSERT INTO fuf_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","O artoyi kadi, o tawi ɓe ɗaanike, ko fii hari gite maɓɓe ɗen teddii. ");
INSERT INTO fuf_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","O acci ɓe ɗon, o yahi, o woɗɗitii ɓe kadi, o torii kadi tammun, o fillitii ɗin konguɗi. ");
INSERT INTO fuf_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Onsay o arti e taalibaaɓe ɓen, o wi'i ɓe: «E on ɗaani kadi, fowtiɗon? Awa jooni saa'i on ɓadike, Ɓii-Aaden on no watteede e juuɗe junuubanke'en. ");
INSERT INTO fuf_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Immee mahen, ko fii wonɗo janfaade lan on ɓadike!» ");
INSERT INTO fuf_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","E nder ko o yewtata kon, hawrondiri Yudaasi, tawdaaɗo e sappoo e ɗiɗooɓe ɓen, hewtidii e jamaa ɗuuɗuɗo jogiiɗo kaafaaje e bedi, immorde e hooreeɓe yottinooɓe sadaka ɓen e mawɓe jamaa on. ");
INSERT INTO fuf_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Tawi wonɗo mo janfaade on waɗaniino ɓe ndee maande ɗoo, o wi'i: «Mo mi hirbii woo, haray ko on. Nangee mo.» ");
INSERT INTO fuf_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Tun o ɓadii Iisaa, e hoore himo wi'a: «On jaaraama karamoko'en!» Onsay o hirbii mo. ");
INSERT INTO fuf_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Iisaa wi'i mo: «Giɗo an, waɗu ko arɗaa waɗugol kon.» Onsay ɓen yimɓe ɓadii, fawi Iisaa juuɗe, ɓe nangi mo. ");
INSERT INTO fuf_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Tun, goɗɗo e wondunooɓe e Iisaa ɓen fonti jungo, sorti kaafa mun kan, o soppi kurkaadu yottinoowo mawɗo sadaka on, o itti mo nowru ndun. ");
INSERT INTO fuf_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Onsay Iisaa wi'i mo: «Wattu kaafa maa kan ka ka wonnoo ɗon, ko fii ƴettuɓe kaafa ɓen fow, ko kaafa mulirtee. ");
INSERT INTO fuf_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Kaa a sikku mi waawataa toraade Ben an ballal, o addanammi kisan ɓuri koneeli sappoo e ɗiɗi malaa'ika? ");
INSERT INTO fuf_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Kono si ɗun waɗii, haray ko honno ko bindi ɗin wi'i kon laatorta? Ɓay ko ɗi wi'i kon ko nii haani wonirde!» ");
INSERT INTO fuf_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Onsay Iisaa wi'i jamaa on: «Hiɗon ardi e kaafaaje e bedi fii nangugol lan, wa si ko ngujjo aranɗon? E hin-le ɲande woo miɗo jooɗii ka *juulirde mawnde, miɗo janna, on nangaali lan. ");
INSERT INTO fuf_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Kono ɗun fow ko waɗiri ko fii ko annabaaɓe ɓen windunoo kon yo laato.» Onsay taalibaaɓe ɓen fow acci mo ɗon, dogi. ");
INSERT INTO fuf_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Onsay nanguɓe Iisaa ɓen naɓi mo ka yottinoowo mawɗo sadaka on, ɗun ko Qayaafa, ka jannooɓe fii Sariya on e mawɓe ɓen mottondiri ɗon. ");
INSERT INTO fuf_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Tawi Petruusu no iwtiri ɓaawo makko ka woɗɗitii haa ka tata yottinoowo mawɗo sadaka on. O naati, o jooɗodi e aynooɓe ɓen fii andugol ko honno ɗun wattinirta. ");
INSERT INTO fuf_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Tawi hooreeɓe yottinooɓe sadaka ɓen e dental fewjooɓe ɓen fow no ɗaɓɓa seedeeji fenaandeeji goo e hoore Iisaa fii no ɓe warira mo, ");
INSERT INTO fuf_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","kono ɓe heɓaali, fii kala seeditotooɓe penaale ɗuuɗuɓe arii. Kono ɓawto ɗun yimɓe ɗiɗo ari, ");
INSERT INTO fuf_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ɓe wi'i: «Oo wi'ii no waawi lancude juulirde Alla mawnde nden, darnitoo nde e nder balɗe tati.» ");
INSERT INTO fuf_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Onsay yottinoowo mawɗo sadaka on immii, wi'i mo: «A jaabotaako hay huunde e ko ɓee woni seeditaade e hoore maa kon?» ");
INSERT INTO fuf_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Kono Iisaa fanki. Yottinoowo mawɗo sadaka on wi'i mo: «Mi woondinirii ma Alla Wuuruɗo on, yeeto men si ko an woni *Almasiihu on, ɗun ko *Ɓiɗɗo Alla on.» ");
INSERT INTO fuf_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Iisaa jaabii mo wi'i: «Ko wano wi'irɗaa non. E hoore ɗun mi andinii on, gila jooni on yi'ay Ɓii-Aaden on no jooɗii ka sengo ɲaamo Jom Bawgal on, no arda e duule iwrude ka kammu.» ");
INSERT INTO fuf_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Onsay yottinoowo mawɗo sadaka on seeki conci mun ɗin, wi'i: «O hoynii Alla! Ko seedeeji honɗi kadi faalaɗen? On nanii hoyre makko nden! ");
INSERT INTO fuf_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ko honɗun sikkuɗon?» Ɓe jaabii mo, ɓe wi'i: «Himo foddi e mayde!» ");
INSERT INTO fuf_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Onsay ɓe tutti mo ka yeeso, ɓe uttii mo, woɓɓe ɓen bantii mo ");
INSERT INTO fuf_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","e hoore hiɓe wi'a: «Ko an yo Almasiihu, hotto ko hombo luubi-maa!» ");
INSERT INTO fuf_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Onsay tawi Petruusu no jooɗii ka nder tata. Debbo kurkaaduujo ari ɓadii mo, wi'i: «An kadi hiɗa wondunoo e Iisaa, oo jeyaaɗo Jaliilu.» ");
INSERT INTO fuf_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Kono o yeddi yeeso fow, o wi'i: «Mi andaa ko wonɗaa wowlude!» ");
INSERT INTO fuf_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Wa ko o fokkitiri ka dambugal njanal, debbo kurkaaduujo goo kadi yi'i mo, wi'i wonnooɓe ɗon ɓen: «Oo no wondunoo e Iisaa, oo jeyaaɗo Naasirata.» ");
INSERT INTO fuf_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","O yeddi kadi e nder woondoore, o wi'i: «Mi andaa oo neɗɗo!» ");
INSERT INTO fuf_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ɓay nettii seeɗa, wonnooɓe ɗon ɓen ɓadii, wi'i Petruusu: «Ka haqiiqa ko a goɗɗo e maɓɓe, ko fii haala maa kan no holli iwdi maa ndin.» ");
INSERT INTO fuf_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Onsay o woni e huɗitagol woonda, wi'a: «Mi andaa oo neɗɗo!» Tun, ndontoori ndin ƴoggi. ");
INSERT INTO fuf_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Petruusu anditi kisan kongol ngol Iisaa wi'unoo mo ngol, wonde: «Ado ndonto ƴoggude, a yedday fii an laabi tati.» Onsay o yalti ka yaasi, o wulli wullaandu sattundu. ");
INSERT INTO fuf_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ɓay weetii, hooreeɓe *yottinooɓe sadaka ɓen fow e mawɓe jamaa on fewjodi fii no ɓe warira Iisaa. ");
INSERT INTO fuf_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ɓay wonii ɓe haɓɓii mo, ɓe naɓi mo, ɓe watti e juuɗe Pilaatu, ɗun ko hooreejo diiwal ngal. ");
INSERT INTO fuf_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ɓay Yudaasi janfiiɗo mo on tawii Iisaa happanaama wareede, o ninsi, o natti tammaaji cappanɗe tati kaalisi ɗin ka hooreeɓe yottinooɓe sadaka ɓen e ka mawɓe ɓen, ");
INSERT INTO fuf_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","e hoore himo wi'a: «Mi waɗii junuubu, fawugol mo bonnaa mayde.» Ɓe jaabii mo, ɓe wi'i: «Haaju amen e ɗun? Ɗun ko haaju maa!» ");
INSERT INTO fuf_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Onsay Yudaasi bugii tammaaji kaalisi ɗin ka nder *juulirde mawnde, o iwi ɗon, o yahi, o wengitoyii. ");
INSERT INTO fuf_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Hooreeɓe yottinooɓe sadaka ɓen mooɓiti tammaaji kaalisi ɗin, ɓe wi'i: «Dagaaki ka ɗi wattee ka marirde laaɓunde, ko fii ko ɗi coggu ƴiiƴan.» ");
INSERT INTO fuf_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ɓay wonii ɓe fottanii, ɓe ƴetti ɗin mbuuɗi, ɓe soodi ngesa mahoowo paya fii ko wona berɗe hoɓɓe. ");
INSERT INTO fuf_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ko ɗun waɗi si mban ngesa no wi'ee haa hande Ngesa Ƴiiƴan. ");
INSERT INTO fuf_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ko nii ko annabi Yeremiiya wi'unoo kon laatori, wonde: «Ɓe ƴettii tammaaji cappanɗe tati kaalisi ɗin, ɗun ko mbuuɗi ɗi *Isra'iilayankeeɓe ɓen fottunoo yoɓugol fii makko ɗin, ");
INSERT INTO fuf_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ɓe soodii ɗi ngesa mahoowo paya, wano Joomiraaɗo on yamirirnoo lan non.» ");
INSERT INTO fuf_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ɓay wonii Iisaa ɓannaama yeeso hooreejo diiwal ngal, kanko hooreejo on o landii mo, o wi'i: «Hara ko an woni lanɗo Yahuudiyanke'en?» Iisaa jaabii mo: «Ko wano wi'irɗaa non.» ");
INSERT INTO fuf_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Kono o jaabaaki huunde e ko hooreeɓe yottinooɓe sadaka ɓen e mawɓe ɓen tooɲata mo kon. ");
INSERT INTO fuf_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Onsay Pilaatu landii mo, wi'i: «A nanaali koo ko ɓe woni seeditaade e hoore maa fow?» ");
INSERT INTO fuf_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Kono Iisaa jaabaaki mo hay huunde e ɗun. Ɗun ŋalɗini hooreejo diiwal ngal fota. ");
INSERT INTO fuf_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Tawi juldeere kala, hooreejo diiwal ngal no woowi accitande ɓe kasoojo gooto, mo jamaa on torinoo fii mun woo. ");
INSERT INTO fuf_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Hari hiɓe marnoo kasoojo andanooɗo fii mun, wi'eteeɗo Barabaasi. ");
INSERT INTO fuf_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Nde tawnoo hiɓe mooɓondiri, Pilaatu landii ɓe, o wi'i: «Ko hombo e ɓee faalaɗon yo mi accitan on? Ko Barabaasi kaa ko Iisaa, wi'eteeɗo *Almasiihu on?» ");
INSERT INTO fuf_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ko fii hari himo andunoo ko sabu nawliigu ɓe waɗiri Iisaa e joge. ");
INSERT INTO fuf_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Wa fewndo ko o jooɗii himo ɲaawude ka ɲaawirdu, ɓeyngu makko nuli e makko, wi'i: «Wota a ukko e fii oo feewuɗo, ko fii hande mi tampii fota e koyɗol fii makko.» ");
INSERT INTO fuf_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Kono hooreeɓe yottinooɓe sadaka ɓen e mawɓe ɓen ƴuuni jamaa on tortagol Barabaasi, ɓe wara Iisaa. ");
INSERT INTO fuf_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Onsay hooreejo diiwal ngal ƴetti haala kan, wi'i ɓe: «Ko hombo e hakkunde ɓee ɗiɗo faalaɗon yo mi accitan on?» Ɓe jaabii: «Ko Barabaasi!» ");
INSERT INTO fuf_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilaatu wi'i ɓe kadi: «Ko honɗun non mi waɗata Iisaa, oo wi'eteeɗo Almasiihu?» Fow jaabii: «Ko yo o fempe!» ");
INSERT INTO fuf_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Kanko hooreejo diiwal ngal, o wi'i: «Hara ko bone hombo oo waɗi?» Ɓe ɓurti ewnaade, wi'a: «Yo o fempe!» ");
INSERT INTO fuf_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ɓay Pilaatu tawii alaa waawude huunde, awa kadi murtaldu ndun ɓeydoto woni, onsay o ƴetti ndiyan, o sooɗii e tawnde jamaa on, o wi'i: «Min mi tawetaake e hibbugol ƴiiƴan oo ɗan! Ɗun ko onon wonani!» ");
INSERT INTO fuf_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Onsay jamaa on fow jaabii, wi'i: «Si men tooɲu mo, yo ƴiiƴan makko ɗan hibbitu e hoore amen, e hoore ɓiɓɓe amen ɓen kadi!» ");
INSERT INTO fuf_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ɓawto ɗun, Pilaatu accitani ɓe Barabaasi. Ɓay wonii Iisaa gaynaama focceede, kanko Pilaatu o watti mo e juuɗe maɓɓe fii yo o fempe. ");
INSERT INTO fuf_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Onsay suufaaɓe hooreejo diiwal ngal naɓi Iisaa ka nder suudu laamu, ɓe mottindiri dental suufaaɓe ɓen fow, ɓe hunditi mo. ");
INSERT INTO fuf_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ɓe ɓorti mo conci ɗin, ɓe ɓorni mo dolokke boɗeejo. ");
INSERT INTO fuf_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ɓe sacci katanwol bulle, ɓe waɗi ka hoore makko, ɓe tambini mo kalinwol ka jungo makko ɲaamo. E hoore ɗun ɓe ari, ɓe jiccii yeeso makko e nder jalnori, e hoore hiɓe wi'a: «Salminaango e maa, yaa an lanɗo Yahuudiyankeeɓe!» ");
INSERT INTO fuf_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ɓe tutti mo, ɓe ƴetti kalinwol ngol, ɓe tappiri mo ka hoore. ");
INSERT INTO fuf_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ɓay wonii ɓe gaynii mo waɗude jalnori, ɓe ɓorti mo dolokke on, ɓe ɓorni mo conci makko ɗin, ɓe naɓi mo fii fempoyegol. ");
INSERT INTO fuf_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ko ɓe yaltata, ɓe fotti e gorko mo Sirenii wi'eteeɗo Sim'uunu, ɓe karhi mo naɓugol *leggal Iisaa altindiraangal ngal. ");
INSERT INTO fuf_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ɓay wonii ɓe hewtii e ndee nokkuure wi'eteende Golgotaa, ko woni firo ɗun ko ‹Nokkuure Laalagal Hoore›, ");
INSERT INTO fuf_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ɓe okkori mo njaram jillaaɗan hahhannde. Kono ɓay o mettike ɗan, o jaɓaali yarude. ");
INSERT INTO fuf_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ɓay wonii ɓe fempii mo, ɓe sendiri conci makko ɗin urɓa. ");
INSERT INTO fuf_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","E hoore ɗun ɓe jooɗii ɗon, ɓe ayni mo. ");
INSERT INTO fuf_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ɓe waɗi ka dow hoore makko bindi ɓanginɗi fii ko o happiranaa kon, ɗun ko: «Ko oo woni Iisaa Lanɗo Yahuudiyanke'en.» ");
INSERT INTO fuf_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Tawi wuyɓe ɗiɗo no fempidaa e makko, goɗɗo on ka sengo makko ɲaamo, oya on ka nano makko. ");
INSERT INTO fuf_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Tawi feƴƴooɓe ɓen no hoyna mo, hayla hoore, ");
INSERT INTO fuf_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","hara hiɓe wi'a: «An oo wi'unooɗo lancay juulirde mawnde nden, darnita nde e nder balɗe tati, dandito an tigi! Si tawii ko an woni *Ɓiɗɗo Alla on, tippo ka leggal altindiraangal ɗon!» ");
INSERT INTO fuf_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Tawi hooreeɓe yottinooɓe sadaka ɓen e jannooɓe fii Sariya on ɓen e mawɓe ɓen kaɲun kadi no jalaynoo mo, wi'a: ");
INSERT INTO fuf_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«O dandii ɓeya, kono o waawataa dandude hoore makko? Si ko o lanɗo Isra'iila'en, yo o jippo ka leggal altindiraangal, ɗun en gomɗinay mo. ");
INSERT INTO fuf_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ɓay himo halfinii e Alla, yo Allaahu on dandu mo jooni si himo yiɗi mo, ko fii o wi'ii ko o Ɓiɗɗo Alla!» ");
INSERT INTO fuf_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Tawi wuyɓe ɓe o fempidaa ɓen no yennira mo wano non kaɲun kadi. ");
INSERT INTO fuf_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Gila naange e hoore, niwre waɗi e leydi ndin fow haa ka ɓaawo fanaa. ");
INSERT INTO fuf_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Telen wa ka ɓaawo fanaa, Iisaa ewnii ko tiiɗi, o wi'i: «Iilooyi, Iilooyi, lama sabaxtanii?» (Ɗun no firi: Alla an, Alla an, ko fii honɗun tertaniɗaa mi?) ");
INSERT INTO fuf_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Woɓɓe e wonnooɓe ɗon ɓen nani ko o wi'i kon, ɓe wi'i: «O noddii Iiliiya!» ");
INSERT INTO fuf_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Tun, goɗɗo e maɓɓe dogi, ƴettoyi linsere, o ɓuɓɓini nde haa nde loppii ndiyan lammuɗan, o waɗi nde e tuggordu, o townani mo fii yo o yaru. ");
INSERT INTO fuf_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Kono ɓeya wi'i: «Accu, ndaaren si Iiliiya aray danda mo.» ");
INSERT INTO fuf_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Iisaa ewnii kadi ko tiiɗi, o timmi. ");
INSERT INTO fuf_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Onsay *wirngallo ngon ka juulirde mawnde seekii, woni pecce ɗiɗi, gila dow haa ley. Leydi ndin dimbii, pete ɗen feccii. ");
INSERT INTO fuf_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Genaale ɗen udditii, ɓalli yimɓe Alla maayunooɓe buy immitii, ");
INSERT INTO fuf_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ɓe yalti ka genaale, ɓe naati ka saare hormorde ɓawto immitagol Iisaa, ɓe feeɲani yimɓe ɗuuɗuɓe. ");
INSERT INTO fuf_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ɓay hooreejo suufaaɓe ɓen e wondunooɓe e makko ɓen fii aynugol Iisaa yi'ii ko leydi ndin dimbii kon e ko ari e waɗude kon, ɓe huli fota, ɓe wi'i: «Ka haqiiqa, hari oo ko Ɓiɗɗo Alla!» ");
INSERT INTO fuf_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Tawi rewɓe ɗuuɗuɓe no ka woɗɗitii, no ndaara, tawi ko ɓen tigi jokkunoo Iisaa gila Jaliilu fii ko kurkanoo mo. ");
INSERT INTO fuf_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Tawi no tawdanoo e maɓɓe Mariyama jeyaaɗo Magaduuna, e Mariyama yumma Yaaquuba e Yuusufu, e yumma ɓiɓɓe Zabadii ɓen. ");
INSERT INTO fuf_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ɓay niɓɓii, aaden alɗuɗo, wi'eteeɗo Yuusufu jeyaaɗo Raamati ari, tawi on kadi ko taalibaajo Iisaa. ");
INSERT INTO fuf_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","O yahi ka Pilaatu, o torii mo hettugol furee Iisaa on. Onsay Pilaatu yamiri jonnugol mo mo. ");
INSERT INTO fuf_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ɓawto ɗun, kanko Yuusufu o ƴetti furee on, o tumbi e kasannge laaɓuɗo, ");
INSERT INTO fuf_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","o belnoyi mo e qaburu keso mo o asunoo e feto fii hoore makko. O talli hayre njannde, o waɗi ka dambugal qaburu, o yahi. ");
INSERT INTO fuf_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Tawi Mariyama jeyaaɗo Magaduuna e Mariyama oya no jooɗii ɗon, fewtondiri e yenaande nden. ");
INSERT INTO fuf_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Bimbi nden ɲande, ɗun ko ɲande ɓawto hebulanagol fii *aseweere nden, hooreeɓe yottinooɓe sadaka ɓen e *Fariisiyaaɓe ɓen yaadi ka Pilaatu. ");
INSERT INTO fuf_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ɓe wi'i: «Koohoojo, men anditii, oo majjinoowo wi'uno wa fewndo ko o wuuri, si balɗe tati feƴƴii o immitoto. ");
INSERT INTO fuf_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Awa yamir fii yo yenaande nden ayne haa ka ɲalaande tammere, fii wota taalibaaɓe makko ɓen aru wujjita furee on, wi'a jamaa on wonde o immitike e hakkunde mayɓe ɓen. Ɗun, nden majjinannde ɗon ɓuray aranere nden.» ");
INSERT INTO fuf_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Onsay Pilaatu wi'i ɓe: «E hino suufaaɓe ko yaha ayna. Yahee ayninon ɓe yenaande nden yeru no waawirɗon woo.» ");
INSERT INTO fuf_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Onsay ɓe yahi ka yenaande, ɓe ɓurti hiɓɓude hayre nden, nota. Ɓe joɗɗini ɗon aynooɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ɓay *ɲalaande fowteteende nden feƴƴii, e alat ka subaka, ɗun ko ɲallal aranal e nder yontere nden, Mariyama jeyaaɗo Magaduuna e Mariyama oya yahi ndaarugol yenaande nden. ");
INSERT INTO fuf_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Tawi dimbannde leydi tiiɗunde waɗii, ko fii hari malaa'ikaajo Joomiraaɗo on tippike iwrude ka kammu, tallii hayre ombiranoonde yenaande nden, jooɗike e hoore mayre. ");
INSERT INTO fuf_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Tawi yeeso makko ngon no wa'i wa ndaygu, dolokke makko on kadi no rawniri wa cuddi. ");
INSERT INTO fuf_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Hakkee ko ɓen suufaaɓe aynunooɓe ɗon diwni kulol, ɓe wa'i wa mayɓe. ");
INSERT INTO fuf_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Kono malaa'ikaajo on wi'i ɓen rewɓe: «Onon wota on hulu, ko fii miɗo andi ko Iisaa fempaaɗo on wonɗon ɗaɓɓitude. ");
INSERT INTO fuf_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Awa o alaa ɗoo, o immitike, wano o wiirunoo non. Aree ndaaron nokkuure ka o belinoo ɗon. ");
INSERT INTO fuf_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Yahon tinna, andinoyon taalibaaɓe makko ɓen wonde o immintinaama e hakkunde mayɓe ɓen, awa kadi o adoyto on Jaliilu. Ko ton yi'oyton mo. Awa, mi yeetike on ɗun.» ");
INSERT INTO fuf_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Onsay ɓe pottitii yenaande nden heɲa, e hoore hiɓe huli, wondude e weltaare mawnde. Ɓe dogi fii yeetoyagol taalibaaɓe ɓen on kibaaru. ");
INSERT INTO fuf_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Onsay Iisaa ari fotti e maɓɓe, o wi'i ɓe: «Mi salminii on!» Onsay ɓe ɓadii, ɓe nangi koyɗe makko ɗen, ɓe sujjani mo. ");
INSERT INTO fuf_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ɓawto ɗun Iisaa wi'i ɓe: «Wota on hulu. Yahee, humpitoyon musiɓɓe an ɓen, yo ɓe yahu Jaliilu, ko ton ɓe yi'oytammi.» ");
INSERT INTO fuf_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Wa fewndo ko ɓen rewɓe woni ka laawol, tawi woɓɓe e suufaaɓe ɓen naatii ka saare, ɓe yeetike hooreeɓe *yottinooɓe sadaka ɓen ko waɗi kon fow. ");
INSERT INTO fuf_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ɓay wonii ɓen hooreeɓe yottinooɓe sadaka mottondirii e mawɓe ɓen, ɓe fewjodi, ɓe yeeni suufaaɓe ɓen kaalisi ɗuuɗuɗo, ");
INSERT INTO fuf_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ɓe wi'i ɓe: «On wi'ay wonde taalibaaɓe makko ɓen arno jemma, wujjiti mo fewndo ko ɗaaniɗon. ");
INSERT INTO fuf_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Si hooreejo diiwal ngal non aru e nanude fii ɗun, men yahay, men yewta mo haa o hooloo, men itta on e annde.» ");
INSERT INTO fuf_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Onsay suufaaɓe ɓen ƴetti kaalisi on, ɓe waɗiri wano ɓe wi'iraa non. Kaa haala lolli e hakkunde Yahuudiyankeeɓe ɓen haa weetaango hande ngoo. ");
INSERT INTO fuf_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Taalibaaɓe ɓen sappoo e goo yahi Jaliilu, e hoore ngoo fello ngo Iisaa toɗɗaninoo ɓe. ");
INSERT INTO fuf_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ɓay wonii ɓe yi'ii mo, ɓe sujjani mo. Kono woɓɓe e maɓɓe sikkitii. ");
INSERT INTO fuf_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Iisaa ɓadii ɓe, wi'iri ɓe nii: «Mi yeɗaama kala bawgal ka kammu e ka hoore leydi, ");
INSERT INTO fuf_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","awa yahee, waɗon leƴƴi ɗin fow taalibaaɓe, *looton ɓe maande kisiyee e innde Baabaajo on e Ɓiɗɗo on e *Ruuhu Seniiɗo on, ");
INSERT INTO fuf_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","waajoɗon ɓe ɗoftagol ko mi yamiri on kon fow. Awa, miɗo wondi e mon ɲande woo, haa ka lannoode aduna.»");
INSERT INTO fuf_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ko fuɗɗoode Kibaaru Moƴƴo Iisaa Almasiihu, *Ɓiɗɗo Alla on, nii. ");
INSERT INTO fuf_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Wano windori non ka deftere annabi *Isaaya: «Awa, miɗo imminde nulaaɗo an on yeeso maa, fii ko fertano-maa laawol maa ngol.» ");
INSERT INTO fuf_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","«Kaa hawa ko hawa ewnotooɗo ka wulaa, wi'a: ‹Moƴƴinee laawol Joomiraaɗo on, fewnon juri makko ɗin!› » ");
INSERT INTO fuf_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Yaayaa yaltiti no *loota maande tuubuubuyee ka wulaa, e himo waajoo yimɓe ɓen yo ɓe aru, ɓe *lootee maande tuubuubuyee fii yo junuubaaji maɓɓe ɗin yaafe. ");
INSERT INTO fuf_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Yimɓe diiwal *Yahuuda ngal fow e hoɗuɓe *Yerusalaam ɓen fow ari e makko. Ɓe qirritii junuubaaji maɓɓe ɗin, o looti ɓe maande tuubuubuyee ka maayo Yurdayniwol. ");
INSERT INTO fuf_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Tawi dolokke Yaayaa on ko leeɓi ngelooba, dattol keeci makko ɗin ko guri. Tawi ko kanu e njuuri buruure o ɲaamata. ");
INSERT INTO fuf_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Kanko Yaayaa o wi'i: «Ɓurɗo lan doole on no arude ɓaawo an mo mi hewtaa hay ugginagol, firta ɓoggi paɗe mun. ");
INSERT INTO fuf_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Min ko ndiyan mi woni on lootirde, kono kanko ko *Ruuhu Seniiɗo on o lootirta on.» ");
INSERT INTO fuf_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ko e on saa'i ɗon Iisaa iwi saare Naasirata e nder Jaliilu. Yaayaa looti mo Yurdayniwol. ");
INSERT INTO fuf_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","E saa'i mo o ƴawaynoo ka ndiyan on, o yi'i kammu ngun no udditoo, Ruuhu Allaahu on no tippora e makko wa gabooru. ");
INSERT INTO fuf_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Onsay hawa nanii ka kammu, no wi'a: «Ko an woni Ɓiɗɗo an yiɗaaɗo on, miɗo weltor-maa.» ");
INSERT INTO fuf_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Onsay kisan, Ruuhu Allaahu on nawri Iisaa ka wulaa. ");
INSERT INTO fuf_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","O woni ka wulaa e nder balɗe cappanɗe nay, Ibuliisa no ndarndoo mo. Tawi ko kulle buruure ɗen o wondi, malaa'ikaaɓe ɓen no kurkanoo mo. ");
INSERT INTO fuf_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ɓay wonii Yaayaa wattaama e joge, Iisaa yahi Jaliilu, tawi himo waajoo fii Kibaaru Moƴƴo Alla on, ");
INSERT INTO fuf_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","himo wi'a: «Saa'i on hewtii, awa kadi *laamu Alla ngun ɓadike! Tuubee, gomɗinon Kibaaru Moƴƴo on!» ");
INSERT INTO fuf_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","E nder ko o takkotoo *Weendu Jaliilu ndun kon, o yi'i Sim'uunu e Andaraawu miɲɲiraawo mun on no bugoo *jalaaji ka weendu, ko fii hari ko ɓe yungooɓe. ");
INSERT INTO fuf_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Iisaa wi'i ɓe: «Jokkee lan, mi wattay on yungooɓe yimɓe.» ");
INSERT INTO fuf_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ɗon kisan ɓe acciti jalaaji ɗin, ɓe jokki mo. ");
INSERT INTO fuf_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","No ɓe yaarunoo seeɗa, Iisaa yi'i Yaaquuba ɓiɗɗo Zabadii on, e Yuuhanna miɲan makko kanko Yaaquuba, tawi ɓen kadi no e nder laana, hiɓe moƴƴintina jalaaji maɓɓe. ");
INSERT INTO fuf_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Kanko Iisaa o noddi ɓe kisan, ɓe acci ɗon ben maɓɓe Zabadii ka nder laana, wondude e ƴettanooɓe golle ɓen, ɓe jokki mo. ");
INSERT INTO fuf_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ɓe yahi Kafernahuum. E *ɲalaande fowteteende nden, ɗun ko aseweere nden, Iisaa naati ka juulirde, woni e jannugol. ");
INSERT INTO fuf_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ko o jannaynoo kon ŋalɗini jamaa on, ko fii himo janniraynoo bawgal, hara wonaa wano jannooɓe fii Sariya on ɓen janniraynoo non. ");
INSERT INTO fuf_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Hawrondiri neɗɗo no ka juulirde maɓɓe ɗon mo jinnawii bonngii nangi, on sonki, wi'i: ");
INSERT INTO fuf_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","«Hey ko honɗun faalanaɗaa men, an Iisaa oo jeyaaɗo Naasirata? Hara ko mulugol men aranɗaa? Min miɗo andi ko hombo wonu-maa, ko a *Seniiɗo mo Alla!» ");
INSERT INTO fuf_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Onsay Iisaa yamiri ngii, wi'i: «Fanku, yaltaa e oo neɗɗo!» ");
INSERT INTO fuf_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Onsay ngin jinnawii yeƴi on neɗɗo, ngii yalti e makko, hingii haaca ko tiiɗi. ");
INSERT INTO fuf_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Fow ŋalɗi, landondiri, ɓe wi'i: «Ko honɗun woni ɗu'un? Ko jannde heyre ardunde bawgal. Himo yamira hay jinnaaji bonɗi ɗin, ɗi ɗoftoo mo!» ");
INSERT INTO fuf_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Onsay kisan, kibaaru fii makko lolli e nder diiwal Jaliilu ngal fow. ");
INSERT INTO fuf_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ɓay ɓe yaltii ka juulirde ɗon, kamɓe e Yaaquuba e Yuuhanna, ɓe yahi ka galle Sim'uunu e Andaraawu. ");
INSERT INTO fuf_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Tawi esiraawo Sim'uunu suddiiɗo on no waalii nawnaare nguli-ɓandu. Tun, ɓe wowlani Iisaa fii makko. ");
INSERT INTO fuf_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Iisaa ɓadii mo, nangi jungo ngon, immini mo. Nguli-ɓandu kin yalti e makko, kanko debbo on o woni e kurkanagol ɓe. ");
INSERT INTO fuf_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ɓay niɓɓii, wonii naange ngen mutii, ɓe addani mo ɲawɓe ɓen fow e ɓe jinna nangi ɓen fow. ");
INSERT INTO fuf_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Tawi saare nden fow no mottondiri ka yeeso dambugal. ");
INSERT INTO fuf_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","O sellini ɲawɓe buy, tampirnooɓe ɲabbeeli nooneeji nooneeji. O raɗii kadi jinnaaji buy, o salii ɗi wowla, ɓay hari hiɗi andi mo. ");
INSERT INTO fuf_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Bimbi nden ɲande subaka, tawi hentaaki taho, o immii, o yalti, o yaari e nokkuure wulɗinnde, o woni e toragol Alla. ");
INSERT INTO fuf_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Onsay Sim'uunu e ɓe o wondunoo ɓen woni e ɗaɓɓitugol mo. ");
INSERT INTO fuf_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ɓay wonii ɓe yi'ii mo, ɓe wi'i mo: «Fow no ɗaɓɓitude on.» ");
INSERT INTO fuf_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Iisaa jaabii ɓe, o wi'i: «Yahen ka koɗooli kawtirɗi e ɗoo, fii yo mi waajo ton kadi, ko fii ko ɗun addimmi.» ");
INSERT INTO fuf_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Onsay o yahi e nder Jaliilu fow, himo waajoo e nder juulirɗe ɗen, raɗoo jinna. ");
INSERT INTO fuf_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Onsay mo ɗamajan ari e makko, jiccii, jeeji mo, wi'i: «Si hiɗon yiɗi, hiɗon waawi lan sellinde, mi laaɓa.» ");
INSERT INTO fuf_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Iisaa yurmaa mo, fonti jungo mun ngon, meemi mo, wi'i: «Miɗo yiɗi, laato selluɗo laaɓaa.» ");
INSERT INTO fuf_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ɗon kisan, ɗamajan ɗan iwi e makko, o selli, o laaɓi. ");
INSERT INTO fuf_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Iisaa immintini mo kisan e hoore yamiroore sattunde, ");
INSERT INTO fuf_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","o wi'i mo: «Reeno wota a wowlan ɗun hay gooto, kono yahu hollitoyoɗaa *yottinoowo sadaka on, ittaa sadaka fii ko laɓɓinaɗaa kon wano Muusaa yamiri non, fii yo ɗun wonan ɓe seedee.» ");
INSERT INTO fuf_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ɓay wonii on neɗɗo yahii, o woni e wowlugol towna ko waɗi kon, e lollingol haa tawi Iisaa waawataa naatude han kadi e saare e kene, kono ko ka ɓaawo ka wulɗini o wonaynoo. Tawi no iwree e cenɗe ɗen fow, aree e makko. ");
INSERT INTO fuf_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Balɗe seeɗa ɓawto ɗun, Iisaa arti Kafernahuum, yimɓe ɓen andi wonde himo ka suudu. ");
INSERT INTO fuf_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Yimɓe ɗuuɗuɓe mooɓii ɗon, tawi hay ka dambugal alaa ka rewee, Iisaa no yewta ɓe daaluyee on. ");
INSERT INTO fuf_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Yimɓe nayo rondii maaya-ɓanduujo, addani mo. ");
INSERT INTO fuf_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Nde tawnoo ɓe waawataa mo hewtinde Iisaa sabu ɗuuɗugol jamaa on, ɓe tufi warɲakere nden fewndo ka Iisaa woni ɗon, ɓe tippindini on maaya-ɓanduujo e ɓoggi dimborɗi ɗin. ");
INSERT INTO fuf_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ɓay Iisaa yi'ii gomɗinal maɓɓe ngal, o wi'i maaya-ɓanduujo on: «Boobo an, junuubaaji maa ɗin yaafaama.» ");
INSERT INTO fuf_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Tawi woɓɓe e jannooɓe fii Sariya on no ɗon, hiɓe miijoo ka ɓerɗe maɓɓe: ");
INSERT INTO fuf_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«Ko fii honɗun oo kan wowliranta nii? Ɗun ko hoynugol Alla! Ko hombo waawi yaafaade junuubi, ko wonaa Alla?» ");
INSERT INTO fuf_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Iisaa andiri kisan ruuhu mun on miijooji maɓɓe ɗin. O wi'i ɓe: «Ko honɗun miijantoɗon ɗun ka ɓerɗe mon? ");
INSERT INTO fuf_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Enee, hakkunde wi'ugol maaya-ɓanduujo ‹junuubaaji maa ɗin yaafaama› e ‹immo ƴettaa ɓoggi-dimborɗi maa ɗin, yahaa›, ko honɗun e ɗii ɗoo ɓuri weeɓude? ");
INSERT INTO fuf_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Fii no andiron wonde *Ɓii-Aaden on no mari bawgal ka aduna ɗoo fii yaafagol junuubaaji», ");
INSERT INTO fuf_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","o wi'i jukkuɗo on: «Mi yamirii ma, immo ƴettaa ɓoggi-dimborɗi maa ɗin, hootaa ka maa.» ");
INSERT INTO fuf_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","On immii ɗon kisan yeeso maɓɓe, o ƴetti ɓoggi dimborɗi makko ɗin, o yalti. Sabu ɗun waɗi ɓe fow ɓe haawii, tawi hiɓe mawnina Alla, wi'a: «Hari haa hande men yi'aali sifa ɗun!» ");
INSERT INTO fuf_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Iisaa yiltori kadi ka daande weendu. Jamaa on fow ari e makko, o woni e jannugol ɓe. ");
INSERT INTO fuf_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Wa ko Iisaa feƴƴata, o yi'i Lewi mo Alfaa no jooɗii ka ƴantirde sagalle. O wi'i mo: «Aru jokkaa mi!» Kanko Lewi o immii, o jokki mo. ");
INSERT INTO fuf_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ɓawto ɗun, Iisaa jooɗii fii ɲaamugol ka suudu Lewi, tawi *ƴantooɓe sagalle ɗuuɗuɓe e junuubankeeɓe ɗuuɗuɓe no jooɗodi e makko, wondude e taalibaaɓe makko ɓen, ko fii hari jokkunooɓe mo ɓen no ɗuuɗi. ");
INSERT INTO fuf_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ɓay jannooɓe fii Sariya on, ɓe fedde *Fariisiyaaɓe ɓen, yi'ii himo ɲaamida e ƴantooɓe sagalle ɓen e junuubanke'en, ɓe wi'i taalibaaɓe makko ɓen: «E ko fii honɗun oo ɲaamidanta e ƴantooɓe sagalle ɓen e junuubanke'en?» ");
INSERT INTO fuf_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ɓay wonii Iisaa nanii ɗun, o wi'i ɓe: «Hinaa selluɓe ɓen hatonjini e ɲawndoowo, kono ko ɲawɓe ɓen. Awa min, wonaa noddugol feewuɓe ɓen mi arani, kono ko junuubankeeɓe ɓen.» ");
INSERT INTO fuf_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Tawi taalibaaɓe Yaayaa ɓen e Fariisiyaaɓe ɓen kaɲun no hoori. Ɓe ari, ɓe wi'i Iisaa: «Ko fii honɗun taalibaaɓe Yaayaa ɓen e ɓe Fariisiyaaɓe ɓen kaɲun hooranta, hara taalibaaɓe maa ɓen kan alaa hoorude?» ");
INSERT INTO fuf_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Iisaa jaabii ɓe, wi'i: «Taw si njaatigiiɓe jom jomba no waawi hoorude nde hiɓe wondi e jom jomba? Ɓe gasataa hoorude yeru jom jomba no wondi e maɓɓe. ");
INSERT INTO fuf_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Aray e saa'i nde jom jomba pottinaa e hakkunde maɓɓe. Onsay e ɗen balɗe ɗon ɓe hooray. ");
INSERT INTO fuf_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","«Hay gooto ƴettataa ceelol bagi keso walkira dolokke kiɗɗo. Ɗun haray kesun ɗun naɓoray fow, wuddere nden ɓurta yaajude. ");
INSERT INTO fuf_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Hay gooto kadi loowataa njaram kesan e nder bootooji guri kiɗɗi. Si hinaa ɗun, ɗan njaram kesan wonay sabu ko feeri ɗin guri. Onsay njaram ɗan woo, bootooji guri ɗin woo, bona. Kono njaram kesan ko e nder bootooji guri kesi loowetee.» ");
INSERT INTO fuf_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","E aseweere goo, ɗun ko *ɲalaande fowteteende nden, hari Iisaa no rewude e gese ngawri. E nder yaadu maɓɓe ndun, tawi taalibaaɓe makko ɓen no woocora cawti ɗen gese. ");
INSERT INTO fuf_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Fariisiyaaɓe ɓen wi'i mo: «Ko honɗun ɓee waɗanta ko dagaaki e ɲalaande fowteteende nden?» ");
INSERT INTO fuf_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Kono Iisaa jaabii ɓe, wi'i: «Hara on jangaali haa hande ko Daawuuda waɗunoo kon fewndo o weelaa, o faalaa ko o ɲaama, kanko e yimɓe wondunooɓe e makko ɓen? ");
INSERT INTO fuf_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","O naati ka nder suudu Alla fewndo oo *yottinoowo mawɗo sadaka wi'eteeɗo Abiiyaataraa, o ɲaami bireediije weeɓitaaɗe fii sadaka ɗen, ɗe tawata ko yottinooɓe sadaka ɓen tun daganinoo ɲaamugol, o okkori kadi wonduɓe e makko ɓen.» ");
INSERT INTO fuf_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","O wi'i ɓe kadi: «Aseweere nden ko fii yimɓe ɓen taganaa, yimɓe ɓen taganaaka fii aseweere nden. ");
INSERT INTO fuf_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ko ɗun si ko Ɓii-Aaden on woni jom hay ɲalaande fowteteende nden.» ");
INSERT INTO fuf_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Iisaa naatiti kadi ka juulirde. Tawi maaya-jungoojo no nder ton. ");
INSERT INTO fuf_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Nde tawnoo *Fariisiyaaɓe ɓen no faalaa tooɲude Iisaa, ɓe ayni mo, hiɓe ndaara si o ɲawnday mo e *ɲalaande fowteteende nden. ");
INSERT INTO fuf_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Iisaa wi'i on maaya-jungoojo: «Immo daroɗaa ka hakkunde ɗoo.» ");
INSERT INTO fuf_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ontuma Iisaa landii ɓen: «E hara no dagii ka goɗɗo waɗa ko moƴƴi maa ko boni, danda wonkii maa wona sabu makki e *aseweere?» Kono ɓe deƴƴi. ");
INSERT INTO fuf_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Onsay Iisaa ndaari ɓe e hoore himo tikki, aani fii sattere ɓerɗe maɓɓe ɗen. O wi'i on neɗɗo: «Fontu jungo maa ngon.» On fonti ngo, jungo makko ngon selli. ");
INSERT INTO fuf_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Onsay Fariisiyaaɓe ɓen yalti, ɓe woni e fewjodugol e yimɓe *Heroodu lanɗo on fii no ɓe warira Iisaa. ");
INSERT INTO fuf_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ɓawto ɗun, Iisaa e taalibaaɓe mun ɓen yaari ka weendu. Jamaa moolanaaɗo iwruɗo ka diiwal Jaliilu e ka diiwal Yahuuda ");
INSERT INTO fuf_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","e Yerusalaam e Iduuma e leyɗe wonirɗe gaɗa Yurdayniwol ɗen e ɗii baŋŋeeji Tiiri e Siduuna jokki mo. On jamaa, nanunooɗo ko o wonnoo waɗude kon fow ari e makko. ");
INSERT INTO fuf_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Onsay Iisaa yamiri taalibaaɓe mun ɓen yo ɓe ɗaɓɓan mo laakun fii wota jamaa on ɓiƴu mo. ");
INSERT INTO fuf_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Nde tawnoo himo sellinde yimɓe ɗuuɗuɓe, tampirnooɓe ɲabbeeli ɓen fow wubbi e makko fii meemugol mo. ");
INSERT INTO fuf_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Kono ɓe jinna nangi ɓen, si yi'ii Iisaa, jiccotono yeeso makko, ewnoo, wi'a: «Ko a *Ɓiɗɗo Alla!» ");
INSERT INTO fuf_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Kono kanko Iisaa o yamirayno ɗin jinnaaji, o tentina wota ɗi feɲɲin fii makko. ");
INSERT INTO fuf_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ɓawto ɗun, Iisaa ƴawi e fello, o noddi ɓe o faalaa ɓen, ɓen ari e makko. ");
INSERT INTO fuf_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","O suɓii sappoo e ɗiɗo, o toɗɗii ɓe *sahaabaaɓe, ko o wonda e mun, ko o immina waajoyoo, ");
INSERT INTO fuf_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","wondude e bawgal fii raɗagol jinnaaji ɗin. ");
INSERT INTO fuf_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ɓen sappoo e ɗiɗo, ɓe o toɗɗii, ko Sim'uunu, on mo o jammi Petruusu, ");
INSERT INTO fuf_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","e Yaaquuba mo Zabadii, e Yuuhanna neene-gooto on on (ɓen ɓe Iisaa jammi Bowanesiisa, ko woni firo ɗun ko «ɓiɓɓe-farɲitere»), ");
INSERT INTO fuf_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","e Andaraawu e Filiipu e Bartolomaawu e Matta e Tooma e Yaaquuba mo Alfaa e Taddaawu e Sim'uunu tawdaaɗo e fedde *Zelotiiɓe ɓen, ");
INSERT INTO fuf_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","e Yudaasi Iskariiyu, janfoytooɗo mo on. ");
INSERT INTO fuf_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ɓawto ɗun, kanko Iisaa o arti ka suudu. Yimɓe ɓen mooɓii kadi haa ka tawata kanko e taalibaaɓe makko ɓen ɓe waawataa hay ɲaamude. ");
INSERT INTO fuf_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ɓay siɓɓe Iisaa ɓen nanii ɗun, ɓe ari nangugol mo, ko fii hari hiɓe wi'a: «O wilike!» ");
INSERT INTO fuf_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Nde tawnoo jannooɓe fii Sariya on, iwruɓe Yerusalaam ɓen, no wi'a: «Balzabuula* no e makko, ko tippude e lanɗo jinnaaji ɗin o woni raɗorde jinnaaji ɗin.» ");
INSERT INTO fuf_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Onsay Iisaa noddi ɓe, yewtiri ɓe misal, o wi'i: «Ko honno Ibuliisa waawirta raɗorde Ibuliisa? ");
INSERT INTO fuf_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Si tawii laamateeri liddondirii kayri tigi, haray ndin laamateeri waawataa tabitude. ");
INSERT INTO fuf_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Awa kadi si suudu liddondirii, ndun suudu waawataa tabitude. ");
INSERT INTO fuf_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Si tawii non Ibuliisa dartike hoore mun tigi, o liddike hoore makko, haray o waawataa tabitude, haray fii makko lannii. ");
INSERT INTO fuf_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ko fii hay gooto waawataa naatude e nder galle neɗɗo dolnuɗo, o mooɓa keyeeji on ɗin, ado o haɓɓude on neɗɗo dolnuɗo. Ko onsay doo o waawata mooɓude ko woni ka suudu on kon. ");
INSERT INTO fuf_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ka haqiiqa mi andinii on, yimɓe ɓen yaafante junuubaaji ɗin fow e hoyreeji ɗi ɓe hoynata ɗin, ");
INSERT INTO fuf_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","kono kala hoynuɗo *Ruuhu Seniiɗo on heɓataa yaafuyee few, haray himo fawtii junuubu haa poomaa.» ");
INSERT INTO fuf_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ko Iisaa wi'iri ɓe ɗun, ko ɓay hiɓe wi'ude: «Jinna no e makko.» ");
INSERT INTO fuf_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Onsay yumma Iisaa e yumma-gootooɓe makko ɓen ari, darii ka yaasi. Ɓe immini goɗɗo ko noddana ɓe mo. ");
INSERT INTO fuf_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Tawi jamaa on no jooɗii, hundi mo, ɓe wi'i mo: «Yumma mon e yumma-gootooɓe mon ɓen no darii ka yaasi, hiɓe ɗaɓɓitude on.» ");
INSERT INTO fuf_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Iisaa jaabii ɓe, o wi'i: «Ko hombo woni yumma an e yumma-gootooɓe an ɓen?» ");
INSERT INTO fuf_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Onsay o laƴƴi gite e hoore jooɗiiɓe hundi mo ɓen, o wi'i: «E hino yumma an e yumma-gootooɓe an ɓen. ");
INSERT INTO fuf_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ko fii kala waɗuɗo faale Alla on, haray ko on woni yumma-gooto an on e bandiraawo an on e yumma an.» ");
INSERT INTO fuf_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Iisaa woni kadi e waajagol ka daande weendu. Hakkee ko jamaa mooɓinooɗo takko makko on ɗuuɗi, o bakii e laakun ka nder weendu, o jooɗii, jamaa on fow woni ka daande weendu. ");
INSERT INTO fuf_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","O janniri ɓe piiji buy mise. E nder ko o waajotoo kon, o wi'i: ");
INSERT INTO fuf_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«Heɗee, ko remoowo yaltunoo sankugol. ");
INSERT INTO fuf_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","E nder ko o sankata kon, gabbe goo yani ka ɗatal, colli ɗin ari moɗi ɗe. ");
INSERT INTO fuf_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Goɗɗe ɗen yani e hoore kaaƴe, ka leydi ɗuuɗaa, ɗe fuɗi heɲa sabu ɗewlugol leydi ndin. ");
INSERT INTO fuf_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ɓay naange ngen yaltii, ɗe sumi ɗe yoori sabu angal ka ɗaɗi ɗin siŋoo. ");
INSERT INTO fuf_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Goɗɗe goo kadi yani ka sooƴoore, ɗe fuɗidi e mayre, sooƴoore nden moɗi ɗe, laatii ɗe rimaali few. ");
INSERT INTO fuf_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Goɗɗe goo yani ka leydi moƴƴiri. Ɗe fuɗi, ɗe mawni, ɗe sawti, cawti goo gabbe cappanɗe tati, cawti goo cappanɗe jeegoo, cawti goo teemedere.» ");
INSERT INTO fuf_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","E hoore ɗun, o wi'i: «Mo no mari noppi nanirɗi yo nanu!» ");
INSERT INTO fuf_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ɓay luttii mo kanko tun, ɗowtunooɓe mo ɓen e *sahaabaaɓe sappoo e ɗiɗooɓe ɓen woni e landagol mo firo ɗee mise. ");
INSERT INTO fuf_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","O wi'i ɓe: «Onon on yeɗaama gundoo *laamu Alla ngun, kono ɓee ka yaasi, ɓe wowlirante fow mise, ");
INSERT INTO fuf_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","fii yo ɓe ndaaru, hara ɓe yi'ataa, yo ɓe nanu, hara ɓe faamataa, fii wota ɓe tuubu, junuubaaji maɓɓe ɗin yaafee.» ");
INSERT INTO fuf_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","O wi'i ɓe kadi: «On faamaali ngal misal ɗoo? Ko honno non faamiroyton ɗeya mise fow? ");
INSERT INTO fuf_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Remoowo on sanki awdi ndin, ɗun ko daalol ngol. ");
INSERT INTO fuf_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Woɓɓe no wa'i wa nde awdi sankaa ka ɗatal ka daalol ngol sankaa ɗon. Ɓe nana ngol tun, Ibuliisa ara, itta daalol sankaangol e maɓɓe ngol. ");
INSERT INTO fuf_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Woɓɓe goo kadi no wa'i wa nde awdi sankaa ka kaaƴe. Nde ɓe nani daalol ngol, ɓe jaɓa ngol heɲa e nder weltaare. ");
INSERT INTO fuf_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Kono ɓe alaa ɗaɗi, ko fii hinaa ɓe tabituɓe. Nde satteendeeji maa cukkeede aroyi sabu jokkugol maɓɓe daalol ngol, ɓe tertoto kisan. ");
INSERT INTO fuf_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Woɓɓe goo kadi no wa'i wa nde awdi sankaa ka sooƴoore. Ko ɓen woni nanooɓe daalol ngol, ");
INSERT INTO fuf_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","kono ngol ronka rimude e maɓɓe, ko fii haray ngol moɗiraama anndeeji aduna e ɗayniro jawle e faaleeji ngurndan goo. ");
INSERT INTO fuf_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ɓeya ɓen non no wa'i wa nde awdi sankaa ka leydi moƴƴiri. Ko ɓen woni nanooɓe daalol ngol, jaɓa, ngol rima e maɓɓe, woɓɓe goo laabi cappanɗe tati, woɓɓe goo laabi cappanɗe jeegoo, ɓeya ɓen laabi teemedere.» ");
INSERT INTO fuf_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","O wi'i ɓe kadi: «Taw si hara lampu ko ka wirnii waɗetee maa ko e ley danki? E hara hinaa ka kene? ");
INSERT INTO fuf_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ko fii alaa ko suuɗii ko feeɲataa, awa kadi kala gundoo ko sakkitorta ko feeɲugol. ");
INSERT INTO fuf_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Mo no mari noppi nanirɗi yo nanu!» ");
INSERT INTO fuf_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","O wi'i ɓe kadi: «Wattanee yiila e ko heɗotoɗon kon. Ko fii ko sariyaare nde etirɗon nden etiranteɗon, ɓeyditaneɗon kadi. ");
INSERT INTO fuf_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ko fii ko marɗo ɓeydantee, kono mo maraa on jaɓitante hay yeru ko o mari kon.» ");
INSERT INTO fuf_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","O wi'i ɓe kadi: «Laamu Alla ngun no wa'i wa nde neɗɗo ƴetti awdi, sanki ka leydi. ");
INSERT INTO fuf_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Woni o ɗaanii woo, o ɗaanaaki woo, jemma e ɲalorma awdi ndin fuɗay, njanɗa, hara ko no o andiraa. ");
INSERT INTO fuf_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Leydi ndin fuɗinanay hoore mun, ndi adora puɗol ngol, hikka cawtol ngol, si gabbe ɗen kadi moƴƴinoo moƴƴa ka cawtol. ");
INSERT INTO fuf_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","No gabbe ɗen ɓendiri, wortowal ngal no ƴetteede, ko fii haray baagol ngol fewndike.» ");
INSERT INTO fuf_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","O wi'i kadi: «Ko honɗun eɓɓindirten e laamu Alla ngun, maa ko misal hongal hollirten ɗun? ");
INSERT INTO fuf_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Hingu wa'i wa abbere bene, kon ko ɓuri fanɗude e ko aawetee kon fow ka leydi. ");
INSERT INTO fuf_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Kono si wonii nde aawaama, nde hawtoo, nde njanɗa, nde ɓura ko aawetee e naakoo kon fow, nde waɗa calɗi njani haa ka tawata colli ɗin ka weeyo waaway hoɗude ka ley ɗowdi makki.» ");
INSERT INTO fuf_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ko mise buy wa'itaynooɗe nii o yewtiraynoo ɓe daaluyee on, noone no ɓe waawiraynoo faamirde. ");
INSERT INTO fuf_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","O yewtirtaano ɓe si wonaa mise, kono si wonii ka weddii o sifantono fow taalibaaɓe makko ɓen. ");
INSERT INTO fuf_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Nden ɲande kiikiiɗe Iisaa wi'i ɓe: «Lumbiten gaɗa.» ");
INSERT INTO fuf_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ɓe acciti jamaa on, ɓe naɓori Iisaa ka weendu e nder laakun kun o wonnoo e mun kun, laaɗe goo ɗowti ɓe. ");
INSERT INTO fuf_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Tun waabiliire tiiɗunde wondunde e hendu woni e wifugol, tawi morlooɗe ndiyan ɗen no piyoo e laakun kun, kun heewa ndiyan. ");
INSERT INTO fuf_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Tawi kanko Iisaa himo awlii ngawlu, ɗaanii ɓaawo. Ɓe findini mo, ɓe wi'i: «Karamoko'en, e on kippataa fii ko men woni mulude kon?» ");
INSERT INTO fuf_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","O immii, o toŋani hendu ndun, o wi'i ndiyan ɗan: «Deeƴu, fankaa!» Hendu ndun deƴƴi, deeƴaango tiiɗungo waɗi. ");
INSERT INTO fuf_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","E hoore ɗun o wi'i ɓe: «Ko fii honɗun hulanɗon? E hara on alaa gomɗinal haa jooni?» ");
INSERT INTO fuf_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ɓe huli kulol tiiɗungol, ɓe wi'indiri: «Ko hombo woni oo? Ko fii hay keneeli ɗin e baharu on ɗoftoto mo!» ");
INSERT INTO fuf_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ɓe hewtoyi gaɗa weendu ndun, ɗun ko e ndii leydi ɓee Gadariyankooɓe. ");
INSERT INTO fuf_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Nde Iisaa tippornoo ka laana, aaden mo jinna woni e mun iwri ka genaale, ari yeeso makko. ");
INSERT INTO fuf_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Tawi ka on mari hoɗo ko ka genaale. Hari hay gooto waawataa mo haɓɓude hande kadi, hay si tawii non ko jolokooje. ");
INSERT INTO fuf_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ko fii hari soono woo o dumbete, o jolkee, o taƴa jolokooje ɗen, o hela dumbirɗe ɗen. Tawi hay gooto waawataa mo ɗahude. ");
INSERT INTO fuf_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Tawi jemma e ɲalorma ko ka genaale e ka pelle o tabiti, e himo sonka, barmintinora kaaƴe. ");
INSERT INTO fuf_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","No o haccornoo Iisaa ka woɗɗi, o dogi, o ari, o jiccii yeeso makko, ");
INSERT INTO fuf_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","o ewnii ko tiiɗi, o wi'i: «Ko honɗun faalanaɗaa lan, an oo *Ɓiɗɗo Alla Jom Ɓural? Mi torike ma fii Alla, wota a lettan!» ");
INSERT INTO fuf_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ko fii hari Iisaa no wi'ude ngii: «Yaltu e oo neɗɗo, yo jinnawii!» ");
INSERT INTO fuf_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Onsay Iisaa landii mo: «Ko honno inneteɗaa?» On jaabii: «Ko ‹Konu›, ko fii meɗen ɗuuɗi!» ");
INSERT INTO fuf_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Awa kadi hiɗi jeejaynoo mo fota fii wota o yaltin ɗi leydi ndin. ");
INSERT INTO fuf_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Tawi wuro kose moolanaango no ooraynoo ka binde falo ɗon. ");
INSERT INTO fuf_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Onsay jinnaaji ɗin jeeji Iisaa, hiɗi wi'a: «Nawru men e ɗii koseeji fii no men naatira e nder majji!» ");
INSERT INTO fuf_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","O newnani ɗi ɗun. Jinnaaji ɗin yalti e on neɗɗo, ɗi naati e nder ɗin koseeji. Onsay koseeji ɗin giddi ka falo, ɗi unoyii ka weendu, ɗi yoolii, tawi ko wa ɗi guluuji ɗiɗi. ");
INSERT INTO fuf_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Onsay ornaynooɓe ɗi ɓen dogi, ɓe fillitoyii ɗun ka saare e ka fulawaaji, yimɓe ɓen ari yi'ugol kon ko waɗi. ");
INSERT INTO fuf_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ɓay ɓe arii e Iisaa, ɓe yi'ii on mo konu jinna wonnoo e mun no jooɗii ɓornii, wondi e hakkille timmuɗe, ɓe huli. ");
INSERT INTO fuf_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Yi'unooɓe ko waɗi kon fillitanii ɓe ko waɗi e hoore jinnanooɗo on kon e ko waɗi e koseeji ɗin kon. ");
INSERT INTO fuf_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Onsay ɓe woni e jeejugol Iisaa fii yo o yaltu ka leydi maɓɓe. ");
INSERT INTO fuf_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Wa ko kanko Iisaa o ƴawata ka laana, jinnanooɗo on torii mo yo o accu ɓe wonda. ");
INSERT INTO fuf_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Laatii Iisaa newnanaali mo, kono o wi'i mo: «Yahu ka mon, ɗun ko ka siɓɓe maa ɓen, fillitanoɗaa ɓe ko Joomiraaɗo on waɗan-maa kon fow e ko honno o yurmira-maa.» ");
INSERT INTO fuf_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Onsay o yahi, o woni e fillitagol e nder *Dekapooli ko Iisaa waɗani mo kon fow. Heɗiiɓe mo ɓen fow ŋalɗi. ");
INSERT INTO fuf_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ɓay Iisaa ƴettii laana kan, lumbitoyii gaɗa, jamaa moolanaaɗo ari, mooɓii takko makko kadi ka daande weendu. ");
INSERT INTO fuf_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Tun goɗɗo e hooreeɓe juulirde nden wi'eteeɗo Yaayirusu, ari. Ɓay o yi'ii mo, o yani e ley koyɗe makko. ");
INSERT INTO fuf_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","O torii mo, o jeeji e hoore himo wi'a: «Ɓiɗɗo an jiwo on no e daande mayde. Seenee fawon sookeeje mon ɗen e makko fii no o daɗira, o wuura.» ");
INSERT INTO fuf_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Onsay Iisaa yaadi e makko. Jamaa ɗuuɗuɗo jokki mo, ɓittiri mo cenɗe ɗen fow. ");
INSERT INTO fuf_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Tawi kadi debbo no ɗon, heɓii duuɓi sappoo e ɗiɗi himo soncaade. ");
INSERT INTO fuf_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Tawi o tampii fota e juuɗe ɲawndooɓe ɗuuɗuɓe, awa kadi o ittii ko o jogii fow, ɗun nafaali huunde, kono ɲaw ngun ɓurtu. ");
INSERT INTO fuf_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ɓay o nanii fii Iisaa no wowlee, o ari e jamaa on, o wontiri ɓaawo Iisaa, o meemi dolokke makko on, ");
INSERT INTO fuf_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","ko fii hari kanko debbo on himo miijoo: «Si mi waawii tun meemude conci makko ɗin, mi ndikkay.» ");
INSERT INTO fuf_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","E on saa'i tigi ko o soncotonoo kon taƴi, o andi ka ɓandu makko wonde o ndikkii ɲaw makko ngun. ");
INSERT INTO fuf_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Tun Iisaa andi wonde bawgal makko ngal gollii goɗɗun. O yeƴƴitii e hakkunde mbatu ngun, o wi'i: «Ko hombo meemi conci an ɗin?» ");
INSERT INTO fuf_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Taalibaaɓe makko ɓen wi'i mo: «Ndaaree jamaa ko ɓitti on, si hiɗon maaka ‹ko hombo meemi lan?› » ");
INSERT INTO fuf_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Onsay o laƴƴi gite takko makko fii yo o yi'u waɗuɗo ɗun on. ");
INSERT INTO fuf_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Nde tawnoo debbo on no andi ko feƴƴi e makko kon, o huli, o diwni, o ari o yani e ley koyɗe Iisaa, o wowlani mo goonga on fow. ");
INSERT INTO fuf_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Kono Iisaa wi'i mo: «Jiwo an, gomɗinal maa ngal sellinii ma. Yahu e hoore ɓuttu, sellaa ɲaw ngu wonduɗaa ngun.» ");
INSERT INTO fuf_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Wa fewndo ko Iisaa yewtata ɗun, woɓɓe e jeyaaɓe ka hooreejo juulirde nden iwi ton ari, wi'i mo: «Jiwo maa on maayii. Ko fii honɗun sonjantaa oo karamokoojo?» ");
INSERT INTO fuf_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Kono ɓay Iisaa nanii ɗun, o wi'i hooreejo juulirde nden: «Wota a hulu, gomɗin tun.» ");
INSERT INTO fuf_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Kono laatii Iisaa jaɓaano hay gooto ɗowta mo, si hinaa Petruusu e Yaaquuba e Yuuhanna neene-gooto Yaaquuba on. ");
INSERT INTO fuf_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ɓay ɓe hewtii ka hooreejo juulirde nden, kanko Iisaa o yi'ii jiiɓoldu ndun e ko yimɓe ɓen wullata fesa ko tiiɗi kon. ");
INSERT INTO fuf_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","O naati, o wi'i ɓe: «Ko honɗun woni nduu jiiɓoldu e ɗii gonɗi? Ko fii jiwo on maayaali, o ɗaani.» ");
INSERT INTO fuf_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ɓe jali mo. Onsay o yaltini ɓe fow, o ƴetti ben jiwo on e yumma jiwo on, wondude e ɗowtunooɓe mo ɓen, ɓe naati ka jiwo on woni ɗon. ");
INSERT INTO fuf_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","O nangi jungo jiwo on, o wi'i mo: «Talitaa kumi!» (ko woni firo ɗun: «Mi wi'ii ma: ‹Jiwo, immo!› ») ");
INSERT INTO fuf_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ɗon kisan jiwo on immii, o woni e jindugol, ko fii hari ko mo o duuɓi sappoo e ɗiɗi. Kaawee mawɗo heɓi ɓe. ");
INSERT INTO fuf_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Iisaa yamiri ɓe, tentini, wota hay gooto andu ɗun. O wi'i ɓe yo ɓe okkor jiwo on ko o ɲaama. ");
INSERT INTO fuf_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Onsay Iisaa iwi ɗon, o yahi ka leydi makko. Taalibaaɓe makko ɓen kadi jokki mo. ");
INSERT INTO fuf_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ɓay wonii *ɲalaande fowteteende nden hewtii, ɗun ko *aseweere nden, o woni e waajagol ka juulirde. Tawi ɗuuɗuɓe no heɗotonoo mo. Ɓe ŋalɗi, ɓe wi'i: «Ɗun ko honto iwrani oo? Ko hongu woni nguu faamu ngu oo yeɗaa, e ko honno sifa ɗii kaawakeeji moƴƴi woni waɗirde e juuɗe makko? ");
INSERT INTO fuf_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","E hinaa minisiyeejo on nii? Hinaa kanko woni ɓiɗɗo Mariyama on? E hara neene-gootooɓe makko ɓen hinaa Yaaquuba e Yuusufu e Yuudu e Sim'uunu? E hinaa bandiraaɓe makko ɓen no wondi e men ɗoo?» Ɗun haɗi ɓe gomɗingol mo. ");
INSERT INTO fuf_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Kono Iisaa wi'i ɓe: «Annabaajo ko ka leydi mun tun e ka musidal mun e ka ɓeynguure mun yawaa.» ");
INSERT INTO fuf_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Laatii o waawaali waɗude ɗon kaawake woo, si hinaa *fawugol juuɗe e hoore nawnuɓe goo, sellina ɓe. ");
INSERT INTO fuf_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Kono o ŋalɗi sabu angal gomɗinal maɓɓe ngal. O jindi e koɗooli hunduɗi ɗon ɗin, o janni. ");
INSERT INTO fuf_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Onsay o noddi sappoo e ɗiɗooɓe ɓen, o woni ɓe e imminirgol ɗiɗo ɗiɗo e hoore jonnugol ɓe bawgal raɗagol jinnaaji ɗin. ");
INSERT INTO fuf_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","E hoore ɗun, himo yamiri ɓe wota ɓe ƴettu hay huunde ko ɓe yooɓoo, si hinaa tuggordu wooturu tun: hinaa bireedi, hinaa bonfooji, hinaa ƴettugol dattol mbuuɗi. ");
INSERT INTO fuf_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Kono o wi'i ɓe: «On wattoto paɗe, kono wota on ɓorno dolokkaaji ɗiɗi.» ");
INSERT INTO fuf_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","O wi'i ɓe kadi: «Kala suudu ndu naatoyɗon e mun, weeree ɗon haa nde hiɗon iwa e nden nokkuure woo. ");
INSERT INTO fuf_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Kono si woodii e saare nde yimɓe ɓen jaɓaali on, heɗii on, nde hiɗon yalta ɗon woo, honkee mbullaari teppe mon ɗen fii yo ɗun wonan ɓe seedee ella maɓɓe on.» ");
INSERT INTO fuf_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ɓe yahi ɓe waajoyii fii yo yimɓe ɓen tuubu. ");
INSERT INTO fuf_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Tawi hiɓe raɗoo jinnaaji ɗuuɗuɗi, juura nebbe e ɲawɓe ɗuuɗuɓe, sellina ɓe. ");
INSERT INTO fuf_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Heroodu* lanɗo on humpitii ɗun. E hoore ɗun tawi innde Iisaa nden lollii, hiɓe wi'a: «Yaayaa lootaynooɗo maande tuubuubuyee on immitike e hakkunde mayɓe ɓen! Ko ɗun waɗi si himo mari bawgal waɗugol kaawakeeji moƴƴi.» ");
INSERT INTO fuf_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Tawi woɓɓe ɓen no wi'a wondema ko Iiliiya, ɓeya ɓen kadi no wi'a ko annabaajo wa goɗɗo e annabaaɓe hiɓɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Kono ɓay Heroodu nanii ɗun, tawi himo wi'a: «Ko Yaayaa, on mo mi waɗi haa daande mun taƴaa. Ko on woni ko immitii!» ");
INSERT INTO fuf_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ko fii hari kanko Heroodu tigi o nangiino Yaayaa, o jolkii mo, o waɗii e kaso, sabu oo debbo wi'eteeɗo Heroodiiya mo kanko Heroodu o ƴetti, tawi-le on ko ɓeyngu Filiipu, yumma-gooto makko on nun kanko Heroodu, ");
INSERT INTO fuf_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","sabu ko Yaayaa wi'unoo mo kon wonde daganaaki mo ka o ƴetta ɓeyngu yumma-gooto makko on. ");
INSERT INTO fuf_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Tawi oo debbo wi'eteeɗo Heroodiiya no haamanii mo kanko Yaayaa, no faalaa mo warude, kono o waawaali, ");
INSERT INTO fuf_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ko fii hari Heroodu no huli Yaayaa, sabu ko o andi kon on ko neɗɗo feewuɗo laaɓuɗo, jaka himo hiwunoo mo. Tawi himo yiɗunoo heɗagol mo, fii kala si o nanii himo yewta, o jiɓotono fota. ");
INSERT INTO fuf_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Kono ɲande goo kanko Heroodiiya o heɓi sabu weeɓanɗo mo e nder ngal caatal, ngal Heroodu waɗani ɓe o lammini ɓen e hooreeɓe suufaaɓe makko ɓen e hooreeɓe ɓen Jaliilu fii anditugol jibineede makko kanko Heroodu ngol. ");
INSERT INTO fuf_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","E nder ɗun, jiwo Heroodiiya on naati, ami, o weli Heroodu e saatinaaɓe ɓen. Onsay lanɗo on wi'i jiwo on: «Toro lan kala ko faalaɗaa, mi waɗante.» ");
INSERT INTO fuf_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","O waɗani mo ndee woondoore ɗoo, o wi'i: «Kala ko toriɗaa mi, mi waɗante, hay si ko feccere laamateeri an ndin.» ");
INSERT INTO fuf_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Kanko jiwo on o yalti, o landii yumma makko: «Ko honɗun mi landotoo?» Neene makko jaabii mo wi'i: «Ko hoore Yaayaa lootoowo maande tuubuubuyee on.» ");
INSERT INTO fuf_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Kanko jiwo on o hawjiti kisan, o naati, o ari e lanɗo on, o wi'i: «Miɗo faalaa yo a jonnan ɗoo hoore Yaayaa lootoowo on kisan, hara hinde tumbaa e miran!» ");
INSERT INTO fuf_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Onsay lanɗo on aani, kono sabu woondooje makko ɗen, e ɓe o saatinnoo ɓen, tawi o faalaaka mo salanaade. ");
INSERT INTO fuf_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","O immini kisan suufaajo, o yamiri mo addoygol hoore Yaayaa nden. Suufaajo on yahi, taƴoyi hoore Yaayaa nden ka kaso, ");
INSERT INTO fuf_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","o addi hoore nden e nder miran, o jonni jiwo on. Jiwo on kadi jonnoyi nde yumma mun. ");
INSERT INTO fuf_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ɓay wonii ɗun andike, taalibaaɓe Yaayaa ɓen ari, ƴetti furee makko on, ɓe surroyi. ");
INSERT INTO fuf_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Sahaabaaɓe* ɓen mottondiri takko Iisaa, ɓe sifanii mo ko ɓe waɗi kon fow e ko ɓe janni kon. ");
INSERT INTO fuf_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Onsay o wi'i ɓe: «Aree ka weddii, hara ko ka wulɗini, fowtoɗon seeɗa.» Ko fii hari yimɓe buy no waɗa yaha ara, tawi Iisaa e taalibaaɓe mun ɓen alaa hay feere no ɓe ɲaamira. ");
INSERT INTO fuf_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Onsay kamɓe tun ɓe bakii e laana fii yahugol e nokkuure wulɗinnde. ");
INSERT INTO fuf_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Buy yi'i hiɓe yaha, anditi ɓe. Yimɓe ɓen ka ca'e fow dogi, aditoyii ɓe ka ɓe yahaynoo ton. ");
INSERT INTO fuf_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ɓay wonii kanko Iisaa o tippike ka laana, o yi'i jamaa ɗuuɗuɗo, o yurmaa ɓe, ko fii hari hiɓe wa'i wa baali ɗi alaa ngaynaako. Onsay o woni ɓe e jannugol piiji ɗuuɗuɗi. ");
INSERT INTO fuf_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Nde tawnoo ɲallal ngal pooɗike, taalibaaɓe makko ɓen ɓadii mo wi'i: «Ndee nokkuure ko wulɗinnde, awa kadi ɲallal ngal pooɗike. ");
INSERT INTO fuf_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Accitee ɓe, ɓe yaha ka fulawaaji e ka koɗooli kawtirɗi e ɗoo, ɓe ɗaɓɓoya ko ɓe ɲaama.» ");
INSERT INTO fuf_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Iisaa jaabii ɓe wi'i: «Onon tigi okkoree ɓe ko ɓe ɲaama.» Kono ɓe wi'i mo: «E hara men yahay, men soodoya bireedi yeru *dinaruuji teemeɗɗe ɗiɗi, men okkora ɓe ko ɓe ɲaama?» ");
INSERT INTO fuf_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Onsay o jaabii ɓe, o wi'i: «Ko bireediije jelu marɗon? Yahee ndaaroyon.» Ɓe yahi, ɓe humpitoyii, ɓe ari, ɓe wi'i mo: «Ko bireediije jowi e liƴƴi ɗiɗi.» ");
INSERT INTO fuf_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Onsay o yamiri ɓe yo ɓe joɗɗinir ɓe fow mojobe mojobe ka hoore huɗo hecco. ");
INSERT INTO fuf_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ɓe joɗɗiniri ɓe saffeeji saffeeji, ɗi yimɓe teemedere, e ɗi yimɓe cappanɗe njowo. ");
INSERT INTO fuf_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","O ƴetti bireediije ɗen jowi e liƴƴi ɗin ɗiɗi, o ɓanti gite ɗen, o fewtini ka kammu, o du'ii. Onsay o taƴiti bireedi on, o woni e jonnugol taalibaaɓe ɓen ko hewtina jamaa on. O senditi kadi liƴƴi ɗin e hakkunde fow. ");
INSERT INTO fuf_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Fow ɲaami haa haari. ");
INSERT INTO fuf_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ɓe mooɓiti debeeje sappoo e ɗiɗi tew kunte bireedi e liƴƴi. ");
INSERT INTO fuf_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ɓen ɲaamunooɓe on bireedi hari ko ɓe worɓe guluuje njowo. ");
INSERT INTO fuf_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ɓawto ɗun kisan, o yamiri taalibaaɓe makko ɓen yo ɓe bako ka laana, ɓe hikkoo yeeso makko, ɓe lumba gaɗa, telen Bayti-Sa'iida, e nder ko o yiltata jamaa on kon. ");
INSERT INTO fuf_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ɓay o waynondirii e maɓɓe, o ƴawi ka fello fii toragol Alla. ");
INSERT INTO fuf_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ɓay niɓɓii, tawi laana kan no ka tumbo weendu, kanko Iisaa tun himo ka leydi. ");
INSERT INTO fuf_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","O andi hiɓe e nder satteende fota e nder awƴingol laakun kun, ko fii hari hiɓe tiindondiri e hendu ndun. Wa fewndo ka subaka, o sutori e maɓɓe, himo seppa ka hoore ndiyan, tawi himo faalaa ɓe feƴƴitaade. ");
INSERT INTO fuf_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ɓay taalibaaɓe ɓen yi'ii himo seppa ka hoore ndiyan, ɓe sikki ko mbeelu, ɓe sonki, ");
INSERT INTO fuf_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ko fii hari ɓe fow ɓe yi'ii mo, ɓe hulii. Iisaa wi'i ɓe kisan: «Hoolee, ko min nii! Wota on hulu!» ");
INSERT INTO fuf_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Onsay o ƴawi ka laana takko maɓɓe, hendu ndun deƴƴiti. Ɓe fow ɓe ŋalɗi fota, ");
INSERT INTO fuf_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ko fii hari ɓe faamaali kaawake moƴƴo waɗuɗo on ka bireediije, ɓay hari ɓerɗe maɓɓe ɗen no uddi. ");
INSERT INTO fuf_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ɓay ɓe gaynii lumbude weendu ndun, ɓe hewtii Jaani-Saarata, ɓe saani laana kan. ");
INSERT INTO fuf_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ɓay ɓe tippike ka laana, yimɓe ɓen anditi kisan Iisaa. ");
INSERT INTO fuf_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ɓe dogi e diiwal ngal fow, ɓe woni e addangol mo nawnuɓe e hoore ɓoggi-dimborɗi, kala ka andanoo himo ɗon. ");
INSERT INTO fuf_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Kala ka o naatunoo, woni ka koɗooli, woni ka ca'e maa ka fulawaaji, ɓe addayno nawnuɓe ɓen ka fottirɗe, ɓe jeeja mo yo o newnan ɓe tun ɓe meema kombol dolokke makko on. Meemunooɓe ngol ɓen fow ndikki. ");
INSERT INTO fuf_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Onsay *Fariisiyaaɓe ɓen e woɓɓe e jannooɓe fii Sariya on, iwrunooɓe Yerusalaam, mooɓii takko Iisaa. ");
INSERT INTO fuf_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ɓe yi'i woɓɓe e taalibaaɓe makko ɓen no ɲaamira juuɗe tuunuɗe, e maanaa ɗe sooɗaaka. ");
INSERT INTO fuf_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Tawi-le Fariisiyaaɓe ɓen e *Yahuudiyankeeɓe ɓen fow ɲaamataano si sooɗaaki haa laaɓi, ko fii hiɓe jogitinoo naamuuji mawɓe maɓɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Si ɓe iwtiino ka fottirde, ɓe ɲaamiino woo nde ɓe laɓɓinii. Hiɓe joginoo kadi naamuuji buy ɗi ɓe waɗaynoo, wano lawƴugol jardukoy koy e payanɗe ɗen e miranji ɗin.) ");
INSERT INTO fuf_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Onsay Fariisiyaaɓe ɓen e jannooɓe fii Sariya on landii mo kanko Iisaa, ɓe wi'i: «Ko honɗun haɗi taalibaaɓe maa ɓen jokka naamuuji mawɓe ɓen? E ko fii honɗun ɓe ɲaamata, hara ɓe sooɗaaki?» ");
INSERT INTO fuf_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Iisaa jaabii ɓe wi'i: «Isaaya* no haalunoo ko Alla longini mo fii mon moƴƴa, yo faasiqiiɓe, wano windori non: ‹Oo jamaa ko ka toni mun woni lan mawninde, kono ɓerɗe maɓɓe ɗen no woɗɗondiri e an fota. ");
INSERT INTO fuf_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ko e nder meere ɓe woni lan rewude, janndeeji ɗi ɓe woni jannude ɗin ko ɗi yimɓe ɓen sinci.› ");
INSERT INTO fuf_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","«Hiɗon tertaade yamirooje Alla ɗen, jogitoo naamuuji yimɓe ɓen.» ");
INSERT INTO fuf_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","O ɓeyditi, o wi'i: «Hiɗon bugitoo few yamirooje Alla ɗen fii huutorgol naamuuji mon ɗin, ");
INSERT INTO fuf_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","ko fii Muusaa no wi'i: ‹Teddin yumma maa e ben maa›, awa kadi: ‹on mo huɗi ben mun maa yumma mun donkinirte mayde.› ");
INSERT INTO fuf_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Kono onon hiɗon wi'a goɗɗo no waawi wi'ude ben mun maa yumma mun: ‹Mi yeɗii Alla ko mi nafiraynoo on kon.› ");
INSERT INTO fuf_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","E nder wi'ugol mon ɗun, on accataa ontigi waɗana ben mun maa yumma mun hay huunde han kadi. ");
INSERT INTO fuf_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ko nii wonɗon mehinɗinirde daaluyee Alla on tippude e naamu mon mo sincanaɗon on. Hiɗon waɗa kadi piiji ɗuuɗuɗi goo nanduɗi e mun!» ");
INSERT INTO fuf_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Iisaa nodditi kadi jamaa on, o wi'i ɓe: «Heɗee lan on fow, faamon. ");
INSERT INTO fuf_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Hay huunde alaa e kene naataynde e neɗɗo, tuunina mo, kono ko ko yaltata e neɗɗo kon tuuninta mo. ");
INSERT INTO fuf_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Mo no mari noppi nanirɗi yo nanu!» ");
INSERT INTO fuf_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ɓay wonii o naatoyii e suudu ka woɗɗitii jamaa on, taalibaaɓe makko ɓen landii mo fii ngal misal. ");
INSERT INTO fuf_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","O wi'i ɓe: «E jaka, onon kadi ko on ɓe alaa faamu? E on andaa hay huunde alaa e kene naataynde e neɗɗo, waawaynde tuuninde mo? ");
INSERT INTO fuf_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ko fii ɗun naatataa ka ɓernde makko, kono ko ka reedu makko yaarata, ɗun yaltinoyee ka ɓaawo.» (Tawi ko o wi'i ɗon ko wonde ɲaameteeji ɗin fow no laaɓi.) ");
INSERT INTO fuf_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","O wi'i kadi: «Ko ko yaltata e neɗɗo kon woni ko tuuninta mo, ");
INSERT INTO fuf_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","ko fii, ko e nder ɓernde neɗɗo miijooji bonɗi yaltata, kaɲun e cagayaagal e nguyka e waru-hoore e ");
INSERT INTO fuf_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","jeeno e miile e hunƴeendi e janfa e jiiɓaare e nawliigu e hoyre e mawnintinaare e njofoyaagal. ");
INSERT INTO fuf_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ɗii piiji bonɗi fow ko yaltayɗi e nder neɗɗo, tuunina mo.» ");
INSERT INTO fuf_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ɓay kanko Iisaa o iwii e nden nokkuure, o yahi e ndii leydi ndee saare Tiiri. O naati ɗon e suudu, tawi o yiɗaa hay gooto anda. Kono o waawaali suuɗaade, ");
INSERT INTO fuf_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","ko fii hari debbo mo tawata jinna no nangi ɓiɗɗo mun jiwo, naniino fii makko kanko Iisaa no wowlee, o ari, o yani e ley koyɗe makko. ");
INSERT INTO fuf_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Tawi on debbo ko *Gereekiyankeejo, mo iwdi mun woni Fenisii, ɗun ko e nder Sirii. O torii mo raɗanagol mo jinnawii wongii e jiwo makko on ngin. ");
INSERT INTO fuf_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Iisaa wi'i mo: «Accu taho fayɓe ɓen haara, ko fii moƴƴaa ka bireediije paykoy koy ƴettee, buganee bareeji ɗin.» ");
INSERT INTO fuf_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Debbo on jaabii mo: «Hiiyii, Koohoojo, kono hay bareeji wonɗi ka ley taabal ɗin ɲaamay ko paykoy koy samminta kon.» ");
INSERT INTO fuf_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Onsay kanko Iisaa o wi'i mo: «Sabu ngol kongol, yahu, jinnawii ngin yaltii e jiwo maa on.» ");
INSERT INTO fuf_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ɓay wonii kanko debbo on o naatoyii ka suudu makko, o tawi ɓiɗɗo makko jiwo on no waalii ka danki, awa kadi jinnawii ngin yaltii e makko. ");
INSERT INTO fuf_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Onsay Iisaa iwi e ndin leydi Tiiri, o taƴiti leydi Siduuna ndin, o artiri *Dekapooli telen ka *Weendu Jaliilu. ");
INSERT INTO fuf_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ɓe addani mo pahiɗuɗo-mbobiɗi, ɓe jeeji mo *fawugol juuɗe ɗen e hoore on, sellina mo. ");
INSERT INTO fuf_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","O naɓi mo sera, ka woɗɗitii jamaa on, o ukki kolli makko ɗin ka nder noppi nawnuɗo on, o tutti, o meemini ɗenngal on ngal. ");
INSERT INTO fuf_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Onsay o ɓanti gite makko ɗen, o fewtini ka kammu, o taƴiti foofaango, o wi'i: «Efataa!» (Ɗun no firi: «Uddito!») ");
INSERT INTO fuf_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Tun kisan noppi makko ɗin udditii, ɗenngal makko ngal kadi ɓowri, o woni e wowlugol no feewiri. ");
INSERT INTO fuf_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Iisaa yamiri ɓe wota ɓe wowlan ɗun hay gooto, kono, ko no o haɗirnoo ɓe woo, ɓe ɓurtiraynoo lollinirde. ");
INSERT INTO fuf_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ɓe woni e nder ŋalaw tiiɗuɗo, ɓe wi'i: «Ko o waɗata kon fow ko ko moƴƴi. O naninay hay pahiɗuɓe ɓen, o wowlina kadi mbobiɗuɓe ɓen!» ");
INSERT INTO fuf_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","E ɗen balɗe ɗon, nde tawnoo jamaa moolanaaɗo kadi no ɗon, awa kadi alaa ko ɓe ɲaama, Iisaa noddi taalibaaɓe mun ɓen, o wi'i: ");
INSERT INTO fuf_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«Oo jamaa no yurmammi, wonii nii balɗe tati hiɓe wondi e an, ɓe alaa ko ɓe ɲaama. ");
INSERT INTO fuf_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Si mi yiltii ɓe ka maɓɓe hiɓe weelaa, ɓe lo'ay ka laawol, ko fii woɓɓe e maɓɓe ko ka woɗɗi iwi.» ");
INSERT INTO fuf_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Kono taalibaaɓe makko ɓen jaabii mo, wi'i: «Ko honto men heɓata bireedi e ndee nokkuure wulɗinnde ko haarata ɓee?» ");
INSERT INTO fuf_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Iisaa landii ɓe, wi'i: «Ko bireediije jelu marɗon?» Ɓe jaabii mo, ɓe wi'i: «Ko ɗe jeeɗiɗi.» ");
INSERT INTO fuf_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Onsay o torii jamaa on jooɗagol ka leydi, o ƴetti bireediije ɗen jeeɗiɗi. Ɓay o jarnii Alla, o taƴiti, o jonni taalibaaɓe makko ɓen fii yo ɓe hewtin jamaa on, kamɓe kadi ɓe hewtini. ");
INSERT INTO fuf_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Tawi hiɓe marnoo kadi liƴƴi seeɗa. Ɗun kadi, ɓay Iisaa gaynii du'aade, o wi'i yo ɓe hewtin ɓe. ");
INSERT INTO fuf_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ɓe ɲaami haa ɓe haari, mooɓitaa debeeje jeeɗiɗi tew ko lutti. ");
INSERT INTO fuf_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Tawi ɓen ko wa ɓe worɓe guluuje nayo. Ɓawto ɗun Iisaa yilti ɓe. ");
INSERT INTO fuf_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ontuma o bakodi e taalibaaɓe makko ɓen e laana ndiyan, o yahi e ndii leydi Dalmanuuta. ");
INSERT INTO fuf_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Onsay *Fariisiyaaɓe ɓen ari, fuɗɗii yeddondirde e Iisaa. Ɓe landii mo fii ndarndagol mo, yo o hollu ɓe maande iwrunde ka kammu. ");
INSERT INTO fuf_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Iisaa taƴiti foofaango tiiɗungo, o wi'i: «Ko fii honɗun nguu jamaanu landorta maande? Ka haqiiqa mi andinii on, nguu jamaanu jonnetaake maande.» ");
INSERT INTO fuf_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Onsay o acci ɓe ɗon, o bakii kadi e laana fii lumbugol gaɗa. ");
INSERT INTO fuf_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Laatii taalibaaɓe ɓen yejjiti ƴettorde bireedi, tawi ko bireediwal gootal pet ɓe mari ka nder laana. ");
INSERT INTO fuf_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Iisaa yamiri ɓe ɗunɗoo, o wi'i: «Reenee fota e lewen Fariisiyaaɓe ɓen e lewen *Heroodu on.» ");
INSERT INTO fuf_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Taalibaaɓe ɓen wi'indiri: «Ko o wi'iri ɗun, ko fii en maraa bireedi.» ");
INSERT INTO fuf_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Iisaa andi ko ɓe wi'i kon, o wi'i ɓe: «Ko fii honɗun wi'anɗon ko ɓay on maraa bireedi? E on andaali, e on faamaali kadi? E hara ɓerɗe mon ɗen sattii? ");
INSERT INTO fuf_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Hiɗon jogii gite, e hara on yi'ataa? Hiɗon mari noppi, e hara on nanataa? ");
INSERT INTO fuf_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Fewndo mi taƴiti bireediije ɗen jowi fii yimɓe ɓen guluuje njowo, e on anditaali ko debeeje jelu heewuɗe tew kunte bireedi artirnoɗon?» Ɓe jaabii mo: «Ko ɗe sappoo e ɗiɗi.» ");
INSERT INTO fuf_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","«Ɓay kadi mi taƴitii bireediije ɗen jeeɗiɗi fii yimɓe ɓen guluuje nayo, ko debeeje jelu tew kunte bireedi artirnoɗon?» Ɓe jaabii: «Ko ɗe jeeɗiɗi.» ");
INSERT INTO fuf_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","O wi'i ɓe kadi: «Hara on faamaali haa jooni?» ");
INSERT INTO fuf_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ɓawto ɗun ɓe yahi Bayti-Sa'iida. Ɓe addani mo bunɗo, ɓe jeeji mo yo o meemu mo fii yo o sellin mo. ");
INSERT INTO fuf_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Onsay o jogii jungo bunɗo on, o naɓi mo ka ɓaawo hoɗo. O waɗi tuuta ka gite on, o *fawi juuɗe makko ɗen e hoore makko, o landii mo, o wi'i: «Hiɗa yi'ude goɗɗun?» ");
INSERT INTO fuf_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","O ɓanti gite ɗen, o wi'i: «Miɗo haccaade yimɓe, kono miɗo yiirude ɓe wa leɗɗe wonɗe yahude.» ");
INSERT INTO fuf_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Iisaa waɗiti kadi juuɗe ɗen ka gite makko. Bunɗo on ndaari tenƴini, o ndikki, o yi'i fow ko laaɓi. ");
INSERT INTO fuf_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Onsay Iisaa immintini mo yo o hootu ka makko e hoore himo wi'a: «Wota a naatu ka hoɗo.» ");
INSERT INTO fuf_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Nde Iisaa naatunoo e koɗooli Seezariiya-Filiipu ɗin, o landii taalibaaɓe makko ɓen ngal landal ɗoo, o wi'i: «E wi'i yimɓe ɓen, ko hombo woni lan min?» ");
INSERT INTO fuf_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ɓe jaabii mo: «Woɓɓe no wi'a ko onon woni Yaayaa lootaynooɗo on, woɓɓe kadi no wi'a ko onon woni Iiliiya, woɓɓe goo kadi no wi'a ko on goɗɗo goo e annabaaɓe ɓen.» ");
INSERT INTO fuf_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","O landii ɓe kadi, o wi'i: «Onon non wi'uɗon ko hombo woni lan min?» Petruusu jaabii mo, wi'i: «Ko onon woni *Almasiihu on!» ");
INSERT INTO fuf_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Iisaa yamiri ɓe, tentini, wota ɓe wowlan hay gooto ko hombo woni mo. ");
INSERT INTO fuf_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Onsay o fuɗɗii ɓe jannude wonde bee *Ɓii-Aaden on tampa fota, awa kadi mawɓe ɓen e hooreeɓe *yottinooɓe sadaka ɓen haa naɓani jannooɓe fii Sariya on wikkoyto mo, o waree, o immintinoyee ka ɲalaande tammere. ");
INSERT INTO fuf_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Tawi ko no laaɓiri o yewtata ɗii piiji. Petruusu pottini mo sera, o woni mo e felugol. ");
INSERT INTO fuf_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Kono Iisaa yeƴƴitii, o ndaari taalibaaɓe makko ɓen, o feli Petruusu, o wi'i mo: «Yilto ɓaawo an, yo Ibuliisa, ko fii miijooji maa ɗin hinaa ɗi Alla, kono ko ɗi yimɓe ɓen!» ");
INSERT INTO fuf_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Onsay o noddi jamaa on e taalibaaɓe makko ɓen, o wi'i ɓe: «Kala faalaaɗo jokkude lan, yo o hayfintino, o ƴetta *leggal makko altindiraangal ngal, o jokkammi. ");
INSERT INTO fuf_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kala faalaaɗo dandude ngurndan mun, ɗan hayriray mo, kono kala non mo ngurndan mun hayriraa sabu an min e Kibaaru Moƴƴo on, haray ontigi dandoyay ɗan. ");
INSERT INTO fuf_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","E ko nafa honɗun woodani neɗɗo heɓugol aduna on fow, hayra wonkii mun kin? ");
INSERT INTO fuf_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Maa ko honɗun neɗɗo ittata fii sottugol wonkii mun kin? ");
INSERT INTO fuf_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Awa kadi, kala hersirɗo lan, hersiri konguɗi an ɗin e hakkunde oo jamaa jinoowo waɗa junuubi, Ɓii-Aaden on kadi hersiroyay mo tuma o ardoyi e mangural Ben makko ngal wondude e malaa'ikaaɓe laaɓuɓe ɓen.» ");
INSERT INTO fuf_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","O wi'i ɓe kadi: «Ka haqiiqa mi andinii on, no woodi woɓɓe e mon onon wonɓe ɗoo ɓen, ɓe maayataa ado ɓe yi'ude *laamu Alla ngun no ardi e doole.» ");
INSERT INTO fuf_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Balɗe jeegoo ɓawto ɗun, Iisaa ƴetti Petruusu e Yaaquuba e Yuuhanna, o naɓi ɓe kamɓe tun e hoore fello toowungo. Mbaadi makko ndin waylii yeeso maɓɓe, ");
INSERT INTO fuf_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","conci makko ɗin jalbi. Hakkee ko ɗi rawni alaa wuppoowo e hoore ndii leydi laɓɓiniroowo non. ");
INSERT INTO fuf_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Iiliiya e Muusaa feeɲani ɓe, ɓe woni e yewtidugol e makko kanko Iisaa. ");
INSERT INTO fuf_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Onsay Petruusu ƴetti haala kan, o wi'i Iisaa: «Karamoko'en, no moƴƴi ka wonen ɗoo. Darnen togooji tati, onon wonndu, Muusaa wonndu, Iiliiya kadi wonndu.» ");
INSERT INTO fuf_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","(Tawi kanko Petruusu o andaa ko o woni wowlude, ko fii hari kamɓe tato kulol heewii e maɓɓe.) ");
INSERT INTO fuf_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Tun duulere ari buumi ɓe. Onsay hawa yalti ka duulere, wi'i: «Oo ɗoo ko Ɓiɗɗo an yiɗaaɗo. Heɗitee mo!» ");
INSERT INTO fuf_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Tun taalibaaɓe ɓen ndaari binde ɗon, ɓe yi'itaali hay gooto, si hinaa kamɓe tun e Iisaa. ");
INSERT INTO fuf_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","E nder ko ɓe tippotoo kon ka fello, Iisaa yamiri ɓe wota ɓe wowlan hay gooto ko ɓe yi'i kon, haa nde *Ɓii-Aaden on immintinaa e hakkunde mayɓe ɓen woo. ");
INSERT INTO fuf_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ɓe maanditii ngol kongol e nder yeddondirgol hakkunde maɓɓe, hiɓe wi'a: «Ko honɗun woni immitagol e hakkunde mayɓe ɓen?» ");
INSERT INTO fuf_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Onsay taalibaaɓe ɓen landii mo, ɓe wi'i: «Ko fii honɗun jannooɓe fii Sariya on ɓen wi'anta wonde ko Iiliiya haani arude taho?» ");
INSERT INTO fuf_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","O jaabii ɓe, o wi'i: «Ko goonga Iiliiya aray taho, wattitoo fow. Ko honɗun windii fii Ɓii-Aaden on? Hinaa o tampay fota, o wikkee? ");
INSERT INTO fuf_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Kono mi andinii on Iiliiya ariino, kono ɓe waɗiri mo no ɓe faaliraa non, wano windori fii makko non.» ");
INSERT INTO fuf_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ɓay ɓe hewtitii takko taalibaaɓe ɓen, ɓe yi'i jamaa ɗuuɗuɗo e jannooɓe fii Sariya on takko maɓɓe no yeddondira e maɓɓe. ");
INSERT INTO fuf_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","No jamaa on yiirunoo Iisaa, ɓe ŋalɗi fota, ɓe dogi fii hiwroyagol mo. ");
INSERT INTO fuf_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Kanko Iisaa o landii ɓe, o wi'i: «Ko e hoore honɗun wonɗon yeddondirde e maɓɓe?» ");
INSERT INTO fuf_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Onsay gorko goo e nder jamaa on jaabii mo wi'i: «Karamoko'en, mi addanii on oo ɓiɗɗo an gorko, mo jinnawii mbobinɗinayngii nangi. ");
INSERT INTO fuf_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Tuma ngii nangi mo woo, ngii liɓay mo ka leydi, o yaltina ngurda, o ŋatindira ɲiiƴe ɗen, o yoora ken. Mi torike taalibaaɓe mon ɓen raɗagol ngii jinnawii, kono ɓe waawaali.» ");
INSERT INTO fuf_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Iisaa jaabii ɓe, wi'i: «Onon ko on jamaanu ngu gomɗinaa. Ko haa honde tuma mi wondata e mon? E ko haa honde tuma mi muɲɲantoo on? Addanee lan mo ɗoo.» ");
INSERT INTO fuf_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Onsay ɓe addani mo mo. No paykun kun yiirunoo Iisaa, jinnawii ngin iirini kun, kun yani ka leydi, kun woni e tallagol, yaltina ngurda. ");
INSERT INTO fuf_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Onsay Iisaa landii ben paykun kun: «Ko gila honde tuma ɗun hewtitii kun?» Ben makkun jaabii: «Ko gila e booboyaagal makko. ");
INSERT INTO fuf_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Awa kadi soono woo jinnawii ngin bugoto kun ka yiite e ka ndiyan fii mulugol kun. Kono si tawii hiɗon waawi goɗɗun, yurmee men, wallon men!» ");
INSERT INTO fuf_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Iisaa kadi wi'i mo: «Wi'uɗaa si miɗo waawi! Fow no newanii gomɗinɗo!» ");
INSERT INTO fuf_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Tun ben paykun kun ewnii, wi'i: «Miɗo gomɗini! Kono wallitee lan ko fii gomɗinal an ngal no ŋakkanimmi!» ");
INSERT INTO fuf_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ɓay Iisaa yi'ii jamaa on no doga, ara e maɓɓe, onsay o toŋani jinnawii ngin, o wi'i: «Ko an, yo jinnawii mbobinɗinayngii, mi wi'ii ma yo a yaltu e makko, wota a naatitu e makko hande kadi!» ");
INSERT INTO fuf_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Onsay ngii haaci, e hoore iiringol kun ko tiiɗi, ngii yalti e makkun. Paykun kun wa'i wa maykun, haa ɗuuɗuɓe wi'i: «Kun maayii!» ");
INSERT INTO fuf_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Kono Iisaa jogii kun, immini, kun darii. ");
INSERT INTO fuf_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ɓay wonii Iisaa naatii ka suudu, taalibaaɓe makko ɓen landii mo e gundoo, ɓe wi'i: «Ko fii honɗun menen men waawaali raɗaade ngii jinnawii?» ");
INSERT INTO fuf_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","O wi'i ɓe: «Sifa ngii jinnawii, ko toragol Alla tun waawata ngii yaltinde.» ");
INSERT INTO fuf_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Onsay ɓe iwi ɗon, ɓe taƴitoyi Jaliilu. Tawi Iisaa faalaaka andee ko honto o woni, ");
INSERT INTO fuf_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ko fii hari himo jannude taalibaaɓe makko ɓen, o wi'a ɓe: «Ɓii-Aaden on wattete e juuɗe yimɓe ɓen, ɓe wara mo. Balɗe tati ɓawto maygol makko, o immitoo.» ");
INSERT INTO fuf_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Kono hari taalibaaɓe ɓen alaa faamude ɗin konguɗi, awa kadi ɓe huli landitagol mo ɗi. ");
INSERT INTO fuf_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Onsay ɓe hewti Kafernahuum. Ɓay ɓe naatii ka suudu, Iisaa landii ɓe, wi'i: «Ko e hoore honɗun wonnoɗon yeddondirde ka laawol?» ");
INSERT INTO fuf_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Kono ɓe deƴƴi, ko fii hari ka laawol ɓe yewtidii fii andugol ko hombo ɓuri teddude. ");
INSERT INTO fuf_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Onsay kanko Iisaa o jooɗii, o noddi sappoo e ɗiɗooɓe ɓen, o wi'i ɓe: «Mo no faalaa wonude arano, o wonay sakkitoro e ɗi fow, kurkaadu fow.» ");
INSERT INTO fuf_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Onsay o ƴetti paykun, o joɗɗini kun hakkunde maɓɓe. Ɓay o hirbike kun, o wi'i ɓe: ");
INSERT INTO fuf_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«Kala jaɓuɗo paykun tosokun e innde an, haray ko min tigi o jaɓi. Awa-le kala jaɓuɗo lan, haray hinaa min tigi o jaɓi, kono ko Nuluɗo lan on.» ");
INSERT INTO fuf_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Onsay Yuuhanna wi'i mo: «Karamoko'en, men yi'ii goɗɗo no raɗoo jinnaaji e innde mo'on. Men toŋani mo ɗun ɓay o wondaa e amen fii jokkugol on.» ");
INSERT INTO fuf_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Kono Iisaa wi'i: «Wota on toŋan mo ɗun. Ko fii hay gooto waawataa waɗude kaawake moƴƴo e innde an, yiltoo kisan ɓawto ɗun, wowlammi ko boni. ");
INSERT INTO fuf_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ko fii kala mo wonaa gaɲo men, haray ko giɗo men. ");
INSERT INTO fuf_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Awa kadi, kala okkorɗo on ndiyan yareteeɗan e innde an min, fii ko on ɓe *Almasiihu on, ka haqiiqa mi andinii on o faɗataa mbarjaari makko ndin few. ");
INSERT INTO fuf_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","«Kono on mo woni sabu feggingol gokkun e koy paykoy gomɗinkoy lan, haray ko ɓuri mo moƴƴande ko kolmbireede tuntere hayre, o bugee ka baharu. ");
INSERT INTO fuf_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Si tawii jungo maa ngon wonay sabu haa feggoɗaa, haray taƴu ngo. Ko fii no ɓuru-maa moƴƴande ka naataa ka ngurndan, hara ko a taƴa-jungoojo, edii a jogaade juuɗe ɗiɗi yahaa ka jahannama, ka yiite nge ɗaanotaako. ");
INSERT INTO fuf_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Si tawii-le koyngal maa ngal wonay sabu haa feggoɗaa, haray taƴu ngal. Ko fii no ɓuru-maa moƴƴande ka naataa ka ngurndan, hara ko a taƴa-koyngaljo, edii a jogaade koyɗe ɗiɗi, bugeɗaa ka jahannama. ");
INSERT INTO fuf_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Si tawii-le yiitere maa nden wonay sabu haa feggoɗaa, haray awu nde. Ko fii no ɓuru-maa moƴƴande ka naataa ka *laamateeri Alla hara ko mo a yiitere wootere, edii a jogaade gite ɗiɗi, bugeɗaa ka jahannama ");
INSERT INTO fuf_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ka gilɗi maɓɓe ɗin maayataa ɗon e ka yiite ngen ɗaanotaako ɗon. ");
INSERT INTO fuf_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","«Ko fii kala neɗɗo lensinirte yiite. ");
INSERT INTO fuf_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Lanɗan ko huunde moƴƴere, kono si dakamme majjan on iwii, haray ko honno dakamme majjan on wattirtee? Waɗee lanɗan e mon onon tigi, wondon e hoore ɓuttu.» ");
INSERT INTO fuf_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Onsay Iisaa iwi ɗon, o ari ka seraaji diiwal Yahuuda gaɗa Yurdayniwol, jamaa on mooɓii kadi takko makko. Wano o woowiri non, o woni e jannugol ɓe kadi. ");
INSERT INTO fuf_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Onsay *Fariisiyaaɓe goo ɓadii mo fii ndarndagol mo, ɓe wi'i: «E hara no daganii goɗɗo accitugol ɓeyngu mun?» ");
INSERT INTO fuf_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","O jaabii ɓe, o wi'i: «Ko honɗun Muusaa yamiri on?» ");
INSERT INTO fuf_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Fariisiyaaɓe ɓen wi'i: «Muusaa no newnani ontigi waɗangol ɓeyngu mun kaydi sertigal, accita mo.» ");
INSERT INTO fuf_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Iisaa kadi wi'i ɓe: «Ko sabu cattal mon ɓernde ngal waɗi si Muusaa windani on nden yamiroore. ");
INSERT INTO fuf_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Kono ka fuɗɗoode, Alla tagii ɓe, o waɗi ɓe gorko e debbo. ");
INSERT INTO fuf_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‹Ko ɗun waɗi si gorko selay ben mun e yumma mun, humoo e ɓeyngu mun, ");
INSERT INTO fuf_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","onsay kamɓe ɗiɗo ɓe wona gooto.› Ɗun haray hinaa ɓe ɗiɗo hande kadi, kono ko gooto. ");
INSERT INTO fuf_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Awa wota goɗɗo sendindir ko Alla hawtindiri kon.» ");
INSERT INTO fuf_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ɓay wonii ɓe naatoyii ka suudu, taalibaaɓe ɓen landii mo kadi fii ɗun. ");
INSERT INTO fuf_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","O jaabii ɓe, o wi'i: «Kala accituɗo ɓeyngu mun, ƴetti goɗɗo goo, haray ontigi jeenii e telen-ma makko. ");
INSERT INTO fuf_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Si debbo kadi seedii e moodi mun, ƴettoyaama ka goɗɗo, haray on debbo kadi jeenii.» ");
INSERT INTO fuf_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Onsay yimɓe ɓen addani mo paykoy fii yo o meemu koy, kono taalibaaɓe ɓen toŋani ɓen. ");
INSERT INTO fuf_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ɓay wonii Iisaa yi'ii ɗun, o tikki, o wi'i: «Accee paykoy koy ara e an, wota on haɗu koy, ko fii *laamu Alla ngun ko sifa makkoy wonani. ");
INSERT INTO fuf_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ka haqiiqa mi andinii on, kala mo jaɓiraali laamu Alla ngun wa paykun, haray o naatataa ton few.» ");
INSERT INTO fuf_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ɓawto ɗun o hirbii paykoy koy, o *fawi juuɗe makko ɗen e makkoy, o du'anii koy. ");
INSERT INTO fuf_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ɓay wonii Iisaa fokkitii, onsay goɗɗo dogi, ari, jiccii yeeso makko. O landii mo, o wi'i: «Karamokoojo moƴƴo, hara ko honɗun mi haani waɗude fii yo mi heɓoy *ngurndan poomayankejan ɗan?» ");
INSERT INTO fuf_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Onsay Iisaa jaabii mo, wi'i: «Ko fii honɗun wi'irtaa mi moƴƴo? Hay gooto moƴƴaa si hinaa Alla Bajjo on. ");
INSERT INTO fuf_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Hiɗa andi yamirooje ɗen: ɗun ko wota a ittu hoore, wota a jeenu, wota a wujju, wota a seedito fenaande, wota a janfo hay gooto, teddinaa kadi yumma maa e ben maa.» ");
INSERT INTO fuf_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","O jaabii, o wi'i: «Karamoko'en, miɗo waɗude ɗun fow gila e cukankaaku an.» ");
INSERT INTO fuf_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ɓay Iisaa ndaaririi mo giggol, o wi'i mo: «No ŋakkan-maa fahin huunde wootere: yahu yeeyitaa kala ko jeyɗaa, okkaa miskinɓe ɓen, ɗun wonanoyte keyee ka kammuuli, onsay araa jokkaa mi.» ");
INSERT INTO fuf_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ɓay on nanii ɗin konguɗi, o ɲirɓinii, o yahi himo aani, ko fii hari himo alɗi fota. ");
INSERT INTO fuf_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Onsay kanko Iisaa o wi'i taalibaaɓe makko ɓen: «Emba no sattani jom jawle en ka ɓe naata ka laamu Alla.» ");
INSERT INTO fuf_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Taalibaaɓe ɓen ŋalɗi fii ɗin yewtereeji. Kanko Iisaa o fillitii kadi, o wi'i ɓe: «Fayɓe an, emba naatugol ka laamu Alla no satti. ");
INSERT INTO fuf_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","No ɓuri weeɓande ngelooba ka mba rewa e wuddere meselal edii ka jom jawle en naata ka laamu Alla.» ");
INSERT INTO fuf_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Taalibaaɓe ɓen ɓurti ŋalɗude kadi, ɓe woni e wi'indirgol: «E hara ko hombo dandoytee?» ");
INSERT INTO fuf_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Iisaa ndaari ɓe, wi'i: «Ɗun waawantaako neɗɗanke, kono Alla kan wonaa non, kala huunde no waawanoo mo.» ");
INSERT INTO fuf_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Onsay Petruusu wi'i mo: «Awa e hino, men accii ko men jeyi kon fow, men jokkii on.» ");
INSERT INTO fuf_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Iisaa jaabii, o wi'i: «Ka haqiiqa mi andinii on, kala accuɗo suudu mun ndun e musiɓɓe mun ɓen e bandiraaɓe mun ɓen e yumma mun e ben mun e ɓiɓɓe mun ɓen e gese mun ɗen sabu innde an nden e Kibaaru Moƴƴo on, ");
INSERT INTO fuf_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","o heɓoyay ko ɓuri ɗun laabi teemedere: cuuɗi e musiɓɓe e bandiraaɓe e neeniraaɓe e ɓiɓɓe e gese e cukkeede ka aduna ɗoo. Ka aduna aroyoowo o heɓoyay ngurndan poomayankejan. ");
INSERT INTO fuf_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Kono wonɓe yeeso buy wontiroyay ɓaawo, ɓaawooɓe ɓen wontiroya yeeso.» ");
INSERT INTO fuf_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Nde tawnoo hiɓe ka laawol fii yahugol Yerusalaam, Iisaa wonti yeeso maɓɓe, taalibaaɓe ɓen ŋalɗi, jokkunooɓe ɓen kadi huli. Iisaa pottini sappoo e ɗiɗooɓe ɓen sera, o woni ɓe e yewtugol ko heɓoyta mo kon. ");
INSERT INTO fuf_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","O wi'i ɓe: «Awa hiɗen yahude Yerusalaam. Ɓii-Aaden* on wattete e juuɗe hooreeɓe yottinooɓe sadaka ɓen e jannooɓe fii Sariya on ɓen, ɓe happana mo wareede, ɓe watta mo e juuɗe ɓe wonaa Yahuudiyanke ɓen, ");
INSERT INTO fuf_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ɓen jala mo, ɓe tutta e hoore makko, ɓe focca mo, onsay ɓe wara mo. Balɗe tati ɓawto ɗun o immitoo.» ");
INSERT INTO fuf_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Onsay Yaaquuba e Yuuhanna, ɗun ko ɓiɓɓe Zabadii ɓen, ɓadii Iisaa, ɓe wi'i mo: «Karamoko'en meɗen faalaa yo on waɗan men ko men torotoo on kon.» ");
INSERT INTO fuf_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","O wi'i ɓe: «Ko honɗun faalaɗon yo mi waɗan on?» ");
INSERT INTO fuf_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ɓe wi'i mo: «Ko yo on newnan men jooɗoyagol ka laamu mon darjinngu, goɗɗo e amen wonira ka ɲaamo mon, oya on ka nano mon.» ");
INSERT INTO fuf_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Kono Iisaa wi'i ɓe: «On andaa ko wonɗon lan toraade. E hara on waaway yarirde jardukun tampere kun mi yarirta kun, maa looteede lootannde tampere nde mi lootoytee nden?» ");
INSERT INTO fuf_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ɓe jaabii: «Men waaway.» Iisaa wi'i ɓe kadi: «Ko goonga on yariray jardukun kun mi yarirta kun, e on lootete lootannde tampere nde mi lootoytee nden. ");
INSERT INTO fuf_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Kono fii jooɗoyagol ka ɲaamo an maa ka nano an, hinaa min yeɗata ɗun: ɗon no yeɗaa ɓe fii mun eɓɓanaa ɓen.» ");
INSERT INTO fuf_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ɓay ɓeya taalibaaɓe sappo nanii ɗun, ɓe fuɗɗii seytinande Yaaquuba e Yuuhanna. ");
INSERT INTO fuf_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Onsay Iisaa noddi ɓe, o wi'i: «Hiɗon andi ɓee ɓe jogitorɗen wa hooreeɓe ɗiya leƴƴi no laamori ɗi doole, awa kadi lamɓe maɓɓe ɓen no feƴƴintini laamu ngun e hoore maɓɓe. ");
INSERT INTO fuf_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Kono onon, wota on wa'u wa ɓen. Kala faalaaɗo wonde tedduɗo e hakkunde mon, yo wonu kurkaadu mon. ");
INSERT INTO fuf_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Awa kadi kala faalaaɗo wonde yeesoojo e hakkunde mon, yo wonu maccuɗo fow, ");
INSERT INTO fuf_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","ko fii Ɓii-Aaden on ardaali fii kurkanegol, kono ko fii kurkanagol, okkitira ngurndan mun ɗan fii cottudi ɗuuɗuɓe.» ");
INSERT INTO fuf_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Onsay ɓe hewti Yeerikoo. Ɓay wonii kanko Iisaa e taalibaaɓe makko ɓen e jamaa ɗuuɗuɗo on ɓe yaltii ɗon, tawi bunɗo torotooɗo no wi'ee Bartimaawu, on ko ɓiɗɗo oo wi'eteeɗo Timaawu, no jooɗii ka sera laawol. ");
INSERT INTO fuf_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","O nani wonde ko Iisaa oo jeyaaɗo Naasirata woni feƴƴude. Onsay o woni e ewnagol, wi'a: «Ko an yo Iisaa, ɓii Daawuuda, yurminan!» ");
INSERT INTO fuf_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ɗuuɗuɓe feli mo fii yo o fanku, kono o ɓurti ewnaade, wi'a: «Ko an yo ɓii Daawuuda, yurminan!» ");
INSERT INTO fuf_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Onsay Iisaa dartii, o wi'i: «Noddee mo!» Ɓe noddi bunɗo on, e hoore hiɓe wi'a mo: «Wakkilo, immoɗaa, himo noddude ma!» ");
INSERT INTO fuf_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Bunɗo on kadi bugii dolokke mun on, immii tinna, o ari e Iisaa. ");
INSERT INTO fuf_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Onsay Iisaa jaabii mo, wi'i: «Ko honɗun faalaɗaa yo mi waɗane?» Kanko bunɗo on o wi'i mo: «Karamoko'en, ko yo mi hettu giiɗe an ɗen.» ");
INSERT INTO fuf_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Iisaa wi'i mo kadi: «Yahu, gomɗinal maa ngal hisinii ma.» Ɗon kisan o wunti, o woni e jokkugol Iisaa e yaadu ndun. ");
INSERT INTO fuf_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ɓay wonii ɓe ɓadike Yerusalaam haa ɓe hewtii Bayti-Faazii e *Betanii, ɗun ko takko Fello *Zaytuuni ngon, kanko Iisaa o nuli taalibaaɓe makko ɗiɗo, ");
INSERT INTO fuf_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","o wi'i ɓe: «Yahee e ngoo hoɗo wongo yeeso mon ɗoo. No naatirɗon e maggo on taway ɗon mbabun kun goɗɗo waɗɗaaki haa hande no humii ɗon. Hunton kun, addon. ");
INSERT INTO fuf_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Si goɗɗo aru on e landaade: ‹Ko honɗun waɗanton ɗun?›, on wi'ay mo: ‹Ko haaju Koohoojo on yani e makkun. O artiray kun ko neeɓaa.› » ");
INSERT INTO fuf_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Onsay ɓe yahi, ɓe tawi mbabun no humii ka yaasi e binde dambugal ka ɗatal, ɓe hunti kun. ");
INSERT INTO fuf_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Woɓɓe e wonnooɓe ɗon ɓen wi'i ɓe: «Ko honɗun waɗi si hiɗon huntude mbabun kun?» ");
INSERT INTO fuf_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ɓe jaabori no Iisaa wiirunoo ɓe non. Onsay ɓe acci ɓe yahi. ");
INSERT INTO fuf_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ɓe addani Iisaa mbabun kun. Ɓe ndaɗɗani mo conci maɓɓe ɗin e hoore makkun. Iisaa jooɗii e hoore makkun. ");
INSERT INTO fuf_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Yimɓe buy ndaɗɗani mo conci mun ɗin ka laawol, woɓɓe calɗi ɗi ɓe saltii ka buruure ɗin. ");
INSERT INTO fuf_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Tawi hikkornooɓe yeeso makko ɓen e iwtirnooɓe ɓaawo ɓen no ewnaade wi'a: «*Hosannaa! Yo barki wonan oo wonɗo arude e innde Joomiraaɗo on! ");
INSERT INTO fuf_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Barki wonanii nguu laamu wongu arude, ɗun ko nguu laamu ben men Daawuuda! Darja ɓurɗo toowude wonanii ma!» ");
INSERT INTO fuf_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ɓay Iisaa naatii Yerusalaam, o yahi ka *juulirde mawnde, o taskii fow. Nde tawnoo niɓɓii, o yahi Betanii kanko e sappoo e ɗiɗooɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Bimbi nden ɲande, ko ɓe yaltata Betanii, kanko Iisaa o weelaa. ");
INSERT INTO fuf_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","O haynii ƴibbehi maruki haako ka woɗɗitii. O yahi ndaarugol si o taway ton goɗɗun. Ɓay o ɓadike o tawi ko haako tun, ko fii hari hinaa dabbunde ƴibbe. ");
INSERT INTO fuf_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Onsay o wi'i ki: «Wota goɗɗo ɲaamitu hande kadi ɓiɓɓe maa ɓen.» Taalibaaɓe makko ɓen nani ko o wi'i kon. ");
INSERT INTO fuf_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ɓay ɓe hewtii Yerusalaam, Iisaa naatiri ka dingiral juulirde mawnde, o woni e raɗagol yeeyaynooɓe ɓen e soodaynooɓe ɓen ka juulirde. O wayliti taabe waɗaynooɓe sensa-sensita ɓen e julle yeeyaynooɓe gabooji ɓen. ");
INSERT INTO fuf_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Tawi o jaɓataa hay gooto naɓora goɗɗun ka nder dingiral juulirde, ");
INSERT INTO fuf_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","e hoore himo jannaynoo ɓe, wi'a: «Hinaa no windii: ‹Suudu an ndun innoyte suudu torordu ndu leƴƴi ɗin fow torotoo Alla e mun?› Kono onon on wattii ndu fammeere wuyɓe!» ");
INSERT INTO fuf_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Kono ɓay hooreeɓe *yottinooɓe sadaka ɓen e jannooɓe fii Sariya on nanii ɗun, ɓe woni e ɗaɓɓugol feere no ɓe sahinbinira mo. Kono tawi hiɓe huli mo, ko fii hari jamaa on fow no ŋalɗidi e ko o jannata kon. ");
INSERT INTO fuf_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ɓay niɓɓii, Iisaa e taalibaaɓe mun ɓen yalti ka saare. ");
INSERT INTO fuf_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Wa ko ɓe feƴƴata bimbi, taalibaaɓe ɓen yi'i kiya ƴibbehi no yoori haa ka ɗaɗi. ");
INSERT INTO fuf_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Onsay Petruusu anditi ko feƴƴi kon. O wi'i Iisaa: «Karamoko'en, ndaaree! Ƴibbehi ki huɗunoɗon kin yoorii!» ");
INSERT INTO fuf_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Iisaa ƴetti haala kan, wi'i ɓe: «Gomɗinee Alla! ");
INSERT INTO fuf_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ko fii, ka haqiiqa mi andinii on, si goɗɗo wi'u ngoo fello yo ngo ɓoro ɗoo, ngo yaha ka baharu, hara o sikkitaaki ka ɓernde makko, hara himo gomɗini ko o wi'i kon waɗay, ɗun waɗante mo. ");
INSERT INTO fuf_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ko ɗun waɗi si mi wi'ay on, kala ko landiɗon e nder toragol Alla, hoolee on hendike ɗun, ɗun waɗante on. ");
INSERT INTO fuf_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Nde hiɗon toroo Alla, hara hiɗon seytinani goɗɗo, yaafee mo, fii no Ben mon Wonɗo ka kammu on yaaforana on onon kadi bonnereeji mon ɗin. ");
INSERT INTO fuf_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Kono si on yaafanaaki ɓe, haray Ben mon Wonɗo ka kammu on kaɲun kadi yaafantaako on bonnereeji mon ɗin.» ");
INSERT INTO fuf_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ɓe yiltitii kadi Yerusalaam. E nder ko Iisaa jindata kon ka nder juulirde mawnde, hooreeɓe yottinooɓe sadaka ɓen e jannooɓe fii Sariya on wondude e mawɓe ɓen ari e makko. ");
INSERT INTO fuf_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ɓe wi'i mo: «Ko e ley kongol hombo wonɗaa waɗude ɗun e ko e ley kongol hombo wonɗaa fii ko wonɗaa waɗude koo?» ");
INSERT INTO fuf_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Iisaa jaabii ɓe, wi'i: «Min kadi mi landoto on huunde wootere. Si on jaabike lan, onsay mi yeetoto on ko e ley kongol hombo mi woni waɗirde ɗun. ");
INSERT INTO fuf_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","E hara lootugol ko Yaayaa lootaynoo yimɓe ɓen kon, ko honto iwri: ko ka arsi, kaa ko e neɗɗanke? Jaabee lan.» ");
INSERT INTO fuf_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Kono ɓe wi'indiri: «Si en jaabike mo ko ka arsi iwri, o wi'ay en ko honɗun haɗunoo gomɗinen mo? ");
INSERT INTO fuf_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Si en jaabike mo-le ko e neɗɗanke ɗun iwri.» (E hin-le hiɓe huli jamaa on, ko fii fow no jogori Yaayaa wa annabaajo tigi.) ");
INSERT INTO fuf_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Onsay ɓe jaabii Iisaa: «Men andaa.» Kanko kadi o wi'i ɓe: «Min kadi mi wowlantaa on ko e ley kongol hombo mi woni waɗirde ɗun.» ");
INSERT INTO fuf_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ɓawto ɗun Iisaa woni kadi yewtirgol ɓe mise, o wi'i ɓe: «Goɗɗo tutuno *wiiɲu, o howi tutateeri ndin, o jasi ngayka fii ka wiiɲu on oƴƴee, o waɗi bente ka reenoowo on wona, o halfini ndi remooɓe wiiɲu ɓen, o yahi safaari. ");
INSERT INTO fuf_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ɓay saa'i soɲitugol wiiɲu on hewtii, o immini kurkaadu makko haa e remooɓe wiiɲu ɓen fii yo ɓen jonnan mo ɓiɓɓe wiiɲu geɓal makko ngal. ");
INSERT INTO fuf_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Kono ɓen hendii mo piyi, ɓe immintini mo juuɗe mehe. ");
INSERT INTO fuf_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","O immini kurkaadu makko goo kadi, ɓe piyi onɗon kadi e hoore, ɓe hersini. ");
INSERT INTO fuf_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","O immini kadi tammo, ɓe wari on. E ɗuuɗuɓe ɓe o imminnoo piyaa, woɓɓe waraa. ");
INSERT INTO fuf_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","«Tawi ko ɓiɗɗo makko yiɗaaɗo on tun o luttirnoo. Ka sakkitorun o immini mo haa e maɓɓe, himo wi'a: ‹Ɓe teddinay ɓiɗɗo an on.› ");
INSERT INTO fuf_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","«Kono kamɓe remooɓe wiiɲu ɓen ɓe haldi: ‹Ɓay ko oo woni ronoowo on, waren mo, ɗun ndondi ndin wontanay en!› ");
INSERT INTO fuf_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Onsay ɓe nangi mo, ɓe wari, ɓe bugii ka ɓaawo tutateeri wiiɲu.» ");
INSERT INTO fuf_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Iisaa wi'i kadi: «Jooni non, hara ko honɗun jom ndin tutateeri wiiɲu waɗata ɓen? On aray, re'a ɓen remooɓe wiiɲu, o jonna tutateeri ndin woɓɓe goo.» ");
INSERT INTO fuf_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Onsay Iisaa wi'i ɓe kadi: «E hara on jangaali ko bindi ɗin wi'i kon? Ko fii hiɗi wi'i wonde: ‹Hayre nde mahooɓe ɓen hawkunoo nden wontii hittunde ka soɓɓundu. ");
INSERT INTO fuf_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ɗun ko e Joomiraaɗo on iwri, ɗun no hawnii e gite men!› » ");
INSERT INTO fuf_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ɓay ɓe faamii wonde ko fii maɓɓe Iisaa waɗani ngal misal, ɓe woni e ɗaɓɓugol feere no ɓe nangira mo, kono hari hiɓe huli jamaa on. Onsay ɓe acci mo ɗon, ɓe yahi. ");
INSERT INTO fuf_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Onsay ɓe immini e Iisaa *Fariisiyaaɓe goo e yimɓe Heroodu goo fii ko nangira mo konguɗi makko ɗin. ");
INSERT INTO fuf_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ɓen ari, wi'i mo: «Karamoko'en meɗen andi ko on nunɗuɓe, awa kadi on ɗenƴotaako hay gooto, ko fii on ɓurdindinaa yimɓe ɓen, hiɗon jannirde laawol Alla ngol goonga. E hara no haani ka men yoɓa lanɗo mawɗo Roomu on sagalle, kaa haanaa? Meɗen haani yoɓude kaa men haanaa yoɓude?» ");
INSERT INTO fuf_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Nde tawnoo Iisaa no andi faasiqiyaagal maɓɓe ngal, o jaabii ɓe, o wi'i: «Ko fii honɗun ndarndorton mi? Addanee lan *dinaruuru, mi ndaara.» ");
INSERT INTO fuf_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ɓe addi wooturu. Iisaa landii ɓe wi'i: «Ko nandolla hombo e bindi hombo woni e mayru?» Ɓe jaabii: «Ko lanɗo mawɗo Roomu on.» ");
INSERT INTO fuf_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Onsay o wi'i ɓe: «Jonnitee lanɗo mawɗo Roomu on ko makko kon, jonniton Alla kadi ko mun kon.» Ɓe ŋalɗi e makko. ");
INSERT INTO fuf_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sadduusiyaaɓe*, wi'uɓe wonde ummutal alaa ɓen, ari landii Iisaa, ɓe wi'i mo: ");
INSERT INTO fuf_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«Karamoko'en, e hino ko Muusaa wi'i men kon: Si goɗɗo maayii accii ɓeyngu e ɓaawo ɓiɗɗo, haray miɲɲiraawo on mayɗo no haani ƴettude on keynguujo mo o acci fii no o heɓirana on kotiraawo makko jurriya. ");
INSERT INTO fuf_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Tawa non ɓen ɓiɓɓe ko ɓe njeeɗiɗo. Arano on jombii, maayii, accaali jurriya. ");
INSERT INTO fuf_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ɗimmo on kadi ƴettii on keynguujo, maayii, accaali jurriya. Tammo on kadi wano non. ");
INSERT INTO fuf_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Tawii hay gooto e ɓen njeeɗiɗo accaali jurriya. Ɓay feƴƴii e maɓɓe ɓe fow, debbo on kadi maayii. ");
INSERT INTO fuf_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ɓay hari ɓen njeeɗiɗoo non resii on debbo, ko hombo e ɓen on debbo wontanoyta ka ummutal?» ");
INSERT INTO fuf_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Iisaa jaabii ɓe, wi'i: «E hino ko waɗi kon si hiɗon e nder palji, ko fii on alaa faamude bindi ɗin, on alaa faamude kadi bawgal Alla ngal. ");
INSERT INTO fuf_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ko fii ka ummutal, worɓe ɓen resataa, rewɓe ɓen kadi resetaake, kono ɓe wa'ay wa malaa'ikaaɓe ɓen ka kammuuli. ");
INSERT INTO fuf_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","E on jangaali ka deftere Muusaa fii mayɓe ɓen kan e ummutal maɓɓe ngal, ko Alla daalani mo kon ka binde pitahun, wonde: ‹Ko min woni Alla Ibraahiima e Alla Issaaqa e Alla Yaaquuba›? ");
INSERT INTO fuf_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Awa Alla wonaa Alla mayɓe ɓen kono ko o Alla wurɓe ɓen. Awa on faljii few!» ");
INSERT INTO fuf_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Goɗɗo e jannooɓe fii Sariya on ɓen, ɓay nanii ko ɓe yewtidi kon, o ndaarii kadi o tawii Iisaa jaaborii no moƴƴiri, o ɓadii, o landii mo: «E nder yamirooje ɗen fow ko honɗun adii?» ");
INSERT INTO fuf_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Iisaa jaabii, wi'i: «E hino ko adii kon: ‹Heɗitee yo *Banii-Isra'iila'en, Alla Joomiraaɗo men on ko Joomiraaɗo gooto, ");
INSERT INTO fuf_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","awa kadi yo a yiɗir Alla Joomiraaɗo maa on ɓernde maa nden fow e wonkii maa kin fow e hakkil maa kin fow e doole maa ɗen fow.› ");
INSERT INTO fuf_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","E hino ko hikki ɗon kon: ‹Yo a yiɗir ɲokondo maa on wano yiɗirɗaa hoore maa non. Yamirooje goo ɓurɗe ɗee mawnude alaa.› » ");
INSERT INTO fuf_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","On jannoowo fii Sariya on wi'i mo: «Moƴƴii, yo karamoko'en, on wowlii goonga wi'ugol Alla ko Bajjo, goɗɗo goo kadi alaa ko wonaa kanko, ");
INSERT INTO fuf_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","yiɗira mo ɓernde mun nden fow e hakkil mun kin fow e doole mun ɗen fow, e yiɗirgol ɲokondo mun wa hoore mun, ɗun no ɓuri sadakaaji sunneteeɗi ɗin fow e ɗiya sadakaaji fow.» ");
INSERT INTO fuf_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ɓay Iisaa ndaarii tawii o jaaborii hakkil, o wi'i mo: «A woɗɗondiraa e *laamu Alla ngun.» Ɓawto ɗun hay gooto suusaali mo landaade. ");
INSERT INTO fuf_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Wa fewndo ko Iisaa jannata ka *juulirde mawnde, o wi'i: «Ko honno jannooɓe fii Sariya on ɓen waawiri wi'ude wonde *Almasiihu on ko jurriya Daawuuda? ");
INSERT INTO fuf_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","E hin-le, immorde e *Ruuhu Seniiɗo on, Daawuuda tigi no wi'i: ‹Joomiraaɗo on daalani Joomi an on: Jooɗor ka sengo an ɲaamo, haa mi waɗa ayɓe maa ɓen ka ley teppe maa.› ");
INSERT INTO fuf_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","«Daawuuda tigi wi'ii Almasiihu on ‹Joomi›, haray ko honno non Almasiihu on woniri jurriya makko?» Tawi jamaa ɗuuɗuɗo no heɗii mo e nder weltaare. ");
INSERT INTO fuf_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","O wi'i ɓe e nder ko o waajotoo kon: «Reenee e ɓee jannooɓe fii Sariya on, ɗun ko ɓee yiɗuɓe jindidugol e dolokkaaji njani, yiɗi hiwreede ka fottirɗe, ");
INSERT INTO fuf_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","yiɗi saffawol aranol ngol ka juulirɗe, yiɗi ndaɗɗule arane ɗen ka nafagol. ");
INSERT INTO fuf_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Hiɓe jatta galleeji keynguuɓe, hiɓe junna julɗe maɓɓe fii yiingo. Awa ɓen heɓoyay ɲaawooje ɓurɗe sattude.» ");
INSERT INTO fuf_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Onsay Iisaa jooɗii ka yeeso arkawal sadaka, o woni e ndaarugol waɗaynooɓe ton kaalisi ɓen. Alɗuɓe buy waɗi ton kaalisi ɗuuɗuɗi. ");
INSERT INTO fuf_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","O yi'i kadi keynguujo baaso no liɓa ton tammahoy ɗiɗoy, fotaykoy e peccun gootun si mbuuɗu feccaama nay. ");
INSERT INTO fuf_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Onsay kanko Iisaa o noddi taalibaaɓe makko ɓen, o wi'i ɓe: «Ka haqiiqa mi andinii on, ko oo keynguujo baaso itti kon no ɓuri ko ɓeya fow itti kon waɗi ka arkawal sadaka. ");
INSERT INTO fuf_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ko fii ɓeya fow ko ko ɓurtani ɗun kon ɓe waɗi, kono kanko keynguujo on e waasiɗude, ko ko o mari kon fow fii ko o wuurira o waɗoyi ton.» ");
INSERT INTO fuf_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Wa fewndo ko Iisaa iwata ka *juulirde mawnde, goɗɗo e taalibaaɓe makko ɓen wi'i mo: «Karamoko'en, ndaaree kaaƴe labaaɗe e darnoodi fotundi!» ");
INSERT INTO fuf_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Iisaa jaabii mo, wi'i: «A yi'ii ndii darnoodi mawndi? Hay hayre e hoore hayre luttoytaa ɗoo ko lancaaka.» ");
INSERT INTO fuf_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Onsay o jooɗoyii ka Fello *Zaytuuni yeeso juulirde nden. Onsay Petruusu e Yaaquuba e Yuuhanna e Andaraawu landii mo e gundoo, ");
INSERT INTO fuf_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","ɓe wi'i: «Yeeto men ko honde tuma ɗun waɗoyta, e ko honɗun wonoyta maande laatagol ɗun fow?» ");
INSERT INTO fuf_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Onsay Iisaa wi'i ɓe: «Reenee fii wota hay gooto faljin on, ");
INSERT INTO fuf_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","ko fii buy aroyay ɓaarora innde an nden, hara no wi'a ko kaɲun woni *Almasiihu on. Awa ɓen faljinoyay yimɓe ɗuuɗuɓe. ");
INSERT INTO fuf_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Awa kadi, nde nanoyɗon fii hareeji no wowlee woo, e haalaaji fii gereeji, haray wota on hulu, ko fii bee ɗun waɗa, kono hinaa ɗon wonata lannoode nden. ");
INSERT INTO fuf_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Hareeji kadi waɗoyay hakkunde leƴƴi ɗin. Laamateeriiji ɗin kadi immondirana, dimbanɗe leydi waɗira e nokkeeli goo, heegeeji kadi waɗa. Ko ɗun wonata fuɗɗoode sattendeeji nanditayɗi e muuseendi ŋata ɗin. ");
INSERT INTO fuf_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","«Awa reenee hoore mon, ko fii ɓe naɓoyay on ka ɲaawirɗi, ɓe foccoya on ka juulirɗe, naɓeɗon ka yeesooɓe ɓen e ka lamɓe ɓen sabu an, fii ko wonana ɓe seedee. ");
INSERT INTO fuf_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Kono ko adii kon bee Kibaaru Moƴƴo on feɲɲinanee leƴƴi ɗin fow. ");
INSERT INTO fuf_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Kono tuma ɓe naɓi on fii wattugol on e joge, wota on jiɓoyo ko wi'on. Kono wowlee ko longinaɗon e on saa'i ɗon kon tigi. Ko fii haray hinaa onon woni wowlude, kono ko *Ruuhu Seniiɗo on. ");
INSERT INTO fuf_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ko fii goɗɗo ƴettoyay musiɗɗo mun, watta mo e joge fii yo o ware, baabaajo kadi warra non ɓiɗɗo mun. Fayɓe ɓen kadi hawtanoyoo mawɓe mun ɓen, ɓe wona sabu haa ɓe waree. ");
INSERT INTO fuf_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Fow aɲoyay on sabu innde an nden. Kono mo ŋaɲɲike ɗun haa ka lannoode, o dandoyte. ");
INSERT INTO fuf_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","«Nde yi'uɗon huunde harmunde caabinaynde nden daakike ka nde haanaa wonude ɗon woo, (haray yo jangoowo on faamu), onsay yo hoɗuɓe ka diiwal Yahuuda ɓen dogir ka pelle. ");
INSERT INTO fuf_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","On wonɗo ka fowtorde hoore suudu mun wota tippano goɗɗun ka nder suudu. ");
INSERT INTO fuf_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","On wonɗo kadi ka ngesa wota yiltito fii ƴettugol dolokke mun on. ");
INSERT INTO fuf_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","E nder ɗen balɗe ɗon, bone wonanay sowiiɓe ɓen e muyninayɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Awa toree fii wota ɗun ardu ndungu. ");
INSERT INTO fuf_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ko fii satteende waɗay e ɗen ɲalaaɗe nde sifa mun waɗaali haa hande, gila ka fuɗɗoode aduna mo Alla tagi, e nde ɓuri mun waɗitataa han kadi. ");
INSERT INTO fuf_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Si tawno Joomiraaɗo on raɓɓinɗinaano ɗen ɲalaaɗe, hay gooto daɗataano, kono o raɓɓinɗinay ɗe sabu suɓaaɓe ɓe o suɓii ɓen. ");
INSERT INTO fuf_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","«Awa si goɗɗo aru on e wi'oyde wonde: ‹Almasiihu on no ɗoo!› maa ‹himo ɗaa!›, wota on hoolo mo. ");
INSERT INTO fuf_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ko fii waɗitiiɓe almasiihu e waɗitiiɓe annaba feeɲoyay, ɓe waɗoya maandeeji e kaawakeeji fii no ɓe faljinira hay suɓaaɓe ɓen, si no gasaynoo. ");
INSERT INTO fuf_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Awa reenee, ko fii mi *hiitanike on fii ɗun fow.» ");
INSERT INTO fuf_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","«Kono e ɗen ɲalaaɗe, ɓawto nden satteende, ‹Naange ngen niɓɓitay, tawa lewru ndun jalbataa, ");
INSERT INTO fuf_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","koode ɗen ka kammu kadi yana, ko tiiɗi kon ka kammu kadi dimboyoo.› ");
INSERT INTO fuf_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","«Ontuma non *Ɓii-Aaden on yi'oyte, no ara e duule, hara himo arda e bawgal mawngal e mangural. ");
INSERT INTO fuf_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Onsay o nuloya malaa'ikaaɓe makko ɓen, o mooɓa suɓaaɓe makko ɓen gila funnaange heɓi hirnaange e gila nano heɓi ɲaamo, gila ka leydi haa ka kattudi kammuuli. ");
INSERT INTO fuf_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","«Yo misal ƴibbehi kin wonan on gandal. Nde calɗi makki on hecciɗiri, ɗi wiliti, on andanay hoore mon wonde setto ngon ɓadike. ");
INSERT INTO fuf_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ko wano non kadi, no yiiruɗon ɗii piiji no waɗa woo, haray andee wonde *Ɓii-Aaden on ɓadike ka dambugal. ");
INSERT INTO fuf_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ka haqiiqa mi andinii on, ɗun fow waɗay ado nguu jamaanu feƴƴude. ");
INSERT INTO fuf_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Kammu ngun e leydi ndin feƴƴay, kono min konguɗi an ɗin feƴƴataa. ");
INSERT INTO fuf_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","«Kono hay gooto andaa fii nden ɲalaande e on saa'i, hinaa hay malaa'ikaaɓe ɓen ka kammuuli, hinaa hay Ɓiɗɗo on, kono ko Baabaajo on tun andi fii nden ɲalaande e on saa'i. ");
INSERT INTO fuf_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Awa reenee, wattanon yiila! Ko fii on andaa nde on saa'i wonata. ");
INSERT INTO fuf_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ɗun no wa'i wa neɗɗo wonɗo yahude safaari, acca suudu mun, o halfina mo kala e kurkaaduuɓe makko ɓen golle mun, o yamira wonɗo ka dambugal on aynugol. ");
INSERT INTO fuf_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Awa, wattanee yiila, ko fii on andaa nde jom suudu ndun artata, si ko kiikiiɗe, maa si ko tumbere jemma, maa si ko nde ndonto no ƴogga, maa si ko bimbi. ");
INSERT INTO fuf_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Hulee wota o aru cuppet, o tawa hiɗon ɗaanii. ");
INSERT INTO fuf_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ko mi wowlani on kon, ko fow mi wowlani: wattanee yiila!» ");
INSERT INTO fuf_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Tawi, si balɗe ɗiɗi feƴƴii, *Juldeere Yawtaneede nden e *Juldeere Bireedi ɗe Aldaa e Lewen ɗen waɗay. Tawi hooreeɓe yottinooɓe sadaka ɓen e jannooɓe fii Sariya on ɓen no ɗaɓɓaynoo ko honno ɓe nangirta Iisaa ƴoyre, ɓe wara mo. ");
INSERT INTO fuf_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Tawi hiɓe wi'a: «Hinaa ka fewndo juldeere, fii wota murtaldu waɗu e hakkunde jamaa on.» ");
INSERT INTO fuf_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Nde tawnoo Iisaa no ka saare *Betanii ka suudu Sim'uunu oo nawnunooɗo ɗamajan, wa fewndo ko o jooɗii fii nafagol, debbo naati. Tawi on debbo no jogii tindohun hayre daneere tew angiri laaɓundi, satta-cogguuri, no wi'ee ‹naar›. On debbo fusi tindohun kun, o juuri angiri ndin ka hoore Iisaa. ");
INSERT INTO fuf_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Woɓɓe e taalibaaɓe ɓen seytini, ɓe wi'indiri: «Ko honɗun woni nafa bonnugol ndii angiri? ");
INSERT INTO fuf_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ko fii en waawayno ndi yeeyude ɓuri *dinaruuji teemeɗɗe tati, okken miskinɓe ɓen!» Onsay ɓe feli debbo on. ");
INSERT INTO fuf_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Kono Iisaa wi'i: « Tertee mo! Ko fii honɗun sattinanton mo? Ko kuugal moƴƴal o waɗanimmi. ");
INSERT INTO fuf_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Miskinɓe ɓen kan, hiɗon wondi e maɓɓe soono woo, on waaway ɓe waɗande ko moƴƴi nde faalaɗon woo, kono min, on wondataa e an soono woo. ");
INSERT INTO fuf_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Kanko debbo on o waɗii ko o waawi kon: o urnii ɓandu an ndun ado ndu surreede. ");
INSERT INTO fuf_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ka haqiiqa mi andinii on, kala ka oo Kibaaru Moƴƴo feɲɲinaa e aduna on, fii koo ko oo debbo waɗi kadi sifete, o anditanee.» ");
INSERT INTO fuf_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Onsay goɗɗo e *sahaabaaɓe Iisaa ɓen sappoo e ɗiɗo, ɗun ko Yudaasi Iskariiyu, yahi tawoyi hooreeɓe yottinooɓe sadaka ɓen, fii no o wattira Iisaa e juuɗe maɓɓe. ");
INSERT INTO fuf_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ɓe heɗii mo, ɓe weltori ɗun, ɓe fodi mo yeenugol mo kaalisi. Onsay, kanko Yudaasi, o woni e ɗaɓɓugol feere no o wattira Iisaa e juuɗe maɓɓe. ");
INSERT INTO fuf_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ka ɲallal aranal Juldeere Bireedi ɗe Aldaa e Lewen ɗen, ɗun ko ɲande baalun kun hirsetee, taalibaaɓe Iisaa ɓen wi'i mo: «Ko honto faalaɗon yo men moƴƴinanoy on nafakka Juldeere Yawtaneede nden?» ");
INSERT INTO fuf_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Onsay o immini ɗiɗo e taalibaaɓe makko ɓen, o wi'i ɓe: «Yahee ka saare. On fottay e gorko rondiiɗo loonde ndiyan, on jokkay mo. ");
INSERT INTO fuf_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ka o naatiri woo, on wi'ay jom ndun suudu: ‹Karamoko'en wi'ii men yo men lando on ko honto ɓe weerata, ɓe nafoda e taalibaaɓe maɓɓe ɓen nafakka Juldeere Yawtaneede nden?› ");
INSERT INTO fuf_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ontuma o hollay on konkooru njanndu, weƴƴitaandu wertaa, ka koore dow. Ko ɗon moƴƴinton.» ");
INSERT INTO fuf_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ɓay taalibaaɓe ɓen yahii, ɓe hewtoyii ka saare, ɓe tawroyi no o haalirannoo ɓe non, ɓe moƴƴini nafakka juldeere nden. ");
INSERT INTO fuf_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ɓay niɓɓii, kanko Iisaa o ardi e sappoo e ɗiɗooɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Wa fewndo ko ɓe jooɗii, hiɓe nafaade, kanko Iisaa o wi'i ɓe: «Ka haqiiqa mi andinii on, goɗɗo e mon, mo mi woni hawtidude, janfoto lan.» ");
INSERT INTO fuf_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Onsay ɓe fuɗɗii aanude fota, mo bee e maɓɓe woni e wi'ugol mo: «E hara ko min?» ");
INSERT INTO fuf_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","O jaabii ɓe, o wi'i: «Ko goɗɗo e onon sappoo e ɗiɗooɓe ɓen, ɗun ko on mo mi yollidi jungo e miran gooto. ");
INSERT INTO fuf_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Awa *Ɓii-Aaden on no yahude wano fii makko windori non, kono bone wonanii on janfotooɗo Ɓii-Aaden on! Ko ɓurnoo moƴƴande on neɗɗo ko si o jibinanooka!» ");
INSERT INTO fuf_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","E nder ko ɓe ɲaamata kon, Iisaa ƴetti bireedi. Ɓay o gaynii du'aade, o taƴiti, o jonni ɓe, e hoore himo wi'a: «Jaɓee ɲaamon, ɗunɗoo ko ɓandu an ndun nii.» ");
INSERT INTO fuf_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","O ƴetti kadi jardukun waɗorkun njaram, o jarni Alla, o jonni ɓe, ɓe fow ɓe yari. ");
INSERT INTO fuf_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","O wi'i ɓe kadi: «Ɗunɗoo ko ƴiiƴan an ɗan nii, ƴiiƴan *ahadi hibboyteeɗan fii ɗuuɗuɓe. ");
INSERT INTO fuf_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ko fii ka haqiiqa mi andinii on, mi yaritataa hande kadi njaram ɓiɓɓe *wiiɲu haa ɲande mi yaritoyta njaram wiiɲu kesan ka *laamateeri Alla.» ");
INSERT INTO fuf_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ɓay wonii ɓe beytii beyti Zabuura, ɓe yahi ka Fello *Zaytuuni. ");
INSERT INTO fuf_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Onsay Iisaa wi'i ɓe: «On fow on selay lan, ko fii no windii: ‹Mi waray ngaynaako on, wuro baali ngon saakoo.› ");
INSERT INTO fuf_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Kono tuma mi immintinaa, mi hikkanto on yeeso, tawoyon mi Jaliilu.» ");
INSERT INTO fuf_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Petruusu wi'i mo: «Hay si fow selay on, min ɗun wonantaa lan!» ");
INSERT INTO fuf_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Onsay Iisaa jaabii mo, wi'i: «Ka haqiiqa mi andinii ma, hande e oo jemma tigi, ado ndonto ƴoggude laabi ɗiɗi, haray a yeddii fii an laabi tati.» ");
INSERT INTO fuf_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Kono Petruusu tentini fota, o wi'i: «Hay si tawii bee mi maayida e mon, mi yeddataa fii mon few!» Ɓeya fow kadi wi'iri non. ");
INSERT INTO fuf_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ɓawto ɗun ɓe yahi e ndee nokkuure wi'eteende *Jatsaymaani. Kanko Iisaa o wi'i taalibaaɓe makko ɓen: «Jooɗee ɗoo haa mi toroyoo.» ");
INSERT INTO fuf_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","O naɓori Petruusu e Yaaquuba e Yuuhanna. Onsay, o fuɗɗii heɓude annde e sokola, ");
INSERT INTO fuf_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","o wi'i ɓe: «Wonkii an kin no aani haa e mayde. Wonee ɗoo, hiiren.» ");
INSERT INTO fuf_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","O yahi yeeso seeɗa, o sujji, o torii, o wi'i: «Si no gasa yo oo saa'i yawtan.» ");
INSERT INTO fuf_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","O wi'i kadi: «Abba*, Baaba an, hiɗa waawi kala huunde. Yo kun jardukun tampere pottito lan. Kono non wota faale an on waɗu, kono yo faale maa on waɗu.» ");
INSERT INTO fuf_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","O artoyi e taalibaaɓe ɓen, o tawi ɓe ɗaanike. O wi'i Petruusu: «Sim'uunu, a ɗaanike? Jaka a waawaali hiirude hay saa'i gooto? ");
INSERT INTO fuf_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Hiiree toroɗon fii wota on naatu e jarrabi. Wonkii kin no yiɗi waɗugol ko moƴƴi, kono ɓandu ndun no lo'i.» ");
INSERT INTO fuf_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","O woɗɗitii ɓe kadi ɗimmun, o torii, o fillitii ɗiya konguɗi. ");
INSERT INTO fuf_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","O artoyi kadi, o tawi ɓe ɗaanike, ko fii hari gite maɓɓe ɗen teddii. Tawi ɓe andaa ko ɓe wi'a mo. ");
INSERT INTO fuf_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","O artoyi tammun, o wi'i ɓe: «E on ɗaani kadi, fowtiɗon? Jooni yonii, saa'i on hewtii. Awa Ɓii-Aaden on no watteede e juuɗe junuubanke'en. ");
INSERT INTO fuf_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Immee mahen, ko fii wonɗo janfaade lan on ɓadike!» ");
INSERT INTO fuf_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","E nder ko o yewtata kon, hawrondiri Yudaasi, tawdaaɗo e sappoo e ɗiɗooɓe ɓen, hewtidii e jamaa jogiiɗo kaafaaje e bedi, immorde e hooreeɓe yottinooɓe sadaka ɓen e jannooɓe fii Sariya on ɓen e mawɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Tawi wonɗo mo janfaade on waɗaniino ɓe ndee maande ɗoo, o wi'i: «Mo mi hirbii woo, haray ko on. Nangee mo, naɓon, aynon mo fota.» ");
INSERT INTO fuf_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Tun o hewti, o ɓadii Iisaa, e hoore himo wi'a: «Karamoko'en!» Onsay o hirbii mo. ");
INSERT INTO fuf_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Onsay ɓen yimɓe fawi Iisaa juuɗe, ɓe nangi mo. ");
INSERT INTO fuf_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Tun goɗɗo e wonnooɓe ɗon ɓen sorti kaafa mun kan, o soppi kurkaadu yottinoowo mawɗo sadaka on, o itti mo nowru ndun. ");
INSERT INTO fuf_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Onsay Iisaa wi'i: «Hiɗon ardi e kaafaaje e bedi fii nangugol lan wa si ko ngujjo aranɗon? ");
INSERT INTO fuf_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","E hin-le miɗo wondi e mon ɲande woo ka *juulirde mawnde, miɗo janna, on nangaali lan. Kono ɗun waɗiri fii ko windanoo kon yo laato.» ");
INSERT INTO fuf_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Onsay ɓe o wondunoo ɓen fow acci mo ɗon, dogi. ");
INSERT INTO fuf_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Suka waaniiɗo suddaare tun jokki mo, ɓe nangi mo kanko kadi. ");
INSERT INTO fuf_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Kono o sortii, o acci ɗon suddaare nden, o dogi, o ɓornaaki. ");
INSERT INTO fuf_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Onsay ɓe naɓi Iisaa ka yottinoowo mawɗo sadaka on, ka hooreeɓe yottinooɓe sadaka ɓen e mawɓe ɓen e jannooɓe fii Sariya on ɓen fow mottondiri ɗon. ");
INSERT INTO fuf_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Tawi Petruusu no iwtiri ɓaawo makko ka woɗɗitii haa ka nder tata yottinoowo mawɗo sadaka on, o jooɗodi e aynooɓe ɓen, tawi himo iwlaade ka binde yiite. ");
INSERT INTO fuf_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Tawi hooreeɓe yottinooɓe sadaka ɓen e dental fewjooɓe ɓen fow no ɗaɓɓa seedeeji e hoore Iisaa fii no ɓe warira mo, kono laatii ɓe heɓaali. ");
INSERT INTO fuf_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ko fii hari ɗuuɗuɓe no seeditoo penaale e hoore makko, kono tawi seedeeji maɓɓe ɗin yaadaa. ");
INSERT INTO fuf_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Kono woɓɓe immii, seeditii fenaande e hoore makko, tawi hiɓe wi'a: ");
INSERT INTO fuf_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","«Men nanii himo wi'a o lancay ndee juulirde mawnde darniraande juuɗe yimɓe, o darna wonnde goo e nder balɗe tati, nde tawata hinaa darniraande juuɗe yimɓe.» ");
INSERT INTO fuf_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Tawi hay e hoore ɗun seedee maɓɓe on yaadaa. ");
INSERT INTO fuf_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Onsay yottinoowo mawɗo sadaka on immii ka hakkunde dental, o landii Iisaa, o wi'i: «A jaabotaako hay huunde e ko ɓee woni seeditaade e hoore maa kon?» ");
INSERT INTO fuf_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Kono Iisaa fanki, o jaabaaki hay huunde. Yottinoowo mawɗo sadaka on landii mo kadi, wi'i: «E hara ko an woni *Almasiihu on, ɗun ko *Ɓiɗɗo Alla Jom Barki on?» ");
INSERT INTO fuf_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Iisaa jaabii, wi'i: «Ko min. On yi'ay kadi Ɓii-Aaden on no jooɗii ka sengo ɲaamo Jom Bawgal on, no arda e duule iwrude ka kammu.» ");
INSERT INTO fuf_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Onsay yottinoowo mawɗo sadaka on seeki conci mun ɗin, wi'i: «Ko seedeeji honɗi kadi faalaɗen? ");
INSERT INTO fuf_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","On nanii hoyre makko nden. Ko honɗun fottanɗon e ɗun?» Fow happirani mo foddugol e mayde. ");
INSERT INTO fuf_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Woɓɓe woni e tuttugol mo, e buumugol mo yeeso ngon, e uttagol mo e hoore hiɓe wi'a mo: «Hotto!». Aynooɓe ɓen kadi jaɓɓori mo bante. ");
INSERT INTO fuf_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Fewndo ko Petruusu jooɗii ley ka nder tata, goɗɗo e rewɓe kurkaaduuɓe ka yottinoowo mawɗo sadaka on ari. ");
INSERT INTO fuf_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","O yi'i Petruusu ka iwlotoo, o tenƴini mo, o wi'i mo: «An kadi, hiɗa wondunoo e Iisaa, oo jeyaaɗo Naasirata.» ");
INSERT INTO fuf_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","O yeddi e hoore himo wi'a: «Mi andaa, mi faamaali ko honɗun wonɗaa wi'ude.» O yalti, o yaari ka ley jimbe, tun ndontoori ndin ƴoggi. ");
INSERT INTO fuf_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","On debbo kurkaaduujo ndaari mo, wi'i wonnooɓe ɗon ɓen kadi: «Oo ko tawdaaɗo e maɓɓe.» ");
INSERT INTO fuf_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","O yeddi kadi. Ɓay nettii seeɗa, wonnooɓe ɗon ɓen wi'i Petruusu: «Ko haqiiqa, an ko a goɗɗo e maɓɓe. Ko fii ko mo a Jaliilu.» ");
INSERT INTO fuf_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Onsay o woni e huɗitagol woonda, wi'a: «Mi andaa oo neɗɗo mo wonɗon wowlude fii mun!» ");
INSERT INTO fuf_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Tun ka ɗimmun ndontoori ndin ƴoggi. Petruusu anditi kisan kongol ngol Iisaa wi'unoo mo ngol: «Ado ndonto ƴoggude laabi ɗiɗi, haray a yeddii fii an laabi tati.» Onsay o ugginii o wulli. ");
INSERT INTO fuf_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ɓay weetii, hooreeɓe *yottinooɓe sadaka ɓen e mawɓe ɓen e jannooɓe fii Sariya on ɓen e dental fewjooɓe ɓen fow yewtidani. Ɓe haɓɓi Iisaa, ɓe naɓi mo, ɓe watti e juuɗe Pilaatu. ");
INSERT INTO fuf_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilaatu landii mo, wi'i: «Hara ko an woni lanɗo Yahuudiyanke'en?» Iisaa jaabii mo: «Ko wano wi'irɗaa non.» ");
INSERT INTO fuf_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Tawi hooreeɓe yottinooɓe sadaka ɓen no liɓi tooɲe ɗuuɗuɗe e hoore makko. ");
INSERT INTO fuf_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilaatu landitii mo kadi, wi'i: «A jaabotaako hay huunde? A nanii ɗee tooɲe ɗe ɓe woni liɓude e hoore maa fow?» ");
INSERT INTO fuf_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Kono Iisaa jaabaaki hay huunde e mun. Ɗun ŋalɗini Pilaatu. ");
INSERT INTO fuf_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Tawi juldeere kala, o accitanay ɓe kasoojo gooto mo ɓe torinoo mo fii mun woo. ");
INSERT INTO fuf_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Hari goɗɗo no wi'ee Barabaasi no ka kaso, wondude e waɗunooɓe gere, e nder gere on ɓe itti hoore. ");
INSERT INTO fuf_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Onsay jamaa on ƴawi tawoyi Pilaatu, ɓe woni e toragol mo, wi'a yo o waɗan ɓe ko woowani ɓe kon. ");
INSERT INTO fuf_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilaatu jaabii ɓe, wi'i: «Hara hiɗon yiɗi yo mi accitan on lanɗo Yahuudiyanke'en?» ");
INSERT INTO fuf_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ko fii hari himo andunoo ko sabu nawliigu waɗi si hooreeɓe yottinooɓe sadaka ɓen waɗiri mo e joge. ");
INSERT INTO fuf_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Kono hooreeɓe yottinooɓe sadaka ɓen ƴuuni jamaa on fii yo Pilaatu accitan ɓe Barabaasi. ");
INSERT INTO fuf_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilaatu ƴettiti kadi haala kan, o wi'i ɓe: «Ko honɗun non faalaɗon yo mi waɗu oo mo wi'oton lanɗo Yahuudiyankeeɓe ɓen?» ");
INSERT INTO fuf_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ɓe ewnii kadi, ɓe wi'i: «Fempee mo!» ");
INSERT INTO fuf_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilaatu wi'i ɓe kadi: «E hara ko honɗun oo bonni?» Ɓe ɓurti kadi sonkude, ewnoo, wi'a: «Fempee mo!» ");
INSERT INTO fuf_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Nde tawnoo Pilaatu no faalaa weltinde jamaa on, o accitani ɓe Barabaasi. Ɓay wonii Iisaa gaynaama focceede, kanko Pilaatu o watti mo e juuɗe maɓɓe fii yo o fempe. ");
INSERT INTO fuf_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Onsay suufaaɓe ɓen naadi Iisaa ka nder tata, e maanaa ka nder suudu laamu. Ɓe nodditi dental suufaaɓe ɓen fow, ");
INSERT INTO fuf_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","ɓe ɓorni mo dolokke boɗeejo, ɓe waɗi ka hoore makko katanwol bulle saccaangol. ");
INSERT INTO fuf_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","E hoore ɗun, ɓe woni e hiwragol mo, wi'a: «Salminaango e maa, yaa an Lanɗo Yahuudiyankeeɓe!» ");
INSERT INTO fuf_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ɓe tappiri mo kadi kalinwol ka hoore, ɓe tutti mo, ɓe jiccii, ɓe sujjinkinanii mo. ");
INSERT INTO fuf_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ɓay wonii ɓe gaynii mo waɗude jalnori, ɓe ɓorti mo dolokke boɗeejo on, ɓe ɓorni mo conci makko ɗin, ɓe naɓi mo fii fempoyegol. ");
INSERT INTO fuf_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Tawi goɗɗo no wi'ee Sim'uunu mo Sirenii no iwaynoo ngesa, rewi ɗon. Tawi ko on woni ben Aleksander e Rufuusa. Ɓe karhi mo naɓugol *leggal Iisaa altindiraangal ngal. ");
INSERT INTO fuf_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Onsay ɓe naɓi Iisaa e ndee nokkuure wi'eteende Golgotaa, ko woni firo ɗun ko ‹Nokkuure Laalagal Hoore›. ");
INSERT INTO fuf_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ɓe okkori mo njaram jillaaɗan *mirri, kono laatii o jaɓaali ɗan yarude. ");
INSERT INTO fuf_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Onsay ɓe fempi mo. Ɓe sendiri conci makko ɗin urɓa fii andugol mo kala ko gasata hendaade. ");
INSERT INTO fuf_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Wa ko ɓe fempata mo, tawi ko e walluhaa on. ");
INSERT INTO fuf_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Hari ɗunɗoo no windii fii ko o happiranaa kon: «Ko lanɗo Yahuudiyanke'en.» ");
INSERT INTO fuf_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Tawi wuyɓe ɗiɗo no fempidaa e makko, goɗɗo on ka sengo makko ɲaamo, oya on ka nano makko. ");
INSERT INTO fuf_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ko nii ko bindi ɗin wi'unoo kon laatori, wonde: «O wattidete e bonɓe ɓen.» ");
INSERT INTO fuf_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Tawi feƴƴooɓe ɓen no hoyna mo, hayla hoore, wi'a: «Hey, an oo wi'unooɗo lancay *juulirde mawnde nden, darnita nde e nder balɗe tati, ");
INSERT INTO fuf_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","awa dandito an tigi, tippoɗaa ka leggal altindiraangal ɗon!» ");
INSERT INTO fuf_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Tawi hooreeɓe yottinooɓe sadaka ɓen e jannooɓe fii Sariya on ɓen kadi no jalaynoo mo hakkunde maɓɓe, wi'a: «O dandii ɓeya, kono o waawataa dandude hoore makko! ");
INSERT INTO fuf_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Si ko o *Almasiihu on, ɗun ko lanɗo *Isra'iila'en, yo o jippo ka leggal altindiraangal, yi'en, ɗun en gomɗinay mo!» Tawi fempidaaɓe e makko ɓen kadi no hoynaynoo mo. ");
INSERT INTO fuf_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Gila naange e hoore, niwre waɗi e leydi ndin fow haa ka ɓaawo fanaa. ");
INSERT INTO fuf_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Wa fewndo ka ɓaawo fanaa, Iisaa ewnii ko tiiɗi, o wi'i: «Iilooyi, Iilooyi, lama sabaxtanii?». (Ɗun no firi: Alla an, Alla an, ko fii honɗun tertaniɗaa mi?) ");
INSERT INTO fuf_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Woɓɓe e wonnooɓe ɗon ɓen nani ko o wi'i kon, ɓe wi'i: «On nanii, o noddii Iiliiya!» ");
INSERT INTO fuf_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Tun goɗɗo e maɓɓe dogi, ƴettoyi linsere, o ɓuɓɓini nde haa nde loppii ndiyan lammuɗan, o waɗi nde e tuggordu, o townani mo fii yo o yaru, e hoore himo wi'a: «Accee, ndaaren si Iiliiya aray, tippina mo.» ");
INSERT INTO fuf_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Iisaa ewnii ko tiiɗi, onsay o timmi. ");
INSERT INTO fuf_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Wirngallo* ngon ka juulirde mawnde seekii, woni pecce ɗiɗi, gila dow haa ley. ");
INSERT INTO fuf_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ɓay hooreejo suufaaɓe wonnooɗo yeeso makko kanko Iisaa on yi'ii no o timmiri non, o wi'i: «Ka haqiiqa, hari oo neɗɗo ko *Ɓiɗɗo Alla!» ");
INSERT INTO fuf_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Tawi rewɓe kadi no ka woɗɗitii, no ndaara. Tawi no tawdaa e maɓɓe Mariyama jeyaaɗo Magaduuna e Mariyama yumma Yaaquuba tosooko on e Yuusufu, e Saliimatu. ");
INSERT INTO fuf_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Tawi ko ɓen jokkunoo mo kanko Iisaa, no kurkanoo mo wa fewndo ko o wonnoo Jaliilu, e ɗuuɗuɓe goo kadi ɓe o yaadunoo Yerusalaam. ");
INSERT INTO fuf_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Hawrondiri niɓɓii, tawi ko hebulanagol *ɲalaande fowteteende nden. ");
INSERT INTO fuf_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Onsay oo wi'eteeɗo Yuusufu hewti. On ko hooloraaɗo goo e ngal dental maɓɓe, on ko jeyaaɗo Raamati, tawi on kaɲun tigi ko *laamu Alla ngun o tijjii. O heɓi cuucal yahugol ka Pilaatu, toroo mo hettugol furee Iisaa on. ");
INSERT INTO fuf_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilaatu ŋalɗi ko tawi o maayii kon. O noddi hooreejo suufaaɓe ɓen, o landii mo si tawii o maayiino. ");
INSERT INTO fuf_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ɓay hooreejo on humpitii mo ɗun, o jonniti Yuusufu furee Iisaa on. ");
INSERT INTO fuf_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Kanko Yuusufu o soodoyi kasannge, o tippini furee Iisaa on ka hoore leggal, o tumbi e kasannge, o belnoyi mo e qaburu asaaɗo e feto. O talli hayre, o waɗi ka dambugal qaburu. ");
INSERT INTO fuf_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Tawi Mariyama jeyaaɗo Magaduuna e Mariyama yumma Yuusufu no ndaara ka o belniraa. ");
INSERT INTO fuf_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ɓay *ɲalaande fowteteende nden feƴƴii, ɗun ko aseweere nden, Mariyama jeyaaɗo Magaduuna e Mariyama yumma Yaaquuba, e Saliimatu soodi tiiri fii ko ɓe fulla e furee Iisaa on. ");
INSERT INTO fuf_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","E alat, ɗun ko ɲallal aranal e nder yontere nden, ɓen rewɓe dawi bimbi subaka ka yenaande, ɗun ko ka puɗal naange. ");
INSERT INTO fuf_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Tawi hiɓe wi'indira: «Taw ko hombo tallanta en hayre wonde nden ka dambugal yenaande nden?» ");
INSERT INTO fuf_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Tun ɓe ɓanti gite, ɓe haynii, ɓe tawi nden hayre njannde tallaama. ");
INSERT INTO fuf_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ɓe naati ka nder yenaande, ɓe yi'i suka gorko, no ɓornii daneeji, no jooɗori ka sengo ɲaamo. Ɓe ŋalɗi, ɓe huli. ");
INSERT INTO fuf_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","On wi'i ɓe: «Wota on hulu! Iisaa oo jeyaaɗo Naasirata, fempaaɗo on, mo wonɗon ɗaɓɓitude on, immitike, o alaa ɗoo. E hino nokkuure ka o belnanoo ɗon. ");
INSERT INTO fuf_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Awa yahee andinoyon taalibaaɓe makko ɓen e Petruusu, o adoyto on Jaliilu. Ko ton yi'oyton mo, wano o wiirunoo on non.» ");
INSERT INTO fuf_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Onsay ɓe dogi ɓe yalti ka yenaande ko fii hari diwnol e kaawee heɓii ɓe. Kono laatii ɓe wowlanaali hay gooto huunde, ko fii hari hiɓe huli. ");
INSERT INTO fuf_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ɓay Iisaa immitike e ɲalaande aranere nden e nder yontere nden bimbi, ko o adii hollitaade ko Mariyama jeyaaɗo Magaduuna, on mo o yaltinnoo jinnaaji jeeɗiɗi e mun. ");
INSERT INTO fuf_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","On yahi, o ɓanginanoyi ɗun ɓe Iisaa wondunoo ɓen, tawi ɓen no yoomi, no wulla. ");
INSERT INTO fuf_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ɓay ɓe nanii wonde himo wuuri, awa kadi kanko debbo on o yi'ii mo, laatii ɓe hoolaaki mo. ");
INSERT INTO fuf_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ɓawto ɗun, tawi ɗiɗo e maɓɓe no e hoore laawol, no yahaynoo e fulawaa, kanko Iisaa o feeɲirani ɓe noone goo. ");
INSERT INTO fuf_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ɓen kadi arti, holliti ɗun ɓeya, laatii ɓe hoolaaki ɓen kadi. ");
INSERT INTO fuf_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ka sakkitorun o feeɲani sappoo e go'ooɓe ɓen, wa fewndo ko ɓe jooɗii fii ɲaamugol, o feli ɓe sabu angal gomɗinal maɓɓe ngal e cattal ɓerɗe maɓɓe ɗen, fii ko ɓe hoolaaki yi'unooɓe mo ɓen kon ɓawto o immintineede. ");
INSERT INTO fuf_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","E hoore ɗun o wi'i ɓe: «Yahee e aduna on fow, feɲɲinanon tageefo ngon fow Kibaaru Moƴƴo on. ");
INSERT INTO fuf_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Kala on gomɗinɗo, *lootaa maande kisiyee, dandoyte, kono kala on mo gomɗinaali, happante. ");
INSERT INTO fuf_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","E hino maandeeji wondayɗi e ɓen gomɗinɓe: e innde an ɓe raɗoyto jinnaaji ɗin, ɓe wowla kadi e *haalaaji goo, ");
INSERT INTO fuf_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ɓe nanga bolle, si ɓe yaru kadi njaram waroojan, ɗun masinbintaa ɓe. Si ɓe *fawoyii kadi juuɗe maɓɓe ɗen e hoore nawnuɓe ɓen, ɓen ndikkay.» ");
INSERT INTO fuf_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ɓay Iisaa Joomi on gaynii ɓe yewtude, o ƴentinaa ka kammu, o jooɗori ka sengo ɲaamo Alla. ");
INSERT INTO fuf_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Kamɓe kadi ɓe yahi, ɓe waajoyii hen fow, tawi Joomiraaɗo on no gollidude e maɓɓe, o haqinqiniri daalol ngol maandeeji ɗi ngol wondunoo ɗin.");
INSERT INTO fuf_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ɓay woodiino yimɓe ɗuuɗuɓe, nangannooɓe wallifagol fillayeeji fii piiji feƴƴunooɗi hakkunde men, ");
INSERT INTO fuf_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","wano ɓee tawanooɓe gila ka fuɗɗoode yottinirnoo non e men, ɓen seeditorɓe gite mun, wonti kurkantooɓe daaluyee on, ");
INSERT INTO fuf_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","min kadi mi taw no hawranimmi, yo Tawaafiilu tedduɗo, tippude e koo ko mi tefi, mi fensiti gila ka fuɗɗoode, weeɓitirangol on ɗun bindudi rewrundi, ");
INSERT INTO fuf_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","fii no andiron pellital wongal ngal e nder ɗii janndeeji ɗi jannaɗon. ");
INSERT INTO fuf_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Fewndo *Heroodu laaminoo diiwal *Yahuuda ngal, wooduno *yottinoowo sadaka wi'eteeɗo Zakariyaa'u jeyaaɗo e mojobere oo wi'eteeɗo Abiiya. Sonna makko ko e leɲol *Haaruuna jeyaa, on no wi'ee Elisabaatu. ");
INSERT INTO fuf_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ɓe ɗiɗoo non ko ɓe feewuɓe yeeso Alla, awa kadi hiɓe jokkunoo yamirooje e sariyaaji Joomiraaɗo on e ɓaawo feloore. ");
INSERT INTO fuf_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Kono tawi ɓe maraa ɓiɗɗo, ɓay hari Elisabaatu wonaa jiidotooɗo, awa kadi mo kala e maɓɓe nawyii. ");
INSERT INTO fuf_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Tawi non e nder ko kanko Zakariyaa'u o gollaynoo golle yottingol sadakaaji ka Alla, ɗun ko fewndo ko mojobere makko nden ardinaa yottingol sadakaaji, ");
INSERT INTO fuf_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","o toɗɗorano urɓa tippude e naamuuji maɓɓe kamɓe yottinooɓe sadaka ɓen naatugol ka nder juulirde Joomiraaɗo on, fii ittugol sadaka urngallooji sunneteeɗi. ");
INSERT INTO fuf_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Fewndo on saa'i ittugol sadaka urngallooji, tawi jamaa on fow no juula ka yaasi. ");
INSERT INTO fuf_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ko fewndo on saa'i malaa'ikaajo Joomiraaɗo on feeɲani mo, no darii ka ɲaamo ittirde sadaka urngallooji. ");
INSERT INTO fuf_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ɓay Zakariyaa'u yi'ii on malaa'ikaajo, o ɗenƴii, o huli. ");
INSERT INTO fuf_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Kono malaa'ikaajo on wi'i mo: «Wota a hulu, yo Zakariyaa'u, ko fii toraare maa nden jaɓaama. Sonna maa Elisabaatu jibinante boobo gorko, a innay on Yaayaa. ");
INSERT INTO fuf_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","O wonane welo-welo e weltaare, awa kadi yimɓe buy weltoray jibinegol makko, ");
INSERT INTO fuf_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","sabu o wonay aaden mawɗo yeeso Joomiraaɗo on. O yaroytaa njaram mandilinayɗan e kala ko caakinta. *Ruuhu Seniiɗo on wonoyay e makko gila ka teege yumma makko, ");
INSERT INTO fuf_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","awa kadi o artiroyay *Banii-Isra'iilayankeeɓe buy e laawol Joomiraaɗo on, on Alla maɓɓe. ");
INSERT INTO fuf_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","O yaaray yeeso Joomiraaɗo on e nder ruuhu e doole wa Iiliiya, fii no o artira ɓerɗe baabiraaɓe e telen-ma ɓiɓɓe mun, o artira murtuɓe ɓen e telen-ma faamu feewuɓe ɓen, e fii no o eɓɓirana Joomiraaɗo on jamaa hebulaniiɗo mo.» ");
INSERT INTO fuf_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakariyaa'u wi'i malaa'ikaajo on: «Ko honno ɗun henirantammi? Ko fii mi nawyii, awa ɓeyngu an kadi wonii nayeejo.» ");
INSERT INTO fuf_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Malaa'ikaajo on jaabii mo: «Ko min woni Jibriilu, darotooɗo takko Allaahu on. Ko mi imminaaɗo fii yewtugol ma, humpite oo kibaaru moƴƴo. ");
INSERT INTO fuf_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Jooni, a mbobiɗay, a waawataa wowlude ɗoo e ɗun laataade, sabu a hoolaaki ɗii konguɗi an laatoytooɗi e saa'i happaaɗo on.» ");
INSERT INTO fuf_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Tawi non jamaa on no habbii Zakariyaa'u, hiɓe jiɓii ko honɗun neeɓini mo ka nder *juulirde mawnde ton. ");
INSERT INTO fuf_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ɓay o yaltii, o waawaali ɓe yewtude hay fus. Ɓe ndaari, ɓe tawi o feɲɲinanaama ka nder juulirde mawnde ton. O woni e eɓɓirangol ɓe juuɗe, o lutti mbobiɗude. ");
INSERT INTO fuf_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ɓay ɲalaaɗe makko yottingol sadakaaji ɗen timmii, o yiltitii ka suudu makko. ");
INSERT INTO fuf_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ɓay feƴƴii e ɗun, sonna makko Elisabaatu ƴetti reedu. O suuɗitii e nder lebbi jowi, himo wi'a: ");
INSERT INTO fuf_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","«E hino ko Joomiraaɗo on waɗanimmi kon, o yeƴƴitike lan jooni, o ittanii lan kaa hersa ka mi wondunoo e hakkunde ɓee yimɓe.» ");
INSERT INTO fuf_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ka lewru jeegaɓuru, Allaahu on nuli oo malaa'ikaajo wi'eteeɗo Jibriilu e ndee saare Naasirata jeyaande e ngal diiwal Jaliilu ");
INSERT INTO fuf_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","haa e oo jiwo wi'eteeɗo Mariyama, mo gorko wi'eteeɗo Yuusufu jeyaaɗo e bolondaa Daawuuda ƴami. ");
INSERT INTO fuf_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Malaa'ikaajo on naati ka on jiwo, wi'i: «Mi salminii ma, an oo yeɗaaɗo sulfu. Joomiraaɗo on no wondi e maa.» ");
INSERT INTO fuf_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ngol kongol jiɓi mo, o miijii ko honɗun e salminaango nii. ");
INSERT INTO fuf_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Malaa'ikaajo on wi'i mo: «Wota a hulu yo Mariyama, sabu a heɓii sulfu immorde ka Allaahu on. ");
INSERT INTO fuf_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Awa a ƴettay reedu, jibinaa boobo gorko, innoyaa mo Iisaa. ");
INSERT INTO fuf_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","O wonay mawɗo, o noddiree Geɗal Jom Ɓural on. Allaahu Joomiraaɗo on jonnoyay mo jullere laamu maama makko Daawuuda nden. ");
INSERT INTO fuf_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","O laamoyto suudu Yaaquuba ndun haa poomaa, awa kadi laamu makko ngun lannataa.» ");
INSERT INTO fuf_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mariyama wi'i malaa'ikaajo on: «E ko honno ɗun laatorta, ɓay mi andaali gorko?» ");
INSERT INTO fuf_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Malaa'ikaajo on jaabii mo, wi'i: «Ruuhu Seniiɗo on aray e maa, bawgal Jom Ɓural on ɗuwirte ɗowdi mun ndin. Ko ɗun si boobo *seniiɗo heɓoyteeɗo on noddiroyte *Ɓiɗɗo Alla. ");
INSERT INTO fuf_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Jooni non, Elisabaatu oo musiɗɗo maa ko sowiiɗo, o sowike kanko kadi e nder nayeewu makko boobo gorko. On wi'anooɗo jiidotaako no e nder lewru jeegaɓuru mun ");
INSERT INTO fuf_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","sabu alaa ko Allaahu on ronki.» ");
INSERT INTO fuf_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Onsay Mariyama wi'i: «Min ko mi korɗo Joomiraaɗo on. Yo woniranan wano wiiruɗon non.» Onsay malaa'ikaajo on yahi. ");
INSERT INTO fuf_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","E nder ɗen balɗe ɗon, Mariyama immii no heɲii yahugol e saare goo ka hoore pelle e nder ndii leydi bolondaa Yahuuda. ");
INSERT INTO fuf_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","O naati ka suudu Zakariyaa'u, o salmini Elisabaatu. ");
INSERT INTO fuf_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","No Elisabaatu nanirnoo salminaango Mariyama ngon, ɓiɗɗo makko on memminii ka nder reedu makko, kanko Elisabaatu o heewi Ruuhu Seniiɗo on, ");
INSERT INTO fuf_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","o ewnii ko tiiɗi, o wi'i: «An ko a barkinaaɗo e hakkunde rewɓe ɓen, awa kadi ɓiɗɗo mo saawuɗaa on ko barkinaaɗo! ");
INSERT INTO fuf_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","E ko honno mi newniranaa yo yumma Koohoojo an on seeno ka an. ");
INSERT INTO fuf_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","No hito salminaango maa ngon naatirnoo ka noppi an, boobo mo mi saawi on memminii weltaare ka reedu an. ");
INSERT INTO fuf_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","On hooliiɗo ko Joomiraaɗo on fodi ɗun kon ko laatotooɗun, haray ko malaaɗo!» ");
INSERT INTO fuf_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Onsay Mariyama wi'i: «Wonkii an kin no manta Joomiraaɗo on. ");
INSERT INTO fuf_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ruuhu an on no weltanii Allaahu on, on Dandoowo lan, ");
INSERT INTO fuf_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ɓay o liiƴii giiɗe makko ɗen e ndee lo'ere an min oo korɗo makko. Ko ɗun waɗi, gila hande kala jamaanu aroyayngu wi'oyay ko mi barkinaaɗo, ");
INSERT INTO fuf_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ɓay Jom Bawgal on waɗanii lan piiji mawnuɗi, innde makko nden ko hormorteende. ");
INSERT INTO fuf_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Awa kadi yurmeende makko nden no layude e hoore ɓen hulooɓe mo, gila e jamaanu heɓi e jamaanu. ");
INSERT INTO fuf_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","O golliri doole jungo makko ngon golle mawɗe. O saakiti ɓen waɗuɓe e ɓerɗe mun miijooji townitaare. ");
INSERT INTO fuf_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","O jippini ɓen marɓe doole ka julle mun laamu. O towni lo'uɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","O harniri weelaaɓe ɓen piiji moƴƴi. O raɗii alɗuɓe ɓen juuɗe mehe. ");
INSERT INTO fuf_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","O faabii *Isra'iila'en, ɓen jiyaaɓe makko. O anditi fii yurmeende makko nden, ");
INSERT INTO fuf_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","wano o fodirnoo maamaaɓe men ɓen e Ibraahiima e jurriya mun on non haa poomaa.» ");
INSERT INTO fuf_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mariyama wondi ɗon e Elisabaatu e nder lebbi tati. Onsay o yiltitii ka makko. ");
INSERT INTO fuf_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ɓay hewtii ka Elisabaatu jibinta, o jibini boobo gorko. ");
INSERT INTO fuf_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","No kawtalɓe makko ɓen e siɓɓe makko ɓen humpitornoo nden yurmeende nde Joomiraaɗo on yeɗi mo, ɓe weltodi e makko. ");
INSERT INTO fuf_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ka ɲallal jeetataɓal, ɓe ari *sunningol boobo on, ɓe faalaa mo innitirde ben makko Zakariyaa'u. ");
INSERT INTO fuf_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Kono yumma makko ƴetti haala kan, wi'i: «Oo'o, ko Yaayaa o innetee!» ");
INSERT INTO fuf_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ɓe wi'i mo: «Hay gooto e musiɓɓe maa ɓen innaaka nden innde ɗon!» ");
INSERT INTO fuf_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ɓe landori ben boobo on eɓɓirangol mo juuɗe fii andugol ko honno o innata boobo on. ");
INSERT INTO fuf_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zakariyaa'u torii alluwal, o windi ɗon: «Ko Yaayaa o innetee.» Onsay ɓe fow ɓe ŋalɗi. ");
INSERT INTO fuf_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ɗon kisan, o hetti hunduko makko kon e ɗenngal makko ngal, o wowli, o jarni Alla. ");
INSERT INTO fuf_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Onsay yimɓe kawtal ngal fow huli, awa kadi koɗooli wonɗi ka hoore pelle Yahuuda ɗin fow hollondiri fii kon ko waɗi ɗon. ");
INSERT INTO fuf_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Kala nanuɗo ɗun miijii e ɓernde mun, wi'i: «Ko honɗun oo boobo laatotoo?» Tawi bawgal Joomiraaɗo on no wondi e makko. ");
INSERT INTO fuf_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ɓay Zakariyaa'u ben boobo on heewii Ruuhu Seniiɗo on, o woni e haalugol ko o longinaa, o wi'i: ");
INSERT INTO fuf_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«Mantoore wonanii Joomiraaɗo on, on Alla Isra'iila'en, e nder ko o faabii o sotti jamaa makko on kon. ");
INSERT INTO fuf_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","O yeɗii en Dandoowo mawɗo e nder nduu suudu Daawuuda, on jiyaaɗo makko ");
INSERT INTO fuf_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","wano o daalirnoo e kundule annabaaɓe makko laaɓuɓe ɓen gila e duuɓi feƴƴunooɗi, ");
INSERT INTO fuf_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","hisingol en e juuɗe ayɓe men e kala aɲuɓe en. ");
INSERT INTO fuf_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ko nii o yeɗirnoo maamiraaɓe men ɓen yurmeende, o anditi *ahadi makko seniindi ndin, ");
INSERT INTO fuf_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","ɗun ko woondoore nde o woondannoo ben men Ibraahiima nden ");
INSERT INTO fuf_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","fii jattingol en e juuɗe ayɓe men ɓen e newnangol en rewugol mo e ɓaawo kulol ");
INSERT INTO fuf_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","e nder laaɓal e peewal yeeso makko, e nder ngurndan men ɗan fow. ");
INSERT INTO fuf_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","An-le oo boobo, a innete annabaajo Alla Jom Ɓural on, sabu a hikkanto Joomiraaɗo on yeeso fii moƴƴinangol mo laawi makko ɗin, ");
INSERT INTO fuf_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","fii no o andinira jamaa makko on wonde ko yaafuyee junuubaaji maɓɓe ɗin o yeɗirta ɓe kisiyee, ");
INSERT INTO fuf_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ko fii Alla men on ko heewuɗo yurmeende, ɗun ko nden nde o imminirani en ndaygu immorde ka dow ");
INSERT INTO fuf_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","fii ndayginangol wonɓe ka niwre ɓen e ɓen jooɗiiɓe ka ɗowdi mayde e fii ardagol en e laawol ɓuttu.» ");
INSERT INTO fuf_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Paykun kun njanɗi, ruuhu makko on kadi tiiɗi. Ko ka wulaa o daakinoo haa ɲande o feeɲannoo *Banii-Isra'iila'en. ");
INSERT INTO fuf_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","E nder ɗen balɗe ɗon Awgustu lanɗo mawɗo Roomu on yamiri winditagol laamateeri makko ndin fow. ");
INSERT INTO fuf_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Fewndo nden winditannde aranere, hari ko Kiriniiyu woni ko halfinaa ardagol leydi Sirii ndin. ");
INSERT INTO fuf_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Mo kala winditorayno ka saare mun. ");
INSERT INTO fuf_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yuusufu kaɲun kadi iwri ka diiwal Jaliilu e ndee saare Naasirata fii yahugol ka diiwal Yahuuda, ka saare Daawuuda wi'eteende Bayti-Lahiimi, ɓay hari ko o jeyaaɗo e nder ɓeynguure Daawuuda nden, awa kadi ko e ndun suudu o jeyaa, ");
INSERT INTO fuf_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","fii no o winditodira e Mariyama on ƴamaaɗo makko, tawi on ko sowiiɗo. ");
INSERT INTO fuf_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Fewndo ɓe wonnoo ɗon, saa'i ka Mariyama jibinta hewti. ");
INSERT INTO fuf_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","O firtii dikkuru makko ndun. O buumi mo e wudere, o wallini e nder kunnawal ɲamminirgal daabeeji, ɓay hari ɓe heɓaali werde ka suudu hoɓɓe. ");
INSERT INTO fuf_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Tawi e on jemma, no woodunoo e ngal diiwal ɗon ngaynaakooɓe daakinooɓe fii aynugol gureeli mun ɗin. ");
INSERT INTO fuf_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Malaa'ikaajo Joomiraaɗo on feeɲani ɓe, annoora Joomiraaɗo on jalbini nokkuure ka ɓe woni ɗon. Ɓe huli fota. ");
INSERT INTO fuf_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Kono malaa'ikaajo on wi'i ɓe: «Wota on hulu, sabu miɗo feɲɲinande on Kibaaru Moƴƴo mo welo-welo moolanaango wonanayngo jamaa on fow. ");
INSERT INTO fuf_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Hande e ndee saare Daawuuda, on daɲanaama ton Dandoowo, on-le ko *Almasiihu on, ko kanko woni Joomi on. ");
INSERT INTO fuf_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Awa seedee mun, on taway boobo penu no buumaa e nder wudere, wallinaa e nder kunnawal.» ");
INSERT INTO fuf_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","No o gaynirnoo wowlude ɗun, ɗon kisan konu malaa'ikaaɓe moolanaangu tawti malaa'ikaajo on, no manta Allaahu on, hiɓe wi'a: ");
INSERT INTO fuf_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«Mangural wonanii Allaahu on ka kammu, ɓuttu wonii e oo aduna, hakkunde ɓen ɓe o waɗani sulfu makko on!» ");
INSERT INTO fuf_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ɓay malaa'ikaaɓe ɓen ƴentii, ngaynaakooɓe ɓen wi'indiri: «Mahen Bayti-Lahiimi ndaaroyen ko waɗi ton kon, ɗun ko koo ko Joomiraaɗo on andini en fii mun!» ");
INSERT INTO fuf_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ɓe yahi heɲa, ɓe tawoyi Mariyama e Yuusufu ton, tawi boobo penu on kadi no wallinaa ka nder kunnawal. ");
INSERT INTO fuf_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ɓay ɓe yi'ii mo, ɓe fillitii ko ɓe wowlananoo kon fii on boobo. ");
INSERT INTO fuf_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Kala nanunooɓe ko ɓen ngaynaakooɓe yewtaynoo kon wontiri ɗun ŋalaw. ");
INSERT INTO fuf_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mariyama mari ɗun fow ka ɓernde mun, maanditii fii miijitagol. ");
INSERT INTO fuf_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ontuma ngaynaakooɓe ɓen yiltitii, hiɓe manta mawnina Allaahu on fii kala ko ɓe nanunoo e ko ɓe yi'i wano ɓe wowlirananoo non tigi. ");
INSERT INTO fuf_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ɓay balɗe jeetati ɗen timmii, o sunninaa o innaa Iisaa, innde nde malaa'ikaajo on toɗɗaninoo boobo on nden ado neene makko saawude mo. ");
INSERT INTO fuf_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ɓay ɲalaaɗe fii laɓɓinagol maɓɓe ngol timmii, wano Sariya Muusaa on wiirunoo non, ɓe naɓi boobo on *Yerusalaam fii weeɓitangol mo Joomiraaɗo on, ");
INSERT INTO fuf_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","(wano windori non ka Sariya Joomiraaɗo on: «Kala boobo gorko afo on ka neene mun ko Joomiraaɗo on jeyi.»), ");
INSERT INTO fuf_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","e fii ittugol sadaka legetereeji ɗiɗi maa gabooji kecci ɗiɗi wano wiiranoo non ka Sariya Joomiraaɗo on. ");
INSERT INTO fuf_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Tawi no woodunoo Yerusalaam gorko wi'eteeɗo Sim'uunu. On ko feewuɗo e kadi ko rewoowo Joomiraaɗo on. Himo tijjaninoo *Isra'iila'en on Dandoowo, tawi kadi *Ruuhu Seniiɗo on no e hoore makko. ");
INSERT INTO fuf_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ruuhu Seniiɗo on feɲɲinanno mo wonde o maayataa ado o yi'ude Almasiihu Joomiraaɗo on. ");
INSERT INTO fuf_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ruuhu Seniiɗo on ardii mo haa ka *juulirde mawnde. Fewndo ko mawɓe paykun kun addata kun, ɗun ko Iisaa, fii laatinangol kun aadaaji maɓɓe tippude e Sariya Muusaa on, ");
INSERT INTO fuf_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","kanko Sim'uunu o tambii paykun kun ka juuɗe makko, o jarni Alla, o wi'i: ");
INSERT INTO fuf_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«Jooni non, yaa an Joomiraaɗo, a accay jiyaaɗo maa on maaya e nder ɓuttu wano daalirannoɗaa mo non, ");
INSERT INTO fuf_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","sabu mi yi'irii gite an ɗen kisiyee iwruɗo e maa on, ");
INSERT INTO fuf_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","mo moƴƴinɗaa yeeso jamaaji ɗin fow, ");
INSERT INTO fuf_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ɗun-le ko ndaygu hentinanayngu leƴƴi aduna on fow e darja wonanayɗo jamaa maa *Isra'iila on.» ");
INSERT INTO fuf_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ben makko e yumma makko ŋalɗi fii ko wowlanoo fii makko kon. ");
INSERT INTO fuf_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Sim'uunu du'anii ɓe, wi'i Mariyama neene paykun kun: «Awa kun paykun wonoyay fii liɓugol woɓɓe, ɓanta ɓeya e nder leydi Isra'iila ndin e fii wonugol maande nde yimɓe ɓen yeddata, ");
INSERT INTO fuf_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","e fii no miijooji ɓerɗe buy feeɲira. An kadi a heɓay nguli ɓernde wa tufiraande kaafa.» ");
INSERT INTO fuf_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Tawi no woodunoo ɗon kadi debbo haaloowo ko Alla longini ɗun wi'eteeɗo Hannatu, on ko geɗal Fanu'iila, jeyaaɗo e bolondaa Asiira, duuɓinɗo fota. On ko yeru duuɓi jeeɗiɗi wondunoo e moodi mun gila curbayaagal makko. ");
INSERT INTO fuf_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ontuma o heynii haa o heɓi duuɓi cappanɗe jeetati e nay. E nder ɗun kadi, o iwataano ka juulirde mawnde, himo duuminoo ton e rewugol Alla, hoora, toroo jemma e ɲalorma. ");
INSERT INTO fuf_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","On debbo hewti e on saa'i tigi, himo jarna Alla, himo wowlana kala tijjinooɗo hisineede ndee saare Yerusalaam fii kun paykun. ");
INSERT INTO fuf_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ɓay Yuusufu e Mariyama waɗii ko Sariya Joomiraaɗo on yamiri kon fow, ɓe yiltitii ka saare maɓɓe Naasirata, ɗun ko e nder Jaliilu. ");
INSERT INTO fuf_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Tawi paykun kun no njanɗude tun tiiɗa e nder ko kun heewata faamu kon. Awa kadi sulfu Alla on no e hoore makkun. ");
INSERT INTO fuf_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Tawi mawɓe Iisaa ɓen yahayno hitaande kala Yerusalaam fii *Juldeere Yawtaneede nden. ");
INSERT INTO fuf_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ɓay kun heɓii duuɓi sappoo e ɗiɗi, ɓe yaadi e makkun e nden juldeere wano woowiri non. ");
INSERT INTO fuf_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ɓay juldeere nden feƴƴii, mawɓe paykun kun hooti, kono kaɲun paykun kun, ɗun ko Iisaa, luttiti Yerusalaam, tawi mawɓe makkun ɓen andaali. ");
INSERT INTO fuf_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ɓay hiɓe sikka paykun kun no wondi e ɓe ɓe ardunoo ɓen, ɓe yahi yeru ɲallal. Onsay ɓe woni e ɗaɓɓitugol kun e hakkunde siɓɓe maɓɓe ɓen e andindiraaɓe maɓɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ɓay ɓe yiitaali kun, ɓe yiltitii Yerusalaam fii ɗaɓɓitoygol kun. ");
INSERT INTO fuf_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Balɗe tati ɓaawo ɗun, ɓe tawoyi kun ka juulirde mawnde, hikun jooɗii hakkunde karamokooɓe ɓen, heɗitii ɓe, e kadi hikun landotonoo ɓe lande. ");
INSERT INTO fuf_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Nanunooɓe hikun yewta ɓen fow ŋalɗi sabu hakkille makkun ɗen e ko kun jaabotonoo kon. ");
INSERT INTO fuf_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ɓay mawɓe makkun ɓen yi'ii kun, ɓe ŋalɗi, neene makkun wi'i kun: «Boobo an, ko honɗun waɗanɗaa men ɗun? E hino ɗun fow min e ben maa meɗen ɗaɓɓitude ma e nder sokola!» ");
INSERT INTO fuf_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Kun wi'i ɓe: «Ko fii honɗun ɗaɓɓitirton mi? Hari on andaa miɗo haani wonude ka suudu Ben an?» ");
INSERT INTO fuf_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Kono kamɓe ɓe faamaali ngol kongol ngol kun haalani ɓe. ");
INSERT INTO fuf_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ontuma kun yiltodi e maɓɓe Naasirata, kun yankinanii ɓe. Neene makkun mari ɗin piiji fow ka ɓernde mun maanditii. ");
INSERT INTO fuf_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Tawi kun paykun, ɗun ko Iisaa, no mawnude tun, faamu makko on kadi ko yeeso tun woni yaarude, himo ɓeydoo tun welude Allaahu on e yimɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ka laamu Tibariiyu heɓi duuɓi sappoo e jowi ɗon, ɗun ko lanɗo mawɗo Roomu on, fewndo onsay hari ko Pilaatu Pontii woni lanɗo diiwal Yahuuda ngal, tawi ko *Heroodu laamii diiwal Jaliilu ngal, tawi ko Filiipu miɲɲiraawo makko on kadi laamii ɗee leyɗe ɗoo, ɗun ko Ituuriiya e Taraahuuniti, tawi ko Lisaaniiyu laamii diiwal Abiliiya ngal, ");
INSERT INTO fuf_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","fewndo Hannaana e Qayaafa wonnoo *yottinooɓe mawɓe sadaka, Allaahu on daalanno Yaayaa mo Zakariyaa'u ka wulaa. ");
INSERT INTO fuf_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Onsay Yaayaa yahi daande Yurdayniwol fow himo waajoo yimɓe ɓen yo ɓe aru ɓe *lootee maande tuubuubuyee fii yo junuubaaji maɓɓe ɗin yaafe ");
INSERT INTO fuf_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","wano windori non ka deftere fii ɗii konguɗi annabi *Isaaya: «Kaa hawa ko hawa ewnotooɗo ka wulaa, wi'a: Moƴƴinee laawol Joomiraaɗo on, fewnon juri makko ɗin. ");
INSERT INTO fuf_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ayɗe ɗen fow uddete, pelle njane e tosooke ɗen fow joltinee. Ɗate ɓoyliiɗe ɗen fewnee, laawi kaanuɗi ɗin newɗinee. ");
INSERT INTO fuf_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Kala neɗɗanke yi'ay kisiyee iwruɗo ka Alla on.» ");
INSERT INTO fuf_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","O wi'ayno ɗin jamaaji arayɗi e makko fii *lootegol maande tuubuubuyee: «Ko onon yo iwdi kuura! Ko hombo tindini on dogugol tikkere aroyaynde nden? ");
INSERT INTO fuf_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Awa yo kuuɗe mon ɗen hollu wonde on tuubii. Hara on hooloraali wi'ugol wonde ko Ibraahiima woni maama mon, ko fii mi andinii on, Alla no waawi wattude ɗee kaaƴe ɗoo ɓiɓɓe Ibraahiima. ");
INSERT INTO fuf_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Toode teenirde nden no waalii ka binde leɗɗe. Kala leggal ngal rimataa ɓiɓɓe moƴƴuɓe, ngal soppete, ngal bugee ka yiite!» ");
INSERT INTO fuf_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Onsay yimɓe ɓen landii mo: «Ko honɗun men waɗata jooni?» ");
INSERT INTO fuf_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","O jaabii ɓe: «Kala marɗo dolokkaaji ɗiɗi yo sendodu ɗi e mo maraa. Kala jogiiɗo kadi ɲaametee yo o warru wano non.» ");
INSERT INTO fuf_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ƴantooɓe* sagalle ɓen ari e makko fii lootegol maande tuubuubuyee, ɓe wi'i mo: «Karamoko, ko honɗun men haani waɗude?» ");
INSERT INTO fuf_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","O wi'i ɓe: «Wota on ƴantu toonin ko yamiraɗon kon.» ");
INSERT INTO fuf_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Suufaaɓe goo kadi landii mo: «Menen-le, ko honɗun men haani waɗude?» O jaabii ɓe: «Wota on jattu hay gooto kaalisi, wota on ittin hay gooto e hoore tooɲe, yo njoddi mon ndin yonu on.» ");
INSERT INTO fuf_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Tawi mo bee e maɓɓe no miijotonoo ka ɓernde mun si tawii wonaa Yaayaa woni *Almasiihu on, ko fii hari jamaa on no sabbinoo on. ");
INSERT INTO fuf_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Kanko Yaayaa o jaabii ɓe, o wi'i: «Min, ko ndiyan mi woni on lootirde, kono ɓurɗo lan doole on, mo mi hewtaa hay firtugol ɓoggi paɗe mun, no arude. On non ko *Ruuhu Seniiɗo on e yiite o lootirta on. ");
INSERT INTO fuf_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Himo jogii feeteewo makko ngon ka jungo, ko o hentinira bete makko on, o mooɓa ɲaametee on ka beembal makko, o sunnira foron on yiite nge ɗaanotaako.» ");
INSERT INTO fuf_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Tawi Yaayaa no feɲɲinanaynoo jamaa on Kibaaru Moƴƴo wondude e waajuuji heewuɗi. ");
INSERT INTO fuf_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Kono ɓay Yaayaa felii *Heroodu lanɗo diiwal ngal, sabu ko on resi sonnaajo yumma-gooto mun on kon, ɗun ko debbo wi'eteeɗo Heroodiiya, wondude e kala bonnereeji ɗi o waɗaynoo, ");
INSERT INTO fuf_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","onsay Heroodu ɓeyditiri ɗun hendagol Yaayaa, soka mo. ");
INSERT INTO fuf_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Fewndo ko jamaa on fow ari fii lootegol maande tuubuubuyee, Iisaa kadi lootoraa. Fewndo ko o du'otoo, kammu ngun udditii, ");
INSERT INTO fuf_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ruuhu Seniiɗo on ƴetti mbaadi gabooru tippii e makko. Onsay hawa nanii ka kammu, no wi'a: «Ko an woni Ɓiɗɗo an yiɗaaɗo on, miɗo weltor-maa.» ");
INSERT INTO fuf_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ko Iisaa fuɗɗii waajaade, ko wa mo duuɓi cappanɗe tati. Ko o tuumanooɗo wonugol geɗal Yuusufu, on ɓiɗɗo Helii, ");
INSERT INTO fuf_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","mo Matsaata, mo Lewi, mo Malkii, mo Yannaa, mo Yuusufu, ");
INSERT INTO fuf_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","mo Mataasiyaa, mo Amuusa, mo Naahuuma, mo Haslii, mo Najji, ");
INSERT INTO fuf_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","mo Maasa, mo Mataasiyaa, mo Sim'ii, mo Yuusuka, mo Yahuuza, ");
INSERT INTO fuf_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","mo Yuuhanna, mo Reesa, mo Zarubaabila, mo Sa'alti'iila, mo Neerii, ");
INSERT INTO fuf_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","mo Malkii, mo Addii, mo Qusaama, mo Almudaama, mo Iiri, ");
INSERT INTO fuf_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","mo Yuusii, mo Aliyaasaru, mo Yuriima, mo Matsaata, mo Lewi, ");
INSERT INTO fuf_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","mo Sim'uunu, mo Yahuuda, mo Yuusufa, mo Yuunaana, mo Alyaqiima, ");
INSERT INTO fuf_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","mo Malayaa, mo Maynaana, mo Mataasa, mo Naasaana, mo Daawuuda, ");
INSERT INTO fuf_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","mo Yassaa'u, mo Obiida, mo Bo'aaza, mo Salmaana, mo Nahasuuna, ");
INSERT INTO fuf_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","mo Ammiina-Daaba, mo Adumiina, mo Arnii, mo Hasruunu, mo Faarisa, mo Yahuuda, ");
INSERT INTO fuf_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","mo Yaaquuba, mo Issaaqa, mo Ibraahiima, mo Taaraha, mo Naahuura, ");
INSERT INTO fuf_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","mo Seruuja, mo Ra'uwa, mo Faalaja, mo Aabira, mo Saalaha, ");
INSERT INTO fuf_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","mo Kiinaana, mo Arfaksaada, mo Saama, mo Nuuhu, mo Laamaka, ");
INSERT INTO fuf_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","mo Matuusaalaha, mo Hanuuka, mo Yaarada, mo Mahalaliila, mo Kiinaana, ");
INSERT INTO fuf_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","mo Anuusa, mo Siita, mo *Aadama, mo Allaahu on. ");
INSERT INTO fuf_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Iisaa iwi Yurdayniwol no heewi *Ruuhu Seniiɗo on. Ruuhu on nawri mo ka wulaa. ");
INSERT INTO fuf_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ko ton Ibuliisa ndarndii mo fodde balɗe cappanɗe nay. O ɲaamaali hay fus e nder ɗen balɗe ɗon fow. Ɓawto ɗun o weelaa. ");
INSERT INTO fuf_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Onsay Ibuliisa wi'i mo: «Si tawii ko a *Ɓiɗɗo Alla, yamir ndee hayre yo nde wontu ɲaametee.» ");
INSERT INTO fuf_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Iisaa jaabii mo, wi'i: «No windii wondema: ‹Neɗɗo hinaa ɲaametee tun wuurirta.› » ");
INSERT INTO fuf_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Onsay Ibuliisa naɓi mo ka ɓuri toowude, o holli mo laamateeriiji aduna on fow yeru hinƴaango yiitere. ");
INSERT INTO fuf_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","O wi'i mo: «Mi jonnete laamu e hoore majji ɗi fow wondude e darja majji on, ɓay mi jonnanooma ɗi, awa-le mi okkay ɗi mo mi faalanaa woo. ");
INSERT INTO fuf_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Si tawii a sujjanii lan, ɗii fow wontante.» ");
INSERT INTO fuf_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Iisaa jaabii mo, wi'i: «No windii wondema: ‹Ko Alla Joomiraaɗo maa on sujjantaa, rewaa mo kanko tun.› » ");
INSERT INTO fuf_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ibuliisa nawri mo kadi Yerusalaam, joɗɗinoyi mo ka hoore warɲakere *juulirde mawnde, o wi'i mo: «Si tawii ko a Ɓiɗɗo Alla, hocco ɗon, cikkoɗaa ka leydi, ");
INSERT INTO fuf_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","ko fii no windii wondema: ‹O yamiray malaa'ikaaɓe makko ɓen fii maa, yo ɓe reene, ");
INSERT INTO fuf_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","awa kadi ɓe tamborte juuɗe maɓɓe ɗen fii wota koyngal maa ngal feggo e hayre.› » ");
INSERT INTO fuf_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Iisaa jaabii mo, wi'i: «No windii wondema: ‹Wota a ndarndo Joomiraaɗo on, on Alla maa.› » ");
INSERT INTO fuf_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ɓay Ibuliisa lannii mo ndarndaade e ɗii ɗoo fow, o pottitii mo haa o eɓɓa feere goo. ");
INSERT INTO fuf_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Iisaa yiltodi e bawgal Ruuhu Allaahu on ka diiwal Jaliilu. Fii makko andii e nokkeeli heeduɗi ɗon ɗin fow. ");
INSERT INTO fuf_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","O jannayno ka juulirɗe maɓɓe. Yimɓe ɓen fow manti mo. ");
INSERT INTO fuf_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","O yahi Naasirata ka o ne'aa ɗon. E *ɲalaande fowteteende nden, ɗun ko asewe, o naati ka juulirde wano o woowiri non. O immii fii jangugol. ");
INSERT INTO fuf_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","O jonnaa deftere annabi Isaaya nden, o udditi nde, o hawrondiri e cortewol ka ɗunɗoo windii: ");
INSERT INTO fuf_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«Ruuhu Joomiraaɗo on no e hoore an, sabu ko min woni Suɓaaɗo on fii feɲɲinangol miskinɓe ɓen Kibaaru Moƴƴo on. O nelii lan fii hollitugol nangaaɓe ɓen hettugol hoore mun, hollita bumɓe ɓen hettugol giiɗe mun ɗen, hollita njaggaaɓe ɓen kadi hettugol hoore mun, ");
INSERT INTO fuf_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","e fii humpitugol on ndee hitaande nde Joomiraaɗo on waɗi moƴƴere mun nden e mun.» ");
INSERT INTO fuf_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ontuma o ɲobbi deftere nden, o jonni nde wallitotooɗo on, o jottii. Tawi yimɓe ɓen fow ka nder juulirde no punnii mo. ");
INSERT INTO fuf_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Onsay o wi'i ɓe: «Oo daaluyee mo nanirɗon noppi mon ɗin laatike hande.» ");
INSERT INTO fuf_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Fow seeditanii mo, ŋalɗidi e ɗin konguɗi makko moƴƴi ɗi o yewtaynoo, hiɓe wi'a: «Wonaa ɓiɗɗo Yuusufu on nii?» ");
INSERT INTO fuf_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Iisaa wi'i ɓe: «Miɗo andi on wowlanay lan ngol tindol ɗoo: Ɲawndoowo, ɲawndu hoore maa tigi. Kala ko men nani waɗii Kafernahuum, waɗu ɗun kadi ka leydi maa ɗoo.» ");
INSERT INTO fuf_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","O wi'i ɓe kadi: «Mi wowlanay on haqiiqa, annabaajo hay e gooto teddinaaka ka leydi mun. ");
INSERT INTO fuf_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","E hino goonga ko mi woni on wowlande: E fewndo jamaanu Iiliiya, hari keynguuɓe buy no woodi e nder leydi Isra'iila. Ko fewndo onsay wonnoo duuɓi tati e lebbi jeegoo kammu ngun no uddii ndiyan ɗan toɓɓaali, heege tiiɗunge waɗi e leydi ndin fow, ");
INSERT INTO fuf_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","kono hari Iiliiya nulaaka e hay gooto e ɓen keynguuɓe, si hinaa e debbo keynguujo mo Sarfati, ɗun ko e nder leydi Siduuna. ");
INSERT INTO fuf_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Tawi kadi e fewndo jamaanu annabi Iliyaasa, ɓe ɗamajan buy no leydi Isra'iila, kono hari hay gooto e maɓɓe sellinaaka, si hinaa oo Siriyankeejo wi'eteeɗo Na'amaana.» ");
INSERT INTO fuf_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ɓay ɓe nanii ɗii konguɗi makko, wonnooɓe ka nder juulirde ɓen fow tikki. ");
INSERT INTO fuf_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ɓe immii, ɓe duɲiri mo ka ɓaawo saare, ɓe naɓi mo haa ka fello ngon ƴellitii ɗon fii bugagol mo ley. Tawi nden saare ko e falo ngon fello darnaa. ");
INSERT INTO fuf_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Kono o ukkitii hakkunde maɓɓe, o feƴƴi, o yahi. ");
INSERT INTO fuf_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Iisaa yahi Kafernahuum, nden saare ko jeyaande e diiwal Jaliilu, himo janna e ɲalaande fowteteende nden, ɗun ko aseweere nden. ");
INSERT INTO fuf_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ko o jannaynoo kon ŋalɗini jamaa on, sabu himo wowliraynoo bawgal. ");
INSERT INTO fuf_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Tawi no ka nder juulirde ton neɗɗo mo jinnawii bonngii nangi, on sonki, wi'i: ");
INSERT INTO fuf_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«Hey, ko honɗun faalanaɗaa men, an Iisaa oo jeyaaɗo Naasirata? Hara ko mulugol men aranɗaa? Min miɗo andi ko hombo wonu-maa, ko a *Seniiɗo mo Alla!» ");
INSERT INTO fuf_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Onsay Iisaa yamiri ngii, wi'i: «Fanku, yaltaa e oo neɗɗo!» Jinnawii ngin liɓi mo hakkunde maɓɓe, ngii yalti e makko, ngii barminaali mo. ");
INSERT INTO fuf_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Fow ŋalɗi, no wi'indira: «E ko honɗun woni ngol kongol? Oo no yamira jinnaaji bonɗi ɗin e hoore doole e bawgal, ɗi yalta!» ");
INSERT INTO fuf_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Kibaaru fii makko lolli e nokkeeli heeduɗi ɗon ɗin fow. ");
INSERT INTO fuf_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ɓay o iwii ka juulirde, o yahi ka galle Sim'uunu. Tawi esiraawo Sim'uunu suddiiɗo on no nawni nawnaare nguli-ɓandu tiiɗuki. Ɓe torii mo kanko Iisaa ballal. ");
INSERT INTO fuf_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","O ugginii e hoore makko, o yamiri nawnaare nden, nde yalti e makko. Ɗon kisan on immii, o woni e kurkanagol ɓe. ");
INSERT INTO fuf_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ɓay naange ngen mutii, kala marnooɓe ɲawɗo noone ɲaw fow, ɓe addi ɓe e makko. O *fawi juuɗe makko ɗen e hoore mo kala e maɓɓe, o sellini ɓe. ");
INSERT INTO fuf_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Tawi kadi jinnaaji no yaltude e buy e maɓɓe, hara hiɗi sonka, wi'a: «Ko an woni Ɓiɗɗo Alla on!» Kono o toŋani ɗi, o salii ɗi wowla, ɓay hari hiɗi andi ko kanko woni *Almasiihu on. ");
INSERT INTO fuf_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","No weetirnoo bimbi, Iisaa yalti yaari e nokkuure wulɗinnde. Jamaaji ɗin woni e ɗaɓɓitugol mo, ɓe ari haa e makko. Ɓe faalaa mo tongude ɗon, hara o accaali ɓe ɗon. ");
INSERT INTO fuf_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Kono o wi'i ɓe: «Bee mi feɲɲinana ɗeya ca'e kadi Kibaaru Moƴƴo on, ɗun ko kibaaru fii *laamu Alla ngun, sabu ko fii ɗun mi neliraa.» ");
INSERT INTO fuf_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Onsay o woni e waajagol ka juulirɗe diiwal Yahuuda. ");
INSERT INTO fuf_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ɲande goo, tawi Iisaa no e daande nduu *Weendu Jaani-Saarata. Tawi jamaa no duɲindira e fee makko fii heɗagol daaluyee Allaahu on. ");
INSERT INTO fuf_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","O haynii laakoy ɗiɗoy ka sera weendu, tawi yungooɓe ɓen no jippii fii lootugol *jalaaji maɓɓe ɗin. ");
INSERT INTO fuf_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","O ƴawi e gokkun e koy laakoy, ɗun hawrondiri e kun Sim'uunu kun, o yamiri onɗon woɗɗintingol ɓe pencen on seeɗa. Ontuma o jooɗii e nder makkun, o woni e jannugol jamaa on. ");
INSERT INTO fuf_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ɓay o gaynii jannude, o wi'i Sim'uunu: «Nawru laakun kun ka luggi ɗon, bugoɗon jalaaji mon ɗin, nangon liƴƴi.» ");
INSERT INTO fuf_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Sim'uunu jaabii mo: «Jom amen, oo jemma feƴƴuɗo ɗoo fow meɗen yungude, men heɓaali hay fus. Kono sabu ko maakuɗon kon, mi bugoto jalaaji ɗin.» ");
INSERT INTO fuf_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ɓay ɓe waɗii ɗun, ɓe nangi liƴƴi ɗuuɗuɗi, benii jalaaji maɓɓe ɗin fuɗɗii taƴude. ");
INSERT INTO fuf_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Onsay ɓe ɓaaƴi ɓeya wondiɓɓe maɓɓe wonɓe e kuma laakun fii ko ara wallitoo ɓe. Ɓen ari ɓe hebbini laakoy koy ɗiɗoy non, haa koy faalaa mutude. ");
INSERT INTO fuf_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ɓay Sim'uunu Petruusu yi'ii ɗun, o yani e ley koyɗe Iisaa, o wi'i: «Koohoojo an, woɗɗitee lan, sabu min ko mi junuubankeejo!» ");
INSERT INTO fuf_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ŋalaw heɓi mo, heɓidi mo e ɓe o wondunoo ɓen fow, sabu ngol nangugol ɗin liƴƴi. ");
INSERT INTO fuf_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ko wano non kadi Yaaquuba e Yuuhanna ɓee ɓiɓɓe Zabadii wondiɓɓe Sim'uunu ŋalɗirnoo. Onsay Iisaa wi'i Sim'uunu: «Wota a hulu, gila jooni a wonay yungoowo yimɓe.» ");
INSERT INTO fuf_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Onsay ɓe artiri laakoy koy ka pencen, ɓe acci fow ɗon, ɓe jokki mo. ");
INSERT INTO fuf_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Tawi Iisaa no e saare goo. Onsay mo ɗamajan heewi e ɓandu mun yi'i mo, ari yani yeeso makko. O jeeji mo, o wi'i: «Koohoojo, si hiɗon faalaa, hiɗon waawi lan sellinde, mi laaɓa!» ");
INSERT INTO fuf_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Iisaa fonti jungo mun ngon, meemi mo, wi'i: «Miɗo faalaa, laato selluɗo laaɓaa.» Ɗon kisan ɗamajan ɗan yalti e makko. ");
INSERT INTO fuf_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Onsay o wi'i mo: «Wota a wowlan ɗun hay gooto. Kono non a yahay hollitoyoɗaa *yottinoowo sadaka on, ittaa sadaka fii ko laɓɓinaɗaa kon wano Muusaa yamiri non fii yo ɗun wonan ɓe seedee.» ");
INSERT INTO fuf_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Kono tawi innde makko nden no ɓurtude lollude, jamaaji buy mooɓii fii jentagol mo e fii ɲawndegol ɲabbeeli maɓɓe, ");
INSERT INTO fuf_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","kono tawi Iisaa no woowunoo pottitaade ka weddii, toroo Alla. ");
INSERT INTO fuf_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ɲande goo tawi Iisaa no jannude. Hari *Fariisiyaaɓe e jannooɓe fii Sariya on no jooɗii ɗon, hiɓe iwri e koɗooli diiwal Jaliilu ngal fow e diiwal Yahuuda ngal e ka saare Yerusalaam. Tawi bawgal Joomiraaɗo on no wondi e makko no o ɲawndira. ");
INSERT INTO fuf_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Tawi kadi woɓɓe arii no rondii jukkuɗo e ɓoggi-dimborɗi. Hiɓe ɗaɓɓa fii no ɓe naadira mo ka nder suudu, ɓe wallina mo yeeso Iisaa. ");
INSERT INTO fuf_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ɓay ɓe heɓaali ka ɓe naadira mo sabu ɗuuɗugol jamaa on, ɓe ƴawdi e makko ka hoore suudu, ɓe tufi ton yolnde, ɓe tippindini mo e ɓoggi-dimborɗi ɗin e hakkunde jamaa on yeeso Iisaa. ");
INSERT INTO fuf_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ɓay Iisaa yi'ii gomɗinal maɓɓe ngal, o wi'i: «Musiɗɗo, junuubaaji maa ɗin yaafaama.» ");
INSERT INTO fuf_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Onsay Fariisiyaaɓe ɓen e jannooɓe fii Sariya on woni e wi'indirgol: «Ko hombo woni oo hoynoowo? Ko hombo waawi yaafaade junuubu ko wonaa Alla?» ");
INSERT INTO fuf_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Iisaa andi ɗin miijooji maɓɓe, o wi'i: «Ko honɗun miijantoɗon ɗun ka ɓerɗe mon? ");
INSERT INTO fuf_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Enee, hakkunde wi'ugol ‹junuubaaji maa ɗin yaafaama› e ‹immo yahaa›, ko honɗun e ɗii ɗoo ɓuri weeɓude?» ");
INSERT INTO fuf_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","O wi'i kadi: «Fii no andiron wonde *Ɓii-Aaden on no mari bawgal ka aduna ɗoo fii yaafagol junuubaaji», o wi'i jukkuɗo on: «Immo ƴettaa ɓoggi-dimborɗi maa ɗin, hootaa ka maa.» ");
INSERT INTO fuf_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","On immii ɗon kisan e tawnde maɓɓe, o ƴetti ɓoggi-dimborɗi makko ɗin, o hooti ka makko, himo manta Alla. ");
INSERT INTO fuf_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Kaawee heɓi ɓe fow, ɓe manti Alla, ɓe huli fota, hiɓe wi'a: «Hande men yi'ii huunde hawniinde!» ");
INSERT INTO fuf_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ɓawto ɗun, Iisaa yalti. Ko o yahata, o yi'i ƴantoowo sagalle wi'eteeɗo Lewi no jooɗii ka ƴantirde sagalle. O wi'i: «Aru jokkaa mi!» ");
INSERT INTO fuf_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lewi acci ɗon ko o joginoo kon fow, o immii, o jokki mo. ");
INSERT INTO fuf_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Lewi waɗani mo caatal mawngal ka mun, yimɓe buy ƴantooɓe sagalle wondude e yimɓe goo jooɗodi e maɓɓe. ");
INSERT INTO fuf_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Fariisiyaaɓe ɓen e jannooɓe fii Sariya on jeyaaɓe e fedde maɓɓe nden ŋuni taalibaaɓe Iisaa ɓen, ɓe wi'i ɓe: «E ko fii honɗun ɲaamidanton, yaridon e junuubankeeɓe ɓen e ƴantooɓe sagalle ɓen?» ");
INSERT INTO fuf_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Iisaa jaabii ɓe, wi'i: «Hinaa selluɓe ɓen hatonjini e ɲawndoowo, kono ko ɲawɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Min, wonaa noddugol feewuɓe ɓen mi arani, kono ko junuubankeeɓe ɓen fii yo ɓe tuubu.» ");
INSERT INTO fuf_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Onsay woɓɓe wi'i mo kanko Iisaa: «Taalibaaɓe Yaayaa ɓen e taalibaaɓe Fariisiyaaɓe ɓen kaɲun hooray, juula soono woo. An-le, ɓe maa ɓen no ɲaamude, yara!» ");
INSERT INTO fuf_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Iisaa jaabii ɓe wi'i: «Taw si on waaway hoorinde njaatigiiɓe jom jomba ɲande peera on, hara himo wondi e maɓɓe? ");
INSERT INTO fuf_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Aray e saa'i nde jom jomba pottinaa e hakkunde maɓɓe, onsay e ɗen balɗe ɗon ɓe hooray.» ");
INSERT INTO fuf_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","O haalani ɓe ngal misal ɗoo, o wi'i: «Hay gooto ƴettataa ceelol bagi keso, walkira dolokke kiɗɗo. Si hinaa ɗun, haray ontigi bonnii kesun ɗun, walkere nden kadi yaadataa e kiɗɗun ɗun. ");
INSERT INTO fuf_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Hay gooto loowataa njaram *wiiɲu kesan e nder bootooji guri kiɗɗi. Si hinaa ɗun, ɗan njaram kesan wonay sabu ko feeri ɗin guri, njaram ɗan hibba, bootooji guri ɗin kadi bona. ");
INSERT INTO fuf_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Kono njaram kesan ko e nder bootooji guri kesi loowetee. ");
INSERT INTO fuf_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Kala yaruɗo njaram kiɗɗan faaletaake njaram kesan, ko fii o wi'ay: ‹Ko kiɗɗan ɗan ɓuri welude.› » ");
INSERT INTO fuf_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","E aseweere goo, ɗun ko *ɲalaande fowteteende nden, hari Iisaa no rewude e gese ngawri, taalibaaɓe makko ɓen no woocora cawti ɗen gese, worsa ɗi, ɲaama. ");
INSERT INTO fuf_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Fariisiyaaɓe* goo wi'i: «Ko honɗun waɗanton koo ko dagaaki e ɲalaande fowteteende nden?» ");
INSERT INTO fuf_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Kono Iisaa jaabii ɓe, wi'i: «Hara on jangaali ko Daawuuda waɗunoo kon fewndo o weelaa, kanko e yimɓe wondunooɓe e makko ɓen? ");
INSERT INTO fuf_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","O naati ka nder suudu Alla, o ƴetti bireediije weeɓitaaɗe fii sadaka ɗen, o ɲaami ko daganinoo *yottinooɓe sadaka ɓen tun kon, o okkori kadi wonduɓe e makko ɓen.» ");
INSERT INTO fuf_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Onsay o wi'i: «Ko *Ɓii-Aaden on woni jom ɲalaande fowteteende nden.» ");
INSERT INTO fuf_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","E aseweere goo, Iisaa naati ka juulirde, o woni e jannugol. Tawi goɗɗo no nder ton mo jungo mun ɲaamo maayi. ");
INSERT INTO fuf_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Nde tawnoo jannooɓe fii Sariya on ɓen e Fariisiyaaɓe ɓen no faalaa heɓude ko ɓe lamitora, ɓe tooɲa Iisaa, tawi hiɓe ndaara si o ɲawnday e asewe, ɗun ko ɲalaande fowteteende nden. ");
INSERT INTO fuf_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Kono tawi Iisaa no andunoo ɗin miijooji maɓɓe. Onsay o wi'i maaya-jungoojo on: «Immo daroɗaa ka hakkunde ɗoo.» On immii, darii. ");
INSERT INTO fuf_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Onsay Iisaa wi'i ɓe: «Mi landike on, hara no dagii ka goɗɗo waɗa ko moƴƴi maa ko boni, danda wonkii maa wona sabu makki e aseweere?» ");
INSERT INTO fuf_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Onsay o ndaari ɓe fow, o wi'i on neɗɗo: «Fontu jungo maa ngon.» On fonti ngo, jungo makko ngon selli. ");
INSERT INTO fuf_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ɗun tikkini Fariisiyaaɓe ɓen e jannooɓe fii Sariya on ɓen fota, ɓe woni e yeddondirgol ko honɗun ɓe waɗata Iisaa. ");
INSERT INTO fuf_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","E nder ɗen balɗe ɗon, Iisaa yaari ka fello fii toragol Alla, o waali toraade. ");
INSERT INTO fuf_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ɓay weetii, o noddi taalibaaɓe makko ɓen, o suɓii sappoo e ɗiɗo e maɓɓe, o toɗɗii ɓe *sahaabaaɓe: ");
INSERT INTO fuf_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","ɗun ko Sim'uunu, on mo o jammi Petruusu, e Andaraawu neene-gooto Sim'uunu on, e Yaaquuba e Yuuhanna e Filiipu e Bartolomaawu ");
INSERT INTO fuf_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","e Matta e Tooma e Yaaquuba mo Alfaa e Sim'uunu tawdaaɗo e fedde *Zelotiiɓe ɓen, ");
INSERT INTO fuf_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","e Yahuuda mo Yaaquuba e Yudaasi Iskariiyu, janfoytooɗo mo on. ");
INSERT INTO fuf_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Iisaa jippodi e ɓen taalibaaɓe ɓe o suɓii, o darii e nokkuure ndeylere ka falo. Tawi taalibaaɓe makko ɗuuɗuɓe no e nden nokkuure, wondude e jamaa moolanaaɗo iwruɗo e cenɗe ɗen fow e diiwal Yahuuda ngal e saare Yerusalaam nden e ɗii baŋŋeeji Tiiri e Siduuna ka daande baharu. ");
INSERT INTO fuf_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ɓen ko arnooɓe heɗagol mo e fii ɲawndegol ɲabbeeli mun. Ɓe jinna tampinnoo ɓen sellinaa. ");
INSERT INTO fuf_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Awa kadi mo kala e maɓɓe no faalanoo mo meemude, ɓay himo wondunoo e bawgal ɲawndaynoongal ɓe fow. ");
INSERT INTO fuf_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","O ɓanti gite makko ɗen, o ndaari taalibaaɓe ɓen, o wi'i: «On malii yo onon miskinɓe, ɓay *laamu Alla ngun ko onon wonani. ");
INSERT INTO fuf_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","On malii yo onon weelaaɓe fewndo ɗoo, ɓay on harnoyte. On malii yo onon wullooɓe fewndo ɗoo, ɓay on weltoyto. ");
INSERT INTO fuf_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","On wonay malaaɓe nde yimɓe ɓen aɲi on e nde ɓe raɗii on, ɓe yenni on, ɓe ɲiddini inɗe mon ɗen sabu Ɓii-Aaden on. ");
INSERT INTO fuf_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Nden ɲande, weltee, jiɲon welo-welo, ɓay hiɗon maranaa njoddi mawndi ka kammu, ko fii ko nii kadi mawɓe maɓɓe ɓen warraynoo annabaaɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Kono bone wonanii on onon alɗuɓe ɓen, ɓay on hendike neweende ko mon kon! ");
INSERT INTO fuf_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Bone wonanii on onon ɓee haaruɓe jooni, ɓay on weeloyte. Bone wonanii on onon ɓee jalooɓe hande, ɓay on yoomoyay wullon. ");
INSERT INTO fuf_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Bone wonanii on nde yimɓe ɓen fow wowli on ko moƴƴi, ɓay ko non mawɓe maɓɓe ɓen wowliraynoo fii ɓee waɗitiiɓe annabaaɓe.» ");
INSERT INTO fuf_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","«Kono min mi wi'ay on yo onon ɓee heɗiiɓe lan: Yiɗee ayɓe mon ɓen, moƴƴoɗon e aɲuɓe on ɓen, ");
INSERT INTO fuf_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","du'anoɗon huɗooɓe on ɓen, toranoɗon tampinooɓe on ɓen. ");
INSERT INTO fuf_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Mo bantike ma e waɓɓugo, tuɗan mo ngoya kadi. Mo jattii ma waramba, wota a haɗu mo ƴettude fokiya on kadi. ");
INSERT INTO fuf_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Okkor kala toriiɗo ma, hara kadi a ƴantaali ko maa kon e juuɗe jattuɓe ma ɓen. ");
INSERT INTO fuf_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Waɗanee yimɓe ɓen wano faaliraɗon yo ɓe waɗan on non. ");
INSERT INTO fuf_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","«Si on yiɗii yiɗuɓe on ɓen, haray ko moƴƴere honde heɓoyton? Ko fii hay junuubankeeɓe ɓen no yiɗi yiɗuɓe ɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Si on moƴƴike e moƴƴiiɓe e mo'on ɓen, haray ko moƴƴere honde heɓoyton? Hay junuubanke'en ko non warrata. ");
INSERT INTO fuf_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Si on ɲawlii ɓe tanƴiniɗon yoɓitay on ɓen, haray ko moƴƴere honde heɓoyton? Hay junuubanke'en ɲawlindiray fii yo ɓe yoɓitindir. ");
INSERT INTO fuf_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Kono yiɗee ayɓe mon ɓen, waɗanon ɓe ko moƴƴi, ɲawlon ɓe hara on habbaaki yoɓiteede. Ɗun on heɓoyay njoddi mawndi, wonoyon kadi ɓiɓɓe Jom Ɓural on, sabu himo moƴƴani dulluɓe ɓen e bonɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Wonee yurmeteeɓe wano Baaba mon Jom Ɓural on woniri Yurmeteeɗo non.» ");
INSERT INTO fuf_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","«Wota on ɲaawu, ɗun on ɲaawetaake. Wota on felu, ɗun on feletaake. Yaafee, ɗun on yaafoyte. ");
INSERT INTO fuf_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Okkee, ɗun on okkorte. On etirante sariyaare yeɗɗunde, timmunde, yeƴaande haa juuri, waɗaneɗon ka jiifaaji mon. Ko fii ko sariyaare nde etirɗon nden etiranteɗon.» ");
INSERT INTO fuf_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","O wowlani ɓe ngal misal ɗoo, o wi'i: «Hara bunɗo no waawi ɗowude bunɗo? Hara ɓe ɗiɗoo non ɓe yanidaali e nder ngayka? ");
INSERT INTO fuf_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Taalibaajo ɓuraa karamoko mun. Kono kala taalibaajo eltiiɗo wa'ay wa karamoko mun. ");
INSERT INTO fuf_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","«Ko honno yiirataa lojol wongol ka yiitere musiɗɗo maa on, hara a yi'aali falimawal wongal ka yiitere maa ngal? ");
INSERT INTO fuf_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ko honno wawrataa wi'ude musiɗɗo maa: ‹Musiɗɗo, accu mi ittane lojol ngol ka yiitere maa›, hara an, a wattanaali yiila e falimawal wongal ka yiitere maa ngal? Ko an yo faasiqiijo, ittu taho falimawal wongal ka yiitere maa ngal, onsay non a yi'ay no ittiranaa musiɗɗo maa on lojol wongol ka yiitere makko ngol.» ");
INSERT INTO fuf_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","«Leggal moƴƴal rimataa ɓiɓɓe bonɓe, wano non kadi leggal bongal rimataa ɓiɓɓe moƴƴuɓe. ");
INSERT INTO fuf_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Leggal kala no anditiree ɓiɓɓe mun: ko fii on ittataa ƴibbe e bulle-koɲon, wano non kadi on ittataa sungala e bulle-bete. ");
INSERT INTO fuf_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Neɗɗo moƴƴo on yaltinay moƴƴere ka moƴƴuki ɓernde mun, neɗɗo bonɗo on kadi yaltina bonki ka bonki mun, ko fii ko ko heewi e ɓernde woo hunduko wowlata.» ");
INSERT INTO fuf_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","«Ko fii honɗun noddanton mi ‹Koohoojo, Koohoojo›, hara on waɗataa ko mi wi'i on kon? ");
INSERT INTO fuf_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Kala neɗɗo arɗo e an, nani waajuuji an ɗin huutori ɗi, mi hollay on no on wa'i. ");
INSERT INTO fuf_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","On no wa'i wa darnuɗo suudu. Hara o jasu gaawol luggungol haa e fetere, o fuɗɗii ɗon mahude. Nde waamere nden waɗi, ndiyan ɗan ari e suudu ndun, ɗan waawataa ndu dillinde, ko fii daroodi mayru on no tiiɗi. ");
INSERT INTO fuf_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Kono kala nanuɗo konguɗi an ɗin, huutoraali ɗi, on no wa'i wa darnuɗo suudu ndu jasanaaka gaawol. Ilol ndiyan ɗan hawri e mayru tun, ndu yani kisan, fii mayru on mula few.» ");
INSERT INTO fuf_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ɓay o gaynii waajaade jamaa heɗitiiɗo mo on, o naati Kafernahuum. ");
INSERT INTO fuf_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Tawi hooreejo suufaaɓe teemedere no mari kurkaadu ndu o yiɗunoo, hari ndun no nawni haa moggo mayde. ");
INSERT INTO fuf_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ɓay o nanii fii Iisaa, o nuli mawɓe *Yahuudiyankeeɓe goo e makko fii toragol mo arugol ɲawndana mo ndun kurkaadu makko. ");
INSERT INTO fuf_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ɓay ɓe arii ɓe tawii Iisaa, ɓe jeeji mo ɓe multi, ɓe wi'i: «Himo handi e waɗaneede ɗun, ");
INSERT INTO fuf_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ko fii himo yiɗi leɲol men ngol, awa-le kadi ko kanko darni juulirde amen nden.» ");
INSERT INTO fuf_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Iisaa yaadi e maɓɓe. Ɓay o ɓattike suudu hooreejo suufaaɓe ɓen, on suufaajo nuli yiɓɓe mun goo e Iisaa ko wi'a mo: «Koohoojo, wota on tampintino, sabu mi foddaa e mo'on ka suudu an. ");
INSERT INTO fuf_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ko ɗun waɗi si min tigi mi foddaa e arugol haa ka mon. Kono maakee tun kongol gootol, kurkaadu an ndun ndikkay. ");
INSERT INTO fuf_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ko fii min tigi ko mi wonɗo e ley kongol hooreeɓe goo, min kadi miɗo mari suufaaɓe wonɓe e ley kongol an. Si mi wi'ii goɗɗo e ɓen ‹yahu›, o yahay. Si mi wi'ii oya on ‹aru›, o aray. Awa kadi si mi wi'ii kurkaadu an ndun ‹waɗu ɗun›, ndu waɗay.» ");
INSERT INTO fuf_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ɓay Iisaa nanii ɗin konguɗi makko, o ŋalɗi, o fewti e jamaa jokkuɗo mo on, o wi'i ɓe: «Mi andinii on, hay ka *Isra'iila'en mi yi'aali neɗɗo gomɗinirɗo wa oo.» ");
INSERT INTO fuf_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ɓay nulanooɓe ɓen yiltitike ka suudu, ɓe tawti kurkaadu nawnunoondu ndun ndikkii. ");
INSERT INTO fuf_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","E nder ɗen balɗe ɗon, Iisaa yahi e saare wi'eteende Naa'ina, taalibaaɓe makko ɓen wondude e jamaa ɗuuɗuɗo yaadi e makko. ");
INSERT INTO fuf_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ko o hewtaynoo ka naatirgal saare, o fotti e rondiiɓe furee, hari on furee ko ɓiɗɗo bajjo ka neene mun, tawi kadi neene makko ko keynguujo. Tawi jamaa ɗuuɗuɗo e nden saare no wondi e on debbo. ");
INSERT INTO fuf_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ɓay Koohoojo on yi'ii on keynguujo, o yurmaa mo, o wi'i mo: «Wota a wullu!» ");
INSERT INTO fuf_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","O ɓadii furee on, o *fawi jungo makko ngon e hoore goyki kin, rondiiɓe furee on dartii, o wi'i: «Suka, mi yamirii ma yo a immo!» ");
INSERT INTO fuf_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Onsay mayɗo on immii jooɗii, o fuɗɗii yewtude. Iisaa jonniti mo yumma makko. ");
INSERT INTO fuf_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ɓe fow ɓe huli, ɓe manti Alla, ɓe wi'i: «Annabaajo kelɗuɗo feeɲii e fewndo men. Allaahu on arii faabagol yimɓe mun ɓen!» ");
INSERT INTO fuf_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Fii ngal kuugal makko lolli e diiwal Yahuuda ngal haa e baŋŋeeji heeduɗi ɗon ɗin fow. ");
INSERT INTO fuf_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Taalibaaɓe Yaayaa ɓen humpiti mo kanko Yaayaa kon ko waɗi fow. ");
INSERT INTO fuf_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Yaayaa noddi ɗiɗo e taalibaaɓe mun ɓen, o immini ɓe e Koohoojo on yo ɓe lando mo: «Taw si ko onon woni haanuɗo arude on, kaa hara yo men habbo goɗɗo goo?» ");
INSERT INTO fuf_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ɓay ɓen imminaaɓe hewtii, ɓe wi'i Iisaa: «Ko Yaayaa *lootoowo maande tuubuubuyee on immini men haa e mon fii landagol on si ko onon woni haanuɗo arude on, kaa hara yo men habbo goɗɗo goo?» ");
INSERT INTO fuf_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ko e on saa'i mo ɓe hewti e mun tigi, Iisaa sellini ɲawɓe e jukkuɓe buy e jinnaaɓe, o wuntini kadi bumɓe buy. ");
INSERT INTO fuf_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ontuma o jaabii ɓen ɓe Yaayaa immini, o wi'i ɓe: «Yahee fillitanoɗon Yaayaa ko yi'uɗon kon e ko nanuɗon kon wonde, bumɓe ɓen yi'ii, boofooɓe ɓen yahii, ɓe ɗamajan ɓen sellinaama, ɓe laaɓii, pahiɗuɓe ɓen nanii, mayɓe no immintineede, Kibaaru Moƴƴo on no feɲɲinaneede miskinɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Kala mo feggaaki e an ko malaaɗo. ");
INSERT INTO fuf_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ɓay ɓen ɓe Yaayaa nelunoo yiltitike, onsay Iisaa fuɗɗii yewtude jamaa on fii Yaayaa, o landii ɓe ɗunɗoo, o wi'i: «Ko honɗun yahunoɗon ndaaroygol ka wulaa? Hara ko kuɗol ngol hendu ndun dimbata? ");
INSERT INTO fuf_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Kaa ko honɗun yahunoɗon ndaarugol? Ko neɗɗo ɓorniiɗo conci dimi? Ndaaree ɓee ɓorniiɓe conci dimi, wuuruɓe ngurndan moƴƴan no e nder galleeji laamu. ");
INSERT INTO fuf_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ko honɗun non yahunoɗon ndaarugol? Ko annabaajo? Hiiyii, min mi wi'ay on, ko ko ɓuri annabaajo. ");
INSERT INTO fuf_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ko oo ɗoo woni mo fii mun windii on: ‹Awa, miɗo imminde nulaaɗo an on yeeso maa, fii ko fertano-maa laawol maa ngol.› ");
INSERT INTO fuf_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","«Mi andinii on, alaa mo suddiiɗo jibini ɓurɗo Yaayaa. Kono non ɓurɗo fanɗude on ka laamateeri Alla no ɓuri mo teddude.» ");
INSERT INTO fuf_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","(Jamaa heɗinooɗo mo on e ƴantooɓe sagalle ɓen jaɓi laawol Alla feewungol ngol e nder ko ɓe lootanoo maande tuubuubuyee ko Yaayaa lootaynoo kon. ");
INSERT INTO fuf_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Kono Fariisiyaaɓe ɓen e waawuɓe fii Sariya ɓen bugitii ko Allaahu on eɓɓannoo ɓe kon, ɓe salii Yaayaa loota ɓe maande tuubuubuyee.) ");
INSERT INTO fuf_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","«Hara ko e honɗun mi eɓɓindirta ɓee yimɓe nguu jamaanu? E ko honɗun ɓe nandi? ");
INSERT INTO fuf_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Hiɓe nandi e fayɓe jooɗiiɓe e kubitirde, hara ɓen no noddindira, wi'a: ‹Men wuttanii on ceri, on amaali, men yimanii on gimɗi yurmuɗi, on wullaali!› ");
INSERT INTO fuf_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","«Ko fii Yaayaa lootoowo maande tuubuubuyee on arno, o ɲaamataano ko defaa, o yarataano ko mandilinta, wi'uɗon: ‹On ko mo jinna!› ");
INSERT INTO fuf_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ɓii-Aaden* on kadi arii no ɲaama no yara, wi'uɗon: ‹On ko reereɗuɗo, yaroowo, welduɗo e ƴantooɓe sagalle e junuubanke'en!› ");
INSERT INTO fuf_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Kono jaɓuɓe faamu Allaahu on ɓen hollay wonde ko ngu feewungu.» ");
INSERT INTO fuf_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Fariisiyaajo goo wi'eteeɗo Sim'uunu torii Iisaa hawtidugol e makko. Iisaa naati ka suudu Fariisiyaajo on, o toolii fii nafagol. ");
INSERT INTO fuf_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Tawi debbo junuubankeejo no e nden saare, on humpitii Iisaa no nafaade ka suudu Fariisiyaajo on. O ardi e tindohun hayre daneere tew angiri, ");
INSERT INTO fuf_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","o wontiri ɓaawo Iisaa, o ugginii ka hoore koyɗe makko, o wulli haa gonɗi makko ɗin ɓuɓɓini koyɗe Iisaa ɗen. Ontuma debbo on fittiri ɗe sukundu mun ndun, o lunnii ɗe, o wuji ɗe angiri. ");
INSERT INTO fuf_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ɓay Fariisiyaajo noddunooɗo Iisaa on yi'ii ɗun, o wi'i e ɓernde makko: «Si tawno oo ko annabaajo, o andayno ko hombo woni oo debbo meemuɗo mo e ko honno on sifori, sabu oo ko junuubankeejo!» ");
INSERT INTO fuf_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Iisaa ƴetti haala kan, wi'i: «Sim'uunu, no woodi ko mi haalanay-maa.» On jaabii: «Maakee yo karamoko'en.» ");
INSERT INTO fuf_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","O wi'i: «Goɗɗo no ɲawlunoo yimɓe ɗiɗo. Gooto on no joganii mo *dinaruuji teemeɗɗe jowi, oya on ko *dinaruuji cappanɗe jowi. ");
INSERT INTO fuf_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ɓay ɓen heɓaali ko yoɓitira mo, o yaafanii ɓe ɗiɗoo non ko ɓe ɲawlii mo kon. Ko hombo e ɓen ɗiɗo ɓurata mo yiɗude?» ");
INSERT INTO fuf_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Sim'uunu jaabii: «Haray ko ɓurɗo ɲamaande tiiɗunde on.» Onsay Iisaa wi'i mo: «A ɲaawirii no moƴƴiri.» ");
INSERT INTO fuf_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","O fewti e debbo on, o wi'i Sim'uunu: «A yi'ii oo debbo? An, mi naatii ka suudu maa, a okkoraali lan ndiyan ko mi sembora, kono oo ɗoo ɓuɓɓinirii koyɗe an ɗen gonɗi mun ɗin, o fittirii ɗe sukundu makko ndun. ");
INSERT INTO fuf_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","A hirbanooki lan lunniɗaa, kono kanko gila mi naati ɗoo, himo lunnaade lan koyɗe ɗen. ");
INSERT INTO fuf_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","A waɗaali nebban ka hoore an, kono kanko o waɗii angiri ka koyɗe an. ");
INSERT INTO fuf_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Awa mi andinii ma, junuubaaji makko e ɗuuɗude yaafaama, ko ɗun waɗi si giggol makko ngol no tiiɗi. Kono mo yaafaama seeɗa, ko seeɗa yiɗata.» ");
INSERT INTO fuf_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Onsay o wi'i debbo on: «Junuubaaji maa ɗin yaafaama.» ");
INSERT INTO fuf_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Onsay ɲaamidaynooɓe e makko ɓen miijii e ɓerɗe mun: «Ko hombo woni oo neɗɗo yaafotooɗo hay junuubaaji?» ");
INSERT INTO fuf_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ontuma o wi'i debbo on: «Gomɗinal maa ngal dandii ma. Yahu e hoore ɓuttu.» ");
INSERT INTO fuf_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ɓawto ɗun, Iisaa yahayno gila e saare heɓi e saare, gila e hoɗo haa e koɗolun wondude e *sahaabaaɓe makko ɓen sappoo e ɗiɗo, hara himo waajoo feɲɲina Kibaaru Moƴƴo *laamu Alla ngun. ");
INSERT INTO fuf_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Himo wondunoo kadi e rewɓe goo ɲawndaaɓe jinnaaji bonɗi e ɲabbeeli, wano Mariyama oo jammaaɗo Mariyama Magaduuna, mo jinnaaji jeeɗiɗi yaltinaa e mun, ");
INSERT INTO fuf_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","e Yuuwanna on ko sonnaajo Kuusa oo mbatulaajo *Heroodu, e Suusanatu, e woɓɓe goo wallitoraynooɓe ɓe keyeeji mun. ");
INSERT INTO fuf_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Jamaa njano mooɓii, yimɓe buy iwri e ca'e heewuɗe, ari e makko. O waɗani ɓe ngal misal ɗoo: ");
INSERT INTO fuf_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«Ko remoowo yaltunoo sankugol awdi mun ndin. E nder ko o sankata kon, gabbe goo yani ka ɗatal, feƴƴooɓe ɓen yaaɓi, colli ɗin kadi moɗi ɗe. ");
INSERT INTO fuf_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Goɗɗe ɗen yani e hoore fetere, no ɗe fuɗirnoo, ɗe yoori, ɓay ɗe alaa e ɓuuɓol. ");
INSERT INTO fuf_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Goɗɗe goo kadi yani ka sooƴoore, ɗe fuɗidi e mayre, sooƴoore nden moɗi ɗe. ");
INSERT INTO fuf_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Goɗɗe goo yani ka leydi moƴƴiri. Ɗe fuɗi, ɗe rimi cawti ɗi gabbe teemedere.» Wa fewndo ko o yewtaynoo ɗun, o ewnii, o wi'i: «Mo no mari noppi nanirɗi yo nanu!» ");
INSERT INTO fuf_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Onsay taalibaaɓe makko ɓen landii mo ko ngal misal ɗoo firi. ");
INSERT INTO fuf_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","O jaabii ɓe: «Onon on yeɗaama andugol gundooji laamu Alla ngun. Kono ɓeya luttuɓe, ɗun wowlirante ɓe mise, fii yo ɓe ndaaru, hara ɓe yi'ataa, yo ɓe nanu, hara ɓe faamataa. ");
INSERT INTO fuf_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","«E hino ko ngal misal firi: Awdi ndin ko daalol Alla ngol. ");
INSERT INTO fuf_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Nde awdi sankaandi ndin saami ka ɗatal, ɗun no wa'i wa nde woɓɓe nani daalol ngol, kono Ibuliisa ara itta ngol e ɓerɗe maɓɓe fii wota ɓe gomɗin sakko ɓe dandee. ");
INSERT INTO fuf_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Nde awdi sankaandi ndin saami ka fetere, ɗun no wa'i wa nde woɓɓe nani daalol ngol, ɓe jaɓira ngol weltaare. Kono ɓe alaa ɗaɗi. Ɓe gomɗinay haa e saa'i, kono si ɓe ndarndaama, ɓe tertoo. ");
INSERT INTO fuf_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Nde awdi sankaandi ndin saami ka sooƴoore, ɗun no wa'i wa nde woɓɓe nani daalol ngol, kono hara ɓe moɗiraama anndeeji aduna e jawle aduna e faaleeji ngurndan aduna e nder yaadu maɓɓe ndun, ɓe ronka rimude moƴƴa. ");
INSERT INTO fuf_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Nde awdi sankaandi ndin saami ka leydi moƴƴiri, ɗun no wa'i wa nde woɓɓe naniri daaluyee on ɓernde laaɓunde moƴƴunde, jogitoo mara. Ko ɓen woni rimooɓe e nder wakkilaare. ");
INSERT INTO fuf_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","«Hay gooto huɓɓintaa lampu buuma mo maa sorna mo e ley danki. Kono o joɗɗinay mo e kene fii no naatooɓe ɓen yi'ira ndaygu ngun. ");
INSERT INTO fuf_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ko fii alaa ko suuɗii ko feeɲataa, kala gundoo ko sakkitorta ko feeɲoygol. ");
INSERT INTO fuf_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Awa wattanee yiila e no heɗorton non, ko fii ko marɗo ɓeydantee, kono mo maraa on jaɓitante hay ko o sikki himo mari kon.» ");
INSERT INTO fuf_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Yumma Iisaa e yumma-gootooɓe makko ɓen ari, kono ɓe waawaali tumbondirde e makko hakkee yimɓe. ");
INSERT INTO fuf_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","O humpitaa wonde: «Yumma mon e yumma-gootooɓe mon ɓen no darii ka yaasi, hiɓe faalaa yiidude e mon. ");
INSERT INTO fuf_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Kono o jaabii ɓe, o wi'i: «Yumma an e yumma-gootooɓe an ɓen ko heɗotooɓe daaluyee Alla on, ɲinna mo.» ");
INSERT INTO fuf_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ɲande goo Iisaa bakii e laakun wondude e taalibaaɓe mun ɓen. O wi'i ɓe: «Lumbiten ka gaɗa weendu.» Ɓe yahi. ");
INSERT INTO fuf_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","E nder ko ɓe lumbata kon, Iisaa ɗaanii. Waabiliire tiiɗunde wondunde e hendu tippii ka weendu, laakun kun fuɗɗii heewude ndiyan, ɗun wonani ɓe nawaare hulɓiniinde. ");
INSERT INTO fuf_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ɓe ari, ɓe findini mo, ɓe wi'i: «Karamoko'en, Karamoko'en, en mulay woni!» O immii, o toŋani hendu ndun e morlooɗe ndiyan ɗen, ɗe deeƴiti, onsay ɓuttu waɗi. ");
INSERT INTO fuf_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ontuma o wi'i ɓe: «Ko honto gomɗinal mon ngal woni?» Ɓe huli, ɓe ŋalɗi, hiɓe wi'indira: «Ko hombo woni oo neɗɗo yamiroowo hay hendu ndun e ndiyan ɗan, ɗun ɗoftoo mo?» ");
INSERT INTO fuf_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ɓe hewtoyi e ndii leydi ɓee Gadariyankooɓe tiindondirndi e ngal diiwal Jaliilu. ");
INSERT INTO fuf_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ɓay Iisaa jippike ka leydi, neɗɗo jeyaaɗo e nden saare mo jinnaaji buy nangi, ari e makko. Tawi gila neeɓii o ɓornotaako conci, o naatataa e suudu, ko ka hakkunde genaale o hoɗunoo. ");
INSERT INTO fuf_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","No o yiirunoo Iisaa, o sonki, o yani e ley koyɗe makko, o ewnii, himo wi'a: «Ko honɗun faalanaɗaa lan an Iisaa *Ɓiɗɗo Alla Jom Ɓural on? Mi torike ma wota a lettan!» ");
INSERT INTO fuf_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ngii jinnawii bonngii wi'i ɗun sabu ko Iisaa yamiraynoo ngin yaltugol e oo neɗɗo kon. Tawi ngin jinnawii nangayno mo soono woo, o dumbee juuɗe e koyɗe fii aynugol mo, kono o bonnayno ɗen jolokooje fow, onsay jinnawii ngin nawra mo ka wulaaji. ");
INSERT INTO fuf_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Onsay Iisaa landii mo: «Ko honno inneteɗaa?» Tawde hari jinnaaji buy no e makko, o jaabii: «Ko Konu.» ");
INSERT INTO fuf_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Awa kadi hiɗi jeejaynoo Iisaa fii wota o yamir ɗi yahugol ka *gaygii ngin alaa kattudi ngin. ");
INSERT INTO fuf_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Tawi wuro kose moolanaango no ooraynoo ka falo. Onsay jinnaaji ɗin jeeji Iisaa yo o accu ɗi naata e ɗin koseeji. O newnani ɗi ɗun. ");
INSERT INTO fuf_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Jinnaaji ɗin yalti e on neɗɗo, ɗi naati e nder ɗin koseeji. Onsay koseeji ɗin giddi ka falo, ɗi unoyii ka weendu, ɗi yoolii. ");
INSERT INTO fuf_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ɓay ornaynooɓe ɗi ɓen yi'ii ɗun, ɓe dogi, ɓe fillitoyii ɗun ka saare e ka fulawaaji. ");
INSERT INTO fuf_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Onsay yimɓe ɓen ari yi'ugol kon ko waɗi. Ɓe ari e Iisaa, ɓe tawi on neɗɗo mo jinnaaji ɗin yalti e mun no jooɗii ka ley koyɗe Iisaa, himo ɓornii, himo wondi e hakkille timmuɗe, ɓe huli. ");
INSERT INTO fuf_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Yi'unooɓe ko waɗi kon fillitanii ɓe no jinnanooɗo on selliniraa. ");
INSERT INTO fuf_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Onsay jeyaaɓe e diiwal Gadariyankooɓe ɓen fow torii mo yaltugol ka maɓɓe sabu kulol ngol ɓe heɓi ɗon ngol. Ontuma Iisaa bakii ka laakun yiltitii. ");
INSERT INTO fuf_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Onsay neɗɗo mo jinnaaji ɗin yaltinaa e mun on torii Iisaa wondugol e makko. Kono Iisaa yilti mo, o wi'i mo: ");
INSERT INTO fuf_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","«Hootu ka mon, fillitoyoɗaa ko Alla waɗan-maa kon.» Onsay o yahi, o ukkii ka saare, o fillitii kala ko Iisaa waɗani mo kon. ");
INSERT INTO fuf_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ɓay Iisaa lumbitii, jamaa on jaɓɓii mo, ko fii hari fow no sabbii mo. ");
INSERT INTO fuf_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Tun oo hooreejo juulirde maɓɓe wi'eteeɗo Yaayirusu ari e makko. Onsay o yani e ley koyɗe Iisaa, o torii mo hewtugol ka suudu makko, ");
INSERT INTO fuf_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ɓay tawi jiwo makko bajjo mo wa duuɓi sappoo e ɗiɗi no e daande mayde. Wa fewndo kanko Iisaa o yahata ka oo neɗɗo, tawi jamaa on no ɓittiri mo cenɗe ɗen fow. ");
INSERT INTO fuf_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Tawi kadi debbo no e nden nokkuure, heɓii duuɓi sappoo e ɗiɗi, himo soncaade. Awa kadi o ittii jawle makko fow o yoɓii ɲawndooɓe ɓen, kono hay gooto e maɓɓe waawaali mo sellinde. ");
INSERT INTO fuf_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","On debbo wontiri ɓaawo Iisaa. No o meemirnoo kombol dolokke makko on, ko o soncotonoo kon taƴi. ");
INSERT INTO fuf_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Onsay Iisaa wi'i: «Ko hombo meemimmi?» Tun mo kala wi'i wonaa kaɲun. Onsay Petruusu wi'i: «Karamoko'en, jamaa on no hundi on, awa kadi hiɓe hiɓɓii on!» ");
INSERT INTO fuf_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Kono Iisaa jaabii, o wi'i: «Goɗɗo meemii lan, ko fii mi andii wonde bawgal an ngal gollii goɗɗun.» ");
INSERT INTO fuf_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Nde debbo on tawnoo ko o waɗi kon pulfitike, o ari himo diwna, o yani e ley koyɗe Iisaa, o furɲiti yeeso jamaa on fow ko fii honɗun o meemani mo e ko honno kadi o selliniraa ɗon kisan. ");
INSERT INTO fuf_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Onsay Iisaa wi'i mo: «Jiwo an, gomɗinal maa ngal sellinii ma. Yahu e hoore ɓuttu.» ");
INSERT INTO fuf_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Wa fewndo ko Iisaa yewtata ɗun, gorko jeyaaɗo ka hooreejo juulirde nden ari, wi'i mo: «Jiwo maa on maayii. Hay tertiɗaa sonjugol oo karamokoojo.» ");
INSERT INTO fuf_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Kono ɓay Iisaa nanii ɗun, o wi'i hooreejo juulirde nden: «Wota a hulu, gomɗin tun, jiwo maa on hisay.» ");
INSERT INTO fuf_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ɓay Iisaa hewtii ka hooreejo juulirde nden, o jaɓaano naatidude hay e gooto ka suudu si hinaa Petruusu e Yaaquuba e Yuuhanna wondude e yumma jiwo on e ben jiwo on. ");
INSERT INTO fuf_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Tawi fow no wulla fesa fii on jiwo. Onsay Iisaa wi'i: «Wota on wullu mo, ko fii o maayaali, o ɗaani.» ");
INSERT INTO fuf_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Onsay ɓe jali mo, ko fii hiɓe andi jiwo on maayii. ");
INSERT INTO fuf_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Onsay Iisaa nangi jungo jiwo on, o ewnii, o wi'i: «Jiwo, immo!» ");
INSERT INTO fuf_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Tun wonkii jiwo on arti, o immii ɗon kisan. Onsay Iisaa yamiri ɓe okkorgol mo ɲaametee. ");
INSERT INTO fuf_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Kaawee heɓi mawɓe jiwo on. Kono o yamiri ɓe wota ɓe wowlan hay gooto kon ko waɗi ɗon. ");
INSERT INTO fuf_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","O noddi ɓe o suɓunoo ɓen sappoo e ɗiɗo, o okki ɓe bawgal e doole e hoore jinnaaji ɗin fow e fii sellingol ɲabbeeli. ");
INSERT INTO fuf_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","O immini ɓe waajoyagol fii *laamu Alla ngun e sellingol ɲawɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","O wi'i ɓe: «Wota on yooɓo hay huunde e nder yaadu mon ndun, gila e tuggordu maa bonfo maa ɲaametee goo haa naɓani e kaalisi. Awa kadi wota on yooɓo dolokkaaji ɗiɗi.» ");
INSERT INTO fuf_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","O wi'i ɓe kadi: «Kala suudu ka naatoyɗon, weeree ɗon haa tuma fokkituɗon woo, ");
INSERT INTO fuf_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","e kala saare nde yimɓe ɓen jaɓaali on e mun, nde hiɗon yalta ɗon woo, honkee mbullaari teppe mon ɗen fii yo ɗun wonan ɓe seedee ella maɓɓe on.» ");
INSERT INTO fuf_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Onsay ɓe yahi koɗolun e koɗolii, hiɓe waajoo fii Kibaaru Moƴƴo on e kadi hiɓe sellina hen fow ɲawɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Heroodu* lanɗo diiwal Jaliilu ngal humpitii fii ko woni waɗude kon, ɗun jiiɓi mo ɓernde, sabu hari woɓɓe no wi'a ko Yaayaa immintinaa e hakkunde mayɓe ɓen, ");
INSERT INTO fuf_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","woɓɓe ɓen no wi'a wondema ko Iiliiya feeɲiti, woɓɓe goo no wi'a wondema ko goɗɗo e annabaaɓe hiɓɓe ɓen immitii. ");
INSERT INTO fuf_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Kono Heroodu wi'i: «Mi taƴiino daande Yaayaa nden, e hara ko hombo woni oo mo mi nanata fii mun nii?» Gila ɗun himo etoo no o yi'ira mo. ");
INSERT INTO fuf_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ɓay ɓen *sahaabaaɓe ɓe o imminnoo hewtitii, ɓe sifanii mo kanko Iisaa ko ɓe waɗoyi kon fow. Onsay o yaadi e maɓɓe haa e takko ndee saare Bayti-Sa'iida, ɓe bakitii ɗon. ");
INSERT INTO fuf_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","No yimɓe ɓen humpitornoo ɗun, ɓe jokki mo. Onsay Iisaa tolni ɓe, o yewti ɓe fii laamu Alla ngun, o ɲawndi kadi ɓen hatonjinɓe e ɲawndeede. ");
INSERT INTO fuf_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Tawi ɲallal ngal woɗɗike. Onsay sappoo e ɗiɗooɓe ɓen ari e makko, ɓe wi'i mo: «Accitee non jamaa on, ɓe yaha ka koɗooli e ka fulawaaji kawtirɗi e ɗoo, ɓe ɗaɓɓoya ko ɓe ɲaama e ka ɓe waaloo, ko fii ko e nokkuure wulɗinnde wonɗen ɗoo.» ");
INSERT INTO fuf_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Onsay Iisaa wi'i ɓe: «Onon tigi okkoree ɓe ko ɓe ɲaama.» Kono ɓe jaabii, ɓe wi'i: «Ko bireediije jowi e liƴƴi ɗiɗi pet men mari ɗoo, si hinaa hara menen tigi men yahay men soodoya ko oo jamaa ɗoo fow ɲaama!» ");
INSERT INTO fuf_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Tawi worɓe wonɓe ɗon ɓen tun ko wa ɓe guluuje njowo. Onsay Iisaa yamiri taalibaaɓe mun ɓen, wi'i: «Joɗɗiniree ɓe mojobe mojobe, mojobere kala cappanɗe njowo.» ");
INSERT INTO fuf_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ɓe joɗɗiniri ɓe no o wi'iri ɓe non. ");
INSERT INTO fuf_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Onsay Iisaa ƴetti bireediije ɗen jowi e liƴƴi ɗin ɗiɗi, o ɓanti gite makko ɗen, o fewti ka kammu, o du'ii. Ontuma o taƴiti ɗe, o woni e jonnugol taalibaaɓe makko ɓen fii yo ɓen hewtin jamaa on. ");
INSERT INTO fuf_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Fow ɲaami haa haari. Ɓe mooɓiti debeeje sappoo e ɗiɗi kunte ko lutti. ");
INSERT INTO fuf_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ɲande goo tawi Iisaa no wondi e taalibaaɓe mun ɓen ka wirnii, himo toraade Alla. Ontuma o landii ɓe ɗunɗoo, o wi'i: «E wi'i jamaa on, ko hombo woni lan min?» ");
INSERT INTO fuf_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ɓe jaabii mo, ɓe wi'i: «Woɓɓe no wi'a ko onon woni Yaayaa lootaynooɗo on, woɓɓe kadi no wi'a ko onon woni Iiliiya, woɓɓe goo kadi no wi'a ko on annabaajo kiɗɗo goo immintinaa.» ");
INSERT INTO fuf_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Onsay o landii ɓe, o wi'i: «Onon non wi'uɗon ko hombo woni lan min?» Petruusu jaabii mo, wi'i: «Ko onon woni *Almasiihu Alla on.» ");
INSERT INTO fuf_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Iisaa yamiri ɓe, tentini, wota ɓe wowlan ɗun hay gooto. ");
INSERT INTO fuf_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","O ɓeyditi e ɗun, o wi'i: «Maa *Ɓii-Aaden on tampa fota, mawɓe ɓen e hooreeɓe *yottinooɓe sadaka ɓen e jannooɓe fii Sariya on ɓen fow wikkoo mo, o waree, o immintinoyee ka ɲalaande tammere.» ");
INSERT INTO fuf_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Onsay o wi'i ɓe fow wonde: «Kala faalaaɗo jokkude lan, yo o hayfintino, o ƴetta ɲande woo ɲande *leggal makko altindiraangal ngal, o jokkammi. ");
INSERT INTO fuf_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Kala faalaaɗo dandude ngurndan mun, ɗan hayriray mo, kono kala non mo ngurndan mun hayriraa sabu an min, haray ontigi dandoyay ɗan. ");
INSERT INTO fuf_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","E ko nafa honɗun woodani neɗɗo heɓugol aduna on fow si o hayrintinike maa si o halkitike kanko tigi? ");
INSERT INTO fuf_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Awa kadi, kala hersirɗo lan, hersiri konguɗi an ɗin, Ɓii-Aaden on kadi hersiroyay mo tuma o ardoyi e mangural makko ngal e mangural Baabaajo on wondude e malaa'ikaaɓe laaɓuɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Miɗo wowlande on goonga, no woodi woɓɓe e mon onon wonɓe ɗoo ɓen, ɓe maayataa ado ɓe yi'ude laamu Alla ngun.» ");
INSERT INTO fuf_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ɓay wa balɗe jeetati feƴƴii ɓawto yewtugol mo ɓe ɗin konguɗi, onsay o noddi Petruusu e Yuuhanna e Yaaquuba, ɓe yahi ka fello fii toragol Alla. ");
INSERT INTO fuf_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Fewndo ko o torotoo, mbaadi yeeso makko ngon waylii, dolokke makko on wonti daneejo jalbuɗo. ");
INSERT INTO fuf_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","E nder ɗun, yimɓe ɗiɗo feeɲi no yewtida e makko, tawi ɓen-le ko Muusaa e Iiliiya. ");
INSERT INTO fuf_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ɓen no feeɲidi e annoora, hiɓe yewta fii yaadu makko sakkitordu ndun Yerusalaam. ");
INSERT INTO fuf_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Tawi Petruusu e wondiɓɓe mun ɓen no soƴƴaade, kono ɓe ŋonti, ɓe yi'i annoora Iisaa on e ɓen yimɓe ɗiɗo ɓe o wondunoo e mun. ");
INSERT INTO fuf_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Fewndo ɓee yimɓe ɗiɗo seedata e Iisaa, Petruusu wi'i mo: «Karamoko'en, no moƴƴi ka wonen ɗoo. Darnen togooji tati, onon wonndu, Muusaa wonndu, Iiliiya kadi wonndu.» Tawi kanko Petruusu o andaa ko o woni wowlude. ");
INSERT INTO fuf_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Wa fewndo ko o wowlata ɗun, duulere ari buumi ɓe. Ko nden duulere buumata ɓe, ɓe huli. ");
INSERT INTO fuf_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Onsay hawa yalti ka duulere, no wi'a: «Oo ɗoo ko Ɓiɗɗo an Suɓaaɗo on. Heɗitee mo!» ");
INSERT INTO fuf_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ɓay ngol ewol waɗii, ɓe tawi ko Iisaa tun lutti ɗon. Taalibaaɓe ɓen mari ɗun fanki. Ɓe fillitanaaki hay gooto kon ko ɓe yi'i ɗon e nder ɗen balɗe ɗon. ");
INSERT INTO fuf_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Bimbi nden ɲande ko ɓe jippotoo ka ley fello, jamaa moolanaaɗo ari fottugol e Iisaa. ");
INSERT INTO fuf_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Onsay gorko goo ewnii ka hakkunde jamaa ton, o wi'i: «Karamoko'en, mi torike on tenƴinee oo ɓiɗɗo an, ko fii ko bajjo an on nii. ");
INSERT INTO fuf_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Nde jinnawii ngin nangi mo woo, o sonkay, o iiroo, o yaltina ngurda. Ngii letta mo, awa kadi ko karahan ngii yaltirta e makko. ");
INSERT INTO fuf_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Mi torike taalibaaɓe mon ɓen raɗagol ngii jinnawii, kono ɓe waawaali.» ");
INSERT INTO fuf_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Iisaa jaabii, wi'i: «Onon ko on jamaanu ɓoyliingu ngu gomɗinaa. Ko haa honde tuma mi wondata e mon, miɗo muɲɲanoo on? Awa addu ɗoo ɓiɗɗo maa on.» ");
INSERT INTO fuf_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Wa ko o ɓannata paykun kun, jinnawii ngin liɓi kun ka leydi, kun iirii. Kono Iisaa toŋani ngii. Onsay o sellini paykun kun, o jonniti kun ben makkun. ");
INSERT INTO fuf_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Fow ŋalɗi fii mangural Allaahu on. Wa fewndo ko fow ŋalɗidi e ko o waɗaynoo kon kanko Iisaa, onsay o wi'i taalibaaɓe ɓen: ");
INSERT INTO fuf_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«Onon heɗitee fota ɗii konguɗi ɗoo: Ɓii-Aaden on janfoyte, wattee e juuɗe yimɓe ɓen.» ");
INSERT INTO fuf_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Kono hari taalibaaɓe ɓen alaa faamude ɗin konguɗi, sabu hari hiɗi wirnanii ɓe fii wota ɓe andu ko ɗi firi. Awa kadi hari hiɓe huli landitagol mo ɗi. ");
INSERT INTO fuf_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Onsay yeddondiral waɗi hakkunde maɓɓe fii andugol ko hombo e maɓɓe ɓuri teddude. ");
INSERT INTO fuf_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Nde tawnoo Iisaa kaɲun no andunoo ɗin miijooji maɓɓe, o ƴetti paykun, o joɗɗini takko makko. ");
INSERT INTO fuf_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Onsay o wi'i ɓe: «Kala jaɓuɗo kun paykun e innde an, haray ko min o jaɓi. Awa kadi kala jaɓuɗo lan, haray ko Nuluɗo lan on o jaɓi. Ko fii ko ɓurɗo fanɗude on e mon woni tedduɗo.» ");
INSERT INTO fuf_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yuuhanna ƴetti haala kan, wi'i: «Karamoko'en, men yi'ii goɗɗo no raɗoo jinnaaji e innde mo'on. Men toŋani mo ɗun, ɓay o wondaa e amen fii jokkugol on.» ");
INSERT INTO fuf_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Onsay Iisaa wi'i mo: «Wota on toŋan mo ɗun. Ko fii kala mo wonaa gaɲo mon, haray ko giɗo mon.» ");
INSERT INTO fuf_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ɓay wonii balɗe ɗe Iisaa ittetee ka aduna ɗoo ɗen hewtii, o fiɓi anniyee yahugol Yerusalaam. ");
INSERT INTO fuf_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","O immini woɓɓe ko hikkoo yeeso makko, ɓen yahi haa e hoɗo Samariyankeeɓe goo fii eɓɓindanagol mo ɗon kanko Iisaa. ");
INSERT INTO fuf_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Kono ɓen yimɓe jaɓaali mo tolnude, ɓay ko Yerusalaam o sutii. ");
INSERT INTO fuf_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ɓay ɓe yi'ii ɗun, Yaaquuba e Yuuhanna wi'i Iisaa: «Koohoojo amen, hiɗon faalaa yo men wi'u yo yiite ngen iwu ka kammu ara mula ɓee?» ");
INSERT INTO fuf_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Onsay Iisaa fewti e maɓɓe, feli ɓe fota. ");
INSERT INTO fuf_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ontuma ɓe yaari e hoɗo goo. ");
INSERT INTO fuf_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","E nder ko ɓe yahata kon, goɗɗo wi'i mo: «Mi jokkete kala ka yaaruɗaa.» ");
INSERT INTO fuf_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Iisaa jaabii mo, wi'i: «Ndoni ɗin no mari gayɗe mun, awa kadi colli ɗin ka weeyo no mari ɲakkaaji mun, kono Ɓii-Aaden on kan alaa hay ka fowtina hoore mun nden.» ");
INSERT INTO fuf_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Iisaa wi'i goɗɗo goo: «Jokkan!» On jaabii mo: «Koohoojo, newnanee lan taho, mi yaha mi wattinoya ben an en.» ");
INSERT INTO fuf_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Kono Iisaa jaabii mo, wi'i: «Accu mayɓe ɓen wattina mayɓe mun ɓen, kono an yahaa feɲɲinoyaa fii laamu Alla ngun.» ");
INSERT INTO fuf_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Goɗɗo goo kadi wi'i mo: «Koohoojo, mi jokkay on, kono newnanee lan taho, mi yaha mi waynoyoo ɓeynguure an nden.» ");
INSERT INTO fuf_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Iisaa wi'i onɗon kadi: «Kala fawuɗo jungo mun e hoore keri sarin, ontigi yeƴƴitii ɓaawo, haray on nafataa laamu Alla ngun.» ");
INSERT INTO fuf_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ɓay feƴƴii e ɗun, Koohoojo on toɗɗii fahin taalibaaɓe cappanɗe njeeɗiɗo e ɗiɗo. O imminiri ɓe ɗiɗo ɗiɗo ko yaha adoyoo mo e ca'e ɗen fow e kala nokkeeli ɗi o rewoyta e mun. ");
INSERT INTO fuf_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","O wi'i ɓe: «Baagol ngol no ɗuuɗi, kono wa'ooɓe ɓen ɗuuɗaa. Awa jooni, toree non Jom baagol ngol yo o addu wa'ooɓe ka baagol makko. ");
INSERT INTO fuf_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Jooni miɗo imminirde on wa baaloy e hakkunde caapaali, yahee. ");
INSERT INTO fuf_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Awa kadi wota on yooɓo bonfohun kaalisi maa sasa maa paɗe goo, hara kadi on hiwraaki hay gooto ka hoore laawol. ");
INSERT INTO fuf_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Kala suudu ndu naatoton e mun, wi'ee taho: ‹Yo ɓuttu wonu e nduu suudu!› ");
INSERT INTO fuf_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Si ɓii-ɓuttu no e nder ndun suudu, ɓuttu mon on juuroto mo. Si ko liddu mun, on ɓuttu wontanay on. ");
INSERT INTO fuf_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Tabitee e ndun suudu ɗon, ɲaamon yaron ko ɓe okkori on ɗon woo, ko fii golloowo no handi e njoddi mun, hara on waɗaali naata e nduu yalta e nduu. ");
INSERT INTO fuf_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","«Kala saare nde naatuɗon e mun tolnaɗon, ɲaamee ko ɓannanaɗon kon. ");
INSERT INTO fuf_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Sellinon ɲawɓe ɓe tawɗon ɗon ɓen, wi'on ɓe wonde *laamu Alla ngun ɓadike ɓe. ");
INSERT INTO fuf_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Kono kala saare nde naatuɗon e mun, ɓe salii on tolnude, yahee ka fottirde maɓɓe, wi'on: ");
INSERT INTO fuf_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‹Men fiɗɗay e mon mbullaari saare mon nangundi men ndin e koyɗe! Kono andee tun wonde, laamu Alla ngun ɓadike!› ");
INSERT INTO fuf_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Mi andinii on, ɲande ɲaawoore nden ko ndee saare *Saduuma ɓuretee hoynaneede edii nden saare ɗon. ");
INSERT INTO fuf_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","«Bone wonanii ndee saare Kuuraziin e ndee saare Bayti-Sa'iida! Ko fii si tawno ɗii kaawakeeji moƴƴi waɗunooɗi ka mon, ko non waɗirnoo e ɗee ca'e Tiiri e Siduuna, harayno neeɓii ko jeyaaɓe e ɗen ca'e ɓornii conci heynorɗi, ɓe wujitii ndoondi fii hollugol wonde ɓe tuubii. ");
INSERT INTO fuf_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ko ɗun waɗi, ɲande ɲaawoore nden ko Tiiri e Siduuna ɓuretee hoynaneede edii onon. ");
INSERT INTO fuf_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Onon non, ɓee ɓe Kafernahuum, hiɗon sikka fii mon ɓantete haa ka aljanna? Oo'o, on bugete ka jahannama. ");
INSERT INTO fuf_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","«Kala heɗitiiɗo on onon ɓee taalibaaɓe an, haray ko min o heɗitii. Kala bugitiiɗo on, haray ko min o bugitii. Awa-le kala bugitiiɗo lan, haray ko Nuluɗo lan on o bugitii.» ");
INSERT INTO fuf_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ɓen cappanɗe njeeɗiɗo e ɗiɗo artidi e weltaare, ɓe wi'i: «Koohoojo amen, hay jinnaaji ɗin yankinanike men e innde mon!» ");
INSERT INTO fuf_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Onsay o wi'i ɓe: «Mi yi'ayno Ibuliisa no iwa ka kammu yanira wa farɲitere. ");
INSERT INTO fuf_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Awa mi okkii on bawgal tippugol e bolle ɗen e jahe ɗen e kala bawɗe gaɲo on, hara hay fus heɓaali on. ");
INSERT INTO fuf_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Wota on weltor ko jinnaaji ɗin yankinanii on kon. Kono weltoree ko inɗe mon ɗen windaa ka kammuuli kon.» ");
INSERT INTO fuf_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ko e on saa'i ɗon tigi, Iisaa heɓi weltaare fota immorde e *Ruuhu Seniiɗo on, o wi'i: «Mi yettii ma yo Baaba, Jom leydi e kammu, fii koo ko wirnanɗaa ɗun ɓen faamuɓe e ɓee gandiɗuɓe, feɲɲinanɗaa ɗun ɓee fayɓe. Hiiyii, ko fii ko ɗun wonnoo yiɗi maa on yo Baaba. ");
INSERT INTO fuf_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","«Awa, Baaba an wattii fow e juuɗe an. Awa kadi hay gooto andaa ko hombo woni Ɓiɗɗo on si hinaa Baabaajo on, wano tawiri non kadi hay gooto andaa ko hombo woni Baabaajo on si hinaa Ɓiɗɗo on e on mo Ɓiɗɗo on faalaa mo feɲɲinande.» ");
INSERT INTO fuf_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Onsay o fewtiti taalibaaɓe ɓen o wi'i ɓe e qunuutu: «Gite yi'uɗe ko yi'uɗon kon malii! ");
INSERT INTO fuf_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ko fii mi andinii on, annabaaɓe e lamɓe buy faalano yi'ude koo ko wonɗon yi'ude, kono ɓe yi'aali. Ɓe faalano kadi nanude koo ko wonɗon nanude, kono ɓe nanaali.» ");
INSERT INTO fuf_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Onsay goɗɗo e waawuɓe fii Sariya ɓen immii landii mo fii ndarndagol mo, o wi'i mo: «Karamoko'en, ko honɗun mi haani waɗude fii yo mi heɓu ɗan *ngurndan poomayankejan?» ");
INSERT INTO fuf_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Onsay Iisaa wi'i mo: «Ko honɗun windii ka defte Sariya? Ko honno faamirɗaa ɗun?» ");
INSERT INTO fuf_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","O jaabii mo, o wi'i: «Yo a yiɗir Alla Joomiraaɗo maa on ɓernde maa nden fow e wonkii maa kin fow e doole maa ɗen fow e hakkil maa kin fow, yiɗiraa ɲokondo maa on wano yiɗirɗaa hoore maa non.» ");
INSERT INTO fuf_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Onsay Iisaa wi'i mo: «A jaaborii no moƴƴiri. Warru non, a heɓay ɗan ngurndan.» ");
INSERT INTO fuf_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Kono tawi on no faalaa hollude peewal mun ngal, o wi'i Iisaa: «Ko hombo non woni on ɲokondo an?» ");
INSERT INTO fuf_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Iisaa jaabori mo nii, o wi'i: «Goɗɗo no iwraynoo Yerusalaam, no yaha Yeerikoo. O hawrondiri e wuyɓe, ɓen ɓoori mo, piyi mo haa moggo mayde, ɓe yahi, ɓe acci mo ɗon. ");
INSERT INTO fuf_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Hawrondiri *yottinoowo sadaka no feƴƴaynoo ɗon, o yi'i oo neɗɗo, o takkii mo, o feƴƴi. ");
INSERT INTO fuf_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Fahin *Lewiyankeejo ari tawi mo ɗon, on kadi yi'i mo, takkii mo, feƴƴi. ");
INSERT INTO fuf_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Kono Samariyankeejo wonɗo e nder safaari mun, ari tawi mo, yurmaa mo. ");
INSERT INTO fuf_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Onsay o ɓadii, o juurani mo njaram e nebban ka barmeeji, o haɓɓi. Onsay o waɗi mo ka mbaɗɗateeri makko, o naɓi mo haa e suudu hoɓɓe, o dankii mo. ");
INSERT INTO fuf_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Bimbi mun, o ƴetti *dinaruuji ɗiɗi, o jonni jom suudu hoɓɓe ndun, o wi'i mo: ‹Dankor mo ɗii ɗoo. Kala ko fawoyɗaa e hoore ɗii ɗoo, mi yoɓitoyte tuma mi rewtoyi.› » ");
INSERT INTO fuf_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ontuma Iisaa wi'i: «Ko hombo e ɓee ɗoo tato woni ɲokondo oo mo ɓee wuyɓe yani e mun?» ");
INSERT INTO fuf_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","On waawuɗo fii Sariya jaabii, wi'i: «Ko yurmaaɗo mo on.» Onsay Iisaa wi'i mo: «Yahu an kadi warraa non.» ");
INSERT INTO fuf_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Fewndo Iisaa e taalibaaɓe mun ɓen wonnoo e hoore laawol, ɓe naati ɗon e hoɗo. Debbo wi'eteeɗo Mariyatu werni ɓe ka mun. ");
INSERT INTO fuf_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Tawi on no mari neene-gooto wi'eteeɗo Mariyama, on jooɗii e ley koyɗe Koohoojo on no heɗitoo konguɗi makko ɗin. ");
INSERT INTO fuf_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Tawi Mariyatu kaɲun no jindidude e muraaɗi nder suudu ɗin. Onsay o ari, o wi'i: «Koohoojo an, on kippataa fii ko oo neene-gooto an accidimmi e ɗee golle ɗoo kon fow? Wi'anee lan mo yo o wallito lan!» ");
INSERT INTO fuf_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Koohoojo on jaabii mo, wi'i: «Mariyatu, Mariyatu! Hiɗa maapii aani fii piiji ɗuuɗuɗi. ");
INSERT INTO fuf_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Kono ko huunde wootere tun hitti. Mariyama kaɲun suɓike ko ɓuri hittude kon, ɗun-le o jaɓitantaake ɗun.» ");
INSERT INTO fuf_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ɲande goo tawi Iisaa no toraade Alla nokku goo. Ɓay o gaynii toraade, goɗɗo e taalibaaɓe makko ɓen wi'i mo: «Koohoojo, tindinee men no torortee wano Yaayaa tindinirnoo non taalibaaɓe mun ɓen.» ");
INSERT INTO fuf_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Onsay o wi'i ɓe: «Nde hiɗon toroo, on wi'iray nii: «Baaba, yo innde maa nden hormore, yo laamu maa ngun feeɲu. ");
INSERT INTO fuf_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Okkor men ɲande woo ɲaametee haananɗo men on. ");
INSERT INTO fuf_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Yaafanoɗaa men junuubaaji amen ɗin, wano menen kadi men woni yaaforande kala bonnuɗo men. Wota a naadu men e jarrabuyee.» ");
INSERT INTO fuf_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","O wi'i kadi: «Si goɗɗo e mon aru e immaade tumbere jemma, yaha ka njaatigi mun, o findina mo, o wi'a mo: ‹Njaatigi, ɲawlan bireediije tati, ");
INSERT INTO fuf_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ko fii miɗo heɓi koɗo ka jemma ɗoo, mi alaa hay fus ko mi okkora mo.› ");
INSERT INTO fuf_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","«Si on non mo o findinoyi wi'ii mo: ‹Mi torike ma wota a finnan, ko fii a taw mi falii baafal ngal, min e fayɓe an ɓen men waalike. Mi waawataa immaade fewndo ɗoo, mi jonne bireedi!› ");
INSERT INTO fuf_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Mi andinii on, hay si o immaaki, o jonnira mo sabu njaatigiyaagal wongal hakkunde maɓɓe ngal, o jonniray mo kala ko o handi sabu ko on torotooɗo haɓɓitori angal hersa kon. ");
INSERT INTO fuf_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","«Min-le mi wi'ii on: Toree, on okkorte. Ɗaɓɓee, on heɓay. Hoɗɗee, on udditante. ");
INSERT INTO fuf_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ko fii kala toriiɗo okkorte, kala ɗaɓɓuɗo heɓay, awa kadi kala on hoɗɗiiɗo udditante. ");
INSERT INTO fuf_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","«Ko hombo e mon, ɓiɗɗo mun torotoo ɗun bireedi, ontigi jonna mo hayre? Maa o toroo mo lingii, ontigi jonna mo mboddi? ");
INSERT INTO fuf_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Maa o toroo mo woofoonde, o jonna mo yaare? ");
INSERT INTO fuf_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Si tawii non hay onon bonɓe ɓen, hiɗon waawi waɗande ɓiɓɓe mon ɓen piiji moƴƴi, haray ko haa honto Ben mon Wonɗo ka kammu on okkorta ɓen toriiɓe mo *Ruuhu Seniiɗo on!» ");
INSERT INTO fuf_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ɲande goo Iisaa raɗii jinnawii mbobinɗinngii goɗɗo. No ngii yaltirnoo e ontigi, o wowli, jamaa wonnooɗo ɗon on fow mugaa. ");
INSERT INTO fuf_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Woɓɓe e maɓɓe wi'i: «Ko e immorde e *Balzabuula lanɗo jinnaaji ɗin o woni raɗorde jinnaaji ɗin!» ");
INSERT INTO fuf_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Woɓɓe goo kadi fii ndarndagol mo torii mo hollugol ɓe maande iwrunde ka kammu. ");
INSERT INTO fuf_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Nde tawnoo himo andi ɗin miijooji maɓɓe, o wi'i: «Kala laamateeri liddondirndi, kayri tigi ndi caabay. Awa kadi si suudu liddondirii, ndu lancoto. ");
INSERT INTO fuf_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Onon hiɗon wi'a ko tippude e Balzabuula mi woni raɗorde jinnaaji ɗin. Si tawii non Ibuliisa liddike hoore mun tigi, ko honno laamateeri makko ndin tabitirta? ");
INSERT INTO fuf_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Si tawii non wonii min ko tippude e Balzabuula mi raɗorta jinnaaji ɗin, ɗun haray onon ɓe mon ɓen non ko tippude e hombo ɓe raɗorta ɗi? Ko ɗun waɗi si kamɓe tigi ɓe ɲaawoyay on. ");
INSERT INTO fuf_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Kono si tawii ko tippude e bawgal Alla ngal mi woni raɗorde jinnaaji ɗin, haray *laamu Alla ngun arii haa e mon. ");
INSERT INTO fuf_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","«Nde neɗɗo dolnuɗo jom aalaaji ayni galle mun woo, jawle mun ɗen daɗay. ");
INSERT INTO fuf_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Kono si tawii ɓurɗo mo doole arii, yanii e makko, foolii mo, o jaɓitay ɗin jogaaji ɗi o hoolornoo, o sendita ɗen jawle makko. ");
INSERT INTO fuf_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","«Kala mo aldaa e an, haray ko gaɲo an, awa kadi kala mo wallataa lan mooɓitude, haray ko saakoowo. ");
INSERT INTO fuf_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","«Nde jinnawii yalti e neɗɗo woo, ngii hammiray ka wulaa, hara hingii ɗaɓɓa nokkuure fowtorde. Si ngii tawii ngii heɓaali, ngii wi'ay: ‹Yo mi yiltito ka suudu ka mi iwnoo ɗon.› ");
INSERT INTO fuf_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Nde ngii hewtiti, ngii tawa ndun suudu fittaama laɓɓinaama. ");
INSERT INTO fuf_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Onsay ngii yahay, ngii ɗaɓɓoya jinnaaji jeeɗiɗi ɓurɗi ngii hunƴude, ɗi naata ɗon, ɗi hoɗa. Onsay sakkitorde on neɗɗo ɓuray aranun ɗun bonude.» ");
INSERT INTO fuf_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Fewndo ko Iisaa yewtaynoo ɗun, debbo ewnii ka hakkunde jamaa ton, wi'i: «Maloore wonanii nduu reedu saawundu ma e ɗin enɗi ɗi muynuɗaa!» ");
INSERT INTO fuf_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Kono Iisaa jaabii, wi'i: «Maloore wonanii kan ɓen heɗotooɓe daaluyee Alla on, ɗoftoo mo!» ");
INSERT INTO fuf_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Nde tawnoo jamaa on no ɓeydaade tun, onsay kanko Iisaa o wi'i: «Nguu jamaanu ɗoo ko jamaanu bonngu, hingu ɗaɓɓa maande. Kono ngu jonnetaake maande si hinaa sifa ndee nde Yuunusa. ");
INSERT INTO fuf_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ko fii ko wano Yuunusa wonirannoo yimɓe ndee saare *Niinawa maande non, ko wano non *Ɓii-Aaden on kadi woniranta nguu jamaanu ɗoo maande. ");
INSERT INTO fuf_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ɲande ɲaawoore nden, nde yimɓe nguu jamaanu ɗoo no ɲaawee woo, onsay oo debbo laaminooɗo ndii leydi hikkorndi ka sengo ɲaamo immoyto, ɲaawoya ɓe sabu iwugol mo haa ka kattudi leyɗe, ara heɗitoo ngun faamu Sulaymaana, hara-le ɓurɗo Sulaymaana no ɗoo. ");
INSERT INTO fuf_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Awa kadi ɲande ɲaawoore nden, nde yimɓe nguu jamaanu ɗoo no ɲaawee woo, yimɓe Niinawa ɓen kadi immoyto, ɲaawoya ɓe sabu ko ɓe heɗinoo waaju Yuunusa ngun, ɓe tuubi, hara-le ɓurɗo Yuunusa no ɗoo.» ");
INSERT INTO fuf_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","«Hay gooto huɓɓintaa lampu suuɗa mo maa hippa mo e ley siyonwal, kono o waɗay mo e kene fii no naatooɓe ɓen yi'ira ndaygu ngun. ");
INSERT INTO fuf_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ko yiitere maa nden woni ndaygu ɓandu ndun. Si tawii yiitere maa nden no selli, haray ɓandu maa ndun fow no ndaygi. Si tawii non yiitere nden no ɲawi, haray ɓandu maa ndun no e nder niwre. ");
INSERT INTO fuf_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Reenee wota ndaygu wongu e mon ngun wontan on niwre. ");
INSERT INTO fuf_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Si tawii ɓandu mon ndun no ndaygi, hara teral mon hay gootal alaa ka niwre, ɗun haray ɓandu mon ndun fow no ndaygiri wa nde ndaygu lampu jalbi e mon.» ");
INSERT INTO fuf_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Wa fewndo ko Iisaa yewtaynoo ɗun, *Fariisiyaajo goo torii mo yo ɓe yaadu ka makko, ɓe hirtodoya. Onsay o naati, o jooɗi fii ɲaamugol. ");
INSERT INTO fuf_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Kono Fariisiyaajo on ŋalɗi ko Iisaa toolii fii ɲaamugol kon sooɗaaki. ");
INSERT INTO fuf_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Onsay Koohoojo on wi'i mo: «Onon ɓee Fariisiyaaɓe, ko ɓaawo miranji ɗin tun laɓɓinton, hara hiɗon heewi miile e bonki. ");
INSERT INTO fuf_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Onon ko on faaɗa-hakkilɓe, hara hinaa Taguɗo ɓaawo on tagi nder on kadi? ");
INSERT INTO fuf_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Okkoree waasuɓe ɓen ko woni ka nder kon, onsay ko heddii kon fow laaɓanay on. ");
INSERT INTO fuf_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","«Kono bone wonanii on, onon ɓee Fariisiyaaɓe, ɓay hiɗon ittana naana e suukooran e kala tutateeriiji wonɗi e naakoo farilla, hara hiɗon welsindanii peewal ngal Alla yeɗata ngal e giggol makko ngol. Hara-le ko ɗun haanunoɗon jokkude, tawa kadi on welsindaaki e ko heddii kon. ");
INSERT INTO fuf_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","«Bone wonanii on, onon ɓee Fariisiyaaɓe, ɓay hiɗon yiɗi saffawol aranol ngol ka juulirɗe e hiwreede ka fottirɗe. ");
INSERT INTO fuf_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Bone wonanii on, ɓay hiɗon wa'i wa genaale ɗe aldaa e maande, ɗe goɗɗo rewata e mun hara andaali!» ");
INSERT INTO fuf_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Onsay goɗɗo e hakkunde waawuɓe fii Sariya ɓen ƴetti haala kan, wi'i mo: «Karamoko'en, si on maakirii nii, haray on aybinii men menen kadi!» ");
INSERT INTO fuf_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ontuma Iisaa jaabii mo, wi'i: «Bone wonanii on onon kadi ɓee waawuɓe fii Sariya, ɓay hiɗon fawa yimɓe ɓen dolle ɗe ɓe waawataa naɓude, hara onon on fopportaa ɗun hay hoore hondu fii wallugol ɓe. ");
INSERT INTO fuf_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","«Bone wonanii on, ɓay hiɗon maha maandina genaale annabaaɓe ɓen, hara-le ko baabiraaɓe mon ɓen sahinbini ɓe. ");
INSERT INTO fuf_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ɗun no seedintini wonde hiɗon newni ɗen kuuɗe ɓen baabiraaɓe mon, ɓay ɓen sahinbiniino annabaaɓe ɓen, onon kadi hiɗon mahude maandina genaale maɓɓe ɗen. ");
INSERT INTO fuf_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ko ɗun waɗi si Alla, Jom faamu on, no daalunoo: ‹Mi naɓanay ɓe annabaaɓe e nulaaɓe, ɓe wara woɓɓe e ɓen, ɓe tampina ɓeya ɓen›, ");
INSERT INTO fuf_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","fii no nguu jamaanu ɗoo ƴantiroyee ƴiiƴan annabaaɓe hibbanooɗan ɗan gila ka fuɗɗoode aduna, ");
INSERT INTO fuf_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","ɗun ko gila e ƴiiƴan Haabiila ɗan haa addani e ƴiiƴan Zakariyaa ɗan, on waranooɗo hakkunde *layyorde nden e *juulirde mawnde nden. Mi andinii on, pellet nguu jamaanu ɗoo ƴantoyte fii ɗun. ");
INSERT INTO fuf_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","«Bone wonanii on, onon ɓee waawuɓe fii Sariya, ɓay on suuɗii saabiwal gandal ngal, on naataali, awa kadi on jaɓaali faalanooɓe naatude ɓen naata!» ");
INSERT INTO fuf_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ɓay o yaltii ɗon, jannooɓe fii Sariya on ɓen wondude e Fariisiyaaɓe ɓen fuɗɗii mo monanaade, landoo mo lande ɗuuɗuɗe, ");
INSERT INTO fuf_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","waɗana mo pirci, fii tun no ɓe nangira mo immorde e konguɗi makko ɗin. ");
INSERT INTO fuf_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Wa fewndo onsay, tawi yimɓe guluuje guluuje mooɓondirii haa hiɓe yaaɓindira. Onsay Iisaa attii wi'i taalibaaɓe mun ɓen: «Reenee e lewen *Fariisiyaaɓe ɓen, ɗun ko faasiqankaaku ngun. ");
INSERT INTO fuf_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Alaa ko suuɗii ko feeɲataa, awa kadi alaa gundoo mo andotaako. ");
INSERT INTO fuf_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ko ɗun waɗi, kala ko wowluɗon ka niwre feeɲay ɲalorma teɗɗan, e kala ko sowndiɗon ka cuuɗi ewnorte ka warɲakke. ");
INSERT INTO fuf_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","«Mi andinii on yo yiɓɓe an, wota on hulu warooɓe ɓandu ɓen, toonin ɗun alaa ko ɓe waawi. ");
INSERT INTO fuf_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Mi hollay on On mo gasoton hulude: hulee on Marɗo bawgal warugol bugoo ka jahannama nde wari. Mi andinii on, ko on Marɗo bawgal waɗugol ɗun haanuɗon hulude. ");
INSERT INTO fuf_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Hinaa seresereeji jowi no yeeyee tammaaji ɗiɗi? Kono Allaahu on kaɲun yejjitaa hay gootun e majji. ");
INSERT INTO fuf_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Hay cukuli ko'e mon ɗen fow no limaa. Wota on hulu, ko fii hiɗon ɓuri seresereeji buy hittude ka Alla. ");
INSERT INTO fuf_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","«Mi andinii on, kala qirritiiɗo fii an yeeso yimɓe ɓen, *Ɓii-Aaden on kadi qirritoyto fii makko yeeso malaa'ikaaɓe Alla ɓen. ");
INSERT INTO fuf_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Kono kala yedduɗo fii an yeeso yimɓe ɓen, fii ontigi yeddoyte e yeeso malaa'ikaaɓe Alla ɓen. ");
INSERT INTO fuf_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Kala wowluɗo Ɓii-Aaden on ko boni, no ara ka yaafanee. Kono kala hoynuɗo *Ruuhu Seniiɗo on yaafantaake. ");
INSERT INTO fuf_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","«Tuma noddaɗon ka juulirɗe e yeeso mawɓe ɓen e laamiiɓe ɓen, wota on jiɓoyo ko jaaboɗon maa ko wi'on. ");
INSERT INTO fuf_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ko fii ɗon kisan Ruuhu Seniiɗo on tigi longinay on ko gasoton yewtude kon.» ");
INSERT INTO fuf_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Goɗɗo e hakkunde on jamaa wi'i Iisaa: «Karamoko'en, maakanee ben-gooto an on yo men sendodu ndondi amen ndin.» ");
INSERT INTO fuf_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","O jaabii on neɗɗo, o wi'i: «Ko hombo waɗimmi ɲaawoowo maa sendanoowo on?» ");
INSERT INTO fuf_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","O watti e ɗun: «Reenee wattanon yiila e kala miile, ko fii ko aaden alɗi woo, ngurndan makko ɗan hinaa e ɗun humii.» ");
INSERT INTO fuf_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Onsay o waɗani ɓe ngal misal ɗoo, o wi'i: «No woodunoo neɗɗo alɗuɗo mo toore leydi mun moƴƴiri ɗun fota. ");
INSERT INTO fuf_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Tawi on neɗɗo no miijotonoo, wi'a: ‹Ko honno mi waɗata, ko fii mi alaa ka mi waɗa ngal coɲal an?› ");
INSERT INTO fuf_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","O wi'itii: ‹E hino ko mi waɗata kon: Mi lancay tumusuuje an ɗen, mi moƴƴina ɓurɗe ɗe njanɗude ka mi loowa nenɗe an ɗen e piiji an ɗin fow. ");
INSERT INTO fuf_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Jooni yo wonkii an, ɓay miɗo mari jawle buy ko yonatammi e nder duuɓi buy, yo mi fowto, mi ɲaama, mi yara, mi weltoo!› ");
INSERT INTO fuf_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","«Kono Allaahu on wi'i mo: ‹Ko an yo faaɗa-hakkiljo, e nder oo jemma ɗoo tigi a ƴantete wonkii maa kin. E hara koo ko faandiɗaa, ko hombo ɗun wontanta?› ");
INSERT INTO fuf_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","«Awa ko nii woniranta kala on mooɓuɗo jawle e ɓaawo alɗangol Alla.» ");
INSERT INTO fuf_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Onsay Iisaa wi'i taalibaaɓe mun ɓen: «Ko ɗun waɗi si mi wi'ay on wonde, wota on aanu fii ko ɲaamon e nder ngurndan mon ɗan maa fii ko ɓornon ɓalli mon ɗin. ");
INSERT INTO fuf_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ko fii ngurndan no ɓuri neema, awa kadi ɓandu no ɓuri koltu. ");
INSERT INTO fuf_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ndaaree kayakayaaji ɗin: ɗi sankataa, ɗi wa'ataa, ɗi alaa tumusuuje e caagaaje, kono Allaahu on no wurni ɗi, hara-le hiɗon ɓuri colli ɗin hittude. ");
INSERT INTO fuf_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ko hombo e mon e nder annde mun waawata ɓeydude ngurndan mun ɗan beru sogonal? ");
INSERT INTO fuf_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Si tawii non on waawataa hay ko ɓuri lo'ude kon, haray ko honɗun aananton fii ko lutti kon? ");
INSERT INTO fuf_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","«Ndaaree no ɗii piindiiji fuɗirta njanɗa, hara-le ɗi gollataa, ɗi saɲɲataa. Kono non mi andinii on, hay Sulaymaana e nder darja mun on fow holtiraali hay wa wootiri e majji. ");
INSERT INTO fuf_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Si tawii non Allaahu on no holtinirde non hay huɗo wonuko hande ka ngesa kon, bugoyteeko jango ka yiite kon, hara o ronkay waɗande on ko ɓuri ɗun, onon ɓee fanɗa-gomɗinalɓe? ");
INSERT INTO fuf_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Onon non wota on yango fii ko ɲaamon maa ko yaron, wota fii ɗun maapin on. ");
INSERT INTO fuf_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ko fii ɗun fow ko ɓe gomɗinaa ka aduna ɓen ɗaɓɓata ɗun. Kono Ben mon Wonɗo ka kammu on no andi hiɗon handi e ɗun. ");
INSERT INTO fuf_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Kono ɗaɓɓee tun laamu makko ngun, ɗin piiji fow ɓeydanoyte on. ");
INSERT INTO fuf_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","«Ko onon yo wuro tosooko, wota on hulu fus, sabu Ben mon Wonɗo ka kammu on tawii no wela mo ka o yeɗa on laamu ngun. ");
INSERT INTO fuf_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Yeeyee ko jeyɗon kon, okkoron miskinɓe ɓen, moƴƴinee bonfooji ɗi hiɗɗataa, ɗun wonanay on keyee mo lannataa ka kammuuli, ɗon mooƴataa, awa kadi ngujjo meemataa. ");
INSERT INTO fuf_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ko fii ko ka keyee mon on woni woo, ɓernde mon nden wonata.» ");
INSERT INTO fuf_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","«Wonee hebuliiɓe, hara lampuuji mon ɗin no huɓɓi. ");
INSERT INTO fuf_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Wa'on wa nde jiyaaɗo tijjii jom mun, hara ko yahuɗo peera, hara no on hewtitiri hoɗɗii, o udditanay mo. ");
INSERT INTO fuf_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ɓen jiyaaɓe malii nde jom maɓɓe ari tawi hiɓe aynude. Ka haqiiqa mi andinii on, jom ɓen daditoto, o ɓannana ɓe ko ɓe ɲaama. ");
INSERT INTO fuf_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ɓen jiyaaɓe ɓe jom mun tawi no ayna tumbere jemma maa ka tataɓal jemma, haray ɓen malii. ");
INSERT INTO fuf_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ko fii andee fota, si tawno jom galle no andunoo nde ngujjo on araynoo wujjugol, haray o accataano galle makko ɗen fusee. ");
INSERT INTO fuf_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Awa onon kadi hebilee, ko fii Ɓii-Aaden on aroyay e saa'i nde on sogitaaki.» ");
INSERT INTO fuf_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Onsay Petruusu wi'i mo kanko Iisaa: «Koohoojo amen, hara ngal misal ɗoo ko fii amen tun kaa ko fii yimɓe ɓen fow?» ");
INSERT INTO fuf_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Koohoojo on jaabii mo, wi'i: «Hara ko golloowo hombo reeniiɗo holniiɗo woni ko jom mun halfinta neemingol kurkaaɗi mun ɗin e saa'i haanuɗo? ");
INSERT INTO fuf_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Maloore wonanii on jiyaaɗo mo jom mun ari tawi no jokkiri non. ");
INSERT INTO fuf_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ka haqiiqa mi andinii on, o halfinay mo jawle makko ɗen fow. ");
INSERT INTO fuf_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Kono si on jiyaaɗo wi'itike: ‹Jom an neeɓii araali›, onsay, o nangana tilfugol kurkaaduuɓe ɓen worɓe e rewɓe e ɲaamugol yara haa mandila, ");
INSERT INTO fuf_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","jom on jiyaaɗo aray nde on jiyaaɗo sabbaaki mo e saa'i mo o sogitaaki, o letta mo lette sattuɗe, o waɗa mo ka ɓe gomɗinaa ɓen waɗetee ton. ");
INSERT INTO fuf_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","«Jiyaaɗo anduɗo faaleeji jom mun ɗin, kono o eɓɓindaaki, maa o waɗaali faaleeji jom makko ɗin, o piyete piggal ɗuuɗungal. ");
INSERT INTO fuf_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Kono si tawii non ontigi andaa faale jom mun on, o waɗii kuuɗe fodduɗe e donkineede, o foccete ko hawri. On okkoraaɗo ko ɗuuɗi ƴantete ko ɗuuɗi, awa kadi on halfinaaɗo ko ɗuuɗi landitoyte ko ɓurti.» ");
INSERT INTO fuf_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","«Miɗo ari bugagol yiite e oo aduna, mi faalete hara nge huɓɓii! ");
INSERT INTO fuf_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Kono no woodi loƴegol ngol mi loƴoytee, e maanaa ɗun ko tampere, ɗoo yo ɗun sollitanan, haray miɗo sonjii. ");
INSERT INTO fuf_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","E hara on sikku ko addugol ɓuttu e oo aduna mi arani? Oo'o, hinaa ɗun, kono ko liddondiral mi addi. ");
INSERT INTO fuf_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ko fii gila jooni njowo wonduɓe e nder suudu ɓe woncondiray, tato liddondiray e ɓeya ɗiɗo, ɓeya ɗiɗo kadi liddondira e ɓeya tato. ");
INSERT INTO fuf_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Baaba liddondiray e ɓiɗɗo, ɓiɗɗo liddondira e baaba, neene liddondira e jiwo mun, jiwo kadi liddondira e neene mun, debbo liddondira e esiraawo mun jiwo, jiwo on kadi liddondira e esiraawo mun debbo.» ");
INSERT INTO fuf_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Iisaa wi'i kadi jamaa on: «No yiiruɗon duulere no immori ka hirnaange, on wi'ay kisan ‹ndiyan ɗan aray›, ɗun wonira non. ");
INSERT INTO fuf_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Awa kadi no yiiruɗon hendu ndun iwrii sengo ɲaamo woo, on wi'ay ‹nguleendi ndin arii›, ɗun kadi waɗa. ");
INSERT INTO fuf_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ko onon yo faasiqiiɓe, on waawii faamude fii ko feeɲi ka leydi kon e ko feeɲi ka kammu kon. Ko fii honɗun non on waawaali andude oo saa'i fewndiiɗo ɗoo? ");
INSERT INTO fuf_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","«Hara ko fii honɗun onon on waawataa faamande hoore mon ko feewi kon? ");
INSERT INTO fuf_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Nde an e mo haɓiduɗaa hiɗon yaha ka yeesoojo on woo, waɗu feere no faamondiriron ka laawol, fii wota o watte e juuɗe ɲaawoowo on, on ɲaawoowo kadi watte e juuɗe aynooɓe kaso ngon, ɓen sokoye. ");
INSERT INTO fuf_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Mi andinii ma, a yaltataa ɗon fannamaa a yoɓaali mbuuɗu sakkitoro on.» ");
INSERT INTO fuf_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ko fewndo onsay, woɓɓe ari fillitanii Iisaa fii ɓee ɓe Jaliilu ɓe Pilaatu warnoo fewndo ɓe hirsata daabeeji fii ittugol sadakaaji maɓɓe. ");
INSERT INTO fuf_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","O jaabii ɓe kanko Iisaa, o wi'i: «Hara on sikku ɓen ɓe Jaliilu no ɓuri Jaliiluyankooɓe ɓen fow junuubu ɓay ɓe lettorii non? ");
INSERT INTO fuf_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Min mi wi'ay on - oo'o! Kono si on tuubaali onon kadi, on fow on re'ay. ");
INSERT INTO fuf_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Kaa hara on sikku ɓee sappoo e njeetato, ɓe nduu suudu aynirdu ka maadi Siluwaama yani e mun wari, no ɓuri ɓee ɓe Yerusalaam luttuɓe fow bakkatu? ");
INSERT INTO fuf_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Min mi wi'ay on - oo'o! Kono si on tuubaali onon kadi, on fow on re'ay.» ");
INSERT INTO fuf_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Onsay o waɗani ɓe ngal misal ɗoo: «Tawi goɗɗo no marnoo ƴibbehi ka tutateeri mun. O ari ɗaɓɓugol ɓiɓɓe e makki, o heɓaali. ");
INSERT INTO fuf_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Onsay o wi'i gollanoowo mo on ka tutateeri: ‹Heɓii nii duuɓi tati miɗo arude ɗaɓɓugol ɓiɓɓe e ngal leggal, mi heɓaali. Hara ko nafa honɗun ngal wonani ɗoo? Jooni soppu ngal!› ");
INSERT INTO fuf_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","«Kono golloowo on jaabii mo, wi'i: ‹Jom an, accee ngal ɗoo ndee hitaande ɗoo. Ɗoo e ɗun mi jasay binde maggal on fow mi waɗana ngal ɲolu. ");
INSERT INTO fuf_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","No gasa ka ngal rima ko arata. Si ko liddu mun, onsay on soppoyay ngal.› » ");
INSERT INTO fuf_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Tawi ɲande goo Iisaa no jannaynoo e juulirde goo e *ɲalaande fowteteende nden, ɗun ko asewe. ");
INSERT INTO fuf_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Tawi no ɗon debbo mo jinnawii jukkini heɓii duuɓi sappoo e jeetati, himo turii, o waawataano ɓantaade few. ");
INSERT INTO fuf_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ɓay Iisaa yi'ii mo, o noddi mo, o wi'i: «Debbo, a sendaama e jukkere maa nden!» ");
INSERT INTO fuf_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Onsay Iisaa *fawi juuɗe mun ɗen e makko. Ɗon kisan debbo on feewi e darnde, o manti Allaahu on. ");
INSERT INTO fuf_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Kono yeesoojo juulirde nden seytini kon ko Iisaa ɲawndi ɲande asewe, o wi'i jamaa on: «No woodi balɗe jeegoo gaseteeɗe golleede e mun. Aree ɲawndeɗon e ɗen balɗe ɗon, hara hinaa e ɲalaande asewe!» ");
INSERT INTO fuf_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Koohoojo on jaabii mo, wi'i: «Ko onon yo faasiqiiɓe! Hinaa mo kala e mo'on yaltinay nagge mun maa mbabba mun ka dingiraa mun ɲande asewe, naɓa yarnoya? ");
INSERT INTO fuf_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Hara oo debbo iwdi Ibraahiima mo Ibuliisa haɓɓi gila duuɓi sappoo e jeetati, haanaa ka o firtanee ɗin kaɓɓi ɲande ɲalaande fowteteende nden?» ");
INSERT INTO fuf_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ɓay o yewtirii non, ɗun hersini ayɓe makko ɓen fow, kono jamaa luttuɗo on weltori ɗii piiji hittuɗi ɗi o waɗaynoo. ");
INSERT INTO fuf_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","O wi'i fahin: «Hara ko honɗun *laamu Alla ngun nandi, maa ko honɗun mi eɓɓindirta e maggu? ");
INSERT INTO fuf_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Hingu wa'i wa abbere bene nde goɗɗo ƴetti, bugii ka suntuure mun. Nden fuɗi, wonti leggal ngal colli ɗin ka weeyo arata hoɗa e calɗi mun.» ");
INSERT INTO fuf_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","O wi'i kadi: «E ko honɗun mi eɓɓindirta e laamu Alla ngun? ");
INSERT INTO fuf_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Hingu wa'i wa lewen mo debbo ƴetti, jillindiri e sariyaare tati condi farin, o piya ɗun, on lewen wona sabu ɗun fow ƴura.» ");
INSERT INTO fuf_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ko Iisaa yahaynoo Yerusalaam, o rewayno koɗolun e koɗolii hara himo waajoo. ");
INSERT INTO fuf_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Goɗɗo goo landii mo, wi'i: «Koohoojo, hara ko yimɓe seeɗaaɓe tun dandoytee?» Onsay o wi'i ɓe: ");
INSERT INTO fuf_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«Etee no naatiron ka dambugal faaɗungal, ko fii mi andinii on, buy ɗaɓɓoyay no naatira ɗon, kono ɓe waawoytaa. ");
INSERT INTO fuf_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Nde jom galle ɗen immii ombi baafal ngal woo, hara hiɗon ka yaasi, onsay on fuɗɗoto honkande mo baafal ngal, wi'a: ‹Koohoojo, udditanee men!› O jaaboyto on, o wi'a: ‹Min mi andaa ko on ɓe honto!› ");
INSERT INTO fuf_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","«Wi'on kadi: ‹Men ɲaamuno men yaridi e mon, awa kadi on waajotono ka ɗate amen.› ");
INSERT INTO fuf_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","O jaaboo on kadi, o wi'a: ‹Min mi andaa ko on ɓe honto. Onon ɓee waɗaynooɓe ko ɓoylii fow, pottitee lan!› ");
INSERT INTO fuf_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","«Tuma yi'uɗon Ibraahiima e Issaaqa e Yaaquuba e ɓeya annabaaɓe heddiiɓe fow ka nder laamateeri Alla, tawa onon ko on bugoyteeɓe ka yaasi, ka wullaandu e ŋatindiro ɲiiƴe woni ton. ");
INSERT INTO fuf_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Iwroyte funnaange e hirnaange, nano e ɲaamo, ɓe nafodoya ka laamateeri Alla. ");
INSERT INTO fuf_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Awa andee wonde, no woodi ɓaawooɓe wontiroyayɓe yeeso, wano tawiri non kadi no woodi yeesooɓe wontiroyayɓe ɓaawo.» ");
INSERT INTO fuf_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ko e on saa'i ɗon *Fariisiyaaɓe goo ari wi'i mo kanko Iisaa: «Yahu iwaa ɗoo, ko fii *Heroodu no faalaa sahinbinde ma!» ");
INSERT INTO fuf_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","O wi'i ɓe: «Yahee hollon ndun saafaandu: Miɗo raɗaade jinnaaji ɗin, mi sellina ɲawɓe ɓen hande e jango, ka ɲalaande tammere haray timmanii lan. ");
INSERT INTO fuf_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Kono bee mi seppa hande e jango e faɗɗi-jango, ko fii haanaa ka annabaajo waree ko wonaa Yerusalaam. ");
INSERT INTO fuf_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","«Ee Yerusalaam! Ee Yerusalaam! Ko an yo saare sahinbinoore annabaaɓe, wariroore nelaaɓe e mun kaaƴe! Ko haa honto mi faalanoo mooɓude ɓee fayɓe maa wano gertogal mooɓirta coppi e ley gabitti mun, e hin-le on jaɓaali ɗun! ");
INSERT INTO fuf_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Awa nokkuure mon nden eggaama. Kono mi andinii on, on yiitataa lan haa ɲande wi'oyton: ‹Yo barki wonan oo wonɗo arude e innde Joomiraaɗo on!› » ");
INSERT INTO fuf_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","E *aseweere goo, ɗun ko *ɲalaande fowteteende nden, Iisaa naati e suudu hooreejo Fariisiyaaɓe ɓen fii nafagol, tawi ɓen Fariisiyaaɓe no tenƴina mo. ");
INSERT INTO fuf_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Tawi aaden ɓuutuɗo no yeeso makko ɗon. ");
INSERT INTO fuf_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Onsay Iisaa landii waawuɓe fii Sariya ɓen e Fariisiyaaɓe ɓen, o wi'i: «Hara no dagii ka ɲawndee e aseweere kaa dagaaki?» ");
INSERT INTO fuf_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Kono ɓe fow ɓe deƴƴi. Onsay o ƴetti on ɲawɗo, o sellini, o acciti mo, on yahi. ");
INSERT INTO fuf_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Onsay o wi'i ɓe: «Ko hombo e mon, si ɓiɗɗo mun maa nagge mun aru e yanude e nder woyndu, salotoo nge ƴawnude maa ƴawna mo ɗon kisan fii nden ɲande ko asewe?» ");
INSERT INTO fuf_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Laatii ɓe waawaali jaabaade hay huunde e ɗun. ");
INSERT INTO fuf_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ɓay o yi'ii no ɓen saatinanooɓe suɓoraynoo ndaɗɗule yeesooje ɗen, o waɗani ɓe ngal misal ɗoo, o wi'i ɓe: ");
INSERT INTO fuf_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«Si on aru e saatineede e peera, wota on wonu ka ndaɗɗule yeesooje fii hita taw ɓurɗo on hittude no saatinaa ɗon ");
INSERT INTO fuf_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","haa saatinɗo on on ara wi'a on: ‹Accanee oo ɗoo ndaɗɗudi ndin.› Onsay on hersay ruttagol ka ndaɗɗudi ɓaawoori. ");
INSERT INTO fuf_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Kono tuma saatinaɗon woo, wontiree ɓaawo fii tuma nde saatinɗo on on ari woo, yo o wi'u on: ‹Giɗo an, aru wonaa yeeso gaa.› Onsay ɗun wonanay on teddungal e tawnde ɓen ɓe saatindinaɗon fow. ");
INSERT INTO fuf_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ko fii kala mawnintiniiɗo jippinoyte, awa kadi kala jippinɗo hoore mun mawninoyte.» ");
INSERT INTO fuf_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Onsay kanko Iisaa o wi'i saatinɗo mo on: «Nde hiɗa soƴƴina maa hirtina woo, wota a saatin yiɓɓe maa ɓen maa neene-gootooɓe maa ɓen maa musiɓɓe maa ɓen maa kawtalɓe maa alɗuɓe ɓen, fii wota kamɓe kadi ɓe saatine ɲande goo, ɗun wonane njoddi. ");
INSERT INTO fuf_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Kono nde waɗataa caatal woo, saatin miskinɓe ɓen e jukkunnaaɓe ɓen, e maanaa boofooɓe ɓen e bumɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ɗun a wonoyay malaaɗo, ko fii ɓen alaa ko yoɓitire, a yoɓitoyte ɲande ummutal feewuɓe ɓen.» ");
INSERT INTO fuf_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ɓay goɗɗo e ɓe o nafodaynoo ɓen nanii ɗin konguɗi makko kanko Iisaa, o wi'i mo: «Maloore wonanoyay on nafoytooɗo ka *laamateeri Alla!» ");
INSERT INTO fuf_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Onsay Iisaa jaabii mo, wi'i: «Ɲande goo goɗɗo waɗuno caatal moolanaangal, o saatini yimɓe buy. ");
INSERT INTO fuf_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ɓay nafagol ngol fewndike, o nuli kurkaadu makko ndun yo on yahu wi'a ɓe o saatinnoo ɓen yo ɓen aru, ko fii hebulaama. ");
INSERT INTO fuf_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","«Kono ɓe fow ɓe kuylitidi. Arano on e maɓɓe wi'i ndun kurkaadu: ‹Miɗo soodi ngesa, bee mi yaha mi ndaaroya mba. Mi torike mo yo o yaafo lan.› ");
INSERT INTO fuf_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Goɗɗo on wi'i: ‹Miɗo soodi kalali sappo, miɗo yahude mi lasindoo ɗi, mi torike mo yo o yaafo lan.› ");
INSERT INTO fuf_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Goɗɗo goo kadi wi'i: ‹Miɗo jombi neeɓaali, ko ɗun haɗata mi yaha.› ");
INSERT INTO fuf_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","«Ɓay kurkaadu ndun hewtitii, o yottintini e jom makko ko o nulaa kon fow. Onsay jom galle on tikki, o wi'i ndun kurkaadu makko: ‹Yahu kisan e ɗate ɗen fow, njane e tosooke, addanoyaa mi miskinɓe ɓen e jukkunnaaɓe ɓen e bumɓe ɓen e boofooɓe ɓen fow.› ");
INSERT INTO fuf_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","«Kurkaadu ndun wi'i: ‹Jom an, ko yamirɗon kon waɗaama, kono haa jooni ka jooɗee no lutti.› ");
INSERT INTO fuf_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","«Onsay jom galle ɗen wi'i kurkaadu ndun: ‹Yahu haa ka fulawaa, takkoɗaa kowle ɗen fow, rewaa e ɗatoy koy fow, etoɗaa no yimɓe ɓen arda fii no ka an heewira. ");
INSERT INTO fuf_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ko fii mi andinii on, hay gooto e ɓee ɓe mi saatinnoo aranun mettotaako oo nafakka an!› » ");
INSERT INTO fuf_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Tawi jamaa moolanaaɗo no jokkondirnoo e Iisaa. O fewtiti ɓe, o wi'i: ");
INSERT INTO fuf_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«Si goɗɗo arii e an, hara o woniraa selugol ben makko e yumma makko e ɓeyngu makko e ɓiɓɓe makko ɓen e neene-gootooɓe makko ɓen worɓe e rewɓe haa naɓani wonkii makko kin tigi, haray onɗon waawataa wonude taalibaajo an. ");
INSERT INTO fuf_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Awa kadi kala mo ƴettaali *leggal mun altindiraangal ngal jokkimmi, haray ontigi waawataa wonude taalibaajo an. ");
INSERT INTO fuf_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","«Hara ko hombo e mon si no faalaa darnude koore, ronkata jooɗaade taho, taskoo fii ko o eɓɓi kon si ko ko yonata? ");
INSERT INTO fuf_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Kulol wota ootigi fuɗɗo ronka gaynude, fii wota yi'uɓe mo e ɗun ɓen fow jalu mo, ");
INSERT INTO fuf_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","wi'a: ‹Oo neɗɗo fuɗɗino darnude, kono o waawaali lannitaade!› ");
INSERT INTO fuf_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","«Maa hara ko lanɗo hombo fokkitanta haɓidoygol e lanɗo goo mo konu mun woni embere yimɓe guluuje noogayo, hara kanko ngu makko ngun ko embere yimɓe guluuje sappo, ronkata jooɗaade taho, taskoo si o heɓoyay kutu maɓɓe? ");
INSERT INTO fuf_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Si o tawii non o heɓoytaa kutu maɓɓe ɓay oya no woɗɗitii mo taho, o nelay e on fii yo on waɗan mo sartiiji no ɓuttu on tabitira. ");
INSERT INTO fuf_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ko ɗun waɗi, kala e mon mo woniraa seedugol e ko o jeyi kon, haray gasataa wonde taalibaajo an. ");
INSERT INTO fuf_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","«Lanɗan ko huunde moƴƴere, kono si dakamme majjan on iwii, haray ko honno dakamme majjan on wattirtee? ");
INSERT INTO fuf_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Haray ɗan alaa nafa ka leydi maa ka ɲolu, ko hawkoyteeɗan ka yaasi. «Mo no mari noppi nanirɗi yo nanu!» ");
INSERT INTO fuf_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ƴantooɓe sagalle ɓen fow wondude e junuubanke'en no ɓadotonoo Iisaa fii heɗagol mo. ");
INSERT INTO fuf_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Fariisiyaaɓe* ɓen e jannooɓe fii Sariya on no ŋunaynoo hakkunde maɓɓe, wi'a: «Oo ɗoo kaɲun ɓannitay junuubanke'en, ɲaamida e maɓɓe!» ");
INSERT INTO fuf_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Onsay kanko Iisaa o waɗani ɓen ngal misal ɗoo, o wi'i: ");
INSERT INTO fuf_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«Ko hombo e mon si no mari baali teemedere, gootii e ɗin majja, ronkata accude cappanɗe jeenay e jeenayji ɗin ka wulaa, yaha ɗaɓɓitoya majjungii ngin haa nde o yiitoyi ngii woo? ");
INSERT INTO fuf_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Nde o yiitoyi ngii, o wakkoo ngii e hoore weltaare. ");
INSERT INTO fuf_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Nde o hewtiti ka makko, o nodditay yiɓɓe makko ɓen e kawtalɓe makko ɓen, o wi'a ɓe: ‹Weltodee e an, ko fii mi yiitii baalii an majjunoongii ngin!› ");
INSERT INTO fuf_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Mi andinii on, ko wano non kadi weltaare ɓurirta woodude ka kammu sabu junuubankeejo gooto tuubuɗo, edii feewuɓe cappanɗe njeenayo e njeenayo ɓe tuubuubuyee fawaaki ɗun.» ");
INSERT INTO fuf_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","«Maa ko debbo hombo marɗo tammaaji sappo, si wooturu e ɗin majjirii mo, ronkata huɓɓude lampu, fitta suudu mun ndun, ɗaɓɓitira hakkil haa nde o yiiti ndu woo? ");
INSERT INTO fuf_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Nde o yiiti ndu, o nodditay yiɓɓe makko ɓen wondude e kawtalɓe makko ɓen, o wi'a ɓe: ‹Weltodee e an, ko fii mi yiitii tammaaru an majjunoondu ndun!› ");
INSERT INTO fuf_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Mi andinii on, ko wano non kadi malaa'ikaaɓe Alla ɓen weltorta tuma nde junuubankeejo gooto tuubi.» ");
INSERT INTO fuf_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","O wi'i kadi: «Goɗɗo no marnoo ɓiɓɓe ɗiɗo. ");
INSERT INTO fuf_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Toolaajo makko on wi'i mo: ‹Baaba an, jonnee lan geɓal an ngal mi haani hendoyaade ngal ka jawdi mon.› Onsay ben maɓɓe sendani ɓe jawdi mun ndin. ");
INSERT INTO fuf_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","«Ɓay balɗe feƴƴii, toolaajo on mooɓi ko o jeyi kon fow, o yahi e leydi woɗɗundi, o funsitoyi ton jawdi makko ndin fow e nder jiiɓaare. ");
INSERT INTO fuf_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ɓay o lannii fewjande fow, heege tiiɗunge waɗi e ndin leydi. Onsay o fuɗɗaa ŋakkireede. ");
INSERT INTO fuf_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","O halfinoyii e goɗɗo goo jeyaaɗo e ndin leydi, on naɓi mo ka gese mun fii ko aynana ɗun koseeji mun ɗin. ");
INSERT INTO fuf_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Himo faaletenoo ɲaamude neteeje ɗe koseeji ɗin ɲaamaynoo ɗen, kono hay gooto okkoraali mo. ");
INSERT INTO fuf_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","«O luggini miijo, o wi'i: ‹Ko gollooɓe njelo ben an mari ɲaamooɓe haa luttina, hara min miɗo maaya ɗoo heege! ");
INSERT INTO fuf_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Jooni non, miɗo yiltitaade ka ben an, mi wi'a ɓe: Baaben, mi waɗii junuubu ka Alla, mi heɓii hakkee mon, ");
INSERT INTO fuf_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","mi foddaa e noddeede ɓiɗɗo mon hande kadi. Jogoree lan wa golloowo mon.› ");
INSERT INTO fuf_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","«Onsay o yiltitii ka ben makko. Ɓay o ɓadike, ben makko haynii mo, yurmaa mo. Tun ben makko dogi, hirbii mo, lunnii. ");
INSERT INTO fuf_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Onsay on ɓiɗɗo makko wi'i mo: ‹Baaben, mi heɓii junuubu ka Alla mi heɓii hakkee mon, mi foddaa e noddeede ɓiɗɗo mon hande kadi!› ");
INSERT INTO fuf_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","«Kono ben makko yamiri kurkaaduuɓe mun ɓen, o wi'i ɓe: ‹Yahee tinna addanon mo kaftaane ɓurɗo fotude on ɓornon mo, waɗanon mo hurundaare ka hondu e paɗe ko o wattoo.› ");
INSERT INTO fuf_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","O wi'i ɓe kadi: ‹Addoyee ga'un fayukun kun, hirson, ɲaamen, weltoɗen. ");
INSERT INTO fuf_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ko fii hari oo ɓiɗɗo an ɗoo ko mayɗo, kono jooni o wuuritii, hari kadi o majjii, kono jooni o yiitaama!› Onsay ɓe woni e fijugol weltoda. ");
INSERT INTO fuf_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","«Ɗun hawrondiri afo makko on no ka ngesa. Ɓay on ɓadike ka hoɗo fewndo ko o artata, o nani hito gimi e gami. ");
INSERT INTO fuf_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Tun o noddi golloowo maɓɓe goo fii ko humpita mo kon ko woni waɗude ka maɓɓe. ");
INSERT INTO fuf_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","On golloowo wi'i mo: ‹Miɲan maa hewtitii. Ɓay non o hewtitii e jam, ko sabu ɗun ben maa en hirsiri ga'un fayukun kun.› ");
INSERT INTO fuf_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","«On seytini kisan, o salii naatude. Onsay ben makko yalti jeeji mo fii yo o naatu. ");
INSERT INTO fuf_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Kono o wi'i ben makko: ‹E hino, waɗii nii duuɓi buy miɗo yanganaade on. Haa hande mi yeddaali on. Min-le hay nde wootere on okkaali lan hay be'un fii ko mi saatinira goreeɓe an ɓen. ");
INSERT INTO fuf_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Kono ɓay oo ɓiɗɗo mon ɗoo dekkuɗo ndii jawdi mon dekkidi ndi e waɗooɓe jinaa artii, onɗon on hirsanii mo ga'un fayukun kun!› ");
INSERT INTO fuf_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","«Ben makko wi'i mo: ‹An non boobo an, ɲande woo hiɗen wondi. Ko mi mari kon fow ko an jeyi. ");
INSERT INTO fuf_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Kono mi taw bee mi weltoo, mi waɗa welo-welo, ɓay hari oo miɲɲiraawo maa ɗoo ko mayɗo, kono jooni o wuuritii, hari kadi o majjii, kono jooni o yiitaama.› » ");
INSERT INTO fuf_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Iisaa wi'i taalibaaɓe mun ɓen kadi: «No woodunoo aaden galo marɗo mbatulaajo, tawi on mbatulaajo makko no ɲo'iraa funsugol jawdi on galo. ");
INSERT INTO fuf_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","O noddi on mbatulaajo, o wi'i mo: ‹Ko honɗun mi woni nanude e hoore maa? Jittanan no wonɗaa gollirde, ko fii a waawataa wonude mbatulaajo an hande kadi.› ");
INSERT INTO fuf_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","«Onsay mbatulaajo on wi'itii: ‹Hara ko honɗun mi waɗata jooni, ɓay jom an no ittude lan wonugol mbatulaajo makko? E hin-le mi maraa doole remugol, awa kadi toragol no hersinanii lan. ");
INSERT INTO fuf_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Mi andii ko mi waɗa fii yo mi heɓoy ko wernammi ka mun tuma mi ittaa e mbatulayaagal.› ");
INSERT INTO fuf_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","«Onsay o nodditi kala joganiiɓe jom makko ɓen. O wi'i arano on: ‹Ko jelu joganiɗaa jom an?› ");
INSERT INTO fuf_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","On jaabii: ‹Ko tankonje teemedere nebban.› Ontuma mbatulaajo on wi'i mo: ‹Jooɗo kisan, ƴettaa kaydi maa ndin, windaa ko cappanɗe jowi joganiɗaa mo.› ");
INSERT INTO fuf_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","«O wi'i goɗɗo goo kadi: ‹An-le ko jelu joganiɗaa mo?› On jaabii: ‹Ko bootooji teemedere ngawri.› O wi'i onɗon kadi: ‹Ƴettu kaydi maa ndin, windaa ko bootooji cappanɗe jeetati joganiɗaa mo.› ");
INSERT INTO fuf_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","«Onsay jom on mbatulaajo ɓoyliiɗo manti mo sabu kon ko on golliri ƴoyre. Ko fii fayɓe nguu jamaanu no ƴoƴi telen ɲokondooɓe mun ɓen ɓuri fayɓe jeyaaɓe ɓen ka ndaygu. ");
INSERT INTO fuf_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Min-le mi wi'ay on: yo on ɗaɓɓir ɗee jawle adunayankeeje yiɓɓe, fii tuma nde ɗen lanniroyi on, yo on wernoye ka galleeji poomayankeeji. ");
INSERT INTO fuf_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","«Mo nunɗii e hoore ko fanɗi, o nunɗay e hoore ko mawni. Awa kadi mo nunɗaali e hoore ko fanɗi, o nunɗataa e hoore ko mawni. ");
INSERT INTO fuf_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Si tawii non on nunɗaali e hoore jawle adunayankeeje ɗen, haray ko hombo halfinoyta on jawle haqiiqaaje ɗen? ");
INSERT INTO fuf_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Awa kadi si on nunɗaali e hoore ngel goɗɗo ngel, ko hombo jonnoyta on ko mon kon? ");
INSERT INTO fuf_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","«Golloowo hay gooto waawataa gollande jeyɓe ɗun ɗiɗo, ko fii o aɲay oya, o yiɗa oya, maa o haɓɓoo e oya, o itta bote e oya. Ko ɗun waɗi si on waawataa rewude Alla, rewon jawdi.» ");
INSERT INTO fuf_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Fariisiyaaɓe* ɓen e yiɗude mun kaalisi no heɗotonoo ɗun fow liɓa bote e Iisaa. ");
INSERT INTO fuf_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","O wi'i ɓe: «Onon hiɗon waɗi hoore mon feewuɓe e yeeso yimɓe ɓen, kono Allaahu on kaɲun no andi ko woni ka ɓerɗe mon. Ko fii ko yimɓe ɓen ɓanti fii mun kon ko ɲidduɗun yeeso Alla. ");
INSERT INTO fuf_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","«Awa ko Sariya on e defte annabaaɓe ɓen wonnoo haa fewndo Yaayaa. Kono gila e fewndo Yaayaa, Kibaaru Moƴƴo fii *laamu Alla ngun no feɲɲineede, mo kala no huutorde doole fii naatugol ɗon. ");
INSERT INTO fuf_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Kono mi andinii on: kammu ngun e leydi ndin mutude no ɓuri newaade edii ciifun gootun wonkun ka Sariya monteede. ");
INSERT INTO fuf_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","«Kala accituɗo ɓeyngu mun, ƴetti goɗɗo goo, haray ontigi jeenii. Awa kadi kala ƴettuɗo debbo seedaaɗo, haray onɗon kadi jeenii. ");
INSERT INTO fuf_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","«Hari no woodunoo aaden galo ɓornotonooɗo conci dimi firsiniraaɗi ko wojji, waɗaynooɗo ɲande woo welii e fotii. ");
INSERT INTO fuf_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Tawi miskiino wi'eteeɗo Laazaru mo ɓandu mun fow temmaa no waalii ka dambugal makko. ");
INSERT INTO fuf_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","On no faaletenoo hendaade ɲaameteeji luttaynooɗi ɗin ka on galo. Tawi hay bareeji ɗin arayno metta ɗen temmeeje makko. ");
INSERT INTO fuf_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","«Ɲande goo on miskiino maayi, malaa'ikaaɓe ɓen naɓi mo tawtinoyi Ibraahiima. On galo kadi maayi, surraa. ");
INSERT INTO fuf_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ka jahannama, tawi on galo no e nder lette, o ɓanti gite, o haynii Laazaru takko Ibraahiima ka woɗɗitii. ");
INSERT INTO fuf_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","O ewnii, o wi'i: ‹Baaba an Ibraahiima, yurme lan, yamiraa Laazaru yo o jullu hondu makko ndun ka ndiyan, o ara o ɓuɓɓinanammi ɗenngal an ngal. Ko fii miɗo tampi ka yiite gaa!› ");
INSERT INTO fuf_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","«Ibraahiima jaabii mo, wi'i: ‹Boobo an, anditu an a hendinoke moƴƴereeji maa ɗin ka aduna, wano non kadi Laazaru yeɗinoke ton tampereeji. Jooni non kanko ɓernde makko ɓuttinaama ɗoo, an hiɗa tampude. ");
INSERT INTO fuf_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","E hoore ɗun kadi, wimbo moolanaango no waɗaa hakkunde men fii wota faalaaɓe iwde gaa yaha ton ɓen waawu ɗun, wano non onon kadi wota on waawu lumbitirde gaa.› ");
INSERT INTO fuf_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","«Onsay on galo wi'i: ‹Awa mi torike ma yo baaba an, nelanan Laazaru ka galle ben an ");
INSERT INTO fuf_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","haa e ɓee neene-gootooɓe an njowo, o hajoyoo ɓe ɗun fii wota kamɓe kadi ɓe aroy e ndee nokkuure lette.› ");
INSERT INTO fuf_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","«Onsay Ibraahiima jaabii mo, wi'i: ‹Hiɓe jogii ton deftere Muusaa nden e defte ɓeya annabaaɓe, yo ɓe heɗo ɗen.› ");
INSERT INTO fuf_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","«O wi'i: ‹Oo'o, yo baaba an Ibraahiima, kono si goɗɗo e mayɓe ɓen yahii e maɓɓe, ɓe tuubay.› ");
INSERT INTO fuf_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","«Kono Ibraahiima wi'i mo: ‹Si ɓe heɗaaki Muusaa e annabaaɓe heddiiɓe ɓen, haray ɓe jaɓataa wurteede hay si ɓe immintinanaama goɗɗo e mayɓe ɓen!› » ");
INSERT INTO fuf_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Iisaa wi'i taalibaaɓe mun ɓen: «Alaa no peggal ronkirta arirde, kono bone wonanii on wonɗo sabu ɗun. ");
INSERT INTO fuf_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Haray ko ɓuri mo moƴƴande ko kolmbireede tuntere hayre, o bugee ka baharu edii o wonude sabu gokkun e koy paykoy feggaade. ");
INSERT INTO fuf_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Reenee hoore mon! «Si musiɗɗo mon ooɲike, waajee mo. Si o tuubii, yaafee mo. ");
INSERT INTO fuf_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Awa kadi si o bonnii on laabi jeeɗiɗi e nder ɲallal, o yiltitoyike e mon laabi jeeɗiɗi hara himo wi'a: ‹mi tuubii›, on yaafoto mo.» ");
INSERT INTO fuf_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Sahaabaaɓe* ɓen wi'i Koohoojo on: «Ɓeydanee men gomɗinal.» ");
INSERT INTO fuf_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Onsay Koohoojo on wi'i ɓe: «Hay si tawii gomɗinal mon ngal no fota e abbere bene, harayno on waaway yamirde kii ndologahi, wi'on: ‹Ɓoro, iroyoɗaa ka tumbo baharu!›, onsay ki ɗoftoto on. ");
INSERT INTO fuf_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","«Hara ko hombo e mon, si no mari kurkaaduujo remoowo maa ngaynaako, wi'ata on no o iwtiri golle: ‹Aru ɲaamaa›? ");
INSERT INTO fuf_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Kono ka liddu ɗun, o wi'ay mo: ‹Moƴƴinanan ko mi ɲaama, ɓornoɗaa si ɓannanaa mi. Si mi gaynii ɲaamude yara, onsay an kadi a ɲaamay yaraa›. ");
INSERT INTO fuf_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Hara o mantay on kurkaaduujo fii o waɗii ko o yamiraa kon? ");
INSERT INTO fuf_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Onon kadi wano non, si on waɗii ko yamiraɗon kon fow, wi'ee: ‹Menen ko men kurkaaduuɓe meereeɓe, ko ko men haani waɗude tun men waɗi.› » ");
INSERT INTO fuf_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","E nder yaadu makko ndun Yerusalaam, kanko Iisaa o rewri hakkunde diiwal *Samariiya ngal e diiwal Jaliilu ngal. ");
INSERT INTO fuf_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Wa fewndo ko o naataynoo e hoɗo, yimɓe sappo ɓe ɗamajan nangi sutii fottugol e makko, ɓe dartii ka woɗɗi, ");
INSERT INTO fuf_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ɓe ewnii, ɓe wi'i: «Iisaa, ko onon yo Karamoko'en! Yurminee men!» ");
INSERT INTO fuf_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ɓay o yi'ii ɓe, o wi'i ɓe: «Yahee hollitoyoɗon *yottinooɓe sadaka ɓen.» E nder yaadu maɓɓe ndun ɓe tawi ɓe sellinaama, ɓe laaɓii. ");
INSERT INTO fuf_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ɓay goɗɗo e maɓɓe tawii sellinaama, o yiltitii e hoore himo ewnoo manta Alla. ");
INSERT INTO fuf_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Hawri on neɗɗo ko Samariyankeejo. O ari, o yani e ley koyɗe Iisaa, o weltanii mo. ");
INSERT INTO fuf_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Onsay Iisaa ƴetti haala kan, wi'i: «Hinaa ɓe sappoo non ɓe sellinaama, ɓe laaɓii? Awa ko honto njeenayooɓe luttuɓe ɓen woni? ");
INSERT INTO fuf_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Hinaa hay gooto e maɓɓe yiltitaaki fii mantugol Alla si wonaa oo janano ɗoo tun?» ");
INSERT INTO fuf_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Onsay o wi'i on: «Immo yahaa, gomɗinal maa ngal hisinii ma.» ");
INSERT INTO fuf_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ɲande goo *Fariisiyaaɓe ɓen landii mo kanko Iisaa ko honde tuma *laamu Alla ngun arata. Iisaa jaabii ɓe, wi'i: «Laamu Alla ngun ardataa no yi'orta. ");
INSERT INTO fuf_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Wi'etaake ‹hingu ɗoo!› maa ɗun ‹hingu ɗaa!›, ko fii mi andinii on, laamu Alla ngun no e mon.» ");
INSERT INTO fuf_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Onsay o wi'i taalibaaɓe makko ɓen: «Saa'i aroyay nde faaleteɗon yi'ude wootere e ɲalaaɗe *Ɓii-Aaden on, kono on yi'oytaa nde. ");
INSERT INTO fuf_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","On wi'oyte ‹himo ɗoo!› maa ‹himo ɗaa!› Wota on hammir ton, wota on dogir ton. ");
INSERT INTO fuf_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Awa ko wano maƴannde maƴirta non, jalba gila nano haa e ɲaamo ka weeyo, ko wano non ardu Ɓii-Aaden on woniroyta ka ɲalaande mun. ");
INSERT INTO fuf_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Kono ɗoo e ɗun, bee o tampa fota, nguu jamaanu ɗoo hawka mo. ");
INSERT INTO fuf_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","«Ko waɗunoo kon fewndo jamaanu Nuuhu, waɗoyay kadi ka ɲalaaɗe ado artugol Ɓii-Aaden on. ");
INSERT INTO fuf_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ko fii fewndo Nuuhu, hari yimɓe ɓen no ɲaamaynoo yara, no jomba jombanee, haa ɲande Nuuhu naatunoo ka laana. Onsay waamere nden ari, muli luttuɓe ɓen fow. ");
INSERT INTO fuf_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","«Ko wano non kadi e fewndo jamaanu Luutu, yimɓe ɓen no ɲaamaynoo yara, sooda soodita, tuta darna. ");
INSERT INTO fuf_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Kono nde Luutu yaltunoo *Saduuma, mbollan yiite iwruno ka kammu yani e maɓɓe, muli ɓe fow. ");
INSERT INTO fuf_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","«Ko wano non kadi woniroyta ɲande Ɓii-Aaden on feeɲiti. ");
INSERT INTO fuf_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Nden ɲande, on wonɗo ka fowtorde hoore suudu mun wota tippano piiji mun wonɗi ɗin ka nder suudu. Wano non kadi on wonɗo ka ngesa wota yiltito ka mun. ");
INSERT INTO fuf_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Anditee fii sonnaajo Luutu on. ");
INSERT INTO fuf_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Kala ɗaɓɓuɗo no dandira ngurndan mun, ɗan hayriray mo, kono kala non mo ngurndan mun hayrinaa, o dandoyay ɗan. ");
INSERT INTO fuf_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","«Mi andinii on kadi, e nden jemmaare ɗon, yimɓe ɗiɗo waaloduɓe e danki wooti, goɗɗo e maɓɓe ƴettete, oya on lutta. ");
INSERT INTO fuf_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Wano non kadi, rewɓe ɗiɗo wonɓe unidude, goɗɗo e maɓɓe ƴettete, oya on lutta. ");
INSERT INTO fuf_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Awa kadi yimɓe ɗiɗo wonduɓe e ngesa woota, gooto e maɓɓe ƴettete, oya on lutta.» ");
INSERT INTO fuf_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Taalibaaɓe ɓen wi'i mo: «Koohoojo amen, hara ko honto ɗun waɗoyta?» O jaabii ɓe, o wi'i: «Ko ka ko maayi kon woni woo, jigaaje ɗen mooɓotoo.» ");
INSERT INTO fuf_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Iisaa waɗani taalibaaɓe mun ɓen ngal misal fii ɓanginangol ɓe nafa duumagol e toraare Alla, hara ɓe haaɓaali. ");
INSERT INTO fuf_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","O wi'i ɓe: «No woodunoo e saare aaden ɲaawoowo mo hulataa Alla, awa kadi o hersataa hay gooto. ");
INSERT INTO fuf_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Tawi kadi no e nden saare keynguujo araynooɗo soono woo ka on ɲaawoowo, wi'a mo: ‹Ɲaawu hakkunde an e oo gaɲo an.› ");
INSERT INTO fuf_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Gila neeɓii hari on ɲaawoowo anniyaaki. Kono ɓawto ɗun o wi'itii: ‹Fii kala mi hulataa Alla, awa kadi mi hersataa hay gooto, ");
INSERT INTO fuf_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ɓay oo keynguujo sonjirii lan nii, yo mi ɲaawan mo fii wota o sonjan ɲande woo!› » ");
INSERT INTO fuf_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Koohoojo on wi'i: «On nanii ko on ɲaawoowo ɓoyliiɗo wi'i kon? ");
INSERT INTO fuf_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","E taw si hara Allaahu on ɲaawantaa ɓen ɓe o suɓii, ɗun ko ɓen torotooɓe mo jemma e ɲalorma? Hara o nennanay ɓe ɗun? ");
INSERT INTO fuf_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Mi andinii on, o ɲaawanay ɓe ko yaawi. Kono taw nde *Ɓii-Aaden on aroyi si o tawoyay gomɗinɓe e hoore ndii leydi?» ");
INSERT INTO fuf_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","O waɗi kadi ngal misal ɗoo e hoore ɓen yimɓe fellituɓe ko feewuɓe, hara hiɓe aybina ɓeya, ");
INSERT INTO fuf_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","o wi'i ɓe: «Yimɓe ɗiɗo yahuno ka *juulirde mawnde fii juulugol, tawi goɗɗo on ko *Fariisiyaajo, oya on ko ƴantoowo sagalle. ");
INSERT INTO fuf_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Fariisiyaajo on immii darii, tawi himo tororanaynoo nii hoore makko, wi'a: ‹Eyoo-maa Alla, mi weltanike ma ko tawi kon mi wa'aa wa heddiiɓe ɓen, ɗun ko ɓee jattooɓe maa ɓee ɓoyliiɓe maa ɓee jeenooɓe maa wano oo ƴantoowo sagalle ɗoo. ");
INSERT INTO fuf_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Min-le mi hooray laabi ɗiɗi e nder yontere nden, awa kadi mi ittay sappaɓun e hoore kala ko mi heɓi.› ");
INSERT INTO fuf_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","«Tawi on ƴantoowo sagalle hay suusataano ɓantirde gite mun ɗen ka kammu, kono himo darii ka woɗɗitii, himo tappitoo e ɓernde, wi'a: ‹Yaa an Alla, yurminan min oo junuubankeejo!› ");
INSERT INTO fuf_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","«Mi andinii on, ko on ƴantoowo sagalle ɗon-le yiltitinoo ka galle mun e hoore ko o jogoraaɗo wa feewuɗo edii Fariisiyaajo on. Ko fii kala mawnintiniiɗo jippinoyte, awa kadi kala jippinɗo hoore mun mawninoyte.» ");
INSERT INTO fuf_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Woɓɓe addanayno mo hay boobooɓe ɓen fii yo o meemu ɓe. Nde taalibaaɓe ɓen yi'unoo ɗun, ɓe toŋani ɓe. ");
INSERT INTO fuf_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Kono Iisaa nodditi paykoy koy e hoore himo wi'a: «Accee paykoy koy ara e an, wota on haɗu koy, ko fii *laamu Alla ngun ko sifa makkoy wonani. ");
INSERT INTO fuf_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ka haqiiqa mi andinii on, kala mo jaɓiraali laamu Alla ngun wa paykun, haray o naatataa ton few.» ");
INSERT INTO fuf_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Hooreejo goo landii Iisaa, wi'i: «Karamokoojo moƴƴo, hara ko honɗun mi haani waɗude fii yo mi heɓoy *ngurndan poomayankejan ɗan?» ");
INSERT INTO fuf_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Onsay Iisaa jaabii mo, wi'i: «Ko fii honɗun wi'irtaa mi moƴƴo? Hay gooto moƴƴaa si hinaa Alla Bajjo on. ");
INSERT INTO fuf_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Hiɗa andi yamirooje ɗen, ɗun ko wota a jeenu, wota a ittu hoore, wota a wujju, wota a seedito fenaande, teddinaa kadi yumma maa e ben maa.» ");
INSERT INTO fuf_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","On hooreejo jaabii, wi'i: «Miɗo waɗude ɗun fow gila e cukankaaku an.» ");
INSERT INTO fuf_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ɓay Iisaa nanii ko on wi'i kon, o wi'i mo: «No ŋakkan-maa fahin huunde wootere: yeeyitu kala ko jeyɗaa, senditanaa miskinɓe ɓen, ɗun wonanoyte keyee ka kammuuli, onsay araa jokkaa mi.» ");
INSERT INTO fuf_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ɓay on nanii ɗun, o aani, ko fii hari himo alɗi fota. ");
INSERT INTO fuf_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ɓay Iisaa yi'ii ɗun e makko, o wi'i: «Emba no sattani jom jawle en ka ɓe naata ka laamu Alla. ");
INSERT INTO fuf_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","No ɓuri weeɓande ngelooba ka mba rewa e wuddere meselal edii ka jom jawle en naata ka laamu Alla.» ");
INSERT INTO fuf_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Wonnooɓe mo heɗaade ɓen wi'i: «E hara ko hombo dandoytee?» ");
INSERT INTO fuf_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Iisaa jaabii ɓe, wi'i: «Ko waawantaako neɗɗanke kon no waawanoo Alla.» ");
INSERT INTO fuf_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Onsay Petruusu wi'i mo: «Awa e hino, men accii ko men jeyi kon fow, men jokkii on.» ");
INSERT INTO fuf_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Iisaa jaabii ɓe, wi'i: «Ka haqiiqa mi andinii on, kala accuɗo suudu mun ndun e ɓeyngu mun e siɓɓe mun ɓen e mawɓe mun ɓen e ɓiɓɓe mun ɓen sabu laamu Alla ngun, ");
INSERT INTO fuf_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","o heɓoyay ko ɓuri ɗun ka aduna ɗoo, awa kadi ka aduna aroyoowo, o heɓoyay ngurndan poomayankejan ɗan.» ");
INSERT INTO fuf_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Onsay Iisaa pottini *sahaabaaɓe mun ɓen sappoo e ɗiɗo sera, o wi'i ɓe: «Awa hiɗen yahude Yerusalaam. Kala ko annabaaɓe ɓen windunoo kon e hoore Ɓii-Aaden on laatoyto. ");
INSERT INTO fuf_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","O wattoyte e juuɗe ɓe wonaa Yahuudiyanke ɓen, o jalee, o tiwee, tuttee e hoore makko, ɓe piyira mo cabbi, ɓe wara. ");
INSERT INTO fuf_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ɓawto ɗun o immitoo ka ɲalaande tammere.» ");
INSERT INTO fuf_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Kono ɓen taalibaaɓe faamaali hay fus e ɗun, ɗin konguɗi wirnanii ɓe, ɓe ronki faamude kon ko yewtaa. ");
INSERT INTO fuf_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ko Iisaa ɓadii Yeerikoo, tawi bunɗo no jooɗii ka sera laawol no toroo. ");
INSERT INTO fuf_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","On nani hito jamaa on ko feƴƴata kon, o landii ko honɗun waɗi. ");
INSERT INTO fuf_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","O andinaa wonde ko Iisaa oo jeyaaɗo Naasirata woni feƴƴude. ");
INSERT INTO fuf_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Onsay o ewnii, o wi'i: «Ko an yo Iisaa, ɓii Daawuuda, yurminan!» ");
INSERT INTO fuf_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Hikkinooɓe yeeso ɓen feli mo fii yo o fanku, kono o ɓurti ewnaade, wi'a: «Ko an yo ɓii Daawuuda, yurminan!» ");
INSERT INTO fuf_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Onsay Iisaa dartii, o yamiri yo ɓe addan mo mo. Ɓay on ɓadike, Iisaa landii mo: ");
INSERT INTO fuf_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«Ko honɗun faalaɗaa yo mi waɗane?» On jaabii mo, wi'i: «Koohoojo, ko yo mi hettu giiɗe an ɗen!» ");
INSERT INTO fuf_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Onsay Iisaa jaabii mo, wi'i: «Wuntu, gomɗinal maa ngal hisinii ma.» ");
INSERT INTO fuf_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","O wunti ɗon kisan, o jokki Iisaa, himo mawnina Alla. Ɓay jamaa on yi'ii ɗun, ɓe woni e mantugol Alla. ");
INSERT INTO fuf_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Iisaa naati Yeerikoo. Ko o taƴitata saare nden, ");
INSERT INTO fuf_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","tawi aaden galo tawaaɗo e hooreeɓe ƴantooɓe sagalle ɓen wi'eteeɗo Zaakaru ");
INSERT INTO fuf_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","no humpanoo yi'ugol mo kanko Iisaa. Kono o ronki feere mun sabu ɗuuɗugol jamaa on, awa kadi himo raɓɓiɗi. ");
INSERT INTO fuf_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Onsay o dogi o feƴƴi yeeso, o ƴawoyi e hoore ƴibbehi fii no o yi'ira Iisaa, ɓay hari on ko ɗon rewata. ");
INSERT INTO fuf_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Nde Iisaa hewtunoo e ley kin ƴibbehi, o tiggitii, o wi'i: «Zaakaru, tippo heɲa, ko fii bee mi weera hande ka galle maa.» ");
INSERT INTO fuf_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zaakaru tippii heɲa, jaɓɓii mo e nder weltaare. ");
INSERT INTO fuf_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ɓay fow yi'ii ɗun, ɓe ŋuni, ɓe wi'i: «Oo koɗoyike junuubankeejo!» ");
INSERT INTO fuf_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Kono Zaakaru immii darii, wi'i Koohoojo on: «Heɗee yo Koohoojo an, mi okkay miskinɓe ɓen feccere jawdi an ndin. Awa kadi si miɗo bonnani goɗɗo goɗɗun, mi yoɓitiray ontigi ɗun cowalle nay.» ");
INSERT INTO fuf_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Onsay Iisaa wi'i: «Hande kisiyee naatii e ɗee galle ɗoo. Ko fii oo ɗoo kadi ko o iwdi Ibraahiima. ");
INSERT INTO fuf_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Awa ko addi *Ɓii-Aaden on ko ɗaɓɓitugol majjuɓe ɓen, danda ɓe.» ");
INSERT INTO fuf_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ɓay hari o ɓadike Yerusalaam, o ɓeyditani ɓe ngal misal ɗoo, ko fii hari heɗinooɓe mo ɓen no sikka *laamu Alla ngun feeɲay kisan. ");
INSERT INTO fuf_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","O wi'i ɓe: «Aaden dimo yahuno e leydi woɗɗundi fii lamminoyegol, arta. ");
INSERT INTO fuf_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","On noddi kurkaaduuɓe mun sappo, o jonni ɓe manankunji sappo. O wi'i ɓe: ‹Gollitiree ɗii ɗoo haa mi ara.› ");
INSERT INTO fuf_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Kono tawi yimɓe leydi makko ndin no aɲi mo. Ɓe nelti woɓɓe ɓaawo makko fii andingol ɓen ton wonde ɓe faalaaka onɗon laamoo ɓe. ");
INSERT INTO fuf_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","«Ɓay o lamminoyaama, o artii, o nodditi kurkaaduuɓe makko ɓe o jonnunoo mbuuɗi ɓen fii no o andira ko honno mo bee e maɓɓe gollitiriri ɗi. ");
INSERT INTO fuf_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","«Arano on e maɓɓe ari, wi'i: ‹Koohoojo an, ɗi accirnoɗon mi ɗin ɓeydike cowalle sappo.› ");
INSERT INTO fuf_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","O wi'i mo: ‹A waɗii ko moƴƴi, yo kurkaaduujo moƴƴo! Ko fii a nunɗii e hoore ko fanɗi, mi waɗii ma yeesoojo e hoore ca'e sappo.› ");
INSERT INTO fuf_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","«Ɗimmo on e maɓɓe ari, wi'i: ‹Koohoojo an, ɗi accirnoɗon mi ɗin ɓeydike cowalle jowi.› ");
INSERT INTO fuf_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","O wi'i onɗon kadi: ‹Mi waɗii ma e hoore ca'e jowi.› ");
INSERT INTO fuf_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","«Goɗɗo e maɓɓe kadi ari, wi'i: ‹Koohoojo an, e hino ɗi accirnoɗaa mi ɗin, hari miɗo mari ɗi e lincun. ");
INSERT INTO fuf_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ko fii hari miɗo hulu maa, ɓay ko a ɲaaɗuɗo. A ƴettay ko a wallinaa, awa kadi a soɲitay ko a aawaa.› ");
INSERT INTO fuf_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","«Onsay on lanɗo wi'i mo: ‹Mi ɲaawitirte konguɗi maa ɗin, yo jiyaaɗo bonɗo! Hiɗa andunoo ko mi aaden ɲaaɗuɗo? Maa mi ƴettay ko mi wallinaa, maa mi soɲitay ko mi aawaa? ");
INSERT INTO fuf_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Fii honɗun non a wallinaali ɗi e juuɗe gollitirooɓe ɗi ɓen, ɗun, nde mi artunoo woo, mi hettayno ɗi e hoore tono.› ");
INSERT INTO fuf_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","«Ontuma kanko lanɗo on o wi'i wonnooɓe ɗon ɓen: ‹Jaɓitee ɗi e juuɗe makko, jonnon ɗi oo jogiiɗo manankunji sappo.› ");
INSERT INTO fuf_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Kono ɓe wi'i mo: ‹Koohoojo amen, onɗon no jogii manankunji sappo!› ");
INSERT INTO fuf_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","O jaabii ɓe, o wi'i: ‹Mi andinii on, ko marɗo ɓeydantee, kono mo maraa on jaɓitante hay yeru ko o mari kon. ");
INSERT INTO fuf_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ɗun-le wurin addanee lan ɗoo ayɓe an ɓen, ɓen ɓe faalanooka mi laamoo ɗun, waron ɓe yeeso an ɗoo.› » ");
INSERT INTO fuf_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ɓay kanko Iisaa o gaynii yewtude ɗun, o hikkii yeeso, o yaari Yerusalaam. ");
INSERT INTO fuf_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ɓay wonii o ɓadike Bayti-Faazii e *Betanii, ɗun ko takko Fello *Zaytuuni ngon, o nuli taalibaaɓe makko ɗiɗo, ");
INSERT INTO fuf_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","o wi'i ɓe: «Yahee e ngoo hoɗo wongo yeeso mon ɗoo. No naatirɗon e maggo, on taway mbabun kun goɗɗo waɗɗaaki haa hande no humii ɗon. Hunton kun, addon. ");
INSERT INTO fuf_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Si goɗɗo aru on e landaade, wi'a: ‹Ko honɗun huntanɗon kun?›, on wi'ay mo: ‹Ko haaju Koohoojo on yani e makkun.› » ");
INSERT INTO fuf_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Nelaaɓe ɓen yahi ɓe tawroyi no ɓe wiiranoo non. ");
INSERT INTO fuf_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ko ɓe huntata kun, jeyɓe mbabun kun ɓen wi'i ɓe: «Ko honɗun wonɗon kun huntande?» ");
INSERT INTO fuf_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ɓe jaabii, ɓe wi'i: «Ko haaju Koohoojo on yani e makkun.» ");
INSERT INTO fuf_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ɓe addani kun Iisaa, ɓe ndaɗɗani mo conci maɓɓe ɗin e hoore makkun si ɓe ƴawni mo. ");
INSERT INTO fuf_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","No o yaaraynoo non, yimɓe ɓen no ndaɗɗirande mo non conci mun ɗin ka laawol. ");
INSERT INTO fuf_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Nde tawnoo o ɓadike Yerusalaam ka tippagol Fello Zaytuuni, dental taalibaaɓe ɓen fow sowti weltaare, ɓe woni e ewnagol manta Alla, sabu ɗii kaawakeeji moƴƴi ɗi ɓe yi'i. ");
INSERT INTO fuf_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Tawi hiɓe wi'a: «Yo barki wonan oo lanɗo wonɗo arude e innde Joomiraaɗo on. Yo ɓuttu wonu ka kammu, darja ɓurɗo toowude wonanii ma!» ");
INSERT INTO fuf_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Woɓɓe e *Fariisiyaaɓe tawaaɓe e mbatu ngun ɓen wi'i mo kanko Iisaa: «Karamoko'en, yamiree taalibaaɓe mon ɓen yo ɓe fanku!» ");
INSERT INTO fuf_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","O jaabii ɓe, o wi'i: «Mi andinii on, si kamɓe ɓe fankii, kaaƴe ɗen sowtay!» ");
INSERT INTO fuf_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ɓay ɓe ɓadike saare Yerusalaam nden, nde Iisaa haynornoo nde, o fesi fii mayre, ");
INSERT INTO fuf_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","o wi'i: «Si an kadi hiɗa andunoo hande ko wonanayno-maa ɓuttu, kono jooni ɗun wirnanike ma. ");
INSERT INTO fuf_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Aroyay e ɲalaaɗe nde ayɓe maa ɓen ari hunditu-maa hurgi, ɓittire cenɗe fow. ");
INSERT INTO fuf_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ɓe lancete, ɓe lancide e kala hoɗuɗo e maa. Ɓe accataa e maa hay kaaƴun e hoore hayre, sabu a anditaali saa'i mo Alla hoddiri faabagol ma on.» ");
INSERT INTO fuf_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","O naati ka dingiral *juulirde mawnde, o woni e raɗagol wonnooɓe yeeyude ton ɓen, ");
INSERT INTO fuf_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","hara himo wi'ora ɓe: «No windii: ‹Suudu an ndun ko suudu torordu Alla›, kono onon on wattii ndu fammeere wuyɓe!» ");
INSERT INTO fuf_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Tawi kanko Iisaa ɲande woo o jannayno ka juulirde mawnde. Kono hooreeɓe *yottinooɓe sadaka ɓen e jannooɓe fii Sariya on ɓen e lamɓe jamaa on no ɗaɓɓaynoo no sahinbinira mo. ");
INSERT INTO fuf_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Kono hari ɓe andaa ko honno ɓe gerdata, sabu hari jamaa on fow no tuɗi noppi mun e makko. ");
INSERT INTO fuf_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","E nder ɗen balɗe ɗon, tawi Iisaa no waajaade jamaa on ka *juulirde mawnde, ɗun-le ko feɲɲinangol ɓe Kibaaru Moƴƴo on. Onsay hooreeɓe *yottinooɓe sadaka ɓen e jannooɓe fii Sariya on ɓen wondude e mawɓe ɓen ari, ");
INSERT INTO fuf_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","wi'i mo: «Wowlan men ko e ley kongol hombo wonɗaa waɗude ɗun e ko e ley kongol hombo wonɗaa?» ");
INSERT INTO fuf_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","O jaabii ɓe, o wi'i: «Min kadi mi landoto on huunde wootere, jaaboɗon mi. ");
INSERT INTO fuf_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","E hara lootugol ko Yaayaa lootaynoo yimɓe ɓen kon, ko ka arsi iwri kaa ko e neɗɗanke?» ");
INSERT INTO fuf_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Kono ɓen woni e wi'indirgol: «Si en jaabike mo ko ka arsi iwri, o wi'ay en ko honɗun haɗunoo gomɗinen mo? ");
INSERT INTO fuf_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Si en jaabike mo-le ko e neɗɗanke ɗun iwri, jamaa on fow fiɗay en kaaƴe, sabu hiɓe felliti Yaayaa ko annabaajo.» ");
INSERT INTO fuf_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Onsay ɓe jaabii mo, ɓe wi'i: «Men andaa ka ngol lootugol ɗon iwri.» ");
INSERT INTO fuf_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Onsay Iisaa wi'i ɓe: «Min kadi mi wowlantaa on ko e ley kongol hombo mi woni waɗirde ɗun.» ");
INSERT INTO fuf_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ontuma o fewtiti jamaa on, o waɗani ɓe ngal misal ɗoo, o wi'i ɓe: «Goɗɗo tutuno *wiiɲu, o halfini tutateeri ndin remooɓe wiiɲu ɓen, o yahi safaari ka o neeɓoyta. ");
INSERT INTO fuf_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ɓay saa'i soɲitugol wiiɲu on hewtii, o immini kurkaadu makko haa e remooɓe wiiɲu ɓen fii yo ɓen jonnan mo ɓiɓɓe wiiɲu geɓal makko ngal. Kono ɓen piyi on, ɓe immintini mo juuɗe mehe. ");
INSERT INTO fuf_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","O immini kurkaadu makko goo kadi, ɓe piyi onɗon kadi, ɓe hersini, ɓe immintini mo juuɗe mehe. ");
INSERT INTO fuf_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","O immini tammo kadi, ɓe barmini onɗon kadi, ɓe raɗii. ");
INSERT INTO fuf_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","«Jom tutateeri ndin wi'i: ‹Ko honɗun mi waɗata jooni? Yo mi immin ɓiɗɗo an yiɗaaɗo on, no gasa ka ɓe teddinoya onɗon.› ");
INSERT INTO fuf_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Kono no ɓen remooɓe wiiɲu haynornoo mo, ɓe wi'indiri: ‹Ko oo woni ronoowo on, waren mo fii yo ndondi ndin wontan en!› ");
INSERT INTO fuf_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Onsay ɓe naɓi mo ka ɓaawo tutateeri, ɓe wari.» Iisaa wi'i kadi: «Jooni non, hara ko honɗun jom ndin tutateeri wiiɲu waɗata ɓen? ");
INSERT INTO fuf_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","On aray, re'a ɓen remooɓe wiiɲu, o halfina ndi woɓɓe goo.» Ɓay ɓen heɗinooɓe mo kanko Iisaa nanii ɗun, ɓe wi'i: «Wota ɗun wonir non!» ");
INSERT INTO fuf_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","E nder ko o tenƴinta ɓe kon, kanko Iisaa, o wi'i: «Hara ko honɗun koo ko windii firi: ‹Hayre nde mahooɓe ɓen hawkunoo nden wontii hittunde ka soɓɓundu›? ");
INSERT INTO fuf_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","«Awa kala yanuɗo e nden hayre, o lancoto, kala kadi mo nde yani e hoore mun, o muncoto.» ");
INSERT INTO fuf_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ɓay hooreeɓe yottinooɓe sadaka ɓen e jannooɓe fii Sariya on ɓen faamii wonde ko e hoore maɓɓe Iisaa waɗi ngal misal, tawi hiɓe ɗaɓɓude no ɓe fawira juuɗe e makko ɗon kisan, kono hari hiɓe huli jamaa on. ");
INSERT INTO fuf_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ɓe woni e aynugol Iisaa, ɓe immini e makko tefooɓe bonɓe waɗitiiɓe ko feewuɓe fii ko nangira mo konguɗi makko ɗin, watta mo e juuɗe laamu ngun e ley kongol lamminaaɗo diiwal ngal. ");
INSERT INTO fuf_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ɓen landii mo, wi'i: «Karamoko'en, meɗen andi hiɗon jannude waajoo no feewiri, awa kadi on ɓurdindinaa yimɓe ɓen, hiɗon jannirde laawol Alla ngol goonga. ");
INSERT INTO fuf_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","E hara no haani ka men yoɓa lanɗo mawɗo Roomu on sagalle kaa haanaa?» ");
INSERT INTO fuf_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Kono ɓay Iisaa faamii janfa maɓɓe kan, o jaabii ɓe, o wi'i: ");
INSERT INTO fuf_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«Hollee lan *dinaruuru. Ko nandolla hombo e bindi hombo woni e mayru?» Ɓe jaabii: «Ko lanɗo mawɗo Roomu on.» ");
INSERT INTO fuf_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Onsay o jaabii ɓe, o wi'i: «Jonnitee lanɗo mawɗo Roomu on ko makko kon, jonniton Alla kadi ko mun kon.» ");
INSERT INTO fuf_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ɓe ronki heɓude feere no ɓe nangira mo e ɗin konguɗi makko yeeso jamaa on, kono ɓay ɓe ŋalɗidii e ngol jaabawol makko, ɓe deƴƴi. ");
INSERT INTO fuf_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Woɓɓe e ɓee *Sadduusiyaaɓe, wi'uɓe wonde ummutal alaa ɓen, ari landii Iisaa, ɓe wi'i mo: ");
INSERT INTO fuf_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","«Karamoko'en, e hino ko Muusaa wi'i men kon: Si goɗɗo maayii accii ɓeyngu e ɓaawo ɓiɗɗo, haray miɲɲiraawo on mayɗo no haani ƴettude on keynguujo mo o acci fii no o heɓirana on kotiraawo makko jurriya. ");
INSERT INTO fuf_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Tawa non no woodi ɓiɓɓe njeeɗiɗo. Arano on jombii, maayii, heɓaali ɓiɗɗo. ");
INSERT INTO fuf_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ɗimmo on kadi ƴettii mo, maayii. ");
INSERT INTO fuf_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Tammo on kadi wano non. Ɗun yaarii non haa ɓen njeeɗiɗo non ɓe timmi, ɓe accaali jurriya. ");
INSERT INTO fuf_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ɓawto ɗun debbo on kadi maayii. ");
INSERT INTO fuf_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ɓay hari ɓen njeeɗiɗoo non resii on debbo, ko hombo e ɓen on debbo wontanoyta ka ummutal?» ");
INSERT INTO fuf_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Iisaa jaabii ɓe, wi'i: «Fayɓe nguu jamaanu ɗoo tiggay tiggete. ");
INSERT INTO fuf_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Kono ɓen yeɗoyaaɓe immintineede e hakkunde mayɓe ɓen e tawegol e nguu jamaanu aroyayngu, resoytaa, resetaake. ");
INSERT INTO fuf_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Awa kadi ɓe maayitoytaa, ko fii haray hiɓe wa'i wa malaa'ikaaɓe. Ko ɓe fayɓe Alla kadi, ɓay ko ɓe ɓiɓɓe ummutal ngal. ");
INSERT INTO fuf_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Seedee mayɓe ɓen immitoto, ko ɗun Muusaa ɓanginnoo ka o wowli ɗon fii pitahun kun fewndo o noddi Joomiraaɗo on, on Alla Ibraahiima e Alla Issaaqa e Alla Yaaquuba. ");
INSERT INTO fuf_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Awa Alla wonaa Alla mayɓe ɓen, kono ko o Alla wurɓe ɓen, ɓay fii makko kanko, ɓen fow ko wurɓe.» ");
INSERT INTO fuf_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Woɓɓe e jannooɓe fii Sariya on ɓen wi'i mo: «Karamoko'en, on yewtii haqiiqa.» ");
INSERT INTO fuf_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ɓawto ɗun ɓe suusaali mo landaade hay huunde. ");
INSERT INTO fuf_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Iisaa wi'i ɓe: «Ko honno wi'iraa wonde *Almasiihu on ko jurriya Daawuuda? ");
INSERT INTO fuf_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Daawuuda tigi no holli ka Zabuura wonde: ‹Joomiraaɗo on daalani Joomi an on: Jooɗor ka sengo an ɲaamo haa mi waɗa ayɓe maa ɓen ka ley teppe maa.› ");
INSERT INTO fuf_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","«Daawuuda tigi wi'ii Almasiihu on ‹Joomi›, haray ko honno non Almasiihu on woniri jurriya makko?» ");
INSERT INTO fuf_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Fewndo ka yimɓe ɓen fow heɗii mo ɗon, o wi'i taalibaaɓe makko ɓen: ");
INSERT INTO fuf_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«Reenee e ɓee jannooɓe fii Sariya on, ɗun ko ɓee yiɗuɓe jindidugol e dolokkaaji njani, yiɗi hiwreede ka fottirɗe, yiɗi saffawol aranol ngol ka juulirɗe, yiɗi ndaɗɗule arane ɗen ka nafagol. ");
INSERT INTO fuf_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Hiɓe jatta galleeji keynguuɓe, hiɓe juutina julɗe maɓɓe fii yiingo, awa ɓen heɓoyay ɲaawooje ɓurɗe sattuɗe.» ");
INSERT INTO fuf_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Onsay Iisaa ɓanti gite mun ɗen, o yi'i alɗuɓe no itta sadakaaji, watta ka nder arkawal sadaka. ");
INSERT INTO fuf_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","O yi'i kadi keynguujo baaso no liɓa ton tammahoy ɗiɗoy. ");
INSERT INTO fuf_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Onsay o wi'i: «Miɗo haalande on goonga, oo keynguujo baaso no ɓuri ɓeya fow ko ittaa. ");
INSERT INTO fuf_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ko fii ɓeya fow ko ko ɓurtani ɗun kon ɓe waɗi, kono kanko keynguujo on e waasiɗude, ko ko o mari kon fow fii ko o wuurira o waɗoyi ton.» ");
INSERT INTO fuf_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Nde tawnoo woɓɓe no yewta fii *juulirde mawnde nden e kon ko nde fotiniraa kaaƴe labaaɗe e piiji ittaaɗi sadaka, onsay Iisaa wi'i ɓe: ");
INSERT INTO fuf_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","«Ɲalaaɗe no ara nde tawata koo ko yi'oton ɗoo fow lancaama, hay hayre e hoore hayre luttoytaa ɗoo.» ");
INSERT INTO fuf_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Onsay ɓe landii mo, ɓe wi'i: «Karamoko'en, ko honde tuma ɗun waɗoyta e ko honɗun wonoyta maande laatagol ɗun?» ");
INSERT INTO fuf_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Iisaa jaabii ɓe, wi'i: «Reenee e faljineede, ko fii buy aroyay ɓaarora innde an nden hara no wi'a ko kaɲun woni *Almasiihu on, saa'i on ɓadike. Wota on jokkoy ɓen. ");
INSERT INTO fuf_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Awa kadi nde nanoyɗon fii hareeji e murtaldu woo, haray wota on hulu. Ko fii ko ɗun haani adaade waɗude, kono lannoode nden hinaa ɗon kisan.» ");
INSERT INTO fuf_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","O wi'i ɓe kadi: «Hareeji waɗoyay hakkunde leƴƴi ɗin. Laamateeriiji ɗin kadi immondirana. ");
INSERT INTO fuf_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Awa kadi dimbanɗe leydi tiiɗuɗe waɗa, heege e ɲabbeeli raaɓooji waɗa e nokkeeli goo, kaawakeeji hulbiniiɗi waɗa, maandeeji njani kadi waɗa ka kammu. ");
INSERT INTO fuf_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","«Kono ɗoo e ɗun, ɓe faway on juuɗe, ɓe cukkoo on, ɓe naɓoyay on ka juulirɗe, ɓe bugoo on ka kaso, ɓe ardoo on haa e lamɓe ɓen e yeesooɓe diiwe ɗen sabu innde an nden. ");
INSERT INTO fuf_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Kono ɗun wonanoyay on sabu no seeditoron. ");
INSERT INTO fuf_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Fiɓee ka ɓerɗe mon wonde on hebulotaako jaabagol ko liddeteɗon kon. ");
INSERT INTO fuf_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ko fii mi okkoyay on faamu, mi longina on konguɗi haa ka tawata ayɓe mon ɓen waawataa dartaade on maa yedda. ");
INSERT INTO fuf_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Awa hay mawɓe mon ɓen e neene-gootooɓe mon ɓen e siɓɓe mon ɓen e yiɓɓe mon ɓen waɗoyay on e joge ɓe wona sabu woɓɓe e mon waree. ");
INSERT INTO fuf_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Fow aɲoyay on sabu innde an nden. ");
INSERT INTO fuf_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Kono cukulol hoore mon hay gootol majjoytaa. ");
INSERT INTO fuf_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Kono si on ŋaɲɲike, haray on hiwii wonkiiji mon ɗin. ");
INSERT INTO fuf_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","«Nde yi'uɗon koneeli ɗin daakanike saare Yerusalaam nden haa hunditii woo, haray andee lancagol mayre ɓadike. ");
INSERT INTO fuf_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Onsay yo hoɗuɓe ka diiwal Yahuuda ɓen dogir ka pelle, yo wonɓe ka nder saare Yerusalaam ɓen kadi yaltu. Wota wonɓe ka fulawaa ɓen kadi aru ka saare. ");
INSERT INTO fuf_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ko fii ɗen wonoyay ɲalaaɗe yottanɗe fii laatingol kala ko windinoo. ");
INSERT INTO fuf_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","E nder ɗen balɗe ɗon, bone wonanay sowiiɓe ɓen e muyninayɓe ɓen. Ko fii annde tiiɗunde waɗay e leydi ndin, tikkere yana e hoore oo jamaa. ");
INSERT INTO fuf_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ɓe liɓiroyee mbelndi kaafa, ɓe naɓee, ɓe maccindinanoyoo leyɗe ɗen fow. Ɓe wonaa Yahuudiyanke ɓen yaaɓita Yerusalaam haa saa'iiji ɗi ɓe happanaa ɗin timma. ");
INSERT INTO fuf_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","«Awa kadi maandeeji waɗoyay ka naange e ka lewru e ka koode. Jamaaji ɗin maapoo ka hoore leydi haa ɓe jiɓoo ko ɓe waɗa sabu uumaango ndiyan ɗan ka baharu e ko ɗan piyondirta kon. ");
INSERT INTO fuf_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Yimɓe ɓen faɗɗee kulol e nder ko ɓe miijotoo fii ko aroyta ka hoore leydi kon, ko tiiɗi kon ka kammu kadi dimboyoo.› ");
INSERT INTO fuf_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ontuma non *Ɓii-Aaden on yi'oyte, no ara e duulere, hara himo arda e bawgal e mangural mawngal. ");
INSERT INTO fuf_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Nde ɗun fuɗɗii waɗude woo, haray ɓantee townon ko'e mon ɗen, ko fii haray kisiyee mon on ɓadike.» ");
INSERT INTO fuf_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Onsay o waɗani ɓe ngal misal ɗoo, o wi'i ɓe: «Ndaaree kii ƴibbehi maa leɗɗe goo. ");
INSERT INTO fuf_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","No ɗe wilitiri, on andanay hoore mon wonde setto ngon ɓadike. ");
INSERT INTO fuf_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ko wano non kadi, no yiiruɗon ɗii piiji no waɗa woo, haray andee wonde *laamu Alla ngun ɓadike. ");
INSERT INTO fuf_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ka haqiiqa mi andinii on, ɗun fow waɗay ado nguu jamaanu feƴƴude. ");
INSERT INTO fuf_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Kammu ngun e leydi ndin feƴƴay, kono min konguɗi an ɗin feƴƴataa. ");
INSERT INTO fuf_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","«Reenee hoore mon fii wota ɓerɗe mon ɗen heewu anndeeji aduna maa faale ɲaamugol yara haa ɓetoo, haa nde ndee ɲalaande mawnde juhirta on wa pircol. ");
INSERT INTO fuf_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ko fii nde hewtay e hoore kala wonɗo e ndelo oo aduna. ");
INSERT INTO fuf_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Findinee hakkillaaji mon ɗin saa'i woo saa'i, toroɗon fii no heɓiron doole daɗugol ɗin piiji waɗoyayɗi, e fii no daroroyoɗon yeeso Ɓii-Aaden on.» ");
INSERT INTO fuf_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Tawi e nder ɲalle ɗen, Iisaa waajotono ka juulirde mawnde, o waaloya jemma e hoore ngoo fello wi'eteengo *Zaytuuni. ");
INSERT INTO fuf_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Jamaa on fow dawrayno ka juulirde mawnde fii heɗagol mo kanko Iisaa. ");
INSERT INTO fuf_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Hari *Juldeere Bireedi ɗe Aldaa e Lewen nden ɓadike, nden no wi'ee kadi *Juldeere Yawtaneede. ");
INSERT INTO fuf_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Tawi hooreeɓe *yottinooɓe sadaka ɓen e jannooɓe fii Sariya on ɓen no ɗaɓɓaynoo feere no ɓe mulira Iisaa, kono tawi hiɓe huli jamaa on. ");
INSERT INTO fuf_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Onsay Ibuliisa naati e ɓernde Yudaasi, ɗun ko oo jammaaɗo Iskariiyu, on ko tawaaɗo e *sahaabaaɓe Iisaa ɓen sappoo e ɗiɗo. ");
INSERT INTO fuf_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","On yahi yewtidoyi e hooreeɓe yottinooɓe sadaka ɓen wondude e halfinaaɓe aynugol *juulirde mawnde nden fii no o wattira Iisaa e juuɗe maɓɓe. ");
INSERT INTO fuf_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ɓen weltori ɗun, ɓe haldi yeenugol mo kaalisi. ");
INSERT INTO fuf_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","O jaɓi ɗun, o woni e ɗaɓɓugol feere no o wattira Iisaa e juuɗe maɓɓe, hara jamaa on hoyɗaali. ");
INSERT INTO fuf_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ɓay ɲalaande Juldeere Bireedi ɗe Aldaa e Lewen nden hewtii, ɗun ko ɲalaande hirsanteende baalun nden, ");
INSERT INTO fuf_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","onsay Iisaa immini Petruusu e Yuuhanna, o wi'i ɓe: «Yahee moƴƴinanon en nafakka fii ko nafoɗen ka juldeere.» ");
INSERT INTO fuf_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ɓen wi'i mo: «Ko honto faalaɗon yo men moƴƴinanoy en ɗun?» ");
INSERT INTO fuf_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Onsay o wi'i ɓe: «No naatirɗon ka saare, on fottay e gorko rondiiɗo loonde ndiyan. On jokkay mo haa e suudu ndu o naati e mun woo. ");
INSERT INTO fuf_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Onsay on wi'ay jom suudu ndun: ‹Karamoko'en wi'ii men yo men lando on: Ko e suudu hondu ɓe nafodata e taalibaaɓe maɓɓe ɓen nafakka Juldeere Yawtaneede nden?› ");
INSERT INTO fuf_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ontuma o hollay on konkooru njanndu weƴƴitaandu ka koore dow. Ko ɗon moƴƴinton.» ");
INSERT INTO fuf_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ɓe yahi ɓe tawroyi no o haalirannoo ɓe non, ɓe moƴƴini nafakka juldeere nden. ");
INSERT INTO fuf_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ɓay saa'i on hewtii, Iisaa ɓadii fii nafagol wondude e sahaabaaɓe ɓe o toɗɗinoo ɓen sappoo e ɗiɗo. ");
INSERT INTO fuf_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Onsay o wi'i ɓe: «Miɗo faalanoo fota hawtidugol e mon oo nafakka ado mi tampude. ");
INSERT INTO fuf_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ko fii mi andinii on, mi ɲaamitataa oo nafakka ndee juldeere hande kadi haa nde laatoyoo ka *laamateeri Alla.» ");
INSERT INTO fuf_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Onsay o ƴetti jardukun waɗorkun njaram, o jarni Alla, o wi'i: «Jaɓee kun jardukun njaram, senditon hakkunde mon. ");
INSERT INTO fuf_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ko fii mi andinii on, mi yaritataa hande kadi njaram ɓiɓɓe wiiɲu haa tuma laamateeri Alla ndin ari.» ");
INSERT INTO fuf_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ɓawto ɗun o ƴetti kadi bireedi, o jarni Alla, o taƴiti, o jonni ɓe, o wi'i: «Ɗunɗoo ko ɓandu an ndu okkaɗon ndun nii, waɗee ɗunɗoo maande ko anditiron fii an.» ");
INSERT INTO fuf_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ko wano non kadi, ɓay ɓe gaynii ɲaamude, o ƴetti jardukun waɗorkun njaram, o wi'i: «Kun jardukun ko maande fii *ahadi heyri tippundi e ɗan ƴiiƴan an hibboyteeɗan fii mon. ");
INSERT INTO fuf_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Kono non janfotooɗo lan on no ɲaamidude e an. ");
INSERT INTO fuf_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ɓii-Aaden* on no yahude wano muuyiranoo non, kono bone wonanii on janfotooɗo mo!» ");
INSERT INTO fuf_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Onsay ɓe woni e landondirgol, wi'a: «Hara ko hombo e men waɗoyta ɗun?» ");
INSERT INTO fuf_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Yeddondiral waɗi hakkunde maɓɓe fii andugol ko hombo e maɓɓe gasata wonude mawɗo. ");
INSERT INTO fuf_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Onsay Iisaa wi'i ɓe: «Lamɓe ɗiya leƴƴi no laamori ɗi doole, ɓen laamiiɓe no wi'aa waɗooɓe ko moƴƴi. ");
INSERT INTO fuf_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Kono onon, wota on wa'u wa ɓen. Ɓurɗo teddude on e mon, yo wa'u wa suka. Awa kadi lanɗo on, yo wa'u wa kurkaadu. ");
INSERT INTO fuf_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Hara ko hombo ɓuri teddude hakkunde wonɗo nafaade on e wonɗo ɓannude nafakka on? Hinaa wonɗo nafaade on? Min-le non, miɗo woniri hakkunde mon wa on ɓannoowo. ");
INSERT INTO fuf_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Onon-le, ko onon wondunoo e an e nder ɗii tampereeji an fow. ");
INSERT INTO fuf_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ko ɗun waɗi si mi lamminiray on wano Baaba an lamminirimmi non, ");
INSERT INTO fuf_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","fii no ɲaamiroyon yaron ka ndaɗɗudi an, ɗun ko ka nder laamateeri an, jooɗoɗon kadi ka julle laamu fii laamoyagol *bolondaaji Isra'iila ɗin sappoo e ɗiɗi.» ");
INSERT INTO fuf_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Onsay Iisaa wi'i: «Sim'uunu, Sim'uunu! Ibuliisa torike hendagol on, wesira wa nendi. ");
INSERT INTO fuf_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Kono min mi toranike ma fii wota gomɗinal maa ngal hayru. An kadi tuma yiltitiɗaa e an eto tabintinaa wondiɓɓe maa ɓen.» ");
INSERT INTO fuf_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Onsay Sim'uunu Petruusu jaabii mo, wi'i: «Koohoojo, miɗo hebulanii yaadugol e maa haa e kaso maa haa e mayde.» ");
INSERT INTO fuf_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Onsay Iisaa jaabii mo, wi'i: «Petruusu, mi andinii ma, ndonto ƴoggataa hande hara a yeddaali wonde hiɗa andimmi haa timma laabi tati.» ");
INSERT INTO fuf_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","O wi'i ɓe kadi: «Fewndo ko mi neli on e ɓaawo mbuuɗi e bonfo e paɗe, on ŋakkiroyano ton goɗɗun?» Ɓe jaabitii: «Hay huunde.» ");
INSERT INTO fuf_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","O wi'i ɓe kadi: «Jooni non ko nii: Kala jogiiɗo mbuuɗi yo ƴettu, wano non kadi on mo no mari bonfo yo ƴettu, awa kadi mo maraa kaafa e mon yo yeeyitu waramba mun on sooda. ");
INSERT INTO fuf_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Awa mi andinii on, bee ko windii fii an kon laatoo, wonde: ‹O wattidete e waɗooɓe bone ɓen.› Wano non kadi, kala ko windanoo fii an kon ko e laataade woni.» ");
INSERT INTO fuf_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Onsay ɓe wi'i mo: «Koohoojo, e hino ɗoo kaafaaje ɗiɗi.» O wi'i ɓe: «Awa yonii.» ");
INSERT INTO fuf_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ontuma o yalti o yahi ka Fello *Zaytuuni wano o woowiri non. Taalibaaɓe makko ɓen kadi jokki mo. ");
INSERT INTO fuf_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ɓay ɓe hewtii e nden nokkuure, o wi'i ɓe: «Toree Alla fii wota on naatu e jarrabi.» ");
INSERT INTO fuf_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Onsay o woɗɗitori ɓe yeru bugannde hayre, o jiccii o torii, ");
INSERT INTO fuf_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","o wi'i: «Baaba an, si hiɗa faalaa, yo kun jardukun tampere pottito lan. Kono non wota faale an on waɗu, kono yo faale maa on waɗu.» ");
INSERT INTO fuf_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Onsay malaa'ikaajo iwri ka kammu, ari e makko no tiiɗina mo. ");
INSERT INTO fuf_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ɓay sonjaa wonkii heɓii mo, o ɓurti toragol. Onsay lakkere makko nden wa'i wa cinte ƴiiƴan ɗe no sinta e leydi. ");
INSERT INTO fuf_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ɓay o gaynii toragol, o immii o yahi ka taalibaaɓe makko ɓen woni ton, o tawi hiɓe ɗaanii sabu annde nde ɓe wondi nden. ");
INSERT INTO fuf_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Onsay o wi'i ɓe: «Ko fii honɗun ɗaanantoɗon? Immee toroɗon fii wota on naatu e jarrabi.» ");
INSERT INTO fuf_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","E nder ko o yewtata kon, hawrondiri jamaa yimɓe hewtii. Tawi ko oo wi'eteeɗo Yudaasi tawdaaɗo e sappoo e ɗiɗooɓe ɓen ardii ɓen. On ɓadii Iisaa fii lunnagol mo. ");
INSERT INTO fuf_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Onsay Iisaa wi'i mo: «Yudaasi, hara ko lunnagol janfortaa Ɓii-Aaden on?» ");
INSERT INTO fuf_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ɓay wondiɓɓe Iisaa ɓen sogitike ko saatii waɗude kon, onsay ɓe wi'i: «Koohoojo, hara yo men huutor kaafaaje amen ɗen?» ");
INSERT INTO fuf_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Tun goɗɗo e maɓɓe soppi kurkaadu yottinoowo mawɗo sadaka on, o itti mo nowru ɲaamuru ndun. ");
INSERT INTO fuf_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Kono Iisaa ƴetti haala kan, wi'i: «Hattinee ɗoo!» Onsay o meemi nowru on ndun, ndu wattii. ");
INSERT INTO fuf_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Iisaa wi'i ɓen arɓe hendagol mo kadi, ɗun ko hooreeɓe yottinooɓe sadaka ɓen e hooreeɓe aynooɓe juulirde mawnde nden e mawɓe ɓen: «Hiɗon ardi e kaafaaje e bedi wa si ko ngujjo aranɗon. ");
INSERT INTO fuf_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Hara-le ɲande woo miɗo wondi e mon ka juulirde mawnde, kono on fawaali juuɗe e an. Kono ɗoo ko saa'i mon nii, e saa'i mbawdi niɓe ɗen.» ");
INSERT INTO fuf_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ɓay wonii ɓe nangii Iisaa, ɓe naɓi mo ka galle yottinoowo mawɗo sadaka on. Petruusu iwtiri ɓaawo maɓɓe ka woɗɗitii. ");
INSERT INTO fuf_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Onsay ɓe huɓɓi yiite ka hakkunde tande, ɓe jooɗii. Petruusu kadi ari jooɗodi e maɓɓe. ");
INSERT INTO fuf_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","No debbo kurkaaduujo goo yiirunoo mo kanko Petruusu himo jooɗii ka binde yiite, kanko debbo on o tenƴini mo, o wi'i: «Oo ɗoo ko wondiɗɗo Iisaa!» ");
INSERT INTO fuf_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Kono kanko Petruusu o yeddi, o wi'i: «Hey ko an yo debbo, min mi andaa oo.» ");
INSERT INTO fuf_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ɓay nettii seeɗa, goɗɗo goo kadi yi'i mo, wi'i: «An ko a tawdaaɗo e maɓɓe.» Petruusu wi'i onɗon kadi: «Mi tawdaaka e maɓɓe!» ");
INSERT INTO fuf_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ɓay wonii embere saa'i gooto feƴƴii, goɗɗo goo kadi catii, wi'i: «Pellet, oo ko wondiɗɗo makko nii, ko fii oo ko mo Jaliilu.» ");
INSERT INTO fuf_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Petruusu jaabii onɗon kadi, wi'i: «An mi andaa ko honɗun wonɗaa wowlude!» Wa fewndo o wowlata ɗun, ndontoori ndin ƴoggi. ");
INSERT INTO fuf_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Onsay Koohoojo on yeƴƴitii, cikki gite mun ɗen e Petruusu. Tun Petruusu anditi fii ko Koohoojo on wowlannoo mo kon wondema: «Ado ndonto ƴoggude hande, haray a yeddii fii an haa timmii laabi tati!» ");
INSERT INTO fuf_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Onsay Petruusu yalti ka yaasi, o wulli wullaandu sattundu. ");
INSERT INTO fuf_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Tawi yimɓe joginooɓe Iisaa ɓen no jalaynoo mo luuboo, ");
INSERT INTO fuf_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","awa kadi ɓe buumayno mo yeeso ngon, ɓe wi'a: «Hotto ko hombo luubi-maa!» ");
INSERT INTO fuf_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","E hoore ɗun ɓe kongayno mo, ɓe hoyna. ");
INSERT INTO fuf_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ɓay weetii, mawɓe jamaa on, ɗun ko hooreeɓe yottinooɓe sadaka ɓen e jannooɓe fii Sariya on ɓen, mottondiri. Ɓe addi Iisaa ka yeeso dental maɓɓe, ");
INSERT INTO fuf_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","ɓe wi'i mo: «Si tawii ko an woni *Almasiihu on, wowlan men.» Iisaa jaabii ɓe, wi'i: «Si mi haalanii on, on hoolotaako, ");
INSERT INTO fuf_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","awa kadi si mi landike on, on jaabotaako lan. ");
INSERT INTO fuf_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Kono gila jooni Ɓii-Aaden on jooɗoto ka sengo ɲaamo Allaahu on, on Jom Bawgal.» ");
INSERT INTO fuf_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ɓe fow ɓe wi'i: «Kere ko an woni *Ɓiɗɗo Alla on?» Ontuma o wi'i ɓe: «Ko ko wowluɗon kon onon tigi, ko mi ɗun.» ");
INSERT INTO fuf_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Onsay ɓe wi'i: «Ko seedee hombo faalaɗen kadi? Kanko tigi o wowlii, en nanii!» ");
INSERT INTO fuf_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Onsay dental ngal fow immii naɓi Iisaa ka Pilaatu. ");
INSERT INTO fuf_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ɓe woni e tooɲugol mo, wi'a: «Men taw oo no murtinde jamaa men on haɗa ɓe yoɓugol lanɗo mawɗo Roomu on sagalle. Awa kadi himo wi'itii *Almasiihu, ɗun ko lanɗo.» ");
INSERT INTO fuf_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilaatu landii mo, wi'i: «Hara ko an woni lanɗo Yahuudiyanke'en?» Iisaa jaabii mo, wi'i: «Ko wano wi'irɗaa non.» ");
INSERT INTO fuf_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Onsay Pilaatu wi'i hooreeɓe *yottinooɓe sadaka ɓen e jamaa on: «Mi yi'aali hujja woo ko oo neɗɗo jogoree!» ");
INSERT INTO fuf_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Kono ɓe catii e ɗun, ɓe wi'i: «Himo lowirde jamaa on jannugol ɓe. O fuɗɗii gila ka diiwal Jaliilu, o rewi e diiwal Yahuuda ngal fow haa o hewtii ɗoo jooni.» ");
INSERT INTO fuf_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ɓay Pilaatu nanii ɗun, o landii si oo neɗɗo ko mo Jaliilu. ");
INSERT INTO fuf_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ɓay kanko Pilaatu o andii wonde Iisaa ko e laamateeri *Heroodu ndin jeyaa, o feƴƴini mo ka Heroodu. Tawi e ɗen balɗe ɗon, on no Yerusalaam. ");
INSERT INTO fuf_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ɓay Heroodu yi'ii Iisaa, ɗun weltini mo fota. Tawi gila neeɓi himo faalanoo mo yi'ude sabu ko o nanaynoo no wowlee fii makko kon. Awa kadi himo faalanoo yi'ude himo waɗa kaawakeeji moƴƴi goo. ");
INSERT INTO fuf_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","O landii mo haa juuti, kono Iisaa jaabaaki mo fus. ");
INSERT INTO fuf_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Tawi hooreeɓe yottinooɓe sadaka ɓen wondude e jannooɓe fii Sariya on ɓen no ɗon, ɓen no tooɲa mo tooɲe sattuɗe. ");
INSERT INTO fuf_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Heroodu e suufaaɓe mun ɓen kadi jali mo aybini. Onsay o ɓorni mo dolokke fotuɗo, o nattani mo Pilaatu. ");
INSERT INTO fuf_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Nden ɲande tigi Pilaatu e Heroodu ɓen ayrunooɓe welditi. ");
INSERT INTO fuf_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ontuma Pilaatu nodditi hooreeɓe yottinooɓe sadaka ɓen e yeesooɓe ɓen wondude e jamaa on, ");
INSERT INTO fuf_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","o wi'i ɓe: «On addanii lan oo neɗɗo, on wi'ii ko kanko woni murtinde jamaa on. E hino mi landike mo e tawnde mon, mi yi'aali dalil woo e hoore oo neɗɗo ko tooɲiron mo. ");
INSERT INTO fuf_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Awa Heroodu kadi-le wano non, ko fii o artiranii en mo. Awa-le oo neɗɗo waɗaa hay huunde ko foddi e wareede. ");
INSERT INTO fuf_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Jooni mi donkinay mo, mi accita.» ");
INSERT INTO fuf_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Tawi no farlii mo kanko Pilaatu, juldeere bee accitangol ɓe nangaaɗo goo. ");
INSERT INTO fuf_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Onsay ɓe fow ɓe sonki, ɓe wi'i: «Waree oo ɗoo! Accitanon men Barabaasi!» ( ");
INSERT INTO fuf_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Tawi on-le ko sokiraa, ko sabu gere no waɗunoo ka saare e waru hoore.) ");
INSERT INTO fuf_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilaatu yewti ɓe fahin, ɓay hari no e fondo makko accitugol Iisaa. ");
INSERT INTO fuf_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Kono hiɓe sonkaynoo, wi'a: «Fempee mo! Fempee mo!» ");
INSERT INTO fuf_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilaatu wi'i ɓe tammun: «Hara ko honɗun oo bonni? Min mi yi'aali dalil woo ko oo wariree. Jooni mi donkinay mo, mi accita.» ");
INSERT INTO fuf_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Kono ɓe catii e ɗun e hoore sonko njano, hiɓe toroo yo o fempe. Ngon sonko maɓɓe fooli mo kanko Pilaatu. ");
INSERT INTO fuf_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pilaatu jaɓani ɓe faale maɓɓe on. ");
INSERT INTO fuf_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","O acciti on mo ɓe torii mo fii mun, ɗun ko oo sokiranooɗo fii gere e waru hoore, o waɗi Iisaa faale maɓɓe on. ");
INSERT INTO fuf_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Fewndo ɓe naɓaynoo Iisaa fii warugol mo, ɓe hendii goɗɗo mo Sirenii iwaynooɗo ngesa, on no wi'ee Sim'uunu. Ɓe rondi mo *leggal altindiraangal ngal, o iwtiri ɓaawo Iisaa. ");
INSERT INTO fuf_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Tawi jamaa moolanaaɗo no iwtiri ɓaawo makko wondude e rewɓe, ɓen no wulla fesa fii makko kanko Iisaa. ");
INSERT INTO fuf_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Onsay Iisaa fewtiti ɓe, wi'i: «Ko onon yo rewɓe Yerusalaam, wota on wullu fii an, kono wullee fii mon e fii ɓiɓɓe mon ɓen. ");
INSERT INTO fuf_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ko fii ɲalaaɗe no aroya ka wi'oytee: ‹Maloore wonanii ɓen ɓe jiidotaako e ɓen ɓe heɓaali ɓiɓɓe e ɓen ɓe muyninaali!› ");
INSERT INTO fuf_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Onsay yimɓe ɓen wi'oyay: ‹Pelle yanee e hoore amen! Cehe suumee men!› ");
INSERT INTO fuf_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Hara si leɗɗe kecce ɗen warraama nii, haray ko honno yorɗe ɗen warroytee?» ");
INSERT INTO fuf_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Tawi bonɓe ɗiɗo no naɓideede e Iisaa fii waridoyegol e makko. ");
INSERT INTO fuf_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ɓay ɓe hewtii e ndee nokkuure wi'eteende Laalagal Hoore, ɓe fempi mo ɗon wondude e ɓen bonɓe ɗiɗo, goɗɗo on ka sengo makko ɲaamo, oya on ka nano makko. ");
INSERT INTO fuf_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Onsay Iisaa wi'i: «Baaba an, yaafo ɓee, ko fii ɓe andaa koo ko ɓe woni waɗude.» Onsay ɓen suufaaɓe sendiri conci makko ɗin urɓa. ");
INSERT INTO fuf_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Tawi yimɓe ɓen no darii ɗon no ndaara. Yeesooɓe ɓen kaɲun no awmotonoo mo, wi'a: «O dandii ɓeya, awa yo o dandu hoore makko kadi si tawii ko kanko woni Almasiihu Alla, Suɓaaɗo on!» ");
INSERT INTO fuf_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Suufaaɓe ɓen kaɲun kadi no jalaynoo mo, ɓe ɓadii ɓannangol mo ndiyan lammuɗan, ");
INSERT INTO fuf_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","hiɓe wi'a: «Si tawii ko an woni Lanɗo Yahuudiyanke'en, dandito an tigi!» ");
INSERT INTO fuf_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Tawi no windii dow makko wonde: «Oo ɗoo ko Lanɗo Yahuudiyanke'en nii.» ");
INSERT INTO fuf_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Tawi bonɗo mo o fempidaa wengaa goo no hoynaynoo mo, wi'a: «Wonaa an woni Almasiihu on? Awa dandu goy hoore maa, dandaa men menen kadi!» ");
INSERT INTO fuf_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Kono ɗimmo makko on feli mo, wi'i: «An a hulataa Alla? An oo yagginiraaɗo wa makko, ");
INSERT INTO fuf_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","enen ɗiɗo-le hiɗen foddi e ɗun, ko fii ko kuuɗe men hettuɗen. Kono oo ɗoo waɗaali hay fus ko boni.» ");
INSERT INTO fuf_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Onsay o wi'iti kadi: «Iisaa, anditoyee fii an tuma artoyɗon ka laamu mon.» ");
INSERT INTO fuf_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Iisaa jaabii mo, wi'i: «Mi holnii ma wondema hande tigi a wonday e an ka aljanna.» ");
INSERT INTO fuf_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ɓay wonii naange e hoore, niwre waɗi e leydi ndin fow haa ka ɓaawo fanaa. ");
INSERT INTO fuf_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Naange ngen weɲi, *wirngallo hormorde nden ka *juulirde mawnde feeri e hakkunde. ");
INSERT INTO fuf_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Iisaa ewnii ko tiiɗi, o wi'i: «Baaba an, mi wattii ruuhu an on e juuɗe maa.» No o gaynirnoo wi'ude ɗun, o timmi. ");
INSERT INTO fuf_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ɓay hooreejo suufaaɓe ɓen yi'ii kon ko waɗi ɗon, o mawnini Alla, o wi'i: «Ka haqiiqa, hari oo neɗɗo ko feewuɗo.» ");
INSERT INTO fuf_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ɓay jamaa arnooɓe yi'ugol ko waɗaynoo ɗon kon yi'ii ɗun, ɓe yiltitii hiɓe tappitoo e ɓerɗe. ");
INSERT INTO fuf_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Tawi kala andunooɓe mo kanko Iisaa, wondude e rewɓe iwtirnooɓe ɓaawo makko ɓen gila Jaliilu, no darii ka woɗɗitii, no ndaara kon ko woni waɗude. ");
INSERT INTO fuf_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Tawi neɗɗo moƴƴo feewuɗo wi'eteeɗo Yuusufu no tawanoo e ngal dental mawɓe *Banii-Isra'iila'en ɓen, ");
INSERT INTO fuf_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","on kaɲun jaɓaano taweede e fewjoore maɓɓe nden e ɗen kuuɗe maɓɓe. Hari on ko jeyaaɗo e ndee saare Yahuudiyankeeɓe wi'eteende Raamati, tawi on ko *laamu Alla ngun tijjii. ");
INSERT INTO fuf_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","On yahi ka Pilaatu, o torii mo hettugol furee Iisaa on. ");
INSERT INTO fuf_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ɓawto ɗun, o yahi, o tippini furee Iisaa on ka hoore leggal, o tumbi e kasannge, o belnoyi mo e qaburu asaaɗo e feto, mo hari hay gooto surraaka e mun. ");
INSERT INTO fuf_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ɗun hawri ɲande hebulanagol *ɲalaande fowteteende nden, ɓay hari nden ɓadike ka naata. ");
INSERT INTO fuf_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Rewɓe ardunooɓe e Iisaa ɓen gila Jaliilu jokki Yuusufu, ɓe yi'oyi yenaande nden e no furee on belniraa. ");
INSERT INTO fuf_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Onsay rewɓe ɓen yiltitii fii moƴƴinoygol tiiri e angiri. No asewe on naatirnoo, ɓe fowtii wano Sariya on wi'iri non. ");
INSERT INTO fuf_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","E alat, ɗun ko ɲallal aranal e nder yontere nden, ɓen rewɓe dawi bimbi subaka ka yenaande, hiɓe yooɓii tiiri ndi ɓe moƴƴinnoo. ");
INSERT INTO fuf_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ɓe tawi hayre ombiranoonde yenaande nden tallaama, ");
INSERT INTO fuf_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","ɓe naati, kono ɓe tawaali ton furee Iisaa Koohoojo on. ");
INSERT INTO fuf_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Wa fewndo ko ɓe miijotoo fii ɗun, worɓe ɗiɗo ɓorniiɓe conci jalbuɗi, feeɲani ɓe. ");
INSERT INTO fuf_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ɓe fow ɓe huli, ɓe ugginii ka leydi. Kono ɓen worɓe ɗiɗo wi'i ɓe: «Ko fii honɗun ɗaɓɓitanton wurɗo on e hakkunde mayɓe ɓen? ");
INSERT INTO fuf_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","O alaa ɗoo, o immintinaama. Anditee ko o wowlanaynoo on kon fewndo o wonnoo Jaliilu, ");
INSERT INTO fuf_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","himo wi'aynoo on: ‹Bee *Ɓii-Aaden on wattee e juuɗe junuubanke'en, o fempee, o waree, o immintinoyee ka ɲalaande tammere.› » ");
INSERT INTO fuf_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Tun, ɓen anditi ɗin konguɗi Iisaa Almasiihu on. ");
INSERT INTO fuf_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Onsay ɓe iwi ka yenaande ɗon, ɓe yahi yeetoyagol ɗun *sahaabaaɓe ɓen sappoo e go'o wondude e heddiiɓe ɓen fow. ");
INSERT INTO fuf_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ɓen rewɓe ko Mariyama Magaduuna e Yuuwanna e Mariyama yumma Yaaquuba wondude e woɓɓe goo, wowlanoynoo ɗun sahaabaaɓe ɓen sappoo e go'o. ");
INSERT INTO fuf_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Kono ɓe ronki hoolaade ɓen rewɓe, tawi konguɗi ɓen ɗin no wa'ani ɓe wa fuyanteeji. ");
INSERT INTO fuf_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Kono Petruusu immii dogiri ton. Ɓay o hewtii, o ugginii ka yenaande, ko kasannge on tun o yi'i ton. Onsay o hooti ka makko e hoore himo ŋalɗi sabu kon ko waɗi. ");
INSERT INTO fuf_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Tawi nden ɲande tigi ɗiɗo e maɓɓe no yahaynoo e hoɗo no wi'ee Emayuusu woɗɗitorngo Yerusalaam embere kilomeeterji sappoo e ɗiɗi. ");
INSERT INTO fuf_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Tawi ɓen no yewta fii ko waɗunoo kon fow. ");
INSERT INTO fuf_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Wa fewndo ko ɓe yewtata ɗun ɓe landondira, Iisaa ɓadii ɓe, o waddi e maɓɓe laawol. ");
INSERT INTO fuf_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Kono tawi giiɗe maɓɓe ɗen no wirnanaa anditugol mo. ");
INSERT INTO fuf_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Onsay o wi'i ɓe: «Ko konguɗi honɗi wonɗon bugondirde e nder nduu yaadu mon?» Ɓe dartii, ɓe yoomi. ");
INSERT INTO fuf_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Onsay goɗɗo e maɓɓe wi'eteeɗo Keleyopaasu jaabii mo, wi'i: «Haray ko an tun woni koɗo wonɗo Yerusalaam mo andaali ko waɗi kon e ɗee balɗe ɗoo?» ");
INSERT INTO fuf_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Onsay o wi'i ɓe: «Honɗun?» Ɓe wi'i mo: «Koo ko waɗi e hoore Iisaa oo jeyaaɗo Naasirata, ɗun ko oo annabaajo jom kuugal e kongol yeeso Alla e yeeso jamaa on fow, ");
INSERT INTO fuf_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","e ko honno kadi hooreeɓe *yottinooɓe sadaka men ɓen e hooreeɓe men ɓen wattiri mo e juuɗe ɓeya fii yo ɓen ɲaawu mo, ɓe fempa mo e leggal, ɓe wara. ");
INSERT INTO fuf_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Meɗen tanƴininoo ko kanko yaltinayno *Banii-Isra'iila'en e njaggu. Kono e nder ɗun fow, e hino heɓii hande balɗe tati gila ɗun waɗi. ");
INSERT INTO fuf_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Awa kadi rewɓe wondiɓɓe amen goo ŋalɗinii men fota, nde ɓe dawunoo ka yenaande, ");
INSERT INTO fuf_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ɓe tawaali ton furee makko on. Ɓe ari ɓe wi'i men malaa'ikaaɓe feeɲanii ɓe, ɓen wi'ii ɓe wonde kanko Iisaa himo wuuri. ");
INSERT INTO fuf_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Onsay wondiɓɓe amen goo kadi yahi ka yenaande, ɓe tawaali furee Iisaa on ton, tawi ko no rewɓe ɓen wiirunoo men non tigi woniri!» ");
INSERT INTO fuf_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Onsay kanko Iisaa o wi'i ɓe: «Ko onon yo njofooɓe, hiɗon nennanii gomɗingol kala ko annabaaɓe ɓen *hiitinoo kon! ");
INSERT INTO fuf_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Hara haananaa *Almasiihu on ka o tampira nii ado o naatude ka mangural makko?» ");
INSERT INTO fuf_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Onsay o nangi sifanagol ɓe ko windii fii makko kon fow ka defte, gila e Muusaa e ɓeya annabaaɓe fow. ");
INSERT INTO fuf_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ɓay wonii ɓe ɓadike hoɗo ngo ɓe yahaynoo e mun ngon, o faaminani ɓe wonde ko toonin ton o sutii. ");
INSERT INTO fuf_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Kono ɓe jeeji mo, ɓe wi'i: «Wonen, ko fii naange ngen yoroyii, niɓɓay woni.» Onsay o naatidi e maɓɓe. ");
INSERT INTO fuf_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Fewndo o jooɗodi e maɓɓe fii ɲaamugol, o ƴetti bireedi on, o du'ii, o taƴiti, o jonni ɓe. ");
INSERT INTO fuf_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Tun, giiɗe maɓɓe ɗen udditii, ɓe anditi mo, onsay o majjitori ɓe. ");
INSERT INTO fuf_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ɓe woni e wi'indirgol: «Hinaa ɓerɗe men ɗen no amaynoo weltaare fewndo ko o yewtata en ka laawol, o sifanoo en ko windii kon ka defte?» ");
INSERT INTO fuf_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ɓe immii kisan, ɓe yiltitii Yerusalaam, ɓe ari ɓe tawi sahaabaaɓe ɓen sappoo e go'o e wondiɓɓe mun ɓen no mottondiri ɗon. ");
INSERT INTO fuf_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Tawi ɓen wonnooɓe ɗon no wi'a: «Ka haqiiqa, Koohoojo on immintinaama, o feeɲanii Sim'uunu!» ");
INSERT INTO fuf_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Onsay ɓeya ɗiɗo kadi sifanii ɓe ko ɓe yi'i kon ka laawol e ko honno ɓe anditiri mo ka sendo bireedi. ");
INSERT INTO fuf_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Wa fewndo ko ɓe yewtaynoo ɗun, kanko tigi o ari hakkunde maɓɓe, o wi'i ɓe: «Yo jam wonu e mon!» ");
INSERT INTO fuf_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Tun ɓe ɗenƴii, ɓe huli, ɓe sikki ko mbeelu ɓe yi'i. ");
INSERT INTO fuf_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Kono o wi'i ɓe: «Ko honɗun jiɓiɗon? Ko fii honɗun kadi ndee sikkitaare wonani ka ɓerɗe mon? ");
INSERT INTO fuf_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ndaaree ɗee juuɗe an e ɗee koyɗe an. Ko min tigi nii! Meemee lan, ndaaron, ko fii mbeelu alaa teewu, alaa ƴi'e, on yi'ii-le min miɗo mari.» ");
INSERT INTO fuf_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ɓay wonii o wi'ii ɗun, onsay o holli ɓe juuɗe makko ɗen e koyɗe makko ɗen. ");
INSERT INTO fuf_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ɓay tawii e nder weltaare maɓɓe nden haa jooni ɓe hoolaaki, hiɓe e nder ŋalaw, onsay o wi'i ɓe: «Hara hiɗon mari ɗoo goɗɗun ko ɲaametee?» ");
INSERT INTO fuf_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Onsay ɓe ɓannani mo huntere lingii sa'aangii. ");
INSERT INTO fuf_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","O ƴetti ngii, o nafii yeeso maɓɓe. ");
INSERT INTO fuf_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Onsay o wi'i ɓe: «Ko ɗunɗoo mi wowlannoo on fewndo mi wondunoo e mon, wonde bee ko windii fii an kon fow ka Sariya Muusaa e ka Zabuura e ka defte ɓeya annabaaɓe laatoo.» ");
INSERT INTO fuf_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ontuma o udditani ɓe hakkille maɓɓe ɗen fii no ɓe faamira defte ɗen. ");
INSERT INTO fuf_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","O wi'i ɓe kadi: «Ko ɗunɗoo windii wondema Almasiihu on tampay, o immintinee e hakkunde mayɓe ɓen ka ɲallal tammal. ");
INSERT INTO fuf_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Awa kadi leƴƴi ɗin fow waajete e innde makko gila Yerusalaam fii yo ɓe tuubu, ɓe yaafanee junuubaaji maɓɓe ɗin. ");
INSERT INTO fuf_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ko onon woni seedeeɓe ɗun ɓen. ");
INSERT INTO fuf_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Jooni non mi addanoyay on ko Baaba an fodunoo kon. Kono onon luttee ka nder saare, haa tuma yeɗaɗon bawgal iwrayngal ka dow ngal.» ");
INSERT INTO fuf_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ɓawto ɗun Iisaa nawri ɓe telen *Betanii, o fonti juuɗe makko ɗen, o du'anii ɓe. ");
INSERT INTO fuf_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Wa fewndo ko o du'antoo ɓe, o acci ɓe ɗon, o ƴentinaa ka kammu. ");
INSERT INTO fuf_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ɓay kamɓe ɓe sujjanii mo, ɓe yiltitii Yerusalaam e hoore welo-welo mawngo. ");
INSERT INTO fuf_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Onsay ɓe tabiti ka *juulirde mawnde, hiɓe mawnina Alla.");
INSERT INTO fuf_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ka fuɗɗoode, hari Daaluyee on no woodi, tawi Daaluyee on no wondi e Alla, tawi kadi Daaluyee on ko Alla, ");
INSERT INTO fuf_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","tawi himo wondi e Alla ka fuɗɗoode. ");
INSERT INTO fuf_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ko rewrude e Daaluyee on Alla tagiri kala huunde, hay huunde e ko tagaa kon alaa ko tagaa e ɓaawo makko. ");
INSERT INTO fuf_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Awa kadi ko e makko ngurndan ɗan woni. Ko ɗan ngurndan kadi woni ndaygu yimɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ndaygu ngun jalbi ka nder niɓe, laatii niɓe ɗen foolaali ngu. ");
INSERT INTO fuf_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Woodii neɗɗo mo Allaahu on nuli no wi'ee Yaayaa. ");
INSERT INTO fuf_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","On ardi wa seedee fii seeditanagol ndaygu ngun, fii yo fow gomɗinir sabu makko. ");
INSERT INTO fuf_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Hinaa non kanko woni ndaygu ngun, kono ko o ardi ko fii seeditanagol ndaygu ngun, ");
INSERT INTO fuf_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","ɗun ko nguu ndaygu haqiiqawu arngu e oo aduna, ndayginayngu kala neɗɗo. ");
INSERT INTO fuf_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Hari daaluyee on no e oo aduna, awa kadi aduna on ko e makko tagiraa, kono aduna on andaali mo. ");
INSERT INTO fuf_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","O arii ka makko, kono ɓe makko ɓen jaɓɓaaki mo. ");
INSERT INTO fuf_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Kono kala jaɓɓiiɓe mo, gomɗini innde makko nden, ko ɓen o newnani wonugol ɓiɓɓe Alla. ");
INSERT INTO fuf_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ɗun ko ɓen heɓaaɓe immorde e Alla, hara hinaa immorde e ƴiiƴan maa e mbeleeɗe ɓandu maa e faale neɗɗanke. ");
INSERT INTO fuf_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Daaluyee on wonti neɗɗo, o hoɗi hakkunde men, ɗun ko on heewuɗo moƴƴere e goonga. Awa-le en punnike mangu makko ngun, ngun mangu ngu Biɗɗo bajjo on heɓi e Baabaajo on. ");
INSERT INTO fuf_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yaayaa seeditanii mo, ewnii, o wi'i: «Ko oo mi wowlunoo fii mun, mi wi'i: ‹Araynooɗo ɓaawo an on ko ɓurɗo lan mawnude, ko fii hari himo woodaa ko adii lan!› » ");
INSERT INTO fuf_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Awa en fow en heɓii moƴƴere e hoore moƴƴere immorde e ko woni e makko kon fow. ");
INSERT INTO fuf_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ko fii Sariya on ko e Muusaa ardi, kono sulfu on e goonga on ko e Iisaa Almasiihu on ardi. ");
INSERT INTO fuf_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Haa hande hay gooto yi'aali Alla. Kono Bajjo on, on wonɗo Alla, wonduɗo e Baabaajo on, on ɓanginanii en fii makko. ");
INSERT INTO fuf_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","E hino seeditoore Yaayaa nden, fewndo ko hooreeɓe *Yahuudiyankeeɓe ɓen Yerusalaam immini *yottinooɓe sadaka ɓen e Lewiyankeeɓe ɓen fii landagol mo, ɓe wi'i: «An ko a hombo nii?». ");
INSERT INTO fuf_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","O qirritii e hoore o yeddaali, o wi'i: «Wonaa min woni *Almasiihu on.» ");
INSERT INTO fuf_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ɓe landii mo kadi, ɓe wi'i: «E hara ko a hombo non? Kaa ko an woni Iiliiya?» O jaabii ɓe, o wi'i: «Hinaa mi on.» Ɓe landii mo kadi, ɓe wi'i: «E hara ko an woni Annabaajo on?» Ɗun kadi o jaabii: «Oo'o.» ");
INSERT INTO fuf_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Onsay ɓe wi'i mo: «E hara ko a hombo non fii yo men jaabitoyo nulɓe men ɓen? Ko honɗun wi'itiɗaa an tigi?» ");
INSERT INTO fuf_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","O jaabori ɓe wano annabi *Isaaya wiirunoo non, o wi'i: «Ko min woni hawa ewnotooɗo ka wulaa on, wi'a: ‹Fewnee laawol Joomiraaɗo on!› » ");
INSERT INTO fuf_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Tawi ɓen imminanooɓe ko ka *Fariisiyaaɓe ɓen iwri. ");
INSERT INTO fuf_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Onsay ɓe landii mo, ɓe wi'i: «Ko fii honɗun non *lootantaa maande tuubuubuyee, si tawii wonaa an woni Almasiihu on maa Iiliiya maa Annabaajo on?» ");
INSERT INTO fuf_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Kanko Yaayaa o jaabii ɓe, o wi'i: «Min ko ndiyan mi woni *lootirde maande tuubuubuyee. Kono goɗɗo no e hakkunde mon mo on andaa, ");
INSERT INTO fuf_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","wonɗo arude ɓaawo an, mo mi hewtaa hay firtugol ɓoggi paɗe mun!» ");
INSERT INTO fuf_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ɗun ko *Betanii funnaange Yurdayniwol waɗi, ka Yaayaa lootaynoo maande tuubuubuyee ɗon. ");
INSERT INTO fuf_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Bimbi nden ɲande, Yaayaa haccii ka Iisaa arata e makko, o ewnii, o wi'i: «E hino *Baalun Alla ɓooraykun junuubi aduna on kun. ");
INSERT INTO fuf_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ko oo woni mo mi wowlannoo on fii mun fewndo ko mi wi'i: Goɗɗo aroyay ɓaawo an, on ko Ɓurɗo lan mawnude, ko fii hari himo woodanoo ko adii lan. ");
INSERT INTO fuf_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Min hari mi andaa mo, kono ko fii ɓanginangol jamaa *Isra'iila on fii makko waɗi si mi ari lootirgol ndiyan.» ");
INSERT INTO fuf_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Kanko Yaayaa o seeditii kadi ɗunɗoo, o wi'i: «Mi yi'ii Ruuhu Allaahu on no iwra ka kammu tippora wa gabooru, wona e hoore makko. ");
INSERT INTO fuf_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Kono min hari mi andaa mo, kono Nuluɗo lan yo mi lootir ndiyan on daalanii lan: ‹On mo yi'uɗaa Ruuhu an on no tippoo wona e mun woo, haray on ko *Ruuhu Seniiɗo on lootirta.› ");
INSERT INTO fuf_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Min non mi yi'ii, mi seeditike kadi, ko on woni *Ɓiɗɗo Alla on.» ");
INSERT INTO fuf_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Bimbi nden ɲande kadi tawi Yaayaa no ɗon, himo wondi e taalibaaɓe makko ɗiɗo. ");
INSERT INTO fuf_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","O yi'i ka Iisaa feƴƴata, o wi'i: «E hino Baalun Alla kun!» ");
INSERT INTO fuf_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ɓen taalibaaɓe makko ɗiɗo nani ɗin konguɗi makko, jokki Iisaa. ");
INSERT INTO fuf_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Onsay Iisaa yeƴƴitii, o tawi hiɓe jokki mo, o wi'i ɓe: «Ko honɗun ɗaɓɓoton?» Ɓen kadi jaabii: «Rabbi*», (ɗun no firi ‹Karamoko'en›) «ko honto hoɗuɗon?» ");
INSERT INTO fuf_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","O jaabii ɓe, o wi'i: «Aree yi'on.» Ɓe yahi, ɓe yi'i ka o hoɗi. Nden ɲande ɓe woni takko makko ɗon, tawi ko wa ka alansaraa. ");
INSERT INTO fuf_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Tawi oo wi'eteeɗo Andaraawu, ɗun ko oo musiɗɗo Sim'uunu Petruusu, ko o goɗɗo e ɓen ɗiɗo nanuɓe konguɗi Yaayaa ɗin e jokkuɓe Iisaa ɓen. ");
INSERT INTO fuf_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Kanko Andaraawu o adii yiidude e Sim'uunu neene-gooto makko on, o wi'i mo: «Men yi'oyii Almasiihu on.» (Ɗun no firi «Toɗɗaaɗo on.») ");
INSERT INTO fuf_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Onsay o addi mo e Iisaa. Iisaa ndaari mo, wi'i: «Ko an woni Sim'uunu mo Yuunusa, jooni ko Petruusu noddeteɗaa.» (Ko woni firo ɗun ko «fetere.») ");
INSERT INTO fuf_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Bimbi nden ɲande, tawi kanko Iisaa himo faalaa yahude Jaliilu, o tawoyi Filiipu, o wi'i mo: «Jokkan.» ");
INSERT INTO fuf_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Tawi Filiipu ko mo Bayti-Sa'iida ka saare oo wi'eteeɗo Andaraawu e Petruusu. ");
INSERT INTO fuf_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Onsay Filiipu tawoyi oo wi'eteeɗo Natanayiila, o wi'i mo: «Men yi'ii on mo fii mun windii ka Sariya Muusaa e ka defte annabaaɓe ɓen, ɗun ko Iisaa oo jeyaaɗo Naasirata, ɓiɗɗo Yuusufu.» ");
INSERT INTO fuf_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Onsay Natanayiila wi'i mo: «Hara huunde moƴƴere no waawi yaltude Naasirata?» Filiipu jaabii mo wi'i: «Aru ndaaraa!» ");
INSERT INTO fuf_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ɓay Iisaa yi'ii Natanayiila no ara e makko, o sifii fii makko, o wi'i: «E hino Isra'iilayankeejo haqiiqaajo mo aldaa e ƴoyre.» ");
INSERT INTO fuf_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Kanko Natanayiila o jaabii: «Ko honno andirɗaa mi?» Iisaa jaabii mo, wi'i: «Ko ado Filiipu noddude ma, fewndo ko wonnoɗaa ka ley ƴibbehi, hari mi yi'ii ma.» ");
INSERT INTO fuf_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanayiila wi'i: «Karamoko'en, ko onon woni Ɓiɗɗo Alla on e Lanɗo Isra'iila on!» ");
INSERT INTO fuf_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Onsay Iisaa jaabii mo, wi'i: «Ko fii mi wi'ii mi yi'ii ma ka ley ƴibbehi gomɗinirɗaa? A yi'ay ko ɓuri ɗunɗoo mawnude. ");
INSERT INTO fuf_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ka haqiiqa haqiiqa mi andinii on, on yi'ay kammu ngun no udditii, malaa'ikaaɓe Alla ɓen no waɗa ƴawa jippoo e hoore *Ɓii-Aaden on.» ");
INSERT INTO fuf_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Balɗe tati ɓawto ɗun, peera waɗi ka wi'etee Kanaa, ɗun ko e nder Jaliilu. Tawi yumma Iisaa no ton. ");
INSERT INTO fuf_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Iisaa e taalibaaɓe mun ɓen kadi saatinaa e on peera. ");
INSERT INTO fuf_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ɓay njaram *wiiɲu ɗan lellii, yumma makko kanko Iisaa wi'i mo: «Njaram ɗan lellirii ɓe.» ");
INSERT INTO fuf_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Onsay Iisaa jaabii yumma mun, wi'i: «Neene, ko honɗun faalanaɗon mi? Ko fii saa'i an on hewtaali taho!» ");
INSERT INTO fuf_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Yumma makko wi'i kurkaaɗi ɗin: «Waɗee kala ko o wi'i on.» ");
INSERT INTO fuf_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Tawi no ɗon looɗe kaaƴe jeegoo eɓɓanaaɗe fii ka Yahuudiyankeeɓe ɓen salligoo, tawi nde bee e majje no waɗa embere liitir teemedere. ");
INSERT INTO fuf_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Iisaa wi'i ɓe yo ɓe hebbin ɗen looɗe ndiyan, kamɓe kadi ɓe loowi e majje haa ɗe heewi. ");
INSERT INTO fuf_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Onsay o wi'i ɓe yo ɓe ɲeɗu, ɓe naɓana ardotooɗo fii ɲaameteeji on. Ɓe ɲeɗi, ɓe naɓani mo. ");
INSERT INTO fuf_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ardotooɗo fii ɲaameteeji on kadi mettii ɗan ndiyan waylaaɗan njaram wiiɲu. Tawi o andaa ko honto ɗan njaram iwi, kono tawi kurkaaduuɓe ƴooguɓe ndiyan ɗan ɓen kaɲun no andi. Onsay o noddi wonɗo tiggude on, ");
INSERT INTO fuf_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","o wi'i mo: «Mo kala ko njaram moƴƴan ɗan adotoo yeɗude, si yeɗoya jaasuɗan ɗan, tuma yaraa moƴƴa. Kono an, hiɗa mari njaram moƴƴan ɗan haa jooni!» ");
INSERT INTO fuf_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ko ndee maande hawniinde o attii waɗude kanko Iisaa, ɗun ko ka wi'etee ɗon Kanaa e nder diiwal Jaliilu waɗi. Ko nii o ɓanginiri darja makko on, taalibaaɓe makko ɓen kadi gomɗini mo. ");
INSERT INTO fuf_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ko ɓawto ɗun, o yaadi e yumma makko e neene-gootooɓe makko ɓen e taalibaaɓe makko ɓen Kafernahuum. Ɓe weeri ɗon balɗe seeɗa. ");
INSERT INTO fuf_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Tawi juldeere Yahuudiyankeeɓe ɓen, ɗun ko *Juldeere Yawtaneede nden, ɓadike. Onsay Iisaa yahi *Yerusalaam. ");
INSERT INTO fuf_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","O tawi yeeyooɓe na'i e baali e gabooji e waɗooɓe sensa-sensita no jooɗii ka dingiral *juulirde mawnde. ");
INSERT INTO fuf_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Onsay o moƴƴini paatawol ɓoggi, o raɗii ɓe fow ka dingiral juulirde mawnde wondude e baali ɗin e na'i ɗin, o saakiti kaalisiiji waɗaynooɓe sensa-sensita ɓen, o liɓi taabe ɗen. ");
INSERT INTO fuf_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","O wi'i yeeyaynooɓe gabooji ɓen: «Ittee ɗu'un ɗoo! Wota on waɗu suudu Baaba an ndun suudu yeeyirdu!» ");
INSERT INTO fuf_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Onsay taalibaaɓe ɓen anditi wonde ɗunɗoo no windinoo: ‹Giggol ngol mi joganii suudu maa ndun no e an wa yiite wonge lan ɲaamude.› ");
INSERT INTO fuf_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Onsay hooreeɓe Yahuudiyankeeɓe ɓen ƴetti haala kan wi'i mo: «Ko maande hawniinde honde waawuɗaa men hollude fii ɓangingol hiɗa gasa warrude nii?» ");
INSERT INTO fuf_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Iisaa jaabii ɓe, wi'i: «Lancee ndee juulirde, mi immintinay nde e nder balɗe tati!» ");
INSERT INTO fuf_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Onsay kamɓe Yahuudiyankeeɓe ɓen ɓe wi'i: «E nder duuɓi cappanɗe nay e jeegoo ndee juulirde no darneede, an non a immintinay nde e nder balɗe tati?» ");
INSERT INTO fuf_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Kono tawi kanko juulirde nde o wonnoo wowlude fii mun nden, ko ɓandu makko ndun. ");
INSERT INTO fuf_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ɓay wonoyii non o immintinaama e hakkunde mayɓe ɓen, taalibaaɓe makko ɓen anditoyi wonde hari o wi'uno ɗun, onsay ɓe gomɗini bindi ɗin e ngol kongol ngol Iisaa wi'unoo. ");
INSERT INTO fuf_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","E nder ko Iisaa wonnoo Yerusalaam kon, ɗun ko ka Juldeere Yawtaneede, buy gomɗini innde makko nden sabu maandeeji hawniiɗi ɗi o waɗaynoo ɗin. ");
INSERT INTO fuf_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Kono Iisaa hoolanooki ɓe, ko fii hari himo andunoo yimɓe ɓen fow, ");
INSERT INTO fuf_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","awa kadi o hatonjinaa e humpiteede fii yimɓe ɓen, ko fii himo andunoo ko woni ka nder ɓernde neddanke. ");
INSERT INTO fuf_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Tawi no e hakkunde fedde *Fariisiyaaɓe ɓen hooreejo Yahuudiyankeeɓe no wi'ee Nikodiyuusu. ");
INSERT INTO fuf_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","On ari jemma takko Iisaa, o wi'i: «Karamoko'en, meɗen andi ko a jannoowo iwruɗo ka Alla, ko fii hay gooto waawataa waɗude ɗii maandeeji hawniiɗi ɗi wonɗaa e waɗude, si tawii Alla aldaa e ontigi.» ");
INSERT INTO fuf_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Onsay Iisaa jaabii, wi'i: «Ka haqiiqa haqiiqa mi andinii ma, si neɗɗo jibintinaaka, o waawataa yi'ude *laamu Alla ngun.» ");
INSERT INTO fuf_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodiyuusu kadi jaabii, wi'i: «Ko honno goɗɗo waawetee jibintinireede e nder nayeewu mun? E hara himo waawa naatitude kadi ka dimdimol neene makko, o jibintinee?» ");
INSERT INTO fuf_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Iisaa jaabii kadi fahin, wi'i: «Ka haqiiqa haqiiqa mi andinii ma, si neɗɗo jibiniraaka ndiyan e Ruuhu Alla on, haray o waawataa naatude ka laamu Alla. ");
INSERT INTO fuf_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ko jibiniraa ɓandu kon ko ɓandu, ko jibiniraa kadi Ruuhu Alla on kon ko ruuhu. ");
INSERT INTO fuf_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Wota a ŋalɗu fii mi wi'ii ma bee jibintineɗon kesun. ");
INSERT INTO fuf_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ko fii hendu ndun no wifirde ka faaliraa woo, hiɗa nanude hawa kan, kono a andaa ko honto ndu iwri maa ko honto ndu fewri. Ko nii kadi fii kala heɓiraaɗo Ruuhu Alla on.» ");
INSERT INTO fuf_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodiyuusu ƴettiti haala kan kadi, wi'i: «Ɗun ko honno gasirta wonirde?» ");
INSERT INTO fuf_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Iisaa jaabii, wi'i: «Ko a jannoowo *Isra'iilayankeeɓe ɓen e a andaa ɗun? ");
INSERT INTO fuf_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ka haqiiqa haqiiqa mi andinii ma, ko ko men andi men wowlata, awa kadi ko ko men yi'i men seeditotoo, kono onon on jaɓataa seeditoore amen nden. ");
INSERT INTO fuf_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Si on gomɗinaali fii piiji adunayankeeji ɗi mi yewti on fii mun ɗin, haray ko honno gomɗinirton piiji kammuyankeeji ɗi mi yewtoyta on fii mun ɗin? ");
INSERT INTO fuf_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Hay gooto ƴawaali ka kammu si hinaa Iwruɗo ka kammu on, ɗun ko *Ɓii-Aaden on. ");
INSERT INTO fuf_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Wano Muusaa townirnoo mboddi ndin non ka wulaa, ko bee Ɓii-Aaden on kadi towniree non, ");
INSERT INTO fuf_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","fii kala gomɗinɗo mo yo heɓu *ngurndan poomayankejan. ");
INSERT INTO fuf_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","«Ko fii hakkee ko Alla yiɗi aduna on, o yeɗii mo Ɓiɗɗo makko bajjo on, fii kala gomɗinɗo mo wota halko, kono yo ontigi heɓu ngurndan poomayankejan. ");
INSERT INTO fuf_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ko fii Allaahu on addaali Ɓiɗɗo makko on e oo aduna fii ɲaawugol aduna on, kono ko fii yo aduna on dandire sabu makko. ");
INSERT INTO fuf_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","On gomɗinɗo mo ɲaawetaake, kono on mo gomɗinaali mo ɲaawaama wuren, ɓayru o gomɗinaali innde Ɓiɗɗo Bajjo Alla on. ");
INSERT INTO fuf_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Awa e hino ɲaawoore nden: ndaygu ngun arii ka aduna, kono yimɓe ɓen yiɗii niwre nden ɓuri ndaygu ngun, ɓay kuuɗe maɓɓe ɗen ko bonɗe. ");
INSERT INTO fuf_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ko fii kala waɗoowo bone haray no aɲi ndaygu ngun, ontigi arataa ka ndaygu fii wota kuuɗe makko ɗen feeɲu. ");
INSERT INTO fuf_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Kono on huutoroowo goonga on aray ka ndaygu fii yo weeɓite wonde kuuɗe makko ɗen ko e Alla huuwiraa.» ");
INSERT INTO fuf_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ɓawto ɗun Iisaa e taalibaaɓe mun ɓen yahi e ngal diiwal *Yahuuda. O ɲallidi e maɓɓe ɗon, tawi himo *loota maande kisiyee. ");
INSERT INTO fuf_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Tawi Yaayaa kadi no *lootude maande tuubuubuyee ka wi'etee ɗon Enuuna, ɗun ko takko Saliima, ɓay tawi ndiyan buy no ɗon. Yimɓe no yahaynoo ɗon fii yo o lootu ɓe, ");
INSERT INTO fuf_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","ko fii tawi Yaayaa waɗaaka taho e kaso. ");
INSERT INTO fuf_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Kono yeddondiral immii hakkunde taalibaaɓe Yaayaa ɓen e Yahuudiyankeejo goo e telen-ma laɓɓinegol ngol. ");
INSERT INTO fuf_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ɓen ɓadii Yaayaa, ɓe wi'i mo: «Karamoko'en, mo wondunoɗaa on gaɗa Yurdayniwol, ɗun ko on mo seeditiɗaa fii mun, himo lootude yimɓe ɓen, awa kadi fow no yaarude e makko!» ");
INSERT INTO fuf_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Onsay Yaayaa jaabii ɓe, wi'i: «Neɗɗo ko ko okkaa ka kammu kon tun waawi hendaade. ");
INSERT INTO fuf_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Onon tigi ko on seedeeɓe an wonde mi wi'ii hinaa min woni *Almasiihu on, kono ko mi imminaaɗo yeeso makko. ");
INSERT INTO fuf_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ko hombo jeyi jomba? Ko jombuɗo mo on. Ko wonani njaatigi jom-jomba ko daragol takko makko, heɗoo mo, nana hito makko, heewa weltaare, nden weltaare an-le timmii. ");
INSERT INTO fuf_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Bee on ɓeydoo, min mi ɗuytoo. ");
INSERT INTO fuf_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ko fii on Iwruɗo dow no e hoore fow. On mo ka leydi ko mo ka leydi, o wowliray kadi wa mo ka leydi. Kono Iwruɗo ka kammu on no e hoore fow. ");
INSERT INTO fuf_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","On non no seeditaade ko yi'i kon e ko nani kon, kono hay gooto jaɓataa nden seeditoore makko. ");
INSERT INTO fuf_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Kala on jaɓuɗo nden seeditoore makko, haray ɓanginii wonde Alla ko goonga. ");
INSERT INTO fuf_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ko fii on mo Allaahu on nuli, ko daaluyeeji Alla ɗin o wowlata. Ko fii Allaahu on yeɗay mo Ruuhu mun on no heewiri. ");
INSERT INTO fuf_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Baabaajo on no yiɗi Ɓiɗɗo on, awa kadi o wattii fow e juuɗe makko. ");
INSERT INTO fuf_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Kala gomɗinɗo Ɓiɗɗo on, haray no mari ngurndan poomayankejan, kono on mo halfinaaki e Ɓiɗɗo on yi'ataa ngurndan, ko fii tikkere Alla nden wonay e hoore makko. ");
INSERT INTO fuf_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Fariisiyaaɓe* ɓen nani wonde Iisaa no ɓurude Yaayaa heɓude taalibaaɓe, o loota ɓe, ");
INSERT INTO fuf_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(kono tawi wonaa kanko Iisaa tigi wonnoo lootude, kono ko taalibaaɓe makko ɓen wonnoo lootude). ");
INSERT INTO fuf_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ɓay Iisaa humpitike ɗun, o iwi ka diiwal Yahuuda ɗon, o yiltitii ka diiwal Jaliilu. ");
INSERT INTO fuf_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Tawi-le bee o taƴitoya *Samariiya. ");
INSERT INTO fuf_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","E nder ɗun, o hewti e saare jeyaande e Samariiya no wi'ee Sikaara e binde ngesa mba Yaaquuba okkunoo ɓiɗɗo mun on, ɗun ko Yuusufu. ");
INSERT INTO fuf_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Tawi woyndu Yaaquuba ndun no ɗon. Iisaa jooɗii ka binde woyndu sabu ronkere yaadu ndun, ɗun ko wa tumbere ɲalorma. ");
INSERT INTO fuf_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Debbo Samariyankeejo ari ƴoogugol ndiyan. Iisaa wi'i mo: «Okkoran mi yara.» ");
INSERT INTO fuf_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Ko fii hari taalibaaɓe makko ɓen no yahi ka saare fii soodugol ɲaametee.) ");
INSERT INTO fuf_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","On debbo Samariyankeejo wi'i mo: «Ko honno an a Yahuudiyankeejo torortaa mi ko yaraa, mi Samariyankeejo?» (Ko fii huuwondiral alaa hakkunde Yahuudiyankeeɓe ɓen e Samariyankeeɓe ɓen.) ");
INSERT INTO fuf_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Iisaa jaabii mo, wi'i: «Si hiɗa andunoo dokkal Alla ngal e Wi'uɗo ma ‹okkoran mi yara› on, hanno ko an torotonoo mo ko yaraa, o okkore ndiyan wurnayɗan.» ");
INSERT INTO fuf_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Kanko debbo on o jaabii mo, o wi'i: «Koohoojo, a alaa hay huunde ko ƴoogiraa, awa-le woyndu ndun no luggi. E hara ko honto heɓaynoɗaa non ɗan ndiyan wurnayɗan? ");
INSERT INTO fuf_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","E hara a ɓuru ben amen Yaaquuba mawnude, on okkuɗo men nduu woyndu, kanko tigi o yari e mayru wondude e ɓiɓɓe makko e jawle makko?» ");
INSERT INTO fuf_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Iisaa jaabii, wi'i: «Kala yaruɗo ɗan ndiyan ɗonɗoyte kadi. ");
INSERT INTO fuf_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","On yaruɗo non ndiyan ɗan mi okkorta mo ɗan, ɗonɗetaake hande kadi. Kono ndiyan ɗan mi okkorta mo ɗan wontay e makko ɓundu ndiyan, ɓuloojan fii yeɗugol *ngurndan poomayankejan.» ");
INSERT INTO fuf_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Debbo on jaabii mo, wi'i: «Koohoojo, okkoran ɗan ndiyan, hara mi ɗonɗetaake hande kadi, e hara mi artaali ɗoo hande kadi ƴoogugol.» ");
INSERT INTO fuf_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Onsay kanko Iisaa o wi'i mo: «Yahu noddoyaa moodi maa, araa.» ");
INSERT INTO fuf_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Debbo on jaabii mo, wi'i: «Mi alaa moodi.» Iisaa wi'i mo: «A wowlii haqiiqa, ko wi'uɗaa kon wonde a alaa moodi. ");
INSERT INTO fuf_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ko fii a heɓii dewle jowi, awa kadi mo wonduɗaa on fewndo ɗoo wonaa moodi maa. E ɗun non a wowlii goonga.» ");
INSERT INTO fuf_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Debbo on wi'i mo: «Koohoojo, mi tawii ko a annabaajo. ");
INSERT INTO fuf_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Menen Samariyankeeɓe ɓen, baabiraaɓe amen ɓen non rewii Alla e ngoo fello. Kono onon Yahuudiyankeeɓe ɓen, hiɗon wi'i ko Yerusalaam woni nokkuure ka Alla rewetee ɗon.» ");
INSERT INTO fuf_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Iisaa wi'i mo: «Hey ko an yo debbo, hoolo lan, saa'iiji goo no aroya hara hinaa e hoore ngoo fello, hinaa Yerusalaam rewoton Baabaajo on. ");
INSERT INTO fuf_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ko fii onon hiɗon rewude ko on andaa, menen meɗen rewude ko men andi, ko fii kisiyee mo Alla yeɗata on ko e Yahuudiyankeeɓe ɓen ardi. ");
INSERT INTO fuf_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Kono saa'i on no arude, ɗun-le wuren o hewtii, ka rewooɓe e haqiiqa ɓen rewira Baabaajo on Ruuhu e goonga, ko fii ko sifa ɓen rewirooɓe mo non, Baabaajo on woni ɗaɓɓude. ");
INSERT INTO fuf_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Alla ko Ruuhu, bee rewooɓe mo ɓen rewira mo Ruuhu e goonga.» ");
INSERT INTO fuf_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Debbo on wi'i mo kadi: «Miɗo andi wonde *Almasiihu on aroyay, ɗun ko Toɗɗaaɗo on. Nde o aroyi, o yewtay men fow.» ");
INSERT INTO fuf_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Iisaa jaabii mo wi'i: «Ko min oo Wonɗo ma wowlande nii woni on.» ");
INSERT INTO fuf_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Onsay taalibaaɓe ɓen hewti, ɓe ŋalɗi ko o wonnoo e yewtidude e debbo on kon. Kono hay gooto e maɓɓe landaaki mo, wi'i: «Ko honɗun faalaɗaa?» maa «Ko honɗun yewtidantaa e makko?». ");
INSERT INTO fuf_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Debbo on kadi acci ɗon loonde nden, o yahi ka saare, o wi'i yimɓe ɓen: ");
INSERT INTO fuf_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«Aree ndaaron neɗɗo wowlanɗo lan kala ko mi waɗi. Taw si wonaa kanko woni Almasiihu on?» ");
INSERT INTO fuf_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Onsay ɓen yalti ka saare, ɓe ari e makko. ");
INSERT INTO fuf_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Wa fewndo onsay, tawi taalibaaɓe ɓen no jeejude mo, wi'a: «Karamoko'en, nafee!» ");
INSERT INTO fuf_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Kono o jaabii ɓe, o wi'i: «Miɗo mari ɲaametee ko mi ɲaama ko on andaa.» ");
INSERT INTO fuf_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Onsay taalibaaɓe ɓen wi'indiri: «E hara ko goɗɗo addani mo ko o ɲaama?» ");
INSERT INTO fuf_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Iisaa wi'i ɓe kadi: «Neema an on ko waɗugol faale Nuluɗo lan on e timmingol golle makko ɗen. ");
INSERT INTO fuf_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","E on wi'aali kadi: ‹Ɗoo e baagol ngol no heddii lebbi nay?› Hey, mi wi'ii on, ɓantee gite ɗen, ndaaron gese ɗen, ɗe wojjanii baagol! ");
INSERT INTO fuf_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Jooni wa'oowo on heɓay njoddi, o mooɓa neema fii ngurndan poomayankejan ɗan, fii yo sankoowo on e wa'oowo on weltodu. ");
INSERT INTO fuf_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ko fii ngal misal ɗoo ko goonga wonde: ‹Ko goɗɗo aawata, oya on soɲita.› ");
INSERT INTO fuf_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Mi nulii on soɲitoygol ko on remaano. Woɓɓe remiino, ko e nder yangi ɓen kin naatuɗon.» ");
INSERT INTO fuf_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Samariyankeeɓe ɗuuɗuɓe e nden saare gomɗini Iisaa sabu ngol kongol ngol oo debbo seeditanii mo, o wi'i: «O wowlanii lan kala ko mi waɗi.» ");
INSERT INTO fuf_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ɓay Samariyankeeɓe ɓen arii e makko, ɓe torii mo wonugol takko maɓɓe, laatii o woni ɗon balɗe ɗiɗi. ");
INSERT INTO fuf_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Gomɗinɓe ɓen ɓurti ɗuuɗude kadi sabu kongol makko ngol, ");
INSERT INTO fuf_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","tawi hiɓe wi'a on debbo: «Hinaa sabu kongol maa ngol hande kadi men gomɗiniri, kono ko ɓay menen tigi men heɗike mo. Meɗen andi wonde ko kanko woni Dandoowo aduna on.» ");
INSERT INTO fuf_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ɓay ɗen balɗe ɗiɗi feƴƴii, Iisaa iwi ɗon fii yahugol Jaliilu, ");
INSERT INTO fuf_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","fii kala o seeditike kanko tigi wonde annabaajo alaa teddungal ka leydi mun. ");
INSERT INTO fuf_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ɓay wonii o hewtii Jaliilu, ɓe Jaliilu ɓen jaɓɓii mo, sabu tawde hari ɓe yi'ii ko waɗi Yerusalaam kon fow ka fewndo juldeere, ɓay kamɓe kadi ɓe yahuno juldeere nden. ");
INSERT INTO fuf_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","O yiltitii kadi Kanaa, ɗun ko e nder Jaliilu, ka o waylunoo ndiyan ɗan njaram *wiiɲu ɗon. Tawi ɓiɗɗo yeesoojo laamateeri ndin, wonɗo Kafernahuum, no nawni. ");
INSERT INTO fuf_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ɓay o nanii wonde Iisaa iwii ka diiwal Yahuuda arii Jaliilu, on ari tawi mo, o torii mo yahugol ndikkinoya on ɓiɗɗo makko wonɗo e daande mayde. ");
INSERT INTO fuf_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Iisaa wi'i mo: «Onon si on yi'aali maandeeji e kaawakeeji, on gomɗintaa few!» ");
INSERT INTO fuf_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Kono on yeesoojo laamateeri ndin wi'i mo: «Koohoojo, seenee ado paykun an kun maayude!» ");
INSERT INTO fuf_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Iisaa wi'i mo: «Yahu, ɓiɗɗo maa on ndikkii.» On neɗɗo hoolii kongol ngol Iisaa wi'i mo ngol, o yahi. ");
INSERT INTO fuf_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","E nder ko o yiltitotoo kon, o fotti e kurkaaɗi makko ɗin, ɓen wi'i mo wonde ɓiɗɗo makko on ndikkii. ");
INSERT INTO fuf_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","O landii ɓe ko e saa'i hombo hayfani paykun kun. Ɓen jaabii mo: «Ko hanki tumbere ɲalorma nguli ɓandu kin yalti e makko.» ");
INSERT INTO fuf_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Onsay kanko baabaajo on o anditi ko e on saa'i tigi Iisaa wi'i mo «ɓiɗɗo maa on ndikkii.» Onsay o gomɗini, kanko e yimɓe suudu makko ndun fow. ");
INSERT INTO fuf_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ko ndee maande hawniinde ɗoo woni ɗimmere nde o waɗi ɓay o iwii ka diiwal Yahuuda, o arii Jaliilu. ");
INSERT INTO fuf_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ɓawto ɗun, juldeere Yahuudiyankeeɓe waɗi. Iisaa yahi Yerusalaam. ");
INSERT INTO fuf_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Tawi beelun no Yerusalaam ɗon ka binde dambugal wi'eteengal Dambugal Baali. Kun beelun no wi'ee e haala Yahuudiyanke Betesada, caaliiji jowi no hundi kun. ");
INSERT INTO fuf_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Nawnuɓe ɗuuɗuɓe no waalii e ley ɗin caaliiji, ɗun ko gila e bumɓe e boofooɓe e maaya-ɓanduuɓe, ");
INSERT INTO fuf_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Tawi goɗɗo no ɗon, ɲawɗo gila duuɓi cappanɗe tati e jeetati. ");
INSERT INTO fuf_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Iisaa yi'i on no waalii, o andi on no ɗon gila neeɓii. Kanko Iisaa o wi'i on: «Hiɗa faalaa hettude cellal?» ");
INSERT INTO fuf_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ɲawɗo on jaabii mo, wi'i: «Koohoojo, mi alaa hay gooto ko yollammi ka nder beelun si ndiyan ɗan memminike. Ɗoo yo wonu mi hewtii, haray goɗɗo attike lan yollaade.» ");
INSERT INTO fuf_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Onsay Iisaa wi'i mo: «Immo, ƴettaa dankun maa kun, yahaa.» ");
INSERT INTO fuf_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ɗon kisan on neɗɗo hetti cellal, o ƴetti dankun makko kun, o woni e jindugol. Ɗun hawrondiri e *aseweere, ɗun ko *ɲalaande fowteteende e mun nden. ");
INSERT INTO fuf_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Hooreeɓe Yahuudiyankeeɓe ɓen wi'i on sellinaaɗo: «Ko ɲalaande fowteteende nii! Hande daganaaki ma ƴettugol danki maa kin!» ");
INSERT INTO fuf_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Kono o jaabii ɓe, o wi'i: «Ko sellinɗo lan on wi'immi: ‹Ƴettu dankun maa kun, yahaa.› » ");
INSERT INTO fuf_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Onsay ɓen landii mo: «Ko neɗɗo hombo wi'u-maa: ‹Ƴettu, yahaa›?» ");
INSERT INTO fuf_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Kono tawi on sellinaaɗo andaa ko hombo, ko fii hari Iisaa majjitorii mo e hakkunde yimɓe wonnooɓe e nden nokkuure ɓen. ");
INSERT INTO fuf_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ɓawto ɗun Iisaa tawti mo ka *juulirde mawnde, o wi'i mo: «E hino a hettii cellal. Wota a waɗitu junuubu hande kadi, fii wota goɗɗun goo heɓe ko ɓuri ɗunɗoo bonde.» ");
INSERT INTO fuf_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Onsay on neɗɗo yiltitii, wi'i hooreeɓe Yahuudiyankeeɓe ɓen wonde ko Iisaa sellini mo. ");
INSERT INTO fuf_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ko waɗi si hooreeɓe Yahuudiyankeeɓe ɓen cukkii Iisaa, ko sabu tawde o waɗii ɗun e aseweere. ");
INSERT INTO fuf_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Kono Iisaa jaabii ɓe, wi'i: «Ben an no gollude haa jooni. Min kadi miɗo gollude.» ");
INSERT INTO fuf_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Sabu ɗun hooreeɓe Yahuudiyankeeɓe ɓen ɓurti ɗaɓɓude no warira mo, ɗun non hinaa fii tun himo bonni Sariya on e asewe, ɗun ko ɲalaande fowteteende nden, kono ko fii himo inni kadi Alla ko Ben makko, ko nii o waɗitori himo fota e Alla. ");
INSERT INTO fuf_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Kono Iisaa jaabii ɓe, wi'i: «Ka haqiiqa haqiiqa mi andinii on, Ɓiɗɗo on waawataa waɗude hay huunde immorde e makko kanko tigi, si hinaa ko o yi'i Baabaajo on no waɗa kon. E kala ko Baabaajo on waɗi, Ɓiɗɗo on kadi waɗiray wano non. ");
INSERT INTO fuf_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ko fii Baabaajo on no yiɗi Ɓiɗɗo on, o hollay mo kadi kala ko o waɗata. Awa kadi o hollay mo kuuɗe ɓurɗe ɗee ɗoo, fii no woniron e nder ŋalaw. ");
INSERT INTO fuf_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ko ɗun waɗi, wano Baabaajo on immintinirta mayɓe ɓen non, o wurnita ɓe, ko wano non kadi Ɓiɗɗo on wurnitirta on mo o faalaa wurnitude. ");
INSERT INTO fuf_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ko wattii e ɗun, Baabaajo on ɲaawataa hay gooto, kono o wattii kala ɲaawoore e juuɗe Ɓiɗɗo on, ");
INSERT INTO fuf_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","fii yo fow teddin Ɓiɗɗo on wano ɓe teddiniri Baabaajo on non. On mo teddinaali Ɓiɗɗo on haray teddinaali Baabaajo on, on Nuluɗo mo. ");
INSERT INTO fuf_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","«Ka haqiiqa haqiiqa mi andinii on, kala on heɗiiɗo kongol an ngol, gomɗini Nuluɗo lan on, haray on no e *ngurndan poomayankejan. Awa kadi o aretaake e ɲaaweede, ko fii haray o iwii e mayde, o arii e ngurndan. ");
INSERT INTO fuf_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ka haqiiqa haqiiqa mi andinii on, saa'i araynooɗo on ko fewndo ɗoo, nde mayɓe ɓen nani hawa *Ɓiɗɗo Alla on, ɓen nanuɓe wuura. ");
INSERT INTO fuf_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ko wano non, nde tawnoo ko Baabaajo on woni ɓundu ngurndan, ko wano non kadi o yeɗiri Ɓiɗɗo on wonugol ɓundu ngurndan, ");
INSERT INTO fuf_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","o yeɗi mo kadi bawgal waɗugol ɲaawoore nden, ɓay ko kanko woni *Ɓii-Aaden on. ");
INSERT INTO fuf_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Wota ɗun ŋalɗin on, ko fii saa'i no arude mo tawata wonɓe ka genaale ɓen fow nanay hawa makko kan, ɓe immitoo. ");
INSERT INTO fuf_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Waɗunooɓe ko moƴƴi ɓen immitoo ummutal ngurndan, waɗunooɓe ko boni ɓen immitoo ummutal ɲaawoore. ");
INSERT INTO fuf_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Min non, mi waawataa waɗude hay huunde immorde e an min tigi, ko ko mi naniri Alla kon mi ɲaawirta. Ɲaawoore an nden-le ko feewunde, ko fii hinaa faale an on mi woni waɗude, kono ko faale Nuluɗo lan on.» ");
INSERT INTO fuf_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","«Si ko min woni seeditanaade hoore an, haray seeditoore an nden wonaa goonga. ");
INSERT INTO fuf_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ko goɗɗo goo seeditanii lan. Miɗo andi non kon ko o seeditii fii an ko goonga. ");
INSERT INTO fuf_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Onon on nelii woɓɓe e Yaayaa, o seeditanii goonga on. ");
INSERT INTO fuf_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Min non mi hatonjinaa yo neɗɗo seeditano lan. Ko mi wowliri fii seeditoore Yaayaa nden, ko fii yo on dande. ");
INSERT INTO fuf_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yaayaa hari ko lampu huɓɓuɗo ndayguɗo, faalaɗon weltorde ndaygu makko ngun e nder saa'ihun. ");
INSERT INTO fuf_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","«Min miɗo mari seedee ɓurɗo mo Yaayaa on mawnude, ko fii kuuɗe ɗe Baabaajo on jonni lan fii laatingol ɗen, ko ɗen kuuɗe tigi woni seeditanaade lan wonde ko Baabaajo on nuli lan. ");
INSERT INTO fuf_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","On non Baabaajo Nuluɗo lan, kanko tigi o seeditike fii an. Haa hande on nanaali hito makko, maa yi'on mbaadi makko, ");
INSERT INTO fuf_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","awa kadi daaluyee makko on tabitaa e mon, ko fii on gomɗinaali mo o nuli on. ");
INSERT INTO fuf_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Hiɗon taskoo bindi ɗin, ɓay hiɗon sikka ko kanji heɓirton ngurndan poomayankejan, e hin-le ko ɗin seeditii fii an. ");
INSERT INTO fuf_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","E hara-le on faalaaka arude e an fii heɓugol ngurndan ɗan. ");
INSERT INTO fuf_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","«Min-le, mi alaa ɗaɓɓude no yimɓe ɓen mantirammi. ");
INSERT INTO fuf_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Kono miɗo andi on, on joganaaki Alla giggol. ");
INSERT INTO fuf_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Min ko e innde Ben an mi ari, kono on wernaali lan. Kono si goɗɗo arii e innde mun, on wernay mo. ");
INSERT INTO fuf_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ko honno gomɗinirton onon, si tawii ko mantindirgol yiɗuɗon, hara hinaa ɗaɓɓugol mantoore iwrunde ka Allaahu Bajjo on nden? ");
INSERT INTO fuf_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","«Wota on sikku min mi felay on yeeso Ben an. Ko Muusaa woni feloowo on on, on mo hoolorɗon. ");
INSERT INTO fuf_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ko fii si on gomɗinno Muusaa, on gomɗinayno lan min kadi, ɓay himo windi fii an. ");
INSERT INTO fuf_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Kono si on gomɗinaa bindi makko ɗin, haray ko honno gomɗinirton konguɗi an ɗin?» ");
INSERT INTO fuf_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ɓawto ɗun Iisaa yahi, wontiri gaɗa *Weendu Jaliilu ndun. (Ndun weendu no wi'ee kadi Tiberiyaada.) ");
INSERT INTO fuf_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Tawi jamaa ɗuuɗuɗo no jokki mo sabu maandeeji hawniiɗi ɗi ɓe yi'aynoo himo waɗa ɗin e hoore nawnuɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Kanko Iisaa o ƴawi ɗon e hoore fello, o jooɗodi ɗon e taalibaaɓe makko ɓen. ");
INSERT INTO fuf_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Tawi juldeere Yahuudiyankeeɓe ɓen, ɗun ko *Juldeere Yawtaneede nden, ɓadike. ");
INSERT INTO fuf_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Onsay Iisaa ɓanti gite ɗen, yi'i on jamaa ɗuuɗuɗo no ara e makko. O wi'i Filiipu: «Ko honto soodeten ɗoo ɲaametee fii ko ɓee yimɓe ɲaama?» ");
INSERT INTO fuf_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(Ko o wiirunoo ɗun ko fii ndarndagol mo, ko fii hari himo andunoo ko honɗun o waɗata.) ");
INSERT INTO fuf_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filiipu jaabii mo, wi'i: «Hay *dinaruuji teemeɗɗe ɗiɗi yonataa ko soodee bireedi haa ɗun yona fii yo mo kala heɓu seeɗa!» ");
INSERT INTO fuf_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Goɗɗo e taalibaaɓe makko ɓen no wi'ee Andaraawu, ɗun ko oo miɲɲiraawo Sim'uunu Petruusu, wi'i mo: ");
INSERT INTO fuf_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«Suka no ɗoo marɗo bireediije jowi e liƴƴi ɗiɗi. Kono ko honɗun ɗun nafata oo jamaa ɗoo fow?» ");
INSERT INTO fuf_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Onsay Iisaa wi'i: «Joɗɗinee yimɓe ɓen.» Tawi huɗo buy no e nden nokkuure. Ɓen jooɗii, tawi ko wa ɓe worɓe guluuje njowo. ");
INSERT INTO fuf_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ɓawto ɗun Iisaa ƴetti bireedi on, o jarni Alla, o senditani wonɓe ɗon ɓen. O waɗiri liƴƴi ɗin kadi wano non haa mo ɓee heɓi yeru faale mun on. ");
INSERT INTO fuf_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ɓay wonii ɓe haarii, o wi'i taalibaaɓe makko ɓen: «Mooɓitee kunte luttuɗe ɗen fii wota hay huunde bonu.» ");
INSERT INTO fuf_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ɓen hocci ɗe, ɓe hebbini debeeje sappoo e ɗiɗi ko ɲaamaa luttinaa ko iwi e ɗen bireediije jowi. ");
INSERT INTO fuf_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ɓay ɓen yimɓe yi'ii nden maande hawniinde nde Iisaa waɗi, ɓe wi'i: «Ko oo tigi woni Annabaajo haanuɗo arude ka aduna on!» ");
INSERT INTO fuf_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ɓay Iisaa andii wonde ɓe faandanike ƴettugol mo lammina, o sortii e hakkunde maɓɓe, o woni feere ka fello ton. ");
INSERT INTO fuf_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ɓay wonii niɓɓii, taalibaaɓe makko ɓen tippori ka weendu. ");
INSERT INTO fuf_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ɓe bakii e laakun fii yahugol e ngoya sengo weendu ndun, ɗun ko Kafernahuum, tawi niwre nden waɗii, ɓe yiitidaali e Iisaa taho. ");
INSERT INTO fuf_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Onsay hendu dolnundu wifi, ndiyan weendu ndun yeƴii. ");
INSERT INTO fuf_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ɓay wonii ɓe awƴinii laakun kun wa kilomeeterji jowi maa jeegoo, ɓe haccii Iisaa no seppa ara ka hoore ndiyan, himo ɓadaade laakun kun, onsay ɓe huli. ");
INSERT INTO fuf_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Kono Iisaa wi'i ɓe: «Ko min nii! Wota on hulu!» ");
INSERT INTO fuf_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Tawi hiɓe faalaa mo ƴettude tumba ka nder laakun, tun laakun kun hewti leydi ka ɓe yahaynoo ɗon. ");
INSERT INTO fuf_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Bimbi nden ɲande, jamaa wonnooɗo e ngoya sengo weendu ndun ndaari tawi ko laakun gootun wonnoo ɗon, awa kadi Iisaa bakodaano e taalibaaɓe mun ɓen e kun laakun, kono ko taalibaaɓe ɓen tun yahi. ");
INSERT INTO fuf_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Onsay laakoy goo iwroyi Tiberiyaada, ɓe ari e binde ndee nokkuure nde ɓen ɲaamunoo bireedi e mun ɓawto Koohoojo on jarnude. ");
INSERT INTO fuf_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ɓay ɓen yimɓe ndaarii tawii Iisaa woo, taalibaaɓe mun ɓen woo alaa ɗon, ɓe bakii kamɓe tigi e koy laakoy, ɓe yahi Kafernahuum fii ɗaɓɓitoygol Iisaa. ");
INSERT INTO fuf_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ɓen yimɓe tawtiroyi Iisaa ka gaɗa weendu, ɓe wi'i mo: «Karamoko'en, nde hewtuɗon ɗoo?» ");
INSERT INTO fuf_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Iisaa jaabii ɓe, wi'i: «Ka haqiiqa haqiiqa mi andinii on, hinaa fii on yi'ii maandeeji hawniiɗi wonɗon mi ɗaɓɓitirde, kono ko fii on ɲaamii haa on haarii. ");
INSERT INTO fuf_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Wota on yangano ɲaametee lannoowo on, kono yanganee ɲaametee luttoowo fii *ngurndan poomayankejan ɗan on, ɗun ko on mo *Ɓii-Aaden on yeɗata on, ko fii ko e makko Alla Baabaajo on noti maande mun nden.» ");
INSERT INTO fuf_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ɓen kadi wi'i mo: «Ko honɗun men waɗata fii yo men huuwu kuuɗe ɗe Alla faalaa ɗen?» ");
INSERT INTO fuf_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Iisaa jaabii ɓe, wi'i: «Ko woni kuugal ngal Alla faalaa ngal, ko yo on gomɗin on mo o nuli.» ");
INSERT INTO fuf_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ɓe wi'i mo kadi: «Ko maande hawniinde honde waɗataa jooni, men yi'a, men gomɗine? Ko kuugal hongal waɗataa? ");
INSERT INTO fuf_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Baabiraaɓe men ɓen ɲaamuno ‹*manna› ka wulaa, wano windori non: ‹O okkori ɓe bireedi immorde ka kammu.› » ");
INSERT INTO fuf_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Onsay Iisaa jaabii ɓe, wi'i: «Ka haqiiqa haqiiqa mi andinii on, hinaa Muusaa okkori on bireedi immorde ka kammu, kono ko Ben an okkori on bireedi tigi-tigiijo iwrude ka kammu. ");
INSERT INTO fuf_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ko fii bireedi Alla on ko on Iwroowo ka kammu, yeɗa yimɓe ɓen ngurndan.» ");
INSERT INTO fuf_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Onsay ɓe wi'i mo: «Koohoojo, awa okkor men saa'i kala on bireedi.» ");
INSERT INTO fuf_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Iisaa wi'i ɓe kadi: «Ko min woni Bireedi Wurnoowo on: kala arɗo e an weeletaake hande kadi, e kala on gomɗinɗo lan ɗonɗetaake hande kadi. ");
INSERT INTO fuf_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Kono mi andinii on, on yi'ii lan, kono on gomɗinaali. ");
INSERT INTO fuf_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Kono ɓe Baabaajo on yeɗi lan ɓen fow aray e an, kala non on arɗo e an mi raɗotaako mo. ");
INSERT INTO fuf_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ko fii hinaa waɗugol faale an on tippinimmi iwrude ka kammu, kono ko waɗugol faale Nuluɗo lan on. ");
INSERT INTO fuf_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ko fii e hino faale on Nuluɗo lan: ko wota hay gooto e ɓe o yeɗimmi ɓen hayru, kono ko yo mi immintin ɓe ka ɲalaande sakkitorde. ");
INSERT INTO fuf_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ko woni faale Ben an on kon, ko kala yi'uɗo Ɓiɗɗo on, gomɗini mo, yo heɓu ngurndan poomayankejan, awa kadi mi immintina mo ka ɲalaande sakkitorde.» ");
INSERT INTO fuf_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Onsay Yahuudiyankeeɓe ɓen fuɗɗii ŋunude fii makko, ɓay hari o wi'ii ko kanko woni Bireedi Iwruɗo ka kammu on. ");
INSERT INTO fuf_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Tawi hiɓe wi'a: «E hara hinaa oo woni Iisaa, ɓiɗɗo Yuusufu on, on mo anduɗen yumma mun e ben mun? Ko honno non on wi'irta ko ka kammu o iwri?» ");
INSERT INTO fuf_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Onsay Iisaa jaabii ɓe, wi'i: «Wota on ŋunu hakkunde mon. ");
INSERT INTO fuf_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Hay gooto waawataa arude e an si hinaa hara ko Baabaajo Nuluɗo lan on pooɗi mo, mi immintinoya mo ka ɲalaande sakkitorde. ");
INSERT INTO fuf_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","No windii ka defte annabaaɓe ɓen wonde: ‹Alla jannay ɓe fow.› Kala on nananɗo Baabaajo on, jaɓi gandal iwrungal ka makko ngal, aray e an. ");
INSERT INTO fuf_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Hay gooto yi'aali Baabaajo on, si hinaa on Iwruɗo ka Alla, on kaɲun yi'ii Baabaajo on. ");
INSERT INTO fuf_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ka haqiiqa haqiiqa mi andinii on, kala gomɗinɗo haray heɓii ngurndan poomayankejan ɗan. ");
INSERT INTO fuf_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ko min woni Bireedi Wurnoowo on. ");
INSERT INTO fuf_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Baabiraaɓe mon ɓen ɲaamuno ‹manna› ka wulaa, kono ɓe maayuno. ");
INSERT INTO fuf_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","E hino ɗoo Bireedi tippiiɗo iwrude ka kammu on, fii kala ɲaamuɗo mo wota maayu. ");
INSERT INTO fuf_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ko min woni Bireedi Wurɗo tippiiɗo iwruɗo ka kammu on, kala ɲaamuɗo oo bireedi, ontigi wuuray haa poomaa. Ko ɓandu an ndun woni on bireedi mo mi okkitirta, fii no aduna on wuurira.» ");
INSERT INTO fuf_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Onsay Yahuudiyankeeɓe ɓen sonki hakkunde maɓɓe, ɓe wi'i: «Ko honno oo waawirta okkude en teewu mun ngun, yo en ɲaamu?» ");
INSERT INTO fuf_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Onsay Iisaa wi'i ɓe: «Ka haqiiqa haqiiqa mi andinii on, si on ɲaamaali teewu Ɓii-Aaden on, yaron ƴiiƴan makko ɗan, haray on heɓataa ngurndan. ");
INSERT INTO fuf_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ko fii kala ɲaamuɗo teewu an ngun, yari ƴiiƴan an ɗan, haray heɓii ngurndan poomayankejan, awa kadi mi immintinay mo ka ɲalaande sakkitorde. ");
INSERT INTO fuf_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ko fii teewu an ngun ko neema tigi, awa kadi ƴiiƴan an ɗan ko njaram tigi. ");
INSERT INTO fuf_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ko fii kala ɲaamuɗo teewu an ngun, yari ƴiiƴan an ɗan, haray o humondirii e an, min kadi mi humondirii e makko. ");
INSERT INTO fuf_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ɓay Baabaajo Wurɗo on nulii lan, awa kadi miɗo wuuriri Baabaajo on, ko non kadi kala on ɲaamuɗo lan wuurirta sabu an. ");
INSERT INTO fuf_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ko oo ɗoo woni Bireedi tippiiɗo iwri ka kammu on. O wa'aa wa mo baabiraaɓe mon ɓen ɲaami on, ɓe maayi. Kala on ɲaamuɗo oo bireedi ɗoo wuuray haa poomaa.» ");
INSERT INTO fuf_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ko ɗun Iisaa wi'unoo wa fewndo ko o jannaynoo ka juulirde Kafernahuum. ");
INSERT INTO fuf_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ɓay ɓe nanii ɗun, buy e hakkunde taalibaaɓe makko ɓen wi'i: «Ngol kongol no satti. Ko hombo waawi jaɓude ngol?» ");
INSERT INTO fuf_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ɓay Iisaa andanii hoore mun wonde taalibaaɓe makko ɓen no ŋunude fii ɗun, o wi'i ɓe: «E hara ɗun feggin on? ");
INSERT INTO fuf_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","E si on yi'ii non Ɓii-Aaden on no ƴenta ka wonnoo ton? ");
INSERT INTO fuf_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Awa, ko Ruuhu Alla on wurnata, ɓandu ndun nafataa huunde. Ɗii konguɗi, ɗi mi yewtata on, ko iwruɗi e Ruuhu Allaahu yeɗoowo ngurndan on. ");
INSERT INTO fuf_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Kono woɓɓe no e hakkunde mon ɓe gomɗinaa.» (Ko Iisaa wi'irnoo ɗun, ko fii hari himo andi gila ka fuɗɗoode ko hombo woni mo gomɗinaa, e ko hombo janfoytoo mo.) ");
INSERT INTO fuf_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","O ɓeyditi kadi, o wi'i: «Ko ɗun waɗi si mi wi'ii on: Hay gooto waawataa arude e an si hinaa taw hara ko Baabaajo on yeɗi ontigi.» ");
INSERT INTO fuf_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Gila nden ɲande ɓuy e taalibaaɓe makko ɓen yiltii, ɓe acciti yaadugol e makko. ");
INSERT INTO fuf_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Onsay Iisaa wi'i sappoo e ɗiɗooɓe ɓen: «E onon-le, on faalaaka yahude?» ");
INSERT INTO fuf_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Onsay Sim'uunu Petruusu jaabii mo, wi'i: «Koohoojo, men jokka hombo? Ko onon jogii konguɗi ngurndan poomayankejan ɗan. ");
INSERT INTO fuf_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Awa men gomɗinii, men andii kadi wonde ko onon woni *Seniiɗo mo Alla!» ");
INSERT INTO fuf_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Onsay Iisaa jaabii ɓe, wi'i: «E wonaa ko min suɓii on, onon sappoo e ɗiɗooɓe ɓen? Kono goɗɗo e mon ko mo Ibuliisa.» ");
INSERT INTO fuf_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Tawi ko Yudaasi mo Sim'uunu Iskariiyu o woni wowlude fii mun, ko fii ko on janfoytoo mo, on ko goɗɗo e sappoo e ɗiɗooɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ɓawto ɗun Iisaa woni e jindugol e nder diiwal Jaliilu ngal, tawi o yiɗaa jindude few e nder diiwal Yahuuda ngal, ko fii hari hooreeɓe Yahuudiyankeeɓe ɓen no ɗaɓɓude no warira mo. ");
INSERT INTO fuf_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Hawrondiri juldeere Yahuudiyankeeɓe, wi'eteende nden *Juldeere Togooji, ɓadike. ");
INSERT INTO fuf_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Onsay neene-gootooɓe makko ɓen wi'i mo: «Iwu ɗoo, yahaa ka diiwal Yahuuda, fii yo taalibaaɓe maa ɓen yi'u kuuɗe ɗe wonɗaa waɗude ɗen. ");
INSERT INTO fuf_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ko fii hay gooto waɗataa huunde e nder gundoo si tawii himo ɗaɓɓude andeede e kene. Si a waɗay ɗii piiji, hollito e aduna on.» ");
INSERT INTO fuf_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Tawi ɓen neene-gootooɓe makko tigi gomɗinaa mo kanko Iisaa. ");
INSERT INTO fuf_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Onsay Iisaa jaabii ɓe, wi'i: «Saa'i on hewtanaali lan taho, kono onon saa'i kala no moƴƴani on. ");
INSERT INTO fuf_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ko fii aduna on waawataa on aɲude, min non, himo joganii lan ngayngu, ɓay miɗo seeditaade e hoore makko wonde kuuɗe makko ɗen ko bonɗe. ");
INSERT INTO fuf_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Onon yahee ka juldeere. Min mi alaa yahude taho e nden juldeere, ko fii saa'i an on hewtaali taho.» ");
INSERT INTO fuf_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ɓay wonii o wi'ii ɓe ɗun, o wonti Jaliilu ɗon. ");
INSERT INTO fuf_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ɓay wonii neene-gootooɓe makko ɓen yahii ka juldeere, kanko kadi o yahi, kono e nder gundoo e ɓaawo hollitagol. ");
INSERT INTO fuf_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Tawi hooreeɓe Yahuudiyankeeɓe ɓen no ɗaɓɓa mo, wi'a: «Ko honto o woni?» ");
INSERT INTO fuf_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Tawi ŋunu-ŋunu fii makko on no ɗuuɗi e hakkunde yimɓe ɓen. Woɓɓe e maɓɓe no wi'a: «Ko o neɗɗo moƴƴo», ɓeya ɓen kadi no wi'a: «Oo'o, o majjinay woni jamaa on.» ");
INSERT INTO fuf_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Kono tawi hay gooto alaa wowlude fii makko e kene sabu kulol hooreeɓe Yahuudiyankeeɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Wa fewndo ko juldeere nden feccii e hakkunde, Iisaa yahi ka *juulirde mawnde woni e jannugol. ");
INSERT INTO fuf_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Onsay Yahuudiyankeeɓe ɓen ŋalɗi, ɓe wi'i: «Ko honno oo andiri bindi ɗin, o jangaali!» ");
INSERT INTO fuf_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Onsay Iisaa jaabii ɓe, wi'i: «Gandal an ngal hinaa e an iwi, kono ko e Nuluɗo lan on. ");
INSERT INTO fuf_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Kala faalaaɗo waɗude faale Alla on anday si ko e makko ndee jannde iwri, e si tawii ɗii konguɗi an ko e immorde e an min. ");
INSERT INTO fuf_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","On mo no wowlude konguɗi iwruɗi e mun, haray ko hoore mun woni ɗaɓɓande darja, kono on mo no ɗaɓɓude darja nuluɗo ɗun on, haray on ko goongaajo, haray angal peewal alaa e makko. ");
INSERT INTO fuf_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","E hara Muusaa jonnaano on Sariya on? Kono hay gooto e mon jokkaali on Sariya. E ko fii honɗun non eɓɓanton warugol lan?» ");
INSERT INTO fuf_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Yimɓe ɓen jaabii mo, wi'i: «An, jinnaaru no e maa! Ko hombo woni ɗaɓɓude no warire?» ");
INSERT INTO fuf_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Onsay Iisaa jaabii ɓe, wi'i: «Mi waɗii kuugal gootal, on fow on ŋalɗii. ");
INSERT INTO fuf_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Muusaa yamirii on *sunningol, hay si tawii non ɗun wonaa e makko iwri, kono ko e maamaaɓe mon ɓen. Kono onon hiɗon waɗude ɗun e *ɲalaande fowteteende nden. ");
INSERT INTO fuf_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Si goɗɗo sunninaama e asewe, fii tun wota Sariya Muusaa on bonne, haray ko fii honɗun seytinanton mi fii miɗo sellini goɗɗo o fow makko e asewe, ɗun ko ɲalaande fowteteende e mun nden? ");
INSERT INTO fuf_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Awa accee ɲaawirgol ko sikkuɗon kon tun, kono ɲaawee ɲaawoore feewunde.» ");
INSERT INTO fuf_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Tun, woɓɓe e hoɗuɓe Yerusalaam ɓen woni e wi'ugol: «E hara hinaa oo wonaa ɗaɓɓeede fii waregol? ");
INSERT INTO fuf_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","E hino ka o woni wowlude e kene, o alaaka wi'eede hay huunde. E taw si hara yeesooɓe ɓen fottii wonde ko oo woni *Almasiihu on? ");
INSERT INTO fuf_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","E hin-le hiɗen andi oo ɗoo ko mo o honto, kono nde Almasiihu on ari, hay gooto andataa ko mo o honto.» ");
INSERT INTO fuf_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Onsay Iisaa ewnii fewndo ko o jannata ka juulirde mawnde, o wi'i: «Hiɗon andi lan, hiɗon andi kadi ko mo mi honto. E hara-le wonaa hoore an mi arani, kono Imminɗo lan on ko o goonga, onon-le on andaa mo. ");
INSERT INTO fuf_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Min non miɗo andi mo, ɓay ko ka makko mi iwri, ko kanko nulimmi.» ");
INSERT INTO fuf_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Onsay ɓe woni e ɗaɓɓugol no ɓe nangira mo, kono laatii hay gooto fawaali mo jungo, ko fii hari saa'i makko on hewtaali. ");
INSERT INTO fuf_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Buy e hakkunde jamaa on gomɗini mo, ɓe wi'i: «E hara, nde Almasiihu on aroyi, taw si o waɗoyay maandeeji hawniiɗi ɓurɗi ɗi oo ɗoo waɗi ɗin?» ");
INSERT INTO fuf_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ɓay *Fariisiyaaɓe ɓen nanii ko jamaa on woni sowndaade fii makko kon, onsay hooreeɓe *yottinooɓe sadaka ɓen e Fariisiyaaɓe ɓen immini suufaaɓe ko nanga mo. ");
INSERT INTO fuf_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Kono Iisaa wi'i: «Miɗo wondi e mon taho seeɗa si mi yiltitoo ka Nuluɗo lan on. ");
INSERT INTO fuf_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Onsay on ɗaɓɓitay lan, on yi'ataa lan, e ka mi wonoyta ɗon, on waawoytaa yahoyde ɗon.» ");
INSERT INTO fuf_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Onsay hooreeɓe Yahuudiyankeeɓe ɓen wi'indiri: «E hara ko honto o yahoyta fii wota en tawoy mo? E hara o yahay e jamaa men saakitiiɗo e hakkunde *Gereekiyankeeɓe ɓen, o janna ɓen Gereekiyankeeɓe? ");
INSERT INTO fuf_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ko honɗun woni ngol kongol ngol o wi'i wonde: ‹On ɗaɓɓay lan, on yi'ataa lan, e ka mi yahata ɗon on waawataa hewtoyde ɗon?› » ");
INSERT INTO fuf_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ɲalaande sakkitorde juldeere nden, ɗun ko ɲalaande ɓurnde mawnude nden, Iisaa immii, o ewnii, o wi'i: «On mo no ɗonɗaa yo aru e an, o yara! ");
INSERT INTO fuf_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ko fii kala on gomɗinɗo lan, canɗi ndiyan wurnayɗan ɓulay e ontigi, wano bindi ɗin wi'iri non.» ");
INSERT INTO fuf_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Tawi ko Iisaa woni wowlude fii mun ko Ruuhu Allaahu mo gomɗinɓe mo ɓen yeɗoytee on, ko fii hari Ruuhu Allaahu on yeɗaaka taho, ɓay hari kanko Iisaa o ƴentinaaka taho ka mangural. ");
INSERT INTO fuf_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ɓay woɓɓe goo e hakkunde jamaa on nanii ɗin konguɗi, ɓe wi'i: «Sikke woo alaa, ko oo woni Annabaajo habbanooɗo on!» ");
INSERT INTO fuf_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Tawi ɓeya no wi'a: «Ko oo woni Almasiihu on!» Ɓeya kadi no wi'a: «E hara ko diiwal Jaliilu Almasiihu on feeɲirta? ");
INSERT INTO fuf_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","E hara defte ɗen wi'aali wonde Almasiihu on ko e jurriya Daawuuda on iwata, e hoore ɗun ko e koɗolun no wi'ee Bayti-Lahiimi, ɗun ko ka Daawuuda wonnoo ɗon, o feeɲata?» ");
INSERT INTO fuf_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ɗun waɗi haa jamaa on yeddondiri sabu makko. ");
INSERT INTO fuf_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Woɓɓe e hakkunde maɓɓe faalaa mo nangude, kono hay gooto fawaali mo juuɗe. ");
INSERT INTO fuf_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Onsay suufaaɓe ɓen yiltitii ka hooreeɓe yottinooɓe sadaka ɓen e ka Fariisiyaaɓe ɓen, ɓen wi'i suufaaɓe ɓen: «Fii honɗun on addaali mo?» ");
INSERT INTO fuf_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Suufaaɓe ɓen jaabii ɓe, wi'i: «Hay gooto yewtiraali wano oo neɗɗo yewtirta nii!» ");
INSERT INTO fuf_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Fariisiyaaɓe ɓen jaabii ɓe kaɲun kadi, wi'i: «E hara onon kadi, ɗun faljinii on? ");
INSERT INTO fuf_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Kaa hara no woodi goɗɗo e yeesooɓe ɓen maa goɗɗo e Fariisiyaaɓe ɓen gomɗinɗo mo? ");
INSERT INTO fuf_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Kono oo jamaa mo andaa Sariya ko huɗaaɗo!» ");
INSERT INTO fuf_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Onsay Nikodiyuusu jeydaaɗo e maɓɓe kamɓe Fariisiyaaɓe ɓen, ɗun ko yiidoynooɗo e Iisaa e saa'i goo, wi'i ɓe: ");
INSERT INTO fuf_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«E hara Sariya men on no waawi ɲaawude sifa oo neɗɗo ado jentaade mo, anden ko honɗun o waɗi?» ");
INSERT INTO fuf_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Kamɓe kadi ɓe jaabii mo, ɓe wi'i: «E hara an kadi, ko mo a Jaliilu? Tasko moƴƴa, a taway annabaajo feeɲirtaa Jaliilu.» ");
INSERT INTO fuf_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Onsay mo kala e maɓɓe yiltitii ka suudu mun. ");
INSERT INTO fuf_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Iisaa kaɲun yaari ka Fello *Zaytuuni. ");
INSERT INTO fuf_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Kono no weetirnoo, o arti kadi ka *juulirde mawnde. Jamaa on fow kadi ari e makko, o jooɗii, o woni e jannugol ɓe. ");
INSERT INTO fuf_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Onsay jannooɓe fii Sariya on ɓen e *Fariisiyaaɓe ɓen addi debbo mo ɓe nangi no waɗa jinaa, ɓe joɗɗini mo hakkunde. ");
INSERT INTO fuf_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ɓe wi'i Iisaa: «Karamoko, oo debbo nanga no waɗa jinaa. ");
INSERT INTO fuf_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ko fii ka Sariya, Muusaa no yamiri fiɗugol sifa oo kaaƴe. An non, ko honɗun wi'uɗaa?» ");
INSERT INTO fuf_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Tawi ko ɓe wonnoo wi'irde ɗun, ko fii ndarndagol mo fii no ɓe heɓira feere no ɓe tooɲira mo. Kono Iisaa ugginii, o nangi windirgol hondu makko ndun ka leydi. ");
INSERT INTO fuf_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Nde tawnoo hiɓe catii e landagol mo tun, o ɓantii, o wi'i ɓe: «On mo aldaa e junuubu hakkunde mon yo ado fiɗude mo hayre.» ");
INSERT INTO fuf_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","O ugginii kadi, o woni e windugol ka leydi. ");
INSERT INTO fuf_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ɓay wonii ɓen nanii ɗun, ɓe sortori gooto gooto, gila e ɓurɓe mawnude ɓen, lutti ɗon Iisaa tun e debbo wonnooɗo on ka hakkunde. ");
INSERT INTO fuf_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ɓawto ɗun Iisaa ɓantii, wi'i mo: «Debbo, honto tooɲuɓe ma ɓen woni? E hay gooto fawaali ma ɲaawoore?» ");
INSERT INTO fuf_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Debbo on jaabii, wi'i: «Koohoojo, hay gooto.» Iisaa kadi wi'i mo: «Min kadi men, mi faawaali ma ɲaawoore. Yahu, wota a waɗitu junuubu hande kadi.» ");
INSERT INTO fuf_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ɓawto ɗun Iisaa yewti yimɓe ɓen, o wi'i: «Ko min woni Ndaygu aduna on. Kala on jokkuɗo lan yahataa han kadi ka nder niɓe, e hoore ɗun, ontigi heɓay ndaygu ngurndan ɗan.» ");
INSERT INTO fuf_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Sabu ɗun Fariisiyaaɓe ɓen wi'i mo: «Hiɗa seeditanaade hoore maa, awa seeditoore maa nden wonaa goonga.» ");
INSERT INTO fuf_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Iisaa kadi jaabii ɓe, wi'i: «Hay si mi seeditani hoore an, haray nden seeditoore an ko goonga, ko fii miɗo andi ko honto mi iwi e ko honto mi yahata. Kono onon on andaa ko honto mi iwi e ko honto mi yahata. ");
INSERT INTO fuf_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Onon, ko no yimɓe ɓen ɲaawirta non ɲaawirton, min non, mi ɲaawataa hay gooto. ");
INSERT INTO fuf_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Min si mi ɲaaway, haray ɲaawoore an nden ko nde goonga, ko fii haray wonaa min tun, miɗo wondi e Baabaajo on, ɗun ko on Nuluɗo lan. ");
INSERT INTO fuf_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","No windii ka Sariya mon wonde seeditoore ɗiɗo ko goonga. ");
INSERT INTO fuf_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Min miɗo seeditanaade hoore an, awa kadi Baabaajo, Nuluɗo lan on, no seeditaade fii an.» ");
INSERT INTO fuf_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Onsay ɓen wi'i mo: «Ko honto non ben maa woni?» Iisaa jaabii ɓe, wi'i: «On andaa lan, min woo, Ben an woo. Si hiɗon andunoo lan, harayno hiɗon andi Ben an.» ");
INSERT INTO fuf_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ko ka nder nokkuure ka arkawal sadaka ngal woni ɗon, Iisaa wowli ɗii konguɗi, fewndo ko o jannata ka juulirde mawnde. Laatii hay gooto nangaali mo, ko fii hari saa'i makko on hewtaali taho. ");
INSERT INTO fuf_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Iisaa wi'i ɓe fahin: «Mi yahay, kono on ɗaɓɓitay lan, maayon e nder junuubu. Onon on waawataa hewtoyde ka min mi yahata ton.» ");
INSERT INTO fuf_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Onsay hooreeɓe Yahuudiyankeeɓe ɓen wi'indiri: «E hara o wartoto, ɓay o wi'ii: ‹On waawataa hewtoyde ka mi yahata ton›?» ");
INSERT INTO fuf_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","O wi'i ɓe kadi: «Onon ko on ɓe ley gaa, min ko mo mi ka dow. Ko fii onon, ko on ɓe oo aduna, min non wonaa mo mi oo aduna. ");
INSERT INTO fuf_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ko ɗun waɗi si mi wi'ay on, on maayay e nder junuubi mon. Ko fii, si on gomɗinaali wonde ko min woni Wonɗo on, on maayay e nder junuubu mon.» ");
INSERT INTO fuf_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Onsay ɓen landii mo: «Ko hombo wonu-maa an?» Iisaa kadi jaabii ɓe, wi'i: «Ko ko mi wi'i on kon gila ka fuɗɗoode. ");
INSERT INTO fuf_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","E telen-ma mon, miɗo mari buy ko mi wowla e ko mi ɲaawa. Kono Nuluɗo lan on ko o goonga, awa kadi ko mi naniri mo kon, mi hollay ɗun aduna on.» ");
INSERT INTO fuf_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Laatii ɓe faamaali ko fii Baabaajo on o yewti ɓe. ");
INSERT INTO fuf_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Iisaa wi'i ɓe fahin: «Nde yowuɗon *Ɓii-Aaden on, onsay on anday ko min woni Wonɗo on, awa kadi mi alaa waɗude hay huunde immorde e an min, kono ko wano Baabaajo on jannirimmi non mi woni yewtirde. ");
INSERT INTO fuf_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Nuluɗo lan on no wondi e an, o accitaali lan min tun, ko fii min miɗo waɗude soono woo ko welata mo kon.» ");
INSERT INTO fuf_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ɓay o wowlirii nii, ɗuuɗuɓe gomɗini mo. ");
INSERT INTO fuf_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Onsay Iisaa wi'i Yahuudiyankeeɓe gomɗinɓe mo ɓen: «Si on duumike e wuurirgol kongol an ngol, haray ka haqiiqa, ko on taalibaaɓe an. ");
INSERT INTO fuf_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Onsay on anday goonga on, goonga on watta on rinɗinaaɓe.» ");
INSERT INTO fuf_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Onsay ɓen jaabii mo, ɓe wi'i: «Menen ko men jurriya Ibraahiima, haa hande men wonaali maccuɓe hay gooto. Ko honno non wi'irtaa men wonay rinɗinaaɓe?» ");
INSERT INTO fuf_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Iisaa jaabii, wi'i: «Ka haqiiqa haqiiqa mi andinii on, kala waɗoowo junuubu haray ko o maccuɗo junuubu. ");
INSERT INTO fuf_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Maccuɗo wontataa ɓeynguure jeyɗo ɗun haa poomaa, kono ɓiɗɗo on ko ɗon jeyaa haa poomaa. ");
INSERT INTO fuf_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ko ɗun waɗi si Ɓiɗɗo on non rinɗinii on, haray on wonii rimɓe tigi. ");
INSERT INTO fuf_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Miɗo andi wonde ko on jurriya Ibraahiima, kono hiɗon ɗaɓɓude no wariron mi, ko fii kongol an ngol heɓaali werde e mon. ");
INSERT INTO fuf_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Min non miɗo wowlude ko mi yi'i ka Ben an kon. Kono onon hiɗon waɗude ko nanirɗon baaba mon kon.» ");
INSERT INTO fuf_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Onsay ɓen jaabii mo, ɓe wi'i: «Ko Ibraahiima woni ben amen.» Iisaa kadi wi'i ɓe: «Si tawii ko on iwdi Ibraahiima, haray waɗee kuuɗe Ibraahiima ɗen. ");
INSERT INTO fuf_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Kono jooni onon, hiɗon ɗaɓɓude no wariron mi, min oo neɗɗo wowlanɗo on goonga mo mi naniri Alla, kono Ibraahiima kan waɗaali ko nandi e ɗun. ");
INSERT INTO fuf_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ko kuuɗe baaba mon ɗen wonɗon waɗude!» Ɓen kadi wi'i mo: «Menen hinaa men ɓiɓɓe heɓiraaɓe nii, ko gooto men mari baaba, on-le ko Alla!» ");
INSERT INTO fuf_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Onsay Iisaa wi'i ɓe: «Si tawii ko Alla wonnoo Ben mon, on yiɗayno lan, ko fii ko ka Alla mi iwri, mi ari. Mi aranaa hoore an, kono ko kanko nulimmi. ");
INSERT INTO fuf_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","E ko fii honɗun on alaa faamude ko mi woni on wowlande kon? Ko ɓay on waawataa heɗaade konguɗi an ɗin. ");
INSERT INTO fuf_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ko fii, ko Ibuliisa woni baaba mon, e hin-le hiɗon faalaa waɗude faaleeji baaba mon ɗin. On-le o woniino waroowo gila ka fuɗɗoode, o jaɓaali daraade e goonga, ɓay goonga on alaa e makko. Nde o wowli fenaande nden woo, haray ɗun ko e jikku makko on iwri, ko fii ko o fenoowo, awa kadi ko o baaba penaale. ");
INSERT INTO fuf_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Min non, ɓay miɗo wowlude goonga, on hoolotaako lan. ");
INSERT INTO fuf_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ko hombo e mon waawi hollude wonde mi waɗii junuubu? Si mi wowlii goonga, ko honɗun haɗata hooloɗon mi? ");
INSERT INTO fuf_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ko fii, mo Alla on heɗoto daaluyeeji Alla ɗin. Kono onon, on heɗotaako, ɓay hinaa on ɓe Alla.» ");
INSERT INTO fuf_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Onsay Yahuudiyankeeɓe ɓen jaabii mo, wi'i: «Kere men alaa goonga si men wi'i ko a Samariyankeejo, awa kadi jinna no e maa?» ");
INSERT INTO fuf_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Kono Iisaa jaabii ɓe, wi'i: «Min, jinna alaa e an, kono mi teddinay woni Ben an, kono onon hiɗon hayfinde lan. ");
INSERT INTO fuf_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Min mi alaa ɗaɓɓande hoore an darja. No woodi Wonɗo lan ɗaɓɓande, ɲaawa kadi. ");
INSERT INTO fuf_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ka haqiiqa haqiiqa mi andinii on, mo ɗoftike kongol an ngol, o maayataa few.» ");
INSERT INTO fuf_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Yahuudiyankeeɓe ɓen wi'i mo: «Jooni non men andii jinna no e maa. Ko fii Ibraahiima maayiino, annabaaɓe ɓen kadi wano non, an non hiɗa wi'ude: mo ɗoftike kongol an ngol, o maayataa few. ");
INSERT INTO fuf_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","E hara a ɓuru Ibraahiima baaba amen mawnude? On-le maayii, annabaaɓe ɓen kadi maayii. Ko hombo waɗuɗaa hoore maa?» ");
INSERT INTO fuf_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Iisaa jaabii ɓe kadi, wi'i: «Si mi mawninii hoore an, haray darja an on ko fus. Ko Ben an darjintammi, on mo wi'uɗon ko Alla mon. ");
INSERT INTO fuf_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","E hara-le on andaa mo, min non miɗo andi mo. Si mi wi'iino mi andaa mo, harayno mi wonii fenoowo, mi wa'ii wa mon. Kono-le miɗo andi mo, miɗo ɗoftii kongol makko ngol. ");
INSERT INTO fuf_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ben mon Ibraahiima weltorno yi'ugol ɲalaande arugol an, ɓay o yi'ii nde, o weltii.» ");
INSERT INTO fuf_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Hooreeɓe Yahuudiyankeeɓe ɓen kadi wi'i mo: «Hay a heɓaali duuɓi cappanɗe jowi, a yi'ii Ibraahiima?» ");
INSERT INTO fuf_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Iisaa jaabii ɓe, wi'i: «Ka haqiiqa haqiiqa mi andinii on, ado Ibraahiima woodeede, hari min miɗo woodaa.» ");
INSERT INTO fuf_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ko sabu ɗin konguɗi ɓe hocciri kaaƴe fii fiɗugol mo, kono Iisaa suuɗii, yalti ka juulirde mawnde. ");
INSERT INTO fuf_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","E nder ko Iisaa feƴƴata kon, o yi'i neɗɗo heɓidaaɗo e mbunɗan. ");
INSERT INTO fuf_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Taalibaaɓe makko ɓen landii mo, wi'i: «Karamoko'en, e hara oo e mawɓe mun ɓen, ko hombo e maɓɓe waɗi junuubu haa si o heɓidaa e mbunɗan?» ");
INSERT INTO fuf_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Iisaa jaabii ɓe, wi'i: «Hinaa kanko, hinaa mawɓe makko ɓen waɗi junuubu, kono ko fii no kuuɗe Alla ɗen feeɲira e makko. ");
INSERT INTO fuf_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ko ɲalorma haanuɗen gollirde golle Nuluɗo lan on. Ko fii jemma no ara mo tawata hay gooto waawataa gollude e mun. ");
INSERT INTO fuf_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Fannii miɗo ka aduna, ko min woni Ndaygu aduna on.» ");
INSERT INTO fuf_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ɓay o gaynii wi'ude ɗun, onsay o tutti ka leydi, o waɗiri tuutaaɗe ɗen loopun, o ƴetti kun loopun, o wuji ka gite bunɗo on. ");
INSERT INTO fuf_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","O wi'i mo: «Yahu sulmoyoɗaa ka beelun Siluwaama.» (Siluwaama no firi «nulaaɗo».) O yahi, o sulmoyii ɗon, tawi ko o artata ko o wuntuɗo. ");
INSERT INTO fuf_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Onsay kawtalɓe makko ɓen e woowunooɓe yi'ude himo toroo ɓen nangi e wi'ugol: «E hara hinaa oo jooɗinoo no toroo?» ");
INSERT INTO fuf_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Woɓɓe e maɓɓe wi'i: «Ko kanko.» Ɓeya kadi wi'i: «Wonaa, ɓe nandu tun.» Onsay kanko tigi o wi'i: «Ko min tigi.» ");
INSERT INTO fuf_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ɓe wi'i mo: «Ko honno wuntirɗaa?» ");
INSERT INTO fuf_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","O jaabii ɓe, o wi'i: «Ko goɗɗo no wi'ee Iisaa waɗi loopun, wuji ka gite an, wi'immi: ‹Yahu sulmoyoɗaa Siluwaama.› Min kadi mi yahi, mi sulmoyii. Awa e hino mi wuntii.» ");
INSERT INTO fuf_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ɓe wi'i mo: «Ko honto on neɗɗo woni?» O jaabii ɓe: «Mi andaa.» ");
INSERT INTO fuf_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Onsay ɓe naɓi on wumunooɗo ka *Fariisiyaaɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","(Tawi ko e *ɲalaande fowteteende e mun, ɗun ko asewe, woni ko Iisaa waɗi loope ɗen ka gite makko, o wuntini mo.) ");
INSERT INTO fuf_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ko ɗun waɗi si Fariisiyaaɓe ɓen kadi landii mo, ɓe wi'i ko honno o hettiri gite makko ɗen. O jaabii ɓe: «Ko loope o waɗi ka gite an, mi sulmii tun, mi yi'i!» ");
INSERT INTO fuf_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ko e hoore ɗun Fariisiyaaɓe goo wi'i: «Oo neɗɗo hinaa iwruɗo ka Alla, ko fii o alaa teddinde ɲalaande fowteteende nden.» Tawi woɓɓe no wi'a: «Ko honno neɗɗo waɗoowo junuubu waawirta waɗude sifa ɗii maandeeji hawniiɗi?» Onsay yeddondiral waɗi hakkunde maɓɓe. ");
INSERT INTO fuf_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ɓe wi'i fahin wumunooɗo on: «An ko honɗun wi'uɗaa fii on wuntinɗo ma?» O jaabii: «Ko o annabaajo.» ");
INSERT INTO fuf_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Tawi hooreeɓe Yahuudiyankeeɓe ɓen hoolanooki wonde ko wumunooɗo wunti, ado ɓe noddude mawɓe makko ɓen, ɓe landoo, ");
INSERT INTO fuf_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ɓe wi'a: «Oo mo wi'oton heɓida e mbunɗan, ko ɓiɗɗo mon? Ko honno oo woni yiirude jooni?» ");
INSERT INTO fuf_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Mawɓe makko ɓen jaabii, wi'i: «Menen, meɗen andi oo ko ɓiɗɗo amen, awa kadi o heɓida e mbunɗan. ");
INSERT INTO fuf_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Kono men andaa ko honno o yiiri jooni. Men andaa kadi ko hombo wuntini mo. Landee mo kanko, o heɓii duuɓi fii yewtangol hoore makko.» ");
INSERT INTO fuf_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Tawi ko mawɓe makko ɓen wi'iri ɗun ko fii hari hiɓe huli hooreeɓe Yahuudiyankeeɓe ɓen, ko fii hari ɓen nanondirii wonde mo qirritike Iisaa ko *Almasiihu, ontigi yaltinte ka juulirde. ");
INSERT INTO fuf_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ko ɗun waɗi si mawɓe makko ɓen wi'i: «O heɓii duuɓi, landee mo.» ");
INSERT INTO fuf_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Onsay Fariisiyaaɓe ɓen nodditi fahin on neɗɗo wumunooɗo, ɓe wi'i mo: «Woondirii Alla! Ko fii menen meɗen andi oo neɗɗo ko junuubankeejo.» ");
INSERT INTO fuf_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Kanko kadi o jaabii ɓe, o wi'i: «Si tawii on ko junuubankeejo, min mi andaa. Miɗo andi tun huunde wootere: hari ko mi bunɗo, jooni mi wuntii.» ");
INSERT INTO fuf_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ɓen wi'i mo fahin: «Ko honɗun on waɗan-maa? Ko honno o wuntinir-maa?» ");
INSERT INTO fuf_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Kanko kadi o jaabii ɓe, o wi'i: «Hari mi wowlanii on, kono on heɗaaki. Ko honno faaliraɗon nanirde kadi? E hara onon kadi on faalaa wonude taalibaaɓe makko?» ");
INSERT INTO fuf_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Onsay ɓe yenni mo, ɓe wi'i: «Ko an woni taalibaajo makko on, menen ko men taalibaaɓe Muusaa. ");
INSERT INTO fuf_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ko men andi, Alla yewtiino Muusaa, kono oo ɗoo, men andaa ko mo o honto.» ");
INSERT INTO fuf_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Onsay on neɗɗo jaabii ɓe, wi'i: «E hino ko ŋalɗini kon, ko ko tawi kon o wuntinii lan, e hin-le on andaa ko mo o honto. ");
INSERT INTO fuf_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Kono hiɗen andi Alla jaabinantaa junuubankeejo, kono si goɗɗo ko dewo Alla, o waɗii faale makko on, haray o jaabinanay mo. ");
INSERT INTO fuf_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Awa kadi haa hande en nanaali no wi'ee goɗɗo wuntinii heɓidaaɗo e mbunɗan. ");
INSERT INTO fuf_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Si tawiino oo neɗɗo wonaa mo Alla, o waawataano waɗude hay fus.» ");
INSERT INTO fuf_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Onsay ɓen jaabii mo, wi'i: «An, oo heɓidaaɗo a fow maa e junuubu, ko an jannata men?» Onsay ɓe bugii mo ka yaasi. ");
INSERT INTO fuf_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Iisaa humpitii wonde ɓe ferike on wumunooɗo ka yaasi. Onsay kanko Iisaa o ari, o tawi mo, o wi'i mo: «Hiɗa gomɗini *Ɓii-Aaden on?» ");
INSERT INTO fuf_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","On jaabii mo, wi'i: «Ko hombo woni on, yaa an Koohoojo, fii yo mi gomɗin mo?» ");
INSERT INTO fuf_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Iisaa wi'i mo: «A yi'ii ontigi. Oo wonɗo ma wowlande ko kanko.» ");
INSERT INTO fuf_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Kanko kadi o wi'i: «Koohoojo, mi gomɗinii.» Onsay o sujjani mo. ");
INSERT INTO fuf_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Iisaa wi'i fahin: «Ko fii ɲaawoore addimmi ka aduna ɗoo, fii yo ɓe yi'ataa ɓen yi'u, e yo yi'ooɓe ɓen wumu.» ");
INSERT INTO fuf_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ɓay woɓɓe e Fariisiyaaɓe wondunooɓe e makko ɓen nanii ɗin konguɗi, ɓe wi'i mo: «Kere menen kadi, ko men bumɓe?» ");
INSERT INTO fuf_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Iisaa jaabii ɓe, wi'i: «Si tawno hara ko on bumɓe, on heɓataano junuubi, kono ɓay jooni hiɗon wi'ude hiɗon yi'a, ko non luttidirton e junuubi mon.» ");
INSERT INTO fuf_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","«Ka haqiiqa haqiiqa mi andinii on, on mo ƴawi nokku goo, naati ka kula baali, hara hinaa ka dambugal o rewri, haray on neɗɗo ko ngujjo, jattoowo. ");
INSERT INTO fuf_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Kono on naatirɗo ka dambugal kula, ko on woni ngaynaako baali ɗin. ");
INSERT INTO fuf_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Aynoowo dambugal kula on udditanay mo, baali ɗin nana hawa makko, o noddira baali ɗi o jeyi ɗin inɗe majji, o yaltina ɗi. ");
INSERT INTO fuf_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Nde o yaltini ɗi makko ɗin fow woo, o wontay yeeso majji, ɗi jokka mo, ko fii hiɗi andi hawa makko kan. ");
INSERT INTO fuf_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ɗi jokkataa janano few, kono ɗi dogay mo, ɗi woɗɗitoo, ko fii ɗi andaa hawa jananɓe ɓen.» ");
INSERT INTO fuf_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ɓay Iisaa waɗanii ɓe ngal misal, laatii ɓe faamaali ko o wi'i ɓe. ");
INSERT INTO fuf_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Iisaa wi'i ɓe kadi: «Ka haqiiqa haqiiqa mi andinii on, ko min woni dambugal baali ɗin. ");
INSERT INTO fuf_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Adinooɓe lan arude ɓen fow ko wuyɓe e jattooɓe, kono baali ɗin heɗanooki ɓe. ");
INSERT INTO fuf_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ko min woni dambugal ngal. Mo naatirii lan o dandete, o naatay, o yalta, o heɓa faggorde. ");
INSERT INTO fuf_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ngujjo on kan ko aranta ko fii wujjugol, wara, hayrina. Min non ko mi arani ko fii yo baali ɗin heɓu ngurndan, hara ko ngurndan heewuɗan. ");
INSERT INTO fuf_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","«Ko min woni Ngaynaako Moƴƴo on, ko fii ngaynaako moƴƴo on okkitiray ngurndan mun ɗan fii baali mun ɗin. ");
INSERT INTO fuf_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Kono wonaa faggiroowo fii njoddi on woni ngaynaako on, wonaa on jeyi baali ɗin. No onɗon yi'iri saafaandu no ara, o accay ɗon baali ɗin, o doga, saafaandu ndun ukkoo e majji, saakita ɗi. ");
INSERT INTO fuf_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ko on neɗɗo waɗirta ɗun ko fii ko njoddi wonani mo e ɗen golle, o haajetaake e ɗin baali. ");
INSERT INTO fuf_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","«Ko min woni Ngaynaako Moƴƴo on. Miɗo andi baali an ɗin, awa kadi baali an ɗin no andimmi, ");
INSERT INTO fuf_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","wano Baabaajo on andirimmi non e wano mi andiri Baabaajo on non, awa kadi mi okkitiray ngurndan an ɗan fii baali an ɗin. ");
INSERT INTO fuf_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Miɗo mari baali goo kadi ɗi tawaaka e oo kula ɗoo. Ɗin kadi bee si mi addu ɗi, ɗi nana hawa an kan, ɗi wona wuro wooto, ɗi wona e ngaynaako gooto. ");
INSERT INTO fuf_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Baabaajo on no yiɗi lan, ko fii mi okkitiray ngurndan an ɗan, mi hettitoya ɗan kadi. ");
INSERT INTO fuf_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Hay gooto sortataa ɗan e an, kono ko min tigi okkitirta ɗan. Miɗo mari bawgal okkitirgol ɗan e bawgal hettugol ɗan. Ɗun ko yamiroore nde mi heɓiri Ben an non.» ");
INSERT INTO fuf_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Sabu ɗin konguɗi, yeddondiral waɗi hakkunde Yahuudiyankeeɓe ɓen kadi. ");
INSERT INTO fuf_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Buy e maɓɓe tawi no wi'a: «Jinna no e oo. Oo ko feetuɗo. Ko fii honɗun heɗantoɗon mo?» ");
INSERT INTO fuf_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Tawi ɓeya ɓen kadi no wi'a: «Ɗii konguɗi hinaa ɗi mo jinna. E hara jinnawii no waawi wuntinde bumɓe?» ");
INSERT INTO fuf_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Tawi juldeere fii anditugol laɓɓintineede *juulirde mawnde nden no waɗude Yerusalaam, ɗun hawrondiri ko dabbunde. ");
INSERT INTO fuf_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Tawi Iisaa no jinda ka *Tungarru Sulaymaana, ɗun ko ka juulirde mawnde. ");
INSERT INTO fuf_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Onsay Yahuudiyankeeɓe ɓen hundi mo, ɓe wi'i mo: «Ko haa honde tuma humpintaa men? Si tawii ko an woni *Almasiihu on, laaɓan men!» ");
INSERT INTO fuf_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Iisaa kadi jaabii ɓe, wi'i: «Mi yeetike on, kono on hoolaaki. Kuuɗe ɗe mi woni waɗude ɗen e innde Ben an no seeditii fii an. ");
INSERT INTO fuf_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Kono on hoolotaako, ɓay wonaa on baali an. ");
INSERT INTO fuf_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Kono baali an ɗin kan heɗoto lan, min miɗo andi ɗi, ɗi jokkay lan kadi. ");
INSERT INTO fuf_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Mi yeɗay ɗi *ngurndan poomayankejan ɗan, hara ɗi mulataa han kadi, awa kadi hay gooto ittataa ɗi e juuɗe an. ");
INSERT INTO fuf_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ben an, on Yeɗuɗo lan ɗi, no mawni ɓuri fow, awa hay gooto waawataa ittude ɗi e juuɗe Baabaajo on. ");
INSERT INTO fuf_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Min e Baabaajo on ko men Gooto.» ");
INSERT INTO fuf_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Yahuudiyankeeɓe ɓen hocci kadi kaaƴe fii fiɗugol mo. ");
INSERT INTO fuf_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Iisaa wi'i ɓe kadi: «Mi hollii on kuuɗe moƴƴe buy iwruɗe ka Baabaajo on. E hara ko hongal e ɗen kuuɗe wonɗon mi fiɗirde kaaƴe?» ");
INSERT INTO fuf_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Onsay Yahuudiyankeeɓe ɓen jaabii mo, wi'i: «Men fiɗirtaa ma fii kuugal moƴƴal, kono ko fii ko hoynuɗaa kon, e tawde kadi an, ko a neɗɗo, hiɗa waɗitii Alla.» ");
INSERT INTO fuf_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Iisaa jaabii ɓe kadi, wi'i: «E hara windaaki ka Sariya mon: ‹Allaahu on daali: ko on allaaɓe.›? ");
INSERT INTO fuf_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ɓay non Alla noddirii ɓee ɓe daaluyee makko on tuggaa e mun: ‹allaaɓe›, e hin-le bindi ɗin montotaako, ");
INSERT INTO fuf_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","haray ko honno wi'irton on mo Baabaajo on suɓii, nuli ka aduna no hoynude, fii tun mi wi'ii ko mi *Ɓiɗɗo Alla? ");
INSERT INTO fuf_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Si mi waɗaali kuuɗe Ben an ɗen, haray wota on hoolo lan. ");
INSERT INTO fuf_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Kono si mi waɗii ɗe, hay si on hoolotaako lan, hoolee ɗe kanje kuuɗe ɗen, fii no andiron faamon wonde Baabaajo on no e an, min kadi miɗo e makko.» ");
INSERT INTO fuf_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ɓe ɗaɓɓi kadi no ɓe nangira mo, kono o laawii ɓe. ");
INSERT INTO fuf_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ɓay Iisaa iwii ɗon, o yiltitii gaɗa Yurdayniwol ka Yaayaa *lootaynoo maande tuubuubuyee ɗon aranun, o daakii ɗon. ");
INSERT INTO fuf_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Yimɓe buy ari e makko, tawi hiɓe wi'a: «Yaayaa kaɲun waɗaali maande hawniinde woo, kono ko Yaayaa wi'i e hoore oo neɗɗo kon fow ko goonga.» ");
INSERT INTO fuf_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Buy gomɗini mo ɗon. ");
INSERT INTO fuf_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Gorko wi'eteeɗo Laazaru nawnuno ka saare *Betanii, ka Mariyatu e miɲan mun Mariyama hoɗunoo ɗon. ");
INSERT INTO fuf_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ko Mariyama on juurunoo angiri ka koyɗe Koohoojo on, o fittiri ɗe sukundu makko ndun. Tawi ko Laazaru oo nawnunooɗo woni bandiraawo makko on. ");
INSERT INTO fuf_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Onsay ɓen bandiraaɓe Laazaru ɗiɗo immini goɗɗo haa e Iisaa ko andinoya mo, wi'a: «Koohoojo, giɗo maa on no nawni.» ");
INSERT INTO fuf_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ɓay Iisaa humpitike ɗun, o wi'i: «Wonaa ndee nawnaare ɗoo warata mo, kono nde hollay mangural Alla ngal, fii no *Ɓiɗɗo Alla on mawniniree sabu mayre.» ");
INSERT INTO fuf_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ko fii hari Iisaa no yiɗi Mariyatu e Mariyama miɲɲiraawo mun on, kaɲun e Laazaru bandiraawo maɓɓe on. ");
INSERT INTO fuf_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ɓay wonii o andii on no nawni, o wonti e nden nokkuure ka o wonnoo ɗon balɗe ɗiɗi. ");
INSERT INTO fuf_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Onsay o wi'i taalibaaɓe ɓen: «Yiltitoɗen ka diiwal Yahuuda.» ");
INSERT INTO fuf_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Taalibaaɓe ɓen wi'i mo: «Karamoko'en, ko neeɓaali koo, Yahuudiyankeeɓe ɓen no etaade no fiɗira on kaaƴe. E on yiltitoto ɗon?» ");
INSERT INTO fuf_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Iisaa kadi jaabii ɓe, wi'i: «E nder ɲallal ngal hinaa saa'iiji sappoo e ɗiɗi? Awa si goɗɗo yaarii ɲalorma, o feggotaako, ɓay haray himo yi'irde ndaygu oo aduna. ");
INSERT INTO fuf_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Kono si goɗɗo yaarii jemma, o feggoto, ko fii haray ndayganaa mo.» ");
INSERT INTO fuf_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ɓawto ɗin konguɗi o wi'i ɓe: «Laazaru, giɗo men on, ɗaanike, kono miɗo yahude fii findingol mo.» ");
INSERT INTO fuf_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Taalibaaɓe ɓen wi'i mo: «Koohoojo, si tawii o ɗaani, o ndikkay.» ");
INSERT INTO fuf_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Tawi Iisaa ko yewti ko fii mayde Laazaru nden, kono kamɓe ɓe sikki ko fii ɗoyngol tun o wowli. ");
INSERT INTO fuf_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Onsay Iisaa laaɓani ɓe, o wi'i ɓe: «Laazaru maayii. ");
INSERT INTO fuf_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Kono miɗo weltii fii mon tawde hari mi alaa ton fii no gomɗiniron. Jooni yahen ka o woni ton.» ");
INSERT INTO fuf_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Onsay Tooma, jammaaɗo Siwtaaɗo on, wi'i taalibaaɓe heddiiɓe ɓen: «Mahen enen kadi, maayiden e makko!» ");
INSERT INTO fuf_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ɓay wonii Iisaa hewtii, o tawi Laazaru heɓii balɗe nay ka yenaande. ");
INSERT INTO fuf_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Tawi hakkunde Betanii ɗon e Yerusalaam yonaa kilomeeterji tati leydi. ");
INSERT INTO fuf_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Tawi Yahuudiyankeeɓe buy no ari ka Mariyatu e Mariyama fii yarlingol ɓe mayde bandiraawo maɓɓe on. ");
INSERT INTO fuf_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ɓay wonii Mariyatu humpitike wonde Iisaa no arude, o yahi fottugol e makko, Mariyama kaɲun lutti jooɗaade ka suudu. ");
INSERT INTO fuf_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mariyatu wi'i Iisaa: «Koohoojo, si tawno hiɗon ɗoo, bandiraawo an on maayataano. ");
INSERT INTO fuf_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Kono haa jooni miɗo andi kala ko toriɗon Alla, Alla waɗanay on.» ");
INSERT INTO fuf_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Onsay Iisaa wi'i mo: «Bandiraawo maa on immitoto.» ");
INSERT INTO fuf_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Mariyatu jaabii mo, wi'i: «Miɗo andi o immitoyto ka ummutal, ɗun ko ka ɲalaande sakkitorde.» ");
INSERT INTO fuf_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Iisaa kadi wi'i mo: «Ko min woni Ummutal ngal e Ngurndan ɗan. Kala gomɗinɗo lan wuuray, hay si o maayii non. ");
INSERT INTO fuf_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Kala wurɗo gomɗinɗo lan maayataa han kadi. Hiɗa hoolii ɗun?» ");
INSERT INTO fuf_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Mariyatu wi'i mo: «Eyyo, yaa an Koohoojo, miɗo gomɗini ko an woni Almasiihu on, Ɓiɗɗo Alla, haanuɗo arude ka aduna on.» ");
INSERT INTO fuf_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ɓay kanko Mariyatu o wi'ii ɗun, o yiltitii, o noddoyi Mariyama miɲɲiraawo makko on, o wi'i mo e gundoo: «Karamoko'en no ɗoo, hiɓe noddude ma.» ");
INSERT INTO fuf_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Nde Mariyama nanirnoo ɗun, o hawtii nde wootere, o yahi e makko. ");
INSERT INTO fuf_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Tawi hari Iisaa naataali taho ka nder hoɗo, himo e nden nokkuure ka Mariyatu fottunoo e makko ɗon. ");
INSERT INTO fuf_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Yahuudiyankeeɓe wondunooɓe e Mariyama ka suudu ɓen fii yarlingol mo yi'i himo hawtoo tun yalta, ɓen kadi jokki mo, ko fii hari hiɓe sikka himo yahude wulloygol ka yenaande. ");
INSERT INTO fuf_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ɓay wonii Mariyama hewtii ka Iisaa woni ɗon, o yi'ii mo, o yani e ley koyɗe makko, o wi'i: «Koohoojo, si tawno hiɗon ɗoo, bandiraawo an on maayataano!» ");
INSERT INTO fuf_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ɓay Iisaa yi'ii himo wulla, awa kadi Yahuudiyankeeɓe ɓe o ardi ɓen kaɲun kadi no wullude, ɗun yurmi mo ka wonkii haa ɓernde makko jiɓii. ");
INSERT INTO fuf_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Onsay kanko Iisaa o wi'i: «Ko honto surruɗon mo?» Ɓe jaabii mo: «Koohoojo, seenee tinon!» ");
INSERT INTO fuf_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Iisaa mbojji. ");
INSERT INTO fuf_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Onsay Yahuudiyankeeɓe ɓen wi'i: «Ndaaree no ɓe yiɗirnoo mo!» ");
INSERT INTO fuf_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Woɓɓe e hakkunde maɓɓe wi'i: «Kanko, oo wuntinnooɗo bumɓe, e hara o waawataano waɗude kadi hara oo neɗɗo maayaali?» ");
INSERT INTO fuf_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ɗun yurmi Iisaa kadi, o ari ka yenaande, tawi ko fammeere ombiraande hayre. ");
INSERT INTO fuf_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Iisaa wi'i: «Pottinee hayre nden.» Mariyatu bandiraawo mayɗo on wi'i mo: «Koohoojo, o luuɓii jooni, ko fii ko balɗe nay on nii.» ");
INSERT INTO fuf_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Kono Iisaa wi'i mo: «E hinaa mi wi'iino ma, si tawii hiɗa gomɗini, a yi'ay mangural Alla ngal?» ");
INSERT INTO fuf_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Onsay ɓe pottini hayre nden. Iisaa ɓanti gite mun ɗen, fewtini dow, wi'i: «Baaba, mi weltanike ma fii ko jaabinanɗaa mi kon. ");
INSERT INTO fuf_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Min miɗo andi hiɗa jaabinande lan saa'i kala, kono ko sabu ɓee yimɓe dariiɓe ɗoo mi wowliri, fii yo ɓe gomɗin wonde ko an nulimmi.» ");
INSERT INTO fuf_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ɓay wonii o wi'ii ɗun, o ewnii ko tiiɗi, o wi'i: «Laazaru, yaltu!» ");
INSERT INTO fuf_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Onsay mayɗo on yalti, tawi koyɗe ɗen e juuɗe ɗen no haɓɓiraa lincoy, himo buumiraa kasannge on. Onsay Iisaa wi'i ɓe: «Firtee mo, accon o yaha.» ");
INSERT INTO fuf_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Onsay ɓay buy e Yahuudiyankeeɓe arnooɓe ka Mariyama ɓen yi'ii ko Iisaa waɗi kon, ɓe gomɗini mo. ");
INSERT INTO fuf_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Kono woɓɓe e maɓɓe yahi tawoyi *Fariisiyaaɓe ɓen, andini ɓen ko Iisaa waɗi kon. ");
INSERT INTO fuf_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Onsay hooreeɓe *yottinooɓe sadaka ɓen e Fariisiyaaɓe ɓen mottindiri dental fewjooɓe ɓen, ɓe wi'i: «Ko honɗun waɗeten? Ko fii oo neɗɗo no waɗude maandeeji hawniiɗi buy. ");
INSERT INTO fuf_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Si en accii o jokkirii nii, fow gomɗinay mo, awa kadi Roomiyankooɓe ɓen aroyay jatta nokkuure men hormorde nden e jamaa men on.» ");
INSERT INTO fuf_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Onsay goɗɗo e maɓɓe no wi'ee Qayaafa, tawi ko on wonnoo yottinoowo mawɗo sadaka e nden hitaande ɗon, o wi'i ɓe: «Onon on faamaali huunde. ");
INSERT INTO fuf_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Onon on andaa wonde no moƴƴani yimɓe ɓen ka aaden gooto maaya fii jamaa on, hara jamaa on fow mulaali.» ");
INSERT INTO fuf_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Tawi ngol kongol hinaa e makko kanko tigi iwri, kono ko ɓay ko kanko wonnoo yottinoowo mawɗo sadaka e nder nden hitaande ɗon, o hiitii* wonde Iisaa no haani maayude fii jamaa *Isra'iila on. ");
INSERT INTO fuf_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ɗun non hinaa fii oo jamaa tun, kono ko fii no fayɓe Alla saakitiiɓe ɓen mottindiriree, wona *moftal gootal. ");
INSERT INTO fuf_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Gila nden ɲande ɓe fottani fii warugol mo. ");
INSERT INTO fuf_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Laatii tawi Iisaa jindataa han kadi e kene hakkunde Yahuudiyankeeɓe ɓen. O iwi ɗon, o yahi e leydi kawtirndi e ɗon ndin ka wulaa e saare no wi'ee Efrayiima, o wondi ɗon e taalibaaɓe makko ɓen. ");
INSERT INTO fuf_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Tawi juldeere Yahuudiyankeeɓe, ɗun ko *Juldeere Yawtaneede nden, ɓadike. Buy e yimɓe leydi ndin yahi Yerusalaam fii yo ɓe laɓɓino ado Juldeere Yawtaneede nden hewtude. ");
INSERT INTO fuf_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Tawi mo bee e maɓɓe no ɗaɓɓa Iisaa ka *juulirde mawnde, wi'a: «Ko sikkuɗon? E hara o arataa ka juldeere few?» ");
INSERT INTO fuf_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Tawi non hooreeɓe yottinooɓe sadaka ɓen e Fariisiyaaɓe ɓen yamiriino wonde, si tawii goɗɗo no andi ka o woni, yo o wowlu fii no ɓe nangira mo. ");
INSERT INTO fuf_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Balɗe jeegoo ado *Juldeere Yawtaneede nden, Iisaa ari ka wi'etee ɗon *Betanii ka Laazaru, oo mo o immintinnoo e hakkunde mayɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ɓe moƴƴinani mo ɗon nafakka. Tawi ko Mariyatu wonnoo ɓannude, awa kadi Laazaru ko goɗɗo e wonnooɓe ɲaamidude e makko ɓen. ");
INSERT INTO fuf_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mariyama kadi ƴetti wa feccere liitir angiri laaɓundi, satta-cogguuri, no wi'ee ‹naar›, o juuri ka koyɗe Iisaa, o fittiri koyɗe on ɗen sukundu makko ndun, suudu ndun heewi urngol angiri ndin. ");
INSERT INTO fuf_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Onsay goɗɗo e taalibaaɓe makko ɓen, ɗun ko Yudaasi Iskariiyu, ɗun ko oo janfoytooɗo mo, wi'i: ");
INSERT INTO fuf_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«Ko fii honɗun en yeeyaali ndii angiri yeru *dinaruuji teemeɗɗe tati, okken miskinɓe ɓen?» ");
INSERT INTO fuf_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Tawi o wiiraali ɗun wa si tawii himo aanannoo miskinɓe ɓen, kono ko ɓay hari ko o ngujjo, awa kadi ko kanko joginoo bonfo on, o ƴettayno ko waɗaa ton woo. ");
INSERT INTO fuf_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Kono Iisaa wi'i: «Terto mo, ko fii ɲande mi surrete o marirnoo ndii angiri. ");
INSERT INTO fuf_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Miskinɓe ɓen kan, hiɗon wondi e maɓɓe soono woo, kono min, on wondataa e an soono woo. ");
INSERT INTO fuf_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Tawi jamaa Yahuudiyankeeɓe ɗuuɗuɗo humpitike wonde himo ɗoo. Ɓe ari, tawi hinaa sabu Iisaa tun, kono ko fii yi'ugol Laazaru kadi, on mo o immintini e hakkunde mayɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Hooreeɓe *yottinooɓe sadaka ɓen aadii warugol Laazaru kadi, ");
INSERT INTO fuf_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ɓay hari ko sabu makko waɗi si Yahuudiyankeeɓe buy no sortaade e hakkunde maɓɓe, gomɗina Iisaa. ");
INSERT INTO fuf_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Bimbi nden ɲande jamaa ɗuuɗuɗo ari fii juldeere nden, ɓe humpitii kadi wonde Iisaa aray Yerusalaam. ");
INSERT INTO fuf_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Onsay ɓe ƴetti baape tugi, ɓe yalti fii jaɓɓagol mo, ɓe woni e ewnagol, wi'a: «*Hosannaa! Yo barki wonan oo wonɗo arude e innde Joomiraaɗo on, ɗun ko oo lanɗo *Isra'iilayanke'en!» ");
INSERT INTO fuf_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Iisaa kadi tawi mbabun, o ƴawi e hoore makkun, o jooɗii wano windori non: ");
INSERT INTO fuf_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","«Wota a hulu, yo jamaa *Siyuuna! E hino lanɗo maa on ka arata, himo jooɗii e hoore ɓikkun mbabba!» ");
INSERT INTO fuf_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Tawi taalibaaɓe makko ɓen faamaali fii ɗun fow taho, kono ɓay wonii Iisaa ƴentinaama ka mangural, onsay ɓe anditi wonde ɗii piiji no windinoo fii makko, awa ko ɗun tigi laatinanaa mo. ");
INSERT INTO fuf_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Tawi yimɓe wondunooɓe e Iisaa ɓen fewndo ko o noddata Laazaru ka qaburu, o immintina mo e hakkunde mayɓe ɓen, no seeditaade fii ko ɓe yi'i kon. ");
INSERT INTO fuf_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ko sabu ɗun waɗi si jamaa on ari, jaɓɓii mo, ko fii hari ɓe nanii wonde o waɗii nden maande hawniinde. ");
INSERT INTO fuf_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Tawi *Fariisiyaaɓe ɓen no wi'indirde: «On yi'ii en alaa waawude hay huunde, ɓay fow jokkii mo!» ");
INSERT INTO fuf_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Tawi *Gereekiyankeeɓe goo no e hakkunde yimɓe yahunooɓe rewugol Alla ɓen ɲande juldeere nden. ");
INSERT INTO fuf_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ɓe ɓadii oo wi'eteeɗo Filiipu mo Bayti-Sa'iida, ɗun ko e nder Jaliilu, ɓe landii mo, ɓe wi'i: «Moodibbo, meɗen faalaa yiidude e Iisaa!» ");
INSERT INTO fuf_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filiipu kadi yahi, wowlani Andaraawu, onsay Andaraawu e Filiipu yahi, wowlani Iisaa. ");
INSERT INTO fuf_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Onsay Iisaa jaabii ɓe, wi'i: «Saa'i mo *Ɓii-Aaden on mawnintee e mun on hewtii. ");
INSERT INTO fuf_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ka haqiiqa haqiiqa mi andinii on, si abbere yanii e leydi, nde maayaali, nde wonay kayre tun, kono si nde maayii, nde rimay ɓiɓɓe buy. ");
INSERT INTO fuf_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Kala yiɗuɗo ngurndan mun ɗan, ɗan hayriray mo, kono kala non aɲuɗo ngurndan mun ɗan ka aduna ɗoo, haray ko fii *ngurndan poomayankejan o marani ɗan. ");
INSERT INTO fuf_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Awa kala on kurkantooɗo lan yo jokkan, ko fii ko ka mi woni ɗon, ko ɗon kurkaadu an ndun wonata. Kala non on kurkaniiɗo lan, Baabaajo on teddinay mo. ");
INSERT INTO fuf_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","«Jooni ɓernde an nden jiɓike. E ko honɗun mi wi'ata? Hara mi wi'ay: Baaba an, dandan oo saa'i? Oo'o, ɓay ko fii ɗun mi arani haa e oo saa'i. ");
INSERT INTO fuf_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Baaba an, mawnin innde maa nden!» Onsay hawa iwri ka kammu no wi'a: «Mi mawninii nde, mi mawninay nde kadi!» ");
INSERT INTO fuf_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Jamaa wonnooɗo ɗon nani ɗun on wi'i ko riggannde, woɓɓe wi'i ko malaa'ikaajo wowlani mo. ");
INSERT INTO fuf_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Iisaa wi'i kadi: «Hinaa fii an kaa hawa nanori, kono ko fii mon. ");
INSERT INTO fuf_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ko jooni non aduna on ɲaawetee, ɓay ko jooni non lanɗo aduna on bugetee ka yaasi. ");
INSERT INTO fuf_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Min non tuma mi townaa ka hoore leydi, mi pooɗitay yimɓe ɓen fow e an.» ");
INSERT INTO fuf_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Tawi ko o wowliri ɗun, ko fii hollugol ko honno o maayirta. ");
INSERT INTO fuf_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Onsay jamaa on jaabii mo, wi'i: «Sariya on no wi'i men wonde *Almasiihu on woodete haa poomaa. Haray ko honno non wi'irɗaa bee Ɓii-Aaden on townee? Ko hombo non woni on Ɓii-Aaden?» ");
INSERT INTO fuf_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Iisaa jaabii ɓe kadi, wi'i: «Ndaygu no e hakkunde mon taho seeɗa. Yahee fewndo ka marɗon ndaygu ɗon, fii wota niwre nden juhu on. Ko fii on yahoowo e niwre andaa ka yahata. ");
INSERT INTO fuf_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Awa fewndo ka marɗon ndaygu ɗon, hoolee ngu, fii no woniron fayɓe ndaygu ngun.» Ɓay Iisaa wi'ii ɗun, onsay o yahi, o suuɗii ɓe. ");
INSERT INTO fuf_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Fii kala o waɗii wa ɗii maandeeji hawniiɗi yeeso maɓɓe, kono ɓe gomɗinaano mo. ");
INSERT INTO fuf_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ko nii kongol ngol annabi Isaaya wowlunoo ngol laatori, ɗun ko ka o wi'unoo ɗon: «Joomiraaɗo, ko hombo gomɗini waaju amen ngun? E ko hombo sookewo Joomiraaɗo on feɲɲinanaa?» ");
INSERT INTO fuf_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ɓe waawataano hoolaade, ɓay wano Isaaya wi'irnoo non kaɗi: ");
INSERT INTO fuf_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","«Allaahu on wuminii ɓe, o uddii ɓerɗe maɓɓe ɗen, fii wota ɓe yiiru gite maɓɓe ɗen, e hita ɓe faamir ɓerɗe maɓɓe ɗen, haa ɓe tuuba, o sellina ɓe.» ");
INSERT INTO fuf_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ko ɗun woni ko *Isaaya yewti, ɓay wonii o yi'ii darja Iisaa Almasiihu on, o yewti fii makko. ");
INSERT INTO fuf_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Kono e nder ɗun, hay e hakkunde yeesooɓe ɓen, buy e maɓɓe gomɗini mo, kono sabu Fariisiyaaɓe ɓen ɓe suusaali qirritaade, fii wota ɓe pottine ka juulirde, ");
INSERT INTO fuf_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","ko fii hari hiɓe yiɗi weltingol yimɓe ɓen ɓuri weltingol Alla. ");
INSERT INTO fuf_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Onsay Iisaa ewnii, wi'i: «Kala on gomɗinɗo lan, haray wonaa min o gomɗini, kono ko Nuluɗo lan on! ");
INSERT INTO fuf_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","E kala yi'uɗo lan, haray o yi'ii Nuluɗo lan on. ");
INSERT INTO fuf_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ko fii wonugol Ndaygu addimmi e oo aduna, hara kala gomɗinɗo lan wonaali e nder niwre nden. ");
INSERT INTO fuf_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Kala nanuɗo konguɗi an ɗin kadi, ronki ɗi huutorde, hinaa min ɲaawoyta mo. Ko fii mi ariraali fii ɲaawugol aduna on, kono ko fii dandugol aduna on. ");
INSERT INTO fuf_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Kala non bugitiiɗo lan, salii jaɓude konguɗi an ɗin, no mari ɲaawoowo. Ko fii ko konguɗi ɗi mi yewti ɗin ɲaawoyta mo ka ɲalaande sakkitorde. ");
INSERT INTO fuf_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ɓay konguɗi an ɗin wonaa e an iwri, kono ko Baabaajo imminɗo lan on tigi yamirimmi ko mi haala e ko mi wi'a. ");
INSERT INTO fuf_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Awa-le miɗo andi yamiroore makko nden ko nde ngurndan poomayankejan. E hin-le, ko mi wi'i kon, ko no Baabaajo on wi'irimmi non mi wowliri.» ");
INSERT INTO fuf_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ɓay *Juldeere Yawtaneede nden ɓadike, tawi kanko Iisaa o andii saa'i makko iwugol e oo aduna, yaha ka Baabaajo on, hewtii. Kanko Iisaa himo yiɗunoo ɓe makko ɓen e oo aduna ɗoo haa ka rawnoode. ");
INSERT INTO fuf_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","E nder ko ɓe nafotoo kon, tawi Ibuliisa waɗii e ɓernde Yudaasi mo Sim'uunu Iskariiyu janfagol mo. ");
INSERT INTO fuf_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Nde tawnoo Iisaa no andi wonde Baabaajo on wattii fow e juuɗe makko, awa kadi ko ka Alla o iwi, ko ka Alla kadi o ruttotoo, ");
INSERT INTO fuf_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","o immii ka ɓe ɲaamaynoo ɗon, o ɓortii burmusu makko on, o ƴetti lefol bagi, o daditii. ");
INSERT INTO fuf_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Onsay o wancini ndiyan e miran, o woni e sembugol taalibaaɓe ɓen, o fittira koyɗe maɓɓe ɗen bagi mo o daditinoo on. ");
INSERT INTO fuf_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ɓay wonii o hewtii Sim'uunu Petruusu, on wi'i mo: «Koohoojo, ko an sembatammi?» ");
INSERT INTO fuf_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Iisaa jaabii mo, wi'i: «Ko mi woni waɗude kon a faamataa ɗun fewndo ɗoo, kono a faamoyay ɗun onsay.» ");
INSERT INTO fuf_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Kanko Petruusu o wi'i mo: «Oo'o, a sembataa lan few!» Iisaa kadi jaabii mo, wi'i: «Si mi sembaali ma, haray a alaa geɓal e an few.» ");
INSERT INTO fuf_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Onsay kanko Sim'uunu Petruusu o wi'i: «Koohoojo, awa hinaa koyɗe an ɗen tun, kono hay juuɗe ɗen e hoore nden!» ");
INSERT INTO fuf_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Iisaa wi'i mo kadi: «Lootiiɗo hatonjinaa e lootagol si wonaa sembagol, ko fii o fow ko o laaɓuɗo. E hin-le ko on laaɓuɓe, kono non hinaa on fow.» ");
INSERT INTO fuf_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ko fii hari himo andi janfotooɗo mo on. Ko ɗun waɗi si o wi'i: ‹Hinaa on fow woni laaɓuɓe.› ");
INSERT INTO fuf_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ɓay wonii o gaynii ɓe sembude, o ɓornii burmusu makko on, o jottii, o wi'i ɓe: «On faamii fii koo ko mi waɗani on? ");
INSERT INTO fuf_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Hiɗon noddirammi Karamoko e Koohoojo. On wowlii goonga, ko fii ko mi ɗun. ");
INSERT INTO fuf_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Si tawii non min Koohoojo on, min Karamoko mon, mi sembii on, haray onon kadi hiɗon haani sembindirde. ");
INSERT INTO fuf_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ko fii, mi waɗanii on misal, fii no onon kadi waɗiron wano mi waɗirani on non. ");
INSERT INTO fuf_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ka haqiiqa haqiiqa mi andinii on, kurkaadu ɓuraa jom mun teddude, nulaaɗo kadi ɓuraa nuluɗo ɗun on teddude. ");
INSERT INTO fuf_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Jooni non, ɓay on andii ɗun, si on huutorii, haray on malii. ");
INSERT INTO fuf_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","«Hinaa non fii mon on fow mi wi'i ɗun, miɗo andi ɓe mi suɓii ɓen. Kono bee ko windii kon laatoo: ‹On mo mi hawtidi bireedi dartike lan.› ");
INSERT INTO fuf_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","«Ko ɗun waɗi, gila jooni mi yeetoto on ado nden huunde hewtude, fii tuma nde hewtoyi yo on hooloyo ko min woni Wonɗo on. ");
INSERT INTO fuf_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ka haqiiqa haqiiqa mi andinii on, kala jaɓuɗo mo mi nuloyta on, haray jaɓii lan, awa kadi kala jaɓuɗo lan, haray jaɓii Nuluɗo lan on.» ");
INSERT INTO fuf_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ɓay wonii kanko Iisaa o yewtii ɗun, ɓernde makko nden aani, o holli ɗunɗoo, o wi'i: «Ka haqiiqa haqiiqa mi andinii on, goɗɗo e mon janfoto lan.» ");
INSERT INTO fuf_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Onsay taalibaaɓe ɓen ndaarindiri, ɓe jiɓii ko hombo o wi'i. ");
INSERT INTO fuf_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Tawi goɗɗo e taalibaaɓe ɓen, mo Iisaa yiɗunoo, no jooɗii ka sera taabal takko Iisaa. ");
INSERT INTO fuf_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Onsay Sim'uunu Petruusu sowndii on, wi'i: «Lando ko hombo o woni wowlude fii mun.» ");
INSERT INTO fuf_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","On taalibaajo kadi ugginii ka fewndo ɓernde Iisaa, o wi'i: «Koohoojo, ko hombo woni on?» ");
INSERT INTO fuf_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Onsay Iisaa jaabii mo, wi'i: «Ko mo mi jullani kuntun bireedi ka mi ɲaamata ɗon, mi jonni woo.» Onsay o julli bireedi on, o jonni Yudaasi mo Sim'uunu Iskariiyu. ");
INSERT INTO fuf_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","No Yudaasi hendornoo kun kuntun bireedi, Ibuliisa naati e ɓernde makko. Iisaa wi'i mo: «Waɗu ko waɗataa kon heɲa.» ");
INSERT INTO fuf_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Kono hay gooto e ɓe o ɲaamidaynoo ɓen faamaali ko fii honɗun o wi'irani mo ɗun. ");
INSERT INTO fuf_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Nde tawnoo ko Yudaasi jogii bonfo on, woɓɓe ɓen sikki ko Iisaa wi'i mo wonde ko yo o soodu ko ɓe handi e mun fii juldeere nden, maa okkorgol miskinɓe ɓen goɗɗun. ");
INSERT INTO fuf_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Onsay Yudaasi ƴetti kuntun bireedi kun, yalti heɲa, hari niɓɓii. ");
INSERT INTO fuf_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Ɓay wonii Yudaasi yaltii, Iisaa wi'i: «Jooni non *Ɓii-Aaden on mawninaama, awa kadi Alla mawniniraama mo. ");
INSERT INTO fuf_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Si tawii non Alla mawniniraama mo, Alla kadi mawninay mo immorde e mun, o mawnina mo kisan.» ");
INSERT INTO fuf_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","O wi'i kadi: «Ko onon yo fayɓe an, miɗo wondi e mon kadi seeɗa. On ɗaɓɓoyay lan, kono jooni miɗo yeetaade on onon kadi wano mi wiirunoo non hooreeɓe Yahuudiyankeeɓe ɓen: ‹Ka mi yahata ton on waawataa hewtude.› ");
INSERT INTO fuf_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","«Miɗo yamirde on yamiroore heyre: Yiɗindiree. Wano mi yiɗiri on non, onon kadi yiɗindiree. ");
INSERT INTO fuf_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Si on yiɗindirii, fow anday ko on taalibaaɓe an.» ");
INSERT INTO fuf_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Onsay Sim'uunu Petruusu wi'i mo: «Koohoojo, ko honto yahataa?» Iisaa jaabii, wi'i: «Ka mi woni yahude ton a waawataa lan jokkude fewndo ɗoo, kono a jokkitoyay lan si neeɓii.» ");
INSERT INTO fuf_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Petruusu wi'i mo fahin: «Koohoojo, ko honɗun haɗata mi waawe jokkude fewndo ɗoo? Mi okkitiray ngurndan an ɗan fii maa!» ");
INSERT INTO fuf_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Onsay Iisaa jaabii mo, wi'i: «A okkitiray ngurndan maa ɗan fii an? Ka haqiiqa haqiiqa mi andinii ma, ndonto ƴoggataa few hara a yeddaali fii an haa timma laabi tati.» ");
INSERT INTO fuf_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","«Wota ɓerɗe mon ɗen aanu. Gomɗinee Alla, gomɗinon lan, min kadi. ");
INSERT INTO fuf_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Wonundeeji buy no woodi ka galle Ben an. Si hinaano ɗun, harayno mi yeetike on, ko fii miɗo yahude parangol on wonunde. ");
INSERT INTO fuf_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Jooni si mi yahii, mi paranoyii on wonunde nden, mi aranoyay on, fii yo on wonoy onon kadi ka mi woni ton. ");
INSERT INTO fuf_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ka mi woni yahude ɗon, hiɗon andi ngol laawol.» ");
INSERT INTO fuf_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Kono Tooma wi'i mo: «Koohoojo, men andaa ka seenotoɗon ton. Ko honno non men andirta laawol ngol?» ");
INSERT INTO fuf_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Iisaa jaabii mo, wi'i: «Ko min woni Laawol ngol e Goonga on e Ngurndan ɗan. Hay gooto waawataa yahude ka Baabaajo on si wonaa e an o rewri. ");
INSERT INTO fuf_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Si hiɗon andi lan, on andoyay kadi Ben an. Kono gila jooni hiɗon andi mo, awa kadi on yi'ii mo.» ");
INSERT INTO fuf_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Onsay Filiipu wi'i mo: «Koohoojo, hollu men Baabaajo on, ɗun haray yonii men.» ");
INSERT INTO fuf_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Iisaa wi'i mo: «Filiipu, koo ko mi neeɓi wondude e mon fow, e a andaali lan? Kala yi'uɗo lan, haray yi'ii Baabaajo on. An non, ko honno wi'irtaa: ‹Hollu men Baabaajo on›? ");
INSERT INTO fuf_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","A hoolaaki wonde miɗo humondiri e Baabaajo on, kanko Baabaajo on kadi himo humondiri e an? Ɗii konguɗi ɗi mi woni on wowlande, wonaa e an ɗi iwri. Ko Baabaajo Wonɗo e an on woni waɗude kuuɗe mun ɗen. ");
INSERT INTO fuf_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Gomɗinee lan wonde miɗo humondiri e Baabaajo on, kanko Baabaajo on kadi himo humondiri e an. Si hinaa ɗun, gomɗiniron bete sabu ɗee kuuɗe ɗe mi woni waɗude. ");
INSERT INTO fuf_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ka haqiiqa haqiiqa mi andinii on, kala on gomɗinɗo lan, kaɲun kadi waɗay kuuɗe ɗe mi waɗata ɗen, o waɗa ko ɓuri mawnude, ko fii miɗo yaarude ka Baabaajo on. ");
INSERT INTO fuf_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Awa kala ko toriɗon e innde an, mi waɗay, fii no Baabaajo on mawniniree immorde e Ɓiɗɗo on. ");
INSERT INTO fuf_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Si on torike goɗɗun e innde an, mi waɗay ɗun.» ");
INSERT INTO fuf_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","«Si hiɗon yiɗi lan, on ɗoftoto yamirooje an ɗen. ");
INSERT INTO fuf_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Min kadi mi toroto Baabaajo on, o yeɗa on Ballo goo, hara ko Wondoowo e mon haa poomaa: ");
INSERT INTO fuf_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","on non ko Ruuhu Wonduɗo e Goonga mo aduna on waawataa jaɓude, ɓay ɓe yi'ataa mo, ɓe andataa mo. Kono onon hiɗon andi mo, ɓay himo humondiri e mon, awa kadi o hoɗay e mon. ");
INSERT INTO fuf_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Mi accataa wonon aliyatiimaaɓe, mi aray e mon. ");
INSERT INTO fuf_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","E nder seeɗa nii aduna on yiitataa lan han kadi, kono onon on yi'ay lan. Ɓay miɗo wuuri, awa onon kadi on wuuray. ");
INSERT INTO fuf_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Nden ɲande on andoyay wonde miɗo humondiri e Baaba an, onon kadi hiɗon humondiri e an, min kadi miɗo humondiri e mon. ");
INSERT INTO fuf_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Yiɗuɗo lan on ko jaɓuɗo yamirooje an ɗen, ɗoftii. Kala yiɗuɗo lan, Ben an yiɗay mo, min kadi mi yiɗay mo, mi hollitoo mo.» ");
INSERT INTO fuf_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Onsay oo wi'eteeɗo Yahuuda, (hara hinaa Yudaasi Iskariiyu), wi'i mo: «Koohoojo, ko honno hollitortaa e amen menen tun, hara hinaa e aduna on?» ");
INSERT INTO fuf_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Iisaa jaabii mo, wi'i : «Kala yiɗuɗo lan ɗoftoto kongol an ngol, Ben an yiɗa mo, men ara e makko, men daakoo ka makko. ");
INSERT INTO fuf_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Kala non on mo yiɗaa lan ɗoftotaako konguɗi an ɗin. Ngol kongol ngol wonɗon e nanude hinaa e an iwri, kono ko e Baabaajo Nuluɗo lan on. ");
INSERT INTO fuf_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","«Mi yewtii on ɗun wa fewndo ko mi wondi e mon. ");
INSERT INTO fuf_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Kono on Ballo, ɗun ko *Ruuhu Seniiɗo mo Baabaajo on addoyta e innde an on, ko on jannoyta on kala huunde, andintina on kala ko mi wi'unoo on. ");
INSERT INTO fuf_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Miɗo accande on ɓuttu, ko ɓuttu an ngun mi woni on okkude. Mi alaa on non okkirde wano aduna on okkirta non. Wota ɓerɗe mon ɗen jiɓo, wota ɗe hulu kadi. ");
INSERT INTO fuf_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","«On nanii ko mi wi'i on kon wonde miɗo yahude, kono mi artoyay e mon. Si hiɗon yiɗunoomi, on weltorayno ko mi woni yaarude ka Baabaajo on kon, ɓay Baabaajo on no ɓuri lan mawnude. ");
INSERT INTO fuf_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ko mi woni on wowlirande ɗii piiji jooni, ado ɗi hewtude, ko fii nde ɗi hewtoyi ko yo on gomɗin. ");
INSERT INTO fuf_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Mi yewtidoytaa e mon buy han kadi, ko fii lanɗo aduna on no arude, kono o maraa bawgal woo e hoore an. ");
INSERT INTO fuf_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Kono aduna on no haani andude wonde miɗo yiɗi Baabaajo on, ko ɗun waɗi si miɗo waɗirde wano Baabaajo on yamirimmi non. Immee, iwen ɗoo!» ");
INSERT INTO fuf_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","O wi'i ɓe kadi: «Ko min woni daƴƴere tigi-tigiire nden, ko Baaba an woni Tutuɗo on. ");
INSERT INTO fuf_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","O taƴay kala salndu wonndu e an ndu rimataa, o feppita rimooji ɗin fow haa ɗi laaɓa fii yo ɗi ɓurtu rimude. ");
INSERT INTO fuf_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ɗun-le wuren on wonii laaɓuɓe sabu kongol ngol mi feɲɲinani on ngol. ");
INSERT INTO fuf_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Awa duumee e humagol e an, wano min kadi mi duumori e humagol e mon non. Ko fii salndu tun waawataa rimude, hara ndu siŋaaki e daƴƴere nden. Onon kadi wano non, si on humaaki e an, haray on waawataa rimude. ");
INSERT INTO fuf_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","«Ko min woni daƴƴere nden, ko onon woni calɗi ɗin. Kala on humondirɗo e an, wano min kadi mi humondiri e makko non, o rimay buy. Ko fii on waawataa waɗude hay huunde e ɓaawo an. ");
INSERT INTO fuf_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Kala mo humaaki e an, ko bugorteeɗo wa salndu taƴaandu yoori, sifa ɗin calɗi ko mooɓeteeɗi, bugee ka yiite, sunnee. ");
INSERT INTO fuf_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Si on humike e an, konguɗi an ɗin kadi wonii e mon, haray toree kala ko faalaɗon, ɗun newnante on. ");
INSERT INTO fuf_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","E hino no Baaba an mawninirtee: ko yo on rimu ko ɗuuɗi, wonon taalibaaɓe an. ");
INSERT INTO fuf_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","«Wano Baabaajo on yiɗirimmi non, ko non min kadi mi yiɗiri on. Tabitee e giggol an ngol. ");
INSERT INTO fuf_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Si on ɗoftike yamirooje an ɗen, wano mi ɗoftori yamirooje Ben an ɗen non, haray on tabitay e giggol an ngol, wano mi tabitiri e giggol makko ngol non. ");
INSERT INTO fuf_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ko mi yewtirani on nii ko fii yo weltaare an nden wonu e mon, e fii yo weltaare mon nden onon kadi wonu timmunde. ");
INSERT INTO fuf_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","E hino yamiroore nde mi yamiri on nden: Yiɗindiree wano mi yiɗiri on non. ");
INSERT INTO fuf_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Hay gooto alaa giggol ɓurngol mawnude wa okkitirgol ngurndan mun ɗan fii yiɓɓe mu'un ɓen. ");
INSERT INTO fuf_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Si on waɗii ko mi yamiri on kon, haray ko on yiɓɓe an. ");
INSERT INTO fuf_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Mi innataa on hande kadi kurkaaɗi, ko fii kurkaadu andaa ko jom mun waɗata. Mi wi'ii on yiɓɓe, ko fii ko mi andiri Ben an kon fow mi andinii on. ");
INSERT INTO fuf_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Awa kadi hinaa onon suɓii lan, kono ko min suɓii on, toɗɗii on kadi, fii yo on yahu rimoyon, kon ko rimuɗon lutta, e yo Baabaajo on yeɗu on kala ko toriɗon mo e innde an. ");
INSERT INTO fuf_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ko mi yamiri on, ko yo on yiɗindir.» ");
INSERT INTO fuf_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","«Si aduna on non aɲii on, andee o aɲiino lan ko adii on. ");
INSERT INTO fuf_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Si tawiino ko on ɓe oo aduna, aduna on yiɗayno on, ɓay ko on ɓe makko, kono nde tawnoo hinaa on ɓe oo aduna, awa kadi mi suɓike on e hakkunde oo aduna, ko ɗun waɗi si aduna on no joganii on ngayngu. ");
INSERT INTO fuf_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Anditee ngol kongol ngol mi wi'unoo on wonde kurkaadu ɓuraa jom mun teddude. Si ɓe cukkike lan, ɓe cukkoyto on onon kadi. Si ɓe ɗoftike kongol an ngol, ɓe ɗoftoyto konguɗi mon ɗin kadi. ");
INSERT INTO fuf_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Kono ɓe waɗay on ɗun fow sabu innde an nden, ɓay ɓe andaa Nuluɗo lan on. ");
INSERT INTO fuf_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Si tawno mi araali, maa mi wowlanaano ɓe, harayno ɓe felnaaki. Kono jooni non ɓe alaa lamitorgal fii junuubaaji maɓɓe ɗin. ");
INSERT INTO fuf_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ko fii kala aɲuɗo lan, haray aɲii Ben an. ");
INSERT INTO fuf_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Si tawno mi waɗaali e hakkunde maɓɓe ɗee kuuɗe ɗe hay gooto waɗaali, harayno ɓe felnaaki, kono jooni non ɓe yi'ii, ɓe aɲii lan, ɓe aɲii Ben an. ");
INSERT INTO fuf_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Kono bee ngol kongol windiingol ka Sariya maɓɓe laato, ɗun ko ngol wi'ungol: ‹Ɓe aɲii lan e ɓaawo hujja.› ");
INSERT INTO fuf_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","«Kono tuma Ballo on ari, ɗun ko on mo mi nulata e mon immorde e Baabaajo on, ɗun ko Ruuhu Wonduɗo e Goonga, on Ruuhu mo tawata ko iwruɗo ka Baabaajo on, o seeditanto lan. ");
INSERT INTO fuf_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Awa onon kadi, on seeditanoyto lan, ko fii hiɗon wondunoo e an gila ka fuɗɗoode.» ");
INSERT INTO fuf_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","«Ko mi wowlirani on ɗun ko fii wota on faljinoye. ");
INSERT INTO fuf_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ko fii ɓe yaltinoyay on ka juulirɗe, hay saa'i kadi aroyay nde tawata kala warɗo on sikkay o waɗii ko Alla yiɗi. ");
INSERT INTO fuf_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ko ɓe waɗiroyta ɗun, ko ɓay ɓe andaali Baabaajo on, ɓe andaali lan kadi. ");
INSERT INTO fuf_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ko mi wowlirani on ɗun, ko fii nde saa'i on hewtoyi, yo on anditoy wonde mi wowlaniino on ɗun. Ko haɗi mi wowlana on ɗun gila ka fuɗɗoode, ko fii hari miɗo wondi e mon.» ");
INSERT INTO fuf_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","«Jooni non miɗo yiltitorde ka Nuluɗo lan on, kono hay gooto e mon landaaki lan ko honto mi yahata. ");
INSERT INTO fuf_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ɓay mi wowlirii nii annde heewii e ɓerɗe mon. ");
INSERT INTO fuf_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","E hin-le miɗo wowlande on goonga, no moƴƴani on ka mi yaha. Ko fii si mi yahaali, Ballo on arataa e mon. Kono si mi yahii, mi nulay mo e mon. ");
INSERT INTO fuf_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Tuma o aroyi, o weeɓitanay aduna on fii junuubu e peewal e ɲaawoore: ");
INSERT INTO fuf_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","ka baŋŋe junuubu, ko ɓay hari ɓe hoolaaki lan, ");
INSERT INTO fuf_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","ka baŋŋe peewal, ko ɓay miɗo yaarude ka Baabaajo on, awa kadi on yiitataa lan han kadi, ");
INSERT INTO fuf_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ka baŋŋe ɲaawoore, ko ɓay lanɗo oo aduna ɲaawaama. ");
INSERT INTO fuf_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","«Miɗo mari fahin piiji buy ko mi yewta on, kono on waawataa faamude ɗi fewndo ɗoo. ");
INSERT INTO fuf_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Tuma on Ruuhu Wonduɗo e Goonga ari, o ardoyto on e kala goonga, ko fii konguɗi makko ɗin wonaa e makko iwroyta, kono o yewtoyay kala ko o nani, o yewta on kadi fii piiji aroyayɗi. ");
INSERT INTO fuf_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","O mawninoyay lan, ko fii o ƴettoyay e ko wonanimmi kon, o feɲɲinana on. ");
INSERT INTO fuf_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ko fii, kala ko Baabaajo on jeyi ko min wonani. Ko ɗun waɗi si mi wi'i wonde, o ƴettay e ko an kon, o feɲɲinana on. ");
INSERT INTO fuf_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","«Si ɓurii nii seeɗa, on yiitataa lan han kadi, onsay si nettii seeɗa, on yiitoyay lan kadi.» ");
INSERT INTO fuf_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Onsay woɓɓe e taalibaaɓe ɓen wi'indiri: «Ko honɗun oo woni en wi'ude: si ɓurii nii seeɗa, en yiitataa mo hande kadi, e hoore ɗun si nettii seeɗa en yiitay mo, e himo yaarude kadi ka Baabaajo on.»? ");
INSERT INTO fuf_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Tawi ko ɓe woni wi'ude: «Ko honɗun o wi'i ɗoo: ‹Si ɓurii nii seeɗa›? En andaa ko honɗun o woni wowlude.» ");
INSERT INTO fuf_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ɓay Iisaa andii wonde hiɓe faalaa mo landaade, onsay o wi'i ɓe: «Hiɗon landondira fii koo ko mi wi'i: ‹Si ɓurii nii seeɗa on yiitataa lan han kadi, awa kadi si nettii seeɗa on yiitay lan.› ");
INSERT INTO fuf_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ka haqiiqa haqiiqa mi andinii on, on wulloyay feson, aduna on kaɲun weltoo, wonoyon e nder annde, kono annde mon nden wattoyte weltaare. ");
INSERT INTO fuf_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Nde debbo no jibina, haray himo e annde, ko fii haray saa'i muuseendi hewtanii mo. Kono si o jibinii, haray o anditoytaa hande kadi fii ndin muuseendi makko, sabu weltaare ko o jibini boobo on kon. ");
INSERT INTO fuf_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Onon kadi hiɗon mari annde jooni, kono mi yiitidoyay e mon kadi, ɓerɗe mon ɗen weltoyto. Onsay hay gooto ittoytaa weltaare mon nden. ");
INSERT INTO fuf_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","E nden ɲalaande, on landotaako lan fii hay huunde hande kadi, ko fii, ka haqiiqa haqiiqa mi andinii on, Baabaajo on okkay on kala ko toriɗon e innde an. ");
INSERT INTO fuf_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ko fii haa jooni on toraaki hay huunde e innde an. Toree, on heɓay, fii no weltaare mon nden timmira. ");
INSERT INTO fuf_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","«Ko mise mi yewtiri on ɗun fow. Saa'i no aroya mo tawata mi yewtirtaa on mise hande kadi, kono hara ko no laaɓiri poy mi yewtirta on fii Baabaajo on. ");
INSERT INTO fuf_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Nden ɲande on toroyto e innde an, kono mi wi'aali on wonde mi toranoyto on Baabaajo on, ");
INSERT INTO fuf_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","ko fii haray Baabaajo on tigi no yiɗi on. Ko waɗi si kanko tigi o yiɗi on, ko ɓay hari on yiɗiino lan, awa kadi on gomɗiniino wonde ko ka makko kanko Alla mi iwi. ");
INSERT INTO fuf_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ko ka Baabaajo on mi iwi, mi ari e oo aduna. Jooni non miɗo iwude e oo aduna, mi yaha ka Baabaajo on.» ");
INSERT INTO fuf_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Onsay taalibaaɓe makko ɓen wi'i mo: «E hino jooni non hiɗon wowlude no laaɓiri, e on alaa wowlirde mise woo. ");
INSERT INTO fuf_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Jooni non meɗen andi wonde hiɗon andi kala huunde, awa kadi jaraa ka goɗɗo landoo on. Ko ɗun waɗi si meɗen gomɗini wonde ko ka Alla iwruɗon.» ");
INSERT INTO fuf_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Iisaa kadi jaabii ɓe, wi'i: «On gomɗinii jooni? ");
INSERT INTO fuf_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Awa e hino saa'i no arude, ɗun-le wuren o hewtii, ka tawata on saakitete, mo kala yaara sengo, accon mi min tun. Kono haray mi weddaaki ko fii Baabaajo on no wondi e an. ");
INSERT INTO fuf_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","«Ko mi wowlirani on nii, ko fii yo on heɓu ɓuttu e an. On heɓoyay satteendeeji e oo aduna, kono wakkilee, ko fii min mi foolii aduna on!» ");
INSERT INTO fuf_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ɓay wonii o wowlirii nii, onsay Iisaa ɓanti gite ɗen, o fewti ka dow, o wi'i: «Baaba an, saa'i on hewtii. Mawnin Ɓiɗɗo maa on, fii no Ɓiɗɗo maa on mawninira fii maa, ");
INSERT INTO fuf_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","wano yeɗirɗaa mo bawgal e hoore kala neɗɗo non, fii no o yeɗira kala mo okkuɗaa mo *ngurndan poomayankejan. ");
INSERT INTO fuf_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ngurndan poomayankejan ɗan ko yo ɓe ande an Alla Bajjo Goongaajo on, e Iisaa Almasiihu, mo nuluɗaa on. ");
INSERT INTO fuf_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Mi mawninii ma ka hoore leydi, mi timminii kuuɗe ɗe yamirɗaa mi waɗugol ɗen. ");
INSERT INTO fuf_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Jooni non an kadi, yo Baaba an, mawninan takko maa tigi, hara ko mangu ngu mi joginoo takko maa ngun ado aduna on woodeede. ");
INSERT INTO fuf_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","«Mi feɲɲinii innde maa nden e hakkunde yimɓe ɓe okkuɗaa mi ka aduna ɗoo ɓen. Ko an ɓe wonannoo, a okkii lan ɓe, awa ɓe ɗoftike daaluyee maa on. ");
INSERT INTO fuf_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Jooni ɓe andii wonde ko yeɗuɗaa mi kon fow ko e maa iwri. ");
INSERT INTO fuf_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ko fii, mi hewtinii ɓe daaluyeeji ɗi jonnuɗaa mi ɗin, ɓe jaɓii ɗi, awa ɓe andii ka haqiiqa wonde ko ka maa mi iwi, awa kadi ɓe gomɗinii wonde ko an nulimmi. ");
INSERT INTO fuf_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ko ɓen mi woni toranaade. Hinaa aduna on mi woni toranaade, kono ko ɓe yeɗuɗaa mi ɓen, ɓay ko ɓe maa. ");
INSERT INTO fuf_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Wano tawiri non kala ko mi jeyi ko an jeyi, awa kadi kala ko jeyuɗaa ko min jeyi, e hoore ɗun ko e maɓɓe mangu an ngun feeɲiri. ");
INSERT INTO fuf_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Hande kadi mi alaa e oo aduna. Kamɓe hiɓe ka aduna, min miɗo yahude ka maa. Yaa Baabaajo *Seniiɗo, hiwir ɓe innde maa nde okkuɗaa mi nden, fii no ɓe wonira gooto wano wonirɗen gooto non. ");
INSERT INTO fuf_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Fewndo mi wondi e maɓɓe, mi marirno ɓe innde maa nde okkuɗaa mi nden, mi hiwi ɓe. Hay gooto e maɓɓe majjaali, si hinaa muuyanaaɗo hayrugol on, fii no ko *hiitanoo ka defte kon laatora. ");
INSERT INTO fuf_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","«Jooni non miɗo yahude ka maa. Ko mi yewtiri ɗun ka aduna ɗoo, ko fii no weltaare an nden timmira e maɓɓe. ");
INSERT INTO fuf_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Mi hewtinii ɓe kongol maa ngol. Aduna on aɲii ɓe, ɓay ɓe jeyaaka e oo aduna, wano tawiri non min kadi mi jeyaaka e oo aduna. ");
INSERT INTO fuf_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Mi toraaki ma yo a suutu ɓe e oo aduna, kono ko yo a dandu ɓe Bonɗo on. ");
INSERT INTO fuf_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ɓe jeyaaka e oo aduna, wano tawiri non min kadi mi jeyaaka e oo aduna. ");
INSERT INTO fuf_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ko daaluyee maa on woni goonga on, waɗu ɓe ɓe maa rewrude e goonga on. ");
INSERT INTO fuf_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Wano nulirɗaa mi non ka aduna, min kadi mi nulirii ɓe non e oo aduna. ");
INSERT INTO fuf_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Min kadi non mi waɗitike mo maa fii maɓɓe, fii yo kamɓe kadi ɓe waɗito ɓe maa rewrude e goonga on. ");
INSERT INTO fuf_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","«Hinaa non kamɓe tun mi woni toranaade, kono hay gomɗinoyooɓe lan ɓen sabu konguɗi maɓɓe ɗin, ");
INSERT INTO fuf_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","fii no ɓe fow, ɓe wonira gooto wano an Baabaajo on wonirɗaa e an non, min kadi mi woniri e maa non. Kamɓe kadi, yo ɓe wonir non e men fii no aduna on gomɗinira wonde ko an nulimmi. ");
INSERT INTO fuf_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Min non mi okkii ɓe mangu ngu yeɗuɗaa mi ngun, fii no ɓe wonira gooto, wano wonirɗen gooto non. ");
INSERT INTO fuf_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Mi wona e maɓɓe, an kadi, wonaa e an, fii no ɓe wonira gooto few, e no aduna on andira wonde a nulii lan, awa kadi a yiɗii ɓe wano yiɗirɗaa mi non. ");
INSERT INTO fuf_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","«Baaba an, miɗo yiɗi yo ɓe okkuɗaa mi ɓen wonu ka mi woni ɗon, fii no ɓe yi'ira mangu an ngu yeɗuɗaa mi ngun, ɓay a yiɗiino lan ado aduna on woodeede. ");
INSERT INTO fuf_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","«Baaba an Feewuɗo, aduna on andaali ma, kono min, mi andii ma, awa ɓee ɗoo kadi andii ko an nulimmi. ");
INSERT INTO fuf_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Mi andinii ɓe innde maa nden, awa kadi mi andinay ɓe, fii no giggol ngol yiɗuɗaa mi ngol wonira e maɓɓe, min kadi mi wona e maɓɓe.» ");
INSERT INTO fuf_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ɓay Iisaa gaynii toraade, o yaltidi e taalibaaɓe makko ɓen, ɓe yahi e gaɗa joolol no wi'ee Kidruuna ka tutateeri woni, o naatidi ɗon e taalibaaɓe makko ɓen. ");
INSERT INTO fuf_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Tawi Yudaasi, ɗun ko janfotooɗo mo on, no andunoo nden nokkuure, ko fii hari Iisaa e taalibaaɓe mun ɓen no mooɓondiraynoo ɗon soono woo. ");
INSERT INTO fuf_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Yudaasi ardi e dental suufaaɓe e yeesooɓe goo, ɓe tawata ko hooreeɓe *yottinooɓe sadaka e *Fariisiyaaɓe ɓen immini, ɓe yahi ka o woni ɗon, tawi hiɓe jogii lampuuji e jowli e jogaaji. ");
INSERT INTO fuf_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Nde tawnoo Iisaa no andi ko arata mo e heɓude kon fow, o ɓadii ɓe, o wi'i: «Ko hombo ɗaɓɓitoton?» ");
INSERT INTO fuf_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ɓen jaabii mo, ɓe wi'i: «Ko Iisaa, oo jeyaaɗo Naasirata.» O wi'i ɓe kadi: «E hino lan.» Tawi Yudaasi, janfiiɗo mo on, no wondi e maɓɓe. ");
INSERT INTO fuf_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Fewndo ko Iisaa wi'i ɓe «e hino lan», ɓe yiltitori ɓawre-ɓawre, ɓe yani ka leydi. ");
INSERT INTO fuf_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","O landitii ɓe, o wi'i: «Ko hombo wonɗon ɗaɓɓitude?» Ɓe wi'i fahin: «Ko Iisaa, oo jeyaaɗo Naasirata.» ");
INSERT INTO fuf_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Iisaa jaabii ɓe fahin, wi'i: «Mi innii on: e hino lan. Si tawii ko min wonɗon ɗaɓɓitude, accitee ɓee ɗoo, ɓe yaha.» ");
INSERT INTO fuf_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ko nii kongol ngol o wi'unoo ngol laatori wonde: «Hay gooto e ɓe jonnuɗaa mi ɓen hayriraali lan.» ");
INSERT INTO fuf_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Tawi Sim'uunu Petruusu no jogii kaafa. Onsay o sorti ka, o soppi kurkaadu yottinoowo mawɗo sadaka on, o itti mo nowru ɲaamuru ndun. Tawi ndun kurkaadu no wi'ee Malkuusa. ");
INSERT INTO fuf_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Tun Iisaa wi'i mo kanko Petruusu: «Wattu kaafa maa kan ka holgo! A sikku mi yarirtaa jardukun tampere kun Baaba an yeɗimmi kun?» ");
INSERT INTO fuf_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Onsay ngal dental suufaaɓe e hooreejo mun e yeesooɓe Yahuudiyankeeɓe ɓen nangi mo kanko Iisaa, ɓe haɓɓi. ");
INSERT INTO fuf_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ɓe naɓiri mo taho ka Hannaana, on ko esiraawo Qayaafa, yottinoowo mawɗo sadaka on e nden hitaande. ");
INSERT INTO fuf_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Awa kadi ko Qayaafa on waajinoo Yahuudiyankeeɓe ɓen wonde no ɓuri ka aaden gooto maaya fii jamaa on. ");
INSERT INTO fuf_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Sim'uunu Petruusu e taalibaajo goo jokkiti Iisaa. Tawi yottinoowo mawɗo sadaka on no andi on taalibaajo, o naatidi e Iisaa ka nder tata yottinoowo mawɗo sadaka on. ");
INSERT INTO fuf_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Kono Petruusu kaɲun wontiri ka binde baafal ka ɓaawo. Oya taalibaajo, mo yottinoowo mawɗo sadaka on andunoo on, yalti, yewti debbo aynoowo dambugal ngal, o naadi Petruusu. ");
INSERT INTO fuf_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","On kurkaadu aynuɗo dambugal ngal wi'i Petruusu: «E hara an kadi, hinaa a tawdaaɗo e ɓee taalibaaɓe oo neɗɗo?» O jaabii: «Wonaa mi tawdaaɗo e maɓɓe.» ");
INSERT INTO fuf_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Tawi kurkaaɗi ɗin e aynooɓe ɓen, ɗun ko darinooɓe ɗon ɓen, no huɓɓi yiite, ko fii hari jaangol ngol no woodi, ɓe woni e iwlagol. Tawi Petruusu kadi no wondi e maɓɓe, no iwloo. ");
INSERT INTO fuf_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Onsay yottinoowo mawɗo sadaka on landii Iisaa fii taalibaaɓe mun ɓen e fii ko o jannaynoo kon. ");
INSERT INTO fuf_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Iisaa jaabii mo, wi'i: «Mi yewtayno aduna on e kene. Ko mi jannaynoo kon fow ko ka juulirɗe e ka *juulirde mawnde ka Yahuudiyankeeɓe ɓen fow fottaynoo ɗon. E hoore ɗun mi wowlaali hay fus e gundoo. ");
INSERT INTO fuf_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ko honɗun non landortaa mi? Lando nanirɓe lan ɓen ko honɗun mi wowlani ɗun. E hino hiɓe andi ko mi wi'i kon.» ");
INSERT INTO fuf_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ɓay Iisaa wi'ii ɗun, goɗɗo e ɓen aynooɓe wonnooɓe ɗon bantii Iisaa, e hoore himo wi'a: «Ko nii jaabortaa yottinoowo mawɗo sadaka on?» ");
INSERT INTO fuf_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Iisaa jaabii, wi'i: «Si mi wowlii ko boni, hollu ko honɗun e ko boni. Si tawii non ko ko moƴƴi mi wowli, haray ko honɗun piyirtaa mi?» ");
INSERT INTO fuf_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Onsay Hannaana feƴƴini mo ka Qayaafa, ɗun ko ka yottinoowo mawɗo sadaka on, e hoore himo haɓɓii. ");
INSERT INTO fuf_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Tawi kaɲun Sim'uunu Petruusu no darii ɗon, no iwloo. Onsay ɓe wi'i mo: «An kadi, hinaa a goɗɗo e taalibaaɓe makko ɓen?» O yeddi, o wi'i: «Hinaa mi taalibaajo makko few!» ");
INSERT INTO fuf_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Onsay goɗɗo e kurkaaɗi yottinoowo mawɗo sadaka on, ɗun ko musiɗɗo oo mo Petruusu ittunoo nowru mun, wi'i: «Taw si hinaa an e makko mi yi'idi ka tutateeri?» ");
INSERT INTO fuf_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Petruusu yeddi ɗun kadi. Tun ndontoori ndin ƴoggi. ");
INSERT INTO fuf_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ɓay ɓe iwii ka Qayaafa, ɓe naɓi Iisaa ka suudu laamu. Tawi ko ka subaka, laatii kamɓe tigi ɓe naataali ka suudu laamu fii wota ɓe tuunintino, fii no ɓe ɲaamira ka *Juldeere Yawtaneede. ");
INSERT INTO fuf_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Onsay Pilaatu lanɗo on yalti, tawoyi ɓe, o wi'i ɓe: «Ko feloore honde wonɗon fawude oo neɗɗo?» ");
INSERT INTO fuf_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ɓen jaabii, wi'i: «Si tawno o waɗaano bone, men addantaano ma mo.» ");
INSERT INTO fuf_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ko e hoore ɗun Pilaatu wi'i ɓe: «Ƴettee mo, onon tigi, ɲaawiron mo sariya mon on.» Kono Yahuudiyankeeɓe ɓen wi'i mo: «Men newnanaaka warugol goɗɗo.» ");
INSERT INTO fuf_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","(Tawi ko nii kongol ngol Iisaa wi'unoo ngol laatorta fii ɓangingol ko mayde honde o maayata.) ");
INSERT INTO fuf_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Onsay Pilaatu naatiti ka suudu laamu, o noddi Iisaa, o landii mo, o wi'i: «Hara ko an woni lanɗo Yahuudiyanke'en?» ");
INSERT INTO fuf_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Iisaa jaabii mo, wi'i: «E ko an wowlani ɗun hoore maa, kaa ko woɓɓe wowlan-maa ɗun fii an?» ");
INSERT INTO fuf_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilaatu kadi jaabii mo, wi'i: «E hara ko mi Yahuudiyankeejo? Ko jamaa maa on e hooreeɓe yottinooɓe sadaka ɓen wattu-maa e juuɗe an. Ko honɗun waɗuɗaa?» ");
INSERT INTO fuf_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Iisaa jaabii mo fahin, wi'i: «Laamateeri an ndin hinaa jeyaandi e oo aduna. Si tawno laamateeri an ndin ko jeyaandi e oo aduna, kurkaaɗi an ɗin haɓanayno lan fii wota mi watte nun e juuɗe Yahuudiyankeeɓe ɓen. Kono laamateeri an ndin hinaa jeyaandi ley gaa.» ");
INSERT INTO fuf_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Onsay Pilaatu wi'i mo: «Ko a lanɗo-le?» Iisaa jaabii mo, wi'i: «Ko ko wowluɗon kon onon tigi, ko mi lanɗo. Ko sabu ɗun mi heɓiraa e ko fii ɗun mi arani ka aduna: ko fii seeditanagol goonga on. Kala jeyaaɗo e goonga heɗoto kongol an ngol.» ");
INSERT INTO fuf_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilaatu wi'i mo fahin: «Ko honɗun woni goonga?» Ɓay wonii o wi'ii ɗun, o yalti kadi, o tawi Yahuudiyankeeɓe ɓen, o wi'i ɓe: «Min mi yi'aali hujja woo fawuɗo mo donkineede. ");
INSERT INTO fuf_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Kono Juldeere Yawtaneede kala, no woowi ka mi accitana on kasoojo gooto. Hara hiɗon yiɗi yo mi accitan on lanɗo Yahuudiyanke'en?» ");
INSERT INTO fuf_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Onsay ɓe ewnii, ɓe wi'i: «Kono hinaa non oo ɗoo, ko Barabaasi!» Tawi-le Barabaasi ko murtunooɗo. ");
INSERT INTO fuf_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Onsay Pilaatu yamiri yo ɓe naɓu Iisaa, ɓe focca. ");
INSERT INTO fuf_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Suufaaɓe ɓen kadi sacci katanwol bulle, ɓe waɗi ngol ka hoore Iisaa, ɓe ɓorni mo kadi dolokke boɗeejo. ");
INSERT INTO fuf_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ɓe ɓadii mo kadi kanko Iisaa, ɓe wi'i: «Salminaango e maa, yaa an lanɗo Yahuudiyankeeɓe!» Ɓe helloo mo bante kadi. ");
INSERT INTO fuf_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilaatu yaltiti fahin, wi'i hooreeɓe Yahuudiyankeeɓe ɓen: «Awa miɗo yaltinande on mo fii no andiron wonde mi yi'aali hujja woo fawuɗo oo donkineede.» ");
INSERT INTO fuf_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Onsay Iisaa yalti, tawi katanwol bulle ngol no ka hoore makko, himo ɓornii kadi dolokke boɗeejo. Pilaatu wi'i ɓe: «E hino aaden on!» ");
INSERT INTO fuf_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ɓay hooreeɓe *yottinooɓe sadaka ɓen e suufaaɓe ɓen yi'ii mo, ɓe ewnii, ɓe wi'i: «Fempee mo! Fempee mo!» Pilaatu kadi wi'i ɓe: «Ƴettee mo onon tigi, fempon. Ko fii min mi yi'aali hujja fawuɗo mo donkineede.» ");
INSERT INTO fuf_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Yahuudiyankeeɓe ɓen jaabii fahin, wi'i: «Meɗen mari Sariya, tippude e on Sariya himo haani wareede, ko fii himo waɗitii *Ɓiɗɗo Alla!» ");
INSERT INTO fuf_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ɓay Pilaatu nanii ngol kongol, o ɓurti hulude. ");
INSERT INTO fuf_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Onsay o naatiti ka nder suudu laamu, o wi'i Iisaa: «Ko honto iwuɗaa?» Kono laatii Iisaa jaabaaki mo. ");
INSERT INTO fuf_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilaatu wi'i mo kadi fahin: «A wowlantaa lan? E a andaa miɗo mari feere accitugol ma, maa fempugol ma?» ");
INSERT INTO fuf_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Onsay Iisaa jaabii mo, wi'i: «A heɓataa feere woo e hoore an si hinaa taw hara a yeɗa immorde ka dow. Ko ɗun waɗi, on wattuɗo lan e juuɗe maa fawtike junuubu ɓurɗo mawnude.» ");
INSERT INTO fuf_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Gila e on saa'i ɗon, tawi Pilaatu no ɗaɓɓude no accitira mo, kono Yahuudiyankeeɓe ɓen woni e ewnagol wi'a: «Si a accitii mo, haray hinaa a giɗo lanɗo mawɗo Roomu on! Ko fii kala waɗitiiɗo lanɗo, haray hollitike ko o gaɲo lanɗo mawɗo Roomu on!» ");
INSERT INTO fuf_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ɓay Pilaatu nanii ɗin konguɗi, o yaltini Iisaa ka yaasi, kanko Pilaatu o jooɗii ka ɲaawirde e nokkuure no wi'ee ‹Meltaande›, nden no wi'ee kadi e haala Yahuudiyanke ‹Gabbata›. ");
INSERT INTO fuf_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Tawi ko ɲande hebulanagol *Juldeere Yawtaneede nden, wa ka tumbere ɲalorma, o wi'i Yahuudiyankeeɓe ɓen: «E hino Lanɗo mon on!» ");
INSERT INTO fuf_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Kono ɓe ewnii, ɓe wi'i: «Yo o ware! Yo o ware! Fempee mo!» Pilaatu kadi landii ɓe: «Yo mi fempu Lanɗo mon on?» Onsay hooreeɓe yottinooɓe sadaka ɓen jaabii mo, wi'i: «Menen men maraa lanɗo goo si wonaa lanɗo mawɗo Roomu on!» ");
INSERT INTO fuf_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Onsay o watti mo e juuɗe maɓɓe fii yo o fempe. Kamɓe kadi ɓe ƴetti Iisaa, ɓe naɓi. ");
INSERT INTO fuf_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Iisaa yalti e nden saare, himo rondanii hoore makko *leggal altindiraangal ngal. O sutanii nokkuure wi'eteende Golgotaa e haala Yahuudiyanke, ko woni firo ɗun ko ‹Nokkuure Laalagal Hoore›. ");
INSERT INTO fuf_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ko ɗon ɓe fempi mo wondude e yimɓe ɗiɗo goo, mo bee e maɓɓe sengo goo, kanko Iisaa o woni ka hakkunde. ");
INSERT INTO fuf_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilaatu windi, waɗi ka dow leggal altindiraangal: «Iisaa oo jeyaaɗo Naasirata, Lanɗo Yahuudiyanke'en.» ");
INSERT INTO fuf_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Buy e Yahuudiyankeeɓe ɓen jangi kon ko windii, ko fii nden nokkuure nde Iisaa fempaa e mun no ɓattinoo saare nden, tawi ɗin bindi ko e haala Yahuudiyanke e haala Roomiyanke e haala Gereekiyanke windii. ");
INSERT INTO fuf_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Onsay hooreeɓe diina Yahuudiyankeeɓe ɓen wi'i Pilaatu: «Wota a windu ko o lanɗo Yahuudiyankeeɓe ɓen, kono windu: O wi'ii wonde ko kanko woni lanɗo Yahuudiyankeeɓe ɓen.» ");
INSERT INTO fuf_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Kono Pilaatu jaabii ɓe, wi'i: «Ko mi windi kon mi windii.» ");
INSERT INTO fuf_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ɓay wonii suufaaɓe ɓen fempii Iisaa, ɓe ƴetti conci makko ɗin, ɓe waɗi ɗi pecce nay, suufaajo kala heɓi feccere. Ɓe ƴetti kadi fokiya makko on, tawi on hinaa ɲo'aaɗo, ko o alluwal gootal gila dow haa ley. ");
INSERT INTO fuf_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Onsay ɓe wi'indiri: «Wota en seeku mo. Waɗen urɓa, ɗun hollay ko hombo o wonanta.» Tawi ɗun ko fii ko bindi ɗin *hiitinoo kon no laatora, ɗun ko: «Ɓe senditii conci an ɗin, ɓe waɗii fokiya an on urɓa.» Ko ɗun suufaaɓe ɓen waɗi. ");
INSERT INTO fuf_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Tawi yumma makko e miɲɲiraawo yumma makko, ɗun ko Mariyama sonna oo wi'eteeɗo Kulopaasi, e Mariyama Magaduuna no darii ka binde leggal altindiraangal ngal Iisaa fempaa e mun ngal. ");
INSERT INTO fuf_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ɓay Iisaa yi'ii yumma mun, awa kadi oo taalibaajo mo o yiɗi no darii takko yumma makko, onsay o wi'i yumma makko: «Neene, ko on ɗon woni ɓiɗɗo mon on.» ");
INSERT INTO fuf_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","O wi'i taalibaajo on kadi: «E hino ɗon yumma maa.» Gila e on saa'i ɗon, taalibaajo on naɓi Mariyama neene Iisaa ka mun. ");
INSERT INTO fuf_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ɓawto ɗun, nde tawnoo Iisaa no andi wonde fow huuɓii, o wi'i: «Miɗo ɗonɗaa!» fii ko bindi ɗin wi'i kon no laatora. ");
INSERT INTO fuf_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Tawi loonde tew njaram lammuɗan no ɗon. Ɓe waɗi linsere e salndu leggal no wi'ee *hisoopu, ɓe yolli nde ka ndiyan, ɓe ɓanni ka hunduko makko. ");
INSERT INTO fuf_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ɓay wonii o ƴettii ɗan njaram, o wi'i: «Fow laatike!» Ɓawto ɗun o liiƴi hoore nden, o timmi. ");
INSERT INTO fuf_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Nde tawnoo nden ɲande ko hebulanagol fii *ɲalaande fowteteende nden e tawde kadi nden ɲalaande ko mawnde. Tawi Yahuudiyankeeɓe ɓen faalaaka yo fureeji ɗin acce ka leɗɗe altindiraaɗe. Onsay ɓe torii Pilaatu yo koyɗe fureeji ɗin hele si ɗi ittee ɗon. ");
INSERT INTO fuf_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Onsay suufaaɓe ɓen ari heli koyɗe arano on e oya kadi mo o fempidanoo e mun. ");
INSERT INTO fuf_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ɓay wonii ɓe hewtii Iisaa, ɓe tawi o maayiino, laatii ɓe helaali mo koyɗe ɗen. ");
INSERT INTO fuf_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Kono goɗɗo e suufaaɓe ɓen tufiri mo conkenwal ka beccal, tun ndiyan e ƴiiƴan yalti. ");
INSERT INTO fuf_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Yi'uɗo mo on seeditike, awa seedee makko on ko goonga. Kanko non himo andi ko goonga o wowli, fii onon kadi no gomɗiniron. ");
INSERT INTO fuf_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ɗun waɗiri fii ko bindi ɗin wi'i kon no laatora wonde: «Ƴi'al makko woo heletaake.» ");
INSERT INTO fuf_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Nokku goo bindi ɗin no wi'i kadi: «Ɓe ndaaray mo ɓe tufi on.» ");
INSERT INTO fuf_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ɓawto ɗun goɗɗo no wi'ee Yuusufu jeyaaɗo Raamati, tawi on ko taalibaajo Iisaa nun, kono ko e nder gundoo sabu tawde himo hulunoo hooreeɓe Yahuudiyankeeɓe ɓen, o torii Pilaatu yo o newnan mo o ƴetta furee Iisaa on. Pilaatu newnani mo. Onsay o ari, o ƴetti furee on. ");
INSERT INTO fuf_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodiyuusu oo yahunooɗo ka Iisaa ɲande goo jemma, o ari kadi, o addori wa kiloo cappanɗe tati tiiri jillaandi *mirri. ");
INSERT INTO fuf_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Onsay ɓe ƴetti furee Iisaa on, ɓe tumbi e kasannge wondude e urngallooji, ɓay tawi ko ɗun woni naamu Yahuudiyankeeɓe ɓen fii surrugol. ");
INSERT INTO fuf_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Tawi tutateeri no e nden nokkuure nde o fempaa e mun, e nder ndin tutateeri kadi tawi no ton qaburu keso mo hay gooto surraaka e mun taho. ");
INSERT INTO fuf_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Nde tawnoo nden ɲande ko ɲalaande nde Yahuudiyankeeɓe ɓen woni hebulanaade fii aseweere nden, awa kadi ko on qaburu ɓuri ɓadaade, ɓe surroyi Iisaa e on qaburu. ");
INSERT INTO fuf_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","E alat, ɗun ko ɲallal aranal e nder yontere nden, Mariyama jeyaaɗo Magaduuna dawi bimbi law ka yenaande, tawi hentaaki taho. O tawi hayre nden ittaama ka yenaande. ");
INSERT INTO fuf_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Onsay o dogi, o tawoyi Sim'uunu Petruusu e oya taalibaajo mo Iisaa yiɗunoo, o wi'i ɓe: «Ɓe ittii Koohoojo on ka yenaande, men andaa ko honto ɓe waɗi mo!» ");
INSERT INTO fuf_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Onsay Petruusu e oya taalibaajo yalti, yaari ka yenaande. ");
INSERT INTO fuf_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ɓe ɗiɗoo non ɓe dogi, kono oya taalibaajo dogi ɓuri Petruusu, o adii hewtude ka yenaande. ");
INSERT INTO fuf_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","O ugginii, o yi'i kasannge on ka waalii, kono o naataali. ");
INSERT INTO fuf_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Sim'uunu Petruusu iwtirnooɗo ɓaawo makko on kaɲun kadi hewti, o naati ka nder yenaande, o haynii kasannge on no waalii ɗon ");
INSERT INTO fuf_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","e lefol waɗanoongol ka hoore Iisaa ngol, tawi ngol wondaa e kasannge on, kono tawi hingol taggaa, hingol feere. ");
INSERT INTO fuf_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Onsay oya taalibaajo, adinooɗo hewtude ka yenaande kaɲun kadi naati, o yi'i, o hoolii. ");
INSERT INTO fuf_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Tawi hari ɓe faamaali taho ko bindi ɗin wi'i kon wonde himo haani immitaade e hakkunde mayɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Onsay kamɓe taalibaaɓe ɓen ɓe yiltitii ka maɓɓe. ");
INSERT INTO fuf_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Tawi Mariyama Magaduuna no darii ka ɓaawo yenaande no wulla. E nder ko o wullata kon, himo ugginii, himo ndaara nder yenaande nden. ");
INSERT INTO fuf_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","O yi'i malaa'ikaaɓe ɗiɗo ɓorniiɓe daneeji no jooɗii ka furee Iisaa on waalinoo ɗon, goɗɗo on telen ka hoore, oya on telen ka koyɗe. ");
INSERT INTO fuf_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ɓen wi'i mo: «Debbo ko honɗun wullataa?» Kanko debbo on o jaabii ɓe, o wi'i: «Ko fii ɓe ittii ɗoo Koohoojo an on, mi andaa ka o waɗiraa.» ");
INSERT INTO fuf_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","E nder ko o wi'ata ɗun kon, o yeƴƴitii, o yi'i Iisaa no darii, kono tawi o andaa wonde ko Iisaa non. ");
INSERT INTO fuf_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Onsay Iisaa wi'i mo: «Debbo ko honɗun wullataa e ko hombo ɗaɓɓitataa?» Nde tawnoo himo sikka ko golloowo ka tutateeri, o wi'i mo: «Koohoojo si tawii ko an naɓi mo, haray yeeto lan ko honto waɗuɗaa mo, mi yahana mo.» ");
INSERT INTO fuf_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Iisaa wi'i mo kadi fahin: «Mariyama!» Debbo on fewti mo, wi'i e haala Yahuudiyanke: «Rabbunii!» (Ko woni ɗun ko «Karamoko'en».) ");
INSERT INTO fuf_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Kono Iisaa wi'i mo: «Wota a jogito lan, ko fii mi ƴentaali taho ka Ben an. Kono yahu ka musiɓɓe an ɓen, wi'aa ɓe wonde miɗo ƴentude ka Ben an e ka Ben mon, ka Alla an e ka Alla mon.» ");
INSERT INTO fuf_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Onsay kanko Mariyama Magaduuna o yahi, o wi'i taalibaaɓe ɓen wonde o yi'ii Koohoojo on, awa kadi kanko Iisaa o yewtii mo ɗun. ");
INSERT INTO fuf_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","E alat kiikiiɗe, ɗun ko ɲalaande aranere e nder yontere nden, tawi taalibaaɓe ɓen sokii baafe ɗen ka ɓe woni ɗon sabu kulol ngol ɓe huli Yahuudiyankeeɓe ɓen ngol. Onsay Iisaa ari darii hakkunde maɓɓe, o wi'i ɓe: «Yo jam wonu e mon!» ");
INSERT INTO fuf_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ɓay wonii o wi'ii ɗun, onsay o holli ɓe juuɗe makko ɗen e beccal makko ngal. Taalibaaɓe ɓen weltii fii ko ɓe yi'i Koohoojo on kon. ");
INSERT INTO fuf_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Iisaa wi'i ɓe kadi fahin: «Yo jam wonu e mon! Min kadi mi nulirii on wano Baabaajo on nulirimmi non!» ");
INSERT INTO fuf_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ɓawto ɗin konguɗi, o wutti e hoore maɓɓe, o wi'i ɓe: «Jaɓee *Ruuhu Seniiɗo on. ");
INSERT INTO fuf_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ɓe yaafaniɗon junuubaaji mun woo, ɗi yaafante ɓe. Ɓe on yaafanaaki junuubaaji mun woo, haray ɗi yaafaaka.» ");
INSERT INTO fuf_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tawi Tooma jammaaɗo Siwtaaɗo tawdaaɗo e sappoo e ɗiɗooɓe ɓen wondaa e maɓɓe fewndo ko Iisaa ari. ");
INSERT INTO fuf_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Onsay taalibaaɓe heddiiɓe ɓen wi'i mo: «Men yi'ii Koohoojo on!» Kono o wi'i ɓe: «Si mi yi'aali batte peŋe ɗen ka juuɗe makko, mi fawa hondu an ndun e batte ɗen peŋe, mi fawa kadi jungo an ngon ka beccal makko, haray mi hoolotaako few.» ");
INSERT INTO fuf_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ɓay yontii, tawi taalibaaɓe Iisaa ɓen no ka suudu kadi, tawi hiɓe wondi e Tooma. Onsay Iisaa ari darii hakkunde maɓɓe, tawi baafe ɗen no sokii, o wi'i ɓe: «Yo jam wonu e mon!» ");
INSERT INTO fuf_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","E hoore ɗun o wi'i Tooma: «Ɓannu ɗoo hondu maa ndun, ndaaraa juuɗe an ɗen, ɓannaa kadi jungo maa ngon, meemaa beccal an ngal. Wota a wonu mo hoolotaako, kono gomɗin!» ");
INSERT INTO fuf_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Onsay Tooma jaabii mo, wi'i: «Joomi an e Alla an!» ");
INSERT INTO fuf_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Iisaa wi'i mo kadi: «Ko ɓay a yi'ii lan si hooliɗaa. Kono maloore wonanii ɓen hooliiɓe ɓe yi'aali!» ");
INSERT INTO fuf_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Iisaa waɗii kadi maandeeji hawniiɗi goo ɗuuɗuɗi e tawnde taalibaaɓe makko ɓen, ɗi windaaki e ndee deftere. ");
INSERT INTO fuf_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Kono ɗunɗoo ko windanaa ko fii no gomɗiniron wonde ko Iisaa woni *Almasiihu on e *Ɓiɗɗo Alla on, e fii no heɓiron ngurndan e nder gomɗingol innde makko nden. ");
INSERT INTO fuf_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ɓawto ɗun Iisaa feeɲitani kadi taalibaaɓe mun ɓen e daande nduu *Weendu Tiberiyaada. E hino no o feeɲirani ɓe. ");
INSERT INTO fuf_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Tawi Sim'uunu Petruusu e Tooma jammaaɗo Siwtaaɗo e Natanayiila oo mo Kanaa, ɗun ko e nder Jaliilu, e ɓiɓɓe oo wi'eteeɗo Zabadii e taalibaaɓe makko ɗiɗo goo no wondi. ");
INSERT INTO fuf_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Sim'uunu Petruusu wi'i ɓe: «Miɗo yaade yungugol.» Kamɓe kadi ɓe wi'i mo: «Menen kadi men yaaday e maa.» Ɓe yalti, ɓe yahi, ɓe bakoyii ka laakun. Laatii e on jemma ɗon ɓe nangaali hay huunde. ");
INSERT INTO fuf_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ɓay weetii, tawi Iisaa no darii ka daande weendu, kono tawi taalibaaɓe ɓen andaa wonde ko Iisaa. ");
INSERT INTO fuf_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Kanko Iisaa o wi'i ɓe: «Fayɓe on heɓaali hay lingii?» Ɓe jaabii mo: «Hay gootii!» ");
INSERT INTO fuf_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Onsay o wi'i ɓe: «Bugoree *jalaaji ɗin ka sengo ɲaamo laakun kun, on heɓay!» Ɓe bugii ɗi, tawi hakkee ko liƴƴi ɗin ɗuuɗi, ɓe alaa feere pooɗugol jalaaji ɗin. ");
INSERT INTO fuf_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Onsay taalibaajo mo Iisaa yiɗunoo on wi'i Petruusu: «Ko Joomi on nii!» Nde Sim'uunu Petruusu nanirnoo wonde ko Joomi on nii, o ɓornii dolokke makko on, ko fii hari himo ɓortii, onsay o iwi ka laana o cikkii ka nder ndiyan. ");
INSERT INTO fuf_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ɓeya taalibaaɓe ardi e laakun kun e nder pooɗorgol jalaaji ɗin e hoore hiɗi heewi tew liƴƴi, ko fii hari hiɓe woɗɗitori pencen on wa sogone teemeɗɗe ɗiɗi. ");
INSERT INTO fuf_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ɓay wonii ɓe tippike ka leydi, ɓe yi'i ɗon liƴƴi no fawii e hoore yiite, wondude e bireedi. ");
INSERT INTO fuf_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Iisaa wi'i ɓe: «Addee goɗɗi e liƴƴi ɗi nanguɗon jooni ɗin.» ");
INSERT INTO fuf_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Onsay Sim'uunu Petruusu ƴawi ka laakun, o pooɗi jalaaji ɗin, o tippini ka leydi. Tawi ɗin jalaaji no heewi liƴƴi njani yonuɗi teemedere e cappanɗe jowi e tati. Fii kala non hiɗi ɗuuɗunoo, kono jalaaji ɗin seekaaki. ");
INSERT INTO fuf_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Iisaa wi'i ɓe: «Aree ɲaamon.» Laatii hay gooto e taalibaaɓe ɓen suusaali mo landaade wi'a: «Ko an hombo nii?» Ko fii hari hiɓe andi ko Joomi on. ");
INSERT INTO fuf_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Onsay Iisaa ɓadii, o ƴetti bireedi on e liƴƴi ɗin, o jonni ɓe. ");
INSERT INTO fuf_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Tawi ko tammun ɗun non Iisaa no feeɲana taalibaaɓe mun ɓen gila o immintinaa e hakkunde mayɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ɓay ɓe gaynii ɲaamude, Iisaa wi'i Sim'uunu Petruusu: «Ko an yo Sim'uunu mo Yuunusa, e hara hiɗa yiɗi lan ɓuri ɓee ɗoo?» O jaabii mo, o wi'i: «Hiiyii Joomi an, hiɗa andi miɗo yiɗu-maa.» Onsay Iisaa wi'i mo: «Awa danko baaloy an koy.» ");
INSERT INTO fuf_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Iisaa wi'i mo kadi: «Enee Sim'uunu mo Yuunusa, hiɗa yiɗimmi?» Kanko Sim'uunu o jaabii mo, o wi'i: «Hiiyii Joomi an, hiɗa andi miɗo yiɗu-maa.» Onsay Iisaa wi'i mo: «Awa aynu baali an ɗin.» ");
INSERT INTO fuf_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","O wi'i mo kadi tammun: «Sim'uunu mo Yuunusa, e hara hiɗa yiɗi lan?» Ɗun aanini Petruusu fii ko o wi'i mo kon tammun si himo yiɗi mo. O jaabii mo, o wi'i: «Joomi an, hiɗa andi kala huunde. Hiɗa andi miɗo yiɗu-maa.» Iisaa wi'i mo kadi: «Awa danko baali an ɗin. ");
INSERT INTO fuf_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ko fii ka haqiiqa haqiiqa mi andinii ma, wa fewndo ko wonnoɗaa suka, a daditantono hoore maa dolokke maa on, yahaa ka faalaɗaa. Kono si a nawyoyii, a fontay juuɗe maa ɗen, goɗɗo dade, o naɓe ka a faalanooka.» ");
INSERT INTO fuf_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Tawi ko o wi'iri ɗun, ko fii hollugol ko mayde honde Petruusu maayata fii mawningol Alla. Ɓay o gaynii yewtude mo ɗun, o wi'i mo: «Jokkan!» ");
INSERT INTO fuf_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Kanko Petruusu o yeƴƴitii, o yi'i oo taalibaajo mo Iisaa yiɗi ka jokkata ɓe, ɗun ko oo liiƴinooɗo ka ɓernde Iisaa fewndo ko ɓe ɲaamaynoo, o wi'i: «Koohoojo ko hombo woni wattoowo on e joge.» ");
INSERT INTO fuf_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ɓay o yi'ii mo, kanko Petruusu, o wi'i Iisaa: «Oo ɗoo non Joomi an, ko honɗun heɓoyta mo?» ");
INSERT INTO fuf_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Iisaa jaabii mo, wi'i: «Si miɗo faalaa o wona haa nde mi artoyi, haaju maa e ɗun? An jokkan tun!» ");
INSERT INTO fuf_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","E hoore ɗun, kan haala jonnondiraa e hakkunde musiɓɓe ɓen wonde on taalibaajo maayataa. E hara-le Iisaa wi'aali mo wonde on maayataa, kono ko o wi'i ko: «Si miɗo faalaa o wona haa nde mi artoyi, haaju maa e ɗun?» ");
INSERT INTO fuf_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ko on taalibaajo seeditii fii ɗin piiji windi ɗi. Awa hiɗen andi nden seeditoore makko ko goonga. ");
INSERT INTO fuf_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Iisaa waɗuno piiji goo kadi buy. Si men winduno ɗun men fensiti, mi sikkaano si ɗen defte ɗe men windaynoo heƴayno e aduna on.");
INSERT INTO fuf_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ko an yo Tawaafiilu, mi yewtuno ka deftere an aranere fii kala ko Iisaa nangannoo waɗugol e jannugol, ");
INSERT INTO fuf_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","haa e ɲalaande ƴentineede makko, ɓawto o yamirde *sahaabaaɓe ɓe o suɓinoo ɓen immorde e *Ruuhu Seniiɗo on, ");
INSERT INTO fuf_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","ɗun ko ɓen ɓe o hollitii himo wuuri ɓawto o wareede, ɓe o waɗani seedeeji ɗuuɗuɗi fii ummutal makko ngal. O feeɲani ɓe e nder balɗe cappanɗe nay, himo haalana ɓe fii *laamu Alla ngun. ");
INSERT INTO fuf_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ɲande goo, ko o wondi e maɓɓe, o yamirno ɓe wota ɓe woɗɗito *Yerusalaam, kono yo ɓe habbo fodaari Baabaajo on, o wi'i ɓe: «Ɗun ko ndin ndi mi wowlani on fii mun. ");
INSERT INTO fuf_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ko fii Yaayaa kaɲun ko ndiyan lootiraynoo, kono onon e nder balɗe nii ko Ruuhu Seniiɗo on lootirteɗon.» ");
INSERT INTO fuf_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Nde tawnoo hiɓe mottondiri takko makko, ɓe landii mo, ɓe wi'i: «Joomi, hara ko e on saa'i joɗɗintintaa laamu *Isra'iila ngun?» ");
INSERT INTO fuf_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","O jaabii ɓe, o wi'i: «Wonaa onon haani andude fewndooji e saa'iiji ɗi Baabaajo on toɗɗori bawgal mun ngal e mun ɗin. ");
INSERT INTO fuf_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Kono onon on heɓay bawgal nde Ruuhu Seniiɗo on ari e mon, wonon seedeeɓe an Yerusalaam e diiwal *Yahuuda ngal fow e diiwal *Samariiya ngal fow haa ka kattuɗe leyɗe.» ");
INSERT INTO fuf_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ɓay o gaynii ɓe wowlande ɗun, wa fewndo ko ɓe ndaarata mo, o ƴentinaa, onsay duulere wirni mo e gite maɓɓe. ");
INSERT INTO fuf_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ko ɓe tiggitii ka kammu, fewndo ko o ƴentata, worɓe ɗiɗo ɓorniiɓe daneeji feeɲani ɓe, wi'i ɓe: ");
INSERT INTO fuf_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","«Ko onon yo ɓe Jaliilu, ko honɗun dariɗon, hiɗon ndaara nguu kammu? Iisaa oo ƴentinaaɗo ka kammu e hakkunde mon artiroyay wano yiiruɗon o ƴentiniraama ka kammu nii.» ");
INSERT INTO fuf_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Onsay ɓe yiltitii Yerusalaam ɓe iwi e ngon fello wi'eteengo Fello *Zaytuuni woɗɗitorngo Yerusalaam yeru sagara yaadu happaandu e *ɲalaande fowteteende nden. ");
INSERT INTO fuf_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ɓay wonii ɓe hewtitii, ɓe naatiroyi ka suudu dow-dowru ndu ɓe woni weerude e mun ndun. Tawi ɓen ko Petruusu, e Yuuhanna e Yaaquuba e Andaraawu, kaɲun e Filiipu e Tooma e Bartolomaawu e Matta e Yaaquuba mo Alfaa e Sim'uunu tawdaaɗo e fedde *Zelotiiɓe ɓen, e Yahuuda mo Yaaquuba. ");
INSERT INTO fuf_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ɓe fow e nder nanondiral maɓɓe, ɓe duumii e toragol Alla, toroda e rewɓe ɓen wondude e Mariyama yumma Iisaa e neene-gootooɓe makko ɓen kanko Iisaa. ");
INSERT INTO fuf_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","E ɗen balɗe ɗon, Petruusu immii, o darii hakkunde musiɓɓe ɓen. Tawi ɓen mooɓinooɓe ɗon ko wa ɓe teemedere e noogayo. O wi'i ɓen: ");
INSERT INTO fuf_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","«Musiɓɓe, bee ko windanoo kon waɗa, ɗun-le ko ko Ruuhu Seniiɗo on longinnoo Daawuuda kon, o *hiitii fii oo wi'eteeɗo Yudaasi ardinooɗo ɓee nangunooɓe Iisaa. ");
INSERT INTO fuf_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","On no tawdanoo e men, awa kadi himo marnoo geɓal e ɗee golle men.» ");
INSERT INTO fuf_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Yudaasi hendorii ngesa mban njoddi janfa mun kan, ko ɗon fii makko lanniri hippagol, fecco e hakkunde, nder reedu makko ndun fow lancitii. ");
INSERT INTO fuf_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Hakkee ko jeyaaɓe Yerusalaam ɓen fow andunoo fii ɗun, ɓe inni mban ngesa e haala maɓɓe ‹Hakel-Dama›, ko woni firo ɗun ko Ngesa Ƴiiƴan.) ");
INSERT INTO fuf_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","«E hin-le no windii ka deftere Zabuura: ‹Yo galle on ɗen caabu, hara hay gooto hoɗataa ɗon.› «No windii kadi: ‹Yo goɗɗo lonto mo ka ardagol.› ");
INSERT INTO fuf_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Kanko Petruusu o wi'i kadi: «Ko ɗun waɗi, bee goɗɗo e ɓee wondunooɓe e men fewndo ko jindideten e Iisaa Joomi on, ");
INSERT INTO fuf_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","gila ko Yaayaa lootunoo mo haa ɲande o ƴentinaa hakkunde men, heɓoo ko wonda e men seeditoo fii ummutal makko ngal.» ");
INSERT INTO fuf_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Onsay ɓe ɓanni yimɓe ɗiɗo: goɗɗo on no wi'ee Yuusufu, ɗun ko Barsabaa jammaaɗo Yustuusa, oya on no wi'ee Matiyaasa. ");
INSERT INTO fuf_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Onsay ɓe torii, ɓe wi'i: «Yaa an Joomiraaɗo Anduɗo ɓerɗe yimɓe fow, ɓanginan men ko hombo e ɓee ɗiɗo suɓiɗaa ");
INSERT INTO fuf_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","fii ko lontoo Yudaasi e golle e sahaabankaaku mun, ɓay kanko Yudaasi o sortike, o yahii ka o muuyanaa ɗon.» ");
INSERT INTO fuf_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ɓe waɗi urɓa hakkunde ɓen ɗiɗo, urɓa on hawri e Matiyaasa, on tawtinaa sahaabaaɓe ɓen sappoo e go'o. ");
INSERT INTO fuf_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Nde ɲalaande juldeere wi'eteende *Pentakosta hewtunoo, tawi ɓe fow hiɓe wondi nokkun gootun. ");
INSERT INTO fuf_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Tun nde wootere, hawa wa hendu tiiɗundu iwri ka kammu ari, hebbini suudu ka ɓe woni ɗon. ");
INSERT INTO fuf_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Onsay wa ɗenɗe yiite feeɲani ɓe, ɗe sendondiri, ɗe woni e hoore mo kala e maɓɓe. ");
INSERT INTO fuf_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ɓe fow ɓe heewi *Ruuhu Seniiɗo on, ɓe nangani wowlugol e *haalaaji goo, mo bee e ko Ruuhu on longini ɗun. ");
INSERT INTO fuf_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Tawi wa nden ɲande *Yahuudiyankeeɓe rewooɓe Alla iwruɓe e leyɗe aduna on fow no Yerusalaam. ");
INSERT INTO fuf_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","E nder ko hawa kan waɗata kon, jamaa mooɓinooɗo ɗon on jiiɓii sabu ko mo kala e maɓɓe nanaynoo ɓen no wowla e haala mun kan tigi kon. ");
INSERT INTO fuf_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ɗun ŋalɗini ɓe haa feƴƴiti, e hoore hiɓe wi'a: «Hara ɓee yimɓe wonɓe wowlude ɗoo fow hinaa ɓe diiwal Jaliilu? ");
INSERT INTO fuf_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ko honno nanirɗen ɓee no wowla e haala ka muynuɗen kan tigi? ");
INSERT INTO fuf_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ɗun ko enen ɓee Fartiyankooɓe e Maadiyankooɓe e Elaamiyankooɓe e ɓee hoɗuɓe Mesopotamii e ka diiwal Yahuuda e ɓe Kapadoosi ɓen e ɓe Pontii ɓen e ɓe *Aazii ɓen, ");
INSERT INTO fuf_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","e ɓe Firgii ɓen e ɓe Pamfilii ɓen e ɓe Misira ɓen e ɓee jeyaaɓe e ndii leydi Libii kawtirɓe e Sirenii e iwruɓe Roomu ɓen, ");
INSERT INTO fuf_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ɗun ko Yahuudiyankeeɓe ɓen e naatuɓe e diina Yahuudiyanke ɓen e jeyaaɓe Kereeti ɓen e Aarabeeɓe ɓen, enen ɗoo fow en nanii hiɓe wowla e haala mo kala e men fii kuuɗe Alla mawɗe ɗen!» ");
INSERT INTO fuf_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Tawi ɗun no ŋalɗini ɓe fota ɓe fow haa hiɓe jiɓii, ɓe nangi wi'indirgol: «Ko honɗun ɗu'un holli?» ");
INSERT INTO fuf_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Kono woɓɓe no awmotonoo ɓe, wi'a: «Ɓee ko yaruɓe haa mandili!» ");
INSERT INTO fuf_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ontuma Petruusu immodi e *sahaabaaɓe ɓen sappoo e go'o, o ewnii jamaa on, o wi'i ɓe: «Ko onon yo Yahuudiyankeeɓe e kala hoɗuɗo Yerusalaam, heɗitee konguɗi an ɗin, andon ɗunɗoo. ");
INSERT INTO fuf_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ko fii hinaa ko sikkuɗon kon, ɓee wonaa mandiluɓe nii, ko walluhaa on nii. ");
INSERT INTO fuf_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","E hino ko annabi Yuu'iila wi'unoo kon, himo wi'i: ");
INSERT INTO fuf_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‹Alla daalii: Ka balɗe sakkitore mi tippinay Ruuhu an on e hoore kala tagaaɗo haa heewa. Onsay ɓiɓɓe mon worɓe e rewɓe haaloyay ko Alla longini ɗun, sukaaɓe mon ɓen yi'oya feɲɲinanɗe, mawɓe mon ɓen hoydoya koyɗi.› ");
INSERT INTO fuf_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","‹Kanko Alla o daalii kadi: Ko non woniri e ɗen ɲalaaɗe ɗon, mi tippinay Ruuhu an on e hoore jiyaaɓe an ɓen worɓe e rewɓe, ɓe haala ko ɓe longinaa. ");
INSERT INTO fuf_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Mi waɗa kadi kaawakeeji ka kammu dow, e maandeeji ka hoore leydi, ɗun hara ko ƴiiƴan e yiite e duggal curki. ");
INSERT INTO fuf_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Naange ngen wayloo niɓe, lewru ndun kadi wayloo ƴiiƴan, ɗun ko ado ɲalaande Joomiraaɗo on hewtude, ɗun ko nden ɲalaande mawnde teddunde. ");
INSERT INTO fuf_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Onsay kala jantotooɗo innde Joomiraaɗo on dandoyte.› ");
INSERT INTO fuf_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Kanko Petruusu o wi'i kadi: «Ko onon yo *Isra'iilayankeeɓe, heɗitee ɗii konguɗi an! Oo gorko wi'eteeɗo Iisaa, oo jeyaaɗo Naasirata, on mo Allaahu on ɓanginiri yeeso mon kaawakeeji moƴƴi e kuuɗe e maandeeji, kon ko Alla warri e makko e hakkunde mon, wano andirɗon non tigi, ");
INSERT INTO fuf_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","ɗun ko on waɗaaɗo e joge tippude e eɓɓoore Alla nden e gandal makko adiingal ngal kanko Alla, warirɗon mo wattugol mo e juuɗe heeferɓe ɓen, ɓen wariri mo fempugol wenga. ");
INSERT INTO fuf_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Allaahu on immintinii mo, o sortii mo e nder ndin muuseendi mayde, ko fii hari gasataa ka nguli mayde kin jogoo mo ton. ");
INSERT INTO fuf_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ko fii hari Daawuuda wi'irii nii fii makko, woo: ‹Mi yi'ay Joomiraaɗo on saa'i woo yeeso an, ko fii hari himo ka sengo ɲaamo an fii wota mi diwnu. ");
INSERT INTO fuf_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ko ɗun waɗi si ɓernde an nden no heewi weltaare, ɗenngal an ngal no e nder welo-welo, hay ɓandu an ndun fowtoto e nder tanƴinaare. ");
INSERT INTO fuf_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ko fii a accoytaa wonkii an kin ka wonunde mayɓe, awa kadi a jaɓataa *Seniiɗo maa on laatoo ɲolɗo. ");
INSERT INTO fuf_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","A andinii lan laawi ngurndan ɗin, a hebbinay lan weltaare yeeso maa.› ");
INSERT INTO fuf_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Kanko Petruusu o wi'i kadi: «Musiɓɓe, newnanee lan mi yewta on no laaɓiri fii Daawuuda oo baabiraawo meeɗen, on maynooɗo surraa, mo tawata yenaande mun no woodaa haa jooni hakkunde men. ");
INSERT INTO fuf_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Nde tawnoo ko o annabaajo, himo andi kadi wonde Allaahu on woondanii mo woondoore wonde o joɗɗinay goɗɗo e jurriya makko on ka jullere laamu makko. ");
INSERT INTO fuf_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","O *hiitino fii immintinegol *Almasiihu on, on mo accoytaake ka wonunde mayɓe ɓen, ɗun ko on mo ɓandu mun laatoytaako ɲolayndu. ");
INSERT INTO fuf_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Iisaa on non, Allaahu on immintinii mo, men fow ko men seedee ɗun. ");
INSERT INTO fuf_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Alla ɓantirii mo ka sengo mun ɲaamo, o hendike e juuɗe Baabaajo on ko fodanoo kon, ɗun ko Ruuhu Seniiɗo on, kanko kadi o tippinii ɗun, wano wonɗon yiirude nii, e no wonɗon nanirde nii. ");
INSERT INTO fuf_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Fii kala Daawuuda yahaali ka kammu, kono kanko tigi o wi'i: ‹Joomiraaɗo on daalanii Joomi an on: Jooɗor ka sengo an ɲaamo, ");
INSERT INTO fuf_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","haa mi waɗa ayɓe maa ɓen ka ley teppe maa.› ");
INSERT INTO fuf_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Kanko Petruusu o wi'i kadi: «Awa yo *bolondaaji Isra'iila ɗin fow andu e nder pellital wonde Allaahu on waɗii Iisaa, oo mo fempunoɗon, Almasiihu e Joomi.» ");
INSERT INTO fuf_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ɓay ɓe nanii ɗun, ɗun naati e ɓerɗe maɓɓe ɗen. Onsay ɓe wi'i Petruusu e ɓeya sahaabaaɓe: «Musiɓɓe, ko honɗun men haani waɗuɗe?» ");
INSERT INTO fuf_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Petruusu wi'i ɓe: «Tuubee, mo kala e mon kadi *lootoo maande kisiyee e innde Iisaa Almasiihu on, fii yaafuyee junuubaaji mon ɗin. Onsay on heɓay dokkal Ruuhu Seniiɗo on. ");
INSERT INTO fuf_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ko fii fodaari ndin ko fii mon e fii ɓiɓɓe mon ɓen e fii kala woɗɗitiiɗo, ɗun ko kala ɓen ɓe Alla Joomiraaɗo men on noddoyta.» ");
INSERT INTO fuf_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Awa ko konguɗi ɗuuɗuɗi goo kadi o seeditorani ɓe, e himo waajotonoo ɓe kadi, wi'a: «Dandee hoore mon e nguu jamaanu ɓoyliingu.» ");
INSERT INTO fuf_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ɓen jaɓuɓe kongol makko ngol, lootaa maande kisiyee. Nden ɲande ko wa guluuje tato yimɓe ɓeyditii e maɓɓe. ");
INSERT INTO fuf_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Onsay ɓe duumii e janndeeji ɓen sahaabaaɓe, e mottondirgol fii jokkere enɗan e ɲaamidugol e toragol Alla. ");
INSERT INTO fuf_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ŋalaw heɓi mo kala e maɓɓe. Tawi sahaabaaɓe ɓen no waɗaynoo kaawakeeji moƴƴi e maandeeji heewuɗi. ");
INSERT INTO fuf_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Onsay gomɗinnooɓe ɓen fow wontidi, ɓe hawti piiji ɗin fow. ");
INSERT INTO fuf_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ɓe yeeyi keyeeji maɓɓe ɗin e ko wonani ɓe kon, ɓe senditi ɗun hakkunde maɓɓe, mo kala e ko hatonjini kon. ");
INSERT INTO fuf_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Tawi ɲande woo e nder wakkilaare maɓɓe e nanondiral hiɓe wontidi, hiɓe ka *juulirde mawnde, awa kadi ɓe ɲaamidayno ka nder cuuɗi, ɓe ɲaamida e nder welo-welo e ɓernde laaɓunde, ");
INSERT INTO fuf_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","ɓe manta Alla, ɓe heɓayno kadi sulfu jamaa on fow. Joomiraaɗo on kadi no ɓeydiraynoo *moftal maɓɓe ngal ɲande woo ɓen wonaaɓe dandeede. ");
INSERT INTO fuf_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ɲande goo, tawi Petruusu e Yuuhanna no yahude ka *juulirde mawnde ka waqutu juuleteeɗo e saa'i sappoo e jowaɓo on. ");
INSERT INTO fuf_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ɗun hawrondiri aaden jibindinaaɗo e boofoyaagal no addeede joɗɗinee ka dambugal juulirde mawnde wi'eteengal Dambugal Fotungal, fii toragol naatooɓe ɓen ka juulirde, wano woowirannoo mo non kanko jukkunnaajo on ɲande woo. ");
INSERT INTO fuf_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","No o yiirunoo Petruusu e Yuuhanna no e fii naatugol, o torii yo ɓe okkor mo. ");
INSERT INTO fuf_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Kono Petruusu e Yuuhanna tenƴini mo, ɓe wi'i: «Ndaarii men!» ");
INSERT INTO fuf_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Kanko kadi o tenƴini ɓe, himo tanƴininoo heɓirgol ɓe goɗɗun. ");
INSERT INTO fuf_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Kono Petruusu wi'i mo: «Mi maraa kaalisi maa kaŋŋe, kono non mi okkorte ko mi jogii kon. Immo, waawaa yahude e innde Iisaa Almasiihu on, oo jeyaaɗo Naasirata!» ");
INSERT INTO fuf_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Onsay kanko Petruusu o jogori mo jungo makko ɲaamo ngon, o immini. Tun koyɗe on ɗen e kolɓule mun ɗen sattiti. ");
INSERT INTO fuf_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","O hawtii kisan, o nangani yaadu, o naatidi e maɓɓe ka juulirde mawnde e hoore himo yaha hoccoo, manta Alla. ");
INSERT INTO fuf_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Jamaa on fow yi'i himo yaha manta Alla. ");
INSERT INTO fuf_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ɓay ɓe anditii wonde ko kanko jooɗotonoo toroo ka dambugal juulirde mawnde wi'eteengal Fotungal, ɓe ŋalɗi ɗun, ɓe haawii fii kon ko o waɗanaa. ");
INSERT INTO fuf_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Kono tawi on jukkunnaajo alaa seedude e Petruusu e Yuuhanna. Jamaa on fow dogiri ka ɓe woniri ton, ɗun ko ka tungarru wi'eteendu *Tungarru Sulaymaana, e hoore hiɓe ŋalɗi. ");
INSERT INTO fuf_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ɓay Petruusu yi'ii ɗun, o wi'i jamaa on: «Ko onon yo *Isra'iilayankeeɓe, ko fii honɗun ŋalɗanɗon fii ɗun? E ko fii honɗun ndaarirton men nii, wa si ko doole amen maa dewal amen men imminiri oo neɗɗo, o waawi yahude? ");
INSERT INTO fuf_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Awa kadi on Alla Ibraahiima e Issaaqa e Yaaquuba, ɗun ko on Alla baabiraaɓe men ɓen, o mawniniino on Jiyaaɗo makko, ɗun ko Iisaa, on mo hendinnoɗon Pilaatu lanɗo on, yedduɗon, ɗun ko on mo o aadinoo accitugol. ");
INSERT INTO fuf_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Kono onon yedduɗon on *Seniiɗo Feewuɗo, toriɗon sulfu fii yo on accitane warnooɗo yimɓe goo, ");
INSERT INTO fuf_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","warɗon on wonɗo daƴƴere ngurndan ɗan. Kono Allaahu on immintinii mo e hakkunde mayɓe ɓen. Ko men seedee ɗun. ");
INSERT INTO fuf_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ko tippude e gomɗingol innde makko nden kanko Iisaa, waɗi si oo neɗɗo sattiti. Ko e immorde e innde Iisaa nden e gomɗingol e mayre on waɗi si oo neɗɗo yeɗaa cellal timmungal yeeso mon on fow. ");
INSERT INTO fuf_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","«Jooni non yo musiɓɓe, miɗo andi, onon e hooreeɓe mon ɓen, ko angal andude warrunoɗon ɗun. ");
INSERT INTO fuf_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Kono ko non Allaahu on laatiniri kon ko o longinnoo annabaaɓe ɓen fow ko adii ɗun, ɗun ko wonde *Almasiihu makko on no haanunoo tampude. ");
INSERT INTO fuf_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Jooni non, tuubee, ruttoɗon fii yo junuubaaji mon ɗin monte, ");
INSERT INTO fuf_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","fii no Joomiraaɗo on yeɗira on saa'iiji fowtere immorde e makko, e fii no o additirana on on Almasiihu mo fodanoɗon, ɗun ko Iisaa. ");
INSERT INTO fuf_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Himo haani wonude ka kammu ton haa tuma Allaahu on heydintini ko o daalirnoo annabaaɓe makko laaɓuɓe ɓen kon fow gila law. ");
INSERT INTO fuf_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Muusaa wi'uno: ‹Alla Joomiraaɗo mon on yaltinanoyay on annabaajo wa'uɗo wa an min e hakkunde musiɓɓe mon ɓen. Ko yo on heɗoyo kala ko o wi'oyi on. ");
INSERT INTO fuf_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Kono kala on mo heɗoyaaki on annabaajo, o suutete e hakkunde jamaa on.› ");
INSERT INTO fuf_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Kanko Petruusu o wi'i kadi: «Annabaaɓe *hiitinooɓe ɓen fow, gila e Samu'iila haa e hikkiiɓe e makko ɓen, hari hiitinoke fii ɗee ɲalaaɗe ɗoo. ");
INSERT INTO fuf_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ko onon woni ɓiɓɓe annabaaɓe ɓen e *ahadi ndi Allaahu on ƴettannoo baabiraaɓe men ɓen, ka o daalannoo Ibraahiima wonde: ‹Ɓeynguureeji aduna on fow barkinte sabu jurriya maa on.› ");
INSERT INTO fuf_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ko fii mon onon taho Allaahu on addirnoo oo Jiyaaɗo makko, mo o immintini e hakkunde mayɓe ɓen, fii ko barkinira on, sendugol mo kala e mon e waɗugol ko boni.» ");
INSERT INTO fuf_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Wa fewndo ko Petruusu e Yuuhanna yewtata ɗun jamaa on, *yottinooɓe sadaka ɓen e hooreejo aynooɓe *juulirde mawnde nden e *Sadduusiyaaɓe ɓen ari. ");
INSERT INTO fuf_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ko fii hari ɓe haaɓii ko ɓen woni waajaade jamaa on kon e ko ɓen woni ɓanginde kon wonde ko e Iisaa ummutal mayɓe ɓen woni. ");
INSERT INTO fuf_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ɓe fawi ɓe juuɗe. Ɓay hari niɓɓii, ɓe soki ɓe haa bimbi nden ɲande. ");
INSERT INTO fuf_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Kono buy e nanunooɓe ɗin konguɗi maɓɓe gomɗini, adadu ɓen yimɓe gomɗinɓe ko wa ɓe guluuje njowo. ");
INSERT INTO fuf_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Bimbi nden ɲande yeesooɓe Yahuudiyankeeɓe ɓen e mawɓe maɓɓe ɓen e jannooɓe fii Sariya ɓen mottondiri Yerusalaam, ");
INSERT INTO fuf_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","wondude e Hannaana, ɗun ko yottinoowo mawɗo sadaka on, e Qayaafa e Yaayaa e Iskandar, e ɓeya jeyaaɓe e gorol yottinoowo mawɗo sadaka on. ");
INSERT INTO fuf_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ɓe addi Petruusu e Yuuhanna hakkunde maɓɓe, ɓe landii ɓe, ɓe wi'i: «Hara ko mbawdi hondi maa innde honde waɗirɗon ɗun?» ");
INSERT INTO fuf_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Onsay Petruusu heewuɗo *Ruuhu Seniiɗo on wi'i ɓe: «Ko onon yo yeesooɓe jamaa e mawɓe, ");
INSERT INTO fuf_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ɓay hande meɗen landiteede fii moƴƴere nde men waɗani aaden jukkunnaajo, e noone no o ndikkiniraa, ");
INSERT INTO fuf_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","awa andee fota, jamaa *Isra'iila on fow kadi anda, ko e innde Iisaa Almasiihu on, oo jeyaaɗo Naasirata, ɗun ko on mo fempunoɗon, Alla immintini mo e hakkunde mayɓe ɓen, ko sabu on oo neɗɗo selliniraa, o darii yeeso mon ɗoo. ");
INSERT INTO fuf_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ko Iisaa on woni: ‹Hayre nde onon mahooɓe ɓen hawkunoɗon nden wontii hittunde ka soɓɓundu.› ");
INSERT INTO fuf_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ko fii kisiyee heɓortaa goɗɗo goo si wonaa Iisaa Almasiihu on, sabu hay gooto okkaaka innde goo ka ley kammu ɗoo, nde waaweten daɗirde sabu mun si wonaa nde makko nden.» ");
INSERT INTO fuf_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ɓay ɓe yi'ii pellital Petruusu e Yuuhanna ngal, ɗun ŋalɗini ɓe. Ɓe ndaari ɓe tawi ɓee ko ɓe yinkoy koy jangaa, ɓe anditiri ɓe ko ɓe wondaynoo e Iisaa kon. ");
INSERT INTO fuf_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Nde tawnoo ɲawndaaɗo on no darii takko maɓɓe, ɓe tawi alaa fus ko ɓe jaaboo. ");
INSERT INTO fuf_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ɓe yamiri yo ɓen yaltine, ɓe accana ɓe mbatirdu ndun. Onsay ɓe diisondiri hakkunde maɓɓe, ɓe wi'i: ");
INSERT INTO fuf_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","«Ko honɗun waɗeten ɓee? Ko fii no henani kala hoɗuɗo Yerusalaam wonde ɓee waɗii kaawake moƴƴo tiiɗuɗo, en waawataa-le yeddude ɗun. ");
INSERT INTO fuf_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Jooni non, fii wota ɗun lollu ɓuri nii e hakkunde jamaa on, haɗen ɓe, sattinanen ɓe wota ɓe wowlan hay gooto nden innde hande kadi.» ");
INSERT INTO fuf_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Onsay ɓe nulitani Petruusu e Yuuhanna, ɓe toŋani ɓe few waajagol maa janna e innde Iisaa. ");
INSERT INTO fuf_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Kono Petruusu e Yuuhanna jaabii ɓe, wi'i: «Hara no feewi yeeso Alla ka men ɗoftoo on, men acca Alla? ");
INSERT INTO fuf_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ɲaawanee hoore mon ɗunɗon, ko fii men waawataa ronkude wowlude ko men yi'irnoo gite amen ɗen kon e ko men nanirnoo noppi amen ɗin kon.» ");
INSERT INTO fuf_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ɓe ɓeydi ɓe sattinande fii ɗun, kono ɓay ɓe heɓaali feere no ɓe donkinira ɓe, sabu ko jamaa on fow wonnoo mawninde Alla fii kon ko waɗi ɗon, ɓe acciti ɓe. ");
INSERT INTO fuf_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Tawi on neɗɗo sellinaaɗo, mo kaawake moƴƴo on waɗaa e hoore mun, ɓurnii duuɓi cappanɗe nay. ");
INSERT INTO fuf_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Ɓay Petruusu e Yuuhanna accitaama, ɓe yaari ka ɗimmooɓe maɓɓe ɓen, ɓe fillitanii ɓen kala ko hooreeɓe yottinooɓe sadaka ɓen e mawɓe ɓen wi'i ɓe kon. ");
INSERT INTO fuf_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ɓay ɓen nanii ko ɓe wi'i kon, ɓe hawtiti, ɓe ewnii Alla, ɓe wi'i: «Ko an yo Joomiraaɗo Taguɗo leydi e kammu e baharu e kala ko woni e mun, ");
INSERT INTO fuf_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","ko an daalirnoo Ruuhu Seniiɗo on, longinɗaa oo jiyaaɗo maa, ɗun ko Daawuuda oo baabiraawo amen ɗunɗoo: ‹Ko fii honɗun leƴƴi ɗin monondiranta, e ko honɗun jamaaji ɗin joganii ɗii miijooji mehi? ");
INSERT INTO fuf_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Lamɓe aduna on no dartodi, hikkondirɓe e maɓɓe ɓen no wontidi, dartii Joomiraaɗo on e *Almasiihu makko on.› ");
INSERT INTO fuf_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","«Awa yaa an Alla, ka haqiiqa, e nder ndee saare ɗoo, oo wi'eteeɗo *Heroodu e oo wi'eteeɗo Pilaatu Pontii, ɓe wontiduno e ɓe wonaa Yahuudiyanke ɓen, wondude e Isra'iilayankeeɓe ɓen, ɓe dartii oo Kurkantooɗo ma Seniiɗo, ɗun ko Iisaa, on mo suɓiɗaa. ");
INSERT INTO fuf_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ɓe waɗiri ɗun faale maa on e bawgal maa ngal, fii timmingol kodduruyee maa on. ");
INSERT INTO fuf_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Jooni non, yaa an Joomiraaɗo, wattan yiili fii ɓee jokkuɓe men, newnanaa kadi jiyaaɓe maa ɓen feɲɲinirgol daaluyeeji maa ɗin pellital timmungal. ");
INSERT INTO fuf_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Fontu sookewo maa ngon fii no ɲawndule e maandeeji e kaawakeeji moƴƴi waɗira e innde Kurkantooɗo ma Seniiɗo on, ɗun ko Iisaa.» ");
INSERT INTO fuf_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ɓay ɓe gaynii toraade, nokkuure nde ɓe wonnoo e mun nden dimbii, ɓe fow ɓe heewi Ruuhu Seniiɗo on, ɓe woni e feɲɲinirgol daaluyee Alla on pellital. ");
INSERT INTO fuf_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Gomɗinɓe ɓen fow wonti ɓernde wootere e miijo wooto, tawi hay gooto e maɓɓe wi'ataa ko jeyi kon ko halal mun, tawi ko ɓe kafu e fow. ");
INSERT INTO fuf_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Tawi *sahaabaaɓe ɓen no seeditora bawgal tiiɗungal fii ummutal Iisaa Joomi on, moƴƴere tiiɗunde kadi woni e hoore maɓɓe ɓe fow. ");
INSERT INTO fuf_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Tawi baaso alaa hakkunde maɓɓe, ko fii kala marnooɗo ngesa maa suudu yeeyitayno ɗun, adda coggu ko yeeyi kon, ");
INSERT INTO fuf_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","watta e juuɗe sahaabaaɓe ɓen. Ɗun senditee, mo kala hendoo ko handi kon. ");
INSERT INTO fuf_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Yuusufu kadi, ɗun ko on mo sahaabaaɓe ɓen jammi Barnabaasi (ko woni firo ɗun ko «wakkilinoowo»), on ko *Lewiyankeejo mo Siipuru, ");
INSERT INTO fuf_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","o yeeyi ngesa himo marnoo, o addi mbuuɗi ɗin, o watti e juuɗe sahaabaaɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Onsay gorko goo kadi wi'eteeɗo Hanaaniiya e ɓeyngu mun Safiirata yeeyi ngesa hiɓe marnoo. ");
INSERT INTO fuf_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","E nder haldigal makko e ɓeyngu makko, o mari feccere coggu ko yeeyaa kon, o ƴetti ndeya feccere o watti e juuɗe *sahaabaaɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Onsay Petruusu wi'i mo: «Hanaaniiya, ko honno Ibuliisa naatiri ka ɓernde maa haa ka fenanaa *Ruuhu Seniiɗo on, maraa feccere coggu ngesa mban. ");
INSERT INTO fuf_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ado a yeeyude mba, wonaa an jeyunoo mba? E ɓay a yeeyii mba, wonaa an jeyunoo coggu mabba on? Ko fii honɗun non waɗanɗaa ka ɓernde maa sifa ngal kuugal? Awa hinaa yimɓe ɓen fenanɗaa, kono ko Alla.» ");
INSERT INTO fuf_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Nde Hanaaniiya nanirnoo ɗin konguɗi, o yani, o maayi. Tun kulol njanol heɓi ɓen heɗinooɓe ɗon fow. ");
INSERT INTO fuf_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Onsay sukaaɓe ɓen immii waɗi kasannge e makko, ɓe naɓi mo, ɓe surroyi. ");
INSERT INTO fuf_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ɓawto ɗun, ɓay wa saa'iiji tati feƴƴii, ɓeyngu makko ari e hoore o andaali kon ko waɗi. ");
INSERT INTO fuf_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Onsay Petruusu wi'i mo kanko debbo on: «Yeeto lan si tawii ko nguu coggu ɗoo yeeyuɗon ngesa mban.» Debbo on jaabii mo, wi'i: «Eyyo, ko nguu coggu ɗoo.» ");
INSERT INTO fuf_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Petruusu wi'i mo fahin: «Ko fii honɗun haldanɗon ndarndagol Ruuhu Joomiraaɗo on? Awa e hino surroyɓe moodi maa ɓen ka dambugal ɗaa. Ɓe naɓete an kadi.» ");
INSERT INTO fuf_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ɗon kisan o yani e ley koyɗe Petruusu, o maayi. Wa ko sukaaɓe ɓen naatata, ɓe tawi kanko debbo on kadi o maayii. Ɓe naɓi mo, ɓe surroyi takko moodi makko. ");
INSERT INTO fuf_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Kulol moolanaangol kadi heɓi *moftal ngal fow e kala nanunooɓe fii ɗun. ");
INSERT INTO fuf_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Tawi sahaabaaɓe ɓen no waɗude maandeeji e kaawakeeji moƴƴi ɗuuɗuɗi hakkunde jamaa on. Hari kamɓe gomɗinɓe ɓen fow hiɓe mottondiri e nder nanondiral maɓɓe ka *Tungarru Sulaymaana. ");
INSERT INTO fuf_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Tawi jamaa on no mantude ɓe fota, kono hay gooto e maɓɓe suusataano ɓe ɓadaade. ");
INSERT INTO fuf_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Tawi ɲande woo wonɓe gomɗinde Joomi on no ɓeydaade fota, hara ko worɓe e rewɓe. ");
INSERT INTO fuf_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Awa kadi nawnuɓe no addetenoo ka sera ballaŋe, wallinee e buutuuji maa e gate, fii nde Petruusu no feƴƴa, hay si ko yo ɗowdi makko ndin hawru e goɗɗo e maɓɓe. ");
INSERT INTO fuf_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Lappi lappi yimɓe no wuggotonoo iwa e ɗeya ca'e heeduɗe e Yerusalaam, ɓe addora nawnuɓe ɓen e ɓe jinna tampini, ɓen fow sellinaa. ");
INSERT INTO fuf_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Onsay *yottinoowo mawɗo sadaka on e kala wondunooɓe e makko, ɗun ko ndee fedde ɓee *Sadduusiyaaɓe, ɓe hawtodi e nawliigu timmungu. ");
INSERT INTO fuf_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ɓe fawi sahaabaaɓe ɓen juuɗe, ɓe soki ɓe. ");
INSERT INTO fuf_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Kono e nder on jemma, malaa'ikaajo Joomiraaɗo on udditi baafe kaso ngon, o yaltini ɓe, o wi'i ɓe: ");
INSERT INTO fuf_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«Yahee wonoyon ka *juulirde mawnde, feɲɲinanon jamaa on kala konguɗi fii ɗan ngurndan kesan.» ");
INSERT INTO fuf_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ɓay ɓe nanii ɗun, no weetirnoo, ɓe naatoyi ka juulirde mawnde ɓe woni e waajagol. Onsay yottinoowo mawɗo sadaka on e wondiɓɓe mun ɓen hewti, ɓe nodditi dental fewjooɓe ɓen, e dental mawɓe *Banii-Isra'iila'en ɓen fow, ɓe immini ko yahana sahaabaaɓe ɓen ka kaso. ");
INSERT INTO fuf_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ɓay ɓen suufaaɓe hewtii, laatii ɓe tawaali ɓeya ka kaso. Ɓe yiltitii ɓe hunitii ɓe, ɓe wi'i: ");
INSERT INTO fuf_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","«Men yahuno, men tawi kaso ngon no sokiraa no holnori, ayninaaɓe dame ɗen kadi mo bee e ka woni. Kono ɓay men udditii, men tawaali hay gooto nder ton!» ");
INSERT INTO fuf_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Nde hooreejo aynooɓe juulirde nden e hooreeɓe yottinooɓe sadaka ɓen nanirnoo ɗin konguɗi, ɓe jiɓii fii ɓen e ko honno fii ɗun sakkitoroyta. ");
INSERT INTO fuf_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Tun goɗɗo ari, wi'i ɓe: «E hino yimɓe ɓe sokunoɗon ka kaso ɓen ka waajotoo jamaa on ka juulirde mawnde too!» ");
INSERT INTO fuf_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Onsay hooreejo aynooɓe ɓen e suufaaɓe mun ɓen yahani ɓe, addi e ɓaawo doolugol ɓe, sabu hiɓe hulunoo wota jamaa on fiɗir ɓe kaaƴe. ");
INSERT INTO fuf_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ɓay ɓe addii ɓe, ɓe darni ɓe yeeso dental fewjooɓe ɓen. Onsay yottinoowo mawɗo sadaka on landori ɓe nii, wi'i: ");
INSERT INTO fuf_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","«Hiɗon andi hari men haɗiino on few waajorgol ndee innde! Jooni non e hino on lannii lollinde waajuuji mon ɗin Yerusalaam. E hoore ɗun hiɗon faalaa fawude kii wonkii oo neɗɗo e hoore amen!» ");
INSERT INTO fuf_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Onsay Petruusu e sahaabaaɓe ɓen jaabii ɓe, wi'i: «Ko Alla ɗoftetee edii yimɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","On Alla baabiraaɓe men ɓen immintinii Iisaa, on mo warirɗon fempugol e leggal, wenga. ");
INSERT INTO fuf_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Allaahu on ɓantirii mo ka sengo mun ɲaamo, waɗii mo Ardotooɗo e Dandoowo fii okkugol *Isra'iila'en feere no ɓe tuubira e no ɓe yaaforanee junuubaaji. ");
INSERT INTO fuf_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Menen e Ruuhu Seniiɗo mo Allaahu on yeɗi ɓen ɗoftiiɓe mo, ko men seedee ɗun.» ");
INSERT INTO fuf_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ɓay ɓen nanii ko ɓen sahaabaaɓe wi'i kon, ɓe hiɓɓii haa ɓe faalaa ɓe warude. ");
INSERT INTO fuf_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Kono Fariisiyaajo jannoowo fii Sariya on, wi'eteeɗo Gamaliyiila, mo jamaa on fow hoolii, hawtii ka nder dental, yamiri yo ɓen sahaabaaɓe yaltine ton taho. ");
INSERT INTO fuf_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Onsay o wi'i: «Ko onon yo Isra'iilayankeeɓe, wattanee yiila e ko miijiɗon waɗugol ɓee kon. ");
INSERT INTO fuf_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ko fii hiɗon andi neeɓaali ko Teyodaasu, waɗitiiɗo ko tedduɗo, immii, mo wa yimɓe teemeɗɗe nayo iwtirnoo ɓaawo mun. Kanko Teyodaasu o waraa, ɗoftinooɓe mo ɓen fow lancaa. E hoore ɗun hay huunde nantaaka. ");
INSERT INTO fuf_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ɓay feƴƴii e on, wi'eteeɗo Yudaasi, jeyaaɗo Jaliilu, immii ka fewndo windito. O ɗaɓɓi yimɓe ko iwtira ɓaawo makko, on kadi mulaa, ɗoftinooɓe mo ɓen fow kadi saakitaa. ");
INSERT INTO fuf_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Jooni min mi wi'ay on, tertee ɓee yimɓe, acciton ɓe, ɓe yaha. Si tawii ɗee eɓɓooje maa ɗee kuuɗe ko e neɗɗanke'en iwi, ɗe bonoyay. ");
INSERT INTO fuf_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Si tawii non ko e Alla iwri, haray on waawataa ɗe bonnude. Reenee fii wota on wonu haɓidooɓe e Alla!» ");
INSERT INTO fuf_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ɓe fow ɓe iwtiri e ɓaawo ko o wi'i kon. Onsay ɓe nodditi sahaabaaɓe ɓen, ɓe focci ɓe, ɓe haɗi ɓe wowlugol innde Iisaa, ɓe acciti ɓe. ");
INSERT INTO fuf_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Kamɓe kadi ɓe yalti ka hakkunde dental e hoore hiɓe weltii ko tawi kon hiɓe foddi e aybineede fii innde Iisaa nden. ");
INSERT INTO fuf_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Tawi ɓe haaɓataano waajagol janna ka juulirde mawnde e ka cuuɗi fii Kibaaru Moƴƴo Iisaa Almasiihu on. ");
INSERT INTO fuf_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Nde tawnoo taalibaaɓe ɓen no ɓeydaade tun e ɗen balɗe ɗon, Yahuudiyankeeɓe wowlooɓe haala Gereeki wonɓe hakkunde maɓɓe ɓen woni e ŋurŋurtugol ɓeya Yahuudiyankeeɓe, sabu ko ɓe welsindii waɗangol keynguuɓe maɓɓe ɓen ko ɓen handi ɲande woo kon. ");
INSERT INTO fuf_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Onsay *sahaabaaɓe ɓen sappoo e ɗiɗo nodditi taalibaaɓe ɓen no ɓe fotata fodde, ɓe wi'i ɓen: «Haanaa ka acciten daaluyee Alla on fii sendugol ɲaameteeji tun. ");
INSERT INTO fuf_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ko ɗun waɗi, yo musiɓɓe, suɓee hakkunde mon yimɓe njeeɗiɗo, hara ko holniiɓe, heewuɓe Ruuhu Allaahu on e faamu, ko halfinen ɗee golle. ");
INSERT INTO fuf_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ɗun, menen men duumoto e toragol e kurkanagol daaluyee on.» ");
INSERT INTO fuf_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ɗin konguɗi weli ɓe no ɓe fotata fodde. Onsay ɓe suɓii oo wi'eteeɗo Astefaana, on ko neɗɗo heewuɗo gomɗinal e *Ruuhu Seniiɗo on, e Filiipu e Porokoor e Nikanuura e Timuuna e Parmeena e Nikolaasi mo ka wi'etee ɗon Antiyoosi-Sirii, on ko naatunooɗo e diina Yahuudiyanke. ");
INSERT INTO fuf_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Onsay ɓe weeɓitani ɓe sahaabaaɓe ɓen, ɓen *fawi juuɗe mun ɗen e hoore maɓɓe, du'anii ɓe. ");
INSERT INTO fuf_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Tawi daaluyee Alla on no layude tun, adadu taalibaaɓe ɓen no ɓeydaade fota e nder Yerusalaam. E hoore ɗun jamaa *yottinooɓe sadaka ɗuuɗuɗo no ɗoftaade gomɗinal ngal. ");
INSERT INTO fuf_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Tawi Astefaana, on heewuɗo sulfu e bawɗe, no waɗaynoo kaawakeeji moƴƴi mawɗi e maandeeji e hakkunde jamaa on. ");
INSERT INTO fuf_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Onsay woɓɓe ɓe Sirenii e ɓe Aleksandiri e ɓee ɓe Silisii e ɓe *Aazii, wonnooɓe ka juulirde wi'eteende Juulirde Rinɗinaaɓe, ɓe woni e yeddondirgol e Astefaana. ");
INSERT INTO fuf_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Kono tawi ɓe alaa kutu dartagol faamu makko ngun e konguɗi ɗi Ruuhu Allaahu on longinaynoo mo ɗin. ");
INSERT INTO fuf_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Onsay ɓe yeeni woɓɓe yo wi'u: «Men nanirii mo konguɗi hoynuɗi Muusaa e Alla!» ");
INSERT INTO fuf_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ko nii ɓe ƴuuniri jamaa on e mawɓe ɓen e jannooɓe fii Sariya on, ɓen ari nangiri Astefaana doole, ɓe naɓi mo ka dental fewjooɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Tawi hiɓe eɓɓi woɓɓe ko seeditoo fenaande, ɓen wi'i: «Oo neɗɗo no jokki aybingol nokkuure hormorde nden e Sariya on. ");
INSERT INTO fuf_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ko fii men nanii himo wi'a wonde, Iisaa, oo jeyaaɗo Naasirata, lancay ndee nokkuure, o wayla kadi naamuuji ɗi Muusaa waɗani en ɗin.» ");
INSERT INTO fuf_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Onsay ɓen wonnooɓe ka dental ɗon ndaari mo kanko Astefaana, tawi yeeso makko ngon wa'itii wa yeeso malaa'ikaajo. ");
INSERT INTO fuf_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Onsay *yottinoowo mawɗo sadaka on landii mo, wi'i: «Hara ɗun ko non woniri?» ");
INSERT INTO fuf_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Astefaana jaabii, wi'i: «Ko onon yo musiɓɓe an e baabiraaɓe an, heɗitee! Alla Jom Mangural on feeɲanno Ibraahiima ben men fewndo ko o wonnoo Mesopotamii, ɗun ko ado o hoɗoyde Haraana. ");
INSERT INTO fuf_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","O daalanno mo, o wi'i: «Yaltu ka leydi maa e ka bolondaa maa, yahaa haa e leydi ndi mi holloyte.› ");
INSERT INTO fuf_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Kanko Astefaana o wi'i kadi: «Onsay o yalti e ndin leydi ɓen Kaldiyankeeɓe, o hoɗoyi Haraana. Ɓay ben makko faatike, Allaahu on addi mo kanko Ibraahiima haa e ndii leydi ndi wonɗon e mun jooni. ");
INSERT INTO fuf_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","E hoore ɗun o yeɗaali mo ndondi woo e ndii leydi, hay non yeru ka o tippa koyngal. Kono o fodi mo okkugol mo ndi, ndi wona halal makko kanko e jurriya makko aroyoowo ɓaawo makko on. Wa fewndo ko Alla daalani mo ɗun, hari o maraa ɓiɗɗo. ");
INSERT INTO fuf_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Allaahu on daalani mo kadi wondema jurriya makko on aroyay nde daakoyii e leydi jananiri, wonɓe e ndin leydi kurkoya ɓe, tampina e nder duuɓi teemeɗɗe nay. ");
INSERT INTO fuf_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Kono o daalani mo kadi, o wi'i: ‹Ko min ɲaawata on jamaa kurkoyɗo ɓe. Ɓawto ɗun, ɓe yaltoya ton, ɓe rewoyammi e ndee nokkuure ɗoo.› ");
INSERT INTO fuf_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","E hoore ɗun Allaahu on ƴettodi e makko *ahadi ndi maande mun woni *sunninegol. Ko e nder ɗun Ibraahiima daɲi Issaaqa, o sunnini mo ka ɲalaande jeetataɓere. Issaaqa waɗiri non Yaaquuba, Yaaquuba kadi waɗiri non e maamiraaɓe men ɓen, ɗun ko ɓiɓɓe makko ɓen sappoo e ɗiɗo. ");
INSERT INTO fuf_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","«Ɓen maamiraaɓe men nawli Yuusufu, ɓe yeeyi mo fii naɓegol *Misira. ");
INSERT INTO fuf_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Kono tawi Alla no wondi e makko, o sorti mo e nder ɗin tampereeji makko fow, Alla okki mo sulfu e faamu yeeso Fir'awna. On lanɗo Misira waɗi mo ardotooɗo leydi Misira ndin, e ka galle makko kanko lanɗo on. ");
INSERT INTO fuf_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Ɓawto ɗun, heege waɗi e nder leydi Misira ndin fow haa hewtoyi *Kanaana, tampere nden tiiɗi, tawi ɓen maamiraaɓe men alaa heɓude ko ɲaama. ");
INSERT INTO fuf_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Yaaquuba nani wonde ɲaametee no woodi Misira. Ka laawol aranol, o immini fayɓe makko ɓen, ɗun ko maamiraaɓe men ɓen. ");
INSERT INTO fuf_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ka laawol ɗimmol, Yuusufu andintinii ben-gootooɓe mun ɓen, ko onsay Fir'awna andi iwdi Yuusufu ndin. ");
INSERT INTO fuf_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Onsay Yuusufu immini ko yahana ben makko Yaaquuba e ɓeynguure mun nden fow, tawi ɓen no yonunoo cappanɗe njeeɗiɗo e njowo. ");
INSERT INTO fuf_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Kanko Yaaquuba o yahi Misira. Ko ɗon kanko e ɓen maamiraaɓe men ɓe faatii. ");
INSERT INTO fuf_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ɓe naɓaa Sakiima, ɓe wattinoyaa ka berɗe ɗe Ibraahiima ittunoo kaalisi soodi Sakiima ɗon e juuɗe ɓiɓɓe Hamuura ɓen. ");
INSERT INTO fuf_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","«Nde tawnoo saa'i on ɓadike ka Allaahu on hunna ko o fodunoo Ibraahiima kon, tawi jamaa makko wonɗo Misira on, no ɓurtude tun ɗuuɗude, ");
INSERT INTO fuf_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","haa nde goɗɗo mo andaano Yuusufu laamii Misira. ");
INSERT INTO fuf_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","On lanɗo ɗayni leɲol men ngol, o tampini maamiraaɓe men ɓen haa o hawkini ɓe ɓiɓɓe maɓɓe ɓen fii wota ɓen wuuru. ");
INSERT INTO fuf_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ko fewndo on saa'i ɗon Muusaa jibinaa, tawi himo labaa yeeso Alla. O muyninaa lebbi tati ka galle ben makko. ");
INSERT INTO fuf_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ɓay o accaama ka yaasi, jiwo Fir'awna on hocci mo, ne'iri mo wa ɓiɗɗo mun. ");
INSERT INTO fuf_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Onsay Muusaa jannaa gande Misirayankooɓe ɓen fow, o woni tiiɗa-konguɗi e kuuɗe. ");
INSERT INTO fuf_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","«Ɓay wonii o timminii duuɓi cappanɗe nay, o miijii e ɓernde makko fii ƴewtoyagol musiɓɓe makko ɓen, ɗun ko *Banii-Isra'iila'en. ");
INSERT INTO fuf_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","O yi'i goɗɗo e ɓen musiɓɓe makko no tampinee. O ari dandugol mo, o yottanii mo, o wari Misirayankoojo on. ");
INSERT INTO fuf_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Tawi himo sikka musiɓɓe makko ɓen faamay wonde Allaahu on yeɗii ɓe kisiyee tippude e sookeeje makko ɗen, kono kamɓe ɓe faamaali ɗun. ");
INSERT INTO fuf_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Bimbi nden ɲande, o yaltiti e hakkunde woɓɓe e ɓen musiɓɓe makko ka piirata, o woni e moƴƴintingol hakkunde maɓɓe, o wi'i ɓe: ‹Ko onon woni musiɓɓe, ko fii honɗun mo kala e mon no tampina oya?› ");
INSERT INTO fuf_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","«Kono wonnooɗo tampinde ɲokondo mun on wiggii Muusaa, wi'i: ‹Ko hombo waɗu-maa lanɗo e ɲaawoowo e hoore amen? ");
INSERT INTO fuf_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Kaa a faalaa lan warude, wano warirɗaa Misirayankoojo on non hanki?› ");
INSERT INTO fuf_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Sabu ngol kongol, Muusaa dogi, yahi daakoyii e ndii leydi wi'eteendi Midiyaani, o daɲi ɗon ɓiɓɓe ɗiɗo. ");
INSERT INTO fuf_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","«Duuɓi cappanɗe nay ɓawto ɗun, malaa'ikaajo feeɲani mo e loyngol yiite ka pitahun woni sumude ka wulaa fello *Sinaayi. ");
INSERT INTO fuf_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ɓay o yi'ii ɗun, kanko Muusaa o ŋalɗi fii kon ko o yi'i. Nde tawnoo himo ɓadaade fii tenƴingol, o nani Joomiraaɗo on no wi'a: ");
INSERT INTO fuf_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‹Ko min woni Alla Joomiraaɗo baabiraaɓe maa ɓen, Alla Ibraahiima e Issaaqa e Yaaquuba.› Onsay Muusaa diwni, tawi suusataa ndaarirde ton. ");
INSERT INTO fuf_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","«Joomiraaɗo on daalani mo kadi, wi'i: ‹Solu paɗe maa ɗen, ko fii ndee nokkuure nde wonɗaa e mun ko nokkuure hormorde.› ");
INSERT INTO fuf_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","O daalani mo kadi, o wi'i: ‹Mi yi'ii tampere jamaa maa wonɗo Misira on, mi nanii woytaango maɓɓe ngon, mi jippike fii jattingol ɓe.› O daalani mo kanko Muusaa, o wi'i: ‹Miɗo imminde ma Misira.› ");
INSERT INTO fuf_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Kanko Astefaana o wi'i kadi: «Ko Muusaa on mo ɓe hayfinnoo ɓe wi'i: ‹ko hombo waɗu-maa lanɗo maa ɲaawoowo?›, ko on Alla immini tippude e ballal malaa'ikaajo feeɲannooɗo mo ka pitahun on fii wonugol lanɗo e sottoowo. ");
INSERT INTO fuf_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ko on yaltini ɓe e hoore waɗugol kaawakeeji e maandeeji e nder leydi Misira, haa naɓani ka *Baharu Boɗeejo e ka wulaa e nder duuɓi cappanɗe nay. ");
INSERT INTO fuf_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ko Muusaa wi'unoo Banii-Isra'iila'en wonde: ‹Alla yaltinanoyay on annabaajo wa'uɗo wa an min e hakkunde musiɓɓe mon ɓen.› ");
INSERT INTO fuf_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Fewndo ko jamaa on mottondirnoo ka wulaa, ko kanko wondunoo e malaa'ikaajo yewtaynooɗo mo on ka fello Sinaayi, wondude kadi e maamiraaɓe men ɓen. Ko kanko kadi Alla yeɗi daaluyeeji ngurndan ɗin fii hewtingol en ɗi. ");
INSERT INTO fuf_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Kono tawi maamiraaɓe men ɓen faalaaka mo ɗoftaade, ɓe bugitii mo, tawi ɓerɗe maɓɓe ko Misira fewti. ");
INSERT INTO fuf_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ɓe wi'i *Haaruuna: ‹Moƴƴinan men allaaji ko ardoo men. Ko fii men andaa ko heɓi Muusaa oo yaltinɗo men leydi Misira.› ");
INSERT INTO fuf_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","E nder ɗen balɗe ɗon ɓe moƴƴini nandolla ga'un nagge, ɓe addani ndun nandollaaru sadaka, ɓe weltori kon ko ɓe moƴƴiniri juuɗe maɓɓe. ");
INSERT INTO fuf_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Onsay Allaahu on hucci ɓe, o accidi ɓe e rewugol koode ɗen ka kammu, wano windori non ka deftere annabaaɓe ɓen, ka o daali ɗon: ‹Ko onon yo bolondaa *Isra'iila, fewndo hirsaynoɗon waɗon sadakaaji ka wulaa e nder duuɓi cappanɗe nay, hara ko min waɗanaynoɗon ɗun? ");
INSERT INTO fuf_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Kono ɓay on rewii oo allaajo wi'eteeɗo Muluuka, on rewii kadi ndee hoodere oo allaajo mon wi'eteeɗo Ronfa, ɗin nandollaaji ɗi moƴƴinɗon fii ko rewon, min kadi mi bugoto on toonin *Baabiila.› ");
INSERT INTO fuf_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","«Tawi maamiraaɓe men ɓen no wondi e *rewirdu ndu seeditoore nden woni e mun ndun ka wulaa ton, wano yewtidaynooɗo e Muusaa on yamirirnoo mo yo ndu moƴƴinire non, e sifa no o hollirnoo mo non kadi. ");
INSERT INTO fuf_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ɓay maamiraaɓe men hikkiiɓe e ɓenɗon ɓen ƴettitii ndu, ɓe yaadi e mayru, tippude e yamiroore Yaasuwa, e ndii leydi ɗii leƴƴi ɗi Alla bugitinoo yeeso maɓɓe, ndu lutti ɗon haa hewti e Daawuuda, ");
INSERT INTO fuf_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","on mo Allaahu on yeɗi sulfu, o torii ka o darnana Alla Yaaquuba on suudu, ");
INSERT INTO fuf_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","kono ko Sulaymaana wonnoo ko darnani mo suudu. ");
INSERT INTO fuf_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","E hin-le Jom Ɓural on hoɗataa e ko goɗɗo mahiri juuɗe, wano annabaajo on holliri non wonde, Alla daali: ");
INSERT INTO fuf_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‹Ko kammu ngun woni jullere laamu an nden, leydi ndin wonanimmi ka mi tippa.› Joomiraaɗo on daaluno: ‹Ko suudu hondu darnanton mi, maa ko nokkuure honde wonantammi fowtorde? ");
INSERT INTO fuf_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","E hara hinaa bawgal an mi warri ɗun fow?› ");
INSERT INTO fuf_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","«Ko onon yo yimɓe yoora-hooreeɓe, ɓe ɓerɗe mun e ɓe noppi mun uddi, onon non ko on dartotooɓe soono woo *Ruuhu Seniiɗo on, wano baabiraaɓe mon ɓen dartoraynoo non! ");
INSERT INTO fuf_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","E hara, ko hombo e annabaaɓe ɓen wonnoo mo baabiraaɓe mon ɓen ɓittinaano? Hay ɓe warno ɓen adinooɓe *hiitaade fii arugol Feewuɗo on, on mo janfiɗon warɗon, ");
INSERT INTO fuf_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","ɗun ko onon ɓe huutoraali Sariya mo malaa'ikaaɓe ɓen hewtinnoo on on!» ");
INSERT INTO fuf_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ɓay ɓen nanii ɗun, ɓerɗe maɓɓe ɗen sokii, ɓe ŋatindiri ɲiiƴe maɓɓe ɗen, monee makko kanko Astefaana. ");
INSERT INTO fuf_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Kono kanko Astefaana o ɓurti heewude Ruuhu Seniiɗo on, o tiggitii ka kammu, o yi'i annoora Alla on, o yi'i kadi Iisaa no darii ka sengo ɲaamo Alla. ");
INSERT INTO fuf_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Kanko Astefaana, o wi'i: «Mi yi'ii kammu ngun no udditii. E hino ka *Ɓii-Aaden on darii ka sengo ɲaamo Alla!» ");
INSERT INTO fuf_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Onsay ɓe fow ɓe uddi noppi, ɓe sonki e makko, ɓe wubbani mo. ");
INSERT INTO fuf_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ɓe raɗii mo haa ka ɓaawo saare, ɓe wariri mo kaaƴe. Seedeeɓe ɓen acci conci mun ɗin e ley koyɗe suka no wi'ee Saawulu. ");
INSERT INTO fuf_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Wa fewndo ko ɓe fiɗata mo kanko Astefaana kaaƴe, tawi himo tororde nii, wi'a: «Ko an yo Joomi an Iisaa, jaɓɓo wonkii an kin!» ");
INSERT INTO fuf_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Onsay o jiccii kadi, o ewnii ko tiiɗi, o wi'i: «Joomi, wota a faw oo junuubu e hoore ɓee!» No o gaynirnoo wowlude ɗun, o timmi. ");
INSERT INTO fuf_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Tawi Saawulu no wonani fii mayde Astefaana nden. Nden ɲande jokkere mawnde heɓi dental gomɗinɓe wongal ngal Yerusalaam haa ɓe fow ɓe saakitii ɓe yaari e ngal diiwal Yahuuda e Samariiya, si wonaa *sahaabaaɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Onsay yimɓe ɓe dewal ɓen surri Astefaana, ɓe fesi mo kadi fota. ");
INSERT INTO fuf_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Tawi Saawulu kaɲun ko lancaynooɗo *moftal gomɗinɓe ɓen, ko fii himo naataynoo e cuuɗi fii wippitugol gomɗinɓe ɓen, worɓe e rewɓe, o feroo ka kaso. ");
INSERT INTO fuf_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ko ɓen saakitanooɓe yahaynoo nokkeeli fow waajoo fii Kibaaru Moƴƴo on. ");
INSERT INTO fuf_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filiipu kadi yahi e saare jeyaande e diiwal *Samariiya, o waajii ɗon fii *Almasiihu on. ");
INSERT INTO fuf_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ɓay jamaa on nanii ko Filiipu yewtata kon, ɓe yi'ii kadi maandeeji ɗi o woni waɗude ɗin, ɓe haɓɓitii e konguɗi ɗi o woni yewtude ɗin. ");
INSERT INTO fuf_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Sabu tawde jinnaaji no yaltaynoo e yimɓe ɗuuɗuɓe ɓe ɗi wonnoo e mun, e hoore hiɗi haaca ko tiiɗi, awa kadi maaya-ɓanduuɓe buy e boofooɓe sellinaama. ");
INSERT INTO fuf_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Onsay welo-welo moolanaango waɗi e nden saare. ");
INSERT INTO fuf_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Kono tawi ado ɗun, gorko wi'eteeɗo Sim'uunu no e nden saare, waɗaynooɗo mbilankaaku ŋalɗina jamaa Samariiya on, waɗitiiɗo ko tedduɗo. ");
INSERT INTO fuf_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Hari ɓe fow, gila e tosooko on haa e ɓurɗo mawnude on, hiɓe haɓɓii e makko, hiɓe wi'a: «Oo ko bawgal Alla wi'eteengal Mawngal ngal!» ");
INSERT INTO fuf_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Tawi hiɓe haɓɓinoo e makko sabu tawde gila neeɓii himo ŋalɗiniraynoo ɓe mbilankaakuuji makko. ");
INSERT INTO fuf_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Kono ɓay ɓe hoolike Filiipu on feɲɲinanɗo ɓe innde Iisaa Almasiihu on e Kibaaru Moƴƴo fii *laamu Alla ngun, onsay worɓe e rewɓe *lootaa maande kisiyee. ");
INSERT INTO fuf_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Sim'uunu kadi gomɗini. Ɓay o lootaama maande kisiyee, tawi o seedataa e Filiipu. O watti yi'ude maandeeji mawɗi e kaawakeeji moƴƴi ka waɗata, o ŋalɗi fii ɗun. ");
INSERT INTO fuf_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Nde ɓee sahaabaaɓe wonɓe Yerusalaam nanirnoo wonde hoɗuɓe Samariiya ɓen jaɓii daaluyee Alla on, ɓe imminani ɓe Petruusu e Yuuhanna. ");
INSERT INTO fuf_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ɓen ari ka maɓɓe, ɓe toranii ɓe fii yo ɓe heɓu *Ruuhu Seniiɗo on. ");
INSERT INTO fuf_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Ko fii hari Ruuhu Allaahu on jippaaki e hoore hay gooto e maɓɓe taho, hari ko maande kisiyee tun ɓe lootaa e innde Iisaa Joomi on. ");
INSERT INTO fuf_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Onsay Petruusu e Yuuhanna *fawi juuɗe mun ɗen e hoore maɓɓe, ɓen heɓi Ruuhu Seniiɗo on. ");
INSERT INTO fuf_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Ɓay Sim'uunu ndaarii tawii ko nde sahaabaaɓe ɓen fawunoo juuɗe mun ɗen e hoore maɓɓe si ɓe okkaa Ruuhu Allaahu on, onsay o addani ɓe mbuuɗi, o wi'i ɓe: ");
INSERT INTO fuf_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","«Yeɗee lan min kadi ngal bawgal, fii yo tawu kala mo mi fawi juuɗe an ɗen e hoore mun heɓay Ruuhu Seniiɗo on!» ");
INSERT INTO fuf_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Kono Petruusu wi'i mo: «Yo kaalisiiji maa ɗin halkodu e maa, ɓay hiɗa sikka dokkal Alla ngal ko kaalisi heɓorta! ");
INSERT INTO fuf_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ko fii a alaa geɓal, a alaa ndondi e nder ɗun, ɓay ɓernde maa nden laaɓaa yeeso Alla. ");
INSERT INTO fuf_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Tuubu fii ɗii miijooji bonɗi wonɗi ka ɓernde maa, toroɗaa Joomiraaɗo on no ɗi yaaforee si no gasa. ");
INSERT INTO fuf_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ko fii mi yi'ii hiɗa tumbii e nder hahhannde, hiɗa humondiri e angal peewal.» ");
INSERT INTO fuf_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Onsay Sim'uunu jaabii, wi'i: «Onon tigi toranee lan Joomiraaɗo on fii kon ko wi'uɗon wota hewtan.» ");
INSERT INTO fuf_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ɓay ɓen ɗiɗo ɓe sahaabaaɓe ɓen imminnoo gaynii feɲɲinde daaluyee Joomiraaɗo on e seeditanagol mo, ɓe yiltitii Yerusalaam. E nder yiltitagol maɓɓe ton, ɓe waajii fii Kibaaru Moƴƴo on e nder koɗooli Samariyankeeɓe ɗuuɗuɗi. ");
INSERT INTO fuf_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Malaa'ikaajo Joomiraaɗo on feeɲani Filiipu, wi'i mo: «Immo jokkaa laawol iwungol Yerusalaam yaari Gaaza, ɗun ko ngol ka sengo ley, yaarungol ngol ka wulaa.» ");
INSERT INTO fuf_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Onsay o immii o yahi, o haccii gorko *nuunaaɗo mo Ecopii toowa ndarndeejo e nder laamateeri ndi debbo wi'eteeɗo Kandaas laamii e mun Ecopii. Tawi ko on gorko halfinaa ngaluuji on debbo fow, tawi on no arnoo Yerusalaam fii rewugol Alla. ");
INSERT INTO fuf_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Ko on yiltitotoo Ecopii, tawi himo jooɗii e hoore *giri-giriwal makko ngal pucci pooɗata, himo jangora deftere annabi Isaaya nden. ");
INSERT INTO fuf_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Onsay Ruuhu Allaahu on yamiri Filiipu, wi'i: «Wuggo, hewtitoɗaa oo mo giri-giriwal.» ");
INSERT INTO fuf_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Onsay Filiipu dogi. Ɓay o ɓadike on mo Ecopii, o nani on no janga deftere annabi Isaaya nden. O landii mo, o wi'i: «Hara hiɗa faamude koo ko wonɗaa jangude?» ");
INSERT INTO fuf_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","On gorko jaabii, wi'i: «Ko honno mi faamirta si goɗɗo sifanaaki lan?» Onsay o noddi Filiipu yo o ƴawu, o jooɗoo takko makko. ");
INSERT INTO fuf_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Tawi ko oo aaya ɗoo o wonnoo jangude: «Himo ɗowiraa wa baalii hirsoyteengii, hara o udditaali hunduko, wa baalun mbobiɗankun taƴoowo kun leeɓi. ");
INSERT INTO fuf_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","E nder ko o hayfinaa kon, ɓe fanni mo goonga. Hara non ko hombo fillitotoo fii jamaanu makko ngun? Ko fii ngurndan makko ɗan taƴaama ka hoore leydi.» ");
INSERT INTO fuf_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ɓay kanko nuunaaɗo on o gaynii jangude ɗun, onsay o wi'i Filiipu: «Mi torike ma, andinan ko hombo oo annabaajo wowli fii mun, si ko kanko tigi maa si ko goɗɗo goo?» ");
INSERT INTO fuf_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Onsay Filiipu ƴetti haala kan, o fuɗɗorani mo on aaya mo o jangi, o feɲɲinani mo Kibaaru Moƴƴo Iisaa on. ");
INSERT INTO fuf_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","37","E nder yaadu maɓɓe ndun, ɓe yi'oyi ka ndiyan woni. Onsay nuunaaɗo on wi'i: «E hino ndiyan, ko honɗun haɗatammi *looteede maande kisiyee?» ");
INSERT INTO fuf_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Onsay on nuunaaɗo yamiri yo giri-giriwal ngal darne, o ukkodi e Filiipu ka ndiyan, on looti mo ɗon maande kisiyee. ");
INSERT INTO fuf_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ɓay ɓe ƴawii ka ndiyan, Ruuhu Joomiraaɗo on jilii Filiipu, nuunaaɗo on yiitaali mo hande kadi. O jokkiti laawol makko e hoore himo weltii. ");
INSERT INTO fuf_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filiipu kaɲun taw tun no Asduuda. Gila ɗon o waajii fii Kibaaru Moƴƴo on e ca'e ɗe o rewi e mun ɗen fow haa o hewti Seezariiya. ");
INSERT INTO fuf_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Kono tawi Saawulu kaɲun no waɗi ka wonkii mun kambirangol taalibaaɓe Joomi on mayde. Kanko Saawulu o yahi ka *yottinoowo mawɗo sadaka on, ");
INSERT INTO fuf_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","o wi'i on yo o windu ɓataake haa e ɗee juulirɗe Yahuudiyankeeɓe wonɗe Damaasi, fii no o andira si tawii no woodi ton worɓe maa rewɓe jokkuɓe laawol Iisaa ngol, o yaha o haɓɓoya ɓe, o adda Yerusalaam. ");
INSERT INTO fuf_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ɓawto ɗun, ɓay o yahii haa o ɓadike Damaasi, tun nde wootere ndaygu iwri ka kammu ari, hundi mo. ");
INSERT INTO fuf_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","O yani kisan ka leydi, o nani hawa no wi'a mo: «Saawulu, Saawulu, ko fii honɗun wonɗaa mi cukkanaade?» ");
INSERT INTO fuf_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","On jaabii, o wi'i: «Ko an hombo nii, yaa an Joomi an?» Onsay kanko Joomi on o jaabii mo, o wi'i: «Ko min woni Iisaa on mo wonɗaa cukkaade. ");
INSERT INTO fuf_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Immo naataa e ndee saare ɗoo, ɓen yeetoto ma ko haanuɗaa waɗude.» ");
INSERT INTO fuf_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Tawi ɓen ɓe o yaadaynoo no darii mbobiɗi hakkee kulol. Hiɓe nanaynoo kadi kan hawa, kono ɓe alaa yi'ude hay gooto. ");
INSERT INTO fuf_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Onsay Saawulu immii ka leydi. Fii kala gite makko ɗen no udditinoo, kono tawi o alaano yi'ude hay huunde. Ɓe ɗowiri mo juuɗe makko ɗen haa Damaasi. ");
INSERT INTO fuf_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","O woniri non balɗe tati o yi'aali, e hoore ɗun o ɲaamaa, o yaraa. ");
INSERT INTO fuf_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Kono tawi taalibaajo no Damaasi ɗon wi'eteeɗo Hanaaniiya. Joomi on feɲɲinani mo, wi'i: «Hanaaniiya!» O jaabii: «Naamu, yaa an Joomi!» ");
INSERT INTO fuf_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Kanko Joomi on o wi'i mo: «Immo yahaa e ngal ɗatal wi'eteengal Feewungal, landoɗaa fii oo wi'eteeɗo Saawulu mo Tarsiisu wonɗo ka galle Yahuuda, himo toraade ɗon. ");
INSERT INTO fuf_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","E nder ko o torotoo kon, o feɲɲinanaa, o yi'i goɗɗo no wi'ee Hanaaniiya, on no naata *fawa juuɗe mun ɗen e hoore makko fii yo o wuntu.» ");
INSERT INTO fuf_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Hanaaniiya jaabii, wi'i: «Joomi an, mi nanirii buy no wi'a wonde on neɗɗo waɗii boneeji ɗuuɗuɗi e hoore laaɓuɓe maa ɓen Yerusalaam. ");
INSERT INTO fuf_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Awa ɗoo kadi hooreeɓe yottinooɓe sadaka ɓen no newnani mo haɓɓugol kala jantotooɗo innde maa nden.» ");
INSERT INTO fuf_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Kono Joomi on wi'i mo: «Yahu, ko fii on neɗɗo ko aala mo mi suɓii fii ko lollina innde an nden yeeso ɓe wonaa Yahuudiyanke ɓen e lamɓe ɓen e yeeso *Banii-Isra'iila'en. ");
INSERT INTO fuf_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Awa kadi mi hollay mo ko ittiri haa honto o tampirta innde an nden.» ");
INSERT INTO fuf_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Onsay Hanaaniiya yahi. Ɓay o hewtii e ndun suudu ka on woni ɗon, o fawi juuɗe makko ɗen e hoore Saawulu, o wi'i: «Ko an yo Saawulu musiɗɗo an, ko Joomi Iisaa, on feeɲanɗo ma ka laawol fewndo arataa, woni ko imminimmi fii yo a wuntu, awa kadi fii yo a heewu *Ruuhu Seniiɗo on.» ");
INSERT INTO fuf_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ɗon kisan ko wa'itata wa koɓolle iwi ka gite makko, saami, o wunti, o immii, o *lootaa maande kisiyee. ");
INSERT INTO fuf_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ɓawto ɗun ɓay o ɲaamii, o hetti doole makko ɗen. O wontidi e taalibaaɓe wonnooɓe Damaasi ɗon ɓen e nder balɗe. ");
INSERT INTO fuf_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","O fuɗɗii kisan waajaade fii Iisaa ka juulirɗe, o wi'a jaka ko oo nun woni *Ɓiɗɗo Alla on. ");
INSERT INTO fuf_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Nanunooɓe ɗun ɓen fow ŋalɗi fota, ɓe wi'i: «Hinaa oo giddanaynoo mulugol ɓen jantotooɓe ndee innde Yerusalaam? Hinaa ko addunoo mo kadi ko fii nangugol ɓen wonnooɓe jantaade nde, naɓa ɓe yeeso hooreeɓe yottinooɓe sadaka ɓen?» ");
INSERT INTO fuf_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Tawi kanko Saawulu himo ɓurtude tun ɓeydaade, himo ŋalɗiniraynoo Yahuudiyankeeɓe wonnooɓe Damaasi ɓen e dow ɓanginirangol ɓe pellital wonde ko Iisaa woni *Almasiihu on. ");
INSERT INTO fuf_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ɓay wontii ɗon haa neeɓii, Yahuudiyankeeɓe ɓen diisondiri fii warugol mo. ");
INSERT INTO fuf_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Kono Saawulu humpitii fii kan janfa maɓɓe. Tawi ɓen no aynunoo dame ɗen jemma e ɲalorma fii no ɓe warira mo. ");
INSERT INTO fuf_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Onsay taalibaaɓe ɓen ƴettiri mo jemma, tumbi e nder debeere, ɓe yawtini mo maadi ndin. ");
INSERT INTO fuf_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Ɓay kanko Saawulu o hewtii Yerusalaam, o ɗaɓɓi no o wontidira e taalibaaɓe ɓen, kono tawi fow no hulunoo mo, awa kadi hari ɓe hoolaaki o wontii taalibaajo. ");
INSERT INTO fuf_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Onsay Barnabaasi ƴetti mo, naɓi takko *sahaabaaɓe ɓen. O sifanii ɓe ko honno kanko Saawulu o yiidiri e Joomi on fewndo o yahata Damaasi e ko honɗun Joomi on yewti mo e ko pellital hongal o waajori Damaasi e innde Iisaa. ");
INSERT INTO fuf_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Gila ɗun, tawi o hayloday e maɓɓe Yerusalaam, o yewtira kadi pellital e innde Joomi on. ");
INSERT INTO fuf_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Tawi himo yewtidaynoo kadi, yeddondira e Yahuudiyankeeɓe wowlooɓe haala Gereeki ɓen, kono tawi ɓen kadi no ɗaɓɓude no warira mo. ");
INSERT INTO fuf_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ɓay kamɓe siɓɓe wonɓe e laawol gootol ɓen ɓe humpitike ɗun, ɓe nawri mo Seezariiya, ɓe itti mo ɗon kadi, ɓe naɓi mo Tarsiisu. ");
INSERT INTO fuf_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Tawi ɓuttu no wonani *moftal ngal e nder ɗee leyɗe ɗoo fow, ɗun ko ɗee diiwe Yahuuda e Jaliilu e Samariiya. Tawi hiɓe mawnude e nder gomɗinal ngal, awa kadi hiɓe wuuri e nder yankinaare Joomiraaɗo on, hiɓe ɓeydorde kadi ballal Ruuhu Seniiɗo on. ");
INSERT INTO fuf_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","E nder ko Petruusu jindata e nokkeeli ɗin fow kon, o yahi ka ɓee gomɗinɓe hoɗuɓe Lidaa. ");
INSERT INTO fuf_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","O tawi ɗon goɗɗo, maaya-ɓanduujo, no waalii e danki gila duuɓi jeetati, on no wi'ee Iiniiya. ");
INSERT INTO fuf_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Kanko Petruusu o wi'i mo: «Iiniiya, Iisaa Almasiihu on sellinii ma! Immo an tigi, weƴƴitaa danki maa kin!» O immii kisan. ");
INSERT INTO fuf_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ɓay hoɗuɓe Lidaa ɓen e ɓee ka hollaande Saruuna fow yi'ii ɗun, ɓe gomɗini Joomi on. ");
INSERT INTO fuf_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Tawi kadi debbo okkaynooɗo fota, waɗa kuuɗe moƴƴe, no hoɗunoo Jaffaa, on no wi'ee Taabiita. (Ko woni firo ɗun e haala Gereeki ko Dorkaas.) ");
INSERT INTO fuf_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","On debbo nawni e ɗen balɗe ɗon, o maayi. Ɓay ɓe gaynii fewnude mo, ɓe naɓi mo, ɓe wallinoyi e nder suudu goo ka koore dow. ");
INSERT INTO fuf_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Nde tawnoo Lidaa e Jaffaa woɗɗondiraa, awa kadi hari taalibaaɓe ɓen andii wonde Petruusu no Lidaa ɗon, ɓe immini yimɓe ɗiɗo ko yahana mo, wi'a: «Yandi men torike ma arugol tinna, hara a neeɓaali.» ");
INSERT INTO fuf_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Onsay Petruusu immii, yaadi e maɓɓe. Ɓay o hewtii, ɓe ƴawni mo ka koore e ndun suudu. Rewɓe keynguuɓe ɓen fow ɓadii mo no wulla, e hoore hiɓe holla mo dolokkaaji e burmusuuji ɗi kanko Dorkaas o moƴƴinaynoo wa fewndo ko o wondi e maɓɓe. ");
INSERT INTO fuf_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Onsay kanko Petruusu o yaltini ɓe fow ka yaasi, o jiccii, o torii. Ɓawto ɗun o fewtiti furee on, o wi'i: «Taabiita, immo!» Onsay kanko Taabiita o udditi gite ɗen, o yi'i Petruusu, o immii, o jooɗii. ");
INSERT INTO fuf_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Kanko Petruusu o nangi mo jungo ngon, o immini, o noddi gomɗinɓe ɓen e keynguuɓe ɓen, o watti mo e juuɗe maɓɓe e hoore ko o wurɗo. ");
INSERT INTO fuf_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ɗun andii e nder Jaffaa fow, buy gomɗini Joomi on. ");
INSERT INTO fuf_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Kanko Petruusu o weeri Jaffaa ɗon seeɗa ka garankeejo no wi'ee Sim'uunu. ");
INSERT INTO fuf_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Tawi goɗɗo no Seezariiya ɗon kadi wi'eteeɗo Korneliyuusu, on ko yeesoojo goo e nder dental suufaaɓe wi'eteengal dental ɓe Italii. ");
INSERT INTO fuf_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Tawi on ko dewo, kanko e yimɓe suudu makko ndun fow hiɓe hulaynoo Alla, awa kadi himo wallaynoo miskinɓe fota, duumoo e toragol Alla. ");
INSERT INTO fuf_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Fewndo ka ɓaawo fanaa, o feɲɲinanaa, o yi'i ko laaɓi poy, malaa'ikaajo Alla no naata ka makko. On malaa'ikaajo noddi mo, wi'i: «Korneliyuusu!» ");
INSERT INTO fuf_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kanko Korneliyuusu o punnii mo e hoore himo huli. O wi'i malaa'ikaajo on: «Ko honɗun waɗi Koohoojo?» Kaɲun malaa'ikaajo on wi'i mo: «Torndeeji maa ɗin e dokke ɗe okkorɗaa miskinɓe ɓen ƴentinaama fii ko anditee yeeso Alla. ");
INSERT INTO fuf_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Jooni immin woɓɓe ko yaha Jaffaa addanoye goɗɗo no ton no wi'ee Sim'uunu jammaaɗo Petruusu. ");
INSERT INTO fuf_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Himo weeri ka garankeejo wi'eteeɗo kadi Sim'uunu, on no hoɗi ka daande baharu.» ");
INSERT INTO fuf_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Nde on malaa'ikaajo yewtuɗo mo ɗun yahirnoo, kanko Korneliyuusu o noddi kisan kurkaaduuɓe makko ɗiɗo e suufaajo dewo Alla goo tawanooɗo e ɓen ɓe o halfinaa. ");
INSERT INTO fuf_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ɓay o gaynii ɓe sifanaade ɗun fow, o immini ɓe Jaffaa. ");
INSERT INTO fuf_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Bimbi nden ɲande nde tawnoo hiɓe ka laawol, awa kadi ɓe ɓadike saare nden, Petruusu kadi ƴawi ka fowtorde hoore suudu tumbere ɲalorma fii toragol Alla. ");
INSERT INTO fuf_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","O weelaa, o faalaa ko o ɲaama. Wa fewndo ko o defantee, o feɲɲinanaa goɗɗun, ");
INSERT INTO fuf_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","o yi'i kammu ngun no udditii, o haynii huunde nanditaynde e sollewol fontiingol njanol jogaangol e coɓɓi ɗin nay no tippoo waaloo ka hoore leydi. ");
INSERT INTO fuf_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Tawi no e maggol kulle yaarayɗe koyɗe nay ɗen fow e kala kulle daasotooɗe ka hoore leydi e colli wiirooji ɗin fow. ");
INSERT INTO fuf_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","O nani hawa no wi'a mo: «Petruusu! Immo waraa, ɲaamaa!» ");
INSERT INTO fuf_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Kono kanko Petruusu o wi'i: «Oo'o Joomiraaɗo! Ko fii mi ɲaamaali haa hande ko tuuni maa ko laaɓaa!» ");
INSERT INTO fuf_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ka ɗimmun o nani hawa kan no wi'a mo: «Wota a jogor ko Allaahu on laɓɓini kon wa ko tuuni.» ");
INSERT INTO fuf_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ɗun waɗiri non haa laabi tati. Ɓawto ɗun, nden huunde ƴentinaa kisan ka kammu. ");
INSERT INTO fuf_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Wa fewndo ko kanko Petruusu o jiɓii fii ko o feɲɲinanaa kon, tawi e hino yimɓe ka dambugal, ɗun ko ɓee ɓe Korneliyuusu immini, humpitiiɓe fii nduu suudu Sim'uunu. ");
INSERT INTO fuf_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ɓe noddi, ɓe landii si ko ɗoo oo wi'eteeɗo Sim'uunu jammaaɗo Petruusu weeri. ");
INSERT INTO fuf_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Fewndo ko Petruusu miijotoo fii ko o feɲɲinanaa kon, Ruuhu Allaahu on wi'i mo: «E hino yimɓe tato ka landotoo fii maa. ");
INSERT INTO fuf_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Immo tippoɗaa, yaadaa e maɓɓe, hara a sikkitaaki, ko fii ko min immini ɓe.» ");
INSERT INTO fuf_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Onsay kanko Petruusu o tippii, o wi'i ɓe: «E hino lan. Ko min wonɗon landaade fii mun. Ko fii honɗun addi on ɗoo?» ");
INSERT INTO fuf_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ɓe jaabii mo, ɓe wi'i: «Ko hooreejo dental suufaaɓe wi'eteeɗo Korneliyuusu, aaden feewuɗo, huloowo Alla, mo jamaa Yahuudiyanke fow joganii kongol moƴƴol, woni ko malaa'ikaajo laaɓuɗo andini wonde yo o adde ka suudu makko fii heɗagol konguɗi maa ɗin.» ");
INSERT INTO fuf_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Onsay kanko Petruusu o werni ɓe. Bimbi nden ɲande, o immii, o yaadi e maɓɓe. Siɓɓe goo ɓe Jaffaa ɗowti mo. ");
INSERT INTO fuf_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Bimbiti nden ɲande o hewtoyi Seezariiya, tawi kanko Korneliyuusu himo habbii ɓe, tawi himo nodditi siɓɓe makko ɓen e yiɓɓe makko hiɓɓuɓe ɓen ka makko. ");
INSERT INTO fuf_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Ɓay kanko Petruusu o hewtii, Korneliyuusu yahi jaɓɓagol mo, yani ka ley koyɗe makko, o sujjani mo. ");
INSERT INTO fuf_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Kono kanko Petruusu o ɓanti mo, o wi'i: «Immo, min kadi ko mi neɗɗo!» ");
INSERT INTO fuf_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","E nder ko o yewtidata e makko kon, ɓay ɓe naatii, ɓe tawi yimɓe buy no mooɓii ton. ");
INSERT INTO fuf_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Onsay kanko Petruusu o wi'i ɓe: «Hiɗon andi Yahuudiyankeejo no toŋanaa ka takkondira e mo wonaa Yahuudiyanke maa ka on naata ka makko. Kono min, Alla hollii lan, haanaa ka goɗɗo wi'a hay gooto no tuuni maa laaɓaa. ");
INSERT INTO fuf_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ko ɗun waɗi, ɓay on imminii ko yahanammi, mi arii e hoore mi sattinaali. Jooni non mi landike on, ko fii honɗun addirɗon mi?» ");
INSERT INTO fuf_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Korneliyuusu wi'i mo: «Hari miɗo toroo Alla ka suudu an ka ɓaawo fanaa, mi yi'i gorko ɓorniiɗo conci jalbuɗi no darii yeeso an, gila ɗun waɗii nii balɗe nay. ");
INSERT INTO fuf_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","On wi'immi: ‹Korneliyuusu, torndeeji maa ɗin jaɓaama, Alla kadi maanditike dokke ɗe okkorɗaa miskinɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Jooni immin ko yaha Jaffaa, addane oo wi'eteeɗo Sim'uunu jammaaɗo Petruusu. On no weeri e suudu garankeejo no wi'ee kadi Sim'uunu ka daande baharu.› ");
INSERT INTO fuf_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ɗon kisan mi immini ko yahane, an kadi a moƴƴinii ko arɗaa kon. Jooni non, men fow meɗen ɗoo yeeso Alla fii heɗagol ko Joomiraaɗo on yamir-maa kon fow.» ");
INSERT INTO fuf_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Onsay Petruusu ƴetti haala kan, wi'i: «Ka haqiiqa mi faamii ɗun, fow no fota yeeso Alla. ");
INSERT INTO fuf_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","E nder leƴƴi ɗin fow, kala huluɗo mo, jokki peewal, o jaɓanay ontigi. ");
INSERT INTO fuf_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","O tippinanii *Banii-Isra'iila'en daaluyee on, fii ko feɲɲinana ɓe Kibaaru Moƴƴo wonduɗo e ɓuttu on, rewrude e Iisaa Almasiihu on, on Joomi yimɓe ɓen fow. ");
INSERT INTO fuf_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Onon tigi hiɗon andi ko feƴƴunoo kon Jaliilu, haa hewtoyi diiwal Yahuuda ngal fow, ɓawto *lootagol maande tuubuubuyee ko Yaayaa waajinoo fii mun kon. ");
INSERT INTO fuf_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","E ko honno Allaahu on yeɗiri Iisaa, oo jeyaaɗo Naasirata, *Ruuhu Seniiɗo on wondude e bawgal, ɗun ko on yahaynooɗo hen fow, waɗa moƴƴere, sellina ɓe jinna nangunoo fow, sabu tawde Alla no wondunoo e makko. ");
INSERT INTO fuf_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","«Ko men seedee kadi ko o waɗi kon fow e nder ndii leydi Yahuudiyankeeɓe haa naɓani Yerusalaam. Ɓe wariri mo fempugol mo e leggal, wenga. ");
INSERT INTO fuf_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Allaahu on immintini mo ka ɲalaande tammere, o newnani mo kadi hollitagol, ");
INSERT INTO fuf_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","hinaa non e yimɓe ɓen fow, kono e seedeeɓe ɓe Allaahu on suɓinoo aranun ɓen, ɗun ko menen ɓee ɲaamiduɓe e makko, yaridi ɓawto immintineede makko e hakkunde mayɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Kanko Iisaa o yamiri men waajagol jamaa on, fellintinana ɓe wonde Allaahu on toɗɗike mo kanko tigi ɲaawoowo wurɓe e mayɓe. ");
INSERT INTO fuf_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Awa kadi annabaaɓe ɓen fow seeditaninoke mo wonde kala gomɗinɗo mo heɓay yaafuyee junuubaaji e innde makko.» ");
INSERT INTO fuf_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Nde tawnoo Petruusu no waajaade fii ɗun, Ruuhu Seniiɗo on tippii e ɓen wonnooɓe heɗaade ngol kongol ɗon fow. ");
INSERT INTO fuf_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Gomɗinnooɓe sunninaa ɓen fow, ɗun ko ɓee ɓe Petruusu ardii, ŋalɗi fii ko ɓe wonaa Yahuudiyanke ɓen okkaa kon Ruuhu Seniiɗo on. ");
INSERT INTO fuf_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Ko fii hari hiɓe nanaynoo hiɓe wowla e *haalaaji janani, manta Alla. Onsay Petruusu ƴetti haala kan, wi'i: ");
INSERT INTO fuf_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","«E hara en salanto ɓee heɓuɓe Ruuhu Seniiɗo on ndiyan ko ɓe lootora maande kisiyee wano heɓirɗen non enen kadi?» ");
INSERT INTO fuf_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Onsay o yamiri yo ɓe loote maande kisiyee e innde Iisaa Almasiihu on. Kamɓe kadi ɓe torii mo wondugol e maɓɓe e nder balɗe. ");
INSERT INTO fuf_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Sahaabaaɓe* wonɓe ka diiwal Yahuuda ɓen e ɓe ɓe wondi e laawol gootol ɓen, nani wonde ɓe wonaa Yahuudiyanke ɓen jaɓii daaluyee Alla on. ");
INSERT INTO fuf_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ɓay kanko Petruusu o yahii Yerusalaam, gomɗinɓe sunninaa ɓen ɓanniti mo, feli, ɓe wi'i: ");
INSERT INTO fuf_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","«A naatii ka ɓe *sunninaaka ɓen, awa kadi a ɲaamidii e maɓɓe!» ");
INSERT INTO fuf_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Onsay Petruusu nangi ɓe sifanagol fii ɗun, ");
INSERT INTO fuf_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","o wi'i: «Fewndo ko mi woni ka saare Jaffaa, hari miɗo toroo Alla, mi feɲɲinanaa goɗɗun. E nder ɗun, mi yi'i huunde nanditaynde e sollewol fontiingol njanol jogaangol e coɓɓi ɗin nay no tippoo tawammi. ");
INSERT INTO fuf_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ɓay mi ndaarii ɗun, mi tenƴinii, mi yi'i ton kulle yaarayɗe koyɗe nay ɗen ka hoore leydi e kulle buruure ɗen e kulle daasotooɗe ɗen e colli wiirooji ɗin. ");
INSERT INTO fuf_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Mi nani hawa no wi'ammi: ‹Petruusu, immo waraa, ɲaamaa!› ");
INSERT INTO fuf_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Kono mi wi'i: ‹Oo'o Joomiraaɗo! Ko fii haa hande ko tuuni maa ko laaɓaa naataali ka hunduko an!› ");
INSERT INTO fuf_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ka ɗimmun hawa kan fillitii ka kammu, wi'immi: ‹Wota a jogor ko Allaahu on laɓɓini kon wa ko tuuni.› ");
INSERT INTO fuf_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ɗun warri non haa laabi tati, onsay fow ƴentinaa ka kammu. ");
INSERT INTO fuf_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","«Tun mi yi'i yimɓe tato imminaaɓe e an iwruɓe Seezariiya no ara ka suudu ka men woni ɗon. ");
INSERT INTO fuf_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ruuhu Allaahu on yamirimmi yaadugol e maɓɓe, hara mi sikkitaaki. Ko ɓee musiɓɓe ɗoo njeegoo ɗowtimmi haa men naatoyi ka galle Korneliyuusu. ");
INSERT INTO fuf_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","On sifanii men ko honno o yiiri malaa'ikaajo on no darii ka suudu makko, e ko o wi'i mo: ‹Immin ko yahana oo wi'eteeɗo Sim'uunu jammaaɗo Petruusu wonɗo on Jaffaa. ");
INSERT INTO fuf_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","On yeetoto ma konguɗi ɗi daɗirtaa ɗin, an e ɓeynguure maa nden fow.› ");
INSERT INTO fuf_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","«Ɓay min kadi mi nanganii yewtugol, *Ruuhu Seniiɗo on tippii e wonɓe ɗon ɓen wano o tippornoo non e men ka fuɗɗoode. ");
INSERT INTO fuf_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Onsay mi anditi ngol daalol ngol Joomi on wi'unoo wonde: ‹Yaayaa kaɲun ko ndiyan lootiraynoo, kono onon ko Ruuhu Seniiɗo on lootirteɗon.› ");
INSERT INTO fuf_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ɓay Allaahu on yeɗii ɓe kamɓe kadi ko o yeɗunoo en kon, enen ɓee gomɗinɓe Iisaa Almasiihu Joomi on, hari ko mi hombo haa ka mi dartoo Alla?» ");
INSERT INTO fuf_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ɓay gomɗinɓe sunninaa ɓen nanii ɗun, ɓe fanki, ɓe manti Alla, e hoore hiɓe wi'a: «Allaahu on yeɗii ɓe wonaa Yahuudiyanke ɓen tuubuubuyee fii no ɓe heɓira ngurndan!» ");
INSERT INTO fuf_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Saakitinooɓe ɓen sabu ɓittineede ɓawto waregol Astefaana, ɓe yahi haa Fenisii e ka suriire Siipuru e haa Antiyoosi-Sirii. Tawi ɓe alaa ɓanginande hay gooto daaluyee on si wonaa Yahuudiyankeeɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Heɓii ton e hakkunde ɓen saakitinooɓe, ɓe Siipuru e ɓe Sirenii, arɓe Antiyoosi-Sirii, yewti ɓee *Gereekiyankeeɓe, feɲɲinani ɓe fii Kibaaru Moƴƴo Iisaa Joomi on. ");
INSERT INTO fuf_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Tawi jungo Joomiraaɗo on no e hoore maɓɓe, yimɓe buy gomɗini, jaɓi Joomi on. ");
INSERT INTO fuf_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Nde *moftal ngal Yerusalaam humpitinoo ɗun, ɓen kadi immini Barnabaasi ko yaha Antiyoosi-Sirii. ");
INSERT INTO fuf_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Ɓay o hewtii, o yi'ii moƴƴere Alla nden, o weltii, o wakkilini ɓe fow catorgol e Joomi on ɓernde tabitunde, ");
INSERT INTO fuf_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","ko fii hari on ko aaden moƴƴo heewuɗo gomɗinal e Ruuhu Seniiɗo on. Konu yimɓe ɗuuɗungu jokki Joomi on. ");
INSERT INTO fuf_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Onsay Barnabaasi yaari Tarsiisu fii yahangol Saawulu. ");
INSERT INTO fuf_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ɓay o tawii mo, o ardi e makko Antiyoosi-Sirii. E nder hitaande fow hiɓe tawdeede e tumbondire moftal ngal, e hoore ɗun hiɓe jannude jamaa yimɓe ɗuuɗuɓe. (Ko Antiyoosi-Sirii ɗon taalibaaɓe ɓen attaa noddeede *Almasiiyaaɓe.) ");
INSERT INTO fuf_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","E nder ɗen balɗe ɗon, haalooɓe ko Alla longini ɗun iwi Yerusalaam, ari Antiyoosi-Sirii. ");
INSERT INTO fuf_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Goɗɗo e ɓen no wi'ee Agabuusi, on immii *hiitii tippude e Ruuhu Allaahu on, o wi'i wonde heege moolanaange waɗay e aduna on fow. (Ɗun waɗi-le e fewndo laamu Kuloodiyuusu.) ");
INSERT INTO fuf_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Taalibaaɓe ɓen anniyii wonde mo bee e maɓɓe wallitoto musiɓɓe maɓɓe wonɓe ɓen ka diiwal Yahuuda embere taaqa maɓɓe on. ");
INSERT INTO fuf_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ɓe waɗi ɗun, ɓe watti e juuɗe Barnabaasi e Saawulu yo ɓen naɓu, jonna ardotooɓe moftal ngal ɓen. ");
INSERT INTO fuf_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ko e fewndo on saa'i, oo lanɗo wi'eteeɗo *Heroodu nangi woɓɓe e *moftal ngal fii lettugol ɓe. ");
INSERT INTO fuf_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","O wariri Yaaquuba kaafa, ɗun ko oo kotiraawo Yuuhanna. ");
INSERT INTO fuf_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Nde o ndaarunoo o tawi ɗun no wela Yahuudiyankeeɓe ɓen, o nangi Petruusu kadi. Ɗun hawrondiri e *Juldeere Bireedi ɗe Aldaa e Lewen nden. ");
INSERT INTO fuf_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Ɓay o nangii mo, o ferii mo ka kaso, o itti mojobe nay ko ayna mo, mojobere kala suufaaɓe nayo. Hari e miijo makko ko si *Juldeere Yawtaneede nden feƴƴii o ɲaawa mo yeeso jamaa on. ");
INSERT INTO fuf_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ko kanko Petruusu o woni ka kaso, moftal ngal duumii e toranagol mo Alla. ");
INSERT INTO fuf_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Weetaynoo Heroodu ɲaawa mo, e on jemma mun, tawi kanko Petruusu himo jolkaa jolokooje ɗiɗi, ɗaanii hakkunde suufaaɓe ɗiɗo, tawi aynooɓe kaso ngon no dartori ka dambugal. ");
INSERT INTO fuf_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Onsay malaa'ikaajo Joomiraaɗo on feeɲani mo, ka o wonnoo ɗon ndaygi. O findiniri mo kanko Petruusu mbaɓɓugol mo ka becce, o wi'i mo, «Immo tinna!» Jolokooje wonnooɗe ka juuɗe makko ɗen yani. ");
INSERT INTO fuf_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Malaa'ikaajo on wi'i mo kadi: «Haɓɓu duhol maa ngol, wattoɗaa paɗe maa ɗen.» O waɗi ɗun. Malaa'ikaajo on wi'i mo: «Waano burmusu maa on, jokkaa mi.» ");
INSERT INTO fuf_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Petruusu yalti, jokki mo, tawi o andaa si ballal malaa'ikaajo on ko goonga, tawi himo sikka ko feɲɲinannde tun o heɓi. ");
INSERT INTO fuf_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ɓay ɓe feƴƴii ayninaaɓe yeeso ɓen e hikkuɓe ɗon ɓen, haa ɓe hewtii ka baafal njandi feƴƴeteengal si yahee ka saare, onsay ngal udditanii hoore maggal yeeso maɓɓe, ɓe yalti, ɓe yaadi haa e laawol. Tun malaa'ikaajo on seedi e makko. ");
INSERT INTO fuf_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Kanko Petruusu o hetti non hakkil, o wi'i: «Jooni non, ka haqiiqa, mi andii wonde Joomiraaɗo on imminii malaa'ikaajo mun on, o sortii lan e juuɗe Heroodu e kala ko jamaa Yahuudiyankeeɓe ɓen tijjinoo e hoore an.» ");
INSERT INTO fuf_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ɓay o faamii ko waɗi kon, o yahi ka galle Mariyama yumma Yuuhanna jammaaɗo Markuusa, ka woɓɓe mooɓinoo no toroo. ");
INSERT INTO fuf_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Ɓay o hoɗɗike baafal ngal ka naatirgal, jiwo kurkaaduujo no wi'ee Rodaasi ɓadoyii fii andugol ko hombo. ");
INSERT INTO fuf_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Ɓay o anditii hawa Petruusu kan, hakkee ko o weltii, ɗoo yo o udditu baafal ngal, o yahi taho, o andinoyi ɓeya wonde Petruusu no ka naatirgal. ");
INSERT INTO fuf_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ɓen wi'i mo: «A feetii!» Kono o wi'i ko goonga. Ɓen wi'i: «Awa ko malaa'ikaajo makko on!» ");
INSERT INTO fuf_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Kono tawi Petruusu no jokki tun hoɗɗagol. Ɓay ɓe udditoyii, ɓe yi'ii mo, ɓe ŋalɗi fota. ");
INSERT INTO fuf_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","O fankiniri ɓe yeƴangol ɓe juuɗe makko ɗen, o sifanii ɓe ko honno Joomiraaɗo on yaltiniri mo ka kaso. O yamiri ɓe, o wi'i: «Andinee ɗun Yaaquuba e musidal ngal.» Onsay o yalti ɗon, o yaari nokku goo. ");
INSERT INTO fuf_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ɓay weetii, jiiɓoldu tiiɗundu waɗi e hakkunde suufaaɓe ɓen, ɓe woni e landondirgol ko honto Petruusu woni. ");
INSERT INTO fuf_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Heroodu kadi ɗaɓɓiti mo, kono o yi'aali mo. O landii suufaaɓe ɓen, o yamiri yo ɓe ware. Onsay kanko Heroodu o iwi ka diiwal Yahuuda ɗon, o yaari Seezariiya fii wonugol ton. ");
INSERT INTO fuf_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Tawi kanko Heroodu himo haɓidi e Tiiriyankooɓe ɓen e Siduunayankooɓe ɓen. Ɓe ari ɓe tawi mo e nder nanondiral maɓɓe. Ɓay ɓe hettii Balastuusa oo dankotooɗo kaybonru lanɗo on, ɓe torii ɓuttu, sabu tawde ko leydi on lanɗo tambitinoo leydi maɓɓe ndin. ");
INSERT INTO fuf_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Ɓay ɲalaande nde ɓe haldunoo nden hewtii, kanko Heroodu o ɓornii conci makko laamu ɗin, o jooɗii ka jullere makko laamu, o yewti ɓe kamɓe jamaa on. ");
INSERT INTO fuf_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Jamaa on nangi ewnagol wi'a: «Kaa hawa ko hito allaajo nii, hinaa hawa neɗɗo!» ");
INSERT INTO fuf_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ɗon kisan malaa'ikaajo Joomiraaɗo on liɓi nawnaare e makko, sabu tawde o jonnitaali Alla mangural ngal, o yilmi, o maayi. ");
INSERT INTO fuf_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Kono daaluyee Alla on ɓurti yaajude. ");
INSERT INTO fuf_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Ɓay Barnabaasi e Saawulu gaynii golle mun ɗen Yerusalaam, ɓe yiltitii Antiyoosi-Sirii, ɓe naɓori Yuuhanna oo jammaaɗo Markuusa. ");
INSERT INTO fuf_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Tawi haalooɓe ko Alla longini ɗun e jannooɓe no e nder *moftal wongal ngal Antiyoosi-Sirii, ɓen-le ko Barnabaasi e Sim'uunu jammaaɗo Ɓaleejo, e Lukiyuusi, oo mo Sirenii, e Saawulu e Manayiina, ɗun ko oo ne'idaaɗo e *Heroodu lanɗo diiwal ngal. ");
INSERT INTO fuf_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","E nder ko ɓe rewaynoo Joomiraaɗo on kon, ɓe hoora, *Ruuhu Seniiɗo on wi'i ɓe: «Waɗanee lan Barnabaasi e Saawulu feere fii golle ɗe mi noddiri ɓe ɗen.» ");
INSERT INTO fuf_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ɓay ɓe gaynii hoorude toroo, ɓe *fawi juuɗe maɓɓe ɗen e hoore Barnabaasi e Saawulu, ɓe nuli ɓe. ");
INSERT INTO fuf_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Ɓen ɓe Ruuhu Seniiɗo on immini, ɗun ko Barnabaasi e Saawulu, ɓe yahi Seluusi, ɓe bakii ɗon e laana ndiyan fii yahugol Siipuru. ");
INSERT INTO fuf_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Ɓay ɓe hewtii Saalamini, ɓe feɲɲini daaluyee Alla on ka juulirɗe Yahuudiyankeeɓe ɓen. Tawi hiɓe wondi e oo wi'eteeɗo Yuuhanna jammaaɗo Markuusa fii ko wallitoo ɓe. ");
INSERT INTO fuf_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Ɓawto ɗun, ɓay ɓe taƴitoyii ndee suriire fow haa ɓe hewtoyii Paafuusa, ɓe tawi ɗon mbileejo goo, tawi on ko Yahuudiyankeejo waɗitiiɗo annabaajo, tawi on no wi'ee Bar-Iisaa. ");
INSERT INTO fuf_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Tawi himo wondi e on addaaɗo lamminaa ngal diiwal, ɗun ko oo wi'eteeɗo Sargiisu Puulusa, tawi on lanɗo ko jooma-hakkiljo. On lanɗo noddi Barnabaasi e Saawulu ɓay himo faalanoo nanude daaluyee Alla on. ");
INSERT INTO fuf_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Kono oo wi'eteeɗo Elimaasi, ɗun ko mbileejo on, (ko fii ko non innde makko nden firiraa), o dartii ɓe, tawi himo ɗaɓɓude fii no o bonnira gomɗinal lanɗo on. ");
INSERT INTO fuf_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Onsay Saawulu, himo wi'ee kadi Puulusa, heewuɗo Ruuhu Seniiɗo on, tenƴini on mbileejo, o wi'i: ");
INSERT INTO fuf_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","«Ko an yo heewuɗo kala noone ƴoyre e bonki, ɓiɗɗo Ibuliisa, gaɲo kala peewal, a accataa bonnugol laawi feewuɗi Joomiraaɗo on? ");
INSERT INTO fuf_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Jooni non heɗo! Joomiraaɗo on fawete jungo, wumaa, wona e saa'i mo a yi'ataa naange ngen.» Ɗon kisan niɓɓitani mo, niwre tiiɗunde yani e makko, o woni e memugol, tawi himo ɗaɓɓa woɓɓe ko ɗowa mo. ");
INSERT INTO fuf_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Ɓay on lanɗo yi'ii kon ko waɗi, o ŋalɗi fii jannde Joomi on, o gomɗini. ");
INSERT INTO fuf_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Ɓay kanko Puulusa e wondiɓɓe makko ɓen ɓe iwii Paafuusa, ɓe bakii ɗon e laana ndiyan fii yahugol Pergii, ɗun ko e nder ndii leydi wi'eteendi Pamfilii. Ɓay ɓe hewtii ɗon, Yuuhanna jammaaɗo Markuusa on seedi ɗon e maɓɓe, o yiltitii Yerusalaam. ");
INSERT INTO fuf_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ɓay ɓe iwii Pergii, ɓe jokkitii laawol maɓɓe haa ɓe hewti ka saare Antiyoosi-Pisidii. Ɓe naati ɗon e nder juulirde, ɓe jooɗii, ɗun hawri e *ɲalaande fowteteende, ɗun ko e *aseweere nden. ");
INSERT INTO fuf_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Ɓay fii Sariya on e fii annabaaɓe ɓen gaynaama jangeede, yeesooɓe juulirde nden immini woɓɓe e maɓɓe ko wi'a ɓe: «Musiɓɓe, si tawii hiɗon mari konguɗi wakkilinayɗi jamaa on, haray yewtee.» ");
INSERT INTO fuf_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Onsay kanko Puulusa o immii, o townani ɓe jungo, o wi'i: «Ko onon yo *Banii-Isra'iila'en e onon ɓee hulooɓe Alla, heɗitee! ");
INSERT INTO fuf_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Alla oo jamaa Isra'iilayankeeɓe suɓike baabiraaɓe men ɓen, on Yaɲɲuɗo kadi oo jamaa fewndo ko ɓe woni tuŋarankeeɓe e nder ndii leydi *Misira, o yaltiniri ɓe ton kadi sookewo makko dolnungo ngon. ");
INSERT INTO fuf_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","O muɲɲanii ɓe kadi wa telen duuɓi cappanɗe nay ka wulaa. ");
INSERT INTO fuf_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Onsay ɓay o mulii leƴƴi jeeɗiɗi e nder ndii leydi *Kanaana, o yeɗi baabiraaɓe men ɓen laral leydi ɓen ndin. ");
INSERT INTO fuf_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ɗun fow waɗi e nder duuɓi teemeɗɗe nay e cappanɗe jowi. «Ɓawto ɗun o addani ɓe hooreeɓe, haa e fewndo annabi Samu'iila. ");
INSERT INTO fuf_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ɓawto ɗun ɓe torii heɓugol lanɗo. Onsay Alla addani ɓe Saawulu ɓiɗɗo Kiisi on, jeyaaɗo e oo bolondaa *Buniyamiinu, ko laamoo ɓe e nder duuɓi cappanɗe nay. ");
INSERT INTO fuf_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Ɓay o follii onɗon, o lamminani ɓe Daawuuda, ɗun ko on mo o seeditornoo ɗunɗoo, o daali: ‹Mi taw Daawuuda mo Yassaa'u ko neɗɗo waalaniiɗo lan e ɓernde, timminoowo faaleeji an ɗin fow.› ");
INSERT INTO fuf_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Kanko Puulusa o wi'i kadi: «Ko tippude e fodoore makko nden kanko Alla waɗi si Iisaa jibinaa e nder bolondaa Daawuuda on, fii ko wonana Isra'iila'en dandoowo. ");
INSERT INTO fuf_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ado o arude, hari Yaayaa waajike jamaa Isra'iilayankeeɓe ɓen fow fii *lootagol maande tuubuubuyee. ");
INSERT INTO fuf_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Fewndo kanko Yaayaa o timminaynoo golle makko ɗen, o wi'uno: ‹Hinaa min woni on mo sikkuɗon, kono on no ara ɓaawo an ɗoo, on mo mi hewtaa hay firtugol ɓoggi paɗe mun!› ");
INSERT INTO fuf_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Kanko Puulusa o wi'i kadi: «Ko onon yo musiɓɓe an, ɓiɓɓe bolondaa Ibraahiima, e hulooɓe Alla wonɓe hakkunde mon, ko haa e men enen ngol daalol kisiyee addaa. ");
INSERT INTO fuf_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ko fii yimɓe Yerusalaam ɓen e lamɓe mun ɓen andaali ko hombo woni Iisaa, awa kadi ɓe faamaali konguɗi annabaaɓe wonaaɗi jangeede ɗin asewe kala, ɓe laatiniri ɗi ɲaawugol mo. ");
INSERT INTO fuf_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","E hoore ɓe heɓaali hujja happanɗo mo wareede, kono ɓe torii Pilaatu yo o waru mo. ");
INSERT INTO fuf_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ɓe laatiniri nii ko windinoo kon fii makko. Onsay ɓe tippini mo ka *leggal altindiraangal, ɓe wallini mo e nder qaburu. ");
INSERT INTO fuf_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Kono Allaahu on immintini mo e hakkunde mayɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Ɓen yaadaynooɓe e makko gila Jaliilu haa Yerusalaam, yi'itike mo e nder balɗe buy, ɓen ko seedeeɓe makko jooni yeeso jamaa on. ");
INSERT INTO fuf_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","«Menen, meɗen feɲɲinande on wonde: Alla hunnii ko o fodunoo baabiraaɓe men ɓen kon e fayɓe maɓɓe ɓen, ɗun ko enen. O hunniri ɗun immintingol Iisaa, tippude e ko windii kon ka beytol ɗimmol Zabuura, ka o wi'i ɗon: ‹Ko an woni Ɓiɗɗo an on, hande a wonii mo an.› ");
INSERT INTO fuf_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","«Kon ko Alla immintini Iisaa e hakkunde mayɓe ɓen, hara o luttaali ka ɲolu, ko ɗun o daalunoo, o wi'i: ‹Mi yeɗay on barkiiji laaɓuɗi holniiɗi ɗi mi fodunoo Daawuuda ɗin.› ");
INSERT INTO fuf_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Kanko Puulusa o wi'i: «E hoore ɗun, no wi'aa nokku goo kadi: ‹Yaa an Alla, a jaɓataa Seniiɗo maa on laatoo ɲolɗo.› ");
INSERT INTO fuf_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Puulusa wi'i fahin: «Kono nde Daawuuda waɗunoo faaleeji Alla ɗin e nder jamaanu makko ngun, o maayuno, o tawtinaa baabiraaɓe makko ɓen, o ɲoli. ");
INSERT INTO fuf_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Kono on mo Allaahu on immintini laataaki ɲolɗo. ");
INSERT INTO fuf_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","«Ko onon non, yo musiɓɓe amen, andee dey ko sabu makko kanko Iisaa feɲɲiniranaɗon yaafuyee junuubaaji ɗin. ");
INSERT INTO fuf_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Kala on hooliiɗo mo jogorte feewuɗo e hoore kala ko on waawetanooke jogoreede feewuɗo e nder Sariya Muusaa on. ");
INSERT INTO fuf_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Ko ɗun waɗi si men wi'ay on, reenee fii wota ko wi'aa kon ka defte annabaaɓe ɓen hawru e mon, ɗun-le ko ɗunɗoo: ");
INSERT INTO fuf_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‹Ndaaree onon ɓee yawitiiɓe, wonee ŋalɗuɓe, mulon! Ko fii e fewndo mon, mi waɗay kuugal ngal on sikkataano hay si on sifanaama!› » ");
INSERT INTO fuf_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Ɓay Puulusa e Barnabaasi fokkitii yaltude ka juulirde ɗon, ɓe saatinaa e aseweere aroore nden, ɗun ko ɲalaande fowteteende nden, fii yewtugol fii ɗun. ");
INSERT INTO fuf_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Ɓay mottondiral ngal lannii, Yahuudiyankeeɓe buy e naatuɓe e diina Yahuudiyanke buy jokki Puulusa e Barnabaasi, ɓe yewtidi e maɓɓe. Onsay Puulusa e Barnabaasi wakkilini ɓe fii tabitugol, haɓɓitoo e moƴƴere Alla nden. ");
INSERT INTO fuf_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","E aseweere hikkunde ɗon nden, fayda saare nden fow mottondiri fii heɗagol daaluyee Joomiraaɗo on. ");
INSERT INTO fuf_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ɓay Yahuudiyankeeɓe ɓen yi'ii on jamaa, ɓe nawli, ɓe yeddi ko Puulusa yewtaynoo kon, ɓe hoyni mo. ");
INSERT INTO fuf_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Onsay Puulusa e Barnabaasi yewtiri pellital, wi'i ɓe: «Hari ko e mon taho daaluyee Allaahu on haananoo yottineede. Kono ɓay on bugitike, awa kadi on waɗaali hoore mon handuɓe e *ngurndan poomayankejan ɗan, men yaaray ka ɓe wonaa Yahuudiyanke ɓen. ");
INSERT INTO fuf_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Ko fii, ko nii Joomiraaɗo on yamiriri men, o daali: ‹Mi suɓike on fii yo on wonan leƴƴi ɗin ndaygu, e naɓugol kisiyee on haa ka kattudi leyɗe.› » ");
INSERT INTO fuf_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ɓay ɓe wonaa Yahuudiyanke ɓen nanii ɗun, ɓe weltii, ɓe manti daaluyee Joomiraaɗo on, tawnooɓe no muuyanaa ngurndan poomayankejan ɗan ɓen fow gomɗini. ");
INSERT INTO fuf_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Tawi daaluyee Joomiraaɗo on no layude e nder leydi ndin fow. ");
INSERT INTO fuf_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Kono Yahuudiyankeeɓe ɓen ƴuuni e maɓɓe rewɓe teddinaaɓe rewooɓe Alla, e mokobaaɓe saare nden, ɓen waɗi jokke e hoore Puulusa e Barnabaasi, ɓe raɗii ɓe ka diiwal maɓɓe. ");
INSERT INTO fuf_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ko ɗun waɗi si Puulusa e Barnabaasi honki mbullaari paɗe mun ɗen e Yahuudiyankeeɓe wonɓe ton ɓen, ɓe yaari Ikoniim. ");
INSERT INTO fuf_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Fii kala ɗun waɗii, tawi taalibaaɓe wonɓe Antiyoosi-Pisidii ɓen kan no heewi weltaare e Ruuhu Seniiɗo on. ");
INSERT INTO fuf_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ɓay Puulusa e Barnabaasi hewtii Ikoniim, ɓe naatiri ka juulirde Yahuudiyankeeɓe ɓen. Noone no ɓe yewtiri non waɗi haa Yahuudiyankeeɓe ɗuuɗuɓe e *Gereekiyankeeɓe gomɗini. ");
INSERT INTO fuf_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Kono Yahuudiyankeeɓe ɓe gomɗinaali ɗun ɓen ƴuuni ɓe wonaa Yahuudiyanke ɓen fii yo ɓen waɗu gomɗinɓe ɓen bone. ");
INSERT INTO fuf_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Kono laatii, ɓe woni Ikoniim ko neeɓi, tawi hiɓe yewtiraynoo pellital fii Joomiraaɗo on, on Seeditantooɗo daaluyee mun sulfu on, himo newnannoo ɓe waɗirgol juuɗe maɓɓe ɗen maandeeji e kaawakeeji moƴƴi yi'otooɗi. ");
INSERT INTO fuf_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Onsay yimɓe saare nden senditii, woɓɓe wontidi e Yahuudiyankeeɓe ɓen, woɓɓe kadi wontidi e *sahaabaaɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","6","Ɓay Puulusa e Barnabaasi humpitike wonde Yahuudiyankeeɓe ɓen e ɓe wonaa Yahuudiyanke ɓen wondude e yeesooɓe maɓɓe ɓen immanike ɓe e feragol ɓe kaaƴe, ɓe tawi yo ɓe yahu, ɓe fattoyoo e ɗee ca'e jeyaaɗe e ndii leydi wi'eteendi Likayonii, ɗun ko Listaara e Derbata, e ca'e heeduɗe ɗon ɗen, ");
INSERT INTO fuf_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","ɓe woni e waajagol ton fii Kibaaru Moƴƴo on. ");
INSERT INTO fuf_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Tawi maaya-koyɗeejo no Listaara ɗon, heɓidaaɗo e boofoyaagal, mo yahaali haa hande, ");
INSERT INTO fuf_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","tawi on no heɗii ko Puulusa yewtaynoo kon. Puulusa tenƴini mo, ndaari tawi himo mari gomɗinal sellinayngal mo. ");
INSERT INTO fuf_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Onsay kanko Puulusa o ewnii, o wi'i: «Immo daroɗaa e hoore koyɗe maa ɗen!» Tun o hawtii nde wootere, o nangi jindugol. ");
INSERT INTO fuf_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Ɓay ɓe yi'ii kon ko Puulusa waɗi, jamaa on ewnii e haala Likayonii, ɓe wi'i: «Allaaɓe ɓe mbaadi neɗɗanke tippike e men!» ");
INSERT INTO fuf_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ɓe inni Barnabaasi Zafsa, Puulusa kaɲun Hermiisi, ɓay ko kanko joginoo kongol ngol. ");
INSERT INTO fuf_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Onsay oo waɗoowo sadakaaji fii nduu allaaru maɓɓe wi'eteendu Zafsa, wondu ka yeeso saare, addi ga'i e *meetelli telen ka dambuɗe saare, tawi kanko e jamaa on hiɓe woniri waɗangol Puulusa e Barnabaasi sadaka. ");
INSERT INTO fuf_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Ɓay sahaabaaɓe ɓen nanii ɗun, ɗun ko Barnabaasi e Puulusa, ɓe seeki dolokkaaji maɓɓe ɗin, ɓe wubbi, ɓe ukkitoyii e hakkunde jamaa on e hoore hiɓe sonkana yimɓe ɓen, wi'a: ");
INSERT INTO fuf_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","«Ko honɗun waɗanton ɗun? Menen kadi ko men yimɓe wano mo'on! Meɗen waajorde on wa Kibaaru Moƴƴo fii ittugol on e ɗii piiji mehi, ruttoɗon e Alla Wuuruɗo on, on Taguɗo kammu e leydi e baharu e kala ko woni e mun. ");
INSERT INTO fuf_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","E ɗii jamaanuuji feƴƴuɗi, o accuno leƴƴi ɗin fow jokki faaleeji mun, ");
INSERT INTO fuf_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","e hoore o accaali seeditorgol moƴƴere nde o waɗata nden, ɗun ko yeɗugol on ndiyan saaƴoojan iwrude ka kammu e saa'iiji moƴƴooji fii demal, e timminangol on neemaaji e hebbingol ɓerɗe mon ɗen welo-welo.» ");
INSERT INTO fuf_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Fii kala ɓe yewtirii non, ko karahan ɓe waawiri haɗirde ɓen yimɓe waɗangol ɓe sadakaaji. ");
INSERT INTO fuf_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Onsay Yahuudiyankeeɓe iwri Antiyoosi-Pisidii e Ikoniim, ɓe murtini jamaa on, ɓe hawtiti, ɓe fiɗi Puulusa kaaƴe haa ɓe sikki o maayii, ɓe daasi mo, ɓe naɓi ka ɓaawo saare. ");
INSERT INTO fuf_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Kono taalibaaɓe ɓen hundi mo, o immii, o naatiti ka saare. Bimbi nden ɲande kanko Puulusa e Barnabaasi ɓe yahi Derbata. ");
INSERT INTO fuf_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Ɓay Puulusa e Barnabaasi waajike fii Kibaaru Moƴƴo on e nden saare haa ɓe heɓii taalibaaɓe ɗuuɗuɓe, onsay ɓe yiltitii e ɗee ca'e ɗoo, ɗun ko Listaara e Ikoniim e Antiyoosi-Pisidii. ");
INSERT INTO fuf_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ɓe wallitii taalibaaɓe ɓen fii tiiɗingol ɓerɗe maɓɓe ɗen, ɓe wakkilini ɓe e duumagol e gomɗinal ngal, ɓe wi'i ɓe: «Ko e nder tampereeji buy naateten ka *laamu Alla!» ");
INSERT INTO fuf_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ɓe toɗɗanii *moftal kala ko wonana ɗun ardotooɓe. Ɓay ɓe gaynii hoorude toroo, ɓe halfini ɓe Joomiraaɗo mo ɓe gomɗini on. ");
INSERT INTO fuf_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Ɓawto ɗun, ɓe taƴitoyi ngal diiwal Pisidii, ɓe yahi Pamfilii. ");
INSERT INTO fuf_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Ɓay ɓe waajike fii daaluyee Alla on ka saare Pergii, onsay ɓe yahi Atalii. ");
INSERT INTO fuf_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ɓe bakii ɗon e laana fii yiltitagol Antiyoosi-Sirii, ka ɓe ƴettanoo ɗon ɓe halfinaa sulfu Alla on fii ɗee golle ɗe ɓe ari e laatinde ɗoo. ");
INSERT INTO fuf_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Ɓay ɓe hewtii, ɓe mottindiri moftal ngal, ɓe fillitanii ɓe ko Alla waɗini ɓe kon fow, e ko honno o udditirani ɓe wonaa Yahuudiyanke ɓen dambugal gomɗinal ngal. ");
INSERT INTO fuf_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Onsay ɓe wontidi e taalibaaɓe ɓen ɗon ko neeɓi. ");
INSERT INTO fuf_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Onsay woɓɓe iwri ka diiwal Yahuuda ari e jannugol musiɓɓe ɓen, wi'a: «Si on sunninaaka tippude e aada Muusaa on, haray on waawetaake dandeede.» ");
INSERT INTO fuf_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Ɓay yeddondiral njanal e yewtere tiiɗunde wonii hakkunde maɓɓe e Puulusa e Barnabaasi fii ɗun, onsay musiɓɓe ɓen aadii yo Puulusa e Barnabaasi e woɓɓe goo hakkunde maɓɓe yaadu Yerusalaam, ɓe tawoya *sahaabaaɓe ɓen e ardotooɓe *moftal ngal fii nden huunde. ");
INSERT INTO fuf_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ɓay moftal ngal wattii ɓe e laawol, ɓe yahi ɓe taƴitoyi Fenisii e Samariiya, e hoore hiɓe fillitanoo ɓen musiɓɓe wonɓe e ɗen ca'e, ɓe fensita ko honno ɓe wonaa Yahuudiyanke ɓen jaɓiri laawol ngol. Ɗun wonani musiɓɓe ɓen fow weltaare njande. ");
INSERT INTO fuf_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ɓay ɓe hewtii Yerusalaam, moftal ngal e sahaabaaɓe ɓen e ardotooɓe moftal ngal tolni ɓe, kamɓe kadi ɓe fillitanii ɓen ko Allaahu on waɗini ɓe kon fow. ");
INSERT INTO fuf_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Onsay woɓɓe e fedde *Fariisiyaaɓe gomɗinɓe ɓen hawtii, wi'i: «No haani ka ɓe wonaa Yahuudiyanke ɓen sunninee, ɓe yamiree ɗoftagol Sariya Muusaa on.» ");
INSERT INTO fuf_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Onsay sahaabaaɓe ɓen e ardotooɓe moftal ngal yiitidi fii ndaarangol ndun muraadu. ");
INSERT INTO fuf_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ɓay yeddondiral ngal tiiɗii hakkunde maɓɓe, onsay Petruusu hawtii, wi'i ɓe: «Musiɓɓe, hiɗon andi wonde, gila ka ɲalaaɗe arane, Allaahu on suɓino lan e hakkunde mon fii no ɓe wonaa Yahuudiyanke ɓen nanira daaluyee Kibaaru Moƴƴo on, ɓe gomɗina. ");
INSERT INTO fuf_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Alla, on Anduɗo ko woni e ɓerɗe, o seeditoranike ɓe yeɗugol ɓe *Ruuhu Seniiɗo on wano men non. ");
INSERT INTO fuf_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","O waɗaali hay fus ko serti hakkunde men e maɓɓe, ko fii ko gomɗinal maɓɓe ngal o laɓɓiniri ɓerɗe maɓɓe ɗen. ");
INSERT INTO fuf_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Jooni non, ko honɗun ndarndoranton Alla rondugol taalibaaɓe ɓen dongal ngal enen tigi e baabiraaɓe men ɓen en waawaali townude? ");
INSERT INTO fuf_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Kono ko moƴƴere Iisaa Joomi on tanƴinorɗen dandeede, kamɓe kadi-le wano non.» ");
INSERT INTO fuf_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Onsay mbatu ngun fow deƴƴiti, ɓe heɗii Barnabaasi e Puulusa, ɓen fillitanii ɓe kala maandeeji e kaawakeeji moƴƴi ɗi Allaahu on waɗini ɓe e hakkunde ɓe wonaa Yahuudiyanke ɓen. ");
INSERT INTO fuf_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Ɓay ɓe gaynii yewtude, Yaaquuba kadi ƴetti haala kan, wi'i: «Heɗee lan yo musiɓɓe an! ");
INSERT INTO fuf_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","En nanii ko Sim'uunu Petruusu fillitanii en kon, ko honno Allaahu on haajiraa e ɓe wonaa Yahuudiyanke ɓen gila ka fuɗɗoode, o ƴetti jamaa e hakkunde maɓɓe ko wona e innde makko. ");
INSERT INTO fuf_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Konguɗi annabaaɓe ɓen no fotti e ɗun-le, ko fii no windii: ");
INSERT INTO fuf_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‹Ɓawto ɗun mi artoyay, mi ɓanta suudu laamu Daawuuda yanunoondu ndun, mi ɓanta kadi ko yirbi kon, mi fewna, ");
INSERT INTO fuf_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","fii no yimɓe heddiiɓe ɓen ɗaɓɓira Joomiraaɗo on, e kala leƴƴi ɗi innde an nden jantaa e mun. ");
INSERT INTO fuf_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Ko Joomiraaɗo on daali ɗun, on Waɗunooɗo ɗii piiji andanooɗi gila ko ɓooyi.› » ");
INSERT INTO fuf_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Yaaquuba wi'i kadi: «Ko ɗun waɗi si mi miijii wonde moƴƴaa ka sincanen ɓen ɓe wonaa Yahuudiyanke tuubanɓe Alla satteende. ");
INSERT INTO fuf_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Kono windanen ɓe tun, wi'en ɓe yo ɓe terto tuunintinorgol sanamuuji e jinaa e ɲaamugol jiibe e ƴiiƴan. ");
INSERT INTO fuf_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Ko fii, gila e ɗiya jamaanuuji feƴƴuɗi, Muusaa no mari yimɓe e saare kala ko waajoo fii makko, ɓay hiɗen jangude fii ɗun e aseweere kala ka juulirɗe.» ");
INSERT INTO fuf_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Onsay sahaabaaɓe ɓen e ardotooɓe moftal ngal e moftal ngal fow ndaari tawi no moƴƴi ka ɓe suɓa woɓɓe e hakkunde maɓɓe, ɓe wattida ɓe e Puulusa e Barnabaasi fii ko yaha Antiyoosi-Sirii. Onsay ɓe suɓii Yahuuda, jammaaɗo Barsabaa, e Silaasi, tawi ɓen ɗiɗo ko ɓe ɓe musiɓɓe ɓen teddini fota. ");
INSERT INTO fuf_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ɓe wattidi ɓe e ɓatakuru ndu tawata ko ɗunɗoo windii ton: «Menen ɓee musiɓɓe mon, ɗun ko sahaabaaɓe ɓen e ardotooɓe moftal ngal, men salminii on onon ɓee musiɓɓe amen wonɓe e hakkunde ɓee ɓe wonaa Yahuudiyanke, hoɗuɓe Antiyoosi-Sirii e Sirii e Silisii. ");
INSERT INTO fuf_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","«Men nanii wonde woɓɓe e amen jiiɓiroyii on konguɗi maɓɓe haa ɓe aaninii wonkiiji mon ɗin, ɓen-le wonaa menen yamiri ɓe ɗun. ");
INSERT INTO fuf_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Men taw no moƴƴi, e nder nanondiral amen, ka men suɓoo woɓɓe, men immindinana on ɓe e ɓee yiɓɓe amen, ɗun ko Barnabaasi e Puulusa, ");
INSERT INTO fuf_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ɗun ko ɓee weeɓituɓe ngurndan mun ɗan fii innde Iisaa Almasiihu Joomi men on haa takko mayde. ");
INSERT INTO fuf_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Ko men imminiri Yahuuda e Silaasi, ko ko yewta on e hunduko fii ko woni kon ka ɓatakuru. ");
INSERT INTO fuf_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Ko fii menen e Ruuhu Seniiɗo on men taw no moƴƴi ka men ronka on fawude dongal goo, si hinaa ɗii haanuɗi ɗoo: ");
INSERT INTO fuf_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","ɗun non ko yo on terto tebbeeli sakkanaaɗi sanamuuji e ƴiiƴan e mummunteeji jiibuɗi e jinaa. Si on reenike e ɗun, haray on waɗii ko moƴƴi. Yo jam wonu e mon!» ");
INSERT INTO fuf_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Onsay kamɓe imminaaɓe ɓen ɓe waynii, ɓe yahi Antiyoosi-Sirii, ɓe wattoyi ɓatakuru ndun e juuɗe mbatu mooɓiingu ɗon ngun. ");
INSERT INTO fuf_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Ɓay ɓatakuru ndun jangaama, ɓe weltori kon ko ɓe wakkilinaa. ");
INSERT INTO fuf_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Nde tawnoo Yahuuda e Silaasi ko haalooɓe ko Alla longini ɗun, ɓe ɓeydi wakkilinde musiɓɓe ɓen, ɓe tiiɗiniri ɓe kadi konguɗi buy. ");
INSERT INTO fuf_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Ɓay ɓe neeɓidii e maɓɓe seeɗa, musiɓɓe ɓen newnitani ɓe ruttagol ka imminnooɓe ɓe ɓen e dow ɓuttu. ");
INSERT INTO fuf_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Kono Silaasi kaɲun tawi luttugol mo ton no moƴƴi. ");
INSERT INTO fuf_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Puulusa kadi e Barnabaasi lutti koɗaade Antiyoosi-Sirii ɗon e jannugol feɲɲindina e yimɓe buy fii daaluyee Joomiraaɗo on. ");
INSERT INTO fuf_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Balɗe seeɗa ɓawto ɗun, Puulusa wi'i Barnabaasi: «Yiltitoɗen, ndartoyen musiɓɓe ɓen e nder ca'e ɗe waajiɗen fii daaluyee Joomiraaɗo on e mun ɗen fow, fii andugol ko honno ɓe fewndori.» ");
INSERT INTO fuf_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Tawi Barnabaasi no faalaa yo ɓe yaadu e Yuuhanna jammaaɗo Markuusa. ");
INSERT INTO fuf_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Kono Puulusa ndaari tawi haanaa ka ɓe yaada e on yiltinooɗo ɓaawo maɓɓe gila Pamfilii, salii ɓe ɗowtude ka golleeji maɓɓe. ");
INSERT INTO fuf_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Hakkee yeddondiral ngal tiiɗii hakkunde maɓɓe, ɓe sakkitori seedugol. Onsay Barnabaasi ƴetti Markuusa, ɓe bakii ɗon e laana ndiyan fii yahugol Siipuru. ");
INSERT INTO fuf_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Puulusa kaɲun suɓii Silaasi ko o yaada, ɓawto musiɓɓe ɓen halfinde mo kanko Puulusa sulfu Joomiraaɗo on. ");
INSERT INTO fuf_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Onsay ɓe yahi, ɓe taƴitoyi Sirii e Silisii, e hoore hiɓe tiiɗina mofte ɗen. ");
INSERT INTO fuf_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Kanko Puulusa o hewtoyi kadi Derbata e Listaara, o tawi no ɗon taalibaajo wi'eteeɗo Timotee. Tawi on yumma mun ko Yahuudiyankeejo gomɗinɗo, kono ben makko ko *Gereekiyankeejo. ");
INSERT INTO fuf_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Tawi musiɓɓe ɓe Listaara e ɓe Ikoniim ɓen no joganii mo kanko Timotee kongol moƴƴol. ");
INSERT INTO fuf_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Tawi Puulusa no faalaa naɓorde mo. Onsay o ƴetti mo, o sunnini sabu Yahuudiyankeeɓe wonɓe e ɗin nokkeeli ɗon ɓen, ko fii hari fow no andi wonde ben makko kanko Timotee ko Gereekiyankeejo. ");
INSERT INTO fuf_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Tawi kanko Puulusa e Timotee, hiɓe hollitude e nder ca'e ɗe ɓe rewi e mun ɗen, pehe ɗe *sahaabaaɓe ɓen e ardotooɓe *moftal ngal Yerusalaam ƴetti ɗen fii yo ɗe huutore. ");
INSERT INTO fuf_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Tawi mofte ɗen no tiiɗude tun e nder gomɗinal ngal, awa kadi hiɓe ɓeydaade ɗuuɗugol ɲande woo ɲande. ");
INSERT INTO fuf_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Nde tawnoo *Ruuhu Seniiɗo on newnanaali ɓe feɲɲinoygol daaluyee on e nder *Aazii on, ɓe yahi ɓe taƴitoyi Firgii wondude e leydi Galaasi ndin. ");
INSERT INTO fuf_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Ɓay ɓe hewtii takko Misii, ɓe etii fii yahugol Bitinii, kono laatii Ruuhu Iisaa on newnanaali ɓe. ");
INSERT INTO fuf_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Onsay ɓe taƴitiri Misii ɗon, ɓe yahi Turuwaasi. ");
INSERT INTO fuf_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","E nder jemma on, kanko Puulusa o yi'i e nder koyɗol, goɗɗo mo Masedonii no darii no jeeja mo, wi'a: «Rewu Masedonii gaa, faaboɗaa men!» ");
INSERT INTO fuf_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Ɓawto ngol koyɗol Puulusa, men ɗaɓɓi kisan feere no men hewtira Masedonii, sabu meɗen felliti ko Alla noddi men ton, fii yo men waajo fii Kibaaru Moƴƴo on. ");
INSERT INTO fuf_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Ɓawto ɗun, men bakii Turuwaasi ɗon e laana ndiyan, men sutori Samotiraasi. Bimbi nden ɲande kadi men sutori Neyapolii. ");
INSERT INTO fuf_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Ɓay men iwii ɗon, men yahi Filipii, ɗun ko saare wonde e diiwal aranal ngal ka leydi Masedonii, jeyaande e ley laamu Roomu, men woni Filipii ɗon e nder balɗe. ");
INSERT INTO fuf_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Ɲande *ɲalaande fowteteende nden, ɗun ko *aseweere nden, men yahi e binde caangol, ɗun ko ka ɓaawo saare, ka men tanƴininoo ko ɗon wonnoo ka juuletee. Ɓay men jooɗike, men yewti rewɓe mooɓinooɓe ɗon ɓen. ");
INSERT INTO fuf_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Tawi no e ɓen debbo rewoowo Alla, on no wi'ee Linda, jeyaaɗo e ndee saare wi'eteende Saayatiira, yeeyoowo gaara baka. Tawi himo heɗinoo, Joomiraaɗo on kadi udditi ɓernde makko nden fii yo o wonan ko Puulusa yewtaynoo kon. ");
INSERT INTO fuf_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Ɓay o *lootidaama e ɓeynguure makko nden maande kisiyee, o saatini men e hoore himo wi'a: «Si tawii hiɗon jogori lan wa gomɗinɗo Joomi on, haray naatee ka suudu an, weeron ka ɓeynguure an ɗoo.» O jeeji men e ɗun haa men jaɓi. ");
INSERT INTO fuf_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Ɓawto ɗun, ko men yahata ka juuletee ɗon, korɗo mo jinnawii *hiitinoowii nangi, ari fotti e amen, tawi kon ko o hiitotonoo no okkoraynoo jeyɓe mo ɓen jawle buy. ");
INSERT INTO fuf_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","O woni e jokkugol men, menen e Puulusa, e hoore himo ewnoo, wi'a: «Ɓee yimɓe ko kurkaaɗi Alla Jom Ɓural on, awa hiɓe feɲɲinande on laawol kisiyee on!» ");
INSERT INTO fuf_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","O waɗi ɗun e nder balɗe buy. Ɓay Puulusa haaɓii ɗun, o yeƴƴitii, o wi'i ngin jinnawii: «Mi yamirii ma e innde Iisaa Almasiihu on, yaltu e oo debbo!» Jinnawii ngin yalti e makko e on saa'i tigi. ");
INSERT INTO fuf_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Ɓay jeyɓe kurkaadu ndun tawii ka ɓe tanƴininoo heɓugol ɗon bonii, ɓe nangi Puulusa e Silaasi, ɓe pooɗi ɓe, ɓe addi yeeso hooreeɓe ɓen ka nokkuure fottirde. ");
INSERT INTO fuf_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Onsay ɓe addi ɓe ka ɲaawooɓe ɓen, ɓe wi'i: «Ɓee yimɓe ko Yahuudiyankeeɓe, hiɓe jiiɓude saare men nden, ");
INSERT INTO fuf_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ɓe janna naamuuji ɗi en newnanaaka jaɓugol maa waɗugol, enen ɓee jeyaaɓe e laamateeri Roomu!» ");
INSERT INTO fuf_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Jamaa on kadi immanii ɓe kamɓe ɗiɗo. Ɓay ɲaawooɓe ɓen waɗii haa ɓe ɓortii ɓe dolokkaaji ɗin, ɓe yamiri yo ɓe luubor ɓe bedi. ");
INSERT INTO fuf_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Ɓay ɓe gaynii ɓe luubaade, ɓe bugii ɓe ka kaso. Ɓe yamiri aynuɗo kaso on yo o jogo ɓe, o ayna fota. ");
INSERT INTO fuf_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","On yamiraaɗo ɗun bugii ɓe ka nder kaso nder-nderwo, o dumbi ɓe ka koyɗe. ");
INSERT INTO fuf_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Ɓay wonii tumbere jemma, Puulusa e Silaasi woni e toragol Alla, beytana mo. Tawi kasooɓe ɓen no heɗii ɓe. ");
INSERT INTO fuf_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Tun, nde wootere leydi ndin dimbii ko tiiɗi, didoodi kaso ngon yergi. E on saa'i tigi baafe kaso ngon fow udditii, jolokooje ɗe kasooɓe ɓen jolkanoo ɗen kadi jolkitii. ");
INSERT INTO fuf_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Aynuɗo kaso ngon fini. Ɓay o yi'ii baafe kaso ngon udditike, o sorti kaafa makko kan fii wartagol, ko fii hari himo sikka kasooɓe ɓen dogii. ");
INSERT INTO fuf_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Kono Puulusa ewnii mo e hawa tiiɗuka, wi'i: «Wota a waɗito bone woo! Men fow meɗen ɗoo!» ");
INSERT INTO fuf_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Onsay kanko aynuɗo kaso ngon o torii ndaygu, o wubbi o naati, o yani yeeso Puulusa e Silaasi e hoore himo diwna. ");
INSERT INTO fuf_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Onsay o yaltini ɓe ka yaasi, o wi'i: «Koohooɓe, ko honɗun mi waɗata fii yo mi dande?» ");
INSERT INTO fuf_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ɓe jaabii mo, ɓe wi'i: «Gomɗin Iisaa Joomi on, ɗun a dandete, an e ɓeynguure maa nden.» ");
INSERT INTO fuf_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Onsay ɓe feɲɲindinani mo e kala wonɗo ka suudu makko daaluyee Joomiraaɗo on. ");
INSERT INTO fuf_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Kanko kadi o ƴetti ɓe e on saa'i tigi e nder on jemma, o lootani ɓe barmeeji maɓɓe ɗin. E on saa'i tigi kanko kadi o *lootaa maande kisiyee, kanko e yimɓe suudu makko ndun fow. ");
INSERT INTO fuf_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","O werni ɓe ka suudu makko, o ɓannani ɓe ɲaametee, o weltodi e ɓeynguure makko nden fow fii ko ɓe gomɗini Alla kon. ");
INSERT INTO fuf_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Ɓay weetii, ɲaawooɓe ɓen immini mbatulaaɓe mun ɓen ko yaha wi'a aynuɗo kaso on: «Accitu ɓen yimɓe.» ");
INSERT INTO fuf_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Onsay aynuɗo kaso on fillitanii Puulusa kon ko ɓe wi'i, o wi'i mo: «Ɲaawooɓe ɓen imminii woɓɓe ko wi'ammi yo mi accitu on. Jooni yaltee, yahon e hoore ɓuttu.» ");
INSERT INTO fuf_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Kono Puulusa wi'i ɓen mbatulaaɓe: «Ɓay ɓe foccii men ka tumbere mbatu e ɓaawo ɲaawugol men, menen ɓee jeyaaɓe e laamateeri Roomu, e hoore ɗun ɓe bugike men ka kaso, e hara jooni ɓe yaltinay men ka kene e dow gundoo? Waawaa wonude! Kamɓe tigi yo ɓe aru, ɓe yaltina men!» ");
INSERT INTO fuf_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Onsay ɓen mbatulaaɓe yahi hollitoyi ɗun ɲaawooɓe ɓen. Ɓen huli ɓay ɓe andii ɓen ko jeyaaɓe e laamateeri Roomu. ");
INSERT INTO fuf_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Onsay ɓen ari, ɓe jeeji ɓe, ɓe acciti ɓe, ɓe torii ɓe kadi yaltugol saare nden. ");
INSERT INTO fuf_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Ɓay ɓe yaltii ka kaso, ɓe naatiri ka oo debbo wi'eteeɗo Linda, ɓe yiidi e musiɓɓe ɓen, ɓe wakkilini ɓe. Onsay ɓe yahi. ");
INSERT INTO fuf_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Ɓe rewoyi Amfipolii e Apolonii, ɓe hewti Tesalonii ka Yahuudiyankeeɓe ɓen mari juulirde ɗon. ");
INSERT INTO fuf_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Puulusa naati ɗon wano woowirani mo non, o wondi e maɓɓe e nder aseweeje tati, himo yewtidude e maɓɓe fii ko bindi ɗin wi'i kon. ");
INSERT INTO fuf_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","O sifii, o weeɓiti wonde *Almasiihu on no haanunoo tampude e immintineede kadi e hakkunde mayɓe ɓen, o wi'i ɓe: «Iisaa oo mo mi woni on wowlande fii mun, ko on woni Almasiihu on.» ");
INSERT INTO fuf_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Woɓɓe e maɓɓe hoolii ɗun, ɓe tawti Puulusa e Silaasi, e hoore ɗun *Gereekiyankeeɓe ɗuuɗuɓe rewooɓe Alla, e rewɓe buy jeyaaɓe e ɓurɓe teddude ɓen kadi hoolii. ");
INSERT INTO fuf_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Kono Yahuudiyankeeɓe ɓen nawli ɗun, ɓe ƴetti woɓɓe e bonɓe wonɓe ka fottirde ɓen, ɓe wattidi e maɓɓe, ɓe waɗi haa sonko waɗi e nder saare nden e haa yimɓe ɓen dilliri hen fow. Ɓe yahi ka suudu oo wi'eteeɗo Yaasuunu fii ɗaɓɓitugol Puulusa e Silaasi ɓe adda ɓe e yeeso jamaa on. ");
INSERT INTO fuf_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Laatii ɓe tawaali ɓe ton. Onsay ɓe pooɗi Yaasuunu e musiɓɓe goo, ɓe addi ɓe yeeso hooreeɓe saare nden, e hoore hiɓe sonka, wi'a: «Ɓee jiiɓuɓe aduna on fow arii ɗoo kadi, ");
INSERT INTO fuf_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Yaasuunu wernii ɓe! Ɓe fow hiɓe dartaade yamirooje lanɗo mawɗo Roomu on, e hoore hiɓe wi'a lanɗo goo no woodi wi'eteeɗo Iisaa.» ");
INSERT INTO fuf_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Ɗin konguɗi jiɓi jamaa on e ɲaawooɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Laatii ɓe accitude Yaasuunu e ɓeya woo nde ɓe yoɓunoo alamaani. ");
INSERT INTO fuf_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","E on jemma kisan musiɓɓe ɓen watti Puulusa e Silaasi e laawol Biriyata. Ɓay ɓen hewtoyii, ɓe naatiri ka juulirde Yahuudiyankeeɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Tawi ɓerɗe ɓen ɗen no ɓuri ɓe Tesalonii ɓen udditaade. Ɓe jaɓiri daaluyee on heɲaare tiiɗunde e hoore hiɓe taskotonoo ɲande woo bindi ɗin fii andugol ko ɓe wi'aa kon si ko non woniri. ");
INSERT INTO fuf_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Onsay buy e hakkunde maɓɓe gomɗini, ɓe gomɗindini e rewɓe Gereekiyankeeɓe tedduɓe e worɓe Gereekiyankeeɓe ɗuuɗuɓe. ");
INSERT INTO fuf_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Kono nde Yahuudiyankeeɓe ɓe Tesalonii ɓen andunoo wonde Puulusa no feɲɲinde kadi daaluyee Alla on Biriyata, ɓen kadi ari, ɓe memmini jamaa on, ɓe jiiɓindiri. ");
INSERT INTO fuf_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Kisan, musiɓɓe gomɗinɓe ɓen waɗi feere no Puulusa yaara ka daande baharu, kono Silaasi e Timotee kaɲun lutti ɗon. ");
INSERT INTO fuf_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Ɓen wonnooɓe ɗowtude Puulusa, ɓe ardii mo haa Atiina. Onsay ɓen yiltitii, ɓay ɓe yamiraama wi'ugol Silaasi e Timotee wonde yo ɓen tawtoy mo ko yaawi. ");
INSERT INTO fuf_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Nde tawnoo Puulusa no habbii ɓeya Atiina, tawi ɓernde makko nden no aani fota kon ko o yi'aynoo saare nden no jokki sanamuuji. ");
INSERT INTO fuf_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Onsay o yewtidi e Yahuudiyankeeɓe ɓen e rewooɓe Alla ɓen ka juulirde e yimɓe fottaynooɓe ɓen ka nokkuure fottirde nden, ɗun non tawi ko ɲande woo. ");
INSERT INTO fuf_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Faamuɓe goo e nder fedde Epikuriiɓe ɓen e fedde Sitoyikiiɓe ɓen nangi e yewtidugol e makko. Onsay woɓɓe e maɓɓe wi'i: «Ko honɗun oo wowloowo faalaa wowlude?» Tawi woɓɓe e maɓɓe no wi'a: «Himo wa'i wa waajotooɗo fii allaaɓe jananɓe goo.» Tawi ɗun fow ko fii himo waajaade fii Iisaa e kibaaru mun moƴƴo on e fii ummutal ngal. ");
INSERT INTO fuf_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Onsay ɓe ƴetti mo, ɓe naɓi ka mbatirde wi'eteende Areyopaasi, ɓe wi'i mo: «A waaway men andinde ko honɗun woni ndee jannde heyre nde wonɗaa wowlude fii mun? ");
INSERT INTO fuf_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Ko fii hiɗa waɗude e noppi amen piiji ɗi men woowaa nanude, meɗen faalaa andude ko honɗun woni ɗun.» ");
INSERT INTO fuf_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Tawi ɓe Atiina ɓen fow e hoɓɓe wondunooɓe e maɓɓe ɓen ko jokkunoo woo ko wowlugol maa heɗagol piiji hesi. ");
INSERT INTO fuf_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Onsay Puulusa darii ka tumbo mbatirde, o wi'i: «Ko onon yo ɓe Atiina, mi ndaarii e cenɗe ɗen fow, mi tawii ko on ɓe diina fota. ");
INSERT INTO fuf_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Awa kadi e nder ko mi feƴƴata kon, mi yi'ii kala ko rewoton, e hay mi yi'ii *layyorde ka ɗunɗoo windii: ‹Ko ko allaajo mo andaaka.› Ɗun ko on mo wonɗon teddinde, mo tawata on andaa, mi woni on feɲɲinande. ");
INSERT INTO fuf_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Ɗun ko on Alla taguɗo aduna on e kala ko woni e mun, on wonɗo Joomiraaɗo kammuuli ɗin e leyɗeele ɗen, on ko mo hoɗataa e nder juulirɗe ɗe yimɓe moƴƴiniri juuɗe mun. ");
INSERT INTO fuf_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Hinaa neɗɗanke waɗanta mo, wa si tawii himo hatonjini e goɗɗun, ko on woni Yeɗoowo mo kala ngurndan e poopaali e kala huunde. ");
INSERT INTO fuf_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Ko immorde e aaden gooto o tagiri leƴƴi neɗɗanke ɗin fow, yo ɓen hoɗu e hoore ndelo leydi ndin fow. Awa o happiino saa'iiji maɓɓe ɗin e ittiri ko ɓe hoɗata e mun kon, ");
INSERT INTO fuf_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","fii no ɓe ɗaɓɓira Alla, ɓe yi'a mo si no hawri e nder memugol, fii kala o woɗɗaaki hay gooto e men. ");
INSERT INTO fuf_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Ko fii ko kanko heɓirɗen ngurndan, waawirɗen memminaade, ko e makko kadi woodaɗen. Ko ɗun yuɓɓooɓe gimɗi mon goo no wi'i: ‹Ko en fayɓe makko kadi.› ");
INSERT INTO fuf_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","«Ɓay non ko en fayɓe Alla, haanaa ka miijoɗen wonde Alla no nandi e kaŋŋe e kaalisi maa e kaaƴe lesaaɗe fotinaa, hara ko e immorde e miijo neɗɗanke. ");
INSERT INTO fuf_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Hari Allaahu on jogoraano yimɓe ɓen ko ɓe andaano mo kon, kono jooni o daalanii yimɓe ɓen fow e nder nokkeeli ɗin fow yo ɓe tuubu. ");
INSERT INTO fuf_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Ko fii o happii ɲalaande nde o ɲaawirta aduna on peewal, rewrude e on neɗɗo mo o toɗɗii, ɗun ko on mo o waɗirani fow seedee timmuɗo immintingol mo e hakkunde mayɓe ɓen.» ");
INSERT INTO fuf_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Nde ɓe nanunoo himo wowla fii ummutal mayɓe ɓen, woɓɓe e maɓɓe jali mo, woɓɓe ɓen wi'i: «Men heɗoto ma ɲande goo fii ɗun.» ");
INSERT INTO fuf_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Onsay kanko Puulusa o sortii hakkunde maɓɓe. ");
INSERT INTO fuf_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Kono fow e mun, ɗun haɗaali woɓɓe humoo e makko, gomɗina. Tawi no tawaa e ɓen oo wi'eteeɗo Denuusi, tawdaaɗo e dental fewjooɓe Areyopaasi ɓen, e debbo no wi'ee Damaari, kaɲun e woɓɓe goo kadi. ");
INSERT INTO fuf_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Ɓawto ɗun, Puulusa iwi Atiina, o yahi Korenti. ");
INSERT INTO fuf_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","O tawi ɗon Yahuudiyankeejo wi'eteeɗo Akiila, mo iwdi mun woni Pontii, tawi neeɓaali ko on yaltidi e sonna mun Piriskiila leydi Italii, sabu ko Kuloodiyuusu lanɗo Roomu on yamiri Yahuudiyankeeɓe ɓen fow yaltugol Roomu kon. Onsay Puulusa yahi yiidoyi e maɓɓe, ");
INSERT INTO fuf_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","ɓay tawii ko mecce goote ɓe mari, o weeri ka maɓɓe, ɓe woni e gollidugol. Tawi ko wonnoo mecce maɓɓe ko moƴƴingol cuuɗi bagi. ");
INSERT INTO fuf_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Tawi kanko Puulusa himo yewtaynoo yewtereeji e aseweere kala ka juulirde fii fellintingol Yahuudiyankeeɓe ɓen e *Gereekiyankeeɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Kono ɓay Silaasi e Timotee iwii Masedonii hewtii, Puulusa jokkii e daaluyee on tun e seeditanagol Yahuudiyankeeɓe ɓen wonde ko Iisaa woni *Almasiihu on. ");
INSERT INTO fuf_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Kono nde tawnoo Yahuudiyankeeɓe ɓen no liddaade mo, hoyna, o fiɗɗi conci makko ɗin, o wi'i ɓe: «Yo ƴiiƴan mon ɗan yantu e hoore mon, min mi laaɓii. Kono gila jooni ko ka ɓe wonaa Yahuudiyanke ɓen mi yaarata.» ");
INSERT INTO fuf_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","O iwi ɗon, o yahi e suudu aaden rewoowo Alla no wi'ee Titiyuusu Yustuusa, tawi kadi suudu makko ndun no ɓadondiri e juulirde nden. ");
INSERT INTO fuf_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Onsay oo wi'eteeɗo Kirispuusa, ɗun ko ardiiɗo juulirde nden, kaɲun e ɓeynguure mun nden fow gomɗini Joomi on. Korentiyankooɓe ɗuuɗuɓe kadi heɗotonooɓe Puulusa gomɗini, *lootaa maande kisiyee. ");
INSERT INTO fuf_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Ɓawto ɗun, Joomiraaɗo on daalani Puulusa e nder jemmaare goo e nder koyɗol, o wi'i mo: «Wota a hulu, yewtu, wota a fanku. ");
INSERT INTO fuf_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Ko fii min miɗo wondi e maa, gooto fawataa ma jungo fii waɗugol ma ko boni, ko fii miɗo mari jamaa ɗuuɗuɗo e nder ndee saare ɗoo.» ");
INSERT INTO fuf_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Onsay kanko Puulusa o daakii hakkunde maɓɓe e nder hitaande e lebbi jeegoo, himo janna daaluyee Alla on. ");
INSERT INTO fuf_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Wa fewndo on saa'i tawi ko Galiyuunu lamminaa Akaaya. Onsay Yahuudiyankeeɓe ɓen immanii Puulusa e nder nanondiral maɓɓe, ɓe addi mo ka yeeso ɲaawirdu, ");
INSERT INTO fuf_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","e hoore hiɓe wi'a: «Oo neɗɗo no fellintinde yimɓe ɓen no ɓe rewira Alla e noone no woopondiriri e Sariya on!» ");
INSERT INTO fuf_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Fewndo ko Puulusa udditata hunduko mun kon, tawi Galiyuunu wi'ii Yahuudiyankeeɓe ɓen: «Ko onon yo Yahuudiyankeeɓe, si tawiino ko angal peewal goo maa bonnere goo, mi heɗotono on e hoore no newori. ");
INSERT INTO fuf_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Kono ɓay ko yeddondiral fii haalaaji e fii inɗe e sariyaaji mon onon tigi, yo ɗun wonu haaju mon. Mi faaletaake wonande on ɲaawoowo ɗun.» ");
INSERT INTO fuf_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Onsay o yaltini ɓe ka ɲaawirdu. ");
INSERT INTO fuf_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Tun, ɓe fow ɓe nangi Sosteene, ɗun ko ardiiɗo juulirde nden, ɓe woni e piyugol mo ka yeeso ɲaawirdu. Tawi Galiyuunu haajaaka e ɗun. ");
INSERT INTO fuf_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Laatii Puulusa daakii Korenti ɗon kadi ko neeɓi. Ɓawto ɗun, o waynitii musiɓɓe ɓen. Onsay o fembii ka wi'etee ɗon Kenkere, sabu himo woondunoo woondoore. Ontuma o bakodi e Piriskiila e Akiila e laana ndiyan fii Sirii. ");
INSERT INTO fuf_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Ɓe hewti Efeesi. Puulusa acci ɗon ɓe o wondunoo ɓen, o naatoyi ka juulirde, o yewtidi e Yahuudiyankeeɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Ɓen torii mo wonugol ɗon seeɗa, kono laatii o jaɓaali. ");
INSERT INTO fuf_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","O waynitii ɓe, o wi'i: «Mi aroyay ka mon si Allaahu on jaɓii.» Ɓay o iwii Efeesi ɗon e laana ndiyan, ");
INSERT INTO fuf_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","o tippoyii Seezariiya. O yahi, o hiwroyii *moftal ngal, onsay o yahi Antiyoosi-Sirii. ");
INSERT INTO fuf_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Ɓay o wonii ɗon seeɗa, o yiltitii, o jindi e ca'e Galaasi e Firgii ɗen, o wakkilini taalibaaɓe ɓen fow. ");
INSERT INTO fuf_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Ɓawto ɗun, Yahuudiyankeejo waawuɗo haala, anduɗo kadi bindi daaluyee on, wi'eteeɗo Apoloosi jeyaaɗo Aleksandiri hewti Efeesi. ");
INSERT INTO fuf_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Tawi on no jangi fii laawol Joomi on, himo wowliraynoo jiɲo tiiɗungo, himo feɲɲinaynoo kadi janna no feewiri fii Iisaa, tawi e hoore ɗun fow ko ko Yaayaa lootaynoo kon tun o andi. ");
INSERT INTO fuf_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Onsay o yewtiri pellital ka nder juulirde. Ɓay Piriskiila e Akiila heɗike mo, ɓe yaadi e makko, ɓe feɲɲinanoyi mo no woniri non tigi fii laawol Alla ngol. ");
INSERT INTO fuf_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Kono ɓay tawii Apoloosi no faalanoo yahugol Akaaya, musiɓɓe ɓen wakkilini mo, ɓe windani kadi taalibaaɓe ɓen wonde yo ɓe wernu mo no moƴƴiri. Ɓay o hewtii ɗon, o nafi ɓen gomɗinirɓe sabu sulfu Alla on, ");
INSERT INTO fuf_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","e hoore himo yeddondiraynoo e Yahuudiyankeeɓe ɓen ka tumbondiral no tiiɗiri, e himo ɓanginira bindi ɗin wonde ko Iisaa woni Almasiihu on. ");
INSERT INTO fuf_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Fewndo ko Apoloosi on woni Korenti, tawi Puulusa kaɲun taƴitoyii leyɗe dowje ɗen, haa o hewtoyii Efeesi, o fotti ɗon e taalibaaɓe goo. ");
INSERT INTO fuf_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","O wi'i ɓen: «Hara on heɓii Ruuhu Seniiɗo on wa ko gomɗinɗon?» Ɓen jaabii mo, ɓe wi'i: «Menen hari hay men nanaali wonde Ruuhu Seniiɗo no woodi.» ");
INSERT INTO fuf_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Onsay o wi'i ɓe: «Awa ko honno lootiranoɗon?» Ɓen kadi jaabii mo, wi'i: «Ko no Yaayaa lootiraynoo non.» ");
INSERT INTO fuf_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Puulusa wi'i: «Yaayaa ko fii tuubuubuyee looti, e hoore ɗun himo wi'aynoo yimɓe ɓen yo ɓe gomɗin aroyoowo ɓaawo makko on, ɗun ko Iisaa.» ");
INSERT INTO fuf_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Ɓay ɓe nanii ɗin konguɗi makko, ɓe *lootaa maande kisiyee e innde Iisaa Joomi on. ");
INSERT INTO fuf_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Onsay Puulusa *fawi juuɗe mun ɗen e hoore maɓɓe, Ruuhu Seniiɗo on ari e maɓɓe, ɓe woni e wowlugol e *haalaaji janani, wowla ko Alla longini ɓe. ");
INSERT INTO fuf_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Tawi ɓen yimɓe ko wa ɓe sappoo e ɗiɗo. ");
INSERT INTO fuf_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Onsay Puulusa naati ka juulirde, o yewtiri ɗon pellital. E nder lebbi tati himo yewtidude e maɓɓe o fellintinana ɓe ko yowitii e fii *laamu Alla ngun. ");
INSERT INTO fuf_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Kono ɓay woɓɓe wonii e sattinkinagol e angal gomɗingol e aybingol laawol Joomi on e hakkunde jamaa on, o sortii hakkunde maɓɓe, o ƴetti taalibaaɓe ɓen o waɗi ɓe feere, o woni e yewtidugol e maɓɓe ɲande woo ka duɗal oo wi'eteeɗo Tiranuusu. ");
INSERT INTO fuf_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Ɗun neeɓi yeru duuɓi ɗiɗi, haa kala hoɗuɗo *Aazii humpitii fii daaluyee Joomiraaɗo on, ɗun ko Yahuudiyankeeɓe ɓen e *Gereekiyankeeɓe ɓen fow. ");
INSERT INTO fuf_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Tawi Allaahu on no waɗaynoo kaawakeeji moƴƴi hawniiɗi rewrude e Puulusa, ");
INSERT INTO fuf_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","haa ka tawata hiɓe yahaynoo ɓe ƴetta disaaje maa lince ɗe Puulusa meemaynoo ɗen, ɓe adda, ɓe waɗa e nawnuɓe ɓen, ɓen ndikka, jinnaaji bonɗi ɗin kadi yalta e maɓɓe. ");
INSERT INTO fuf_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Yahuudiyankeeɓe goo, jindaynooɓe wi'a no raɗoo jinna, woni e jantagol e hoore ɓen ɓe jinnaaji woni e mun innde Iisaa Joomi on, hara hiɓe wi'a: «Mi yamirii on yaltugol e innde Iisaa, on mo Puulusa woni waajaade fii mun!» ");
INSERT INTO fuf_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Tawi ɓen waɗaynooɓe ɗun ko ɓe njeeɗiɗo, ɓen-le ko ɓe ɓiɓɓe oo wi'eteeɗo Sekubaa, tawaaɗo e hooreeɓe *yottinooɓe sadaka Yahuudiyankeeɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ngin jinnawii jaabii ɓe, wi'i: «Miɗo andi Iisaa, miɗo andi kadi ko hombo woni Puulusa, kono onon ko on homɓe?» ");
INSERT INTO fuf_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Onsay on neɗɗo mo ngin jinnawii woni e mun yani e maɓɓe, o waawi ɓe fow e hoore doole tiiɗuɗe, haa ɓen dogi yalti e ndun suudu ɓe ɓornaaki, e hoore hiɓe barminaa. ");
INSERT INTO fuf_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Kala Yahuudiyankeejo e Gereekiyankeejo hoɗuɗo Efeesi andi fii ɗun, kulol nangi ɓe ɓe fow, onsay innde Iisaa Joomi on mawninaa. ");
INSERT INTO fuf_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Onsay buy e aruɓe e gomɗinde ari qirritii, weeɓiti boneeji ɗi ɓe waɗunoo. ");
INSERT INTO fuf_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Ɓawto ɗun, yimɓe buy waɗaynooɓe mbilankaaku, addi defte mun, ɓe sunni ɗe yeeso fow. Coggu majje on jittaa, tawaa ko tammaaji kaalisi guluuji cappanɗe jowi. ");
INSERT INTO fuf_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Ko nii, daaluyee Joomiraaɗo on woni layirde semba e hoore doole. ");
INSERT INTO fuf_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Ɓawto ɗun Puulusa eɓɓani fii yahugol Yerusalaam, hara ko Masedonii e Akaaya o rewri. O wi'i: «Si mi iwii ɗon, bee mi hewtoya Roomu.» ");
INSERT INTO fuf_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Onsay o immini wallindirteeɓe makko ɗiɗo Masedonii, ɗun ko Timotee e Arastuusa, kanko o luttiti Aazii ɗon seeɗa. ");
INSERT INTO fuf_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Onsay jiiɓoldu tiiɗundu waɗi sabu laawol Joomi on. ");
INSERT INTO fuf_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Tawi no e nden saare siyaakeejo wi'eteeɗo Dimitiriyuusu, tafaynooɗo rewirkoy tosokoy tafiraakoy kaalisi, hara ko nandintinaakoy e rewirdu allaajo maɓɓe debbo wi'eteeɗo *Artemiisi on. Tawi ɗun no wondannoo e ɓe o tafidaynoo ɓen tono tiiɗuɗo. ");
INSERT INTO fuf_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","On mooɓindiri ɓe o tafidaynoo ɓen, kamɓe e ɓe ɓe kafidunoo mecce goote ɓen, o wi'i ɓe: «On fow hiɗon andi, fii men on ko e ɗee golle ɗoo humii, ");
INSERT INTO fuf_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","awa kadi hiɗon yi'ude, hiɗon nanude ko woni feƴƴude kon, hara hinaa Efeesi ɗoo tun, fayda ko e nder Aazii on fow wonde, oo wi'eteeɗo Puulusa no murtinde jamaa ɗuuɗuɗo, fellintinira ɓe wi'ugol wonde allaaji moƴƴiniraaɗi juuɗe neɗɗanke wonaa allaaji. ");
INSERT INTO fuf_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Ɗun non hinaa fii hayfingol mecce men ɗen tun, kono ko liɓugol fii nduu rewirdu oo allaajo debbo mawɗo wi'eteeɗo Artemiisi e ɓoorugol teddungal makko ngal, on mo Aazii fow e aduna on fow woni rewude.» ");
INSERT INTO fuf_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Ɓay ɓe nanii ɗin konguɗi, ɓe heewi tikkere, ɓe nangi e ewnagol, wi'a: «Artemiisi Efeesiyankooɓe ɓen ko mawɗo!» ");
INSERT INTO fuf_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Onsay saare nden fow jiiɓondiri, ɓe wubbidi, ɓe saalori ɓee Masedoniyankooɓe ɓe Puulusa jindidaynoo, ɗun ko Gayuusi e Aristarke, ɓe naɓori ɓe ka fijirde mawnde. ");
INSERT INTO fuf_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Puulusa kadi faalaa hollitaade jamaa on, kono laatii taalibaaɓe ɓen jaɓaali. ");
INSERT INTO fuf_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Hay woɓɓe e hooreeɓe Aazii ɓen, ɓe tawata ko yiɓɓe makko kanko Puulusa, ɓe nuli woɓɓe e makko ko jeeja mo fii wota o yahu ka fijirde mawnde. ");
INSERT INTO fuf_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Tawi woɓɓe no ewnoo goɗɗun goo, ɓeya kadi no ewnoo goɗɗun goo, ko fii jiiɓaare nden no woni hakkunde dental ngal, e hoore ɗun ɓurɓe ɓen andaa wuren ko honɗun mooɓindiri ɓe. ");
INSERT INTO fuf_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Onsay woɓɓe e hakkunde jamaa on lowi oo wi'eteeɗo Aleksander mo Yahuudiyankeeɓe ɓen feƴƴini yeeso dental ngal. Kanko Aleksander o towni jungo, tawi himo faalaa sifanaade jamaa on. ");
INSERT INTO fuf_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Ɓay ɓeya andii ko o Yahuudiyankeejo, fow ewnodi wa saa'iiji ɗiɗi, hiɓe wi'a: «Artemiisi Efeesiyankooɓe ɓen ko mawɗo!» ");
INSERT INTO fuf_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Onsay hoore kaydi on ɗahi yimɓe ɓen, o wi'i ɓe: «Ko onon yo Efeesiyankooɓe, hara ko hombo woni andaa wonde saare Efeesi nden ko ngaynaakoore rewirdu oo allaajo debbo mawɗo wi'eteeɗo Artemiisi, awa kadi ko nde ngaynaakoore nandolla makko iwruɗo ka kammu on? ");
INSERT INTO fuf_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Ɓay ɗun hinaa ko yeddinii, wonee deeƴuɓe, hara on waɗiraali huunde hawjere. ");
INSERT INTO fuf_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Ko fii on addii ɓee yimɓe, ɓe tawata bonnaa ka hormorde, ɓe hoynaa kadi allaajo men debbo on. ");
INSERT INTO fuf_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Si tawii non Dimitiriyuusu oo, e siyaakeeɓe ɓe o kafidi mecce ɓen no galdidi e goɗɗo, haray no woodi ɲaawirɗi e ɲaawooɓe lamminaaɓe fii mun, yo ɓe wullito e ɓen. ");
INSERT INTO fuf_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Si tawii non hiɗon mari goɗɗun ko ɓeyditii e ɗun, haray ko ka dental ardinaangal ngal ɗunɗon moƴƴintee. ");
INSERT INTO fuf_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","41","Ko fii hiɗen waawi heɓude feloore fii nduu murtaldu waɗundu hande, ɓay dalil woo alaa mo holloyen ko honɗun waɗirɗen nduu jiiɓoldu.» Ɓay o gaynii wowlude ɗun, o yilti jamaa on. ");
INSERT INTO fuf_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Ɓay murtaldu ndun accii, Puulusa ɓanniti taalibaaɓe ɓen. Ɓay o gaynii ɓe wakkilinde, o waynii ɓe, o immii, o fokkitani yahugol Masedonii. ");
INSERT INTO fuf_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","O taƴitoyi ɗen leyɗe e hoore himo yewta yimɓe ɓen nooneeji no ɓe wakkilora, onsay o hewtoyi Gereesi. ");
INSERT INTO fuf_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Onsay o koɗii ɗon lebbi tati, hari himo woniri ƴettugol ɗon laana ndiyan, yaara Sirii. Kono nde tawnoo Yahuudiyankeeɓe ɓen no eɓɓani mo janfa, o aadii yiltitagol Masedonii. ");
INSERT INTO fuf_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Hari ko o wondi ko ɗowta mo, ko oo ɓiɗɗo Piruusi mo Biriyata wi'eteeɗo Sopateere, e Aristarke e Sekondiisu, on ko mo Tesalonii, e Gayuusi, on kadi ko mo Derbata, e Timotee e Tikiiki e Torofiimi, ɓee fow ko ɓe iwdi *Aazii. ");
INSERT INTO fuf_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Ɓen woni yeeso, ɓe habboyii men Turuwaasi. ");
INSERT INTO fuf_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Menen kadi, ɓay *Juldeere Bireedi ɗe Aldaa e Lewen nden feƴƴii, men bakii e laana ndiyan Filipii. E nder balɗe jowi men tawoyi ɓe Turuwaasi, men waɗi ɗon balɗe jeeɗiɗi. ");
INSERT INTO fuf_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","E asewe kiikiiɗe, men mooɓondiri fii ɲaamidugol. Nde tawnoo Puulusa ruttoto bimbi nden ɲande, o yewtidi e tawanooɓe ɓen, o junni yewtere makko nden haa tumbere jemma. ");
INSERT INTO fuf_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Tawi lampuuji ɗuuɗuɗi no ka suudu dow-dowru ka men mottondirnoo ɗon. ");
INSERT INTO fuf_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Tawi kadi suka no wi'ee Etikuusi no jooɗinoo e damun tosokun e on koore tammo. O ƴetti ɗoyngol luggungol e nder ko Puulusa juutini yewtere nden kon, o accitii ka koore ton sabu ɗoyngol ngol, o yani. O imminaa, tawi o maayii. ");
INSERT INTO fuf_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Onsay Puulusa tippii, o ugginii e hoore makko, o ƴetti mo, o tambii, o wi'i: «Wota on aanu, ko fii himo wuuri.» ");
INSERT INTO fuf_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Ɓay kanko Puulusa o ƴawitoyii, o taƴiti bireedi on, o ɲaami. Ɓawto ɗun, o yewti kadi ko juuti haa wa ka peeral fajiri. Onsay o yahi. ");
INSERT INTO fuf_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Ɓawto ɗun, suka on nattaa ko o wurɗo, ɗun wonani ɓe welo-welo mawngo. ");
INSERT INTO fuf_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Onsay menen men hikkanii men yeeso, men bakii ɗon e laana ndiyan fii yahugol Asoosi ka men haanunoo yiitidude e Puulusa ɗon, ɓay hari kanko o aadike wonde o seppay. ");
INSERT INTO fuf_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Ɓay o tawoyii men Asoosi, men ƴawni mo ka laana fii yaadugol e makko Mitileeni. ");
INSERT INTO fuf_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Ɓay men iwii ɗon, men jokki baharu on haa men hewtoyi bimbi nden ɲande yeeso Kiyoo. E ɲallal hikkungal ɗon ngal kadi, men meemoyi ka wi'etee ɗon Samoosi. Ɓawto ngal ɲallal ɗon kadi, men hewtoyi Miletii. ");
INSERT INTO fuf_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Tawi Puulusa no miijinoo feƴƴugol Efeesi tun hara daraaki, fii wota o tongo e nder Aazii on. Ko fii hari himo hawji hewtoygol Yerusalaam fii Juldeere *Pentakosta nden, si tawii ɗun no waawi mo gasande. ");
INSERT INTO fuf_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Ko onsay, ko o woni Miletii ɗon, kanko Puulusa o immini ko yahana ardotooɓe *moftal ngal Efeesi. ");
INSERT INTO fuf_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Ɓay ɓen arii, o wi'i ɓe: «Hiɗon andi ko honno mi wondiri e mo'on yeru ko mi woni ɗoo kon, gila ɲande mi tippi Aazii. ");
INSERT INTO fuf_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","E hoore ɗun mi kurkanike Joomiraaɗo on, e hoore yankinaare fow, e nder gonɗi, e hakkunde ndarndeede wonanɗun lan janfaaji immorde e Yahuudiyanke'en. ");
INSERT INTO fuf_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","E ɓaawo suuɗugol on hay huunde, miɗo feɲɲinande on, janna on e hakkunde fow e ka cuuɗi kala ko wondani on e nafa, ");
INSERT INTO fuf_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","e seedintinangol Yahuudiyankeeɓe ɓen e *Gereekiyankeeɓe ɓen fii tuubangol Alla e gomɗingol Iisaa Joomi men on. ");
INSERT INTO fuf_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","«Jooni yo mi yahu Yerusalaam, ɓay Ruuhu Allaahu on no haɓɓitii e ɗun, e hoore mi andaa ko heɓoytammi ton. ");
INSERT INTO fuf_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Ko woni tun, gila saare heɓi e saare, *Ruuhu Seniiɗo on no seedintinande lan wi'ammi wonde, kaɓɓi e satteendeeji no sabbii lan. ");
INSERT INTO fuf_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Kono mi waɗaa ngurndan an ɗan ko goɗɗun, wa si tawii hiɗan hitti e an, fii tun yo mi timmin jinduruuji an ɗin e golle ɗe mi heɓiri Iisaa Joomi on ɗen, ɗun ko seeditagol fii Kibaaru Moƴƴo fii moƴƴere Alla nden. ");
INSERT INTO fuf_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","«Jooni miɗo andi, on yi'itataa lan hande kadi, ɗun ko onon ɓee ɓe mi rewi hakkunde mun, mi waajii fii *laamu Alla ngun. ");
INSERT INTO fuf_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Ko ɗun waɗi, miɗo seedaade hande wonde si goɗɗo e mon halkike, haray wonaa min waɗi. ");
INSERT INTO fuf_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Ko fii mi suuɗaali on hay huunde, mi ɓanginanii on eɓɓoore Alla nden fow. ");
INSERT INTO fuf_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Jooni reenee, reenidon hoore mon e wuro ngo Ruuhu Seniiɗo on waɗi on e hoore mun ngon, fii no ayniron moftal Alla ngal o heɓiri ƴiiƴan ɓiɗɗo makko on tigi. ");
INSERT INTO fuf_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Miɗo andi si mi iwoyii ɗoo, caapaali hunƴuɗi aroyay hakkunde mon ɗi tawata accoytaa wuro ngon. ");
INSERT INTO fuf_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Awa kadi woɓɓe hawtoyto e hakkunde mon, hara hiɓe wowla haalaaji ɓoyliiɗi fii pooɗugol taalibaaɓe ɓen e maɓɓe. ");
INSERT INTO fuf_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Awa on wattanoyay yiila, anditon, e nder duuɓi tati jemma e ɲalorma mi accaali waajagol mo kala e mon e hoore gonɗi. ");
INSERT INTO fuf_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","«Jooni mi ƴettii on, mi halfinii Alla e daaluyee moƴƴere makko nden, ko on mari bawgal fii mawningol on e yeɗugol on ndondi wondude e yimɓe Alla ɓen fow. ");
INSERT INTO fuf_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Mi himmanaali kaalisi e kaŋŋe e conci hay gooto. ");
INSERT INTO fuf_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Onon tigi hiɗon andi ko juuɗe an ɗen mi golliri fii ko mi hatonjini e mun kon e ko wondiɓɓe an ɓen hatonjini e mun kon. ");
INSERT INTO fuf_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","E nder ɗun fow, mi hollii on yo on gollir nii fii yo on wallito lo'uɓe ɓen, anditon kadi konguɗi Iisaa Joomi on ko o wi'i kon kanko tigi wonde: ‹Ko okkugol ɓuri moƴƴude edii okkoreede.› » ");
INSERT INTO fuf_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Ɓay o gaynii yewtude ɗun, onsay o jiccii fii du'ondirgol e maɓɓe ɓe fow. ");
INSERT INTO fuf_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Onsay ɓe fow ɓe hirbii mo kanko Puulusa, ɓe lunnii e hoore gonɗi tiiɗuɗi. ");
INSERT INTO fuf_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Ko ɓurnoo ɓe sokolinde kon, ko ko o wi'unoo ɓe kon wonde ɓe yi'itataa mo hande kadi. Onsay ɓe ɗowtiti mo haa ka laana ndiyan. ");
INSERT INTO fuf_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Ɓay men sertii e maɓɓe, men bakii ɗon e laana ndiyan, men fewni haa Koosi. Bimbi nden ɲande men yahi Rodeesi. Ɓay men iwii ɗon kadi, men yahi Patara. ");
INSERT INTO fuf_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Ɓay men tawii ɗon laana lumbooha yaara Fenisii, men bakii ɗon, men yahi. ");
INSERT INTO fuf_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Ɓay men ɓattike Siipuru, onsay men acciri ɗon ka nano, men yaari telen Sirii fii tippinoygol ko laana kan rondii kon Tiiri. ");
INSERT INTO fuf_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Ɓay men tawii taalibaaɓe ɓen ɗon, men woni balɗe jeeɗiɗi. Immorde e Ruuhu Allaahu on ɓe wi'i Puulusa: «Wota yahu Yerusalaam.» ");
INSERT INTO fuf_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Ɓay ɗen balɗe jeeɗiɗi timmii, men yahi. Onsay kamɓe fow e rewɓe maɓɓe ɓen e ɓiɓɓe maɓɓe ɓen, ɓe ɗowtiti men, men yaadi haa men yalti saare nden, ɗun ko ka sera ndiyan, men jiccii, men du'ondiri. ");
INSERT INTO fuf_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Onsay men waynondiri e maɓɓe, men bakii ka laana, kamɓe ɓe yiltitii ka maɓɓe. ");
INSERT INTO fuf_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Ɓay men gaynii ko yaaretee laana ndiyan kon, ɗun ko gila Tiiri haa Potolemaayi, men hiwrondiri e musiɓɓe gomɗinɓe wonɓe ɗon ɓen, men wondi e maɓɓe ɲallal. ");
INSERT INTO fuf_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Bimbi nden ɲande, men yahi men hewtoyi Seezariiya, men naatiri ka suudu Filiipu oo waajotooɗo fii Kibaaru Moƴƴo on, tawdaaɗo e njeeɗiɗooɓe ɓen, men weeri ka makko. ");
INSERT INTO fuf_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Tawi himo mari jiwɓe nayo haalooɓe ko Alla longini ɗun ɓe andaali gorko. ");
INSERT INTO fuf_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Nde tawnoo men waɗii ɗon balɗe buy, haaloowo ko Alla longini ɗun wi'eteeɗo Agabuusi, iwruɗo ka diiwal Yahuuda, ari tawi men. ");
INSERT INTO fuf_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","O ƴetti dattol Puulusa ngol, o haɓɓitii juuɗe e koyɗe, o wi'i: «E hino ko *Ruuhu Seniiɗo on wi'i kon: ‹Oo neɗɗo jeyɗo ngol dattol, Yahuudiyankeeɓe ɓen haɓɓiray mo nii Yerusalaam, ɓe watta mo e juuɗe ɓe wonaa Yahuudiyanke ɓen.› » ");
INSERT INTO fuf_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Ɓay menen e ɓen yimɓe hoɗuɓe e nden nokkuure men nanii ɗun, men jeeji Puulusa fii wota o yahu Yerusalaam. ");
INSERT INTO fuf_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Kono Puulusa jaabii men, wi'i: «Ko honɗun wulloton, bonnon mi ɓernde? Ko fii min hinaa fii haɓɓegol tun mi hebulanii, kono ko hay maayugol Yerusalaam fii innde Iisaa Joomi on.» ");
INSERT INTO fuf_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Nde tawnoo o jaɓaali yilteede e ko o anniyii kon, men haɓɓitaaki hande kadi, kono men wi'i: «Yo kodduruyee Joomiraaɗo on waɗu!» ");
INSERT INTO fuf_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Ɓay ɗen balɗe ɗon feƴƴii, men eɓɓindii, men yahi Yerusalaam. ");
INSERT INTO fuf_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Taalibaaɓe goo ɓe Seezariiya ɗowti men ka goɗɗo no wi'ee Manasuuna mo Siipuru, on ko taalibaajo gila ko neeɓi, fii ko werna men. ");
INSERT INTO fuf_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Ɓay men hewtii Yerusalaam, musiɓɓe ɓen jaɓɓori men weltaare. ");
INSERT INTO fuf_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Bimbi nden ɲande menen e Puulusa men ari ka Yaaquuba, ardotooɓe *moftal ngal kadi fow ari ɗon. ");
INSERT INTO fuf_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Ɓay Puulusa gaynii ɓe hiwraade, o nangi e fillitanagol ɓe, fensita ko Allaahu on waɗi e hakkunde ɓe wonaa Yahuudiyanke ɓen e nder golle makko ɗen. ");
INSERT INTO fuf_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","E nder ko ɓe heɗii mo kon, ɓe mawnini Alla, e hoore ɗun ɓe wi'i mo: «Musiɗɗo, a yi'ii ittiri guluuje guluuje Yahuudiyankeeɓe ko gomɗini, e hoore ɓe fow hiɓe haɓɓitii e Sariya on. ");
INSERT INTO fuf_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","E hoore ɓe yeetaama wonde hiɗa jannude Yahuudiyankeeɓe wonɓe e hakkunde ɓe wonaa Yahuudiyanke ɓen fow wota ɓe jokku Sariya Muusaa on, ɗun ko wi'ugol ɓe wota ɓe sunnin fayɓe maɓɓe ɓen e wota ɓe jokku naamuuji ɗin. ");
INSERT INTO fuf_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Hara ko honɗun waɗeten? Ko fii pellet ɓe anday wonde a arii. ");
INSERT INTO fuf_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Ko ɗun waɗi si men wi'ete yo a waɗu ko men wi'u-maa kon. No e hakkunde amen yimɓe nayo woonduɓe woondoore. ");
INSERT INTO fuf_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Ƴettu ɓen, laɓɓindinoɗaa e maɓɓe, fawtoɗaa njoddi fembagol maɓɓe ngol, ɗun fow anday goonga alaa e ko ɓe wowlanaa kon fii maa, kono an kadi hiɗa ɗoftii Sariya on. ");
INSERT INTO fuf_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Kono fii ɓe wonaa Yahuudiyanke, gomɗinɓe ɓen, men tawi no moƴƴi ka men windana ɓe, yo ɓe reeno e tebbeeli sakkanaaɗi sanamuuji e ƴiiƴan e mummunteeji jiibuɗi e jinaa.» ");
INSERT INTO fuf_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Bimbi nden ɲande, Puulusa ƴetti ɓen yimɓe nayo, o laɓɓindinodi e maɓɓe, o naati ka *juulirde mawnde. O feɲɲini ko honde tuma e ɲalaaɗe ɗen laɓɓinagol maɓɓe ngol timmata, sadaka mo bee e maɓɓe waɗee. ");
INSERT INTO fuf_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Ka balɗe jeeɗiɗi ɗen timmata ɗon, ɓay Yahuudiyankeeɓe ɓe *Aazii ɓen yi'ii mo ka juulirde mawnde, ɓe ƴuuni jamaa on fow, ɓe fawi mo juuɗe, ");
INSERT INTO fuf_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","e hoore hiɓe ewnoo, wi'a: «Isra'iilayankeeɓe*, wallee men! E hino neɗɗo wonɗo jannude fow on nokku woo nokku fii liddagol jamaa on, liddoo Sariya on, liddoo kadi ndee nokkuure. E hay o naadii *Gereekiyankeeɓe ka juulirde mawnde, o tuuninii ndee nokkuure hormorde!» ");
INSERT INTO fuf_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","(Ko woni sabu ɗun ko tawde hari ɓe yiidiino mo e oo Efeesiyankoojo wi'eteeɗo Torofiimi ka saare, haa ɓe sikki wonde Puulusa naadii mo ka juulirde mawnde.) ");
INSERT INTO fuf_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Onsay saare nden fow memminii, yimɓe ɓen dogi iwri e cenɗe ɗen fow, ɓe nangi Puulusa, ɓe pooɗi mo, ɓe itti ka juulirde mawnde, baafe ɗen ombaa kisan. ");
INSERT INTO fuf_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Wa ko ɓe eɓɓata fii warugol mo, tawi hooreejo dental suufaaɓe Roomu ɓen nanii wonde jiiɓoldu waɗii e nder Yerusalaam fow. ");
INSERT INTO fuf_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Ɗon kisan, o ƴetti suufaaɓe e yeesooɓe mun, ɓe wubbani ɓen eɓɓunooɓe warugol Puulusa. No ɓe yiirunoo on hooreejo e ɓen suufaaɓe, ɓe acciti piyugol mo. ");
INSERT INTO fuf_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Onsay on hooreejo ɓadii mo kanko Puulusa, o nangi mo, o yamiri yo ɓe jolku mo jolokooje ɗiɗi. O landii non ko hombo woni oo e ko honɗun o waɗi. ");
INSERT INTO fuf_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Kono tawi e nder jamaa on, woɓɓe no ewnoo wi'a goɗɗun, ɓeya kadi no wi'a goɗɗun goo, tawi kanko hooreejo on o waawaali andude ko woni haqiiqa fii murtaldu ndun. Onsay o yamiri yo ɓe naɓu mo ka daaka suufaaɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Wa ko Puulusa ƴawata ɓorɗi ɗin, suufaaɓe ɓen kutii mo tambii sabu hunƴeendi jamaa on. ");
INSERT INTO fuf_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Ko fii hari konu yimɓe ɓen no jokki mo, no ewnoo, wi'a: «Waree mo!» ");
INSERT INTO fuf_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Wa ko kanko Puulusa o naadetee ka daaka suufaaɓe ɓen, o landii hooreejo dental suufaaɓe ɓen, o wi'i: «E hara a newnanay lan yeetagol ma goɗɗun?» On jaabii mo, wi'i: «Hiɗa waawi haala Gereeki? ");
INSERT INTO fuf_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","E hara hinaa an woni oo Misirayankoojo, wonuɗo sabu nduu murtaldu ko feƴƴi koo, dogidi e ɓee ittooɓe ko'e guluuje nayo ka wulaa?» ");
INSERT INTO fuf_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Kanko Puulusa o wi'i mo: «Min, ko mi Yahuudiyankeejo mo Tarsiisu, ɗun ko e nder Silisii, jeyaaɗo e saare nde tawata wonaa hayfunde. Mi jeejii ma newnanan yewtugol jamaa on.» ");
INSERT INTO fuf_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Onsay on hooreejo newnani mo. Kanko Puulusa o immii, o darii ka hoore ɓorɗi, o yeƴani jamaa on jungo, deeƴaango tiiɗungo waɗi. Onsay o hewtini ɓe yewtere nden e haala Yahuudiyanke, o wi'i: ");
INSERT INTO fuf_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","«Ko onon yo musiɓɓe an e baabiraaɓe an, jooni heɗee mi yewta on fii jaabannde an nden.» ");
INSERT INTO fuf_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Nde ɓe nanunoo ko e haala Yahuudiyanke o woni ɓe yewtude, deeƴaango ngon ɓurti kadi. Onsay Puulusa wi'i: ");
INSERT INTO fuf_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","«Min ko mi Yahuudiyankeejo heɓaaɗo Tarsiisu, ɗun ko e nder Silisii, kono ko e nder ndee saare ɗoo mi ne'aa. Ko e fee Gamaliyiila kadi mi jangi fii jokkugol Sariya baabiraaɓe men ɓen tigi. Hari miɗo huminoo e Alla fota wano wonirɗon non on fow hande. ");
INSERT INTO fuf_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Miɗo cukkotonoo ɓen jokkuɓe laawol Iisaa haa woɓɓe maayori, mi haɓɓa, mi soka worɓe e rewɓe. ");
INSERT INTO fuf_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Yottinoowo* mawɗo sadaka on e dental mawɓe ɓen fow ko seedee an e ɗun. Mi hendorii ɓe hay ɓataake fii musiɓɓe Yahuudiyankeeɓe wonɓe Damaasi ɓen. Onsay mi yahi fii haɓɓugol jokkuɓe ngol laawol wonɓe ton ɓen, mi adda Yerusalaam fii donkingol ɓe. ");
INSERT INTO fuf_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","«Wa fewndo ko mi woni ka ɗatal, ɓay mi ɓadike Damaasi, ɗun ko wa naange e hoore, tun ndaygu moolanaangu iwri ka kammu, hunditi lan. ");
INSERT INTO fuf_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Mi yani ka leydi, onsay mi nani hawa no wi'ammi: ‹Saawulu! Saawulu! Ko fii honɗun wonɗaa mi cukkanaade?› ");
INSERT INTO fuf_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","«Mi jaabii: ‹Ko an hombo nii Joomi an?› «O wi'immi: ‹Ko min woni Iisaa jeyaaɗo Naasirata, on mo wonɗaa cukkaade.› ");
INSERT INTO fuf_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Ɓen wondunooɓe e an yi'uno ngun ndaygu, kono ɓe alaano nanude hawa on Wonɗo lan wowlande. ");
INSERT INTO fuf_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","«Onsay mi wi'i: ‹Ko honɗun mi waɗata, yaa an Joomi?› «Joomi on jaabii lan, wi'i: ‹Immo yahaa Damaasi, ko ɗon ɓe yeetoto-maa kala ko haanuɗaa waɗude.› ");
INSERT INTO fuf_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","«Tawi mi alaa yi'ude han kadi, ko fii hari jalbeendi ngun ndaygu wuminii lan. Onsay wondunooɓe e an ɓen ɗowimmi haa mi hewti Damaasi. ");
INSERT INTO fuf_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","«Tawi goɗɗo no ɗon no wi'ee Hanaaniiya, on ko gorko dewo ɗoftotooɗo Sariya on, mo Yahuudiyankeeɓe wonɓe Damaasi ɓen fow joganii kongol moƴƴol. ");
INSERT INTO fuf_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","On ari darii takko an, wi'immi: ‹Ko an yo Saawulu musiɗɗo an, wuntu!› E on saa'i tigi mi wunti, mi yi'i mo. ");
INSERT INTO fuf_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","«O wi'immi kadi: ‹Alla baabiraaɓe men ɓen suɓike ma fii yo a andu faale makko on e fii yo a yi'u Feewuɗo on, nanaa konguɗi iwruɗi ka hunduko makko ɗin. ");
INSERT INTO fuf_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Ko fii a wonay seeditantooɗo mo e yeeso yimɓe ɓen fow fii ko yi'uɗaa kon e ko nanuɗaa kon. ");
INSERT INTO fuf_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Jooni non ko honɗun wonɗaa nennanaade? Immo *looteɗaa maande kisiyee, laɓɓineɗaa junuubaaji maa ɗin e nder jantagol innde makko nden.› » ");
INSERT INTO fuf_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Puulusa wi'i kadi: «Ɓay mi yiltitike Yerusalaam, e nder ko mi torotoo Alla kon ka *juulirde mawnde, mi feɲɲinanaa goɗɗun. ");
INSERT INTO fuf_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Onsay mi yi'i Joomi on, o wi'immi: ‹Hittin yaltugol Yerusalaam, ko fii ɓe jaɓataa seeditoore maa nden fii an.› ");
INSERT INTO fuf_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Kono mi wi'i: ‹Joomi an, hiɓe andi kamɓe tigi wonde mi yahayno gila e juulirde heɓi e juulirde fii piyugol soka ɓen gomɗinɓe ma. ");
INSERT INTO fuf_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Awa fewndo kadi ɓe hibbi ƴiiƴan Astefaana ɗan, ɗun ko on seeditantonooɗo ma, hari min tigi miɗo ɗon e miɗo jaɓi ɗun. Awa kadi hari miɗo joganii ɓen wonɓe mo warude conci mun ɗin.› ");
INSERT INTO fuf_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Kono o wi'immi, ‹Yahu, ko fii mi imminte ka woɗɗi, ɗun ko haa e ɓe wonaa Yahuudiyanke ɓen.› » ");
INSERT INTO fuf_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Laatii ɓe heɗii mo kanko Puulusa haa e ngol kongol ɗon, onsay ɓe ewnii, ɓe wi'i: «Yo sifa oo neɗɗo itte aduna! O haanaa wuurude!» ");
INSERT INTO fuf_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Ɓe ɓeydi sonko, ɓe ferii kadi conci maɓɓe ɗin, e hoore hiɓe bugoo kadi mbullaari dow. ");
INSERT INTO fuf_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Onsay hooreejo dental suufaaɓe ɓen yamiri yo ɓe naadu Puulusa ka nder daaka suufaaɓe ɓen, ɓe landora mo cabbi fii andugol ko honɗun wonaa sonkireede nii fii makko. ");
INSERT INTO fuf_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","E nder ko ɓe haɓɓata mo kon fii foccugol mo, kanko Puulusa o wi'i yeesoojo sufaaɓe wonnooɗo ɗon on: «E hara hiɗon newnanaa foccugol jeyaaɗo e laamateeri Roomu, mo on ɲaawaali toode?» ");
INSERT INTO fuf_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Ɓay on yeesoojo nanii ngol kongol, o yahi, o wi'oyi hooreejo dental ngal: «Ko honno gerdataa, ko fii oo neɗɗo ko jeyaaɗo e laamateeri Roomu.» ");
INSERT INTO fuf_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Onsay on hooreejo ari wi'i mo kanko Puulusa: «Yeeto lan, e hara ko a jeyaaɗo e laamateeri Roomu?» O jaabii: «Hiiyii, ko mi ɗun.» ");
INSERT INTO fuf_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Kanko hooreejo on o wi'i mo: «Min ko kaalisi buy mi itti fii yo mi wonu jeyaaɗo e laamateeri Roomu.» Puulusa kadi wi'i mo: «Min non mi jibina ko mi ɗun.» ");
INSERT INTO fuf_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Onsay kisan landotonooɓe mo ɓen diri, hooreejo dental ngal kadi huli, ɓay o andii Puulusa ko jeyaaɗo e laamateeri Roomu, awa kadi o waɗii haa o haɓɓaama. ");
INSERT INTO fuf_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Jango mun, nde tawnoo kanko hooreejo dental suufaaɓe Roomu ɓen himo faalaa andude e haqiiqa ko honɗun Yahuudiyankeeɓe ɓen wonnoo mo tooɲirde, o hoynitani mo, o yamiri kadi hooreeɓe yottinooɓe sadaka ɓen e dental fewjooɓe ɓen fow mottondirgol. Onsay o addi Puulusa, o joɗɗini mo yeeso maɓɓe. ");
INSERT INTO fuf_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Ɓay Puulusa tenƴinii dental fewjooɓe ɓen, o wi'i: «Musiɓɓe, ko e hoore ɓernde laaɓunde mi wonirani Alla haa handeere ndee.» ");
INSERT INTO fuf_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Tun *yottinoowo mawɗo sadaka on, ɗun ko Hanaaniiya, yamiri wonɓe takko makko ɓen bantagol mo. ");
INSERT INTO fuf_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Puulusa kadi wi'i mo: «An kadi, Allaahu on bantoto ma yo maadi rawninaandi! Hiɗa jooɗii ɲaawirgol lan Sariya on, e hin-le a bonnirii Sariya on ko yamirɗaa yo ɓe banto lan kon!» ");
INSERT INTO fuf_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Wonnooɓe ɗon ɓen wi'i: «A hoynii yottinoowo mawɗo sadaka fii Alla on!» ");
INSERT INTO fuf_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Onsay Puulusa jaabii, wi'i: «Musiɓɓe, hari mi andaa wonde ko yottinoowo mawɗo sadaka on nii, ko fii no windii: Wota mo wowla yeesoojo jamaa mun on ko boni.» ");
INSERT INTO fuf_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Ɓay kanko Puulusa o faamii wonde feccere e wonnooɓe ɗon ɓen ko fedde *Sadduusiyaaɓe e ndeya feccere kadi ko fedde *Fariisiyaaɓe, onsay kanko Puulusa o ewnii ka hakkunde dental fewjooɓe ɓen, o wi'i: «Musiɓɓe, min ko mi Fariisiyaajo ɓii Fariisiyaajo kadi. Ko sabu tanƴinaare ummutal mayɓe ɓen waɗi si miɗo ɲaaweede.» ");
INSERT INTO fuf_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Ɓay kanko Puulusa o wi'ii ɗun, yeddondiral waɗi hakkunde Fariisiyaaɓe ɓen e Sadduusiyaaɓe ɓen, onsay mbatu ngun senditii. ");
INSERT INTO fuf_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","(Tawi Sadduusiyaaɓe ɓen no wi'a ummutal alaa, malaa'ika alaa, awa kadi ruuhu alaa. Fariisiyaaɓe ɓen kaɲun no wi'a ɗun fow no woodi.) ");
INSERT INTO fuf_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Sonko njano waɗi, woɓɓe e yeesooɓe dental Fariisiyaaɓe ɓen hawtii, ɓe immini yewtoore tiiɗunde, ɓe wi'i: «Men yi'aali bone woo e hoore oo neɗɗo. No gasa non hara ko ruuhu maa malaa'ika wowlani mo.» ");
INSERT INTO fuf_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Nde tawnoo yeddondiral ngal no tiiɗude tun, hooreejo dental suufaaɓe ɓen huli wota ɓe seekitu Puulusa. O yamiri suufaaɓe ɓen tippagol, ittoya mo hakkunde maɓɓe, ɓe naɓa mo ka daaka suufaaɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","E on jemma hikkiiɗo ɗon, Joomi on ɓadii Puulusa, wi'i mo: «Wakkilo, ko fii wano seeditorɗaa non fii an Yerusalaam, bee seeditoroyaa non kadi Roomu.» ");
INSERT INTO fuf_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Ɓay weetii, Yahuudiyankeeɓe ɓen waɗi janfa, ɓe woondi wota ɓe ɲaamu hay huunde maa ɓe yara, ɗoo e ɓe warude Puulusa. ");
INSERT INTO fuf_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Ɓen eɓɓunooɓe kan janfa no ɓurnoo cappanɗe nayo. ");
INSERT INTO fuf_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Ɓe yahi, ɓe tawoyi hooreeɓe yottinooɓe sadaka ɓen e mawɓe ɓen, ɓe wi'i ɓe: «Men aadike e hoore woondoore tiiɗunde wonde, men ɲaamataa men yarataa hay huunde fannin men waraali Puulusa. ");
INSERT INTO fuf_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Jooni nanondiree e dental fewjooɓe ɓen, yiidon e hooreejo suufaaɓe ɓen, faaminanon mo wonde on ndaaray fii nduu muraadu Puulusa hara ko no woniri non, fii no o addira mo yeeso mon. Menen haray meɗen hebulii warugol mo ɗoo yo o hewtu.» ");
INSERT INTO fuf_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Kono laatii ɓiɗɗo bandiraawo Puulusa on nani hiɓe yewta fii kan janfa, o yahi o naatoyi ka daaka suufaaɓe ɓen, o humpiti ɗun Puulusa. ");
INSERT INTO fuf_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Puulusa kadi noddi goɗɗo e yeesooɓe suufaaɓe ɓen, o wi'i on: «Ɗowtu oo ka hooreejo dental suufaaɓe ɓen, ko fii himo jogii ko o hollita mo.» ");
INSERT INTO fuf_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","On yeesoojo kadi ƴetti mo, ɗowti mo ka on hooreejo, o wi'i mo: «Ko oo kasoojo wi'eteeɗo Puulusa noddimmi wi'immi yo mi ɗowtu oo suka ka mon, himo mari goɗɗun ko o yeetoo on.» ");
INSERT INTO fuf_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","On hooreejo kadi jogii mo jungo ngon, ɓe pottitii sera, o wi'i mo: «Ko honɗun jogiɗaa ko yeetoɗaa mi?» ");
INSERT INTO fuf_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","On suka jaabii mo, wi'i: «Yahuudiyankeeɓe ɓen nanondirii fii toragol on yo on naɓan ɓe Puulusa jango ka yeeso dental fewjooɓe ɓen, wa si tawii hiɓe faalaa humpitaade ko laaɓi fii nduu muraadu makko. ");
INSERT INTO fuf_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Awa wota on jaɓu ko ɓe toroytoo on kon, ko fii ɓuri yimɓe cappanɗe nayo hakkunde maɓɓe no eɓɓi janfa e hoore makko. Hiɓe aadii e nder woondoore wonde ɓe ɲaamataa ɓe yarataa ɗoo e ɓe warude mo. Hiɓe hebulanii non ɗun. Jooni ko newnugol mon ngol tun ɓe heɗii.» ");
INSERT INTO fuf_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Onsay hooreejo dental suufaaɓe ɓen newnitani suka on, e hoore o wi'i mo wota o wowlan hay gooto kon ko o humpiti mo ɗon. ");
INSERT INTO fuf_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Kanko hooreejo on o noddi kadi ɗiɗo e hakkunde yeesooɓe suufaaɓe ɓen, o wi'i ɓe: «Hebulinee suufaaɓe teemeɗɗe ɗiɗo e doginooɓe pucci cappanɗe njeeɗiɗo e ɓe conkenje teemeɗɗe ɗiɗo fii ko yaha Seezariiya hande jemma ka saa'i jeenayaɓo. ");
INSERT INTO fuf_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Eɓɓon kadi pucci ka Puulusa ƴawa, naɓon mo lawnon haa ka Felikiisa yeesoojo diiwal ngal.» ");
INSERT INTO fuf_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","O windirani nii kadi lanɗo on ɓatakuru, o wi'i: ");
INSERT INTO fuf_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","«Salminaango an min Kuloodu Lisiyaasi, haa e mo'on onon Felikiisa, yo yeesoojo tedduɗo. ");
INSERT INTO fuf_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","«Awa oo neɗɗo mo mi naɓani on, ko Yahuudiyankeeɓe ɓen wonnoo ko nangi mo fii warugol. Nde mi humpitinoo wonde ko o jeyaaɗo e laamateeri Roomu, mi ardi e mojobere suufaaɓe, mi jattini mo ɓe. ");
INSERT INTO fuf_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Nde tawnoo miɗo faalaa andude ko e hoore honɗun ɓe wonnoo mo tooɲirde, mi naɓi mo e yeeso dental fewjooɓe maɓɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Mi tawi tooɲe maɓɓe ɗen ko e baŋŋe yeddondire fii Sariya maɓɓe on. Kono tawi ella woo fawaaki mo fodduɗo e wareede maa sokeede. ");
INSERT INTO fuf_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Ɓay mi andinaama janfa no eɓɓaa e hoore oo neɗɗo, mi imminani on mo kisan, mi yamiri ɓen tooɲuɓe mo yo ɓe wullito e hoore makko ka mon.» ");
INSERT INTO fuf_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Onsay, suufaaɓe ɓen waɗi ko ɓe yamiraa kon, ɓe ƴetti Puulusa, ɓe nawri mo jemma haa Antipatiri. ");
INSERT INTO fuf_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Bimbi nden ɲande ɓe yiltitii ka daaka suufaaɓe ɓen e hoore ɓe accu ɓe pucci ɓen yaadii e makko. ");
INSERT INTO fuf_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Ɓay ɓen hewtii Seezariiya, ɓe jonni yeesoojo diiwal ngal ɓatakuru ndun, ɓe watti Puulusa e juuɗe makko. ");
INSERT INTO fuf_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Ɓay kanko yeesoojo on o jangii ɓatakuru ndun, o landii Puulusa ko mo o diiwal hongal. Ɓay o andii ko mo o Silisii, ");
INSERT INTO fuf_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","o wi'i: «Nde tooɲuɓe ma ɓen aroyi woo mi heɗoyto ma.» Onsay o yamiri yo ɓe maroy Puulusa ka suudu laamu *Heroodu lanɗo on. ");
INSERT INTO fuf_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Balɗe jowi ɓawto ɗun, *yottinoowo mawɗo sadaka on, ɗun ko Hanaaniiya, ardi e mawɓe seeɗaaɓe e yewtoowo no wi'ee Tertuula. Ɓe wullitii e hoore Puulusa ka yeesoojo on. ");
INSERT INTO fuf_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","3","Ɓay kanko Puulusa o noddaama, oo wi'eteeɗo Tertuula nangi tooɲirde mo nii, wi'a: «Yaa an Felikiisa lanɗo tedduɗo, ko sabu mon men heɓiri oo ɓuttu timmuɗo, ko faamu mon ngun kadi woni sabu si ɗee waylanɗe fii nafa oo jamaa waɗi. Meɗen jaɓidi ɗi, ɗi fow ka woni woo e hoore anditangol on fota. ");
INSERT INTO fuf_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Kono fow e mun, men faalaaka on tongude haa neeɓa, mi torike on tun, tippude e newaare mon nden, yo on newnan men heɗitoɗon men seeɗa. ");
INSERT INTO fuf_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","«Men taw oo neɗɗo ko gerenteejo, memminoowo yeddondire e hakkunde Yahuudiyankeeɓe aduna on fow. Ko o yeesoojo fedde Naasirayaaɓe ɓen kadi. ");
INSERT INTO fuf_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","7","O etike hay no o tuuninira *juulirde mawnde nden. Onsay men nangi mo. ");
INSERT INTO fuf_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Onon tigi Felikiisa hiɗon waawi mo landaade kanko Puulusa, andon fii ko men tooɲiri mo kon fow.» ");
INSERT INTO fuf_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Yahuudiyankeeɓe ɓen bambani mo kanko Tertuula, ɓe wi'i: «Ko nii tigi woniri!» ");
INSERT INTO fuf_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Onsay Puulusa ƴetti haala kan, ɓay yeesoojo on jonnirii mo haala kan ɓaaƴugol mo, o wi'i: «Miɗo andi waɗii nii duuɓi buy ko onon woni ɲaawoowo e hoore oo jamaa. Awa ko e nder hoolaare mi weeɓitirta jaabannde an nden. ");
INSERT INTO fuf_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Waɗaali nii ɓuri balɗe sappoo e ɗiɗi gila mi yahi Yerusalaam fii rewoygol Alla, hiɗon waawi tefude ɗun non onon tigi. ");
INSERT INTO fuf_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","E hoore ɗun ɓe tawaali miɗo yeddondira e goɗɗo maa miɗo ƴuuna yimɓe, ɗun non woni ka juulirde mawnde, maa e ɗeya juulirɗe, maa ka nder saare. ");
INSERT INTO fuf_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Ɓe waawataa kadi hollude ko honɗun ɓe tooɲirimmi. ");
INSERT INTO fuf_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Miɗo qirritaade yeeso mon wonde ko Alla baabiraaɓe an ɓen mi woni rewude, e hoore jokkugol laawol ngol ɓe wi'i ko fedde ngol. Miɗo gomɗini kadi kala ko windii ka Sariya e ka defte annabaaɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Awa kadi miɗo mari on tama'u e fee Alla, wano kamɓe kadi ɓe tijjori non: on-le ko fii ummutal feewuɓe ɓen e ɓoyliiɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Ko ɗun waɗi si min kadi mi etoto fii heɓugol ɓernde nde aldaa e feloore yeeso Alla e yeeso yimɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","«Ɓay waɗii duuɓi buy mi artaali ka leydi an, mi arti fii addangol yimɓe an ɓen kaalisi fii ko ɓe wallitora, e fii weeɓitangol Alla dokke. ");
INSERT INTO fuf_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Ko onsay ɓe tawimmi ka juulirde mawnde e hoore ko mi laɓɓiniiɗo. Mi wondaa kadi e yimɓe maa murtaldu. ");
INSERT INTO fuf_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Kono ko Yahuudiyankeeɓe ɓe *Aazii goo haanunoo arude hollitoo yeeso mon, ɓe liɓa haala e an, si tawii hiɓe jogii goɗɗun ko ɓe fawa e an. ");
INSERT INTO fuf_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Si hinaa ɗun, yo ɓee ɗoo wowlu ko ella hombo ɓe tawi miɗo waɗi wa fewndo ko mi addaa yeeso dental fewjooɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Si hinaa taw hara ko fii ngol kongol ngol mi ewninoo e hakkunde maɓɓe tun, mi wi'i: Ko sabu ummutal mayɓe ɓen waɗi si mi waɗaa ɲaaweteeɗo yeeso mon hande!» ");
INSERT INTO fuf_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Nde tawnoo Felikiisa no humpitii fii laawol ngol moƴƴa, o yamiri ɓe yiltagol taho, o wi'i: «Nde hooreejo dental suufaaɓe ɓen ari woo, ɗun ko Lisiyaasi, mi ndartay muraadu mon ndun.» ");
INSERT INTO fuf_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","O yamiri kadi yeesoojo suufaaɓe ɓen yo o maroy Puulusa e hoore hoynangol mo seeɗa, hara o salaaki kadi ɓe Puulusa ɓen kurkanoo mo. ");
INSERT INTO fuf_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Ɓay balɗe seeɗa feƴƴii, kanko Felikiisa o ardi e ɓeyngu makko, ɗun ko Duruusiila, tawi on debbo ko Yahuudiyankeejo. Kanko Felikiisa, o immini ko yahana Puulusa, o heɗii mo fii ko yowitii e gomɗingol Iisaa Almasiihu on. ");
INSERT INTO fuf_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Nde tawnoo Puulusa ko fii peewal e waawugol hoore mun e fii ɲaawoore aroyaynde nden wonnoo yewtude, kulol heɓi Felikiisa, o wi'i: «Hiɗa waawi yahude taho! Nde mi hettindoyii woo, mi noddete.» ");
INSERT INTO fuf_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","E himo tanƴininoo kadi wonde Puulusa yeenay mo, ko ɗun waɗi si himo imminaynoo ko yahana mo soono woo fii yo ɓe yewtidu. ");
INSERT INTO fuf_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Duuɓi ɗiɗi feƴƴiri nii. Ɓawto ɗun Felikiisa lontiniraa Perkuusi Festuusa. Nde tawnoo kanko Felikiisa himo faalaa sulfinande Yahuudiyankeeɓe ɓen, o acci Puulusa ka kaso. ");
INSERT INTO fuf_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Ɓay kanko Festuusa o hewtii e ngal diiwal Seezariiya, o woni ɗon balɗe tati si o yahi Yerusalaam. ");
INSERT INTO fuf_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Onsay hooreeɓe *yottinooɓe sadaka ɓen e mokobaaɓe Yahuudiyankeeɓe ɓen yahi ka makko, wullitii e hoore Puulusa. ");
INSERT INTO fuf_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Ɓe torii mo, ɓe jeeji yo o sulfinan ɓe, o addana ɓe Puulusa Yerusalaam, tawi hiɓe eɓɓunoo janfa no ɓe warira mo ka laawol. ");
INSERT INTO fuf_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Kono Festuusa jaabii ɓe, wi'i: «Puulusa no sokii Seezariiya, awa min kadi mi yiltoto ton ko neeɓaa.» ");
INSERT INTO fuf_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","O wi'i kadi: «Miɗo waawi yaadude e woɓɓe e hooreeɓe mon ɓen, si on neɗɗo no waɗi bone, ɓe wullitoo e hoore makko!» ");
INSERT INTO fuf_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Laatii kanko Festuusa o wondaali e maɓɓe ɓuri balɗe jeetati haa sappo, onsay o yiltitii Seezariiya. Bimbi nden ɲande ɓay o jooɗike ka ɲaawirdu, o yamiri yo Puulusa adde. ");
INSERT INTO fuf_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Ɓay on addaama, Yahuudiyankeeɓe iwruɓe Yerusalaam ɓen hundi mo, ɓe liɓi e hoore makko tooɲe ɗuuɗuɗe tiiɗuɗe, ɗe ɓe waawataa fensitude fii mun. ");
INSERT INTO fuf_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Puulusa jaabori nii, wi'i: «Mi waɗaali ella liddiiɗo Sariya Yahuudiyankeeɓe ɓen, maa *juulirde mawnde nden, maa lanɗo mawɗo Roomu on.» ");
INSERT INTO fuf_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Nde tawnoo kanko Festuusa himo faalaa sulfinande Yahuudiyankeeɓe ɓen, o jaabii Puulusa, o wi'i mo: «Hiɗa faalaa yahude Yerusalaam ɲaaweɗaa ton e tawnde an?» ");
INSERT INTO fuf_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Puulusa jaabii mo, wi'i: «Miɗo ka yeeso ɲaawirdu lanɗo mawɗo Roomu on, ko ton mi haanaa ɲaaweede. Mi waɗaali Yahuudiyankeeɓe ɓen ella woo, wano gelorɗon non onon tigi fota. ");
INSERT INTO fuf_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Kono si miɗo mari ellaaji, e si mi waɗii kuuɗe fodduɗe e mayde, haray mi salotaako wareede. Kono si tawii goonga woo alaa e tooɲe ɗe ɓe tooɲimmi ɗen, haray hay gooto waawataa lan wattude e juuɗe maɓɓe. Ɗun haray yo mi feƴƴu ka *Seezar lanɗo mawɗo Roomu on.» ");
INSERT INTO fuf_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Ɓay Festuusa yewtidii e ɓe o fewjodata ɓen, o jaabii Puulusa, o wi'i: «Ɓay a feƴƴinii hoore maa ka Seezar, a yahay yeeso Seezar.» ");
INSERT INTO fuf_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Balɗe seeɗa ɓawto ɗun, Agiriipa lanɗo on e Bereniise hewti Seezariiya fii hiwragol Festuusa. ");
INSERT INTO fuf_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Nde tawnoo ɓe wonay ɗon balɗe buy, Festuusa weeɓitani on lanɗo muraadu Puulusa ndun, o wi'i: «Felikiisa no accunoo ɗoo goɗɗo ka kaso. ");
INSERT INTO fuf_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Fewndo non ko mi yahi Yerusalaam, hooreeɓe yottinooɓe sadaka ɓen e dental mawɓe Yahuudiyankeeɓe ɓen wullitino e hoore makko kanko Puulusa, tawi hiɓe landii happangol mo. ");
INSERT INTO fuf_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Kono mi jaabii ɓe, mi wi'i: ‹Roomiyankooɓe ɓen woowaa warirgol nii tun, ado ɓe tumbindirde tooɲuɓe ɓen e tooɲaaɗo on, e newnangol on tooɲaaɗo fii no o jaabora ɗen tooɲe maɓɓe.› ");
INSERT INTO fuf_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Onsay mi ardi e maɓɓe ɗoo, tawi mi faalaaka juutinde muraadu ndun. Bimbi nden ɲande kisan mi joɗɗini ɲaawoore nden, mi yamiri yo on neɗɗo adde. ");
INSERT INTO fuf_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Ɓay tooɲuɓe mo ɓen hewtii, laatii ɓe fawaali mo kuuɗe bonɗe woo, wano mi sikkirnoo non. ");
INSERT INTO fuf_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Tawi yeddondiral wongal hakkunde maɓɓe e makko ngal ko yuɓɓondirngal e fii diina maɓɓe kan tun, e aaden mayɗo goo kadi no wi'ee Iisaa, mo Puulusa kaɲun wi'i no wuuri. ");
INSERT INTO fuf_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Tawi min miɗo jiɓii fii sifa nden yewtere. Onsay mi landii mo si tawii himo faalaa yahude Yerusalaam, o ɲaawoyee ton fii ɗun. ");
INSERT INTO fuf_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Kono Puulusa feƴƴini nden yewtere yeeso fii yo muraadu makko ndun wonu e andal lanɗo mawɗo Roomu on. Onsay mi yamiri yo ɓe maru mo haa nde miɗo feƴƴina mo ka lanɗo mawɗo Roomu on woo.» ");
INSERT INTO fuf_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Onsay Agiriipa wi'i Festuusa: «Min kadi miɗo faalaa heɗaade on neɗɗo.» Festuusa kadi jaabii mo: «A heɗoto mo jango.» ");
INSERT INTO fuf_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Bimbi nden ɲande Agiriipa e Bereniise ardi e hollitaare mawnde, ɓe naatidi e hooreeɓe suufaaɓe toowuɓe ɓen e mokobaaɓe saare nden ka suudu tolnirdu. E yamiroore Festuusa, Puulusa addaa. ");
INSERT INTO fuf_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Onsay Festuusa wi'i: «Ko an yo Agiriipa lanɗo, e onon fow yo wonduɓe e amen, on yi'ii oo neɗɗo mo fii mun waɗi haa jamaa Yahuudiyanke on Yerusalaam fow e ɗoo kadi ari toriimi, hara hiɓe wi'a wonde o haanaa hande kadi wuurugol. ");
INSERT INTO fuf_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Kono min mi faamii o waɗaali hay huunde ko foddi e wareede, kono laatii kanko tigi o feƴƴini hoore makko ka laamu dow-dowwu, mi tawi no moƴƴi naɓugol mo. ");
INSERT INTO fuf_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Kono mi tawi, mi alaa hay huunde ko mi windana hooreejo dow-dowjo on, hara ko ko haqinqini fii makko. Ko ɗun waɗi si mi weeɓiti mo yeeso mon, tentinii yeeso mon onon Agiriipa yo lanɗo on, fii heɓugol goɗɗun ko mi winda nde lande ɗen lanni. ");
INSERT INTO fuf_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Ko fii mi taw wa si tawii no ɓoylii ka naɓa kasoojo, hara hollaali ko ella honɗun woni e hoore makko.» ");
INSERT INTO fuf_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Onsay Agiriipa wi'i Puulusa: «Hiɗa newnanaa yewtangol hoore maa.» Ontuma Puulusa towni jungo, o fuɗɗii jaabaade, o wi'i: ");
INSERT INTO fuf_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","«Hande miɗo weltori heɓugol feere weeɓitangol on jaabannde an nden, yo onon Agiriipa Lanɗo, fii ɗee tooɲe ɗe Yahuudiyankeeɓe ɓen liɓi e hoore an fow. ");
INSERT INTO fuf_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Ko fii hiɗon andi haa yaltoyi naamuuji Yahuudiyankeeɓe ɓen fow e yeddondire maɓɓe ɗen fow. Ko ɗun waɗi si mi torike on, jebbilagol heɗoo lan. ");
INSERT INTO fuf_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","«Yahuudiyankeeɓe ɓen fow no andi ko honno mi wuurirnoo Yerusalaam e ka leydi an gila ka fuɗɗoode cukaaku an. ");
INSERT INTO fuf_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Hiɓe andunoo lan gila ko neeɓi, hiɓe waawi non seeditaade. Miɗo wuurirnoo wa *Fariisiyaajo, mo fedde mun ɓurnoo cataade e diina amen kan. ");
INSERT INTO fuf_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Jooni non, miɗo ɲaaweede sabu tama'u fodaari ndi Allaahu on fodi baabiraaɓe amen ɓen ndin. ");
INSERT INTO fuf_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Bolondaaji* amen ɗin sappoo e ɗiɗi, ɗin duumiiɗi e rewugol Alla jemma e ɲalorma, no tanƴinii yi'ugol laatagol ndin fodaari. Yaa an Lanɗo, ko fii nden tanƴinaare Yahuudiyankeeɓe ɓen tooɲirimmi. ");
INSERT INTO fuf_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Ko honno waawuɗon miijorde wonde Alla immintintaa mayɓe ɓen? ");
INSERT INTO fuf_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","«Min tigi hari miɗo miijoo wonde miɗo haani rewude pehe ɗen fow fii liddagol ndee innde Iisaa, oo jeyaaɗo Naasirata. ");
INSERT INTO fuf_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Ko ɗun mi waɗi Yerusalaam. Min tigi mi sokii gomɗinɓe mo buy ka kasooji, wano hooreeɓe *yottinooɓe sadaka ɓen newniranimmi non. Nde ɓe ɲaawetenoo fii wareede woo, min kadi tawayno miɗo wonani nden fewjoore. ");
INSERT INTO fuf_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Awa kadi mi jokkayno ɓe soono woo e juulirɗe ɗen fow fii donkingol ɓe, miɗo ɓittinaynoo ɓe fii no ɓe yeddira gomɗinal maɓɓe ngal. E nder ko mi monantoo ɓe haa feƴƴita kon kadi, mi cukkotono ɓe haa ka ca'e janane. ");
INSERT INTO fuf_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","«Ko e nder ɗun mi yahi Damaasi e hoore nelal e yamiroore hooreeɓe yottinooɓe sadaka ɓen. ");
INSERT INTO fuf_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","E nder yaadu ndun tumbere ɲalorma, mi yi'i jalbeendi no hundi lan, min e ɓe mi yaadaynoo ɓen ka ɗatal, ɗun ko ndaygu iwrungu ka kammu, ɓurngu naange ngen jalbude, yo Lanɗo on. ");
INSERT INTO fuf_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Men fow men yani ka leydi. Onsay mi nani hawa no wi'ammi e haala Yahuudiyanke: ‹Saawulu! Saawulu! Ko fii honɗun wonɗaa mi cukkanaade? Ko fii no mettan-maa fii dartorgol wa ngaari dartotoondi soggirdu jom mun.› ");
INSERT INTO fuf_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","«Mi jaabii mo: ‹Ko an hombo nii, yaa an Joomi an?› «Joomi on jaabii lan, wi'i: ‹Ko min woni Iisaa, on mo wonɗaa cukkaade. ");
INSERT INTO fuf_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Kono immo daroɗaa e hoore koyɗe maa ɗen. Ko fii e hino ko mi feeɲiran-maa kon: Miɗo suɓaade ma fii yo a wonu kurkaadu an, e yo a wonu seedee piiji ɗi yi'uɗaa ɗin e hoore an, e ɗi mi hollay-maa ɗin. ");
INSERT INTO fuf_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Mi jattinoyte e hakkunde oo jamaa Yahuudiyanke, e ɓe wonaa Yahuudiyanke, ɓe mi imminoyay maa haa e mun, kamɓe ɓe wonaa Yahuudiyanke ɓen, ");
INSERT INTO fuf_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","fii udditugol gite maɓɓe ɗen, ɓe yiltoo ka niɓe, ɓe arda ka ndaygu, ɓe iwa e laamu Ibuliisa, ɓe fewta Alla, ɓe heɓa yaafuyee junuubaaji, ɓe tawdee e yimɓe Alla ɓen, ɓay ɓe gomɗinii lan.› ");
INSERT INTO fuf_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","«Ko ɗun waɗi yo Agiriipa Lanɗo on, si mi salaaki ɗoftaade ko mi feɲɲinanaa iwrude ka kammu kon. ");
INSERT INTO fuf_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Mi fuɗɗorani feɲɲinangol ɓee ɓe Damaasi taho, si mi arani ɓee ɓe Yerusalaam, haa naɓani e diiwal Yahuuda ngal fow, e ɓe wonaa Yahuudiyanke ɓen, fii yo ɓe tuubu, ɓe ruttoo e Alla, ɓe waɗa kuuɗe holluɗe wonde ɓe tuubii. ");
INSERT INTO fuf_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Awa ko fii ɗunɗoo Yahuudiyankeeɓe ɓen yaniri e an ka *juulirde mawnde, haa ɓe etii no ɓe mulirammi. ");
INSERT INTO fuf_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","«Kono haa hande Alla no wallimmi, ko ɗun waɗi si miɗo darii, miɗo seeditaade e yeeso sewɓe ɓen e mawɓe ɓen, e hoore mi alaa wowlude hay huunde ko wonaa ko Muusaa e annabaaɓe ɓen wi'unoo waɗay kon ");
INSERT INTO fuf_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","wonde *Almasiihu on tampoyay, awa kadi o attee immintineede e hakkunde mayɓe ɓen, o ɓanginana jamaa Yahuudiyankeeɓe ɓen e ɓe wonaa Yahuudiyanke ɓen, ndaygu ngun.» ");
INSERT INTO fuf_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Nde tawnoo ko nii o wonnoo jaaborde, Festuusa ewnii no tiiɗiri, o wi'i: «Puulusa a feetii! Gandal maa tiiɗungal ngal feetinii ma!» ");
INSERT INTO fuf_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Puulusa jaabii mo, wi'i: «Yaa an Festuusa tedduɗo, mi feetaa. Ko konguɗi goongaaji holniiɗi mi yewti. ");
INSERT INTO fuf_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Lanɗo on no humpitii fii koo ko waɗi, mi yewtiray mo woni pellital. Ko fii miɗo hoolii o majjaaka huunde, ɓay ɗun wonaa e qunuutu waɗi. ");
INSERT INTO fuf_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Agiriipa Lanɗo on, wonaa hiɗon gomɗini annabaaɓe ɓen? Miɗo andi pellet hiɗon gomɗini ɓe.» ");
INSERT INTO fuf_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Onsay Agiriipa wi'i Puulusa: «Hiɗa sikka ko e nder saa'ihun nii waawataami wattude *Almasiiyaajo?» ");
INSERT INTO fuf_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Puulusa kadi jaabii mo, wi'i: «Woni ko jooni woni ko onsay, ko mi torii Alla, ko yo onon e heɗiiɓe lan ɓen fow hande, on wa'u wano mi wa'i nii, hara hinaa e sifa ɗee jolkanɗe ɗoo.» ");
INSERT INTO fuf_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Onsay lanɗo on e yeesoojo diiwal ngal e Bereniise e jooɗodunooɓe e maɓɓe ɓen immii. ");
INSERT INTO fuf_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Ko ɓe pottitotoo, ɓe woni e wi'indirgol: «Oo neɗɗo waɗaali hay huunde ko foddi e wareede maa jolkeede.» ");
INSERT INTO fuf_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agiriipa kadi wi'i Festuusa: «Si oo neɗɗo feƴƴinaano hoore mun ka lanɗo mawɗo Roomu on, hanno himo haanaa acciteede.» ");
INSERT INTO fuf_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Ɓay wonii aadaama men bakoto ɗon e laana ndiyan fii yahugol Italii, ɓe ƴetti Puulusa e kasooɓe goo, ɓe watti e juuɗe Yuliyuusu, ɗun ko yeesoojo dental suufaaɓe jeyaangal ka lanɗo mawɗo Roomu on. ");
INSERT INTO fuf_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Men bakii ɗon e laana iwruka Adiramiyuuna rewoyayka Aazii. Men yahi, tawi meɗen wondi e Masedoniyankoojo wi'eteeɗo Aristarke mo Tesalonii. ");
INSERT INTO fuf_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Bimbi nden ɲande, men hewti Siduuna. Sabu ko Yuliyuusu jogornoo Puulusa no moƴƴiri non, o newnani mo kanko Puulusa yahugol ka yiɓɓe makko ɓen, ɓen waɗana mo faale makko on. ");
INSERT INTO fuf_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Ɓay men iwii ɗon, men takkii suriire Siipuru nden, ko fii hari hendu ndun no alindaade men. ");
INSERT INTO fuf_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Ɓay men takkike daande baharu hunduɗo Silisii e Pamfilii on, men hewti Miira, ɗun ko e nder Lisii. ");
INSERT INTO fuf_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Yeesoojo konu on tawi ɗon laana iwruka Aleksandiri, yahayka Italii, o ƴawni men ɗon. ");
INSERT INTO fuf_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Tawi e nder balɗe buy ko doy men woni yaarude, men ɓattori ndee saare Kinidii karahan. Kono nde tawnoo hendu ndun jaɓaali men jokka ngol laawol, onsay men takkii soɓɓundu Salamonee ndun, men acciri Kereeti ka ɲaamo. ");
INSERT INTO fuf_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Ɓay men serindorii ɗon karahan, men hewti e nokkuure no wi'ee Darorɗe Labaaɗe, ɗun ko takko ndee saare wi'eteende Lasaayata. ");
INSERT INTO fuf_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Ɓay saa'i juutuɗo feƴƴii, tawi yaadu amen ndun ka nder ndiyan wondii e nawaare, ko fii hari saa'i korka kan feƴƴii. Ko ɗun waɗi si Puulusa hajii ɓe, ");
INSERT INTO fuf_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","wi'i: «Mi yi'ii wonde nduu yaadu nder ndiyan gasataa e ɓaawo masiibo e kasaara, ɗun non hinaa fii laana kan e dolle ɗen tun, kono fii wonkiiji men ɗin enen kadi.» ");
INSERT INTO fuf_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Kono yeesoojo dental suufaaɓe ɓen hoolori doginoowo laana kan e yeesoojo makka on edii o heɗaade yewtereeji Puulusa ɗin. ");
INSERT INTO fuf_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Nde tawnoo ngal dingiral laaɗe ndiyan moƴƴaa ndungu, ɓurɓe ɓen e maɓɓe aadii yo ɓe yahu ɓe hettoya si tawii no gasa, ka wi'etee ɗon Feniika, e ngal dingiral laaɗe wongal Kereeti hikkorngal hirnaange ɲaamo e hirnaange nano, fii yo ɓe feƴƴin ɗon ndungu ngun. ");
INSERT INTO fuf_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Onsay kenun wifi iwri ka sengo ɲaamo, ɓe sikki wonde ɓe heɓii ko ɓe faandinoo kon. Onsay ɓe towni darnirɗun laana kan, ɓe serindii binde Kereeti. ");
INSERT INTO fuf_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Kono ɓawto ɗun seeɗa, kenii moolanaangii wifi sortori ka suriire, ngin no wi'ee kenii funnaange nano. ");
INSERT INTO fuf_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Laatii laana kan waawaali tiindaade hendu ndun, ndu naɓi ka, menen kadi men acci ka naɓi men. ");
INSERT INTO fuf_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Men yaari non haa men bakitori ka sengo ɲaamo wirnitorngo surihun tosokun no wi'ee Kawda, ka men wawtii laakun danditorkun kun ɗon e hoore karahan. ");
INSERT INTO fuf_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Ɓay kun ƴawnaama, men heɓi feere ƴettugol ɓoggi ɗin, haɓɓa laana kan. Nde tawnoo kadi meɗen hulnoo saggoygol ka njaareendi Sirtisi, onsay men tippini darnirɗun laana kan ka nder ndiyan, ko nii men yaari. ");
INSERT INTO fuf_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Nde tawnoo kenii ngin no yeƴude men fota, bimbi nden ɲande men woni e bugagol dolle ɗen ka ndiyan. ");
INSERT INTO fuf_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Ɲande timmunoo nden balɗe tati, gollooɓe ɓen ƴettani hoore mun aalaaji gollirɗi ka laana ɗin, ɓe bugii ka ndiyan. ");
INSERT INTO fuf_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Tawi e nder balɗe buy, hinaa naange hinaa koode woni ko yalti. Tawi kenii ngin ɓurtu tabitude tiiɗa haa men taƴii hisugol few. ");
INSERT INTO fuf_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","E hoore ɗun, tawi neeɓii men ɲaamaali. Onsay Puulusa hawtii darii e hakkunde yimɓe ɓen, o wi'i: «On jaɓanayno lan, hara en iwaali Kereeti, ɗun on daɗayno oo masiibo e oo kasaara. ");
INSERT INTO fuf_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Jooni mi ɓeydii on wakkilinde, ko fii on fow wonkiiji mon ɗin daɗay, ko laana kan tun woni daɗataa. ");
INSERT INTO fuf_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Ko fii oo Alla Jeyɗo lan, on mo mi rewata, malaa'ikaajo mun on arii e an e oo jemma, ");
INSERT INTO fuf_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","o wi'immi: ‹Wota a hulu yo Puulusa, ko fii bee daroɗaa yeeso lanɗo mawɗo Roomu on. Awa kadi Alla yeɗete sulfu fii ɓe wonduɗaa ka ndiyan ɓen fow.› ");
INSERT INTO fuf_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Ko ɗun waɗi, si mi wi'ay on wakkilee, ko fii miɗo hoolii ko Alla wi'immi kon waɗiray non. ");
INSERT INTO fuf_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Kono fow e mun, bee saggoyen e suriire.» ");
INSERT INTO fuf_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Ka jemmaare sappoo e nayaɓere gila hendu ndun woni men bugondirde e on baharu Adriyatiika, gollooɓe ka laana ɓen sogitii ɓadagol amen leydi ndin tumbere jemma. ");
INSERT INTO fuf_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Onsay ɓe yolli sawru eɓɓirdu ndun, ɓe tawi luggeendi ndin ko sogone cappanɗe jeetati. Ɓay men woɗɗitike ɗon seeɗa, ɓe yolliti ndu kadi, ɓe tawi luggeendi ndin ko sogone cappanɗe jeegoo. ");
INSERT INTO fuf_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Nde tawnoo hiɓe hulunoo yi'ugol ka laana kan lancotoo e kaaƴe, onsay ɓe bugori darnirɗe nay laana kan ɓaawo, tawi ko ɓe habbii woo ko weetugol ngol. ");
INSERT INTO fuf_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Tawi gollooɓe ka laana ɓen no ɗaɓɓude no seedira e makka. Onsay ɓe tippini laakun danditorkun kun ka nder ndiyan, wa si tawii hiɓe yahude waɗoya darnirɗe laana kan yeeso makka. ");
INSERT INTO fuf_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Onsay Puulusa wi'i yeesoojo suufaaɓe ɓen e suufaaɓe ɓen: «Wattanee yiila, ko fii si ɓee yimɓe wonaali ka nder laana gaa, haray on waawataa daɗude hande kadi.» ");
INSERT INTO fuf_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Onsay suufaaɓe ɓen taƴi ɓoggi laakun danditorkun kun, ɓe acci kun yoolii. ");
INSERT INTO fuf_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Ado weetude, Puulusa wakkilini fow fii ɲaamugol e hoore himo wi'a ɓe: «Ko hande woni ɲalaande sappoo e nayaɓere nden hiɗon habbii e hoore on ɲaamaali hay huunde haa jooni. ");
INSERT INTO fuf_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Mi wakkilinii on jooni ɲaamugol, ko fii ɗun no haani fii no daɗiron, awa kadi hay gooto e mon cukulol hoore mun hayrataa.» ");
INSERT INTO fuf_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Ɓay o gaynii wi'ude ɗun, o ƴetti bireedi on, o jarni Alla yeeso maɓɓe ɓe fow. Onsay o senditi, o nangani ɲaamugol. ");
INSERT INTO fuf_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Ɓay ɓe wakkilinaama, ɓe fow ɓe ɲaami. ");
INSERT INTO fuf_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Tawi wonnooɓe ka laana ɓen fow ko ɓe yimɓe teemeɗɗe ɗiɗo e cappanɗe njeeɗiɗo e njeegoo. ");
INSERT INTO fuf_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Ɓay wonii ɓe ɲaamii haa, ɓe hayfiniri laana kan bugagol ɲaametee on ka baharu. ");
INSERT INTO fuf_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Ɓay weetii, laatii ɓe anditaali leydi ndin, kono ɓe haccii salndu baharu on e pencen mun, ɓe fottani nawrugol ton laana kan si no hawri. ");
INSERT INTO fuf_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Onsay ɓe taƴi ɓoggi darnirɗe laana kan ɗin, ɓe acci ɗe ka ndiyan, ɓe acciti kadi kaɓɓi ardorɗe laana kan. Onsay ɓe fonti bagi wonɗo on ka leggal laana kan, ɓe fewtini e hendu ndun, ɓe yaari ka pencen salndu baharu on. ");
INSERT INTO fuf_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Kono ɓe hawroyi e mowre njaare e hakkunde waameeji ɗiɗi, ɓe acci laana kan saggi ɗon. Hakkee ko yeeso laana kan irii, tawi ka waawataa dillude, awa kadi hakkee ko morlooɗe ndiyan ɗen tiiɗunoo ɓaawo laana kan lancii. ");
INSERT INTO fuf_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Tawi kadi suufaaɓe ɓen no miijinoo warugol kasooɓe ɓen, fii wota hay gooto e maɓɓe fubbo laawoo. ");
INSERT INTO fuf_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Kono tawi yeesoojo suufaaɓe ɓen no aadii dandugol Puulusa, o falli ɓe waɗugol kon ko ɓe eɓɓi. O yamiri yo wawɓe fubbaade ɓen atto ukkaade fii hettoygol gaɗa, ");
INSERT INTO fuf_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","heddiiɓe ɓen kadi huutora pecce maa goɗɗun e kunte laana kan. Ko nii fow hewtiroyi gaɗa e hoore jam. ");
INSERT INTO fuf_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Ɓay men daɗii, men andi wonde suriire nde men woni e mun nden ko Malta wi'etee. ");
INSERT INTO fuf_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Yimɓe hoɗuɓe ɗon ɓen holli men teddungal mawngal, ɓe ɓanniti men fow, ɓe huɓɓi yiite sabu ndiyan ɗan e jaangol ngol. ");
INSERT INTO fuf_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Onsay Puulusa ƴetti donkun leɗɗe, ukki ka yiite. Kono sabu nguleendi yiite ngen, kuuraari sortii ton siŋii jungo makko ngon. ");
INSERT INTO fuf_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Ɓay ɓen yimɓe nden suriire yi'ii ngin kullii no siŋii mo jungo ngon, ɓe wi'indiri: «Wa jooni oo neɗɗo ko ittoowo hoore, ko fii ko karahan o daɗiri ka baharu, kono ɲaawoore nden accataa o wuura.» ");
INSERT INTO fuf_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Kono laatii Puulusa piɗɗii kullii ngin ka nder yiite e hoore o heɓaali bone woo. ");
INSERT INTO fuf_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Tawi ɓen yimɓe ko habbii woo ko yi'ugol ka o ɓuuti maa ka o yanata, o maaya kisan. Kono ɓay ɓe habbike haa, ɓe yi'aali hay huunde ko heɓi mo, ɓe yiltitii, ɓe wi'i ko o allaajo. ");
INSERT INTO fuf_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Tawi nokkuure no moggo ɗon, nde ɓurɗo teddude e suriire nden no wi'ee Pubiliyuusa jeyi. On jaɓɓii men, o werni men ɗon e hoore giggol e nder balɗe tati. ");
INSERT INTO fuf_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Tawi ben Pubiliyuusa no nawni, waalii nguli-ɓandu e dogu-reedu. Onsay Puulusa naati ka makko, *fawi juuɗe ɗen e hoore makko, o toranii mo Alla, o ndikkini mo. ");
INSERT INTO fuf_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Ɓawto ɗun nawnuɓe ɓen ka suriire fow ari e makko, o ndikkini ɓen kadi. ");
INSERT INTO fuf_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Onsay ɓe waɗani men teddungal njanal. Ɓay wonii men fokkitii kadi, ɓe waɗani men dokke ɗe men handi e mun. ");
INSERT INTO fuf_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Ɓawto koɗagol amen e nder lebbi tati, men ƴawi ɗon e laana iwruka Aleksandiri, ruumunooka e nden suriire, maandiniranooka sanamuuji funeeji ɗin. ");
INSERT INTO fuf_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Ɓay men hewtoyii Sirakuusa, men woni ɗon balɗe tati. ");
INSERT INTO fuf_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Ɓay men iwii ɗon, e nder ko men takkotoo kon, men hewti Regiyuuna. Bimbi nden ɲande hendu ndun immori ka ɲaamo ɓaawo amen, e nder balɗe ɗiɗi tawi men hewtii Pusolii. ");
INSERT INTO fuf_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Men tawi ɗon musiɓɓe goo, ɓen torii men wondugol e maɓɓe ɗon balɗe jeeɗiɗi, ko nii men yaari Roomu. ");
INSERT INTO fuf_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Musiɓɓe wonɓe e nden saare, humpitinooɓe fii amen ɓen, ari haa e ndee nokkuure fottirde wonde Apiyuusu e haa e ngoo hoɗo wi'eteengo Cuuɗi Tati Hoɓɓe, fii fottugol e amen. Ɓay Puulusa yi'ii ɓe, o jarni Alla, o ɓeydi wakkilaare. ");
INSERT INTO fuf_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Ɓay men hewtii Roomu, Puulusa newnanaa wonugol feere wondude e suufaajo goo ko ayna mo. ");
INSERT INTO fuf_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Balɗe tati ɓawto ɗun, kanko Puulusa o nodditi mokobaaɓe Yahuudiyankeeɓe ɓen. Ɓay wonii ɓe mooɓondirii, onsay o hewtini ɓe ndee yewtere ɗoo, o wi'i: «Musiɓɓe, e ɓaawo waɗugol an jamaa on hay huunde maa dartagol aadaaji maamiraaɓe men ɓen, mi wattaama e juuɗe Roomiyankooɓe ɓen, mi sokaa gila Yerusalaam. ");
INSERT INTO fuf_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Ɓay ɓen gaynii landaade lan, ɓe faalaa lan accitude, ɓay ɓe yi'aali e an huunde ko foddi e mayde. ");
INSERT INTO fuf_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Kono Yahuudiyankeeɓe ɓen dartii. Mi tawi min kadi bee mi hewta lanɗo mawɗo Roomu on e hoore mi miijaaki tooɲude jamaa an on. ");
INSERT INTO fuf_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Ko fii ɗun mi faaliranoo on yiirude, mi yewta on, ko fii ko sabu tanƴinaare *Isra'iilayankeeɓe ɓen mi jolkiraa ngal jolokowal.» ");
INSERT INTO fuf_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Ɓen kadi jaabii mo, wi'i: «Men hendaaki ɓataake woo iwruɗe ka diiwal Yahuuda fii maa, awa kadi hay gooto e musiɓɓe ɓen araali hewtini men goɗɗun maa wowlu-maa ko boni. ");
INSERT INTO fuf_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Kono meɗen faalaa andirde ma ko miijiɗaa. Ko fii meɗen andi ndee fedde ko liddondirteende ka woni woo.» ");
INSERT INTO fuf_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Onsay ɓe bugitii e ɲalaande goo. Ɓay wonii nden ɲalaande nde ɓe haldi hewtii, ɗuuɗuɓe ari ka makko ɓuri aranun. E nder ko o sifotoo kon, tawi himo seeditaade fii *laamu Alla ngun, awa kadi himo rewrude e Sariya Muusaa on e defte annabaaɓe ɓen fii holnugol ɓe fii Iisaa, ɗun waɗi gila bimbi haa kiikiiɗe. ");
INSERT INTO fuf_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Woɓɓe felliti sabu ko o wowli kon, woɓɓe ronki hoolaade. ");
INSERT INTO fuf_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Ɓay wonii ɓe fokkitii e ɓaawo nanondiral maɓɓe, Puulusa ɓeyditi ɗii konguɗi ɗoo, o wi'i: «Ruuhu Seniiɗo on yewtiri baabiraaɓe mon ɓen haqiiqa, rewrude e annabi Isaaya, o wi'i: ");
INSERT INTO fuf_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‹Yahu e oo jamaa, wi'aa: On nanay, kono on faamataa, on ndaaray kadi, kono on yi'ataa. ");
INSERT INTO fuf_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Ko fii ɗee ɓerɗe oo jamaa wonii yooruɗe, ɓe uddii noppi maɓɓe ɗin, awa kadi ɓe ombii gite ɗen, sakko ɓe yiira gite maɓɓe ɗen, maa ɓe nanira noppi maɓɓe ɗin, maa ɓe faamira ɓerɗe maɓɓe ɗen haa ɓe tuuba, mi sellina ɓe.› ");
INSERT INTO fuf_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","29","Kanko Puulusa o ɓeyditi, o wi'i: «Andee, oo kisiyee Alla addanaama ɓe wonaa Yahuudiyanke ɓen, awa-le kamɓe ɓe heɗoto mo.» ");
INSERT INTO fuf_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Ɓawto ɗun, Puulusa daakii ka o woni ɗon e nder duuɓi ɗiɗi timmuɗi, e hoore himo tolna kala araynooɗo ka makko. ");
INSERT INTO fuf_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","O waajoo fii laamu Alla ngun, o jannira kadi fii Iisaa Almasiihu Joomi on pellital timmungal e ɓaawo haɗeede woo kadi.");
INSERT INTO fuf_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Immorde e an min Puulusa, nduu kurkaadu Iisaa Almasiihu on, noddaaɗo wonugol *sahaabaajo, waɗaaɗo feere fii yottingol Kibaaru Moƴƴo Alla on. ");
INSERT INTO fuf_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Hari Allaahu on fodiriino oo Kibaaru immorde e annabaaɓe ɓen e nder bindi seniiɗi ɗin. ");
INSERT INTO fuf_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Tawi ko on Kibaaru sifii ko fii Ɓiɗɗo makko on: ka baŋŋe ɓandu ko e bolondaa Daawuuda o jibinaa, ");
INSERT INTO fuf_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","ka baŋŋe *Ruuhu Seniiɗo on, immintineede makko e hakkunde mayɓe ɓen ɓanginirii bawgal ko o *Ɓiɗɗo Alla, ɗun ko Iisaa Almasiihu Joomi men on. ");
INSERT INTO fuf_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Ko kanko men heɓiri moƴƴere e sahaabankaaku fii ardagol yimɓe e nder leƴƴi ɗin fow e innde makko fii gomɗingol mo e ɗoftagol mo. ");
INSERT INTO fuf_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Onon kadi hiɗon tawdaa e maɓɓe, onon ɓee ɓe Alla noddi yo wonu ɓe Iisaa Almasiihu on. ");
INSERT INTO fuf_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Onon wonɓe Roomu ɓen fow, noddaaɓe wonugol ɓe Alla yiɗi e jeyaaɓe Alla: yo ɓuttu e moƴƴere wonan on immorde e Alla, on Baabaajo men, e Iisaa Almasiihu Joomi on. ");
INSERT INTO fuf_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Miɗo jarnude taho on Alla an, immorde e Iisaa Almasiihu on, fii mon on fow, ko fii gomɗinal mon ngal ko lollungal e aduna on fow. ");
INSERT INTO fuf_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Alla, on mo mi rewirta ruuhu an on e nder yottingol Kibaaru Moƴƴo Ɓiɗɗo makko on, ko seedee an wonde miɗo maandinde fii mon ɲande woo ka toraaje an. ");
INSERT INTO fuf_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Awa kadi miɗo toraade Alla soono woo, si tawii ko faale makko heɓugol feere no mi yaara ka mon jooni. ");
INSERT INTO fuf_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Ko fii miɗo faalaa yi'ude on fota fii hewtingol on dokkal goo iwrungal e Ruuhu Alla on fii no tabitiron, ");
INSERT INTO fuf_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","maaɗun fii no wakkilindiriren ka mon, mo kala e men wakkilora gomɗinal oya ngal. ");
INSERT INTO fuf_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Mi faalaaka yo on ronku andude, yo musiɓɓe an, wonde soono woo mi eɓɓay yahugol yi'a on, fii no mi soɲitira battane moƴƴe hakkunde mon, onon kadi, wano ɓeya ɓe wonaa Yahuudiyanke heddiiɓe non. Kono haa jooni mi heɓaali feere. ");
INSERT INTO fuf_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Ko fii no farlii mi andingol *Gereekiyankeeɓe ɓen e leƴƴi ɗi finaa ɗin, e faamuɓe ɓen e njofooɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Ko ɗun waɗi si miɗo faalaa yottingol e mon Kibaaru Moƴƴo on, onon wonɓe Roomu ɓen kadi. ");
INSERT INTO fuf_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Ko fii mi hersiraa Kibaaru Moƴƴo on, ɗun ko bawgal Alla fii kisiyee wonannde kala gomɗinɗo, ko adii kon taho ko *Yahuudiyankeeɓe ɓen, hikki ɗon ɓe wonaa Yahuudiyanke ɓen. ");
INSERT INTO fuf_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Ko ɗun waɗi, peewal Alla ngal no ɓanginireede Kibaaru Moƴƴo on, gila ka gomɗinal fuɗɗi haa ka ngal hatti, wano windori non: «Feewuɗo on wuuriray gomɗinal ngal.» ");
INSERT INTO fuf_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Tikkere Alla nden no ɓangi iwrude ka kammu e hoore kala junuubu e kala bone ko yimɓe suuɗirayɓe goonga on kuuɗe mun bonɗe waɗata. ");
INSERT INTO fuf_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Ko fii ko waawaa andeede e Alla kon no feeɲani ɓe kamɓe, ɓay Alla feɲɲinanii ɓe ɗun. ");
INSERT INTO fuf_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Ɓay, ko yi'otaako kon e Alla, ɗun ko bawgal makko poomayankewal ngal e allankaaku makko ngun, kuuɗe makko ɗen no ɓangini ɗun fota gila ka fuɗɗoode aduna. Ɓe alaa lamitorgal. ");
INSERT INTO fuf_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Ko fii nde ɓe andunoo Alla, ɓe ronki mo mawninirde wa Alla, awa kadi ɓe jarnaali mo, kono ɓe majjiri haalaaji mehi, ɓerɗe maɓɓe ɗe alaa faamu ɗen kadi yollii ka nder niɓe. ");
INSERT INTO fuf_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","E nder ko ɓe mantorta ko ɓe faamuɓe kon, ɓe laatii njofooɓe. ");
INSERT INTO fuf_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Ɓe lontiniri mangu Alla, mo maayataa on, mbaadiiji lontiiɗi neɗɗanke maayayɗo e colli e kulle yaarooje koyɗe nay e kulle daasotooɗe. ");
INSERT INTO fuf_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Ko ɗun waɗi si Alla accidi ɓe e himmeeji ɓerɗe maɓɓe e angal laaɓal, fii no ɓe hayfinira ɓalli maɓɓe ɗin kamɓe tigi. ");
INSERT INTO fuf_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Ɗun ko ɓen lontinirɓe goonga Alla on fenaande, yanganiiɓe rewi ko tagaa kon, ɗoo e ɓe yanganaade rewa Taguɗo on, on mo mantoore wonani haa poomaa. Aamiina! ");
INSERT INTO fuf_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Ko ɗun si Alla accidi ɓe e himmeeji maɓɓe hersiniiɗi ɗin. Ko fii rewɓe maɓɓe ɓen lontinirii dewle mun ɗen e kuuɗe harmuɗe. ");
INSERT INTO fuf_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Worɓe ɓen kadi wano non, ɓe seli yiidugol e rewɓe ɓen, hiɓe huɓɓani faaleeji hakkunde maɓɓe kamɓe worɓe ɓen, hiɓe yiida hakkunde maɓɓe e mbalndi, hiɓe hettude njoddi handundi e majjere maɓɓe nden. ");
INSERT INTO fuf_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Ɓay ɓe sikkii moƴƴaa ka ɓe anda Alla, Alla accidi ɓe e ngun faamu ɓoyliingu, fii waɗugol piiji ɗi haanaa. ");
INSERT INTO fuf_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Ko ɓe heewuɓe nooneeji ɗi feewaa e bonkiiji e miile e bone e nawliigu e warugol e yeddondiral e kippugu e hunƴeendi e baddi. ");
INSERT INTO fuf_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","Ko ɓe ɲo'ooɓe, aɲuɓe Alla, yennooɓe. Ko ɓe mawnintiniiɓe e mantiiɓe e sincooɓe ko boni e murtanɓe mawɓe mun, ");
INSERT INTO fuf_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","ɓe aldaa e faamu, ɓe sellaa kongol, ɓe aldaa e giggol, ɓe aldaa e yurmeende. ");
INSERT INTO fuf_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Fii kala hiɓe andi yamiroore Alla feewunde nden ko wi'i kon wonde ɓen waɗayɓe ɗin piiji ko fodduɓe e mayde, hiɓe waɗude ɗun, hiɓe jaɓani kadi ɓen wonɓe waɗude ɗun. ");
INSERT INTO fuf_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","An kadi non, oo feloowo, a maraa lamitorgal woo. Ko fii nde hiɗa fela ɓeya, haray hiɗa fawude hoore maa ɲaawoore an tigi. Ko fii an, wonɗo felude on, hiɗa waɗirde wa maɓɓe. ");
INSERT INTO fuf_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Hiɗen andi, ɓen warrooɓe non, Alla ɲaawiray ɓe goonga on. ");
INSERT INTO fuf_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","An oo feloowo ɓen waɗirooɓe non, hara hiɗa waɗira non tigi, a sikku a daɗay ɲaawoore Alla nden? ");
INSERT INTO fuf_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Kaa a yawiti ngaluuji moƴƴere makko nden e muɲal makko ngal e yondinaare makko nden, e ɓaawo andugol wonde moƴƴere Alla nden no pooɗude ma e tuubuubuyee? ");
INSERT INTO fuf_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Kono sabu sattere maa fii nden e ɓernde maa yoorunde nden, hiɗa mooɓa tikkere fii ɲalaande tikkere nden, ɗun ko fii ɲande feeɲugol ɲaawoore Alla feewunde nden, ");
INSERT INTO fuf_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","on Jonnitoyoowo mo kala njoddi kuuɗe mun ɗen. ");
INSERT INTO fuf_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Ngurndan poomayankejan* ɗan wonanay ŋaɲɲiiɓe e waɗugol ko moƴƴi, ɗaɓɓa darja on e teddungal e ngurndan ɗan lannataa ɗan, ");
INSERT INTO fuf_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","kono wonduɓe e haasidi ɓen, salii ɗoftaade goonga on fii ɗoftagol angal peewal ngal: tikkere e monee no maranaa ɓe. ");
INSERT INTO fuf_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Satteende e annde wonanii kala waɗoowo ko boni, ko adii kon ko Yahuudiyankeeɓe ɓen, hikki ɗon ɓe wonaa Yahuudiyanke ɓen. ");
INSERT INTO fuf_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Kono darja e teddungal e ɓuttu wonanii kala on waɗoowo ko moƴƴi, ko adii kon ko Yahuudiyankeeɓe ɓen, hikki ɗon ɓe wonaa Yahuudiyanke ɓen. ");
INSERT INTO fuf_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Ko fii giɗaale alaa ka Alla. ");
INSERT INTO fuf_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Kala ɓen waɗuɓe junuubu e ɓaawo andugol Sariya on, mulay e ɓaawo Sariya on. E kala non kadi waɗuɗo junuubu e hoore andugol Sariya on, ɲaawirte Sariya on. ");
INSERT INTO fuf_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Ko ɗun waɗi, hinaa heɗotooɓe Sariya on woni feewuɓe yeeso Alla, kono ko ɗoftotooɓe Sariya on jogortee feewuɓe. ");
INSERT INTO fuf_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Si tawii non ɓe wonaa Yahuudiyanke ɓen, ɓen ɓe maraa Sariya, waɗii ko Sariya on wi'i kon tigi, ɗun ko ɓen ɓe maraa Sariya, haray hiɓe mari sariya fii maɓɓe kamɓe tigi. ");
INSERT INTO fuf_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Ɗun haray ɓe ɓanginii wonde kuugal Sariya on no windii ka ɓerɗe maɓɓe, fondo maɓɓe ngon no seeditaade ɗun, miijooji maɓɓe ɗin kadi no felude ɓe e saa'i goo, e saa'i goo no dandude ɓe. ");
INSERT INTO fuf_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Ko ɗun fow feeɲoyta ɲande Alla ɲaawoyta miijooji ɓerɗe yimɓe suuɗiiɗi ɗin, o ɲaawiroya ɗi Iisaa Almasiihu on, wano Kibaaru Moƴƴo mo mi yottini on holliri non. ");
INSERT INTO fuf_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","An oo wi'itiiɗo Yahuudiyanke, hoolorɗo Sariya on, wonɗo mantorde Alla, ");
INSERT INTO fuf_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","anduɗo faale makko on, waawuɗo sendindirde ko ɓuri moƴƴude kon, ɓay ko a jangirɗo Sariya on, ");
INSERT INTO fuf_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","an oo hooliiɗo wonay ardotooɗo bumɓe, hoolii kadi wonanay ɓen wonɓe ka niwre ndaygu, ");
INSERT INTO fuf_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","andinoowo ɓen ɓe alaa faamu, karamokoojo fayɓe, ɓay hiɗa mari gandal timmungal e goonga selluɗo ka nder Sariya: ");
INSERT INTO fuf_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","awa an, oo wonɗo jannude ɓeya, e hara a alaa jannitaade an tigi? An, oo waajotooɗo wota wujje, hinaa hiɗa wujjude? ");
INSERT INTO fuf_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","An, oo wonɗo wi'ude wota jeene, hinaa hiɗa jeenude? An, oo aɲuɗo sanamu, hinaa hiɗa wujjude ɗi, huutoraa? ");
INSERT INTO fuf_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","An, oo darjinorɗo Sariya on, hinaa hiɗa hayfinirde Alla bonnugol Sariya on? ");
INSERT INTO fuf_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Ko fii no windii: «Sabu mon innde Alla nden no hoyneede e hakkunde ɓe wonaa Yahuudiyanke ɓen.» ");
INSERT INTO fuf_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","No fellitaa wonde *sunninegol no hitti, si tawii a huutorii Sariya on, kono si a bonnii Sariya on, haray ko sunninaɗaa kon wonii meere. ");
INSERT INTO fuf_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Si tawii non mo sunninaaka on ɗoftike yamirooje Sariya on, hara angal sunninegol makko ngol jaɓirtaake wa sunninaaɗo? ");
INSERT INTO fuf_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Awa, on neɗɗo mo sunninaaka e ɓandu, timminɗo Sariya on, ɲaawete an oo mo ɗoftaaki Sariya on, fii kala hiɗa wondi e bindi ɗin e sunninannde nden. ");
INSERT INTO fuf_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Yahuudiyankeyaagal wonaa ka kene, sunninannde kadi hinaa feeɲunde e ɓandu nden. ");
INSERT INTO fuf_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Kono Yahuudiyankeejo, ko wonɗo ɗun ka nder. Sunninannde haqiiqaare nden ko nde ka ɓernde, yaadunde e Ruuhu Allaahu on, hara hinaa yaadunde e bindi nden. Mantoore sifa on Yahuudiyankeejo wonaa e yimɓe ɓen iwrata, kono ko e Alla. ");
INSERT INTO fuf_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Ko ɓural hongal Yahuudiyanke mari? E ko honɗun woni nafa *sunninegol? ");
INSERT INTO fuf_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","No mari nafa e ɗi fow. Ko adii kon, daaluyeeji Alla ɗin ko Yahuudiyankeeɓe ɓen halfinaa. ");
INSERT INTO fuf_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","E ko honɗun si woɓɓe e maɓɓe wonaali sella-findeeɓe? E hara ngal angal sella-findeyaagal maɓɓe ɗuytay goɗɗun e sella-findeyaagal Alla ngal? ");
INSERT INTO fuf_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Pellet hinaa non! Hay si yimɓe ɓen fow ko fenooɓe, Alla kan ko goongaajo, wano windori non wonde: «Peewal maa ngal no feeɲira konguɗi maa ɗin, nde ɲaawaɗaa woo wonaa fooluɗo.» ");
INSERT INTO fuf_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Si tawii non angal peewal men ngal feɲɲinii wonde Alla ko feewuɗo, haray ko honɗun wi'eten? Kere si Alla tippinii tikkere makko nden, haray hinaa o Feewuɗo? (Ɗun ko haala neɗɗanke non!) ");
INSERT INTO fuf_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Pellet hinaa non! Si hinaa ɗun, ko honno Alla ɲaawirta aduna on? ");
INSERT INTO fuf_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","E si tawii fenaande an nden no ɓurtude ɓanginde goonga Alla on fii darja makko on, haray ko fii honɗun min tigi mi ɲaawirtee wa junuubankeejo haa jooni? ");
INSERT INTO fuf_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Awa ko honɗun haɗi wi'en, wano aybinooɓe goo wi'irta wonde hiɗen wi'a: «Waɗen ko boni, fii ko moƴƴi yo yaltu.»? Donkineede ɓen yimɓe ko ko feewi! ");
INSERT INTO fuf_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Awa, enen Yahuudiyankeeɓe, ko honɗun ɓurɗen ɓeya? Hay fus! Ko fii en ɓanginii wonde kala Yahuudiyankeejo e mo wonaa Yahuudiyanke no e nder junuubu, ");
INSERT INTO fuf_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","wano windori non: «Feewuɗo alaa, hay e gooto non! ");
INSERT INTO fuf_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Hay gooto alaa faamu, hay gooto alaa ɗaɓɓude Alla. ");
INSERT INTO fuf_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Fow ko huccuɓe Alla, awa kadi ɓe fow ko ɓe ɓoyliiɓe, hay gooto alaa wonɗo waɗude ko moƴƴi, hinaa non hay e gooto! ");
INSERT INTO fuf_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Kononɗi maɓɓe ɗin ko genaale udditiiɗe, hiɓe huutora ɗenɗe maɓɓe ɗen fii janfagol, tuutaaɗe toni maɓɓe ɗin ko tooke mboddi. ");
INSERT INTO fuf_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Kundule maɓɓe ɗen no heewi kuddi e hahhannde, ");
INSERT INTO fuf_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","koyɗe maɓɓe ɗen no hawjani hibbugol ƴiiƴan, ");
INSERT INTO fuf_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","yeebaare e tampere no ka ɗate maɓɓe. ");
INSERT INTO fuf_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Ɓe andaali ɗatal ɓuttu ngal, ");
INSERT INTO fuf_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","awa kadi kulol Alla alaa e gite maɓɓe.» ");
INSERT INTO fuf_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Hiɗen andi wonde ko Sariya on wi'i kon fow ko wonɓe e ley Sariya on wi'aa, fii no kala hunduko ombiree, e no Alla ɲaawira yimɓe aduna on fow. ");
INSERT INTO fuf_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Ko fii hay gooto jogortaake feewuɗo yeeso Alla fii ko o ɗoftii Sariya on kon, ko fii ko immorde e Sariya on junuubu andori. ");
INSERT INTO fuf_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Kono jooni, Alla feɲɲinii ko honno goɗɗo waawetee jogoreede feewuɗo yeeso Alla e ɓaawo Sariya on, wano Sariya on e annabaaɓe ɓen seeditori non. ");
INSERT INTO fuf_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Alla jogoray yimɓe ɓen feewuɓe sabu ko ɓe gomɗini Iisaa Almasiihu on kon, ɗun ko gomɗinɓe ɓen fow. Ko fii sendondiral alaa: ");
INSERT INTO fuf_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","fow waɗii junuubu, ɓe waawataa hewtude mangu Alla ngun. ");
INSERT INTO fuf_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Awa ko tippude e dokkal moƴƴuki makko kin ɓe jogoraa feewuɓe rewrude e cottudi wondi e Iisaa Almasiihu on ndin, ");
INSERT INTO fuf_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","on mo Alla toɗɗii wonugol sadaka fii, rewrude e ƴiiƴan makko ɗan, no gomɗinɓe mo ɓen heɓira yaafuyee junuubaaji. Alla waɗi ɗun fii ɓangingol peewal mun ngal, ko fii o donkinaali ɓee waɗunooɓe junuubi feƴƴunooɗi ɗin fewndo muɲal makko ngal. ");
INSERT INTO fuf_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","O faalaama ɓanginde peewal makko ngal e oo saa'i fewndiiɗo, ɗun fow ko fii no andiree ko o Feewuɗo, o jogitora on gomɗinɗo Iisaa wa feewuɗo. ");
INSERT INTO fuf_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Ko dalil honɗun non mantortee? Dalil woo alaa! Maa ko sabu honɗun? Hara ko kuuɗe ɗen? Oo'o, kono ko gomɗinal ngal. ");
INSERT INTO fuf_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Ko fii hiɗen wi'a wonde ko sabu gomɗinal ngal neɗɗo jogoraa feewuɗo, e ɓaawo ɗoftagol Sariya on. ");
INSERT INTO fuf_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Kaa hara Alla ko Alla Yahuudiyankeeɓe ɓen tun? E hinaa o Alla ɓe wonaa Yahuudiyanke ɓen kadi? Hiiyii, ko o Alla ɓe wonaa Yahuudiyanke ɓen kadi! ");
INSERT INTO fuf_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Ɓay ko Alla gooto woni jogorɗo sunninaaɓe ɓen feewuɓe sabu gomɗinal maɓɓe ngal, o jogora ɓe sunninaaka ɓen kadi feewuɓe sabu gomɗinal mun ngal. ");
INSERT INTO fuf_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","E hara ɗun no firi wonde en bonnitirii Sariya on gomɗinal ngal? Pellet wonaa non! Ka liddu ɗun, hiɗen tambitaade Sariya on! ");
INSERT INTO fuf_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Awa ko honɗun wi'eten fii Ibraahiima, oo maamiraawo amen iwrude ka ƴiiƴan? Ko honɗun o heɓi? ");
INSERT INTO fuf_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Si tawno ko sabu kuuɗe ɗen Ibraahiima jogoranoo feewuɗo, harayno himo mari feere mantagol. Kono hinaa non woniri yeeso Alla! ");
INSERT INTO fuf_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Ko honɗun bindi ɗin wi'i e ɗun? «Ibraahiima gomɗini Alla, ngal gomɗinal makko jogoranaa mo peewal.» ");
INSERT INTO fuf_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","E hin-le, on mo golli, njoddi makko ndin jogitoranaaka mo wa dokkal, kono ko ko haani. ");
INSERT INTO fuf_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","On mo gollaali non, kono gomɗini Alla on Jogoroowo ɓe feewaa ɓen feewuɓe, haray gomɗinal makko ngal no jogoranaa mo peewal. ");
INSERT INTO fuf_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Daawuuda kadi no haali fii maloore neɗɗo mo Allaahu on jogitori feewuɗo e ɓaawo kuugal: ");
INSERT INTO fuf_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","«Maloore wonanii ɓen ɓe bonkiiji mun ɗin yaafaa, ɓe tawata junuubaaji mun ɗin montaama. ");
INSERT INTO fuf_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Maloore wonanii on neɗɗo, mo Joomiraaɗo on jogoraali junuubu mun.» ");
INSERT INTO fuf_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","E hara nden maloore ko fii sunninaaɓe ɓen tun, kaa ko fii ɓe sunninaaka ɓen kadi? Ko fii hiɗen wi'a: «Ibraahiima gomɗini Alla, ngal gomɗinal makko jogoranaa mo peewal.» ");
INSERT INTO fuf_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Ko honno o wa'unoo kanko Ibraahiima fewndo ngal jaɓanaa mo? Hari o teddinaama, kaa o teddinaaka? Hari o teddinaaka taho, ko mo o teddinaaka wonnoo ");
INSERT INTO fuf_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","fewndo o hendii maande *sunninegol ngol, wa ɓattatere peewal ngal o heɓiri gomɗinal ngal, fewndo ko o teddinanooka. Ko non o woniri ben kala gomɗinɗo, hay ɓe sunninanooka ɓen, fii no ɓe jogoree feewuɓe. ");
INSERT INTO fuf_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","O laatii kadi ben sunninaaɓe ɓen, hinaa non sunninaaɓe ɓen tun, kono kadi ko o ben ɓen jokkuɓe laawi gomɗinal ngal kanko ben men Ibraahiima o heɓunoo ngal wa fewndo ko o teddinanooka taho. ");
INSERT INTO fuf_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Ko ɗun waɗi, hinaa tippude e Sariya on Ibraahiima e jurriya mun on fodiraa ronugol aduna on, kono ko tippude e peewal iwrungal e gomɗinal ngal. ");
INSERT INTO fuf_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Si tawno ko tippude e Sariya on ronirten, harayno gomɗinal ngal ko fus, awa kadi harayno fodaari ndin firtaama. ");
INSERT INTO fuf_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Ko fii Sariya on ko tikkere rimata. Ka Sariya on non alaa ɗon, haray bonnugol Sariya on alaa. ");
INSERT INTO fuf_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Awa, ko ɗun waɗi ko gomɗinal ngal fodaari ndin ronirtee, fii no laatora dokkal moƴƴere, fii no jurriya on fow hendora fodaari ndin, wonaa non jogiiɓe Sariya on tun, kono ko hay jogiiɓe gomɗinal Ibraahiima maama men ngal en fow, ");
INSERT INTO fuf_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","wano windori non: «Mi waɗii ma maamaajo leƴƴi ɗuuɗuɗi.» Ko o maama men en fow yeeso Alla, on mo o gomɗini, on Yeɗoowo mayɓe ɓen ngurndan, on Woodinoowo ko woodanooka. ");
INSERT INTO fuf_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","O tanƴinii ka tama'u alaa, o gomɗini. Ko nii o woniri maamaajo leƴƴi ɗuuɗuɗi, wano daaliranoo non: «Ko nii jurriya maa on ɗuuɗiroyta!» ");
INSERT INTO fuf_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","E ɓaawo lo'angol gomɗinal ngal, o tawi ɓandu makko ndun fayda ko mayndu, ko fii hari moggo o teeminii, awa kadi hari dimdimol Saarata ngol ko mayngol. ");
INSERT INTO fuf_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Awa o hutitoraali fodaari Alla ndin sabu angal gomɗinal, kono o wonti tiiɗa-gomɗinaljo, o mawnini Alla. ");
INSERT INTO fuf_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","O felliti wonde Alla no mari bawgal hunnugol ko o fodi kon. ");
INSERT INTO fuf_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Ko ɗun waɗi si gomɗinal makko ngal jogoranaa mo peewal. ");
INSERT INTO fuf_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Hinaa fii makko kanko tun ɗun windiraa, ");
INSERT INTO fuf_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","kono ko fii men, enen kadi, enen ɓee jogorteeɓe feewuɓe, gomɗinɓe on Immintinɗo Joomi men on Iisaa e hakkunde mayɓe ɓen, ");
INSERT INTO fuf_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","ittaaɗo sadaka fii bonnereeji men ɗin, e immintinaaɗo fii yo en jogoree wa feewuɓe. ");
INSERT INTO fuf_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Nde tawnoo en jogoraama feewuɓe sabu gomɗinal men ngal, hiɗen mari ɓuttu e Alla rewrude e Iisaa Almasiihu Joomi men on. ");
INSERT INTO fuf_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Ko sabu makko heɓirɗen, iwrude e gomɗinal ngal, naatirgal e oo sulfu, mo wonɗen e mun, tabituɗen. Hiɗen mantorde on tama'u mo marɗen fii mangural Alla ngal. ");
INSERT INTO fuf_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Ko ɓeyditii e ɗun, hiɗen mantorde hay e nder tampereeji ɗin, e hoore andugol wonde tampereeji ɗin rimay ŋaɲɲagol, ");
INSERT INTO fuf_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","ŋaɲɲagol ngol kadi ardoo haa e jikku timmuɗo, jikku timmuɗo on kadi adda tama'u. ");
INSERT INTO fuf_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","E hin-le tama'u on hersinoytaa, ko fii Alla juuriri giggol makko ngol ka ɓerɗe men *Ruuhu Seniiɗo mo yeɗaɗen on. ");
INSERT INTO fuf_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Ko fii fewndo tawnoo en maraa doole, e saa'i toɗɗaaɗo on *Almasiihu on mayno fii ɓe rewataa Alla ɓen. ");
INSERT INTO fuf_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Ko karahan goɗɗo jaɓirta maayande aaden feewuɗo, kono no gasa ka goɗɗo wakkiloo maayangol neɗɗo moƴƴo. ");
INSERT INTO fuf_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Kono e nder ɗun, Alla ɓanginii giggol mun ngol fii men: wa fewndo wonnoɗen junuubankeeɓe, Iisaa Almasiihu on mayno fii men. ");
INSERT INTO fuf_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Jooni, ɓay en jogoraama feewuɓe sabu ƴiiƴan makko ɗan, haray ko honno ronkirten dandireede tikkere nden sabu makko? ");
INSERT INTO fuf_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Si tawii fewndo wonnoɗen ayɓe makko kanko Alla, o moƴƴintinirii hakkunde men e makko sabu mayde Ɓiɗɗo makko on, haray ko haa honto non dandirteɗen ngurndan makko ɗan, enen moƴƴintinidaaɓe e makko kanko Alla ɓen! ");
INSERT INTO fuf_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Ko ɓeyditii e ɗun, hiɗen mantorde Alla sabu Iisaa Almasiihu Joomi men on, on wonɗo sabu moƴƴintingol hakkunde men e Alla. ");
INSERT INTO fuf_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Ko ɗun waɗi, ko wano non, sabu aaden gooto, junuubu naatiri e aduna on, e sabu on junuubu kadi mayde nden ari, ko wano non kadi mayde nden rewiri e hoore yimɓe ɓen fow, ko fii fow waɗii junuubu. ");
INSERT INTO fuf_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Ko fii, haa fewndo addegol Sariya on, hari junuubu on no e nder aduna on, kono junuubu ndaaretaake si sariya alaa. ");
INSERT INTO fuf_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Kono mayde nden laamii gila e *Aadama haa e Muusaa, hay e hoore ɓe waɗaano junuubu ɓen wa bonnere Aadama nden, on mo tawata ko mbaadi Aroyoowo on. ");
INSERT INTO fuf_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Kono bonnere Aadama nden e dokkal Alla ngal wonaa gootun. Si tawii buy maayii sabu bonnere aaden gooto, ɗun ko Aadama, haray ko haa honto non moƴƴere Alla nden, e dokkal iwrungal e moƴƴere on aaden gooto, ɗun ko Iisaa Almasiihu on, layirta haa heewa e hoore ɗuuɗuɓe! ");
INSERT INTO fuf_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Ko wano non, battane junuubu aaden gooto e dokkal Alla ngal wonaa gootun. Ko fii ɲaawoore nden ɓawto junuubu gooto ko addi ko donkineede, e hin-le dokkal ngal ɓawto bonnereeji ɗuuɗuɗi ko addi ko jogoreede wa feewuɓe. ");
INSERT INTO fuf_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Si tawii, sabu bonnere aaden gooto, ɗun ko Aadama, mayde nden laamorii immorde e makko kanko tun, haray ko haa honto heɓuɓe moƴƴere heewunde e dokkal peewal ɓen laamotoo ka ngurndan, sabu oo gooto, ɗun ko Iisaa Almasiihu on! ");
INSERT INTO fuf_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Ko ɗun waɗi, si tawii donkinannde bonnere aaden gooto hewtii yimɓe ɓen fow, ko wano non kadi, ko sabu kuugal feewungal gootal, peewal yeɗayngal ngurndan ngal hewtiri yimɓe ɓen fow. ");
INSERT INTO fuf_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Nde tawnoo ɗuuɗuɓe laatike junuubankeeɓe sabu angal ɗoftaare aaden gooto, ɗun ko Aadama, ko wano non kadi ɗuuɗuɓe laatortoo feewuɓe sabu ɗoftaare aaden gooto, ɗun ko Iisaa Almasiihu on. ");
INSERT INTO fuf_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","E hin-le ko Sariya on arani, ko fii yo bonnereeji ɗin ɓeydo. Kono ka junuubu on ɓeydii ɗon, ko ɗon sulfu on ɓeydii ɓeydaadee. ");
INSERT INTO fuf_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Ko wano junuubu on ɓanginiri bawgal mun mayde non, ko wano non kadi sulfu Alla on ɓanginiri bawgal mun ngal peewal nawrayngal e *ngurndan poomayankejan ɗan immorde e Iisaa Almasiihu Joomi men on. ");
INSERT INTO fuf_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Awa ko honɗun wi'eten? En duumoto e waɗugol junuubu on fii yo sulfu on ɓeydo? ");
INSERT INTO fuf_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Pellet hinaa non! Enen, ɓee mayɓe e telen-ma junuubu, ko honno non wuurirten e nder junuubu kadi? ");
INSERT INTO fuf_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","E on andaa wonde, enen ɓee *lootaaɓe maande kisiyee e nder humondiral e Iisaa Almasiihu on fow, ko e mayde makko nden tawdaɗen? ");
INSERT INTO fuf_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Awa, en surridaama e makko ka nder mayde rewrude e looteede maande kisiyee nden, fii, wano *Almasiihu on imminiraa non e hakkunde mayɓe ɓen rewrude e mangu Baabaajo on, enen kadi, yo en wuuru ngurndan kesan. ");
INSERT INTO fuf_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Ko ɗun waɗi, si en yuɓɓondirii e makko ka mayde makko, pellet en woniray kadi wano non ka immintineede makko. ");
INSERT INTO fuf_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Ko fii hiɗen andi ngurndan men kiɗɗan ɗan fempidaama e makko, fii no ndun ɓandu junuubankeeru muliree, fii wota en laato hande kadi maccuɓe junuubu. ");
INSERT INTO fuf_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Ko fii kala mayɗo fuutike bawgal junuubu. ");
INSERT INTO fuf_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Si tawii en maayidii e Almasiihu on, haray hiɗen gomɗini wonde en wuuriday e makko. ");
INSERT INTO fuf_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Ko fii hiɗen andi wonde Almasiihu on immitike e hakkunde mayɓe ɓen, o maayataa hande kadi, mayde nden maraa doole hande kadi e hoore makko. ");
INSERT INTO fuf_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Nden mayde nde o maayi, ko e telen-ma junuubu o maayi, nde wootere ko yoni haa poomaa. Jooni non himo wuuri, ko Alla o wuurani. ");
INSERT INTO fuf_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Onon kadi wano non, jogoree hoore mon wa mayɓe e telen-ma junuubu, e wa wuuranɓe Alla e nder humondiral e Iisaa Almasiihu on. ");
INSERT INTO fuf_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Awa, wota junuubu laamo ɓalli mon maayayɗi ɗin, e wota on ɗofto himmeeji majji ɗin. ");
INSERT INTO fuf_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Wota on weeɓitan tere mon ɗen junuubu, wa aala fii angal peewal, kono wattee hoore mon onon tigi e Alla, wa wuuruɓe iwɓe e mayde, sakkanoɗon Alla tere mon ɗen wa aalaaji fii peewal ngal. ");
INSERT INTO fuf_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Ɗun, junuubu foolataa on, ko fii hinaa e ley Sariya on wonɗon, kono ko e ley sulfu on. ");
INSERT INTO fuf_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Jooni non, ko honno? E hara en jokkay waɗugol junuubu, ɓay hinaa e ley Sariya on wonɗen, kono ko e ley sulfu Alla on? Pellet waawataa wonde! ");
INSERT INTO fuf_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","E on andaa, si on waɗii hoore mon maccuɗo goɗɗo fii ɗoftagol mo, haray on wonii maccuɗo on mo ɗoftiɗon? Ko si on wonu maccuɓe junuubu nawroowo e mayde, maa si on wonu maccuɓe ɗoftaare nawraynde e peewal. ");
INSERT INTO fuf_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Kono ko yettude Alla, ɓawto on wonude maccuɓe junuubu on, on ɗoftorii ɓernde noone jannde nde hewtinaɗon nden. ");
INSERT INTO fuf_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Ɓay on jattinaama junuubu on, on wontii maccuɓe peewal ngal. ");
INSERT INTO fuf_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","(Ko wano neɗɗanke'en nii mi woni yewtirde, sabu lo'ere ɓalli mon ɗin.) Wano waɗirnoɗon tere mon ɗen wa kurkantooɗe angal laaɓal e angal peewal, fii sakkitorgol ka angal peewal, jooni kadi waɗiree wano non tere mon ɗen wa kurkantooɗe peewal ngal fii sakkitorgol laaɓal ngal. ");
INSERT INTO fuf_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Ko fii, fewndo wonnoɗon maccuɓe junuubu, hari on alaa kurkanaade peewal ngal. ");
INSERT INTO fuf_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Ko honɗun heɓunoɗon e ɗen kuuɗe ɗe waɗunoɗon, ɗen ɗe tawata hiɗon hersiri jooni? Ko fii sakkitoode majje on ko mayde. ");
INSERT INTO fuf_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Jooni non, onon jattinaaɓe junuubu ɓen, ko on maccuɓe Alla, ko marɗon tono ko laaɓal, sakkitoode nden kadi ko *ngurndan poomayankejan. ");
INSERT INTO fuf_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Ko fii, njoddi junuubu ko mayde, kono dokkal Alla ngal ko ngurndan poomayankejan e nder humondiral e Iisaa Almasiihu Joomi men on. ");
INSERT INTO fuf_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","E on andaa yo musiɓɓe wonde Sariya on ardoto goɗɗo fannin himo wuuri? (Miɗo yewtude on wano mi yewtirta yimɓe anduɓe Sariya on.) ");
INSERT INTO fuf_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Ko sariya on humindiri debbo ƴettaaɗo e moodi mun, yeru on no wuuri. Kono si moodi makko maayii, haray on debbo seedii e on sariya humindirnooɗo mo e moodi makko. ");
INSERT INTO fuf_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Si tawii non e nder ngurndan moodi makko, o wonii ɓeyngu gorko goo, haray o wontii jeenoowo. Kono si tawii moodibbo on maayii, haray o sendaama e sariya on. Ɗun, si goɗɗo goo ƴettii mo, haray hinaa o jeenoowo. ");
INSERT INTO fuf_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Onon kadi ko wano non, yo musiɓɓe an, on maayii e telen-ma Sariya on wondude e ɓandu Iisaa Almasiihu on, fii no jeyireɗon e goɗɗo goo, on immintinaaɗo e hakkunde mayɓe ɓen, fii no waɗiren kuuɗe welayɗe Alla. ");
INSERT INTO fuf_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Ko fii, fewndo jokkunoɗen mbeleeɗe ɓandu men ndun, hari faaleeji bonɗi yaaduɗi e junuubu immorde e Sariya on no ardotonoo tere men ɗen, fawa en kadi kuuɗe nawrayɗe e mayde. ");
INSERT INTO fuf_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Kono jooni, en seedii e Sariya on, ko fii en maayii e telen-ma kon ko waɗunoo en maccuɓe. Ko ɗun waɗi, jooni hiɗen kurkorande Alla noone keso tippude e Ruuhu makko on, hara hinaa e oya noone kiɗɗo mo Sariya. ");
INSERT INTO fuf_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Awa ko honɗun wi'eten jooni: Sariya on ko junuubu? Pellet hinaa ɗun! Kono ko sabu Sariya on mi andiri junuubu. Ko fii mi andataano ko woni himme si Sariya on wi'aano «wota mo himma!» ");
INSERT INTO fuf_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Onsay junuubu on ɓaarori yamiroore nden, o waɗi e an kala noone himme. Ko fii, si Sariya on araano, hanno junuubu on ko mayɗo. ");
INSERT INTO fuf_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","E telen-ma an min, si Sariya on alaano, hanno miɗo wuuri. Kono ɓay yamiroore nden arii, junuubu on wuuri, min mi maayi. ");
INSERT INTO fuf_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Onsay yamiroore nawraynde e ngurndan nden nawrimmi ka mayde. ");
INSERT INTO fuf_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Ko fii junuubu on ɗaynimmi ɓaarori yamiroore nden, warimmi. ");
INSERT INTO fuf_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Ɗun non, Sariya on ko *seniiɗo, yamiroore nden kadi ko seniinde, feewunde moƴƴere. ");
INSERT INTO fuf_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Awa hara ko moƴƴi kon wonanii lan mayde? Pellet oo'o! Kono ko junuubu on, fii yo o feeɲu junuubu, o waɗirii e an mayde rewrude e ko moƴƴi kon, fii yo junuubu on feeɲir no laaɓiri poy junuubu sabu yamiroore nden. ");
INSERT INTO fuf_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","E hoore ɗun, hiɗen andi wonde Sariya on ko e Alla iwri, kono min, ko mi neɗɗanke maccinaniiɗo junuubu. ");
INSERT INTO fuf_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Ko fii mi faamaa ko mi woni waɗude kon. Ko mi yiɗi kon kadi mi alaa waɗude ɗun, kono ko ko mi aɲi kon mi woni waɗude. ");
INSERT INTO fuf_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Si tawii miɗo waɗude ko mi faalaaka kon, haray miɗo jaɓi wonde Sariya on ko moƴƴo. ");
INSERT INTO fuf_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Jooni non, hinaa min han kadi woni waɗude ɗun, kono ko junuubu wonɗo e an on. ");
INSERT INTO fuf_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Ko fii miɗo andi wonde ko moƴƴi kon alaa e an, e maanaa ka ɓandu an. Ko fii min tigi miɗo wondi e faale waɗugol ko moƴƴi, kono mi alaa waɗude ɗun. ");
INSERT INTO fuf_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Mi alaa waɗude moƴƴere nde mi faalaa nden, kono miɗo waɗude bone mo mi faalaaka on. ");
INSERT INTO fuf_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Si tawii miɗo waɗude ko mi faalaaka, haray hinaa min tigi hande kadi woni waɗude ɗun, kono ko junuubu wonɗo e an on. ");
INSERT INTO fuf_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Awa e hino sariya mo mi tawi on: tuma mi faalaa waɗude ko moƴƴi woo, haray bone on no e an. ");
INSERT INTO fuf_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Ko fii Sariya Alla on no welammi ka ɓernde, ");
INSERT INTO fuf_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","kono miɗo yi'ude ka tere an sariya goo, wonɗo dartaade sariya faamu an ngun, wonɗo lan e wattude maccuɗo sariya junuubu, wonɗo e tere an ɗen. ");
INSERT INTO fuf_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Min e tampere an! Hara ko hombo jattintammi e nduu ɓandu maayooru? ");
INSERT INTO fuf_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Ko yettude Alla, immorde e Iisaa Almasiihu Joomi men on! Ko ɗun waɗi, si ka ɓernde an ko mi maccuɗo Sariya Alla on, fii kala ka ɓandu an ko mi maccuɗo sariya junuubu on. ");
INSERT INTO fuf_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Jooni donkinannde woo alanaa ɓen humondirɓe e Iisaa Almasiihu on. ");
INSERT INTO fuf_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Ko fii sariya Ruuhu ngurndan wonɗo e Iisaa Almasiihu on jattinii lan sariya junuubu e mayde on. ");
INSERT INTO fuf_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Ko fii Alla timminii ko Sariya on ronki kon, ɓay lo'ere neɗɗanke nden mehinɗinii mo. Alla muncii bawgal junuubu on ka ɓandu e nder addirgol Ɓiɗɗo makko on ɓandu nanditayndu e junuubankeeru neɗɗanke ndun. ");
INSERT INTO fuf_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Alla waɗiri ɗun fii no peewal Sariya on timmira e men, enen wonɓe jokkude Ruuhu Allaahu on, hara hinaa e mbeleeɗe ɓandu. ");
INSERT INTO fuf_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Ko ɗun waɗi, wuurirɓe mbeleeɗe ɓandu ɓen ko fii mayru miijotoo, kono wuurirɓe Ruuhu Allaahu on no miijoo fii faale Ruuhu Allaahu on. ");
INSERT INTO fuf_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Jokkugol mbeleeɗe ɓandu ko mayde, jokkugol non faaleeji Ruuhu Allaahu on ko ngurndan e ɓuttu. ");
INSERT INTO fuf_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Ko fii mbeleeɗe ɓandu no aɲi Alla, ɓay ɓandu ndun yankinantaako Sariya Alla on, ko ɓay non ndu waawataa! ");
INSERT INTO fuf_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Ko fii wonɓe e ley mbeleeɗe ɓandu ndun waawataa welude Alla. ");
INSERT INTO fuf_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Onon non, on alaa e ley mbeleeɗe ɓandu han kadi, kono ko e ley faale Ruuhu on, ɓay Ruuhu Allaahu on no e mon. Ko fii on mo Ruuhu *Almasiihu on alaa e mun, haray hinaa mo makko. ");
INSERT INTO fuf_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Si tawii Almasiihu on no e mon, haray ɓandu ndun maayii sabu junuubu on, kono haray ruuhu on no wuuri sabu peewal ngal. ");
INSERT INTO fuf_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","E si tawii Ruuhu makko kanko Immintinɗo Iisaa e hakkunde mayɓe ɓen no e mon, haray on Immintinɗo Iisaa Almasiihu on e hakkunde mayɓe ɓen yeɗay ɓalli mon mayooji ɗin ngurndan immorde e Ruuhu makko Wonɗo e mon on. ");
INSERT INTO fuf_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Ɗun haray, yo musiɓɓe, no woodi ko fawii en, hara hinaa wuurirgol mbeleeɗe ɓandu. ");
INSERT INTO fuf_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Si tawii ko mbeleeɗe ɓandu wuurirɗon, on maayay. Kono si tawii ko Ruuhu Allaahu on warirɗon mbeleeɗe ɓandu ɗen, on wuuray. ");
INSERT INTO fuf_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Ko fii kala ɓe Ruuhu Alla on ardii, ko ɓiɓɓe Alla. ");
INSERT INTO fuf_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Awa Ruuhu mo heɓuɗon on hinaa ruuhu maccangaaku fii wonugol fahin e nder kulol, kono ko Ruuhu Waɗuɗo on ɓiɓɓe Alla. Immorde e makko kanko Ruuhu on en ewnoto Alla «Abba!», ɗun ko «Baaba!» ");
INSERT INTO fuf_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Ruuhu Allaahu on tigi no seeditanaade ruuhu men on wonde ko en ɓiɓɓe Alla. ");
INSERT INTO fuf_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Ko ɗun waɗi, si tawii ko en ɓiɓɓe makko, haray kadi ko en ronooɓe mo kanko Alla, ronidooɓe e Almasiihu on, si tawii e nder haqiiqa hiɗen tampidude e makko fii no tawireɗen e mangural makko ngal. ");
INSERT INTO fuf_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Miɗo felliti tampereeji oo saa'i fewndiiɗo foddaa eɓɓindireede e mangu aroyoowu feɲɲinanoyteengu en ngun. ");
INSERT INTO fuf_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Awa kadi tageefo ngon no habbori no tiiɗiri fii feɲɲineede ɓiɓɓe Alla ɓen. ");
INSERT INTO fuf_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Ko fii tageefo ngon ko e ley ɓitteende waɗaa, hinaa tippude e yiɗi maggo, kono ko tippude e yiɗi Waɗuɗo ngo e ley ɓitteende on, e hoore tanƴinagol wonde ");
INSERT INTO fuf_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","ngon tageefo tigi jattinte maccangaaku mayde e ɲolugol, ngo heɓa geɓal ka ndimu ɓiɓɓe Alla darjinngu ngun. ");
INSERT INTO fuf_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Ko fii hiɗen andi tageefo ngon fow no woytaade tampere haa hande wa muuseendi ŋata. ");
INSERT INTO fuf_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Ko ɓeyditii e ɗun, enen kadi, ɓee adiiɓe hendaade Ruuhu Allaahu on, hiɗen woytaade ka ɓerɗe men e nder ko habbiɗen haa Alla waɗa en ɓiɓɓe makko, o sotta ɓalli men ɗin. ");
INSERT INTO fuf_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Ko fii ko e nder ndee tanƴinaare dandaɗen. E hin-le si en yi'ii ko tanƴiniɗen kon, haray ɗun wonaa tama'u hande kadi. E hara ko hombo tanƴinortoo ko yi'i kon? ");
INSERT INTO fuf_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Kono si hiɗen tanƴinii ko en yi'aali, haray hiɗen habbori ɗun ŋaɲɲaare. ");
INSERT INTO fuf_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Ko wano non kadi Ruuhu Allaahu on wallitorta en tuma lo'uɗen. Ko fii en andaa ko haanuɗen toraade Alla e nder torndeeji men ɗin, kono on Ruuhu tigi faaboto en e fee woytaangooji ɗi waawotaako sifaade. ");
INSERT INTO fuf_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Ko fii Liɲoowo ɓerɗe on no andi ko honɗun woni miijo Ruuhu mun on, ɓay ko e yiɗi Alla, on Ruuhu fattoranta gomɗinɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Hiɗen andi wonde piiji ɗin fow no yaadude fii moƴƴere ɓen yiɗuɓe Alla, noddiraaɓe sabu eɓɓoore makko nden. ");
INSERT INTO fuf_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Ko fii, ko ɓen ɓe o andunoo, ko ɓen o muuyani nandugol e mbaadi Ɓiɗɗo makko on, fii no on Ɓiɗɗo wonira Afo e hakkunde musiɓɓe ɗuuɗuɓe. ");
INSERT INTO fuf_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Ɓen ɓe o muuyannoo, o noddi ɓe. Ɓen ɓe o noddi, o jogori ɓe kadi feewuɓe. Ɓen ɓe o jogori feewuɓe non, o darjini ɓe kadi. ");
INSERT INTO fuf_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Ko honɗun non wi'eten e ɗun? Si tawii Alla no wonani en, haray ko hombo dartotoo en? ");
INSERT INTO fuf_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","On mo salanaaki en Ɓiɗɗo mun Bajjo on, kono o itti mo sadaka fii men en fow, ko honno o ronkirta en okkirde piiji ɗin fow wondude e Ɓiɗɗo on, sabu moƴƴere makko nden! ");
INSERT INTO fuf_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Ko hombo tooɲata suɓaaɓe Alla ɓen? Hay gooto, ɓay ko Alla woni Jogoroowo wa feewuɗo. ");
INSERT INTO fuf_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Ko hombo donkinta ɓe? Hay gooto, ɓay ko Iisaa Almasiihu on woni maayunooɗo on, e hoore ɗun o immintinaama, himo ka sengo ɲaamo Alla, himo tefande en. ");
INSERT INTO fuf_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Ko hombo sendindirta en e giggol Almasiihu on? Hara ko tampereeji ɗin, kaa ko annde nden, kaa ko jokkereeji ɗin, kaa ko heege ngen, kaa ko kolngal ngal, kaa ko masiibo ngon, kaa ko kaafa kan? ");
INSERT INTO fuf_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Wano windori non: «Ɲallal ngal fow meɗen weeɓitanii mayde fii maa, men jogoree wa baali hirseteeɗi!» ");
INSERT INTO fuf_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Kono e nder ɗun fow, ko en fooluɓe, hiɗen ɓuri fooluɓe kadi, sabu Yiɗuɗo en on. ");
INSERT INTO fuf_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Ko fii miɗo felliti, hinaa mayde nden, hinaa ngurndan ɗan, hinaa malaa'ikaaɓe ɓen, hinaa mbawdiiji ɗin, hinaa ko fewndii kon, hinaa ko aroyta kon, hinaa doole ɗen, ");
INSERT INTO fuf_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","hinaa tagoore nden ka dow, hinaa tagoore nden ka ley, hinaa tagu goo kadi woo waawata en sendude e giggol Alla wongol e Iisaa Almasiihu Joomi men on! ");
INSERT INTO fuf_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Miɗo wowlude goonga e nder humondiral an e *Almasiihu on, mi fenataa, fondo an ngon no seeditorande lan *Ruuhu Seniiɗo on: ");
INSERT INTO fuf_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","miɗo wondi e sokola tiiɗuɗo e muuseendi duumiindi ka ɓernde. ");
INSERT INTO fuf_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Ko fii mi yeloyto wonugol min tigi malkisaaɗo, sendee e Almasiihu on fii musiɓɓe an ɓen, ɗun ko musidal an ngal ka ƴiiƴan, ");
INSERT INTO fuf_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","ɓen ɓe tawata ko *Isra'iilayankeeɓe. Ko kamɓe Alla jogori wa ɓiɓɓe. Ko ɓen mangu ngun e *ahadiiji ɗin e Sariya on e dewal ngal e fodaariiji ɗin, ");
INSERT INTO fuf_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","e maamankaaku Isra'iila'en ngun wonani. Awa kadi Almasiihu on ko ƴiiƴan maɓɓe, on Wonɗo Alla e dow kala huunde, mo mantoore wonani haa poomaa. Aamiina! ");
INSERT INTO fuf_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Hinaa fii daaluyee Alla on ko meereejo. Ko fii hinaa jurriya Isra'iila ndin fow woni Isra'iilayanko. ");
INSERT INTO fuf_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Wonaa jurriya Ibraahiima on fow woni ɓiɓɓe makko, kono no windii: «Ko e *Issaaqa jurriya maa on nodditirtee.» ");
INSERT INTO fuf_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","E maanaa, hinaa ɓiɓɓe ɓen ka ƴiiƴan woni fayɓe Alla, kono ko ɓiɓɓe fodaari ndin toɗɗaa wonugol jurriya. ");
INSERT INTO fuf_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Awa e hino kongol fodaari ndin: «E oo saa'i tigi mi aray, Saarata heɓa ɓiɗɗo.» ");
INSERT INTO fuf_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Ko ɓeyditii e ɗun, Rifqatu siwti ɗiɗo, ɓe tawata ko oo maamiraawo men wi'eteeɗo Issaaqa woni ben maɓɓe. ");
INSERT INTO fuf_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","12","Hay fewndo tawnoo fayɓe ɓen heɓaaka taho, sakko ɓe waɗa ko boni maa ko moƴƴi, Alla daalanno Rifqatu wonde: «Ko mawɗo on kurkanoytoo tosooko on», fii no eɓɓoore Alla nden fii suɓagol tabitira, ɗun non wonaa e kuuɗe maɓɓe ɗen tippi, kono ko e kanko Alla, Noddoowo on, ");
INSERT INTO fuf_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","wano no windori non: «Mi yiɗii Yaaquuba, mi aɲii Iisu.» ");
INSERT INTO fuf_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Ko honɗun wi'eten jooni? Hara angal peewal no e Alla? Pellet oo'o! ");
INSERT INTO fuf_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Ko fii himo daalani Muusaa wonde: «Mi yurmete on mo mi faalaa yurminde, mi moƴƴoo e on mo mi faalaa moƴƴaade e mun.» ");
INSERT INTO fuf_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Ko ɗun waɗi, ɗun hinaa immorde e faale neɗɗanke, maa e wakkilaare makko, kono ko immorde e Alla, on Yurmeteeɗo. ");
INSERT INTO fuf_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Ko fii bindi ɗin no wi'i Fir'awna: «Mi ɓantii ma tun fii ɓangingol bawgal an ngal e hoore maa, e fii no innde an nden lolliniree e hoore leydi ndin fow.» ");
INSERT INTO fuf_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Awa ɗun no holli wonde himo yurmina on mo o faalaa, o sattina ɓernde on mo o faalaa. ");
INSERT INTO fuf_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Miɗo andi a wi'ay lan: «Ɓay ko nii, ko honɗun Alla feliranta yimɓe ɓen? Ko fii ko hombo waawi dartaade faale makko on?» ");
INSERT INTO fuf_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","An non taho, ko hombo wonu-maa ka yeddondiraa e Alla? E hara loonde wi'ay moƴƴinɗo nde on: «Ko honɗun moƴƴiniranɗaa mi nii?» ");
INSERT INTO fuf_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","E hara daaloyankeejo waawataa mahirgol loopal no o faaliraa woo, o moƴƴina ngal loopal gootal looɗe: wonde nden fii haaju hittuɗo, ndeya fii haajuhoy tosokoy? ");
INSERT INTO fuf_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","E si tawii, e nder ko Alla faalaa hollude tikkere mun nden e ɓangingol bawgal makko ngal kon, o muɲɲanike ɗen looɗe handunooɗe e tikkere makko nden e nder muɲal tiiɗungal, ɗun ko ɗen eɓɓananooɗe fii hayrannde nden? ");
INSERT INTO fuf_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","E si tawii non o faalaama andinde ɗen looɗe ɗe o yurmaa ngalu darja makko on, ɗen ɗe o eɓɓannoo fii darja makko on, ");
INSERT INTO fuf_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","e maanaa ɗun ko enen ɓe o noddi ɓen, hinaa non tun e hakkunde Yahuudiyankeeɓe ɓen, kono kadi e ɓe wonaa Yahuudiyanke ɓen? ");
INSERT INTO fuf_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Wano o daaliri non ka deftere oo wi'eteeɗo Husaa'a: «On mo wonaano jamaa an, mi nodday mo jamaa an, on mo wonaano kadi giɗo an, mi nodday mo giɗo an», ");
INSERT INTO fuf_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","e: «Ka ɓe wi'anoo ɗon tigi: ‹hinaa on jamaa an!› ko ɗon ɓe noddoytee ɓiɓɓe Alla Wuuruɗo on.» ");
INSERT INTO fuf_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Isaaya* kadi no wi'i fii Isra'iilayankeeɓe ɓen: «Nde adadu Isra'iilayankeeɓe ɓen ɗuuɗiroyi wa njaareendi ndin ka baharu, ko heddiiɓe seeɗaaɓe tun dandetee, ");
INSERT INTO fuf_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","ko fii Joomiraaɗo on laatinay kongol ɲaawoore mun nden ka hoore leydi no yaawiri haa timma!» ");
INSERT INTO fuf_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Wano Isaaya wiirunoo non: «Si tawno Joomiraaɗo Jom Bawɗe on accanaano en jurriya, hanno en wa'iino wa ɗee ca'e ɗiɗi, ɗun ko *Saduuma e Amuura!» ");
INSERT INTO fuf_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Ko honɗun non wi'eten jooni? Ɓe wonaa Yahuudiyanke, ɓe ɗaɓɓataano peewal ngal ɓen, ɓe heɓii peewal, ngal peewal iwrungal e gomɗinal ngal. ");
INSERT INTO fuf_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","E hin-le Isra'iilayankeeɓe, ɗaɓɓaynooɓe peewal iwrungal e Sariya on ɓen, ɓe laatinaano waɗugol ko Sariya on yamiri kon fow. ");
INSERT INTO fuf_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Fii honɗun? Ko fii Isra'iilayankeeɓe ɓen hinaa gomɗinal ɗaɓɓiraynoo peewal ngal, kono ko wa si tawii ko kuuɗe ɗen peewal heɓorta. Ɓe buɓɓii e hayre fegginaynde nden, ");
INSERT INTO fuf_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","wano windori non: «Miɗo tippinde ka hoore Fello *Siyuuna hayre fegginaynde, e fetere liɓaynde. Kala gomɗinɗo e makko hersinoytaake.» ");
INSERT INTO fuf_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Musiɓɓe an, faale ɓernde an nden, e ko mi woni toraade Alla fii *Isra'iilayankeeɓe ɓen, ko yo ɓe dande. ");
INSERT INTO fuf_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Kono miɗo seeditanaade ɓe ɗunɗoo: hiɓe himmani fii Alla, kono hinaa tippude e gandal. ");
INSERT INTO fuf_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Ɓay ɓe andaali peewal iwrungal e Alla ngal, e ɓay ɓe ɗaɓɓii no ɓe tabintinira peewal maɓɓe ngal kamɓe tigi, ɓe ronki yankinanaade peewal Alla ngal. ");
INSERT INTO fuf_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Ko fii, ko *Almasiihu on woni timmoode Sariya on fii no kala gomɗinɗo heɓira peewal. ");
INSERT INTO fuf_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Ko ɗun waɗi, Muusaa no windi fii peewal iwrungal e Sariya on ngal, o wi'i: «Kala ɗoftiiɗo ɗee yamirooje, o wuuriray ɗe.» ");
INSERT INTO fuf_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Kono e hino ko peewal iwrungal e gomɗinal ngal wi'i kon: «Wota a miijo ka ɓernde maa: ‹ko hombo ƴawata ka kammu?› » (ɗun haray ko tippingol Almasiihu on), ");
INSERT INTO fuf_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","«maa: ‹ko hombo tippotoo ka *gaygii ngii alaa kattudi ngin?› » (ɗun haray ko suutugol Almasiihu on e hakkunde mayɓe ɓen). ");
INSERT INTO fuf_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Awa ko honɗun bindi ɗin wi'i? Ko: «Daaluyee on no takko maa, ɗun ko ka nder hunduko maa e ka ɓernde maa.» On-le ko daaluyee gomɗinal ngal, on mo men woni yottinde ");
INSERT INTO fuf_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","wonde: si a qirritorii hunduko maa kon ko Iisaa woni Joomi on, e si a gomɗinii ka ɓernde maa wonde Allaahu on immintinii mo e hakkunde mayɓe ɓen, a dandete. ");
INSERT INTO fuf_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Ko fii ko ɓernde nden gomɗinirtee, ontigi jogoree wa feewuɗo, ko hunduko kon qirritortee, ontigi dandee. ");
INSERT INTO fuf_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Wano bindi ɗin wi'iri non: «Kala gomɗinɗo e makko hersinoytaake.» ");
INSERT INTO fuf_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Awa, alaa ko sendindiri Yahuudiyanke e ɓe wonaa Yahuudiyanke, ɓe fow ko Joomiraaɗo gooto ɓe mari, on Alɗanɗo kala jantiiɗo mo. ");
INSERT INTO fuf_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Ko fii: «Onsay kala jantotooɗo innde Joomiraaɗo on dandoyte.» ");
INSERT INTO fuf_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Ko honno non ɓe jantoroyta innde on mo ɓe gomɗinaali? E ko honno ɓe gomɗinirta on mo ɓe nanaali fii mun no wowlee? E ko honno ɓe nanirta fii makko no wowlee e ɓaawo waajotooɗo? ");
INSERT INTO fuf_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","E ko honno ɓe waajorta si ɓe imminaaka? Ko fii no windii: «Emba teppe yottinooɓe Kibaaru Moƴƴo on no labaa!» ");
INSERT INTO fuf_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Kono hinaa fow ɗoftii Kibaaru Moƴƴo on. Ɓay Isaaya wi'uno: «Joomiraaɗo, ko hombo gomɗini waaju amen ngun?» ");
INSERT INTO fuf_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Ko ɗun waɗi, gomɗinal ko e nanugol iwata, ko nanetee kon kadi ko e kongol Almasiihu on iwi. ");
INSERT INTO fuf_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Kono mi wi'i: hara ɓe nanaali? Oo'o: «Hito kammuuli ɗin yahii e leydi ndin fow, e konguɗi majji ɗin yottoyike haa ka kattudi leydi.» ");
INSERT INTO fuf_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Kono mi wi'i: e hara Isra'iilayankeeɓe ɓen faamaali ɗun? Ko Muusaa adii wi'ude wonde Allaahu on daalii: «Mi nawliniray on ɓe wonaa jamaa tigi, mi moninira on jamaa mo alaa faamu.» ");
INSERT INTO fuf_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Awa Isaaya heɓuno cuucal haa o wi'i wonde Allaahu on daalii: «Ɓe alaa lan ɗaɓɓude ɓen heɓii lan, mi feeɲanii ɓe alaano landaade fii an ɓen.» ");
INSERT INTO fuf_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Kono e telen-ma Isra'iilayankeeɓe ɓen, o daali: «Ɲallal ngal fow miɗo fontande juuɗe an ɗen jamaa murtuɗo yeddi.» ");
INSERT INTO fuf_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Awa miɗo landoo: e hara Alla bugitike jamaa mun on? Pellet oo'o! Ko fii min kadi ko mi *Isra'iilayankeejo, jurriya Ibraahiima, ko mi jeyaaɗo e oo bolondaa *Buniyamiinu. ");
INSERT INTO fuf_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Alla bugitaaki jamaa makko mo o andunoo ko adii fow. E on andaa ko bindi ɗin wi'i kon ka cortewol ka Iiliiya wullitii e Alla ɗon e hoore Isra'iilayankeeɓe ɓen? ");
INSERT INTO fuf_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","O wi'i: «Joomiraaɗo, ɓe warii annabaaɓe maa ɓen, ɓe waylitii layyorɗe maa ɗen! Jooni ko min tun lutti, awa kadi hiɓe ɗaɓɓa no ɓe ittirammi e oo aduna!» ");
INSERT INTO fuf_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Ko honɗun woni jaabannde Alla nden? O daali: «Miɗo maritori yimɓe guluuje njeeɗiɗo, ɓe sujjanaali sanamuuru wi'eteendu *Baalu ndun.» ");
INSERT INTO fuf_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Ko wano non kadi e oo saa'i fewndiiɗo, no woodi heddiiɓe ɓe Alla suɓori sulfu mun on. ");
INSERT INTO fuf_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Si tawii non ko sulfu on o suɓori ɓe, haray hinaa rewrude e kuuɗe ɗen hande kadi. Si hinaa ɗun, haray sulfu on wonaa sulfu. ");
INSERT INTO fuf_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Awa ko honɗun? Ko Isra'iilayankeeɓe ɓen ɗaɓɓaynoo kon ɓe heɓaali, kono suɓaaɓe ɓen hendike ɗun. Ɓeya, ɓerɗe mun ɗen sattinaa, ");
INSERT INTO fuf_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","wano windori non: «Alla yeɗii ɓe hakkillaaji ɗaaniiɗi, e gite ɗe yi'ataa, e noppi ɗi nanataa, haa weetaango hande ngoo.» ");
INSERT INTO fuf_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Daawuuda kadi wi'i: «Yo ndaɗɗule ka ɓe ɲaamata ɗon wonan ɓe pircol e ngantan, e peggal e njoddi kuuɗe! ");
INSERT INTO fuf_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Yo gite maɓɓe ɗen niɓɓitu haa tawa ɓe yi'ataa, e yo ɓe laato saa'i kala turiiɓe!» ");
INSERT INTO fuf_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Awa miɗo landoo: Ɓay ɓe feggike, ɓe yanuno, ngal ɓe immotaako? Pellet oo'o! Kono ko sabu bonnere maɓɓe nden kisiyee on yeɗiraa ɓe wonaa Yahuudiyanke ɓen fii memmingol nawliigu Isra'iilayankeeɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","E hin-le, si tawii bonnere maɓɓe nden ko ngalu oo aduna, e si tawii faɗannde maɓɓe nden ko ngalu ɓe wonaa Yahuudiyanke ɓen, haray ko ittiri ngalu hongu ɓeydotoo ka tawdegol maɓɓe e kisiyee on. ");
INSERT INTO fuf_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Awa mi andinii on, onon ɓe wonaa Yahuudiyanke ɓen, min oo *sahaabaajo fii ɓe wonaa Yahuudiyanke ɓen, min miɗo teddini fii golle an ɗen, ");
INSERT INTO fuf_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","fii, si tawii no gasa, memmingol nawliigu e hakkunde leɲol an ngol, e dandugol woɓɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Si tawii waɗeede maɓɓe sera addii moƴƴintingol hakkunde aduna on e Alla, ko honɗun artireede maɓɓe nden wonoyta si hinaa immintineede ka mayde? ");
INSERT INTO fuf_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","E hin-le, si tawii bireediije arane ɗen ko Alla wonani, haray farin piyaaɗo on men. Si tawii kadi ɗaɗol ngol ko Alla wonani, haray calɗi ɗin men. ");
INSERT INTO fuf_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Si tawii non goɗɗi e calɗi ɗin saltaama, e an non, ki *zaytuunihi buruurehi, a tokkaama batte majji, haa tawii a tawdaama e ɗaɗol ngol e enɗan zaytuuni ɗan, ");
INSERT INTO fuf_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","wota a mantor calɗi ɗin. Si tawii a mantoray, andu tun wonde hinaa an jogii ɗaɗol ngol, kono ko ɗaɗol ngol jogi-maa. ");
INSERT INTO fuf_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Haray ko wi'ataa: «Calɗi saltaama fii min yo mi tokke.» ");
INSERT INTO fuf_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Andaa fota wonde ko ɗi taƴiraa ko angal gomɗinal majji on. An, a siŋorii ɗon sabu gomɗinal maa ngal. Awa wota a mawnintino, kono hulu. ");
INSERT INTO fuf_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Ko fii, si Allaahu on accaali calɗi ko ngal wondunoo kon, an kadi o accataa ma. ");
INSERT INTO fuf_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Awa anditu fii moƴƴere Alla nden e yagginannde makko nden, yagginannde makko nden e hoore yanuɓe ɓen, e moƴƴere Alla nden e hoore maa, si a duumike e nder nden moƴƴere. Si hinaa ɗun, an kadi, a soppete. ");
INSERT INTO fuf_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Kamɓe kadi wano non. Si ɓe duumaaki e angal gomɗinal ngal, ɓe tokkete, ko fii Alla no mari bawgal tokkugol ɓe kadi. ");
INSERT INTO fuf_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Si tawii an a soppaama e zaytuunihi buruurehi, a tokkaama e zaytuunihi tutaaki, woopondirki e mbaadi maa ndin, ittii e sikke si kamɓe ɓe tokkete e mbaadi maɓɓe ndin, e zaytuunihi maɓɓe kin tigi. ");
INSERT INTO fuf_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Ko fii, yo musiɓɓe an, mi yiɗaa yo on ronku andude oo gundoo ɗoo fii wota on sikku hiɗon mari faamu feƴƴitungu: sattere ɓernde no e hoore woɓɓe e jamaa Isra'iilayankeeɓe ɓen haa yeru ko timmi e ɓe wonaa Yahuudiyanke ɓen naata. ");
INSERT INTO fuf_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Ontuma non Isra'iilayanko fow wonay dandaaɓe, wano windori non: «Jattinoowo on iwray *Siyuuna, o pottina e bolondaa Yaaquuba on kala ko yaadaa e faale Alla on. ");
INSERT INTO fuf_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Ko ɗun wonoyta *ahadi an ndin hakkunde an e maɓɓe nde mi ɓooroyi junuubaaji maɓɓe ɗin.» ");
INSERT INTO fuf_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","E telen-ma Kibaaru Moƴƴo on, ko ɓe ayɓe sabu mon, kono e telen-ma suɓeede nden, ko ɓe yiɓɓe Allaahu on sabu baabiraaɓe maɓɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Ko fii, dokke Alla ɗen e noddaandu makko ndun hinaa ko jaɓitotoo. ");
INSERT INTO fuf_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Hari on ɗoftanooki Alla, kono jooni on heɓirii yurmeende sabu angal ɗoftaare Yahuudiyankeeɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","Ko wano non jooni, kamɓe kadi ɓe wontiri ɓe ɗoftotaako Alla fii no ɓe heɓiroya yurmeende nden kamɓe kadi, sabu yurmeende nde waɗanaɗon nden. ");
INSERT INTO fuf_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Ko fii Alla dumbii yimɓe ɓen fow e nder geddi fii no o yurmiree fow. ");
INSERT INTO fuf_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Ko haa honto ngalu Alla ngun e faamu makko ngun e gandal makko ngal luggi! Hay gooto waawataa sifaade ɲaawooje makko ɗen, hay gooto waawataa andude eɓɓooje makko ɗen! ");
INSERT INTO fuf_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","Ko fii ko hombo andi miijo Joomiraaɗo on, maa ko hombo woni waajotooɗo mo on, ");
INSERT INTO fuf_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","ko hombo adii mo okkorde, si o yoɓita mo? ");
INSERT INTO fuf_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Ko fii fow ko immorde e makko, tippude e makko, e fii makko. Ko kanko mangu wonani haa poomaa. Aamiina! ");
INSERT INTO fuf_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Awa mi wakkilinii on, yo musiɓɓe an, sabu yurmeende Alla nden, okkitirgol ɓalli mon ɗin wa sadaka wurɗo laaɓuɗo, weloowo mo, ko ɗun wonanoyta on dewal haanungal. ");
INSERT INTO fuf_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Wota on ɲembu aduna fewndiiɗo on, kono wonee waylaaɓe, ɓe hakkillaaji mun heyɗintinaa, fii no andiron ko honɗun woni faale Alla on: ɗun ko ko moƴƴi kon e ko welata mo kon e ko timmi kon. ");
INSERT INTO fuf_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Tippude e moƴƴere nde o yeɗimmi nden, mi wi'ay kala e mon wota o miijo himo hitti haa feƴƴiti, kono yo o miijito fii hoore makko wano haaniri non, mo kala embere gomɗinal ngal Alla yeɗi ɗun ngal. ");
INSERT INTO fuf_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Wano tawiri non hiɗen mari tere buy e nder ɓandu wooturu, awa kadi tere ɗen fow hinaa golle goote mari, ");
INSERT INTO fuf_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","ɗun non, fii kala hiɗen ɗuuɗi, en fow ko en ɓandu wooturu e nder humondiral e *Almasiihu on, en fow ko en tere jogondirɗe. ");
INSERT INTO fuf_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Kono hiɗen mari dokke seeduɗe, wano Alla yeɗiri mo kala e men moƴƴere non. Si tawii ko dokkal haalugol ko Alla longini ɗun, yo taw ko ko yaadi e gomɗinal. ");
INSERT INTO fuf_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","Si ko dokkal fii wallugol, yo o wallu, si ko dokkal jannugol, yo o jannu. ");
INSERT INTO fuf_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","Mo no mari kadi dokkal wakkilingol, yo o wakkilin. On marɗo kadi dokkal okkugol, yo o okkir no yaajiri. On marɗo dokkal ardagol kadi, yo o ardor no kelɗiri. On marɗo dokkal yurmeende kadi, yo o waɗir ɗun weltaare. ");
INSERT INTO fuf_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Yo giggol ngol wonu sellungol. Aɲon ko boni kon, humoɗon no tiiɗiri e ko moƴƴi kon. ");
INSERT INTO fuf_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Yiɗindiron giggol siɗɗankaaku, mo kala e mon jogitora oya wa burɗo ɗun teddude. ");
INSERT INTO fuf_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","Wakkiloɗon hara on aamaali, kurkoranon Joomiraaɗo on ɓerɗe mon ɗen fow. ");
INSERT INTO fuf_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","Weltee e hoore tanƴinagol, ŋaɲɲoɗon tampereeji ɗin, duumoɗon e toraare Alla. ");
INSERT INTO fuf_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","Faaboron gomɗinɓe ɓen ko ɓe handi kon, newanoɗon wernugol. ");
INSERT INTO fuf_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Du'anoɗon cukkotooɓe on ɓen, du'ee, wota on huɗu. ");
INSERT INTO fuf_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Weltodee e ɓen wonɓe weltaade, wullidon e wonɓe wullude ɓen. ");
INSERT INTO fuf_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Miijondiranee miijo wooto, wota on mawnintino, kono jaɓon jippinde hoore mon. Wota on waɗu hoore mon faamuɓe. ");
INSERT INTO fuf_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Wota on yoɓitir gooto bone bone. Waɗee ko yimɓe ɓen fow ndaarata tawa no moƴƴi. ");
INSERT INTO fuf_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Si tawii no gasa, yeru hiɗon waawi, wondee e yimɓe ɓen fow e nder ɓuttu. ");
INSERT INTO fuf_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Wota on yottano hoore mon onon tigi, yo yiɗaaɓe an, kono accee tikkere Alla nden yottoo, ko fii no windii: «Joomiraaɗo on wi'i: Ko min yottannde wonani, ko min woni Yoɓoowo.» ");
INSERT INTO fuf_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","Ko fii no windii kadi: «Si gaɲo maa no weelaa, okkor mo, o ɲaama, si himo ɗonɗaa, okkor mo, o yara. Ko fii warrugol non, haray no wa'i wa si ko ƴulɓe yiite mooɓuɗaa ka hoore makko.» ");
INSERT INTO fuf_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Wota bone foolu on, kono fooliree bone on moƴƴere. ");
INSERT INTO fuf_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Yo kala neɗɗo yankinano laamuuji ɗin, ko fii alaa laamu ngu tawata hinaa e Alla iwri, ko fii laamuuji wooduɗi ɗin, ko Alla joɗɗini ɗi. ");
INSERT INTO fuf_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Ko ɗun waɗi, kala on dartiiɗo laamu ngun, haray dartike yamiroore Alla nden, ɓen dartiiɓe non, haray fawii hoore mun ɲaawoore. ");
INSERT INTO fuf_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Laamiiɓe ɓen hulɓinaaki si tawii ko ko moƴƴi wonaa waɗeede, kono ko si tawii ko ko boni. Si a faalaaka hulude laamu ngun, waɗu ko moƴƴi, ɗun a heɓay kuluujaa maggu on. ");
INSERT INTO fuf_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","Ko fii ko kangu woni kurkaadu Alla fii nafa maa kan. Kono si hiɗa waɗude ko boni, haray wonu e nder kulol, ɓay hinaa meere ngu jogori kaafa, ko fii ko kangu woni kurkaadu Alla fii yottingol tikkere makko nden e hoore on waɗoowo ko boni. ");
INSERT INTO fuf_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Awa jaka yankinanagol laamu ngun no hitti, hinaa fii nden tikkere tun non, kono kadi ko sabu ɓernde ontigi nden. ");
INSERT INTO fuf_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Ko sabu ɗun kadi hiɗon yoɓa sagalle, ko fii laamiiɓe ɓen ko liggantooɓe Alla, duumiiɓe e waɗugol ɗen golle no moƴƴiri. ");
INSERT INTO fuf_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Jonnitee mo kala ko handi kon, jonniton sagalle ɗen on mo haanuɗon jonnude, hulon on mo haanuɗon hulude, teddinon on mo haanuɗon teddinde. ");
INSERT INTO fuf_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Wota ɲamaande woo wonu hakkunde mon e goɗɗo si wonaa yiɗindirgol, ko fii kala yiɗuɗo wondiɓɓe mun ɓen, haray timminii Sariya on. ");
INSERT INTO fuf_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","Ko fii yamirooje ɗen, ɗun ko «wota mo jeena», «wota mo itta hoore», «wota mo wujja», «wota mo seeditoo fenaande», «wota mo himmana ko goɗɗo jeyi», e ɗeya yamirooje fow no ɲoggaa e nder ngol daalol ɗoo: «Yo a yiɗir ɲokondo maa on wano yiɗirɗaa hoore maa non.» ");
INSERT INTO fuf_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Giggol waɗataa ɲokondo mun ko boni, awa jaka ko giggol woni timmoode Sariya on. ");
INSERT INTO fuf_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Ɓay hiɗon andi ko e saa'i hombo wonɗen, awa immee, hinaa saa'i ɗaanagol nii! Ko fii jooni kisiyee on ɓurtii en ɓattaade edii fewndo arɗen e gomɗinde. ");
INSERT INTO fuf_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","Jemma on muutike, ɓadike weetude, awa ɓortoɗen kuuɗe niwre nden, ɓornoɗen aalaaji ndaygu ngun. ");
INSERT INTO fuf_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","Wuuriren no feewiri, wa tumbere ɲalorma, e ɓaawo *fasaadu e mandilugol e jinaa e jiiɓaare e yeddondiral e nawliigu. ");
INSERT INTO fuf_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","Kono ɓornoɗon Iisaa Almasiihu Joomi men on, hara on ɗaɓɓaali mbeleeɗe ɓandu fii weltingol himmeeji. ");
INSERT INTO fuf_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","Jaɓee on mo tiiɗaa gomɗinal e ɓaawo feloore. ");
INSERT INTO fuf_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","Goɗɗo on no sikka no waawi ɲaamude ko woni woo, oya mo tiiɗaa gomɗinal kadi ko ɓiɓɓe naakoo tun ɲaamata. ");
INSERT INTO fuf_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","On ɲaamoowo ko woni woo, wota ɲiddin few mo ɲaamataa ko woni woo on. On mo ɲaamataa kadi, wota felu ɲaamoowo on, ko fii Alla no jaɓi mo kala. ");
INSERT INTO fuf_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","Ko hombo wonu-maa an, oo feloowo kurkaadu goɗɗo goo? Si tawii himo darii maa si himo yani, ɗun ko jeyɗo mo on wonani. Kono o daroto, ko fii Joomiraaɗo on no mari bawgal tambitagol mo. ");
INSERT INTO fuf_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Woɓɓe no wi'i wonde ɲalaaɗe ɗen no ɓurdi, woɓɓe ɓen no jogitii ɗe fow hiɗe fota. Awa yo mo kala hoolor ko miijii kon. ");
INSERT INTO fuf_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","On mo ɓurdindini ɲalaaɗe ɗen, haray ko fii teddingol Joomiraaɗo on o waɗiri ɗun. On mo no ɲaama kadi, haray ko fii teddingol Joomiraaɗo on o woni ɲaamande, ko fii himo jarnude Alla. On mo alaa ɲaamude, haray ko fii teddingol Joomiraaɗo on haɗi o ɲaama, ko fii kanko kadi himo jarnude Alla. ");
INSERT INTO fuf_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","Ko ɗun waɗi, hay gooto e men alaa wuurande hoore mun tigi, e hay gooto alaa maayande hoore mun tigi. ");
INSERT INTO fuf_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","Ko fii si en wuuru, haray ko Joomiraaɗo on wuuranɗen, si en maayu, haray ko Joomiraaɗo on maayanɗen. Woni en wuuru maa en maayu, ko Joomiraaɗo on jeyi en. ");
INSERT INTO fuf_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","Ko ɗun waɗi si *Almasiihu on maayi, o immitii, fii wonugol Jom mayɓe ɓen e wurɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","Kono an, ko honɗun felantaa musiɗɗo maa on? Maa an, ko honɗun ɲiddinantaa musiɗɗo maa on? Ko fii en fow en daroyto yeeso ɲaawoore Alla nden. ");
INSERT INTO fuf_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","Ko fii no windii wonde, Joomiraaɗo on no daali: «Fodde ko goonga miɗo wuuri, kala howru jiccoto yeeso an, kala ɗenngal mantay Alla.» ");
INSERT INTO fuf_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","Ko ɗun waɗi, mo kala e men qirritoto yeeso Alla fii hoore mun tigi. ");
INSERT INTO fuf_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","Awa, wota en ɲaawindir hande kadi, ɗun-le wuren ardinee hakkil, fii wota on waɗu yeeso musiɗɗo mon on hayre fegginaynde maa wonon sabu yanal. ");
INSERT INTO fuf_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","Miɗo andi, miɗo felliti e nder humondiral an ngal e Iisaa Joomi on, huunde alaa ko tuunani hoore mun, kono si goɗɗo no miijii wonde goɗɗun laaɓaa, haray ɗun laaɓanaa mo. ");
INSERT INTO fuf_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","Si tawii musiɗɗo maa aanii sabu ko ɲaamataa kon, haray a woniraa giggol hande kadi. Wota ko ɲaamataa kon wonu sabu hayrannde on mo Almasiihu on maayi fii mun. ");
INSERT INTO fuf_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","Wota ko moƴƴani on kon wowlire wa ko boni. ");
INSERT INTO fuf_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","Ko fii *laamu Alla ngun hinaa ɲaametee maa njaram, kono ko peewal e ɓuttu e weltaare ko *Ruuhu Seniiɗo on yeɗata kon. ");
INSERT INTO fuf_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","On mo kurkorani nii Almasiihu on, haray no wela Alla, no mari kadi teddungal yimɓe ɓen. ");
INSERT INTO fuf_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","Awa ɗaɓɓen ko ɓeydata ɓuttu e ko tiiɗinta hakkundeeji men e nder gomɗinal ngal. ");
INSERT INTO fuf_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","Wota a bonnir golle Alla ɗen ɲaametee. Ka haqiiqa, ɲaameteeji ɗin fow no laaɓi, kono moƴƴanaa neɗɗo ka o ɲaama goɗɗun ko wonata sabu feggingol goɗɗo. ");
INSERT INTO fuf_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","No moƴƴani goɗɗo hara o ɲaamaali teewu, o yaraali njaram mandilinayɗan, maa waɗugol kala ko fegginta musiɗɗo mun. ");
INSERT INTO fuf_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","Ngal gomɗinal ngal marɗaa, maru ngal fii maa yeeso Alla. Maloore wonanii on mo fawaali hoore mun ɲaawoore e nder anniyeeji mun. ");
INSERT INTO fuf_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","Kono on ɲaamuɗo ko sikkitii, haray fawtike ɲaawoore, ko fii ɗun hinaa e gomɗinal ngal iwri. Ko fii kala ko iwraa e gomɗinal ngal, haray ko junuubu. ");
INSERT INTO fuf_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","Enen tiiɗuɓe e gomɗinal ɓen, hiɗen haani tambitaade lo'ereeji ɓen ɓe tiiɗaa ka gomɗinal, e wota en ɗaɓɓu ko welata en kon. ");
INSERT INTO fuf_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","Yo mo kala e men weltinir ɲokondo mun on ko moƴƴi fii tiiɗingol mo ka gomɗinal. ");
INSERT INTO fuf_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","Ko fii *Almasiihu on ɗaɓɓaano ko welata mo kon, kono wano bindi ɗin holliri non: «Hoyreeji wonɓe ma hoynude ɓen yanii e hoore an.» ");
INSERT INTO fuf_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","E hin-le ko adanoo windeede kon fow wonanii en jannde, fii no heɓiren tama'u on sabu ŋaɲɲaare nden e wakkilaare iwrunde e bindi ɗin. ");
INSERT INTO fuf_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","Yo Alla, Jom ŋaɲɲaare nden e Jom wakkilaare nden, yeɗu on wonugol miijo wooto, e nder jokkugol misal Iisaa Almasiihu on, ");
INSERT INTO fuf_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","fii no mawniniron Alla, on Ben Iisaa Almasiihu Joomi men on, e nder nanondiral e kongol gootol. ");
INSERT INTO fuf_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","Jaɓɓondiree no moƴƴiri, wano Almasiihu on jaɓɓori on non, fii mangu Alla ngun. ");
INSERT INTO fuf_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","Ko mi woni wi'ude, ko Almasiihu on wonii kurkaadu Yahuudiyankeeɓe ɓen fii ɓangingol goonga Alla on, e nder haqinqingol fodaariiji waɗanaaɗi baabiraaɓe ɓen, ");
INSERT INTO fuf_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","fii no ɓe wonaa Yahuudiyanke ɓen mawninira Alla fii yurmeende makko nden, wano windori ka Zabuura non: «Mi mantete e hakkunde leƴƴi ɗin, mi beyta fii teddingol innde maa nden.» ");
INSERT INTO fuf_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","No windii ton kadi: «Ko onon, yo leƴƴi, weltodee e jamaa makko on!» ");
INSERT INTO fuf_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","No windii ton kadi fahin: «Onon leƴƴi ɗin fow, jarnee Joomiraaɗo on, awa kadi yo jamaaji ɗin fow mantu mo!» ");
INSERT INTO fuf_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","Isaaya kadi no wi'i: «Geeƴol Yassaa'u ngol feeɲoyay, ko ngol immoytoo fii ardagol leƴƴi ɗin, leƴƴi ɗin tanƴinora ngol.» ");
INSERT INTO fuf_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","Yo Alla, Jom tama'u on, hebbin on weltaare e ɓuttu fow e nder gomɗinal ngal, fii no heewiron tanƴinaare immorde e bawgal *Ruuhu Seniiɗo on. ");
INSERT INTO fuf_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","E telen-ma mon, yo musiɓɓe an, min tigi miɗo felliti hiɗon heewi moƴƴere e faamu timmungu, e hiɗon waawi waajondirde. ");
INSERT INTO fuf_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","Ko ɗun waɗi, e nooneeji goo mi windiranii on cuucal, fii andintingol on toɓɓe goo ɗe jangunoɗon, sabu moƴƴere nde Alla waɗanimmi nden ");
INSERT INTO fuf_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","wonangol Iisaa Almasiihu on kurkaadu fii ɓe wonaa Yahuudiyanke ɓen, e nder ko Alla toɗɗii mi kon fii Kibaaru Moƴƴo makko on, fii no ɓe wonaa Yahuudiyanke ɓen wonirana mo sadaka weloowo mo, laɓɓiniraaɗo* Ruuhu Seniiɗo on. ");
INSERT INTO fuf_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","Sabu humondiral an e Iisaa Almasiihu on, miɗo waawi mantorde golle ɗe mi woni gollande Alla ɗen. ");
INSERT INTO fuf_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","Ko fii mi suusataa wowlude si wonaa ko Almasiihu on waɗiri e an kon fii addugol ɓe wonaa Yahuudiyanke ɓen ɗoftorgol Alla kongol e kuugal, ");
INSERT INTO fuf_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","tippude e doole maandeeji e kaawakeeji moƴƴi e bawgal Ruuhu Alla on. Ko wano non, gila *Yerusalaam mi taarori non haa hewti Iliriiya, mi yottini Kibaaru Moƴƴo Almasiihu on fow. ");
INSERT INTO fuf_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","Awa anniyee an on ko feɲɲingol Kibaaru Moƴƴo on nokku ka tawata Almasiihu on andaaka, fii wota mi darnu e hoore didol goɗɗo. ");
INSERT INTO fuf_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","Kono wano windori non: «Ɓen ɓe feɲɲinananooka yi'oyay, e ɓen ɓe nanaano kadi faamoyay.» ");
INSERT INTO fuf_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","Ko ɗun wonnoo mi haɗude soono woo yahugol ka mon. ");
INSERT INTO fuf_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","Kono jooni mi gaynii golle an ɗen e ɗii nokkeeli. Gila duuɓi buy miɗo faalanoo yahude ka mon. ");
INSERT INTO fuf_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","Nde miɗo yaha Espaaɲi, miɗo tanƴinii yiidugol e mon e nder ko mi rewata ɗon kon, mi weltora wondugol e mon seeɗa. Onsay, wallon mi no yahugol e ndin leydi neworanammi. ");
INSERT INTO fuf_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","Fewndo ɗoo miɗo yahude Yerusalaam fii kurkanagol yimɓe Alla ɓen. ");
INSERT INTO fuf_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","Ko fii ɓe Masedonii ɓen e ɓe Akaaya ɓen no faalaa mooɓindirde goɗɗun e nder jawle maɓɓe ɗen fii miskinɓe wonɓe e hakkunde yimɓe Alla ɓen Yerusalaam. ");
INSERT INTO fuf_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","Awa, hiɓe weltori waɗugol ɗun, ɓay hiɓe haani ɓe waɗande. Ko fii, si ɓe wonaa Yahuudiyanke ɓen heɓirii barkiiji Alla ɗin sabu Yahuudiyankeeɓe ɓen, kamɓe ɓe wonaa Yahuudiyanke ɓen kadi hiɓe haani ɓe wallirde keyeeji aduna. ");
INSERT INTO fuf_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","Si mi gaynii jonnude ko mooɓindiraa kon haanuɓe hendaade ɓen, mi rewoyay ka mon, nde miɗo yaha Espaaɲi. ");
INSERT INTO fuf_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","Miɗo andi, nde miɗo yaha ka mon, mi yaaday e barki timmuki Almasiihu on. ");
INSERT INTO fuf_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","Mi wakkilinii on sabu Iisaa Almasiihu Joomi men on yo musiɓɓe an, e sabu giggol Ruuhu Alla on, dartodugol e an e nder fewtingol Alla toraaje fii an, ");
INSERT INTO fuf_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","fii no mi hettora e juuɗe yedduɓe wonɓe ka diiwal *Yahuuda ɓen, e fii no gomɗinɓe ɓen jaɓira dokke, ɗe mi naɓata Yerusalaam ɗen, no moƴƴiri. ");
INSERT INTO fuf_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","Ɗun, mi hewtiday ka mon e weltaare, si tawii ko ɗun woni faale Alla on, hara en fow en heyɗintinoday. ");
INSERT INTO fuf_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","Yo Alla Jom ɓuttu on wondu e mon on fow. Aamiina! ");
INSERT INTO fuf_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","Mi halfinii on oo bandiraawo men wi'eteeɗo Fibii, wallitotooɗo ka *moftal wongal Kenkere, ");
INSERT INTO fuf_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","fii no jaɓɓoron mo e innde Joomiraaɗo on, e noone no haanirani gomɗinɓe ɓen. Wattitoɗon e juuɗe makko fii kala huunde nde haaju makko yanoyi e mon, ko fii o wallitike ɗuuɗuɓe, min kadi men o wallitike lan. ");
INSERT INTO fuf_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","Hiwranee lan Piriskiila e Akiila, ɓen wondiɓɓe an e golle e nder humondiral e Iisaa Almasiihu on, ");
INSERT INTO fuf_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","ɓen weeɓituɓe ngurndan mun fii hiwugol ngurndan an ɗan. Hinaa min tun non weltanii ɓe, kono ko mofte ɓe wonaa Yahuudiyanke ɓen fow kadi. ");
INSERT INTO fuf_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","Salminanee lan kadi moftal wongal ka suudu maɓɓe ngal. Salminanon mi kadi oo giɗo an wi'eteeɗo Apayniiti, on adiiɗo gomɗinde *Almasiihu on e hakkunde ɓe *Aazii ɓen. ");
INSERT INTO fuf_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","Salminanon mi Mariyama, on gollannooɗo on fota. ");
INSERT INTO fuf_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","Salminanon mi kadi Andoroniiki e Yuniyaasi, ɗun ko ɓee musiɓɓe an e wondiɓɓe an ka kaso, ɗun ko ɓen ɓe *sahaabaaɓe ɓen hoolii fota, adiiɓe lan jeyeede e Almasiihu on. ");
INSERT INTO fuf_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","Salminanon mi kadi Ampiliyaasi, on giɗo an e nder humondiral e Joomiraaɗo on. ");
INSERT INTO fuf_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","Salminanon mi kadi Urbaanu, ɗun ko oo wondiɗɗo men e golle e nder humondiral e Almasiihu on, e oo giɗo an wi'eteeɗo Astakiisi. ");
INSERT INTO fuf_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","Salminanon mi kadi Apeliisi, on mo gomɗinal mun e Almasiihu on seeditaa fii mun. Salminanon mi ɓee jeyaaɓe e nduu suudu oo wi'eteeɗo Aristobuulu. ");
INSERT INTO fuf_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","Salminanon mi oo musiɗɗo an wi'eteeɗo Herodiyuuna. Salminanon mi kadi ɓee jeyaaɓe e nduu suudu oo wi'eteeɗo Narkiisu, humondirɓe e Joomiraaɗo on. ");
INSERT INTO fuf_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","Salminanon mi kadi Tarifayna e Tarifuusa, ɗun ko ɓee rewɓe gollanooɓe Joomiraaɗo on. Salminanon mi kadi Persiisa, giɗo an on, on kadi gollanii Joomiraaɗo on fota. ");
INSERT INTO fuf_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","Salminanon mi kadi Rufuusa, oo suɓaaɗo Joomiraaɗo on. Salminanon mi kadi yumma makko, on mo tawata kadi ko yumma an. ");
INSERT INTO fuf_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","Salminanon mi kadi Asinkiriiti e Filiguuna e Hermiisi e Patrobaasi e Hermasa e musiɓɓe wonduɓe e maɓɓe ɓen fow. ");
INSERT INTO fuf_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","Salminanon mi kadi Filolooge e Yuliyaa e Niriyuusa, wondude e bandiraawo makko on, e Olimpaasi e wondiɓɓe maɓɓe gomɗinɓe ɓen fow. ");
INSERT INTO fuf_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","Salmondiree, hirbondiron hirbondiral laaɓungal. Mofte* Almasiihu on ɗen fow salminii on. ");
INSERT INTO fuf_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","Mi wakkilinii on, yo musiɓɓe an, e reenagol ko wonata sabu sendondire e pegge ko luutondiri e jannde nde hendiɗon nden. Woɗɗitee ɓen wonayɓe sabu ɗun. ");
INSERT INTO fuf_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","Ko fii sifa ɓen yimɓe kurkantaako Almasiihu on, on Joomi men, kono ko deedi maɓɓe ɗin tun ɓe kurkantoo. Ɓe faljinira ɓerɗe ɓen ɓe bonnaa, konguɗi maɓɓe welɗi e waccooje. ");
INSERT INTO fuf_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","Onon non, ɗoftaare mon nden ko nde yimɓe ɓen fow andi. Awa miɗo weltori fii mon on, e miɗo yiɗi yo on wonu faamuɓe e telen-ma ko moƴƴi kon, e ɗayɓe e telen-ma ko boni kon. ");
INSERT INTO fuf_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","Alla Jom ɓuttu on muncay Ibuliisa ka ley koyɗe mon ko neeɓaa. Yo moƴƴere Iisaa Joomi men on wonu e mon. ");
INSERT INTO fuf_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","Timotee, oo wondiɗɗo an e golle, salminii on, wondude e Lukiyuusi e Yaasuunu e Sosipaate, ɓee musiɓɓe an. ");
INSERT INTO fuf_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","E innde Joomiraaɗo on, min oo wi'eteeɗo Tertiyuusi, mi salminii on, ɗun ko min oo winduɗo nduu ɓatakuru. ");
INSERT INTO fuf_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","Gayuusi wernuɗo lan on, werni moftal ngal fow kadi, salminii on. Arastuusa kadi, ɗun ko halfinaaɗo jawdi saare nden, salminii on, wondude e oo musiɗɗo wi'eteeɗo Kawartuusu. ");
INSERT INTO fuf_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","Yo moƴƴere Iisaa Almasiihu Joomi men on wonu e mon on fow. Aamiina! ");
INSERT INTO fuf_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","Mangu wonanii Alla, on Waawuɗo tabintinde on, immorde e Kibaaru Moƴƴo an on e waajuuji fii Iisaa Almasiihu on, ko yaadi e feɲɲinannde gundoo suuɗinooɗo on gila ka fuɗɗoode saa'iiji ɗin, ");
INSERT INTO fuf_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","kono o feɲɲiniraama jooni defte annabaaɓe ɓen, wano Alla poomayankeejo on yamiri non, o feɲɲinanaama leƴƴi ɗin fow fii yo ɓe gomɗin mo, ɓe ɗoftoo mo. ");
INSERT INTO fuf_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","Mangu wonanii on Alla Bajjo, Jom Faamu, immorde e Iisaa Almasiihu on haa poomaa. Aamiina!");
INSERT INTO fuf_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","Immorde e an min Puulusa, mo Alla noddiri kodduruyee mun on fii wonugol *sahaabaajo Iisaa Almasi