﻿USE sofia;
DROP TABLE IF EXISTS sofia.fue_vpl;
CREATE TABLE fue_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES fue_vpl WRITE;
INSERT INTO fue_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Nani ɗo inɗe kaakiraaɓe Yeesu Almasiihu, taaniraawo Dawda, taaniraawo Iburahiima: ");
INSERT INTO fue_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Iburahiima rimi Isiyaaku, Isiyaaku rimi Yaakuubu, Yaakuubu rimi Yahuuda e miiraaɓe mum. ");
INSERT INTO fue_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yahuuda rimi Fares e Jara, kamɓe woni ɓe o rindi e Tamar, Fares rimi Hisuruuna, Hisuruuna rimi Aram. ");
INSERT INTO fue_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram rimi Aminadab, Aminadab rimi Nasuuna, Nasuuna rimi Salmuuna. ");
INSERT INTO fue_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmuuna rimi Bo'es, mo o rindi e Rahab, Bo'es rimi Obed, mo o rindi e Ruutu, Obed rimi Yesa. ");
INSERT INTO fue_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yesa rimi Dawda, laamiiɗo. Dawda rimi Suleymaanu, inniiko woni debbo mo Uriya acci. ");
INSERT INTO fue_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Suleymaanu rimi Robo'am, Robo'am rimi Abiya, Abiya rimi Asa. ");
INSERT INTO fue_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa rimi Yusafat, Yusafat rimi Yoram, Yoram rimi Ujiya. ");
INSERT INTO fue_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ujiya rimi Yotam, Yotam rimi Akas, Akas rimi Hejekiya. ");
INSERT INTO fue_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hejekiya rimi Manaasa, Manaasa rimi Amon, Amon rimi Yusiya. ");
INSERT INTO fue_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yusiya rimi Yekuniya e miiraaɓe mum. Wakkati mum nun Yahuduuɓe egginaa, yaaraa leydi Babiila. ");
INSERT INTO fue_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ɓaawo no ɓe jaara Babiila, Yekuniya rimi Salaatiyel, Salaatiyel rimi Jorobabel. ");
INSERT INTO fue_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Jorobabel rimi Abihuda, Abihuda rimi Eliyakim, Eliyakim rimi Ajora. ");
INSERT INTO fue_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ajora rimi Sadok, Sadok rimi Akim, Akim rimi Eliyuda. ");
INSERT INTO fue_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliyuda rimi Eliyaajaru, Eliyaajaru rimi Mattan, Mattan rimi Yaakuubu. ");
INSERT INTO fue_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yaakuubu rimi Yusufu, gorko Mariyama, inna Yeesu, bi'eteeɗo Almasiihu. ");
INSERT INTO fue_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Jaamanuuji sappo e naay nun waɗi diga Iburahiima faa yottii Dawda. Diga Dawda faa yottii wakkati Yahuduuɓe egginaa, yaaraa Babiila, waɗii jaamanuuji sappo e naay. Diga Yahuduuɓe egginaa yaara Babiila, faa yottii Almasiihu, waɗii jaamanuuji sappo e naay. ");
INSERT INTO fue_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Nani ɗo no Yeesu Almasiihu rimiraa. Mariyama inniiko, e laatii mo Yusufu ɗaɓɓi. Amma ko ɓe kawta, Mariyama heɓii reedu e baawɗe Ruuhu Ceniiɗo. ");
INSERT INTO fue_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yusufu ɗaɓɓuɗo Mariyama e laatii neɗɗo poonnitiiɗo. O yiɗay sentingo mo, den o resi salaago mo e cuuɗiiɗum. ");
INSERT INTO fue_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Wakkati o woni oo miijoo ka, malaykaajo Joomiraawo wari e makko, der koyɗool. Malaykaajo on wi'i mo: «Yusufu, taaniraawo Dawda, taa hulu ettugo Mariyama, debbo maa. Gam ɓinŋel ŋel o saawi, e Ruuhu Ceniiɗo ƴiwi. ");
INSERT INTO fue_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","O riman ɓiɗɗo gorko, kokkaa mo inne Yeesu, gam o hisinan himɓe makko diga hakkeeji maɓɓe.» ");
INSERT INTO fue_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ɗum fu, ɗum waɗii gam hebbingo haala ka Joomiraawo batuno diga e hunnuko annabiijo, o wi'i: ");
INSERT INTO fue_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«Gatol ŋol annaa gorko saawan, rima ɓiɗɗo gorko, o wi'ete Emmanuwel.» Maana inne nen woni: «Alla e wondi e meeɗen.» ");
INSERT INTO fue_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","No Yusufu fini, waɗi ko malaykaajo Joomiraawo bati ɗum, o ɓaŋi Mariyama. ");
INSERT INTO fue_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Amma o hawtay e makko, faa nyaanne o rimi ɓiɗɗo gorko. Yusufu hokki mo inne Yeesu. ");
INSERT INTO fue_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yeesu rimaama Baytilaama der leydi Yahudiya, wakkati laamiiɗo Eroodu, go wooduɓe annal ƴiwoy diga lettugal, wari Urusaliima. ");
INSERT INTO fue_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","No ɓe jottii, ɓe ƴami: «Toy laamiiɗo Yahuduuɓe dimaaɗo jooni on woni? Men ji'ii hoodere makko diga lettugal, men garii sujidango mo.» ");
INSERT INTO fue_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","No laamiiɗo Eroodu nani habaru on, hakkillo mum jiɓii, kanko e himɓe Urusaliima fu. ");
INSERT INTO fue_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","O noddini hooreeɓe limaamiiɓe, e moodiɓɓe tawreeta fu, o ƴami ɓe, toy nun Almasiihu rimetee? ");
INSERT INTO fue_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ɓe toontii mo, ɓe bi'i: «Baytilaama nun, der leydi Yahudiya, gam nani ko annabiijo winnunoo: ");
INSERT INTO fue_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‟An, Baytilaama der leydi Yahudiya, a faanɗay caka ci'e Yahudiya mawɗe. Gam ardotooɗo ƴiwan diga e maa, kanko nun durata himɓe am Isira'iilaaɓe.”» ");
INSERT INTO fue_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Den, Eroodu noddini wooduɓe annal ɓen e cuuɗiiɗum, ƴami ɓe ɓe laaɓinana ɗum wakkati de hoodere nen hollitii. ");
INSERT INTO fue_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ɓaawo mum, o lildi ɓe Baytilaama, o wi'i ɓe: «Jahee, pumpitee habaru sukayel ŋel faa laaɓa. To on ji'ii ŋel, maatinee am, gam mi yaha, min bo, mi sujidana ŋel.» ");
INSERT INTO fue_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","No ɓe nani ka laamiiɗo bati ɓe, ɓe jawti. Den, ɓe kollirii hoodere ne ɓe ji'unoo lettugal e ardii ɓe. No ne yottii nokkuure to sukayel ŋel woni, ne darii. ");
INSERT INTO fue_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","No ɓe ji'i hoodere nen, ɓerɗe maɓɓe welii puy. ");
INSERT INTO fue_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ɓe naati der wuro, ɓe ji'i sukayel e inna mum, Mariyama. Ɓe jiccii, ɓe cujidani ŋel. Ɓe pitti gineeji maɓɓe, ɓe kokkori ŋel kanŋeeje, e wardi buuɗeteeɗum, e ɗacce luuttooje, bi'eteeɗe miir. ");
INSERT INTO fue_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ɓaawo majjum, Alla holli ɓe der koyɗool to ɓe bittu to Eroodu. Den ɓe kootiri leydi maɓɓe e laawol gonŋol. ");
INSERT INTO fue_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","No ɓe jawti, malaykaajo Joomiraawo hollitanii Yusufu der koyɗool, wi'i mo: «Umma, ettu sukayel ŋel e inna mum. Doggidin ŋel, jahaa Misira, jooɗoɗaa ton faa de bi'umaa mi gartaa. Gam Eroodu waran daartugo sukayel ŋel, gam halka ŋel.» ");
INSERT INTO fue_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Yusufu ummii jemma, yaari sukayel ŋel e inna mum faa Misira. ");
INSERT INTO fue_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","O jooɗii ton faa de Eroodu maayi. Nun nun ka Joomiraawo batuno e hunnuko annabiijo hebbiri, de o wi'i: «Mi noddii ɓiyam wurtoo diga Misira.» ");
INSERT INTO fue_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","No Eroodu faami wooduɓe annal ɓen jammike ɗum, mone makko ummii puy. O lili ɓe bara sukahon goron tawaakon Baytilaama e der jeyde makko fu, diga sukahon keccon, faa kon duuɓi ɗiɗi. O waɗii ɗum, o foonni deydey wakkati ki wooduɓe annal batuno mo dow hollitaago hoodere nen. ");
INSERT INTO fue_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ɗum hebbinii haala ka annabi Yeremiya batunoo, wi'i: ");
INSERT INTO fue_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«Cimaali nanaama der siire Rama, e bojji, e goytaali ɗuuɗɗi. Rahiilu nun wullata, gam sukahon mum. O nootaaki eyteego, gam kon maayidii.» ");
INSERT INTO fue_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ɓaawo maayde Eroodu, malaykaajo Joomiraawo hollitanii Yusufu der koyɗool, der leydi Misira. ");
INSERT INTO fue_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","O wi'i mo: «Umma, ettu sukayel ŋel e inna mum, bitton leydi Isira'iila, gam yiɗunooɓe warugo suka on maayii.» ");
INSERT INTO fue_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Den Yusufu ummii, etti sukayel ŋel e inna mum, ɓe bitti leydi Isira'iila. ");
INSERT INTO fue_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Amma Yusufu nanii Arikilawus jaɓii laamaare baaba mum Eroodu, laamii dow Yahudiya. O huli yahugo ton. Ko Alla baddi mo der koyɗool, den o yahi far leydi Galili. ");
INSERT INTO fue_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","O yahi o jooɗii siire wi'eteene Nasaratu. Ɗum laatike, gam hebbingo ka annabiiɓe batunoo, wi'i: «O noddete Nasaratuujo.» ");
INSERT INTO fue_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Wakkati majjum, Yuhaana gaɗoowo batisi suppitii. Oo waajoo der ladde haro Yahudiya, oo wi'a: ");
INSERT INTO fue_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","«Tuubee, gam Laamaare Alla faanake.» ");
INSERT INTO fue_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Kanko nun annabi Esaaya batani, wi'i: «Daane neɗɗo e bata dow dow, der haro, e wi'a: Moƴƴinee laawol Joomiraawo, poonnitee laabi makko!» ");
INSERT INTO fue_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yuhaana e ɓorninoo gineeji cannyiraaɗi leeɓi jeelooba, oo haɓɓii ɓelɓelol gurol dow funŋudu makko. Nyaamdu makko laatii baɓatti e juuri ladde. ");
INSERT INTO fue_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Himɓe Urusaliima, e leydi Yahudiya, e tawaaɓe takkol maayo Urdun fu, wari to makko. ");
INSERT INTO fue_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ɓe tuubi hakkeeji maɓɓe, go Yuhaana waɗi ɓe batisi der maayo Urdun. ");
INSERT INTO fue_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","No o yi'i Farisaaɓe e Sadukiiɓe ɗuuɓɓe e wara waɗeego batisi, o wi'i ɓe: «Ɓiɓɓe bolle pure! Moy tintini on doggon mone Alla waroore? ");
INSERT INTO fue_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Gaɗee golle kollitooje on tuubii. ");
INSERT INTO fue_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","To on miilee e ɓerɗe mooɗon bi'on: ‟Iburahiima nun woni maama amen!” Gam mii wi'a on, Alla e waawi waylitingo kaaƴe, ɗe laatoo ɓiɓɓe Iburahiima! ");
INSERT INTO fue_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Jooni, jammere ɓantaama gam feƴƴa leɗɗe faa e ɗaɗi mum. Den, leggal ŋal rimataa ɓiɓɓe booɗɗe fu wudditinte, faɗɗee der yiite. ");
INSERT INTO fue_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Min, e diyam nun gaɗiranmi on batisi, gam hollitingo on tuubi. Amma garoowo ɓaawo am, e ɓurimmi baawɗe. Mi fotay du baa jimminaago, ɓorta paɗe makko. Kanko, o waɗan on batisi e Ruuhu Ceniiɗo, e yiite. ");
INSERT INTO fue_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Oo jogii besirɗum e junŋo makko, o laaɓinan fiyirde makko. O loowa gawri der rummuure makko, o wula nyaane der yiite ŋe nyifataa.» ");
INSERT INTO fue_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Wakkati majjum, Yeesu ƴiwi Galili, wari maayo Urdun to Yuhaana, gam Yuhaana waɗa mo batisi. ");
INSERT INTO fue_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Amma Yuhaana nootaaki, wi'i: «Min nun haajaa gaɗanaa batisi, ko an nun wari to am mi waɗanee?» ");
INSERT INTO fue_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yeesu toontii mo, wi'i: «Noota ɗum laatoo non non jooni, gam hande non kebbinirten ko foonnitii fu.» Den Yuhaana nootii. ");
INSERT INTO fue_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ɗon maa ɗon, no Yeesu waɗaa batisi, wurtii e diyam, kammu maɓɓitii. O yi'i Ruuhu Alla e jippoo dow makko, hande tantabaraaru. ");
INSERT INTO fue_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ɗon daane gom nanaa dow kammu, e wi'a: «Oo ɗo nun laatii Ɓiɗɗo am jiɗaaɗo, mo ceyoriimi.» ");
INSERT INTO fue_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ɓaawo majjum, Ruuhu Ceniiɗo yaari Yeesu der haro gam Ibiliisa jarboo mo. ");
INSERT INTO fue_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","O suumii nyaloomaaje lasoy ɗiɗi e jemmaaje lasoy ɗiɗi. Den, rafo waɗi mo. ");
INSERT INTO fue_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ɗon Jarbotooɗo on ɓattii mo, wi'i: «To a laati nun Ɓiɗɗo Alla, batu kaaƴe ɗee ɗo waylitoo peen.» ");
INSERT INTO fue_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yeesu toontii mo, wi'i: «E winnaa: ‟Neɗɗo wuurirtaa e peen tan, amma e haala burtiika diga hunnuko Alla fu.”» ");
INSERT INTO fue_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ibiliisa yaari mo wanŋarde seniine, ɓili mo dow suudu Alla to ɓuri towugo. ");
INSERT INTO fue_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Den o wi'i mo: «To a laati nun Ɓiɗɗo Alla, fittu koɗaa ley, gam e winnaa der dewtere, Alla batan malaykaaɓe mum ɓe taɓɓee e juuɗe maɓɓe gam to koyɗe maa fergoo kaaƴe.» ");
INSERT INTO fue_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yeesu toontii mo, wi'i: «Dewtere wi'i kade: ‟Taa jarba Alla Joomiraawo maa”.» ");
INSERT INTO fue_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ibiliisa yaari mo kade dow waanne towune puy. O holli mo laamaareeji duuniyaaru fu e tedduŋal majji. ");
INSERT INTO fue_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Den o wi'i mo: «Mi hokkete huune ɗum fu, to a jiccake cujidanɗaa am.» ");
INSERT INTO fue_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yeesu toontii mo, wi'i: «Dillu diga ɗon, an Ibiliisa, gam e winnii der dewtere: ‟Sujidan Alla Joomiraawo maaɗa, kanko tan teddintaa!”» ");
INSERT INTO fue_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Den Ibiliisa acci mo, go malaykaaɓe ɓattii e jagganoo mo. ");
INSERT INTO fue_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","No Yeesu nani Yuhaana gaɗoowo batisi nanŋaama, wattaa der kasu, o witti leydi Galili. ");
INSERT INTO fue_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","O eggi Nasaratu, o jooɗoy Kafarnahum, takkol fonŋo maayo Galili, hakkune jeyde leydi Jabulon e Neftali. ");
INSERT INTO fue_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Hande non haala ka annabi Esaaya batunoo hebbiri, o wi'i: ");
INSERT INTO fue_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","‟Leydi Jabulon e leydi Neftali, jooɗiini takkol maayo, fonŋo Urdun, Galili, an laatiini jooɗorde himɓe ɓe lenyi janani. ");
INSERT INTO fue_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Himɓe tawaaɓe der niwre, yi'ii jayŋol manŋol. Jooɗiiɓe e leydi maayde, niɓɓuni, jayŋol yaynanii ɗum.” ");
INSERT INTO fue_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Diga wakkati majjum, Yeesu fuɗɗi waajaago e wi'a: «Tuubee, gam Laamaare Alla ɓattike.» ");
INSERT INTO fue_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","No Yeesu woosotoo takkol fonŋo maayo Galili, o yi'i suuɓotooɓe liƴƴi ɗiɗo, Simon, noddeteeɗo Piyer, e minyum Andere, e faɗɗa taaruuji mum der maayo. ");
INSERT INTO fue_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yeesu wi'i ɓe: «Tokkee am, mi waɗan on suuɓotooɓe himɓe.» ");
INSERT INTO fue_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ɗon maa ɗon ɓe acci taaruuji maɓɓe, ɓe tokki mo. ");
INSERT INTO fue_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","O yahi yeeso, o yi'i rindaaɓe ɗiɗo der laana, Yaakuuba e minyum Yuhaana, ɓiɓɓe Jebede. Kamɓe e baaba maɓɓe, ɓee moƴƴina taaruuji maɓɓe. O noddi ɓe. ");
INSERT INTO fue_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ɗon maa ɗon, ɓe acci laana ŋan e baaba maɓɓe, ɓe tokki mo. ");
INSERT INTO fue_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yeesu woositii leydi Galili fu. Oo janŋina der cuuɗi baajorɗi, oo waajoo linjiila dow Laamaare Alla, oo nyawta himɓe ɓe nyawuuji feere feere, e toorotooɓe. ");
INSERT INTO fue_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Habaru makko sankitii der leydi Siriya fu. Ɓee gaddana mo nyawɓe nyawuuji feere feere, hande ɓe ginnaaji toorata, e yanooɓe paɗɗe, e moofiɗinɓe, o nyawti ɓe. ");
INSERT INTO fue_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Jama'aare ɗuunne e tokki mo. Ɓe ƴiway maa diga leydi Galili, e ɓaadeere Genniije Sappo, e Urusaliima, e Yahudiya, e fonŋo maayo Urdun. ");
INSERT INTO fue_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","No Yeesu yi'i jama'aare ɗuunne, o eenci dow waanne, o jooɗii. Aahiiɓe makko hawritii ley makko. ");
INSERT INTO fue_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","O fuɗɗi waajaago ɓe, o wi'i: ");
INSERT INTO fue_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«Barke laatanii ɓe yonki mum humpaa Alla, gam kamɓe nun jey Laamaare Alla! ");
INSERT INTO fue_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Barke laatanii wullooɓe, ɓerɗe maɓɓe fewtinte! ");
INSERT INTO fue_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Barke laatanii ɗigguɓe, gam ɓe donan leydi! ");
INSERT INTO fue_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Barke laatanii rafaaɓe, e ɗonɗaaɓe foonnitaare, gam ɓe kaaran! ");
INSERT INTO fue_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Barke laatanii enɗotooɓe, gam ɓe enɗete! ");
INSERT INTO fue_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Barke laatanii ɓe ɓerɗe mum laaɓi, gam ɓe ji'an Alla! ");
INSERT INTO fue_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Barke laatanii daartooɓe jam, gam ɓe noddete ɓiɓɓe Alla! ");
INSERT INTO fue_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Barke laatanii tooraaɓe gam sabbu foonnitaare, gam kamɓe nun Laamaare Alla laatanii! ");
INSERT INTO fue_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Barke laatanii on, to himɓe yennii on, toorii on, takki on gaccee baaɗey fu, sabbu am. ");
INSERT INTO fue_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ceyee, belbeltee, gam riiba mawka e heɗii on dow kammu. Hande non annabiiɓe ardiiɓe on tooriraa.» ");
INSERT INTO fue_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","«Onon laatii lamɗam duuniyaaru. Amma to lamɗam walaa dakam, e ume ɗam welinirtee? Ɗam nafataa goɗɗum, sey ɗam woppee, himɓe yaaɓa ɗam. ");
INSERT INTO fue_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Onon laatii jayŋol duuniyaaru. Genni mahaani dow waanne suuɗataako. ");
INSERT INTO fue_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Fitilla bo huɓɓataake gam ka ommee gummal. Amma ka ɓilete dow to fitilla ɓiletee, gam ka yaynana wonuɓe der suudu fu. ");
INSERT INTO fue_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Hande non haani jayŋol mooɗon yaynira yeeso himɓe. Den ɓe ji'an golle booɗɗe ɗe gaɗoton, ɓe teddina Baaba mooɗon gonuɗo dow kammu.» ");
INSERT INTO fue_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","«To on miilee mi warii gam moytugo tawreeta, ɗum bo ko winnaa der dewte annabiiɓe. Mi waray moytugo ka, amma gam hebbingo ka. ");
INSERT INTO fue_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","E gooŋa batanmi on, dow e leydi heennyan, amma toɓɓel, ɗum bo maasel gootel der tawreeta, sottintaake, faa nyalaane huune fu hebboyta. ");
INSERT INTO fue_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Gam majjum, mo ɗowtanaaki toɓɓel gootel, ɓuruŋel faanɗugo der tawreeta, go e ekkitina woɓɓe bo to ɗowtoo, o laatoto paanɗuɗo der Laamaare Alla. Amma ɗowtaniiɗo tawreeta, go e janŋina woɓɓe bo ɗowtanoo ka, joomum laatoto mawɗo der Laamaare Alla. ");
INSERT INTO fue_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","E gooŋa bi'anmi on, to foonnitaare mon ɓuray ne moodiɓɓe tawreeta e Farisaaɓe, on naatataa der Laamaare Alla pay.» ");
INSERT INTO fue_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","«On nanii ko kaakiraaɓe meeɗen wi'ano: ‟Taa waru neɗɗo, baruɗo neɗɗo fu, hiitete.” ");
INSERT INTO fue_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Amma min, mii wi'a on, jogoriiɗo banniraawo mum mone fu, hiitete. Bi'uɗo banniraawo mum: ‟A walaa hoore,” joomum yaarete yeeso hiitorde mawne. Bi'uɗo banniraawo mum ‟A haaŋa nun,” o wattete der yiite jahannama. ");
INSERT INTO fue_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Gam majjum, to a yahii sakkanoygo Alla sadaka, to hiisirde, go ciwtorɗaa aa woodi gokka e banniraawo maa, ");
INSERT INTO fue_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","accu ɗon sadaka maa yeeso hiisirde. Den jahaa taw to banniraawo maa, jaafontiron. Ɓaawo mum, bittaa, cakkaa sadaka maa. ");
INSERT INTO fue_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","To goɗɗo gaccake maa, go oon jaha to kiitotooɗo, yawɗa nannantiraa e makko diga e laawol. To a waɗay ɗum, o wattete der juuɗe kiitotooɗo, den kiitotooɗo bo wattee e juuɗe sandaaji, maɓɓeɗaa der kasu. ");
INSERT INTO fue_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Mii batee e gooŋa, a wurtataako diga ɗon, to a yoɓiday nyamaane maa, faranwel mum koriiŋel.» ");
INSERT INTO fue_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","«On nanii wi'aanoma: ‟Taa waɗu jeenu!” ");
INSERT INTO fue_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Amma min, mii wi'a on, daaruɗo debbo fu, ko suunii mo, waɗii jeenu e makko der ɓerne mum. ");
INSERT INTO fue_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Gam majjum, to itere maa nyaamoore nun laatantee daliila doƴƴere, ɗoofu ne, boppaa to woɗɗi! Ɗum ɓurante jokkulal ɓannu maa gootal halka, e no ɓannu maa fu naatirta der yiite jahannama. ");
INSERT INTO fue_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","To junŋo maa nyaamo nun laatantee daliila doƴƴere, wudditin ŋo, boppaa to woɗɗi, ɗum ɓurante jokkulal maa gootal halka, e no ɓannu maaɗa fu naatirta der yiite jahannama.» ");
INSERT INTO fue_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","«Wi'aama bo: ‟Ceeruɗo debbo mum fu, sey hokka mo ɗerewol ceergal.” ");
INSERT INTO fue_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Amma min kan, mii wi'a on, ceeruɗo debbo mum to hinaa gam daliila jeenu, to o hoowaama, o laatinii mo jeenoowo. Neɗɗo koowuɗo debbo ceeraaɗo fu, waɗii jeenu kanun bo.» ");
INSERT INTO fue_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","«On nanii kade, kaakiraaɓe meeɗen wi'aama: ‟Taa fiirtu hunayeere maa, hebbin ne yeeso Joomiraawo.” ");
INSERT INTO fue_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Amma min, mii wi'a on, to on kunee. To on kunoree kammu, gam ŋu laati nun gurol Laamaare Alla. ");
INSERT INTO fue_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","To on kunoree leydi, gam ni laati nun jaaɓirɗum koyɗe makko. To on kunoree Urusaliima, gam ni laati nun wanŋarde Laamiiɗo mawɗo. ");
INSERT INTO fue_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","To on kunoree ko'e mon bo, gam on baawataa rawningo, ɗum bo ɓawlingo baa leeɓol gaasa mon gootol. ");
INSERT INTO fue_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Haala mon fu daroo dow: ‟oo”, ɗum bo ‟aawo”, to yawtu ɗon. Ko ɓeydii dow majjum fu ƴiwii diga e Kalluɗo.» ");
INSERT INTO fue_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","«On nanii wi'aama, ‟Itere yoɓiree itere, nyiire yoɓiree nyiire.” ");
INSERT INTO fue_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Amma min, mii wi'a on, to on battee gaɗanɗo on ko boni. To goɗɗo fiyii maa meenyo dow golal nyaamowal, hokku mo ŋal to bo. ");
INSERT INTO fue_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","To goɗɗo gaccike maa, e yiɗi teeta dansikiire maa, accu mo o etta gulunfaare maa bo. ");
INSERT INTO fue_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","To goɗɗo doolii maa doonanoɗaa ɗum doongal mum kuule ujuneere, roonana mo ŋal kuule ujune ɗiɗi. ");
INSERT INTO fue_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","To goɗɗo eelii maa, hokku mo. To goɗɗo e yiɗi wuƴaago huune maa, taa haɗu mo ɗum.» ");
INSERT INTO fue_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","«On nanii wi'aama: ‟Yiɗu banniraawo maa, banyaa ganyo maa.” ");
INSERT INTO fue_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Amma min, mii wi'a on, jiɗee wayɓe mooɗon, du'anee tooranɓe on. ");
INSERT INTO fue_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Hande non, laatortoɗon ɓiɓɓe Baaba mooɗon gonuɗo dow kammu. Gam oo fuɗina naaŋe dow yeeɗɗuɓe e halluɓe. Oo toɓina bo diyam gam foonnitiiɓe e ɓe foonnitaaki. ");
INSERT INTO fue_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","To oon jiɗi yiɗuɓe on tan, riiba kaye keɓoton? Baa jaɓooɓe ceede faada bo e waɗa hande non! ");
INSERT INTO fue_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","To oon canna banniraaɓe mooɗon tan, ko haaynii ume gaɗoton ɗon? Baa heeferɓe bo e waɗa hande non! ");
INSERT INTO fue_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","To non, laatee hebbuɓe, hande no Baaba mooɗon mo dow kammu laatorii kebbuɗo.» ");
INSERT INTO fue_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","«Kakkilee, to on kollitee gaɗu mooɗon geetu yeeso himɓe gam ji'eɗon. To on gaɗii ɗum, on keɓataa riiba to Baaba mooɗon gonuɗo dow kammu. ");
INSERT INTO fue_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","To non, to aa hokka sadaka, taa fiyu lenŋuru gam himɓe yi'ee. Non non nun munaafitiiɓe waɗata der cuuɗi baajorɗi, e sera laabi. Ɓee gaɗa ɗum gam himɓe mana ɓe. E gooŋa batanmi on, ɓe keɓii ko riiba maɓɓe. ");
INSERT INTO fue_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Amma, to aa hokka sadaka, taa accu junŋo maa nano anna ko nyaamo waɗata. ");
INSERT INTO fue_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","To a waɗii ɗum, sadaka maa laatoto e cuuɗiiɗum. Den Baaba maa ji'oowo ko woni der cuuɗiiɗum, yoɓete ɗum.» ");
INSERT INTO fue_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","«To oon du'oo, to on gaɗee hande no munaafitiiɓe waɗata. Kamɓe ɓee jiɗa du'aago e darorii der cuuɗi baajorɗi, e ate cele, gam himɓe fu yi'a ɓe. E gooŋa batanmi on, ɓe keɓii riiba maɓɓe ko. ");
INSERT INTO fue_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Amma an, to aa du'oo, naatu suudu maa, maɓɓaa dammugal, eelaa Baaba maa e cuuɗiiɗum. Den, Baaba maa ji'oowo ko woni der cuuɗiiɗum, yoɓete ɗum. ");
INSERT INTO fue_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","To oon du'oo, to on ɗuuɗinee haalaaji ɗi galaa nafuwe hande no heeferɓe waɗata. Ɓee miili to ɓe ɗuuɗinii haalaaji, Alla toontoto ɓe. ");
INSERT INTO fue_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Gam majjum to on nandee e maɓɓe, gam Baaba mooɗon e anni ko kaajaɗon diga on eelay ɗum.» ");
INSERT INTO fue_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","«Nani ɗo no haani du'oroɗon: ‟Baaba amen tawaaɗo dow kammu, inne maa e senii. ");
INSERT INTO fue_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Laamaare maa wara. Sago maa laatoo dow leydi, hande no ŋo laatorii dow kammu. ");
INSERT INTO fue_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Hokku men nyaamdu keƴannu men hanne. ");
INSERT INTO fue_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Yaafana men hakke amen, hande no minon bo men jaaforanto woofananɓe men. ");
INSERT INTO fue_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Taa accu men naata der jarbeeji, amma hisin men diga e Kalluɗo. Gam an nun laamaare, e baawɗe, e tedduŋal fu woodani faa abada. Aami!” ");
INSERT INTO fue_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","To on jaafanake himɓe boofi mum, Baaba mooɗon gonuɗo dow kammu yaafanto on onon bo. ");
INSERT INTO fue_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Amma to on jaafanaaki himɓe, Baaba mooɗon bo yaafantaako on boofi mooɗon.» ");
INSERT INTO fue_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","«To oon cuumoo, to on jurmikinee hande no munaafitiiɓe waɗata. Ɓee jiɓa geese maɓɓe gam himɓe annita ɓee cuumii. E gooŋa batanmi on, ɓe keɓii ko riiba maɓɓe. ");
INSERT INTO fue_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Amma an, to aa suumii, sulma, bujoɗaa wardi. ");
INSERT INTO fue_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Den himɓe annitintaa naa aa suumii. Amma Baaba maa mo yi'ataake tan anni. Baaba maa ji'oowo ko gaɗuɗaa der cuuɗiiɗum, kanko yoɓetee.» ");
INSERT INTO fue_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«To on kawritanee ko'e mon jawdi der duuniyaaru, to mooƴi e guƴuhon biisata ni, ɗum bo to wuyɓe yulata cuuɗi mon, wujja ni. ");
INSERT INTO fue_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Amma kawritanee ko'e mon jawdi dow kammu, to guƴuhon e mooƴi biisataa ni, wuyɓe bo heɓataa wujja ni. ");
INSERT INTO fue_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Gam to jawdi maa woni, ɗon ɓerne maa bo wonoto.» ");
INSERT INTO fue_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","«Gite woni fitilla ɓannu. To gite maa e yanɗi, ɓannu maa fu, wonoto der jayŋol. ");
INSERT INTO fue_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Amma to gite maa yanɗaa, ɓannu maa ŋol fu, ŋol wonoto der niwre. Den, to jayŋol gonuŋol der maa laatike niwre, a yi'ii ɗon no niwre mawniri!» ");
INSERT INTO fue_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","«Walaa baawoowo ko jagganii joomiraaɓe ɗiɗo, gam o wanyan oo ɗo, o yiɗa oo to, o takkontiran e oo ɗo, o yawoo oo to. On baawataa ko jagganii Alla, e jawdi.» ");
INSERT INTO fue_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","«Gam majjum bi'anmi on: To on cukulanee yonkiiji mooɗon dow ko nyaamoton e ko jaroton. To on cukulanee ɓalli mooɗon dow ko ɓornotoɗon. Yonki ɓuraa nyaamdu na? Ɓannu ɓuraa koltal na? ");
INSERT INTO fue_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Daaree pooli piirooji: Ɗi aawataa, ɗi duggataa, ɗi galaa rummuure. Amma e non, Baaba mooɗon gonuɗo dow kammu e nyaanna ɗi. On ɓuraa pooli tedduŋal na? ");
INSERT INTO fue_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Moy e mooɗon der ɓillaaje mum waawata ko ɓeydi balɗe mum, baa maƴƴande woore? ");
INSERT INTO fue_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","To non, gam ume ko oon cukulana kolte? Daaree no pinniiji gese mawnirta: Ɗi mottataa, ɗi cannyataa. ");
INSERT INTO fue_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Amma mii bata on, baa Suleymaanu e tedduŋal mum fu, ɓornaaki kolte booɗuɗe hande no pinniiji ɗin gootel mum. ");
INSERT INTO fue_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","To Alla e holtina kuɗooji ladde tawaaɗi hanne, jaaŋo ɗi bulee yiite, o holtintaa on ɓura non non na? Onon ɓe goonɗinki paanɗuki! ");
INSERT INTO fue_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","To on cukulee bi'on: «Ume nyaameten? Ume jareten? Ume ɓornotoɗen?» ");
INSERT INTO fue_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Gam kujje ɗee, heeferɓe nun daartata ɗe. Amma Baaba mooɗon gonuɗo dow kammu, e anni oon goodi haaje majje. ");
INSERT INTO fue_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Daartee aran Laamaare Alla, e foonnitaare makko. Den ko horii fu, on ɓeydante ɗum. ");
INSERT INTO fue_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","To on cukulanee gam jaaŋo, jaaŋo sukulanto hoore mum. Nyalaane fu, toora mum heƴii ɗum.» ");
INSERT INTO fue_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","«To on kiitee woɓɓe, gam to Alla hiitoo on. ");
INSERT INTO fue_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Gam no kiitoriɗon woɓɓe, non kiitorteɗon. Etorde etiranɗon woɓɓe, kayre etiranteɗon. ");
INSERT INTO fue_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ume waɗi go aa daara kuɗeel der itere banniraawo maa, go a faamanay legga gonuŋa der itere maa? ");
INSERT INTO fue_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Noy baawirtaa ko wi'i banniraawo maa: ‟Accu mi ikkinanee kuɗeel gonuŋel der itere maa”, nani bo, legga e woni der ne maa? ");
INSERT INTO fue_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Munaafitiijo, ikkin legga gonuŋa der itere maa taw, den gite maa laaɓan, keɓaa no ikkinirɗaa kuɗeel gonuŋel der itere banniraawo maa. ");
INSERT INTO fue_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","To on kokkee dawaaɗi ko senii, gam to ɗi bittoy ɗi ŋata on. To on cankitee kaaƴe mooɗon dime yeeso afaaji, gam to ɗi jaaɓu ɗe.» ");
INSERT INTO fue_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","«Eelee, on keɓan, daartee, on jiitan, cilminee, on maɓɓitante. ");
INSERT INTO fue_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Gam eeloowo fu, heɓan, daartoowo fu, yiitan, piyoowo dammugal fu, maɓɓitante. ");
INSERT INTO fue_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Moy caka mooɗon to ɓiyum eelii ɗum peen, hokka mo hayre? ");
INSERT INTO fue_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ɗum bo to o eelii mo linŋol, o hokkan mo boddi? ");
INSERT INTO fue_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Onon halluɓe, oon baawi hokkugo ɓiɓɓe mooɗon dokke booɗɗe, hakko Baaba mooɗon gonuɗo dow kammu. Oo hokka eelanɓe mo fu dokke booɗɗe. ");
INSERT INTO fue_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Gam majjum ko jiɗuɗon himɓe waɗana on fu, onon bo, gaɗanee ɓe ɗum. Kanjum woni ekkitinol tawreeta e dewte annabiiɓe.» ");
INSERT INTO fue_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","«Naatiree dammugal paanɗuŋal, gam dammugal jaajuŋal e laawol koyuŋol, e yaara der halkere, himɓe ɗuuɓɓe nun tokki ŋol. ");
INSERT INTO fue_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Amma dammugal paanɗuŋal, e laawol ɓilliiŋol, e yaara to yonki, yiituɓe ŋol ɗuuɗaa.» ");
INSERT INTO fue_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","«Kakkilanee annabiiɓe fewrekuuɓe. Ɓe garan to mooɗon, ɓee ɓornii guri baali, amma der maɓɓe, ɓee laatii bu'i ladde bonuɗi. ");
INSERT INTO fue_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","E gaɗu maɓɓe annitirton ɓe. Innabooje ɓorataake dow gi'e, ibbe bo ɓorataake dow gi'e danehi. ");
INSERT INTO fue_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Leggal booɗuŋal fu riman ɓiɓɓe booɗɗe, amma leggal kalluŋal riman ɓiɓɓe kalluɗe. ");
INSERT INTO fue_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Leggal booɗuŋal waawataa ko rimi ɓiɓɓe kalluɗe, nun bo leggal kalluŋal waawataa ko rimi ɓiɓɓe booɗɗe. ");
INSERT INTO fue_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Leggal fu ŋal rimataa ɓiɓɓe booɗɗe wudditinte, faɗɗee der yiite. ");
INSERT INTO fue_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Hande non, annitirton ɓe diga e gaɗu maɓɓe.» ");
INSERT INTO fue_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","«Hinaa wi'ooɓe am “Joomiraawo, Joomiraawo” fu naatata Laamaare Alla, sey waɗooɓe ko Baaba am gonuɗo dow kammu yiɗi tan. ");
INSERT INTO fue_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Nyalaane darŋal, ɗuuɓɓe wi'an am: ‟Joomiraawo, Joomiraawo! E inne maa nun men gaɗiri annabaaku. E inne maa nun men diiwiri ginnaaji. E inne maa nun men gaɗiri haaynaareeji ɗuuɗɗi.” ");
INSERT INTO fue_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Wakkati mum, mi toontoto ɓe: ‟Mi annaa on abada. Boɗɗee am, onon waɗooɓe ko halli!”» ");
INSERT INTO fue_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","«Hande non, neɗɗo fu kettiniiɗo haala am, go e gollira ka, e nandi e neɗɗo kakkilɗo, mahuɗo suudu mum dow tepaare. ");
INSERT INTO fue_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Diyam toɓi, gooruuji hebbi, keni mawɗi wifi dow maggol. Amma ŋol yanay, gam dow tepaare nun ŋol daɗɗaa. ");
INSERT INTO fue_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Amma kettiniiɗo haala am fu, go tokkay ka, e nandi e neɗɗo mo walaa hakkillo, mahuɗo suudu mum dow jaaneeri. ");
INSERT INTO fue_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Diyam toɓi, gooruuji hebbi, keni mawɗi wifi dow maggol. Den ŋol yani yanande mawne.» ");
INSERT INTO fue_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","No Yeesu heennyi waajuuji ɗin, haaynaare nanŋi jama'aare puy gam waaji makko. ");
INSERT INTO fue_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Gam o janŋinirii ɓe e baawɗe, hinaa hande no moodiɓɓe tawreeta janŋinirta. ");
INSERT INTO fue_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yeesu jippoyii diga dow waanne, go jama'aare ɗuunne e tokki mo. ");
INSERT INTO fue_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Wakkati mum, ceccefo gom wari, jiccii yeeso makko, wi'i mo: «Joomiraawo, to aa yiɗi, a waawan ko nyawtimmi.» ");
INSERT INTO fue_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yeesu foorti junŋo mum, meemi mo, wi'i: «Mii yiɗi, nyawta!» Ɗon maa ɗon, gorko on nyawtii. ");
INSERT INTO fue_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Den Yeesu wi'i mo: «Hakkil! Taa batu ka goɗɗo. Amma yahu holloy hoore maa limaamiijo. Den, gaɗaa sadaka ka Muusa wi'i on gaɗon, gam anninaa ɓe a yoofake.» ");
INSERT INTO fue_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yeesu e naata siire Kafarnahum, ɗon hooreejo soogeeji gom ɓattii mo, eeli mo, wi'i: ");
INSERT INTO fue_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","«Joomiraawo, jaggiiɗo am na'on fukkii wuro, yanɗaa, faa juuɗe e koyɗe fu waatii, oo naawee sanne!» ");
INSERT INTO fue_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yeesu wi'i mo: «Mi yahan, mi nyawta mo.» ");
INSERT INTO fue_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Amma hooreejo soogeeji on toontii, wi'i: «Joomiraawo, mi fotay naataa wuro am. Amma batu woliine woore tan, jaggiiɗo am yoofoto. ");
INSERT INTO fue_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Min e hoore am, mii woodi mawɓe ɓe ɗowtanii mi, min bo mii woodi ɗowtaniiɓe am. To mi wi'i, oo ɗo, ‟yahu”, o yahan. To mi wi'i, oo to, ‟war”, o waran. To mi wi'i, jaggiiɗo am, ‟waɗu nii”, o waɗan.» ");
INSERT INTO fue_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","No Yeesu nani ka, haaynaare nanŋi ɗum, wi'i tokkuɓe ɗum: «E gooŋa batanmi on, mi yi'ay iri goonɗinki kii ɗo dow goɗɗo, baa der Isira'iilaaɓe. ");
INSERT INTO fue_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Mii bata on, ɗuuɓɓe waran diga lettugal e gorgal. Ɓe jooɗodo e Iburahiima e Isiyaaku e Yaakuubu, ɓe nyaamda der Laamaare Alla. ");
INSERT INTO fue_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Amma laatiiɓe ɓiɓɓe Laamaare, faɗɗete yaasi, der niwre. Ton ɓe bullata, ɓe ƴakkontira nyiiƴe.» ");
INSERT INTO fue_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ɓaawo mum, Yeesu wi'i hooreejo soogeeji on: «Hootu! Ɗum laatanee hande no goonɗinirɗaa.» Wakkati mum, jaggiiɗo makko yoofii. ");
INSERT INTO fue_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yeesu yahi wuro Piyer. O tawi esiraawo Piyer debbo e fukkii, e yontaa. ");
INSERT INTO fue_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yeesu meemi junŋo makko, yontere nen acci mo. Den o ummii, oo jagganoo ɓe. ");
INSERT INTO fue_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","No kiikiiɗe waɗi, Yeesu waddanaa himɓe ɗuuɓɓe, ɓe ginnaaji woni e mum. O riiwi ɗi e haala makko, o nyawti nyawɓe fu. ");
INSERT INTO fue_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Hande non haala annabaaku Esaaya hebbiri, ka o wi'i: «O jaɓii roonaago tampe meeɗen, o nyawtii nyawuuji meeɗen.» ");
INSERT INTO fue_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yeesu yi'i jama'aare ɗuunne e huuritii ɗum, o wi'i aahiiɓe makko ɓe jola fonŋo far to. ");
INSERT INTO fue_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ɗon Moodibbo tawreeta gom ɓattii mo, wi'i: «Moodibbo, mi tokkete to jahataa fu.» ");
INSERT INTO fue_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yeesu wi'i mo: «Dondonɗehon e woodi gayɗe, pooli bo e woodi daɗɗa mum, amma Ɓii neɗɗo woodaa to fukkinta hoore mum gam siwtoo.» ");
INSERT INTO fue_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Goɗɗo diga caka aahiiɓe wi'i mo: «Joomiraawo, accu mi yaha, mi uwaa baaba am taw.» ");
INSERT INTO fue_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yeesu toontii mo, wi'i: «Tokkam, accu maayɓe uwa maayɓe mum.» ");
INSERT INTO fue_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yeesu naati der laana diyam, go aahiiɓe makko e tokki mo. ");
INSERT INTO fue_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ɗon maa ɗon, hennu mawkol ummii e wifa dow maayo. Ŋol wifi, faa galmaaji diyam e yiɗi mutina ŋa. Amma Yeesu e ɗaani. ");
INSERT INTO fue_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Aahiiɓe ɓattii mo, finnini mo, wi'i: «Joomiraawo, faaba men! Men na'on kalka!» ");
INSERT INTO fue_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","O toontii ɓe, o wi'i: «Gam ume ko kuluɗon? Onon ɓe goonɗinki paanɗuki!» Den, o ummii, o falmi hennu e maayo. Ɗum yeewi siriw! ");
INSERT INTO fue_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ɓe fu, haaynaare nanŋi ɓe, ɓee bi'a: «Iri moy nun oo ɗo, faa hennu e maayo e ɗowtanoo mo?» ");
INSERT INTO fue_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yeesu joli fonŋo maayo, yottii der leydi Gadarena. Ɗon worɓe ɗiɗo wooduɓe ginnaaji wurtii e caabeeje, fotti e makko. Ɓee kunnii puy, faa goɗɗo suusataa ko tokki laawol ŋol. ");
INSERT INTO fue_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ɓe darii ɓee bata e semme, ɓee bi'a: «An Ɓiɗɗo Alla, ume jiɗuɗaa waɗugo men? A warii ɗo gam tooraa men diga wakkati waɗay na?» ");
INSERT INTO fue_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Fotii darne afaaji mawne gom e durannoo takkol ɗon. ");
INSERT INTO fue_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ginnaaji ɗin eeli Yeesu, wi'i: «To a riiwii men, accu men naataa der darne afaaji nee ɗo.» ");
INSERT INTO fue_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","O wi'i ɓe: «Jahee!» Ginnaaji ɗin wurtii, naatoy der afaaji ɗin. Ɗon maa ɗon, darne afaaji nen fu diirtii diga takkol waanne, simmitii der maayo, yoolii e diyam. ");
INSERT INTO fue_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Durooɓe afaaji ɗin doggi, hooti wuro. Ɓe batoy ko waɗi fu, e ko waɗi wooduɓe ginnaaji ɗiɗo ɓen. ");
INSERT INTO fue_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Den, himɓe siire nen fu wurtoy fotti e Yeesu. No ɓe ji'i mo, ɓe eeli mo o wurtoo leydi maɓɓe. ");
INSERT INTO fue_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yeesu naati laana diyam, joli, witti der siire mum. ");
INSERT INTO fue_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Himɓe waddani mo moofo, pukkinaaɗo dow daago. No Yeesu yi'i goonɗinki maɓɓe, wi'i moofo on: «Suka am, tiiɗin ɓerne maa! Hakkeeji maa yaafaama!» ");
INSERT INTO fue_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Den, moodiɓɓe tawreeta woɓɓe yanti e miila der ɓerɗe mum, e wi'a: «Gorko oo ɗo e bata kalluka dow Alla!» ");
INSERT INTO fue_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yeesu e anni miilooji maɓɓe, o wi'i ɓe: «Gam ume go oon miila miilooji kalluɗi ɗii der ɓerɗe mooɗon? ");
INSERT INTO fue_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ume ɓuri hoyugo? wi'ugo: ‟Hakkeeji maa yaafaama,” naa wi'ugo: ‟Umma yahu?” ");
INSERT INTO fue_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Amma, mii yiɗi paamon, no Ɓii neɗɗo e woodi baawɗe yaafaago hakke der duuniyaaru ɗo.» Den, o wi'i moofo on: «Umma, ettu daago maa, hootu wuro maa!» ");
INSERT INTO fue_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","O ummii, o hooti wuro makko. ");
INSERT INTO fue_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","No jama'aare yi'i ɗum, huli, darii e teddina Alla gam o hokki himɓe baawɗe hande ɗee. ");
INSERT INTO fue_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yeesu e yawta, diga e laawol o yi'i gorko bi'eteeɗo Matiye e jooɗii to ceede faada yoɓetee, o wi'i mo: «Tokkam.» Matiye ummii, tokki mo. ");
INSERT INTO fue_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ɓaawo mum, Yeesu yahi e nyaama der wuro Matiye. Jaɓooɓe ceede faada ɗuuɓɓe, e waɗooɓe hakke wari jooɗii e nyaamida e Yeesu e aahiiɓe mum. ");
INSERT INTO fue_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","No Farisaaɓe yi'i ɗum, ɓe bi'i aahiiɓe makko: «Gam ume moodibbo mooɗon nyaamidinta e jaɓooɓe ceede faada, e waɗooɓe hakke?» ");
INSERT INTO fue_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yeesu nani ka, wi'i ɓe: «Yanɗuɓe haajaaka nyawtoowo, sey nyawɓe. ");
INSERT INTO fue_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Jahee ekkitee ko haala kaa ɗo yiɗi wi'ugo: ‟Yurmeene nun jiɗumi, sadakaaji bane.”» Gam mi waray noddugo foonnitiiɓe, amma hakkeeɓe. ");
INSERT INTO fue_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Den, aahiiɓe Yuhaana gaɗoowo batisi ɓattii Yeesu, ƴami mo, wi'i: «Ume waɗi minon e Farisaaɓe emen cuumoo, go aahiiɓe maa suumataako?» ");
INSERT INTO fue_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","O toontii ɓe, o wi'i: «Noddinaaɓe ɓangal waawan ko woni der biisere ɓerne to jommanjo gorko e wondi e maɓɓe na? Nyalaane waraan de jommanjo gorko on ettetee caka maɓɓe. Den ɓe cuumoyto. ");
INSERT INTO fue_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Walaa takkoowo lefol kesol dow wudere hiinne, gam lefol kesol fooɗan wudere hiinne, den cerkol mayre yaajan puy. ");
INSERT INTO fue_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Kade bo innabojam kesam loowataake der jollooji guri kiiɗɗi. To hinaa non, jollooji ɗin pusan, innabojam reƴƴitoo, jollooji ɗin bo halka. Amma innabojam kesam, sey loowee der jollooji guri kesi, gam ɗum fu ɗum daɗa.» ");
INSERT INTO fue_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Wakkati Yeesu woni e bata ɓe ka, ɗon hooreejo suudu waajorde gom yottii, jiccii yeeso makko, wi'i: «Ɓiyam debbo maayii, ɗum waɗii tifere. Amma war yowu junŋo maa dow makko, heɓa o wuura.» ");
INSERT INTO fue_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yeesu ummii e aahiiɓe mum, tokki mo. ");
INSERT INTO fue_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Den debbo gom, mo lefol mum salii ko haggii diga duuɓi sappo e ɗiɗi, ƴiwi ɓawɓawre Yeesu, meemi kommulol toggoore makko. ");
INSERT INTO fue_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Gam o miilii der ɓerne makko, o wi'i: «To mi heɓii meemumi baa kommulol toggoore makko, mi yoofoto.» ");
INSERT INTO fue_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yeesu yeeƴitii, yi'i mo, wi'i: «Suka am, tiiɗin ɓerne maa! Goonɗinki maa nyawtii ma.» Wakkatiire nen, debbo on yoofii. ");
INSERT INTO fue_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yeesu yottii wuro hooreejo waajorde on. O yi'i fuurooɓe puuraaɗi maayde e himɓe wullooɓe. ");
INSERT INTO fue_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","O wi'i ɓe: «Burtee diga ɗo. Suka on maayay, o ɗaani nun.» Ɓe darii ɓee jala mo. ");
INSERT INTO fue_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","No himɓe wurtinaa yaasi, o naati der suudu, o nanŋi junŋo suka debbo, go o ummii. ");
INSERT INTO fue_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Habaru majjum sankitii toy fu der leydi nin. ");
INSERT INTO fue_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","No Yeesu yawtata, wumuɓe ɗiɗo tokki mo, e bata e daane towne, e wi'a: «Ɓii Dawda, yurma men!» ");
INSERT INTO fue_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","No o naati suudu, wumuɓe ɓen ɓattii mo, o wi'i ɓe: «Oon goonɗini mi waawan ko waɗi ɗum na?» Ɓe toontii mo, ɓe bi'i: «Oo, Joomiraawo, emen goonɗini.» ");
INSERT INTO fue_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Den, o meemi gite maɓɓe, o wi'i: «Ɗum laatanoo on hande no goonɗinirɗon.» ");
INSERT INTO fue_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Den ɓe bumti. O waggini ɓe, o wi'i: «To on batee ka baa goɗɗo.» ");
INSERT INTO fue_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Amma no ɓe burtii, ɓe jahi ɓee cankita habaru makko der leydi nin fu. ");
INSERT INTO fue_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","No wuntinaaɓe ɓen wurtotoo, Yeesu waddanaa gorko mo ginnool muumiɗini. ");
INSERT INTO fue_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","O riiwi ginnool ŋol, muumo on yanti e bata. Jama'aare fu haayɗinii, e wi'a: «Iri ɗum ɗo meeɗay ko yi'aa der Isira'iila!» ");
INSERT INTO fue_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Amma Farisaaɓe wi'i: «E baawɗe hooreejo ginnaaji nun o riiwirta ginnaaji!» ");
INSERT INTO fue_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yeesu e woositoo der genneele mawɗe, e ci'on petton fu. Oo janŋina der cuuɗi baajorɗi, oo fiina linjiila Laamaare Alla, oo nyawta nyawɓe nyawneeji feere feere fu. ");
INSERT INTO fue_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","No o yi'i jama'aare, ɓe jurminii mo, gam ɓe comii, ɓe tampi, ɓee laatii hande baali ɗi galaa duroowo. ");
INSERT INTO fue_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Den, o wi'i aahiiɓe makko: «Ko ruggetee e ɗuuɗi, amma ruggooɓe ɗuuɗaa. ");
INSERT INTO fue_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Eelee Joomiraawo dugge lildaa ruggooɓe der to ruggantee.» ");
INSERT INTO fue_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yeesu noddi aahiiɓe mum sappo e ɗiɗo. O hokki ɓe baawɗe riiwugo ginnaaji e nyawtugo nyawɓe nyawuuji feere feere fu. ");
INSERT INTO fue_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Inɗe lilaaɓe sappo e ɗiɗo ɓen woni: Simon noddeteeɗo Piyer, e minyum Andere. Yaakuuba ɓii Jebede, e minyum Yuhaana. ");
INSERT INTO fue_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filippu e Bartolome, Toma e Matiye jaɓoowo ceede faada. Yaakuuba ɓii Alfee, e Taddee. ");
INSERT INTO fue_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon tinniiɗo gam Alla, e Yahuuda Iskariyot, jammoytooɗo Yeesu. ");
INSERT INTO fue_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yeesu lili aahiiɓe mum sappo e ɗiɗo, bati ɓe haalaaji ɗii ɗo, wi'i: «To on jahee to heeferɓe, to on naatee bo der siire Samariyaaɓe. ");
INSERT INTO fue_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Amma jahee, caka Isira'iilaaɓe, laatiiɓe hande baali majjuɗi. ");
INSERT INTO fue_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","To jahuɗon fu, piinee, bi'on: ‟Laamaare Alla ɓattike!” ");
INSERT INTO fue_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Nyawtee nyawɓe, pintinee maayɓe, joofinee sesseɓɓe, diiwee ginnaaji. On keɓii on joɓay, onon bo kokkee to on jaɓee goɗɗum. ");
INSERT INTO fue_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","To on jaaree kanŋeeri, ɗum bo cardi, maa bo ceede der jiibaaji mooɗon. ");
INSERT INTO fue_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","To on jogee bogooru, ɗum bo toggooje ɗiɗi. To on ettee paɗe, ɗum bo sawru. Gam gollotooɗo e haani nyaama. ");
INSERT INTO fue_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","To on garii der genni, ɗum bo siire gom, daartee beero geeto. Jooɗee to makko faa de jawtuɗon. ");
INSERT INTO fue_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","To oon naata der wuro, cannee tawaaɓe ɗon. ");
INSERT INTO fue_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","To wuro ŋon e haanani ɗum, jam mooɗon naata der maggo. Amma to ŋo haananaa ɗum, jam mooɗon wittana on. ");
INSERT INTO fue_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","To on jaɓaaka, on kettinanaaka bo, burtee ɗon, piɗɗon sollaare koyɗe mooɗon. ");
INSERT INTO fue_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","E gooŋa batanmi on: ‟Nyalaane darŋal, kiita Sodoma e Gomora ɓuran hoyugo dow kiita siire nen.”» ");
INSERT INTO fue_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","«Kettinee! Mii lila on hande baali caka bu'i. To non, laatee ƴoƴuɓe hande bolle, laatoɗon ɓe walaa gacce hande tantabaraaji. ");
INSERT INTO fue_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Kakkilanee ko'e mooɗon e himɓe, gam ɓe jaaran on yeeso kiitorɗe, ɓe piya on looci der cuuɗi maɓɓe baajorɗi. ");
INSERT INTO fue_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ɓe jaaran on yeeso mawɓe leydi, e laamiiɓe genni, sabbu am. On laatanto am seedeeɓe yeeso maɓɓe, e yeeso heeferɓe. ");
INSERT INTO fue_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","To on jaaraama yeeso hiitotooɓe, to on miilee no batiroyton e ka batoyton. Gam on kokkete ka batoyton wakkati mum. ");
INSERT INTO fue_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Onon bane batata, Ruuhu Baaba mooɗon nun batata diga e mooɗon. ");
INSERT INTO fue_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Mawniraawo ummanto miiraawo, acca o waree. Baaba bo waɗanan ɗum ɓiɓɓe mum. Ɓiɓɓe bo ummanto saareeji mum, waɗa dabare gam ɓe baree. ");
INSERT INTO fue_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Himɓe fu wanyan on gam am. Amma munyuɗo faa heennyitirde, joomum hisinte. ");
INSERT INTO fue_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","To on tooraama e genni nii ɗo, doggiree nii to. E gooŋa batanmi on, on keenyataa woositaago genneele Isira'iila, go Ɓii neɗɗo wara. ");
INSERT INTO fue_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Aahiijo ɓurataa moodibbo mum, maccuɗo ɓurataa joomiraawo mum. ");
INSERT INTO fue_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","E wooɗi aahiijo laatoo hande moodibbo mum, maccuɗo bo, hande joomiraawo mum. To hooreejo wuro noddaama ‟Beljebul” hakko himɓe wuro makko!» ");
INSERT INTO fue_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","«To on kulee himɓe. Ko suuɗii fu wurtitinto, asiiri bo suppitinto. ");
INSERT INTO fue_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ka batumi on der niwre, batitee ka caka nyalooma. Ka bataɗon e noppi der asiiri, piinee ka dow doomooɗe cuuɗi. ");
INSERT INTO fue_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","To on kulee warooɓe ɓannu, ɓe baawataa ko wari yonki. Amma, kulee baawoowo ko halki ɓannu e yonki fu der yiite jahannama. ");
INSERT INTO fue_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Colon ɗiɗon sippataake faranwel gootel na? Amma baa gootel makkon yanataa e leydi, to e sago Baaba mooɗon bane. ");
INSERT INTO fue_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Onon, baa gaasaaji ko'e mooɗon fu e limaa. ");
INSERT INTO fue_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Gam majjum, to on kulee, gam oon ɓuri colon ɗuukkon tedduŋal. ");
INSERT INTO fue_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Ceedaniiɗo am yeeso himɓe, min bo, mi seedanto joomum yeeso Baaba am gonuɗo dow kammu. ");
INSERT INTO fue_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Amma caliiɗo am yeeso himɓe fu, min bo, mi saloto joomum yeeso Baaba am gonuɗo dow kammu.» ");
INSERT INTO fue_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","«To on miilee jam nun gaddumi e duuniyaaru. Mi waray gam mi wadda jam, amma kaafahi gaddumi. ");
INSERT INTO fue_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ko waddimmi woni, seennugo ɓiɗɗo gorko e baaba mum, ɓiɗɗo debbo bo e inna mum, debbo ɓaŋaaɗo e esum debbo. ");
INSERT INTO fue_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Neɗɗo fu, himɓe wuro mum nun laatotoo wayɓe mum.» ");
INSERT INTO fue_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","«Jiɗuɗo baaba mum, ɗum bo inna mum faa ɓurinimmi, joomum fotay laataago mo am. Jiɗuɗo ɓiɗɗo mum gorko naa bo debbo, faa ɓurinimmi, joomum fotay laataago mo am. ");
INSERT INTO fue_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Mo ettay leggal mum palaaŋal tokkimmi, joomum fotay laataago mo am. ");
INSERT INTO fue_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Jiɗuɗo hisina yonki mum, dullan ki, amma majjinɗo yonki mum gam am, heɓitinto ki.» ");
INSERT INTO fue_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","«Jaɓɓiiɗo on fu, jaɓɓike am, jaɓɓiiɗo am bo jaɓɓike liloyɗo am. ");
INSERT INTO fue_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Jaɓɓiiɗo annabiijo gam oo annabiijo, joomum heɓan riiba ka annabiiɓe heɓata. Jaɓɓiiɗo neɗɗo poonnitiiɗo gam oo poonnitiiɗo, joomum heɓan riiba ka foonnitiiɓe heɓata. ");
INSERT INTO fue_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","E gooŋa batanmi on, kokkuɗo ɓurɗo faanɗugo caka aahiiɓe am, diyam peewɗam, baa der jarirgel gootel, gam oo aahiijo am, o dullataa riiba makko.» ");
INSERT INTO fue_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","No Yeesu heennyi waajaago aahiiɓe mum sappo e ɗiɗo waajuuji ɗii, o yawti diga ɗon. Den o yahi janŋinoygo e waajaago caka ci'e mawɗe, der weccoore nen. ");
INSERT INTO fue_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yuhaana gaɗoowo batisi e wonnoo der kasu, go o nani golle ɗe Almasiihu waɗata e batanee. Den o lili aahiiɓe makko, ");
INSERT INTO fue_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","yaha ƴamaa Yeesu, wi'a: «An woni kaanuɗo wara na, naa men keɗoo goɗɗo?» ");
INSERT INTO fue_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yeesu toontii ɓe, wi'i: «Jahee, batee Yuhaana ko nanuɗon e ko ji'uɗon fu: ");
INSERT INTO fue_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","wumuɓe e wunta, moofiɗinɓe e yaha, sesseɓɓe e nyawtee, pahiɗinɓe e nana, maayɓe e finta, talakaaɓe bo e waajee habaru Laamaare Alla. ");
INSERT INTO fue_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Barke laatanto mo mi laatanaaki daliila fergere dow goonɗinki mum.» ");
INSERT INTO fue_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","No lilaaɓe ɓen yawti, Yeesu fuɗɗi batugo jama'aare haala Yuhaana, o wi'i: «Ume jahuɗon daaroygo der haro? Kuɗool ŋol hennu dimmata na? ");
INSERT INTO fue_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Naa ume daaroyɗon? Gorko ɓorniiɗo gineeji booɗuɗi na? Ɓorniiɓe gineeji booɗuɗi, der wuro laamiiɓe nun tawetee. ");
INSERT INTO fue_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Den, ume jahuɗon daaroygo? Annabiijo na? Oo! Mii bata on, oo ɓuri annabiijo. ");
INSERT INTO fue_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Kanko nun Dewte batani wi'i: ‟Mi lilan lilaaɗo am yeeso maaɗa, o moƴƴinanee laawol.”» ");
INSERT INTO fue_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","«E gooŋa batanmi on, der ɓe rewɓe rimi fu, walaa ɓurɗo Yuhaana gaɗoowo batisi manŋu. Amma, ɓurɗo pettiɗingo der Laamaare Alla, e ɓuri Yuhaana manŋu.» ");
INSERT INTO fue_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Diga Yuhaana gaɗoowo batisi fuɗɗi waajaago faa jooni, himɓe e teetontira Laamaare Alla e catte. Sattuɓe bo teetata ne. ");
INSERT INTO fue_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Annabiiɓe, e dewte tawreeta fu, waɗii annabaaku dow Laamaare nen faa yottii wakkati Yuhaana gaɗoowo batisi. ");
INSERT INTO fue_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","To oon jiɗi koolee, Yuhaana woni annabi Eliya, kaanuɗo wara. ");
INSERT INTO fue_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Gooduɗo noppi fu, nana. ");
INSERT INTO fue_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Ume nun nanditiniranmi himɓe jaamanuuru nuu ɗo? Ɓee nandi e sukaaɓe jooɗiiɓe caka jayri to himɓe fijata, e huuɓa igooɓe mum, e wi'a: ");
INSERT INTO fue_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‟Men puuranii on puuraaɗi, on pijay, men jimanii on jimi bojji maayde, on cimaaki.” ");
INSERT INTO fue_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Gam no Yuhaana wari, o nyaamataa o yarataa, on bi'ii: ‟O ginnaajiijo nun.” ");
INSERT INTO fue_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ɓii neɗɗo warii, e nyaama, e yara. Den, himɓe wi'i: ‟O laati nun deereeruujo, e jaroowo bagi. Oo laatii bo beldiijo jaɓooɓe ceede faada, e waɗooɓe hakke hande maɓɓe.” Amma, hakkillo Alla e hollitoo der golle muuɗum.» ");
INSERT INTO fue_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ɓaawo majjum, Yeesu feli genneele ɗe o waɗi haaynaareeji ɗuuɗɗi der mum ko himɓe majje tuubay. O wi'i: ");
INSERT INTO fue_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","«Bone laatante, an Korajin! Bone laatante, an Baytisayda! Gam haaynaareeji gaɗaaɗi to mooɗon, to ɗi gaɗaanomaa der Tirus e Sidon, maa ɓe mootikeno dooni, ɓe ɓornii saakiho, ɓe kollitira no ɓe tuubii. ");
INSERT INTO fue_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Gam majjum, mii wi'a on: Nyalaane darŋal, kiita Tirus e Sidon hoyan e ka mooɗon. ");
INSERT INTO fue_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","An bo Kafarnahum, aa miili a towinte faa dow kammu na? Aawo! A leesinte faa der joonne maayɓe. Gam haaynaareeji gaɗaaɗi der maa, to ɗi gaɗaanomaa der Sodoma, maa siire nen na'onno faa hanne. ");
INSERT INTO fue_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Gam majjum, mii wi'a on: Nyalaane darŋal, kiita Sodoma hoyan e ka mooɗon.» ");
INSERT INTO fue_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Wakkati mum, Yeesu etti haala wi'i: «Mii yettee Baaba, Joomiraawo mo dow, e mo leydi. A suuɗii wooduɓe annal e hakkillo kujje ɗee, ko kollitinɗaa ɗe sukahon petton. ");
INSERT INTO fue_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","E gooŋa, mi yettii maa Baaba, gam non ɗum fottiran maa. ");
INSERT INTO fue_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Baaba am hokkii am huune fu der junŋo am. Walaa annuɗo Ɓiɗɗo to hinaa Baaba. Walaa annuɗo Baaba bo, to hinaa Ɓiɗɗo, e mo Ɓiɗɗo yiɗi hollitingo ɗum.» ");
INSERT INTO fue_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","«Garee to am on fu, onon somuɓe, e rooniiɓe doolle tedduɗe, mi hokkan on siwtaare. ");
INSERT INTO fue_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ɗowtanee am, accee mi janŋina on. Gam mii yeeɗɗi, mii ɗiggi, den yonkiiji mon heɓan siwtaare. ");
INSERT INTO fue_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Gam doongal am e huyfi, ko dooninanmi on bo teddaa.» ");
INSERT INTO fue_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Wakkati mum, Yeesu e aahiiɓe mum e falta caka gese alkamaari nyalaane siwteteene, go aahiiɓe makko rafo waɗi ɗum, yanti e wooca cammeeje e ƴakka. ");
INSERT INTO fue_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","No Farisaaɓe yi'i ɗum, wi'i mo: «Daaru, aahiiɓe maa e waɗa ko haanay waɗeego nyalaane siwteteene!» ");
INSERT INTO fue_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","O toontii ɓe, o wi'i: «E gooŋa on janŋay ko Dawda waɗi no rafo waɗi ɗum, e himɓe mum na? ");
INSERT INTO fue_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","O naati der suudu Alla, e himɓe makko, ɓe ƴakki peen cakkanaako Alla. Baa no kanko e himɓe makko ɓe goodaa laawol ƴakkugo ko. Limaamiiɓe tan nun woodi laawol ƴakkugo ko. ");
INSERT INTO fue_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Naa, on janŋay der tawreeta Muusa, no limaamiiɓe gollotooɓe der suudu Alla waɗiri ko haanaa der nyalaane siwteteene? Amma e nun fu ɓe gaccaaka. ");
INSERT INTO fue_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Mii wi'a on e gooŋa, ɓurɗo suudu Alla mawnugo nun woni ɗo. ");
INSERT INTO fue_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","To on paamiino ko haala Alla kaa ɗo fillitii: ‟Yurmeene jiɗumi, hinaa sadakaaji kiiseteeɗi”, on kiitataakono himɓe ɓe walaa gacce.» ");
INSERT INTO fue_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Gam Ɓii neɗɗo nun laatii Joomiraawo nyalaane siwteteene.» ");
INSERT INTO fue_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yeesu yawti diga ɗon, yahi der suudu waajorde maɓɓe. ");
INSERT INTO fue_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Gorko mo junŋo waatuŋo gom e tawaa ɗon, go tawaaɓe ɗon ƴami mo ƴanɗe ɗee ɗo, gam heɓa no gaccorii mo, wi'i: «Laawol hokkii nyawtiigu waɗee nyalaane siwteteene na?» ");
INSERT INTO fue_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","O toontii ɓe, o wi'i: «To goɗɗo mooɗon e woodi baalel mum, go nyalaane siwteteene ŋel yanti der ɓunnu, joomum suttoytaa ŋel na? ");
INSERT INTO fue_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Neɗɗo e ɓuri baala faa to woɗɗi! To non, laawol hokki ko wooɗi waɗee der nyalaane siwteteene.» ");
INSERT INTO fue_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Den, o wi'i gorko on: «Foortu junŋo maa!» O foorti ŋo, ŋo yoofii hande no ŋoo to. ");
INSERT INTO fue_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Farisaaɓe wurtii, yahi dawraa dow no ɓe kalkirta Yeesu. ");
INSERT INTO fue_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","No Yeesu nani ka, yawti diga nokkuure nen, himɓe ɗuuɓɓe e tokki mo. O nyawti nyawɓe fu. ");
INSERT INTO fue_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Den o waggini ɓe, to ɓe batu goɗɗo moy nun o laatii. ");
INSERT INTO fue_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ɗum laatike non gam haala annabi Esaaya hebba, ka o wi'i: ");
INSERT INTO fue_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","«Nani gollotooɗo am mo cuɓumi. Kanko woni jiɗaaɗo am, mo ceyoriimi. Mi jippinan Ruuhu am dow makko, o fiinan habaru foonnitaare dow lenyi fu. ");
INSERT INTO fue_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","O yeddontirtaa e goɗɗo, o falmataa goɗɗo, daane makko nanataake e laabi. ");
INSERT INTO fue_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","O heltataa ƴommal turiiŋal, o nyifataa fitilleel cuurtoowel, faa nyalaane o hokki foonnitaare jaalorgal. ");
INSERT INTO fue_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Lenyi fu yowan hoolaare mum dow makko.» ");
INSERT INTO fue_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Den, Yeesu waddanaa gorko bumɗo muumiɗinɗo, mo ginnool woni e mum. O nyawti mo faa muumo on e bata, e yi'a bo. ");
INSERT INTO fue_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Haynaare nanŋi himɓe fu, ko ɓee bi'a: «Hinaa kanko woni Ɓii Dawda na?» ");
INSERT INTO fue_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Amma no Farisaaɓe nani ka, yanti e wi'a: «E baawɗe ‟Beljebul” hooreejo ginnaaji nun o riiwirta ɗi.» ");
INSERT INTO fue_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","No Yeesu e anni miilooji maɓɓe, o wi'i ɓe: «Laamaare fu to seennirake e haɓa hoore mum, ne halkan. Ɗum bo to siire gom, maa bo wuro gom seennirii e haɓa hoore mum, ŋo wonataako. ");
INSERT INTO fue_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","To Seyɗan seennirake e riiwa Seyɗan, den noy laamaare makko wonortoo? ");
INSERT INTO fue_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","To laatike e baawɗe ‟Beljebul” nun diiwiranmi ginnaaji, ɓiɓɓe mooɗon bo na, e baawɗe moy ɓe diiwirta ɗi? Gam majjum, kamɓe e ko'e maɓɓe nun laatoytoo hiitotooɓe on! ");
INSERT INTO fue_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Amma to e Ruuhu Alla nun diiwiranmi ginnaaji, eɗum holla no Laamaare Alla warii faa to mooɗon. ");
INSERT INTO fue_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Naa moy waawata ko naati wuro gorko semmenteejo, teeta jawdi makko, to o haɓɓay joomum taw. Amma to o haɓɓii mo, o waawan ko wuuwi ko woni der wuro ŋon fu. ");
INSERT INTO fue_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Mo wonday e am fu, ganyo am nun. Mo wallay am hawritingo, sankitan nun. ");
INSERT INTO fue_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Gam majjum, mii wi'a on: himɓe heɓan yaafuye hakkeeji mum, e kalluka ka ɓe bati. Amma batuɗo kalluka dow Ruuhu Ceniiɗo, yaafataake pay. ");
INSERT INTO fue_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Batuɗo kalluka dow Ɓii neɗɗo fu, heɓan yaafeego. Amma batuɗo kalluka dow Ruuhu Ceniiɗo, yaafataake der jaamanuuru nuu ɗo, e der jaamanuuru warannu.» ");
INSERT INTO fue_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","«To leggal e wooɗi, ɓiɓɓe maggal bo wooɗan. To leggal wooɗaa, ɓiɓɓe maggal bo wooɗataa, gam leggal fu, diga e ɓiɓɓe mum nun annitirtee. ");
INSERT INTO fue_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ɓiɓɓe bolle pure! Noy baawirton batugo booɗuka, onon laatiiɓe halluɓe? Gam ko hebbi der ɓerne, kan nun hunnuko wurtinta. ");
INSERT INTO fue_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Neɗɗo geeto, wurtinan ko wooɗi diga booɗɗum ko suuɗii der ɓerne mum. Neɗɗo kalluɗo bo, wurtinan ko halli diga kalluɗum cuuɗiiɗum der ɓerne mum. ");
INSERT INTO fue_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","E gooŋa bi'anmi on: nyalaane darŋal himɓe toontoyto haalaaji baanji baanji ɗi ɓe bati fu. ");
INSERT INTO fue_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Gam moy fu, haala mum nun wurtinta ɗum, ɗum bo ka doƴƴa ɗum kiita.» ");
INSERT INTO fue_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ɓaawo majjum, woɓɓe der moodiɓɓe tawreeta e Farisaaɓe, wi'i Yeesu: «Moodibbo, emen jiɗi gaɗanaa men kaayeefi.» ");
INSERT INTO fue_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","O toontii ɓe, o wi'i: «Himɓe jaamanuuru hallunu, coɓuɓe, e daarta kaayeefi. Ɓe ji'ataa kaayeefi gom, to hinaa kaayeefi annabi Yonas. ");
INSERT INTO fue_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yonas waɗii nyaloomaaje tati e jemmaaje tati der reedu linŋol manŋol. Hande non bo Ɓii neɗɗo waɗirta nyaloomaaje tati e jemmaaje tati der leydi. ");
INSERT INTO fue_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Nyalaane darŋal, himɓe Niniwe ummodoto e himɓe jaamanuuru nuu ɗo, gaccoo ɓe. Gam ɓe tuubii no ɓe nani waaji Yonas. Nani bo, ɓuruɗo Yonas nun woni ɗo! ");
INSERT INTO fue_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Nyalaane darŋal, laamiiɗo debbo mo leydi hoore fuɗo ummodoto e himɓe jaamanuuru nuu ɗo, gaccoo ɓe. Gam o ƴiwoy diga kaddin leydi, o wari hettinaago haalaaji Suleymaanu kebbuɗi hakkillo. Nani bo, ɓuruɗo Suleymaanu nun woni ɗo!» ");
INSERT INTO fue_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","«To ginnool wurtike e neɗɗo, ŋol yahan ŋol yiilitoo nokkuuje joorɗe, eŋol daarta to ŋol siwtoto, amma ŋol heɓataa. ");
INSERT INTO fue_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Den ŋol wi'an: ‟Mi wittitinto wuro am ŋo eggunoomi e mum.” To ŋol yottike, ŋol tawan goɗɗo walaa der wuro ŋon, eŋo wuuwaa, eŋo moƴƴinaa faa wooɗi. ");
INSERT INTO fue_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Den, ŋol wittan, ŋol waddaa ginnaaji jeeɗiɗi goɗɗi ɓuruɗi ŋol hallugo. Ɗi naata e wuro ŋon, ɗi jooɗoo der maggo. Heennyitirde neɗɗo on ɓuran arandeere mum hallugo. Hande non ɗum laatantoo himɓe jaamanuuru hallunu nu.» ");
INSERT INTO fue_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Wakkati Yeesu baddata e jama'aare, inniiko e miiraaɓe makko yottii. Ɓe darii yaasi, ɓee jiɗi baddugo mo. ");
INSERT INTO fue_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Den, goɗɗo bati Yeesu, wi'i: «Inna maa e miiraaɓe maa e darii yaasi, e yiɗi baddugo maa.» ");
INSERT INTO fue_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","O toontii mo, o wi'i: «Moy woni inna am? Ɓey woni miiraaɓe am?» ");
INSERT INTO fue_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","O sappii aahiiɓe makko, o wi'i: «Inna am e miiraaɓe am nun ɗo. ");
INSERT INTO fue_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Miiraaɓe am worɓe e rewɓe, e inna am woni, waɗooɓe ko Baaba am gonuɗo dow kammu yiɗi.» ");
INSERT INTO fue_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Nyaanne mum, Yeesu wurtii wuro, yahi jooɗoy takkol maayo. ");
INSERT INTO fue_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Jama'aare ɗuunne e howii mo, o ummii o naati laana diyam, o jooɗii. Himɓe fu e darii takkol maayo. ");
INSERT INTO fue_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","O bati ɓe kujje ɗuuɗɗe e ballaaji. O wi'i ɓe: «Aawoowo nun wurtii aawoygo. ");
INSERT INTO fue_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","No o aawata, awdiiri gonni yani sera laawol, pooli wari soppi ni. ");
INSERT INTO fue_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Gonni bo yani e kaaƴe to leydi ɗuuɗaa, ni fuɗi ɗon maa ɗon, gam ni heɓay to leydi luggi. ");
INSERT INTO fue_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Amma no naaŋe nyawli, ŋe wuli ni. Ni yoori, gam ni walaa ɗaɗi. ");
INSERT INTO fue_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Gonni bo yani caka gi'e. Gi'e mawni, ɓiɗɗi ni. ");
INSERT INTO fue_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Gonni bo yani e leydi geeri, ni fuɗi, ni rimi ɓikkol: Gonni rimi gite hewre, gonni lasoy tati, gonni bo laso e sappo. ");
INSERT INTO fue_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Gooduɗo noppi fu nana!» ");
INSERT INTO fue_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Aahiiɓe Yeesu ɓattii, ƴami mo, wi'i: «Ume waɗi ko aa baddira himɓe e ballaaji?» ");
INSERT INTO fue_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","O toontii ɓe, o wi'i: «Onon, on kokkaama faamugo asiiri Laamaare Alla, amma kamɓe, ɓe keɓay ɗum. ");
INSERT INTO fue_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Gam gooduɗo nun ɓeydantee faa ɗuuɗa. Anni mo woodaa, baa seɗɗa ko woodi, teetete. ");
INSERT INTO fue_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Gam majjum, baddiranmi ɓe e ballaaji: ‟Gam ɓee daara, amma ɓe ji'ataa, Ɓee kettinoo, amma ɓe nanataa, ɓe paamataa bo.” ");
INSERT INTO fue_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Hande non ka Alla batunoo e hunnuko annabi Esaaya hebbiri dow maɓɓe: ‟On nanan faa wooɗa, amma on paamataa fuy, on daaran faa wooɗa, amma on ji'ataa fuy. ");
INSERT INTO fue_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Gam himɓe lenyol ŋol ɓerɗe mum laatike joorɗe. Ɓe cukkii noppi maɓɓe, ɓe muunnii gite maɓɓe, gam to ɓe ji'u to ɓe nanu e noppi maɓɓe, hakkillo maɓɓe bo to faamu, hakko ɓe tuuba, mi nyawta ɓe.” ");
INSERT INTO fue_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Amma onon, barke laatanike on, gam gite mooɗon e yi'a, noppi mooɗon bo e nana! ");
INSERT INTO fue_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","E gooŋa batanmi on, annabiiɓe ɗuuɓɓe, e foonnitiiɓe ɗuuɓɓe yiɗiino yi'a ko ji'oton, amma ɓe ji'ay. Ɓe jiɗiino ɓe nana ko nanoton, amma ɓe nanay.» ");
INSERT INTO fue_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","«Onon, kettinee ko ballool aawoowo ŋol fillitii. ");
INSERT INTO fue_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","To neɗɗo e hettinoo haala Laamaare Alla, go o faamataa ka, Kalluɗo nun suttata ka der ɓerne makko. Kanko nandi e awdiiri caamuni sera laawol. ");
INSERT INTO fue_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Goɗɗo e nandi e awdiiri caamuni to kaaƴe. Kanko to o nanii haala Alla, ɗon maa ɗon o jaɓa ka e seyo. ");
INSERT INTO fue_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Amma ka waɗataa ɗaɗi der makko, wakkati seɗɗa tan o wonoto. To ɓillaaje, ɗum bo tooraaji yottake gam haala kan, o woppa ka law. ");
INSERT INTO fue_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Goɗɗo e nandi e awdiiri caamuni to gi'e woni. To o nanii haala Alla, ɓillaaje duuniyaaru e yidde jawdi ɓiɗɗa ka, ka rimataa ɓikkol. ");
INSERT INTO fue_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Amma goɗɗo e nandi e awdiiri caamuni to leydi geeri. To o nanii haala Alla, o faama ka. Kanko o riman ɓikkon. Gokkon hewre, gokkon lasoy tati, gokkon bo laso e sappo.» ");
INSERT INTO fue_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yeesu waɗani ɓe kade ballool gonŋol, wi'i: «Laamaare Alla e nandi e gorko aawuɗo awdiiri geeri e gesa mum. ");
INSERT INTO fue_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","No himɓe fu ɗaani, ɗon ganyo makko wari, aawi fuɗo kalluko caka alkamaari nin, yawti. ");
INSERT INTO fue_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","No alkamaari fuɗi e sawtina, den fuɗo kalluko bo suppitii. ");
INSERT INTO fue_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Gollotooɓe jom gesa wari, wi'i mo: ‟Joomiraawo, awdiiri geeri bane aawuɗaa der gesa maa na? Diga toy fuɗo kalluko koo ɗo ƴiwi?” ");
INSERT INTO fue_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","O toontii ɓe, o wi'i: ‟Ganyo nun waɗi ɗum.» Den, gollotooɓe ɓen ƴami mo, wi'i: «Men jaha men ɗoofaa fuɗo kalluko kon na?” ");
INSERT INTO fue_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","O toontii ɓe, o wi'i: ‟Aawo, gam to oon ɗoofa fuɗo kalluko, on kawran e alkamaari. ");
INSERT INTO fue_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Accee ɗum mawnida faa wakkati dugge yottoo. To wakkati dugge yottake, mi wi'an ruggooɓe am ɗoofa fuɗo kalluko kon taw, haɓɓa ko, watta der yiite. Amma alkamaari, ɓe kawrita ɗum der beemal am.”» ");
INSERT INTO fue_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yeesu waɗani ɓe ballool gonŋol, wi'i: «Laamaare Alla e nandi e ɓinŋel mutaadihi, ŋel goɗɗo etti aawi der gesa mum. ");
INSERT INTO fue_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ɓinŋel mutaadihi ɓuri ɓikkol leɗɗe kara li'o fu faanɗugo. Amma to ŋel fuɗi, eŋel ɓura leɗɗe kara li'o mawnugo, ŋel laatoo leggal manŋal faa pooli waɗa daɗɗa mum dow licce maggal.» ");
INSERT INTO fue_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","O waɗani ɓe ballool gonŋol, o wi'i: «Laamaare Alla e nandi e ƴuufinirɗum, ɗum debbo etti hawrontiri e conni etorɗe tati, ko ni ƴuufini conni laawaani nin fu.» ");
INSERT INTO fue_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","E ballaaji nun Yeesu baddiri himɓe huune ɗum fu. O badday ɓe to hinaa e ballaaji. ");
INSERT INTO fue_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","O waɗii ɗum gam hebbingo haala ka annabiijo batunoo, wi'i: «Mi maɓɓitan hunnuko, mi bata e ballaaji, mi batan, mi wurtina kujje cuuɗinooɗe diga ko duuniyaaru tagaa.» ");
INSERT INTO fue_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ɓaawo majjum, Yeesu acci himɓe, hooti wuro. Aahiiɓe makko ɓattii, ƴami mo, wi'i: «Faantin men ballool fuɗo kalluko der gesa.» ");
INSERT INTO fue_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","O toontii ɓe, o wi'i: «Aawuɗo aawdi booɗuni woni Ɓii neɗɗo. ");
INSERT INTO fue_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Gesa ŋan woni duuniyaaru. Awdiiri geeri woni fotuɓe naata der Laamaare Alla, fuɗo kalluko woni, tokkuɓe Kalluɗo. ");
INSERT INTO fue_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ganyo aawuɗo fuɗo kalluko woni Ibiliisa, dugge laati nun nyalaane darŋal, ruggooɓe bo laatii malaykaaɓe. ");
INSERT INTO fue_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Hande no fuɗo kalluko ɗoofirtee wattee e yiite, hande non ɗum laatotoo nyalaane darŋal. ");
INSERT INTO fue_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ɓii neɗɗo lilan malaykaaɓe mum, wurtina doƴƴooɓe himɓe der hakke, e waɗooɓe ko halli der laamaare mum. ");
INSERT INTO fue_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","O faɗɗan ɓe der yiite jahannama, ton ɓe bullata, ɓe ƴakkontira nyiiƴe. ");
INSERT INTO fue_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Amma wakkati mum, foonnitiiɓe jalbitinto hande naaŋe der Laamaare Baaba mum. Gooduɗo noppi fu, nana!» ");
INSERT INTO fue_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","«Laamaare Alla e nandi e jawdi cuuɗiini der gesa. Goɗɗo hocciri ni, witti suuɗitii ni. Ɓerne makko weli puy, den o yahi o sippoy ko o woodi fu, gam o sooda gesa ŋan.» ");
INSERT INTO fue_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","«Faa hanne Laamaare Alla e nandi e tenkotooɗo daartoowo sokiyaaje dime. ");
INSERT INTO fue_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","No o yi'i sokiyaaje dime, o sippoy ko o woodi fu, o soodi ɗe.» ");
INSERT INTO fue_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","«Laamaare Alla e nandi kade e taaruwol paɗɗaaŋol der maayo, nanŋoy liƴƴi feere feereeji. ");
INSERT INTO fue_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","No ŋol hebbi, suuɓotooɓe fooɗi ŋol, wurtini far fonŋo, ɓe jooɗii ɓe cuɓitii ɗi. Ɓe gatti liƴƴi booɗɗi der killaaje, ɓe boppi ɗi nafataa goɗɗum. ");
INSERT INTO fue_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Hande non ɗum laatotoo nyaanne duuniyaaru timmata. Malaykaaɓe waran suttontira halluɓe e wooɗuɓe. ");
INSERT INTO fue_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ɓe paɗɗan halluɓe der yiite manŋe, ɓe bulla, ɓe ƴakkontira nyiiƴe.» ");
INSERT INTO fue_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yeesu ƴami ɓe, wi'i: «On paamii huune ɗum fu na?» Ɓe toontii, ɓe bi'i: «Oo, men paamii.» ");
INSERT INTO fue_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Den, o wi'i ɓe: «Moodibbo tawreeta paamuɗo haala Laamaare Alla, e nandi hande jom wuro, burtinoowo huune kesum e kiiɗɗum diga e jawdi mum.» ");
INSERT INTO fue_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","No Yeesu heennyi batugo e ballaaji, o yawti diga ɗon. ");
INSERT INTO fue_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","O witti genni makko to o mawni, oo waajoo der cuuɗi maɓɓe baajorɗi. Ko haaynaare nanŋi himɓe hettinaniiɓe mo, ɓee bi'a: «Toy o heɓi annal iri ŋal ɗo, e baawɗe waɗugo kaayeefiiji ɗii ɗo? ");
INSERT INTO fue_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","E gooŋa, kanko bane woni ɓii ceɓoowo leɗɗe on na? Inniiko bane wi'etee Mariyama na? Miiraaɓe makko bane Yaakuuba, e Yusufu, e Simon, e Yahuuda na? ");
INSERT INTO fue_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Enen e sakikiraaɓe makko rewɓe bane wondi ɗo na? Den, toy o heɓi ɗum ɗon fu?» ");
INSERT INTO fue_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ɗum haɗi ɓe goonɗingo mo. Gam majjum, o wi'i ɓe: «Annabiijo teddintaake der genni mum, e der wuro mum.» ");
INSERT INTO fue_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","O waɗay ɗon haaynaareeji ɗuuɗɗi gam ɓe goonɗinay mo. ");
INSERT INTO fue_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Wakkati majjum, Eroodu hooreejo leydi Galili nani Yeesu e batanee. ");
INSERT INTO fue_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","O wi'i jaggiiɓe makko: «Yuhaana gaɗoowo batisi nun! O fintii. Kanjum acci oo woodi baawɗe waɗugo kaayeefiiji.» ");
INSERT INTO fue_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Tawi Eroodu hokkiino laawol Yuhaana nanŋee, haɓɓee, wattee der kasu. O waɗii ɗum sabbu Erodiya, debbo mawniiko, Filippu. ");
INSERT INTO fue_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Gam Yuhaana wi'iino Eroodu: «Laawol hokkay maa koowaa mo.» ");
INSERT INTO fue_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Eroodu e yiɗuno warugo mo, amma oo hula himɓe, gam himɓe fu e goonɗini no Yuhaana laati nun annabiijo. ");
INSERT INTO fue_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","No nyalaane juulɗe dingol Eroodu yottii, ɓii Erodiya debbo naati e fija yeeso noddinaaɓe. Ɗum weli Eroodu puy. ");
INSERT INTO fue_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","O hunanii suka on, o hokkan ɗum huune ko ƴami fu. ");
INSERT INTO fue_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Suka debbo on gollori ka inna mum tintini ɗum, wi'i Eroodu: «Wattanam ɗo hoore Yuhaana gaɗoowo batisi der heeɗo!» ");
INSERT INTO fue_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ɓerne Eroodu biisi, amma, gam sabbu o hunike yeeso noddinaaɓe makko, o hokki hunnuko ne hokkee suka debbo on. ");
INSERT INTO fue_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","O lili goɗɗo yaha wudditaa hoore Yuhaana der kasu. ");
INSERT INTO fue_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Hoore nen waddaa der heeɗo, suka debbo on hokkaa. Kanko bo, o hokkoy inniiko. ");
INSERT INTO fue_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Aahiiɓe Yuhaana wari etti ɓannu makko, uwoy. Ɓaawo majjum, ɓe jahi ɓe batoy Yeesu ko waɗi. ");
INSERT INTO fue_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","No Yeesu nani habaru on, o solti kanko tan, o naati laana, o yahi nokkuure deƴƴune. Himɓe nani ka, wurtoy diga ci'e mum, tokki mo e koyɗe. ");
INSERT INTO fue_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","No o wurti e laana, o yi'i jama'aare ɗuunne, yurmeene maɓɓe waɗi mo, den o nyawti nyawɓe tawaaɓe ɗon. ");
INSERT INTO fue_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","No kiikiiɗe waɗi, aahiiɓe makko ɓattii mo, wi'i: «Kiikiiɗe waɗii, kade bo, e ladde nun gonuɗen ɗo. Accu himɓe ɓen yawta, yaha der ci'e, soodaa ko nyaamata.» ");
INSERT INTO fue_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yeesu toontii ɓe, wi'i: «Doole bane ɓe jawta. Onon e ko'e mooɗon, kokkee ɓe ko ɓe nyaamata!» ");
INSERT INTO fue_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ɓe toontii mo, ɓe bi'i: «Peen joyo, e liƴƴi ɗiɗi tan gooduɗen ɗo.» ");
INSERT INTO fue_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","O wi'i ɓe: «Gaddanee am ɗum ɗo.» ");
INSERT INTO fue_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","O hokki hunnuko himɓe jooɗinee dow fuɗo. Den o etti peen joyo kon, e liƴƴi ɗiɗi ɗin, o tiggitii, o yetti Alla. O ŋappiti peen kon, o hokki aahiiɓe makko seennana jama'aare. ");
INSERT INTO fue_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ɓe fu ɓe nyaami ɓe kaari. Aahiiɓe hawriti ko horii, ɗum hebbi killaaje sappo e ɗiɗi. ");
INSERT INTO fue_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Nyaamuɓe ɗum waɗii worɓe ujune joyo, rewɓe e sukaaɓe limaaka. ");
INSERT INTO fue_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ɗon maa ɗon, Yeesu dooli aahiiɓe mum naata laana, ardoo, jola fonŋo maayo. Wakkati mum, oo waynoo jama'aare. ");
INSERT INTO fue_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ɓaawo no o waynodii ɓe, o yawtiri dow waanne gam o waɗaa du'aare kanko tan. Foti kiikiiɗe waɗii, kanko tan bo woni ton. ");
INSERT INTO fue_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Tawi laana ŋan woɗɗake diga e fonŋo, ko galmaaji diyam e fiya ŋa, gam ŋa jaɓɓitinto nun hennu. ");
INSERT INTO fue_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","No faanii weetugo, Yeesu yottii to maɓɓe, e yaha dow maayo e koyɗe. ");
INSERT INTO fue_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","No aahiiɓe makko yi'i mo oo yaha dow diyam e koyɗe, kulol manŋol nanŋi ɓe, ɓe bi'i: «Beelu nun!» Ɓe darii ɓee kalɓa sabbu kulol. ");
INSERT INTO fue_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ɗon maa ɗon Yeesu wi'i ɓe: «Deƴƴitee! Min nun, to on kulee!» ");
INSERT INTO fue_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Piyer toontii mo, wi'i: «Joomiraawo, to an nun e gooŋa, accu mi yaha dow diyam, mi wara to maa.» ");
INSERT INTO fue_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","O toontii mo, o wi'i: «War!» Piyer wurtii laana, e yaha dow diyam, e foonnii to Yeesu. ");
INSERT INTO fue_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Amma no o yi'i hennu e satti, o huli, o fuɗɗi mutugo, den o halɓi, o wi'i: «Joomiraawo, faabam!» ");
INSERT INTO fue_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ɗon maa ɗon, Yeesu foorti junŋo mum, jogii mo, wi'i: «An mo goonɗinki paanɗuki, gam ume ko gaɗuɗaa seko?» ");
INSERT INTO fue_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ɓe fu ɗiɗo, ɓe naati laana, den, hennu darii. ");
INSERT INTO fue_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Tawaaɓe der laana ŋan fu, sujidani Yeesu, wi'i: «E gooŋa, a laati nun Ɓiɗɗo Alla!» ");
INSERT INTO fue_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ɓaawo no ɓe joli maayo, ɓe jottii leydi Genesaret. ");
INSERT INTO fue_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Himɓe tawaaɓe nokkuure nen anniti mo. Ɓe lildi habaru der leydi nin fu, no o wari, ɓe gaddani mo nyawɓe fu. ");
INSERT INTO fue_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ɓee eela mo o acca nyawɓe ɓen meema baa kommulol toggoore makko tan. Hande non bo, meemuɓe ŋol fu e yoofoo. ");
INSERT INTO fue_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Farisaaɓe e moodiɓɓe tawreeta ƴiwoy Urusaliima, wari to Yeesu, ƴami mo, wi'i: ");
INSERT INTO fue_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«Ume waɗi ko aahiiɓe maa e waylita tawaaŋal kaakiraaɓe meeɗen? Gam ɓe lootataa juuɗe maɓɓe go ɓe nyaama.» ");
INSERT INTO fue_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","O toontii ɓe, o wi'i: «Onon bo na, ume waɗi go oon baylita sariyaaji Alla no fottiranta tawaaŋal mooɗon? ");
INSERT INTO fue_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Gam Alla wi'i: ‟Teddin baaba maa e inna maa.” O wi'i kade: ‟Jennuɗo baaba mum, ɗum bo inna mum, joomum e haani waree.” ");
INSERT INTO fue_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Amma onon, oon bi'a, to neɗɗo wi'ii baaba mum, ɗum bo inna mum: ‟Ko haani mi wallitiree laatike geɗu Alla, den doole bane ballitaa baaba maa e inna maa.” ");
INSERT INTO fue_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Nun nun baylitirɗon haala Alla gam tawaaŋal mooɗon. ");
INSERT INTO fue_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Onon munaafitiiɓe! Esaaya waɗii annabaaku dow mooɗon, wi'i: ");
INSERT INTO fue_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‟Lenyol ŋol ɗo, e hunnuko tan nun teddinirtammi, amma ɓerɗe maɓɓe e woɗɗodii am. ");
INSERT INTO fue_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ɓee cujidanammi, amma ɗum nafataa gam ko ɓe janŋinta laati nun miilooji himɓe.”» ");
INSERT INTO fue_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Den, Yeesu noddi jama'aare, wi'i ɓe: «Kettinee, paamee faa wooɗa: ");
INSERT INTO fue_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ko naatata der hunnuko neɗɗo bane soɓinta mo. Amma ko wurtoto diga e hunnuko makko, kanjum soɓinta mo.» ");
INSERT INTO fue_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Go aahiiɓe makko ɓattii, wi'i mo: «Aa anni haala maaɗa kan mettinii ɓerɗe Farisaaɓe na?» ");
INSERT INTO fue_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","O toontii ɓe, o wi'i: «Aawre fu ne Baaba am gonuɗo dow kammu aaway, ne ɗoofete. ");
INSERT INTO fue_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Accee ɓe, wumuɓe ardiiɓe wumuɓe nun! To bumɗo e ardii bumɗo bannum, ɓe fu ɗiɗo, ɓe jantan der gayka.» ");
INSERT INTO fue_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Piyer toontii mo wi'i: «Faamin men haala kan.» ");
INSERT INTO fue_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yeesu wi'i mo: «Onon bo, faa jooni on galaa faamu na? ");
INSERT INTO fue_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","On paamay huune ko naati e hunnuko fu, der reedu ɗum pa'i, den ɗum wurtoo na? ");
INSERT INTO fue_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Amma ko wurtoto e hunnuko fu, der ɓerne ɗum ƴiwata, kanjum nun soɓinta neɗɗo. ");
INSERT INTO fue_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Gam diga der ɓerne neɗɗo nun miilooji kalluɗi ƴiwata. Den ɗi gatta mo barol himɓe, jeenu, kaaruwaaku, guyka, seedaago fewre, e batugo kalluka. ");
INSERT INTO fue_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ɗum ɗon nun woni ko soɓinta neɗɗo. Amma nyaamugo lootay juuɗe mum hande no tawaaŋal holliri soɓintaa neɗɗo.» ");
INSERT INTO fue_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ɓaawo majjum, Yeesu yawti diga ɗon yahi der jeyde Tirus e Sidon. ");
INSERT INTO fue_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Debbo Kananinkeejo, jeyaaɗo der leydi nin wari to makko, bati e daane towne, wi'i: «Joomiraawo, Ɓii Dawda, yurmam! Ginnool nun toorata ɓiyam debbo sanne!» ");
INSERT INTO fue_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Amma o toontaaki mo gokka. Ko aahiiɓe makko wi'i mo: «Riiwu mo, gam o accay halɓugo, oo tokkiri en.» ");
INSERT INTO fue_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yeesu toontii ɓe, wi'i: «Mi lilaaka maa to baali Isira'iila majjuɗi tan.» ");
INSERT INTO fue_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Amma debbo on wari jiccii yeeso makko, wi'i: «Joomiraawo, war wallam!» ");
INSERT INTO fue_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yeesu toontii mo, wi'i: «Ɗum wooɗaa nyaamdu sukaaɓe ettee, faɗɗanee dawaaɗi.» ");
INSERT INTO fue_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Debbo on wi'i: «Gooŋa nun Joomiraawo, amma dawaaɗi bo e suɓinoo nyaamdu caamoowol to joomiraaɓe mum nyaamata.» ");
INSERT INTO fue_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Den, Yeesu toontii mo, wi'i: «Hey debbo, goonɗinki maa e mawni! Ɗum laatanee hande no jiɗirɗaa.» E wakkati on, ɓiyiiko yoofii. ");
INSERT INTO fue_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yeesu yawti diga ɗon, witti takkol maayo Galili, eenci dow waanne, jooɗii ton. ");
INSERT INTO fue_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Himɓe ɗuuɓɓe wari to makko, ɓe gaddani mo laƴooɓe, e wumuɓe, e moofiɗinɓe, e muumiɗinɓe, e nyawɓe nyawuuji feere feere. Ɓe desi ɓe ley koyɗe Yeesu. ");
INSERT INTO fue_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Haynaare nanŋi himɓe, no ɓe ji'i muumiɗinɓe e bata, moofiɗinɓe e yoofoo, laƴooɓe e yaha deydey, wumuɓe bo e yi'a. Ɓe teddini Alla mo Isira'iila. ");
INSERT INTO fue_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yeesu noddi aahiiɓe mum, wi'i: «Himɓe ɓee e yurminoo am. Gam waɗii balɗe tati ɓee gondi e am, ɓe goodaa ko ɓe nyaamata. Mi yiɗaa bo riiwugo ɓe ɓe jawta e rafo, gam to rafo doƴƴu ɓe e laawol.» ");
INSERT INTO fue_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Aahiiɓe makko wi'i mo: «Toy keɓeten nyaamdu ko nyaannata jama'aare nee ɗo e ladde haro ɗo?» ");
INSERT INTO fue_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","O ƴami ɓe, o wi'i: «Peen noyo gooduɗon?» Ɓe toontii mo, ɓe bi'i: «Peen jeeɗiɗo e likkol pettol seɗɗa.» ");
INSERT INTO fue_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ɓaawo majjum, o hokki hunnuko jama'aare jooɗoo e leydi. ");
INSERT INTO fue_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","O etti peen jeeɗiɗo, e likkon seɗɗa kon. O yetti Alla, o ŋappiti, o hokki aahiiɓe makko, ɓe ceennani jama'aare. ");
INSERT INTO fue_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ɓe fu ɓe nyaami faa ɓe kaari. Ɓe kawriti ko horii, hebbi killaaje jeeɗiɗi. ");
INSERT INTO fue_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Nyaamuɓe ɗum waɗii worɓe ujune nayo, rewɓe e sukaaɓe limaaka. ");
INSERT INTO fue_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ɓaawo mum Yeesu waynii ɓe. Den, o naati laana, o yahi leydi Magadan. ");
INSERT INTO fue_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Farisaaɓe e Sadukiiɓe wari jarbaago Yeesu. Ɓe ƴami mo o waɗana ɓe kayniiɗum ƴiwuɗum diga kammu. ");
INSERT INTO fue_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","O toontii ɓe, o wi'i: «To on ji'ii dow kammu e wojji kiikiiɗe, oon bi'a: ‟Nokkuuje wooɗan.” ");
INSERT INTO fue_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Subaka bo, to on ji'ii kammu e wojji e niɓɓi, oon bi'a: ‟Diyam toɓan.” Oon anni suttontirgo ko waɗotoo dow kammu, amma on baaway suttontirgo maane wakkatiire nee ɗo! ");
INSERT INTO fue_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Himɓe jaamanuuru hallunu, coɓuɓe, e daarta kaayeefi. Ɓe ji'ataa kaayeefi gom, to hinaa kaayeefi Yonas.» Ɓaawo majjum, o acci ɓe, o yawti. ");
INSERT INTO fue_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","No aahiiɓe jolata fonŋo maayo far to, ɓe jeggiti ko etti peen. ");
INSERT INTO fue_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yeesu wi'i ɓe: «Kakkilee, deenee ko'e mon e ƴuufinirɗum Farisaaɓe e ɗum Sadukiiɓe.» ");
INSERT INTO fue_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Aahiiɓe darii e wi'ontira hakkune mum: «Gam en ettay peen acci oo bata ka.» ");
INSERT INTO fue_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yeesu anniti ka ɓe batata, wi'i ɓe: «Ko waɗi oon badda hakkune mon, oon batana dullere mooɗon jogaago peen? Onon ɓe goonɗinki paanɗuki! ");
INSERT INTO fue_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","E gooŋa faa jooni on paamay na? On ciwtoray peen joyo ko ceennanmi worɓe ujune joyo, e killaaje ɗe kebbinɗon ko horii na? ");
INSERT INTO fue_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","On ciwtoray bo peen jeeɗiɗo ko ceennanmi worɓe ujune nayo, e killaaje ɗe kebbinɗon ko horii na? ");
INSERT INTO fue_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Noy waɗi go on paamay no haala peen bane batananmi, wakkati bi'umi on, kakkilanee ƴuufinirɗum Farisaaɓe e ɗum Sadukiiɓe?» ");
INSERT INTO fue_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Den, ɓe paami no ƴuufinirɗum conni peen bane o batanta, amma, ekkitinol Farisaaɓe e ŋol Sadukiiɓe. ");
INSERT INTO fue_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yeesu yahii leydi Kaysariya Filippu. O ƴami aahiiɓe makko, o wi'i: «Moy himɓe wi'ata Ɓii neɗɗo e laatii?» ");
INSERT INTO fue_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ɓe toontii mo, ɓe bi'i: «Woɓɓe e wi'a, a laati nun Yuhaana gaɗoowo batisi. Woɓɓe e wi'a, an woni annabi Eliya. Woɓɓe kade e wi'a, an woni annabi Yeremiya, to ɗum bo gooto der annabiiɓe.» ");
INSERT INTO fue_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yeesu ƴami ɓe, onon bo na: «Moy bi'oton mii laatii?» ");
INSERT INTO fue_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simon Piyer toontii mo, wi'i: «An woni Almasiihu, Ɓiɗɗo Alla yonkinteejo.» ");
INSERT INTO fue_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Den Yeesu ettitii haala wi'i mo: «Barke laatanii maa, an Simon ɓii Yonas. Gam neɗɗo bane hollitin maa ɗum, amma Baaba am gonuɗo dow kammu hollitin maa ɗum. ");
INSERT INTO fue_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Min bo, mii wi'ee, an woni Piyer, waato hayre. Dow hayre nen mahanmi Eklesiya am, baa joonne maayɓe waawataa ko jaalii ka. ");
INSERT INTO fue_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Mi hokkete maɓɓitirgel Laamaare Alla. Ko caliɗaa e leydi ɗo, salaama dow kammu. Ko jaɓuɗaa e leydi ɗo bo, jaɓaama dow kammu.» ");
INSERT INTO fue_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Den, Yeesu waggini aahiiɓe mum, e semme, wi'i to ɓe batu goɗɗo, no kanko nun woni Almasiihu. ");
INSERT INTO fue_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Diga wakkati mum, Yeesu fuɗɗi faamingo aahiiɓe mum wi'i e haani o yaha Urusaliima. Ton dottiiɓe e limaamiiɓe, e moodiɓɓe tawreeta tooroyta mo puy, ɓe bara mo. Amma nyalaane tatawre, o fintan. ");
INSERT INTO fue_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Den, Piyer yaari mo sera, wooltani mo wi'i: «Joomiraawo, Alla haɗu ɗum! Iri majjum tawataa maa!» ");
INSERT INTO fue_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yeesu yeeƴitii, wi'i Piyer: «An Seyɗan, wittu ɓaawo am! A laati nun ko doƴƴatammi. Miilooji maa ƴiway to Alla, to himɓe ɗi ƴiwi!» ");
INSERT INTO fue_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Den Yeesu wi'i aahiiɓe mum: «Jiɗuɗo tokkugo am fu, acca miijaanaago hoore mum, etta leggal mum palaaŋal, tokkammi. ");
INSERT INTO fue_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Gam jiɗɗo hisingo yonki mum, dullan ki. Amma, majjinɗo yonki mum gam am, hisinan ki. ");
INSERT INTO fue_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","To neɗɗo heɓii huune fu der duuniyaaru ɗo, ko yonki mum halki, ume ɗum nafi mo? Naa ume neɗɗo waawata ko hokki gam sooditaago yonki mum? ");
INSERT INTO fue_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Gam Ɓii neɗɗo waran e tedduŋal Baaba mum, e malaykaaɓe mum. Den o yoɓan moy fu ko waɗi der golle mum. ");
INSERT INTO fue_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","E gooŋa batanmi on, tawaaɓe ɗo, woɓɓe mum maayataa, ko ɓe ji'a Ɓii neɗɗo e warida e laamaare mum.» ");
INSERT INTO fue_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ɓaawo balɗe jeego'o, Yeesu yahidi e Piyer e Yaakuuba e minyum Yuhaana. O yaari ɓe sera, faa dow waanne towune. ");
INSERT INTO fue_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Tagudi makko waylitii yeeso maɓɓe. Yeeso makko e jalba hande naaŋe, gineeji makko rawni tar hande jayŋol. ");
INSERT INTO fue_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Muusa e Eliya suppitanii ɓe, e badda e makko. ");
INSERT INTO fue_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Piyer etti haala wi'i Yeesu: «Joomiraawo, wonaago men ɗo e wooɗi. To aa yiɗi, mi darnan ɗo bukaaji tati: an wooru, Muusa wooru, Eliya wooru.» ");
INSERT INTO fue_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","O heennyay batugo, ko duulel jalboowel gom wari ommi ɓe. Ɗon daane gom ƴiwi der duulel ŋel, wi'i: «Oo ɗo laatii Ɓiɗɗo am jiɗaaɗo, mo cuɓumi. Kettinanee mo!» ");
INSERT INTO fue_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","No aahiiɓe nani daane nen, ɓe jani, ɓe kippii e leydi, ɓe kuli sanne. ");
INSERT INTO fue_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yeesu ɓattii, meemi ɓe, wi'i: «Ummee, to on kulee.» ");
INSERT INTO fue_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Den, ɓe ɓanti gite, ɓe ji'ay goɗɗo, sey Yeesu tan. ");
INSERT INTO fue_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","No ɓe jippotoo diga dow waanne nen, Yeesu waggini ɓe, wi'i: «To on batee goɗɗo ko ji'uɗon, faa to Ɓii neɗɗo fintii diga e maayɓe.» ");
INSERT INTO fue_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Den, aahiiɓe makko ƴami mo, wi'i: «Gam ume ko moodiɓɓe tawreeta e wi'a: ‟Eliya nun artata wara”?» ");
INSERT INTO fue_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","O toontii ɓe, o wi'i: «Gooŋa nun, Eliya nun artata wara, moƴƴina huune fu. ");
INSERT INTO fue_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Amma mii wi'a on, Eliya wari ko. Amma ɓe annitay mo, ɓe gaɗanii mo ko ɓe jiɗi fu. Hande non ɓe toorirta Ɓii neɗɗo bo.» ");
INSERT INTO fue_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Aahiiɓe faami no haala Yuhaana gaɗoowo batisi nun o batanta ɓe. ");
INSERT INTO fue_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","No ɓe bittoy to jama'aare woni, gorko gom wari jiccii yeeso Yeesu. ");
INSERT INTO fue_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","O wi'i: «Joomiraawo, yurma ɓiyam gorko! Ginnool nun woni e makko, eŋol toora mo puy. To ŋol ummanake mo, eŋol doƴƴa mo der yiite, nokkun bo der diyam. ");
INSERT INTO fue_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Mi yaarii mo to aahiiɓe maa, amma ɓe baaway ko nyawti mo.» ");
INSERT INTO fue_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yeesu toontii, wi'i: «Hey, onon himɓe jaamanuuru hallunu, ɓe walaa goonɗinki! Faa dey gondanmi e mooɗon? Faa dey tokkanmi munyango on? Gaddanee am mo ɗo!» ");
INSERT INTO fue_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yeesu falmi ginnool tawaaŋol der suka on, ŋol wurtii, o yoofii ɗon maa ɗon. ");
INSERT INTO fue_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ɓaawo majjum, aahiiɓe makko ƴami mo kamɓe tan, wi'i: «Ume acci men baaway ko riiwi ginnool ŋol?» ");
INSERT INTO fue_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yeesu toontii ɓe, wi'i: «Gam goonɗinki mooɗon e faanɗi. E gooŋa batanmi on: To goonɗinki mooɗon e foti baa hande ɓinŋel mutaadihi, on baawan ko wi'i waanne nee ɗo: ‟Eggu ɗo, jahaa to,” ne eggan bo. Walaa ko tampoton waɗugo. ");
INSERT INTO fue_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Amma, ginnool hande ŋol ɗo wurtataako to hinaa e du'aare, e suumaye.» ");
INSERT INTO fue_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","No ɓe boositintoo der leydi Galili, den Yeesu wi'i ɓe: «Ɓii neɗɗo wattete der juuɗe himɓe. ");
INSERT INTO fue_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ɓe baran mo, amma nyalaane tatawre o fintan.» Ɓerɗe aahiiɓe makko biisii puy, no ɓe nani ka. ");
INSERT INTO fue_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","No Yeesu e aahiiɓe mum yottii Kafarnahum, jaɓooɓe ceede faada suudu Alla ɓattii Piyer, wi'i mo: «Moodibbo mooɗon yoɓataa woni ceede faada suudu Alla?» ");
INSERT INTO fue_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Piyer toontii, wi'i: «Oo yoɓa.» No Piyer naati der wuro, Yeesu arti etti haala, wi'i: «Simon, ume miiluɗaa? Ɓey nun haani yoɓa ceede faada? Ɓiɓɓe genni nun naa hoɓɓe?» ");
INSERT INTO fue_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Piyer toontii, wi'i: «Hoɓɓe nun haani yoɓa.» Yeesu wi'i mo: «Den, ɓiɓɓe genni haanay yoɓa. ");
INSERT INTO fue_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Amma, gam to en laatana himɓe fergere, yahu maayo. Tuunnu malimali maa, pitoɗaa linŋol ŋol artuɗaa nanŋuɗaa. Den ŋaaɓaa hunnuko maggol, a tawan ceede cardi der ɗon. Ikkinaa ɗe, joɓanaa en, min e maa.» ");
INSERT INTO fue_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Wakkati majjum, aahiiɓe Yeesu ɓattii, ƴami mo, wi'i: «Moy ɓuri manŋu der Laamaare Alla?» ");
INSERT INTO fue_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yeesu noddi sukayel, darni ŋel yeeso maɓɓe, ");
INSERT INTO fue_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","wi'i: «E gooŋa batanmi on: to on baylitaaki laatiɗon hande sukahon petton, on naatoytaa der Laamaare Alla. ");
INSERT INTO fue_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Gam majjum, leesinɗo hoore mum, hande sukayel ŋel ɗo, kanko nun ɓurata manŋu der Laamaare Alla. ");
INSERT INTO fue_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Jaɓɓiiɗo sukayel pettel hande ŋel ɗo, e inne am, min nun joomum jaɓɓii.» ");
INSERT INTO fue_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","«Amma to goɗɗo doƴƴii sukahon petton, goonɗinkon am, gooten mum der hakke, ɗum ɓuranno hoyango mo, o haɓɓanee namarde e daane, o faɗɗee caka maayo. ");
INSERT INTO fue_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Bone laatanii duuniyaaru nuu, gam woodi ko doƴƴata himɓe der hakke. Waɗataako ko doƴƴata himɓe waray, amma bone laatanto laatiiɗo daliila majjum! ");
INSERT INTO fue_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","To junŋo maa, ɗum bo koyŋal maa nun waɗinte hakke, wudditin ɗe boppaa to woɗɗi. Ɗum ɓurante wooɗugo, naataa aljanna e koyŋal gootal, ɗum bo e junŋo wooto, e no paɗɗirteɗaa e koyɗe maa ɗiɗi, ɗum bo e juuɗe maa ɗiɗi der yiite tabitiiŋe. ");
INSERT INTO fue_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","To bo itere maa nun waɗintee hakke, ɗoofu ne boppaa to woɗɗi. Ɗum ɓurante hoyugo naataa aljanna e itere woore, e no paɗɗirteɗaa e gite maa ɗiɗi der yiite jahannama.» ");
INSERT INTO fue_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","«Kakkilee, to on jawee baa gooten der sukahon petton kon. Gam mii wi'a on, malaykaaɓe makkon, e darii wakkati fu, dow kammu e daara yeeso Baaba am gonuɗo dow kammu.  ");
INSERT INTO fue_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Gam Ɓii neɗɗo warii hisingo majjuɓe. ");
INSERT INTO fue_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Kaye miiluɗon? To neɗɗo e woodi baali hewre, go baala goota majji, o accataa lasooji naay e sappo e jeenay koriiɗi dow waanne, o daartaa majjuŋa ŋan na? ");
INSERT INTO fue_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","E gooŋa batanmi on: to o yiitii ŋa, o seyorto ŋa ɓura lasooji naay e sappo e jeenay koriiɗi, ɗi majjay. ");
INSERT INTO fue_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Hande non Baaba mooɗon gonuɗo dow kammu yiɗaa baa gooto, der sukahon kon, majja.» ");
INSERT INTO fue_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","«To banniraawo maa woofanii maa, yahu to makko an tan, kollaa mo onon ɗiɗo. To o nootike, a heɓitake mo. ");
INSERT INTO fue_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Amma to o hettinaaki ka kollataa mo, den wittu, jahidaa e neɗɗo gooto, ɗum bo ɗiɗo, gam haala kan moƴƴinee yeeso seedeeɓe ɗiɗo, ɗum bo tato. ");
INSERT INTO fue_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","To o salike hettinanaago ɓe, den batu ka Eklesiya. To o salike hettinanaago Eklesiya bo, den fu daaree mo hande keefeero, ɗum bo jaɓoowo ceede faada. ");
INSERT INTO fue_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","E gooŋa batanmi on: Huune fu ko caliɗon e leydi ɗo, salaama dow kammu. Ko jaɓuɗon e leydi ɗo, jaɓete bo dow kammu.» ");
INSERT INTO fue_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Mii bata on kade e gooŋa: «To himɓe ɗiɗo e duuniyaaru ɗo nannantirii dow huune ko ɓe eelata, Baaba am gonuɗo dow kammu hokkan ɓe ɗum. ");
INSERT INTO fue_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Gam to himɓe ɗiɗo ɗum bo tato e hawritii e inne am, mi na'on caka maɓɓe.» ");
INSERT INTO fue_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Den Piyer ɓattii Yeesu, ƴami mo, wi'i: «Joomiraawo, de noy nun haani mi yaafano banniraawo am to o woofanii am? De jeeɗiɗi na?» ");
INSERT INTO fue_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yeesu toontii mo, wi'i: «De jeeɗiɗi tan bane bi'umaa mi, amma de lasoy tati e sappo faa de jeeɗiɗi. ");
INSERT INTO fue_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Hande non Laamaare Alla e nandi e laamiiɗo gom jiɗuɗo gollotooɓe mum liisanoo ɗum jawdi muuɗum. ");
INSERT INTO fue_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","No o fuɗɗi liisaaɗe, ɓe gaddani mo joganiiɗo mo ceede cardi miliyooji ɗuuɗɗi. ");
INSERT INTO fue_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Gorko on woodaa ko yoɓirta mo. Den, laamiiɗo on hokki laawol o sippee, kanko e deekiiko, e sukaaɓe makko, e ko o woodi fu, gam o yoɓa nyamaane nen. ");
INSERT INTO fue_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Gollotooɗo on jiccii yeeso makko, eeli mo, wi'i: ‟Joomiraawo Munyanam, mi yoɓete fu!” ");
INSERT INTO fue_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Joomiraawo on yurmii mo, yaafanii mo nyamaane nen, acci mo, o yawti. ");
INSERT INTO fue_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","No o wurtii, o fotti e banniraawo makko joganiiɗo mo ceede cardi hewre. O gattii mo, o ɗeɗɗi daane makko, o wi'i: ‟Yoɓam ceede am!” ");
INSERT INTO fue_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Banniiko jiccii, eeli mo, wi'i: ‟Munyanam, mi yoɓete!” ");
INSERT INTO fue_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Amma o jaɓay. O yaari mo o maɓɓoy der kasu, faa de o yoɓidi nyamaane nen fu. ");
INSERT INTO fue_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","No banniraaɓe makko gollotooɓe horiiɓe yi'i ko waɗi, mone maɓɓe ummii puy, ɓe jahi ɓe batoy joomiraawo maɓɓe ko waɗi. ");
INSERT INTO fue_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Den, joomiraawo on nodditii gollotooɗo on, wi'i mo: ‟An gollotooɗo kalluɗo! Mi yaafanakeno maa nyamaane joganinoɗaa am fu, gam a sawrinii am. ");
INSERT INTO fue_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","An bo, haanayno jurmoɗaa banniraawo maa hande no jurmoriimaa mi na?” ");
INSERT INTO fue_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Mone waɗi joomiiko, watti mo e juuɗe hiitotooɓe. O maɓɓaa der kasu, faa de o yoɓidi nyamaane nen fu. Den Yeesu ɓeydi wi'i: ");
INSERT INTO fue_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","‟Hande non Baaba am gonuɗo dow kammu waɗanta on to moy mooɗon fu yaafanaaki banniraawo mum e ɓerne woore.”» ");
INSERT INTO fue_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","No Yeesu heennyi fillaaji ɗin, o yawti diga Galili, o yahi Yahudiya, far fonŋo maayo Urdun. ");
INSERT INTO fue_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Jama'aare ɗuunne e tokki mo, den o nyawti ton nyawɓe. ");
INSERT INTO fue_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Woɓɓe der Farisaaɓe wari to makko, ƴami mo gam jarboo mo, wi'i: «Gorko e woodi laawol seera debbo mum, baa to gam daliila kaye nun na?» ");
INSERT INTO fue_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","O toontii ɓe, o wi'i: «On janŋay ko winnaa e dewtere na? Diga fuɗɗoode Alla tagii gorko e debbo.» ");
INSERT INTO fue_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","O wi'i: ‟Gam majjum gorko accan baaba mum e inna mum, takkontira e debbo mum, ɓe fu ɗiɗo, ɓe laatoo ɓannu gootol.”» ");
INSERT INTO fue_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Hande non ɓe laatataako kade ɗiɗo, amma ɓannu gootol. Den kan, to neɗɗo seennu ko Alla hawti. ");
INSERT INTO fue_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Farisaaɓe ɓen ƴami mo, wi'i: «Gam ume ko Muusa wi'i gorko hokka debbo ɗerewol ceergal to oo seera mo?» ");
INSERT INTO fue_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yeesu toontii ɓe, wi'i: «Gam sabbu yoorugo ɓerɗe mooɗon nun acci ko Muusa hokki on laawol ceeron rewɓe mooɗon. Amma diga fuɗɗoode, ɗum laataakino non. ");
INSERT INTO fue_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","E gooŋa bi'anmi on, ceeruɗo debbo mum to hinaa gam daliila jeenu, to o hoowi goɗɗo, o waɗii jeenu.» ");
INSERT INTO fue_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Aahiiɓe makko wi'i mo: «To non non nun haala gorko e debbo laatii, gomma to neɗɗo ɓaŋu.» ");
INSERT INTO fue_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yeesu toontii ɓe, wi'i: «Himɓe fu bane waawata ko jaɓi haala kan, sey ɓe Alla hokki ɗum tan. ");
INSERT INTO fue_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","E woodi rimaaɓe e laatii waatoraaɓe. Woɓɓe bo himɓe nun watti ɓe ɗum. Woɓɓe kan ɓaŋataa gam daliila Laamaare Alla. Baawuɗo ko jaɓi haala kan fu, jaɓa!» ");
INSERT INTO fue_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ɓaawo majjum, himɓe waddani Yeesu sukahon petton, gam o yowa juuɗe makko dow makkon o du'anoo kon, amma aahiiɓe makko nyaasitii ɓe. ");
INSERT INTO fue_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Den Yeesu wi'i ɓe: «Accee sukahon petton wara to am, to on kaɗee kon, gam Laamaare Alla laatani nun wa'uɓe hande makkon.» ");
INSERT INTO fue_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","O yowi juuɗe makko dow makkon, den o yawti diga ɗon. ");
INSERT INTO fue_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Gojankeejo gom ɓattii Yeesu, ƴami mo, wi'i: «Moodibbo, booɗɗum ume haani mi waɗa, go mi heɓa yonki tabitiiki?» ");
INSERT INTO fue_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yeesu wi'i mo: «Ko waɗi aa ƴamammi dow ko wooɗi? Alla tan woni booɗɗo! To aa yiɗi heɓugo yonki tabitiiki, sey tokkaa sariyaaji.» ");
INSERT INTO fue_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Gorko on ƴami Yeesu, wi'i: «Ɗiye nun sariyaaji ɗin?» Yeesu toontii mo, wi'i: «Taa waru neɗɗo, taa jeenu, taa wujju, taa seeda fewre. ");
INSERT INTO fue_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Teddin baaba maa e inna maa, den jiɗaa banniraawo maa hande no jiɗirɗaa hoore maa.» ");
INSERT INTO fue_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Gojankeejo on wi'i mo: «Mii jogii sariyaaji ɗii ɗon fu. Ume nun horii kade?» ");
INSERT INTO fue_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yeesu wi'i mo: «To aa yiɗi laatoɗaa kebbuɗo, yahu cippaa ko gooduɗaa, kokkaa talakaaɓe ceede majjum. Den a heɓan jawdi dow kammu. Ɓaawo majjum, garaa tokkaa am.» ");
INSERT INTO fue_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","No gojankeejo on nani haala kan, yawti e ɓerne biisiine, gam o laati nun jom jawdiijo. ");
INSERT INTO fue_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Den, Yeesu wi'i aahiiɓe mum: «E gooŋa batanmi on, eɗum saɗi jom jawdiijo naata der Laamaare Alla! ");
INSERT INTO fue_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Mii batitoo on ka kade, eɗum ɓuri hoyugo, jelooba wurtoroo e hinere baatal, e no jom jawdiijo naatirta der Laamaare Alla.» ");
INSERT INTO fue_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","No aahiiɓe makko nani ka, haaynaare nanŋi ɗum, wi'i: «Den, moy waawata ko hisi?» ");
INSERT INTO fue_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yeesu daari ɓe, wi'i: «E himɓe, ɗum ɗon waɗataako, amma to Alla, huune fu waɗoto.» ");
INSERT INTO fue_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Den, Piyer etti haala wi'i mo: «Minon, men accii huune fu men tokki maa. Ume nun laatantoo men?» ");
INSERT INTO fue_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yeesu wi'i ɓe: «E gooŋa batanmi on, to huune fu laatinaama kesum, Ɓii neɗɗo jooɗoto e kittaal laamaare tedduŋal makko. Den, onon sappo e ɗiɗo tokkuɓe am, on jooɗoto dow kittaaje sappo e ɗiɗi, kiitoɗon lenyi Isira'iilaaɓe sappo e ɗiɗi. ");
INSERT INTO fue_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Neɗɗo fu accuɗo wuro mum, e sakikiraaɓe mum worɓe e rewɓe, e baaba mum, ɗum bo inna mum, e sukaaɓe mum, e gese mum, gam am, o heɓan ko ɓuri ɗum, kade bo, o heɓan yonki tabitiiki. ");
INSERT INTO fue_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Amma ɗuuɓɓe ardiiɓe jooni, laatoto sakitiiɓe, ɗuuɓɓe der sakitiiɓe jooni bo, laatoto ardiiɓe.» ");
INSERT INTO fue_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","«Laamaare Alla e nandi e jom gesa innabooje. O wurtii subaka kecco, gam o daarta gollotooɓe, o yaara to gesa innabooje makko. ");
INSERT INTO fue_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","O nannantiri e gollotooɓe, o yoɓa ɓe nyalaane fu ceede cardi goote. Den o yaari ɓe gesa makko. ");
INSERT INTO fue_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","O wurtii jaka yanɗe jeenay, o tawi woɓɓe e jooɗii der luumo, woodaa gaɗeteeŋal. ");
INSERT INTO fue_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","O wi'i ɓe: ‟Jahee golloɗon, onon bo der gesa innabooje am, mi yoɓan on ko haani,” ");
INSERT INTO fue_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","kamɓe bo ɓe jahi. Jom gesa on witti kade caka nyalooma e yanne tati, o waɗi hande non. ");
INSERT INTO fue_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ɓaawo majjum, wakkati yanne joy, o wurtii kade. O tawi woɓɓe e darii, woodaa gaɗeteeŋal. O wi'i ɓe: ‟Ume waɗi ko oon nyalli daraago ɗo, on goodaa gaɗeteeŋal?” ");
INSERT INTO fue_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ɓe toontii mo, ɓe bi'i: ‟Men keɓay ettuɗo men golle.” O wi'i ɓe: ‟Jahee onon bo golloɗon der gesa innabooje am.” ");
INSERT INTO fue_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","No kiikiiɗe waɗi, jom gesa on wi'i deenuɗo jawdi mum: ‟Noddu gollotooɓe ɓen, joɓaa moy fu ceede mum. Puɗɗiraa sakitiiɓe, keennyitiraa ardiiɓe.” ");
INSERT INTO fue_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ettanooɓe golle deydey alaasara wari, moy maɓɓe fu hokkaa ceede cardi goote. ");
INSERT INTO fue_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ardinooɓe etteego golle bo wari. Ɓee miiluno joddi maɓɓe ɓuran ni ɓee to. Amma moy maɓɓe fu yoɓaa ceede cardi goote. ");
INSERT INTO fue_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","No ɓe joɓaa, ɓee dumbitoo dow jom gesa on, ");
INSERT INTO fue_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ɓee bi'a: ‟Sakitiiɓe wari, yanne woore tan gollii, ko potinɗaa ɓe e minon golliiɓe nyalaane ne fu, der naaŋe e guli!” ");
INSERT INTO fue_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Jom gesa on toontii gooto maɓɓe, wi'i: ‟Banniraawo am, mi farkanay maa. En nannantir bane dow ceede cardi goote nyalaane fu na? ");
INSERT INTO fue_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ettu joddi maa, dillu. Mii yiɗi yoɓugo cakitiiɗo hande no maa. ");
INSERT INTO fue_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Laawol hokkay am mi waɗira ceede am no jiɗirmi na? A daaririi am e gite kalluɗe gam mi waɗii ko wooɗi na?”» ");
INSERT INTO fue_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yeesu wi'i: «Hande non sakitiiɓe laatortoo ardiiɓe, ardiiɓe bo laatoo sakitiiɓe.» ");
INSERT INTO fue_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","No Yeesu yahata Urusaliima e aahiiɓe mum, o noddi sappo e ɗiɗo ɓen, feere mum, o wi'i ɓe: ");
INSERT INTO fue_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«Nani een jaha Urusaliima. Ton Ɓii neɗɗo wattoyte der juuɗe hooreeɓe limaamiiɓe, e moodiɓɓe tawreeta. Ɓe kiitoto mo kiita maayde. ");
INSERT INTO fue_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ɓe gattan mo der juuɗe heeferɓe, gam ɓe jaanca mo, ɓe piya mo looci, ɓe ɓila mo dow leggal palaaŋal. Amma nyalaane tatawre, o fintan.» ");
INSERT INTO fue_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Den, inna ɓiɓɓe Jebede e sukaaɓe mum ɓattii Yeesu. O jiccii yeeso Yeesu gam o eela ɗum ballal. ");
INSERT INTO fue_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yeesu wi'i mo: «Ume jiɗuɗaa?» O toontii mo, o wi'i: «Mii yiɗi, to a laamike, nootoɗaa ɓiɓɓe am ɗiɗo ɓee ɗo, gooto jooɗoo nyaamo maaɗa, gooto bo nano maaɗa.» ");
INSERT INTO fue_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yeesu toontii, wi'i: «On annaa ko eeloton am. On baawan ko yariri jarirgel ŋel jarirammi na?» Ɓe toontii mo, ɓe bi'i: «Men baawan.» ");
INSERT INTO fue_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","O wi'i ɓe: «Gooŋa nun, on baawan. Amma jooɗaago nyaamo am e nano am, min bane hokkata ɗum. Ɓee ɗo Baaba am siryanii joonɗe ɗen nun heɓata ɗe.» ");
INSERT INTO fue_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","No aahiiɓe sappo horiiɓe nani ka, mone maɓɓe ummii dow banniraaɓe maɓɓe ɗiɗo ɓen. ");
INSERT INTO fue_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Den, Yeesu noddi ɓe, ɓe fu, wi'i ɓe: «Oon anni hooreeɓe duuniyaaru, no boni nun jogorii himɓe mum. Mawɓe bo e holla himɓe mum baawɗe. ");
INSERT INTO fue_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Amma, ɗum waɗataako hande non hakkune mooɗon. Jiɗuɗo laataago mawɗo caka mooɗon fu, joomum laatoo jaggotooɗo mon. ");
INSERT INTO fue_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Kade bo, jiɗuɗo ardaago e mooɗon fu, joomum laatoo maccuɗo mooɗon. ");
INSERT INTO fue_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Hande non, Ɓii neɗɗo waray gam jagganeego, amma, jagganaago himɓe waddi mo, o hokkitira yonki makko gam sooditaago ɗuuɓɓe.» ");
INSERT INTO fue_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yeesu e aahiiɓe mum e wurtoo Yeriko, go jama'aare ɗuunne e tokki mo. ");
INSERT INTO fue_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Wumuɓe ɗiɗo gom e jooɗinoo sera laawol. Ɓe nani e wi'ee, Yeesu nun yawtata ɗon, den ɓe janti ɓee kuuɓa, ɓee bi'a: «Joomiraawo Ɓii Dawda, yurma men!» ");
INSERT INTO fue_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Jama'aare e falma ɓe gam ɓe jeeɗoo, amma ɓe ɓeydi huuɓugo e semme, ɓee bi'a: «Joomiraawo Ɓii Dawda, yurma men!» ");
INSERT INTO fue_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yeesu darii, noddi ɓe, wi'i: «Ume jiɗuɗon mi waɗana on?» ");
INSERT INTO fue_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ɓe toontii mo, ɓe bi'i: «Joomiraawo, wuntin men.» ");
INSERT INTO fue_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yeesu yurmii ɓe, meemi gite maɓɓe. Ɗon maa ɗon ɓe bumti, ɓe tokki mo. ");
INSERT INTO fue_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","No Yeesu e aahiiɓe mum faanii Urusaliima, ɓe jottii Baytifaaji, takkol waanne wi'eteene waanne Jaytuuje. Yeesu lili aahiiɓe ɗiɗo. ");
INSERT INTO fue_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","O wi'i ɓe: «Jahee siire wonune yeeso mooɗon, to oon naata ne, on tawan babba e ɓinŋel mum e haɓɓii. Pittee ɗi gaddanon am. ");
INSERT INTO fue_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","To goɗɗo ƴamii on gokka fu, toontee mo: ‟Joomiraawo nun bukaa ɗi.” Ɗon maa ɗon, o accan on gaddon ɗi.» ");
INSERT INTO fue_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ɗum waɗii, gam hebbingo haala ka annabiijo batuno, wi'i: ");
INSERT INTO fue_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«Batee ɓiɓɓe Siyoona, bi'on: ‟Daaree, laamiiɗo mon e wara e mon, oo ɗiggi, oo waɗɗii babba, e ɓinŋel mum.”» ");
INSERT INTO fue_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Aahiiɓe ɓen yahi, waɗi ko Yeesu bati ɓe. ");
INSERT INTO fue_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ɓe gaddi babba e ɓinŋel mum, ɓe daɗɗi toggooje maɓɓe dow majji, den Yeesu waɗɗii. ");
INSERT INTO fue_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ɗuuɓɓe der jama'aare nen weƴƴiti gineeji mum dow laawol. Woɓɓe bo salti licce leɗɗe, e weƴƴita dow laawol. ");
INSERT INTO fue_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ardiiɓe Yeesu, e tokkinɓe mo ɓaawo fu, e hulgina e wi'a: «Hosana, Ɓii Dawda! Barke laatanoo garoowo e inne Joomiraawo! Hosana Joomiraawo mo dow kammu!» ");
INSERT INTO fue_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","No Yeesu naati Urusaliima, genni fu laawontirii. Himɓe e ƴamontira, e wi'a: «Moy nun gorko oo ɗo?» ");
INSERT INTO fue_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Jama'aare toontii, wi'i: «Yeesu annabiijo, mo Nasaratu, der leydi Galili nun.» ");
INSERT INTO fue_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yeesu naatii der suudu Alla. O riiwi sippooɓe, e soodooɓe, o hippi taaburuuji cengotooɓe ceede, e kittaaje sippooɓe tantabaraaji. ");
INSERT INTO fue_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Den, o wi'i ɓe: «Alla batii der Dewtere, wi'i: ‟Suudu am noddete suudu to du'aare waɗetee.” Amma onon, on gartirii ŋol suuɗorde wuyɓe!» ");
INSERT INTO fue_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Wumuɓe e laƴooɓe wari to makko der suudu Alla, go o nyawti ɓe. ");
INSERT INTO fue_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Hooreeɓe limaamiiɓe, e moodiɓɓe tawreeta, mone mum ummi no yi'i kujje kayniiɗe ɗe Yeesu waɗata, e no sukaaɓe hulginirta der suudu Alla, e wi'a: «Hosana Ɓii Dawda!» ");
INSERT INTO fue_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Den ɓe bi'i: «Aa nana ko sukaaɓe ɓen batata na?» Yeesu toontii ɓe, wi'i: «Mii nana. On meeɗay ko janŋi haala kaa ɗo na? ‟A heɓii maanteego diga e kunnuɗe sukaaɓe, e musinooɓe.”» ");
INSERT INTO fue_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Den, o acci ɓe, o wurtii siire nen, o yahi Baytaniya, o waaloy ton. ");
INSERT INTO fue_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Fini mum subaka, Yeesu dawi e witta der siire, go rafo waɗi mo. ");
INSERT INTO fue_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","O hollirii ibbi sera laawol. O yaali to makki, amma o taway goɗɗum, sey baafe tan. Den o bati ibbi kin, o wi'i: «A rimataa ɓiɓɓe kade faa abada!» Ɗon maa ɗon, ibbi kin yoori. ");
INSERT INTO fue_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","No aahiiɓe makko yi'i ɗum, haaynaare nanŋi ɗum, den ɓe ƴami mo, ɓe bi'i: «Noy ibbi kin yooriri ɗon maa ɗon?» ");
INSERT INTO fue_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","O toontii ɓe, o wi'i: «E gooŋa batanmi on: To oon goonɗini, on gaɗay seko, on gaɗan ko ɓuri ko ibbi kin waɗanaa. On baawan ko wi'i, waanne nee ɗo: ‟Ɗoofa diga ɗo, yantoy der maayo,” ɗum laatoto bo. ");
INSERT INTO fue_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","To oon goonɗini, ko eeluɗon e du'aare fu, on keɓan ɗum.» ");
INSERT INTO fue_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yeesu naati der suudu Alla. No o waajotoo, hooreeɓe limaamiiɓe, e dottiiɓe Yahuduuɓe ɓattii, ƴami mo, wi'i: «E baawɗe ɗey gaɗirtaa kujje ɗee? Moy hokku maa baawɗe majjum?» ");
INSERT INTO fue_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yeesu toontii ɓe, wi'i: «Min bo, mi ƴaman on ƴanɗe goote. To on toontike am, mi batan on e baawɗe ɗey nun gaɗiranmi huune ɗum. ");
INSERT INTO fue_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Moy lili Yuhaana waɗa himɓe batisi? Alla nun, naa himɓe?» Ɓe baddi hakkune maɓɓe, ɓe bi'i: «To en bi'i ‟Alla nun”, o wi'an: ‟Den, ume waɗi go en goonɗinay Yuhaana?” ");
INSERT INTO fue_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Amma to en toontike bi'uɗen ‟himɓe nun”, een kula himɓe bo, gam himɓe fu e daari Yuhaana hande annabiijo.» ");
INSERT INTO fue_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ɓe toontii Yeesu, ɓe bi'i: «Men annaa.» Kanko bo, o wi'i ɓe: «To non min bo, mi batataa on to e baawɗe ɗey nun gaɗiranmi kujje ɗee.» ");
INSERT INTO fue_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yeesu ɓeydi wi'i: «Kaye miiluɗon e ballool ŋol ɗo: Gorko gom nun woodunoo sukaaɓe worɓe ɗiɗo. O bati arano, o wi'i ɗum: ‟Suka am, yahu golloɗaa to gesa innabooje.” ");
INSERT INTO fue_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Suka on toontii, wi'i: ‟Mi yahataa.” Amma ɓaawo nii, o miijitii, o yahi. ");
INSERT INTO fue_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Baaba on noddi suka ɗiɗaɓo, wi'i mo ka o wi'unoo arano on. Oo ɗon toontii, wi'i: ‟Wooɗi Baaba, mi yahan” Amma o yahay. ");
INSERT INTO fue_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Der kamɓe ɗiɗo ɓen, moy nun e maɓɓe waɗi ko baaba mum yiɗi?» Ɓe toontii, ɓe bi'i: «Arano on nun.» Den, Yeesu wi'i ɓe: «E gooŋa batanmi on, jaɓooɓe ceede faada, e kaaruwaaɓe artan on naatoygo Laamaare Alla. ");
INSERT INTO fue_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Gam Yuhaana warii caka mooɗon, hollii on laawol foonnitaare, on jaɓay haala makko. Amma jaɓooɓe ceede faada e kaaruwaaɓe goonɗinii mo, go onon yi'uɓe ɗum, on tuubay goonɗinɗon mo.» ");
INSERT INTO fue_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","«Kettinee ballool gonŋol kade. Neɗɗo gom nun tiggi gesa innabooje mum. O waɗi kowaagol kara, o fiiltini ka. O wasi gayka to ɓiɓɓe innabooje ɓiɗɗetee, o mahi suudu towukol deenirkol der gesa ka. Ɓaawo mum, o accani ka gollotooɓe makko ɓe gaɗi haya, den o waɗi jahaaŋal. ");
INSERT INTO fue_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","No wakkati ɓorugo innabooje yottii, o lili gollotooɓe makko to reeninaaɓe gesa, ɓe gaddanaa mo geɗu makko der ɓiɓɓe innabooje ɗen. ");
INSERT INTO fue_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Amma reeninaaɓe gesa ŋan nanŋi lilaaɓe ɓen, fiyi gooto, gooto bo, ɓe bari ɗum, tataɓo ɓe paɗɗi ɗum kaaƴe, ɓe bari. ");
INSERT INTO fue_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Jom gesa on lilitii gollotooɓe mum, ɓuruɓe arandeeɓe ɗuuɗugo. Reeninaaɓe gesaa, waɗani ɓe no waɗannoo arandeeɓe. ");
INSERT INTO fue_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Faa sakitiine, o lili ɓiyiiko gorko to maɓɓe, o wi'i: ‟No waɗi fu, ɓe teddinan ɓiyam.” ");
INSERT INTO fue_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Amma no reeninaaɓe gesa yi'i mo, ɓe bi'ontiri hakkune maɓɓe: ‟Kanko woni donoowo gesa ŋan. Garee baren mo, donen ŋa!”» ");
INSERT INTO fue_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Den, ɓe nanŋi mo, ɓe paɗɗi mo ɓaawo gesa, ɓe bari mo. ");
INSERT INTO fue_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Jooni noo, to jom gesa innabooje on wari, noy o waɗata ɓe?» ");
INSERT INTO fue_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ɓe toontii mo, ɓe bi'i: «O halkan reenuɓe halluɓe ɓen halkere naawune. Den o hokkan woɓɓe gesa ŋan, waɗa haya, baawooɓe ko hokki mo geɗu makko, to wakkati ɓorol ɓiɓɓe fotii.» ");
INSERT INTO fue_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ɓaawo majjum, Yeesu wi'i ɓe: «On meeɗay janŋugo ko winnaa der dewtere na? ‟Hayre ne mahooɓe woppi, kayre laatii hayre jogiine maadi.” Kanjum woni golle Joomiraawo, eɗum haaynii e gite meeɗen!» ");
INSERT INTO fue_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Gam majjum, mii wi'a on: «Laamaare Alla sottinte caka mooɗon, ne hokkee himɓe lenyi janani, waɗooɓe ko Alla yiɗi. ");
INSERT INTO fue_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Neɗɗo januɗo dow hayre nen, heltoto. Mo ne yanti dow mum fu bo, muunyitinto.» ");
INSERT INTO fue_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","No hooreeɓe limaamiiɓe e Farisaaɓe nani ka, ɓe paami kamɓe nun Yeesu waɗani ballaaji ɗii. ");
INSERT INTO fue_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ɓee daarta laabi no ɓe nanŋirta mo, amma ɓee kula himɓe, gam himɓe fu e daari mo annabiijo. ");
INSERT INTO fue_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yeesu baddi ɓe kade e ballaaji, wi'i: ");
INSERT INTO fue_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«Laamaare Alla e nandi hande laamiiɗo gom gaɗuɗo julɗe ɓangal ɓiyum. ");
INSERT INTO fue_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","O lili gollotooɓe makko noddanaa mo noddinaaɓe julɗe ɓangal. Amma noddinaaɓe ɓen yiɗay warugo. ");
INSERT INTO fue_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","O lili kade gollotooɓe makko woɓɓe, o wi'i ɓe: ‟Bi'ee noddinaaɓe ɓen, huune fu siriyaama, ga'i e baali payuɗi hiisaama, huune fu gasii, ɓe gara nyaamɗe.” ");
INSERT INTO fue_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Amma noddinaaɓe yeebii noddoore nen, hiinnii haajuuji mum. Oo ɗo yawtiri gesa mum, oo to bo yawtiri daartiiru mum. ");
INSERT INTO fue_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Horiiɓe nanŋi gollotooɓe, toori ɓe, wari ɓe. ");
INSERT INTO fue_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Mone laamiiɗo ummii puy. O lili soogeeji makko yaha halkaa himɓe ɓen, wuuɗa ci'e maɓɓe. ");
INSERT INTO fue_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ɓaawo majjum, o wi'i gollotooɓe makko: ‟Nafa ɓangal ɓenni, amma noddinanooɓe fotay nyaamugo ka. ");
INSERT INTO fue_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Gam majjum, jahee to fottirɗe laabi, noddon ɓe tawuɗon ɗon fu wara.” ");
INSERT INTO fue_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Gollotooɓe ɓen yahi to fottirde laabi, noddi ɓe tawi ɗon fu, halluɓe e wooɗuɓe fu, faa suudu hebbi himɓe. ");
INSERT INTO fue_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Laamiiɗo naati gam daara noddinaaɓe mum. O hollirii goɗɗo gom, mo ɓornaaki gineeji ɓangal. ");
INSERT INTO fue_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","O ɓattii mo, o wi'i: ‟Banniraawo am, noy naatirɗaa ɗo go a ɓornaaki gineeji ɓangal?” Amma, oo jeeɗii. ");
INSERT INTO fue_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Den, laamiiɗo wi'i gollotooɓe mum: ‟Kaɓɓee mo, koyɗe e juuɗe, boppon yaasi, der niwre. O wulla ton, o ƴakkontira nyiiƴe.”» ");
INSERT INTO fue_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yeesu tokki wi'ugo: «Noddaaɓe e ɗuuɗi, amma suɓaaɓe ɗuuɗaa.» ");
INSERT INTO fue_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Farisaaɓe yahi baddoy dow no ɓe nanŋirta Yeesu der haala mum. ");
INSERT INTO fue_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ɓe lili aahiiɓe maɓɓe woɓɓe, e ɓe Eroodu, ɓe bi'i mo: «Moodibbo, emen anni a laati nun gooŋaajo. E gooŋa nun janŋinirtaa laawol Alla, a hulataa bo himɓe, gam a ɓurontirtaa himɓe. ");
INSERT INTO fue_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Den, batu men ko miiluɗaa dow haala kaa ɗo: E haani men joɓa laamiiɗo Roma ceede faada naa haanay?» ");
INSERT INTO fue_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Amma Yeesu e anni miilooji ɓerɗe maɓɓe kalluɗi. O toontii ɓe, o wi'i: «Onon munaafitiiɓe! Ume waɗi ko oon daarta jammaago am? ");
INSERT INTO fue_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Kollee am ceede joɓirteeɗe ɗen.» Ɓe gaddani mo ceede cardi goote. ");
INSERT INTO fue_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","O ƴami ɓe, o wi'i: «Foto moy e inne moy woni ɗo?» ");
INSERT INTO fue_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ɓe toontii, ɓe bi'i: «Laamiiɗo Roma nun.» Den o wi'i ɓe: «To non, kokkee laamiiɗo Roma ko laatanii ɗum, kokkon Alla bo ko laatanii ɗum.» ");
INSERT INTO fue_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","No ɓe nani ka o toontii, haaynaare nanŋi ɓe. Den ɓe acci mo, ɓe jawti. ");
INSERT INTO fue_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Der nyalaane woore nen, woɓɓe ƴiwoy diga e waalde Sadukiiɓe. Kamɓe nun yeddata, e wi'a maayɓe fintataa. Ɓe gari to Yeesu, ɓe ƴami mo, ");
INSERT INTO fue_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","ɓe bi'i: «Moodibbo, Muusa wi'i: ‟To goɗɗo maayii rimay ɓiɓɓe, minnyiiko naatta debbo on, gam o darina lenyol mawniiko maayuɗo.” ");
INSERT INTO fue_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ɗum waɗiino caka amen dow woɓɓe rindaaɓe jeeɗiɗo. Arano ɓaŋi debbo, maayi, rinday e makko. Minnyiiko naatti debbo on. ");
INSERT INTO fue_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Kanko bo o maayi, o rinday mo ɓiɗɗo. Tataɓo bo non non, faa ɓe fu jeeɗiɗo ɓen. ");
INSERT INTO fue_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ɓaawo maɓɓe ɓe fu, debbo on bo maayi. ");
INSERT INTO fue_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Den, nyalaane darŋal, to maayɓe fintoy, moy nun e maɓɓe, o laatoytoo debbo mum, dow kamɓe jeeɗiɗo ɓen? Gam ɓe fu ɓe koowiino mo.» ");
INSERT INTO fue_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yeesu toontii ɓe, wi'i: «On majjii, gam on paamay Dewte, on annaa baawɗe Alla bo. ");
INSERT INTO fue_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","To maayɓe fintii, worɓe ɓaŋataa, rewɓe bo ɓaŋataake, ɓe laatoto nun hande malaykaaɓe tawaaɓe dow kammu. ");
INSERT INTO fue_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Dow haala pintol maayɓe, on janŋay ko Alla wi'i on na? O wi'i: ");
INSERT INTO fue_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‟Min woni Alla Iburahiima, Alla Isiyaaku, e Alla Yaakuubu.” Alla laataaki Alla maayuɓe, amma Alla wuuruɓe.» ");
INSERT INTO fue_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Jama'aare hettinaniine mo, haaynaare nanŋi ɗum e ekkitinol makko. ");
INSERT INTO fue_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","No Farisaaɓe nani Yeesu muɓɓii kunnuɗe Sadukiiɓe e haala, ɓe gaɗi hawriine. ");
INSERT INTO fue_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Gooto maɓɓe, laatiiɗo janŋinoowo Sariya, yiɗi jarbaago Yeesu, ƴami mo, wi'i: ");
INSERT INTO fue_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«Moodibbo, sariya kaye ɓuri mawnugo der dewtere tawreeta?» ");
INSERT INTO fue_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yeesu toontii mo, wi'i: «‟Yiɗu Alla Joomiraawo maa e ɓerne maa fu, e yonki maa fu, e hakkillo maa fu.” ");
INSERT INTO fue_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Kanka woni sariya arana, ɓuruka manŋu. ");
INSERT INTO fue_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Sariya ɗiɗaɓa nanduka e makka nani: ‟Yiɗu banniraawo maa, hande no jiɗirɗaa hoore maa.” ");
INSERT INTO fue_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ko tawreeta Muusa e dewte annabiiɓe bati fu, e darii dow sariyaaji ɗiɗi ɗii.» ");
INSERT INTO fue_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","No Farisaaɓe hawritii, Yeesu ƴami ɓe, wi'i: ");
INSERT INTO fue_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«Ume miiloton dow Almasiihu? Ɓii moy nun?» Ɓe toontii mo, ɓe bi'i: «Ɓii Dawda nun.» ");
INSERT INTO fue_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Den Yeesu wi'i ɓe: «Noy Dawda noddiri mo ‟Joomiraawo?” Ruuhu Alla holli mo ɗum, gam majjum o wi'i: ");
INSERT INTO fue_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‟Joomiraawo wi'i Joomam: Jooɗa nyaamo am, faa mi waɗa jaaɓaa wayɓe maa.” ");
INSERT INTO fue_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","To Dawda noddii mo ‟Joomiraawo”, den, noy o laatortoo ɓiyiiko?» ");
INSERT INTO fue_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ɓe fu ɓe baaway ko toontii mo gokka. Diga nyaanne mum, goɗɗo suusay ko ƴami mo ƴanɗe goɗɗe. ");
INSERT INTO fue_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Den, Yeesu baddi jama'aare e aahiiɓe mum, wi'i: ");
INSERT INTO fue_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«Moodiɓɓe tawreeta e Farisaaɓe, yowanaama janŋingo tawreeta Muusa. ");
INSERT INTO fue_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Gam majjum, nananee ɓe, gaɗee huune fu ko ɓe bi'i on. Amma to on gaɗee ko ɓe gaɗata, gam ɓee bata, amma ɓe gaɗataa ko ɓe bati. ");
INSERT INTO fue_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ɓee kaɓɓa doolle tedduɗe, ɓee doonina himɓe dow balbe mum. Amma kamɓe, ɓe jiɗaa meemugo ɗe baa e kollel. ");
INSERT INTO fue_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ko ɓe gaɗata fu, ɓee gaɗa ɗum gam himɓe yi'ana ɓe. Kanjum acci ɓee binna aayaaje dow laayaaji, ɓe kaɓɓa e tiiɗe, e dow came maɓɓe. Ɓee juutina sariiji toggooje maɓɓe. ");
INSERT INTO fue_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ɓee jiɗi joonɗe arandeeje to ɓe noddinaama nyaamɗe. Ɓee jiɗi joonɗe ɓurɗe teddugo, der cuuɗi baajorɗi. ");
INSERT INTO fue_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ɓee jiɗi sanneego caka jaayri to jama'aare hawritii, e noddeego ‟Moodibbo”. ");
INSERT INTO fue_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Amma onon, to on nootee noddeɗon ‟Moodibbo”, gam moodibbo gooto tan gooduɗon, onon kan, on fu oon banniraaɓe. ");
INSERT INTO fue_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","To on noddee goɗɗo ‟Baaba” e duuniyaaru ɗo, gam Baaba gooto tan gooduɗon, kanko woni gonuɗo dow kammu. ");
INSERT INTO fue_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","To on jaɓee noddeego ‟Hooreejo”, gam hooreejo gooto tan gooduɗon, kanko woni Almasiihu. ");
INSERT INTO fue_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ɓuruɗo mawnugo caka mooɗon laatoo gollantooɗo horiiɓe. ");
INSERT INTO fue_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Mawninɗo hoore mum fu, leesinte. Leesinɗo hoore mum bo, mawninte.» ");
INSERT INTO fue_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","«Bone laatanto on, onon moodiɓɓe tawreeta e Farisaaɓe, munaafitiiɓe! gam oon maɓɓana himɓe dammugal Laamaare Alla. Onon e ko'e mon on naatataa, on accay yiɗuɓe naatugo bo, naata.  ");
INSERT INTO fue_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Bone laatanto on onon moodiɓɓe e Farisaaɓe munaafitiiɓe! Oon teeta cuuɗi gowniiɓe, oon juutina du'aaje gam himɓe mana on. Gam majjum, on kiitete kiita ɓuruka naawugo. ");
INSERT INTO fue_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Bone laatanto on, onon moodiɓɓe tawreeta e Farisaaɓe, munaafitiiɓe! Gam oon boositoo leyɗe, e maayo fu, gam keɓon baa gooto tokka on. To on keɓii mo, laatinon mo ɓii yiiteejo, de ɗiɗi, ɓura no mooɗon. ");
INSERT INTO fue_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Bone laatanto on, onon wumuɓe ardiiɓe! Oon bi'a: ‟To neɗɗo hunorake suudu Alla, ɗum laataaki goɗɗum. Amma to o hunorake kanŋeeri suudu Alla, doole o hebbina hunayeere makko.” ");
INSERT INTO fue_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Onon majjuɓe, e wumuɓe! Ume ɓuri mawnugo, kanŋeeri na, naa suudu Alla laaɓinooŋol kanŋeeri? ");
INSERT INTO fue_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Oon bi'a kade: ‟To neɗɗo hunorake hiisirde ɗum laataaki goɗɗum. Amma to o hunorake sadaka cakkaaka dow hiisirde, doole o hebbina hunayeere makko.” ");
INSERT INTO fue_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Onon wumuɓe! Ume nun ɓuri mawnugo: sadaka kiisaaka na, naa hiisirde laaɓinoore sadaka kan? ");
INSERT INTO fue_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","To non kunoriiɗo hiisirde, hunorake hiisirde e ko woni dow maggol fu. ");
INSERT INTO fue_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Kunoriiɗo suudu Alla, hunorake ŋol e Alla tawaaɗo der mayru. ");
INSERT INTO fue_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Kunoriiɗo kammu bo, hunorake gurol Laamaare Alla, e Alla jooɗiiɗo dow maggol. ");
INSERT INTO fue_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Bone laatanto on, onon moodiɓɓe tawreeta e Farisaaɓe, munaafitiiɓe! Gam oon cutta jakka haakooji bi'eteeɗi maantu, e anisa, e kume, amma oon jeeboo ko ɓuri teddugo der tawreeta, kan woni foonnitaare, e enɗam, e goonɗinki. Amma to on jeebee ko horii. ");
INSERT INTO fue_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Onon wumuɓe ardiiɓe! To buubol yanii der jaram mooɗon, oon cekoo, ikkinon ŋol, amma oon moɗa jeelooba! ");
INSERT INTO fue_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Bone laatanto on, onon moodiɓɓe tawreeta e Farisaaɓe, munaafitiiɓe! Gam oon layɓa ɓaawo jarirkon, e ɓaawo keeɗe. Amma der majje e heewi huune ko wujjaa, e ko teetaa. ");
INSERT INTO fue_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","An Farisaajo bumɗo! Layɓu taw der jarirkon e der keeɗe, den ɓaawo majje bo laaɓan. ");
INSERT INTO fue_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Bone laatanto on, onon moodiɓɓe tawreeta e Farisaaɓe, munaafitiiɓe! Gam oon nandi hande caabeeje dawninaaɗe. Yaasi majje e wooɗi, amma der e hebbi ƴiƴe maayuɓe, e huune ko soɓi fu. ");
INSERT INTO fue_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Onon bo, hande non laatiɗon. Dow gite himɓe, oon nandi hande foonnitiiɓe, amma der mooɗon e hebbi munaafitaare, e luudaare. ");
INSERT INTO fue_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Bone laatanto on, onon moodiɓɓe tawreeta e Farisaaɓe, munaafitiiɓe! Gam oon maha jenaale annabiiɓe, oon booɗina caabeeje foonnitiiɓe. ");
INSERT INTO fue_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Den oon bi'a: ‟To men na'onno wakkati kaakiraaɓe amen, men kawtataano e maɓɓe dow barki annabiiɓe ɓen.” ");
INSERT INTO fue_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Hande non, nootoriɗon onon nun laatii ɓiɓɓe warunooɓe annabiiɓe. ");
INSERT INTO fue_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","To non, kebbinee golle ɗe kaakiraaɓe mooɗon fuɗɗuno! ");
INSERT INTO fue_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Onon ɓiɓɓe bolle pure! Noy baawirton ko daɗi yiite jahannama? ");
INSERT INTO fue_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Gam majjum, mii lildana on annabiiɓe, e hakkilɓe, e moodiɓɓe tawreeta. On baran woɓɓe, tiggon woɓɓe, woɓɓe, piyon ɗum looci, der cuuɗi mooɗon baajorɗi, tooron ɓe, der ci'e e ci'e. ");
INSERT INTO fue_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Alla hiitoto on sabbu ƴiiƴam himɓe foonnitiiɓe, baraaɓe. Ɗum fuɗɗan diga ƴiiƴam Habiila, poonnitiiɗo, faa ƴiiƴam Jekariya, ɓii Barakiya, mo baruɗon hakkune suudu Alla e hiisirde. ");
INSERT INTO fue_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","E gooŋa batanmi on: Huune ɗum fu, tawan himɓe jaamanuuru nuu ɗo! ");
INSERT INTO fue_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","«Urusaliima, Urusaliima! an baroowo annabiiɓe, e paɗɗoowo ɓe Alla lildanoy maa kaaƴe! De ɗuuɗɗum jiɗumi hawritingo ɓiɓɓe maaɗa hande no gertogal hawritirta coppi mum ley biyeeɗe mum. Amma on jaɓay. ");
INSERT INTO fue_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Gam majjum, on accante genni mooɗon laatoo bille. ");
INSERT INTO fue_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","E gooŋa batanmi on, on ji'ataa am kade faa nyalaane bi'oyton: ‟Barke woodani garoowo e inne Joomiraawo!”» ");
INSERT INTO fue_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yeesu wurtii suudu Alla, e yawta, ko aahiiɓe makko ɓattii, e holla mo no suudu Alla ŋol mahiraa. ");
INSERT INTO fue_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Den, o wi'i ɓe: «On ji'i huune ɗum fu na?» E gooŋa batanmi on: «Baa hayre yowataako dow wonne, ɗum fu, ɗum pusete.» ");
INSERT INTO fue_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yeesu yahi jooɗoy dow waanne wi'eteene waanne Jaytuuje, den aahiiɓe makko wari kamɓe tan, ƴami mo, wi'i: «Batu men dey nun ɗum waɗata. Maane ney nun hollitinta garki maa e keennyol duuniyaaru?» ");
INSERT INTO fue_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yeesu toontii ɓe, wi'i: «Kakkilee, to on accee goɗɗo majjina on. ");
INSERT INTO fue_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Gam ɗuuɓɓe waran e inne am, ɓe bi'a, kamɓe nun woni Almasiihu. Ɓe majjinan himɓe ɗuuɓɓe. ");
INSERT INTO fue_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","On nanan habaruuji konuuji e rimmo konuuji e batanee, amma to on kulee! Doole nun ɗum waɗa, amma timmoode bane ɗon taw. ");
INSERT INTO fue_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Lenyol ummanto lenyol hawre. Laamaare ummanto laamaare bannun hawre. Rafo e dimmaaɗe leydi waɗan der nokkuuje goɗɗe. ");
INSERT INTO fue_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ɗum ɗon fu laati nun hande fuɗɗoode ŋatawre. ");
INSERT INTO fue_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Den himɓe wattan on e juuɗe woɓɓe gam tooreɗon, bareɗon. Lenyi fu wanyan on gam inne am. ");
INSERT INTO fue_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Wakkati mum, himɓe ɗuuɓɓe accan goonɗinki, ɓe jammontiran, ɓe banyontira hakkune maɓɓe. ");
INSERT INTO fue_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Annabiiɓe fewooɓe ɗuuɓɓe waran, ɓe majjinan himɓe ɗuuɓɓe. ");
INSERT INTO fue_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Hallande yahan e ɗuuɗa faa yidde himɓe ɗuuɓɓe feewta. ");
INSERT INTO fue_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Amma munyuɗo faa timmoode, hisan. ");
INSERT INTO fue_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Linjiila dow Laamaare Alla waajete der duuniyaaru fu, gam ɗum laatanoo lenyi fu seedaaku. Den, timmoode duuniyaaru waran.» ");
INSERT INTO fue_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","«Gam majjum, to on ji'ii ‟karmuɗum, nyidduɗum”, ɗum annabi Daniyel batannoo e darii dow nokkuure ceniine, den sey janŋooɓe ka waɗa hakkillo. ");
INSERT INTO fue_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Den, tawaaɓe Yahudiya fu dogga eenca baalle. ");
INSERT INTO fue_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Tawaaɗo dow suudu bo, to wi'a jippoto etta ko woni der suudu. ");
INSERT INTO fue_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Tawaaɗo gese bo, to wittu wuro ettoygo toggoore mum. ");
INSERT INTO fue_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Bone laatanto rewɓe gaamɓe, e musinteeɓe der nyalaaɗe ɗen! ");
INSERT INTO fue_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Du'ee, gam to doggudu mooɗon laatoo wakkati dabbune, ɗum bo nyalaane siwteteene. ");
INSERT INTO fue_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Gam, toora mawka laatoto, hande makka meeɗay ko waɗii diga duuniyaaru fuɗɗi faa jooni, hande makka bo waɗataa kade faa abada. ");
INSERT INTO fue_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","To nyalaaɗe ɗen ɓuytaakano juutugo, goɗɗo hisataano. Amma Alla ɓuytii ɗe sabbu suɓaaɓe mum. ");
INSERT INTO fue_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Wakkati mum, to goɗɗo wi'ii on: ‟Almasiihu nani ɗo,» naa bo ‟o nani to,” to on goonɗinee. ");
INSERT INTO fue_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Gam almasiihuuɓe e annabiiɓe fewrekuuɓe waraan. Ɓe gaɗan kaayeefiiji mawɗi, e haaynaareeji ɗuuɗɗi, gam ɓe majjina baa e suɓaaɓe, to waɗoto. ");
INSERT INTO fue_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Paamee wooɗa, mi seedinii on ɗum diga ɗum waray. ");
INSERT INTO fue_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","To goɗɗo wi'ii on: ‟O na'on der haro,” to on jahee ton. Naa bo to ɓe bi'ii on: ‟O na'on der cuuɗi,” to on goonɗinee. ");
INSERT INTO fue_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Hande no maaƴƴere maaƴƴirta dow kammu diga lettugal faa gorgal, hande non Ɓii neɗɗo bo warirta. ");
INSERT INTO fue_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","To baatuɗum woni fu, ton nun digaareeje hawritintoo.» ");
INSERT INTO fue_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","«Ɗon maa ɗon, ɓaawo nyalaaɗe ɓillaaje ɗen, naaŋe niɓɓan, lewru accan yaynugo, koode yanan diga dow kammu, baawɗe gonuɗe dow kammu fu dimmoto. ");
INSERT INTO fue_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Den, maane Ɓii neɗɗo hollitinto dow kammu. Lenyi himɓe duuniyaaru fu simoto. Ɓe ji'an Ɓii neɗɗo e wara diga kammu, der duule, e baawɗe mawɗe, e tedduŋal. ");
INSERT INTO fue_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Walaldu mawnu fuurete. O lilan malaykaaɓe makko der gooraaje leydi naay, lettugal e gorgal, soɓɓiire e hoore fuɗo, gam hawritingo suɓaaɓe makko wonuɓe der duuniyaaru fu. ");
INSERT INTO fue_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Paamee ko ibbi ekkitinta. To licce makki e wilita, e waɗa haako, oon anni dunŋu faanike. ");
INSERT INTO fue_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Hande non, onon bo, to on ji'ii huune ko batanmi ɗo fuɗɗi waɗugo, annitee wakkati Ɓii neɗɗo faanike, oo darii dammugal wuro. ");
INSERT INTO fue_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","E gooŋa batanmi on: Himɓe jaamanuuru nu ɗo maayidintaa go huune ɗum fu laatoo. ");
INSERT INTO fue_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Kammu e leydi heennyan, amma haala am heennyataa faa abada.» ");
INSERT INTO fue_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","«Amma nyalaane e wakkati majjum, walaa annuɗo ɗum. Baa malaykaaɓe wonuɓe dow kammu annaa, baa Ɓiɗɗo bo. Walaa annuɗo ɗum sey Baaba tan. ");
INSERT INTO fue_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Hande no ɗum laatino der jaamanu Nuuhu, hande non garki Ɓii neɗɗo bo laatoto. ");
INSERT INTO fue_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Go ilam tufaana wara, himɓe e nyaamanno, e yaranno, e ɓaŋanno, e ɓaŋana ɓiɓɓe mum, faa nyalaane Nuuhu naati laana diyam. ");
INSERT INTO fue_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ɓe miijanaaki ɗum, faa ilam tufaana wari halki ɓe ɓe fu. Hande non garki Ɓii neɗɗo bo laatorto. ");
INSERT INTO fue_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Wakkati mum, worɓe ɗiɗo wonoto der gesa, gooto ettee, gooto accee. ");
INSERT INTO fue_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Rewɓe ɗiɗo namidan dow namarde woore, gooto ettee, gooto accee. ");
INSERT INTO fue_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","To non, deenee, gam on annaa wakkati de Joomiraawo mooɗon warata. ");
INSERT INTO fue_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Paamee kaa ɗo: To jom wuro e anni wakkatiire ne gujjo warata jemma, o ɗaanataako. O accataa gujjo yula suudu makko. ");
INSERT INTO fue_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Gam majjum, kakkilee onon bo, gam Ɓii neɗɗo waran der wakkatiire ne on miilay.» ");
INSERT INTO fue_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","«Moy woni gollotooɗo kooliniiɗo, kakkilɗo? Kanko woni mo joomiraawo mum yowani ɗum himɓe wuro mum gam o hokka ɓe nyaamdu der wakkati kaanuki. ");
INSERT INTO fue_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Barke laatanto gollotooɗo mo joomiraawo mum warti tawi e hiinnii golle mum. ");
INSERT INTO fue_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","E gooŋa batanmi on: Joomiiko yowanan mo jawdi mum fu. ");
INSERT INTO fue_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Amma to gollotooɗo on e laatii kalluɗo, o wi'an der ɓerne makko: Joomiraawo am ɓooyan, wartay, ");
INSERT INTO fue_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","den o yanta oo fiya banniraaɓe makko gollotooɓe, oo nyaamida, oo yarida e yarooɓe. ");
INSERT INTO fue_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Kanko, joomiiko wartan nyalaane ne o miilanay, e wakkatiire ne o annaa. ");
INSERT INTO fue_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Joomiiko hiitoto mo kiita naawuka, o heɓa riiba e munaafitiiɓe. Den o wullan, o ƴakkontira nyiiƴe.» ");
INSERT INTO fue_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","«Nyalaane mum, Laamaare Alla nandan e gati sappo ɗi annaa worɓe ettuɗi fitillaaji mum, wurtii gam fottoygo e jommanjo gorko. ");
INSERT INTO fue_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Joyo maɓɓe e laatii ŋaaɓiiɓe, joyo bo ƴoƴuɓe. ");
INSERT INTO fue_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ŋaaɓiiɓe ɓen etti fitillaaji mum, amma ɓe ettay nebbam goɗɗam. ");
INSERT INTO fue_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ƴoƴuɓe kan etti fitillaaji mum, hawri e paali nebbam goɗɗam. ");
INSERT INTO fue_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","No jommanjo jenŋi waray, ɓe fu ɓe ŋoŋi, ɓe ɗaani. ");
INSERT INTO fue_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Faa caka jemma, huuɓaaŋo nanaa, wi'i: ‟Jommanjo gorko nani, burtee, pottee e makko!” ");
INSERT INTO fue_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Den ɓe fu ɓe pini, ɓee moƴƴina fitillaaji maɓɓe. ");
INSERT INTO fue_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Gati joy ŋaaɓiiɗi wi'i banniraaɓe mum ƴoƴuɓe: ‟Kokkoree men nebbam mooɗon seɗɗa, gam fitillaaji amen na'on nyifa.” ");
INSERT INTO fue_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ƴoƴuɓe toontii ɓe, wi'i: ‟Aawo nebbam ɗam men goodi heƴataa en, en fu. Jahee to sippooɓe, coodee ɗam mooɗon!” ");
INSERT INTO fue_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","No ɓe jawti soodoygo nebbam, jommanjo gorko yottii. Waɗunooɓe siri mum naatidi e makko der wuro to ɓangal waɗata, den dammugal maɓɓaa. ");
INSERT INTO fue_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","No ɓooyi seɗɗa, joyo horiiɓe wittoy, e huuɓa, e wi'a: ‟Joomiraawo, Joomiraawo, maɓɓitan men!” ");
INSERT INTO fue_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Amma o toontii ɓe, o wi'i: ‟E gooŋa batanmi on, mi annaa on.” ");
INSERT INTO fue_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Gam majjum Yeesu wi'i: «Deenee, gam on annaa nyalaane, ɗum bo wakkatiire de Ɓii neɗɗo warata.» ");
INSERT INTO fue_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","«Ɗum nandan hande gorko gom ciriyiiɗo waɗa jahaaŋal. Den o noddi gollotooɓe makko, o yowani ɓe jawdi makko. ");
INSERT INTO fue_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","O hokki arano maɓɓe ceede cardi keme joy, ɗiɗaɓo, ceede cardi keme ɗiɗi, tataɓo bo, ceede cardi hewre, moy fu jaka baawɗe mum. Den o yawti genni makko. ");
INSERT INTO fue_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ɗon maa ɗon, gollotooɗo kokkaaɗo ceede cardi keme joy, yahi tenkorii ɗe, ɗe diibi ceede cardi keme joy goɗɗe. ");
INSERT INTO fue_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Kokkaaɗo ceede cardi keme ɗiɗi bo, waɗi hande non, kanko bo o riibii ceede cardi keme ɗiɗi goɗɗe. ");
INSERT INTO fue_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Amma kokkaaɗo ceede cardi hewre, yahi wasi gayka, uwi ɗon ceede joomiraawo mum hokki ɗum. ");
INSERT INTO fue_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","No ɓooyi, joomiraawo maɓɓe warti, noddi ɓe, ɓe liiso, ɓe kolla no moy maɓɓe fu waɗiri golle mum. ");
INSERT INTO fue_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Kokkaaɗo ceede cardi keme joy wari, waddi ceede cardi keme joy goɗɗe, wi'i: ‟Joomiraawo, ceede cardi keme joy ɗe kokkuɗaa am riibake keme joy goɗɗe.” ");
INSERT INTO fue_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Joomiiko wi'i mo: ‟Golle maa wooɗii sanne, an gollotooɗo geeto, koolaaɗo. No a laatike koolaaɗo e huune ko faanɗi, mi hokkete ko ɓuri ɗum mawnugo. War naatu ceyodoɗaa e am!” ");
INSERT INTO fue_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Gollotooɗo kokkanooɗo ceede cardi keme ɗiɗi wari kanun bo, wi'i: ‟Joomiraawo, ceede cardi keme ɗiɗi ɗe kokkuɗaa am riibake ceede cardi keme ɗiɗi goɗɗe.” ");
INSERT INTO fue_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Joomiiko wi'i mo: ‟Golle maa wooɗii sanne, an gollotooɗo geeto, koolaaɗo. No a laatike koolaaɗo e huune ko faanɗi, mi hokkete ko ɓuri ɗum mawnugo. War naatu ceyodoɗaa e am!” ");
INSERT INTO fue_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Kokkaaɗo ceede cardi hewre wari kanun bo, wi'i: ‟Joomiraawo, mii anni a laati nun neɗɗo caɗuɗo: Aa rugga ko a aaway, aa ɓotta ko a hawritay. ");
INSERT INTO fue_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Gam majjum kulumi, jahum cuuɗoymi ceede maa der leydi. Jaɓu ceede maa!” ");
INSERT INTO fue_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Joomiiko toontii mo, wi'i: ‟An gollotooɗo kalluɗo, ciiwaakuujo! Aa annunoo mii rugga ko mi aaway, mii ɓotta ko mi hawritay, ");
INSERT INTO fue_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","den, ume waɗi ko a wattay ceede am der banki, to mi wartiino mi jaɓanno ɗe e riiba majje. ");
INSERT INTO fue_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Teetee ceede makko ɗen, kokkon gooduɗo ceede cardi keme joy. ");
INSERT INTO fue_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Gam gooduɗo nun ɓeydantee faa ɗuuɗa. Amma mo woodaa, baa seɗɗa ko woodi teetete. ");
INSERT INTO fue_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Gollotooɗo mo nafataa on, paɗɗee mo yaasi der niwre, o wulla ton, o ƴakkontira nyiiƴe.” ");
INSERT INTO fue_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","«To Ɓii neɗɗo warii e tedduŋal mum e malaykaaɓe fu, o jooɗoto dow kittaal laamaare makko ŋal tedduŋal. ");
INSERT INTO fue_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Himɓe lenyi duuniyaaru fu, hawritinto yeeso makko. O seenniran himɓe hande no duroowo seennirta baali e be'i. ");
INSERT INTO fue_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","O resan baali, junŋo makko nyaamo, o resa be'i bo, junŋo makko nano. ");
INSERT INTO fue_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Den, laamiiɗo wi'an wonuɓe junŋo mum nyaamo: ‟Garee, onon ɓe Baaba am barkiɗini, jaɓee donŋu laamaare ne ciriyanaɗon diga fuɗɗoode duuniyaaru. ");
INSERT INTO fue_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Gam rafo waɗii am, on nyaannii am, mi ɗonɗaama, on jarnii am, mi laatino koɗo, on bernii am. ");
INSERT INTO fue_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Mi wonake funtu, on koltinii am, mi nyawii, on nyawtii am, mi maɓɓaamaa der kasu, on daaroyii am.” ");
INSERT INTO fue_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Den, foonnitiiɓe toontoto mo, wi'a: ‟Joomiraawo, dey men ji'u maa aa rafi, men nyaannu maa, naa dey men ji'u maa aa ɗonɗii, ko men jarnu maa? ");
INSERT INTO fue_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Dey men ji'u maa aa laatii koɗo, men beernu maa, naa dey men ji'u maa aa woni funtu go men koltin maa? ");
INSERT INTO fue_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Dey men ji'u maa aa nyawi naa bo aa maɓɓaa der kasu, men daaroy ma?” ");
INSERT INTO fue_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Laamiiɗo on toontoto ɓe, wi'a: ‟E gooŋa batanmi on: ko gaɗanɗon gooto der ɓuruɗo faanɗugo caka sakikiraaɓe am ɓee, min nun gaɗanɗon ɗum.” ");
INSERT INTO fue_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Ɓaawo majjum, o wi'an wonuɓe junŋo makko nano: ‟Dillee woɗɗi am, onon ya'aaɓe! Naatee der yiite tabitiiŋe, desanaaŋe Ibiliisa e malaykaaɓe mum! ");
INSERT INTO fue_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Gam rafo waɗii am, on nyaannay am, ɗonka waɗii am, on jarnay am, ");
INSERT INTO fue_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","mii laatino koɗo, on beerinay am, mi wonino funtu, on koltinay am, mi nyawii, maɓɓaami der kasu, on daaray am.” ");
INSERT INTO fue_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Den, ɓe toontoto mo kamɓe bo, ɓe bi'a: ‟Joomiraawo, dey men ji'i rafo e waɗee, ɗum bo ɗonka e waɗee, maa bo aa laatii koɗo, naa bo aa woni funtu, maa bo aa nyawi, naa aa maɓɓaa der kasu, ko men ballay maa?” ");
INSERT INTO fue_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","O toontoto ɓe o wi'a: ‟E gooŋa batanmi on: ko on gaɗanay gooto der ɓuruɓe faanɗugo, min woni on gaɗanay ɗum.” ");
INSERT INTO fue_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Den kamɓe, ɓe jahan der ɓillaare tabitiine, amma foonnitiiɓe heɓan yonki tabitiiki.» ");
INSERT INTO fue_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","No Yeesu heennyi waɗugo fillaaji ɗin fu, o wi'i aahiiɓe makko: ");
INSERT INTO fue_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«Oon anni balɗe ɗiɗi nun horii go juulɗe Paska waɗa, Ɓii neɗɗo bo wattete e juuɗe himɓe, ɓe tigga mo dow leggal palaaŋal.» ");
INSERT INTO fue_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Wakkati mum, hooreeɓe limaamiiɓe e dottiiɓe waɗi hawriine der wuro hooreejo limaamiiɓe, bi'eteeɗo Kayafas. ");
INSERT INTO fue_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ɓe nannantiri ɓe nanŋa Yeesu e ƴoyre, ɓe bara mo. ");
INSERT INTO fue_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Amma ɓe bi'i: «To en gaɗee ɗum wakkati juulɗe, gam to himɓe ummin fitina caka jama'aare.» ");
INSERT INTO fue_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yeesu e wonuno Baytaniya der wuro Simon ceccefo. ");
INSERT INTO fue_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","No ɓe nyaamata, ɗon debbo gom ɓattii Yeesu, e jogii faanu gaɗiraaŋol hayre albaatiri kebbuŋol wardi, ɗam ceede ɗuuɗɗe. O waanji ɗam dow hoore Yeesu. ");
INSERT INTO fue_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","No aahiiɓe makko yi'i ɗum, ɓerɗe maɓɓe welay, ɓe bi'i: «Gam ume wardi ɗam biisaa baanji? ");
INSERT INTO fue_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ɗam waaweteno sippeego ceede ɗuuɗɗe, ɗe ceennanee talakaaɓe.» ");
INSERT INTO fue_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yeesu faanti ko ɓe batannoo, wi'i ɓe: «Gam ume ko oon toora debbo on? O waɗanii am golle booɗɗe. ");
INSERT INTO fue_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Gam talakaaɓe e wondi e mooɗon wakkati fu. Amma min, mi wondataa e mooɗon wakkati fu. ");
INSERT INTO fue_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","O moomii ɓannu am wardi, gam siryaago uwol am. ");
INSERT INTO fue_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","E gooŋa batanmi on: To linjiila waajetee e duuniyaaru ɗo fu, ko debbo on waɗi batante, siwtorte bo.» ");
INSERT INTO fue_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Den Yahuuda Iskariyot, gooto der aahiiɓe sappo e ɗiɗo, yahi to hooreeɓe limaamiiɓe. ");
INSERT INTO fue_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","O wi'i ɓe: «Ume kokkoton am to mi wattanii on Yeesu der juuɗe mon?» Ɓe limi ceede cardi laso e sappo, ɓe kokki mo. ");
INSERT INTO fue_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Diga wakkati majjum, oo daarta laabi no o jammortoo Yeesu. ");
INSERT INTO fue_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Nyalaane arandeere, der juulɗe peen ko ƴuufinaaka, aahiiɓe Yeesu wari, ƴami mo, wi'i: «Toy jiɗuɗaa men ciriyanee hiraane Paska?» ");
INSERT INTO fue_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","O toontii ɓe, o wi'i: «Jahee siire, naaton wuro waane, bi'on mo: “Moodibbo wi'i, wakkati mum faanike, der wuro maaɗa nun o nyaamata juulɗe Paska e aahiiɓe makko.”» ");
INSERT INTO fue_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Aahiiɓe waɗi ko Yeesu bati ɗum, ɓe ciryii hiraane Paska. ");
INSERT INTO fue_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","No kiikiiɗe waɗi, o jooɗodii e aahiiɓe makko sappo e ɗiɗo, ɓee nyaama. ");
INSERT INTO fue_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Wakkati ɓe nyaamata, Yeesu wi'i ɓe: «E gooŋa batanmi on: gooto mooɗon jammoto am.» ");
INSERT INTO fue_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ɓerɗe maɓɓe biisii puy, go ɓee ƴama mo gooto gooto, moy fu e wi'a: «Joomiraawo, min bane hinaa?» ");
INSERT INTO fue_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","O toontii ɓe, o wi'i: «Tummidinɗo junŋo mum e am der heeɗo, joomum nun jammotoo am. ");
INSERT INTO fue_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","E gooŋa Ɓii neɗɗo dillan hande no Dewte bati dow makko. Amma bone woodani jammiiɗo mo! To o rimaakano, ɗum ɓurananno mo wooɗugo.» ");
INSERT INTO fue_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yahuuda, jammotooɗo mo, ƴami mo, wi'i: «Moodibbo, min nun naa?» O toontii mo, o wi'i: «A batii ka.» ");
INSERT INTO fue_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","No ɓe nyaamata, Yeesu etti peen, yetti Alla, ŋappiti, hokki aahiiɓe mum, wi'i: «Jaɓee, nyaamee, kanjum woni ɓannu am.» ");
INSERT INTO fue_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ɓaawo majjum, o etti jarirgel innabojam, o yetti Alla, o hokki ɓe, o wi'i: «Jaree on fu. ");
INSERT INTO fue_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Kanjam laatii ƴiiƴam am, ƴiiƴam alkawal, deƴƴitiiɗam gam yaafuye hakkeeji himɓe ɗuuɓɓe. ");
INSERT INTO fue_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Mii wi'a on: Mi yarataa innabojam ɗam kade faa abada, sey nyalaane jaridanmi kesam e mooɗon, der Laamaare Baaba am.» ");
INSERT INTO fue_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ɓaawo ɓe jimi jimol, ɓe burtii, ɓe jahi waanne Jaytuuje. ");
INSERT INTO fue_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Den Yeesu wi'i aahiiɓe mum: «Jemmaare nee ɗo, on fu, on accan am, gam e winnaa der dewtere: ‟Mi fiyan duroowo, den hoggo baali sankito.”» Yeesu ɓeydi, wi'i: ");
INSERT INTO fue_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","«Amma ɓaawo to mi fintii, mi artan on Galili.» ");
INSERT INTO fue_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Den Piyer, wi'i mo: «Baa to ɓe fu ɓe accii maa, min kan mi accataa maa pay.» ");
INSERT INTO fue_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yeesu toontii mo, wi'i: «E gooŋa batan maa mi: Jemmaare nee ɗo, ko jakaraari jogga, a wi'an de tati a annaa am.» ");
INSERT INTO fue_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Piyer wi'i mo: «Baa to doole mi maayida e maa, mi wi'ataa pay mi annaa maa.» Aahiiɓe fu wi'i, hande non. ");
INSERT INTO fue_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ɓaawo majjum, Yeesu e aahiiɓe mum yottii nokkuure wi'eteene Gesemane. O wi'i ɓe: «Jooɗee ɗo, faa mi waɗaa du'aare.» ");
INSERT INTO fue_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","O yaadi e Piyer, e ɓiɓɓe Jebede ɗiɗo, ko ɓerne makko fuɗɗi biisaago, oo maata toora ɓerne puy. ");
INSERT INTO fue_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Den o wi'i ɓe: «Biisere ɓerne sattanii am faa e yiɗi warugo am. Gonee ɗo, deenidee e am.» ");
INSERT INTO fue_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","O woɗɗii seɗɗa, o yani o hippii e leydi, oo du'oo, oo wi'a: «Baaba, to waɗoto, woɗɗinanam jarirgel toora kaa. Amma ko jiɗuɗaa laatoo, hinaa ko jiɗumi.» ");
INSERT INTO fue_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","O wittoy, o tawi ɓee ɗaani. O wi'i Piyer: «On baaway ko reenidi e am baa yanne woore na? ");
INSERT INTO fue_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","To on ɗaane, du'ee, gam to on janee der jarbeeji. Gam ɓerne e yiɗi, amma ɓannu tampii.» ");
INSERT INTO fue_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","O witti du'aago kade de ɗiɗawre, o woɗɗii seɗɗa, o wi'i: «Baaba, to waɗataako jarirgel toora ŋel yawta, mi yariray ŋel, den, accu yidde maa laatoo!» ");
INSERT INTO fue_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Yeesu wittoy kade, o tawi ɓe ɓee ɗaani, gam ɗoyŋol e jogii ɓe puy. ");
INSERT INTO fue_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","O acci ɓe kade, o witti du'aago de tatawre e boliiɗe goote ɗen. ");
INSERT INTO fue_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ɓaawo majjum, o wittoy to aahiiɓe makko, o wi'i ɓe: «Faa jooni on na'on ɗaani, oon ciwtii na? Wakkati waɗii! Ɓii neɗɗo wattete der juuɗe hakkeeɓe. ");
INSERT INTO fue_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ummee jawten! Jammotooɗo am nani wara!» ");
INSERT INTO fue_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yeesu heennyay batugo, go Yahuuda, gooto der aahiiɓe makko sappo e ɗiɗo yottii, e himɓe ɗuuɓɓe, jogiiɓe kaafaaje, e cabbi. Hooreeɓe limaamiiɓe, e dottiiɓe nun liloy ɓe. ");
INSERT INTO fue_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Jammotooɗo mo on tintiniinoo ɓe maane, wi'i: «Neɗɗo mo cannumi e mammilaaɗe fu, kanko nun ɗon. Nanŋee mo.» ");
INSERT INTO fue_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ɗon maa ɗon, Yahuuda ɓattii Yeesu, wi'i mo: «Jam kirɗen Moodibbo!» Den o mammilii mo. ");
INSERT INTO fue_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yeesu toontii mo, wi'i: «Igo am, waɗu ko waddu maa.» Himɓe ɓen ɓattii, watti Yeesu junŋo, nanŋi mo. ");
INSERT INTO fue_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Den gooto der wondunooɓe e Yeesu solti kaafahi mum, jabbi maccuɗo hooreejo limaamiiɓe, setti nowru, ");
INSERT INTO fue_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","go Yeesu wi'i mo: «Wittin kaafahi maa der kuunŋal mum, gam kaɓiroowo e kaafahi, e kaafahi nun joomum halkirta. ");
INSERT INTO fue_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Aa miili mi waawataa ko noddi Baaba am lildanaanmi ko ɓuri malaykaaɓe konunkeeɓe ukke sappo e ɗiɗi ɗon maa ɗon na? ");
INSERT INTO fue_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Amma to ɗum laataaki non, noy ko winnaa der Dewtere hebbirta? Gam dewtere wi'i, non ɗum laatotoo.» ");
INSERT INTO fue_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Den, Yeesu wi'i jama'aare: «Daa on garii nanŋugo am e kaafaaje, e cabbi hande pasotooɗo ni. Der suudu Alla bane gonunoomi de weeti fu, emi janŋina, go on nanŋay am? ");
INSERT INTO fue_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Amma huune ɗum fu waɗii gam ko winnaa der dewte annabiiɓe hebba.» Den, aahiiɓe makko fu doggi, acci mo. ");
INSERT INTO fue_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Nanŋuɓe Yeesu ɓen yaari mo to Kayafas hooreejo limaamiiɓe, go moodiɓɓe tawreeta, e dottiiɓe genni, hawritii. ");
INSERT INTO fue_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Piyer e tokki mo ɓawɓawre, diga woɗɗi, faa der fageere wuro hooreejo limaamiiɓe. O naati, o jooɗodii e reenuɓe gam o yi'a no ɗum heennyitirta. ");
INSERT INTO fue_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Hooreeɓe limaamiiɓe, e dawrooɓe fu, e daarta fewre ne ɓe gaccorto Yeesu gam o waree. ");
INSERT INTO fue_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Himɓe ɗuuɓɓe wari seedii fewre dow makko, amma ɓe keɓay gacce potuɗe warugo mo. Den, worɓe ɗiɗo gom wari, seedii ");
INSERT INTO fue_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","wi'i: «Kanko nun wi'unoo pusan suudu Alla, mahitoo ŋol der balɗe tati.» ");
INSERT INTO fue_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Hooreejo limaamiiɓe ummii, wi'i Yeesu: «A toontataako gokka na? A nanay ka ɓe batata dow maa na?» ");
INSERT INTO fue_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Amma Yeesu toontaaki gokka. Hooreejo limaamiiɓe on wi'i mo: «Mii eele e inne Alla yonkinteejo, batu men to an nun woni Almasiihu, Ɓiɗɗo Alla.» ");
INSERT INTO fue_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yeesu toontii mo, wi'i: «A batii ka. Ka batanmi woni: Diga jooni, on ji'an Ɓii neɗɗo e jooɗii nyaamo Jom Baawɗe, o waran diga dow kammu.» ");
INSERT INTO fue_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Den, mone waɗi hooreejo limaamiiɓe faa serkiti toggoore mum, wi'i: «O batii kalluka dow Alla! En kaajaaka seedeeɓe gom kade! On nanii e noppi mooɗon kalluka ka o bati. ");
INSERT INTO fue_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ume ji'uɗon?» Ɓe toontii, ɓe bi'i: «Emo haani wareego.» ");
INSERT INTO fue_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Den, ɓe tuuti mo joode e yeeso, ɓee piya mo guƴƴe. Woɓɓe maɓɓe e fiya mo meeƴe, ");
INSERT INTO fue_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","e wi'a: «Almasiihu! Tinta, moy nun fiyu maa.» ");
INSERT INTO fue_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Piyer e jooɗii yaasi fageere wuro. Horɓe tawaaɓe ɗon, gooto mum, ɓattii mo, wi'i: «An bo, aa wondunoo e Yeesu Galilinkeejo.» ");
INSERT INTO fue_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Amma Piyer yeddi ka yeeso himɓe fu, wi'i: «Mi faamay ko jiɗuɗaa wi'ugo.» ");
INSERT INTO fue_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ɓaawo majjum, o ummii oo foonnii far dammugal wuro. Korɗo goɗɗo yi'i mo, wi'i wonɓe ɗon: «Gorko oo ɗo e wondunoo e Yeesu Nasaratuujo.» ");
INSERT INTO fue_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Piyer yeddi kade, wi'i: «Mi hunike, mi annaa gorko on.» ");
INSERT INTO fue_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","No waɗi tifere, wonuɓe ɗon ɓattii Piyer, wi'i mo: «Seko walaa, a laati nun gooto der aahiiɓe makko, gam batu maa e hollita to ƴiwuɗaa.» ");
INSERT INTO fue_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Den, Piyer hunii wi'i: «Alla hiitoo am to mi fewii, e gooŋa mi annaa gorko on!» Wakkati mum, jakaraari joggi. ");
INSERT INTO fue_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Den Piyer siwtorii ka Yeesu batunoo ɗum, wi'i: «Go jakaraari jogga, a wi'an de tati a annaa am.» O wurtii yaasi, o wulli bojji kaaɗuɗi. ");
INSERT INTO fue_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Subaka kecco, hooreeɓe limaamiiɓe, e dottiiɓe fu, hawritii e dawra dow no ɓe barirta Yeesu. ");
INSERT INTO fue_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ɓe kaɓɓi mo, ɓe jaari to Pilaatu, hooreejo jeyde leydi Yahudiya. ");
INSERT INTO fue_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","No Yahuuda jammiiɗo Yeesu yi'i o hiitaama o waree, o miijitii, o wittini ceede cardi laso e sappo ɗe o jaɓunoo to hooreeɓe limaamiiɓe, e dottiiɓe, ");
INSERT INTO fue_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","o wi'i ɓe: «Mi waɗii hakke, mi jammike mo walaa gacce!» Ɓe toontii mo, ɓe bi'i: «Ko faalii men? Haala maa nun!» ");
INSERT INTO fue_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yahuuda woppi ceede ɗen der suudu Alla, yahi haɓɓitoyii ɓoggol, maayi. ");
INSERT INTO fue_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Hooreeɓe limaamiiɓe etti ceede ɗen, wi'i: «Sariya meeɗen hokkay laawol ceede hande ɗee ɗo hawritee e ceede cakkanaaɗe Alla der suudu Alla, gam ceede ƴiiƴam nun.» ");
INSERT INTO fue_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ɓaawo dawriine maɓɓe, ɓe nannantiri, ɓe etti ceede ɗen, ɓe coodiri gesa mahoowo payanɗe gom, gam hoɓɓe e uwee ton. ");
INSERT INTO fue_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Kanjum acci faa hanne, gesa ŋan e noddee «Gesa Ƴiiƴam.» ");
INSERT INTO fue_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Hande non annabaaku Yeremiya hebbiri, ŋu o waɗunoo, o wi'i: «Ɓe ettii ceede cardi laso e sappo, kanje nun himɓe Isira'iila tawi o foti yoɓaneego. ");
INSERT INTO fue_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ɓe coodirii ɗe gesa mahoowo payanɗe, hande no Joomiraawo batunoo am.» ");
INSERT INTO fue_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ɓe jaari Yeesu yeeso Pilaatu hooreejo leydi, o ƴami mo, o wi'i: «An woni laamiiɗo Yahuduuɓe na?» Yeesu toontii mo wi'i: «A batii ka.» ");
INSERT INTO fue_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Den hooreeɓe limaamiiɓe, e dottiiɓe gaccii mo, amma o toontaaki gokka. ");
INSERT INTO fue_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ko Pilaatu wi'i mo: «A nanataa gacce ɗe ɓe batata dow maaɗa fu na?» ");
INSERT INTO fue_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Amma Yeesu toontaaki gokka mum. Ɗum haaynii hooreejo leydi on sanne. ");
INSERT INTO fue_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Der Juulɗe Paska fu, hooreejo leydi e woowi yoofango ɓe maɓɓaaɗo gooto, mo himɓe yiɗi. ");
INSERT INTO fue_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Wakkati mum, e woodunoo maɓɓaaɗo annanaaɗo, bi'eteeɗo Yeesu Barabbas. ");
INSERT INTO fue_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","No jama'aare hawritii, Pilaatu ƴami ɓe, wi'i: «Moy jiɗuɗon mi yoofana on: Yeesu Barabbas na, naa Yeesu bi'eteeɗo Almasiihu?» ");
INSERT INTO fue_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilaatu e anni sabbu nawniraagu nun waɗi ko ɓe nanŋi Yeesu ɓe gaddi to mum. ");
INSERT INTO fue_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Wakkati Pilaatu jooɗii e hiitoo, deekiiko lili goɗɗo, wi'a mo: «Taa naannu hoore maa der haala gorko mo walaa gacce oo, gam hanki mi toorake der koyɗool dow haala makko.» ");
INSERT INTO fue_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Hooreeɓe limaamiiɓe, e dottiiɓe yeeƴi jama'aare, ɓe ƴama Pilaatu yoofana ɓe Barabbas, acca Yeesu waree. ");
INSERT INTO fue_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Hooreejo leydi on ƴamitii ɓe, wi'i: «Mi yoofanan on maɓɓaaɗo gooto, moy nun der ɗiɗo ɓen jiɗuɗon mi yoofana on?» Ɓe toontii, ɓe bi'i: «Barabbas!» ");
INSERT INTO fue_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilaatu ƴami ɓe, wi'i: «Den, noy gaɗanmi Yeesu bi'eteeɗo Almasiihu?» Ɓe fu ɓe toontii, ɓe bi'i: «Tiggu mo dow leggal palaaŋal!» ");
INSERT INTO fue_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","O ƴami ɓe, o wi'i: «Ko boni ume o waɗi?» Ɓe ɓeydi woolo e semme, ɓee bi'a: «Tiggu mo dow leggal palaaŋal!» ");
INSERT INTO fue_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilaatu tawi waawataa ko deƴƴitini ɓe, woolo bo e ɓeydoo. Den o etti diyam, o looti juuɗe makko yeeso jama'aare, o wi'i ɓe: «Mi walaa gacce dow reƴƴitingo ƴiiƴam gorko oo. Haala mooɗon nun.» ");
INSERT INTO fue_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ɓe fu ɓe toontii, ɓe bi'i: «Men jaɓii gacce ƴiiƴam makko yowoo dow ko'e amen, e dow ɓiɓɓe amen!» ");
INSERT INTO fue_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Den, Pilaatu yoofitani ɓe Barabbas, o hokki laawol Yeesu fiyee looci, ɓaawo mum, o tiggee dow leggal palaaŋal. ");
INSERT INTO fue_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Soogeeji hooreejo leydi yaari Yeesu der fageere laamorde mum, ukkere soogeeji ɗin fu hawritii e tummi mo. ");
INSERT INTO fue_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ɓe ɓorti gineeji makko, ɓe ɓorni mo gulunfaare woɗeere. ");
INSERT INTO fue_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ɓaawo majjum, ɓe canyi huuneere gi'e, ɓe kuunini mo. Ɓe kokki mo helliiru e junŋo makko nyaamo, ɓee jiccoo yeeso makko, ɓee jaanca mo, ɓee bi'a: «Foo foo maa, laamiiɗo Yahuduuɓe!» ");
INSERT INTO fue_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ɓe tuuti mo joode, ɓe teeti helliiru ŋol, ɓee piya mo dow hoore. ");
INSERT INTO fue_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","No ɓe keennyi jaancugo mo, ɓe ɓorti gulunfaare, ɓe ɓorni mo gineeji makko. Den, ɓe jaari mo ɓe tiggaa dow leggal palaaŋal. ");
INSERT INTO fue_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","No ɓe burtoto siire, ɓe potti e gorko bi'eteeɗo Simon mo Sirene. Soogeeji dooli mo o roono leggal Yeesu palaaŋal. ");
INSERT INTO fue_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ɓe jottii nokkuure wi'eteene Golgota. Maana Golgota woni (nokkuure le'al hoore). ");
INSERT INTO fue_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ɓe kokki Yeesu innabojam jillontiraaɗam e kaaɗuɗum, o yara. No o metti ɗam, o salii yarugo. ");
INSERT INTO fue_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","No ɓe keennyi tiggugo mo, ɓe piɗani gineeji makko tete, ɓe ceenniri. ");
INSERT INTO fue_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ɓaawo majjum, ɓe jooɗii ɗon, ɓee deeni mo. ");
INSERT INTO fue_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ɓe binni dow alluwal daliila ko acci o tiggaa, ɓe takki dow hoore makko. Ko ɓe binni woni: «Oo ɗo woni Yeesu, laamiiɗo Yahuduuɓe.» ");
INSERT INTO fue_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Fasotooɓe ɗiɗo gom bo e tiggaa takkol makko, gooto nyaamo makko, gooto bo nano makko. ");
INSERT INTO fue_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Himɓe falotooɓe ɗon e yenna mo, e dimma ko'e mum, ");
INSERT INTO fue_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","e wi'a: «An pusoowo suudu Alla, mahitoo ŋol der balɗe tati, faaba hoore maa. To a laati nun Ɓiɗɗo Alla, jippa diga e leggal palaaŋal ŋal!» ");
INSERT INTO fue_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Hande non, hooreeɓe limaamiiɓe, e moodiɓɓe tawreeta, e dottiiɓe fu jaanciri mo, e wi'a: ");
INSERT INTO fue_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«O faabike woɓɓe, amma o waaway ko faabii hoore makko, kanko laamiiɗo Isira'iila. Jooni, o jippoo diga leggal palaaŋal ŋal, gam goonɗinen mo. ");
INSERT INTO fue_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","O yowii hoolaare makko fu dow Alla. To non Alla faaboo mo jooni, to e yiɗi mo. Gam o wi'i, o laati nun Ɓiɗɗo Alla.» ");
INSERT INTO fue_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Fasotooɓe, tiggaaɓe takkol makko bo e yenna mo hande non. ");
INSERT INTO fue_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Diga caka nyalooma, niwre waɗi e leydi nin fu, faa yottii yanne tati kiikiiɗe. ");
INSERT INTO fue_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Jaka yanne tati kiikiiɗe, Yeesu halɓi e semme, wi'i: «Eloyi, Eloyi, lama sabaktani?» Kan woni «Alla am, Alla am! Gam ume accuɗaa am?» ");
INSERT INTO fue_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Woɓɓe der darinooɓe ɗon no nani ɗum, wi'i: «Emo nodda Eliya!» ");
INSERT INTO fue_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ɗon maa ɗon, gooto maɓɓe doggi waddoy soosuuji, suuwi ɗi der jaran lammuɗam, haɓɓi e sawru, ɓattini to hunnuko Yeesu gam o ɓiccinoo. ");
INSERT INTO fue_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Den horiiɓe wi'i: «Munyen, daaren naa Eliya waran faaboo mo.» ");
INSERT INTO fue_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ɓaawo majjum, Yeesu halɓi e semme, o maayi. ");
INSERT INTO fue_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Wakkati mum, wudere wirniraane der suudu Alla serkitii caka caka, diga dow faa ley. Leydi dimmii, tepaaje feccii, ");
INSERT INTO fue_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","jenaale maɓɓitii, seniiɓe ɗuuɓɓe maayunooɓe finti. ");
INSERT INTO fue_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ɓe burtii e jenaale. Ɓaawo mum, Yeesu finti, ɓe naatidi e genni seniini, himɓe ɗuuɓɓe yi'i ɓe. ");
INSERT INTO fue_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Hooreejo soogeeji deenuɗo Yeesu, e soogeeji mum, yi'i dimmaaɗe leydi e ko waɗi fu. Ɓe kuli puy, ɓe bi'i: «E gooŋa, o laati nun Ɓiɗɗo Alla!» ");
INSERT INTO fue_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Rewɓe ɗuuɓɓe e tawaa ɗon e daara diga woɗɗi, kamɓe nun tokkoynoo mo diga Galili, ɓee jagganoo mo. ");
INSERT INTO fue_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Der maɓɓe: E woodi Mariyama mo Magadala, e Mariyama inna Yaakuuba e Yusufu, e inna ɓiɓɓe Jebede. ");
INSERT INTO fue_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","No kiikiiɗe waɗi, gorko jom jawdiijo gom, mo siire Arimatiya, wari. Emo wi'ee Yusufu, kanko bo o laati nun aahiijo Yeesu. ");
INSERT INTO fue_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","O yahi to Pilaatu, o eeli ɗum ɓannu Yeesu. Den, Pilaatu wi'i o hokkee ŋol. ");
INSERT INTO fue_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yusufu etti ɓannu ŋol, suddi ŋol wudere heyre, ");
INSERT INTO fue_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","o watti ɓannu ŋol der saabeere heyre ne o wasani hoore makko der hayre. Ɓaawo mum, o talli hayre teddune, o maɓɓiri dammugal saabeere nen, o yawti. ");
INSERT INTO fue_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mariyama Magadalaajo, e Mariyama oo to, e tawaa ɗon, e jooɗi e daari far to saabeere nen. ");
INSERT INTO fue_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Fini mum laatii nyalaane ardiine nyalaane siwteteene. Den hooreeɓe Limaamiiɓe e Farisaaɓe hawritii yahi to Pilaatu. ");
INSERT INTO fue_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ɓe bi'i mo: «Joomiraawo, men ciwtorii pewoowo on batiino diga e wuuri, wi'i, fintan nyalaane tatawre. ");
INSERT INTO fue_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Gam majjum, batu soogeeji reena saabeere nen faa balɗe tati ɗen yawta. Gam to aahiiɓe makko wujju ɓannu makko, wi'a, o fintii diga maayɓe. Den fewre sakitiineere nen ɓuran arandeere hallugo.» ");
INSERT INTO fue_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilaatu wi'i ɓe: «Soogeeji nani, jahee, deenee saabeere nen no baawirɗon!» ");
INSERT INTO fue_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ɓe jahi, ɓe deenoy saabeere nen. Ɓe talli hayre, ɓe maɓɓi faa wooɗi, ɓe darini soogeeji gam reena ne. ");
INSERT INTO fue_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","No nyalaane siwteteene yawti, alal subaka, Mariyama Magadalaajo e Mariyama oo to dawi, yahi daaroygo saabeere nen. ");
INSERT INTO fue_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ɗon de woore, leydi dimmii e semme. Malaykaajo Joomiraawo jippii diga dow kammu, talli hayre nen, jooɗii dow mayre. ");
INSERT INTO fue_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Oo jalbitoo hande maaƴƴere, gineeji makko e rawni hande malamalluuje. ");
INSERT INTO fue_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Reenuɓe ɓen huli faa e diwna, ɓe laatii hande maayɓe. ");
INSERT INTO fue_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Malaykaajo wi'i rewɓe ɓen: «To on kulee onon! Mii anni Yeesu tigganooɗo nun daartoton. ");
INSERT INTO fue_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","O walaa ɗo, o fintii hande no o wi'unoo on. Garee, daaree to o fukkinoo. ");
INSERT INTO fue_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Tinnee, batee aahiiɓe makko o fintii diga e maayde. O na'on heɗii on far Galili, on ji'an mo ton. Ka goodumi mi bata on nun ɗon.» ");
INSERT INTO fue_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Rewɓe ɓen yawti law diga to saabeere nen, go kulol e seyo waɗi ɓe puy. Ɓe doggi ɓe batoy aahiiɓe makko habaru on. ");
INSERT INTO fue_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ɗon maa ɗon, Yeesu fotti e maɓɓe, wi'i ɓe: «Mii sanna on!» Ɓe ɓattii mo, ɓe nanŋi koyɗe makko, ɓe cujidani mo. ");
INSERT INTO fue_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Den Yeesu wi'i ɓe: «To on kulee! Jahee, batee banniraaɓe am, ɓe jaha Galili. Ton nun ɓe ji'atammi.» ");
INSERT INTO fue_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Wakkati rewɓe ɓen yanti laawol, den woɓɓe der soogeeji deenuɗi saabeere nen naati e genni, e bata hooreeɓe limaamiiɓe ko waɗi fu. ");
INSERT INTO fue_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Hooreeɓe limaamiiɓe, e dottiiɓe waɗi hawriine, ɓe baddi, ɓe kokki soogeeji ɗin ceede ɗuuɗɗe, ");
INSERT INTO fue_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ɓe bi'i ɓe: «Bi'ee aahiiɓe makko nun wari jemma, tawi oon ɗaani, wujji ɓannu makko. ");
INSERT INTO fue_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","To hooreejo leydi nanii ka, minon nun anni ka batata mo, men burtina on e toora fu.» ");
INSERT INTO fue_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Soogeeji jaɓi ceede mum, waɗi no wi'aa. Hande non haala kan sankitorii caka Yahuduuɓe faa warugo hanne. ");
INSERT INTO fue_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Aahiiɓe sappo e go'o yahi Galili, dow waanne ne Yeesu tintinnoo ɓe ɓe jaha. ");
INSERT INTO fue_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","No ɓe ji'i mo, ɓe cujidani mo, amma woɓɓe maɓɓe waɗii seko. ");
INSERT INTO fue_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","O ɓattii, o wi'i ɓe: «Mi hokkaama baawɗe dow kammu e leydi fu. ");
INSERT INTO fue_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Gam majjum jahee, gaɗee himɓe lenyi fu aahiiɓe am, gaɗee ɓe batisi e inne Baaba e Ɓiɗɗo e Ruuhu Ceniiɗo. ");
INSERT INTO fue_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Janŋinee ɓe ɓe tokkoo ko batumi on fu. Annee, mii wondi e mooɗon nyalaane fu, faa timmoode duuniyaaru.» ");
INSERT INTO fue_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Diga fuɗɗoode, bi'eteeɗo Haala e wonunoo. Oo wondi e Alla, o laati nun Alla. ");
INSERT INTO fue_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Diga fuɗɗoode, oo wondi e Alla. ");
INSERT INTO fue_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","E makko Alla tagiri huune fu. Baa goɗɗum ko woni tagaaka to hinaa e makko. ");
INSERT INTO fue_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Yonki ƴiwii e makko, yonki kin laatanii himɓe jayŋol. ");
INSERT INTO fue_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Jaayŋol e yayna der niwre, niwre bo waaway ko nyifi ŋol. ");
INSERT INTO fue_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Wakkati gom, Alla lili goɗɗo bi'eteeɗo Yuhaana. ");
INSERT INTO fue_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","O warii gam o laato seedeejo, o waɗana jayŋol seedaaku, gam himɓe fu goonɗina sabbu haala makko. ");
INSERT INTO fue_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Kanko bane woni jayŋol, amma o waru nun gam o seedanoo jayŋol. ");
INSERT INTO fue_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Kanŋol woni jayŋol gooŋawol, garuŋol e duuniyaaru gam yaynana himɓe fu. ");
INSERT INTO fue_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Bi'eteeɗo Haala na'onno der duuniyaaru, e makko duuniyaaru tagiraa, amma himɓe duuniyaaru annitay mo. ");
INSERT INTO fue_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","O warii to himɓe makko, himɓe makko bo jaɓɓaaki mo. ");
INSERT INTO fue_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Amma jaɓɓiiɓe mo fu, ko goonɗinii inne makko, o hokkii ɗum laawol laataago ɓiɓɓe Alla. ");
INSERT INTO fue_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ɓe laataaki ɓiɓɓe Alla diga e dingol, e yidde tagaaɗo bo bane, amma gam Alla hokkii ɓe yonki kesi. ");
INSERT INTO fue_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Haala laatike neɗɗo. Neɗɗo on jooɗodii e meeɗen, oo hebbi moƴƴere e gooŋa. Men ji'ii tedduŋal makko, tedduŋal ŋal Ɓiɗɗo bajjo heɓata e baaba mum. ");
INSERT INTO fue_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yuhaana seedanii mo, bati e daane towne, wi'i: «Oo ɗo woni mo batannoomi on, bi'umi: Ɓaawo am, ɓurɗo am waran, gam o na'on diga mi walaano.» ");
INSERT INTO fue_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","E gonnan makko, en fu en keɓii moƴƴere dow moƴƴere. ");
INSERT INTO fue_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Diga e Muusa nun tawreeta hokkiraa, amma moƴƴere, e gooŋa warii diga e Yeesu Almasiihu. ");
INSERT INTO fue_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Goɗɗo yi'ay Alla abada, amma Ɓiɗɗo bajjo, laatiiɗo Alla, gonduɗo e Baaba nun annini en Alla. ");
INSERT INTO fue_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Yahuduuɓe Urusaliima lilii moodiɓɓe ƴiwuɓe e lenyol Lewinkeeɓe e Limaamiiɓe ɓe ƴama mo, kanko woni moy. ");
INSERT INTO fue_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","O toontii ɓe ko laaɓi. Nani ko o seedii: «Min, mi Cuɓaaɗo bane.» ");
INSERT INTO fue_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ɓe ƴamitii mo, ɓe bi'i: «Den kan, moy nun laatiɗaa an? An nun Eliya na?» O wi'i: «Min, mi Eliya bane.» Ɓe bi'i: «An nun Annabiijo batanaaɗo na?» O toontii: «Aawo, kanko bane laatiimi!» ");
INSERT INTO fue_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ɓe bi'i mo: «Den fu moy nun laatiɗaa? Batu men ko men batoyta liloyɓe men. Ko bi'uɗaa hoore maa?» ");
INSERT INTO fue_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","O toontii, o wi'i: «Min woni batoowo der haro e wi'a: “Moƴƴinee laawol Joomiraawo,” non annabi Esaaya wi'i.» ");
INSERT INTO fue_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Lilaaɓe ɓen laati nun Farisaaɓe. ");
INSERT INTO fue_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ɓe ƴami mo: «Ko woni sabbu ko aa waɗa batisi nani bo a Cuɓaaɗo bane, a Eliya bane, a Annabiijo batanaaɗo bane?» ");
INSERT INTO fue_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yuhaana toontii ɓe, wi'i: «Min, mii waɗira batisi e diyam, amma e woodi goɗɗo hakkune mooɗon mo on annaa, ");
INSERT INTO fue_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","kanko woni garoowo ɓaawo am, mi fotay baa fittugo ɓoggi paɗe makko.» ");
INSERT INTO fue_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ɗum ɗon fu waɗu nun Baytaniya, takkol maayo Urdun, to Yuhaana waɗannoo batisi. ");
INSERT INTO fue_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Fini mum, Yuhaana yi'i Yeesu e wara to mum, wi'i: «Nani Jawgiyel Alla ikkinoowel hakkeeji duuniyaaru. ");
INSERT INTO fue_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Kanko nun batannoomi, bi'umi: ‟Goɗɗo waran ɓaawo am, oo ɓurimmi, gam o na'on diga mi walaano.” ");
INSERT INTO fue_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Min, mi annaano mo. Amma mi warii, mii waɗa batisi e diyam gam mi holla mo himɓe Isira'iila.» ");
INSERT INTO fue_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Yuhaana seedii, wi'i: «Mi yi'ii Ruuhu hande foonu e jippoo diga dow, hoɗi dow makko. ");
INSERT INTO fue_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Min, mi annaano mo. Amma lilɗo am mi waɗa batisi der diyam, kanko nun wi'immi: “Mo ji'oytaa Ruuhu e jippoo dow mum, kanko woni gaɗiroowo batisi e Ruuhu Ceniiɗo.” ");
INSERT INTO fue_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Yuhaana wi'i: «Min, mi yi'ii, mi seedike, kanko woni Ɓiɗɗo Alla.» ");
INSERT INTO fue_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Fini mum, Yuhaana e darodii kade e aahiiɓe mum ɗiɗo. ");
INSERT INTO fue_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","O yi'i Yeesu e faloo, o wi'i: «Nani Jawgiyel Alla!» ");
INSERT INTO fue_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Aahiiɓe ɗiɗo ɓen nani ka o bati, tokki Yeesu. ");
INSERT INTO fue_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yeesu yeeƴitii, yi'i ɓee tokki ɗum, wi'i ɓe: «Ume daartoton?» Ɓe toontii, ɓe bi'i: «Rabbi (ɗum wi'ay maa Moodibbo), toy tawaɗaa?» ");
INSERT INTO fue_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","O wi'i ɓe: «Garee, daaree!» den ɓe gari, ɓe ji'i to o tawaa. Ɓe jooɗodii e makko nyalaane nen. Wakkati on, kiikiiɗe nun. ");
INSERT INTO fue_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andere, miiraawo Simon Piyer, woni gooto der ɗiɗo nanuɓe haala Yuhaana, ko tokkini Yeesu. ");
INSERT INTO fue_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Mawniraawo makko, Simon, o arti o fotti, o wi'i ɗum: «Men ji'ii Almasiihu.» (Ɗum wi'ay maa Cuɓaaɗo.) ");
INSERT INTO fue_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","O yaari mo to Yeesu. Yeesu daari Simon Piyer, wi'i mo: «An, a Simon ɓii Yuhaana, a innitirte Kefas.» (Ɗum wi'ay maa Hayre.) ");
INSERT INTO fue_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Fini mum Yeesu yiɗi yahugo Galili. O fotti e Filippu, o wi'i ɗum: «Tokkam!» ");
INSERT INTO fue_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filippu, mo Baytisayda nun, genni Andere e Piyer. ");
INSERT INTO fue_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","O fotti e Natanayel, o wi'i ɗum: «Men ji'ii mo haala mum batano der tawreeta Muusa e der dewte annabiiɓe. Yeesu ɓii Yusufu mo Nasaratu.» ");
INSERT INTO fue_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanayel wi'i mo: «Ko wooɗi waawan ko ƴiwi Nasaratu na?» Filippu toontii mo: «War, daaru!» ");
INSERT INTO fue_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yeesu yi'i Natanayel e fonnoy ɗum, wi'i: «Oo ɗo laati nun Isira'iilaajo lalley, jamma fu walaa e makko.» ");
INSERT INTO fue_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanayel wi'i mo: «Toy annuɗaa am?» Yeesu toontii mo, wi'i: «Mi yi'ii maa ley ibbi diga Filippu nodday maa.» ");
INSERT INTO fue_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanayel toontii, wi'i: «Moodibbo, a laati nun Ɓiɗɗo Alla, a Laamiiɗo Isira'iila nun.» ");
INSERT INTO fue_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yeesu toontii mo, wi'i: «Gam mi wi'ii mi yi'ii maa ley ibbi, kan acci ko goonɗinɗaa na? A yi'an ko ɓuri ɗum ɗon manŋu.» ");
INSERT INTO fue_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Den o wi'i Natanayel: «E gooŋa batan mi on: On ji'an duule e maɓɓitii, malaykaaɓe Alla e eenca e jippoo dow Ɓii neɗɗo.» ");
INSERT INTO fue_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Balɗe ɗiɗi ɓaawo mum, ɓangal waɗii e siire Kana, der leydi Galili. Inna Yeesu e tawanoo ton. ");
INSERT INTO fue_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yeesu e aahiiɓe mum bo noddinaama e jamaanu nu. ");
INSERT INTO fue_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","No innabojam maɓɓe jacci, inna Yeesu wi'i mo: «Ɓe galaa innabojam.» ");
INSERT INTO fue_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yeesu toontii mo, wi'i: «Inna day, taa accu ka ɓillee. Wakkati am yottaaki taw.» ");
INSERT INTO fue_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Den inniiko wi'i gollooɓe: «Ko o wi'i on fu, gaɗee.» ");
INSERT INTO fue_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Looɗe jeego'o gaɗiraaɗe kaaƴe e tawaa ɗon. Diyam majje Yahuduuɓe waɗiranno naŋarɗam gam laaɓingo ko'e mum, hande no diina maɓɓe bati. Looɗe ɗen, baaney mum fu e jaɓa ƴoogirɗe diyam sappo. ");
INSERT INTO fue_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yeesu wi'i ɓe: «Kebbinee payanɗe ɗen diyam.» Ɓe kebbini ɗe faa gaɓɓuɗe. ");
INSERT INTO fue_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","O wi'i ɓe: «Jooni kan, nyeɗee, jaaranee mawɗo ɓangal.» Ɓe nyeɗi. ");
INSERT INTO fue_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","No mawɗo ɓangal metti diyam baylitaaɗam innabojam ɗam, o annaa toy ɗam ƴiwi. Amma gollooɓe nokkoyɓe ɗam, e anni. O noddi jommanjo gorko, ");
INSERT INTO fue_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","o wi'i ɗum: «Himɓe fu innabojam belɗam woowi artirgo. To himɓe buusii, ko ɗam hewtay welugo sakitoree. Amma an, a resii belɗam ɗam faa jooni.» ");
INSERT INTO fue_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Non Yeesu waɗiri kaayeefi mum arandehi der siire Kana, der leydi Galili. Non o hollitiri baawɗe makko, go aahiiɓe makko goonɗini mo. ");
INSERT INTO fue_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ɓaawo majjum o yahi Kafarnahum, kanko e inniiko, e miiraaɓe makko, e aahiiɓe makko. Ɓe jooɗii ton balɗe seɗɗa. ");
INSERT INTO fue_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","No juulɗe Yahuduuɓe bi'eteeɗe Paska ɓadii, Yeesu yahi Urusaliima. ");
INSERT INTO fue_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Der suudu Alla, o tawi sippooɓe ga'i, e baali, e tantabaraaji, e cengotooɓe ceede, e jooɗii. ");
INSERT INTO fue_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","O etti ɓoggi o waɗi ɓoccol, o riiwi ɓe ɓe burtoo suudu Alla, kamɓe e baali, e ga'i. O sankiti ceede cengotooɓe, o hippi taaburuuji maɓɓe. ");
INSERT INTO fue_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","O wi'i sippooɓe tantabaraaji: «Burtinee ɗum, to on gaɗee suudu baaba am suudu tenkuru.» ");
INSERT INTO fue_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Aahiiɓe makko siwtori ko winnaa e Dewte: «Yidde suudu maa e jaɓina ɓerne am.» ");
INSERT INTO fue_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Den hooreeɓe Yahuduuɓe wi'i mo: «Kaayeefi kiye gaɗataa ko kollaa men aa woodi laawol waɗugo nun nun.» ");
INSERT INTO fue_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yeesu toontii ɓe, wi'i: «Pusee suudu Alla ŋol ɗo, mi mahitinto ŋol der balɗe tati.» ");
INSERT INTO fue_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ɓe toontii mo: «Suudu ŋol mahiraama duuɓi lasooji ɗiɗi e jeego'o, go an, bi'aa a mahitinto ŋol der balɗe tati na?» ");
INSERT INTO fue_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Amma ɓannu makko nun o nandiniri suudu Alla. ");
INSERT INTO fue_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","No Yeesu finti, aahiiɓe mum siwtorii o batiino ɗum ka, go ɓe goonɗini Dewte e haala ka o batunoo. ");
INSERT INTO fue_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","No Yeesu wonunoo Urusaliima gam juulɗe Paska, ɗuuɓɓe goonɗini inne makko gam ɓe ji'ii kaayeefi ɗi o waɗi. ");
INSERT INTO fue_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Amma Yeesu hoolaaki ɓe, gam oo anni ɓe ɓe fu. ");
INSERT INTO fue_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","O bukaaka goɗɗo seedanoo mo ko woni e himɓe, gam oo anni ko woni der ɓerne neɗɗo. ");
INSERT INTO fue_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","E woodunoo goɗɗo, Farisaajo, bi'eteeɗo Nikodemu, o laati nun gooto der hooreeɓe Yahuduuɓe. ");
INSERT INTO fue_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Jemmaare gom o yahi to Yeesu, o wi'i ɗum: «Moodibbo, emen anni a laati nun baajotooɗo ƴiwuɗo to Alla, gam goɗɗo waawataa ko waɗi kaayeefiiji ɗi gaɗataa, to Alla wondaa e makko.» ");
INSERT INTO fue_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yeesu toontii mo, wi'i: «Mii batee e gooŋa: Goɗɗo waawataa ko yi'i Laamaare Alla to rimitaaka.» ");
INSERT INTO fue_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodemu wi'i mo: «Noy neɗɗo waawirta ko rimitoraa to naywii? O waawan ko witti e reedu inniiko, o rimitee na?» ");
INSERT INTO fue_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yeesu toontii mo wi'i: «Mii batee e gooŋa: To neɗɗo rimitoraaka e diyam, e Ruuhu, o waawataa ko naati laamu Alla. ");
INSERT INTO fue_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ko neɗɗo rimata, laati nun neɗɗo. Ko Ruuhu bo rimata, laati nun ruuhu. ");
INSERT INTO fue_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","To ɗum haaynee gam mi wi'ii maa: ‟E haani dimiteɗaa.” ");
INSERT INTO fue_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Hennu e wifa to yiɗi fu. Aa nana sonnyo maggol, amma a annaa to ŋol ƴiwi, a annaa to ŋol yahata. Hande nun dimiraaɗo Ruuhu laati.» ");
INSERT INTO fue_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodemu wi'i mo: «Noy ɗum waɗortoo?» ");
INSERT INTO fue_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yeesu toontii mo: «An, moodibbo Isira'iila mawɗo, a annaa ɗum? ");
INSERT INTO fue_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Mii batee e gooŋa, menen, ko men anni, men batata, ko men ji'i, men ceedotoo. Amma on jaɓataa seedaaku amen. ");
INSERT INTO fue_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","On goonɗinay no batanmi on kujje ɗe leydi. Noy goonɗinirton to mi batanii on kujje ɗe dow kammu? ");
INSERT INTO fue_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Goɗɗo meeɗay eencugo dow kammu, to hinaa jippiiɗo diga kammu, kanko woni Ɓii neɗɗo. ");
INSERT INTO fue_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Hande no Muusa ɓiliri boddi janni dow leggal der ladde haro, hande non Ɓii neɗɗo bo ɓilirtee, ");
INSERT INTO fue_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","gam goonɗinɗo mo fu heɓa yonki tabitiiki. ");
INSERT INTO fue_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Gam Alla yiɗii duuniyaaru sanne faa hokki Ɓiɗɗo mum bajjo, gam goonɗinɗo mo fu to halku, amma heɓa yonki tabitiiki. ");
INSERT INTO fue_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Alla lilay Ɓiɗɗo mum e duuniyaaru gam o hiitoo nu, amma gam nu hisira diga e makko. ");
INSERT INTO fue_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Goonɗinɗo mo hiitataake, amma mo goonɗinay, hiitaamaa ko, gam o goonɗinay inne Ɓiɗɗo Alla bajjo. ");
INSERT INTO fue_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Kiita maɓɓe nani: Jaayŋol warii e duuniyaaru, amma himɓe, niwre nun ɓuri yiɗugo dow jayŋol, gam gaɗu maɓɓe wooɗaa. ");
INSERT INTO fue_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Mo golle mum wooɗaa e wanyi jayŋol, warataa e maggol, gam e hula golle mum wurtoo. ");
INSERT INTO fue_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Amma tokkuɗo gooŋa, waran to jayŋol gam gaɗu ŋu waɗi gam Alla, wurtoo.» ");
INSERT INTO fue_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ɓaawo mum Yeesu yaadi e aahiiɓe mum leydi Yahudiya. O jooɗodii e maɓɓe ton, oo waɗa batisi. ");
INSERT INTO fue_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yuhaana bo e waɗa batisi e siire Aynon, takkol Salim, gam ton diyam e ɗuuɗi. Himɓe e yaha ton e waɗanee batisi. ");
INSERT INTO fue_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Tawi Yuhaana maɓɓaakano taw.) ");
INSERT INTO fue_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Nyaanne gom aahiiɓe Yuhaana yeddontirii e Yahuduujo gom dow haala laaɓal. ");
INSERT INTO fue_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ɓe jahi to Yuhaana, ɓe bi'i ɗum: «Moodibbo, gorko gondunooɗo e maa takkol maayo Urdun, mo ceedaniɗaa men, kanko bo oo waɗa batisi. Himɓe fu e yaha to makko.» ");
INSERT INTO fue_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yuhaana toontii ɓe, wi'i: «Neɗɗo waawataa ko heɓi goɗɗum to hinaa ko Alla hokki ɗum. ");
INSERT INTO fue_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Onon e hoore mooɗon, on seedeeɓe am, mi wi'ii: ‟Mi Almasiihu bane, amma mi lilaama mi ardoo mo”.» ");
INSERT INTO fue_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Yuhaana wi'i kade: «Gaddanaaɗo jommanjo debbo, kanko woni jommanjo gorko. Ɗottoowo gorko e darii, e hettinii. To o nanii daane jommanjo gorko, ɓerne makko welan sanne. Nii belɗum ɓerne am hebbiri. ");
INSERT INTO fue_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Haani tedduŋal makko e ɓeydoo, ŋal am e ɓuytoo.» ");
INSERT INTO fue_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","«Ƴiwuɗo dow kammu nun ɓuri fu. Ƴiwuɗo e leydi, laati nun leydinkeejo. Haala mum bo laati nun ka leydinkeeɓe. Ƴiwuɗo dow kammu, kan nun jinti moy fu. ");
INSERT INTO fue_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ko o yi'i e ko o nani, o seedotoo, amma goɗɗo jaɓataa seedaaku makko. ");
INSERT INTO fue_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Jaɓuɗo seedaaku makko, tabbitinii Alla laati nun gooŋaajo. ");
INSERT INTO fue_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Mo Alla lili, ko Alla bati nun o batata, gam Alla hebbinii mo Ruuhu mum. ");
INSERT INTO fue_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Baaba e yiɗi Ɓiɗɗo, faa watti huune fu e junŋo makko. ");
INSERT INTO fue_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Goonɗinɗo Ɓiɗɗo, heɓii yonki tabitiiki. Mo goonɗinay Ɓiɗɗo, heɓataa ki, amma mone Alla e wonani ɗum.» ");
INSERT INTO fue_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Farisaaɓe nanii Yeesu e waɗa batisi, e heɓa aahiiɓe ɗuuɓɓe faa ɓuri Yuhaana. ");
INSERT INTO fue_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","To gooŋa nun, Yeesu e hoore mum waɗay batisi, amma aahiiɓe makko nun waɗannoo ɗum. ");
INSERT INTO fue_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","No Yeesu nani ka Farisaaɓe bati, ummii leydi Yahudiya, witti leydi Galili. ");
INSERT INTO fue_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","E haani bo o falta leydi Samariya. ");
INSERT INTO fue_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","O wari e siire Samariya bi'eteene Sikar, takkol gesa ŋa Yaakuubu hokki ɓiyum Yusufu. ");
INSERT INTO fue_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ɗon ɓunnu Yaakuubu woni. No Yeesu somi yaadu, jooɗii gaɓɓuɗe ɓunnu ŋol. Caka nyaalooma nun. ");
INSERT INTO fue_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Samariyaajo debbo wari ƴoogugo. Yeesu wi'i mo: «Hokkoram diyam, mi yara!» ");
INSERT INTO fue_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Tawi aahiiɓe makko yahii siire soodoygo ko nyaametee.) ");
INSERT INTO fue_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Debbo on wi'i Yeesu: «Ee, noy an Yahuduujo, eelirtaa am diyam jaraa, min samariyaajo debbo?» Nani bo potal walaa hakkune Yahuduuɓe e Samariyaaɓe. ");
INSERT INTO fue_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yeesu toontii mo, wi'i: «To aa annunoo no dokkal Alla foti, e moy wi'i maa: “Hokkoram diyam, mi yara!” an nun eelatano mo, o hokkee diyam yonki.» ");
INSERT INTO fue_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Debbo on wi'i mo: «Moodibbo, a walaa cawgal. Ɓunnu nun bo e luggi. Toy keɓataa diyam yonki ɗam? ");
INSERT INTO fue_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","A ɓuru nun maama amen Yaakuubu, kokkuɗo men ɓunnu ŋol manŋu na? Kanko e ɓiɓɓe makko, e bisaaji makko fu, ɓe jarii e maggol.» ");
INSERT INTO fue_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yeesu toontii mo, wi'i: «Neɗɗo fu jarɗo diyam ɗam, ɗonɗete kade, ");
INSERT INTO fue_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","amma jarɗo diyam ɗam kokkanmi ɗum, ɗonɗataake faa abada. Gam diyam kokkanmi ɗum, laatanto ɗum ɓuldude diyam kokkoojam yonki tabitiiki.» ");
INSERT INTO fue_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Debbo on wi'i: «Moodibbo, hokkoram diyam ɗam, to mi ɗonɗee kade, to mi wittaa bo ƴoogugo.» ");
INSERT INTO fue_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yeesu wi'i mo: «Yahu noddoy gorko maa, garidon!» ");
INSERT INTO fue_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Debbo on toontii mo: «Mi walaa gorko.» Yeesu wi'i mo: «Aa woodi gooŋa no bi'uɗaa a walaa gorko. ");
INSERT INTO fue_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","A ettayno maa worɓe joyo. Gorko gonduɗaa jooni on bo, gorko maa bane. A batii gooŋa.» ");
INSERT INTO fue_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Debbo on wi'i mo: «Moodibbo, laaɓanii am, a laati nun Annabiijo. ");
INSERT INTO fue_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Maamiraaɓe amen saafiino Alla dow waanne nee, amma onon, oon bi'a: ‟Urusaliima nun Alla haani saafeego”.» ");
INSERT INTO fue_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yeesu wi'i mo: «Banniraawo debbo, hoola ko batan maa mi. Wakkati e wara, dow waanne nee ɗo bane, Urusaliima bo bane caafoton Baaba. ");
INSERT INTO fue_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Onon Samariyaaɓe, oon caafa ko on annaa, menen Yahuduuɓe, ko men anni men caafata, gam kisidam to Yahuduuɓe nun ƴiwata. ");
INSERT INTO fue_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Amma wakkati e wara, ki yottike du, de saafooɓe gooŋakuuɓe saafirta Baaba e ruuhu e gooŋa. Iri saafooɓe ɓee ɗon nun Baaba daartata. ");
INSERT INTO fue_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Alla laati nun Ruuhu. Gam majjum, e haani saafooɓe, saafira mo e ruuhu e gooŋa.» ");
INSERT INTO fue_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Debbo on wi'i: «Mii anni Almasiihu, bi'eteeɗo Cuɓaaɗo, waran. To o warii, o humpitanan men kujje fu.» ");
INSERT INTO fue_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yeesu wi'i mo: «Min, baddoowo e maa, woni kanko.» ");
INSERT INTO fue_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Dow kaa ɗon, aahiiɓe makko yottii to maɓɓe. No Yeesu baddata e debbo on, ɗum haaynii ɓe, amma baa gooto maɓɓe wi'ay: «Ko daartataa?» Naa: «Gam ume baddataa e makko?» ");
INSERT INTO fue_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Den debbo on resi ƴoogirgal mum, witti siire, bati himɓe, wi'i: ");
INSERT INTO fue_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«Garee, daaree gorko batuɗo am ko gaɗunoomi fu. Kanko bane woni Almasiihu on?» ");
INSERT INTO fue_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ɓe burti siire nen, ɓe jahi to makko. ");
INSERT INTO fue_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Wakkati den aahiiɓe e sawrina mo, e wi'a: «Moodibbo, nyaamu!» ");
INSERT INTO fue_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","O toontii ɓe: «Mii woodi ko nyaamaanmi, ko on annaa.» ");
INSERT INTO fue_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Aahiiɓe ɓen e ƴamontira: «Moy waddani mo ko nyaametee?» ");
INSERT INTO fue_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yeesu wi'i ɓe: «Nyaamdu am laati nun waɗugo sago lilɗo am, e heennyitingo golle ɗe o hokkimmi. ");
INSERT INTO fue_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Onon, oon bi'a: ‟Faa hanne lebbi naay horii go dugge yottoo?” Amma min, mii wi'a on: ɓantee gite mon, daaree, gese ɓennii, ɗe potii ruggeego. ");
INSERT INTO fue_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Dugguɗo heɓan joddi, hawritan ɓiɓɓe gam yonki tabitiiki, gam aawuɗo e dugguɗo seyodoo. ");
INSERT INTO fue_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ɗum ɗon e tabbitina ballool ŋol ɗo: ‟Gooto e aawa, gooto e rugga.” ");
INSERT INTO fue_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Mi lilii on duggoon to on gollay. Woɓɓe gollii, onon, on nafitoroo golle maɓɓe.» ");
INSERT INTO fue_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Der siire nen, Samariyaaɓe ɗuuɓɓe goonɗinii Yeesu gam haala debbo ceediiɗo, wi'i: «O batii am ko gaɗunoomi fu.» ");
INSERT INTO fue_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Gam majjum no Samariyaaɓe yottii to Yeesu, ɓe eeli mo o jooɗoo to maɓɓe. O waɗi ɗon balɗe ɗiɗi. ");
INSERT INTO fue_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Himɓe ɗuuɓɓe, faa ɓuri no arande, goonɗini mo, no nani haala makko. ");
INSERT INTO fue_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ɓe bi'i debbo on: «Jooni, hinaa gam ka batuɗaa men tan acci men goonɗini. Amma menen e ko'e amen, men nanii haala makko, emen anni kanko woni Kisinoowo duuniyaaru lalley.» ");
INSERT INTO fue_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","No Yeesu waɗi ton balɗe ɗiɗi, o witti Galili. ");
INSERT INTO fue_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Kanko e hoore makko o seedike, o wi'i: «Annabiijo teddintaake der leydi mum.» ");
INSERT INTO fue_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","No o yottii Galili, Galilinkeeɓe jaɓɓorii mo juuɗe ɗiɗi, gam kamɓe bo ɓe jahiino juulɗe Urusaliima, ɓe ji'iino ko o waɗi ton fu. ");
INSERT INTO fue_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Den Yeesu warti Kana, der leydi Galili to o waylitinnoo diyam laatii jaram. Tawi ɓii gorko semmenteejo gom, yanɗaa, e fukkii Kafarnahum. ");
INSERT INTO fue_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Semmenteejo on nani Yeesu ƴiwii Yahudiya, warii Galili. O yahi to makko, o eeli mo o yaha o nyawtaa ɓiyiiko ɓadiiɗo maayugo. ");
INSERT INTO fue_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yeesu wi'i mo: «Abada on goonɗintaa, to on ji'ay kaayeefiiji e haaynaareeji.» ");
INSERT INTO fue_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Semmenteejo on wi'i mo: «Moodibbo, en jahu diga ɓiyam maayay.» ");
INSERT INTO fue_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yeesu wi'i mo: «Hootu, ɓiya e wuuri.» Gorko on goonɗini ko Yeesu bati ɗum, witti. ");
INSERT INTO fue_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","E laawol, gollooɓe makko fotti e makko, wi'i mo ɓiyiiko yoofike. ");
INSERT INTO fue_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","O ƴami ɓe: «Wakkati dey o yoofii?» Ɓe toontii mo, ɓe bi'i: «Keenya juura jonte ɗen yoofi mo.» ");
INSERT INTO fue_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Baabiiko anniti wakkati oo ɗon nun lalley Yeesu wi'i mo: «Ɓiya yoofike!» Kanko e getti makko fu, ɓe goonɗini Yeesu. ");
INSERT INTO fue_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ɗum ɗon woni kaayeefi ɗiɗaɓi ki Yeesu waɗi Galili, no ƴiwunoo Yahudiya. ");
INSERT INTO fue_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ɓaawo majjum, juulɗe Yahuduuɓe e waɗa. Yeesu yahi Urusaliima. ");
INSERT INTO fue_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Urusaliima ton, takkol Dammugal baali, weldere diyam e woni ɗon, nee wi'ee e Iburaninkeere Baytisayda. Dammuɗe joy mawɗe e filtitii ne. ");
INSERT INTO fue_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Nyawɓe ɗuuɓɓe e fukkii ley dammuɗe ɗen: wumuɓe, laƴooɓe, e moofiɗinɓe. Ɓee keɗii diyam irtee, ");
INSERT INTO fue_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","gam malaykaajo Joomiraawo e jippoo e weldere nen tife e tife, e irta diyam ɗam. Nyawɗo artuɗo naati e diyam ɗam de ɗam irtaa, e yoofoo no nyaw mum wa'i fu. ");
INSERT INTO fue_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Gorko nyawɗo diga duuɓi laso e sappo e jeetati e wonunoo ɗon. ");
INSERT INTO fue_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yeesu yi'i oo fukkii, anniti o ɓooyidii e nyaw, ƴami mo, wi'i «Aa yiɗi yoofaago?» ");
INSERT INTO fue_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Nyawɗo on toontii mo, wi'i: «Moodibbo, mi walaa goɗɗo ballanɗo am naatugo e weldere nen to diyam irtike, go mi yottoo fu, den goɗɗo artii am naatugo.» ");
INSERT INTO fue_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yeesu wi'i mo: «Umma, ettu daago maa, yahu!» ");
INSERT INTO fue_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ɗon maa ɗon gorko on yoofii, etti daago mum e yaha. Ɗum fakkii e nyalaane siwteteene, ");
INSERT INTO fue_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","gam majjum hooreeɓe Yahuduuɓe wi'i nyawtaaɗo on: «Hanne nyalaane siwteteene nun, laawol hokkay maa doonoɗaa daago maa.» ");
INSERT INTO fue_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","O toontii ɓe, o wi'i: «Nyawtuɗo am, kan nun wi'immi: Ettu daago maa, yahu!» ");
INSERT INTO fue_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ɓe ƴami mo: «Moy nun bi'uɗo maa: Ettu daago maa, yahu?» ");
INSERT INTO fue_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Amma nyawtaaɗo on annaano mo, gam Yeesu mutii caka himɓe sabbu no ɓe ɗuuɗiri e nokkuure nen. ");
INSERT INTO fue_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ɓaawo mum Yeesu fottitii e makko der suudu Alla, wi'i mo: «Daaru, jooni kan, a yoofike. Taa waɗu hakke kade, wara ko ɓuri ɗum bonugo heɓee.» ");
INSERT INTO fue_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Gorko on yahi batoy hooreeɓe Yahuduuɓe wi'i Yeesu nun nyawti ɗum. ");
INSERT INTO fue_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Go Yahuduuɓe fuɗɗi gaccaago Yeesu gam o waɗii ɗum e nyalaane siwteteene. ");
INSERT INTO fue_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yeesu wi'i ɓe: «Baaba am, e golloo faa hanne, min bo, mii golla.» ");
INSERT INTO fue_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Gam majjum hooreeɓe Yahuduuɓe hocci niiya warugo mo, hinaa gam o biisii nyalaane siwteteene tan, amma gam o wi'i bo, Alla woni Baabiiko. O fotinii hoore makko e Alla. ");
INSERT INTO fue_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yeesu wi'i ɓe: «Mii bata on e gooŋa: Ɓiɗɗo waawataa ko waɗi goɗɗum kan tan, sey ko yi'i Baaba e waɗa. Gam ko Baaba waɗata fu, kanjum Ɓiɗɗo bo waɗata. ");
INSERT INTO fue_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Gam Baaba e yiɗi Ɓiɗɗo, kan waɗi e holla mo huune fu ko o waɗata. O hollan mo golle ɓurɗe ɗee ɗo fu manŋu, faa haaynaare waɗa on. ");
INSERT INTO fue_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Gam hande no Baaba fintinirta maayɓe wuurina ɓe, nun Ɓiɗɗo bo wuurinirta mo yiɗi. ");
INSERT INTO fue_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Baaba kan, hiitataako goɗɗo, amma o hokkii Ɓiɗɗo baawɗe hiitaago kiita fu, ");
INSERT INTO fue_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","gam himɓe fu teddina Ɓiɗɗo hande no teddiniri Baaba. Neɗɗo fu mo teddinay Ɓiɗɗo, teddinay Baaba liloyɗo mo. ");
INSERT INTO fue_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Mii bata on e gooŋa. Nanuɗo haala am ko goonɗini liluɗo am, heɓii yonki tabitiiki, o hiitataake. O ƴiwii e maayde, o warii to yonki. ");
INSERT INTO fue_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Mii bata on e gooŋa: Wakkati e wara, ki yottike du, wakkati de maayɓe nanata daane Ɓiɗɗo Alla. Nanuɓe ne bo wuuran. ");
INSERT INTO fue_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Hande no Baaba laatorii ɓulirde yonki, hande nun o hokkii Ɓiɗɗo bo laatoo ɓulirde yonki. ");
INSERT INTO fue_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","O hokkii mo baawɗe hiitaago, gam o laati nun Ɓii neɗɗo. ");
INSERT INTO fue_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","To ɗum haaynoo on. Wakkati waran, de maayɓe wonuɓe der caabeeje nanata daane makko, ");
INSERT INTO fue_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ɓe burtoo. Waɗuɓe ko wooɗi, finta, heɓa yonki, waɗuɓe ko halli finta, hiitee.» ");
INSERT INTO fue_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","«Min e hoore am, walaa fu ko baawumi waɗugo. Ko nanumi, kiitortoomi. Kiita am e foonnitii, gam mi tokkataa sago am, sago lilɗo am nun tokkumi. ");
INSERT INTO fue_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","To mi seedanike hoore am, seedaaku am nootataake. ");
INSERT INTO fue_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","E woodi goɗɗo ceedantooɗo am. Mii anni seedaaku makko, ko o seedantoo am laati nun gooŋa. ");
INSERT INTO fue_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Onon, on lilii himɓe to Yuhaana, o seedike gooŋa. ");
INSERT INTO fue_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Min, mi bukaaka seedaaku neɗɗo, amma mi batii ka gam kison. ");
INSERT INTO fue_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yuhaana laatike fitilla kuɓɓoowa, jaaynoowa. On jaɓii welweltugo wakkati seɗɗa e jayŋol makko. ");
INSERT INTO fue_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Min, mii woodi seedaaku ɓurŋu ŋu Yuhaana manŋu. Golle ɗe Baaba yowanimmi mi waɗa, golle ɗe gaɗanmi ɗen nun seedantoo am no Baaba nun lilimmi. ");
INSERT INTO fue_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Baaba liluɗo am, kanko e hoore makko seedanii am. Abada on nanay daane makko, abada on ji'ay mo. ");
INSERT INTO fue_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Batu makko wonday e mooɗon, gam on goonɗinay mo o lili. ");
INSERT INTO fue_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Oon biɗitoo Dewte gam oon miiji ɗe kokkan on yonki tabitiiki. Kanje seedantoo am. ");
INSERT INTO fue_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Amma, on jaɓay warugo to am gam keɓon yonki. ");
INSERT INTO fue_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Diga e himɓe bane keɓammi tedduŋal am, ");
INSERT INTO fue_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","amma mii anni on, mii anni yidde Alla walaa e mooɗon. ");
INSERT INTO fue_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Min, mi warii e inne Baaba am, on jaɓɓaaki am. Amma to goɗɗo wardii inne mum, on jaɓɓoto ɗum. ");
INSERT INTO fue_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Noy baawirton ko goonɗini, onon teddinontirooɓe hakkune mooɗon, go accuɗon daartugo tedduŋal Alla? ");
INSERT INTO fue_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","To on miilee min gaccotoo on yeeso Baaba. Muusa, mo jowuɗon hoolaare mooɗon dow mum, kanko nun gaccoytoo on. ");
INSERT INTO fue_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","To on goonɗiniino Muusa e gooŋa, on goonɗinanno am min bo, gam min o batani der dewte makko. ");
INSERT INTO fue_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Amma no on goonɗinay ko o winni, noy goonɗinirton haala am?» ");
INSERT INTO fue_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ɓaawo majjum Yeesu joli maayo Galili, bi'eteeŋo Tiberiya. ");
INSERT INTO fue_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Jama'aare ɗuunne e tokki mo gam ɓe ji'ii haaynaareeji ɗi o waɗi dow nyawɓe. ");
INSERT INTO fue_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yeesu eenci dow waanne, jooɗodii ton e aahiiɓe mum. ");
INSERT INTO fue_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Tawi juulɗe Yahuduuɓe bi'eteeɗe Paska ɓadike. ");
INSERT INTO fue_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yeesu ɓanti hoore, hollirii jama'aare ɗuunne e fonnoy ɗum. O ƴami Filippu: «Toy keɓeten cooden nyaamdu ko nyaannata ɓee ɗo fu?» ");
INSERT INTO fue_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","O batu nun makko gam o nana ko Filippu toontotoo, gam oo anni ko o miili waɗugo. ");
INSERT INTO fue_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filippu toontii mo, wi'i: «Baa gollotooɗo golle juuɗe balɗe keme ɗiɗi, joddi mum heƴataa sooda peen, tawee moy fu heɓa ŋappel.» ");
INSERT INTO fue_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Gooto e aahiiɓe makko, bi'eteeɗo Andere, miiraawo Simon Piyer, wi'i mo: ");
INSERT INTO fue_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«E woodi ɗo suka gorko gom gooduɗo peen joy e liƴƴi ɗiɗi, amma ume ɗum ɗon waɗanta ɓee ɗo fu?» ");
INSERT INTO fue_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yeesu wi'i: «Bi'ee ɓe, ɓe jooɗoo.» Nokkuure nen e hebbi fuɗo, ɓe jooɗii. Ɓe gaɗan himɓe ujune joyo. ");
INSERT INTO fue_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yeesu etti peen kon, yetti Alla, yeɗi wonuɓe ɗon. O waɗi liƴƴi ɗii bo hande nun. O hokki ɓe faa ɓe kaari. ");
INSERT INTO fue_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","No ɓe kaari, Yeesu wi'i aahiiɓe mum: «Kawritee ko horii, baa goɗɗum to halku.» ");
INSERT INTO fue_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ɓe kawriti ŋappe peen joyo ko himɓe ɓen horii, ko kebbi killaaje sappo e ɗiɗi. ");
INSERT INTO fue_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","No himɓe yi'i kaayeefi ɗum Yeesu waɗi, ɓe bi'i: «Lalley, kanko woni Annabiijo bi'aaɗo e wara der duuniyaaru.» ");
INSERT INTO fue_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Amma no Yeesu e anni ɓe garan nanŋugo ɗum e semme, ɓe laamina, o dilli diga ɗon, o eenci dow waanne, kanko tan. ");
INSERT INTO fue_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Kiikiiɗe mum, aahiiɓe Yeesu yahii fonŋo maayo. ");
INSERT INTO fue_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ɓe naati laana diyam gam ɓe jola, ɓe jaha Kafarnahum. Niwre fuɗɗii waɗugo, tawi Yeesu hewtaaki ɓe taw. ");
INSERT INTO fue_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Hennu mawkol e wifa, galmaji diyam e ummoo. ");
INSERT INTO fue_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ɓe jawɗini laana kan faa ɓe keɓi hande kilo joy naa jeego'o. Den ɓe kolliri Yeesu e yaha e koyɗe dow maayo, faa ɓattii ɓe. Ɓe kuli. ");
INSERT INTO fue_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Yeesu wi'i ɓe: «Min nun, to on kulee!» ");
INSERT INTO fue_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ɓe eeli mo o naata e laana kan. Ɗon maa ɗon ɓe jottii fonŋo to ɓe poonnii. ");
INSERT INTO fue_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Fini mum, jama'aare wonunoone fonŋo maayo, yi'i laana goota tan woni ton. Yeesu naatiday e aahiiɓe mum laana kan. Kamɓe tan yawti e makka. ");
INSERT INTO fue_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Laanaaje ƴiwuɗe Tiberiya warii takkol to ɓe nyaami peen ɗon, ɓaawo no Joomiraawo yetti Alla. ");
INSERT INTO fue_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","No jama'aare yi'i Yeesu e aahiiɓe mum walaa ɗon, ɓe naati laanaaje, ɓe batti Kafarnahum daartoygo mo. ");
INSERT INTO fue_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","No ɓe tawi Yeesu fonŋo maayo, ɓe bi'i ɗum: «Moodibbo, dey garuɗaa ɗo?» ");
INSERT INTO fue_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yeesu toontii ɓe, wi'i: «To gooŋa nun, hinaa gam on ji'ii kaayeefi acci oon daartammi. Ko daartirton am woni gam on nyaamii faa on kaarii. ");
INSERT INTO fue_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","To on gollee gam nyaamdu keennyoowol, amma gollee gam nyaamdu tabitintooŋol, kokkoowol yonki tabitiiki. Nyaamdu ŋol ɗon nun, Ɓii neɗɗo hokkata on, gam kanko Alla Baaba, waɗani maane baawɗe mum.» ");
INSERT INTO fue_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Den ɓe ƴami mo, ɓe bi'i: «Ume men gaɗata ko men gaɗa golle ɗe Alla yiɗi?» ");
INSERT INTO fue_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yeesu toontii ɓe, wi'i: «Golle ɗe Alla yiɗi woni goonɗinon mo o lili.» ");
INSERT INTO fue_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ɓe toontii mo, ɓe bi'i: «Kaayeefi kiye gaɗataa men ji'a, faa men goonɗinee? Ume gaɗataa? ");
INSERT INTO fue_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Maamiraaɓe amen nyaamii nyaamdu maannu der haro, hande no dewte wi'i: ‟O hokkii ɓe nyaamdu ƴiwunu dow kammu”.» ");
INSERT INTO fue_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yeesu toontii ɓe, wi'i: «Mii bata on e gooŋa: hinaa annabi Muusa hokki on nyaamdu ƴiwuŋol dow kammu. Baaba am hokki on nyaamdu geetol, ƴiwuŋol dow kammu. ");
INSERT INTO fue_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Nyaamdu ŋol Alla hokkata woni, ƴiwuŋol dow kammu, kokkoowol duuniyaaru yonki.» ");
INSERT INTO fue_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ɓe bi'i mo: «Moodibbo, hokku men nyaamdu ŋol baadey.» ");
INSERT INTO fue_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yeesu wi'i ɓe: «Min woni nyaamdu kokkoowol yonki, garuɗo to am, rafataake abada, goonɗinɗo am bo ɗonɗataake abada. ");
INSERT INTO fue_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Amma mi batii on: on ji'ii am, ko on goonɗinay. ");
INSERT INTO fue_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ɓe Baaba hokkimmi fu, waran to am. Garuɗo to am fu, mi salataako ɗum. ");
INSERT INTO fue_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Gam waɗugo ko jiɗumi bane acci ƴiwmi dow kammu, amma gam mi waɗa ko liluɗo am yiɗi. ");
INSERT INTO fue_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Nani ko lilɗo am yiɗi: to baa gooto der himɓe o hokki am majju, amma gam mi ummitina ɓe nyalaane darŋal. ");
INSERT INTO fue_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Nani ko Baaba am yiɗi: ji'uɗo Ɓiɗɗo fu, to goonɗinii mo, heɓii yonki tabitiiki. Mi ummitinan mo nyalaane darŋal.» ");
INSERT INTO fue_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Yahuduuɓe e dumbitoo hakkune mum dow haala Yeesu, gam o wi'i: «Min woni nyaamdu ƴiwuŋol dow kammu» ");
INSERT INTO fue_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ɓe bi'i: «Oo ɗo, hinaa Yeesu ɓii Yusufu, mo annuɗen inna mum e baaba mum on na? Noy o wi'irta: ‟Dow kammu ƴiwmi”?» ");
INSERT INTO fue_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yeesu wi'i ɓe: «To on dumbitee hakkune mooɗon! ");
INSERT INTO fue_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Goɗɗo waawataa ko wari to am, to Baaba lilɗo am fooɗay mo. Min, mi ummitinan mo nyalaane darŋal. ");
INSERT INTO fue_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","E winnii der dewte annabiiɓe: ‟Ɓe fu Alla janŋinan ɓe.” Neɗɗo fu nanuɗo ko Baaba bati, go jaɓi janŋinol makko, waran to am. ");
INSERT INTO fue_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Baa gooto yi'ay Baaba, to hinaa ƴiwuɗo to Alla, kanko tan yi'i Baaba. ");
INSERT INTO fue_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Mii bata on e gooŋa: Goonɗinɗo am, heɓii yonki tabitiiki. ");
INSERT INTO fue_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Min woni nyaamdu kokkoowol yonki. ");
INSERT INTO fue_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Maamiraaɓe mooɗon nyaamii maannu der haro, ɓe maayii bo. ");
INSERT INTO fue_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ŋol ɗo nun nyaamdu ƴiwuŋol dow kammu, nyaamuɗo ŋol fu maayataa. ");
INSERT INTO fue_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Min woni nyaamdu yonkintewol, ƴiwuŋol dow kammu. To neɗɗo nyaami nyaamdu ŋol, wuuran faa abada. Nyaamdu ŋol kokkanmi gam duuniyaaru wuura, laati nun ɓannu am.» ");
INSERT INTO fue_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Dow kaa ɗon Yahuduuɓe e yeddontira no waawi fu, e wi'a: «Noy neɗɗo oo waawirta ko hokki en ɓannu mum nyaamen?» ");
INSERT INTO fue_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yeesu toontii ɓe, wi'i: «Mii bata on e gooŋa: To on nyaamaay ɓannu Ɓii neɗɗo, on jaray ƴiiƴam makko, yonki walaa der mooɗon. ");
INSERT INTO fue_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Neɗɗo fu nyaamuɗo ɓannu am, to yari ƴiiƴam am, heɓii yonki tabitiiki. Mi fintinan mo nyalaane darŋal. ");
INSERT INTO fue_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Gam ɓannu am laati nun nyaamdu lalley, ƴiiƴam am bo laati nun jaram lalley. ");
INSERT INTO fue_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Neɗɗo fu nyaamuɗo ɓannu am, to yari ƴiiƴam am, oo wondi e am, min bo mii wondi e makko. ");
INSERT INTO fue_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Baaba liloyɗo am laati nun buuruɗo. Gam makko buurumi. Hande nun nyaamuɗo am fu, wuurirta gam am. ");
INSERT INTO fue_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ŋol ɗo nun woni nyaamdu ƴiwuŋol dow kammu. Ŋol nandaa e ŋol kaakiraaɓe mooɗon nyaamuno, ɓe maayii bo. Nyaamuɗo nyaamdu ŋol ɗo wuuran faa abada.» ");
INSERT INTO fue_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Haalaaji ɗii ɗo nun Yeesu janŋini der suudu waajorde Kafarnahum. ");
INSERT INTO fue_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","No ɓe nani haalaaji ɗin, ɗuuggal e aahiiɓe makko wi'i: «Haala ka e tiiɗi. Moy waawata ko jaɓi ka?» ");
INSERT INTO fue_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yeesu faami der ɓerne mum, aahiiɓe mum e dumbitoo dow majjum, go o wi'i ɓe: «Haala kan jiɓi on nun? ");
INSERT INTO fue_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Jon kan to on ji'ii Ɓii neɗɗo eenci to wonunoo, den mum noy gaɗoton? ");
INSERT INTO fue_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ruuhu woni buurinoowo, ɓannu nafataa goɗɗum. Haalaaji haalanmi on ɗii, laati nun Ruuhu e yonki. ");
INSERT INTO fue_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Nani e woodi hakkune mooɗon ɓe goonɗinay.» Gam Yeesu e anni diga fuɗɗoode, ɓe goonɗinay ɗum, e jammotooɗo ɗum. ");
INSERT INTO fue_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","O ɓeydi o wi'i: «Gam majjum bi'umi on: ‟Walaa baawoowo ko wari to am, to Baaba hokkay ɗum no warirta”.» ");
INSERT INTO fue_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Diga den, ɗuuggal e aahiiɓe makko dilli, acci tokkugo mo. ");
INSERT INTO fue_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Den Yeesu ƴami aahiiɓe sappo e ɗiɗo ɓen: «Onon bo, oon jiɗi dillugo na?» ");
INSERT INTO fue_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simon Piyer toontii mo, wi'i: «Joomiraawo, to moy men jahata? An woodi haala kokkoowa yonki tabitiiki. ");
INSERT INTO fue_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Men goonɗinii, emen anni an woni Ceniiɗo ƴiwuɗo e Alla.» ");
INSERT INTO fue_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yeesu toontii ɓe, wi'i: «Hinaa min suɓi on, onon sappo e ɗiɗo? Gooto mooɗon laati nun seyɗaanuujo.» ");
INSERT INTO fue_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Haala Yahuuda, ɓii Simon Iskariyot nun o batata, gooto der sappo e ɗiɗo ɓen. Oo ɗon woni jammotooɗo mo. ");
INSERT INTO fue_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ɓaawo majjum Yeesu e woosoo der Galili. O yiɗaa woosaago der Yahudiya gam hooreeɓe Yahuduuɓe e daarta no warirta mo. ");
INSERT INTO fue_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Tawi juulɗe Yahuduuɓe bi'eteeɗe juulɗe bukaaji ɓadike. ");
INSERT INTO fue_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Miiraaɓe Yeesu wi'i ɗum: «Eggu, jahaa Yahudiya gam aahiiɓe maa yi'a golle ɗe gaɗataa. ");
INSERT INTO fue_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Goɗɗo suuɗataa ko waɗata, to e yiɗi anneego. No aa waɗa golle ɗee, hollitin hoore maa himɓe.» ");
INSERT INTO fue_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Baa miiraaɓe makko goonɗinay mo. ");
INSERT INTO fue_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yeesu wi'i ɓe: «Wakkati am waray taw, amma onon, wakkati fu laati nun wakkati mooɗon. ");
INSERT INTO fue_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Himɓe duuniyaaru waawataa ko wanyi on, amma min, ɓee banyimmi gam mii seedoo golle maɓɓe wooɗaa. ");
INSERT INTO fue_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Onon, jahee juulɗe ɗen. Min, mi yahataa, gam wakkati am waray taw.» ");
INSERT INTO fue_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","No o bati ɓe kaa ɗon, o jooɗii leydi Galili. ");
INSERT INTO fue_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","No miiraaɓe Yeesu yahi juulɗe ɗen, Yeesu bo yahi ton, amma o hollitay hoore makko, o suuɗii. ");
INSERT INTO fue_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Hooreeɓe Yahuduuɓe e daarta mo der juulɗe, e wi'a: «Toy o woni?» ");
INSERT INTO fue_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Himɓe ɗuuɓɓe e dumbitoo dow haala makko. Woɓɓe e wi'a: «Neɗɗo geeto nun!» Woɓɓe bo e wi'a: «Nun nun bane, majjinoowo himɓe nun.» ");
INSERT INTO fue_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Goɗɗo suusay batango mo e daane towne, gam ɓee kula hooreeɓe Yahuduuɓe. ");
INSERT INTO fue_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Tawi juulɗe ɗen fecciri, go Yeesu fuɗɗi janŋingo der suudu Alla. ");
INSERT INTO fue_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Haaynaare waɗi Yahuduuɓe sanne, ɓe bi'i: «Noy o waawiri dewte, kanko mo janŋay?» ");
INSERT INTO fue_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yeesu toontii ɓe, wi'i: «Jande janŋinammi on, ƴiway e am. Diga to liloyɗo am, ɗum ƴiwi. ");
INSERT INTO fue_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","To neɗɗo e yiɗi waɗugo sago Alla, o annitan janŋinol am to Alla ƴiwi, naa bo to haalaaji am, e baawɗe am nun ƴiwi. ");
INSERT INTO fue_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Batanoowo hoore mum, hoore mum nun daartanta tedduŋal. Amma daartoowo tedduŋal liloyɗo ɗum, oo ɗon gooŋa nun batata, fewre walaa e makko. ");
INSERT INTO fue_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Hinaa Muusa hokki on tawreeta na? Amma baa gooto mooɗon golliray tawreeta. Ko woni sabbu go oon daarta warugo am?» ");
INSERT INTO fue_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Himɓe ɓen toontii mo, wi'i: «An, aa woodi ginnool. Moy daartata warugo maa?» ");
INSERT INTO fue_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yeesu toontii ɓe: «Golle goote tan gaɗumi, on fu, haaynaare waɗi on. ");
INSERT INTO fue_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Muusa hokkii laawol gaɗon julnol. Diga to Muusa du bane ŋol ƴiwi, diga to kaakiraaɓe mon nun, go oon julna suka nyalaane siwteteene. ");
INSERT INTO fue_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","To suka e julnee nyalaane siwteteene, gam to tawreeta Muusa ƴartee, gam ume monnotoɗon gam mi nyawtii tagaaɗo bumbum nyalaane siwteteene? ");
INSERT INTO fue_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Accee hiitoraago no ji'irton, amma gaɗee kiita poonnitiika.» ");
INSERT INTO fue_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Go himɓe Urusaliima woɓɓe wi'i: «Hinaa oo ɗo ɓe daartata warugo na? ");
INSERT INTO fue_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Oo woni caka maɓɓe, oo bata, ɓe bi'ay mo gokka. Den mawɓe amen annitin nun kanko woni Cuɓaaɗo na? ");
INSERT INTO fue_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Oo ɗo kan, een anni to ƴiwi, amma to Cuɓaaɗo e wara, goɗɗo annataa to o ƴiwata.» ");
INSERT INTO fue_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Tawi Yeesu e janŋina der suudu Alla, o bati e daane towne, o wi'i: «Oon annimmi, oon anni to ƴiwumi! Min bane waddi hoore am. Liloyɗo am laati nun gooŋaajo. Kanko woni mo on annaa. ");
INSERT INTO fue_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Min, mii anni mo gam to makko ƴiwmi. Kanko liloymmi.» ");
INSERT INTO fue_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Den ɓe daarti no ɓe nanŋirta mo, amma goɗɗo junŋo mum meemaay mo, gam wakkati makko waray taw. ");
INSERT INTO fue_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ɗuuggal der jama'aare goonɗinii mo, wi'i: «To Cuɓaaɗo warii, o waɗan kaayeefi ɓuruɗi ɗi gorko oo waɗi na?» ");
INSERT INTO fue_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Farisaaɓe nani ko himɓe ɓen dumbitintoo dow haala Yeesu. Hooreeɓe Limaamiiɓe e Farisaaɓe lili reenooɓe, nanŋa mo. ");
INSERT INTO fue_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yeesu wi'i: «Min, mii wondi e mooɗon seɗɗa taw. Ɓaawo mum, mi wittan to liloyɗo am. ");
INSERT INTO fue_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","On daartan am, amma on jiitataa am, gam on baawataa ko yahi to gonumi.» ");
INSERT INTO fue_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Yahuduuɓe ƴamontiri, wi'i: «Toy o yahata ko en baawataa ko yiiti mo? O yahan to himɓe meeɗen feroyɓe to Yunaninkeeɓe, o janŋina Yunaninkeeɓe na? ");
INSERT INTO fue_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","O wi'ii en daartan mo, en jiitataa mo, gam en baawataa ko yahi to o tawetee. Kaye nun kaa ɗon bo?» ");
INSERT INTO fue_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Nyalaane sakitiineere der juulɗe ɗen ɓuri teddugo. Nyaanne mum, Yeesu darii, bati e daane towne, wi'i: «Neɗɗo fu ɗonɗaaɗo wara to am, yara. ");
INSERT INTO fue_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Goonɗinɗo am fu, ‟ilaaɗi diyam yonki mawɗi ilan e ɓerne mum” hande no Dewte bati.» ");
INSERT INTO fue_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","O batu nun kaa ɗon dow Ruuhu mo goonɗinɗo fu heɓata. Den Ruuhu hokkaaka taw, gam Yeesu teddinaaka taw. ");
INSERT INTO fue_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","No woɓɓe der jama'aare nen nani haala ka, wi'i: «Lalley kanko woni Annabiijo.» ");
INSERT INTO fue_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Woɓɓe wi'i: «Kanko woni Cuɓaaɗo.» Woɓɓe bo wi'i: «Cuɓaaɗo ƴiwan diga Galili na?» ");
INSERT INTO fue_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Dewte wi'ay ba, e lenyol annabi Dawda nun Cuɓaaɗo ƴiwata, der siire Baytilaama, to Dawda ƴiwi? ");
INSERT INTO fue_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Jama'aare nen luudontiri gam makko. ");
INSERT INTO fue_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","E woodi yiɗuɓe nanŋugo mo der maɓɓe, amma goɗɗo junŋo mum meemaay mo. ");
INSERT INTO fue_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Reenooɓe warti to hooreeɓe Limaamiiɓe e Farisaaɓe, ɓe ƴami ɓe, ɓe bi'i: «Ko woni sabbu ko on gadday mo?» ");
INSERT INTO fue_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Reenooɓe ɓen toontii, wi'i: «Abada goɗɗo batiray no gorko on batiri.» ");
INSERT INTO fue_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Farisaaɓe ƴami ɓe: «Onon bo on majjinaama hinaa? ");
INSERT INTO fue_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","E woodi baa gooto der hooreeɓe, maa bo der Farisaaɓe goonɗinɗo mo na? ");
INSERT INTO fue_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Amma jama'aare ne annaa tawreeta, ne yaa'aane» ");
INSERT INTO fue_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Gooto der maɓɓe, bi'eteeɗo Nikodemu, jahunooɗo to Yeesu wi'i ɓe: ");
INSERT INTO fue_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«Tawreeta meeɗen e hiitoo neɗɗo tawee nanaaka ko o bati, annaaka ko o waɗi na?» ");
INSERT INTO fue_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ɓe bi'i mo: «An bo a Galilinkeejo na? Wiɗita Dewte, a yi'an walaa annabiijo ƴiwuɗo Galili.»  ");
INSERT INTO fue_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ɓaawo mum, moy fu hooti wuro mum. ");
INSERT INTO fue_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Yeesu yawti far waanne Jaytuuje. ");
INSERT INTO fue_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Subaka kecco o witti der suudu Alla. Jama'aare fu wari. O jooɗii, oo janŋina ɓe. ");
INSERT INTO fue_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Moodiɓɓe tawreeta, e Farisaaɓe waddi debbo nanŋaaɗo e waɗa jeenu. Ɓe darni mo caka jama'aare. ");
INSERT INTO fue_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ɓe bi'i Yeesu: «Moodibbo, debbo oo ɗo nanŋa nun e waɗa jeenu. ");
INSERT INTO fue_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Muusa batii der tawreeta men, iri debbo oo ɗon kaaƴe nun warirtee. An bo, kaye bi'uɗaa?» ");
INSERT INTO fue_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ɓe baddu nun ɓe ƴoyra mo, gam ɓe keɓa no ɓe gaccorii mo. Amma Yeesu jimminii, e winna e honnu mum dow leydi. ");
INSERT INTO fue_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","No ɓe tokki ɓee ƴamitoo mo, Yeesu ɓanti hoore, wi'i ɓe: «Goɗɗo mooɗon mo waɗay hakke daɗey arta faɗɗa mo hayre.» ");
INSERT INTO fue_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","O jimminii kade, oo winna e leydi. ");
INSERT INTO fue_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","No ɓe nani ka, ɓe dilli gooto gooto. Nayeeɓe arti dilli. Yeesu e debbo on tan horii. ");
INSERT INTO fue_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yeesu ɓanti hoore, wi'i mo: «Debbo, toy ɓe goni? Baa gooto hiitaaki maa?» ");
INSERT INTO fue_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","O toontii, o wi'i: «Moodibbo, baa gooto.» Yeesu wi'i mo: «Min bo, mi hiitataako ma. Yahu, taa mayta kade waɗugo hakke.» ");
INSERT INTO fue_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yeesu baddi e maɓɓe kade, wi'i: «Min woni jayŋol duuniyaaru. Tokkuɗo am, yahataa e niwre abada, amma o heɓan jayŋol yonki.» ");
INSERT INTO fue_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Dow kaa ɗon, Farisaaɓe wi'i mo: «To aa seedanoo hoore maa, seedaaku maa jaɓataake.» ");
INSERT INTO fue_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yeesu toontii ɓe, wi'i: «Baa to mi seedanike hoore am, seedaaku am e laatii gooŋa, gam mii anni to ƴiwmi, mii anni to jahammi bo. Amma onon, on annaa to ƴiwmi, on annaa bo to jahammi. ");
INSERT INTO fue_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Oon gaɗa kiitaa hande no himɓe hiitortoo, amma min, mi hiitataako goɗɗo. ");
INSERT INTO fue_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","To mii waɗa kiita, kiita am e laatii gooŋa, gam mi hiitataako min tan, amma Baaba liloyɗo am, e wondi e am. ");
INSERT INTO fue_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","E winnii e tawreeta mooɗon: ‟Seedaaku himɓe ɗiɗo e laatii gooŋa”. ");
INSERT INTO fue_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Mii seedanoo hoore am. Baaba liloyɗo am bo, e seedanoo am.» ");
INSERT INTO fue_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ɓe bi'i mo: «Toy Baaba maa woni?» Yeesu toontii, wi'i ɓe: «On annaa am min, hakko Baaba am. To oon annunoo am, maa on anniino Baaba am bo.» ");
INSERT INTO fue_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yeesu batii haalaaji ɗii no o janŋinta der suudu Alla, to nokkuure ceede Alla wattetee. Goɗɗo nanŋay mo, gam wakkati makko yottaaki taw. ");
INSERT INTO fue_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yeesu wi'i ɓe kade: «Mi nani yaha, on daartan am, on maaydan e hakkeeji mooɗon. On baawataa ko yahi to jahanmi.» ");
INSERT INTO fue_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Yahuduuɓe wi'i: «O waritinto nun naa? Gam o wi'i en baawataa ko yahi to o yahata.» ");
INSERT INTO fue_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yeesu wi'i ɓe: «E ley jeyaɗon, amma min, dow jeyaami. E duuniyaaru nuu jeyaɗon, amma min, mi jeyaaka e maayru. ");
INSERT INTO fue_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Gam majjum bi'umi on: on maaydan e hakkeeji mooɗon. Gam to on goonɗinay min woni mo gonmi, on maaydan e hakkeeji mooɗon.» ");
INSERT INTO fue_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ɓe ƴami mo: «An moy nun laatiɗaa?» Yeesu toontii: «Mo bi'unoo mi on diga arande, laatiimi. ");
INSERT INTO fue_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Mii woodi huune ɗuuɗɗum ko batanmi, e ko kiitotoomi dow mon. Amma liloyɗo am laati nun gooŋaajo. Ko nanumi e makko, batanmi duuniyaaru.» ");
INSERT INTO fue_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ɓe paamay naa Baaba nun o batanta ɓe. ");
INSERT INTO fue_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Den Yeesu wi'i ɓe: «To Ɓii neɗɗo ɓilaama fu, den paamoton “min woni mo gonmi,” mi waɗataa bo goɗɗum e hoore am, amma mi batan nun ko Baaba ekkitinimmi tan. ");
INSERT INTO fue_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Liloyɗo am e wondi e am, o accay am min tan, gam ko welata mo gaɗanmi wakkati fu.» ");
INSERT INTO fue_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","No o bati hande nun, ɗuuɓɓe goonɗinii mo. ");
INSERT INTO fue_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yeesu wi'i Yahuduuɓe, goonɗinɓe ɗum: «To oon jogii haala am, on laati nun aahiiɓe am lalley. ");
INSERT INTO fue_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","On annan gooŋa. Gooŋa bo rinɗinan on.» ");
INSERT INTO fue_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ɓe toontii mo, ɓe bi'i: «Menen, men ƴiwi e lenyol Iburahiima, abada men laataaki maccuɓe goɗɗo. Noy bi'irtaa men dimɗan?» ");
INSERT INTO fue_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yeesu toontii ɓe, wi'i: «Mii bata on e gooŋa: gaɗoowo hakke fu laati nun maccuɗo hakke. ");
INSERT INTO fue_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Maccuɗo wonataako der saare baadey, amma ɓiɗɗo nun wonotoo der saare e baadey ");
INSERT INTO fue_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","To Ɓiɗɗo rinɗinii on, on laatoto rimɓe e gooŋa. ");
INSERT INTO fue_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Mii anni on ƴiwi e lenyol Iburahiima, amma oon daarta warugo am gam haala am naatay der mooɗon. ");
INSERT INTO fue_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ko ji'umi e Baaba kan nun batanmi, onon bo oon gaɗa ko Baaba mooɗon wi'i on.» ");
INSERT INTO fue_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ɓe toontii mo, ɓe bi'i: «Baaba amen woni Iburahiima.» Yeesu wi'i ɓe: «To on laatino ɓiɓɓe Iburahiima e gooŋa, maa on gaɗiino golle Iburahiima. ");
INSERT INTO fue_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Amma jooni oon daarta warugo am, min batuɗo on gooŋa ka nanumi to Alla. Ɗum ɗon Iburahiima waɗay ɗum. ");
INSERT INTO fue_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Onon, golle Baaba mooɗon gaɗoton.» Ɓe bi'i mo: «Menen, men jaaluuɓe bane, Baaba gooto men goodi, kanko woni Alla.» ");
INSERT INTO fue_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yeesu wi'i ɓe: «To Alla nun laatinoo Baaba mooɗon, maa on jiɗiino am, gam to Alla ƴiwmi, ko garumi. Mi wadday hoore am, amma kanko lilimmi. ");
INSERT INTO fue_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Gam ume ko on nanataa haala am? Gam on baawataa ko hettinii haala am. ");
INSERT INTO fue_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Seyɗan woni baaba mooɗon. Jiɗaaɗi baaba mooɗon gaɗoton. Baroowo nun o laatii diga fuɗɗoode. O walaa der gooŋa, gam gooŋa walaa der makko. To oo bata fewre, jikku makko nun, gam oo pewoowo, oo baaba fewre. ");
INSERT INTO fue_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Amma min, gam mii bata gooŋa, waɗi ko on goonɗinay am. ");
INSERT INTO fue_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Moy mooɗon waawata seedaago mi waɗii hakke? To mi batii gooŋa, gam ume ko on goonɗintaa am? ");
INSERT INTO fue_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Neɗɗo Alla nun hettintoo haala Alla. Onon, on kettintaako gam on laataaki himɓe Alla.» ");
INSERT INTO fue_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Yahuduuɓe wi'i mo: «Men batay gooŋa no men bi'i a laati nun samariyaajo, aa woodi bo ginnool na?» ");
INSERT INTO fue_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yeesu toontii ɓe, wi'i: «Mi woodaa ginnool, amma mii teddina Baaba am. Onon, oon jawoo am. ");
INSERT INTO fue_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Tedduŋal hoore am bane daartanmi. E woodi daartanoowo am tedduŋal, kiitotooɗo. ");
INSERT INTO fue_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Gooŋa batanmi on: Jaɓuɗo haala am fu, maayataa abada.» ");
INSERT INTO fue_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Yahuduuɓe wi'i mo: «Jooni men tabbitini aa woodi ginnool. Iburahiima e annabiiɓe fu maayi, amma an, a wi'ii: ‟Jaɓuɗo haala am fu, maayataa abada”. ");
INSERT INTO fue_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Aa ɓuri Iburahiima baaba amen manŋu na? O maayii, annabiiɓe bo maayii. Ume miiluɗaa aa laatii?» ");
INSERT INTO fue_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yeesu toontii ɓe, wi'i: «To hoore am teddinanmi, tedduŋal am laati nun baanji. Baaba am, mo bi'oton Alla mooɗon on nun teddintammi. ");
INSERT INTO fue_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","On annaa mo. Amma min, mii anni mo. To mi wi'ii mi annaa mo, mi laatoto pewoowo hande mooɗon. Amma mii anni mo, mi tokkii haala makko. ");
INSERT INTO fue_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Baaba mooɗon Iburahiima e seyorino yi'ugo nyalaane wittoygo am. O yi'ii ne, go ɓerne makko weli.» ");
INSERT INTO fue_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Yahuduuɓe wi'i mo: «A waɗay taw baa duuɓi lasoy ɗiɗi e sappo, go aa wi'a a yi'ii Iburahiima?» ");
INSERT INTO fue_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yeesu toontii ɓe, wi'i: «Mii bata on e gooŋa: Diga Iburahiima tagaaka, min, mi na'on.» ");
INSERT INTO fue_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Dow kaa ɗon ɓe etti kaaƴe ɓe paɗɗa mo. Amma Yeesu soltii, wurtii e suudu Alla. ");
INSERT INTO fue_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","No Yeesu yawtata, o yi'i gorko dimdaaɗo e bundan. ");
INSERT INTO fue_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Aahiiɓe makko ƴami mo, wi'i: «Moodibbo, moy waɗi hakke, kanko na, naa baaba e inna makko nun, ko o rindaa e bundan?» ");
INSERT INTO fue_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yeesu toontii ɓe wi'i: «Kanko bane waɗi hakke, baaba e inna makko bo bane. Amma gam baawɗe Alla yi'ee e makko nun. ");
INSERT INTO fue_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","No jayŋol na'on taw, haani gaɗen golle liloyɗo am. Gam jemma waran de goɗɗo waawataa ko gollii. ");
INSERT INTO fue_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","No mii tawaa e duuniyaaru, min woni jayŋol mayru.» ");
INSERT INTO fue_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Den, no o bati kaa ɗon, o tuuti joode e leydi, o laawi loope e joode ɗen, o moomi e gite bumɗo on. ");
INSERT INTO fue_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","O wi'i mo: «Yahu sulmaa weeldere Silowe.» (Ɗum wi'ay maa Lilaaɗo). O yahi, o sulmii. O warti oo yi'a. ");
INSERT INTO fue_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Wondunooɓe e makko, e yi'annooɓe mo oo fiya bara, wi'i: «Hinaa oo ɗo jooɗotono e fiya bara na?» ");
INSERT INTO fue_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Woɓɓe wi'i: «Kanko nun!» Woɓɓe bo wi'i: «Kanko bane! Nandi makko nun!» Gorko on e hoore mum wi'i: «Min nun lalley!» ");
INSERT INTO fue_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ɓe ƴami mo: «Noy bumtirɗaa?» ");
INSERT INTO fue_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","O toontii: «Gorko bi'eteeɗo Yeesu laawi loope, moomi e gite am, wi'immi: ‟Yahu weldere Silowe, culmoɗaa”. Jahumi, culmiimi, ko bumtumi.» ");
INSERT INTO fue_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ɓe ƴami mo: «Toy gorko on woni?» O toonti: «Mi annaa!» ");
INSERT INTO fue_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Den ɓe jaari bumtinaaɗo on to Farisaaɓe. ");
INSERT INTO fue_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Nyalaane Yeesu laawi loope wumtini mo, laati nun nyalaane siwteteene. ");
INSERT INTO fue_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Farisaaɓe bo ƴami mo, wi'i: «Noy bumtirɗaa?» O toontii ɓe: «O moomu nun loope e gite am, ko culmiimi, ko bumtumi.» ");
INSERT INTO fue_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Woɓɓe der Farisaaɓe wi'i: «Gorko on waawataa ko ƴiwi to Alla, gam o jogaaki nyalaane siwteteene.» Woɓɓe bo wi'i: «Noy gaɗoowo hakke waawirta ko waɗi iri kaayeefiiji ɗii ɗo?» Go ɓe ceenniri hakkune maɓɓe. ");
INSERT INTO fue_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Farisaaɓe ƴami bumtinaaɗo on kade, wi'i: «An kaye batataa dow bumtinɗo maa on?» O toontii ɓe, o wi'i: «Annabiijo nun.» ");
INSERT INTO fue_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Hooreeɓe Yahuduuɓe jaɓay naa oo laatino bumɗo, sey no ɓe noddi baaba e inna makko. ");
INSERT INTO fue_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ɓe ƴami ɓe: «Oo ɗo ɓiɗɗo mooɗon mo bi'uɗon rindaa e bumdan on nun ɗon na? Jon kan noy o wuntiri?» ");
INSERT INTO fue_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Baabiiko e inniiko toontii: «Emen anni ɓiɗɗo amen nun, e bumdan nun bo o rindaa. ");
INSERT INTO fue_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Amma no o wuntiri jooni, men annaa. Men annaa bo moy wuntini mo. Kanko bo o mawɗo nun. O waawan ko toontanii hoore makko. Ƴamee mo!» ");
INSERT INTO fue_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Baabiiko e inniiko toontorike nun nun gam ɓee kula hooreeɓe Yahuduuɓe. Gam ɓe desu nun: Neɗɗo fu jaɓi Yeesu laati nun Cuɓaaɗo, ɓe diiwa ɗum, ɓe burtina waajorde. ");
INSERT INTO fue_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Gam majjum saareeji makko wi'i: «O mawnii, ƴamee mo!» ");
INSERT INTO fue_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Farisaaɓe nodditii bumtinaaɗo on, ɓe bi'i mo: «Teddin Alla, emen anni, menen kan, gorko on hakkeejo nun.» ");
INSERT INTO fue_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","O wi'i ɓe: «To o hakkeejo nun, min kan, mi annaa. Goota tan annumi: Mi bumunooɗo, jooni mii yi'a.» ");
INSERT INTO fue_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ɓe ƴami mo: «Ume o waɗi e maa? Noy o wuntiniri maa?» ");
INSERT INTO fue_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","O toontii ɓe, o wi'i: «Mi batiino on ɗum, amma on kettinaaki. Gam ume go oon jiɗi nanitaago ka kade? Naa onon bo, on jiɗu nun laataago aahiiɓe makko?» ");
INSERT INTO fue_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ɓe jenni mo, ɓe bi'i: «An woni aahiijo makko! Menen, men aahiiɓe Muusa nun. ");
INSERT INTO fue_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Menen, emen anni Alla baddii e Muusa, amma kanko, men annaa to o ƴiwi.» ");
INSERT INTO fue_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Gorko on toontii ɓe, wi'i: «E ɗum haaynii no on annaa to o ƴiwi, ko o wuntinimmi! ");
INSERT INTO fue_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Een anni Alla hettinantaako waɗooɓe hakke, amma oo hettinanoo teddinɗo mo, gaɗoowo sago makko. ");
INSERT INTO fue_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Daɗey nanaaka bumtinɗo dimdaaɗo e bumdan. ");
INSERT INTO fue_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","To hinaa to Alla gorko on ƴiwi, o waawataano ko waɗi goɗɗum.» ");
INSERT INTO fue_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ɓe toontii mo: «An, bumbum, der hakkeeji dimaɗaa, an janŋinta men!» Ɓe nyeebi mo yaasi. ");
INSERT INTO fue_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yeesu nani ɓe nyeebii bumtinaaɗo on, yi'itii mo, ƴami mo: «An kan, aa goonɗini Ɓii neɗɗo na?» ");
INSERT INTO fue_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","O toontii: «Moodibbo, moy woni kanko faa mi goonɗina mo?» ");
INSERT INTO fue_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yeesu wi'i mo: «A yi'ii mo, baddoowo e maa woni kanko.» ");
INSERT INTO fue_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","O toontii: «Moodibbo, mii goonɗini.» O sujidani Yeesu. ");
INSERT INTO fue_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Den Yeesu wi'i mo: «Mi waru nun der duuniyaaru mi waɗa kiita, gam wumuɓe yi'a, yi'ooɓe wuma.» ");
INSERT INTO fue_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Farisaaɓe tawanooɓe ɗon, nani ka, ƴami mo, wi'i: «Menen bo, men wumuɓe na?» ");
INSERT INTO fue_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yeesu toontii ɓe: «To oon bumuno, on goodataano boofi. No bi'oton jooni oon ji'a, gam majjum boofi mooɗon tabitii.» ");
INSERT INTO fue_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yeesu wi'i: «Mii bata on e gooŋa, neɗɗo fu naatoowo der hoggo baali go naatiray dammugal, go ƴartorii to feere, kanko woni gujjo, kanko woni pasotooɗo. ");
INSERT INTO fue_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Amma duroowo baali, dammugal nun naatirta. ");
INSERT INTO fue_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Cakkiiɗo dammugal maɓɓitanan mo, baali ɗin bo nanan daane makko. O noddiran ɗi, ŋaye fu e inne mum, o yaara ɗi yaasi. ");
INSERT INTO fue_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","To o wurtinii ɗi ɗi fu, o ardoo ɗi, ɗi tokka mo gam ɗii anni daane makko. ");
INSERT INTO fue_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Abada ɗi tokkataa koɗo, amma ɗi doggan mo nun faa woɗɗi gam ɗi annaa daane hoɓɓe.» ");
INSERT INTO fue_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yeesu waɗani ɓe ballool ŋol, amma ɓe paamay ko ŋol fillitii. ");
INSERT INTO fue_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Yeesu wi'i ɓe kade: «Mii bata on e gooŋa, min woni dammugal baali. ");
INSERT INTO fue_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Artuɓe am warugo fu, laati nun wuyɓe e pasotooɓe, amma baali ɗii nananay ɓe. ");
INSERT INTO fue_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Min woni dammugal. Neɗɗo fu naatirɗo e am, hisan, heɓan durdugol, ooran, jaannyan. ");
INSERT INTO fue_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Gujjo warataa maa gam wujja, o wara, o biisa, amma min, mi waru nun gam himɓe heɓa yonki, heɓa ki kii heewi. ");
INSERT INTO fue_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Min woni duroowo geeto. Duroowo geeto woni kokkitiroowo yonki mum gam baali mum. ");
INSERT INTO fue_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Amma biiro, mo laataaki duroowo geeto, mo jeyaa baali, to yi'ii buuru, sey dogga, acca baali. Buuru nanŋa baali ɗin, sankita koriiɗi. ");
INSERT INTO fue_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Biiro on doggan gam faalaaka e majji. ");
INSERT INTO fue_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Min woni duroowo geeto. Mii anni baali am, baali am bo e annimmi. ");
INSERT INTO fue_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Hande no Baaba annirimmi, non annirmi Baaba. Mii hokka yonki am gam baali am. ");
INSERT INTO fue_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Mii woodi kade baali goɗɗi ɗi galaa der hoggo ŋo. Ɗii ɗon bo haani mi dura ɗum. Ɗi nanan daane am, ɗi laatoo darne woore, ɗi gooda duroowo gooto. ");
INSERT INTO fue_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Baaba e yiɗimmi gam mii hokkitira yonki am gam mi heɓitoo ki kade. ");
INSERT INTO fue_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Goɗɗo ittantaa am ki, min hokkata ki e hoore am. Mii woodi baawɗe hokkitirgo ki, mii woodi bo baawɗe heɓitaago ki. Ooda kaa ɗon keɓumi e Baaba am.» ");
INSERT INTO fue_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Batuuji ɗii seenni kade Yahuduuɓe. ");
INSERT INTO fue_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ɗuuɓɓe maɓɓe e wi'a: «Oo ginnaajiijo nun, o haaŋa nun. Gam ume go oon kettinanoo mo?» ");
INSERT INTO fue_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Amma woɓɓe wi'i: «Batu kaa, haala ginnaajiijo bane. Ginnool waawan ko wuntini bunɗo na?» ");
INSERT INTO fue_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Juulɗe senuki suudu Alla e waɗenoo Urusaliima. Ɗum fottii e dabbune. ");
INSERT INTO fue_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ley suudu Alla ɗon, Yeesu e yaha e warta ley danki Suleymaanu. ");
INSERT INTO fue_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Yahuduuɓe fiiltitii mo, wi'i mo: «Faa dey accataa men der seko? To an woni Cuɓaaɗo laaɓinan men.» ");
INSERT INTO fue_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yeesu toontii ɓe: «Mi batii on, on goonɗinay. Golleeji ɗi gaɗirmi inne Baaba am, e seedanoo am. ");
INSERT INTO fue_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Amma on goonɗinay gam on laataaki baali am. ");
INSERT INTO fue_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Baali am e nana daane am. Mii anni ɗi, ɗii tokkimmi. ");
INSERT INTO fue_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Mii hokka ɗi yonki tabitiiki, ɗi baatataa abada. Goɗɗo teetataa ɗi e junŋo am. ");
INSERT INTO fue_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Baaba am kokkuɗo am ɗi, ɓuri huune fu. Goɗɗo waawataa ko teeti ɗi e junŋo Baaba. ");
INSERT INTO fue_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Min e Baaba fu, men gooto.» ");
INSERT INTO fue_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Den Yahuduuɓe etti kade kaaƴe gam ɓe paɗɗa mo. ");
INSERT INTO fue_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yeesu wi'i ɓe: «Mi waɗii yeeso mooɗon golleeji booɗɗi ɗuuɗɗi e baawɗe Baaba. Der golleeji ɗin, ɗiye e majji jiɗanɗon warirgo am kaaƴe?» ");
INSERT INTO fue_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Yahuduuɓe toontii mo: «Gam golle booɗɗe bane men jiɗi warirgo maa kaaƴe, ko men jiɗi warirgo maa nun, gam a yennii Alla. An a tagaaɗo nun, a waɗii hoore maa Alla.» ");
INSERT INTO fue_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yeesu toontii ɓe: «Ɗum winnaaka der tawreeta mooɗon: ‟Alla wi'ii on, on allaaɓe na”?» ");
INSERT INTO fue_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","To tawreeta noddii allaaɓe, ɓe o baddi, een anni ko dewtere bati ikkintaake. ");
INSERT INTO fue_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Onon mo Alla seni, ko lili mo e duuniyaaru, oo ɗon nun bi'oton: ‟A yennii Alla!” Gam o wi'ii oo laatii Ɓiɗɗo Alla. ");
INSERT INTO fue_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","To mi waɗay golle Baaba am, to on goonɗinee am. ");
INSERT INTO fue_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Amma to mii waɗa ɗe, baa to on goonɗintaa am, min e hoore am, goonɗinee golle am, gam annon, paamon Baaba na'on e am, min bo mi na'on e Baaba.» ");
INSERT INTO fue_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ɓe daarti nanŋugo mo kade. O sottii ɓe. ");
INSERT INTO fue_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Yeesu wittii fonŋo maayo Urdun, nokkuure to Yuhaana waɗannoo batisi arande, o jooɗii ton. ");
INSERT INTO fue_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Himɓe ɗuuɓɓe wari e makko, wi'i: «Yuhaana waɗay alaama kaayniika baa goota. Amma, ko o bati e gorko on fu laati nun gooŋa.» ");
INSERT INTO fue_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ton ɗuuɓɓe goonɗini Yeesu. ");
INSERT INTO fue_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Gorko gom, bi'eteeɗo Lasar e tawano Baytaniya, o nyawi. Oo woodi sakikiraaɓe ɗiɗo, Mariyama e Marta. ");
INSERT INTO fue_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mariyama on nun woni moomunooɗo wardi e Joomiraawo, go o moytiri gaasa makko koyɗe Yeesu. Sakiike makko, Lasar nyawunoo. ");
INSERT INTO fue_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Sakikiraaɓe makko lili e Yeesu wi'a mo: «Moodibbo, beldiijo maa yanɗaa.» ");
INSERT INTO fue_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","No Yeesu nanunoo ka, wi'i: «Nyaw ɗum ɗon nyaw maayde bane. Ɗum waru nun gam tedduŋal Alla, gam Ɓiɗɗo Alla teddiniree e majjum.» ");
INSERT INTO fue_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yeesu e yiɗi Marta, e miiraawo mum, e Lasar. ");
INSERT INTO fue_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Baa no o nani Lasar yanɗaa, haɗay mo jooɗaago balɗe ɗiɗi to o wonunoo. ");
INSERT INTO fue_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ɓaawo majjum o wi'i aahiiɓe makko: «En bittee leydi Yahudiya!» ");
INSERT INTO fue_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Aahiiɓe wi'i: «Moodibbo, baa ɓooyay Yahuduuɓe e daartano warirgo maa kaaƴe, go ton nun bittataa?» ");
INSERT INTO fue_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yeesu toontii: «Hinaa wakkatiiji sappo e ɗiɗi woni der nyaalooma? Jahoowo nyaalooma fergataako gam oo yi'a jayŋol duuniyaaru nu. ");
INSERT INTO fue_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Amma jahoowo jemma fergoto gam jayŋol walaa e makko.» ");
INSERT INTO fue_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ɓaawo o bati haalaaji ɗii, o wi'i: «Giɗo meeɗen Lasar ɗaanike, mi yahan, mi finnina mo.» ");
INSERT INTO fue_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Aahiiɓe wi'i: «Moodibbo, to o ɗaani nun, o yoofoto.» ");
INSERT INTO fue_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Maayde Lasar nun o batannoo. Kamɓe ɓe miili haala ɗoyŋol nun o batani. ");
INSERT INTO fue_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Yeesu laaɓinani ɓe: «Lasar maayii! ");
INSERT INTO fue_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ɓerne am welii gam mooɗon ko mi tawaaka ton. Ɗum laatanto on daliila goonɗinon. To non en jahu, to makko.» ");
INSERT INTO fue_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Den Toma bi'eteeɗo Ciwto wi'i aahiiɓe horiiɓe: «En jahu enen bo gam maayden e makko.» ");
INSERT INTO fue_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","No Yeesu yottinoo, tawi waɗii balɗe naay Lasar e tawaa der saabeere. ");
INSERT INTO fue_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Hakkune Baytaniya e Urusaliima ɓuraa kilooji tati, ");
INSERT INTO fue_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Yahuduuɓe ɗuuɓɓe wari to Marta e Mariyama gam eytugo ɓe e maayde sakiike maɓɓe. ");
INSERT INTO fue_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","No Marta nani Yeesu warii, yahi taɓɓitoyii mo, tawi Mariyama e jooɗii der suudu. ");
INSERT INTO fue_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta wi'i Yeesu: «Moodibbo, to aa wonunoo ɗo, sakiike am maayataano. ");
INSERT INTO fue_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Amma baa jooni mii anni huune fu ko ƴamuɗaa Alla, o waɗante.» ");
INSERT INTO fue_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yeesu wi'i mo: «Sakiike maa fintan.» ");
INSERT INTO fue_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta wi'i: «Mii anni o fintan nyalaane ummital.» ");
INSERT INTO fue_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yeesu wi'i mo: «Min woni pintinoowo, min woni kokkoowo yonki. Neɗɗo fu goonɗinɗo am, baa to maayii, o wuuran. ");
INSERT INTO fue_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Buurɗo fu, goonɗinɗo am, maayataa abada. Aa goonɗini ɗum na?» ");
INSERT INTO fue_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","O toontii: «Ee, moodibbo! Mii goonɗini an woni Cuɓaaɗo, Ɓiɗɗo Alla, garoowo e duuniyaaru.» ");
INSERT INTO fue_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","E dow ɗum Marta yahi noddoygo miiraawo mum Mariyama, o sownii ɗum: «Moodibbo warii, oo noddee.» ");
INSERT INTO fue_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","No Mariyama nanuno kaa ɗon, ummii ɗon maa ɗon, yahi to makko. ");
INSERT INTO fue_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yeesu naatayno siire nen taw. Oo tawaa to Marta fottunoo e makko. ");
INSERT INTO fue_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Yahuduuɓe e wondunoo e Mariyama der suudu. Ɓee eyta mo. Ɓe ji'i o faɗɗitii, o wurtii. Ɓe tokki mo, ɓe miili o yahan nun e saabeere o wulla. ");
INSERT INTO fue_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","No Mariyama yotti to Yeesu, no o yi'i mo, o diccii yeeso makko, o wi'i: «Moodibbo, to aa wonunoo ɗo, sakiike am maayataano.» ");
INSERT INTO fue_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","No Yeesu yi'i Mariyama e Yahuduuɓe wondunooɓe e mum e wulla, hakkillo makko ummii, o wemmaa. ");
INSERT INTO fue_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","O ƴami: «Toy gattuɗon mo?» ɓe toontii: «Moodibbo, war, daaru!» ");
INSERT INTO fue_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yeesu wulli. ");
INSERT INTO fue_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Yahuduuɓe wi'i: «Daaree no o yiɗiri mo.» ");
INSERT INTO fue_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Woɓɓe e maɓɓe wi'i: «Bumtinɗo bunɗo waawataano ko haɗi gorko on maayugo na?» ");
INSERT INTO fue_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Hakkillo Yeesu ummii kade, o yahi to saabeere woni. Saabeere nen laati nun gayka maaɓɓiraaka hayre. ");
INSERT INTO fue_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yeesu wi'i: «Ikkinee hayre nen!» Marta, sakiike maayɗo, wi'i mo: «Moodibbo, o luuɓii ko, gam hanne waɗi balɗe naay oo woni der saabeere.» ");
INSERT INTO fue_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yeesu wi'i mo: «Mi wi'ay maa baa, to a goonɗinii, a yi'an baawɗe Alla?» ");
INSERT INTO fue_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ɓe ikkini hayre nen. Yeesu tiggitii, wi'i: «Baaba, mii yettee gam aa nananammi. ");
INSERT INTO fue_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Min kan, mii anni baadey fu aa nananammi. Amma mi baddu maa nun gam himɓe dariiɓe ɓee ɗo, gam ɓe goonɗina an nun lilimmi.» ");
INSERT INTO fue_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ɓaawo haalaaji ɗii, o bati e semme: «Lasar wurta!» ");
INSERT INTO fue_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Maayunooɗo on wurtii, juuɗe mum e koyɗe mum e fiilaa leppi, yeeso mum e soomii. Yeesu wi'i ɓe: «Piilitee mo, accon mo o yaha.» ");
INSERT INTO fue_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ɗuuggal e Yahuduuɓe warunooɓe to Mariyama, yi'uɓe ko Yeesu waɗi, goonɗini mo. ");
INSERT INTO fue_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Amma woɓɓe maɓɓe yahi to Farisaaɓe, bati ɓe ko Yeesu waɗi. ");
INSERT INTO fue_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Farisaaɓe ɓen e hooreeɓe Limaamiiɓe waɗi dawriine, wi'i: «Gorko oo e waɗa kaayeefiiji ɗuuɗɗi. Noy gaɗeten? ");
INSERT INTO fue_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","To en accirii mo nunnun, ɓe fu, ɓe goonɗinan mo. Romankeeɓe waran, halka en enen e nokkuure meeɗen ceniine e leydi meeɗen.» ");
INSERT INTO fue_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Gooto maɓɓe, bi'eteeɗo Kayafas, laatinooɗo hooreejo Limaamiiɓe duuɓol mum, wi'i ɓe: «Onon, on annaa goɗɗum. ");
INSERT INTO fue_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","On annaa gomma neɗɗo gooto maayana leydi men e ɓuri leydi nin fu halka.» ");
INSERT INTO fue_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Nani e hoore makko bane o bati haalaaji ɗii, amma gam o laatinoo hooreejo Limaamiiɓe duuɓol mum, o waɗay maa annabaaku e haani Yeesu maayana leydi nin. ");
INSERT INTO fue_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Leydi nin tan bane haani o maayana, amma gam o hawrita ɓiɓɓe Alla sankitiiɓe fu laatoo jama'aare woore. ");
INSERT INTO fue_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Diga nyaanne den, hooreeɓe Yahuduuɓe dawri warugo mo. ");
INSERT INTO fue_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Jon kan Yeesu acci yahugo e warta hakkune Yahuduuɓe. O yawti diga ɗon, o yahi siire wi'eteene Efrayim gonune ley haro. O jooɗodii ton e aahiiɓe makko. ");
INSERT INTO fue_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Juulɗe Yahuduuɓe bi'eteeɗe Paska ɓadike. Ɗuuggal e himɓe leydi nii yahi Urusaliima gam laaɓina ko'e mum diga juulɗe ɗen yottaaki. ");
INSERT INTO fue_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ɓee gonii e fageere suudu Alla, ɓee daarta Yeesu, ɓee ƴamontira: «O warataa e juulɗe ɗen? Naa no miiluɗon?» ");
INSERT INTO fue_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Tawi hooreeɓe Limaamiiɓe e Farisaaɓe batiino annuɗo to o woni fu, bata, heɓa o nanŋee. ");
INSERT INTO fue_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Balɗe jeego'o horii go juulɗe Paska yottoo, Yeesu yahi Baytaniya to Lasar mo o fintinnoo. ");
INSERT INTO fue_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ɓe jonŋani mo hiraane. Marta e yeɗa ɓe, Lasar e wondunoo e nyaamdooɓe e Yeesu. ");
INSERT INTO fue_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mariyama etti feccere liitiri nardi, caadiiɗum, waanji e koyɗe Yeesu, moytiri ɗe gaasa mum. Suudu ŋol fu luutti. ");
INSERT INTO fue_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Yahuuda Iskariyot, gooto der aahiiɓe makko, garoowo jammoo mo, ƴami: ");
INSERT INTO fue_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«Gam ume wardi ɗum sippaaka hande jaka ceede joddi golliiɗo duuɓol, ceede mum hokkee talakaaɓe?» ");
INSERT INTO fue_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ko acci o wi'i nun, hinaa gam yurmeene talakaaɓe, amma oo gujjo nun. Kanko woni jogiiɗo ceede, oo wujja ɗe. ");
INSERT INTO fue_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yeesu wi'i: «Accu debbo on seese. O waɗu ɗum nun gam nyalaane uweteemi. ");
INSERT INTO fue_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Talakaaɓe e tawdaa e mooɗon nyalaane fu. Min kan, mi tawdataake e mooɗon nyalaane fu.» ");
INSERT INTO fue_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Jama'aare Yahuduuɓe ɗuunne nanani Yeesu Baytaniya. Gam Yeesu tan bane ɓe gari, amma gam ɓe ji'a Lasar pintinaaɗo bo. ");
INSERT INTO fue_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Hooreeɓe Limaamiiɓe dawri warugo Lasar bo. ");
INSERT INTO fue_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Gam Lasar nun, Yahuduuɓe ɗuuɓɓe wurtii e maɓɓe, goonɗini Yeesu. ");
INSERT INTO fue_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Fini mum jama'aare ɗuunne, warune juulɗe, nani Yeesu e wara Urusaliima. ");
INSERT INTO fue_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ɓe calti bali, ɓe taɓɓitoyii mo. Ɓee kulgina, ɓee bi'a: «Hosana! Alla barkiɗin garduɗo e inne Joomiraawo, Laamiiɗo Isira'iila!» ");
INSERT INTO fue_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yeesu heɓi ɓinŋel babba, jooɗii dow maggel hande no winniraa e Dewte: ");
INSERT INTO fue_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","«Siire Siyoona, taa hulu! Daaru, Laamiiɗo maa e wara, e waɗɗii ɓinŋel babba.» ");
INSERT INTO fue_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Arande aahiiɓe makko faamayno ɗum. Ɓaawo ko Yeesu teddinaa, ɓe ciwtorii ɗum winnaanoma. Kanjum bo waɗi e makko. ");
INSERT INTO fue_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Jama'aare tawdanoone e makko no o noddunoo Lasar wurtoo e saabeere, o fintini ɗum, seedanike mo. ");
INSERT INTO fue_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Himɓe nani o waɗiino alaama kaayniika. Kanjum acci ɓe taɓɓitoyii mo. ");
INSERT INTO fue_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Farisaaɓe baddontiri, wi'i: «On ji'ii, walaa fu ko baawanɗon mo, duuniyaaru fu nani e tokkii ɓaawo makko.» ");
INSERT INTO fue_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Der himɓe warɓe Urusaliima juulɗe gam sujidana Alla, Yunaninkeeɓe e woni der maɓɓe. ");
INSERT INTO fue_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ɓe ɓattii Filippu mo Baytisayda, mo leydi Galili. Ɓe bi'i ɗum: «Moodibbo, emen jiɗi yi'ugo Yeesu.» ");
INSERT INTO fue_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filippu batoy Andere. Ɓe batoy Yeesu. ");
INSERT INTO fue_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yeesu toontii ɓe: «Wakkati teddinol Ɓii neɗɗo warii. ");
INSERT INTO fue_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Mii bata on e gooŋa: ɓinŋel gawri aawaaŋel, to ŋel nyolay, ŋel wonan nun ɓinŋel gootel. Amma to ŋel nyoli, ŋel rimaan faa ɗuuɗa. ");
INSERT INTO fue_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Neɗɗo fu jiɗuɗo yonki mum, dullan yonki tabitiiki, banyuɗo ki e duuniyaaru nu, heɓan yonki tabitiiki. ");
INSERT INTO fue_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","To goɗɗo e yiɗi jagganaago am, sey tokkammi. To gonmi fu, ɗon jagganiiɗo am bo wonata. Baaba teddinan neɗɗo jaggantooɗo am.» ");
INSERT INTO fue_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","«Jooni kan, mi wemmaama. Kaye bi'anmi? Mi waawataa ko wi'i: ‟Baaba hisinam e wakkati oo”, amma gam wakkati on nun garumi. ");
INSERT INTO fue_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Baaba, teddin inne maa.» Den daane nanaa e ƴiwoy dow kammu, wi'i: «Mi teddinii ne, mi teddinan ne kade.» ");
INSERT INTO fue_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Himɓe dariiɓe ton, nani daane nen, wi'i: «Ɗum laati nun riggaaŋo duule.» Woɓɓe wi'i: «Malaykaajo nun baddi e makko!» ");
INSERT INTO fue_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yeesu wi'i ɓe: «Gam am bane daane nee nanaa, ne nana nun gam mooɗon. ");
INSERT INTO fue_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Jooni woni kiita duuniyaaru. Jooni laamiiɗo duuniyaaru nuu, tippetee yaasi. ");
INSERT INTO fue_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Min, to mi ɓantaama dow fu, mi fooɗan himɓe fu e am.» ");
INSERT INTO fue_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Batuuji o batata ɗii, hollan nun maayde ne o maayata. ");
INSERT INTO fue_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Himɓe ɓen toontii mo: «tawreeta batii: ‟Cuɓaaɗo maayataa abada. Noy baawirtaa ko wi'i Ɓii neɗɗo ettete?” Moy woni Ɓii neɗɗo on?» ");
INSERT INTO fue_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yeesu toontii ɓe: «Jaayŋol na'on caka mon, amma ɗum ɓooyataa. Jahee diga oon goodi jayŋol, gam to niwre juhu on. Gam jahoowo der niwre annaa to yahata. ");
INSERT INTO fue_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Goonɗinee jayŋol diga oon goodi ŋol gam laatoɗon ɓiɓɓe jayŋol.» Ɓaawo Yeesu bati kaa ɗon, yawti suuɗoyii ɓe to woɗɗi.» ");
INSERT INTO fue_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Baa no o waɗi kaayeefiiji ɗuuɗɗi yeeso maɓɓe, ɓe goonɗinay mo, ");
INSERT INTO fue_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","nunnun haala annabi Esaaya goonɗiri: «Joomiraawo, moy goonɗini lilal meeɗen? Moy Joomiraawo holli baawɗe mum?» ");
INSERT INTO fue_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Esaaya wi'ii kade bo gam ume himɓe ɓen waawataa ko goonɗini: ");
INSERT INTO fue_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","«Alla wuminii ɓe, yoorinii ɓerne maɓɓe, gam to gite maɓɓe yi'u, to ɓerɗe maɓɓe faamu, to ɓe tuubu, to mi nyawtu ɓe bo.» ");
INSERT INTO fue_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Esaaya wi'u ɗum nun gam o yi'ii tedduŋal Yeesu, go o bati haala makko. ");
INSERT INTO fue_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Amma baa hooreeɓe Yahuduuɓe ɗuuɓɓe goonɗinii Yeesu. Amma gam Farisaaɓe, ɓe kulii wurtingo ɗum, gam to ɓe burtinee e waajorde. ");
INSERT INTO fue_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Gam ɓee jiɗi manoore himɓe ɓuri manoore Alla. ");
INSERT INTO fue_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yeesu towni daane, wi'i: «Goonɗinɗo am fu, min bane o goonɗini, amma lilɗo am nun o goonɗini. ");
INSERT INTO fue_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ji'uɗo am bo yi'ii liloyɗo am. ");
INSERT INTO fue_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Mi warii e duuniyaaru, mii jayŋol, gam goonɗinɗo am fu to jooɗoo der niwre. ");
INSERT INTO fue_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Nanuɗo haalaaji am go tokkay, min bane hiitotoo ɗum. Gam mi waray hiitaago duuniyaaru, gam mi hisina nu nun garumi. ");
INSERT INTO fue_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Caliiɗo am, to jaɓay haalaaji am, e woodi ko hiitantoo ɗum. Ko janŋimmi, kan hiitotoo ɗum nyalaane darŋal. ");
INSERT INTO fue_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Gam mi batanay hoore am, amma Baaba lilɗo am hokkimmi ko bi'anmi e ko janŋinammi. ");
INSERT INTO fue_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Mii anni ooda makko hokkata yonki tabitiiki. Ko batanmi, mi batan ɗum nun no Baaba batirimmi.» ");
INSERT INTO fue_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Nyaanne finata juulɗe Paska, Yeesu e anni wakkati o accata duuniyaaru o hoota to Baaba yottike. O yiɗii himɓe makko e duuniyaaru, oo yiɗi ɓe faa keerol yidde. ");
INSERT INTO fue_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Wakkati hiraane, Seyɗan watti e ɓerne Yahuuda Iskariyot ɓii Simon o jammoo Yeesu. ");
INSERT INTO fue_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yeesu e anni e hoore mum, to Alla nun ƴiwi, to Alla nun hootata. Baaba wattii huune fu der junŋo makko. ");
INSERT INTO fue_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","O ummii o acci hiraane nen, o ɓoorti toggoore makko, o etti lefol, o taadi. ");
INSERT INTO fue_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","O wayli diyam e lootorgal, o yanti lootugo koyɗe aahiiɓe makko, oo moytira ɗe lefol ŋol taadinoo. ");
INSERT INTO fue_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","No o yotti to Simon Piyer, Piyer wi'i mo: «Moodibbo, an lootata koyɗe am?» ");
INSERT INTO fue_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yeesu toontii mo: «A faamay jooni ko gaɗanmi, amma ɓaawo nii a faamaan.» ");
INSERT INTO fue_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Piyer wi'i mo: «A lootataa koyɗe am abada!» Yeesu toontii mo: «To mi lootay maa, a walaa geɗu e am.» ");
INSERT INTO fue_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simon Piyer wi'i mo: «Moodibbo! To nunnun, taa haaɗu e koyɗe tan, lootu juuɗe e hoore am bo.» ");
INSERT INTO fue_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yeesu wi'i mo: «Lootiiɗo walaa haaju looteego, sey loota koyɗe, gam o fu oo laaɓi. Onon on laaɓuɓe, amma on fu bane.» ");
INSERT INTO fue_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Oo anni jammotooɗo mo. Kan waɗi o wi'i: «On fu bane woni laaɓuɓe.» ");
INSERT INTO fue_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","No Yeesu lootunoo koyɗe maɓɓe, ettitii toggoore muuɗum, jooɗitii, ƴami: «On paamii ko gaɗanmi on? ");
INSERT INTO fue_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Oon noddammi moodibbo e maalan. On peway, kan nun laatiimi, ");
INSERT INTO fue_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","jon kan mi maalan nun, mi moodibbo bo, to mi lootii koyɗe mooɗon, onon bo oon kaani lootoontiron koyɗe. ");
INSERT INTO fue_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ko kollumi on laati nun tintinol. Onon bo gaɗee ko gaɗumi. ");
INSERT INTO fue_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Mii bata on e gooŋa, maccuɗo ɓurataa joomum, lilaaɗo ɓurataa lilɗo ɗum. ");
INSERT INTO fue_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","To oon anni ɗum, to on gollirii, barke laatanto on. ");
INSERT INTO fue_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","On fu bane batanmi. Mii anni ɓe cuɓumi, amma haani ko winnaa e dewte goonɗa: ‟Nyaamdoowo e am ummanike am.” ");
INSERT INTO fue_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Diga jooni mii bata on ɗum hakko ɗum yottoto, gam to ɗum yottike on goonɗina min woni “mo gonmi!” ");
INSERT INTO fue_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Mii bata on e gooŋa: Neɗɗo fu jaɓɓiiɗo lilaaɗo am, min nun o jaɓɓii. Neɗɗo fu jaɓɓiiɗo am, jaɓɓike lilɗo am.» ");
INSERT INTO fue_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ɓaawo no o bati nunnun, o jiɓii sanne, o wi'i: «Mii bata on e gooŋa: Gooto mooɗon jammoto am.» ");
INSERT INTO fue_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Aahiiɓe ɓen e daarontira. Ɓee ƴamontira moy o batanta. ");
INSERT INTO fue_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Gooto e aahiiɓe makko, mo Yeesu ɓuri yiɗugo, e jooɗii takkol makko. ");
INSERT INTO fue_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simon Piyer ɓaaƴi mo o ƴama Yeesu moy o wondanaa. ");
INSERT INTO fue_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Aahiijo on wuurorii far to gabaare Yeesu, wi'i: «Joomam moy nun?» ");
INSERT INTO fue_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yeesu toontii mo: «Mi suƴƴan lonŋere, mo kokkan mi ne, kanko nun.» Yeesu etti lonŋere, suƴƴi ne, hokki Yahuuda, ɓii Simon Iskariyot. ");
INSERT INTO fue_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ɓaawo o jaɓi lonŋere nen, Seyɗan naati e makko. Yeesu wi'i mo: «Waɗu ko gaɗataa, law!» ");
INSERT INTO fue_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","(Baa gooto e jooɗiiɓe ɗon faamay ko o batani kaa ɗon. ");
INSERT INTO fue_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Gam Yahuuda nun jogotono ceede maɓɓe, woɓɓe e miijii Yeesu wi'u nun o soodaa goɗɗum gam juulɗe, maa o heɓa ko o hokki talakaaɓe.) ");
INSERT INTO fue_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yahuuda no jaɓi lonŋere nen fu, ɗon maa ɗon o wurti. Tawii jemma waɗi. ");
INSERT INTO fue_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","No Yahuuda wurtinoo, Yeesu wi'i: «Ɓii neɗɗo teddinaama, Alla bo teddinaama sabbu makko. ");
INSERT INTO fue_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","To Alla teddinaama sabbu makko, Alla e hoore mum bo teddinan mo, baa ɓooyataa. ");
INSERT INTO fue_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Sukaaɓe am, mii wondi e mooɗon seɗɗa taw. On daartan am. Mi wi'an on jooni ko bi'unoo mi Yahuduuɓe woɓɓe: “On baawataa ko yahi to jahammi.” ");
INSERT INTO fue_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Mii hokka on ooda kesa: Jiɗontiree! Hande no jiɗirmi on, onon bo jiɗontiree! ");
INSERT INTO fue_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","To yidde e woni hakkune mooɗon, hande nun, himɓe fu annirta on aahiiɓe am.» ");
INSERT INTO fue_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simon Piyer wi'i mo: «Joomam, toy jahataa?» Yeesu toontii mo: «To jahanmi, a waawataa ko tokki am jooni. Amma ɓaawo ɗo a tokkan am!» ");
INSERT INTO fue_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Piyer wi'i mo: «Joomam, gam ume mi waawataa ko tokki maa jooni? Mi hokkitiran yonki am gam maa.» ");
INSERT INTO fue_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yeesu toontii: «Gooŋa a hokkitiran yonki maa gam am? E gooŋa batan maa mi: Hakko jakaraari joggata, a wi'an de tati a annaa am.» ");
INSERT INTO fue_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yeesu wi'i aahiiɓe mum: «Pukkinee ɓerɗe mooɗon, goonɗinee Alla, goonɗinon am min bo. ");
INSERT INTO fue_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Cuuɗi ɗuuɗɗi na'on der wuro Baaba am. To ɗum laataakino gooŋa, mi batataano on mi yahan, mi moƴƴinanaa on joonne. ");
INSERT INTO fue_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","To mi moƴƴinanii on to gonoyton, mi wittaan mi hocca on to am gam gonon to gonmi. ");
INSERT INTO fue_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Oon anni laawol jahoowol to jahanmi.» ");
INSERT INTO fue_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Toma wi'i mo: «Moodibbo, men annaa to jahataa, noy men annirta laawol mum?» ");
INSERT INTO fue_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yeesu toontii mo: «Min woni laawol, min woni gooŋa, min woni yonki. Goɗɗo yahataa to Baaba to ƴiwiray to am. ");
INSERT INTO fue_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","To oon annunoo am, on annanno Baaba am bo. Diga jooni oon anni mo, on ji'ii mo.» ");
INSERT INTO fue_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filippu wi'i mo: «Moodibbo, hollu men Baaba, ɗum ɗon heƴan men.» ");
INSERT INTO fue_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yeesu wi'i mo: «No ɓooydirmi e mooɗon nii fu, Filippu a annaa am? A annaa ji'uɗo am fu, yi'ii Baaba? Noy bi'irtaa: ‟Hollu men Baaba”? ");
INSERT INTO fue_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","A goonɗinay mii hawti e Baaba, Baaba bo e hawti e am na? Batuuji ɗi batumi on ɗii fu, ɗi ƴiway e hoore am. Baaba mo kawtumi e mum waɗata golle mum. ");
INSERT INTO fue_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Goonɗinee ko batumi on: ‟Mii hawti e Baaba, Baaba bo e hawti e am.” Baa to on goonɗinay am, goonɗinee gam golle am. ");
INSERT INTO fue_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Mii bata on e gooŋa, neɗɗo fu goonɗinɗo am, waɗan kanun bo golle gaɗanmi. O waɗan du ko ɓuri ɗe, gam mii dilla to Baaba. ");
INSERT INTO fue_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Mi waɗanan on huune fu ko ƴamirton e inne am. Mi waɗan ɗum gam Baaba teddinee diga e Ɓiɗɗo. ");
INSERT INTO fue_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ko eelirɗon e inne am, mi waɗan ɗum.» ");
INSERT INTO fue_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","«To oon jiɗi am, on tokkan ooda am. ");
INSERT INTO fue_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Mi eelan Baaba hokka on balloowo goɗɗo. O wondan e mooɗon faa abada. ");
INSERT INTO fue_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Oo ɗon woni Ruuhu gooŋa. Duuniyaaru nuu waawataa ko jaɓi mo, gam nu yi'ataa mo, nu annaa mo. Amma onon, oon anni mo gam oo wondi e mooɗon, oo tawaa bo der mooɗon. ");
INSERT INTO fue_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Mi accataa on hande gonɗaaɓe, mi wittaan to mooɗon. ");
INSERT INTO fue_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","To ɓooyii seɗɗa, duuniyaaru nuu yi'ataa am kade. Amma onon, on ji'an am, gam mi buurɗo, onon bo on buuran. ");
INSERT INTO fue_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Nyaanne muuɗum on paamaan mii hawti e Baaba, oon kawti e am, mii woni e mooɗon. ");
INSERT INTO fue_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Jogiiɗo oodaaji am ko tokki ɗi, kanko nun woni jiɗɗo am. Jiɗuɗo am, Baaba am yiɗan ɗum. Min bo, mi yiɗan mo, mi wirnitanto ɗum min e hoore am.» ");
INSERT INTO fue_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yahuuda, banda Yahuuda Iskariyot, wi'i Yeesu: «Joomam, noy ɗum laatortoo birnitanoɗaa men, tawee a wirtanaaki duuniyaaru?» ");
INSERT INTO fue_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yeesu toontii mo: «To goɗɗo e yiɗi am, o golliran haala am, Baaba am yiɗan mo. Min e Baaba men garda to makko, men jooɗodo e makko. ");
INSERT INTO fue_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Neɗɗo fu mo yiɗaa am, gollirtaa haala am. Haala ka nanoton ka, ka am bane, haala Baaba lilɗo am nun. ");
INSERT INTO fue_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Mi batii on ɗum diga mii wondi e mooɗon. ");
INSERT INTO fue_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ruuhu Ceniiɗo, balloowo on, mo Baaba liloyta e inne am, kanko anninta on kujje fu. O suwtoran on ko batunoomi on fu. ");
INSERT INTO fue_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Mii accana on jam, mii hokka on jam am. No duuniyaaru hokkirta bane kokkiranmi on. To ɓerɗe mooɗon biisoo, to on kulee. ");
INSERT INTO fue_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","On nanii ko bi'umi on: ‟Mi yahan, mi wartan to mon.” To oon jiɗunoo am, ɓerɗe mon welanno ko jahanmi to Baaba, gam kanko ɓurimmi manŋu. ");
INSERT INTO fue_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Mii bata on jooni, diga ɗum waray taw, gam to ɗum warii, goonɗinon. ");
INSERT INTO fue_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Mi baddataa kade e mooɗon ko ɗuuɗi, gam laamiiɗo duuniyaaru nuu e wara. Baa goɗɗum o waawataa e am, ");
INSERT INTO fue_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","amma sey duuniyaaru anna mii yiɗi Baaba, nu annan mi waɗan bo ko Baaba wannunoo am. Ummee, jawten diga ɗo.» ");
INSERT INTO fue_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","«Min woni innabohi gooŋahi, Baaba am woni jom gesa innabooje. ");
INSERT INTO fue_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Liccal takkiiŋal e am fu, to rimataa, o saltoto ɗum, liccal dimoowal fu, o saaɓanoo ɗum gam ŋal ɓeyda rimugo. ");
INSERT INTO fue_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Onon, jooni on laaɓuɓe gam waaju mo baajiimi on. ");
INSERT INTO fue_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Tabbitee e am, min bo mi tabbitoo e mooɗon! No liccal caltaaŋal waawataa ko rimi e hoore mum, haani e ŋal tiggii e innabohi, hande nun onon bo on baawataa ko rimi to on tiggaaki e am. ");
INSERT INTO fue_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Min woni innabohi, onon woni licce. Tiggiiɗo e am ko mii tiggii e mum, o rimaan faa ɗuuɗa. Gam on baawataa ko waɗi goɗɗum to ɗum ƴiway e am. ");
INSERT INTO fue_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","To goɗɗo tiggaaki e am, o woppete nun yaasi hande liccal caltaaŋal, o yoora. Licce joorɗe ɗen hawritinte, faɗɗee der yiite, ɗe jaɓa. ");
INSERT INTO fue_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","To on piɓontirii e am, waaju am bo e fiɓontirii e mon, ko ƴamoton fu, on keɓan. ");
INSERT INTO fue_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","To on dimii faa ɗuuɗi, den kan on laatike aahiiɓe am. Nunnun tedduŋal Baaba am wurtortoo. ");
INSERT INTO fue_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Hande no Baaba yiɗirimmi, nun jiɗirmi on. Tabbitee der yidde am. ");
INSERT INTO fue_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","To on tokkii ooda am, on tabbitinto der yidde am, hande no tokkirmi oodaaji Baaba am go mii tabbii der yidde makko.» ");
INSERT INTO fue_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","«Mi batu on nun kaa ɗon gam belɗum ɓerne am wona der mooɗon. Den belɗum ɓerne mooɗon bo hebba. ");
INSERT INTO fue_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ooda am nani: jiɗontiree hande no jiɗirmi on. ");
INSERT INTO fue_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Yidde ɓuroore yidde nee ɗo manŋu walaa, kokkitiroore yonki mum gam weldiiɓe mum. ");
INSERT INTO fue_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","To on gaɗii ko resanmi on on laati nun weldiiɓe am. ");
INSERT INTO fue_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Mi noddataa on kade maccuɓe gam maccuɗo annaa ko joomum gollata. Mi noddan on weldiiɓe gam ko nanumi diga Baaba am fu, mi anninii on ɗum. ");
INSERT INTO fue_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Onon bane suɓimmi, min suɓi on go desumi on jahon, dimoon ɓiɓɓe, ɓiɓɓe mooɗon taboo, den Baaba hokkan on huune fu ko eelirton e inne am. ");
INSERT INTO fue_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ko resanmi on woni, jiɗontiree.» ");
INSERT INTO fue_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","«To duuniyaaru nuu wanyii on, annee, min nu arti nu wanyi. ");
INSERT INTO fue_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","To oon laatinoo ɓe duuniyaaru, duuniyaaru yiɗanno ko mum. Amma onon ɓe duuniyaaru bane. Min seenni on e duuniyaaru, no cuɓumi on. Gam majjum nu wanyi on. ");
INSERT INTO fue_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ciwtoree ko bi'unoo mi on: ‟Maccuɗo ɓurataa joomum.” To ɓe toorii am, ɓe tooran on onon bo. To ɓe gollirii haala am, ɓe golliran haala mooɗon. ");
INSERT INTO fue_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Amma ɓe gaɗanan on ɗum ɗum fu gam am, gam ɓe annaa liluɗo am. ");
INSERT INTO fue_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","To mi warayno, to mi baddayno e maɓɓe, ɓe goodataano hakke, amma jooni, ɓe galaa accitaneego hakkeeji maɓɓe. ");
INSERT INTO fue_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Banyuɗo am fu, wanyii Baaba am bo. ");
INSERT INTO fue_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","To mi waɗayno golleeji ɗii hakkune maɓɓe, ɗi goɗɗo meeɗay waɗugo, ɓe goodataano hakke. Amma jooni ɓe ji'ii ɗi, ɓe banyii am, e min, e Baaba. ");
INSERT INTO fue_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ɗum waɗu nun gam ɗum goonɗina ko winnaa der Dewtere tawreeta maɓɓe: ‟Ɓe banyirii am baanji”. ");
INSERT INTO fue_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","To balloowo mo lildan mi on warii, kanko woni Ruuhu gooŋa ƴiwoowo to Baaba, kanko e hoore makko seedantoo am. ");
INSERT INTO fue_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Onon bo, on ceedanto am gam oon goondi e am diga fuɗɗoode.» ");
INSERT INTO fue_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","«Mi batii on ɗum gam to on majjee. ");
INSERT INTO fue_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ɓe burtinan on diga baajorɗe. Wakkati waran, barɗo on fu miijan Alla saafata. ");
INSERT INTO fue_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ɓe gaɗan ɗum nun gam ɓe annaa Baaba, ɓe annaa am, min bo. ");
INSERT INTO fue_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Mi batii on ɗum, gam to wakkati on waroy, ciwtoron, mi batiino on ɗum. Mi batay on ɗum diga arande gam mii wondunoo e mooɗon. ");
INSERT INTO fue_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Jooni mi na'on hoota to lilɗo am, amma baa gooto mooɗon ƴamay am: ‟Toy jahataa?” ");
INSERT INTO fue_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ɓerɗe mooɗon biisike gam mi batii on ka. ");
INSERT INTO fue_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Mii bata on e gooŋa, yaadu am ɓuran nafugo on. To mi yahay, balloowo on warataa to mooɗon. Amma, to mi yahii, mi lildan on mo. ");
INSERT INTO fue_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","To o warii, o anninan himɓe duuniyaaru boofi mum dow hakke, dow foonnitaare, e dow kiita. ");
INSERT INTO fue_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Dow hakke, ɓee boofa gam ɓe goonɗinay am. ");
INSERT INTO fue_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Dow foonnitaare, ɓee boofa gam mii hoota to Baaba am, on ji'ataa am kade. ");
INSERT INTO fue_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Dow kiita, ɓee boofa gam laamiiɗo duuniyaaru hiitaama ko. ");
INSERT INTO fue_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Mii woodi kade kujje ɗuuɗɗe ɗe batanmi on, amma on baawataa ko faami ɗe jooni. ");
INSERT INTO fue_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","To Ruuhu gooŋa warii, o anninan on gooŋa lalley, gam o batantaa hoore makko, amma o batan on ko o nani, o batan on bo ko warata. ");
INSERT INTO fue_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","O teddinan am gam o jaɓan ko woni e am, o yottina on ɗum. ");
INSERT INTO fue_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ko Baaba am jey fu, min jey, gam majjum bi'umi o yottinanan on ko o heɓi e am.» ");
INSERT INTO fue_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","«To ɓooyii seɗɗa, on ji'ataa am, to ɓooyii seɗɗa kade, ji'on am.» ");
INSERT INTO fue_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Woɓɓe e aahiiɓe makko ƴamontiri, wi'i: «Ume woni maana haala makko ka o wi'i: ‟To ɓooyi seɗɗa, on ji'ataa am e to ɓooyi seɗɗa, ji'on am kade”, gam mii yaha to Baaba?» ");
INSERT INTO fue_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ɓe bi'i: «To ɓooyii seɗɗa, ume ɗum hollata? Men paamay ko o wi'i.» ");
INSERT INTO fue_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","No Yeesu annunoo ɓe jiɗi ƴamugo ɗum, wi'i ɓe: «Oon ƴamontira maana haala am ka: “To ɓooyii seɗɗa on ji'ataa am, to ɓooyii seɗɗa kade, ji'on am.” ");
INSERT INTO fue_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Mii bata on e gooŋa: on bullan bullitoɗon, amma duuniyaaru nuu welweltan. Ɓerɗe mon biisoto, amma biisere ɓerne mon waylitinto welwelo. ");
INSERT INTO fue_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","To debbo ɓadike rimugo, o tooroto gam ŋatawre ɓillan mo. Amma to o rimii, o yeggitan naawella, ɓerne makko e weli gam o rimii neɗɗo e duuniyaaru. ");
INSERT INTO fue_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Onon bo hande nun ɓerɗe mon e biisii jooni, amma en jiidaan kade. Ɓerɗe mon welan, goɗɗo waawataa ko ikkini belɗum ɓerɗe mooɗon. ");
INSERT INTO fue_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Nyalaane nee ɗon, on ƴamataa am gokka dow goɗɗum. Mii bata on e gooŋa, huune fu ko eeluɗon Baaba, e inne am o hokkan on ɗum. ");
INSERT INTO fue_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Faa jooni, walaa fu ko eeluɗon e inne am. Eelee, on keɓan gam belɗum ɓerne mon hebba.» ");
INSERT INTO fue_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","«Ko batumi on jooni laati nun ballaaji. Wakkati waran de mi batirtaa on e ballaaji, amma mi batan on haala batanoowa Baaba faa laaɓa. ");
INSERT INTO fue_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Nyalaane nee ɗon on eelan Baaba e inne am. Mi wi'ay mi eelanan on Baaba, ");
INSERT INTO fue_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","gam Baaba e hoore muuɗum e yiɗi on. Oo yiɗi on gam oon jiɗimmi, on goonɗinii bo to Alla ƴiwmi. ");
INSERT INTO fue_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Mi ƴiwii to Baaba, mi warii e duuniyaaru, jooni mi accan duuniyaaru, mi hoota to Baaba.» ");
INSERT INTO fue_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Aahiiɓe makko wi'i mo: «Jooni kan, a batii faa laaɓi, a accii haalango men e ballaaji. ");
INSERT INTO fue_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Jooni kan, emen anni aa anni huune fu, a walaa bo haaju goɗɗo ƴamee gokka, gam majjum men goonɗini a ƴiwuɗo to Alla.» ");
INSERT INTO fue_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yeesu toontii ɓe: «Jooni kan, on goonɗinii na? ");
INSERT INTO fue_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Wakkati e wara, wakkati on yottike du, on fu on cankitinto, moy fu yaha feere mum, accon am mi tan. Amma min tan bane, gam Baaba e wondi e am. ");
INSERT INTO fue_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Mi batii on ɗum, gam keɓon jam der kawtal mooɗon e am. Oon gonii e ɓillaare der duuniyaaru. Amma tinnee, gam mi jaalike duuniyaaru.» ");
INSERT INTO fue_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ɓaawo haalaaji ɗin, Yeesu tiggitii dow, wi'i: «Baaba, wakkati warii, teddin Ɓiya, gam Ɓiya bo teddinee. ");
INSERT INTO fue_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","A hokkii mo baawɗe dow himɓe fu, gam o hokka ɓe kalfinɗaa mo fu yonki tabitiiki. ");
INSERT INTO fue_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Annugo an woni Alla gooto, gooŋaajo, e lilaaɗo makko Yeesu Almasiihu, kan woni yonki tabitiiki. ");
INSERT INTO fue_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Mi teddinii maa e duuniyaaru, mi hebbinii golle ɗe kokkuɗaa am mi golla. ");
INSERT INTO fue_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Jooni kan, Baaba, teddinam tedduŋal ŋal goodunoo mi to maa diga duuniyaaru tagaaka. ");
INSERT INTO fue_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Mi anninii inne maa himɓe duuniyaaru ɓe kalfinɗaa am. An ɓe gonannoo, a halfinii am ɓe. Ɓe jaɓi haala maa. ");
INSERT INTO fue_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Jooni kan, ɓee annii ko kokkuɗaa am fu, to maaɗa ɗum ƴiwi. ");
INSERT INTO fue_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Gam mi yottinii ɓe haala ka kaalanɗaa am. Ɓe jaɓii ka. Ɓee anni lalley to maaɗa ƴiwmi, ɓe goonɗinii an lilimmi. ");
INSERT INTO fue_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Gam sabbu maɓɓe nun du'otoomi. Mi du'ataako gam duuniyaaru. Amma mii du'oo gam ɓe kalfinɗaa am, gam an jey ɓe. ");
INSERT INTO fue_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Huune fu ko jeyumi, an jey, huune fu ko jeyɗaa, min jey. Mi teddinaama e maɓɓe. ");
INSERT INTO fue_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Mi wonataa der duuniyaaru kade, mii wara to maaɗa. Amma kamɓe ɓe na'on der duuniyaaru. An Baaba Ceniiɗo, reenir ɓe inne maaɗa ne kokkuɗaa am, gam ɓe laato gootum hande no laatoriɗen gootum. ");
INSERT INTO fue_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","No gondunoo mi e maɓɓe der duuniyaaru, mi reenirii ɓe inne maa ne kokkuɗaa am. Mi hakkilanii ɓe, baa gooto e maɓɓe majjay to hanaa ɓii halkere, gam ko batanaa e Dewte goonɗinee. ");
INSERT INTO fue_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Jooni kan mii foonni to maa. Mi batii haalaaji ɗii diga mi na'on e duuniyaaru gam belɗum ɓerne am hebba ɓe. ");
INSERT INTO fue_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Mi janŋinii ɓe haala maa, go duuniyaaru wanyi ɓe, gam ɓe duuniyaaru bane, hande no mi laatoraaki mo duuniyaaru. ");
INSERT INTO fue_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Mi eelay burtinaa ɓe e duuniyaaru, amma deenaa ɓe e Kalluɗo. ");
INSERT INTO fue_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ɓe duuniyaaru bane, hande no mi laatoraaki mo duuniyaaru. ");
INSERT INTO fue_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Senu ɓe e gooŋa maa. Haala maa woni gooŋa. ");
INSERT INTO fue_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Hande no lilirɗaa am e duuniyaaru, nunnun, liliranmi ɓe min bo e duuniyaaru. ");
INSERT INTO fue_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Mii sena hoore am gam maɓɓe gam kamɓe bo ɓe laatoo senaaɓe der gooŋa. ");
INSERT INTO fue_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Hinaa gam maɓɓe tan du'otoomi. Amma mii du'oo bo gam goonɗinanɓe am e haala maɓɓe. ");
INSERT INTO fue_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Mii eela gam ɓe laatoo gootum. Baaba, ɓe kawta e meeɗen hande no kawtirɗaa e am, no min bo kawtirmi e maa. Ɓe fu ɓe laatoo gootum, heɓa duuniyaaru hooloo an nun lilimmi. ");
INSERT INTO fue_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Min, mi hokkii ɓe tedduŋal ŋal kokkuɗaa am, gam ɓe laatoo gootum, hande no laatoriɗen gootum. ");
INSERT INTO fue_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Mi na'on hawti e maɓɓe, a na'on hawti e am, nunnun ɓe laatortoo gootum mam mam, heɓa duuniyaaru anna an lilimmi. Aa yiɗi ɓe bo hande no jiɗirɗaa am. ");
INSERT INTO fue_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Baaba, mii yiɗi ɓe kalfinɗaa am ɓee, tawdee e am nokkuure to tawaami, gam ɓe ji'a tedduŋal ŋal kokkuɗaa am, gam a yiɗii am diga duuniyaaru diidaaka. ");
INSERT INTO fue_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Baaba poonnitiiɗo, duuniyaaru nuu annay maa, min kan mii annu maa, ɓee ɗo bo annii an nun lilimmi. ");
INSERT INTO fue_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Mi anninii ɓe inne maa. Mi anninan ɓe ne kade gam yidde ne jiɗuɗaa am tawee e maɓɓe, min bo mi hawta e maɓɓe.» ");
INSERT INTO fue_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ɓaawo haalaaji ɗi, Yeesu yawtidi e aahiiɓe mum fonŋo maayel bi'eteeŋel Kedoron. Leɗɗe e ɗuuɗunoo ton, o naatidi ton e aahiiɓe makko. ");
INSERT INTO fue_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yahuuda jammotooɗo mo e anni nokkuure nen, gam Yeesu e aahiiɓe mum e hawritannoo ton de ɗuuɗɗum. ");
INSERT INTO fue_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Yahuuda ardii ililingal soogeeji, e reenooɓe ɓe Limaamiiɓe e Farisaaɓe lili. Ɓe jottii ɗon, ɓee jogii jolli, e fitillaaji e konirɗum. ");
INSERT INTO fue_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Tawii Yeesu e anni ko fonnoy heɓugo ɗum, taɓɓitii ɓe, wi'i: «Moy daartoton?» ");
INSERT INTO fue_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ɓe toontii mo: «Yeesu mo Nasaratu.» O wi'i ɓe: «Mi nani!» Yahuuda jammotooɗo mo e darodii e maɓɓe. ");
INSERT INTO fue_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","No Yeesu wi'unoo «Mi nani!» Ɓe tartartiri ɓawɓawre ɓe jani. ");
INSERT INTO fue_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yeesu ƴami ɓe kade: «Moy daartoton?» Ɓe toontii: «Yeesu mo Nasaratu!» ");
INSERT INTO fue_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yeesu toontii ɓe: «Mi wi'ii on, min nun. To min nun daartoton, joofee aahiiɓe am ɓen ɓe dilla.» ");
INSERT INTO fue_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","O batu nun kaa ɗon gam ka o batuno goonɗa: «Mi majjinay baa gooto e ɓe kalfinɗaa am.» ");
INSERT INTO fue_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Den Simon Piyer e woodunoo tabugaahi, saaɓii ki, feƴƴii maccuɗo hooreejo Limaamiiɓe, setti nowru mum nyaamooru. Maccuɗo on e wi'ee Malkus. ");
INSERT INTO fue_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yeesu wi'i Piyer: «Wattita tabugaahi maa kii e kuunŋal mum. Aa miiji mi yarirtaa jardugel bone ŋel Baaba hokkimmi na?» ");
INSERT INTO fue_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ililingal soogeeji e mawɗo maɓɓe, e maccuɓe hooreeɓe Yahuduuɓe nanŋi Yeesu, haɓɓi mo. ");
INSERT INTO fue_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ɓe artii yaarugo mo to Annas. Annas esiraawo Kayafas nun. Der duuɓol ŋol ɗon, kanko nun woni hooreejo Limaamiiɓe. ");
INSERT INTO fue_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayafas batunoo hooreeɓe Yahuduuɓe ko ɓuri wooɗugo, kan woni neɗɗo gooto maayana leydi fu. ");
INSERT INTO fue_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simon Piyer e aahiijo goɗɗo tokki Yeesu. Aahiijo oo ɗon e annirnoo e hooreejo yottinooɓe sadaka, o naatidi e Yeesu fageere hooreejo Limaamiiɓe on. ");
INSERT INTO fue_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Go Piyer e darii yaasi ley dammugal. Aahiijo annirɗo e hooreejo Limaamiiɓe on, wurti baddi e debbo deenoowo dammugal, naanni Piyer. ");
INSERT INTO fue_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Debbo deenoowo dammugal on wi'i mo: «An bo a laataaki gooto e aahiiɓe gorko oo na?» Piyer toontii mo: «Aawo, mi laataaki aahiijo makko.» ");
INSERT INTO fue_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Maccuɓe e reenooɓe huɓɓiino yiite e aytinoo, gam jaaŋol na'on. Piyer bo e darodii e maɓɓe e aytinii. ");
INSERT INTO fue_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Hooreejo Limaamiiɓe on ƴami Yeesu haala aahiiɓe mum, ƴami ko o janŋinta. ");
INSERT INTO fue_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yeesu toontii mo: «Mi laaɓinanii duuniyaaru haala am. Nyalaane fu mi janŋinii der baajorɗe, der suudu Alla to Yahuduuɓe hawritinta nyalaane fu. Walaa fu ko batumi e cuucukka. ");
INSERT INTO fue_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Gam ume ƴamantaa am? Ko batumi, ƴamu hettinaniiɓe am. Ɓee anni no ko wooɗi batumi.» ");
INSERT INTO fue_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Der haala ka, gooto e reenooɓe fiyi Yeesu meenyo, wi'i: «Nun nun toontortoɗaa hooreejo Limaamiiɓe na?» ");
INSERT INTO fue_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yeesu toontii mo: «To ko boni nun batumi, haala kay nun boni e makka. To tawii ko wooɗi nun batumi, gam ume piyanɗaa am?» ");
INSERT INTO fue_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Annas lildi mo to Kayafas hooreejo Limaamiiɓe, oo haɓɓaa. ");
INSERT INTO fue_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simon Piyer e aytininoo ɗon. Ɓe bi'i mo: «An bo, a laataaki gooto e aahiiɓe makko na?» Piyer yeddi, wi'i: «Mi laataaki!» ");
INSERT INTO fue_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Gooto e maccuɓe hooreejo Limaamiiɓe, gettol mo Piyer settunoo nowru muuɗum, wi'i mo: «Mi yi'idayno maa e makko der gesa to na?» ");
INSERT INTO fue_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Piyer yeddi kade, wakkati den nun, jakaraari joggi. ");
INSERT INTO fue_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ɓe burtini Yeesu diga to Kayafas, diga subaka kecco, ɓe jaari mo laamorde Roma. Yaaruɓe mo ɓee naatay ɓaade, gam to ɓe coɓu, faa ɓe keɓa nyaamugo nyaamdu juulɗe Paska. ");
INSERT INTO fue_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Pilaatu yahi tawoy ɓe yaasi ton, wi'i: «Ume beeforiɗon gorko oo?» ");
INSERT INTO fue_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ɓe toonti mo: «To o waɗataano ko boni, men gaddataano mo to maa.» ");
INSERT INTO fue_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Den Pilaatu wi'i ɓe: «Ettee mo, kiitoɗon mo e ooda mooɗon.» Yahuduuɓe wi'i mo: «Men goodaa laawol warugo goɗɗo.» ");
INSERT INTO fue_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Nunnun haala ka laatorii gam goonɗingo ka Yeesu batuno dow no o maayirta. ");
INSERT INTO fue_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilaatu naati der laamorde mum, noddi Yeesu, wi'i ɗum: «A laamiiɗo Yahuduuɓe nun na?» ");
INSERT INTO fue_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yeesu toontii mo: «An wi'i ɗum e hoore maa, naa to woɓɓe nanuɗaa ka?» ");
INSERT INTO fue_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilaatu toontii mo: «Mi Yahuduujo, min? Himɓe lenyol maa e hooreeɓe Limaamiiɓe waddu maa to am. Ko gaɗuɗaa?» ");
INSERT INTO fue_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yeesu toontii: «Laamaare am, laamaare duuniyaaru bane. To ne laamaare duuniyaaru nun, maccuɓe am haɓanno gam to mi naatu juuɗe Yahuduuɓe. Amma jooni Laamaare am ne ɗo bane.» ");
INSERT INTO fue_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Den Pilaatu wi'i mo: «To nunnun a laamiiɗo nun?» Yeesu wi'i mo: «Hande no bi'uɗaa, mi laamiiɗo nun. Mi rimaama, mi warii bo e duuniyaaru gam mi seedanoo gooŋa. Jiɗɗo gooŋa fu, nanan haala am.» ");
INSERT INTO fue_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilaatu ƴami mo: «Gooŋa, ume nun ɗon?» Ɓaawo o bati ka, o wurti kade, o tawoy Yahuduuɓe yaasi, o wi'i ɓe: «Mi heɓay gacce baa goote ɗe nanŋiranmi gorko oo. ");
INSERT INTO fue_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Oon boowi juulɗe Paska fu mi yoofana on neɗɗo gooto. Oon jiɗi mi yoofitana on laamiiɗo Yahuduuɓe na?» ");
INSERT INTO fue_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ɓe toonti dow dow: «Kanko bane, sey Barabbas.» Nani Barabbas laati nun pasotooɗo. ");
INSERT INTO fue_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Den Pilaatu wi'i ɓe nanŋa Yeesu ɓe piya mo looci. ");
INSERT INTO fue_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Soogeeji ɗin sanyi gi'e, ɓe kuunini mo, go ɓe ɓornini mo toggowa boɗeya. ");
INSERT INTO fue_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ɓe ɓattii mo, ɓee bi'a: «Foofo, laamiiɗo Yahuduuɓe!» Ɓee piya mo meeƴe. ");
INSERT INTO fue_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilaatu wurtii kade, wi'i Yahuduuɓe: «Mi wurtinanan on mo, heɓa annon mi heɓay fu gacce nanŋiran moo mi.» ");
INSERT INTO fue_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Yeesu wurti e huunii huuneere gi'e, e ɓornii toggowa boɗeya. Pilaatu wi'i ɓe: «Nani neɗɗo on.» ");
INSERT INTO fue_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","No hooreeɓe Limaamiiɓe e reenooɓe yi'i mo, ɓe bati dow ɓe bi'i: «Tiggu mo! Tiggu mo!» Pilaatu wi'i ɓe: «Nanŋee mo onon bo, tiggon mo, gam min kan, mi heɓay gacce e makko.» ");
INSERT INTO fue_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Yahuduuɓe toontii mo: «Emen goodi ooda, ooda kan nun hokki laawol o waree gam o waɗii hoore makko o Ɓii Alla.» ");
INSERT INTO fue_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","No Pilaatu nanunoo haala kan, kulol makko ɓeydii. ");
INSERT INTO fue_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","O naati der laamorde, o wi'i Yeesu: «An, toy ƴiwuɗaa?» Amma Yeesu toontaaki baa goota. ");
INSERT INTO fue_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Den Pilaatu wi'i mo: «A toontataako na? A annaa mii woodi baawɗe yoofugo maa, mii woodi bo baawɗe tiggugo maa na?» ");
INSERT INTO fue_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yeesu toontii mo: «Walaa fu ko baawɗaa e am, to hinaa Alla hokku maa baawɗe mum. Gam majjum gattuɗo am e junŋo maa, e ɓuru maa hakke.» ");
INSERT INTO fue_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Diga wakkati on Pilaatu e daarta yoofitingo mo. Amma Yahuduuɓe e bata dow, e wi'a: «To ni a yoofitii mo, a laataaki beldiijo laamiiɗo Roma. Gam neɗɗo gaɗuɗo hoore mum laamiiɗo, laati nun ganyo laamiiɗo Roma mawɗo.» ");
INSERT INTO fue_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","No Pilaatu nani haalaaji ɗii, o wurtini Yeesu o joonni mo dow kittaal kiita, nokkuure bi'eteene to kaaƴe yowyowtiri e ne wi'ee e Iburaninkeere: «Gabbata.» ");
INSERT INTO fue_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Nyalaane ciryaaɗe Paska nun, caka nyaalooma. Pilaatu wi'i Yahuduuɓe: «Nani laamiiɗo mooɗon!» ");
INSERT INTO fue_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ɓee boola: «Waru mo! Waru mo! Tiggu mo!» Pilaatu toontii: «Mi tigga laamiiɗo mooɗon na?» Hooreeɓe Limaamiiɓe wi'i: «Min galaa laamiiɗo to hinaa laamiiɗo Roma.» ");
INSERT INTO fue_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Den o hokki ɓe Yeesu, ɓe tiggaa. Ɓe kocci Yeesu. ");
INSERT INTO fue_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","O wurtii oo roonii palaaŋal makko faa o yottii nokkuure noddeteene «Le'al hoore» e ne wi'e e Iburaninkeere: «Golgota.» ");
INSERT INTO fue_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ɗon ɓe tiggidi mo e woɓɓe ɗiɗo: oo ɗo nano, oo ɗo nyaamo, Yeesu e tummii caka. ");
INSERT INTO fue_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilaatu waɗi alluwal winnaa hande ni: «YEESU MO NASARATU, LAAMIIƊO YAHUDUUƁE,» wi'i ŋal takkee e palaaŋal ŋal. ");
INSERT INTO fue_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ɗuuggal e Yahuduuɓe janŋii binni nin gam to Yeesu tiggaa woɗɗidaa e siire. Alluwal ŋal winniraama e Iburaninkeere e Romankoore e Yunaninkeere. ");
INSERT INTO fue_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Hooreeɓe Limaamiiɓe bati Pilaatu: «Taa winnu ‟Laamiiɗo Yahuduuɓe”, amma winnu: ‟Kanko wi'i o laamiiɗo Yahuduuɓe”.» ");
INSERT INTO fue_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilaatu toontii: «Ko binnumi, winnike.» ");
INSERT INTO fue_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","No soogeeji ɗin tiggidinno Yeesu, ɓe kocci gineeji makko ɓe ceenni ukke naay. Moy fu etti to mum. Horii gulunfaare ne lefol gootol, cannyaane diga dow faa ley, ne walaa nyoogol. ");
INSERT INTO fue_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Soogeeji ɗin baddi: «To en cerkitee ne, en piɗanee ne tete, daaren keɓanɗo ne,» gam ko bataa e dewte goonɗa: «Ɓe ceennii gineeji am hakkune maɓɓe, ɓe piɗani gulunfaare am tete.» Nun bo soogeeji ɗin waɗi. ");
INSERT INTO fue_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Inna Yeesu, e miiraawo mum, e Mariyama debbo Kolopas, e Mariyama mo Magadala e darii takkol leggal ŋal Yeesu tiggaa e mum. ");
INSERT INTO fue_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yeesu yi'i inna muuɗum e aahiijo mum mo ɓuri yiɗugo e darodii, wi'i inna muuɗum: «Inna, ɓiya nani!» ");
INSERT INTO fue_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ɓaawo mum, o wi'i aahiijo on: «Inna maa nani.» Diga nyalaane nee ɗon, aahiijo on hoori Mariyama wuro muuɗum. ");
INSERT INTO fue_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ɓaawo Yeesu anni walaa fu ko horii, gam ko winnaa e Dewte goonɗa, o wi'i: «Ɗonka e woodimmi.» ");
INSERT INTO fue_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ƴoogirgal kebbuŋal innabojam lammuɗam e wonunoo ɗon. Ɓe cuuwi soosuuji e innabojam ɗam, ɓe kaɓɓi e loocol, ɓe ɓattini e hunnuko makko. ");
INSERT INTO fue_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","No Yeesu ɓiccininoo innabojam ɗam, o wi'i: «Ɗum fu ɗum hebbii!» O jimminii, o maayi. ");
INSERT INTO fue_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Nyalaane ciryaaki juulɗe nun. Hooreeɓe Yahuduuɓe ƴami Pilaatu gam koyɗe tiggaaɓe heltee, ɓe ɓiltee. Ɓe jiɗaa ɓalli tiggaaɓe tawee e leɗɗe nyalaane siwteteene, gam nyalaane siwteteene nen laati nun nyalaane mawne. ");
INSERT INTO fue_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Soogeeji ɗin wari, helti koyɗe arandeejo e ɗiɗaɓo, tiggidaaɓe e Yeesu ɓen. ");
INSERT INTO fue_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Amma no ɓe jottino to Yeesu, ɓe tawi o maayii. Gam majjum, ɓe keltay koyɗe makko. ");
INSERT INTO fue_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Amma gooto e soogeeji ɗin yuwi wuttudu Yeesu e labbo. Ɗon ƴiiƴam e diyam facci. ");
INSERT INTO fue_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ji'uɗo e seedoo, seedaaku makko bo gooŋa nun. Oo anni o batii gooŋa gam onon bo, goonɗinon. ");
INSERT INTO fue_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ɗum fu ɗum waɗii gam ko bataa e Dewte goonɗa: «Baa ƴiƴal makko gootal heltataake.» ");
INSERT INTO fue_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Aayaare wonne der Dewtere bo wi'ii: «Ɓe daaran mo ɓe juwi.» ");
INSERT INTO fue_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ɓaawo mum, Yusufu mo Arimatiya, eeli Pilaatu hokka ɗum ɓannu Yeesu. Yusufu on e laatino aahiijo Yeesu e cuuccukka gam oo hulannoo Yahuduuɓe. Pilaatu nootii, Yusufu wari etti ɓannu kol. ");
INSERT INTO fue_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodemu, jahunooɗo to Yeesu der jemmaare gom, kanun bo warii, waddi urdiiji bi'eteeɗi, miir e alo'es jillontiraaɗi, ko waɗata kilooji laso e sappo. ");
INSERT INTO fue_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ɓe etti ɓannu Yeesu kol, ɓe piili ŋol leppi baanjaaɗi wardi hande no Yahuduuɓe woowi waɗugo to ɓee uwa maayɗo. ");
INSERT INTO fue_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","To Yeesu tiggano, gesa e wonunoo ɗon. Der gesa ŋan e woodunoo saabeere heyre ne baa goɗɗo uwaakano e muuɗum. ");
INSERT INTO fue_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ɗon ɓe gatti Yeesu gam sabbu ciryaaki juulɗe Yahuduuɓe, saabeere nen bo e ɓadii ɗon. ");
INSERT INTO fue_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Nyaanne alal, Mariyama mo Magadala hujji, yahi e saabeere Yeesu. O tawi hayre maɓɓiranoone saabeere nen tallitaama. ");
INSERT INTO fue_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","O doggi, o yahi to Simon Piyer e aahiijo mo Yeesu ɓuruno yiɗugo. O wi'i ɓe: «Moodibbo ikkinaama e saabeere, mi annaa to o wattaa.» ");
INSERT INTO fue_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Piyer e aahiijo oo ton wurtii, ɓe jahi e saabeere ton. ");
INSERT INTO fue_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ɓe fu ɗiɗo ɓee dogga. Aahiijo oo ton daɗi Piyer, arti mo yottaago saabeere. ");
INSERT INTO fue_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","O yuurnii, o yi'i leppi e joowi, amma o naatay. ");
INSERT INTO fue_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simon Piyer yottii, naati, tawi leppi e joowi. ");
INSERT INTO fue_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Lefol piilanooŋol e hoore makko ŋol hawritayno e leppi ɗii ton, ŋol tawa nun e ŋol resii feere maggol. ");
INSERT INTO fue_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Den aahiijo artuɗo yottaago on, kanun bo naati, yi'i ɗum, goonɗini. ");
INSERT INTO fue_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ɓe paamayno taw Dewte batiino Yeesu fintan. ");
INSERT INTO fue_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ɓaawo mum aahiiɓe ɓen hooti. ");
INSERT INTO fue_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Mariyama darii yaasi ley to saabeere, e wulla: O jimminii, oo yuurnoo der saabeere nen. ");
INSERT INTO fue_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","O yi'i malaykaaɓe ɗiɗo ɓorniiɓe gineeji daneeji e jooɗi to Yeesu fukkinanoo: Gooto e jooɗii to hoore wonnoo, gooto far to koyɗe. ");
INSERT INTO fue_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Malaykaaɓe ɓen ƴami mo: «Debbo, ume bullantaa?» O toontii ɓe: «Moodibbo am ikkinaama, mi annaa to o wattaa.» ");
INSERT INTO fue_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","No o batunoo haala ka, o yeeƴitii, o yi'i Yeesu e darii, amma o annitay ɗum. ");
INSERT INTO fue_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yeesu wi'i mo: «Debbo, ume bullantaa? Moy daartataa?» Amma kanko, oo miiji jom gesa nun baddata e makko, o wi'i ɗum: «To an etti mo, batan to gattuɗaa mo, faa mi ettitoo mo.» ");
INSERT INTO fue_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yeesu wi'i mo: «Mariyama.» Mariyama wonƴitii, wi'i mo e Iburaninkeere: «Rabbuni,» waato moodibbo. ");
INSERT INTO fue_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yeesu wi'i mo: «Taa meemam, gam mi eencay to Baaba am taw, amma yahu to banniraaɓe am, bi'aa ɓe: ‟Mi wonu nun mii eenca to Baaba am, laatiiɗo bo Baaba mooɗon, to Alla am, laatiiɗo bo Alla mooɗon”.» ");
INSERT INTO fue_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Mariyama mo Magadala batoy aahiiɓe: «Mi yi'ii Joomiraawo.» O holli ɓe ko Yeesu bati mo. ");
INSERT INTO fue_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Alal kiikiiɗe, aahiiɓe Yeesu fu hawriti der suudu, kullii dammugal gam kulol hooreeɓe Yahuduuɓe, Yeesu suppiti hakkune maɓɓe. O wi'i ɓe: «Jam wonana on!» ");
INSERT INTO fue_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ɓaawo haala ka, o holli ɓe newe juuɗe makko e wuttudu makko. Ɓerɗe aahiiɓe ɓen weli no ɓe ji'i Joomiraawo. ");
INSERT INTO fue_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Den Yeesu wi'i ɓe kade: «Jam wonana on. Hande no Baaba lilirimmi nunnun, liliranmi on.» ");
INSERT INTO fue_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","No o batunoo haalaaji ɗii, o fuufi dow maɓɓe, o wi'i: «Jaɓee Ruuhu Ceniiɗo. ");
INSERT INTO fue_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Mo jaafaniɗon hakkeeji mum, yaafaama, mo on jaafanaaki, yaafataake.» ");
INSERT INTO fue_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Toma bi'eteeɗo Ciwto, gooto e aahiiɓe sappo e ɗiɗo, walaano ɗon no Yeesu warunoo. ");
INSERT INTO fue_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Aahiiɓe ɓen wi'i mo: «Men ji'ii Joomiraawo!» O toontii ɓe: «To mi yi'ay ɓattarɗe newe makko, to mi wattay honnu am e julanɗe majje, mi watta junŋo am e wuttudu makko, mi goonɗintaa.» ");
INSERT INTO fue_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","No balɗe jeetati waɗi, aahiiɓe hawritii der suudu kade, Toma e wondi e maɓɓe. Dammuɗe fu e kullii, Yeesu suppiti hakkune maɓɓe, wi'i ɓe: «Jam wonana on!» ");
INSERT INTO fue_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","O wi'i Toma: «Waddu honnu maa, daaru newe am; waddu junŋo maa bo, wattu e wuttudu am. Taa laata mo hoolaaki, goonɗin tan.» ");
INSERT INTO fue_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Toma toontii mo: «Joomam, Alla am.» ");
INSERT INTO fue_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yeesu wi'i mo: «Gam a yi'ii am, a goonɗinii: Barke wonana ɓe ji'ay go goonɗini.» ");
INSERT INTO fue_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yeesu waɗii kaayeefiiji kaayniiɗi ɗuuɗɗi goɗɗi yeeso aahiiɓe mum ɗi winnaaka e dewtere nee. ");
INSERT INTO fue_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ɗii ɗo winnaama gam goonɗinon Yeesu laati nun Cuɓaaɗo, Ɓii Alla, gam to on goonɗinii mo, keɓon yonki sabbu makko. ");
INSERT INTO fue_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ɓaawo majjum, Yeesu wirnitanike aahiiɓe mum kade fonŋo maayo Tiberiya. Nani no o wirnitorii e maɓɓe: ");
INSERT INTO fue_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simon Piyer, e Toma bi'eteeɗo Ciwto, e Natanayel mo Kana, leydi Galili, e ɓiɓɓe Jebede worɓe, e aahiiɓe makko ɗiɗo woɓɓe, ɓee tawdaa ɗon. ");
INSERT INTO fue_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simon Piyer wi'i ɓe: «Mi yahan cuuɓaaki liƴƴi.» Ɓe bi'i: «Menen bo, men jahidan e maa.» Ɓe jahi, ɓe naatoy laana, der jemmaare nee ɗon, ɓe keɓay baa goɗɗum. ");
INSERT INTO fue_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","No beeggol ummoy, Yeesu wari e fonŋo ŋon, amma aahiiɓe annitay naa kanko nun. ");
INSERT INTO fue_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Yeesu wi'i ɓe: «Sukaaɓe, on keɓii liƴƴi na?» Ɓe toontii mo: «Men keɓay!» ");
INSERT INTO fue_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","O wi'i ɓe: «Paɗɗee taaruwol ŋol wecco laana nyaamo, on keɓan.» Ɓe paɗɗi ŋol. Ɓe keɓi liƴƴi faa ɓe tampi wattugo ŋol der laana sabbu no liƴƴi ɗuuɗiri. ");
INSERT INTO fue_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Aahiijo Yeesu mo o ɓuri yiɗugo wi'i Simon Piyer: «Joomiraawo nun!» No Simon Piyer nanunoo: «Joomiraawo nun», o etti ginewol makko, o ɓornii gam funtu o wonunoo, o yanti e diyam. ");
INSERT INTO fue_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Aahiiɓe woɓɓe wardi e laana kan, e daasa taaruwol kebbuŋol liƴƴi. Ɓe boɗɗoraaki fonŋo ko ɓurata kuule keme ɗiɗi. ");
INSERT INTO fue_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","No ɓe ŋabbunoo, ɓe ji'i ƴulɓe yiite, liƴƴi e peen e yowii dow mum. ");
INSERT INTO fue_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yeesu wi'i ɓe: «Gaddee liƴƴi ɗi nanŋuɗon ɗin.» ");
INSERT INTO fue_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simon Piyer naati laana, fooɗi taaruwol kebbuŋol liƴƴi mawɗi, hewre e lasoy ɗiɗi e sappo e tati. Baa no ɗi ɗuuɗiri nunnun fu taaruwol ŋol serkitaaki. ");
INSERT INTO fue_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yeesu wi'i ɓe: «Garee nyaamee!» Baa gooto e aahiiɓe ɓen suusay ƴamugo «An moy nun? Gam ɓee anni Joomiraawo nun.» ");
INSERT INTO fue_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Den Yeesu wari, etti peen e liƴƴi, hokki ɓe. ");
INSERT INTO fue_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Tatawre nun ɗon ko Yeesu wirnitanii aahiiɓe mum ɓaawo no o finti. ");
INSERT INTO fue_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","No ɓe nyaamdi, Yeesu ƴami Simon Piyer: «Simon ɓii Yuhaana, aa ɓuri ɓee ɗo yiɗugo am?» O toontii: «Ee! Joomam, aa anni mii yiɗu maa.» Den Yeesu wi'i mo: «Duru baali am!» ");
INSERT INTO fue_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yeesu wi'i mo kade: «Simon, ɓii Yuhaana, aa yiɗimmi?» O toontii: «Ee! Joomam aa anni mii yiɗu maa!» Den Yeesu wi'i mo: «Duru baali am!» ");
INSERT INTO fue_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","O wi'i mo kade: «Simon, ɓii Yuhaana, aa yiɗimmi na?» Piyer ɓerne mum biisii, gam o wi'i ɗum de tatawre: «Aa yiɗimmi na?» Piyer wi'i mo: «Joomiraawo aa anni huune fu, aa anni bo mii yiɗu maa.» Yeesu wi'i mo: «Duru baali am ɗii. ");
INSERT INTO fue_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Mii batee e gooŋa, e sukaanaaku maa, aa haɓɓonoo ɓelɓelol, jahaano to jiɗuɗaa, to a naywii, a ɓantan juuɗe maa, kaɓɓaneɗaa ɓelɓelol, jaareɗaa to a yiɗaa.» ");
INSERT INTO fue_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Batuuji ɗin hollan nun no Piyer maayirta, e no o teddinirta Alla. Ɓaawo majjum, o wi'i mo: «Tokkam». ");
INSERT INTO fue_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Piyer yeeƴitii, yi'i aahiijo Yeesu mo o ɓuri yiɗugo e tokki ɓe. Kanko woni bahinooɗo ley gabaare makko, wakkati ɓe kirtotoo, bi'unooɗo: «Moodibbo, moy woni jammotooɗo maa?» ");
INSERT INTO fue_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","No Piyer yi'unoo mo, ƴami Yeesu: «Joomam, noy oo ɗo heennyitirta?» ");
INSERT INTO fue_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yeesu toontii mo: «To mii yiɗii o wuura faa mi warta, ko faali maa? An ni tokkam.» ");
INSERT INTO fue_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Haala kan sankitii caka goonɗinɓe Yeesu ike aahiijo on maayataa. Amma Yeesu wi'ay: «O maayataa». O wi'u nun: «To mii yiɗi o wuura faa mi warta, ko faali maa?» ");
INSERT INTO fue_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Aahiijo oo ɗon nun seedii kujje ɗen, winni ɗe, emen anni bo seedaaku makko laati nun gooŋa. ");
INSERT INTO fue_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yeesu waɗii kujje goɗɗe ɗuuɗɗe kade: To ɗe binnaanoma gootel, gootel, mii miila duuniyaaru nuu waawataano jaɓidingo dewte binnoytenooɗe. ");
INSERT INTO fue_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Ɗerewol ŋol ƴiwii e am min Pol maccuɗo Yeesu Almasiihu. Mi noddaama gam mi laatoo lilaaɗo, mi suɓaama gam mi waajoo linjiila Alla. ");
INSERT INTO fue_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Linjiila kan, Alla haɓɓiino alkawal mum diga ɗum ɓooyi diga e annabiiɓe mum, der Dewte ceniiɗe. ");
INSERT INTO fue_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Eka batana Ɓiɗɗo makko, Joomiraawo meeɗen, ƴiwuɗo e lenyol Dawda diga e ɓannu. ");
INSERT INTO fue_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","O hollitaama e baawɗe, diga e Ruuhu Ceniiɗo, o laati nun Ɓiɗɗo Alla de o fintini mo e maayɓe. Kanko woni Almasiihu, Joomiraawo men. ");
INSERT INTO fue_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Diga e makko keɓumi moƴƴere laataago lilaaɗo, gam mi waɗa himɓe caka lenyi fu goonɗina mo, ɗowtanoo mo, ɓe teddina inne makko. ");
INSERT INTO fue_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Onon bo, on na'on caka maɓɓe, onon ɓe Yeesu Almasiihu noddi. ");
INSERT INTO fue_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Mii sanna on on fu, onon wonɓe Roma, yiɗaaɓe Alla, seniiɓe ɓe o noddi. Alla Baaba meeɗen, e Joomiraawo meeɗen Yeesu Almasiihu, hokka on moƴƴere e jam. ");
INSERT INTO fue_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Taw, mii yetta Alla am diga e Yeesu Almasiihu gam mooɗon on fu. Gam goonɗinki mooɗon e batanee der duuniyaaru fu. ");
INSERT INTO fue_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Alla mo jaggantoomi e ɓerne woore, emi waajoroo linjiila Ɓiɗɗo mum, e anni gooŋa nun batanmi. De du'otoomi fu, mii siwtora moy mooɗon fu. ");
INSERT INTO fue_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Mii eela Alla hokkammi laawol mi wara to mooɗon to oo yiɗi. ");
INSERT INTO fue_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Mii yiɗi yi'ugo on sanne, heɓa mi seennira e mooɗon dokkal Ruuhu gam ɗum semmiɗina on. ");
INSERT INTO fue_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Naa bo mi wi'a, to mi warii to mooɗon, deƴƴitinontiren en fu sabbu goonɗinki kawtuki en, min e mon. ");
INSERT INTO fue_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Banniraaɓe, mii yiɗi annon, no de ɗuuɗɗum mi daartii mi wara to mooɗon, amma faa jooni mi heɓoray taw. Mii yiɗi golle am rima ɓikkol caka mon, hande no ɗum laatorii to ɓe lenyi janani. ");
INSERT INTO fue_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Doole nun mi yaha to himɓe fu, fettuɓe gite e ɓe fettay, janŋuɓe e ɓe janŋay. ");
INSERT INTO fue_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Kanjum acci mii suunaa waajaago on linjiila, onon wonuɓe Roma. ");
INSERT INTO fue_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Mi sentirtaa linjiila, gam der makka baawɗe Alla kisinooje goonɗinɗo fu woni, aran Yahuduuɓe, ɓaawo mum ɓe lenyi janani. ");
INSERT INTO fue_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Gam der linjiila nun foonnitaare Alla hollitii. Foonnitaare nen, e goonɗinki tan ne heɓortoo, diga fuɗɗoode faa heennyitirde. E winnii der dewtere: «Poonnitiiɗo wuuran e goonɗinki.» ");
INSERT INTO fue_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Alla e hollita mone mum diga kammu dow himɓe ɓe hulataa mo fu, e dow waɗooɓe ko halli e suuɗira gooŋa der hallande mum. ");
INSERT INTO fue_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Ko haani neɗɗo anna dow Alla e laaɓani ɓe, gam Alla e hoore mum hollitii ɓe ɗum. ");
INSERT INTO fue_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Diga Alla tagi duuniyaaru, ko yi'ataake e makko, hande jon baawɗe makko tabitiiɗe, e Allaaku makko, e faamee diga ko o tagi. Gam majjum, yedduɓe woodaa laawol daɗirde. ");
INSERT INTO fue_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Ɓee anni Alla, amma ɓe teddinay mo hande no haani Alla teddiniree, ɓe jettay mo bo. Miilooji maɓɓe majjinii ɓe. Ɓerɗe maɓɓe ɗe galaa faamu niɓɓii. ");
INSERT INTO fue_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Ɓee gaɗa hande wooduɓe faamu, amma ɓe laatake haaŋaaɓe. ");
INSERT INTO fue_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Ɓe battontiri tedduŋal Alla mo maayataa e tooruuje nandinaaɗe e himɓe maayooɓe, e pooli, e bisaaji ɗi koyɗe naayi, e daasotooɗum. ");
INSERT INTO fue_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Gam majjum, Alla yoofi ɓe ɓe gaɗa coɓuɗum, hande no suuno ɓerɗe maɓɓe yiɗi. Nonnon ɓe coɓinirta ɓalli maɓɓe, kamɓe e ko'e maɓɓe. ");
INSERT INTO fue_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Ɓe battontirii gooŋa Alla e fewre. Ɓe teddinii ko tagaa, ɓe caafi ɗum, ɓe acci Taguɗo, mo yettoore wonani faa abada. Aami! ");
INSERT INTO fue_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Gam majjum, Alla yoofi ɓe ɓe tokkoo suunooji maɓɓe centiniiɗi. Rewɓe maɓɓe wattontiri baaldal hande no tawiraa, ɓee gaɗa ko luudontirii e ko tawaa. ");
INSERT INTO fue_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Hande non worɓe bo acci waaldugo e rewɓe, witti e waalontira hakkune mum. Ɓee gaɗontira ko sentinii hakkune maɓɓe. Hande non, ɓe keɓan riiba majjere maɓɓe. ");
INSERT INTO fue_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","No ɓe calii annitingo Alla, kan waɗi ko o yoofi ɓe der majjere maɓɓe, ɓe gaɗi ko haanay waɗeego. ");
INSERT INTO fue_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Ɓe kebbi hallande iri ney fu, e deeɗi bonɗi, e suunooji, e ganyaani. Ɓee kebbi kaajal e warugo himɓe e kaɓe e nyaamugo himɓe amaana. Ɓee ƴoƴi dow dabareeji bonɗi e munaafitaaje. Ɓee nyo'a himɓe. ");
INSERT INTO fue_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","Ɓee jaanca himɓe, ɓee banyi Alla, ɓee jara hennu. Ɓee goodi manŋu hoore, ɓee juro, ɓee goodi ƴoyre dow dabareeji bonɗi. Ɓe ɗowtantaako saareeji maɓɓe. ");
INSERT INTO fue_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Ɓe galaa hakkillo, ɓe kebbintaa ka ɓe bati. Ɓe galaa enɗam, ɓe galaa yurmeene. ");
INSERT INTO fue_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Ɓee anni, sariya ka Alla resi dow waɗooɓe iri majjum, maayde nun, ɓe daroraaki waɗugo ɗum tan, amma ɓee teddina waɗanɓe ɗum bo. ");
INSERT INTO fue_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","To non, an kiitotooɗo woɓɓe, baa to moy laatiɗaa, a woodaa laawol accitaneego hakku. To aa hiitoo woɓɓe, hoore maa nun kiitotoɗaa, gam ko kiitantoɗaa ɓe, kanjum gaɗataa. ");
INSERT INTO fue_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Een anni Alla hiitoto waɗooɓe huune ɗum e gooŋaaku. ");
INSERT INTO fue_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","An kiitotooɗo woɓɓe ko aa waɗa hande ko ɓe gaɗata, aa miili a daɗan kiita Alla na? ");
INSERT INTO fue_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Naa a wonu nun aa yawoo manŋu neɗɗaaku Alla e sawraare mum e munyal mum? A annitay no Alla hollii maa neɗɗaaku mum gam tuubaa na? ");
INSERT INTO fue_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","A yoorinii ɓerne maa, a yiɗaa tuubugo. Gam majjum, a fooɗanan hoore maa mone Alla mawne, nyaanne o hollitinta mone makko. Nyaanne mum, o hiitoto e tawreeta makko poonnitiika. ");
INSERT INTO fue_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","O yoɓan moy fu jaka gaɗu muuɗum. ");
INSERT INTO fue_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Tinniiɓe e waɗa ko wooɗi e daartira tedduŋal e manŋu e ko tabotoo, Alla hokkan ɓe yonki tabitiiki. ");
INSERT INTO fue_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Amma yiɗuɓe jeddi, e saliiɓe gooŋa, e tokki ko halli, mone e tikkere Alla yanan dow maɓɓe. ");
INSERT INTO fue_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Ɓillaare e jiɓayeere ɗuuɗanan gaɗoowo ko halli fu, aran, Yahuduuɓe, den ɓe lenyi janani. ");
INSERT INTO fue_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Manŋu e tedduŋal e jam laatanto waɗooɓe ko wooɗi fu, aran, Yahuduuɓe, den ɓe lenyi janani. ");
INSERT INTO fue_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Gam Alla suttontirtaa himɓe. ");
INSERT INTO fue_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Waɗuɓe hakke dow dullere annal tawreeta fu, halkan hinaa e tawreeta. Amma waɗuɓe hakke e anniri tawreeta, hiitorte e tawreeta. ");
INSERT INTO fue_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Hettintooɓe tawreeta bane laatii foonnitiiɓe yeeso Alla. Gollirooɓe ko tawreeta bati tan, laatintee foonnitiiɓe. ");
INSERT INTO fue_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Ɓe lenyi janani, woodaa tawreeta, amma ɓee gaɗa ko tawreeta wi'i e sago maɓɓe. Ɓe goodaa tawreeta, amma ɓee laatanii ko'e maɓɓe tawreeta. ");
INSERT INTO fue_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Ɓe kollitii golle ɗe tawreeta ƴami e winnii e ɓerɗe maɓɓe. Cuuɗiiɗum ɓerɗe maɓɓe e seedanoo ɓe ɗum. Tife miilooji ɓerɗe maɓɓe e gaccoo ɓe, tife bo, ɗii caloroo ɓe. ");
INSERT INTO fue_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Ɗum hollitinto nyaanne Alla hiitoto miilooji himɓe cuuɗiiɗi. O waɗan ɗum diga e Yeesu Almasiihu, hande no linjiila ka baajotoomi bati. ");
INSERT INTO fue_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Aa nodda hoore maa Yahuduujo, aa darii dow tawreeta, aa juroro Alla. ");
INSERT INTO fue_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Aa anni ko Alla yiɗi, aa anni suttontirgo ko wooɗi gam a janŋinaama tawreeta. ");
INSERT INTO fue_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Aa miili a fotii ardanaago wumuɓe, kollaa wonuɓe der niwre jayŋol. ");
INSERT INTO fue_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","Aa ekkitina ɓe galaa annal, aa janŋina sukaaɓe. Aa woodi annal e gooŋa diga e tawreeta. ");
INSERT INTO fue_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","An janŋinoowo woɓɓe, a janŋintaa hoore maa na? Aa waajoo woɓɓe to ɓe bujju, go an aa wujja! ");
INSERT INTO fue_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Aa wi'a: «to on jeenee», go an aa jeena? Aa wanyi tooruuje, go aa wujja ko woni der cuuɗi majje! ");
INSERT INTO fue_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Aa mawnitoroo tawreeta, go aa yawna Alla e ƴaartaago ka. ");
INSERT INTO fue_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Dewtere wi'ii: «Gam daliila mooɗon acci ɓe lenyi janani e yenna inne Alla.» ");
INSERT INTO fue_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","E gooŋa juulnol e nafa to a ɗowtanike tawreeta, amma to a ƴaartake tawreeta, a laatake hande a juulnaaki. ");
INSERT INTO fue_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","To mo juulnaaki waɗii ko sariya ƴamata, mo juulnaaki on fotay daareego hande juulniiɗo na? ");
INSERT INTO fue_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Mo juulnaaki, go e ɗowtanii ko tawreeta bati, o hiitete an gooduɗo tawreeta e juulnol, go a ɗowtanaaki ka. ");
INSERT INTO fue_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Hinaa ko yi'etee yaasi ɓannu laatinta neɗɗo Yahuduujo, hinaa bo ko waɗetee dow ɓannu laatii juulnol. ");
INSERT INTO fue_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Yahuduujo e gooŋa, woni laatiiɗo ɗum diga der. Juulnol gooŋakuwol bo woni ŋol Ruuhu waɗata der ɓerne, hinaa ŋol tawreeta waɗata. Iri Yahuduujo on, Alla nun manata ɗum, himɓe bane. ");
INSERT INTO fue_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Den to non, ume nun Yahuduujo ɓurdiri ɓe lenyi janani? Ume woni nafuwe juulnol? ");
INSERT INTO fue_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Nafuwe majjum e mawni dow laabi fu. Aran, Yahuduuɓe nun Alla arti yowani haala mum. ");
INSERT INTO fue_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","To non, to woɓɓe maɓɓe laataaki hoolaaɓe, ɗum haɗan Alla laataago koolaaɗo na? ");
INSERT INTO fue_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Waɗataako! Ɗum annitinte no Alla laati nun gooŋaajo, himɓe fu bo e laatii fewooɓe. Gam e winnii: «A annitinte aa laatii poonnitiiɗo diga e haala maa, to a hiitaama, a jaaloto.» ");
INSERT INTO fue_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Amma to dullere gooŋaaku meeɗen e hollita foonnitaare Alla, den ume bi'eten? Alla laataaki poonnitiiɗo to mone makko ummake dow meeɗen na? Mii bata ɗo hande no himɓe batirta. ");
INSERT INTO fue_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Aawo nun nun bane, Gam to non non nun, noy Alla hiitortoo duuniyaaru? ");
INSERT INTO fue_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Gam to fewre am e ɓeyda hollugo gooŋa Alla, e teddina mo, ume kiitanteemi hande mi laati nun hakkeejo? ");
INSERT INTO fue_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Woɓɓe e hallina men e wi'a, menen nun wi'ata: «En gaɗee ko halli gam ko wooɗi wurtoo diga e majjum.» Kamɓe, ɓe kiitete no haaniri. ");
INSERT INTO fue_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","To non, enen Yahuduuɓe een ɓuri horiiɓe na? Aawo, baa seɗɗa! Gam mi hollii no Yahuduujo e mo laataaki Yahuduujo fu na'on e baawɗe hakke. ");
INSERT INTO fue_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Dewtere wi'ii: «Poonnitiiɗo walaa, baa gooto, ");
INSERT INTO fue_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","mo faamu baa gooto walaa, daartoowo Alla walaa, baa gooto. ");
INSERT INTO fue_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Himɓe fu majjii, ɓe fu ɓe biisake, gaɗoowo ko wooɗi walaa, baa gooto. ");
INSERT INTO fue_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Konoli maɓɓe e nandi e caabeeje maɓɓitiiɗe, ɓee jammoo himɓe e ɗelle maɓɓe. Tonɗi kunnuɗe maɓɓe e hebbi tooke, hande bolle pure. ");
INSERT INTO fue_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Kunnuɗe maɓɓe e hebbi jaa'ooje e boliiɗe naawuɗe. ");
INSERT INTO fue_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Koyɗe maɓɓe e yawɗanoo reƴƴitingo ƴiiƴam himɓe. ");
INSERT INTO fue_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Halkere e bone e woni to ɓe jahi fu. ");
INSERT INTO fue_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Ɓe annaa laawol jam. ");
INSERT INTO fue_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Kulol Alla walaa e ɓerɗe maɓɓe baa seɗɗa.» ");
INSERT INTO fue_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Een anni ko tawreeta wi'i fu, ka wi'anay ɗum maa wonɓe e makka. Den kunnuɗe fu muɓɓoto, gacce himɓe fu annitee yeeso Alla. ");
INSERT INTO fue_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Gam majjum, walaa laatinteeɗo poonnitiiɗo yeeso Alla e tokkugo tawreeta. Gam tawreeta hollan nun himɓe hakkeeji mum. ");
INSERT INTO fue_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Jooni, Alla hollitii laawol no o laatinirta himɓe foonnitiiɓe, hinaa e tokkugo tawreeta. Nun dewte tawreeta, e annabiiɓe seedinoo der binni. ");
INSERT INTO fue_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Alla laatinan himɓe foonnitiiɓe gam ɓe goonɗinii Yeesu Almasiihu. Ɗum laatanto goonɗinɗo fu, gam Alla ɓurontirtaa himɓe. ");
INSERT INTO fue_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Himɓe fu waɗii hakke, ɓe tampi yottaago tedduŋal ŋal Alla hokkata. ");
INSERT INTO fue_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Amma Alla waɗanii ɓe moƴƴere, laatini ɓe foonnitiiɓe gam Yeesu Almasiihu, cooditiiɗo ɓe. ");
INSERT INTO fue_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Kanko nun Alla laatini sadaka moytoojum hakkeeji goonɗinɓe ƴiiƴam makko. Hande non Alla hollitiri foonnitaare mum e munyal mum dow hakkeeji gaɗanooɗi hiitaaka. ");
INSERT INTO fue_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","O waɗii ɗum gam o hollita foonnitaare makko der wakkati ki gonɗen jooni. Ɗum hokkii mo laawol laataago poonnitiiɗo e laatingo goonɗinɗo Yeesu fu poonnitiiɗo. ");
INSERT INTO fue_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Ume nun horii ko jurortee kade? Goɗɗum walaa! E sariya kaye? E ɗowtanaago tawreeta na? Gam Alla daarataa ɗowtanaago tawreeta, goonɗinki tan o daarata. ");
INSERT INTO fue_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Gam emen miili e goonɗinki nun neɗɗo laatinirtee poonnitiiɗo, hinaa gam tokkugo tawreeta. ");
INSERT INTO fue_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Naa Alla laati nun Alla mo Yahuduuɓe tan na? O laataaki Alla ɓe lenyi janani na? Seko walaa, o laati nun Alla ɓe lenyi janani bo. ");
INSERT INTO fue_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Alla gooto nun woni. Kanko laatinta juulniiɓe foonnitiiɓe sabbu goonɗinki maɓɓe. Kanko bo laatinta ɓe juulnaaki foonnitiiɓe sabbu goonɗinki maɓɓe. ");
INSERT INTO fue_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Den fu, en moytan nun tawreeta gam en goonɗinii na? Abada! En moytataa ka, amma een tabbitina ka! ");
INSERT INTO fue_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Ume bi'eten dow Iburahiima maama lenyol meeɗen? Ume o heɓi? ");
INSERT INTO fue_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","To Iburahiima laatinaama poonnitiiɗo gam gaɗu mum, den o waawan ko mawnitii, amma yeeso Alla bane. ");
INSERT INTO fue_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Gam Dewtere wi'i: «Iburahiima goonɗinii Alla, go Alla daari mo poonnitiiɗo sabbu goonɗinki makko.» ");
INSERT INTO fue_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","To goɗɗo gollake, sey joomum yoɓee joddi mum, moƴƴere bane o waɗanaa, ko haanani mo nun. ");
INSERT INTO fue_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Hande jon bi'en goɗɗo waɗay golle, amma o goonɗinii Alla laatinoowo hakkeeɓe foonnitiiɓe. Alla daaran mo poonnitiiɗo gam goonɗinki makko. ");
INSERT INTO fue_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Hande nun Dawda batirani barke ɗe neɗɗo heɓata to Alla, baa to o waɗay gaɗu geetu. O wi'i: ");
INSERT INTO fue_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","«Barke laatanii ɓe boofi mum yaafaa, e ɓe hakke mum moytaa. ");
INSERT INTO fue_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Barke laatanii neɗɗo mo Joomiraawo limay hakkeeji mum.» ");
INSERT INTO fue_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Barke ɗen juulniiɓe tan nun resanaa ɗe na? ɗe laatanaaki ɓe juulnaaki na? Gam en bi'ii: «Alla daarii Iburahiima poonnitiiɗo gam goonɗinki mum.» ");
INSERT INTO fue_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Wakkati dey nun ɗum laatanii Iburahiima? De o juulnii na? Naa, de o juulnaaki? De o juulnii bane, amma diga o juulnaakino nun. ");
INSERT INTO fue_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Alla hokkii mo juulnol, ŋol laatii alaama foonnitaare ne o heɓi. E goonɗinki o heɓi ɗum diga o juulnaakino. Hande non, o laatorii maama goonɗinɓe fu, ɓe juulnaaki, gam kamɓe bo ɓe daaree foonnitiiɓe. ");
INSERT INTO fue_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","O laatake bo baaba juulniiɓe. Ɓe daroraaki juulnol tan nun batananmi, amma tokkuɓe laawol goonɗinki maama meeɗen Iburahiima, diga o juulnaaki. ");
INSERT INTO fue_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Iburahiima e lenyol mum haɓɓanaama alkawal rona duuniyaaru nu. Hinaa gam oo tokkii tawreeta. O haɓɓanaama alkawal ŋal gam foonnitaare makko ne o heɓiri goonɗinki. ");
INSERT INTO fue_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Gam majjum, to tokkugo tawreeta nun hokkata donŋu, den mum goonɗinki laatake baanji, alkawal bo moytaama. ");
INSERT INTO fue_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Tawreeta waddan nun mone Alla. To tawreeta walaa, ƴaartaago ka bo walaa. ");
INSERT INTO fue_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Gam majjum, alkawal Alla dow goonɗinki nun darii, gam ŋal laatoo e moƴƴere dow lenyol Iburahiima fu. Hinaa tokkuɓe tawreeta tan ŋal laatanii, amma goonɗinɓe hande no Iburahiima laatiiɗo maama meeɗen en fu goonɗiniri. ");
INSERT INTO fue_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Dewtere wi'ii: «Mi waɗii maa baaba himɓe lenyi ɗuuɗɗi.» (Iburahiima woni maama meeɗen en fu,) yeeso Alla mo o goonɗini. Alla pintinoowo maayɓe, laatinoowo ko walaano laatoo. ");
INSERT INTO fue_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Iburahiima hoolake, wakkati daliila hoolaago walaa. O hoolake, o goonɗini, nun nun o laatorii baaba himɓe lenyi ɗuuɗɗi, hande no Alla wi'unoo mo: «Nii lenyol maaɗa laatoyto.» ");
INSERT INTO fue_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Goonɗinki Iburahiima tampay, baa no duuɓi makko waɗan hewre. Oo anni ɓannu makko faanake maayugo, Saratu debbo makko bo rimataa kade. ");
INSERT INTO fue_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","O waɗay seko dow alkawal Alla, o saloo goonɗingo. Amma goonɗinki makko semmiɗinii mo, o teddini Alla. ");
INSERT INTO fue_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","O tabbitini no Alla e woodi baawɗe hebbingo alkawal mum. ");
INSERT INTO fue_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Gam majjum, Alla daari mo poonnitiiɗo. ");
INSERT INTO fue_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Amma hinaa gam makko tan ɗum winnaa: «O daaraama poonnitiiɗo.» ");
INSERT INTO fue_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Gam meeɗen nun, enen bo, Alla daaran goonɗinki men. En goonɗinii Alla pintinɗo Joomiraawo meeɗen Yeesu diga maayɓe. ");
INSERT INTO fue_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Yeesu on maayi gam boofi meeɗen, o fintinaama gam laatineɗen foonnitiiɓe. ");
INSERT INTO fue_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","En laatinaama foonnitiiɓe gam en goonɗinii. Jooni jam waɗii hakkune meeɗen e Alla, sabbu Joomiraawo meeɗen Yeesu Almasiihu. ");
INSERT INTO fue_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Kanko yottini en moƴƴere Alla ne gonuɗen e muuɗum jooni. Ɗum laatake gam goonɗinki meeɗen. Een juroro hoolaare heɓugo geɗu der tedduŋal Alla. ");
INSERT INTO fue_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Hinaa kanjum tan, een juroro bo tooraaji meeɗen, gam een anni tooraaji riman munyal. ");
INSERT INTO fue_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","Munyal e rima hoolaare semmiɗinne. Hoolaare semmiɗinne e wadda heɗaago ko warata yeeso. ");
INSERT INTO fue_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Hoolaago ko warata yeeso majjintaa en, gam Alla wattii yidde mum der ɓerɗe meeɗen, diga e Ruuhu Ceniiɗo mo o hokki en. ");
INSERT INTO fue_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Gam wakkati de en galaano semme, den nun Almasiihu maayani en, enen hakkeeɓe no wakkati ki o suɓi yottii. ");
INSERT INTO fue_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","E saɗi neɗɗo nootoo maaya gam poonnitiiɗo. Waɗoto neɗɗo nooto maaya gam neɗɗo geeto. ");
INSERT INTO fue_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Amma Alla hollitii en yidde mum. Gam Almasiihu maayanii en wakkati laatinoɗen hakkeeɓe. ");
INSERT INTO fue_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","To en laatinaama foonnitiiɓe gam ƴiiƴam Almasiihu, den kan, een anni en daɗan mone Alla sabbu makko. ");
INSERT INTO fue_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Wakkati laatinoɗen wayɓe Alla, o weldinii en e hoore makko diga e maayde Ɓiyiiko. Jooni en beldii e makko, to non non en keɓan hisineego gam yonki Ɓiyiiko. ");
INSERT INTO fue_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Kanjum tan bane, een juroro Alla sabbu Joomiraawo meeɗen Yeesu Almasiihu, beldinɗo en e makko jooni. ");
INSERT INTO fue_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Diga e neɗɗo gooto nun hakke naatiri duuniyaaru. Diga hakke bo maayde wari, go ne sankitii dow himɓe fu, gam ɓe fu ɓe gaɗii hakke. ");
INSERT INTO fue_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Diga tawreeta waray, hakke na'onno der duuniyaaru, amma ɗe limaakano, gam tawreeta walaano. ");
INSERT INTO fue_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","E non fu maayde nun laamii diga Aadamu faa yottii Muusa. Ne laamake baa dow ɓee ɗo waɗay hakke hande ɗe Aadamu waɗuno. Aadamu on woni misaalu garoowo. ");
INSERT INTO fue_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Dokkal Alla foonnataake e hakke Aadamu. E gooŋa, himɓe ɗuuɓɓe maayii gam hakke neɗɗo gooto. Amma enɗam Alla, e moƴƴere ne o waɗani ɗuuɓɓe diga e neɗɗo gooto, waato Yeesu Almasiihu, e ɓuri nun mawnugo. ");
INSERT INTO fue_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Kade bo dokkal Alla, e hakke neɗɗo gooto, gootum bane. Gam kiita warii diga e hakke neɗɗo gooto. Ɓaawo boofol gooto, Alla doƴƴii himɓe fu kiita. Amma ɓaawo boofi ɗuuɗɗi, dokkal moƴƴere Alla wari, laatini ɗuuɓɓe foonnitiiɓe. ");
INSERT INTO fue_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Diga e hakke neɗɗo gooto, maayde laamii dow himɓe fu gam neɗɗo gooto on. Amma ko neɗɗo gooto waɗi, e ɓuri mawnugo. O hokkorii ɓe moƴƴereeji makko, o laatini ɓe foonnitiiɓe. Ɓe keɓan yonki, ɓe laamodoo e makko. ");
INSERT INTO fue_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Boofol neɗɗo gooto accii himɓe fu doƴƴaa kiita. Hande non bo gaɗu geetu ŋu neɗɗo gooto waɗi acci himɓe fu heɓi foonnitaare, hokkaa yonki. ");
INSERT INTO fue_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Dullere ɗowtaare neɗɗo gooto accii himɓe ɗuuɓɓe laatii hakkeeɓe. Hande non bo ɗowtaare neɗɗo gooto accirta himɓe ɗuuɓɓe laatoo foonnitiiɓe. ");
INSERT INTO fue_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Tawreeta Muusa warii gam hakke ɓeydoo. Amma to hakke ɓeydii, ɗon nun moƴƴere Alla ɓuri ɓeydaago. ");
INSERT INTO fue_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Hakke acci maayde laamii. Hande non bo foonnitaare acciri moƴƴere Alla laamii gam keɓen yonki tabitiiki ki Joomiraawo meeɗen Yeesu Almasiihu hokkata. ");
INSERT INTO fue_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Den mum, ume bi'eten? En tabitinto nun waɗugo hakke gam moƴƴere Alla ɓeydoo na? ");
INSERT INTO fue_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Waɗataako! Gam dow wecco hakke, en maayii. Noy kade buurirten der majje? ");
INSERT INTO fue_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","E gooŋa on annaa enen waɗanaaɓe batisi e inne Yeesu Almasiihu, en kawtii e maayde makko na? ");
INSERT INTO fue_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Diga e batisi, en maayii, uwidaɗen e makko. Almasiihu fintii e maayɓe sabbu baawɗe Baaba tedduɗe, hande non enen bo, buurirten gonki kesi. ");
INSERT INTO fue_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","To en kawtii e makko dow maayde nandune e ne makko, en pintan bo hande no o fintiri. ");
INSERT INTO fue_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Een anni jikku meeɗen kiinŋu tiggidaama e makko dow leggal palaaŋal. Ɗum waɗaama, heɓa ɓannu meeɗen hakkewol halka, gam to en laatoo kade maccuɓe hakke. ");
INSERT INTO fue_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Gam to goɗɗo maayii, hakke woodaa baawɗe dow makko. ");
INSERT INTO fue_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","To en maaydii e Almasiihu, een koolii no en buuridan e makko bo. ");
INSERT INTO fue_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Een anni Almasiihu pintuɗo diga maayɓe, maayataa kade. Maayde woodaa baawɗe dow makko. ");
INSERT INTO fue_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Almasiihu maayii, de woore gam hakke, ɗum heƴii faa abada. Jooni oo wuuri, gam Alla bo o wuuri. ");
INSERT INTO fue_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Hande non, onon bo, daaree ko'e mon hande maayuɓe dow wecco hakke, den buuranon Alla sabbu Yeesu Almasiihu. ");
INSERT INTO fue_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Gam majjum, to on accee hakke laamanoo ɓalli mooɗon maayooji, to on ɗowtanee suunooji majji. ");
INSERT INTO fue_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","To on kokkee hakke jokkule ɓalli mooɗon ɗe gaɗira ko foonnitaaki. Amma kokkee Alla ko'e mooɗon. On maayiino, jooni oon buuri. To non kokkee mo jokkule mooɗon, ɗe laatoo gaɗirɗum ko foonnitii. ");
INSERT INTO fue_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","To on accee hakke laamanoo on, gam der tawreeta bane gonuɗon, amma der moƴƴere Alla. ");
INSERT INTO fue_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Ume kade? En tokkoto nun waɗugo hakke gam der moƴƴere nun gonuɗen hinaa der tawreeta na? Ɗum waɗataako! ");
INSERT INTO fue_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","On annaa na? Mo gaɗuɗon ko'e mon maccuɓe mum, gam ɗowtanoɗon ɗum, kanko ɗowtantoɗon. Waɗoto hakke nun, jaarooje der maayde, ɗum bo ɗowtaare jaaroore der foonnitaare. ");
INSERT INTO fue_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Yettoore laatanoo Alla! On laatikeno maccuɓe hakke, amma jooni on ɗowtanake e ɓerɗe mooɗon fu janŋinol ŋol janŋinaɗon. ");
INSERT INTO fue_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","On dinɗinaama diga e hakke, on laatake gollantooɓe foonnitaare. ");
INSERT INTO fue_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Mii bata ɗo hande no himɓe woowi batirgo, gam tampere mooɗon. On kokkiino ɓalli mooɗon, gaɗuɗon ko tuuni e ko wuurii, oon gaɗa ko halli. Hande non jooni bo, kokkee ɓalli mooɗon laatoɗon gollantooɓe ko foonnitii gam laatoɗon seniiɓe. ");
INSERT INTO fue_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Wakkati laatinoɗon maccuɓe hakke, foonnitaare woodaano baawɗe dow mooɗon. ");
INSERT INTO fue_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Ume keɓunoɗon no gaɗunoɗon ko centirton jooni? Heennyitirde majjum laati nun maayde. ");
INSERT INTO fue_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Amma jooni, on dinɗinaama e hakke. On laatike maccuɓe Alla, riiba majjum laatii laaɓineego. Heennyitirde majjum laati yonki tabitiiki. ");
INSERT INTO fue_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Riiba hakke, maayde nun. Amma kokkal Alla laati nun yonki tabitiiki der kawtal men e Yeesu Almasiihu Joomiraawo meeɗen. ");
INSERT INTO fue_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Banniraaɓe, mii badda on hande annuɓe tawreeta. Oon anni tawreeta dawrantaa maa neɗɗo to emo wuuri. ");
INSERT INTO fue_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Hande non debbo ɓaŋaaɗo, tawreeta haɓɓii ɗum e gorum wakkati guurnam goriiko. Amma to goriiko maayii, o firtake e tawreeta kaɓɓunooka mo e goriiko. ");
INSERT INTO fue_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Amma to o laatike debbo goɗɗo diga goriiko e wuuri, o noddete jeenoowo. Amma to goriiko maayii, o firtake e tawreeta, o noddataake bo jeenoowo baa to gorko goɗɗo hoowii mo. ");
INSERT INTO fue_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Hande non ɗum laatii e mooɗon onon bo, banniraaɓe am. Sabbu maayde Almasiihu on pirtaama e tawreeta. On laatake jeyde Almasiihu mo Alla fintini diga maayɓe gam gaɗen ko fottanta Alla. ");
INSERT INTO fue_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Wakkati gaɗetenno ko suunooji ɓalli men yiɗi, en tokkiino giɗaaɗi hakke ƴiwuɗe e tawreeta. Tawreeta kan gollotono der men e yaara en e maayde. ");
INSERT INTO fue_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Amma jooni, en pirtaama e tawreeta, en maayii dow wecco makka. Gam majjum en caafirtaa Alla e laawol kiinŋol ŋol tawreeta binnaaka. Amma een caafa mo e laawol kesol ŋol Ruuhu makko. ");
INSERT INTO fue_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Den, ume bi'eten kade? Tawreeta laati nun hakke na? Abada! Amma, diga e tawreeta nun annirmi ko woni hakke. Gam mi annataano ko woni suuno to tawreeta wi'ayno: «Taa suuna.» ");
INSERT INTO fue_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Hakke heɓii laawol diga e umuroore, ɗe gattimmi suunooji iri ɗiye fu. Gam to tawreeta walaa, hakke bo waatii. ");
INSERT INTO fue_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Naane, ko mi annaano tawreeta, emi wuurunoo. Amma no umuroore wari, hakke heɓii baawɗe, ");
INSERT INTO fue_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","den min, maayumi. Umroore kaanunoone hokkammi yonki, waddanii am maayde. ");
INSERT INTO fue_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Gam hakke heɓii laawol diga e umuroore, ƴoyrimmi, yaarimmi der maayde. ");
INSERT INTO fue_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Hande non, tawreeta e laatii ceniika. Umroore bo e laatii seniine, foonnitiine, wooɗune. ");
INSERT INTO fue_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Jooni, ko wooɗi laatanike am maayde na? Abada! Amma gam hakke hollitoo no ɗe laati nun hakke e gooŋa, ɗe gollirii ko wooɗi, go ɗe barimmi. Hande non, diga e umuroore, hakke heɓi hollitiri hallande mum fu. ");
INSERT INTO fue_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Een anni tawreeta ƴiwii diga Ruuhu. Amma min, mii laatii neɗɗo tampuɗo, mii laatii maccuɗo hakke. ");
INSERT INTO fue_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","E gooŋa, mi faamataa ko gaɗanmi. Ko jiɗumi, mi waɗataa ɗum, amma ko banyumi, gaɗanmi. ");
INSERT INTO fue_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","To mii waɗa ko mi yiɗaa, eɗum hollita no mi nootake tawreeta e wooɗi. ");
INSERT INTO fue_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Jooni, min bane waɗata ko gaɗanmi, hakke gonuɗe der am waɗata ɗum. ");
INSERT INTO fue_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Gam mii anni, ko wooɗi walaa der am, waato der ɓannu am. Mii yiɗi waɗugo ko wooɗi, amma mi waawataa ko waɗi ɗum. ");
INSERT INTO fue_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Mii yiɗi waɗugo ko wooɗi, amma mi waɗataa ɗum. Kalluɗum ko mi yiɗaa gaɗanmi. ");
INSERT INTO fue_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","To mii waɗa ko mi yiɗaa, min bane waɗata ɗum, amma hakke gonuɗe der am waɗata ɗum. ");
INSERT INTO fue_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Daa ko ji'umi e waɗoo der am: mii yiɗi waɗugo ko wooɗi, amma go kalluɗum e takkii am. ");
INSERT INTO fue_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Der lugguɗum ɓerne am, mii seyorii tawreeta Alla. ");
INSERT INTO fue_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Amma mii yi'a tawreeta gokka der am, kaɓidoowa e tawreeta ka hakkillo am jaɓi. Ka laatinimmi maccuɗo tawreeta hakke gonuɗe der am. ");
INSERT INTO fue_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Kayto! Mii laatii neɗɗo jurminiiɗo! Moy rinɗintammi e ɓannu maayoowol ŋol? ");
INSERT INTO fue_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Yettoore laatanoo Alla, diga e Joomiraawo meeɗen Yeesu Almasiihu! Min, der hakkillo am, mi laati nun maccuɗo tawreeta Alla, amma der am, mii maccuɗo tawreeta hakke. ");
INSERT INTO fue_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Gam majjum, jooni, hawtuɓe e Yeesu Almasiihu doƴƴataake kiita. ");
INSERT INTO fue_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Gam tawreeta Ruuhu e hokka yonki to goɗɗo hawtii e Yeesu Almasiihu. Kanka rinɗinimmi diga tawreeta hakke, e maayde. ");
INSERT INTO fue_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Tawreeta Muusa waawayno ko waɗi ɗum gam tampere ɓannu. Amma Alla waɗii ɗum. O liloy Ɓiyiiko tii etti ɓannu nanduŋol e ɓannu hakkeeɓe gam o firta ɓe diga hakke. Hande non o hiitorii hakke gollotooɗe der ɓalli meeɗen. ");
INSERT INTO fue_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","O waɗii ɗum gam foonnitaare ne tawreeta ƴami, hebba dow meeɗen. Hande non, en jahataa kade no ɓannu yiɗiri, amma no Ruuhu yiɗiri. ");
INSERT INTO fue_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Tokkiiɓe jiɗaaɗi ɓannu, ko ɓannu yiɗi ɓe miijantoo. Amma tokkiiɓe Ruuhu, ɗum Ruuhu ɓe miijantoo. ");
INSERT INTO fue_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Tokkugo jiɗaaɗi ɓannu, maayde nun. Amma tokkugo ko Ruuhu yiɗi, yonki e jam nun. ");
INSERT INTO fue_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Tokkuɗo jiɗaaɗi ɓannu laati nun ganyo Alla. O ɗowtantaako tawreeta Alla, o waawataa du ko ɗowtanii ka. ");
INSERT INTO fue_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Waɗooɓe ko ɓalli mum yiɗi waawataa ko fottani Alla. ");
INSERT INTO fue_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Onon kan, on tokkaaki jiɗaaɗi mooɗon, amma Ruuhu Alla, to Ruuhu on e woni e mooɗon kan. Mo walaa Ruuhu Almasiihu, laataaki mo makko. ");
INSERT INTO fue_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","To Almasiihu na'on der mooɗon, e non fu ɓalli mooɗon maayan gam hakke, amma ruuhu mooɗon wuuran gam on laatinaama foonnitiiɓe. ");
INSERT INTO fue_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Alla fintinii Yeesu diga maayɓe. To Ruuhu makko na'on der mooɗon, den kan pintinɗo Yeesu Almasiihu diga maayɓe, hokkan ɓalli mooɗon maayooji yonki, diga e Ruuhu makko gonuɗo der mooɗon. ");
INSERT INTO fue_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","To non non, banniraaɓe, een jogii nyamaane. Amma hinaa nyamaane suunooji ɓalli jogiɗen gam gonoɗen no ɗi jiɗiri. ");
INSERT INTO fue_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","To oon tokki jiɗaaɗi ɓannu, on maayan. Amma to on barii ɗi diga e Ruuhu Alla, on buuran. ");
INSERT INTO fue_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Gam ɓe Ruuhu Alla ɗowata fu, kamɓe nun laatii ɓiɓɓe Alla. ");
INSERT INTO fue_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Ruuhu mo Alla hokki on laatinay on maccuɓe, hakko gonoɗon kade der kulol. Amma o laatinii on ɓiɓɓe Alla. Ruuhu acci een nodda Alla «Abba» waato Baaba. ");
INSERT INTO fue_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Ruuhu Ceniiɗo e hoore mum, e seedanoo ruuhu meeɗen, en laati nun ɓiɓɓe Alla. ");
INSERT INTO fue_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","To een laatii ɓiɓɓe Alla, en donan ko Alla resani himɓe mum. En donidan ɗum e Almasiihu. To en toorodike e makko, en donidan bo tedduŋal e makko. ");
INSERT INTO fue_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Mii anni tooraaji meeɗen ɗi jooni, foonnataako e tedduŋal garoowal, ŋal Alla suppitinanoyta en. ");
INSERT INTO fue_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Ko tagaa fu e haaɓi yi'a wakkatiire ne o hollitinta tedduŋal ɓiɓɓe makko. ");
INSERT INTO fue_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Gam ko tagaa fu naatinaama der jeyaanaaku, ɗum laatinaa baanji, hinaa e yidde majjum, amma sabbu naatinɗo ɗum e maggu. Amma e non, hoolaare na'on. ");
INSERT INTO fue_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","Ko Alla tagi fu firtete e jeyaanaaku halkere. Den ɗum heɓa rinɗineego e tedduŋal ŋal ɓiɓɓe Alla heɓata. ");
INSERT INTO fue_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Gam een anni, faa jooni, tagaaɗum fu e uuma e tooroo hande debbo dimoowo. ");
INSERT INTO fue_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Tagaaɗum tan bane tooroto. Baa enen ɓe Alla hokki Ruuhu mum hande kokkal artuŋal, een uuma. Enen bo, een kaaɓi Alla rinɗina ɓalli meeɗen, laatina en ɓiɓɓe mum. ");
INSERT INTO fue_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","En kisinaama, amma een keɗii taw. To een ji'a huune ko tammihiɗen heɓugo, ɗum laataaki kade tammuwe. Moy nun tammihintoo ko yi'i? ");
INSERT INTO fue_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Amma to een tammihii ko en ji'ataa yottoto, en kettinto ɗum e munyal. ");
INSERT INTO fue_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Hande non bo Ruuhu e wara wallugo en der tampe meeɗen. En annaa du'aago hande no haani. Amma Ruuhu e hoore mum e du'anoo en e uumaali ɗi neɗɗo waawataa ko bati. ");
INSERT INTO fue_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Alla annuɗo ko woni der ɓerɗe himɓe e anni ko Ruuhu yiɗi. No Alla yiɗiri bo, nun nun Ruuhu du'orantoo himɓe makko. ");
INSERT INTO fue_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Een anni bo, ko Alla waɗata fu, oo waɗa ɗum gam booɗɗum yiɗuɓe mo, kamɓe ɓe o suɓi hande no o resiri. ");
INSERT INTO fue_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Himɓe ɓe Alla anni diga aran, o suɓii ɓe diga fuɗɗoode ɓe nanda e Ɓiyiiko. Den Ɓiyiiko laatoo afo caka banniraaɓe ɗuuɓɓe. ");
INSERT INTO fue_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Ɓe o suɓi diga fuɗɗan, o noddii ɗum. Ɓe o noddi bo, o laatinii ɗum foonnitiiɓe. Ɓe o laatini foonnitiiɓe, o teddinii ɗum. ");
INSERT INTO fue_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Ume bi'eten kade dow haala kan? To Alla e wondi e meeɗen, moy waawata ko haɓidi en? ");
INSERT INTO fue_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Kanko, mo saloraaki Ɓiyiiko, amma o hokkitirii mo gam meeɗen en fu. Noy woni o hokkirtaa en ko o woodi fu e moƴƴere, diga e Ɓiyiiko? ");
INSERT INTO fue_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Moy nun gaccoto ɓe Alla suɓi? Walaa! Gam Alla nun laatinta ɓe foonnitiiɓe! ");
INSERT INTO fue_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Moy waawata ko doƴƴi ɓe kiita? Walaa! Yeesu Almasiihu maayii gam maɓɓe. Ko ɓuri fu, o fintii, o na'on jooɗii nyaamo Alla, oo du'anoo en. ");
INSERT INTO fue_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","To non non, moy nun waawata ko seenni en e yidde Almasiihu? Ɓillaare na, jiɓayeere na, tooreego na, rafo na, talakaaku na, kaliire na, naa kaafahi? ");
INSERT INTO fue_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Hande no Dewtere wi'i: «Gam maaɗa acci emen gonii nyalaane fu der kaliije maayde, emen daaraa hande baali kiiseteeɗi.» ");
INSERT INTO fue_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Amma der huune ɗum fu, en keɓii jaalorgal sabbu jiɗuɗo en. ");
INSERT INTO fue_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Gam mii anni, walaa ko seennata en e yidde makko. Baa maayde, baa guurnam, baa malaykaaɓe, baa baawɗeeji, baa ko warata jooni, ɗum bo ko waroyta yeeso, ɗum bo semme gom, ");
INSERT INTO fue_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","baa baawɗeeji gonuɗi dow, ɗum bo baawɗeeji gonuɗi ley, to ɗum bo tagaaɗum gom, walaa e majjum ko seennata en e yidde Alla nee ɗo hawti en e Joomiraawo meeɗen Yeesu Almasiihu. ");
INSERT INTO fue_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Ka batanmi ɗo gooŋa nun. E inne Almasiihu, mi fewataa. Cuuɗiiɗum ɓerne am bo e seedanoo am diga e Ruuhu Ceniiɗo no gooŋa nun batanmi. ");
INSERT INTO fue_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","Ɓerne am e biisii puy, mii woodi toora ka heennyataa, der ɓerne am. ");
INSERT INTO fue_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Mi wanyay laataago jaa'aaɗo, mi seenniree e Almasiihu to ɗum nafanno banniraaɓe e baabiraaɓe am, ɓe lenyol am. ");
INSERT INTO fue_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Kamɓe woni Isira'iilaaɓe, ɓe Alla laatini ɓiɓɓe mum, holli ɓe tedduŋal mum. Ɓe keɓii alkawalji e tawreeta. O hollii ɓe no ɓe caafirta mo, o batii ɓe o waɗanan ɓe huune ɗuuɗɗum. ");
INSERT INTO fue_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Kamɓe laatii ƴiwuɓe diga e kaakiraaɓe amen. Almasiihu bo ƴiwii e lenyol ŋol. Kanko woni Alla jintuɗo huune fu, yettoore laatanoo mo faa abada. Aami! ");
INSERT INTO fue_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","To non non haala Alla tampu nun na? Gam ƴiwuɓe e lenyol Isira'iila fu bane woni Isira'iilaaɓe. ");
INSERT INTO fue_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Ƴiwuɓe e lenyol Iburahiima fu bane woni ɓiɓɓe makko. Gam Alla wi'i Iburahiima: «Diga e Isiyaaku keɓataa lenyol innitirteeŋol inne maa». ");
INSERT INTO fue_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Ko ɗum yiɗi wi'ugo woni: rimaaɓe e ɓannu bane laatii ɓiɓɓe Alla, sey rimaaɓe dow alkawal Alla. Kamɓe nun limetee der lenyol makko. ");
INSERT INTO fue_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Gam Alla haɓɓanii mo alkawal wi'i: «Mi wittaan mawuuri hande nii, mi tawan Saratu rimii ɓiɗɗo gorko.» ");
INSERT INTO fue_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Ɗon tan bane. Rebeka bo heɓii reedu siwtuɓe. Baaba maɓɓe nun Isiyaaku, maama meeɗen. ");
INSERT INTO fue_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","Sukaaɓe ɓen rimaakano taw, ɓe gaɗay ko wooɗi, ɗum bo ko halli. E nun fu, ko Alla resi nun waɗata. Cuɓol makko daraaki dow gaɗu, amma dow no o resiri, kanko cuɓoowo. ");
INSERT INTO fue_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","Alla wi'i Rebeka: «Mawniraawo jagganto miiraawo.» ");
INSERT INTO fue_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Hande ko winnaa: ­ «Yaakuubu jiɗumi, Isuwa banyumi.» ");
INSERT INTO fue_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Den, ume bi'eten? Ko Alla waɗata foortaaki na? Abada! ");
INSERT INTO fue_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Nani ko o wi'i Muusa: «Mi enɗoto mo enɗotoomi, mi yurmoto mo jurmotoomi.» ");
INSERT INTO fue_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Hande non, cuɓol Alla daraaki dow sago neɗɗo, ɗum bo dow anniya mum, amma diga e Alla enɗotooɗo ɗum ƴiwi. ");
INSERT INTO fue_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Gam Dewtere batii dow Fiirawna, wi'i: «Mi suɓii maa e sago am gam mi hollita baawɗe am dow maa, kade bo gam inne am sankitoo e duuniyaaru fu». ");
INSERT INTO fue_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Den, Alla enɗoto mo yiɗi, yoorinan ɓerne mo yiɗi. ");
INSERT INTO fue_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","A ƴaman am bi'aa: «Ume acci ko Alla e gaccoo himɓe? Moy waawata ko salii sago makko?» ");
INSERT INTO fue_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Amma an, moy laatiɗaa faa jeddontiraa e Alla? Fayande waawan ko ƴami mahuɗo ɗum: «Gam ume ko mahirɗaa am ninni na?» ");
INSERT INTO fue_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Mahoowo payanɗe woodaa hoore mum waɗa ko yiɗi e loope goote ɗen na? E loope goote ɗen, o waawan ko mahi payanɗe goɗɗe ɗe tedduŋal, o maha goɗɗe bo ɗe walaa tedduŋal. ");
INSERT INTO fue_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Alla yiɗii hollitingo mone mum e baawɗe mum. Amma o munyanii himɓe puy, kamɓe haanannooɓe mone makko, resanooɓe gam halkere. ");
INSERT INTO fue_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","O waɗii ɗum gam hollitingo tedduŋal makko manŋal dow ɓe o enɗii. O siriyake ɗum gam ɓe o yiɗi teddingo. ");
INSERT INTO fue_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Himɓe ɓen woni enen ɓe o noddi, hinaa caka Yahuduuɓe tan, amma e caka ɓe laataaki Yahuduuɓe bo. ");
INSERT INTO fue_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Kanka nun Alla bati e dewtere annabi Hose'a o wi'i: «Lenyol ŋol laataakino lenyol am, mi noddan ŋol lenyol am, lenyol ŋol yiɗaakano, mi noddan ŋol lenyol am jiɗaaŋol. ");
INSERT INTO fue_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Kade bo, to ɓe bi'etenoo, ɓe laataaki himɓe am, ton ɓe noddetee ɓiɓɓe Alla mo yonki.» ");
INSERT INTO fue_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Annabi Esaaya bo batii haala Isira'iilaaɓe, wi'i: «Baa to ɓiɓɓe Isira'iila ɗuuɗii hande jaaneeri maayo, woɓɓe maɓɓe tan hisintee. ");
INSERT INTO fue_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","Gam Joomiraawo hebbinan law haala ka o bati fu, deydey, dow leydi ɗo.» ");
INSERT INTO fue_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Kade bo non Esaaya wi'unoo diga ɓooyɗum: «To Joomiraawo hooreejo konunkeeɓe accanayno en lenyol baa seɗɗa, en laatotono hande Sodoma, en nandanno e Gomora.» ");
INSERT INTO fue_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Den, ume bi'eten? Himɓe ɓe lenyi janani dartayno laatoo foonnitiiɓe yeeso Alla, amma ɓe keɓii ɗum diga e goonɗinki. ");
INSERT INTO fue_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Amma Isira'iilaaɓe dartuɓe foonnitaare diga e tokkugo tawreeta, waaway ko heɓi ɗum. ");
INSERT INTO fue_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Gam ume nun? Gam ɓe dartiray ɗum e goonɗinki. E anniya maɓɓe nun ɓe dartiri ɗum, go ɓe pergi dow hayre doƴƴoore ɓe. ");
INSERT INTO fue_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","Dewtere wi'ii: «Mi yowii dow Siyoona hayre fergeteene, tepaare doƴƴoore himɓe. Amma goonɗinɗo ne fu sentintaake abada!» ");
INSERT INTO fue_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Banniraaɓe, mii yiɗi e ɓerne am fu, Isira'iilaaɓe hisa. Kanjum eelanmi Alla. ");
INSERT INTO fue_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Mii seedanoo ɓe no ɓee goodi tinnaare gam Alla, amma ɓe galaa annal. ");
INSERT INTO fue_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Ɓe annaa laawol ŋol Alla laatinirta himɓe foonnitiiɓe. Den ɓe dartani ko'e maɓɓe no ɓe laatortoo foonnitiiɓe. Ɓe jiɗay ɗowtanaago Alla e laawol ŋol o laatinirta himɓe foonnitiiɓe. ");
INSERT INTO fue_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Almasiihu yottinii tawreeta, gam goonɗinɗo mo fu laatinee poonnitiiɗo. ");
INSERT INTO fue_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Muusa winnii dow haala foonnitaare ƴiwune e tawreeta, wi'i: «Neɗɗo fu tokkuɗo tawreeta, wuuran diga e makka.» ");
INSERT INTO fue_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Amma foonnitaare ƴiwune e goonɗinki wi'i: Taa wi'u der ɓerne maa «Moy eencata dow kammu?» Jippingo Almasiihu nun ɗon. ");
INSERT INTO fue_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","Taa wi'u der ɓerne maa bo: «Moy mutata der leydi?» Wurtingo Almasiihu diga hakkune maayɓe nun ɗon. ");
INSERT INTO fue_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Den, ume haala kan bati? «Haala Alla e ɓadii maa, ka na'on der hunnuko maa, e der ɓerne maa.» Haala kan woni habaru goonɗinki ki men baajotoo. ");
INSERT INTO fue_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","To a batii e hunnuko maa Yeesu nun laatii Joomiraawo, go goonɗinɗaa der ɓerne maa Alla fintinii mo diga maayɓe, den a hisan. ");
INSERT INTO fue_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Gam goonɗinɗo e ɓerne mum fu, Alla laatinan ɗum poonnitiiɗo. Batuɗo e hunnuko mum bo, Alla hisinan ɗum. ");
INSERT INTO fue_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Dewtere wi'ii: «Goonɗinɗo fu sentintaake.» ");
INSERT INTO fue_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Walaa ko suttontiri Yahuduujo e mo laataaki Yahuduujo. Ɓe fu Joomiraawo gooto ɓe goodi. Kanko nun hokkata noddanɓe mo fu jawdi makko. ");
INSERT INTO fue_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Gam «nodduɗo inne Joomiraawo fu, hisan.» ");
INSERT INTO fue_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Amma noy ɓe noddirta inne mo ɓe goonɗinay? Noy ɓe goonɗinirta mo ɓe nanay habaru muuɗum? Noy ɓe nanirta habaru makko to baajotooɗo walaa? ");
INSERT INTO fue_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Noy himɓe waajortoo to ɓe lilaaka? Dewtere wi'ii: «Ume wooɗi hande koyɗe fiinooɓe habaruuji belɗi.» ");
INSERT INTO fue_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Amma himɓe fu bane ɗowtanii linjiila kan. Hande no Esaaya wi'i: «Joomiraawo, moy nun goonɗini waaji amen?» ");
INSERT INTO fue_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Hande non, goonɗinki e ƴiwa diga e nanugo, ko nanetee bo e ƴiwa diga e haala Almasiihu. ");
INSERT INTO fue_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Amma mii ƴama kaa ɗo: Isira'iilaaɓe nanay woni na? E gooŋa ɓe nanii! Gam dewtere wi'ii: «Daaɗe maɓɓe nanaama der duuniyaaru fu, Haala maɓɓe yottike kaddi leydi.» ");
INSERT INTO fue_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Mii ƴama kade: Isira'iilaaɓe faamay woni na? Muusa artii wi'i: «Mi waɗan nawniraagu mooɗon ummoo dow lenyol ŋol on gattiray, Mi accan mone mooɗon ummoo dow lenyol ŋol walaa annal.» ");
INSERT INTO fue_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Ɓaawo mum Esaaya hulay wi'ugo: «Himɓe ɓe dartayno am yiitii am, mi hollitanike himɓe ɓe ƴamanay am.» ");
INSERT INTO fue_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Amma dow Isira'iilaaɓe, o wi'i: «Nyalaane fu mii weeɗi juuɗe am gam jaɓugo himɓe nanaruuɓe e yeddooɓe.» ");
INSERT INTO fue_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Mii wi'a: Alla woppu nun himɓe muuɗum na? O woppay ɓe! Gam min bo mi laati nun Isira'iilaajo, taaniraawo Iburahiima, mi ƴiwii e lenyol Benyamin. ");
INSERT INTO fue_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Alla woppay himɓe muuɗum ɓe o suɓi diga fuɗɗoode. Oon anni ko Dewtere bati wakkati annabi Eliya wullani Alla gam Isira'iilaaɓe, e wi'a: ");
INSERT INTO fue_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","«Joomiraawo, ɓe barii annabiiɓe maa, ɓe pusii kiisirɗe maa. Min tan horii, go ɓee darta min bo ɓe barammi.» ");
INSERT INTO fue_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Ume Alla toontii mo? O wi'i: «Mii horanii hoore am worɓe ujune jeeɗiɗo ɓe jiccanaaki tooruure wi'eteene Ba'al.» ");
INSERT INTO fue_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Hande non bo ɗum laatii jooni. E woodi himɓe horiiɓe ɓe Alla suɓi e moƴƴere mum. ");
INSERT INTO fue_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","To e moƴƴere nun o suɓiri ɓe, den fu gam gaɗu maɓɓe bane. To hinaa non, moƴƴere laatataako moƴƴere. ");
INSERT INTO fue_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Ume nun kade? Ko Isira'iilaaɓe dartannoo, ɓe keɓay ɗum. Ɓe Alla suɓi caka maɓɓe heɓi ɗum. Horiiɓe, ɓerɗe muuɗum yoorinaama, ");
INSERT INTO fue_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","hande no winnaa: «Alla maɓɓii hakkilooji maɓɓe, Ɓee goodi gite, amma ɓe ji'ataa, ɓee goodi noppi amma ɓe nanataa. Non ɗum laatii faa hanne.» ");
INSERT INTO fue_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Dawda bo wi'i: «Nyaamduuji juulɗe maɓɓe laatanoo ɓe pittol e to ɓe pergotoo, ɗum laatanoo ɓe doƴƴere, e riiba golle maɓɓe. ");
INSERT INTO fue_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Gite maɓɓe wuminee, dulla yi'ugo, ɓe laatinee jeyaaɓe e baadey!» ");
INSERT INTO fue_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Den, mii ƴama: Yahuduuɓe fergi nun gam ɓe jana e baadey na? Aawo! Amma sabbu fergaago maɓɓe, ɓe lenyi janani heɓii kisidam gam nawniraagu Yahuduuɓe umminiree. ");
INSERT INTO fue_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Fergaago Yahuduuɓe laatanike himɓe duuniyaaru jawdi, seekaago maɓɓe bo waddanii ɓe lenyi janani jawdi. Den noy ɗum laatotono to Yahuduuɓe fu tuubiino? ");
INSERT INTO fue_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Jooni, onon ɓe lenyi janani nun baddanmi. Mii laatii lilaaɗo caka ɓe lenyi janani, mii teddina golle am. ");
INSERT INTO fue_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","Mii yiɗi to waɗoto, mi ummina nawniraagu himɓe lenyol am, mi hisina woɓɓe maɓɓe. ");
INSERT INTO fue_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Takkeego maɓɓe sera weldini himɓe duuniyaaru e Alla. Noy ɗum laatotono to ɓe bittinaama? Ɗum nandan hande ƴiwugo diga maayde naata e yonki. ");
INSERT INTO fue_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","To peen artuŋa sakkaama Alla, den koriiko fu e laatanii mo. To ɗaɗi leggal e laatanii Alla, licce maggal bo e laatanii mo. ");
INSERT INTO fue_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Hande non ɗum laatii e himɓe Isira'iila, ɓee laatii hande leggal jaytuhi. Licce jaytuhi wuro goɗɗe wudditaama, go an jaytuhi laddehi takkaɗaa dow jayri jaytuhi wuro, go aa heɓa nyaamdu maa diga e makki. ");
INSERT INTO fue_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","Gam majjum, taa yawa licce budditaaɗe. A woodaa laawol mawnitaago. Amma to aa mawnito, annitin no an bane roonii ɗaɗi, ɗaɗi nun roonii maa. ");
INSERT INTO fue_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Waɗoto bi'aa: «Licce wuddita nun gam mi takkee to ɗe gonunoo.» ");
INSERT INTO fue_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Gooŋa nun! Ɗe budditaama gam dullere goonɗinki majje, go an takkaɗaa gam goonɗinki maa. To non non, taa mawnita, amma hulu Alla. ");
INSERT INTO fue_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Gam to Alla accay licce wuro, o accataa maa an bo. ");
INSERT INTO fue_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","En daaree geetaaku Alla e saɗella makko. Saɗella makko dow yanuɓe, den geetaaku makko bo dow maa, to aa tabitii der geetaaku makko. To hinaa non, an bo a wudditinte. ");
INSERT INTO fue_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","To Isira'iilaaɓe bo tabitaaki der dullere goonɗinki mum, Alla takkanɓe kade. Gam Alla e woodi baawɗe takkugo ɓe kade. ");
INSERT INTO fue_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","An jaytuhi laddehi, a wudditaama takkaɗaa to jaytuhi ki wuro. Ɗum ɗon haandanayno maa. To non, eɗum saɗi takkugo licce jaytuhi ki wuro to ɗe gonunoo na? ");
INSERT INTO fue_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Banniraaɓe, mii yiɗi faamingo on asiiri ɗum ɗo, gam to on daaree ko'e mooɗon hande wooduɓe hakkillo. Woɓɓe der Isira'iilaaɓe, ɓerɗe mum yoorinaama. Amma ɗum daroto to limgal ɓe lenyi janani hisinteeɓe hebbii. ");
INSERT INTO fue_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Hande non, Isira'iilaaɓe fu hisan. Non Dewtere wi'i: «Kisinoowo waran diga Siyoona, o mooytan dullere kulol Alla caka himɓe lenyol Yaakuubu. ");
INSERT INTO fue_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Kanjum woni alkawal am e maɓɓe to mi moytii hakkeeji maɓɓe.» ");
INSERT INTO fue_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Dow wecco linjiila Yahuduuɓe laatake ɓe Alla wanyi, gam mooɗon. Amma dow wecco cuɓol Alla, ɓe laati nun yiɗaaɓe gam kaakiraaɓe maɓɓe. ");
INSERT INTO fue_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","To Alla hokkii neɗɗo o hokku nun, to o noddi neɗɗo bo o noddu nun. ");
INSERT INTO fue_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Naane, on ɗowtanaakino Alla. Amma joonii on keɓii enɗam Alla gam dullere ɗowtaare Yahuduuɓe. ");
INSERT INTO fue_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","Non bo jooni, ɓe ɗowtanaaki Alla gam keɓon enɗam makko. Jooni, kamɓe bo ɓe keɓan enɗam makko, hande no onon bo keɓirɗon. ");
INSERT INTO fue_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Gam Alla maɓɓii himɓe fu der dullere ɗowtaare, gam o enɗoo ɓe, ɓe fu. ");
INSERT INTO fue_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Hey! E gooŋa Alla e mawni! Hakkillo makko e annal makko e luggi! Walaa baawoowo ko faami no o hiitortoo, laabi makko faamataako! ");
INSERT INTO fue_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","Gam e winnaa: «Moy anni miilooji Joomiraawo? Moy woni kokkoowo mo saawari? ");
INSERT INTO fue_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","Moy arti hokki mo, hakko o yoɓa ɗum?» ");
INSERT INTO fue_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Gam huune fu e makko ƴiwi, gam makko ɗum woni, kanko bo woodi ɗum. Tedduŋal laatanoo mo faa abada! Aami! ");
INSERT INTO fue_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Banniraaɓe, mii eela on sabbu enɗam Alla. Kokkee mo ko'e mooɗon hande sadaka yonkinteha, ceniika, pottananka Alla. Kanjum woni sujida gooŋaha, kaanuka caafiron Alla. ");
INSERT INTO fue_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","To on nandee e himɓe duuniyaaru nu. Amma accee Alla waylita on. Hakkillooji mooɗon laatoo kesi. Den on baawan suttontirgo ko Alla yiɗi, e ko wooɗi, e ko weli, e ko hebbi. ");
INSERT INTO fue_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Alla waɗanii am moƴƴere mum. Gam majjum mii wi'a moy mooɗon fu to daaru hoore muuɗum ɓura ko laati. Amma moy fu daara hoore mum jaka no foti, e jaka goonɗinki ki Alla hokki ɗum. ");
INSERT INTO fue_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Moy meeɗen fu e woodi jokkule ɗuuɗɗe der ɓannu gootol. Jokkule ɗen fu golle goote bane waɗata. ");
INSERT INTO fue_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","Hande non, enen bo, no ɗuuɗirɗen fu, en laati nun ɓannu gootol, gam kawtal meeɗen e Almasiihu. En fu, een jeyontiri. ");
INSERT INTO fue_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Alla hokkii en dokke feere feereeje e moƴƴere mum. Kokkaaɗo gaɗol annabaaku, waɗa ɗum no fottiri e goonɗinki. ");
INSERT INTO fue_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","To wallugo woɓɓe nun, o waɗa ɗum e hakkillo makko fu. Janŋinoowo bo, hiinnoo janŋinol mum. ");
INSERT INTO fue_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","Kokkaaɗo dokkal semmiɗingo himɓe, o semmiɗina ɓe. Kokkaaɗo dokkal wallugo woɓɓe, walla e ɓerne woore. Ardiiɗo, ardoo e tinnaare. Enɗotooɗo himɓe, waɗa ɗum e seyo. ");
INSERT INTO fue_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Yidde mon laatoo ne walaa munaafitaare. Banyee ko halli, takkee ko wooɗi e semme. ");
INSERT INTO fue_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Jiɗontiree e yidde banniraagu. Moy mooɗon fu teddina banniraawo mum, ɓurina hoore mum. ");
INSERT INTO fue_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","Laatee tinniiɓe, to on laatee ciiwankeeɓe. Accee hakkillo mon e fini. Gollanee Joomiraawo e ɓerɗe mon fu. ");
INSERT INTO fue_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","Ceyoree ko kooliɗon on keɓan, munyanee tooraaji, tinnee e waɗugo du'aaje. ");
INSERT INTO fue_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","Ballitee himɓe Alla e haajeeji mum, laatee weernooɓe hoɓɓe. ");
INSERT INTO fue_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Barkiɗinee tooranɓe on, barkiɗinee, to on jaa'ee. ");
INSERT INTO fue_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Ceyodee e seyotooɓe, bullidee e wullooɓe. ");
INSERT INTO fue_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Goodee miilooji gooti hakkune mon. To on dartee ko mawni, amma nootee bo waɗugo ko leesi. To on daaree ko'e mooɗon hande wooduɓe hakkillo. ");
INSERT INTO fue_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","To goɗɗo waɗanii on ko halli, to on battee mo. Dartee waɗugo ko wooɗi yeeso himɓe fu. ");
INSERT INTO fue_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","To waɗoto, gaɗee no baawuɗon fu, gonidon e himɓe fu e jam. ");
INSERT INTO fue_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Banniraaɓe am yiɗaaɓe, to on battanee ko'e mooɗon, amma accee mone Alla waɗa ɗum. Gam Joomiraawo wi'i der Dewtere: «Min nun wattaago wonani, mi yoɓan moy fu ko waɗi.» ");
INSERT INTO fue_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","E winnaa kade: «To ganyo maa e rafaa, hokku mo o nyaama, to emo ɗonɗaa, hokku mo o yara. To a waɗii ɗum, ƴulɓe yiite nun jowanɗaa mo ɗon dow hoore makko.» ");
INSERT INTO fue_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Taa accu hallande jaalee, amma jaalora ne ko wooɗi. ");
INSERT INTO fue_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Sey moy fu ɗowtanoo laamiiɓe. Laamiiɗo walaa to hinaa mo Alla suɓi, gam laamiiɓe fu, Alla nun laaminta ɗum. ");
INSERT INTO fue_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Gam majjum, caliiɗo ko ɗowtanii laamiiɗo, salike ka Alla bati. Caliiɗo ka Alla bati fu, fooɗanan hoore mum kiita. ");
INSERT INTO fue_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Gaɗoowo ko wooɗi hulaataa mawɓe genni, sey gaɗoowo ko halli. A yiɗaa aa huli laamiiɓe na? waɗu ko wooɗi, den ɓe manete. ");
INSERT INTO fue_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","Golle Alla nun laamiiɓe waɗata gam nafuwe maa. Amma to a waɗii ko halli, sey kulaa, gam baanji bane acci ɓee bakkii kaafahi. Ɓe laati nun gollantooɓe Alla gam ɓe battoo, ɓe kollita mone makko dow waɗooɓe ko halli. ");
INSERT INTO fue_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","To non non, eɗum haani ɗowtanoɗon laamiiɓe, hinaa gam oon kula hiiteego tan, amma gam miilooji ɓerɗe mooɗon cuuɗiiɗi e holla on ɗum. ");
INSERT INTO fue_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Gam majjum acci oon joɓa ceede faada. Alla ɓe gollantoo, der golle ɗen. ");
INSERT INTO fue_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Kokkee moy fu ko haanani ɗum. Joɓee ceede faada to haanuɓe joɓon ɗe. Joɓee ko tannyanaɗon to haanuɓe joɓon. Kulee kaanuɗo huleego. Teddinee kaanuɗo teddineego. ");
INSERT INTO fue_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","To on joganee goɗɗo nyamaane, to hinaa nyamaane yiɗontirgo hakkune mon. Gam jiɗuɗo banniraawo mum, hebbinii ko tawreeta ƴami. ");
INSERT INTO fue_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","Gam tawreeta wi'i: «Taa jeenu, taa waru neɗɗo, taa wujju, taa suuna.» Tawreeta ka, e tawreetaaji koriiɗi fu, hawtii dow haala goota kaa ɗo: «Yiɗu banniraawo maa hande no jiɗirɗaa hoore maa.» ");
INSERT INTO fue_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Yidde waɗantaa banniraawo ko halli. To non yidde laati nun hebbingo tawreeta. ");
INSERT INTO fue_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Gaɗee ɗum, gam oon anni der iri wakkati kiye nun gonuɗen. Wakkati kaanuki pinen diga e ɗoyŋol nun. Gam jooni kisidam men e ɓadii ɓuri de goonɗinnoɗen. ");
INSERT INTO fue_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","Jemma jenŋii, nokkuuje faanake weetugo. Gam majjum, en accee waɗugo golle niwre, en ɓornee kaɓirɗum ɗum jayŋol. ");
INSERT INTO fue_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","En gonee hande no haani wonuɓe der nyalooma wonira. En accee deereraaku e jarɗe, accen bo jeenu e suunooji baanji baanji, accen kaɓe e nawniraagu. ");
INSERT INTO fue_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","Ɓornee jikku Joomiraawo meeɗen Yeesu Almasiihu hande no ɓornortoɗon kolte. To on kiinnitanee ɓannu gam deƴƴitingo suunooji maggol. ");
INSERT INTO fue_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","Jaɓee mo goonɗinki mum semmiɗaa, to on jeddontiree dow miilooji makko. ");
INSERT INTO fue_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","Hande jon, goɗɗo, goonɗinki mum hokkan ɗum semme nyaamugo huune fu. Mo goonɗinki tampuki bo nyaamataa goɗɗum, sey baafe tan. ");
INSERT INTO fue_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","Nyaamoowo huune fu, to yawoo mo nyaamataa. Mo nyaamataa huune fu bo, to hiitoo nyaamoowo ko yiɗi fu, gam Alla jaɓii mo. ");
INSERT INTO fue_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","An, moy laatiɗaa faa kiitoɗaa gollantooɗo goɗɗo? To oo darii, ɗum bo to o yanii, ka joomiraawo makko nun. O daroto bo, gam Joomiraawo e woodi baawɗe darnugo mo. ");
INSERT INTO fue_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Goɗɗo e daari hande nyalaane nee ɗo e ɓuri nee to teddugo, oo to bo e daari no nyalaaɗe fu fotan nun. Sey moy fu anna to darii der hakkillo mum. ");
INSERT INTO fue_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","Ɓurontiroowo nyalaaɗe e waɗa ɗum gam Joomiraawo. Nyaamoowo ko yiɗi fu, e waɗa ɗum gam Joomiraawo, oo yetta Alla. Mo nyaamataa huune fu bo e waɗa ɗum gam Joomiraawo, oo yetta Alla kanko bo. ");
INSERT INTO fue_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","Gam walaa e meeɗen buuruɗo gam hoore mum, nun nun bo walaa maayoowo gam hoore mum. ");
INSERT INTO fue_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","To een buuri, Joomiraawo nun buuranɗen, to en maayii bo, Joomiraawo on nun maayanɗen. To een buuri ɗum bo to en maayii, Joomiraawo laataniɗen. ");
INSERT INTO fue_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","Gam Almasiihu maayii, o fintii bo gam o laatoo Joomiraawo wuuruɓe e maayuɓe fu. ");
INSERT INTO fue_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","Amma an, gam ume kiitotoɗaa banniraawo maa goonɗinɗo? An bo, ume jawantoɗaa banniraawo maa goonɗinɗo? En fu, en daroyto yeeso hiitorde Alla, ");
INSERT INTO fue_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","gam e winnii: Joomiraawo wi'i: «Min, mii wuuri moy fu jiccoto yeeso am, ɗelle fu teddinan am.» ");
INSERT INTO fue_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","Den moy meeɗen fu toontanto hoore mum yeeso Alla. ");
INSERT INTO fue_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","Gam majjum, en accee gaccontirgo. Ko haani gaɗen woni accen resango banniraaɓe ko ferginta ɓe, ɓe jana. ");
INSERT INTO fue_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","Mii anni, mii tabbitini bo der kawtal men e Joomiraawo Yeesu, no nyaamdu walaa karmuŋol e hoore mum. Amma to goɗɗo e miili e woodi huune ko harmi, dow makko ɗum harmi. ");
INSERT INTO fue_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","To gam sabbu nyaamdu, a accii ɓerne banniraawo maa biisake, a tokkay laawol yidde. Taa accu gam nyaamdu maa, neɗɗo mo Almasiihu maayi gam mum halka. ");
INSERT INTO fue_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","Gam majjum, to on accee himɓe bata kalluka dow ko laatanii on booɗuɗum. ");
INSERT INTO fue_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","Gam Laamaare Alla laataaki gam nyaamɗe e jarɗe, amma ne laati nun foonnitaare, e jam, e seyo ɗum Ruuhu Ceniiɗo hokkata. ");
INSERT INTO fue_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","Golliranoowo Almasiihu hande non, fottanan Alla, himɓe bo yettan mo. ");
INSERT INTO fue_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","Gam majjum, en dartee ko waddata jam hakkune meeɗen, e ko mawninta goonɗinki moy meeɗen fu. ");
INSERT INTO fue_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","Gam sabbu nyaamdu, taa biisu golle Alla. E gooŋa, nyaamdu fu e laaɓi. Amma nyaamaa nyaamdu, den ɗum doƴƴa goɗɗo, ɗum wooɗaa. ");
INSERT INTO fue_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","E ɗum wooɗi, to neɗɗo ƴakku tew, to o yaru bo innabojam, o acca waɗugo huune ko ferginta banniraawo makko. ");
INSERT INTO fue_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","Ko kooliɗaa dow haala ka fu, joga ɗum gam maa yeeso Alla. Barke laatanto mo gaccataako hoore mum dow ko o suɓi o waɗa! ");
INSERT INTO fue_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","Amma gaɗuɗo seko dow ko nyaamata, hiitaama, gam joomum nyaamiray ɗum e goonɗinki. Nani bo, huune fu ko waɗaaka e goonɗinki, laati nun hakke. ");
INSERT INTO fue_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","Enen ɓe goonɗinki mum semmiɗi, e haani balliten ɓe goonɗinki mum semmiɗaa. Haanay daarten ko fottanta en tan. ");
INSERT INTO fue_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","Sey moy meeɗen fu darta ko fottanta banniraawo mum gam nafuwe makko e gam mawningo goonɗinki makko. ");
INSERT INTO fue_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","Gam Almasiihu dartay ko welata ɗum. Amma hande no winnaa: «Jennooje yennanɓe maa yanii dow am.» ");
INSERT INTO fue_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","Ko artaa winnaa e dewte fu, winnaama gam janŋingo en. Kanjum hokkata en munyal, e ɓerɗe deƴƴuɗe, een keɗorii ko warata. ");
INSERT INTO fue_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","Munyal e deƴƴitinki ɓerne, diga Alla nun ƴiwata. Alla on hokka on laatoɗon miilo wooto hakkune mon. Ɗum laatoo deydey no Yeesu Almasiihu ekkitiniri on. ");
INSERT INTO fue_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","Den on teddinan Alla, Baaba Yeesu Almasiihu, Joomiraawo meeɗen e ɓerɗe goote, e daane woore. ");
INSERT INTO fue_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","Jaɓɓontiree hakkune mon hande no Almasiihu jaɓɓorii on, gam tedduŋal Alla. ");
INSERT INTO fue_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","Mii bata on no Almasiihu laatike jaggiiɗo caka Yahuduuɓe. O waɗii ɗum gam o hebbina alkawal ŋal Alla waɗanno maamiraaɓe men gam o tabbitina Alla laati nun gooŋaajo. ");
INSERT INTO fue_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","Den ɓe lenyi janani bo teddina Alla gam enɗam makko, hande no Dewtere wi'i: «Mi maantete caka ɓe lenyi janani, mi yiman, mi teddina inne maa.» ");
INSERT INTO fue_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","Dewtere wi'i kade: «Lenyi janani, belbeltee e himɓe Joomiraawo.» ");
INSERT INTO fue_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","Kade: «Onon ɓe lenyi janani fu, Jettee Joomiraawo, Himɓe fu yetta mo.» ");
INSERT INTO fue_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","Annabi Esaaya bo wi'i: «Ƴiwuɗo e lenyol Yesa waraan, O ummoto gam o laamanoo himɓe lenyi janani, Ɓe jowan hoolaare maɓɓe dow makko.» ");
INSERT INTO fue_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","Alla mo tammuwe hebbina ɓerɗe mooɗon seyo e jam gam goonɗinki mon. Tammuwe mooɗon ɓeydoo der ɓerɗe mooɗon diga e baawɗe Ruuhu Ceniiɗo! ");
INSERT INTO fue_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","Banniraaɓe am, min e hoore am, mii hoolii, oon goodi ko wooɗi, oon keewi annal, on baawan ko hokkontiri saawari hakkune mooɗon. ");
INSERT INTO fue_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","Amma der nokkuuje goɗɗe der ɗerewol am ŋol, mi winnanii on e cuusal gam siwtorgo on ko annuɗon. Mi waɗii ɗum sabbu moƴƴere ne Alla waɗanimmi. ");
INSERT INTO fue_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","O waɗii am gollantooɗo Yeesu Almasiihu caka ɓe lenyi janani. Mii golloo hande Limaamiijo. Mii waajoo ɓe lenyi janani linjiila gam ɓe laatoo sadaka belanka Alla, ka Ruuhu Ceniiɗo laaɓini. ");
INSERT INTO fue_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","Gam majjum, sabbu kawtal am e Yeesu Almasiihu, mi waawan ko jurorii golle am yeeso Alla. ");
INSERT INTO fue_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","Gam mi suusataa batango goɗɗum, to hinaa ko Almasiihu waɗi diga e am, gam waddugo ɓe lenyi janani ɗowtanoo Alla. O waɗii ɗum diga haala am, e gaɗu am, ");
INSERT INTO fue_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","non bo diga e baawɗe kaayeefiiji e haaynaareeji, e baawɗe Ruuhu Alla. Hande non baajoriimi linjiila Almasiihu diga Urusaliima e nokkuuje piiltitiiɗe ɗum, faa yottii leydi Illiriya. ");
INSERT INTO fue_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","Mi tinnake gam to mi waajoo linjiila to inne Almasiihu meeɗi noddeego. Mi waɗii ɗum, gam mi yiɗaa mahugo dow daɗɗa goɗɗo. ");
INSERT INTO fue_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","Hande no Dewtere wi'i: «Ɓe bataakano haala makko, yi'aan, ɓe nanayno oo batanee, faamaan.» ");
INSERT INTO fue_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","Golle am ɗen nun haɗimmi de ɗuuɗɗum warugo to mooɗon. ");
INSERT INTO fue_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","Amma jooni mi woodaa to gollotoomi, golle am heennyii der leyɗe ɗee, kade bo diga duuɓi ɗuuɗɗi nun jiɗumi warugo to mooɗon. ");
INSERT INTO fue_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","Mii yiɗi yaalugo on to mii yaha Espaniya. Mi jooɗodoto e mooɗon seɗɗa, ballon am der jahaaŋal am ɓaawo de ji'umi on go hakkillo am fukkii. ");
INSERT INTO fue_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","Amma jooni mi yahan Urusaliima walloygo himɓe Alla wonɓe ton. ");
INSERT INTO fue_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","Goonɗinɓe Maseduwaan e ɓe Akaya hawritii ceede, gam ɓe balla goonɗinɓe talakaaɓe wonɓe Urusaliima. ");
INSERT INTO fue_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","Ɓe gaɗii ɗum e sago maɓɓe, e haani bo ɓe gaɗana ɓe ɗum. Gam to ɓe lenyi janani heɓii kujje ruuhunkeeje diga e Yahuduuɓe, den e haani bo ɓe balla ɓe e jawdi maɓɓe. ");
INSERT INTO fue_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","To mi yottinii golle ɗen, kokkumi ko hawritaa to haanuɓe ɗum yottoo, den mi yahan Espaniya, mi yaalan bo to mooɗon. ");
INSERT INTO fue_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","Mii anni to mii wara to mooɗon, mi waridan e barke Almasiihu fu. ");
INSERT INTO fue_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","Banniraaɓe, mii eela on gam sabbu Joomiraawo meeɗen Yeesu Almasiihu, e gam yidde ne Ruuhu hokkata: Ballee am hawre, oon eelanammi Alla. ");
INSERT INTO fue_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","Du'ee gam mi daɗa e juuɗe himɓe Yahudiya ɓe goonɗinay. Du'ee bo gam himɓe Alla wonɓe Urusaliima jaɓa ballal ŋal jaaranmi. ");
INSERT INTO fue_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","Hande non, to Alla e yiɗi, mi yottoto to mooɗon e welwelo, den mi siwtoo seɗɗa hakkune mooɗon. ");
INSERT INTO fue_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","Alla kokkoowo jam wonda e mooɗon, on fu. Aami! ");
INSERT INTO fue_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","Mii yowana on sakiike meeɗen Fiibi junŋo, o laati nun gollotooɗo der Eklesiya Kenkereya. ");
INSERT INTO fue_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","Jaɓee mo e inne Joomiraawo hande no haani himɓe Alla waɗa. Ballee mo dow huune ko o haajaa e mon fu, gam kanko bo, o wallii ɗuuɓɓe, min e hoore am bo o wallii am. ");
INSERT INTO fue_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","Mi sannii Pirisilla e Akilas, gollidooɓe e am golle Yeesu Almasiihu. ");
INSERT INTO fue_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","Ɓe kokkii ko'e maɓɓe gam ɓe kisina yonki am. Min tan bane seedantooɓe ɗum, eklesiyaaji ɓe lenyi janani fu e seedanoo ɓe ɗum. ");
INSERT INTO fue_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","Cannanee am goonɗinɓe hawritintooɓe wuro maɓɓe. Mii sanna Epaynetus, giɗo am. Kanko arti goonɗini Almasiihu der leydi Asiya. ");
INSERT INTO fue_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","Mii sanna Mariyama, kokkuɗo hoore muuɗum sanne gam mooɗon. ");
INSERT INTO fue_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","Mii sanna Andoronikus e Yuniyas, himɓe lenyol am. Min e maɓɓe nun maɓɓidanoo der kasu. Ɓee laatii lilaaɓe teddinaaɓe, ɓe arti am bo goonɗingo Almasiihu. ");
INSERT INTO fue_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","Mii sanna bo Ampiliyatus jiɗaaɗo am sabbu kawtal amen e Joomiraawo. ");
INSERT INTO fue_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","Mi sannii Urbanus, gollidoowo e meeɗen der golle Almasiihu, kanko e Estakis, giɗo am. ");
INSERT INTO fue_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","Mii sanna Apelles goonɗinɗo Almasiihu e gooŋaaku. Mi sannii bo himɓe wuro Aristobil. ");
INSERT INTO fue_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","Mii sanna Herodiyon, mo lenyol am. Mii sanna bo himɓe wuro Narsisi hawtuɓe e Joomiraawo. ");
INSERT INTO fue_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","Mii sanna Tirifen e Tirifos, rewɓe gollantooɓe Joomiraawo puy. Mii sanna bo Persis, debbo jiɗaaɗo, kokkuɗo hoore mum sanne gam golle Joomiraawo. ");
INSERT INTO fue_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","Mi sannii Rufus mo Joomiraawo suɓi, e inna mum, laatiiɗo inna am min bo. ");
INSERT INTO fue_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","Mii sanna Asinkiriti e Felegon e Hermes e Patorobas e Hermas e goonɗinɓe Yeesu wonduɓe e maɓɓe fu. ");
INSERT INTO fue_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","Mii sanna Filologus e Yuliya. Mii sanna bo Nere e sakiike mum, mii sanna Olimpas e himɓe Alla wonduɓe e maɓɓe fu. ");
INSERT INTO fue_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","Moy mooɗon fu sanna banniraawo mum e mammilontirgo, e yidde. Kawtal Eklesiyaaji Almasiihu fu e sanna on. ");
INSERT INTO fue_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","Banniraaɓe, nani ɗo ko eelanmi on: kakkilanee waddooɓe ceennirgu caka mon. Kamɓe ɓee darta selingo on diga ekkitinol ŋol keɓuɗon. Boɗɗodee ɓe! ");
INSERT INTO fue_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","Gam himɓe ɓen, Almasiihu Joomiraawo meeɗen bane ɓe gollantoo, amma deeɗi maɓɓe. E haalaaji belɗi, eytooji ɓe jarbortoo himɓe ɓe walaa hakkillo. ");
INSERT INTO fue_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","Amma onon, himɓe fu e anni habaru ɗowtaare mooɗon. Gam majjum mii seyorii on. Amma mii yiɗi laatoɗon hakkilɓe dow waɗugo ko wooɗi, laatoɗon bo laaɓuɓe dow waɗugo ko halli. ");
INSERT INTO fue_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","Alla kokkoowo jam muunyitan Seyɗan yeeso seɗɗa ley koyɗe mooɗon. Moƴƴere Joomiraawo meeɗen Yeesu wonda e mooɗon! ");
INSERT INTO fue_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","Timote gollidoowo am sannii on. Lusiyus e Yason e Sosipater himɓe lenyol am bo e sanna on. ");
INSERT INTO fue_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","Min Tertiyus binnuɗo ɗerewol ŋol mi sannii on der kawtal meeɗen e Joomiraawo. ");
INSERT INTO fue_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","Gayus, beero am, e beero goonɗinɓe sannii on. Erastus cuuɗoowo ceede siire sannii on, e Kartus banniraawo meeɗen.  ");
INSERT INTO fue_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","Moƴƴere Joomiraawo men Yeesu Almasiihu wonoo e mon on fu. Aami! ");
INSERT INTO fue_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","Yettoore laatanoo Alla! Oo woodi baawɗe semmiɗingo on der goonɗinki, hande no linjiila ka baajotoomi batiri. Linjiila kan laati nun habaru Yeesu Almasiihu, eka hollita laabi Alla cuuɗiiɗi diga ɗum ɓooyi. ");
INSERT INTO fue_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","Amma jooni ɗum hollitake. Dewte annabiiɓe e seedoo ka. Alla tabitiiɗo batii ka anninee himɓe lenyi janani fu, gam ɓe goonɗina, ɓe ɗowtoo. ");
INSERT INTO fue_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","Alla tan woodi faamu. Tedduŋal laatanoo mo diga e Yeesu Almasiihu, faa abada. Aami! ");
INSERT INTO fue_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","Min Pol e banniraawo men Sosteni winnani on ɗerewol ŋol. Min Pol noddaaɗo gam laatoo lilaaɗo Yeesu Almasiihu e muunyo Alla. ");
INSERT INTO fue_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","Emen canna eklesiya Alla gonuka Korintu. Alla laaɓinii on gam on kawtii e Yeesu Almasiihu, onon noddaaɓe gam laatoɗon seniiɓe, noddooɓe inne Joomiraawo meeɗen Yeesu Almasiihu to gonuɗon fu. Yeesu on laatii Joomiraawo maɓɓe, e Joomiraawo meeɗen. ");
INSERT INTO fue_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","Alla Baaba e Joomiraawo meeɗen Yeesu Almasiihu waɗana on moƴƴere, hokka on jam! ");
INSERT INTO fue_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","Wakkati fu mii yetta Alla gam mooɗon sabbu moƴƴere makko ne o holliti on. O hollitii on ne gam on kawtii e Yeesu Almasiihu. ");
INSERT INTO fue_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","Der kawtal e makko, on keɓii huune fu, ko ɓuri du, der haala, e der annal fu, ");
INSERT INTO fue_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","eɗum hollita no on jaɓii seedaago amen haala Almasiihu no wooɗi. ");
INSERT INTO fue_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","Kanjum acci on dullay dokkal Alla baa gootal, oon keɗorii Joomiraawo meeɗen Yeesu Almasiihu wittaa. ");
INSERT INTO fue_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","Kanko semmiɗinta on faa heennyitirde, gam laatoɗon ɓe walaa gacce der nyalaane wittoygo makko. ");
INSERT INTO fue_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","Gam Alla laati nun koolaaɗo, kanko nodduɗo on kawton e Ɓiyiiko Yeesu Almasiihu, Joomiraawo meeɗen. ");
INSERT INTO fue_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","Banniraaɓe, mii eela on e inne Joomiraawo meeɗen Yeesu Almasiihu, batee haala goota, to on ceenniree, gaɗee hakkillo wooto e miilo wooto. ");
INSERT INTO fue_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","Banniraaɓe am, mi nanii diga e getti wuro Kolowe, kaɓe tawaaɗe caka mooɗon. ");
INSERT INTO fue_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","Ko jiɗum wi'ugo woni mi nanii moy mooɗon e wi'a min, mo Pol nun, goɗɗo bo e wi'a: «Min, mo Apollos nun,» goɗɗo feere kade e wi'a: «Min, mo Piyer nun,» faa hanne goɗɗo e wi'a: «Min, mo Almasiihu nun.» ");
INSERT INTO fue_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","Almasiihu seennu nun na? Pol nun maayi gam mon dow leggal palaaŋal na, naa e inne Pol nun gaɗiraɗon batisi? ");
INSERT INTO fue_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","Mi yettii Alla gam mi waɗay baa gooto mooɗon batisi, to hinaa Kirispus e Gayus. ");
INSERT INTO fue_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","Non non, goɗɗo mooɗon waawataa ko wi'i waɗaama batisi e inne am. ");
INSERT INTO fue_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","Ee, gooŋa, mi waɗii getti wuro Estefanas batisi. Baka ɗon, mi annaa naa mi waɗii goɗɗo kade batisi. ");
INSERT INTO fue_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","Almasiihu du lilay am gam mi waɗa batisi. Ko o lilanimmi woni, mi waajoo linjiila. To emi waajoo ka bo, mi waɗirtaa ɗum e baawal haala, gam to maayde Almasiihu dow leggal palaaŋal laatoo baanji. ");
INSERT INTO fue_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","Haala maayde Yeesu dow leggal palaaŋal laati nun haaŋaare dow gite halkooɓe, amma dow meeɗen enen hisinaaɓe, ka laati nun baawɗe Alla. ");
INSERT INTO fue_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","Eɗum winnaa der dewtere: «Mi halkan faamu faamuɓe, mi jirgitan annal annuɓe» ");
INSERT INTO fue_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","Den, toy wooduɓe faamu woni? Toy moodiɓɓe tawreeta woni? Toy waawuɓe jeddi der jamaanuuru nuu ɗo woni? Alla bane wayliti annal himɓe duuniyaaru nuu waɗi ŋal haaŋaare na? ");
INSERT INTO fue_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","Himɓe duuniyaaru nuu e faamu mum fu, annitay Alla no o holliti faamu makko. Ɗum laatake nun nun gam Alla e yiɗi hisingo goonɗinɓe ɗum fu diga e waaji amen ɗi woɓɓe daari haaŋaare. ");
INSERT INTO fue_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","Gooŋa nun, Yahuduuɓe e ƴama haaynaareeji, Yunaninkeeɓe bo e darta annal. ");
INSERT INTO fue_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","Amma enen, habaru tiggol Almasiihu dow leggal palaaŋal baajotoɗen. Yahuduuɓe e daari ɗum ko ferginta ɓe, Yunaninkeeɓe bo e daari ɗum haaŋaare. ");
INSERT INTO fue_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","Amma ɓe Alla noddi, baa ɓee Yahuduuɓe, ɗum bo ɓee Yunaninkeeɓe, ɓee anni no Almasiihu laati nun baawɗe e annal Alla. ");
INSERT INTO fue_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","Gam haaŋaare Alla e ɓuri annal neɗɗo, kade bo, tampere Alla e ɓuri semme neɗɗo. ");
INSERT INTO fue_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","Onon banniraaɓe, daaree no Alla noddiri on onon e ko'e mooɗon, caka mooɗon, wooduɓe annal dow gite himɓe, ɗum bo semmenteeɓe, maa bo ɓe lenyi laamiiɓe, ɗuuɗaa. ");
INSERT INTO fue_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","Amma Alla suɓii kaaŋal duuniyaaru gam o sentina wooduɓe annal, o suɓii tampuɓe gam o sentina wooduɓe semme. ");
INSERT INTO fue_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","O suɓii ko walaa tedduŋal e jawniiɗum, e ko wattiraaka der duuniyaaru nuu, gam o yawna ko teddi, ");
INSERT INTO fue_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","gam to goɗɗo heɓu juraago yeeso Alla. ");
INSERT INTO fue_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","Kanko hawti en e Yeesu Almasiihu, go Yeesu laatanii en annal Alla, der makko keɓuɗen gooŋaaku e laaɓineego e rinɗineego diga hakke. ");
INSERT INTO fue_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","To non «jurotooɗo fu, juro gam kawtal mum e Joomiraawo», hande no winniraa. ");
INSERT INTO fue_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","Banniraaɓe, no garunoomi waajaago on haala Alla cuuɗiika, mi waajoraaki on e annal, ɗum bo e baawal batu. ");
INSERT INTO fue_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","Mi yiɗayno waajaago on goɗɗum feere to hinaa Yeesu Almasiihu e no o tiggiraa dow leggal palaaŋal. ");
INSERT INTO fue_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","Mi wonakeno to mooɗon e tampere, e kulol, mii diwna puy. ");
INSERT INTO fue_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","Haala am e waaji am daraaki dow baawal haala e annal himɓe. Eɗum darii dow ko Ruuhu Ceniiɗo hollitinta e baawɗe, ");
INSERT INTO fue_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","gam to goonɗinki mooɗon daroo dow annal himɓe, amma dow baawɗe Alla. ");
INSERT INTO fue_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","E nun fu, emen baajoo annal lugguŋal yeeso ɓe goonɗinki mum semmiɗi. Amma annal himɓe duuniyaaru nuu ɗo bane men baajotoo, ɗum bo annal himɓe halkooɓe wooduɓe baawɗe. ");
INSERT INTO fue_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","Annal Alla kaayniiŋal, cuuɗaniiŋal himɓe men baajotoo, ŋal o siriyanii en diga duuniyaaru tagaaka, gam tedduŋal men. ");
INSERT INTO fue_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","Baa gooto der semmenteeɓe duuniyaaru nuu annaano ŋal, gam to ɓee annunoo ŋal, ɓe tiggataano Joomiraawo mo tedduŋal dow palaaŋal. ");
INSERT INTO fue_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","Amma hande no winnaa: «Ko itere meeɗay ko yi'i, noppi bo meeɗay ko nani, ko hakkillo goɗɗo yahay dow mum abada, kanjum Alla siriyanii yiɗuɓe ɗum.» ");
INSERT INTO fue_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","Amma enen, Alla hollitii en ɗum diga e Ruuhu mum. Ruuhu on e wiɗitoo huune fu, faa e lugguɗum Alla. ");
INSERT INTO fue_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","Moy waawata ko anni neɗɗo to hinaa yonki gonuki der joomum? Hande nun Alla bo, walaa annuɗo mo to hinaa Ruuhu gonɗo der makko. ");
INSERT INTO fue_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","Enen kan, ruuhu duuniyaaru bane keɓuɗen, Ruuhu Alla nun, gam annen ko Alla waɗani en e moƴƴere nun. ");
INSERT INTO fue_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","Men batirtaa ɗum bo e boliiɗe ɗe himɓe duuniyaaru janŋinta, amma e boliiɗe ɗe Ruuhu janŋinta. Hande non men paaminirta heɓuɓe Ruuhu, kujje ruuhunkeeje. ");
INSERT INTO fue_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","Mo heɓay Ruuhu Alla waawataa ko jaɓi kujje Ruuhu, gam ɗe laatani mo nun haaŋaare. O waawataa ko anni ɗe, gam e ballal Ruuhu tan ɗe annitirtee. ");
INSERT INTO fue_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","Gooduɗo Ruuhu Alla e suttontira huune fu, amma kanko e hoore makko, walaa cuttontiroowo haala makko. ");
INSERT INTO fue_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","Eɗum winnaa der Dewtere: «Moy anni miilooji Joomiraawo? Moy tintinta mo gokka?» Amma enen, Ruuhu Almasiihu na'on der meeɗen. ");
INSERT INTO fue_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","Banniraaɓe, mi waaway ko baddi on hande heɓuɓe Ruuhu Ceniiɗo, doole mi badda on hande himɓe duuniyaaru, e hande sukahon petton der goonɗinki Almasiihu. ");
INSERT INTO fue_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","Gam majjum baajiimi on hande yarooɓe kosam, hinaa nyaamdu tekkuŋol kokkumi on, gam on potanay ŋol taw. Faa jooni bo, on potanay ŋol, ");
INSERT INTO fue_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","gam jikku duuniyaaru nun jogii on taw. To nawniraagu e kaɓe e woni hakkune mooɗon, ɗum hollitintaa no jikku duuniyaaru nun jogii on na? Ɗum hollitintaa no ɓalli mooɗon nun jaalii on na? ");
INSERT INTO fue_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","To oon ceenniri hakkune mooɗon faa moy mooɗon fu e wi'a: «Min mo Pol nun,» oya bo e wi'a: «Min mo Apollos nun,» ɗum hollataa no onon e ɓe duuniyaaru fu on gootum nun na? ");
INSERT INTO fue_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","Moy nun Apollos laatii? Moy nun Pol laatii? Men laati nun gollantooɓe Alla, ɓe diga e muuɗum goonɗinɗon, jaka no Joomiraawo hokkiri moy maɓɓe fu. ");
INSERT INTO fue_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","Min, mi aawi, go Apollos misi diyam, amma Alla mawnini. ");
INSERT INTO fue_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","Hande non, aawuɗo e misuɗo diyam fu laataaki goɗɗum, Alla mawninɗo tan laatii goɗɗum. ");
INSERT INTO fue_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","Aawuɗo e misuɗo diyam fu laati nun gootum, moy maɓɓe fu heɓan riiba jaka golle mum. ");
INSERT INTO fue_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","Gam minon men gollidooɓe e Alla, onon laatii deme makko, e suudu makko maheteeŋol. ");
INSERT INTO fue_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","Dow moƴƴere ne Alla waɗanimmi, daɗɗumi daɗɗa suudu, hande mahoowo annanaaɗo. Jooni goɗɗo feere e maha dow makka. Amma sey moy fu waɗa hakkillo dow no mahirta. ");
INSERT INTO fue_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","Gam goɗɗo waawataa ko daɗɗi daɗɗa gokka to hinaa arana, kanka woni Yeesu Almasiihu. ");
INSERT INTO fue_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","Woɓɓe e maha dow daɗɗa kan e kanŋeeri, woɓɓe e cardi, woɓɓe bo e kaaƴe dime, woɓɓe bo e mahira leɗɗe e fuɗo e ƴomme. ");
INSERT INTO fue_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","Nyalaane darŋal, Almasiihu sumpitan golle moy fu, gam moy fu yiite foonnan golle mum, gam yiite hollan no golle moy fu wa'i. ");
INSERT INTO fue_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","Mo golle mum jaɓay yiite dow daɗɗa, joomum heɓan riiba golle mum. ");
INSERT INTO fue_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","Amma mo golle mum yiite nyaami, dullan riiba mum, kanko o hisan, amma o nandan hande cuttaaɗo e yiite. ");
INSERT INTO fue_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","Faa jooni on annitay onon nun laatii suudu Alla na? On annaa Ruuhu Alla na'on der mooɗon na? ");
INSERT INTO fue_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","To goɗɗo halkii suudu Alla, Alla halkan joomum. Gam suudu Alla laati nun seniinu, onon nun bo laatii suudu makko. ");
INSERT INTO fue_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","To goɗɗo jammoo hoore mum. Miiluɗo e mooɗon e woodi faamu der jaamanuuru nuu ɗo, sey o laatoo taw kaaŋaaɗo, gam o heɓa faamu gooŋawu. ");
INSERT INTO fue_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","Gam annal duuniyaaru nuu laati nun haaŋaare yeeso Alla. E winnii der dewtere: «Alla nanŋiran annuɓe e dabareeji maɓɓe.» ");
INSERT INTO fue_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","E winnii kade: «Joomiraawo e anni miilooji annuɓe, ɗi laati nun baanji.» ");
INSERT INTO fue_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","Gam majjum, to goɗɗo juroro himɓe, gam huune fu onon woodi. ");
INSERT INTO fue_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","Pol e Apollos e Piyer, ko woni der duuniyaaru, yonki e maayde, hanne e jaaŋo fu, onon woodi. ");
INSERT INTO fue_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","Onon, Almasiihu jey on, Almasiihu bo, Alla woodi ɗum. ");
INSERT INTO fue_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","Min Pol e Appolos, daaree men hande gollantooɓe Almasiihu, yowanaaɓe haala Alla cuuɗiika. ");
INSERT INTO fue_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","Ko yiɗaa yi'ee dow yowaanaaɓe golle woni ɓe gaɗa golle ɗe ɓe jowanaa e hoolaare. ");
INSERT INTO fue_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","Mi faalaaka baa to on kiitake am, ɗum bo to woɓɓe hiitake am. Min e hoore am bo, mi hiitataako hoore am. ");
INSERT INTO fue_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","Baa to ɓerne am gaccaaki am, ɗum yiɗay wi'ugo mii poonnitiiɗo. Joomiraawo woni kiitotooɗo am. ");
INSERT INTO fue_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","Gam majjum, to on kiitee goɗɗo ko wakkati yottoo, keɗee faa Joomiraawo wara. Kanko wurtinta ko suuɗii der niwre, o hollita ko woni der ɓerɗe himɓe. Nyalaane majjum, moy fu heɓan yettoore kaananne mo to Alla. ");
INSERT INTO fue_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","Banniraaɓe, haalaaji ɗi batumi dow am e Apollos fu, gam mooɗon batumi ɗi. Men jiɗu nun tokkitoɗon koyɗe amen, golliron haala bi'uka to neɗɗo ƴartoo ko winnaa. To on mawnitoree janŋinoowo oo ɗo, jawoɗon oo to. ");
INSERT INTO fue_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","Den moy ɓurnu maa dow woɓɓe? Ume gooduɗaa ko a hokka ɗum bane? To laatake a hokka ɗum nun, ume waɗi go aa mawnitoroo ɗum hande a hokka ɗum bane? ");
INSERT INTO fue_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","On kaarii ko, on keɓii ko jawdi, on puɗɗii laamaago, men laamodaaki e mon! Kay, emen jiɗi laamoɗon, gam men laamodoo e mooɗon minon bo! ");
INSERT INTO fue_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","Gam eɗum nandi hande minon lilaaɓe, Alla laatinii men sakitiiɓe. O nandinii men hande hiitaaɓe waree, ko duuniyaaru e malaykaaɓe e himɓe e daara men. ");
INSERT INTO fue_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","Minon men kaaŋaama gam Almasiihu, amma onon oon goodi annal gam kawtal mon e Almasiihu. Minon men galaa semme, amma onon oon cemmiɗi. On teddinaaɓe, amma minon men jawaaɓe. ");
INSERT INTO fue_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","Faa e jooni, minon men dafaaɓe e ɗonɗaaɓe, funtu men goni, emen piyee, emen jiiloo toy fu. ");
INSERT INTO fue_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","Emen golloo e ko'e amen hande maayooɓe gam nyaannugo ko'e amen. To men jennaama, men barkiɗina, emen tooree emen munyi, ");
INSERT INTO fue_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","to men batanaama kalluka, men toonto geeta. Men laatake buuri duuniyaaru, e tuuni ni himɓe fu woppata. ");
INSERT INTO fue_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","Mi winnanay on gam mi sentina on, amma gam mi waggina on, hande sukaaɓe am yiɗaaɓe. ");
INSERT INTO fue_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","E nun fu, baa to oon goodi ekkitinooɓe ujune sappo der goonɗinki mon Almasiihu, on goodaa baabiraaɓe ɗuuɓɓe kan. Gam der kawtal mooɗon e Almasiihu, min on laatii baaba mooɗon diga e waaji linjiila. ");
INSERT INTO fue_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","Gam majjum mii eela on, yemminee am. ");
INSERT INTO fue_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","Kan waɗi lilumi Timote ɓiyam jiɗaaɗo to mooɗon, koolaaɗo der kawtal mum e Joomiraawo. O siwtoran on no tokkirmi Almasiihu, e ko baajotoomi nokku fu der eklesiyaaji. ");
INSERT INTO fue_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","E woodi mawnitiiɓe caka mooɗon, ɓee miiji mi warataa kade to mooɗon. ");
INSERT INTO fue_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","Amma ɓooyataa ko mi wara to mooɗon, to Joomiraawo e yiɗi. To mi warii, mi yiɗaa nanugo haala mawnitiiɓe ɓen tan, amma baawɗe maɓɓe. ");
INSERT INTO fue_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","Gam Laamaare Alla, hollitintaako e haala tan, amma e baawɗe. ");
INSERT INTO fue_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","Ume ɓuruɗon yiɗugo? Mi warida to mooɗon e sawru na? Naa e yidde e ɗiggere? ");
INSERT INTO fue_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","Men nanii huune centiniiɗum waɗii caka mooɗon. Iri majjum meeɗay ko waɗii baa caka heeferɓe. Men nanii gooto mooɗon e yiɗi debbo baaba mum! ");
INSERT INTO fue_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","Go oon juroro ɗum! Ko haanuno ɓerɗe mooɗon biisoo, burtinon gaɗuɗo iri baadi bonni nii caka mooɗon. ");
INSERT INTO fue_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","Min, mii woɗɗodii on e ɓannu, amma miilooji am e wondi e mon. Mi hiitake gaɗuɗo baadi ni hande mi na'on to mooɗon. ");
INSERT INTO fue_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","De kawritiɗon fu, hakkillo am e wondi e mooɗon, gaɗee ɗum ɗo e baawɗe Joomiraawo meeɗen Yeesu: ");
INSERT INTO fue_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","gattee neɗɗo on der juuɗe Seyɗan, gam suunooji ɓannu makko halka, amma yonki makko hisa der nyalaane garki Joomiraawo. ");
INSERT INTO fue_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","E gooŋa, on goodaa laawol juraago! On annaa no ƴuufinirɗum seɗɗa ƴuufinan conni peen laawaani fu na? ");
INSERT INTO fue_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","Laaɓinee ko'e mooɗon, ikkinee ƴuufinirɗum kiiɗɗum hakkune mooɗon, heɓa laatoɗon conni laawaani keyri, on galaa ƴuufinirɗum. Oon laaɓi ko, gam Almasiihu jawgiiri Paska meeɗen hiisaama. ");
INSERT INTO fue_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","Gam majjum, en nyaamee juulɗe Paska hinaa e ƴuufinirɗum kiiɗɗum ɗum hallande e ganyaani. Amma nyaamen ɗe e conni peen ni walaa ƴuufinirɗum, laatiini alaama laaɓal e gooŋa. ");
INSERT INTO fue_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","Mi winnaniino on der ɗerewol am bi'umi, to on kawtee e waɗooɓe jeenu. ");
INSERT INTO fue_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","Himɓe duuniyaaru jeenooɓe bane batananmi, to ɗum bo suunaaɓe, maa bo wuyɓe, to ɗum bo saafooɓe tooruuje, gam to kamɓe nun batananmi, doole sey burtoɗon duuniyaaru. ");
INSERT INTO fue_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","Ko binnumi woni, to on kawtee e goɗɗo noddeteeɗo goonɗinɗo, go emo laatii jeenoowo, to ɗum cuunaaɗo, maa bo caafoowo tooruuje, maa bo nyo'oowo himɓe, ɗum bo jaroowo bagi, to ɗum bo gujjo, baa nyaamɗe to on kawtee e iri makko. ");
INSERT INTO fue_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","Ume faalii am e hiitaago himɓe ɓe goonɗinay? Onon yowanaa hiitaago wonɓe caka mooɗon. ");
INSERT INTO fue_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","Himɓe ɓe goonɗinay, Alla nun hiitotoo ɗum. Gam e winnaa: «Burtinee neɗɗo kalluɗo caka mooɗon.» ");
INSERT INTO fue_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","To goɗɗo mon e woodi haala gom e banniraawo mum, o suusan o yaara ka to hiitotooɓe ɓe duuniyaaru, ɓe goonɗinay, o acca himɓe Alla na? ");
INSERT INTO fue_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","E gooŋa on annaa no seniiɓe nun hiitoytoo himɓe duuniyaaru na? Den, to onon nun hiitoyto himɓe duuniyaaru, noy tampirɗon ko hiiti haalaaji petti? ");
INSERT INTO fue_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","On annaa enen nun hiitoyto malaykaaɓe na? Gam ume tampeten ko hiiti haalaaji goonki ki jooni? ");
INSERT INTO fue_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","Den, to haala gom waɗii caka mooɗon, himɓe ɓe eklesiya daaray goɗɗum cuɓoton ɓe kiitoo ka! ");
INSERT INTO fue_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","Mii bata ka gam centon! E gooŋa on goodaa mo hakkillo baa gooto caka mooɗon, baawoowo ko hiiti haala caka banniraaɓe na? ");
INSERT INTO fue_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","Goonɗinɗo e yaara goonɗinɗo bannu kiita to ɓe goonɗinay! ");
INSERT INTO fue_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","Maa to oon gaccontira, eɗum hollita no on tampii. Ume waɗi on jaɓataa gaɗaneɗon ko wooɗaa? Ume waɗi on munyantaa nyaameego amaana? ");
INSERT INTO fue_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","Amma onon, oon parkana woɓɓe, oon nyaama ɓe amaana, banniraaɓe mooɗon bo gaɗanton ɗum. ");
INSERT INTO fue_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","On annaa ɓe fonnitaaki naatataa der Laamaare Alla na? To on jammee ko'e mooɗon: Soɓuɓe, e saafooɓe tooruuje e jeenooɓe e luudiiɓe, ");
INSERT INTO fue_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","e wuyɓe e suunaaɓe e yarooɓe bagi, e nyo'ooɓe, e pasotooɓe, ɓe fu ɓe naatataa Laamaare Alla. ");
INSERT INTO fue_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","Woɓɓe mooɗon laatakeno hande non, amma jooni on lootaama, cenaɗon, on laatinaama foonnitiiɓe e baawɗe inne Joomiraawo meeɗen Yeesu Almasiihu, e Ruuhu Alla meeɗen. ");
INSERT INTO fue_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","Oon bi'a, oon goodi laawol waɗugo huune fu. Gooŋa nun, amma huune fu bane nafata on. Mii woodi laawol waɗugo huune fu, amma mi nootataako mi laatoo jeyaaɗo majjum. ");
INSERT INTO fue_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","Oon bi'a, nyaamdu waɗaaka maa gam reedu, reedu bo gam nyaamdu. Gooŋa nun, amma Alla halkan ɗum ɗum fu ɗiɗum. Ɓannu ɓii aadama tagaaka gam waɗugo jeenu, ŋol laatani nun Joomiraawo, Joomiraawo bo gam maggol. ");
INSERT INTO fue_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","Hande nun, Alla pintinɗo Joomiraawo meeɗen e maayde, fintinan en enen bo e baawɗe mum. ");
INSERT INTO fue_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","E gooŋa, on annaa ɓalli mooɗon laati nun jokkulal gootal der ɓannu Almasiihu na? Den, e haani mi etta jokkulal Almasiihu mi laatina jokkulal jeenoowo na? Waɗataako! ");
INSERT INTO fue_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","E gooŋa on annaa kawtuɗo e debbo jeenoowo fu, laatake ɓannu gootol e makko na? E winnaa: «Ɓe fu ɗiɗo, ɓe laatoto ɓannu gootol.» ");
INSERT INTO fue_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","Amma kawtuɗo e Joomiraawo laatoto ruuhu gootu e makko. ");
INSERT INTO fue_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","Boɗɗodee haala jeenu fu. Hakke ɗe neɗɗo waɗata fu, meemataa ɓannu mum, amma gaɗuɗo jeenu, waɗii hakke der ɓannu mum. ");
INSERT INTO fue_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","On annaa ɓalli mooɗon laati nun suudu Ruuhu Ceniiɗo gonɗo der mooɗon, mo Alla hokki on na? On jeyaa ko'e mooɗon, ");
INSERT INTO fue_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","gam Alla soodirii on e huune tedduɗum. Gam majjum, teddinee mo e ɓalli mooɗon. ");
INSERT INTO fue_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","Jooni kan mii yiɗi toontaago on ƴanɗe ɗe binnanɗon am. E gooŋa, e ɗum wooɗi to gorko meemay debbo. ");
INSERT INTO fue_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","Amma, gam to on gonee der jeenu, e haani gorko fu e woodi debbo mum, debbo moy fu bo, e woodi gorko mum. ");
INSERT INTO fue_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","Gorko huntana debbo haaje mum, debbo bo hande nun. ");
INSERT INTO fue_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","Debbo jeyaa ɓannu mum, gorum jey ŋol. Gorko bo hande non, jeyaa ɓannu mum, debbo mum jey ŋol. ");
INSERT INTO fue_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","To on calontiree dow kawtal ɓalli mooɗon, sey to on nannantiri dow majjum der wakkati seɗɗa gam du'aago. Ɓaawo majjum, kawtee kade gam to Seyɗan jarboo on dow tampere jogaago ko'e mon. ");
INSERT INTO fue_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","Ka batumi on ɗo, doole bane, saawari nun. ");
INSERT INTO fue_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","Mii yiɗi himɓe fu laatoo hande am, amma moy fu bane Alla hokki ɗum. Moy fu e dokkal muuɗum non, oo ɗo hande nii, oya bo hande nun. ");
INSERT INTO fue_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","Mii yiɗi wi'ugo ɓe ɓaŋay e ɓe ɓaŋaaka, e gowniiɓe, eɗum wooɗi ɓe jooɗoo hande am. ");
INSERT INTO fue_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","Amma to ɓe baawataa ko jogii ko'e maɓɓe, ɓe ɓaŋontira. Ɓaŋontirgo e ɓuri wonaago der suunooji. ");
INSERT INTO fue_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","Ɓaŋontirɓe, mii hokka ɓe dooka, to am bane ka ƴiwi, amma to Joomiraawo: debbo haanay saloo gorum. ");
INSERT INTO fue_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","To o salake bo, sey o jooɗoo nun nun, maa bo o naara e goriiko. Nunnun gorko bo, haanay seera debbo mum. ");
INSERT INTO fue_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","Amma dow horiiɓe, min nun batata kaa ɗo, Joomiraawo bane. To goonɗinɗo e woodi debbo mo goonɗinay, go debbo on nootii wondugo e makko, to o seeru mo. ");
INSERT INTO fue_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","Non non nun bo, to debbo goonɗinɗo e woodi gorko mo goonɗinay, to gorko on nootake wondugo e makko, to o saloo mo. ");
INSERT INTO fue_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","Gam gorko mo goonɗinay senaama gam debbo mum, nun bo debbo mo goonɗinay senaama gam gorko mum. To hinaa nun, ɓiɓɓe maɓɓe laatataako seniiɓe, nani bo ɓee ceniiɓe. ");
INSERT INTO fue_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","Amma mo goonɗinay, to e yiɗi seerugo goonɗinɗo, o seera. Den fu goonɗinɗo, debbo, to ɗum bo gorko, doolaaka jooɗoo der teegal mum, Alla noddu en nun gam gonoɗen der jam. ");
INSERT INTO fue_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","Debbo, aa anni naa a hisinan gorko maa na, nun bo gorko, aa anni naa a hisinan debbo maa na? ");
INSERT INTO fue_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","To non, moy fu wonoo hande no Joomiraawo hokkiri ɗum, moy fu wonoo der goonki ki wonuno go Alla nodda ɗum. Kanjum umuranmi der eklesiyaaji fu. ");
INSERT INTO fue_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","Juulniiɗo go Alla noddi ɗum, wonoroo nun nun, mo juulnaakino bo go Alla noddi ɗum, wonoroo nun nun. ");
INSERT INTO fue_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","Juulnaago e dullere juulnaago fu, laataaki goɗɗum, sey tokkugo umurooje Alla. ");
INSERT INTO fue_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","Moy fu wonoro hande no laatinoo go Alla nodda ɗum. ");
INSERT INTO fue_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","To jeyaaɗo nun laatinoɗaa go Alla noddu maa, taa accu ɗum ɓillee. Amma to a heɓii laawol no dimɗirtaa, taa yeeba ɗum. ");
INSERT INTO fue_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","Gam jeyaaɗo mo Joomiraawo noddi, laatake dimo gam Joomiraawo. Dimo mo Alla noddi bo, laatake jeyaaɗo Almasiihu. ");
INSERT INTO fue_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","On coodiraama e huune ko teddi. Gam majjum, to on laatinee ko'e mon jeyaaɓe himɓe. ");
INSERT INTO fue_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","Banniraaɓe, moy fu wonoro yeeso Alla, hande no laatinoo go o noddee. ");
INSERT INTO fue_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","Dow himɓe ɓe meeɗay ɓaŋugo, ɗum bo ɓaŋeego, mi woodaa umuroore gom ƴiwne to Joomiraawo, amma mi batan ko miilumi, min mo Joomiraawo yurmii, waɗimmi koolaaɗo. ");
INSERT INTO fue_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","Mii miila to neɗɗo wonake non, ɗum ɓuran wooɗugo, sabbu tooraaji ɗi jooni. ");
INSERT INTO fue_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","Ɓaŋuɗo, to seeru, mo ɓaŋay bo to daartu ɓaŋugo. ");
INSERT INTO fue_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","Amma ɓaŋuɗo waɗay gacce, gatol bo to ɓaŋaama, waɗay gacce. Amma annee no ɓaŋuɓe e woodi ɓillaaje der goonki mum. Kanji bo woni mi yiɗanaa on. ");
INSERT INTO fue_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","Banniraaɓe, ko jiɗum batugo on nani: Wakkati juutaa, gam majjum, ɓaŋuɓe laatoo hande ɓe ɓaŋay, ");
INSERT INTO fue_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","wullooɓe laatoo hande ɓe bullataa, seyotooɓe waɗa hande ɓe ceyataako, soodooɓe bo waɗa hande ɓe goodaa goɗɗum, ");
INSERT INTO fue_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","seyortooɓe jawdi duuniyaaru, wonoo hande ɓe ceyataako, gam duuniyaaru nuu ɗo faanake heennyugo. ");
INSERT INTO fue_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","Ko jiɗumi woni, burtoɗon e sugullaaji. Mo ɓaŋay e hiinnitano golle Joomiraawo, ko fottanta Joomiraawo tan o dartata. ");
INSERT INTO fue_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","Amma ɓaŋuɗo, hakkillo mum, to kujje duuniyaaru wonoto, ko welata debbo makko o dartata, ");
INSERT INTO fue_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","hakkillo joomum seennake. Hande non bo, mo ɓaŋaaka, hakkillo mum to kujje Joomiraawo wonoto, gam ɓannu e yonki makko fu laatoo ko senaa. Amma ɓaŋuɗo, hakkillo mum to kujje duuniyaaru wonoto, ko welata goriiko o dartata. ");
INSERT INTO fue_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","Mi batay ka, gam mi fergina on, amma gam wallugo on batanmi ka. Mii yiɗi gonoɗon der goonki kaanuki, tokkoɗon bo Joomiraawo e ɓerɗe goote. ");
INSERT INTO fue_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","To goɗɗo e woodi ɗaɓɓere mum, go o yiɗaa sentingo mo diga o ɓaŋay mo, o waɗa ko o yiɗi. O ɓaŋa mo, o farkay to o ɓaŋii mo. ");
INSERT INTO fue_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","Amma to gorko waɗi niiya der ɓerne mum, hinaa e doole, laatoo bo o waawan ko jogii hoore makko, o ɓaŋay, o waɗii ko wooɗi. ");
INSERT INTO fue_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","Ɓaŋuɗo ɗaɓɓere mum waɗii ko wooɗi, amma mo ɓaŋay mo, waɗii ko ɓuri wooɗugo. ");
INSERT INTO fue_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","Debbo ɓaŋaaɗo laati nun kaɓɓaaɗo to goriiko e wuuri. Amma to goriiko wuuraa, o rinɗii, o waawan ko etti mo o yiɗi fu, amma tawee der laawol Joomiraawo nun. ");
INSERT INTO fue_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","Dow miilo am, to debbo jooɗake ɓaŋaaka, o ɓuran heɓugo seyo. Miilooji am nun batanmi ɗon, mii miila bo mii woodi Ruuhu Alla. ");
INSERT INTO fue_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","Jooni faa mi toontoo ƴanɗe mooɗon dow tew caafiranaaɗum tooruuje. Gooŋa nun, en fu, een goodi annal. Annal e wadda manŋu hoore, amma yidde woni ko yaarata eklesiya yeeso. ");
INSERT INTO fue_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","Neɗɗo miijuɗo e anni, joomum annaa taw no haani anniree. ");
INSERT INTO fue_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","Amma neɗɗo fu jiɗuɗo Alla, Alla e anni ɗum. ");
INSERT INTO fue_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","Dow ƴakkugo tew caafiranaaɗum tooruuje, een anni tooruure laataaki goɗɗum der duuniyaaru, Alla gooto tan woni. ");
INSERT INTO fue_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","Himɓe e saafa tooruuje ɗe dow e ɗe ley. E gooŋa, saafeteeɓe ɗuuɓɓe e wi'eteeɓe joomiraaɓe ɗuuɓɓe na'on. ");
INSERT INTO fue_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","Amma e nun fu, enen kan, Alla gooto tan woni, Baaba taguɗo huune fu, mo gam mum buuruɗen. Kade bo Joomiraawo gooto tan woni, Yeesu Almasiihu mo huune fu laatorii e mum, e mo gam mum keɓuɗen yonki. ");
INSERT INTO fue_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","Amma himɓe fu bane anni gooŋa kaa ɗon. Woɓɓe woowunooɓe tooruuje, e ƴakka tew caafiranaaɗum tooruuje, go miilooji ɓerɗe maɓɓe tampuɗi e hiitoo ɓe. ");
INSERT INTO fue_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","Nyaamdu ɓeydantaa en goɗɗum to Alla. To en nyaamii, ɗum nafataa en goɗɗum, to en nyaamay bo, ɗum ɓuytataa en goɗɗum. ");
INSERT INTO fue_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","Amma kakkilee to dimaaku mooɗon doƴƴa ɓe goonɗinki mum semmiɗaa. ");
INSERT INTO fue_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","An gooduɗo annal, to goɗɗo yi'ii maa aa nyaama to tooruure saafetee, hakkillo makko tampuŋo hokkan mo o nyaama kanko bo. Den fu, der cuuɗiiɗum ɓerne makko, nafa caafiranaaka tooruure bane o nyaami na? ");
INSERT INTO fue_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","Den banniraawo tampuɗo halkan gam annal maa, kanko mo Almasiihu maayi gam muuɗum halka gam annal maa. ");
INSERT INTO fue_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","To oon gaɗa hakke dow banniraaɓe mooɗon ɓe goonɗinki mum semmiɗay hande nun, oon nawna miilooji ɓerɗe maɓɓe, hakke nun gaɗoton ɗon dow Almasiihu. ");
INSERT INTO fue_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","Gam majjum to nyaamdu nun doƴƴata banniraawo am, mi ƴakkataa kade tew abada, gam to mi doƴƴu mo. ");
INSERT INTO fue_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","Mi jeyaa hoore am na? Mi laataaki lilaaɗo na? Mi yi'ay Joomiraawo meeɗen Yeesu na? Diga golle ɗe gollaniimi Joomiraawo bane goonɗinirɗon na? ");
INSERT INTO fue_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","Baa to woɓɓe daaray am hande lilaaɗo, to mooɗon kan, mi lilaaɗo nun, gam onon laati ko hollitinta no Joomiraawo nun lilimmi. ");
INSERT INTO fue_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","Daa ko bi'anmi yiɗuɓe gaccaago am: ");
INSERT INTO fue_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","Men kaanaa nyaamugo e yarugo der golle amen na? ");
INSERT INTO fue_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","Men kaanaa woositaago e rewɓe goonɗinɓe hande no lilaaɓe woɓɓe, e miiraaɓe Joomiraawo, e Kefas waɗata na? ");
INSERT INTO fue_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","Min e Barnabbas tan nun haani golloo gam nyaannugo ko'e amen na? ");
INSERT INTO fue_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","Soogeeru nuye haɓata konu e nyaanna hoore mum bo? Demoowo moy woni mo nyaamataa ɓiɓɓe gesa mum? Moy woni duroowo mo yarataa kosam darne mum? ");
INSERT INTO fue_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","Ka batanmi ɗo, dow miilooji himɓe bane ɗum ƴiwi, tawreeta bo batii ɗum. ");
INSERT INTO fue_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","E winnaa der tawreeta: «Taa haɓɓu hunnuko gaari gollotooni der nafa.» Ga'i demooji nun Alla batani ka na? ");
INSERT INTO fue_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","E gooŋa enen bane batanaa ka na? Enen nun batanaa haala ka, gam demoowo e duggoowo fu waɗa golle muuɗum e miiliri heɓugo geɗu mum. ");
INSERT INTO fue_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","Men aawii der mooɗon kujje ruuhunkeeje. To men duggii jawdi ni gooduɗon, ko mawni nun na? ");
INSERT INTO fue_vpl VALUES ("C19_12","076_9_12","1CO","9","12","12","To woɓɓe e woodi laawol dow mooɗon, minon, men ɓuraa ɓe woodugo ŋol na? Amma minon, men nafitoraaki baawɗe amen. Men munyanii huune fu gam to men paddoo linjiila Almasiihu yahugo yeeso. ");
INSERT INTO fue_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","E gooŋa, on annaa gollotooɓe der suudu Alla e heɓa nyaamdu mum der ko sakketee na? On annaa bo no gollotooɓe der wuuɗirde sadakaaji, der ɗon nun heɓata geɗu mum na? ");
INSERT INTO fue_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","Hande non bo, Joomiraawo batii waajotooɓe linjiila, heɓa nyaamdu mum diga waaji linjiila. ");
INSERT INTO fue_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","Amma min, mi nafitoraaki kujje ɗee fu, to mi winnii ka bo, gam mi heɓa ɗe bane. Gomma mi maaya, mi nootataako goɗɗo haɗanmi juraago dow majjum. ");
INSERT INTO fue_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","Gam waajaago linjiila laatanaaki am juro, doole nun mi waajoo ka. Bone woodanimmi to mi waajaaki ka! ");
INSERT INTO fue_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","To e anniya ɓerne am nun gaɗiranmi golle ɗen, mi heɓan riiba am. Amma min bane suɓi, mi yowana ɗe nun. ");
INSERT INTO fue_vpl VALUES ("C19_18","076_9_18","1CO","9","18","18","Den fu, ume woni riiba am? Riiba am woni waajaago linjiila hinaa gam joddi. Mi dartay nafitoraago ko haani mi heɓa gam gollal ŋal. ");
INSERT INTO fue_vpl VALUES ("C19_19","076_9_19","1CO","9","19","19","Mii dimo dow himɓe fu, amma mi laatinii hoore am jaggantooɗo himɓe fu, gam mi heɓana Almasiihu ɗuuɓɓe maɓɓe. ");
INSERT INTO fue_vpl VALUES ("C19_20","076_9_20","1CO","9","20","20","To mi na'on caka Yahuduuɓe, mi waɗa hoore am hande Yahuduujo, gam mi heɓa ɓe. To mi yahii to tokkuɓe tawreeta, mii waɗa hoore am hande tokkuɗo tawreeta, gam mi heɓa ɓe, baa to mi tokkay tawreeta. ");
INSERT INTO fue_vpl VALUES ("C19_21","076_9_21","1CO","9","21","21","Hande nun bo to mi yahii to ɓe annaa tawreeta, mii waɗa hoore am hande mo annaa tawreeta, gam mi heɓa ɓe, ɗum yiɗay wi'ugo mi tokkay tawreeta Alla, gam der umuroore Almasiihu gonumi. ");
INSERT INTO fue_vpl VALUES ("C19_22","076_9_22","1CO","9","22","22","To mi yahii to goonɗinɓe tampuɓe, mii waɗa hoore am hande tampuɗo, gam mi heɓa ɓe. Walaa fu no mi laatinay hoore am dow himɓe fu gam mi hisinira woɓɓe maɓɓe, baa no waɗi fu. ");
INSERT INTO fue_vpl VALUES ("C19_23","076_9_23","1CO","9","23","23","Ɗum fu, mi waɗii ɗum gam linjiila, gam mi heɓa geɗu am der barke makka. ");
INSERT INTO fue_vpl VALUES ("C19_24","076_9_24","1CO","9","24","24","E gooŋa, on annaa himɓe fu nun doggata der jayri, to waɗooɓe daɗontiro doggata na? Amma e non fu, gooto maɓɓe tan nun heɓata ko resaa on. Gam majjum, doggee gam keɓal. ");
INSERT INTO fue_vpl VALUES ("C19_25","076_9_25","1CO","9","25","25","Jiɗɗo daɗugo der doggudu fu, sey elta ɓannu mum der huune fu. Kamɓe, ɓee gaɗa ɗum gam heɓugo keɓal meetalol ɗayloowol, amma enen, een tammi heɓugo meetalol ŋol ɗaylataa. ");
INSERT INTO fue_vpl VALUES ("C19_26","076_9_26","1CO","9","26","26","Gam majjum to emi dogga, gam baanji bane dogganmi, to emi lukka bo, dow hennu bane lukkanmi. ");
INSERT INTO fue_vpl VALUES ("C19_27","076_9_27","1CO","9","27","27","Amma mii gollina ɓannu am e naawɗum faa mi jaaloo ŋol, gam mii hula mi dulla heɓugo yetteego ɓaawo baajiimi woɓɓe linjiila. ");
INSERT INTO fue_vpl VALUES ("C110_1","076_10_1","1CO","10","1","1","Banniraaɓe, mii yiɗi paamon ɗum ɗo: ɓaawo no kaakiraaɓe meeɗen wurtii Misira, der wakkati Muusa, ɓe fu ɓe gonake ley duulere ardanii ne ɓe, ɓe fu bo, ɓe jolii maayo. ");
INSERT INTO fue_vpl VALUES ("C110_2","076_10_2","1CO","10","2","2","Ɓe fu ɓe gaɗanaama batisi der duulere e der maayo sabbu kawtal maɓɓe e Muusa. ");
INSERT INTO fue_vpl VALUES ("C110_3","076_10_3","1CO","10","3","3","Kade bo, ɓe fu ɓe nyaamii nyaamdu ruuhunkewol gootol, ");
INSERT INTO fue_vpl VALUES ("C110_4","076_10_4","1CO","10","4","4","ɓe fu ɓe jarii jaram ruuhunkejam gootam, burtiiɗam e tepaare ruuhunkeere, jaadannoore e maɓɓe. Tepaare nen woni Almasiihu. ");
INSERT INTO fue_vpl VALUES ("C110_5","076_10_5","1CO","10","5","5","Amma e non fu, ɗuuɓɓe maɓɓe, Alla yerdaaki ɗum. Ɓe baraama der ladde. ");
INSERT INTO fue_vpl VALUES ("C110_6","076_10_6","1CO","10","6","6","Huune ɗum fu, laatanake en misaalu gam to en tokkee jiɗaaɗi yonki meeɗen, hande no maɓɓe. ");
INSERT INTO fue_vpl VALUES ("C110_7","076_10_7","1CO","10","7","7","To on laatee saafooɓe tooruuje hande no woɓɓe maɓɓe waɗi, hande no winnaa: «Himɓe jooɗii nyaami yari, den ɓe ummii gam ɓe pija fijo jaayŋo.» ");
INSERT INTO fue_vpl VALUES ("C110_8","076_10_8","1CO","10","8","8","To on naatee jeenu hande no woɓɓe maɓɓe waɗi. Faa himɓe ujune laso e tato maayi nyalaane woore. ");
INSERT INTO fue_vpl VALUES ("C110_9","076_10_9","1CO","10","9","9","To on jarbee Joomiraawo hande no woɓɓe maɓɓe waɗi, ko bolle halki ɓe. ");
INSERT INTO fue_vpl VALUES ("C110_10","076_10_10","1CO","10","10","10","To on dumbitee hande no woɓɓe maɓɓe waɗi, go malaykaajo maayde halki ɓe. ");
INSERT INTO fue_vpl VALUES ("C110_11","076_10_11","1CO","10","11","11","Huune ɗum fu, tawii ɓe gam keɓen misaalu. Ɗum winnaama bo gam keɓen hakkillo, enen wonuɓe der wakkatiiji cakitiiɗi. ");
INSERT INTO fue_vpl VALUES ("C110_12","076_10_12","1CO","10","12","12","Gam majjum, miiluɗo e darii fu, waɗa hakkillo to yanu. ");
INSERT INTO fue_vpl VALUES ("C110_13","076_10_13","1CO","10","13","13","Jarbeeji walaa ɗi keɓuɗon, ɗi woɓɓe heɓayno. Alla e laatii koolaaɗo, o accataa jarbeɗon ɓura semme mon. To ɗi garii bo, o hokkan on laawol no munyirton, e no burtortoɗon e majji. ");
INSERT INTO fue_vpl VALUES ("C110_14","076_10_14","1CO","10","14","14","Gam majjum, banniraaɓe am yiɗaaɓe, boɗɗodee caafol tooruuje. ");
INSERT INTO fue_vpl VALUES ("C110_15","076_10_15","1CO","10","15","15","Mii badda on hande wooduɓe hakkillo, onon e ko'e mooɗon biɗitee ko batumi. ");
INSERT INTO fue_vpl VALUES ("C110_16","076_10_16","1CO","10","16","16","Jarirgel hiraane seniine ŋel jetteten Alla gam mum, ŋel hollitintaa en kawtii e ƴiiƴam Almasiihu na? Peen ceenneten een nyaama, ŋa hollitintaa en kawtii e ɓannu Almasiihu na? ");
INSERT INTO fue_vpl VALUES ("C110_17","076_10_17","1CO","10","17","17","Peen ŋan laati nun goota, nun nun enen bo, no ɗuuɗirɗen fu, en laati nun ɓannu gooton, gam en fu, een keɓa geɗu meeɗen e peen goota ŋan. ");
INSERT INTO fue_vpl VALUES ("C110_18","076_10_18","1CO","10","18","18","Daaree Isira'iilaaɓe: himɓe maɓɓe nyaamooɓe sadakaaji cakkanaaɗi Alla, ɓe goodaa kawtal e Alla cakkanteeɗo sadakaaji ɗin na? ");
INSERT INTO fue_vpl VALUES ("C110_19","076_10_19","1CO","10","19","19","Ko jiɗum wi'ugo woni: Tooruure e tew ko ne saafiranaa e laatii goɗɗum? Aawo! ");
INSERT INTO fue_vpl VALUES ("C110_20","076_10_20","1CO","10","20","20","Amma, ko heeferɓe saafirta, ginnaaji ɓe caafanta ɗum, Alla bane. Nani bo mi yiɗaa oon goodi kawtal e ginnaaji. ");
INSERT INTO fue_vpl VALUES ("C110_21","076_10_21","1CO","10","21","21","On baawataa ko yariri jarirgel Joomiraawo, jariron bo ŋel ginnaaji, on baawataa ko nyaamidi e Joomiraawo, nyaamidon e ginnaaji bo. ");
INSERT INTO fue_vpl VALUES ("C110_22","076_10_22","1CO","10","22","22","Naa en jiɗu nun ummingo nawniraagu Joomiraawo? Een ɓuri mo semme na? ");
INSERT INTO fue_vpl VALUES ("C110_23","076_10_23","1CO","10","23","23","Gooŋa nun: «Huune fu e dagii». Amma huune fu bane nafata. «Huune fu e dagii,» amma huune fu bane yaarata eklesiya yeeso. ");
INSERT INTO fue_vpl VALUES ("C110_24","076_10_24","1CO","10","24","24","To goɗɗo mooɗon daartu ko nafata ɗum kan tan, amma ko nafata woɓɓe bo. ");
INSERT INTO fue_vpl VALUES ("C110_25","076_10_25","1CO","10","25","25","Ko sippetee der luumo fu, on baawan ko nyaami ɗum, to on daartee annugo to ɗum ƴiwi, gam ɓerɗe mon e gaccoo on. ");
INSERT INTO fue_vpl VALUES ("C110_26","076_10_26","1CO","10","26","26","Gam: «Leydi e ko woni e mayri fu, Joomiraawo jey.» ");
INSERT INTO fue_vpl VALUES ("C110_27","076_10_27","1CO","10","27","27","To mo goonɗinay noddinii on nyaamɗe, go nootiɗon noddoore makko, nyaamee ko o resani on fu e jam, to on biɗitee ɗum gam ɓerɗe mooɗon e gaccoo on. ");
INSERT INTO fue_vpl VALUES ("C110_28","076_10_28","1CO","10","28","28","Amma to goɗɗo wi'ii on: «Tew ɗum ɗo caafiranaaɗum tooruure nun,» den kan, to on nyaamee gam sabbu ceedinɗo on, e gam sabbu cuuɗiiɗum ɓerne. ");
INSERT INTO fue_vpl VALUES ("C110_29","076_10_29","1CO","10","29","29","Mi batantaa ɗo miilooji ɓerɗe mon, amma ɗi oya. E gooŋa, gam ume miilooji ɓerne goɗɗo hiitotoo dimaaku am? ");
INSERT INTO fue_vpl VALUES ("C110_30","076_10_30","1CO","10","30","30","To mi yettii Alla dow nyaamdu am, gam ume gacceteemi dow nyaamdu nu jettumi Alla gam mum? ");
INSERT INTO fue_vpl VALUES ("C110_31","076_10_31","1CO","10","31","31","Gam majjum, on nyaaman nun, on jaran nun, ko gaɗoton fu de, gaɗee ɗum gam teddinon Alla. ");
INSERT INTO fue_vpl VALUES ("C110_32","076_10_32","1CO","10","32","32","To on laatanee Yahuduuɓe e Yunaninkeeɓe e eklesiya Alla fergere. ");
INSERT INTO fue_vpl VALUES ("C110_33","076_10_33","1CO","10","33","33","Laatee hande am, gam dow huune fu, mii darta fottango himɓe fu, mi dartataa ko nafatammi min tan, ko nafata himɓe fu dartanmi, gam ɓe kisa. ");
INSERT INTO fue_vpl VALUES ("C111_1","076_11_1","1CO","11","1","1","Yemminee am hande no min e hoore am yemminiranmi Almasiihu. ");
INSERT INTO fue_vpl VALUES ("C111_2","076_11_2","1CO","11","2","2","Mii yetta on gam oon ciwtorammi wakkati fu, e kade bo gam oon joggii ekkitinooje hande no ekkitinirmi on. ");
INSERT INTO fue_vpl VALUES ("C111_3","076_11_3","1CO","11","3","3","Mii yiɗi bo paamon no Almasiihu nun woni hooreejo dow gorko fu, gorko bo woni hooreejo dow debbo, Alla bo woni hooreejo Almasiihu. ");
INSERT INTO fue_vpl VALUES ("C111_4","076_11_4","1CO","11","4","4","To gorko e du'oo, ɗum bo e waɗa annabaaku, go e suddii hoore mum, o teddinay hooreejo makko. ");
INSERT INTO fue_vpl VALUES ("C111_5","076_11_5","1CO","11","5","5","Amma to debbo kan e du'oo, ɗum bo e waɗa annabaaku, go fiilaaki, o teddinay hooreejo makko, oo nandi e pemmiiɗo laaɓune. ");
INSERT INTO fue_vpl VALUES ("C111_6","076_11_6","1CO","11","6","6","Gam to debbo fiilaaki, sey o hesa gaasa makko. Amma to hesugo gaasa, ɗum bo femmugo ka e sentinoo mo, den fu, o fiiloo. ");
INSERT INTO fue_vpl VALUES ("C111_7","076_11_7","1CO","11","7","7","Gorko haanay sudda hoore mum gam o laati nun nandi Alla e tedduŋal mum. Amma debbo, laati nun tedduŋal gorko. ");
INSERT INTO fue_vpl VALUES ("C111_8","076_11_8","1CO","11","8","8","Gam gorko bane ƴiwi e debbo, debbo nun ƴiwi e gorko, ");
INSERT INTO fue_vpl VALUES ("C111_9","076_11_9","1CO","11","9","9","gorko bane tagaa gam debbo, debbo nun tagaa gam gorko. ");
INSERT INTO fue_vpl VALUES ("C111_10","076_11_10","1CO","11","10","10","Gam daliila malaykaaɓe, debbo fiiloo gam hollita baawɗe mum. ");
INSERT INTO fue_vpl VALUES ("C111_11","076_11_11","1CO","11","11","11","Hande no Joomiraawo resiri, debbo wonataako to gorko walaa, gorko bo wonataako to debbo walaa. ");
INSERT INTO fue_vpl VALUES ("C111_12","076_11_12","1CO","11","12","12","Gam hande no debbo ƴiwiri e gorko, non non nun gorko bo rimiraa e debbo. Amma ɗum fu, to Alla ɗum ƴiwi. ");
INSERT INTO fue_vpl VALUES ("C111_13","076_11_13","1CO","11","13","13","Miilee onon e ko'e mooɗon: E wooɗi debbo e du'oo, o fiilaaki na? ");
INSERT INTO fue_vpl VALUES ("C111_14","076_11_14","1CO","11","14","14","Tawaaŋal hollataa to gorko yoofitii gaasa mum, femmay ka, eɗum sentinii na? ");
INSERT INTO fue_vpl VALUES ("C111_15","076_11_15","1CO","11","15","15","Amma to debbo, tedduŋal muuɗum nun, gam o hokkaama gaasa juutuka hande fiilaanu. ");
INSERT INTO fue_vpl VALUES ("C111_16","076_11_16","1CO","11","16","16","Jiɗɗo yeddugo ka fu, baa minon, baa eklesiya Alla, en goodaa tawaaŋal ŋal ɗon. ");
INSERT INTO fue_vpl VALUES ("C111_17","076_11_17","1CO","11","17","17","Woodi ko jiɗum batugo on kade dow haala no kawritirton. Dow majjum mi waawataa ko mani on, gam no kawritirton laataaki gam yaarugo on yeeso, amma gam wittingo on ɓaawo. ");
INSERT INTO fue_vpl VALUES ("C111_18","076_11_18","1CO","11","18","18","Taw, mi nanii to on kawtii, hunnuko wooto walaa hakkune mon, mi hoolake bo haala kan gokka mum, gooŋa nun. ");
INSERT INTO fue_vpl VALUES ("C111_19","076_11_19","1CO","11","19","19","Haani du ceenniigu laatoo caka mooɗon, gam heɓa gooŋaaɓe wurtoo e mooɗon. ");
INSERT INTO fue_vpl VALUES ("C111_20","076_11_20","1CO","11","20","20","To on kawritii, hiraane Joomiraawo bane nyaamoton. ");
INSERT INTO fue_vpl VALUES ("C111_21","076_11_21","1CO","11","21","21","Gam to on kawritii oon nyaama, moy mooɗon fu, e yawɗanoo nyaamugo nafa mum, den tawaa woɓɓe e rafaa, woɓɓe bo bagi e doƴƴi ɗum. ");
INSERT INTO fue_vpl VALUES ("C111_22","076_11_22","1CO","11","22","22","E gooŋa on goodaa cuuɗi to haani nyaamon, jaron na? Naa on jawu nun eklesiya Alla? On jiɗu nun sentingo talakaaɓe na? Ume bi'anmi on? Mi yetta on na? Mi waawataa ko yetti on dow majjum. ");
INSERT INTO fue_vpl VALUES ("C111_23","076_11_23","1CO","11","23","23","Min, diga Joomiraawo nun keɓumi ko jottimmi on: Jemmaare ne der muuɗum Joomiraawo meeɗen Yeesu jammaa, o etti peen, ");
INSERT INTO fue_vpl VALUES ("C111_24","076_11_24","1CO","11","24","24","o yetti Alla, o ŋappiti ŋa, o wi'i: Ɗum ɗo woni ɓannu am kokkaaŋol gam mooɗon. Gaɗee ɗum, oon ciwtorirammi. ");
INSERT INTO fue_vpl VALUES ("C111_25","076_11_25","1CO","11","25","25","No ɓe keennyi, o etti jarirgel innabojam, o wi'i: Jarirgel ŋel woni alkawal kesal tabbitiniraaŋal e ƴiiƴam am. De jaroton ɗam fu, jaree ɗam, oon ciwtorirammi. ");
INSERT INTO fue_vpl VALUES ("C111_26","076_11_26","1CO","11","26","26","De nyaamoton peen oon jara der jarirgel ŋel fu, oon baajoo wa ɗon haala maayde Joomiraawo faa de o wittoy. ");
INSERT INTO fue_vpl VALUES ("C111_27","076_11_27","1CO","11","27","27","Gam majjum, neɗɗo fu ƴakkuɗo peen, yariri jarirgel Joomiraawo hande no haaniray, waɗii hakke dow ɓannu Joomiraawo e ƴiiƴam mum. ");
INSERT INTO fue_vpl VALUES ("C111_28","076_11_28","1CO","11","28","28","Gam majjum, moy fu wiɗitoo hoore mum go ƴakka peen, yara bo der jarirgel ŋel. ");
INSERT INTO fue_vpl VALUES ("C111_29","076_11_29","1CO","11","29","29","Gam neɗɗo ƴakkuɗo peen, yari der jarirgel ŋel, go suttontiray ko woni ɓannu Joomiraawo, o fooɗanan hoore makko kiita diga nyaamɗe e jarɗe makko. ");
INSERT INTO fue_vpl VALUES ("C111_30","076_11_30","1CO","11","30","30","Gam majjum waɗi ko ɗuuɓɓe mooɗon laatii nyawɓe e moofiɗinɓe, ɗuuɓɓe bo maayi. ");
INSERT INTO fue_vpl VALUES ("C111_31","076_11_31","1CO","11","31","31","To en biɗitake ko'e meeɗen, en kiitataake. ");
INSERT INTO fue_vpl VALUES ("C111_32","076_11_32","1CO","11","32","32","Amma Joomiraawo e hiitoo en gam o elta en, wara doƴƴideɗen kiita e himɓe duuniyaaru. ");
INSERT INTO fue_vpl VALUES ("C111_33","076_11_33","1CO","11","33","33","To non, banniraaɓe am, to on kawritii gam nyaamon hiraane Joomiraawo, keɗontiree. ");
INSERT INTO fue_vpl VALUES ("C111_34","076_11_34","1CO","11","34","34","To woodi e mooɗon mo rafo waɗata, joomum nyaama diga wuro mum, gam to kawtal mooɗon waddana on kiita. Dow ko horii fu, to mi warii, mi laaɓinanan on ɗum. ");
INSERT INTO fue_vpl VALUES ("C112_1","076_12_1","1CO","12","1","1","Banniraaɓe, dow haala dokke Ruuhu Ceniiɗo hokkata, mi yiɗaa dullon annal dow mum. ");
INSERT INTO fue_vpl VALUES ("C112_2","076_12_2","1CO","12","2","2","Ciwtoree, den ko on goonɗinayno, on pooɗeno far to tooruuje muume. ");
INSERT INTO fue_vpl VALUES ("C112_3","076_12_3","1CO","12","3","3","Gam majjum waɗi ko mii yiɗi paamon ɗum ɗo. Walaa bi'oowo Yeesu laati nun naalaaɗo to Ruuhu Alla o batirta ka, kade bo walaa bi'oowo Yeesu laati nun Joomiraawo to joomum woodaa Ruuhu Ceniiɗo. ");
INSERT INTO fue_vpl VALUES ("C112_4","076_12_4","1CO","12","4","4","Dokke Ruuhu Ceniiɗo feere feereeje nun woni, amma Ruuhu on gooto nun. ");
INSERT INTO fue_vpl VALUES ("C112_5","076_12_5","1CO","12","5","5","Golle feere feereeje nun woni, amma Joomiraawo majje laati nun gooto. ");
INSERT INTO fue_vpl VALUES ("C112_6","076_12_6","1CO","12","6","6","Baawal golle feere feereeje nun woni, amma Alla gooto on waɗata huune fu der moy fu. ");
INSERT INTO fue_vpl VALUES ("C112_7","076_12_7","1CO","12","7","7","Moy fu heɓii kokkal kollitoowal baawɗe Ruuhu, nafoowal himɓe fu. ");
INSERT INTO fue_vpl VALUES ("C112_8","076_12_8","1CO","12","8","8","Ruuhu hokkata oo ɗo dokkal batugo e hakkillo, o hokka oo to dokkal batugo e annal. Ruuhu gooto on waɗata ɗum. ");
INSERT INTO fue_vpl VALUES ("C112_9","076_12_9","1CO","12","9","9","Kanko on hokkata oo ɗo goonɗinki, oo to nyawtugo nyawɓe, ");
INSERT INTO fue_vpl VALUES ("C112_10","076_12_10","1CO","12","10","10","o hokka oo ɗo baawɗe waɗugo haaynaareeji, oo to baawɗe waɗugo annabaaku, oo ɗo baawɗe annitingo ko warata diga Ruuhu, oo to baawɗe batugo e ɗelle Ruuhu, goɗɗo bo o hokka ɗum baawɗe nantingo ɗelle ɗen. ");
INSERT INTO fue_vpl VALUES ("C112_11","076_12_11","1CO","12","11","11","Ruuhu gooto on tan waɗata ɗum ɗon fu, o seennirana moy fu dokkal hande no o yiɗiri. ");
INSERT INTO fue_vpl VALUES ("C112_12","076_12_12","1CO","12","12","12","Hande no ɓannu laatorii gootol baa no jokkule ɗuuɗɗe ŋol woodi, nun bo, jokkule ɗuuɗɗe laatorii ɓannu gootol. Non Almasiihu bo wa'i. ");
INSERT INTO fue_vpl VALUES ("C112_13","076_12_13","1CO","12","13","13","Gam en fu, en keɓii batisi diga e Ruuhu gooto gam laatoɗen ɓannu gootol, Yahuduuɓe e Yunaninkeeɓe, maccuɓe e rimɓe, en fu en jarinaama Ruuhu gooto on. ");
INSERT INTO fue_vpl VALUES ("C112_14","076_12_14","1CO","12","14","14","Ɓannu neɗɗo laataaki jokkulal gootal, amma jokkule ɗuuɗɗe. ");
INSERT INTO fue_vpl VALUES ("C112_15","076_12_15","1CO","12","15","15","To koyŋal wi'i: «No mi junŋo bane, mi jeyaaka e ɓannu,» e nun fu ŋal jeyaaka e ɓannu na? ");
INSERT INTO fue_vpl VALUES ("C112_16","076_12_16","1CO","12","16","16","Naa to nowru wi'i: «No mi laataaki itere, mi jeyaaka e ɓannu,» ɗum haɗan ne jeyeego e ɓannu na? ");
INSERT INTO fue_vpl VALUES ("C112_17","076_12_17","1CO","12","17","17","To jokkule ɓannu fu laatake gite, noy neɗɗo nanirta? Naa to ɗe fu ɗe laatake nowru, noy neɗɗo luuttirta? ");
INSERT INTO fue_vpl VALUES ("C112_18","076_12_18","1CO","12","18","18","Amma, Alla resii jokkulal baaŋale fu der ɓannu, hande no o yiɗiri. ");
INSERT INTO fue_vpl VALUES ("C112_19","076_12_19","1CO","12","19","19","To jokkule fu laatakeno gootal, noy ɓannu laatotonoo? ");
INSERT INTO fue_vpl VALUES ("C112_20","076_12_20","1CO","12","20","20","E gooŋa, jokkule e ɗuuɗi, amma ɗe fu, ɗe laati nun ɓannu gootol. ");
INSERT INTO fue_vpl VALUES ("C112_21","076_12_21","1CO","12","21","21","Itere waawataa ko wi'i junŋo: «Mi woodaa haaje maa». Hoore bo waawataa ko wi'i koyɗe: «Mi woodaa haaje mooɗon». ");
INSERT INTO fue_vpl VALUES ("C112_22","076_12_22","1CO","12","22","22","Amma, jokkule ɓannu daaraaɗe e ɓuri tampugo, kanje bo ɗee nafa. ");
INSERT INTO fue_vpl VALUES ("C112_23","076_12_23","1CO","12","23","23","Jokkule ɗe daareten walaa tedduŋal, kanje ɓuruɗen teddingo. Jokkule ɗe centirten bo kanje ɓuruɗen hakkilango. ");
INSERT INTO fue_vpl VALUES ("C112_24","076_12_24","1CO","12","24","24","Jokkule meeɗen goɗɗe en kaajaaka hakkilango ɗum. Alla hawtii jokkule fu, hokki ɓuruɗe faanɗugo, tedduŋal, ");
INSERT INTO fue_vpl VALUES ("C112_25","076_12_25","1CO","12","25","25","gam to ceennirgu waɗu der ɓannu, o acci jokkule fu e wallontira hakkune mum. ");
INSERT INTO fue_vpl VALUES ("C112_26","076_12_26","1CO","12","26","26","To jokkulal gootal e naawee, ɗe fu ɗe nana naawɗum e maggal. To jokkulal gootal teddinaama, ɗe fu ɗe maata welwelo e maggal. ");
INSERT INTO fue_vpl VALUES ("C112_27","076_12_27","1CO","12","27","27","Onon, on laati nun ɓannu Almasiihu, moy mooɗon fu laati nun jokkulal ɓannu makko. ");
INSERT INTO fue_vpl VALUES ("C112_28","076_12_28","1CO","12","28","28","Hande nun Alla resiri himɓe der eklesiya mum. Aran, lilaaɓe, ɗiɗawre annabiiɓe, tatawre janŋinooɓe, ɓaawo majjum waɗooɓe haaynaareeji, e nyawtooɓe nyawɓe, e faabotooɓe, e ardiiɓe, e batooɓe ɗelle Ruuhu. ");
INSERT INTO fue_vpl VALUES ("C112_29","076_12_29","1CO","12","29","29","Himɓe ɓen fu laati nun lilaaɓe na? Naa ɓe fu ɓee annabiiɓe nun? Naa ɓe fu ɓee janŋinooɓe nun? Himɓe fu nun waɗata haaynaareeji na? ");
INSERT INTO fue_vpl VALUES ("C112_30","076_12_30","1CO","12","30","30","Himɓe fu bane hokkaa baawɗe nyawtugo nyawɓe, ɓe fu bane hokkaa baawɗe batugo e ɗelle Ruuhu, ɓe fu bane bo hokkaa baawɗe nantingo ɗelle ɗen. ");
INSERT INTO fue_vpl VALUES ("C112_31","076_12_31","1CO","12","31","31","To non, tinnee daartee dokke ɓuruɗe nafugo. Jooni mi hollan on laawol ɓurŋol wooɗugo. ");
INSERT INTO fue_vpl VALUES ("C113_1","076_13_1","1CO","13","1","1","Baa to mii waawi batugo ɗelle himɓe e ɗelle malaykaaɓe fu, to mi walaa yidde, mi laati nun hande lenŋuru piyeteenu, ɗum bo hande rimmo baggu. ");
INSERT INTO fue_vpl VALUES ("C113_2","076_13_2","1CO","13","2","2","To Alla hokkii am dokkal waɗugo annabaaku, to mi heɓii annal dow siiriiji e dow huune fu, ɗum bo to mii woodi goonɗinki faa mi sottina baalle, amma mi woodaa yidde, mi laataaki goɗɗum. ");
INSERT INTO fue_vpl VALUES ("C113_3","076_13_3","1CO","13","3","3","Baa to mi hokkii jawdi am fu talakaaɓe, mi sakka ɓannu am bo wuuɗee yiite, to mi woodaa yidde, ɗum nafataa am. ");
INSERT INTO fue_vpl VALUES ("C113_4","076_13_4","1CO","13","4","4","Gooduɗo yidde e woodi munyal, nee hebbi neɗɗaaku. Yidde walaa nawniraagu, ne jurataako, ne woodaa manŋu hoore. ");
INSERT INTO fue_vpl VALUES ("C113_5","076_13_5","1CO","13","5","5","Gooduɗo yidde waɗataa ko sentinii, o dartataa ko nafata mo tan, o monnortaako goɗɗo, o jogataako hallande. ");
INSERT INTO fue_vpl VALUES ("C113_6","076_13_6","1CO","13","6","6","Gooduɗo yidde seyortaako ko halli, amma e seyoroo gooŋa. ");
INSERT INTO fue_vpl VALUES ("C113_7","076_13_7","1CO","13","7","7","Oo yaafoo huune fu, oo hoolo huune fu, oo heɗoo Alla der ko waroyta, oo munyana huune fu. ");
INSERT INTO fue_vpl VALUES ("C113_8","076_13_8","1CO","13","8","8","Yidde heennyataa faa abada. Annabaaku heennyan, batugo e ɗelle feere feereeje heennyan, annal bo heennyan. ");
INSERT INTO fue_vpl VALUES ("C113_9","076_13_9","1CO","13","9","9","Annal meeɗen laaɓidaa, annabaaku meeɗen bo laaɓidaa. ");
INSERT INTO fue_vpl VALUES ("C113_10","076_13_10","1CO","13","10","10","Amma to huune fu laaɓinaama, ko laaɓaa fu majjitan. ");
INSERT INTO fue_vpl VALUES ("C113_11","076_13_11","1CO","13","11","11","No laatinoomi suka, mi batii hande suka, mi miijono hande suka, jiiɗe am bo hande jiiɗe suka. Amma no mawnumi, mi accii golle sukaaku. ");
INSERT INTO fue_vpl VALUES ("C113_12","076_13_12","1CO","13","12","12","Jooni en ji'ataa taw huune fu e laaɓal, ɗum nandi hande daanorgal niɓɓuŋal nun daanortoɗen. Amma wakkati waraan, en ji'an e gite meeɗen deydey. Jooni taw annal am laaɓay, amma wakkati waraan de annanmi faa laaɓa, hande no Alla annirimmi. ");
INSERT INTO fue_vpl VALUES ("C113_13","076_13_13","1CO","13","13","13","Den, huune tati woni ko tabitii, goonɗingo, e heɗaago moƴƴere Alla, e yidde. Amma yidde ɓuri ɗum ɗum fu mawnugo. ");
INSERT INTO fue_vpl VALUES ("C114_1","076_14_1","1CO","14","1","1","To non, daartee yidde. Daartee bo dokke Ruuhu Ceniiɗo, hakko du dokkal annabaaku. ");
INSERT INTO fue_vpl VALUES ("C114_2","076_14_2","1CO","14","2","2","Batoowo e ɗelle Ruuhu, Alla nun joomum baddata, himɓe bane. Gam goɗɗo faamataa ka o batata, Ruuhu nun hokkata mo haalaaji Alla cuuɗiiɗi. ");
INSERT INTO fue_vpl VALUES ("C114_3","076_14_3","1CO","14","3","3","Amma gaɗoowo annabaaku wallan nun woɓɓe mawnugo der goonɗinki, e tiiɗina ɓe, e hokka ɓe semme. ");
INSERT INTO fue_vpl VALUES ("C114_4","076_14_4","1CO","14","4","4","Batoowo e ɗelle Ruuhu, semmiɗinan nun goonɗinki mum, gaɗoowo annabaaku bo e walla eklesiya yahugo yeeso. ");
INSERT INTO fue_vpl VALUES ("C114_5","076_14_5","1CO","14","5","5","Mii yiɗi on fu baton e ɗelle Ruuhu, amma ko ɓurumi yiɗugo woni, gaɗon annabaaku. Gaɗoowo annabaaku e ɓuri batoowo e ɗelle Ruuhu, gam batoowo e ɗelle Ruuhu mawnintaa eklesiya to jottinoowo ɗe walaa. ");
INSERT INTO fue_vpl VALUES ("C114_6","076_14_6","1CO","14","6","6","Banniraaɓe, hande jon bi'en, mi wara to mooɗon, mi yanta baddirgo on e ɗelle Ruuhu tan, laatoo mi janŋinay on ko Alla hollitimmi, mi waddanay on bo annal kesal, mi ekkitinay on bo, ume nafanmi on? ");
INSERT INTO fue_vpl VALUES ("C114_7","076_14_7","1CO","14","7","7","Daaree ji'en, baa huune jimirɗum, hande jon fuuraanu ɗum bo moolooru. To puuroowo fuuraanu, ɗum bo piyoowo moolooru fiyay hande no haaniri, moy tintotoo ko fuuretee ɗum bo ko fiyetee? ");
INSERT INTO fue_vpl VALUES ("C114_8","076_14_8","1CO","14","8","8","Naa moy siriyanto konu to puuroowo walaldu konu fuuray hande no haani? ");
INSERT INTO fue_vpl VALUES ("C114_9","076_14_9","1CO","14","9","9","Hande non onon bo, to haala mooɗon laaɓay, moy faamata ko jiɗɗon wi'ugo? On boppii haala mooɗon! ");
INSERT INTO fue_vpl VALUES ("C114_10","076_14_10","1CO","14","10","10","Ɗelle ɗuuɗɗe nun woni der duuniyaaru nu, ɗe fu, ɗee goodi ko ɗe bi'ata. ");
INSERT INTO fue_vpl VALUES ("C114_11","076_14_11","1CO","14","11","11","Amma to goɗɗo baddii am e ɗenŋal ŋal mi nanataa, mi laatake janano makko, kanko bo o laatake janano am. ");
INSERT INTO fue_vpl VALUES ("C114_12","076_14_12","1CO","14","12","12","Hande non, onon bo, no oon tinnii daartugo dokke Ruuhu, daartee aran dokke puy, jaarooje eklesiya yeeso. ");
INSERT INTO fue_vpl VALUES ("C114_13","076_14_13","1CO","14","13","13","Gam majjum, batoowo e ɗelle Ruuhu fu, eela Alla walla ɗum nantingo ɗe. ");
INSERT INTO fue_vpl VALUES ("C114_14","076_14_14","1CO","14","14","14","Gam to mii du'oo e ɗenŋal Ruuhu, ruuhu am e du'oo, amma hakkillo am gollataako. ");
INSERT INTO fue_vpl VALUES ("C114_15","076_14_15","1CO","14","15","15","Den, noy gaɗanmi? Mi du'oto e ruuhu am, mi du'oto bo e hakkillo am. Mi yiman e ruuhu am, mi yiman bo e hakkillo am. ");
INSERT INTO fue_vpl VALUES ("C114_16","076_14_16","1CO","14","16","16","To hinaa nun, to aa yetta Alla e ruuhu, noy tawaaɗo caka hettiniiɓe, mo annaa ɗum, waawirta ko wi'i «aami» to a yettidii? Gam joomum nanataa ko batataa. ");
INSERT INTO fue_vpl VALUES ("C114_17","076_14_17","1CO","14","17","17","Baa to yettoore maa e wooɗi hande noy, ɗum mawnintaa goonɗinki joomum. ");
INSERT INTO fue_vpl VALUES ("C114_18","076_14_18","1CO","14","18","18","Mii yetta Alla gam mii ɓuri on, on fu batugo e ɗelle Ruuhu. ");
INSERT INTO fue_vpl VALUES ("C114_19","076_14_19","1CO","14","19","19","Amma der eklesiya, mii ɓuri yiɗugo mi bata haalaaji joy paameteeɗi gam ekkitingo woɓɓe, ɓuri batugo haalaaji ujune sappo e ɗelle Ruuhu ɗe faamataake. ");
INSERT INTO fue_vpl VALUES ("C114_20","076_14_20","1CO","14","20","20","Banniraaɓe, to on laatee hande sukaaɓe der hakkillo mooɗon. Amma dow hallande laatee hande sukaaɓe, dow suttontirgo huune, laatee ɓe hakkillooji mum ɓenni hande mawɓe. ");
INSERT INTO fue_vpl VALUES ("C114_21","076_14_21","1CO","14","21","21","E winnaa der tawreeta: Joomiraawo wi'i: «Himɓe ɓee, e ɗelle Ruuhu, e kunnuɗe hoɓɓe nun baajortoomi ɓe. Amma e nun fu, ɓe kettinantaako am.» ");
INSERT INTO fue_vpl VALUES ("C114_22","076_14_22","1CO","14","22","22","Hande non, batugo e ɗelle Ruuhu laati nun maane kiita dow ɓe goonɗinay. Waɗugo annabaaku laati nun gam goonɗinɓe, hinaa gam ɓe goonɗinay. ");
INSERT INTO fue_vpl VALUES ("C114_23","076_14_23","1CO","14","23","23","Hande jon, to himɓe eklesiya fu hawritii, den moy maɓɓe fu e bata ɗelle Ruuhu feere feere, to himɓe ɓe janŋinaaka, ɗum bo ɓe goonɗinay warii yi'ii ɗum, ɓe bi'ataa ko'e mon sottake na? ");
INSERT INTO fue_vpl VALUES ("C114_24","076_14_24","1CO","14","24","24","Naa bo, hande jon, mo goonɗinay, ɗum bo mo annaa ɗum, naati der juulirde mooɗon, go o tawi himɓe fu e waɗa annabaaku, ka o nanata hiitoto mo, o faama no oo woodi hakke. ");
INSERT INTO fue_vpl VALUES ("C114_25","076_14_25","1CO","14","25","25","Miilooji ɓerne makko cuuɗiiɗi wurtinte, den o jiccoo, o sujidana Alla, o wi'a: «E gooŋa, Alla e wondi e mooɗon.» ");
INSERT INTO fue_vpl VALUES ("C114_26","076_14_26","1CO","14","26","26","Banniraaɓe, noy haani gaɗen? To on kawritii, go oo ɗo e woodi jimol, oo to e woodi janŋinol, goɗɗo bo e woodi kollitol gom, goɗɗo bo e bata e ɗelle Ruuhu, goɗɗo bo e nantina ɗe, sey huune fu waɗee gam goonɗinɓe mawna. ");
INSERT INTO fue_vpl VALUES ("C114_27","076_14_27","1CO","14","27","27","To ɗelle Ruuhu nun batete, sey himɓe ɗiɗo bata, to ɗum ɓuru tato, moy fu e wakkati mum. Goɗɗo mooɗon nantina ɗe. ");
INSERT INTO fue_vpl VALUES ("C114_28","076_14_28","1CO","14","28","28","Amma to nantinoowo walaa, gooduɗo dokkal batugo e ɗelle Ruuhu jeeɗoo der eklesiya, bata der ɓerne mum, badda e Alla. ");
INSERT INTO fue_vpl VALUES ("C114_29","076_14_29","1CO","14","29","29","Dow waɗooɓe annabaaku, ɗiɗo ɗum bo tato etta haala, horiiɓe wiɗitoo haala maɓɓe. ");
INSERT INTO fue_vpl VALUES ("C114_30","076_14_30","1CO","14","30","30","To goɗɗo der jooɗiiɓe e woodi ka Alla holli ɗum bata, sey aranneejo batoowo jeeɗoo. ");
INSERT INTO fue_vpl VALUES ("C114_31","076_14_31","1CO","14","31","31","Hande nun, on baawan ko waɗi annabaaku gooto gooto, gam moy mooɗon fu ekkitoo, semmiɗina goonɗinki mum. ");
INSERT INTO fue_vpl VALUES ("C114_32","076_14_32","1CO","14","32","32","Waɗooɓe annabaaku sey waawa ko jogii ko'e mum, ");
INSERT INTO fue_vpl VALUES ("C114_33","076_14_33","1CO","14","33","33","gam Alla laataaki Alla mo jiɓayeere, amma Alla mo jam. Hande no ɗum laatii toy fu der eklesiyaaji Alla, ");
INSERT INTO fue_vpl VALUES ("C114_34","076_14_34","1CO","14","34","34","sey rewɓe jeeɗoo der eklesiya, ɓe kokkaaka laawol ɓe bata. Sey ɓe baawa jogaago ko'e maɓɓe ɓee ɗowtii hande no winniraa der tawreeta. ");
INSERT INTO fue_vpl VALUES ("C114_35","076_14_35","1CO","14","35","35","To woodi ko ɓe jiɗi faamineego, ɓe acca faa to ɓe kooti wuro, ɓe ƴama worɓe maɓɓe. Gam to debbo batii haala der eklesiya, ɗum centiniiɗum. ");
INSERT INTO fue_vpl VALUES ("C114_36","076_14_36","1CO","14","36","36","Naa oon miili to mooɗon nun haala Alla ƴiwi? Onon tan heɓi ka na? ");
INSERT INTO fue_vpl VALUES ("C114_37","076_14_37","1CO","14","37","37","To goɗɗo e miili e laati annabiijo, ɗum bo e miili heɓii Ruuhu Ceniiɗo, e haani joomum annita ko binnanmi on laati nun umuroore Joomiraawo. ");
INSERT INTO fue_vpl VALUES ("C114_38","076_14_38","1CO","14","38","38","To goɗɗo salake ko jaɓi haala ka, eɗum hollita no kanko e hoore makko Alla jaɓay mo. ");
INSERT INTO fue_vpl VALUES ("C114_39","076_14_39","1CO","14","39","39","Gam majjum, banniraaɓe, tinnee daartee dokke annabaaku. To on calee bo himɓe bata e ɗelle Ruuhu, ");
INSERT INTO fue_vpl VALUES ("C114_40","076_14_40","1CO","14","40","40","amma kakkilee, huune fu waɗoo e hakkillo, e no haaniri. ");
INSERT INTO fue_vpl VALUES ("C115_1","076_15_1","1CO","15","1","1","Banniraaɓe, mii yiɗi siwtorgo on linjiila ka baajiimi on, jaɓuɗon ko oon darii dow makka e semme. ");
INSERT INTO fue_vpl VALUES ("C115_2","076_15_2","1CO","15","2","2","Diga e makka kisinteɗon to oon jogii ka hande no baajoriimi on. To hinaa non, goonɗinki mooɗon laatoto baanji. ");
INSERT INTO fue_vpl VALUES ("C115_3","076_15_3","1CO","15","3","3","Aran, mi yottinii on ko keɓumi min e hoore am, kanjum woni. Almasiihu maayii gam hakkeeji meeɗen, hande no Dewtere wi'i. ");
INSERT INTO fue_vpl VALUES ("C115_4","076_15_4","1CO","15","4","4","O uwaama, o fintii nyalaane tatawre, hande no Dewtere batiri. ");
INSERT INTO fue_vpl VALUES ("C115_5","076_15_5","1CO","15","5","5","O hollitanake Piyer, ɓaawo majjum o hollitanii aahiiɓe sappo e ɗiɗo. ");
INSERT INTO fue_vpl VALUES ("C115_6","076_15_6","1CO","15","6","6","Ɓaawo majjum o hollitanii banniraaɓe ko ɓuri keme joyo de woore. Ɗuuɓɓe maɓɓe e wuuri faa jooni, amma woɓɓe mum maayi. ");
INSERT INTO fue_vpl VALUES ("C115_7","076_15_7","1CO","15","7","7","Ɓaawo majjum, o hollitanake Yaakuuba, den go o hollitanii lilaaɓe fu. ");
INSERT INTO fue_vpl VALUES ("C115_8","076_15_8","1CO","15","8","8","Faa sakitiineere, o hollitanii am, min nanduɗo hande sukeel dimaaŋel lebbi mum hebbay. ");
INSERT INTO fue_vpl VALUES ("C115_9","076_15_9","1CO","15","9","9","Gam min ɓuri lilaaɓe fu faanɗugo, mi fotay du noddeego lilaaɗo, gam mi tooriino eklesiya Alla. ");
INSERT INTO fue_vpl VALUES ("C115_10","076_15_10","1CO","15","10","10","Gam moƴƴere Alla laatoriimi ko laatiimi. Moƴƴere ne o waɗanimmi bo laataaki baanji, gam mi gollake ko ɓuri lilaaɓe fu. Min bane waɗata ɗum, amma moƴƴere Alla wonne der am waɗata ɗum. ");
INSERT INTO fue_vpl VALUES ("C115_11","076_15_11","1CO","15","11","11","To non, min nun, kamɓe nun, haala goota kan men piinata, kanka nun bo goonɗinɗon. ");
INSERT INTO fue_vpl VALUES ("C115_12","076_15_12","1CO","15","12","12","To emen baajoo no Almasiihu fintii e maayde, den noy woɓɓe mooɗon wi'irta maayɓe fintataa? ");
INSERT INTO fue_vpl VALUES ("C115_13","076_15_13","1CO","15","13","13","To pintol maayɓe walaa, Almasiihu e hoore mum bo fintay, ");
INSERT INTO fue_vpl VALUES ("C115_14","076_15_14","1CO","15","14","14","to Almasiihu fintay bo, waaji amen laatake baanji, goonɗinki mooɗon bo laatake baanji. ");
INSERT INTO fue_vpl VALUES ("C115_15","076_15_15","1CO","15","15","15","Ko ɓuri fu, to e gooŋa maayɓe fintataa, minon bo men laatake seedaniiɓe Alla fewre, gam emen ceedoo o fintinii Almasiihu, nani bo gooŋa bane, to maayɓe fintataa. ");
INSERT INTO fue_vpl VALUES ("C115_16","076_15_16","1CO","15","16","16","Gam to maayɓe fintataa, Almasiihu e hoore mum fintay. ");
INSERT INTO fue_vpl VALUES ("C115_17","076_15_17","1CO","15","17","17","To Almasiihu fintay, goonɗinki mooɗon laatake baanji, der hakkeeji mooɗon bo gonuɗon faa jooni, ");
INSERT INTO fue_vpl VALUES ("C115_18","076_15_18","1CO","15","18","18","maayunooɓe e goonɗinki Yeesu bo halkii. ");
INSERT INTO fue_vpl VALUES ("C115_19","076_15_19","1CO","15","19","19","To der duuniyaaru ɗo tan miiluɗen heɓugo riiba gonuka der kawtal men e Almasiihu, enen ɓurannoo himɓe fu yurminaago. ");
INSERT INTO fue_vpl VALUES ("C115_20","076_15_20","1CO","15","20","20","Amma e gooŋa, Almasiihu fintii, o laatake arano der maayɓe fintooɓe. ");
INSERT INTO fue_vpl VALUES ("C115_21","076_15_21","1CO","15","21","21","Hande no maayde naatiri der duuniyaaru diga neɗɗo, hande non bo pintol wariri diga e neɗɗo. ");
INSERT INTO fue_vpl VALUES ("C115_22","076_15_22","1CO","15","22","22","Hande no himɓe fu maayirta gam kawtal mum e Aadamu, hande non himɓe heɓirta yonki gam kawtal mum e Almasiihu. ");
INSERT INTO fue_vpl VALUES ("C115_23","076_15_23","1CO","15","23","23","Moy fu fintan e wakkati mum. Almasiihu laatii arano, ɓaawo mum, goonɗinɓe mo tokkina der nyalaane garki makko. ");
INSERT INTO fue_vpl VALUES ("C115_24","076_15_24","1CO","15","24","24","Ɓaawo majjum, timmoode duuniyaaru waran. Almasiihu halkan hooreeɓe e wooduɓe baawɗe e semmeeji kalluɗi fu, den o hokka Alla Baaba meeɗen laamaare. ");
INSERT INTO fue_vpl VALUES ("C115_25","076_15_25","1CO","15","25","25","Gam doole Almasiihu laamoo faa to Alla wattii wayɓe makko ley teppe makko. ");
INSERT INTO fue_vpl VALUES ("C115_26","076_15_26","1CO","15","26","26","Ganyo cakitorteeɗo halkeego woni maayde. ");
INSERT INTO fue_vpl VALUES ("C115_27","076_15_27","1CO","15","27","27","E winnaa: «Alla wattii huune fu ley koyɗe makko». Amma to wi'aama, «huune fu» Alla gattuɗo huune fu ley koyɗe makko bane wondaa. ");
INSERT INTO fue_vpl VALUES ("C115_28","076_15_28","1CO","15","28","28","To Almasiihu laatake hooreejo dow huune fu, kanko Ɓiɗɗo bo, o hokkan Alla hoore makko, den Alla laamoo dow huune fu, e dow moy fu. ");
INSERT INTO fue_vpl VALUES ("C115_29","076_15_29","1CO","15","29","29","To non, riiba kaye waɗeteeɓe batisi faa maayira woodi to maayɓe fintataa? Ume waɗi ko himɓe e waɗee batisi faa maayira? ");
INSERT INTO fue_vpl VALUES ("C115_30","076_15_30","1CO","15","30","30","Enen e ko'e meeɗen bo, gam ume potteten wakkati fu kaliije maayde? ");
INSERT INTO fue_vpl VALUES ("C115_31","076_15_31","1CO","15","31","31","Banniraaɓe, nyalaane fu der hunnuko maayde nun gonumi. Amma e nun fu mii juroro on gam daliila kawtal mooɗon e Joomiraawo meeɗen Yeesu Almasiihu. ");
INSERT INTO fue_vpl VALUES ("C115_32","076_15_32","1CO","15","32","32","To e miilooji heɓugo goɗɗum der duuniyaaru ɗo nun gaɗirmi duuro der wanŋarde Efesu, kaɓumi e bisaaji ladde kalluɗi, ume ɗum nafatammi to maayɓe fintataa? Ɗum laatotono hande no ballool ŋol ɗo wi'i: «Nyaamen jaren, gam jaaŋo en maayan.» ");
INSERT INTO fue_vpl VALUES ("C115_33","076_15_33","1CO","15","33","33","To on jammee ko'e mooɗon: «Yaadugo e kalluɗo biisan jikku booɗuŋu.» ");
INSERT INTO fue_vpl VALUES ("C115_34","076_15_34","1CO","15","34","34","Pukkinee hakkillooji mooɗon hande no haani, to on gaɗee hakke. Mi batii ka gam centon, gam woɓɓe mooɗon annaa Alla. ");
INSERT INTO fue_vpl VALUES ("C115_35","076_15_35","1CO","15","35","35","Amma, waɗoto goɗɗo ƴama: «Noy maayɓe fintirta? Ɓannu iri ŋole ɓe bittiroyta?» ");
INSERT INTO fue_vpl VALUES ("C115_36","076_15_36","1CO","15","36","36","Onon ɓe galaa hakkillo! To a aawi awdi, doole ni waata go ni fuɗa. ");
INSERT INTO fue_vpl VALUES ("C115_37","076_15_37","1CO","15","37","37","Awdi ni aawuɗaa fu, to gawri nun, ɗum bo awdi feereeri gom nun, gitel tan aawataa, puɗol e haako mum bane. ");
INSERT INTO fue_vpl VALUES ("C115_38","076_15_38","1CO","15","38","38","Ɓaawo mum, Alla nun hokkata awdi fu iri puɗol mum no o yiɗiri, awdi fu bo e puɗol muuɗum nun. ");
INSERT INTO fue_vpl VALUES ("C115_39","076_15_39","1CO","15","39","39","Kujje yonkinteeje fu bane woodi ɓannu gootol. Himɓe e woodi ɓannu mum, bisaaji e ɓannu mum, pooli e ɓannu mum, liƴƴi bo e ɓannu mum. ");
INSERT INTO fue_vpl VALUES ("C115_40","076_15_40","1CO","15","40","40","E woodi ɓannu ŋol dow kammu, e ɓannu ŋol leydi. Ɓannu ŋol dow e ŋari mum, ŋol leydi bo e ŋari mum. ");
INSERT INTO fue_vpl VALUES ("C115_41","076_15_41","1CO","15","41","41","Naaŋe e jayŋol mum, lewru e jayŋol mum, koode bo e jayŋol mum, baa koode ɗen jayŋol mum e suttontiri. ");
INSERT INTO fue_vpl VALUES ("C115_42","076_15_42","1CO","15","42","42","Hande non, pintol maayɓe bo laatii. To ɓannu uwaama, ŋol nyola, to ŋol fintinaama, ŋol nyolataa. ");
INSERT INTO fue_vpl VALUES ("C115_43","076_15_43","1CO","15","43","43","To ŋol uwaama ŋol woodaa tedduŋal, ŋol fintinee, eŋol woodi tedduŋal. To ŋol uwaama, ŋol tampuŋol, ŋol fintinee eŋol woodi semme. ");
INSERT INTO fue_vpl VALUES ("C115_44","076_15_44","1CO","15","44","44","To ŋol uwaama ɓannu leydinkewol, ŋol fintinee eŋol laatii ɓannu ruuhunkewol. To ɓannu leydinkewol na'on, ɓannu ruuhunkewol bo na'on. ");
INSERT INTO fue_vpl VALUES ("C115_45","076_15_45","1CO","15","45","45","E winnaa: «Aadamu neɗɗo aranneejo laatake yonkinteejo». Aadamu cakitiiɗo laatake Ruuhu kokkoowo yonki. ");
INSERT INTO fue_vpl VALUES ("C115_46","076_15_46","1CO","15","46","46","Ruuhunkejum bane ardii, ɗum ɓannu nun ardii. Ɓaawo mum ko ɗum Ruuhu tokkii. ");
INSERT INTO fue_vpl VALUES ("C115_47","076_15_47","1CO","15","47","47","Aadamu neɗɗo arandeejo e sollaare leydi nun tagiraa, e leydi o ƴiwi, neɗɗo ɗiɗaɓo bo, dow kammu ƴiwi. ");
INSERT INTO fue_vpl VALUES ("C115_48","076_15_48","1CO","15","48","48","No tagiraaɗo e sollaare leydi wa'i, hande non wooduɓe ɓannu leydinkewol bo wa'i. No ƴiwuɗo dow kammu wa'i, hande non ɓe dow kammu bo waɗoyta. ");
INSERT INTO fue_vpl VALUES ("C115_49","076_15_49","1CO","15","49","49","Hande no nandirɗen e neɗɗo tagiraaɗo sollaare leydi, hande non bo nandiroyten e neɗɗo ƴiwuɗo dow kammu. ");
INSERT INTO fue_vpl VALUES ("C115_50","076_15_50","1CO","15","50","50","Banniraaɓe, ko jiɗum wi'ugo on nani: Ɓannu e ƴiiƴam waawataa ko roni Laamaare Alla, kade bo, nyoloojum waawataa ko roni ko nyolataa. ");
INSERT INTO fue_vpl VALUES ("C115_51","076_15_51","1CO","15","51","51","Nani mi hollan on asiiri gom: en fu bane maayata, amma en fu en baylitinte, ");
INSERT INTO fue_vpl VALUES ("C115_52","076_15_52","1CO","15","52","52","der wakkati gooti, der maƴƴande itere, to rimmo walaldu sakitiinewol nanaama. To ŋol fuuraama, maayɓe artan finta e ɓannu ŋol nyolataa, enen horiiɓe en baylitinte. ");
INSERT INTO fue_vpl VALUES ("C115_53","076_15_53","1CO","15","53","53","Den fu, ɓannu nyoloowol ɓornoto ko nyolataa, ɓannu maayoowol bo ɓornoo ko maayataa. ");
INSERT INTO fue_vpl VALUES ("C115_54","076_15_54","1CO","15","54","54","To ɓannu nyoloowol ɓorninaama ko nyolataa, maayoowol bo ɓoorninaama ko maayataa, den haala annabaaku binnaaka ka hebban: «Maayde jaalaama, moɗaa. ");
INSERT INTO fue_vpl VALUES ("C115_55","076_15_55","1CO","15","55","55","Maayde, toy jaalorgal maa woni? Maayde, toy tooke maa woni?» ");
INSERT INTO fue_vpl VALUES ("C115_56","076_15_56","1CO","15","56","56","Hakke woni tooke maayde, baawɗe hakke bo woni tawreeta. ");
INSERT INTO fue_vpl VALUES ("C115_57","076_15_57","1CO","15","57","57","Yettoore laatanoo Alla kokkoowo en jaalaago diga e Joomiraawo meeɗen Yeesu Almasiihu. ");
INSERT INTO fue_vpl VALUES ("C115_58","076_15_58","1CO","15","58","58","Gam majjum banniraaɓe am yiɗaaɓe, laatee tabitiiɓe, ɓe dimmataako. Wakkati fu kiinnee golle Joomiraawo, gam oon anni ko gaɗuɗon sabbu kawtal mooɗon e Joomiraawo yanataa baanji. ");
INSERT INTO fue_vpl VALUES ("C116_1","076_16_1","1CO","16","1","1","Jooni, wallirgo goonɗinɓe wonɓe Urusaliima e ceede nun batananmi. Onon bo gaɗee hande no batumi eklesiyaaji leydi Galaatiya. ");
INSERT INTO fue_vpl VALUES ("C116_2","076_16_2","1CO","16","2","2","Alal fu, moy mooɗon fu resa wecco dow ko o heɓi. To on keɗee mi wara go kawriton ɗe. ");
INSERT INTO fue_vpl VALUES ("C116_3","076_16_3","1CO","16","3","3","To mi warii, mi lilan ɓe cuɓoton ɓe jaara ballal mooɗon faa Urusaliima, e ɗereeji paaminooji haala ballal mooɗon. ");
INSERT INTO fue_vpl VALUES ("C116_4","076_16_4","1CO","16","4","4","To fotii mi yaha min e hoore am, ɓe jaadan e am. ");
INSERT INTO fue_vpl VALUES ("C116_5","076_16_5","1CO","16","5","5","Mi waran to mooɗon, amma mi ƴiwiran e leydi Maseduwaan, gam ton tokkiranmi. ");
INSERT INTO fue_vpl VALUES ("C116_6","076_16_6","1CO","16","6","6","Waɗoto to mi warii mi jooɗoo to mooɗon balɗe seɗɗa, ɗum bo mi dabba ton. Den ballon am der jahaaŋal am mi yahira to jahanmi fu. ");
INSERT INTO fue_vpl VALUES ("C116_7","076_16_7","1CO","16","7","7","Gam e laawol ŋol ɗo, mi yiɗaa yaalugo on to mii yawta, to Joomiraawo e yiɗi mi jooɗoto to mooɗon balɗe seɗɗa. ");
INSERT INTO fue_vpl VALUES ("C116_8","076_16_8","1CO","16","8","8","Amma mi jooɗoto taw Efesu faa juulɗe Pantekosta yottoo, ");
INSERT INTO fue_vpl VALUES ("C116_9","076_16_9","1CO","16","9","9","gam laawol manŋol maɓɓitanake am mi waɗa golle am, baa no wayɓe bo e ɗuuɗi. ");
INSERT INTO fue_vpl VALUES ("C116_10","076_16_10","1CO","16","10","10","To Timote warii to mooɗon, jaɓɓee mo, jogoɗon mo faa wooɗa, gam golle Joomiraawo nun o waɗata hande am. ");
INSERT INTO fue_vpl VALUES ("C116_11","076_16_11","1CO","16","11","11","Gam majjum, to goɗɗo yawoo mo. Ballitee mo dow jahaaŋal makko. O yaha e jam, o warta to amen. Min e banniraaɓe emen keɗii mo. ");
INSERT INTO fue_vpl VALUES ("C116_12","076_16_12","1CO","16","12","12","Banniraawo meeɗen Apollos, mi tiiɗinii ɗum de ɗuuɗɗum o yaada e banniraaɓe to mooɗon, amma faa hanne o nootaaki. Amma o waran to o heɓori. ");
INSERT INTO fue_vpl VALUES ("C116_13","076_16_13","1CO","16","13","13","Kakkilee, daree e semme der goonɗinki, kollitee cuusal mon, goodee semme. ");
INSERT INTO fue_vpl VALUES ("C116_14","076_16_14","1CO","16","14","14","Ko gaɗoton fu, gaɗiree ɗum e yidde. ");
INSERT INTO fue_vpl VALUES ("C116_15","076_16_15","1CO","16","15","15","Banniraaɓe, ko eelanmi on woni, oon anni Estefanas e himɓe wuro mum, kamɓe nun arti goonɗini der leydi Akaya fu. Ɓe tinnake gollanaago himɓe Alla. ");
INSERT INTO fue_vpl VALUES ("C116_16","076_16_16","1CO","16","16","16","Ɗowtanee himɓe iri maɓɓe, tinniiɓe e gollodoo e maɓɓe. ");
INSERT INTO fue_vpl VALUES ("C116_17","076_16_17","1CO","16","17","17","Ɓerne am weli e garki Estefanas e Fortunatus kan e Akaykus. Ɓe gaɗanii am ko on baaway ko waɗanimmi gam oon boɗɗi. ");
INSERT INTO fue_vpl VALUES ("C116_18","076_16_18","1CO","16","18","18","Ɓe pukkinii ɓerne am e ɓerɗe mooɗon. Gam majjum teddinee himɓe hande maɓɓe. ");
INSERT INTO fue_vpl VALUES ("C116_19","076_16_19","1CO","16","19","19","Himɓe eklesiyaaji leydi Asiya fu sannii on. Akilas e Pirisikiila, e goonɗinɓe Yeesu hawritintooɓe der wuro maɓɓe fu e sanna on sanne e inne Joomiraawo. ");
INSERT INTO fue_vpl VALUES ("C116_20","076_16_20","1CO","16","20","20","Banniraaɓe fu e sanna on. Moy mooɗon fu sanna banniraawo mum e yidde mawne. ");
INSERT INTO fue_vpl VALUES ("C116_21","076_16_21","1CO","16","21","21","Min Pol mi sannii on e binni junŋo am. ");
INSERT INTO fue_vpl VALUES ("C116_22","076_16_22","1CO","16","22","22","Neɗɗo fu mo yiɗaa Joomiraawo, o naalaaɗo! Maranata, yaa Joomiraawo Yeesu, war! ");
INSERT INTO fue_vpl VALUES ("C116_23","076_16_23","1CO","16","23","23","Moƴƴere Joomiraawo meeɗen Yeesu wonda e mooɗon! ");
INSERT INTO fue_vpl VALUES ("C116_24","076_16_24","1CO","16","24","24","Mii yiɗi on on fu, gam kawtal meeɗen e Yeesu Almasiihu. ");
INSERT INTO fue_vpl VALUES ("GL1_1","078_1_1","GAL","1","1","1","Ɗerewol ŋol ɗo ƴiwii e am, min Pol, lilaaɗo. Himɓe bane lilimmi. Lilal am ƴiway diga e neɗɗo. Amma Yeesu Almasiihu e Alla Baaba pintinɗo mo diga maayde nun lilimmi. ");
INSERT INTO fue_vpl VALUES ("GL1_2","078_1_2","GAL","1","2","2","Min e banniraaɓe wonduɓe e am fu, emen binnana on ɗerewol ŋol, onon himɓe eklesiyaaji leydi Galaatiya. ");
INSERT INTO fue_vpl VALUES ("GL1_3","078_1_3","GAL","1","3","3","Baaba meeɗen Alla, e Joomiraawo meeɗen Yeesu Almasiihu, waɗana on moƴƴere, hokka on jam. ");
INSERT INTO fue_vpl VALUES ("GL1_4","078_1_4","GAL","1","4","4","Almasiihu hokkii hoore mum gam hakkeeji meeɗen. O wurtinii en diga e jamaanuuru hallunu nu. Hande non Alla Baaba meeɗen yiɗiri. ");
INSERT INTO fue_vpl VALUES ("GL1_5","078_1_5","GAL","1","5","5","Tedduŋal laatanoo mo faa abada. Aami. ");
INSERT INTO fue_vpl VALUES ("GL1_6","078_1_6","GAL","1","6","6","Ɗum haaynake am no baylitoriɗon law, tokkuɗon linjiila gokka, accuɗon Alla, nodduɗo on e moƴƴere Almasiihu. ");
INSERT INTO fue_vpl VALUES ("GL1_7","078_1_7","GAL","1","7","7","Linjiila gokka walaa. Amma himɓe nun laawata on e yiɗi waylitingo linjiila Almasiihu. ");
INSERT INTO fue_vpl VALUES ("GL1_8","078_1_8","GAL","1","8","8","To goɗɗo waajike on linjiila feereha ka yaaday e ka men baajii on, baa to menen nun, ɗum bo malaykaajo ƴiwuɗo dow kammu nun, naaloore Alla wonoo dow joomum. ");
INSERT INTO fue_vpl VALUES ("GL1_9","078_1_9","GAL","1","9","9","Men batiino on ka, jooni bo mii batitoo on ka: To goɗɗo waajike on linjiila feereha, cuttontirka e ka men baajii on, naaloore Alla wonoo dow joomum. ");
INSERT INTO fue_vpl VALUES ("GL1_10","078_1_10","GAL","1","10","10","Den kan, fottango himɓe nun daartanmi, naa fottango Alla? Mi daartan nun mi fottana himɓe na? To mii daartanno fottango himɓe, mi laatataakono maccuɗo Almasiihu. ");
INSERT INTO fue_vpl VALUES ("GL1_11","078_1_11","GAL","1","11","11","Banniraaɓe, mii yiɗi paamon no linjiila ka baajotoomi ƴiway e neɗɗo. ");
INSERT INTO fue_vpl VALUES ("GL1_12","078_1_12","GAL","1","12","12","Neɗɗo bane hokkimmi ka, neɗɗo bane janŋinimmi ka bo, amma Yeesu Almasiihu hollitanii am, hokkimmi ka. ");
INSERT INTO fue_vpl VALUES ("GL1_13","078_1_13","GAL","1","13","13","On nanii no laatinoomi arande, der diina Yahuduuɓe. Mi toorii eklesiya Alla e cattal, mi tinnakeno halkugo ka. ");
INSERT INTO fue_vpl VALUES ("GL1_14","078_1_14","GAL","1","14","14","Mii ɓurunoo igooɓe am ɗuuɓɓe der laawol diina Yahuduuɓe. Mii wooduno tinnaare mawne dow saloraago tawaaŋal kaakiraaɓe am. ");
INSERT INTO fue_vpl VALUES ("GL1_15","078_1_15","GAL","1","15","15","Amma Alla suɓii am diga mii woni der reedu inna am, noddimmi sabbu moƴƴere mum. ");
INSERT INTO fue_vpl VALUES ("GL1_16","078_1_16","GAL","1","16","16","O hollitii am Ɓiyiiko gam mi waajoo heeferɓe habaru makko. Wakkati mum, mi seedinay goɗɗo. ");
INSERT INTO fue_vpl VALUES ("GL1_17","078_1_17","GAL","1","17","17","Mi yahay Urusaliima to artuɓe am laataago lilaaɓe, amma mi yahii leydi Arabiya, bittoymi Damas. ");
INSERT INTO fue_vpl VALUES ("GL1_18","078_1_18","GAL","1","18","18","Duuɓi tati ɓaawo mum jahumi Urusaliima, gam mi annita Piyer, gondumi e makko balɗe sappo e joy. ");
INSERT INTO fue_vpl VALUES ("GL1_19","078_1_19","GAL","1","19","19","Mi yi'ay lilaaɗo baa gooto, to hinaa Yaakuuba, miiraawo Joomiraawo. ");
INSERT INTO fue_vpl VALUES ("GL1_20","078_1_20","GAL","1","20","20","Ko binnananmi on ɗo, Alla woni seedeejo am, mi fewataa. ");
INSERT INTO fue_vpl VALUES ("GL1_21","078_1_21","GAL","1","21","21","Ɓaawo majjum, jahumi leydi Siriya, e leydi Silisiya. ");
INSERT INTO fue_vpl VALUES ("GL1_22","078_1_22","GAL","1","22","22","Wakkati majjum, goonɗinɓe ɓe eklesiyaaji leydi Yahudiya meeɗay yi'ugo am e gite mum. ");
INSERT INTO fue_vpl VALUES ("GL1_23","078_1_23","GAL","1","23","23","Ɓe nananno nun tan e wi'ee, neɗɗo toorannooɗo en, jooni na'on waajoo haala goonɗinki ki yiɗuno halkugo. ");
INSERT INTO fue_vpl VALUES ("GL1_24","078_1_24","GAL","1","24","24","Den ɓe teddinii Alla sabbu am. ");
INSERT INTO fue_vpl VALUES ("GL2_1","078_2_1","GAL","2","1","1","Duuɓi sappo e naay ɓaawo mum, bittumi Urusaliima min e Barnabbas. Titus bo e wondi e am. ");
INSERT INTO fue_vpl VALUES ("GL2_2","078_2_2","GAL","2","2","2","Mi yahii ton gam ko Alla hollitimmi. Mi hawtii min tan e ardiiɓe, kollumi ɓe linjiila ka baajotoomi caka ɓe lenyi janani. Gam mi yiɗaa golle am ɗe gaɗumi, e ɗe gaɗanmi laatoo baanji. ");
INSERT INTO fue_vpl VALUES ("GL2_3","078_2_3","GAL","2","3","3","Titus gonduɗo e am, laati nun Yunaninkeejo, o doolaaka bo julnaago. ");
INSERT INTO fue_vpl VALUES ("GL2_4","078_2_4","GAL","2","4","4","E non fu, banniraaɓe fewrekuuɓe naatuɓe caka men e ƴoyre, e yiɗunoo ɗum. Ɓe daartii liinyugo dimaaku keɓuɗen der kawtal meeɗen e Yeesu Almasiihu, gam ɓe bittina en der maccunnaaku. ");
INSERT INTO fue_vpl VALUES ("GL2_5","078_2_5","GAL","2","5","5","Amma men kokkay ɓe laawol baa seɗɗa, heɓa gooŋa linjiila tabitoo caka mooɗon. ");
INSERT INTO fue_vpl VALUES ("GL2_6","078_2_6","GAL","2","6","6","Daaraaɓe mawɓe ɓen, baa to ume ɓe laatiino, walaa ko faalii am, gam Alla ɓurontirtaa himɓe. Mawɓe ɓen yowanay am goɗɗum. ");
INSERT INTO fue_vpl VALUES ("GL2_7","078_2_7","GAL","2","7","7","Amma ɓe paamii Alla nun yowanimmi linjiila mi waajoo ɓe lenyi janani, hande no o yowirani Piyer waajoo Yahuduuɓe. ");
INSERT INTO fue_vpl VALUES ("GL2_8","078_2_8","GAL","2","8","8","Alla laatinɗo Piyer lilaaɗo caka Yahuduuɓe, kanko laatinimmi min bo lilaaɗo caka ɓe lenyi janani. ");
INSERT INTO fue_vpl VALUES ("GL2_9","078_2_9","GAL","2","9","9","Yaakuuba e Piyer e Yuhaana, laatiiɓe darŋanal goonɗinɓe annitii moƴƴere ne Alla waɗanimmi. Ɓe kokkii men juuɗe min e Barnabbas gam hollitingo naaral amen. Hande non menen, men jaha men baajoo ɓe lenyi janani, kamɓe bo ɓe baajoo Yahuduuɓe. ");
INSERT INTO fue_vpl VALUES ("GL2_10","078_2_10","GAL","2","10","10","Ko ɓe eeli men tan woni, men ciwtora talakaaɓe. Mi tinnike bo waɗugo ɗum. ");
INSERT INTO fue_vpl VALUES ("GL2_11","078_2_11","GAL","2","11","11","Amma no Piyer wari Antiyokiya, mi wooltanii mo yeeso himɓe gam o woofii. ");
INSERT INTO fue_vpl VALUES ("GL2_12","078_2_12","GAL","2","12","12","Gam ko lilaaɓe Yaakuuba wara, Piyer e nyaamdannoo e ɓe lenyi janani. Amma no ɓe jottii, o takkitii ɓe, o acci nyaamdugo e maɓɓe, gam oo hula Yahuduuɓe. ");
INSERT INTO fue_vpl VALUES ("GL2_13","078_2_13","GAL","2","13","13","Yahuduuɓe goonɗinɓe Yeesu woɓɓe hawtii e makko, faa ɓe naanni Barnabbas bo der munaafitaare maɓɓe. ");
INSERT INTO fue_vpl VALUES ("GL2_14","078_2_14","GAL","2","14","14","No ji'umi ɓe jahataa der gooŋa linjiila, bi'umi Piyer yeeso himɓe fu: «An Yahuduujo, aa waɗa hande no ɓe lenyi janani waɗata, hinaa hande no Yahuduuɓe, noy doolirta ɓe lenyi janani ɓe gaɗa hande Yahuduuɓe?» ");
INSERT INTO fue_vpl VALUES ("GL2_15","078_2_15","GAL","2","15","15","Menen, men dimaaka maa der lenyol Yahuduuɓe, men laataaki hakkeeɓe ɓe lenyi janani. ");
INSERT INTO fue_vpl VALUES ("GL2_16","078_2_16","GAL","2","16","16","Emen anni neɗɗo laatintaake poonnitiiɗo e tokkugo tawreeta. E goonɗinki Yeesu Almasiihu tan neɗɗo laatinirtee poonnitiiɗo. Menen bo men goonɗinii Yeesu Almasiihu, gam men laatinee foonnitiiɓe diga e goonɗinki, hinaa gam tokkugo tawreeta. Gam walaa baa gooto laatinteeɗo poonnitiiɗo e tokkugo tawreeta. ");
INSERT INTO fue_vpl VALUES ("GL2_17","078_2_17","GAL","2","17","17","Emen daarta laatineego foonnitiiɓe der kawtal amen e Almasiihu. Der majjum, to tawaama men hakkeeɓe nun, den Almasiihu laati nun gollantooɗo hakke na? Abada! ");
INSERT INTO fue_vpl VALUES ("GL2_18","078_2_18","GAL","2","18","18","Gam to mii mahitoo ko pusumi, min e hoore am mii tabbitina no mi boofuɗo. ");
INSERT INTO fue_vpl VALUES ("GL2_19","078_2_19","GAL","2","19","19","Amma min, mi maayi dow wecco tawreeta, tawreeta kan warimmi, heɓa mi wuura gam Alla. Mi tiggidaama e Almasiihu dow leggal palaaŋal. ");
INSERT INTO fue_vpl VALUES ("GL2_20","078_2_20","GAL","2","20","20","Min bane wuurata, Almasiihu nun wuuri der am. Guurnam ɓannu buuranmi jooni, e goonɗinki Ɓiɗɗo Alla nun buuranmi, kanko jiɗɗo am faa hokkitiri hoore mum gam am. ");
INSERT INTO fue_vpl VALUES ("GL2_21","078_2_21","GAL","2","21","21","Mi woppataa moƴƴere Alla. Gam to e tokkugo tawreeta nun neɗɗo laatinirtee poonnitiiɗo, den fu Almasiihu maayii gam baanji. ");
INSERT INTO fue_vpl VALUES ("GL3_1","078_3_1","GAL","3","1","1","Onon ɓe Galaatiya, on galaa hakkillo! Moy jammii on? On laaɓinanaamaa haala Yeesu Almasiihu, tiggaaɗo dow leggal palaaŋal. ");
INSERT INTO fue_vpl VALUES ("GL3_2","078_3_2","GAL","3","2","2","Toontee am ƴanɗe ɗee ɗo: Gam tokkuɗon tawreeta acci keɓuɗon Ruuhu Ceniiɗo na, naa gam on nanii linjiila go goonɗinɗon Yeesu Almasiihu? ");
INSERT INTO fue_vpl VALUES ("GL3_3","078_3_3","GAL","3","3","3","Non hakkillo mooɗon faanɗiri? On puɗɗirii e Ruuhu Alla, ko oon jiɗi heennyitirgo e semme mooɗon? ");
INSERT INTO fue_vpl VALUES ("GL3_4","078_3_4","GAL","3","4","4","Huune ko heɓi on ɗum fu laatike baanji na? Waɗataako ɗum laatoo baanji. ");
INSERT INTO fue_vpl VALUES ("GL3_5","078_3_5","GAL","3","5","5","Kokkuɗo on Ruuhu mum, go e waɗa haaynaareeji hakkune mon, gam tokkuɗon tawreeta o waɗata nun na, naa gam on nanii linjiila ko goonɗinɗon? ");
INSERT INTO fue_vpl VALUES ("GL3_6","078_3_6","GAL","3","6","6","Dewtere wi'i: «Iburahiima goonɗinii, go Alla daari mo poonnitiiɗo.» ");
INSERT INTO fue_vpl VALUES ("GL3_7","078_3_7","GAL","3","7","7","Gam majjum, paamee kaa ɗo: Goonɗinɓe Alla nun laatii ɓiɓɓe Iburahiima. ");
INSERT INTO fue_vpl VALUES ("GL3_8","078_3_8","GAL","3","8","8","Dewtere batiino, no Alla waɗan ɓe lenyi janani foonnitiiɓe gam goonɗinki maɓɓe. Kan acci ne batunoo Iburahiima linjiila diga law, ne wi'i: «Lenyi fu barkiɗinte diga e maa.» ");
INSERT INTO fue_vpl VALUES ("GL3_9","078_3_9","GAL","3","9","9","Iburahiima goonɗinii go o barkiɗinaa. Hande non goonɗinɓe heɓan barkiɗineego e makko. ");
INSERT INTO fue_vpl VALUES ("GL3_10","078_3_10","GAL","3","10","10","Amma hooliiɓe tawreeta fu naaloore na'on dow maɓɓe. Gam e winnii der Dewtere: «Naaloore laatanoo mo tokkay baadey e gollira ko winnaa der tawreeta.» ");
INSERT INTO fue_vpl VALUES ("GL3_11","078_3_11","GAL","3","11","11","Ɗum laaɓii no baa gooto laatintaake poonnitiiɗo yeeso Alla e tokkugo tawreeta. Gam dewtere wi'i: «Poonnitiiɗo wuuran sabbu goonɗinki mum.» ");
INSERT INTO fue_vpl VALUES ("GL3_12","078_3_12","GAL","3","12","12","Nani tawreeta ƴiway e goonɗinki, gam e winnii: «Golliroowo ko tawreeta bati fu wuuran e majjum.» ");
INSERT INTO fue_vpl VALUES ("GL3_13","078_3_13","GAL","3","13","13","Almasiihu sooditake en diga naaloore tawreeta. O laatake naalaaɗo gam men, gam e winnii: «Ɓilaaɗo dow leggal fu laati nun naalaaɗo.» ");
INSERT INTO fue_vpl VALUES ("GL3_14","078_3_14","GAL","3","14","14","Yeesu waɗii ɗum gam barke Iburahiima laatanoo ɓe lenyi janani. Goonɗinɗo Yeesu Almasiihu heɓan Ruuhu mo Alla haɓɓani ɗum alkawal. ");
INSERT INTO fue_vpl VALUES ("GL3_15","078_3_15","GAL","3","15","15","Banniraaɓe, mii bata ɗo hande no himɓe batirta. To neɗɗo haɓɓii alkawal tabbitini ŋal, walaa piirtanɗo ŋal, walaa ɓeydoowo ŋal bo. ");
INSERT INTO fue_vpl VALUES ("GL3_16","078_3_16","GAL","3","16","16","Alla haɓɓanii Iburahiima e taaniraawo mum alkawal. Dewtere wi'ay: «Taaniraaɓe», hande ɓe ɗuuɓɓe nun, amma gooto ne batani, ne wi'i: «taaniraawo maa», kanko woni Almasiihu. ");
INSERT INTO fue_vpl VALUES ("GL3_17","078_3_17","GAL","3","17","17","Ko jiɗumi wi'ugo woni: Alla haɓɓi alkawal faa wooɗi. Den tawreeta garuka ɓaawo duuɓi keme naay e laso e sappo, waawataa ko fiirti ŋal, laatina ŋal baanji. ");
INSERT INTO fue_vpl VALUES ("GL3_18","078_3_18","GAL","3","18","18","To donŋu heɓirte nun e tawreeta, den fu e alkawal bane ŋu heɓirtee. Nani bo e alkawal nun Alla hokkiri Iburahiima moƴƴere. ");
INSERT INTO fue_vpl VALUES ("GL3_19","078_3_19","GAL","3","19","19","Den ume sariya wari waɗugo? Ka hokkaamaa gam hollitingo boofi, faa ko taaniraawo Iburahiima wara, kanko nun Alla haɓɓani alkawal. Diga e malaykaaɓe bo tawreeta hokkaa, der junŋo hakkunneejo. ");
INSERT INTO fue_vpl VALUES ("GL3_20","078_3_20","GAL","3","20","20","Amma to neɗɗo gooto nun, haaje hakkunneejo walaa. Nani bo Alla kan laati nun gooto. ");
INSERT INTO fue_vpl VALUES ("GL3_21","078_3_21","GAL","3","21","21","Den, tawreeta luudontiran nun e alkawal Alla na? Aawo! To tawreeta waawanno ko hokki yonki, den fu e gooŋa neɗɗo laatinteno poonnitiiɗo diga e tawreeta. ");
INSERT INTO fue_vpl VALUES ("GL3_22","078_3_22","GAL","3","22","22","Dewtere wi'i, hakke jaalake himɓe fu. To non goonɗinɓe Yeesu Almasiihu heɓan ko ɓe kaɓɓanaa alkawal gam goonɗinki maɓɓe. ");
INSERT INTO fue_vpl VALUES ("GL3_23","078_3_23","GAL","3","23","23","Diga goonɗinki waray, tawreeta e haɓɓunoo en hande der kasu. Ekaa haɓɓi en hakko goonɗinki suppitintoo. ");
INSERT INTO fue_vpl VALUES ("GL3_24","078_3_24","GAL","3","24","24","Hande non tawreeta laatorii deenoowo en faa wakkati Almasiihu wari gam laatineɗen foonnitiiɓe diga e goonɗinki. ");
INSERT INTO fue_vpl VALUES ("GL3_25","078_3_25","GAL","3","25","25","Jooni no goonɗinki wari, en burtake e junŋo deenoowo on. ");
INSERT INTO fue_vpl VALUES ("GL3_26","078_3_26","GAL","3","26","26","On fu, on laatake ɓiɓɓe Alla gam on goonɗini Yeesu Almasiihu. ");
INSERT INTO fue_vpl VALUES ("GL3_27","078_3_27","GAL","3","27","27","On fu, on kawtii e Almasiihu, gaɗanaɗon batisi e inne makko, nanduɗon mo. ");
INSERT INTO fue_vpl VALUES ("GL3_28","078_3_28","GAL","3","28","28","Cuttontirol walaa hakkune Yahuduujo e Yunaninkeejo, dimo naa bo maccuɗo, gorko naa bo debbo, gam on fu on laatike gootum der kawtal mooɗon e Yeesu Almasiihu. ");
INSERT INTO fue_vpl VALUES ("GL3_29","078_3_29","GAL","3","29","29","To on laatike himɓe Almasiihu, den on laatike ɓe lenyol Iburahiima, on donan ko Alla haɓɓannoo mo alkawal. ");
INSERT INTO fue_vpl VALUES ("GL4_1","078_4_1","GAL","4","1","1","Ko jiɗum wi'ugo woni, to donoowo e laatii sukeel, walaa ko suttontirta mo e maccuɗo, baa no kanko nun woodi huune fu. ");
INSERT INTO fue_vpl VALUES ("GL4_2","078_4_2","GAL","4","2","2","O ɗowtanto reenooɓe mo e dawranooɓe jawdi makko faa wakkati ki baabiiko resi yottoo. ");
INSERT INTO fue_vpl VALUES ("GL4_3","078_4_3","GAL","4","3","3","Enen bo, no laatinoɗen sukaaɓe, en laatikeno maccuɓe baawɗeeji duuniyaaru. ");
INSERT INTO fue_vpl VALUES ("GL4_4","078_4_4","GAL","4","4","4","Amma no wakkati ki Alla resi hebbi, o lilii Ɓiɗɗo makko. Ɓiɗɗo on rimaama e debbo, o umminaama ley baawɗe tawreeta, ");
INSERT INTO fue_vpl VALUES ("GL4_5","078_4_5","GAL","4","5","5","gam o rinɗina wonɓe der makka, o laatina en ɓiɓɓe Alla. ");
INSERT INTO fue_vpl VALUES ("GL4_6","078_4_6","GAL","4","6","6","Gam een laatii ɓiɓɓe Alla, o lilii Ruuhu Ɓiyiiko der ɓerɗe meeɗen. Kanjum acci Ruuhu on e wi'a: «Abba», waato Baaba. ");
INSERT INTO fue_vpl VALUES ("GL4_7","078_4_7","GAL","4","7","7","To non, a laataaki kade maccuɗo, ɓiɗɗo nun laatiɗaa. No aa laatii ɓiɗɗo, a ronan ko Alla resani ɓiɓɓe mum. ");
INSERT INTO fue_vpl VALUES ("GL4_8","078_4_8","GAL","4","8","8","Den ko on annaano Alla, on jagganakeno safeteeɓe ɓe laataaki Alla e gooŋa. ");
INSERT INTO fue_vpl VALUES ("GL4_9","078_4_9","GAL","4","9","9","Amma jooni no annitinɗon Alla, ɗum bo mi wi'a no Alla anniti on, noy ɗum waɗi ko oon bitta to ruuhuuji ɗi walaa baawɗe e tedduŋal? Ko jey sabbu ko oon jiɗi laataago maccuɓe majji kade? ");
INSERT INTO fue_vpl VALUES ("GL4_10","078_4_10","GAL","4","10","10","Oon kakkilana nyalaaɗe goɗɗe, e lebbi goɗɗi, e wakkatiiji goɗɗi, e duuɓi goɗɗi. ");
INSERT INTO fue_vpl VALUES ("GL4_11","078_4_11","GAL","4","11","11","Mii hula to golle gaɗumi gam mooɗon laato baanji. ");
INSERT INTO fue_vpl VALUES ("GL4_12","078_4_12","GAL","4","12","12","Banniraaɓe, mii eela on, laatee hande am, gam min bo mii laatii hande mooɗon. On gaɗay am fu gacce gom. ");
INSERT INTO fue_vpl VALUES ("GL4_13","078_4_13","GAL","4","13","13","Oon anni gam sabbu nyaw nun acci ko baajiimi on linjiila aran. ");
INSERT INTO fue_vpl VALUES ("GL4_14","078_4_14","GAL","4","14","14","Nyaw am toorii on, amma on jawaaki am, on elay am bo. On jaɓii am hande malaykaajo Alla, e hande Yeesu Almasiihu. ");
INSERT INTO fue_vpl VALUES ("GL4_15","078_4_15","GAL","4","15","15","To non, toy seyo mooɗon goodunoɗon woni? Gam mii seedanoo on ɗum, to on baawiino, on ɗoofanno gite mooɗon kokkon am. ");
INSERT INTO fue_vpl VALUES ("GL4_16","078_4_16","GAL","4","16","16","Mi laatike ganyo mooɗon gam mii bata on gooŋa na? ");
INSERT INTO fue_vpl VALUES ("GL4_17","078_4_17","GAL","4","17","17","Tinnaare himɓe ɓen woodi dow mooɗon wooɗaa, gam ɓe jiɗu nun seennugo on e am, gam tokkoɗon ɓe e tinnaare. ");
INSERT INTO fue_vpl VALUES ("GL4_18","078_4_18","GAL","4","18","18","Waɗugo ko nafata e tinnaare baadey e wooɗi, amma hinaa to mii woni e mooɗon tan. ");
INSERT INTO fue_vpl VALUES ("GL4_19","078_4_19","GAL","4","19","19","Sukaaɓe am, mii tooro kade gam mooɗon hande no debbo nanirta ŋatawre. Ɗum laato faa jikku Almasiihu wonoo der mooɗon. ");
INSERT INTO fue_vpl VALUES ("GL4_20","078_4_20","GAL","4","20","20","Mii yiɗunoo wonaago to mooɗon jooni, gam mi heɓa no baddirmi e mooɗon. Jooni mi annaa noy gaɗanmi e haala mooɗon. ");
INSERT INTO fue_vpl VALUES ("GL4_21","078_4_21","GAL","4","21","21","Batee am onon yiɗuɓe ɗowtanaago tawreeta. On nanay ko tawreeta kan wi'i na? ");
INSERT INTO fue_vpl VALUES ("GL4_22","078_4_22","GAL","4","22","22","E winnii no Iburahiima e woodi ɓiɓɓe worɓe ɗiɗo, gooto ɓii korɗo, gooto bo ɓii dimo. ");
INSERT INTO fue_vpl VALUES ("GL4_23","078_4_23","GAL","4","23","23","Ɓii korɗo rimaama hande no himɓe fu rimirtee, ɓii dimo bo rimiraa e alkawal Alla. ");
INSERT INTO fue_vpl VALUES ("GL4_24","078_4_24","GAL","4","24","24","E woodi ko soomii der haala ka. Rewɓe ɗiɗo ɓen laati nun alkawalji Alla ɗiɗi. Gootal, waato Hajara, ƴiwii dow waanne Sinayi, kanŋal rimi maccuɓe. ");
INSERT INTO fue_vpl VALUES ("GL4_25","078_4_25","GAL","4","25","25","Hajara laati nun hande waanne Sinayi, tawaane leydi Arabiya. Oo nandi e Urusaliima ni jooni. Gam Urusaliima e sukaaɓe mum, e jeyaanaaku woni. ");
INSERT INTO fue_vpl VALUES ("GL4_26","078_4_26","GAL","4","26","26","Amma Urusaliima ni dow kammu laati nun dimuri, kayri laatii inna meeɗen. ");
INSERT INTO fue_vpl VALUES ("GL4_27","078_4_27","GAL","4","27","27","Gam e winnii: «Welweltu, an dimaro! Huuɓu kuuɓaali seyo! an mo meeɗay ko nani ŋatawre. Gam sukaaɓe debbo accaaɗo ɗuuɗan ɓura ɓe debbo ɓaŋaaɗo.» ");
INSERT INTO fue_vpl VALUES ("GL4_28","078_4_28","GAL","4","28","28","Onon banniraaɓe, on laati nun ɓiɓɓe alkawal Alla hande Isiyaaku. ");
INSERT INTO fue_vpl VALUES ("GL4_29","078_4_29","GAL","4","29","29","Amma, hande no dimaaɗo e ɓannu tooriri dimaaɗo e Ruuhu Alla, hande nun bo ɗum laatii faa hanne. ");
INSERT INTO fue_vpl VALUES ("GL4_30","078_4_30","GAL","4","30","30","Amma ume nun Dewtere wi'i? Ne wi'i: «Riiwu korɗo e ɓiyum, gam ɓii korɗo ronidintaa e ɓii dimo». ");
INSERT INTO fue_vpl VALUES ("GL4_31","078_4_31","GAL","4","31","31","Hande non banniraaɓe, en laataaki ɓiɓɓe korɗo, amma een ɓiɓɓe dimo. ");
INSERT INTO fue_vpl VALUES ("GL5_1","078_5_1","GAL","5","1","1","Almasiihu firtii en gam laatoɗen rimɓe e gooŋa. Gam majjum, daree e semme, to on accee bittineɗon der baawɗe jeyaanaaku. ");
INSERT INTO fue_vpl VALUES ("GL5_2","078_5_2","GAL","5","2","2","Min Pol, mii wi'a on: To on nootike juulnaɗon, Almasiihu nafataa on goɗɗum. ");
INSERT INTO fue_vpl VALUES ("GL5_3","078_5_3","GAL","5","3","3","Mii batitoo ka kade, neɗɗo fu nootiiɗo juulnaago, sey joomum ɗowtanoo tawreeta fu. ");
INSERT INTO fue_vpl VALUES ("GL5_4","078_5_4","GAL","5","4","4","Onon dartooɓe laataago foonnitiiɓe diga e tawreeta, on ceedi e Almasiihu, on boɗɗodike e moƴƴere Alla. ");
INSERT INTO fue_vpl VALUES ("GL5_5","078_5_5","GAL","5","5","5","Menen, e men keɗi Alla laatina men foonnitiiɓe diga e goonɗinki. Kanjum men keɗi e baawɗe Ruuhu Ceniiɗo. ");
INSERT INTO fue_vpl VALUES ("GL5_6","078_5_6","GAL","5","6","6","To goɗɗo hawtii e Yeesu Almasiihu, juulnol e dullere juulnol fu laataaki goɗɗum. Ko nafata woni, goonɗinki gollotooki e yidde. ");
INSERT INTO fue_vpl VALUES ("GL5_7","078_5_7","GAL","5","7","7","On puɗɗii doggudu mooɗon no wooɗiri. Moy haggi on, haɗi on ɗowtanaago gooŋa? ");
INSERT INTO fue_vpl VALUES ("GL5_8","078_5_8","GAL","5","8","8","Ko wayliti miilooji mooɗon ƴiway to Alla, nodduɗo on. ");
INSERT INTO fue_vpl VALUES ("GL5_9","078_5_9","GAL","5","9","9","E wi'ee: Ƴuufinirɗum seɗɗa ƴuufinan conni laawaani fu. ");
INSERT INTO fue_vpl VALUES ("GL5_10","078_5_10","GAL","5","10","10","Min kan, mii hoolii on gam Joomiraawo, mii anni miilo mooɗon wittay nokkun feere. Amma laawoowo on on, baa to moy nun, o doƴƴete kiita. ");
INSERT INTO fue_vpl VALUES ("GL5_11","078_5_11","GAL","5","11","11","Banniraaɓe, to haala juulnol nun baajotoomi, gam ume tooreteemi? To kanka baajotoomi, den fu maayde Almasiihu dow leggal palaaŋal laatantaakono goɗɗo fergere. ");
INSERT INTO fue_vpl VALUES ("GL5_12","078_5_12","GAL","5","12","12","Laawooɓe on ɓee, yaha wuddita ɗum fu. ");
INSERT INTO fue_vpl VALUES ("GL5_13","078_5_13","GAL","5","13","13","Banniraaɓe, on noddaama gam laatoɗon rimɓe. To on ettee dimaaku mooɗon gaɗiron jiɗaaɗi yonki. Amma, moy fu jagganoo bannun e yidde. ");
INSERT INTO fue_vpl VALUES ("GL5_14","078_5_14","GAL","5","14","14","Gam tawreeta fu hawtii der haala goota kaa ɗo: «Yiɗu banniraawo maa hande no jiɗirɗaa hoore maa». ");
INSERT INTO fue_vpl VALUES ("GL5_15","078_5_15","GAL","5","15","15","Amma to oon ƴakkontira, oon nyaamontira hande dawaaɗi, kakkilee to on kalkontiree. ");
INSERT INTO fue_vpl VALUES ("GL5_16","078_5_16","GAL","5","16","16","Gam majjum, mii bata on: Accee Ruuhu Ceniiɗo dura gonki mon, den on tokkataa jiɗaaɗi yonki mooɗon. ");
INSERT INTO fue_vpl VALUES ("GL5_17","078_5_17","GAL","5","17","17","Gam jiɗaaɗe yonki e luudontiri e Ruuhu, ko Ruuhu yiɗi bo e luudontiri e jiɗaaɗi yonki. Eɗum luudontiri hakkune majjum, kan acci on baawataa waɗugo ko jiɗuɗon. ");
INSERT INTO fue_vpl VALUES ("GL5_18","078_5_18","GAL","5","18","18","Amma to Ruuhu durata on, tawreeta woodaa baawɗe dow mon. ");
INSERT INTO fue_vpl VALUES ("GL5_19","078_5_19","GAL","5","19","19","Ko jiɗaaɗi yonki waddata e laaɓi. Kanjum woni, jeenu, ko soɓi, kaaruwaaku, ");
INSERT INTO fue_vpl VALUES ("GL5_20","078_5_20","GAL","5","20","20","caafol tooruuje, dobodobooje, gayŋu, hawre, nawniraagu, mone, jeddi cattuɗi, luudontirgo, ceennirgu, ");
INSERT INTO fue_vpl VALUES ("GL5_21","078_5_21","GAL","5","21","21","suuno, jarɗe bagi, deereraaku e ko nandi e majjum. Mii seedina on hande no ceedinirnoomi on bi'umi, waɗooɓe iri baadi nin fu naatataa der Laamaare Alla. ");
INSERT INTO fue_vpl VALUES ("GL5_22","078_5_22","GAL","5","22","22","Amma ko Ruuhu Ceniiɗo rimata woni: yidde, seyo, jam, munyal, neɗɗaaku, yurmeene, goonɗinki, ");
INSERT INTO fue_vpl VALUES ("GL5_23","078_5_23","GAL","5","23","23","ɗiggere e jogaago hoore mum. Tawreeta walaa gaccotooka iri kujje ɗee. ");
INSERT INTO fue_vpl VALUES ("GL5_24","078_5_24","GAL","5","24","24","Laatiiɓe ɓe Yeesu Almasiihu tiggii ɓalli mum e jiɗaaɗi yonki, e suuno mum fu dow leggal palaaŋal. ");
INSERT INTO fue_vpl VALUES ("GL5_25","078_5_25","GAL","5","25","25","To e Ruuhu nun buurirɗen, accee jahiren no Ruuhu yiɗiri. ");
INSERT INTO fue_vpl VALUES ("GL5_26","078_5_26","GAL","5","26","26","To en mawnitee, to en corkontiree, to en gaɗontiree nawniraagu. ");
INSERT INTO fue_vpl VALUES ("GL6_1","078_6_1","GAL","6","1","1","Banniraaɓe, to on nanŋii goɗɗo e waɗa boofol, onon wooduɓe Ruuhu, bittinee joomum e ɗiggere. Amma, onon bo kakkilee gam to on naatee der jarbeeji. ");
INSERT INTO fue_vpl VALUES ("GL6_2","078_6_2","GAL","6","2","2","Ballontiree roonaago doolle mooɗon, hande non kebbinirton ko Almasiihu resani on. ");
INSERT INTO fue_vpl VALUES ("GL6_3","078_6_3","GAL","6","3","3","To goɗɗo e miili e laatii goɗɗum, nani bo o laataaki goɗɗum, o jammike hoore makko. ");
INSERT INTO fue_vpl VALUES ("GL6_4","078_6_4","GAL","6","4","4","Moy fu daara golle muuɗum. To ɗe potii ko o juroro, o juro gam hoore makko, amma to o jura dow golle goɗɗo. ");
INSERT INTO fue_vpl VALUES ("GL6_5","078_6_5","GAL","6","5","5","Gam moy fu roonoto e hoore mum doongal mum. ");
INSERT INTO fue_vpl VALUES ("GL6_6","078_6_6","GAL","6","6","6","Janŋinteeɗo haala Alla, e haani seennira ko woodi e janŋinoowo ɗum. ");
INSERT INTO fue_vpl VALUES ("GL6_7","078_6_7","GAL","6","7","7","To on majjinee ko'e mooɗon, Alla nootataako goɗɗo yawoo ɗum. Ko moy fu aawi, kanjum ruggata. ");
INSERT INTO fue_vpl VALUES ("GL6_8","078_6_8","GAL","6","8","8","Aawuɗo ko suuno mum yiɗi, ruggan ko suuno rimata, waato maayde. Aawuɗo ko Ruuhu Ceniiɗo yiɗi, ruggan ko Ruuhu rimata, waato yonki tabitiiki. ");
INSERT INTO fue_vpl VALUES ("GL6_9","078_6_9","GAL","6","9","9","To en comee waɗugo geetum. Gam to en tampay, en duggan to wakkati mum warii. ");
INSERT INTO fue_vpl VALUES ("GL6_10","078_6_10","GAL","6","10","10","To non, de gooduɗen wakkati, en gaɗanee himɓe fu geetum, accu dun banniraaɓe meeɗen goonɗinɓe. ");
INSERT INTO fue_vpl VALUES ("GL6_11","078_6_11","GAL","6","11","11","Daaree binniiji mawɗi ɗi binnanmi on e junŋo am. ");
INSERT INTO fue_vpl VALUES ("GL6_12","078_6_12","GAL","6","12","12","Dartooɓe hollitingo hoore mum yeeso himɓe, kamɓe doolata on juulnaago. Ɓee gaɗa ɗum gam ɓe jiɗaa tooreego sabbu leggal Almasiihu palaaŋal. ");
INSERT INTO fue_vpl VALUES ("GL6_13","078_6_13","GAL","6","13","13","Baa kamɓe juulnaaɓe, ɓe tokkaaki tawreeta. Ɓe jiɗu nun juulnoɗon gam ɓe keɓa juroraago on. ");
INSERT INTO fue_vpl VALUES ("GL6_14","078_6_14","GAL","6","14","14","Min kan, mi jurortaako goɗɗum to hinaa leggal Joomiraawo meeɗen Yeesu Almasiihu palaaŋal. Diga e maggal duuniyaaru tiggaa gam am, min bo tiggaami gam mayru. ");
INSERT INTO fue_vpl VALUES ("GL6_15","078_6_15","GAL","6","15","15","Gam juulnaago e dullere juulnaago fu laataaki goɗɗum, sey laataago neɗɗo keso, tagitaaɗo. ");
INSERT INTO fue_vpl VALUES ("GL6_16","078_6_16","GAL","6","16","16","Tokkuɓe laawol ŋol fu, Alla hokku ɗum jam e enɗam, kamɓe e Isira'iilaaɓe ɓe Alla. ");
INSERT INTO fue_vpl VALUES ("GL6_17","078_6_17","GAL","6","17","17","Diga jooni, to goɗɗo tooranmi kade, gam ɓannu am e woodi maane ɓattarɗe Yeesu. ");
INSERT INTO fue_vpl VALUES ("GL6_18","078_6_18","GAL","6","18","18","Banniraaɓe, moƴƴere Joomiraawo meeɗen Yeesu Almasiihu wonda e mooɗon! Aami. ");
INSERT INTO fue_vpl VALUES ("EP1_1","079_1_1","EPH","1","1","1","Ɗerewol ŋol ɗo ƴiwii e am min Pol, lilaaɗo Yeesu Almasiihu e yidde Alla. Mii winnana himɓe Alla wonɓe Efesu, goonɗinɓe Yeesu Almasiihu. ");
INSERT INTO fue_vpl VALUES ("EP1_2","079_1_2","EPH","1","2","2","Alla Baaba meeɗen, e Yeesu Almasiihu Joomiraawo, waɗana on moƴƴere, hokka on jam. ");
INSERT INTO fue_vpl VALUES ("EP1_3","079_1_3","EPH","1","3","3","Yettoore laatano Alla, laatiiɗo Baaba Yeesu Almasiihu Joomiraawo meeɗen. Gam kawtal meeɗen e Almasiihu, o barkiɗinii en e hokkugo en barke ruuhunkeeje feere feereeje, ƴiwuɗe dow kammu. ");
INSERT INTO fue_vpl VALUES ("EP1_4","079_1_4","EPH","1","4","4","Diga duuniyaaru tagaaka, Alla suɓii en sabbu Almasiihu, gam laatoɗen seniiɓe, ɓe walaa gacce yeeso makko. ");
INSERT INTO fue_vpl VALUES ("EP1_5","079_1_5","EPH","1","5","5","O suɓii en diga aran, gam laatoɗen ɓiɓɓe makko diga e Yeesu Almasiihu. Non non o yiɗiri ɗum sabbu geetaaku makko. Non ɗum fottirani mo bo. ");
INSERT INTO fue_vpl VALUES ("EP1_6","079_1_6","EPH","1","6","6","Gam majjum, en maantee, teddinen Alla gam moƴƴere makko ne o waɗani en, diga hokkugo en Ɓiyiiko jiɗaaɗo. ");
INSERT INTO fue_vpl VALUES ("EP1_7","079_1_7","EPH","1","7","7","Moƴƴere Alla e mawni: Diga e kawtal men e Almasiihu, en pirtaama, jaafaɗen, sabbu ƴiiƴam makko deƴƴitiiɗam. ");
INSERT INTO fue_vpl VALUES ("EP1_8","079_1_8","EPH","1","8","8","O ɗuuɗinanii en moƴƴere makko, o hokki en hakkillo e faamu kebbuŋu. ");
INSERT INTO fue_vpl VALUES ("EP1_9","079_1_9","EPH","1","9","9","Geetaaku makko acci o annini en asiiri sago makko, ko o resuno waɗugo diga fuɗɗoode diga e Almasiihu. ");
INSERT INTO fue_vpl VALUES ("EP1_10","079_1_10","EPH","1","10","10","To wakkati warii, Alla hebbinan ko resuno waɗugo, o hawritan ko woni dow kammu e dow leydi fu, o waɗa Almasiihu laatoo hooreejo majjum. ");
INSERT INTO fue_vpl VALUES ("EP1_11","079_1_11","EPH","1","11","11","Der kawtal men e Almasiihu, Alla hokkii en geɗu ŋu o haɓɓannoo en alkawal mum, e suɓugo en diga law, hande no o resirno. O waɗii ɗum, gam non o suɓirno e sago makko, ");
INSERT INTO fue_vpl VALUES ("EP1_12","079_1_12","EPH","1","12","12","gam maanten Alla, teddinen mo, enen artaaɓe suɓaa, watti hoolaare mum dow Almasiihu. ");
INSERT INTO fue_vpl VALUES ("EP1_13","079_1_13","EPH","1","13","13","Onon bo, no kawtuɗon e Almasiihu, on nanii haala gooŋa, kanka woni linjiila kaa ɗo hisinta on. No goonɗinɗon, Alla maanake on. Maane nen woni Ruuhu Ceniiɗo mo o haɓɓuno alkawal mum o hokkan. ");
INSERT INTO fue_vpl VALUES ("EP1_14","079_1_14","EPH","1","14","14","Ruuhu Ceniiɗo on nun laatii hande torma barke ɗe desanaɗen. En keɓan ɗe to nyalaane kisidam men hebbidii. To non en maantee Alla, teddinen mo. ");
INSERT INTO fue_vpl VALUES ("EP1_15","079_1_15","EPH","1","15","15","Gam majjum, min bo, no nanumi habaru no goonɗinirɗon Yeesu Joomiraawo, e no jiɗirɗon banniraaɓe goonɗinɓe, ");
INSERT INTO fue_vpl VALUES ("EP1_16","079_1_16","EPH","1","16","16","mi accay yettugo Alla gam mooɗon. De du'otoomi fu, emi siwtora on. ");
INSERT INTO fue_vpl VALUES ("EP1_17","079_1_17","EPH","1","17","17","Mii eela Alla Joomiraawo meeɗen Yeesu Almasiihu, Baaba mo tedduŋal, hokka on Ruuhu mum kokkoowo hakkillo. Ruuhu on hollita on Alla hande no o laati. ");
INSERT INTO fue_vpl VALUES ("EP1_18","079_1_18","EPH","1","18","18","Mii eela Alla yaynina ɓerɗe mooɗon, heɓa paamon ko heɗii on der noddoore ne o noddi on, paamon bo no barke ɗe desanaɗon onon e himɓe makko teddiri. ");
INSERT INTO fue_vpl VALUES ("EP1_19","079_1_19","EPH","1","19","19","On paaman bo baawɗe mawɗe, semmenteeje, ɗe o holliti dow meeɗen, enen goonɗinɓe. E baawɗe ɗen, e semme makko, ");
INSERT INTO fue_vpl VALUES ("EP1_20","079_1_20","EPH","1","20","20","o fintiniri Almasiihu diga e maayde. O jooɗini mo wecco junŋo makko nyaamo, dow kammu. ");
INSERT INTO fue_vpl VALUES ("EP1_21","079_1_21","EPH","1","21","21","Hande non Almasiihu laatorii ɓuruɗo laamuuji e baawɗeeji e semmeeji e mawɓe fu. Kanko nun laatii hooreejo dow ko woodi inne fu, hinaa der duuniyaaru nuu ɗo tan, amma e der duuniyaaru nu yeeso bo. ");
INSERT INTO fue_vpl VALUES ("EP1_22","079_1_22","EPH","1","22","22","Alla wattii huune fu ley koyɗe Almasiihu. O waɗii mo Joomiraawo dow huune fu, o laatini mo hooreejo Eklesiya. ");
INSERT INTO fue_vpl VALUES ("EP1_23","079_1_23","EPH","1","23","23","Eklesiya kan woni ɓannu Almasiihu. E makka Almasiihu hebbi, kanko mo Alla hebbi der mum. ");
INSERT INTO fue_vpl VALUES ("EP2_1","079_2_1","EPH","2","1","1","Onon, on maayiino gam boofi mooɗon e hakkeeji mooɗon. ");
INSERT INTO fue_vpl VALUES ("EP2_2","079_2_2","EPH","2","2","2","Kanji tokkunoɗon, hande no duuniyaaru yahirta, ɗowtaniɗon hooreejo ruuhuuji kalluɗi, tawaaɗi hakkune dow e ley. Ruuhuuji ɗin nun gollotoo faa e hanne caka himɓe yedduɓe Alla. ");
INSERT INTO fue_vpl VALUES ("EP2_3","079_2_3","EPH","2","3","3","En fu, hande no maɓɓe laatinoɗen. Suunooji meeɗen tokkunoɗen. Ko miilooji meeɗen kalluɗi, e jikku meeɗen yiɗi gaɗetenno. Gam sabbu jikku meeɗen ŋu, mone Alla nun haandannoo en hande no maɓɓe. ");
INSERT INTO fue_vpl VALUES ("EP2_4","079_2_4","EPH","2","4","4","Amma enɗam Alla walaa kaddi, o yiɗii en e yidde mawne. ");
INSERT INTO fue_vpl VALUES ("EP2_5","079_2_5","EPH","2","5","5","Gam majjum, enen maayunooɓe sabbu boofi men, o fintidinii en e Almasiihu. E gooŋa, gam moƴƴere Alla kisuɗon. ");
INSERT INTO fue_vpl VALUES ("EP2_6","079_2_6","EPH","2","6","6","No een kawti e Yeesu Almasiihu, Alla fintidinii en e makko, jooɗidini en e makko dow kammu. ");
INSERT INTO fue_vpl VALUES ("EP2_7","079_2_7","EPH","2","7","7","O waɗii ɗum gam o hollita en geetaaku makko. Jaamanuuji garooji fu yi'an manŋu moƴƴere makko ne foonnirtaake goɗɗum. O waɗanii en ne gam een kawti e Yeesu Almasiihu. ");
INSERT INTO fue_vpl VALUES ("EP2_8","079_2_8","EPH","2","8","8","Gam sabbu moƴƴere Alla kisuɗon, e gam on goonɗinii Almasiihu. Kisidam mooɗon laati nun dokkal Alla, golle mooɗon bane. ");
INSERT INTO fue_vpl VALUES ("EP2_9","079_2_9","EPH","2","9","9","Kisidam mon ƴiway diga e mon, gam to goɗɗo heɓu juraago. ");
INSERT INTO fue_vpl VALUES ("EP2_10","079_2_10","EPH","2","10","10","Alla nun waɗi en, kanko tagi en diga e kawtal men e Yeesu Almasiihu, gam golle booɗɗe. Golle booɗɗe ɗen, Alla siriyake ɗe diga aran gam gaɗen ɗe. ");
INSERT INTO fue_vpl VALUES ("EP2_11","079_2_11","EPH","2","11","11","Yahuduuɓe e woodunoo maane juulnol e ɓalli mum, ɓee jiɗi bo noddeego «juulniiɓe.» Onon ɓe laataaki Yahuduuɓe, on goodaa hande maane nen e ɓalli mon, go ɓee nodda on «heeferɓe.» To non ciwtoree ko laatinoɗon. ");
INSERT INTO fue_vpl VALUES ("EP2_12","079_2_12","EPH","2","12","12","Wakkati mum, on goodaano Almasiihu, on kawtaano e Isira'iilaaɓe, on galaano der alkawalji ɗi Alla haɓɓuno. On keɗaakino goɗɗum yeeso, on goodaano bo Alla der duuniyaaru. ");
INSERT INTO fue_vpl VALUES ("EP2_13","079_2_13","EPH","2","13","13","Amma jooni, no kawtuɗon e Yeesu Almasiihu, onon woɗɗinooɓe, on ɓattinaama diga e ƴiiƴam makko deƴƴitiiɗam. ");
INSERT INTO fue_vpl VALUES ("EP2_14","079_2_14","EPH","2","14","14","Gam Almasiihu nun laatii jam meeɗen. O waɗii laatiiɓe Yahuduuɓe e ɓe lenyi janani laatii gootum, diga e hokkugo yonki makko dow leggal palaaŋal. Hande non o pusiri bombooru gayŋu ŋuu ɗo seennunoo ɓe. ");
INSERT INTO fue_vpl VALUES ("EP2_15","079_2_15","EPH","2","15","15","Almasiihu moytii Sariya e umurooje mum, e kakkilanol mum fu. Non non o waɗiri Yahuduuɓe e ɓe lenyi janani fu laatii lenyol kesol, gam ɓee kawti e makko. Hande non o joonniri jam hakkune maɓɓe. ");
INSERT INTO fue_vpl VALUES ("EP2_16","079_2_16","EPH","2","16","16","Diga e maayde makko dow leggal palaaŋal o weldiniri ɓe e Alla. O hawtii ɓe ɓe laatii ɓannu gootol diga e maayde makko. Diga e palaaŋal ŋal, o sottiniri gayŋu tawanooŋu hakkune maɓɓe. ");
INSERT INTO fue_vpl VALUES ("EP2_17","079_2_17","EPH","2","17","17","Almasiihu warii fiinii habaru jam caka mooɗon, onon ɓe lenyi janani woɗɗinooɓe, e onon Yahuduuɓe ɓadinooɓe. ");
INSERT INTO fue_vpl VALUES ("EP2_18","079_2_18","EPH","2","18","18","Gam sabbu Almasiihu, en fu, en keɓii laawol yottaago to Baaba, e ballal Ruuhu gooto. ");
INSERT INTO fue_vpl VALUES ("EP2_19","079_2_19","EPH","2","19","19","Hande non, on laataaki kade hoɓɓe, ɗum bo jananɓe. On laatodake ɓe genni goori e himɓe Alla, oon himɓe wuro Alla. ");
INSERT INTO fue_vpl VALUES ("EP2_20","079_2_20","EPH","2","20","20","On mahaama dow suudu ŋol daɗɗa mum laatii lilaaɓe e annabiiɓe. Yeesu Almasiihu e hoore mum woni hayre jogiine maadi. ");
INSERT INTO fue_vpl VALUES ("EP2_21","079_2_21","EPH","2","21","21","Kanko nun jogii maadi nin fu, eni mawnira, faa ni towa, ni laatoo suudu Alla Joomiraawo ceniiŋol. ");
INSERT INTO fue_vpl VALUES ("EP2_22","079_2_22","EPH","2","22","22","No kawtuɗon e makko, on laatake mahirɗum to Alla wonoto diga e Ruuhu mum. ");
INSERT INTO fue_vpl VALUES ("EP3_1","079_3_1","EPH","3","1","1","Min Pol, mii maɓɓaaɗo der kasu gam golle Yeesu Almasiihu caka mooɗon, onon ɓe lenyi janani. ");
INSERT INTO fue_vpl VALUES ("EP3_2","079_3_2","EPH","3","2","2","Seko walaa, on nanii habaru golle ɗe Alla yowanimmi e moƴƴere mum, mi waɗa gam mon. ");
INSERT INTO fue_vpl VALUES ("EP3_3","079_3_3","EPH","3","3","3","O hollitanake am, o faaminimmi asiiri ko o resi o waɗa. Kanjum nun binnanmi on e haala seɗɗa. ");
INSERT INTO fue_vpl VALUES ("EP3_4","079_3_4","EPH","3","4","4","To on janŋii ɗerewol am, on annan no paamirmi asiiri dow Almasiihu. ");
INSERT INTO fue_vpl VALUES ("EP3_5","079_3_5","EPH","3","5","5","Asiiri on, himɓe hollaakano ɗum der jaamanuuji jawtuɗi. Amma jooni, diga e Ruuhu Ceniiɗo, Alla hollitii ɗum lilaaɓe e annabiiɓe ɓe o suɓi ɓe gollanoo mo. ");
INSERT INTO fue_vpl VALUES ("EP3_6","079_3_6","EPH","3","6","6","Nani ɗo no asiiri on laatori: Diga e linjiila, ɓe lenyi janani heɓi geɗu mum der moƴƴereeji desaaɗi, hande no Yahuduuɓe heɓiri. Ɓe laatake jokkule ɓannu gootol, ɓee goodi alkawal gootal gam ɓe kawtii e Yeesu Almasiihu. ");
INSERT INTO fue_vpl VALUES ("EP3_7","079_3_7","EPH","3","7","7","Linjiila kan nun laatiimi gollotooɗo mum, sabbu moƴƴere ne Alla waɗanimmi e golle baawɗe mum. ");
INSERT INTO fue_vpl VALUES ("EP3_8","079_3_8","EPH","3","8","8","Min ɓuri goonɗinɓe fu faanɗugo. E non, mi heɓii moƴƴere waajaago ɓe lenyi janani habaru jawdi gonuni der Almasiihu, ni faamataako. ");
INSERT INTO fue_vpl VALUES ("EP3_9","079_3_9","EPH","3","9","9","Mi heɓii bo dokkal faamingo no Alla taguɗo huune fu hebbinirta ko o resuno o waɗa, cuuɗinooɗum diga den. ");
INSERT INTO fue_vpl VALUES ("EP3_10","079_3_10","EPH","3","10","10","Hande non Eklesiya anninirta wooduɓe baawɗe e semme dow kammu, no faamu Alla ɗuuɗiri. ");
INSERT INTO fue_vpl VALUES ("EP3_11","079_3_11","EPH","3","11","11","Non o resunoo o waɗa diga ɓooyɗum, ko o hebbini ɗum diga e Joomiraawo meeɗen Yeesu Almasiihu. ");
INSERT INTO fue_vpl VALUES ("EP3_12","079_3_12","EPH","3","12","12","En kawtii e Almasiihu, en goonɗinii mo, to non, en baawan ko ɓattii Alla e hoolaare. ");
INSERT INTO fue_vpl VALUES ("EP3_13","079_3_13","EPH","3","13","13","Kanjum waɗi mii eela on, to on accee ɓerɗe mooɗon biisoo sabbu tooraaji ɗi keɓammi gam mooɗon. Tooraaji ɗin laati nun tedduŋal mooɗon. ");
INSERT INTO fue_vpl VALUES ("EP3_14","079_3_14","EPH","3","14","14","Gam sabbu ɗum ɗon fu, mii jiccanoo Baaba. ");
INSERT INTO fue_vpl VALUES ("EP3_15","079_3_15","EPH","3","15","15","Diga e makko lenyi gonuɗi dow kammu e leydi fu heɓi inne mum. ");
INSERT INTO fue_vpl VALUES ("EP3_16","079_3_16","EPH","3","16","16","Mii eela Alla mo tedduŋal manŋal semmiɗina ɓerɗe mon e baawɗe Ruuhu mum Ceniiɗo. ");
INSERT INTO fue_vpl VALUES ("EP3_17","079_3_17","EPH","3","17","17","Mii eela Almasiihu wonoo der ɓerɗe mooɗon, diga e goonɗingo mo. Mii eela mo kade, cemmiɗee der yidde, gaɗee ɗaɗi der mayre. ");
INSERT INTO fue_vpl VALUES ("EP3_18","079_3_18","EPH","3","18","18","Hande non paamirton, onon e himɓe Alla fu, no yidde Almasiihu foti yaajugo e juutugo e luggugo e towugo. ");
INSERT INTO fue_vpl VALUES ("EP3_19","079_3_19","EPH","3","19","19","Mii eela Alla annina on yidde Almasiihu ɓurune faamu fu, gam laatoɗon hebbuɓe, Alla bo hebba der mooɗon. ");
INSERT INTO fue_vpl VALUES ("EP3_20","079_3_20","EPH","3","20","20","Alla gollotooɗo der meeɗen e baawɗe mum, waɗana en ɓura ko eeleten, e ko miileten fu. ");
INSERT INTO fue_vpl VALUES ("EP3_21","079_3_21","EPH","3","21","21","Tedduŋal laatanoo mo der Eklesiya, diga e Yeesu Almasiihu, der jaamanuuji fu, faa abada abadin! Aami. ");
INSERT INTO fue_vpl VALUES ("EP4_1","079_4_1","EPH","4","1","1","Mii eela on, min maɓɓaaɗo der kasu gam Joomiraawo, goniree no fottiri hande no Alla noddiri on. ");
INSERT INTO fue_vpl VALUES ("EP4_2","079_4_2","EPH","4","2","2","Ɓuytee ko'e mon, laatee ɗigguɓe e munyuɓe. Munyanee himɓe e yidde. ");
INSERT INTO fue_vpl VALUES ("EP4_3","079_4_3","EPH","4","3","3","Tinnee oon laatii gootum hakkune mon, diga e jam mo Ruuhu Ceniiɗo hokkata on. ");
INSERT INTO fue_vpl VALUES ("EP4_4","079_4_4","EPH","4","4","4","Ɓannu gootol nun woni, e Ruuhu gooto, non bo gootum woni ko tammihiɗon yeeso, ɗum Alla noddani on. ");
INSERT INTO fue_vpl VALUES ("EP4_5","079_4_5","EPH","4","5","5","Joomiraawo gooto nun woni, e goonɗinki gooti, e batisi gooti. ");
INSERT INTO fue_vpl VALUES ("EP4_6","079_4_6","EPH","4","6","6","Alla gooto nun woni, laatiiɗo Baaba himɓe fu, laamaniiɗo himɓe fu, gollotooɗo diga e himɓe fu, gonuɗo der himɓe fu. ");
INSERT INTO fue_vpl VALUES ("EP4_7","079_4_7","EPH","4","7","7","Moy meeɗen fu heɓii dokkal moƴƴere, jaka no Almasiihu yiɗirani ɗum. ");
INSERT INTO fue_vpl VALUES ("EP4_8","079_4_8","EPH","4","8","8","Dewtere wi'ii: «O eencii dow, o yaarii nanŋaaɓe, o hokkii himɓe dokke.» ");
INSERT INTO fue_vpl VALUES ("EP4_9","079_4_9","EPH","4","9","9","Ume nun «o eencii dow» yiɗi fillitaago? Ko ɗum fillitii woni, o artii o jippii der nokkuure to ɓuri luggugo der leydi. ");
INSERT INTO fue_vpl VALUES ("EP4_10","079_4_10","EPH","4","10","10","Jippiiɗo on woni, «eencuɗo» faa dow kammu, gam o hebba duuniyaaru fu. ");
INSERT INTO fue_vpl VALUES ("EP4_11","079_4_11","EPH","4","11","11","Kanko nun hokki woɓɓe ɓe laatoo lilaaɓe, woɓɓe annabiiɓe, woɓɓe waajotooɓe, woɓɓe bo durugo himɓe, e janŋingo ɓe. ");
INSERT INTO fue_vpl VALUES ("EP4_12","079_4_12","EPH","4","12","12","O waɗii ɗum gam o siriyoo himɓe Alla gam golle, ɓe mawninira ɓannu Almasiihu. ");
INSERT INTO fue_vpl VALUES ("EP4_13","079_4_13","EPH","4","13","13","Hande non tinnortoɗen keɓen goonɗinki gooti, e annal Ɓiɗɗo Alla gootal, laatoɗen mawɓe, jottoɗen to Almasiihu woni laatoɗen hande no o wa'i. ");
INSERT INTO fue_vpl VALUES ("EP4_14","079_4_14","EPH","4","14","14","Den, en laatataako kade sukaaɓe wifitinteeɓe nokku fu, hande laanayel diyam ŋel galmaaji diyam yaarata to yiɗi. Den bo, janŋinooɓe pewe majjintaa en e ƴoyre mum. ");
INSERT INTO fue_vpl VALUES ("EP4_15","079_4_15","EPH","4","15","15","Amma to een bata gooŋa e yidde, en mawnan der huune fu, een poonnorii Almasiihu laatiiɗo hooreejo. ");
INSERT INTO fue_vpl VALUES ("EP4_16","079_4_16","EPH","4","16","16","Diga e makko nun jokkule ɓannu fu jogontirii. To jokkulal fu e waɗa golle mum, den ɓannu mawnan, yaha yeeso der yidde. ");
INSERT INTO fue_vpl VALUES ("EP4_17","079_4_17","EPH","4","17","17","Mii bata on, mii batitoo e inne Joomiraawo, to on nyaamee goonki mon hande heeferɓe, ɓe miilooji mum majjinta ɗum. ");
INSERT INTO fue_vpl VALUES ("EP4_18","079_4_18","EPH","4","18","18","Hakkillo maɓɓe niɓɓii, ɓee boɗɗodii yonki ki Alla hokkata. Ɓe galaa annal, ko ɓerɗe maɓɓe e yoori. ");
INSERT INTO fue_vpl VALUES ("EP4_19","079_4_19","EPH","4","19","19","Ɓe annaa suttontirgo ko wooɗi e ko halli, ɓee nyaama goonki maɓɓe no ɓe pakkiri fu, ɓee gaɗa ko ɓerɗe maɓɓe yiɗi. ");
INSERT INTO fue_vpl VALUES ("EP4_20","079_4_20","EPH","4","20","20","Amma onon, kanjum bane janŋinaɗon e Almasiihu. ");
INSERT INTO fue_vpl VALUES ("EP4_21","079_4_21","EPH","4","21","21","On nanii habaru makko, on janŋinaama gooŋa gonuka e makko. ");
INSERT INTO fue_vpl VALUES ("EP4_22","079_4_22","EPH","4","22","22","To non, ɓortee jikku mooɗon ŋu gonunoɗon e muuɗum. Kanjum woni suunooji ɓannu kalkooji yonkiiji mooɗon. ");
INSERT INTO fue_vpl VALUES ("EP4_23","079_4_23","EPH","4","23","23","Accee Ruuhu Alla laatina yonki mooɗon e hakkillo mooɗon kesum. ");
INSERT INTO fue_vpl VALUES ("EP4_24","079_4_24","EPH","4","24","24","Ɓornee jikku kesu ŋu Alla tagi dow nandi mum heɓa gonoɗon no foonnitorii e no laaɓiri, ƴiwuɗum diga e gooŋa. ");
INSERT INTO fue_vpl VALUES ("EP4_25","079_4_25","EPH","4","25","25","Ton non, accee batugo fewre, moy mon fu bata bannun gooŋa, gam en fu, en laati nun jokkule ɓannu gootol. ");
INSERT INTO fue_vpl VALUES ("EP4_26","079_4_26","EPH","4","26","26","To mone waɗii on, to on gaɗee hakke. To on accee mone waɗa on faa naaŋe yana. ");
INSERT INTO fue_vpl VALUES ("EP4_27","079_4_27","EPH","4","27","27","To on kokkee Seyɗan laawol der mooɗon baa seɗɗa. ");
INSERT INTO fue_vpl VALUES ("EP4_28","079_4_28","EPH","4","28","28","Bujjannooɗo acca guyka mum, waɗa golle geete e semme ɓannu mum, gam heɓa ko wallirta wooduɓe haaje. ");
INSERT INTO fue_vpl VALUES ("EP4_29","079_4_29","EPH","4","29","29","Haanay haalaaji bonɗi e wurtoo diga e kunnuɗe mooɗon. Ko haani gaɗon woni, baton haalaaji nafooji, cemmiɗinooji goonɗinki woɓɓe, gam kettinaniiɓe on nana ko nafata ɗum. ");
INSERT INTO fue_vpl VALUES ("EP4_30","079_4_30","EPH","4","30","30","To on mettinee ɓerne Ruuhu Ceniiɗo mo Alla maanorii on, gam o rinɗina on nyalaane darŋal. ");
INSERT INTO fue_vpl VALUES ("EP4_31","079_4_31","EPH","4","31","31","Ikkinee ko haaɗi e gayŋu, e mone, e palmooje, e jennooje e huune ko halli fu caka mooɗon. ");
INSERT INTO fue_vpl VALUES ("EP4_32","079_4_32","EPH","4","32","32","Gaɗontiree ko wooɗi hakkune mon. Jurmontiree, moy fu yaafanoo bannun, hande no Alla yaaforanii on, sabbu kawtal mon e Yeesu Almasiihu. ");
INSERT INTO fue_vpl VALUES ("EP5_1","079_5_1","EPH","5","1","1","Jooni on laatike ɓiɓɓe Alla yiɗaaɓe, gam majjum, yemminee mo. ");
INSERT INTO fue_vpl VALUES ("EP5_2","079_5_2","EPH","5","2","2","Yidde ardanoo goonki mon, hande no ɗum laatii e Almasiihu. O yiɗii en, faa o hokki yonki makko gam meeɗen. O laatake sadaka e kiisaaɗum pottanɗum Alla. ");
INSERT INTO fue_vpl VALUES ("EP5_3","079_5_3","EPH","5","3","3","On laatike himɓe Alla. Gam majjum haanay jeenu, e coɓuɗum fu, e suuno, batanee caka mon. ");
INSERT INTO fue_vpl VALUES ("EP5_4","079_5_4","EPH","5","4","4","Hande non bo, haanay haalaaji centiniiɗi, ɗi walaa hoore, e haalaaji baanji baanji, nanee caka mooɗon. Ko haani wurtoo e kunnuɗe mooɗon woni, jetton Alla. ");
INSERT INTO fue_vpl VALUES ("EP5_5","079_5_5","EPH","5","5","5","E haani paamon faa wooɗa: Jeenooɓe e soɓuɓe e suunaaɓe, gam suuno laati nun saafugo tooruure, ɓee ɗon fu walaa geɗu der Laamaare Almasiihu e Alla. ");
INSERT INTO fue_vpl VALUES ("EP5_6","079_5_6","EPH","5","6","6","To on accee goɗɗo majjina on e haalaaji baanji baanji, gam iri majjum nun waddata mone Alla dow saliiɓe ɗowtanaago mo. ");
INSERT INTO fue_vpl VALUES ("EP5_7","079_5_7","EPH","5","7","7","Sabbu majjum, to on kawtee e himɓe iri maɓɓe. ");
INSERT INTO fue_vpl VALUES ("EP5_8","079_5_8","EPH","5","8","8","Aran, der niwre gonunoɗon, amma jooni, gam kawtal mooɗon e Joomiraawo, on naati e jayŋol. To non, buuree hande ɓiɓɓe jayŋol. ");
INSERT INTO fue_vpl VALUES ("EP5_9","079_5_9","EPH","5","9","9","Gam ko jayŋol rimata woni: geetaaku e foonnitaare e gooŋa fu. ");
INSERT INTO fue_vpl VALUES ("EP5_10","079_5_10","EPH","5","10","10","Liinyee ko fottanta Joomiraawo. ");
INSERT INTO fue_vpl VALUES ("EP5_11","079_5_11","EPH","5","11","11","To on gattee juuɗe mon e golle gaɗeteeɗe der niwre, ɗe walaa nafuwe, amma cumpitee ɗe. ");
INSERT INTO fue_vpl VALUES ("EP5_12","079_5_12","EPH","5","12","12","Ko himɓe ɓen waɗata e suuɗe, baa batugo ɗum e sentinii. ");
INSERT INTO fue_vpl VALUES ("EP5_13","079_5_13","EPH","5","13","13","Amma to huune sumpitaama, jayŋol hollitan no ɗum laatii. ");
INSERT INTO fue_vpl VALUES ("EP5_14","079_5_14","EPH","5","14","14","Huune ko wurtii fu, laatoto jayŋol. Gam majjum acci e wi'ee: «Finu e ɗoyŋol maa, an ɗaaniiɗo! Umma hakkune maayɓe, Almasiihu yaynante jayŋol mum.» ");
INSERT INTO fue_vpl VALUES ("EP5_15","079_5_15","EPH","5","15","15","Gam majjum, kakkilanee yaadu mon dow no gonirton, to on laatee hande ɓe galaa hakkillo, amma laatee hakkilɓe. ");
INSERT INTO fue_vpl VALUES ("EP5_16","079_5_16","EPH","5","16","16","To on majjinee wakkati, gam nyalaaɗe ɗe gonuɗen e mum jooni e halli. ");
INSERT INTO fue_vpl VALUES ("EP5_17","079_5_17","EPH","5","17","17","Gam majjum, to on laatee ɓe walaa hakkillo, amma paamee ko Joomiraawo yiɗi. ");
INSERT INTO fue_vpl VALUES ("EP5_18","079_5_18","EPH","5","18","18","To on accee bagi doƴƴa on, gam eɗam watta himɓe der hallumaru, amma, kebbee Ruuhu Ceniiɗo. ");
INSERT INTO fue_vpl VALUES ("EP5_19","079_5_19","EPH","5","19","19","Cemmiɗinontiree e jimi jabuuraaji e jettooje, e jimi ruuhunkeeji. Jimanee Joomiraawo, maantee mo e ɓerɗe mon fu. ");
INSERT INTO fue_vpl VALUES ("EP5_20","079_5_20","EPH","5","20","20","Jettee Alla Baaba wakkati fu e gam huune fu, e inne Joomiraawo meeɗen Yeesu Almasiihu. ");
INSERT INTO fue_vpl VALUES ("EP5_21","079_5_21","EPH","5","21","21","Moy mooɗon fu ɗowtano banniraawo mum gam teddingo Almasiihu. ");
INSERT INTO fue_vpl VALUES ("EP5_22","079_5_22","EPH","5","22","22","Onon rewɓe, ɗowtanee worɓe mooɗon hande no ɗowtorantoɗon Joomiraawo. ");
INSERT INTO fue_vpl VALUES ("EP5_23","079_5_23","EPH","5","23","23","Gam gorko nun laatii hooreejo dow debbo muuɗum, hande no Almasiihu laatorii hooreejo dow Eklesiya. Kanko woni kisinoowo Eklesiya, laatiika ɓannu makko. ");
INSERT INTO fue_vpl VALUES ("EP5_24","079_5_24","EPH","5","24","24","Hande no Eklesiya ɗowtorantoo Almasiihu, hande non debbo fu, haani ɗowtorano gorko mum, dow huune fu. ");
INSERT INTO fue_vpl VALUES ("EP5_25","079_5_25","EPH","5","25","25","Onon worɓe bo, jiɗee rewɓe mooɗon hande no Almasiihu yiɗiri eklesiya. O yiɗii ka, faa o hokki yonki makko gam makka, ");
INSERT INTO fue_vpl VALUES ("EP5_26","079_5_26","EPH","5","26","26","gam o loota ka e diyam, o laaɓina ka e haala makko. ");
INSERT INTO fue_vpl VALUES ("EP5_27","079_5_27","EPH","5","27","27","O waɗii ɗum, heɓa o darina ka yeeso makko e tedduŋal, ka laatoo ceniika, ka walaa aybe, ɗum bo tuuni, maa bo boofol gom, e huune ko nandi e mum fu. ");
INSERT INTO fue_vpl VALUES ("EP5_28","079_5_28","EPH","5","28","28","Hande non, haani worɓe yiɗira rewɓe mum, hande no ɓe jiɗiri ɓalli maɓɓe. Jiɗuɗo debbo mum, yiɗii hoore mum. ");
INSERT INTO fue_vpl VALUES ("EP5_29","079_5_29","EPH","5","29","29","Daɗey, goɗɗo meeɗay ko wanyi ɓannu mum. Amma oo nyaanna ŋol, oo hiinnoo ŋol, hande no Almasiihu waɗanta Eklesiya, ");
INSERT INTO fue_vpl VALUES ("EP5_30","079_5_30","EPH","5","30","30","gam enen nun laatii jokkule ɓannu makko. ");
INSERT INTO fue_vpl VALUES ("EP5_31","079_5_31","EPH","5","31","31","Kan waɗi dewtere wi'i: «Gorko accan baaba mum e inna mum, takkontira e debbo mum, ɓe fu ɗiɗo, ɓe laatoo ɓannu gootol.» ");
INSERT INTO fue_vpl VALUES ("EP5_32","079_5_32","EPH","5","32","32","Asiiri mawɗo nun ɗon. Amma, Almasiihu e Eklesiya mum nun batananmi. ");
INSERT INTO fue_vpl VALUES ("EP5_33","079_5_33","EPH","5","33","33","Amma onon ko yaali on woni, gorko fu yiɗa debbo mum, hande no yiɗiri hoore mum. Debbo bo teddina gorum. ");
INSERT INTO fue_vpl VALUES ("EP6_1","079_6_1","EPH","6","1","1","Onon sukaaɓe, ɗowtanee saareeji mooɗon, gam sabbu Joomiraawo, kanjum laatii ko fotti. ");
INSERT INTO fue_vpl VALUES ("EP6_2","079_6_2","EPH","6","2","2","«Teddin baaba maa e inna maa.» Kanka woni umuroore arandeere, goodune alkawal. ");
INSERT INTO fue_vpl VALUES ("EP6_3","079_6_3","EPH","6","3","3","Den: «a heɓan barke, balɗe maa juuta der duuniyaaru,» kan woni alkawal ŋal. ");
INSERT INTO fue_vpl VALUES ("EP6_4","079_6_4","EPH","6","4","4","Onon saareeji, to on mettinee ɓerɗe sukaaɓe mooɗon, amma, eltee ɓe, oon ekkitina ɓe laawol Joomiraawo hande no haani. ");
INSERT INTO fue_vpl VALUES ("EP6_5","079_6_5","EPH","6","5","5","Onon maccuɓe, ɗowtanee joomiraaɓe mooɗon ɓe duuniyaaru ɗo, e kulol e diwnugo, e ɓerɗe laaɓuɗe, hande no ɗowtorantoɗon Almasiihu. ");
INSERT INTO fue_vpl VALUES ("EP6_6","079_6_6","EPH","6","6","6","Ɗowtanee ɓe, hinaa yeeso maɓɓe tan, gam fottango ɓe. Amma ɗowtanee ɓe gam on maccuɓe Almasiihu, waɗooɓe ko Alla yiɗi e ɓerɗe goote. ");
INSERT INTO fue_vpl VALUES ("EP6_7","079_6_7","EPH","6","7","7","Jagganee ɓe e seyo, hande Joomiraawo nun jaggantoɗon, himɓe bane. ");
INSERT INTO fue_vpl VALUES ("EP6_8","079_6_8","EPH","6","8","8","Gam oon anni neɗɗo fu gaɗuɗo ko wooɗi, heɓan riiba majjum to Joomiraawo, baa to oo dimo, ɗum bo maccuɗo. ");
INSERT INTO fue_vpl VALUES ("EP6_9","079_6_9","EPH","6","9","9","Onon joomiraaɓe bo, jogoree non maccuɓe mooɗon. Accee nyaasitaago ɓe. Annitee, onon e maɓɓe fu, Joomiraawo gooto gooduɗon dow kammu, o ɓurontirtaa bo himɓe. ");
INSERT INTO fue_vpl VALUES ("EP6_10","079_6_10","EPH","6","10","10","Ko horii wi'ugo on woni: Accee baawɗe Joomiraawo mawɗe semmiɗina on. ");
INSERT INTO fue_vpl VALUES ("EP6_11","079_6_11","EPH","6","11","11","Ettee kaɓirɗum ɗum Alla hokki on fu, gam baawon daraago yeeso dabareeji Seyɗan. ");
INSERT INTO fue_vpl VALUES ("EP6_12","079_6_12","EPH","6","12","12","Gam e himɓe bane kaɓidinten, amma e ruuhuuji kalluɗi, tawaaɗi dow kammu, gooduɗi baawɗe e semme, e laamanii duuniyaaru nu niwre. ");
INSERT INTO fue_vpl VALUES ("EP6_13","079_6_13","EPH","6","13","13","Gam majjum, ettee kaɓirɗum ɗum Alla fu, gam baawon ko darii to nyalaaɗe kalluɗe warii, keɓon semme ɓaawo to hawre heennyii. ");
INSERT INTO fue_vpl VALUES ("EP6_14","079_6_14","EPH","6","14","14","To non, ummee daree. Kaɓɓee gooŋa hande ɓelɓelol e punŋuli mooɗon. Ɓornee foonnitaare hande toggoore janni ne konu. ");
INSERT INTO fue_vpl VALUES ("EP6_15","079_6_15","EPH","6","15","15","Tinnaare waajaago linjiila ka jam laatoo paɗe mooɗon. ");
INSERT INTO fue_vpl VALUES ("EP6_16","079_6_16","EPH","6","16","16","Wakkati fu, jogee goonɗinki hande taɓɓorɗum kure. E makki nyifirton kure Ibiliisa ɗe yiite. ");
INSERT INTO fue_vpl VALUES ("EP6_17","079_6_17","EPH","6","17","17","Kuunee kisidam hande huuneere janni, jogee haala Alla hande kaafahi ki Ruuhu Ceniiɗo hokkata. ");
INSERT INTO fue_vpl VALUES ("EP6_18","079_6_18","EPH","6","18","18","Wakkati fu gaɗee du'aaje feere feere. Eelee ballal Alla hande no Ruuhu Ceniiɗo hollitirta on. Deenee e tinnaare! To on accee du'anaago himɓe Alla. ");
INSERT INTO fue_vpl VALUES ("EP6_19","079_6_19","EPH","6","19","19","Du'anee am min bo, gam Alla hokkammi boliiɗe pottuɗe, mi anninira e cuusal, gooŋa cuuɗiika der linjiila. ");
INSERT INTO fue_vpl VALUES ("EP6_20","079_6_20","EPH","6","20","20","Kanka nun laatiimi lilaaɗo mum, mii haɓɓiraa callalluuji. Du'anee am, gam mi waawa ko waajii ka e cuusal, hande no haaniri. ");
INSERT INTO fue_vpl VALUES ("EP6_21","079_6_21","EPH","6","21","21","Mii yiɗi onon bo, annon no gonirmi e ko gaɗanmi. Gam majjum, Tikikus banniraawo meeɗen jiɗaaɗo, gollantooɗo Joomiraawo e hoolaare, humpitan on habaru am fu. ");
INSERT INTO fue_vpl VALUES ("EP6_22","079_6_22","EPH","6","22","22","Mii lila mo e mooɗon, gam annon no men goniri, o fukkina hakkillo mooɗon. ");
INSERT INTO fue_vpl VALUES ("EP6_23","079_6_23","EPH","6","23","23","Banniraaɓe, Alla Baaba, e Yeesu Almasiihu Joomiraawo, hokka on jam e yidde, o hokka on goonɗinki bo. ");
INSERT INTO fue_vpl VALUES ("EP6_24","079_6_24","EPH","6","24","24","Yiɗuɓe Joomiraawo meeɗen Yeesu Almasiihu fu, e yidde ne heennyataa, moƴƴere Alla laatanoo ɗum. ");
INSERT INTO fue_vpl VALUES ("PP1_1","080_1_1","PHP","1","1","1","Min Pol e Timote, maccuɓe Yeesu Almasiihu, winnani seniiɓe hawtuɓe e Yeesu Almasiihu wonɓe Filippi ɗerewol ŋol, e onon ardiiɓe e gollotooɓe der eklesiya. ");
INSERT INTO fue_vpl VALUES ("PP1_2","080_1_2","PHP","1","2","2","Alla Baaba e Joomiraawo meeɗen Yeesu Almasiihu hokka on moƴƴere e jam! ");
INSERT INTO fue_vpl VALUES ("PP1_3","080_1_3","PHP","1","3","3","Mii yetta Alla am de ciwtormi on fu. ");
INSERT INTO fue_vpl VALUES ("PP1_4","080_1_4","PHP","1","4","4","Wakkati du'antoomi on on fu, e ɓerne welne du'ortoomi, ");
INSERT INTO fue_vpl VALUES ("PP1_5","080_1_5","PHP","1","5","5","diga nyalaane arandeere faa jooni, on darorake am, on ballii am waajaago linjiila. ");
INSERT INTO fue_vpl VALUES ("PP1_6","080_1_6","PHP","1","6","6","Mii tabbitini, Alla puɗɗuɗo golle muuɗum booɗuɗe der mooɗon hebbinan ɗe, der nyalaane Yeesu Almasiihu. ");
INSERT INTO fue_vpl VALUES ("PP1_7","080_1_7","PHP","1","7","7","E fotti, mii woodi miilooji ɗii dow mon on fu, gam mii watti on der ɓerne am. Gam baa no kaɓɓaami callalluuji gam mi seedanake linjiila tabbitinmi ka, on darorake am, on kawtii e am der moƴƴere ne. ");
INSERT INTO fue_vpl VALUES ("PP1_8","080_1_8","PHP","1","8","8","Alla woni seedeejo am, mii yiɗi on on fu e yidde Yeesu Almasiihu. ");
INSERT INTO fue_vpl VALUES ("PP1_9","080_1_9","PHP","1","9","9","Ko eelananmi on Alla woni, ɓeydoɗon yeeso yeeso, dow yidde, e dow annal, e suttontirgo gooŋa e fewre, ");
INSERT INTO fue_vpl VALUES ("PP1_10","080_1_10","PHP","1","10","10","gam baawon annitingo ko ɓuri nafugo, laatoɗon laaɓuɓe, ɓe galaa gacce der nyalaane Almasiihu wittoyta. ");
INSERT INTO fue_vpl VALUES ("PP1_11","080_1_11","PHP","1","11","11","On kebbinaama ɓiɓɓe foonnitaare ƴiwuɗe diga e Yeesu Almasiihu, gam inne Alla teddinee, yettee. ");
INSERT INTO fue_vpl VALUES ("PP1_12","080_1_12","PHP","1","12","12","Banniraaɓe, mii yiɗi, annon ɗum ɗo: ko heɓimmi walli linjiila yahugo yeeso. ");
INSERT INTO fue_vpl VALUES ("PP1_13","080_1_13","PHP","1","13","13","Himɓe hiitorde wuro laamiiɗo, e woɓɓe, e nokku fu e anni no gam Almasiihu nun maɓɓaami der kasu. ");
INSERT INTO fue_vpl VALUES ("PP1_14","080_1_14","PHP","1","14","14","Maɓɓol am accii banniraaɓe ɗuuɓɓe ɓeydii hoolaago Joomiraawo, ɓe accii hulugo, ɓe ɓeydi cuusal dow waajaago haala Alla. ");
INSERT INTO fue_vpl VALUES ("PP1_15","080_1_15","PHP","1","15","15","E gooŋa, woodi waajotooɓe habaru Almasiihu gam nawniraagu e jeddi, amma e woodi waajortooɓe e miilooji booɗuɗi. ");
INSERT INTO fue_vpl VALUES ("PP1_16","080_1_16","PHP","1","16","16","Ɓee ɗo e waɗa ɗum gam ɓee jiɗi Almasiihu, ɓee anni mi yowanaama haɓango linjiila. ");
INSERT INTO fue_vpl VALUES ("PP1_17","080_1_17","PHP","1","17","17","Amma ɓee to, e waajo habaru Almasiihu gam nawniraagu, miilooji maɓɓe bo laaɓaa, kade bo, ɓee daarta ɓeydugo toora callalluuji am der kasu. ");
INSERT INTO fue_vpl VALUES ("PP1_18","080_1_18","PHP","1","18","18","No ɓe baajori fu, ɗum ɓillataa am! to yiɗi anniyaaji maɓɓe laatoo bonɗi maa bo booɗuɗi, anni inne Almasiihu waajee tan, mii seyii, mi seyoto bo kade. ");
INSERT INTO fue_vpl VALUES ("PP1_19","080_1_19","PHP","1","19","19","Gam mii anni heennyitirde toora kan laatoto kisidam am, gam sabbu du'aaje mooɗon, e ballal Ruuhu Yeesu Almasiihu. ");
INSERT INTO fue_vpl VALUES ("PP1_20","080_1_20","PHP","1","20","20","Mii heɗii sanne, mii woodi bo tammuwe, mi heɓataa senteene goɗɗum. Amma hande no baadey, nun jooni bo, mii anni mi teddinan Almasiihu e tinnaare, der gurnam am, baa to mii wuuri, baa to mi maayi. ");
INSERT INTO fue_vpl VALUES ("PP1_21","080_1_21","PHP","1","21","21","Min kan, Almasiihu woni gurnam am, maayde laatani am nun riiba, ");
INSERT INTO fue_vpl VALUES ("PP1_22","080_1_22","PHP","1","22","22","amma, to wonaago am e duuniyaaru waddanan am waɗugo golle nafooje, den mi annaa du ume nun cuɓanmi. ");
INSERT INTO fue_vpl VALUES ("PP1_23","080_1_23","PHP","1","23","23","Mii waɗa ɓerɗe ɗiɗi: ko jiɗumi woni, mi yaha mi wonda e Almasiihu, kanjum ɓuranimmi wooɗugo. ");
INSERT INTO fue_vpl VALUES ("PP1_24","080_1_24","PHP","1","24","24","Amma gonki am e duuniyaaru ɓuran nafugo on. ");
INSERT INTO fue_vpl VALUES ("PP1_25","080_1_25","PHP","1","25","25","Mii hoolii, mii anni mi wonoto e duuniyaaru taw, mi wonda e mooɗon on fu, gam ɓeydoɗon yeeso, ɓerɗe mooɗon wela gam goonɗinki, ");
INSERT INTO fue_vpl VALUES ("PP1_26","080_1_26","PHP","1","26","26","hande nun, to mi wittoy to mooɗon, daliila juroraago kawtal mon e Yeesu Almasiihu ɓeydoto. ");
INSERT INTO fue_vpl VALUES ("PP1_27","080_1_27","PHP","1","27","27","Amma, sey no gonirɗon fotta e linjiila Almasiihu, gam to mi warii daarugo on, naa bo to mi waray, mi nana oon tabitii der hakkillo wooto, oon kaɓa gam goonɗinki linjiila e ɓerɗe goote, ");
INSERT INTO fue_vpl VALUES ("PP1_28","080_1_28","PHP","1","28","28","to on accee wayɓe huunna on baa seɗɗa, kanjum hollitinta seedaaku halkere maɓɓe, amma onon, kisidam mooɗon, ɗum fu diga to Alla ɗum ƴiwi. ");
INSERT INTO fue_vpl VALUES ("PP1_29","080_1_29","PHP","1","29","29","On kokkaama moƴƴere goonɗingo Almasiihu, kanjum tan bane, on kokkaama bo moƴƴere tooranaago mo, ");
INSERT INTO fue_vpl VALUES ("PP1_30","080_1_30","PHP","1","30","30","e daranaago hawre woore ne ji'uɗon mii haɓa, e ne nanoton kade mii haɓa faa jooni. ");
INSERT INTO fue_vpl VALUES ("PP2_1","080_2_1","PHP","2","1","1","Almasiihu deƴƴitinii ɓerɗe mooɗon, semmiɗini on der yidde, oon kawti e Ruuhu, oon goodi yurmeene e enɗam, naa noy? ");
INSERT INTO fue_vpl VALUES ("PP2_2","080_2_2","PHP","2","2","2","To non kan, kebbinee seyo am e laataago gootum hakkune mooɗon: yidde mooɗon, e ɓerɗe mooɗon, e miilo mooɗon laatoo gootum. ");
INSERT INTO fue_vpl VALUES ("PP2_3","080_2_3","PHP","2","3","3","To on gaɗee goɗɗum e miilooji ɓurontiro, naa bo e manŋu hoore; amma leesinee ko'e mon, moy mon fu daara woɓɓe hande ɓuruɓe ɗum. ");
INSERT INTO fue_vpl VALUES ("PP2_4","080_2_4","PHP","2","4","4","To goɗɗo mooɗon daarta ko nafata ɗum tan, amma daarta ko nafata woɓɓe bo. ");
INSERT INTO fue_vpl VALUES ("PP2_5","080_2_5","PHP","2","5","5","Goodee hakkune mon, miilo ŋo Yeesu Almasiihu woodunoo. ");
INSERT INTO fue_vpl VALUES ("PP2_6","080_2_6","PHP","2","6","6","Kanko potidinɗo e Alla diga fuɗɗoode, e non fu, o daaray fotugo makko e Alla hande huune ko o jogitinto, ");
INSERT INTO fue_vpl VALUES ("PP2_7","080_2_7","PHP","2","7","7","amma o ɓuyti hoore makko, o etti jayri maccuɗo, o nandi e himɓe, o tawaama oo laatii neɗɗo deydey. ");
INSERT INTO fue_vpl VALUES ("PP2_8","080_2_8","PHP","2","8","8","O leesinii hoore makko, o ɗowtanii Alla faa o maayi, o maayi dow leggal palaaŋal. ");
INSERT INTO fue_vpl VALUES ("PP2_9","080_2_9","PHP","2","9","9","Gam majjum, Alla etti mo faa dow, hokki mo inne ɓurne inɗe fu manŋu, ");
INSERT INTO fue_vpl VALUES ("PP2_10","080_2_10","PHP","2","10","10","gam to inne Yeesu noddaama, doole himɓe fu jiccoo dow kammu e dow leydi, e der leydi fu, ");
INSERT INTO fue_vpl VALUES ("PP2_11","080_2_11","PHP","2","11","11","kade bo himɓe fu batan wi'a, Yeesu Almasiihu woni Joomiraawo, gam inne Alla Baaba teddinee. ");
INSERT INTO fue_vpl VALUES ("PP2_12","080_2_12","PHP","2","12","12","Gam majjum, banniraaɓe am yiɗaaɓe, hande no ɗowtoriɗon wakkati fu, hande nun, gaɗee kolliton kisidam mooɗon e kulol e diwnugo, hinaa to mii wondi e mooɗon tan, amma baa no mii boɗɗodii on bo. ");
INSERT INTO fue_vpl VALUES ("PP2_13","080_2_13","PHP","2","13","13","Gam Alla e hoore mum nun gollata der mooɗon, faa jiɗon ko weli mo, gaɗon ɗum bo. ");
INSERT INTO fue_vpl VALUES ("PP2_14","080_2_14","PHP","2","14","14","Ko gaɗoton fu, to on dumbitee, to on kaɓee bo, ");
INSERT INTO fue_vpl VALUES ("PP2_15","080_2_15","PHP","2","15","15","gam laatoɗon ɓe walaa gacce, laaɓuɓe, ɓiɓɓe Alla ɓe walaa ko elee, wonɓe der jaamanuuru biisiinu, oonyiinu, laatoɗon yaynooɓe der duuniyaaru hande fitillaaji. ");
INSERT INTO fue_vpl VALUES ("PP2_16","080_2_16","PHP","2","16","16","Oon baajoo ɓe haala ka yonki gam mi juro der nyalaane wittoygo Almasiihu, mi anna doggudu am e comuri am waɗay baanji. ");
INSERT INTO fue_vpl VALUES ("PP2_17","080_2_17","PHP","2","17","17","Golle mooɗon laatake hande dokkal goonɗinki mon. Baa to ƴiiƴam am reƴƴitake dow dokkal mooɗon, mii seyorii ɗum, mii seyorii on bo on fu. ");
INSERT INTO fue_vpl VALUES ("PP2_18","080_2_18","PHP","2","18","18","Hande non onon bo, ceyee, ceyodee e am. ");
INSERT INTO fue_vpl VALUES ("PP2_19","080_2_19","PHP","2","19","19","To Joomiraawo Yeesu jaɓii, ɓooytaa mi lilan Timote to mooɗon, gam min bo, mi heɓa habaruuji mooɗon ɗi o waddanoytammi, ɗi cemmiɗinammi, ");
INSERT INTO fue_vpl VALUES ("PP2_20","080_2_20","PHP","2","20","20","gam mi walaa goɗɗo jiɗuɗo on hande am, paaliiɗo on e gooŋa, to hinaa kanko, ");
INSERT INTO fue_vpl VALUES ("PP2_21","080_2_21","PHP","2","21","21","horiiɓe fu haaje mum tan miijantoo, hinaa ɗum Yeesu Almasiihu. ");
INSERT INTO fue_vpl VALUES ("PP2_22","080_2_22","PHP","2","22","22","Oon anni Timote hollitii oo laatii koolaaɗo, o gollodake e am gam waaji linjiila hande no ɓiɗɗo gollorantoo baaba mum. ");
INSERT INTO fue_vpl VALUES ("PP2_23","080_2_23","PHP","2","23","23","Kanko miilumi lilugo to mooɗon law, to mi annii no haala am laatortoo. ");
INSERT INTO fue_vpl VALUES ("PP2_24","080_2_24","PHP","2","24","24","Mii hooli Joomiraawo, ɗo e yeeso seɗɗa, min e hoore am mi waran to mooɗon. ");
INSERT INTO fue_vpl VALUES ("PP2_25","080_2_25","PHP","2","25","25","Amma mi tawi e haani mi lila banniraawo am Epaforoditus, gollodiiɗo am, e wallitammi hawre, kanko lilunoɗon to am gam o wallammi huuntugo haaje am. ");
INSERT INTO fue_vpl VALUES ("PP2_26","080_2_26","PHP","2","26","26","Emo humpaa on booɗum on fu, kade bo o toorakeno sanne no nanuɗon emo nyawi. ");
INSERT INTO fue_vpl VALUES ("PP2_27","080_2_27","PHP","2","27","27","E gooŋa, o nyawiino sanne faa o ɓadii maayugo, amma Alla yurmake mo, kanko tan bane Alla yurmii, baa min Alla yurmake am, gam to mi heɓu biisere ɓerne dow biisere ɓerne. ");
INSERT INTO fue_vpl VALUES ("PP2_28","080_2_28","PHP","2","28","28","Kan waɗi, jiɗum lilugo mo law to mooɗon, gam ɓerɗe mooɗon wela e yi'ugo mo, min bo, biisere ɓerne am ɓuytoo. ");
INSERT INTO fue_vpl VALUES ("PP2_29","080_2_29","PHP","2","29","29","Cilminee mo e inne Joomiraawo e seyo manŋo. Teddinee himɓe hande makko, ");
INSERT INTO fue_vpl VALUES ("PP2_30","080_2_30","PHP","2","30","30","gam der golle Almasiihu o ɓadino maayugo, o hokkii yonki makko der kaliire gam o hebbita ko on baaway wallugo am waɗugo. ");
INSERT INTO fue_vpl VALUES ("PP3_1","080_3_1","PHP","3","1","1","Banniraaɓe am, ko horii wi'ugo on woni: Ceyoree Joomiraawo. Mi somataa maytitaago goota kan der binni am, gam kanjum tabbitinta faamu mooɗon. ");
INSERT INTO fue_vpl VALUES ("PP3_2","080_3_2","PHP","3","2","2","Kakkilanee himɓe nanduɓe e dawaaɗi, e gollotooɓe halluɓe, jeeƴanɓe on juulnaago! ");
INSERT INTO fue_vpl VALUES ("PP3_3","080_3_3","PHP","3","3","3","Gam enen woni julniiɓe e gooŋa, enen saafirooɓe Alla e Ruuhu, jurortooɓe Yeesu Almasiihu, ɓe koolaaki ko'e mum. ");
INSERT INTO fue_vpl VALUES ("PP3_4","080_3_4","PHP","3","4","4","Min e hoore am, mi waawanno yowugo hoolaare am dow gaɗu ɓannu. Woɓɓe e miili waawan hoolaago hoore mum, hakko min. ");
INSERT INTO fue_vpl VALUES ("PP3_5","080_3_5","PHP","3","5","5","Mii julnaaɗo nyaanne jeetatawre, mii Isira'iilaajo ƴiwuɗo e lenyol Benyamin, mii Iburaninkeejo ɓii Iburaninkeejo. Dow wecco tawreeta, mii Farisaajo, ");
INSERT INTO fue_vpl VALUES ("PP3_6","080_3_6","PHP","3","6","6","ko yaalani tinnaare, mi tooriino eklesiya, dow wecco foonnitaare ko tawaa der sariya, mi walaa gacce. ");
INSERT INTO fue_vpl VALUES ("PP3_7","080_3_7","PHP","3","7","7","Ɗum ɗon fu daarunoomi hande riiba, amma jooni mi daarii ɗum baanji gam Almasiihu. ");
INSERT INTO fue_vpl VALUES ("PP3_8","080_3_8","PHP","3","8","8","E gooŋa, mi daarii huune fu baanji, gam mi heɓii ko ɓuri ɗum teddugo, kan woni annugo Yeesu Almasiihu Joomiraawo am. Gam makko, mi majjinii huune fu, daarumi ɗum hande buuri, gam mi heɓa mo, ");
INSERT INTO fue_vpl VALUES ("PP3_9","080_3_9","PHP","3","9","9","mi tawee e makko, hinaa e foonnitaare ƴiwune diga ɗowtanaago tawreeta, amma e foonnitaare ƴiwune diga goonɗingo Almasiihu, ne Alla hokkata goonɗinɓe. ");
INSERT INTO fue_vpl VALUES ("PP3_10","080_3_10","PHP","3","10","10","Min kan, sago am woni annugo Almasiihu e baawɗe pintol mum, mi heɓa geɗu am der toora makko faa mi nanda mo der maayde makko, ");
INSERT INTO fue_vpl VALUES ("PP3_11","080_3_11","PHP","3","11","11","gam no ɗum waɗi fu, min bo, mi heɓa yottaago nyalaane pintol maayɓe. ");
INSERT INTO fue_vpl VALUES ("PP3_12","080_3_12","PHP","3","12","12","Mi wi'ay mi heɓii ko keɓal am, naa bo mii kebbuɗo, amma emi jokki doggudu am gam mi happa ŋal law. Min e hoore am Yeesu Almasiihu happii am. ");
INSERT INTO fue_vpl VALUES ("PP3_13","080_3_13","PHP","3","13","13","Banniraaɓe am, min e hoore am, mi wi'ay mi happii ŋal ko, amma ko gaɗanmi nun: Emi yeggita ko yawti, mii foonnani ko woni yeeso, ");
INSERT INTO fue_vpl VALUES ("PP3_14","080_3_14","PHP","3","14","14","mii doggana heennyitirde gam mi heɓa riiba, noddoore ne Alla noddi en diga dow kammu gam kawtal men e Yeesu Almasiihu. ");
INSERT INTO fue_vpl VALUES ("PP3_15","080_3_15","PHP","3","15","15","To non en fu, enen ɓennuɓe der goonɗinki, sey gooden iri miilo ŋoo, amma dow gokka, to on goodi miilo wonŋo no paamirton, Alla hollan on ko haani. ");
INSERT INTO fue_vpl VALUES ("PP3_16","080_3_16","PHP","3","16","16","Amma to jottiɗen ɗo, sey tokken laawol ŋol jaheten e mum jooni. ");
INSERT INTO fue_vpl VALUES ("PP3_17","080_3_17","PHP","3","17","17","Banniraaɓe, on fu, yemminee am, daaree wa'uɓe hande no ji'uɗon emen laatii. ");
INSERT INTO fue_vpl VALUES ("PP3_18","080_3_18","PHP","3","18","18","Gam ɗuuɓɓe e yaha hande wayɓe leggal Almasiihu palaaŋal, mi batiino on ka de ɗuuɗɗum, jooni bo, mii batitoo on ka e bojji, ");
INSERT INTO fue_vpl VALUES ("PP3_19","080_3_19","PHP","3","19","19","heennyitirde maɓɓe laatoto halkere, deeɗi maɓɓe laatii tooruuje maɓɓe, ɓee juroro ko waddanta ɓe senteene, huune duuniyaaru tan ɓe miijanto. ");
INSERT INTO fue_vpl VALUES ("PP3_20","080_3_20","PHP","3","20","20","Amma enen, dow kammu jeyaɗen, diga ton keɗiɗen Kisinoowo men, Joomiraawo Yeesu Almasiihu wara. ");
INSERT INTO fue_vpl VALUES ("PP3_21","080_3_21","PHP","3","21","21","Kanko o waylitan ɓalli meeɗen centiniiɗi, o nandina ɗi e ɓannu makko tedduŋol, o waɗan ɗum diga e baawɗe kokkuɗe mo laamanaago huune fu. ");
INSERT INTO fue_vpl VALUES ("PP4_1","080_4_1","PHP","4","1","1","Gam majjum, banniraaɓe am yiɗaaɓe, mii woodi kumpa yi'ugo on sanne, onon laatii seyo am, e tuutawal am, tabitee hande nun der kawtal mon e Joomiraawo, onon yiɗaaɓe am. ");
INSERT INTO fue_vpl VALUES ("PP4_2","080_4_2","PHP","4","2","2","Mii wi'a Ewodi e Sintis ɓe gonda der hakkillo wooto gam Joomiraawo. ");
INSERT INTO fue_vpl VALUES ("PP4_3","080_4_3","PHP","4","3","3","An gollidoowo e am koolaaɗo, mii eelee ballaa rewɓe ɓen, ɓe gollidii e am gam waaju linjiila, kamɓe e Kelema e gollodiiɓe e am woɓɓe, inɗe maɓɓe winnaama der dewtere yonki. ");
INSERT INTO fue_vpl VALUES ("PP4_4","080_4_4","PHP","4","4","4","Wakkati fu, ceyee der kawtal mooɗon e Joomiraawo, mii batitoo ka kade, ceyee! ");
INSERT INTO fue_vpl VALUES ("PP4_5","080_4_5","PHP","4","5","5","Accee himɓe fu annita neɗɗaaku mooɗon. Joomiraawo ɓadake warugo. ");
INSERT INTO fue_vpl VALUES ("PP4_6","080_4_6","PHP","4","6","6","To on accee ɓerɗe mooɗon biisoo gam goɗɗum, amma huune fu kollee ɗum Alla. Du'ee, eelee, eelitee, jettee Alla. ");
INSERT INTO fue_vpl VALUES ("PP4_7","080_4_7","PHP","4","7","7","Jam Alla ɓuruɗum faamu fu, reena ɓerɗe mooɗon e miilooji mooɗon der kawtal mon e Yeesu Almasiihu. ");
INSERT INTO fue_vpl VALUES ("PP4_8","080_4_8","PHP","4","8","8","Banniraaɓe am, ko horii wi'ugo on woni, miilanee ko laatii gooŋa, ko foti teddineego, e poonnitiiɗum, e laaɓuɗum, e kaanuɗum yiɗeego, e ko manetee, e kaanuɗum yetteego, e ko haani maanteego. ");
INSERT INTO fue_vpl VALUES ("PP4_9","080_4_9","PHP","4","9","9","Ko janŋinmi on jaɓuɗon, nanuɗon, ji'uɗon e am, golloree ɗum, Alla mo jam wonda e mooɗon. ");
INSERT INTO fue_vpl VALUES ("PP4_10","080_4_10","PHP","4","10","10","Mii seyorii Joomiraawo sanne, gam on puɗɗitake miilango am. E gooŋa oon goodunoo miilooji ɗii dow am, amma on keɓayno laawol hollitingo ɗum. ");
INSERT INTO fue_vpl VALUES ("PP4_11","080_4_11","PHP","4","11","11","Hinaa gam dullere acci ko mii bata ka, gam mi ekkitake seyoraago no gonirmi fu. ");
INSERT INTO fue_vpl VALUES ("PP4_12","080_4_12","PHP","4","12","12","Mii waawi wonaago der dullere, mi waawan bo ko woni der keɓal. Der wakkatiiji fu e no ɗum laatii fu, mi ekkitake wonaago der haarande e rafo, der goonnan e dullere. ");
INSERT INTO fue_vpl VALUES ("PP4_13","080_4_13","PHP","4","13","13","Mi waawan ko waɗi huune fu, gam sabbu cemmiɗinoowo am. ");
INSERT INTO fue_vpl VALUES ("PP4_14","080_4_14","PHP","4","14","14","Amma e nun, on gaɗii ko wooɗi, no balluɗon am der toora am. ");
INSERT INTO fue_vpl VALUES ("PP4_15","080_4_15","PHP","4","15","15","Onon ɓe Filippi, oon anni no ƴiwumi Maseduwaan, der wakkati puɗɗumi waajaago linjiila, eklesiya gom hawtay e am dow hokkugo e jaɓugo, to hinaa onon, ");
INSERT INTO fue_vpl VALUES ("PP4_16","080_4_16","PHP","4","16","16","onon tan wallimmi, gam no jahumi Tesalonika, on lildii am ballal de ɗiɗi mi huntira haaje am. ");
INSERT INTO fue_vpl VALUES ("PP4_17","080_4_17","PHP","4","17","17","Ɗum wi'ay no ballal nun daartanmi, ko daartanmi woni, ɓikkon goonɗinki mooɗon ɓeydoo faa ɗuuɗa. ");
INSERT INTO fue_vpl VALUES ("PP4_18","080_4_18","PHP","4","18","18","Mi heɓi ballal mooɗon ŋal lilduɗon am fu e junŋo Epaforoditus, ŋal heƴii am faa ɓuri haaje am. Ŋal laatake hande wardi belɗo, hande sadaka, ɗum Alla jaɓi. ");
INSERT INTO fue_vpl VALUES ("PP4_19","080_4_19","PHP","4","19","19","Alla am huunta haajeeji mooɗon fu, jaka goonnan mum tedduŋal, ɗum waɗoo der kawtal mooɗon e Yeesu Almasiihu. ");
INSERT INTO fue_vpl VALUES ("PP4_20","080_4_20","PHP","4","20","20","Tedduŋal wonanoo Alla Baaba meeɗen faa abada, Aami! ");
INSERT INTO fue_vpl VALUES ("PP4_21","080_4_21","PHP","4","21","21","Cannee seniiɓe hawtuɓe e Yeesu Almasiihu. Banniraaɓe wonduɓe e am sannii on. ");
INSERT INTO fue_vpl VALUES ("PP4_22","080_4_22","PHP","4","22","22","Goonɗinɓe wonɓe ɗo fu sannii on, wonɓe der wuro Kaysara bo sannii on puy. ");
INSERT INTO fue_vpl VALUES ("PP4_23","080_4_23","PHP","4","23","23","Moƴƴere Joomiraawo men Yeesu Almasiihu wonda e mooɗon! ");
INSERT INTO fue_vpl VALUES ("CL1_1","081_1_1","COL","1","1","1","Min Pol, mii laatii lilaaɗo Yeesu Almasiihu e sago Alla. Min e banniraawo meeɗen Timote, ");
INSERT INTO fue_vpl VALUES ("CL1_2","081_1_2","COL","1","2","2","men cannii on onon himɓe Alla wonuɓe Koloosi, banniraaɓe men hoolaaɓe der kawtal mum e Almasiihu. Alla Baaba meeɗen waɗana on moƴƴere, hokka on jam! ");
INSERT INTO fue_vpl VALUES ("CL1_3","081_1_3","COL","1","3","3","Wakkati fu, emen du'anoo on, emen jetta Alla, Baaba Joomiraawo meeɗen Yeesu Almasiihu. ");
INSERT INTO fue_vpl VALUES ("CL1_4","081_1_4","COL","1","4","4","Men nanii habaru goonɗinki mooɗon dow Yeesu Almasiihu e batane, e yidde ne gooduɗon dow himɓe Alla fu. ");
INSERT INTO fue_vpl VALUES ("CL1_5","081_1_5","COL","1","5","5","Oon goodi ɗum gam oon keɗii ko Alla resani on dow kammu. Oon keɗii ko Alla resani on gam on nanii haala gooŋakuwa, ƴiwuka e linjiila. ");
INSERT INTO fue_vpl VALUES ("CL1_6","081_1_6","COL","1","6","6","Linjiila kan yottake on, e rima ɓikkon, e sankitoo, e laya der duuniyaaru fu. Hande non ɗum laatii to mooɗon onon bo, diga nyaanne nanuɗon, ko paamuɗon moƴƴere Alla e gooŋa. ");
INSERT INTO fue_vpl VALUES ("CL1_7","081_1_7","COL","1","7","7","Epafaras banniraawo amen jiɗaaɗo, gollodintooɗo e amen, waajike on haala moƴƴere nen. Oo laatii koolaaɗo, gollantooɗo Almasiihu caka mooɗon. ");
INSERT INTO fue_vpl VALUES ("CL1_8","081_1_8","COL","1","8","8","O batii men bo yidde ne Ruuhu Ceniiɗo watti der ɓerɗe mooɗon. ");
INSERT INTO fue_vpl VALUES ("CL1_9","081_1_9","COL","1","9","9","Gam majjum, menen bo, diga men nani ka, men accay du'anaago on. Emen eela Alla hokka on hakkillo fu e faamu ƴiwuŋu diga e Ruuhu mum. Den on kebban annal sago makko faa wooɗa. ");
INSERT INTO fue_vpl VALUES ("CL1_10","081_1_10","COL","1","10","10","Hande non, on buuran der goonki pottananki Joomiraawo der huune fu. On tabitinto waɗugo ko wooɗi feere feere, on ɓeydoto annugo Alla. ");
INSERT INTO fue_vpl VALUES ("CL1_11","081_1_11","COL","1","11","11","Emen eela Alla hokka on semme, e baawɗe mum tedduɗe, gam baawon tinnaago, e munyango huune fu. ");
INSERT INTO fue_vpl VALUES ("CL1_12","081_1_12","COL","1","12","12","Jettee Alla Baaba e seyo, gam o waɗii on fotuɓe heɓugo geɗu der moƴƴereeji ɗi o resani himɓe makko, gonuɗi der jayŋol. ");
INSERT INTO fue_vpl VALUES ("CL1_13","081_1_13","COL","1","13","13","Kanko teeti en e baawɗe niwre, naanni en der Laamaare Ɓiyiiko jiɗaaɗo. ");
INSERT INTO fue_vpl VALUES ("CL1_14","081_1_14","COL","1","14","14","O sooditake en, o yaafii hakkeeji meeɗen. ");
INSERT INTO fue_vpl VALUES ("CL1_15","081_1_15","COL","1","15","15","Ɓiɗɗo on nun laatii nandi Alla mo yi'ataake. Kanko woni afo, ɓuruɗo huune ko tagaa fu. ");
INSERT INTO fue_vpl VALUES ("CL1_16","081_1_16","COL","1","16","16","E makko Alla tagiri huune fu, ko woni dow kammu, e ko woni e leydi, ko yi'etee, e ko yi'ataake fu, laamuuji, e baawɗeeji, e semmeeji, e hoorejum fu, diga e makko ɗum fu ɗum tagaa, e gam makko bo. ");
INSERT INTO fue_vpl VALUES ("CL1_17","081_1_17","COL","1","17","17","Almasiihu na'on diga huune fu tagaaka, huune ko woni fu, diga e makko ɗum woni. ");
INSERT INTO fue_vpl VALUES ("CL1_18","081_1_18","COL","1","18","18","Kanko woni hooreejo Eklesiya laatiika ɓannu makko. Kanko woni fuɗɗoode, oo laatii arano dow fintooɓe diga maayde, gam o laatoo arano dow huune fu. ");
INSERT INTO fue_vpl VALUES ("CL1_19","081_1_19","COL","1","19","19","Gam ɗum fottanii Alla ko woni der mum fu wonoo der Almasiihu. ");
INSERT INTO fue_vpl VALUES ("CL1_20","081_1_20","COL","1","20","20","E Almasiihu nun o weldiniri huune fu e makko, ko woni dow kammu, e ko woni der leydi fu. O waddii jam, sabbu ƴiiƴam Almasiihu deƴƴitiiɗam dow leggal palaaŋal. ");
INSERT INTO fue_vpl VALUES ("CL1_21","081_1_21","COL","1","21","21","Naane, oon boɗɗodinoo e Alla, oon laatinoo wayɓe makko, gam miilooji mooɗon kalluɗi, e golle mooɗon bonɗe. ");
INSERT INTO fue_vpl VALUES ("CL1_22","081_1_22","COL","1","22","22","Amma jooni, Alla weldinii on e muuɗum diga e maayde Ɓiyiiko laatiiɗo neɗɗo, gam daroɗon yeeso makko oon laatii seniiɓe, laaɓuɓe, ɓe walaa gacce. ");
INSERT INTO fue_vpl VALUES ("CL1_23","081_1_23","COL","1","23","23","Amma, sey tiiɗon, daroɗon e semme der goonɗinki, laatoɗon ɓe dimmataako. To on boɗɗodee e linjiila, laatiika tammuwe meeɗen. Linjiila ka nanuɗon, waajaama der duuniyaaru ɗo. Min Pol, kanka nun laatiimi gollotooɗo mum. ");
INSERT INTO fue_vpl VALUES ("CL1_24","081_1_24","COL","1","24","24","Jooni, ɓerne am e weli gam tooraaji ɗi keɓammi gam mooɗon. Hande non, kebbiniranmi ko horii der tooraaji Almasiihu gam ɓannu mum, laatiiŋol eklesiya makko. ");
INSERT INTO fue_vpl VALUES ("CL1_25","081_1_25","COL","1","25","25","Eklesiya kan nun laatiimi gollotooɗo mum. Alla yowanii am golle waajaago on haala mum deydey no ka wa'i. ");
INSERT INTO fue_vpl VALUES ("CL1_26","081_1_26","COL","1","26","26","Kanjum woni asiiri cuuɗaninooɗo himɓe diga den, der jaamanuuji ɗuuɗɗi, amma jooni, Alla hollitii ɗum himɓe mum. ");
INSERT INTO fue_vpl VALUES ("CL1_27","081_1_27","COL","1","27","27","Gam Alla e yiɗi anningo himɓe ɓe lenyi janani manŋu asiiri mum tedduɗo. Asiiri on woni, Almasiihu na'on der mooɗon. Kanko hokki on tammuwe heɓugo geɗu der tedduŋal Alla. ");
INSERT INTO fue_vpl VALUES ("CL1_28","081_1_28","COL","1","28","28","Almasiihu on nun men piinata haala mum. Emen baajoo himɓe fu, emen janŋina ɓe e hakkillo fu, gam men jottina moy fu yeeso Alla e hebbi der kawtal mum e Almasiihu. ");
INSERT INTO fue_vpl VALUES ("CL1_29","081_1_29","COL","1","29","29","Kanjum acci mii golloo, mii haɓa diga e baawɗe Almasiihu gollotooɗe e semme der am. ");
INSERT INTO fue_vpl VALUES ("CL2_1","081_2_1","COL","2","1","1","Mii yiɗi anningo on hawre mawne ne kaɓammi gam mooɗon, e gam banniraaɓe meeɗen wonuɓe Lawdikiya, e woɓɓe ɓe meeɗay yi'ugo am e gite muuɗum fu. ");
INSERT INTO fue_vpl VALUES ("CL2_2","081_2_2","COL","2","2","2","Mii waɗa ɗum, gam ɓe keɓa cuusal, ɓe kawta der yidde, ɓe keewa hakkillo hebbuŋo, ɓe paama asiiri Alla cuuɗiiɗo, kan woni Almasiihu. ");
INSERT INTO fue_vpl VALUES ("CL2_3","081_2_3","COL","2","3","3","Der makko nun jawdi ni faamu e annal fu suuɗii. ");
INSERT INTO fue_vpl VALUES ("CL2_4","081_2_4","COL","2","4","4","Mi batii ka, gam to goɗɗo majjin on e haalaaji belɗi. ");
INSERT INTO fue_vpl VALUES ("CL2_5","081_2_5","COL","2","5","5","Ɓannu am e woɗɗodii on, amma hakkillo am e wondi e mooɗon. Ɓerne am e weli gam foonnitaare tawaane caka mooɗon, kade bo oon darii dow goonɗingo Almasiihu e semme. ");
INSERT INTO fue_vpl VALUES ("CL2_6","081_2_6","COL","2","6","6","Jooni, no on jaɓii Yeesu Almasiihu laatoo Joomiraawo mooɗon, tokkee mo. ");
INSERT INTO fue_vpl VALUES ("CL2_7","081_2_7","COL","2","7","7","Gaɗee ɗaɗi der makko, mahee goonki mon bo dow makko. Cemmiɗee der goonɗinki hande no janŋiniraɗon, jettee Alla puy. ");
INSERT INTO fue_vpl VALUES ("CL2_8","081_2_8","COL","2","8","8","Kakkilee gam to goɗɗo ƴoyra on e annal lugguŋal. Kakkilanee bo haalaaji majjinooji, ƴiwuɗi e tawaaŋal himɓe, naa bo e semmeeji duuniyaaru. E Almasiihu bane ɗum ƴiwi. ");
INSERT INTO fue_vpl VALUES ("CL2_9","081_2_9","COL","2","9","9","Gam ko woni der Alla fu e yi'oo der ɓannu Almasiihu. ");
INSERT INTO fue_vpl VALUES ("CL2_10","081_2_10","COL","2","10","10","Onon bo, on keɓii huune fu der kawtal mooɗon e makko, kanko laatii hooreejo laamuuji, e baawɗeeji fu. ");
INSERT INTO fue_vpl VALUES ("CL2_11","081_2_11","COL","2","11","11","Der kawtal mooɗon e Almasiihu, on keɓii juulneego. Amma juulnol ŋol himɓe waɗata bane. Juulnol ƴiwuŋol e Almasiihu nun. Ŋol laati nun hande moytugo baawɗe hakke jaaliiɗe ɓalli mooɗon. ");
INSERT INTO fue_vpl VALUES ("CL2_12","081_2_12","COL","2","12","12","Diga e batisi, on uwidaama e Almasiihu, on pintidinaama bo e makko, gam on goonɗinii baawɗe Alla pintinɗe mo e maayde. ");
INSERT INTO fue_vpl VALUES ("CL2_13","081_2_13","COL","2","13","13","Onon, on maayiino gam boofi mooɗon, e gam on juulnaaki. Amma Alla wuuridinii on e Almasiihu, yaafi boofi meeɗen fu. ");
INSERT INTO fue_vpl VALUES ("CL2_14","081_2_14","COL","2","14","14","O moytii ɗerewol nyamaane men, gaccotonoo ŋol en. O ikkinii ŋol, o tiggi dow leggal palaaŋal. ");
INSERT INTO fue_vpl VALUES ("CL2_15","081_2_15","COL","2","15","15","O ɓortii laamuuji, e baawɗeeji fu, o sentinii ɗi yeeso himɓe fu. Non Alla jaalorii ɗi e maayde Almasiihu. ");
INSERT INTO fue_vpl VALUES ("CL2_16","081_2_16","COL","2","16","16","Gam majjum, to on nootee goɗɗo gaccoo on dow ko nyaamoton e ko jaroton, ɗum bo dow hakkilango nyalaaɗe juulɗe, e lebbi, maa bo dow nyalaaɗe ciwteteeɗe. ");
INSERT INTO fue_vpl VALUES ("CL2_17","081_2_17","COL","2","17","17","Ɗum fu, kollitoojum ko waroyta nun, gooŋa majjum fu der Almasiihu nun woni. ");
INSERT INTO fue_vpl VALUES ("CL2_18","081_2_18","COL","2","18","18","To on accee waɗooɓe hande e ɓuyti ko'e mum, ko ɓee caafa malaykaaɓe majjina on. Koyɗaali maɓɓe ɓe tokkii, ɓee mawnito dow baanji, gam miilooji maɓɓe ɓe tokkii. ");
INSERT INTO fue_vpl VALUES ("CL2_19","081_2_19","COL","2","19","19","Ɓe kawtay e Almasiihu laatiiɗo hoore. Kanko nun hokkata ɓannu fu ko haajaa, kanko acci jokkule e ɗaɗi fu e hawti. Kanko bo acci ɓannu e mawna no Alla yiɗiri. ");
INSERT INTO fue_vpl VALUES ("CL2_20","081_2_20","COL","2","20","20","On maayidii e Almasiihu, burtiɗon e baawɗeeji duuniyaaru. Den, ume waɗi ko oon nyaama goonki mon hande woniiɓe der baawɗeeji duuniyaaru? Ume waɗi ko oon nooto ɗowtanaago boɗaaji himɓe resanta on: ");
INSERT INTO fue_vpl VALUES ("CL2_21","081_2_21","COL","2","21","21","«Taa ettu ɗum ɗo, taa mettu ɗum to, taa meemu ɗum ɗo?» ");
INSERT INTO fue_vpl VALUES ("CL2_22","081_2_22","COL","2","22","22","Boɗaaji ɗii fu laati nun nyolooji, janŋinol himɓe tan nun. Alla tagii kujje fu gam nafitoroɗen ɗe. ");
INSERT INTO fue_vpl VALUES ("CL2_23","081_2_23","COL","2","23","23","Gooŋa nun, sujidango baawɗeeji, e ɓuytugo hoore mum, e toorugo ɓannu mum puy, e nandi ko wooɗi. Amma, ɗum ɗon fu nafataa goɗɗum, suuno ɓannu tan ɗum deƴƴitinta. ");
INSERT INTO fue_vpl VALUES ("CL3_1","081_3_1","COL","3","1","1","Onon, on pintidinaama e Almasiihu. Gam majjum, daartee kujje gonuɗe dow kammu to Almasiihu jooɗii nyaamo Alla. ");
INSERT INTO fue_vpl VALUES ("CL3_2","081_3_2","COL","3","2","2","Miilanee kujje gonuɗe dow kammu, to on kakkilanee kujje ɗe leydi. ");
INSERT INTO fue_vpl VALUES ("CL3_3","081_3_3","COL","3","3","3","Gam on maayi, yonki mooɗon na'on suuɗi e Almasiihu to Alla. ");
INSERT INTO fue_vpl VALUES ("CL3_4","081_3_4","COL","3","4","4","To Almasiihu laatiiɗo yonki mooɗon suppitoyke, on cuppitinto e makko onon bo e tedduŋal. ");
INSERT INTO fue_vpl VALUES ("CL3_5","081_3_5","COL","3","5","5","Gam majjum, baree suunooji duuniyaaru gonuɗi der mooɗon, hande jon, baadi jayni, e coɓuɗum, e yidde baanjaare, e suunooji kalluɗi, e suuno woodugo huune fu. Ɗum ɗon fu, laati nun caafol tooruuje. ");
INSERT INTO fue_vpl VALUES ("CL3_6","081_3_6","COL","3","6","6","Kanjum waddata mone Alla dow saliiɓe ko ɗowtanii mo. ");
INSERT INTO fue_vpl VALUES ("CL3_7","081_3_7","COL","3","7","7","Onon bo, hande non nyaamirnoɗon goonki mon naane, de gonunoɗon der hakkeeji mon. ");
INSERT INTO fue_vpl VALUES ("CL3_8","081_3_8","COL","3","8","8","Amma jooni, boppee kujje ɗee ɗo: mone, e ɓernugo, e haaɗugo reedu, e jennooje, e batugo kalluka. ");
INSERT INTO fue_vpl VALUES ("CL3_9","081_3_9","COL","3","9","9","To on pewontiree hakkune mooɗon, gam on boppii jikku mon kiinŋu, e golle mum fu. ");
INSERT INTO fue_vpl VALUES ("CL3_10","081_3_10","COL","3","10","10","On laatike himɓe heyɓe. Alla taguɗo huune kesum der mooɗon, accataa waylitingo ɗum, faa ɗum nanda e makko, gam keɓon annal kebbuŋal. ");
INSERT INTO fue_vpl VALUES ("CL3_11","081_3_11","COL","3","11","11","To non, walaa ko suttontiri Yahuduujo e mo laataaki Yahuduujo, juulniiɗo e mo juulnaaki, janŋuɗo e mo janŋay, maccuɗo e dimo, gam Almasiihu nun laatii huune fu, e der moy fu. ");
INSERT INTO fue_vpl VALUES ("CL3_12","081_3_12","COL","3","12","12","Alla suɓii on laatini on himɓe mum yiɗaaɓe. Gam majjum, goodee yurmeene mawne, e neɗɗaaku, e ɓuytugo hoore, e ɗiggere, e munyal. ");
INSERT INTO fue_vpl VALUES ("CL3_13","081_3_13","COL","3","13","13","Munyontiree hakkune mon. To goɗɗo woofanii bannun, jaafontiree hande no Joomiraawo yaaforanii on. ");
INSERT INTO fue_vpl VALUES ("CL3_14","081_3_14","COL","3","14","14","Ko ɓuri ɗum fu, accee ɓerɗe mooɗon hebba yidde, gam yidde e hawta himɓe no wooɗi. ");
INSERT INTO fue_vpl VALUES ("CL3_15","081_3_15","COL","3","15","15","Accee jam Almasiihu laamanoo miilooji mooɗon, kanjum Alla noddani on, gam laatoɗon ɓannu gootol. To non, jettee mo. ");
INSERT INTO fue_vpl VALUES ("CL3_16","081_3_16","COL","3","16","16","Accee haala Almasiihu hebba e mooɗon faa wooɗa. Janŋinontiree, tiiɗinontiron e hakkillo. Jimanee Alla e ɓerɗe mooɗon fu, jettee mo e jimi jabuuraaji, e maantooje, e jimi ɗi Ruuhu Ceniiɗo hokkata on. ");
INSERT INTO fue_vpl VALUES ("CL3_17","081_3_17","COL","3","17","17","Ko batoton e ko gaɗoton fu, gaɗee ɗum e inne Yeesu Joomiraawo. Jettee Alla Baaba meeɗen diga e makko. ");
INSERT INTO fue_vpl VALUES ("CL3_18","081_3_18","COL","3","18","18","Onon rewɓe, ɗowtanee worɓe mooɗon, hande no haani rewɓe tokkuɓe Joomiraawo wonira. ");
INSERT INTO fue_vpl VALUES ("CL3_19","081_3_19","COL","3","19","19","Onon worɓe, jiɗee rewɓe mooɗon, to on monnanee ɓe. ");
INSERT INTO fue_vpl VALUES ("CL3_20","081_3_20","COL","3","20","20","Onon sukaaɓe, ɗowtanee saareeji mooɗon dow huune fu, gam kanjum fottanta Joomiraawo. ");
INSERT INTO fue_vpl VALUES ("CL3_21","081_3_21","COL","3","21","21","Onon saareeji bo, to on monninee sukaaɓe mooɗon, gam to ɓerɗe maɓɓe biisoo. ");
INSERT INTO fue_vpl VALUES ("CL3_22","081_3_22","COL","3","22","22","Onon maccuɓe, ɗowtanee joomiraaɓe mooɗon ɓe duuniyaaru ɗo, dow huune fu, hinaa yeeso maɓɓe tan, gam himɓe yetta on. Ko haani nun, jagganoɗon ɓe e ɓerɗe laaɓuɗe, der kulol Joomiraawo. ");
INSERT INTO fue_vpl VALUES ("CL3_23","081_3_23","COL","3","23","23","Ko gaɗoton fu, gaɗee ɗum e ɓerɗe goote, gam Joomiraawo nun jaggantoɗon, himɓe bane. ");
INSERT INTO fue_vpl VALUES ("CL3_24","081_3_24","COL","3","24","24","Annitee Joomiraawo hokkan on riiba ka o resani himɓe makko. Gam Joomiraawo mo jaggantoɗon woni Almasiihu. ");
INSERT INTO fue_vpl VALUES ("CL3_25","081_3_25","COL","3","25","25","Gaɗoowo ko halli fu, heɓan riiba golle mum kalluɗe, gam Alla ɓurontirtaa himɓe. ");
INSERT INTO fue_vpl VALUES ("CL4_1","081_4_1","COL","4","1","1","Onon joomiraaɓe, gaɗanee maccuɓe mooɗon ko wooɗi, ko foonnitii. Annee onon bo oon goodii joomiraawo dow kammu. ");
INSERT INTO fue_vpl VALUES ("CL4_2","081_4_2","COL","4","2","2","Tinnee der du'aare, deenee, oon jetta Alla. ");
INSERT INTO fue_vpl VALUES ("CL4_3","081_4_3","COL","4","3","3","Du'anee men menen bo, gam Alla maɓɓitana men laawol fiinugo haala mum, gam mi waawa ko waajii asiiri Almasiihu. Sabbu majjum nun acci jooni, mii maɓɓaa der kasu. ");
INSERT INTO fue_vpl VALUES ("CL4_4","081_4_4","COL","4","4","4","Eelee Alla gam mi waajoo asiiri on hande no haaniri. ");
INSERT INTO fue_vpl VALUES ("CL4_5","081_4_5","COL","4","5","5","Kakkilanee gondal mon e himɓe ɓe goonɗinay. De keɓuɗon wakkati fu, nafitoree ki. ");
INSERT INTO fue_vpl VALUES ("CL4_6","081_4_6","COL","4","6","6","Sey wakkati fu haala mooɗon e laatii belka, nafoowa. Annee bo no toontortoɗon moy fu. ");
INSERT INTO fue_vpl VALUES ("CL4_7","081_4_7","COL","4","7","7","Tikikus, banniraawo meeɗen jiɗaaɗo, humpitan on no gonirmi fu. O laati nun koolaaɗo, gollodintooɗo men der golle Joomiraawo. ");
INSERT INTO fue_vpl VALUES ("CL4_8","081_4_8","COL","4","8","8","Mi lilii mo to mon gam majjum, heɓa annon no men goniri, hakkillo mooɗon fukkoo. ");
INSERT INTO fue_vpl VALUES ("CL4_9","081_4_9","COL","4","9","9","Mi lilidii mo e banniraawo meeɗen Onesimu jiɗaaɗo, koolaaɗo, neɗɗo leydi mooɗon. Ɓe batan on ko waɗotoo ɗo fu. ");
INSERT INTO fue_vpl VALUES ("CL4_10","081_4_10","COL","4","10","10","Aristarkus mo maɓɓidaami e sanna on, e Marku denɗiraawo Barnabbas mo bi'umi to warii to mooɗon, jaɓɓoɗon ɗum no wooɗi. ");
INSERT INTO fue_vpl VALUES ("CL4_11","081_4_11","COL","4","11","11","Yeesu noddeteeɗo Yustus bo e sanna on. Kamɓe tan laatii Yahuduuɓe gollodiiɓe e am der Laamaare Alla. Ɓe cemmiɗinii am sanne. ");
INSERT INTO fue_vpl VALUES ("CL4_12","081_4_12","COL","4","12","12","Epafaras, neɗɗo leydi mooɗon, gollantooɗo Yeesu Almasiihu, e sanna on. Wakkati fu, o accay haɓugo gam mooɗon der du'aaje makko. O eela heɓa cemmiɗon der goonɗinki, kebbinon sago Alla. ");
INSERT INTO fue_vpl VALUES ("CL4_13","081_4_13","COL","4","13","13","Mii seedanoo mo ɗum, oo hiinnanii on sanne, onon e ɓe Lawdikiya, e ɓe Hiyerapolis fu. ");
INSERT INTO fue_vpl VALUES ("CL4_14","081_4_14","COL","4","14","14","Luka lokotoroojo men jiɗaaɗo, e Demas sannii on. ");
INSERT INTO fue_vpl VALUES ("CL4_15","081_4_15","COL","4","15","15","Emen canna banniraaɓe meeɗen wonuɓe Lawdikiya. Emen canna bo Nimfa, e goonɗinɓe hawritintooɓe wuro makko fu. ");
INSERT INTO fue_vpl VALUES ("CL4_16","081_4_16","COL","4","16","16","To on janŋii ɗerewol ŋol, gaɗee no gaɗoton fu, faa himɓe eklesiya Lawdikiya bo janŋa ŋol. Onon bo, janŋee ɗerewol ŋol ɓe lildanoyta on diga Lawdikiya. ");
INSERT INTO fue_vpl VALUES ("CL4_17","081_4_17","COL","4","17","17","Batee Arkippus tinnoo waɗa golle ɗe Joomiraawo yowani ɗum no wooɗi. ");
INSERT INTO fue_vpl VALUES ("CL4_18","081_4_18","COL","4","18","18","Min Pol, mi winnanii on sannoore ne e junŋo am. To on jeggitee e callalluuji nun gonumi. Moƴƴere Alla wonoo e mooɗon! ");
INSERT INTO fue_vpl VALUES ("H21_1","083_1_1","2TH","1","1","1","Ɗerewol ŋol ƴiwii diga e Pol, e Silaasi, e Timote. Emen canna eklesiya Tesalonika, kawtuka e Alla Baaba meeɗen, e Joomiraawo meeɗen Yeesu Almasiihu. ");
INSERT INTO fue_vpl VALUES ("H21_2","083_1_2","2TH","1","2","2","Alla Baaba, e Yeesu Almasiihu Joomiraawo, hokka on moƴƴere e jam! ");
INSERT INTO fue_vpl VALUES ("H21_3","083_1_3","2TH","1","3","3","Banniraaɓe, e haani men jetta Alla wakkati fu gam mooɗon. Eɗum fotti, gam goonɗinki mooɗon e ɓeydoo yeeso yeeso, kade bo yidde ne goodontirɗon hakkune mooɗon e ɓeydoo der moy mooɗon. ");
INSERT INTO fue_vpl VALUES ("H21_4","083_1_4","2TH","1","4","4","Kanjum acci emen juroro on der eklesiyaaji Alla. Emen juroro munyal mooɗon, e goonɗinki mooɗon, der tooraaji ɗi tooreteɗon, e ɓillaaje ɗe munyanton. ");
INSERT INTO fue_vpl VALUES ("H21_5","083_1_5","2TH","1","5","5","Tooraaji ɗin laati nun ko hollitinta kiita Alla poonnitiika, gam laatoɗon fotuɓe naatugo der Laamaare Alla, ne gam mum tooreteɗon. ");
INSERT INTO fue_vpl VALUES ("H21_6","083_1_6","2TH","1","6","6","Gam eɗum foonnitii yeeso Alla, o yoɓa tooranɓe on, toora. ");
INSERT INTO fue_vpl VALUES ("H21_7","083_1_7","2TH","1","7","7","Onon toorootooɓe, o hokkan on siwtaare e amen. Ɗum laatoto to Joomiraawo meeɗen Yeesu gonuɗo dow kammu suppitoyke e malaykaaɓe mum ɓe baawɗe. ");
INSERT INTO fue_vpl VALUES ("H21_8","083_1_8","2TH","1","8","8","Nyalaane majjum, o suppitinto der ɗenŋal yiite, gam o fooɗa noppi ɓe annaa Alla, e ɓe ɗowtanaaki linjiila Joomiraawo men Yeesu. ");
INSERT INTO fue_vpl VALUES ("H21_9","083_1_9","2TH","1","9","9","Pooɗol maɓɓe noppi e foonnitii, halkere tabitiine nun, ɓe boɗɗodinto e Joomiraawo e tedduŋal baawɗe mum. ");
INSERT INTO fue_vpl VALUES ("H21_10","083_1_10","2TH","1","10","10","Ɗum laatoto der nyalaane ne o wittoyta. Den himɓe makko teddinan mo, goonɗinɓe mo fu haaynee gam makko. Onon bo, on gonoto caka maɓɓe, gam on goonɗinii waaji men baajii on. ");
INSERT INTO fue_vpl VALUES ("H21_11","083_1_11","2TH","1","11","11","Gam majjum emen du'anoo on wakkati fu. Emen eela Alla meeɗen laatina on fotuɓe noddoore ne o noddi on. Baawɗe makko hokka on semme hebbingo golle booɗuɗe ɗe jiɗuɗon waɗugo fu, gam on goonɗinii mo. ");
INSERT INTO fue_vpl VALUES ("H21_12","083_1_12","2TH","1","12","12","Hande nun inne Joomiraawo meeɗen Yeesu teddinirtee der mooɗon, onon bo, teddineɗon gam makko. Ɗum fu, gam moƴƴere Alla meeɗen, e Yeesu Almasiihu Joomiraawo. ");
INSERT INTO fue_vpl VALUES ("H22_1","083_2_1","2TH","2","1","1","Banniraaɓe, dow garki Joomiraawo meeɗen Yeesu Almasiihu, e no kawritirteɗen e makko, nani ɗo ko men eelata on: ");
INSERT INTO fue_vpl VALUES ("H22_2","083_2_2","2TH","2","2","2","To on accee hakkillo mooɗon jiɓoo law. To on accee bo goɗɗo huunna on der annabaaku mum, ɗum bo der haala mum, ɗum bo goɗɗo wi'a, men binnii ka der ɗerewol amen no nyalaane Joomiraawo warii ko. ");
INSERT INTO fue_vpl VALUES ("H22_3","083_2_3","2TH","2","3","3","To on accee goɗɗo ƴoyra on baa dow laawol ŋole. Gam nyalaane nen warataa to hinaa himɓe ɗuuɓɓe yeddi Alla, neɗɗo kalluɗo, laatiiɗo ɓii halkere suppitoo. ");
INSERT INTO fue_vpl VALUES ("H22_4","083_2_4","2TH","2","4","4","Ganyo on mawnitinto dow huune fu ko saafetee e noddee Alla, o yahan faa o jooɗoo der suudu Alla, o wi'a hoore makko, kanko woni Alla. ");
INSERT INTO fue_vpl VALUES ("H22_5","083_2_5","2TH","2","5","5","Mi batiino on ka wakkati gonnoomi to mooɗon, on ciwtoray na? ");
INSERT INTO fue_vpl VALUES ("H22_6","083_2_6","2TH","2","6","6","Jooni kan oon anni ko faddii mo warugo. Amma o hollitinto to wakkati makko waɗii. ");
INSERT INTO fue_vpl VALUES ("H22_7","083_2_7","2TH","2","7","7","Gam baawɗe hakke cuuɗiiɗe e golloo ko diga jooni. Amma paddiiɗo ɗe na'on taw. To o yawtii, den ");
INSERT INTO fue_vpl VALUES ("H22_8","083_2_8","2TH","2","8","8","neɗɗo kalluɗo on suppitinto. Amma Yeesu Joomiraawo waran mo e foofaaŋo hunnuko mum, halka mo e jayŋol garki mum. ");
INSERT INTO fue_vpl VALUES ("H22_9","083_2_9","2TH","2","9","9","Neɗɗo kalluɗo on waridan e baawɗe Seyɗan, o waɗan kaayeefiiji, e maaneeji, e kaayeefiiji fewrekuuji. ");
INSERT INTO fue_vpl VALUES ("H22_10","083_2_10","2TH","2","10","10","O eytan halkooɓe e hakkeeji ɗiye fu. Ɓe majjan, gam ɓe jiɗay gooŋa kaa ɗo hisinta ɓe. ");
INSERT INTO fue_vpl VALUES ("H22_11","083_2_11","2TH","2","11","11","Gam majjum Alla lildanoyta ɓe baawɗe majjinooje, heɓa ɓe goonɗina fewre. ");
INSERT INTO fue_vpl VALUES ("H22_12","083_2_12","2TH","2","12","12","O waɗan ɗum gam o hiitoo ɓe goonɗinay gooŋa, go ɓee ceyoroo ko foonnitaaki. ");
INSERT INTO fue_vpl VALUES ("H22_13","083_2_13","2TH","2","13","13","Banniraaɓe, yiɗaaɓe Joomiraawo, menen, doole men jetta Alla wakkati fu gam mooɗon. Alla suɓii on diga fuɗɗoode, gam kison diga e Ruuhu Ceniiɗo laaɓinɗo on, gam on goonɗinii gooŋa. ");
INSERT INTO fue_vpl VALUES ("H22_14","083_2_14","2TH","2","14","14","Kanjum Alla noddani on diga e linjiila ka men baajii on, gam keɓon tedduŋal Joomiraawo meeɗen Yeesu Almasiihu. ");
INSERT INTO fue_vpl VALUES ("H22_15","083_2_15","2TH","2","15","15","Gam majjum banniraaɓe, tabitee wakkati fu, jogee ko men ekkitini on e haala, ɗum bo e ɗereeji amen. ");
INSERT INTO fue_vpl VALUES ("H22_16","083_2_16","2TH","2","16","16","Joomiraawo meeɗen Yeesu Almasiihu e hoore mum, e Alla Baaba meeɗen, jiɗuɗo en, hokkii en moƴƴere mum e jam tabitiiɗo, e tammuwe wooɗune. ");
INSERT INTO fue_vpl VALUES ("H22_17","083_2_17","2TH","2","17","17","Ɓe deƴƴitina ɓerɗe mooɗon, ɓe tiiɗina on waɗugo, e batugo ko wooɗi. ");
INSERT INTO fue_vpl VALUES ("H23_1","083_3_1","2TH","3","1","1","Banniraaɓe, ko horii woni, du'anoɗon men gam haala Joomiraawo sankitoo law, ka teddinee bo hande to mooɗon. ");
INSERT INTO fue_vpl VALUES ("H23_2","083_3_2","2TH","3","2","2","Du'ee gam men daɗa himɓe ɓe walaa ko'e, bonɓe. Gam himɓe fu bane goonɗini. ");
INSERT INTO fue_vpl VALUES ("H23_3","083_3_3","2TH","3","3","3","Amma Joomiraawo e laatii koolaaɗo, o semmiɗinan on, o reena on e ganyo. ");
INSERT INTO fue_vpl VALUES ("H23_4","083_3_4","2TH","3","4","4","Gam daliila Joomiraawo, emen koolii on, oon tokki umurooje ɗe men umuri on, on tokkoto ɗe bo yaago. ");
INSERT INTO fue_vpl VALUES ("H23_5","083_3_5","2TH","3","5","5","Joomiraawo acca ɓerɗe mooɗon yiɗa Alla, munyon hande no Almasiihu munyiri! ");
INSERT INTO fue_vpl VALUES ("H23_6","083_3_6","2TH","3","6","6","Banniraaɓe, emen eela on e inne Joomiraawo meeɗen Yeesu Almasiihu, boɗɗodee banniraaɓe ɓe walaa gaɗaaŋal, ɓe tokkay ko men ekkitini on. ");
INSERT INTO fue_vpl VALUES ("H23_7","083_3_7","2TH","3","7","7","Onon e ko'e mooɗon, oon anni no haani yemminiron men, gam men gonday e mooɗon der dullere gaɗaaŋal. ");
INSERT INTO fue_vpl VALUES ("H23_8","083_3_8","2TH","3","8","8","Walaa mo men nyaami nafa mum baanji. Jemma e nyalooma fu, men gollike e comuri, gam to men laatano goɗɗo mon doongal. ");
INSERT INTO fue_vpl VALUES ("H23_9","083_3_9","2TH","3","9","9","Men baawanno ko eeli on nyaamdu, amma men gaɗay ɗum. Men gollike e ko'e amen gam men laatanoo on misaalu, gam yemmenen men. ");
INSERT INTO fue_vpl VALUES ("H23_10","083_3_10","2TH","3","10","10","Gam wakkati men gonunoo to mooɗon, men batiino on, men bi'i: «Mo yiɗaa gollaago fu, to nyaamu bo.» ");
INSERT INTO fue_vpl VALUES ("H23_11","083_3_11","2TH","3","11","11","Gam men nani woɓɓe caka mon yiɗaa gaɗaaŋal, sey naatugo haalaaji ɗi yaalay ɗum. ");
INSERT INTO fue_vpl VALUES ("H23_12","083_3_12","2TH","3","12","12","Emen eela iri himɓe ɓen, emen bata ɓe e inne Joomiraawo meeɗen Yeesu Almasiihu, ɓe golloo e jam, gam ɓe nyaanna ko'e maɓɓe. ");
INSERT INTO fue_vpl VALUES ("H23_13","083_3_13","2TH","3","13","13","Amma onon banniraaɓe, to on comee waɗugo ko wooɗi. ");
INSERT INTO fue_vpl VALUES ("H23_14","083_3_14","2TH","3","14","14","To goɗɗo salike ko ɗowtanii ko men binni der ɗerewol ŋol, maanee joomum, boɗɗoɗon mo, gam o senta. ");
INSERT INTO fue_vpl VALUES ("H23_15","083_3_15","2TH","3","15","15","Amma, to on daaree mo hande ganyo, bagginee mo hande banniraawo. ");
INSERT INTO fue_vpl VALUES ("H23_16","083_3_16","2TH","3","16","16","Joomiraawo mo jam e hoore mum hokka on jam wakkati fu, e der noy fu. Joomiraawo wonda e mooɗon, on fu. ");
INSERT INTO fue_vpl VALUES ("H23_17","083_3_17","2TH","3","17","17","Min Pol winni e junŋo am sannoore ne, hande non boowirmi wattirgo ɗereeji am fu junŋo. ");
INSERT INTO fue_vpl VALUES ("H23_18","083_3_18","2TH","3","18","18","Moƴƴere Joomiraawo meeɗen Yeesu Almasiihu wonda e mooɗon, on fu! ");
INSERT INTO fue_vpl VALUES ("T11_1","084_1_1","1TI","1","1","1","Ɗerewol ŋol ƴiwii e am min Pol lilaaɗo Yeesu Almasiihu. Alla Kisinoowo en e Yeesu Almasiihu laatiiɗo tammuwe men, yowanimmi ɗum junŋo. ");
INSERT INTO fue_vpl VALUES ("T11_2","084_1_2","1TI","1","2","2","Emi sannee Timote, ɓiyam gooŋaajo, mo dimumi dow laawol goonɗinki. Alla Baaba meeɗen, e Joomiraawo meeɗen Yeesu Almasiihu enɗee, hokkee moƴƴere e jam. ");
INSERT INTO fue_vpl VALUES ("T11_3","084_1_3","1TI","1","3","3","Wakkati jahannoomi Maseduwaan, mi batiino maa jooɗoɗaa Efesu. Himɓe woɓɓe na'on ɗon e janŋina ekkitinol feerewol. Haɗu ɓe ɗum. ");
INSERT INTO fue_vpl VALUES ("T11_4","084_1_4","1TI","1","4","4","Batu ɓe ɓe acca hakkilango taalaaji e inɗe kaakiraaɓe ɗe walaa kaddi. Jeddi tan ɗum waddata, ɗum nafataa laawol ŋol Alla hisinirta himɓe e goonɗinki. ");
INSERT INTO fue_vpl VALUES ("T11_5","084_1_5","1TI","1","5","5","Ka batanmi ɗo laati nun gam mawningo yidde ƴiwune diga ɓerne laaɓune, e miilooji laaɓuɗi, e goonɗinki ki walaa munaafitaare. ");
INSERT INTO fue_vpl VALUES ("T11_6","084_1_6","1TI","1","6","6","Woɓɓe seekake e majjum, ɓe majjii der haalaaji baanji baanji. ");
INSERT INTO fue_vpl VALUES ("T11_7","084_1_7","1TI","1","7","7","Ɓee jiɗi laataago moodiɓɓe tawreeta, amma ɓe paamataa ka ɓe batata, e ka ɓe tabbitinta. ");
INSERT INTO fue_vpl VALUES ("T11_8","084_1_8","1TI","1","8","8","Een anni tawreeta e wooɗi, to kaa golliree hande no haani. ");
INSERT INTO fue_vpl VALUES ("T11_9","084_1_9","1TI","1","9","9","Een anni no tawreeta waɗaaka gam foonnitiiɓe. Amma ka waɗaama gam halluɓe, e nanaruuɓe, e ɓe hulataa Alla, e hakkeeɓe, e ɓe teddintaa ko senii, e yawiiɓe Alla, e warooɓe baabiraaɓe e inniraaɓe mum, e reƴƴitooɓe ƴiiƴam himɓe. ");
INSERT INTO fue_vpl VALUES ("T11_10","084_1_10","1TI","1","10","10","Ka waɗaama bo gam jeenooɓe, e waɗooɓe jeenu gorko e gorko, non bo debbo e debbo, e sippooɓe maccuɓe, e fewooɓe, e hunortooɓe fewre, e huune ɗuuɗɗum, luudontirɗum e ekkitinol gooŋawol. ");
INSERT INTO fue_vpl VALUES ("T11_11","084_1_11","1TI","1","11","11","Ekkitinol ŋol e yaada e linjiila ka jowanaami. Eka hollita tedduŋal Alla maanteteeɗo. ");
INSERT INTO fue_vpl VALUES ("T11_12","084_1_12","1TI","1","12","12","Mii yetta Joomiraawo meeɗen Yeesu Almasiihu, kokkuɗo am semme. Mii yetta mo gam o daarii am koolaaɗo, o yowanimmi golle makko. ");
INSERT INTO fue_vpl VALUES ("T11_13","084_1_13","1TI","1","13","13","Mii laatino batoowo kalluka dow makko. Mii toorannoo himɓe makko, mi holliino mo gite boɗeeje. Amma Joomiraawo meeɗen enɗike am. Mi annaano ko gaɗannoomi, gam mi goonɗinayno. ");
INSERT INTO fue_vpl VALUES ("T11_14","084_1_14","1TI","1","14","14","Moƴƴere Joomiraawo ɗuuɗanii am puy. O hokkii am goonɗinki e yidde ƴiwune diga e Yeesu Almasiihu. ");
INSERT INTO fue_vpl VALUES ("T11_15","084_1_15","1TI","1","15","15","Haala kooliniika nani, kaanuka himɓe fu jaɓa: Yeesu Almasiihu warii e duuniyaaru gam hisingo hakkeeɓe. Mii laatii arano caka maɓɓe. ");
INSERT INTO fue_vpl VALUES ("T11_16","084_1_16","1TI","1","16","16","Amma Alla enɗake am gam Yeesu Almasiihu hollita munyal mum dow am, min laatiiɗo arano caka hakkeeɓe. Yeesu on waɗii ɗum gam mi laatanoo goonɗinooɓe mo, heɓooɓe yonki tabitiiki fu misaalu. ");
INSERT INTO fue_vpl VALUES ("T11_17","084_1_17","1TI","1","17","17","Alla gooto woni, laamiiɗo tabitiiɗo, mo maayataa, mo yi'ataake bo. Daraja e tedduŋal woodani mo faa abada abadin. Aami! ");
INSERT INTO fue_vpl VALUES ("T11_18","084_1_18","1TI","1","18","18","Ɓiyam Timote, saawari kokku maa mi nun ɗon, jaadooki e annabaakuuji gaɗanooɗi dow maa. Accu ɗi laatanee gineeji gaɗiraa konu geetu. ");
INSERT INTO fue_vpl VALUES ("T11_19","084_1_19","1TI","1","19","19","Joga goonɗinki e cuuɗiiɗum ɓerne geetum. Woɓɓe hakkilanay ɗum, go goonɗinki maɓɓe halki. ");
INSERT INTO fue_vpl VALUES ("T11_20","084_1_20","1TI","1","20","20","Himeneyus e Aleksandire na'on caka maɓɓe. Mi wattii ɓe e junŋo Seyɗan gam ɓe annita no haanay ɓe bata kalluka dow Alla. ");
INSERT INTO fue_vpl VALUES ("T12_1","084_2_1","1TI","2","1","1","Ka batanmi on aran nani: Eelee, eelitee. Du'ee, jettee Alla gam himɓe fu. ");
INSERT INTO fue_vpl VALUES ("T12_2","084_2_2","1TI","2","2","2","Du'anee laamiiɓe, e mawɓe leydi fu. Du'ee gam gonoɗen e jam, e deƴƴere der kulol Alla, heɓa himɓe ɗowtanoo neɗɗaaku men. ");
INSERT INTO fue_vpl VALUES ("T12_3","084_2_3","1TI","2","3","3","Kanjum wooɗi, eɗum fottani Alla kisinoowo en. ");
INSERT INTO fue_vpl VALUES ("T12_4","084_2_4","1TI","2","4","4","Oo yiɗi himɓe fu hisa, heɓa ɓe jottoo annal gooŋa. ");
INSERT INTO fue_vpl VALUES ("T12_5","084_2_5","1TI","2","5","5","Alla gooto nun woni. Tawaaɗo hakkune makko e himɓe bo gooto nun, kanko woni Yeesu Almasiihu, laatiiɗo neɗɗo. ");
INSERT INTO fue_vpl VALUES ("T12_6","084_2_6","1TI","2","6","6","O hokkitirii hoore makko gam sooditaago himɓe fu. Non Alla hollitiri laawol ŋol o suɓi no wakkati mum waɗi. ");
INSERT INTO fue_vpl VALUES ("T12_7","084_2_7","1TI","2","7","7","Gam mi batana ɗum, Alla waɗimmi baajotooɗo e lilaaɗo. O yowanii am mi janŋina himɓe ɓe lenyi janani haala goonɗinki e gooŋa. Gooŋa batammi, mi fewataa. ");
INSERT INTO fue_vpl VALUES ("T12_8","084_2_8","1TI","2","8","8","Gam majjum, mii yiɗi worɓe du'oo nokku fu, ɓe ɓanta juuɗe maɓɓe. Ɓe gaɗa ɗum e ɓerɗe laaɓuɗe, hinaa e tikkere, hinaa e jeddi. ");
INSERT INTO fue_vpl VALUES ("T12_9","084_2_9","1TI","2","9","9","Rewɓe kan ɓornoo gineeji pottuɗi. Ɓe gooda neɗɗaaku e senteene. To ɓe mooroo moorɗi ɗi gidi e kanŋeeri, e bannaaje ɗe cardi. To ɓe ɓorna gineeji ɗi ceede puy. ");
INSERT INTO fue_vpl VALUES ("T12_10","084_2_10","1TI","2","10","10","Amma ŋari maɓɓe laatoo waɗugo gaɗu geetu. Hande nun haanirani rewɓe batooɓe no e teddini Alla. ");
INSERT INTO fue_vpl VALUES ("T12_11","084_2_11","1TI","2","11","11","To e janŋinee, sey rewɓe jeeɗoo, e hettinii e ɗowtaare. ");
INSERT INTO fue_vpl VALUES ("T12_12","084_2_12","1TI","2","12","12","Mi hokkay laawol, debbo janŋina, ɗum bo laatoo hooreejo dow gorko. Ko haani nun o jeeɗoo. ");
INSERT INTO fue_vpl VALUES ("T12_13","084_2_13","1TI","2","13","13","Gam Aadamu nun artaa tagaa, ko Hawwa tokki. ");
INSERT INTO fue_vpl VALUES ("T12_14","084_2_14","1TI","2","14","14","Kade bo Aadamu bane Seyɗan jarbii, debbo nun jarbaa, go o ƴaartii sariya Alla. ");
INSERT INTO fue_vpl VALUES ("T12_15","084_2_15","1TI","2","15","15","Amma debbo hisinte diga e ɓeyŋu mum, to emo tabbitii e goonɗinki e yidde, e laaɓal, e jogaago hoore mum. ");
INSERT INTO fue_vpl VALUES ("T13_1","084_3_1","1TI","3","1","1","Haala kooliniika nani: Jiɗɗo laataago hooreejo eklesiya fu, yiɗii golle booɗuɗe. ");
INSERT INTO fue_vpl VALUES ("T13_2","084_3_2","1TI","3","2","2","Den, sey ardiiɗo eklesiya fu laatoo mo walaa gacce. O laatoo gooduɗo debbo gooto, nantiiɗo, mo hakkillo, gooduɗo neɗɗaaku, cilminoowo hoɓɓe, baawuɗo ekkitingo. ");
INSERT INTO fue_vpl VALUES ("T13_3","084_3_3","1TI","3","3","3","Taa o laatoo jaroowo bagi, ɗum bo kaɓaaɗo. Amma o laatoo munyuɗo, daartoowo jam, mo suunaaka ceede. ");
INSERT INTO fue_vpl VALUES ("T13_4","084_3_4","1TI","3","4","4","O laatoo ardaniiɗo saare makko no wooɗiri. O elta ɓiɓɓe makko faa ɓe ɗowtanoo mo, ɓe teddina mo. ");
INSERT INTO fue_vpl VALUES ("T13_5","084_3_5","1TI","3","5","5","Gam to goɗɗo waaway ko ardanii saare mum, noy o waawirta ko hiinnii eklesiya Alla? ");
INSERT INTO fue_vpl VALUES ("T13_6","084_3_6","1TI","3","6","6","Haanay hooreejo eklesiya e laatii goonɗinɗo keso. To oo laatii keso, o mawnitinto, o doƴƴee kiita hande no Ibiliisa doƴƴiraa kiita. ");
INSERT INTO fue_vpl VALUES ("T13_7","084_3_7","1TI","3","7","7","E haani joomum e batanee geeta yeeso himɓe ɓe goonɗinay. Den ɓe jawataako mo, o yantataa bo der pitti Ibiliisa. ");
INSERT INTO fue_vpl VALUES ("T13_8","084_3_8","1TI","3","8","8","Wallooɓe der golle eklesiya bo, e haani laatoo fotuɓe teddineego. Ɓe galaa munaafitaare, ɓe jarataa bagi jiiloojam. To ɓe laatoo daartooɓe ceede e laabi kalluɗi. ");
INSERT INTO fue_vpl VALUES ("T13_9","084_3_9","1TI","3","9","9","Sey ɓe jogoo gooŋa goonɗinki ka Alla holliti. Ɓe jogoo ka e cuuɗiiɗum ɓerne laaɓuɗum. ");
INSERT INTO fue_vpl VALUES ("T13_10","084_3_10","1TI","3","10","10","Sey ɓe poonnee taw. To ɓe galaa gacce, ɓe puɗɗa golle maɓɓe. ");
INSERT INTO fue_vpl VALUES ("T13_11","084_3_11","1TI","3","11","11","Hande non rewɓe bo, sey ɓe laatoo fotuɓe teddineego. Haanay ɓe laatoo nyo'ooɓe himɓe, amma ɓe laatoo nantiiɓe, hooliniiɓe der huune fu. ");
INSERT INTO fue_vpl VALUES ("T13_12","084_3_12","1TI","3","12","12","Laatiiɗo balloowo eklesiya fu, sey joomum e woodi debbo gooto. O waawa bo dawrango ɓiɓɓe makko, e wuro makko hande no haani. ");
INSERT INTO fue_vpl VALUES ("T13_13","084_3_13","1TI","3","13","13","To wallooɓe der eklesiya waɗii golle mum no wooɗiri, ɓe keɓan joonne teddune. Ɓe keɓan bo semme der goonɗinki maɓɓe Yeesu Almasiihu. ");
INSERT INTO fue_vpl VALUES ("T13_14","084_3_14","1TI","3","14","14","Mi winnanii maa ɗerewol ŋol ɗo, amma mii miila warugo to maaɗa, yeeso seɗɗa. ");
INSERT INTO fue_vpl VALUES ("T13_15","084_3_15","1TI","3","15","15","Amma to ɓooyii mi waray, ɗerewol ŋol ɗo anninte no haani goniraa der saare Alla, laatiine eklesiya Alla yonkinteejo. Eklesiya kan laatii darŋanal, e to gooŋa darii. ");
INSERT INTO fue_vpl VALUES ("T13_16","084_3_16","1TI","3","16","16","Seko fu walaa, asiiri diina meeɗen e mawni: Alla hollitake e ɓannu neɗɗo, Ruuhu seedanike gooŋaaku makko, malaykaaɓe yi'ii mo, lenyi fu waajaama haala makko, o goonɗinaama der lenyi janani, o heɓii tedduŋal dow kammu. ");
INSERT INTO fue_vpl VALUES ("T14_1","084_4_1","1TI","4","1","1","Ruuhu Ceniiɗo batii e laaɓuɗum wi'i: Der jaamanuuji cakitiiɗi, woɓɓe woppan goonɗinki. Ɓe ɗowtanto ruuhuuji majjinooji, e ekkitinooje ginnaaji. ");
INSERT INTO fue_vpl VALUES ("T14_2","084_4_2","1TI","4","2","2","Ɓe accan ekkitinooɓe munaafitiiɓe e fewooɓe majjina ɓe. Cuuɗiiɗum ɓerɗe ekkitinooɓe pewe ɗen maanaama e fewre, nandi hande cumaaɗum e janni boɗeeri. ");
INSERT INTO fue_vpl VALUES ("T14_3","084_4_3","1TI","4","3","3","Ɓee kaɗa himɓe ɓaŋontirgo, e nyaamugo nyaamduuji goɗɗi. Amma Alla tagi nyaamduuji ɗin. Goonɗinɓe, annuɓe gooŋa fu, waawan ko yetti Alla, nyaama ɗi. ");
INSERT INTO fue_vpl VALUES ("T14_4","084_4_4","1TI","4","4","4","Ko Alla tagi fu e wooɗi. Walaa ko woppetee e majjum, to en jaɓii ɗum e yettoore. ");
INSERT INTO fue_vpl VALUES ("T14_5","084_4_5","1TI","4","5","5","Gam haala Alla, e du'aare, e laaɓina huune fu. ");
INSERT INTO fue_vpl VALUES ("T14_6","084_4_6","1TI","4","6","6","Ekkitin banniraaɓe huune ɗum. Den a laatoto gollantooɗo Yeesu Almasiihu geeto. A nyaannan hoore maa e haala goonɗinki, e ekkitinol poonnitiiŋol ŋol tokkuɗaa e tinnaare. ");
INSERT INTO fue_vpl VALUES ("T14_7","084_4_7","1TI","4","7","7","Haalaaji ɗi walaa hoore, e taalaaji ɗi himɓe tafi, ɗi jaadataa e goonɗinki, sala ɗi. Amma an, eltu hoore maa aa takkii Alla. ");
INSERT INTO fue_vpl VALUES ("T14_8","084_4_8","1TI","4","8","8","Eltugo ɓannu e nafa seɗɗa dow kujje goɗɗe. Amma takkaago Alla e nafa dow huune fu. Eɗum woodi alkawal der goonki duuniyaaru ɗo, e der goonki garoowi yeeso. ");
INSERT INTO fue_vpl VALUES ("T14_9","084_4_9","1TI","4","9","9","Kanka woni haala kooliniika, kaanuka himɓe fu jaɓa! ");
INSERT INTO fue_vpl VALUES ("T14_10","084_4_10","1TI","4","10","10","Gam sabbu ɗum ɗon fu, emen golloo emen duura, gam men jowii hoolaare amen fu dow Alla yonkinteejo. Kanko laatii Kisinoowo himɓe fu, accu du goonɗinɓe mo. ");
INSERT INTO fue_vpl VALUES ("T14_11","084_4_11","1TI","4","11","11","Kanjum haani bataa himɓe, ekkitinaa ɓe ɗum. ");
INSERT INTO fue_vpl VALUES ("T14_12","084_4_12","1TI","4","12","12","Taa accu goɗɗo yawee gam aa laatii gojankeejo. Amma laatana goonɗinɓe misaalu diga e haala maa, e gaɗu maa, e yidde maa e goonɗinki maa, e laaɓal maa. ");
INSERT INTO fue_vpl VALUES ("T14_13","084_4_13","1TI","4","13","13","Go mi wara, tinna aa janŋana goonɗinɓe dewte ceniiɗe, aa tiiɗina ɓe, aa ekkitina ɓe. ");
INSERT INTO fue_vpl VALUES ("T14_14","084_4_14","1TI","4","14","14","Taa yeeba dokkal moƴƴere ŋal keɓuɗaa. A heɓii ŋal diga e annabaaku, wakkati dottiiɓe eklesiya yowi juuɗe mum dow maa. ");
INSERT INTO fue_vpl VALUES ("T14_15","084_4_15","1TI","4","15","15","Tinna e golle ɗen, kokkaa hoore maa e majje, gam himɓe fu yi'a no ɓeydortoɗaa yeeso yeeso. ");
INSERT INTO fue_vpl VALUES ("T14_16","084_4_16","1TI","4","16","16","Hakkilan hoore maa. Reenu bo janŋinol maa, tinna dow majjum. To a waɗii ɗum, den aa hoolii a hisan, an e hettinaniiɓe maa fu. ");
INSERT INTO fue_vpl VALUES ("T15_1","084_5_1","1TI","5","1","1","Taa falmu dottiijo e semme, amma tiiɗin mo hande baaba maa. Gojankeeɓe bo, baddu ɓe hande mawniraaɓe maa, e miiraaɓe maa. ");
INSERT INTO fue_vpl VALUES ("T15_2","084_5_2","1TI","5","2","2","Rewɓe manŋusuuɓe, baddu ɗum hande inniraaɓe maa, saaŋooɓe bo, hande sakikiraaɓe maa. Waɗu ɗum e miilooji laaɓuɗi. ");
INSERT INTO fue_vpl VALUES ("T15_3","084_5_3","1TI","5","3","3","Teddin rewɓe gowniiɓe, ɓe woodaa wallanɓe ɗum. ");
INSERT INTO fue_vpl VALUES ("T15_4","084_5_4","1TI","5","4","4","Amma to debbo gowniijo e woodi sukaaɓe, ɗum bo taaniraaɓe, e haani ɓe ekkitoo taw golloraago kulol Alla der saareeji maɓɓe. Ɓe joɓa saareeji maɓɓe barjaari booɗuni. Kanjum fottani Alla. ");
INSERT INTO fue_vpl VALUES ("T15_5","084_5_5","1TI","5","5","5","Debbo gowniijo, mo walaa kiinnotooɗo ɗum, go e woni kan tan, yowii hoolaare mum dow Alla. Jemma e nyalooma, oo tinnii, oo eela ballal Alla. ");
INSERT INTO fue_vpl VALUES ("T15_6","084_5_6","1TI","5","6","6","Amma gowniijo daartoowo welwelo, laati nun maayɗo baa to emo foofa. ");
INSERT INTO fue_vpl VALUES ("T15_7","084_5_7","1TI","5","7","7","Kanjum haani bataa ɓe, gam ɓe laatoo ɓe walaa gacce. ");
INSERT INTO fue_vpl VALUES ("T15_8","084_5_8","1TI","5","8","8","Mo hiinnaaki getti wuro mum, accu du himɓe saare mum, joomum yeddii goonɗinki, oo ɓuri mo goonɗinay jaasugo. ");
INSERT INTO fue_vpl VALUES ("T15_9","084_5_9","1TI","5","9","9","Ko inne gowniijo winnee e ɗerewol, sey oo woodi jaka duuɓi lasoy tati, tawee o laatanakeno goriiko koolaaɗo. ");
INSERT INTO fue_vpl VALUES ("T15_10","084_5_10","1TI","5","10","10","O laatoo anniraaɗo waɗugo ko wooɗi, hande jon: ummingo sukaaɓe mum hande no haani, oo laatii bernuɗo hoɓɓe, e lootuɗo koyɗe goonɗinɓe, e balluɗo toorotooɓe. Laatoo bo o waɗii gaɗuuji geeti ɗuuɗɗi. ");
INSERT INTO fue_vpl VALUES ("T15_11","084_5_11","1TI","5","11","11","Amma taa winnu inɗe rewɓe saaŋooɓe, laatiiɓe gowniiɓe. Gam to suunooji maɓɓe ummake, ɓe jiɗan hooweego kade, ɓe acca gollanaago Almasiihu. ");
INSERT INTO fue_vpl VALUES ("T15_12","084_5_12","1TI","5","12","12","Ɓe keɓan gacce, gam ɓe accii alkawal gollanaago Alla ŋal ɓe kaɓɓuno. ");
INSERT INTO fue_vpl VALUES ("T15_13","084_5_13","1TI","5","13","13","Ko ɓuri ɗum, no ɓe galaa gaɗaaŋal, ɓe ettan wakkati maɓɓe, ɓee boositoo wuro e wuro. Dullere gaɗaaŋal tan bane, amma ɓee nyo'a himɓe. Ɓee naata haalaaji ɗi yaalay ɓe, ɓee una batu. ");
INSERT INTO fue_vpl VALUES ("T15_14","084_5_14","1TI","5","14","14","Sabbu majjum, mii yiɗi saaŋooɓe, laatiiɓe gowniiɓe, hoowitee. Ɓe dima sukaaɓe, ɓe kiinno wuro maɓɓe. Den ɓe kokkataa wayɓe men laawol no biisiri inɗe meeɗen. ");
INSERT INTO fue_vpl VALUES ("T15_15","084_5_15","1TI","5","15","15","Woɓɓe maɓɓe selii ko laawol, tokkii Seyɗan. ");
INSERT INTO fue_vpl VALUES ("T15_16","084_5_16","1TI","5","16","16","Debbo goonɗinɗo, mo rewɓe gowniiɓe woni e wuro mum, o walla ɓe, gam to ɓe laatana eklesiya doongal. Eklesiya kan, hiinno rewɓe gowniiɓe, ɓe goodaa goɗɗo kiinnotooɗo ɗum. ");
INSERT INTO fue_vpl VALUES ("T15_17","084_5_17","1TI","5","17","17","Dottiiɓe ardaniiɓe Eklesiya deydey, e haani heɓa joddi golle mum de ɗiɗi. Accu du tinniiɓe e waaji e janŋinol. ");
INSERT INTO fue_vpl VALUES ("T15_18","084_5_18","1TI","5","18","18","Gam Dewtere wi'i: «Taa haɓɓu hunnuko gaari corɓoori gawri.» Ne wi'i kade bo: «Gollotooɗo fu e haani joddi mum.» ");
INSERT INTO fue_vpl VALUES ("T15_19","084_5_19","1TI","5","19","19","To goɗɗo waddanii maa gacce dow dottiijo eklesiya, taa jaɓu, to hinaa ɓe gaɗii seedeeɓe ɗiɗo, ɗum bo tato. ");
INSERT INTO fue_vpl VALUES ("T15_20","084_5_20","1TI","5","20","20","Waɗooɓe hakke, felu ɗum yeeso himɓe fu, gam heɓa horiiɓe hula. ");
INSERT INTO fue_vpl VALUES ("T15_21","084_5_21","1TI","5","21","21","Mi eelii maa yeeso Alla, e Yeesu Almasiihu, e malaykaaɓe suɓaaɓe, ɗowtana haalaaji ɗii, tawee a suttontiray himɓe, a ɓurontiray ɓe bo. ");
INSERT INTO fue_vpl VALUES ("T15_22","084_5_22","1TI","5","22","22","Taa yawɗa jowaa juuɗe maa dow hoore goɗɗo. Taa naannu hoore maaɗa der hakkeeji woɓɓe. Reenu hoore maa aa laaɓi. ");
INSERT INTO fue_vpl VALUES ("T15_23","084_5_23","1TI","5","23","23","Taa yaru diyam ɓalam tan. Yaru innabojam seɗɗa gam reedu maa, e gam aa nyawi de ɗuuɗɗum. ");
INSERT INTO fue_vpl VALUES ("T15_24","084_5_24","1TI","5","24","24","Hakkeeji woɓɓe wurtitinto diga ɓe kiitaaka, ɗi woɓɓe bo wurtitoo ɓaawo ni. ");
INSERT INTO fue_vpl VALUES ("T15_25","084_5_25","1TI","5","25","25","Hande nun bo golle booɗɗe hollitortoo, ɗe hollitaaki bo, tabitintaako e suuɗi. ");
INSERT INTO fue_vpl VALUES ("T16_1","084_6_1","1TI","6","1","1","Maccuɓe laatiiɓe goonɗinɓe, daara joomiraaɓe mum hande fotuɓe teddineego. Den mum, goɗɗo heɓataa laawol bata kalluka dow inne Alla, e ekkitinol men. ");
INSERT INTO fue_vpl VALUES ("T16_2","084_6_2","1TI","6","2","2","Maccuɓe wooduɓe joomiraaɓe goonɗinɓe, to wi'u gam ɓee laatii banniraaɓe, ɓe teddintaa ɓe. Amma, ɓe jagganoo ɓe ɓura, gam goonɗinɓe yiɗaaɓe nun ɓe jaggantoo. Kanjum haani janŋinaa, baajoɗaa. ");
INSERT INTO fue_vpl VALUES ("T16_3","084_6_3","1TI","6","3","3","Woɓɓe e ekkitina ekkitinol feerewol. Ɓe tokkay haala Joomiraawo meeɗen Yeesu Almasiihu laaɓuka, e ekkitinol jaadoowol e kulol Alla. ");
INSERT INTO fue_vpl VALUES ("T16_4","084_6_4","1TI","6","4","4","Himɓe ɓen laati nun mawnitiiɓe, ɓe annaa goɗɗum. Ɓee nyawi jeddi e biɗitiri haalaaji. Diga e majjum nawniraagu, e kaɓe, e jennooje, e biisugo bannun ƴiwata. ");
INSERT INTO fue_vpl VALUES ("T16_5","084_6_5","1TI","6","5","5","Eɗum wadda jeddi ɗi walaa kaddi, hakkune himɓe ɓe hakkillo mum wuurii. Ɓe joofii gooŋa, ɓee miili goonɗinki laati nun laawol keɓal. ");
INSERT INTO fue_vpl VALUES ("T16_6","084_6_6","1TI","6","6","6","E gooŋa, goonɗinki laati nun laawol keɓal manŋal, to neɗɗo e seyorii ko woodi. ");
INSERT INTO fue_vpl VALUES ("T16_7","084_6_7","1TI","6","7","7","En gadday goɗɗum der duuniyaaru. En baawataa bo ko hoori goɗɗum. ");
INSERT INTO fue_vpl VALUES ("T16_8","084_6_8","1TI","6","8","8","Gam majjum to een goodi nyaamdu e kolte, ɗum heƴii en. ");
INSERT INTO fue_vpl VALUES ("T16_9","084_6_9","1TI","6","9","9","Amma suunaaɓe jawdi, jarbeeji waranan ɓe. Ɓe jantan pitti Seyɗan e suunooji ɗi nafataa, jaarooji der majjere e halkere. ");
INSERT INTO fue_vpl VALUES ("T16_10","084_6_10","1TI","6","10","10","Gam suuno ceede woni ɗaɗol kalluɗum. Woɓɓe suunake ɗe, go ɓe ceeki diga goonɗinki, den ɓe gaddani ko'e maɓɓe tooraaji ɗuuɗɗi. ");
INSERT INTO fue_vpl VALUES ("T16_11","084_6_11","1TI","6","11","11","Amma, an neɗɗo Alla, woɗɗoda kujje ɗen. Daartu foonnitaare e takkaago Alla, e goonɗinki, e yidde, e tinnaare, e ɗiggere. ");
INSERT INTO fue_vpl VALUES ("T16_12","084_6_12","1TI","6","12","12","Haɓu hawre goonɗinki wooɗune, jaɓaa yonki tabitiiki. Gam sabbu yonki kin Alla noddu maa, gaɗuɗaa seedaaku maaɗa booɗuŋu yeeso seedeeɓe ɗuuɓɓe. ");
INSERT INTO fue_vpl VALUES ("T16_13","084_6_13","1TI","6","13","13","Mii batee kaa ɗo yeeso Alla buurinoowo huune fu. Mii batee ka bo yeeso Yeesu Almasiihu gaɗuɗo seedaaku booɗuŋu yeeso Ponsu Pilaatu. ");
INSERT INTO fue_vpl VALUES ("T16_14","084_6_14","1TI","6","14","14","Joga ko bataɗaa faa wooɗa. Laata mo walaa tuuni ɗum bo gacce faa nyalaane Joomiraawo meeɗen Yeesu Almasiihu suppitoyto. ");
INSERT INTO fue_vpl VALUES ("T16_15","084_6_15","1TI","6","15","15","Garki makko laatoto wakkatiire ne Alla resi, Alla maanteteeɗo. Kanko tan woodi baawɗe, Laamiiɗo laamiiɓe, Joomiraawo joomiraaɓe. ");
INSERT INTO fue_vpl VALUES ("T16_16","084_6_16","1TI","6","16","16","Kanko tan woni mo maayataa, jooɗiiɗo der jayŋol ŋol goɗɗo waawataa ko ɓattii. Walaa mo meeɗi yi'ugo mo, walaa baawoowo ko yi'i mo bo. Tedduŋal e baawɗe tabitiiɗe woodani mo faa abada abadin. Aami. ");
INSERT INTO fue_vpl VALUES ("T16_17","084_6_17","1TI","6","17","17","Batu wooduɓe jawdi der duuniyaaru ɗo, to ɓe mawnito. To ɓe kooloo jawdi ni tabitintaako, amma ɓe kooloo Alla. Kanko nun hokkata en huune fu, faa heƴa, gam ceyoroɗen ɗum. ");
INSERT INTO fue_vpl VALUES ("T16_18","084_6_18","1TI","6","18","18","Batu ɓe ɓe gaɗa ko wooɗi. Waɗugo geetum laatoo jawdi maɓɓe. Ɓe laatoo hokkitirooɓe, siriyiiɓe wallugo woɓɓe e jawdi maɓɓe. ");
INSERT INTO fue_vpl VALUES ("T16_19","084_6_19","1TI","6","19","19","Hande nun ɓe cuuɗiranta ko'e maɓɓe jawdi booɗuni, tabitintooni, gam nyalaaɗe garooje, ɓe keɓa bo yonki gooŋahi. ");
INSERT INTO fue_vpl VALUES ("T16_20","084_6_20","1TI","6","20","20","Timote, hakkilan ko kalfinaɗaa, woɗɗoda haalaaji baanji baanji ɗi yaadataa e goonɗinki. Hakkilan bo jeddi dow ko woɓɓe wi'ata annal lugguŋal. ");
INSERT INTO fue_vpl VALUES ("T16_21","084_6_21","1TI","6","21","21","Woɓɓe mawnitorake annal ŋal, go ɓe acci goonɗinki. Moƴƴere Alla wonda e mooɗon. ");
INSERT INTO fue_vpl VALUES ("T21_1","085_1_1","2TI","1","1","1","Ɗerewol ŋol ƴiwii diga e am, min Pol, lilaaɗo Yeesu Almasiihu e sago Alla. Mi lilaama gam mi fiina haala dow yonki ki Alla haɓɓani en alkawal, sabbu kawtal men e Yeesu Almasiihu. ");
INSERT INTO fue_vpl VALUES ("T21_2","085_1_2","2TI","1","2","2","Mi sannii maa, an Timote ɓiyam jiɗaaɗo. Alla Baaba meeɗen, e Joomiraawo meeɗen Yeesu Almasiihu enɗee, hokkee moƴƴere e jam! ");
INSERT INTO fue_vpl VALUES ("T21_3","085_1_3","2TI","1","3","3","Mii yetta Alla mo cujidananmi e cuuɗiiɗum ɓerne laaɓuɗum, hande no kaakiraaɓe am waɗunoo. Emi siwtoree jemma e nyalooma fu der du'aaje am. ");
INSERT INTO fue_vpl VALUES ("T21_4","085_1_4","2TI","1","4","4","Mii siwtora gonɗi maa. Mii woodi kumpa yi'itaago maa puy, gam mi seyoo puy. ");
INSERT INTO fue_vpl VALUES ("T21_5","085_1_5","2TI","1","5","5","Mii siwtora goonɗinki maa ki walaa munaafitaare. Maama maa Loyis e inna maa Enis e artu maa woodugo ki. Mii hoolii an bo aa woodi ki. ");
INSERT INTO fue_vpl VALUES ("T21_6","085_1_6","2TI","1","6","6","Gam majjum mii hattinee, accu dokkal ŋal Alla hokku maa no jowumi juuɗe am dow maa ɓeydoo. ");
INSERT INTO fue_vpl VALUES ("T21_7","085_1_7","2TI","1","7","7","Gam Ruuhu ŋu Alla hokki en, laatintaa en hulooɓe. Amma Ruuhu kokkoowo en semme, e yidde, e nantaare o hokki en. ");
INSERT INTO fue_vpl VALUES ("T21_8","085_1_8","2TI","1","8","8","Gam majjum taa sentu seedanaago Joomiraawo meeɗen. Taa sentu bo seedanaago am, min maɓɓaaɗo der kasu gam makko. Hawtu e am der tooraaji gam linjiila, jaka baawɗe ɗe Alla hokku maa. ");
INSERT INTO fue_vpl VALUES ("T21_9","085_1_9","2TI","1","9","9","Kanko hisini en, noddi en gam laatanoɗen mo. Hinaa gam gaɗu meeɗen o hisiniri en, amma gam nun nun o yiɗiri ɗum e moƴƴere makko. Moƴƴere nen o waɗani en diga e Yeesu Almasiihu, diga hanne bane. ");
INSERT INTO fue_vpl VALUES ("T21_10","085_1_10","2TI","1","10","10","Jooni, moƴƴere nen hollitake e garki kisinoowo meeɗen Yeesu Almasiihu. Kanko halki baawɗe maayde. Diga e linjiila o holliti yonki tabitintooki. ");
INSERT INTO fue_vpl VALUES ("T21_11","085_1_11","2TI","1","11","11","Gam sabbu linjiila kan, Alla waɗimmi baajotooɗo, lilaaɗo e janŋinoowo. ");
INSERT INTO fue_vpl VALUES ("T21_12","085_1_12","2TI","1","12","12","Sabbu majjum tooreteemi tooraaji ɗii ɗo, amma mi sentiray ɗum. Gam mii anni mo goonɗinmi. Mii hoolii bo o waawan ko reeni ko o halfinimmi faa nyalaane darŋal yottoo. ");
INSERT INTO fue_vpl VALUES ("T21_13","085_1_13","2TI","1","13","13","Joga haala gooŋaha ka nanuɗaa diga e am. Gollir ka e goonɗinki, e yidde ne keɓuɗen gam een kawti e Yeesu Almasiihu, ka laatanee misaalu. ");
INSERT INTO fue_vpl VALUES ("T21_14","085_1_14","2TI","1","14","14","Joga geetum ɗum kalfinaɗaa e ballal Ruuhu Ceniiɗo gonuɗo der meeɗen. ");
INSERT INTO fue_vpl VALUES ("T21_15","085_1_15","2TI","1","15","15","Aa anni, himɓe leydi Asiya fu accii am, Figelus e Hermogenes na'on der maɓɓe. ");
INSERT INTO fue_vpl VALUES ("T21_16","085_1_16","2TI","1","16","16","Joomiraawo enɗoo himɓe saare Onesifor, gam o deƴƴitinii am. O sentiray bo nanŋoode am der kasu, ");
INSERT INTO fue_vpl VALUES ("T21_17","085_1_17","2TI","1","17","17","accu du no o wari Roma, o dartii am e tinnaare mawne faa o yiitimmi. ");
INSERT INTO fue_vpl VALUES ("T21_18","085_1_18","2TI","1","18","18","Alla Joomiraawo hokka mo enɗam nyaanne darŋal. An e hoore maa aa anni no wooɗi, golle ɗe o waɗanimmi der siire Efesu. ");
INSERT INTO fue_vpl VALUES ("T22_1","085_2_1","2TI","2","1","1","Gam majjum ɓiyam, accu moƴƴere ne keɓuɗen sabbu kawtal men e Yeesu Almasiihu semmiɗinee. ");
INSERT INTO fue_vpl VALUES ("T22_2","085_2_2","2TI","2","2","2","Ko nanuɗaa diga e am yeeso seedeeɓe ɗuuɓɓe, halfin ɗum himɓe hooliniiɓe, waawooɓe ko janŋini woɓɓe. ");
INSERT INTO fue_vpl VALUES ("T22_3","085_2_3","2TI","2","3","3","Jaɓu geɗu toora maa hande soogeeru Yeesu Almasiihu yeeru. ");
INSERT INTO fue_vpl VALUES ("T22_4","085_2_4","2TI","2","4","4","To soogeeru jahooru konu e yiɗi fottango mawɗo mum, hakkilantaa haajuuji duuniyaaru. ");
INSERT INTO fue_vpl VALUES ("T22_5","085_2_5","2TI","2","5","5","Nun nun bo, to gaɗoowo doggudu yawtontire ɗowtanaaki sariyaaji doggudu, heɓataa meetalol. ");
INSERT INTO fue_vpl VALUES ("T22_6","085_2_6","2TI","2","6","6","Demoowo golliiɗo puy, kan nun haani arta nyaama ɓiɓɓe deme mum. ");
INSERT INTO fue_vpl VALUES ("T22_7","085_2_7","2TI","2","7","7","Miija ka batu maa mi faa wooɗa, Joomiraawo faaminte huune fu. ");
INSERT INTO fue_vpl VALUES ("T22_8","085_2_8","2TI","2","8","8","Siwtor Yeesu Almasiihu mo lenyol Dawda. O fintii e maayde, hande no linjiila ka baajootomi bati. ");
INSERT INTO fue_vpl VALUES ("T22_9","085_2_9","2TI","2","9","9","Linjiila kan nun acci mii tooree faa kaɓɓaami e callalluuji, hande gaɗuɗo kalluɗum. Amma haala Alla haɓɓaaka. ");
INSERT INTO fue_vpl VALUES ("T22_10","085_2_10","2TI","2","10","10","Gam majjum munyanmi huune fu, sabbu suɓaaɓe Alla heɓa kamɓe bo, Yeesu Almasiihu hisina ɓe, ɓe keɓa tedduŋal makko tabitiiŋal. ");
INSERT INTO fue_vpl VALUES ("T22_11","085_2_11","2TI","2","11","11","Daa ɗo haala kooliniika: To en maaydii e makko, en buuridan e makko bo. ");
INSERT INTO fue_vpl VALUES ("T22_12","085_2_12","2TI","2","12","12","To en munyanii tooraaji, en laamodoto e makko bo, to en calike mo, kanko bo o saloto en. ");
INSERT INTO fue_vpl VALUES ("T22_13","085_2_13","2TI","2","13","13","To en laataaki hooliniiɓe, kanko o tabitinto oo kooliniiɗo, gam o waawataa ko yeddi hoore makko. ");
INSERT INTO fue_vpl VALUES ("T22_14","085_2_14","2TI","2","14","14","Kanjum haani ciwtoraa goonɗinɓe, eelaa ɓe yeeso Alla ɓe acca jeddi dow haalahon. Jeddi iri ɗii ɗon nafataa goɗɗum, sey majjingo hettiniiɓe. ");
INSERT INTO fue_vpl VALUES ("T22_15","085_2_15","2TI","2","15","15","Tinna daroɗaa yeeso Alla aa koolaaɗo. Laata gollotooɗo mo sentintaake der golle mum. Laatoɗaa bo janŋinoowo haala gooŋaha, hande no fotti. ");
INSERT INTO fue_vpl VALUES ("T22_16","085_2_16","2TI","2","16","16","Seedu e haalaaji baanji baanji, centiniiɗi. Batooɓe ɗi e ɓeydoo woɗɗodaago Alla. ");
INSERT INTO fue_vpl VALUES ("T22_17","085_2_17","2TI","2","17","17","Haala maɓɓe e nandi hande ɓuure kokkollaare, layoore. Himeneyus e Filetus na'on caka maɓɓe. ");
INSERT INTO fue_vpl VALUES ("T22_18","085_2_18","2TI","2","18","18","Ɓe celii laawol gooŋa. Ɓe accii woɓɓe woppi goonɗinki mum e wi'ugo pintol maayɓe waɗii yawtii. ");
INSERT INTO fue_vpl VALUES ("T22_19","085_2_19","2TI","2","19","19","Amma Alla daɗɗii daɗɗa ka dimmataako. Nani ɗo ko winnaa dow makka: «Joomiraawo e anni laataniiɓe ɗum.» Nunnun bo: «Noddoowo inne Joomiraawo fu, woɗɗoo waɗugo ko halli.» ");
INSERT INTO fue_vpl VALUES ("T22_20","085_2_20","2TI","2","20","20","Der suudu manŋol, keeɗe gaɗiraaɗe janɗe geete e kanŋeeri tan bane woni ɗon. Keeɗe gaɗiraaɗe leɗɗe e loope na'on ɗon. Goɗɗe, gollirte golle ɗe tedduŋal, goɗɗe bo golliree golle ɗe walaa tedduŋal. ");
INSERT INTO fue_vpl VALUES ("T22_21","085_2_21","2TI","2","21","21","To goɗɗo laaɓinii hoore mum e kujje ɗee fu, joomum laatoto hande heeɗo gollirteeŋo golle tedduɗe. O laatoto, cenaaɗo, nafoowo joomum, ciriyiiɗo waɗugo golle booɗɗe fu. ");
INSERT INTO fue_vpl VALUES ("T22_22","085_2_22","2TI","2","22","22","Doggu suunooji gojankaaku. Dartu foonnitaare e goonɗinki, e yidde, e jam, an e noddooɓe inne Joomiraawo e ɓerɗe laaɓuɗe fu. ");
INSERT INTO fue_vpl VALUES ("T22_23","085_2_23","2TI","2","23","23","Amma an, woɗɗoda haalaaji ɗi walaa hoore, e jeddi baanji baanji. Aa anni ɗi umminan nun kaɓe. ");
INSERT INTO fue_vpl VALUES ("T22_24","085_2_24","2TI","2","24","24","Gollantooɗo Joomiraawo haaniraa e hawre. Amma o laatoo ɗigguɗo yeeso himɓe fu, o laatoo bo baawuɗo janŋingo, e munyuɗo. ");
INSERT INTO fue_vpl VALUES ("T22_25","085_2_25","2TI","2","25","25","E haani o foorta yeddooɓe mo e jam. Waɗoto Alla walla ɓe, ɓe tuuba, ɓe paama gooŋa. ");
INSERT INTO fue_vpl VALUES ("T22_26","085_2_26","2TI","2","26","26","Den hakkilooji maɓɓe wittaan, ɓe daɗa pitti Seyɗan nanŋunooɗo ɓe, e waɗina ɓe sago mum. ");
INSERT INTO fue_vpl VALUES ("T23_1","085_3_1","2TI","3","1","1","Annu der jaamanuuji cakitiiɗi, wakkatiiji caɗuɗi waran. ");
INSERT INTO fue_vpl VALUES ("T23_2","085_3_2","2TI","3","2","2","Himɓe laatoto yiɗuɓe ko'e mum tan, suunaaɓe ceede, ɓe laatoto jurotooɓe e mawnitintooɓe, ɓe jennan haala Alla. Ɓe ɗowtantaako saareeji maɓɓe, ɓe annaa gaɗu, ɓe teddintaa ko senii. ");
INSERT INTO fue_vpl VALUES ("T23_3","085_3_3","2TI","3","3","3","Ɓe laatoto ɓe ɓerɗe mum yoori, ɓe cawrantaako goɗɗo, nyo'ooɓe himɓe, ɓe galaa nantaare, ɓe yonki bonki, ɓe banyan ko wooɗi. ");
INSERT INTO fue_vpl VALUES ("T23_4","085_3_4","2TI","3","4","4","Ɓe laatoto jammotooɓe, dulluɓe hakkillo, ɓe jiɗan welwelo duuniyaaru ɓura Alla. ");
INSERT INTO fue_vpl VALUES ("T23_5","085_3_5","2TI","3","5","5","Ɓe nandinan ko'e maɓɓe hande hulooɓe Alla, amma ɓee jedda baawɗe mum. Woɗɗoda iri himɓe ɓen. ");
INSERT INTO fue_vpl VALUES ("T23_6","085_3_6","2TI","3","6","6","Woɓɓe maɓɓe e naata e wurooji, ɓee ƴoyra rewɓe ɓe galaa hakkillo, ɓe hakkeeji nyoƴƴi, go suunooji feere feere e wifita ɗum. ");
INSERT INTO fue_vpl VALUES ("T23_7","085_3_7","2TI","3","7","7","Rewɓe ɓen e ekkitoo wakkati fu, amma abada ɓe baawataa ko yottii annal gooŋa. ");
INSERT INTO fue_vpl VALUES ("T23_8","085_3_8","2TI","3","8","8","Hande no Yannes e Yamberes haɓidiri Muusa, nunnun himɓe ɓen haɓidirta e gooŋa. Hakkillo maɓɓe wuurake, goonɗinki maɓɓe walaa nafuwe. ");
INSERT INTO fue_vpl VALUES ("T23_9","085_3_9","2TI","3","9","9","Amma ɓe keɓataa saa'a, gam haaŋaare maɓɓe laaɓanan himɓe fu, hande no ɗum laatii e Yannes e Yamberes. ");
INSERT INTO fue_vpl VALUES ("T23_10","085_3_10","2TI","3","10","10","Amma an Timote, a yi'i no janŋinirmi. A yi'ii jikku am, e anniya am, e goonɗinki am, e munyal am, e yidde am, e tinnaare am. ");
INSERT INTO fue_vpl VALUES ("T23_11","085_3_11","2TI","3","11","11","Aa anni tooraaji am, e boneeji am. A yi'ii ko heɓimmi Antiyokiya e Ikoniya, e Listira fu. A yi'i bo no munyirmi dow tooraaji ɗi keɓumi. Amma Joomiraawo wurtinii am e majji ɗi fu. ");
INSERT INTO fue_vpl VALUES ("T23_12","085_3_12","2TI","3","12","12","Hawtuɓe e Yeesu Almasiihu, go e yiɗi hulugo Alla, ɓe toorete. ");
INSERT INTO fue_vpl VALUES ("T23_13","085_3_13","2TI","3","13","13","Amma halluɓe e hiilooɓe, ɓeydoto e halla. Ɓe majjinan woɓɓe, gam kamɓe bo ɓee majji. ");
INSERT INTO fue_vpl VALUES ("T23_14","085_3_14","2TI","3","14","14","Amma an, joga ko ekkitiɗaa, e ko kooliiɗaa e semme. Aa anni moy ekkitin maa ɗum. ");
INSERT INTO fue_vpl VALUES ("T23_15","085_3_15","2TI","3","15","15","Diga sukaaku maa, aa anni Dewte ceniiɗe. Kanje ɗe baawan ko hokku maa faamu, jiitiraa kisidam keɓeteeɗam diga e goonɗingo Yeesu Almasiihu. ");
INSERT INTO fue_vpl VALUES ("T23_16","085_3_16","2TI","3","16","16","Binni ceniini fu ƴiwii diga e kollitinki Alla. Nafuwe majje woni, janŋingo gooŋa, e hollugo boofi, e moƴƴingo ɗi, e ekkitingo wonaago no fottiri. ");
INSERT INTO fue_vpl VALUES ("T23_17","085_3_17","2TI","3","17","17","Nunnun neɗɗo Alla fu laatortoo kebbuɗo, ciriyiiɗo waɗugo golle geete. ");
INSERT INTO fue_vpl VALUES ("T24_1","085_4_1","2TI","4","1","1","Mii eelee yeeso Alla e yeeso Yeesu Almasiihu, kiitotooɗo wuuruɓe e maayɓe. Mii eelee bo sabbu wittoygo makko e Laamaare makko: ");
INSERT INTO fue_vpl VALUES ("T24_2","085_4_2","2TI","4","2","2","Waaja haala Alla, waajita ka wakkati fu, baa ɗum fottanii ɓe, baa ɗum fottanay ɓe. Felu ɓe, semmiɗin ɓe e munyal, aa janŋina ɓe. ");
INSERT INTO fue_vpl VALUES ("T24_3","085_4_3","2TI","4","3","3","Gam wakkati waran de himɓe salotoo nanugo ekkitinol poortiiŋol. Ɓe tokkoto suunooji maɓɓe. Ɓe dartanan ko'e maɓɓe janŋinooɓe ɗuuɓɓe, janŋinanɓe ɓe ko ɓe jiɗi nanugo. ");
INSERT INTO fue_vpl VALUES ("T24_4","085_4_4","2TI","4","4","4","Ɓe cukkan noppi maɓɓe gam to ɓe nanu gooŋa, ɓe baylitinto far to taalaaji. ");
INSERT INTO fue_vpl VALUES ("T24_5","085_4_5","2TI","4","5","5","Amma an, nantu hoore maa der huune fu. Munyan tooraaji, waɗu golle baajotooɗo linjiila, heennyitin golle maa faa wooɗa. ");
INSERT INTO fue_vpl VALUES ("T24_6","085_4_6","2TI","4","6","6","Amma min, mi ɓadike laataago sadaka, hande kiriseteeɗi, wakkati yawtugo am ɓadake. ");
INSERT INTO fue_vpl VALUES ("T24_7","085_4_7","2TI","4","7","7","Mi haɓii hawre wooɗune, mi yottinii doggudu am, mii joggii goonɗinki. ");
INSERT INTO fue_vpl VALUES ("T24_8","085_4_8","2TI","4","8","8","Diga jooni, Joomiraawo kiitotooɗo e gooŋaaku, e resanimmi riiba kokketeeka poonnitiiɗo nyaanne darŋal. Min tan bane hokketee ka. Amma, min e hettiniiɓe, yiɗuɓe wittoygo makko fu, o hokkata ka. ");
INSERT INTO fue_vpl VALUES ("T24_9","085_4_9","2TI","4","9","9","Tinna garaa to am law. ");
INSERT INTO fue_vpl VALUES ("T24_10","085_4_10","2TI","4","10","10","Gam Demas accii am, sabbu yidde duuniyaaru, o yahii Tesalonika. Kereskes yahii Galaatiya, Titus bo yahii Dalmatiya. ");
INSERT INTO fue_vpl VALUES ("T24_11","085_4_11","2TI","4","11","11","Luka tan nun wondi e am. Waddu Marku to aa wara, o nafan am sanne der golle am. ");
INSERT INTO fue_vpl VALUES ("T24_12","085_4_12","2TI","4","12","12","Tikikus, mi lilii ɗum Efesu. ");
INSERT INTO fue_vpl VALUES ("T24_13","085_4_13","2TI","4","13","13","To aa wara, gaddanaa am gulunfaare am ne accumi Torowas, wuro Karpus. Gaddanaa am bo dewte am, ko jogii am ɓuri woni, dewte am ɗe guri. ");
INSERT INTO fue_vpl VALUES ("T24_14","085_4_14","2TI","4","14","14","Aleksandire bahillo waɗanii am ko halli puy. Joomiraawo yoɓan mo ko o waɗi. ");
INSERT INTO fue_vpl VALUES ("T24_15","085_4_15","2TI","4","15","15","An bo, hakkilan mo, gam o salake waaji amen e semme. ");
INSERT INTO fue_vpl VALUES ("T24_16","085_4_16","2TI","4","16","16","Nyalaane arandeere ne darinaami yeeso kiitoowo gam mi toontano hoore am, baa gooto wallay am, ɓe fu ɓe accii am. To Alla liman ɓe ɗum gacce! ");
INSERT INTO fue_vpl VALUES ("T24_17","085_4_17","2TI","4","17","17","Amma Joomiraawo wallii am, semmiɗinimmi. Kan acci keennyitimmi golle waaji am. Himɓe lenyi janani fu nanii waaji ɗin. Nunnun daɗirmi diga e hunnuko jaggere. ");
INSERT INTO fue_vpl VALUES ("T24_18","085_4_18","2TI","4","18","18","Joomiraawo daɗinan am ko halli fu, o yottinammi jam to Laamaare makko ne kammu. Tedduŋal laatanoo mo faa abada. Aami! ");
INSERT INTO fue_vpl VALUES ("T24_19","085_4_19","2TI","4","19","19","Mi sannii Pirisilla e Akilas, mi sannii getti wuro Onesifor. ");
INSERT INTO fue_vpl VALUES ("T24_20","085_4_20","2TI","4","20","20","Erastus darake Korintu, Torofimus bo, mi accii ɗum Miletus oo nyawi. ");
INSERT INTO fue_vpl VALUES ("T24_21","085_4_21","2TI","4","21","21","Tinna garaa go dabbune waɗa. Ebulus e Pudes e Linus e Kalawdiya e sakikiraaɓe wonɓe ɗo fu, sannii maa. ");
INSERT INTO fue_vpl VALUES ("T24_22","085_4_22","2TI","4","22","22","Joomiraawo wonda e maa! Moƴƴere Alla wonda e mooɗon. ");
INSERT INTO fue_vpl VALUES ("TT1_1","086_1_1","TIT","1","1","1","Ɗerewol ŋol ɗo ƴiwii e am, min Pol, maccuɗo Alla e lilaaɗo Yeesu Almasiihu. Alla yowanii am mi waɗa suɓaaɓe makko goonɗina mo. O yowanii am anningo ɓe gooŋa jaadooha e goonɗinki men. ");
INSERT INTO fue_vpl VALUES ("TT1_2","086_1_2","TIT","1","2","2","Hande non ɓe goodirta hoolaare heɓugo yonki tabitiiki. Alla mo fewataa haɓɓaniino en alkawal yonki kin diga huune fu tagaaka. ");
INSERT INTO fue_vpl VALUES ("TT1_3","086_1_3","TIT","1","3","3","No wakkati waɗi, o anninii haala makko diga e waaji ɗi o yowanimmi hande no Alla Kisinoowo en umuri ɗum. ");
INSERT INTO fue_vpl VALUES ("TT1_4","086_1_4","TIT","1","4","4","Titus, mi sannii maa, an, laatiiɗo ɓiyam e gooŋa diga e goonɗinki men gooti. Alla Baaba, e Yeesu Almasiihu Kisinoowo en waɗanee moƴƴere, hokkee bo jam! ");
INSERT INTO fue_vpl VALUES ("TT1_5","086_1_5","TIT","1","5","5","Mi accii maa Kereta gam moƴƴinaa ko horii moƴƴineego. Cuɓanaa genni fu dottiiɓe Eklesiya hande no bi'uno maa mi. ");
INSERT INTO fue_vpl VALUES ("TT1_6","086_1_6","TIT","1","6","6","Sey dottiijo cuɓaaɗo fu laatoo mo walaa gacce. O laatoo gorko mo debbo gooto, mo ɓiɓɓe mum laatii goonɗinɓe. Ɓiɓɓe ɓen laatoo ɓe nyo'irtaake baadi baanjaari, ɗum bo dullere ɗowtaare. ");
INSERT INTO fue_vpl VALUES ("TT1_7","086_1_7","TIT","1","7","7","Doole ardiiɗo Eklesiya fu laatoo mo walaa gacce, gam o laati nun gollantooɗo Alla. Haanay o laatoo mawnitiiɗo, ɗum bo mo mone, maa bo jaroowo bagi, ɗum bo kaɓaaɗo, maa bo cuunaaɗo riiba kalluka. ");
INSERT INTO fue_vpl VALUES ("TT1_8","086_1_8","TIT","1","8","8","Amma sey joomum e laatii bernoowo hoɓɓe, jiɗuɗo ko wooɗi, mo hakkillo, poonnitiiɗo, laaɓuɗo, nantiiɗo. ");
INSERT INTO fue_vpl VALUES ("TT1_9","086_1_9","TIT","1","9","9","Sey joomum e jogii haala kooliniika hande no ka janŋiniraa. Den o waawan ko semmiɗini woɓɓe e ekkitinol laaɓuŋol, o waawan bo ko jaalii yeddooɓe. ");
INSERT INTO fue_vpl VALUES ("TT1_10","086_1_10","TIT","1","10","10","E gooŋa, ɗuuɓɓe e laatii nanaruuɓe, accu du caka Yahuduuɓe goonɗinɓe. Ɓee laatii batooɓe haalaaji ɗi walaa hoore, ɓee ƴoyra himɓe. ");
INSERT INTO fue_vpl VALUES ("TT1_11","086_1_11","TIT","1","11","11","Sukku kunnuɗe maɓɓe, gam ɓee biisa saareeji ɗuuɗɗi. Ɓee ekkitina ko haanay, gam ɓe keɓa riiba kalluka. ");
INSERT INTO fue_vpl VALUES ("TT1_12","086_1_12","TIT","1","12","12","Neɗɗo maɓɓe, mo himɓe daari hande annabiijo, batii du, wi'i: «Keretaaɓe laati nun fewooɓe wakkati fu, ɓee laatii bisaaji bonɗi, ciiwankeeɓe, e deereruuɓe.» ");
INSERT INTO fue_vpl VALUES ("TT1_13","086_1_13","TIT","1","13","13","O batii gooŋa. Gam majjum, felu ɓe e semme, gam ɓe keɓa goonɗinki geeti. ");
INSERT INTO fue_vpl VALUES ("TT1_14","086_1_14","TIT","1","14","14","Ɓe acca tokkugo taalaaji Yahuduuɓe, e oodaaji himɓe yoofuɓe gooŋa. ");
INSERT INTO fue_vpl VALUES ("TT1_15","086_1_15","TIT","1","15","15","Huune fu e laaɓi to laaɓuɓe. Amma walaa ko laaɓi, to soɓuɓe e ɓe goonɗinay, gam hakkillo maɓɓe e cuuɗiiɗum ɓerne maɓɓe fu soɓii. ");
INSERT INTO fue_vpl VALUES ("TT1_16","086_1_16","TIT","1","16","16","Ɓee bi'a ɓee anni Alla, amma golle maɓɓe e yedda no ɓee anni mo. Ɓee laatii nyidduɓe, e nanaruuɓe. Ɓe baawataa ko waɗi geetum baa gootum. ");
INSERT INTO fue_vpl VALUES ("TT2_1","086_2_1","TIT","2","1","1","Amma an, accu batu maaɗa yaada e ekkitinol gooŋawol. ");
INSERT INTO fue_vpl VALUES ("TT2_2","086_2_2","TIT","2","2","2","Worɓe nayeeɓe, batu ɓe no haani ɓe laatoo nantiiɓe, fotuɓe teddineego, hakkilɓe. Ɓe laatoo ɓe goonɗinki mum yanɗi, ɓe gooda yidde e munyal. ");
INSERT INTO fue_vpl VALUES ("TT2_3","086_2_3","TIT","2","3","3","Batu rewɓe nayeeɓe bo, wonoo hande no haani rewɓe goonɗinɓe wonoroo. To ɓe laatoo nyo'ooɓe himɓe, ɗum bo horɓe bagi. Amma ɓe laatoo ekkitinooɓe ko wooɗi. ");
INSERT INTO fue_vpl VALUES ("TT2_4","086_2_4","TIT","2","4","4","Ɓe ekkitina rewɓe saaŋooɓe yiɗugo worɓe mum, e sukaaɓe mum. ");
INSERT INTO fue_vpl VALUES ("TT2_5","086_2_5","TIT","2","5","5","Ɓe laatoo hakkilɓe, laaɓuɓe. Ɓe kiinnoo golle wuro maɓɓe, ɓe laatoo yeeɗɗuɓe. Moy fu ɗowtanoo gorko muuɗum, gam to haala Alla yennee. ");
INSERT INTO fue_vpl VALUES ("TT2_6","086_2_6","TIT","2","6","6","Waaja gojankeeɓe, ɓe laatoo hakkilɓe der huune fu. ");
INSERT INTO fue_vpl VALUES ("TT2_7","086_2_7","TIT","2","7","7","An e hoore maa, laatana ɓe misaalu der golle booɗɗe fu. Ekkitin ɓe ekkitinol gooŋawol, e pottuŋol. ");
INSERT INTO fue_vpl VALUES ("TT2_8","086_2_8","TIT","2","8","8","Haala maa laatoo gooŋaha, ka yeddataako, gam wayɓe meeɗen jiɓoo, ɓe dulla kalluka ka ɓe batani en. ");
INSERT INTO fue_vpl VALUES ("TT2_9","086_2_9","TIT","2","9","9","Maccuɓe bo, waaja ɓe, ɓe nanana joomiraaɓe maɓɓe der huune fu. Ɓe gaɗa ko welata ɓe, to ɓe jeddontir e maɓɓe. ");
INSERT INTO fue_vpl VALUES ("TT2_10","086_2_10","TIT","2","10","10","To ɓe bujju ɓe, amma wakkati fu, ɓe kollita ɓee laatii hoolaaɓe, hebbuɓe. Ɓe gaɗa ɗum gam ekkitinol haala Alla kisinoowo en, teddinee der huune fu. ");
INSERT INTO fue_vpl VALUES ("TT2_11","086_2_11","TIT","2","11","11","E gooŋa, moƴƴere Alla hollitake gam himɓe fu hisa. ");
INSERT INTO fue_vpl VALUES ("TT2_12","086_2_12","TIT","2","12","12","Moƴƴere nen e ekkitina en accen wonaago der dullere kulol Alla, e suunooji duuniyaaru. Nee ekkitina en bo laatoɗen hakkilɓe, e foonnitiiɓe, e hulooɓe Alla der duuniyaaru nuu ɗo. ");
INSERT INTO fue_vpl VALUES ("TT2_13","086_2_13","TIT","2","13","13","Hande non keɗortoɗen nyalaane barkiɗinaane, ne tammihiɗen. Nyalaane nen, Yeesu Almasiihu, Alla meeɗen mawɗo, Kisinoowo en, hollitinto e tedduŋal. ");
INSERT INTO fue_vpl VALUES ("TT2_14","086_2_14","TIT","2","14","14","O hokkii hoore makko gam men, o sooditii en diga ko halli fu. O laatinii en himɓe makko ɓe o woodi, laaɓinaaɓe, tinniiɓe waɗugo golle geete. ");
INSERT INTO fue_vpl VALUES ("TT2_15","086_2_15","TIT","2","15","15","Kanjum haani bataa himɓe, nun bo haani baajoɗaa ɓe, pelaa ɓe e baawɗe maa fu. Taa accu goɗɗo yawee. ");
INSERT INTO fue_vpl VALUES ("TT3_1","086_3_1","TIT","3","1","1","Siwtor goonɗinɓe ɓe nanana mawɓe leydi, e wooduɓe baawɗe. Ɓe ɗowtanoo ɓe, ɓee ciriyii waɗugo golle booɗɗe fu. ");
INSERT INTO fue_vpl VALUES ("TT3_2","086_3_2","TIT","3","2","2","To ɓe batu kalluka dow goɗɗo, ɓe laatoo deƴƴuɓe, e sawriiɓe, e weluɓe deeɗi dow himɓe fu. ");
INSERT INTO fue_vpl VALUES ("TT3_3","086_3_3","TIT","3","3","3","Gam enen bo, een laatinoo ɓe walaa hakkillo, nanaruuɓe, e majjuɓe. Een laatinoo maccuɓe jiɗaali, e suunooji ɗiye fu. Een goodunoo ganyaani e nawniraagu, een banyontiri, en banyaa, een banyontiri. ");
INSERT INTO fue_vpl VALUES ("TT3_4","086_3_4","TIT","3","4","4","Amma Alla Kisinoowo en hollitii himɓe geetaaku mum e yidde mum. ");
INSERT INTO fue_vpl VALUES ("TT3_5","086_3_5","TIT","3","5","5","O hisinii en, amma hinaa gam en gaɗii golle poonnitiiɗe, e enɗam makko o rimitorii en, laatiɗen heyɓe diga e Ruuhu Ceniiɗo laaɓinɗo en. ");
INSERT INTO fue_vpl VALUES ("TT3_6","086_3_6","TIT","3","6","6","Alla hokkii en Ruuhu mum ceniiɗo puy, diga e Yeesu Almasiihu Kisinoowo en. ");
INSERT INTO fue_vpl VALUES ("TT3_7","086_3_7","TIT","3","7","7","O waɗii ɗum diga moƴƴere makko gam laatoɗen foonnitiiɓe, heɓa donen yonki tabitiiki, ki tammiɗen heɓugo. ");
INSERT INTO fue_vpl VALUES ("TT3_8","086_3_8","TIT","3","8","8","Kanka woni haala kooliniika. Mii yiɗi tasinaa ka, gam goonɗinɓe Alla tinnoo waɗugo golle booɗɗe. Kanjum woni ko wooɗi, ko nafata himɓe. ");
INSERT INTO fue_vpl VALUES ("TT3_9","086_3_9","TIT","3","9","9","Amma woɗɗoda haalaaji ɗi walaa hoore, e jeddi dow habaruuji lenyi, e kaɓe, e jeddi dow tawreeta. Haalaaji ɗii ɗon fu nafataa goɗɗum, baanji ɗi laatii. ");
INSERT INTO fue_vpl VALUES ("TT3_10","086_3_10","TIT","3","10","10","Gaddoowo ceennol caka himɓe, felu mo de woore, de ɗiɗi, to o salake, takku mo sera. ");
INSERT INTO fue_vpl VALUES ("TT3_11","086_3_11","TIT","3","11","11","Annu gaɗoowo hande non laati nun majjuɗo e hakkeejo, o doƴƴii hoore makko kiita. ");
INSERT INTO fue_vpl VALUES ("TT3_12","086_3_12","TIT","3","12","12","To mi lilii Artemas naa bo Tikikus to maa, yawɗa garaa law, tawaa am Nikopolis, gam ton jiɗumi dabbugo. ");
INSERT INTO fue_vpl VALUES ("TT3_13","086_3_13","TIT","3","13","13","Tinna ballaa Jenas, moodibbo tawreeta, e Apollos, gam to goɗɗum jaccu ɓe der jahaaŋal maɓɓe. ");
INSERT INTO fue_vpl VALUES ("TT3_14","086_3_14","TIT","3","14","14","E haani himɓe meeɗen bo ekkitoo waɗugo golle booɗɗe. Ɓe balla haajaaɓe walleego gam to kamɓe wallooɓe ɓen ɓe gonoo baanji. ");
INSERT INTO fue_vpl VALUES ("TT3_15","086_3_15","TIT","3","15","15","Wonduɓe e am fu sannii maa. Emen canna goonɗinɓe yiɗuɓe men fu. Moƴƴere Alla wonda e mooɗon, on fu. ");
INSERT INTO fue_vpl VALUES ("PM1_1","087_1_1","PHM","1","1","1","Min Pol, e banniraawo meeɗen Timote nun winni ɗerewol ŋol. Min Pol, mii laatii maɓɓaaɗo gam daliila Yeesu Almasiihu. Emen canna Filemon, jiɗaaɗo amen, gollodintooɗo e amen. ");
INSERT INTO fue_vpl VALUES ("PM1_2","087_1_2","PHM","1","2","2","Emen canna bo Afiya, sakiike men debbo, e Arkippus kaɓidoowo e meeɗen gam linjiila, e goonɗinɓe hawritintooɓe der wuro maa. ");
INSERT INTO fue_vpl VALUES ("PM1_3","087_1_3","PHM","1","3","3","Alla Baaba meeɗen, e Yeesu Almasiihu Joomiraawo, hokka on moƴƴere e jam. ");
INSERT INTO fue_vpl VALUES ("PM1_4","087_1_4","PHM","1","4","4","Filemon, mii yetta Alla wakkati fu, mi accay siwtorgo maa der du'aaje am. ");
INSERT INTO fue_vpl VALUES ("PM1_5","087_1_5","PHM","1","5","5","E gooŋa, mi nanii yidde e goonɗinki maaɗa dow Joomiraawo Yeesu e batanee, e no jiɗirɗaa himɓe Alla fu. ");
INSERT INTO fue_vpl VALUES ("PM1_6","087_1_6","PHM","1","6","6","Emii eela Alla, gam goonɗinki kii ɗo hawti en yi'oo der gaɗu. Den paaminaa geetum fu ɗum baaweten waɗugo gam Almasiihu. ");
INSERT INTO fue_vpl VALUES ("PM1_7","087_1_7","PHM","1","7","7","Banniraawo, ɓerne am seyake puy, hakkillo am fukkake bo, gam yidde maa deƴƴitinii himɓe Alla. ");
INSERT INTO fue_vpl VALUES ("PM1_8","087_1_8","PHM","1","8","8","Mii woodi laawol der kawtal men e Almasiihu mi eelee ko haani gaɗaa. ");
INSERT INTO fue_vpl VALUES ("PM1_9","087_1_9","PHM","1","9","9","Amma, mii ɓuri yiɗugo, mi eelee gam yidde, min Pol dottiijo, jooni bo mii maɓɓaaɗo sabbu Yeesu Almasiihu. ");
INSERT INTO fue_vpl VALUES ("PM1_10","087_1_10","PHM","1","10","10","Mii eelee gam Onesimu ɓiyam mo keɓumi goonɗini der kasu. ");
INSERT INTO fue_vpl VALUES ("PM1_11","087_1_11","PHM","1","11","11","Naane, o nafayno maa, amma jooni, o nafan en, min e maa. ");
INSERT INTO fue_vpl VALUES ("PM1_12","087_1_12","PHM","1","12","12","Mii wittina mo to maaɗa, jaɓu mo hande min e hoore am. ");
INSERT INTO fue_vpl VALUES ("PM1_13","087_1_13","PHM","1","13","13","Mii yiɗuno haggugo mo to am, gam o wallammi hande no haani balliraano am jooni no tawaami der kasu gam linjiila. ");
INSERT INTO fue_vpl VALUES ("PM1_14","087_1_14","PHM","1","14","14","Amma mi yiɗay waɗugo goɗɗum to hinaa en baddii, gam mi yiɗaa waɗingo maa booɗɗum e doole, amma ɗum laatoo e sago maa. ");
INSERT INTO fue_vpl VALUES ("PM1_15","087_1_15","PHM","1","15","15","Waɗoto Onesimu seenniriino e maa wakkati seɗɗa, gam o wonda e maa, e baadey. ");
INSERT INTO fue_vpl VALUES ("PM1_16","087_1_16","PHM","1","16","16","O laataaki kade maccuɗo tan, oo ɓuri maccuɗo, o laatike banniraawo men jiɗaaɗo. Min, mii yiɗi mo sanne. Mii anni aa yiɗi mo ɓuri, hinaa hande neɗɗo tan, amma hande goonɗinɗo Joomiraawo. ");
INSERT INTO fue_vpl VALUES ("PM1_17","087_1_17","PHM","1","17","17","To a daarii am hande igo maa, den kan, jaɓu mo hande no jaɓirtaa am min e hoore am. ");
INSERT INTO fue_vpl VALUES ("PM1_18","087_1_18","PHM","1","18","18","To o woofaniino maa, ɗum bo to o joganiino maa nyamaane, yowanam ɗum. ");
INSERT INTO fue_vpl VALUES ("PM1_19","087_1_19","PHM","1","19","19","Min Pol, mii winna ka e junŋo am, mi yoɓete ɗum. Amma mii siwtoree, an bo aa joganii am nyamaane, nyamaane nen bo, an e hoore maa nun. ");
INSERT INTO fue_vpl VALUES ("PM1_20","087_1_20","PHM","1","20","20","An banniraawo am, waɗanam ɗum sabbu Joomiraawo, deƴƴitin ɓerne am gam kawtal men e Almasiihu. ");
INSERT INTO fue_vpl VALUES ("PM1_21","087_1_21","PHM","1","21","21","Mii winnanee gam mii hoolii a nananan am, gam mii anni a waɗan ɓuri ko eelu maa mi. ");
INSERT INTO fue_vpl VALUES ("PM1_22","087_1_22","PHM","1","22","22","Sikan, ciriyanoɗaa am suudu to beeranmi, gam mii miila, Alla jaɓan du'aaje mon, o wittinanmi to mooɗon. ");
INSERT INTO fue_vpl VALUES ("PM1_23","087_1_23","PHM","1","23","23","Epafaras mo maɓɓidaami gam Yeesu Almasiihu sanni maa. ");
INSERT INTO fue_vpl VALUES ("PM1_24","087_1_24","PHM","1","24","24","Marku bo, e Aristarkus, e Demas, e Luka gollidooɓe e am sannii maa. ");
INSERT INTO fue_vpl VALUES ("PM1_25","087_1_25","PHM","1","25","25","Moƴƴere Yeesu Almasiihu Joomiraawo meeɗen wonda e mooɗon. ");
INSERT INTO fue_vpl VALUES ("HB1_1","088_1_1","HEB","1","1","1","Diga ko ɓooyi, Alla baddiino kaakiraaɓe meeɗen de ɗuuɗɗum, e laabi feere feere. O baddii ɓe diga e annabiiɓe. ");
INSERT INTO fue_vpl VALUES ("HB1_2","088_1_2","HEB","1","2","2","Amma der nyalaaɗe cakittiiɗe ɗee ɗo, o baddii en diga e Ɓiyiiko. E makko Alla tagiri duuniyaaru e kammu. Kanko nun bo Alla suɓi laatoo donoowo huune fu. ");
INSERT INTO fue_vpl VALUES ("HB1_3","088_1_3","HEB","1","3","3","Kanko nun laatii jayŋol jalboowol, kollitoowol tedduŋal Alla, e no Alla laatii e gooŋa. Oo jogii huune fu diga e haala makko gooduka baawɗe. Ɓaawo o laaɓini hakkeeji himɓe, o jooɗake dow kammu, to nyaamo Alla mawɗo, mo tedduŋal. ");
INSERT INTO fue_vpl VALUES ("HB1_4","088_1_4","HEB","1","4","4","Ɓiɗɗo e ɓurii malaykaaɓe manŋu, kan waɗi Alla hokki mo inne ɓurune inɗe maɓɓe. ");
INSERT INTO fue_vpl VALUES ("HB1_5","088_1_5","HEB","1","5","5","Malaykaajo moy nun Alla meeɗi ko wi'i: «An laatii Ɓiɗɗo am, hanne min nun laatii Baaba maa?» Moy o wi'i kade: «Mi laatanto mo Baaba, kanko bo, o laatanoo am Ɓiɗɗo?» ");
INSERT INTO fue_vpl VALUES ("HB1_6","088_1_6","HEB","1","6","6","Kade bo, no o liloyta Afo makko e duuniyaaru, o wi'i: «Malaykaaɓe Alla fu sujidana mo.» ");
INSERT INTO fue_vpl VALUES ("HB1_7","088_1_7","HEB","1","7","7","Dow malaykaaɓe bo Alla wi'ii: «Oo gollira malaykaaɓe makko hande keni, o waɗii ɓe jagganoo mo hande ɗelle yiite.» ");
INSERT INTO fue_vpl VALUES ("HB1_8","088_1_8","HEB","1","8","8","Amma dow Ɓiɗɗo, o wi'i: «Laamu maa, an Alla, wonoo faa abada! A laamoranto himɓe maa e sawru foonnitaare. ");
INSERT INTO fue_vpl VALUES ("HB1_9","088_1_9","HEB","1","9","9","Aa yiɗi foonnitaare, aa wanyi ko halli, gam majjum, Alla maaɗa suɓi ma, wuju maa nebbam seyo ɓuruŋo ŋo wonduɓe e maaɗa.» ");
INSERT INTO fue_vpl VALUES ("HB1_10","088_1_10","HEB","1","10","10","O wi'i kade: «Joomiraawo, diga fuɗɗoode, an tagi leydi, juuɗe maa tagi kammu. ");
INSERT INTO fue_vpl VALUES ("HB1_11","088_1_11","HEB","1","11","11","Ɗum fu, ɗum halkan, amma an, a tabbitinto, ɗum fu, ɗum hiiɗɗan hande kolte, ");
INSERT INTO fue_vpl VALUES ("HB1_12","088_1_12","HEB","1","12","12","a taggan ɗum hande toggoore, ɗum waylitinte, hande kolte. Amma an, a waylitintaako. Duuɓi maa bo heennyataa.» ");
INSERT INTO fue_vpl VALUES ("HB1_13","088_1_13","HEB","1","13","13","Alla meeɗay ko wi'i malaykaajo gom: «Jooɗa nyaamo am gam mi waɗa wanyuɓe maa laatoo jaaɓirɗum koyɗe maa.» ");
INSERT INTO fue_vpl VALUES ("HB1_14","088_1_14","HEB","1","14","14","Malaykaaɓe fu laati nun ruuhuuji jaggantooɗi Alla, oo lila ɗi gam ɗi gollanoo ronooɓe kisidam. ");
INSERT INTO fue_vpl VALUES ("HB2_1","088_2_1","HEB","2","1","1","Gam majjum, e haani kakkilanen puy ko nanuɗen, gam to en boɗɗodee laawol. ");
INSERT INTO fue_vpl VALUES ("HB2_2","088_2_2","HEB","2","2","2","Haala ka Alla hokki diga e malaykaaɓe goonɗii. Woofuɓe e saliiɓe ɗowtanaago ka fu, heɓan kiita kaa ɗo haanani ɓe. ");
INSERT INTO fue_vpl VALUES ("HB2_3","088_2_3","HEB","2","3","3","To non noy daɗirten, to en jeebake kisidam mawɗam hande ɗam ɗo? Joomiraawo nun arti batango kisidam ɗam, den nanuɓe tabbitinanii en ɗam. ");
INSERT INTO fue_vpl VALUES ("HB2_4","088_2_4","HEB","2","4","4","Alla semmiɗinii seedaaku maɓɓe e waɗugo maaneeji, e kaayɗiniiɗum, e kaayeefiiji feere feere. Alla hollitii ɗum bo e seennango ɓe Ruuhu Ceniiɗo hande no o yiɗiri. ");
INSERT INTO fue_vpl VALUES ("HB2_5","088_2_5","HEB","2","5","5","Alla hokkay malaykaaɓe ɓe laamano duuniyaaru garoowu nu batanten. ");
INSERT INTO fue_vpl VALUES ("HB2_6","088_2_6","HEB","2","6","6","Goɗɗo batii nokkun der Dewtere, wi'i: «Ume neɗɗo laatii faa ciwtoraa ɗum? naa ɓii-aadama ko paaleɗaa ɗum? ");
INSERT INTO fue_vpl VALUES ("HB2_7","088_2_7","HEB","2","7","7","A leesinii mo wakkati seɗɗa ley malaykaaɓe, a meelii mo tedduŋal e manŋu. ");
INSERT INTO fue_vpl VALUES ("HB2_8","088_2_8","HEB","2","8","8","A yowii huune fu ley koyɗe makko.» No Alla yowani mo huune fu, eɗum holla no goɗɗum horaaki ko o yowanay mo junŋo. Jooni en ji'ataa taw no o yowanii mo kujje fu junŋo. ");
INSERT INTO fue_vpl VALUES ("HB2_9","088_2_9","HEB","2","9","9","Amma een ji'a Yeesu leesinanooɗo wakkati seɗɗa ley malaykaaɓe, jooni o meelinaama tedduŋal e manŋu. Gam ume? Gam o toorake, o maayi. Hande non, sabbu moƴƴere Alla, o maayiranii himɓe fu. ");
INSERT INTO fue_vpl VALUES ("HB2_10","088_2_10","HEB","2","10","10","Ɗum fottanii Alla taguɗo huune fu, e mo gam mum huune fu woni, yaara himɓe ɗuuɓɓe ɓe keɓa tedduŋal. Ɗum fottanii mo bo, o yottina Yeesu maɓɓitinɗo laawol kisidam, o laato kebbuɗo diga e tooraaji. ");
INSERT INTO fue_vpl VALUES ("HB2_11","088_2_11","HEB","2","11","11","Gam laaɓinoowo, e laaɓinteeɓe fu ƴiwii diga e baaba gooto. Kan waɗi o sentay noddugo ɓe banniraaɓe. ");
INSERT INTO fue_vpl VALUES ("HB2_12","088_2_12","HEB","2","12","12","O wi'ii: «Mi batan banniraaɓe am inne maa, mi maantete caka jama'aare maa.» ");
INSERT INTO fue_vpl VALUES ("HB2_13","088_2_13","HEB","2","13","13","O wi'ii kade: «Mi yowan hoolaare am fu dow Alla.» Kade bo, o wi'i: «Mi nani, min e ɓiɓɓe ɓe Alla hokkimmi.» ");
INSERT INTO fue_vpl VALUES ("HB2_14","088_2_14","HEB","2","14","14","Hande no ɓiɓɓe woodiri ɓannu e ƴiiƴam, hande non Yeesu bo ettiri ɓannu, laatii hande maɓɓe. O waɗii ɗum gam diga e maayde makko, o halka baawɗe laamaniiɗo maayde, waato Seyɗan. ");
INSERT INTO fue_vpl VALUES ("HB2_15","088_2_15","HEB","2","15","15","Diga e majjum o rinɗini laatiiɓe maccuɓe der gonki mum fu, gam ɓe kuliino maayde. ");
INSERT INTO fue_vpl VALUES ("HB2_16","088_2_16","HEB","2","16","16","Gam een anni, malaykaaɓe bane Yeesu wari wallugo, amma laatiiɓe lenyol Iburahiima nun. ");
INSERT INTO fue_vpl VALUES ("HB2_17","088_2_17","HEB","2","17","17","Gam majjum, e haani o nanda e banniraaɓe makko der huune fu. Hande non o laatorii hooreejo Limaamiiɓe mo enɗam, koolaaɗo der golle Alla, gam o moyta hakkeeji jama'aare. ");
INSERT INTO fue_vpl VALUES ("HB2_18","088_2_18","HEB","2","18","18","Kanko e hoore makko o tooraama, o jarbaa. Gam majjum, o waawan wallugo jarbaaɓe. ");
INSERT INTO fue_vpl VALUES ("HB3_1","088_3_1","HEB","3","1","1","Banniraaɓe goonɗinɓe, onon ɓe Alla noddi, gattee hakkillo mon dow Yeesu. Alla liloyi mo gam o laatoo hooreejo Limaamiiɓe dow goonɗinki meeɗen ki ceedotoɗen. ");
INSERT INTO fue_vpl VALUES ("HB3_2","088_3_2","HEB","3","2","2","O laatake koolaaɗo yeeso Alla cuɓuɗo mo, hande no Muusa laatorii koolaaɗo der suudu Alla fu. ");
INSERT INTO fue_vpl VALUES ("HB3_3","088_3_3","HEB","3","3","3","E gooŋa, Yeesu e ɓuri Muusa tedduŋal, hande no mahoowo ɓuriri suudu ŋol o mahi tedduŋal. ");
INSERT INTO fue_vpl VALUES ("HB3_4","088_3_4","HEB","3","4","4","Gam suudu fu e woodi mahuɗo ɗum, amma mahuɗo huune fu woni Alla. ");
INSERT INTO fue_vpl VALUES ("HB3_5","088_3_5","HEB","3","5","5","Muusa laatike koolaaɗo der suudu Alla fu, hande jaggiiɗo, oo seedanoo ko batanoytee. ");
INSERT INTO fue_vpl VALUES ("HB3_6","088_3_6","HEB","3","6","6","Amma Almasiihu laatike koolaaɗo der suudu Alla hande ɓiɗɗo. Enen laatii ɓe suudu makko to en tinnake een koolii, een tabbitini ko jurortoɗen faa heennyitirde. ");
INSERT INTO fue_vpl VALUES ("HB3_7","088_3_7","HEB","3","7","7","Gam majjum, Ruuhu Ceniiɗo wi'i: «Hanne, to on nanii daane Alla, ");
INSERT INTO fue_vpl VALUES ("HB3_8","088_3_8","HEB","3","8","8","to on joorinee ɓerɗe mooɗon hande no kaakiraaɓe mooɗon waɗunoo, no ɓe ummanii Alla, ");
INSERT INTO fue_vpl VALUES ("HB3_9","088_3_9","HEB","3","9","9","ɓe jarbii mo der ladde haro. Alla wi'i, ton ɓe jarbii am, ɓe poonnimmi, baa no ɓe ji'ii golle ɗe gaɗumi jaka duuɓi lasoy ɗiɗi. ");
INSERT INTO fue_vpl VALUES ("HB3_10","088_3_10","HEB","3","10","10","Gam majjum, mone am ummii dow himɓe jaamanuuru nu, bi'umi: “Wakkati fu, ɓerɗe maɓɓe e majji, ɓe annaa laabi am!” ");
INSERT INTO fue_vpl VALUES ("HB3_11","088_3_11","HEB","3","11","11","Gam majjum, mone am ummii, kuniimi, bi'umi: “Ɓe naatataa der siwtaare am pay.”» ");
INSERT INTO fue_vpl VALUES ("HB3_12","088_3_12","HEB","3","12","12","To non, banniraaɓe, kakkilee, gam to goɗɗo mooɗon woodu ɓerne hallune, dulla goonɗingo, woɗɗodoo Alla mo yonki. ");
INSERT INTO fue_vpl VALUES ("HB3_13","088_3_13","HEB","3","13","13","Amma baajontiree nyalaane fu, faa ɗum wi'ee «hanne» gam to hakke majjin goɗɗo mooɗon, yoorina ɓerne mum. ");
INSERT INTO fue_vpl VALUES ("HB3_14","088_3_14","HEB","3","14","14","To en jogake hoolaare men arandeere e semme faa heennyitirde, den en laatike hawtuɓe e Almasiihu. ");
INSERT INTO fue_vpl VALUES ("HB3_15","088_3_15","HEB","3","15","15","Hande no Dewtere wi'i: «Hanne, to on nanii daane Alla, to on joorinee ɓerne mon hande no kaakiraaɓe mooɗon waɗunoo, ɓe ummanii Alla» ");
INSERT INTO fue_vpl VALUES ("HB3_16","088_3_16","HEB","3","16","16","Ɓey nun nani daane Alla, go ɓe ummanii mo? Kamɓe woni wurtiiɓe diga leydi Misira fu, ɓe Muusa ardanii fu! ");
INSERT INTO fue_vpl VALUES ("HB3_17","088_3_17","HEB","3","17","17","Ɓey nun mone Alla ummii dow muuɗum faa duuɓi lasoy ɗiɗi? Kamɓe woni waɗuɓe hakke, go maayi der ladde haro. ");
INSERT INTO fue_vpl VALUES ("HB3_18","088_3_18","HEB","3","18","18","Ɓey nun o hunanii ɓe naatataa der siwtaare makko? Kamɓe woni saliiɓe ɗowtanaago mo. ");
INSERT INTO fue_vpl VALUES ("HB3_19","088_3_19","HEB","3","19","19","En ji'i, ɓe baaway naatugo der siwtaare nen gam ɓe goonɗinay. ");
INSERT INTO fue_vpl VALUES ("HB4_1","088_4_1","HEB","4","1","1","Alla haɓɓanii en alkawal naatugo der siwtaare mum. To non, sey kulen, gam to goɗɗo mooɗon miilu sakitake, dullii naatugo der mayre. ");
INSERT INTO fue_vpl VALUES ("HB4_2","088_4_2","HEB","4","2","2","Gam enen bo, en baajaama linjiila hande kaakiraaɓe men. Amma, ka ɓe nani nafay ɓe, gam no ɓe nani, ɓe goonɗinay. ");
INSERT INTO fue_vpl VALUES ("HB4_3","088_4_3","HEB","4","3","3","Amma enen goonɗinɓe, en naatan der siwtaare ne Alla batani, hande no o wi'i: «Mi hunake e mone bi'umi: “Ɓe naatataa der siwtaare am pay!”» Nani bo Alla heennyi waɗugo golle mum diga o tagi duuniyaaru. ");
INSERT INTO fue_vpl VALUES ("HB4_4","088_4_4","HEB","4","4","4","Bataama kade nokkun der Dewtere, dow nyalaane jeeɗiɗawre, wi'aa: «Alla siwtake waɗugo golle mum fu der nyalaane jeeɗiɗawre.» ");
INSERT INTO fue_vpl VALUES ("HB4_5","088_4_5","HEB","4","5","5","O wi'i kade der nokkuure wonne: «Ɓe naatataa der siwtaare am pay.» ");
INSERT INTO fue_vpl VALUES ("HB4_6","088_4_6","HEB","4","6","6","Artuɓe nani linjiila naatay der siwtaare nen, gam ɓe ɗowtaaki. Amma woɓɓe waawan ko naati kade. ");
INSERT INTO fue_vpl VALUES ("HB4_7","088_4_7","HEB","4","7","7","Gam majjum, Alla resii nyalaane wonne kade, o noddi ne «hanne» o batanii ne ɓaawo duuɓi ɗuuɗɗi, diga e hunnuko Dawda, o wi'i: «Hanne, to on nanii daane Alla, to on joorinee ɓerɗe mooɗon.» ");
INSERT INTO fue_vpl VALUES ("HB4_8","088_4_8","HEB","4","8","8","To Yosuwa hokkiino ɓe siwtaare, Alla batantaano kade siwtaare wonne ɓaawo nii. ");
INSERT INTO fue_vpl VALUES ("HB4_9","088_4_9","HEB","4","9","9","To non, nyalaane siwtaare e horanii kade himɓe Alla. ");
INSERT INTO fue_vpl VALUES ("HB4_10","088_4_10","HEB","4","10","10","Gam naatuɗo der siwtaare Alla, siwtoto e golle mum kanun bo, hande no Alla siwtorii e ɗe mum. ");
INSERT INTO fue_vpl VALUES ("HB4_11","088_4_11","HEB","4","11","11","Gam majjum, en tinnee naaten der siwtaare Alla. To goɗɗo tokku misaalu dullere ɗowtaare himɓe Isira'iila, yana. ");
INSERT INTO fue_vpl VALUES ("HB4_12","088_4_12","HEB","4","12","12","Haala Alla e woodi yonki, eka woodi semme. Kaa ɓuri kaafahi kiye fu, belnaaki becce ɗiɗi welugo. Kaa naata faa der, ka seenna yonki e ruuhu, jokkule e busam. Eka hiitoo maatirɗum, e miilooji ɓerne. ");
INSERT INTO fue_vpl VALUES ("HB4_13","088_4_13","HEB","4","13","13","Walaa fu ko tagaa, ko suuɗanii Alla, huune fu laaɓi e gite makko. Kanko jottinoyten ko gaɗuɗen fu. ");
INSERT INTO fue_vpl VALUES ("HB4_14","088_4_14","HEB","4","14","14","Een goodi hooreejo Limaamiiɓe mawɗo jottiiɗo to Alla dow kammu, kanko woni Yeesu, Ɓiɗɗo Alla. Gam majjum, sey jogoɗen e ɓerɗe goote goonɗinki meeɗen ki ceedotoɗen. ");
INSERT INTO fue_vpl VALUES ("HB4_15","088_4_15","HEB","4","15","15","Een goodii hooreejo Limaamiiɓe baawoowo enɗaago en der tampe meeɗen. Gam kanko e hoore makko o jaribaama der huune fu hande no meeɗen, amma o waɗay hakke. ");
INSERT INTO fue_vpl VALUES ("HB4_16","088_4_16","HEB","4","16","16","Gam majjum, en ɓattee kittaal Laamaare Alla ŋal moƴƴere e hoolaare, gam keɓen enɗam, e moƴƴere, de gooduɗen bukaata ballal fu. ");
INSERT INTO fue_vpl VALUES ("HB5_1","088_5_1","HEB","5","1","1","Hooreejo Limaamiiɓe fu, suɓete nun caka himɓe, o gollanoo Alla gam maɓɓe, o yaara dokke e kiiseteeɗi yeeso Alla gam ikkingo hakkeeji. ");
INSERT INTO fue_vpl VALUES ("HB5_2","088_5_2","HEB","5","2","2","O waawan faamugo ɓe walaa annal e majjuɓe, gam kanko e hoore makko oo laatii tampuɗo der becce fu. ");
INSERT INTO fue_vpl VALUES ("HB5_3","088_5_3","HEB","5","3","3","Gam sabbu tampere nen nun haani o waɗa kiiseteeɗi ikkinooji hakke, hinaa gam jama'aare tan, amma gam hoore makko bo. ");
INSERT INTO fue_vpl VALUES ("HB5_4","088_5_4","HEB","5","4","4","Goɗɗo waawataa ko hokki hoore mum tedduŋal laataago hooreejo Limaamiiɓe. Amma Alla nun noddata joomum hande no o noddiri Haruuna. ");
INSERT INTO fue_vpl VALUES ("HB5_5","088_5_5","HEB","5","5","5","Non bo ɗum laatii e Almasiihu, kanko bane hokki hoore makko tedduŋal laataago hooreejo Limaamiiɓe. Alla nun hokki mo ɗum, de o wi'i: «An laatii Ɓiɗɗo am, hanne min nun laatii Baaba maa.» ");
INSERT INTO fue_vpl VALUES ("HB5_6","088_5_6","HEB","5","6","6","O wi'i nokku kade: «A laatike Limaamiijo faa e baade hande no Malkisadaka.» ");
INSERT INTO fue_vpl VALUES ("HB5_7","088_5_7","HEB","5","7","7","Wakkati Almasiihu wonunoo e duuniyaaru, o eelii Alla, o eelitii, e bojji mawɗi, e gonɗi, gam Alla hisina mo diga maayde. Alla bo toontake mo, gam oo woodi kulol Alla. ");
INSERT INTO fue_vpl VALUES ("HB5_8","088_5_8","HEB","5","8","8","Baa no oo laatii Ɓiɗɗo Alla, tooraaji makko ekkitinii mo ɗowtaago. ");
INSERT INTO fue_vpl VALUES ("HB5_9","088_5_9","HEB","5","9","9","Alla laatinii mo kebbuɗo, gam majjum o laatanii ɗowtaniiɓe mo fu daliila kisidam tabitiiɗam. ");
INSERT INTO fue_vpl VALUES ("HB5_10","088_5_10","HEB","5","10","10","Alla suɓi mo, waɗi mo hooreejo Limaamiiɓe hande no Malkisadaka. ");
INSERT INTO fue_vpl VALUES ("HB5_11","088_5_11","HEB","5","11","11","Dow haala kaa ɗo, emen goodi haalaaji ɗuuɗɗi, e kujje caɗuɗe faamingo, gam on paamataa law. ");
INSERT INTO fue_vpl VALUES ("HB5_12","088_5_12","HEB","5","12","12","E haanunoo oon laatii janŋinooɓe diga ɗum ɓooyi, amma faa jooni oon goodi bukaata janŋineego puɗɗirɗum der haala Alla. Haanuno oon nyaama nyaamdu tekkuŋol, amma faa jooni, kosam nun musinton. ");
INSERT INTO fue_vpl VALUES ("HB5_13","088_5_13","HEB","5","13","13","Musinoowo fu, waawataa suttontirgo haala foonnitaare, gam o laati nun suka. ");
INSERT INTO fue_vpl VALUES ("HB5_14","088_5_14","HEB","5","14","14","Amma, mawɓe, woowinɓe hakkillo mum suttontirgo ko wooɗi e ko halli nun nyaamdu tekkuŋol wonani. ");
INSERT INTO fue_vpl VALUES ("HB6_1","088_6_1","HEB","6","1","1","Gam majjum en accee ekkitaago ekkitinol leesuŋol dow Almasiihu. En jahee yeeso e ko hebbi. To en daɗɗee daɗɗa kesa, hande jon: tuubugo golle jaayɗe, e goonɗingo Alla, ");
INSERT INTO fue_vpl VALUES ("HB6_2","088_6_2","HEB","6","2","2","e ekkitinooje dow batisi, e yowugo himɓe juuɗe, e pintol maayɓe, e kade kiita duumiika. ");
INSERT INTO fue_vpl VALUES ("HB6_3","088_6_3","HEB","6","3","3","En jahee yeeso, kanjum en gaɗan ɗum, to Alla jaɓii. ");
INSERT INTO fue_vpl VALUES ("HB6_4","088_6_4","HEB","6","4","4","Daaree haala himɓe wittuɓe der gonki mum kiikki. Ɓe keɓiino jayŋol Alla. Ɓe mettii dokkal ƴiwuŋal dow, go ɓe keɓi geɗu e Ruuhu Ceniiɗo. ");
INSERT INTO fue_vpl VALUES ("HB6_5","088_6_5","HEB","6","5","5","Ɓe mettii haala Alla geeta, e baawɗe jaamanuuru warooru, ");
INSERT INTO fue_vpl VALUES ("HB6_6","088_6_6","HEB","6","6","6","e non fu, go ɓe bitti ɓaawo. Waɗataako ɓe bittinee ɓe tuuba kade. Gam ɗum laatii hande kamɓe e ko'e maɓɓe, ɓee tigga kade Ɓiɗɗo Alla dow leggal palaaŋal, ɓee jawna mo yeeso himɓe fu. ");
INSERT INTO fue_vpl VALUES ("HB6_7","088_6_7","HEB","6","7","7","To leydi e yara diyam toɓoojam de ɗuuɗɗum, nii fuɗinana aawuɗo awdi geeri, den ni heɓuwa ɗon barke Alla. ");
INSERT INTO fue_vpl VALUES ("HB6_8","088_6_8","HEB","6","8","8","Amma to gi'e, e tuppe nun ni fuɗinta, sey ni woppee, ɓooyataa ko ni yaa'ee, ko sakitoytoo fu, sey ni sunnyee yiite. ");
INSERT INTO fue_vpl VALUES ("HB6_9","088_6_9","HEB","6","9","9","Onon, banniraaɓe am yiɗaaɓe, baa to emen bata hande non, emen anni oon darii dow laawol booɗuŋol, ŋol kisidam. ");
INSERT INTO fue_vpl VALUES ("HB6_10","088_6_10","HEB","6","10","10","Gam Alla laataaki mo fonnitaaki. O yeggitintaa gaɗu mon, e yidde ne kollitinɗon gam inne makko. On kollitii yidde nen e golle ɗe gaɗuɗon, e ɗe gaɗoton faa hanne gam himɓe Alla. ");
INSERT INTO fue_vpl VALUES ("HB6_11","088_6_11","HEB","6","11","11","Amma emen jiɗi moy mooɗon fu hollita iri anniya kaa ɗon faa heennyitirde, gam keɓon ko keɗiɗon. ");
INSERT INTO fue_vpl VALUES ("HB6_12","088_6_12","HEB","6","12","12","To on laatee ciiwaakuuɓe, amma yemminee goonɗinki e munyal himɓe heɓooɓe donŋu ŋu Alla haɓɓi alkawal mum diga e goonɗinki. ");
INSERT INTO fue_vpl VALUES ("HB6_13","088_6_13","HEB","6","13","13","No Alla haɓɓanta Iburahiima alkawal, e hoore makko o hunorii, gam o waawataa ko hunorii ɓuruɗo mo manŋu. ");
INSERT INTO fue_vpl VALUES ("HB6_14","088_6_14","HEB","6","14","14","O wi'i: «E gooŋa, mi barkiɗinte, mi ɗuuɗinan lenyol maa!» ");
INSERT INTO fue_vpl VALUES ("HB6_15","088_6_15","HEB","6","15","15","Hande non Iburahiima munyiri, o heɓi ko Alla haɓɓani mo alkawal. ");
INSERT INTO fue_vpl VALUES ("HB6_16","088_6_16","HEB","6","16","16","To himɓe e hunoo, ɓee kunoro inne ɓurɗo ɓe manŋu. Hunayeere nen nun tabbitinta haala, ikkina jeddi fu. ");
INSERT INTO fue_vpl VALUES ("HB6_17","088_6_17","HEB","6","17","17","Non bo, no Alla yiɗi hollugo ronooɓe alkawal mum e ɓuruɗum laaɓugo, no ka o resi waylitintaako pay, o waɗii ɗum e hunayeere. ");
INSERT INTO fue_vpl VALUES ("HB6_18","088_6_18","HEB","6","18","18","To non, kujje ɗiɗi woni waylitintaako, ɗe Alla waawataa ko fewi dow mum, kanje woni: hunayeere e alkawal. Kanjum semmiɗinta ɓerɗe men, enen accoyɓe huune fu, go kooliɗen ko bi'aɗen. ");
INSERT INTO fue_vpl VALUES ("HB6_19","088_6_19","HEB","6","19","19","Hoolaare nen e laatanii en hande tiggere laana diyam, tiggaane ne dimmataako gam yonkiiji men. Ne yahii faa ɓaawo wudere wirnirde nokkuure ɓurune fu senaago. ");
INSERT INTO fue_vpl VALUES ("HB6_20","088_6_20","HEB","6","20","20","Ɗon nun Yeesu arti naatani en, o laatanii en hooreejo Limaamiiɓe faa e baadey, hande no Malkisadaka. ");
INSERT INTO fue_vpl VALUES ("HB7_1","088_7_1","HEB","7","1","1","Malkisadaka on laati nun laamiiɗo siire wi'eteene Salaam. Oo laatii bo Limaamiijo Alla towuɗo. Wakkati Iburahiima wartata diga konu ŋu o jaalii laamiiɓe, den Malkisadaka fotti e makko, barkiɗini mo. ");
INSERT INTO fue_vpl VALUES ("HB7_2","088_7_2","HEB","7","2","2","Kanko nun Iburahiima hokki jakka huune fu. Ko inne Malkisadaka fillitii woni: «Laamiiɗo foonnitaare», kade bo, oo laatii laamiiɗo Salaam, waato «laamiiɗo jam.» ");
INSERT INTO fue_vpl VALUES ("HB7_3","088_7_3","HEB","7","3","3","O woodaa Baaba, ɗum bo inna, o woodaa bo kaakiraaɓe. O woodaa fuɗɗoode, o woodaa timmoode. O nandinaama e Ɓiɗɗo Alla, oo laatii Limaamiijo faa e baadey. ");
INSERT INTO fue_vpl VALUES ("HB7_4","088_7_4","HEB","7","4","4","Daaree no tedduŋal Malkisadaka foti mawnugo, faa Iburahiima maama meeɗen hokki mo jakka ko heɓi diga konu. ");
INSERT INTO fue_vpl VALUES ("HB7_5","088_7_5","HEB","7","5","5","Limaamiiɓe ƴiwɓe e lenyol Leewi, kamɓe nun tawreeta hokki laawol jaɓugo jakka to Isira'iilaaɓe, banniraaɓe maɓɓe, baa no kamɓe bo ɓe ƴiwii e Iburahiima hande maɓɓe. ");
INSERT INTO fue_vpl VALUES ("HB7_6","088_7_6","HEB","7","6","6","Amma Malkisadaka mo jeyaaka der lenyol Leewi, jaɓii jakka to Iburahiima, o barkiɗini keɓuɗo alkawalji Alla. ");
INSERT INTO fue_vpl VALUES ("HB7_7","088_7_7","HEB","7","7","7","Nani bo, jeddi walaa, barkiɗinɗo e ɓuri barkiɗinaaɗo manŋu. ");
INSERT INTO fue_vpl VALUES ("HB7_8","088_7_8","HEB","7","8","8","Dow wecco arano, Limaamiiɓe jaɓooɓe jakka laati nun himɓe maayooɓe. Amma dow wecco ɗiɗaɓo, Malkisadaka ceedanaaɗo e wuuri nun jaɓi ka. ");
INSERT INTO fue_vpl VALUES ("HB7_9","088_7_9","HEB","7","9","9","En baawan ko wi'i Leewi jaɓoowo jakka, hokkii ka diga e Iburahiima. ");
INSERT INTO fue_vpl VALUES ("HB7_10","088_7_10","HEB","7","10","10","Gam Leewi rimaakano taw, go Malkisadaka fotti e maamiiko Iburahiima. ");
INSERT INTO fue_vpl VALUES ("HB7_11","088_7_11","HEB","7","11","11","Der tawreeta ka Isira'iilaaɓe hokkaa, ɓe lenyol Leewi nun haani suɓee laatoo Limaamiiɓe. To golle limaamaaku Leewinkeeɓe e hebbuno, Limaamiijo goɗɗo hande Malkisadaka bukaakano wara, laato mo lenyol Haruuna bane. ");
INSERT INTO fue_vpl VALUES ("HB7_12","088_7_12","HEB","7","12","12","To golle limaamaaku waylitake, doole sariya bo waylitoo. ");
INSERT INTO fue_vpl VALUES ("HB7_13","088_7_13","HEB","7","13","13","Mo haala kan wondanaa laati nun mo lenyol feerewol, mo himɓe lenyol mum gollaakino daɗey to hirsirde. ");
INSERT INTO fue_vpl VALUES ("HB7_14","088_7_14","HEB","7","14","14","Himɓe fu e anni no Joomiraawo meeɗen ƴiwii diga e lenyol Yahuuda. Lenyol ŋol, Muusa batanay ŋol gokka dow limaamaaku. ");
INSERT INTO fue_vpl VALUES ("HB7_15","088_7_15","HEB","7","15","15","Warugo Limaamiijo goɗɗo, nanduɗo e Malkisadaka, ɓeydii laaɓingo haala kan. ");
INSERT INTO fue_vpl VALUES ("HB7_16","088_7_16","HEB","7","16","16","O laataaki Limaamiijo hande no himɓe suɓirtee e sariyaaji mum. Amma, o laatike Limaamiijo e baawɗe yonki ki heennyataa. ");
INSERT INTO fue_vpl VALUES ("HB7_17","088_7_17","HEB","7","17","17","Gam Dewtere wi'i: «A laatike Limaamiijo faa e baadey hande no Malkisadaka.» ");
INSERT INTO fue_vpl VALUES ("HB7_18","088_7_18","HEB","7","18","18","To non, sariya artuka woppaama, gam ka tampii, ka nafay. ");
INSERT INTO fue_vpl VALUES ("HB7_19","088_7_19","HEB","7","19","19","Gam tawreeta Muusa waɗay goɗɗum kebbuɗum. Amma jooni, en keɓii tammuwe ɓurune wooɗugo, ne ɓattortoɗen Alla. ");
INSERT INTO fue_vpl VALUES ("HB7_20","088_7_20","HEB","7","20","20","Ɗum ɗon fu, e hunayeere nun laatorii. Amma ɓee to, laataaki Limaamiiɓe e hunayeere. ");
INSERT INTO fue_vpl VALUES ("HB7_21","088_7_21","HEB","7","21","21","Amma Yeesu kan laatike ɗum dow hunayeere Alla, bi'uɗo: «Min Joomiraawo mi hunike, mi wittataa ɓaawo: “A laatike Limaamiijo faa e baadey.”» ");
INSERT INTO fue_vpl VALUES ("HB7_22","088_7_22","HEB","7","22","22","Hande non Yeesu laatorii torma alkawal ɓuruŋal wooɗugo. ");
INSERT INTO fue_vpl VALUES ("HB7_23","088_7_23","HEB","7","23","23","Gokka nani kade. Limaamiiɓe ɗuuɓɓe nun wonuno, gam maayde e haɗannoo ɓe tabitaago. ");
INSERT INTO fue_vpl VALUES ("HB7_24","088_7_24","HEB","7","24","24","Amma no Yeesu e laatii duumiiɗo, limaamaaku makko goɗɗo wattirtaa ɗum. ");
INSERT INTO fue_vpl VALUES ("HB7_25","088_7_25","HEB","7","25","25","Gam majjum, o waawan hisingo no haaniri ɓattiiɓe Alla diga e makko, gam oo wuuri e baadey, oo eelana ɓe Alla. ");
INSERT INTO fue_vpl VALUES ("HB7_26","088_7_26","HEB","7","26","26","Hooreejo Limaamiiɓe hande oo ɗon nun haanani en. Oo laatii ceniiɗo, mo walaa gacce, ko soɓi fu walaa e makko. Oo seenniri e hakkeeɓe, o ɓantaama faa dow to ɓuri kammu towugo. ");
INSERT INTO fue_vpl VALUES ("HB7_27","088_7_27","HEB","7","27","27","O nandaa e hooreeɓe Limaamiiɓe. O bukaaka waɗugo kiiseteeɗi nyalaane fu, aran, gam makko, ɓaawo mum gam hakke himɓe. Kanko, o sakkii hoore makko de woore tan, ɗum heƴi faa e baadey. ");
INSERT INTO fue_vpl VALUES ("HB7_28","088_7_28","HEB","7","28","28","Tawreeta Muusa suɓiino hooreeɓe Limaamiiɓe laatiiɓe himɓe tampuɓe. Amma hunayeere Alla warune ɓaawo tawreeta, jooɗinii Ɓiɗɗo laatiiɗo kebbuɗo faa abada. ");
INSERT INTO fue_vpl VALUES ("HB8_1","088_8_1","HEB","8","1","1","Hoore haala ka men batanta nani: Een goodi hooreejo Limaamiiɓe mawɗo hande oo ɗo. Oo jooɗii nyaamo leeso Laamaare Alla mawɗo, mo tedduŋal, dow kammu. ");
INSERT INTO fue_vpl VALUES ("HB8_2","088_8_2","HEB","8","2","2","Kanko nun gollotoo der nokkuure ceniine, der bukaaru gooŋaaru nu Joomiraawo darini, hinaa neɗɗo. ");
INSERT INTO fue_vpl VALUES ("HB8_3","088_8_3","HEB","8","3","3","Hooreejo Limaamiiɓe fu suɓa nun gam hokka Alla dokke e kiiseteeɗi. E haani bo, oo woodi ko o sakkata. ");
INSERT INTO fue_vpl VALUES ("HB8_4","088_8_4","HEB","8","4","4","To e duuniyaaru ɗo nun o wonuno, o laatataakono du Limaamiijo, gam Limaamiiɓe waɗooɓe sadaka hande no tawreeta Muusa batiri na'on. ");
INSERT INTO fue_vpl VALUES ("HB8_5","088_8_5","HEB","8","5","5","Golle limaamaaku ɗe ɓe gaɗata e laatii misaalu, e nandi huune ko woni e gooŋa dow kammu. No Muusa yiɗunoo darnugo bukaaru, Alla bati mo wi'i: «Tinna, gaɗaa huune fu, hande misaalu mo kollaɗaa dow waanne.» ");
INSERT INTO fue_vpl VALUES ("HB8_6","088_8_6","HEB","8","6","6","Jooni, Almasiihu heɓii golle ɓuruɗe wooɗugo, gam o laatike hakkunneejo alkawal ɓuruŋal wooɗugo, dariiŋal dow alkawalji ɓuruɗi wooɗugo. ");
INSERT INTO fue_vpl VALUES ("HB8_7","088_8_7","HEB","8","7","7","Gam e gooŋa, to alkawal aranal woodaano gacce, bukaata dartugo ɗiɗaɓal walaano. ");
INSERT INTO fue_vpl VALUES ("HB8_8","088_8_8","HEB","8","8","8","Amma Alla felii himɓe muuɗum wi'i: «Min Joomiraawo mii wi'a on, nyalaaɗe waraan, mi haɓɓan alkawal kesal e himɓe Isira'iila, e ɓe Yahuuda.» ");
INSERT INTO fue_vpl VALUES ("HB8_9","088_8_9","HEB","8","9","9","Ŋal nandataa e alkawal ŋal kaɓɓunoomi e kaakiraaɓe maɓɓe, nyaanne ettumi ɓe e junŋo, burtinmi diga leydi Misira. No ɓe jogaaki alkawal am min bo, kokkumi ɓe ɓaawo. ");
INSERT INTO fue_vpl VALUES ("HB8_10","088_8_10","HEB","8","10","10","O wi'i kade: Daa no alkawal ŋal kaɓɓanmi e himɓe Isira'iila laatoytoo ɓaawo nii: Mi wattan sariyaaji am der hakkillo maɓɓe, mi winnan ɗi der ɓerɗe maɓɓe, mi laatoto Alla maɓɓe, ɓe laatoo himɓe am. ");
INSERT INTO fue_vpl VALUES ("HB8_11","088_8_11","HEB","8","11","11","Goɗɗo janŋintaa gondaaɗo mum, naa bo banniraawo mum, wi'a, Annu Joomiraawo, gam himɓe fu annan am, diga pettel faa mawɗo maɓɓe. ");
INSERT INTO fue_vpl VALUES ("HB8_12","088_8_12","HEB","8","12","12","Gam mi yaafoto boofi maɓɓe, mi siwtortaa kade hakke maɓɓe.» ");
INSERT INTO fue_vpl VALUES ("HB8_13","088_8_13","HEB","8","13","13","No Alla noddii alkawal ŋal ɗo kesal, den fu, o laatinii aranal kiinŋal. Ko hiiɗɗi, e ko nayyi bo, faanike majjitingo. ");
INSERT INTO fue_vpl VALUES ("HB9_1","088_9_1","HEB","9","1","1","Alkawal aranal e wooduno sariyaaji dow sujidango Alla e nokkuure ceniine, nyiɓaane der duuniyaaru. ");
INSERT INTO fue_vpl VALUES ("HB9_2","088_9_2","HEB","9","2","2","Bukaaru tiggaama, enu woodi gaɗaaji ɗiɗi. Gaɗa arana e wi'ee gaɗa ceniika, ɗon nun fitilleel resetee, e taaburu, e peen cakkanaako Alla. ");
INSERT INTO fue_vpl VALUES ("HB9_3","088_9_3","HEB","9","3","3","Ɓawɓawre wudere ɗiɗawre wiirniraane, ɗon nun gaɗa ɗiɗaɓa bi'eteeka, gaɗa ɓuruka senaago fu woni. ");
INSERT INTO fue_vpl VALUES ("HB9_4","088_9_4","HEB","9","4","4","Der makka, e woodi urirde wardi gaɗiraane kanŋeeri, e keesuwal alkawal gaɗiraaŋal kanŋeeri. Der keesuwal ŋal, looŋel gaɗiraaŋel kanŋeeri na'on ɗon. Maannu e woni der looŋel ŋel, e sawru Haruuna bilitinŋol, e kaaƴe alluwaaje ɗiɗi to dookaaji winnaa. ");
INSERT INTO fue_vpl VALUES ("HB9_5","088_9_5","HEB","9","5","5","Dowdowre keesuwal ŋal, e woodi foto malaykaaɓe wi'eteeɓe kerubaaɓe, tedduɓe. Biyeeɗe maɓɓe e suddi ommoode yaaforde hakkeeji. Jooni en baawataa ko batani ɗum gootel gootel. ");
INSERT INTO fue_vpl VALUES ("HB9_6","088_9_6","HEB","9","6","6","Non non nun huune ɗum fu resiraa. Den, nyalaane fu, Limaamiiɓe naata gaɗa bukaaru arana, ɓe gaɗa golle sujidango Alla. ");
INSERT INTO fue_vpl VALUES ("HB9_7","088_9_7","HEB","9","7","7","Amma gaɗa ɗiɗaɓa, hooreejo Limaamiiɓe tan nun naatata ɗon de woore der duuɓol. O naatataa bo, to o jogaaki ƴiiƴam o waɗirta sadaka gam yaafuye hakke makko e ɗe himɓe waɗi hinaa e sago. ");
INSERT INTO fue_vpl VALUES ("HB9_8","088_9_8","HEB","9","8","8","Diga e majjum Ruuhu Ceniiɗo e hollita no laawol gaɗa ɓuruka senaago fu maɓɓitaaki taw, to wecco bukaaru aranu e woni. ");
INSERT INTO fue_vpl VALUES ("HB9_9","088_9_9","HEB","9","9","9","Huune ɗum e hollita ko woni jooni. Ko ɗum yiɗi wi'ugo woni: dokke e sadakaaji cakketeeɗi waawataa laaɓingo ɓerne gaɗoowo ɗum. ");
INSERT INTO fue_vpl VALUES ("HB9_10","088_9_10","HEB","9","10","10","Sariyaaji ɗii ɗon laati nun ɗi ɓannu. Ɗii batana haala nyaamdu, e jaram, e lootuki feere feere. Sariyaaji ɗii nafii faa wakkati de Alla wayliti ɗi. ");
INSERT INTO fue_vpl VALUES ("HB9_11","088_9_11","HEB","9","11","11","Amma, Almasiihu warii, laatii hooreejo Limaamiiɓe dow kujje geete, garooje yeeso. O naatii der bukaaru ɓurunu mawnugo, e ɓurunu hebbugo, nu junŋo neɗɗo waɗay, nu jeyaaka bo e duuniyaaru ɗo. ");
INSERT INTO fue_vpl VALUES ("HB9_12","088_9_12","HEB","9","12","12","O naatii de woore der nokkuure ɓurne senaago fu, ɗum heƴi faa e baadey. O naatiday e ƴiiƴam ginniiji, e ɗam nyalbi, amma e ƴiiƴam hoore makko. Non non o sooditorii en faa e baadey. ");
INSERT INTO fue_vpl VALUES ("HB9_13","088_9_13","HEB","9","13","13","To ƴiiƴam ginniiji e ga'i, e dooni wiige miccaama dow coɓuɗo, eɗam laaɓina mo dow laawol diina. ");
INSERT INTO fue_vpl VALUES ("HB9_14","088_9_14","HEB","9","14","14","To non, noy ƴiiƴam Almasiihu ɓurirtaa laaɓingo cuuɗiiɗum ɓerɗe meeɗen diga e golle mum baatuɗe? Gam e baawɗe Ruuhu tabitiiɗo o hokkiri hoore makko Alla, o laatii sadaka kaa ɗo woodaa tuuni, heɓa gollanoɗen Alla mo yonki. ");
INSERT INTO fue_vpl VALUES ("HB9_15","088_9_15","HEB","9","15","15","Kan acci Almasiihu laatii beldinoowo, kaɓɓuɗo alkawal kesal, gam noddaaɓe heɓa donŋu duumiiŋu ŋu Alla haɓɓani ɓe alkawal. Ɗum waɗoto, gam o maayii, heɓa o sooditoo himɓe waɗunooɓe hakke der alkawal aranal. ");
INSERT INTO fue_vpl VALUES ("HB9_16","088_9_16","HEB","9","16","16","To ɗerewol donŋu e batanee, sey laatoo doneteeɗo maayii. ");
INSERT INTO fue_vpl VALUES ("HB9_17","088_9_17","HEB","9","17","17","Ɗerewol donŋu nafataa, to doneteeɗo e wuuri, sey doneteeɗo maaya go ŋol nafa. ");
INSERT INTO fue_vpl VALUES ("HB9_18","088_9_18","HEB","9","18","18","Kan acci go alkawal aranal haɓɓee, sey no ƴiiƴam reƴƴitii. ");
INSERT INTO fue_vpl VALUES ("HB9_19","088_9_19","HEB","9","19","19","Ɓaawo Muusa janŋani himɓe sariyaaji gonuɗi der tawreeta fu, o etti ƴiiƴam nyalbi, e ɗam ginniiji, o hawrontiri e diyam. Den o etti leeɓi boɗeeji, e haako isop, o micci dow dewtere, e dow himɓe fu, o wi'i: ");
INSERT INTO fue_vpl VALUES ("HB9_20","088_9_20","HEB","9","20","20","«Kanjum woni ƴiiƴam tabbitinoojam alkawal ŋal Alla haɓɓi wi'i, ɗowtanoɗon.» ");
INSERT INTO fue_vpl VALUES ("HB9_21","088_9_21","HEB","9","21","21","Hande non bo o micci ƴiiƴam dow bukaaru, e dow ko ɓe cujidiranta Alla fu. ");
INSERT INTO fue_vpl VALUES ("HB9_22","088_9_22","HEB","9","22","22","Hande no tawreeta resiri, ƴiiƴam nun laaɓinta huune ɗuuɗɗum! To ƴiiƴam reƴƴitaaka bo, yaafuye hakkeeji walaa. ");
INSERT INTO fue_vpl VALUES ("HB9_23","088_9_23","HEB","9","23","23","E haani kujje kollitooje ko woni dow kammu laaɓiniree hande non. E haani bo ɗe laaɓiniree e sadakaaaji ɓuruɗi wooɗugo. ");
INSERT INTO fue_vpl VALUES ("HB9_24","088_9_24","HEB","9","24","24","Gam Almasiihu naatay der nokkuure ceniine ne junŋo neɗɗo nyiɓi, nandune e gooŋaare. Amma o naatii dow kammu e hoore makko, gam o daroo jooni yeeso Alla gam men. ");
INSERT INTO fue_vpl VALUES ("HB9_25","088_9_25","HEB","9","25","25","O naatay ton gam o sakka hoore makko de ɗuuɗɗum, hande no hooreejo Limaamiiɓe naatirta duuɓol fu der nokkuure ɓurune senaago e ƴiiƴam mareefu. ");
INSERT INTO fue_vpl VALUES ("HB9_26","088_9_26","HEB","9","26","26","To hinaa non, Almasiihu toorotono de ɗuuɗɗum diga fuɗɗoode duuniyaaru. Amma jooni, o hollitake de woore tan, der heennyitirde jaamanuuji, gam o ikkina hakkeeji diga e hokkugo yonki makko. ");
INSERT INTO fue_vpl VALUES ("HB9_27","088_9_27","HEB","9","27","27","Neɗɗo fu maayan de woore hande no ɗum resirani ɗum, ɓaawo mum Alla hiitoo mo. ");
INSERT INTO fue_vpl VALUES ("HB9_28","088_9_28","HEB","9","28","28","Hande non bo, Almasiihu sakkii hoore mum de woore tan gam o ikkina hakkeeji himɓe ɗuuɓɓe. O suppitoyto de ɗiɗawre, hinaa gam hakke, amma gam o hisina hettiniiɓe mo. ");
INSERT INTO fue_vpl VALUES ("HB10_1","088_10_1","HEB","10","1","1","Tawreeta, hollitan nun tan ɗoogi huune geetum, garoojum, ka hollitintaa huune ɗum e hoore mum. Kan acci ka waawataa ko laatini ɓattotooɓe Alla hebbuɓe e laawol waɗugo sadakaaji gooti ɗin baadey fu, e der duuɓol fu. ");
INSERT INTO fue_vpl VALUES ("HB10_2","088_10_2","HEB","10","2","2","To tawreeta waawino laaɓingo ɓe, maa ɓe acciino waɗugo sadakaaji, ɓerɗe maɓɓe bo gaccataako ɓe, gam ɓe laaɓinaama de woore, go ɗum heƴi faa e baadey. ");
INSERT INTO fue_vpl VALUES ("HB10_3","088_10_3","HEB","10","3","3","Amma kiiseteeɗi ɗin e siwtora himɓe hakkeeji mum duuɓol fu. ");
INSERT INTO fue_vpl VALUES ("HB10_4","088_10_4","HEB","10","4","4","Gam waɗataako ƴiiƴam ga'i, e ginniiji ikkina hakkeeji. ");
INSERT INTO fue_vpl VALUES ("HB10_5","088_10_5","HEB","10","5","5","Gam majjum, no Almasiihu warata der duuniyaaru, o bati Alla o wi'i: «A yiɗaa sadakaaji kiiseteeɗi e dokke, amma a siriyanake am ɓannu. ");
INSERT INTO fue_vpl VALUES ("HB10_6","088_10_6","HEB","10","6","6","A seyortaako sadakaaji buuɗeteeɗi e sadakaaji ikkinooji hakke. ");
INSERT INTO fue_vpl VALUES ("HB10_7","088_10_7","HEB","10","7","7","Den bi'umi: “Mi nani, mii wara waɗugo ko jiɗuɗaa, an Alla, non non ɗum winnaa dow am der dewtere taggeteene.”» ");
INSERT INTO fue_vpl VALUES ("HB10_8","088_10_8","HEB","10","8","8","Aran, o wi'i: «A yiɗaa sadakaaji kiiseteeɗi e dokke, e sadakaaji buuɗeteeɗi, e sadakaaji ikkinooji hakke. Nani bo, huune ɗum fu, sakkete nun hande no tawreeta batiri. ");
INSERT INTO fue_vpl VALUES ("HB10_9","088_10_9","HEB","10","9","9","Ɓaawo mum, o wi'i: «Mi nani, mii wara gam mi waɗa ko jiɗuɗaa.» Non Alla mooytiri sadakaaji arandeeji, go o jooɗini ɗiɗaɓa. ");
INSERT INTO fue_vpl VALUES ("HB10_10","088_10_10","HEB","10","10","10","En laaɓinaama e hakke, gam Yeesu Almasiihu waɗii ko Alla yiɗi. O sakkii ɓannu makko de woore, ɗum heƴii faa e baadey. ");
INSERT INTO fue_vpl VALUES ("HB10_11","088_10_11","HEB","10","11","11","Limaamiijo fu e yaha gollirde mum nyalaane fu. Oo sakka sadakaaji gooti ɗin de ɗuuɗɗum, amma ɗi baawataa ko mooyti hakkeeji pay. ");
INSERT INTO fue_vpl VALUES ("HB10_12","088_10_12","HEB","10","12","12","Amma oo ɗo kan, waɗii sadaka goota tan gam mooytugo hakkeeji, ɓaawo mum o jooɗii ley nyaamo Alla faa e baadey. ");
INSERT INTO fue_vpl VALUES ("HB10_13","088_10_13","HEB","10","13","13","Ton o heɗii Alla waɗa wanyuɓe mo laatoo jaaɓirɗum koyɗe makko. ");
INSERT INTO fue_vpl VALUES ("HB10_14","088_10_14","HEB","10","14","14","Gam e sadaka goota kan o laatiniri ɓe o laaɓini hebbuɓe, faa e baadey. ");
INSERT INTO fue_vpl VALUES ("HB10_15","088_10_15","HEB","10","15","15","Kanjum bo Ruuhu Ceniiɗo seedanii en, wi'i: ");
INSERT INTO fue_vpl VALUES ("HB10_16","088_10_16","HEB","10","16","16","«Joomiraawo wi'i: Alkawal ŋal kaɓɓanmi e maɓɓe nani, ɓaawo nyalaaɗe ɗee, mi wattan sariyaaji am der ɓerɗe maɓɓe, mi winnan ɗi der hakkillo maɓɓe.» ");
INSERT INTO fue_vpl VALUES ("HB10_17","088_10_17","HEB","10","17","17","O wi'i kade: «Mi siwtortaa hakkeeji maɓɓe kade, e boofi maɓɓe.» ");
INSERT INTO fue_vpl VALUES ("HB10_18","088_10_18","HEB","10","18","18","Nani bo to hakkeeji yaafaama, doole bane sadaka ikkinoojum hakke waɗee. ");
INSERT INTO fue_vpl VALUES ("HB10_19","088_10_19","HEB","10","19","19","Onon banniraaɓe, ƴiiƴam Yeesu hokkii en laawol naatugo der nokkuure ɓurne senaago. ");
INSERT INTO fue_vpl VALUES ("HB10_20","088_10_20","HEB","10","20","20","O maɓɓitanii en laawol kesol, ŋol yonki, gaɗa wudere wirnirde, waato ɓannu makko. ");
INSERT INTO fue_vpl VALUES ("HB10_21","088_10_21","HEB","10","21","21","Een goodi hooreejo Limaamiiɓe ardinaaɗo der suudu Alla. ");
INSERT INTO fue_vpl VALUES ("HB10_22","088_10_22","HEB","10","22","22","Gam majjum, en ɓattee Alla e ɓerɗe goote, e goonɗinki kebbuki, laatoo ɓerɗe meeɗen laaɓinaama e ko gaccotoo en, ɓalli men lootiraama e diyam ceniiɗam. ");
INSERT INTO fue_vpl VALUES ("HB10_23","088_10_23","HEB","10","23","23","En ceedee ko kooliɗen, to en tampee, gam kaɓɓanɗo en alkawal e laatii koolaaɗo. ");
INSERT INTO fue_vpl VALUES ("HB10_24","088_10_24","HEB","10","24","24","En ballontiree gam kolliten yidde hakkune men, gaɗen bo golle booɗuɗe. ");
INSERT INTO fue_vpl VALUES ("HB10_25","088_10_25","HEB","10","25","25","To en accee hawtugo e goonɗinɓe hande no woɓɓe waɗata. Amma baajontiree, hakko du no oon ji'a nyalaane Joomiraawo e faanoo. ");
INSERT INTO fue_vpl VALUES ("HB10_26","088_10_26","HEB","10","26","26","Gam to en gaɗii hakke e sago men, ɓaawo de annitinɗen gooŋa, sadaka gom kade walaa ikkinoowa hakkeeji. ");
INSERT INTO fue_vpl VALUES ("HB10_27","088_10_27","HEB","10","27","27","Ko horii tan woni, keɗoɗen e kulol kiita Alla, e yiite kalkoowe yedduɓe Alla. ");
INSERT INTO fue_vpl VALUES ("HB10_28","088_10_28","HEB","10","28","28","To neɗɗo taƴii tawreeta Muusa, sey o waree, o yurmataake, to himɓe ɗiɗo naa bo tato seedake ɗum! ");
INSERT INTO fue_vpl VALUES ("HB10_29","088_10_29","HEB","10","29","29","To goɗɗo yawike Ɓiɗɗo Alla, go o daarii ƴiiƴam alkawal ɗam Alla laaɓiniri mo huune baanji, go o yenni Ruuhu kokkoowo en moƴƴere, e gooŋa, joomum heɓan kiita ɓuruka hallugo. ");
INSERT INTO fue_vpl VALUES ("HB10_30","088_10_30","HEB","10","30","30","Gam een anni Alla bi'uɗo: «Min nun wattotoo, min nun yoɓata.» O wi'i kade: «Joomiraawo hiitoto himɓe mum.» ");
INSERT INTO fue_vpl VALUES ("HB10_31","088_10_31","HEB","10","31","31","Yanugo e junŋo Alla yonkinteejo e hunnii puy! ");
INSERT INTO fue_vpl VALUES ("HB10_32","088_10_32","HEB","10","32","32","Ciwtoree nyalaaɗe arandeeje, ɓaawo de Alla yaynani on, on jarii bone mawɗe, amma on darike e semme, kaɓuɗon. ");
INSERT INTO fue_vpl VALUES ("HB10_33","088_10_33","HEB","10","33","33","Wakkati mum, on jennaama yeeso himɓe, tooraɗon, kawtuɗon e tooreteeɓe hande mooɗon. ");
INSERT INTO fue_vpl VALUES ("HB10_34","088_10_34","HEB","10","34","34","On jurmake maɓɓaaɓe der kasu, nootiɗon e seyo ko gooduɗon teetaa, gam oon anni oon goodi kujje ɓuruɗe wooɗugo, tabitintooɗe. ");
INSERT INTO fue_vpl VALUES ("HB10_35","088_10_35","HEB","10","35","35","Gam majjum, to on boppee hoolaare mooɗon, gam ne waddanan on riiba mawka. ");
INSERT INTO fue_vpl VALUES ("HB10_36","088_10_36","HEB","10","36","36","E gooŋa, oon goodi bukaata munyal, gam keɓon ko Alla haɓɓani on alkawal, to on gaɗii ko o yiɗi. ");
INSERT INTO fue_vpl VALUES ("HB10_37","088_10_37","HEB","10","37","37","E winnii der Dewtere: «Ɗo e yeeso seɗɗa, seɗɗa tan horii kaanuɗo wara, waran, o ɓooyataa. ");
INSERT INTO fue_vpl VALUES ("HB10_38","088_10_38","HEB","10","38","38","Neɗɗo am poonnitiiɗo wuuran e goonɗinki, amma to o wittii ɓaawo, ɓerne am seyortaako mo.» ");
INSERT INTO fue_vpl VALUES ("HB10_39","088_10_39","HEB","10","39","39","Enen, en galaa caka wittooɓe ɓaawo gam halka. Amma caka goonɗinɓe, gam yonkiiji men hisa. ");
INSERT INTO fue_vpl VALUES ("HB11_1","088_11_1","HEB","11","1","1","Goonɗinki laati nun hoolaago a heɓii huune ko keɗiɗaa e wara, e tabbitingo kujje ɗe a yi'ay. ");
INSERT INTO fue_vpl VALUES ("HB11_2","088_11_2","HEB","11","2","2","Sabbu goonɗinki nun himɓe arandeeɓe heɓiri seedaneego geeta yeeso Alla. ");
INSERT INTO fue_vpl VALUES ("HB11_3","088_11_3","HEB","11","3","3","Diga e goonɗinki nun paamirɗen no duuniyaaru e kammu tagiraama e haala Alla. Ko yi'etee bo tagaama diga ko yi'ataake. ");
INSERT INTO fue_vpl VALUES ("HB11_4","088_11_4","HEB","11","4","4","Diga e goonɗinki nun Habiila hokki Alla sadaka ɓuruka ka Kayiinu go Alla daari mo poonnitiiɗo. Alla bo jaɓii sadaka makko. Baa no Habiila maayi, goonɗinki makko e waajoo en faa hanne. ");
INSERT INTO fue_vpl VALUES ("HB11_5","088_11_5","HEB","11","5","5","Diga e goonɗinki nun Anuhu eenciniraa dow kammu, o maayay. O yiitaaka, gam Alla eencinii mo dow. Ko o eencinee, dewte seedanike mo wi'i, oo fottani Alla. ");
INSERT INTO fue_vpl VALUES ("HB11_6","088_11_6","HEB","11","6","6","Nani bo to hinaa e goonɗinki, walaa baawoowo ko fottani Alla. Ɓattotooɗo Alla fu, sey goonɗina no Alla na'on, o warjoto dartanɓe mo. ");
INSERT INTO fue_vpl VALUES ("HB11_7","088_11_7","HEB","11","7","7","Diga e goonɗinki nun Alla maatiniri Nuuhu dow huune ko yottaaki taw. O huli Alla, den o waɗi laana diyam, o daɗiniri getti makko. O doƴƴii duuniyaaru kiita, o roni fonnitaare heɓeteene diga e goonɗinki. ");
INSERT INTO fue_vpl VALUES ("HB11_8","088_11_8","HEB","11","8","8","Diga e goonɗinki nun Iburahiima ɗowtoranii noddoore Alla, o yahi leydi ni Alla wi'i o ronan, o yawti, o annaa toy o yahata. ");
INSERT INTO fue_vpl VALUES ("HB11_9","088_11_9","HEB","11","9","9","Diga e goonɗinki o yahiri der leydi ni Alla haɓɓani mo alkawal, o jooɗi der bukaaji hande janano, nun nun bo Isiyaaku e Yaakuubu ronidooɓe alkawal ŋal e makko waɗi. ");
INSERT INTO fue_vpl VALUES ("HB11_10","088_11_10","HEB","11","10","10","Iburahiima e heɗinoo yi'a wanŋarde ne daɗɗa semmenteha, ne Alla diidi, mahi. ");
INSERT INTO fue_vpl VALUES ("HB11_11","088_11_11","HEB","11","11","11","Diga e goonɗinki nun Saratu heɓiri baawɗe rimugo suka, baa no o naywii puy, gam o faamii, kaɓɓanɗo mo alkawal e laatii koolaaɗo. ");
INSERT INTO fue_vpl VALUES ("HB11_12","088_11_12","HEB","11","12","12","Gam majjum diga neɗɗo gooto naywuɗo, himɓe ɗuuɓɓe rimaa. Ɓe ɗuuɗi hande koode tawaaɗe dow kammu, e jaaneeri gonuni onde maayo, ni limataako. ");
INSERT INTO fue_vpl VALUES ("HB11_13","088_11_13","HEB","11","13","13","Der goonɗinki ɓe fu, ɓe maayi. Ɓe keɓay ko Alla haɓɓani ɓe alkawal. Amma ɓe ji'ii ɗum, ɓe ceyorii ɗum diga woɗɗi. Den ɓe bati no kamɓe ɓe laati nun hoɓɓe e jananɓe der duuniyaaru. ");
INSERT INTO fue_vpl VALUES ("HB11_14","088_11_14","HEB","11","14","14","Batooɓe hande nii e holla e laaɓuɗum, no e darta leydi halal mum. ");
INSERT INTO fue_vpl VALUES ("HB11_15","088_11_15","HEB","11","15","15","To hakkillo maɓɓe wittiino der leydi ni ɓe burtinoo e mum, ɓe baawanno ko witti ton. ");
INSERT INTO fue_vpl VALUES ("HB11_16","088_11_16","HEB","11","16","16","Amma leydi ɓuruni wooɗugo ɓe jiɗi, leydi gonuni dow kammu. Gam majjum senteene waɗay Alla o noddee Alla maɓɓe, gam oo siriyanii ɓe wanŋarde. ");
INSERT INTO fue_vpl VALUES ("HB11_17","088_11_17","HEB","11","17","17","Diga e goonɗinki nun Iburahiima sakkiri Isiyaaku no Alla foonni mo. Ɓiyiiko bajjo, mo Alla waɗani alkawalji ɗuuɗɗi nun o siriyino sakkugo. ");
INSERT INTO fue_vpl VALUES ("HB11_18","088_11_18","HEB","11","18","18","Dow makko nun Alla batuno, wi'i: «E Isiyaaku nun lenyol noddirteeŋol inne maa wurtotoo.» ");
INSERT INTO fue_vpl VALUES ("HB11_19","088_11_19","HEB","11","19","19","Iburahiima faamii no Alla e woodi baawɗe fintingo maayɗo. Gam majjum Alla hokkiti mo ɓiyiiko hande pintinaaɗo diga maayde. Eɗum holla misaalu pintol diga maayɓe. ");
INSERT INTO fue_vpl VALUES ("HB11_20","088_11_20","HEB","11","20","20","Diga e goonɗinki nun Isiyaaku barkiɗiniri Yaakuubu e Isuwa gam kujje garooje. ");
INSERT INTO fue_vpl VALUES ("HB11_21","088_11_21","HEB","11","21","21","Diga e goonɗinki kin nun Yaakuubu barkiɗiniri ɓiɓɓe Yusufu goggooto, no o faanii maayugo. O tuggi sawru makko o jimminii, o teddini Alla. ");
INSERT INTO fue_vpl VALUES ("HB11_22","088_11_22","HEB","11","22","22","Diga e goonɗinki nun acci no Yusufu faanii maayugo, o bati ɓiɓɓe Isira'iila haala wurtaago maɓɓe diga leydi Misira. O bati ɓe bo ko ɓe gaɗata e ƴiye makko. ");
INSERT INTO fue_vpl VALUES ("HB11_23","088_11_23","HEB","11","23","23","Diga e goonɗinki nun saareeji Muusa suuɗiri ɗum lebbi tati ɓaawo no o rimaa, gam ɓe ji'ii sukeel ŋel e wooɗi, ɓe kulay bo ka laamiiɗo bati. ");
INSERT INTO fue_vpl VALUES ("HB11_24","088_11_24","HEB","11","24","24","Diga e goonɗinki nun acci no Muusa mawni, o salii noddeego suka ɓii Fiirawna debbo. ");
INSERT INTO fue_vpl VALUES ("HB11_25","088_11_25","HEB","11","25","25","O suɓii hawtugo e himɓe Alla der tooraaji maɓɓe, e no o seyortoo der hakke wakkati seɗɗa. ");
INSERT INTO fue_vpl VALUES ("HB11_26","088_11_26","HEB","11","26","26","O faamii yarugo bone gam Almasiihu e laatii jawdi ɓuruni jawdi Misira fu manŋu, gam oo daarii riiba gonuka yeeso. ");
INSERT INTO fue_vpl VALUES ("HB11_27","088_11_27","HEB","11","27","27","Diga e goonɗinki o wurtori leydi Misira, o hulay mone laamiiɗo. O darii e semme, hande oo yi'a Alla mo yi'ataake. ");
INSERT INTO fue_vpl VALUES ("HB11_28","088_11_28","HEB","11","28","28","Diga e goonɗinki, o waɗiri juulɗe Paska, o wi'i, ƴiiƴam miccee e dammuɗe gam to malaykaajo maayde meema afuɓe Isira'iila. ");
INSERT INTO fue_vpl VALUES ("HB11_29","088_11_29","HEB","11","29","29","Diga e goonɗinki nun, Isira'iilaaɓe joliri maayo Maliya hande dow leydi joorni. Amma ŋo moɗii Misirankeeɓe, no ɓe dartata jolugo. ");
INSERT INTO fue_vpl VALUES ("HB11_30","088_11_30","HEB","11","30","30","Diga e goonɗinki nun birniwol piiltitiiŋol Yeriko yani, no Isira'iilaaɓe fiiltitii ŋol balɗe jeeɗiɗi. ");
INSERT INTO fue_vpl VALUES ("HB11_31","088_11_31","HEB","11","31","31","Sabbu goonɗinki nun, Rahab, debbo jeenoowo, daɗiri halkidingo e heeferɓe, gam o jaɓɓake Isira'iilaaɓe daarooɓe no leydi resorii e jam. ");
INSERT INTO fue_vpl VALUES ("HB11_32","088_11_32","HEB","11","32","32","Kaye batanmi kade? Wakkati heƴataa am gam mi batana habaru Gedeyon, e Barak, e Samson, e Yefta, e Dawda, e Samuyila, e kade annabiiɓe woɓɓe. ");
INSERT INTO fue_vpl VALUES ("HB11_33","088_11_33","HEB","11","33","33","Himɓe ɓee fu, goonɗinki nun acci ɓe jaalii laamiiɓe, ɓe gaɗi ko foonnitii, ɓe keɓi alkawal Alla. Goonɗinki kin acci ɓe muɓɓi kunnuɗe jagge, ");
INSERT INTO fue_vpl VALUES ("HB11_34","088_11_34","HEB","11","34","34","ɓe nyifi baawɗe yiite, ɓe daɗi diga e kaafaaje belɗe. Ɓe keɓitii semme ɓaawo ɓe nyawi, ɓe laatii waawuɓe konu, ɓe jaalii soogeeji janani. ");
INSERT INTO fue_vpl VALUES ("HB11_35","088_11_35","HEB","11","35","35","Diga e goonɗinki nun rewɓe woɓɓe heɓiri maayɓe mum fintinaa. Gam goonɗinki nun, woɓɓe tooraa, salii faabeego, gam ɓe keɓa pintol ɓuruŋol wooɗugo. ");
INSERT INTO fue_vpl VALUES ("HB11_36","088_11_36","HEB","11","36","36","Woɓɓe jaancaa, fiyaa ɓocci, ko ɓuri du, woɓɓe mum haɓɓaa e callalluuji, wattaa der kasu. ");
INSERT INTO fue_vpl VALUES ("HB11_37","088_11_37","HEB","11","37","37","Woɓɓe bo faɗɗaa kaaƴe faa maayi, woɓɓe jarbaa, woɓɓe, ɓalli mum wudditaa geɓe ɗiɗi, woɓɓe wariraa e kaafaaje. Ɓee jiiloo toy fu, ɓee ɓornii guri baali, e be'i, ko ɓe goodi fu teetaa, ɓe tooraa, ɓe ɓillaa puy. ");
INSERT INTO fue_vpl VALUES ("HB11_38","088_11_38","HEB","11","38","38","Kamɓe, duuniyaaru fotay ɓe gonoo e mum, ɓee jiiloo der ladde haro, e dow baalle, e luuro kaaƴe, e der gayɗe. ");
INSERT INTO fue_vpl VALUES ("HB11_39","088_11_39","HEB","11","39","39","Ɓe fu ɓe keɓii seedaneego geeta yeeso Alla, gam goonɗinki maɓɓe. Amma ɓe keɓay ko Alla haɓɓani ɓe alkawal, ");
INSERT INTO fue_vpl VALUES ("HB11_40","088_11_40","HEB","11","40","40","gam Alla e yiɗi hokkugo en ko ɓuri wooɗugo, heɓa to ɓe jottoo to kebbuɗum woni hinaa e men. ");
INSERT INTO fue_vpl VALUES ("HB12_1","088_12_1","HEB","12","1","1","Seedeeɓe ɗuuɓɓe e fiiltitii en hande duule. Gam majjum enen bo, en boppee doongal fu, e hakke taariiɗe en e koyɗum. Den doggen e tinnaare der doggudu daɗontiree ŋol desanaɗen. ");
INSERT INTO fue_vpl VALUES ("HB12_2","088_12_2","HEB","12","2","2","En tiggee gite meeɗen dow Yeesu, laatiiɗo puɗɗuɗo goonɗinki meeɗen, kanko nun bo hebbinta ki. O hakkilanay senteene maayde dow leggal palaaŋal, gam seyo ŋo o resanaa. Jooni oo jooɗii nyaamo kittaal Laamaare Alla. ");
INSERT INTO fue_vpl VALUES ("HB12_3","088_12_3","HEB","12","3","3","Miilanee Yeesu munyuɗo, e tooraaji ɗi hakkeeɓe toori mo, gam to on tampee, ɓerɗe mooɗon biisoo. ");
INSERT INTO fue_vpl VALUES ("HB12_4","088_12_4","HEB","12","4","4","On kaɓiday taw e hakke faa yottii maayde. ");
INSERT INTO fue_vpl VALUES ("HB12_5","088_12_5","HEB","12","5","5","On jeggitii bo waaji ɗi Alla waajii on hande sukaaɓe muuɗum, o wi'i: «Ɓiyam, taa fijir elto Joomiraawo, Taa accu ɓerne maa biisoo to o wooltanii maa. ");
INSERT INTO fue_vpl VALUES ("HB12_6","088_12_6","HEB","12","6","6","Gam Joomiraawo e elta mo o yiɗi fu, oo fiya ɓe o daari sukaaɓe makko.» ");
INSERT INTO fue_vpl VALUES ("HB12_7","088_12_7","HEB","12","7","7","Munyanee elto, annitee no Alla e daari on hande sukaaɓe muuɗum. Suka moy woni mo Baaba mum eltataa ɗum? ");
INSERT INTO fue_vpl VALUES ("HB12_8","088_12_8","HEB","12","8","8","To Alla eltay on hande no o eltirta sukaaɓe makko fu, den, on laataaki woni sukaaɓe makko, amma jaaluuɓe laatiɗon. ");
INSERT INTO fue_vpl VALUES ("HB12_9","088_12_9","HEB","12","9","9","Ciwtoren no baabiraaɓe meeɗen ɓe duuniyaaru ɗo e elta en, een ɗowtanii ɓe bo. Ume haɗata en ɗowtanaago Baaba men mo dow kammu, gam buuren? ");
INSERT INTO fue_vpl VALUES ("HB12_10","088_12_10","HEB","12","10","10","Baabiraaɓe meeɗen e elta en der wakkati seɗɗa, no fottirani ɓe fu. Amma, Alla e elta en gam ɗum nafa en, gam o hawta en der senaare makko. ");
INSERT INTO fue_vpl VALUES ("HB12_11","088_12_11","HEB","12","11","11","Aran, elto fu waddataa seyo, sey biisere ɓerne. Amma ɓaawo mum, nee waddana jaɓuɓe ne fu foonnitaare e jam. ");
INSERT INTO fue_vpl VALUES ("HB12_12","088_12_12","HEB","12","12","12","Gam majjum, portee juuɗe mooɗon comuɗe, cemmiɗinee koppi mooɗon tampuɗi. ");
INSERT INTO fue_vpl VALUES ("HB12_13","088_12_13","HEB","12","13","13","Tokkee laabi poortiiɗi, gam to koyŋal laƴoowal sela laawol, amma ŋal nyawtoo. ");
INSERT INTO fue_vpl VALUES ("HB12_14","088_12_14","HEB","12","14","14","Dartee jam hakkune mooɗon e himɓe fu, dartee senaare bo, gam to hinaa e mayre, walaa ji'oowo Joomiraawo. ");
INSERT INTO fue_vpl VALUES ("HB12_15","088_12_15","HEB","12","15","15","Kakkilee gam to goɗɗo ɗawu hoore mum moƴƴere Alla, to o laatoo hande ɗaɗol kaaɗuŋol bilitoowol e raaɓoo ɗuuɓɓe kaaɗuɗum mum, e laawa ɓe. ");
INSERT INTO fue_vpl VALUES ("HB12_16","088_12_16","HEB","12","16","16","Kakkilee gam to goɗɗo mooɗon laatoo jeenoowo, ɗum bo jawiiɗo kujje ceniiɗe hande no Isuwa sippiri afaaku mum gam nyaama de woore tan. ");
INSERT INTO fue_vpl VALUES ("HB12_17","088_12_17","HEB","12","17","17","Oon anni ɓaawo nii, o yiɗii baabiiko barkiɗina mo, amma o salaama. O dartii e bojji, dabare no baabiiko waylitira miilo mum, amma o waaway. ");
INSERT INTO fue_vpl VALUES ("HB12_18","088_12_18","HEB","12","18","18","Onon, on garay to waanne meemeteene, kuɓɓoore yiite. On garay bo to duule niɓɓuɗe, to niwre e to hennu semmentewol woni. ");
INSERT INTO fue_vpl VALUES ("HB12_19","088_12_19","HEB","12","19","19","On garay bo to walaldu fuuretee, e to daane towne falmata. Nanuɓe daane nen fu, eelii to ne baddu ɗum kade baa woliine woore. ");
INSERT INTO fue_vpl VALUES ("HB12_20","088_12_20","HEB","12","20","20","Gam ɓe baaway ko munyani haala bi'uka: «Baa to bisa nun ɓattii waanne nen, ŋa faɗɗee kaaƴe ŋa waree.» ");
INSERT INTO fue_vpl VALUES ("HB12_21","088_12_21","HEB","12","21","21","Ko himɓe yi'i ɗon e hunnii, faa Muusa e hoore mum wi'i: «Mi hulii sanne faa mii diwna.» ");
INSERT INTO fue_vpl VALUES ("HB12_22","088_12_22","HEB","12","22","22","Amma onon, on garii to waanne Siyoona, e wanŋarde Alla yonkinteejo, waato Urusaliima ni dow kammu, to malaykaaɓe uju ujuneeje hawriti e welwelta. ");
INSERT INTO fue_vpl VALUES ("HB12_23","088_12_23","HEB","12","23","23","On garii to hawriine afuɓe, ɓe inɗe mum winnaa dow kammu. On garii to Alla kiitotooɗo himɓe fu, e to yonkiiji foonnitiiɓe hebbinaaɓe. ");
INSERT INTO fue_vpl VALUES ("HB12_24","088_12_24","HEB","12","24","24","On garii to Yeesu beldinɗo himɓe e Alla der alkawal kesal, e to ƴiiƴam mum miccaaɗam, ɓuruɗam ɗam Habiila. ");
INSERT INTO fue_vpl VALUES ("HB12_25","088_12_25","HEB","12","25","25","Kakkilee, to on calee hettinanaago baddoowo on, gam saliiɓe nanango seedinɓe ɗum der duuniyaaru ɗo daɗay kiita. Noy enen miiluɗen daɗiren to en kokkii baddanɗo en diga dow kammu ɓaawo? ");
INSERT INTO fue_vpl VALUES ("HB12_26","088_12_26","HEB","12","26","26","Wakkati gom Alla dimmiino leydi. Jooni bo, o haɓɓanii en alkawal, o wi'i: «Mi dimman de woore kade, hinaa leydi tan, amma kammu bo.» ");
INSERT INTO fue_vpl VALUES ("HB12_27","088_12_27","HEB","12","27","27","No o wi'i «de woore kade» eɗum holla no tagaaɗum fu dimmoto faa ko dimmataako horoo. ");
INSERT INTO fue_vpl VALUES ("HB12_28","088_12_28","HEB","12","28","28","Gam majjum, no en keɓan laamu ŋu dimmataako, en jettee Alla, cujidanen mo no fottiri der kulol e tedduŋal. ");
INSERT INTO fue_vpl VALUES ("HB12_29","088_12_29","HEB","12","29","29","Gam Alla meeɗen laati nun yiite kalkoowe. ");
INSERT INTO fue_vpl VALUES ("HB13_1","088_13_1","HEB","13","1","1","Tinnee jiɗontiree hakkune mon, gam on laati nun banniraaɓe. ");
INSERT INTO fue_vpl VALUES ("HB13_2","088_13_2","HEB","13","2","2","To on jeggitee weernugo hoɓɓe, gam woɓɓe weernii malaykaaɓe, ɓe annaa naa malaykaaɓe nun ɓe beerni. ");
INSERT INTO fue_vpl VALUES ("HB13_3","088_13_3","HEB","13","3","3","Ciwtoree maɓɓaaɓe der kasu, hande onon e maɓɓe nun maɓɓidaa. Ciwtoree bo tooreteeɓe, hande onon e maɓɓe nun tooridintee. ");
INSERT INTO fue_vpl VALUES ("HB13_4","088_13_4","HEB","13","4","4","Moy mooɗon fu teddina teegal, gorko laatoo koolaaɗo dow debbo mum, debbo bo laatoo koolaaɗo dow gorko mum. Gam Alla hiitoto waɗooɓe nyidduɗum, e jeenooɓe. ");
INSERT INTO fue_vpl VALUES ("HB13_5","088_13_5","HEB","13","5","5","To on accee yidde ceede arditanoo goonki mooɗon. Ceyoree ko gooduɗon, gam Alla e hoore mum wi'i: «Mi accataa maa, mi woppataa maa pay!» ");
INSERT INTO fue_vpl VALUES ("HB13_6","088_13_6","HEB","13","6","6","Gam majjum, en baawan batugo e hoolaare bi'en: «Joomiraawo woni paabotooɗo am, mi hulataa. Ume neɗɗo waawata ko waɗanimmi?» ");
INSERT INTO fue_vpl VALUES ("HB13_7","088_13_7","HEB","13","7","7","Ciwtoree ardiiɓe, baajiiɓe on haala Alla. Daaree no gonki maɓɓe heennyitiri, den, yemminon goonɗinki maɓɓe. ");
INSERT INTO fue_vpl VALUES ("HB13_8","088_13_8","HEB","13","8","8","Yeesu Almasiihu gooto on nun, diga keenya, hanne, e faa abada. ");
INSERT INTO fue_vpl VALUES ("HB13_9","088_13_9","HEB","13","9","9","To on accee ekkitinooje janane iri ɗey fu fooɗa on. Ko haani woni, moƴƴere Alla semmiɗa der ɓerɗe mooɗon, hinaa sariyaaji dow nyaamduuji. Tokkuɓe sariyaaji ɗii ɗon, ɗi nafay ɗum goɗɗum. ");
INSERT INTO fue_vpl VALUES ("HB13_10","088_13_10","HEB","13","10","10","Een goodi hiisirde, amma Limaamiiɓe gollotooɓe der bukaaru ceniinu woodaa laawol nyaamugo sadaka jowiika dow mayre. ");
INSERT INTO fue_vpl VALUES ("HB13_11","088_13_11","HEB","13","11","11","Hooreejo Limaamiiɓe e wadda ƴiiƴam bisaaji cakkaaɗi gam moytugo hakkeeji der nokkuure ceniine, amma, ɓalli majji e wuuɗee yaasi. ");
INSERT INTO fue_vpl VALUES ("HB13_12","088_13_12","HEB","13","12","12","Gam majjum nun bo, Yeesu maayoy yaasi wanŋarde, gam o laaɓina himɓe e ƴiiƴam makko. ");
INSERT INTO fue_vpl VALUES ("HB13_13","088_13_13","HEB","13","13","13","To non, en burtee taween mo yaasi wanŋarde, jaɓen senteene ne o sentinaa! ");
INSERT INTO fue_vpl VALUES ("HB13_14","088_13_14","HEB","13","14","14","Gam der duuniyaaru ɗo, en goodaa wanŋarde tabitintoone, amma een darta garoore yeeso. ");
INSERT INTO fue_vpl VALUES ("HB13_15","088_13_15","HEB","13","15","15","En cakkee wakkati fu Alla jettooje meeɗen diga e Yeesu, waato ceedoɗen inne makko wakkati fu. ");
INSERT INTO fue_vpl VALUES ("HB13_16","088_13_16","HEB","13","16","16","Amma to on jeggitee waɗugo ko wooɗi. Ballontiree, gam iri kiiseteeɗi ɗii ɗon nun Alla yiɗi. ");
INSERT INTO fue_vpl VALUES ("HB13_17","088_13_17","HEB","13","17","17","Ɗowtanee ardiiɓe on, leesinee ko'e mon yeeso maɓɓe. Gam kamɓe nun reeni yonkiiji mooɗon, ɓe jottinan bo Alla golle maɓɓe. Kokkee ɓe laawol ɓe gaɗa golle maɓɓe e seyo, hinaa e dumbitaaɗe, gam ɗum nafataa on. ");
INSERT INTO fue_vpl VALUES ("HB13_18","088_13_18","HEB","13","18","18","Du'anee men, gam emen kooli, ɓerɗe amen e laaɓi, men tokkoto bo waɗugo ko wooɗi der becce fu. ");
INSERT INTO fue_vpl VALUES ("HB13_19","088_13_19","HEB","13","19","19","Mii eela on puy, gaɗon ɗum, heɓa Alla maɓɓitanammi laawol mi warta to mooɗon law. ");
INSERT INTO fue_vpl VALUES ("HB13_20","088_13_20","HEB","13","20","20","Alla kokkoowo jam fintinii Joomiraawo meeɗen Yeesu diga maayɓe. Yeesu on laatike duroowo baali mawɗo, o haɓɓii alkawal tabitiiŋal diga e ƴiiƴam makko. ");
INSERT INTO fue_vpl VALUES ("HB13_21","088_13_21","HEB","13","21","21","Alla on hokka on baawɗe waɗugo booɗɗum feere feere fu, heɓa kebbinon ko o yiɗi. O waɗa der men ko fottani mo, diga e Yeesu Almasiihu mo tedduŋal laatanii faa e baade! Aami! ");
INSERT INTO fue_vpl VALUES ("HB13_22","088_13_22","HEB","13","22","22","Banniraaɓe, mii eela on jaɓee waaji ɗii e munyal, gam seɗɗa tan nun binnanmi on. ");
INSERT INTO fue_vpl VALUES ("HB13_23","088_13_23","HEB","13","23","23","Mii maatina on no banniraawo meeɗen Timote yoofitaama. To o yottake law, mi waridan e makko yi'ugo on. ");
INSERT INTO fue_vpl VALUES ("HB13_24","088_13_24","HEB","13","24","24","Cannee hooreeɓe mooɗon, e himɓe Alla fu. Banniraaɓe tawaaɓe leydi Itali sannii on. ");
INSERT INTO fue_vpl VALUES ("HB13_25","088_13_25","HEB","13","25","25","Moƴƴere Alla wonoo e mooɗon, on fu! ");
INSERT INTO fue_vpl VALUES ("P11_1","090_1_1","1PE","1","1","1","Min Piyer lilaaɗo Yeesu Almasiihu winnani on, onon ɓe Alla suɓi laatiiɓe hoɓɓe e sankitii der leyɗe ɗee ɗo: Pontus e Galaatiya e Kapadosiya e Asiya e Bitiniya. ");
INSERT INTO fue_vpl VALUES ("P11_2","090_1_2","1PE","1","2","2","Alla Baaba suɓii on hande no o resirnoo, o seni on e Ruuhu makko, gam ɗowtanoɗon Yeesu Almasiihu, mo ƴiiƴam mum laaɓini on. Alla ɗuuɗinana on moƴƴere e jam! ");
INSERT INTO fue_vpl VALUES ("P11_3","090_1_3","1PE","1","3","3","En jettee Alla, Baaba Joomiraawo men Yeesu Almasiihu, dimitoriiɗo en e enɗam mum mawɗam. E pintol Yeesu Almasiihu diga maayɓe, o hokkiri en tammuwe gooŋaare. ");
INSERT INTO fue_vpl VALUES ("P11_4","090_1_4","1PE","1","4","4","Een goodi tammuwe heɓugo donŋu ŋu nyolataa, ŋu biisataako, ŋu ɗaylataa bo. Kanŋu Alla resani on dow kammu. ");
INSERT INTO fue_vpl VALUES ("P11_5","090_1_5","1PE","1","5","5","O reenirii on e baawɗe makko gam on goonɗinii mo. O reenii on gam o hokka on kisidam ciriyiiɗam hollitaago der wakkati cakitiiki. ");
INSERT INTO fue_vpl VALUES ("P11_6","090_1_6","1PE","1","6","6","Oon ceyorii ɗum, baa no jooni doole tooraaji feere feere e tampina on der wakkati seɗɗa. ");
INSERT INTO fue_vpl VALUES ("P11_7","090_1_7","1PE","1","7","7","Tooraaji ɗin nun foonnata goonɗinki mon. Hande no kanŋeeri ni tabitintaako lootirtee der yiite, hande non goonɗinki mon ɓuruki kanŋeeri saman faa to woɗɗi, foonnirtee, ki heɓan maanteego, e tedduŋal, e manŋu, nyaanne Yeesu Almasiihu suppitoytoo. ");
INSERT INTO fue_vpl VALUES ("P11_8","090_1_8","1PE","1","8","8","Yeesu on, baa no on ji'ay mo, oon jiɗi mo, baa no on ji'ataa mo jooni, e nun oon goonɗini mo. Ɗum hebbinii ɓerɗe mooɗon seyo ŋo tedduŋal, ɓuruŋo bataneego. ");
INSERT INTO fue_vpl VALUES ("P11_9","090_1_9","1PE","1","9","9","On keɓan riiba goonɗinki mon, kan woni kisidam yonkiiji mon. ");
INSERT INTO fue_vpl VALUES ("P11_10","090_1_10","1PE","1","10","10","Annabiiɓe waɗii annabaaku dow moƴƴere ne desanaɗon, ɓe dartii, ɓe biɗitii gam faamugo haala kisidam ɗam. ");
INSERT INTO fue_vpl VALUES ("P11_11","090_1_11","1PE","1","11","11","Ruuhu Almasiihu gonɗo der maɓɓe, hollii ɓe ɗum diga wakkati majjum waray, o sappake ɓe tooraaji Almasiihu, e tedduŋal ɗi ŋal waddata. Annabiiɓe ɓen dartii faamugo dey ɗum waɗata, e no ɗum waɗirta. ");
INSERT INTO fue_vpl VALUES ("P11_12","090_1_12","1PE","1","12","12","Alla hollii ɓe no habaruuji ɗi ɓe baajotoo, ko'e maɓɓe bane ɓe baajantoo, amma onon ɓe baajantoo. Jooni, waajotooɓe linjiila ɓen yottinii on habaru diga e baawɗe Ruuhu Ceniiɗo, ƴiwuɗo dow kammu. Malaykaaɓe e hoore mum bo dartii faamugo ɗum no wooɗi. ");
INSERT INTO fue_vpl VALUES ("P11_13","090_1_13","1PE","1","13","13","Gam majjum accee hakkillo mon e fini, jogee ko'e mon, jowee tammuwe mooɗon fu dow moƴƴere ne Alla hokkata on nyaanne Yeesu Almasiihu suppitoytoo. ");
INSERT INTO fue_vpl VALUES ("P11_14","090_1_14","1PE","1","14","14","Laatee hande sukaaɓe ɗowtiiɓe, to on tokkee suunooji mon ɗi gonnoɗon der muuɗum wakkati on annaano Almasiihu. ");
INSERT INTO fue_vpl VALUES ("P11_15","090_1_15","1PE","1","15","15","Amma laatee seniiɓe der yaadu mon fu, hande no Alla nodduɗo on oo Ceniiɗo, ");
INSERT INTO fue_vpl VALUES ("P11_16","090_1_16","1PE","1","16","16","gam Alla wi'i der dewtere: «Laatee seniiɓe gam min mii Ceniiɗo.» ");
INSERT INTO fue_vpl VALUES ("P11_17","090_1_17","1PE","1","17","17","Der du'aaje mon, oon nodda Alla «Baaba» mon, kanko woni kiitotooɗo moy fu deydey gaɗu muuɗum, o suttontirtaa himɓe, gam majjum nyaamee goonki mooɗon der duuniyaaru ɗo e kulol Alla. ");
INSERT INTO fue_vpl VALUES ("P11_18","090_1_18","1PE","1","18","18","Oon anni on cooditaama diga e goonki baanjahi ki donunoɗon diga e kaakiraaɓe mooɗon. On cooditiraaka e huune ko heennyata, hande cardi maa bo kanŋeeri. ");
INSERT INTO fue_vpl VALUES ("P11_19","090_1_19","1PE","1","19","19","On cooditiraama e ƴiiƴam Almasiihu tedduɗam, Almasiihu nanduɗo e jawgiiri ni walaa elande, ni walaa tuuni. ");
INSERT INTO fue_vpl VALUES ("P11_20","090_1_20","1PE","1","20","20","Alla suɓii mo diga duuniyaaru tagaaka, amma o hollitii mo der jaamanuuji cakitiiɗi gam mooɗon. ");
INSERT INTO fue_vpl VALUES ("P11_21","090_1_21","1PE","1","21","21","Diga e makko goonɗinɗon Alla, pintinɗo mo diga e maayde, hokki mo tedduŋal, gam goonɗinki mon e tammuwe mon fu daroo dow Alla. ");
INSERT INTO fue_vpl VALUES ("P11_22","090_1_22","1PE","1","22","22","Jooni no ɗowtaniɗon gooŋa, on cenii ko'e mooɗon, on jiɗii banniraaɓe e yidde ne walaa munaafitaare. Gam majjum, jiɗontiree e yidde gooŋaare, e ɓerɗe mon fu. ");
INSERT INTO fue_vpl VALUES ("P11_23","090_1_23","1PE","1","23","23","On dimitaaɓe de ɗiɗawre, hinaa e awdi nyoloori, amma e awdi ni nyolataa, e haala Alla yonkinteha, tabitiika. ");
INSERT INTO fue_vpl VALUES ("P11_24","090_1_24","1PE","1","24","24","E winnaa: «Ɓii-Aadama e nandi hande fuɗo, Tedduŋal maɓɓe nandi hande pinni fuɗo, to fuɗo yoori pinni mum saaman, ");
INSERT INTO fue_vpl VALUES ("P11_25","090_1_25","1PE","1","25","25","amma haala Joomiraawo tabitinto faa abada.» Kanka woni linjiila ka baajaɗon ");
INSERT INTO fue_vpl VALUES ("P12_1","090_2_1","1PE","2","1","1","Gam majjum boppee ko boni fu, hande jamma, fewre, munaafitaare, nawniraagu, e nyoore, ");
INSERT INTO fue_vpl VALUES ("P12_2","090_2_2","1PE","2","2","2","hande no sukahon keccon yiɗiri kosam ɗam jillontiraaka, nun haani onon bo jiɗiron haala Alla, gam mawnon der makka, kison. ");
INSERT INTO fue_vpl VALUES ("P12_3","090_2_3","1PE","2","3","3","Hande no Binni Ceniini wi'i: «On mettii no Joomiraawo weliri». ");
INSERT INTO fue_vpl VALUES ("P12_4","090_2_4","1PE","2","4","4","Ɓattee Joomiraawo, laatiiɗo hayre yonkinteere, ne himɓe woppi, goodune saman, ne Alla suɓi. ");
INSERT INTO fue_vpl VALUES ("P12_5","090_2_5","1PE","2","5","5","Onon bo, on laati nun hande kaaƴe ɗe yonki, garee mahireɗon suudu ruuhunkewol, gam laatoɗon waalde limaamiiɓe seniiɓe, yaaranooɓe Alla sadakaaji ruuhunkeeji ɗi o jaɓata diga e Yeesu Almasiihu. ");
INSERT INTO fue_vpl VALUES ("P12_6","090_2_6","1PE","2","6","6","Gam e winnaa der dewtere: «Mi yowan dow Siyoona hayre gooraare, suɓaane, ne saman. Goonɗinɗo ne fu sentintaake.» ");
INSERT INTO fue_vpl VALUES ("P12_7","090_2_7","1PE","2","7","7","Onon goonɗinɓe, hayre nee e woodi tedduŋal dow mooɗon, amma dow ɓee ɗo goonɗinay, Dewtere wi'i dow maɓɓe: «Hayre ne mahooɓe woppi Kayre laatii ɓurune fottugo der gooraare suudu, ");
INSERT INTO fue_vpl VALUES ("P12_8","090_2_8","1PE","2","8","8","Kayre ferginta himɓe, kayre bo doƴƴata ɓe» Saliiɓe goonɗingo haala kan, fergoto dow mayre, kanjum Alla resani ɓe. ");
INSERT INTO fue_vpl VALUES ("P12_9","090_2_9","1PE","2","9","9","Amma onon, on laati nun lenyol cuɓaaŋol, on limaamiiɓe gollantooɓe Laamiiɗo, on himɓe lenyol ceniiŋol, on himɓe ɓe o suɓani hoore makko, gam baajoɗon haala golle makko geete. Kanko woni nodduɗo on, wurtini on der niwre, yaari on der jaygol mum kayniiŋol. ");
INSERT INTO fue_vpl VALUES ("P12_10","090_2_10","1PE","2","10","10","Aran, on laataakino himɓe Alla, amma jooni on laatake himɓe makko, on keɓayno enɗam makko, amma jooni on keɓii ɗam. ");
INSERT INTO fue_vpl VALUES ("P12_11","090_2_11","1PE","2","11","11","Banniraaɓe am yiɗaaɓe, on laati nun hoɓɓe e jananɓe. Gam majjum mii eela on, boɗɗodee jiɗaali ɓannu dartooji halka yonkiiji mooɗon. ");
INSERT INTO fue_vpl VALUES ("P12_12","090_2_12","1PE","2","12","12","Accee joonne mooɗon e wooɗi yeeso himɓe ɓe goonɗinay, gam baa to ɓe gaccake on, e wi'ugo on, on halluɓe, ɓe ji'a golle mooɗon booɗuɗe, ɓe teddina Alla nyaanne o hollitanii ɓe. ");
INSERT INTO fue_vpl VALUES ("P12_13","090_2_13","1PE","2","13","13","Gam sabbu Joomiraawo, ɗowtanee mawɓe fu, ɗowtanee laamiiɗo leydi bo, gam kanko ɓuri ɓe. ");
INSERT INTO fue_vpl VALUES ("P12_14","090_2_14","1PE","2","14","14","Ɗowtanee mawɓe genni bo, gam kamɓe laatii lilaaɓe makko, gam ɓe pooɗa noppi waɗooɓe ko halli, ɓe jetta waɗooɓe ko wooɗi. ");
INSERT INTO fue_vpl VALUES ("P12_15","090_2_15","1PE","2","15","15","Gam ko Alla yiɗi woni, gaɗon ko wooɗi, muɓɓiron kunnuɗe himɓe batooɓe ko ɓe annaa. ");
INSERT INTO fue_vpl VALUES ("P12_16","090_2_16","1PE","2","16","16","Laatee rinɗinaaɓe, to on coomee ko halli der dimaaku mooɗon, gonee hande maccuɓe Alla. ");
INSERT INTO fue_vpl VALUES ("P12_17","090_2_17","1PE","2","17","17","Teddinee himɓe fu, jiɗee banniraaɓe goonɗinɓe, kulee Alla, teddinee laamiiɗo. ");
INSERT INTO fue_vpl VALUES ("P12_18","090_2_18","1PE","2","18","18","Onon jaggiiɓe, ɗowtanee joomiraaɓe mooɗon, hinaa yeeɗɗuɓe e ɗigguɓe tan, amma e saɗuɓe fu. ");
INSERT INTO fue_vpl VALUES ("P12_19","090_2_19","1PE","2","19","19","To on munyanii tooraaji ɗi kaandaa heɓugo on, gam daliila Alla, on gaɗii ko wooɗi. ");
INSERT INTO fue_vpl VALUES ("P12_20","090_2_20","1PE","2","20","20","To on munyanii piiɗe ɗe piyeteɗon gam on gaɗii ko wooɗaa, toy tedduŋal mon woni? Amma to on munyanii tooraaji ɗi keɓoton gam sabbu gaɗu mon geetu, eɗum fottani Alla, ");
INSERT INTO fue_vpl VALUES ("P12_21","090_2_21","1PE","2","21","21","gam kanjum Alla noddani on, Almasiihu e hoore mum toorake, gam mooɗon bo o toorii. O hollii on laawol gam tokkon koyɗe makko. ");
INSERT INTO fue_vpl VALUES ("P12_22","090_2_22","1PE","2","22","22","Daɗey o waɗay hakke, goɗɗo meeɗay ko nani fewre der hunnuko makko. ");
INSERT INTO fue_vpl VALUES ("P12_23","090_2_23","1PE","2","23","23","No ɓe jennata mo, o yennitaaki ɓe, de ɓe kollata mo bone, o wattaaki ɓe. Amma o yowanii hoore makko Alla, kiitotooɗo e gooŋaaku ");
INSERT INTO fue_vpl VALUES ("P12_24","090_2_24","1PE","2","24","24","Almasiihu roonake hakkeeji meeɗen dow ɓannu mum dow leggal palaaŋal, gam laatoɗen maayuɓe wecco hakke, amma laatoɗen foofooɓe der ko foonniti. On joofake sabbu looci ɗi o fiyaa. ");
INSERT INTO fue_vpl VALUES ("P12_25","090_2_25","1PE","2","25","25","Gam on laatino nun hande baali majjuɗi, amma jooni on bittoy to duroowo, deenoowo yonkiiji mooɗon. ");
INSERT INTO fue_vpl VALUES ("P13_1","090_3_1","1PE","3","1","1","Onon rewɓe bo, moy mooɗon fu ɗowtanoo gorko muuɗum. Gam to woɓɓe maɓɓe goonɗinay haala Alla, jikku mon waawa ko wayliti ɓe, baa to on batay woliine. ");
INSERT INTO fue_vpl VALUES ("P13_2","090_3_2","1PE","3","2","2","Gam ɓe ji'an ko gaɗoton no laaɓiri, e no teddinirton Alla. ");
INSERT INTO fue_vpl VALUES ("P13_3","090_3_3","1PE","3","3","3","To on dartee ŋari ki yaasi, diga e moorɗi, ɗum bo kanŋeeri, maa bo gineeji ŋariiɗi. ");
INSERT INTO fue_vpl VALUES ("P13_4","090_3_4","1PE","3","4","4","Accee ŋari mooɗon ƴiwa diga der ɓerɗe, ŋari ki heennyataa, kan woni hakkillo ɗigguŋo, e deƴƴuŋo, kanjum laatii ko teddi yeeso Alla. ");
INSERT INTO fue_vpl VALUES ("P13_5","090_3_5","1PE","3","5","5","Hande nun rewɓe seniiɓe ɓe diga den, yowuɓe tammuwe mum dow Alla, wooɗiniri ko'e mum. Ɓee ɗowtanii worɓe maɓɓe. ");
INSERT INTO fue_vpl VALUES ("P13_6","090_3_6","1PE","3","6","6","Nun Saratu ɗowtoranii Iburahiima, faa o noddi mo joomiraawo. Onon woni ɓiɓɓe makko, to on gaɗii ko wooɗi, laatoo on kulay goɗɗum. ");
INSERT INTO fue_vpl VALUES ("P13_7","090_3_7","1PE","3","7","7","Onon worɓe bo, jooɗodee moy mon fu e debbo mum, der gondal pottuŋal. Annitee no rewɓe hewtay worɓe semme. Teddinee ɓe, gam kamɓe bo ɓe donidan e mon, yonki ki Alla hokkata der moƴƴere mum, heɓa to goɗɗum haɗu du'aaje mon. ");
INSERT INTO fue_vpl VALUES ("P13_8","090_3_8","1PE","3","8","8","Ɓaawo majjum, on fu laatee wooduɓe miilo wooto, jurmontiree, jiɗontiree hande mawniraaɓe e miiraaɓe, enɗontiree, leesinee ko'e mon. ");
INSERT INTO fue_vpl VALUES ("P13_9","090_3_9","1PE","3","9","9","To goɗɗo waɗanii on ko wooɗaa, to on battee mo, jennuɗo on bo to on jennitee ɗum: Amma barkiɗinee joomum, kanjum Alla noddani on gam donon barke. ");
INSERT INTO fue_vpl VALUES ("P13_10","090_3_10","1PE","3","10","10","Hande no Binni Ceniini wi'i: «Jiɗɗo wuurugo guurnam geetam, yi'a nyalaaɗe geete, sey waawa ɗenŋal mum dow ko halli, hunnuko mum acca batugo pewe. ");
INSERT INTO fue_vpl VALUES ("P13_11","090_3_11","1PE","3","11","11","O acca ko halli, o waɗa ko wooɗi, o darta jam e semme makko fu. ");
INSERT INTO fue_vpl VALUES ("P13_12","090_3_12","1PE","3","12","12","Gam Joomiraawo e hakkilani foonnitiiɓe, oo nana du'aaje maɓɓe. Amma oo hokka waɗooɓe ko halli ɓaawo.» ");
INSERT INTO fue_vpl VALUES ("P13_13","090_3_13","1PE","3","13","13","Moy toorata on to oon tinnii waɗugo ko wooɗi? ");
INSERT INTO fue_vpl VALUES ("P13_14","090_3_14","1PE","3","14","14","Amma baa to on tooraama gam waɗugo ko foonnitii, on barkiɗinaaɓe. To on kulee himɓe, to on accee hakkillooji mooɗon jiɓoo! ");
INSERT INTO fue_vpl VALUES ("P13_15","090_3_15","1PE","3","15","15","Teddinee Almasiihu Joomiraawo der ɓerɗe mooɗon. Wakkati fu ciriyee toontaago ƴamuɗo on daliila tammuwe mooɗon. ");
INSERT INTO fue_vpl VALUES ("P13_16","090_3_16","1PE","3","16","16","Amma toontee ɓe e ɗiggere, e hakkillo fukkiiŋo. Goodee miilooji ɓerɗe laaɓuɗi, den gaccotooɓe on, e yenna on, gam joonne mooɗon wooɗune der kawtal mon e Almasiihu senta. ");
INSERT INTO fue_vpl VALUES ("P13_17","090_3_17","1PE","3","17","17","Tooreego dow waɗugo ko wooɗi to nun Alla yiɗiri, e ɓuri tooreego dow waɗugo ko halli. ");
INSERT INTO fue_vpl VALUES ("P13_18","090_3_18","1PE","3","18","18","Gam Almasiihu e hoore mum maayi de woore, sabbu hakkeeji ɓiɓɓe Aadama. Kanko poonnitiiɗo, o maayanii en enen woofuɓe gam o yaara en to Alla. Himɓe warii mo, amma Ruuhu Ceniiɗo fintinii mo. ");
INSERT INTO fue_vpl VALUES ("P13_19","090_3_19","1PE","3","19","19","E Ruuhu on Yeesu yahi waajoroy baa e yonkiiji maɓɓaaɗi der kasu. ");
INSERT INTO fue_vpl VALUES ("P13_20","090_3_20","1PE","3","20","20","Kanji woni ruuhuuji himɓe ɓe ɗowtanaakino Alla der jaamanu Nuuhu, baa no o munyanii ɓe. De Nuuhu seɓunoo laana diyam mum, himɓe seɗɗa tan naati ŋa, kamɓe jeetato daɗi diyam ɗam. ");
INSERT INTO fue_vpl VALUES ("P13_21","090_3_21","1PE","3","21","21","Diyam ɗam laati nun misaalu batisi kisinan on ɗum jooni, hinaa batisi moytoojum tuuni ɓannu, amma haɓɓidingo e Alla alkawal e ɓerɗe laaɓuɗe nun, diga e pintol Yeesu Almasiihu. ");
INSERT INTO fue_vpl VALUES ("P13_22","090_3_22","1PE","3","22","22","Kanko, o eencii dow kammu, oo jooɗi nyaamo Alla. Malaykaaɓe e mawɓe, e wooduɓe baawɗe fu, e ɗowtanii mo. ");
INSERT INTO fue_vpl VALUES ("P14_1","090_4_1","1PE","4","1","1","Almasiihu yarii bone der ɓannu muuɗum, onon bo goodee iri miilooji ɗin. Jaruɗo bone der ɓannu muuɗum seedi e hakke. ");
INSERT INTO fue_vpl VALUES ("P14_2","090_4_2","1PE","4","2","2","Diga jooni faa balɗe mooɗon koriiɗe der duuniyaaru, sey goniron hande no Alla yiɗiri, ceedon e suunooji ɓannu. ");
INSERT INTO fue_vpl VALUES ("P14_3","090_4_3","1PE","4","3","3","Goonki mon ki nyaamunoɗon naane, gaɗuɗon hande heeferɓe, ki heƴi, on gonakeno der hallumaru, e suunooji e jarɗe bagi, e fijooji kalluɗi, e jaamanuuji jarɗe bagi, caafuɗon tooruuje karmuɗe. ");
INSERT INTO fue_vpl VALUES ("P14_4","090_4_4","1PE","4","4","4","No caliɗon hawtugo e maɓɓe der fijooji kalluɗi, kanjum haaynii ɓe jooni, go ɓee biisa inɗe mon. ");
INSERT INTO fue_vpl VALUES ("P14_5","090_4_5","1PE","4","5","5","Amma ɓe daroyto yeeso Alla, ciriyiiɗo hiitaago wuuruɓe e maayɓe, ɓe toontoto mo. ");
INSERT INTO fue_vpl VALUES ("P14_6","090_4_6","1PE","4","6","6","Kanjum waɗi maayɓe bo waajaa linjiila, ɓe kiitaa dow ko ɓe gaɗi, hande no himɓe fu hiitortee der ɓannu, heɓa ɓe buurda e Alla der ruuhu. ");
INSERT INTO fue_vpl VALUES ("P14_7","090_4_7","1PE","4","7","7","Huune fu ɓadake heennyugo, gam majjum gaɗee hakkillo, jogee ko'e mon gam gaɗon du'aaje. ");
INSERT INTO fue_vpl VALUES ("P14_8","090_4_8","1PE","4","8","8","Ko ɓuri fu, jiɗontiree e yidde hebbune, gam yidde e yaafoo hakkeeji ɗuuɗɗi. ");
INSERT INTO fue_vpl VALUES ("P14_9","090_4_9","1PE","4","9","9","Beernontiree hakkune mon, hinaa e dumbitaago. ");
INSERT INTO fue_vpl VALUES ("P14_10","090_4_10","1PE","4","10","10","Baamoy mon heɓii dokkal Alla. Golliree ŋal gam nafon woɓɓe. Hande nun kollitirton oon gollira dokke moƴƴere feere feereeje ɗe Alla hokki on. ");
INSERT INTO fue_vpl VALUES ("P14_11","090_4_11","1PE","4","11","11","Baajotooɗo fu, sey waajoo haala Alla. Jaggotooɗo bo, jaggoo e semme ne Alla hokki ɗum, gam der huune ko gaɗoton fu, teddinon Alla diga e Yeesu Almasiihu, mo tedduŋal e baawɗe wonani faa abada! Aami ");
INSERT INTO fue_vpl VALUES ("P14_12","090_4_12","1PE","4","12","12","Banniraaɓe am yiɗaaɓe, to on accee tooraaji buluɗi keɓanɗi on gam foonnugo on haaynoo on, hande huune koɗum. ");
INSERT INTO fue_vpl VALUES ("P14_13","090_4_13","1PE","4","13","13","Amma to oon kawti e Almasiihu der toora mum, ceyee oon belbelta booɗum to tedduŋal makko suppitoyke. ");
INSERT INTO fue_vpl VALUES ("P14_14","090_4_14","1PE","4","14","14","To on jennaama gam inne Almasiihu, barke laatanto on, gam Ruuhu tedduɗo, laatiiɗo Ruuhu Alla e wondi e mooɗon. ");
INSERT INTO fue_vpl VALUES ("P14_15","090_4_15","1PE","4","15","15","To goɗɗo e mooɗon yaru bone gam oo laatii baroowo himɓe, ɗum bo gam emo laatii gujjo, maa bo gaɗoowo ko halli, to ɗum bo dow naatugo haala ka yaalay ɗum. ");
INSERT INTO fue_vpl VALUES ("P14_16","090_4_16","1PE","4","16","16","Amma to o tooraama gam oo tokkii Almasiihu, to o sentir ɗum, o yetta Alla gam oo noddee goonɗinɗo Almasiihu. ");
INSERT INTO fue_vpl VALUES ("P14_17","090_4_17","1PE","4","17","17","Gam wakkati kiita faanake, Alla fuɗɗiran hiitaago himɓe muuɗum, to ka fuɗɗirii en enen, noy ɗum laatantoo himɓe ɓe jaɓay linjiila Alla? ");
INSERT INTO fue_vpl VALUES ("P14_18","090_4_18","1PE","4","18","18","Binni Ceniini wi'i: «To poonnitiiɗo hisiri no boni, ume laatantoo kalluɗo e gaɗoowo hakke?» ");
INSERT INTO fue_vpl VALUES ("P14_19","090_4_19","1PE","4","19","19","Gam ɗum ɗon fu, tooreteeɓe no Alla yiɗiri, yowa yonkiiji mum dow Alla tagoowo, koolaaɗo, ɓe tokka waɗugo ko wooɗi. ");
INSERT INTO fue_vpl VALUES ("P15_1","090_5_1","1PE","5","1","1","Jooni emii badda dottiiɓe eklesiya wonɓe caka mon, gam min bo mii dottiijo hande maɓɓe. Mi seedake tooraaji Almasiihu, mi wonoto der tedduŋal ŋal o hollitoyta. ");
INSERT INTO fue_vpl VALUES ("P15_2","090_5_2","1PE","5","2","2","Duree himɓe Alla ɓe jowanaɗon. To on gaɗee ɗum e doole, amma e ɓerɗe goote, hande no Alla yiɗiri, to on duree ɓe gam heɓugo joddi kalluni, amma gam oon jiɗi ɗum puy. ");
INSERT INTO fue_vpl VALUES ("P15_3","090_5_3","1PE","5","3","3","To on kollee himɓe ɓe Alla yowani on semme, amma laatanee ɓe misaalu. ");
INSERT INTO fue_vpl VALUES ("P15_4","090_5_4","1PE","5","4","4","To Duroowo mawɗo yottake, on meelete meetalol tedduŋal ŋol hiiɗɗataa. ");
INSERT INTO fue_vpl VALUES ("P15_5","090_5_5","1PE","5","5","5","Onon gojankeeɓe ɗowtanee dottiiɓe. On fu, ɓornee yakkinaare hande toggoore hakkune mon, gam e winnaa der Dewtere Ceniine: «Alla e haɓida mawnitiiɓe, amma ɓuytuɓe ko'e mum oo hokka ɓe moƴƴere makko.» ");
INSERT INTO fue_vpl VALUES ("P15_6","090_5_6","1PE","5","6","6","Gam majjum ɓuytee ko'e mon yeeso Alla mo semme, heɓa o mawnina on to wakkati yottake. ");
INSERT INTO fue_vpl VALUES ("P15_7","090_5_7","1PE","5","7","7","Doontiree sugullaaji mooɗon fu dow makko, gam emo hakkilani on. ");
INSERT INTO fue_vpl VALUES ("P15_8","090_5_8","1PE","5","8","8","Kakkilee, oon deeni! Gam ganyo mooɗon Ibiliisa e yiilito hande jaggere kalɓoore, dartoore mo ne ƴakkata. ");
INSERT INTO fue_vpl VALUES ("P15_9","090_5_9","1PE","5","9","9","Kaɓidee e makko, tiiɗee der goonɗinki, gam oon anni banniraaɓe mooɗon sankitiiɓe der duuniyaaru nu, e woodi iri tooraaji ɗii kanun bo. ");
INSERT INTO fue_vpl VALUES ("P15_10","090_5_10","1PE","5","10","10","Amma to on jarii bone der wakkati seɗɗa, Alla mo moƴƴere nodduɗo on gam naaton der tedduŋal mum tabitiiŋal e Almasiihu, kanko o tiiɗinan on, o semmiɗina on, o hebbina on, o darna on. ");
INSERT INTO fue_vpl VALUES ("P15_11","090_5_11","1PE","5","11","11","Baawɗe wonana mo faa abada! Aami. ");
INSERT INTO fue_vpl VALUES ("P15_12","090_5_12","1PE","5","12","12","Silaasi banniraawo men koolaaɗo wallii am winnango on ɗereyel pettel ŋel, gam tiiɗingo on e seedanaago on no habaru moƴƴere Alla ne dariɗon dow mum laati nun gooŋa. ");
INSERT INTO fue_vpl VALUES ("P15_13","090_5_13","1PE","5","13","13","Eklesiya gonuka Babiila ka Alla suɓi sannii on. Marku ɓiyam bo e sanna on. ");
INSERT INTO fue_vpl VALUES ("P15_14","090_5_14","1PE","5","14","14","Cannontiree cannooje ɗe yidde. Jam wona dow mooɗon onon hawtuɓe der Almasiihu. ");
INSERT INTO fue_vpl VALUES ("P21_1","091_1_1","2PE","1","1","1","Ɗerewol ŋol ƴiwii e am min Simon Piyer. Mii laatii jaggiiɗo e lilaaɗo Yeesu Almasiihu. Mi sannii on, onon heɓuɓe goonɗinki geeti hande ki amen, gam sabbu foonnitaare Alla men, tawaane der Yeesu Almasiihu, kisinoowo. ");
INSERT INTO fue_vpl VALUES ("P21_2","091_1_2","2PE","1","2","2","Alla ɗuuɗinana on moƴƴere e jam gam oon anni mo, kanko e Joomiraawo meeɗen Yeesu. ");
INSERT INTO fue_vpl VALUES ("P21_3","091_1_3","2PE","1","3","3","Baawɗe Alla hokkii en huune fu ko haanani en buuriren, e no haani goniren e kulol Alla. Baawɗe ɗen wallii en annugo Alla nodduɗo en kawten der tedduŋal mum, e geetaaku mum. ");
INSERT INTO fue_vpl VALUES ("P21_4","091_1_4","2PE","1","4","4","Diga e baawɗe ɗen keɓuɗen moƴƴereeji mawɗi, tedduɗi, ɗi gaɗanaɗen alkawal mum. O waɗii ɗum gam kawton e makko, nandon mo, gam daɗon suunooji duuniyaaru kalkooji. ");
INSERT INTO fue_vpl VALUES ("P21_5","091_1_5","2PE","1","5","5","Gam huune ɗum, tinnee, ɓeydee dow goonɗinki mooɗon geetaaku, dow geetaaku, annal, ");
INSERT INTO fue_vpl VALUES ("P21_6","091_1_6","2PE","1","6","6","dow annal, nantaare, dow nantaare, tinnaare, dow tinnaare, kulol Alla, ");
INSERT INTO fue_vpl VALUES ("P21_7","091_1_7","2PE","1","7","7","dow kulol Alla, banniraagu, dow banniraagu, yidde. ");
INSERT INTO fue_vpl VALUES ("P21_8","091_1_8","2PE","1","8","8","To huune ɗum fu oon jogii ɗum no wooɗi, ko e ɗum ɓeydo der mooɗon, ɗum wallan on ɓeydaago yeeso yeeso der annugo mooɗon Joomiraawo meeɗen Yeesu Almasiihu. ");
INSERT INTO fue_vpl VALUES ("P21_9","091_1_9","2PE","1","9","9","Neɗɗo mo huune ɗum jacci, laati nun bumɗo, o yi'ataa, gam o yeggitii no Alla laaɓini mo diga e hakkeeji makko jawtuɗi. ");
INSERT INTO fue_vpl VALUES ("P21_10","091_1_10","2PE","1","10","10","Gam majjum banniraaɓe am, tinnee no baawirɗon fu, gam tabbitinon noddoore ne Alla noddi on, e cuɓol ŋol o suɓi on. Gam to on gaɗii ɗum on janataa der ko halli abada! ");
INSERT INTO fue_vpl VALUES ("P21_11","091_1_11","2PE","1","11","11","Hande non Alla maɓɓitiranta on mammam dammugal Laamaare tabitiine, ne Joomiraawo meeɗen Yeesu Almasiihu kisinoowo en. ");
INSERT INTO fue_vpl VALUES ("P21_12","091_1_12","2PE","1","12","12","Kanjum acci wakkati fu mii siwtora on huune ɗum, baa no oon anni ɗum, heɓa cemmiɗon der gooŋa ka jaɓuɗon. ");
INSERT INTO fue_vpl VALUES ("P21_13","091_1_13","2PE","1","13","13","Mii miili, eɗum foonnitii, mi finnina hakkillooji mooɗon faa ciwtoron ɗum to emii wuuri. ");
INSERT INTO fue_vpl VALUES ("P21_14","091_1_14","2PE","1","14","14","Gam mii anni mi ɓooyataa e duuniyaaru ɗo kade, hande no Joomiraawo meeɗen Yeesu Almasiihu anninirinmi ɗum. ");
INSERT INTO fue_vpl VALUES ("P21_15","091_1_15","2PE","1","15","15","Amma mi waɗan ko baawumi fu, gam to mi yawti, baawon ko siwtori kujje ɗee wakkati fu. ");
INSERT INTO fue_vpl VALUES ("P21_16","091_1_16","2PE","1","16","16","E haalaaji ɗi himɓe tafi bane men anniniri on wittoygo Joomiraawo meeɗen Yeesu Almasiihu e baawɗe, amma men ceedike e gite amen manŋu makko! ");
INSERT INTO fue_vpl VALUES ("P21_17","091_1_17","2PE","1","17","17","Alla Baaba hokkii mo tedduŋal wakkati daane ne tedduŋal seedanii mo wi'i: «Oo ɗo nun laatii Ɓiyam jiɗaaɗo, mo belirmi ɓerne.» ");
INSERT INTO fue_vpl VALUES ("P21_18","091_1_18","2PE","1","18","18","Menen e ko'e amen men nanii daane nen diga dow kammu, gam emen gondunoo e makko dow waanne seniine. ");
INSERT INTO fue_vpl VALUES ("P21_19","091_1_19","2PE","1","19","19","Ɗum ɗon fu ɓeydanii men tabbitingo ko annabiiɓe batunoo. On gaɗii ko wooɗi no gattuɗon hakkillooji mooɗon dow makka, gam haala maɓɓe e nandi hande fitilleel jalboowel der niwre, e hande hoodere fajiri jalboore der ɓerɗe mooɗon faa de fajiri waɗi, ");
INSERT INTO fue_vpl VALUES ("P21_20","091_1_20","2PE","1","20","20","Aran, annitee no walaa baawoowo ko faamini ko winnaa der dewte annabiiɓe e annal hoore mum. ");
INSERT INTO fue_vpl VALUES ("P21_21","091_1_21","2PE","1","21","21","Hande non, walaa mo meeɗi ko heɓi haala annabaaku e sago hoore mum, amma Ruuhu Ceniiɗo nun waɗata himɓe e bata haala Alla. ");
INSERT INTO fue_vpl VALUES ("P22_1","091_2_1","2PE","2","1","1","Hande no annabiiɓe fewrekuuɓe wonirno caka Isira'iilaaɓe, non bo janŋinooɓe fewrekuuɓe wonortoo caka mooɗon. Ɓe naannan janŋinol fewrekuwol, kalkoowol, caka mon. Ɓe jeddan Joomiraawo cooditiiɗo ɓe. Hande non ɓe pooɗiranta ko'e maɓɓe halkere yaawune. ");
INSERT INTO fue_vpl VALUES ("P22_2","091_2_2","2PE","2","2","2","Himɓe ɗuuɓɓe tokkan laabi maɓɓe kalluɗi, sabbu maɓɓe, himɓe batanan laawol gooŋa kalluka. ");
INSERT INTO fue_vpl VALUES ("P22_3","091_2_3","2PE","2","3","3","Suunooji maɓɓe waddanan ɓe batugo haalaaji fewrekuuji gam ɓe jammoo on, amma ɓe doƴƴaamaa kiita diga ɗum ɓooyii, halkere e nyuɗanoo ɓe. ");
INSERT INTO fue_vpl VALUES ("P22_4","091_2_4","2PE","2","4","4","Baa malaykaaɓe waɗunooɓe hakke, Alla accay ɗum, o haɓɓii ɓe e callalluuji, o faɗɗi der niwre jahannama, faa nyalaane darŋal. ");
INSERT INTO fue_vpl VALUES ("P22_5","091_2_5","2PE","2","5","5","Alla accay duuniyaaru naane, amma o halkii yedduɓe Alla e ilam tufaana, sey Nuuhu baajotooɗo foonnitaare Alla, e himɓe jeeɗiɗo woɓɓe hisi. ");
INSERT INTO fue_vpl VALUES ("P22_6","091_2_6","2PE","2","6","6","Alla accay ci'e Sodoma e Gomora, o hiitake, o halki ɗe e yiite faa ɗe laatii dooni, gam ɗum laatanoo yeddooɓe Alla fu misaalu. ");
INSERT INTO fue_vpl VALUES ("P22_7","091_2_7","2PE","2","7","7","O daɗinii Luudu, neɗɗo poonnitiiɗo, mo ɓerne mum biisii puy sabbu baadiiji himɓe bonɓe. ");
INSERT INTO fue_vpl VALUES ("P22_8","091_2_8","2PE","2","8","8","Neɗɗo poonnitiiɗo jooɗiiɗo caka maɓɓe on, ɓerne mum laaɓune naawi dow ko yi'ata, e ko nanata nyalaane fu, sabbu baadiiji bonɗi ɗi himɓe halluɓe waɗata. ");
INSERT INTO fue_vpl VALUES ("P22_9","091_2_9","2PE","2","9","9","Eɗum holla en no Joomiraawo e anni no reenirta ɗowtantooɓe ɗum der tooraaji mum. Oo anni bo no o resirta himɓe halluɓe gam ɓe kiitee nyaanne darŋal, ");
INSERT INTO fue_vpl VALUES ("P22_10","091_2_10","2PE","2","10","10","accu du tokkuɓe suunooji ɓalli mum, e waɗa jiɗaaɗi yonki mum, ko e yawii baawɗe Joomiraawo. Janŋinooɓe fewrekuuɓe ɓen ɓerɗe mum e yoori, ɓee goodi manŋu hoore, ɓee bata kalluka dow tedduɓe wonɓe dow kammu. ");
INSERT INTO fue_vpl VALUES ("P22_11","091_2_11","2PE","2","11","11","Nani bo, baa malaykaaɓe ɓee ɗo ɓuri ɓe semme e baawɗe, batataa kalluka dow maɓɓe yeeso Joomiraawo. ");
INSERT INTO fue_vpl VALUES ("P22_12","091_2_12","2PE","2","12","12","Amma himɓe ɓen e laatii hande bisaaji ɗi galaa hakkillo, tagaaɗi gam nanŋee, waree. Ɓee bata kalluka dow ko ɓe annaa, gam majjum ɓe kalkiran hande no bisaaji halkirta. ");
INSERT INTO fue_vpl VALUES ("P22_13","091_2_13","2PE","2","13","13","Ɓe duggan riiba golle maɓɓe kalluɗe. Ɓee ceyoroo waɗugo ko wooɗaa caka nyalooma. Ɓee laatii coɓuɓe e nyidduɓe. To ɓe jooɗike gam ɓe nyaamda e mooɗon der juulɗe, ɓee ceyoroo jammaago on. ");
INSERT INTO fue_vpl VALUES ("P22_14","091_2_14","2PE","2","14","14","Gite maɓɓe sawtataa daarugo rewɓe e suuno, ɓe comataa waɗugo hakke, ɓee pooɗa ɓe goonɗinki mum walaa semme der pitti maɓɓe. Ɓerɗe maɓɓe e hebbi suuno keɓal, bone laatanto ɓe. ");
INSERT INTO fue_vpl VALUES ("P22_15","091_2_15","2PE","2","15","15","Ɓe accii laawol poortiiŋol, ɓe majjii, ɓe tokki laawol Balaama, jiɗuɗo heɓa ceede diga waɗugo kalluɗum. ");
INSERT INTO fue_vpl VALUES ("P22_16","091_2_16","2PE","2","16","16","O felaama gam boofol makko. Babba makko muuma bati e daane neɗɗo, haɗi mo waɗugo golle haaŋare makko. ");
INSERT INTO fue_vpl VALUES ("P22_17","091_2_17","2PE","2","17","17","Janŋinooɓe fewrekuuɓe ɓen laati nun hande ɓulli ɗi galaa diyam, e duule ɗe hennu semmentewol soggata, niwre ɓurne niɓɓugo nun Alla resani ɓe. ");
INSERT INTO fue_vpl VALUES ("P22_18","091_2_18","2PE","2","18","18","Ɓee bata haalaaji mawnitiiɗi, ɗi galaa hoore. Ɓee ƴoyra himɓe e haalaaji suuno ɓannu. Himɓe ɓen wurtikeno ɗum ɓooyay diga majjuɓe. ");
INSERT INTO fue_vpl VALUES ("P22_19","091_2_19","2PE","2","19","19","Ɓee kaɓɓana ɓe alkawal no ɓe dinɗan, amma kamɓe e ko'e maɓɓe ɓee laatii maccuɓe suunooji kalluɗi. Gam moy fu laati nun maccuɗo ko jaalii ɗum. ");
INSERT INTO fue_vpl VALUES ("P22_20","091_2_20","2PE","2","20","20","Wurtiiɓe e huune coɓuɗum ɗum duuniyaaru, go ɓe anniti Joomiraawo e Kisinoowo men Yeesu Almasiihu, den ko ɓe bittitii der majji kade faa ɗi jaalii ɓe, heennyitirde maɓɓe ɓuran fuɗɗoode jaasugo. ");
INSERT INTO fue_vpl VALUES ("P22_21","091_2_21","2PE","2","21","21","To ɓe annitayno laawol foonnitaare, ɗum ɓurananno ɓe, e annitingo ŋol, witta totta umuroore ceniine ne ɓe kokkaa ɓaawo. ");
INSERT INTO fue_vpl VALUES ("P22_22","091_2_22","2PE","2","22","22","Ko tawi ɓe e tabbitina haala ballool ŋol ɗo: «Rawaanu wittii e nyaamito tuure mum.» E wi'ee bo kade: «Afaaru lootaanu wittii e talloo der loope.» ");
INSERT INTO fue_vpl VALUES ("P23_1","091_3_1","2PE","3","1","1","Banniraaɓe am yiɗaaɓe, ɗerewol ŋol ɗo nun laatii ɗiɗaɓol ŋol binnanmi on. Der ɗereeji ɗiɗi ɗii fu, mii yiɗi finningo hakkillooji mooɗon gam wallugo on miilon no wooɗiri, ciwtoron ko ekkitinoɗon. ");
INSERT INTO fue_vpl VALUES ("P23_2","091_3_2","2PE","3","2","2","Ciwtoree haalaaji ɗi annabiiɓe seniiɓe batunoo diga ko ɓooyi, e umuroore Joomiraawo meeɗen kisinoowo, ne lilaaɓe mon annini on. ");
INSERT INTO fue_vpl VALUES ("P23_3","091_3_3","2PE","3","3","3","Aran, annitee ɗum ɗo: Der nyalaaɗe cakitiiɗe, himɓe jaancooɓe, tokkuɓe jiɗaaɗi yonki mum waran. Ɓe jaancan on, ");
INSERT INTO fue_vpl VALUES ("P23_4","091_3_4","2PE","3","4","4","ɓe bi'a: «O haɓɓii alkawru o wittaan, toy mo? Diga ko kaakiraaɓe meeɗen maayi walaa ko waylitii, no ɗum laatinoo diga fuɗɗoode duuniyaaru, non ɗum laatii faa jooni.» ");
INSERT INTO fue_vpl VALUES ("P23_5","091_3_5","2PE","3","5","5","Ɓe jeggitii e yidde maɓɓe no diga ko ɓooyi, Alla tagi kammu e leydi e haala muuɗum. O wi'i leydi wurtoo diga diyam, go o tagiri ni e diyam, ");
INSERT INTO fue_vpl VALUES ("P23_6","091_3_6","2PE","3","6","6","e diyam gootam ɗam kade, duuniyaaru halkiraa e ilam tufaana. ");
INSERT INTO fue_vpl VALUES ("P23_7","091_3_7","2PE","3","7","7","E haala makko goota kan, o jogorii kammu e leydi, ɗum ji'eten jooni faa nyalaane darŋal yottoo, o halka ɗum der yiite e yedduɓe Alla. ");
INSERT INTO fue_vpl VALUES ("P23_8","091_3_8","2PE","3","8","8","Banniraaɓe am yiɗaaɓe, to on jeggitee no to Joomiraawo, nyalaane woore e wa'i hande duuɓi ujuneere, duuɓi ujuneere bo e wa'i hande nyalaane woore. ");
INSERT INTO fue_vpl VALUES ("P23_9","091_3_9","2PE","3","9","9","Joomiraawo ɓooyataa go hebbina alkawru mum, hande no woɓɓe miili, o munyan on nun tan, gam o yiɗaa baa gooto halka. Ko o yiɗi nun, himɓe fu wittaa to makko tuuba. ");
INSERT INTO fue_vpl VALUES ("P23_10","091_3_10","2PE","3","10","10","Nyalaane Joomiraawo waran hande gujjo. Nyalaane nen, kammu majjitan e rimmo manŋo. Ko woni dow kammu fu halkete e yiite. Leydi e golle gaɗaaɗe dow mayri fu, hiitete. ");
INSERT INTO fue_vpl VALUES ("P23_11","091_3_11","2PE","3","11","11","To huune fu halkete hande non, sey annon no nyaamirton goonki mon der laaɓal, oon kuliri Alla! ");
INSERT INTO fue_vpl VALUES ("P23_12","091_3_12","2PE","3","12","12","Onon heɗiiɓe nyalaane Alla wara, gaɗee no ne warirta law! Nyaanne mum kammu halkan, huune ko woni dow kammu fu taayan e yiite. ");
INSERT INTO fue_vpl VALUES ("P23_13","091_3_13","2PE","3","13","13","Amma enen, een keɗii hande no Alla haɓɓirani en alkawru, kammu keso e leydi keyri, to foonnitaare tawetee. ");
INSERT INTO fue_vpl VALUES ("P23_14","091_3_14","2PE","3","14","14","Gam majjum, onon banniraaɓe am yiɗaaɓe, tinnee laatoɗon ɓe galaa gacce, e tuuni yeeso Alla. Goodee jam der kawtal mon e makko, oon keɗorii nyalaane nen. ");
INSERT INTO fue_vpl VALUES ("P23_15","091_3_15","2PE","3","15","15","Paamee no munyal Joomiraawo meeɗen maɓɓitanii on laawol kisidam. Kanka banniraawo meeɗen Pol, jiɗaaɗo, winnani on der ɗereeji mum hande no Alla hokkiri mo hakkillo majjum. ");
INSERT INTO fue_vpl VALUES ("P23_16","091_3_16","2PE","3","16","16","Non o winniri ɗum der ɗereeji makko fu. Der majji e woodi nokkuuje goɗɗe to saɗi faamugo, himɓe ɓe annaa goɗɗum, e ɓe ɓennay der goonɗinki e waylita miilooji makko, hande non ɓe gaɗata e nokkuuje goɗɗe der Dewtere Ceniine. Ɓe gaddanan ko'e maɓɓe halkere. ");
INSERT INTO fue_vpl VALUES ("P23_17","091_3_17","2PE","3","17","17","Amma onon banniraaɓe yiɗaaɓe, on keɓii seedineego, to non kakkilee to himɓe yedduɓe Alla majjina on, sottina on diga darande mon. ");
INSERT INTO fue_vpl VALUES ("P23_18","091_3_18","2PE","3","18","18","Mawnee der moƴƴere e annugo Joomiraawo meeɗen Yeesu Almasiihu kisinoowo en! Tedduŋal laatanoo mo diga jooni faa abada! Aami! ");
INSERT INTO fue_vpl VALUES ("J11_1","092_1_1","1JN","1","1","1","Emen binnana on haala neɗɗo gom gonuɗo. Men nanii daane makko, men ji'ii mo e gite amen, men daarii mo, men meemi mo e juuɗe amen. Kanko woni haala kokkoowa himɓe yonki. ");
INSERT INTO fue_vpl VALUES ("J11_2","092_1_2","1JN","1","2","2","Yonki kin hollitaama, men ji'ii ki, emen ceedanoo ki. Emen baajoo on haala yonki tabitiiki gonunooki to Alla Baaba, kanki men kollitaa. ");
INSERT INTO fue_vpl VALUES ("J11_3","092_1_3","1JN","1","3","3","Ko men ji'i, e ko men nani, kan men batata on onon bo, gam laatoɗon gootum e amen hande no laatoriɗen gootum e Baaba e Ɓiɗɗo mum Yeesu Almasiihu. ");
INSERT INTO fue_vpl VALUES ("J11_4","092_1_4","1JN","1","4","4","Kanka men binnanta on, gam belɗum ɓerne meeɗen hebba. ");
INSERT INTO fue_vpl VALUES ("J11_5","092_1_5","1JN","1","5","5","Habaru ko men nani e Yeesu Almasiihu, kan men batata on haala mum, Alla laati nun jayŋol, niwre walaa e makko. ");
INSERT INTO fue_vpl VALUES ("J11_6","092_1_6","1JN","1","6","6","To en bi'ii een laatii gootum e makko, ko een tawaa der niwre, en pewii, gooŋa walaa der gaɗu meeɗen. ");
INSERT INTO fue_vpl VALUES ("J11_7","092_1_7","1JN","1","7","7","Amma to een jaha der jayŋol hande no kanko e hoore makko o wonori der jayŋol, den kan een laatii gootum hakkune meeɗen, kade bo ƴiiƴam Ɓiɗɗo makko Yeesu e laaɓina en diga hakkeeji men fu. ");
INSERT INTO fue_vpl VALUES ("J11_8","092_1_8","1JN","1","8","8","To en bi'ii en galaa hakke, en pewanii ko'e men, gooŋa walaa e meeɗen. ");
INSERT INTO fue_vpl VALUES ("J11_9","092_1_9","1JN","1","9","9","Amma to en tuubanii Alla hakke meeɗen, o yaafoto en, o laaɓina en e tuuni fu. Gam kanko, o kooliniiɗo, o poonnitiiɗo. ");
INSERT INTO fue_vpl VALUES ("J11_10","092_1_10","1JN","1","10","10","To en bi'ii en gaɗay hakke, en laatinii Alla pewoowo, haala makko bo walaa der meeɗen. ");
INSERT INTO fue_vpl VALUES ("J12_1","092_2_1","1JN","2","1","1","Onon sukaaɓe am, mi winnanii on ɗum, gam to on gaɗee hakke. Amma to goɗɗo mooɗon waɗii hakke, een goodi balloowo to Baaba, kanko woni Yeesu Almasiihu, poonnitiiɗo. ");
INSERT INTO fue_vpl VALUES ("J12_2","092_2_2","1JN","2","2","2","Kanko, o sakki yonki makko gam hakkeeji meeɗen yaafee, hakkeeji meeɗen tan bane, amma hakkeeji himɓe duuniyaaru fu. ");
INSERT INTO fue_vpl VALUES ("J12_3","092_2_3","1JN","2","3","3","Ko hollitinta no een anni Alla woni, ɗowtanaago oodaaji makko. ");
INSERT INTO fue_vpl VALUES ("J12_4","092_2_4","1JN","2","4","4","Bi'uɗo «emi anni mo,» go ɗowtanaaki oodaaji makko, joomum laati nun pewoowo, gooŋa walaa der joomum. ");
INSERT INTO fue_vpl VALUES ("J12_5","092_2_5","1JN","2","5","5","Amma ɗowtaniiɗo haala Alla e gooŋa, yidde Alla hebbii dow joomum. Nunnun annitirten een kawti e makko. ");
INSERT INTO fue_vpl VALUES ("J12_6","092_2_6","1JN","2","6","6","Bi'uɗo e hawti e makko, e haani wonoo hande no Almasiihu wonirnoo. ");
INSERT INTO fue_vpl VALUES ("J12_7","092_2_7","1JN","2","7","7","Banniraaɓe am yiɗaaɓe, ko binnanmi on hinaa ooda kesa, ooda ɓooyuka nun, ka nanuɗon diga fuɗɗoode. ");
INSERT INTO fue_vpl VALUES ("J12_8","092_2_8","1JN","2","8","8","E nun fu ooda kesa nun binnanmi on, gooŋa makka hollitake der Almasiihu, ka hollitake der mooɗon bo. Gam niwre e yawta, jayŋol gooŋawol fuɗɗii yaynugo. ");
INSERT INTO fue_vpl VALUES ("J12_9","092_2_9","1JN","2","9","9","Miiluɗo na'on der jayŋol, ko e wanyi banniraawo mum, faa hanne der niwre joomum woni taw. ");
INSERT INTO fue_vpl VALUES ("J12_10","092_2_10","1JN","2","10","10","Jiɗɗo banniraawo mum der jayŋol woni, goɗɗum walaa ko ferginta mo. ");
INSERT INTO fue_vpl VALUES ("J12_11","092_2_11","1JN","2","11","11","Amma banyuɗo banniraawo mum, der niwre woni, oo yaha der niwre, o annaa toy o yahata, gam niwre wuminii mo. ");
INSERT INTO fue_vpl VALUES ("J12_12","092_2_12","1JN","2","12","12","Sukaaɓe am, mii winnana on gam hakkeeji mooɗon yaafaama gam inne Yeesu. ");
INSERT INTO fue_vpl VALUES ("J12_13","092_2_13","1JN","2","13","13","Baabiraaɓe, mii winnana on gam oon anni gonuɗo diga fuɗɗoode. Gojankeeɓe, mii winnana on gam on jaalake Kalluɗo. ");
INSERT INTO fue_vpl VALUES ("J12_14","092_2_14","1JN","2","14","14","Sukaaɓe am, mi winnanii on, gam oon anni Baaba. Baabiraaɓe, mi winnanii on, gam oon anni gonuɗo diga fuɗɗoode. Gojankeeɓe, mi winnanii on gam oon goodii semme, haala Alla bo e semmiɗi der mooɗon, kade bo on jaalake Kalluɗo. ");
INSERT INTO fue_vpl VALUES ("J12_15","092_2_15","1JN","2","15","15","To on jiɗee duuniyaaru e ko woni e mayru fu. Gam jiɗɗo kujje duuniyaaru, yidde Baaba walaa e mum. ");
INSERT INTO fue_vpl VALUES ("J12_16","092_2_16","1JN","2","16","16","Gam huune ko woni e duuniyaaru, hande jon ko neɗɗo suunete, e ko gite yi'ata, suunee, e jawdi ni o mawnitorto, kujje ɗe fu ƴiway e Baaba, e duuniyaaru ɗe ƴiwi. ");
INSERT INTO fue_vpl VALUES ("J12_17","092_2_17","1JN","2","17","17","Duuniyaaru e suuno mum fu heennyan, amma gaɗoowo ko Alla yiɗi, taboto faa abada. ");
INSERT INTO fue_vpl VALUES ("J12_18","092_2_18","1JN","2","18","18","Sukaaɓe am, duuniyaaru ɓadake heennyugo. On nanii ganyo Almasiihu waran, jooni du wayɓe Almasiihu ɗuuɓɓe yottake. Kanjum annitirɗen no wakkati ɓadake. ");
INSERT INTO fue_vpl VALUES ("J12_19","092_2_19","1JN","2","19","19","Caka men ɓe ƴiwi, amma e gooŋa ɓe laataaki ɓe meeɗen. Gam to ɓee laatino ɓe men, ɓe gondanno e meeɗen. Amma ɓe accii en gam ɗum hollita no ɓe fu, ɓe laataakino ɓe meeɗen. ");
INSERT INTO fue_vpl VALUES ("J12_20","092_2_20","1JN","2","20","20","Amma onon, Almasiihu hokkii on Ruuhu Ceniiɗo, on fu oon anni gooŋa. ");
INSERT INTO fue_vpl VALUES ("J12_21","092_2_21","1JN","2","21","21","Mi winnanay on gam on annaa gooŋa. Amma gam oon anni ka. Oon anni bo fewre walaa der gooŋa. ");
INSERT INTO fue_vpl VALUES ("J12_22","092_2_22","1JN","2","22","22","Den kan, moy woni pewoowo? Jedduɗo Yeesu laati nun Almasiihu, Paabotooɗo mo Alla liloy, kanko woni pewoowo, kanko woni ganyo Almasiihu, o yeddii Baaba e Ɓiɗɗo mum. ");
INSERT INTO fue_vpl VALUES ("J12_23","092_2_23","1JN","2","23","23","Jedduɗo Yeesu laati nun Ɓiɗɗo, walaa Baaba, jaɓuɗo Ɓiɗɗo, e woodi Baaba bo. ");
INSERT INTO fue_vpl VALUES ("J12_24","092_2_24","1JN","2","24","24","Onon kan haala ka nanuɗon diga fuɗɗoode, tinnee jogee ka der ɓerɗe mooɗon. To haala ka nanuɗon diga fuɗɗoode tabitake der ɓerɗe mooɗon, den kan, oon goodi kawtal e Ɓiɗɗo e Baaba. ");
INSERT INTO fue_vpl VALUES ("J12_25","092_2_25","1JN","2","25","25","Almasiihu haɓɓanii en alkawal, alkawal ŋal woni yonki tabitiiki. ");
INSERT INTO fue_vpl VALUES ("J12_26","092_2_26","1JN","2","26","26","Mi winnanii on ɗum gam sabbu himɓe yiɗuɓe majjingo on. ");
INSERT INTO fue_vpl VALUES ("J12_27","092_2_27","1JN","2","27","27","Onon kan, no Ruuhu Ceniiɗo mo Almasiihu hokki on e tabitii der mooɗon, on bukaaka janŋineɗon. Gam Ruuhu janŋinan on huune fu, o janŋinan on gooŋa, hinaa fewre. Den kan, kawtee e Almasiihu hande no Ruuhu janŋiniri on. ");
INSERT INTO fue_vpl VALUES ("J12_28","092_2_28","1JN","2","28","28","Jooni kan onon sukaaɓe am, tabitee der kawtal mon e Almasiihu, gam keɓen cuusal daraago yeeso makko nyaanne o suppitoy, heɓa daɗen senteene nyalaane garki makko. ");
INSERT INTO fue_vpl VALUES ("J12_29","092_2_29","1JN","2","29","29","No oon annii Alla laati nun gooŋaajo, annee bo mo gaɗu mum foonnitii fu, laati nun ɓiyiiko. ");
INSERT INTO fue_vpl VALUES ("J13_1","092_3_1","1JN","3","1","1","Daaree no Alla Baaba yiɗiri en, faa noddaɗen ɓiɓɓe makko. Een ɓiɓɓe makko e gooŋa. Ko acci duuniyaaru annaa en woni gam nu annaa mo. ");
INSERT INTO fue_vpl VALUES ("J13_2","092_3_2","1JN","3","2","2","Yiɗaaɓe am, jooni en laatake ɓiɓɓe Alla. Ko laatoytoɗen laaɓay taw. Amma een anni to Almasiihu wittoy holliti hoore mum, en nandan e makko, gam en ji'an mo hande no o wa'i. ");
INSERT INTO fue_vpl VALUES ("J13_3","092_3_3","1JN","3","3","3","Gooduɗo tammuwe nen dow Almasiihu, laaɓinan hoore mum hande no kanko Almasiihu o laatori laaɓuɗo. ");
INSERT INTO fue_vpl VALUES ("J13_4","092_3_4","1JN","3","4","4","Gaɗoowo hakke fu, ƴartake sariya Alla. Gam waɗugo hakke laati nun ƴartaago sariya Alla. ");
INSERT INTO fue_vpl VALUES ("J13_5","092_3_5","1JN","3","5","5","Oon anni Almasiihu wari gam moytugo hakkeeji, kanko mo walaa hakke. ");
INSERT INTO fue_vpl VALUES ("J13_6","092_3_6","1JN","3","6","6","Kawtuɗo e makko fu waɗataa hakke. Gaɗoowo hakke fu, yi'ay mo, annaa mo bo. ");
INSERT INTO fue_vpl VALUES ("J13_7","092_3_7","1JN","3","7","7","Sukaaɓe am, to on accee goɗɗo majjina on! Gaɗoowo ko goonɗi fu laati nun gooŋaajo, hande no Almasiihu laatori gooŋaajo. ");
INSERT INTO fue_vpl VALUES ("J13_8","092_3_8","1JN","3","8","8","Gaɗoowo hakke fu laati nun neɗɗo Ibiliisa, gam Ibiliisa e waɗa hakke diga fuɗɗoode. Gam majjum Ɓiɗɗo Alla wari gam halka golle Ibiliisa. ");
INSERT INTO fue_vpl VALUES ("J13_9","092_3_9","1JN","3","9","9","Laatiiɗo ɓinŋel Alla fu, waɗataa hakke, gam awdi Alla na'on der makko. Joomum waawataa ko tokkii waɗugo hakke, gam Alla laatii baaba makko. ");
INSERT INTO fue_vpl VALUES ("J13_10","092_3_10","1JN","3","10","10","Ko seennontirta ɓiɓɓe Alla e ɓiɓɓe Ibiliisa nani: mo waɗay ko goonɗi fu, neɗɗo Alla bane. Mo yiɗaa banniraaɓe mum bo, laataaki mo Alla. ");
INSERT INTO fue_vpl VALUES ("J13_11","092_3_11","1JN","3","11","11","Habaru nanuɗon diga fuɗɗoode nani: Jiɗontiren hakkune meeɗen. ");
INSERT INTO fue_vpl VALUES ("J13_12","092_3_12","1JN","3","12","12","Haanay gaɗen hande no Kayiinu waɗi kanko laatiiɗo mo Ibiliisa, o warii minnyiiko. Gam ume waɗi o wari minnyiiko? O warii mo gam golle makko wooɗay, go ɗe minnyiiko laatii goonɗuɗe. ");
INSERT INTO fue_vpl VALUES ("J13_13","092_3_13","1JN","3","13","13","Banniraaɓe, to on kayɗinee to himɓe duuniyaaru wanyii on. ");
INSERT INTO fue_vpl VALUES ("J13_14","092_3_14","1JN","3","14","14","No een jiɗi banniraaɓe meeɗen, een anni en ƴartake maayde, en naatii der yonki. Mo yiɗaa banniraawo mum, der maayde woni. ");
INSERT INTO fue_vpl VALUES ("J13_15","092_3_15","1JN","3","15","15","Banyuɗo banniraawo mum fu, laati nun baroowo himɓe. Oon anni walaa baroowo baa gooto woodi yonki tabitiiki der mum. ");
INSERT INTO fue_vpl VALUES ("J13_16","092_3_16","1JN","3","16","16","No annitirɗen ko woni yidde nun, Almasiihu hokkitirii yonki mum gam meeɗen. To nun enen bo, e haani kokkitiren yonkiiji meeɗen gam banniraaɓe men. ");
INSERT INTO fue_vpl VALUES ("J13_17","092_3_17","1JN","3","17","17","To jom jawdiijo yi'ii banniraawo mum e talakiɗi, ko yurmaaki mo, noy yidde Alla waawirta ko woni e makko? ");
INSERT INTO fue_vpl VALUES ("J13_18","092_3_18","1JN","3","18","18","Sukaaɓe am, haanay yidde meeɗen laatoo e haala belka tan, sey ka laatoo e gaɗu gooŋawu. ");
INSERT INTO fue_vpl VALUES ("J13_19","092_3_19","1JN","3","19","19","Kanjum hollata, en na'on der gooŋa, en deƴƴitinan ɓerɗe meeɗen yeeso Alla. ");
INSERT INTO fue_vpl VALUES ("J13_20","092_3_20","1JN","3","20","20","To ɓerɗe meeɗen gaccake en, Alla e ɓuri ɓerɗe meeɗen, emo anni huune fu. ");
INSERT INTO fue_vpl VALUES ("J13_21","092_3_21","1JN","3","21","21","Banniraaɓe am yiɗaaɓe, to ɓerɗe meeɗen gaccaaki en, en daroto yeeso Alla e hoolaare. ");
INSERT INTO fue_vpl VALUES ("J13_22","092_3_22","1JN","3","22","22","O hokkan en ko eeluɗen mo fu, gam en tokkii ooda makko, een gaɗa ko fottani mo. ");
INSERT INTO fue_vpl VALUES ("J13_23","092_3_23","1JN","3","23","23","Ooda ka o hokki en woni, goonɗinen inne Yeesu Almasiihu, Ɓiɗɗo makko, kade bo jiɗontiren hakkune meeɗen hande no o ƴamiri en. ");
INSERT INTO fue_vpl VALUES ("J13_24","092_3_24","1JN","3","24","24","Ɗowtaniiɗo ooda Alla fu e hawti e Alla, Alla bo e hawti e joomum. Ruuhu mo o hokki en, kanŋu anninta en oo hawti e meeɗen. ");
INSERT INTO fue_vpl VALUES ("J14_1","092_4_1","1JN","4","1","1","Banniraaɓe am yiɗaaɓe, to on goonɗinee wi'ooɓe e woodi Ruuhu Alla fu, amma biɗitee ɓe, heɓa anniton naa to Alla ɓe ƴiwi. Gam annabiiɓe fewooɓe ɗuuɓɓe e sankitii der duuniyaaru. ");
INSERT INTO fue_vpl VALUES ("J14_2","092_4_2","1JN","4","2","2","No annitirten gooduɗo Ruuhu Alla woni, to o seedake Yeesu Almasiihu warii, laatii neɗɗo, oo ɗon e woodi Ruuhu Alla. ");
INSERT INTO fue_vpl VALUES ("J14_3","092_4_3","1JN","4","3","3","Mo annitay kaa ɗon dow Yeesu fu, woodaa Ruuhu Alla. Ruuhu ŋu o woodi ƴiwii diga ganyo Almasiihu. On nanii garki ganyo Almasiihu batanaama, o na'on ko der duuniyaaru. ");
INSERT INTO fue_vpl VALUES ("J14_4","092_4_4","1JN","4","4","4","Sukaaɓe am, onon on himɓe Alla, on jaalake annabiiɓe fewooɓe, gam Ruuhu gonɗo der mooɗon e ɓuri gonɗo der duuniyaaru semme. ");
INSERT INTO fue_vpl VALUES ("J14_5","092_4_5","1JN","4","5","5","Kamɓe himɓe duuniyaaru ɓe laati. Gam majjum, ɓe batata haalaaji duuniyaaru, himɓe duuniyaaru bo e hettinanoo ɓe. ");
INSERT INTO fue_vpl VALUES ("J14_6","092_4_6","1JN","4","6","6","Enen, een himɓe Alla, annuɗo Alla fu hettinanto en. Mo laataaki neɗɗo Alla hettinantaako en. Nun ceennontirten Ruuhu gooŋa e ruuhu fewre. ");
INSERT INTO fue_vpl VALUES ("J14_7","092_4_7","1JN","4","7","7","Banniraaɓe am yiɗaaɓe, jiɗontiree, gam yidde ƴiwi e Alla. Gooduɗo yidde fu laati nun ɓinŋel Alla, e anni Alla bo. ");
INSERT INTO fue_vpl VALUES ("J14_8","092_4_8","1JN","4","8","8","Mo walaa yidde annaa Alla, gam Alla laati nun yidde. ");
INSERT INTO fue_vpl VALUES ("J14_9","092_4_9","1JN","4","9","9","No Alla hollitiri en yidde mum nani, o lili Ɓiɗɗo makko bajjo der duuniyaaru, gam keɓen yonki diga e makko. ");
INSERT INTO fue_vpl VALUES ("J14_10","092_4_10","1JN","4","10","10","Daaru ko woni yidde, enen bane yiɗi Alla, kanko yiɗi en, liloy Ɓiɗɗo mum wari laatii sadaka gam hakkeeji meeɗen yaafee. ");
INSERT INTO fue_vpl VALUES ("J14_11","092_4_11","1JN","4","11","11","Banniraaɓe am, to nii Alla yiɗiri en, enen bo, e haani jiɗontiren. ");
INSERT INTO fue_vpl VALUES ("J14_12","092_4_12","1JN","4","12","12","Walaa meeɗuɗo yi'ugo Alla abada. Amma to en jiɗontirii hakkune men, Alla e hawti e meeɗen, yidde makko e hebbi der men. ");
INSERT INTO fue_vpl VALUES ("J14_13","092_4_13","1JN","4","13","13","Noy annirten een kawti e makko, kanko bo oo hawti e meeɗen? Diga e Ruuhu makko ŋu o hokki en nun. ");
INSERT INTO fue_vpl VALUES ("J14_14","092_4_14","1JN","4","14","14","Menen men ji'ii, emen ceedo bo no Alla Baaba liloy Ɓiɗɗo mum gam wara hisina himɓe duuniyaaru. ");
INSERT INTO fue_vpl VALUES ("J14_15","092_4_15","1JN","4","15","15","Ceediiɗo Yeesu laati nun Ɓiɗɗo Alla fu, Alla e hawti e joomum, joomum bo e hawti e Alla. ");
INSERT INTO fue_vpl VALUES ("J14_16","092_4_16","1JN","4","16","16","Enen kan, een anni yidde Alla yiɗi en, een koolii ne bo. Alla e hoore mum laati nun yidde, gooduɗo yidde fu, e hawti e Alla, Alla bo e hawti e joomum. ");
INSERT INTO fue_vpl VALUES ("J14_17","092_4_17","1JN","4","17","17","Gam to yidde makko hebbii der meeɗen, en keɓan cuusal daraago nyalaane darŋal. Gam no Almasiihu wa'i, hande nun enen bo ga'uɗen der duuniyaaru ɗo. ");
INSERT INTO fue_vpl VALUES ("J14_18","092_4_18","1JN","4","18","18","Kulol walaa der yidde, yidde hebbune e riiwa kulol, gam kulol ƴiwii diga yaggingo. Kuloowo fu, yidde Alla woni hebbay der joomum. ");
INSERT INTO fue_vpl VALUES ("J14_19","092_4_19","1JN","4","19","19","Enen een jiɗi Alla gam kanko arti yiɗi en. ");
INSERT INTO fue_vpl VALUES ("J14_20","092_4_20","1JN","4","20","20","Bi'uɗo e yiɗi Alla, go e wanyi banniraawo mum laati nun pewoowo. Gam mo yiɗay banniraawo mum ji'eteeɗo, waawataa ko yiɗi Alla mo yi'ataake. ");
INSERT INTO fue_vpl VALUES ("J14_21","092_4_21","1JN","4","21","21","Daaru ooda ka Almasiihu accani en: jiɗuɗo Alla fu, sey yiɗa banniraawo mum bo. ");
INSERT INTO fue_vpl VALUES ("J15_1","092_5_1","1JN","5","1","1","Goonɗinɗo Yeesu woni Almasiihu fu laati nun Ɓiɗɗo Alla. Jiɗuɗo baaba fu, e yiɗi ɓiɗɗo bo. A yiɗataa baaba, banyaa ɓiɗɗo. ");
INSERT INTO fue_vpl VALUES ("J15_2","092_5_2","1JN","5","2","2","No annirten een jiɗi ɓiɓɓe Alla woni jiɗen Alla, den tokken oodaaji makko. ");
INSERT INTO fue_vpl VALUES ("J15_3","092_5_3","1JN","5","3","3","Tokkugo oodaaji makko woni yiɗugo mo. Oodaaji makko laataaki doongal, ");
INSERT INTO fue_vpl VALUES ("J15_4","092_5_4","1JN","5","4","4","gam laatiiɗo mo Alla fu, jaaloto kujje duniyaaru. E goonɗinki meeɗen jaalortoɗen kujje duniyaaru. ");
INSERT INTO fue_vpl VALUES ("J15_5","092_5_5","1JN","5","5","5","Moy waawata ko jaali duniyaaru? Walaa, to hinaa goonɗinɗo Yeesu nun woni Ɓiɗɗo Alla. ");
INSERT INTO fue_vpl VALUES ("J15_6","092_5_6","1JN","5","6","6","Kanko, Yeesu Almasiihu, o wari e diyam e ƴiiƴam. E diyam tan bane o wardi, o wardii e diyam e ƴiiƴam fu. Ruuhu e hoore mum seedake ɗum, gam Ruuhu on woni gooŋa. ");
INSERT INTO fue_vpl VALUES ("J15_7","092_5_7","1JN","5","7","7","Seedeeɓe tato woni, ");
INSERT INTO fue_vpl VALUES ("J15_8","092_5_8","1JN","5","8","8","Ruuhu e diyam e ƴiiƴam, seedaaku maɓɓe fu laatii gootu. ");
INSERT INTO fue_vpl VALUES ("J15_9","092_5_9","1JN","5","9","9","Een jaɓa seedaaku himɓe, amma seedaaku Alla ɓuri semme, seedaaku ŋun non Alla seedanii Ɓiɗɗo mum. ");
INSERT INTO fue_vpl VALUES ("J15_10","092_5_10","1JN","5","10","10","Goonɗinɗo Ɓiɗɗo Alla fu, heɓii seedaaku ŋu der ɓerne mum. Mo goonɗinay Alla, laatinii mo pewoowo, gam o jaɓay seedaaku Alla seedanii Ɓiɗɗo mum. ");
INSERT INTO fue_vpl VALUES ("J15_11","092_5_11","1JN","5","11","11","Nani ɗo seedaaku ŋu: Alla hokkii en yonki tabitiiki, yonki kin der Ɓiɗɗo makko ki woni. ");
INSERT INTO fue_vpl VALUES ("J15_12","092_5_12","1JN","5","12","12","Gooduɗo Ɓiɗɗo e woodi yonki. Mo walaa Ɓiɗɗo Alla woodaa yonki. ");
INSERT INTO fue_vpl VALUES ("J15_13","092_5_13","1JN","5","13","13","Onon goonɗinɓe inne Ɓiɗɗo Alla, mi winnanii on ɗum gam anniton on keɓii yonki tabitiiki. ");
INSERT INTO fue_vpl VALUES ("J15_14","092_5_14","1JN","5","14","14","Hoolaare ne gooduɗen nani: To en eelii mo huune e sago makko, oo nanana en. ");
INSERT INTO fue_vpl VALUES ("J15_15","092_5_15","1JN","5","15","15","No een anni oo nanana en ko eeluɗen mo, een anni en keɓii ɗum. ");
INSERT INTO fue_vpl VALUES ("J15_16","092_5_16","1JN","5","16","16","To goɗɗo yi'ii banniraawo mum e waɗa hakke ɗe yaarataa ɗum der maayde, o eelana joomum Alla, Alla bo hokkan mo yonki. Haala ka nafan dow waɗooɓe hakke ɗe yaarataa ɗum der maayde. Amma e woodi hakke jaarooje der maayde. Mi wi'ay eelon Alla gam iri hakke ɗe. ");
INSERT INTO fue_vpl VALUES ("J15_17","092_5_17","1JN","5","17","17","Kujje kalluɗe fu laati nun hakke, amma hakke fu bane yaarata der maayde. ");
INSERT INTO fue_vpl VALUES ("J15_18","092_5_18","1JN","5","18","18","Een anni laatiiɗo ɓinŋel Alla tokkataako waɗugo hakkeeji, amma Ɓiɗɗo Alla e reeni mo, Ibiliisa kalluɗo meemataa mo. ");
INSERT INTO fue_vpl VALUES ("J15_19","092_5_19","1JN","5","19","19","Een anni en himɓe Alla, go duuniyaaru fu e woni der junŋo Ibiliisa. ");
INSERT INTO fue_vpl VALUES ("J15_20","092_5_20","1JN","5","20","20","Een anni bo Ɓiɗɗo Alla wari, hokkii en hakkillo annitingo Alla gooŋaajo, jooni kanko woodi en, gam en kawti e Ɓiɗɗo makko Yeesu Almasiihu. Yeesu Almasiihu on woni Alla gooŋaajo, kanko woni yonki tabitiiki bo. ");
INSERT INTO fue_vpl VALUES ("J15_21","092_5_21","1JN","5","21","21","Sukaaɓe am, kakkilanee ko'e mooɗon e caafi tooruuje. ");
INSERT INTO fue_vpl VALUES ("J21_1","093_1_1","2JN","1","1","1","Min dottiijo, winni ɗerewol ŋol, mi winnanii maa an debbo mo Alla suɓi. Mi sannii maa an e ɓiɓɓe maa fu, onon ɓe jiɗum der gooŋa. Min tan bane yiɗi on, annuɓe gooŋa fu e yiɗi on, ");
INSERT INTO fue_vpl VALUES ("J21_2","093_1_2","2JN","1","2","2","gam sabbu gooŋa tabitiika der meeɗen, gonotooka der meeɗen faa abada. ");
INSERT INTO fue_vpl VALUES ("J21_3","093_1_3","2JN","1","3","3","Alla Baaba, e Ɓiɗɗo mum Yeesu Almasiihu hokka en moƴƴere e enɗam e jam, ɓeydana en gooŋa e yidde. ");
INSERT INTO fue_vpl VALUES ("J21_4","093_1_4","2JN","1","4","4","Ɓerne am welii sanne, no nanumi ɓiɓɓe maa woɓɓe e yaha der gooŋa hande no Baaba ƴamiri. ");
INSERT INTO fue_vpl VALUES ("J21_5","093_1_5","2JN","1","5","5","Jooni, an yeeraajo, ko gonum emi winnanee hinaa ooda kesa, ooda ka keɓuɗen diga fuɗɗoode nun, mi eelii maa, accu jiɗontiren hakkune meeɗen. ");
INSERT INTO fue_vpl VALUES ("J21_6","093_1_6","2JN","1","6","6","Ko woni yidde nun, jahen der ooda Alla. Kanka woni ooda ka nanuɗen diga fuɗɗoode, kaanuka jahen dow mun. ");
INSERT INTO fue_vpl VALUES ("J21_7","093_1_7","2JN","1","7","7","Majjinooɓe ɗuuɓɓe sankitake e duuniyaaru. Ɓe jaɓay Yeesu Almasiihu warii laatii neɗɗo. Ga'uɗo nun fu, majjinoowo nun, ganyo Almasiihu nun bo. ");
INSERT INTO fue_vpl VALUES ("J21_8","093_1_8","2JN","1","8","8","Kakkilanee ko'e mooɗon, gam to on majjin riiba golle amen heɓa keɓon joddi kebbuni. ");
INSERT INTO fue_vpl VALUES ("J21_9","093_1_9","2JN","1","9","9","Mo daraaki dow kollitol Almasiihu ko ƴaartii ŋol, walanaa Alla. Dariiɗo e maggol fu, e wonani Baaba e Ɓiɗɗo mum. ");
INSERT INTO fue_vpl VALUES ("J21_10","093_1_10","2JN","1","10","10","To goɗɗo wari caka mooɗon go waajaaki kollitol ŋol, to on jaɓee mo der wuro mooɗon, to on cannee mo bo. ");
INSERT INTO fue_vpl VALUES ("J21_11","093_1_11","2JN","1","11","11","Gam cannuɗo mo, hawti e makko der golle makko kalluɗe. ");
INSERT INTO fue_vpl VALUES ("J21_12","093_1_12","2JN","1","12","12","Ko Haani mi bata on e ɗuuɗi, amma mi yiɗaa winnango on ɗum ɗum fu der ɗerewol e dawa. Amma mi miili warugo to mooɗon, gam keɓen badden hunnuko e hunnuko, gam belɗum ɓerɗe meeɗen hebba. ");
INSERT INTO fue_vpl VALUES ("J21_13","093_1_13","2JN","1","13","13","Sukaaɓe miiraawo maa mo Alla suɓi sannii maa. ");
INSERT INTO fue_vpl VALUES ("J31_1","094_1_1","3JN","1","1","1","Min dottiijo, winni ɗerewol ŋol. Mii winnanee an banniraawo am Gayus, jiɗaaɗo der gooŋa. ");
INSERT INTO fue_vpl VALUES ("J31_2","094_1_2","3JN","1","2","2","Banniraawo am jiɗaaɗo, mii eela huune fu yahanee yeeso, ɓannu maa yanɗa hande no yonki maa yanɗiri. ");
INSERT INTO fue_vpl VALUES ("J31_3","094_1_3","3JN","1","3","3","Ɓerne am weli sanne no banniraaɓe woɓɓe wari seedanii am no tinnoriɗaa der gooŋa, e no jahirtaa der gooŋa bo. ");
INSERT INTO fue_vpl VALUES ("J31_4","094_1_4","3JN","1","4","4","Walaa ko ɓuri welingo ɓerne am, to hinaa nanugo no ɓikkol am e yaha der gooŋa. ");
INSERT INTO fue_vpl VALUES ("J31_5","094_1_5","3JN","1","5","5","Banniraawo am jiɗaaɗo, golle geete ɗe gaɗataa e wallugo banniraaɓe baa to ɓee hoɓɓe e hollita aa kooliniiɗo. ");
INSERT INTO fue_vpl VALUES ("J31_6","094_1_6","3JN","1","6","6","Ɓe ceedake yidde maa yeeso jama'aare goonɗinɓe ɗo. Wallu ɓe hande no fottiranta Alla der jahaaŋal maɓɓe, den a waɗii ko wooɗi. ");
INSERT INTO fue_vpl VALUES ("J31_7","094_1_7","3JN","1","7","7","Gam inne Almasiihu ɓe gaɗi jahaaŋal maɓɓe, ɓe keɓay goɗɗum e juuɗe ɓe goonɗinay. ");
INSERT INTO fue_vpl VALUES ("J31_8","094_1_8","3JN","1","8","8","Gam majjum haani, balliten himɓe iri maɓɓe, gam golliden e maɓɓe der fiinugo gooŋa. ");
INSERT INTO fue_vpl VALUES ("J31_9","094_1_9","3JN","1","9","9","Mi winnanii jama'aare goonɗinɓe ɗerewol, amma Diyoterefes, jiɗɗo ardingo hoore mum jaɓay haala amen. ");
INSERT INTO fue_vpl VALUES ("J31_10","094_1_10","3JN","1","10","10","Gam majjum, to mi warii, mi hollan ko o waɗata e no o biisirta inne amen. Kanjum tan bane: O jaɓɓataako banniraaɓe hoɓɓe, kade bo, yiɗuɓe jaɓɓaago ɓe, oo haɗa ɗum, oo riiwa ɓe diga e eklesiya. ");
INSERT INTO fue_vpl VALUES ("J31_11","094_1_11","3JN","1","11","11","Banniraawo am jiɗaaɗo, taa yemmin ko boni, yemmin ko wooɗi. Gaɗoowo ko wooɗi fu, neɗɗo Alla nun. Gaɗoowo ko halli bo, annaa Alla. ");
INSERT INTO fue_vpl VALUES ("J31_12","094_1_12","3JN","1","12","12","Demeteriyus kan, himɓe fu e seedanoo ɗum ko wooɗi, gooŋa e hoore mum bo e seedanoo mo ɗum. Menen bo, emen ceedo ɗum, aa anni bo seedaaku amen e laatii gooŋa. ");
INSERT INTO fue_vpl VALUES ("J31_13","094_1_13","3JN","1","13","13","Ko haani mi winnanee e ɗuuɗi, amma mi yiɗaa winnugo ɗum ɗum fu der ɗerewol e dawa. ");
INSERT INTO fue_vpl VALUES ("J31_14","094_1_14","3JN","1","14","14","Mii haaɓi yi'ugo maa law, gam badden hunnuko e hunnuko. ");
INSERT INTO fue_vpl VALUES ("J31_15","094_1_15","3JN","1","15","15","Igooɓe maa wonɓe ɗo fu sannii maa. Mi sannii banniraaɓe fu, gooto gooto. Jam wona e maa. ");
INSERT INTO fue_vpl VALUES ("JD1_1","095_1_1","JUD","1","1","1","Ɗerewol ŋol ƴiwi e am min Yahuuda, maccuɗo Yeesu Almasiihu, miiraawo Yaakuuba. Mi sannii on, onon ɓe Alla Baaba meeɗen yiɗi, go noddi on, onon reenaaɓe gam Yeesu Almasiihu. ");
INSERT INTO fue_vpl VALUES ("JD1_2","095_1_2","JUD","1","2","2","Alla ɗuuɗinana on enɗam e jam, e yidde! ");
INSERT INTO fue_vpl VALUES ("JD1_3","095_1_3","JUD","1","3","3","Banniraaɓe am yiɗaaɓe, mi yiɗiino puy winnango on dow haala kisidam kawtuɗam en en fu. Jooni mi tawii doole nun mi winnana on gam tiiɗingo on dow hawre goonɗinki ki Alla hokki himɓe mum de woore, go ki heƴi faa baadey. ");
INSERT INTO fue_vpl VALUES ("JD1_4","095_1_4","JUD","1","4","4","Gam himɓe halluɓe naati caka mooɗon e ƴoyre. Ɓee darta lelugo haala moƴƴere Alla men, gam ɓe nyaama goonki maɓɓe no ɓe pakkiri fu. Ɓee jedda Yeesu Almasiihu laatiiɗo hooreejo meeɗen gooto, e Joomiraawo meeɗen. Dewte ceniiɗe bataniino halkere maɓɓe. ");
INSERT INTO fue_vpl VALUES ("JD1_5","095_1_5","JUD","1","5","5","Jooni, mii yiɗi siwtorgo on ko annuɗon, ko wooɗi. Wakkati Joomiraawo wurtini himɓe Isira'iila diga Misira, ɓaawo mum o halkii ɗuuɓɓe maɓɓe gam ɓe goonɗinay. ");
INSERT INTO fue_vpl VALUES ("JD1_6","095_1_6","JUD","1","6","6","Ciwtoree bo malaykaaɓe, saliiɓe ko darii to Alla resani ɗum, ɓe acci darande maɓɓe. Gam majjum Alla maɓɓi ɓe der kasu tabitiiŋu, e der niwre, faa nyalaane darŋal, ko ɓe kiitee. ");
INSERT INTO fue_vpl VALUES ("JD1_7","095_1_7","JUD","1","7","7","Kade bo, ciwtoree himɓe Sodoma e Gomora, e himɓe genniije takkiiɗe ton fu. Kamɓe bo, ɓe gaɗiino hande non, ɓe gaɗii jeenu e ko luudii fu. Ɓe kalkiraama e yiite tabitiiŋe, gam ɗum laatanoo himɓe fu misaalu. ");
INSERT INTO fue_vpl VALUES ("JD1_8","095_1_8","JUD","1","8","8","Hande non, naatuɓe caka mooɗon ɓen miilirta miilooji jaaranɗi ɓe soɓingo ɓalli maɓɓe. Ɓee jawoo baawɗe Joomiraawo, ɓee bata kalluka dow tedduɓe wonuɓe dow kammu. ");
INSERT INTO fue_vpl VALUES ("JD1_9","095_1_9","JUD","1","9","9","Baa Mika'iilu, hooreejo malaykaaɓe batay kalluka dow Seyɗan wakkati ɓe jeddontirtano dow ɓannu Muusa. Ka o bati tan woni, o wi'i: «Joomiraawo hiitee.» ");
INSERT INTO fue_vpl VALUES ("JD1_10","095_1_10","JUD","1","10","10","Amma himɓe ɓee e bata kalluka dow ko ɓe annaa. Ko ɓe anni dow ko finaa tawa bo, ɓee laatii hande bisaaji ɗi galaa faamu, kanjum majjinta ɓe. ");
INSERT INTO fue_vpl VALUES ("JD1_11","095_1_11","JUD","1","11","11","Bone laatanii ɓe! Gam ɓe tokkii laawol Kayiinu. Ɓe gattii ko'e maɓɓe der majjere, hande ne Balaama, gam ɓe keɓa jawdi. Ɓe turtii hande no gorko bi'eteeɗo Koora turtiri, go ɓe kalki. ");
INSERT INTO fue_vpl VALUES ("JD1_12","095_1_12","JUD","1","12","12","Kamɓe woni e soɓina nyaamdu kawtal mooɗon. Ɓe galaa senteene, ɓee nyaama hande bisaaji. Ko'e maɓɓe tan ɓe paalaa. Ɓee nandi hande duule ɗe hennu ɓottata, ɗe galaa diyam. Ɓee nandi hande leɗɗe ceeɗu, ɗe galaa ɓikkol, e hande leɗɗe ɗoofaaɗe, yoori. ");
INSERT INTO fue_vpl VALUES ("JD1_13","095_1_13","JUD","1","13","13","Ɓee cankita gaɗu maɓɓe kalluŋu, hande no galmaaji diyam maayo wurtinirta guufo. Ɓee nandi hande koode boosotooɗe, niwre ɓurune niɓɓugo fu Alla resani ɓe faa abada. ");
INSERT INTO fue_vpl VALUES ("JD1_14","095_1_14","JUD","1","14","14","Anuhu taaniraawo Aadamu jeeɗiɗaɓo, bataniino habaru maɓɓe diga ko ɓooyi, wi'i: «Daaree, Joomiraawo e warida e malaykaaɓe mum seniiɓe uju ujuneeje. ");
INSERT INTO fue_vpl VALUES ("JD1_15","095_1_15","JUD","1","15","15","Oo wara gam o hiito himɓe fu, o halka halluɓe fu, waɗooɓe ko halli. O hiitoto ɓe, gam haalaaji kalluɗi ɗi ɓe bati dow makko fu.» ");
INSERT INTO fue_vpl VALUES ("JD1_16","095_1_16","JUD","1","16","16","Himɓe ɓen laati nun dumbitintooɓe, ɓee bullikinoo wakkati fu, suunooji maɓɓe nun ɓe tokki. Ɓee mawnito dow majjum, ɓee mana woɓɓe gam ɓe keɓa ko ɓe jiɗi. ");
INSERT INTO fue_vpl VALUES ("JD1_17","095_1_17","JUD","1","17","17","Amma onon yiɗaaɓe am, ciwtoree haalaaji ɗi lilaaɓe Joomiraawo meeɗen Yeesu Almasiihu batunoo on diga law. ");
INSERT INTO fue_vpl VALUES ("JD1_18","095_1_18","JUD","1","18","18","Ɓe batiino on, ɓe bi'i: «Der jaamanuuji cakitiiɗi, himɓe jaancooɓe, tokkuɓe jiɗaaɗi yonki mum kalluɗi waraan.» ");
INSERT INTO fue_vpl VALUES ("JD1_19","095_1_19","JUD","1","19","19","Kamɓe nun ɗon, ɓee ceenna himɓe, miilooji duuniyaaru ɓe goodi, ɓe goodaa Ruuhu Alla. ");
INSERT INTO fue_vpl VALUES ("JD1_20","095_1_20","JUD","1","20","20","Amma onon yiɗaaɓe, cemmiɗinee ko'e mon dow goonɗinki mon ceniiki sanne, du'ee e baawɗe Ruuhu Ceniiɗo. ");
INSERT INTO fue_vpl VALUES ("JD1_21","095_1_21","JUD","1","21","21","Gonee der yidde Alla, keɗee enɗam Joomiraawo meeɗen Yeesu Almasiihu jaaranɗam on to yonki tabitiiki. ");
INSERT INTO fue_vpl VALUES ("JD1_22","095_1_22","JUD","1","22","22","Jurmee himɓe waɗooɓe seko der goonɗinki mum. ");
INSERT INTO fue_vpl VALUES ("JD1_23","095_1_23","JUD","1","23","23","Paabee woɓɓe, gam to naatu der yiite. Jurmee woɓɓe bo, amma kakkilee, to ɓe raaɓoo on jikku maɓɓe. Banyee faa e toggooje ɗe ɓalli maɓɓe soɓini. ");
INSERT INTO fue_vpl VALUES ("JD1_24","095_1_24","JUD","1","24","24","Alla waawan reenugo on e perge, faa o darna on yeeso tedduŋal makko e seyo, on galaa gacce. ");
INSERT INTO fue_vpl VALUES ("JD1_25","095_1_25","JUD","1","25","25","Kanko woni Alla gooto, kisinoowo en diga e Yeesu Almasiihu, Joomiraawo meeɗen. Tedduŋal, e manŋu, e baawɗe, e laamaare, laatanii mo, diga huune fu tagaaka, non bo faa e jooni, e faa abada abadin. Aami! ");
INSERT INTO fue_vpl VALUES ("RV1_1","096_1_1","REV","1","1","1","Dewtere nee ɗo, e batana haalaaji asiiri ko Yeesu Almasiihu holliti. Alla hollii mo ɗum, gam o holla gollotooɓe makko ko waroyta, ɓooyataa. Yeesu Almasiihu lilii malaykaajo mum gam o annina ɗum Yuhaana, maccuɗo makko. ");
INSERT INTO fue_vpl VALUES ("RV1_2","096_1_2","REV","1","2","2","Yuhaana seedake ko o yi'i fu, o batii haala Alla, o seedii ko Yeesu Almasiihu holliti. ");
INSERT INTO fue_vpl VALUES ("RV1_3","096_1_3","REV","1","3","3","Barke laatanii janŋoowo dewtere ne, e nanooɓe haala annabaaku ŋu, go e jogii ko winnaa der mayre! Gam wakkati ɓadike. ");
INSERT INTO fue_vpl VALUES ("RV1_4","096_1_4","REV","1","4","4","Min Yuhaana nun winnani eklesiyaaji jeeɗiɗi tawaaɗi der leydi Asiya. Moƴƴere, e jam laatanoo on diga e Alla gonuɗo, e goonnooɗo, e garoowo. Ɗum laatanoo on diga e ruuhuuji jeeɗiɗi, gonuɗi yeeso kittaal Laamaare makko. ");
INSERT INTO fue_vpl VALUES ("RV1_5","096_1_5","REV","1","5","5","Ɗum laatanoo on bo diga e Yeesu Almasiihu, ceedotooɗo koolaaɗo, artuɗo finti diga e maayɓe, laamiiɗo laamiiɓe duuniyaaru. Kanko yiɗi en, go o hisini en diga e hakkeeji men, e ƴiiƴam makko. ");
INSERT INTO fue_vpl VALUES ("RV1_6","096_1_6","REV","1","6","6","O laatinii en laamiiɓe, e Limaamiiɓe Alla baabiiko. Tedduŋal e Laamaare laatanoo mo, duuɓi duuɓaali. Aami. ");
INSERT INTO fue_vpl VALUES ("RV1_7","096_1_7","REV","1","7","7","Daaree, oo warida e duulere. Himɓe fu yi'an mo, baa yuwunooɓe mo, lenyi duuniyaaru fu simoto gam makko. Ɗum laatoo hande non! Aami. ");
INSERT INTO fue_vpl VALUES ("RV1_8","096_1_8","REV","1","8","8","Joomiraawo Alla, gonuɗo, e gonnooɗo, e garoowo, mo baawɗe wi'i: «Min woni arano, min woni sakitiineejo.» ");
INSERT INTO fue_vpl VALUES ("RV1_9","096_1_9","REV","1","9","9","Min woni Yuhaana banniraawo mooɗon. Mi hawtii e mooɗon der toora, e der Laamaare Yeesu Almasiihu, e der tinnaare makko. Mi yaaraama e semme dow duunne wi'eteene Patimos gam mi waajike haala Alla, ceedaniimi Yeesu. ");
INSERT INTO fue_vpl VALUES ("RV1_10","096_1_10","REV","1","10","10","Nyaanne nyalaane Joomiraawo, kebbumi Ruuhu, den nanumi ɓaawo am daane towne hande galalɗi puureteeɗi. ");
INSERT INTO fue_vpl VALUES ("RV1_11","096_1_11","REV","1","11","11","Daane nen e wi'a: «Ko ji'ataa, winnu ɗum der ɗerewol, lildaa eklesiyaaji jeeɗiɗi ɗii ɗo: Efesu e Samirna e Pergamu e Tiyatira, e Sardis, e Filadelfiya e Lawdikiya.» ");
INSERT INTO fue_vpl VALUES ("RV1_12","096_1_12","REV","1","12","12","Den jeeƴitiimi gam mi daara baddanɗo am, ko ji'umi fitillaaji jeeɗiɗi, gaɗiraaɗi kanŋeeri. ");
INSERT INTO fue_vpl VALUES ("RV1_13","096_1_13","REV","1","13","13","Goɗɗo nanduɗo e Ɓii neɗɗo e darii hakkune majji, oo ɓornii jabbaare, oo haɓɓi ɓelɓelol kanŋeeri to gabaare makko. ");
INSERT INTO fue_vpl VALUES ("RV1_14","096_1_14","REV","1","14","14","Hoore makko e gaasa makko e rawni tar hande hottollo e kosam, gite makko e wa'i hande ɗenŋal yiite. ");
INSERT INTO fue_vpl VALUES ("RV1_15","096_1_15","REV","1","15","15","Koyɗe makko e jalba hande janni boɗeeri buuɗaani faa wojji coy, daane makko e nandi hande rimmo diyam ɗuuɗɗam. ");
INSERT INTO fue_vpl VALUES ("RV1_16","096_1_16","REV","1","16","16","Oo jogii koode jeeɗiɗi e junŋo makko nyaamo. Kaafahi belki becce ɗiɗi e wurtoo diga e hunnuko makko. Yeeso makko e nandi hande naaŋe jalboowe caka nyalooma. ");
INSERT INTO fue_vpl VALUES ("RV1_17","096_1_17","REV","1","17","17","No ji'u moo mi, janumi yeeso makko, laatiimi hande maayɗo. Den o yowi junŋo makko nyaamo dow am, o wi'i: Taa hulu! Min woni arano, min woni cakitiiɗo, ");
INSERT INTO fue_vpl VALUES ("RV1_18","096_1_18","REV","1","18","18","min woni buuruɗo. Mi maayiino, amma jooni mii wuuri faa abada. Mii woodi baawɗe dow maayde e dow joonne maayɓe. ");
INSERT INTO fue_vpl VALUES ("RV1_19","096_1_19","REV","1","19","19","Gam majjum, winnu ko ji'ataa, ko waɗotoo, e ko waɗoytoo yeeso. ");
INSERT INTO fue_vpl VALUES ("RV1_20","096_1_20","REV","1","20","20","Nani ɗo asiiri koode jeeɗiɗi ɗe ji'uɗaa der junŋo am nyaamo, e fitillaaji kanŋeeri jeeɗiɗi. Koode jeeɗiɗi, laatii malaykaaɓe eklesiyaaji jeeɗiɗi. Fitillaaji kanŋeeri jeeɗiɗi bo, laatii eklesiyaaji jeeɗiɗi.» ");
INSERT INTO fue_vpl VALUES ("RV2_1","096_2_1","REV","2","1","1","«Winnan malaykaajo eklesiya Efesu, bi'aa: Nani haalaaji jogiiɗo koode jeeɗiɗi der junŋo mum nyaamo, jahoowo hakkune fitillaaji kanŋeeri jeeɗiɗi: ");
INSERT INTO fue_vpl VALUES ("RV2_2","096_2_2","REV","2","2","2","Mii anni golle maa, e tinnaare maa, e munyal maa. Mii anni a munyantaa halluɓe, a foonnii wi'ooɓe e laatii lilaaɓe, amma ɓe laataaki ɗum, a tawii ɓe laati nun fewooɓe. ");
INSERT INTO fue_vpl VALUES ("RV2_3","096_2_3","REV","2","3","3","Aa woodi munyal, a toorake gam inne am, amma a tampay. ");
INSERT INTO fue_vpl VALUES ("RV2_4","096_2_4","REV","2","4","4","Amma ko pelan maa mi woni, a accii yidde maa arandeere. ");
INSERT INTO fue_vpl VALUES ("RV2_5","096_2_5","REV","2","5","5","Gam majjum, siwtor diga to januɗaa. Tuubu, den gaɗaa golle maa arandeeje! To hinaa nun, mi waran, mi ikkina fitilla maa e nokkuure mum, sey to a tuubii. ");
INSERT INTO fue_vpl VALUES ("RV2_6","096_2_6","REV","2","6","6","Amma aa woodi gootum ko wooɗi: aa wanyi golle Nikolayiiɓe, hande no min bo banyirmi ɗe. ");
INSERT INTO fue_vpl VALUES ("RV2_7","096_2_7","REV","2","7","7","Gooduɗo noppi fu, nana ko Ruuhu batata eklesiyaaji! Jaaliiɗo fu, mi hokkan ɗum nyaama ɓiɓɓe leggal yonki gonuŋal der aljanna Alla.» ");
INSERT INTO fue_vpl VALUES ("RV2_8","096_2_8","REV","2","8","8","«Winnan malaykaajo eklesiya Samirna, bi'aa: Nani ɗo haalaaji ɗi bi'eteeɗo arano e sakitiineejo wi'i, kanko maayunooɗo ko finti. ");
INSERT INTO fue_vpl VALUES ("RV2_9","096_2_9","REV","2","9","9","Mii anni toora maa, e talakaaku maa, baa no aa jom jawdiijo. Mii anni kalluka ka wi'ooɓe e laatii Yahuduuɓe batata dow maa. Amma fewre, ɓe laati nun jama'aare saafooɓe Seyɗan. ");
INSERT INTO fue_vpl VALUES ("RV2_10","096_2_10","REV","2","10","10","Taa hulu toora ɓadiika tawugo maa. Daa Seyɗan maɓɓan woɓɓe mon der kasu, gam poonneɗon, on toorete faa balɗe sappo. Laata koolaaɗo faa maayde, mi hokkete keɓal jaalorgal, waato yonki. ");
INSERT INTO fue_vpl VALUES ("RV2_11","096_2_11","REV","2","11","11","Gooduɗo noppi, nana ko Ruuhu batata eklesiyaaji! Jaaliiɗo, maayde ɗiɗawre meemataa ɗum.» ");
INSERT INTO fue_vpl VALUES ("RV2_12","096_2_12","REV","2","12","12","«Winnan malaykaajo eklesiya Pergamu, bi'aa: Nani ɗo haalaaji jogiiɗo kaafahi ceeɓuki, ki beldiiji ɗiɗi: ");
INSERT INTO fue_vpl VALUES ("RV2_13","096_2_13","REV","2","13","13","Mii anni to jooɗiɗaa, ɗon nun laamorde Seyɗan woni. Aa jogii inne am, a yedday goonɗingo am baa der wakkati Antipas seedeejo am koolaaɗo waraa caka mooɗon, to Seyɗan woni. ");
INSERT INTO fue_vpl VALUES ("RV2_14","096_2_14","REV","2","14","14","Amma mii woodi ko pelan maa mi: Aa woodi woɓɓe tokkuɓe ekkitinol Balaama. Balaama ekkitiniino Balak waɗa no himɓe Isira'iila yanirta. O acca ɓe ƴakka tew caafiraaɗum tooruuje, ɓe gaɗa jeenu bo. ");
INSERT INTO fue_vpl VALUES ("RV2_15","096_2_15","REV","2","15","15","Hande nun an bo, aa woodi tokkuɓe ekkitinol Nikolayiiɓe. ");
INSERT INTO fue_vpl VALUES ("RV2_16","096_2_16","REV","2","16","16","Gam majjum tuubu, to hinaa nun, ɓooyataa, mi waran to maa, mi haɓidan ɓe e kaafahi gonuki e hunnuko am. ");
INSERT INTO fue_vpl VALUES ("RV2_17","096_2_17","REV","2","17","17","Gooduɗo noppi, nana ko Ruuhu batata eklesiyaaji! Jaaliiɗo, mi hokkan ɗum nyaamdu suuɗiinu, wi'eteenu “maannu”. Mi hokkan mo bo, kaaƴel daneyel. Dow maggel, inne heyre e winnaa. Goɗɗo annaa inne nen to hinaa kokkaaɗo ne.» ");
INSERT INTO fue_vpl VALUES ("RV2_18","096_2_18","REV","2","18","18","«Winnan malaykaajo eklesiya Tiyatira bi'aa: Nani ɗo haalaaji Ɓiɗɗo Alla mo gite mum nandi hande ɗenŋal yiite, koyɗe makko e nandi hande janni boɗeeri. ");
INSERT INTO fue_vpl VALUES ("RV2_19","096_2_19","REV","2","19","19","Mii anni golle maa, e yidde maa, e goonɗinki maa, e ballal ŋal ballataa woɓɓe, e munyal maa. Mii anni golle maa cakitiiɗe e ɓuri arandeeje ɗuuɗugo. ");
INSERT INTO fue_vpl VALUES ("RV2_20","096_2_20","REV","2","20","20","Amma woodi ko pelan maa mi. Aa acci Ijabeeli, debbo bi'oowo hoore mum annabiijo. Oo janŋina, oo jarboo gollotooɓe am, gam ɓe gaɗa jeenu, ɓe ƴakka tew caafiraaɗum tooruuje. ");
INSERT INTO fue_vpl VALUES ("RV2_21","096_2_21","REV","2","21","21","Mi hokkii mo wakkati gam o tuuba, amma o salike ko tuubi, o acca jeenu makko. ");
INSERT INTO fue_vpl VALUES ("RV2_22","096_2_22","REV","2","22","22","Gam majjum mi faɗɗan mo dow banni toora, kanko e jeenidooɓe e makko, sey to ɓe tuubii ko ɓe gaɗi e makko. ");
INSERT INTO fue_vpl VALUES ("RV2_23","096_2_23","REV","2","23","23","Mi waran ɓiɓɓe makko. Eklesiyaaji fu annan min woni liinyoowo hakkillo e ɓerɗe. Mi yoɓan bo moy mooɗon fu ko waɗi. ");
INSERT INTO fue_vpl VALUES ("RV2_24","096_2_24","REV","2","24","24","Amma onon horiiɓe der Tiyatira, onon ɓe tokkay laawol ŋol, onon ɓe annaa ko woɓɓe wi'ata “asiiri Seyɗan lugguɗo”, mi yowantaa on dongal kuuŋal. ");
INSERT INTO fue_vpl VALUES ("RV2_25","096_2_25","REV","2","25","25","Amma, ko gooduɗon, jogee ɗum e semme faa mi wara. ");
INSERT INTO fue_vpl VALUES ("RV2_26","096_2_26","REV","2","26","26","Jaaliiɗo, gaɗuɗo golle am faa heennyitirde, mi hokkan ɗum baawɗe dow lenyi himɓe. ");
INSERT INTO fue_vpl VALUES ("RV2_27","096_2_27","REV","2","27","27","O duriran ɓe e sawru janni, o pusan ɓe hande no payanɗe loopeeje pusirtee. ");
INSERT INTO fue_vpl VALUES ("RV2_28","096_2_28","REV","2","28","28","Hande no min bo keɓirmi baawɗe diga Baaba am. Hande non min bo, mi hokkan mo hoodere fajiri. ");
INSERT INTO fue_vpl VALUES ("RV2_29","096_2_29","REV","2","29","29","Gooduɗo noppi, nana ko Ruuhu batata eklesiyaaji!» ");
INSERT INTO fue_vpl VALUES ("RV3_1","096_3_1","REV","3","1","1","«Winnan malaykaajo eklesiya Sardis, bi'aa: Nani ɗo haalaaji gooduɗo ruuhuuji Alla jeeɗiɗi, e koode jeeɗiɗi: Mii anni golle maa, aa wi'ee aa buuruɗo, amma a maayɗo. ");
INSERT INTO fue_vpl VALUES ("RV3_2","096_3_2","REV","3","2","2","Waɗu hakkillo, semmiɗin ko faani waatugo, gam mi tawii golle maa hebbay yeeso Alla am. ");
INSERT INTO fue_vpl VALUES ("RV3_3","096_3_3","REV","3","3","3","Gam majjum siwtor no keɓirɗaa, e no nanirɗaa haala Alla, joga ka, tuubu. To a reenaay, mi waran hande gujjo, a annataa bo wakkati de garanmi juhugo maa. ");
INSERT INTO fue_vpl VALUES ("RV3_4","096_3_4","REV","3","4","4","Amma, aa woodi der Sardis himɓe ɓe tuuninaay kolte mum. Ɓe ɓornoto kolte daneeje, ɓe jaada e am, gam ɓe potanii ɗum. ");
INSERT INTO fue_vpl VALUES ("RV3_5","096_3_5","REV","3","5","5","Hande non, jaaliiɗo fu ɓornoto kolte daneeji. Mi moytataa inne makko diga dewtere yonki pay. Mi seedoto yeeso Baaba am e yeeso malaykaaɓe mum, oo laatii mo am. ");
INSERT INTO fue_vpl VALUES ("RV3_6","096_3_6","REV","3","6","6","Gooduɗo noppi, nana ko Ruuhu batata eklesiyaaji!» ");
INSERT INTO fue_vpl VALUES ("RV3_7","096_3_7","REV","3","7","7","«Winnan malaykaajo eklesiya Filadelfiya, bi'aa: Nani ɗo haalaaji Ceniiɗo, Gooŋaajo, jogiiɗo maɓɓitirgel ŋel Dawda e junŋo mum. To o maɓɓitii goɗɗo maɓɓataa, to o maɓɓii bo, goɗɗo maɓɓitintaa. ");
INSERT INTO fue_vpl VALUES ("RV3_8","096_3_8","REV","3","8","8","Mii anni golle maa. Daaru, mi maɓɓitii dammugal yeeso maa ŋal goɗɗo waawataa ko maɓɓi. A woodaa baawɗe mawɗe, amma a jogake haala am, a yedday inne am. ");
INSERT INTO fue_vpl VALUES ("RV3_9","096_3_9","REV","3","9","9","Daaru, mi hokkete jama'aare sujidanooɓe Seyɗan, wi'ooɓe ko'e mum ɓee laatii Yahuduuɓe, amma fewre. Mi accan ɓe gara ɓe jiccoo ley koyɗe maa, den ɓe paaman mii yiɗu ma. ");
INSERT INTO fue_vpl VALUES ("RV3_10","096_3_10","REV","3","10","10","A jogake haala am, a munyii sanne. Gam majjum, min bo, mi reenete der wakkati ɓillaare garanoore duuniyaaru gam foonna himɓe. ");
INSERT INTO fue_vpl VALUES ("RV3_11","096_3_11","REV","3","11","11","Mi faanake warugo. Joga ko gooduɗaa e semme, gam to goɗɗo etta meetalol maa. ");
INSERT INTO fue_vpl VALUES ("RV3_12","096_3_12","REV","3","12","12","Jaaliiɗo fu, mi waɗan ɗum darŋanal der suudu Alla am, o wurtataako e mayru abada. Mi winnan dow makko inne Alla am, e inne wanŋarde Alla am, waato Urusaliima kesol, ƴiwoowol diga dow kammu, to Alla am. Mi winnan bo dow makko, inne am heyre. ");
INSERT INTO fue_vpl VALUES ("RV3_13","096_3_13","REV","3","13","13","Gooduɗo noppi, nana ko Ruuhu batata eklesiyaaji!» ");
INSERT INTO fue_vpl VALUES ("RV3_14","096_3_14","REV","3","14","14","«Winnan malaykaajo eklesiya Lawdikiya, bi'aa mo: Nani ɗo haalaaji bi'eteeɗo Aami, seedeejo koolaaɗo, e gooŋaajo, mo diga e mum Alla tagi huune fu. ");
INSERT INTO fue_vpl VALUES ("RV3_15","096_3_15","REV","3","15","15","Mii anni golle maa, a wulaa a feewaa. Laata buluɗo, ɗum bo peewuɗo! ");
INSERT INTO fue_vpl VALUES ("RV3_16","096_3_16","REV","3","16","16","Amma no aa woni caka caka, a wulaa a feewaa, mi tuutete diga hunnuko am. ");
INSERT INTO fue_vpl VALUES ("RV3_17","096_3_17","REV","3","17","17","Aa wi'a: ‟Mii laatii jom jawdiijo, mi hawritii jawdi, mi haajaaka goɗɗum”. A annaa a laati nun mo walaa goɗɗum, jurminiiɗo, talakaajo, bumɗo, e jahoowo funtu. ");
INSERT INTO fue_vpl VALUES ("RV3_18","096_3_18","REV","3","18","18","Ka batan maa mi nani: Soodu to am, kanŋeeri laaɓiniraani yiite, gam laatoɗaa jom jawdiijo. Soodu gineeji daneeji ɓornoɗaa, gam senteene funtu maa to yi'oo. Kade bo, soodu lekki gite mooma, gam ji'aa. ");
INSERT INTO fue_vpl VALUES ("RV3_19","096_3_19","REV","3","19","19","Himɓe ɓe jiɗumi, mi felan ɓe, mii fooɗa noppi maɓɓe. Gam majjum, tinna tuubaa! ");
INSERT INTO fue_vpl VALUES ("RV3_20","096_3_20","REV","3","20","20","Mi nani darii e dammugal, mii silmina. To goɗɗo nanii daane am go maɓɓiti dammugal, mi naatan wuro mum, mi nyaamda e mum, joomum bo nyaamdan e am. ");
INSERT INTO fue_vpl VALUES ("RV3_21","096_3_21","REV","3","21","21","Jaaliiɗo fu, mi jooɗinan ɗum dow kittaal Laamaare am, hande no jaaloriimi go jooɗodiimi e baaba am dow kittaal Laamaare mum. ");
INSERT INTO fue_vpl VALUES ("RV3_22","096_3_22","REV","3","22","22","Gooduɗo noppi, nana ko Ruuhu batata eklesiyaaji!» ");
INSERT INTO fue_vpl VALUES ("RV4_1","096_4_1","REV","4","1","1","Ɓaawo majjum, ji'umi dammugal gom e maɓɓitii dow kammu. Daane ne nanunoomi e baddammi arande, nandune e galalɗi puureteeɗi, wi'immi: «Eencu ɗo, mi hollee ko waroyta yeeso.» ");
INSERT INTO fue_vpl VALUES ("RV4_2","096_4_2","REV","4","2","2","Ɗon maa ɗon, kebbumi Ruuhu. Den ji'umi kittaal laamu dow kammu, goɗɗo e jooɗii dow maggal. ");
INSERT INTO fue_vpl VALUES ("RV4_3","096_4_3","REV","4","3","3","Jooɗiiɗo on e jalba hande hayre haakoore bi'eteene yaspa, e hayre woɗeere, wi'eteene sardis. Cincinga e fiiltitii kittaal ŋal, e jalba hande hayre wi'eteene emerooda. ");
INSERT INTO fue_vpl VALUES ("RV4_4","096_4_4","REV","4","4","4","Kittaaje laamu laso e naay e fiiltitii kittaal laamu ŋal. Dottiiɓe laso e nayo e jooɗii dow majje, ɓee ɓornii kolte daneeje, ɓee mellii meetali kanŋeeri. ");
INSERT INTO fue_vpl VALUES ("RV4_5","096_4_5","REV","4","5","5","Den maaƴƴe, e rimmo daaɗe towɗe, e diggaali, e wurtoo diga kittaal laamu ŋal. Fitillaaji jeeɗiɗi e huɓɓaa yeeso maggal, kanji woni ruuhuuji Alla jeeɗiɗi. ");
INSERT INTO fue_vpl VALUES ("RV4_6","096_4_6","REV","4","6","6","Huune ko nandi e maayo e woni yeeso kittaal ŋal, e nandi e daanorgal laaɓuŋal tar. Kujje yonkinteeje naay e woni caka kittaal ŋal, e fiiltitii ŋal. Eɗe goodi gite ɗuuɗɗe yeeso e ɓaawo fu. ");
INSERT INTO fue_vpl VALUES ("RV4_7","096_4_7","REV","4","7","7","Huune ɗum yonki ɗum, aranum mum e nandi e jaggere. Ɗiɗaɓum, e nandi nyaleel, tataɓum, e woodi yeeso hande ŋo neɗɗo. Nayaɓum bo, e nandi hande ciilal piiroowal. ");
INSERT INTO fue_vpl VALUES ("RV4_8","096_4_8","REV","4","8","8","Huune yonkintejum nayum ɗum, gootum mum fu e woodi biyeeɗe jeego'o. Biyeeɗe ɗen e woodi gite der e yaasi. Jemma e nyalooma fu, eɗum wi'a: «Ceniiɗo, Ceniiɗo, Ceniiɗo, non Joomiraawo Alla mo baawɗe fu laatii. O na'onno, o na'on jooni, oo wara!» ");
INSERT INTO fue_vpl VALUES ("RV4_9","096_4_9","REV","4","9","9","Huune yonkintejum ɗum, e teddina, e mana, e yetta jooɗiiɗo dow kittaal laamu, mo yonki faa abada. ");
INSERT INTO fue_vpl VALUES ("RV4_10","096_4_10","REV","4","10","10","De ɗum waɗata ɗum fu, dottiiɓe laso e nayo ɓen e jiccoo yeeso jooɗiiɗo dow kittaal laamu, ɓee cujidana yonkinteejo faa abada, ɓee paɗɗa meetali maɓɓe yeeso kittaal laamu, ɓee bi'a: ");
INSERT INTO fue_vpl VALUES ("RV4_11","096_4_11","REV","4","11","11","«An Joomiraawo Alla amen, a fotii heɓugo tedduŋal, e manŋu, e baawɗe, gam an tagi kujje fu, e sago maa ɗe laatorii, e sago maa ɗe tagiraa.» ");
INSERT INTO fue_vpl VALUES ("RV5_1","096_5_1","REV","5","1","1","Ɓaawo mum, ji'umi dewtere der junŋo nyaamo jooɗiiɗo dow kittaal laamu. Dewtere nen e winnaa becce ɗiɗi fu, ne maɓɓaa, ne waɗanaa maaneeji jeeɗiɗi. ");
INSERT INTO fue_vpl VALUES ("RV5_2","096_5_2","REV","5","2","2","Den ji'umi malaykaajo semmenteejo gom e bata e daane towne, e wi'a: «Moy nun foti takkitingo maaneeji ɗin, den maɓɓita dewtere nen?» ");
INSERT INTO fue_vpl VALUES ("RV5_3","096_5_3","REV","5","3","3","Baa gooto walaa dow kammu, e dow leydi e der leydi, baawoowo ko maɓɓiti ne, ɗum bo daarugo der mayre. ");
INSERT INTO fue_vpl VALUES ("RV5_4","096_5_4","REV","5","4","4","Den bullumi puy, gam goɗɗo heɓaaki potuɗo maɓɓita dewtere nen, naa bo daarugo ko woni der mayre. ");
INSERT INTO fue_vpl VALUES ("RV5_5","096_5_5","REV","5","5","5","Den gooto der dottiiɓe ɓen wi'immi: «Taa wullu! A yi'ii jaggere lenyol Yahuuda, ƴiwuɗo diga Dawda, o jaalake. O waawan ko takkiti maaneeji jeeɗiɗi ɗin, o maɓɓita dewtere nen.» ");
INSERT INTO fue_vpl VALUES ("RV5_6","096_5_6","REV","5","6","6","Den ji'umi Jawgiyel, eŋel nandi hande ŋel hiisaanoma. Jawgiyel ŋel e darii hakkune kittaal Laamaare, e huune nayum yonkintejum, e dottiiɓe. Eŋel woodi galalɗi jeeɗiɗi, e gite jeeɗiɗi, kanjum woni ruuhuuji Alla jeeɗiɗi, lilaaɗi der duuniyaaru fu. ");
INSERT INTO fue_vpl VALUES ("RV5_7","096_5_7","REV","5","7","7","Jawgiyel ŋel wari jaɓi dewtere nen diga e junŋo nyaamo jooɗiiɗo dow kittaal laamu. ");
INSERT INTO fue_vpl VALUES ("RV5_8","096_5_8","REV","5","8","8","No ŋel jaɓi ne, huune nayum yonkintejum, e dottiiɓe laso e nayo ɓen jiccii yeeso maggel. Moy maɓɓe fu e jogii moolooru, e jarirkon gaɗiraakon kanŋeeri, keewukon wardi. Kanjum laatii du'aaje himɓe Alla. ");
INSERT INTO fue_vpl VALUES ("RV5_9","096_5_9","REV","5","9","9","Ɓee jima jimol kesol, ɓee bi'a der maggol: «An foti etta dewtere nen, takkitaa maaneeji mayre Gam a hiisaanoma, a sooditanike Alla himɓe e ƴiiƴam maa, diga lenyol fu, e ɗenŋal fu, himɓe fu, e diga leydi fu. ");
INSERT INTO fue_vpl VALUES ("RV5_10","096_5_10","REV","5","10","10","A waɗii ɓe laamiiɓe, e Limaamiiɓe Alla, gam ɓe laamanoo duuniyaaru.» ");
INSERT INTO fue_vpl VALUES ("RV5_11","096_5_11","REV","5","11","11","Mii daara, ko nanumi daaɗe malaykaaɓe ɗuuɓɓe, uju ujuneeje. Ɓe piiltitii kittaal laamu, e huune yonkintejum, e dottiiɓe. ");
INSERT INTO fue_vpl VALUES ("RV5_12","096_5_12","REV","5","12","12","Ɓee bata e daaɗe towɗe ɓee bi'a: «Jawgiyel kiisanooŋel fotii heɓa baawɗe, e jawdi, e faamu, e semme, e manŋu, e tedduŋal, e maantooje!» ");
INSERT INTO fue_vpl VALUES ("RV5_13","096_5_13","REV","5","13","13","Den nanumi ko tagaa fu, gonuɗum dow kammu, e dow leydi, e der leydi, e der maayo, e ko woni der majjum fu, e wi'a: «Maantoore, e manŋu, e tedduŋal, e baawɗe woodani jooɗiiɗo dow kittaal laamu, e Jawgiyel, faa abada!» ");
INSERT INTO fue_vpl VALUES ("RV5_14","096_5_14","REV","5","14","14","Huune nayum yonkintejum ɗum, toontii, wi'i: «Aami!» Dottiiɓe ɓen bo jiccii, sujidi. ");
INSERT INTO fue_vpl VALUES ("RV6_1","096_6_1","REV","6","1","1","Wakkati daaranmi, ji'umi Jawgiyel takkiti maaneeji jeeɗiɗi ɗin woore mum. Den nanumi huune nayum yonkintejum ɗum, gootum mum e bata e daane towne hande riggaaŋo, e wi'a: «War!» ");
INSERT INTO fue_vpl VALUES ("RV6_2","096_6_2","REV","6","2","2","No daarumi, go ji'umi puccu danewol. Baɗɗiiɗo ŋol e jogii biroogal, o hokkaa meetalol, o yawti hande jaalotooɗo gam o jaaloo bo. ");
INSERT INTO fue_vpl VALUES ("RV6_3","096_6_3","REV","6","3","3","Jawgiyel takkiti maane ɗiɗawre, den nanumi huune yonkintejum ɗiɗaɓum e wi'a: «War!» ");
INSERT INTO fue_vpl VALUES ("RV6_4","096_6_4","REV","6","4","4","Den puccu gonŋol boɗewol wurtii. Baɗɗiiɗo ŋol hokkaa kaafahi mawki. O hokkaa bo baawɗe sottingo jam e duuniyaaru, gam himɓe warontira. ");
INSERT INTO fue_vpl VALUES ("RV6_5","096_6_5","REV","6","5","5","No Jawgiyel takkiti maane tatawre, den nanumi huune yonkintejum tataɓum e wi'a: «War!» Go ji'umi puccu ɓalewol. Baɗɗiiɗo ŋol e jogii etirgel kilo. ");
INSERT INTO fue_vpl VALUES ("RV6_6","096_6_6","REV","6","6","6","Den nanumi ko wa'i hande daane ƴiwi hakkune huune yonkintejum nayum. Daane nen e wi'a: «Etorde alkamaari woore, e etorɗe gawri tati, soodee ceede joddi golle nyalaane woore. Amma taa saɗin nebbam e innabojam.» ");
INSERT INTO fue_vpl VALUES ("RV6_7","096_6_7","REV","6","7","7","No Jawgiyel takkiti maane nayawre, den nanumi daane huune yonkintejum nayaɓum, e wi'a: «War!» ");
INSERT INTO fue_vpl VALUES ("RV6_8","096_6_8","REV","6","8","8","No daarumi, go ji'umi puccu haako haakowol. Baɗɗiiɗo ŋol e wi'ee Maayde, joonne maayɓe e tokki mo. Ɓe kokkaa baawɗe dow fecco duuniyaaru nayawre, gam ɓe bara himɓe e kaafahi, e rafo, e nyawuuji bonɗi, e bisaaji ladde. ");
INSERT INTO fue_vpl VALUES ("RV6_9","096_6_9","REV","6","9","9","No Jawgiyel takkiti maane jowawre, den ji'umi ley hiisirde, yonkiiji waraaɓe gam haala Alla, e gam seedaaku ŋu ɓe ceedanii mo. ");
INSERT INTO fue_vpl VALUES ("RV6_10","096_6_10","REV","6","10","10","Ɓee bata e daaɗe towɗe, ɓee bi'a: «Joomiraawo, ceniiɗo, gooŋaajo, faa dey keɗiɗaa ko kiitoɗaa himɓe wonɓe der duuniyaaru, ƴamaa ɓe ƴiiƴam amen?» ");
INSERT INTO fue_vpl VALUES ("RV6_11","096_6_11","REV","6","11","11","Moy maɓɓe fu hokkaa toggoore raneere. Ɓe bi'aa, ɓe ciwtoo taw seɗɗa faa to limgal banniraaɓe maɓɓe, gollodiiɓe e maɓɓe, wareteeɓe hande maɓɓe hebbii. ");
INSERT INTO fue_vpl VALUES ("RV6_12","096_6_12","REV","6","12","12","Den ji'umi Jawgiyel takkiti maane jeego'awre. Den leydi dimmii dimmaaɗe mawɗe, naaŋe ɓawli hande guda ɓaleya, lewru bo wojji hande ƴiiƴam. ");
INSERT INTO fue_vpl VALUES ("RV6_13","096_6_13","REV","6","13","13","Koode kammu yani e leydi hande no ɓiɓɓe ibbe kecce saamirta to hennu mawkol wifii. ");
INSERT INTO fue_vpl VALUES ("RV6_14","096_6_14","REV","6","14","14","Kammu majjiti, hande no daago taggirtee, baalle, e dunɗe fu eggi e nokkuuje mum. ");
INSERT INTO fue_vpl VALUES ("RV6_15","096_6_15","REV","6","15","15","Den laamiiɓe duuniyaaru, e himɓe tedduɓe, e hooreeɓe soogeeji, e jom jawdiiɓe, e wooduɓe baawɗe, e maccuɓe, e rimɓe fu suuɗii der lowi kaaƴe, e hakkune baalle. ");
INSERT INTO fue_vpl VALUES ("RV6_16","096_6_16","REV","6","16","16","Ɓe darii ɓee bi'a baalle e kaaƴe: «Janee dow amen! Cuuɗee men e yeeso jooɗiiɗo dow kittaal laamu e mone Jawgiyel! ");
INSERT INTO fue_vpl VALUES ("RV6_17","096_6_17","REV","6","17","17","Gam nyalaane mawne ne mone maɓɓe yottake, moy daɗata?» ");
INSERT INTO fue_vpl VALUES ("RV7_1","096_7_1","REV","7","1","1","Ɓaawo majjum, ji'umi malaykaaɓe nayo e darii to gooraaje duuniyaaru naay. Ɓee kaɗa keni duuniyaaru naay wifugo dow leydi, e dow maayo, e dow leɗɗe. ");
INSERT INTO fue_vpl VALUES ("RV7_2","096_7_2","REV","7","2","2","Ji'umi kade malaykaajo goɗɗo ƴiwoy diga lettugal, e jogii maanorɗum Alla yonkinteejo. O baddi malaykaaɓe nayo e daane towne, hokkaaɓe baawɗe waɗango leydi, e maayo ko halli. ");
INSERT INTO fue_vpl VALUES ("RV7_3","096_7_3","REV","7","3","3","O wi'i ɓe: «To on gaɗanee taw leydi, e maayo, e leɗɗe ko halli, faa to en gaɗanii maccuɓe Alla meeɗen maane dow tiiɗe.» ");
INSERT INTO fue_vpl VALUES ("RV7_4","096_7_4","REV","7","4","4","Den nanumi limgal waɗanaaɓe maane dow tiiɗe mum: Ɓe gaɗii himɓe ujune hemure e lasoy ɗiɗo e nayo (144 000) ƴiwuɓe diga lenyi Isira'iilaaɓe fu. ");
INSERT INTO fue_vpl VALUES ("RV7_5","096_7_5","REV","7","5","5","Ƴiwuɓe e lenyol Yahuuda, ujune sappo e ɗiɗo (12 000). Ƴiwuɓe e lenyol Ruben, ujune sappo e ɗiɗo (12 000). Ƴiwuɓe e lenyol Gada, ujune sappo e ɗiɗo (12 000). ");
INSERT INTO fue_vpl VALUES ("RV7_6","096_7_6","REV","7","6","6","Ƴiwuɓe e lenyol Aser, ujune sappo e ɗiɗo (12 000). Ƴiwuɓe e lenyol Neftali, ujune sappo e ɗiɗo (12 000). Ƴiwuɓe e lenyol Manaasa, ujune sappo e ɗiɗo (12 000). ");
INSERT INTO fue_vpl VALUES ("RV7_7","096_7_7","REV","7","7","7","Ƴiwuɓe e lenyol Simeyon, ujune sappo e ɗiɗo (12 000). Ƴiwuɓe e lenyol Leewi, ujune sappo e ɗiɗo (12 000). Ƴiwuɓe e lenyol Isakar, ujune sappo e ɗiɗo (12 000). ");
INSERT INTO fue_vpl VALUES ("RV7_8","096_7_8","REV","7","8","8","Ƴiwuɓe e lenyol Jabulon, ujune sappo e ɗiɗo (12 000). Ƴiwuɓe e lenyol Yusufu, ujune sappo e ɗiɗo (12 000). Ƴiwuɓe e lenyol Benyamin bo, ujune sappo e ɗiɗo (12 000). Cuuɗi baaba ɗii fu waɗanaama maane. ");
INSERT INTO fue_vpl VALUES ("RV7_9","096_7_9","REV","7","9","9","Ɓaawo mum daarumi, go ji'umi jama'aare ɗuunne, ne limataako. Ɓe ƴiwii diga e leyɗe fu, e lenyi fu, e himɓe fu, e ɗelle fu. Ɓee darii yeeso kittaal laamu, e yeeso Jawgiyel. Ɓee ɓornii toggooje daneeje, ɓee jogii licce papaaje e juuɗe maɓɓe. ");
INSERT INTO fue_vpl VALUES ("RV7_10","096_7_10","REV","7","10","10","Ɓee bata e daaɗe towɗe ɓee bi'a: «Kisidam men ƴiwii diga e Alla meeɗen, jooɗiiɗo dow kittaal laamu, kanko e Jawgiyel.» ");
INSERT INTO fue_vpl VALUES ("RV7_11","096_7_11","REV","7","11","11","Malaykaaɓe fu e fiiltitii kittaal laamu, e dottiiɓe, e huune yonkintejum nayum. Ɓe jiccii yeeso kittaal laamu, ɓe cujidani Alla. ");
INSERT INTO fue_vpl VALUES ("RV7_12","096_7_12","REV","7","12","12","Ɓee bi'a: «Aami! Maantoore, e tedduŋal, e faamu, e jettooje, e manŋu, e baawɗe, e semme woodani Alla meeɗen faa abada!» ");
INSERT INTO fue_vpl VALUES ("RV7_13","096_7_13","REV","7","13","13","Den gooto der dottiiɓe ƴamimmi wi'i: «Ɓeey nun himɓe ɓorniiɓe toggooje daneeje? Toy ɓe ƴiwi?» ");
INSERT INTO fue_vpl VALUES ("RV7_14","096_7_14","REV","7","14","14","Toonti moo mi: «Joomiraawo am, an nun anni.» Go o wi'immi: «Kamɓe woni ƴiwoyɓe diga toora mawka. Ɓe loonnii toggooje maɓɓe, ɓe dawnini ɗe e ƴiiƴam Jawgiyel. ");
INSERT INTO fue_vpl VALUES ("RV7_15","096_7_15","REV","7","15","15","Gam majjum ɓe gonii yeeso kittaal laamu Alla. Ɓee cujidana mo jemma e nyalooma der suudu Alla makko ceniinu. Jooɗiiɗo dow kittaal laamu reenan ɓe. ");
INSERT INTO fue_vpl VALUES ("RV7_16","096_7_16","REV","7","16","16","Ɓe dafataake, ɓe ɗonɗataake, naaŋe fiyataa ɓe, guli bo waɗataa ɓe. ");
INSERT INTO fue_vpl VALUES ("RV7_17","096_7_17","REV","7","17","17","Gam Jawgiyel gonuŋel caka kittaal laamu duran ɓe. Ŋel yaaran ɓe to ciiɓiije diyam kokkoojam yonki. Alla moytan gonɗi gite maɓɓe fu.» ");
INSERT INTO fue_vpl VALUES ("RV8_1","096_8_1","REV","8","1","1","No Jawgiyel takkiti maane jeeɗiɗawre, jam waɗi dow kammu faa jaka feccere janni. ");
INSERT INTO fue_vpl VALUES ("RV8_2","096_8_2","REV","8","2","2","Den ji'umi malaykaaɓe jeeɗiɗo dariiɓe yeeso Alla, ɓe kokkaa galalɗi jeeɗiɗi puureteeɗi. ");
INSERT INTO fue_vpl VALUES ("RV8_3","096_8_3","REV","8","3","3","Malaykaajo goɗɗo wari darii ley hiisirde. Oo jogii heeɗo urirgo, ŋo kanŋeeri. O hokkaa wardi ɗuuɗɗo, o ura, kanjum e du'aaje himɓe Alla, o yottina ɗum dow hiisirde ne kanŋeeri, gonune yeeso kittaal laamu. ");
INSERT INTO fue_vpl VALUES ("RV8_4","096_8_4","REV","8","4","4","Curki wardi on eencidi e du'aaje himɓe Alla diga e junŋo malaykaajo dariiɗo yeeso Alla. ");
INSERT INTO fue_vpl VALUES ("RV8_5","096_8_5","REV","8","5","5","Malaykaajo on etti heeɗo urirgo, hebbini ŋo yiite hiisirde, faɗɗi ŋo e leydi. Den riggaaŋo e rimmo waɗi, maaƴƴe maaƴƴi, leydi dimmii. ");
INSERT INTO fue_vpl VALUES ("RV8_6","096_8_6","REV","8","6","6","Ɓaawo majjum, malaykaaɓe jeeɗiɗo jogiiɓe galalɗi jeeɗiɗi puureteeɗi, siryii fuurugo ɗi. ");
INSERT INTO fue_vpl VALUES ("RV8_7","096_8_7","REV","8","7","7","Malaykaajo arano fuuri walaldu mum, den malamalluuje, e yiite jillontirŋe e ƴiiƴam faɗɗaa e leydi. Feccere leydi tatawre wulaa, den feccere leɗɗe tatawre bo wulaa, non bo, fuɗo hecco fu wulaa. ");
INSERT INTO fue_vpl VALUES ("RV8_8","096_8_8","REV","8","8","8","Malaykaajo ɗiɗaɓo fuuri walaldu mum. Den huune nandune e waanne huɓɓoore yiite faɗɗaa der maayo. Feccere maayo tatawre waylitii ƴiiƴam. ");
INSERT INTO fue_vpl VALUES ("RV8_9","096_8_9","REV","8","9","9","Feccere tatawre der huune yonkintejum, gonuɗum der maayo waati. Feccere tatawre der laanaaje diyam bo halki. ");
INSERT INTO fue_vpl VALUES ("RV8_10","096_8_10","REV","8","10","10","Malaykaajo tataɓo fuuri walaldu mum. Den hoodere mawne, huɓɓoore yiite hande doccal ƴiwoy diga dow kammu, yani dow feccere gooruuji tatawre, e ciiɓiije diyam. ");
INSERT INTO fue_vpl VALUES ("RV8_11","096_8_11","REV","8","11","11","Inne hoodere nen e wi'ee «Kaaɗuɗum.» Ne haaɗini feccere diyam tatawre, himɓe ɗuuɓɓe maayi gam haaɗugo diyam ɗam. ");
INSERT INTO fue_vpl VALUES ("RV8_12","096_8_12","REV","8","12","12","Malaykaajo nayaɓo fuuri walaldu mum. Den feccere naaŋe, e lewru, e koode tatawre fiyaa. No ɗum fiyaa, go feccere majjum tatawre niɓɓi, jemma e nyalooma bo majjini feccere jayŋol mum tatawre. ");
INSERT INTO fue_vpl VALUES ("RV8_13","096_8_13","REV","8","13","13","Ɓaawo mum, ji'umi ciilal e fiira dow kammu. Den nanumi eŋal bata e daane towne, eŋal wi'a: «Kayto! Kayto! Bone woodani himɓe duuniyaaru to malaykaaɓe tato horiiɓe fuurii galalɗi mum!» ");
INSERT INTO fue_vpl VALUES ("RV9_1","096_9_1","REV","9","1","1","Malaykaajo joyaɓo fuuri walaldu mum. Den ji'umi hoodere ƴiwi dow kammu yani e leydi. Ne hokkaa maɓɓitirgel ɓunnu lugguŋol ŋol walaa kaddi. ");
INSERT INTO fue_vpl VALUES ("RV9_2","096_9_2","REV","9","2","2","No ne maɓɓiti ŋol, go curki tekkuki wurti e maggol. Curki kin e nandi hande curki ƴiwuki e suudu yiite, ki niɓɓini naaŋe e hennu. ");
INSERT INTO fue_vpl VALUES ("RV9_3","096_9_3","REV","9","3","3","Den baɓatti wurti e curki kin, sankitii e leydi, ɗi kokkaa baawɗe hande jahe. ");
INSERT INTO fue_vpl VALUES ("RV9_4","096_9_4","REV","9","4","4","Ɗi bi'aa to ɗi meemu fuɗo, e huune ko fuɗata dow leydi, e leɗɗe, amma himɓe ɓe maane Alla walaa dow tiiɗe mum. ");
INSERT INTO fue_vpl VALUES ("RV9_5","096_9_5","REV","9","5","5","Ɗi kokkaaka laawol ɗi bara himɓe, amma, ɗi toora ɓe faa lebbi joyi. Naawella majji e nandi hande naawalla yaare to fiɗii neɗɗo. ");
INSERT INTO fue_vpl VALUES ("RV9_6","096_9_6","REV","9","6","6","Wakkati mum, himɓe dartan maayde, amma ɓe keɓataa ne. Ɓe jiɗan maayde, amma ne doggan ɓe. ");
INSERT INTO fue_vpl VALUES ("RV9_7","096_9_7","REV","9","7","7","Baɓatti ɗin e nandi e pucci ciriyaniiɗi konu. Huune ko nandi e meetali gaɗiraaɗi kanŋeeri e woni dow ko'e majji. Geese majji e nandi e geese himɓe. ");
INSERT INTO fue_vpl VALUES ("RV9_8","096_9_8","REV","9","8","8","Gaasa majji e nandi e gaasa rewɓe, nyiiƴe majji e wa'i hande nyiiƴe jagge. ");
INSERT INTO fue_vpl VALUES ("RV9_9","096_9_9","REV","9","9","9","Gabaaje majji e wa'i hande taɓɓorɗum kure. Rimmo biyeeɗe majji e wa'i hande rimmo laanaaji ɗi pucci ɗuuɗɗi, ciriyaniiɗi konu fooɗata. ");
INSERT INTO fue_vpl VALUES ("RV9_10","096_9_10","REV","9","10","10","Ɗii goodi ɓokkorɗi e kure hande jahe. Der ɓokkorɗi majji, baawɗe toorugo himɓe faa lebbi joy woni. ");
INSERT INTO fue_vpl VALUES ("RV9_11","096_9_11","REV","9","11","11","Malaykaajo ɓunnu lugguŋol kaddi walaa, laatii laamiiɗo majji. Inne makko e Iburaninkeere woni, Abaddon, e Yunaninkeere bo, Apolliyon. ");
INSERT INTO fue_vpl VALUES ("RV9_12","096_9_12","REV","9","12","12","Bone arandeere yawtii. Daa, boneeji ɗiɗi e wara kade. ");
INSERT INTO fue_vpl VALUES ("RV9_13","096_9_13","REV","9","13","13","Malaykaajo jeego'aɓo fuuri walaldu mum. Den nanumi daane ƴiwii to galalɗi hiisirde naay ne kanŋeeri, gonune yeeso Alla. ");
INSERT INTO fue_vpl VALUES ("RV9_14","096_9_14","REV","9","14","14","Daane nen wi'i malaykaajo jeego'aɓo jogiiɗo walaldu puureteeŋol: «Fiirtu malaykaaɓe nayo haɓɓaaɓe to maayo manŋo, wi'eteeŋo Efaratis.» ");
INSERT INTO fue_vpl VALUES ("RV9_15","096_9_15","REV","9","15","15","Malaykaaɓe nayo ɓen firtaa. Ɓe ciriyake gam duuɓol, e lewru, e nyalaane, e wakkati, de ɓe barata feccere himɓe tatawre. ");
INSERT INTO fue_vpl VALUES ("RV9_16","096_9_16","REV","9","16","16","Mi nanii limgal soogeeji baɗɗiiɗi pucci: ɓe gaɗii himɓe miliyo keme ɗiɗo (200. 000.000). ");
INSERT INTO fue_vpl VALUES ("RV9_17","096_9_17","REV","9","17","17","Nani ɗo no ji'irmi pucci e waɗɗiiɓe ɗi der jiiki am. Waɗɗiiɓe pucci ɗin, e ɓornii taɓɓorɗum kure boɗejum hande yiite, e bula bulajum, e nareerijum hande bu'e naaŋe. Ko'e pucci ɗin e nandi hande ko'e jagge. Yiite, e curki, e bu'e naaŋe e wurtoo diga kunnuɗe majji. ");
INSERT INTO fue_vpl VALUES ("RV9_18","096_9_18","REV","9","18","18","Boneeji tati ɗin, waato yiite e curki, e ko nandi e bu'e naaŋe wurtii e kunnuɗe pucci, wari feccere himɓe tatawre. ");
INSERT INTO fue_vpl VALUES ("RV9_19","096_9_19","REV","9","19","19","Gam baawɗe, e semme pucci ɗin tawaaka maa to kunnuɗe e ɓokkorɗi majji. Ɓokkorɗi ɗin e nandi e bolle, ɗii goodii ko'e, kanje ɗi gaɗiranta himɓe ko halli. ");
INSERT INTO fue_vpl VALUES ("RV9_20","096_9_20","REV","9","20","20","Horiiɓe, ɓe boneeji ɗin waray, tuubay ko ɓe gaɗi, ɓe accay saafugo ginnaaji, e tooruuje gaɗiraaɗe kanŋeeri, e cardi, e janni boɗeeri, e kaaƴe, e leɗɗe. Tooruuje ɗen yi'ataa, ɗe nanataa, ɗe jahataa. ");
INSERT INTO fue_vpl VALUES ("RV9_21","096_9_21","REV","9","21","21","Ɓe tuubay ɓe acca warugo himɓe e saafugo ginnaaji, e jeenu, e guyka. ");
INSERT INTO fue_vpl VALUES ("RV10_1","096_10_1","REV","10","1","1","Ɓaawo majjum, ji'umi malaykaajo semmenteejo gom kade. Oo jippoo diga dow kammu. Oo ɓornii duulere, cincinga e fiiltitii hoore makko. Yeeso makko e jalba hande naaŋe, asaale makko e wa'i hande moosi yiite. ");
INSERT INTO fue_vpl VALUES ("RV10_2","096_10_2","REV","10","2","2","Oo jogii dewtel maɓɓitiiŋel. O darini koyŋal makko nyaamowal dow maayo, nanowal bo dow leydi. ");
INSERT INTO fue_vpl VALUES ("RV10_3","096_10_3","REV","10","3","3","O bati e daane towne hande no jaggere halɓirta. No o bati e daane towne, den palmaali jeeɗiɗi nanaa. ");
INSERT INTO fue_vpl VALUES ("RV10_4","096_10_4","REV","10","4","4","No palmaali jeeɗiɗi ɗin batidi, ko ciriyiimi mi winna. Amma nanumi daane gom ƴiwi diga dow kammu, wi'immi: «Suuɗu ko palmaali jeeɗiɗi ɗin wi'i, taa winnu ka!» ");
INSERT INTO fue_vpl VALUES ("RV10_5","096_10_5","REV","10","5","5","Den malaykaajo mo ji'unoomi e darii dow maayo e dow leydi on, ɓanti junŋo mum nyaamo faa dow. ");
INSERT INTO fue_vpl VALUES ("RV10_6","096_10_6","REV","10","6","6","O hunorii inne Alla, tabitiiɗo faa abada, taguɗo kammu e ko woni der mum, taguɗo leydi e ko woni der mayri, taguɗo maayo e ko woni der maggo. O wi'i: «Ɗum ɓooyataa kade! ");
INSERT INTO fue_vpl VALUES ("RV10_7","096_10_7","REV","10","7","7","Amma nyaanne malaykaajo jeeɗiɗaɓo fuurata walaldu mum, Alla hebbinan asiiri mum. Ɗum laatoto hande no o batirnoo annabiiɓe gollantooɓe mo habaru belɗo.» ");
INSERT INTO fue_vpl VALUES ("RV10_8","096_10_8","REV","10","8","8","Den daane ne nanunoomi, ƴiwoyne diga dow kammu, wi'immi kade: «Yahu ettu dewtel maɓɓitiiŋel, gonuŋel der junŋo malaykaajo dariiɗo dow maayo e dow leydi.» ");
INSERT INTO fue_vpl VALUES ("RV10_9","096_10_9","REV","10","9","9","Jahumi to malaykaajo on, bi'u moo mi, o hokkammi dewtel ŋel. O wi'immi: «Ettu ŋel, moɗaa! Ŋel welan der hunnuko maa hande juuri, amma ŋel haaɗan der reedu maa.» ");
INSERT INTO fue_vpl VALUES ("RV10_10","096_10_10","REV","10","10","10","Jaɓumi dewtel ŋel e junŋo malaykaajo, ƴakkumi ŋel. Ŋel weli der hunnuko am hande juuri, amma no moɗumi ŋel, ŋel haaɗi der reedu am! ");
INSERT INTO fue_vpl VALUES ("RV10_11","096_10_11","REV","10","11","11","Ɓaawo majjum, bi'aami: «Sey bataa kade ko Alla hollitin maa dow himɓe ɗuuɓɓe, e lenyi ɗuuɗɗi, e ɗelle ɗuuɗɗe, e laamiiɓe ɗuuɓɓe.» ");
INSERT INTO fue_vpl VALUES ("RV11_1","096_11_1","REV","11","1","1","Den kokkaami ƴommal nanduŋal e sawru poonnirkol. O wi'immi: «Umma, foonnu suudu Alla e hiisirde. Limu sujidooɓe wonuɓe der maggol. ");
INSERT INTO fue_vpl VALUES ("RV11_2","096_11_2","REV","11","2","2","Amma accu fageere suudu Alla yaasiire, taa foonnu ne, gam ɓe lenyi janani nun hokkaa ne. Ɓe jaaɓan wanŋarde seniine faa lebbi lasoy ɗiɗi e ɗiɗi. ");
INSERT INTO fue_vpl VALUES ("RV11_3","096_11_3","REV","11","3","3","Mi hokkan seedeeɓe am ɗiɗo baawɗe waɗugo annabaaku faa balɗe ujuneere e keme ɗiɗi e lasoy tati, (1260) ɓee ɓornorii saakiiji.» ");
INSERT INTO fue_vpl VALUES ("RV11_4","096_11_4","REV","11","4","4","Seedeeɓe ɗiɗo ɓen woni leɗɗe jaytuuje ɗiɗi, e fitillaaji ɗiɗi, dariiɗi yeeso Joomiraawo duuniyaaru. ");
INSERT INTO fue_vpl VALUES ("RV11_5","096_11_5","REV","11","5","5","Jiɗɗo waɗugo ko halli fu, yiite wurtoto diga kunnuɗe maɓɓe, halka wayɓe maɓɓe. Nun nun haani jiɗɗo waɗango ɓe ko halli fu, wariree. ");
INSERT INTO fue_vpl VALUES ("RV11_6","096_11_6","REV","11","6","6","Ɓee goodi baawɗe maɓɓugo kammu gam to diyam toɓu der balɗe ɗe ɓe baajotoo haala Alla. Ɓee goodi bo baawɗe waylitingo diyeele laatoo ƴiiƴam. Ɓe baawan bo ko jippini boneeji feere feere de ɓe jiɗi fu, e duuniyaaru ɗo. ");
INSERT INTO fue_vpl VALUES ("RV11_7","096_11_7","REV","11","7","7","To ɓe gaynii seedaaku maɓɓe, tewuwa gom wurtoto diga gayka lugguka, haɓa e maɓɓe, jaaloo ɓe, wara ɓe. ");
INSERT INTO fue_vpl VALUES ("RV11_8","096_11_8","REV","11","8","8","Ɓalli maɓɓe wonoto der fageere wanŋarde mawne. Ton nun Joomiraawo maɓɓe tigganoo dow leggal palaaŋal. Wanŋarde nen nanditiniraamaa Sodoma e Misira. ");
INSERT INTO fue_vpl VALUES ("RV11_9","096_11_9","REV","11","9","9","Himɓe ƴiwoyɓe diga duuniyaaru fu, e lenyi fu, e ɗelle fu, e leyɗe fu, yi'an ɓalli maɓɓe, jaka balɗe tati e feccere. Ɓe nootataako ɓalli maɓɓe uwee. ");
INSERT INTO fue_vpl VALUES ("RV11_10","096_11_10","REV","11","10","10","Wonuɓe der duuniyaaru seyoto gam maayde maɓɓe. Ɓe gaɗan juulɗe, ɓe kokkontira dokke gam annabiiɓe ɗiɗo ɓen tooriino ɓe puy. ");
INSERT INTO fue_vpl VALUES ("RV11_11","096_11_11","REV","11","11","11","Amma ɓaawo balɗe tati e feccere ɗen, foofaaŋo yonki ƴiwuŋo to Alla, naati e maɓɓe. Ɓe pinti, ɓe ummii ɓe darii, go yi'uɓe ɓe fu, kulol manŋol nanŋi ɗum. ");
INSERT INTO fue_vpl VALUES ("RV11_12","096_11_12","REV","11","12","12","Den daane towne ƴiwi dow kammu, e wi'a annabiiɓe ɗiɗo ɓen: «Eencee ɗo!» Ɓe eenci dow kammu, der duule, wayɓe maɓɓe e daara ɓe. ");
INSERT INTO fue_vpl VALUES ("RV11_13","096_11_13","REV","11","13","13","Wakkati mum, leydi dimmii e semme, go feccere wanŋarde sappo'awre mum halki. Dimmaaɗe leydi ɗen wari himɓe ujune jeeɗiɗo (7000). Den horiiɓe huli, hokki Alla mo dow kammu tedduŋal. ");
INSERT INTO fue_vpl VALUES ("RV11_14","096_11_14","REV","11","14","14","Bone ɗiɗawre yawti, amma ɓooyataa ko bone tatawre wara. ");
INSERT INTO fue_vpl VALUES ("RV11_15","096_11_15","REV","11","15","15","Malaykaajo jeeɗiɗaɓo fuuri walaldu mum. Den daaɗe towɗe nanaa dow kammu, e wi'a: «Baawɗe laamanaago duuniyaaru fu laatanike Joomiraawo meeɗen e Almasiihu mum. O laamoto faa abada!» ");
INSERT INTO fue_vpl VALUES ("RV11_16","096_11_16","REV","11","16","16","Dottiiɓe laso e nayo jooɗiiɓe dow kittaaje yeeso Alla jiccii, sujidani Alla, ");
INSERT INTO fue_vpl VALUES ("RV11_17","096_11_17","REV","11","17","17","ɓee bi'a: «Joomiraawo Alla, mo baawɗe, An gonuɗo naane, e jooni, men jettii maa, gam a gollirii baawɗe maa mawɗe, a tabbitinii laamu maa. ");
INSERT INTO fue_vpl VALUES ("RV11_18","096_11_18","REV","11","18","18","Mone waɗii heeferɓe, amma mone maa wari. Wakkati kiitotoɗaa maayɓe waɗii, wakkati de barjotoɗaa annabiiɓe maa, gollanooɓe maa, waɗii, wakkati de barjotoɗaa himɓe maa, hulɓe inne maa waɗii, mawɓe e petton fu, wakkati bo waɗii de kalkataa halkooɓe leydi.» ");
INSERT INTO fue_vpl VALUES ("RV11_19","096_11_19","REV","11","19","19","Suudu Alla maɓɓitaa dow kammu, pakoroowal alkawal yi'aa der mayru. Den maaƴƴe maaƴƴi, rimmo waɗi, palmaali falmi, leydi dimmii, malamalluuje mawɗe toɓi. ");
INSERT INTO fue_vpl VALUES ("RV12_1","096_12_1","REV","12","1","1","Maane mawne gom hollitii dow kammu. Debbo gom e ɓornii naaŋe, lewru e woni ley koyɗe makko, oo mellii meetalol ŋol koode sappo e ɗiɗi dow hoore makko. ");
INSERT INTO fue_vpl VALUES ("RV12_2","096_12_2","REV","12","2","2","Oo woodi reedu, go oo halɓa sabbu toora, e naawalla ŋatawre. ");
INSERT INTO fue_vpl VALUES ("RV12_3","096_12_3","REV","12","3","3","Maane gom kade hollitii dow kammu, go kuuŋa gom boɗeya, manŋa, hollitii. Ŋaa woodi ko'e jeeɗiɗi e galalɗi sappo, hoore fu e woodi meetalol laamu. ");
INSERT INTO fue_vpl VALUES ("RV12_4","096_12_4","REV","12","4","4","Ɓokkordu magga e fooɗa feccere koode kammu tatawre, e faɗɗa ɗe e leydi. Ŋa darii yeeso debbo paaniiɗo rimugo on, gam ŋa moɗa ɓiyiiko to o rimii. ");
INSERT INTO fue_vpl VALUES ("RV12_5","096_12_5","REV","12","5","5","Den o rimi ɓiɗɗo gorko. Kanko woni duroowo ɓe lenyi janani fu e sawru janni. Den suka on yawtinaa faa to Alla, e kittaal laamu mum. ");
INSERT INTO fue_vpl VALUES ("RV12_6","096_12_6","REV","12","6","6","Debbo on doggi yahi der ladde, nokkuure to Alla moƴƴinannoo mo. Ton o nyaannetee faa balɗe ujuneere e keme ɗiɗi e lasoy tati (1260). ");
INSERT INTO fue_vpl VALUES ("RV12_7","096_12_7","REV","12","7","7","Go konu ummii dow kammu. Malaykaajo bi'eteeɗo Mika'iilu, e malaykaaɓe mum, haɓidi e kuuŋa ŋan, kanŋa bo, ŋa haɓidi ɓe, e malaykaaɓe magga. ");
INSERT INTO fue_vpl VALUES ("RV12_8","096_12_8","REV","12","8","8","Amma kuuŋa ŋan waaway jaalaago, kanŋa e malaykaaɓe magga fu, ɓe dulli jayri maɓɓe dow kammu. ");
INSERT INTO fue_vpl VALUES ("RV12_9","096_12_9","REV","12","9","9","Kuuŋa manŋa ŋan wurtinaama yaasi. Kanŋa woni boddi nayeeri, bi'eteeni Ibiliisa e Seyɗan, jarbotooɗo duuniyaaru fu. O faɗɗaama e leydi, e malaykaaɓe makko fu. ");
INSERT INTO fue_vpl VALUES ("RV12_10","096_12_10","REV","12","10","10","Den nanumi daane towne diga dow kammu, e wi'a: «Jooni, kisidam, e semme, e Laamaare Alla meeɗen, e baawɗe Almasiihu makko warii. Gam gaccotooɗo banniraaɓe meeɗen, to Alla jemma e nyalooma fu riiwaama diga dow kammu. ");
INSERT INTO fue_vpl VALUES ("RV12_11","096_12_11","REV","12","11","11","Amma, ɓe jaalake mo gam daliila ƴiiƴam Jawgiyel e gam haala seedaaku maɓɓe. Ɓe jiɗay yonki maɓɓe faa ɓe kula maayugo. ");
INSERT INTO fue_vpl VALUES ("RV12_12","096_12_12","REV","12","12","12","Gam majjum, kammu e jooɗiiɓe der mum, belbeltee! Amma leydi e maayo, bone woodani on! Gam Seyɗan jippanake on e mone mawne, gam oo anni wakkati seɗɗa horanii mo.» ");
INSERT INTO fue_vpl VALUES ("RV12_13","096_12_13","REV","12","13","13","No kuuŋa ŋan yi'i faɗɗaama e leydi, ŋa yanti toorugo debbo dimuɗo ɓiɗɗo gorko on. ");
INSERT INTO fue_vpl VALUES ("RV12_14","096_12_14","REV","12","14","14","Den debbo on hokkaa biyeeɗe dulowwa manŋa, gam o fiira, o yaha der ladde, to nokkuure ne o moƴƴinanaa, gam o woɗɗodoo e boddi nin. Ton nun o nyaannetee faa jaka duuɓi tati e feccere. ");
INSERT INTO fue_vpl VALUES ("RV12_15","096_12_15","REV","12","15","15","Go boddi nin tuuti diyam, eɗam ila ɓaawo debbo on hande maayo, gam ɗam ilina mo. ");
INSERT INTO fue_vpl VALUES ("RV12_16","096_12_16","REV","12","16","16","Amma, leydi faabii debbo on, ni omtii, ni yari diyam ɗam kuuŋa ŋan tuuti. ");
INSERT INTO fue_vpl VALUES ("RV12_17","096_12_17","REV","12","17","17","Kuuŋa ŋan monnii debbo on sanne, yahi haɓoygo horiiɓe der lenyol makko, waato ɗowtaniiɓe ka Alla bati ko e seedanoo Yeesu. ");
INSERT INTO fue_vpl VALUES ("RV12_18","096_12_18","REV","12","18","18","Den kuuŋa ŋan darii dow jaaneeri fonŋo maayo. ");
INSERT INTO fue_vpl VALUES ("RV13_1","096_13_1","REV","13","1","1","Ɓaawo majjum, ji'umi bisaa gom e wurtoo der maayo, ŋaa woodi galalɗi sappo, e ko'e jeeɗiɗi. Hoore fu e woodi meetalol laamu. Inɗe jennooje Alla e winnaa dow ko'e ɗee fu. ");
INSERT INTO fue_vpl VALUES ("RV13_2","096_13_2","REV","13","2","2","Bisaa ŋa ji'umi e nandi e muusuuru. Koyɗe magga e wa'i hande koyɗe dawaaŋel. Hunnuko magga e wa'i hande hunnuko jaggere. Kuuŋa ŋan hokki bisaa ŋan baawɗe mum, e kittaal mum, e baawɗe mawɗe. ");
INSERT INTO fue_vpl VALUES ("RV13_3","096_13_3","REV","13","3","3","Ko'e bisaa ŋan woore mum, e nandi hande ko nawnano faa waati. Amma jooni nawnande magga hoynii. Go himɓe duuniyaaru fu haayɗinii, e tokki ŋa. ");
INSERT INTO fue_vpl VALUES ("RV13_4","096_13_4","REV","13","4","4","Ɓe cujidani kuuŋa ŋan, gam ŋa hokkii bisaa baawɗe magga. Den, ɓe cujidani bo bisaa, ɓe bi'i: «Moy nandi e bisaa? Moy waawi ko haɓidi e magga?» ");
INSERT INTO fue_vpl VALUES ("RV13_5","096_13_5","REV","13","5","5","Bisaa ŋan hokkaa hunnuko bata haalaaji mawnitaare, bata kalluka dow Alla. Ŋa hokkaa bo laawol gollirgo baawɗe magga faa lebbi lasoy ɗiɗi e ɗiɗi. ");
INSERT INTO fue_vpl VALUES ("RV13_6","096_13_6","REV","13","6","6","Ŋa fuɗɗi batugo kalluka dow Alla, e inne mum, e nokkuure to o woni, non bo, e woniiɓe dow kammu. ");
INSERT INTO fue_vpl VALUES ("RV13_7","096_13_7","REV","13","7","7","Ŋa hokkaa baawɗe haɓugo e himɓe Alla, ŋa jaaloo ɓe. Ŋa hokkaa baawɗe laamanaago lenyi fu, e himɓe fu, e ɗenɗe fu, e leydiije fu. ");
INSERT INTO fue_vpl VALUES ("RV13_8","096_13_8","REV","13","8","8","Himɓe wonuɓe e duuniyaaru, ɓe inɗe mum winnaaka der dewtere yonki diga fuɗɗoode duuniyaaru, sujidanan bisaa ŋan. Jawgiyel kiisanooŋel nun woodi dewtere nen. ");
INSERT INTO fue_vpl VALUES ("RV13_9","096_13_9","REV","13","9","9","Gooduɗo noppi fu, nana! ");
INSERT INTO fue_vpl VALUES ("RV13_10","096_13_10","REV","13","10","10","Mo ɗum resani nanŋee maccunnaaku, nanŋee. Mo ɗum resani waree e kaafahi, waree e kaafahi. Gam majjum sey himɓe Alla tinno, jogoo goonɗinki. ");
INSERT INTO fue_vpl VALUES ("RV13_11","096_13_11","REV","13","11","11","Ɓaawo majjum, ji'umi bisaa kuuŋa e wurtoo diga e leydi. Ŋaa woodi galalɗi ɗiɗi nanduɗi e galalɗi Jawgiyel, amma ŋaa bata hande kuuŋa ŋan. ");
INSERT INTO fue_vpl VALUES ("RV13_12","096_13_12","REV","13","12","12","Ŋa gollirii baawɗe bisaa arana yeeso magga. Ŋa dooli duuniyaaru e jooɗiiɓe e mayru sujidana bisaa arana nawnanooŋa yiɗi waatugo ko nyawtaa. ");
INSERT INTO fue_vpl VALUES ("RV13_13","096_13_13","REV","13","13","13","Bisaa ɗiɗaɓa waɗi kaayeefiiji mawɗi. Ŋa jippini yiite diga dow kammu e leydi, himɓe fu e daara. ");
INSERT INTO fue_vpl VALUES ("RV13_14","096_13_14","REV","13","14","14","Ŋa ƴoyri himɓe duuniyaaru e kaayeefiiji. Ŋa hokkaama baawɗe waɗugo kaayeefiiji ɗin yeeso bisaa arana. Ŋa bati himɓe duuniyaaru waɗa tooruure nandune e bisaa nawnaaŋa e kaafahi ko daɗi. ");
INSERT INTO fue_vpl VALUES ("RV13_15","096_13_15","REV","13","15","15","Ŋa hokkaa baawɗe wattango tooruure nen yonki, faa ne bata gecca, ŋa waɗa mo sujidanay ne fu waree. ");
INSERT INTO fue_vpl VALUES ("RV13_16","096_13_16","REV","13","16","16","Bisaa ŋan dooli himɓe fu, tedduɓe e faanɗuɓe, jom jawdiiɓe e talakaaɓe, rimɓe e maccuɓe, ɓe gaɗanee maane to junŋo nyaamo, ɗum bo to tiiɗe maɓɓe. ");
INSERT INTO fue_vpl VALUES ("RV13_17","096_13_17","REV","13","17","17","Goɗɗo heɓataa sooda ɗum bo sippa to woodaa maane nen, maane nen bo, inne bisaa e lamba mum nun. ");
INSERT INTO fue_vpl VALUES ("RV13_18","096_13_18","REV","13","18","18","Sey neɗɗo heɓa faamu. Gooduɗo hakkillo, liiso lamba bisaa ŋan, gam lamba magga laati nun lamba neɗɗo. Lamba kan woni, keme jeego'o e lasoy tati e jeego'o (666). ");
INSERT INTO fue_vpl VALUES ("RV14_1","096_14_1","REV","14","1","1","Den daarumi kade, go ji'umi Jawgiyel e darii dow waanne Siyoona. Himɓe ujune hemure e lasoy ɗiɗo e nayo (144 000), e wondi e maggel. Inne maggel, e inne Baaba maggel e winnaa dow tiiɗe maɓɓe. ");
INSERT INTO fue_vpl VALUES ("RV14_2","096_14_2","REV","14","2","2","Nanumi daane ƴiwoy diga dow kammu kade. Daane nen e wa'i hande rimmo diyam ɗuuɗɗam, e hande riggaaŋo manŋo. Daane ne nanumi e wa'i hande moolooji nun fiyetee. ");
INSERT INTO fue_vpl VALUES ("RV14_3","096_14_3","REV","14","3","3","Himɓe ɓen e yima jimol kesol yeeso kittaal laamu, e yeeso tagaaɗum nayum yonkintejum, e yeeso dottiiɓe. Goɗɗo waaway ko ekkitii jimol ŋol to hinaa himɓe ujune hemure e lasoy ɗiɗo e nayo (144 000), sooditaaɓe diga duuniyaaru. ");
INSERT INTO fue_vpl VALUES ("RV14_4","096_14_4","REV","14","4","4","Himɓe ɓen tuuninay ko'e mum e rewɓe, gam ɓe jogake ko'e maɓɓe ɓee laaɓi. Ɓee tokki Jawgiyel to ŋel yahata fu. Kamɓe woni sooditaaɓe diga caka himɓe, gam ɓe laatoo arteteeɓe sakkee Alla e Jawgiyel. ");
INSERT INTO fue_vpl VALUES ("RV14_5","096_14_5","REV","14","5","5","Fewre meeɗay wurtaago e kunnuɗe maɓɓe, ɓe galaa gacce. ");
INSERT INTO fue_vpl VALUES ("RV14_6","096_14_6","REV","14","6","6","Ɓaawo majjum, ji'umi malaykaajo goɗɗo e fiira hakkune dow e ley. Oo woodi habaru belɗo, tabitiiɗo, gam o waajoo himɓe duuniyaaru fu, e leyɗeele fu, e lenyi fu, e ɗelle fu, e jama'aaje fu. ");
INSERT INTO fue_vpl VALUES ("RV14_7","096_14_7","REV","14","7","7","Oo bata e daane towne, oo wi'a: «Kulee Alla, teddinee mo, gam wakkati o hiitotoo warii. Cujidanee taguɗo kammu e leydi, e maayo, e ciiɓiije diyam!» ");
INSERT INTO fue_vpl VALUES ("RV14_8","096_14_8","REV","14","8","8","Malaykaajo ɗiɗaɓo tokkini arano, e wi'a: «Babiila wanŋarde mawne yanii! Ne yanii! Ne yarnii leyɗeele fu jaram mayre, ɗam baadi mayre kalluni.» ");
INSERT INTO fue_vpl VALUES ("RV14_9","096_14_9","REV","14","9","9","Malaykaajo goɗɗo, tataɓo tokkini ɓe, e bata e daane towne, e wi'a: «To goɗɗo sujidanii bisaa, e foto magga, go heɓi maane magga e tiine, naa bo e junŋo mum, ");
INSERT INTO fue_vpl VALUES ("RV14_10","096_14_10","REV","14","10","10","joomum yaran innabojam mone Alla. Jaram ɗam jillontiraaka, baanjaaɗam der jarirgel mone makko. Joomum tooroto der yiite e kibiriita yeeso malaykaaɓe seniiɓe, e yeeso Jawgiyel. ");
INSERT INTO fue_vpl VALUES ("RV14_11","096_14_11","REV","14","11","11","Curki yiite tooranŋe ɓe, e eenca dow faa abada. Sujidanɓe bisaa, e foto mum, ko heɓi maane inne magga, ɓe keɓataa siwtaare jemma e nyalooma fu.» ");
INSERT INTO fue_vpl VALUES ("RV14_12","096_14_12","REV","14","12","12","Gam majjum sey himɓe Alla, ɗowtaniiɓe ka o bati, go e goonɗini Yeesu heɓa munyal. ");
INSERT INTO fue_vpl VALUES ("RV14_13","096_14_13","REV","14","13","13","Den, nanumi daane diga dow kammu, e wi'a: «Winnu kaa ɗo: “Diga jooni, barke woodani maayuɓe go e hawti e Joomiraawo.” Ruuhu e wi'a: “Gooŋa nun! Ɓe ciwtoto e golle maɓɓe, gam golle maɓɓe tokkan ɓe.”» ");
INSERT INTO fue_vpl VALUES ("RV14_14","096_14_14","REV","14","14","14","Daarumi, den ji'umi duulere raneere. Goɗɗo nanduɗo e Ɓii neɗɗo e jooɗii dow mayre. Meetalol kanŋeeri e woni dow hoore makko. Oo jogii waarudu belŋol e junŋo makko. ");
INSERT INTO fue_vpl VALUES ("RV14_15","096_14_15","REV","14","15","15","Malaykaajo goɗɗo wurtoy diga suudu Alla, e bata e daane towne, e wi'a jooɗiiɗo e duulere on: «Faɗɗu waarudu maa, duggaa, gam wakkati dugge yottake, ko woni e leydi fotii ruggeego!» ");
INSERT INTO fue_vpl VALUES ("RV14_16","096_14_16","REV","14","16","16","Jooɗiiɗo e duulere faɗɗi waarudu mum e leydi, den ko woni e mayri fu ruggaa. ");
INSERT INTO fue_vpl VALUES ("RV14_17","096_14_17","REV","14","17","17","Malaykaajo goɗɗo wurtoy diga suudu Alla gonunu dow kammu, kanko bo, oo jogii waarudu belŋol. ");
INSERT INTO fue_vpl VALUES ("RV14_18","096_14_18","REV","14","18","18","Malaykaajo goɗɗo, dawranoowo yiite wurtoy diga e hiisirde. Oo bata e daane towne, oo wi'a malaykaajo jogiiɗo waarudu welunu on: «Faɗɗu waarudu maa welunu, duggaa ɓiɓɓe innabooje gonuɗe der duuniyaaru, gam ɗe ɓennii.» ");
INSERT INTO fue_vpl VALUES ("RV14_19","096_14_19","REV","14","19","19","Malaykaajo faɗɗi waarudu mum der duuniyaaru. O ruggi ɓiɓɓe innabooje tawaaɗe der leydi, o waanji ɗe der ɓiɗɗirde mawne, ne mone Alla. ");
INSERT INTO fue_vpl VALUES ("RV14_20","096_14_20","REV","14","20","20","Ɓiɓɓe innabooje ɓiɗɗaa der ɓiɗɗirde wonune yaasi wanŋarde. Ƴiiƴam ili diga ɓiɗɗirde nen. Ɗam hebbi faa yottii to lagame pucci. Ɗam ili faa jaka kiloo keme tati (300). ");
INSERT INTO fue_vpl VALUES ("RV15_1","096_15_1","REV","15","1","1","Ɓaawo mum, ji'umi maane gom dow kammu. Maane nen e mawni, nee hunnii bo. Den ji'umi malaykaaɓe jeeɗiɗo e jogii boneeji jeeɗiɗi. Kanji laatii boneeji cakitiiɗi ɗi mone Alla hebbirta. ");
INSERT INTO fue_vpl VALUES ("RV15_2","096_15_2","REV","15","2","2","Ji'umi ko nandi e maayo nanduŋo e daanorgal, jillontiriiŋo e yiite. Mi yi'ii jaaliiɓe bisaa e foto magga, e lamba inne magga, ɓee darii dow maayo ŋon, ɓee jogii moolooji Alla. ");
INSERT INTO fue_vpl VALUES ("RV15_3","096_15_3","REV","15","3","3","Ɓee jima jimol Muusa, jaggiiɗo Alla, e ŋol Jawgiyel, ɓee bi'a: «Joomiraawo Alla mo baawɗe, golle maa e mawni, e haayɗinii! Laabi maa e foortii, e laatii gooŋaaji, an laamaniiɗo leyɗeele! ");
INSERT INTO fue_vpl VALUES ("RV15_4","096_15_4","REV","15","4","4","Joomiraawo, moy woni mo hulataa ma? moy woni teddintaa inne maa? Gam an tan laatii Ceniiɗo. Lenyi fu waran sujida yeeso maa, gam ɓe ji'i no golle maa foonnitorii.» ");
INSERT INTO fue_vpl VALUES ("RV15_5","096_15_5","REV","15","5","5","Ɓaawo mum, ji'umi dow kammu, suudu Alla e maɓɓitii, bukaaru e woni der mayru. ");
INSERT INTO fue_vpl VALUES ("RV15_6","096_15_6","REV","15","6","6","Malaykaaɓe jeeɗiɗo jogiiɓe boneeji jeeɗiɗi wurtoy diga suudu Alla nun. Ɓee ɓornii gineeji laaɓuɗi, jalbooji. Ɓee kaɓɓi ɓelɓeli to gabaaje maɓɓe. ");
INSERT INTO fue_vpl VALUES ("RV15_7","096_15_7","REV","15","7","7","Gootum der tagaaɗum nayum yonkintejum ɗum, hokki malaykaaɓe jeeɗiɗo ɓen pehe kanŋeeri jeeɗiɗi. Pehe ɗen e hebbi mone Alla buurɗo faa abada. ");
INSERT INTO fue_vpl VALUES ("RV15_8","096_15_8","REV","15","8","8","Den suudu Alla hebbi curki sabbu tedduŋal Alla e baawɗe mum. Goɗɗo waaway ko naati der mayru, sey no boneeji jeeɗiɗi ɗi malaykaaɓe jeeɗiɗo waddi hebbi. ");
INSERT INTO fue_vpl VALUES ("RV16_1","096_16_1","REV","16","1","1","Den nanumi daane towne ƴiwoy diga suudu Alla, e wi'a malaykaaɓe jeeɗiɗo ɓen: «Jahee, deƴƴitee der duuniyaaru jarirkon mone Alla jeeɗiɗon!» ");
INSERT INTO fue_vpl VALUES ("RV16_2","096_16_2","REV","16","2","2","Malaykaajo arano yahi, reƴƴiti jarirgel mum dow leydi, ɓuuwe kalluɗe, naawuɗe nanŋi himɓe wooduɓe maane bisaa, e sujidanooɓe foto magga. ");
INSERT INTO fue_vpl VALUES ("RV16_3","096_16_3","REV","16","3","3","Malaykaajo ɗiɗaɓo reƴƴiti jarirgel mum dow maayo, ŋo waylitii ƴiiƴam hande ɗam maayɗo. Den ko woodi yonki der maayo fu, waati. ");
INSERT INTO fue_vpl VALUES ("RV16_4","096_16_4","REV","16","4","4","Malaykaajo tataɓo reƴƴiti jarirgel mum dow gooruuji, e ciiɓiije, ɗe baylitii ƴiiƴam. ");
INSERT INTO fue_vpl VALUES ("RV16_5","096_16_5","REV","16","5","5","Den nanumi malaykaajo dawranoowo diyeele e wi'a: «An Alla, laatiiɗo poonnitiiɗo, an wonunoo, an woni jooni, an laatii Ceniiɗo, a hiitorake e foonnitaare. ");
INSERT INTO fue_vpl VALUES ("RV16_6","096_16_6","REV","16","6","6","Gam ɓe deƴƴitii ƴiiƴam himɓe maaɗa e ɗam annabiiɓe, an bo, a hokkii ɓe ƴiiƴam ɓe jara! Ɓe keɓii ko haanani ɓe.» ");
INSERT INTO fue_vpl VALUES ("RV16_7","096_16_7","REV","16","7","7","Den nanumi daane ƴiwi diga hiisirde, e wi'a: «Gooŋa! Joomiraawo Alla mo baawɗe, sariyaaji maa e laatii gooŋaaji, ɗii laatii poonnitiiɗi!» ");
INSERT INTO fue_vpl VALUES ("RV16_8","096_16_8","REV","16","8","8","Malaykaajo nayaɓo reƴƴiti jarirgel mum dow naaŋe, den ŋe hokkaa baawɗe sunnyugo himɓe e yiite magge. ");
INSERT INTO fue_vpl VALUES ("RV16_9","096_16_9","REV","16","9","9","Guli cattuɗi waɗi himɓe. Ɓe jenni inne Alla gooduɗo baawɗe dow boneeji ɗin. Amma ɓe tuubay, ɓe teddina mo. ");
INSERT INTO fue_vpl VALUES ("RV16_10","096_16_10","REV","16","10","10","Malaykaajo joyaɓo reƴƴiti jarirgel mum dow kittaal laamu bisaa. Den laamu magga niɓɓi. Himɓe darii e ŋata ɗelle mum sabbu naawella. ");
INSERT INTO fue_vpl VALUES ("RV16_11","096_16_11","REV","16","11","11","Ɓe jenni Alla mo dow kammu, sabbu ɓuuwe e naawella maɓɓe. Amma, ɓe tuubay, ɓe acca golle maɓɓe kalluɗe. ");
INSERT INTO fue_vpl VALUES ("RV16_12","096_16_12","REV","16","12","12","Malaykaajo jeego'aɓo reƴƴiti jarirgel mum dow maayo manŋo wi'eteeŋo Efaratis, diyam maggo ɓeetti, accani laamiiɓe warooɓe diga lettugal laawol. ");
INSERT INTO fue_vpl VALUES ("RV16_13","096_16_13","REV","16","13","13","Den ji'umi ginnaaji tati, nanduɗi e paaɓi, e wurtoo e hunnuko kuuŋa gom, e diga hunnuko bisaa, e diga hunnuko annabiijo fewrekuujo. ");
INSERT INTO fue_vpl VALUES ("RV16_14","096_16_14","REV","16","14","14","Ginnaaji ɗin ƴiwii e Seyɗan. Ɗii gaɗa maaneeji, ɗii jaha to laamiiɓe duuniyaaru fu, ɗii kawrita ɓe gam ɓe kaɓa konu nyalaane darŋal, nyalaane Alla mo baawɗe. ");
INSERT INTO fue_vpl VALUES ("RV16_15","096_16_15","REV","16","15","15","Joomiraawo wi'i: «Kettinee! Mii wara hande gujjo. Barke laatanii mo ɗaanaaki e reeni gineeji mum gam to o yahu funtu, himɓe yi'a centuɗum makko!» ");
INSERT INTO fue_vpl VALUES ("RV16_16","096_16_16","REV","16","16","16","Ginnaaji ɗin hawriti laamiiɓe to nokkuure wi'eteene e Iburaninkeere, Harmagedon. ");
INSERT INTO fue_vpl VALUES ("RV16_17","096_16_17","REV","16","17","17","Malaykaajo jeeɗiɗaɓo reƴƴiti jarirgel mum dow hennu, daane towne gom nanaa diga kittaal laamu, der suudu Alla e wi'a: «Ɗum heennyii!» ");
INSERT INTO fue_vpl VALUES ("RV16_18","096_16_18","REV","16","18","18","Maaƴƴe maaƴƴi, rimmo e diggaale waɗi, leydi dimmii e semme. Iri dimmaaɗe leydi hande ɗee ɗon meeɗay ko waɗi diga ko himɓe tagaa der duuniyaaru, gam ɗe cattii puy! ");
INSERT INTO fue_vpl VALUES ("RV16_19","096_16_19","REV","16","19","19","Wanŋarde mawne seenniraa pecce tati. Banŋarɗe mawɗe ɗe leyɗeele goɗɗe yani. Den Alla siwtori wanŋarde mawne wi'eteene Babiila. O yarini ne jarirgel kebbuŋel innabojam ɗam mone makko mawne. ");
INSERT INTO fue_vpl VALUES ("RV16_20","096_16_20","REV","16","20","20","Dunɗe fu halki, baalle bo majjiti. ");
INSERT INTO fue_vpl VALUES ("RV16_21","096_16_21","REV","16","21","21","Malamalluuje mawɗe yani dow himɓe diga kammu. Malamalluuje ɗen teddugo woore mum fu waɗan kilo lasoy ɗiɗi. Himɓe yenni Alla sabbu bone malamalluuje ɗen, gam ɗum sattii puy. ");
INSERT INTO fue_vpl VALUES ("RV17_1","096_17_1","REV","17","1","1","Ɓaawo majjum, gooto der malaykaaɓe jeeɗiɗo, jogiiɓe jarirkon jeeɗiɗon wari, wi'immi: «War mi hollee no kaaruwaajo mawɗo, jooɗiiɗo dow diyeele ɗuuɗɗe hiitortee. ");
INSERT INTO fue_vpl VALUES ("RV17_2","096_17_2","REV","17","2","2","Laamiiɓe duuniyaaru waɗidii jeenu e makko. Himɓe buusii e jaram kaaruwaaku makko.» ");
INSERT INTO fue_vpl VALUES ("RV17_3","096_17_3","REV","17","3","3","Den Ruuhu hebbimmi, go malaykaajo yaarimmi der haro. Ton ji'umi debbo gom e waɗɗii bisaa boɗeya, gooduŋa inɗe jennooje Alla. Bisaa ŋan e woodi ko'e jeeɗiɗi e galalɗi sappo. ");
INSERT INTO fue_vpl VALUES ("RV17_4","096_17_4","REV","17","4","4","Debbo on e ɓornii kolte boɗe boɗeeji, e wattii kanŋeeri e kaaƴe dime, e colle. Oo jogii jarirgel kanŋeeri e junŋo makko. Jarirgel ŋel e hebbi karmuɗum e nyidduɗum ɗum kaaruwaaku makko. ");
INSERT INTO fue_vpl VALUES ("RV17_5","096_17_5","REV","17","5","5","Inne ne maane mum suuɗii e winnii e tiine makko: «Babiila wanŋarde mawne, inna kaaruwaaɓe e waɗooɓe ko nyiddi fu der duuniyaaru.» ");
INSERT INTO fue_vpl VALUES ("RV17_6","096_17_6","REV","17","6","6","Den ji'umi debbo on e buusi sabbu no o yariri ƴiiƴam himɓe Alla, e ƴiiƴam waraaɓe gam ɓe ceedii haala Yeesu. No ji'umoo mi, kayɗiniimi sanne. ");
INSERT INTO fue_vpl VALUES ("RV17_7","096_17_7","REV","17","7","7","Amma malaykaajo on wi'immi: «Gam ume ɗum haaynii maa? Mi faaminte maanaa cuuɗiika dow debbo on e bisaa ŋa o waɗɗii, gooduŋa ko'e jeeɗiɗi e galalɗi sappo. ");
INSERT INTO fue_vpl VALUES ("RV17_8","096_17_8","REV","17","8","8","Bisaa ŋa ji'uɗaa, ŋa na'onno, amma jooni, ŋa walaa. Ŋa wurtoyto diga e gayka lugguka, ŋa yaha halkoygo. Inɗe himɓe duuniyaaru woɓɓe winnaaka e dewtere yonki diga fuɗɗoode duuniyaaru. Ɓe kaayɗinto to ɓe ji'ii ŋa, gam ŋa na'onno, go ŋa walaa kade, amma ŋa wittitoyto. ");
INSERT INTO fue_vpl VALUES ("RV17_9","096_17_9","REV","17","9","9","Haani neɗɗo heɓa annal e faamu. Ko'e jeeɗiɗi ɗen laati nun baalle jeeɗiɗi ɗe debbo jooɗii dow mum. Kanje woni laamiiɓe jeeɗiɗo: ");
INSERT INTO fue_vpl VALUES ("RV17_10","096_17_10","REV","17","10","10","joyo yanii, jeego'aɓo nun laamii jooni, jeeɗiɗaɓo waray taw. Amma to o warii wakkati seɗɗa o laamotoo. ");
INSERT INTO fue_vpl VALUES ("RV17_11","096_17_11","REV","17","11","11","Bisaa gonunooŋa go ŋa walaa, laatii laamiiɗo jeetataɓo. Ŋaa laatii bo gooto der jeeɗiɗo, go ŋaa yaha halkoygo. ");
INSERT INTO fue_vpl VALUES ("RV17_12","096_17_12","REV","17","12","12","Galalɗi sappo ɗi ji'uɗaa, laatii laamiiɓe sappo ɓe keɓay laamaare taw. Amma ɓe keɓan baawɗe laamaago e bisaa yanne woore tan. ");
INSERT INTO fue_vpl VALUES ("RV17_13","096_17_13","REV","17","13","13","Ɓe fu, huune gootum ɓe tiitii, ɓe kokka bisaa semme maɓɓe, e baawɗe maɓɓe. ");
INSERT INTO fue_vpl VALUES ("RV17_14","096_17_14","REV","17","14","14","Ɓe kaɓan e Jawgiyel, amma ŋel jaaloto ɓe, gam kanŋel laatii Joomiraawo joomiraaɓe, e Laamiiɗo laamiiɓe. Wonduɓe e maggel, laatiiɓe noddaaɓe, e suɓaaɓe, e hoolaaɓe, jaalodinto e maggel.» ");
INSERT INTO fue_vpl VALUES ("RV17_15","096_17_15","REV","17","15","15","Malaykaajo on wi'immi kade: «Diyeele ɗe ji'uɗaa kaaruwaajo on e jooɗii dow mum, woni himɓe, e jama'aaje, e leyɗeele, e ɗelle. ");
INSERT INTO fue_vpl VALUES ("RV17_16","096_17_16","REV","17","16","16","Galalɗi sappo ɗi ji'uɗa, kanji e bisaa, wanyan kaaruwaajo on, ɓorta mo, acca mo funtu. Ɓe ƴakkan tew makko, ɓe paɗɗa mo e yiite. ");
INSERT INTO fue_vpl VALUES ("RV17_17","096_17_17","REV","17","17","17","Gam Alla wattii der ɓerɗe maɓɓe ɓe gaɗa ko o resi. Ɓe gaɗa hunnuko wooto, ɓe kokka bisaa laamu maɓɓe, faa de ko Alla bati fu hebbi. ");
INSERT INTO fue_vpl VALUES ("RV17_18","096_17_18","REV","17","18","18","Debbo mo ji'uɗaa, kanko laatii wanŋarde mawne, laamaniine laamiiɓe duuniyaaru.» ");
INSERT INTO fue_vpl VALUES ("RV18_1","096_18_1","REV","18","1","1","Ɓaawo majjum, ji'umi malaykaajo gom kade e jippoo diga dow kammu. Oo woodi baawɗe mawɗe, tedduŋal makko yayni e duuniyaaru fu. ");
INSERT INTO fue_vpl VALUES ("RV18_2","096_18_2","REV","18","2","2","O batii e daane towne, o wi'i: «Ne yanii! Babiila wanŋarde mawne yanii! Ne laatike wonorde ginnaaji, e suuɗorde ruuhuuji coɓuɗi, e suuɗorde pooli coɓuɗi, e elliniiɗi fu! ");
INSERT INTO fue_vpl VALUES ("RV18_3","096_18_3","REV","18","3","3","Gam leyɗeele fu buusii e jaram kaaruwaaku mayre. Laamiiɓe duuniyaaru jeenii e mayre, tenkuuɓe duuniyaaru heɓii jawdi diga goonnan mayre mawɗam.» ");
INSERT INTO fue_vpl VALUES ("RV18_4","096_18_4","REV","18","4","4","Den nanumi daane wonne diga kammu, e wi'a: «Burtee e mayre, onon himɓe am! Gam to on kawtee e hakkeeji mayre, gam to boneeji mayre heɓu on. ");
INSERT INTO fue_vpl VALUES ("RV18_5","096_18_5","REV","18","5","5","Gam hakkeeji mayre yowontirii faa yottii dow kammu, Alla bo siwtorii gaɗu mayre kalluŋu. ");
INSERT INTO fue_vpl VALUES ("RV18_6","096_18_6","REV","18","6","6","Gaɗanee ne hande no ne waɗani on. Joɓitee ne ko ne waɗani on de ɗiɗi. Jarirgel ŋel ne laawirani on jaram, laawiranee ne e maggel, semme majjam ɓura de ɗiɗi! ");
INSERT INTO fue_vpl VALUES ("RV18_7","096_18_7","REV","18","7","7","Ɗuuɗinanee ne toora e bojji jaka no ne teddiniri hoore mayre, e no ne wuuriri der goonnan. Gam nee wi'a der ɓerne mayre: ‟Min laamiiɗo debbo nun, mi gowniijo bane, mi annataa bojji maayde abada!” ");
INSERT INTO fue_vpl VALUES ("RV18_8","096_18_8","REV","18","8","8","Gam majjum, der nyalaane woore boneeji ɗii ɗo waranan ne: maayde, e bojji, e rafo, ne jaɓan du yiite, gam Alla Joomiraawo kiitotooɗo ne, laati nun mo baawɗe.» ");
INSERT INTO fue_vpl VALUES ("RV18_9","096_18_9","REV","18","9","9","Laamiiɓe duuniyaaru hawtuɓe e mayre der jeenu e goonnan mayre wullan, simoo to yi'i curki bulol yiite mayre. ");
INSERT INTO fue_vpl VALUES ("RV18_10","096_18_10","REV","18","10","10","Ɓe daroto woɗɗi, gam ɓe kulan kiita mayre heɓa ɓe. Ɓe bi'an: «Kayto! Kayto! Babiila, wanŋarde mawne, Babiila wanŋarde semmenteere, der yanne woore tan, kiitaɗaa!» ");
INSERT INTO fue_vpl VALUES ("RV18_11","096_18_11","REV","18","11","11","Tenkuuɓe duuniyaaru wullan, simoo gam mayre, gam goɗɗo soodataa kade gineeji maɓɓe. ");
INSERT INTO fue_vpl VALUES ("RV18_12","096_18_12","REV","18","12","12","Kanŋeeri, e cardi, e kaaƴe dime, e colle, e gude ɗigguɗe, e gude boɗeeje, e boɗeeje coy, e leɗɗe luuttooje, e huune feere feere gaɗiraaɗum nyiiƴe nyiibi, e huune gaɗiraaɗum leɗɗe caadiiɗe, e janni boɗeeri, e janni ɓaleeri, e hayre wi'eteeni marba, ");
INSERT INTO fue_vpl VALUES ("RV18_13","096_18_13","REV","18","13","13","e koɓitaaje leɗɗe bi'eteeɗe kanel, e li'anji, e wardi, e miira, e wardi buuɗeteeɗum, e innabojam, e nebbam, e conni, e alkamaari, e na'i, e baali, e pucci, e laanaaji pucci, e maccuɓe, e yonkiiji himɓe. ");
INSERT INTO fue_vpl VALUES ("RV18_14","096_18_14","REV","18","14","14","Tenkuuɓe wi'an wanŋarde nen: «Ko cuuninoɗaa heɓugo fu woɗɗike ma. Jawdi maa, e ko wooɗi fu majjii, a heɓitintaako ɗum abada.» ");
INSERT INTO fue_vpl VALUES ("RV18_15","096_18_15","REV","18","15","15","Tenkuuɓe heɓuɓe jawdi e mayre, daroto woɗɗi, gam kulol kiita mayre. Ɓe bullan, ɓe cimoo, ");
INSERT INTO fue_vpl VALUES ("RV18_16","096_18_16","REV","18","16","16","ɓee bi'a: «Kayto! Kayto! Wanŋarde mawne, nee ɗo jurortono gude ɗigguɗe e gude boɗeeje, e boɗeeje coy. Nee ɗo jurortono kanŋeeri e kaaƴe dime, e colle! ");
INSERT INTO fue_vpl VALUES ("RV18_17","096_18_17","REV","18","17","17","Jawdi nii fu halkii der yanne woore!» Ɓoylooɓe laanaaje diyam mawɗe, e yahooɓe toy fu der majje, e gollotooɓe der majje, e suuɓotooɓe liƴƴi, darii woɗɗi. ");
INSERT INTO fue_vpl VALUES ("RV18_18","096_18_18","REV","18","18","18","No ɓe ji'i curki bulol mayre yiite, ɓe kalɓi, ɓe bi'i: «Wanŋarde gom walaa fotidinnoone e wanŋarde nee ɗo!» ");
INSERT INTO fue_vpl VALUES ("RV18_19","096_18_19","REV","18","19","19","Ɓe darii, ɓee baanja leydi dow ko'e maɓɓe, ɓee bulla, ɓee cimoo. Ɓerɗe maɓɓe e biisii, ɓee bi'a: «Kayto! Kayto! Wanŋarde mawne, ne goonnan mum hokki wooduɓe laanaaje diyam fu jawdi, der yanne woore tan, ne halkii! ");
INSERT INTO fue_vpl VALUES ("RV18_20","096_18_20","REV","18","20","20","Kammu, seya gam kalkol mayre! Onon himɓe Alla e lilaaɓe, e annabiiɓe, ceyee onon bo! Gam Alla hiitake ne ko ne waɗani on!» ");
INSERT INTO fue_vpl VALUES ("RV18_21","096_18_21","REV","18","21","21","Den malaykaajo semmenteejo gom etti hayre mawne nandune e namarde, faɗɗi ne der maayo, wi'i: «Ninnii nun Babiila, wanŋarde mawne faɗɗirtee e semme, ne yi'ataake kade faa abada! ");
INSERT INTO fue_vpl VALUES ("RV18_22","096_18_22","REV","18","22","22","Daane fiyooɓe moolooji, e yimooɓe, e fuurooɓe algaytaaji, e fuurooɓe galalɗi nanataake kade der maa abada! Waɗooɓe golle juuɗe feere feere yi'ataake kade der maa. Rimmo namarde nanataake kade der maa. ");
INSERT INTO fue_vpl VALUES ("RV18_23","096_18_23","REV","18","23","23","Jayŋol fitilla yaynataa der maa. Daane jommanjo gorko e jommanjo debbo nanataake kade der maa. Gam tenkuuɓe maa laatinoo mawɓe der leydi. A jammike leyɗeele ɗuuɗɗe e dobo dobooje maa. ");
INSERT INTO fue_vpl VALUES ("RV18_24","096_18_24","REV","18","24","24","Ƴiiƴam annabiiɓe e ƴiiƴam himɓe Alla, e ɗam waraaɓe der duuniyaaru tawaama der maa.» ");
INSERT INTO fue_vpl VALUES ("RV19_1","096_19_1","REV","19","1","1","Ɓaawo majjum, nanumi daane towne hande daane jama'aare ɗuunne dow kammu, e wi'a: «Aleluya! Kisidam, e tedduŋal, e baawɗe laatanii Alla meeɗen. ");
INSERT INTO fue_vpl VALUES ("RV19_2","096_19_2","REV","19","2","2","Kiitaaji makko e laatii gooŋaaji, ɗii poonnitii! O hiitake kaaruwaajo mawɗo biisuɗo duuniyaaru e kaaruwaaku mum. Alla hiitake mo gam o reƴƴitii ƴiiƴam gollantooɓe ɗum.» ");
INSERT INTO fue_vpl VALUES ("RV19_3","096_19_3","REV","19","3","3","Ɓe bi'i de ɗiɗawre: «Aleluya! Curki bulol wanŋarde nen e eenca dow faa abada!» ");
INSERT INTO fue_vpl VALUES ("RV19_4","096_19_4","REV","19","4","4","Dottiiɓe laso e nayo, e tagaaɗum nayum yonkintejum ɗum, jiccii sujidani Alla jooɗiiɗo dow kittaal laamu, e wi'a: «Aami! Aleluya!» ");
INSERT INTO fue_vpl VALUES ("RV19_5","096_19_5","REV","19","5","5","Daane ƴiwi diga kittaal laamu, e wi'a: «Jettee Alla meeɗen, onon gollantooɓe mo fu, onon hulɓe mo, mawɓe e petton!» ");
INSERT INTO fue_vpl VALUES ("RV19_6","096_19_6","REV","19","6","6","Den nanumi hande daane jama'aare ɗuunne, e hande rimmo diyam ɗuuɗɗam, e kade hande riggaaŋo manŋo, e wi'a: «Aleluya! Alla Joomiraawo meeɗen, mo baawɗe, laamake. ");
INSERT INTO fue_vpl VALUES ("RV19_7","096_19_7","REV","19","7","7","En ceyee, belbelten, teddinen mo, gam ɓangal Jawgiyel yottake. Ɗaɓɓaaɗo maggel siriyake. ");
INSERT INTO fue_vpl VALUES ("RV19_8","096_19_8","REV","19","8","8","O hokkaama o ɓornoo kolte ɗigguɗe, jalbooje, laaɓuɗe.» Kolte ɗen laatii hande gaɗu himɓe Alla geetu. ");
INSERT INTO fue_vpl VALUES ("RV19_9","096_19_9","REV","19","9","9","Malaykaajo wi'immi: «Winnu: ‟Barke woodani noddinaaɓe nyaamɗe teegal Jawgiyel!”» O wi'immi kade: «Haala Alla gooŋaha ka o bati nun ɗon.» ");
INSERT INTO fue_vpl VALUES ("RV19_10","096_19_10","REV","19","10","10","Jicciimi ley koyɗe makko, gam mi sujidana mo, amma o wi'immi: «Taa waɗu ɗum! Min bo, mi gollantooɗo Alla nun hande maa, e hande banniraaɓe maa jogiiɓe seedaaku Yeesu. Sujidan Alla!» Gooŋa ka Yeesu holliti, kanka nun hokki annabiiɓe haala ka ɓe bati dow makko. ");
INSERT INTO fue_vpl VALUES ("RV19_11","096_19_11","REV","19","11","11","Ɓaawo majjum ji'umi kammu maɓɓitii. Den ji'umi puccu danewol. Baɗɗiiɗo ŋol, e wi'ee Kooliniiɗo, e Gooŋaajo. Gooŋa o hiitortoo, kanka o haɓirta bo konu. ");
INSERT INTO fue_vpl VALUES ("RV19_12","096_19_12","REV","19","12","12","Gite makko e wa'i hande ɗenŋal yiite. Oo mellii meetali laamu ɗuuɗɗi. Inne e winna dow makko, goɗɗo annaa ne, to hinaa kanko. ");
INSERT INTO fue_vpl VALUES ("RV19_13","096_19_13","REV","19","13","13","Oo ɓornii toggoore cownaane der ƴiiƴam, inne makko woni: «Haala Alla.» ");
INSERT INTO fue_vpl VALUES ("RV19_14","096_19_14","REV","19","14","14","Konunkeeɓe ɓe dow kammu e tokkini mo. Ɓee baɗɗii pucci daneeji, ɓee ɓornii kolte daneeje ɗigguɗe, laaɓuɗe. ");
INSERT INTO fue_vpl VALUES ("RV19_15","096_19_15","REV","19","15","15","Kaafahi belki e wurtoo diga e hunnuko makko. Kanki o jaalortoo himɓe. O laamoranto ɓe e sawru janni. O ɓiɗɗan innabooje der ɓiɗɗirde mone Alla mawne, laatiiɗo mo baawɗe. ");
INSERT INTO fue_vpl VALUES ("RV19_16","096_19_16","REV","19","16","16","Inne gom e winnaa dow toggoore makko, e dow asaaŋal makko: «Laamiiɗo laamiiɓe, e Joomiraawo joomiraaɓe.» ");
INSERT INTO fue_vpl VALUES ("RV19_17","096_19_17","REV","19","17","17","Den ji'umi malaykaajo gom e darii dow naaŋe. O batii e daane towne, o wi'i pooli piirooji dow hennu fu: «Garee kawritee gam juulɗe Alla waɗi. ");
INSERT INTO fue_vpl VALUES ("RV19_18","096_19_18","REV","19","18","18","On ƴakkan tew laamiiɓe, e hooreeɓe soogeeji, e ɓannu semmenteeɓe, e tew pucci, e waɗɗiiɓe ɗi, e ɓannu himɓe fu: rimɓe e maccuɓe, mawɓe e petton!» ");
INSERT INTO fue_vpl VALUES ("RV19_19","096_19_19","REV","19","19","19","Den ji'umi bisaa e laamiiɓe duuniyaaru, e konunkeeɓe mum. Ɓe kawritii gam ɓe kaɓida e baɗɗiiɗo puccu on, e konunkeeɓe mum. ");
INSERT INTO fue_vpl VALUES ("RV19_20","096_19_20","REV","19","20","20","Bisaa ŋan nanŋaa maɓɓaa, kanŋa e annabiijo pewoowo gaɗunooɗo haaynaareeji yeeso magga. E haaynaareeji ɗin o jammoriinoo wooduɓe maane bisaa, e sujidanooɓe foto magga. Ɓe fu ɗiɗo, ɓe paɗɗaa e yonki der maayo yiite kuɓɓoowe, e kibiriita. ");
INSERT INTO fue_vpl VALUES ("RV19_21","096_19_21","REV","19","21","21","Horiiɓe waraa e kaafahi burtotooki e hunnuko baɗɗiiɗo puccu on. Pooli wari ƴakki ɓalli maɓɓe, faa ɗi kaari. ");
INSERT INTO fue_vpl VALUES ("RV20_1","096_20_1","REV","20","1","1","Ɓaawo majjum, ji'umi malaykaajo gom e jippoo diga dow kammu. Oo jogii callalluwol manŋol, e maɓɓitirgel gayka lugguka. ");
INSERT INTO fue_vpl VALUES ("RV20_2","096_20_2","REV","20","2","2","O nanŋi kuuŋa, boddi nayeeri, bi'eteeni Ibiliisa e Seyɗan, o haɓɓi ŋa faa duuɓi ujuneere. ");
INSERT INTO fue_vpl VALUES ("RV20_3","096_20_3","REV","20","3","3","O watti ŋa der gayka lugguka, o maɓɓi, o feɗi. Den o takki takkanne dow makka, gam to o jammoo leyɗeele kade faa duuɓi ujuneere hebba. Ɓaawo majjum, o maɓɓitinte wakkati seɗɗa. ");
INSERT INTO fue_vpl VALUES ("RV20_4","096_20_4","REV","20","4","4","Den ji'umi kittaaje laamu e jooɗiiɓe dow majje. Ɓe kokkaama baawɗe hiitaago. Den ji'umi yonkiiji ɓe ko'e mum wudditaa gam ɓe ceedanike Yeesu, e gam ɓe baajike haala Alla. Ɓe cujidanaay bo bisaa, e foto mum. Ɓe keɓay maane dow tiiɗe, ɗum bo e juuɗe maɓɓe. Ɓe pintii, ɓe laamodii e Almasiihu duuɓi ujuneere. ");
INSERT INTO fue_vpl VALUES ("RV20_5","096_20_5","REV","20","5","5","Maayɓe horiiɓe fintay faa duuɓi ujuneere hebbi. Kanjum woni pintol aranol. ");
INSERT INTO fue_vpl VALUES ("RV20_6","096_20_6","REV","20","6","6","Barke e cenaaki woodani wonuɓe der pintol aranol! Maayde ɗiɗawre woodaa baawɗe dow maɓɓe. Ɓe laatanto Alla e Almasiihu Limaamiiɓe, ɓe laamodoo e makko duuɓi ujuneere. ");
INSERT INTO fue_vpl VALUES ("RV20_7","096_20_7","REV","20","7","7","To duuɓi ujuneere hebbii, Seyɗan yoofete, wurtoo e kasu mum. ");
INSERT INTO fue_vpl VALUES ("RV20_8","096_20_8","REV","20","8","8","O jammoto leyɗeele gonuɗe der gooraaje duuniyaaru naay, waato Gog, e Magog. O hawritan ɗe gam konu, ɗe ɗuuɗan hande jaaneeri maayo. ");
INSERT INTO fue_vpl VALUES ("RV20_9","096_20_9","REV","20","9","9","Ɓe cankitii der duuniyaaru fu, ɓe piiltitii himɓe Alla, e wanŋarde jiɗaane. Amma yiite jippii diga kammu, halki ɓe. ");
INSERT INTO fue_vpl VALUES ("RV20_10","096_20_10","REV","20","10","10","Seyɗan jammotooɗo ɓe, faɗɗaa der maayo yiite e kibiriita, to bisaa e annabiijo pewoowo woni. Ɗon nun ɓe toorotoo jemma e nyalooma, faa abada. ");
INSERT INTO fue_vpl VALUES ("RV20_11","096_20_11","REV","20","11","11","Ɓaawo majjum, ji'umi kittaal laamu manŋal daneyal, e jooɗiiɗo dow maggal. Leydi e kammu doggi yeeso makko, yi'aaka kade. ");
INSERT INTO fue_vpl VALUES ("RV20_12","096_20_12","REV","20","12","12","Mi yi'ii maayɓe, mawɓe e petton e darii yeeso kittaal laamu. Dewte maɓɓitaa. Den dewtere wonne maɓɓitaa, kayre woni dewtere yonki. Maayɓe hiitaa hande no winniraa der dewte, moy fu jaka golle mum. ");
INSERT INTO fue_vpl VALUES ("RV20_13","096_20_13","REV","20","13","13","Maayo tuuti maayɓe mum. Maayde e joonne maayɓe bo tuuti maayɓe mum. Den moy maɓɓe fu, hiitaa deydey golle mum. ");
INSERT INTO fue_vpl VALUES ("RV20_14","096_20_14","REV","20","14","14","Maayde, e joonne maayɓe wattaa der maayo yiite. Maayo yiite ŋon woni maayde ɗiɗawre. ");
INSERT INTO fue_vpl VALUES ("RV20_15","096_20_15","REV","20","15","15","Neɗɗo mo inne mum winnaaka der dewtere yonki, faɗɗaama der maayo yiite. ");
INSERT INTO fue_vpl VALUES ("RV21_1","096_21_1","REV","21","1","1","Ɓaawo majjum, ji'umi kammu kesu e leydi keyri, kammu aranu e leydi arandeeri majjitii, maayo bo walaa. ");
INSERT INTO fue_vpl VALUES ("RV21_2","096_21_2","REV","21","2","2","Ji'umi wanŋarde ceniine, waato Urusaliima kesol e jippoo diga dow kammu, diga to Alla. Ŋol siriyake hande debbo ciriyiiɗo fotta e gorum. ");
INSERT INTO fue_vpl VALUES ("RV21_3","096_21_3","REV","21","3","3","Mi nanii daane towne diga to kittaal laamu, e wi'a: «Jooɗorde Alla caka himɓe nani, o wonoto e maɓɓe, ɓe laatoo himɓe makko, Alla e hoore mum wondan e maɓɓe. ");
INSERT INTO fue_vpl VALUES ("RV21_4","096_21_4","REV","21","4","4","O moytan gonɗi gite maɓɓe fu. Maayde, e bojji, e toora wonataako kade, gam kujje arandeeje fu yawtii.» ");
INSERT INTO fue_vpl VALUES ("RV21_5","096_21_5","REV","21","5","5","Jooɗiiɗo dow kittaal laamu wi'i: «Mi waɗan huune fu laatoo kesum!» O wi'i: «Winnu haalaaji ɗii, gam ɗi laati nun gooŋaaji, kooliniiɗi.» ");
INSERT INTO fue_vpl VALUES ("RV21_6","096_21_6","REV","21","6","6","O wi'immi kade, «Huune fu hebbii! Min woni arano, min woni sakitiineejo, min woni fuɗɗoode, e heennyitirde. Ɗonɗaaɗo fu, mi hokkan ɗum diyam yonki, o yoɓataa. ");
INSERT INTO fue_vpl VALUES ("RV21_7","096_21_7","REV","21","7","7","Jaaliiɗo heɓan huune ɗum fu, mi laatoto Alla makko, o laatoo ɓiɗɗo am. ");
INSERT INTO fue_vpl VALUES ("RV21_8","096_21_8","REV","21","8","8","Amma hulhulɓe, e ɓe walaa goonɗinki, e soɓuɓe, e warooɓe himɓe, e jeenooɓe, e waɗooɓe dobo dobooje, e saafooɓe tooruuje, e fewooɓe fu, maayo yiite kuɓɓoowe e kibiriita nun woni geɗu maɓɓe. Kanjum woni maayde ɗiɗawre.» ");
INSERT INTO fue_vpl VALUES ("RV21_9","096_21_9","REV","21","9","9","Ɓaawo majjum, gooto der malaykaaɓe jeeɗiɗo jogiinooɓe jarirkon jeeɗiɗon kebbukon boneeji jeeɗiɗi cakitiiɗi, wari, baddimmi wi'i: «War mi hollee jommanjo debbo, debbo Jawgiyel.» ");
INSERT INTO fue_vpl VALUES ("RV21_10","096_21_10","REV","21","10","10","Den keewumi Ruuhu, go malaykaajo on yaarimmi dow waanne mawne towne. O hollimmi Urusaliima, wanŋarde seniine ƴiwi diga dow kammu to Alla, e jippo. ");
INSERT INTO fue_vpl VALUES ("RV21_11","096_21_11","REV","21","11","11","Tedduŋal Alla e woni der mayre. Nee jalba hande hayre rimre, e hande hayre wi'eteene yaspa, laaɓune hande daanorgal. ");
INSERT INTO fue_vpl VALUES ("RV21_12","096_21_12","REV","21","12","12","Birniwol manŋol, towuŋol e fiiltitii wanŋarde nen. Nee woodi dammuɗe sappo e ɗiɗi, dammugal fu e woodi malaykaajo. Inɗe lenyi ɓiɓɓe Isira'iila sappo e ɗiɗi, e winnii dow dammuɗe ɗen. ");
INSERT INTO fue_vpl VALUES ("RV21_13","096_21_13","REV","21","13","13","Dammuɗe tati e woni far lettugal, tati far soɓɓiire, tati far hoore fuɗo, tati bo far gorgal. ");
INSERT INTO fue_vpl VALUES ("RV21_14","096_21_14","REV","21","14","14","Birniwol wanŋarde nen e woodi kaaƴe daɗɗa sappo e ɗiɗi. Inɗe lilaaɓe Jawgiyel sappo e ɗiɗo, e winnii e majje. ");
INSERT INTO fue_vpl VALUES ("RV21_15","096_21_15","REV","21","15","15","Malaykaajo baddannooɗo am e jogii ƴommal poonnirgal, ŋal kanŋeeri, gam o foonnira wanŋarde, e dammuɗe mayre e birniwol mayre. ");
INSERT INTO fue_vpl VALUES ("RV21_16","096_21_16","REV","21","16","16","Becce mayre naay fu e foti, juutugo e yaajugo fu e foti. Malaykaajo foonni wanŋarde nen e poonnirɗum mum. Juutugo mayre waɗii kilomeeta ujune ɗiɗi e keme ɗiɗi (2200), non bo yaajugo e towugo mayre foti. ");
INSERT INTO fue_vpl VALUES ("RV21_17","096_21_17","REV","21","17","17","O foonni bo birniwol mayre, ŋol waɗi kuule hemure e lasoy ɗiɗi e naay, (144) jaka poonnol himɓe. ");
INSERT INTO fue_vpl VALUES ("RV21_18","096_21_18","REV","21","18","18","Birniwol ŋol, hayre yaspa nun mahiraa. Wanŋarde nen bo mahiraa e kanŋeeri laaɓuni, e jalba hande daanorgal laaɓuŋal. ");
INSERT INTO fue_vpl VALUES ("RV21_19","096_21_19","REV","21","19","19","Wanŋarde nen daɗɗa bombooru mum moƴƴiniraama e kaaƴe dime feere feere. Arandeere, Yaspa, ɗiɗawre, safiir, tatawre, agate, nayawre, emerooda, ");
INSERT INTO fue_vpl VALUES ("RV21_20","096_21_20","REV","21","20","20","joyawre, sardoniisi, jeego'awre, sarduwan, jeeɗiɗawre, kirisoliti, jeetatawre, haako haakoore, jeenayawre, topas, sappo'awre, kirisoparas, sappo e go'awre, yasente, sappo e ɗiɗawre, ametis. ");
INSERT INTO fue_vpl VALUES ("RV21_21","096_21_21","REV","21","21","21","Dammuɗe sappo e ɗiɗi ɗen waɗiraama e sokiyaaje daneeje sappo e ɗiɗi. Dammugal fu waɗiraa sokiyaare woore. Jayri wanŋarde nen waɗira e kanŋeeri laaɓuni, jalboori hande daanorgal laaɓuŋal. ");
INSERT INTO fue_vpl VALUES ("RV21_22","096_21_22","REV","21","22","22","Mi yi'ay suudu Alla der wanŋarde nen, gam Joomiraawo Alla mo baawɗe, e Jawgiyel nun laatii suudu Alla mayre. ");
INSERT INTO fue_vpl VALUES ("RV21_23","096_21_23","REV","21","23","23","Wanŋarde nen bukaaka naaŋe, naa bo lewru yaynana ɗum, gam tedduŋal Alla yaynanta ne, Jawgiyel laatii fitilla mayre. ");
INSERT INTO fue_vpl VALUES ("RV21_24","096_21_24","REV","21","24","24","Leyɗeele fu yahan der jayŋol mayre, laamiiɓe duuniyaaru waddan jawdi mum der mayre. ");
INSERT INTO fue_vpl VALUES ("RV21_25","096_21_25","REV","21","25","25","Dammuɗe mayre maɓɓataako nyalooma, gam jemma walaa der mayre. ");
INSERT INTO fue_vpl VALUES ("RV21_26","096_21_26","REV","21","26","26","Ɓe gaddan jawdi e tedduŋal leyɗeele der mayre. ");
INSERT INTO fue_vpl VALUES ("RV21_27","096_21_27","REV","21","27","27","Ko soɓi fu naatataa der mayre. Gaɗoowo ko sentinii, e pewoowo naatataa ton. Amma naatooɓe ton woni, ɓe inɗe mum winnaa der dewtere yonki, ne Jawgiyel. ");
INSERT INTO fue_vpl VALUES ("RV22_1","096_22_1","REV","22","1","1","Ɓaawo majjum, malaykaajo hollimmi maayo diyam yonki. Diyam ɗam e laaɓi hande daanorgal. Maayo ŋon e ƴiwa diga kittaal laamu Alla, e Jawgiyel. ");
INSERT INTO fue_vpl VALUES ("RV22_2","096_22_2","REV","22","2","2","Diyam maayo ŋon e ila caka jayri wanŋarde nen. Leggal kokkoowal yonki e tawaa fonŋo maggo ɗiɗi fu. Leggal ŋal e rima ɓikkol de sappo e ɗiɗi der duuɓol, waato de woore der lewru fu. Haako maggal e laatii lekki nyawtoohi himɓe. ");
INSERT INTO fue_vpl VALUES ("RV22_3","096_22_3","REV","22","3","3","Naaloore tawataake kade der siire nen. Kittaal laamu Alla e Jawgiyel wonoto der mayre, jaggiiɓe makko sujidanan mo. ");
INSERT INTO fue_vpl VALUES ("RV22_4","096_22_4","REV","22","4","4","Ɓe ji'an yeeso makko, inne makko winnete e tiiɗe maɓɓe. ");
INSERT INTO fue_vpl VALUES ("RV22_5","096_22_5","REV","22","5","5","Jemma walaa ton kade, ɓe kaajataake jayŋol fitilla, e jayŋol naaŋe, gam Joomiraawo Alla laatoto jayŋol maɓɓe. Ɓe laamoto faa abada. ");
INSERT INTO fue_vpl VALUES ("RV22_6","096_22_6","REV","22","6","6","Malaykaajo on wi'immi: «Haalaaji ɗii ɗo e laatii gooŋa, ɗii laatii kooliniiɗi bo. Alla Joomiraawo gattuɗo haala mum der annabiiɓe, lili malaykaajo mum gam o holla jeyaaɓe makko ko waroyta, ɓooyataa.» ");
INSERT INTO fue_vpl VALUES ("RV22_7","096_22_7","REV","22","7","7","Yeesu wi'i: «Kettinee, mii wara ɓooyataa!» Barke laatani ɗowtaniiɗo ko woni der dewtere annabaaku nee ɗo. ");
INSERT INTO fue_vpl VALUES ("RV22_8","096_22_8","REV","22","8","8","Min, Yuhaana, min nani kujje ɗee, yi'i ɗe. Ɓaawo no nanumi, ji'umi ɗe, jicciimi yeeso malaykaajo kolluɗo am ɗe, gam mi sujidana mo. ");
INSERT INTO fue_vpl VALUES ("RV22_9","096_22_9","REV","22","9","9","Amma o wi'immi: «Taa waɗu ɗum, min bo, mi laati nun jaggiiɗo hande maa, e banniraaɓe maa annabiiɓe, e ɗowtaniiɓe haalaaji gonuɗi der dewtere nee ɗo. Sujidan Alla!» ");
INSERT INTO fue_vpl VALUES ("RV22_10","096_22_10","REV","22","10","10","O wi'immi kade: «Taa suuɗu haalaaji annabaaku gonuɗi der dewtere nee ɗo, gam wakkati ɓadake. ");
INSERT INTO fue_vpl VALUES ("RV22_11","096_22_11","REV","22","11","11","Gaɗoowo ko halli, tokkoo waɗugo ko halli. Coɓuɗo, tokka waɗugo ko soɓi. Poonnitiiɗo, tokkoo waɗugo ko foonnitii. Ceniiɗo, tokkoo wonaago der senaare!» ");
INSERT INTO fue_vpl VALUES ("RV22_12","096_22_12","REV","22","12","12","Yeesu wi'i: «Kettinee, mii wara, ɓooyataa. Mi waddan barjaari gam mi warjoo moy fu deydey golle mum. ");
INSERT INTO fue_vpl VALUES ("RV22_13","096_22_13","REV","22","13","13","Min woni arano e sakitiineejo, min woni fuɗɗoode e heennyitirde.» ");
INSERT INTO fue_vpl VALUES ("RV22_14","096_22_14","REV","22","14","14","Barke laatanii loonnuɓe toggooje mum gam ɓe baawa ko nyaami ɓiɓɓe leggal yonki, ɓe naatira bo wanŋarde diga e dammuɗe! ");
INSERT INTO fue_vpl VALUES ("RV22_15","096_22_15","REV","22","15","15","Amma laatiiɓe dawaaɗi, e waɗooɓe dobo dobooje, e jeenooɓe, e warooɓe himɓe, e saafooɓe tooruuje, e yiɗuɓe fewre go e fewa fu, wonoto yaasi. ");
INSERT INTO fue_vpl VALUES ("RV22_16","096_22_16","REV","22","16","16","Min Yeesu, mi lilii malaykaajo am, o seedoo kujje ɗe der eklesiyaaji. Min woni mo lenyol Dawda, e taaniiko, min woni hoodere fajiri jalboore! ");
INSERT INTO fue_vpl VALUES ("RV22_17","096_22_17","REV","22","17","17","Ruuhu e jommanjo debbo darii e wi'a: «War!» Nanuɗo fu sey wi'a: «War!» Ɗonɗaaɗo fu, wara. Jiɗuɗo diyam yonki fu, jaɓa ɗam, yoɓataa! ");
INSERT INTO fue_vpl VALUES ("RV22_18","096_22_18","REV","22","18","18","Min, Yuhaana, mii bata moy fu, nanuɗo haala annabaaku gonuka der dewtere nee ɗo hakkila. To goɗɗo ɓeydii goɗɗum dow kujje ɗee, Alla ɓeydanan joomum boneeji batanaaɗi der mayre. ");
INSERT INTO fue_vpl VALUES ("RV22_19","096_22_19","REV","22","19","19","To goɗɗo ɓuytii goɗɗum der haalaaji dewtere annabaaku ne, Alla suttan geɗu joomum e leggal yonki, e diga wanŋarde seniine, ko batanaa der dewtere ne. ");
INSERT INTO fue_vpl VALUES ("RV22_20","096_22_20","REV","22","20","20","Ceediiɗo kujje ɗee wi'i: «E gooŋa, mii wara, ɓooyataa!» Aami! War Yeesu Joomiraawo! ");
INSERT INTO fue_vpl VALUES ("RV22_21","096_22_21","REV","22","21","21","Moƴƴere Joomiraawo meeɗen Yeesu wonda e mooɗon on fu! ");
ALTER TABLE fue_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
