﻿USE sofia;
DROP TABLE IF EXISTS sofia.frd_vpl;
CREATE TABLE frd_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES frd_vpl WRITE;
INSERT INTO frd_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Naꞌa daftar ini, na rtulis Yesus Kristus ubun a nusin ra. Yesus ubun a nusin tali Raja Daud i ubun a nusin Abraham. ");
INSERT INTO frd_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Tali Abraham ti naran Daud, na Yesus ubun a nusin ra nararira ra wean ini: Abraham yanan Ishak, Ishak yanan Yakub, Yakub yanan verin Yehuda, novun aꞌan a warin ra. ");
INSERT INTO frd_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yehuda awan verin Tamar, yanarira verin Peres ovu Zerah. Peres yanan Hezron, na Hezron yanan Ram. ");
INSERT INTO frd_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram yanan Aminadab, Aminadab yanan Nahason, Nahason yanan Salmon. ");
INSERT INTO frd_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon awan verin Rahab, yanarira verin Boas. Boas awan verin Rut, yanarira verin Obed. Obed yanan Isai. ");
INSERT INTO frd_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isai yanan verin Daud i notu raja naꞌa Israel. Daud awan verin Batsyeba, yanarira verin Salomo. Lan a Batsyeba nsifa vali ovu Uria. ");
INSERT INTO frd_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomo yanan Rehabeam, Rehabeam yanan Abia, Abia yanan Asa. ");
INSERT INTO frd_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa yanan Yosafat, Yosafat yanan Yoram, Yoram yanan Uzia. ");
INSERT INTO frd_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzia yanan Yotam, Yotam yanan Ahas, Ahas yanan Hizkia. ");
INSERT INTO frd_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hizkia yanan Manasye, Manasye yanan Amon, Amon yanan Yosia. ");
INSERT INTO frd_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosia yanan verin Yekhonya novun aꞌan a warin ra. Naꞌut inyai, na tamata Babel ra rkiwal Israel ra ma ti rnaꞌa Babel. ");
INSERT INTO frd_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Naꞌut i tamata Babel ra rkiwal Israel ra ma ti rnaꞌa roak Babel, beti Yekhonya yanan verin Sealtiel, Sealtiel yanan a Zerubabel. ");
INSERT INTO frd_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubabel yanan Abihud, Abihud yanan Elyakim, Elyakim yanan Azor. ");
INSERT INTO frd_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor yanan Zadok, Zadok yanan Akhim, Akhim yanan Eliud. ");
INSERT INTO frd_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud yanan Eleazar, Eleazar yanan Matan, Matan yanan Yakub. ");
INSERT INTO frd_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakub yanan verin Yusuf i awan verin Maria. Maria ini yanan Yesus i rfanara vali Ia ne Kristus, Raja i ntevut dida salasilan ra. ");
INSERT INTO frd_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ba Yesus ubun a nusin ovi beti tbas yai: Tali Abraham ti naran Daud, na tuvu nkati tuvu ti naran vutu rahin ifaꞌat. Tali Daud ti naran naꞌut i tamata Babel ra rkiwal Israel ra ma rti Babel, na tuvu nkati tuvu ti naran vutu rahin ifaꞌat vali. Tali naꞌut i rnaꞌa Babel ti naran i rarali Kristus, Raja i ntevut dida salasilan ra, na tuvu nkati tuvu ti naran vutu rahin ifaꞌat vali. ");
INSERT INTO frd_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yesus Kristus Ni tomu mngaꞌun a naꞌut i rarali Ia wean ini. Ia renan naran Maria. Maria ini irua Yusuf raꞌan vai isa roak mane rsifa. Ira wol rsifa obin, naꞌuk Maria nbarlewan roak, tevek ngrebat tali Ubu Ni Roh. ");
INSERT INTO frd_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yusuf ni vavaꞌat nmalola, ovu wol inan ma nfamaꞌit Maria naꞌa tamata rivun waharira ralan a, ba nanovak mane ntalik fanfonak watan ia. ");
INSERT INTO frd_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Naꞌuk ti ma Yusuf nanovak munuk wean inyai ma ntuba, na Duilaꞌa Ni sansinir isa ntali lanit ratan nma ma nfavotuk ia verin Yusuf naꞌa ni mifi a. Ia nfalak ne, “Yusuf, Daud ubun a nusin oa, deka ralam raruan ma mala Maria ma neluk awam, tevek kasikoꞌu yanat i naꞌa evun ralan yai ntali Ubu Ni Roh a. ");
INSERT INTO frd_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Maria veka nrali kasikoꞌu brana isa, ma oa ki fwanara ia ne Yesus, tevek Ia veka nsikat Ni tamata ra tali rira salasilan ra.” ");
INSERT INTO frd_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Afa avyai rvotuk munuk roak, boma rfakena afa ovi lan a Duilaꞌa nfalak verin Ni nabi a ma ntulis ne, ");
INSERT INTO frd_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Vata mnelat isa veka nbarlewan ma nrali kasikoꞌu brana isa, velik ne wol ntuba ovu brana obin. Tamata ra veka rera Ia ne Imanuel, ihin a naꞌa vai Ibrani ne, ‘Ubu novun ita.’ ” ");
INSERT INTO frd_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ti ma Yusuf nbatar, na not-orang afa ovi Duilaꞌa Ni sansinir yai nfalak verin ia. Ia nala Maria ma neluk awan, ");
INSERT INTO frd_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","naꞌuk irua wol rtuba isa ti naran i nrali kasikoꞌu brana yai. Ti ma nrali ia, na Yusuf nfanara kasikoꞌu yai ne, Yesus. ");
INSERT INTO frd_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Rarali Yesus naꞌa ahu isa naran Betlehem, naꞌa propinsi Yudea. Naꞌut inyai, na raja Herodes ntaha fareta. Rarali roak Yesus, beti tamata boku rtali wan raroa naꞌa lihir timur veli rma kota Yerusalem. Tamata avyai rira kakaꞌa dawan ma al rfaneak nara ra. ");
INSERT INTO frd_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ira rorat tamata ovi rnaꞌa inyai ne, “Kasikoꞌu yanat i beti rarali Ia yai nanaꞌa inba? Tamata Yahudi ra rira raja verin Ia. Ami amsiꞌik roak naꞌa lihir timur ne, nara isa notu faneak ne rarali roak Ia, ba amama ini ma amsangatur ma amraning Ia.” ");
INSERT INTO frd_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ti ma raja Herodes nrenar afa avyai, na sara wor watan ia. Tamata ovi rnaꞌa Yerusalem ra munuk wean vali inyai. ");
INSERT INTO frd_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ba nera Yahudi rira dawan mela falurut ra ovu dawan ovi rair Musa ni inukun ra ma rasdovu ira, beti norat ira ne, “Raja i ntevut dida salasilan ra, veka rarali Ia naꞌa inba?” ");
INSERT INTO frd_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ira rfalak ne, “Veka rarali ia naꞌa Betlehem naꞌa propinsi Yudea, tevek nabi isa ntulis roak naꞌa Surat Ralan ne, ");
INSERT INTO frd_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘O Betlehem, oa mnaꞌa arun dawan Yehuda rira lanun. Oa ahu koꞌu watan naꞌa Yehuda, naꞌuk mu dawan nlia munuk ahu ra, tevek dawan isa veka nvotuk tali oa ma nfareta ovu nsiꞌik ma lolin Ning tamata Israel ra.’ ” ");
INSERT INTO frd_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Herodes nrenar munuk afa avyai, na nera tamata kakaꞌa dawan avyai, ma rasdovu fanfonak ira. Rasdovu ira, beti norat ira ma al ndava ne, rarea nara yai lafira. ");
INSERT INTO frd_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Nata nsinir ira ma rti Betlehem, ovu nfalak verin ira ne, “Miti ma mdyava ma lolin kasikoꞌu yanat yai ne, naꞌa inba. Wean i mdyav-nala roak ia, na fyaivar verin yaꞌa, boma uti ma usangatur ma uraning vali Ia!” ");
INSERT INTO frd_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Rarenar munuk afa ovi Herodes nfalak ra, beti rti. Ira rti, na rarea ewal nara i lan rsiꞌik naꞌa lihir timur yai, ba ralarira lolin urun. Nara yai nbana ula ia tali ira, beti naꞌa teri naꞌa wan i rarali kasikoꞌu yanat yai. ");
INSERT INTO frd_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ba rti rahan ralan ma rsiꞌik kasikoꞌu yanat yai ovu renan a Maria, ma rsangatur ma raraning Ia. Nata rvadil rira sadawan ra ma rala afa ovi fyawar urun verin kasikoꞌu yanat yai. Ira rala masa ovu afa irua i fyawar ovu voarira lolin, nararira mur ovu kemenyan. ");
INSERT INTO frd_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Naꞌuk naꞌa rira mifi a, na Ubu nfalak teri ma deka rewal ira rti verin Herodes, ba rban-talik wan yai, naꞌuk rahu lingaꞌan liak watan ma rti ewal rira ahu. ");
INSERT INTO frd_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ti ma tamata ovi rira kakaꞌa dawan avyai rban-talik wan yai, na Duilaꞌa Ni sansinir isa tali lanit ratan nfavotuk tenan a verin Yusuf naꞌa mifi. Ia nfalak ne, “Yusuf! Bwatar kikyai ma movun kasikoꞌu yanat yai ovu renan a ma mifla talik wan ini ma miti Mesir. Mnyaꞌa ineri nata ti naran i ufalak ma myewal mia, tevek Herodes ndava mane nfedan Ia.” ");
INSERT INTO frd_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ovan yai, na Yusuf novun kasikoꞌu yanat yai ovu renan a ma irmunuk rti Mesir. ");
INSERT INTO frd_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ira rnaꞌa inyai ti naran i raja Herodes nmata. Afa yai nvotuk munuk, boma nfakena lahir vaivatul ovi lan Duilaꞌa nfalak verin nabi isa ma ntulis ne, “Yaꞌa era roak Yanak ma nti talik Mesir.” ");
INSERT INTO frd_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ti ma Herodes nkaꞌa roak ne, tamata kakaꞌa dawan avyai rlabir ia, na nangrova urun, ba nsinir ni suldadu ra ma ti rfedan munuk kasikoꞌu brana ovi rira varat irua nsuta, naꞌa Betlehem ovu ahu ovi rnaꞌa inyai. Herodes nkaꞌa roak ne nara yai nvotuk naꞌa amar aka, tevek norat roak tamata kakaꞌa dawan avyai. ");
INSERT INTO frd_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Afa sian ovi Herodes notu ra rfakena lahir afa ovi lan a nabi Yeremia ntulis ne, ");
INSERT INTO frd_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Tamata isa nvakar ovu nfaktanit ma vain a dawan urun naꞌa ahu isa naran Rama. Rahel nvakar yanan ra ovu nafena ma nmolu, tevek yanan ra rmata munuk roak.” ");
INSERT INTO frd_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Naꞌut i raja Herodes nmata ana, Yusuf, Maria ovu Yesus rnaꞌa Mesir obin, na Duilaꞌa Ni sansinir isa ntali lanit ratan nma ma nfavotuk tenan a verin Yusuf naꞌa mifi, ma nfalak ne, ");
INSERT INTO frd_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Herodes ovu ni tamata ovi rvolan mane rfedan kasikoꞌu yanat yai rmata munuk roak, ba bwatar ma movun ia ovu renan a ma myewal mia miti Israel rira lanun.” ");
INSERT INTO frd_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ba Yusuf nbatar ma novun kasikoꞌu yanat yai ovu renan a ma rewal ira rti Israel rira lanun. ");
INSERT INTO frd_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Naꞌuk ti ma Yusuf nrenar ne, Arkhelaus nkati roak yaman i Herodes ma nfareta naꞌa Yudea, na nbobar ma nti inyai. Nata Yusuf ni mifi isa vali ne, Ubu nfalak verin ia ma novun ni rahan teta a ma rti propinsi Galilea. ");
INSERT INTO frd_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ba rti raran ineri, na rleal ahu isa naran Nazaret. Afa yai nvotuk, boma nfakena lahir afa ovi lalan a nabi ra rfamalik roak naꞌa Raja i ntevut dida salasilan ra. Ira rfalak ne, “Tamata ra veka rfalak ne, tamata Nazaret Ia.” ");
INSERT INTO frd_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Varat ifira relak roak, na Yohanes i nbaptis tamata ra nti wan lean vu dawan naꞌa propinsi Yudea ma nfamalik Ubu Ni vaivatul ra. Ia nfalak ne, ");
INSERT INTO frd_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Myahil ma mtyalik tali bira salasilan ra, tevek sarseri roak ma Ubu nma ma nfareta tamata ra wean lahir Raja.” ");
INSERT INTO frd_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Lan ana, nabi Yesaya nfamalik roak Yohanes naꞌa Surat Ralan ne, “Tamata isa nafwak naꞌa wan lean vu dawan, ma nfalak ne, ‘Misusan lingaꞌan verin Duilaꞌa, fyamalola lingaꞌan verin Ia.’ ” ");
INSERT INTO frd_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yohanes ini ni ravit blawat i noru a, rotu tali afwatan isa naran unta, vulun ra, ovu ni ngesa a rotu tali afwatan ulin. Ni fanaꞌan a kabina ovu wenan vahan i naꞌa nangan a. ");
INSERT INTO frd_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Tamata rivun rma wan lean vu dawan yai. Boku rtali Yerusalem ovu wan ovi rnaꞌa Yudea ra munuk, ovu vali boku rtali ahu ovi rnaꞌa oar Yordan ni lihir timur ovu lihir varat a. Ira rma ma rarenar afa ovi Yohanes nfalak ra. ");
INSERT INTO frd_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ira rahil ma rtorung rira salasilan ra, ba Yohanes nbaptis ira naꞌa oar Yordan. ");
INSERT INTO frd_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Tamata rivun rtali Yahudi rira sidovung isa naran Farisi, ovu sidovung isa vali naran Saduki, rma ma rera ma Yohanes nbaptis ira. Ia nsiꞌik ira ma nfalak ne, “Hoi, mia sian urun mia wean nifa isa naran aru! Bira vavaꞌat ra wol kena ovu bira vaivatul ra. Iki nfalak verin mia ne, wean i rbaptis mia, na Ubu Ni inukun wol nkena mia? ");
INSERT INTO frd_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ba fyaturu lahir naꞌa bira vavaꞌat ra ne, myahil ma mtyalik roak tali bira salasilan ra! ");
INSERT INTO frd_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Deka minovak naꞌa ralabira ra ne, ububir-nusibira Abraham, ba Ubu veka wol nukun mia! Mryenar ma lolin afa ovi ufalak ini! Ubu bis notu watan ma Abraham yanan ra rtali vatu ovi! ");
INSERT INTO frd_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ubu Ni amar sarseri roak ma nukun tamata ra. Ni inukun a wean tamata i ntaha savi ma veka netal aa ra tali rira waꞌar ra. Aa ovi vuarira wol lolin a, na veka netal vatuk ira ma nala ira rti yafu ralan. ");
INSERT INTO frd_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ubaptis mia ovu wear ma nfaturu ne, myahil ma mtyalik roak tali bira salasilan ra ma myorang Ubu, naꞌuk Ia i veka nma yai Ni ngrebat a nlia yaꞌa. Yaꞌa wol verang a ratang Ia, ba wol inovan lahir ma aling Ni tatea ra. Ia veka nbaptis mia ovu Ni Roh a ovu yafu. ");
INSERT INTO frd_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ia wean tamata isa i ntaha fanan lafan ma al ntafi gandum. Gandum vatul ovi lolin ra nfadok-aling ira naꞌa wan i baꞌi rfadoku gandum ra naꞌa, naꞌuk ovi sian ra ovu kukan ra, nasnuri ira naꞌa yafu i wol nmat-nala.” ");
INSERT INTO frd_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Naꞌut inyai, na Yesus ntali propinsi Galilea nti oar Yordan, boma Yohanes nbaptis Ia. ");
INSERT INTO frd_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Naꞌuk Yohanes nafena. Ia nfalak ne, “Velik aba Oa bwaptis yaꞌa, tevek wol verang a ratang Oa. Notu afakinimi mwa ma mera verin yaꞌa ma ubaptis Oa i?” ");
INSERT INTO frd_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Naꞌuk Yesus nfalak verin ia ne, “Motu watan wean i ufalak yai, boma mot-orang munuk afa ovi Ubu ralan nfalak a.” Ba Yohanes norang watan ma nbaptis Ia. ");
INSERT INTO frd_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ti ma nbaptis munuk Ia ma ndata tali wear, na brian munuk lanit ratan a natvadil ma Ubu Ni Roh nsuta wean modarlaka ma ndoku tenan a. ");
INSERT INTO frd_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Nata vai isa ntali lanit ratan nma ma nfalak ne, “Ini Yaꞌa Yanak i ulobang urun Ia. Ia notu ma ralang a lolin urun.” ");
INSERT INTO frd_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ira rotu afa avyai munuk roak, beti Ubu Ni Roh novun Yesus nti wan lean vu dawan isa ma nitdawan nlabir teman Ia. ");
INSERT INTO frd_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Yesus ntolat ti naran amar vutfaꞌat, ba nablafar urun. ");
INSERT INTO frd_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ba nitdawan nma ma nlabir teman Ia ma nfalak ne, “Wean i Ubu Yanan urun Oa, na eka motu ma vatu ovi rnaꞌa afamtahan ma muan.” ");
INSERT INTO frd_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Naꞌuk Yesus nfalak ne, “Wol kena, tevek rtulis roak naꞌa Surat Ralan ne, ‘Tamata ra wol rvaꞌat tali afamtahan watan, naꞌuk rvaꞌat vali wean i rorang Ubu Ni vaivatul ra munuk.’ ” ");
INSERT INTO frd_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Nata nitdawan novun ewal Yesus ma rati Yerusalem, kota i nmerat urun, ma nfadoku Ia naꞌa Yahudi rira Rahan Dawan Falurut ni wan i karatat lia munuk a. ");
INSERT INTO frd_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ia nfalak verin Yesus ne, “Wean i Ubu Yanan urun Oa, na eka muswatil tali ini msuta, tevek rtulis roak naꞌa Surat Ralan ne, ‘Ubu veka nfareta Ni sansinir ra rtali lanit ratan ma rsiꞌik ma lolin Oa. Ira veka rvelar limarira ra ma rtada Oa, boma eam ra deka rkena vatu.’ ” ");
INSERT INTO frd_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesus nfalak verin nitdawan ne, “Naꞌuk rtulis vali roak naꞌa Surat Ralan ne, ‘Tamata ra deka rlabir teman Duilaꞌa, tevek Ia Ubu i rorang a.’ ” ");
INSERT INTO frd_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Nata, nitdawan novun ewal Yesus ma rti vuar karatat isa ni tutul ma nfaturu negara ovi rnaꞌa lanit ivavan munuk ovu rira metan ra, verin Ia. ");
INSERT INTO frd_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ia nfalak verin Yesus ne, “Yaꞌa veka ala munuk afa ovi verin Oa, wean i msangatur ma mraning Yaꞌa.” ");
INSERT INTO frd_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yesus nfalak ne, “Nitdawan, muti vatuk oa tali wahang ralan ini kikyai, tevek rtulis roak naꞌa Surat Ralan ne, ‘Msangatur ma mraning aꞌuk Duilaꞌa, mu Ubu i morang a.’ ” ");
INSERT INTO frd_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ba nitdawan nti talik lahir Yesus, na Ubu Ni sansinir ra rtali lanit ratan rma ma rfatuang Ia ma rlobang Ia. ");
INSERT INTO frd_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ti ma Yesus nrenar ne, rtaha roak Yohanes ma raꞌabuꞌi ia, na nti talik propinsi Yudea ma newal Ia nti propinsi Galilea. ");
INSERT INTO frd_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Yesus nahu ahu Nazaret ma nbana nti ahu Kapernaum ma nleal inyai. Kapernaum naꞌa danau Galilea nelan a, naꞌa Yahudi rira arun dawan isa naran Zebulon ovu arun dawan isa vali naran Naftali, rira lanun a. ");
INSERT INTO frd_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Yesus nleal inyai, boma nfakena lahir vaivatul ovi lan a Ubu nfalak verin nabi Yesaya ne, ");
INSERT INTO frd_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Arun dawan Zebulon ovu arun dawan Naftali rira lanun a, sarseri ovu danau Galilea, nanaꞌa oar Yordan ni lihir a. Tamata rivun ovi wol Yahudi ra rleal vali propinsi Galilea. ");
INSERT INTO frd_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Lan ana, tamata ra rnaꞌa dedan ralan obin, naꞌuk rarea lyawan i dawan ilaꞌa. Tamata ovi rleal wan matmatan a, ira rarea lyawan yai.” ");
INSERT INTO frd_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Naꞌut inyai vali, na Yesus nfamalik Ubu Ni vaivatul ra ma nfalak ne, “Myahil ma mtyalik tali bira salasilan ra, tevek sarseri roak ma Ubu nma ma nfareta tamata ra wean lahir Raja.” ");
INSERT INTO frd_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Amar isa, na Yesus nbana naꞌa danau Galilea nelan a, na nrea tamata irua, iyaꞌan iwarin ira. Isa naran Simon i rfanara vali ia ne, Petrus, ovu isa vali naran Andreas. Ira sinat roal ira, ba rfasuka rira jaring naꞌa inyai ma al rdava ian. ");
INSERT INTO frd_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ba Yesus nfalak verin ira ne, “Mya ma myorang Yaꞌa! Mia wol fyasuka jaring roak ma nala ian, tevek ala karya verin mia ma myair tamata ra ma rorang Yaꞌa.” ");
INSERT INTO frd_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ba rfadoku lahir rira jaring ra naꞌa inyai ma rorang Ia. ");
INSERT INTO frd_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Nata Yesus nban-ewal ma nsiꞌik tamata liak irua vali, iyaꞌan iwarin ira. Nararira Yakobus ovu Yohanes, yamarira naran Zebedeus. Ira rdoku ovu yamarira naꞌa rira kumal a ma roar rira jaring ra, na Yesus nera ira ma rorang Ia. ");
INSERT INTO frd_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ba irua rsuta talik lahir yamarira naꞌa kumal yai ma rorang Ia. ");
INSERT INTO frd_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Nata Yesus nban-lilit propinsi Galilea ma nsiair naꞌa Yahudi rira rahan falurut ra. Ia nfamalik Ubu Ni Ivar Lolin i nfalak ne, Ubu veka nfareta tamata ra wean lahir Raja. Yesus notu ma lolin vali tamata ra tali rira suhut ra, ovu notu ma lolin vali tamata ovi tenarira ra rmafun. ");
INSERT INTO frd_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ivar i nfamalik Yesus yai ti nsoru propinsi Siria roak, ba tamata rivun rma ma rtuan Ia. Ira rovun tamata ovi rira suhut ra, ovi rfarnuang wawaꞌuk ra, laklukut ra, tamata ovi nait sian ra rleal ira, ovu boku rira suhut manut a, rma ma Yesus notu ma lolin ewal ira. ");
INSERT INTO frd_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ba tamata rivun ilaꞌa rban-orang Yesus. Boku rtali Galilea, boku rtali Dekapolis, ovu boku vali rtali Yerusalem. Boku rtali propinsi Yudea, ntafal vali boku rtali oar Yordan ni lihir timur. ");
INSERT INTO frd_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ti ma Yesus nsiꞌik tamata rivun avyai, na nrata vuar isa naꞌa inyai ma ndoku. Ba Ni tamata ovi rorang Ia rti vali inyai ma irmunuk rasdovu ira. ");
INSERT INTO frd_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Nata Yesus nair ira munuk ma nfalak ne, ");
INSERT INTO frd_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Ubu naflahar tamata ovi rfakloꞌi aꞌuk rira vavaꞌat verin Ia, tevek Ia wean lahir Raja ma nfareta tamata ovi rorang Ia. ");
INSERT INTO frd_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ubu naflahar tamata ovi ralarira lalau, tevek Ia veka nfaloling ralarira ra. ");
INSERT INTO frd_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ubu naflahar tamata ovi rfakabava tenarira ra, tevek Ia veka nfakena Ni tnorung a ma nala lanit ivavan verin ira. ");
INSERT INTO frd_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ubu naflahar tamata ovi inar urun ma rira vavaꞌat ra rmalola, tevek Ia veka nala verin ira afa ovi rdava ra. ");
INSERT INTO frd_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ubu naflahar tamata ovi ralarira lolin ma rlobang tamata liak ra, tevek Ia veka nfaturu vali Ni silobang a verin ira. ");
INSERT INTO frd_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ubu naflahar tamata ovi ralarira rmerat urun, tevek ira veka rarea Ia. ");
INSERT INTO frd_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ubu naflahar tamata ovi rlobang tamata ma rotu ma malinan ewal ovu tamata liak ra, tevek Ia veka nala ira ma reluk yanan ra. ");
INSERT INTO frd_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ubu naflahar tamata ovi tamata liak ra rwi-rwa ira tevek rira vavaꞌat ra rmalola. Ia Raja Ia ma nfareta tamata avyai. ");
INSERT INTO frd_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ubu naflahar mia naꞌut i tamata liak ra rfalak sian mia ovu rwi-rwa mia, ovu vali rfalak sian mia ma rfangra narabira ra, tevek myorang Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Lalan ana, rwi-rwa vali Ubu Ni nabi ra, ba ti ma rwi-rwa mia, na ralabira lolin ovu inabira lolin watan, tevek Ia veka naval ma dawan mia naꞌa bira rala lolin a, naꞌa lanit ratan.” ");
INSERT INTO frd_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Mia ini weabira sira verin tamata ovi rnaꞌa lanit ivavan a. Wean i sira yai wol sarsiran roak, na veka myot-ewal wean inba ma sarsiran? Wol fyawan akataka roak, ba rvatuk ia ovu rta sorat watan ia. ");
INSERT INTO frd_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Mia ini weabira lyawan verin tamata ra naꞌa lanit ivavan. Mia weabira vali kota i naꞌa vuar ratan, ba wol rfonak nala ia. ");
INSERT INTO frd_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Wol tamata isa ntutun damar ma nulang teri ia ovu suran. Ia nfadoku naꞌa damar wan, boma nyeba munuk tamata ovi rnaꞌa rahan ralan a. ");
INSERT INTO frd_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Wean vali inyai naꞌa afa lolin ovi myotu ra musti lyawan verin tamata ra, boma rsiꞌik afa lolin avyai ma rfadawang Yamabira i naꞌa lanit ratan a.” ");
INSERT INTO frd_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Mia deka minovak ne, uma lanit ivavan a ma aling vatuk Musa ni inukun ra, te afa ovi nabi rair ra, naꞌuk uma ma ufakena lahir afa avyai. ");
INSERT INTO frd_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Afa i ufalak verin mia ini, kena urun! Lanit ovu lanit ivavan nanaꞌa obin, na wol huruf te vaivatul isa tali Musa ni inukun ra veka rmamu, ti naran i Ubu nfakena munuk afa ovi nfalak ra. ");
INSERT INTO frd_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ba wean inyai bi ufalak verin mia ne, iki nangal kedan watan afa ovi Ubu nfareta roak, ma nair tamata ra ma rotu vali wean inyai, na tamata yai veka koꞌu rahi lia munuk tali Ubu Ni tamata ovi rnaꞌa Ni Fareta a. Naꞌuk tamata iki watan not-orang afa ovi Ubu nfareta roak ovu nair afa avyai verin tamata liak, na tamata yai veka dawan ia naꞌa Ubu Ni Fareta a. ");
INSERT INTO frd_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ba ufalak verin mia ne, ralabira ra musti rmalola rahi dida dawan ovi rair Musa ni inukun ra, ovu tamata ovi rtali sidovung Farisi. Naꞌuk ne wahal, na wol wabira naꞌa Ubu Ni Fareta a.” ");
INSERT INTO frd_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Mia mkyaꞌa roak ne, lan a Ubu nfalak naꞌa Ni Surat Ralan verin ubud-nusid ra ne, deka msyifedan, tevek wean i tamata isa nsifedan, na musti rfaleka inukun verin ia. ");
INSERT INTO frd_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Naꞌuk ufalak verin mia ne, tamata iki watan nangrova tamata liak, na Ubu veka nukun ia. Tamata iki watan nangrihi ma nworuk-nwak tamata liak, na veka rala ia ma ndiri dawan fareta Yahudi waharira ralan ra ma rfaleka inukun verin ia. Tamata iki watan nfalak tamata liak ne, nboda-nbadi, na nahu roak lingaꞌan i nti yafwan kakiwal. ");
INSERT INTO frd_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ba wean i tamata isa mane ti nfadoku ni korban naꞌa wan i baꞌi rasnuri rira korban ra naꞌa, naꞌuk nangnanang ne, tamata isa ralan sian ia, na ");
INSERT INTO frd_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","nfadok-aling ni korban yai, ma ti notu lolin ovu tamata yai veki, beti newal ia ma ti nfadoku ni korban yai verin Ubu. ");
INSERT INTO frd_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ba wean i tamata isa nala oa nti wan i baꞌi rfaleka inukun verin tamata ra, na yarak ti motu ma lolin ewal ovu ia, ma deka ti maran wan yai. Tevek wean i wol motu ma lolin ewal ovu ia, na tamata yai veka nala oa ti verin tamata i baꞌi nfaleka inukun verin tamata ra. Tamata inukun yai veka nala oa ti ma raꞌabuꞌi oa. ");
INSERT INTO frd_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Afa i ufalak verin mia ini, kena urun! Wean i wol bwahir nala mu utan ra obin, na wol rfatalik oa tali buꞌi yai.” ");
INSERT INTO frd_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Mia mkyaꞌa roak ne, lan a Ubu nfalak naꞌa Ni Surat Ralan ne, ‘Wean i msyifa roak, na deka mtyuba ovu tamata ovi wol awabira verin ira.’ ");
INSERT INTO frd_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Naꞌuk ufalak verin mia ne, tamata iki watan wean i nsiꞌik vata isa ma kaꞌi norang ni ininan sian ma inan ma ntuba ovu vata yai, na naꞌa ralan a ntuba roak ovu vata yai. ");
INSERT INTO frd_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ba wean i matabira lihir mela notu ma myotu salasilan, na mkyivul vatuk ia. Ni lolin a matabira lihir watan, tevek wol lolin lahir ma rvatuk fatnemung tenabira naꞌa yafwan kakiwal. ");
INSERT INTO frd_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Wean inyai vali, na wean i limabira mela notu ma myotu salasilan, na myetal vatuk ia. Ni lolin a limabira lihir watan, tevek wol lolin lahir ma rvatuk fatnemung tenabira naꞌa yafwan kakiwal.” ");
INSERT INTO frd_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Ubu Ni vaivatul ra rfalak vali ne, ‘Wean i brana isa mane ntalik awan a, na ia musti nasusan ni surat sitalik veki ma nala verin ia.’ ");
INSERT INTO frd_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Naꞌuk ufalak verin mia ne, wean i brana awan ntuba ovu tamata liak, na bis ntalik ia. Naꞌuk wean i awan a wol notu sala, ma brana ntalik watan ia, na brana yai notu ma awan a notu sala, wean lahir i awan ntuba ovu tamata i wol awan verin ia. Ba wean i brana iki watan nsifa ovu vata i brana ntalik roak ia yai, na ia notu sala vali, wean lahir i ntuba ovu tamata i wol awan verin ia.” ");
INSERT INTO frd_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Mia mkyaꞌa roak ne, lan a Ubu nfalak naꞌa Ni Surat Ralan verin ubud-nusid ra ne, ‘Wean i mifwaba afa isa verin Ubu, na myot-orang lahir afa i mifwaba roak yai verin Ia.’ ");
INSERT INTO frd_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Naꞌuk ufalak verin mia ne, deka mifwaba naꞌa afaka watan. Deka myala lanit ratan al mifwaba, tevek inyai Ubu wan i ndoku ma nfareta a. ");
INSERT INTO frd_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Deka myala lanit ivavan ma al mifwaba, tevek Ubu nfareta vali naꞌa inyai. Deka myala Yerusalem ma al mifwaba, tevek inyai Raja Dawan Ni kota a. ");
INSERT INTO frd_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Deka myala ulubira ra al mifwaba, tevek wol bira ngrebat ma myotu ma bira vut van isa vali nangiar te nangtoan. ");
INSERT INTO frd_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ni lolin a, fyalak watan ne, ‘Oꞌu, yaꞌa veka otu,’ te fyalak watan ne, ‘Wahal, yaꞌa wol otu.’ Wol lolin ma mifwaba al fyangrebat bira vaivatul ra, tevek myotu wean inyai, na inyai ntali watan nitdawan a.” ");
INSERT INTO frd_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Mia mkyaꞌa roak ne, lan a Ubu nfalak naꞌa Ni Surat Ralan ne, ‘Iki not-visal matam a, na mot-visal vali matan a, ovu iki nfarofuk nifam a, na fwarofuk vali nifan a.’ ");
INSERT INTO frd_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Naꞌuk ufalak verin mia ne, deka myaval tamata ovi rotu sian mia. Wean i tamata isa ntafitil fifim mela, na mala vali fifim balit a ma ntafitil. ");
INSERT INTO frd_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Wean i tamata isa nmangadu oa ma miti fareta, tevek inan ma nala mu ravit a, na mala vali mu ravit blawat verin ia. ");
INSERT INTO frd_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Wean i tamata isa nkiwal oa ma bwara ni vnuat ra ma byana kil isa, na bwara ma ti naran kil irua. ");
INSERT INTO frd_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Wean i tamata isa nera afa tali oa, na mala verin ia, ovu wean i tamata isa inan ma ner-teri afa boku tali oa, na deka mulaꞌing ia.” ");
INSERT INTO frd_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Mia mkyaꞌa roak ne, lan a Ubu nfalak naꞌa Ni Surat Ralan ne, ‘Mlyobang tamata liak ra, naꞌuk wol inabira lahir tamata ovi rira sian mia.’ ");
INSERT INTO frd_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Naꞌuk Yaꞌa ufalak verin mia ne, mlyobang tamata ovi rira sian mia, ovu miflurut verin tamata ovi rwi-rwa mia. ");
INSERT INTO frd_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Tevek wean i mlyobang tamata ovi rira sian mia, na fyaturu roak ne, Ubu i nleal lanit ratan veka nala mia ma neluk yanan, tevek Ia notu ma lera vanan verin tamata ra munuk, velik ne sian te lolin ira. Ia nala daꞌut verin tamata ovi rira vavaꞌat ra rmalola, ovu verin tamata ovi rira vavaꞌat ra wol rmalola. ");
INSERT INTO frd_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Wean i mlyobang watan tamata ovi rlobang mia, na deka minovak ne, Ubu veka nala akataka verin mia. Velik ne tamata ovi baꞌi rera babahir kulu rira vavaꞌat ra sian, naꞌuk rlobang vali tamata ovi rlobang ira. ");
INSERT INTO frd_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Wean i mtyuli bira kida ra watan, na afa i myotu yai veka lolin lia aka? Tamata ovi wol rorang Ubu rotu vali wean inyai te wahal? ");
INSERT INTO frd_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ba dida vavaꞌat ra musti rmalola, wean Yamadida i naꞌa lanit ratan, Ia wol Ni salasilan lahir.” ");
INSERT INTO frd_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Yesus ntafal ma nfalak ne, “Msyiꞌik wabira ma lolin, boma deka fyaturu afa lolin ovi myotu ra verin tamata ra. Wean i wol myorang afa i ufalak verin mia ini, na Yamad i naꞌa lanit ratan a veka wol naval mia naꞌa bira rala lolin. ");
INSERT INTO frd_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ba wean i myala afa boku verin tamata kasian ra, na deka fyamalik verin tamata ra, wean tamata ovi rfalak afa isa, naꞌuk rotu afa liak. Deka myotu wean tamata avyai, tevek rti rahan falurut ra ovu rdiri lingaꞌan ralan ra, boma tamata liak ra rsiꞌik afa ovi rotu ra ma raraning ira. Afa i ufalak verin mia ini, kena urun! Tamata avyai enarira naꞌa roak, tevek tamata ra raraning ira, ba Ubu wol nala akataka roak verin ira. ");
INSERT INTO frd_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Naꞌuk wean i myala afa verin tamata kasian ra ovu limabira mela, na limabira balit deka nkaꞌa, ba deka fyamalik afa yai verin tamata liak. ");
INSERT INTO frd_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Myala fanfonak watan, tevek Yamabira i nkaꞌa munuk afa fanfonak ra veka naval mia naꞌa bira rala lolin.” ");
INSERT INTO frd_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Wean i miflurut, na deka myot-orang tamata ovi rfalak afa isa, naꞌuk rotu afa liak. Tamata avyai inar ma rdiri Yahudi rira rahan falurut ra te naꞌa lingaꞌan sinutun ra ma raflurut, boma tamata ra rsiꞌik ira. Ba afa i ufalak verin mia ini kena urun! Ira enarira ra rnaꞌa roak, ba Ubu wol nala akataka verin ira. ");
INSERT INTO frd_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Naꞌuk wean i mane miflurut, na miti kamar ralan ma fyolat falfolat a veki, beti miflurut verin Yamadida i wol trea Ia. Tevek Ia nsiꞌik afa fanfonak ra munuk, ovu Ia veka naval mia naꞌa bira rala lolin. ");
INSERT INTO frd_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ba ti ma miflurut, na deka tia ma watan mia naꞌa afa ovi fyalak ra, wean tamata ovi wol rorang Ubu. Ira ranovak ne, rira falurut ra blawat, ba Ubu veka nrenar ira. ");
INSERT INTO frd_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Deka myot-orang ira, tevek wol myera verin Ia obin, na Yamadida nkaꞌa roak afa ovi ralabira rfalak ra. ");
INSERT INTO frd_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Miflurut wean ini: Yamamami, Oa mdoku lanit ratan. Ami amalang Oa, tevek naram a nmerat urun. ");
INSERT INTO frd_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Mwa ovu Mu Fareta a ma fwareta ami. Fara amot-orang afa ovi ralam nfalak a naꞌa lanit ivavan a, wean lahir i naꞌa lanit ratan a. ");
INSERT INTO frd_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Amera ma mala afamtahan verin ami ma naran ma amaꞌan amar ini. ");
INSERT INTO frd_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Fara maꞌi vatuk mami salasilan ra, wean ami amabun roak tamata ovi rotu salasilan verin ami. ");
INSERT INTO frd_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Deka mtorung ma tamata te nitdawan nlabir teman ami, ba fwaroa tali ami nitdawan ovu ni siweang. Tevek Oa mtaha fareta, Oa Mua ngrebat a, ovu vanam a nfitik nyadat ma ti wol ni wahan. Kena urun! ");
INSERT INTO frd_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Wean i myabun tamata ovi rotu salasilan verin mia, na Yamadida i naꞌa lanit ratan veka naꞌi vatuk vali bira salasilan ra. ");
INSERT INTO frd_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Naꞌuk wean i mifena ma myabun tamata ovi rotu salasilan verin mia, na Yamadida i naꞌa lanit ratan veka wol naꞌi vatuk vali bira salasilan ra.” ");
INSERT INTO frd_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Wean i mtyolat, na deka myotu ma felabira ra wean tamata ovi rfalak afa isa, naꞌuk rotu afa liak. Wean i tamata avyai rtolat, na rotu ma felarira sian ovu wol rmadua tenarira ra, boma tamata ra rsiꞌik, na rtolat. Afa i ufalak verin mia ini, kena urun! Ubu veka wol nala akataka verin ira. ");
INSERT INTO frd_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ba wean i mtyolat, na msyisir bira vut ra ovu miflarut wahabira ra, ");
INSERT INTO frd_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","boma tamata ra deka rkaꞌa ne, mtyolat. Yamabira i tamata ra wol rarea Ia yai saꞌi nkaꞌa ne, mtyolat. Ia saꞌi nrea nkaꞌa munuk afa fanfonak ovi myotu ra, ba veka naval mia naꞌa bira rala lolin.” ");
INSERT INTO frd_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Deka misdovuk bira metan ra naꞌa lanit ivavan ini, tevek ngafat ovu arawan ra rot-visal ira, ovu tamata barborin ra veka rti bira rahan ra ma rbori bira metan ra. ");
INSERT INTO frd_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ni lolin ana, misdovuk bira metan ra naꞌa lanit ratan, tevek ngafat ovu arawan ra wol rnaꞌa ma rot-visal bira metan ra. Tamata barborin ra vali wol rti bira rahan ralan ma rbori bira metan ra. ");
INSERT INTO frd_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Tevek wean i fyadoku bira metan ra naꞌa wan isa, na ralabira ra veka rnaꞌa vali inyai.” ");
INSERT INTO frd_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Matadida ra reluk damar verin tenadida ra, ba wean i matabira ra lolin, na lyawan a nsoru lahir tenabira ra. ");
INSERT INTO frd_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Naꞌuk wean i matabira ra lavlova, na mnyaꞌa dedan ralan watan. Ba wean i lyawan i naꞌa tenabira ra wol lyawan roak ma dedan watan, na veka deda fafyat lahir. ");
INSERT INTO frd_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Wol tamata isa bisma nkarya verin duan irua. Ia veka wol inan lahir isa, naꞌuk nlobang isa. Te veka not-orang lalawatan afa ovi nfalak ra verin isa, naꞌuk isa wahal. Mia weabira vali inyai, ma wol bisma myala bira vavaꞌat ra verin Ubu, ovu vali myala bira vavaꞌat ra verin bira metan ra.” ");
INSERT INTO frd_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Ba ufalak verin mia ne, deka ralabira kakoꞌu naꞌa bira vavaꞌat ra, ovu bira fanaꞌan-fanenu ra. Deka ralabira kakoꞌu vali naꞌa afa ovi veka myung a myeluk ra, tevek bira vavaꞌat a fyawan lia bira fanaꞌan ra te bira kadaravit ra. ");
INSERT INTO frd_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Eka msyiꞌik manut nangan ra. Ira wol ravuri-rava nabat ra, wol rafdiar, ovu vali wol rasdovuk afamtahan naꞌa manlenan ra, naꞌuk Yamabira naꞌa lanit ratan nala afamtahan verin ira ma raꞌan. Mia wol mkyaꞌa ne, fyawabira nlia manut nangan ra, ovu Ia nlobang mia nlia manut nangan ra? ");
INSERT INTO frd_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Wean i tamata isa ralan kakoꞌu naꞌa ni vavaꞌat a, na ia veka wol ntafal amar isa vali naꞌa ni vavaꞌat a. ");
INSERT INTO frd_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Afakinimi ralabira kakoꞌu naꞌa afa ovi myung a myeluk mia i? Eka msyiꞌik aa ovi rira fafun ra naꞌa vaꞌi ra. Ira wol rkarya te rafedu ma rotu rira kadaravit ra. ");
INSERT INTO frd_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Mryenar ma lolin afa i ufalak ini! Raja Salomo nkaꞌi urun, naꞌuk ni kadaravit ovi neluk ra, wol isa vali lolin lia tali fafun avyai. ");
INSERT INTO frd_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ubu notu ria ovi rnaꞌa vaꞌi ra ma felarira lolin, velik ne amar ini rvaꞌat obin, naꞌuk ilyan te ravrua, na rasnuri roak ira. Mia fyawabira nlia munuk ira! Ia nsiꞌik mia nlia tali ria avyai. Naꞌuk wol myorang ne, Ubu nlobang mia nlia ria avyai! ");
INSERT INTO frd_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ba ralabira deka kakoꞌu naꞌa bira fanaꞌan-fanenu ra, te naꞌa kadaravit ovi veka myala ma al myung a myeluk mia. ");
INSERT INTO frd_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Tamata ovi wol rorang Ubu rdava lalawatan afa avyai, naꞌuk mia deka myotu wean inyai, tevek Yamabira i naꞌa lanit ratan nkaꞌa munuk afa ovi mdyava naꞌa bira vavaꞌat ra. ");
INSERT INTO frd_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ba mtyorung ma Ubu nfareta mia wean lahir Raja, ovu myot-orang afa ovi ralan nfalak ra. Myotu wean inyai, na Ia veka nala munuk afa ovi mdyava ra. ");
INSERT INTO frd_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ba ralabira ra deka kakoꞌu naꞌa ilyan te ravrua, tevek ilyan, na ni angangal ra rnaꞌa vali. Dida susa rivun naꞌa amar ini, ba tanovak watan amar ini.” ");
INSERT INTO frd_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Yesus nfalak ne, “Deka fyasala tamata ra, boma Ubu deka nfaleka inukun verin mia. ");
INSERT INTO frd_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Tevek Ubu veka nfaleka inukun verin mia wean lahir i fyasala tamata ra. Tevek afa i myala al myukur tamata ra, na Ubu veka nala vali al nukur mia. ");
INSERT INTO frd_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Notu afakinimi msyiꞌik aa mumun i naꞌa terabira isa matan a, naꞌuk wol msyiꞌik nala aa etal dawan i naꞌa matabira ra? ");
INSERT INTO frd_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Wean inba ma fyalak verin terabira yai ne, ‘Mwa ma aling vatuk aa mumun i naꞌa matam a,’ naꞌuk aa etal dawan a nanaꞌa matabira obin? ");
INSERT INTO frd_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Hoi, mia fyalak afa isa, naꞌuk myotu afa liak! Eka myaling vatuk aa etal dawan yai tali matabira ra veki, boma msyirea ma lolin, beti myaling vatuk aa mumun tali terabira yai matan a.” ");
INSERT INTO frd_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Deka myala afa marmerat ovi rtali Ubu verin tamata ovi wol inar ra. Tevek myala verin ira, na inyai wean i myala afa marmerat verin yaha ra, te myala mutiara ra verin vavu ra. Ira veka rta mutiara avyai, beti rewal ira ti ma rkaras mia.” ");
INSERT INTO frd_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Myera verin Ubu naꞌa afa ovi ralabira ra rfalak ra, na Ia veka nala verin mia. Mdyava urun ia, na veka mtyuan. Myevan falfolat a, na falfolat a veka natvadil verin mia. ");
INSERT INTO frd_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Tamata ovi rera verin Ubu, ira veka rala afa ovi rera yai tali Ia. Tamata ovi rdava afa ovi ralarira ra rfalak ra, ira veka rtuan vali. Tamata ovi revan falfolat a, falfolat a veka natvadil vali verin ira. ");
INSERT INTO frd_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Did tinemun, wean i yanabira nera afamtahan ma naꞌan, na veka myala vatu verin ia? ");
INSERT INTO frd_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Te wean i yanabira nera ian tali mia, na veka myala nifa verin ia? ");
INSERT INTO frd_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Velik ne bira salasilan rivun, naꞌuk mkyaꞌa ma myala afa ovi lolin ra verin yanabira ra. Ba Yamabira i naꞌa lanit ratan veka notu ma nlia tali inyai! Ia nkaꞌa lahir ma nala afa ovi lolin ra verin tamata ovi rera tali Ia. ");
INSERT INTO frd_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Ba wean i inabira ma tamata ra rotu lolin mia wean inyai, na mia musti myotu lolin vali wean inyai verin tamata ra, tevek ini nfakena lahir Musa ni inukun ra ovu afa ovi nabi rair ra.” ");
INSERT INTO frd_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Did tinemun, naꞌa bira vavaꞌat a, na myahu aꞌuk falfolat i katkotat a. Wean i myahu falfolat i ngluar a, na nti yafwan kakiwal, ma tamata rivun veka rahu lingaꞌan yai. ");
INSERT INTO frd_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Naꞌuk falfolat ovu lingaꞌan i katkotat a nti vavaꞌat kakiwal, ma tamata ifira watan rahu inyai.” ");
INSERT INTO frd_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Msyiꞌik wabira ma lolin naꞌa nabi siklabir ra. Ira rma ma rotu felarira ra wean domba, wean tamata ovi rorang Yesus. Naꞌuk ira wearira serigala ra ma rot-visal tamata rira inorang a. ");
INSERT INTO frd_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Mia mkyaꞌa lahir rira siweang ra, wean i msyiꞌik afa ovi rotu ra. Mia wol fyufu anggur vuan ra naꞌa kadkadir ralan, ovu vali wol fyufu aa ara vuan ra naꞌa karwamus ralan. ");
INSERT INTO frd_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Aa ovi lolin ra, vuarira veka lolin urun, naꞌuk aa ovi sian ra, vuarira ra veka sian vali. ");
INSERT INTO frd_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Wol mane aa ovi lolin ra, vuarira ra sian, te aa ovi sian ra vuarira ra lolin. ");
INSERT INTO frd_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ba aa ovi vuarira ra wol lolin a, na retal watan ma ti rvatuk ira, beti rasnuri ira. ");
INSERT INTO frd_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Aa avyai wearira nabi siklabir ra. Ba tali afa ovi rotu ra, na bisma mkyaꞌa ne, rsiklabir te wahal.” ");
INSERT INTO frd_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Tamata rivun veka rera Yaꞌa ne, ‘Duilaꞌa, Duilaꞌa,’ naꞌuk wol mane ira munuk ti rnaꞌa Ubu Ni Fareta a. Tamata ovi rot-orang Yamang i naꞌa lanit ratan Ni afa ovi ralan nfalak ra, na ira watan veka rnaꞌa Ni Fareta a. ");
INSERT INTO frd_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Naꞌut amar i Ubu veka nukun tamata ra, na tamata ra veka rfalak ne, ‘Duilaꞌa, wol mrenar ami ma amala naram ma amfamalik Mu vaivatul ra? Amala vali naram a al amalaꞌing vatuk nait sian ra tali tamata ra, ovu amotu mujizat rivun.’ ");
INSERT INTO frd_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Naꞌuk veka ungrihi velar ira ma ufalak ne, ‘Yaꞌa wol ukaꞌa mia! Miti vatuk mia tali wahang ralan a, tevek myotu lalawatan salasilan ra.’ ” ");
INSERT INTO frd_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Ba tamata ovi rarenar ovu rot-orang Ning vaivatul ra, na ira wearira tamata ovi rira kakaꞌa dawan ma rfadiri rira rahan ra naꞌa fanderen ngrebat i rotu tali vatu ra. ");
INSERT INTO frd_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ti ma daꞌut dawan ma wear ndata ma nbubul, ovu nait dawan a nean rahan yai, naꞌuk wol namaꞌar, tevek rfadiri ia naꞌa vatu ratan. ");
INSERT INTO frd_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Tamata ovi rarenar afa ovi ufalak ra, naꞌuk wol rot-orang, na ira wean tamata boda-badi ovi rfadiri rira rahan ra naꞌa ngur ratan. ");
INSERT INTO frd_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ba ti ma daꞌut dawan ma wear ndata ma nbubul, ovu nait dawan nean rahan yai, na rahan yai veka namaꞌar munuk.” ");
INSERT INTO frd_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesus nfalak munuk afa avyai verin ira, na tamata ovi rarenar afa ovi nair ra rtalkaka lahir, ");
INSERT INTO frd_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","tevek Yesus nsiair ovu Ubu Ni ngrebat. Yahudi rira dawan ovi rair Musa ni inukun ra, rira afa ovi rair ra wol wean afa ovi Yesus nair ra. ");
INSERT INTO frd_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ti ma Yesus nsuta tali vuar, na tamata rivun rorang Ia. ");
INSERT INTO frd_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Naꞌut inyai, na tamata i ni suhut ngabaa nma ma nsangatur naꞌa Yesus wahan ralan a, ma nfalak ne, “Duilaꞌa, wean i mtorung, na fara motu ma lolin ewal yaꞌa.” ");
INSERT INTO frd_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ba Yesus nlauk liman a ma nkena ia ma nfalak ne, “Yaꞌa utorung ma ulobang oa, ba lolin roak oa!” Brian munuk, na tamata yai lolin lahir ia tali ni suhut a. ");
INSERT INTO frd_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Nata Yesus nfalak verin ia ne, “Mungnanang ma deka fwamalik afa ini verin tamata iki watan, naꞌuk ti ma fwaturu tenam a verin mela falurut a ma nsiꞌik ne, lolin roak oa. Mala mu korban verin Ubu, wean i rfalak roak naꞌa Musa ni inukun ra, boma tamata munuk rkaꞌa ne, lolin roak oa.” ");
INSERT INTO frd_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesus nbana nti ahu Kapernaum. Roma rira suldadu dawan isa nma ma ntuan Ia, ma nera lablobang verin Ia ne, ");
INSERT INTO frd_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Duilaꞌa, yaꞌa ning tamata sansinir nawar ma dawan ia ma naklukut, ba ntuba watan rahan eri.” ");
INSERT INTO frd_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ba Yesus nfalak verin ia ne, “Baba, Yaꞌa ki uti mu rahan ma otu ma lolin ia.” ");
INSERT INTO frd_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Naꞌuk suldadu dawan yai nfalak ne, “Duilaꞌa, yaꞌa wol verang a ratang Oa, ba deka muti ning rahan. Fwalak watan vaivatul isa naꞌa ini, na ning tamata sansinir veka lolin lahir ia. ");
INSERT INTO frd_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ukaꞌa lahir ne, afa ovi fwalak ra kena, tevek usoak vali verin ning dawan a, ovu suldadu ra rsoak vali verin yaꞌa. Wean i ufareta suldadu isa ma ufalak ne, ‘Muti’, na ia nti. Wean i ufalak verin isa vali ne, ‘Mwa ini’, na ia nma. Wean i ufalak verin ning tamata sansinir a ne, ‘Mkarya afa ini’, na ia notu.” ");
INSERT INTO frd_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesus nrenar afa ovi suldadu dawan yai nfalak a, na ntalkaka, ma nfalak verin tamata ovi rban-orang Ia ne, “Afa i ufalak verin mia ini kena urun! Tamata ini ni inorang a dawan urun. Naꞌa Israel, na wol utuan tamata isa obin ni inorang a dawan wean tamata ini! ");
INSERT INTO frd_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ufalak vali verin mia ne, tamata ovi wol Yahudi ra veka rtali timur ovu rtali varat rma ma rdoku rafnaꞌan ovu Abraham, Ishak ovu Yakub, naꞌa Ubu Ni Fareta a. ");
INSERT INTO frd_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Naꞌuk, velik ne tali lalan Ubu nera tamata Yahudi ra ma rleal Ni Fareta a, Ia veka nvatuk ma rivun vali ira ti rnaꞌa dedan ralan i raroa tali Ia. Ira veka rvakar lalawatan ovu nifarira ra rsitutu ira, tevek rfarnuang wawaꞌuk i dawan a.” ");
INSERT INTO frd_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Nata Yesus nfalak verin ia ne, “Mewal oa kikyai, tevek morang urun ne, veka otu ma mu tamata sansinir yai lolin ia. Wean urun i morang yai, ba mu sansinir a lolin roak ia.” Naꞌut inyai, na tamata sansinir yai lolin lahir ia. ");
INSERT INTO frd_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Nata Yesus nti Petrus ni rahan ma nsiꞌik, na Petrus avan a ntuba watan, tevek tenan ngnea. ");
INSERT INTO frd_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ti ma Yesus ntaha vata yai liman a, na lolin lahir ia. Itvata yai nbatar lahir ma ti nasusan afamtahan verin Ia ma naꞌan. ");
INSERT INTO frd_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Yaꞌi laflofan roak, na tamata ra rovun tamata rivun rma verin Yesus. Tamata avyai nait sian ra rleal ira. Yesus nfareta nait sian ra ma rti rtalik tamata avyai, ovu notu ma tamata ovi rira suhut ra lolin ewal ira. ");
INSERT INTO frd_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Afa ovi Yesus notu ra rfakena lahir Ubu Ni vaivatul ovi nabi Yesaya ntulis roak naꞌa Surat Ralan a ne, “Ia veka nvara dida wawaꞌuk ra, ovu notu ma lolin ita tali dida suhut ra.” ");
INSERT INTO frd_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Amar isa, na tamata rivun rdir-lilit Yesus, ba nfareta Ni tamata ra ma rovun Ia rti danau Galilea ni lihir a. ");
INSERT INTO frd_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Yesus mane nti, na tamata isa tali Yahudi rira dawan ovi rair Musa ni inukun ra, nma ma nfalak verin Ia ne, “Tuan Guru, muti inba watan, na orang Oa!” ");
INSERT INTO frd_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesus nfalak verin ia ne, “Serigala ra warira ma rnaꞌa, ovu manut nangan ra rira renga, naꞌuk Yaꞌa, Tamata Yanan Yaꞌa, wol wang ma uyari Yaꞌa.” ");
INSERT INTO frd_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Nata tamata isa tali tamata ovi rorang Yesus nfalak verin Ia ne, “Duilaꞌa, fara mtorung ma ewal yaꞌa veki ti ma oving yamang a.” ");
INSERT INTO frd_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yesus nfalak verin ia ne, “Morang aꞌuk Yaꞌa! Tamata ovi wol rorang Yaꞌa, ira wearira tamata ovi rmata roak. Ba ira kaꞌi roving rira tamata ovi rmata roak a.” ");
INSERT INTO frd_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Tali inyai, na Yesus nrata ula Ia naꞌa kumal isa, beti Ni tamata ra rorang Ia rarata, ma rti talik wan yai. ");
INSERT INTO frd_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Brian munuk, na nait fufakmetan nkena ira naꞌa danau yai ralan a, ba saksakan dawan ra mane rulang ira ovu vali vaha mane nngora roak naꞌa rira kumal ralan a. Naꞌuk Yesus ntub-lufa watan. ");
INSERT INTO frd_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ni tamata ra rkadu Ia ma rfalak ne, “Duilaꞌa, bwatar ma mlobang ami! Ita mane takduvul roak ini!” ");
INSERT INTO frd_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yesus nfalak verin ira ne, “Notu afakinimi byobar i? Bira inorang a koꞌu daꞌin.” Nata Yesus ndiri ma nfareta nait ovu saksakan ra, ma rtalik ma ngarlina ma latlatan. ");
INSERT INTO frd_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ni tamata avyai rtalkaka ma rsifalak afa verin ira ne, “Tamata ini iki Ia? Ia nfaret-nala nait ovu saksakan ra ma rorang Ia!” ");
INSERT INTO frd_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yesus ovu Ni tamata ovi rorang Ia ti raran roak danau ni lihir a, naꞌa wan i tamata Gadara rleal. Raran inyai, na tamata irua nait sian ra rleal ira, rtali van ovi rfadoku tamata matmatan naꞌa rma ma rtuan Yesus. Tamata irua yai rira afa ovi rotu ra sian urun ma rfabobar tamata ra, ba tamata ra wol rabrahi ma rahu lingaꞌan yai. ");
INSERT INTO frd_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Nait sian avyai rsiꞌik Yesus ma rafwak ne, “Ubu Yanan Oa, mwa ini ma motu afaka verin ami? Deka motu sian ami, tevek Ubu Ni amar wol naran obin ma nukun ami!” ");
INSERT INTO frd_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Nata Yesus nsiꞌik tali raroa ma nrea vavu dur dawan isa rafnuak ma al rdava rira fanaꞌan naꞌa inyai. ");
INSERT INTO frd_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Nait sian avyai rera lablobang verin Yesus ne, “Wean i mane mulaꞌing ami tali tamata irua ini, na fara msinir ami ma ti amnaꞌa vavu avyai.” ");
INSERT INTO frd_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ba Yesus nfalak verin ira ne, “Miti kikyai!” Nata nait sian avyai rti talik tamata irua yai ma ti rnaꞌa vavu dur yai. Vavu avyai rafla ma rti rtobur tali biliꞌin nelan a ma rsuta danau yai, ba rakduvul ma rmata munuk. ");
INSERT INTO frd_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Tamata ovi rfawatak vavu avyai kaꞌi rsiꞌik afa avyai, ba rafla rti rira kota ma rfamalik afa avyai verin tamata ra. Ira rfamalik vali tamata irua i inlangin a nait sian ra rleal ira. ");
INSERT INTO frd_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ba ti nata tamata ovi rnaꞌa ahu yai rti munuk ma rtuan Yesus. Rarea Yesus, na rera lablobang verin Ia ma nti talik warira yai. ");
INSERT INTO frd_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesus ovu Ni tamata ovi rorang Ia rarata kumal isa ma retal danau Galilea, ma rti ahu i nleal a, naran Kapernaum. ");
INSERT INTO frd_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ira raran inyai, na tamata ifira rovun tamata laklukut isa naꞌa ni dari a, rma verin Yesus. Yesus nsiꞌik tamata avyai, na nkaꞌa lahir ne, rira inorang a dawan, ba nfalak verin tamata laklukut yai ne, “Ralam deka kakoꞌu ta baba! Yaꞌa aꞌi vatuk roak mu salasilan ra.” ");
INSERT INTO frd_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Yahudi rira dawan ovi rair Musa ni inukun ra, boku rarenar vali afa ovi Yesus beti nfalak yai, ba ranovak naꞌa ralarira ne, “Tamata ini nfalak sian Ubu, tevek Ubu saꞌi naꞌi vatuk salasilan ra!” ");
INSERT INTO frd_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Naꞌuk Yesus nkaꞌa lahir afa i ranovak naꞌa ralarira ra, ba nfalak verin ira ne, “Notu afakinimi minovak naꞌa afa sian i wean inyai? ");
INSERT INTO frd_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Inabira ma ufalak verin tamata laklukut yai ne, ‘Aꞌi vatuk roak mu salasilan ra’, te ufalak ne, ‘Mdiri ma bwana kikyai!’ Afaka maraan ma ufalak naꞌa afa irua ini? ");
INSERT INTO frd_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Yaꞌa Tamata Yanan Yaꞌa mane ufaturu verin mia, boma mkyaꞌa ne, naꞌa lanit ivavan ini Yaꞌa Ning ngrebat ma aꞌi vatuk tamata rira salasilan ra.” Ba Yesus nfalak verin tamata laklukut yai ne, “Baba, mdiri ma mlulung mu dari a ma mewal oa muti mu rahan kikyai.” ");
INSERT INTO frd_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ba ndiri ma newal ia nti ni rahan. ");
INSERT INTO frd_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ti ma tamata rivun avyai rsiꞌik afa i Yesus notu yai, na rbobar ma raraning Ubu, tevek nala roak ngrebat i wean inyai verin tamata ra. ");
INSERT INTO frd_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Nata Yesus nban-talik wan yai, na nsiꞌik tamata isa naran Matius ndoku rahan i baꞌi rera babahir kulu naꞌa. Yesus nfalak verin ia ne, “Morang Yaꞌa!” Ba Matius ndir-talik lahir ni karya ma norang Ia. ");
INSERT INTO frd_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Naꞌut inyai, na Yesus ovu tamata ovi rorang Ia rafnaꞌan naꞌa Matius ni rahan. Tamata rivun ovi baꞌi rera babahir kulu tali tamata ra, ovu tamata ovi tamata liak rfalak ira ne, tamata salasilan, rma vali ma irmunuk rafnaꞌan. ");
INSERT INTO frd_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ti ma tamata ovi rtali sidovung Farisi rsiꞌik afa yai, na rorat Yesus Ni tamata ra ne, “Afakinimi bira guru nafnaꞌan ovu tamata ovi baꞌi rera babahir kulu ovu tamata ovi rotu salasilan ra?” ");
INSERT INTO frd_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesus nrenar afa ovi rfalak yai, ba nfalak verin ira ne, “Tamata ovi wol rira suhut ra wol rti dokter, naꞌuk ovi rira suhut ra ki rti dokter. ");
INSERT INTO frd_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Myair ma fyan-aran vaivatul ovi Ubu nfalak naꞌa Ni Surat Ralan ne, ‘Yaꞌa inak ma fwaturu mu silobang verin tamata ra, nlia tali myala bira korban ra verin Yaꞌa.’ Tevek Yaꞌa wol uma ma era tamata ovi rira vavaꞌat ra rmalola, naꞌuk uma ma era tamata salasilan ra ma rorang Yaꞌa.” ");
INSERT INTO frd_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Naꞌut inyai, na tamata ovi rorang Yohanes i nbaptis tamata ra ti rtuan Yesus ma rorat Ia ne, “Baba, notu afakinimi ami ovu tamata Farisi ra amtolat, naꞌuk tamata ovi rorang Oa wol rtolat?” ");
INSERT INTO frd_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesus nala vaivatul kamkuma ma nfalak verin ira ne, “Naꞌa snobsifa isa, na brana i mane nsifa yai ni kida ra ralarira ra wol lalau ovu wol rtolat, tevek irmunuk obin. Brana i mane nsifa yai ni amar a veka nma ma rala ia, ma wol nanaꞌa roak ini. Naꞌut inyai beti rtolat.” ");
INSERT INTO frd_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Yesus nala vaivatul kamkuma irua ewal ma nfalak ne, “Wol tamata isa nlavan ni kadaravit mnanat ovu maloli ngorvaꞌan, tevek maloli ngorvaꞌan yai wol naslura obin, ba veka notu watan ma kadaravit yai ntafal ma namsat. ");
INSERT INTO frd_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Wean vali inyai ma wol tamata isa vali nliꞌi anggur ngorvaꞌan naꞌa sadawan mnanat i rotu tali karba ulin. Wean i tamata isa notu wean inyai, na sadawan veka naksat ma anggur yai nvoat, ovu sadawan yai veka sian lahir. Ba tliꞌi anggur ngorvaꞌan naꞌa sadawan ovi ngorvaꞌan ra watan, boma irua rmela ma wer isa.” ");
INSERT INTO frd_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesus nangrihi nulu Yohanes ni tamata avyai obin, na Yahudi rira dawan i nban-ulu naꞌa rira rahan falurut a nma ma nsangatur ma nsoak wahan a naꞌa Yesus wahan ralan a ma nfalak ne, “Baba, yanak vata beti nmata i. Fara mlobang ma ti fwadoku watan limam naꞌa tenan a ma nvaꞌat ewal!” ");
INSERT INTO frd_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ba Yesus ovu Ni tamata ra, irmunuk Yahudi rira dawan yai, rbana mane rti ni rahan a. ");
INSERT INTO frd_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Ira rbana obin, na vata isa, laran nvoat ma dawan daꞌin ti naran varat vutu rahin irua roak, nma ma nfaseri Yesus. Ia nanovak naꞌa ralan a ne, “Fara ukena watan Ni ravit blawat a, na lolin lahir yaꞌa!” Ba ia nahu Yesus murin a ma nkena Ni ravit wahan a. ");
INSERT INTO frd_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesus nfulak Ia ma nsiꞌik vata yai ma nfalak ne, “Titi, ralam a dawan aꞌuk! Oa morang Yaꞌa, ba lolin roak oa.” Naꞌut inyai, na lolin lahir ia. ");
INSERT INTO frd_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Nata Yesus nban-ewal nti Yahudi rira dawan yai ni rahan a. Ti naran inyai, na nsiꞌik tamata ra rafraik floꞌits ovu rvakar ma rfaktanit ma vairira dawan ilaꞌa. ");
INSERT INTO frd_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Yesus nfalak verin ira ne, “Miti kikyai, tevek kasikoꞌu vata yai wol nmata, naꞌuk ntub-lufa watan.” Ira rmalit waweang Ia, tevek rarenar afa i nfalak yai. ");
INSERT INTO frd_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ba Yesus nsinir ira ma rti murin, beti nti wan i kasikoꞌu yai ntuba ma ntaha liman a, na nvaꞌat ewal ma nbatar lahir. ");
INSERT INTO frd_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ivar yai ti nsoru munuk propinsi Galilea. ");
INSERT INTO frd_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesus nban-talik wan yai, na tamata kibu irua rorang Ia ma rafwak ne, “Oa ubum a nusim verin Raja Daud, fara fwaturu Mu silobang a verin ami!” ");
INSERT INTO frd_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ti ma Yesus nti rahan isa ralan a, na tamata kibu irua yai rorang Ia rti inyai vali. Ia norat ira ne, “Mia myorang ne, Yaꞌa bis ot-nala ma msyirea ewal?” Ira rvalat Yesus ma rfalak ne, “Duilaꞌa, ami amorang Oa!” ");
INSERT INTO frd_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ba Yesus nkena matarira ra ma nfalak ne, “Mia veka msyirea ewal, tevek bira inorang a dawan.” ");
INSERT INTO frd_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Naꞌut inyai, na rsirea lahir. Nata Yesus nsurak ira ne, “Deka fyamalik verin tamata ra naꞌa afa i beti otu yai!” ");
INSERT INTO frd_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Naꞌuk ira rti ma rfamalik watan afa yai naꞌa ahu ra munuk naꞌa propinsi Galilea. ");
INSERT INTO frd_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ira rti murin roak, na tamata ifira rovun tamata manu isa rti verin Yesus. Tamata manu yai nait sian a nleal ia. ");
INSERT INTO frd_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ti ma Yesus naling vatuk nait sian yai tali tamata manu yai, na nangrihi nala lahir. Tamata rivun ovi rnaꞌa inyai rtalkaka munuk lahir ma rfalak ne, “Yaꞌi yo! Wol trea afa i wean ini naꞌa Israel obin!” ");
INSERT INTO frd_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Naꞌuk tamata ovi rtali sidovung Farisi rfalak ne, “Ia naling vatuk nait sian ra, tevek nitdawan a nala ngrebat verin Ia.” ");
INSERT INTO frd_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesus nban-lilit ahu ra munuk, koꞌu ovu dawan, ma nsiair naꞌa Yahudi rira rahan falurut ra. Ia nfamalik Ubu Ni Ivar Lolin ne, Ubu nfareta tamata ra wean lahir Raja. Ia notu ma tamata ovi rira suhut afaka watan lolin ira, ovu notu ma lolin vali tamata ovi tenarira ra rmafun. ");
INSERT INTO frd_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ia nsiꞌik tamata rivun avyai, na nlobang urun ira ma nfaturu Ni silobang verin ira, tevek rira susa rivun ovu wol tamata ma rlobang ira, wean domba ovi wol duarira ra. ");
INSERT INTO frd_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Nata Yesus nala vaivatul kamkuma ma nfalak verin Ni tamata ra ne, “Tamata rivun avyai wearira wanat ovi rwavar ma rivun ilaꞌa roak, naꞌuk tamata ifira watan ti ma rafdiar. ");
INSERT INTO frd_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ba wean inyai, na myera verin vaꞌi duan a ma nala tamata ma ti rafdiar. Wean inyai vali, na myera verin Ubu ma ntafal tamata ma rfaivar Ni vaivatul ra verin tamata ovi wol rarenar obin.” ");
INSERT INTO frd_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesus nasdovu Ni tamata vutu rahin irua ovi rorang Ia, ma nala Ni ngrebat verin ira ma raling vatuk nait sian ra tali tamata ra, ovu rotu ma lolin tamata ra tali rira suhut afaka watan, ovu rotu ma lolin vali tamata ovi tenarira ra rmafun. ");
INSERT INTO frd_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","4","Yesus Ni tamata vutu rahin irua ovi reluk rasul nararira: Simon i rfanara ia ne, Petrus; Andreas i warin verin Simon; Yakobus irua warin a Yohanes, yamarira naran Zebedeus; Filipus; Bartolomeus; Tomas; Matius i baꞌi nera babahir kulu; Yakobus i yaman naran Alfeus; Tadeus; Simon i ntali sidovung isa naran Zelot; ovu Yudas Iskariot i nfedi Yesus. ");
INSERT INTO frd_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesus nsurak Ni tamata vutu rahin irua yai, beti nsinir ira ma rti. Ia nfalak verin ira ne, “Deka miti tamata ovi wol Yahudi ra, ovu deka miti vali tamata Samaria rira ahu ra. ");
INSERT INTO frd_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Naꞌuk miti watan tamata Israel ra, tevek rafena roak ma rorang Yaꞌa. Ira wearira domba ovi rban-sala roak. ");
INSERT INTO frd_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Miti ma fyalak verin ira ne, ‘Sarseri roak ma Ubu nma ma nfareta tamata ra wean lahir Raja.’ ");
INSERT INTO frd_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Myotu ma lolin tamata ra tali rira suhut ra, ovu fyavaꞌat ewal tamata ovi rmata roak ra. Myotu ma lolin ewal tamata ovi rira suhut ngabaa, ovu myaling vatuk nait sian ra tali tamata ra. Yaꞌa ala ngrebat verin mia, naꞌuk wol era ma byahir, ba mlyobang watan tamata ra, naꞌuk deka myera akataka tali ira. ");
INSERT INTO frd_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Miti ovu tenabira vu watan, ba deka mtyaha kubang te masa te perak. ");
INSERT INTO frd_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Naꞌa bira banbanan a, deka mtyaha sadawan. Bis watan ma mtyaha ravit, takil te tatea, naꞌuk sasan watan. Tamata ovi rkarya ra, inovan ma rala afa ovi rperlu tali tamata ovi rlobang nala roak ira. ");
INSERT INTO frd_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Wean i miti ahu te kota isa, na mdyava tamata ovi inar ma mnyaꞌa teri rira rahan ra. Mnyaꞌa teri inyai veki, ti naran i mane miti talik wan yai. ");
INSERT INTO frd_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ba wean i miti rahan isa ma milola ira, na myala salam verin ira. ");
INSERT INTO frd_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Wean i rahan duan avyai ralarira ra lolin ma mnyaꞌa teri rira rahan ra, na Ubu veka nala malinan a ma nturat ira. Naꞌuk wean i wol rtorung ma mnyaꞌa rira rahan ra, na myera verin Ubu ma deka nala malinan verin ira. ");
INSERT INTO frd_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Wean i rahan duan te ahu ra wol rtorung ma mnyaꞌa teri rira rahan ra, te rafena ma rarenar afa ovi fyalak ra, na byan-talik ira. Byan-talik ira, beti misnabar vatuk kyavu ovi rnaꞌa eabira ralan ra, tevek rafena ma rarenar afa ovi fyalak ra. ");
INSERT INTO frd_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Afa i ufalak verin mia ini, kena urun! Ba naꞌa amar i Ubu nma ma nukun tamata ra, na Ni inukun i veka nala verin tamata avyai nlia inukun i veka nala verin tamata ovi lan a rleal kota Sodom ovu Gomora.” ");
INSERT INTO frd_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Mingnanang afa ini! Usinir mia ma miti wan ovi tamata sian ra rnaꞌa. Mia weabira domba ovi rvaꞌat naꞌa serigala warira i rnaꞌa, ba fara msyiꞌik wabira ma lolin wean nifa ra, naꞌuk ralabira ra rmerat wean modarlaka ra. ");
INSERT INTO frd_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Msyiꞌik wabira ma lolin, tevek tamata ra mane rtaha ma rala mia ti verin tamata dawan ovi rfaleka inukun verin tamata ra. Ira veka rvaval vali mia naꞌa Yahudi rira rahan falurut ra. ");
INSERT INTO frd_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ira veka rala vali mia ti verin dawan fareta ra ovu raja ra, tevek myorang Yaꞌa. Naꞌut inyai, na mia veka fyamalik Yaꞌa verin ira ovu vali verin tamata ovi wol Yahudi ra. ");
INSERT INTO frd_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ti ma rtaha mia ti verin dawan i nfaleka inukun verin tamata ra, na ralabira deka kakoꞌu naꞌa afa ovi mane fyalak ra, te wean inba ma byalat ira. Tevek naꞌut inyai, na Ubu veka nala vaivatul verin mia ma mingrihi verin ira. ");
INSERT INTO frd_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ba afa ovi fyalak ra wol rtali mia, naꞌuk Yamabira Ni Roh veka nala vaivatul ra verin mia ma mingrihi. ");
INSERT INTO frd_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Naꞌut inyai, na tamata ra veka rsifedi-sikual ira. Ira veka rfedi aꞌarir-waririra ra ma tamata ra rfedan ira. Brana ra rotu vali wean inyai, ma veka rfedi yanarira ra, ovu vali yanarira ra veka rangal renarir-yamarira ra ma rala ira ti verin tamata ra ma rfedan ira. ");
INSERT INTO frd_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Tamata ra munuk veka wol inar lahir mia, tevek myorang Yaꞌa. Naꞌuk tamata ovi rorang Yaꞌa ti naran amar i rmata, na Ubu veka nsikat ira tali rira salasilan ra, boma rira vavaꞌat kakiwal. ");
INSERT INTO frd_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ba wean i miti ahu isa ma rwi-rwa mia, na miti ahu liak watan. Afa i ufalak verin mia ini, kena urun! Mia wol fyamalik Ubu Ni vaivatul ra verin tamata Israel rira ahu ra munuk obin, na Yaꞌa, Tamata Yanan Yaꞌa ini, uma ewal roak. ");
INSERT INTO frd_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Wol tamata isa ni dawan nlia ni guru a, ovu tamata sansinir ra wol rlia duarira ra. ");
INSERT INTO frd_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Naran watan ma tamata isa ni kakaꞌa veran ni guru a, ovu tamata sansinir isa ni dawan a veka veran watan duan a. Yaꞌa wean rahan duan Yaꞌa, na mia wean tamata ovi rnaꞌa rahan yai. Tamata ovi wol rorang Yaꞌa rfalak ne, Beelzebul Yaꞌa, ma uban-ulu verin nait sian ra munuk. Wean inba ovu mia? Ira veka rfalak sian mia nlia tali Yaꞌa!” ");
INSERT INTO frd_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Yesus ntafal ma nfalak ne, “Naꞌuk mia deka byobar tamata ra, tevek afa fanfonak ovi rotu ra veka rvotuk, ovu afa ovi rfonak naꞌa ralarira ra veka lyawan vali. ");
INSERT INTO frd_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Afa ovi ufalak fanfonak verin mia yai, ti fyamalik ma lyawan verin tamata ra. Te afa ovi ufifi roak naꞌa arubira ra, ti fyamalik naꞌa rahan ratan ra ma tamata rivun rarenar. ");
INSERT INTO frd_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Deka byobar tamata ovi inar ma rfedan tenabira ra, tevek wol rira ngrebat ma rvatuk bira roh a naꞌa yafwan kakiwal. Byobar aꞌuk Ubu, tevek Ia Ni ngrebat ma nfedan tenabira ra ovu not-visal vali bira roh a ma mnyaꞌa yafwan kakiwal. ");
INSERT INTO frd_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Tamata ra rfedi subit irua ma fyawarira koꞌu lalean, naꞌuk wean i Yamabira Ubilaꞌa ralan wol nfalak, na wol subit isa vali kaꞌi nleka watan nsuta lanun. ");
INSERT INTO frd_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Vut ovi rnaꞌa ulubira ra, na Ubu nrekan ovu nkaꞌa munuk vali roak. ");
INSERT INTO frd_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ba deka byobar, tevek Ubu nsiꞌik ma lolin mia. Mia fyawabira lia subit ra! ");
INSERT INTO frd_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Tamata iki watan ntorung ne, norang Yaꞌa naꞌa tamata waharira ralan ra, na Yaꞌa veka utorung vali verin Yamang naꞌa lanit ratan ne, tamata yai norang Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Naꞌuk tamata iki watan wean i nalak ia ne, wol nkaꞌa Yaꞌa naꞌa tamata waharira ralan ra, na Yaꞌa veka alak vali ia ne, wol ukaꞌa ia naꞌa Yamang wahan ralan a naꞌa lanit ratan.” ");
INSERT INTO frd_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Deka minovak ne, Yaꞌa uma lanit ivavan ini ma otu ma malinan. Wahal! Uma ma otu ma tamata ra rsingarahi. ");
INSERT INTO frd_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Yaꞌa uma ma otu ma brana ra rangal yamarira ra, ovu vata ra rangal renarira ra. Etan ra rangal vali avarira ra. ");
INSERT INTO frd_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Tamata ra veka rsingarahi ma dawan vali naꞌa rira rahan teta ra. ");
INSERT INTO frd_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Tamata iki watan i nlobang renan te yaman a nlia tali nlobang Yaꞌa, na wol fyawan lahir ma norang Yaꞌa. Tamata iki watan i nlobang yanan vata te yanan brana nlia tali nlobang Yaꞌa, na wol fyawan lahir ma norang Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Tamata i norang Yaꞌa musti ntuan susa, te nmata, wean i nvara ni aa walwalur a. Ba tamata i nafena ma nvara ni aa walwalur, na wol fyawan lahir ma norang Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Tamata iki watan kaꞌi nfikir aꞌuk ni vavaꞌat naꞌa lanit ivavan ini, na ia veka wol ni vavaꞌat kakiwal. Naꞌuk tamata iki watan wol nfikir ni vavaꞌat a, velik ne nmata, tevek norang Yaꞌa, na ia veka ni vavaꞌat kakiwal. ");
INSERT INTO frd_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Tamata iki watan notu lolin mia, na ia notu lolin roak Yaꞌa. Tamata iki watan notu lolin Yaꞌa, na ia notu lolin roak Ubu, tevek Ia nsinir Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Tamata iki watan notu lolin nabi isa tevek nabi mngaꞌun ia, na Ubu veka nkaꞌa ia, wean i nkaꞌa nabi ra. Tamata iki watan notu lolin tamata i ni vavaꞌat nmalola tevek tamata yai ni vavaꞌat nmalola, na Ubu veka nkaꞌa vali ia, wean i nkaꞌa tamata i ni vavaꞌat nmalola. ");
INSERT INTO frd_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Tamata iki watan nala wear ngneridin gelas isa verin tamata kasian isa, tevek tamata kasian yai norang Yaꞌa, na Ubu veka naval ia naꞌa ni rala lolin a.” ");
INSERT INTO frd_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Naꞌut i Yesus nair munuk roak Ni tamata vutu rahin irua ovi rorang Ia, na nban-talik wan yai ma ti nair tamata ra ovu nfamalik Ubu Ni Ivar Lolin naꞌa ahu ovi rnaꞌa propinsi Galilea. ");
INSERT INTO frd_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Naꞌut inyai, na Yohanes i nbaptis tamata ra nanaꞌa roak buꞌi ralan. Ia nrenar naꞌa afa ovi Yesus notu ra, ");
INSERT INTO frd_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ba nsinir ni tamata ifira ma ti rorat Yesus ne, “Bapa, Oa ini Raja i veka mtevut mami salasilan ra, wean i Ubu nfadoku roak naꞌa Ni tnorung a, te musti amnaban tamata liak?” ");
INSERT INTO frd_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ba Yesus nfalak verin ira ne, “Myewal mia ma fyamalik verin Yohanes naꞌa afa ovi mryenar, ovu afa ovi msyiꞌik ra. ");
INSERT INTO frd_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Tamata ovi rkibu rsirea ewal, tamata ovi raklukut rbana nala ewal. Tamata ovi rira suhut ngabaa lolin ewal ira, ovu tamata ovi raktun, rafrenar ewal. Tamata ovi rmata roak rvaꞌat ewal, ovu ufamalik Ubu Ni Ivar Lolin verin tamata ovi kasian ra. ");
INSERT INTO frd_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ubu naflahar tamata ovi ralarira ra wol raruan naꞌa rira inorang verin Yaꞌa.” ");
INSERT INTO frd_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ti ma Yohanes ni tamata ra rban-talik wan yai, na Yesus nfamalik Yohanes verin tamata rivun ovi rnaꞌa inyai. Ia nfalak ne, “Naꞌut i miti wan lean vu dawan yai ma msyiꞌik Yohanes, na minovak aka? Miti ma msyiꞌik tavtevu ovi nait nean tia ma watan ira a? Wahal! ");
INSERT INTO frd_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Inabira ma ti msyiꞌik aka? Beta ne inabira ma msyiꞌik tamata isa i neluk kadaravit ovi lolin urun a? Wahal, tevek tamata ovi reluk kadaravit lolin ra rleal raja rira rahan dawan ra. ");
INSERT INTO frd_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Inabira ma ti msyiꞌik aka? Beta ne inabira ma msyiꞌik nabi isa? Wean inyai, na kena lahir, ovu Yohanes ni dawan a nlia nabi ra. ");
INSERT INTO frd_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Tevek lan a, Ubu nfamalik ia naꞌa Ni Surat Ralan a, ma nfalak ne, ‘Ini Yaꞌa Ning tamata sansinir a, Yaꞌa usinir lan ia, beti Oa, ma nasusan Mu lingaꞌan a.’ ");
INSERT INTO frd_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Afa i ufalak verin mia ini, kena urun! Tali lalan ma naran amar ini, wol tamata isa vali ni dawan a veran lia Yohanes i nbaptis tamata ra. Naꞌuk tamata ovi rtorung ma Ubu nfareta rira vavaꞌat ra, na rira dawan a nlia Yohanes, velik ne tamata koꞌu ira watan. ");
INSERT INTO frd_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Tali amar i Yohanes betmane nfamalik Ubu Ni banbanan a, ma naran amar ini, na tamata ovi rsitaha sian ra rangal Ubu Ni Fareta a. ");
INSERT INTO frd_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Tevek Yohanes wol nma obin, na tali lalan ana, Musa ni inukun ra ovu nabi ra rfamalik roak Ubu Ni Fareta a. ");
INSERT INTO frd_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Wean i inabira ma myorang afa ovi ufalak ra, na eka mryenar. Lan ana, rfadoku roak naꞌa Surat Ralan ne, nabi Elia veka nma ewal. Velik aba, ia nfamalik Yohanes. ");
INSERT INTO frd_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Iki arun, na eka nrenar ma lolin! ");
INSERT INTO frd_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Yaꞌa veka ala vaivatul kamkuma aka ma ufamalik tamata ovi rvaꞌat naꞌa tuvu ini? Ira wearira kasikoꞌu ovi rdoku wan i rfedi-rfaha afa naꞌa, ma rafwak verin rira kida ra ne, ");
INSERT INTO frd_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Amafraik floꞌits verin mia, naꞌuk mifena ma msyoꞌi-msyomar. Amdedang dadedang ovi lalau ra, naꞌuk wol byakar.’ ");
INSERT INTO frd_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Wean inyai vali verin Yohanes i nma ma ntolat ovu wol nenu anggur a, naꞌuk rafena ia ma rfalak ne, ‘Nait sian nleal ia.’ ");
INSERT INTO frd_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Yaꞌa, Tamata Yanan Yaꞌa, uma ma ufnaꞌan ovu ufnenu. Ira rafena vali Yaꞌa, ma rfalak ne, ‘Ia nafnaꞌan sian ovu baꞌi nanavut, ovu notu kida ovu tamata ovi baꞌi rera babahir kulu ra, ovu vali notu kida ovu tamata salasilan ra!’ Velik ne wean inyai, naꞌuk tali afa ovi Ubu Ni tamata ra rotu, na tamata ra veka rsiꞌik ne, Ni kakaꞌa dawan a kena.” ");
INSERT INTO frd_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yesus ntabu tamata ovi rleal ahu ovi notu roak mujizat rivun naꞌa, tevek wol rahil ma rtalik tali rira salasilan ra obin. ");
INSERT INTO frd_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ia nfalak ne, “Sian urun i lahir verin mia tamata ovi mtyali ahu Korazim ovu ahu Betsaida! Yaꞌa otu mujizat rivun roak naꞌa bira ahu ra, naꞌuk wol myahil ma mtyalik tali bira salasilan ra obin. Lalan a, tamata ra naꞌa kota Tirus ovu Sidon rira sian a dawan urun, ovu wol rsiꞌik mujizat i wean mujizat avyai. Naꞌuk wean i otu mujizat wean avyai naꞌut lalan a naꞌa inyai, na ira rahil ma mnanat roak ma rtalik tali rira salasilan ra, ovu reluk roak kadaravit ovi rotu tali bibi vulun ra, ovu vali rdoku fun ma rfadoku kfuan naꞌa ulurira ra. ");
INSERT INTO frd_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Naꞌuk ufalak verin mia ne, naꞌa amar i Ubu veka nukun tamata ra, na inukun i nala verin tamata ovi rnaꞌa Tirus ovu Sidon maraan lia mia. ");
INSERT INTO frd_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Tamata ovi mnyaꞌa ahu Kapernaum! Mnyarin ne Ubu veka nfasaka mia ma mirata lanit ratan? Wahal lahir! Ubu veka naling vatuk mia ma ti mnyaꞌa yafwan kakiwal. Otu mujizat rivun roak naꞌa wahabira ralan ra, naꞌuk wol myahil. Wean i mujizat avyai naꞌa kota i ni sian a dawan naran Sodom, na ira rahil roak ma kota yai ndiri obin ma naran amar ini. ");
INSERT INTO frd_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Naꞌuk ufalak verin mia ne, naꞌa amar i Ubu veka nukun tamata ra, na Ni inukun i veka nala verin mia aleman lia tali inukun i veka nala verin tamata ovi rnaꞌa kota Tirus ovu kota Sidon.” ");
INSERT INTO frd_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Nata Yesus naflurut ma nfalak ne, “Duilaꞌa, Yamang Oa! Oa fwareta lanit ratan ovu lanit ivavan a! Ufalak fara weninyai verin Oa, tevek wol fwalyawang munuk afa avyai verin tamata ovi rira kakaꞌa dawan a, ovu tamata ovi rbitar ra. Naꞌuk Oa fwalyawang verin tamata ovi kaꞌi rfikir ne, ira wearira kasikoꞌu ra. ");
INSERT INTO frd_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Bapa, afa avyai rotu ma ralam lolin urun. ");
INSERT INTO frd_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Yamang nala munuk roak afakataka verin Yaꞌa. Tamata ovi rnaꞌa lanit ivavan a wol rkaꞌa Yaꞌa. Yamang aꞌuk saꞌi nkaꞌa Yaꞌa. Tamata ovi rnaꞌa lanit ivavan a vali wol rkaꞌa Yamang a. Yaꞌa aꞌuk saꞌi ukaꞌa Ia, ovu vali tamata ovi ralang a nfalak ma ufalyawang Yamang a verin ira. ");
INSERT INTO frd_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Yaꞌa era ma tamata ovi mifrea ra, ovu vali tamata ovi bira varvara aleman ra, mya boma otu ma myari mia. ");
INSERT INTO frd_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Myorang afa ovi air verin mia ovu afa ovi ufalak ra, tevek ufakabava tenang a ovu ufamafung ralang verin mia. Mia ralabira ra veka malinan vali. ");
INSERT INTO frd_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Varvara i ala verin mia yai maraan watan, ovu afa ovi ufalak ma myotu ra wol susa ma fyabana.” ");
INSERT INTO frd_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Amar isa, naꞌut i Yahudi ra ryari ira, na Yesus ovu Ni tamata ovi rorang Ia rban-etal vaꞌi gandum ra. Ira rablafar, ba rfufu gandum ni funu boku ma raꞌan. ");
INSERT INTO frd_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Tamata Farisi boku rarea ira, ba rfalak verin Yesus ne, “Msiꞌik Mu tamata ovi rorang Oa! Ira rangal dida agama ni inukun ra, ma rotu afa i wol bisma totu naꞌa amar i tyari ita!” ");
INSERT INTO frd_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yesus nfalak verin ira ne, “Mia byas roak afa ovi Raja Daud notu ra, naꞌut i ia ovu ni tamata ovi rorang ia rablafar. ");
INSERT INTO frd_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ia nti befak dawan i baꞌi raraning Ubu naꞌa. Ia nti ralan ma nala roti ovi rfadok-aling roak verin Ubu, ma ia ovu ni kida raꞌan. Naꞌuk dida inukun ra rfalak ne, mela falurut ra aꞌuk saꞌi bisma raꞌan, ba ira wol rot-orang roak dida inukun ra. ");
INSERT INTO frd_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Mia mkyaꞌa vali ne, Musa ni inukun ra rfalak ne, naꞌa amar i tyari ita, na mela falurut ra rkarya naꞌa Rahan Dawan Falurut ralan a, naꞌuk wol sala ira. ");
INSERT INTO frd_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Naꞌuk ufalak verin mia ne, naꞌa ini, na isa aꞌuk saꞌi ni dawan nlia Rahan Dawan Falurut a. ");
INSERT INTO frd_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ubu Ni Surat Ralan nfalak ne, ‘Yaꞌa inak ma fyaturu bira silobang verin tamata ra, nlia tali myala bira korban verin Yaꞌa.’ Wean i fyan-aran vaivatul avyai, na wol fyasala tamata ovi wol rotu sala ra. ");
INSERT INTO frd_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Tevek Yaꞌa, Tamata Yanan Yaꞌa, Ningu ngrebat ma ufadoku munuk afa ovi inovan ma totu naꞌa amar i tyari ita.” ");
INSERT INTO frd_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Nata Yesus nban-talik wan yai ma nati Yahudi rira rahan falurut isa ralan a. ");
INSERT INTO frd_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Naꞌa inyai, na brana isa liman lihir nmata. Tamata Farisi ra rdava mane rfasala Yesus, ba rorat Ia ne, “Dida agama ntorung ma tamata isa bis notu ma lolin tamata ra naꞌa amar i tyari ita, te wahal?” ");
INSERT INTO frd_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yesus nfalak verin ira ne, “Wean i tamata isa ni domba nleka nsuta bilaman ralan naꞌa amar i tyari ita, na veka mlyobang ma msyikat ia tali bilaman yai te wahal? ");
INSERT INTO frd_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ba wean inyai, na tamata ra fyawar lia domba ra! Ba dida agama ntorung ma bis totu afa ovi lolin ra naꞌa amar i tyari ita naꞌa.” ");
INSERT INTO frd_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Nata Yesus nfalak verin brana yai ne, “Mlauk limam a mwa!” Ba nlauk liman a, ma Yesus notu ma liman i nmata yai lolin lahir, ma wean liman lihir a. ");
INSERT INTO frd_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ba tamata Farisi ra rdir-talik wan yai ma rti murin, ma rasdovu ira al ranovak ma raꞌan vai isa mane rfedan Yesus. ");
INSERT INTO frd_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Naꞌuk Yesus nkaꞌa lahir ne, mane rotu sian Ia, ba nban-talik wan yai. Tamata rivun ilaꞌa rorang Ia, ba notu ma tamata ovi rira suhut ra lolin munuk ira. ");
INSERT INTO frd_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Naꞌuk Yesus nfalak teri ira ma deka rfamalik Ia verin tamata ra. ");
INSERT INTO frd_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Yesus notu mujizat avyai ma nfakena lahir afa ovi lan a nabi Yesaya nfalak roak naꞌa Ubu Ni Surat Ralan ne, ");
INSERT INTO frd_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ini Ning sansinir i ufili a, Ulobang urun Ia. Ia notu ma ralang a lolin urun. Yaꞌa veka ala Ning Roh verin Ia, ma nfamalik naꞌa wean inba ma tamata ra munuk rira vavaꞌat ra rmalola. ");
INSERT INTO frd_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ia veka wol nsingarahi te nafwak tia ma watan, ovu wol nangrihi ma vain a dawan naꞌa lingaꞌan ralan. ");
INSERT INTO frd_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ia veka wol nkametal tavtevu i mane nleka roak, ovu wol nfedan damar i ongan a koꞌu lalean roak, naꞌuk wol nmata obin. Ba Ning sansinir a veka nlobang tamata ovi wol rangrebat. Ia nfabana lalawatan afa ini, ti naran tamata ra rtorung ne, afa ovi notu ra kena. ");
INSERT INTO frd_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ba tali arun dawan ra munuk naꞌa lanit ivavan a, na tamata rivun veka rfakloꞌi aꞌuk rira vavaꞌat ra verin Ia.” ");
INSERT INTO frd_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Nata tamata ifira rovun brana isa rti verin Yesus. Brana yai nait sian nleal ia ma notu ma nkibu ovu nmanu, ba Yesus naling vatuk nait sian yai tali ia, ma nangrihi ovu nsirea ewal roak! ");
INSERT INTO frd_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Tamata rivun ovi rnaꞌa inyai rtalkaka munuk, ma rsifalak afa verin ira ne, “Beta ne tamata ini Raja Daud ubun te nusin i lan a Ubu nfadoku roak naꞌa Ni tnorung a.” ");
INSERT INTO frd_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ti ma tamata Farisi ra rarenar vaivatul avyai, na rfalak ne, “Tamata ini naling vatuk nait sian ra tali tamata ra, tevek nait sian rira dawan a, naran Beelzebul, nala ngrebat verin Ia.” ");
INSERT INTO frd_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Naꞌuk Yesus nkaꞌa afa ovi ranovak ra, ba nfalak verin ira ne, “Wean i rsiduk nuhu dawan isa naꞌut ifira ma sidovung ra rotu rihi, na nuhu dawan yai veka namaꞌar. Wean inyai vali wean i tamata ra rsingarahi naꞌa ahu isa te rahan teta isa, na rira ahu a te rira rahan teta a veka namaꞌar vali. ");
INSERT INTO frd_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ba nitdawan ni fareta veka wean watan inyai. Wean i nitdawan nsingarahi-sikual ovu ni nait sian ra, na ni fareta veka namaꞌar vali. ");
INSERT INTO frd_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Wean i fyalak ne, aling vatuk nait sian ra ovu ngrebat i ntali Beelzebul, na tamata ovi rorang mia yai rala ngrebat tali iki ma raling vatuk nait sian avyai? Tamata ovi rorang mia yai kaꞌi rfaturu lahir ne, sala mia. ");
INSERT INTO frd_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Naꞌuk wean i ala ngrebat tali Ubu Ni Roh ma aling vatuk nait sian ra tali tamata ra, na inyai nfaturu ne, Ubu nma roak ma nfareta tamata ra wean lahir Raja. ");
INSERT INTO frd_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Wean i tamata isa mane nti tamata ngrebat isa ni rahan ma nbori ni metan ra, na musti nkeak ia veki, beti nbor nala ni metan ra tali ni rahan a. ");
INSERT INTO frd_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Tamata iki watan wol norang Yaꞌa, na ia nangal roak Yaꞌa. Tamata iki watan wol nkarya ovu Yaꞌa, na ia not-visal Ning karya. ");
INSERT INTO frd_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ba ufalak verin mia ne, Ubu veka naꞌi vatuk tamata rira salasilan ra, velik ne rfalak sian Ia. Naꞌuk tamata iki nfalak sian Ubu Ni Roh a, na Ubu wol naꞌi vatuk roak ni salasilan ra. ");
INSERT INTO frd_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Tamata iki watan nfalak sian Yaꞌa, Tamata Yanan Yaꞌa ini, na Ubu veka naꞌi vatuk ni salasilan yai. Naꞌuk wean i nfalak sian Ubu Ni Roh a, na Ubu wol naꞌi vatuk roak ni salasilan ra, naꞌa amar ini ovu naꞌa amar ovi veka rma. ");
INSERT INTO frd_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Wean i mane mdyav-nala aa vuan ovi lolin ra, na mdyava naꞌa aa ovi lolin ra. Wean i aa ovi wol ihirira ra, na vuarira ra sian vali. Ita tkaꞌa ne, aa lolin te sian tali vuan ra. ");
INSERT INTO frd_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Hoi, mia sian urun mia weabira nifa isa naran aru, ba wean inba ma fyamalik afa ovi lolin ra? Vaivatul ra tali sumarbira ra rfaturu lahir ralabira ra. ");
INSERT INTO frd_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Tamata lolin ra rfamalik afa lolin ra, tevek ralarira ra lolin. Naꞌuk tamata ovi raktufan ra, veka rotu watan afa ovi sian ra, tevek ralarira ra rngora lahir ovu afa ovi sian ra. ");
INSERT INTO frd_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ba ufalak verin mia ne, naran amar i Ubu nma ma nukun lanit ivavan a, na lokat tamata veka kaꞌi rvara rira vaivatul ra munuk, ma rvalat Ia naꞌa rira vaivatul vu ra. ");
INSERT INTO frd_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ba Ubu veka nukun mia tali bira vaivatul ra. Wean i fyalak afa ovi lolin ra, na veka nfadoku ne, wol sala mia. Naꞌuk wean i fyalak afa ovi sian ra, na veka nfadoku vali ne, sala mia.” ");
INSERT INTO frd_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Tamata Farisi boku ovu tamata boku tali Yahudi rira dawan ovi rair Musa ni inukun ra rfalak verin Ia ne, “Tuan Guru, inamami ma motu mujizat ma nfaturu ne, Mu ngrebat a tali Ubu.” ");
INSERT INTO frd_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yesus nfalak verin ira ne, “Tamata ovi rvaꞌat naꞌa tuvu ini raktufan urun, ovu wol rot-orang Ubu Ni vaivatul ra. Ira rera ma otu faneak i tamata ra wol rot-nala, naꞌuk otu watan faneak i wean lan a Ubu notu roak verin nabi Yunus. ");
INSERT INTO frd_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Tevek Yunus nanaꞌa ian dawan isa evun ralan a, ma amar itelu ovan itelu, wean vali Yaꞌa, Tamata Yanan Yaꞌa ini, veka unaꞌa lanun ralan amar itelu ovan itelu vali. ");
INSERT INTO frd_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Naꞌut amar i Ubu veka nma ma nukun lanit ivavan a, na tamata Niniwe veka rdiri vali ovu tamata ovi rvaꞌat naꞌa tuvu ini ma rtaꞌi nuang ira, tevek tamata Niniwe avyai rahil roak ma rtalik tali rira salasilan ra naꞌut i Yunus nangrihi verin ira. Naꞌuk Ia i nanaꞌa fiang ini Ni dawan a nlia Yunus! ");
INSERT INTO frd_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Naꞌut amar i Ubu veka nukun lanit ivavan a, na ratu i ntali nuhu dawan isa i raroa ilaꞌa naꞌa tranan a, veka nma ma irmunuk tamata ovi rvaꞌat naꞌa tuvu ini. Ia veka nfaturu lahir tamata ovi rvaꞌat naꞌa tuvu ini rira sala ra. Ratu ini nma ma nrenar Raja Salomo i ni kakaꞌa dawan tali Ubu. Naꞌuk Ia i nanaꞌa fiang ini, Ni dawan a nlia Salomo!” ");
INSERT INTO frd_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Wean i nait sian nti talik roak tamata isa, na nait sian yai veka nlilin watan naꞌa wan ovi wol wear naꞌa ma ndava wan ma nyari ia, naꞌuk wol ndav-nala wan. ");
INSERT INTO frd_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ba wean inyai, na nait sian veka kaꞌi nfalak ne, ‘Yaꞌa veka ewal yaꞌa ma ti unaꞌa ewal rahan i uti talik roak ia yai!’ Ba nait sian yai newal ia nti rahan yai ma nsiꞌik, na rbitin roak ma rahan yai nmerat, ovu rasusan roak ma afakataka munuk rnaꞌa warira ra. ");
INSERT INTO frd_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ba nait sian yai novun nait sian ifitu i rira sian veran lia ia. Ira rti ma rleal tamata yai. Ti nata tamata yai ni sian veran rahi roak lan a. Wean inyai vali verin tamata ktufan ovi rvaꞌat naꞌa tuvu ini.” ");
INSERT INTO frd_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesus nangrihi verin tamata rivun avyai obin, na renan ovu warin ra rma. Ira inar ma rangrihi ovu Ia, naꞌuk rdiri watan murin. ");
INSERT INTO frd_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ba tali tamata rivun avyai, na tamata isa nfalak verin Yesus ne, “Baba, eka ti ma msiꞌik renam a ovu warim ra rdiri watan murin eri. Ira inar ma rangrihi nulu Oa.” ");
INSERT INTO frd_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yesus nfalak verin ia ne, “Yaꞌa renang iki te waring aba?” ");
INSERT INTO frd_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Nata Yesus nfaturu Ni tamata ovi rorang Ia ma nfalak ne, “Ira ini renang ovu waring ra! ");
INSERT INTO frd_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Tevek tamata iki watan not-orang afa ovi Yamang i nleal lanit ratan, ralan nfalak a, na Yaꞌa renang ovu urang a waring ira.” ");
INSERT INTO frd_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Amar yai vali, na Yesus nban-talik rahan yai ma ti ndoku danau Galilea nelan a. ");
INSERT INTO frd_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Tamata rivun ilaꞌa rma ma rdir-lilit Ia, ba nroal ma ndata kumal isa ma ndoku ralan a. Tamata rivun avyai rdiri watan ngur ratan. ");
INSERT INTO frd_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Yesus nala vaivatul kamkuma ra al nair afa rivun verin ira, ma nfalak ne, “Amar isa, na tamata vaꞌi isa nti navuri nabat ra. ");
INSERT INTO frd_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Naꞌut i navuri nabat ra obin, na boku rleka naꞌa lingaꞌan ralan, ba manut nangan ra rma ma raꞌan munuk watan. ");
INSERT INTO frd_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Nabat boku vali rleka naꞌa vatralan i lanun kadkedan watan. Wol mnanat, na nabat ra rarubu lahir, tevek lanun a masnifit watan. ");
INSERT INTO frd_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Naꞌuk ti ma lera ndirlola, na nabat ovi rarubu roak yai roarira ra rakla munuk ma rangaran, tevek wol rabwaꞌar ma lolin obin. ");
INSERT INTO frd_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Nabat boku vali rleka naꞌa kadkadir ralan. Kadkadir avyai rmel-yatak irubun ra, ma irubun ra rmata. ");
INSERT INTO frd_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Tali nabat avyai, na boku vali rleka naꞌa lanun tinemun, ba vuarira. Funu boku rira vatul ra ratratut sasan, boku vatvutun nanean ovu vali boku vatvutun taltelun. ");
INSERT INTO frd_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Iki arun, na eka nrenar ma lolin!” ");
INSERT INTO frd_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Yesus Ni tamata ovi rorang Ia rma ma rorat Ia ne, “Notu afakinimi mair tamata ra ovu vaivatul kamkuma ra?” ");
INSERT INTO frd_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yesus nfalak verin ira ne, “Ubu notu ma fyan-aran afa ovi Ia wol nfavotuk obin verin tamata ra, naꞌa i wean inba ma nfareta tamata ra wean lahir Raja. Naꞌuk verin tamata liak ra, na wol rfan-aran afa avyai. ");
INSERT INTO frd_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Tevek tamata iki watan inan ma nfan-aran Ubu Ni Fareta a, na ni kakaꞌa naꞌa Ni fareta veka ntafal ma dawan. Naꞌuk tamata iki watan wol inan ma nfan-aran Ubu Ni Fareta a, velik ne nkaꞌa kadkedan roak, na Ubu veka nala munuk kakaꞌa yai tali ia. ");
INSERT INTO frd_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Wean inyai bi air ira ovu vaivatul kamkuma ra, boma rsiꞌik afa ovi otu ra, naꞌuk wean lahir i wol rarea afa avyai. Rarenar Ning vaivatul ra, naꞌuk wean i wol rarenar ovu wol rfan-aran vali. ");
INSERT INTO frd_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ba afa ovi lan nabi Yesaya nfadoku ra nkena ira. Ia nfalak ne, ‘Ira rarenar, naꞌuk wol rfan-aran afa ovi rarenar ra. Ira rsiꞌik, naꞌuk wol rfan-aran afa ovi rsiꞌik ra. ");
INSERT INTO frd_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Tevek tamata ovi ralarira ra rasmotak, ba rsibi arurira ra ovu rkubak matarira ra, boma deka rsiꞌik ovu matarira ra, deka rarenar ovu arurira ra, ovu deka rfan-aran ovu ralarira ra. Deka rahil ma rtalik tali rira salasilan ra, ovu deka rdava Yaꞌa i bis otu ma lolin ewal ira.’ ");
INSERT INTO frd_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Naꞌuk Ubu naflahar roak mia tamata ovi myorang roak Yaꞌa, tevek msyiꞌik afa ovi otu ra, ovu vali mryenar afa ovi air ra. ");
INSERT INTO frd_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Afa i ufalak verin mia ini, kena urun! Nabi rivun ovu tamata rivun ovi rira vavaꞌat ra rmalola inar ma rsiꞌik afa ovi msyiꞌik ra, naꞌuk wol rarea. Ira inar ma rarenar afa ovi mryenar ra, naꞌuk wol rarenar afa avyai.” ");
INSERT INTO frd_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Eka mryenar ta did tinemun. Mane ufalyawang vaivatul kamkuma yai naꞌa tamata vaꞌi i navuri nabat ra. ");
INSERT INTO frd_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Nabat ovi rleka naꞌa lingaꞌan nelan, ira wearira tamata ovi rarenar Ubu Ni vaivatul ra naꞌa i wean inba ma Ubu nfareta tamata ra wean lahir Raja, naꞌuk wol rfan-aran ihin a. Ba nitdawan a nma ma nal-ewal vaivatul avyai tali ralarira ra. ");
INSERT INTO frd_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Nabat ovi rleka naꞌa vatralan, ira wearira tamata ovi rarenar Ubu Ni vaivatul ra, ma rtorung lahir ovu ralarira lolin. ");
INSERT INTO frd_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Naꞌuk ira wearira irubun ovi wol rabwaꞌar, ba wol rtahang ma mnanat. Ba ti ma rtuan susa te tamata ra rwi-rwa ira, tevek rorang Yaꞌa, na rafla talik lahir rira inorang a. ");
INSERT INTO frd_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Nabat ovi rleka naꞌa kadkadir ralan, ira wearira tamata ovi rarenar Ubu Ni vaivatul ra, naꞌuk ralarira ra raruan naꞌa afa rivun, ma inar ma rira metan rivun. Ba Ubu Ni vaivatul ra wol wan roak naꞌa ralarira ra, ma rira vavaꞌat ra wol vuarira. ");
INSERT INTO frd_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Nabat ovi rleka naꞌa lanun tinemun, ira wearira tamata ovi rarenar Ubu Ni vaivatul ra ma rfan-aran naꞌa ralarira ra, ba vuar ma dawan. Ira wearira gandum ni funu ovi rira vatul ra ratratut sasan, boku vatvutun nanean, boku vali vatvutun taltelun.” ");
INSERT INTO frd_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesus nfamalik vaivatul kamkuma isa vali verin tamata rivun avyai ne, “Ubu Ni Fareta wean tamata i navuri nabat gandum ovi lolin ra naꞌa ni vaꞌi a. ");
INSERT INTO frd_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Naꞌuk ti ma tamata ra rtub-lufa munuk, na tamata i ni sian tamata vaꞌi yai nti ma navuri yatak lavurun nabat ra naꞌa gandum avyai, beti newal ia. ");
INSERT INTO frd_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Nata ti ma gandum ra rarubu ma betmane vuarira, na lavurun ra rarubu vali naꞌa vaꞌi yai. ");
INSERT INTO frd_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Tamata sansinir ovi rkarya naꞌa vaꞌi yai rma ma rtuan tamata i ni vaꞌi yai ma rfalak ne, ‘Baba, oa muvuri nabat ovi lolin ra naꞌa mu vaꞌi a. Wean inbinimi lavurun avyai rarubu vali?’ ");
INSERT INTO frd_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ia nfalak verin ira ne, ‘Tamata isa i ni sian yaꞌa nma ma notu afa yai.’ Ba tamata sansinir avyai rorat ia ne, ‘Inam ma amati amvutuk lavurun avyai?’ ");
INSERT INTO frd_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ia nfalak ne, ‘Deka, tevek wean i byutuk lavurun avyai, na gandum ra veka ratvutuk vali. ");
INSERT INTO frd_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Mnyaban watan ma rmel-yatak ira, nata ti naran amar i tafdiar. Naꞌut inyai, na ki ufalak verin tamata ovi rafdiar ra ma rasdovuk lan lavurun avyai ma rtenak ira, beti rasnuri ira, ki rdiar gandum ra ma rasdovuk naꞌa ning syahawan a.’ ” ");
INSERT INTO frd_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesus nfamalik ewal vaivatul kamkuma liak verin ira ne, “Ubu Ni Fareta wean ini. Tamata isa nala sesawi ni vatul a, ma nava naꞌa ni vaꞌi a. ");
INSERT INTO frd_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Sesawi ni vatul yai koꞌu lia munuk tali afa ovi rira vatul ra munuk, naꞌuk ti ma narubu, na dawan lia munuk afa liak ovi rnaꞌa vaꞌi a. Sesawi nmela wean aa ma sanan ra dawan, ba manut nangan ra rti ma rotu rira renga naꞌa.” ");
INSERT INTO frd_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesus nfamalik vaivatul kamkuma liak isa ewal verin ira ne, “Ubu Ni Fareta wean ragi. Vata isa nala ragi yai ma nsileti naꞌa terigu loyang dawan isa, nata terigu yai nmela ma dawan.” ");
INSERT INTO frd_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesus nala vaivatul kamkuma ra ma nfamalik munuk afa avyai verin tamata rivun avyai. Ia wol nair ira wean i wol nala vaivatul kamkuma ra. ");
INSERT INTO frd_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ia nsiair wean inyai, boma nfakena lahir vaivatul ovi lan a nabi isa ntulis ne, “Yaꞌa veka ala vaivatul kamkuma ra ma ungrihi verin mia. Yaꞌa ufamalik afa fanfonak ovi tamata wol rkaꞌa obin, tali naꞌut i Ubu notu lanit ivavan a.” ");
INSERT INTO frd_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Nata Yesus nban-talik tamata rivun avyai ma newal Ia nti rahan ralan. Ni tamata ovi rorang Ia rma ma rfalak verin Ia ne, “Baba, eka fwalyawang vaivatul kamkuma yai naꞌa lavurun ovi rnaꞌa vaꞌi.” ");
INSERT INTO frd_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yesus nfalak ne, “Yaꞌa, Tamata Yanan Yaꞌa, uvuri nabat lolin avyai. ");
INSERT INTO frd_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Vaꞌi yai wean lanit ivavan a. Nabat ovi lolin, inyai tamata ovi Ubu nfareta ira. Lavurun avyai wean tamata ovi nitdawan nfareta ira. ");
INSERT INTO frd_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Tamata i ni sian tamata vaꞌi yai, nitdawan ia. Ia navuri lavurun vatul avyai. Amar fadiar yai nfaturu amar i lanit ivavan veka namwear. Tamata fadiar avyai, Ubu Ni sansinir ra tali lanit ratan. ");
INSERT INTO frd_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ba wean lavurun ovi rasdovuk ma rasnuri ira naꞌa yafralan, na wean inyai vali naꞌut amar i lanit ivavan veka namwear. ");
INSERT INTO frd_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Yaꞌa, Tamata Yanan Yaꞌa veka usinir Ning sansinir ra tali lanit ratan ma rma lanit ivavan ini. Ira veka rasdovu munuk tamata ovi rweang tamata ra ma rotu salasilan ra, ovu vali tamata ovi rotu afa ovi sian ra, ma ralaꞌing ira tali Ning Fareta. ");
INSERT INTO frd_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Sansinir avyai veka rvatuk ira rti yafwan kakiwal. Naꞌa inyai, na veka rvakar ma dawan ovu nifarira ra rsitutu ira tevek rfarnuang wawaꞌuk i dawan a. ");
INSERT INTO frd_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Naꞌuk tamata ovi rira vavaꞌat ra rmalola veka vanar wean lera naꞌa Yamarira Ubilaꞌa, Ni Fareta a. Iki arun, na eka nrenar ma lolin!” ");
INSERT INTO frd_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Ubu Ni Fareta wean metan ovi fyawarira ma roving fanfonak ira naꞌa vaꞌi isa. Tamata isa nma ma nrea metan avyai, na noving fanfonak ewal. Ralan a lolin urun ma nti ma nfedi munuk ni metan ra ma nfaha vaꞌi yai. ");
INSERT INTO frd_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Vaivatul kamkuma isa vali nfalak ne, Ubu Ni Fareta wean vali tamata i nfedi-nfaha afa ma ndava mutiara ovi fyawarira ra. ");
INSERT INTO frd_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ba ti ma nrea mutiara isa i fyawan dawan a, na ti ma nfedi ni metan ra munuk, ma ti nfaha mutiara yai.” ");
INSERT INTO frd_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Ubu Ni Fareta wean tamata ovi rfalau jaring naꞌa danau, ma nala ian rivun. ");
INSERT INTO frd_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ti ma jaring nala ma rivun roak, na raravut jaring rara ngur ratan, ma rdoku rtakal ian ra. Ira rasdovuk ian ovi lolin ra naꞌa ahir ra, naꞌuk rvatuk watan ian ovi sian ra. ");
INSERT INTO frd_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Wean inyai vali naꞌut amar i lanit ivavan veka namwear. Ubu Ni sansinir ra tali lanit ratan veka rma ma raling tamata ovi lolin ra tali tamata sian ra. ");
INSERT INTO frd_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Nata sansinir avyai veka rvatuk tamata sian ra ma ti rnaꞌa yafwan kakiwal. Naꞌa inyai, na veka rvakar ma dawan ovu nifarira ra rsitutu ira, tevek rfarnuang wawaꞌuk i dawan a. ");
INSERT INTO frd_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Wean inba? Fyan aran munuk afa avyai te wahal?” Ira rvalat ma rfalak ne, “Oꞌu, amfan-aran.” ");
INSERT INTO frd_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ba Yesus nfalak verin ira ne, “Tamata ovi rair Musa ni inukun ra ovu rorang roak Ubu Ni Fareta a, na ira wearira tamata isa i ni rahan. Ia nala metan ovi ngorvaꞌan ra, ovu mnanat ra tali wan i baꞌi nfadoku metan ra naꞌa.” ");
INSERT INTO frd_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesus nfamalik munuk vaivatul kamkuma avyai, beti nban-talik wan yai. ");
INSERT INTO frd_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ti ma naran Ni ahu livur a, na Yesus nair tamata ra naꞌa rira rahan falurut. Ira rarenar afa ovi nair ra, ba rtalkaka ma rfalak ne, “Ia nkaꞌa afa avyai tali inba? Iki nala ngrebat verin Ia ma not-nala mujizat ra? ");
INSERT INTO frd_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ita tkaꞌa basil ne, Ia yaman a tukan kayu ia, na renan a naran Maria. Warin ra nararira Yakobus, Yusuf, Simon ovu Yudas. ");
INSERT INTO frd_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ita tkaꞌa vali ne, itmunuk uran ra! Ba nala ni kakaꞌa ovu ngrebat tali inba ma notu mujizat ra?” ");
INSERT INTO frd_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ba rangrova Ia ma rafena ma rorang Ia. Yesus nfalak verin ira ne, “Tamata ra ralang nabi isa naꞌa wan inba watan, naꞌuk wol ralang ia naꞌa ni ahu, ovu naꞌa ni rahan teta, ovu ni tiniman ra wol ralang vali ia.” ");
INSERT INTO frd_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Yesus wol notu mujizat rivun naꞌa inyai, tevek wol rorang Ia. ");
INSERT INTO frd_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Naꞌut inyai, na tamata i ntaha fareta naꞌa propinsi Galilea naran Herodes. Ia nrenar roak afa ovi Yesus notu ra, ");
INSERT INTO frd_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ba nfalak verin tamata ovi rkarya verin ia ne, “Yohanes i nbaptis tamata ra nvaꞌat ewal roak tali matmatan, ba ni ngrebat ma not-nala mujizat ra.” ");
INSERT INTO frd_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Herodes nfalak wean inyai, tevek lan ana, nfareta ma rtaha Yohanes ma rkeak ia, beti rovun ia ti rfadoku ia naꞌa buꞌi ralan. Herodes notu wean inyai, tevek awan a Herodias. Herodes nala roak warin i Filipus awan a, Herodias, ma neluk awan. ");
INSERT INTO frd_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ba Yohanes nfalak lalawatan verin Herodes ne, “Wol bisma msifa ovu ia, tevek motu wean inyai, na mangal roak Ubu Ni inukun ra!” ");
INSERT INTO frd_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Velik aba, Herodes inan ma nfedan Yohanes, naꞌuk tamata rivun rnaꞌa inyai, ba nbobar, tevek ira rfalak ne, Yohanes nabi ia. ");
INSERT INTO frd_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Naꞌut i Herodes ni amar vulan kena, na ia notu snoba. Herodias yanan vata nti snoba ralan ma nsoꞌi-nsomar naꞌa mangun waharira ralan ra, ma notu ma Herodes inan urun. ");
INSERT INTO frd_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ba Herodes nafwaba lahir verin vata mnelat yai ne, “Mera afaka watan tali yaꞌa, na veka ala verin oa.” ");
INSERT INTO frd_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Vata yai renan a nsinir ia ma nfalak verin Herodes ne, “Era ma fwadoku Yohanes i nbaptis tamata ra, ulun a, naꞌa binan dawan isa ma mala verin yaꞌa.” ");
INSERT INTO frd_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ti ma Herodes nrenar afa yai, na ralan lalau urun, naꞌuk nafwaba roak ma ni mangun ra rarenar. Ba nfareta ni tamata ra ma rot-orang afa i vata mnelat yai nera a. ");
INSERT INTO frd_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ba nsinir ni suldadu ra rti ma rvangal Yohanes ulun a. ");
INSERT INTO frd_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Nata rfadoku ulun a naꞌa binan dawan isa, beti rala verin vata mnelat yai, ma ntaha ti verin renan a. ");
INSERT INTO frd_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Yohanes ni tamata ovi rorang ia rarenar ne nmata roak, ba rti ma rala tbunan a ma ti rfanuba naꞌa van isa ralan. Nata ti ma rfamalik verin Yesus. ");
INSERT INTO frd_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ti ma Yesus nrenar ivar ne, Yohanes nmata roak, na nrata kumal isa ma aksa Ia nti wan lean vu isa. Naꞌuk tamata rivun rarenar ne Yesus nti roak, ba rbana earira rtali rira ahu ra ma rorang Ia. ");
INSERT INTO frd_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesus nda ma nsuta tali kumal ma nsiꞌik tamata rivun avyai, na nfaturu Ni silobang verin ira, ba notu ma tamata ovi rira suhut ra lolin ewal ira. ");
INSERT INTO frd_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Yaꞌi laflofan roak, ba Yesus Ni tamata ovi rorang Ia rma ma rfalak verin Ia ne, “Wol tamata rleal wan lean vu ini ovu yaꞌi laflofan roak. Ba ni lolin a, msinir tamata rivun avyai ma rti ahu ovi sarseri ra ma rfaha rira afamtahan.” ");
INSERT INTO frd_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yesus nfalak verin ira ne, “Tamata rivun avyai deka rti. Mia musti fyaꞌan ira!” ");
INSERT INTO frd_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ira rfalak ne, “Ami amtaha watan roti ilima ovu ian irua.” ");
INSERT INTO frd_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ba Yesus nfalak ne, “Mtyaha ian ovu roti avyai mya ini.” ");
INSERT INTO frd_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Nata nsinir tamata rivun avyai ma rdoku ngrova yanat ratarira ra. Yesus nala roti ilima ovu ian irua yai, beti ntadata nrata lanit ma nfalak fara weninyai verin Ubu. Ia notu munuk wean inyai, beti nvisul roti ovu ian avyai ma nala verin Ni tamata ovi rorang Ia, boma rti rsiduk verin tamata rivun avyai. ");
INSERT INTO frd_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Tamata avyai munuk rafnaꞌan ma evurira rveda. Rafnaꞌan munuk roak, beti rasdovuk roti ovu ian teran ra naꞌa ahir vutu rahin irua rngora. ");
INSERT INTO frd_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Tali tamata ovi rafnaꞌan ra, na rarekan brana ra watan, na kaꞌa bi rivun ilima. Wol rarekan vata ovu kasikoꞌu ra obin. ");
INSERT INTO frd_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Nata Yesus nsinir lahir Ni tamata ovi rorang Ia ma ravul kumal yai ma ula ira rti Danau Galilea ni lihir a. Yesus nfalak ma tamata rivun avyai rewal aꞌuk ira. ");
INSERT INTO frd_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ia nfalak ma rewal ira, beti nvaꞌal vuar isa naꞌa inyai ma naflurut. Ovan roak, na aksa Ia nanaꞌa watan inyai obin. ");
INSERT INTO frd_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Kumal i Ni tamata ra ravul yai natlitir ma nfaroa ngur a, ma ti rnaꞌa roak danau ni fruan a. Nait dawan a nangal ira ma saksakan ra rfari kumal yai tia ma watan. ");
INSERT INTO frd_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Nfadaꞌing amar, na Yesus nroal ma nbana naꞌa wear ratan ma ntuan ira. ");
INSERT INTO frd_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ni tamata ra rarea Ia nbana naꞌa wear ratan, ba rbobar urun i lahir ma rafwak ne, “Yaꞌi yo, ini nitu ngran a!” ");
INSERT INTO frd_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Yesus nfalak lahir verin ira ne, “Ralabira ra deka kakoꞌu, tevek ini Yaꞌa, ba deka byobar!” ");
INSERT INTO frd_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ba Petrus nfalak verin Ia ne, “Duilaꞌa, wean i Oa mnaꞌa urun inyai, na msinir yaꞌa ma ubana naꞌa wear ratan ma uti wan i mnaꞌa yai.” ");
INSERT INTO frd_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ba Yesus nfalak ne, “Mwa ini kikyai!” Petrus nsuta tali kumal yai ma nbana roak naꞌa wear ratan mane ti ntuan Yesus. ");
INSERT INTO frd_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Naꞌuk nfarnuang nait dawan a, ba nbobar urun ma tenan a nsuta lahir wear ralan. Ia nafwak ne, “Duilaꞌa, mlobang yaꞌa!” ");
INSERT INTO frd_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ba Yesus nlauk lahir liman a ma ntaha ia, ma nfalak ne, “Mu inorang a kakoꞌu obin. Notu afakinimi ralam raruan naꞌa Yaꞌa i?” ");
INSERT INTO frd_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ti ma Yesus irua Petrus rarata kumal yai, na nait ntalik lahir. ");
INSERT INTO frd_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ni tamata ra rsangatur ma raraning Ia naꞌa kumal ralan yai ma rfalak ne, “Oa Ubu Yanan urun Oa!” ");
INSERT INTO frd_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Yesus ovu Ni tamata ovi rorang Ia retal roak danau Galilea, ma rda raran ngur tavun i rfanara ia ne, Genesaret. ");
INSERT INTO frd_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Tamata ovi rnaꞌa inyai ref nala roak Yesus, ba ti rfaivar verin ahu ovi rfaseri wan yai. Ba tamata ra rvara munuk tamata ovi rira suhut ra rma verin Yesus. ");
INSERT INTO frd_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ira rera verin Yesus ma fara rkena watan Ni ravit blawat wahan a. Ba tamata ovi rkena Ni ravit blawat a, lolin munuk ira. ");
INSERT INTO frd_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Amar isa, na tamata boku tali Yahudi rira sidovung isa naran Farisi ovu tamata boku vali tali Yahudi rira dawan ovi rair Musa ni inukun ra, rtali Yerusalem rma ma rtuan Yesus. Ira rorat ne, ");
INSERT INTO frd_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Afakinimi Mu tamata ovi rorang Oa rangal dida adat ovi rtali ubud-nusid ra? Ira rafnaꞌan, naꞌuk wol raraming limarira ra obin.” ");
INSERT INTO frd_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesus nfalak ne, “Afakinimi myangal vali Musa ni inukun ra ma myorang aꞌuk bira adat ovi rtali ububir-nusibira ra? ");
INSERT INTO frd_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ubu nfalak ne, ‘Myalang renabir-yamabira ra.’ Ia nfalak vali ne, ‘Tamata iki watan nfalak sian renan a te yaman a, na musti rfedan ia.’ ");
INSERT INTO frd_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Naꞌuk mia fyalak ne, tamata iki watan wean i nfalak verin renan te yaman a ne, ‘Mane ala afa boku verin mia ma al ulobang mia, naꞌuk ala roak verin Ubu.’ ");
INSERT INTO frd_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ba tamata yai wol nalang roak renan a ovu yaman a. Wean inyai, na fyaturu lahir ne, wol fyabana roak Ubu Ni vaivatul ra, tevek myorang aꞌuk bira adat ra. ");
INSERT INTO frd_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Mia baꞌi msyiklabir ma fyalak afa isa, naꞌuk myotu afa liak! Afa ovi lan ana, nabi Yesaya ntulis roak naꞌa Surat Ralan a, nfamalik lahir mia. ");
INSERT INTO frd_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Yesaya nfalak ne, ‘Tamata ovi rfadawang Yaꞌa ovu rira vaivatul ra, naꞌuk ralarira ra raroa tali Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ira raraning Yaꞌa, naꞌuk wol ihin lahir, tevek afa ovi rair ra wol rtali Ubu, naꞌuk rtali watan tamata.’ ” ");
INSERT INTO frd_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yesus nera ewal tamata rivun avyai ma nfalak verin ira ne, “Eka mryenar ma lolin boma fyan-aran. ");
INSERT INTO frd_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Afa ovi mian ra wol rfangra mia. Naꞌuk vaivatul ovi rtali sumarbira ra saꞌi rfangra mia.” ");
INSERT INTO frd_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ba Yesus Ni tamata ra rma ma rorat Ia ne, “Baba, Oa wol mkaꞌa ne, afa ovi fwalak avyai rotu ma tamata Farisi ra rangrova?” ");
INSERT INTO frd_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","14","Ba Yesus nfalak verin ira ne, “Deka ralabira raruan naꞌa tamata avyai! Ira wean afa ovi Yamang a naꞌa lanit ratan wol nfau ra, ma veka ratvutuk watan. Ira tamata dawan ira ma rban-ulu verin tamata ra, naꞌuk ira wearira tamata ovi matarira ra rkibu. Wean i tamata kibu isa nfabana tamata kibu liak, na irua veka rleka rsuta bilaman ralan.” ");
INSERT INTO frd_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Petrus nfalak verin Yesus ne, “Baba, fwalyawang vaivatul kamkuma yai verin ami.” ");
INSERT INTO frd_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesus nfalak verin ira ne, “Ba mia wol fyan-aran obin? ");
INSERT INTO frd_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Wol fyan-aran obin ne, afamtahan ra rahu tamata sumarn ma nsuta evun ralan, beti ntimuri vatuk? ");
INSERT INTO frd_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Naꞌuk vaivatul ovi rtali tamata sumarn a ma rti murin, inyai ntali tamata ralan a, ma saꞌi rfangra ia. ");
INSERT INTO frd_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Tevek afa ovi rtali tamata ralarira ra, rotu ma tamata ra rfikir aꞌuk afa ovi sian ra. Ira rsifedan, rsifa roak, naꞌuk rtuba ovu tamata ovi wol awarira verin ira, rsifa tia ma watan ovu tamata ovi wol awarira verin ira, rbori, rsiklabir ovu rfalak sian tamata ra. ");
INSERT INTO frd_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Afa sian avyai rfangra tamata ra, naꞌuk wean i mifnaꞌan, na wol mryaming limabira ra, inyai wol nfangra tamata ra.” ");
INSERT INTO frd_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Nata Yesus nban-talik wan yai ma nti naran wan i nfaseri kota Tirus ovu kota Sidon. ");
INSERT INTO frd_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Vata Kanaan isa ntali wan yai nma ma nafwak ne, “Duilaꞌa, raja Daud ubun a nusin Oa, fara fwaturu Mu silobang verin yaꞌa, tevek nait sian isa nleal yanak vata, ovu notu ma nleka aleman roak.” ");
INSERT INTO frd_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Yesus wol nfalak afakataka verin vata yai, ba Ni tamata ra rti ma rera verin Ia ne, “Baba, fara msinir vata ini ma nti, tevek nban-orang ita ovu nafwak lalawatan.” ");
INSERT INTO frd_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yesus nfalak verin ia ne, “Ubu nsinir Yaꞌa ma ulobang aꞌuk tamata Israel ra, tevek ira wearira domba ovi wol rkaꞌa roak ne, duarira naꞌa inba.” ");
INSERT INTO frd_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Naꞌuk vata yai nma ma nsangatur verin Ia ma nfalak ne, “Duilaꞌa, fara mlobang yaꞌa!” ");
INSERT INTO frd_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ba Yesus nfalak verin ia ne, “Wol lolin, wean i tala kasikoꞌu rira afamtahan ra ma tvatuk verin yaha ra ma raꞌan.” ");
INSERT INTO frd_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Vata yai nfalak verin Yesus ne, “Kena ta Duilaꞌa, naꞌuk yaha ra baꞌi raꞌan afamtahan mumun ovi rleka naꞌa duarira rira meja vavan a.” ");
INSERT INTO frd_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ba Yesus nfalak verin ia ne, “Titi, mu inorang a dawan urun, ba veka nfakena afa i ralam nfalak a.” Brian munuk, na vata yai yanan a lolin lahir ia. ");
INSERT INTO frd_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesus nban-talik wan yai ma ti nban-oli danau Galilea nelan a. Ia nrata vuar isa ma ndoku inyai. ");
INSERT INTO frd_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Tamata rivun ilaꞌa rma ma rtuan Ia naꞌa inyai. Ira rovun tamata ovi ratlukut ra, tamata ovi limarira te earira ra sian, tamata ovi rkibu ra, tamata ovi rmanu ra ovu vali tamata suhut liak ra. Ira rfadoku tamata avyai naꞌa Yesus wahan ralan a, ma notu ma lolin munuk ira. ");
INSERT INTO frd_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ba tamata rivun avyai rtalkaka, tevek rsiꞌik Yesus notu ma lolin ewal tamata ra. Tamata ovi rmanu ra rangrihi nala roak, tamata ovi limarira te earira ra sian lolin roak ira, tamata ovi ratlukut ra rbana nala roak ovu tamata ovi rkibu ra rsirea ewal roak. Ba rir tinemun rfadawang tamata Israel rira Ubu a. ");
INSERT INTO frd_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesus nera Ni tamata ovi rorang Ia ma nfalak ne, “Ufaturu Ning silobang verin tamata rivun ovi, tevek rorang Yaꞌa amar itelu roak, ovu wol rira afamtahan ma raꞌan. Wol mane usinir ma rewal ira ovu evurira vu, boma deka renweringun naꞌa lingaꞌan ralan.” ");
INSERT INTO frd_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ba Yesus Ni tamata ra rfalak verin Ia ne, “Wol tamata naꞌa wan lean vu ini, ba ki tala afamtahan tali inba ma al tfaꞌan tamata rivun ovi?” ");
INSERT INTO frd_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesus norat ira ne, “Bira roti ifira?” Ira rfalak ne, “Roti ifitu ovu ian koꞌu ifira watan.” ");
INSERT INTO frd_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Yesus nsinir tamata rivun avyai ma rdoku lanun, ");
INSERT INTO frd_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","beti nala roti ifitu yai ovu ian ra ma naflurut ovu nfalak fara weninyai verin Ubu. Nata nvisul roti ovu ian ra ma nala verin Ni tamata ra, ma rtanang verin tamata rivun avyai. ");
INSERT INTO frd_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ira munuk rafnaꞌan ma evurira rveda roak, beti Yesus Ni tamata ra rasdovuk teran ra naꞌa ahir ifitu ma rngora. ");
INSERT INTO frd_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Tali tamata ovi rafnaꞌan, na rarekan brana ra watan rivun ifaꞌat. Wol rarekan vata ovu kasikoꞌu ra obin. ");
INSERT INTO frd_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yesus nsinir tamata rivun avyai ma rewal ira. Nata Ia nrata kumal isa ma nti wan i naran Magadan. ");
INSERT INTO frd_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Amar isa, na tamata boku tali sidovung Farisi ovu Saduki rma mane rlabir teman Yesus. Ira rera ma notu faneak i tamata ra wol rot-nala ma nfaturu ne, Ubu nsinir urun Ia. ");
INSERT INTO frd_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yesus nfalak verin ira ne, “Wean i lera mane nakduvul, na fyalak ne, ‘Ilyan veka lera, tevek lanit a navuli watan.’ ");
INSERT INTO frd_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Wean i varverak obin, na fyalak ne, ‘Lanit navuli ovu mutan ra rdiri, ba veka daꞌut.’ Mia mkyaꞌa ma msyiꞌik lanit, na fyalak lahir ne, veka daꞌut te wahal, naꞌuk wol fyan-aran faneak ovi fiang ini Ubu notu ra. ");
INSERT INTO frd_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Notu afakinimi tamata ktufan ovi rvaꞌat naꞌa tuvu ini wol rorang Yaꞌa, naꞌuk rera ma otu faneak i tamata ra wol rot-nala? Fiang ini wol otu faneak akataka verin ira, naꞌuk ki ufaturu faneak isa watan verin ira, wean faneak i lan a Ubu notu roak verin nabi Yunus.” Yesus nfalak munuk wean inyai, beti nban-talik ira. ");
INSERT INTO frd_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Yesus ovu Ni tamata ovi rorang Ia raran danau ni lihir a, naꞌuk Ni tamata ra rablufang ma rtaha roti. Naꞌut inyai, na ");
INSERT INTO frd_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesus nfalak verin ira ne, “Msyiꞌik wabira ma lolin. Msyiꞌik ma lolin tamata Farisi ovu tamata Saduki rira ragi a!” ");
INSERT INTO frd_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Yesus Ni tamata ra wol rfan-aran Ni vaivatul ra, ba kaꞌi rsifalak afa verin ira ne, “Ia nfalak wean inyai, tevek tablufang ma tataha roti.” ");
INSERT INTO frd_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Naꞌuk Yesus nkaꞌa afa ovi rfalak ra, ba norat ira ne, “Notu afakinimi msyifalak afa naꞌa i wol mtyaha roti i? Mia bira inorang a koꞌu daꞌin! ");
INSERT INTO frd_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Mia wol fyan-aran obin! Wol mingnanang amar i uvisul roti ilima ma ufaꞌan tamata rivun ilima? Miblufang vali ne, misdovuk teran ra naꞌa ahir ifira? ");
INSERT INTO frd_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Wean inba vali naꞌa amar i uvisul roti ifitu ma ufaꞌan tamata rivun ifaꞌat a? Misdovuk teran ra naꞌa ahir ifira? ");
INSERT INTO frd_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Notu afakinimi wol fyan-aran obin ne, wol ufamalik naꞌa roti! Msyiꞌik ma lolin tamata Farisi ovu tamata Saduki rira ragi a.” ");
INSERT INTO frd_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ba Ni tamata ra beti rfan-aran ne, Yesus wol nfamalik ragi i tamata ra baꞌi rfadoku naꞌa roti. Ia nfamalik wean inyai, boma rsiꞌik warira ma lolin naꞌa Farisi ovu Saduki rira afa ovi rair ra. ");
INSERT INTO frd_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesus ovu Ni tamata ovi rorang Ia rti wan ovi sarseri ovu kota Kaisarea Filipi. Ia nanaꞌa inyai, na norat ira ne, “Tamata ra rfalak ne, Tamata Yanan yai, iki ia?” ");
INSERT INTO frd_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ira rfalak ne, “Tamata boku rfalak ne, Oa ini Yohanes i nbaptis tamata ra. Boku rfalak ne, Oa ini nabi Elia. Boku vali rfalak ne, Oa ini nabi Yeremia, te nabi liak isa vali.” ");
INSERT INTO frd_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ba norat ewal ira ne, “Naꞌuk mia fyikir ne, Yaꞌa ini iki?” ");
INSERT INTO frd_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simon Petrus nfalak ne, “Oa ini Raja i mtevut mami salasilan ra, ovu Ubu i nvaꞌat a, Yanan Oa.” ");
INSERT INTO frd_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesus nfalak verin ia ne, “Ubu naflahar oa, Simon i yamam verin Yunus, tevek tamata ra wol rfavotuk afa ini verin oa, naꞌuk tali Yamang i naꞌa lanit ratan a. ");
INSERT INTO frd_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ufalak vali verin oa ne, naram a Petrus, ihin a vatminan. Yaꞌa veka ufadiri Ning sidovung tamata ovi rorang Yaꞌa naꞌa vatminan ini ratan a. Matmatan ni ngrebat wol nfalek-nala ira. ");
INSERT INTO frd_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Yaꞌa wean ala kusi tali Ubu Ni Fareta ma ufadoku naꞌa limam ralan a, boma wean i fwalak teri afaka watan naꞌa lanit ivavan a, na Ubu nfalak teri vali naꞌa lanit ratan. Wean i mtorung afaka watan naꞌa lanit ivavan a, na Ubu veka ntorung vali naꞌa lanit ratan.” ");
INSERT INTO frd_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Nata nfalak teri ma deka rfamalik verin tamata ra ne, Ia Raja i ntevut rira salasilan ra. ");
INSERT INTO frd_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Tali amar yai vali, na Yesus nfalyawang verin Ni tamata ovi rorang Ia ne, afaka veka nkena Ia. Ia nfamalik verin ira ne, musti nti Yerusalem ma dawan Yahudi ra, Yahudi rira dawan mela falurut ra ovu vali Yahudi rira dawan ovi rair Musa ni inukun ra veka rotu sian Ia tia ma watan. Ira vali veka rfedan Ia, naꞌuk amar itelu nelak, na Ubu veka nfavaꞌat ewal Ia. ");
INSERT INTO frd_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ba Petrus novun Ia ma rdir-aling ira, beti ntabu Ia nfalak ne, “Duilaꞌa, deka fwalak wean inyai! Era verin Ubu, boma afa yai deka nkena Oa.” ");
INSERT INTO frd_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Naꞌuk Yesus ndir-tamuri Petrus, beti nfalak verin ia ne, “Nitdawan, muti vatuk oa tali ini! Oa mangal Yaꞌa ma deka ot-orang Ubu Ni banbanan verin Yaꞌa. Afa ovi fwikir ra wol rtali Ubu, naꞌuk rtali watan tamata ra.” ");
INSERT INTO frd_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Nata, Yesus nfalak verin Ni tamata ra ne, “Tamata iki inan ma norang Yaꞌa, na ia musti nalak tenan a ovu nvara ni aa walwalur ma norang aꞌuk Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Tamata iki watan inan ma ntahang teri ni vavaꞌat i naꞌa lanit ivavan a, na ia wol ni vavaꞌat kakiwal a. Naꞌuk tamata iki nablufang ni vavaꞌat a tevek norang Yaꞌa, na veka ni vavaꞌat kakiwal. ");
INSERT INTO frd_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Wean i tamata isa nasdovu munuk metan ovi rnaꞌa lanit ivavan a, naꞌuk wol ni vavaꞌat kakiwal, na ihin aka? Ia ki nala aka ma al nkati vavaꞌat kakiwal yai? Wol nala akataka lahir! ");
INSERT INTO frd_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ba myorang aꞌuk Yaꞌa ovu ralabira urun, tevek Ning amar veka nma ma Yaꞌa, Tamata Yanan Yaꞌa veka uma ewal, ovu Yamang Ni ngrebat i nfitik nyadat a, ovu vali Ni sansinir ra tali lanit ratan rovu vali Yaꞌa. Naꞌut amar yai, na veka ukun tamata ra munuk ma inovan ovu afa ovi rotu ra. ");
INSERT INTO frd_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Afa i ufalak verin mia ini, kena urun! Tali bir tinemun naꞌa wan ini, na tamata boku wol rmata obin, naꞌut inyai na ira veka rsiꞌik lahir Yaꞌa Tamata Yanan Yaꞌa veka uma ma ufareta wean lahir Raja.” ");
INSERT INTO frd_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Amar inean nelak roak, na Yesus novun Petrus, Yakobus irua warin a Yohanes, ma rvaꞌal vuar karatat isa, ma aksa ira watan naꞌa inyai. ");
INSERT INTO frd_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ira rsiꞌik, na Yesus felan a naling roak Ia. Wahan a vanan ma wean lera, ovu vali afa ovi nung a neluk ra, rangiar urun ma rfitik-ryadat. ");
INSERT INTO frd_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Brian munuk, na rsiꞌik Musa irua Elia rvotuk ma rangrihi nulu Yesus. ");
INSERT INTO frd_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ba Petrus nfalak verin Ia ne, “Duilaꞌa, lolin urun ma tnaꞌa wan ini. Ni lolin a amfadiri befak itelu, ma isa verin Oa, isa verin Musa, isa vali verin Elia.” ");
INSERT INTO frd_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Petrus nangrihi obin, na brian munuk mutan isa vanan urun ma nkum-teri irtelu. Ira rarenar vai isa ntali mutan ralan yai ne, “Ini Yanak i ulobang urun Ia. Ia notu ma ralang a lolin urun, ba mryenar afa ovi nfalak ra!” ");
INSERT INTO frd_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Yesus Ni tamata avyai rarenar vai yai, na rbobar urun ma rleka lahir rsuta lanun ma rtub-fangofak ira. ");
INSERT INTO frd_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yesus nma ma nkena ira, beti nfalak ne, “Deka byobar, ba mdyiri kikyai!” ");
INSERT INTO frd_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ba rvanung waharira ra ma rsiꞌik, na wol tamata roak naꞌa inyai. Yesus aꞌuk saꞌi nanaꞌa inyai. ");
INSERT INTO frd_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Nata rsuta tali vuar ma rnaꞌa rira banbanan obin, na Yesus nsurak ira ne, “Deka fyamalik afa i mryea inlangin yai verin tamata ra veki. Mnyaban ma Ubu nfavaꞌat ewal Yaꞌa, Tamata Yanan Yaꞌa tali matmatan, beti fyamalik.” ");
INSERT INTO frd_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ira rorat Ia ne, “Notu afakinimi Yahudi rira dawan ovi rair Musa ni inukun ra rfalak ne Elia nma ula ia, beti Raja i ntevut dida salasilan ra nma?” ");
INSERT INTO frd_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesus nfalak ne, “Kena, Elia nma ula ia, boma nasusan afakataka munuk. ");
INSERT INTO frd_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Naꞌuk ufalak verin mia ne, Elia nma roak, naꞌuk tamata ra wol rkaꞌa ia ma rotu tia ma watan ia. Wean inyai vali verin Yaꞌa Tamata Yanan Yaꞌa ini, veka utuan sian rivun ma tamata ra veka rwi-rwa Yaꞌa.” ");
INSERT INTO frd_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Naꞌut inyai beti Yesus Ni tamata ra rkaꞌa ne, Yesus nfamalik Yohanes i nbaptis tamata ra. Yohanes wean nabi Elia. ");
INSERT INTO frd_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Yesus ovu Ni tamata itelu yai rsuta tali vuar yai ma rtuan tamata rivun. Tali tamata rivun avyai, na brana isa nma ma nsangatur naꞌa Yesus wahan ralan a ma nfalak ne, ");
INSERT INTO frd_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Duilaꞌa, fara fwaturu Mu silobang a verin yanak brana. Ia ni suhut manut ma notu ma wean i nfoar, ba nawar ma dawan ia, ovu baꞌi nleka naꞌa yafralan ovu vali naꞌa wear. ");
INSERT INTO frd_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Yaꞌa ovun roak ia uma verin Mu tamata ovi rorang Oa, naꞌuk wol rot-nala ma lolin ia.” ");
INSERT INTO frd_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesus ntabu ira ma nfalak ne, “Wean inba mia? Wol bira inorang lahir ovu wol myorang afa ovi kena ra. Amar ifira vali ma udoku ovu mia ma utahang nal ralang ovu mia, tamata ovi wol bira inorang a? Myovun kasikoꞌu yai mya ini!” ");
INSERT INTO frd_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ba Yesus nfareta nait sian i nleal kasikoꞌu yai ma nti talik ia. Nait sian yai nti talik lahir ia, ma lolin ewal ia. ");
INSERT INTO frd_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Afa yai nlia roak, beti Yesus ovu Ni tamata ovi rorang Ia rban-talik wan yai ma aksa ira watan, ma rorat Ia ne, “Afakinimi ami wol amaling nala nait sian yai?” ");
INSERT INTO frd_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesus nfalak verin ira ne, “Wol myot-nala, tevek bira inorang a kakoꞌu daꞌin. Afa i ufalak verin mia ini, kena urun! Ba wean i bira inorang a veran sesawi ni vatul watan, na bisma fyalak ma vuar yai nti wan liak, na vuar yai veka nti lahir, ba bis myot-nala afaka watan.  ");
INSERT INTO frd_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Naꞌuk lingaꞌan isa watan ma milaꞌing vatuk nala nait sian i felan wean inyai. Musti miflurut verin Ubu ovu mtyolat.” ");
INSERT INTO frd_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Amar isa, na Yesus ovu Ni tamata ovi rorang Ia rasdovu ira naꞌa Galilea, ma nfalak verin ira ne, “Tamata ra veka rala Yaꞌa, Tamata Yanan Yaꞌa ini, verin tamata ra, ");
INSERT INTO frd_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ma rfedan Yaꞌa, naꞌuk amar itelu nelak, na Ubu veka nfavaꞌat ewal Yaꞌa.” Rarenar afa i Yesus nfalak yai, na ralarira ra lalau urun. ");
INSERT INTO frd_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesus ovu Ni tamata ovi rorang Ia raran ahu Kapernaum. Amar isa, na tamata ovi baꞌi rera babahir kulu verin Yahudi rira Rahan Dawan Falurut, ti ma rtuan Petrus ma rorat ia ne, “Mu guru nbahir kulu verin dida Rahan Dawan Falurut, te wahal?” ");
INSERT INTO frd_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Petrus nfalak ne, “Ia nbahir kulu yai!” Nata nti rahan i Yesus nleal a mane norat afa yai tali Ia. Wol norat Yesus obin, na Yesus norat lan roak ia ne, “Simon, munovak aka naꞌa afa ini: raja ovi rnaꞌa lanit ivavan rfareta tamata aba ma rbahir kulu? Rera tali rira tamata ra, te tali tamata dakan ra?” ");
INSERT INTO frd_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petrus nfalak ne, “Tali tamata dakan ra.” Yesus nfalak ne, “Ba wean inyai, na raja rira tamata ra deka rbahir kulu. ");
INSERT INTO frd_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Naꞌuk totu ma ralarira deka sian ita, ba mtaha mu snar a ma ti mdava ian naꞌa danau. Mngal ian i bwing lan a, vavan a, na veka mrea kubang isa. Kubang yai naran ma tbahir kulu, ba mala ma bwahir kulu verin itrua.” ");
INSERT INTO frd_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Naꞌut inyai, na Yesus Ni tamata ovi rorang Ia rma ma rtuan Ia, ma rorat ne, “Naꞌa Ubu Ni Fareta, na iki ni dawan a nlia munuk?” ");
INSERT INTO frd_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yesus nera kasikoꞌu isa ma ndiri waharira ralan ra, ");
INSERT INTO frd_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ma nfalak verin ira ne, “Afa i ufalak verin mia ini, kena urun! Wean i wol myahil ma mtyalik tali bira salasilan ra, ovu fyakabava tenabira ra wean kasikoꞌu ini, na mia veka wol ti mnyaꞌa Ubu Ni Fareta a. ");
INSERT INTO frd_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Tamata iki watan nfakabava tenan a wean kasikoꞌu ini, na ia veka dawan lia munuk tamata ovi rnaꞌa Ubu Ni Fareta a. ");
INSERT INTO frd_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Tamata iki watan nalang kasikoꞌu ra wean kasikoꞌu ini tevek narang a, na ia nalang roak Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Naꞌuk tamata iki watan notu ma kasikoꞌu i norang Yaꞌa nleka ma notu salasilan, na Ubu veka nukun ia. Ni lolin a, rkeak vatu dawan isa naꞌa relan a, ma rfanebar ia naꞌa tahat ralan.” ");
INSERT INTO frd_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Yaꞌi yo! Veka sian urun i lahir, tevek afa ovi rnaꞌa lanit ivavan ini veka rotu ma tamata ra rira salasilan. Ita tkaꞌa roak ne, afa sian avyai rotu ma tamata ra rira salasilan rnaꞌa watan, naꞌuk sian urun verin tamata ovi rotu ma tamata liak ra rotu salasilan. ");
INSERT INTO frd_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ba wean i limabira te eabira ra rotu ma myotu salasilan, na myetal vatuk watan ira. Ni lolin a, limabira lihir te eabira lihir watan, naꞌuk bira vavaꞌat kakiwal ovu Ubu. Sian urun i lahir wean limabira ovu eabira ratnemu, naꞌuk rvatuk mia ma mnyaꞌa yafwan kakiwal. ");
INSERT INTO frd_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Wean i matabira lihir notu ma myotu salasilan, na mkyivul vatuk watan ia. Ni lolin a, matabira lihir watan, naꞌuk bira vavaꞌat kakiwal ovu Ubu. Sian urun ia lahir ma matabira irua, naꞌuk rvatuk mia ma mnyaꞌa yafwan kakiwal.” ");
INSERT INTO frd_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Msyiꞌik wabira ma lolin, boma deka minovak ne, kasikoꞌu ovi wearira kasikoꞌu ini wol fyawarira. Mingnanang, tevek ufalak verin mia ne, Ubu Ni sansinir ra tali lanit ratan rsiꞌik ma lolin kasikoꞌu avyai, ovu rdiri lalawatan Yamang i naꞌa lanit ratan wahan ralan a.  ");
INSERT INTO frd_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Tevek Yaꞌa, Tamata Yanan Yaꞌa, uma lanit ivavan ini ma udava tamata ovi rfaroa ira tali Ubu, ma usikat ira tali rira salasilan ra, ma rira vavaꞌat kakiwal. ");
INSERT INTO frd_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Mia minovak aka naꞌa vaivatul kamkuma ini? Tamata isa ni domba ratut isa, naꞌuk isa nban-sala ma wol nleal roak. Domba duan yai veka nti talik ni domba vutsi rahin isi yai ma rnaꞌa vuar ni dadudur watan, ma ti ndava domba i nban-sala yai. ");
INSERT INTO frd_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Afa i ufalak verin mia ini, kena urun! Ti ma ndav-nala roak ia, na inan urun i lahir, nlia tali domba vutsi rahin isi ovi wol rban-sala. ");
INSERT INTO frd_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ba Yamadida i naꞌa lanit ratan wean vali inyai. Ia wol inan ma kasikoꞌu isa vali tali kasikoꞌu avyai rban-sala ma veka wol rleal.” ");
INSERT INTO frd_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Wean i teram-valim tamata inorang isa notu salasilan verin oa, na muti ma fwalyawang verin ia naꞌa ni sala, naꞌuk mirua watan ma deka tamata liak rkaꞌa. Wean i nrenar mu snurak a, na nfaturu roak ne, mirua ralabira lolin ewal roak. ");
INSERT INTO frd_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Naꞌuk wean i wol nrenar oa, na movun tamata isa te irua ewal ma msurak ewal ia, ma rarenar afa ovi fwalak ra. Rtulis roak naꞌa Surat Ralan ne, ‘Wean i mane rmangadu tamata, na tamata irua te itelu musti rnaꞌa inyai vali ma rarenar afa ovi rfalak ra.’ ");
INSERT INTO frd_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Wean i nafena ma nrenar obin, na fwamalik ni sala yai verin sidovung tamata ovi rorang Yaꞌa. Wean i nafena vali ma nrenar ira, na deka myotu kida ovu ia, wean tamata ovi baꞌi rera babahir kulu ra te tamata liak ovi wol rkaꞌa Ubu. ");
INSERT INTO frd_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Afa i ufalak verin mia ini, kena urun! Afa ovi fwalak teri naꞌa lanit ivavan ini, Ubu veka nfalak teri vali naꞌa lanit ratan. Wean i mtorung afaka watan naꞌa lanit ivavan ini, na Ubu veka ntorung vali naꞌa lanit ratan. ");
INSERT INTO frd_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ufalak ewal verin mia ne, wean i tamata irua tali mia naꞌa lanit ivavan ini mian vai isa ma myera afaka watan tali Yamang a naꞌa lanit ratan, na Ia veka nvalat bira falurut a. ");
INSERT INTO frd_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Tevek naꞌa inba watan, wean i tamata inorang irua te itelu rasdovu ira, na Yaꞌa unaꞌa vali inyai.” ");
INSERT INTO frd_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Petrus nma ma nfalak verin Yesus ne, “Duilaꞌa, veka abun nala fafira salasilan ovi terang a valing isa notu verin yaꞌa? Abun nala fafitu?” ");
INSERT INTO frd_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesus nfalak verin ia ne, “Wol fafitu watan. Oa musti mabun salasilan ovi tamata ra rotu verin oa, ti naran favutfitu, fafitu. ");
INSERT INTO frd_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ufamalik afa yai tevek Ubu Ni Fareta a wean raja isa i mane nsiꞌik ne, ni tamata ovi rkarya verin ia rira utan ifira verin ia. ");
INSERT INTO frd_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ti ma nrekan utan avyai, na rovun vali ni tamata isa nma verin ia. Tamata yai ni utan dawan urun i lahir, talenta rivun vutu a. ");
INSERT INTO frd_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Tamata yai wol nbahir nala ni utan yai, ba raja yai nfareta ni tamata ra ma rfedi ia ovu awan a yanan ra ovu vali ni metan ra munuk ma nbahir ni utan yai. ");
INSERT INTO frd_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ba tamata yai nsuta ma nsangatur verin ia ma nfalak ne, ‘Baba, fara mnaban kedan veki, ma ki ubahir munuk ning utan a.’ ");
INSERT INTO frd_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Nata raja yai nfaturu ni silobang verin ia, ma nfatalik ia ovu naꞌi vatuk tamata yai ni utan. ");
INSERT INTO frd_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Naꞌuk ti ma nban-talik raja yai, na ntuan tamata isa i nkarya vali verin raja yai. Tamata yai nutang roak ni kubang a, naꞌuk koꞌu watan, dinar ratut isa. Ia ntaha ngurus tamata yai relan a, beti nfalak ne, ‘Bwahir kikyai mu utan verin yaꞌa!’ ");
INSERT INTO frd_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ba tamata yai nsangatur verin ia ma nfalak ne, ‘Baba, fara mnaban kedan a, ma ki ubahir munuk ning utan.’ ");
INSERT INTO frd_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Naꞌuk nafena ma naꞌi vatuk tamata yai ni utan, ba nala ia ma ti raꞌabuꞌi ia, ti naran i nbahir munuk ni utan a. ");
INSERT INTO frd_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ti ma tamata liak ovi rkarya verin raja yai rsiꞌik afa i tamata yai notu, na ralarira lalau urun. Ba ti rfamalik afa yai verin raja. ");
INSERT INTO frd_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Nata raja yai nsinir ma ti rera tamata yai ma nfalak ne, ‘Oa muktufan urun! Aꞌi vatuk munuk roak mu utan a, tevek mera lablobang verin yaꞌa. ");
INSERT INTO frd_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Notu afakinimi wol mlobang tamata i nkarya ovu oa, wean i ulobang roak oa yai?’ ");
INSERT INTO frd_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Raja nangrova urun, ba nfalak ma rtaha ia ti verin tamata ovi baꞌi rwi-rwa tamata ra, ti naran i nbahir munuk ni utan a. ");
INSERT INTO frd_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ba Yamang a naꞌa lanit ratan veka notu vali wean inyai verin lokat tamata, wean i wol ralabira urun ma myabun salasilan ovi terabir-valibira ra rotu verin mia.” ");
INSERT INTO frd_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesus nair munuk naꞌa afa avyai, na ntali propinsi Galilea nti propinsi Yudea ma nanaꞌa oar Yordan ni lihir a. ");
INSERT INTO frd_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Naꞌa inyai na, tamata rivun rma ma rorang Ia, ovu notu ma ovi rira suhut ra lolin ewal ira. ");
INSERT INTO frd_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Tamata Farisi boku rma ma rlabir teman Yesus. Ira rorat Ia ne, “Naꞌa dida inukun ra, na brana ra bisma rtalik tia ma watan awarira te wahal?” ");
INSERT INTO frd_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesus nfalak ne, “Mia wol byas Ubu Ni vaivatul ra? Tali naꞌut i Ubu notu lanit ivavan a, na Ia notu roak brana ovu vata. ");
INSERT INTO frd_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ubu Ni vaivatul a nfalak ne, ‘Wean inyai, bi brana veka nsuta talik renan ovu yaman a, ma irua awan a rleal isa. Vata irua brana ralarira isa ma ikisa watan ira.’ ");
INSERT INTO frd_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ba irua ikisa watan roak. Wean inyai, bi Ubu notu roak ma irua rleal isa, ba tamata ra wol bis rotu ma rsitalik.” ");
INSERT INTO frd_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Tamata Farisi avyai rorat Yesus ne, “Ba wean inyai, na afakinimi Musa nfalak ma wean i brana isa mane ntalik awan a, na nasusan ni surat sitalik ma nfasuka ia?” ");
INSERT INTO frd_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesus nfalak verin ira ne, “Musa ntorung ma mtyalik awabira ra, tevek ralabira ra rangrebat daꞌin. Tali lalan ana, Ubu wol ntorung ma msyitalik. ");
INSERT INTO frd_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ufalak verin mia ne, brana iki watan ntalik awan a ma nsifa ewal ovu vata liak, na ia naflidan roak. Naꞌuk wean i awan a ntuba ovu brana liak, beti bisma ntalik awan a.” ");
INSERT INTO frd_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Nata Yesus Ni tamata ovi rorang Ia rfalak ne, “Ba wean i brana mane nsifa ovu ntuan angangal wean inyai, na ni lolin a deka nsifa lahir.” ");
INSERT INTO frd_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yesus nfalak verin ira ne, “Tamata boku watan rtahang nala afa i fyalak yai. Naꞌuk Ubu nala ngrebat verin tamata boku ma rtorung ma wol rsifa. ");
INSERT INTO frd_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Tamata boku wol rsifa, tevek tali amar i rarali ira, na ira wearira watan inyai. Tamata boku wol rsifa, tevek tamata ra rotu ma ira wearira inyai. Boku vali tali watan ira ma rfili ma wol rsifa, tevek ranovak ma rkarya verin Ubu naꞌa Ni Fareta a. Iki nfan-aran Ning vaivatul ra, na ni lolin a not-orang.” ");
INSERT INTO frd_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Tamata ra rovun yanarira ra rma verin Yesus, ma nfadoku liman a naꞌa ira ovu naflurut verin ira, naꞌuk Ni tamata ovi rorang Ia rangrova tamata avyai. ");
INSERT INTO frd_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yesus nfalak verin ira ne, “Msyiꞌik watan ma kasikoꞌu avyai rma ma rtuan Yaꞌa. Deka myotu teri ira, tevek tamata ovi wearira avyai, ira veka warira vali ovu Ubu naꞌa Ni Fareta a.” ");
INSERT INTO frd_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Nata Yesus nfadoku liman a naꞌa kasikoꞌu avyai ma naflahar ira, beti nban-talik wan yai. ");
INSERT INTO frd_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Amar isa, na brana isa nma ma norat Yesus ne, “Tuan Guru, yaꞌa musti otu afa lolin aka, boma ning vavaꞌat kakiwal?” ");
INSERT INTO frd_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesus nfalak verin ia ne, “Afakinimi morat Yaꞌa naꞌa afa i lolin a? Ubu aꞌuk saꞌi lolin Ia. Wean i inam ma mu vavaꞌat kakiwal, na mot-orang Ubu Ni inukun ra.” ");
INSERT INTO frd_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ba brana yai norat ewal ne, “Inukun inba?” Yesus nfalak verin ia ne, “Deka msifedan, wean i msifa roak, na deka mtuba ovu tamata i wol awam verin ia, deka bwori, ovu vali deka mdiri fareta waharira ralan ra ma msiklabir naꞌa afa ovi fwalak ra naꞌa tamata liak. ");
INSERT INTO frd_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Malang renam ovu yamam a, ovu vali mlobang tamata ra munuk, wean watan i mlobang tenam a.” ");
INSERT INTO frd_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Varverun yai nfalak ne, “Baba, yaꞌa ot-orang munuk roak afa avyai, ba afaka wahal obin?” ");
INSERT INTO frd_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesus nfalak verin ia ne, “Wean i inam ma mu vavaꞌat a nmalola, na muti ma fwedi munuk mu metan ra, ma mtanang kubang avyai verin tamata kasian ra. Motu wean inyai, na veka mu metan naꞌa lanit ratan, beti mwa ma morang Yaꞌa.” ");
INSERT INTO frd_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ti ma nrenar afa i Yesus nfalak yai, na newal ia ovu ralan lalau, tevek ni metan a rivun. ");
INSERT INTO frd_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Nata Yesus nfalak verin Ni tamata ra ne, “Afa i ufalak verin mia ini, kena urun! Susa buas ma tamata ovi rkaꞌi ra rtorung ma Ubu nfareta ira wean lahir raja! ");
INSERT INTO frd_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ufalak fasa ewal ne, susa dalang ma unta nuruk nala nti dirin ni bilahin a, naꞌuk susa lia inyai vali verin tamata kaꞌi ra rtorung ma Ubu nfareta ira wean lahir raja!” ");
INSERT INTO frd_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ti ma Ni tamata ra rarenar afa ovi nfalak ra, na rtalkaka lahir ma rfalak ne, “Ba wean inyai, na iki veka ni vavaꞌat kakiwal?” ");
INSERT INTO frd_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesus nsiꞌik ira ma nfalak ne, “Tamata ra wol rot-nala lahir afa yai, naꞌuk Ubu bis not-nala munuk akataka.” ");
INSERT INTO frd_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ba Petrus nfalak ne, “Ami amban-talik roak mami afakataka munuk ma amorang Oa, ba ami veka enamami aka?” ");
INSERT INTO frd_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesus nfalak verin ira ne, “Afa i ufalak verin mia ini, kena urun! Ti naran amar i Ubu veka notu ma akataka ngorvaꞌan munuk, na Yaꞌa, Tamata Yanan Yaꞌa ini veka udoku wang i nfitik nyadat a ma ufareta. Naꞌut inyai, na mia tamata ovi myorang roak Yaꞌa, lokat mia veka mdyoku vali naꞌa wan vutu rahin irua ma fyareta. Naꞌa wan avyai vali, na mia veka fyaleka inukun verin Israel ni arun dawan vutu rahin irua. ");
INSERT INTO frd_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Tamata iki watan nban-talik aꞌan a warin ra, renan ovu yaman a, yanan ra ovu uran ra, ni rahan teta te ni vaꞌi ra, tevek norang Yaꞌa, na tamata yai enan a veka ntafal ma faratratut, ovu vali veka ni vavaꞌat kakiwal. ");
INSERT INTO frd_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Naꞌuk tamata rivun ovi fiang ini dawan ira ma rban-ulu verin tamata ra, ira veka rban-muri watan. Tamata ovi koꞌu watan ira fiang ini ma rban-muri, ira veka dawan ira ma rban-ulu verin tamata ra.” ");
INSERT INTO frd_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Yesus nfalak ne, “Naꞌut i Ubu nfareta tamata ra wean lahir Raja, na Ni Fareta yai wean vaivatul kamkuma ini: Vaꞌi duan isa nbatar varverak sumatan, ma ti ndava tamata ma rkarya naꞌa ni vaꞌi anggur a. ");
INSERT INTO frd_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Vaꞌi duan yai naꞌan vai isa ovu tamata ovi ndav-nala roak ira ma nbahir kubang dinar isa naꞌa amar isa, tevek fyawan i wean ini baꞌi rala naꞌa amar isa. Ba nsinir ira ma ti rkarya naꞌa ni vaꞌi anggur. ");
INSERT INTO frd_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Kaꞌa bi jam sembilan varverak, na ia nti wan i rfedi-rfaha afa naꞌa ma nsiꞌik tamata liak boku vali. Tamata avyai wol rira karya, ma rdiri watan. ");
INSERT INTO frd_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ba nfalak verin ira ne, ‘Miti ma mkyarya naꞌa ning vaꞌi anggur a, ki ubahir bira kadi ra ma inovan ovu bira karya.’ Ba rti ni vaꞌi a. ");
INSERT INTO frd_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Lera ndirlola roak, na nti ewal ma ndava tamata. Jam tiga lerasian sian, na notu vali wean inyai. ");
INSERT INTO frd_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ti ma jam lima lera sian roak, na nti ewal inyai ma ntuan tamata ovi rdiri watan. Ia nfalak verin ira ne, ‘Notu afakinimi mdyiri watan ma wol mkyarya naꞌa amar lolan ini?’ ");
INSERT INTO frd_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ira rfalak verin ia ne, ‘Wol tamata rera ami ma amkarya.’ Ba nfalak verin ira ne, ‘Miti ma mkyarya naꞌa ning vaꞌi anggur a.’ ");
INSERT INTO frd_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Lervava roak, na vaꞌi duan yai nfalak verin ni tamata i nfili ma nfareta ovi rkarya ra ne, ‘Mera tamata rkarya ra ma bwahir rira kadi ra. Bwahir lan verin tamata ovi rban-muri ra, beti ovi ula ira.’ ");
INSERT INTO frd_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ba tamata ovi rkarya tali jam lima lersian yai rma, ma nbahir rira kadi ra naꞌa amar isa. Lokat ira rira kadi kubang dinar isa. ");
INSERT INTO frd_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Nata tamata ovi rkarya tali varverak yai rma. Ia nbahir ira kubang dinar isa vali. Tamata avyai ranovak ne, rira kadi veka nlia dinar isa, naꞌuk rira kadi ra wean watan ovi rban-muri ra. ");
INSERT INTO frd_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ba rala rira kadi ra, na rafngamuꞌur watan verin vaꞌi duan yai. ");
INSERT INTO frd_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ira rfalak ne, ‘Tamata ovi rban-muri lalean rkarya jam isa watan, naꞌuk bwahir ma wean watan ami! Velik ne ami amkarya amar lolan lahir, ma lera ntunu ami!’ ");
INSERT INTO frd_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Vaꞌi duan yai nfalak verin tamata isa tali rir tinemun ne, ‘Kida, yaꞌa wol ulabir oa. Ita taꞌan vai isa roak ma ubahir oa, kubang dinar isa naꞌa amar isa. ");
INSERT INTO frd_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Yaꞌa mane ubahir tamata ovi rban-muri lalean rira kadi ra ma wean watan mu kadi a. Ba mala mu kadi a ma mewal oa. ");
INSERT INTO frd_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Tali watan ralang a ma otu wean inyai, tevek yaꞌa ning kubang avyai. Oa betane ralam sian yaꞌa, tevek ralang lolin ma ala verin ira wean i ala verin oa.’ ” ");
INSERT INTO frd_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Nata Yesus nfalyawang vaivatul kamkuma yai ihin a verin Ni tamata ra ne, “Wean vali inyai verin tamata ovi fiang ini rban-muri, ira veka rban-ulu. Tamata ovi fiang ini rban-ulu, ira veka rban-muri watan.” ");
INSERT INTO frd_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Naꞌut i Yesus nti Yerusalem, ma naꞌa lingaꞌan ralan obin, na nera Ni tamata vutu rahin irua ovi rorang Ia yai, ma rti nelan kedan a ma nfalak verin ira ne, ");
INSERT INTO frd_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Fiang ini mane tati Yerusalem, na tamata ra veka rala Yaꞌa, Tamata Yanan Yaꞌa ini, verin dawan mela falurut ra ovu dawan ovi rair Musa ni inukun ra. Ira veka rukun Yaꞌa ma umata. ");
INSERT INTO frd_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ira veka rala Yaꞌa verin tamata ovi wol Yahudi ra. Tamata avyai veka rlabir waweang Yaꞌa ovu rira vaivatul ra, rasveva Yaꞌa, beti rbaku Yaꞌa naꞌa aa walwalur. Naꞌuk ti ma amar itelu nelak, na Ubu veka nfavaꞌat ewal Yaꞌa.” ");
INSERT INTO frd_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Nata Zebedeus awan a ovu yanan ra, rma ma rtuan Yesus. Zebedeus awan a nsoak ma nsangatur verin Yesus, mane nera afa tali Ia. ");
INSERT INTO frd_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ba Yesus norat ia ne, “Inam ma otu afaka verin oa?” Vata yai nfalak verin Yesus ne, “Era ma mtorung ne, veka mala yanak ra ma isa ndoku Mu lihir mela ovu isa ndoku vali Mu lihir balit a, ma mimunuk fyareta tamata ra naꞌa Mu Fareta a.” ");
INSERT INTO frd_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Naꞌuk Yesus nfalak verin ia ne, “Mia wol mkyaꞌa afa i myera tali Yaꞌa. Mtyahang nala ma rotu sian mia wean i veka rotu sian Yaꞌa?” Ira rfalak ne, “Oꞌu. Amtahang nala watan.” ");
INSERT INTO frd_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ba Yesus nfalak verin ira ne, “Fyalak kena urun, tevek ira veka rotu sian mia wean i veka rotu sian Yaꞌa. Naꞌuk Yaꞌa wol bisma ufadoku ne, iki ndoku Ning lihir mela ovu balit a. Ning lihir mela ovu Ning lihir balit a. Yamang aꞌuk saꞌi nfadoku ne, tamata aba veka rdoku ovu Yaꞌa.” ");
INSERT INTO frd_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Nata Yesus Ni tamata vutu rarenar afa ovi rira kida irua yai rfalak ra, ba rangrova ira. ");
INSERT INTO frd_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ba Yesus nera ira munuk ma nfalak ne, “Mia mkyaꞌa roak ne, tamata fareta ra ovu tamata dawan ovi wol Yahudi ira rfareta rira tamata ra ovu limarira tmaꞌan ma rtaꞌi ira. ");
INSERT INTO frd_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Naꞌuk mia deka weabira tamata avyai. Tamata iki inan ma ni dawan nlia tamata ra, na ia musti neluk tamata sansinir verin mia. ");
INSERT INTO frd_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Iki inan ma nlia munuk mia, na ia musti neluk tamata sansinir verin mia. ");
INSERT INTO frd_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Wean vali inyai verin Yaꞌa, Tamata Yanan Yaꞌa. Yaꞌa wol uma ma usinir tamata ra ma rlobang Yaꞌa. Naꞌuk uma ma ulobang tamata ra ovu umata al ukvanak tamata rivun tali rira salasilan ra.” ");
INSERT INTO frd_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Naꞌut i Yesus ovu Ni tamata ovi rorang Ia rban-talik kota Yerikho, na tamata rivun rorang vali ira. ");
INSERT INTO frd_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Naꞌa lingaꞌan nelan, na tamata kibu irua rdoku. Ira rarenar ne, Yesus nahu inyai, ba rafwak ne, “Yesus, Oa ubum a nusim Raja Daud, ba fara fwaturu Mu silobang verin ami!” ");
INSERT INTO frd_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Tamata rivun rtabu ira ma deka vairira. Naꞌuk rtafal ma rafwak ilaꞌa ne, “Oa ubum-nusim Raja Daud, ba fara fwaturu Mu silobang verin ami!” ");
INSERT INTO frd_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Nata Yesus ndir-teri ma nera tamata kibu irua yai ma norat ira ne, “Inabira ma otu aka verin mia?” ");
INSERT INTO frd_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ira rfalak ne, “Duilaꞌa, fara ne mlobang ami ma motu ma amsirea ewal!” ");
INSERT INTO frd_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yesus nfaturu Ni silobang verin ira, ba nkena matarira ra, na rsirea lahir. Ba rdiri ma rorang Yesus. ");
INSERT INTO frd_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesus ovu Ni tamata ovi rorang Ia ti rfaseri Yerusalem, ma raran roak ahu Betfage i nanaꞌa vuar Zaitun. Ba Yesus nsinir tamata irua tali Ni tamata ovi rorang Ia ma rti ula ira. ");
INSERT INTO frd_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Ia nfalak verin ira ne, “Miti ahu i naꞌa ulu eri. Naꞌa ineri, na mia veka mtyuan lahir keledai vata i rkeak siebang watan ia ovu yanan a. Mryuvat ni kakeak a ma fyabana ira mya verin Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Wean i tamata isa ntabu mia, na fyalak verin ia ne, ‘Duilaꞌa nperlu keledai yai,’ na npake munuk, beti rtaha lahir rma.” ");
INSERT INTO frd_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Rotu wean inyai, boma nfakena lahir vaivatul ovi nabi isa ntulis roak a. Ia ntulis ne, ");
INSERT INTO frd_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Fyalak verin tamata ovi rnaꞌa Sion ne, ‘Msyiꞌik kikyai, bira raja nma. Ia nfakabava tenan a, ma rata ndoku watan keledai isa i wol kaꞌi dawan ia obin.’ ” ");
INSERT INTO frd_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ba Yesus Ni tamata irua yai rti ma rot-orang afa ovi nfalak ra. ");
INSERT INTO frd_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Tamata irua yai rovun keledai vata yai ovu yanan a rti verin Yesus, ma rala rira ravit blawat ra ma al raraang tetarira ratan ra, beti Yesus rata ndoku keledai koꞌu yai. ");
INSERT INTO frd_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Tamata rivun ovi rnaꞌa inyai rvelar rira ravit a blawat ra naꞌa lingaꞌan ralan. Boku retal aa sanan tutul ra ma relir naꞌa lingaꞌan ralan. ");
INSERT INTO frd_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Tamata rivun rban-orang Yesus, boku rbana ula ira ovu boku vali rban-muri, ovu rafwak ne, “Mya ma traning Raja Daud ubun a nusin a! Ubu naflahar Ia i nma ovu Duilaꞌa naran a. Ubu nanaꞌa wan i karatat lia munuk a, ba traning Ia!” ");
INSERT INTO frd_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Naꞌut i Yesus ti naran Yerusalem, na tamata ovi rnaꞌa kota ralan yai vairira dawan. Ira rorat ne, “Ini tamata iki?” ");
INSERT INTO frd_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ba tamata rivun ovi rban-orang Yesus yai rfalak ne, “Ini Yesus i nabi Ia, ntali ahu Nazaret naꞌa propinsi Galilea.” ");
INSERT INTO frd_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Nata Yesus nati Yahudi rira Rahan Dawan Falurut ni lean a, ma nalaꞌing vatuk tamata ovi rfedi-rfaha afa naꞌa inyai. Ia nir-nar tamata ovi rsikati kubang rira meja ra, ovu vali dakdokwan ovi tamata ra rdoku ma ala rfedi modarlaka. ");
INSERT INTO frd_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ia nfalak verin tamata avyai ne, “Surat Ralan nfalak wean ini, ‘Ning rahan a neluk rahan falurut ma tamata raflurut naꞌa, naꞌuk mia myotu ma neluk wan ma tamata barborin ra rnaꞌa.’ ” ");
INSERT INTO frd_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ba tamata ovi rkibu ra ovu tamata ovi ratlukut ra, rma rtuan Yesus naꞌa Rahan Dawan Falurut a, ma notu ma lolin ewal ira. ");
INSERT INTO frd_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Naꞌuk Yahudi rira dawan mela falurut ra ovu dawan ovi rair Musa ni inukun ra rangrova. Ira rangrova, tevek rsiꞌik mujizat ovi Yesus notu ra, ovu vali kasikoꞌu ra rafwak naꞌa Rahan Dawan Falurut ni lean a ne, “Mya ma traning Yesus, Raja Daud ubun-nusin a!” Ba ralarira sian urun. ");
INSERT INTO frd_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Nata rfalak verin Yesus ne, “Oa mrenar afa ovi kasikoꞌu ra rfalak te wahal?” Yesus nfalak ne, “Oꞌu, Yaꞌa urenar roak, naꞌuk wean inba ovu mia? Mia wol byas obin naꞌa Surat Ralan ne, tali kasikoꞌu ra ovu kasikoꞌu yanat ovi rsusu obin, na veka rfadawang Ia?” ");
INSERT INTO frd_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Nata Yesus nban-talik ira naꞌa kota Yerusalem ma nti ahu Betania, ma Ni ovan naꞌa inyai. ");
INSERT INTO frd_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ni ilyan varverak a, na Yesus ovu Ni tamata ovi rorang Ia rewal ira rti kota Yerusalem, na Yesus nfarnuang Ni balafar roak. ");
INSERT INTO frd_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Yesus nsiꞌik naꞌa lingaꞌan nelan, na nrea aa ara isa. Ba nbana nti inyai, naꞌuk wol nrea vuan isa vali, tevek aa ara yai roan lalawatan. Ba Yesus nfalak verin aa ara yai ne, “Tali amar ini, na wol vuam roak nata ti mungaran watan.” Brian munuk, na aa ara yai nangaran lahir. ");
INSERT INTO frd_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Yesus Ni tamata ra rsiꞌik afa yai, na rtalkaka. Ba rorat Ia ne, “Afakinimi brian munuk, na aa ara yai nangaran lahir i?” ");
INSERT INTO frd_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesus nfalak ne, “Afa i ufalak verin mia ini, kena urun! Wean i myorang Yaꞌa ovu ralabira wol raruan, na mia bisma myot-nala vali afa i otu verin aa ara yai. Wol wean inyai watan, naꞌuk bisma fyalak verin vuar isa ne, ‘Mlaun talik wam a kikyai, ma roal mtuba tahat ralan’, na veka wean urun inyai. ");
INSERT INTO frd_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Myorang urun Ubu ma miflurut verin Ia, ma myera afaka watan tali Ia, na veka nala verin mia.” ");
INSERT INTO frd_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Nata Yesus nati nsiair naꞌa Rahan Dawan Falurut ralan a. Naꞌut i nsiair, na Yahudi rira dawan mela falurut ra ovu rira dawan ra rma ma rtuan Ia naꞌa inyai, ba rorat Ia ne, “Oa mu ngrebat aka ma al motu afa ovi? Iki nala ngrebat yai verin Oa?” ");
INSERT INTO frd_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesus nfalak verin ira ne, “Yaꞌa mane orat mia naꞌa afa isa, ba byalat Yaꞌa veki, beti ufalak vali verin mia ne iki nala ngrebat ini verin Yaꞌa ma otu afa ovi. ");
INSERT INTO frd_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Yohanes nbaptis tamata ra ovu ngrebat tali iki? Ngrebat tali lanit ratan, te tali tamata?” Ira rsifalak afa verin ira ne, “Wean i tfalak ne, ‘Yohanes ni ngrebat ntali lanit ratan,’ na Ia veka nfalak verin ita ne, ‘Notu afakinimi wol myorang ia?’ ");
INSERT INTO frd_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Naꞌuk wean i tfalak ne, ‘Ngrebat tali tamata,’ na tbobar tamata rivun veka rotu sian ita, tevek ranovak ne, Yohanes yai nabi ia.” ");
INSERT INTO frd_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ba rfalak verin Yesus ne, “Ami wol amkaꞌa.” Yesus nfalak vali verin ira ne, “Ba wean inyai, na Yaꞌa veka wol ufalak vali verin mia ne, ala ngrebat tali iki ma otu afa avyai.” ");
INSERT INTO frd_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Mia minovak aka naꞌa vaivatul kamkuma ini? Tamata isa yanan a brana irua. Amar isa, na ia nti ma nfalak verin yanan iyaꞌan a ne, ‘Baba, amar ini muti ma mkarya naꞌa vaꞌi anggur.’ ");
INSERT INTO frd_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Yanan iyaꞌan yai nfalak ne, ‘Bapa, yaꞌa ufena uti.’ Naꞌuk nfikir ewal, ba nti nkarya naꞌa vaꞌi anggur yai. ");
INSERT INTO frd_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Tamata yai nti ma nfalak vali verin yanan iwarin a ne, ‘Baba, amar ini muti ma mkarya naꞌa vaꞌi anggur.’ Yanan iwarin yai nfalak ne, ‘Oꞌu ta bapa.’ Naꞌuk ia wol nti ma nkarya. ");
INSERT INTO frd_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ba tali yanan a brana irua yai, na iki not-orang afa i yaman a nfalak a?” Ira rfalak ne, “Yanan iyaꞌan.” Ba Yesus nfalak verin dawan Yahudi avyai ne, “Afa i ufalak verin mia ini, kena urun! Tamata ovi baꞌi rera babahir kulu, ovu vatlean ra, veka ula ira ma ti rnaꞌa Ubu Ni Fareta, beti mia. ");
INSERT INTO frd_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Tevek Yohanes nma ma nair mia ma nfaturu banbanan ovi kena ra verin mia, naꞌuk wol myorang ia. Naꞌuk tamata ovi baꞌi rera babahir kulu ra, ovu vatlean ra, saꞌi rorang ia. Mia mryenar ovu msyiꞌik ne, ira rahil roak ma rtalik tali rira salasilan ra, naꞌuk wol myahil ma mtyalik tali bira salasilan ra ma myorang vaivatul ovi Yohanes nfalak a.” ");
INSERT INTO frd_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Eka mryenar vaivatul kamkuma isa ewal. Tamata isa notu vaꞌi anggur naꞌa ni lanun a. Ia notu ngean ma nlilit ni vaꞌi a, ovu nkear wan isa ma al raramat anggur vuan ra naꞌa. Ia nfadiri sari isa felan a wean farwan ma rata rdoku al rwanar ni vaꞌi a. Notu munuk wean inyai, na nala verin tamata vaꞌi ra, ma rasusan ni vaꞌi yai, ma ki rsiduk anggur boku verin ia. Nata nban-talik ni ahu ma nti wan raroa. ");
INSERT INTO frd_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ba ti ma naran amar i rfufu anggur vuan ra, na vaꞌi duan nsinir ni tamata sansinir boku ti ma rala ni wahat tali tamata ovi rwanar ni vaꞌi a. ");
INSERT INTO frd_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Naꞌuk tamata sansinir avyai rati raran vaꞌi anggur yai, na tamata ovi rwanar vaꞌi yai rtaha lahir ira. Ira rvaval isa, rfedan isa ovu vali rteva isa. ");
INSERT INTO frd_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ba vaꞌi duan nsinir ni tamata sansinir liak boku vali ma rti ewal, naꞌuk ira rivun rahi tamata sansinir ovi rti ula roak ira. Naꞌuk tamata ovi rwanar vaꞌi yai rotu sian vali ira, wean sansinir ovi rti lan roak a. ");
INSERT INTO frd_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ti nata vaꞌi duan a nanovak ne, ‘Tamata avyai veka ralang yanan brana a, ba nsinir yanan a ma nati vali.’ ");
INSERT INTO frd_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Naꞌuk ti ma tamata ovi rwanar vaꞌi yai rarea vaꞌi duan yanan brana yai, na rsifalak afa verin ira ne, ‘Tamata ini vaꞌi duan yanan a brana a, ba mya ma tfedan ia, boma tala vaꞌi ini verin ita.’ ");
INSERT INTO frd_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ba rtaha yanan yai ma ti rvatuk ia naꞌa vaꞌi yai murin a, beti rfedan ia.” ");
INSERT INTO frd_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yesus norat dawan Yahudi ra ne, “Ba wean i vaꞌi duan a nma, na veka notu afaka verin tamata ovi rwanar ni vaꞌi a?” ");
INSERT INTO frd_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ira rfalak verin Yesus ne, “Ia veka nma ma nfedan tamata ktufan avyai. Ia nala ni vaꞌi a verin tamata liak ma rwanar, boma naran ni amar i rfufu anggur ra, na rala vali ni wahat a verin ia.” ");
INSERT INTO frd_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yesus nfalak verin ira ne, “Mia wol byas obin Ubu Ni vaivatul ovi naꞌa Surat Ralan? Vaivatul avyai wean ini: Vatu i tukan ra rvatuk yai, fyawan lia munuk ma al nfangrebat rahan a. Afa i Duilaꞌa notu lolin urun, ovu notu ma tamata ra rtalkaka. ");
INSERT INTO frd_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ba ufalak verin mia ne, Ubu veka notu ma wol wabira roak naꞌa Ni Fareta a, naꞌuk veka nala tamata ovi rot-orang afa ovi ralan a nfalak ra ma notu ma rnaꞌa Ni Fareta a.  ");
INSERT INTO frd_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Tamata iki watan wol norang Ubu, na ia wean tamata i nleka nsuta vatu yai ratan a ma nablewar lahir. Wean i vatu yai nleka ma ntaꞌi tamata isa, na tamata yai veka manminan lahir ia.” ");
INSERT INTO frd_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ti ma Yahudi rira dawan mela falurut ra ovu tamata Farisi ra rarenar vaivatul kamkuma yai, na ira rfan-aran lahir, tevek vaivatul avyai Yesus nala al ntaꞌing ira. ");
INSERT INTO frd_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ba ira rdava lingaꞌan mane rtaha Yesus, naꞌuk rbobar, tevek tamata rivun rorang ne, Yesus yai nabi Ia. ");
INSERT INTO frd_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesus nal-ewal vaivatul kamkuma ma nfalak verin ira ne, ");
INSERT INTO frd_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Ubu Ni Fareta ralan wean raja isa i mane notu snobsifa verin yanan brana a. ");
INSERT INTO frd_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ia nsinir ni tamata sansinir ra ma ti rera tamata ovi nasweang roak ira ma rma snobsifa yai, naꞌuk tamata avyai rafena rma. ");
INSERT INTO frd_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ia nsinir ni tamata sansinir liak boku vali ma nfalak verin ira ne, ‘Fyalak verin tamata ovi usweang roak ira yai ne, tasusan munuk roak afamtahan ra, ovu tfedan roak afwatan ra, wean sapi brana, ovu sapi yanat ovi rfaꞌan ma dawan roak ira. Fyalak vali verin ira ne, afa avyai ramtahan munuk roak, ba rma kikyai snobsifa ini.’ ");
INSERT INTO frd_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Naꞌuk tamata ovi rasweang ira yai wol rkamlabir ma rti snobsifa yai. Boku rti rira vaꞌi ra, na boku vali rti ma rasusan rira karya liak ra. ");
INSERT INTO frd_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Boku vali rtaha tamata sansinir ovi raja nsinir ira yai ma rwi-rwa ira, ovu rfedan ira. ");
INSERT INTO frd_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ti ma raja nrenar afa avyai, na nangrova urun, ba nsinir ni suldadu ra ma ti rfedan munuk tamata ovi rfedan ni sansinir ra, ovu rasnuri rira kota. ");
INSERT INTO frd_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Nata nfalak verin ni tamata sansinir liak boku vali ne, ‘Tasusan munuk roak ma totu snobsifa, naꞌuk tamata ovi tasweang roak ira, wol inovan ma rma snoba ini. ");
INSERT INTO frd_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ba miti lingaꞌan dawan ra ma misweang tamata iki watan naꞌa ineri, ma fyalak ma rma snobsifa ini.’ ");
INSERT INTO frd_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Tamata sansinir avyai rti ma rasdovu munuk tamata ovi rtuan ira naꞌa lingaꞌan ra, ba ti nata wan i rotu snobsifa naꞌa yai nngora lahir. Tali tamata ovi rasweang ira yai, na boku rmarkai, naꞌuk boku vali raktufan. ");
INSERT INTO frd_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Nata raja yai nti snobsifa ralan ma ntuan ni mangun avyai, na nsiꞌik tamata isa ni kadaravit wol inovan ma nma snobsifa yai. ");
INSERT INTO frd_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ba nfalak verin ia ne, ‘Kida, notu afakinimi mwa ini, na meluk kadaravit i wol inovan naꞌa snoba i?’ Tamata yai wol vain. ");
INSERT INTO frd_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Raja nfalak verin ni tamata ra ne, ‘Mkyeak tamata yai ean ovu liman a ma ti byatuk ia naꞌa deda fafyat ralan. Naꞌa inyai, na tamata ra rvakar ovu nifarira ra rsitutu watan ira, tevek rfarnuang wawaꞌuk i dawan a.’ ” ");
INSERT INTO frd_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yesus nfamalik munuk roak vaivatul kamkuma yai, beti nfalak ne, “Ubu nera tamata rivun, naꞌuk nfili ifira watan.” ");
INSERT INTO frd_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Tamata boku tali sidovung Farisi rti ma rfamalik ne, wean inba ma rangrihi waweang Yesus, ma al rdava mane rfaleka Ia naꞌa Ni vaivatul ra. ");
INSERT INTO frd_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ba rsinir rira tamata boku, ovu boku vali tali ovi rorang Herodes ma ti rorat Yesus ne, “Tuan Guru, ami amkaꞌa ne, afa ovi fwalak ra kena lalawatan, ovu vali Oa msiair ovu ni malolan a wean Ubu ralan nfalak a. Oa wol bwobar tamata, tevek wol fwili tamata ovu wol mdava waham ralan. ");
INSERT INTO frd_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Amera verin Oa ma eka fwalak verin ami ne, dida agama nfalak ne, kena ma tbahir kulu verin Kaisar te wahal?” ");
INSERT INTO frd_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Yesus nkaꞌa rira siweang ra, ba nfalak verin ira ne, “Hoi, mia baꞌi msyiklabir ma fyalak afa isa, naꞌuk myotu afa liak. Notu afakinimi mane mlyabir teman Yaꞌa i? ");
INSERT INTO frd_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Eka fyaturu kubang i baꞌi myala ma al byahir kulu a ma usiꞌik.” Ba rala kubang dinar isa ma nsiꞌik. ");
INSERT INTO frd_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ba norat ira ne, “Tamata iki walun ovu naran a naꞌa kubang ini?” ");
INSERT INTO frd_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ira rfalak ne, “Kaisar walun ovu naran a.” Yesus nfalak verin ira ne, “Myala verin Kaisar afa ovi ia nia ra, ovu vali myala verin Ubu afa ovi Ubu Nia ra.” ");
INSERT INTO frd_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Yesus nfalak wean inyai, na rtalkaka lahir, ba rban-talik Ia. ");
INSERT INTO frd_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Amar yai vali, na tamata boku tali sidovung Saduki rma ma rorat afa tali Yesus. Ira wol rorang ne, tamata matmatan ra veka rvaꞌat ewal, ba rorat Ia ne, ");
INSERT INTO frd_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Tuan Guru, Musa nfalak ne, ‘Wean i brana isa nmata ma teran aꞌuk awan a, naꞌuk wol yanarira, na brana yai aꞌan te warin nal-ewal varu yai ma neluk awan, ma fara ia i nmata roak yai veka duan yanan boku.’ ");
INSERT INTO frd_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Lan ana, brana ifitu iyaꞌan iwarin ira. Iyaꞌan nsifa roak, naꞌuk wol yanan obin, na nmata. Ia warin nsifa ewal ovu varu yai. ");
INSERT INTO frd_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Naꞌuk wol yanar obin, na brana yai nmata. Ba varu yai nsifa ewal ovu warin isa vali. Wean inyai lalawatan, nata ti naran iwarin tutul a. ");
INSERT INTO frd_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Brana ifitu yai rmata munuk, beti vata yai nmata vali. ");
INSERT INTO frd_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ba wean inyai, na ti naran amar i tamata matmatan ra rvaꞌat ewal, na iki veka awan mngaꞌun vata yai, tevek brana ifitu yai awar munuk roak ia?” ");
INSERT INTO frd_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesus nfalak verin ira ne, “Mia sala ma dawan mia, tevek wol fyan-aran Surat Ralan a, ovu wol mkyaꞌa Ubu Ni ngrebat a! ");
INSERT INTO frd_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Naꞌut i tamata ovi rmata roak rvaꞌat ewal, na ira veka wol rsifa roak, ba rvaꞌat wean Ubu Ni sansinir ra naꞌa lanit ratan. ");
INSERT INTO frd_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Mia wol byas obin naꞌa Ubu Ni vaivatul ovi rfamalik naꞌa tamata ovi rmata roak, naꞌuk veka rvaꞌat ewal a? Ubu nfalak verin mia naꞌa Ni Surat Ralan ne, ");
INSERT INTO frd_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Yaꞌa ini Ubu i Abraham, Ishak ovu Yakub baꞌi raraning a.’ Matmatan ra wol raraning Ubu, naꞌuk tamata ovi rvaꞌat ra saꞌi raraning Ia.” ");
INSERT INTO frd_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ti ma tamata rivun avyai rarenar afa ovi Yesus nair ra, na rtalkaka lahir. ");
INSERT INTO frd_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ti ma tamata Farisi rarenar ne, Yesus nangrihi ma tamata Saduki ra wol rvalat nala roak Ia, na Farisi avyai rasdovu ewal ira. ");
INSERT INTO frd_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Tali rir tinemun, na dawan Yahudi isa i nair Musa ni inukun ra mane nlabir teman Yesus. Ia norat Yesus ne, ");
INSERT INTO frd_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Tuan Guru, inukun bi nlia munuk tali Musa ni inukun ra?” ");
INSERT INTO frd_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesus nfalak verin ia ne, “ ‘Oa musti mlobang Duilaꞌa, mu Ubu i mraning Ia a, ovu ralam urun. Mala munuk mu vavaꞌat verin Ia, ovu mala munuk mu kakaꞌa al mlobang Ia.’ ");
INSERT INTO frd_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Inyai inukun i nlia munuk tali inukun ra. Inukun ini ula lalean ia, beti inukun liak ra. ");
INSERT INTO frd_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Inukun isa vali i norang i ula lalean yai wean ini, ‘Oa musti mlobang vali tamata liak ra, wean watan i mlobang tenam a.’ ");
INSERT INTO frd_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Musa ni inukun ra munuk ovu afa ovi nabi rair ra, rakloꞌi aꞌuk naꞌa inukun irua ini.” ");
INSERT INTO frd_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Tamata Farisi avyai rasdovu ira obin, na Yesus norat ira ne, ");
INSERT INTO frd_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Mia minovak aka naꞌa Kristus, Raja i veka ntevut bira salasilan ra? Ia ubun nusin verin iki?” Ira rfalak ne, “Raja Daud ubun-nusin Ia.” ");
INSERT INTO frd_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ba Yesus norat ewal ira ne, “Wean i afa i fyalak yai kena, na notu afakinimi Ubu Ni Roh nfalak verin Daud ma nfalak ne, ni Duilaꞌa verin Ia. Daud nfalak ne, ");
INSERT INTO frd_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Ubu nfalak verin ning Duilaꞌa ne: Mdoku Ning lihir mela a, ti naran i otu ma tamata ovi rira sian Oa rsoak nulu Oa.’ ");
INSERT INTO frd_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ba wean i Daud nera Kristus ne, ‘Ning Duilaꞌa,’ na wean inba ma ubun-nusin vali Ia?” ");
INSERT INTO frd_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Wol tamata isa vali nvalat nala Ia. Ba tali amar yai, na wol tamata isa vali nabrahi ma norat afa tali Yesus. ");
INSERT INTO frd_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ba Yesus nfalak verin Ni tamata ovi rorang Ia ovu tamata rivun vali ne, ");
INSERT INTO frd_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Tamata Yahudi rira dawan ovi rair Musa ni inukun ra ovu Yahudi ovi rtali sidovung Farisi, ira rfalyawang Musa ni inukun ra, tevek rkaꞌa ma lolin afa ovi Musa ntulis. ");
INSERT INTO frd_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ba myot-orang munuk afa ovi rair verin mia, naꞌuk deka myot-orang afa ovi rotu ra. Ira rira vavaꞌat ra wol kena ovu afa ovi rair ra. ");
INSERT INTO frd_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ira rala varvara aleman verin tamata ra tali afa ovi rair ra, naꞌuk ira wol rlauk limarira ra al rlobang tamata ra, ma rot-nala afa ovi rair ra. ");
INSERT INTO frd_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ira rtulis vaivatul boku tali Surat Ralan a ma rkeak naꞌa ulurira te naꞌa limarira ra. Ira roru ravit blawat i ni wahan nsoli lanun a. Ira rotu munuk afa avyai naꞌa tamata rivun waharira ralan ra, boma tamata ra rsiꞌik ma rfadawang ira. ");
INSERT INTO frd_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ira inar ma rdoku wan ovi tamata ra baꞌi ralang ira naꞌa snoba ra ovu naꞌa rahan falurut ra. ");
INSERT INTO frd_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ira inar vali ma tamata ra ralang ira, ma rala salam verin ira naꞌa wan i rfedi-rfaha afa naꞌa, ovu inar ma tamata ra rera ira ne, ‘Tuan guru.’ ");
INSERT INTO frd_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Naꞌuk mia deka inabira ma tamata ra rfadawang mia ma rera mia ne, ‘Tuan guru.’ Tevek Tuan Guru mngaꞌun isa watan, ovu vali bir tinemun weabira isa watan. ");
INSERT INTO frd_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Mia deka fyadawang tamata ovi rnaꞌa lanit ivavan ini ma fyalak ne, ‘Bapa,’ tevek Yamadida ikisa watan naꞌa lanit ratan. ");
INSERT INTO frd_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Mia deka inabira vali ma tamata ra rfalak mia ne, tamata dawan mia, tevek Yaꞌa Raja i utevut bira salasilan ra, ovu Yaꞌa saꞌi uban-ulu verin mia. ");
INSERT INTO frd_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ba tamata i ni dawan a nlia tamata ra munuk naꞌa bira sidovung a, na ia musti neluk tamata sansinir verin mia. ");
INSERT INTO frd_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Tevek tamata iki watan nfakaratat tenan a, na Ubu veka nfakabava ia. Naꞌuk tamata iki watan nfakabava tenan a, na Ubu veka nfakaratat ia.” ");
INSERT INTO frd_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Mia dawan Yahudi ovi myair Musa ni inukun ra ovu ovi mtyali sidovung Farisi, veka sian urun i lahir verin mia! Mia baꞌi fyalak afa isa, naꞌuk myotu afa liak! Ba afa ovi myair verin tamata ra wol kena ovu Ubu Ni vaivatul ra, tevek fyalak teri tamata ra ma deka ti rnaꞌa Ni Fareta a. Mia wol wabira naꞌa Ubu Ni Fareta a, ovu vali myotu teri tamata ovi mane ti rnaꞌa Ni Fareta.  ");
INSERT INTO frd_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Mia dawan Yahudi ovi myair Musa ni inukun ra ovu ovi mtyali sidovung Farisi, veka sian urun i lahir verin mia! Mia baꞌi fyalak afa isa, naꞌuk myotu afa liak! Mia mingrihi ma mlyabir tia ma watan varu ra ma myala rira metan ra, ti naran i myala rira rahan ra. Bira falurut ra blawat urun, ma al mtyeri afa sian ovi myotu ra. Naꞌuk Ubu veka nukun mia ovu inukun i aleman urun, ma nlia tamata liak ra! ");
INSERT INTO frd_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Mia dawan Yahudi ovi myair Musa ni inukun ra ovu ovi mtyali sidovung Farisi, veka sian urun i lahir verin mia! Mia baꞌi fyalak afa isa, naꞌuk myotu afa liak! Mia myobal te byaꞌal vuar ra ala mdyava tamata liak i mane norang bira inukun ra. Tamata yai norang roak mia, ba myotu sian roak tamata yai ma ni salasilan nlia nala farua mia. Ba ia veka nti urun yafwan kakiwal wean vali mia. ");
INSERT INTO frd_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Mia Yahudi ovi byan-ulu verin tamata ra, veka sian urun i lahir verin mia! Mia weabira tamata kibu ovi rfaturu lingaꞌan verin tamata liak ra. Myair tamata ra ne, wean i tamata iki watan nala Rahan Dawan Falurut naran a al nafwaba, na inyai wol ihin akataka. Naꞌuk tamata iki watan nala masa i naꞌa Rahan Dawan Falurut ma al nafwaba, na ia musti nfakena ni tnorung a. ");
INSERT INTO frd_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Yaꞌi yo! Mia tamata ovi mkyibu ovu byoda ra. Mia mkyaꞌa roak ne, Rahan Dawan Falurut fyawan lia munuk masa ovi rnaꞌa ralan a. Rahan Dawan Falurut kaꞌi notu ma masa yai nmerat urun ovu fyawan. ");
INSERT INTO frd_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Mia fyalak vali ne, tamata iki watan nala wan i baꞌi rasnuri rira korban ra naꞌa ma al nafwaba, na wol ihin akataka, tevek wol nfakena ni tnorung a. Naꞌuk tamata iki watan nfalak ne, afa ovi nfadoku roak naꞌa wan yai ma al nafwaba, na ia musti nfakena ni tnorung a. ");
INSERT INTO frd_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Hoi! Matabira ra betane rkibu urun roak! Mia mkyaꞌa roak ne wan i baꞌi rasnuri rira korban ra naꞌa yai, fyawan lia korban i rasnuri roak a. Tevek wan i rasnuri rira korban ra naꞌa yai nmerat urun, ba rira korban ra rmerat urun vali. ");
INSERT INTO frd_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Wean i tamata isa nala wan i rasnuri rira korban ra naꞌa yai ma ala nafwaba, na ia nafwaba vali verin afa ovi rnaꞌa wan i baꞌi rasnuri rira korban ra naꞌa yai ratan a. ");
INSERT INTO frd_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Wean i tamata isa nala Rahan Dawan Falurut al nafwaba, na ia nafwaba roak ovu Rahan Dawan Falurut yai naran a ovu Ubu i nleal inyai. ");
INSERT INTO frd_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Wean i tamata isa nala lanit ratan al nafwaba, na ia nafwaba roak ovu wan i Ubu ndoku ma nfareta, ovu vali Ubu i ndoku wan yai. ");
INSERT INTO frd_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Mia dawan Yahudi ovi myair Musa ni inukun ra ovu ovi mtyali sidovung Farisi, veka sian urun i lahir verin mia! Mia baꞌi fyalak afa isa, naꞌuk myotu afa liak! Mia myala persen vutu tali bira vaꞌi bumbu ra, nararira selasih, adas manis ovu jintan verin Ubu, naꞌuk wol myot-orang inukun ovi rbana ula lalean ra naꞌa Musa ni inukun ra. Inukun avyai wean ini: Myotu afa ovi kena ra verin tamata ra munuk ovu fyaturu bira silobang verin tamata liak, ovu vali myot-orang munuk afa ovi Ubu nfalak roak verin mia. Myot-orang inukun ovi ula lalean avyai, ovu vali deka miblufang ma myotu vali afa liak ovi Ubu nfareta roak. ");
INSERT INTO frd_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Mia Yahudi ovi byan-ulu verin tamata ra, weabira tamata kibu ovi rfaturu lingaꞌan verin tamata liak ra! Myaling vatuk afwatan koꞌu wean barboras tali wear i myenu a, naꞌuk afwatan dawan i naran unta mtyelas watan! ");
INSERT INTO frd_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Mia dawan Yahudi ovi myair Musa ni inukun ra ovu ovi mtyali sidovung Farisi, veka sian urun i lahir verin mia! Mia baꞌi fyalak afa isa, naꞌuk myotu afa liak! Mia mryaming bira moko ovu bira binan muririra ra ma rmerat, naꞌuk ralarira ra ngra-ngrodi obin. Mia vali ralabira ra ngra-ngrodi wean inyai, ba inabira ma myala tamata liak rira metan ra, ovu fyikir aꞌuk tenabira ra. ");
INSERT INTO frd_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Hoi Farisi averi, matabira rkibu! Fyamerat lan ralabira ra veki, boma bira afa ovi myotu ovu fyalak ra veka lolin vali. Inyai wean mryaming bira moko ralarira ra veki ma rmerat, na muririra ra veka rmerat vali. ");
INSERT INTO frd_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Mia dawan Yahudi ovi myair Musa ni inukun ra ovu ovi mtyali sidovung Farisi, veka sian urun i lahir verin mia! Mia baꞌi fyalak afa isa, naꞌuk myotu afa liak! Mia weabira kubur ovi rsoka ira ma rangiar ma rsiꞌik tali murin, na lolin. Naꞌuk naꞌa ralarira ra, na rngora ovu tamata luririra ra, ovu vali afa ovi ngra-ngrodi ra munuk. ");
INSERT INTO frd_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Mia weabira vali inyai. Tamata ra rsiꞌik bira afa ovi myotu ra kena, naꞌuk ralabira ra rngora ovu bira salasilan ra, wean lahir tamata ovi baꞌi rfalak afa isa, naꞌuk rotu afa liak! ");
INSERT INTO frd_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Mia dawan Yahudi ovi myair Musa ni inukun ra ovu ovi mtyali sidovung Farisi, veka sian urun i lahir verin mia! Mia baꞌi fyalak afa isa, naꞌuk myotu afa liak! Myotu ma nabi rira kubur ra lolin buas, ovu myaꞌang vatu ra ma karatat naꞌa kubur avyai. Tamata ovi lan a rira vavaꞌat ra rmalola rnaꞌa kubur avyai. ");
INSERT INTO frd_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Mia fyalak ne, wean i byaꞌat naꞌut i ububir-nusibira rvaꞌat a, na mia wol mtyorung ma rfedan nabi ra. ");
INSERT INTO frd_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Naꞌuk tali bira vaivatul ra, na fyaturu roak ne, mia weabira ububir-nusibira ovi rfedan nabi ra. ");
INSERT INTO frd_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Mia fyabana munuk afa sian ovi ububir-nusibira ra rotu a, ba Ubu veka nukun mia vali. ");
INSERT INTO frd_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Mia sian mia ovu vali ububir-nusibira ra wearira nifa isa naran aru. Deka minovak ne, Ubu wol nukun mia ma miti mnyaꞌa yafwan kakiwal. ");
INSERT INTO frd_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Eka mryenar! Wean inyai bi veka usinir nabi ra ovu tamata ovi rira kakaꞌa dawan ra, ovu vali dawan ovi rair Musa ni inukun ra ma ti rtuan mia. Naꞌuk mia veka fyedan boku tali ira, ovu byaku boku naꞌa aa walwalur, boku vali myi-mya ira naꞌa bira rahan falurut ra. Mlyabas boku vali tali ahu isa ma miti ahu liak vali ma fyedan ira. ");
INSERT INTO frd_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ba mia veka byara munuk varvara naꞌa tamata ovi rira vavaꞌat ra rmalola yai, tevek fyedan ira. Tali lalan ana, ububir-nusibira ra rsifedan. Ira rfedan lan Habel i ni vavaꞌat a nmalola. Mia fyedan vali tamata liak ovi rira vavaꞌat rmalola a, ti naran i fyedan Bereka yanan a Zakharia. Mia fyedan ia naꞌa Rahan Dawan Falurut a, ovu wan i baꞌi misnuri bira korban ra verin Ubu, fruarira ra. ");
INSERT INTO frd_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Afa i ufalak verin mia ini, kena urun! Mia kaꞌi byara munuk afa sian ovi ububir-nusibira rotu ra, ba Ubu veka nukun mia.” ");
INSERT INTO frd_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Nata Yesus nfalak ne, “Tamata ovi mnyaꞌa Yerusalem! Mia fyedan nabi ra ovu mtyev-fedan tamata ovi Ubu nsinir ira rma rtuan mia! Yaꞌa umaseak dalang roak ma usdovu mia, wean manut itai isa nkoka yanan ra naꞌa manin vavan a, naꞌuk mifena ma otu wean inyai. ");
INSERT INTO frd_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Eka mryenar ma lolin! Ubu veka nti talik bira Rahan Dawan Falurut a, ba veka vu watan. ");
INSERT INTO frd_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ufalak verin mia ne, tali amar ini veka wol msyiꞌik roak Yaꞌa, nata ti naran i veka fyalak ne, ‘Ubu naflahar Ia i nma ovu Duilaꞌa naran a.’ ” ");
INSERT INTO frd_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ti ma Yesus nban-talik Yahudi rira Rahan Dawan Falurut yai ma wol kaꞌi raroa obin, na Ni tamata ovi rorang Ia rma ma rebang Ia, beti rfaturu Rahan Dawan Falurut ovu rahan ovi rdir-ebang Rahan Dawan Falurut. ");
INSERT INTO frd_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yesus nfalak verin ira ne, “Mia msyiꞌik roak ne, rahan averi felar lolin urun? Afa i ufalak verin mia ini, kena urun! Ni amar veka nma, ma vatu ovi rotu naꞌa rahan averi veka ramaꞌar munuk, ma wol teran vatu isa vali naꞌa wan a.” ");
INSERT INTO frd_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesus ti ma ndoku vuar Zaitun a, na Ni tamata ovi rorang Ia rti ma rorat aling afa tali Ia. Ira rorat Ia ne, “Bapa, amera ma fwalak verin ami ne, naꞌut inba na afa ovi beti fwalak yai veka rvotuk? Faneak aka veka nvotuk ma nfaturu ne, mane mwa ewal? Faneak aka vali veka nvotuk ma nfaturu ne, lanit ivavan a mane namwear?” ");
INSERT INTO frd_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ba Yesus nfalak verin ira ne, “Msyiꞌik wabira ma lolin, boma tamata ra deka rlabir nala mia! ");
INSERT INTO frd_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ufalak wean inyai, tevek tamata rivun veka rma ma rala narang a, ma lokat ira kaꞌi rfalak ne, ‘Yaꞌa Raja i ntevut bira salasilan ra.’ Ira veka rlabir nala tamata rivun. ");
INSERT INTO frd_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Mia veka mryenar ne, tamata ra rotu rihi, ovu ivar ne, rihi ra rvotuk, naꞌuk deka byobar. Afa avyai veka rma urun, naꞌuk lanit ivavan a wol namwear obin. ");
INSERT INTO frd_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Bangsa isa veka notu rihi ovu bangsa liak. Fareta dawan isa veka notu rihi ovu fareta dawan liak. Naꞌa lanit ivavan a, na veka ruru ovu lafar dawan naꞌa wan rivun. ");
INSERT INTO frd_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Naꞌuk afa avyai munuk reluk faneak ne, susa ra beti rvotuk. Wawaꞌuk ovi naꞌa amar avyai wean wawaꞌuk i vata ovi mane rarali ira rfarnuang a. ");
INSERT INTO frd_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Naꞌut inyai, na tamata ovi rangal mia veka rtaha mia ti verin tamata ovi veka rwi-rwa mia ma rotu sian mia, ovu veka rfedan mia. Tamata ra tali inba watan naꞌa lanit ivavan a veka wol inar lahir mia, tevek myorang Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Naꞌut inyai, na tamata rivun vali veka rafla talik lahir rira inorang a, ma rotu aꞌuk afa ovi sian ra. Ira veka rsifedi-sikual ira, ovu vali isa wol inan lahir isa. ");
INSERT INTO frd_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Tamata rivun veka rma ma rsiklabir ma rfalak ne, nabi ira. Ira veka rlabir tia ma watan tamata ra ma rorang ira. ");
INSERT INTO frd_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Afa sian ovi tamata ra rotu veka ntafal ma dawan, ma tamata rivun veka wol rsilobang roak ira. ");
INSERT INTO frd_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Naꞌuk tamata ovi rorang Yaꞌa ti naran amar i rmata, na Ubu veka nsikat ira tali rira salasilan ra, ma rira vavaꞌat kakiwal. ");
INSERT INTO frd_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Tamata ovi rorang Yaꞌa veka rfamalik Ubu Ni Ivar Lolin i nfalak ne, Ubu veka nfareta tamata ra wean lahir Raja. Ira veka rfamalik Ivar yai verin bangsa ra munuk, beti lanit ivavan a namwear.” ");
INSERT INTO frd_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Lan a, na nabi Daniel nfamalik ne, mia veka msyiꞌik afa isa i sian urun ndiri wan i nmerat urun naꞌa Ubu Ni Rahan Dawan Falurut ralan a, ma nfangra ia. Mia tamata ovi byas ini, eka msyiꞌik ma lolin, boma fyan-aran ni vaivatul ra. ");
INSERT INTO frd_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Amar yai, na tamata ovi rnaꞌa propinsi Yudea musti rafla talik wan yai ma rti vuar ra. ");
INSERT INTO frd_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Tamata ovi ryari ira naꞌa rira rahan ratan ra, deka rsuta ma rala rira afa ovi rnaꞌa rira rahan ralan. ");
INSERT INTO frd_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Tamata ovi rkarya naꞌa rira vaꞌi ra deka rewal ira rma rira rahan ra ma rala rira kadaravit ra. ");
INSERT INTO frd_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Naꞌut inyai, na veka sian urun i lahir verin vata ovi rbarlewan ra ovu ovi rsusu kasikoꞌu yanat ra. ");
INSERT INTO frd_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Miflurut verin Ubu, boma naꞌa amar i mifla yai, na deka naꞌut i daꞌut ovu radridin, te naꞌa amar i tyari ita. ");
INSERT INTO frd_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Amar ovi veka rma yai, na tamata ra veka rtuan susa dawan ilaꞌa. Tali amar i Ubu notu lanit ivavan a ti naran amar ini, na tamata ra wol rtuan susa i wean inyai obin. Susa i wean inyai, tamata veka wol rtuan roak. ");
INSERT INTO frd_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Wean i Ubu wol nfaketa amar avyai, na veka wol tamata isa nvaꞌat vali. Naꞌuk Ubu nlobang Ni tamata ovi nfili ra, ba veka nfaketa amar avyai. ");
INSERT INTO frd_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Naꞌut inyai, na wean i tamata ra rfalak verin mia ne, ‘Eka msyiꞌik. Raja i ntevut dida salasilan ra nma roak, ma nanaꞌa ini te nanaꞌa ineri,’ naꞌuk deka myorang ira! ");
INSERT INTO frd_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Tevek naꞌut inyai, na tamata boku veka rsiklabir ma rfalak ne, ira Raja i ntevut bira salasilan ra, ovu rfalak vali ne, nabi ira. Ira veka rotu faneak ovi wol tfikir aran ra, ovu mujizat ra ma rlabir tamata ra, boma tamata ranovak ne, rira ngrebat a ntali Ubu. Wean i rot-nala afa avyai, na ira veka rlabir nala vali tamata ovi Ubu nfili ra. ");
INSERT INTO frd_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ba msyiꞌik wabira ma lolin! Velik ne wol naran ni amar obin, naꞌuk ufalak lan roak verin mia, boma tamata ra wol rlabir nala mia. ");
INSERT INTO frd_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Wean i tamata ra rfalak verin mia ne, ‘Eka msyiꞌik Kristus nanaꞌa wan lean vu dawan eri.’ Te rfalak ne, ‘Ia nanaꞌa rahan ralan eri,’ na deka myorang afa avyai. ");
INSERT INTO frd_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Tevek fitik nfitik tali lihir timur ma nyelar nti lihir varat, ba Yaꞌa, Tamata Yanan Yaꞌa, veka uma ewal lanit ivavan ini wean vali inyai, ma tamata ra munuk rsiꞌik. ");
INSERT INTO frd_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Wean i msyiꞌik ne, manut nangan dawan ovi baꞌi raꞌan afa matmatan ra rasdovu ira, na tkaꞌa vali ne, afa matmatan nanaꞌa inyai. Inyai neluk faneak roak ne, Yaꞌa veka uma ewal.” ");
INSERT INTO frd_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Naꞌut i susa dawan avyai rlia roak, na amar yai lahir lera a veka wol vanan, vulan wol nyeba, ovu vali nara ra veka rleka tali lanit rsuta. Afa ovi rira ngrebat ra naꞌa lanit veka rarwaꞌung ma rasmoang tia ma watan ira. ");
INSERT INTO frd_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Naꞌut inyai, na faneak veka nvotuk naꞌa lanit ma nfaturu ne, Yaꞌa, Tamata Yanan Yaꞌa ini, veka uma ewal. Tamata ra munuk naꞌa lanit ivavan ini veka rvakar ma rfaktanit, tevek rsiꞌik Yaꞌa, Tamata Yanan Yaꞌa, unaꞌa mutan ratan ra uma ovu Ning ngrebat dawan a, ovu vali vanang a nfitik nyadat. ");
INSERT INTO frd_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ba Ubu veka nafraik tvuri ma ngoan dawan ilaꞌa ovu ufareta Ning sansinir ra tali lanit ratan ma rti rasdovu tamata ovi Ubu nfili roak ma rorang Yaꞌa, tali inba watan naꞌa lanit ivavan. ");
INSERT INTO frd_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Eka myair tali aa i rfanara ia ne, ara. Wean i anan ra raftuvul ewal ma rafroang, na inyai neluk faneak verin mia ne, lera dawan sarseri roak. ");
INSERT INTO frd_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Wean i mryea munuk roak afa ovi ufalak avyai, na veka mkyaꞌa lahir ne, sarseri roak ma uma ewal. ");
INSERT INTO frd_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Afa i ufalak verin mia ini, kena urun! Tamata ovi rvaꞌat fiang ini veka wol rmata munuk obin, na afa avyai munuk rvotuk roak. ");
INSERT INTO frd_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Lanit ovu afa ovi rnaꞌa lanit ivavan a veka ramwear, naꞌuk Ning vaivatul ra rnaꞌa kakiwal watan.” ");
INSERT INTO frd_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Wol tamata isa nkaꞌa ne, lafira ki amar i ufalak yai nma. Ubu Ni sansinir ra naꞌa lanit ratan wol rkaꞌa vali. Ubu Yanan Yaꞌa ini wol ukaꞌa vali. Yamang aꞌuk saꞌi nkaꞌa. ");
INSERT INTO frd_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Amar i Yaꞌa, Tamata Yanan a, veka uma, na tamata ra veka wean lahir naꞌut i Nuh nvaꞌat a. ");
INSERT INTO frd_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Naꞌut i wear dawan wol nma obin, na tamata ra rafnaꞌan-rafnenu, ovu rsifa wean watan wean a, ti naran amar i wear dawan nma ma Nuh nrata ni kabal a. ");
INSERT INTO frd_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ira wol rkaꞌa ne, wear dawan mane nma ma nfedan munuk ira. Yaꞌa, Tamata Yanan Yaꞌa, veka uma wean vali inyai, ma ufabriang tamata ra munuk. ");
INSERT INTO frd_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Naꞌut inyai, na wean i tamata irua rkarya naꞌa vaꞌi, na Ubu veka nala isa, naꞌuk isa nanaꞌa watan. ");
INSERT INTO frd_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Wean i vata irua rbutar slaru naꞌa batu putar, na Ubu veka nala isa, naꞌuk isa nanaꞌa watan. ");
INSERT INTO frd_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ba wean inyai, na msyiꞌik wabira ma lolin, tevek wol mkyaꞌa ne, lafira ki bira Duilaꞌa nma. ");
INSERT INTO frd_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Mingnanang afa ovi ufalak ini! Wean i rahan duan nkaꞌa ne, ovan jam ifira, na tamata barborin veka nma ni rahan, na ia veka nsiꞌik ma lolin ni rahan a, boma deka nti ni rahan ralan. ");
INSERT INTO frd_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ba wean inyai bi lokat amar, na mia musti msyiꞌik wabira ma lolin, tevek Yaꞌa, Tamata Yanan Yaꞌa, veka uma naꞌut i wol mkyaꞌa.” ");
INSERT INTO frd_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Wean i tamata sansinir isa ni kakaꞌa dawan ovu not-orang lalawatan afa ovi duan nfalak ra, na duan a veka nfili ia ma nfareta tamata sansinir liak ra, ovu lokat amar nala afamtahan ma raꞌan. ");
INSERT INTO frd_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Tamata sansinir yai veka utun urun naꞌut i duan a newal ia, na ntuan ia nfabana ni karya ra. ");
INSERT INTO frd_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Afa i ufalak verin mia ini, kena urun! Tamata sansinir yai duan a veka nfili ia ma nasusan munuk ni metan ra. ");
INSERT INTO frd_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Naꞌuk wean i tamata sansinir yai naktufan ma nanovak naꞌa ralan a ne, ‘Mnanat obin beti duang nma ewal.’ ");
INSERT INTO frd_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ba ti ma nvaval tamata sansinir liak ra, ovu nafnaꞌan-nafnenu ovu tamata ovi ranavut sian ra. ");
INSERT INTO frd_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Nata duan newal ia nma naꞌut i sansinir yai wol nkaꞌa. ");
INSERT INTO frd_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Duan a veka nfar-visal sansinir yai ma nvatuk ia ovu tamata ovi baꞌi rfalak afa isa, naꞌuk rotu afa liak. Irmunuk veka rvakar ovu nifarira ra rsitutu, tevek rfarnuang wawaꞌuk dawan a.” ");
INSERT INTO frd_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Yesus nfalak verin Ni tamata ovi rorang Ia ne, “Naꞌut i veka uma ewal, na Ubu Ni Fareta a wean vaivatul kamkuma naꞌa vata mnelat vutu i rtaha rira damar ra, ma ti rsaꞌa brana i mane nsifa a. ");
INSERT INTO frd_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Tali vata vutu yai, na ilima rboda, na ilima vali rira kakaꞌa dawan. ");
INSERT INTO frd_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Vata ilima i rboda yai rtaha rira damar ra, naꞌuk wol rtaha ngul freꞌi. ");
INSERT INTO frd_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Naꞌuk vata ilima i rbitar yai, rtaha rira ngul freꞌi naꞌa rira suran ra. ");
INSERT INTO frd_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ira rnaban brana i mane nsifa yai, naꞌuk mnanat i nma a, ba matarira ra waswosu roak ma rtuba. ");
INSERT INTO frd_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ti ma nafafruan tenan roak, na rarenar fawak isa ne, ‘Byatar kikyai! Brana i mane nsifa yai sarseri ma nma roak! Miti murin ma msyaꞌa ia.’ ");
INSERT INTO frd_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ba vata avyai rbatar lahir ma rasusan rira damar ra. ");
INSERT INTO frd_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Vata ovi rboda yai rera lablobang tali vata ovi rira kakaꞌa dawan yai ne, ‘Myala bira ngul kedan a verin ami, tevek mami damar ra mane rmata roak.’ ");
INSERT INTO frd_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Naꞌuk vata ovi rira kakaꞌa dawan yai rfalak verin ira ne, ‘Ami wol amala verin mia, beta ne mami ngul a wol naran ami, ovu vali verin mia. Ba miti ma fyaha ngul naꞌa wan i baꞌi rfedi ngul naꞌa.’ ");
INSERT INTO frd_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ba vata ovi rboda yai rti ma rfaha rira ngul. Naꞌut i rti ma rfaha ngul a, na brana i mane nsifa yai nma, ba vata ovi rira kakaꞌa dawan yai rorang ia rti rahan ralan ma rotu snoba, nata falfolat a natfolat. ");
INSERT INTO frd_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ba vata ovi rboda yai rma ewal rahan yai, ma rafwak ne, ‘Bapa, mlobang ma bwadil falfolat a verin ami!’ ");
INSERT INTO frd_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Naꞌuk brana i mane nsifa yai nfalak ne, ‘Afa i ufalak verin mia ini, kena urun! Yaꞌa wol ukaꞌa mia!’ ");
INSERT INTO frd_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ba wean inyai, na msyiꞌik wabira ma lolin, tevek mia wol mkyaꞌa ne, veka ewal Yaꞌa naꞌa amar ba te naꞌut inba.” ");
INSERT INTO frd_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Naꞌut i veka uma ewal a, na Ubu Ni Fareta wean vali vaivatul kamkuma ini. Tamata isa mane nti talik ni rahan a. Ia wol nti obin, na nasdovu ni tamata sansinir ra ma nala karya verin ira ma rasusan ni kubang ra. ");
INSERT INTO frd_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ia nsiduk ni kubang a verin ni tamata sansinir ra ma inovan ovu rira kakaꞌa a. Ia nala kubang masa kadut ilima verin ni sansinir isa. Ia nala vali kubang masa kadut irua verin sansinir isa, beti nala kubang masa kadut isa verin sansinir isa vali. Nsiduk munuk ni kubang masa avyai, beti nfalak verin ira ma ti rfabana kubang avyai. Nata nti talik ira ma nobal. ");
INSERT INTO frd_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Tamata sansinir i nala roak kubang masa kadut ilima yai nti ma nfabana lahir kubang yai, ma utun kubang masa kadut ilima vali. ");
INSERT INTO frd_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Tamata sansinir i nala kubang masa kadut irua yai nti vali ma nfabana kubang yai, ma utun kubang masa kadut irua vali. ");
INSERT INTO frd_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Naꞌuk tamata sansinir i nala kubang masa kadut isa yai nti ma nkear voat, ma noving fanfonak kubang i duan a nala verin ia. ");
INSERT INTO frd_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Yaꞌi mnanat roak, ba tamata sansinir itelu avyai duarira a newal ia ma nasdovu ira, ma nera ma rfamalik naꞌa i wean inba ma rfabana kubang masa ra, boma nkaꞌa ne, utur ifira. ");
INSERT INTO frd_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ba sansinir i nfabana kubang masa kadut ilima yai nma ma ntuan duan a. Ia nala kubang masa kadut vutu verin duan a. Nata nfalak verin duan a ne, ‘Baba, oa mala kubang masa kadut ilima verin yaꞌa. Eka msyiꞌik, utung vali kubang masa kadut ilima, ba utaha uma verin oa.’ ");
INSERT INTO frd_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ba duan nfalak verin ia ne, ‘Mu karya a lolin buas ovu mot-orang afa ovi ufalak ra. Oa mot-nala roak afa ovi ufalak ra naꞌa varvara ovi maraan a, ba veka al vali varvara ovi aleman a verin oa. Mwa ma totu snoba, tevek inad lolin.’ ");
INSERT INTO frd_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Tamata sansinir i nfabana kubang masa kadut irua yai nma vali ma ntuan duan a. Ia nfalak verin ia ne, ‘Baba, oa mala kubang masa kadut irua verin yaꞌa. Eka msyiꞌik, utung vali kubang masa kadut irua ba utaha uma verin oa.’ ");
INSERT INTO frd_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ba duan nfalak verin ia ne, ‘Mu karya a lolin buas ovu mot-orang afa ovi ufalak ra. Oa mot-nala roak afa ovi ufalak ra naꞌa varvara ovi maraan a, ba veka al vali varvara ovi aleman a verin oa. Mwa ma totu snoba, tevek inad lolin.’ ");
INSERT INTO frd_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Nata tamata sansinir i nala kubang masa kadut isa yai nma ma ntuan vali duan a ma nfalak ne, ‘Baba, yaꞌa ukaꞌa ne oa msingarova sian. Oa mala afamtahan naꞌa vaꞌi ovi wol muvuri naꞌa. Oa mnaban watan ma mala tamata liak rira karya enan ra. ");
INSERT INTO frd_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Wean inyai bi ubobar, beta ne otu ma mu kubang a wol nleal ma mukun yaꞌa, ba uti wan isa ma ukear voat ma oving mu kubang a. Eka msyiꞌik, mu kubang a hi ini, ba al ewal verin oa.’ ");
INSERT INTO frd_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Naꞌuk duan nfalak ne, ‘Hoi, tamata ktufan! Oa bwosa sian. Oa fwalak ne, al afamtahan naꞌa vaꞌi ovi wol uvuri naꞌa, ovu unaban watan ma ala tamata liak rira karya enan ra? ");
INSERT INTO frd_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ba wean urun inyai, na velik aba mala ning kubang yai verin tamata ovi rfabana kubang, boma wean i ewal yaꞌa, na al-ewal ning kubang a ovu ni bunga.’ ");
INSERT INTO frd_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Nata tamata yai nfalak verin ni tamata sansinir liak ra ne, ‘Myal-ewal kubang yai tali ia ma myala verin tamata i ni kubang masa kadut vutu a.’ ");
INSERT INTO frd_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Tevek tamata iki watan npake ma lolin afa ovi rnaꞌa roak ia, na Yaꞌa veka ala ma rivun ilaꞌa matan verin ia. Naꞌuk tamata iki watan wol npake ma lolin afa ovi rnaꞌa roak ia, na velik ne koꞌu watan, veka ala munuk tali ia. ");
INSERT INTO frd_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ba byatuk vali tamata i nbosa sian yai nti murin ma naꞌa dedan ralan. Naꞌa wan yai, na tamata ra rvakar lalawatan ovu nifarira ra rsitutu ira tevek rfarnuang wawaꞌuk dawan a.” ");
INSERT INTO frd_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Wean i Yaꞌa, Tamata Yanan Yaꞌa, uma ovu vanang i nfitik nyadat a, na Ning sansinir ra tali lanit ratan veka rovu vali Yaꞌa ma unaꞌa wan i udoku ma ufareta, ma ukun tamata ra munuk. ");
INSERT INTO frd_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Bangsa ra munuk veka rasdovu ira ma rdiri wahang ralan a, ma ukun ira. Yaꞌa veka usiduk ira naꞌa sidovung irua, wean tamata i baꞌi nfawatak domba notu a. Ia notu ma domba ra rnaꞌa wan isa, na bibi ra rnaꞌa wan liak. ");
INSERT INTO frd_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Yaꞌa veka usdovu tamata ovi rira vavaꞌat ra rmalola naꞌa Ning lihir mela a. Naꞌuk tamata ovi rira vavaꞌat ra wol rmalola, veka ala ira ma ti rnaꞌa Ning lihir balit a. ");
INSERT INTO frd_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Nata Yaꞌa Raja Yaꞌa ini veka ufalak verin ovi rnaꞌa Ning lihir mela yai ne, ‘Yamang a naflahar roak mia, ba mya ini ma mnyaꞌa Ni Fareta ralan a. Ubu nasusan roak Ni Fareta yai verin mia naꞌut i notu lanit ivavan a. ");
INSERT INTO frd_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Tevek naꞌut i ublafar a, na myala afamtahan roak ma uan. Naꞌut i ubroa, na myala roak wear ma enu. Naꞌut i Yaꞌa wean tamata dakan, na myala roak Yaꞌa ma ti unaꞌa bira rahan. ");
INSERT INTO frd_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Naꞌut i wol Ning kadaravit a, na myala roak ma ung eluk Yaꞌa. Naꞌut i nawar Yaꞌa, na mlyobang roak Yaꞌa. Naꞌut i unaꞌa buꞌi ralan, na mya roak ma milola Yaꞌa.’ ");
INSERT INTO frd_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ba tamata ovi rira vavaꞌat rmalola veka rfalak verin Ia ne, ‘Duilaꞌa, naꞌut inba ma amrea ne, mublafar ma amala afamtahan ma muan. Te naꞌut inba ma amrea ne, mubroa ma amala wear ma menu? ");
INSERT INTO frd_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Baba, ami wol amkaꞌa vali ne, naꞌut inba ma amrea Oa wean tamata dakan, ma amala Oa ti mnaꞌa mami rahan, ovu naꞌut inba ma amrea Oa wol mu kadaravit ma amala ma mung-meluk Oa? ");
INSERT INTO frd_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Duilaꞌa, ami wol amkaꞌa ne, naꞌut inba ma nawar Oa, ovu naꞌut inba ma mnaꞌa buꞌi ralan ma ti amalola Oa?’ ");
INSERT INTO frd_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Raja Yaꞌa ini veka ufalak verin ira ne, ‘Afa i ufalak verin mia ini, kena urun! Naꞌut i myotu wean inyai verin terang a valing ovi rira kasian a dawan, na inyai wean i myotu roak verin Yaꞌa.’ ");
INSERT INTO frd_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Yaꞌa veka ufalak vali verin ovi rnaꞌa Ning lihir balit a ne, ‘Yamang a veka near nfasoba mia, ba miti vatuk mia tali ini, ma ti mnyaꞌa yafwan kakiwal. Wan yai Ubu nfadoku roak verin nitdawan ovu ni sansinir ra. ");
INSERT INTO frd_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Inyai mia bira varvara a, tevek naꞌut i ublafar a, na wol myala afamtahan ma uan. Naꞌut i ubroa, na wol myala wear ma enu. ");
INSERT INTO frd_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ti ma aksa Yaꞌa wean tamata dakan, na wol myala vali Yaꞌa ma ti unaꞌa bira rahan. Naꞌut i wol Ning kadaravit ma ung a eluk Yaꞌa, na wol myala vali kadaravit verin Yaꞌa. Ti ma nawar Yaꞌa ovu unaꞌa buꞌi ralan, na wol mya ma milola vali Yaꞌa.’ ");
INSERT INTO frd_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ba veka rfalak ne, ‘Duilaꞌa, naꞌut inba ma ami amkaꞌa ne, mublafar, mubroa te tamata dakan Oa, te amrea ne wol Mu kadaravit? Naꞌut inba ma amkaꞌa ne, nawar Oa ovu mnaꞌa buꞌi ralan ma wol amati ma amalola Oa?’ ");
INSERT INTO frd_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ba Raja Yaꞌa ini veka ufalak verin ira ne, ‘Afa i ufalak verin mia ini, kena urun! Naꞌut i mifena ma mlyobang tamata ovi rira kasian dawan avyai naꞌa rira susa ra, na fyaturu roak ne, wol mlyobang Yaꞌa.’ ");
INSERT INTO frd_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ba tamata ktufan ovi rnaꞌa Ning lihir balit a, veka rti yafwan kakiwal, naꞌuk tamata ovi rira vavaꞌat ra rmalola veka rira vavaꞌat kakiwal.” ");
INSERT INTO frd_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesus nair munuk roak afa avyai, na nfalak verin Ni tamata ovi rorang Ia ne, ");
INSERT INTO frd_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Mia mkyaꞌa roak ne, amar irua ewal, na ita, tamata Yahudi, mane totu snoba Paskah. Naꞌut inyai, na tamata ra veka rtaha Yaꞌa, Tamata Yanan Yaꞌa, ma rala Yaꞌa ma ti rbaku Yaꞌa naꞌa aa walwalur.” ");
INSERT INTO frd_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Naꞌut inyai vali, na Yahudi dawan ra ovu rira dawan mela falurut ra rasdovu ira naꞌa rira Mela Falurut Ilaꞌa, naran Kayafas, ni rahan a. ");
INSERT INTO frd_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Rasdovu ira ma rdava lingaꞌan mane rtaha fanfonak Yesus ma rfedan Ia. ");
INSERT INTO frd_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Naꞌuk ira rfalak ne, “Deka totu naꞌut i snoba nbana roak a, beta ne tamata rivun veka vangoa-vanga.” ");
INSERT INTO frd_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesus nti ahu i naran Betania, ma nti tamata isa naran Simon ni rahan a ma nalola ia. Tamata ini lan a, ni suhut ngabaa. ");
INSERT INTO frd_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Naꞌa rahan yai, na vata isa nma ma ntaha botal koꞌu isa i rotu tali vatu lolin isa naran pualam. Botal yai nsaꞌa ngul i voan a lolin ovu fyawan urun a. Naꞌut inyai, na Yesus nafnaꞌan obin, na vata yai ti ntuan Ia ma nliꞌi ngul yai naꞌa ulun a. ");
INSERT INTO frd_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Yesus Ni tamata ovi rorang Ia rsiꞌik afa i vata yai notu a, na rangrova ma rfalak ne, “Notu afakinimi nawahak watan ngul i voan lolin yai? ");
INSERT INTO frd_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ngul yai fyawan urun, ba bisma tfedi ma kubang a, tala verin tamata kasian ra.” ");
INSERT INTO frd_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Naꞌuk Yesus nkaꞌa lahir afa i ranovak naꞌa ralarira ra, ba nfalak ne, “Notu afakinimi fyasala vata ini? Ia notu roak afa i lolin urun a verin Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Tamata kasian ra rnaꞌa lalawatan ovu mia, naꞌuk Yaꞌa wol mane unaꞌa lalawatan ovu mia. ");
INSERT INTO frd_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ia nliꞌi ngul voan lolin yai naꞌa tenang a, ma neluk faneak ne, nvilu lan roak Yaꞌa naꞌut amar i veka umata a. ");
INSERT INTO frd_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Afa i ufalak verin mia ini, kena urun! Naꞌa wan inba watan ma rfamalik Ubu Ni Ivar Lolin naꞌa lanit ivavan a, na veka rfamalik vali afa i notu roak ini ma al rangnanang ia.” ");
INSERT INTO frd_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Tamata isa tali Yesus Ni tamata vutu rahin irua ovi rorang ia, naran Yudas Iskariot, nti ma ntuan Yahudi rira dawan mela falurut ra. ");
INSERT INTO frd_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ia norat ira ne, “Veka myala afaka verin yaꞌa, boma ala Ia verin mia?” Ira rbahir ia ovu kubang perak vututelu. ");
INSERT INTO frd_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Tali amar yai vali, na ia ndava amar kena mane nfedi Yesus. ");
INSERT INTO frd_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Naꞌa amar i nban-ulu naꞌa tamata Yahudi rira snoba ma raꞌan roti i wol rfadoku ragi naꞌa, na Yesus Ni tamata ovi rorang Ia rma ma rtuan Ia ma rfalak ne, “Bapa, ralam nfalak wan inba ma amasusan verin Oa ma mufnaꞌan Paskah?” ");
INSERT INTO frd_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yesus nsinir Ni tamata ra ma nfalak ne, “Miti ma fyalak a verin tamata i mkyaꞌa roak ia naꞌa kota ralan eri. Fyalak verin ia ne: Tuan Guru nfalak ne, ‘Ning amar sarseri roak ma umata, ovu mane ufnaꞌan Paskah ovu Ning tamata ovi rorang Yaꞌa naꞌa mu rahan.’ ” ");
INSERT INTO frd_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ba ira rotu wean i nfalak yai, ma rasusan afamtahan ma al rotu rira snoba Paskah. ");
INSERT INTO frd_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ti ma ovan roak, na Yesus nma ma ndoku ma nafnaꞌan ovu Ni tamata vutu rahin irua yai. ");
INSERT INTO frd_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Rdoku rafnaꞌan obin, na Yesus nfalak verin ira ne, “Afa i ufalak verin mia ini, kena urun. Tali ovi tdoku tafnaꞌan ini, na tamata isa veka nfedi Yaꞌa.” ");
INSERT INTO frd_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Rarenar munuk afa i Yesus nfalak yai, na ralarira lalau urun i lahir. Ba rsikati ira al rfalak verin Yesus ne, “Duilaꞌa, yaꞌa wahal!” ");
INSERT INTO frd_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ia nfalak ne, “Tamata i mane nfedi Yaꞌa yai, fiang ini amrua amsovu mami roti naꞌa moko ini. ");
INSERT INTO frd_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Yaꞌa, Tamata Yanan Yaꞌa, veka umata wean i rfalak roak naꞌa Ubu Ni Surat Ralan a. Naꞌuk sian urun i lahir verin tamata i nfedi Yaꞌa. Ni lolin a, tamata yai deka rarali lahir ia.” ");
INSERT INTO frd_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yudas i mane nfedi Yesus yai nfalak ne, “Tuan Guru, yaꞌa wahal!” Yesus nfalak verin ia ne, “Oa kaꞌi fwalak roak yai.” ");
INSERT INTO frd_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Yesus ovu Ni tamata ra rafnaꞌan obin, na Ia nala roti a ma nfalak fara weninyai verin Ubu, beti nvisul roti yai ma nsiduk verin ira. Ia nfalak ne, “Myala ma mian kikyai. Ini Yaꞌa tenang a.” ");
INSERT INTO frd_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Nata Yesus nala vali kobi i nsaꞌa anggur ma nfalak fara weninyai verin Ubu, beti nala ma renu. Ia nfalak ne, “Mia munuk myenu anggur i naꞌa kobi ini, ");
INSERT INTO frd_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","tevek ini Yaꞌa larang i nvoat al nakvanak tamata rivun rira salasilan ra, ma neluk faneak ne, Ubu nfakena roak Ni tnorung a. ");
INSERT INTO frd_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Naꞌuk ufalak verin mia ne, tali amar ini, na Yaꞌa veka wol enu roak anggur ini, ti naran amar i veka enu ewal anggur ngorvaꞌan ovu mia naꞌa Yamang Ni Fareta a.” ");
INSERT INTO frd_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Yesus ovu Ni tamata ra rdedang ma rfadawang roak Ubu, beti ira rarata vuar Zaitun. ");
INSERT INTO frd_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Nata Yesus nfalak verin ira ne, “Ovan ini lahir, bira inorang veka wol nangrebat ma mifla talik Yaꞌa, tevek afa sian ovi tamata veka rotu verin Yaꞌa. Surat Ralan nfalak roak ne, ‘Ubu veka nfedan domba duarira a, ba domba ra veka rlilin watan.’ ");
INSERT INTO frd_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Naꞌuk Ubu veka nfavaꞌat ewal Yaꞌa tali matmatan, ba veka ula Yaꞌa uti Galilea.” ");
INSERT INTO frd_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Petrus nfalak verin Yesus ne, “Velik ne ira munuk rira inorang a wol nangrebat ma rafla talik Oa, naꞌuk yaꞌa wahal lahir.” ");
INSERT INTO frd_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesus nfalak verin ia ne, “Afa i ufalak verin oa ini, kena urun! Ovan ini lahir manut wol nkukuwai obin, na oa veka malak nala fatelu roak ne, wol mkaꞌa Yaꞌa.” ");
INSERT INTO frd_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Naꞌuk Petrus nfalak verin Ia ne, “Velik ne musti umata vali ovu Oa, naꞌuk wol alak yaꞌa ne, wol ukaꞌa Oa.” Yesus Ni tamata liak ra munuk rfalak vali wean i nfalak a. ");
INSERT INTO frd_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yesus ovu Ni tamata ovi rorang Ia rbana ma raran vaꞌi isa naran Getsemani. Ia nfalak verin ira ne, “Mdyoku ini veki, ma ti uflurut naꞌa ineri.” ");
INSERT INTO frd_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ia novun vali Petrus ovu Zebedeus yanan irua. Yesus ralan nmulai lalau urun Ia ovu wol malinan. ");
INSERT INTO frd_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ba nfalak verin ira ne, “Ralang a lalau urun i lahir, wean i ufarnuang ne, mane umata roak. Fyatuang Yaꞌa naꞌa ini ovu msyiꞌik wabira ma lolin.” ");
INSERT INTO frd_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Nata Yesus nbana ma yaꞌi nfaroa tali ira, beti nsangatur naꞌa lanun ma naflurut ne, “Bapa, ne wean urun inyai, na fara maling vatuk varvara i aleman urun ini tali Yaꞌa, naꞌuk deka wean i ralang a nfalak a, ba wean watan i ralam a nfalak a.” ");
INSERT INTO frd_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Yesus naflurut munuk ma newal ia, na Ni tamata itelu i rfatuang Ia yai rtub-lufa roak. Ba nfalak verin Petrus ne, “Wol mtyahang nala jam isa vali ma fyatuang Yaꞌa ma tsiꞌik wadida ma lolin? ");
INSERT INTO frd_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Msyiꞌik wabira ma lolin ovu miflurut, boma nitdawan deka nlabir nala mia ma myotu salasilan. Mia ralabira rfalak ma myotu afa lolin, naꞌuk wol myot-nala, tevek myafun daꞌin.” ");
INSERT INTO frd_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Nata Yesus nti ewal vali ma naflurut. Ia nfalak ne, “Bapa, wean i mtorung ma uvara wawaꞌuk ini, na wean watan i ralam a nfalak a!” ");
INSERT INTO frd_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Naflurut munuk ma newal Ia, na Ni tamata itelu yai rtuba watan obin, tevek matarira ra raswosu daꞌin roak. ");
INSERT INTO frd_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ba nsiꞌik watan ma rtuba inyai, na nti ewal ma naflurut nala fatelu roak. Ia naflurut wean inlangin a. ");
INSERT INTO frd_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Nata nma ma ntuan ewal Ni tamata itelu yai. Ia nfalak verin ira ne, “Mtyuba watan obin? Eka msyiꞌik Ning amar a naran roak ma rala Yaꞌa Tamata Yanan verin tamata salasilan ra. ");
INSERT INTO frd_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Byatar ma tati kikyai. Eka msyiꞌik! Tamata i mane nfedi Yaꞌa nma ma sarseri roak.” ");
INSERT INTO frd_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Naꞌut i Yesus nangrihi obin, na Yudas i ntali Ni tamata vutu rahin irua yai nma. Tamata rivun ovi rtaha nahin blawat ovu rira navnaval ra rban-orang vali ia. Yahudi rira dawan mela falurut ra ovu dawan Yahudi ra rsinir ira ma rti inyai. ");
INSERT INTO frd_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yudas i nfedi Yesus nfalak lan roak verin tamata rivun avyai ne, veka notu faneak. Faneak yai wean ini: “Tamata i uvoan Ia yai, Ia hi inyai i. Ba mtyaha lahir Ia ma myovun Ia ovu msyiꞌik ma lolin Ia.” ");
INSERT INTO frd_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ba ti nfaseri lahir Yesus ma nfalak verin Ia ne, “Oo Tuan Guru.” Nata nvoan Ia. ");
INSERT INTO frd_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesus nfalak verin ia ne, “Kida, motu kikyai afa ovi ralam nfalak a.” Ba tamata avyai rti rtaha lahir Ia. ");
INSERT INTO frd_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Tamata isa i norang vali Yesus ntavar ni nahin blawat a ma nafat vatuk lahir Yahudi rira Mela Falurut Ilaꞌa ni tamata sansinir isa arun a. ");
INSERT INTO frd_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yesus nfalak verin Ni tamata yai ne, “Maꞌadoru ewal nahin blawat yai naꞌa ni tlanan a, tevek wean i iki nsingarahi ovu nahin blawat, na veka nmata vali ovu nahin blawat. ");
INSERT INTO frd_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Mia wol mkyaꞌa ne, Yaꞌa bis watan ma era verin Yamang a ma nlobang Yaꞌa? Bis watan ma era verin Ia ma nsinir lahir Ni sansinir ra tali lanit ratan, naꞌa sidovung dawan nlia tali vutu rahin irua, ma rma. ");
INSERT INTO frd_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Naꞌuk wean i Ubu notu wean inyai ma nlobang Yaꞌa, na wean inba ma nfakena lahir afa ovi rfadoku roak naꞌa Surat Ralan a, naꞌa Ning matmatan a?” ");
INSERT INTO frd_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Naꞌut inyai, na Yesus nfalak verin tamata rivun avyai ne, “Mia beta mnyari ne Yaꞌa ini tamata ktufan Yaꞌa, ma mya lahir ovu bira nahin blawat ra ovu navnaval ra ma mtyaha Yaꞌa? Lokat amar, na mryea Yaꞌa udoku ma usiair naꞌa Rahan Dawan Falurut, naꞌuk wol mtyaha Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Naꞌuk ma wean urun ini, boma nfakena lahir afa ovi nabi ra rfadoku roak naꞌa Surat Ralan a.” Nata Ni tamata ra munuk rafla talik Ia. ");
INSERT INTO frd_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Tamata avyai rtaha roak Yesus, beti rovun Ia rti Yahudi rira Mela Falurut Ilaꞌa, naran Kayafas, ni rahan a ma ndiri wahan ralan a. Yahudi rira dawan ovi rair Musa ni inukun ra ovu dawan Yahudi ra rasdovu roak ira naꞌa inyai. ");
INSERT INTO frd_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Petrus nban-orang Yesus tali raroa watan, nata ti naran Mela Falurut Ilaꞌa yai ni lean a. Tamata avyai rovun roak Yesus rati lean ralan. Petrus ndoku watan ovu tamata ovi rwanar wan yai, ma al nanaban ne, veka rotu Yesus wean inba. ");
INSERT INTO frd_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Dawan Mela Falurut ra, ovu dawan fareta Yahudi ovi rdoku naꞌa rira sidovung dawan yai rdava tamata boku ma rala vaivatul siklabir al rfasala Yesus, boma rukun Ia ma nmata. ");
INSERT INTO frd_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Naꞌuk wol rtuan Ni sala isa vali, velik ne tamata rivun rma ma rfalak rira afa siklabir ra naꞌa Yesus. Ti nata tamata siklabir irua rma ma rfalak ne, ");
INSERT INTO frd_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Tamata ini nfalak ne, ‘Yaꞌa bis aꞌar vatuk Ubu Ni Rahan Dawan Falurut a, ma naꞌa amar itelu, na veka ufadiri ewal ia.’ ” ");
INSERT INTO frd_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ba Mela Falurut Ilaꞌa ndiri ma norat Yesus ne, “Notu afakinimi wol mlotar tenam a, ma fwalak naꞌa afa ovi tamata avyai rfalak a?” ");
INSERT INTO frd_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Naꞌuk Yesus wol vain. Ba Mela Falurut Ilaꞌa nfalak verin Ia ne, “Yaꞌa ufalak verin Oa ne, Ubu i nvaꞌat a nrenar afa ovi fwalak ra, ba fwalak urun verin ami! Oa ini Raja i veka mtevut tamata ra rira salasilan ra? Oa ini Ubu Yanan a?” ");
INSERT INTO frd_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesus nfalak ne, “Wean i fwalak roak yai. Naꞌuk ufalak verin mia ne, tali amar ini vali, na veka msyiꞌik Yaꞌa, Tamata Yanan Yaꞌa ini, udoku Ubu i nfareta munuk afakataka Ni lihir mela a, ovu veka utali lanit ma unaꞌa mutan ratan ra uma.” ");
INSERT INTO frd_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ba Mela Falurut Ilaꞌa nangrova urun ma nkamadir ni ravit blawat a. Ba nfalak ne, “Ia nfalak sian Ubu, tevek nfalak ne, Ubu Yanan Ia. Wol tperlu ma tdava tamata liak roak ma rfalak ni sala ra. Mia kaꞌi mryenar afa sian i nfalak a. ");
INSERT INTO frd_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ba minovak ma wean inba?” Ira rfalak ne, “Musti rukun Ia ma nmata!” ");
INSERT INTO frd_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Nata tamata boku rafnit naꞌa wahan ralan a ovu raskevu tia ma watan Ia. Boku rvaval vali Ia ovu rfalak ne, ");
INSERT INTO frd_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Hoi, Oa ini Raja i veka mtevut tamata ra rira sala silan ra? Wean i nabi Oa, na eka fwalak verin ami ne, abovi rvaval Oa ini!” ");
INSERT INTO frd_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Amar yai, na Petrus ndoku watan lean obin. Mela Falurut Ilaꞌa ni vata sansinir isa nma ma nfalak verin Petrus ne, “Oa baꞌi morang vali Yesus, tamata Galilea eri.” ");
INSERT INTO frd_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Naꞌuk Petrus nalak ia naꞌa tamata rivun avyai waharira ralan ra ne, “Yaꞌa wol ukaꞌa afa i fwalak yai.” ");
INSERT INTO frd_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Petrus ti ma ndiri tembok dawan ni falfolat ngoran a, na Mela Falurut Ilaꞌa ni vata sansinir liak isa vali nrea ia ma nfalak verin tamata ovi rnaꞌa inyai ne, “Tamata ini baꞌi norang Yesus tamata Nazaret eri.” ");
INSERT INTO frd_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Naꞌuk nalak ewal vali ia, ma nafwaba lahir ne, “Yaꞌa wol ukaꞌa tamata yai!” ");
INSERT INTO frd_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ba wol mnanat, na tamata ovi rnaꞌa inyai rma ma rfalak verin Petrus ne, “Oa ini vali morang Yesus, tevek tkaꞌa lahir naꞌa mu vai a.” ");
INSERT INTO frd_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Petrus nalak matmatan watan ia ma kaꞌi nafwaba tenan a ma nfalak ne, “Yaꞌa wol ukaꞌa tamata yai.” Naꞌut inyai lahir, na manut nkukuwai. ");
INSERT INTO frd_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ba Petrus nangnanang nal-ewal vaivatul ovi Yesus nfalak lan roak verin Ia ne, “Manut wol nkukuwai obin, na oa veka malak nala fatelu roak ne, wol mkaꞌa Yaꞌa.” Nata Petrus nti talik wan yai ma nvakar ma naꞌa samsekur. ");
INSERT INTO frd_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ti ma varverak sumatan, na Yahudi rira dawan mela falurut ra munuk ovu dawan Yahudi liak ra vali rasdovu ira ma ranovak ma raꞌan vai isa mane rfedan Yesus. ");
INSERT INTO frd_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ba rkeak Yesus, beti rovun Ia ti verin Pilatus, tamata Roma i nfareta propinsi Yudea. ");
INSERT INTO frd_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ti ma Yudas i nfedi Yesus nsiꞌik ne, rvolan roak ma rfedan Yesus, na ralan lalau urun naꞌa ni sala i notu a. Ba nal-ewal kubang perak vututelu yai verin Yahudi rira dawan mela falurut ra ovu dawan Yahudi liak ra. ");
INSERT INTO frd_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ba nfalak verin ira ne, “Yaꞌa sala roak yaꞌa, tevek ufedi tamata i wol Ni sala ma rukun roak Ia ma nmata.” Naꞌuk Yahudi rira dawan avyai rfalak ne, “Ami wol amkamlabir afa yai. Inyai oa mu varvara.” ");
INSERT INTO frd_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ba Yudas nasba vatuk kubang avyai rti Rahan Dawan Falurut ralan a. Ia nban-talik wan yai ma kaꞌi ti nesa relan a ma nakloꞌi ma nmata. ");
INSERT INTO frd_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Nata Yahudi rira dawan mela falurut ra rala kubang avyai ma rfalak ne, “Ita wol bisma tfadoku ewal kubang ovi naꞌa vatvatat i tamata ra baꞌi rfadoku rira kubang ra, ma reluk rira persembahan verin Ubu. Ita tala roak kubang avyai ma al rotu ma tamata laran nvoat.” ");
INSERT INTO frd_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ba rasdovu ira ma raꞌan vai isa ma rala kubang avyai al rfaha lanun i baꞌi rala ma al rotu suran. Ba rfaha lanun yai, boma wean i tamata dakan ra rmata, na roving ira naꞌa inyai. ");
INSERT INTO frd_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Wean inyai bi ma naran amar ini, na tamata ra rfanara wan yai ne, lanun i tamata laran nvoat naꞌa. ");
INSERT INTO frd_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ba afa yai nfakena lahir afa ovi lan a nabi Yeremia ntulis ne, “Ira rala roak kubang perak vututelu. Ira rfadoku roak fyawan wean inyai verin tamata ovi rnaꞌa Israel. ");
INSERT INTO frd_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ira rala vali kubang avyai ma al rfaha lanun i baꞌi rala ma al rotu suran, wean lahir i Duilaꞌa nfalak roak verin yaꞌa.” ");
INSERT INTO frd_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Naꞌut i Yesus ndiri Gubernur Pilatus wahan ralan a, na Pilatus norat Ia ne, “Yahudi rira raja verin Oa?” Yesus nfalak ne, “Oa kaꞌi fwalak roak yai.” ");
INSERT INTO frd_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Yahudi rira dawan mela falurut ra ovu dawan Yahudi liak ra rmangadu Yesus, naꞌuk Ia wol nangrihi vaivatul isa vali. ");
INSERT INTO frd_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ba Pilatus norat ewal Yesus ne, “Wol mrenar ngrihi sian ovi rala al rmangadu Oa yai!” ");
INSERT INTO frd_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Naꞌuk Yesus wol nala vaivatul isa vali, ba Pilatus ntalkaka lahir. ");
INSERT INTO frd_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Lokat varat naꞌut amar dawan Paskah, na gubernur baꞌi nfatalik tamata isa. Yahudi ra rfili tamata yai tali buꞌi ralan. ");
INSERT INTO frd_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Naꞌut inyai, na tamata isa nanaꞌa buꞌi ralan naran Yesus Barabas. Tamata ra munuk rkaꞌa roak ia, tevek afa sian ovi notu ra. ");
INSERT INTO frd_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ba ti ma tamata rivun rasdovu ira, na Pilatus norat ira ne, “Inabira ma ufatalik iki verin mia? Yesus Barabas te Yesus i rfanara Ia ne, Kristus?” ");
INSERT INTO frd_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilatus nkaꞌa roak ne, Yahudi rira dawan ra ralarira sian Yesus, ba rovun Ia verin Pilatus. ");
INSERT INTO frd_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Naꞌut i Pilatus ndoku kadera i baꞌi ndoku ma nfaleka inukun verin tamata ra, na awan a nsinir tamata isa ma nfalak verin ia ne, “Deka movu ma mukun tamata i wol ni sala yai, tevek Ia bi indean a umdedar lalean naꞌa ning mifi a.” ");
INSERT INTO frd_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Naꞌuk Yahudi rira dawan mela falurut ra ovu Yahudi rira dawan liak ra rtuar tamata rivun avyai, boma rera verin Pilatus ma nfatalik Barabas verin ira, ovu nsinir ma rfedan Yesus. ");
INSERT INTO frd_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Nata Gubernur Pilatus norat ira ne, “Ba tali tamata irua ini, na inabira ma ufatalik iki verin mia?” Ira rfalak ne, “Barabas.” ");
INSERT INTO frd_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilatus norat ewal ira ne, “Ba wean inyai, na yaꞌa musti otu afaka verin Yesus i rfanara Ia ne, Kristus?” Ira munuk rafwak ne, “Bwaku Ia naꞌa aa walwalur!” ");
INSERT INTO frd_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilatus nfalak verin ira ne, “Afakinimi? Notu sala afaka?” Naꞌuk rafwak ma vairira dawan ilaꞌa ne, “Bwaku Ia naꞌa aa walwalur!” ");
INSERT INTO frd_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilatus nsiꞌik roak ne, veka wol not-nala roak tamata rivun avyai, tevek mane rotu vangoa-vanga. Ba nala wear ma nraming liman a naꞌa waharira ralan ra ma nfalak ne, “Yaꞌa wol ning varvara naꞌa tamata ini ni matmatan a. Mia bira varvara ini.” ");
INSERT INTO frd_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Tamata rivun avyai rafwak ne, “Ami ovu yanamami ra ki amvara tamata ini laran a.” ");
INSERT INTO frd_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Nata Pilatus nfatalik Barabas verin ira. Naꞌuk ia nfalak verin ni suldadu ra ma rasveva Yesus veki, beti nala Ia verin ira ma rbaku Ia naꞌa aa walwalur. ");
INSERT INTO frd_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Gubernur Pilatus ni suldadu ra rovun Yesus rti Pilatus ni rahan fareta dawan, beti rasdovu rira suldadu liak ra munuk ma rdir-lilit Yesus. ");
INSERT INTO frd_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Nata ira raling Ni kadaravit ra, ma rala ravit blawat ungu isa ma raꞌadoru naꞌa Ia. ");
INSERT INTO frd_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ira ranan aa anan ovi imarira ra naꞌa sabeꞌu ma rfadoku naꞌa Yesus ulun a. Ira rala vali takil isa ma ntaha naꞌa liman mela a, beti rsangatur naꞌa wahan ralan a ma rworuk-rwak Ia ma rfalak ne, “Yahudi rira Raja verin Oa, ba fara nam a blawat!” ");
INSERT INTO frd_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ira rafnit naꞌa Ia, ovu rala takil i ntaha yai ma rsikati ira al rvaval ulun a. ");
INSERT INTO frd_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ba ti ma rworuk-rwak munuk Ia, na raling ewal ravit blawat ungu i neluk a, beti rung a reluk ewal Ia ovu Ni kadaravit ra. Nata rovun Ia nti murin ma rbaku Ia naꞌa aa walwalur. ");
INSERT INTO frd_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Naꞌut i mane rbana rti kota Yerusalem murin a, na rtuan tamata isa ntali kota Kirene naran Simon. Suldadu ra rkiwal ia ma nvara Yesus Ni aa walwalur a. ");
INSERT INTO frd_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Nata ti raran wan isa naran Golgota. Vaivatul yai ihin a, “Kalkulun Wan.” ");
INSERT INTO frd_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Tamata avyai rala anggur i rsileti ovu afa i kfera, beti rala verin Yesus ma nenu. Naꞌuk ti ma Yesus nfatemang, na nafena ma nenu. ");
INSERT INTO frd_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Rbaku Yesus naꞌa aa walwalur, beti rbataru ma rsiduk ni kadaravit ra. ");
INSERT INTO frd_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Nata rdoku aa walwalur nelan a ma rwanar Ia. ");
INSERT INTO frd_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Naꞌa aa walwalur ni tutul a, na rtulis vaivatul ra naꞌa kba etal isa ma nfalyawang ne wean inbinimi rukun Yesus. Vaivatul avyai ngoarira ra wean ini, “Yahudi rira Raja verin Yesus.” ");
INSERT INTO frd_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Amar yai, na rbaku vali tamata ktufan irua naꞌa aa walwalur. Isa naꞌa Yesus Ni lihir mela a, na isa naꞌa Ni lihir balit a ");
INSERT INTO frd_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Tamata ovi rahu inyai rarwaꞌung ulurira ra ma rfalak sian Yesus. ");
INSERT INTO frd_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Ira rfalak ne, “Yaꞌi yo! Oa fwalak ne, bisma maꞌar vatuk dida Rahan Dawan Falurut a ovu fwadiri ewal naꞌa amar itelu. Wean i Ubu Yanan urun Oa, na msuta tali aa walwalur yai, boma deka mwata.” ");
INSERT INTO frd_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Yahudi rira dawan mela falurut ra ovu rira dawan ovi rair Musa ni inukun ra, ovu vali rira dawan liak ra rdiri vali wan yai ma rworuk-rwak Ia. Ira rfalak ne, ");
INSERT INTO frd_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Ia not-nala ma tamata liak wol rmata, naꞌuk wol not-nala ma deka nmata. Wean i Israel rira Raja verin Ia, na nsuta tali aa walwalur yai, boma torang Ia. ");
INSERT INTO frd_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ia norang Ubu ovu nfalak ne, Ubu Yanan Ia. Eka tsiꞌik, wean i Ubu veka nala Ia, na nvaꞌat te wahal?” ");
INSERT INTO frd_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Tamata ktufan irua i rbaku roak ira naꞌa aa walwalur ma rnaꞌa Yesus Ni lihir mela ovu balit yai, rangrihi visal-vasil vali Ia wean inyai. ");
INSERT INTO frd_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Naꞌut inyai lera ndirlola, na deda fafyat nsoru munuk wan yai, ti naran jam tiga lersian. ");
INSERT INTO frd_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ba naꞌut jam tiga lersian, na Yesus nafwak ne, “Eli, Eli lama sabaktani?” Yesus Ni vaivatul avyai ihin a wean ini, “O Ubu i uraning a, O Ubu i uraning a! Afakinimi muti talik Yaꞌa i?” ");
INSERT INTO frd_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Tamata ovi rdiri inyai rarenar afa i Yesus nfalak a, ba rfalak ne, “Ia nera nabi Elia!” ");
INSERT INTO frd_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ba tamata isa ti nala spons etal isa ma nsovu naꞌa anggur i nakbia, ma nngatan teri spons yai naꞌa aa etal isa ni tutul a ma nlauk rata verin Yesus ma nbuk. ");
INSERT INTO frd_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Naꞌuk tamata boku rfalak ne, “Tnaban veki! Eka tsiꞌik, beta ne Elia nma ma nlobang Ia ma deka nmata.” ");
INSERT INTO frd_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Nata Yesus nafwak ewal ma vain a dawan, na nan nakbosal lahir. ");
INSERT INTO frd_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Naꞌut inyai vali, na maloli dawan amafal i nakloꞌi Yahudi rira Rahan Dawan Falurut ralan a namadir lahir naꞌut irua, tali ratan nsuta naran fun. Ruru dawan vali, ba vatu dawan ra rablihir munuk. ");
INSERT INTO frd_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Van ovi rfadoku matmatan ra ratvadil, ba tamata rivun ovi rorang urun Ubu, naꞌuk rmata roak yai, Ubu nfavaꞌat ewal ira. ");
INSERT INTO frd_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Tamata matmatan avyai rvaꞌat ewal ma rti talik warira ra naꞌa van ra. Ti ma Yesus nvaꞌat ewal tali matmatan, na ira rti Yerusalem, kota i nmerat urun, ma tamata rivun rsiꞌik ira. ");
INSERT INTO frd_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Roma rira suldadu dawan isa ovu ni suldadu ovi rwanar Yesus, rsiꞌik Yesus ti naran i nan a nakbosal a, ovu rfarnuang ruru i dawan a, ba rbobar urun i lahir. Ba rfalak ne, “Kena urun, tamata ini Ubu Yanan a!” ");
INSERT INTO frd_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Naꞌa wan yai, na vata rivun rsiꞌik afa avyai tali raroa watan. Vata avyai rorang Yesus tali Galilea, boma rlobang Ia. ");
INSERT INTO frd_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Tali vata avyai, na boku nararira Maria Magdalena, Maria i yanan verin Yakobus ovu Yusuf, ovu vali Zebedeus awan a. Zebedeus irua awan a yanarira verin Yohanes ovu Yakobus. ");
INSERT INTO frd_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Yaꞌi laflofan roak, na tamata kaꞌi isa naran Yusuf, ntali ahu Arimatea nma. Ia norang roak Yesus. ");
INSERT INTO frd_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ia ti ntuan Pilatus ma nera Yesus tenan a. Ba Pilatus nsinir ni tamata ra ma rala Yesus tenan a verin Yusuf. ");
INSERT INTO frd_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yusuf nala Yesus tenan a ma nkuma Ia ovu maloli ngangiar marmerat i naran lenan. ");
INSERT INTO frd_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Nata Yusuf nti ma nfanuba Yesus tenan a naꞌa vatu i rtivan roak ia ma wean van. Van yai, Yusuf nia ovu ngorvaꞌan obin. Ia nlawar vatu dawan isa ma al nulang teri van ngoran a, beti nti talik wan yai. ");
INSERT INTO frd_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maria Magdalena ovu Maria isa vali rnaꞌa inyai. Ira rdoku van yai ngoran a. ");
INSERT INTO frd_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ni ilyan a, naꞌa amar i Yahudi ra ryari ira, na Yahudi rira dawan mela falurut ra ovu tamata Farisi ra, irmunuk rti ma rtuan Pilatus. ");
INSERT INTO frd_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ira rfalak verin Pilatus ne, “Baba, ami amangnanang naꞌut i tamata siklabir eri nvaꞌat obin, na nfalak roak ne, ‘Ti ma amar itelu nelak, na veka uvaꞌat ewal.’ ");
INSERT INTO frd_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ba wean inyai bi fwareta mu suldadu ra ma ti rwanar van i rfanuba Ia naꞌa, ti naran amar itelu. Tevek wean i wahal, na Ni tamata ra veka rti ma rbori tenan a ma rfalak verin tamata rivun ne, ‘Ia nvaꞌat ewal roak tali matmatan!’ Ba wean i afa yai nvotuk, na rira siklabir ra veka ntafal ma dawan ilaꞌa.” ");
INSERT INTO frd_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilatus nfalak verin dawan Yahudi avyai ne, “Myovun suldadu ra miti ma myanar kakiwal van yai.” ");
INSERT INTO frd_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ba rati van yai ma rfadoku faneak naꞌa vatu i nteri van ngoran a, boma wean i tamata ra rlabir van yai, na rkaꞌa. Rotu munuk wean inyai, beti rfalak ma suldadu avyai rwanar ma lolin van yai. ");
INSERT INTO frd_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Amar i Yahudi ra ryari ira yai nelak roak, na Maria Magdalena ovu Maria liak isa vali rti ma rsiꞌik van matmatan i rfanuba Yesus tenan a. Naꞌut inyai, na lera sarseri mane ndata roak naꞌa amar kareda. ");
INSERT INTO frd_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ruru dawan urun naꞌa inyai, tevek Duilaꞌa Ni sansinir isa ntali lanit ratan nsuta ma nlawar vatu i nteri van ngoran yai, ma ndoku vatu yai ratan a. ");
INSERT INTO frd_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Felan a nyadat ma wean fitik, ovu ni ravit blawat a nangiar ma wean avat minan. ");
INSERT INTO frd_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Suldadu ovi rwanar van yai rbobar ma raruru lalean ira, ba rleka rsuta fun ma wean tamata ovi rmata roak. ");
INSERT INTO frd_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Naꞌuk sansinir yai nfalak verin vata avyai ne, “Deka byobar, tevek ukaꞌa roak ne, mya ma mdyava Yesus i rbaku roak Ia naꞌa aa walwalur a. ");
INSERT INTO frd_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ia wol nleal roak ini. Ia nvaꞌat ewal roak, wean i nfalak lan roak verin mia. Eka mya ma msyiꞌik wan i rfanuba Ia naꞌa. ");
INSERT INTO frd_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ba myewal lahir mia ma ti fyamalik verin Ni tamata ovi rorang Ia ne, Yesus nvaꞌat ewal roak tali matmatan, ma veka ula Ia nti propinsi Galilea. Mia veka mtyuan Ia naꞌa ineri. Afa ovi ufamalik roak verin mia ini, kena urun!” ");
INSERT INTO frd_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Vata irua yai rafla talik van matmatan yai. Ira rbobar urun, naꞌuk ralarira lolin urun i vali, ba rfarlan mane ti rfamalik afa ini verin Yesus Ni tamata ovi rorang Ia. ");
INSERT INTO frd_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Brian munuk, na Yesus ntuan ira ma nfalak ne, “Oo Titi averi!” Ba vata irua yai rfaseri Ia, ma rsangatur ovu rangabuk ean a ma rfadawang Ia. ");
INSERT INTO frd_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ba Yesus nfalak verin ira ne, “Deka byobar! Miti ma fyalak verin Ning tamata ra ma rti Galilea, tevek naꞌa ineri, na veka rsiꞌik Yaꞌa.” ");
INSERT INTO frd_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Vata irua yai rbana obin, na suldadu ifira tali ovi rwanar van yai rti kota ralan ma rfamalik afa ovi rarea yai verin Yahudi rira dawan mela falurut ra. ");
INSERT INTO frd_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ti ma suldadu ovi rwanar van yai rfalak munuk afa avyai verin mela falurut ra ovu dawan Yahudi ra, na ira raꞌan vai isa ma rala kubang dawan verin suldadu avyai. ");
INSERT INTO frd_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Yahudi rira mela falurut ra rfareta ira ne, “Mia musti fyalak ne, ‘Ovan yai, na amtub-lufa munuk roak, beti Ni tamata ovi rorang Ia rma ma rbori tenan a.’ ");
INSERT INTO frd_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Wean i Gubernur Pilatus nrenar afa ini, na ami ki amangrihi ma amlotar mia, boma deka angangal akataka verin mia.” ");
INSERT INTO frd_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ba ira rala kubang avyai ma rewal roak ira, ma ti rfamalik wean i rsurak roak verin ira yai. Ivar ini ti nsoru roak Yahudi ra ma naran amar ini. ");
INSERT INTO frd_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Yesus Ni tamata vutu rahin isa yai rti Galilea, ma rnaꞌa vuar i Yesus nfalak roak verin ira. ");
INSERT INTO frd_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ti ma rsiꞌik Ia, na rsangatur lahir ma rfadawang Ia, naꞌuk boku ralarira ra raruan obin. ");
INSERT INTO frd_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesus nfaseri ira ma nfalak ne, “Ubu nala munuk roak ngrebat verin Yaꞌa naꞌa lanit ratan ovu lanit ivavan a. ");
INSERT INTO frd_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ba miti ma fyamalik Ubu Ni Ivar Lolin verin bangsa ra munuk naꞌa lanit ivavan a, boma rorang Yaꞌa. Byaptis ira naꞌa Yamang a naran a, Yanan a, ovu Ni Roh a. ");
INSERT INTO frd_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Myair ira ma rot-orang afa ovi ufareta munuk roak verin mia yai. Yaꞌa veka ufatuang mia, nata ti naran i lanit ivavan namwear a.”");
INSERT INTO frd_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ivar Lolin i nfamalik Ubu Yanan a Yesus Kristus beti nvotuk. ");
INSERT INTO frd_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Lalan ana, nabi Yesaya ntulis Ivar Lolin yai ne, “Ubu nfalak ne, ‘Ini Yaꞌa Ning tamata sansinir; Yaꞌa usinir lan ia ma nasusan lingaꞌan verin oa.’ ");
INSERT INTO frd_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Tamata isa nafwak naꞌa wan lean vu dawan ne, ‘Misusan lingaꞌan verin Duilaꞌa, fyamalola lingaꞌan ra!’ ” ");
INSERT INTO frd_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","6","Tamata i Ubu nsinir ia yai naran Yohanes. Ia nleal wan lean vu dawan isa ma nbaptis tamata ra. Ni ravit a blawat i noru a, rotu tali afwatan i naran unta, vulun ra. Ni ngesa rotu vali tali afwatan ulin. Ni fanaꞌan a kabina ovu wenan vahan i naꞌa nangan. Ia nfamalik Ubu Ni vaivatul ra verin tamata ra, ma rahil ma rtalik tali rira salasilan ra, boma Ubu naꞌi vatuk rira salasilan ra, beti rala tenarira ra ma nbaptis ira. Tamata rivun ilaꞌa rtali propinsi Yudea ovu kota Yerusalem rti ma rarenar afa ovi Yohanes nfalak ra. Ira rahil ma rfavotuk rira salasilan ra verin Ubu, ba Yohanes nbaptis ira naꞌa oar Yordan. ");
INSERT INTO frd_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ia nfamalik lalawatan verin tamata ra ne, “Wol mnanat, na tamata isa veka nma, ovu Ni ngrebat a nlia yaꞌa. Yaꞌa wol verang a ratan Ia, ba wol inovan ma usangatur ma aling ni tatea ni tatur a. ");
INSERT INTO frd_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Yaꞌa ubaptis mia ovu wear, naꞌuk Ia veka nbaptis mia ovu Ni Roh a.” ");
INSERT INTO frd_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Naꞌut i Yohanes nbaptis tamata ra, na Yesus ntali ahu Nazaret i nanaꞌa propinsi Galilea nma ma Yohanes nbaptis Ia naꞌa oar Yordan. ");
INSERT INTO frd_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Naꞌut i Yesus ndata tali wear, na brian munuk nsiꞌik, na wean i lanit natvadil, ma Ubu Ni Roh nsuta wean modarlaka ma ndoku tenan a. ");
INSERT INTO frd_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Vai isa ntali lanit ratan nfalak ne, “Oa ini Yanak i ulobang urun a. Oa motu ma ralang a lolin urun.” ");
INSERT INTO frd_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ubu Ni Roh novun lahir Yesus ma nti wan lean vu dawan isa. ");
INSERT INTO frd_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ba Ia nanaꞌa wan lean vu dawan yai, na nitdawan nlabir teman Ia ma naran amar vutfaꞌat. Yesus nanaꞌa inyai ovu afwatan ra, na Ubu Ni sansinir ra tali lanit ratan rfatuang Ia ma rlobang Ia. ");
INSERT INTO frd_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Fareta ra raꞌabuꞌi roak Yohanes. Nata Yesus nti propinsi Galilea ma nfamalik Ubu Ni Ivar Lolin a. ");
INSERT INTO frd_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ba Ia nfalak ne, “Amar nma ma naran roak ma Ubu nfareta wean lahir Raja. Myahil ma mtyalik tali bira salasilan ra ma myorang aꞌuk Ubu Ni Ivar Lolin!” ");
INSERT INTO frd_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Amar isa, na Yesus nbana naꞌa danau Galilea nelan a, na nrea tamata irua, iyaꞌan iwarin ira. Isa naran Simon ovu isa vali naran Andreas. Ira sinat roal ira, ba rfasuka rira jaring naꞌa inyai ma al rdava ian. ");
INSERT INTO frd_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ba Yesus nfalak verin ira ne, “Mya ma myorang Yaꞌa! Mia wol fyasuka jaring roak ma nala ian, tevek ala karya verin mia ma myair tamata ra ma rorang Yaꞌa.” ");
INSERT INTO frd_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ba rfadoku lahir rira jaring ra naꞌa inyai ma rorang Ia. ");
INSERT INTO frd_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Nata nban-ewal ma nsiꞌik Yakobus irua warin a naran Yohanes, yamarira naran Zebedeus. Ira rnaꞌa rira kumal ralan ma rlavan rira jaring ra. ");
INSERT INTO frd_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Yesus nera lahir ira ma rorang Ia, ba rsuta talik yamarira ovu tamata ovi raꞌan kadi tali ira naꞌa rira kumal yai, ma rorang Ia. ");
INSERT INTO frd_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesus ovu Ni tamata ovi rorang Ia rti raran ahu isa naran Kapernaum. Naꞌut amar i Yahudi ryari ira, na Yesus nti lahir Yahudi rira rahan falurut ralan a, ma nsiair naꞌa inyai. ");
INSERT INTO frd_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Tamata ovi rarenar afa ovi nair ra rtalkaka lahir, tevek nsiair ovu Ubu Ni ngrebat a, wol wean Yahudi ovi rair Musa ni inukun ra. ");
INSERT INTO frd_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Brian munuk, na brana isa i nait sian nleal ia nti Yahudi rira rahan falurut ralan a, ma nait sian notu ma brana yai nafwak ne, ");
INSERT INTO frd_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Hoi, Yesus tamata Nazaret, deka mlabir ami! Oa mwa ini mane fwedan ami? Yaꞌa ukaꞌa ne iki Oa. Oa sansinir i ralam nmerat urun tali Ubu.” ");
INSERT INTO frd_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesus nfalak verin nait sian yai ne, “Deka vaim! Muti talik brana ini!” ");
INSERT INTO frd_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Nait sian yai notu ma brana yai nafwak ma vain a dawan, ovu notu ma tenan raruru lalean, nata nti talik ia. ");
INSERT INTO frd_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Tamata ra munuk rtalkaka, ba rsiorat ira ne, “Yaꞌi yo, ini afaka? Ia Ni ngrebat ma nair afa ngorvaꞌan! Ia bisma nfareta nait sian ra vali ma rot-orang afa ovi nfalak ra.” ");
INSERT INTO frd_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Tamata ra rfamalik Yesus verin tamata rivun naꞌa wan Galilea munuk. ");
INSERT INTO frd_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yesus irtelu Yakobus ovu Yohanes rtali Yahudi rira rahan falurut ralan rti murin, beti rti Simon ovu Andreas rira rahan a. ");
INSERT INTO frd_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Tamata ovi rnaꞌa rahan yai rfalak verin Yesus ne, “Simon avan a tenan ngnea, ba ntuba watan.” ");
INSERT INTO frd_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yesus nti wan i vata yai nanaꞌa ma ntaha liman a, ma nfabatar ia, na lolin lahir ia. Ba vata yai nasusan afamtahan verin ira ma raꞌan. ");
INSERT INTO frd_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Lera nakduvul ma laflofan roak, beti tamata ra rovun tamata ovi raruru ira, ovu ovi nait sian ra rleal ira ti verin Yesus. ");
INSERT INTO frd_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Tamata ra munuk naꞌa ahu yai rasdovu ira naꞌa rahan ngoran. ");
INSERT INTO frd_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yesus notu ma lolin tamata rivun tali rira suhut afaka watan, ovu naling vatuk nait sian ra tali tamata ra. Ia wol ntorung ma nait sian ra rangrihi, tevek rkaꞌa munuk roak ne, Ubu Yanan Ia. ");
INSERT INTO frd_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Nfadaꞌing amar, na Yesus nbatar ma nti talik rahan yai. Ia nti wan lean vu isa, ma naflurut naꞌa inyai. ");
INSERT INTO frd_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Nata Simon ovu ni kida ra ti rdava Ia. ");
INSERT INTO frd_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ba rdav-nala Ia, na rfalak ne, “Tamata rivun rdava Oa!” ");
INSERT INTO frd_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yesus nfalak ne, “Eka tati ahu liak ra vali ma ufamalik Ubu Ni Ivar Lolin a verin tamata ovi rnaꞌa ineri, tevek Ubu Ni Ivar Lolin yai bi uma ini.” ");
INSERT INTO frd_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ba nban-soru wan Galilea munuk ma nfamalik Ubu Ni Ivar Lolin naꞌa Yahudi rira rahan falurut ra, ovu naling vatuk nait sian ra tali tamata ra. ");
INSERT INTO frd_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Tamata isa ni suhut ngabaa nma ma ntuan Yesus, ma nsangatur naꞌa wahan ralan al nera verin Ia ne, “Baba, wean i mtorung, na fara motu ma lolin ewal yaꞌa.” ");
INSERT INTO frd_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesus nfaturu Ni silobang verin tamata yai, ba nlauk liman a ma nkena ia, ma nfalak ne, “Yaꞌa ulobang oa, ba lolin kikyai oa!” ");
INSERT INTO frd_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Brian munuk, na tamata yai lolin ia, tevek ni suhut nlia roak. ");
INSERT INTO frd_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Ba Yesus nsinir lahir ia ma nfalak ne, “Ufangnanang oa ne, deka fwamalik afa ini verin tamata iki watan. Naꞌuk muti lahir ma fwaturu tenam a verin Yahudi rira mela falurut a ma nsiꞌik oa. Mala mu korban verin Ubu, wean i rfalak roak naꞌa Musa ni inukun ra, boma tamata ra rkaꞌa ne, lolin roak oa.” ");
INSERT INTO frd_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Naꞌuk tamata yai ti nfaivar soru ne, lolin roak ia. Ba Yesus wol nti ahu ralan, boma tamata ra deka rarea Ia. Ia nti ahu murin watan ma nleal wan i wol tamata rnaꞌa, naꞌuk tamata ra rtali wan rivun rma lalawatan ma rtuan Ia naꞌa inyai. ");
INSERT INTO frd_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Nata amar ifira nelak roak, na Yesus nati ewal ahu Kapernaum, ma tamata ra rarenar ivar ne, newal roak Ia. ");
INSERT INTO frd_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ba tamata rivun rasdovu ira naꞌa rahan i Yesus nanaꞌa, ma rahan ralan ovu falfolat ngoran nngora lahir naꞌa tamata ra, ma Yesus nfamalik Ubu Ni vaivatul ra verin ira. ");
INSERT INTO frd_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Tamata ifaꞌat rsikat brana laklukut isa ma rati inyai. ");
INSERT INTO frd_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Naꞌuk wol rti nala rahan ralan ma rtuan Yesus, tevek tamata rivun daꞌin. Ba rarata rahan ratan a, ma rotu ma nablahi ma rtolar tamata laklukut yai ovu ni dari i ntuba naꞌa. ");
INSERT INTO frd_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesus nsiꞌik tamata avyai, na nkaꞌa lahir ne, rira inorang a dawan, ba nfalak verin tamata laklukut yai ne, “Baba, aꞌi vatuk roak mu salasilan ra.” ");
INSERT INTO frd_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Nata tamata boku tali Yahudi rira dawan ovi rair Musa ni inukun ra rdoku inyai ma ranovak naꞌa ralarira ne, ");
INSERT INTO frd_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Afakinimi tamata ini nangrihi wean ini? Ia nfalak sian Ubu! Wol tamata isa bisma naꞌi vatuk tamata rira salasilan ra. Ubu saꞌi naꞌi vatuk.” ");
INSERT INTO frd_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yesus nkaꞌa lahir afa i ranovak naꞌa ralarira ra, ba nfalak verin ira, “Afakinimi minovak wean inyai naꞌa ralabira ra? ");
INSERT INTO frd_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Inabira ma ufalak verin tamata laklukut yai ne, ‘Aꞌi vatuk roak mu salasilan ra,’ te ufalak ne, ‘Mdiri ma mlulung mu dari ma bwana.’ Afaka maraan ma ufalak naꞌa afa irua ini? ");
INSERT INTO frd_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Boma mkyaꞌa ne, naꞌa lanit ivavan ini, na Yaꞌa, Tamata Yanan Yaꞌa, Ning ngrebat ma aꞌi vatuk tamata rira salasilan ra.” Ba Yesus nfalak verin tamata laklukut yai ne, ");
INSERT INTO frd_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ufalak verin oa ma mdiri, ovu mlulung mu dari a ma mewal oa muti mu rahan kikyai!” ");
INSERT INTO frd_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Tamata laklukut yai ndiri ma nlulung ni dari a, ma nbana naꞌa tamata rivun avyai wahar ralan ra ma nati murin, ba tamata rivun rtalkaka ma rfadawang Ubu ma rfalak ne, “Afa i wean ini ita wol trea obin.” ");
INSERT INTO frd_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Nata Yesus newal Ia nti danau Galilea nelan a, na tamata rivun rma ma rdir-lilit Ia, ba nair ira. ");
INSERT INTO frd_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ti ma Yesus nbana, na nrea tamata isa ndoku rahan i baꞌi rera babahir kulu naꞌa. Ia naran Lewi, yaman a naran Alfeus. Yesus nfalak verin ia ne, “Morang Yaꞌa.” Ba Lewi ndir-talik ni karya a ma norang Yesus. ");
INSERT INTO frd_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Naꞌut inyai, na Yesus ovu Ni tamata ovi rorang Ia rafnaꞌan naꞌa Lewi ni rahan. Tamata rivun ovi rera babahir kulu tali tamata ra, ovu tamata ovi tamata liak ra rfalak ira ne, tamata salasilan ra, rafnaꞌan vali ovu Yesus, tevek tamata rivun rban-orang Ia. ");
INSERT INTO frd_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Yahudi rira dawan boku ovi rair Ubu Ni inukun ra rtali Yahudi rira sidovung isa naran Farisi. Ira rorat Yesus Ni tamata ovi rorang Ia ne, “Afakinimi Yesus nafnaꞌan ovu tamata sian avyai?” Ira rfalak wean inyai, tevek rarea Yesus nafnaꞌan ovu tamata ovi rera babahir kulu ra, ovu tamata ovi rotu salasilan. ");
INSERT INTO frd_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesus nrenar rira afa ovi rfalak ra, ba nfalak ne, “Tamata ovi wol rira suhut ra wol rti dokter, naꞌuk ovi rira suhut ra aꞌuk saꞌi rti dokter. Yaꞌa wol uma ma era tamata ovi rira vavaꞌat ra rmalola, naꞌuk uma ma era tamata salasilan ra, ma rorang Yaꞌa.” ");
INSERT INTO frd_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Naꞌut inyai, na tamata ovi rorang Yohanes i nbaptis tamata ra, ntafal vali tamata ovi rtali sidovung Farisi, rtolat ma raflurut verin Ubu. Ba tamata boku rma ma rorat Yesus ne, “Afakinimi Yohanes ni tamata ra ovu ovi rorang tamata Farisi ra rtolat, naꞌuk Mu tamata ra wol rtolat i?” ");
INSERT INTO frd_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesus nala vaivatul kamkuma ma nfalak verin ira ne, “Naꞌa snobsifa isa, na wean i brana i mane nsifa irmunuk ni kida ra obin, na musti rtolat? Wahal, ira veka rafnaꞌan ovu rotu rira snobsifa. ");
INSERT INTO frd_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Brana i mane nsifa yai ni amar a veka nma ma rala ia, ma wol nanaꞌa roak ini. Naꞌut inyai, beti rtolat.” ");
INSERT INTO frd_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Yesus nfamalik vaivatul kamkuma isa ewal wean ini: “Wol tamata isa nlavan ni kadaravit mnanat ovu maloli ngorvaꞌan, tevek maloli ngorvaꞌan yai wol naslura obin, ba veka notu watan ma kadaravit yai ntafal ma namsat. ");
INSERT INTO frd_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Wean vali inyai, ma wol tamata isa vali nliꞌi anggur ngorvaꞌan naꞌa sadawan mnanat i rotu tali karba ulin a. Wean i tamata isa notu wean inyai, na sadawan veka naksat ma anggur yai nvoat, ovu vali sadawan sian lahir. Ba tliꞌi anggur ngorvaꞌan naꞌa sadawan ovi ngorvaꞌan ra aꞌuk.” ");
INSERT INTO frd_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Amar isa naꞌut i Yahudi ra ryari ira, na Yesus ovu Ni tamata ovi rorang Ia rban-etal vaꞌi gandum ra, na Yesus Ni tamata ra rfufu gandum ni funu boku. ");
INSERT INTO frd_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Tamata Farisi ra rfalak verin Yesus ne, “Msyiꞌik kikyai! Afakinimi ira rangal dida agama ni inukun ra, ma rotu afa i wol bisma totu naꞌa amar i tyari ita?” ");
INSERT INTO frd_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Yesus nfalak ne, “Mia wol byas obin afa ovi Raja Daud notu ra naꞌut Abyatar neluk Yahudi rira Mela Falurut Ilaꞌa? Daud ovu ni tamata ra rablafar, ba Ia nti befak dawan i baꞌi raraning Ubu naꞌa. Ia nti ralan ma nala roti i rfadok-aling roak verin Ubu ma naꞌan. Nata ntanang vali roti avyai verin ni tamata ovi rorang ia, velik ne naꞌa dida agama ni inukun ra, na mela falurut ra aꞌuk saꞌi bisma raꞌan roti avyai.” ");
INSERT INTO frd_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Nata Yesus ntafal ma nfalak verin ira ne, “Ubu nala amar isa ma tamata ra ryari ira. Ia wol nfadoku tamata verin amar i ryari ira. ");
INSERT INTO frd_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Yaꞌa Tamata Yanan Yaꞌa, ba Ning fareta ti naran vali amar i tyari ita.” ");
INSERT INTO frd_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yesus newal Ia nti Yahudi rira rahan falurut ralan a, na brana isa naꞌa inyai liman lihir nmata. ");
INSERT INTO frd_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Tamata Farisi ovi rnaꞌa inyai rsiꞌik nanuang Ia, betane notu ma lolin brana yai naꞌa amar i Yahudi ra ryari ira, boma rmangadu Ia. ");
INSERT INTO frd_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ia nfalak verin brana i liman nmata yai ne, “Mwa ma mdiri tamata ovi rnaꞌa ini waharira ralan ra!” ");
INSERT INTO frd_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Nata, Yesus norat tamata avyai ne, “Dida agama ni inukun ra rfalak ma bis totu afaka naꞌut amar i tyari ita? Totu afa ovi lolin ra, te afa ovi sian ra? Tlobang tamata ra ma rvaꞌat, te tfedan ira?” Naꞌuk ira wol vair lahir. ");
INSERT INTO frd_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yesus ralan a lalau, tevek ralarira ra rangrebat dalang, ba nsiꞌik lilit ira ovu wahan nangrova. Ia nfalak verin brana yai ne, “Mlauk limam a mwa.” Ia nlauk liman a ma Yesus notu ma lolin lahir ia. ");
INSERT INTO frd_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Tamata Farisi ra rdir-talik wan yai ma rti murin. Ba Farisi ra ovu tamata ovi rorang Herodes rasdovu lahir ira ma al ranovak ma raꞌan vai isa mane rfedan Yesus. ");
INSERT INTO frd_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Yesus ovu Ni tamata ovi rorang Ia rewal ira rti danau Galilea. Tamata rivun ilaꞌa rtali propinsi Galilea rorang ira, ovu tamata ovi rma vali rtali propinsi Yudea, rtali kota Yerusalem, propinsi Idumea, wan ovi rnaꞌa oar Yordan ni lihir a, ovu vali rtali wan ovi sarseri ovu kota Tirus ovu kota Sidon. Tamata rivun ilaꞌa rarenar ne, Yesus notu mujizat rivun, ba rma ma rtuan Yesus. ");
INSERT INTO frd_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ia nfalak verin Ni tamata ovi rorang Ia ma ti rala kumal isa verin Ia, boma wean i tamata rivun avyai rdir-sidekin ira, na wol rdekin kena Ia. ");
INSERT INTO frd_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ia notu ma lolin roak tamata rivun ovi rira suhut ra, ba tamata liak ovi rira suhut obin rdir-sidekin ira ma rkiwal ma rkena Ia. ");
INSERT INTO frd_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Tamata liak boku vali nait sian ra rleal ira, ma naꞌut i rsiꞌik Yesus, na rsangatur lahir verin Ia ma rafwak ne, “Ubu Yanan Oa!” ");
INSERT INTO frd_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Naꞌuk Yesus nfalak teri lahir ma deka rfalak ne, iki Ia. ");
INSERT INTO frd_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesus nvaꞌal vuar isa ma nera tamata ovi ralan nfalak a ma rorang Ia. Ba tamata avyai rma ma rtuan Ia. ");
INSERT INTO frd_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ia nfili tamata vutu rahin irua ma reluk Ni rasul ma rorang Ia, boma nsinir ma rti rfamalik Ubu Ni Ivar Lolin, ");
INSERT INTO frd_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ovu nala Ni ngrebat verin ira ma raling vatuk nait sian ra tali tamata ra. ");
INSERT INTO frd_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Tamata ovi Yesus nfili ra, nararira Simon i Yesus nfanara ia ne Petrus, ");
INSERT INTO frd_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yakobus irua warin a Yohanes, yamarira naran Zebedeus (Yesus nfanara ira ne Boanerges, ihin a vairira wean dodung). ");
INSERT INTO frd_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andreas, Filipus, Bartolomeus, Matius, Tomas, Yakobus i yaman naran Alfeus, Tadeus, Simon i ntali sidovung isa naran Zelot, ");
INSERT INTO frd_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ovu Yudas Iskariot i nfedi Yesus. ");
INSERT INTO frd_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Nata Yesus ovu Ni tamata ovi rorang Ia rewal ira rti rahan i nleal a, na tamata rivun rasdovu ewal ira, ba Yesus ovu Ni tamata ra wol bisma rafnaꞌan. ");
INSERT INTO frd_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ni tiniman rarenar afa yai, ba rti lahir ma rala Ia. Ira rfalak ne, “Yesus nfoar-nlakat roak!” ");
INSERT INTO frd_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Yahudi rira dawan boku ovi rair Ubu Ni inukun ra rtali Yerusalem rma ma rfalak ne, “Beelzebul i nitdawan ia nleal Yesus! Nait sian rira dawan ini nala ngrebat verin Ia ma naling vatuk nait sian ra.” ");
INSERT INTO frd_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ba Yesus nera tamata rivun avyai ma nala vaivatul kamkuma al nfalak verin ira ne, “Nitdawan wol naling nala ni nait sian ra tali tamata. ");
INSERT INTO frd_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Wean i rsiduk nuhu dawan isa naꞌut ifira ma sidovung ra rotu rihi, na nuhu dawan yai veka namaꞌar. ");
INSERT INTO frd_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Wean i tamata ra rsingarahi naꞌa rahan teta isa, na rira rahan teta veka namaꞌar vali. ");
INSERT INTO frd_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ba wean vali i nitdawan nsingarahi-sikual ovu ni nait sian ra, na ni fareta veka namaꞌar ma wol nfaret-nala roak ira. ");
INSERT INTO frd_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Wean vali inyai, wol tamata nti nala tamata ngrebat isa ni rahan ma nbori ni metan ra, naꞌuk musti nkeak ia veki, beti nbor-nala ni metan ra. ");
INSERT INTO frd_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Afa i ufalak verin mia ini, kena urun! Ubu bisma naꞌi vatuk tamata rira salasilan ra, velik ne rfalak sian Ia. ");
INSERT INTO frd_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Naꞌuk tamata ovi rfalak sian Ubu Ni Roh, na Ubu veka wol naꞌi vatuk roak rira salasilan ra. Ba rira salasilan yai nanaꞌa, nata ti wol ni wahan.” ");
INSERT INTO frd_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesus nfalak wean inyai, tevek tamata boku rfalak ne, nait sian nleal Ia. ");
INSERT INTO frd_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Nata Yesus renan ovu warin ra rma, naꞌuk rdiri rahan murin watan, ba rsinir tamata ra ma ti rera Ia. ");
INSERT INTO frd_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Tamata rivun rdok-lilit Yesus ma rfalak verin Ia ne, “Baba, ti ma msiꞌik renam ovu warim ra rnaꞌa murin eri. Ira inar ma rangrihi nulu Oa.” ");
INSERT INTO frd_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesus nfalak verin ira ne, “Yaꞌa renang iki te waring aba?” ");
INSERT INTO frd_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Yesus nsiꞌik tamata ovi rdok-lilit Ia ma nfalak ne, “Mia ini renang ovu waring ra! ");
INSERT INTO frd_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Tamata iki watan not-orang afa ovi Ubu ralan nfalak a, na Yaꞌa urang ia, waring ia, ovu renang ia.” ");
INSERT INTO frd_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Amar isa, na Yesus nsiair ewal vali naꞌa danau Galilea nelan a, na tamata rivun ilaꞌa rdir-lilit Ia. Ba Yesus nti ma nrata ndoku kumal isa i nlau naꞌa danau, ma nsiair naꞌa inyai. ");
INSERT INTO frd_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Yesus nala vaivatul kamkuma ra al nair afa rivun verin ira. Ba nair ira ma nfalak ne, ");
INSERT INTO frd_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Eka mryenar! Amar isa, na tamata vaꞌi isa nti navuri nabat ra. ");
INSERT INTO frd_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Naꞌut i navuri nabat ra obin, na boku rleka naꞌa lingaꞌan ralan, ba manut nangan ra rma ma raꞌan munuk watan. ");
INSERT INTO frd_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Nabat boku vali rleka naꞌa vatralan i lanun kadkedan watan. Wol mnanat, na nabat ra rarubu lahir, tevek lanun a masnifit watan. ");
INSERT INTO frd_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Naꞌuk ti ma lera ndirlola, na nabat ovi rarubu roak yai roarira ra rakla munuk ma rangaran, tevek wol rabwaꞌar ma lolin obin. ");
INSERT INTO frd_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Nabat boku vali rleka naꞌa kadkadir ralan. Kadkadir avyai rmel-yatak irubun ra, ba wol vuarira. ");
INSERT INTO frd_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Tali nabat avyai, na boku vali rleka naꞌa lanun tinemun, ba rarubu rmela ma lolin, ovu vuarira; funu boku rira vatul ra vatvutun taltelun, boku vatvutun nanean, boku vali ratratut sasan.” ");
INSERT INTO frd_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Nata Yesus nfalak verin ira ne, “Iki arun, na eka nrenar ma lolin!” ");
INSERT INTO frd_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ti ma Yesus ovu Ni tamata vutu rahin irua, ntafal vali tamata boku ovi rorang Ia, rti talik roak tamata rivun avyai, na rorat Yesus ne, “Vaivatul kamkuma inlangin a, ihin wean inba?” ");
INSERT INTO frd_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Yesus nfalak verin ira ne, “Ubu notu ma fyan-aran afa ovi Ia wol nfavotuk obin verin tamata ra naꞌa i wean inba ma nfareta tamata ra wean lahir Raja. Naꞌuk verin tamata liak ra, na air ira ovu vaivatul kamkuma ra, ");
INSERT INTO frd_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","boma: velik ne rsiꞌik afa ovi otu ra, naꞌuk wol rfan-aran afa avyai. Rarenar Ning vaivatul ra, naꞌuk wol rfan-aran vali, boma deka rahil ma rtalik tali rira salasilan ra, ma Ubu wol naꞌi vatuk rira salasilan ra.” ");
INSERT INTO frd_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ba Yesus nfalak verin tamata ovi rorang Ia ne, “Mia wol mkyaꞌa vaivatul kamkuma ini, ba wean inba ma mkyaꞌa munuk vaivatul kamkuma ovi veka ufamalik verin mia? ");
INSERT INTO frd_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Tamata vaꞌi yai navuri nabat ra, wean ia nfamalik Ubu Ni vaivatul ra. ");
INSERT INTO frd_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Tamata ovi rarenar Ubu Ni vaivatul ra, wean nabat ovi rleka naꞌa lingaꞌan ralan. Naꞌut i rarenar, na nitdawan nma lahir ma nal-ewal Ubu Ni vaivatul avyai ma wol rnaꞌa ralarira ra. ");
INSERT INTO frd_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Tamata liak boku wean nabat ovi rleka naꞌa vatralan. Tamata avyai rarenar Ubu Ni vaivatul ra ma rtorung lahir ovu ralarira lolin. ");
INSERT INTO frd_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Naꞌuk ira wean irubun ovi wol rabwaꞌar, ba wol rtahang ma mnanat. Ba ti ma rtuan susa te tamata ra rwi-rwa ira, tevek rorang Yaꞌa, na rafla talik lahir rira inorang a. ");
INSERT INTO frd_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Tamata liak boku vali wean nabat ovi rleka naꞌa kadkadir ralan. Ira rarenar Ubu Ni vaivatul ra, ");
INSERT INTO frd_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","naꞌuk ralarira ra raruan naꞌa afa rivun, ma inar ma rira metan rivun, ovu inar ma rira afa liak ra vali. Ba Ubu Ni vaivatul ra wol wan roak naꞌa ralarira ra, ma rira vavaꞌat ra wol vuarira. ");
INSERT INTO frd_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Naꞌuk tamata liak boku wean nabat ovi rleka naꞌa lanun tinemun. Ira rarenar Ubu Ni vaivatul ra ovu rtorung ma rala naꞌa ralarira ra, ba vuarira rivun, ma boku vatvutun taltelun, boku vatvutun nanean, ovu vali ratratut sasan.” ");
INSERT INTO frd_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ba Yesus nfalak verin tamata avyai ne, “Tamata ra wol rtutun damar ma rulang teri ovu ngusi, te rfadoku naꞌa koꞌi vavan a. Naꞌuk ira veka rfadoku damar naꞌa damar wan, te wahal? ");
INSERT INTO frd_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Afa fanfonak ra veka lyawan, ovu afa ovi tamata ra wol rkaꞌa veka rvotuk. ");
INSERT INTO frd_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ba iki arun, na eka nrenar ma lolin!” ");
INSERT INTO frd_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Nata Yesus ntafal ma nfalak ewal ne, “Fyikir ma lolin naꞌa afa i mryenar! Tamata i norang afa ovi air verin ia, na Ubu veka ntafal ma nfan-aran afa ovi ufalak ra. ");
INSERT INTO frd_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Tamata iki watan inan ma nfan-aran Ubu Ni vaivatul ra, na Ubu veka ntafal ni kakaꞌa. Tamata iki watan wol inan ma nfan-aran Ubu Ni vaivatul ra, velik ne nkaꞌa kadkedan roak, na Ubu veka nala munuk kakaꞌa yai tali ia.” ");
INSERT INTO frd_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesus nfalak ewal ne, “Ubu nfareta tamata ra wean lahir Raja veka wean ini. Tamata isa nti ni vaꞌi ma nava nabat ra. ");
INSERT INTO frd_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Tamata yai ovan-amar tuba-batar watan ia. Nabat avyai rarubu ovu rmela ma dawan ira, naꞌuk ia wol nkaꞌa ne, afakinimi wean inyai. ");
INSERT INTO frd_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Lanun saꞌi nfaihing afamtahan ra ma vuarira. Ba kan ra ula ira, nata funu ra, beti vuan ra. ");
INSERT INTO frd_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Wean i vuarira rwavar roak, na tamata vaꞌi yai nti ma nafdiar, tevek naran roak amar fadiar a.” ");
INSERT INTO frd_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesus norat vali ira ne, “Ubu nfareta tamata ra wean lahir Raja, na felan a veka wean inba? Ufamalik vaivatul kamkuma aka al ufalyawang Ni Fareta a? ");
INSERT INTO frd_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Naꞌut i Ubu nfareta tamata ra wean lahir Raja, na veka wean ini: tamata isa nala sesawi ni vatul a ma nava naꞌa ni vaꞌi a. Sesawi ni vatul yai koꞌu lia munuk tali afa ovi rira vatul ra munuk naꞌa lanit ivavan a. ");
INSERT INTO frd_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Naꞌuk ti ma narubu, na dawan lia munuk afa liak ovi rnaꞌa vaꞌi a. Sanan ra dawan, ba manut nangan ra ti rotu rira renga naꞌa.” ");
INSERT INTO frd_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesus nair tamata ra ovu vaivatul kamkuma rivun ovi wean vaivatul kamkuma avyai, ma inovan ovu rira kakaꞌa. ");
INSERT INTO frd_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ia nair ira ovu vaivatul kamkuma ra watan, naꞌuk ti ma nanaꞌa aling Ia ovu Ni tamata vutu rahin irua ovi rorang Ia, na nfalyawang munuk afa avyai verin ira. ");
INSERT INTO frd_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Nata lera nakduvul ma laflofan roak, na Yesus nfalak verin Ni tamata ovi rorang Ia ne, “Mya ma tati danau Galilea ni lihir a.” ");
INSERT INTO frd_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Yesus ndoku kumal ralan obin, na Ni tamata ovi rorang Ia raroal ma rarata kumal yai, beti rti talik tamata rivun avyai. Kumal liak boku rorang vali ira. ");
INSERT INTO frd_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Nata nait fufakmetan nkena ira, ba saksakan ra mane rulang ira, ovu wear ndata lahir rira kumal ralan a, ba sarseri ma rakduvul. ");
INSERT INTO frd_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yesus naluni bantal isa naꞌa kumal ni muri a, ma ntub-lufa. Ni tamata ra rkadu Ia ma rfalak ne, “Tuan Guru, Oa wol fwaduli lahir! Ita mane takduvul roak ini!” ");
INSERT INTO frd_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yesus nbatar ma nfareta nait a, ma nfalak verin saksakan ra ne, “Ngarlina kikyai!” Nait ovu saksakan rtalik lahir ma danau yai ngarlina ma latlatan. ");
INSERT INTO frd_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ba Yesus nfalak verin ira ne, “Mia byobar aka? Afakinimi wol myorang Yaꞌa?” ");
INSERT INTO frd_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ira rbobar urun i lahir ma rsifalak afa verin ira ne, “Ini tamata iki mngaꞌun, ma nfaret-nala nait ovu saksakan ra ma rorang Ia?” ");
INSERT INTO frd_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesus ovu Ni tamata ovi rorang Ia raran roak danau ni lihir a, naꞌa wan i tamata Gerasa rleal. ");
INSERT INTO frd_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yesus nsuta tali kumal ralan a, na brana isa nait sian nleal ia, ntali van ovi rfadoku tamata matmatan naꞌa nma ma ntuan Yesus. ");
INSERT INTO frd_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Brana yai nanaꞌa watan van matmatan avyai, ovu tamata ra wol rdadul nala roak ia, velik ne rdadul ia ovu kakeak tmaꞌan. ");
INSERT INTO frd_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Tamata ra rdadul ma rivun roak liman a ean a ovu kakeak tmaꞌan, naꞌuk not-visal watan kakeak ra. Wol tamata isa ntaha teri nala ia, tevek nangrebat daꞌin. ");
INSERT INTO frd_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ovan-amar ia nbana tia ma watan naꞌa van avyai, ovu nafwak lalawatan naꞌa vuar ra, ovu vali nala vatu ovi ramneran ra ma al nfamngala tenan a. ");
INSERT INTO frd_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Naꞌut i nsiꞌik Yesus tali raroa nma, na nafla ti ntuan Ia ma nsangatur ma nraning Ia. ");
INSERT INTO frd_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Yesus nfalak verin nait sian i nleal brana yai ne, “Oa nait sian oa, ba muti talik brana ini!” Nait sian yai notu ma brana yai nafwak ne, “Yesus mwa ini ma motu afaka verin yaꞌa? Oa ini Ubu i Ni dawan nlia munuk afakataka Yanan Oa. Ala Ubu naran a ma era verin Oa ne, deka motu sian yaꞌa!” ");
INSERT INTO frd_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ba Yesus norat ia ne, “Oa naram iki?” Ia nfalak ne, “Yaꞌa narang Legion, tevek nait sian rivun ami.” ");
INSERT INTO frd_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ba nera lalawatan verin Yesus ma deka nsinir ira ma rti talik wan yai. ");
INSERT INTO frd_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Vavu dur dawan isa rfaseri wan yai ma rafnuak al rdava rira fanaꞌan naꞌa vuar ni dadudur a. ");
INSERT INTO frd_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Nata nait sian avyai rera lablobang verin Yesus ne, “Fara msinir ami ma ti amnaꞌa vavu averi.” ");
INSERT INTO frd_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yesus ntorung, ba nait sian ra rti talik brana yai ma ti rnaꞌa vavu dur yai. Vavu avyai, snain nlabas rivun irua, rafla ma rti rtobur tali biliꞌin nelan ma rsuta danau ralan ma rakduvul ma rmata munuk. ");
INSERT INTO frd_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Tamata ovi rfawatak vavu avyai rafla ma ti rfamalik naꞌa kota isa ovu ahu ovi rfaseri inyai ne, Yesus nsinir nait sian ra ma ti rnaꞌa vavu dur isa. Ba tamata ra ti ma ramunin afa i Yesus beti notu a. ");
INSERT INTO frd_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ba rma ma rtuan Yesus, na rarea brana i lan a, nait sian ra rleal ia. Nait sian ra wol rleal roak ia ma nkaꞌa wan roak. Ia ndoku ovu noru-neluk ni kadaravit roak, ba rbobar. ");
INSERT INTO frd_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Tamata ovi rarea brana i lolin roak ia yai, ti rfamalik ne, Yesus naling vatuk roak nait sian ra tali tamata i nait sian ra rleal ia, ma ti rnaꞌa vavu dur isa. ");
INSERT INTO frd_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ba rera lablobang verin Yesus ma nti talik warira yai. ");
INSERT INTO frd_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ba Yesus mane nrata kumal ralan, na brana i lan a nait sian ra rleal ia, nera verin Yesus ma novu vali. ");
INSERT INTO frd_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Naꞌuk Yesus wol ntorung ma novu, ma nfalak verin ia ne, “Ni lolin a, mewal aꞌuk oa muti mu ahu a, ma fwamalik verin mu rahan teta naꞌa Duilaꞌa Ni afa lolin ovi notu munuk roak verin oa, ovu Ni silobang i nfaturu roak verin oa.” ");
INSERT INTO frd_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ba brana yai nti wan i naran Dekapolis ma nfamalik naꞌa afa lolin ovi Yesus notu verin ia, ma tamata ovi rarenar ra rtalkaka munuk. ");
INSERT INTO frd_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesus navul kumal ma netal ewal nti danau ni lihir a. Naꞌa danau yai nelan a, tamata rivun rma ma rdir-lilit Ia. ");
INSERT INTO frd_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Tamata dawan isa, naran Yairus. Ia nban-ulu naꞌa Yahudi rira rahan falurut a. Ia nma ma nsiꞌik Yesus, na nsangatur ma nsoak wahan a naꞌa Yesus wahan ralan a, ");
INSERT INTO frd_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ma nera ovu ralan urun ne, “Baba, yanak vata nawar ma dawan ia, ma sarseri ma nmata. Fara mwa ma mlobang ia ma fwadoku limam naꞌa tenan a, boma deka nmata!” ");
INSERT INTO frd_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ba Yesus irua Yairus rti, na tamata rivun ilaꞌa rorang Ia, ba tamata avyai rsidekin ira. ");
INSERT INTO frd_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Tali tamata rivun avyai, na vata isa laran nvoat ma dawan daꞌin, ti naran varat vutu rahin irua roak. ");
INSERT INTO frd_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Vata yai ni vavaꞌat wol lolin lahir, ovu nala munuk roak ni metan ra al nbahir dokter ra, naꞌuk nawar watan ia ovu ntafal ma aleman. ");
INSERT INTO frd_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ia nrenar roak ne, Yesus notu ma lolin ewal tamata ra, ba naꞌa tamata rivun fruarira ra, na vata yai nahu Yesus murin nma ma nebang Ia, ma nkena Ni ravit blawat a. ");
INSERT INTO frd_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ia nanovak naꞌa ralan a ne, “Fara ukena watan Ni ravit blawat a, na veka lolin ewal yaꞌa!” ");
INSERT INTO frd_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Naꞌut i nkena Yesus Ni ravit blawat a, na brian munuk laran i nvoat a ntalik lahir, ba ia nfarnuang ne, lolin ewal ia tali ni suhut a. ");
INSERT INTO frd_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Naꞌut inyai lahir, na Yesus a nkaꞌa ne, Ni ngrebat a ntali tenan nti ma notu ma tamata suhut ra lolin ewal ira. Ba nfulak Ia naꞌa tamata rivun avyai fruarira ma norat ira ne, “Iki nkena Ning ravit blawat i?” ");
INSERT INTO frd_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Yesus Ni tamata ovi rorang Ia rfalak ne, “Bapa kaꞌi msiꞌik watan, tamata rivun rdir-lilit Oa, ba rdekin kena Oa, naꞌuk morat watan obin ne, ‘Iki nkena Yaꞌa?’ ” ");
INSERT INTO frd_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Naꞌuk Yesus nsiꞌik lilit ira obin al ndava tamata i nkena Ia. ");
INSERT INTO frd_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Vata yai nkaꞌa roak ne lolin roak ia, ba nbobar ma raruru ia, ma nma ma nsangatur naꞌa Yesus wahan ralan a, ma nfamalik verin Ia naꞌa afakataka munuk. ");
INSERT INTO frd_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ba Yesus nfalak verin vata yai ne, “Titi, morang Yaꞌa, ba lolin roak oa! Lolin roak oa, ba mewal oa, ovu fara Ubu nala Ni malinan verin oa.” ");
INSERT INTO frd_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Naꞌut i Yesus nangrihi obin, na Yairus i nban-ulu naꞌa Yahudi rira rahan falurut yai, ni tamata ifira rtali ni rahan rma. Ira rfalak verin Yairus ne, “Itrana, yanam vata nmata roak, ba deka fwafrea Tuan Guru.” ");
INSERT INTO frd_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Naꞌuk Yesus nafena ma nrenar afa ovi rfalak ra, ba nfalak verin Yairus ne, “Deka bwobar, ba morang watan Yaꞌa!” ");
INSERT INTO frd_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yesus wol ntorung ma tamata rivun avyai rban-orang Ia, naꞌuk ntorung watan ma Petrus, Yakobus irua warin a Yohanes rovu Ia. ");
INSERT INTO frd_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ti ma raran Yairus ni rahan, na Yesus nsiꞌik rahan ralan a vangoa-vanga, ovu rvakar al rfaktanit ma vair dawan. ");
INSERT INTO frd_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yesus nti ralan ma nfalak verin ira ne, “Afakinimi vangoa-vanga ovu byakar i? Kasikoꞌu yai wol nmata, naꞌuk ntub-lufa watan!” ");
INSERT INTO frd_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ira rmalit waweang Yesus, ba Ia nsinir ira ma rti murin. Ia novun kasikoꞌu yai renan ovu yaman a, ntafal vali tamata itelu ovi rorang Ia ma rti wan i kasikoꞌu yai ntuba a. ");
INSERT INTO frd_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Yesus ntaha kasikoꞌu yai liman a ma nfalak verin ia ne, “Talita kum.” Faliak ini ihin a ne, “Titi, ufalak verin oa ma bwatar kikyai!” ");
INSERT INTO frd_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Kasikoꞌu yai nvaꞌat ewal ma nbatar lahir ma nbana. Ia ni varat vutu rahin irua. Tamata ovi rsiꞌik afa i Yesus notu yai rtalkaka urun i lahir! ");
INSERT INTO frd_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Naꞌuk Yesus nfalak teri lahir ma deka rfaivar verin iki watan naꞌa afa i notu a. Ia nfalak munuk wean inyai, na nsinir ira ma rala afamtahan ma kasikoꞌu yai naꞌan. ");
INSERT INTO frd_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesus ovu Ni tamata ovi rorang Ia rti talik wan yai, ma rti Ni ahu. ");
INSERT INTO frd_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Naꞌut amar i Yahudi ra ryari ira, na Yesus nsiair naꞌa rira rahan falurut. Tamata rivun rarenar afa ovi nfalak ra, na rtalkaka. Ba rsiforat ira ne, “Ia nkaꞌa afa avyai tali inba? Ia Ni kakaꞌa ntali iki? Iki nala ngrebat ini verin Ia ma not-nala mujizat ra? ");
INSERT INTO frd_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ia tukan kayu Ia. Renan naran Maria ovu warin ra verin Yakobus, Yoses, Yudas ovu Simon. Uran ra rleal vali ini.” Tamata rivun avyai ralar sian Ia, ba rafena ma rorang Ia. ");
INSERT INTO frd_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesus nfalak verin ira ne, “Tamata ra ralang nabi isa naꞌa wan inba watan, naꞌuk wol ralang ia naꞌa ni ahu, ovu naꞌa ni rahan teta, ovu ni tiniman ra wol ralang vali ia.” ");
INSERT INTO frd_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Yesus wol notu mujizat naꞌa inyai, tevek wol rorang Ia. Naꞌuk nfadoku liman nanaꞌa tamata ifira watan ovi rira suhut ra, ma lolin ewal ira. ");
INSERT INTO frd_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Yesus nabrian, tevek wol rorang Ia. Nata Yesus nban-lilit ahu ovi rnaꞌa wan yai, ma nsiair. ");
INSERT INTO frd_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Naꞌut inyai, na Ia nasdovu Ni tamata vutu rahin irua ovi rorang Ia, beti nsinir ma raruan ira rti, ovu nala Ni ngrebat verin ira ma raling vatuk nait sian ra tali tamata ra. ");
INSERT INTO frd_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Yesus nsurak ira ma nfalak ne, “Deka mtyaha afa rivun naꞌa bira banbanan, ba mtyaha watan bira takil ra. Deka mtyaha kesi, sadawan, ovu vali kubang. ");
INSERT INTO frd_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Myaꞌadoru tatea ra naꞌa eabira ra, naꞌuk deka mtyaha ravit blawat, nlia tali isa.” ");
INSERT INTO frd_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ia ntafal ma nfalak verin ira ne, “Wean i miti rahan isa, na mnyaꞌa inyai, ti naran i mane miti talik wan yai. ");
INSERT INTO frd_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Wean i tamata ovi rnaꞌa ahu isa wol rtorung ma mnyaꞌa inyai, ovu vali wol rarenar bira vaivatul ra, na byan-talik wan yai. Misnabar vatuk kyavu tali eabira ra, boma neluk faneak ne, Ubu veka nukun ira.” ");
INSERT INTO frd_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ba Yesus Ni tamata ovi rorang Ia rti rfamalik Ubu Ni Ivar Lolin verin tamata ra, boma rahil ma rtalik tali rira salasilan ra. ");
INSERT INTO frd_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ira raling vatuk nait sian rivun tali tamata ra. Raslofi vali ngul naꞌa tamata rivun ovi rira suhut ra, ma lolin ewal ira. ");
INSERT INTO frd_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Raja Herodes nrenar roak afa ovi Yesus notu ra, tevek tamata rivun rkaꞌa roak naran a. Tamata boku rfalak ne, “Yohanes i nbaptis tamata ra nvaꞌat ewal roak tali matmatan a, ba ia ni ngrebat ma not-nala mujizat ra.” ");
INSERT INTO frd_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Naꞌuk tamata liak boku rfalak ne, “Ia ini nabi Elia.” Boku rfalak vali ne, “Yesus yai nabi Ia, wean nabi lalan ra.” ");
INSERT INTO frd_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Herodes nrenar afa ovi tamata ra rfamalik yai, na nfalak ne, “Wahal, inyai Yohanes i usinir tamata ra ma rvangal ia nvaꞌat ewal roak!” ");
INSERT INTO frd_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","20","Herodes nala roak warin i Filipus awan a naran Herodias ma neluk awan, ba Yohanes nfalak lalawatan verin ia ne, “Wol bisma msifa ovu ia, tevek motu wean inyai, na mangal roak Ubu Ni inukun ra!” Afa i Yohanes nfalak yai notu ma Herodias ntonan mane nfedan ia, naꞌuk wol not-nala, tevek Herodes nalang Yohanes ovu nkaꞌa ne, ni vavaꞌat a nmalola ovu wol ni salasilan lahir. Velik ne afa ovi Yohanes nfalak yai rotu ma Herodes ralan raruan, naꞌuk inan ma nrenar watan. Herodes nfalak ma rtaha Yohanes ma rkeak ia ma ti rfadoku ia naꞌa buꞌi ralan a. Notu wean inyai tevek awan a, naꞌuk nsinir tamata ovi rnaꞌa buꞌi ralan a ma rwanar Yohanes. ");
INSERT INTO frd_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ti nata Herodias ndav-nala roak lingaꞌan mane nfedan Yohanes. Naꞌut inyai, na Herodes notu ni snoba ma al nfangnanang ni amar vulan kena. Ia nasdovu munuk ni dawan fareta ra, dawan suldadu ra, ovu vali tamata dawan ra naꞌa propinsi Galilea. ");
INSERT INTO frd_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Herodias yanan vata nti snoba ralan ma nsoꞌi-nsomar. Ba notu ma raja Herodes ovu ni mangun ra inar urun. Herodes nfalak verin vata mnelat yai ne, “Mera afaka watan tali yaꞌa, na veka ala verin oa!” ");
INSERT INTO frd_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ia nafwaba lahir verin vata yai ne, “Mera afaka watan tali yaꞌa, na veka ala verin oa, velik ne wang i ufareta ni lihir vali, veka ala watan verin oa.” ");
INSERT INTO frd_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ba vata yai nti murin ma norat renan ne, “Veka era afaka tali ia?” Renan nfalak ne, “Mera Yohanes i nbaptis tamata ra, ulun a.” ");
INSERT INTO frd_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Nata vata yai newal lahir ia ma ti nfalak verin Herodes ne, “Era ma fwadoku Yohanes i nbaptis tamata ra, ulun a, naꞌa binan dawan isa ma mala verin yaꞌa.” ");
INSERT INTO frd_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Herodes nrenar afa i vata yai nfalak a, na ralan lalau urun, naꞌuk wol nalaꞌing nala roak afa i vata yai nera, tevek nafwaba roak ma ni mangun ra rarenar. ");
INSERT INTO frd_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ba Herodes nsinir lahir suldadu isa ma ti nfedan Yohanes, ma nala ulun a verin ia. Suldadu yai nti buꞌi ralan ma nvangal Yohanes ulun a. ");
INSERT INTO frd_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ia nfadoku Yohanes ulun a naꞌa binan dawan isa, beti rala verin vata mnelat yai, ma ntaha ti verin renan a. ");
INSERT INTO frd_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ti ma Yohanes ni tamata ovi rorang ia rarenar ne nmata roak, na rti ma rala tbunan a ma ti rfanuba naꞌa van isa ralan a. ");
INSERT INTO frd_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yesus Ni tamata ovi lan nsinir ira ma rti rfamalik Ubu Ni vaivatul ra rewal ira ma ti rtuan Ia. Ira rfamalik munuk afa ovi rotu ra, ovu vali rira afa ovi rair ra verin Ia. ");
INSERT INTO frd_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Yesus nfalak verin ira ne, “Mya ma did tinemun tati wan lean vu isa ma myari kedan mia.” Ia nfalak wean ini, tevek tamata ra rma ma rtuan lalawatan ira, ma wol rafnaꞌan ovu wol rot-nala akataka vali. ");
INSERT INTO frd_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ba aksa ira ravul kumal rti wan lean vu isa. ");
INSERT INTO frd_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Tamata rivun rarea ira rti, na ref nala ira, ma tamata avyai rtali ahu munuk naꞌa wan yai rafla watan rahu raa ma raran lan, beti Yesus ovu Ni tamata ra raran. ");
INSERT INTO frd_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ti ma Yesus nsuta tali kumal ma nda, na nsiꞌik tamata rivun avyai. Ia nfaturu Ni silobang verin ira, tevek ira wean domba ovi wol duarira. Nata nair afa rivun verin ira. ");
INSERT INTO frd_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Lera nakduvul ma laflofan roak, ba Yesus Ni tamata ovi rorang Ia rma rtuan Ia ma rfalak ne, “Wol tamata rleal wan lean vu ini, ovu vali lera sian roak, ");
INSERT INTO frd_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","ba msinir ira ma rti ahu ovi sarseri ma rfaha afamtahan ma raꞌan.” ");
INSERT INTO frd_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Naꞌuk Ia nfalak verin ira ne, “Mia musti fyaꞌan ira!” Ira rfalak verin Ia ne, “Ba ami musti amfaha roti fyawan dinar ratut irua ma amfaꞌan tamata rivun ovi?” ");
INSERT INTO frd_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ba Ia norat ira ne, “Bira roti ifira? Eka miti ma msyiꞌik.” Ira rti ma rsiꞌik, ma rewal ira ma rfalak ne, “Roti ilima ovu ian irua.” ");
INSERT INTO frd_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Yesus nsinir tamata avyai munuk ma rotu rira sidovung ma rdoku ngrova yanat ratarira ra. ");
INSERT INTO frd_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ba tamata rivun avyai rdoku naꞌa sidovung ra, ma tali sidovung avyai, na boku tamata vatvutun lamliman, boku vali ratratut sasan. ");
INSERT INTO frd_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Yesus nala roti ilima ovu ian irua yai, beti ntadata nrata lanit ma nfalak fara weninyai verin Ubu. Ia notu munuk wean inyai, beti nvisul roti avyai ma nala verin Ni tamata ovi rorang Ia, boma rti rsiduk verin tamata rivun avyai. Nvisul vali ian irua yai ma rsiduk verin tamata ra munuk. ");
INSERT INTO frd_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ira rir tinemun rafnaꞌan ma evurira ra rveda munuk roak, ");
INSERT INTO frd_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","beti Yesus Ni tamata ovi rorang Ia rasdovuk munuk roti teran ovu ian teran avyai naꞌa ahir vutu rahin irua rngora. ");
INSERT INTO frd_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Tali tamata ovi raꞌan roti ovu ian avyai, brana ra watan rivun ilima. ");
INSERT INTO frd_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Yesus nsinir lahir Ni tamata ovi rorang Ia ma ravul kumal yai, ma ula ira rti ahu Betsaida naꞌa danau Galilea ni lihir a. Ia nanaꞌa wan yai obin ma nsinir tamata rivun avyai ma rewal ira. ");
INSERT INTO frd_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ti ma tamata rivun avyai rsilyaha, beti Yesus nvaꞌal vuar ma naflurut. ");
INSERT INTO frd_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ti ma ovan roak, na Ni tamata ra rnaꞌa kumal yai ma rti raran roak danau ni fruan a, na aksa Ia naꞌa da obin. ");
INSERT INTO frd_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Yesus nsiꞌik ira rvahi ma nawar ira, tevek nait a dawan nangal ira. Kaꞌa bi nfadaꞌing amar roak, beti Yesus nbana naꞌa wear ratan ma norang ira, ovu notu mane nbana lia ira. ");
INSERT INTO frd_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Naꞌuk ti ma rarea Ia nbana naꞌa wear ratan, na rnarin ne nitu ngran Ia, ba rafwak, ");
INSERT INTO frd_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","tevek ira munuk rarea Ia ovu rbobar urun i lahir. Naꞌuk Ia nfalak lahir verin ira ne, “Ralabira ra deka kakoꞌu, tevek ini Yaꞌa, ba deka byobar!” ");
INSERT INTO frd_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Yesus nrata kumal yai ma ntuan ira, na nait ntalik lahir. Ira rabrian munuk, ");
INSERT INTO frd_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","tevek wol rkaꞌa Yesus Ni dawan obin. Velik ne rsiꞌik roak Ia nfamela roti ovu ian ra, naꞌuk ralarira rasmotak watan. ");
INSERT INTO frd_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ira ravul kumal yai ma retal nala roak danau Galilea, ma rda raran ngur tavun i rfanara ia ne Genesaret, ma rfalau rira kumal a. ");
INSERT INTO frd_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Rsuta tali kumal yai, na brian munuk, tamata ra ref-nala lahir Yesus. ");
INSERT INTO frd_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ba tamata ra rban-lilit lahir wan yai, ma rfaivar verin tamata ra ne, Yesus nanaꞌa wan yai. Nata, tamata ovi wol rira suhut ra rvara ovi rira suhut ra naꞌa rira dari ra, ma rti wan inba watan ovi rarenar ne, Yesus nanaꞌa. ");
INSERT INTO frd_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Naꞌa wan inba watan Yesus nma, naꞌa ahu te kota te wan liak, ira rovun tamata ovi rira suhut ra rti wan i rfedi-rfaha afa naꞌa. Nata tamata ovi rira suhut ra rvakar al rera verin Ia ne, “Fara mtorung ma amkena watan mu ravit a blawat ni wahan a.” Ba tamata ovi rkena Ia, lolin munuk ira. ");
INSERT INTO frd_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Amar isa, na tamata boku tali Yahudi rira sidovung isa naran Farisi, ovu boku vali tali Yahudi rira dawan ovi rair Ubu Ni inukun ra, rtali Yerusalem rma ma rtuan Yesus. ");
INSERT INTO frd_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","4","Tamata Farisi ra ovu tamata Yahudi liak ra munuk rorang ma dawan adat ovi rtali uburir-nusirira ra. Adat avyai rfalak ma raraming limarira ra beti rafnaꞌan, wean tamata isa newal ia tali wan i rfedi-rfaha afa naꞌa, na nliru ia ma nmerat veki, beti nafnaꞌan. Ira rorang vali inukun rivun tali uburir-nusirira ra, wean raraming rira ketal, kobi ovu afa ovi rala al rafvaꞌak ra ma rmerat. Tamata Farisi ra ovu Yahudi rira dawan avyai rsiꞌik Yesus Ni tamata boku ovi rorang Ia rafnaꞌan, naꞌuk wol rot-orang rira adat ma raraming limarira ra. ");
INSERT INTO frd_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ba ira mane rfasala Ni tamata ra ma rfalak ne, “Afakinimi Mu tamata ovi rorang Oa wol rorang dida adat ovi rtali ubud-nusid ra? Ira rafnaꞌan, naꞌuk wol raraming limarira ra.” ");
INSERT INTO frd_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesus nfalak verin ira ne, “Mia ini wean lahir tamata ovi rfalak afa isa, naꞌuk rotu afa liak! Afa ovi lan ana, nabi Yesaya ntulis roak naꞌa Surat Ralan a, rfamalik lahir mia. Yesaya ntulis ne, ‘Tamata ovi rfadawang Yaꞌa ovu rira vaivatul ra, naꞌuk ralarira ra raroa tali Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ira raraning Yaꞌa, naꞌuk wol ihin lahir, tevek afa ovi rair ra wol rtali Ubu, naꞌuk rtali tamata!’ ");
INSERT INTO frd_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Mia wol myorang afa ovi Ubu nfareta ma myotu a, ba inabira ma myorang aꞌuk adat ovi tamata ra rotu.” ");
INSERT INTO frd_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yesus ntafal ma nfalak vali verin ira ne, “Mia mkyaꞌa dalang ma mifena ma myorang afa ovi Ubu nfareta, ma myorang aꞌuk bira adat ra! ");
INSERT INTO frd_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Lalan ana, Musa nfalak roak ne, ‘Myalang renabir-yamabira ra,’ ovu vali, ‘Tamata iki watan i nfalak sian renan te yaman a, na musti rfedan ia.’ ");
INSERT INTO frd_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Naꞌuk mia myair tamata Yahudi ra ne, wean i tamata isa nfalak verin renan te yaman a ne, ‘Mane ala afa boku verin mia ma al ulobang mia, naꞌuk ala roak verin Ubu, ma neluk ning korban verin Ia.’ ");
INSERT INTO frd_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Mia fyalak ne, lolin watan ma tamata yai wol nlobang renan te yaman a. ");
INSERT INTO frd_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ba wean inyai, na sala ma dawan mia. Mia wol fyabana roak Ubu Ni vaivatul ra, tevek myorang aꞌuk ububir-nusibira rira adat ra. Afa ovi wean inyai, mia myotu ma rivun obin.” ");
INSERT INTO frd_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Nata Yesus nera ewal tamata rivun avyai ma nfalak verin ira ne, “Eka mryenar ma lolin afa ovi ufalak ra, boma mkyaꞌa. ");
INSERT INTO frd_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Afa ovi mian ra wol rfangra mia. Naꞌuk afa ovi rtali ralabira ra kaꞌi rfangra mia.  ");
INSERT INTO frd_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ba tamata iki watan tali mia inan ma nkaꞌa Ning vaivatul ra, na eka nrenar ma lolin!” ");
INSERT INTO frd_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Nata Yesus nban-talik tamata rivun avyai ma nti rahan isa ralan a, na Ni tamata ovi rorang Ia rorat Ia naꞌa vaivatul kamkuma i nfamalik a. ");
INSERT INTO frd_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ia nfalak verin ira ne, “Ba mia wol fyan-aran obin? Wol mkyaꞌa ne, afa ovi rtali murin rti tamata evun ralan wol rot-nala ma ni vavaꞌat wol nmalola naꞌa Ubu wahan ralan a. ");
INSERT INTO frd_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Afamtahan wol nsuta tamata ralan a, naꞌuk nsuta evun a, beti ntimuri vatuk ia.” (Yesus nfalak wean ini ma nfaturu ne, bisma taꞌan afamtahan afaka watan, ovu afamtahan ovi taꞌan avyai wol rotu ma dida salasilan.) ");
INSERT INTO frd_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Yesus ntafal ma nfalak ne, “Afa ovi rtali tamata ralan saꞌi rfangra tamata rira vavaꞌat ra. ");
INSERT INTO frd_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ba afa ovi rtali tamata ralan rotu ma tamata ra rfikir aꞌuk afa ovi sian ra. Ira rsifa tia ma watan ovu tamata ovi wol awarira verin ira, rbori, rsifedan, ");
INSERT INTO frd_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","tamata ovi rsifa roak, naꞌuk rtuba ovu tamata ovi wol awarira verin ira, tamata ovi inar ma rtafal ilaꞌa rira metan ra, inar urun ma rot-visal tamata rira vavaꞌat ra, rsiklabir sian, rorang rira ininan sian ra, rboꞌitea tamata liak rira metan ra, rfalak sian tamata, rfakaratat tenarira ra, ovu vali rboda-rbadi. ");
INSERT INTO frd_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Afa sian avyai munuk rtali tamata ralan ovu rotu ma ni vavaꞌat a wol nmalola naꞌa Ubu wahan ralan.” ");
INSERT INTO frd_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesus nban-talik propinsi Galilea ma nti wan i nfaseri kota Tirus. Ia nti rahan isa ralan a, ovu nafena ma tamata ra rkaꞌa ne, nleal inyai. Naꞌuk wol nfonak nala tenan, tevek tamata rivun rkaꞌa roak. ");
INSERT INTO frd_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Naꞌut inyai, na vata isa, nait sian nleal yanan vata koꞌu a. Naꞌut i nrenar afa ovi Yesus notu ra, na nma lahir ma nsangatur nulu Yesus. ");
INSERT INTO frd_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Vata ini wol tamata Yahudi ia. Ia ntali wan isa naran Fenisia i naꞌa propinsi Siria. Ia nera lablobang verin Yesus ma naling vatuk nait sian tali yanan vata yai. ");
INSERT INTO frd_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yesus nfalak verin ia ne, “Wol lolin, wean i tala kasikoꞌu rira afamtahan ra ma tvatuk verin yaha ra ma raꞌan.” ");
INSERT INTO frd_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Vata yai nfalak verin Yesus ne, “Kena ta Duilaꞌa, naꞌuk yaha ra baꞌi raꞌan kasikoꞌu rira afamtahan mumun ovi rleka naꞌa meja vavan.” ");
INSERT INTO frd_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ba Yesus nfalak verin ia ne, “Oa mu vaivatul ovi fwalak yai lolin, ba bisma mewal aꞌuk oa, tevek nait sian nti talik roak yanam vata.” ");
INSERT INTO frd_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Vata yai newal ia nti naran ni rahan ma nsiꞌik, na yanan ntuba koꞌi ratan. Nait sian nti talik roak ia. ");
INSERT INTO frd_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Nata Yesus nti talik Tirus ma nti kota Sidon, beti newal Ia nahu wan Dekapolis ma nti danau Galilea. ");
INSERT INTO frd_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Tamata ra rovun brana isa nma ma ntuan Yesus. Brana yai nangrihi, naꞌuk ni vaivatul ra wol lyawan, ovu naktun. Ira rera lablobang verin Ia ma nfadoku liman naꞌa brana yai. ");
INSERT INTO frd_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ba Yesus novun ia ma rfaroa ira tali tamata rivun ovi rnaꞌa inyai, ma naꞌadoru liman tanan ra rti brana yai arun ra, beti notu beran naꞌa liman a ma nkena brana yai earn a. ");
INSERT INTO frd_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Nata ntadata nrata lanit ma nanak ma dodun, beti nfalak ne, “Efata!” Ihin ne: “Natvadil lahir!” ");
INSERT INTO frd_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Brian munuk, na arun ra lolin lahir ma nafrenar, ovu earn maraan vali ma nangrihi ma lyawan roak. ");
INSERT INTO frd_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesus nfalak teri tamata ovi rnaꞌa inyai ma deka rfamalik afa yai verin tamata iki watan. Velik ne Yesus nfalak teri ira, naꞌuk rfamalik lalawatan afa yai naꞌa inba watan. ");
INSERT INTO frd_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Tamata ra rtalkaka lahir ma rfalak ne, “Yaꞌi yo! Ia notu munuk afa ovi ma lolin buas, tevek notu ma tamata i naktun bisma nafrenar, ovu notu ma tamata i nmanu bisma nangrihi.” ");
INSERT INTO frd_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Naꞌut inyai, na tamata rivun ilaꞌa rasdovu ira. Ira wol rira afamtahan ma raꞌan, ba Yesus nera Ni tamata ovi rorang Ia ma nfalak verin ira ne, ");
INSERT INTO frd_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ufaturu Ning silobang verin tamata rivun ovi, tevek rorang Yaꞌa amar itelu roak, ovu wol rira afamtahan ma raꞌan. ");
INSERT INTO frd_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Wean i usinir ma rewal ira ovu evurira vu, na veka renweringun naꞌa lingaꞌan ralan, tevek boku rtali raroa rma.” ");
INSERT INTO frd_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ira rfalak ne, “Naꞌa wan lean vu ini, na tala roti tali inba ma naran ma al tfaꞌan tamata rivun ovi?” ");
INSERT INTO frd_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesus norat ira ne, “Bira roti ifira?” Ira rfalak ne, “Roti ifitu.” ");
INSERT INTO frd_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ia nsinir tamata rivun avyai ma rdoku lanun, beti nala roti ifitu yai ma naflurut ovu nfalak fara weninyai verin Ubu. Nata nvisul roti ra ma nala verin Ni tamata ra, ma ki rtanang verin tamata rivun avyai. Ba rtanang verin tamata rivun avyai. ");
INSERT INTO frd_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ira rira ian koꞌu boku vali, ba Yesus naflurut ovu nfalak fara weninyai verin Ubu naꞌa ian avyai, beti nsinir Ni tamata ra ma rtanang vali ian avyai verin tamata ra. ");
INSERT INTO frd_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Rafnaꞌan ma evurira ra rveda roak, beti Yesus Ni tamata ovi rorang Ia rasdovuk teran ra naꞌa ahir dawan ifitu rngora. ");
INSERT INTO frd_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Tamata ovi rafnaꞌan ini nlabas rivun ifaꞌat. Ba Yesus nsinir ira ma rewal ira, ");
INSERT INTO frd_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","beti Ia ovu Ni tamata ovi rorang Ia rarata lahir kumal isa ma rti wan i naran Dalmanuta. ");
INSERT INTO frd_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Amar isa, na tamata Farisi boku rma ma rtuan Yesus, ma rsisoal ira ovu Ia. Ira rlabir teman Ia ma rera ma notu mujizat isa ma nfaturu ne, Ubu nsinir Ia. ");
INSERT INTO frd_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesus nanak ma dodun, ma nfalak verin ira ne, “Afakinimi tamata ovi rvaꞌat fiang ini rera ma otu mujizat? Afa i ufalak verin mia ini, kena urun! Yaꞌa veka wol otu mujizat verin mia!” ");
INSERT INTO frd_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Nata nti talik ira ma nrata kumal ovu Ni tamata ovi rorang Ia, ma retal danau yai rti ni lihir a. ");
INSERT INTO frd_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Yesus Ni tamata ovi rorang Ia rablufang ma rtaha roti rivun. Ira rtaha roti isa watan naꞌa kumal a. ");
INSERT INTO frd_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesus nala vaivatul kamkuma al nsurak ira ne, “Msyiꞌik ma lolin tamata Farisi ra ovu raja Herodes rira ragi a.” ");
INSERT INTO frd_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ira kaꞌi rsifalak afa verin ira ne, “Ia nfalak wean inyai, tevek wol dida roti.” ");
INSERT INTO frd_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesus nkaꞌa afa ovi rfalak ra, ba norat ira ne, “Notu afakinimi msyifalak afa naꞌa i wol mtyaha roti? Mia wol mkyaꞌa ovu wol fyan-aran obin? Ralabira rangrebat daꞌin ma wol fyikir aran afa ini? ");
INSERT INTO frd_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Matabira, naꞌuk wol msyiꞌik? Arubira, naꞌuk wol mifrenar? Mia wol mingnanang ne, ");
INSERT INTO frd_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","amar i uvisul roti ilima verin tamata rivun ilima ma raꞌan, ovu vali rasdovuk teran ra naꞌa ahir ifira?” Ira rfalak ne, “Ahir vutu rahin irua.” ");
INSERT INTO frd_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Yesus norat ewal ira ne, “Amar i uvisul roti ifitu ma tamata rivun ifaꞌat raꞌan, na misdovuk teran ra naꞌa ahir ifira?” Ira rfalak ne, “Ahir ifitu.” ");
INSERT INTO frd_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ia nfalak verin ira ne, “Notu afakinimi wol fyan-aran obin?” ");
INSERT INTO frd_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yesus ovu Ni tamata ovi rorang Ia rbana ma raran ahu Betsaida, na tamata boku ovi rnaꞌa ahu yai rovun brana isa i nkibu verin Ia, ma rera lablobang ma nkena tamata kibu yai, boma nsirea ewal. ");
INSERT INTO frd_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ba Yesus ntaha tamata kibu yai liman a ovu nfabana ia ma rti ahu murin. Nata nafnit naꞌa tamata yai matan a ovu nfadoku liman a naꞌa matan a, beti norat ia ne, “Msirea roak?” ");
INSERT INTO frd_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Tamata yai ntadata ma nfalak ne, “Yaꞌa usiꞌik tamata ra, naꞌuk wearira aa ra rbana.” ");
INSERT INTO frd_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ba Yesus nfadok-ewal liman a naꞌa tamata yai matan a, ma lolin roak ia ba nsirea urun, ma nsiꞌik afa ra munuk ovu lyawan. ");
INSERT INTO frd_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Tamata yai lolin roak ia, beti Yesus nsinir ma newal ia nti ni rahan, ovu nsurak ia ne, “Deka muti ahu ralan veki.” ");
INSERT INTO frd_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesus ovu Ni tamata ovi rorang Ia rban-talik Betsaida ma rti ahu ovi rfaseri kota Kaisarea Filipi. Ira rnaꞌa lingaꞌan ralan obin, na Ia norat ira ne, “Tamata ra rfalak ne, Yaꞌa ini iki?” ");
INSERT INTO frd_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ira rfalak verin Ia ne, “Tamata boku rfalak ne, Oa ini Yohanes i nbaptis tamata ra. Boku rfalak ne, nabi Elia, ovu vali boku rfalak ne, tamata isa tali nabi ra.” ");
INSERT INTO frd_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ia norat ira ne, “Naꞌuk mia fyikir ne, Yaꞌa ini iki?” Petrus nfalak ne, “Oa ini Raja i mtevut mami salasilan ra!” ");
INSERT INTO frd_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ba Yesus nfalak teri lahir ma deka rfamalik afa yai verin tamata iki watan. ");
INSERT INTO frd_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Tali amar yai, Yesus nair Ni tamata ovi rorang Ia ne, “Yaꞌa, Tamata Yanan Yaꞌa, musti utuan susa rivun. Dawan Yahudi ra, ovu Yahudi rira dawan mela falurut ra ovu vali Yahudi rira dawan ovi rair Musa ni inukun ra veka ralaꞌing Yaꞌa ma rfedan Yaꞌa, naꞌuk amar itelu nelak, na Ubu veka nfavaꞌat ewal Yaꞌa.” ");
INSERT INTO frd_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesus nfalyawang lahir afa yai verin ira. Ba Petrus novun Ia ma rdir-aling ira, beti ntabu Ia. ");
INSERT INTO frd_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Naꞌuk Yesus ndir-tamuri Ia, beti nfalak verin ia ne, “Nitdawan, muti vatuk oa tali ini! Afa ovi fwikir ra wol rtali Ubu, naꞌuk rtali watan tamata ra.” ");
INSERT INTO frd_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Tamata rivun rnaꞌa wan yai, ba Yesus nera ira ovu vali Ni tamata ra ma nfalak ne, “Tamata iki watan inan ma norang Yaꞌa, na ia musti nalak tenan a ovu nvara ni aa walwalur a. Notu wean inyai, beti bisma norang Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Tamata iki watan inan ma ntahang teri ni vavaꞌat i naꞌa lanit ivavan a, na ia veka wol ni vavaꞌat kakiwal a. Naꞌuk tamata iki watan nmata tevek norang Yaꞌa, ovu nfamalik Ubu Ni Ivar Lolin a, na ia veka ni vavaꞌat kakiwal a. ");
INSERT INTO frd_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Wean i tamata isa nasdovu munuk metan ovi rnaꞌa lanit ivavan a, naꞌuk wol ni vavaꞌat kakiwal, na ihin aka? ");
INSERT INTO frd_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ia ki nala aka ma al nkati vavaꞌat kakiwal? Wol nala akataka lahir! ");
INSERT INTO frd_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Fiang ini, mlyeal tamata sian ovi rafena ma rorang Yaꞌa, fruarira ra. Naꞌuk tamata iki watan nmaꞌit ma nfalak ne norang Yaꞌa, ovu wol ntorung afa ovi ufalak ra, na Yaꞌa, Tamata Yanan Yaꞌa, veka wol utorung vali tamata yai, naꞌut i uma ewal a ovu Yamang vanan i nfitik nyadat a, ovu vali Ubu Ni sansinir ovi rmerat urun tali lanit ratan.” ");
INSERT INTO frd_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ia ntafal ma nfalak verin ira ne, “Afa i ufalak verin mia ini, kena urun! Tali bir tinemun naꞌa wan ini, na boku wol rmata obin, naꞌut inyai, na ira veka rsiꞌik Ubu Ni Fareta nma ovu ngrebat!” ");
INSERT INTO frd_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ba amar inean nelak roak, na Yesus novun Petrus, Yakobus ovu Yohanes ma rvaꞌal vuar karatat isa, ma aksa ira watan naꞌa inyai. Ira rsiꞌik, na Yesus felan a naling roak ia. ");
INSERT INTO frd_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Afa ovi nung a neluk ra, rangiar urun ma rfitik-ryadat. Wol tamata isa naꞌa lanit ivavan a veka ntof nala ma ravit ra rangiar wean inyai. ");
INSERT INTO frd_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Brian munuk, na irtelu rsiꞌik, na nabi Elia ovu nabi Musa rvotuk ma rangrihi nulu Yesus. ");
INSERT INTO frd_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ba Petrus nfalak verin Ia ne, “Tuan Guru, lolin urun ma tnaꞌa wan ini. Ni lolin a amfadiri befak itelu, ma isa verin Oa, isa verin Musa, isa vali verin Elia.” ");
INSERT INTO frd_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Velik aba, Petrus wol nkaꞌa afa ovi nfalak ra, tevek irtelu rbobar urun, naꞌuk nangrihi watan wean inyai. ");
INSERT INTO frd_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Naꞌut inyai, na mutan isa nkum-teri ira, ovu rarenar vai isa ntali mutan ralan yai ne, “Ini Yaꞌa Yanak i ulobang urun Ia. Mryenar afa ovi nfalak ra!” ");
INSERT INTO frd_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Brian munuk, na rsiꞌik lilit wan yai, na wol tamata roak naꞌa inyai. Yesus aꞌuk saꞌi nanaꞌa inyai. ");
INSERT INTO frd_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Nata rsuta tali vuar ma rnaꞌa rira banbanan obin, na Yesus nsurak ira ne, “Deka fyamalik afa i mryea inlangin yai verin tamata ra veki. Mnyaban ma Ubu nfavaꞌat ewal Yaꞌa, Tamata Yanan Yaꞌa ini tali matmatan, beti fyamalik.” ");
INSERT INTO frd_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ira rot-orang Ni snurak yai, naꞌuk kaꞌi rsiforat ira naꞌa Yesus Ni afa i nfalak a ne, “Veka uvaꞌat ewal tali matmatan.” ");
INSERT INTO frd_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ba rorat Yesus ne, “Notu afakinimi Yahudi rira dawan ovi rair Musa ni inukun ra rfalak ne, Elia veka nma ula ia, beti Raja i ntevut mami salasilan ra?” ");
INSERT INTO frd_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesus nfalak ne, “Kena, Elia nma ula ia, boma nasusan afakataka munuk. Naꞌuk mia mkyaꞌa roak ne, rtulis naꞌa Surat Ralan ne, Yaꞌa, Tamata Yanan, veka utuan sian rivun ovu vali rangrihi visal-vasil Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ba ufalak verin mia ne, Elia nma roak, naꞌuk tamata ra kaꞌi rorang rira ininan ra ma rotu tia ma watan ia. Inyai kena lahir ovu vaivatul ovi lalan a rtulis roak naꞌa Surat Ralan a.” ");
INSERT INTO frd_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yesus, Petrus, Yakobus ovu Yohanes rtali vuar rsuta roak mane rasdovu ira ovu Yesus Ni tamata liak ovi rorang Ia. Ira rsiꞌik, na tamata rivun ilaꞌa rdir-lilit rira kida ra. Yahudi rira dawan ovi rair Musa ni inukun ra, boku rsingarahi ovu ira. ");
INSERT INTO frd_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ti ma tamata rivun avyai rsiꞌik Yesus, na rtalkaka munuk, ba rafla lahir rti ma rtuan Yesus. ");
INSERT INTO frd_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yesus norat ira ne, “Msyingarahi ovu ira naꞌa aka?” ");
INSERT INTO frd_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Tali tamata rivun avyai, na tamata isa nfalak verin Yesus ne, “Tuan Guru, yaꞌa ovun yanak a brana nma verin Oa ma motu ma lolin ia, tevek nait sian nleal ia ma notu ma nmanu. ");
INSERT INTO frd_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Wean i nait sian nlabir ia, na notu ma nvatuk tenan nsuta lanun, ovu vali bera faluvur ia, nifan ra rsitutu ira, ovu nablingu lahir. Era roak verin Mu tamata ovi rorang Oa ma raling vatuk nait sian yai, naꞌuk wol rot-nala.” ");
INSERT INTO frd_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ba Yesus nfalak verin Ni tamata ovi rorang Ia ne, “Wol bira inorang lahir! Amar ifira vali ma udoku ovu mia ma utahang nal ralang ovu mia, tamata ovi wol bira inorang a? Myovun kasikoꞌu yai mya ini!” ");
INSERT INTO frd_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ba rovun kasikoꞌu yai verin Yesus. Naꞌut i nait sian yai nrea Yesus, na notu lahir ma kasikoꞌu yai tenan a raruru lalean ia, ovu nleka ma nlawar ia naꞌa lanun, ovu vali bera faluvur ia. ");
INSERT INTO frd_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesus norat kasikoꞌu yai yaman a ne, “Nait sian ini nleal ia mnanat roak?” Yaman nfalak ne, “Tali ni kakoꞌu roak! ");
INSERT INTO frd_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Nait sian ini nleal ia ma nfaleka dalang ia naꞌa yafu ovu vali naꞌa wear mane nfedan ia. Ba wean i Oa bisma mlobang ia, na mlobang ma fwaturu Mu silobang verin ami!” ");
INSERT INTO frd_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesus nfalak ne, “Oa fwalak ne, wean i bis ot-nala? Tamata i norang Ubu ovu ralan urun veka not-nala afakataka munuk lahir!” ");
INSERT INTO frd_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Kasikoꞌu yai yaman nafwak lahir ne, “Yaꞌa orang, naꞌuk ning inorang a kakoꞌu obin, ba mlobang yaꞌa ma mtafal ning inorang verin Oa!” ");
INSERT INTO frd_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesus nsiꞌik, na tamata rivun rma roak, ba nfalak ne, “Hoi, nait sian oa, ovu motu tamata ra ma raktun ovu rmanu. Ufareta ma muti talik kasikoꞌu ini, ovu deka mewal kikyai oa ma mleal ia.” ");
INSERT INTO frd_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Nait sian yai nafwak ovu notu ma kasikoꞌu yai raruru lalean ia, ma nleka nsuta ntuba wean tamata matmatan roak, beti nait sian nti ntalik ia. Ba tamata rivun avyai rfalak ne, “Ia nmata roak.” ");
INSERT INTO frd_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Naꞌuk Yesus ntaha kasikoꞌu yai liman a ma nfadiri ia ma ndiri. ");
INSERT INTO frd_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Nata Yesus ovu Ni tamata ovi rorang Ia saꞌi rnaꞌa rahan, beti rorat Ia ne, “Afakinimi ami wol amaling nala nait sian yai?” ");
INSERT INTO frd_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yesus nfalak ne, “Nait sian i wean inyai, wol bisma milaꞌing ia, wean i wol miflurut.” ");
INSERT INTO frd_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ira rti talik wan yai ma rban-oli propinsi Galilea. Yesus nafena ma tamata ra rkaꞌa ne, ira rnaꞌa inyai, ");
INSERT INTO frd_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","tevek Ia nair Ni tamata ovi rorang Ia. Yesus nair ira ma nfalak ne, “Tamata ra veka rala Yaꞌa, Tamata Yanan Yaꞌa ini, verin tamata ra ma rfedan Yaꞌa, naꞌuk amar itelu nelak, na uvaꞌat ewal” ");
INSERT INTO frd_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Naꞌuk Yesus Ni tamata ovi rorang Ia wol rfan-aran afa ovi nfalak ra, ovu rbobar ma wol rorat Ia naꞌa afa avyai. ");
INSERT INTO frd_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Rewal ira rti Kapernaum, na rti rahan isa ralan a. Yesus norat ira ne, “Inlangin a naꞌa lingaꞌan, na vaibira naꞌa afaka?” ");
INSERT INTO frd_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Wol rfalak akataka verin Ia, boma deka nkaꞌa, tevek inlangin a rsitaku ulurira naꞌa rira fikiran ra ma rdava ne, iki dawan lia munuk tali ira. ");
INSERT INTO frd_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesus ndoku ma nera Ni tamata vutu rahin irua ma nfalak ne, “Iki mane dawan lia munuk ia, na nfakabava tenan veki ma neluk sansinir ovu nlobang tamata ra munuk.” ");
INSERT INTO frd_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Nata Yesus nala kasikoꞌu isa ma nfalak ma ndiri waharira ralan ra. Yesus nangabuk kasikoꞌu yai ma nfalak verin ira ne, ");
INSERT INTO frd_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Tamata iki watan nalang kasikoꞌu ra wean kasikoꞌu ini tevek narang a, na ia nalang roak Yaꞌa. Tamata iki watan nalang Yaꞌa, na wol nalang watan Yaꞌa, naꞌuk nalang roak Ubu i nsinir Yaꞌa.” ");
INSERT INTO frd_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yohanes nfalak verin Yesus ne, “Tuan Guru, ami amsiꞌik tamata isa nala naram a ma naling vatuk nait sian tali tamata, ba amtab-teri ia, tevek wol ntali mami sidovung.” ");
INSERT INTO frd_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yesus nfalak ne, “Deka mtyab-teri ia, tevek wol tamata isa bisma nala narang a ma notu mujizat, beti nangrihi lahir ma nfalak sian Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Tamata iki watan wol nangal ita, na ia nlobang roak ita. ");
INSERT INTO frd_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Afa i ufalak verin mia kena urun! Tamata iki watan nala wear gelas isa ma myenu tevek myorang Kristus, na Ubu veka naval ia naꞌa ni rala lolin a.” ");
INSERT INTO frd_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Naꞌuk tamata iki watan notu ma kasikoꞌu i norang Yaꞌa nleka ma notu salasilan, na Ubu veka nukun ia. Ni lolin a rkeak vatu dawan isa naꞌa relan a, ma relik ia naꞌa tahat ralan. ");
INSERT INTO frd_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Wean i limabira lihir notu ma myotu salasilan, na myetal vatuk ia. Ni lolin a, bira vavaꞌat kakiwal ovu Ubu, velik ne limabira lihir watan, tevek wol lolin lahir ma miti yafwan kakiwal ovu limabira irua.  ");
INSERT INTO frd_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Naꞌa wan yai yafu wol nmat-nala, ovu bwa ovi raꞌan matmatan ra wol rmat-nala vali. ");
INSERT INTO frd_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Wean i eabira lihir notu ma myotu salasilan, na myetal vatuk ia. Ni lolin a, bira vavaꞌat kakiwal ovu Ubu, velik ne eabira lihir watan, tevek wol lolin lahir ma miti yafwan kakiwal ovu eabira irua.  ");
INSERT INTO frd_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Naꞌa wan yai, na bwa ovi raꞌan matmatan ra wol rmat-nala ovu yafu wol nmat-nala vali. ");
INSERT INTO frd_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Wean i matabira lihir notu ma myotu salasilan, na mkyivul vatuk ia. Ni lolin a, ti mnyaꞌa Ubu Ni Fareta, velik ne matabira lihir watan, tevek wol lolin lahir ma nvatuk mia naꞌa yafwan kakiwal ovu matabira irua. ");
INSERT INTO frd_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Naꞌa wan yai, na yafu wol nmat-nala ovu bwa ovi raꞌan matmatan ra wol rmat-nala vali. ");
INSERT INTO frd_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Yafu veka notu ma tamata ovi rorang Ubu rmerat. ");
INSERT INTO frd_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Sira lolin, naꞌuk wean i wol sarsiran roak, na myotu wean inba ma sarsiran ewal? Fara bira vavaꞌat lolin, wean afamtahan ovi rtafal sira ma lanun. Deka vaibira naꞌa iki dawan lia munuk, ba msyiotu lolin watan mia, boma bira vavaꞌat ra malinan.” ");
INSERT INTO frd_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesus ndir-talik ahu Kapernaum ma nti Propinsi Yudea naꞌa oar Yordan ni lihir a. Tamata rivun rma ewal ma rdir-lilit Yesus ma nair ira, wean i baꞌi nsiair a. ");
INSERT INTO frd_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Tamata Farisi boku rma ma rlabir teman Ia, ma rorat Ia ne, “Naꞌa dida agama ni inukun ra, na brana i nsifa roak bisma ntalik awan te wahal?” ");
INSERT INTO frd_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ba Yesus norat ira ne, “Musa nfareta aka verin mia naꞌa ni inukun ra?” ");
INSERT INTO frd_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ira rfalak ne, “Musa ntorung verin brana ra ne, wean i brana isa mane ntalik awan a, na ia nasusan ni surat sitalik, beti nfasuka ia.” ");
INSERT INTO frd_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesus nfalak verin ira ne, “Musa nala ni inukun yai verin mia, tevek ralabira ra rangrebat daꞌin. ");
INSERT INTO frd_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Tevek naꞌut i Ubu notu lanit ivavan a, na Ia notu vali brana ovu vata. ");
INSERT INTO frd_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Wean inyai, bi brana veka nsuta talik renan ovu yaman a, ma irua awan a rleal isa. ");
INSERT INTO frd_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Vata irua brana ralarira isa ma ikisa watan ira. Ba irua ikisa watan roak. ");
INSERT INTO frd_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Wean inyai, bi Ubu notu roak ma irua rleal isa, ba tamata ra wol bis rotu ma rsitalik.” ");
INSERT INTO frd_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Nata Yesus ovu Ni tamata ovi rorang Ia rti rahan ralan ewal ma rorat Yesus naꞌa afa avyai. ");
INSERT INTO frd_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yesus nfalak ne, “Brana iki watan i ntalik awan a ma nsifa ewal ovu vata liak, na ia naflidan roak, ba notu sala roak verin awan lan a. ");
INSERT INTO frd_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Wean vali inyai verin vata ra. Vata iki watan i ntalik awan a ma nsifa ovu brana liak, na ia naflidan vali.” ");
INSERT INTO frd_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Tamata ra rovun yanarira rma verin Yesus, boma nfadoku liman naꞌa ira, naꞌuk Ni tamata ovi rorang Ia rangrova tamata avyai. ");
INSERT INTO frd_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesus nsiꞌik afa yai, na nangrova ma nfalak verin ira ne, “Msyiꞌik watan ma kasikoꞌu avyai rma ma rtuan Yaꞌa. Deka myotu teri ira, tevek tamata ovi wearira avyai, ira veka warira vali ovu Ubu naꞌa Ni Fareta a. ");
INSERT INTO frd_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Afa i ufalak verin mia ini, kena urun! Tamata iki watan wean i wol norang wean kasikoꞌu avyai ne, Ubu nfareta tamata ra wean lahir Raja, na ia veka wol wan naꞌa Ubu Ni Fareta a.” ");
INSERT INTO frd_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ba Yesus nangabuk kasikoꞌu avyai ovu nfadoku liman nanaꞌa ira ma naflahar ira. ");
INSERT INTO frd_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesus mane nti roak, na brana isa nafla nma ma nsangatur nulu Ia ma norat ne, “Tuan Guru, lolin Oa. Yaꞌa musti otu afaka, boma ning vavaꞌat kakiwal?” ");
INSERT INTO frd_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesus norat ia ne, “Afakinimi fwalak ne lolin Yaꞌa? Wol tamata isa vali lolin ia, Ubu aꞌuk saꞌi lolin Ia. ");
INSERT INTO frd_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Oa mkaꞌa munuk afa ovi Ubu nfareta roak verin ita. Deka msifedan, wean i msifa roak, na deka mtuba ovu tamata i wol awam verin ia, ovu deka bwori. Deka mdiri fareta waharira ralan ra ma msiklabir naꞌa afa ovi fwalak ra naꞌa tamata liak, deka fwaruki tamata liak ra ovu malang renam ovu yamam a.” ");
INSERT INTO frd_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Tamata yai nfalak ne, “Tuan Guru, yaꞌa ot-orang munuk roak afa avyai, tali naꞌut i ning kakoꞌu obin.” ");
INSERT INTO frd_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesus nsiꞌik, na nlobang ia ma nfalak ne, “Teran afa isa wol motu obin. Muti ma fwedi munuk mu metan ra, ma mtanang kubang avyai verin tamata kasian ra. Motu wean inyai, na veka mu metan naꞌa lanit ratan, beti mwa ma morang Yaꞌa.” ");
INSERT INTO frd_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ti ma nrenar afa i Yesus nfalak yai, na wahan aleman ma newal ia ovu ralan lalau, tevek ni metan rivun. ");
INSERT INTO frd_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesus nsiꞌik lilit Ni tamata ra, na nfalak verin ira ne, “Susa buas ma tamata ovi rkaꞌi ra rtorung ma Ubu nfareta ira wean lahir Raja!” ");
INSERT INTO frd_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Yesus Ni tamata ra rarenar Ni vaivatul ra, na rtalkaka. Ba Yesus nfalak ewal verin ira ne, “Baba averi, veka susa buas ma tamata ovi rkaꞌi ra rtorung ma Ubu nfareta ira wean lahir Raja. ");
INSERT INTO frd_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Susa ma afwatan dawan isa naran unta nuruk nala dirin ni bilahin a, naꞌuk susa lia munuk verin tamata ovi rkaꞌi a ma ti rnaꞌa Ubu Ni Fareta a.” ");
INSERT INTO frd_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Tamata ovi rorang Yesus rtalkaka lahir ma rsiforat ira ne, “Ba wean inyai, na iki veka ni vavaꞌat kakiwal?” ");
INSERT INTO frd_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesus nsiꞌik ira ma nfalak ne, “Tamata ra wol rot-nala lahir afa yai, naꞌuk wol wean inyai verin Ubu, tevek Ia bis not-nala munuk akataka.” ");
INSERT INTO frd_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Petrus nfalak verin Yesus ne, “Ami amban-talik roak mami afakataka munuk ma amorang Oa!” ");
INSERT INTO frd_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesus nfalak ne, “Afa i ufalak verin mia ini, kena urun! Tamata iki watan i nban-talik ni rahan teta a, aꞌan a warin ra, renan ovu yaman a, uran a yanan ra, te ni vaꞌi ra ma norang Yaꞌa ovu nfamalik Ubu Ni Ivar Lolin a, na ");
INSERT INTO frd_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","fiang ini Ubu veka nal-ewal ma ntafal ma faratut ni rahan teta, aꞌan a warin, uran a yanan ra, renan ra, ovu vali ni vaꞌi ra, naꞌuk veka rotu sian ia vali, tevek norang Yaꞌa. Naꞌuk amar ovi veka rma ini, na ia veka ni vavaꞌat kakiwal. ");
INSERT INTO frd_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Naꞌuk tamata rivun ovi fiang ini dawan ira ma rban-ulu verin tamata ra, ira veka rban-muri watan. Tamata ovi koꞌu watan ira fiang ini ma rban-muri, ira veka dawan ira ma rban-ulu verin tamata ra.” ");
INSERT INTO frd_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ira rvaꞌal rarata Yerusalem, na Yesus nbana ula Ia. Yesus Ni tamata ovi rorang Ia rtalkaka, ovu vali tamata ovi rban-orang ira rbobar. Ia nera Ni tamata vutu rahin irua ovi rorang Ia yai ma rti nelan kedan a, ma nfamalik verin ira naꞌa afa ovi tamata ra veka rotu verin Ia. ");
INSERT INTO frd_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Yesus nfalak ne, “Fiang ini mane tati Yerusalem, na Yaꞌa, Tamata Yanan Yaꞌa ini, veka rala Yaꞌa ti ma unaꞌa dawan mela falurut ra ovu dawan ovi rair Musa ni inukun ra limarira ralan ra. Ira veka rukun Yaꞌa ma umata, boma rala Yaꞌa verin tamata ovi wol Yahudi ra. ");
INSERT INTO frd_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Tamata avyai veka rlabir waweang Yaꞌa ovu rira vaivatul ra, rafnit Yaꞌa, rasveva Yaꞌa, beti rfedan Yaꞌa. Naꞌuk ti ma amar itelu nelak, na veka uvaꞌat ewal.” ");
INSERT INTO frd_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ba Zebedeus yanan ra, nararira Yakobus ovu Yohanes, ti rfaseri Yesus ma rfalak verin Ia ne, “Tuan Guru, fara fwakena watan afa i mane amera tali Oa.” ");
INSERT INTO frd_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ba Yesus norat ira ne, “Inabira ma otu afaka verin mia?” ");
INSERT INTO frd_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ira rfalak verin Yesus ne, “Naꞌut i mdoku naꞌa wam i mdoku ma fwareta naꞌa Mu Fareta i nfitik nyadat a, na fara mtorung ma amdoku Mu lihir mela ovu balit a.” ");
INSERT INTO frd_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesus nfalak verin ira ne, “Mia wol mkyaꞌa afa i myera tali Yaꞌa. Mtyahang nala ma rotu sian ovu rfedan mia wean i veka rotu sian ovu rfedan Yaꞌa?” ");
INSERT INTO frd_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ira rfalak ne, “Oꞌu, amtahang nala afa sian avyai.” Ba Yesus nfalak verin ira ne, “Mia fyalak kena ne, veka rotu sian ovu rfedan mia, wean i veka rotu sian ovu rfedan Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Yaꞌa wol bisma ufadoku ne, iki ndoku Ning lihir mela ovu balit a. Ubu aꞌuk saꞌi nfadoku ne, tamata aba veka rdoku ovu Yaꞌa.” ");
INSERT INTO frd_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Nata Yesus Ni tamata vutu rarenar afa ovi Yakobus irua Yohanes rfalak ra, ba rangrova ira. ");
INSERT INTO frd_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yesus nera munuk ira ma nfalak ne, “Mia mkyaꞌa roak ne, tamata ra rkaꞌa munuk tamata fareta ra ovu tamata dawan ovi wol rorang Ubu, ma rfareta tamata ra ovu limarira tmaꞌan. ");
INSERT INTO frd_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Naꞌuk mia deka weabira tamata avyai. Tamata iki inan ma ni dawan nlia tamata ra, na ia musti neluk tamata sansinir verin mia. ");
INSERT INTO frd_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Iki inan ma nlia munuk mia, na musti neluk tamata sansinir ma nkarya verin iki watan. ");
INSERT INTO frd_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ba Yaꞌa vali Tamata Yanan Yaꞌa, wol uma ma usinir tamata ra ma rlobang Yaꞌa, naꞌuk uma ma ulobang tamata ra, ovu ala tenang al ukvanak tamata rivun tali rira salasilan ra.” ");
INSERT INTO frd_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yesus ovu Ni tamata ovi rorang Ia raran Yerikho. Nata, ira ovu tamata rivun vali rti talik kota yai, na rtuan tamata kasian isa nkibu, naran Bartimeus, yaman a naran Timeus. Ia ndoku lingaꞌan nelan ma nera kubang tali tamata ra. ");
INSERT INTO frd_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ti ma nrenar ne, Yesus i ntali Nazaret nma inyai, na nafwak ne, “Yesus, Oa ubum-nusim Raja Daud. Fara fwaturu Mu silobang a verin yaꞌa!” ");
INSERT INTO frd_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Tamata rivun rtabu ia ma deka vain. Naꞌuk ia ntafal ma nafwak ilaꞌa ne, “Oa ubum-nusim Raja Daud. Fara fwaturu Mu silobang a verin yaꞌa!” ");
INSERT INTO frd_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Nata Yesus ndir-teri ma nfalak verin tamata ovi rnaꞌa inyai ne, “Eka myera ia ma nma ini.” Ba ira rfalak verin tamata kibu yai ne, “Kida, eka motu ma ralam a lolin ma mdiri, tevek Yesus nera oa.” ");
INSERT INTO frd_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ia naling ni ravit a blawat a ma ndiri lahir ma ti ntuan Yesus. ");
INSERT INTO frd_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesus norat ia ne, “Oa inam ma otu afaka verin oa?” Ba tamata kibu yai nfalak verin Ia ne, “Tuan Guru, yaꞌa inak ma usirea!” ");
INSERT INTO frd_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Nata, Yesus nfalak verin ia ne, “Mewal oa ta baba, tevek mu inorang verin Yaꞌa notu ma lolin roak oa!” Ba ia nsirea lahir ma norang Yesus naꞌa Ni banbanan. ");
INSERT INTO frd_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yesus ovu Ni tamata ovi rorang Ia ti rfaseri Yerusalem, na raran lan ahu Betfage ovu Betania. Ahu irua yai rnaꞌa vuar Zaitun. Ba Yesus nsinir tamata irua tali Ni tamata ovi rorang Ia ma rti ula ira. ");
INSERT INTO frd_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ia nfalak verin ira ne, “Miti ahu i naꞌa ulu eri. Ti myaran ahu eri, na veka mtyuan lahir keledai isa i wol kaꞌi dawan ia obin. Rkeak teri ia, ovu vali tamata ra wol rata rdoku tetan ratan obin. Mryuvat ni kakeak a ma fyabana ia mya. ");
INSERT INTO frd_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Beta ne tamata ra rorat mia ne, ‘Afakinimi mryuvat keledai yai ni kakeak a?’, na fyalak ne, ‘Duilaꞌa nperlu keledai yai, ovu wol mnanat, na veka rtaha ewal rma.’ ” ");
INSERT INTO frd_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Tamata irua yai rti ma rtuan keledai yai naꞌa lingaꞌan nelan. Tamata ra rkeak keledai yai naꞌa rahan isa ni falfolat a. Ba irua rti ma raruvat ni kakeak a, na ");
INSERT INTO frd_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","tamata ovi rdiri inyai rorat ira ne, “Afakinimi mryuvat keledai yai ni kakeak a?” ");
INSERT INTO frd_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Tamata irua yai rfalak wean afa ovi Yesus nfalak lan roak verin ira, ba tamata ovi rnaꞌa inyai rsiꞌik watan ma rfabana keledai yai rti. ");
INSERT INTO frd_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ba rfabana keledai yai rti verin Yesus, ovu rala rira ravit blawat ra ma al raraang tetan ratan a, ma Yesus rata ndoku. ");
INSERT INTO frd_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Tamata rivun rvelar rira ravit a blawat ra naꞌa lingaꞌan ralan, na boku vali rfadoku aa sanan tutul ovi retal naꞌa rira vaꞌi ra. ");
INSERT INTO frd_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Tamata ovi rbana ula ira ovu ovi rban-muri ra, rafwak ma vairira dawan ne, “Mya ma tfadawang Ubu! Ubu naflahar Ia i nma ovu Duilaꞌa naran a. ");
INSERT INTO frd_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ubu naflahar ita, tevek Ni fareta i veka nma ini lolin urun, wean i ubud a nusid Raja Daud nfareta! Ubu nanaꞌa wan i karatat lia munuk a, ba traning Ia!” ");
INSERT INTO frd_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesus naran roak Yerusalem ma nti Yahudi rira Rahan Dawan Falurut ralan a. Ia nsiꞌik lilit wan yai, na yaꞌi laflofan roak, ba nti Betania ovu Ni tamata vutu rahin irua ovi rorang Ia. ");
INSERT INTO frd_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ni ilyan ana, Yesus ovu Ni tamata ovi rorang Ia rban-talik Betania, na Yesus nfarnuang Ni balafar roak. ");
INSERT INTO frd_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Tali raroa obin, na nsiꞌik aa isa naran ara nafroang roak. Ba nti ma nsiꞌik aa yai al ndava ne, vuan te wahal, naꞌuk wol nrea vuan isa vali. Ia nrea watan aa yai roan ra, tevek wol naran amar i vuan obin. ");
INSERT INTO frd_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ba Yesus nfalak verin aa ara yai ne, “Tali amar ini, na tamata ra wol raꞌan roak vuam a!” Yesus Ni tamata ra rarenar munuk afa i nfalak a. ");
INSERT INTO frd_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Yesus ovu Ni tamata ovi rorang Ia rewal ira rti Yerusalem, na nti Yahudi rira Rahan Dawan Falurut ni lean a, ma nalaꞌing vatuk tamata ovi rfedi-rfaha afa naꞌa inyai, beti nir-nar tamata ovi rsikati kubang rira meja ra, ovu vali dakdokwan ovi tamata ra rdoku ma ala rfedi modarlaka. ");
INSERT INTO frd_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ia ntab-teri vali tamata ra ma deka rtaha afa ovi rfedi-rfaha ra, ma rahu Rahan Dawan Falurut ni lean a. ");
INSERT INTO frd_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Yesus notu wean inyai, beti nair tamata ovi rnaꞌa inyai. Ia nfalak verin ira ne, “Surat Ralan nfalak wean ini: ‘Ning rahan a neluk rahan falurut verin bangsa ra munuk naꞌa lanit ivavan,’ naꞌuk mia myotu ma neluk wan ma tamata barborin ra rnaꞌa.” ");
INSERT INTO frd_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Yahudi rira dawan mela falurut ra ovu dawan ovi rair Ubu Ni inukun ra rarenar vaivatul avyai, ba rdava lingaꞌan mane rfedan Yesus, tevek rbobar Ia. Rbobar Ia, tevek tamata rivun ovi rnaꞌa inyai rtalkaka, ovu inar urun ma rarenar afa ovi nfalak ra. ");
INSERT INTO frd_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Lera nakduvul ma laflofan roak, na Yesus ovu Ni tamata ovi rorang Ia rban-talik kota yai. ");
INSERT INTO frd_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Varverak sumatan obin, na Yesus ovu Ni tamata ovi rorang Ia rban-ewal rti Yerusalem ma raran aa ara yai. Aa yai nangaran munuk roak ma ti naran ni waꞌar ra. ");
INSERT INTO frd_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Petrus nangnanang ewal afa i Yesus nfalak lan roak verin ira naꞌa aa yai, ba nfalak verin Ia ne, “Tuan Guru, eka msiꞌik! Aa i inravin mear fwasoba yai nangaran munuk roak!” ");
INSERT INTO frd_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesus nfalak verin ira ne, “Myorang urun Ubu! ");
INSERT INTO frd_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Afa i ufalak verin mia ini, kena urun! Wean i tamata iki watan wol ralan raruan al norang Ubu, na ia veka nfalak verin vuar isa ne, ‘Mlaun talik wam kikyai ma roal mtuba tahat ralan!’, na vuar yai veka nlaun lahir ma roal ntuba tahat. ");
INSERT INTO frd_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Wean inyai, bi ufalak verin mia ne, wean i myorang ne, afa ovi myera tali Ubu naꞌa bira falurut ra, Ia nala roak verin mia, na Ia veka nala afa avyai verin mia. ");
INSERT INTO frd_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Naꞌut i miflurut, na wean i ralabira sian tamata isa, na myabun ia veki, boma Yamabira i nleal lanit ratan veka naꞌi vatuk vali bira salasilan ra.  ");
INSERT INTO frd_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Naꞌuk wean i wol myabun tamata ra, na Yamabira naꞌa lanit ratan veka wol naꞌi vatuk vali bira salasilan ra.” ");
INSERT INTO frd_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yesus ovu Ni tamata ovi rorang Ia rewal ira rma Yerusalem. Ia nbana naꞌa Yahudi rira Rahan Dawan Falurut ni lean a, na Yahudi rira dawan mela falurut ra ovu rira dawan ovi rair Musa ni inukun ra, ovu vali Yahudi rira dawan ra rma ma rtuan Ia, ");
INSERT INTO frd_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ma rorat ne, “Oa Mu ngrebat aka ma al motu afa ovi? Iki nala ngrebat yai verin Oa ma motu afa avyai?” ");
INSERT INTO frd_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesus nfalak ne, “Yaꞌa mane orat mia naꞌa afa isa, ba byalat Yaꞌa veki, beti ufalak vali verin mia ne, iki nala ngrebat verin Yaꞌa ma otu afa avyai. ");
INSERT INTO frd_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Yohanes nbaptis tamata ra ovu ngrebat tali iki? Ngrebat tali lanit ratan, te tali tamata? Eka fyalak kikyai!” ");
INSERT INTO frd_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ba rsifalak afa verin ira ne, “Wean i tfalak ne, ‘Yohanes ni ngrebat ntali lanit ratan,’ na Ia veka nfalak ne, ‘Notu afakinimi wol myorang ia?’ ");
INSERT INTO frd_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Naꞌuk susa vali ma tfalak ne, ‘Ngrebat tali tamata!’ ” Ira rbobar, tevek tamata rivun rorang roak ne, Yohanes nabi mngaꞌun ia. ");
INSERT INTO frd_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ba rfalak verin Yesus ne, “Ami wol amkaꞌa.” Yesus nfalak verin ira ne, “Ba wean inyai, na Yaꞌa veka wol ufalak vali verin mia ne, ala ngrebat tali iki ma otu afa avyai.” ");
INSERT INTO frd_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yesus nfamalik vaivatul kamkuma isa verin Yahudi rira dawan mela falurut ra, ovu dawan Yahudi ra, ntafal vali Yahudi rira dawan ovi rair Ubu Ni inukun ra. Ia nfalak ne, “Tamata isa notu ni vaꞌi anggur, na notu ngean ma nlilit ni vaꞌi a, ovu nkear wan isa ma al raramat anggur vuan ra naꞌa. Ia nfadiri sari isa felan a wean farwan ma rata rdoku al rwanar ni vaꞌi a. Notu munuk wean inyai, na nala verin tamata vaꞌi ra ma rasusan ni vaꞌi yai, ma ki rsiduk anggur boku verin ia. Nata nban-talik ni ahu ma nti wan raroa. ");
INSERT INTO frd_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ba ti naran roak ni amar i rfufu anggur vuan ra, na vaꞌi duan yai nsinir ni tamata sansinir isa ma ti nala ni wahat tali tamata ovi rwanar ni vaꞌi a. ");
INSERT INTO frd_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Naꞌuk tamata avyai rtaha tamata sansinir yai, ma rvaval ia, beti rsinir ma newal favu watan ia. ");
INSERT INTO frd_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ba vaꞌi duan yai nsinir ni tamata sansinir isa ewal ma nti, naꞌuk rvaval ma ulun a namngala, beti rfamaꞌit ia. ");
INSERT INTO frd_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Vaꞌi duan yai nsinir ni tamata sansinir isa ewal vali ma nti, naꞌuk rfedan ia. Ia nsinir tamata rivun ma sasan ira rti vali, naꞌuk rotu lalawatan ira wean inyai, ba rvaval boku ovu rfedan boku. ");
INSERT INTO frd_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Teran aꞌuk yanan a brana i nlobang urun ia. Ti nata nfalak ne, ‘Tamata avyai veka ralang yanak a,’ ba nsinir ia ma nti vali. ");
INSERT INTO frd_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Naꞌuk rsifalak afa verin ira ne, ‘Tamata ini vaꞌi duan yanan a brana, ba mya ma tfedan ia, boma tala vaꞌi ini verin ita.’ ");
INSERT INTO frd_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ba rtaha brana yai ma rfedan ia, ma ti rvatuk tenan a naꞌa vaꞌi yai murin a.” ");
INSERT INTO frd_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yesus norat ira ne, “Vaꞌi duan yai veka notu afaka? Ia veka nma ma nfedan tamata avyai, ma nala ni vaꞌi yai verin tamata liak. ");
INSERT INTO frd_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Mia wol byas obin vaivatul ovi rnaꞌa Surat Ralan a? Vaivatul avyai wean ini: ‘Vatu i tukan ra rvatuk yai, fyawan lia munuk ma al nfangrebat rahan yai. ");
INSERT INTO frd_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Afa i Duilaꞌa notu lolin urun, ovu notu ma tamata ra rtalkaka.’ ” ");
INSERT INTO frd_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ba tamata ovi rarenar vaivatul kamkuma yai rdava lingaꞌan mane rtaha Yesus, tevek rkaꞌa ne, Ia nala vaivatul kamkuma yai al ntaꞌing ira. Naꞌuk rbobar, tevek tamata rivun inar Yesus, ba rban-talik watan Ia. ");
INSERT INTO frd_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Tamata ovi rarenar vaivatul kamkuma yai rsinir tamata Farisi boku, ovu tamata boku vali ovi rorang Herodes ma rorat afa isa tali Yesus, boma rfaleka Ia naꞌa Ni vaivatul ra. ");
INSERT INTO frd_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ti ma rtuan Yesus, na rfalak ne, “Tuan Guru, ami amkaꞌa ne, afa ovi fwalak ra kena lalawatan. Oa wol fwili tamata, ovu wol mdava waham ralan, naꞌuk msiair ovu ni malolan a, wean Ubu ralan nfalak a, verin tamata ra. Ba, eka fwalak verin ami ne, dida agama nfalak ne, kena ma tbahir kulu verin Kaisar te wahal? Ba musti tbahir te wahal?” ");
INSERT INTO frd_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Yesus nkaꞌa rira siweang ra, ba nfalak verin ira ne, “Afakinimi mlyabir teman Yaꞌa? Eka myala bira kubang dinar isa ma usiꞌik.” ");
INSERT INTO frd_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Nata rala kubang dinar isa ma nsiꞌik, ba norat ira ne, “Tamata iki walun a ovu naran a naꞌa kubang ini?” Ira rfalak ne, “Kaisar.” ");
INSERT INTO frd_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ia nfalak ne, “Ba wean inyai, na myala verin Kaisar afa ovi Kaisar nia, ovu myala vali verin Ubu afa ovi Ubu Nia.” Ira rarenar afa ovi Yesus nfalak ra, na rtalkaka lahir. ");
INSERT INTO frd_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Tamata boku tali Yahudi rira sidovung isa naran Saduki rma ma rtuan Yesus. Tamata Saduki ra wol rorang ne, tamata matmatan ra veka rvaꞌat ewal. Ba rorat Ia ne, ");
INSERT INTO frd_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Tuan Guru, Musa ntulis inukun ini verin ita: Wean i brana isa nmata ma teran aꞌuk awan a, naꞌuk wol yanarira, na brana yai aꞌan te warin musti nala varu yai neluk awan, ma fara ia i nmata roak yai veka duan yanan boku. ");
INSERT INTO frd_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ba wean i brana ifitu iyaꞌan iwarin ira, ma iyaꞌan nsifa roak, naꞌuk wol yanan obin, na nmata. ");
INSERT INTO frd_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Nata warin nsifa vali ovu varu yai, naꞌuk wol yanar obin, na nmata. Ba brana i norang aꞌan i beti nmata yai nsifa vali ovu varu yai, nata wol yanar obin, na nmata vali. ");
INSERT INTO frd_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Warin i norang ia nsifa vali ovu varu yai, naꞌuk wol yanar obin, na nmata vali. Wean inyai lalawatan, nata ti naran iwarin tutul a. Ti nata vata yai nmata vali. ");
INSERT INTO frd_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ba wean inyai, na ti naran amar i tamata matmatan ra rvaꞌat ewal, na iki veka awan mngaꞌun vata yai, tevek brana ifitu yai awar munuk roak ia?” ");
INSERT INTO frd_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesus nfalak verin ira ne, “Mia sala ma dawan mia, tevek wol fyan-aran Surat Ralan a, ovu wol mkyaꞌa Ubu Ni ngrebat a! ");
INSERT INTO frd_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ba naꞌut i Ubu nfavaꞌat ewal tamata matmatan ra, na ira veka wol rsifa roak, naꞌuk rvaꞌat wean Ubu Ni sansinir ra naꞌa lanit ratan. ");
INSERT INTO frd_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Mia wol byas obin naꞌa Ubu Ni vaivatul ovi rfamalik naꞌa tamata ovi rmata roak, naꞌuk veka rvaꞌat ewal a? Ia ntulis naꞌa Surat Ralan ma nfamalik naꞌut i nsiꞌik yafu nonga naꞌa lavurun lesmat ralan. Ia ntulis ne, ‘Yaꞌa ini Ubu i Abraham, Ishak ovu Yakub baꞌi raraning a.’ ");
INSERT INTO frd_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ia wol neluk Ubu verin matmatan ra, naꞌuk neluk Ubu verin tamata ovi rvaꞌat ra. Ba bira afa ovi fyalak ra wol kena lahir.” ");
INSERT INTO frd_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Yahudi rira dawan isa i nair Musa ni inukun ra nma ma nrenar vali Yesus ovu tamata Saduki ra rsisoal ira. Ia nrenar Yesus Ni vaivatul ra kena munuk, ba norat Ia ne, “Inukun bi nlia munuk tali inukun ra?” ");
INSERT INTO frd_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesus nfalak ne, “Inukun i nlia inukun ra munuk wean ini: ‘Tamata Israel ra eka mryenar! Ubilaꞌa i traning a ikisa watan, ovu wol Ubu liak. ");
INSERT INTO frd_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Oa musti mlobang Duilaꞌa, mu Ubu i mraning a, ovu ralam urun. Mala munuk mu vavaꞌat a, mu kakaꞌa ra, ovu vali mu ngrebat ra verin Ia ma al mlobang Ia.’ ");
INSERT INTO frd_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Inukun isa vali i norang i ula lalean yai wean ini: ‘Oa musti mlobang vali tamata liak ra wean watan i mlobang tenam a.’ Inukun ra munuk wol verar lia inukun irua ini.” ");
INSERT INTO frd_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ba Yahudi rira dawan yai nfalak verin Yesus ne, “Tuan Guru, kena urun, tevek afa ovi fwalak ra rfaturu ne, Ubu ikisa watan, ovu vali wol Ubu liak. ");
INSERT INTO frd_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Tlobang Ubu ovu ralad urun, ovu tala munuk dida kakaꞌa ra ovu vali tala munuk dida ngrebat ra ma al tlobang Ia. Tlobang tamata liak wean i tlobang tenadida ra, na inyai lolin lia munuk tali dida afwatan ra, te dida korban liak ovi tala ma veka rasnuri ira verin Ubu.” ");
INSERT INTO frd_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesus nrenar dawan Yahudi yai ni vaivatul ra, na nkaꞌa ne, ni kakaꞌa dawan, ba nfalak verin ia ne, “Sarseri roak ma mnaꞌa Ubu Ni Fareta a.” Ba wol tamata isa vali nabrahi roak ma norat afa tali Yesus. ");
INSERT INTO frd_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Naꞌut i Yesus nsiair naꞌa Yahudi rira Rahan Dawan Falurut ni lean, na norat tamata ovi rnaꞌa inyai ne, “Wean inba ma dida dawan ovi rair Musa ni inukun ra bisma rfalak ne, Raja i ntevut tamata rira salasilan ra, Daud ubun-nusin Ia? ");
INSERT INTO frd_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ubu Ni Roh nleal Daud ralan a ma Daud nfalak ne, ‘Ubu nfalak verin ning Duilaꞌa ne: Mdoku Ning lihir mela a, ti naran i otu ma tamata ovi rira sian Oa rsoak nulu Oa.’ ");
INSERT INTO frd_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ba wean i Daud nfalak ne, Raja i ntevut tamata rira salasilan ra Duilaꞌa Ia, na wean inba ma Daud ubun-nusin Ia?” Tamata rivun ilaꞌa rnaꞌa inyai inar ma rarenar Yesus. ");
INSERT INTO frd_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesus nair ira ma nfalak ne, “Msyiꞌik wabira ma lolin naꞌa dawan ovi rair Musa ni inukun ra. Wean i rbasiar, na inar ma roru ravit blawat, ovu inar vali ma tamata ra ralang ira ma rala salam verin ira naꞌa wan i rfedi-rfaha afa naꞌa. ");
INSERT INTO frd_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ira inar ma rdoku wan ovi tamata ra baꞌi ralang ira naꞌa rahan falurut ra ovu vali naꞌa snoba ra. ");
INSERT INTO frd_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ira rlabir kual a moang watan vata varu ra ma rala rira rahan ra ovu rira metan liak ra. Rira falurut ra blawat urun ma al rteri rira afa sian ovi rotu ra. Ba wean inyai, na Ubu veka nukun ira ovu inukun i aleman urun, ma nlia tamata liak ra!” ");
INSERT INTO frd_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesus ti ndoku ma nfaseri wan i tamata ra baꞌi rfadoku rira kubang ra ma reluk rira persembahan verin Ubu, ma nsiꞌik tamata rivun rfadoku rira kubang ra. Tamata kaꞌi rivun rfadoku ma rira kubang dawan vali. ");
INSERT INTO frd_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Naꞌuk vata varu isa i ni kasian a dawan nma ma nala ni kubang ihin irua i fyawar koꞌu lean, ma ti nfadoku vali naꞌa wan yai. ");
INSERT INTO frd_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yesus nera Ni tamata ovi rorang Ia ma nfalak ne, “Afa i ufalak verin mia ini, kena urun! Vata varu i ni kasian a dawan ini, ni kubang i nfadoku naꞌa vatvatat i baꞌi rfadoku rira kubang ra verin Ubu, fyawan lia munuk kubang ovi tamata liak ra rala a. ");
INSERT INTO frd_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Tamata avyai munuk rala kubang dawan, tevek rira metan rivun, naꞌuk vata varu ini, nala munuk lahir ni kubang ovi nala al nvaꞌat a, velik ne ni kasian a dawan.” ");
INSERT INTO frd_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Naꞌut i Yesus mane nban-talik Yahudi rira Rahan Dawan Falurut a, na Ni tamata isa tali ovi rorang Ia nfalak ne, “Tuan Guru, Rahan Dawan Falurut ovu rahan ovi rdir-ebang Rahan Dawan Falurut felarira lolin buas! Eka msiꞌik lahir vatu dawan ovi rotu naꞌa rahan averi!” ");
INSERT INTO frd_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesus nfalak verin ia ne, “Oa msiꞌik roak rahan averi lolin buas. Ni amar veka nma ma vatu ovi rotu naꞌa rahan averi veka ramaꞌar munuk, ma wol teran vatu isa vali naꞌa wan a.” ");
INSERT INTO frd_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesus ovu Ni tamata ovi rorang Ia rti vuar Zaitun, na ndoku ma wahan nti Yahudi rira Rahan Dawan Falurut a. Ba Petrus, Yakobus, Yohanes, ovu vali Andreas rti ma rorat aling afa tali Ia. ");
INSERT INTO frd_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Rorat Ia ne, “Bapa, amera ma fwalak verin ami ne, naꞌut inba na afa ovi beti fwalak yai veka rvotuk? Faneak aka veka nvotuk ma nfaturu ne, afa avyai munuk veka rvotuk?” ");
INSERT INTO frd_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ba Yesus nfalak verin ira ne, “Msyiꞌik wabira ma lolin, boma tamata ra deka rlabir nala mia! ");
INSERT INTO frd_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Tamata rivun veka rma ma rala narang a, ma lokat ira kaꞌi rfalak ne, ‘Yaꞌa Raja i ntevut bira salasilan ra.’ Ira veka rlabir nala tamata rivun. ");
INSERT INTO frd_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Naꞌut i mryenar tamata ra rotu rihi, ovu ivar ne rihi ra rvotuk, na deka byobar. Afa avyai munuk musti rvotuk lan veki, naꞌuk lanit ivavan a wol namwear obin. ");
INSERT INTO frd_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Bangsa isa veka notu rihi ovu bangsa liak. Fareta dawan isa veka notu rihi ovu fareta dawan liak. Naꞌa lanit ivavan a, na veka ruru ovu lafar dawan naꞌa wan rivun. Afa avyai munuk reluk faneak ne, susa ra beti rvotuk. Wawaꞌuk ovi naꞌa amar avyai wean wawaꞌuk i vata ovi mane rarali ira rfarnuang a. ");
INSERT INTO frd_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Naꞌuk msyiꞌik wabira ma lolin! Tamata ovi rangal mia veka rtaha mia ma rovun mia ti verin tamata dawan ovi rfaleka inukun verin tamata ra, ma rvaval mia naꞌa rahan falurut ra. Ira veka rala mia ma ti mdyiri raja ra ovu dawan fareta waharira ralan ra, tevek myorang Yaꞌa. Naꞌut inyai vali, na mia veka fyamalik Yaꞌa verin ira. ");
INSERT INTO frd_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Tamata ovi rorang Yaꞌa veka rfamalik lan Ubu Ni Ivar Lolin verin tamata ra munuk. ");
INSERT INTO frd_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Wean i rtaha mia ti verin tamata ovi rukun tamata ra, na deka ralabira ra kakoꞌu ma mingrihi nulu ira. Ba ti naran ni amar a, na fyalak watan afa ovi Ubu veka nfadoku naꞌa ralabira ra, tevek afa ovi fyalak ra wol rtali mia, naꞌuk rtali Ubu Ni Roh. ");
INSERT INTO frd_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Naꞌut inyai, na tamata ra veka rsifedi-sikual ira. Ira veka rfedi aꞌarir-waririra ra ma tamata ra rfedan ira. Brana ra rotu vali wean inyai, ma veka rfedi yanarira ra, ovu vali tamata yanarira ra veka rangal renarir-yamarira ra ma rala ira ti verin tamata ra ma rfedan ira. ");
INSERT INTO frd_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Tamata ra munuk veka wol inar lahir mia, tevek myorang Yaꞌa. Naꞌuk tamata ovi rorang Yaꞌa ovu ralarira urun ma ti naran i rmata, na veka rira vavaꞌat kakiwal.” ");
INSERT INTO frd_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Ni amar veka nma ma msyiꞌik afa isa i sian urun ndiri wan isa i wol inovan ma nanaꞌa, ma nfangra ia (Mia tamata ovi byas ini, eka msyiꞌik ma lolin, boma fyan-aran vaivatul ovi). Tamata ovi rnaꞌa Propinsi Yudea musti rafla talik wan yai ma rti vuar ra. ");
INSERT INTO frd_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Tamata ovi ryari ira naꞌa rira rahan ratan ra, deka rsuta ma rala rira afa ovi rnaꞌa rira rahan ralan. ");
INSERT INTO frd_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Tamata ovi rkarya naꞌa rira vaꞌi ra deka rewal ira rma rira rahan ra ma rala rira kadaravit ra. ");
INSERT INTO frd_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Naꞌut inyai, na sian urun i lahir verin vata ovi rbarlewan ra ovu vata ovi rsusu kasikoꞌu yanat ra. ");
INSERT INTO frd_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Miflurut verin Ubu, boma deka mtyuan afa avyai naꞌut i daꞌut ovu radridin a. ");
INSERT INTO frd_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Amar ovi veka rma yai, na tamata ra veka rtuan susa dawan urun. Tali amar i Ubu beti notu lanit ivavan a, ma naran amar ini, na tamata ra wol rtuan susa i wean inyai obin. Tamata ra veka wol rtuan roak susa i wean inyai. ");
INSERT INTO frd_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Wean i Duilaꞌa wol nfaketa amar avyai, na veka wol tamata isa nvaꞌat vali. Naꞌuk Duilaꞌa nlobang Ni tamata ovi nfili ra, ba veka nfaketa amar avyai. ");
INSERT INTO frd_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Naꞌut inyai, na wean i tamata ra rfalak verin mia ne, ‘Eka msyiꞌik, Raja i ntevut dida salasilan ra nma roak ma nanaꞌa ini te nanaꞌa ineri!’ naꞌuk deka myorang ira. ");
INSERT INTO frd_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Tevek naꞌut inyai, na tamata boku veka rsiklabir ma rfalak ne, ira Raja i ntevut bira salasilan ra, ovu rfalak vali ne, nabi ira. Ira veka rotu faneak ovi wol tfikir aran ra, ovu mujizat ra ma rlabir tamata ra, boma tamata ra ranovak ne, rira ngrebat a ntali Ubu. Ba wean i bisma rlabir nala vali tamata ovi nfili ra, na veka rlabir ira. ");
INSERT INTO frd_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ba msyiꞌik wabira ma lolin! Ufalak lan roak afa avyai munuk verin mia.” ");
INSERT INTO frd_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Naꞌut inyai, na susa dawan avyai rlia roak, na lera veka wol vanan ovu vulan wol nyeba vali. ");
INSERT INTO frd_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Nara ra veka rleka tali lanit rsuta. Ngrebat ovi rnaꞌa lanit veka rarwaꞌung ma rasmoang tia ma watan ira. ");
INSERT INTO frd_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Naꞌut inyai, na tamata ra veka rsiꞌik Yaꞌa, Tamata Yanan Yaꞌa ini, unaꞌa mutan ra uma ovu Ning ngrebat dawan a, ovu vali vanang i nfitik nyadat. ");
INSERT INTO frd_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Yaꞌa veka ufareta Ning sansinir ra tali lanit ratan ma rti rasdovu tamata ovi Ubu nfili roak ira ma rorang Yaꞌa. Tamata ovi Ubu nfili ra rtali munuk tamata ovi rnaꞌa lanit ivavan; boku rtali varat, timur, marmar, ovu vali tranan, ma ti naran lanit ni wahan a.” ");
INSERT INTO frd_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Eka myair tali aa i rfanara ia ne ara. Wean i anan ra raftuvul ewal ma rafroang, na inyai neluk faneak verin mia ne, lera dawan sarseri roak. ");
INSERT INTO frd_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Wean i mryea roak afa avyai, na veka mkyaꞌa lahir ne, sarseri roak ma uma ewal. ");
INSERT INTO frd_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Afa i ufalak verin mia ini, kena urun! Tamata ovi rvaꞌat fiang ini veka wol rmata munuk obin, na afa avyai munuk rvotuk roak. ");
INSERT INTO frd_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Lanit ovu afa ovi rnaꞌa lanit ivavan veka ramwear, naꞌuk Ning vaivatul ra rnaꞌa kakiwal watan.” ");
INSERT INTO frd_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Wol tamata isa vali nkaꞌa ne, lafira ki amar i ufalak yai nma. Ubu Ni sansinir ovi rtali lanit ratan wol rkaꞌa. Yaꞌa Ubu Yanan ini wol ukaꞌa vali. Yamang aꞌuk saꞌi nkaꞌa. ");
INSERT INTO frd_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ba msyiꞌik wabira ma lolin, tevek wol mkyaꞌa ne, veka ewal Yaꞌa naꞌut inba. ");
INSERT INTO frd_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Yaꞌa veka uma ewal, wean tamata i nti talik ni rahan ma nobal. Wol nti obin, na nasdovu ni tamata sansinir ra ma nala karya lokat ira ma rasusan ni rahan. Ia nfalak verin ni tamata sansinir i nwanar falfolat ngoran a ma nsiꞌik ma lolin wan yai. ");
INSERT INTO frd_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ba wean inyai, na msyiꞌik wabira ma lolin, tevek mia wol mkyaꞌa ne, rahan duan yai lafira ki newal ia. Wol mkyaꞌa ne, nma naꞌut i lera nakduvul ma laflofan roak, te nafafruan tenan, te manut ra vair, te varverak sumatan. ");
INSERT INTO frd_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Wean i brian munuk, na ewal Yaꞌa ma utuan mia, na deka mtyub-lia. ");
INSERT INTO frd_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Afa ovi ufalak verin mia ini, ufalak vali verin tamata ra munuk ne: msyiꞌik wabira ma lolin!” ");
INSERT INTO frd_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Amar irua ewal, beti tamata Yahudi rotu rira snoba Paskah, ovu rotu rira snoba ma raꞌan roti i wol rfadoku ragi naꞌa. Yahudi rira dawan mela falurut ra ovu rira dawan ovi rair Musa ni inukun ra rdava lingaꞌan mane rtaha fanfonak Yesus ma rfedan Ia. ");
INSERT INTO frd_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ira rfalak ne, “Naꞌut i snoba nbana obin, na deka tataha Ia, beta ne tamata rivun vangoa-vanga.” ");
INSERT INTO frd_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesus ndoku Simon ni rahan naꞌa ahu Betania. Simon ini lan a ni suhut ngabaa. Yesus ndoku nafnaꞌan, na vata isa nma ma ntuan Ia. Vata yai ntaha botal koꞌu isa i rotu tali vatu lolin isa naran pualam. Botal yai nsaꞌa ngul i voan a lolin urun ovu fyawan urun, naran narwastu. Ba nfefar botal yai relan a, ma nliꞌi ngul yai naꞌa Yesus ulun. ");
INSERT INTO frd_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Tamata ovi rnaꞌa inyai boku rangrova ma rsifalak afa verin ira ne, “Notu afakinimi nawahak watan ngul i voan lolin yai? ");
INSERT INTO frd_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ngul yai fyawan urun, ba bisma tfedi, na fyawan a dinar ratut itelu teran, ma tala kubang a verin tamata kasian ra.” Ba rfasala ma dawan vata yai. ");
INSERT INTO frd_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Naꞌuk Yesus nfalak ne, “Deka fyalak teri ia! Afakinimi fyasala ia? Afa i notu verin Yaꞌa lolin urun. ");
INSERT INTO frd_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Tamata kasian ra rnaꞌa lalawatan ovu mia, ba naꞌut inba watan bisma mlyobang ira. Naꞌuk Yaꞌa wol mane unaꞌa lalawatan ovu mia. ");
INSERT INTO frd_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Vata ini not-nala roak afa ovi bis notu verin Yaꞌa. Wol naran amar i umata obin, na ia nliꞌi lan roak ngul voan lolin a naꞌa tenang a. ");
INSERT INTO frd_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Afa i ufalak verin mia ini, kena urun! Naꞌa wan inba watan rfamalik Ubu Ni Ivar Lolin naꞌa lanit ivavan a, na veka rfamalik vali afa i vata ini notu roak a, ma al rangnanang ia.” ");
INSERT INTO frd_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Tamata isa tali Yesus Ni tamata vutu rahin irua ovi rorang Ia, naran Yudas Iskariot. Ia ti ntuan Yahudi rira dawan mela falurut ra, boma nfedi Yesus verin ira. ");
INSERT INTO frd_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Rarenar afa i Yudas nfalak yai, na inar urun, ba rtorung ma veka rala kubang verin ia. Ba ndava amar kena mane nfedi Yesus. ");
INSERT INTO frd_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Naꞌa amar i nban-ulu naꞌa tamata Yahudi rira snoba ma raꞌan roti wol rfadoku ragi naꞌa, na tamata ra rfedan domba Paskah ra. Yesus Ni tamata ra rorat Ia ne, “Bapa, inam ma amati ma amasusan dida fanaꞌan Paskah naꞌa inba?” ");
INSERT INTO frd_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ba Yesus nsinir Ni tamata irua tali ovi rorang Ia, ma nfalak verin ira ne, “Miti kota ralan, na veka mtyuan brana isa ntaha suran isa nsaꞌa roak wear, ba byan-orang ia. ");
INSERT INTO frd_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ti myaran rahan i veka nwelat yai, na fyalak verin rahan duan yai ne, ‘Tuan Guru norat ne: Wan i misusan roak ma veka ufnaꞌan Paskah ovu Ning tamata ovi rorang Yaꞌa, naꞌa inba?’ ");
INSERT INTO frd_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Rahan duan yai veka nfaturu verin mia kamar dawan i nanaꞌa ratan a, naꞌa ni rahan yai. Ira rasusan munuk roak kamar yai, ba mia musti misusan watan afamtahan Paskah verin ita.” ");
INSERT INTO frd_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Yesus nfalak munuk wean inyai, beti irua rti kota yai. Ira rti ma rtuan munuk afa avyai wean lahir i Yesus nfalak roak a. Nata rasusan afamtahan Paskah yai. ");
INSERT INTO frd_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ti ma ovan roak, na Yesus nma ovu Ni tamata vutu rahin irua. ");
INSERT INTO frd_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Rdoku rafnaꞌan obin, na Yesus nfalak ne, “Afa i ufalak verin mia ini, kena urun! Tali ovi tafnaꞌan ini, na tamata isa veka nfedi Yaꞌa.” ");
INSERT INTO frd_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Rarenar munuk afa i Yesus nfalak yai, na ralarira lalau urun. Ba rsikati ira al rfalak verin Yesus ne, “Duilaꞌa, yaꞌa wahal!” ");
INSERT INTO frd_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesus nfalak ne, “Tamata isa tali mia vutu rahin irua ini mane nfedi Yaꞌa. Tamata yai amrua amsovu roti naꞌa moko isa. ");
INSERT INTO frd_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Yaꞌa, Tamata Yanan Yaꞌa, veka umata wean i rfalak roak naꞌa Ubu Ni Surat Ralan a. Naꞌuk sian urun i lahir verin tamata i nfedi Yaꞌa! Ni lolin a, tamata yai deka rarali lahir ia!” ");
INSERT INTO frd_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Yesus ovu Ni tamata ra rafnaꞌan obin, na nala roti a ma nfalak fara weninyai verin Ubu, beti nvisul roti yai ma nsiduk verin ira. Ia nfalak ne, “Myala ma mian kikyai, ini Yaꞌa tenang a.” ");
INSERT INTO frd_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Nata Yesus nala vali kobi i nsaꞌa anggur a ma nfalak fara weninyai verin Ubu, beti nala ma irmunuk renu tali kobi yai. ");
INSERT INTO frd_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ia nfalak verin ira ne, “Ini Yaꞌa larang i nvoat verin tamata rivun ma neluk faneak ne, Ubu nfakena roak Ni tnorung a. ");
INSERT INTO frd_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Afa i ufalak verin mia, kena urun! Yaꞌa veka wol enu roak anggur ini, ti naran amar i veka enu ewal anggur ngorvaꞌan naꞌa Ubu Ni Fareta.” ");
INSERT INTO frd_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ira rdedang ma rfadawang roak Ubu, beti rarata vuar Zaitun. ");
INSERT INTO frd_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesus nfalak verin ira ne, “Bira inorang a veka wol nangrebat ma mifla talik Yaꞌa, tevek rtulis roak naꞌa Surat Ralan ne, ‘Yaꞌa veka ufedan domba duan a, ba domba ra veka rlilin watan.’ ");
INSERT INTO frd_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Naꞌuk Ubu veka nfavaꞌat ewal Yaꞌa tali matmatan, ba veka ula Yaꞌa uti Galilea.” ");
INSERT INTO frd_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Petrus nfalak verin Yesus ne, “Velik ne ira munuk rira inorang wol nangrebat ma rafla talik Oa, naꞌuk yaꞌa wahal.” ");
INSERT INTO frd_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ba Yesus nfalak verin ia ne, “Afa i ufalak verin oa ini, kena urun! Ovan ini lahir, manut wol nkukuwai farua obin, na veka malak nala fatelu roak ne, wol mkaꞌa Yaꞌa.” ");
INSERT INTO frd_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Naꞌuk Petrus nfangrebat ralan a, ma nfalak ewal verin Yesus ne, “Velik ne musti umata vali ovu Oa, naꞌuk wol alak yaꞌa ne, wol ukaꞌa Oa.” Yesus Ni tamata liak ra munuk rfalak vali wean i nfalak a. ");
INSERT INTO frd_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Yesus ovu Ni tamata ovi rorang Ia rbana ma raran vaꞌi isa naran Getsemani. Ia nfalak verin ira ne, “Mdyoku ini ma ti uflurut veki.” ");
INSERT INTO frd_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ba Yesus ti naflurut, na novun vali Petrus, Yakobus, ovu Yohanes. Yesus ralan lalau urun Ia ovu wol malinan. ");
INSERT INTO frd_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ba nfalak verin ira ne, “Ralang a lalau urun i lahir, wean i ufarnuang ne, mane umata roak. Mnyaꞌa ini veki ovu msyiꞌik wabira ma lolin!” ");
INSERT INTO frd_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Yesus nbana ma yaꞌi nfaroa kedan tali ira, beti nsangatur naꞌa lanun ma naflurut. Ia nera verin Ubu ma fara ntorung ma susa i dawan urun deka nkena Ia. ");
INSERT INTO frd_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ia nfalak ne, “Bapa, o Bapa! Oa mot-nala akataka munuk, ba fara fwaroa susa i dawan urun ini tali Yaꞌa. Naꞌuk deka wean i ralang nfalak a, ba wean watan i ralam nfalak a.” ");
INSERT INTO frd_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Naflurut munuk ma newal Ia, na Ni tamata itelu i rfatuang Ia yai rtub-lufa roak. Ba Yesus nfalak verin Simon Petrus ne, “Simon, afakinimi mtub-lufa i? Wol mtahang nala jam isa vali ma msiꞌik wam ma lolin. ");
INSERT INTO frd_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Msyiꞌik wabira ma lolin ovu miflurut, boma nitdawan deka nlabir nala mia ma myotu salasilan. Ralabira rfalak ma myotu afa lolin, naꞌuk wol myot-nala, tevek tenabira ra rmafun.” ");
INSERT INTO frd_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Nata Yesus nti ewal vali ma naflurut, ma nfalak wean i inlangin nfalak roak a. ");
INSERT INTO frd_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ti ma naflurut munuk ma newal Ia, na ira rtub-ewal, tevek matarira ra raswosu daꞌin roak, ovu wol rkaꞌa ne, mane rfalak aka verin Yesus. ");
INSERT INTO frd_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Yesus newal fatelu Ia roak, ba nfalak verin ira ne, “Afakinimi mtyuba watan obin? Naran roak ni amar, ba deka mtyuba kikyai! Tevek tamata ovi mane rtaha Yaꞌa, Tamata Yanan Yaꞌa, rma roak. Ira mane rovun Yaꞌa ti verin tamata salasilan ra. ");
INSERT INTO frd_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Byatar ma tati kikyai. Eka msyiꞌik! Tamata i mane nfedi Yaꞌa nma ma sarseri roak!” ");
INSERT INTO frd_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Naꞌut i Yesus nangrihi obin, na brian munuk Yudas i ntali Ni tamata vutu rahin irua yai nma. Tamata rivun ovi rtaha nahin blawat ovu rira navnaval ra rban-orang vali ia. Yahudi rira dawan mela falurut ra ovu rira dawan ovi rair Ubu Ni inukun ra, ntafal vali dawan Yahudi liak ra rsinir ira ma rti inyai. ");
INSERT INTO frd_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yudas i nfedi Yesus nfalak lan roak verin tamata rivun avyai ne, veka notu faneak. Faneak yai wean ini: “Tamata i uvoan Ia yai, Ia hi inyai i. Ba mtyaha lahir Ia ma myovun Ia ovu msyiꞌik ma lolin Ia.” ");
INSERT INTO frd_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ba ti nfaseri lahir Yesus ma nfalak verin Ia ne, “Oo Tuan Guru.” Nata nvoan Ia. ");
INSERT INTO frd_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ba tamata avyai rti rtaha lahir Yesus. ");
INSERT INTO frd_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Naꞌuk tamata isa i ndiri wan yai ntavar ni nahin blawat, ma nafat vatuk Yahudi rira Mela Falurut Ilaꞌa ni tamata sansinir arun a. ");
INSERT INTO frd_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ba Yesus nfalak verin ira ne, “Mia beta myarin ne, Yaꞌa ini wean tamata ktufan i nwi-nwa tamata ra ma nbori rira metan ra, bi mya mtyaha nahin blawat ovu navnaval ra ma mtyaha Yaꞌa? ");
INSERT INTO frd_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Lokat amar, na itmunuk tnaꞌa dida Rahan Dawan Falurut ma usiair, na wol mtyaha Yaꞌa. Naꞌuk wean urun ini, boma nfakena lahir afa ovi rtulis roak naꞌa Surat Ralan a.” ");
INSERT INTO frd_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Nata Ni tamata ra munuk rafla talik Ia. ");
INSERT INTO frd_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Varverun isa norang Yesus ovu neluk watan maloli etal isa al nteri tenan a. Ba ti mane rtaha ia, ");
INSERT INTO frd_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","naꞌuk nafla, ba raravut vatuk ni maloli etal yai ma nafla faluhu ia watan. ");
INSERT INTO frd_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Tamata ovi beti rtaha Yesus rovun Ia rti Yahudi rira Mela Falurut Ilaꞌa ni rahan a. Naꞌa inyai, na Yahudi rira dawan mela falurut ra ovu dawan Yahudi ra ntafal vali Yahudi rira dawan ovi rair Ubu Ni inukun ra munuk rasdovu ira. ");
INSERT INTO frd_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Petrus nban-orang Yesus tali raroa watan, ma ti naran Mela Falurut Ilaꞌa ni lean a. Nanaꞌa inyai, na ia ndoku ma nafraran ovu tamata ovi rwanar Yahudi rira Rahan Dawan Falurut. ");
INSERT INTO frd_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Dawan Mela Falurut ra ovu dawan fareta Yahudi ovi rdoku naꞌa rira sidovung dawan rkiwal mane rkaꞌa Yesus Ni sala ra, boma rukun Ia ma nmata. Naꞌuk wol rtuan Ni sala isa vali, ");
INSERT INTO frd_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","tevek tamata rivun ovi rfalak sian Yesus rsiklabir watan. Afa ovi rfalak ra rfarsangal tia ma watan, ba rira afa ovi rfalak ra wol wer isa. ");
INSERT INTO frd_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Nata tamata boku rdiri ma rsiklabir ma al rfasala Yesus. ");
INSERT INTO frd_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Ira rfalak ne, “Ami amrenar, na Ia nfalak ne, ‘Yaꞌa veka aꞌar vatuk dida Rahan Dawan Falurut i tamata ra rotu ini, ma naꞌa amar itelu watan, na ufadiri liak ewal, naꞌuk tamata ra wol rotu.’ ” ");
INSERT INTO frd_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Naꞌuk afa ovi rfalak ra rfarsangal tia ma watan, ba rira afa ovi rfalak ra wol wer isa. ");
INSERT INTO frd_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ba Mela Falurut Ilaꞌa ndiri waharira ralan ra, ma norat Yesus ne, “Notu afakinimi wol mlotar tenam a, ma fwalak naꞌa afa ovi tamata avyai rfalak a?” ");
INSERT INTO frd_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Naꞌuk Yesus wol vain ovu Ia wol nvalat akataka. Ba Mela Falurut Ilaꞌa yai norat ewal Ia ne, “Oa ini Raja i veka mtevut tamata ra rira salasilan ra? Ubu i tamata raraning a, Yanan Oa?” ");
INSERT INTO frd_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesus ntorung ma nfalak ne, “Kena lahir, ini Yaꞌa. Mia veka msyiꞌik Yaꞌa, Tamata Yanan Yaꞌa ini, udoku Ubu i nfareta munuk afakataka Ni lihir mela, ovu veka utali lanit ma unaꞌa mutan ra uma.” ");
INSERT INTO frd_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","64","Ba Mela Falurut Ilaꞌa nangrova urun ma nkamadir ni ravit blawat a ma nfalak ne, “Mia kaꞌi mryenar Ia nfalak sian Ubu, tevek nfalak ne, Ia wean lahir Ubu. Wol tperlu ma tdava tamata liak roak ma rfalak ni sala ra. Ba minovak wean inba?” Ira ralar isa ma rfadoku ne, Ia musti nmata. ");
INSERT INTO frd_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ba tamata boku rafnit Yesus, ovu rkeak teri matan a. Ira raskevu tia ma watan Ia, beti rorat Ia ne, “Nabi Oa, ba eka fwalak ne, inlangin a iki naskevu Oa!” Nata tamata ovi rwanar Rahan Dawan Falurut a rovun Yesus rti ma rvaval Ia. ");
INSERT INTO frd_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Amar yai, na Petrus nanaꞌa lean obin. Mela Falurut Ilaꞌa ni vata sansinir isa nma wan yai. ");
INSERT INTO frd_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ti ma nrea Petrus nafraran naꞌa yafu, na nsiꞌik ma lolin wahan a, ma nfalak ne, “Oa baꞌi morang vali Yesus, tamata Nazaret eri.” ");
INSERT INTO frd_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Naꞌuk Petrus nalak watan ia, ma nfalak ne, “Yaꞌa wol ukaꞌa afa i fwalak yai.” Ba ti naran tembok dawan ni falfolat ngoran a, na manut isa nkukuwai vali. ");
INSERT INTO frd_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Vata sansinir yai nrea ewal ia ma nfalak verin tamata ovi rnaꞌa inyai ne, “Tamata yai norang vali Yesus!” ");
INSERT INTO frd_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Naꞌuk Petrus nalak ewal vali ia. Ba wol mnanat, na tamata ovi rafraran naꞌa yafu yai rfalak ewal verin Petrus ne, “Amkaꞌa lahir ne, oa morang vali Ia, tevek mtali Galilea vali!” ");
INSERT INTO frd_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ba Petrus nalak matmatan watan ia, ma kaꞌi nafwaba tenan a ma nfalak ne, “Yaꞌa wol ukaꞌa tamata i fyalak yai!” ");
INSERT INTO frd_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Brian munuk, na manut nkukuwai ewal. Ba Petrus nangnanang nal-ewal vaivatul ovi Yesus nfalak lan roak verin ia ne, “Manut wol nkukuwai farua obin, na oa veka malak nala fatelu roak ne, wol mkaꞌa Yaꞌa.” Ba Petrus nvakar ma naꞌa samsekur. ");
INSERT INTO frd_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Varverak sumatan, na Yahudi rira dawan ra rasdovu munuk ira naꞌa rira sidovung dawan. Yahudi rira dawan avyai rtali dawan mela falurut ra, dawan Yahudi ra, Yahudi rira dawan ovi rair Musa ni inukun ra, ovu rira dawan liak ra vali. Ira ranovak ma raꞌan vai isa naꞌa afa ovi mane rotu verin Yesus. Ba rkeak Yesus, beti rovun Ia rti verin Pilatus. ");
INSERT INTO frd_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilatus norat Ia ne, “Yahudi rira raja verin Oa?” Yesus nfalak ne, “Oa kaꞌi fwalak roak yai.” ");
INSERT INTO frd_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ba Yahudi rira dawan mela falurut ra rmangadu Yesus naꞌa afa rivun. ");
INSERT INTO frd_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Nata Pilatus norat ewal Yesus ne, “Wol bwalat ira? Eka mrenar ngrihi sian ovi rala al rmangadu Oa yai!” ");
INSERT INTO frd_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Naꞌuk Yesus wol nvalat lahir, ba Pilatus ntalkaka. ");
INSERT INTO frd_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Lokat varat naꞌut amar dawan Paskah, na tamata ra baꞌi rera verin Pilatus ma nfatalik tamata isa tali buꞌi ralan. ");
INSERT INTO frd_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Naꞌut inyai, na tamata isa naran Barabas ovu tamata ovi rangal fareta rnaꞌa buꞌi ralan. Ira rfedan tamata naꞌut i rotu vangoa-vanga. ");
INSERT INTO frd_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Tamata rivun rasdovu ira ma ti rera verin Pilatus, ma nfatalik tamata isa tali buꞌi ralan, wean i baꞌi notu a. ");
INSERT INTO frd_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilatus norat ira ne, “Ba mtyorung ma ufatalik Yahudi rira raja ini verin mia?” ");
INSERT INTO frd_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilatus nkaꞌa roak ne, Yahudi rira dawan mela falurut ra ralarira sian Yesus, ba rovun Ia verin Pilatus. ");
INSERT INTO frd_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Naꞌuk Yahudi rira dawan mela falurut ra rtuar tamata rivun, boma rera verin Pilatus ma nfatalik Barabas verin ira. ");
INSERT INTO frd_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Nata Pilatus norat ewal ira ne, “Ba wean inyai, na inabira ma otu afaka verin tamata i fyalak Ia ne, Yahudi rira Raja?” ");
INSERT INTO frd_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Tamata rivun yai rafwak ma rfalak ne, “Bwaku Ia naꞌa aa walwalur!” ");
INSERT INTO frd_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilatus nfalak verin ira ne, “Afakinimi? Notu sala afaka?” Naꞌuk rafwak ma vairira dawan ilaꞌa ne, “Bwaku Ia naꞌa aa walwalur!” ");
INSERT INTO frd_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilatus inan ma nfakena watan ralarira ra, ba nfatalik Barabas verin ira. Nata nsinir ma Roma rira suldadu ra rasveva Yesus veki, beti nala Ia verin ira, ma veka rbaku Ia naꞌa aa walwalur. ");
INSERT INTO frd_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Roma rira suldadu ra rovun Yesus rti Pilatus ni rahan fareta dawan a, beti rasdovu rira suldadu liak ra munuk. ");
INSERT INTO frd_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ira rala ravit blawat ungu isa ma raꞌadoru naꞌa Ia, ovu ranan aa anan ovi imarira ra ma naꞌa sabeꞌu ma rfadoku naꞌa Yesus ulun a. ");
INSERT INTO frd_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Nata rsiklabir ma rotu ma felarira ra wean i ralang Ia ma rafwak ne, “Yahudi rira raja verin Oa, ba fara nam a blawat!” ");
INSERT INTO frd_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ira rsikati ira ma al rvaval Yesus ulun ovu takil isa, rafnit naꞌa Ia, ovu rsangatur naꞌa wahan ralan a ma raraning waweang Ia. ");
INSERT INTO frd_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ba ti ma rworuk-rwak munuk Yesus, na raling ewal ravit blawat ungu i neluk a, ma raꞌadoru ewal Ni kadaravit ra naꞌa Ia. Nata rovun Ia mane rbaku Ia naꞌa aa walwalur. ");
INSERT INTO frd_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Naꞌut inyai, na rtuan tamata isa ntali kota Kirene, naran Simon. Simon ini yanan verin Aleksander ovu Rufus. Ia ntali ni kota mane nti Yerusalem, na suldadu ra rkiwal ia ma nvara Yesus Ni aa walwalur a. ");
INSERT INTO frd_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ira rovun Yesus rti wan isa naran Golgota. Vaivatul yai ihin a, “Kalkulun Wan.” ");
INSERT INTO frd_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Rala anggur i nsileti ovu afa isa naran mur verin Yesus ma nenu, naꞌuk nafena. ");
INSERT INTO frd_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ba rbaku Ia naꞌa aa walwalur, nata rotu undi ma rsiduk Ni kadaravit ra. ");
INSERT INTO frd_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Naꞌut inyai jam sembilan varverak, na rbaku Ia naꞌa aa walwalur. ");
INSERT INTO frd_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Rtulis vali vaivatul ra naꞌa aa walwalur, ma nfalyawang ne, afakinimi rukun Ia. Rtulis ne, “Yahudi rira Raja verin Ia.” ");
INSERT INTO frd_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Amar yai, na rbaku vali tamata ktufan irua naꞌa aa walwalur. Isa naꞌa Yesus Ni lihir mela a, na isa naꞌa Ni lihir balit a.  ");
INSERT INTO frd_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ba wean inyai, boma nfakena lahir afa ovi rtulis roak naꞌa Surat Ralan a ne, “Tamata ra veka ranovak ne, tamata ktufan Ia.” ");
INSERT INTO frd_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Tamata ovi rahu inyai rarwaꞌung ulurira ra ma rfalak sian Yesus. Ira rfalak ne, “Oa fwalak ne, bisma maꞌar vatuk dida Rahan Dawan Falurut ovu fwadiri ewal ia naꞌa amar itelu! ");
INSERT INTO frd_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ba wean inyai, na msuta tali aa walwalur yai, boma deka mwata!” ");
INSERT INTO frd_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Yahudi rira dawan mela falurut ra ovu rira dawan ovi rair Musa ni inukun ra rdiri vali wan yai ma rworuk-rwak Yesus. Ira rfalak ne, “Ia not-nala ma tamata liak wol rmata, naꞌuk wol not-nala ma deka nmata. ");
INSERT INTO frd_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Wean i Israel rira raja verin Ia, ovu Ia Raja i ntevut dida salasilan ra, na eka nsuta tali aa walwalur yai, boma tsiꞌik ovu torang Ia.” Tamata ktufan irua i rbaku roak ira naꞌa aa walwalur ma rnaꞌa Yesus Ni lihir mela ovu balit yai, rfalak sian vali Ia. ");
INSERT INTO frd_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Naꞌut inyai lera ndirlola, na deda fafyat nsoru munuk wan yai, ti naran jam itelu. ");
INSERT INTO frd_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ba naꞌut jam tiga lersian, na Yesus nafwak ne, “Eloi, Eloi lama sabaktani?” Yesus Ni vaivatul avyai ihin a wean ini, “O Ubu i uraning a! O Ubu i uraning a! Afakinimi muti talik Yaꞌa i?” ");
INSERT INTO frd_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Tamata ovi rdiri inyai rarenar afa i Yesus nfalak a, ba rfalak ne, “Eka tfatlina ma lolin! Ia nera nabi Elia.” ");
INSERT INTO frd_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ba tamata isa ti nala spons etal isa ma nsovu naꞌa anggur i nakbia. Nata nngatan teri spons yai naꞌa aa etal isa ni tutul a, ma nlauk rata verin Yesus ma nbuk, beti nfalak ne, “Tnaban veki! Eka tsiꞌik, beta ne Elia nma ma nfasuka Ia tali aa walwalur yai.” ");
INSERT INTO frd_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Nata Yesus nafwak ma vain a dawan, na nan nakbosal lahir. ");
INSERT INTO frd_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Naꞌut inyai vali, na maloli dawan amafal i nakloꞌi Yahudi rira Rahan Dawan Falurut ralan a namadir lahir naꞌut irua, tali ratan nsuta naran fun. ");
INSERT INTO frd_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Dawan i nfareta Roma rira suldadu ra ndiri Yesus wahan ralan, ma nsiꞌik Ia, nata ti naran nan nakbosal, ba nfalak ne, “Kena urun, tamata ini Ubu Yanan a!” ");
INSERT INTO frd_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Vata boku rsiꞌik afa avyai tali raroa watan. Vata avyai nararira Maria Magdalena, Salome, Maria i yanan marmuri Yakobus ovu Yoses. ");
INSERT INTO frd_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Naꞌut i Yesus nanaꞌa propinsi Galilea, na vata avyai rorang ovu rlobang Ia. Vata liak rivun vali rorang Yesus rti Yerusalem, ma rnaꞌa vali inyai. ");
INSERT INTO frd_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Naꞌa amar yai, na tamata Yahudi ra rasusan warira, tevek ni ilyan a, na rira amar ma ryari ira. Yaꞌi laflofan roak, na ");
INSERT INTO frd_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","tamata isa naran Yusuf ntali ahu Arimatea nma mane ntuan Pilatus. Yusuf ini ndoku Yahudi rira sidovung dawan, ovu tamata ra ralang ma dawan ia. Yusuf nanaban vali ma Ubu nfareta tamata ra wean lahir Raja. Ba Yusuf nfabrahi tenan ma ti ntuan Pilatus ma nera Yesus tenan a. ");
INSERT INTO frd_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilatus ntalkaka, tevek nrenar ne, Yesus nmata roak. Ba nera dawan i nfareta Roma rira suldadu ra ma norat ia ne, Yesus nmata roak. ");
INSERT INTO frd_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ti ma Pilatus nrenar Roma rira suldadu dawan yai nfalak ne, Yesus nmata roak, ba ntorung ma Yusuf ti nala Yesus tenan a. ");
INSERT INTO frd_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ba Yusuf nfaha maloli ngangiar isa ma ti nfasuka Yesus tenan tali aa walwalur, ma nkuma Ia ovu maloli yai. Nata Yusuf ti ma nfanuba Yesus tenan a naꞌa vatu i rtivan roak ia ma wean van, beti nlawar vatu dawan al nulang teri van ngoran yai. ");
INSERT INTO frd_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria Magdalena ovu Maria i yanan Yoses ti rsiꞌik wan i rfadoku Yesus naꞌa. ");
INSERT INTO frd_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Amar i Yahudi ra ryari ira nelak roak, na Maria Magdalena, Maria i yanan Yakobus ovu Salome rfaha ngul ovi voarira lolin, mane rti raꞌung naꞌa Yesus tenan a. ");
INSERT INTO frd_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ba ti ma lera ndata roak naꞌa amar kareda, na rti van matmatan i rfanuba Yesus tenan a. ");
INSERT INTO frd_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Rnaꞌa rira banbanan obin, na rsiforat ira ne, “Tamata iki veka nlawar nala vatu i nulang teri van ngoran eri?” ");
INSERT INTO frd_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Naꞌuk rti ma raran inyai ma rsiꞌik, na vatu i dawan urun yai natsuar roak tali van matmatan ngoran a. ");
INSERT INTO frd_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ba rti van ralan ma rsiꞌik, na varverun isa noru ravit blawat ngangiar ma ndoku rira lihir mela. Vata avyai rabrian urun. ");
INSERT INTO frd_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Varverun yai nfalak verin ira ne, “Deka byobar. Ukaꞌa roak ne, mya ma mdyava Yesus ntali Nazaret i rbaku roak Ia naꞌa aa walwalur. Ia wol nanaꞌa roak ini, tevek nvaꞌat ewal roak. Eka msyiꞌik wan i rfanuba Ia naꞌa yai. ");
INSERT INTO frd_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Myewal aꞌuk mia ma miti fyamalik verin Petrus ovu Yesus Ni tamata liak ovi rorang Ia ne, ‘Yesus veka ula Ia nti propinsi Galilea. Mia veka mtyuan Ia naꞌa ineri, wean lahir i nfamalik roak verin mia.’ ” ");
INSERT INTO frd_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Vata avyai rbobar ma raruru lalean ira, ba rti murin ma rafla talik van matmatan yai. Ira wol rfalak akataka verin tamata ra, tevek rbobar. Ira rfamalik munuk ivar yai verin Petrus ovu ni kida ra, naꞌuk wol mnanat. Rotu munuk afa avyai, beti Yesus nsinir Ni tamata ovi rorang Ia ma rtali timur rti varat, ma ti rfamalik Ubu Ni Ivar mngaꞌun i wol bisma nmamu. Ivar yai nfamalik naꞌa i wean inba ma Ubu nsikat tamata ra tali rira salasilan ra, ma rira vavaꞌat kakiwal.  ");
INSERT INTO frd_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ti ma Yesus nvaꞌat ewal naꞌut varverak sumatan naꞌa amar kareda, na nfavotuk lan Ia verin Maria Magdalena. Vata yai lan a, Yesus naling vatuk nait sian ifitu tali ia. ");
INSERT INTO frd_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ba Maria ti ma nfamalik ivar yai verin Yesus Ni tamata ovi rorang Ia. Tamata avyai ralarira lalau ma rvakar. ");
INSERT INTO frd_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ira rarenar ne, Yesus nvaꞌat ewal roak, ovu Maria nrea lahir Ia, naꞌuk ira wol rorang.  ");
INSERT INTO frd_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Yesus notu wean inyai, beti ti nfavotuk vali tenan ovu felan naling Ia verin tamata irua tali tamata ovi rorang Ia. Rarea Ia naꞌut amar i rbana rti talik kota ma rti wan liak. ");
INSERT INTO frd_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ba rewal ira ma rfamalik ivar yai verin rira kida ra, naꞌuk wol rorang. ");
INSERT INTO frd_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Nata Yesus ti nfavotuk vali tenan verin Ni tamata vutu rahin isa ovi rorang Ia, naꞌut i rafnaꞌan. Yesus ntabu ira, tevek rira inorang wol nangrebat ovu vali rafena lahir ma rorang tamata ovi rarea Ia ma rfamalik ne, Yesus nvaꞌat ewal roak. ");
INSERT INTO frd_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ia nfalak verin ira ne, “Byan-soru munuk lanit ivavan a, ma fyamalik Ubu Ni Ivar Lolin verin tamata ra munuk. ");
INSERT INTO frd_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Tamata ovi rorang Ubu Ni Ivar Lolin yai ovu rtorung ma rbaptis ira, na Ubu veka nsikat ira tali rira salasilan ra, ma rira vavaꞌat kakiwal. Naꞌuk tamata ovi wol rorang Ia, Ubu veka nukun ira. ");
INSERT INTO frd_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Tamata ovi rorang Yaꞌa, Ubu veka nala ngrebat ma neluk faneak verin ira, ma rala narang a al raling vatuk nait sian ra, ovu vali veka rangrihi ovu vai ovi wol rkaꞌa ra. ");
INSERT INTO frd_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ira veka rtaha nala nifa te renu alanu, naꞌuk wol rtuan akataka. Ira veka rfadoku limarira ra naꞌa tamata ovi rira suhut ra, na tamata avyai lolin ewal ira.”  ");
INSERT INTO frd_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ti ma Duilaꞌa Yesus nangrihi munuk verin ira, na Ubu notu ma nrata lanit ratan, ma ndoku Ni lihir mela a. ");
INSERT INTO frd_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Nata Yesus Ni tamata ovi rorang Ia rti ma rfamalik Ubu Ni Ivar Lolin naꞌa wan inba watan. Duilaꞌa novun ira, ma rotu mujizat ra ma al rfalyawang ne, afa ovi rfamalik ra kena.");
INSERT INTO frd_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Baba Teofilus, yaꞌa alang oa. Tamata rivun rasahak roak ma rtulis ivar i nvotuk roak a, ma rfamalik naꞌa afa ovi tatuan roak naꞌa dida vavaꞌat ra. ");
INSERT INTO frd_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ira rtulis wean lahir i trenar roak tali tamata ovi kaꞌi rsiꞌik lahir afa ovi Yesus notu tali lalan a, beti rti ma rfamalik ivar yai. ");
INSERT INTO frd_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ba urenar ovu ubas ma lolin afakataka munuk naꞌa Yesus, tali naꞌut i beti nvotuk a, ti naran i roak a. Ufikir ne, ni lolin a, na ususan ma lolin ivar yai veki, beti utulis lahir naꞌa surat isa verin oa. ");
INSERT INTO frd_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Yaꞌa otu wean inyai, boma mkaꞌa lahir ne, afa ovi rair munuk roak verin oa yai, kena urun. ");
INSERT INTO frd_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Naꞌut i Herodes notu raja naꞌa propinsi Yudea, na Yahudi rira mela falurut isa i nkarya verin Ubu nanaꞌa inyai. Mela falurut yai naran Zakharia. Ia ntali sidovung mela falurut ovi Abia nban-ulu verin ira. Awan a naran Elisabet. Elisabet ini Harun ubun a nusin verin ia. ");
INSERT INTO frd_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Zakharia irua awan a rira vavaꞌat ra rmalola naꞌa Ubu wahan ralan a. Irua ralarira urun ma rot-orang munuk afa ovi Duilaꞌa nfadoku roak naꞌa Ni inukun ra. ");
INSERT INTO frd_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Naꞌuk irua wol yanarira, tevek Elisabet wol bisma yanan, ovu vali naꞌut inyai itvata-itrana roak ira. ");
INSERT INTO frd_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Amar isa, naꞌut i sidovung Abia rira amar ma rfabana rira karya naꞌa Yahudi rira Rahan Dawan Falurut, na Zakharia nfabana ni karya i neluk Yahudi rira mela falurut a naꞌa Duilaꞌa wahan ralan a. ");
INSERT INTO frd_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Naꞌut i rotu undi ma al nfaturu ne, mela falurut iki veka nfabana ni karya naꞌa Duilaꞌa Ni Rahan Dawan Falurut, na undi yai nfaturu Zakharia. Ba ia nti Rahan Dawan Falurut ralan a ma nasnuri afa i uman voan a lolin urun. ");
INSERT INTO frd_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Naꞌut i Zakharia nti ralan ma nasnuri afa i uman a voan a lolin urun yai, na tamata rivun rasdovu ira naꞌa Rahan Dawan Falurut ni lean a ma raflurut. ");
INSERT INTO frd_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ba naꞌut inyai, na Ubu Ni sansinir isa ntali lanit ratan nvotuk ma ndiri lahir wan i baꞌi rasnuri afa i uman a voan lolin urun, ni lihir mela a. ");
INSERT INTO frd_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ti ma Zakharia nsiꞌik Ubu Ni sansinir yai, na nabrian munuk ovu nbobar urun. ");
INSERT INTO frd_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Naꞌuk Ubu Ni sansinir yai nfalak verin ia ne, “Zakharia, deka bwobar, tevek Ubu nrenar roak mu falurut a. Awam i Elisabet a veka nrali kasikoꞌu brana isa. Oa musti fwanara ia ne, Yohanes. ");
INSERT INTO frd_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ralam a veka lolin urun, ovu tamata rivun ralarira ra veka lolin urun i vali, naꞌut i kasikoꞌu yai rarali roak ia! ");
INSERT INTO frd_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ira ralarira ra veka lolin, tevek Ia veka neluk tamata dawan naꞌa Duilaꞌa wahan ralan a. Ia wol bis lahir ma nenu anggur te tuat, ovu naꞌut i naꞌa kevralan obin, na Ubu Ni Roh a veka nsoru ralan a. ");
INSERT INTO frd_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Afa ovi nair ra veka notu ma tamata Israel rivun ira rorang ewal Duilaꞌa i rira Ubu verin Ia. ");
INSERT INTO frd_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ia veka neluk Duilaꞌa Ni sansinir i ula ia ma nasusan lingaꞌan verin Duilaꞌa. Ia notu afa yai ovu ngrebat i ntali Ubu Ni Roh a, wean ngrebat i nala verin nabi Elia. Ia veka notu ma brana ovi wol malinan obin ovu yanarira ra, malinan ewal. Ia veka notu vali ma tamata ovi wol rorang afa ovi Ubu nfalak ra, rorang ewal Ubu, ma rira kakaꞌa wean tamata ovi rira vavaꞌat ra rmalola. Notu wean inyai, boma tamata rira vavaꞌat ra inovan ma rarenar Duilaꞌa.” ");
INSERT INTO frd_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Nata Zakharia nfalak verin Ubu Ni sansinir yai ne, “Wean inba ma ukaꞌa ne, afa yai veka nvotuk? Yaꞌa itrana roak yaꞌa ovu vali awang a itvata roak ia.” ");
INSERT INTO frd_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ubu Ni sansinir yai nfalak ne, “Yaꞌa ini Gabriel. Ukarya verin Ubu naꞌa lanit ratan, ovu Ia nsinir yaꞌa ma ufalak ivar lolin ini verin oa. ");
INSERT INTO frd_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Afa i ufalak ini veka nvotuk naꞌa amar i Ubu nfadoku roak a. Naꞌuk oa wol morang, ba veka wol mungrihi nala oa, nata ti naran afa i ufalak yai nvotuk.” ");
INSERT INTO frd_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Naꞌut inyai, na tamata rivun rnaban watan Zakharia. Ira rsiforat ira ne, afakinimi mnanat ia naꞌa Rahan Dawan Falurut ralan a. ");
INSERT INTO frd_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ti ma Zakharia ntali Rahan Dawan Falurut ralan a nma murin, na ia wol nangrihi nala afakataka verin ira. Ia nala watan liman a ma al notu faneak verin ira. Ba tamata ra rkaꞌa ne, ia wean i namifi naꞌuk wol ntub-lufa ma nsiꞌik afa boku naꞌa Rahan Dawan Falurut ralan. ");
INSERT INTO frd_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Amar ovi nkarya naꞌa Rahan Dawan Falurut ralan a nbosal roak, beti newal ia nti ni rahan. ");
INSERT INTO frd_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Wol kaꞌi mnanat, na awan a Elisabet nbarlewan. Vulan ilima, na ia nanaꞌa rahan ralan watan ma tamata ra wol rarea ia. ");
INSERT INTO frd_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Elisabet nfalak ne, “Duilaꞌa nfaturu roak Ni rala lolin a verin yaꞌa, tevek nlobang roak yaꞌa ma ubarlewan, ba wol umaꞌit roak naꞌa tamata waharira ralan ra.” ");
INSERT INTO frd_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabet nbarlewan vulan inean roak, na Ubu nsinir Ni sansinir tali lanit ratan i naran Gabriel yai, ma nti ahu isa naran Nazaret naꞌa propinsi Galilea. ");
INSERT INTO frd_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Gabriel ti nalola vata mnelat isa naran Maria. Ia wol ntuba ovu brana obin. Yusuf i ubun-nusin Raja Daud ntavun teri roak ia. ");
INSERT INTO frd_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Sansinir yai nti Maria ni rahan ma nfalak verin ia ne, “Oo titi, Duilaꞌa naflahar roak oa ovu novun oa!” ");
INSERT INTO frd_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ti ma Maria nrenar afa i nfalak yai, na wol nkaꞌa ne, veka nanovak aka. Ba norat watan naꞌa ralan a ne, vaivatul ovi ihirira ra wean inba? ");
INSERT INTO frd_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ubu Ni sansinir yai nfalak vali ne, “Maria deka bwobar, tevek Ubu naflahar roak oa. ");
INSERT INTO frd_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Oa veka bwarlewan ma mrali oa, na yanam brana. Oa musti fwanara Ia ne Yesus. ");
INSERT INTO frd_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ia vali veka nanaꞌa tamata dawan, ovu tamata ra veka rfalak ne, Ubu i Ni dawan nlia munuk afakataka, Yanan Ia. Ubilaꞌa veka nsikat Ia ma neluk raja, ma ndoku ubun-nusin Raja Daud wan i ndoku ma nfareta. ");
INSERT INTO frd_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ia veka nfareta kakiwal Yakub ubun-nusin ra, tevek Ni fareta a wol ni wahan.” ");
INSERT INTO frd_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maria nfalak verin Ubu Ni sansinir yai ne, “Wean inba ma veka wean inyai, tevek yaꞌa wol utuba ovu brana obin?” ");
INSERT INTO frd_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ubu Ni sansinir yai nfalak verin Maria ne, “Ubu Ni Roh veka nsuta ma nleal lahir oa. Ubu i Ni dawan nlia munuk afakataka, Ni ngrebat a veka nteri oa ma yanam i veka mrali Ia yai wol Ni salasilan, ovu veka rera Ia ne, ‘Ubu Yanan a.’ ");
INSERT INTO frd_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Teram i Elisabet itvata roak ia ma tamata ra rfalak ne, ia wol bisma yanan, naꞌuk fiang ini nbarlewan vali ma ni vulan inean roak, ovu kasikoꞌu yanat i naꞌa evun ralan a, brana vali ia. ");
INSERT INTO frd_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Tevek Ubu bis not-nala munuk afakataka.” ");
INSERT INTO frd_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maria nfalak ne, “Yaꞌa eluk sansinir verin Duilaꞌa, ba fara wean urun afa ovi fwalak yai.” Nata Ubu Ni sansinir yai nti talik ia. ");
INSERT INTO frd_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Wol mnanat, na Maria nti lahir ma nalola Elisabet naꞌa ahu isa, naꞌa propinsi Yudea. Ahu yai ndoku wan i vuar ra rnaꞌa. ");
INSERT INTO frd_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Naꞌa inyai, na ia nti Zakharia ni rahan ralan a ma nala salam verin Elisabet. ");
INSERT INTO frd_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ti ma Elisabet nrenar Maria vain a, na yanan i nanaꞌa evun ralan a nasdai lahir, tevek inan lolin, ovu vali Ubu Ni Roh a nsoru lahir Elisabet. ");
INSERT INTO frd_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ba vain a dawan ma nfalak ne, “Ubu naflahar roak oa, nlia tali vata liak ra munuk, ovu naflahar vali kasikoꞌu yanat i veka mrali ia yai. ");
INSERT INTO frd_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Yaꞌa ini iki yaꞌa mi ning Duilaꞌa renan a nma ma nalola yaꞌa? ");
INSERT INTO frd_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Naꞌut i urenar vaim a, na kasikoꞌu yanat i naꞌa evung ralan ini nasdai lahir, tevek inan lolin urun. ");
INSERT INTO frd_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Lolin urun verin oa, tevek morang ne, afa ovi Duilaꞌa nfalak verin oa yai veka rvotuk.” ");
INSERT INTO frd_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","47","Maria nfalak ne, “Ufadawang Duilaꞌa, ovu ralang a lolin urun, tevek Ubu neluk Raja ma nsikat yaꞌa tali ning salasilan ra, ma ning vavaꞌat kakiwal. ");
INSERT INTO frd_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ia nsiꞌik ma lolin yaꞌa, velik ne eluk tamata sansinir ma ukarya verin Ia. Ba tali amar ini, tali tuvu nti tuvu, na tamata ra munuk veka rfalak ne, yaꞌa ini vata i utung urun a, ");
INSERT INTO frd_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","tevek Ubu i nfareta munuk afakataka notu roak afa dawan ovi tamata ra wol rot-nala a verin yaꞌa. Ubu naran a nmerat urun. ");
INSERT INTO frd_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Tali tuvu nti tuvu, na Ia nfaturu lalawatan Ni silobang a verin tamata ovi rbobar Ia. ");
INSERT INTO frd_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ia nala Ni ngrebat a ma notu afa dawan ovi tamata ra wol rot-nala, ovu notu ma tamata ovi rfakaratat tenarira ra ramir-ramar tia ma watan ira. ");
INSERT INTO frd_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ia nfaleka tamata fareta ra tali wan ovi rdoku ma rfareta a, naꞌuk nfakaratat tamata ovi wol fyawarira ra. ");
INSERT INTO frd_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ubu nala afa ovi lolin ra munuk verin tamata kasian ra, boma deka rablafar, naꞌuk nsinir tamata ovi rkaꞌi ra ma rewal ira ovu limarira vu watan. ");
INSERT INTO frd_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Ubu Ni tnorung verin ubumam-nusimami ra ma nfalak ne, Ia nlobang ami, tamata Israel ra. Ia nfakena roak Ni tnorung yai. Ia wol nablufang ma nfaturu Ni silobang a verin Abraham ovu ubun a nusin ra, nata ti wol ni wahan.” ");
INSERT INTO frd_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria nanaꞌa Elisabet ni rahan, kaꞌa bi vulan itelu, beti newal ia nti ni rahan. ");
INSERT INTO frd_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabet ni amar kena roak ma nrali ia, ma yanan a brana ia. ");
INSERT INTO frd_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ti ma tamata ovi rnaꞌa ni rahan nelan a ovu ni tiniman ra rarenar ne, Duilaꞌa nfaturu Ni silobang i dawan urun a verin Elisabet, na rir tinemun rotu inarira lolin ovu ia. ");
INSERT INTO frd_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Kasikoꞌu yanat yai ni amar iwalu roak, na rir tinemun rovun ia ti mane rsunat ia. Ira mane rfanara kasikoꞌu yai naran a wean yaman a Zakharia. ");
INSERT INTO frd_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Naꞌuk renan a nfalak ne, “Deka! Ita musti tfanara ia ne, Yohanes.” ");
INSERT INTO frd_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ira rfalak verin Elisabet ne, “Wol tamata isa vali tali bira tiniman ra nararira wean inyai.” ");
INSERT INTO frd_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ba ira rotu faneak ma al rorat yaman a ne, veka nala nara aka ma al nfanara yanan a. ");
INSERT INTO frd_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zakharia nera kba masnifit isa tali ira ma ntulis ne, “Ia naran Yohanes.” Ba rir tinemun rtalkaka munuk lahir. ");
INSERT INTO frd_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Brian munuk, na Zakharia nangrihi nal-ewal ma nfadawang lahir Ubu. ");
INSERT INTO frd_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ba tamata ovi rnaꞌa rira rahan nelan a munuk rbobar ma ralang Ubu, ovu tamata ra rfamalik ivar yai ma ti nsoru munuk wan ovi rnaꞌa Yudea ni vuar ra. ");
INSERT INTO frd_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Tamata ovi rarenar ivar yai, ira munuk ranovak watan naꞌa ralarira ra ne, “Kasikoꞌu yanat ini dawan ia, na veka wean inba? Kena urun ma Duilaꞌa nfatuang ia.” ");
INSERT INTO frd_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ubu Ni Roh a nsoru lahir Zakharia i yanan kasikoꞌu yanat yai, ba nfamalik ivar ovi nrenar lahir tali Duilaꞌa. ");
INSERT INTO frd_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Ia nfalak ne, “Mya ma tfadawang Duilaꞌa, Ubu i tamata Israel ra raraning a, tevek nma ma nalola ita ovu nlobang ita, ma nfatalik ita tali dida varvara aleman ra. ");
INSERT INTO frd_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ia nala Tamata i Ni ngrebat a dawan urun a, ma nsikat ita tali dida salasilan ra, ma dida vavaꞌat kakiwal. Ia ubun a nusin Raja Daud i neluk tamata sansinir verin Ubu. ");
INSERT INTO frd_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Tali lalan ana, Ubu nfalak roak Ni tnorung yai nahu nabi ovi nfili ra, ");
INSERT INTO frd_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ma nfatalik ita tali tamata ovi rira sian ita. Ia nfatalik ita tali tamata ovi wol inar lahir ita. ");
INSERT INTO frd_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Notu wean inyai ma nfaturu Ni rala lolin a verin ubud-nusid ra ne, veka nfakena Ni tnorung i nmerat urun yai. ");
INSERT INTO frd_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Ia nafwaba roak naꞌa Ni tnorung a verin ubud-nusid i Abraham. Ia nafwaba roak ne, veka nfatalik ita tali tamata ovi rira sian ita, boma tot-orang afa ovi nfalak ra, ovu wol tbobar, ");
INSERT INTO frd_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ovu ralad urun ma dida vavaꞌat ra rmerat ovu rmalola, boma Ubu ralan a lolin ovu ita, ti naran i tmata a.” ");
INSERT INTO frd_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Nata Zakharia nfalak verin yanan a ne, “Ubu i Ni dawan nlia munuk afakataka veka nsikat oa ma meluk Ni nabi, tevek oa veka bwana ula oa ma mususan lingaꞌan verin Duilaꞌa. ");
INSERT INTO frd_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Oa veka fwalyawang verin Ni tamata ra ne, wean i Ubu naꞌi vatuk roak rira salasilan ra, na Ia veka nala vavaꞌat kakiwal verin ira. ");
INSERT INTO frd_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ubu nfaturu Ni rala lolin a ovu Ni silobang a verin ita, bi notu wean inyai. Ia i ntali lanit ratan yai, veka nma wean lera beti ndata. ");
INSERT INTO frd_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ia vanan a veka nyeba munuk tamata ovi rvaꞌat naꞌa dedan ralan a, ovu vali tamata ovi rbobar matmatan. Ia veka novun vali ita ma dida vavaꞌat ra malinan lalawatan.” ");
INSERT INTO frd_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Zakharia yanan yai nmela ma dawan roak ia, ovu ni inorang verin Duilaꞌa ntafal ma nangrebat. Ia nanaꞌa watan wan lean vu dawan, ti naran amar i nfavotuk tenan a verin tamata Israel ra. ");
INSERT INTO frd_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Naꞌut i beti rarali Yohanes, na Kaisar Agustus nfareta ni tamata ra ma rtulis munuk tamata ovi rarenar tali fareta Roma, nararira ra. ");
INSERT INTO frd_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Inyai beti fasa rtulis nararira ra naꞌa daftar, boma rkaꞌa lahir ne, tamata ifira munuk naꞌut inyai. Ira rotu daftar yai naꞌut i Kirenius notu gubernur naꞌa propinsi Siria. ");
INSERT INTO frd_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ba tamata ra munuk rti rira ahu ra ma rtulis nararira ra. ");
INSERT INTO frd_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Yusuf notu vali wean inyai. Ia ntali ahu Nazaret i nanaꞌa propinsi Galilea ma nti Raja Daud ni kota a, naran Betlehem, naꞌa propinsi Yudea, tevek ubun a nusin Raja Daud. Yusuf nti ma rdaftar naran a ovu Maria i ntavun teri roak ia. Naꞌut inyai, na Maria nbarlewan roak. ");
INSERT INTO frd_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Naꞌut i rnaꞌa Betlehem, na Maria ni amar kena roak ma nrali Ia. ");
INSERT INTO frd_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Yanan iyaꞌan ini, brana Ia. Maria nkuma yanan a ovu sikar, beti nfanuba Ia naꞌa wan i afwatan ra baꞌi rafnaꞌan naꞌa, tevek rahan siwelat ma rafnerung teri naꞌa nngora roak. ");
INSERT INTO frd_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ovan yai, na domba duarira ra rnaꞌa vali ngrova dardirin ovi rfaseri Betlehem a, ma rwanar rira domba ra. ");
INSERT INTO frd_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Brian munuk, na Duilaꞌa Ni sansinir isa ntali lanit ratan nma ma nfaturu tenan a verin ira. Duilaꞌa vanan i nfitik nyadat nsoru ira, ba rbobar urun i lahir. ");
INSERT INTO frd_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Duilaꞌa Ni sansinir yai nfalak verin ira ne, “Deka byobar, tevek ufamalik ivar lolin verin mia, ovu verin tamata ra munuk ma veka inabira lolin urun i lahir. ");
INSERT INTO frd_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ovan ini vali naꞌa Raja Daud ni kota, na rarali roak Duilaꞌa Kristus. Ia Raja i nsikat tamata ra tali rira salasilan ra, ma rira vavaꞌat kakiwal. ");
INSERT INTO frd_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ni faneak a wean ini: mia veka mtyuan kasikoꞌu yanat isa, rkuma Ia ovu sikar ma rfanuba Ia naꞌa wan i afwatan ra baꞌi rafnaꞌan naꞌa.” ");
INSERT INTO frd_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Brian munuk, na Duilaꞌa Ni sansinir yai ovu Ni sansinir liak ra vali, rivun ilaꞌa ira rvotuk. Rir tinemun rfadawang Ubu ma rfalak ne, ");
INSERT INTO frd_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Fara traning Ubu! Ia saꞌi dawan Ia ovu nanaꞌa wan i karatat lia munuk a. Naꞌa lanit ivavan ini, fara malinan verin tamata ovi Ubu naflahar roak ira.” ");
INSERT INTO frd_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ti ma Duilaꞌa Ni sansinir avyai rti talik ira ma rarata ewal lanit ratan, na domba duarira ra rsifalak afa verin ira ne, “Mya ma tati Betlehem ma tsiꞌik afa i Duilaꞌa nfalak roak verin ita.” ");
INSERT INTO frd_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ba rfarlan lahir ma ti rtuan Maria irua Yusuf, ovu vali kasikoꞌu yanat i ntuba wan i afwatan ra baꞌi rafnaꞌan naꞌa. ");
INSERT INTO frd_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ti ma rsiꞌik kasikoꞌu yanat yai, na rfamalik lahir afa ovi Duilaꞌa Ni sansinir yai nfalak naꞌa kasikoꞌu yanat yai. ");
INSERT INTO frd_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Tamata ovi rarenar afa ovi domba duarira rfamalik yai, rtalkaka munuk lahir. ");
INSERT INTO frd_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Naꞌuk Maria nfikir watan afa avyai ma nanovak naꞌa ralan a. ");
INSERT INTO frd_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Nata domba duarira avyai rewal ira ma raraning Ubu ovu rfadawang Ia, tevek afa ovi rarenar ra ovu afa ovi rsiꞌik ra, kena lahir ovu afa ovi Duilaꞌa Ni sansinir yai nfalak a. ");
INSERT INTO frd_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ti ma Ni amar iwalu roak, na rsunat kasikoꞌu yai, ovu rfanara Ia ne, Yesus. Ubu Ni sansinir tali lanit ratan nfalak lan roak naran ini, naꞌut i renan a wol nlewan Ia obin. ");
INSERT INTO frd_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Amar naran roak ma Yusuf ovu Maria rot-orang Musa ni inukun ra ma rfamerat tenarira ra. Naꞌut inyai, na rovun vali Yesus ma rti Yerusalem ma rfaturu ne, rfadoku munuk Yesus Ni vavaꞌat a verin Duilaꞌa. ");
INSERT INTO frd_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Rfadoku roak naꞌa Duilaꞌa Ni Inukun ra ne, “Brana iyaꞌan ra munuk musti rfamerat ira ma al rfaturu ne, ira veka rkarya watan verin Duilaꞌa.” ");
INSERT INTO frd_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Amar yai, na rot-orang vali Duilaꞌa Ni inukun ra, ma rala kakahu irua te modarlaka yanat irua ma reluk rira korban verin Ubu. ");
INSERT INTO frd_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Naꞌa Yerusalem, na tamata isa naran Simeon. Ia ni vavaꞌat nmalola ovu not-orang munuk afa ovi rnaꞌa Duilaꞌa Ni inukun ra. Ia nanaban amar i Ubu veka nma ma nfaloling tamata Israel ralarira ra. Ubu Ni Roh a nfatuang vali ia. ");
INSERT INTO frd_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ubu Ni Roh a nfalyawang roak verin ia ne, ia wol bisma nmata, ti naran i nsiꞌik Raja i ntevut dida salasilan ra. ");
INSERT INTO frd_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ubu Ni Roh nfalak verin Simeon ma nti Rahan Dawan Falurut ni lean a. Naꞌut inyai, na Yusuf ovu Maria rovun Yesus ma rti ralan ma rot-orang afa ovi rnaꞌa Musa ni inukun ra. ");
INSERT INTO frd_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeon nala kasikoꞌu yanat yai ma nsaka Ia, beti nfadawang Ubu ma nfalak ne, ");
INSERT INTO frd_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Duilaꞌa, fiang ini fwakena roak Mu tnorung a verin yaꞌa. Yaꞌa eluk Mu sansinir, ba velik ne umata, naꞌuk wol akataka, tevek umata ovu malinan. ");
INSERT INTO frd_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Usiꞌik roak Ia i msinir ma nma, ma nsikat ami tali mami salasilan ra, ma mami vavaꞌat kakiwal. ");
INSERT INTO frd_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Oa fwadoku lan roak ma nma, boma tamata ra munuk rsiꞌik Ia. ");
INSERT INTO frd_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ia wean lyawan i nyeba lingaꞌan a verin tamata ovi wol Yahudi ra ma rorang Oa, ovu vali tali afa ovi veka notu ra, na tamata ra munuk ralang Mu tamata Israel ra.” ");
INSERT INTO frd_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Kasikoꞌu yai renan ovu yaman a rtalkaka lahir naꞌut i rarenar afa ovi Simeon nfalak naꞌa yanarira a. ");
INSERT INTO frd_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Nata Simeon naflurut verin Ubu ma naflahar ira, ovu nfalak verin Maria ne, “Ubu nfadoku roak ma kasikoꞌu ini veka nfaleka ma rivun tamata Israel ovi rafena ma rorang Ia, ovu vali nsikat tamata rivun tali rira salasilan ra, ma rira vavaꞌat kakiwal. Ia neluk faneak tali Ubu ma nfangnanang tamata ra naꞌa afa ovi Ubu nfalak ra, naꞌuk tamata rivun veka rangal Ia. ");
INSERT INTO frd_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Wean inyai, na afa ovi tamata ra rfikir a veka rvotuk. Nlia tali inyai, na oa veka fwarnuang lahir lalau dawan i wean nahin blawat nsungu ralam a.” ");
INSERT INTO frd_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Vata isa naran Hana nanaꞌa vali inyai. Ia nabi ia, ovu yaman a naran Fanuel. Fanuel ini ntali Israel rira arun dawan i naran Asyer. Ia tuvu ilaꞌa roak ia. Naꞌut i nsifa ana, nvaꞌat ovu awan a varat ifitu watan, na awan nmata. ");
INSERT INTO frd_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ba tali amar yai, na ia nvaru lahir, ovu ni varat vutwalu rahin ifaꞌat roak. Ovan a amar, na ia nanaꞌa lalawatan Rahan Dawan Falurut a ma nfadawang Ubu, ntolat, ovu vali naflurut. ");
INSERT INTO frd_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Naꞌut inyai vali, na Hana nma ma nfadawang Ubu, ovu nfamalik naꞌa kasikoꞌu yai verin tamata ra munuk. Tamata avyai rnaban amar i Ubu veka nma ma nsikat tamata Yerusalem tali tamata ovi rira sian ira. ");
INSERT INTO frd_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ti ma Yusuf ovu Maria rotu munuk roak afa ovi rnaꞌa Duilaꞌa Ni inukun ra, beti rewal ira rti rira ahu Nazaret i naꞌa propinsi Galilea. ");
INSERT INTO frd_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Kasikoꞌu yai nmela ma dawan roak ia, ma tenan a nangrebat. Ia Ni kakaꞌa dawan tali Ubu, ovu Ubu nala Ni rala lolin verin Ia. ");
INSERT INTO frd_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Lokat varat naꞌut amar i Yahudi ra rangnanang amar i uburir-nusirira ra rdir-talik Mesir, na Yesus renan ovu yaman a baꞌi rti Yerusalem ma rovu snoba dawan yai. ");
INSERT INTO frd_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Naꞌut i Yesus Ni varat vutu rahin irua roak, na ira rti Yerusalem wean i baꞌi rti lokat varat a naꞌa amar dawan yai. ");
INSERT INTO frd_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Amar dawan yai nlia roak beti rewal ira, naꞌuk Yesus nanaꞌa watan Yerusalem. Renan ovu yaman a wol rkaꞌa ne, nanaꞌa inyai obin. ");
INSERT INTO frd_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ira rnarin ne, Ia novu vali tamata rivun ovi irmunuk rbana yai. Ba rbana amar lolan roak, beti rdava Ia naꞌa rira tiniman ra ovu rira kidabela ra. ");
INSERT INTO frd_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Naꞌuk wol rtuan Ia, ba rewal ewal ira rti Yerusalem ma rdava Ia. ");
INSERT INTO frd_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Amar itelu nelak roak, beti rtuan Ia naꞌa Rahan Dawan Falurut ralan a. Ia ndoku ovu Yahudi rira dawan ovi rair Musa ni inukun ra ma nrenar afa ovi rfalak ra, ovu norat afa tali ira. ");
INSERT INTO frd_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Tamata ovi rnaꞌa inyai munuk rtalkaka lahir naꞌa afa ovi nfalak ra ma al nvalat ira, tevek Ni kakaꞌa dawan tali Ubu. ");
INSERT INTO frd_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ti ma renan ovu yaman a rsiꞌik Ia, na rtalkaka lahir, ba renan nfalak verin Ia ne, “Baba, notu afakinimi motu wean inyai verin ami? Amrua yamam a amdava Oa, nata ralamami raruan roak!” ");
INSERT INTO frd_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Yesus nfalak verin renan ovu yaman a ne, “Notu afakinimi mdyava Yaꞌa? Mia wol mkyaꞌa ne, Yaꞌa musti unaꞌa Yamang a Ni rahan a?” ");
INSERT INTO frd_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Naꞌuk Yesus renan ovu yaman a wol rfan-aran afa ovi nfalak verin ira yai. ");
INSERT INTO frd_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Nata Yesus newal Ia ovu renan a yaman a ma rti Nazaret. Ia not-orang lalawatan afa ovi renan-yaman a rfalak ra. Renan a nanovak watan afa ovi rvotuk yai naꞌa ralan a. ");
INSERT INTO frd_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesus nmela ma dawan roak Ia, ovu Ni kakaꞌa dawan tali Ubu ntafal ma nmela. Ubu nlobang urun Ia, ovu vali tamata ra inar dalang Ia. ");
INSERT INTO frd_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Kaisar Tiberius nfareta Roma varat vutu rahin ifaꞌat teran roak. Naꞌut inyai Pontius Pilatus notu gubernur naꞌa propinsi Yudea. Herodes notu raja ma nfareta naꞌa propinsi Galilea, ovu Herodes aꞌan i Filipus, notu raja ma nfareta naꞌa propinsi Iturea ovu Trakhonitis. Lisanias notu raja ma nfareta vali naꞌa propinsi Abilene. ");
INSERT INTO frd_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Naꞌut inyai, na Hanas ovu Kayafas reluk Yahudi rira Mela Falurut Ilaꞌa ma rkarya verin Ubu. Naꞌa varat yai vali, na Ubu nangrihi verin Yohanes naꞌa wan lean vu dawan. Yohanes ini yaman a verin Zakharia. ");
INSERT INTO frd_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ba Yohanes nti munuk wan ovi rfaseri oar Yordan a, ovu nafwak ma vain a dawan urun al nfamalik Ubu Ni Ivar a ne, “Myahil kikyai tali bira salasilan ra, ovu myala tenabira ra ma ti rbaptis mia, boma Ubu veka naꞌi vatuk bira salasilan ra.” ");
INSERT INTO frd_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Wean i nabi Yesaya ntulis naꞌa ni kitab a ne, “Tamata isa nafwak naꞌa wan lean vu dawan ne, ‘Misusan lingaꞌan verin Duilaꞌa, ovu fyamalola lingaꞌan a verin Ia. ");
INSERT INTO frd_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Lanun ovi wol manesan ra, myotu ma manesan, ovu myotu vali ma sakvuar ovu vuar ra manesan, ovu vali lingaꞌan ovi rkiluk ra, fyamalola ira. Lanun i suta-rata ra, myotu vali ma manesan. ");
INSERT INTO frd_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ba tamata ovi rnaꞌa lanit ivavan a munuk veka rsiꞌik i Ubu nsikat tamata ra tali rira salasilan ra, ma rira vavaꞌat kakiwal.’ ” ");
INSERT INTO frd_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Yohanes nfalak verin tamata rivun ovi rma ma nbaptis ira yai ne, “Mia sian urun mia wean aru ra! Iki nfalak verin mia ne, Ubu Ni inukun i veka nma yai wol nkena mia? ");
INSERT INTO frd_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Fyaturu lahir naꞌa bira vavaꞌat ra ne, myahil roak tali bira salasilan ra! Deka minovak naꞌa ralabira ra ne, ububir-nusibira Abraham, ba Ubu veka wol nukun mia! Mryenar ma lolin afa ovi ufalak ini! Ubu bis notu watan ma Abraham yanan ra, rtali vatu ovi! ");
INSERT INTO frd_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ubu Ni amar sarseri roak ma nfaleka inukun verin tamata ra. Ni inukun a wean tamata i ntaha savi ma veka netal aa ra tali rira waꞌar ra. Aa ovi vuarira wol lolin ra, na veka netal vatuk ira ma nala ira rti yafu ralan.” ");
INSERT INTO frd_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ba tamata rivun avyai rorat ia ne, “Wean inyai, na ami veka amotu afaka?” ");
INSERT INTO frd_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yohanes nfalak ne, “Wean i tamata isa ni ravit irua, na musti nala isa verin tamata i wol nia a. Wean iki ni afamtahan, na ia musti notu vali wean inyai.” ");
INSERT INTO frd_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Tamata ovi baꞌi rera babahir kulu ra, rma vali ma Yohanes nbaptis ira. Ira rorat ne, “Tuan Guru, ami veka amotu afaka?” ");
INSERT INTO frd_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ia nfalak ne, “Deka myera ma nlia tali i fareta nfadoku roak a.” ");
INSERT INTO frd_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Suldadu ra rma vali ma rorat ne, “Ami veka amotu afaka?” Ia nfalak ne, “Deka mkyiwal tamata ra ma rala rira kubang verin mia, te deka fyasala tia ma watan tamata ra ma myala rira kubang ra. Fyikir watan ne, bira kadi naran roak ma byaꞌat.” ");
INSERT INTO frd_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Naꞌut inyai, na tamata ra rnaban lalawatan Raja i ntevut ita tali dida salasilan ra. Ira kaꞌi rorat watan naꞌa ralarira ra ne, “Yohanes ini, betane Raja i ntevut ita tali dida salasilan ra?” ");
INSERT INTO frd_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ba Yohanes nfalak verin ira ne, “Yaꞌa ubaptis mia ovu wear, naꞌuk Ia i veka nma a Ni ngrebat a nlia yaꞌa. Yaꞌa wol verang a ratang Ia, ba wol inovan lahir ma aling Ni tatea ni tatur ra. Ia veka nbaptis mia ovu Ni Roh a ovu vali yafu a. ");
INSERT INTO frd_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ia wean tamata isa i ntaha fanan lafan ma al ntafi wanat ra. Wanat vatul ovi lolin ra, nfadok-aling ira naꞌa wan i baꞌi rfadoku wanat ra naꞌa, naꞌuk ovi sian ra ovu kukan ra nasnuri ira naꞌa yafu i wol nmat-nala.” ");
INSERT INTO frd_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Naꞌut i Yohanes nfamalik Ubu Ni Ivar Lolin a, na nala snurak rivun verin tamata ra. ");
INSERT INTO frd_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ia ntabu Herodes i notu raja naꞌa Galilea, tevek nsifa ovu ifarn i Filipus awan a, naran Herodias. Yohanes ntabu vali Herodes naꞌa ni afa sian liak ovi notu ra munuk. ");
INSERT INTO frd_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ti nata, Herodes ntafal ma naktufan, ovu nala Yohanes ma nti buꞌi ralan. ");
INSERT INTO frd_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Naꞌut i Yohanes wol nanaꞌa buꞌi ralan obin, na ia nbaptis tamata ra, ovu nbaptis vali Yesus. Ti ma Yohanes nbaptis roak Yesus, na Yesus naflurut. Naꞌut i naflurut obin, na lanit ratan a natvadil, ");
INSERT INTO frd_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ovu Ubu Ni Roh a nsuta wean modarlaka ma ndoku Yesus tenan a. Nata vai isa ntali lanit ratan nma ma nfalak ne, “Oa ini Yanak i ulobang urun a. Oa motu ma ralang a lolin urun.” ");
INSERT INTO frd_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Naꞌut i Yesus betmane nfabana Ni karya a, na snain a Ni varat vututelu. Tamata ra ranovak ne, Yesus yaman verin Yusuf i yaman verin Eli. ");
INSERT INTO frd_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli yaman verin Matat, Matat yaman a verin Lewi, Lewi yaman a verin Malkhi, Malkhi yaman verin Yanai, Yanai yaman a verin Yusuf. ");
INSERT INTO frd_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yusuf yaman a verin Matica, Matica yaman a verin Amos, Amos yaman a verin Nahum, Nahum yaman a verin Hesli, Hesli yaman a verin Nagai, ");
INSERT INTO frd_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai yaman a verin Maat, Maat yaman a verin Matica. Matica yaman a verin Simei, Simei yaman a verin Yosekh, Yosekh yaman a verin Yoda, ");
INSERT INTO frd_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda yaman a verin Yohanan, Yohanan yaman a verin Resa, Resa yaman a verin Zerubabel, Zerubabel yaman a verin Sealtiel, Sealtiel yaman a verin Neri, ");
INSERT INTO frd_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri yaman a verin Malkhi, Malkhi yaman a verin Adi, Adi yaman a verin Kosam, Kosam yaman a verin Elmadam, Elmadam yaman a verin Er, ");
INSERT INTO frd_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er yaman a verin Yesua, Yesua yaman a verin Eliezer, Eliezer yaman a verin Yorim, Yorim yaman a verin Matat. ");
INSERT INTO frd_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat yaman a verin Lewi, Lewi yaman a verin Simeon, Simeon yaman a verin Yehuda, Yehuda yaman a verin Yusuf. Yusuf yaman a verin Yonam, Yonam yaman a verin Elyakim, ");
INSERT INTO frd_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Elyakim yaman a verin Melea, Melea yaman a verin Mina, Mina yaman a verin Matata, Matata yaman verin Natan, Natan yaman verin Daud, ");
INSERT INTO frd_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Daud yaman a verin Isai, Isai yaman a verin Obed, Obed yaman a verin Boas, Boas yaman a verin Salmon, Salmon yaman a verin Nahason, ");
INSERT INTO frd_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahason yaman a verin Aminadab, Aminadab yaman a verin Admin, Admin yaman a verin Arni, Arni yaman a verin Hezron, Hezron yaman a verin Peres, Peres yaman a verin Yehuda, ");
INSERT INTO frd_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yehuda yaman a verin Yakub, Yakub yaman a verin Ishak, Ishak yaman a verin Abraham, Abraham yaman a verin Terah, Terah yaman a verin Nahor, ");
INSERT INTO frd_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor yaman a verin Serug, Serug yaman a verin Rehu, Rehu yaman a verin Peleg, Peleg yaman a verin Eber, Eber yaman a verin Salmon. ");
INSERT INTO frd_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Salmon yaman a verin Kenan, Kenan yaman a verin Arpakhsad, Arpakhsad yaman a verin Sem, Sem yaman a verin Nuh, Nuh yaman a verin Lamekh, ");
INSERT INTO frd_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamekh yaman a verin Metusalah, Metusalah yaman a verin Henokh, Henokh yaman a verin Yared, Yared yaman a verin Mahalaleel, Mahalaleel yaman a verin Kenan, ");
INSERT INTO frd_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan yaman a verin Enos, Enos yaman a verin Set, Set yaman a verin Adam, Adam yaman a verin Ubu. ");
INSERT INTO frd_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ubu Ni Roh nleal roak Yesus, ba naꞌut i nban-talik oar Yordan a, na Ubu Ni Roh novun Ia nti wan lean vu dawan isa. ");
INSERT INTO frd_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Naꞌa wan yai, na nitdawan nlabir teman Yesus, ti naran amar vutfaꞌat. Naꞌut inyai, na Ia wol nafnaꞌan, ba nablafar urun. ");
INSERT INTO frd_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ba nitdawan nma ma nfalak ne, “Wean i Ubu Yanan urun Oa, na eka motu vatu ini naꞌa afamtahan ma muan.” ");
INSERT INTO frd_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesus nfalak ne, “Wol kena, tevek rtulis roak naꞌa Surat Ralan ne, ‘Tamata ra wol rvaꞌat tali afamtahan watan.’ ” ");
INSERT INTO frd_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Nitdawan novun ewal Yesus ma rti vuar karatat isa ni tutul a, ma brian munuk wean tkubak-tvelar watan matadida ra, na nfaturu negara ovi rnaꞌa lanit ivavan munuk verin Ia. ");
INSERT INTO frd_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ba nitdawan nfalak ne, “Yaꞌa veka ala munuk fareta ovu metan ra verin Oa, tevek ning munuk roak afa avyai, ovu bisma ala verin iki watan wean i ralang nfalak. ");
INSERT INTO frd_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ba wean i msangatur ma mraning yaꞌa, na veka ala munuk afa avyai verin Oa.” ");
INSERT INTO frd_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Naꞌuk Yesus nfalak verin ia ne, “Rtulis roak naꞌa Surat Ralan ne, ‘Msangatur ma mraning aꞌuk Duilaꞌa, mu Ubu i morang a.’ ” ");
INSERT INTO frd_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Nata nitdawan novun ewal Yesus ma rti Yerusalem, naꞌa Yahudi rira Rahan Dawan Falurut ni wan i karatat lia munuk a. Ia nfalak verin Yesus ne, “Wean i Ubu Yanan urun Oa, na eka muswatil tali ini msuta. ");
INSERT INTO frd_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","11","Tevek rtulis roak naꞌa Surat Ralan ne, ‘Ubu veka nfareta Ni sansinir ra tali lanit ratan ma rsiꞌik ma lolin Oa. Ira veka rvelar limarira ra ma rtada Oa, boma eam ra deka rkena vatu ra.’ ” ");
INSERT INTO frd_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yesus nfalak verin nitdawan ne, “Naꞌuk Ubu Ni vaivatul ra rfalak vali ne, ‘Tamata ra deka rlabir teman Duilaꞌa, tevek Ia Ubu i rorang a.’ ” ");
INSERT INTO frd_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ti ma nitdawan nlabir teman munuk roak Yesus, na nti talik Ia ma nanaban amar liak ewal. ");
INSERT INTO frd_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ubu Ni Roh a nleal roak Yesus, ma newal Ia nti propinsi Galilea. Yesus Ni ivar a ti nsoru munuk lahir wan yai. ");
INSERT INTO frd_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ia nsiair naꞌa rahan falurut ra, ba tamata ra munuk raraning Ia. ");
INSERT INTO frd_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yesus nti ahu Nazaret. Ia nleal wan yai tali Ni kakoꞌu, nata ti naran i dawan Ia. Naꞌut amar i tamata Yahudi ryari ira, na Yesus nti tamata Yahudi rira rahan falurut isa. Ia baꞌi notu wean inyai. Ia ndiri mane nbas Surat Ralan a. ");
INSERT INTO frd_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ba tamata isa nala nabi Yesaya ni buku lalulung a verin Yesus. Ti ma nvadil buku yai, na ntuan vaivatul ovi: ");
INSERT INTO frd_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Ubu Ni Roh a nleal Yaꞌa, ba wean inyai bi nfili Yaꞌa ma ufamalik Ni Ivar Lolin verin tamata ovi rira kasian ra. Ia nsinir Yaꞌa ma ufalak verin tamata ovi rkeak roak ira ne, rfatalik roak ira. Ia nsinir vali Yaꞌa ma otu ma tamata ovi rkibu ra rsirea ewal, ovu vali veka ufatalik tamata ovi tamata liak ra rwi-rwa ira. ");
INSERT INTO frd_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ia nsinir vali Yaꞌa ma ufamalik amar i Duilaꞌa veka nma ma nala Ni rala lolin a verin Ni tamata inorang ra.” ");
INSERT INTO frd_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ia nlulung ewal buku yai ma nala verin tamata i nkarya naꞌa rahan falurut yai, beti nti ndoku mane nsiair. Tamata ovi rnaꞌa rahan falurut yai rsiꞌik nanuang watan Ia. ");
INSERT INTO frd_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Yesus nair ira ma nfalak ne, “Amar ini Ubu nfakena vaivatul ovi mryenar tali Ni Surat Ralan yai.” ");
INSERT INTO frd_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Afa ovi Yesus nfalak ra rotu ma tamata ra munuk rtalkaka ovu inar urun Ia. Naꞌuk rira fikiran ratvali ewal ma rfalak ne, “Ia ini Yusuf yanan watan Ia!” ");
INSERT INTO frd_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ba Yesus nfalak verin ira ne, “Mia veka myala vaivatul kamkuma ini ma fyalak verin Yaꞌa ne, ‘Dokter, Oa bis motu ma tamata ra lolin ewal ira tali rira suhut ra, na eka motu lan tenam a. Amrenar ne, motu roak mujizat wean inyai naꞌa ahu Kapernaum, ba eka motu vali naꞌa mu ahu ini.’ ” ");
INSERT INTO frd_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Yesus nfalak vali ne, “Afa i ufalak verin mia ini, kena urun! Wol nabi isa vali ma ralang ia naꞌa ni ahu livur a. ");
INSERT INTO frd_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","26","Naꞌuk mryenar ma lolin afa ovi ufalak ini: Naꞌut i nabi Elia nvaꞌat obin, na wol daꞌut varat itelu vulan inean, ba lafar dawan nsoru munuk wan ovi rnaꞌa Israel. Naꞌut inyai, na vata varu rivun rnaꞌa Israel. Velik ne wean inyai, naꞌuk Ubu wol nsinir Elia ma nti nalola varu isa vali tali varu avyai. Naꞌuk Ubu nsinir ia ma nti nalola varu isa i naꞌa ahu i naran Sarfat. Ahu yai wol kaꞌi raroa tali kota Sidon. ");
INSERT INTO frd_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Wean vali inyai naꞌut i nabi Elisa nvaꞌat a, na tamata rivun naꞌa Israel rira suhut ngabaa. Naꞌuk Elisa wol notu ma tamata isa vali tali tamata avyai lolin ia tali ni suhut a. Ia notu aꞌuk ma Naaman i ntali Siria yai lolin ewal ia tali ni suhut ngabaa a.” ");
INSERT INTO frd_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Tamata ovi rnaꞌa rahan falurut yai rangrova urun Yesus naꞌut i rarenar afa ovi nfalak ra. ");
INSERT INTO frd_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ba rdiri lahir ma rtaha Yesus ma rovun Ia nti ahu yai murin a naꞌa vuar i rfadiri rira ahu naꞌa, ni biliꞌin a. Ira mane ralaꞌing vatuk Ia nsuta biliꞌin ralan yai. ");
INSERT INTO frd_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Naꞌuk Yesus nbana watan nahu tamata rivun avyai fruarira ra, ma nti talik wan yai. ");
INSERT INTO frd_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Nata Yesus nti Galilea ma nsiair naꞌa ahu Kapernaum. Ia nsiair naꞌut amar i tamata Yahudi ra ryari ira. ");
INSERT INTO frd_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Tamata ovi rarenar afa ovi nair ra rtalkaka lahir, tevek nsiair ovu Ubu Ni ngrebat a. ");
INSERT INTO frd_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Naꞌa Yahudi rira rahan falurut i naꞌa inyai, na tamata isa nait sian nleal ia, ba nafwak ovu vain dawan ne, ");
INSERT INTO frd_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Hoi Yesus tamata Nazaret! Oa mane motu afaka verin ami? Oa mwa ini mane fwedan ami? Yaꞌa ukaꞌa ne, iki Oa. Oa sansinir i ralam nmerat urun tali Ubu.” ");
INSERT INTO frd_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Naꞌuk Yesus ntabu lahir nait sian yai ovu vain dawan ma nfalak ne, “Deka vaim! Muti talik tamata ini!” Ba nait sian yai nfaleka tamata yai naꞌa tamata rivun waharira ralan ra, beti nti talik ia, naꞌuk wol not-nala ma tamata yai namngala. ");
INSERT INTO frd_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Tamata ra munuk rtalkaka, ba rsifalak afa verin ira ne, “Yesus Ni vaivatul avyai rangrebat urun! Ia Ni ngrebat ma nfareta nait sian ra, ma rti talik lahir tamata ra.” ");
INSERT INTO frd_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ba Yesus Ni ivar a ti nsoru munuk lahir wan inba watan naꞌa Galilea. ");
INSERT INTO frd_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesus nban-talik rahan falurut yai ma nti Simon ni rahan a. Naꞌa inyai, na Simon avan a nawar ma dawan ia ovu tenan ngnea urun, ba tamata ra rera lablobang tali Yesus ma nlobang ia. ");
INSERT INTO frd_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Nata Yesus nti ma ndir-ebang koꞌi i vata yai ntuba a, beti nfareta suhut yai ma nti talik vata yai, na suhut yai nti talik lahir ia. Ba nbatar lahir ma nasusan afamtahan verin Yesus ovu Ni tamata ovi rnaꞌa inyai ma raꞌan. ");
INSERT INTO frd_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ti ma lera nakduvul roak, na tamata ovi terarir-valirira ra rira suhut afaka watan rovun munuk ira rma verin Yesus. Ia nfadoku liman a naꞌa lokat tamata ma notu ma lolin ira tali rira suhut ra. ");
INSERT INTO frd_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Yesus naling vatuk nait sian ra tali tamata rivun, ba nait sian avyai rafwak ne, “Oa ini Ubu Yanan Oa!” Naꞌuk Yesus ntabu ira ovu vain dawan, ovu vali nfalak teri ma deka rafwak wean inyai, tevek rkaꞌa ne, Ia Raja i ntevut tamata rira salasilan ra. ");
INSERT INTO frd_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ti ma ilyan varverak sumatan, na Yesus nti talik ahu yai ma nti wan i wol tamata rnaꞌa, ma aksa Ia naꞌa inyai. Naꞌuk tamata rivun rdava ma rtuan roak Ia, ba rkiwal Ia ma deka nti talik ira. ");
INSERT INTO frd_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Naꞌuk Yesus nfalak verin ira ne, “Yaꞌa musti ufamalik Ubu Ni Ivar Lolin naꞌa kota liak ra vali ne, Ia nfareta tamata ra wean lahir Raja. Wean inyai bi nsinir Yaꞌa ma uma lanit ivavan ini.” ");
INSERT INTO frd_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ba Yesus nti ma nfamalik Ubu Ni Ivar Lolin naꞌa Yahudi rira rahan falurut ovi rnaꞌa propinsi Yudea. ");
INSERT INTO frd_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Amar isa, na Yesus ndiri danau Genesaret nelan a, na tamata rivun rma, tevek inar ma rarenar i nfamalik Ubu Ni vaivatul ra. Rivun ira, ba rdiri ma rsidekin ira. ");
INSERT INTO frd_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ia nsiꞌik kumal irua rnaꞌa danau yai nelan a. Tamata ovi baꞌi rdava ian ovu kumal irua yai rsuta roak ma rfamerat rira jaring ra. ");
INSERT INTO frd_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ia nrata Simon ni kumal a. Ba nsinir Simon ma nalaꞌing kumal yai nroal kedan a, beti ndoku ma nair tamata rivun avyai. ");
INSERT INTO frd_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ti ma nsiair munuk, na nfalak verin Simon ne, “Bwahi muroal wan i bilaman a ma fyasuka bira jaring ra, boma rala ian.” ");
INSERT INTO frd_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simon nfalak ne, “Tuan Guru, indean a, na amdava ian nata varverak nala ami, naꞌuk wol amwadar akataka. Naꞌuk Oa msinir ami, ba veka amfasuka ewal jaring ra.” ");
INSERT INTO frd_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ti ma rfasuka roak rira jaring ra, na rala ma ian rivun urun i lahir, ba rira jaring ra mulai ma ramsat roak. ");
INSERT INTO frd_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ba rotu faneak ovu limarira ra, boma rira kida ovi rnaꞌa kumal liak a rma ma rlobang ira. Ira rma ma irmunuk rfak ian avyai naꞌa kumal irua yai, ma ti nata sarseri mane rakduvul. ");
INSERT INTO frd_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simon i Yesus nfanara vali ia ne Petrus nsiꞌik afa yai, na nsangatur ma nsoak wahan a naꞌa Yesus wahan ralan a ma nfalak ne, “Duilaꞌa, muti talik yaꞌa, tevek tamata salasilan yaꞌa!” ");
INSERT INTO frd_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simon ovu ni kida avyai rtalkaka lahir, tevek rwadar urun i lahir. ");
INSERT INTO frd_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Simon ni kida Yakobus irua Yohanes i yamarira verin Zebedeus, rtalkaka vali. Yesus nfalak verin Simon ne, “Deka bwobar! Tali amar ini, na oa wol fwasuka jaring roak ma nala ian, tevek ala karya verin oa ma mair tamata ra ma rorang Yaꞌa.” ");
INSERT INTO frd_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ba Simon ovu ni kida ra resa rira kumal ra, beti rban-talik lahir rira afakataka munuk ma rorang Yesus. ");
INSERT INTO frd_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Amar isa, na Yesus nti kota isa. Naꞌa inyai, na tamata isa tenan a nngora lahir ovu suhut ngabaa. Naꞌut i nsiꞌik Yesus, na nsangatur ma wahan nkena lanun naꞌa Yesus wahan ralan a. Ia nera lablobang verin Yesus ne, “Duilaꞌa, wean i mtorung, na fara motu ma lolin ewal yaꞌa.” ");
INSERT INTO frd_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ba Yesus nlauk liman a ma nkena ia, beti nfalak ne, “Yaꞌa utorung ma ulobang oa, ba lolin roak oa!” Brian munuk, na tamata yai lolin lahir ia tali ni suhut a. ");
INSERT INTO frd_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Nata Yesus nfalak teri ma tamata yai deka nfamalik afa ini verin tamata iki watan, ovu nfalak vali ne, “Muti ma fwaturu tenam a verin Yahudi rira mela falurut a, ma nsiꞌik ne, lolin roak oa. Beti mala mu korban verin Ubu, wean i rfalak roak naꞌa Musa ni inukun ra, boma tamata ra rkaꞌa ne, lolin roak oa.” ");
INSERT INTO frd_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Naꞌuk ivar naꞌa afa ovi Yesus notu ra nti nsoru wan inba watan, ba tamata rivun rma ma rarenar afa ovi nair ra, ovu rera ma Ia notu ma lolin ewal ira tali rira suhut ra. ");
INSERT INTO frd_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Naꞌuk Yesus baꞌi nfaroa Ia tali ira ma nti wan i wol tamata rnaꞌa ma naflurut. ");
INSERT INTO frd_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Amar isa, naꞌut i Yesus nsiair, na tamata boku rtali sidovung Farisi ovu Yahudi rira dawan ovi rair Musa ni inukun ra rdoku vali inyai. Ira rtali ahu ovi rnaꞌa propinsi Galilea, propinsi Yudea ovu vali kota Yerusalem. Duilaꞌa Ni ngrebat a nanaꞌa Yesus ma notu ma tamata ovi rira suhut ra, lolin ewal ira. ");
INSERT INTO frd_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Naꞌut inyai, na tamata boku rovun tamata laklukut isa naꞌa ni dari i ntuba a. Ira rdava lingaꞌan fafira roak mane rovun tamata yai nti rahan ralan, boma rfanuba ia naꞌa Yesus wahan ralan a. ");
INSERT INTO frd_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Naꞌuk tamata rivun daꞌin rnaꞌa inyai, ba wol rovun nala ia nti rahan ralan. Ba ira rovun ia rarata rahan ratan, beti raꞌar rafat boku ma rtolar ia ovu ni dari a nsuta tamata rivun avyai fruarira ra, ma nanaꞌa lahir Yesus wahan ralan a. ");
INSERT INTO frd_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Naꞌut i Yesus nsiꞌik tamata avyai, na nkaꞌa ne, rira inorang a dawan, ba nfalak verin tamata laklukut yai ne, “Baba, fiang ini aꞌi vatuk roak mu salasilan ra.” ");
INSERT INTO frd_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Yahudi rira dawan ovi rair Musa ni inukun ra ovu tamata ovi rtali sidovung Farisi ranovak naꞌa ralarira ra ne, “Tamata ini iki Ia ma nfalak sian Ubu? Wol tamata isa bisma naꞌi vatuk tamata rira salasilan ra. Ubu saꞌi naꞌi vatuk.” ");
INSERT INTO frd_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Naꞌuk Yesus nkaꞌa lahir afa i ranovak naꞌa ralarira ra, ba nfalak verin ira ne, “Notu afakinimi minovak wean inyai naꞌa ralabira ra? ");
INSERT INTO frd_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Inabira ma ufalak verin tamata laklukut yai ne, ‘Aꞌi vatuk roak mu salasilan ra,’ te ufalak ne, ‘Mdiri ma bwana kikyai’? Afaka maraan ma ufalak naꞌa afa irua ini? ");
INSERT INTO frd_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Yaꞌa, Tamata Yanan Yaꞌa, mane ufaturu verin mia, boma mkyaꞌa ne, naꞌa lanit ivavan ini, na Yaꞌa, Tamata Yanan Yaꞌa Ning ngrebat ma aꞌi vatuk tamata rira salasilan ra.” Ba Yesus nfalak verin tamata laklukut yai ne, “Ufalak verin oa ma mdiri ovu mlulung mu dari a, ma mewal oa muti mu rahan kikyai!” ");
INSERT INTO frd_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Brian munuk, na tamata yai nbatar lahir ma nlulung ni dari a naꞌa waharira ralan ra, beti newal ia nti ni rahan. Naꞌa ni banbanan a, na nfadawang Ubu. ");
INSERT INTO frd_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Tamata ra munuk rtalkaka, ba rfadawang Ubu. Ira rbobar vali ma rfalak ne, “Amar ini, ita tsiꞌik lahir afa ovi tamata ra wol rot-nala!” ");
INSERT INTO frd_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","28","Nata Yesus nban-talik wan yai ma nati murin, na nsiꞌik tamata isa i baꞌi nera babahir kulu, naran Lewi. Tamata yai ndoku rahan i baꞌi rera babahir kulu naꞌa. Yesus nfalak verin ia ne, “Morang Yaꞌa!” Ba Lewi ndiri ma nban-talik lahir ni karya ma norang Yesus. ");
INSERT INTO frd_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Lewi notu snoba dawan verin Yesus naꞌa ni rahan a. Tamata rivun ovi baꞌi rera babahir kulu ovu tamata liak ra rma ma irmunuk rafnaꞌan ovu Yesus. ");
INSERT INTO frd_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ti ma tamata Farisi ra ovu rira dawan ovi rair Musa ni inukun ra rsiꞌik afa avyai, na rorat Yesus Ni tamata ra ne, “Notu afakinimi mifnaꞌan-mifnenu ovu tamata ovi baꞌi rera babahir kulu ra, ovu tamata salasilan ra?” ");
INSERT INTO frd_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesus nfalak verin ira ne, “Tamata ovi wol rira suhut ra wol rti dokter, naꞌuk tamata ovi rira suhut ra aꞌuk saꞌi rti dokter. ");
INSERT INTO frd_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Yaꞌa wol uma ma era tamata ovi rira vavaꞌat ra rmalola, naꞌuk uma ma era tamata salasilan ra, boma rahil ma rtalik tali rira salasilan ra.” ");
INSERT INTO frd_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Tamata boku rfalak vali verin Yesus ne, “Tamata ovi rorang Yohanes i nbaptis tamata ra baꞌi rtolat ovu raflurut. Tamata ovi rtali sidovung Farisi a rtolat ovu raflurut vali wean inyai. Naꞌuk Mu tamata ovi rorang Oa rafnaꞌan ovu rafnenu.” ");
INSERT INTO frd_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesus nala vaivatul kamkuma ma nfalak verin ira ne, “Naꞌa snobsifa isa, wean i brana i mane nsifa irmunuk ni kida ra obin, na musti rtolat? Wahal! ");
INSERT INTO frd_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Naꞌuk ni amar veka nma, ma tamata ra rala brana i mane nsifa yai tali ni kida ra. Naꞌut inyai, beti rtolat.” ");
INSERT INTO frd_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yesus nala vaivatul kamkuma isa ewal ma nfalak vali ne, “Wol tamata isa nkamsat ravit ngorvaꞌan isa ma nlavan naꞌa ravit i mnanat a. Wean i notu wean inyai, na ravit ngorvaꞌan yai namsat, ovu vali ravit i mnanat yai wol inovan ovu maloli i rlavan naꞌa. ");
INSERT INTO frd_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","38","Wean vali inyai, na wol tamata isa vali nliꞌi anggur ngorvaꞌan naꞌa sadawan mnanat i rotu tali karba ulin a, tevek anggur ngorvaꞌan yai veka notu ma sadawan yai naksat ma anggur a nvoak munuk, ovu sadawan veka nakvisal lahir. Ba musti tliꞌi anggur ngorvaꞌan a naꞌa sadawan ngorvaꞌan vali. ");
INSERT INTO frd_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Wol tamata isa inan ma nenu anggur ngorvaꞌan, wean i nenu roak anggur i mnanat a, tevek ia veka nfalak ne, ‘Anggur i mnanat yai manminak lia anggur i ngorvaꞌan a.’ ” ");
INSERT INTO frd_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Amar isa naꞌut i Yahudi ra ryari ira, na Yesus ovu Ni tamata ovi rorang Ia rban-etal vaꞌi gandum ra. Ni tamata ra rfufu gandum ni funu boku, ma rsufak ovu limarira ra, beti raꞌan ihin ra. ");
INSERT INTO frd_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Naꞌuk tamata Farisi boku rfalak ne, “Afakinimi myangal dida agama ni inukun ra, ma myotu afa i wol bisma totu naꞌa amar i tyari ita?” ");
INSERT INTO frd_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesus nfalak verin ira ne, “Mia byas roak afa ovi Raja Daud notu ra, naꞌut i ia ovu ni tamata ovi rorang ia rablafar. ");
INSERT INTO frd_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ia nti befak dawan i baꞌi raraning Ubu naꞌa. Ia nti ralan ma nala roti ovi rala roak ma neluk korban verin Ubu ma naꞌan. Nata ntanang vali roti avyai verin ni tamata ovi rorang ia, velik ne naꞌa dida agama ni inukun ra rfalak ne, mela falurut ra watan saꞌi bisma raꞌan roti avyai.” ");
INSERT INTO frd_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yesus nfalak vali verin ira ne, “Yaꞌa, Tamata Yanan Yaꞌa, ba Ning fareta a ti naran vali amar i tyari ita.” ");
INSERT INTO frd_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Amar isa vali naꞌut i Yahudi ra ryari ira, na Yesus nti rira rahan falurut isa ma nsiair. Naꞌa inyai, na brana isa liman mela nmata. ");
INSERT INTO frd_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Yahudi rira dawan ovi rair Musa ni inukun ra, ovu tamata Farisi ra rsiꞌik nanuang Ia, betane notu ma lolin tamata ra naꞌa amar i ryari ira, boma rmangadu Ia. ");
INSERT INTO frd_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Naꞌuk Ia nkaꞌa lahir afa ovi ranovak naꞌa ralarira ra, ba nfalak verin brana i liman nmata yai ne, “Mwa ma mdiri tamata ovi rnaꞌa ini waharira ralan ra!” Ba brana yai ti ndiri tamata ovi rnaꞌa inyai waharira ralan ra. ");
INSERT INTO frd_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ba Yesus norat ira ne, “Dida agama ni inukun ra rfalak ma bis totu afaka naꞌut amar i tyari ita? Totu afa ovi lolin ra, te afa ovi sian ra? Tlobang tamata ra ma rvaꞌat, te tfedan ira?” ");
INSERT INTO frd_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ia nfalak munuk wean inyai, beti nsiꞌik lilit ira munuk ma nfalak verin brana yai ne, “Mlauk limam a mwa!” Ia not-orang afa i Yesus nfalak a, ba liman a lolin lahir. ");
INSERT INTO frd_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Yahudi rira dawan ovi rair Musa ni inukun ra ovu tamata Farisi avyai rangrova urun i lahir, ba rfamalik afa ini ma ranovak ne, veka rotu afaka verin Yesus. ");
INSERT INTO frd_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Amar isa, na Yesus nrata vuar isa ma naflurut verin Ubu. Ovan lolan yai, na Ia naflurut lalawatan. ");
INSERT INTO frd_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ti ma lyawan roak, na nera Ni tamata ovi rorang Ia, beti nfili tamata vutu rahin irua tali tamata avyai ma reluk Ni rasul ra. ");
INSERT INTO frd_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Tamata avyai nararira ra: Simon i Yesus nfanara vali ia ne, Petrus. Ia ovu warin a naran Andreas. Liak ra nararira ra: Yakobus, Yohanes, Filipus ovu Bartolomeus, ");
INSERT INTO frd_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matius ovu Tomas, Yakobus i yaman a verin Alfeus, ovu Simon i rfanara ia ne Zelot, ");
INSERT INTO frd_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yudas i yaman a verin Yakobus, ovu vali Yudas Iskariot i nfedi Yesus. ");
INSERT INTO frd_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesus ovu Ni tamata ovi rorang Ia rsuta tali vuar yai ma rwelat wan manesan isa. Tamata rivun ovi rorang Yesus rnaꞌa vali inyai. Tamata liak rivun ilaꞌa rnaꞌa vali inyai. Boku rtali wan ovi rnaꞌa propinsi Yudea, ovu boku rtali kota Yerusalem. Boku vali rtali kota Tirus ovu Sidon. Kota irua yai rebang tahat. ");
INSERT INTO frd_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Tamata avyai rma ma rarenar afa ovi Yesus nair ra, ovu rera ma notu ma lolin ewal ira tali rira suhut ra. Tamata ovi nait sian ra rleal ira rma vali, ma Yesus naling vatuk nait sian avyai tali ira. ");
INSERT INTO frd_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ba tamata avyai rdava lingaꞌan mane rkena Yesus, tevek ngrebat i nvotuk tali tenan a notu ma lolin munuk ira tali rira suhut ra. ");
INSERT INTO frd_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesus nsiꞌik Ni tamata ovi rorang Ia ma nfalak ne, “Ubu naflahar mia, tamata ovi bira kasian a dawan, tevek Ia wean lahir Raja ma nfareta mia, tamata ovi myorang Ia. ");
INSERT INTO frd_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ubu naflahar mia, tamata ovi fiang ini miblafar, tevek Ia veka notu ma evubira ra rveda. Ubu naflahar mia, tamata ovi fiang ini byakar, tevek Ia veka nfaloling ralabira ra. ");
INSERT INTO frd_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ubu naflahar mia naꞌut i tamata ra wol inar lahir mia, rfalak sian mia, ralaꞌing vatuk mia ovu vali rfangra narabira ra, tevek myorang Yaꞌa, Tamata Yanan a. ");
INSERT INTO frd_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Lalan ana, uburir-nusirira ra rwi-rwa Ubu Ni nabi ra wean vali inyai. Ba ti ma rotu mia wean inyai vali, na ralabira lolin watan, tevek Ia veka naval ma dawan mia naꞌa bira rala lolin a, naꞌa lanit ratan. ");
INSERT INTO frd_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Naꞌuk sian urun i lahir verin tamata ovi fiang ini mkyaꞌi roak a, tevek myotu roak inabira lolin ovu bira metan ra. ");
INSERT INTO frd_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Sian urun i lahir verin tamata ovi fiang ini evubira ra rveda, tevek mia veka miblafar urun. Sian urun i lahir verin tamata ovi fiang ini myalit, tevek mia veka ralabira lalau urun ovu byakar. ");
INSERT INTO frd_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Sian urun i lahir verin tamata ovi fiang ini tamata ra munuk rfadawang mia, tevek lan ana, ububir-nusibira ra rotu roak wean inyai verin nabi siklabir ra.” ");
INSERT INTO frd_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Naꞌuk tamata ovi fiang ini mryenar Yaꞌa, na ufalak verin mia ne, mlyobang tamata ovi rira sian mia, ovu myotu lolin a verin tamata ovi wol inar lahir mia. ");
INSERT INTO frd_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Myera verin Ubu ma naflahar tamata ovi rear rfasoba mia. Miflurut vali verin tamata ovi rotu sian mia. ");
INSERT INTO frd_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Wean i tamata isa ntafitil fifim mela a, na mala vali fifim balit a ma ntafitil, ovu wean i tamata isa nala mu ravit blawat a, na mala vali mu ravit a verin ia. ");
INSERT INTO frd_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Wean i tamata isa nera afa tali mia, na myala verin ia, ovu wean i tamata boku rkiwal ma rala bira metan ra, na deka myera ewal tali ira. ");
INSERT INTO frd_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Wean i inabira ma tamata ra rotu lolin mia, na myotu lolin vali tamata ra. ");
INSERT INTO frd_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Wean i mlyobang watan tamata ovi rlobang mia, na Ubu veka wol nfadawang mia, tevek tamata salasilan ra rlobang vali tamata ovi rlobang ira. ");
INSERT INTO frd_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Wean i myotu lolin tamata ovi rotu lolin mia, na Ubu veka wol nfadawang mia, tevek tamata salasilan ra rotu lolin vali tamata ovi rotu lolin ira. ");
INSERT INTO frd_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Wean i kaꞌi myal-teri bira kubang verin tamata liak, tevek fyikir ne, veka ral-ewal kubang yai munuk verin mia, na Ubu veka wol nfadawang mia. Tamata salasilan ra rotu vali wean inyai verin rira kida ra, tevek rorang ne, veka ral-ewal rira kubang ra. ");
INSERT INTO frd_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Naꞌuk mia deka myotu wean inyai! Mia musti mlyobang tamata ovi rira sian mia ovu myotu lolin ira. Myal-teri bira kubang verin tamata liak, naꞌuk deka fyikir ne, veka ral-ewal verin mia. Myotu wean inyai, na Ubu veka naval ma dawan bira rala lolin a, ovu vali afa ovi myotu yai nfaturu ne, Ubu i Ni dawan nlia munuk afakataka yanan mia, tevek Ia notu lolin tamata ovi wol rkaꞌa ma rfalak fara weninyai, ovu vali tamata ktufan ra. ");
INSERT INTO frd_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ba fara fyaturu bira rala lolin verin tamata ra, wean lahir Yamabira nfaturu Ni rala lolin a verin tamata ra munuk.” ");
INSERT INTO frd_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Deka fyasala tamata ra, boma Ubu deka nfaleka inukun verin mia. Deka myukun tamata ra, boma Ubu deka nukun mia. Naꞌuk myabun tamata ovi rotu salasilan verin mia, boma Ubu veka naꞌi vatuk vali bira salasilan ra. ");
INSERT INTO frd_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Myala bira afaka watan verin tamata ra, na Ubu veka nala vali verin mia. Wean tamata i nala wanat kadut isa verin oa. Ia nfak wanat naꞌa kadut ma nngora, beti nayaꞌuk ma ntafal ma nngora, ma wanat boku rvoat. Tevek afa i myala al myukur tamata ra, Ubu veka nala vali al nukur mia.” ");
INSERT INTO frd_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesus nfalak vali vaivatul kamkuma isa verin ira ne, “Wean i tamata kibu isa nfabana tamata kibu liak, na irua veka rleka rsuta bilaman ralan. ");
INSERT INTO frd_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Wol tamata isa ni dawan nlia ni guru a, naꞌuk wean i iki watan nair munuk ma nkaꞌa roak afa ovi musti nair ra, na ia veka wean lahir ni guru a. ");
INSERT INTO frd_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Notu afakinimi msyiꞌik aa mumun i naꞌa terabira isa matan a, naꞌuk wol msyiꞌik nala aa etal dawan i naꞌa matabira ra? ");
INSERT INTO frd_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Wean inba ma fyalak verin terabira yai ne, ‘Mwa ma aling vatuk aa mumun i naꞌa matam a,’ naꞌuk aa etal dawan a nanaꞌa matabira obin? Hoi, mia fyalak afa isa, naꞌuk myotu afa liak! Eka myaling vatuk aa etal dawan yai tali matabira ra veki, boma msyirea ma lolin, beti myaling vatuk aa mumun i tali terabira yai matan a.” ");
INSERT INTO frd_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Aa ovi lolin ra, vuarira ra wol sian, ovu aa ovi sian ra, vuarira ra veka wol lolin. ");
INSERT INTO frd_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ita tkaꞌa lokat aa tali vuan a. Tamata ra wol rfufu aa ara vuan ra naꞌa karwamus ralan, ovu vali wol rfufu anggur vuan ra naꞌa kadkadir ralan. ");
INSERT INTO frd_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Wean vali inyai verin tamata ra. Tamata ovi ralarira lolin veka rotu watan afa ovi lolin ra, tevek ralarira ra rngora lahir ovu afa ovi lolin ra. Naꞌuk tamata ovi raktufan ra rfamalik aꞌuk afa sian ra, tevek ranovak lalawatan naꞌa afa avyai. Vaivatul ovi rtali tamata sumarira ra rfaturu lahir ralarira ra.” ");
INSERT INTO frd_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Afakinimi mifwak Yaꞌa ne, ‘Duilaꞌa, Duilaꞌa,’ naꞌuk wol myot-orang afa ovi ufalak ra? ");
INSERT INTO frd_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Yaꞌa ala vaivatul kamkuma ma ufamalik tamata ovi rma ma rarenar ovu rot-orang afa ovi ufalak ra. ");
INSERT INTO frd_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Tamata avyai wearira tamata i mane nfadiri rahan isa. Ia nkear ma lanun a blaman, beti nfadoku ni fanderen a naꞌa vatu ratan. Ti ma wear dawan a nma ma ni oar dawan nkena rahan yai, na wol nawelu, tevek nfadiri naꞌa fanderen i nangrebat urun a. ");
INSERT INTO frd_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Naꞌuk tamata iki watan nrenar afa ovi ufalak ra ma wol not-orang, na ia wean tamata i nfadiri rahan isa naꞌa lanun, naꞌuk wol ni fanderen. Ti ma wear dawan nma ma ni oar dawan nkena rahan yai, na nleka ma namaꞌar munuk lahir.” ");
INSERT INTO frd_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ti ma Yesus nangrihi munuk verin tamata rivun ovi rnaꞌa inyai, na nti Kapernaum. ");
INSERT INTO frd_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Naꞌa inyai, na Roma rira suldadu dawan isa, ni tamata sansinir nawar ma dawan ia ovu sarseri mane nmata. Ia nlobang urun ni sansinir yai. ");
INSERT INTO frd_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Naꞌut i nrenar ne Yesus nanaꞌa inyai, na nsinir lahir dawan Yahudi boku ma ti rtuan Yesus, boma rera ma nma ma notu ma lolin ewal ni tamata sansinir yai. ");
INSERT INTO frd_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Ba ira rma ma rtuan Yesus ma rera lablobang verin Ia, ma rfalak ne, “Bapa, kena urun ma mlobang Roma rira dawan eri, tevek ia nlobang urun dida bangsa a, ovu vali nfadiri mami rahan falurut a.” ");
INSERT INTO frd_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ba irmunuk Yesus rati. Naꞌut i rfaseri roak suldadu dawan yai ni rahan a, na nsinir ni kida ra ma ti rfalak verin Yesus ne, “Bapa, yaꞌa wol verang a ratang Oa, ba deka fwafrea Oa ma mwa ning rahan a. ");
INSERT INTO frd_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Wean inyai bi wol ubrahi ma utuan Oa, tevek wol verang a ratang Oa. Ba fwalak watan vaivatul isa, na ning tamata sansinir a veka lolin lahir ia. ");
INSERT INTO frd_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ukaꞌa lahir ne, afa ovi fwalak ra kena, tevek usoak vali verin ning dawan a, ovu suldadu ra rsoak vali verin yaꞌa. Wean i ufareta suldadu isa ma ufalak ne, ‘Muti,’ na ia nti. Wean i ufalak verin isa vali ne, ‘Mwa,’ na ia nma, te ufalak verin ning tamata sansinir a ne, ‘Mkarya afa ini,’ na ia notu!” ");
INSERT INTO frd_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesus ntalkaka naꞌut i nrenar vaivatul avyai. Nata Ia ntamuri ma nfalak verin tamata rivun ovi rorang Ia ne, “Mryenar ma lolin afa i ufalak ini! Wol utuan tamata isa obin ni inorang a dawan wean tamata ini, velik ne nanaꞌa vali tamata Israel ra!” ");
INSERT INTO frd_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ti ma tamata ovi nsinir ira yai rewal ira rti suldadu dawan yai ni rahan a, na tamata sansinir yai lolin ewal roak ia. ");
INSERT INTO frd_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ti ma wol mnanat, na Yesus ovu Ni tamata ovi rorang Ia rti kota isa naran Nain. Tamata rivun rban-orang vali Ia. ");
INSERT INTO frd_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ti ma rfaseri roak kota yai ni falfolat ilaꞌa ni fidu a, na rtuan tamata ra rvara tamata matmatan isa ntali kota yai mane rti murin. Matmatan yai vata varu isa yanan a brana ikisa laloꞌi watan. Tamata rivun tali kota yai rovu vali varu yai. ");
INSERT INTO frd_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ti ma Duilaꞌa Yesus nsiꞌik varu yai, na nfarnuang lahir naꞌa ralan ma nfaturu Ni silobang verin ia, ba nfalak verin ia ne, “Deka bwakar!” ");
INSERT INTO frd_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Nata Yesus ti ma nkena boban i matmatan ntuba naꞌa, na tamata avyai rdir-teri lahir. Ia nfalak ne, “Baba, ufalak lahir verin oa ne, bwatar kikyai!” ");
INSERT INTO frd_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Varverun i nmata yai nbatar lahir ma ndoku ovu nangrihi, na Yesus nala ia verin renan a. ");
INSERT INTO frd_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Tamata rivun avyai rbobar urun, ovu rfadawang Ubu ma rfalak ne, “Nabi dawan nma roak ma nanaꞌa fruadida ra,” ovu “Ubu nma roak ma nlobang Ni tamata ra!” ");
INSERT INTO frd_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ba Yesus Ni ivar a ti nsoru munuk ahu ovi rnaꞌa propinsi Yudea, ovu wan ovi rnaꞌa ebang inyai. ");
INSERT INTO frd_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Tamata ovi rorang Yohanes i nbaptis tamata ra rfamalik afa avyai verin ia, na nera tamata irua tali ira. ");
INSERT INTO frd_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ia nsinir ira rti ma rtuan Duilaꞌa Yesus ma rorat Ia ne, “Bapa, Oa ini Raja i veka mtevut mami salasilan ra, wean i Ubu nfadoku roak naꞌa Ni tnorung a, te musti amnaban tamata liak?” ");
INSERT INTO frd_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Tamata irua yai rti ma rtuan Yesus ma rfalak verin Ia ne, “Yohanes i nbaptis tamata ra nsinir ami ma amorat Oa ne, Oa ini Raja i veka mtevut mami salasilan ra, te ami musti amnaban tamata liak?” ");
INSERT INTO frd_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Naꞌut inyai vali, na Yesus notu ma lolin ewal tamata rivun tali rira suhut ra. Ia naling vatuk nait sian ra tali tamata ra, ovu notu vali ma tamata ovi rkibu ra rsirea ewal. ");
INSERT INTO frd_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ba Yesus nfalak verin ira ne, “Myewal mia ma fyamalik verin Yohanes naꞌa afa ovi mryenar, ovu afa ovi msyiꞌik ra. Tamata ovi rkibu rsirea ewal, tamata ovi raklukut rbana nala ewal, tamata ovi rira suhut ngabaa lolin ewal ira, ovu tamata ovi raktun, rafrenar ewal. Tamata ovi rmata roak rvaꞌat ewal, ovu ufamalik Ubu Ni Ivar Lolin verin tamata kasian ra. ");
INSERT INTO frd_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ubu naflahar tamata ovi ralarira ra wol raruan naꞌa rira inorang verin Yaꞌa.” ");
INSERT INTO frd_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ti ma Yohanes ni tamata ra rban-talik wan yai, na Yesus nfamalik Yohanes verin tamata rivun ovi rnaꞌa inyai. Ia nfalak ne, “Naꞌut i miti wan lean vu dawan ma msyiꞌik Yohanes, na minovak aka? Miti ma msyiꞌik tavtevu ovi nait nean tia ma watan ira a? Wahal! ");
INSERT INTO frd_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Inabira ma ti msyiꞌik aka? Beta ne inabira ma ti msyiꞌik tamata isa i neluk kadaravit ovi lolin urun a? Wahal, tevek tamata ovi reluk kadaravit lolin ra, ovu rvaꞌat ovu rira metan rivun rleal raja rira rahan ra. ");
INSERT INTO frd_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Inabira ma ti msyiꞌik aka? Beta ne inabira ma msyiꞌik nabi isa? Wean inyai, na kena lahir, ovu Yohanes ni dawan a nlia nabi ra. ");
INSERT INTO frd_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Tevek lan ana, Ubu nfamalik ma dawan ia naꞌa Ni Surat Ralan a, ma nfalak ne, ‘Ini Yaꞌa Ning tamata sansinir ini, Yaꞌa usinir lan ia beti Oa, ma nasusan Mu lingaꞌan a.’ ” ");
INSERT INTO frd_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yesus nfalak vali ne, “Mingnanang! Tali lalan ma naran amar ini, wol tamata isa vali ni dawan a veran lia Yohanes. Naꞌuk tamata ovi rtorung ma Ubu nfareta rira vavaꞌat ra, na rira dawan a nlia Yohanes, velik ne tamata koꞌu ira watan.” ");
INSERT INTO frd_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Tamata avyai munuk, ovu tamata ovi baꞌi rera babahir kulu, rarenar afa ovi Yesus nfalak ra. Ira rtorung ne, Ubu kena Ia, tevek Yohanes nbaptis roak ira. ");
INSERT INTO frd_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Naꞌuk tamata Farisi ra ovu Yahudi rira dawan ovi rair Musa ni inukun ra, wol rtorung afa ovi Ubu ralan nfalak ma notu naꞌa rira vavaꞌat ra, tevek rafena ma Yohanes nbaptis ira. ");
INSERT INTO frd_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ba Yesus nfalak ewal vali ne, “Yaꞌa veka ala vaivatul kamkuma aka ma ufamalik tamata ovi rvaꞌat naꞌa tuvu ini? ");
INSERT INTO frd_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ira wearira kasikoꞌu ovi rdoku naꞌa wan i rfedi-rfaha afa naꞌa, ma rafwak rira kida ra ne, ‘Amafraik floꞌits verin mia, naꞌuk mifena ma msyoꞌi-msyomar. Amdedang dadedang ovi lalau ra, naꞌuk wol byakar.’ ");
INSERT INTO frd_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Wean inyai vali verin Yohanes i nbaptis tamata ra. Ia nma ma ntolat ma wol nafnaꞌan ovu wol nenu anggur. Mia mifena ia ma fyalak ne, ‘Nait sian nleal ia.’ ");
INSERT INTO frd_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Yaꞌa, Tamata Yanan Yaꞌa, uma ma ufnaꞌan ovu ufnenu, ba fyalak ne, ‘Ia nafnaꞌan sian, baꞌi nanavut, notu kida ovu tamata ovi baꞌi rera babahir kulu ra, ovu vali notu kida ovu tamata salasilan ra.’ ");
INSERT INTO frd_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Naꞌuk velik ne wean inyai, tali afa lolin ovi Ni tamata ra munuk rotu, na nfaturu ne, Ubu Ni kakaꞌa dawan a kena.” ");
INSERT INTO frd_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Amar isa, na tamata Farisi isa nasweang Yesus ma nma ma nafnaꞌan naꞌa ni rahan a. Ba Yesus nti ni rahan ma nafnaꞌan. ");
INSERT INTO frd_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Vata isa notu salasilan rivun naꞌa kota yai. Ti ma vata yai nkaꞌa ne, Yesus nafnaꞌan naꞌa tamata Farisi yai ni rahan a, na ntaha botal koꞌu isa i rotu tali vatu lolin isa naran pualam ma nti inyai. Botal yai nsaꞌa ngul i voan a lolin urun. ");
INSERT INTO frd_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Vata yai ti ndiri Yesus murin a ma nebang lahir Yesus ean a. Ia nvakar ma lun ra rditi naꞌa Yesus ean a, beti naꞌi lun ra ovu ni vut a. Notu munuk wean inyai, beti nvoan Yesus ean a ovu vali naꞌung ngul yaꞌi naꞌa ean a. ");
INSERT INTO frd_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ti ma tamata Farisi i nasweang Yesus nsiꞌik afa yai, na nfalak naꞌa ralan a ne, “Tamata ini wol nabi Ia, tevek wol nkaꞌa lahir ne, vata i nkena Ia ini, notu salasilan rivun.” ");
INSERT INTO frd_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ba Yesus nfalak verin tamata Farisi yai ne, “Simon, mane ufalak afa isa verin oa.” Simon nfalak ne, “Fwalak ta Tuan Guru.” ");
INSERT INTO frd_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yesus nfalak ne, “Tamata irua rira utan naꞌa tamata i baꞌi nal-teri kubang verin tamata ra. Tamata isa ni utan kubang dinar ratut ilima, na isa vali ni utan kubang dinar vutlima. ");
INSERT INTO frd_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Tamata irua ini wol rbahir nala rira utan a, ba tamata i nal-teri kubang verin ira yai naꞌi vatuk munuk rira utan a. Tali tamata irua yai, na iki ni silobang a dawan lia verin tamata i nal-teri roak kubang verin ira yai?” ");
INSERT INTO frd_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon nfalak ne, “Yaꞌa ufikir ne, tamata i ni utan dawan lia ni kida yai.” Yesus nfalak ne, “Mu fikiran a kena.” ");
INSERT INTO frd_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Yesus nfulak wahan a ma nsiꞌik vata yai, beti nfalak verin Simon ne, “Eka msiꞌik vata ini. Oa musweang Yaꞌa ma uma roak mu rahan ini, naꞌuk wol mala vali wear ma uraming eang ra. Vata ini nvakar ma lun ra rditi naꞌa eang a, beti naꞌi eang a ovu ni vut a. ");
INSERT INTO frd_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Inlangin uma mu rahan a, na wol bwoan Yaꞌa. Naꞌuk tali inlangin a, na vata ini nvoan lalawatan eang a. ");
INSERT INTO frd_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Oa wol mliꞌi ngul naꞌa ulung a, naꞌuk ia nliꞌi ngul i voan a lolin urun a naꞌa eang a. ");
INSERT INTO frd_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ba ufalak verin oa ne, ni silobang i dawan yai nfaturu ne, Ubu naꞌi vatuk roak ni salasilan ra! Naꞌuk wean i tamata isa ni salasilan kedan a watan ma Ubu naꞌi vatuk roak ni salasilan avyai, na ni silobang a kedan watan vali.” ");
INSERT INTO frd_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Nata Yesus nfalak verin vata yai ne, “Yaꞌa aꞌi vatuk roak mu salasilan ra.” ");
INSERT INTO frd_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Tamata ovi rdoku ma rafnaꞌan ovu Yesus ranovak naꞌa ralarira ra ne, “Ini tamata iki ma nabrahi ma nfalak ne, Ia naꞌi vatuk nala tamata rira salasilan ra?” ");
INSERT INTO frd_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Yesus nfalak vali verin vata yai ne, “Mu inorang verin Yaꞌa notu ma Ubu nsikat roak oa tali mu salasilan ra, boma wol mwata kakiwal. Ba mewal oa ovu malinan watan!” ");
INSERT INTO frd_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Wol mnanat, na Yesus nban-lilit tali kota nti kota, ovu ahu nti ahu, ma nfamalik Ubu Ni Ivar Lolin ne, Ubu nfareta tamata ra wean lahir Raja. Ni tamata vutu rahin irua yai rorang Ia. ");
INSERT INTO frd_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Vata ovi Yesus naling vatuk roak nait sian ra ovu notu ma lolin ira tali rira suhut ra, rorang vali Ia. Vata avyai, isa naran Maria i baꞌi rera ia ne Magdalena. Yesus naling vatuk roak nait sian ifitu tali ia. ");
INSERT INTO frd_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Vata isa vali naran Yohana i awan verin Khuza. Khuza ini baꞌi nasusan Herodes ni kubang ra. Vata isa vali naran Susana, ovu vata liak ra rivun vali rorang Yesus. Vata avyai rala rira kubang ma rlobang Yesus ovu Ni tamata ovi rorang Ia. ");
INSERT INTO frd_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Tamata rivun ilaꞌa tali ahu rivun rma ma rasdovu ira ma rarenar afa ovi Yesus nfalak ra. Ba Yesus nala vaivatul kamkuma isa ma nfalak verin ira ne, ");
INSERT INTO frd_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Amar isa, na tamata vaꞌi isa ti ma navuri nabat ra. Naꞌut i navuri nabat ra, na boku rleka naꞌa lingaꞌan ralan ma tamata ra rbana ma rta watan ira, ovu manut nangan ra raꞌan vali boku. ");
INSERT INTO frd_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Nabat boku rleka vali naꞌa vatralan i lanun kadkedan watan, ba ti ma rarubu, na rakla ma rangaran lahir, tevek lanun yai near watan. ");
INSERT INTO frd_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Nabat boku vali rleka naꞌa kadkadir ralan. Kadkadir avyai rmel-yatak irubun ra, ma irubun ra rmata. ");
INSERT INTO frd_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Naꞌuk nabat boku rleka naꞌa lanun tinemun, ba ti ma rarubu, na vuar ma faratratut.” Yesus nfamalik munuk vaivatul kamkuma yai, na vain a dawan ma nfalak ne, “Iki arun, na eka nrenar ma lolin!” ");
INSERT INTO frd_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Yesus Ni tamata ovi rorang Ia rorat ne, “Vaivatul kamkuma yai ihin aka?” ");
INSERT INTO frd_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ba Yesus nfalak verin ira ne, “Ubu notu ma fyan-aran afa ovi Ia wol nfavotuk obin verin tamata ra, naꞌa i wean inba ma nfareta tamata ra wean lahir Raja. Naꞌuk verin tamata liak ra, na air ira ovu vaivatul kamkuma ra, boma velik ne rsiꞌik afa ovi otu ra, naꞌuk wol rarea afa avyai. Rarenar Ning vaivatul ra, naꞌuk wol rfan-aran vali. ");
INSERT INTO frd_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Vaivatul kamkuma yai ihin a wean ini: nabat avyai rfaturu Ubu Ni vaivatul ra. ");
INSERT INTO frd_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Nabat ovi rleka naꞌa lingaꞌan ralan rfaturu tamata ovi rarenar roak Ubu Ni vaivatul ra, na nitdawan nma ma nal-ewal vaivatul avyai ma wol rnaꞌa ralarira ra. Nitdawan notu wean inyai, boma tamata avyai deka rorang Ubu, ovu Ubu wol nsikat ira tali rira salasilan ra, boma deka rira vavaꞌat kakiwal. ");
INSERT INTO frd_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Nabat ovi rleka naꞌa vatralan i lanun kadkedan watan a, rfaturu tamata ovi rarenar roak Ubu Ni vaivatul ra ma rtorung ovu ralarira lolin naꞌut i rarenar vaivatul avyai. Naꞌuk vaivatul avyai wol rabwaꞌar naꞌa ralarira ra, ba rira inorang a wol ntahang ma mnanat. Naꞌut i rtuan angangal, na rafla talik rira inorang a. ");
INSERT INTO frd_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Nabat ovi rleka naꞌa kadkadir ralan ra rfaturu tamata ovi rarenar roak Ubu Ni vaivatul ra, naꞌuk rfikir lalawatan afa liak, ma ralarira kakoꞌu naꞌa rira vavaꞌat ra. Ira inar vali ma rtafal ilaꞌa rira metan ra, ovu rotu inar lolin watan naꞌa lanit ivavan ini. Afa avyai rotu ma wol rorang Ubu Ni vaivatul ra, ma wol enarira akataka naꞌa rira vavaꞌat ra. ");
INSERT INTO frd_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Nabat ovi rleka naꞌa lanun tinemun, rfaturu tamata ovi rarenar Ubu Ni vaivatul ra ma rala naꞌa ralarira ra, ovu ralarira ilaꞌa ra lolin urun ovu rmalola. Ba velik ne rtuan angangal, naꞌuk rtahang nal ralarira watan, ma rira vavaꞌat ra kena ovu Ni vaivatul ra.” ");
INSERT INTO frd_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Yesus ntafal ma nfalak ne, “Wol tamata isa ntutun damar ma nulang teri ovu ngusi, te nfadoku naꞌa koꞌi vavan a. Naꞌuk nfadoku naꞌa damar wan i karatat a, boma nyeba munuk tamata ovi rma rahan ralan yai. ");
INSERT INTO frd_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Wean inyai bi, afa fanfonak ra veka lyawan, ovu afa ovi tamata ra wol rkaꞌa veka rvotuk ma lyawan verin tamata ra. ");
INSERT INTO frd_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Eka mingnanang ma lolin afa ovi mryenar roak tali Yaꞌa, tevek tamata iki watan inan ma nfan-aran Ubu Ni vaivatul ra, na Ubu veka ntafal ni kakaꞌa. Naꞌuk tamata iki watan wol inan ma nfan-aran Ubu Ni vaivatul ra, na Ubu veka nala munuk kakaꞌa yai tali ia, velik ne nfikir ne, nkaꞌa kadkedan roak.” ");
INSERT INTO frd_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Yesus renan ovu warin ra rma ma rtuan Ia, naꞌuk wol rfaser-nala, tevek tamata rivun rdir-lilit Ia. ");
INSERT INTO frd_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ba tamata isa nfalak verin Yesus ne, “Baba, renam a ovu warim ra rdiri watan murin eri ovu inar ma rtuan Oa.” ");
INSERT INTO frd_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Naꞌuk Yesus nfalak ne, “Tamata ovi rarenar Ubu Ni vaivatul ra ovu rot-orang, na tamata avyai renang ovu waring verin ira.” ");
INSERT INTO frd_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Amar isa, na Yesus ovu Ni tamata ovi rorang Ia rarata kumal isa. Yesus nfalak verin ira ne, “Mya ma tati danau Galilea ni lihir a.” Ba irmunuk robal ma rti lahir danau yai ni lihir a. ");
INSERT INTO frd_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Naꞌut i robal a, na Yesus ntuba. Brian munuk, na nait fufakmetan nkena ira naꞌa danau yai ralan a, ba saksakan ra dawan ma wear a ndata lahir rira kumal ralan a. Ira sarseri mane rakduvul roak, ma wol rkaꞌa ne, veka rmata te rvaꞌat. ");
INSERT INTO frd_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ba Yesus Ni tamata ovi rorang Ia rkadu Ia ma rfalak ne, “Tuan Guru! Ita mane takduvul roak!” Yesus nbatar ma nfareta nait ovu saksakan ra, ba nait ovu saksakan ra rtalik lahir ma danau yai ngarlina ewal. ");
INSERT INTO frd_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Nata Yesus nfalak verin ira ne, “Afakinimi wol myorang Yaꞌa?” Ba ira rbobar urun i lahir ovu rtalkaka ma rsifalak afa verin ira ne, “Ini tamata iki mngaꞌun ma nfareta nait ovu saksakan ra ma rorang Ia?” ");
INSERT INTO frd_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yesus ovu Ni tamata ovi rorang Ia robal ewal ma rti raran wan i tamata Gerasa rleal naꞌa danau Galilea ni lihir a. ");
INSERT INTO frd_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ti ma Yesus nsuta tali kumal a, na brana isa ntali ahu i sarseri wan yai nma ma ntuan Ia. Brana yai nait sian ra rlabir ia ovu mnanat roak wol nung a neluk ia, ovu vali ia wol nanaꞌa rahan, naꞌuk nanaꞌa watan van ovi rfadoku tamata matmatan ra rnaꞌa. ");
INSERT INTO frd_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ba naꞌut i nsiꞌik Yesus, na nafwak ma vain a dawan, beti nsangatur lahir naꞌa Yesus wahan ralan a ma nafwak ne, “Yesus, mwa ini ma motu afaka verin yaꞌa? Oa ini Ubu i Ni dawan lia munuk afakataka Yanan Oa. Era lablobang verin Oa ma deka motu sian yaꞌa.” ");
INSERT INTO frd_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ia nfalak wean inyai, tevek Yesus nfareta roak ma nait sian avyai rti talik ia. Brana ini nait sian avyai baꞌi rlabir ia, ba velik ne rkeak liman ovu ean a ovu kakeak tmaꞌan, ovu vali rwanar ia, naꞌuk nkametal nala munuk kakeak tmaꞌan avyai, beti nait sian avyai rovun ia nti wan ovi wol tamata rnaꞌa. ");
INSERT INTO frd_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ba Yesus norat brana yai ne, “Oa naram iki?” Ba nfalak ne, “Yaꞌa narang Legion.” Ia nfalak wean inyai, tevek nait sian rivun roak rlabir ia. ");
INSERT INTO frd_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Nait sian avyai rera lablobang verin Yesus ma deka nalaꞌing vatuk ira rti tivat matmatan i bilaman urun a. ");
INSERT INTO frd_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Naꞌa wan yai, na vavu dur dawan isa rafnuak naꞌa ma rdava rira fanaꞌan ra naꞌa vuar ni dadudur a. Ba nait sian avyai rera lablobang verin Yesus ma ti rnaꞌa vavu avyai. Yesus ntorung afa i rera yai. ");
INSERT INTO frd_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ba nait sian avyai rti talik brana yai ma ti rnaꞌa vavu dur yai. Nata vavu avyai rafla ma rti rtobur tali biliꞌin nelan a, ma rsuta danau ralan ma rakduvul ma rmata munuk. ");
INSERT INTO frd_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ti ma tamata ovi rfawatak vavu avyai rsiꞌik afa yai, na rafla lahir rti ma rfamalik ivar yai naꞌa kota ovu naꞌa ahu ovi rfaseri wan yai. ");
INSERT INTO frd_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ba tamata ra rma ma rsiꞌik afa ovi Yesus notu roak a. Ira rma ma rtuan Yesus, na rarea lahir brana i Yesus naling vatuk roak nait sian ra tali ia. Brana yai ndok-ebang Yesus ean a. Ia nung a neluk roak ia, ovu ni fikiran a lolin ewal roak, ba tamata avyai rbobar urun i lahir. ");
INSERT INTO frd_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Tamata ovi rsiꞌik lahir afa i Yesus notu roak yai rfamalik verin tamata ovi beti rma wan yai, naꞌa brana i Yesus naling vatuk roak nait sian ra tali ia. ");
INSERT INTO frd_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ba tamata ovi rnaꞌa Gerasa munuk lahir rera lablobang verin Yesus ma nti talik ira, tevek rbobar urun. Ba Yesus nrata kumal a ma robal ewal. ");
INSERT INTO frd_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Brana i nait sian ra rti talik roak ia yai nera urun verin Yesus, boma ia novu vali. Naꞌuk Yesus nsinir ma newal ia ma nfalak ne, ");
INSERT INTO frd_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Mewal oa muti mu rahan ma fwamalik munuk afa ovi Ubu notu roak verin oa.” Ba brana yai nti ma nban-lilit kota a ma nfamalik afa ovi Yesus notu roak verin ia. ");
INSERT INTO frd_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Naꞌut i Yesus newal Ia ma nti danau Galilea ni lihir varat a, na tamata rivun rsaꞌa Ia, tevek rnaban watan Ia. ");
INSERT INTO frd_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Naꞌa wan yai, na tamata isa naran Yairus, ia nban-ulu naꞌa tamata Yahudi rira rahan falurut a. Ia nma ma nsangatur ma nsoak wahan a naꞌa Yesus wahan ralan a, ma nera urun verin Yesus ma nti ni rahan. ");
INSERT INTO frd_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Yairus nera wean inyai, tevek yanan vata nawar ia, sarseri mane nmata. Yanan vata yai ikisa laloꞌi, ovu ni varat vutu rahin irua. Naꞌut i Yesus nbana nti Yairus ni rahan a, na tamata rivun rnaꞌa inyai, ba rsidekin ira ma rdekin nala vali Yesus. ");
INSERT INTO frd_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Tali tamata rivun avyai, na vata isa laran nvoat ma dawan daꞌin, ti naran varat vutu rahin irua roak, naꞌuk wol tamata isa vali bis notu ma lolin ewal ia. ");
INSERT INTO frd_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Vata yai nahu Yesus murin a ma ti nfaseri Ia ma nkena Ni ravit blawat ni wahan a, ba naꞌut inyai vali, na laran i nvoat a ntalik lahir. ");
INSERT INTO frd_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ba Yesus nfalak ne, “Iki nkena Yaꞌa?” Wol tamata isa vali ntali ira ntorung ne, nkena Ia. Ba Petrus nfalak ne, “Tuan Guru, tamata rivun rdir-lilit Oa, ma rdekin kena Oa.” ");
INSERT INTO frd_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Naꞌuk Yesus nfalak ne, “Tamata isa nkena Yaꞌa, tevek ufarnuang ne, Ning ngrebat nlobang tamata isa.” ");
INSERT INTO frd_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Vata yai nsiꞌik ne, Yesus nkaꞌa roak afa i notu a, ba nbobar ma raruru lalean ia, ma nsangatur ma nsoak wahan naꞌa Yesus wahan ralan a. Ia nfamalik verin tamata rivun avyai, ma al nfalyawang ne, afakinimi nkena Yesus, ovu naꞌut inyai, na lolin lahir ia. ");
INSERT INTO frd_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yesus nfalak verin vata yai ne, “Titi, oa morang Yaꞌa, ba lolin roak oa. Mewal oa, ovu fara Ubu nala Ni malinan verin oa.” ");
INSERT INTO frd_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Naꞌut i Yesus nangrihi obin, na Yairus i nban-ulu naꞌa Yahudi rira rahan falurut yai, ni tamata isa ntali ni rahan nma. Ia nfalak verin Yairus ne, “Itrana, yanam vata nmata roak, ba deka fwafrea Tuan Guru.” ");
INSERT INTO frd_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Naꞌuk Yesus nrenar vaivatul yai, ba nfalak verin Yairus ne, “Baba, deka bwobar. Morang watan Yaꞌa, na yanam a veka nvaꞌat ewal.” ");
INSERT INTO frd_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ti ma raran Yairus ni rahan, na Yesus wol ntorung ma tamata liak rorang Ia rti ralan, naꞌuk ntorung watan ma Petrus, Yakobus, Yohanes ovu kasikoꞌu yai renan a yaman a rovu Ia. ");
INSERT INTO frd_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Tamata ra munuk ralarira lalau ma rvakar ma vairira dawan. Naꞌuk Yesus nfalak ne, “Deka byakar, tevek ia wol nmata, naꞌuk ntub-lufa watan.” ");
INSERT INTO frd_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Tamata avyai rmalit waweang Ia, tevek ira rkaꞌa ne, kasikoꞌu yai nmata roak. ");
INSERT INTO frd_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Naꞌuk Yesus ntaha kasikoꞌu yai liman a ma nfalak ne, “Titi, bwatar kikyai!” ");
INSERT INTO frd_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ba kasikoꞌu yai nvaꞌat ewal ma nbatar ma ndiri lahir. Nata Yesus nsinir ira ma rala afamtahan verin ia ma naꞌan. ");
INSERT INTO frd_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Kasikoꞌu yai renan yaman a rtalkaka lahir, naꞌuk Yesus nfalak teri ma deka rfaivar verin iki watan naꞌa afa i notu a. ");
INSERT INTO frd_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesus nasdovu Ni tamata vutu rahin irua ovi rorang Ia, ma nala Ni fareta ovu Ni ngrebat a verin ira, boma raling vatuk nait sian ra tali tamata ra ovu rotu ma lolin tamata ra tali rira suhut ra. ");
INSERT INTO frd_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ia nsinir ira ma rti rotu ma lolin tamata ra tali rira suhut ra, ovu rfamalik naꞌa i wean inba ma Ubu nfareta tamata ra wean lahir Raja. ");
INSERT INTO frd_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Yesus nfalak verin ira ne, “Deka mtyaha afakataka naꞌa bira banbanan a. Deka mtyaha takil, sadawan, kesi, kubang ovu kadaravit. Myoru watan kadaravit ovi rnaꞌa tenabira ra. ");
INSERT INTO frd_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Wean i tamata ra rtorung ma mnyaꞌa teri rira rahan, na mnyaꞌa inyai, ti naran i mane miti talik rira ahu a. ");
INSERT INTO frd_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Wean i tamata ra naꞌa ahu isa wol rtorung ma mnyaꞌa inyai, na byan-talik ahu yai, ovu misnabar vatuk kyavu tali eabira ra, boma neluk faneak ne, Ubu veka nukun ira.” ");
INSERT INTO frd_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ba Yesus Ni tamata ra rban-soru ahu ra ma rfamalik Ubu Ni Ivar Lolin, ovu rotu ma lolin tamata ra tali rira suhut ra naꞌa wan inba watan. ");
INSERT INTO frd_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ti ma raja Herodes i ntaha fareta naꞌa propinsi Galilea nrenar afa ovi Yesus notu ra, na wol nkaꞌa ma nroal te nra, tevek tamata boku rfalak ne, Yohanes i nbaptis tamata ra nvaꞌat ewal roak. ");
INSERT INTO frd_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Tamata boku rfalak ne, Elia nvotuk ewal roak, ovu tamata boku vali rfalak ne, nabi isa tali nabi lan ra nvaꞌat ewal roak. ");
INSERT INTO frd_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herodes nfalak ne, “Yaꞌa usinir roak ma tamata ra rvangal Yohanes ulun a, naꞌuk Ia ini tamata iki mngaꞌun Ia ma notu mujizat wean inyai?” Ba nkiwal mane ntuan Yesus. ");
INSERT INTO frd_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ti ma Yesus Ni tamata vutu rahin irua ovi nsinir ma rfamalik Ni Ivar Lolin rewal ira, na rfamalik munuk afa ovi rotu ra verin Yesus. Ira rfamalik munuk afa avyai, beti Yesus novun ira ma rti wan isa i nfaseri kota Betsaida ma aksa ira rnaꞌa inyai. ");
INSERT INTO frd_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Naꞌuk ti ma tamata rivun rkaꞌa ne, Yesus ovu Ni tamata ovi rorang Ia rti wan yai, na rorang lahir Ia. Ba Yesus ntorung ma rnaꞌa inyai ma nfamalik i wean inba ma Ubu nfareta wean lahir Raja verin ira, ovu notu ma lolin tamata ovi rdava mane lolin ira tali rira suhut ra. ");
INSERT INTO frd_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ti ma lera nakduvul ma laflofan roak, na Yesus Ni tamata vutu rahin irua yai rma ma rfalak verin Ia ne, “Msinir ma tamata rivun ini rti ahu ovi rfaseri wan ini ma rdava rira fanaꞌan, ovu rahan siwelat ma rnaꞌa, tevek ita tnaꞌa wan i tamata ra wol rnaꞌa.” ");
INSERT INTO frd_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Naꞌuk Yesus nfalak verin ira ne, “Mia musti fyaꞌan ira!” Ira rfalak ne, “Ami mami roti ilima ovu ian irua watan. Ba wean inyai, na ami musti amati ma amfaha fanaꞌan verin tamata rivun ovi?” ");
INSERT INTO frd_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Brana ovi rnaꞌa wan yai kaꞌa bi nlabas rivun ilima. Ba Yesus nfalak verin Ni tamata ovi rorang Ia ne, “Msyinir ma tamata rivun avyai rotu rira sidovung ra, ma lokat sidovung tamata nlabas vutlima ma lokat ira rdoku naꞌa rira sidovung a.” ");
INSERT INTO frd_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Yesus Ni tamata ovi rorang Ia yai rot-orang afa ovi nfalak ra, ba rsinir ma tamata rivun avyai rdoku munuk. ");
INSERT INTO frd_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Nata Yesus nala roti ilima ovu ian irua yai, beti ntadata nrata lanit ma nfalak fara weninyai verin Ubu. Ia notu munuk wean inyai, beti nvisul roti avyai ma nala verin Ni tamata ovi rorang Ia, boma rti rsiduk verin tamata rivun avyai. ");
INSERT INTO frd_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Tamata rivun avyai rafnaꞌan ma evurira ra rveda munuk roak, beti Yesus Ni tamata ovi rorang Ia rasdovuk munuk roti teran ra naꞌa ahir vutu rahin irua rngora. ");
INSERT INTO frd_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Amar isa, na Yesus aksa Ia naflurut. Ni tamata ovi rorang Ia rnaꞌa wan yai vali. Ba norat ira ne, “Tamata ra rfalak ne, Yaꞌa ini iki?” ");
INSERT INTO frd_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ira rfalak ne, “Tamata boku rfalak ne, Oa ini Yohanes i nbaptis tamata ra, boku rfalak ne Elia, boku vali rfalak ne, nabi isa tali nabi ovi lan ra nvaꞌat ewal roak.” ");
INSERT INTO frd_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Yesus norat ira ne, “Naꞌuk mia fyikir ne, Yaꞌa ini iki?” Petrus nfalak ne, “Oa ini Raja i mtevut mami salasilan ra.” ");
INSERT INTO frd_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ba Yesus nfalak teri lahir ma deka rfaivar afa yai verin tamata ra. ");
INSERT INTO frd_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Yesus nfalak verin Ni tamata ovi rorang Ia ne, “Yaꞌa, Tamata Yanan Yaꞌa musti utuan susa rivun. Dawan Yahudi ra, ovu Yahudi rira dawan mela falurut ra ovu vali Yahudi rira dawan ovi rair Musa ni inukun ra veka ralaꞌing Yaꞌa ma rfedan Yaꞌa, naꞌuk amar itelu nelak, na Ubu veka nfavaꞌat ewal Yaꞌa.” ");
INSERT INTO frd_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Yesus nfalak verin tamata ovi rnaꞌa inyai munuk ne, “Tamata iki watan inan ma norang Yaꞌa, na lokat amar ia musti nalak tenan a ovu nvara ni aa walwalur a. Notu wean inyai, beti bisma norang Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Tamata iki watan inan ma ntahang teri ni vavaꞌat i naꞌa lanit ivavan a, na ia veka wol ni vavaꞌat kakiwal a. Naꞌuk iki watan nmata tevek norang Yaꞌa, na ia veka ni vavaꞌat kakiwal a. ");
INSERT INTO frd_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Velik ne tamata isa nasdovu munuk metan ovi rnaꞌa lanit ivavan a, naꞌuk wol ni vavaꞌat kakiwal, na ihin aka? Metan ovi rnaꞌa lanit ivavan ini wol rotu ma utun akataka. ");
INSERT INTO frd_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Wean i tamata iki watan nmaꞌit ma nfalak ne norang Yaꞌa, ovu wol ntorung afa ovi ufalak ra, na Yaꞌa, Tamata Yanan Yaꞌa, veka wol utorung vali tamata yai, naꞌut i uma ewal a ovu vanang i nfitik nyadat, ovu Yamang vanan i nfitik nyadat a, ovu vali Ubu Ni sansinir ra tali lanit ratan ovi rmerat urun. ");
INSERT INTO frd_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Afa i ufalak verin mia ini, kena urun! Tali bir tinemun naꞌa wan ini, na boku wol rmata obin, naꞌut inyai na ira veka rsiꞌik lahir wean inba ma Ubu nfareta wean lahir Raja.” ");
INSERT INTO frd_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Snain a amar iwalu nelak roak tali naꞌut i Yesus nair afa avyai, na Ia novun Petrus, Yohanes ovu Yakobus ma rvaꞌal vuar isa ma raflurut. ");
INSERT INTO frd_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Naꞌut i Yesus naflurut, na felan a naling roak Ia, ovu afa ovi nung a neluk ra, rangiar urun ma rfitik-ryadat. ");
INSERT INTO frd_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Brian munuk, na tamata irua rvotuk ovu vanarira i nyadat a, ma rangrihi nulu Yesus. Tamata irua yai Musa ovu Elia. Ira rangrihi ovu Yesus naꞌa Ni matmatan i veka nti ma nfakena naꞌa Yerusalem. ");
INSERT INTO frd_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Naꞌut inyai, na Petrus ovu ni kida ra rtuba roak. Brian munuk, na rbatar ma rsiꞌik Yesus ovu vanan i nfitik nyadat a. Ira rsiꞌik vali tamata irua i rdir-ebang Ia. ");
INSERT INTO frd_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ti ma tamata irua yai mane rti talik Yesus, na Petrus nfalak verin Yesus ne, “Tuan Guru, lolin urun ma tnaꞌa wan ini. Ni lolin a amfadiri befak itelu ma isa verin Oa, isa verin Musa, isa vali verin Elia.” Petrus nfalak wean inyai, naꞌuk wol nfan-aran afa ovi nfalak ra. ");
INSERT INTO frd_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Petrus nangrihi obin, na mutan nma ma nkum-teri ira, ba rbobar urun. ");
INSERT INTO frd_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Naꞌa mutan ralan yai, na rarenar vai isa nfalak ne, “Ini Yanak i ufili roak Ia. Mryenar afa ovi nfalak ra!” ");
INSERT INTO frd_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ti ma vai yai nlia roak, na rsiꞌik watan i Yesus aksa Ia naꞌa inyai. Naꞌut inyai, na Yesus Ni tamata itelu yai wol rfamalik afa yai verin tamata iki watan. ");
INSERT INTO frd_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ti ma ni ilyan a, na Yesus ovu Ni tamata itelu ovi rorang Ia yai rsuta tali vuar yai, na tamata rivun ilaꞌa rma ma rtuan Yesus. ");
INSERT INTO frd_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Brana isa tali tamata rivun avyai nafwak ma nfalak ne, “Tuan Guru, era lablobang verin Oa ma eka msiꞌik yanak a, tevek yanak ikisa laloꞌi watan. ");
INSERT INTO frd_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Nait sian isa nlabir ia, ba brian munuk nafwak ma vain a dawan, ovu tenan a raruru lalean ia ma bera faluvur ia. Nait sian yai labir mane nanaꞌa lalawatan ia, ovu not-visal lahir ia. ");
INSERT INTO frd_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Era roak verin Mu tamata ovi rorang Oa ma raling vatuk nait sian yai, naꞌuk wol rot-nala.” ");
INSERT INTO frd_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ba Yesus ntabu ira ma nfalak ne, “Wean inba mia? Wol bira inorang lahir ovu wol myorang afa ovi kena ra. Amar ifira vali ma udoku ovu mia ma utahang nal ralang ovu mia, tamata ovi wol bira inorang a? Movun yanam a mwa ini!” ");
INSERT INTO frd_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ti ma kasikoꞌu yai nfaseri Yesus, na nait sian i nleal ia yai nasba vatuk ia nsuta lanun, ovu notu ma tenan a raruru lalean ia. Naꞌuk Yesus nfareta nait sian yai ovu vain dawan ma nti talik kasikoꞌu yai, ovu notu ma kasikoꞌu yai lolin ewal ia, beti nala ia verin yaman a. ");
INSERT INTO frd_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ba tamata rivun avyai rtalkaka, tevek rsiꞌik lahir Ubu Ni ngrebat a. Naꞌut i tamata rivun avyai rtalkaka obin, tevek rsiꞌik afa ovi Yesus notu ra, na Yesus nfalak verin Ni tamata ovi rorang Ia ne, ");
INSERT INTO frd_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Mryenar ma lolin ovu deka miblufang afa ovi ufalak ini. Tamata ra veka rala Yaꞌa, Tamata Yanan Yaꞌa ini, verin tamata ra.” ");
INSERT INTO frd_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Naꞌuk Yesus Ni tamata ovi rorang Ia wol rfan-aran afa ovi nfalak ra, tevek Ubu notu ma wol rfan-aran vaivatul avyai ihirira ra. Ira wol rabrahi vali ma rorat vaivatul avyai ihirira ra. ");
INSERT INTO frd_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Yesus Ni tamata ovi rorang Ia rsitaku ulurira naꞌa rira fikiran ra ma rdava ne, iki dawan lia munuk tali ira. ");
INSERT INTO frd_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Naꞌuk Yesus nkaꞌa lahir afa i ranovak naꞌa ralarira ra, ba nala kasikoꞌu isa ma ndir-ebang Ia, ");
INSERT INTO frd_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","beti nfalak verin ira ne, “Tamata iki watan nalang kasikoꞌu ini tevek narang a, na ia nalang roak Yaꞌa. Tamata iki watan nalang Yaꞌa, na ia nalang roak Ubu i nsinir Yaꞌa, tevek tali bir tinemun, na tamata i wol fyawan akataka, ia veka fyawan urun.” ");
INSERT INTO frd_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yohanes nfalak ne, “Tuan Guru, ami amsiꞌik tamata isa nala naram a vali ma naling vatuk nait sian a, ba amtab-teri ia, tevek ia wol ntali dida sidovung a.” ");
INSERT INTO frd_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yesus nfalak verin ia ne, “Deka mtab-teri tamata yai, tevek tamata iki watan wean i wol nangal mia, na ia nlobang roak mia.” ");
INSERT INTO frd_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ti ma Yesus Ni amar sarseri roak mane nrata lanit ratan, na nfadoku lahir ma musti nti Yerusalem. ");
INSERT INTO frd_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ba nsinir lan tamata ifira ma ula ira rti. Tamata avyai rti ahu isa naꞌa propinsi Samaria, ma rasusan munuk lahir afakataka verin Yesus. ");
INSERT INTO frd_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Naꞌuk tamata ovi rnaꞌa ahu yai ralaꞌing Yesus, tevek rkaꞌa roak ne, Ia mane nti Yerusalem. ");
INSERT INTO frd_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ti ma Yesus Ni tamata irua ovi nararira Yakobus ovu Yohanes rkaꞌa afa yai, na rfalak verin Yesus ne, “Duilaꞌa, mtorung ma amera verin Ubu ma nfasuka yafu tali lanit ratan ma nfedan munuk tamata ovi?” ");
INSERT INTO frd_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Naꞌuk Yesus nfulak wahan a ma ntabu irua, tevek rfalak wean inyai, ");
INSERT INTO frd_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","beti rti ahu liak. ");
INSERT INTO frd_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Naꞌut i Yesus ovu Ni tamata ovi rorang Ia rban-ewal mane rti Yerusalem, na tamata isa nfalak verin Ia ne, “Baba, muti inba watan, na orang Oa.” ");
INSERT INTO frd_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesus nfalak verin ia ne, “Serigala ra warira ma rnaꞌa, ovu manut nangan ra rira renga, naꞌuk Yaꞌa, Tamata Yanan Yaꞌa, wol wang ma uyari Yaꞌa.” ");
INSERT INTO frd_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Nata Yesus nfalak verin tamata liak isa vali ne, “Morang Yaꞌa!” Naꞌuk tamata yai nfalak ne, “Baba, fara mtorung ma ewal yaꞌa veki ti ma oving yamang a.” ");
INSERT INTO frd_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yesus nfalak verin ia ne, “Tamata ovi wol rorang Yaꞌa, ira wearira tamata ovi rmata roak. Ba ira kaꞌi roving tamata ovi rmata roak a, naꞌuk oa musti muti ma fwaivar naꞌa inba watan ne, Ubu nfareta tamata ra wean lahir Raja.” ");
INSERT INTO frd_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Tamata liak isa vali nfalak ne, “Duilaꞌa, yaꞌa mane orang Oa, naꞌuk mtorung ma ti utuli tamata ovi rnaꞌa ning rahan a veki.” ");
INSERT INTO frd_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ba Yesus nfalak ne, “Tamata i betmane nta ni vaꞌi, naꞌuk ntamuri lalawatan, na ni karya wol kena. Wean inyai vali verin tamata ovi inar ma rkarya verin Ubu naꞌa Ni Fareta a.” ");
INSERT INTO frd_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Duilaꞌa Yesus nfalak munuk wean inyai, beti nsinir Ni tamata vutfitu ovi rorang vali Ia, ma raruan ira rti lan ahu ovi veka nwelat ra. ");
INSERT INTO frd_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ia nala vaivatul kamkuma ma nfalak verin ira ne, “Tamata rivun wearira wanat ovi rwavar ma rivun ilaꞌa roak, naꞌuk tamata ifira watan ti ma rafdiar. Ba wean inyai, na myera verin vaꞌi duan a ma nala tamata ma ti rafdiar. Wean inyai, na myera verin Ubu ma ntafal tamata ma ti rfaivar Ni vaivatul ra verin tamata ovi wol rarenar obin.” ");
INSERT INTO frd_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ia nfalak vali verin ira ne, “Miti kikyai! Usinir ma miti wan ovi tamata sian ra rnaꞌa. Mia weabira domba yanan ovi rvaꞌat naꞌa serigala warira i rnaꞌa. ");
INSERT INTO frd_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Deka mtyaha sadawan i baꞌi fyadoku kubang naꞌa, te sadawan liak ma fyadoku bira kesi naꞌa, te tatea liak naꞌa bira banbanan a. Wean i mtyuan tamata iki watan naꞌa bira banbanan a, na deka mingrihi ma blawat ovu ira. ");
INSERT INTO frd_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Wean i miti rahan isa ralan a, na fyalak lan verin tamata ovi rnaꞌa inyai ne, ‘Fara Ubu naflahar bira rahan teta a ma malinan watan.’ ");
INSERT INTO frd_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Wean i tamata boku rnaꞌa inyai inar lalawatan malinan a, na mu salam yai veka nanaꞌa watan tamata avyai. Naꞌuk wean i wahal, na mu salam yai veka nleka ma lolan watan. ");
INSERT INTO frd_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Mnyaꞌa rahan yai, na myenu ovu mian watan afamtahan ovi tamata ra rala verin mia naꞌa inyai, tevek tamata ovi rkarya inovan ma rala enarira ra. Deka msyuta talik rahan ovi mnyaꞌa lan roak a ma ti mnyaꞌa rahan liak. ");
INSERT INTO frd_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Wean i miti kota isa ralan a ma tamata ovi rnaꞌa inyai rala mia ovu lolin, ovu vali rasusan afamtahan ma mian, na mian watan afamtahan ovi rasusan roak ma mian yai. ");
INSERT INTO frd_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Myotu ma lolin tamata ovi rira suhut ra naꞌa inyai, ovu fyalak verin tamata ovi rnaꞌa kota yai ne, ‘Naran roak Ni amar a ma Ubu nfareta wean lahir Raja.’ ");
INSERT INTO frd_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Naꞌuk wean i tamata ovi rnaꞌa kota yai wol rtorung ma mnyaꞌa inyai, na miti lahir kota yai ni lingaꞌan dawan ra ma fyalak ne, ");
INSERT INTO frd_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Velik ne bira kota ini ni kyavu nlatan eamami ra obin, na amasnabar vatuk watan, boma neluk faneak verin mia ne, Ubu veka nukun mia. Naꞌuk mingnanang ma lolin ne, Ni amar a sarseri roak ma Ubu nma ma nfareta wean lahir Raja.’ ");
INSERT INTO frd_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Mryenar ma lolin afa ovi ufalak ini! Naꞌa amar i Ubu nma ma nukun munuk tamata ra, na Ni inukun i veka nala verin tamata ovi rnaꞌa kota yai, nlia inukun i veka nala verin tamata ovi lan a rleal kota Sodom.” ");
INSERT INTO frd_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Yesus nfalak ne, “Sian urun i lahir verin mia tamata ovi mtyali ahu Korazim ovu ahu Betsaida! Yaꞌa otu mujizat rivun roak naꞌa bira ahu ra, naꞌuk wol myahil ma mtyalik tali bira salasilan ra obin. Lalan a, tamata ra naꞌa kota Tirus ovu Sidon rira sian a dawan urun, ovu wol rsiꞌik mujizat i wean mujizat avyai. Naꞌuk wean i otu mujizat wean avyai naꞌut lalan a naꞌa inyai, na ira rahil ma mnanat roak tali rira salasilan ra, ovu reluk roak kadaravit ovi rotu tali bibi vulun ra, ovu vali rdoku fun ma rfadoku kfuan naꞌa ulurira ra. ");
INSERT INTO frd_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Naꞌuk mryenar ma lolin afa ovi ufalak ini! Naꞌa amar i Ubu veka nma ma nukun tamata ra, na Ni inukun i veka nala verin mia aleman lia tali inukun i veka nala verin tamata ovi rnaꞌa kota Tirus ovu kota Sidon. ");
INSERT INTO frd_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Tamata ovi mnyaꞌa ahu Kapernaum! Mnyarin ne, Ubu veka nfasaka mia ma mirata lanit ratan? Wahal lahir! Ubu veka naling vatuk mia ma ti mnyaꞌa yafwan kakiwal!” ");
INSERT INTO frd_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yesus nfalak verin Ni tamata ovi rorang Ia ne, “Tamata ovi rarenar afa ovi fyalak ra, na rarenar roak Yaꞌa. Tamata ovi wol rarenar afa ovi fyalak ra, na wol rarenar vali Yaꞌa. Tamata iki watan wol norang afa ovi ufalak ra, na ia wol ntorung vali Ubu i nsinir Yaꞌa ma uma lanit ivavan ini.” ");
INSERT INTO frd_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ti ma Yesus Ni tamata vutfitu ovi nsinir ira yai rewal ira, na ralarira lolin urun i lahir. Ba rfalak verin Ia ne, “Duilaꞌa, nait sian ra vali rot-orang afa ovi amfalak ra ma rti lahir, naꞌut i amala naram a ma amaling vatuk ira!” ");
INSERT INTO frd_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ba Yesus nfalak verin ira ne, “Yaꞌa usiꞌik roak naꞌut i Ubu nvatuk nitdawan ma nleka tali lanit ratan a nsuta ma sngaꞌut urun i lahir wean fitik a nyelar. ");
INSERT INTO frd_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Yaꞌa ala roak ngrebat verin mia ma wean i mtya aru te katkatan, na wol akataka. Yaꞌa ala vali ngrebat verin mia roak ma utubira nitdawan ni ngrebat a, ba wol afakataka veka rotu sian mia. ");
INSERT INTO frd_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Naꞌuk velik ne wean inyai, na deka myotu ralabira lolin urun, tevek nait sian avyai rorang roak afa ovi fyalak ra. Naꞌuk ralabira lolin urun, tevek Duilaꞌa ntulis roak narabira ra naꞌa lanit ratan.” ");
INSERT INTO frd_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Naꞌut inyai vali, na Ubu Ni Roh notu ma Yesus ralan a lolin urun. Yesus nfalak ne, “Duilaꞌa, Yamang Oa! Oa fwareta lanit ratan ovu lanit ivavan ini. Ufalak fara weninyai verin Oa, tevek wol fwalyawang munuk afa avyai verin tamata ovi rira kakaꞌa dawan a, ovu tamata ovi rbitar ra. Naꞌuk Oa fwalyawang verin tamata ovi wearira kasikoꞌu ra. Bapa, afa avyai rotu ma ralam lolin urun.” ");
INSERT INTO frd_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Yesus nfalak verin tamata ovi rnaꞌa inyai ne, “Yamang a nala roak ngrebat ovu Ni kakaꞌa dawan a verin Yaꞌa. Tamata ovi rnaꞌa lanit ivavan a wol rkaꞌa Yaꞌa. Yamang aꞌuk saꞌi nkaꞌa Yaꞌa. Tamata ovi rnaꞌa lanit ivavan a vali wol rkaꞌa Yamang a. Yaꞌa aꞌuk saꞌi ukaꞌa, ovu vali tamata ovi ralang a nfalak ma ufalyawang Yamang a verin ira.” ");
INSERT INTO frd_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Yesus nfalak munuk wean inyai, beti nti nelan kedan ma nangrihi ovu Ni tamata ovi rorang Ia yai, ma nfalak ne, “Mia utubira, tevek msyiꞌik roak Ning afa ovi otu ra. ");
INSERT INTO frd_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ufalak ne utubira, tevek nabi ovu raja rivun tali lalan roak inarira ma rsiꞌik afa ovi fiang ini msyiꞌik a, naꞌuk wol rarea. Ira inar vali ma rarenar afa ovi fiang ini mryenar roak a, naꞌuk wol rarenar nala vali.” ");
INSERT INTO frd_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Amar isa, na tamata isa tali Yahudi rira dawan ovi rair Musa ni inukun ra nlabir teman Yesus ne, “Tuan Guru, yaꞌa musti otu afaka, boma ning vavaꞌat kakiwal?” ");
INSERT INTO frd_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesus nfalak ne, “Musa ntulis aka naꞌa ni inukun ra, ovu fwikir aka naꞌa afa ovi bwas ra?” ");
INSERT INTO frd_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Tamata yai nfalak ne, “Oa musti mlobang Duilaꞌa, mu Ubu i mraning Ia a, ovu ralam urun. Mala munuk mu vavaꞌat a, mu ngrebat ovu vali mu kakaꞌa ra ma al mlobang Ia. Oa musti mlobang vali tamata liak ra, wean watan i mlobang tenam a.” ");
INSERT INTO frd_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ba Yesus nfalak ne, “Mu afa ovi fwalak yai kena urun, ba motu watan wean i fwalak roak yai, na oa veka mu vali vavaꞌat kakiwal.” ");
INSERT INTO frd_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Naꞌuk dawan Yahudi yai notu felan a wean tamata ovi baꞌi rotu aꞌuk afa ovi lolin ra, ba norat ewal Yesus ne, “Tamata ovi musti ulobang avyai, aba ira?” ");
INSERT INTO frd_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesus nfamalik vaivatul kamkuma isa ewal ma nfalak wean ini, “Brana isa ntali Yerusalem a nsuta mane nti kota Yerikho. Naꞌa ni banbanan obin, na ntuan tamata ovi baꞌi rbori tamata liak rira metan ra. Tamata avyai rala munuk lahir ni kadaravit ovu afa ovi ntaha ra, beti rvaval ma brana yai kata kedan watan, na nmata. Rotu munuk wean inyai, beti rban-talik brana yai ma aksa ia watan naꞌa lingaꞌan nelan. ");
INSERT INTO frd_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Naꞌut inyai vali, na Yahudi rira mela falurut isa nahu vali lingaꞌan yai. Naꞌuk ti ma nsiꞌik tamata yai, na ia nban-etal watan lingaꞌan yai ma ti nahu ni lihir a. ");
INSERT INTO frd_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Tamata Lewi isa vali nahu lingaꞌan yai. Ia nrea tamata yai, naꞌuk nban-etal vali lingaꞌan yai ma nban-talik ia. ");
INSERT INTO frd_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Nata tamata Samaria isa nahu vali lingaꞌan yai. Ti ma nrea tamata yai, na nfarnuang lahir naꞌa ralan ma nfaturu ni silobang verin ia. ");
INSERT INTO frd_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ba nti nebang tamata yai ma nala ni anggur ovu ngul al nfamerat ni mngala ra, ovu nkum-teri ni mngala ra ovu maloli, beti nfasaka ia naꞌa ni keledai a ma novun ia nti rahan siwelat isa. Naꞌa inyai, na ia nasusan munuk lahir afakataka verin tamata yai. ");
INSERT INTO frd_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ni ilyan ana, ia nala kubang dinar irua verin tamata i ni rahan siwelat yai, beti nfalak verin ia ne, ‘Msiꞌik ma lolin tamata yai ni mngala ra. Wean i kubang ini wol naran, na mala mu kubang a veki ma ewal yaꞌa ki ukati.’ ” ");
INSERT INTO frd_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yesus nfamalik munuk vaivatul kamkuma yai, beti norat dawan Yahudi yai ne, “Tali tamata itelu yai, na iki nfaturu ni silobang a ma al nlobang tamata i rvaval ia yai?” ");
INSERT INTO frd_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Dawan Yahudi yai nfalak verin Yesus ne, “Tamata i nfaturu roak ni silobang verin tamata i rvaval ia yai.” Ba Yesus nfalak verin ia ne, “Muti ma motu vali wean inyai!” ");
INSERT INTO frd_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesus nfamalik munuk afa avyai, beti irmunuk Ni tamata ovi rorang Ia rban-ewal vali ma rti raran ahu isa. Naꞌa inyai, na vata isa i naran Marta nasweang Ia ma nanaꞌa ni rahan. ");
INSERT INTO frd_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta warin isa naran Maria. Ia ndok-ebang Duilaꞌa Yesus ean a ma al nrenar afa ovi nfalak ra. ");
INSERT INTO frd_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Naꞌuk Marta wol ndok-nala wan isa al nasusan fanaꞌan-fanenu verin ira munuk. Ia ti nfaseri Yesus ma nfalak ne, “Duilaꞌa, Oa wean i wol mkamlabir yaꞌa, ma aksa yaꞌa ukarya watan. Msinir ia ma nlobang yaꞌa!” ");
INSERT INTO frd_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Duilaꞌa nfalak ne, “Marta, oa ralam a kakoꞌu daꞌin ovu kaꞌi motu susa watan tenam a ovu afa avyai. ");
INSERT INTO frd_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Velik aba, oa pwerlu afa isa watan. Maria nfili roak afa i lolin a, ma afa yai tamata ra wol bisma rala tali ia.” ");
INSERT INTO frd_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Amar isa, na Yesus naflurut naꞌa wan isa. Ti ma naflurut munuk, na tamata isa tali Ni tamata ovi rorang Ia nfalak verin Ia ne, “Duilaꞌa, mair ami ma amaflurut, wean watan i Yohanes nair roak ni tamata ovi rorang ia ma raflurut.” ");
INSERT INTO frd_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ba Yesus nfalak verin ira ne, “Wean i miflurut, na fyalak wean ini, Yamamami, amalang Oa, tevek naram a nmerat urun. Mwa ovu Mu Fareta a ma fwareta ami. ");
INSERT INTO frd_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Amera ma mala afamtahan verin ami ma naran ma amaꞌan amar ini. ");
INSERT INTO frd_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Fara maꞌi vatuk mami salasilan ra, wean ami amabun roak tamata ovi rotu salasilan verin ami. Deka mtorung ma tamata ra te nitdawan a rlabir teman ami.” ");
INSERT INTO frd_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yesus nfalak ewal verin ira ne, “Wean i tamata isa ntali mia nti ni kida ni rahan a nafafruan tenan, ma nfalak verin ia ne, ‘Kida, er-teri mu roti itelu veki, ");
INSERT INTO frd_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","tevek ning kida isa naꞌa ni banbanan a, beti nwelat ning rahan, ovu yaꞌa wol ning afakataka ma ala ma naꞌan!’ ");
INSERT INTO frd_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Wean i ni kida nfalak tali rahan ralan ne, ‘Deka mlabir yaꞌa. Ukusi roak falfolat a, ovu vali ovun yanak ra amtuba roak. Yaꞌa wol ukamlabir ma ubatar, ovu yaꞌa wol bisma ala afa verin oa.’ ");
INSERT INTO frd_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Mryenar ma lolin afa ovi ufalak ini! Velik ne irua rotu kida roak, naꞌuk afa yai wol notu ma ni kida yai veka nbatar ma nala afa verin ia. Naꞌuk tamata yai nera ma wol ntalik lahir, tevek wol nmaꞌit, ba ni kida yai veka nbatar ma nala afa ovi nera ra. ");
INSERT INTO frd_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Wean inyai bi ufalak verin mia ne, myera verin Ubu naꞌa afa ovi ralabira ra rfalak ra, na Ia veka nala verin mia. Mdyava urun ia, na veka mtyuan. Myevan falfolat a, na falfolat a veka natvadil verin mia. ");
INSERT INTO frd_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Tamata ovi rera verin Ubu, ira veka rala afa ovi rera yai tali Ia. Tamata ovi rdava afa ovi ralarira ra rfalak ra, ira veka rtuan vali. Tamata ovi revan falfolat a, falfolat a veka natvadil vali verin ira. ");
INSERT INTO frd_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","12","Tali bir tinemun, na wean i yanabira nera ian tali mia, na veka myala nifa verin ia? Te wean i yanabira nera matatelur, na veka myala afwatan i naran katkatan a verin ia? ");
INSERT INTO frd_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Velik ne bira salasilan rivun, naꞌuk mkyaꞌa ma myala afa ovi lolin ra verin yanabira ra. Ba Yamabira i naꞌa lanit ratan veka notu ma nlia tali inyai! Ia veka nala Ni Roh verin tamata ovi rera tali Ia.” ");
INSERT INTO frd_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Amar isa, na Yesus naling vatuk nait sian tali tamata isa i nmanu a. Ti ma nait sian yai nti talik tamata yai, na ia nangrihi nala lahir. Ba tamata rivun ovi rnaꞌa inyai rtalkaka munuk. ");
INSERT INTO frd_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Naꞌuk tamata boku rfalak ne, “Ia naling vatuk nait sian yai, tevek Beelzebul i notu dawan verin nait sian ra, nala ngrebat verin Ia.” ");
INSERT INTO frd_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Tamata boku vali mane rlabir teman Yesus, ba rera ma notu mujizat, boma rkaꞌa ne, Ni ngrebat yai ntali Ubu te wahal. ");
INSERT INTO frd_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Naꞌuk Yesus nkaꞌa afa ovi ranovak ra, ba nfalak verin ira ne, “Wean i rsiduk nuhu dawan isa naꞌut ifira ma sidovung ra rotu rihi, na nuhu dawan yai veka namaꞌar. Wean inyai vali wean i tamata ra rsingarahi naꞌa rahan teta isa, na rira rahan teta veka namaꞌar vali. ");
INSERT INTO frd_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Nitdawan ni fareta a wean vali inyai. Wean i nitdawan nsingarahi-sikual ovu ni nait sian ra, na ni fareta veka namaꞌar. Ufalak wean ini, tevek mia fyalak ne, Yaꞌa aling vatuk nait sian ra ovu ngrebat tali Beelzebul. ");
INSERT INTO frd_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Wean i fyalak ne, aling vatuk nait sian ra ovu ngrebat i ntali Beelzebul, na tamata ovi rorang mia yai rala ngrebat tali iki ma raling vatuk nait sian avyai? Tamata ovi rorang mia yai kaꞌi rfaturu lahir ne, sala mia. ");
INSERT INTO frd_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Naꞌuk wean i aling vatuk nait sian ra ovu Ubu Ni ngrebat a, na inyai nfaturu lahir ne, Ubu Raja Ia, ma nma roak ma nfareta tamata ovi rorang Ia. ");
INSERT INTO frd_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Wean i tamata ngrebat isa ni mneran ra rngora lahir ma nwanar ni rahan a, na tamata ra wol rabrahi ma rala ni metan ra. ");
INSERT INTO frd_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Naꞌuk wean i tamata isa nangrebat lia ia nma ma notu rihi ma nfaleka ia, na tamata i nangrebat lia ia yai veka nala munuk ni mneran ovi nanovak ne, bisma nala ma al nfaleka tamata ovi rangal ia a. Notu munuk wean inyai, beti nsiduk tamata yai ni metan ra. ");
INSERT INTO frd_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Tamata iki watan wol norang Yaꞌa, na ia nangal roak Yaꞌa. Tamata iki watan wol nkarya ovu Yaꞌa, na ia not-visal karya.” ");
INSERT INTO frd_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Wean i nait sian nti talik roak tamata isa, na nait sian yai veka nlilin watan nti wan ovi wol wear naꞌa ma ndava wan ma nyari ia, naꞌuk wol ndav-nala wan. Ba wean inyai, na ia veka nfalak ne, ‘Yaꞌa veka ewal yaꞌa ma ti unaꞌa ewal rahan i uti talik roak ia yai!’ ");
INSERT INTO frd_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ba nait sian newal ia nti rahan yai ma nsiꞌik, na rahan yai rbitin roak ma nmerat, ovu rasusan ma afakataka munuk rnaꞌa warira ra. ");
INSERT INTO frd_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Nata nti murin, ma nasweang nait sian ifitu ewal ma irmunuk rti ma rnaꞌa tamata yai. Nait sian avyai rira sian a nlia nait sian lan a. Ba, ti nata tamata yai ni vavaꞌat a sian lia lan a.” ");
INSERT INTO frd_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Naꞌut i Yesus nangrihi obin, na vata isa tali tamata rivun avyai nafwak ma vain a dawan urun, ma nfalak verin Ia ne, “Lolin urun verin vata i nlewan Oa, ovu nsusu Oa.” ");
INSERT INTO frd_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Naꞌuk Yesus nfalak verin ia ne, “Lolin lia munuk verin tamata ovi rarenar Ubu Ni vaivatul ra ovu rot-orang!” ");
INSERT INTO frd_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Naꞌut i tamata ra rtafal ma rivun ira ma rsiꞌik Yesus, na Ia nfalak verin ira ne, “Tamata ovi rvaꞌat naꞌa tuvu ini raktufan urun. Ira rera ma otu faneak i tamata ra wol rala nala, naꞌuk otu watan faneak i wean lan a Ubu notu roak verin nabi Yunus. ");
INSERT INTO frd_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Wean watan Yunus neluk faneak verin tamata Niniwe ra, na Yaꞌa, Tamata Yanan Yaꞌa ini, veka wean vali inyai, ma eluk faneak verin tamata ovi rvaꞌat naꞌa tuvu ini. ");
INSERT INTO frd_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Naꞌut amar i Ubu veka nma ma nukun lanit ivavan a, na ratu i ntali nuhu dawan isa i raroa ilaꞌa naꞌa tranan a, veka nfaturu lahir tamata ovi rvaꞌat naꞌa tuvu ini rira sala ra. Ratu ini nma ma nrenar Raja Salomo i ni kakaꞌa dawan tali Ubu. Naꞌuk Ia i nanaꞌa fiang ini, Ni dawan a nlia Salomo! ");
INSERT INTO frd_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Naꞌut amar i Ubu veka nma ma nukun lanit ivavan ini, na tamata Niniwe veka rdiri vali ovu tamata ovi rvaꞌat naꞌa tuvu ini ma rtaꞌi nuang ira, tevek tamata Niniwe avyai rahil ma rtalik roak tali rira salasilan ra naꞌut i Yunus nangrihi verin ira. Naꞌuk Ia i nanaꞌa fiang ini Ni dawan a nlia Yunus!” ");
INSERT INTO frd_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Wol tamata isa ntutun damar ma nfonak te nulang teri ia ovu suran. Naꞌuk ia nfadoku naꞌa damar wan, boma tamata ovi rti rahan ralan a bisma rsiꞌik munuk yeban a. ");
INSERT INTO frd_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Matabira ra reluk damar verin tenabira ra. Wean i matabira ra lolin, na lyawan a nsoru lahir tenabira ra. Naꞌuk wean i matabira ra lavlova, na dedan a veka nsoru lahir tenabira ra. ");
INSERT INTO frd_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ba wean inyai, na msyiꞌik wabira ma lolin. Deka mane lyawan i nanaꞌa tenabira avyai ti ma nanaꞌa dedan ralan. ");
INSERT INTO frd_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Wean i tenabira munuk lahir lyawan, ovu wol isa vali dedan, na inyai nfaturu ne, tenabira ra munuk lahir lyawan, wean damar yeban a nyeba tenabira ra.” ");
INSERT INTO frd_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ti ma Yesus nsiair munuk roak, na tamata Farisi isa nasweang Ia ma nafnaꞌan naꞌa ni rahan a. Ba nti rahan yai ralan a ma nafnaꞌan. ");
INSERT INTO frd_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Tamata Farisi yai nabrian lahir, tevek Yesus wol nraming liman a obin, na nafnaꞌan roak. ");
INSERT INTO frd_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Naꞌuk Duilaꞌa nfalak verin ia ne, “Mia tamata Farisi ra baꞌi mryaming watan bira kobi ovu bira binan muririra ra ma rmerat, naꞌuk ralarira ra ngra-ngrodi. Mia ralabira ra wean tamata ovi raktufan ra ovu tamata ovi inar ma rtafal ilaꞌa rira metan ra. ");
INSERT INTO frd_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Tamata boda averi! Mia mkyaꞌa roak ne, Ubu kaꞌi notu afa ovi rnaꞌa murin a, ovu vali afa ovi rnaꞌa ralan a. ");
INSERT INTO frd_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Naꞌuk myala ovu ralabira urun afa ovi rnaꞌa mia verin tamata kasian ra. Myotu wean inyai, na ralabira ovu tenabira veka rmerat urun naꞌa Ubu wahan ralan a. ");
INSERT INTO frd_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Mia tamata Farisi ra myala bira persen vutu a tali bira vaꞌi bumbu ra verin Ubu. Bumbu avyai wean selasih ovu inggu, ovu vali sayur liak ra. Velik ne myotu wean inyai, naꞌuk veka sian urun i lahir verin mia, tevek wol myotu afa ovi rmalola ra verin tamata liak ra, ovu wol mlyobang Ubu. Ba mia musti myot-orang inukun ovi ula lalean avyai, ovu vali deka miblufang ma myotu vali afa liak ovi Ubu nfareta roak. ");
INSERT INTO frd_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Veka sian urun i lahir verin mia tamata Farisi ra, tevek inabira ma mdyoku wan ovi tamata ra baꞌi ralang mia, naꞌa rahan falurut, ovu inabira ma tamata ra ralang mia ma rala salam verin mia naꞌa wan i rfedi-rfaha afa naꞌa. ");
INSERT INTO frd_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Mia tamata Farisi ra veka sian urun i lahir verin mia! Mia weabira lahir kubur a, naꞌuk wol rfaneak ne, inyai kubur. Ba tamata ovi rbana naꞌa ratan a, wol rkaꞌa ne, matmatan ra rnaꞌa ralan. Mia myotu ma felabira ra wean tamata lolin mia, naꞌuk ralabira ra sian urun.” ");
INSERT INTO frd_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Tamata isa tali Yahudi rira tamata ovi baꞌi rair Musa ni inukun ra nfalak verin Yesus ne, “Tuan Guru, tali afa ovi fwalak yai, na Oa fwalak sian vali ami!” ");
INSERT INTO frd_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesus nfalak ne, “Tamata ovi baꞌi myair Musa ni inukun ra, veka sian urun i lahir verin mia vali. Mia myala varvara aleman verin tamata ra tali afa ovi myair ra. Ba tamata ra wol rvar-nala afa avyai, naꞌuk mia wol mlyauk limabira ra ma al mlyobang ira. ");
INSERT INTO frd_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Mia myotu ma nabi rira kubur ra lolin buas. Naꞌuk velik aba, mia weabira watan ububir-nusibira ovi rfedan roak nabi avyai, ba veka sian urun i lahir verin mia. ");
INSERT INTO frd_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Myotu wean inyai, na kaꞌi fyaturu lahir ne, mia mtyorung afa ovi ububir-nusibira ra rotu ra, tevek ira rfedan nabi avyai, ovu mia ini kaꞌi myotu warira ovi roving ira naꞌa. ");
INSERT INTO frd_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Wean inyai bi Ubu i Ni kakaꞌa dawan a nfalak ne, ‘Yaꞌa veka usinir nabi ra ovu rasul ra verin ububir-nusibira ra. Ira veka rfedan rasul ovu nabi boku, ovu veka rwi-rwa boku vali!’ ");
INSERT INTO frd_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ubu notu wean inyai, boma nukun tamata ovi byaꞌat fiang ini, tevek ububir-nusibira ra rfedan nabi ra munuk. Ba mia byara rira matmatan ra, tali naꞌut i Ubu notu lanit ivavan a. ");
INSERT INTO frd_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Tali lalan ana, ububir-nusibira ra rsifedan. Ira rfedan lan Habel. Rfedan vali tamata liak ovi rira vavaꞌat ra rmalola, ti naran i rfedan Zakharia. Ira rfedan ia naꞌa Rahan Dawan Falurut a, ovu wan i baꞌi rasnuri rira afwatan ra verin Ubu, naꞌa wan irua yai fruarira ra. Mia tamata ovi byaꞌat fiang ini, mryenar ma lolin afa ovi ufalak ini! Ubu veka nukun mia naꞌa ububir-nusibira ra rira afa sala avyai. ");
INSERT INTO frd_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Mia dawan Yahudi ovi myair Musa ni inukun ra, veka sian urun i lahir verin mia! Mia wean i mtyaha kusi ma al byadil tamata rira fikiran ra ma rkaꞌa kakaꞌa dawan i ntali Ubu. Naꞌuk mia wol mdyava kakaꞌa yai, ovu myotu teri tamata ovi inar ma rkaꞌa vali!” ");
INSERT INTO frd_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ti ma Yesus nban-talik wan yai, na Yahudi rira dawan ovi baꞌi rair Musa ni inukun ra ovu tamata Farisi ra vairira dawan ma rorat lablabas watan Ia. Ira rorat afa rivun rasan tali Ia, boma nvalat ira naꞌa afa rivun ovi rorat ra. ");
INSERT INTO frd_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ira rotu wean inyai ma al rlabir teman Ia, boma wean i nvalat sala afa boku, na bisma rtaha Ia. ");
INSERT INTO frd_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Naꞌut inyai, na tamata rivun ilaꞌa ti rasdovu ira, ma boku rdir-sidekin watan ira ovu rsita earira ra al rsiꞌik ovu rarenar afa ovi Yesus nair ra. Ia nair lan Ni tamata ovi rorang Ia ma nfalak ne, “Msyiꞌik ma lolin sidovung tamata Farisi rira ragi a. Deka myot-orang ira, tevek rfalak afa isa, naꞌuk rotu afa liak. ");
INSERT INTO frd_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Afa fanfonak ovi tamata rotu ra veka rvotuk, ovu afa ovi rfonak naꞌa ralarira ra veka lyawan vali. ");
INSERT INTO frd_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ba afa ovi fyamalik naꞌa dedan ralan, na veka rvotuk naꞌut i amar a ma tamata ra rkaꞌa. Afa ovi fyifi watan verin tamata ra naꞌa kamar ralan, na tamata liak ra veka rti ma rfamalik ma tamata rivun a rkaꞌa.” ");
INSERT INTO frd_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Ning kida averi, deka byobar tamata ovi inar ma rfedan tenabira ra, tevek wol rot-nala ma nlia tali inyai. ");
INSERT INTO frd_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Yaꞌa mane ufalak verin mia ne, byobar aꞌuk Ubu! Ia wol mane Ni ngrebat watan ma nfedan tamata ra, naꞌuk Ia Ni ngrebat vali ma nvatuk ira rti yafwan kakiwal. Wean urun inyai, bi ufalak verin mia ne, ‘Byobar aꞌuk Ubu!’ ");
INSERT INTO frd_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Eka minovak! Subit ilima fyawarira ra koꞌu lalean. Velik ne fyawarira koꞌu, naꞌuk Ubu wol nablufang isa vali, tevek Ia nsiꞌik munuk subit ra. ");
INSERT INTO frd_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Wean vali inyai verin vut ovi rnaꞌa ulubira ra. Ubu nrekan ovu nkaꞌa munuk vali roak, ba deka byobar, tevek Ubu nsiꞌik ma lolin mia. Mia fyawabira lia subit ra!” ");
INSERT INTO frd_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Mryenar ma lolin afa ovi ufalak ini! Tamata iki watan ntorung ne, norang Yaꞌa naꞌa tamata waharira ralan ra, na Yaꞌa, Tamata Yanan Yaꞌa ini, veka utorung vali ia naꞌa Ubu Ni sansinir ovi rnaꞌa lanit ratan waharira ralan ra. ");
INSERT INTO frd_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Naꞌuk tamata iki watan wean i nalak ia ne, wol nkaꞌa Yaꞌa naꞌa tamata waharira ralan ra, na Yaꞌa veka alak vali ia ne, wol ukaꞌa ia naꞌa Ubu Ni sansinir ovi rnaꞌa lanit ratan waharira ralan ra. ");
INSERT INTO frd_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Tamata iki watan nfalak afa boku ma nangal Yaꞌa, Tamata Yanan Yaꞌa, na Ubu veka naꞌi vatuk ni salasilan avyai. Naꞌuk tamata iki watan wean i nfalak sian Ubu Ni Roh a, na Ubu veka wol naꞌi vatuk roak ni salasilan ra. ");
INSERT INTO frd_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Wean i tamata ra rtaha mia ti ma mdyiri Yahudi rira dawan waharira ralan ra naꞌa rira rahan falurut ra, te fareta waharira ralan ra ma rurus mia, na deka ralabira raruan naꞌa afa ovi veka fyalak ma al mlyotar tenabira ra. ");
INSERT INTO frd_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Tevek naꞌut inyai vali, na Ubu Ni Roh a veka nfalyawang verin mia naꞌa afa ovi musti fyalak ra.” ");
INSERT INTO frd_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Tali tamata rivun avyai, na brana isa nfalak verin Yesus ne, “Tuan Guru, fwalak verin aꞌang a ma nsiduk yamamami ni metan ra ovu fautnanan ovi nfadoku roak verin amrua.” ");
INSERT INTO frd_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesus nfalak verin ia ne, “Iki nsikat yaꞌa ma eluk tamata fareta ma usiduk bira metan ra?” ");
INSERT INTO frd_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Nata Yesus nfalak ewal verin tamata rivun avyai ne, “Msyiꞌik wabira ma lolin ma deka inabira ma mtyafal ilaꞌa bira metan ra, tevek tamata rira vavaꞌat ra wol rakloꞌi watan naꞌa rira metan ra, velik ne rira metan rivun ilaꞌa.” ");
INSERT INTO frd_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Yesus nfamalik vaivatul kamkuma isa ma nfalak ne, “Tamata kaꞌi isa ni vaꞌi a ihin urun. ");
INSERT INTO frd_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Tamata yai nanovak naꞌa ralan a ne, ‘Wol wan roak ma ufadoku ning metan ra, ba fiang ini veka otu afaka?’ ");
INSERT INTO frd_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ba nanovak ewal vali ma nfalak ne, ‘Aꞌar munuk aꞌuk wan ovi ufadoku ning vaꞌi ihin ra, boma ufadiri ewal wan avyai ma veran rahi wan ovi ufadiri lan ra. Otu wean inyai, boma bisma ufadoku ning vaꞌi ihin ra ovu metan ra naꞌa. ");
INSERT INTO frd_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Otu munuk wean inyai, beti kaꞌi unovak naꞌa ralang a ne, yaꞌa inak urun, tevek ning metan ovu vaꞌi ihin ra rivun roak, ovu bisma uvaꞌat tali varat nti varat. Ba fiang ini uyari watan yaꞌa ma ufnaꞌan-ufnenu ovu otu inak lolin watan.’ ");
INSERT INTO frd_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Naꞌuk Ubu nfalak verin ia ne, ‘Hei, oa bwoda urun! Ovan ini lahir, na oa veka mwata, ba iki veka ni munuk mu metan rivun ovi musdovuk roak yai?’ ");
INSERT INTO frd_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Tamata ovi baꞌi rasdovuk rira metan ra ma al rfakaꞌi watan tenarira ra, wor watan ira, tevek wol rkaꞌi naꞌa Ubu wahan ralan a.” ");
INSERT INTO frd_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yesus nfalak verin Ni tamata ovi rorang Ia ne, “Ba ufalak verin mia ne, deka ralabira kakoꞌu naꞌa bira vavaꞌat ra ovu bira fanaꞌan-fanenu ra. Deka ralabira kakoꞌu vali naꞌa afa ovi veka myung a myeluk ra. ");
INSERT INTO frd_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Tevek bira vavaꞌat a fyawan lia bira fanaꞌan ra, te bira kadaravit ra. ");
INSERT INTO frd_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Eka msyiꞌik manut nangan ra! Ira wol ravuri-rava nabat ra, ovu wol rala vaꞌi ihin ra, ovu vali wol wan ma rfadoku vaꞌi ihin ra naꞌa, naꞌuk Ubu nala afamtahan verin ira. Mia fyawabira lia manut nangan avyai, ovu Ubu nlobang mia nlia manut nangan ra! ");
INSERT INTO frd_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Wean i tamata isa ralan kakoꞌu naꞌa ni vavaꞌat a, na ia veka wol ntafal amar isa vali naꞌa ni vavaꞌat. ");
INSERT INTO frd_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ba wean i wol myot-nala afa koꞌu yai, na afakinimi ralabira kakoꞌu naꞌa afa liak ra? ");
INSERT INTO frd_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Eka msyiꞌik aa rira fafun ra. Ira wol rkarya ovu wol rafedu ma rotu rira kadaravit. Mryenar ma lolin afa ovi ufalak ini! Raja Salomo nkaꞌi urun, naꞌuk ni kadaravit ovi neluk ra, na wol isa vali lolin lia tali fafun avyai. ");
INSERT INTO frd_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ubu notu ria ovi rnaꞌa vaꞌi ra ma felarira lolin, velik ne amar ini rvaꞌat obin, naꞌuk ilyan te ravrua, na rasnuri roak ira. Mia fyawabira nlia munuk ira! Ia nsiꞌik mia nlia tali ria avyai. Naꞌuk wol myorang ne, Ubu nlobang mia nlia tali ria avyai! ");
INSERT INTO frd_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ba deka fyikir daꞌin afa ovi veka mian te myenu ra, ovu ralabira deka kakoꞌu. ");
INSERT INTO frd_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Tamata ovi wol rorang Ubu rdava lalawatan afa avyai, naꞌuk Yamabira nkaꞌa munuk afa ovi mdyava naꞌa bira vavaꞌat ra. ");
INSERT INTO frd_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ba mtyorung ma Ubu nfareta mia wean lahir Raja, na Ia veka nfakena munuk afa ovi mdyava ra. ");
INSERT INTO frd_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Tamata ovi myorang Yaꞌa, velik ne bira sidovung a koꞌu watan, naꞌuk ralabira ra deka kakoꞌu! Tevek Yamabira inan ma nala Ni kalolin ra verin mia tali Ni Fareta a. ");
INSERT INTO frd_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ba miti ma fyedi bira metan ra, ma myala kubang avyai verin tamata kasian ra. Myotu wean inyai, na misdovuk roak bira metan ra naꞌa lanit ratan. Metan avyai wol rakvisal nala, nata ti wol ni wahan, ovu tamata barborin ra wol bis rala nala, ovu ngafat ra wol bisma raꞌan nala. ");
INSERT INTO frd_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Tevek wean i fyadoku bira metan ra naꞌa wan isa, na ralabira ra veka rnaꞌa vali inyai.” ");
INSERT INTO frd_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","“Naꞌut inba watan, velik ne ovan te amar, na musti misusan wabira ma lolin ma mkyarya urun verin Ubu. Myotu wean tamata sansinir ovi rnaban duarira ra ma newal ia tali snobsifa. Ira rasusan lalawatan warira ma rkarya ovu rwanar ma lolin rira damar ra ma deka rmata, boma wean i duarira newal ia ma nevan falfolat a, na yarak ti ma rvadil falfolat a. ");
INSERT INTO frd_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Tamata sansinir ovi rasusan warira ma lolin ma al rnaban duarira ra veka uturira. Afa i ufalak verin mia ini, kena urun! Duarira yai veka nfalak ma ni tamata sansinir avyai rdoku, beti ia kaꞌi nasusan afamtahan verin ira. ");
INSERT INTO frd_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Tamata sansinir avyai veka uturira wean i duarira newal ia, na ntuan ira rasusan warira ma lolin ma al rnaban ia, velik ne nafafruan tenan te nfadaꞌing amar. ");
INSERT INTO frd_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Mingnanang afa ovi ufalak ini! Wean i rahan duan nkaꞌa ne, jam ifira beti tamata barborin nma, na ia veka nsiꞌik ma lolin ni rahan a, boma deka nti ni rahan ralan. ");
INSERT INTO frd_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Wean inyai bi lokat amar, na musti msyiꞌik wabira ma lolin, tevek wol mkyaꞌa ne, naꞌut inba na Yaꞌa, Tamata Yanan Yaꞌa, veka uma.” ");
INSERT INTO frd_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Petrus nfalak ne, “Duilaꞌa! Vaivatul kamkuma yai fwamalik watan verin ami, te verin tamata liak ra vali?” ");
INSERT INTO frd_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Duilaꞌa nfalak verin ia ne, “Tamata sansinir isa nasusan duan ni rahan, ovu not-orang lalawatan afa ovi duan a nfalak ra, ovu vali ni kakaꞌa dawan. Ba duan a veka nfili ia ma nfareta tamata sansinir liak ra, ovu nala afamtahan lokat amar ma raꞌan. ");
INSERT INTO frd_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Tamata sansinir yai veka utun urun naꞌut i duan a newal ia, na ntuan ia nfabana ni karya ra. ");
INSERT INTO frd_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Afa i ufalak verin mia ini, kena urun! Tamata sansinir yai duan a veka nfili ia ma nasusan munuk ni metan ra. ");
INSERT INTO frd_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","46","Naꞌuk wean i tamata sansinir yai naktufan ma nanovak naꞌa ralan a ne, ‘Mnanat obin beti duang nma ewal.’ Ba ti ma nvaval tamata sansinir vata ovu brana ra, ovu vali nafnaꞌan-nafnenu ovu boranavut ia. Tamata sansinir yai notu watan wean inyai, ti naran i duan newal ia naꞌa amar i wol nkaꞌa. Ba duan a veka nfar-visal ia ma rvatuk ia, ma ia wean lahir tamata i wol norang Ubu. ");
INSERT INTO frd_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Tamata sansinir i nkaꞌa afa ovi duan ralan nfalak a, naꞌuk wol nasusan tenan a ma not-orang afa ovi duan ralan a nfalak a, na veka nfar-visal ia. ");
INSERT INTO frd_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Naꞌuk tamata sansinir i wol nkaꞌa afa ovi duan ralan nfalak a ma notu sala, na inovan ma rukun ia. Ira veka rvaval ia, naꞌuk wol aleman. Tamata iki watan wean i Ubu nala roak varvara verin ia ma nfareta tamata liak ra, naꞌuk wol not-orang afa ovi Ubu nfalak ra, na Ubu veka nukun tamata yai nlia tali tamata liak.” ");
INSERT INTO frd_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yesus nfalak verin Ni tamata ovi rorang ia ne, “Deka minovak ne, Yaꞌa uma lanit ivavan ini ma otu ma malinan, naꞌuk uma ma ukun tamata ra, wean yafu i nlevur a, ovu inak ma rsidovuk kikyai yafu yai! ");
INSERT INTO frd_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Yaꞌa musti utuan susa i dawan a. Ba ralang a wol malinan lahir, ti naran i susa yai nlia. ");
INSERT INTO frd_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Mia minovak ne, uma lanit ivavan a ma otu ma malinan? Wahal! Mryenar ma lolin afa ovi ufalak ini! Uma lanit ivavan ini, na wol otu ma malinan, naꞌuk otu ma tamata ra rsingarahi. ");
INSERT INTO frd_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ba tali fiang ini, na wean i tamata ilima rnaꞌa rahan teta isa, na veka rsitaku ulu ma tamata itelu rangal tamata irua, te tamata irua rangal tamata itelu. ");
INSERT INTO frd_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ira veka kaꞌi rsitaku ulu. Brana ra veka rangal yamarira ra, ba yamarira ra veka rangal vali ira. Vata ra veka rangal renarira ra, ba renarira ra veka rangal vali ira. Etan ra veka rangal avarira ra, ba avarira ra veka rangal vali ira.” ");
INSERT INTO frd_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesus nfalak verin tamata rivun avyai ne, “Wean i msyiꞌik mutan ra rdiri naꞌa lihir varat, na fyalak lahir ne, veka daꞌut, na veka daꞌut lahir wean i fyalak a. ");
INSERT INTO frd_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Wean i nait tranan, na mia fyalak ne, veka lera, na lera lahir ma wean i fyalak a. ");
INSERT INTO frd_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Hoi, mia tamata ovi fyalak afa isa, naꞌuk myotu afa liak! Mia msyiꞌik lanit ovu lanit ivavan felan a, na mkyaꞌa ma fyalak ne, veka daꞌut te lera. Naꞌuk afakinimi msyiꞌik afa ovi otu ra, ovu vali mryenar Ning Ivar Lolin a, naꞌuk wol fyan-aran?” ");
INSERT INTO frd_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Mia musti fyikir ma lolin afa ovi kena ra ma myot-orang! ");
INSERT INTO frd_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Wean i tamata isa nti ma nmangadu oa verin tamata i baꞌi nfaleka inukun verin tamata ra, na musti mkiwal ma naꞌa bira banbanan obin, na motu ma lolin ovu ia. Tevek wean i wol motu wean inyai, na tamata yai veka nkiwal ma novun oa ti verin tamata i baꞌi nfaleka inukun verin tamata ra, beti tamata i baꞌi nfaleka inukun yai novun oa ti verin polisi ra ma raꞌabuꞌi oa. ");
INSERT INTO frd_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Mrenar ma lolin afa i ufalak ini! Ira veka wol rfatalik oa tali buꞌi ralan yai, wean i wol bwahir munuk mu utan ra obin.” ");
INSERT INTO frd_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Naꞌut i Yesus nair tamata rivun, na boku rma ma rfamalik verin Yesus ne, Pilatus nfedan roak tamata Galilea boku. Ia nfedan ira naꞌut i rfedan afwatan ra ma reluk rira korban verin Ubu. ");
INSERT INTO frd_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesus nfalak verin ira ne, “Mia fyikir ne, tamata Galilea avyai rmata wean inyai tevek rira salasilan ra rivun lia tamata Galilea liak ra? ");
INSERT INTO frd_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Mryenar ma lolin afa ovi ufalak ini! Bira fikiran i wean inyai wol kena lahir! Naꞌuk wean i wol myahil tali bira salasilan ra, na mia veka myata vali wean inyai. ");
INSERT INTO frd_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Mia mingnanang obin rahan dawan i nleka ma ntaꞌi fedan tamata vutu rahin iwalu naꞌa Siloam? Mia fyikir ne, ira rira salasilan ra dawan lia munuk tamata ovi rnaꞌa Yerusalem? ");
INSERT INTO frd_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Mryenar ma lolin afa ovi ufalak ini! Bira fikiran i wean inyai wol kena lahir! Naꞌuk wean i wol myahil ma mtyalik tali bira salasilan ra, na mia veka myata vali wean inyai.” ");
INSERT INTO frd_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yesus ntafal ma nfamalik ewal vaivatul kamkuma isa wean ini, “Aa ara isa naꞌa tamata isa ni vaꞌi anggur a. Amar isa, na tamata yai ndava aa yai vuan a, naꞌuk wol ndav-nala isa vali. ");
INSERT INTO frd_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ba nfalak verin tamata i nasusan ni vaꞌi a ne, ‘Varat itelu roak uma ma udava aa ara ini vuan a, naꞌuk wol udav-nala isa vali. Metal aꞌuk aa ini! Deka nvaꞌat kikyai naꞌa lanun ini, tevek wol nala utun akataka.’ ");
INSERT INTO frd_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Naꞌuk tamata i nasusan vaꞌi yai nfalak ne, ‘Baba, mnaban ma varat isa ewal. Yaꞌa ki ukear lilit aa yai ma otu pupuk naꞌa. ");
INSERT INTO frd_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Snain a varat ewal, na veka vuan roak. Naꞌuk wean i wol vuan, na ki etal vatuk ia.’ ” ");
INSERT INTO frd_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Amar isa naꞌa amar i Yahudi ra ryari ira, na Yesus nsiair naꞌa Yahudi rira rahan falurut isa. ");
INSERT INTO frd_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Naꞌa inyai, na nait sian isa nlabir vata isa ma naran varat vutu rahin iwalu roak, ba nawar ia ma tetan a natbukar, ovu wol ndiri nala ma nmalola. ");
INSERT INTO frd_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ti ma Yesus nsiꞌik vata yai, na nera ia ma nfalak ne, “Titi, lolin roak oa tali mu suhut a.” ");
INSERT INTO frd_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Nata Yesus nfadoku liman a naꞌa vata yai, ba brian munuk, na vata yai tetan wol natbukar roak ma ndiri lahir, ma nfadawang Ubu. ");
INSERT INTO frd_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Naꞌuk tamata i nban-ulu naꞌa rahan falurut yai nangrova, tevek Yesus notu ma lolin tamata naꞌa amar i Yahudi ra ryari ira. Ba nfalak verin tamata rivun avyai ne, “Naꞌa karedralan isa, na tkarya amar inean, ba amar isa tali amar avyai, na bisma mya ma rotu ma lolin mia. Naꞌuk deka mya naꞌa amar i tyari ita!” ");
INSERT INTO frd_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ba Duilaꞌa nfalak ne, “Hoi, mia msyiklabir sian ma fyalak afa isa, naꞌuk myotu afa liak. Naꞌa amar i myari mia, na fyatalik bira karba ra ovu keledai ra tali warira ra ma myovun ira rti wan i baꞌi rafnenu naꞌa. ");
INSERT INTO frd_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Vata ini Abraham ubun-nusin vali ia. Nitdawan nkeak ia varat vutu rahin iwalu roak, ba Yaꞌa musti aling vatuk kakeak yai tali ia, velik ne naꞌa amar i tyari ita!” ");
INSERT INTO frd_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yesus nfalak wean inyai, ba tamata ovi rangal Ia rmaꞌit urun. Naꞌuk tamata rivun inarira lolin urun, tevek Yesus notu afa lolin ovi tamata ra wol rot-nala. ");
INSERT INTO frd_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ba Yesus nfalak ne, “Ubu nfareta tamata ra wean lahir Raja, na veka wean inba? Yaꞌa veka ala vaivatul kamkuma ini ma ufalyawang Ni Fareta yai. ");
INSERT INTO frd_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ubu Ni Fareta wean sesawi ni vatul a. Tamata isa nala sesawi ni vatul a, ma ti nava naꞌa ni vaꞌi a. Sesawi yai veka narubu ma dawan, ba manut nangan ra rti rotu rira renga naꞌa sanan ra.” ");
INSERT INTO frd_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yesus nfalak ewal vali ne, “Yaꞌa veka ala vaivatul kamkuma ra ma ufalyawang Ubu Ni Fareta.” ");
INSERT INTO frd_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ubu Ni Fareta wean ragi. Vata isa nala ragi yai ma nsileti naꞌa terigu loyang dawan isa, nata terigu yai nmela ma dawan. ");
INSERT INTO frd_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ba Yesus nban-ewal mane nti Yerusalem, na nwelat kota ra ovu ahu ra ma nair tamata ra. ");
INSERT INTO frd_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Tamata isa norat Yesus ne, “Duilaꞌa, tamata ifira watan veka rira vavaꞌat kakiwal?” ");
INSERT INTO frd_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Ba Yesus nfalak verin tamata ovi rnaꞌa inyai ne, “Mkyiwal urun ma myahu falfolat i katkotat a! Mingnanang, tevek tamata rivun veka rkiwal ma rti ralan, naꞌuk wol rti nala. ");
INSERT INTO frd_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Wean i rahan duan a ndiri roak ma nfolat falfolat a, na mia veka mydiri murin watan ma myevan falfolat a, ma fyalak ne, ‘Baba, bwadil falfolat a verin ami!’ Ia veka nfalak ne, ‘Yaꞌa wol ukaꞌa mia!’ ");
INSERT INTO frd_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Mia veka fyalak ne, ‘Ami amafnaꞌan ovu amafnenu roak ovu Oa, ovu vali Oa msiair roak naꞌa lingaꞌan ovi rnaꞌa mami ahu ra.’ ");
INSERT INTO frd_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Naꞌuk Ia veka nfalak verin mia ne, ‘Yaꞌa wol ukaꞌa mia ovu wol ukaꞌa ne, mtyali inba mya. Hoi, mia tamata ovi baꞌi myotu aꞌuk afa ovi sian ra, miti talik kikyai wan ini!’ ");
INSERT INTO frd_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ba mia veka msyiꞌik Abraham, Ishak, Yakub ovu nabi ra munuk rotu inarira lolin naꞌa Ubu Ni Fareta Ralan. Naꞌuk mia veka byakar ovu nifabira ra veka rsitutu ira, tevek fyarnuang wawaꞌuk i dawan a. Ubu notu teri mia ma mnyaꞌa murin watan. ");
INSERT INTO frd_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Tamata ra veka rtali timur, varat, marmar ovu tranan rma ma rdoku rafnaꞌan naꞌa Ubu Ni Fareta. ");
INSERT INTO frd_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ba Ubu veka notu ma tamata ovi wol fyawar akataka, fyawar lia munuk tamata ra. Tamata ovi rfakaratat tenarira ra, Ia veka notu ma wol fyawar akataka.” ");
INSERT INTO frd_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Naꞌut inyai vali, na tamata boku tali sidovung Farisi rma ma rfalak verin Yesus ne, “Muti talik lahir wan ini, tevek raja Herodes mane nfedan Oa.” ");
INSERT INTO frd_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yesus nfalak verin ira ne, “Miti lahir Herodes i rfanara ia ne serigala, ma fyalak verin ia ne, Yaꞌa aling vatuk nait sian ra tali tamata ra ovu otu ma tamata ra lolin ira tali rira suhut ra, amar ini ovu ilyan. Ravrua beti Ning karya a roak. ");
INSERT INTO frd_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Velik ne wean inyai, naꞌuk Yaꞌa musti ubana uti Yerusalem amar ini, ilyan ovu ravrua, tevek wol inovan ma rfedan nabi naꞌa wan liak, musti naꞌa Yerusalem.” ");
INSERT INTO frd_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Nata Yesus nfalak ne, “Tamata ovi mnyaꞌa Yerusalem! Mia fyedan nabi ra ovu mtyev-fedan tamata ovi Ubu nsinir ira rma rtuan mia. Yaꞌa umaseak dalang roak ma usdovu mia, wean manut itai isa nkoka yanan ra naꞌa manin vavan a, naꞌuk mifena ma otu wean inyai! ");
INSERT INTO frd_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ba wean inyai bi Ubu nban-talik bira Rahan Dawan Falurut a, ba veka vu watan. Ufalak verin mia ne, tali amar ini, na veka wol msyiꞌik roak Yaꞌa, ti naran amar i veka fyalak ne, ‘Ubu naflahar Ia i nma ovu Duilaꞌa naran a!’ ” ");
INSERT INTO frd_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Amar isa naꞌut i Yahudi ra ryari ira, na Yesus nti dawan Farisi isa ni rahan ma nafnaꞌan naꞌa inyai. Tamata ovi rnaꞌa inyai rsiꞌik nanuang Ia. ");
INSERT INTO frd_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Tamata isa nma ma ndiri Yesus wahan ralan a. Tamata yai ni suhut notu ma ean ovu liman ra rbara. ");
INSERT INTO frd_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ba Yesus norat Yahudi rira dawan ovi rair Musa ni inukun ra ovu tamata Farisi avyai ne, “Naꞌa Musa ni inukun ra, bis totu ma tamata lolin ira naꞌa amar i ita tamata Yahudi tyari ita a?” ");
INSERT INTO frd_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Tamata avyai munuk wol vairira lahir. Yesus ntaha tamata i ni suhut yai liman a ma notu ma lolin ia, beti nsinir ma newal ia. ");
INSERT INTO frd_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Nata Yesus norat ewal ira ma nfalak ne, “Wean i yanabira isa, te bira sapi isa nleka nsuta wear kakear ralan a, na wol msyuta ma msyikat lahir ia, velik ne naꞌa amar i tyari ita?” ");
INSERT INTO frd_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Naꞌuk wol tamata isa nvalat nala afa i Yesus norat yai. ");
INSERT INTO frd_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yesus nsiꞌik mangun ovi rma dawan Farisi yai ni rahan a, na ira ti rdoku kadera ovi rnaꞌa ulu ra. Ba Yesus nala vaivatul kamkuma isa ma nair ira. Ia nfalak ne, ");
INSERT INTO frd_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Wean i tamata isa nasweang oa ma movu ni snobsifa a, na deka muti mdoku kadera ovi rnaꞌa ulu ra, beta ne snoba duan yai nasweang roak tamata ovi rira van ra dawan lia oa. ");
INSERT INTO frd_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Snoba duan yai veka nma ma nfalak verin oa ne, ‘Deka mungrova, tevek ufadoku roak wan ini verin mangun eri.’ Ba veka mwaꞌit urun i lahir ma ti mdoku kadera ovi rnaꞌa muri lalean a. ");
INSERT INTO frd_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ba wean i rasweang oa ma muti snoba isa, na mdoku kadera ovi rnaꞌa muri lalean a, boma snoba duan yai nfalak verin oa ne, ‘Kida, mwa ma muti mdoku kadera ovi rnaꞌa ulu eri.’ Wean inyai, na snoba duan yai nalang roak oa naꞌa mangun waharira ralan ra. ");
INSERT INTO frd_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Tamata iki watan wean i nfakaratat tenan a, na Ubu veka nfakabava ia. Naꞌuk tamata iki nfakabava tenan a, na Ubu veka nfakaratat ia.” ");
INSERT INTO frd_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Nata Yesus nfalak verin dawan Farisi yai ne, “Wean i musweang tamata ra ma rovu mu snoba a ma rafnaꞌan lera ndirlola te lervava, na deka musweang watan mu kida ra te aꞌam a warim ra, ovu vali tamata kaꞌi ovi rnaꞌa mu rahan nelan a, tevek ira veka rasweang vali oa ma mimunuk mifnaꞌan ma rfaturu ne, raval roak mu lolin a. ");
INSERT INTO frd_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Naꞌuk wean i motu snoba, na musweang tamata ovi rira kasian ra, tamata ovi ear limarira rametal, te tamata ovi ratlukut ra, ovu vali tamata ovi rkibu ra. ");
INSERT INTO frd_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Motu wean inyai, na Ubu veka naflahar oa, tevek tamata avyai veka wol raval nala mu lolin a. Ubu veka nbalas mu lolin yai naꞌut i nfavaꞌat ewal tamata ovi rira vavaꞌat ra rmalola.” ");
INSERT INTO frd_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ti ma rarenar munuk afa ovi Yesus nfalak ra, na tamata isa tali tamata ovi rdoku rafnaꞌan yai nfalak verin Yesus ne, “Lolin urun verin tamata ovi veka rafnaꞌan naꞌa snoba dawan ovu Ubu naꞌa Ni Fareta a!” ");
INSERT INTO frd_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Naꞌuk Yesus nfalak verin ia ne, “Amar isa, na tamata isa notu ni snoba dawan, na ia nasweang ma tamata rivun rma! ");
INSERT INTO frd_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ti ma snoba yai mane nbana, na nsinir ni tamata sansinir isa ma ti nfalak verin tamata ovi nasweang roak ira yai ne, ‘Afakataka rnaꞌa munuk roak, ba mya kikyai.’ ");
INSERT INTO frd_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Naꞌuk tamata avyai munuk lahir, lokat ira, kaꞌi rdava rira lola. Tamata i ula lalean ia nfalak verin sansinir yai ne, ‘Yaꞌa ufaha roak vaꞌi isa, ba musti uti ma usiꞌik. Era ma deka mungrova yaꞌa, tevek wol uti.’ ");
INSERT INTO frd_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Tamata isa vali nfalak ne, ‘Beti ufaha sapi brana vutu a, ba musti uti ma ucoba sapi avyai ma usiꞌik ne, rkarya ma lolin te wahal. Wol bis uti, ba era ma deka mungrova.’ ");
INSERT INTO frd_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Tamata isa vali nfalak ne, ‘Yaꞌa beti usifa, ba veka wol uti mu snoba.’ ");
INSERT INTO frd_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ba sansinir yai newal ia ma ti nfamalik munuk afa avyai verin ni dawan a. Ba rahan duan yai nangrova urun ma nfalak verin ni sansinir yai ne, ‘Muti lahir kota ini ni lingaꞌan koꞌu ovu dawan ra, ma movun tamata kasian ra ovu tamata ovi ear-limarira ra rametal, ovu tamata ovi rkibu ra, ntafal vali tamata ovi ratlukut ra ma rma snoba ini.’ Ba, sansinir yai nti. ");
INSERT INTO frd_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ti ma sansinir yai newal ia, na nfalak ne, ‘Baba, otu munuk roak afa ovi fwalak ra, naꞌuk wan rivun naꞌa snoba ini vu obin.’ ");
INSERT INTO frd_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Snoba duan yai nfalak ne, ‘Muti lahir lingaꞌan dawan ovu lingaꞌan koꞌu ovi rnaꞌa kota murin a ma mkiwal tamata ra ma rma, boma ning rahan a nngora. ");
INSERT INTO frd_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ufalak urun verin mia ne, wol tamata isa vali tali mangun ovi usweang ula roak ira yai veka rfatemang ning afamtahan ovi naꞌa ning snoba ini.’ ” ");
INSERT INTO frd_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Tamata rivun rorang Yesus naꞌa Ni banbanan a. Yesus nfulak wahan a, ma nfalak verin ira ne, ");
INSERT INTO frd_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Wean i tamata isa nma ma norang Yaꞌa, na ia musti nlobang Yaꞌa nlia tali renan a, yaman a, awan a, yanan ra, aꞌan a warin ra, ovu tenan a. Naꞌuk wean i wol notu wean inyai, na ia wol bisma norang Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Tamata i norang Yaꞌa musti ntorung ma ntuan susa, te nmata, wean i nvara ni aa walwalur a. Ba tamata i nafena ma nvara ni aa walwalur, wol bisma norang Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Wean i tamata isa tali mia mane nfadiri rahan dawan isa, na ia musti ndoku ma nrekan ni kubang ra veki, boma bisma nkaꞌa ne, ni kubang avyai naran ma not-nala rahan yai te wahal. ");
INSERT INTO frd_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Tevek, wean i nfadoku roak ni fanderen, naꞌuk wol not-nala rahan yai, na tamata rivun veka rsiꞌik ni karya a ma rmalit ia. ");
INSERT INTO frd_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Tamata avyai veka rfalak ne, ‘Yaꞌi yo, tamata ini mulai roak ma nfadiri ni rahan dawan, naꞌuk ni kubang wol naran ma not-nala munuk!’ ");
INSERT INTO frd_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Wean i raja isa ni suldadu rivun vutu mane rti rotu rihi ovu raja liak isa i ni suldadu rivun vutrua, na raja yai musti ndoku ma nanovak veki ne, ia veka utun raja i ni suldadu rivun vutrua yai te wahal. ");
INSERT INTO frd_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Wean i nkaꞌa roak ne, ia veka wol utun, na naꞌut i raja i ni suldadu rivun vutrua yai raroa ira obin, na nsinir lahir ni suldadu ifira rati rera ma deka rotu rihi.” ");
INSERT INTO frd_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ti nata, Yesus nfalak ne, “Mia weabira vali inyai. Wean i inabira ma myorang Yaꞌa, na musti byan-talik bira metan ra munuk.” ");
INSERT INTO frd_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Sira lolin ma totu ma afamtahan ra lanun. Naꞌuk wean i sira yai wol sarsiran roak, na veka totu aka ma sira yai sarsiran ewal? ");
INSERT INTO frd_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ba rvatuk aꞌuk sira yai, tevek wol bis vali ma rotu naꞌa pupuk ma naꞌa tamata rira vaꞌi ra. Iki arun, na eka nrenar ma lolin.” ");
INSERT INTO frd_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Amar isa, na tamata ovi baꞌi rera babahir kulu ra, ovu tamata salasilan liak ra, rma rtuan Yesus ma rarenar afa ovi nfalak ra. ");
INSERT INTO frd_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ba tamata Yahudi boku rtali sidovung Farisi, ovu rira dawan ovi rair Musa ni inukun ra, rafngamuꞌur ma rfalak ne, “Yaꞌi yo, tamata ini notu ni kida ovu tamata salasilan ra ma nafnaꞌan ovu ira!” ");
INSERT INTO frd_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ba Yesus nala vaivatul kamkuma isa ma nfalak verin ira ne, ");
INSERT INTO frd_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Wean i tamata isa ntali mia ni domba ratut isa, naꞌuk isa wol nleal, na ia veka notu afaka? Ia veka nban-talik domba vutsi rahin isi yai naꞌa wan lean vu i ngrova lalawatan a, ma ti ndava domba i wol nleal yai, ti naran i ndav-nala roak ia. ");
INSERT INTO frd_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ba wean i ntuan roak domba yai, na inan urun i lahir, ma nala domba yai nrata varan a ma newal ia. ");
INSERT INTO frd_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ti ma naran ni rahan, na nera ni kida ra ovu tamata ovi rnaꞌa ni rahan nelan a ma nfalak verin ira ne, ‘Mya ma totu inad lolin, tevek udav-nala roak ning domba i wol nleal a.’ ");
INSERT INTO frd_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ba ufalak verin mia ne, naꞌa lanit ratan veka wean vali inyai. Ubu ralan a veka lolin urun, tevek tamata salasilan isa nahil ma ntalik roak tali ni salasilan ra. Ralan lolin yai nlia tali ralan lolin verin tamata vutsi rahin isi ovi rira vavaꞌat ra rmalola, ma wol rperlu ma rahil ma rtalik tali rira salasilan ra.” ");
INSERT INTO frd_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Nata Yesus nfamalik vaivatul kamkuma isa verin ira ne, “Vata isa ni kubang ihin vutu a, ba wean i isa wol nleal, na veka notu afaka? Ia veka ntutun damar ovu nbitin munuk rahan ralan a ma al ndava ni kubang i wol nleal yai, ti naran i ndav-nala. ");
INSERT INTO frd_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ti ma ndav-nala roak kubang yai, na nera ni kida ra ovu tamata ovi rnaꞌa ni rahan nelan a ma nfalak verin ira ne, ‘Mya ma totu inad lolin, tevek udav-nala roak ning kubang i wol nleal a.’ ");
INSERT INTO frd_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Wean vali inyai verin Ubu Ni sansinir ra naꞌa lanit ratan, ma veka inarira lolin urun, tevek tamata salasilan isa nahil roak tali ni salasilan ra.” ");
INSERT INTO frd_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesus nfalak ewal vali ne, “Tamata isa yanan brana irua. ");
INSERT INTO frd_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Amar isa, na iwarin a nfalak verin yaman a ne, ‘Bapa, msiduk kikyai dida metan ra, ma mala ning wahat a verin yaꞌa.’ Ba yaman a nsiduk lahir ni metan ra verin yanan irua yai. ");
INSERT INTO frd_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Amar ifira nelak watan, na yanan iwarin a ti nfedi munuk lahir ni metan ra ma nti negara i raroa. Naꞌa negara yai, na ia nawahak munuk lahir ni kubang ra ma al notu ni sian a lolin watan. ");
INSERT INTO frd_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ti ma nawahak munuk ni kubang ra, na lafar dawan nkena negara yai. Ba ni vavaꞌat a sian urun i lahir. ");
INSERT INTO frd_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ia nti ndava karya naꞌa tamata isa naꞌa negara yai. Ba tamata yai nala karya verin ia ma ti nwanar ni vavu ra naꞌa ni lanun a. ");
INSERT INTO frd_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ia nablafar daꞌin roak, ba mane naꞌan watan vavu rira afamtahan ra, naꞌuk wol tamata isa vali ntorung ma nala verin ia. ");
INSERT INTO frd_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ti nata ni fikiran lyawan roak ma nfalak naꞌa ralan ne, ‘Tamata ovi rkarya verin yamang a rivun urun ira, ovu rira afamtahan a nngora tia ma watan, naꞌuk unaꞌa ini, na mane umata ning lafar roak! ");
INSERT INTO frd_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Yaꞌa veka ewal yaꞌa ma ti utuan yamang a ma ufalak verin ia ne: Bapa, yaꞌa otu salasilan roak verin Ubu ovu oa. ");
INSERT INTO frd_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Wol inovan roak ma tamata ra rfalak ne, oa yanam yaꞌa. Ba fara mtorung ma ukarya verin oa, wean watan mu tamata karya liak ra.’ ");
INSERT INTO frd_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ba ndiri ma newal ia nti verin yaman a. Nanaꞌa raroa obin, na yaman a nrea lan roak ia, ba nfarnuang lahir naꞌa ralan ma nfaturu ni silobang a, ba nafla nti ma nangabuk ovu nvoan ia. ");
INSERT INTO frd_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ia nfalak verin yaman a ne, ‘Bapa, yaꞌa otu salasilan roak verin Ubu ovu oa, ba wol inovan roak ma tamata ra rfalak ne, oa yanam yaꞌa.’ ");
INSERT INTO frd_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Naꞌuk yaman nfalak verin ni sansinir ra ne, ‘Yarak ti myala ravit blawat i lolin urun a ma myotu ma neluk, ovu myala tatea ma myaꞌadoru naꞌa ean a, ovu vali myala sitana ma myaꞌadoru naꞌa liman a. ");
INSERT INTO frd_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Myotu munuk wean inyai, beti myala sapi koꞌu i ngbabal urun a ma fyedan ia. Ki totu snoba ma tafnaꞌan ovu totu inad lolin. ");
INSERT INTO frd_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Tevek yanak ini nmata roak, naꞌuk fiang ini nvaꞌat ewal. Ia wol nleal roak, naꞌuk fiang ini utuan ewal roak ia.’ Ba rotu lahir rira snoba. ");
INSERT INTO frd_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Naꞌut inyai vali, na yanan iyaꞌan a naꞌa vaꞌi obin. Ti ma newal ia ma nfaseri rira rahan a, na nrenar tamata ra rdedang, rafraik floꞌits ovu rsoꞌi-rsomar. ");
INSERT INTO frd_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ba nera rira tamata sansinir isa ma norat ia ne, ‘Rotu afakinyai?’ ");
INSERT INTO frd_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Sansinir yai nfalak ne, ‘Warim a newal roak ia, ba yamam a nsinir ami ma amfedan roak sapi koꞌu i ngbabal urun a, tevek yanan i wol nleal yai newal roak ia ovu lolin.’ ");
INSERT INTO frd_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ba yanan iyaꞌan yai nangrova urun, ma nafena nti rahan ralan. Nata yaman a nma murin ma nera lablobang ia ma nma ralan. ");
INSERT INTO frd_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Naꞌuk nfalak verin yaman a ne, ‘Varat a nkati varat, na ukarya verin oa wean sansinir. Wol fasa vali obin angal afa ovi fwareta ra, naꞌuk wol mane fasa vali mala bibi koꞌu isa verin yaꞌa ma otu snoba ovu ning kida ra. ");
INSERT INTO frd_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Naꞌuk yanam yai ti ma nawahak munuk roak mu metan ra ovu vatlean ra. Ti ma newal ia, na bapa fwedan lahir sapi koꞌu i ngbabal yai verin ia!’ ");
INSERT INTO frd_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Yaman nfalak verin ia ne, ‘Baba, oa ini mnaꞌa lalawatan ovu yaꞌa, ba ning afakataka munuk, oa mu vali. ");
INSERT INTO frd_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Naꞌuk inovan ma totu snoba ma totu inad lolin, tevek warim ini nmata roak, naꞌuk fiang ini nvaꞌat ewal. Ia wol nleal roak, naꞌuk tatuan ewal roak ia.’ ” ");
INSERT INTO frd_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesus nfalak verin Ni tamata ovi rorang Ia ne, “Tamata kaꞌi isa ni tamata karya isa. Tamata kaꞌi yai nala karya verin ia ma nasusan munuk ni metan ra. Amar isa, na tamata ra rmangadu tamata karya yai verin tamata kaꞌi yai ne, ia nawahak tia ma watan tamata kaꞌi yai ni metan ovu ni kubang ra. ");
INSERT INTO frd_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ba tamata kaꞌi yai nera ni tamata karya yai ma norat ia ne, ‘Yaꞌa urenar roak ivar naꞌa mu karya a, ba eka fwamalik munuk lahir afa ovi ala ma mususan ra, tevek oa wol bisma mususan roak ning metan ovu ning kubang ra!’ ");
INSERT INTO frd_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ba ia nanovak naꞌa ralan a ne, ‘Yaꞌa musti otu afaka fiang ini? Tevek ning dawan a mane nfaleka yaꞌa tali ning karya. Yaꞌa wol ufkear nala, ovu yaꞌa wol bis vali ma era kubang tali tamata ra, tevek umaꞌit. ");
INSERT INTO frd_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Yaꞌa ufikir nala afa isa ma veka otu, tevek sarseri roak ma ning dawan a nfaleka yaꞌa tali ning karya a, ma wol ususan roak ni metan ovu ni kubang ra, na bisma ning kida rivun. Ira veka rala yaꞌa ma ti unaꞌa rira rahan.’ ");
INSERT INTO frd_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ba nera munuk tamata ovi rira utan naꞌa ni dawan a, ma norat tamata avyai lokat ira. Ia norat tamata i ula lalean a ne, ‘Mu utan ifira naꞌa ning dawan a?’ ");
INSERT INTO frd_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Tamata yai nfalak ne, ‘Ngul ngusi ratut isa.’ Ba nfalak verin tamata i ula lalean yai ne, ‘Ini oa mu surat utan a. Mdoku ma mtulis lahir mu surat utan liak a, ne ngul ngusi vutlima watan.’ ");
INSERT INTO frd_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Nata nfalak vali verin tamata i norang hi ula lalean a ne, ‘Oa mu utan ifira?’ Tamata yai nfalak ne, ‘Gandum tenat rivun isa.’ Ba nfalak vali verin tamata yai ne, ‘Mala mu surat utan ini ma mdoku ma mtulis lahir mu surat utan liak a, ne gandum tenat ratut iwalu watan.’ ");
INSERT INTO frd_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ba tamata kaꞌi yai nfakaratat ni tamata i baꞌi nasusan ni metan ovu ni kubang ra, tevek ni kakaꞌa, velik ne ni bota dawan. Ufalak wean inyai, tevek tamata ovi wol rorang Ubu rira kakaꞌa ma rasusan rira vavaꞌat ra ovu rotu ma tamata ra inar ira, nlia tali tamata ovi rira vavaꞌat ra naꞌa lyawan ralan. ");
INSERT INTO frd_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Myala metan ovi rnaꞌa lanit i vavan ini ma al myotu bira kida, boma wean i metan avyai wol fyawarira roak, na Ubu veka nala mia ti mnyaꞌa lanit ratan. ");
INSERT INTO frd_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Tamata iki watan not-orang lalawatan afa ovi nfalak ra naꞌa afa ovi koꞌu ra, na ia veka not-orang afa ovi nfalak ra vali naꞌa afa ovi dawan ra. Naꞌuk tamata iki watan nsiklabir naꞌa afa ovi koꞌu ra, na ia veka nsiklabir vali naꞌa afa ovi dawan ra. ");
INSERT INTO frd_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ba wean i wol myot-orang afa ovi fyalak ra naꞌa metan koꞌu ovi rnaꞌa lanit i vavan a, na Ubu veka wol norang vali mia ma nala metan dawan ovi rnaꞌa lanit ratan verin mia. ");
INSERT INTO frd_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Wean i msyiklabir ma wol msyiꞌik ma lolin tamata rira metan ra, na iki vali veka nala metan ra verin mia? ");
INSERT INTO frd_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Tamata sansinir isa wol bisma nkarya verin duan irua. Ia veka wol inan lahir isa, naꞌuk nlobang isa. Te veka not-orang lalawatan afa ovi nfalak ra verin isa, naꞌuk wol inan lahir isa. Mia weabira vali inyai, ma wol bisma myala bira vavaꞌat ra verin Ubu, ovu vali myala bira vavaꞌat ra verin bira metan ra.” ");
INSERT INTO frd_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ti ma tamata Farisi avyai rarenar munuk afa ovi Yesus nfalak ra, na rmalit Ia, tevek rlobang urun rira kubang ra. ");
INSERT INTO frd_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ba Yesus nfalak verin ira ne, “Mia myotu felabira ra wean tamata ovi baꞌi rotu aꞌuk afa ovi lolin ra naꞌa tamata waharira ralan ra, naꞌuk Ubu nkaꞌa munuk ralabira ra. Afa ovi tamata ranovak ne lolin urun, na Ubu wol inan lahir afa avyai. ");
INSERT INTO frd_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Musa ni inukun ra ovu nabi rira afa ovi rair ra rbana, nata ti naran Yohanes i nbaptis tamata ra nma. Tali naꞌut inyai, na tamata ra rfamalik Ivar Lolin i nfamalik Ubu nfareta tamata ra wean lahir Raja. Tamata rivun rkiwal ma ti rnaꞌa Ni Fareta yai. ");
INSERT INTO frd_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Musa ni inukun ra munuk, ti naran ni titik koma ra, veka rnaꞌa kakiwal, ma nlia tali lanit ovu lanit ivavan ini. ");
INSERT INTO frd_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Brana iki watan ntalik awan a, ma nsifa ewal ovu vata liak, na brana yai sala roak ia, wean lahir i ntuba ovu tamata i wol awan verin ia. Ba wean i brana iki watan nsifa ovu vata i awan a ntalik roak ia yai, na brana yai sala roak ia vali, wean lahir i ntuba ovu tamata i wol awan verin ia.” ");
INSERT INTO frd_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Nata Yesus nfamalik ewal ne, “Tamata kaꞌi isa baꞌi noru aꞌuk ravit blawat i lolin urun a ovu kadaravit liak ovi fyawar urun a. Lokat amar, na ia notu inan lolin ovu ni kakaꞌi a. ");
INSERT INTO frd_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Tamata isa vali ni kasian a dawan, naran Lazarus. Lokat amar, na ia ntuba naꞌa tamata kaꞌi yai ni falfolat ngoran a. Ni weba ra rsoru lahir tenan a. ");
INSERT INTO frd_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ia mane naꞌan watan afamtahan mumun ovi rleka naꞌa tamata kaꞌi yai ni meja vavan a, naꞌuk wol nal-nala akataka. Yaha ra rma vali ma rlelut ni weba ra. ");
INSERT INTO frd_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Nata tamata kasian yai nmata, ba Ubu Ni sansinir ra tali lanit ratan rma ma rovun lahir ia nti wan i lolin urun a nebang Abraham. Ba tamata kaꞌi yai nmata vali ma ti roving ia. ");
INSERT INTO frd_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Tamata kaꞌi yai nanaꞌa roak yafwan kakiwal, na ni wawaꞌuk a dawan urun i lahir. Ia ntadata ma nsiꞌik tali raroa watan, na Lazarus ndoku wan i lolin urun a nebang Abraham. ");
INSERT INTO frd_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ba nafwak ma nfalak ne, ‘O Bapa Abraham, fara fwaturu Mu silobang verin yaꞌa! Msinir Lazarus ma nsovu liman tutul a naꞌa wear ma nma nfangridin earng a, tevek ufarnuang wawaꞌuk i dawan urun a naꞌa yafu ralan ini!’ ");
INSERT INTO frd_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Naꞌuk Abraham nfalak ne, ‘Mungnanang veki ta baba, tevek naꞌut i bwaꞌat obin a, na oa mu munuk roak afa ovi lolin ra, naꞌuk Lazarus ni watan afa ovi sian ra. Fiang ini Lazarus inan lolin roak, naꞌuk oa mu wawaꞌuk a dawan urun ia. ");
INSERT INTO frd_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Nlia tali inyai vali, na tivat isa i bilaman urun a nelak ita ma oa mnaꞌa lihir a, na ami amnaꞌa lihir a. Ba wean i tamata ovi rtali wamami mane rahu tivat yai ma rti ralola mia, te ovi rnaꞌa inyai mane rma ma ralola ami, na wol bis lahir!’ ");
INSERT INTO frd_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ba tamata kaꞌi yai nfalak ne, ‘Baba, wean inyai ba era lablobang verin oa, ma msinir Lazarus ma nti yamang ni rahan a, ");
INSERT INTO frd_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","tevek aꞌang-waring ilima rnaꞌa rahan yai obin, ma nfangnanang urun ira, boma naꞌut i rmata a, na deka rma wan i ni wawaꞌuk a sian urun ini.’ ");
INSERT INTO frd_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Naꞌuk Abraham nfalak ne, ‘Ira rira roak Musa ovu nabi rira kitab ra. Ba fara rorang watan afa ovi rtulis roak naꞌa kitab avyai!’ ");
INSERT INTO frd_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ba tamata yai kaꞌi nfalak ne, ‘Baba, inyai wol naran obin, naꞌuk wean i matmatan isa nvaꞌat ewal ma nti nfalak verin ira, na ira veka rahil ma rtalik tali rira salasilan ra.’ ");
INSERT INTO frd_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Naꞌuk Abraham nfalak ne, ‘Wean i wol rarenar afa ovi rtulis roak naꞌa Musa ovu nabi rira kitab ra, na ira veka wol rorang vali ma rahil ma rtalik tali rira salasilan ra, velik ne matmatan isa nvaꞌat ewal ma ti nfalak verin ira.’ ” ");
INSERT INTO frd_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesus nfalak verin Ni tamata ovi rorang Ia ne, “Ita tkaꞌa roak ne, afa ovi rotu ma tamata ra rotu aꞌuk salasilan ra veka rnaꞌa, naꞌuk sian urun i lahir verin tamata ovi rotu ma tamata liak ra rotu salasilan. ");
INSERT INTO frd_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ni lolin a, rkeak vatu dawan isa naꞌa tamata avyai relarira ra ma relik ira rti tahat ralan. Rotu wean inyai, na lolin lia tali tamata avyai rotu ma tamata i ni inorang a kakoꞌu nleka ma notu salasilan. ");
INSERT INTO frd_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Wean inyai bi, msyiꞌik ma lolin afa ovi myotu ra! Wean i terabir-valibira isa notu salasilan, na mtyabu ia. Ba wean i nahil ma ntalik roak tali ni salasilan ra, na myabun ia. ");
INSERT INTO frd_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Wean i notu salasilan verin mia fafitu naꞌa amar isa, ovu vali newal nala fafitu ia nma verin mia ma nfalak ne, ‘Yaꞌa ahil roak, ba era ma myabun yaꞌa,’ na mia musti myabun ia.” ");
INSERT INTO frd_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Nata Yesus Ni rasul ra rfalak verin Ia ne, “Duilaꞌa Yesus, fara fwangrebat mami inorang a!” ");
INSERT INTO frd_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Duilaꞌa nfalak ne, “Wean i bira inorang a veran sesawi ni vatul watan, na mia bisma fyalak verin aa dawan ini ne, ‘Mutvutuk lahir ma roal mdiri tahat ralan,’ na veka norang watan mia!” ");
INSERT INTO frd_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Wean i tamata isa tali bir tinemun ni tamata sansinir nkarya naꞌa ni vaꞌi a, te nwanar ni afwatan ra, ma wean i newal ia tali ni karya, na tamata yai veka nfalak verin ni sansinir yai ne, ‘Mwa ma mufnaꞌan kikyai!’? ");
INSERT INTO frd_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Velik aba, wahal lahir! Ia veka nfalak verin ni sansinir yai ne, ‘Mususan afamtahan verin yaꞌa. Moru mu ravit i nmerat a, ma mdiri msiꞌik ma ufnaꞌan-ufnenu munuk veki, beti mufnaꞌan-mufnenu vali.’ ");
INSERT INTO frd_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ia veka nraning ni sansinir yai? Wahal lahir, velik ne notu munuk ni karya ovi nala verin ia. ");
INSERT INTO frd_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Wean watan inyai verin mia vali. Wean i myotu munuk roak afa ovi Ubu nfalak ma myotu ra, na ni lolin a, fyalak ne, ‘Ami tamata sansinir ami watan, ovu wol fyawamami lahir, ba amotu aꞌuk afa ovi musti amotu ra.’ ” ");
INSERT INTO frd_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesus nahu propinsi Samaria ovu propinsi Galilea rira elat ratan a ma nbana nti Yerusalem. ");
INSERT INTO frd_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Naꞌut i Yesus nti naran ahu isa, na tamata vutu ovi rira suhut ngabaa rma rtuan Ia. Ira rdiri ma yaꞌi raroa ira tali Yesus, ");
INSERT INTO frd_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ma rafwak ne, “Yesus, Tuan Guru! Mlobang ami.” ");
INSERT INTO frd_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ba Yesus nsiꞌik ira ma nfalak ne, “Miti ma fyaturu tenabira ra verin Yahudi rira mela falurut ra, ma rsiꞌik tenabira ra ne, lolin roak te wahal.” Naꞌa rira banbanan obin, na lolin lahir ira tali rira suhut a. ");
INSERT INTO frd_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Tamata isa tali tamata vutu yai, ti ma nsiꞌik tenan a, na lolin roak ia tali ni suhut a, ba newal ia ma nfadawang Ubu ovu vain dawan. ");
INSERT INTO frd_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Nata nsangatur naꞌa Yesus wahan ralan a, ovu nfalak fara weninyai verin Ia. Tamata yai ntali Samaria. ");
INSERT INTO frd_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yesus nfalak ne, “Inlangin a otu ma tamata vutu lolin ewal roak ira tali rira suhut a te wahal? Tamata isi yai rnaꞌa inba? ");
INSERT INTO frd_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Wean inbinimi wol tamata isa vali tali ira rma ma rfalak fara weninyai verin Ubu, naꞌuk tamata i wol Yahudi ini saꞌi nma aꞌuk?” ");
INSERT INTO frd_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Yesus nfalak verin tamata yai ne, “Mdiri ma mewal oa kikyai, tevek mu inorang a notu ma lolin roak oa.” ");
INSERT INTO frd_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Tamata Farisi ifira rorat Yesus ne, “Lafira, na Ubu nma ovu Ni Fareta Ralan a?” Ba Yesus nfalak ne, “Ubu Ni Fareta Ralan wol nma ovu faneak ovi tamata ra rsiꞌik, ");
INSERT INTO frd_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","ovu vali tamata ra wol bisma rfalak ne, ‘Eka msyiꞌik, Ia naꞌa ini, te naꞌa ineri!’ Tevek Ubu neluk raja ma nfareta lanit ivavan ini naꞌa roak ralabira ra.” ");
INSERT INTO frd_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ba Yesus nfalak verin Ni tamata ovi rorang Ia ne, “Ni amar a veka nma ma inabira ma msyiꞌik Yaꞌa, Tamata Yanan Yaꞌa, naꞌa amar isa watan, naꞌuk mia wol bisma msyiꞌik. ");
INSERT INTO frd_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Tamata ra veka rfalak verin mia ne, ‘Msyiꞌik Ia naꞌa ineri!’ Te, ‘Msyiꞌik Ia naꞌa ini!’ Mia deka miti ineri, ovu deka myorang ira. ");
INSERT INTO frd_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Tevek Yaꞌa, Tamata Yanan Yaꞌa, veka uma ewal lanit ivavan ini, ma vanang wean lahir i fitik nyelar tali lanit wahan nti lanit wahan. ");
INSERT INTO frd_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Naꞌuk Yaꞌa musti utuan veki wawaꞌuk i dawan urun a, ovu tamata ovi fiang ini rvaꞌat ra veka ralaꞌing Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Amar i Yaꞌa, Tamata Yanan Yaꞌa veka uma, na tamata ra veka wean lahir naꞌut i Nuh nvaꞌat a. ");
INSERT INTO frd_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Naꞌut inyai, na tamata ra rafnaꞌan, rafnenu ovu rsifa wean watan wean a, ti naran amar i Nuh nrata ni kabal a. Nata wear dawan nma ma nfedan munuk ira. ");
INSERT INTO frd_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Amar yai wean vali naꞌut i Lot nvaꞌat obin. Tamata rafnaꞌan, rafnenu, rfedi-rfaha afa, ravuri-rava ovu rotu rira rahan ra. ");
INSERT INTO frd_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Naꞌut amar i Lot nban-talik kota Sodom, na Ubu nfasuka yafu ovu belerang wean lahir daꞌut tali lanit ratan, ma nvisal tamata ra munuk. ");
INSERT INTO frd_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Veka wean vali inyai naꞌut i Yaꞌa, Tamata Yanan Yaꞌa, uma ma ufavotuk tenang a. ");
INSERT INTO frd_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Naꞌa amar yai, na tamata ovi ryari ira naꞌa rira rahan ratan ra, deka rsuta ma rala rira afa ovi rnaꞌa rira rahan ralan, ovu vali tamata ovi rkarya naꞌa rira vaꞌi ra wol bisma rewal roak ira rti rira rahan ra. ");
INSERT INTO frd_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Mingnanang afa i nkena roak Lot awan a. ");
INSERT INTO frd_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Tamata iki watan nfikir aꞌuk ni vavaꞌat naꞌa lanit ivavan a, na ia veka wol ni vavaꞌat kakiwal a. Naꞌuk iki watan wol nfikir ni vavaꞌat tevek norang Yaꞌa, velik ne tamata ra rfedan ia, na ia veka ni vavaꞌat kakiwal. ");
INSERT INTO frd_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Yaꞌa ufalak verin mia ne, naꞌa ovan i veka uma ewal yai, na wean i utuan tamata irua rtuba koꞌi isa, na Ubu veka nala isa, naꞌuk isa nanaꞌa watan. ");
INSERT INTO frd_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Wean i vata irua rbutar slaru naꞌa batu putar, na Ubu veka nala isa, naꞌuk isa nanaꞌa watan.”  ");
INSERT INTO frd_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Wean i tamata irua rnaꞌa vaꞌi, na Ubu veka nala isa, naꞌuk isa nanaꞌa watan. ");
INSERT INTO frd_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ba Yesus Ni tamata ovi rorang Ia rorat Ia ne, “Duilaꞌa, afa yai veka nvotuk naꞌa inba?” Ba Ia nfalak verin ira ne, “Wean i matmatan ra rnaꞌa inyai, na manut nangan dawan ovi baꞌi raꞌan afa matmatan ra rnaꞌa vali inyai.” ");
INSERT INTO frd_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yesus nfamalik vaivatul kamkuma isa verin Ni tamata ovi rorang Ia ma al nair ira. Ia nfangnanang ira ma musti raflurut lalawatan ovu deka ralarira kakoꞌu. ");
INSERT INTO frd_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ia nfalak ne, “Tamata isa i baꞌi nfaleka inukun nleal kota isa. Ia wol nbobar Ubu ovu wol nkamlabir tamata isa vali. ");
INSERT INTO frd_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Naꞌa kota yai vali, na vata varu isa nma lalawatan ma ntuan tamata inukun yai ma nera verin ia ne, ‘Mlobang ma mususan ning ngrihi a ovu tamata i nangal yaꞌa ini ovu ni malolan a.’ ");
INSERT INTO frd_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Yaꞌi mnanat, na tamata inukun yai wol nkamlabir lahir varu yai, ti nata nanovak naꞌa ralan a ne, ‘Velik ne wol ubobar Ubu ovu wol ukamlabir tamata isa vali, ");
INSERT INTO frd_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","naꞌuk varu ini nlabir lalawatan yaꞌa. Ba ni lolin a, ulobang ia ovu ni malolan a, boma deka nma lalawatan ma nlabir yaꞌa.’ ” ");
INSERT INTO frd_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ba Duilaꞌa nfalak ne, “Minovak ma lolin naꞌa afa ovi tamata inukun yai nfalak ra. Ni vavaꞌat a wol nmalola! ");
INSERT INTO frd_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ubu notu ma nlia tali inyai! Ia veka nlobang Ni tamata ovi nfili ra. Ira ovan-amar raflurut verin Ia. Ia veka wol ntal ma mnanat ma nlobang ira! ");
INSERT INTO frd_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ufalak lahir verin mia ne, Ubu veka nlobang lahir ira ovu Ni malolan a! Naꞌuk wean i Yaꞌa, Tamata Yanan Yaꞌa, uma lanit ivavan ini, na Yaꞌa veka utuan tamata inorang ra te wahal?” ");
INSERT INTO frd_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yesus nfamalik vali vaivatul kamkuma ini verin tamata ovi ranovak ne, wol rotu salasilan, ovu ranovak vali ne, tamata liak ra wol fyawarira. ");
INSERT INTO frd_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Ia nfalak ne, “Tamata irua rti Rahan Dawan Falurut ma raflurut. Tamata isa ntali sidovung Farisi, na tamata isa vali baꞌi nera babahir kulu. ");
INSERT INTO frd_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Tamata Farisi yai ndiri ma naflurut watan naꞌa ralan a ne, ‘Ubu, yaꞌa ufalak fara weninyai verin Oa, tevek yaꞌa wol weang tamata liak ra; ira rwi-rwa tamata ra ma rbori rira metan ra, rangal inukun ra, rsifa roak naꞌuk rtuba ovu tamata ovi wol awarira verin ira, ovu vali wol weang tamata i baꞌi nera babahir kulu ini. ");
INSERT INTO frd_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Yaꞌa utolat farua naꞌa karedralan isa, ovu ala persen vutu tali ning karya enan ra munuk verin Oa.’ ");
INSERT INTO frd_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Naꞌuk tamata i baꞌi nera babahir kulu yai ndiri ma nfaroa ia tali tamata ra. Ia wol nabrahi ma ntadata nrata lanit, naꞌuk nfefik buburn a ma nfalak ne, ‘O Ubu, fara fwaturu Mu silobang a verin yaꞌa, tamata salasilan ini.’ ");
INSERT INTO frd_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Mryenar ma lolin afa ovi ufalak ini! Tamata i baꞌi nera babahir kulu yai, naꞌut i newal ia nti ni rahan a, na Ubu naꞌi vatuk roak ni salasilan ra, naꞌuk tamata Farisi yai wahal. Tevek tamata iki watan nfakaratat tenan a, na Ubu veka nfakabava ia, naꞌuk tamata iki watan nfakabava tenan a, na Ubu veka nfakaratat ia.” ");
INSERT INTO frd_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Tamata rovun yanarira koꞌu ra rma verin Yesus, boma nfadoku liman naꞌa ira. Naꞌut i Ni tamata ovi rorang Ia rsiꞌik tamata avyai, na rangrova ira. ");
INSERT INTO frd_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Naꞌuk Yesus nera kasikoꞌu avyai, beti nfalak verin Ni tamata ra ne, “Msyiꞌik watan ma kasikoꞌu avyai rma ma rtuan Yaꞌa. Deka myotu teri ira, tevek tamata ovi wearira avyai, ira veka warira vali ovu Ubu naꞌa Ni Fareta a. ");
INSERT INTO frd_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Afa i ufalak verin mia ini, kena urun! Tamata iki watan wean i wol norang ne, Ubu nfareta tamata ra wean lahir Raja, wean kasikoꞌu avyai, na ia veka wol wan naꞌa Ubu Ni Fareta a.” ");
INSERT INTO frd_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Yahudi rira dawan isa nfalak verin Yesus ne, “Tuan Guru, lolin Oa. Yaꞌa musti otu afaka, boma ning vavaꞌat kakiwal?” ");
INSERT INTO frd_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesus nfalak ne, “Afakinimi fwalak ne lolin Yaꞌa? Wol tamata isa vali lolin ia, Ubu aꞌuk saꞌi lolin Ia. ");
INSERT INTO frd_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Oa mkaꞌa munuk afa ovi Ubu nfareta roak verin ita: ‘Wean i msifa roak, na deka mtuba ovu tamata i wol awam verin ia, deka msifedan, deka bwori, deka mdiri fareta waharira ralan ra ma msiklabir naꞌa afa ovi fwalak ra naꞌa tamata liak, ovu malang renam ovu yamam a.’ ” ");
INSERT INTO frd_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Tamata yai nfalak ne, “Yaꞌa ot-orang munuk roak afa avyai, tali naꞌut i ning kakoꞌu obin.” ");
INSERT INTO frd_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesus nrenar munuk afa ovi tamata yai nfalak ra, na nfalak verin ia ne, “Teran afa isa wol motu obin. Musti fwedi munuk mu metan ra ma mtanang kubang avyai verin tamata kasian ra. Motu wean inyai, na veka mu metan naꞌa lanit ratan, beti mwa ma morang Yaꞌa.” ");
INSERT INTO frd_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ti ma nrenar afa ovi Yesus nfalak ra, na ralan a lalau urun, tevek nkaꞌi urun ia. ");
INSERT INTO frd_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesus nkaꞌa lahir ne, tamata yai ralan lalau, ba nfalak verin ia ne, “Susa buas ma tamata ovi rkaꞌi ra rtorung ma Ubu nfareta ira wean lahir raja. ");
INSERT INTO frd_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Susa buas ma unta nuruk dirin ni bilahin a nti, naꞌuk susa lia vali verin tamata kaꞌi ra ma rtorung ma Ubu nfareta ira wean lahir raja.” ");
INSERT INTO frd_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Tamata ovi rarenar afa ovi Yesus nfalak ra rorat ne, “Ba wean inyai, na iki veka ni vavaꞌat kakiwal?” ");
INSERT INTO frd_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ba Yesus nfalak ne, “Afa ovi tamata wol rot-nala ra, Ubu not-nala munuk.” ");
INSERT INTO frd_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Nata Petrus nfalak ne, “Ami amban-talik roak mami afakataka munuk ma amorang Oa.” ");
INSERT INTO frd_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Yesus nfalak verin ira ne, “Afa i ufalak verin mia ini, kena urun! Tamata ovi rban-talik roak rira rahan ra, te awarira ra, te terarir-valirira ra, te renarir-yamarira ra, te yanarira ra, tevek rfamalik Ubu Ni Fareta verin tamata ra, na Ia veka ntafal enarira ra ma nlia ma dawan tali lan a naꞌa rira vavaꞌat ra, ovu vali naꞌa amar ovi veka rma ini, na ira veka rira vavaꞌat kakiwal.” ");
INSERT INTO frd_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesus nasdovu munuk Ni tamata vutu rahin irua ovi rorang Ia ma nfalak verin ira ne, “Fiang ini tati Yerusalem. Naꞌa ineri, na afa ovi nabi ra rtulis munuk roak naꞌa Yaꞌa, Tamata Yanan Yaꞌa, veka rkena lahir Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Tamata ra veka rala Yaꞌa verin tamata ovi wol Yahudi ra ma rlabir waweang Yaꞌa ovu rira vaivatul ra, rfalak sian Yaꞌa ovu rafnit Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ira veka rasveva Yaꞌa ovu rfedan Yaꞌa, naꞌuk ti ma amar itelu nelak, na veka uvaꞌat ewal.” ");
INSERT INTO frd_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Naꞌuk Yesus Ni tamata ovi rorang Ia wol rfan-aran afa ovi nfalak ra. Ni vaivatul avyai wean afa fanfonak verin ira, ba wol rkaꞌa afa ovi Yesus nfalak ra. ");
INSERT INTO frd_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Naꞌut i Yesus nfaseri roak kota Yerikho, na tamata kibu isa ndoku lingaꞌan nelan ma nera afa tali tamata ra. ");
INSERT INTO frd_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ti ma nrenar tamata rivun ovi rahu inyai vairira ra, na norat ira ne, “Myotu afakinyai?” ");
INSERT INTO frd_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ira rfalak ne, “Yesus i ntali ahu Nazaret nbana nahu ini.” ");
INSERT INTO frd_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ba ia nafwak ne, “Yesus, Oa ubum-nusim Raja Daud. Fara fwaturu Mu silobang a verin yaꞌa!” ");
INSERT INTO frd_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Tamata ovi rbana ula ira rtabu ia ma deka vain. Naꞌuk ia nafwak ma vain a dawan urun ma nfalak ne, “Oa ubum-nusim Raja Daud, ba fara fwaturu Mu silobang a verin yaꞌa!” ");
INSERT INTO frd_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Nata Yesus ndir-teri, beti nsinir tamata boku ma rovun tamata kibu yai nma. Ti ma nfaseri Yesus, na Yesus norat ia ne, ");
INSERT INTO frd_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Oa inam ma otu afaka verin oa?” Tamata yai nfalak ne, “Duilaꞌa, yaꞌa inak ma usirea!” ");
INSERT INTO frd_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ba Yesus nfalak verin Ia ne, “Msirea kikyai, tevek mu inorang a verin Yaꞌa notu ma lolin roak oa!” ");
INSERT INTO frd_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Naꞌut inyai vali, na tamata yai nsirea lahir. Nata norang Yesus ovu nfadawang Ubu. Ti ma tamata rivun avyai rsiꞌik afa yai, na ira munuk rfadawang Ubu. ");
INSERT INTO frd_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ti ma Yesus naran kota Yerikho, na nban-oli kota yai. ");
INSERT INTO frd_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Naꞌa kota yai, na tamata kaꞌi isa naran Zakheus. Ia nban-ulu verin tamata ovi baꞌi rera babahir kulu. ");
INSERT INTO frd_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ia inan ma nsiꞌik Yesus, naꞌuk tamata rivun ovu kabava daꞌin ia, ba wol bisma nrea Yesus. ");
INSERT INTO frd_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ba nafla ula ia tali tamata rivun avyai nti ma nakbasal aa ara isa, boma bisma nsiꞌik Yesus naꞌut i nahu inyai. ");
INSERT INTO frd_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ti ma Yesus naran aa ara yai, na ntadata ma nfalak ne, “Zakheus msuta kikyai, tevek amar ini musti unaꞌa teri mu rahan.” ");
INSERT INTO frd_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ba Zakheus ralan lolin urun ma nsuta lahir, tevek Yesus veka nanaꞌa teri ni rahan a. ");
INSERT INTO frd_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Tamata rivun ovi rsiꞌik afa yai rafngamuꞌur ma rfalak ne, “You! Yesus nti lahir tamata i baꞌi notu salasilan yai ni rahan a.” ");
INSERT INTO frd_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Naꞌuk Zakheus ndiri ma nfalak verin Duilaꞌa ne, “Duilaꞌa, yaꞌa veka ala lahir ning metan lihir a verin tamata kasian ra, ovu veka ubahir ma nlia nala fafaꞌat verin tamata ovi ulabir nala roak ira.” ");
INSERT INTO frd_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ba Yesus nfalak verin Zakheus ne, “Amar ini lahir, na Ubu nsikat oa ovu mu rahan teta tali bira salasilan ra, ma bira vavaꞌat kakiwal, tevek Abraham ubun a nusin vali oa. ");
INSERT INTO frd_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Yaꞌa, Tamata Yanan Yaꞌa, uma ma udava ovu ala tamata ovi rfaroa ira tali Ubu, ma usikat ira tali rira salasilan ra, ma rira vavaꞌat kakiwal.” ");
INSERT INTO frd_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Yesus nfaseri roak Yerusalem, ba tamata avyai rnarin ne, Ubu Ni amar sarseri lalean roak ma nfareta tamata ra wean lahir Raja. Tamata avyai rarenar Yesus nangrihi obin a, ba Ia nfamalik ewal vaivatul kamkuma isa. ");
INSERT INTO frd_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Yesus nfalak ne, “Tamata mela isa mane nti negara isa i raroa ma ndava mane rsikat ia ma notu raja naꞌa negara yai, beti newal ia. ");
INSERT INTO frd_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ia wol nati obin, na nera ni tamata sansinir vutu a ma nala kubang masa sasan lokat ira, ma nfalak ne, ‘Myala kubang ovi ma al fyedi-fyaha afa, nata ti naran i ewal yaꞌa.’ ");
INSERT INTO frd_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Naꞌuk tamata ovi rtali ni negara wol inar lahir tamata mela yai. Ia nti roak, beti rsinir tamata boku ma rorang ia ma rfalak verin tamata ra naꞌa negara yai ne, ‘Ami wol inamami ma tamata ini notu raja verin ami!’ ");
INSERT INTO frd_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Velik ne wean inyai, naꞌuk raja i nfareta negara yai nsikat watan ia ma notu raja, beti newal ia. Ia nsinir tamata ra ma rera ni sansinir ovi nala roak kubang verin ira ma rma, boma nkaꞌa lahir ne, uturira te wahal. ");
INSERT INTO frd_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Sansinir i ula lalean a nma ma nfalak ne, ‘Baba, ala roak kubang masa isa i mala verin yaꞌa yai, ma ufedi-ufaha afa ma utung nala kubang masa vutu a.’ ");
INSERT INTO frd_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ba raja yai nfalak verin ia ne, ‘Oa mu karya lolin buas. Oa mot-orang lalawatan afa ovi ufalak ra naꞌa afa koꞌu ovi ala verin oa, ba yaꞌa veka usikat oa ma fwareta kota vutu a.’ ");
INSERT INTO frd_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Sansinir i norang i ula lalean a nma ma nfalak ne, ‘Baba, ala roak kubang masa isa i mala yai, ma ufedi-ufaha afa ma utung nala kubang masa ilima.’ ");
INSERT INTO frd_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ba raja nfalak verin ia, ‘Yaꞌa veka usikat oa ma fwareta kota ilima.’ ");
INSERT INTO frd_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Sansinir liak isa vali nma ma nfalak ne, ‘Baba, mu kubang hi ini. Ukum-teri ma lolin ia naꞌa lesu isa. ");
INSERT INTO frd_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ubobar oa ta baba, tevek waham a ngrova watan. Oa mala afa ovi oa wol mua ra, ovu baꞌi mala vaꞌi ihin tali vaꞌi ovi wol muvuri-muva naꞌa.’ ");
INSERT INTO frd_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Raja nfalak verin tamata yai ne, ‘Oa muktufan urun, ba veka ufaleka inukun verin oa tali afa ovi fwalak ra. Oa mkaꞌa roak ne, wahang a ngrova ovu baꞌi ala afa ovi wol ningu ra, ovu vali baꞌi ala vaꞌi ihin tali vaꞌi ovi wol uvuri-uva naꞌa. ");
INSERT INTO frd_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Wean inyai, na afakinimi wol fwadoku ning kubang yai naꞌa bank, boma ti ma ewal yaꞌa, na bisma ala kubang yai ovu ni bunga a.’ ");
INSERT INTO frd_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Nata raja nfalak verin tamata ovi rdiri inyai ne, ‘Myal-ewal kubang tali sansinir yai, ma myala verin sansinir i ni kubang masa vutu a.’ ");
INSERT INTO frd_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Naꞌuk ira rfalak ne, ‘Baba, ia ni kubang masa vutu roak.’ ");
INSERT INTO frd_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Raja nfalak ne, ‘Mingnanang! Tamata iki watan npake ma lolin afa ovi rnaꞌa roak ia, na veka utafal vali verin ia. Naꞌuk tamata iki watan wol npake ma lolin afa ovi rnaꞌa roak ia, na veka al-ewal afa ovi rnaꞌa ia. ");
INSERT INTO frd_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Naꞌuk fiang ini myovun tamata ovi rira sian yaꞌa ovu wol inar ma unaꞌa raja verin ira ma rma ini. Fyedan ira naꞌa wahang ralan a!’ ” ");
INSERT INTO frd_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ti ma Yesus nfamalik munuk vaivatul kamkuma yai, na nbana ula ia nti Yerusalem, ma Ni tamata ra rahu murin a. ");
INSERT INTO frd_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ti ma Yesus nfaseri ahu Betfage ovu Betania i rnaꞌa vuar Zaitun a, na nsinir tamata irua tali Ni tamata ovi rorang Ia ma rti ula ira. ");
INSERT INTO frd_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Yesus nsurak ira ne, “Miti ahu i naꞌa ulu eri. Ti myaran ahu yai, na veka mtyuan keledai isa i wol kaꞌi dawan ia obin, ovu rkeak teri ia. Tamata ra wol rata rdoku tetan ratan obin. Mryuvat ni kakeak a ma fyabana ia mya. ");
INSERT INTO frd_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Wean i tamata rorat mia ne, ‘Notu afakinimi fyatalik keledai yai?’, na byalat ira ne, ‘Duilaꞌa nperlu keledai yai.’ ” ");
INSERT INTO frd_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ba Yesus Ni tamata irua yai rti, na rtuan lahir afa i Yesus nfalak roak verin ira. ");
INSERT INTO frd_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Naꞌut i raruvat keledai yai ni kakeak a, na tamata ovi rira keledai yai rorat ira ne, “Afakinimi mane fyatalik keledai yai?” ");
INSERT INTO frd_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ira rfalak ne, “Duilaꞌa nperlu.” ");
INSERT INTO frd_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ba rovun keledai yai ti verin Yesus, ma rala rira ravit blawat ra ma al raraang tetan ratan a, beti rsikat Yesus ma rata ndoku. ");
INSERT INTO frd_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Naꞌut i Yesus nrata roak keledai yai ma nati Yerusalem, na tamata ra rvelar rira ravit blawat ra naꞌa lingaꞌan ralan. ");
INSERT INTO frd_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ti ma Yesus nfaseri Yerusalem naꞌa lingaꞌan dadudur i naꞌa vuar Zaitun, na Ni tamata ovi rorang Ia munuk rotu inar lolin ovu rfadawang Ubu ovu vair dawan, tevek rarea munuk roak mujizat ovi notu ra. ");
INSERT INTO frd_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ira rfalak ne, “Ubu naflahar tamata i neluk Raja ma nma ovu Duilaꞌa naran a! Fara dida vavaꞌat ra malinan watan ovu Ubu i naꞌa lanit ratan, ovu tfadawang Ubu i Ni dawan a nlia munuk afakataka.” ");
INSERT INTO frd_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Tamata Farisi boku rovu vali tamata rivun avyai, ba rfalak verin Yesus ne, “Tuan Guru, mtabu Mu tamata ovi rorang Oa yai ma deka rangrihi wean inyai!” ");
INSERT INTO frd_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ba Yesus nfalak lahir verin ira ne, “Ufalak verin mia ma mkyaꞌa ne, wean i tamata ovi wol vairira, na vatu ovi veka rafwak.” ");
INSERT INTO frd_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Naꞌut i Yesus nfaseri roak Yerusalem, ma nsiꞌik kota yai, na nvakar lahir. ");
INSERT INTO frd_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ia nfalak ne, “Wora lahir mia tamata ovi mnyaꞌa Yerusalem ini! Yaꞌa inak urun ma amar ini fyan-aran afa ovi rotu ma Ubu ralan malinan ovu mia! Naꞌuk fiang ini wol fyan-aran lahir afa avyai obin. ");
INSERT INTO frd_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Tevek ni amar a veka nma ma tamata ovi rira sian mia rdir-lilit mia ovu rotu balbelat i nangrebat urun, ma rdovak mia tali wan inba watan. ");
INSERT INTO frd_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ira veka rvisal bira kota ma rfedan mia ovu bira tamata ra munuk. Ira veka raꞌar munuk lahir bira rahan ra ovu tembok ra ma wol trea vatu isa vali naꞌa wan a, tevek mia wol mkyaꞌa amar i Ubu nma ma nsikat mia tali bira salasilan ra, boma bira vavaꞌat kakiwal.” ");
INSERT INTO frd_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Nata Yesus nati Yahudi rira Rahan Dawan Falurut ni lean a ma nalaꞌing vatuk tamata ovi rfedi-rfaha afa naꞌa inyai. ");
INSERT INTO frd_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Yesus nfalak verin ira ne, “Surat Ralan nfalak wean ini: ‘Ning rahan a neluk rahan falurut ma tamata raflurut naꞌa,’ naꞌuk mia myotu ma neluk wan ma tamata barborin ra rnaꞌa.” ");
INSERT INTO frd_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Lokat amar, na Yesus nsiair naꞌa Rahan Dawan Falurut. Ba Yahudi rira dawan mela falurut ra, ovu rira dawan ovi rair Musa ni inukun ra, ovu dawan Yahudi ra rdava lingaꞌan mane rfedan Ia. ");
INSERT INTO frd_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Naꞌuk ira wol rdav-nala lingaꞌan ma rfedan Ia, tevek tamata ra munuk inar urun ma rarenar Ni vaivatul ra. ");
INSERT INTO frd_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Amar isa, na Yesus nair tamata rivun naꞌa Yahudi rira Rahan Dawan Falurut ovu nfamalik Ubu Ni Ivar Lolin a, na Yahudi rira dawan mela falurut ra ovu rira dawan ovi rair Musa ni inukun ra, ovu vali rira dawan ovi rban-ulu verin ira rma wan yai. ");
INSERT INTO frd_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ira rfalak verin Yesus ne, “Eka fwalak verin ami ne, Mu ngrebat aka ma al motu afa ovi, ovu iki nala ngrebat yai verin Oa ma motu afa avyai?” ");
INSERT INTO frd_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yesus nfalak verin ira ne, “Yaꞌa mane orat vali afa isa tali mia, ba fyalak verin Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Yohanes nbaptis tamata ra ovu ngrebat tali iki? Ngrebat tali lanit ratan, te tali tamata?” ");
INSERT INTO frd_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ba ranovak afa yai ma rfalak ne, “Wean i tfalak ne, ‘Yohanes ni ngrebat ntali lanit ratan,’ na Ia veka nfalak ne, ‘Notu afakinimi wol myorang ia?’ ");
INSERT INTO frd_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Naꞌuk wean i tfalak ne, ‘Ngrebat tali tamata,’ na tamata ra munuk veka rala vatu al rasba ita, tevek ira rorang ne, Yohanes nabi ia.” ");
INSERT INTO frd_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ba rfalak ne, “Ami wol amkaꞌa ne, nala ngrebat tali iki ma nbaptis tamata ra.” ");
INSERT INTO frd_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yesus nfalak verin ira ne, “Ba wean inyai, na Yaꞌa veka wol ufalak vali verin mia ne, ala ngrebat tali iki ma otu afa avyai.” ");
INSERT INTO frd_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yesus nfamalik vaivatul kamkuma isa verin tamata rivun avyai ne, “Tamata isa notu ni vaꞌi anggur, beti nala verin tamata vaꞌi ra ma rasusan ni vaꞌi yai, ma ki rsiduk anggur boku verin ia. Nata nban-talik ni ahu ma nti wan raroa, ma yaꞌi mnanat ia naꞌa wan yai. ");
INSERT INTO frd_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ni amar naran roak ma rfufu anggur vuan ra, na vaꞌi duan yai nsinir ni tamata sansinir isa ma ti ntuan ira, boma rala ni wahat a. Naꞌuk tamata avyai rvaval sansinir yai, beti rsinir ma newal ia ovu liman vu watan. ");
INSERT INTO frd_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ba nsinir ewal ni sansinir liak isa, naꞌuk rvaval vali sansinir yai ovu rfamaꞌit ia, beti rsinir ma newal ia ovu liman vu watan. ");
INSERT INTO frd_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Nata nsinir ewal ni sansinir liak isa ma fatelu roak, naꞌuk rvaval ma sansinir yai namngala lahir, beti rvatuk ia nti vaꞌi yai murin a. ");
INSERT INTO frd_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ti nata vaꞌi duan yai nfalak naꞌa ralan ne, ‘Yaꞌa musti otu afaka ewal? Yaꞌa veka usinir yanak i ulobang urun ia. Snain ira veka ralang ia.’ ");
INSERT INTO frd_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Naꞌuk ti ma tamata vaꞌi avyai rarea vaꞌi duan yai yanan a brana, na rsifalak afa verin ira ne, ‘Tamata ini vaꞌi duan yanan a, ba mya ma tfedan ia, boma tala vaꞌi ini verin ita.’ ");
INSERT INTO frd_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Rvatuk ia nti vaꞌi yai murin a, beti rfedan ia.” Yesus norat tamata rivun avyai ne, “Ba wean i vaꞌi duan yai nma, na veka notu afaka verin tamata avyai? ");
INSERT INTO frd_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ia veka nma ma nfedan tamata avyai ma nala ni vaꞌi anggur yai verin tamata liak ra.” Ti ma tamata rivun avyai rarenar afa i Yesus nfalak yai, na rfalak ne, “Fara deka wean inyai!” ");
INSERT INTO frd_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Naꞌuk Yesus nsiꞌik ira ma nfalak ne, “Wean inyai, na vaivatul ovi rnaꞌa Surat Ralan ini ihin aka? ‘Vatu i tukan ra rvatuk yai, fyawan lia munuk ma al nfangrebat rahan yai.’ ");
INSERT INTO frd_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Tamata iki watan wean i nleka nsuta vatu yai ratan a, na veka manminan lahir ia, ovu wean i vatu yai nleka tali wan karatat ma ntaꞌi tamata iki watan, na tamata yai veka manminan lahir ia.” ");
INSERT INTO frd_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ba Yahudi rira dawan ovi rair Musa ni inukun ra ovu Yahudi rira dawan mela falurut ra rdava lingaꞌan mane rtaha Yesus amar yai vali, tevek rkaꞌa roak ne, Ia nala vaivatul kamkuma yai al ntaꞌing ira, naꞌuk rbobar tamata rivun avyai. ");
INSERT INTO frd_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Yahudi rira dawan ovi rair Musa ni inukun ra, ovu Yahudi rira dawan mela falurut ra rsiꞌik nanuang watan Yesus. Ira rsinir tamata boku ma rotu felarira wean tamata ovi wol rsiklabir ra, boma rorat afa isa tali Ia ma rfasala Ia, ma rtaha Ia verin gubernur i nfareta naꞌa wan yai. ");
INSERT INTO frd_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Tamata avyai rorat Yesus ne, “Tuan Guru, ami amkaꞌa ne, afa ovi fwalak ovu mair ra kena ovu wol fwili tamata. Oa msiair ovu ni malolan a wean Ubu ralan nfalak a. ");
INSERT INTO frd_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Wean inyai, ba eka fwalak verin ami ne, dida agama nfalak ne, kena ma tbahir kulu verin Kaisar te wahal?” ");
INSERT INTO frd_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Naꞌuk Yesus nkaꞌa lahir rira siweang a, ba nfalak verin ira ne, ");
INSERT INTO frd_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Eka fyaturu kubang ihin isa verin Yaꞌa. Tamata iki walun ovu naran a naꞌa kubang ini?” Ira rfalak ne, “Kaisar walun ovu naran a.” ");
INSERT INTO frd_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Nata Yesus nfalak verin ira ne, “Ba wean inyai, na myala verin Kaisar afa ovi ia nia ra, ovu myala verin Ubu afa ovu Ia Nia ra.” ");
INSERT INTO frd_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ira wol rfalek-nala Ia tali Ni vaivatul ra naꞌa tamata rivun waharira ralan ra. Ira rtalkaka lahir ovu wol vairira, tevek afa ovi Yesus nfalak yai. ");
INSERT INTO frd_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Tamata boku tali Yahudi rira sidovung isa naran Saduki rma ma rtuan Yesus. Tamata Saduki ra wol rtorung ne, tamata matmatan ra veka rvaꞌat ewal, ba rorat Yesus ne, ");
INSERT INTO frd_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Tuan Guru, Musa ntulis inukun ini verin ita: Wean i brana isa nmata ma teran aꞌuk awan a, naꞌuk wol yanarira, na brana yai aꞌan te warin musti nal-ewal varu yai ma neluk awan, ma fara ia i nmata roak yai veka duan yanan boku. ");
INSERT INTO frd_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ba wean i brana ifitu iyaꞌan iwarin ira ma iyaꞌan nsifa roak, naꞌuk wol yanan obin, na nmata. ");
INSERT INTO frd_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Nata warin nsifa ewal ovu varu yai, naꞌuk wol yanar obin, na nmata. ");
INSERT INTO frd_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Warin i norang ia nsifa ewal ovu varu yai, naꞌuk wol yanar obin, na nmata vali. Wean inyai lalawatan, nata ti naran iwarin tutul a. ");
INSERT INTO frd_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ti nata vata yai nmata vali. ");
INSERT INTO frd_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ba wean inyai, na ti naran amar i tamata matmatan ra rvaꞌat ewal, na iki veka awan mngaꞌun vata yai, tevek brana ifitu yai awar munuk roak ia?” ");
INSERT INTO frd_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesus nfalak verin ira ne, “Tamata ovi rnaꞌa lanit i vavan ini rsifa, ");
INSERT INTO frd_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","naꞌuk tamata ovi Ubu nfavaꞌat ewal ira tali matmatan ma inovan ma rvaꞌat naꞌa lanit ivavan ngorvaꞌan a, ira wol rsifa. ");
INSERT INTO frd_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Tevek ira wearira Ubu Ni sansinir tali lanit ratan ma wol rmata vali. Ubu yanan ira, tevek Ia nfavaꞌat ewal ira tali matmatan. ");
INSERT INTO frd_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Mia wol myorang ne, tamata ovi rmata roak bisma rvaꞌat ewal. Musa kaꞌi nfaturu roak ne, matmatan ra veka rvaꞌat ewal. Ia ntulis naꞌa Surat Ralan ma nfamalik naꞌut i nsiꞌik yafu nonga naꞌa lavurun lesmat ralan. Ia ntulis ne, Duilaꞌa neluk ‘Ubu verin Abraham, Ishak ovu Yakub.’ ");
INSERT INTO frd_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ia wol neluk Ubu verin matmatan ra, naꞌuk neluk Ubu verin tamata ovi rvaꞌat ra, tevek naꞌa wahan ralan a, na tamata ra munuk rvaꞌat.” ");
INSERT INTO frd_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Boku tali Yahudi rira dawan ovi rair Musa ni inukun ra rarenar afa ovi Yesus nfalak yai, na rfalak ne, “Tuan Guru, afa ovi fwalak yai kena urun.” ");
INSERT INTO frd_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Tali inyai, na wol rabrahi roak ma rorat afa tali Yesus. ");
INSERT INTO frd_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Nata Yesus norat ira ne, “Wean inba ma tamata ra bisma rfalak ne, Raja i ntevut tamata rira salasilan ra, Daud ubun-nusin Ia? ");
INSERT INTO frd_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Daud kaꞌi nfalak roak naꞌa kitab Mazmur ne, ‘Ubu nfalak verin ning Duilaꞌa ne: Mdoku Ning lihir mela a, ");
INSERT INTO frd_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ti naran i otu ma tamata ovi rira sian Oa rsoak nulu Oa.’ ");
INSERT INTO frd_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ba wean i Daud nfalak ne, Raja i ntevut tamata rira salasilan ra Duilaꞌa Ia, na wean inba ma Daud ubun-nusin Ia?” ");
INSERT INTO frd_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Naꞌut i tamata rivun rarenar i Yesus nangrihi a, na Ia nfalak verin Ni tamata ovi rorang Ia ne, ");
INSERT INTO frd_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Msyiꞌik wabira ma lolin naꞌa dawan ovi rair Musa ni inukun ra. Wean i rbasiar, na inar ma roru ravit blawat, ovu inar vali ma tamata ra ralang ira ma rala salam verin ira naꞌa wan i rfedi-rfaha afa naꞌa. Ira inar ma rdoku wan ovi tamata ra baꞌi ralang ira naꞌa rahan falurut ra, ovu vali naꞌa snoba ra. ");
INSERT INTO frd_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ira rangrihi ma rlabir vata varu ra ma rala rira metan ra. Ira raflurut ma rira falurut ra blawat ma ala rteri rira afa sian ovi rotu ra. Ubu veka nukun ira ovu inukun i aleman urun a ma nlia tamata liak ra.” ");
INSERT INTO frd_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Naꞌut i Yesus naꞌa Yahudi rira Rahan Dawan Falurut a, na Ia nsiꞌik tamata kaꞌi ra ti rfadoku rira kubang ra naꞌa vatvatat i baꞌi rfadoku rira kubang ma reluk rira persembahan verin Ubu. ");
INSERT INTO frd_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ia nsiꞌik vali vata varu isa i ni kasian a dawan, nala ni kubang ihin irua i fyawar a koꞌu lean ma ti nfadoku vali naꞌa wan yai. ");
INSERT INTO frd_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Nata Yesus nfalak ne, “Afa i ufalak verin mia ini, kena urun! Vata varu i ni kasian dawan ini ni kubang i nala a, fyawan lia munuk kubang ovi tamata liak ra rala a. ");
INSERT INTO frd_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Tevek tamata avyai munuk rala rira kubang ra tali rira metan teran ra, naꞌuk vata varu ini, velik ne ni kasian a dawan, na ia nala munuk lahir ni kubang ovi nala al nvaꞌat a.” ");
INSERT INTO frd_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Naꞌut inyai, na tamata boku rfamalik Yahudi rira Rahan Dawan Falurut ni lolin a. Ira rfalak ne, Rahan Dawan Falurut felan a lolin buas, tevek rdamur ovu vatu marmer ovi lolin urun a, ovu vali tali tamata rira afa fyawan ovi rala ma reluk rira persembahan verin Ubu. Yesus nrenar afa avyai, na nfalak ne, ");
INSERT INTO frd_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Afa ovi msyiꞌik avyai, ni amar veka nma ma vatu ovi rotu naꞌa rahan averi veka ramaꞌar munuk, ma wol teran vatu isa vali naꞌa wan a.” ");
INSERT INTO frd_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Yesus Ni tamata ovi rorang Ia rorat ne, “Tuan Guru, naꞌut inba na afa avyai veka rvotuk? Faneak aka veka nvotuk ma nfaturu ne, afa avyai veka rvotuk?” ");
INSERT INTO frd_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesus nfalak ne, “Msyiꞌik wabira ma lolin, boma tamata ra deka rlabir nala mia! Ufalak wean inyai, tevek tamata rivun veka rma ma rala narang a ma lokat ira kaꞌi rfalak ne, ‘Yaꞌa Raja i ntevut bira salasilan ra.’ Ovu vali boku veka rfalak ne, ‘Duilaꞌa mane nma ewal roak.’ Deka myorang lahir afa ovi rfalak ra. ");
INSERT INTO frd_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Naꞌut i mryenar ivar ne, tamata ra rotu rihi ovu rotu vangoa-vanga, na deka byobar, tevek afa avyai munuk musti rvotuk lan veki. Naꞌuk inyai wol neluk faneak ne, naran roak ni amar a ma lanit ivavan a namwear.” ");
INSERT INTO frd_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Nata Yesus nfalak ewal ne, “Bangsa isa veka notu rihi ovu bangsa liak ra, ovu vali fareta dawan isa veka notu rihi ovu fareta dawan liak. ");
INSERT INTO frd_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Naꞌa lanit ivavan, na veka ruru dawan, ovu lafar dawan, ovu vali suhut dawan naꞌa wan rivun. Naꞌa lanit a, na veka trea lahir faneak ovi raling ma lolan watan, ovu rotu ma tamata ra rbobar urun. ");
INSERT INTO frd_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Naꞌuk afa avyai munuk wol rvotuk obin, na veka rtaha lan mia ma rwi-rwa mia. Veka rala mia ti mdyiri fareta waharira ralan ra naꞌa dida rahan falurut ra, ovu vali veka rala mia ti mnyaꞌa buꞌi ralan. Ira veka rala mia ma ti mdyiri raja ra ovu dawan fareta waharira ralan ra, tevek myorang Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Naꞌut inyai vali, mia veka fyamalik Ubu Ni Ivar Lolin verin ira. ");
INSERT INTO frd_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Mia musti fyangrebat lan ralabira ra, boma naꞌa amar yai, na deka ralabira raruan naꞌa vaivatul ovi veka myala al mlyotar tenabira ra. ");
INSERT INTO frd_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Wean inyai bi Yaꞌa veka ala ngrebat verin mia ma mingrihi nala vaivatul ovi kena ra, boma tamata ovi rira sian mia wol rangal nala bira vaivatul avyai, ovu wol rfasala nala mia. ");
INSERT INTO frd_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Renabir-yamabira ra, terabir-valibira ra, aꞌabir-waribira ra ovu bira kida ra veka rfedi mia verin tamata ovi rira sian mia. Tamata ra veka rfedan boku tali mia vali. ");
INSERT INTO frd_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Tamata ra munuk veka wol inar lahir mia, tevek myorang Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Naꞌuk wol mane bira vut van isa vali natvutuk tali ulubira ra, te rfamngala mia. ");
INSERT INTO frd_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ba wean i mtyahang nal ralabira ma myorang lalawatan Yaꞌa, na veka bira vavaꞌat kakiwal.” ");
INSERT INTO frd_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Yesus nfalak verin Ni tamata ovi rorang Ia ne, “Wean i msyiꞌik suldadu ra rbelat lilit Yerusalem, na mia musti mkyaꞌa ne wol mnanat, na kota yai veka namaꞌar. ");
INSERT INTO frd_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Naꞌut inyai, na tamata ovi rnaꞌa propinsi Yudea musti rafla talik ma rti vuar ra. Tamata ovi rnaꞌa kota yai ralan a musti rafla talik kota yai, ovu vali tamata ovi rnaꞌa kota yai murin a, deka rati kikyai kota yai ralan a. ");
INSERT INTO frd_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Tevek amar avyai amar ma Ubu nukun Yerusalem, boma nfakena lahir afa ovi rtulis roak naꞌa Surat Ralan a. ");
INSERT INTO frd_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Naꞌut inyai, na veka sian urun i lahir verin vata ovi rbarlewan ra, ovu vata ovi rsusu kasikoꞌu yanat ra! Naꞌut i Duilaꞌa nukun bangsa Israel ini, tamata ovi rnaꞌa wan yai veka rtuan susa dawan urun. ");
INSERT INTO frd_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Tamata boku veka rfedan ira ovu nahin a blawat. Boku vali veka rkeak teri ira ovu rtaha ira ma reluk tamata ovi rfaleka roak ira verin bangsa ra munuk naꞌa lanit ivavan a. Tamata ovi wol Yahudi ra veka rma ma rta sorat Yerusalem naꞌa amar ovi Duilaꞌa nfadoku roak verin ira.” ");
INSERT INTO frd_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Yesus nfalak verin Ni tamata ovi rorang Ia ne, “Faneak ra veka rvotuk naꞌa lera, vulan, ovu nara ra. Bangsa ovi rnaꞌa lanit ivavan a veka rbobar ovu wol rkaꞌa ma raroal te rara, tevek rsiꞌik saksakan dawan ra ovu rarenar dodurira ra. ");
INSERT INTO frd_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Tamata ra rbobar ma rablingu lahir naꞌut i rsiꞌik afa ovi rvotuk naꞌa lanit ivavan a munuk, tevek afa ovi rira ngrebat ra naꞌa lanit veka rarwaꞌung ma rasmoang tia ma watan ira. ");
INSERT INTO frd_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Naꞌut inyai, na tamata ra munuk veka rsiꞌik Yaꞌa, Tamata Yanan Yaꞌa ini, uma ovu mutan a ovu Ning ngrebat a, ovu vali vanang i nfitik a nyadat a. ");
INSERT INTO frd_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Naꞌut i faneak avyai beti rvotuk, na fara fyangrebat ralabira ra ovu inabira lolin watan, tevek sarseri roak ma Ubu mane nfatalik mia tali bira susa ovi mtyuan ra.” ");
INSERT INTO frd_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Nata, Yesus nfamalik vaivatul kamkuma isa verin Ni tamata ra ne, “Msyiꞌik ma lolin aa ara ovu aa afaka watan. ");
INSERT INTO frd_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Wean i aa avyai raftuvul roak, na mia mkyaꞌa lahir ne, lera dawan a sarseri roak. ");
INSERT INTO frd_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Wean vali inyai wean i mryea munuk roak afa ovi ufalak ra, na veka mkyaꞌa lahir ne, sarseri roak ma uma ewal ma ufareta tamata ra wean lahir Raja. ");
INSERT INTO frd_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Afa i ufalak verin mia ini, kena urun! Tamata ovi rvaꞌat fiang ini veka wol rmata munuk obin, na afa avyai munuk rvotuk roak. ");
INSERT INTO frd_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Lanit ovu lanit ivavan a veka ramwear, naꞌuk Ning vaivatul ra rnaꞌa kakiwal watan.” ");
INSERT INTO frd_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Msyiꞌik wabira ma lolin, boma deka fyikir lalawatan ma myotu snoba ma boranavut mia, ovu deka ralabira raruan naꞌa bira vavaꞌat ra. Wean i fyikir lalawatan wean inyai, na veka mibrian naꞌa amar i Yaꞌa, Tamata Yanan a uma, tevek brian munuk, na uma lahir. ");
INSERT INTO frd_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Amar yai, na veka uma verin tamata ovi rnaꞌa lanit ivavan munuk ma rabrian watan, na inyai wean vali afwatan ovi brian munuk, na voar nakevu nala roak ira. ");
INSERT INTO frd_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ba msyiꞌik wabira ma lolin ovu miflurut lalawatan, boma byan-lia afa ovi veka rvotuk naꞌa amar yai, ovu bisma mdyiri nala Tamata Yanan wahan ralan a.” ");
INSERT INTO frd_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Lokat amar, na Yesus nsiair naꞌa Yahudi rira Rahan Dawan Falurut a. Lervava, na Ia nti vuar Zaitun ma Ni ovan naꞌa inyai. ");
INSERT INTO frd_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Lokat varverak, na tamata rivun rti Yahudi rira Rahan Dawan Falurut a ma rarenar i Yesus nsiair a. ");
INSERT INTO frd_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Amar dawan i tamata Yahudi ra baꞌi rotu snoba ma raꞌan roti i wol rfadoku ragi naꞌa yai sarseri roak. Yahudi rfanara amar yai ne, amar Paskah. ");
INSERT INTO frd_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Yahudi rira dawan mela falurut ra ovu rira dawan ovi rair Musa ni inukun ra rdava lingaꞌan mane rfedan fanfonak Yesus, tevek rbobar tamata rivun ovi rnaꞌa inyai. ");
INSERT INTO frd_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Nata nitdawan nanaꞌa roak Yudas i rfanara vali ia ne, Iskariot. Ia ini ntali vali Yesus Ni tamata vutu rahin irua ovi rorang Ia. ");
INSERT INTO frd_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ba Yudas nati ma ntuan Yahudi rira dawan mela falurut ra ovu dawan ovi rban-ulu verin suldadu ovi rwanar Yahudi rira Rahan Dawan Falurut a, ma irmunuk rdava lingaꞌan, boma nfedi Yesus verin ira. ");
INSERT INTO frd_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Tamata avyai inar urun ovu raꞌan vai isa ma ki rala kubang verin ia. ");
INSERT INTO frd_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yudas ntorung afa yai, ba naꞌut inyai, na ndava amar kena mane nfedi Yesus verin ira, naꞌuk rotu ma tamata rivun deka rkaꞌa. ");
INSERT INTO frd_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ni amar kena roak ma Yahudi ra rotu snoba ma raꞌan roti i wol rfadoku ragi naꞌa. Naꞌa amar yai vali, na tamata ra musti rfedan domba Paskah ra. ");
INSERT INTO frd_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ba Yesus nsinir Petrus irua Yohanes ma nfalak ne, “Miti ula mia ma misusan afamtahan Paskah verin ita, boma did tinemun tafnaꞌan.” ");
INSERT INTO frd_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ira rorat Yesus ne, “Bapa, inam ma amasusan naꞌa inba?” ");
INSERT INTO frd_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Yesus nfalak ne, “Naꞌut i miti kota eri ralan a, na veka mtyuan brana isa ntaha suran i nsaꞌa roak wear a. Myorang ia miti rahan i nti ralan a. ");
INSERT INTO frd_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Myorat rahan duan yai ne, ‘Tuan Guru norat ne: Yaꞌa veka ufnaꞌan Paskah ovu Ning tamata ovi rorang Yaꞌa naꞌa inba?’ ");
INSERT INTO frd_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Rahan duan yai veka nfaturu verin mia kamar dawan i nanaꞌa ratan a, naꞌa ni rahan yai. Ira rasusan munuk roak kamar yai, ba mia musti misusan watan dida fanaꞌan fanenu ra.” ");
INSERT INTO frd_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Yesus nfalak munuk wean inyai, beti irua rti. Ira rti ma rtuan munuk afa avyai wean lahir i Yesus nfalak roak a. Nata rasusan afamtahan Paskah yai. ");
INSERT INTO frd_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Naran roak amar i Yahudi rafnaꞌan naꞌa amar dawan Paskah yai, na Yesus ndoku ma nafnaꞌan ovu Ni rasul ra. ");
INSERT INTO frd_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ia nfalak verin ira ne, “Yaꞌa inak urun i lahir ma ufnaꞌan ovu mia naꞌa amar dawan Paskah ini, beti utuan susa dawan. ");
INSERT INTO frd_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ufalak verin mia, boma mkyaꞌa ne, Yaꞌa veka wol uan roak afamtahan Paskah ini, ti naran i Ubu nfakena snoba ini ihin a, naꞌut i Ia neluk Raja ma nfareta lanit ivavan a.” ");
INSERT INTO frd_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Yesus nfalak munuk wean inyai, beti nala kobi i nsaꞌa anggur a ma nfalak fara weninyai verin Ubu, beti nfalak ne, “Myala kobi ini ma msyikati mia al myenu, ");
INSERT INTO frd_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","tevek ufalak verin mia, boma mkyaꞌa ne: Amar ini lahir, na Yaꞌa veka wol enu roak anggur ini, ti naran i Ubu Ni Fareta nma.” ");
INSERT INTO frd_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Yesus nfalak munuk wean inyai, na nala vali roti a ma nfalak fara weninyai verin Ubu, beti nvisul roti yai ma nsiduk verin ira ma nfalak ne, “Roti ini Yaꞌa tenang a ma ala verin mia. Mian ma al nfangnanang mia naꞌa Ning matmatan a.” ");
INSERT INTO frd_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Yesus notu munuk wean inyai, na nala vali kobi i nsaꞌa anggur a ma nfalak ne, “Anggur i naꞌa kobi ini nfaturu Ubu Ni tnorung ngorvaꞌan a. Tnorung yai nanaꞌa larang i veka nvoat verin mia. ");
INSERT INTO frd_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Naꞌuk tamata i veka nfedi Yaꞌa, fiang ini ndoku vali naꞌa ini ma nafnaꞌan ovu Yaꞌa! ");
INSERT INTO frd_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Yaꞌa, Tamata Yanan Yaꞌa, veka umata wean lahir i Ubu nfadoku roak a, naꞌuk veka sian urun i lahir verin tamata i nfedi Yaꞌa.” ");
INSERT INTO frd_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ba kaꞌi rsiforat roak ira ne, iki veka notu wean inyai. ");
INSERT INTO frd_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ba Yesus Ni tamata ovi rorang Ia rsitaku ulurira naꞌa rira fikiran ra ma rdava ne, iki veka dawan lia munuk tali ira. ");
INSERT INTO frd_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesus ntabu ira ma nfalak ne, “Raja ovi rfareta naꞌa nuhu dawan ovi wol rkaꞌa Ubu, ira kaꞌi rfareta watan rira tamata ra ovu limarira tmaꞌan. Tamata dawan ra inar ma tamata liak ra rfalak ira ne, ‘Tamata ovi rlobang tamata ra.’ ");
INSERT INTO frd_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Naꞌuk mia deka weabira inyai. Wean i iki inan ma dawan lia munuk tamata ra, na ia musti nfakabava tenan a ma wean tamata ovi koꞌu rahi lia munuk tamata ra. Tamata ovi rban-ulu verin tamata ra, musti rfakabava vali tenarira ra wean tamata sansinir ra. ");
INSERT INTO frd_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Eka minovak ne, iki veka dawan lia munuk? Tamata i ndoku nafnaꞌan, te tamata sansinir i ntanang afamtahan? Tamata i ndoku nafnaꞌan yai saꞌi dawan ia. Naꞌuk Yaꞌa unaꞌa ovu mia ma eluk tamata sansinir. ");
INSERT INTO frd_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Mia fyatuang Yaꞌa lalawatan naꞌa Ning angangal ra munuk. ");
INSERT INTO frd_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ba wean lahir i Yamang a nala ngrebat verin Yaꞌa ma ufareta wean raja, na Yaꞌa veka ala ngrebat verin mia ma fyareta vali wean Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Wean inyai, na mia veka myotu inabira lolin ovu Yaꞌa naꞌa Ning Fareta a. Inabira lolin yai wean lahir tamata ovi inarira lolin naꞌut i rdoku ma rafnaꞌan naꞌa meja isa. Mia veka mdyoku wean raja ra naꞌa wan vutu rahin irua ma fyareta. Naꞌa wan avyai vali, na mia veka fyaleka inukun verin Israel ni arun dawan vutu rahin irua.” ");
INSERT INTO frd_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Nata Yesus nfalak verin Simon Petrus ne, “Simon, Simon, eka mrenar ma lolin! Ubu ntorung roak ma nitdawan veka nlabir teman mia. Ia veka nwi-nwa mia, ma wean lahir gandum ovi tamata ra rtafi. ");
INSERT INTO frd_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Naꞌuk uflurut roak verin oa ma fara mu inorang a naꞌa lalawatan Yaꞌa. Wean i mahil roak ma morang Yaꞌa, na fwangrebat vali teram a valim tamata inorang ra ma rira inorang a nanaꞌa lalawatan Yaꞌa.” ");
INSERT INTO frd_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Petrus nfalak ne, “Duilaꞌa, yaꞌa utorung roak ma wean i raꞌabuꞌi te rfedan Oa, na yaꞌa veka ovu vali ma unaꞌa buꞌi ralan te umata ovu Oa!” ");
INSERT INTO frd_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesus nfalak ne, “Petrus, ufalak verin oa ma mkaꞌa ne, ovan ini lahir manut wol nkukuwai obin, na oa malak nala fatelu roak ne, wol mkaꞌa Yaꞌa.” ");
INSERT INTO frd_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Yesus norat Ni tamata ovi rorang Ia ne, “Naꞌut i usinir mia ma ti fyamalik Ubu Ni Ivar Lolin a, na ufalak teri roak ma deka mtyaha sadawan, kubang ovu tatea, na mtyuan susa aka?” ");
INSERT INTO frd_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ira rfalak ne, “Wol amtuan susa isa vali.” Ba Yesus nfalak verin ira ne, “Naꞌuk fiang ini, iki ni sadawan te kubang, na ntaha watan. Iki wol ni nahin blawat, na nfedi ni ravit blawat a ma nfaha. ");
INSERT INTO frd_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Mryenar ma lolin afa ovi ufalak ini! Ubu veka nfakena afa ovi rtulis roak naꞌa Surat Ralan a ne, ‘Tamata ra veka rwi-rwa Yaꞌa wean tamata ovi rangal fareta a,’ tevek afa avyai fiang ini vali Ubu mane nfakena lahir naꞌa Yaꞌa.” ");
INSERT INTO frd_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ira rfalak ne, “Duilaꞌa, nahin blawat irua ini.” Yesus nfalak ne, “Naran roak.” ");
INSERT INTO frd_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Nata Yesus nban-talik Yerusalem ma nti vuar Zaitun a, wan i baꞌi nti. Ni tamata ovi rorang Ia rovu vali. ");
INSERT INTO frd_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ti ma raran roak wan yai, na nfalak verin ira ne, “Miflurut, boma nitdawan deka nlabir nala mia ma myotu salasilan.” ");
INSERT INTO frd_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ba Yesus nbana ma nfaroa kedan Ia tali ira, snain a meter vututelu, beti nsangatur ma naflurut ne, ");
INSERT INTO frd_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Bapa, wean i ralam nfalak, na fara maling vatuk varvara i aleman urun ini tali Yaꞌa, naꞌuk deka wean i ralang a nfalak a, ba wean watan i ralam a nfalak a.”  ");
INSERT INTO frd_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ba Ubu Ni sansinir isa ntali lanit ratan nvotuk ovu Ubu Ni ngrebat ma nfangrebat Ia. ");
INSERT INTO frd_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Naꞌuk Yesus ralan a lalau urun i lahir, ba ntafal ma naflurut ilaꞌa. Ratin ra wean lara ma rditi rsuta lanun. ");
INSERT INTO frd_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Naflurut munuk roak, beti newal Ia nti Ni tamata ovi rorang Ia. Ti ma nsiꞌik ira, na rtub-lufa munuk roak, tevek ralarira ra lalau urun i lahir. ");
INSERT INTO frd_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ba nfalak verin ira ne, “Afakinimi mtyub-lufa i? Byatar ma miflurut, boma nitdawan deka nlabir nala mia ma myotu salasilan.” ");
INSERT INTO frd_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Naꞌut i Yesus nangrihi obin, na Yudas nbana ula ia verin sidovung isa i rma ma rtuan Ia. Yudas ini ntali Yesus Ni tamata vutu rahin irua yai. Ia ti nfaseri lahir Yesus ma nvoan Ia. ");
INSERT INTO frd_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Naꞌuk Yesus nfalak verin ia ne, “Yudas, bwoan Yaꞌa ma al fwaturu ne, fwedi Yaꞌa, Tamata Yanan Yaꞌa ini?” ");
INSERT INTO frd_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ti ma Yesus Ni tamata ovi rorang Ia rsiꞌik afa i tamata rivun avyai mane rotu a, na rfalak verin Yesus ne, “Duilaꞌa, amangal aꞌuk ira ovu mami nahin blawat ra?” ");
INSERT INTO frd_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Tamata isa tali Yesus Ni tamata ovi rorang Ia, nala nahin blawat ma nafat vatuk lahir Yahudi rira Mela Falurut Ilaꞌa ni tamata sansinir isa arun mela a. ");
INSERT INTO frd_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Naꞌuk Yesus nfalak ne, “Mtalik kikyai!” Nata Yesus nkena tamata yai arun ma notu ma lolin ewal ia. ");
INSERT INTO frd_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Yahudi rira dawan mela falurut ra, ovu dawan ovi rban-ulu verin suldadu ovi rwanar Yahudi rira Rahan Dawan Falurut a, ovu vali dawan Yahudi ra rma ma rtaha Yesus. Ba Ia nfalak verin ira ne, “Mia mnyarin ne, usdovu tamata ra ma amangal fareta a, ba mya lahir ovu bira nahin blawat ra ovu navnaval ra ma mtyaha Yaꞌa? ");
INSERT INTO frd_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Lokat amar, na itmunuk tnaꞌa Rahan Dawan Falurut a, na wol mtyaha Yaꞌa. Naꞌuk fiang ini bira amar ma myorang bira ininan sian ra, tevek Ubu ntorung ma nitdawan ni amar vali ma nfabana ngarmeran ni ngrebat a.” ");
INSERT INTO frd_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ira rtaha roak Yesus, beti rovun Ia rti Yahudi rira Mela Falurut Ilaꞌa ni rahan a. Petrus nban-orang vali tali raroa watan. ");
INSERT INTO frd_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Naꞌa rahan yai ni lean a fruan a, na tamata ra rsidovuk yafu ma rdok-lilit yafu yai. Petrus ti ndoku vali ovu ira. ");
INSERT INTO frd_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Vata sansinir isa nrea Petrus ndoku yafu yai nelan a, ba nsiꞌik nanuang ia ma nfalak ne, “Tamata ini irmunuk Yesus vali!” ");
INSERT INTO frd_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Naꞌuk Petrus nalak ia ma nfalak ne, “Yaꞌa wol ukaꞌa lahir tamata yai!” ");
INSERT INTO frd_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Wol kaꞌi mnanat obin, na tamata isa nsiꞌik vali Petrus, ba nfalak ne, “Oa ini mimunuk Yesus vali!” Naꞌuk Petrus nfalak ne, “Yaꞌa wahal!” ");
INSERT INTO frd_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Kaꞌa bi jam isa nelak, na tamata liak isa vali nfalak ne, “Ita tkaꞌa roak ne, tamata ini irmunuk Yesus, tevek ia ntali Galilea vali!” ");
INSERT INTO frd_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Naꞌuk Petrus nfalak ne, “Wahal! Yaꞌa wol ukaꞌa ne, oa fwalak afakinyai!” Ia nangrihi obin, na manut nkukuwai lahir. ");
INSERT INTO frd_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Nata Yesus nfulak Ia ma nsiꞌik Petrus, beti Petrus nangnanang nala ewal afa i Duilaꞌa nfalak roak verin ia ne, “Ovan ini manut wol nkukuwai obin, na oa malak nala fatelu roak ne, wol mkaꞌa Yaꞌa.” ");
INSERT INTO frd_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ba Petrus nbana nti murin ma nvakar ma naꞌa samsekur. ");
INSERT INTO frd_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Tamata ovi rwanar Yesus rangrihi ma rworuk-rwak Ia, ovu rvaval Ia. ");
INSERT INTO frd_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ira rkum-teri wahan a beti rorat Ia ne, “Wean i nabi Oa, na eka fwalak ne, iki nvaval Oa yai?” ");
INSERT INTO frd_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Nata rtafal ma rfamaꞌit ilaꞌa Ia. ");
INSERT INTO frd_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ti ma varverak, na dawan Yahudi ra, ovu rira mela falurut ra, ovu vali rira dawan ovi rair Musa ni inukun ra, rasdovu ira naꞌa rira sidovung dawan a. Tamata ovi rwanar Yesus rovun Ia nti sidovung dawan yai. ");
INSERT INTO frd_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ira rorat Ia ne, “Fwalak lahir verin ami ne, Oa ini Raja i veka mtevut tamata ra rira salasilan ra?” Yesus nfalak ne, “Velik ne ufalak wean inyai verin mia, naꞌuk veka wol myorang, ");
INSERT INTO frd_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ovu velik ne orat afa tali mia, na veka wol byalat. ");
INSERT INTO frd_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ba tali amar ini, na Yaꞌa, Tamata Yanan Yaꞌa, udoku Ubu i nfareta munuk afakataka Ni lihir mela a.” ");
INSERT INTO frd_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ira munuk rorat Yesus ne, “Ba wean inyai, na Oa ini Ubu Yanan a?” Yesus nfalak ne, “Mia kaꞌi fyalak roak yai.” ");
INSERT INTO frd_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ti nata ira rfalak ne, “Ita wol tdava roak tamata ma rfamalik naꞌa afa i nfalak ini, tevek ita kaꞌi trenar lahir Ni sala tali sumarn a!” ");
INSERT INTO frd_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Nata tamata ovi rovu munuk sidovung dawan yai, rdiri munuk lahir ma rovun Yesus nti verin Pilatus. ");
INSERT INTO frd_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ti ma raran Pilatus, na rmangadu Ia ma rfalak ne, “Ami amtuan roak tamata ini naꞌut i nlabir nala mami tamata ra. Ia nfalak teri tamata ra ma deka rbahir kulu verin Kaisar. Ia nfalak vali ne, Ia Raja i ntevut dida salasilan ra.” ");
INSERT INTO frd_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ba Pilatus norat Ia ne, “Yahudi rira raja verin Oa?” Yesus nfalak ne, “Oa kaꞌi fwalak roak yai.” ");
INSERT INTO frd_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilatus nfalak verin Yahudi rira dawan mela falurut ra ovu tamata rivun avyai ne, “Yaꞌa wol utuan sala akataka naꞌa tamata ini.” ");
INSERT INTO frd_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Naꞌuk ira rkiwal ilaꞌa ma rfalak ne, “Ia Ni afa ovi nair ra rsoru munuk roak tamata ovi rnaꞌa Yudea, bi tamata ra rotu vangoa-vanga. Ia nsiair lan naꞌa Galilea, beti nma naran wan ini.” ");
INSERT INTO frd_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilatus nrenar afa yai, ba norat ira ne, “Tamata ini ntali Galilea?” ");
INSERT INTO frd_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ti ma Pilatus nkaꞌa ne, Yesus ntali wan i raja Herodes nfareta a, na nsinir tamata ra ma rovun Yesus ti verin Herodes. Naꞌut inyai, na Herodes nanaꞌa vali Yerusalem. ");
INSERT INTO frd_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herodes nsiꞌik Yesus, na inan urun, tevek mnanat ilaꞌa roak nrenar watan tamata ra rfamalik Yesus, ovu inan ma nsiꞌik Ia. Ia inan vali ma nsiꞌik Yesus notu mujizat a. ");
INSERT INTO frd_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Wean inyai bi norat afa rivun tali Yesus, naꞌuk Yesus wol nvalat akataka. ");
INSERT INTO frd_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Yahudi rira dawan mela falurut ra ovu rira dawan ovi rair Musa ni inukun ra rnaꞌa vali inyai, ba rmangadu Yesus ovu rira vaivatul ovi aleman ra. ");
INSERT INTO frd_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ba Herodes ovu ni suldadu ra rfalak sian ovu rangrihi ma rworuk-rwak Yesus, beti rotu ma neluk ravit blawat i raja ra baꞌi roru a. Rotu munuk wean inyai, beti rovun ewal Ia ti verin Pilatus. ");
INSERT INTO frd_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Lan ana Herodes ovu Pilatus rsisala rala, naꞌuk naꞌut amar yai, na irua rotu kida. ");
INSERT INTO frd_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilatus nasdovu munuk Yahudi rira dawan mela falurut ra, ovu rira dawan ra, ovu vali tamata rivun, ");
INSERT INTO frd_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","beti nfalak verin ira ne, “Mia myovun roak tamata ini nma verin yaꞌa ma fyalak ne, Ia nlabir nala tamata ra. Mia kaꞌi msyiꞌik lahir i urus roak Ia, naꞌuk wol utuan Ni sala isa vali tali afa ovi myangadu ra. ");
INSERT INTO frd_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herodes vali wol ntuan afa sala avyai. Ba wean inyai bi nsinir roak ma rovun Ia nma verin yaꞌa. Ufalak urun ne, tamata ini wol Ni sala akataka, ba wol inovan ma ufaleka inukun matmatan verin Ia. ");
INSERT INTO frd_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ba yaꞌa veka ufareta ma rasveva Ia, beti ufatalik Ia.”  ");
INSERT INTO frd_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Lokat snoba Paskah, na Pilatus musti nfatalik tamata isa tali buꞌi ralan verin tamata ra. ");
INSERT INTO frd_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Naꞌuk tamata rivun ovi rnaꞌa inyai rafwak ne, “Fwedan Ia! Fwatalik Barabas verin ami!” ");
INSERT INTO frd_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Pilatus ni suldadu ra raꞌabuꞌi roak Barabas, tevek ia novu vali vangoa-vanga i naꞌa kota ralan a, ovu nsifedan. ");
INSERT INTO frd_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilatus inan ma nfatalik Yesus, ba nangrihi fasa ewal verin tamata rivun avyai ovu vain dawan. ");
INSERT INTO frd_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Naꞌuk rafwak ma rfalak ne, “Bwaku Ia naꞌa aa walwalur! Bwaku Ia naꞌa aa walwalur!” ");
INSERT INTO frd_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Nata Pilatus nfalak fasa ewal verin ira ma fatelu roak ne, “Tamata ini Ni sala aka? Yaꞌa wol utuan lahir ne, notu sala ma inovan ma ukun Ia ma nmata. Ba veka ufareta ma rasveva Ia, beti ufatalik Ia.” ");
INSERT INTO frd_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Naꞌuk ira rkiwal ilaꞌa ma rafwak ovu vair dawan, boma nfareta ma rbaku Yesus naꞌa aa walwalur. Ti nata uturira. ");
INSERT INTO frd_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ba Pilatus nfaleka inukun verin Yesus, boma nfakena tamata rivun avyai rira ininan a. ");
INSERT INTO frd_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ia norang rira ininan a ma nfatalik tamata i raꞌabuꞌi roak ia, velik ne notu vangoa-vanga ovu nsifedan. Naꞌuk ia nala Yesus verin tamata avyai ma rotu tia ma watan Ia, wean i ralarira rfalak a. ");
INSERT INTO frd_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Naꞌut i ira rovun Yesus, na rtaha vali Simon i ntali kota Kirene a. Ia beti naran Yerusalem. Ira rkiwal ia ma nvara Yesus Ni aa walwalur a ma norang Ia. ");
INSERT INTO frd_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Tamata rivun ilaꞌa rorang Yesus. Tali tamata avyai, na vata boku rvakar ma rfaktanit Yesus. ");
INSERT INTO frd_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Naꞌuk Yesus nfulak Ia ma nfalak verin ira ne, “Vata Yerusalem averi! Deka byakar Yaꞌa, naꞌuk byakar aꞌuk tenabira ra ovu yanabira ra! ");
INSERT INTO frd_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Tevek ni amar a veka nma ma tamata ra rfalak ne, ‘Lolin urun verin vata ovi wol rbarlewan, ovu wol yanarira, ovu vali wol rsisusu!’ ");
INSERT INTO frd_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Naꞌut inyai, na tamata ra veka rfalak verin vuar ra ne, ‘Fara mlyeka ma mtyaꞌi ami!’ Ovu rfalak vali verin sakvuar ra ne, ‘Mya ma myoving ami!’ ");
INSERT INTO frd_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Tevek rotu roak wean ini verin Yaꞌa i wol ning salasilan a, na ira veka rotu ma nlia verin mia, tamata ovi bira salasilan roak a. Yaꞌa weang aa i nvaꞌat obin ma yafu wol bisma nasnuri nala. Naꞌuk mia weabira aa ovi rangaran roak a ma yafu veka nasnuri munuk lahir!” ");
INSERT INTO frd_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ira rovun vali tamata ktufan irua ma veka rfakloꞌi ira ma rmata ovu Yesus. ");
INSERT INTO frd_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ti ma raran wan i naran “Kalkulun a”, na rbaku Yesus naꞌa aa walwalur. Ira rbaku vali tamata ktufan irua yai, ma isa naꞌa Ni lihir mela a, na isa vali naꞌa Ni lihir balit a.  ");
INSERT INTO frd_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yesus nfalak ne, “Bapa, maꞌi vatuk rira salasilan yai, tevek wol rkaꞌa afa i rotu a.” Rotu munuk wean inyai, beti rotu undi ma rtanang Ni kadaravit ra. ");
INSERT INTO frd_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Tamata rivun ovi rdiri inyai ramunin Ia naꞌa aa walwalur a. Yahudi rira dawan ra rfalak sian Ia ne, “Ia notu ma lolin ewal tamata liak ma wol rmata. Ba wean i Ubu nfili Ia ma neluk Raja ma nsikat tamata ra tali rira salasilan ra, na tsiꞌik watan ne, nlobang tenan ma nangal nala Ni matmatan ma nvaꞌat te wahal!” ");
INSERT INTO frd_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Roma rira suldadu ra rfalak sian vali Ia. Ira rala anggur i nakbia a verin Ia, ");
INSERT INTO frd_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ma rfalak ne, “Wean i Oa meluk raja verin tamata Yahudi ra, na msuta tali aa walwalur yai, boma deka mwata!” ");
INSERT INTO frd_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Rtulis vali vaivatul ra naꞌa aa walwalur, naꞌa Yesus ulun ratan a ne: “Yahudi rira Raja verin Ia.” ");
INSERT INTO frd_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Tamata ktufan isa i rakloꞌi ia naꞌa aa walwalur yai nfalak sian Yesus ne, “Oa ini Raja i mtevut tamata ra rira salasilan ra? Eka mlobang tenam a ovu ami ma mangal nala matmatan a ma tvaꞌat!” ");
INSERT INTO frd_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Naꞌuk tamata ktufan isa vali ntabu ia ma nfalak ne, “Oa wol bwobar Ubu? Ira rfaleka vali inukun matmatan verin oa wean watan Ia. ");
INSERT INTO frd_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Inovan ma rukun itrua, tevek afa sian ovi totu ra. Naꞌuk tamata ini wol Ni sala akataka.” ");
INSERT INTO frd_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Nata nfalak verin Yesus ne, “Naꞌut i veka mwa ma meluk Raja ma fwareta, na fara mungnanang vali yaꞌa.” ");
INSERT INTO frd_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ba Yesus nfalak verin ia ne, “Afa i ufalak verin oa ini, kena urun! Amar ini veka movu lahir Yaꞌa ma tnaꞌa Firdaus.” ");
INSERT INTO frd_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Naꞌut inyai lera ndirlola, na deda fafyat nsoru munuk wan yai, ti naran jam itelu. ");
INSERT INTO frd_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Maloli dawan amafal i nakloꞌi Yahudi rira Rahan Dawan Falurut ralan namadir lahir naꞌut irua. ");
INSERT INTO frd_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Nata Yesus nafwak ovu vain dawan ne, “Bapa, ala munuk Ning vavaꞌat a ma ufadoku naꞌa limam ralan a.” Ti ma nfalak munuk wean inyai, na nan a nakbosal vali. ");
INSERT INTO frd_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Naꞌut i dawan i nfareta Roma rira suldadu ra nsiꞌik afa avyai, na nfadawang lahir Ubu ma nfalak ne, “Kena urun, tamata ini Ni vavaꞌat nmalola!” ");
INSERT INTO frd_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Tamata rivun ovi rma ma ramunin, rsiꞌik vali afa avyai, ba rewal ira ma naꞌa rira banbanan obin, na kaꞌi rfefik buburira ra. ");
INSERT INTO frd_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Tamata ovi rkaꞌa Yesus, ovu vata ovi rkaꞌa vali Ia ma rorang Ia tali Galilea, rdiri watan raroa ma rsiꞌik afa avyai munuk. ");
INSERT INTO frd_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Tamata isa naran Yusuf ntali ahu Arimatea naꞌa propinsi Yudea. Ia tamata lolin ia ovu ni vavaꞌat nmalola, ovu vali nanaban ma Ubu nfareta tamata ra wean lahir Raja. Velik ne ia ndoku vali Yahudi rira sidovung dawan a, naꞌuk wol ntorung ma rfasala Yesus ma rala Ia verin fareta Roma a. ");
INSERT INTO frd_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ia nti ma ntuan Pilatus ma nera Yesus tenan a. ");
INSERT INTO frd_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Nata, ia nfasuka Yesus tenan tali aa walwalur, ma nkuma Ia ovu maloli ngangiar, beti ti nfanuba Yesus tenan a naꞌa vatu i rtivan roak ia ma wean van, naꞌuk wol rfadoku matmatan ra naꞌa obin. ");
INSERT INTO frd_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Amar yai amar i Yahudi ra rasusan warira ma rsaꞌa amar i mane ryari ira, tevek lokat amar yai ni ovan, na ira ryari roak ira. ");
INSERT INTO frd_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Vata ovi rorang Yesus tali Galilea rorang vali Yusuf, ti ma rsiꞌik van i rfanuba Yesus. Ira rsiꞌik vali i wean inba ma rfanuba Yesus tenan a naꞌa van yai. ");
INSERT INTO frd_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Nata rewal ira rti Yerusalem ma rasusan ngul ovi voarira lolin, ovu voan ngul lolin i rfanara ia ne mur, ma veka raslofi naꞌa Yesus tenan a. Naꞌa amar i Yahudi ra ryari ira, na ira wol rkarya, ma rot-orang Musa ni inukun ra. ");
INSERT INTO frd_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Varverak sumatan obin naꞌut i amar kareda, na vata avyai rtaha ngul ovi voarira lolin ma rti van matmatan i rfanuba Yesus tenan a. Ira wol rti obin, na rasusan lan roak afa avyai. ");
INSERT INTO frd_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ti raran inyai ma rsiꞌik, na vatu dawan i rala al rulang van matmatan yai ngoran a, natsuar roak. ");
INSERT INTO frd_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ba rti lahir ralan ma rsiꞌik, na Duilaꞌa Yesus tenan a wol nleal roak. ");
INSERT INTO frd_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ira rdiri watan ma wol rkaꞌa ma raroal te rara, tevek ranovak afa yai. Brian munuk, na tamata irua rdir-ebang lahir ira. Tamata irua yai roru kadaravit ovi vanar urun a. ");
INSERT INTO frd_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ba vata avyai rbobar urun i lahir ma rsangatur nulu ira ma waharira rsuta rkena lanun. Naꞌuk tamata irua yai rfalak verin ira ne, “Notu afakinimi mdyava tamata i nvaꞌat naꞌa tamata matmatan warira? ");
INSERT INTO frd_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ia wol nanaꞌa roak wan ini. Ia nvaꞌat ewal roak! Eka mingnanang afa ovi nfalak lan roak verin mia, naꞌut i nanaꞌa propinsi Galilea ne, ");
INSERT INTO frd_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Ira musti rala Tamata Yanan verin tamata salasilan ra ma rbaku Ia naꞌa aa walwalur, naꞌuk amar itelu nelak, na veka nvaꞌat ewal.’ ” ");
INSERT INTO frd_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ba vata avyai rangnanang nala ewal afa ovi Yesus nfalak roak verin ira. ");
INSERT INTO frd_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ti ma rewal ira tali van matmatan yai, na rfamalik munuk lahir afa avyai verin Yesus Ni tamata vutu rahin isa ovi rorang Ia, ovu vali verin tamata inorang liak ra. ");
INSERT INTO frd_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Vata avyai nararira: Maria Magdalena, Yohana, ovu Maria i yanan verin Yakobus, ovu vali vata liak ovi rovu vali ira. Irmunuk rfamalik afa avyai verin rasul ra. ");
INSERT INTO frd_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Naꞌuk rasul avyai ranovak ne, inyai ivar vu watan, ba wol rorang afa ovi vata avyai rfalak a. ");
INSERT INTO frd_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Velik ne wean inyai, Petrus ndiri ma nafla lahir nti van matmatan yai. Ti naran van yai, na nsoak ia ma nsiꞌik nti ralan, na nrea watan maloli ra. Nata newal ia ovu norat watan naꞌa ralan a, naꞌa afa ovi rvotuk roak yai. ");
INSERT INTO frd_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Amar yai vali, na Yesus Ni tamata irua ovi rorang Ia rbana rti ahu i naran Emaus a. Ahu yai kaꞌa bi kil vutu rahin isa tali Yerusalem. ");
INSERT INTO frd_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Naꞌa rira banbanan a, na rfamalik afa ovi rvotuk roak yai. ");
INSERT INTO frd_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Naꞌut i irua rfamalik afa ovu rsiforat ira, na Yesus aksa Ia nma lahir ma nbana ovu ira. ");
INSERT INTO frd_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ira rsiꞌik Yesus, naꞌuk afa isa notu ma wol rkaꞌa Ia. ");
INSERT INTO frd_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yesus nfalak verin ira ne, “Mia byana fyamalik afakinyai?” Ba rdir-teri lahir ovu waharira rfaturu ne, ralarira lalau. ");
INSERT INTO frd_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Tali tamata irua yai, na isa naran Kleopas. Ia norat Yesus ne, “Baba, afakinimi tali tamata dakan ovi rnaꞌa ini, na Oa aꞌuk saꞌi wol mkaꞌa afa ovi beti rvotuk inravin ovu ravruan a naꞌa Yerusalem?” ");
INSERT INTO frd_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ia nfalak verin ira ne, “Mia fyalak afakinyai?” Ba rfalak ne, “Afaka nkena Yesus i ntali ahu Nazaret yai! Ia nabi Ia, ovu Ni vaivatul ra ovu afa ovi notu ra rira ngrebat naꞌa Ubu wahan ralan a, ovu tamata ra munuk waharira ralan ra. ");
INSERT INTO frd_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Mami dawan mela falurut ra ovu mami dawan ra rala roak Ia verin fareta ra ma rfaleka inukun matmatan verin Ia, beti rbaku Ia naꞌa aa walwalur. ");
INSERT INTO frd_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Naꞌuk lan ana, amfakloꞌi aꞌuk mami vavaꞌat ra verin Ia ma amnaban ma nma, boma nfatalik ami tamata Israel ra tali tamata ovi rira sian ami. Nlia tali inyai, na ini amar itelu roak, ntali amar i rfedan Ia yai, naꞌuk wol nfatalik ami obin. ");
INSERT INTO frd_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Nlia tali inyai, na vata ifira tali mami tamata ra rfabriang ami. Varverak sumatan obin, na ira rti roak van matmatan yai. ");
INSERT INTO frd_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Naꞌuk naꞌa inyai, na wol rtuan Yesus tenan a. Ira rewal ira ma rfaivar verin ami ne, rsiꞌik Ubu Ni sansinir ovi rtali lanit ratan. Sansinir avyai rfalak ne, Yesus nvaꞌat ewal roak. ");
INSERT INTO frd_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Mami kida boku rti vali van matmatan yai. Ti ma rsiꞌik, na wean lahir i vata avyai rfalak a, naꞌuk wol rarea Ia.” ");
INSERT INTO frd_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ba Yesus nfalak verin ira ne, “Hoi, mia ini byoda urun! Bira fikiran ra wol kaꞌi rbana ma lolin, ma wol myorang munuk afa ovi nabi ra rfalak roak a. ");
INSERT INTO frd_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Mia musti mkyaꞌa ne, Raja i ntevut roak tamata rira salasilan ra musti ntuan wawaꞌuk i dawan urun a veki, beti nti vanan i nfitik nyadat a.” ");
INSERT INTO frd_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Nata Yesus nfalyawang verin ira afa ovi rtulis roak naꞌa Ia naꞌa Surat Ralan. Ia nfalyawang lan Ia naꞌa Musa ni kitab ra, beti nabi liak rira kitab ra munuk. ");
INSERT INTO frd_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ti ma rfaseri roak ahu i rti yai, na Yesus notu ma felan a wean i mane nbana lia ira. ");
INSERT INTO frd_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Naꞌuk rkiwal Ia ma rfalak ne, “Lera nakduvul ma laflofan roak, ba itmunuk tnaꞌa ini veki, tevek mane ovan roak.” Ba Yesus norang ira ma irmunuk rnaꞌa inyai. ");
INSERT INTO frd_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Naꞌut i ndoku mane nafnaꞌan ovu ira, na Ia nala lan roti a ma nfalak fara weninyai verin Ubu, beti nvisul roti yai ma nala verin ira. ");
INSERT INTO frd_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Naꞌut inyai beti rkaꞌa lahir ne, inyai Yesus. Naꞌuk brian munuk, na wol nleal lahir. ");
INSERT INTO frd_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ira kaꞌi rsifalak afa ma rfalak ne, “Ita inadida lolin urun naꞌut i tnaꞌa lingaꞌan ralan, ma nangrihi verin ita ovu nfamalik Surat Ralan ihin a verin ita.” ");
INSERT INTO frd_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Naꞌut inyai, na rewal lahir ira rti Yerusalem. Raran roak Yerusalem, na rtuan Yesus Ni tamata vutu rahin isa rasdovu ira ovu rira kida ra. ");
INSERT INTO frd_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Tamata ovi rasdovu ira yai rfalak ne, “Kena urun, Duilaꞌa nvaꞌat ewal roak! Ia nfavotuk roak Ia verin Simon.” ");
INSERT INTO frd_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Nata tamata irua yai rfamalik afa i rarea naꞌut i rbana naꞌa lingaꞌan ralan a, ovu vali wean inba ma rkaꞌa Yesus naꞌut i nvisul roti a. ");
INSERT INTO frd_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Naꞌut i Yesus Ni tamata ovi rorang Ia rfamalik afa ovi rarea roak a, na brian munuk Yesus ndiri fruarira ra, ma nfalak verin ira ne, “Fara Ubu notu ma bira vavaꞌat ra malinan watan!” ");
INSERT INTO frd_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ira rabrian ovu rbobar, tevek rnarin ne rsiꞌik nitu ngran. ");
INSERT INTO frd_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Naꞌuk Yesus nfalak verin ira ne, “Notu afakinimi byobar, ovu afaka notu ma ralabira ra raruan? ");
INSERT INTO frd_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Msyiꞌik limang a ovu eang a; Ini Yaꞌa! Mtyeman tenang a ovu msyiꞌik Yaꞌa, tevek nitu ngran a wol ihin ovu wol lurin wean i msyiꞌik naꞌa tenang a.” ");
INSERT INTO frd_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Yesus nfalak wean inyai, beti nfaturu liman a ovu ean a verin ira. ");
INSERT INTO frd_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Naꞌuk ira wol rorang urun obin, tevek rtalkaka ovu inarira urun ma rsiꞌik Yesus. Ba Yesus norat ira ne, “Bira afamtahan naꞌa ini te wahal?” ");
INSERT INTO frd_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ba ira rala ian tantunun etal a verin Yesus. ");
INSERT INTO frd_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Yesus nala ian yai ma naꞌan lahir naꞌa waharira ralan ra. ");
INSERT INTO frd_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ia nfalak verin ira ne, “Ini afa ovi ufalak roak verin mia naꞌut i itmunuk obin a. Ufalak verin mia ne, afa ovi Musa ntulis roak naꞌa ni kitab ra, ovu nabi liak ra rtulis vali roak naꞌa rira kitab ra, ovu vali naꞌa Mazmur, na irmunuk rfamalik Yaꞌa. Ubu nfadoku roak ma afa avyai fiang ini musti rvotuk munuk roak!” ");
INSERT INTO frd_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Nata Yesus notu ma rira fikiran ra lyawan ma rfan-aran afa ovi rtulis roak naꞌa Surat Ralan. ");
INSERT INTO frd_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Yesus nfalak verin ira ne, “Rtulis roak naꞌa Surat Ralan ne, Raja i ntevut tamata rira salasilan ra musti ntuan wawaꞌuk dawan ma nmata, ma amar itelu nelak, beti nvaꞌat ewal tali matmatan. ");
INSERT INTO frd_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Tamata ra veka rala narang ma ti rfamalik Ubu Ni Ivar Lolin a verin tamata ra munuk, boma rahil ma rtalik tali rira salasilan ra, ma Ubu naꞌi vatuk rira salasilan ra. Rfamalik lan naꞌa Yerusalem, beti rti nuhu ovi rnaꞌa lanit ivavan ini munuk. ");
INSERT INTO frd_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Mia kaꞌi msyiꞌik lahir afa avyai munuk. ");
INSERT INTO frd_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Yaꞌa veka ala Ubu Ni Roh a verin mia, wean lahir Yamang Ni tnorung a verin mia. Naꞌuk mia musti mnyaꞌa kota ini veki, ti naran i Ubu nfangora mia ovu Ni ngrebat a.” ");
INSERT INTO frd_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Nata Yesus novun Ni tamata ovi rorang Ia ma rti kota Yerusalem murin a. Ira rbana ma rfaseri ahu isa naran Betania. Naꞌa inyai, na nsikat liman a ma naflahar ira. ");
INSERT INTO frd_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Naꞌut i naflahar ira, na Ia nti talik ira ma Ubu notu ma nrata lahir lanit ratan. ");
INSERT INTO frd_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ira munuk rsangatur ma raraning Ia. Ira ralarira lolin urun, ma rewal ira rti Yerusalem. ");
INSERT INTO frd_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Lokat amar, na ira rti rira Rahan Dawan Falurut ralan a ma rfadawang Ubu.");
INSERT INTO frd_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Lalan a, naꞌut i Ubu wol notu lanit ivavan obin, na Ia i rfanara Ia ne, Ubu Ni Vaivatul a, nanaꞌa lan roak. Ia nanaꞌa roak ovu Ubu, ovu Ia Ubu Ia. ");
INSERT INTO frd_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Naꞌut i Ubu wol notu lanit ivavan obin, na Ia nanaꞌa lan roak ovu Ubu. ");
INSERT INTO frd_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ubu notu afakataka munuk naꞌa lanit ivavan a nahu Ni Vaivatul a, ba afa ovi rnaꞌa lanit ivavan a munuk wol bisma rnaꞌa, wean i wol notu afa avyai nahu Ni Vaivatul a. ");
INSERT INTO frd_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ubu Ni Vaivatul a nala vavaꞌat mngaꞌun verin tamata ra. Vavaꞌat mngaꞌun yai ntali Ia, ovu nala lyawan verin tamata ra. ");
INSERT INTO frd_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Lyawan yai vanan naꞌa dedan ralan, ovu dedan wol bisma nteri nala ia. ");
INSERT INTO frd_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Amar isa, na Ubu nsinir tamata isa naran Yohanes. ");
INSERT INTO frd_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ia nma ma nfamalik naꞌa lyawan yai, boma tamata ra munuk bisma rorang lyawan yai. ");
INSERT INTO frd_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Lyawan yai wol Yohanes, naꞌuk ia nma watan, boma nfamalik lyawan yai. ");
INSERT INTO frd_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Lyawan mngaꞌun i nala lyawan verin tamata ra munuk nma roak lanit ivavan a. ");
INSERT INTO frd_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Lyawan yai nanaꞌa roak lanit ivavan a. Ubu notu lanit ivavan a nahu lyawan yai, naꞌuk tamata ovi rnaꞌa lanit ivavan a wol rkaꞌa Ia. ");
INSERT INTO frd_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ia nma lahir Ni ahu livur a, naꞌuk Ni tiniman ovi rnaꞌa inyai wol rtorung ma rala Ia. ");
INSERT INTO frd_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Naꞌuk tamata ovi rtorung ma rala Ia ovu rorang Ia, na Ubu nala ngrebat verin ira ma reluk yanan ra. ");
INSERT INTO frd_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ira wol reluk Ubu yanan ra tevek renarir-yamarira ra rarali ira, te rira ininan a, te wol rtali brana ni ininan verin awan a, naꞌuk Ubu kaꞌi notu ma reluk yanan ra. ");
INSERT INTO frd_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ubu Ni Vaivatul neluk tamata, ma nanaꞌa roak lanit ivavan ovu ita, ovu vali ita tsiꞌik roak Ni dawan a. Ni dawan yai, Yaman a nala verin Ia, tevek Yanan ikisa laloꞌi watan. Ubu Yanan nma tali Yaman a, ma notu ma tkaꞌa lahir Ubu Ni rala lolin i dawan urun, ovu afa ovi nfavotuk ra munuk kena. ");
INSERT INTO frd_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yohanes nfalyawang Vaivatul yai ovu vain dawan ma nfalak ne, “Ini tamata i ufamalik roak Ia. Ufalak ne, ‘Ia veka norang yaꞌa nma, naꞌuk Ni dawan a nlia yaꞌa, tevek wol rarali yaꞌa obin, na Ia nanaꞌa lan roak.’ ” ");
INSERT INTO frd_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ia Ni lolin a dawan dalang, ba nala Ni kalolin ra lalawatan verin ita munuk. ");
INSERT INTO frd_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ubu nala Ni inukun ra verin ita nahu Musa. Naꞌuk ita tkaꞌa Ubu Ni rala lolin ovu ivar i kena nahu Yesus Kristus. ");
INSERT INTO frd_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Wol tamata isa vali nrea Ubu, naꞌuk Yanan i ikisa laloꞌi yai nanaꞌa lalawatan ovu Ia. Yanan yai nfalyawang lahir Yaman a verin ita. ");
INSERT INTO frd_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Yahudi rira dawan ovi rnaꞌa Yerusalem rsinir mela falurut ra, ovu tamata Lewi ra ma rti rorat Yohanes ne, “Oa ini iki mngaꞌun?” ");
INSERT INTO frd_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ia ntorung ma nfalyawang lahir ne, “Yaꞌa wol eluk Raja i ntevut dida salasilan ra.” ");
INSERT INTO frd_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Nata rorat ewal ia ne, “Ba iki oa? Beta ne oa ini nabi Elia?” Ia nfalak ne, “Wahal!” Ba rorat ewal vali ia ne, “Beta ne oa ini nabi i lan a Ubu ntorung roak ma nma lanit ivavan a?” Ia nfalak ne, “Wahal!” ");
INSERT INTO frd_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Nata rorat ia ne, “Ba eka fwalak verin ami ne, oa ini iki mngaꞌun? Ami musti amfalyawang verin tamata ovi rsinir ami. Ba eka kaꞌi fwamalik tenam a!” ");
INSERT INTO frd_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yohanes nfalak ne, “Yaꞌa ini tamata i ufwak naꞌa wan lean vu dawan ma tamata ra rfamalola lingaꞌan verin Duilaꞌa.” Afa ovi Yohanes nfalak yai, wean lahir i nabi Yesaya ntulis roak naꞌa ni kitab a. ");
INSERT INTO frd_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Tali tamata ovi rorat Yohanes, na tamata boku rtali Yahudi rira sidovung isa i naran Farisi. ");
INSERT INTO frd_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ira rfalak ne, “Oa wol meluk Raja i mtevut dida salasilan ra, ovu oa wol nabi Elia oa, ovu vali oa wol nabi i Ubu ntorung ma veka nma lanit ivavan a, ba afakinimi bwaptis tamata ra?” ");
INSERT INTO frd_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yohanes nfalak ne, “Yaꞌa ubaptis tamata ra ovu wear, naꞌuk tamata i ndiri fruabira ra, mia wol mkyaꞌa ne, iki Ia. ");
INSERT INTO frd_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ia veka norang yaꞌa nma. Velik ne wean inyai, naꞌuk wol inovan lahir ma aling Ni tatea ni tatur ra, tevek yaꞌa wol verang a ratang Ia.” ");
INSERT INTO frd_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Yohanes ovu tamata ovi rorat ia rfamalik afa avyai munuk naꞌa ahu Betania. Ahu yai nanaꞌa oar Yordan ni lihir timur a. Ia nbaptis tamata ra naꞌa inyai. ");
INSERT INTO frd_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ni ilyan ana, Yohanes nsiꞌik Yesus nma ma ntuan ia, ba nfalak ne, “Eka msyiꞌik! Ubu Ni Domba Yanan i veka nmata al naꞌi vatuk tamata ovi rnaꞌa lanit ivavan a rira salasilan ra. ");
INSERT INTO frd_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ia ini tamata i ufamalik roak Ia ne, ‘Ia veka norang yaꞌa nma, naꞌuk Ni dawan a nlia yaꞌa, tevek wol rarali yaꞌa obin, na Ia nanaꞌa lan roak.’ ");
INSERT INTO frd_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Lan a wol ukaꞌa ne, iki Ia. Naꞌuk uma, ma ubaptis tamata ra ovu wear, ma ufavotuk Ia verin tamata Israel ra, boma bisma rkaꞌa Ia.” ");
INSERT INTO frd_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Yohanes nfamalik vali afa ovi nsiꞌik ra, ma nfalak ne, “Yaꞌa usiꞌik Ubu Ni Roh nsuta tali lanit wean modarlaka, ma ndoku Yesus tenan a. ");
INSERT INTO frd_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Yaꞌa wol ukaꞌa ne, iki Ia. Naꞌuk Ubu i nsinir yaꞌa ma ubaptis tamata ra ovu wear, nfalak roak ne, ‘Wean i msiꞌik Ning Roh nsuta ma nleal tamata isa, na tamata yai veka nbaptis tamata ra ovu Ning Roh a.’ ");
INSERT INTO frd_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Yaꞌa usiꞌik roak afa yai, ba ufalak verin mia ne, Ubu Yanan Ia.” ");
INSERT INTO frd_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ni ilyan ana, Yohanes ovu ni tamata irua ovi rorang ia rnaꞌa ewal wan yai. ");
INSERT INTO frd_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Naꞌut i Yohanes nsiꞌik Yesus nahu wan yai, na nfalak ne, “Msyiꞌik, inyai Ubu Ni Domba Yanan a!” ");
INSERT INTO frd_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Yohanes ni tamata irua yai rarenar afa ovi nfalak ra, ba rti ma rorang Yesus. ");
INSERT INTO frd_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesus ntamuri ma nsiꞌik, na rorang Ia, ba norat ira ne, “Mia mdyava afaka?” Ira rfalak ne, “Rabi, Oa mnaꞌa inba?” (Rabi ihin a, Tuan Guru) ");
INSERT INTO frd_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ia nfalak ne, “Mya ma kaꞌi msyiꞌik.” Ba rorang Ia ma ti rsiꞌik wan i nleal a ma irmunuk rnaꞌa inyai. Naꞌut inyai, na snain jam empat lersian. ");
INSERT INTO frd_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Tali tamata irua yai, na isa naran Andreas. Ia aꞌan verin Simon Petrus. Ia nrenar afa ovi Yohanes nfalak ra, ba norang lahir Yesus. ");
INSERT INTO frd_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ia nti lahir ma ntuan Simon ma nfalak ne, “Ami amtuan roak Raja i ntevut dida salasilan ra (ihin a ne, Kristus).” ");
INSERT INTO frd_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ba Andreas novun Simon ti verin Yesus. Yesus nsiꞌik Simon ma nfalak ne, “Oa ini Simon, yamam naran Yohanes.” Tamata ra veka rera oa ne Kefas (ihin a ne, Petrus). ");
INSERT INTO frd_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ni ilyan ana, Yesus nvolan mane nti propinsi Galilea. Ia wol nti obin, na ntuan Filipus ma nfalak ne, “Mwa ma morang Yaꞌa!” ");
INSERT INTO frd_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipus ini ntali ahu Betsaida. Andreas irua Petrus rtali vali inyai. ");
INSERT INTO frd_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ba ia ti ntuan Natanael ma nfalak ne, “Ami amtuan roak tamata i Musa ntulis roak Ia naꞌa ni inukun ra, ovu nabi ra rtulis vali roak naꞌa tamata yai. Tamata yai, Yesus i ntali Nazaret a. Yusuf yanan Ia.” ");
INSERT INTO frd_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Naꞌuk Natanael nfalak ne, “Wol bis lahir ma afa lolin ntali Nazaret nma.” Filipus nfalak ne, “Mwa ma msiꞌik lahir.” ");
INSERT INTO frd_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yesus nsiꞌik Natanael nma ma ntuan Ia, ba nfalak ne, “Msyiꞌik kikyai, ini tamata Israel mngaꞌun ia. Tamata ini nfalak lalawatan afa ovi kena ra.” ");
INSERT INTO frd_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ba Natanael norat Yesus ne, “Wean inba ma Oa mkaꞌa yaꞌa?” Yesus nfalak ne, “Filipus wol nera oa obin, na urea roak oa naꞌa aa ara vavan a.” ");
INSERT INTO frd_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanael nfalak ne, “Tuan Guru, Ubu Yanan Oa ovu Raja Oa verin tamata Israel ra!” ");
INSERT INTO frd_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesus nfalak ne, “Oa morang Yaꞌa, tevek ufalak ne, urea roak oa naꞌa aa ara vavan a? Oa veka msiꞌik lahir afa dawan ovi rlia tali afa yai.” ");
INSERT INTO frd_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Nata Yesus nfalak lahir ne, “Afa i ufalak verin oa ini kena urun! Oa veka msiꞌik lanit natvadil, ovu Ubu Ni sansinir ra rtali lanit ratan suta-rata ira verin Tamata Yanan a.” ");
INSERT INTO frd_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Amar irua nelak roak, beti tamata ra rotu snoba sifa isa naꞌa ahu Kana, naꞌa propinsi Galilea. Yesus renan a novu snoba yai. ");
INSERT INTO frd_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Rasweang vali Yesus ovu Ni tamata ovi rorang Ia ma rovu snoba yai. ");
INSERT INTO frd_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Naꞌut i rira anggur roak rok, na Yesus renan nfalak verin Ia ne, “Rira anggur roak rok.” ");
INSERT INTO frd_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ba Yesus nfalak ne, “Mama, notu afakinimi fwalak wean inyai verin Yaꞌa? Wol naran Ning amar a obin.” ");
INSERT INTO frd_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Yesus renan nfalak verin tamata ovi rira rkarya ma rliꞌi anggur ne, “Myot-orang watan afa ovi nfalak ra.” ");
INSERT INTO frd_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Naꞌa inyai, na rfadoku ngusi inean. Rotu ngusi avyai tali vatu. Tamata Yahudi baꞌi rsaꞌa wear naꞌa ngusi avyai ma al rfamerat tenarira ra, wean Musa ni inukun nfalak a. Lokat ngusi avyai kaꞌa bi bisma rsaꞌa wear botal ratut isa vutlima. ");
INSERT INTO frd_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesus nfalak verin tamata karya avyai ne, “Mlyiꞌi ma wear nngora naꞌa ngusi avyai.” Ba tamata avyai rliꞌi ma ngusi avyai rngora lahir ovu wear. ");
INSERT INTO frd_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Nata Yesus nfalak verin tamata avyai ne, “Fiang ini, myitu wear kedan a, ma myala verin tamata i nasusan snoba ini.” Ba rot-orang afa i Yesus nfalak a. ");
INSERT INTO frd_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Tamata i nasusan snoba yai ntebung wear a, na wear a naꞌa roak anggur, naꞌuk wol nkaꞌa ne, anggur yai ntali ba. Naꞌuk tamata karya avyai rkaꞌa. Ba tamata yai nera brana i nsifa yai, ");
INSERT INTO frd_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ma nfalak ne, “Naꞌut i snoba wean ini, na tala lan anggur i lolin a ma tamata ra renu, nata nbolak roak ira, beti tala anggur i wol kaꞌi lolin a. Naꞌuk oa fwadok-aling watan anggur i lolin rahi lia munuk ini, ma beti mala mwa.” ");
INSERT INTO frd_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Beti fasa lahir Yesus notu faneak i tamata ra wol rot-nala naꞌa Kana i naꞌa Galilea. Tali faneak yai, na Ia nfaturu Ni dawan a, ba Ni tamata ovi rorang Ia, rorang urun Ia. ");
INSERT INTO frd_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Yesus notu munuk afa avyai, beti nti ahu Kapernaum. Renan a, warin ra, ovu Ni tamata ovi rorang Ia rovu vali Ia, ma rnaꞌa inyai amar ifira watan. ");
INSERT INTO frd_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Tamata Yahudi rira amar dawan Paskah sarseri roak, na Yesus nvaꞌal nti Yerusalem. ");
INSERT INTO frd_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Naꞌa Yahudi rira Rahan Dawan Falurut ni lean a, na Yesus nsiꞌik tamata ovi baꞌi rfedi sapi, domba, modarlaka ovu tamata ovi baꞌi rdoku ma rsitukar kubang rnaꞌa vali inyai. ");
INSERT INTO frd_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ia notu tali naꞌa navnaval, beti nalaꞌing vatuk munuk tamata ovi rnaꞌa inyai, ovu rira sapi ovu domba ra. Ia nvalik tamata ovi rsitukar kubang rira meja ra, ma rira kubang ra ramir-ramar. ");
INSERT INTO frd_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Nata Ia nfalak verin tamata ovi rfedi modarlaka ra ne, “Myaling vatuk munuk afa ovi tali ini. Deka myotu Yamang Ni rahan neluk wan ma tamata ra rfedi-rfaha afa naꞌa!” ");
INSERT INTO frd_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ba Ni tamata ovi rorang Ia rangnanang vaivatul ovi rtulis roak naꞌa Surat Ralan ne, “Yaꞌa ulobang urun Mu rahan a, ta Ubu. Ba afa yai veka not-visal Yaꞌa.” ");
INSERT INTO frd_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ba dawan Yahudi ra rangal Yesus ma rfalak ne, “Eka motu faneak isa i tamata ra wol rot-nala verin ami ma nfaturu ne, Ubu nala fareta verin Oa ma bis motu wean ini.” ");
INSERT INTO frd_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesus nfalak ne, “Myaꞌar vatuk Rahan Dawan Falurut ini, ma ki ufadiri ewal ia naꞌa amar itelu watan.” ");
INSERT INTO frd_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ba Yahudi rira dawan avyai rfalak ne, “Tamata ra rfadiri Rahan Dawan Falurut ini varat vutfaꞌat rahin inean beti roak, na Oa fwalak ne, amar itelu watan, na bisma fwadiri ewal?” ");
INSERT INTO frd_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Naꞌuk Ia nangrihi ma nfalak naꞌa Rahan Dawan Falurut a, ma nfaturu ne, Ia kaꞌi nfamalik tenan a. ");
INSERT INTO frd_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Yesus nvaꞌat ewal tali matmatan, beti Ni tamata ovi rorang Ia rangnanang afa i Yesus nfalak roak yai. Ba ira rorang urun afa ovi rtulis roak naꞌa Surat Ralan a, ovu afa ovi Yesus nfalak roak yai. ");
INSERT INTO frd_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Amar ovi Yesus nanaꞌa Yerusalem naꞌut i rira amar dawan Paskah, na tamata rivun rorang Ia, tevek rsiꞌik roak Ia notu faneak ovi tamata ra wol rot-nala ra. ");
INSERT INTO frd_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Naꞌuk Yesus wol norang tamata avyai, tevek Ia nkaꞌa munuk tamata ralarira ra. ");
INSERT INTO frd_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ia wol nperlu tamata isa vali ma nfamalik tamata ra rira vavaꞌat ra verin Ia, tevek nkaꞌa roak tamata ralarira ra. ");
INSERT INTO frd_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Tamata isa naran Nikodemus. Ia ntali Yahudi rira sidovung Farisi, ovu dawan Yahudi ia vali. ");
INSERT INTO frd_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ovan isa, na ia nti ma ntuan Yesus ma nfalak ne, “Tuan Guru, ami amkaꞌa ne Ubu kaꞌi nsinir Oa mwa ma msiair, tevek wol tamata isa vali bisma notu faneak ovi motu ra, wean i Ubu wol novu ia.” ");
INSERT INTO frd_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesus nfalak ne, “Afa i ufalak verin oa ini kena urun. Wean i tamata isa wol rarali ewal ia, na wol bisma nanaꞌa Ubu Ni Fareta a.” ");
INSERT INTO frd_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodemus nfalak ne, “Wean inba ma tamata isa i itrana roak ia, na bisma rarali ewal ia? Wean inba ma bisma nti ewal renan evun ralan ma rarali ewal ia?” ");
INSERT INTO frd_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ba Yesus nfalak ne, “Afa i ufalak verin oa ini kena urun! Wean i tamata isa wol rarali ia ovu wear ovu vali Ubu Ni Roh a, na ia wol bisma nanaꞌa Ubu Ni Fareta a. ");
INSERT INTO frd_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Tamata ra rarali tamata ra, naꞌuk Ubu Ni Roh nala vavaꞌat ngorvaꞌan naꞌa tamata ralarira ra. ");
INSERT INTO frd_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Deka mtalkaka tevek ufalak ne, musti rarali ewal mia. ");
INSERT INTO frd_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ubu Ni Roh wean nait i nean nti inba watan ovu trenar ngoan a, naꞌuk wol tkaꞌa ne nait yai ntali ba nma, ovu veka nti ba. Tamata ovi rarali ira ovu Ubu Ni Roh, wearira vali inyai.” ");
INSERT INTO frd_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodemus nfalak ne, “Wean inba ma afa i fwalak yai bisma wean inyai?” ");
INSERT INTO frd_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesus nfalak ne, “Oa meluk guru verin tamata Israel ra ma tamata ra ralang ma dawan oa, ba afakinimi wol fwan-aran afa yai? ");
INSERT INTO frd_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Afa i ufalak verin oa ini kena urun! Ami amfamalik afa ovi amkaꞌa ovu amsiꞌik ra, naꞌuk mia wol myorang afa ovi amfalak ra. ");
INSERT INTO frd_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Mia wol myorang afa ovi ufalak ra naꞌa lanit ivavan ini, na wean inba ma bisma myorang wean i ufamalik afa ovi rnaꞌa lanit ratan? ");
INSERT INTO frd_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Wol tamata isa vali nrata roak lanit ratan. Naꞌuk Yaꞌa, Tamata Yanan Yaꞌa, saꞌi usuta roak tali lanit ratan. ");
INSERT INTO frd_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Musa nfadoku nifa i rotu tali tembaga naꞌa aa etal isa, beti nfadiri naꞌa wan lean vu dawan. Yaꞌa, Tamata Yanan Yaꞌa, wean vali inyai. Ning amar a veka nma ma rfasaka Yaꞌa, ");
INSERT INTO frd_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","boma tamata iki watan norang Yaꞌa, na veka ni vavaꞌat kakiwal. ");
INSERT INTO frd_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ubu Ni silobang dawan urun verin tamata ra naꞌa lanit ivavan a, ma nala lahir Yanan ikisa laloꞌi a, boma tamata iki watan norang Ia, na veka wol nmata kakiwal, naꞌuk veka nvaꞌat, nata ti wol ni wahan. ");
INSERT INTO frd_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ubu wol nsinir Yanan nma lanit ivavan a ma nfaleka inukun verin tamata ra, naꞌuk nsinir Ia nma ma nsikat tamata ra tali rira salasilan ra, boma rira vavaꞌat kakiwal. ");
INSERT INTO frd_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Tamata iki watan norang Ubu Yanan a, na Ubu wol nukun ia. Naꞌuk tamata iki watan wol norang Ubu Yanan ikisa laloꞌi a, na Ubu nukun roak ia, tevek wol norang Yanan a. ");
INSERT INTO frd_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ia nukun ira, tevek lyawan a nma roak lanit ivavan ini, naꞌuk ira inar dedan nlia tali lyawan, tevek rotu lalawatan afa ovi sian ra. ");
INSERT INTO frd_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Tamata iki watan inan ma notu afa ovi sian ra, na ia wol inan lahir lyawan a, ovu nafena ma nma lyawan a, boma afa sian ovi notu ra deka rvotuk. ");
INSERT INTO frd_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Naꞌuk tamata iki watan not-orang lalawatan afa ovi kena ra, na ia nma roak lyawan a. Ba lyawan yai nfavotuk ni afa ovi notu ra ne, not-orang lalawatan afa ovi Ubu ralan nfalak ra.” ");
INSERT INTO frd_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ti ma Yesus notu munuk afa avyai, na Ia ovu Ni tamata ovi rorang Ia rti propinsi Yudea. Ira rnaꞌa inyai, ma rbaptis tamata ra. ");
INSERT INTO frd_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","Naꞌut inyai, na wol raꞌabuꞌi Yohanes i nbaptis tamata ra obin. Ia nbaptis tamata ra naꞌa ahu Ainon i nfaseri ahu Salim. Wear a dawan naꞌa inyai, ba tamata ra rma lalawatan ma nbaptis ira. ");
INSERT INTO frd_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Yohanes ni tamata ovi rorang ia boku rsingarahi ovu tamata Yahudi isa naꞌa Yahudi rira adat i rotu ma al rfamerat tenarira ra. ");
INSERT INTO frd_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ba ira rti ma rtuan Yohanes ma rfalak ne, “Tuan Guru, mungnanang tamata i mirua mnyaꞌa oar Yordan nelan a? Oa fwamalik roak Ia verin ami, ovu fiang ini nbaptis vali tamata ra, ovu tamata rivun rti verin Ia.” ");
INSERT INTO frd_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yohanes nfalak ne, “Wol tamata isa bis not-nala afa isa, wean i Ubu wol nala ngrebat verin ia. ");
INSERT INTO frd_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Mia kaꞌi mryenar roak afa ovi ufalak ra ne, ‘Yaꞌa wol Raja i ntevut dida salasilan ra, naꞌuk Ubu nsinir yaꞌa ma uma ula yaꞌa, beti Ia.’ ");
INSERT INTO frd_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ia wean brana i mane nsifa ma nala ni vata ma neluk awan a, na yaꞌa wean ni kida i ndir-ebang ia ovu nrenar vain a. Naꞌut i nrenar vain a, na ralan lolin urun. Ba yaꞌa wean lahir inyai, ma fiang ini ralang a lolin urun. ");
INSERT INTO frd_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Tamata ra musti rfakaratat ilaꞌa Ia, ovu rfakabava watan yaꞌa. ");
INSERT INTO frd_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ia i ntali lanit ratan a, Ni dawan a nlia munuk afakataka. Ia i ntali lanit ivavan a, tamata watan ia, ba nfamalik watan afa ovi rvotuk naꞌa lanit ivavan ini. Ia i ntali lanit ratan a, Ni dawan nlia munuk afakataka. ");
INSERT INTO frd_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ia nfamalik afa ovi nsiꞌik ovu nrenar ra naꞌa lanit ratan, naꞌuk wol tamata isa vali norang afa ovi nfalak ra. ");
INSERT INTO frd_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Tamata iki watan norang afa ovi nfalak ra, na nfaturu ne, Ubu kena Ia. ");
INSERT INTO frd_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ubu nsinir Ia ma nfamalik Ni vaivatul ra, tevek nfangora lahir Ia ovu Ni Roh a. ");
INSERT INTO frd_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ubu nlobang urun Yanan a, ovu nala roak Ni ngrebat a verin Ia ma nfareta munuk afakataka. ");
INSERT INTO frd_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Tamata iki watan norang Ubu Yanan a, na ia ni vavaꞌat kakiwal. Naꞌuk tamata iki watan wol norang Ia, na veka wol ni vavaꞌat kakiwal. Ubu nangrova ma nukun ia, nata ti wol ni wahan.” ");
INSERT INTO frd_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Tamata ovi rtali Yahudi rira sidovung Farisi rarenar roak ne, tamata ovi rma ma rorang Duilaꞌa Yesus ovu rera ma nbaptis ira yai, rivun lia tamata ovi rorang Yohanes ovu nbaptis ira. ");
INSERT INTO frd_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Velik aba, Yesus wol nbaptis tamata ra, naꞌuk Ni tamata ovi rorang Ia rbaptis tamata ra. ");
INSERT INTO frd_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Naꞌut i Yesus nkaꞌa ne, tamata Farisi avyai rarenar roak afa ovi Ia ovu Ni tamata ra rotu, na nti talik propinsi Yudea ma newal Ia nti propinsi Galilea. ");
INSERT INTO frd_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Naꞌa Ni banbanan a, na musti nahu propinsi Samaria. ");
INSERT INTO frd_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Yesus nbana nata naran ahu isa naꞌa Samaria naran Sikhar. Ahu yai nfaseri lanun i lalan a Yakub nala verin yanan i Yusuf a. ");
INSERT INTO frd_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Yakub ni wear kakear naꞌa ahu yai. Yesus nafrea tevek nbana ma raroa, ba ndoku wear yai nelan a. Naꞌut inyai, na snain a lera ndirlola. ");
INSERT INTO frd_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Yesus Ni tamata ovi rorang Ia rti roak ahu yai ma rfaha afamtahan. Wol mnanat, na vata Samaria isa nma mane nitu wear. Ba Yesus nfalak verin ia ne, “Titi, mlobang ma mala wear kedan a ma enu.” ");
INSERT INTO frd_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Vata yai nfalak verin Ia ne, “Oa tamata Yahudi Oa, na yaꞌa tamata Samaria yaꞌa, ba afakinimi mera wear tali yaꞌa ma menu?” (Vata yai nfalak wean inyai, tevek tamata Yahudi wol rkamlabir tamata Samaria ra.) ");
INSERT INTO frd_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesus nfalak ne, “Wean i mkaꞌa Ubu Ni rala lolin i nala verin tamata ra, ovu mkaꞌa vali ne Yaꞌa ini iki, na oa veka mera wear tali Yaꞌa, ovu Yaꞌa veka ala wear i nala vavaꞌat a verin oa.” ");
INSERT INTO frd_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Vata yai nfalak ne, “Bapa, Oa wol Mu taul, ovu wear ini blaman. Ba veka mala wear i nala vavaꞌat yai tali inba? ");
INSERT INTO frd_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ubumam-nusimami Yakub nala wear kakear ini verin ami. Ia ovu yanan ra, ovu vali ni afwatan ra renu roak wear ini. Oa fwikir ne, Mu dawan a nlia Yakub?” ");
INSERT INTO frd_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesus nfalak ne, “Tamata iki watan nenu wear ini, na ia veka nabroa ewal. ");
INSERT INTO frd_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Naꞌuk iki watan nenu wear i ala verin ia, na veka wol nabroa roak, nata ti wol ni wahan. Tevek wear i ala verin ia yai wean wear matan naꞌa tamata yai ralan a, ma nava lalawatan ovu nala vavaꞌat kakiwal verin ia.” ");
INSERT INTO frd_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Vata yai nfalak ne, “Bapa, mala wear yai verin yaꞌa, na wol ubroa roak ovu wol uma roak ma ala wear ini.” ");
INSERT INTO frd_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yesus nfalak ne, “Muti ma mera awam a, ma mirua mya ini.” ");
INSERT INTO frd_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Vata yai nfalak ne, “Yaꞌa wol awang.” Yesus nfalak ne, “Oa fwalak kena, ");
INSERT INTO frd_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","tevek awam ilima roak, ovu brana i fiang ini mirua mleal isa, wol awam ia. Mu vaivatul ra kena.” ");
INSERT INTO frd_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Vata yai nfalak ne, “Bapa, fiang ini ukaꞌa lahir ne, nabi Oa. ");
INSERT INTO frd_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ami tamata Samaria ubumam-nusimami ra rsangatur ma raraning Ubu naꞌa vuar ini, naꞌuk Mu tamata Yahudi ra rfalak ne, Yerusalem aꞌuk neluk wan ma tamata ra rsangatur ma raraning Ubu.” ");
INSERT INTO frd_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesus nfalak ne, “Titi, morang afa i mane ufalak ini: Ni amar veka nma ma tamata ra rsangatur ma raraning Yamadida, naꞌuk wol nanaꞌa roak vuar ini ovu vali wol nanaꞌa Yerusalem. ");
INSERT INTO frd_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Mia tamata Samaria ra msyangatur ma mryaning Ubu, naꞌuk wol mkyaꞌa ne, iki Ia. Naꞌuk ami tamata Yahudi ra amsangatur ma amraning Ubu i amkaꞌa roak Ia. Tevek nahu tamata Yahudi ra, na Ubu nsikat tamata ra tali rira salasilan ra, ma rira vavaꞌat kakiwal. ");
INSERT INTO frd_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Naꞌuk ni amar a veka nma ovu fiang ini, amar yai nma roak, ma ngrebat tali Ubu Ni Roh notu ma tamata ra rkaꞌa lingaꞌan i kena a ma rsangatur ma raraning Yamadida. Ubu inan ma tamata ra rsangatur ma raraning Ia wean inyai. ");
INSERT INTO frd_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ubu Roh Ia, ba iki watan mane nsangatur ma nraning Ia, na musti nsangatur ma nraning Ia ovu ngrebat i ntali Ni Roh a, ovu norang lingaꞌan i kena.” ");
INSERT INTO frd_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Vata yai nfalak verin Yesus ne, “Yaꞌa ukaꞌa ne, Raja i ntevut mami salasilan ra veka nma. Rfalak vali Ia ne, Kristus. Naꞌut i nma, na veka nfamalik afakataka munuk verin ami.” ");
INSERT INTO frd_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesus nfalak ne, “Yaꞌa ini Tamata i fwalak yai, fiang ini nangrihi nulu oa.” ");
INSERT INTO frd_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Naꞌut inyai, na Yesus Ni tamata ovi rorang Ia rewal roak ira rma wan yai. Ira rtalkaka, tevek rsiꞌik i Yesus nangrihi ovu vata. Naꞌuk wol tamata isa vali norat Yesus ne, “Oa inam afaka?” Te, “Afakinimi mungrihi nulu vata yai?” ");
INSERT INTO frd_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ba vata yai nti talik ni suran a naꞌa inyai, ma nti ahu ma nfalak verin tamata ra ne, ");
INSERT INTO frd_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Mya ma ti tsiꞌik tamata i nfamalik munuk lahir ning afa ovi otu ra. Beta ne Ia Raja i ntevut dida salasilan ra.” ");
INSERT INTO frd_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ba tamata avyai rti ahu yai murin a mane rtuan Yesus. ");
INSERT INTO frd_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Tamata avyai wol rtuan Yesus obin, na Ni tamata ovi rorang Ia rfalak ne, “Tuan Guru, mufnaꞌan kikyai.” ");
INSERT INTO frd_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Naꞌuk Yesus nfalak ne, “Yaꞌa Ning afamtahan nanaꞌa, naꞌuk mia wol mkyaꞌa.” ");
INSERT INTO frd_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ba Ni tamata ovi rorang Ia kaꞌi rsiforat ira ne, “Tamata aba rala roak afamtahan verin Ia?” ");
INSERT INTO frd_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ba Yesus nfalak verin ira ne, “Wean i ot-orang Ia i nsinir Yaꞌa, Ni afa ovi nfalak ra, ovu ot-nala munuk karya ovi nala verin Yaꞌa, na inyai wean watan Ning afamtahan. ");
INSERT INTO frd_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Mia fyalak ne, ‘Vulan ifaꞌat ewal, beti tamata rafdiar.’ Naꞌuk ufalak verin mia ne: Eka msyiꞌik vaꞌi wanat ra. Wanat ra rwavar roak ovu bisma tafdiar roak. ");
INSERT INTO frd_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Fiang ini tamata ovi rafdiar a rala roak rira kubang tali rira karya, ba tamata ovi rafdiar ovu tamata ovi ravuri-rava, irmunuk ralarira lolin urun. Wanat ovi rdiar roak yai ihin a ne, tamata ovi rira vavaꞌat kakiwal. ");
INSERT INTO frd_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ba kena ovu faliak ini: Tamata isa navuri-nava nabat ra, na tamata liak ti nafdiar. ");
INSERT INTO frd_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Yaꞌa usinir mia ti mifdiar naꞌa vaꞌi i wol myotu a. Tamata liak ra rkarya lan roak naꞌa vaꞌi yai, naꞌuk mia myala utubira tali rira karya ra.” ");
INSERT INTO frd_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Tamata Samaria ovi rnaꞌa ahu yai, rivun ira rorang roak Yesus, tevek vata yai nfalak ne, “Ia nfamalik munuk lahir afa ovi otu ra.” ");
INSERT INTO frd_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ba naꞌut i tamata Samaria avyai rma ma rtuan Yesus, na rera lalawatan verin Ia ma irmunuk rleal inyai veki. Ba Yesus nleal inyai amar irua. ");
INSERT INTO frd_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Tamata ovi rorang Yesus rtafal ma rivun, tevek Ni afa ovi nair ra. ");
INSERT INTO frd_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ba ira rfalak verin vata yai ne, “Fiang ini amorang Ia, wol mane ntali afa ovi fwalak ra watan, naꞌuk ami kaꞌi amrenar afa ovi nfalak ra. Amkaꞌa lahir ne, Ia Raja i nsikat tamata ra tali rira salasilan ra.” ");
INSERT INTO frd_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Yesus nanaꞌa Sikhar amar irua, beti nti Galilea. ");
INSERT INTO frd_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ia kaꞌi nfalak roak ne, tamata isa, velik ne nabi ia, naꞌuk wol ralang ia naꞌa ni ahu a. ");
INSERT INTO frd_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Tamata ovi rnaꞌa Galilea rti roak Yerusalem naꞌut i tamata Yahudi rira snoba Paskah. Naꞌut inyai, na ira rarea munuk roak afa ovi Yesus notu ra. Ba ti ma Yesus naran Galilea, na tamata ra rtorung ma ti rsaꞌa Ia ovu ralarira lolin. ");
INSERT INTO frd_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yesus newal Ia nti ahu Kana naꞌa Galilea. Lan a Ia nti roak ahu yai, ma notu roak ma wear nanaꞌa anggur. Naꞌa ahu Kapernaum, na raja ni tamata karya isa yanan a nawar ia. ");
INSERT INTO frd_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Naꞌut i raja ni tamata karya yai nrenar ne, Yesus ntali Yudea nma roak Galilea, na ia nti ma nera lablobang verin Yesus ma nti Kapernaum, boma notu ma lolin ewal yanan a, tevek yanan a sarseri mane nmata. ");
INSERT INTO frd_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ba Yesus nfalak verin ia ne, “Wean i mia wol msyiꞌik faneak ovi tamata ra wol rot-nala ovu mujizat ra, na veka wol myorang Yaꞌa.” ");
INSERT INTO frd_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Tamata yai nfalak ne, “Duilaꞌa, mwa kikyai, boma yanak a deka nmata.” ");
INSERT INTO frd_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesus nfalak ne, “Mewal aꞌuk oa, yanam a veka lolin ewal ia.” Tamata yai norang afa ovi Yesus nfalak ra, ba newal ia. ");
INSERT INTO frd_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Naꞌut i newal ia ma naꞌa ni banbanan obin, na ni tamata sansinir ra rma ma rtuan ia ma rfalak ne, “Yanam a lolin ewal roak ia.” ");
INSERT INTO frd_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ba norat ira ne, “Mulai ma lolin ia jam ifira?” Ira rfalak ne, “Inravin a, kaꞌa bi jam satu lera ndirlola, na wol nayadu roak ia.” ");
INSERT INTO frd_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ba kasikoꞌu yai yaman a nangnanang nala ne, naꞌut inyai, na Yesus nfalak ne, “Yanam a lolin ewal roak ia.” Ba ia ovu ni rahan teta munuk rorang Yesus. ");
INSERT INTO frd_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ini ma farua roak Yesus notu faneak i tamata ra wol rot-nala naꞌa Galilea, naꞌut i newal Ia tali Yudea. ");
INSERT INTO frd_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Yesus notu munuk afa avyai, beti newal ia ma nvaꞌal nti Yerusalem, tevek tamata Yahudi rira amar dawan isa. ");
INSERT INTO frd_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Naꞌa Yerusalem, na rfanara fidu isa ne Fidu Domba. Naꞌa fidu yai ni falfolat nelan a, na kolam isa nsaꞌa wear. Kolam yai naran naꞌa vai Ibrani, Betesda, ovu naꞌa wan yai vali, na rotu abelus ilima. ");
INSERT INTO frd_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Naꞌa abelus avyai, na tamata ovi rira suhut ra, rivun ira rtuba wan yai. Tamata avyai boku rkibu, boku wol rbana nala, ovu vali boku ratlukut. Tamata avyai rnaban ma wear i naꞌa kolam yai nfaduak. ");
INSERT INTO frd_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Tevek amar boku, na Ubu Ni sansinir tali lanit ratan nsuta ma nfaduak wear i naꞌa kolam yai. Ba ti ma wear yai nfaduak, na tamata ovi rira suhut ra, wean i iki nsuta ula ia ma nsovu tenan a, na veka lolin lahir ia. ");
INSERT INTO frd_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Tali tamata suhut avyai, na brana isa nawar ia varat vututelu rahin iwalu roak. ");
INSERT INTO frd_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesus nsiꞌik brana yai ntuba watan wan a, ovu nkaꞌa ne, ni suhut a mnanat roak, ba nfalak verin ia ne, “Inam ma lolin oa?” ");
INSERT INTO frd_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Tamata yai nfalak ne, “Bapa! Wean i wear naꞌa kolam yai nfaduak, na wol tamata ma rfasuka yaꞌa naꞌa kolam yai. Usahak roak ma ti ufaseri kolam yai, naꞌuk tamata boku ula roak ira rsuta.” ");
INSERT INTO frd_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ba Yesus nfalak verin ia ne, “Baba, mdiri ma mlulung mu dari a ma bwana kikyai.” ");
INSERT INTO frd_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Naꞌut inyai, na tamata yai lolin lahir ia, ba nlulung ni dari a ma nbana. Amar yai, amar i tamata Yahudi ra ryari ira. ");
INSERT INTO frd_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ba dawan Yahudi ra rfalak verin tamata i beti lolin ia tali ni suhut yai ne, “Hoi, amar ini amar ma tyari ita, ma wol bisma mkarya, ba wol bisma mtaha mu dari a.” ");
INSERT INTO frd_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Tamata yai nfalak ne, “Tamata i notu ma lolin yaꞌa nfalak verin yaꞌa ne, ‘Mlulung mu dari a ma bwana kikyai.’ ” ");
INSERT INTO frd_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ba rorat ia ne, “Inyai tamata iki mi nfalak verin oa ma mlulung mu dari a ma bwana?” ");
INSERT INTO frd_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Naꞌuk ia wol nkaꞌa tamata i notu ma lolin ia yai, tevek Yesus ti nanaꞌa tamata rivun fruarira ra, ba wol nrea roak Ia. ");
INSERT INTO frd_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Wol mnanat, na Yesus ntuan ewal tamata yai naꞌa Yahudi rira Rahan Dawan Falurut ralan a. Ba nfalak verin ia ne, “Lolin roak oa ta baba. Deka motu salasilan kikyai, boma deka mtuan sian i nlia tali lan a.” ");
INSERT INTO frd_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Nata ia nti ma nfalak verin dawan avyai ne, tamata i notu ma lolin ewal ia tali ni suhut a, inyai Yesus. ");
INSERT INTO frd_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ba dawan Yahudi avyai betmane rwi-rwa Yesus, tevek notu ma tamata ra lolin ewal ira naꞌa amar i Yahudi ra ryari ira. ");
INSERT INTO frd_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Naꞌuk Yesus nfalak verin ira ne, “Yamang a nkarya lalawatan ma naran amar ini, ba Yaꞌa musti ukarya vali.” ");
INSERT INTO frd_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Yesus nfalak wean inyai, ba dawan Yahudi avyai rkiwal ma rdava lingaꞌan ma rfedan Ia. Ira rotu wean inyai, tevek Yesus wol mane nangal watan Yahudi rira adat naꞌa amar i ryari ira, naꞌuk nfalak vali ne, Ia Yaman verin Ubu. Yesus nfalak wean inyai, ma notu ma Ia wean lahir Ubu. ");
INSERT INTO frd_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yesus nfalak verin ira ne, “Afa i ufalak verin mia ini kena urun! Velik ne Ubu Yanan Yaꞌa, naꞌuk wol Ning ngrebat ma otu afaka watan, wean i ralang a nfalak. Yaꞌa musti usiꞌik afa ovi Yamang notu ra ma ot-orang. Afa ovi Yamang notu ra, Yaꞌa veka otu vali. ");
INSERT INTO frd_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Tevek Yamang a nlobang Yaꞌa, ovu Ia nfaturu munuk afa ovi notu ra verin Yaꞌa. Ia veka nfaturu afa ovi inan ma otu ra, ma nlia tali afa ovi otu roak ma mryea, boma msyiꞌik na mtyalkaka. ");
INSERT INTO frd_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Yamang a nfavaꞌat tamata ovi rmata ra, ma nala vavaꞌat verin ira. Yaꞌa veka wean vali inyai, ma veka ala vavaꞌat a verin tamata iki watan i ralang nfalak a. ");
INSERT INTO frd_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Yamang a wol nfaleka inukun verin tamata iki watan. Naꞌuk nala munuk roak Ni ngrebat a verin Yanan a, ma al nfaleka inukun verin tamata ra. ");
INSERT INTO frd_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Yamang a notu wean inyai, boma tamata ra bisma ralang Yaꞌa, wean i ralang Ia. Tamata iki watan wol nalang Yaꞌa, na ia wol nalang vali Yamang i nsinir Yaꞌa ma uma lanit ivavan a. ");
INSERT INTO frd_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Afa i ufalak verin mia ini, kena urun! Wean i tamata iki watan nrenar ovu not-orang afa ovi ufalak ra ovu norang Ia i nsinir Yaꞌa, na inukun veka wol nkena ia, ovu veka ni vavaꞌat kakiwal. Ia veka wol nmata, naꞌuk ni roak vavaꞌat kakiwal a. ");
INSERT INTO frd_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Afa i ufalak verin mia ini, kena urun! Amar a sarseri roak, ovu amar a naran roak, ma tamata ovi rmata roak a veka rarenar Ubu Yanan vain a, ovu tamata ovi rarenar vain a, veka rvaꞌat. ");
INSERT INTO frd_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Yamang Ni ngrebat ma nala vavaꞌat verin tamata ra, ovu Ia nala vali ngrebat verin Yaꞌa ma ala vavaꞌat verin tamata ra. ");
INSERT INTO frd_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Yamang a nala roak ngrebat verin Yaꞌa ma ufaleka inukun verin tamata ra, tevek Yaꞌa Tamata Yanan Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Deka mibrian naꞌa afa ovi ufalak ra, tevek amar a veka nma ma tamata ovi rnaꞌa roak tivat matmatan ra veka rarenar vaing a, ");
INSERT INTO frd_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ma rtali inyai rma murin. Tamata ovi rotu lolin naꞌut i rvaꞌat a, na veka rvaꞌat ewal ma rira vavaꞌat kakiwal. Naꞌuk tamata ovi rotu watan afa ovi sian ra naꞌut i rvaꞌat a, na veka rvaꞌat vali, naꞌuk Ubu nukun ira. ");
INSERT INTO frd_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Yaꞌa wol ot-nala akataka wean i ralang a nfalak ma otu a. Yaꞌa ufaleka inukun watan verin tamata wean lahir i urenar tali Ubu. Ufaleka inukun ovu ni malolan a, tevek wol orang watan afa ovi ralang a nfalak a, naꞌuk ot-orang afa ovi Ubu ralan nfalak a, tevek nsinir Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Wean i kaꞌi ufamalik Yaꞌa, na tamata ra wol rorang afa ovi ufalak ra. ");
INSERT INTO frd_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Naꞌuk Yamang nfamalik vali afa ovi otu ra. Ba Yaꞌa ukaꞌa ne, afa ovi Ia nfalak yai kena. ");
INSERT INTO frd_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Mia msyinir roak tamata ra ma rti rarenar Yohanes ni afa ovi nfalak ra, ovu ia nfalak naꞌa afa ovi otu ra ne, kena. ");
INSERT INTO frd_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Naꞌuk wean i tamata ra rfamalik te wol rfamalik Yaꞌa verin tamata liak, na inyai wol akataka verin Yaꞌa. Naꞌuk ufalak watan afa ovi Yohanes nfalak roak yai verin mia, boma kaꞌi mryenar ovu myorang ma Ubu nsikat mia tali bira salasilan ra, ma bira vavaꞌat kakiwal. ");
INSERT INTO frd_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yohanes wean damar i nyeba ma nala lyawan verin mia. Inabira lolin naꞌa lyawan yai, naꞌuk wol mnanat. ");
INSERT INTO frd_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Yohanes nfamalik roak ne, Yaꞌa ini iki. Naꞌuk wean i inabira ma mkyaꞌa mngaꞌun ne, Yaꞌa ini iki, na bisma msyiꞌik afa ovi fiang ini otu ra. Afa avyai rfaturu ne, Yamang nsinir Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Yamang i nsinir Yaꞌa kaꞌi nfamalik vali ne, iki Yaꞌa. Mia wol mryenar vain a ovu vali wol msyiꞌik felan a obin. ");
INSERT INTO frd_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ni vaivatul ra wol rnaꞌa ralabira ra, tevek wol myorang Yaꞌa. Velik ne Ia nsinir Yaꞌa ma ufamalik Ni vaivatul ra, naꞌuk wol myorang Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Mia byas ma mkyear mkyali Surat Ralan a, tevek minovak ne, myotu wean inyai, na mdyav-nala roak lingaꞌan ma bira vavaꞌat kakiwal. Surat Ralan yai nfamalik Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Naꞌuk mia mifena ma mya mtyuan Yaꞌa, ma bira vavaꞌat kakiwal yai. ");
INSERT INTO frd_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Yaꞌa wol udava ma tamata ra ralang Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Naꞌuk ukaꞌa mia ne, naꞌa ralabira ra, na wol bira silobang verin Ubu. ");
INSERT INTO frd_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Uma ovu Yamang Ni ngrebat a, naꞌuk mifena ma mtyorung Yaꞌa. Naꞌuk wean i tamata liak isa nma ovu ni ngrebat a, na mtyorung ia. ");
INSERT INTO frd_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Mia kaꞌi mdyava watan ma tamata ra rfadawang mia, naꞌuk wol mdyava ma Ubu i ikisa watan nfadawang mia. Myotu wean inyai, na wol myorang Yaꞌa! ");
INSERT INTO frd_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Deka fyikir ne, amar isa, na veka umangadu mia naꞌa Yamang wahan ralan a. Naꞌuk Musa veka nmangadu mia, velik ne fyakloꞌi bira vavaꞌat ra verin ia. ");
INSERT INTO frd_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Wean i myorang Musa ni afa ovi ntulis ra, na mia veka myorang vali Yaꞌa, tevek afa ovi ntulis ra rfamalik Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Naꞌuk wean i wol myorang ni afa ovi ntulis ra, na wean inba ma myorang Ning afa ovi ufalak ra?” ");
INSERT INTO frd_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Yesus notu munuk afa avyai, beti nrata kumal isa ma nti danau Galilea ni lihir a. Danau yai rfanara vali ia ne, danau Tiberias. ");
INSERT INTO frd_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Tamata rivun rban-earira ma rorang Ia, tevek rsiꞌik roak mujizat ovi notu ma tamata ovi rira suhut ra lolin ira. ");
INSERT INTO frd_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Nata Yesus ovu Ni tamata ovi rorang Ia rti rvaꞌal vuar ma rdoku. ");
INSERT INTO frd_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Naꞌut inyai, na Yahudi rira amar dawan Paskah sarseri roak. ");
INSERT INTO frd_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Naꞌut i Yesus nvanung wahan a ma nsiꞌik tia ma, na tamata rivun ilaꞌa rma mane rtuan Ia, ba nfalak verin Filipus ne, “Ita veka tfaha roti naꞌa inba ma al tfaꞌan tamata rivun ovi?” ");
INSERT INTO frd_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yesus nfalak wean inyai ma nlabir teman Filipus, tevek Yesus nkaꞌa afa ovi veka notu ra. ");
INSERT INTO frd_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipus nfalak ne, “Velik ne tfaha roti fyawan dinar ratut irua vali, ma tsiduk kadkedan lokat ira, na wol naran watan.” ");
INSERT INTO frd_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Nata Simon Petrus warin i naran Andreas nfalak verin Yesus ne, ");
INSERT INTO frd_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Kasikoꞌu brana isa naꞌa ini ntaha roti ilima ovu ian irua. Naꞌuk afa avyai wol naran ma tfaꞌan tamata rivun ovi.” ");
INSERT INTO frd_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ba Yesus nfalak ne, “Fyalak verin tamata avyai ma rdoku.” Naꞌa wan yai, na ngrova yanat lalawatan, ba tamata avyai rdoku watan inyai. Tali tamata avyai munuk, na brana ra watan kaꞌa bi rivun ilima. ");
INSERT INTO frd_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ba Yesus nala roti avyai ma naflurut ovu nfalak fara weninyai verin Ubu, beti ntanang verin tamata ovi rdoku inyai. Nata Yesus nala vali ian irua yai, ma notu vali wean inyai, ba rafnaꞌan ma tali watan ira. ");
INSERT INTO frd_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Rafnaꞌan ma evurira ra rveda roak, beti Yesus nfalak verin Ni tamata ovi rorang Ia ne, “Misdovuk munuk roti teran ra, boma deka mane rvatuk watan.” ");
INSERT INTO frd_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ba ti ma rafnaꞌan munuk, na rasdovuk roti etal ra tali roti ilima yai teran ra, naꞌa ahir vutu rahin irua rngora. ");
INSERT INTO frd_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Naꞌut i tamata rivun avyai rsiꞌik mujizat i Yesus notu yai, na rfalak lahir ne, “Kena urun! Ia ini nabi i Ubu ntorung roak, ma veka nma lanit ivavan a.” ");
INSERT INTO frd_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yesus nkaꞌa afa i tamata rivun avyai ranovak a. Tamata avyai mane rkiwal Ia ma neluk raja verin ira. Ba Yesus nban-talik wan yai ma nti vuar isa ma aksa Ia watan naꞌa inyai. ");
INSERT INTO frd_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Naꞌut i lera mane nakduvul roak, na Yesus Ni tamata ovi rorang Ia rti danau. ");
INSERT INTO frd_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ira rdata rira kumal mane rti ahu Kapernaum, naꞌa danau ni lihir a. Ti ma ovan roak, na Yesus wol nma ntuan ira obin. ");
INSERT INTO frd_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Wol mnanat, na nait a dawan ovu saksakan dawan naꞌa danau yai. ");
INSERT INTO frd_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ira rvahi ma snain kil ilima te inean roak, na rsiꞌik i Yesus nbana naꞌa wear ratan ma nfaseri rira kumal a, ba rbobar urun i lahir. ");
INSERT INTO frd_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Naꞌuk Yesus nfalak verin ira ne, “Yaꞌa ini, ba deka byobar!” ");
INSERT INTO frd_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ira rtorung ma irmunuk Yesus rnaꞌa rira kumal a. Brian munuk, na raran lahir wan i mane rti yai. ");
INSERT INTO frd_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ti ma ni ilyan, beti tamata rivun ovi rnaꞌa danau yai ni lihir a rkaꞌa ne, inravin a kumal isa watan naꞌa inyai. Ira rkaꞌa vali roak ne, Yesus Ni tamata ovi rorang Ia rti roak ovu kumal yai, naꞌuk Yesus wol novu. ");
INSERT INTO frd_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Naꞌut inyai, na kumal liak boku rtali kota Tiberias rma ma rlau ebang wan i Yesus nera verin Ubu ma naflahar roti ra ma tamata rivun raꞌan. ");
INSERT INTO frd_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ti ma tamata rivun avyai rkaꞌa roak ne, Yesus ovu Ni tamata ovi rorang Ia wol rnaꞌa roak wan yai, na rafnavul lahir kumal avyai ma rti Kapernaum ma rdava Yesus. ");
INSERT INTO frd_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Naꞌut i tamata rivun avyai rti ma rtuan Yesus naꞌa Kapernaum, na rorat Ia ne, “Tuan Guru, mwa maran ini lafira?” ");
INSERT INTO frd_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesus nfalak verin ira ne, “Afa i ufalak verin mia ini, kena urun! Velik aba, mia wol mdyava Yaꞌa tevek msyiꞌik roak i otu faneak ovi tamata ra wol rot-nala, naꞌuk mdyava Yaꞌa tevek mian roak roti ma evubira rveda roak. ");
INSERT INTO frd_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Deka mdyava afamtahan ovi bisma rbetan, naꞌuk mkyarya ma al mdyava afamtahan ovi rala vavaꞌat kakiwal. Yaꞌa, Tamata Yanan Yaꞌa, veka ala afamtahan yai verin mia, tevek Yamang a nala roak ngrebat verin Yaꞌa.” ");
INSERT INTO frd_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ba rfalak verin Yesus ne, “Ami musti amotu afaka, boma amot-orang afa ovi Ubu ralan nfalak a?” ");
INSERT INTO frd_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesus nfalak verin ira ne, “Karya i Ubu ralan nfalak ma myotu a wean ini: Myorang Ia i Ubu nsinir roak ma nma ini.” ");
INSERT INTO frd_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ba rfalak verin Ia ne, “Oa veka motu faneak aka ma amsiꞌik, boma amorang Oa? Oa Mu karya afaka? ");
INSERT INTO frd_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ubumam-nusimami ra raꞌan afamtahan i naran manna naꞌa wan lean vu dawan, wean i rtulis roak naꞌa Surat Ralan ne, ‘Ia nala afamtahan tali lanit ratan ma raꞌan.’ ” ");
INSERT INTO frd_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ba Yesus nfalak verin ira ne, “Afa i ufalak verin mia ini, kena urun! Musa wol nala afamtahan tali lanit ratan verin mia, naꞌuk Yamang a nala afamtahan mngaꞌun tali lanit ratan verin mia. ");
INSERT INTO frd_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Tevek afamtahan i Yamang nala yai nfaturu Ia i ntali lanit ratan nma, ma nala vavaꞌat verin tamata ra naꞌa lanit ivavan a.” ");
INSERT INTO frd_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ira rfalak verin Yesus ne, “Duilaꞌa, mala afamtahan yai lalawatan verin ami.” ");
INSERT INTO frd_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yesus nfalak verin ira ne, “Yaꞌa ini afamtahan i nala vavaꞌat a. Tamata iki watan nma verin Yaꞌa, na ia veka wol nablafar roak. Tamata iki watan norang Yaꞌa, na ia veka wol nabroa roak. ");
INSERT INTO frd_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Naꞌuk ufalak roak verin mia ne, velik ne msyiꞌik roak Yaꞌa, naꞌuk wol myorang Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Tamata ovi Yamang a nala roak ira verin Yaꞌa, veka rma munuk Yaꞌa. Tamata iki watan nma verin Yaꞌa, na wol ulaꞌing ia. ");
INSERT INTO frd_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Tevek uma tali lanit ratan ovu wol mane ot-orang afa ovi ralang nfalak ra. Naꞌuk ot-orang Ia i nsinir roak Yaꞌa Ni afa ovi ralan nfalak ra. ");
INSERT INTO frd_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ia i nsinir roak Yaꞌa, ralan nfalak wean ini: tali tamata ovi nala roak ira verin Yaꞌa, na wol isa vali nmamu, naꞌuk veka ufavaꞌat ewal ira tali matmatan naꞌa amar i lanit ivavan veka namwear. ");
INSERT INTO frd_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Tevek afa ovi Yamang ralan nfalak a wean ini: tamata iki watan nsiꞌik Yaꞌa, Ubu Yanan a, ovu norang Yaꞌa, na veka ni vavaꞌat kakiwal. Yaꞌa veka ufavaꞌat ewal ia tali matmatan naꞌa amar i lanit ivavan veka namwear.” ");
INSERT INTO frd_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Tamata Yahudi ra rafngamuꞌur, tevek Yesus nfalak roak ne, “Yaꞌa ini afamtahan i nsuta tali lanit ratan.” ");
INSERT INTO frd_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ira kaꞌi rsifalak afa verin ira ne, “Yesus ini Yusuf yanan a. Ita tkaꞌa roak renan ovu yaman a, naꞌuk wean inbinimi nfalak ne, ‘Yaꞌa usuta tali lanit ratan?’ ” ");
INSERT INTO frd_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ba Yesus nfalak verin ira ne, “Deka mifngamuꞌur. ");
INSERT INTO frd_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Wol tamata isa vali bisma nma verin Yaꞌa, wean i Yamang i nsinir Yaꞌa wol novun ia nma. Tamata iki nma verin Yaꞌa, na veka ufavaꞌat ewal ia tali matmatan naꞌa amar i lanit ivavan veka namwear. ");
INSERT INTO frd_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Rtulis roak naꞌa nabi rira kitab ra ne, ‘Ubu veka nair tamata ra munuk.’ Tamata iki watan nrenar ovu ntorung afa ovi Yamang nair ra, na veka nma verin Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Inyai wol nfaturu ne, tamata boku rsiꞌik roak Yamang a. Naꞌuk Ia i ntali Ubu saꞌi nsiꞌik roak Ia. ");
INSERT INTO frd_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Afa i ufalak verin mia ini, kena urun! Tamata iki watan norang Yaꞌa, na ia veka ni vavaꞌat kakiwal. ");
INSERT INTO frd_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Yaꞌa ini afamtahan i nala vavaꞌat. ");
INSERT INTO frd_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ububir-nusibira ra raꞌan roak afamtahan i naran manna naꞌa wan lean vu dawan, naꞌuk rmata vali. ");
INSERT INTO frd_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Naꞌuk fiang ini, afamtahan i nsuta tali lanit ratan a, naꞌa roak wahabira ralan ra. Tamata iki watan naꞌan afamtahan ini, na ia veka wol nmata. ");
INSERT INTO frd_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Yaꞌa ini afamtahan i nsuta tali lanit ratan ma ala vavaꞌat verin tamata ra. Tamata iki watan naꞌan afamtahan ini, na ia veka ni vavaꞌat kakiwal. Afamtahan i veka ala yai, nala vavaꞌat verin tamata ra naꞌa lanit ivavan a. Afamtahan yai tenang a.” ");
INSERT INTO frd_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Naꞌut i tamata Yahudi rarenar afa ovi Yesus nfalak ra, na rsitaku ulurira naꞌa rira fikiran ra ma rfalak ne, “Wean inba ma tamata ini bisma nala tenan a ma taꞌan?” ");
INSERT INTO frd_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ba Yesus nfalak verin ira ne, “Afa i ufalak verin mia ini, kena urun! Ba wean i wol mian Tamata Yanan tenan a, ovu wol myenu laran a, na veka wol bira vavaꞌat kakiwal. ");
INSERT INTO frd_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Tamata iki watan naꞌan tenang a ovu nenu larang a, na ia veka ni vavaꞌat kakiwal. Yaꞌa veka ufavaꞌat ewal ia tali matmatan naꞌa amar i lanit ivavan veka namwear, ");
INSERT INTO frd_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","tevek tenang a ovu larang a inyai fanaꞌan-fanenu mngaꞌun a. ");
INSERT INTO frd_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Tamata iki watan naꞌan tenang a ovu nenu larang a, na ia ni vavaꞌat isa roak ovu Yaꞌa, ovu vali Yaꞌa Ning vavaꞌat isa roak ovu ia. ");
INSERT INTO frd_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Yamang i nvaꞌat a nsinir Yaꞌa ma uma, ovu Ning vavaꞌat ntali Ia. Wean vali inyai verin tamata ra. Tamata iki watan naꞌan tenang a, na veka ala vavaꞌat verin Ia. ");
INSERT INTO frd_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Yaꞌa ini afamtahan i ntali lanit ratan. Afamtahan ini wol wean afamtahan i ububir-nusibira raꞌan a. Velik ne raꞌan roak afamtahan yai, naꞌuk rmata watan. Naꞌuk tamata iki watan naꞌan afamtahan ini, na ia veka nvaꞌat, nata ti wol ni wahan.” ");
INSERT INTO frd_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesus nfalak munuk afa avyai naꞌut i nsiair naꞌa tamata Yahudi rira rahan falurut i naꞌa Kapernaum. ");
INSERT INTO frd_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ti ma rarenar munuk roak afa ovi Yesus nair ra, na tamata rivun ovi rorang Ia rfalak ne, “Vaivatul ovi nala ma al nsiair ra aleman urun. Iki bisma nfan-aran vaivatul ovi?” ");
INSERT INTO frd_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Tamata ra wol rfalak verin Yesus, naꞌuk nkaꞌa lahir ne, Ni tamata ovi rorang Ia rafngamuꞌur naꞌa afa ovi nfalak ra, ba nfalak verin ira ne, “Betane Ning vaivatul ra rotu ma ralabira raruan naꞌa bira inorang a? ");
INSERT INTO frd_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ufalak watan wean inyai, na ralabira raruan roak, ba wean inba vali wean i msyiꞌik Yaꞌa, Tamata Yanan a, urata ewal wan i unaꞌa lan a? ");
INSERT INTO frd_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ubu Ni Roh nala vavaꞌat verin tamata ra. Tamata rira ngrebat ra wol rot-nala ma rira vavaꞌat a. Vaivatul ovi ufalak roak verin mia ini, rtali Ubu Ni Roh ovu rala vavaꞌat verin mia. ");
INSERT INTO frd_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Naꞌuk boku tali mia wol myorang Yaꞌa.” Yesus nfalak wean inyai, tevek naꞌut i beti nfabana Ni karya a, na nkaꞌa roak ne, tamata aba rafena ma rorang Ia, ovu tamata iki veka nfedi Ia verin tamata ovi wol inar lahir Ia. ");
INSERT INTO frd_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ba Yesus nfalak ewal verin ira ne, “Ufalak roak verin mia ne, wol tamata isa vali bisma nma verin Yaꞌa, wean i Yamang wol notu ma nma verin Yaꞌa.” ");
INSERT INTO frd_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Naꞌut inyai, tali tamata ovi rorang Ia, na rivun ira rti talik Ia ovu rafena roak ma rorang Ia. ");
INSERT INTO frd_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ba Yesus nfalak verin Ni tamata vutu rahin irua ovi rorang Ia ne, “Betane mia mane miti talik vali Yaꞌa?” ");
INSERT INTO frd_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simon Petrus nfalak ne, “Duilaꞌa, ami veka amorang iki vali? Mu vaivatul ra rala vavaꞌat kakiwal verin ami. ");
INSERT INTO frd_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ami amorang roak Oa. Amkaꞌa lahir ne, Oa ini Ubu Ni sansinir a, ovu Mu vavaꞌat a nmerat urun.” ");
INSERT INTO frd_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yesus nfalak verin ira ne, “Yaꞌa kaꞌi ufili roak mia tamata vutu rahin irua ini, naꞌuk tamata isa tali mia veka norang watan nitdawan ni ininan a.” ");
INSERT INTO frd_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Tamata i Yesus nfalak yai, inyai Yudas i yaman verin Simon Iskariot. Velik ne ntali Yesus Ni tamata vutu rahin irua ovi rorang Ia, naꞌuk veka nfedi Yesus. ");
INSERT INTO frd_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Yesus notu munuk afa avyai, na Ia nti ma nban-lilit wan ovi rnaꞌa propinsi Galilea. Ia nafena ma nti propinsi Yudea, tevek dawan Yahudi ra rdava lingaꞌan mane rfedan Ia. ");
INSERT INTO frd_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Naꞌut inyai, na Yahudi rira amar dawan sarseri roak ma rotu snoba. Naꞌa snoba yai, na ira rotu rira befak ra ma rnaꞌa. ");
INSERT INTO frd_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Yesus warin ra rfalak verin Ia ne, “Bwan-talik wan ini ma muti Yudea, boma tamata rivun ovi rorang Oa rsiꞌik vali afa ovi motu ra. ");
INSERT INTO frd_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Wean i tamata isa inan ma tamata rivun rkaꞌa ia, na ia wol nfonak afa ovi notu ra. Wean i motu mujizat ra, na muti ma fwaturu afa avyai verin tamata ra munuk naꞌa lanit ivavan a.” ");
INSERT INTO frd_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Yesus warin ra rfalak wean inyai, tevek ira vali wol rorang Ia. ");
INSERT INTO frd_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ba Yesus nfalak verin ira ne, “Wol naran Ning amar a obin, naꞌuk mia bisma miti naꞌut inba watan. ");
INSERT INTO frd_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Tamata ovi rnaꞌa lanit ivavan a inar watan mia, naꞌuk wol inar lahir Yaꞌa, tevek ufalak ne, afa ovi rotu ra sian. ");
INSERT INTO frd_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Mia miti aꞌuk snoba yai. Yaꞌa wol uti, tevek Ning amar a wol naran obin.” ");
INSERT INTO frd_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Yesus nfalak wean inyai verin ira, ovu naꞌut inyai, na Ia nanaꞌa Galilea. ");
INSERT INTO frd_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ti ma Yesus warin ra rti roak snoba yai, beti Ia nti vali, naꞌuk nti fanfonak watan Ia, boma tamata ra deka rkaꞌa. ");
INSERT INTO frd_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Dawan Yahudi ra rdava Ia naꞌa snoba yai, ovu rorat tamata ovi rnaꞌa inyai ne, “Tamata yai nanaꞌa inba?” ");
INSERT INTO frd_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Tamata rivun rfamalik Yesus, naꞌuk vairira kakoꞌu watan. Boku rfalak ne, “Ia tamata lolin Ia,” na boku vali rfalak ne, “Wahal, Ia nlabir nala tamata rivun.” ");
INSERT INTO frd_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Naꞌuk wol tamata isa vali nabrahi ma nfamalik Yesus naꞌa tamata rivun waharira ralan ra, tevek rbobar dawan Yahudi ra. ");
INSERT INTO frd_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Naꞌut i snoba yai nbana ma nfafruang roak, na Yesus nti Yahudi rira Rahan Dawan Falurut ni lean a ma nair tamata ra naꞌa inyai. ");
INSERT INTO frd_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Dawan Yahudi ra rtalkaka urun ma rfalak ne, “Wean inba ma tamata ini bisma nkaꞌa lahir ma wean ini, velik ne tamata ra wol rair Ia?” ");
INSERT INTO frd_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yesus nfalak verin ira ne, “Afa ovi air ra wol rtali Yaꞌa, naꞌuk rtali Ia i nsinir roak Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Tamata iki watan inan ma not-orang afa ovi Ubu ralan nfalak a, na ia veka nkaꞌa ne, afa ovi air ra rtali Ubu, te Yaꞌa kaꞌi ufalak watan. ");
INSERT INTO frd_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Tamata iki watan wean i kaꞌi nfamalik afa ovi rtali watan ni fikiran a, na ia kaꞌi ndava mane tamata ra ralang ia. Naꞌuk iki watan inan ma tamata ra ralang Ubu i nsinir ia, na ia nfalak watan afa ovi kena ra ovu wol nsiklabir. ");
INSERT INTO frd_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Musa nala roak ni inukun ra verin mia, naꞌuk wol tamata isa tali mia not-orang inukun avyai. Afakinimi mdyava lingaꞌan mane fyedan Yaꞌa?” ");
INSERT INTO frd_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Tamata rivun avyai rfalak ne, “Nait sian nleal roak Oa! Iki ndava lingaꞌan mane nfedan Oa?” ");
INSERT INTO frd_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesus nfalak verin ira ne, “Yaꞌa otu mujizat isa watan naꞌa amar i tyari ita, ma bir tinemun mtyalkaka lahir. ");
INSERT INTO frd_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Naꞌuk mia mkyarya vali naꞌut i msyunat tamata ra naꞌa amar i tyari ita. Musa ntulis naꞌa ni inukun ra ma rsunat mia, naꞌuk velik aba sunat yai wol ntali Musa. Sunat yai ntali ubud-nusid ra. ");
INSERT INTO frd_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ba wean i msyunat tamata isa naꞌa amar i tyari ita, boma myot-orang Musa ni inukun ra, na afakinimi mingrova Yaꞌa, tevek otu ma tamata isa lolin ia naꞌa amar i tyari ita? ");
INSERT INTO frd_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Deka sngaꞌut ma fyaleka inukun verin tamata ra tali afa ovi msyiꞌik ra, naꞌuk fyaleka inukun verin ira ovu ni malolan a.” ");
INSERT INTO frd_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Tamata Yerusalem boku rfalak ne, “Beta ne, ini tamata i dawan Yahudi ra rdava mane rfedan Ia? ");
INSERT INTO frd_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Eka msyiꞌik, Ia nangrihi naꞌa tamata rivun waharira ralan ra, naꞌuk dawan Yahudi avyai wol rfalak akataka verin Ia. Betane dida dawan ra rkaꞌa roak ne, Ia ini Raja i ntevut dida salasilan ra? ");
INSERT INTO frd_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Naꞌuk tamata ini, ita tkaꞌa roak ne, Ia ntali inba. Naꞌuk wean i Raja i ntevut dida salasilan ra nma, na wol tamata isa vali nkaꞌa ne, Ia ntali inba.” ");
INSERT INTO frd_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Naꞌut i Yesus nsiair naꞌa Yahudi rira Rahan Dawan Falurut obin, na Ia vain dawan ma nfalak ne, “Mia mkyaꞌa Yaꞌa, ovu mkyaꞌa vali ne utali inba. Yaꞌa wol kaꞌi usinir Yaꞌa ma uma, naꞌuk Ia nsinir Yaꞌa ma uma. Afa ovi nfalak ra kena lalawatan, naꞌuk mia wol mkyaꞌa Ia. ");
INSERT INTO frd_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Yaꞌa ukaꞌa Ia, tevek utali Ia ovu nsinir Yaꞌa ma uma.” ");
INSERT INTO frd_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Naꞌut inyai, na tamata ra rdava lingaꞌan mane rtaha Yesus, naꞌuk wol tamata isa vali nkena Ia, tevek wol naran Ni amar a obin. ");
INSERT INTO frd_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Naꞌuk tali tamata rivun ovi rnaꞌa inyai, na tamata rivun rorang Ia ma rfalak ne, “Ia ini Raja i ntevut dida salasilan ra, tevek wol tamata isa vali bisma notu mujizat nlia tali mujizat ovi notu ra.” ");
INSERT INTO frd_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Tamata Yahudi ovi rtali sidovung Farisi rarenar roak afa ovi tamata rivun avyai rfamalik ovu vairira kakoꞌu watan, naꞌa Yesus. Ba irmunuk Yahudi rira dawan mela falurut ra rsinir tamata ovi rwanar Yahudi rira Rahan Dawan Falurut ma ti rtaha Yesus. ");
INSERT INTO frd_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yesus nfalak ne, “Ning amar a wol mnanat roak ma unaꞌa ovu mia. Yaꞌa veka ewal Yaꞌa uti verin Ia i nsinir Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Mia veka mdyava Yaꞌa, naꞌuk wol mtyuan Yaꞌa, tevek wol bisma miti wan i veka unaꞌa.” ");
INSERT INTO frd_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Dawan Yahudi avyai kaꞌi rsifalak afa verin ira ne, “Ia veka nti ba, ma ita wol bisma tatuan Ia? Beta ne Ia mane nti nuhu mavu ma ntuan tamata Yahudi ovi rebang tamata ovi wol Yahudi ra, ma nair tamata ovi wol Yahudi ra? ");
INSERT INTO frd_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Afakinimi Ia nfalak ne, ‘Mia veka mdyava Yaꞌa, naꞌuk wol bisma mtyuan Yaꞌa, ovu wol bisma miti wan i veka unaꞌa?’ ” ");
INSERT INTO frd_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Amar i nban-muri lalean naꞌa snoba yai penting lia amar liak ra naꞌa snoba yai. Naꞌa amar yai, na Yesus ndiri, beti vain dawan ma nfalak ne, “Tamata iki watan nabroa, na nma ma ala wear ma nenu! ");
INSERT INTO frd_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Rtulis roak naꞌa Surat Ralan ne, tamata iki watan wean i norang Yaꞌa, na wear matan i nala vavaꞌat verin tamata ra, veka nava naꞌa ralan a.” ");
INSERT INTO frd_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yesus nfalak wean inyai ma nfalyawang ne, Ubu veka nala Ni Roh verin tamata ovi rorang Yesus. Naꞌut inyai, na Ubu wol nala Ni Roh verin tamata inorang ra obin, tevek Ia wol nfadawang Yesus obin. ");
INSERT INTO frd_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Tamata rivun rarenar afa ovi Yesus nfalak ra, ma boku rfalak ne, “Kena urun! Ia ini nabi i Ubu ntorung roak ma nma lanit ivavan a.” ");
INSERT INTO frd_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Tamata boku vali rfalak ne, “Ia Raja i ntevut dida salasilan ra!” Naꞌuk boku vali rfalak ne, “Wahal, Raja i ntevut dida salasilan ra wol ntali Galilea! ");
INSERT INTO frd_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Rtulis roak naꞌa Surat Ralan ne, Raja i ntevut dida salasilan ra ubun-nusin Raja Daud, ovu ntali Daud ni ahu a naran Betlehem.” ");
INSERT INTO frd_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ba tamata rivun avyai rsitaku ulurira naꞌa rira fikiran ra naꞌa Yesus. ");
INSERT INTO frd_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Tamata boku mane rtaha Ia, naꞌuk wol tamata isa vali nkena Ia. ");
INSERT INTO frd_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Tamata ovi rwanar Yahudi rira Rahan Dawan Falurut rewal ira ma ti rtuan Yahudi rira dawan mela falurut ra ovu tamata Farisi ra, ma rorat Yahudi rira dawan avyai ovu tamata Farisi ra ne, “Afakinimi wol mtyaha Ia mya ini?” ");
INSERT INTO frd_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ira rfalak ne, “Ita wol trenar obin ne, tamata ra bisma rangrihi nala wean tamata eri.” ");
INSERT INTO frd_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Tamata Farisi avyai rfalak ne, “Beta ne Ia nlabir nala roak mia vali? ");
INSERT INTO frd_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Mia mryenar ne, tamata isa tali dawan Yahudi ra te tamata Farisi ra rorang Ia? ");
INSERT INTO frd_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Naꞌuk tamata rivun ovi wol rkaꞌa Musa ni inukun ra, fara Ubu near nfasoba ira!” ");
INSERT INTO frd_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Tamata isa tali tamata Farisi avyai naran Nikodemus ntuan lan roak Yesus. Ia nfalak verin ira ne, ");
INSERT INTO frd_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Naꞌa Musa ni inukun ra, na wol bisma tukun tamata isa obin, wean i wol trenar afa ovi nfalak ra, ma tkaꞌa afa ovi notu ra.” ");
INSERT INTO frd_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ira rfalak verin ia ne, “Beta ne oa mtali vali Galilea? Bwas ma lolin Surat Ralan a, na veka mkaꞌa ne, wol nabi isa ntali Galilea!” ");
INSERT INTO frd_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Nata, lokat ira rewal ira rti rira rahan ra. ");
INSERT INTO frd_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Naꞌuk Yesus nti vuar Zaitun. ");
INSERT INTO frd_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Varverak sumatan, na Ia nti ewal Yahudi rira Rahan Dawan Falurut, na tamata rivun rma ma rtuan Ia. Ia ndoku ma nair ira. ");
INSERT INTO frd_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Naꞌut inyai, na Yahudi rira dawan ovi rair Ubu Ni inukun ra ovu tamata Yahudi ovi rtali sidovung Farisi rovun vata i nsifa roak ti verin Ia. Tamata ra rtaha nala lahir vata yai naꞌut i ntuba ovu tamata i wol awan verin ia. Ira rsinir ia ma ndiri tamata rivun avyai fruarira ra. ");
INSERT INTO frd_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ba rfalak verin Yesus ne, “Tuan Guru, amtaha nala lahir vata ini naꞌut i ntuba ovu brana i wol awan verin ia. ");
INSERT INTO frd_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Musa ni inukun ra rfalak ne, vata i notu wean inyai, musti tala vatu ma al tatev-fedan ia. Ba Bapa munovak wean inba naꞌa afa ini?” ");
INSERT INTO frd_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ira rfalak wean inyai ma al rlabir teman Ia, boma bisma rfasala Ia. Naꞌuk Yesus ntoak Ia ma ntulis ovu liman tanan a naꞌa lanun. ");
INSERT INTO frd_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ira rkiwal ma rorat Ia, ba ndiri ma nfalak verin ira ne, “Tamata iki watan tali mia, wean i wol ni salasilan lahir, na ula ia ma nala vatu al nteva vata ini.” ");
INSERT INTO frd_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Yesus ntoak ewal vali Ia ma ntulis naꞌa lanun. ");
INSERT INTO frd_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Naꞌuk ti ma rarenar afa i Yesus nfalak a, na rti talik wan yai. Tamata ovi tuvu roak ira rti ula ira, beti tuvmarmuri ra, ma teran aꞌuk Yesus ovu vata yai rnaꞌa wan yai. ");
INSERT INTO frd_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Nata Yesus ndiri lahir ma nfalak verin vata yai ne, “Titi, tamata avyai rti ba roak? Wol tamata isa vali nukun oa?” ");
INSERT INTO frd_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Vata yai nfalak ne, “Duilaꞌa, wol tamata rukun yaꞌa.” Ba Yesus nfalak ne, “Yaꞌa vali wol ukun oa. Ba mewal oa, ovu tali amar ini, na deka motu salasilan kikyai.” ");
INSERT INTO frd_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yesus nangrihi ewal verin tamata rivun avyai ma nfalak ne, “Yaꞌa ini lyawan a verin tamata ra naꞌa lanit ivavan a. Tamata iki watan norang Yaꞌa, na ia veka wol nbana naꞌa dedan ralan, naꞌuk ia veka ni lyawan i nala vavaꞌat verin tamata ra.” ");
INSERT INTO frd_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Tamata Farisi avyai rfalak verin Ia ne, “Oa kaꞌi fwamalik watan Oa, ba Mu afa ovi fwalak ra wol kena.” ");
INSERT INTO frd_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesus nfalak verin ira ne, “Velik ne kaꞌi ufamalik watan Yaꞌa, naꞌuk Ning afa ovi ufalak ra kena. Tevek Yaꞌa ukaꞌa ne, utali inba ovu veka uti inba, naꞌuk mia wol mkyaꞌa ne, utali inba ovu veka uti inba. ");
INSERT INTO frd_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Mia fyaleka inukun verin tamata ra ovu adat ovi tamata ra baꞌi rala al rfaleka inukun verin tamata liak ra. Yaꞌa wol ufaleka inukun verin tamata isa vali. ");
INSERT INTO frd_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Naꞌuk wean i ufaleka inukun verin tamata ra, na otu ovu ni malolan a, tevek wol aksa Yaꞌa ufaleka inukun verin ira, naꞌuk Ia i nsinir Yaꞌa novu vali naꞌut i ufaleka inukun verin tamata ra. ");
INSERT INTO frd_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Naꞌa bira inukun ra rtulis ne, wean i tamata irua rira afa ovi rfalak ra wearira isa, na rira afa ovi rfalak avyai kena. ");
INSERT INTO frd_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Yaꞌa kaꞌi ufamalik Yaꞌa, ovu Yamang i nsinir Yaꞌa nfamalik vali Yaꞌa.” ");
INSERT INTO frd_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ba ira rfalak verin Ia ne, “Yamam a nanaꞌa ba?” Yesus nfalak ne, “Mia wol mkyaꞌa Yaꞌa ovu vali wol mkyaꞌa Yamang a. Wean i mkyaꞌa Yaꞌa, na mia veka mkyaꞌa vali Yamang a.” ");
INSERT INTO frd_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesus nfalak afa avyai munuk naꞌut i nsiair naꞌa Yahudi rira Rahan Dawan Falurut ni lean a, nebang wan i tamata ra rfadoku rira persembahan ra naꞌa. Naꞌuk wol tamata isa vali ntaha Ia, tevek wol naran Ni amar a obin. ");
INSERT INTO frd_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesus nfalak ewal verin tamata rivun avyai ne, “Yaꞌa veka uti verin Yamang a ovu mia veka mdyava Yaꞌa, naꞌuk mia wol bisma miti wan i uti a, ovu veka myata naꞌa bira salasilan ra.” ");
INSERT INTO frd_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Dawan Yahudi avyai rfalak ne, “Beta ne Ia mane nfedan tenan a, bi nfalak ne, ‘Naꞌa wan i uti a, mia wol bisma miti.’ ” ");
INSERT INTO frd_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ba Yesus nfalak verin ira ne, “Mia mtyali fun ini, naꞌuk Yaꞌa utali ratan. Mia mtyali lanit ivavan ini, naꞌuk Yaꞌa wol utali lanit ivavan ini. ");
INSERT INTO frd_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Wean inyai, bi inlangin a ufalak verin mia ne, mia veka myata naꞌa bira salasilan ra. Wean i wol myorang ne, Yaꞌa ini tamata i ufalak roak yai, na mia veka myata naꞌa bira salasilan ra.” ");
INSERT INTO frd_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ba rorat Ia ne, “Oa ini iki mngaꞌun?” Yesus nfalak verin ira ne, “Yaꞌa ufamalik lan roak verin mia ne, Yaꞌa ini iki! ");
INSERT INTO frd_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Yaꞌa mane ufalak afa rivun verin mia, ovu ufaleka inukun verin mia. Naꞌuk Ia i nsinir Yaꞌa Ni afa ovi nfalak ra kena lalawatan. Yaꞌa ufamalik afa ovi urenar tali Ia verin tamata ra naꞌa lanit ivavan a.” ");
INSERT INTO frd_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ira wol rfan-aran ne, Yesus nfamalik Yaman a verin ira. ");
INSERT INTO frd_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Wean inyai, bi Yesus nfalak ne, “Wean i fyasaka Yaꞌa, Tamata Yanan Yaꞌa, beti mkyaꞌa ne, Yaꞌa ini tamata i ufalak roak yai, ovu mkyaꞌa vali ne, afa ovi otu ra wol mane rtali watan Yaꞌa. Naꞌuk ufamalik watan afa ovi Yamang a nair roak verin Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ia i nsinir Yaꞌa nfatuang lalawatan Yaꞌa. Ia wol nsiꞌik watan ma aksa Yaꞌa, tevek otu lalawatan afa ovi rotu ma ralan lolin.” ");
INSERT INTO frd_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ti ma Yesus nangrihi munuk roak wean inyai, na tamata rivun rorang Ia. ");
INSERT INTO frd_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ba Yesus nfalak verin tamata Yahudi ovi rorang Ia ne, “Wean i myot-orang lalawatan afa ovi ufalak ra, na mia myeluk Ning tamata mngaꞌun ovi rorang Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Mia veka mkyaꞌa afa ovi kena ra, ba afa avyai veka rfatalik mia.” ");
INSERT INTO frd_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ira rfalak verin Ia ne, “Abraham ubun-nusin ami, ovu wol fasa vali obin ameluk tamata sansinir. Afakinimi fwalak ne, veka rfatalik ami?” ");
INSERT INTO frd_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesus nfalak verin ira ne, “Afa i ufalak verin mia ini, kena urun! Tamata iki watan notu salasilan, na inyai nfaturu ne, salasilan nfareta roak ia, wean tamata isa nfareta ni sansinir. ");
INSERT INTO frd_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Tamata sansinir isa wol nanaꞌa lalawatan rahan teta isa, naꞌuk tamata i rarali ia tali rahan teta yai, nanaꞌa lalawatan rahan yai. ");
INSERT INTO frd_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ba wean i Ubu Yanan a nfatalik mia tali bira salasilan ra, na kena urun ne, afa ovi lan rfareta mia, wol rfaret-nala roak mia. ");
INSERT INTO frd_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Yaꞌa ukaꞌa ne, Abraham ubun-nusin mia, naꞌuk mia mdyava lingaꞌan mane fyedan Yaꞌa, tevek mifena ma mtyorung Ning vaivatul ra. ");
INSERT INTO frd_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Yaꞌa ufamalik afa ovi Yamang nfaturu roak verin Yaꞌa. Naꞌuk mia myot-orang watan afa ovi mryenar tali yamabira a.” ");
INSERT INTO frd_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ira rfalak verin Ia ne, “Ami yamamami verin Abraham.” Yesus nfalak verin ira ne, “Wean i mia yamabira verin Abraham, na bira afa ovi myotu ra veka wean lahir ia. ");
INSERT INTO frd_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Yaꞌa ufamalik afa kena ovi urenar tali Ubu, naꞌuk mia mdyava lingaꞌan mane fyedan Yaꞌa. Abraham wol notu wean inyai. ");
INSERT INTO frd_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Mia myot-orang watan afa ovi yamabira notu a.” Ira rfalak ne, “Tamata ovi rtuba ovu tamata ovi wol awarira verin ira wol yanarira ami! Ubu aꞌuk saꞌi neluk Yamamami.” ");
INSERT INTO frd_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesus nfalak verin ira ne, “Wean i Yamabira verin Ubu, na mia veka mlyobang urun Yaꞌa, tevek utali Ia uma lanit ivavan a. Yaꞌa wol kaꞌi usinir Yaꞌa ma uma, naꞌuk Ia nsinir Yaꞌa ma uma ini. ");
INSERT INTO frd_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Afakinimi wol fyan-aran afa ovi ufalak ra? Mia wol fyan-aran, tevek mifena ma mryenar Ning vaivatul ra. ");
INSERT INTO frd_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Yamabira verin nitdawan a, ovu inabira ma myot-orang watan ni ininan ra. Tali lalan a, nitdawan nsifedan lalawatan, ovu ni vavaꞌat wol nanaꞌa afa ovi kena ra, tevek nafena lahir ma notu afa ovi kena ra. Wean i nsiklabir, na notu watan afa ovi ralan nfalak a, tevek ia baꞌi nsiklabir, ovu afa siklabir ra munuk rtali ia. ");
INSERT INTO frd_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ba mia wol myorang Yaꞌa, tevek ufalak afa ovi kena ra. ");
INSERT INTO frd_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Tamata iki tali mia bisma nfaturu ne, otu salasilan? Wean i ufalak afa ovi kena ra, na afakinimi wol myorang Yaꞌa? ");
INSERT INTO frd_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Tamata iki watan ntali Ubu, na ia nrenar Ubu Ni vaivatul ra. Naꞌuk mia wol mtyali Ubu, ba mifena ma mryenar Ni afa ovi nfalak ra.” ");
INSERT INTO frd_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Tamata Yahudi avyai rfalak verin Yesus ne, “Kena ami, wean i amfalak ne, tamata Samaria Oa, ovu nait sian nleal Oa!” ");
INSERT INTO frd_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesus nfalak ne, “Nait sian wol nleal Yaꞌa. Yaꞌa alang Yamang a, naꞌuk mia fyalak sian Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Yaꞌa wol udava ma tamata ra rfadawang Yaꞌa. Naꞌuk Ubu inan ma tamata ra ralang Yaꞌa, ovu Ia i nfaleka inukun verin tamata ra. ");
INSERT INTO frd_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Afa i ufalak verin mia ini, kena urun! Tamata iki watan not-orang Ning vaivatul ra, na ia veka wol nmata kakiwal.” ");
INSERT INTO frd_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Tamata Yahudi avyai rfalak verin Ia ne, “Fiang ini amkaꞌa roak ne, nait sian nleal Oa. Tevek Abraham nmata roak ovu nabi ra rmata vali roak, naꞌuk Oa fwalak ne, tamata iki watan not-orang Mu vaivatul ra, na ia veka wol nmata kakiwal. ");
INSERT INTO frd_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Abraham nmata roak ovu nabi ra rmata vali roak, na Oa ini iki? Oa fwikir ne, Mu dawan nlia yamamami Abraham?” ");
INSERT INTO frd_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesus nfalak ne, “Wean i Yaꞌa kaꞌi ufadawang tenang a, na afa yai wol ihin akataka. Naꞌuk Yamang i fyalak ne, neluk Ubu verin mia, kaꞌi nfadawang Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Velik ne mia wol mkyaꞌa Ia, naꞌuk Yaꞌa ukaꞌa Ia. Wean i ufalak ne, wol ukaꞌa Ia, na Yaꞌa usiklabir roak wean mia. Naꞌuk ukaꞌa Ia, ovu ot-orang Ni vaivatul ra. ");
INSERT INTO frd_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Yamabira Abraham ralan lolin urun, tevek ia veka nsiꞌik Ning amar i uma a. Ia nsiꞌik roak amar yai, ba ralan lolin urun.” ");
INSERT INTO frd_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ba tamata Yahudi avyai rfalak verin Yesus ne, “Oa wol Mu varat vutlima obin, na wean inba ma fwalak ne, mrea roak Abraham?” ");
INSERT INTO frd_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesus nfalak verin ira ne, “Afa i ufalak verin mia ini, kena urun! Wol rarali Abraham obin, na Yaꞌa unaꞌa roak.” ");
INSERT INTO frd_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ba ira rala vatu ma al rteva Yesus, naꞌuk Ia kaꞌi nfonak tenan a ma nban-talik Yahudi rira Rahan Dawan Falurut ni lean yai. ");
INSERT INTO frd_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Naꞌut i Yesus nbana, na nsiꞌik tamata kibu isa. Tamata yai nkibu naꞌut i rarali ia. ");
INSERT INTO frd_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Yesus Ni tamata ovi rorang Ia rorat ne, “Tuan Guru, afakinimi tamata ini rarali ia, na nkibu roak? Ia nkibu tevek ni salasilan ra, te renan-yaman rira salasilan ra?” ");
INSERT INTO frd_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesus nfalak ne, “Ia nkibu wol ntali ni salasilan ra te ntali renan-yaman rira salasilan ra, naꞌuk musti wean inyai, boma tamata ra bisma rsiꞌik Ubu Ni ngrebat i nfaturu naꞌa tamata yai. ");
INSERT INTO frd_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Naꞌut amar obin, na ita musti tfabana Ia i nsinir Yaꞌa Ni karya ra, tevek wean i ovan roak, na wol tamata isa vali bisma nkarya. ");
INSERT INTO frd_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Naꞌut i unaꞌa lanit ivavan obin, na Yaꞌa ini lyawan verin tamata ra naꞌa lanit ivavan a.” ");
INSERT INTO frd_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ia nfalak munuk wean inyai, na nafnit naꞌa lanun, beti nsileti beran a ovu lanun ma naꞌung naꞌa tamata kibu yai matan a, ");
INSERT INTO frd_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ma nfalak verin ia ne, “Muti ma muflarut waham a naꞌa kolam Siloam.” Siloam ihin a ne, “Tamata i rsinir ia.” Ba tamata yai nti ma naflarut wahan a, ma nsirea roak, ma newal ia nti ni rahan a. ");
INSERT INTO frd_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Naꞌuk tamata ovi rkaꞌa roak ne, ia baꞌi ndoku lingaꞌan nelan ma nera afa tali tamata ra, ovu tamata ovi rnaꞌa ni rahan nelan a rfalak ne, “Betane ini tamata i baꞌi ndoku lingaꞌan nelan ma nera afa tali tamata ra?” ");
INSERT INTO frd_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Tamata boku rfalak ne, “Kena urun, inyai ia.” Boku vali rfalak ne, “Wahal, ia felan a wean watan tamata yai.” Naꞌuk tamata kibu yai nfalak ne, “Kena urun, yaꞌa ini tamata yai!” ");
INSERT INTO frd_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ba tamata avyai rorat ia ne, “Wean inbinimi bisma msirea roak?” ");
INSERT INTO frd_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ia nfalak ne, “Tamata i naran Yesus nsileti beran a ovu lanun, beti naꞌung naꞌa matang ra ma nfalak ne, ‘Muti ma muflarut waham a naꞌa kolam Siloam.’ Ba uti ma uflarut munuk wahang a, na usirea lahir!” ");
INSERT INTO frd_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ba tamata avyai rorat ia ne, “Tamata yai naꞌa inba?” Ia nvalat ne, “Yaꞌa wol ukaꞌa.” ");
INSERT INTO frd_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ba tamata avyai rovun tamata i nkibu naꞌuk nsirea roak yai ti verin tamata Yahudi ovi rtali sidovung Farisi. ");
INSERT INTO frd_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Naꞌut i Yesus nsileti beran a ovu lanun ma notu ma lolin tamata yai matan a, na amar yai amar i Yahudi ra ryari ira. ");
INSERT INTO frd_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ba tamata Farisi avyai rorat vali ia ne, “Wean inbinimi msirea roak i?” Tamata yai nfalak ne, “Ia nsileti beran a ovu lanun ma naꞌung naꞌa matang ra, beti nsinir yaꞌa ma ti uflarut wahang a, na usirea lahir!” ");
INSERT INTO frd_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Tamata Farisi boku rfalak ne, “Tamata i notu ma lolin tamata ini matan a wol ntali Ubu, tevek wol nalang amar i tyari ita.” Naꞌuk tamata Farisi boku vali rfalak ne, “Wean inba ma tamata salasilan isa bisma not-nala mujizat i wean ini?” Ba rsitaku ulurira naꞌa rira fikiran ra. ");
INSERT INTO frd_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ira rorat ewal tamata yai ne, “Oa munovak aka naꞌa tamata yai, tevek notu roak ma matam ra lolin?” Ia nvalat ne, “Tamata yai nabi Ia.” ");
INSERT INTO frd_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Naꞌuk dawan Yahudi avyai rafena ma rorang ne, lan a tamata yai nkibu, naꞌuk fiang ini nsirea roak. Wean inyai bi rera tamata yai renan ovu yaman a, ");
INSERT INTO frd_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ma rorat ira ne, “Ini yanabira i fyalak ne, nkibu naꞌut i rarali ia? Wean inbinimi fiang ini bisma nsirea roak?” ");
INSERT INTO frd_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Tamata yai renan ovu yaman a rfalak ne, “Ami amkaꞌa ne, yanamami ia ovu nkibu roak naꞌut i rarali ia, ");
INSERT INTO frd_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","naꞌuk ami wol amkaꞌa ne, wean inbinimi fiang ini nsirea roak. Ami wol amkaꞌa vali ne, tamata iki notu ma nsirea roak. Myorat watan ia, tevek dawan roak ia, ba bisma kaꞌi nfamalik lahir.” ");
INSERT INTO frd_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Tamata yai renan ovu yaman a rfalak wean inyai, tevek rbobar dawan Yahudi avyai. Ira ralarira isa roak ne, tamata iki watan ntorung ne, Yesus yai Raja i ntevut tamata rira salasilan ra, na ia wol bisma nti Yahudi rira rahan falurut ralan a. ");
INSERT INTO frd_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Wean inyai bi, tamata yai renan ovu yaman a rfalak ne, “Myorat watan ia, tevek dawan roak ia.” ");
INSERT INTO frd_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ba tamata Yahudi avyai rera ewal tamata i lan a nkibu naꞌuk nsirea roak yai, ma rfalak verin ia ne, “Mala lahir Ubu Naran a al mufwaba ne, afa i fwalak a kena urun. Ami amkaꞌa ne, tamata yai tamata salasilan Ia.” ");
INSERT INTO frd_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ia nvalat ne, “Yaꞌa wol ukaꞌa ne, tamata yai tamata salasilan Ia te wahal. Naꞌuk ukaꞌa afa isa watan ne, lan a matang ra rkibu, naꞌuk fiang ini usirea roak.” ");
INSERT INTO frd_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ba rorat ewal ia ne, “Ia notu afaka verin oa? Ia notu wean inba ma msirea roak?” ");
INSERT INTO frd_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ia nfalak ne, “Ufalak munuk roak verin mia, naꞌuk mifena ma mryenar. Afakinimi myorat ewal? Betane mia vali mane myeluk Ni tamata ovi rorang Ia?” ");
INSERT INTO frd_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ira rfalak sian ia ma rfalak ne, “Oa morang Ia, naꞌuk ami wahal, tevek ami amorang Musa. ");
INSERT INTO frd_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ami amkaꞌa ne, Ubu nangrihi roak verin Musa, naꞌuk wol amkaꞌa ne, tamata yai ntali inba.” ");
INSERT INTO frd_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Tamata kibu yai nfalak ne, “Yaꞌa ubrian! Afakinimi wol mkyaꞌa ne, Ia ntali inba? Ia notu roak ma usirea. ");
INSERT INTO frd_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ita tkaꞌa ne, Ubu wol nvalat tamata salasilan rira falurut ra, naꞌuk Ia nvalat tamata ovi ralang Ia ovu rot-orang afa ovi ralan nfalak ra. ");
INSERT INTO frd_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Tali lalan a ma naran amar ini, na wol trenar obin ne, tamata ra bis rotu ma lolin tamata ovi rkibu naꞌut i rarali ira ma rsirea. ");
INSERT INTO frd_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Wean i tamata yai wol ntali Ubu, na wol not-nala afakataka.” ");
INSERT INTO frd_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ira rfalak ne, “Oa mu salasilan nngora roak naꞌut i beti rarali oa, na wean inba ma mair ami?” Ba ralaꞌing vatuk ia tali Yahudi rira rahan falurut a. ");
INSERT INTO frd_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesus nrenar ne, dawan Yahudi avyai ralaꞌing vatuk roak ia tali Yahudi rira rahan falurut a. Ba Yesus ti ntuan ia ma nfalak ne, “Oa morang Tamata Yanan a te wahal?” ");
INSERT INTO frd_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Tamata yai nfalak ne, “Bapa, mlobang ma fwalak verin yaꞌa ne, tamata yai iki Ia, boma orang Ia.” ");
INSERT INTO frd_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesus nfalak verin ia ne, “Oa msiꞌik roak Ia, ovu Ia fiang ini nangrihi lahir verin oa!” ");
INSERT INTO frd_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Tamata yai nfalak ne, “Duilaꞌa, yaꞌa orang Oa!” Ba nsangatur ma nraning Yesus. ");
INSERT INTO frd_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yesus nfalak ne, “Yaꞌa uma lanit ivavan a ma ufaleka inukun verin tamata ra. Otu wean inyai, boma tamata iki watan nkibu, veka nsirea, ovu vali iki watan nsirea, veka nkibu.” ");
INSERT INTO frd_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Tamata Farisi boku rnaꞌa vali inyai ma rarenar afa ovi Yesus nfalak ra, ba rorat Ia ne, “Ba ami amkibu vali?” ");
INSERT INTO frd_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesus nvalat ira ne, “Wean i matabira ra rkibu urun, na mia wol bira salasilan. Naꞌuk mia fyalak ne, matabira ra wol rkibu, ba bira salasilan obin.” ");
INSERT INTO frd_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesus nfalak ne, “Afa i ufalak verin mia ini kena urun! Tamata iki watan inan ma nti wan i domba ra rnaꞌa, ovu wol nahu wan yai ni falfolat a, naꞌuk nakbasal ni balbelat a ma nti ralan, na ia tamata i nwi-nwa tamata ra ma nbori rira metan ra, ovu tamata barborin ia. ");
INSERT INTO frd_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Naꞌuk tamata iki watan nti wan yai nahu ni falfolat a, na domba duan ia. ");
INSERT INTO frd_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Tamata i nwanar wan i domba ra rnaꞌa nvadil falfolat a verin domba duan a. Domba ra rarenar domba duan vain a, ovu nera lokat domba nararira ra ma novun ira ma rti murin. ");
INSERT INTO frd_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Wean i domba duan a novun munuk roak ni domba ra ma rti murin, na nbana ula ia, beti ni domba ra rorang ia, tevek ref-nala vain a. ");
INSERT INTO frd_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Naꞌuk wean i tamata liak nera ira, na veka wol rorang ia ovu rafla talik lahir ia, tevek wol ref-nala tamata yai vain a.” ");
INSERT INTO frd_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesus nfamalik vaivatul kamkuma ini verin ira, naꞌuk wol rfan-aran afa ovi nfalak ra. ");
INSERT INTO frd_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ba Yesus nfalak ewal ne, “Afa i ufalak verin mia ini kena urun! Yaꞌa ini wean falfolat i domba ra baꞌi rahu ma rti warira ra. ");
INSERT INTO frd_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Tamata ovi rma lan beti Yaꞌa, na ira munuk tamata ovi rwi-rwa tamata ra ma rbori rira metan ra, ovu tamata barborin ira. Wean inyai bi, domba ra wol rarenar ira. ");
INSERT INTO frd_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Yaꞌa ini wean falfolat a. Tamata iki watan nma ma ntuan Ubu nahu Yaꞌa, na Ubu veka nsikat ia tali ni salasilan ra, ma ni vavaꞌat kakiwal. Tamata yai veka nti ovu nma, nahu falfolat yai ma ntuan wan lean vu i ngrova lalawatan. ");
INSERT INTO frd_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Tamata barborin nma ma nbori, nfedan ovu vali nvisal domba ra. Naꞌuk Yaꞌa uma, boma tamata ra rira vavaꞌat, ovu vavaꞌat i lolin urun. ");
INSERT INTO frd_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Yaꞌa ini domba duan i lolin a. Domba duan i wean inyai, nmata verin ni domba ra. ");
INSERT INTO frd_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Naꞌuk tamata i rbahir ia ma nwanar domba ra, naꞌut i nsiꞌik serigala nma, na nafla talik domba ra, tevek wol ni domba avyai. Ba serigala veka ntaha lahir domba boku, na boku rafla ma ramir-ramar. ");
INSERT INTO frd_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ia nafla, tevek nkarya al ndava ma rbahir watan ia, ba wol nkamlabir domba ra. ");
INSERT INTO frd_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Yaꞌa ini domba duan i lolin a, ovu ukaꞌa Ning domba ra, ovu vali Ning domba ra rkaꞌa Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Wean lahir Yamang a nkaꞌa Yaꞌa, ovu ukaꞌa Yamang a, ovu vali umata verin Ning domba ra. ");
INSERT INTO frd_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Yaꞌa Ning domba liak boku vali, naꞌuk wol rasdovu ira obin ovu domba ovi rnaꞌa roak warira ini. Domba avyai musti ovun vali ira, ovu ira veka rarenar vaing a. Ira veka rasdovu ira naꞌa sidovung isa, ovu veka rira domba duan isa watan vali, inyai Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Yamang a nlobang Yaꞌa, tevek utorung ma umata, boma bisma uvaꞌat ewal. ");
INSERT INTO frd_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Wol tamata isa vali bisma nfedan Yaꞌa, naꞌuk Yaꞌa kaꞌi utorung watan ma umata. Yaꞌa Ning ngrebat ma ala tenang a ma tamata ra rfedan Yaꞌa. Yaꞌa Ning ngrebat vali ma uvaꞌat ewal. Yamang a kaꞌi nsinir Yaꞌa ma otu karya ini.” ");
INSERT INTO frd_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Yesus nfalak munuk wean inyai, na tamata Yahudi ra rsitaku ulurira naꞌa rira fikiran ra. ");
INSERT INTO frd_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Tamata rivun rfalak ne, “Nait sian a nleal roak Ia ma nfoar. Afakinimi mryenar Ia?” ");
INSERT INTO frd_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Naꞌuk tamata boku vali rfalak ne, “Afa ovi nfalak ra wol rtali nait sian a, tevek nait sian wol not-nala ma tamata i nkibu bisma nsirea!” ");
INSERT INTO frd_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Naꞌa Yerusalem, na tamata Yahudi ra rotu snoba ma al rangnanang amar i raresmi rira Rahan Dawan Falurut a. Naꞌut inyai, naꞌut radridin. ");
INSERT INTO frd_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yesus nbana watan nahu wan i rfanara ia ne, Salomo ni abelus a, naꞌa Yahudi rira Rahan Dawan Falurut a. ");
INSERT INTO frd_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Tamata Yahudi ra rma ma rdir-lilit Ia, ovu rfalak verin Ia ne, “Lafira ki fwavotuk verin ami ne, Oa ini iki mngaꞌun, boma ralamami ra deka raruan? Wean i Oa ini Raja i ntevut mami salasilan ra, na fwalak lahir verin ami.” ");
INSERT INTO frd_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ba Yesus nfalak verin ira ne, “Ufalak roak verin mia, naꞌuk mifena ma myorang. Yaꞌa otu mujizat ra ovu Yamang Ni ngrebat a, ovu mujizat avyai rfalyawang lahir ne, iki Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Mia wol myorang Yaꞌa, tevek wol Ning domba verin mia. ");
INSERT INTO frd_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ning domba ra rarenar vaing a, ovu ukaꞌa ira, ovu vali rorang Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Yaꞌa ala vavaꞌat kakiwal verin ira, ovu ira veka wol rmata, nata ti wol ni wahan. Wol tamata isa vali bisma nala ira tali limang ralan a. ");
INSERT INTO frd_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Yamang a nala munuk roak ira verin Yaꞌa. Ni dawan a nlia munuk afakataka. Wol tamata isa vali bisma nala ira tali Yamang liman ralan a. ");
INSERT INTO frd_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Yaꞌa ovu Yamang a, ikisa watan ami.” ");
INSERT INTO frd_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ba tamata Yahudi avyai ral-ewal vatu ma al rteva Yesus. ");
INSERT INTO frd_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Naꞌuk Yesus nfalak ne, “Mia msyiꞌik roak karya lolin ovi Yamang nsinir Yaꞌa ma otu ra. Tali afa ovi otu avyai munuk, na karya inbi notu ma mane mtyeva Yaꞌa?” ");
INSERT INTO frd_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ira rfalak ne, “Ami wol mane amteva Oa tevek motu karya ovi lolin ra, naꞌuk amteva Oa tevek fwalak sian Ubu. Velik aba, Oa ini tamata watan Oa, naꞌuk motu tenam a wean lahir Ubu.” ");
INSERT INTO frd_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yesus nfalak verin ira ne, “Rtulis roak naꞌa bira Buku Inukun ra wean ini, ‘Ubu nfalak roak ne, mia ubu mia.’ ");
INSERT INTO frd_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ita tkaꞌa ne, afa ovi rtulis roak naꞌa Surat Ralan a, tamata ra wol rkati nala. Ba wean i Ubu nera tamata ovi nala Ni vaivatul ra verin ira ne, ubu ira, na ");
INSERT INTO frd_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","afakinimi fyalak ne, ufalak sian Ubu, wean i ufalak ne, Ubu Yanan Yaꞌa? Ubu kaꞌi nfili Yaꞌa, beti nsinir ma uma lanit ivavan a. ");
INSERT INTO frd_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Wean i wol ufabana karya i Yamang a nala verin Yaꞌa, na deka myorang Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Naꞌuk wean i otu karya i Yamang a nala verin Yaꞌa, velik ne mifena ma myorang Yaꞌa, na fara myorang watan afa ovi otu ra. Myorang afa avyai, boma bisma mkyaꞌa ovu fyan-aran ne, Yamang nleal ralang a, ovu Yaꞌa uleal Yamang ralan a.” ");
INSERT INTO frd_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ira rdava lingaꞌan ewal mane rtaha Yesus, naꞌuk nti talik watan ira. ");
INSERT INTO frd_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Nata Yesus nti ewal oar Yordan ni lihir a ma nanaꞌa inyai. Lan a, Yohanes nbaptis tamata ra naꞌa wan yai. ");
INSERT INTO frd_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Tamata rivun rma ma rtuan Ia naꞌa inyai. Ira rfalak ne, “Yohanes wol notu mujizat isa vali, naꞌuk afa ovi nfalak munuk roak naꞌa tamata ini, kena munuk lahir.” ");
INSERT INTO frd_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ba tamata rivun ovi rnaꞌa inyai rorang Yesus. ");
INSERT INTO frd_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Brana isa naran Lazarus, ovu uran irua nararira Maria ovu Marta. Ira rleal ahu Betania. Lan a, Maria ini nliꞌi ngul i voan lolin urun naꞌa Duilaꞌa ean a, ovu nala ni vut ma al naꞌi. Amar isa, na uran i Lazarus nawar ia. ");
INSERT INTO frd_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Lazarus uran irua yai rsinir tamata isa ma ti nfaivar verin Yesus ne, “Duilaꞌa, uramami i mlobang ia yai, nawar ia.” ");
INSERT INTO frd_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ti ma Yesus nrenar ivar yai, na nfalak ne, “Suhut yai veka wol notu ma nmata. Naꞌuk musti wean inyai, boma nfaturu Ubu Ni dawan a, ovu tamata ra rfadawang Ubu Yanan a Ni dawan a.” ");
INSERT INTO frd_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesus nlobang Marta, Maria ovu urarira i Lazarus a. ");
INSERT INTO frd_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ba naꞌut i Yesus nrenar ne, Lazarus nawar ia, na Ia nanaꞌa watan wan a amar irua ewal. ");
INSERT INTO frd_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Amar irua yai nelak roak, beti Yesus nfalak verin Ni tamata ovi rorang Ia ne, “Mya ma tewal ita tati Yudea.” ");
INSERT INTO frd_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ni tamata ovi rorang Ia yai rfalak verin Ia ne, “Tuan Guru, beti amar ifira nelak, na tamata Yahudi ra mane rala vatu al rteva Oa, na afakinimi mane muti ewal ineri?” ");
INSERT INTO frd_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesus nfalak ne, “Mia wol mkyaꞌa ne, tali lera beti ndata nata ti naran i nakduvul a, na jam vutu rahin irua? Tamata iki watan nbana naꞌut amar a, na veka wol nasvotun, tevek nsiꞌik lyawan i naꞌa lanit ivavan a. ");
INSERT INTO frd_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Naꞌuk tamata i nbana naꞌut ovan, na ia veka nasvotun, tevek lyawan a wol nanaꞌa ia.” ");
INSERT INTO frd_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yesus nfalak munuk roak wean inyai, beti nfalak vali verin ira ne, “Dida kida i Lazarus ntub-lufa roak, naꞌuk veka uti ma ufabatar ia.” ");
INSERT INTO frd_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ba Ni tamata ovi rorang Ia rfalak ne, “Duilaꞌa, wean i ntub-lufa, na veka lolin ewal ia tali ni suhut a.” ");
INSERT INTO frd_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Naꞌut inyai, na Yesus nfalak ne, Lazarus ntub-lufa. Ihin a ne, ia nmata roak. Naꞌuk Ni tamata ovi rorang Ia rfikir ne, Lazarus ntub-lufa watan. ");
INSERT INTO frd_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ba wean inyai, bi Yesus nfalyawang lahir ne, “Lazarus nmata roak. ");
INSERT INTO frd_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Naꞌuk ralang a lolin, tevek naꞌut i nmata, na Yaꞌa wol unaꞌa inyai. Wean inyai ma naꞌa bira lolin, boma myorang urun Yaꞌa. Mya ma tati ma tsiꞌik Lazarus.” ");
INSERT INTO frd_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomas i baꞌi rera ia ne Didimus, nfalak verin teran a valin ovi irmunuk rorang Yesus ne, “Mya ma torang Ia ma tmata ovu Ia.” ");
INSERT INTO frd_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Naꞌut i Yesus naran roak ahu Betania, na nrenar ne, rfadoku roak Lazarus naꞌa van matmatan amar ifaꞌat roak. ");
INSERT INTO frd_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania sarseri ovu Yerusalem, ma snain a kil itelu watan. ");
INSERT INTO frd_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Naꞌa inyai, na tamata Yahudi rivun ira rma roak ma rfaloling Marta ovu Maria ralarira ra, tevek urarira nmata. ");
INSERT INTO frd_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ti ma Marta nrenar ne, Yesus nma, na nti ma ntuan Ia. Naꞌuk Maria nanaꞌa watan rahan. ");
INSERT INTO frd_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta nfalak verin Yesus ne, “Duilaꞌa, wean i mnaꞌa ini, na urang a wol nmata. ");
INSERT INTO frd_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Velik ne wean inyai, naꞌuk fiang ini vali ukaꞌa ne, mera afaka watan tali Ubu, na Ia veka nala verin Oa.” ");
INSERT INTO frd_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesus nfalak verin Marta ne, “Uram a veka nvaꞌat ewal.” ");
INSERT INTO frd_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta nfalak ne, “Yaꞌa ukaꞌa ne, ia veka nvaꞌat ewal naꞌa amar i lanit ivavan veka namwear ma matmatan ra rvaꞌat ewal.” ");
INSERT INTO frd_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesus nfalak ne, “Yaꞌa ini ufavaꞌat matmatan ra ovu al vavaꞌat kakiwal verin tamata ra. Tamata iki watan norang Yaꞌa, na veka nvaꞌat ewal, velik ne nmata roak. ");
INSERT INTO frd_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Tamata i nvaꞌat obin ovu norang Yaꞌa, na veka wol nmata kakiwal. Morang afa i ufalak ini te wahal?” ");
INSERT INTO frd_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marta nfalak ne, “Duilaꞌa, yaꞌa orang ne, Oa ini Ubu Yanan i mwa lanit ivavan a, ovu Oa ini Raja i mtevut mami salasilan ra.” ");
INSERT INTO frd_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ti ma Marta nfalak munuk wean inyai, na nti ma nera aꞌan i Maria ma rdir-aling ira ma nfifi verin ia ne, “Tuan Guru nma roak eri, ba nfalak ma ti mtuan Ia.” ");
INSERT INTO frd_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Maria nrenar wean inyai, na nti lahir ma ntuan Yesus. ");
INSERT INTO frd_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Naꞌut inyai, na Yesus wol nma naran rira ahu ralan obin. Ia nanaꞌa watan obin wan i inlangin a Marta ntuan Ia. ");
INSERT INTO frd_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Tamata Yahudi ovi rnaꞌa rahan ma rfangrebat Maria ralan a, naꞌut i rsiꞌik ia ndiri ma nti lahir murin, na rorang ia. Ira rnarin ne, ia nti ma nvakar naꞌa van matmatan i rfanuba Lazarus naꞌa. ");
INSERT INTO frd_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Naꞌut i Maria nti naran wan i Yesus nanaꞌa ma nsiꞌik Ia, na nsangatur lahir naꞌa wahan ralan a ma nfalak ne, “Duilaꞌa, wean i mnaꞌa ini, na urang a wol nmata.” ");
INSERT INTO frd_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yesus nsiꞌik, na Maria nvakar, ovu tamata Yahudi ovi rorang ia rvakar vali, ba ralan lalau urun ovu nangrova. ");
INSERT INTO frd_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ia norat ira ne, “Fyanuba ia naꞌa inba?” Ira rfalak ne, “Duilaꞌa, mwa ma kaꞌi msiꞌik.” ");
INSERT INTO frd_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ba Yesus nvakar. ");
INSERT INTO frd_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Nata tamata Yahudi ra rfalak ne, “Eka msyiꞌik, Yesus nlobang urun Lazarus.” ");
INSERT INTO frd_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Boku vali rfalak ne, “Ia notu ma tamata ovi rkibu ra rsirea ewal. Naꞌuk afakinimi wol bis notu teri ma Lazarus deka nmata?” ");
INSERT INTO frd_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yesus nangrova, ma nti van matmatan i rfadoku ia naꞌa. Ira rfadoku ia naꞌa van yai ma rulang teri van ngoran yai ovu vatu dawan isa. ");
INSERT INTO frd_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yesus nfalak ne, “Msyikat aling vatu yai!” Tamata i nmata yai uran i Marta nfalak verin Yesus ne, “Duilaꞌa, ia ni amar ifaꞌat roak naꞌa van ralan yai, ba voan batbetan roak!” ");
INSERT INTO frd_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yesus nfalak verin Marta ne, “Ufalak roak verin oa ne, wean i morang, na veka msiꞌik Ubu Ni ngrebat a!” ");
INSERT INTO frd_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ba rsikat aling vatu yai. Nata Yesus ntadata nrata lanit, beti nfalak ne, “Fara weninyai ta Bapa, tevek mrenar roak Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ukaꞌa ne, Oa mrenar lalawatan Yaꞌa, naꞌuk ufalak munuk afa ini, boma tamata rivun ovi rnaꞌa ini rorang ne, Oa msinir roak Yaꞌa.” ");
INSERT INTO frd_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Yesus nfalak munuk wean inyai, na nafwak ne, “Lazarus! Mwa murin ini!” ");
INSERT INTO frd_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Nata Lazarus nma murin. Ean ovu liman ra ratkuma teri obin ovu maloli. Wahan a natkuma vali obin ovu maloli liak isa. Yesus nfalak verin ira ne, “Myaling maloli avyai tali tenan a, boma bisma nbana ma lolin.” ");
INSERT INTO frd_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Tamata Yahudi ovi rma ma ralola Maria, rivun vali ira rorang Yesus, tevek kaꞌi rsiꞌik afa i notu roak a. ");
INSERT INTO frd_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Naꞌuk tamata Yahudi boku vali ti rfamalik afa i Yesus notu yai verin tamata Yahudi ovi rtali sidovung Farisi. ");
INSERT INTO frd_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ba Yahudi rira dawan mela falurut ra ovu tamata Farisi ra rera rira dawan ovi rban-ulu naꞌa rira sidovung dawan a ma rasdovu ira. Ira rfalak ne, “Ita musti totu afaka? Tevek tamata yai notu roak mujizat rivun. ");
INSERT INTO frd_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Wean i tsiꞌik watan ma notu wean inyai, na tamata ra munuk veka rorang Ia. Ti nata tamata Roma rira suldadu ra veka rma ma rot-visal dida Rahan Dawan Falurut a, ovu dida bangsa a.” ");
INSERT INTO frd_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Tamata isa ntali Yahudi rira dawan avyai naran Kayafas, ovu naꞌut inyai, na ia neluk Yahudi rira Mela Falurut Ilaꞌa. Ia nfalak verin ira ne, “Mia wol mkyaꞌa afakataka. ");
INSERT INTO frd_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Mia wol mkyaꞌa ne, ni lolin a, tamata isa nmata verin tamata rivun. Afa yai lolin rahi tamata isa notu ma tamata Roma ra rvisal munuk dida bangsa a.” ");
INSERT INTO frd_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Velik aba Kayafas nfalak wean inyai, wol ntali ni fikiran a. Naꞌuk ia neluk Yahudi rira Mela Falurut Ilaꞌa naꞌut inyai, ba kaꞌi nfamalik afa ovi veka rvotuk naꞌa amar ovi veka rma ne, Yesus veka nmata al nakvanak tamata Yahudi ra. ");
INSERT INTO frd_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ia wol nmata verin tamata Yahudi ra watan, naꞌuk nmata verin Ubu yanan ra munuk naꞌa wan inba watan, boma nasdovu ira naꞌa isa. ");
INSERT INTO frd_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ba naꞌut inyai vali, na Yahudi rira dawan avyai raꞌan vai isa mane rfedan Yesus. ");
INSERT INTO frd_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Wean inyai bi, Yesus wol nbana roak naꞌa tamata Yahudi waharira ralan ra, boma deka rarea Ia. Ia nban-talik wan yai ma nti ahu isa i nfaseri wan lean vu dawan, naran Efraim, ma irmunuk Ni tamata ovi rorang Ia rnaꞌa inyai. ");
INSERT INTO frd_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Naꞌut inyai, na Yahudi rira amar dawan Paskah sarseri roak. Ba tamata rivun rtali ahu ra rti Yerusalem. Ira rti ma rfamerat tenarira ra wean rira adat a nfalak, beti rovu rira amar dawan Paskah yai. ");
INSERT INTO frd_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ira rsiꞌik al rdava Yesus, naꞌuk wol rarea Ia. Ira rdiri naꞌa Yahudi rira Rahan Dawan Falurut ni lean ma rsiforat ira ne, “Fyikir aka? Betane Ia wol nma snoba ini?” ");
INSERT INTO frd_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ira rfalak wean inyai, tevek rira dawan mela falurut ra ovu tamata Farisi ra rfareta roak ne, tamata iki watan nkaꞌa wan i Yesus nanaꞌa, na musti nfalak verin ira, boma bisma rtaha Ia. ");
INSERT INTO frd_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Teran amar inean ewal, beti tamata Yahudi ra rotu snoba naꞌa rira amar dawan Paskah. Naꞌut inyai, na Yesus nti ahu Betania. Lazarus i Yesus nfavaꞌat ewal roak ia tali matmatan yai, ntali ahu yai. ");
INSERT INTO frd_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Yesus Ni kida boku rotu snoba verin Ia naꞌa ahu yai. Naꞌut inyai, na Marta nasusan fanaꞌan verin ira. Lazarus ndoku vali ovu tamata ovi rma snoba yai, ma irmunuk rafnaꞌan ovu Yesus. ");
INSERT INTO frd_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Wol mnanat obin, na Maria ntaha ngul i voan lolin urun a naran narwastu, naꞌa botal fruan, ma nliꞌi naꞌa Yesus ean a, beti nala ni vut a ma al naꞌi. Ba ngul i voan lolin yai, voan a nsoru lahir rahan yai. Ngul yai fyawan urun. ");
INSERT INTO frd_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Yesus Ni tamata ovi rorang Ia, isa naran Yudas Iskariot i veka nfedi Yesus nanaꞌa inyai. Ia nfalak ne, ");
INSERT INTO frd_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Notu afakinimi wol ti fwedi ngul i voan lolin yai, ma mala kubang a verin tamata kasian ra? Wean i fwedi, na ni fyawan a dinar ratut itelu.” ");
INSERT INTO frd_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Yudas nfalak wean inyai, naꞌuk velik aba wol nkamlabir tamata kasian ra, tevek ia tamata barborin ia. Ia nasusan kubang verin Yesus Ni tamata ovi rorang Ia, ovu baꞌi nbori kubang boku tali kubang ovi nasusan avyai. ");
INSERT INTO frd_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Naꞌuk Yesus nfalak ne, “Deka fwalak teri ia. Ia notu wean ini, ma nfangnanang ia naꞌut amar i veka umata a, ma ti raflahar Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ufalak wean inyai, tevek tamata kasian ra rnaꞌa lalawatan ovu mia, naꞌuk Yaꞌa wol mane unaꞌa lalawatan ovu mia.” ");
INSERT INTO frd_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Tamata Yahudi rivun rarenar ne, Yesus nanaꞌa Betania, ba rti ma rtuan Ia. Ira wol mane rti ma rtuan watan Yesus, naꞌuk mane rsiꞌik vali Lazarus i Yesus nfavaꞌat ewal roak ia tali matmatan a. ");
INSERT INTO frd_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ba Yahudi rira dawan mela falurut ra raꞌan vai isa mane rfedan vali Lazarus, ");
INSERT INTO frd_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","tevek tamata Yahudi rivun wol rorang roak ira. Tamata Yahudi avyai mane rorang watan Yesus, tevek rsiꞌik roak ne, Lazarus nvaꞌat ewal roak. ");
INSERT INTO frd_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ni ilyan ana, tamata rivun ovi rma roak Yerusalem mane rovu snoba Paskah rarenar ne, Yesus mane nma vali Yerusalem. ");
INSERT INTO frd_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ba ti rala aa palem roan ra ma al rsaꞌa Ia, beti rafwak ne, “Mya ma tfadawang Ubu! Ubu naflahar Ia i nma ovu Duilaꞌa naran a, ovu Ia Raja Ia verin ita tamata Israel ra!” ");
INSERT INTO frd_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesus ntuan keledai isa i wol kaꞌi dawan ia obin ma rata ndoku tetan ratan a. Ba afa yai wean i rtulis roak naꞌa Surat Ralan ne, ");
INSERT INTO frd_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Tamata Sion ra deka byobar! Msyiꞌik kikyai, bira Raja a nma. Ia ndoku keledai isa i wol kaꞌi dawan ia obin tetan ratan a.” ");
INSERT INTO frd_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Naꞌut inyai, na Yesus Ni tamata ovi rorang Ia wol rfan-aran ne, afakinimi tamata ra rsaꞌa Ia wean inyai. Naꞌuk ti ma Yesus nvaꞌat ewal tali matmatan, ovu Ubu notu ma tamata ra rfadawang Ia, beti rangnanang ne, afa ovi tamata ra rotu yai wean lahir afa ovi nabi ra rtulis roak naꞌa Surat Ralan. ");
INSERT INTO frd_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Tamata rivun rovu vali Yesus naꞌut i nera Lazarus ntali van matmatan i rfanuba ia naꞌa, ma nfavaꞌat ewal ia tali matmatan. Tamata avyai rti rfamalik lalawatan afa yai. ");
INSERT INTO frd_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ba tamata rivun rti ma rtuan Ia, tevek rarenar ne, notu mujizat yai. ");
INSERT INTO frd_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ba tamata Yahudi ovi rtali sidovung Farisi kaꞌi rsifalak afa verin ira ne, “Ita kaꞌi tsiꞌik ne, ita wol tot-nala akataka lahir! Ita kaꞌi tsiꞌik ne, tamata ra munuk naꞌa lanit ivavan ini rti ma rorang Ia!” ");
INSERT INTO frd_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Naꞌut amar dawan Paskah yai, na tamata rivun rti Yerusalem, tevek mane rsangatur ma raraning Ubu. Naꞌut inyai, na tamata Yunani boku rti mane rsangatur ma raraning vali Ubu naꞌa inyai. ");
INSERT INTO frd_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ba tamata Yunani avyai ti rtuan Filipus i ntali Betsaida i naꞌa propinsi Galilea. Ira rfalak verin ia ne, “Baba, ami mane amtuan Yesus.” ");
INSERT INTO frd_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ba Filipus ti ntuan Andreas ma irua ti rfaivar verin Yesus. ");
INSERT INTO frd_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yesus nfalak verin ira ne, “Ubu Ni amar a naran roak mane nfavotuk Yaꞌa, Tamata Yanan, Ning dawan a. ");
INSERT INTO frd_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Afa i ufalak verin mia ini kena urun! Wean i wol rava gandum nabat isa naꞌa lanun ma nakvisal, na gandum yai isa watan. Naꞌuk wean i rava gandum yai ni nabat a, na veka narubu ma nafut, beti vuan ma rivun. ");
INSERT INTO frd_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Iki watan nlobang ni vavaꞌat a naꞌa lanit ivavan a, na veka wol ni vavaꞌat kakiwal. Naꞌuk iki watan wol nlobang ni vavaꞌat naꞌa lanit ivavan ini, na veka ni vavaꞌat kakiwal. ");
INSERT INTO frd_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Iki watan wean i mane nkarya verin Yaꞌa, na ia musti norang Yaꞌa. Notu wean inyai, boma itmunuk tnaꞌa wan isa. Yamang veka nalang munuk tamata ovi rkarya verin Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Fiang ini ralang wol malinan, ovu veka ufalak afaka? Yaꞌa veka ufalak ne, ‘Bapa, fwatalik Yaꞌa ma fara deka utuan susa i dawan urun a’? Wahal! Wol ufalak wean inyai, tevek Ning susa i veka utuan a, bi uma ini.” ");
INSERT INTO frd_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Yesus nfalak verin Yaman a ne, “Bapa, fara tamata ra rfadawang ilaꞌa naram a.” Nata vai isa ntali lanit ratan nfalak ne, “Ufadawang ilaꞌa narang a, ovu veka ufadawang ewal narang a.” ");
INSERT INTO frd_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Tamata rivun ovi rdiri inyai rarenar munuk vai yai. Boku rfalak ne, inyai dodung ngoan a, boku rfalak vali ne, Ubu Ni sansinir isa ntali lanit ratan nangrihi verin Ia. ");
INSERT INTO frd_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yesus nfalak ne, “Vai i mryenar yai, wol mane verin Yaꞌa, naꞌuk verin mia. ");
INSERT INTO frd_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Fiang ini, Ubu veka nfaleka inukun verin lanit ivavan ini. Fiang ini vali Ubu veka nfaleka lahir nitdawan i nfareta lanit ivavan a. ");
INSERT INTO frd_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Naꞌuk wean i rfasaka Yaꞌa tali lanit ivavan ini, na veka otu ma tamata ra munuk rma verin Yaꞌa.” ");
INSERT INTO frd_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ia nfalak wean inyai, boma nfaturu verin tamata ra ne, veka nmata wean inba. ");
INSERT INTO frd_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Nata tamata rivun avyai rfalak ne, “Ambas roak naꞌa mami buku inukun a ne, ‘Raja i ntevut tamata rira salasilan ra veka nvaꞌat, nata ti wol ni wahan. Wean inba ma Oa fwalak ne, musti rfasaka Tamata Yanan a? Tamata Yanan yai iki?’ ” ");
INSERT INTO frd_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yesus nfalak verin ira ne, “Wol mnanat, na lyawan i fiang ini nanaꞌa ovu mia, wol nleal roak. Ba fiang ini byana ovu lyawan yai, boma dedan wol nala mia. Tamata iki watan nbana naꞌa dedan ralan, na wol nkaꞌa ne, mane nti inba. ");
INSERT INTO frd_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Mia musti myorang lyawan yai naꞌut i nanaꞌa obin ovu mia, boma myeluk tamata ovi rvaꞌat naꞌa lyawan ralan!” Yesus nangrihi munuk wean inyai, beti nban-talik wan yai, ovu wol nfaturu roak felan a verin ira. ");
INSERT INTO frd_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Velik ne Yesus notu mujizat rivun naꞌa tamata Yahudi waharira ralan ra, naꞌuk wol rorang Ia. ");
INSERT INTO frd_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Afa ini nfakena afa ovi nabi Yesaya nfalak ra ne, “Duilaꞌa, wol tamata rorang ivar i amfamalik ini. Velik ne fwaturu Mu ngrebat i dawan ilaꞌa, naꞌuk rafena ma rorang Oa obin.” ");
INSERT INTO frd_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Wean inyai bi wol rorang Ia. Ini wean afa ovi Yesaya nfalak vali ne: ");
INSERT INTO frd_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Duilaꞌa kaꞌi notu ma matarira ra wean i rkibu, ovu notu ma ralarira wean vatu, boma wol bisma rsiꞌik, ovu rira fikiran ra rasmotak ma wol rfan-aran, ma wol rewal roak ira rma verin Yaꞌa ma otu ma lolin ewal ira.” ");
INSERT INTO frd_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Yesaya nfalak wean inyai, tevek nrea roak Yesus Ni dawan a, ovu nfamalik naꞌa Ia. ");
INSERT INTO frd_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Velik ne wean inyai, naꞌuk tamata rivun vali rorang Ia. Tali tamata rivun avyai, na boku tamata biasa watan, naꞌuk boku vali tali Yahudi rira dawan ovi rban-ulu verin ira. Naꞌuk wol rabrahi ma rtorung ne rorang Yesus, tevek rbobar betane tamata Farisi ra rfalak teri ma deka rti raflurut naꞌa Yahudi rira rahan falurut. ");
INSERT INTO frd_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Rotu wean inyai, tevek inar ma tamata ra rfadawang ira, nlia tali Ubu nfadawang ira. ");
INSERT INTO frd_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Nata Yesus nafwak ovu vain dawan ma nfalak ne, “Tamata iki watan norang Yaꞌa, na wol mane norang watan Yaꞌa, naꞌuk norang Ia i nsinir Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Tamata iki watan nsiꞌik roak Yaꞌa, na Ia nsiꞌik roak Ia i nsinir Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Yaꞌa uma roak lanit ivavan ini ma eluk lyawan, boma tamata ovi rorang roak Yaꞌa, munuk lahir wol rvaꞌat naꞌa dedan ralan. ");
INSERT INTO frd_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Tamata ovi rarenar afa ovi ufalak ra, naꞌuk wol rot-orang, na Yaꞌa wol ufaleka inukun verin ira. Tevek Yaꞌa wol uma ma ufaleka inukun verin tamata ra naꞌa lanit ivavan ini, naꞌuk uma ma usikat tamata ra tali rira salasilan ra, ma rira vavaꞌat kakiwal. ");
INSERT INTO frd_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Tamata iki watan wean i wol ntorung Yaꞌa, te nafena ma nrenar afa ovi ufalak ra, na Ning vaivatul ra veka rfaleka inukun verin ia naꞌa amar i lanit ivavan veka namwear. ");
INSERT INTO frd_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Tevek vaivatul ovi ufalak ra wol rtali Yaꞌa, naꞌuk rtali Yamang i nsinir Yaꞌa. Ia nsinir Yaꞌa ma ufalak afa ovi musti ufalak ra. ");
INSERT INTO frd_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Yaꞌa ukaꞌa ne, afa ovi Yamang a nfareta ra rvua vavaꞌat kakiwal verin mia. Ba uma ma ufalak munuk lahir afa ovi Yamang nsinir ma ufalak ra.” ");
INSERT INTO frd_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Naꞌut inyai, na Yahudi rira amar dawan Paskah sarseri roak. Yesus nkaꞌa ne, Ni amar a sarseri roak mane nti talik lanit ivavan a ma newal Ia nti verin Yaman a. Ia nlobang lalawatan Ni tamata ovi rorang Ia naꞌa lanit ivavan ini, ovu Ia nlobang ira ti naran i roak a. ");
INSERT INTO frd_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ovan roak, na Yesus nafnaꞌan ovu Ni tamata ovi rorang Ia. Nitdawan nkarya roak naꞌa Yudas Iskariot ralan a ma veka nfedi Yesus. Yudas ini Simon yanan ia. ");
INSERT INTO frd_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesus nkaꞌa roak ne, Yaman a nala roak Ni ngrebat a verin Ia ma nfareta munuk afakataka. Ia nkaꞌa vali ne, Ubu nsinir Ia ma nma, ovu veka newal Ia nti verin Ubu. ");
INSERT INTO frd_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ba Ia ndiri ma naling Ni ravit blawat a, ovu nala handuk isa ma nkeak naꞌa twalan a. ");
INSERT INTO frd_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Nata nliꞌi wear naꞌa loyang koꞌu isa ma nraming Ni tamata ovi rorang Ia earira ra, beti nala handuk i nkeak naꞌa twalan a ma al naꞌi earira ra. ");
INSERT INTO frd_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ti ma Yesus naran Simon Petrus, na ia nfalak verin Yesus ne, “Duilaꞌa, Oa mane mraming eang ra?” ");
INSERT INTO frd_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesus nvalat ne, “Oa wol fwan-aran obin afa i otu fiang ini, naꞌuk veka fwan-aran naꞌa amar ovi veka rma ini.” ");
INSERT INTO frd_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Petrus nfalak verin Yesus ne, “Deka ta Duilaꞌa! Wol lolin lahir ma mraming eang ra.” Naꞌuk Yesus nfalak ne, “Wean i wol uraming eam ra, na oa wol mu vavaꞌat isa ovu Yaꞌa.” ");
INSERT INTO frd_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simon Petrus nfalak ne, “Duilaꞌa, deka mane eang ra watan, naꞌuk limang ra ovu ulung a vali!” ");
INSERT INTO frd_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesus nfalak ne, “Tamata iki watan nliru roak ia, na tenan a nmerat munuk roak, ba teran aꞌuk nraming ean a. Mia myerat roak, naꞌuk tali mia, na isa wahal.” ");
INSERT INTO frd_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesus nkaꞌa roak ne, iki veka nfedi Ia, bi nfalak ne, “Mia myerat roak, naꞌuk tali mia, na isa wahal.” ");
INSERT INTO frd_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ti ma Yesus nraming munuk roak earira ra, na noru ewal Ni ravit blawat a ma ti ndoku ewal wan a. Nata nfalak verin ira ne, “Fyan aran afa i beti otu verin mia ini? ");
INSERT INTO frd_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Mia baꞌi myera Yaꞌa ne, Tuan Guru ovu Duilaꞌa. Inyai kena, tevek bira Tuan Guru ovu bira Duilaꞌa verin Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ba wean i Yaꞌa ini Tuan Guru ovu Duilaꞌa verin mia ma uraming eabira ra, na wean inyai vali verin mia, ma isa musti nraming isa ean a. ");
INSERT INTO frd_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Yaꞌa ufaturu roak lingaꞌan verin mia, ba musti myot-orang afa i otu roak verin mia yai. ");
INSERT INTO frd_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Afa i ufalak verin mia ini, kena urun! Tamata sansinir isa ni dawan a wol nlia duan a, ovu tamata sansinir ni dawan a wol nlia tamata i nsinir ia yai. ");
INSERT INTO frd_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Lolin urun verin mia, wean i mkyaꞌa munuk roak afa i ufalak ini ma myot-orang. ");
INSERT INTO frd_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Wol ufalak afa avyai verin bir tinemun. Yaꞌa ukaꞌa tamata ovi ufili ira, naꞌuk afa ini musti nvotuk, boma kena lahir ovu afa ovi rfadoku roak naꞌa Surat Ralan ne, ‘Tamata i nafnaꞌan ovu Yaꞌa veka nangal Yaꞌa.’ ");
INSERT INTO frd_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Fiang ini ufalak verin mia ne, afa i ufalak ini wol nvotuk obin, boma wean i nvotuk, na myorang ne, Yaꞌa ini Tamata i ufalak roak verin mia. ");
INSERT INTO frd_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Afa i ufalak verin mia ini, kena urun! Tamata iki ntorung ma nala tamata i usinir ia, na ia ntorung vali Yaꞌa. Tamata iki ntorung ma nala Yaꞌa, na ia ntorung vali Ia i nsinir Yaꞌa.” ");
INSERT INTO frd_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ti ma Yesus nangrihi munuk wean inyai, na ralan a lalau urun, ma nfalak ne, “Afa i ufalak verin mia ini, kena urun! Tamata isa tali bir tinemun veka nfedi Yaꞌa.” ");
INSERT INTO frd_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Yesus Ni tamata ovi rorang Ia yai kaꞌi rsisiꞌik ira watan, tevek wol rkaꞌa lahir ne, Ia nfalak iki. ");
INSERT INTO frd_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Tali Yesus Ni tamata ovi rorang Ia yai, na Ia nlobang urun tamata isa. Tamata yai ndoku Ni lihir mela a. ");
INSERT INTO frd_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simon Petrus nala liman al notu faneak verin tamata i Yesus nlobang urun ia yai, ma norat ia ne, “Ia nfalak iki.” ");
INSERT INTO frd_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ba tamata yai nrevang ia naꞌa Yesus buburn a ma norat ne, “Duilaꞌa, iki ia?” ");
INSERT INTO frd_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesus nfalak ne, “Tamata i usovu roti naꞌa Ning moko a ma al verin ia, inyai tamata i ufalak a.” Ia nfalak munuk wean inyai, beti nala roti yai ma nsovu naꞌa Ni moko a, ma nala verin Yudas i yaman verin Simon Iskariot. ");
INSERT INTO frd_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ti ma Yudas nala roti yai, na nitdawan a nanaꞌa ralan a. Ba Yesus nfalak verin ia ne, “Mane motu afakinyai, na motu lahir fiang ini.” ");
INSERT INTO frd_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Naꞌuk tali tamata ovi rdoku ma rafnaꞌan yai, na wol isa vali nkaꞌa ne, afakinimi Yesus nfalak wean inyai verin Yudas. ");
INSERT INTO frd_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Tamata boku tali Yesus Ni tamata ovi rorang Ia ranovak ne, Yesus nsinir Yudas ma ti nfaha afa ovi mane rotu naꞌa rira amar dawan, te nsinir ia ma ti nala kubang boku verin tamata kasian ra. Rfikir wean inyai, tevek Yudas nasusan rira kubang ra. ");
INSERT INTO frd_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yudas nala roti yai ma nti lahir. Naꞌut inyai, na ovan roak. ");
INSERT INTO frd_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Ti ma Yudas nti roak, beti Yesus nfalak ne, “Fiang ini Ning amar a naran roak ma Ubu nfadawang Yaꞌa, Tamata Yanan a. Tali afa ovi otu ra, na tamata ra rfadawang Ubu. ");
INSERT INTO frd_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Tali afa ovi otu roak avyai, bi tamata ra rfadawang Ubu, ba Ia veka notu ma tamata ra rfadawang vali Yaꞌa. Wol mnanat, na Ubu veka notu wean inyai. ");
INSERT INTO frd_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Yanak averi, Ning amar a wol mnanat roak ma unaꞌa ovu mia. Afa i ufalak roak verin dawan Yahudi ra, wean lahir afa i fiang ini ufalak vali verin mia. Mia veka mdyava Yaꞌa, naꞌuk naꞌa wan i veka uti a, fiang ini mia wol bisma miti. ");
INSERT INTO frd_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Yaꞌa ala fareta ngorvaꞌan verin bir tinemun wean ini: msyilobang mia. Wean lahir i ulobang roak mia, ba musti msyilobang mia. ");
INSERT INTO frd_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Wean i msyilobang mia, na tamata ra munuk veka rkaꞌa lahir ne, mia myeluk Ning tamata ovi rorang Yaꞌa.” ");
INSERT INTO frd_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simon Petrus nfalak verin Yesus ne, “Duilaꞌa, mane muti ba?” Yesus nfalak ne, “Naꞌa wan i veka uti a, fiang ini wol bisma muti. Naꞌuk naꞌa amar ovi veka rma ini, na oa veka morang Yaꞌa.” ");
INSERT INTO frd_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Petrus nfalak ewal verin Yesus ne, “Duilaꞌa, afakinimi fiang ini wol bisma orang Oa? Yaꞌa utorung ma veka umata verin Oa.” ");
INSERT INTO frd_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yesus nfalak ne, “Petrus, oa mane mwata verin Yaꞌa? Afa i ufalak verin oa ini, kena urun! Manut wol nkukuwai obin, na oa veka malak nala fatelu roak ne, wol mkaꞌa Yaꞌa.” ");
INSERT INTO frd_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesus nfalak ne, “Deka ralabira kakoꞌu. Myorang Ubu, ovu myorang vali Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Wan rivun naꞌa Yamang Ni Rahan a. Uti inveli, boma ususan wan verin mia. Wean i wol wean inyai, na ufalak roak verin mia. ");
INSERT INTO frd_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Yaꞌa uti ma ususan wabira munuk, beti ewal Yaꞌa ma ala mia ma tati wang i unaꞌa, boma wean i unaꞌa inyai, na mia mnyaꞌa vali inyai. ");
INSERT INTO frd_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Mia mkyaꞌa roak lingaꞌan i nti wan i veka uti yai.” ");
INSERT INTO frd_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomas nfalak verin Yesus ne, “Duilaꞌa, ami wol amkaꞌa ne, Oa mane muti ba. Ba wean inba ma bisma amkaꞌa lingaꞌan i mane nti wan yai?” ");
INSERT INTO frd_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesus nfalak ne, “Yaꞌa ini lingaꞌan verin tamata ovi mane rti Yamang a. Tali Yaꞌa bi tamata ra rkaꞌa afa ovi kena ra, ovu Yaꞌa ala vavaꞌat kakiwal verin tamata ra. Wol tamata isa bisma nti ntuan Yamang a, wean i wol nahu Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Wean i mkyaꞌa roak Yaꞌa, na mkyaꞌa roak Yamang a. Ba fiang ini mkyaꞌa roak Ia, ovu msyiꞌik roak Ia.” ");
INSERT INTO frd_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ba Filipus nfalak verin Yesus ne, “Duilaꞌa, fwaturu Yamam a verin ami, na inyai naran roak verin ami.” ");
INSERT INTO frd_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesus nfalak verin ia ne, “Filipus, itmunuk mnanat roak, naꞌuk afakinimi wol mkaꞌa Yaꞌa obin? Tamata iki watan nsiꞌik roak Yaꞌa, na ia nsiꞌik roak Yamang a. Notu afakinimi fwalak ne, ‘Fwaturu Yamam a verin ami’? ");
INSERT INTO frd_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Oa wol morang ne, Yaꞌa uleal Yamang ralan a, ovu Yamang nleal ralang a? Afa ovi ufalak verin mia, wol mane ntali watan Yaꞌa, naꞌuk ntali Yamang a. Yamang nleal ralang a, ba afa ovi otu ra, na Ia notu munuk afa avyai. ");
INSERT INTO frd_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Myorang Yaꞌa naꞌut i ufalak ne, Yaꞌa uleal Yamang ralan a ovu Yamang nleal Yaꞌa ralang a. Wean i wol myorang afa yai, na myorang Yaꞌa tevek mujizat ovi otu roak ra. ");
INSERT INTO frd_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Afa i ufalak verin mia ini, kena urun! Tamata iki watan norang Yaꞌa, na ia veka not-nala vali mujizat ovi otu ra. Ia bis notu ma nlia tali mujizat ovi otu ra, tevek Yaꞌa veka uti verin Yamang a. ");
INSERT INTO frd_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Wean i myera afaka watan naꞌa narang a, na Yaꞌa veka otu munuk verin mia, boma tamata ra rfadawang Yamang a, tevek afa ovi otu ra. ");
INSERT INTO frd_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Wean i myera afaka watan naꞌa narang a, na veka otu munuk afa avyai verin mia.” ");
INSERT INTO frd_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Yesus nfalak ne, “Wean i mlyobang Yaꞌa, na mia veka myot-orang afa ovi ufareta ma myotu ra. ");
INSERT INTO frd_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Yaꞌa veka era verin Yamang a ma nala Ni Roh i veka nala lablobang verin mia ovu nfatuang mia, nata ti wol ni wahan. ");
INSERT INTO frd_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ubu Ni Roh yai veka nfalyawang afa ovi kena ra. Tamata ovi rnaꞌa lanit ivavan a wol rtorung Ni Roh a, tevek wol rsiꞌik ovu wol rkaꞌa Ia. Naꞌuk mia mkyaꞌa Ia, tevek nfatuang mia ovu veka nleal ralabira ra. ");
INSERT INTO frd_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Yaꞌa wol usiꞌik watan ma aksa mia, wean tamata ovi rwatat renarir-yamarira ra, naꞌuk Yaꞌa veka uma ewal ma itmunuk. ");
INSERT INTO frd_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Wol mnanat, na tamata ovi rnaꞌa lanit ivavan a veka wol rarea roak Yaꞌa. Naꞌuk mia veka msyiꞌik ewal Yaꞌa, tevek veka uvaꞌat ewal tali matmatan, ba mia veka byaꞌat vali. ");
INSERT INTO frd_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Naꞌut inyai, na veka mkyaꞌa ne, Yaꞌa uleal Yamang ralan a, ovu mia mlyeal Yaꞌa ralang a, ovu vali Yaꞌa uleal ralabira ra. ");
INSERT INTO frd_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Tamata iki watan ntorung afa ovi ufareta verin tamata ra ovu not-orang, na ia nlobang urun Yaꞌa. Iki watan nlobang Yaꞌa, na Yamang a nlobang ia, ovu Yaꞌa veka ulobang vali ia, ma ufaturu tenang a verin ia.” ");
INSERT INTO frd_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ba Yudas i wol Yudas Iskariot, norat Yesus ne, “Duilaꞌa, afakinimi mane fwaturu watan tenam a verin ami, naꞌuk wol fwaturu tenam a verin tamata ovi rnaꞌa lanit ivavan a?” ");
INSERT INTO frd_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesus nfalak ne, “Tamata iki watan nlobang Yaꞌa, na ia veka not-orang afa ovi ufalak ra, ovu Yamang veka nlobang ia. Yaꞌa ovu Yamang a veka amama verin ia, ma amleal ovu ia, nata ti wol ni wahan. ");
INSERT INTO frd_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Tamata iki watan wol nlobang Yaꞌa, na ia veka wol not-orang Ning vaivatul ra. Vaivatul ovi mryenar roak yai wol rtali watan Yaꞌa, naꞌuk rtali Yamang i nsinir Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Ufalak munuk roak afa avyai verin mia naꞌut i itmunuk obin. ");
INSERT INTO frd_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Naꞌuk Yamang a veka nala Ni Roh ma al nkati Yaꞌa ma nala lablobang verin mia. Ni Roh yai veka nair mia naꞌa afakataka munuk, ovu nfangnanang mia naꞌa afa ovi air munuk roak verin mia. ");
INSERT INTO frd_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Uti, naꞌuk otu ma ralabira ra malinan watan. Malinan i ntali Yaꞌa, ala verin mia, ovu afa i ala verin mia yai wol wean afa ovi lanit ivavan a nala verin mia. Ba ralabira ra deka kakoꞌu ovu deka byobar. ");
INSERT INTO frd_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Mia mryenar roak i ufalak ne, Yaꞌa veka uti, naꞌuk veka uma ewal ma utuan mia. Wean i mlyobang Yaꞌa, na veka ralabira lolin urun naꞌut i uti verin Yamang a, tevek Ni dawan a nlia Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Afa avyai wol rvotuk obin, naꞌuk fiang ini ufalak roak verin mia, boma wean i afa avyai rvotuk, na myorang. ");
INSERT INTO frd_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Yaꞌa veka wol ungrihi ma rivun verin mia, tevek naran roak ni amar a ma nitdawan i nfareta lanit ivavan a mane nma. Naꞌuk ia wol ni ngrebat ma nfareta Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Naꞌuk afa avyai munuk musti rvotuk, boma tamata ovi rnaꞌa lanit ivavan a rkaꞌa ne, Yaꞌa ulobang Yamang a, ovu ot-orang afa ovi nfalak ra munuk. Byatar ma tati kikyai.” ");
INSERT INTO frd_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yesus nfamalik vaivatul kamkuma isa wean ini: “Yaꞌa ini wean aa anggur mngaꞌun a, na Yamang a wean tamata i nwanar vaꞌi anggur a. ");
INSERT INTO frd_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ningu aa anggur sanan ra, ovu sanan avyai rfaturu tamata inorang ra. Ba lokat aa sanan ovi wol vuarira, na tamata i nwanar vaꞌi anggur yai veka netal vatuk aa sanan avyai. Naꞌuk aa sanan ovi vuar ra, na Ia veka nsingya aa sanan avyai, boma rtafal ma vuarira. ");
INSERT INTO frd_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Mia myerat roak, tevek ufalak roak vaivatul ovi verin mia. ");
INSERT INTO frd_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Mia musti myotu ma bira vavaꞌat ra isa lalawatan ovu Yaꞌa, ovu Yaꞌa veka otu vali ma Ning vavaꞌat isa lalawatan ovu mia. Wean aa anggur sanan ra wol bisma vuar wean i rdir-aling ira tali aa anggur a, ovu mia weabira vali inyai. Wean i wol bira vavaꞌat isa ovu Yaꞌa, na wol bisma vuabira. ");
INSERT INTO frd_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Yaꞌa ini wean aa anggur a, na mia wean aa anggur sanan ra. Tamata iki watan ni vavaꞌat isa roak ovu Yaꞌa, ovu vali unaꞌa lalawatan ni vavaꞌat a, na ia veka vuan ma rivun. Tevek wean i wol bira vavaꞌat isa ovu Yaꞌa, na wol myot-nala akataka. ");
INSERT INTO frd_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Tamata iki watan wol ni vavaꞌat isa ovu Yaꞌa, na ia veka wean aa sanan ovi retal vatuk ira. Ti ma rear roak, na rasdovuk ira ma relik rti yafu ralan ma rasnuri ira. ");
INSERT INTO frd_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Wean i bira vavaꞌat isa roak ovu Yaꞌa, ovu vali myala lalawatan vaivatul ovi ufalak roak verin mia naꞌa ralabira ra, na myera afaka watan tali Yamang a, na Ia veka nala verin mia. ");
INSERT INTO frd_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Wean i bira vavaꞌat ra wean aa sanan ovi vuarira rivun, na fyaturu ne, mia myeluk tamata ovi rorang Yaꞌa. Bira vavaꞌat i wean inyai notu ma tamata ra rfadawang Yamang a.” ");
INSERT INTO frd_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Yaꞌa ulobang mia, wean lahir Yamang a nlobang Yaꞌa. Ba musti myotu ma bira vavaꞌat ra isa lalawatan ovu Yaꞌa, boma bisma mkyaꞌa Ning silobang yai. ");
INSERT INTO frd_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Wean i myot-orang afa ovi ufareta ma myotu ra, na bira vavaꞌat ra isa lalawatan ovu Yaꞌa naꞌa Ning silobang a. Inyai wean lahir i ot-orang lalawatan afa ovi Yamang nfareta ma otu ra, ovu Ning silobang isa lalawatan ovu Ia naꞌa Ni silobang a. ");
INSERT INTO frd_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ufalak munuk afa avyai verin mia, boma ralabira ra lolin urun, wean Yaꞌa ralang i lolin urun a. Otu wean inyai ma nfatnemung ralabira i lolin urun yai. ");
INSERT INTO frd_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ufareta mia ma myotu wean ini: Msyilobang mia, wean lahir i ulobang roak mia. ");
INSERT INTO frd_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Tamata i ntorung ma nmata al nakvanak ni kida ra, na tamata yai nfaturu roak silobang i dawan lia munuk. ");
INSERT INTO frd_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Wean i myot-orang afa ovi ufareta ma myotu ra, na mia myotu kida roak ovu Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Yaꞌa veka wol era roak mia ne tamata sansinir, tevek tamata sansinir wol nkaꞌa afa ovi duan a veka notu a. Naꞌuk era roak mia ne kida, tevek afa ovi urenar roak tali Yamang a, ufalak munuk roak verin mia. ");
INSERT INTO frd_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Mia wol fyili Yaꞌa, naꞌuk Yaꞌa ufili mia ma usinir mia, ma ti ma myotu afa ovi lolin ra, boma weabira aa anggur sanan ovi vuar lalawatan. Myotu wean inyai, na myera afaka watan tali Yamang a naꞌa narang a, na Ia veka nala verin mia. ");
INSERT INTO frd_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ba ufareta mia wean ini: Msyilobang mia.” ");
INSERT INTO frd_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Wean i tamata ovi rnaꞌa lanit ivavan wol inar lahir mia, na mingnanang ne, lan a wol inar lahir Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Wean i bira vavaꞌat ra wean tamata ovi rnaꞌa lanit ivavan a, na ira veka rlobang mia wean watan i rlobang yanarira ra. Naꞌuk Yaꞌa ufili roak mia, ma wol myovu roak tamata ovi rnaꞌa lanit ivavan a, boma bira vavaꞌat ra naling ia tali ira. Wean inyai bi wol inar lahir mia. ");
INSERT INTO frd_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Mingnanang afa ovi ufalak roak verin mia: Tamata sansinir isa ni dawan wol nlia duan a. Tamata boku rwi-rwa lan roak Yaꞌa, ovu ira veka rwi-rwa vali mia. Naꞌuk tamata boku vali rot-orang roak afa ovi air ra, ovu veka rot-orang vali afa ovi myair ra. ");
INSERT INTO frd_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Tamata avyai rwi-rwa mia, tevek myorang Yaꞌa. Ira rotu wean inyai, tevek wol rkaꞌa Ia i nsinir roak Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Wean i Yaꞌa wol uma ma ungrihi ovu ira, na Ubu wol nfasala ira. Naꞌuk fiang ini uma roak ma ungrihi ovu ira, naꞌuk rafena ma rorang. Ba wol tamata isa vali bisma nfalak ne, wol notu salasilan! ");
INSERT INTO frd_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Tamata iki watan wol inan lahir Yaꞌa, na ia vali wol inan lahir Yamang a. ");
INSERT INTO frd_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Wean i Yaꞌa wol otu mujizat ovi tamata ra wol rotu obin naꞌa waharira ralan ra, na Ubu wol nfasala ira. Naꞌuk fiang ini rsiꞌik roak mujizat ovi otu ra, naꞌuk wol inar lahir Yaꞌa ovu vali wol inar lahir Yamang a. ");
INSERT INTO frd_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Naꞌuk rotu wean inyai ma nfakena afa ovi rtulis roak naꞌa rira Inukun ne, ‘Ira wol inar lahir Yaꞌa, naꞌuk wol rira lola ma wol inar lahir Yaꞌa.’ ");
INSERT INTO frd_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Yaꞌa veka usinir Roh i ntali Yamang a ma nlobang mia. Roh yai veka nfalak lahir afa ovi kena ra. Roh yai ntali Yamang a nma, ba veka nfamalik Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Mia vali musti fyamalik afa ovi otu ra, tevek myovu roak Yaꞌa naꞌut i beti ukarya naꞌa lanit ivavan ini.” ");
INSERT INTO frd_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Yaꞌa ufalak munuk afa avyai verin mia, boma deka mifla talik bira inorang a verin Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Tamata ra veka raling vatuk mia tali dida rahan falurut ra. Veka ti naran ni amar a ma tamata ovi rfedan mia ranovak ne, rkarya verin Ubu ovu rotu ma ralan lolin. ");
INSERT INTO frd_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Rotu wean inyai, tevek wol rkaꞌa Yamang a ovu wol rkaꞌa vali Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ba fiang ini ufalak afa avyai verin mia, boma naꞌut i rwi-rwa mia wean i ufalak roak yai, na mingnanang ne, ufamalik roak verin mia.” “Lan a wol ufalak afa avyai verin mia, tevek naꞌut inyai, na Yaꞌa unaꞌa ovu mia obin. ");
INSERT INTO frd_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Fiang ini mane ewal roak Yaꞌa uti utuan Ia i nsinir Yaꞌa, naꞌuk wol tamata isa vali tali mia norat Yaꞌa ne, ‘Muti ba?’ ");
INSERT INTO frd_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Fiang ini ralabira lalau, tevek ufalak roak ne, mane uti. ");
INSERT INTO frd_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Naꞌuk afa i ufalak ini kena: Ni lolin a uti, boma naꞌa bira lolin. Wean i wol uti, na Ubu Ni Roh i nala lablobang verin mia veka wol nma. Naꞌuk wean i uti, na veka usinir Ia nma verin mia. ");
INSERT INTO frd_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Wean i Ubu Ni Roh nma, na Ia veka notu ma tamata ovi rnaꞌa lanit ivavan a rkaꞌa ne, rotu roak salasilan. Ia veka notu ma rkaꞌa ne, Ning vavaꞌat nmalola, ovu rkaꞌa vali Ubu Ni inukun i veka nfaleka verin lanit ivavan a. ");
INSERT INTO frd_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ia veka notu ma rkaꞌa vali ne, rira salasilan roak, tevek rafena ma rorang Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ia veka notu vali ma rkaꞌa ne, Ning vavaꞌat nmalola, tevek ewal Yaꞌa uti verin Yamang a. Naꞌut inyai, na mia veka wol mryea roak Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ubu Ni Roh veka notu vali ma rkaꞌa Ubu Ni inukun i veka nfaleka verin ira, tevek fiang ini Ubu nukun roak nitdawan i nfareta lanit ivavan a. ");
INSERT INTO frd_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Afa rivun ilaꞌa mane ufalak verin mia, naꞌuk fiang ini wol bisma byar-nala afa avyai obin, tevek aleman. ");
INSERT INTO frd_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Naꞌut i Ubu Ni Roh nma, na Ni Roh yai veka nfalak afa ovi kena ra. Ia veka nair mia ma mkyaꞌa afa ovi kena ra munuk. Naꞌut i nangrihi, na afa ovi nfalak ra wol rtali Ni fikiran a watan, naꞌuk Ia nfalak afa ovi nrenar roak tali Ubu. Ia veka nfalak vali verin mia naꞌa afa ovi veka rvotuk ra. ");
INSERT INTO frd_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ubu Ni Roh a veka nalang Yaꞌa, tevek vaivatul ovi nfalak verin mia yai, rtali munuk Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Afa ovi rnaꞌa munuk Yamang a, Yaꞌa Ningu vali. Wean inyai bi ufalak ne, afa ovi Ubu Ni Roh nfalak verin mia, rtali munuk Yaꞌa.” ");
INSERT INTO frd_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Ning amar wol mnanat roak ma veka wol mryea roak Yaꞌa, ovu veka wol mnanat, na mryea ewal Yaꞌa.” ");
INSERT INTO frd_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ba Yesus Ni tamata ovi rorang Ia boku rsiforat ira ma rfalak ne, “Afakinimi nfalak ne, ‘Ning amar wol mnanat roak ma veka wol mryea roak Yaꞌa, ovu veka wol mnanat, na mryea ewal Yaꞌa’? Afakinimi Ia nfalak vali ne, ‘Yaꞌa mane ewal Yaꞌa ti verin Yamang a’?” ");
INSERT INTO frd_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ira rfalak vali ne, “Ia nfalak ne, ‘Ning amar wol mnanat roak.’ Ita wol tkaꞌa ne, inyai ihin aka?” ");
INSERT INTO frd_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesus nkaꞌa ne, ira mane rera ma nfalyawang naꞌa afa ovi nfalak ra. Ba nfalak ne, “Inlangin a ufalak ne, Ning amar wol mnanat roak ma veka wol mryea roak Yaꞌa, naꞌuk veka wol mnanat, na mryea ewal Yaꞌa. Ba msyiforat mia naꞌa afa yai? ");
INSERT INTO frd_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Afa i ufalak verin mia ini, kena urun! Naꞌut i uti a, na mia veka byakar ma ralabira lalau, naꞌuk tamata ovi rnaꞌa lanit ivavan a veka inarira lolin. Velik ne byakar, naꞌuk veka myewal ma ralabira ra lolin urun. ");
INSERT INTO frd_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Bira wawaꞌuk i mtyuan yai wean vata i mane ndoku rahan nfarnuang a. Naꞌuk ti ma nrali roak ia, na wol nangnanang roak wawaꞌuk yai, tevek nrali roak kasikoꞌu yanat isa naꞌa lanit ivavan a. ");
INSERT INTO frd_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Wean vali inyai verin mia. Fiang ini ralabira lalau, naꞌuk veka utuan ewal mia, na veka inabira lolin, ovu wol tamata isa vali bisma nala inabira lolin yai tali mia. ");
INSERT INTO frd_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Amar yai, na veka wol myorat afakataka tali Yaꞌa. Afa i ufalak verin mia ini, kena urun! Naꞌut inyai, na myera afaka watan tali Yamang a naꞌa narang a, na Ia veka nala verin mia. ");
INSERT INTO frd_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Tali lalan a ma naran amar ini, na mia wol myera akataka naꞌa narang obin. Ba fiang ini myera afaka watan naꞌa narang a, na Yamang a veka nala verin mia, boma ntafal ma ralabira lolin urun. ");
INSERT INTO frd_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Yaꞌa ala vaivatul kamkuma ma al ufalak munuk afa avyai verin mia. Veka naran ni amar a ma wol ala vaivatul kamkuma roak ma ungrihi verin mia, naꞌuk veka ufalyawang lahir naꞌa Yamang a verin mia. ");
INSERT INTO frd_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Naꞌut inyai, na mia veka myala narang a ma kaꞌi myera verin Yamang a. Yaꞌa wol ufalak ne, veka era afakataka tali Yamang a verin mia, ");
INSERT INTO frd_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","tevek Yamang a kaꞌi nlobang mia. Ia nlobang mia, tevek mlyobang Yaꞌa, ovu myorang ne, Ubu nsinir Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Yaꞌa utali Yamang a uma lanit ivavan a, ba uban-talik lanit ivavan a ma ewal Yaꞌa ti verin Yamang a.” ");
INSERT INTO frd_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ba Yesus Ni tamata ovi rorang Ia rfalak verin Ia ne, “Fiang ini mungrihi, na wol mala roak vaivatul kamkuma, naꞌuk fwalyawang lahir afa ovi fwalak ra. ");
INSERT INTO frd_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Fiang ini amkaꞌa roak ne, Oa mkaꞌa munuk afakataka, ba wol amperlu roak ma amorat akataka tali Oa. Wean inyai bi, amorang urun ne, Oa mtali Ubu.” ");
INSERT INTO frd_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yesus nfalak ne, “Ba fiang ini myorang roak afa ovi ufalak ra? ");
INSERT INTO frd_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Mingnanang! Ni amar a veka nma, ovu fiang ini amar yai nma roak. Mia veka mifla talik Yaꞌa ma myewal mia miti bira rahan ra, ma aksa Yaꞌa watan. Naꞌuk wol aksa Yaꞌa, tevek Yamang a novun Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ufalak munuk afa avyai verin mia, boma ralabira ra malinan watan, tevek bira vavaꞌat ra isa roak ovu Yaꞌa. Naꞌa lanit ivavan a mia veka mtyuan susa. Naꞌuk mtyahang ralabira watan, tevek utung munuk roak ngrebat ovi rnaꞌa lanit ivavan a.” ");
INSERT INTO frd_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesus nfalak munuk afa avyai, beti ntadata nrata lanit ma nfalak ne, “Bapa, naran roak ni amar a ma fwaturu Yanam Ni dawan a, boma Yanam a nfaturu vali Mu dawan a. ");
INSERT INTO frd_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Bapa, Oa mala roak ngrebat verin Yanam a ma nfareta tamata ovi rnaꞌa lanit ivavan a munuk. Ngrebat yai notu ma Ia nala vavaꞌat kakiwal verin tamata ovi mala munuk roak ira verin Ia. ");
INSERT INTO frd_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Vavaꞌat kakiwal yai wean ini: ira rkaꞌa roak ne, Oa Ubu i ikisa watan a ovu saꞌi kena Oa, ovu vali rkaꞌa Yesus Kristus i msinir roak Ia ma nma lanit ivavan a. ");
INSERT INTO frd_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Yaꞌa ufaturu roak Mu dawan a naꞌa lanit ivavan a, tevek ot-nala munuk roak afa ovi msinir ma otu ra. ");
INSERT INTO frd_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Bapa, wean inyai bi era verin Oa, ma fwadawang Yaꞌa naꞌa waham ralan wean lan fwadawang Yaꞌa, naꞌut i wol motu lanit ivavan obin. ");
INSERT INTO frd_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Yaꞌa ufamalik roak Oa verin tamata ovi mala roak ira verin Yaꞌa naꞌa lanit ivavan a. Oa Mu tamata avyai, ovu mala roak ira verin Yaꞌa, ovu vali rot-orang roak Mu vaivatul ra. ");
INSERT INTO frd_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Fiang ini rkaꞌa roak ne, afa ovi mala munuk verin Yaꞌa rtali Oa. ");
INSERT INTO frd_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ufamalik roak Mu vaivatul ovi fwalak roak verin Yaꞌa verin ira, ma rtorung vaivatul avyai. Ira rkaꞌa urun ne, Yaꞌa utali Oa ovu rorang ne, Oa msinir Yaꞌa ma uma. ");
INSERT INTO frd_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Yaꞌa uflurut verin ira. Wol uflurut verin tamata ra munuk naꞌa lanit ivavan ini, naꞌuk verin tamata ovi mala roak ira verin Yaꞌa, tevek Oa Mu ira. ");
INSERT INTO frd_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Yaꞌa Ning tamata ra, Oa Mu vali ira, ovu Oa Mu tamata ra, Yaꞌa Ningu vali ira. Ira rfaturu Ning dawan a ma tamata ra rfadawang Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Fiang ini uti verin Oa ta Bapa. Yaꞌa wol unaꞌa roak lanit ivavan a, naꞌuk Ning tamata ovi rorang Yaꞌa rnaꞌa lanit ivavan obin. Bapa, Oa mwerat urun. Fara mwanar ira ovu Mu ngrebat i mala roak verin Yaꞌa, boma ralar isa, wean lahir Yaꞌa ovu Bapa ikisa watan ita. ");
INSERT INTO frd_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Naꞌut i unaꞌa ovu ira obin, na uwanar ira ovu ngrebat i mala roak verin Yaꞌa. Uwanar roak ira, ma wol isa vali tali ira nmata kakiwal. Naꞌuk isa watan tali ira veka nmata kakiwal, ma nfakena afa ovi rtulis roak naꞌa Surat Ralan. ");
INSERT INTO frd_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Fiang ini uti verin Oa ta Bapa. Unaꞌa lanit ivavan ini obin, na ungrihi wean ini, boma ira bisma rfarnuang ne, ralarira lolin urun wean lahir Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ufamalik roak Mu vaivatul ra verin ira. Ba tamata ovi rnaꞌa lanit ivavan a wol inar lahir ira, tevek rira vavaꞌat ra wol wean tamata ovi rnaꞌa lanit ivavan a. Inyai wean vali Ning vavaꞌat a, wol wean tamata ovi rnaꞌa lanit ivavan a. ");
INSERT INTO frd_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Yaꞌa wol era verin Oa ma mala ira tali lanit ivavan a, naꞌuk era ma mwanar ira tali nitdawan a. ");
INSERT INTO frd_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Rira vavaꞌat ra wol wean tamata ovi rnaꞌa lanit ivavan a. Yaꞌa vali Ning vavaꞌat a wol wean tamata ovi rnaꞌa lanit ivavan a. ");
INSERT INTO frd_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Bapa, motu ma rira vavaꞌat ra rmalola ovu afa ovi kena ra. Mu vaivatul ra kena. ");
INSERT INTO frd_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Wean lahir i msinir roak Yaꞌa ma uma lanit ivavan a, ba usinir vali ira ma rti verin tamata ra naꞌa lanit ivavan a. ");
INSERT INTO frd_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Yaꞌa kaꞌi ala tenang a wean lahir ralam nfalak a ma naꞌa rira lolin, boma ira bisma rala urun tenarira ra ma rot-orang Mu vaivatul ovi kena ra. ");
INSERT INTO frd_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Yaꞌa wol mane uflurut watan verin ira, naꞌuk uflurut vali verin tamata ovi rorang Yaꞌa tali afa ovi rfamalik ra. ");
INSERT INTO frd_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Era verin Oa ta Bapa, boma motu ma isa watan ira, wean lahir Yaꞌa uleal ralam a ovu mleal ralang a. Era vali ma ira ovu ita isa watan, boma tamata ovi rnaꞌa lanit ivavan a rorang ne, Oa msinir roak Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Yaꞌa alang roak ira wean watan i malang roak Yaꞌa, boma isa watan ira wean lahir i isa watan ita. ");
INSERT INTO frd_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ning vavaꞌat isa watan ovu ira, ovu vali Bapa ovu Yaꞌa isa watan ita, boma irmunuk isa watan ira. Wean inyai, boma tamata ovi rnaꞌa lanit ivavan a rkaꞌa ne, Oa msinir Yaꞌa, ovu vali mlobang ira wean lahir i mlobang Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Bapa, era ma fara tamata ovi mala roak ira verin Yaꞌa, rovu vali Yaꞌa ma amnaꞌa wan i unaꞌa. Motu wean inyai, boma rsiꞌik Ning dawan i mala roak verin Yaꞌa, tevek mlobang roak Yaꞌa, naꞌut i wol motu lanit ivavan obin. ");
INSERT INTO frd_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Bapa, Mu afa ovi motu ra rmalola lalawatan. Tamata ovi rnaꞌa lanit ivavan a wol rkaꞌa Oa. Naꞌuk Yaꞌa ukaꞌa Oa, ovu vali Ning tamata ovi rorang Yaꞌa rkaꞌa ne, Oa msinir roak Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Yaꞌa ufamalik roak verin ira ne, iki Oa, ovu veka ufamalik lalawatan Oa verin ira, boma Mu silobang i mala verin Yaꞌa nanaꞌa lalawatan ralarira ra, ma Ning vavaꞌat isa watan ovu ira.” ");
INSERT INTO frd_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ti ma Yesus naflurut munuk wean inyai, na irmunuk Ni tamata ovi rorang Ia rti oar Kidron ni lihir a. Vaꞌi zaitun isa nanaꞌa inyai, ba Yesus ovu Ni tamata ra rti vaꞌi yai ralan a. ");
INSERT INTO frd_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yudas i nfedi Yesus nkaꞌa vali vaꞌi yai, tevek Yesus baꞌi nasdovu Ia ovu Ni tamata ovi rorang Ia naꞌa inyai. ");
INSERT INTO frd_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ba Yudas nti wan yai. Ia novun Roma rira sidovung suldadu isa, ovu tamata ovi rwanar Yahudi rira Rahan Dawan Falurut a rti vali wan yai, ovu rtaha damar, faduk ovu rira mneran ra. Tamata Yahudi rira dawan mela falurut ra ovu tamata Yahudi ovi rtali sidovung Farisi rsinir ira ma rti. ");
INSERT INTO frd_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesus nkaꞌa lahir afa ovi veka rkena Ia, ba ti nfaseri tamata avyai ma nfalak verin ira ne, “Mia mdyava iki?” ");
INSERT INTO frd_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ira rfalak ne, “Yesus i ntali Nazaret a.” Ia nfalak verin ira ne, “Yaꞌa ini tamata i mdyava a.” Naꞌut inyai, na Yudas i nfedi Yesus ndiri vali ovu ira naꞌa inyai. ");
INSERT INTO frd_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Naꞌut i Yesus nfalak verin ira ne, “Yaꞌa ini tamata i mdyava a,” na tamata avyai munuk rsuka ira ma rleka fatvelar ira rsuta lanun. ");
INSERT INTO frd_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ba Yesus norat ewal ira ne, “Mia mdyava iki?” Ira rfalak ne, “Amdava Yesus i ntali Nazaret.” ");
INSERT INTO frd_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yesus nfalak ne, “Ufalak roak verin mia ne, Yaꞌa ini tamata i mdyava a. Ba wean i mdyava urun Yaꞌa, na msyiꞌik watan Ning tamata ra ma rti.” ");
INSERT INTO frd_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Yesus nfalak wean inyai, boma nfakena afa ovi nfalak roak ne, “Tamata ovi mala roak ira verin Yaꞌa, na wol isa tali ira nmamu.” ");
INSERT INTO frd_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simon Petrus ntaha nahin blawat isa, ba ntavar nahin blawat yai ma nafat vatuk Mela Falurut Ilaꞌa ni tamata sansinir isa arun mela a. Sansinir yai naran Malkhus. ");
INSERT INTO frd_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ba Yesus nfalak verin Petrus ne, “Maꞌadoru ewal mu nahin blawat yai naꞌa ni tlanan a. Oa beta fwikir ne, wol utorung ma utuan susa i Yamang nfadoku roak ma musti utuan a?” ");
INSERT INTO frd_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Roma rira suldadu ra ovu rira dawan a, ovu vali tamata ovi rwanar Yahudi rira Rahan Dawan Falurut a, rtaha Yesus ma rkeak Ia. ");
INSERT INTO frd_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Nata rovun Ia rti lan Kayafas memin i Hanas a. Taꞌun yai Kayafas neluk Yahudi rira Mela Falurut Ilaꞌa. ");
INSERT INTO frd_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayafas nsurak lan roak dawan Yahudi ra ne, “Ni lolin a, tamata isa nmata verin tamata rivun.” ");
INSERT INTO frd_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simon Petrus ovu tamata isa vali tali Yesus Ni tamata ovi rorang Ia, rban-orang Yesus. Yahudi rira Mela Falurut Ilaꞌa nkaꞌa roak Yesus Ni tamata isa yai. Ba ia bisma norang Yesus ma nti Mela Falurut Ilaꞌa yai ni rahan ni lean a, ");
INSERT INTO frd_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","naꞌuk Petrus nanaban watan naꞌa balbelat ni falfolat murin a. Yesus Ni tamata yai newal ia nti murin ma nangrihi ovu vata i nwanar falfolat a, ma novun Petrus nti ralan. ");
INSERT INTO frd_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ba vata yai nfalak verin Petrus ne, “Betane oa morang vali tamata yai?” Petrus nfalak ne, “Wahal!” ");
INSERT INTO frd_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Naꞌut inyai na radridin urun, ba Mela Falurut Ilaꞌa ni tamata sansinir ra ovu tamata ovi baꞌi rwanar Yahudi rira Rahan Dawan Falurut a, rsidovuk yafu ma rdiri rafraran. Petrus nti vali ma irmunuk rafraran naꞌa inyai. ");
INSERT INTO frd_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Mela Falurut Ilaꞌa yai norat Yesus naꞌa Ni tamata ovi rorang Ia ovu Ni afa ovi nair ra. ");
INSERT INTO frd_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yesus nfalak ne, “Yaꞌa baꞌi udiri tamata rivun waharira ralan ra ma ungrihi. Yaꞌa usiair lalawatan naꞌa rahan falurut ovu Rahan Dawan Falurut i tamata Yahudi ra munuk baꞌi rasdovu ira naꞌa. Yaꞌa wol mane ungrihi fanfonak watan. ");
INSERT INTO frd_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Afakinimi morat Yaꞌa? Morat watan tamata ovi rarenar roak afa ovi air ra. Ira rkaꞌa urun afa ovi ufalak roak a.” ");
INSERT INTO frd_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Naꞌut i Yesus nfalak wean inyai, na tamata isa tali tamata ovi baꞌi rwanar Yahudi rira Rahan Dawan Falurut a, ntafitil Yesus ma nfalak ne, “Mubrahi urun ma mungrihi wean inyai verin Mela Falurut Ilaꞌa!” ");
INSERT INTO frd_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ba Yesus nfalak ne, “Wean i afa i ufalak yai sala, na eka fwalak Ning sala a, naꞌuk wean i afa i ufalak yai kena, na afakinimi mtafitil Yaꞌa?” ");
INSERT INTO frd_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Nata Hanas nsinir ma rovun Yesus nti verin Kayafas i neluk Mela Falurut Ilaꞌa yai. Yesus liman a natkeak obin. ");
INSERT INTO frd_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simon Petrus nafraran obin, ba tamata ovi rnaꞌa inyai rfalak verin ia ne, “Betane oa morang vali Ia?” ");
INSERT INTO frd_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Simon Petrus nalak ia ma nfalak ne, “Wahal.” Ba Mela Falurut Ilaꞌa ni tamata sansinir i lan a Petrus nafat vatuk arun a, ni tiniman isa nfalak ne, “Inlangin a, urea roak oa mimunuk Yesus mnyaꞌa vaꞌi yai.” ");
INSERT INTO frd_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Petrus nalak ewal ia ma nfalak ne, “Wahal.” Naꞌut inyai, na manut isa nkukuwai lahir. ");
INSERT INTO frd_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Varverak sumatan obin, na dawan Yahudi ra rovun roak Yesus tali Kayafas ni rahan a rti Gubernur ni rahan a. Naꞌuk dawan Yahudi avyai wol rti Gubernur ni rahan ralan a, tevek wol mane rfangra tenarira ra, wean rira adat nfalak a. Rotu wean inyai, tevek ira mane rovu ma rafnaꞌan naꞌa rira amar dawan Paskah. ");
INSERT INTO frd_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ba Gubernur Pilatus nti murin ma norat ira ne, “Mia myangadu tamata ini, tevek Ni sala aka?” ");
INSERT INTO frd_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ira rfalak ne, “Wean i wol Ni sala, na wol amovun Ia nma verin oa!” ");
INSERT INTO frd_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilatus nfalak verin ira ne, “Myala Ia miti ma kaꞌi fyaleka inukun verin Ia, ma inovan ovu bira inukun a.” Naꞌuk tamata Yahudi avyai rfalak ne, “Ami wol mami ngrebat ma amfaleka inukun matmatan verin tamata.” ");
INSERT INTO frd_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Afa yai nvotuk, boma nfakena afa ovi Yesus nfalak roak naꞌa Ni matmatan a. ");
INSERT INTO frd_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilatus newal ia nti ni rahan ralan a, nata nera Yesus ma norat Ia ne, “Yahudi rira raja verin Oa?” ");
INSERT INTO frd_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesus nfalak ne, “Morat Yaꞌa wean inyai, na ntali ralam a, te tamata liak boku rfamalik roak Yaꞌa verin oa?” ");
INSERT INTO frd_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilatus nfalak ne, “Oa fwikir ne, yaꞌa ini tamata Yahudi yaꞌa? Tamata ovi rovun Oa mwa verin yaꞌa ini, inyai Mu tamata Yahudi ra, ovu Mu dawan mela falurut ra. Motu sala aka ma rovun Oa mwa ini?” ");
INSERT INTO frd_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesus nfalak ne, “Ning fareta wol ntali lanit ivavan a. Wean i Ning fareta ntali lanit ivavan a, na Ning tamata ra veka rotu ma vangoa-vanga, boma deka rala Yaꞌa verin tamata Yahudi ra. Naꞌuk Ning fareta a wol ntali lanit ivavan a.” ");
INSERT INTO frd_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ba Pilatus nfalak verin Ia ne, “Oa ini raja Oa?” Yesus nfalak ne, “Oa kaꞌi fwalak ne, Yaꞌa ini raja Yaꞌa. Rarali Yaꞌa naꞌa lanit ivavan ini, boma ufamalik afa ovi kena ra. Tamata iki watan ndava lalawatan afa ovi kena ra, na ia nrenar roak afa ovi ufalak ra.” ");
INSERT INTO frd_vpl VALUES ("JN18_38a","073_18_38a","JHN","18","38a","38a","Pilatus norat Ia ne, “Afa ovi kena ra, ihin aka?” ");
INSERT INTO frd_vpl VALUES ("JN18_38b","073_18_38b","JHN","18","38b","38b","Pilatus nfalak munuk wean inyai, na nti murin ewal ma nfalak verin tamata Yahudi ra ne, “Yaꞌa wol utuan sala akataka naꞌa Ia. ");
INSERT INTO frd_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Naꞌuk mia baꞌi myera verin yaꞌa, ma lokat varat naꞌut amar dawan Paskah, na ufatalik tamata isa tali buꞌi ralan. Ba mtyorung ma ufatalik Yahudi rira raja ini verin mia?” ");
INSERT INTO frd_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ira rafwak ma rfalak ne, “Deka fwatalik Ia, naꞌuk fwatalik Barabas!” Barabas yai nwi-nwa tamata ra ma nbori rira metan ra. ");
INSERT INTO frd_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pilatus nangrihi munuk verin tamata Yahudi ra, beti nsinir ni suldadu ra ma rasveva Yesus. ");
INSERT INTO frd_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Suldadu avyai ranan aa anan ovi imarira ra ma naꞌa sabeꞌu ma rfadoku naꞌa Yesus ulun a. Ira rala ravit blawat ungu isa ma raꞌadoru naꞌa Ia, ");
INSERT INTO frd_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","beti rsikati ira ti rfaseri Yesus ma rfalak ne, “Yahudi rira raja verin Oa, ba fara nam a blawat!” Nata, rtafitil wahan a. ");
INSERT INTO frd_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilatus nti murin ewal ma nfalak verin tamata rivun avyai ne, “Eka msyiꞌik, yaꞌa ovun roak Ia nma verin mia, boma mkyaꞌa ne, wol utuan sala akataka naꞌa Ia.” ");
INSERT INTO frd_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ba rovun Yesus nti murin. Ia naklulu roak sabeꞌu iman yai, ovu noru roak ravit blawat ungu yai. Pilatus nfalak verin ira ne, “Eka msyiꞌik tamata ini!” ");
INSERT INTO frd_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ti ma Yahudi rira dawan mela falurut ra ovu tamata ovi rwanar Yahudi rira Rahan Dawan Falurut a rsiꞌik Yesus, na rafwak ma rfalak ne, “Bwaku Ia naꞌa aa walwalur! Bwaku Ia naꞌa aa walwalur!” Pilatus nfalak verin ira ne, “Mia kaꞌi myala Ia ma byaku Ia naꞌa aa walwalur, tevek yaꞌa wol utuan lahir sala akataka naꞌa Ia.” ");
INSERT INTO frd_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Tamata Yahudi avyai rfalak verin Pilatus ne, “Ami mami inukun vali, ovu naꞌa mami inukun a nfadoku ne, Ia musti nmata, tevek nfalak ne, Ubu Yanan Ia.” ");
INSERT INTO frd_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Naꞌut i Pilatus nrenar i rfalak wean inyai, na ia ntafal ma nbobar. ");
INSERT INTO frd_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ba Pilatus newal ia nti ni rahan fareta dawan ralan a. Ti ma rovun roak Yesus nti rahan yai ralan, na norat Yesus ne, “Oa mtali ahu inba?” Naꞌuk Yesus wol nvalat ia. ");
INSERT INTO frd_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilatus norat ewal Ia ne, “Oa mufena ma mungrihi nulu yaꞌa? Oa wol mkaꞌa ne, ning ngrebat ma ufatalik Oa, ovu ning ngrebat ma ufalak ma rbaku Oa naꞌa aa walwalur?” ");
INSERT INTO frd_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesus nfalak ne, “Wean i Ubu wol nala ngrebat yai verin oa, na oa wol mu ngrebat akataka ma fwareta Yaꞌa. Ba tamata i nala Yaꞌa verin oa, ni salasilan a veran rahi mu salasilan.” ");
INSERT INTO frd_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Naꞌut i Pilatus nrenar afa i Yesus nfalak yai, na ndava lingaꞌan mane nfatalik Ia. Naꞌuk tamata Yahudi avyai rafwak ewal ma rfalak ne, “Wean i fwatalik Ia, na oa veka wol motu kida roak ovu Kaisar. Tamata iki watan ntorung ne notu raja, na ia nangal roak Kaisar.” ");
INSERT INTO frd_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Naꞌut i Pilatus nrenar i tamata Yahudi ra rfalak wean inyai, na nsinir ma rovun Yesus nti murin, na ia ndoku kadera i baꞌi ndoku ma nfaleka inukun verin tamata ra. Wan yai naran Lantai Vatu, naꞌa vai Ibrani rfanara ia ne Gabata. ");
INSERT INTO frd_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Naꞌut inyai, na kaꞌa bi lera ndirlola. Amar yai, na tamata Yahudi ra rasusan warira ma ilyan, na rotu rira amar dawan Paskah. Pilatus nfalak verin tamata avyai ne, “Ini bira raja a!” ");
INSERT INTO frd_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Tamata avyai rafwak ma rfalak ne, “Fwedan Ia! Fwedan Ia! Bwaku Ia naꞌa aa walwalur!” Pilatus norat ira ne, “Yaꞌa musti utorung ma rbaku bira raja a naꞌa aa walwalur?” Yahudi rira dawan mela falurut ra rfalak ne, “Ami wol mami raja. Kaisar aꞌuk saꞌi notu raja verin ami!” ");
INSERT INTO frd_vpl VALUES ("JN19_16a","073_19_16a","JHN","19","16a","16a","Ba Pilatus nala Yesus verin ira, ma ti rbaku Ia naꞌa aa walwalur. ");
INSERT INTO frd_vpl VALUES ("JN19_16b","073_19_16b","JHN","19","16b","16b","Ba rala Yesus ma rovun Ia rti. ");
INSERT INTO frd_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Yesus kaꞌi nvara Ni aa walwalur a, ma nti wan i naran Kalkulun Wan. Naꞌa vai Ibrani rfanara ia ne, Golgota. ");
INSERT INTO frd_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Naꞌa wan yai, na rbaku Ia naꞌa aa walwalur. Ira rbaku vali tamata irua ovu Ia, ma isa naꞌa Ni lihir mela, na isa naꞌa Ni lihir balit, na Yesus naꞌa fruarira ra. ");
INSERT INTO frd_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilatus nsinir ira ma rtulis naꞌa kba etal isa, beti rbaku kba etal yai naꞌa aa walwalur ni tutul a. Vaivatul avyai ngoarira ne, “Yesus ntali Nasaret, Yahudi rira Raja verin Ia.” ");
INSERT INTO frd_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Tamata Yahudi rivun rbas roak vaivatul avyai, tevek wan i rbaku Yesus naꞌa aa walwalur yai nfaseri kota. Vaivatul avyai rtulis naꞌa vai Ibrani, vai Latin ovu vai Yunani. ");
INSERT INTO frd_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Yahudi rira dawan mela falurut ra rfalak verin Pilatus ne, “Deka mtulis ne, ‘Yahudi rira Raja verin Ia.’ Naꞌuk mtulis ne, ‘Ia nfalak ne Yahudi rira Raja verin Yaꞌa.’ ” ");
INSERT INTO frd_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Naꞌuk Pilatus nfalak ne, “Afa i ufalak ma rtulis roak yai, wol bisma rkati.” ");
INSERT INTO frd_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ti ma suldadu avyai rbaku roak Yesus naꞌa aa walwalur, beti rala Ni kadaravit ra ma rsiduk naꞌut ifaꞌat, ma sasan lokat ira. Ira rala vali Ni ravit blawat. Ravit blawat yai wol roar ia, naꞌuk redu falolang watan ia ma naꞌa near isa. ");
INSERT INTO frd_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ba suldadu avyai rsifalak afa verin ira ne, “Deka tkamsat ravit blawat yai, naꞌuk totu undi ma tkaꞌa ne, iki veka nia ravit blawat yai.” Wean inyai, boma nfakena afa ovi rtulis roak naꞌa Surat Ralan ne, “Ira rsiduk Ning kadaravit ra lokat ira, ovu rotu undi naꞌa Ning ravit blawat a.” Ba suldadu avyai rotu wean inyai. ");
INSERT INTO frd_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Yesus renan a, ovu Yesus renan warin a, ovu Maria i awan verin Klopas, ovu Maria Magdalena rdir-ebang aa walwalur i rbaku Yesus naꞌa. ");
INSERT INTO frd_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Naꞌut i Yesus nsiꞌik Ni tamata i norang Ia ovu nlobang urun ia ndiri inyai ovu renan a, na nfalak verin renan a ne, “Mama, inyai yanam a!” ");
INSERT INTO frd_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Nata Yesus nfalak verin Ni tamata i norang Ia yai ne, “Inyai renam a!” Tali amar yai, na Ni tamata yai ntorung ma nala Yesus renan a ma nanaꞌa ni rahan a. ");
INSERT INTO frd_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yesus nkaꞌa ne, fiang ini Ia notu munuk roak karya ovi Ubu nala verin Ia. Ba nfalak ne, “Yaꞌa ubroa.” Nfalak wean inyai ma nfakena afa ovi rtulis roak naꞌa Surat Ralan. ");
INSERT INTO frd_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Naꞌa wan yai, na moko isa nngora ovu anggur i nakbia a. Ba rala spons etal isa ma rsovu naꞌa anggur yai, ma rngatan teri spons yai naꞌa aa etal isa ni tutul a, ma rlauk rata nkena Yesus sumarn a. ");
INSERT INTO frd_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ti ma Yesus nbuk roak anggur yai, na nfalak ne, “Roak rok.” Ba nsoak wahan a, na nan a nakbosal. ");
INSERT INTO frd_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Naꞌut inyai, na tamata Yahudi ra rasusan warira ma ilyan, na ryari ira. Ira rira adat notu teri ma tamata ovi rbaku roak ira naꞌa aa walwalur, wol bisma rakloꞌi watan naꞌa amar i ryari ira. Nlia tali inyai, na amar i ryari ira yai neluk amar dawan verin ira. Ba dawan Yahudi ra rera verin Pilatus ma nsinir suldadu ra ma rkametal tamata ovi rbaku ira yai earira ra, ma rfasuka ira tali aa walwalur ra. ");
INSERT INTO frd_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Nata suldadu avyai rti ma rkametal lan tamata irua i rbaku ira ovu Yesus, earira ra. ");
INSERT INTO frd_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Naꞌuk ti ma rfaseri Yesus, ma rsiꞌik na nmata roak, ba wol rkametal ean a. ");
INSERT INTO frd_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Naꞌuk suldadu isa nsungu Yesus nelan ovu vunut, ma laran a ovu wear nvoat lahir. ");
INSERT INTO frd_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Tamata i nsiꞌik afa yai kaꞌi nfamalik afa i nsiꞌik yai. Ia nkaꞌa ne, afa ovi nfalak ra kena ma nfamalik afa avyai, boma myorang vali. ");
INSERT INTO frd_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Suldadu avyai wol rkametal Yesus ean a, boma nfakena afa ovi rtulis roak naꞌa Surat Ralan ne, “Tali lurin ra, na wol isa vali nametal.” ");
INSERT INTO frd_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Rtulis vali roak naꞌa Surat Ralan wean ini, “Tamata ra veka rsiꞌik Ia naꞌut i rsungu roak Ia.” ");
INSERT INTO frd_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Afa avyai roak munuk roak, beti tamata isa naran Yusuf ntali ahu Arimatea nti ma ntuan Pilatus ma nera verin ia ma nala Yesus tenan a. Yusuf norang vali Yesus, naꞌuk norang fanfonak Ia, tevek nbobar dawan Yahudi ra. Pilatus ntorung afa i Yusuf nfalak a, ba Yusuf nti ma nfasuka Yesus tenan a. ");
INSERT INTO frd_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodemus i lan a ti ntuan roak Yesus naꞌut ovan a, novu vali Yusuf. Ia ntaha ngul ovi voarira lolin urun a nararira mur ovu gaharu. Rsileti roak ngul avyai, ma kaꞌa bi kil vututelu. ");
INSERT INTO frd_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ira rala Yesus tenan a ma rkuma Ia ovu maloli ngangiar, ovu raslofi ngul ovi voarira lolin avyai ma rot-orang Yahudi rira adat a verin tamata matmatan ra. ");
INSERT INTO frd_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Naꞌa wan i rbaku Yesus naꞌa aa walwalur, na vaꞌi isa nfaseri inyai. Naꞌa vaꞌi yai, na van matmatan isa nanaꞌa. Van yai ngorvaꞌan obin, tevek wol rfanuba matmatan ra naꞌa obin. ");
INSERT INTO frd_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Naꞌut inyai, na tamata Yahudi ra rasusan warira ma rsaꞌa amar i mane ryari ira. Ba Yusuf irua Nikodemus rti ma rfanuba Yesus tenan a naꞌa van yai ralan a, tevek nfaseri inyai. ");
INSERT INTO frd_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Naꞌut amar kareda, na Maria Magdalena nti van matmatan i rfanuba Yesus tenan a. Naꞌut inyai, na manut ra vair iwarin obin. Ia nsiꞌik vatu dawan i rala al rulang van yai ngoran a natsuar roak. ");
INSERT INTO frd_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ba ia nafla ma ti ntuan Yesus Ni tamata irua: Simon Petrus ovu Yesus Ni tamata isa i norang Ia ovu nlobang urun ia. Maria nfalak verin ira ne, “Tamata ra rala roak Duilaꞌa tali van matmatan, ovu wol amkaꞌa ne, rfadoku Ia naꞌa inba.” ");
INSERT INTO frd_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Petrus ovu Yesus Ni tamata liak isa i norang Ia yai rti van yai. ");
INSERT INTO frd_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Irua rafla, naꞌuk Yesus Ni tamata liak isa i norang Ia yai nafla lia Petrus, ba naran lan van yai, beti Petrus. ");
INSERT INTO frd_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ia nsoak ia ma nsiꞌik nti ralan, na nrea maloli i rala ala rkuma Yesus naꞌa inyai, naꞌuk wol nti ralan. ");
INSERT INTO frd_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simon Petrus nma vali ma nti lahir van yai ralan a. Ia nsiꞌik, na maloli i rala al rkuma Yesus nanaꞌa inyai. ");
INSERT INTO frd_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Naꞌuk maloli i rala al rkeak Yesus ulun a wol nanaꞌa ebang roak maloli i rala al rkuma Ia. Maloli yai natlulung roak ma naꞌa wan liak. ");
INSERT INTO frd_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ba Yesus Ni tamata i naran lan van yai, nti vali ralan, ma nsiꞌik munuk afa avyai, beti norang ne, Yesus nvaꞌat ewal roak. ");
INSERT INTO frd_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ira wol rfan-aran obin Surat Ralan ihin a ne, Ia musti nvaꞌat ewal tali matmatan. ");
INSERT INTO frd_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ba Yesus Ni tamata irua ovi rorang Ia yai rewal ira rti rira rahan ra. ");
INSERT INTO frd_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maria Magdalena ndir-ebang van yai ma nvakar. Naꞌut i nvakar, na nsoak ia ma nsiꞌik nti van yai ralan, ");
INSERT INTO frd_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","na nrea Ubu Ni sansinir irua tali lanit ratan reluk kadaravit ngangiar, ma rdoku wan i rfanuba Yesus tenan a naꞌa. Isa ndoku wan i Yesus ulun nanaꞌa, na isa vali ndoku wan i ean a rnaꞌa. ");
INSERT INTO frd_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ba sansinir avyai rorat Maria ne, “Afakinimi bwakar?” Maria nfalak ne, “Tamata rala roak ning Duilaꞌa, ba wol ukaꞌa ne rfadoku Ia naꞌa inba.” ");
INSERT INTO frd_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ia nfalak munuk wean inyai, na nfulak ia ma nsiꞌik, na Yesus ndiri murin a, naꞌuk wol nkaꞌa ne inyai Yesus. ");
INSERT INTO frd_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yesus nfalak verin ia ne, “Afakinimi bwakar? Oa mdava iki?” Maria nanarin ne, inyai tamata i baꞌi nwanar vaꞌi a, ba nfalak verin ia ne, “Bapa, wean i mala Yesus tenan a, na fwalak verin yaꞌa ne, fwadoku Ia naꞌa inba, boma ti ala Ia.” ");
INSERT INTO frd_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesus nfalak verin ia ne, “Maria!” Ba Maria nfulak wahan a ma nfalak naꞌa vai Ibrani ne, “Rabuni!”, ihin a Guru. ");
INSERT INTO frd_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesus nfalak verin ia ne, “Deka mtaha Yaꞌa, tevek wol urata verin Yamang obin. Muti ma mtuan terang a valing ra ma fwalak verin ira ne, ‘Yaꞌa veka uti verin Yamang a ovu Yamabira a, ovu vali verin Ning Ubu a ovu bira Ubu a.’ ” ");
INSERT INTO frd_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Maria Magdalena newal ia ma nfalak verin Yesus Ni tamata ovi rorang Ia ne, “Yaꞌa urea roak Duilaꞌa!” Ia nfalak afa ovi Yesus nfalak ra verin ira. ");
INSERT INTO frd_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Naꞌut i amar kareda ma ni lervava a, na Yesus Ni tamata ovi rorang Ia rasdovu ira naꞌa rahan isa, ba rkus-teri munuk falfolat ra, tevek rbobar dawan Yahudi ra. Brian munuk, na Yesus ndiri fruarira ra ma nfalak verin ira ne, “Fara Ubu notu ma bira vavaꞌat ra malinan watan!” ");
INSERT INTO frd_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ia nfalak munuk wean inyai, beti nfaturu liman a ovu nelan i rsungu a verin ira. Naꞌut i rsiꞌik Duilaꞌa, na ralar lolin urun. ");
INSERT INTO frd_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ba Yesus nfalak fasa ewal verin ira ne, “Fara Ubu notu ma ralabira ra malinan watan! Inyai wean lahir i Yamang nsinir Yaꞌa ovu vali Yaꞌa usinir mia.” ");
INSERT INTO frd_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ia nfalak munuk wean inyai, beti nafraik nan nti verin ira, ma nfalak ne, “Myala Ubu Ni Roh a naꞌa ralabira ra. ");
INSERT INTO frd_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Wean i myabun roak tamata isa ni salasilan ra, na Ubu veka naꞌi vatuk vali tamata yai ni salasilan ra. Naꞌuk wean i wol myabun ni salasilan ra, na Ubu veka wol naꞌi vatuk vali ni salasilan ra.” ");
INSERT INTO frd_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Naꞌut i Yesus nfavotuk Ia verin Ni tamata ovi rorang Ia, na Tomas i rfanara ia ne, Didimus wol nanaꞌa ovu ira. Ia ntali vali Yesus Ni tamata vutu rahin irua ovi rorang Ia. ");
INSERT INTO frd_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ba Yesus Ni tamata ra rfalak verin ia ne, “Ami amsiꞌik roak Duilaꞌa!” Naꞌuk ia nfalak verin ira ne, “Wean i wol urea paku wan naꞌa liman a, ovu wol ufadoku limang tanan ra naꞌa paku wan avyai, ovu vali wol ufadoku limang a naꞌa nelan i rsungu a, na yaꞌa wol orang lahir.” ");
INSERT INTO frd_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Kareda ralan isa nelak roak, beti Yesus Ni tamata ovi rorang Ia rasdovu ewal ira naꞌa rahan yai, na Tomas novu vali ira. Ira rkus-teri munuk falfolat ra, naꞌuk brian munuk, na Yesus ndiri fruarira ra ma nfalak ne, “Fara Ubu notu ma bira vavaꞌat ra malinan watan!” ");
INSERT INTO frd_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Nata Yesus nfalak verin Tomas ne, “Msiꞌik limang a ovu fwadoku limam a naꞌa paku wan ovi. Mlauk limam a ma fwadoku naꞌa nelang i rsungu a, boma deka ralam raruan, ma morang lahir Yaꞌa!” ");
INSERT INTO frd_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomas nfalak ne, “Yaꞌa ning Duilaꞌa ovu ning Ubu verin Oa!” ");
INSERT INTO frd_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yesus nfalak verin ia ne, “Oa msiꞌik roak Yaꞌa bi morang. Lolin urun verin tamata ovi wol rarea Yaꞌa, naꞌuk rorang watan.” ");
INSERT INTO frd_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesus Ni tamata ovi rorang Ia rsiꞌik Ni mujizat liak rivun vali, naꞌuk wol rtulis mujizat avyai naꞌa kitab ini. ");
INSERT INTO frd_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Naꞌuk utulis afa ovi Yesus notu ra naꞌa kitab ini, boma myorang ne, Ia Raja i ntevut dida salasilan ra, Ubu Yanan Ia. Wean i myorang Ia, na veka bira vavaꞌat kakiwal. ");
INSERT INTO frd_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Yesus notu munuk wean inyai, beti nfavotuk ewal vali tenan a verin Ni tamata ovi rorang Ia naꞌa danau Tiberias nelan a. Ia nfavotuk tenan a wean ini: ");
INSERT INTO frd_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Naꞌa danau yai nelan a, na Simon Petrus, Tomas i rfanara ia ne Didimus, Natanael i ntali ahu Kana i naꞌa Galilea, ntafal vali Zebedeus yanan irua ovu Yesus Ni tamata irua ovi rorang vali Ia, rasdovu ira naꞌa inyai. ");
INSERT INTO frd_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ba Simon Petrus nfalak verin ira ne, “Yaꞌa mane ti udava ian.” Ira rfalak verin ia ne, “Amorang vali oa.” Ba irmunuk rti ma rdata kumal a, beti raroal ma rdava ian naꞌa danau yai. Naꞌuk tali ovan lolan yai, na wol rwadar akataka. ");
INSERT INTO frd_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ti ma lera wol ndata obin, na Yesus ndiri roak ngur ratan, naꞌuk ira wol rkaꞌa ne inyai Yesus. ");
INSERT INTO frd_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Yesus norat ira ne, “Baba averi, myadar te wahal?” Ira rfalak ne, “Wol amwadar.” ");
INSERT INTO frd_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Yesus nfalak verin ira ne, “Fyasuka bira jaring a naꞌa kumal ni lihir mela a, na veka myadar.” Ba rfasuka rira jaring a. Ti ma rfar rira jaring a, na wol rfar nala, tevek nala ma ian rivun urun i lahir. ");
INSERT INTO frd_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ba Yesus Ni tamata i nlobang urun ia yai nfalak verin Petrus ne, “Inyai, Duilaꞌa!” Ti ma Petrus nrenar ne, inyai Duilaꞌa, na noru ni ravit a, tevek wol noru ravit, beti nwatil nsuta danau yai ma nra. ");
INSERT INTO frd_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Yesus Ni tamata ovi rorang Ia rorang Petrus rara ovu rira kumal. Ira wol kaꞌi raroa tali danau nelan a, kaꞌa bi meter ratut isa watan, ba rving jaring i nngora lahir ovu ian ra. ");
INSERT INTO frd_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ti ma rda raran ngur roak, na rsiꞌik ian ovu roti ra naꞌa yafaran ratan a. ");
INSERT INTO frd_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yesus nfalak verin ira ne, “Mtyaha bira ian boku tali ian ovi beti myot-nala avyai mya.” ");
INSERT INTO frd_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simon Petrus ndata kumal a ma nving jaring a nra. Jaring yai nngora lahir ovu ian dawan ratut isa vutlima rahin itelu. Velik ne ian rivun, naꞌuk rira jaring a wol namsat. ");
INSERT INTO frd_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesus nfalak verin ira ne, “Mya ma tafnaꞌan kikyai.” Tali Yesus Ni tamata avyai, na wol tamata isa vali nabrahi ma norat Ia ne, “Oa ini iki?” Tevek rkaꞌa roak ne, inyai Duilaꞌa. ");
INSERT INTO frd_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yesus nti ma nala lan roti verin ira, beti nala vali ian ra. ");
INSERT INTO frd_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Tali amar i Yesus nvaꞌat ewal tali matmatan, na nfavotuk nala fatelu roak tenan a verin Ni tamata ovi rorang Ia. ");
INSERT INTO frd_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ti ma rafnaꞌan munuk, na Yesus nfalak verin Simon Petrus ne, “Simon, Yohanes yanan oa. Oa mlobang Yaꞌa nlia tali ira?” Petrus nfalak ne, “Kena ta Duilaꞌa. Oa mkaꞌa lahir ne, yaꞌa ulobang Oa.” Yesus nfalak verin ia ne, “Fwaꞌan ma lolin Ning domba yanat ra.” ");
INSERT INTO frd_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yesus norat ewal ia ma farua roak ne, “Simon, Yohanes yanan oa. Oa mlobang Yaꞌa?” Petrus nfalak ne, “Kena ta Duilaꞌa. Oa mkaꞌa ne, yaꞌa ulobang Oa.” Yesus nfalak verin ia ne, “Mwanar ma lolin Ning domba ra.” ");
INSERT INTO frd_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Yesus norat ewal ia ma fatelu roak ne, “Simon, Yohanes yanan oa. Oa mlobang Yaꞌa?” Petrus ralan lalau, tevek Yesus norat fatelu ia roak ne, “Oa mlobang Yaꞌa?” Ba Petrus nfalak ne, “Duilaꞌa, Oa mkaꞌa munuk afakataka. Oa mkaꞌa ne, yaꞌa ulobang Oa.” Yesus nfalak verin ia ne, “Fwaꞌan ma lolin Ning domba ra. ");
INSERT INTO frd_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Afa i ufalak verin oa ini, kena urun! Naꞌut i varverun oa obin, na kaꞌi mkeak twalam a ma bwana muti inba watan, wean ralam nfalak a. Naꞌuk wean i itrana roak oa, na veka mlauk limam ra, ma tamata ra rkeak oa ma rovun oa rti wan i wol inam ma muti a.” ");
INSERT INTO frd_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yesus nala vaivatul ovi ma nfaturu ne, wean inba ma Petrus veka nmata ma nfaturu Ubu Ni dawan a. Ia nfalak munuk wean inyai, na nfalak verin Petrus ne, “Morang Yaꞌa.” ");
INSERT INTO frd_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Naꞌut i Petrus nfulak ia ma nsiꞌik, na Yesus Ni tamata i norang Ia ovu nlobang urun ia, nban-orang ira. Tamata yai, Yesus Ni tamata i ndok-ebang Ia naꞌut i irmunuk rafnaꞌan ma norat Yesus ne, “Duilaꞌa, tamata iki veka nfedi Oa?” ");
INSERT INTO frd_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Petrus nsiꞌik Yesus Ni tamata i nlobang urun ia yai, na nfalak verin Yesus ne, “Duilaꞌa, wean inba ovu tamata ini?” ");
INSERT INTO frd_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesus nfalak ne, “Wean i ralang nfalak ma nvaꞌat nata ti naran i ewal Yaꞌa, na deka fwikir afa yai! Naꞌuk morang Yaꞌa.” ");
INSERT INTO frd_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ba ivar yai ti nsoru Yesus Ni tamata ovi rorang Ia, ma rfikir ne, Ni tamata yai veka wol nmata. Naꞌuk Yesus wol nfalak verin Petrus ne, Ni tamata yai veka wol nmata. Velik aba, Ia nfalak ne, “Wean i ralang nfalak ma nvaꞌat, nata ti naran i ewal Yaꞌa, na deka fwikir afa yai.” ");
INSERT INTO frd_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Yesus Ni tamata yai nsiꞌik ovu nfamalik afa ovi Yesus notu ra, ma ntulis afa avyai naꞌa kitab ini. Ita tkaꞌa ne, afa ovi nfalak ra kena. ");
INSERT INTO frd_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yesus notu vali ma afa liak rivun ilaꞌa matan, naꞌuk wean i musti rtulis munuk lahir afa avyai, na ufikir ne, lanit ivavan a veka wol nsaꞌa nala kitab avyai.");
INSERT INTO frd_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Kida Teofilus, naꞌa ning kitab i ususan lan a, ufamalik munuk roak afa ovi Yesus notu ovu nair ra, ");
INSERT INTO frd_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ti naran amar i Ubu notu ma Yesus nrata lanit ratan. Yesus wol nrata lanit ratan obin, na Ubu Ni Roh nala ngrebat verin Ia, ma nsurak Ni rasul ovi nfili ra. ");
INSERT INTO frd_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Tamata ra rotu sian Ia ma rfedan Ia, naꞌuk nvaꞌat ewal. Ia notu ma faneak rivun ovu nfavotuk ma rivun tenan a verin rasul ra, ti naran amar vutfaꞌat, boma rkaꞌa basil ne, Ia nvaꞌat ewal roak. Ia nfamalik verin ira naꞌa i wean inba ma Ubu nfareta tamata ra wean lahir Raja. ");
INSERT INTO frd_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Amar isa, na irmunuk Yesus rasdovu ira ma rafnaꞌan, ma nfalak ne, “Deka miti talik Yerusalem veki, ma mnyaban watan naꞌa ini, ti naran i Ubu nfakena Ni tnorung a ma nala Ni Roh verin mia. Yaꞌa ufamalik lan roak Ubu Ni Roh verin mia. ");
INSERT INTO frd_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yohanes nbaptis tamata ra ovu wear watan, naꞌuk wol mnanat, na Ubu veka nbaptis mia ovu Ni Roh.” ");
INSERT INTO frd_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Naꞌut i rasul ra rasdovu ira, na rorat Yesus ne, “Duilaꞌa, fiang ini mane fwatalik ami tali Roma ni fareta ma fwadiri ewal Israel ni fareta?” ");
INSERT INTO frd_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yesus nfalak verin ira ne, “Yamang saꞌi nfadoku amar yai ovu Ni ngrebat a. Mia wol bisma mkyaꞌa. ");
INSERT INTO frd_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Naꞌuk Ubu Ni Roh veka nleal mia ma nala ngrebat verin mia. Naꞌut inyai, na veka ti fyamalik Yaꞌa naꞌa Yerusalem, propinsi Yudea munuk ovu Samaria, ti nsoru munuk lanit ivavan a.” ");
INSERT INTO frd_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Yesus nfalak munuk afa yai verin ira, na rsiꞌik lahir i Ubu notu ma nrata lanit. Ia nrata ma mutan nteri ma wol rarea roak Ia. ");
INSERT INTO frd_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ira rtadata rata lanit obin, na brian munuk, na brana irua roru kadaravit ngangiar rdir-ebang ira. ");
INSERT INTO frd_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Irua rfalak ne, “Tamata Galilea averi, notu afakinimi mdyiri ini ma mtyadata mirata lanit i? Amar isa, na Yesus i Ubu notu ma nrata lanit ratan yai veka newal Ia, wean i beti mryea Ia nrata lanit ratan.” ");
INSERT INTO frd_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Nata rasul ra rewal ira tali vuar Zaitun rti Yerusalem. Ntali vuar ini nti Yerusalem kil isa teran. ");
INSERT INTO frd_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Rewal ira ti raran rahan i rnaꞌa teri naꞌa Yerusalem, na rarata kamar i naꞌa ratan. Tamata ovi rnaꞌa inyai nararira: Petrus, Yohanes, Yakobus, Andreas, Filipus, Tomas, Bartolomeus, Matius, Yakobus i yaman Alfeus, Simon i ntali sidovung Zelot ovu Yudas i yaman a naran vali Yakobus. ");
INSERT INTO frd_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Rir tinemun ralarira isa ma rasdovu ira lalawatan al raflurut. Irmunuk vata boku ovu Yesus renan ovu vali Yesus warin ra. ");
INSERT INTO frd_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Naꞌut inyai, na Petrus ti ndiri tamata ovi rorang Yesus fruarira ra. Naꞌa wan yai, na tamata kaꞌa bi ratut isa vutrua. ");
INSERT INTO frd_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Ia nfalak ne, “Terang a valing averi, Ubu nfakena roak afa ovi Raja Daud ntulis naꞌa Surat Ralan. Lalan ana, Ubu Ni Roh nangrihi ovu Daud ma nfamalik Yudas i nban-ulu verin tamata ovi rtaha Yesus. ");
INSERT INTO frd_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yudas ini lan a itmunuk vali, tevek Yesus nfili ia ma neluk rasul.” ");
INSERT INTO frd_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Yudas nala kubang i Yahudi ra rala verin ia tevek nfedi Yesus, ma al nfaha lanun. Naꞌa lanun yai, na nleka fangofak ia, ma nmata. Evun a nakfefar lahir ovu tnean ra rma murin. ");
INSERT INTO frd_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Tamata ovi rnaꞌa Yerusalem ra munuk rkaꞌa afa ini, ba rfanara lanun yai naꞌa rira vai ne, “Hakal-Dama.” Ihin a ne, lanun i tamata laran a nvoat naꞌa.) ");
INSERT INTO frd_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Petrus ntafal ma nfalak ne, “Raja Daud ntulis naꞌa kitab Mazmur ne, ‘Ni lolin ana, ni rahan a vu watan ma deka tamata isa ti nleal.’ Daud ntulis vali ne, ‘Ni lolin ana, tamata liak nkati ia naꞌa ni van a.’ ");
INSERT INTO frd_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Ba did tinemun, ita musti tfili brana isa ma nkati Yudas. Tamata yai norang lalawatan ita naꞌut i Duilaꞌa Yesus nvaꞌat obin, ");
INSERT INTO frd_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","ntali amar ovi Yohanes nbaptis tamata ra, ti naran amar i Ubu notu ma Yesus nti talik ita ma nrata lanit ratan. Tamata i veka tfili ia yai musti nkarya ovu ita ma nfamalik ne, Yesus nvaꞌat ewal roak.” ");
INSERT INTO frd_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Nata rir tinemun rfaturu tamata irua. Isa naran Yusuf i boku rfanara ia ne Barsabas, ovu vali boku rfanara ia ne Yustus, ovu tamata isa vali naran Matias. ");
INSERT INTO frd_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ira raflurut ma rfalak ne, “Duilaꞌa Yesus, Oa mkaꞌa munuk tamata ralarira ra. Ba fara fwaturu verin mam tinemun naꞌa tamata irua ini ne, ralam nfalak iki, ");
INSERT INTO frd_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","boma neluk rasul ma nkati Yudas i nti talik roak ni karya i mala verin ia, ba nti wan i inovan ovu afa i notu.” ");
INSERT INTO frd_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Nata rotu undi naꞌa irua nararira ra, na Matias naran nvotuk, ba nti ma ntafal rasul vutu rahin isa yai. ");
INSERT INTO frd_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ti naran amar dawan Pentakosta, na tamata ovi rorang Yesus rasdovu munuk ira naꞌa wan isa. ");
INSERT INTO frd_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Brian munuk, na rarenar afa isa ngoan wean nait dawan ilaꞌa tali lanit nsuta ma nsoru munuk lahir naꞌa rahan i rdoku a. ");
INSERT INTO frd_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Nata rarea afa ovi wean yafongan ra ma felarira ra wean tamata earn. Yafongan ra rsialing ira ma ti rturat tamata ra munuk. ");
INSERT INTO frd_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ubu Ni Roh a ti ma nsoru lahir ralarira ra, ba betfasa rangrihi ovu vai ovi wol rkaꞌa ra, tevek Ubu Ni Roh a notu ma rangrihi. ");
INSERT INTO frd_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Naꞌut inyai, na Yahudi ovi rot-orang afa ovi Ubu ralan nfalak ra rtali negara munuk naꞌa lanit ivavan a rnaꞌa Yerusalem. ");
INSERT INTO frd_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Naꞌut i rarenar afa ngoan dawan i wean a nait yai, na tamata rivun rasdovu ira. Yahudi avyai rtalkaka, tevek rarenar tamata ovi rorang Yesus rala rira vai ra al rangrihi. ");
INSERT INTO frd_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ira rtalkaka lahir ma rfalak ne, “Yaꞌi yo, ita tkaꞌa roak ne, tamata ovi rangrihi ini rtali munuk Galilea! ");
INSERT INTO frd_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Wean inba ma ita trenar ira rala dida vai ra al rangrihi? ");
INSERT INTO frd_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Boku tatali Partia, Media, Elam, Mesopotamia, Yudea, Kapadokia, Pontus, Asia, ");
INSERT INTO frd_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigia, Pamfilia, Mesir ovu wan ovi rnaꞌa Libia ma rfaseri kota Kirene. Boku vali tatali kota Roma. ");
INSERT INTO frd_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ita boku tamata Yahudi ovu boku vali wol Yahudi ira, naꞌuk rorang roak dida agama. Boku vali tatali Kreta ovu Arab, naꞌuk trenar ira rala dida vai ra ma rfamalik afa dawan ovi Ubu notu ra!” ");
INSERT INTO frd_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Rir tinemun rtalkaka ovu wol rkaꞌa ma raroal te rara, ba rsiorat ira ne, “Afa ini ihin aka?” ");
INSERT INTO frd_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Naꞌuk tamata boku rangrihi lablabir ira ma rfalak ne, “Tamata avyai renu anggur ma ranavut watan!” ");
INSERT INTO frd_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ba Petrus ndiri ovu rasul vutu rahin isa yai ma nangrihi verin tamata rivun avyai ovu vain dawan ma nfalak ne, “Terang a valing Yahudi averi ovu tamata ovi mnyaꞌa Yerusalem! Eka mryenar ma lolin afa ovi veka ufalak verin mia. ");
INSERT INTO frd_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Mia mnyarin ne, tamata ovi ranavut. Wahal, tevek lera ndata roak, naꞌuk wol kaꞌi ngnea obin! ");
INSERT INTO frd_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Naꞌuk afa ovi beti mryea yai, Ubu nfalak lan roak verin nabi Yoel ma ntulis ne, ");
INSERT INTO frd_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Ubu nfalak ne, ‘Amar ra mane rlia roak, ba Yaꞌa veka ala Ning Roh verin tamata ra munuk. Ba yanabira vata ovu brana ra veka rarenar lahir tali Yaꞌa ma ti rfamalik Ning vaivatul ra, ovu bira varverun ra veka wean i ramifi naꞌuk wol rtub-lufa, ovu itrana ra veka ramifi lahir. ");
INSERT INTO frd_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Naꞌa amar avyai, na veka ala lahir Ning Roh verin Ning sansinir vata ra ovu brana ra, boma ira ki rfamalik afa ovi rarenar lahir tali Yaꞌa. ");
INSERT INTO frd_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Yaꞌa veka otu mujizat ra naꞌa lanit ovu faneak ovi tamata ra wol rot-nala naꞌa lanit ivavan a; veka lara, yafu, ovu yafuman nafkoval. ");
INSERT INTO frd_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Lera veka wol vanan lahir, ovu vulan veka navuli ma wean lara, beti Duilaꞌa Ni amar dawan nma. Naꞌa amar yai, na Ia veka nma ma nfavotuk Ni ngrebat a. ");
INSERT INTO frd_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Tamata ovi rera lablobang verin Duilaꞌa, na Ia veka nsikat ira tali rira salasilan ra, ma rira vavaꞌat kakiwal.’ ");
INSERT INTO frd_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Terang a valing Israel averi, eka mryenar afa ovi ufalak ini! Yesus i ntali ahu Nazaret yai, Ubu nsinir roak Ia ma nma verin mia. Ubu nala ngrebat verin Ia ma notu mujizat ra ovu faneak ovi tamata ra wol rot-nala, ovu vali nfaturu Ni ngrebat a ma tamata ra rtalkaka. Bir tinemun mkyaꞌa roak afa ovi notu ra, tevek msyiꞌik munuk roak. ");
INSERT INTO frd_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ubu ralan nfalak roak ma nala Yesus verin mia. Ia nkaꞌa roak afa ovi tamata ra mane rotu verin Yesus. Ba mia ovu tamata ovi wol rorang Ubu byaku Ia naꞌa aa walwalur ma fyadiri Ia ma fyedan Ia. ");
INSERT INTO frd_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Yesus ntuan wawaꞌuk i dawan urun, beti nmata. Naꞌuk Ubu nfavaꞌat ewal Ia tali matmatan, tevek matmatan a wol bisma ntahang teri Ia. ");
INSERT INTO frd_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Raja Daud nfamalik lan roak Yesus ne, ‘Yaꞌa usiꞌik lalawatan Duilaꞌa nban-ulu verin yaꞌa. Ia ndiri ning lihir mela, ba tamata ra wol rweang nala yaꞌa. ");
INSERT INTO frd_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Wean inyai, bi ralang lolin urun ma uraning Oa. Ukaꞌa basil ne, velik ne umata, naꞌuk veka ning vavaꞌat kakiwal. ");
INSERT INTO frd_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Velik ne umata, naꞌuk wol mtalik Yaꞌa ma umata watan. Wol mtorung ma Mu Sansinir i ralan nmerat urun, tenan a nakvisal. ");
INSERT INTO frd_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Oa fwaturu roak lingaꞌan verin Yaꞌa ma veka ning vavaꞌat kakiwal. Oa veka motu ma ralang lolin urun, tevek movun Yaꞌa.’ ” ");
INSERT INTO frd_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Petrus ntafal ma nfalak ne, “Terang a valing averi, yaꞌa wol ufonak ralang verin mia ma ufamalik ubud-nusid i Raja Daud. Ia nmata roak, ma wan i roving ia tali lalan ma naran amar ini nanaꞌa obin. ");
INSERT INTO frd_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Daud nabi ia, ba nkaꞌa roak ne, Ubu nala tnorung verin ia ovu nafwaba verin ia ne, tali Daud ubun nusin ra, na veka nsikat tamata isa ma neluk Raja i ntevut dida salasilan ra, ma ndoku wan i Daud ndoku ma nfareta. ");
INSERT INTO frd_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ubu notu ma Daud nkaꞌa lan afa i Ubu veka notu a, ba Daud nfalak ne, Ubu veka nfavaꞌat ewal Raja i ntevut dida salasilan ra tali matmatan. Ubu wol ntalik Ia ma nmata watan, ba tenan wol nakvisal. ");
INSERT INTO frd_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ubu nfavaꞌat ewal Yesus tali matmatan, ma mam tinemun amsiꞌik ovu matamami ra ne, Ia nvaꞌat. ");
INSERT INTO frd_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ubu nalang ma dawan Yesus, ba nsikat Ia ma ndoku Ni lihir mela naꞌa lanit ratan. Ubu nfakena Ni tnorung ma nala roak Ni Roh verin Yesus. Nata Yesus nala Ubu Ni Roh ma nsoru ralamami ra, ma amar ini msyiꞌik ovu mryenar afa ovi Ni Roh notu a. ");
INSERT INTO frd_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Daud tenan wol nrata lanit ratan, naꞌuk nfamalik ne, ‘Ubu nfalak verin ning Duilaꞌa ne, “Mdoku Ning lihir mela, ");
INSERT INTO frd_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ti naran i otu ma tamata ovi rira sian Oa rsoak nulu Oa.” ’ ");
INSERT INTO frd_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Ba Israel averi, wean inyai, na bir tinemun musti mkyaꞌa ne, Yesus i byaku Ia naꞌa aa walwalur ma fyadiri Ia yai, Ubu notu ma neluk Duilaꞌa verin mia, ovu neluk Raja i ntevut dida salasilan ra.” ");
INSERT INTO frd_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ti ma rarenar afa avyai, na ralarira lalau urun, ba rorat vali Petrus ovu rasul liak ra ne, “Kida averi, ki amotu aka?” ");
INSERT INTO frd_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Petrus nfalak verin ira ne, “Mia munuk musti myahil ma mtyalik tali bira salasilan ra, ovu mtyorung ma ambaptis mia naꞌa Yesus Kristus naran a ovu Ni ngrebat, boma Ubu veka naꞌi vatuk bira salasilan ra. Nata Ubu veka nala Ni Roh verin mia. ");
INSERT INTO frd_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ubilaꞌa i traning a nala tnorung ini verin tamata ovi nfili ra, ba nala verin mia ovu yanabira ovu ububira ra, ovu vali verin tamata ovi raroa tali ini.” ");
INSERT INTO frd_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Petrus nangrihi verin ira wean inyai, ovu nala vali vaivatul rivun ma nsurak ovu nfangnanang ira ne, “Deka myorang tamata ktufan ovi rvaꞌat fiang ini, boma Ubu deka nukun mia naꞌut i veka nukun tamata ovi wol rorang Ia.” ");
INSERT INTO frd_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Amar yai tamata rivun rorang afa ovi Petrus nfalak naꞌa Yesus, ba ti rbaptis ira. Rarekan tamata ovi beti rorang Yesus amar yai, na tamata rivun itelu. ");
INSERT INTO frd_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Tamata avyai ivaꞌur urun ma rorang ma dawan afa ovi rasul rair verin ira. Ira ralar isa ma baꞌi rasdovu ira ma rafnaꞌan kida ovu raflurut. ");
INSERT INTO frd_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Rasul ra rotu mujizat ra ovu faneak rivun ovi tamata ra wol rot-nala, ba tamata ra munuk ralang ma dawan Ubu. ");
INSERT INTO frd_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Tamata ovi rorang Yesus baꞌi rasdovu ira, ma rala rira metan ra munuk ma irmunuk rira watan. ");
INSERT INTO frd_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Amar boku, na tamata boku tali ira rfedi rira lanun ovu rira metan ra, ma rtanang kubang yai verin tamata inorang ovi rira kubang mamahin. ");
INSERT INTO frd_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Lokat amar, na rasdovu ira naꞌa Yahudi rira Rahan Dawan Falurut ni lean. Ira rafnaꞌan kida naꞌa rira rahan ra ovu ralar lolin, ovu vali wol rfakaratat tenarira ra. ");
INSERT INTO frd_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ira rfadawang Ubu lalawatan ma tamata ovi rnaꞌa Yerusalem inar ira. Lokat amar, na Duilaꞌa notu ma tamata ra rtafal ma rorang Yesus, ma Ubu nsikat ira tali rira salasilan ra, ma rira vavaꞌat kakiwal. ");
INSERT INTO frd_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Amar isa, na lera mane sian roak, na Petrus irua Yohanes rarata Yahudi rira Rahan Dawan Falurut. Lokat amar lera wean inyai, na Yahudi ra baꞌi rti ma raflurut naꞌa inyai. ");
INSERT INTO frd_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Tamata ra rvara brana isa i natlukut tali amar i rarali ia. Lokat amar, na rvara ia ma rfadoku ia naꞌa Rahan Dawan Falurut ni tembok dawan ni falfolat ilaꞌa i rfanara ia ne Falfolat i Felan Lolin Buas. Brana yai ndoku falfolat yai ngoran a ma nera kubang tali tamata ovi rti Rahan Dawan Falurut. ");
INSERT INTO frd_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ia nsiꞌik Petrus irua Yohanes rbana mane rti Rahan Dawan Falurut ni lean ralan, ba nera kubang tali ira. ");
INSERT INTO frd_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ira rsiꞌik nanuang ia, ma Petrus nfalak verin ia ne, “Eka msiꞌik ami!” ");
INSERT INTO frd_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ba brana yai nsiꞌik nanuang ira ma nanovak roak naꞌa ralan ne, veka rala afa boku verin ia. ");
INSERT INTO frd_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ba Petrus nfalak verin ia ne, “Yaꞌa wol ning kubang, naꞌuk afa ovi rnaꞌa yaꞌa ini veka ala verin oa. Yesus Kristus i ntali ahu Nazaret nala ngrebat verin yaꞌa, ba ufalak ne, bwana kikyai!” ");
INSERT INTO frd_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ba ntaha brana laklukut yai liman mela ma nfadiri ia. Notu wean inyai, na brana yai ean a ovu ni kamuku ra rangrebat lahir. ");
INSERT INTO frd_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ba naswatil ma ndiri ovu nbana lahir. Nata ia ovu Petrus irua Yohanes rti Rahan Dawan Falurut ni lean ralan. Ia nbana naswatil watan ia ma nraning Ubu. ");
INSERT INTO frd_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Tamata ovi rnaꞌa inyai munuk rsiꞌik brana yai nbana nala roak ovu nraning Ubu. ");
INSERT INTO frd_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ira ref nala ia ne, brana laklukut i baꞌi ndoku Rahan Dawan Falurut ni falfolat i rfanara ia ne “Falfolat i Felan Lolin Buas,” ma nera kubang tali tamata ra. Irmunuk rtalkaka lahir, tevek lolin roak ia. ");
INSERT INTO frd_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Brana laklukut yai ntaha Petrus irua Yohanes ma irtelu rti wan i rfanara ia ne, Salomo ni abelus. Tamata rivun avyai rtalkaka lahir, ba rafla ti ma rfaseri ira. ");
INSERT INTO frd_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Petrus nsiꞌik tamata rivun avyai ma nfalak ne, “Hoi, Israel averi, afakinimi msyiꞌik afa yai, na mtyalkaka, ovu msyiꞌik nanuang ami? Mia mnyarin ne, mami ngrebat te mami vavaꞌat nmerat urun notu ma tamata yai nbana? ");
INSERT INTO frd_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ubu i Abraham, Ishak, Yakub ovu ubud-nusid ra baꞌi raraning, nalang ma dawan Ni sansinir a. Ni sansinir yai Yesus i lan ana, mia myala roak Ia verin fareta ra ma rfedan Ia, ovu milaꞌing Ia naꞌa gubernur Pilatus wahan ralan, velik ne Pilatus mane nfatalik Ia. ");
INSERT INTO frd_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ia ralan nmerat urun ovu Ni vavaꞌat nmalola, naꞌuk mifena Ia, ba myera tali Pilatus ma nfatalik tamata isa i baꞌi nsifedan verin mia. ");
INSERT INTO frd_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Mia fyedan Ia i nala vavaꞌat kakiwal verin tamata ra, naꞌuk Ubu nfavaꞌat ewal roak Ia tali matmatan. Ami amsiꞌik lahir Ia nvaꞌat ewal tali matmatan. ");
INSERT INTO frd_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Yesus Ni ngrebat notu ma brana laklukut ini ean ra rangrebat roak, tevek norang Ia. Mia munuk mkyaꞌa ovu msyiꞌik roak brana laklukut ini. Ia norang Yesus, ba Yesus notu ma lolin lahir ia naꞌa wahabira ralan ra. ");
INSERT INTO frd_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Kida averi! Fiang ini ukaꞌa roak afa sala ovi mimunuk bira dawan ra myotu verin Yesus, naꞌuk wol fyan-aran afa ovi myotu ra. ");
INSERT INTO frd_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Naꞌuk wean inyai, boma Ubu nfakena afa ovi lalan a Ia nfalak verin nabi ra, ma ti rfamalik Raja i ntevut dida salasilan ra. Ira rfalak ne, Ia musti ntuan susa rivun. ");
INSERT INTO frd_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ba terang a valing averi, myahil kikyai ma mtyalik tali bira salasilan ra ma myorang Ubu, boma naꞌi vatuk bira salasilan ra. ");
INSERT INTO frd_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Myotu wean inyai, boma Duilaꞌa novun mia ma nfaloling ralabira ra. Ia veka nsinir Yesus nti verin mia, tevek nfili roak Ia ma neluk Raja i ntevut dida salasilan ra. ");
INSERT INTO frd_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ia nanaꞌa lanit ratan watan, nata ti naran amar i Ubu notu ma afa ra munuk ngorvaꞌan ewal, wean i nfalak roak naꞌa Ni Tnorung a, nahu Ni nabi ovi ralarira ra rmerat urun. ");
INSERT INTO frd_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Lalan ana, Musa nfalak ne, ‘Ubilaꞌa i mryaning a veka nfili nabi isa tali bira sidovung a. Ia veka wean yaꞌa, ba mia musti mryenar ma lolin afa ovi nfalak ra verin mia naꞌa afaka watan. ");
INSERT INTO frd_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Tamata iki watan wol nrenar nabi yai ma norang Ia, na Ubu veka naling ia tali Ni tamata ovi rorang Ia, ma nfedan ia.’ ");
INSERT INTO frd_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Tali nabi Samuel ti naran nabi ovi marmuri ra, na ira munuk rfamalik afa ovi fiang ini tamata ra rsiꞌik a. ");
INSERT INTO frd_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Lalan a, Ubu nala tnorung verin Ni nabi ra. Ia nala vali tnorung ini ma naflahar ububir-nusibira ra. Tnorung ini verin mia vali. Ubu nfalak verin Abraham ne, ‘Yaꞌa veka ala ubum-nusim isa ma uflahar tamata ra munuk naꞌa lanit ivavan ini.’ ");
INSERT INTO frd_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ba Ubu nsinir lan Ni sansinir verin mia. Inyai Yesus i naflahar mia, ovu notu ma myahil ma mtyalik tali bira afa sian ovi myotu ra.” ");
INSERT INTO frd_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Naꞌut i Petrus irua Yohanes rangrihi nulu tamata rivun avyai obin, na Yahudi rira mela falurut ra ovu tamata i nfareta suldadu ovi rwanar Yahudi rira Rahan Dawan Falurut a, ovu vali tamata boku tali Yahudi rira sidovung isa naran Saduki, rma ma rtuan ira. ");
INSERT INTO frd_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Tamata dawan avyai rangrova urun, tevek irua rair tamata ra ovu rfalak ne, Ubu veka nfavaꞌat ewal tamata ovi rmata ra, wean i nfavaꞌat roak Yesus tali matmatan. ");
INSERT INTO frd_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ba ira rtaha Petrus ovu Yohanes ma ti rvatuk ira naꞌa buꞌi ralan. Ovan roak, ba rtahang teri ira naꞌa inyai ma ti naran ilyan. ");
INSERT INTO frd_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Naꞌuk tali tamata rivun ovi rarenar afa ovi rair ra, na rivun ilaꞌa rorang Yesus. Ira rarekan brana ra, na kaꞌa bi rivun ilima rorang roak Yesus. ");
INSERT INTO frd_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ni ilyan ana, Yahudi rira dawan ovi rair Musa ni inukun ra, ovu dawan Yahudi ra ovu dawan ovi rban-ulu verin ira, rasdovu ira naꞌa Yahudi rira sidovung dawan naꞌa Yerusalem. ");
INSERT INTO frd_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Rira Mela Falurut Ilaꞌa naran Hanas, ovu Kayafas, Yohanes, Aleksander, ovu ni tiniman liak ra munuk rdoku sidovung dawan yai. ");
INSERT INTO frd_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ira rovun Petrus irua Yohanes ma rdiri waharira ralan ra, ma rorat ira ne, “Mia myotu ma lolin brana laklukut yai ovu ngrebat tali iki, ovu myala iki naran a ma myotu afa ini?” ");
INSERT INTO frd_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ubu Ni Roh nsoru lahir Petrus ralan a ma nfalak ne, “Dawan Yahudi averi ovu dawan ovi byan-ulu verin ami! ");
INSERT INTO frd_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Amar ini myera ma amfamalik naꞌa i wean inba ma amlobang tamata laklukut yai, ovu vali wean inbinimi tamata yai lolin roak ia. ");
INSERT INTO frd_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Mane ufalyawang verin mia ovu vali Israel ra munuk ma mkyaꞌa ne, Yesus Kristus i ntali ahu Nazaret nala ngrebat verin ami ma amotu ma lolin tamata ini ma ndiri wahabira ralan ra. Mia myotu ma rbaku Yesus naꞌa aa walwalur, naꞌuk Ubu nfavaꞌat ewal Ia. ");
INSERT INTO frd_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Rtulis roak naꞌa Surat Ralan ne, Yesus wean vatu i tukan ra rvatuk. Mia wean tukan ovi rvatuk vatu yai: ‘Naꞌuk Ubu nala vatu i byatuk yai ma notu ma wean vatu i fyawan lia munuk ma al nfangrebat rahan yai.’ ");
INSERT INTO frd_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Yesus aꞌuk saꞌi nsikat ita tali dida salasilan ra, ma dida vavaꞌat kakiwal. Ubu wol nfili tamata liak isa vali naꞌa lanit ivavan ini ma nsikat ita tali dida salasilan ra.” ");
INSERT INTO frd_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Tamata ovi rnaꞌa sidovung dawan yai rsiꞌik roak ne, Petrus irua Yohanes rabrahi, ovu rkaꞌa vali ne, irua wol raskola, ba rtalkaka. Ira rkaꞌa ne, tamata irua ini rorang lalawatan Yesus. ");
INSERT INTO frd_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Naꞌuk tamata avyai wol bisma rfalak afakataka, tevek tamata i Petrus irua Yohanes beti rotu ma lolin ia yai ndir-ebang ira. ");
INSERT INTO frd_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ba rfareta Petrus ovu Yohanes ma rti sidovung dawan murin a, boma tamata avyai rfamalik ewal ira. ");
INSERT INTO frd_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ba rsiorat ira ne, “Ita veka totu aka verin tamata irua ini? Tamata ra munuk naꞌa Yerusalem rkaꞌa roak ne, tamata irua yai rotu mujizat i betfasa tamata ra rarea, ba rtalkaka. Wol talak nala roak ita naꞌa mujizat yai. ");
INSERT INTO frd_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Naꞌuk totu ma tamata liak wol rarenar mujizat i rfamalik yai, ba eka tfalak teri ira, boma deka rfamalik Yesus verin tamata ra.” ");
INSERT INTO frd_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ba rera ewal Petrus irua Yohanes ma rti ralan, ma rfareta ira boma deka rfamalik te rair ewal Yesus verin tamata ra. ");
INSERT INTO frd_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Naꞌuk Petrus irua Yohanes rfalak ne, “Eka fyanovak watan naꞌa ralabira ra ne, afaka kena naꞌa Ubu wahan ralan a: ami amorang afa ovi fyalak ra, te amorang Ia. ");
INSERT INTO frd_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ami wol bisma amtalik ma amfamalik afa ovi amsiꞌik ovu amrea roak.” ");
INSERT INTO frd_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ira wol rdav-nala lingaꞌan mane rukun Petrus irua Yohanes, tevek tamata ra munuk naꞌa inyai rfadawang Ubu naꞌa afa i tamata irua ini rotu a. Ba ral-ewal vaivatul aleman al rfabobar ira, beti rfatalik ira. ");
INSERT INTO frd_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Tamata ra munuk rkaꞌa roak ne, Ubu notu mujizat, tevek tamata laklukut i beti rotu ma lolin ia ini, ni varat vutfaꞌat rahin roak. ");
INSERT INTO frd_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Ti ma rfatalik roak Petrus irua Yohanes, na rewal ira rti ma rtuan rira kida ra. Ba rfamalik munuk afa ovi Yahudi rira dawan mela falurut ra ovu dawan Yahudi ra rfalak verin ira. ");
INSERT INTO frd_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ti ma rira kida ra rarenar afa ovi rfalak ra, na irmunuk ralarira isa ma rera verin Ubu ne, “Duilaꞌa, Oa saꞌi fwareta afakataka munuk. Oa motu lanit ivavan a ovu lanit ratan. Oa motu vali tahat ovu afa ovi rnaꞌa ralan. ");
INSERT INTO frd_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ubumam-nusimami Raja Daud nkarya verin Oa, ba lalan ana, fwalak ma Mu Roh notu ma Daud nfalak ne, ‘Notu afakinimi bangsa ovi wol Yahudi ra rangrova ma dawan i? Afaka notu ma tamata ra rvolan ma rotu afa ovi wol ihir lahir? ");
INSERT INTO frd_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Raja ovi rnaꞌa lanit ivavan rasusan warira mane rotu rihi, ovu vali mela dawan ra rasdovu ira ma raꞌan vai isa ma rangal Duilaꞌa ovu Ni Raja i ntevut dida salasilan ra.’ ");
INSERT INTO frd_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Daud nfalak kena, tevek Raja Herodes irua gubernur Pontius Pilatus rasdovu roak tamata Israel ra ovu ovi wol Israel ra naꞌa Yerusalem, mane rangal Yesus, Mu Sansinir i nmerat urun. Oa fwili roak Ia ma neluk Raja i ntevut dida salasilan ra. ");
INSERT INTO frd_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Duilaꞌa, Oa saꞌi mungrebat, ba ira rot-nala watan afa ovi ralam nfalak roak ma rotu. Oa bwolan roak ma rotu afa avyai. ");
INSERT INTO frd_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Duilaꞌa, amera verin Oa ma mrenar ovu msiꞌik ira! Ira rworuk-rwak ami, ba mlobang ami, boma ralamami dawan ma amfamalik ma lolin Mu vaivatul ra, tevek amkarya verin Oa. ");
INSERT INTO frd_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Mala Mu ngrebat, boma tamata ovi rira suhut ra veka lolin ewal ira. Fara motu wean inyai, tevek Yesus, Mu sansinir i nmerat urun a, veka notu ma amotu vali mujizat ra ovu faneak ovi tamata ra wol rot-nala.” ");
INSERT INTO frd_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ti ma raflurut munuk, na ruru naꞌa wan i rasdovu ira naꞌa yai. Ubu Ni Roh nsoru lahir ralarira ra, ba wol rbobar ma rfamalik Ubu Ni vaivatul ra. ");
INSERT INTO frd_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Tamata ovi rorang Yesus munuk ralarira isa, ba wol tamata isa tali ira nafena ma nala ni metan ra verin rira sidovung. ");
INSERT INTO frd_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ubu nala ngrebat dawan verin rasul ra ma rfamalik ne, Ia nfavaꞌat ewal Duilaꞌa Yesus tali matmatan, ba Ubu naflahar ma dawan tamata ovi rorang Ia. ");
INSERT INTO frd_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Wol tamata isa tali ira kasian ia, tevek amar boku, na tamata ra rfedi rira rahan te lanun ra ma rala kubang avyai ");
INSERT INTO frd_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","verin rasul ra. Nata rtanang kubang avyai ma inovan ovu afa ovi tamata ra rperlu. ");
INSERT INTO frd_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Tamata isa naran Yusuf wean vali inyai. Rasul ra rfanara ia ne Barnabas, ihin a tamata i baꞌi nfangrebat tamata ralarira ra. Ubun nusin ra rtali Yahudi rira arun dawan isa naran Lewi. Rarali ia naꞌa nuhu isa naran Siprus. ");
INSERT INTO frd_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ia nfedi ni vaꞌi isa ma nala kubang avyai verin rasul ra. ");
INSERT INTO frd_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Brana isa naran Ananias, awan a naran Safira. Irua rfedi rira lanun boku. ");
INSERT INTO frd_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ia nfonak lanun yai fyawan a, ma boku verin ia, na teran ntaha ti verin rasul ra. Ia awan nkaꞌa vali afa i notu yai. ");
INSERT INTO frd_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ba Petrus nfalak ne, “Ananias, afakinimi mtorung ma nitdawan nleal lahir ralam a, ma mlabir Ubu Ni Roh ma fwonak kubang boku tali lanun i fwedi yai? ");
INSERT INTO frd_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Wol fwedi lanun yai obin, na oa mu lanun a. Ti ma fwedi roak, na oa mu lanun fyawan yai obin. Afakinimi munovak naꞌa ralam a wean inyai? Oa wol mlabir tamata, naꞌuk mlabir roak Ubu.” ");
INSERT INTO frd_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ti ma Ananias nrenar munuk afa i Petrus nfalak yai, na nmata lahir ma nleka nsuta lanun. Ba tamata ovi rarenar ivar yai rbobar urun. ");
INSERT INTO frd_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Varverun boku rma ma rkuma ia, ma rvara ia rti murin ma roving ia. ");
INSERT INTO frd_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Kaꞌa bi jam itelu nelak roak, na Ananias awan nma vali. Naꞌuk ia wol nkaꞌa ne, awan nmata roak. ");
INSERT INTO frd_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Petrus norat ia ne, “Eka fwalak verin yaꞌa. Lanun i mirua awam a fyedi yai, fyawan a veran ini?” Ananias awan nfalak ne, “Oꞌu ta baba, fyawan veran inyai.” ");
INSERT INTO frd_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Petrus nfalak verin ia ne, “Afakinimi mirua awam ralabira isa ma mlyabir teman Ubu Ni Roh i? Eka msiꞌik! Tamata ovi beti rti roving awam a rewal roak ira ma rdiri falfolat ngoran a, ba veka rvara vali oa ma ti roving oa.” ");
INSERT INTO frd_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ti ma Ananias awan nrenar munuk afa i Petrus nfalak yai, na nmata lahir ma nleka nsuta ntuba Petrus wahan ralan a. Varverun avyai rti rahan ralan ma rsiꞌik, na nmata roak, ba rvara ia ma ti roving ia nebang awan a. ");
INSERT INTO frd_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ba tamata ovi rorang Yesus ovu tamata liak ovi rarenar afa ini, irmunuk rbobar urun. ");
INSERT INTO frd_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Rasul ra rotu mujizat rivun, ovu vali rotu faneak ovi tamata ra wol rot-nala, naꞌa tamata rivun waharira ralan ra. Tamata ovi rorang Yesus ralarira isa ma baꞌi rasdovu ira naꞌa wan isa naran Salomo ni abelus i naꞌa Yahudi rira Rahan Dawan Falurut. ");
INSERT INTO frd_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Tamata liak wol rabrahi ma rdoku ovu ira, velik ne tamata ra ralang ma dawan ira. ");
INSERT INTO frd_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Naꞌuk amar nkati amar, na sidovung tamata ovi rorang Duilaꞌa Yesus ntafal lalawatan. Ba vata ovu brana rivun rorang Ia. ");
INSERT INTO frd_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Rasul ra rotu mujizat ra, ba tamata ra rsikat tamata ovi rira suhut ra ma rfanuba ira naꞌa koꞌi te dari naꞌa lingaꞌan, boma wean i Petrus nbana nahu inyai ma molan nkena watan ira, na lolin lahir ira. ");
INSERT INTO frd_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Tamata rivun ilaꞌa rtali ahu ovi rfaseri Yerusalem rma vali ma rovun rira tamata ovi rira suhut ra ovu tamata ovi nait sian ra rleal ira, ba ira munuk lolin ewal ira. ");
INSERT INTO frd_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ti nata Yahudi rira Mela Falurut Ilaꞌa ovu ni tamata ovi rnaꞌa sidovung Saduki ralarira sian urun, tevek tamata rivun rorang rasul ra. ");
INSERT INTO frd_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ba rtaha rasul ra rma ma raꞌabuꞌi ira. ");
INSERT INTO frd_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Naꞌuk lervava yai, na Ubu Ni sansinir isa tali lanit ratan nma ma nvadil buꞌi ni falfolat ra ma novun ira rti murin, ma nfalak verin ira ne, ");
INSERT INTO frd_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Miti Rahan Dawan Falurut ni lean ma mdyiri ineri, ma fyamalik munuk vaivatul ovi rala vavaꞌat ngorvaꞌan a verin tamata rivun.” ");
INSERT INTO frd_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ira rot-orang snurak i sansinir tali lanit ratan yai nfalak a, ba varverak sumatan, na rti Rahan Dawan Falurut yai ni lean ma rsiair naꞌa inyai. Naꞌut inyai vali, na Yahudi rira Mela Falurut Ilaꞌa ovu ni tamata ovi rorang ia rma, ma rera Israel rira dawan ovi rdoku rira sidovung dawan ma rasdovu munuk ira. Nata rsinir tamata ra ma rovun rasul ra ti verin ira. ");
INSERT INTO frd_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Naꞌuk tamata avyai rti raran buꞌi, na rasul ra wol rleal roak, ba rewal watan ira ma rfalak verin sidovung dawan yai ne, ");
INSERT INTO frd_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Ti amaran buꞌi yai, na amsiꞌik falfolat ra ratkusi ma lolin watan, ma tamata ovi rwanar falfolat ra rdiri falfolat ngoran ra. Naꞌuk ti amvadil falfolat ra, na wol amrea tamata isa vali naꞌa ralan.” ");
INSERT INTO frd_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ti ma tamata i nfareta suldadu ovi rwanar Yahudi rira Rahan Dawan Falurut a, ovu Yahudi rira dawan mela falurut ra rarenar ivar yai, na ralar raruan ma rsiorat ira ne, ilyan te ravrua veka wean inba? ");
INSERT INTO frd_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Nata tamata isa nma ma nfalak ne, “Baba averi, eka msyiꞌik! Tamata ovi myaꞌabuꞌi ira yai rdiri Rahan Dawan Falurut ni lean ma rair tamata ra!” ");
INSERT INTO frd_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ba tamata i nfareta suldadu ovi rwanar Rahan Dawan Falurut ovu ni suldadu ra rti ma rala rasul irua yai. Ira rala rasul irua yai ovu lolin watan, tevek wean i rotu sian ira, na rbobar beta ne tamata rivun rteva ira. ");
INSERT INTO frd_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ira rovun rasul irua yai ma rti rdiri tamata ovi rnaꞌa sidovung dawan yai waharira ralan ra, boma Mela Falurut Ilaꞌa norat afa tali ira. ");
INSERT INTO frd_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Ia nfalak ne, “Amfalak teri roak ma deka fyamalik Tamata yai verin tamata ra. Naꞌuk fyamalik roak Ia ma ti nsoru roak wan ovi rnaꞌa Yerusalem. Mia fyalak vali ne, ami amotu ma Tamata yai nmata!” ");
INSERT INTO frd_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Petrus ovu rasul liak ra rfalak ne, “Ami musti amot-orang aꞌuk afa ovi Ubu nfalak ra. Ami wol amot-orang afa ovi tamata ra rfalak. ");
INSERT INTO frd_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Mia fyakloꞌi Yesus naꞌa aa walwalur ma fyedan Ia. Naꞌuk Ubu i ubud-nusid ra baꞌi raraning a, notu ma Ia nvaꞌat ewal tali matmatan. ");
INSERT INTO frd_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ubu nalang ma dawan Yesus, ba novun Ia nrata lanit ratan ma ndoku Ni lihir mela, ma nala ngrebat verin Ia ma nfareta tamata ra, ovu nsikat ira tali rira salasilan ra. Ubu notu wean inyai, boma tamata Israel ra rahil ma rtalik tali rira salasilan ra, ovu naꞌi vatuk rira salasilan ra. ");
INSERT INTO frd_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ami amrea ma amfamalik afa avyai munuk, ovu Ubu Ni Roh nrea nkaꞌa vali afa ovi Yesus notu ra. Ubu nala Ni Roh verin tamata ovi rot-orang afa ovi nfalak ra.” ");
INSERT INTO frd_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Dawan ovi rdoku sidovung dawan yai rarenar afa avyai, na rangrova urun i lahir, ba mane rfedan rasul avyai. ");
INSERT INTO frd_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Naꞌuk tamata Farisi isa naran Gamaliel naꞌa vali sidovung dawan yai. Ia nair vali Yahudi rira inukun ra, ba tamata ra munuk ralang ia. Ia ndiri ma nsinir tamata ovi rwanar rasul ra ma rovun ira rti murin, naꞌuk wol mnanat. ");
INSERT INTO frd_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Nata nfalak verin ira ne, “Hei, tamata Israel averi! Minovak ma lolin naꞌa afa i mane myotu verin tamata ovi! ");
INSERT INTO frd_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Varat ifira nti roak veli, na tamata isa naran Teudas nma ma nfalak verin tamata ra ne, tamata dawan ia, ba kaꞌa bi tamata ratut ifaꞌat rorang ia. Naꞌuk rfedan ia ma tamata ovi rorang ia rban-talik munuk ia, ba rira sidovung namaꞌar ma wol rot-nala akataka lahir. ");
INSERT INTO frd_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Afa avyai kena munuk roak, beti Roma rira fareta nfalak ma rtulis tamata ra munuk nararira ra naꞌa daftar. Naꞌut inyai, na tamata Galilea isa naran Yudas nma vali ma notu ma tamata rivun rorang ia, ma rotu rihi ovu Roma ra. Naꞌuk rfedan vali ia, ba rira sidovung namaꞌar ma tamata ovi rorang ia rban-talik ia. ");
INSERT INTO frd_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ba mane usurak mia ne, deka mtyeri ira naꞌa afa ovi rotu ra, ba fyatalik watan ira! Wean i tamata ra rvolan ma rotu afa avyai, na ira veka wol rot-nala. ");
INSERT INTO frd_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Naꞌuk wean i Ubu nsinir ira ma rair tamata ra, na mia veka wol fyalek-nala ira, tevek wean inyai, na mia veka myangal Ubu.” Ba ira rorang Gamaliel ni snurak yai. ");
INSERT INTO frd_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ira rera rasul ra rma ma rasveva ira. Nata rfalak teri ma deka rfamalik Yesus verin tamata ra, beti rfatalik ira. ");
INSERT INTO frd_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Rasul ra rban-talik sidovung dawan yai ovu inar lolin, tevek Ubu nfili ira ma tamata ra rotu sian ira ovu rfalak sian ira, tevek rorang Yesus. ");
INSERT INTO frd_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Lokat amar, na rti Rahan Dawan Falurut ni lean ovu naꞌa tamata rira rahan ra ma rair lalawatan ira. Ira rfamalik lalawatan Ubu Ni Ivar Lolin verin tamata ra ne, Yesus yai Raja i ntevut dida salasilan ra. ");
INSERT INTO frd_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Naꞌut inyai, na tamata ovi rorang Yesus ntafal lalawatan ma rivun ira. Boku tali ira rala aꞌuk vai Yunani, naꞌuk etal dawan rala vai Ibrani. Tamata ovi rala vai Yunani rafngamuꞌur, tevek lokat amar, na tamata ovi rala vai Ibrani rtanang afamtahan verin varu ra, naꞌuk tamata ovi rala vai Yunani rfalak ne, wol rala afamtahan verin rira varu ra. ");
INSERT INTO frd_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ba rasul vutu rahin irua yai rasdovu munuk tamata ovi rorang Yesus, ma rfalak verin ira ne, “Wol kena ma amtanang afamtahan verin varu ra, tevek wean inyai, na wol mami amar roak ma amair ovu amfamalik Ubu Ni vaivatul ra. ");
INSERT INTO frd_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ba teramam-valimami averi, eka fyili tamata ifitu tali bir tinemun. Fyili tamata ovi mkyaꞌa roak ne, Ubu Ni Roh nsoru lahir ira, ovu rira kakaꞌa dawan, boma amala varvara ini verin ira. ");
INSERT INTO frd_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Wean inyai bi ralamami isa ma amaflurut verin Ubu, ovu amfamalik watan Ni vaivatul ra.” ");
INSERT INTO frd_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Rira tinemun inar, ba rtorung afa ovi rasul ra rfalak. Ira rfili tamata isa naran Stefanus i ni inorang nangrebat, ovu Ubu Ni Roh nsoru lahir ia. Ira rfili vali Filipus, Prokhorus, Nikanor, Timon, Parmenas, ovu isa ntali Antiokhia naran Nikolaus. Ia wol Yahudi ia, naꞌuk norang Yahudi rira agama. ");
INSERT INTO frd_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ira rovun tamata ifitu yai ti verin rasul ra, ba rasul ra rfadoku limarira ra naꞌa tamata ifitu yai, beti raflurut verin ira. ");
INSERT INTO frd_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ba tamata ovi rorang Yesus ti rfamalik Ubu Ni vaivatul ra verin tamata rivun. Tamata ovi rorang Yesus naꞌa Yerusalem ntafal ma rivun ilaꞌa. Yahudi rira mela falurut ra, rivun vali ira rorang Yesus. ");
INSERT INTO frd_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Ubu naflahar ma dawan Stefanus, ba nkarya ovu Ni ngrebat ma notu mujizat dawan ra ovu faneak dawan ovi tamata ra wol rot-nala naꞌa tamata rivun waharira ralan ra. ");
INSERT INTO frd_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Naꞌuk Yahudi boku rangal vali ia. Ira rtali Yahudi rira rahan falurut i naran “Libertini.” Yahudi avyai rtali kota Kirene ovu kota Aleksandria, boku vali rtali propinsi Kilikia ovu propinsi Asia. Ira rsisoal ira ovu Stefanus, ");
INSERT INTO frd_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","naꞌuk wol rvalat nala afa ovi nfalak ra, tevek Ubu Ni Roh nala kakaꞌa dawan verin ia ma nangrihi ma lolin buas. ");
INSERT INTO frd_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ba rangrihi fanfonak verin tamata ifira ma rala ralarira ra, ma tamata avyai rfalak ne, “Ami amrenar lahir i Stefanus near nfasoba Musa ovu Ubu!” ");
INSERT INTO frd_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Rotu wean inyai, na rfakeri tamata Yahudi ralarira ra, dawan Yahudi ra ovu rira dawan ovi rair Musa ni inukun ra. Ba rti ma rtaha Stefanus ma rovun ia ti ndiri Yahudi rira sidovung dawan waharira ralan ra. ");
INSERT INTO frd_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ira rera tamata boku ma rti sidovung dawan ma rala vaivatul siklabir ma rfalak sian Stefanus. Tamata avyai rfalak ne, “Tamata ini nfalak sian lalawatan dida Rahan Dawan Falurut. Ia nfalak sian vali inukun ovi Ubu nala verin Musa. ");
INSERT INTO frd_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ami amrenar roak ia nfalak ne, Yesus i ntali ahu Nazaret yai veka naꞌar vatuk Rahan Dawan Falurut ini, ovu veka nkati vali adat ovi Musa nfadoku verin ami.” ");
INSERT INTO frd_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Rfalak munuk wean inyai, na tamata ovi rdoku Yahudi rira sidovung dawan yai munuk rsiꞌik nanuang Stefanus, na wahan a wean Ubu Ni sansinir ntali lanit ratan. ");
INSERT INTO frd_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Yahudi rira Mela Falurut Ilaꞌa norat Stefanus ne, “Ba afa ovi rfalak ra kena te wahal?” ");
INSERT INTO frd_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Stefanus nfalak ne, “Terang a valing ovu yamang averi, eka mryenar! Ubud-nusid Abraham wol nleal ahu Haran obin, na nleal wan dawan isa naran Mesopotamia. Naꞌut inyai, na Ubu i saꞌi dawan Ia nfavotuk Ia verin Abraham. ");
INSERT INTO frd_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ubu nfalak verin ia ne, ‘Muti talik mu negara ovu mu tiniman ra, ma muti wan i veka ufaturu verin oa.’ ");
INSERT INTO frd_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ba Abraham nban-talik negara i rfanara ia ne Kasdim, ma nti ahu isa naran Haran ma nleal inyai. Ia nanaꞌa inyai ti naran i yaman nmata, beti Ubu nsinir ia ma nma wan i fiang ini tleal. ");
INSERT INTO frd_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Naꞌut inyai, na Ubu wol nala lanun kedan a vali verin ia. Naꞌuk Ubu notu tnorung verin ia. Ubu nfalak naꞌa Ni Tnorung ne, Ia veka nala lanun verin Abraham ovu ubun nusin ra, velik ne naꞌut inyai, na wol yanan obin. ");
INSERT INTO frd_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ubu nfalak verin ia ne, ‘Ubum-nusim ra veka reluk tamata dakan naꞌa negara liak. Tamata ovi rnaꞌa negara yai veka rotu sian ububir-nusibira ra ma reluk tamata sansinir, ti naran varat ratut ifaꞌat. ");
INSERT INTO frd_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Naꞌuk Yaꞌa veka ukun tamata ovi rotu ma tamata Yahudi ra reluk tamata sansinir, beti ububir-nusibira ra rban-talik negara yai ma rma wan ini ma raraning Yaꞌa.’ ");
INSERT INTO frd_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ba Ubu nala tnorung verin Abraham ma nfalak verin ia ovu brana ra munuk naꞌa ni rahan ovu ubun nusin brana ra ne, veka rsunat ira al nfaneak ne, Ubu yanan ira. Ni amar kena ma rarali Abraham yanan naran Ishak, ma ni amar iwalu, na Abraham nsunat ia. Ishak yanan Yakub, nata Yakub yanan brana vutu rahin irua, na nsunat vali ira. Yakub yanan avyai reluk ubud-nusid ra. ");
INSERT INTO frd_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Yakub yanan isa naran Yusuf. Aꞌan ra ralar sian ia, ba rfedi ia verin tamata Mesir ra, ma neluk tamata sansinir. Naꞌuk Ubu nfatuang ia, ");
INSERT INTO frd_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ovu nfatalik ia tali ni susa ra munuk. Ubu nala kakaꞌa dawan verin ia, ma notu ma Mesir rira Raja Firaun inan ia. Ba Firaun nsikat ia ma nfareta Mesir ovu nsiꞌik munuk afa ovi rnaꞌa ni rahan dawan. ");
INSERT INTO frd_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Nata lafar dawan nkena Mesir ovu Kanaan, ba rtuan susa dawan ilaꞌa. Naꞌut inyai, na ubud-nusid ra vali wol rira afamtahan roak ma raꞌan. ");
INSERT INTO frd_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Amar isa, na Yakub nrenar ne, gandum naꞌa Mesir, ba nsinir ubud-nusid ra rti ma rfaha gandum. Ira betfasa rti Mesir. ");
INSERT INTO frd_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Naꞌut i rti ewal Mesir, na Yusuf nfalyawang ia verin aꞌan a warin ra. Ba tamata Mesir ra rfamalik Yusuf aꞌan a warin ra verin Raja Firaun. ");
INSERT INTO frd_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Nata Yusuf nsinir ira ma rti ma rfalak verin yaman i Yakub, ma irmunuk ni tiniman ra rti Mesir. Ni tiniman ra munuk tamata vutfitu rahin ilima. ");
INSERT INTO frd_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ba Yakub ovu ni tiniman ra rti Mesir. Ira rleal inyai, ti naran ia ovu ubud-nusid ra rmata. ");
INSERT INTO frd_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Tamata ra rtaha luririra ra rti ahu i naran Sikhem, ma rfadoku naꞌa van isa ralan a. Van ini lalan a Abraham nfaha ovu kubang perak tali Hemor yanan ovi rnaꞌa Sikhem. ");
INSERT INTO frd_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Sarseri roak ma Ubu nfakena Ni tnorung verin Abraham, na dida tamata Yahudi ovi rnaꞌa Mesir rtafal ma rivun ilaꞌa roak ira. ");
INSERT INTO frd_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Nata rsikat raja liak isa ma nfareta Mesir. Raja ngorvaꞌan yai wol nkaꞌa akataka naꞌa Yusuf. ");
INSERT INTO frd_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Raja yai nweang ubud-nusid ra, ma notu sian ira. Ia nsinir ira ma rvatuk rira kasikoꞌu yanat ovi beti rarali ra ma rmata. ");
INSERT INTO frd_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Naꞌut inyai, na beti rarali Musa, ovu Ubu notu ma felan a lolin urun. Ba renan ovu yaman a rwanar fanfonak ia naꞌa rira rahan, ti naran vulan itelu. ");
INSERT INTO frd_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Nata rfadoku ia naꞌa murin ma raja Firaun yanan vata nrea ia, ba nala lahir ma nsiwota ia neluk yanan. ");
INSERT INTO frd_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Tamata Mesir ra rair rira kakaꞌa munuk verin Musa. Dawan roak ia, na nkaꞌa urun ma nangrihi ovu ni ngrebat naꞌa afa ovi notu ra. ");
INSERT INTO frd_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Musa ni varat vutfaꞌat roak, na amar isa ia nanovak naꞌa ralan a ne, inan ma ti nalola teran a valin tamata Israel ra. ");
INSERT INTO frd_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ti ma nsiꞌik tamata Mesir isa notu sian tamata Israel isa, ba nlotar ni tamata yai ovu nbalas afa ovi tamata Mesir yai notu ma nfedan ia. ");
INSERT INTO frd_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Musa nanovak ne, tamata Israel ra veka rkaꞌa roak ne, Ubu nsinir ia ma nfatalik ira tali Mesir, boma deka reluk tamata sansinir kikyai. Naꞌuk wol rkaꞌa. ");
INSERT INTO frd_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ni ilyan ana, ia nrea brana Israel irua rsitaha, ba inan ma notu ma rsiotu lolin ewal ira. Ia nfalak ne, ‘Terang a valing averi, eka mryenar! Mirua ini iyaꞌan iwarin mia, ba notu afakinimi msyiotu sian mia?’ ");
INSERT INTO frd_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Naꞌuk tamata i notu sian tamata liak yai nalaꞌing Musa, beti nfalak ne, ‘Iki nsikat oa ma fwaleka inukun verin ami ovu fwareta ami? ");
INSERT INTO frd_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Beta ne oa mane fwedan yaꞌa, wean i inravin fwedan tamata Mesir yai?’ ");
INSERT INTO frd_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Musa nrenar vaivatul avyai, na nafla talik Mesir ma nti negara isa naran Midian. Musa neluk tamata dakan roak ma nleal inyai. Nata nsifa ma yanan brana irua. ");
INSERT INTO frd_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Varat vutfaꞌat nelak roak beti amar isa, na Ubu Ni sansinir isa tali lanit ratan nma ma nfavotuk ia verin Musa naꞌa wan lean vu dawan i nebang vuar Sinai. Sansinir yai nvotuk naꞌa yafu ongan i naꞌa kadkadir ralan. ");
INSERT INTO frd_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Musa nsiꞌik yafu ongan yai ma ntalkaka lahir, ba ti nfaseri ma nsiꞌik ma lolin, na nrenar Duilaꞌa nfalak verin ia ne, ");
INSERT INTO frd_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Yaꞌa Ubu Yaꞌa. Ubum-nusim ra Abraham, Ishak ovu Yakub raraning Yaꞌa.’ Musa nbobar ma raruru lalean ia, ba wol nsiꞌik roak kadkadir yai. ");
INSERT INTO frd_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Nata Duilaꞌa nfalak verin ia ne, ‘Eka maling mu tatea ra, tevek wam i mdiri yai nmerat urun. ");
INSERT INTO frd_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Usiꞌik roak ne, wean inba ma tamata Mesir ra rotu sian Ning tamata ra. Urenar roak rira maruhuk ra, ba uma ma ufatalik ira tali rira susa ra. Ba mwa kikyai ma usinir oa ma muti ewal Mesir.’ ");
INSERT INTO frd_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Musa ini Israel ra rafena ia, ma rfalak verin ia ne, ‘Iki nsikat oa ma fwareta ami ovu fwaleka inukun verin ami?’ Naꞌuk Ubu nsinir Musa ma nban-ulu verin ira ma nfatalik ira, boma deka reluk tamata sansinir kikyai. Ubu nsinir Ni sansinir ntali lanit ratan ma nfavotuk ia naꞌa yafu ongan i naꞌa kadkadir ralan. ");
INSERT INTO frd_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Musa notu mujizat ra ovu faneak ovi tamata ra wol rot-nala, ma novun Israel ra ma rban-talik Mesir. Ira rbana earira ma retal Tahat Valvulin, ovu vali rnaꞌa wan lean vu dawan ti naran varat vutfaꞌat. ");
INSERT INTO frd_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Musa ini tamata i nfalak verin Israel ra ne, ‘Ubu veka nfili tali bir tinemun nabi isa ma ti nfamalik Ni Ivar Lolin. Ia nfili tamata yai verin mia wean i nfili yaꞌa.’ ");
INSERT INTO frd_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Musa novun ubud-nusid ra ma rasdovu ira naꞌa wan lean vu dawan. Ubu Ni sansinir yai nangrihi verin ia naꞌa vuar Sinai. Ubu nala vali Ni vaivatul ovi rala vavaꞌat verin tamata ra verin Musa, ma ti nfamalik verin ita. ");
INSERT INTO frd_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Naꞌuk ubud-nusid ra rafena ma rot-orang afa ovi nfalak ra, ba ralaꞌing ia, tevek inar ma rewal ira rti Mesir. ");
INSERT INTO frd_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ira rfalak verin Harun ne, ‘Eka motu ubu boku verin ami, ma rlobang ami ma rfaturu lingaꞌan verin ami. Amfalak wean ini, tevek ami wol amkaꞌa roak ne, afaka nkena Musa i novun ami ma amban-talik Mesir!’ ");
INSERT INTO frd_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ba naꞌut inyai, na rotu walut isa, felan a wean karba yanan. Nata rfedan afwatan ra ma rasnuri ira al raraning walut yai, ovu rotu snoba ma al rsoba afa i ira kaꞌi rot-nala roak yai. ");
INSERT INTO frd_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Naꞌuk Ubu nangrova ira, ba wol nkamlabir ira. Ia nsiꞌik watan ma ira kaꞌi raraning lera, vulan ovu nara ra. Afa avyai rfakena vaivatul ovi nabi ra rtulis roak naꞌa Surat Ralan. Nabi Amos nfalak ne, ‘Hoi tamata Israel averi, mia fyedan afwatan ra ma reluk bira korban ra ma myala roak verin Yaꞌa? Naꞌut i mnyaꞌa wan lean vu dawan ti naran varat vutfaꞌat, na wol myala korban verin Yaꞌa! ");
INSERT INTO frd_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Mia byara befak isa miti inba watan, ma fyadoku bira walut i naran Molokh naꞌa ralan. Mia mtyaha bira ubu isa vali i felan wean nara isa i fyan-aran ia ne, Refan. Myotu walut ra ma mryaning ira, ba Yaꞌa veka otu ma negara liak ra raling vatuk mia tali bira negara, ma rtaha mia miti wan i naꞌa kota Babel ni lihir timur veli.’ ");
INSERT INTO frd_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Naꞌut inyai, na ubud-nusid ra rleal wan lean vu dawan, na ira rvara rira befak dawan i baꞌi raraning Ubu naꞌa. Ubu nfareta Musa ma notu befak dawan i nfaturu verin ia, ba Musa not-orang afa ovi nfalak ra. ");
INSERT INTO frd_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ubud-nusid ra rala befak dawan yai tali yamarira ra. Naꞌut i Yosua nfareta ira, na rvara ia rma lanun ini. Naꞌut inyai vali, na Ubu notu ma tamata ovi rleal inyai rafla talik rira lanun, boma ubud-nusid ra rala lanun yai. Naꞌut i Raja Daud nfareta Israel ra, na befak dawan yai naꞌa ini obin. ");
INSERT INTO frd_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Daud notu ma Ubu ralan a lolin, ba nera verin Ia ma fara ntorung ma nfadiri rahan isa ma Yakub ubun-nusin ra raraning Ubu naꞌa inyai. ");
INSERT INTO frd_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Naꞌuk Salomo nfadiri rahan isa verin Ubu. ");
INSERT INTO frd_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Naꞌuk Ubu i Ni dawan nlia munuk akataka wol nleal rahan ovi tamata ra rotu. Wean nabi Yesaya nfalak ne, ");
INSERT INTO frd_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Duilaꞌa nfalak ne: Yaꞌa unaꞌa lanit ratan ma ufareta, ovu lanit ivavan ini neluk wan ma ufadoku eang ra naꞌa. Mia mane fyadiri rahan aka verin Yaꞌa? Wang i mane uyari Yaꞌa naꞌa inba? ");
INSERT INTO frd_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Mia mkyaꞌa ne, Yaꞌa otu munuk afa ovi rnaꞌa lanit ratan ovu lanit ivavan ini vali.’ ");
INSERT INTO frd_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Mia ulubira vatu, ralabira rasmotak ovu msyibi arubira ra ma wol mryenar ovu wol myot-orang afa ovi Ubu nfalak ra. Mia weabira lahir ububir-nusibira ra, ma myangal lalawatan Ubu Ni Roh! ");
INSERT INTO frd_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ububir-nusibira ra rotu sian munuk lahir nabi ra. Ira rfedan vali tamata ovi lalan ana rfalak ne, Ubu Ni Tamata i Ni vavaꞌat nmalola veka nma. Tamata yai nma roak, ma fyedi ovu fyedan Ia! ");
INSERT INTO frd_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ubu nsinir Ni sansinir tali lanit ratan ra ma rala Ni inukun ra verin mia, naꞌuk wol myot-orang vali!” ");
INSERT INTO frd_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Dawan Yahudi ovi rdoku naꞌa rira sidovung dawan yai rarenar munuk afa ovi Stefanus nfalak ra, ba nifarira ra rsitutu ira, tevek rangrova urun i lahir. ");
INSERT INTO frd_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Naꞌuk Ubu Ni Roh nsoru lahir Stefanus. Ia ntadata nrata lanit ma nsiꞌik Ubu vanan i nfitik nyadat, ovu nrea vali Yesus ndiri Ni lihir mela. ");
INSERT INTO frd_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ba nfalak ne, “Yaꞌi yo, eka msyiꞌik kikyai! Usiꞌik, na lanit ratan a natvadil ma Tamata Yanan ndiri naꞌa Ubu Ni lihir mela.” ");
INSERT INTO frd_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ira rarenar ni vaivatul ra, na rtaha motak arurira ra ma rafwak ilaꞌa ma rafla ti rtaha Stefanus. ");
INSERT INTO frd_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Nata rlia soli-sasan ia rti kota murin, beti rteva lahir ia. Tamata ovi rteva ia raling rira ravit blawat ra ma rfadok-ebang varverun isa naran Saulus. ");
INSERT INTO frd_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ira rteva Stefanus obin, na nera verin Ubu ne, “Duilaꞌa Yesus, mala aꞌuk ning roh a.” ");
INSERT INTO frd_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ti nata nsangatur ma nafwak ne, “Duilaꞌa, deka mtorung ma ira rvara rira salasilan i rotu ini!” Nfalak munuk wean inyai, na nan nakbosal lahir. ");
INSERT INTO frd_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saulus ntorung vali ma rfedan Stefanus. Naꞌa amar yai vali, na tamata ra mulai ma rwi-rwa ma dawan tamata ovi rorang Yesus naꞌa Yerusalem, ba rafla tia ma watan ma ti rleal ahu ovi rnaꞌa propinsi Yudea ovu propinsi Samaria. Naꞌuk rasul ra rnaꞌa watan Yerusalem. ");
INSERT INTO frd_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Tamata ovi rot-orang afa ovi Ubu ralan nfalak ra, boku ti ma roving Stefanus. Ira ralarira lalau urun, ba rvakar ma rfaktanit lahir. ");
INSERT INTO frd_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Naꞌuk Saulus nkiwal ma nwi-nwa tamata ovi rorang Yesus. Ba ntali rahan isa nti rahan isa ma nving vatuk vata ovu brana ovi rorang Yesus, ma nala ira rti buꞌi ralan. ");
INSERT INTO frd_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Tamata inorang ovi rafla talik roak Yerusalem, rti inba watan ma rfamalik Ubu Ni Ivar Lolin verin tamata ra. ");
INSERT INTO frd_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Ba Filipus nti kota isa naꞌa Samaria ma nfamalik Raja i ntevut dida salasilan ra verin tamata ovi rnaꞌa inyai. ");
INSERT INTO frd_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ti ma tamata rivun avyai rarenar afa ovi Filipus nfamalik ra, ovu rsiꞌik faneak ovi notu ra ma al rfaturu Ubu Ni ngrebat a, na irmunuk ralarira isa ma rtorung afa ovi nfalak ra. ");
INSERT INTO frd_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Filipus nfareta nait sian ra ma rti talik tamata rivun ovi nait sian ra rleal ira. Nait sian avyai rafwak urun ia, beti rati. Tamata rivun ovi raklukut ovu tamata ovi rtakil ra lolin lahir ira. ");
INSERT INTO frd_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ba tamata ovi rnaꞌa kota yai ralarira lolin urun i lahir. ");
INSERT INTO frd_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Naꞌa kota yai, na tamata isa naran Simon. Ia ntaha afa te notu ni afnitu ra ma mnanat roak ia naꞌa inyai, ba nfabriang tamata Samaria ra, ovu vali nfakaratat tenan ma nfalak ne, tamata dawan ia. ");
INSERT INTO frd_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ba tamata koꞌu ovu dawan ra munuk rorang ia ma rfalak ne, “Tamata ini ni ngrebat tali Ubu, ba tfanara ia ne Ngrebat Ilaꞌa.” ");
INSERT INTO frd_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ira rorang ia, tevek mnanat roak nfaturu ni ngrebat ma notu ma tamata ra rtalkaka ovu ni afnitu ra. ");
INSERT INTO frd_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Naꞌuk ti ma Filipus nfamalik Ivar Lolin naꞌa i wean inba ma Ubu nfareta tamata ra wean lahir Raja ovu nfamalik vali Yesus, Raja i ntevut dida salasilan ra, na vata ovu brana rivun ira rorang afa ovi nfalak ra ma nbaptis ira. ");
INSERT INTO frd_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simon norang afa ovi Filipus nfalak ra, ba Filipus nbaptis vali ia. Nbaptis munuk ia, na norang Filipus nti inba watan. Ia nrea Filipus notu mujizat dawan ra ovu faneak dawan ovi tamata ra wol rot-nala, ba Simon ntalkaka lahir. ");
INSERT INTO frd_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Naꞌa Yerusalem, na rasul ra rarenar roak ne, tamata rivun naꞌa propinsi Samaria rtorung roak ma rala Ubu Ni vaivatul ra naꞌa ralarira ra, ba rsinir Petrus irua Yohanes ma rti ineri. ");
INSERT INTO frd_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ti ma raran Samaria, na raflurut verin Ubu ma nala Ni Roh ma nleal tamata ovi beti rorang Yesus, ");
INSERT INTO frd_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","tevek tali ira, na Ubu Ni Roh wol nleal tamata isa vali obin. Rbaptis roak ira, naꞌuk rala watan Duilaꞌa Yesus naran a. ");
INSERT INTO frd_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ba Petrus irua Yohanes rfadoku limarira naꞌa ira, na Ubu nala Ni Roh ma nleal lahir ira. ");
INSERT INTO frd_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simon nsiꞌik, na rasul avyai rfadoku roak limarira naꞌa tamata ra ma Ubu nala Ni Roh verin ira, ba ntaha kubang ti verin Petrus ovu Yohanes ma nfalak ne, ");
INSERT INTO frd_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Era verin mia ma myala ngrebat yai verin yaꞌa vali, boma wean i ufadoku limang naꞌa tamata iki watan, na Ubu veka nala Ni Roh verin ira.” ");
INSERT INTO frd_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Naꞌuk Petrus nfalak verin ia ne, “Fara Ubu not-visal oa ovu mu kubang a! Oa munovak ne, bisma fwaha Ubu Ni Roh ovu kubang? ");
INSERT INTO frd_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Oa wol mu hak ma movu ami naꞌa mami karya ini, tevek ralam wol kena lahir naꞌa Ubu wahan ralan a. ");
INSERT INTO frd_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ba mahil ma mtalik tali afa sian i ralam a nlewan yai ma mera verin Duilaꞌa, boma naꞌi vatuk afa sian i munovak yai. ");
INSERT INTO frd_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Yaꞌa ukaꞌa roak ne, ralam a sian daꞌin, ovu vali mu salasilan ra rkeak teri roak oa.” ");
INSERT INTO frd_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ba Simon nera verin ira ne, “Kida averi, miflurut verin Ubu, ma fara ne afa ovi beti fyalak yai deka rkena yaꞌa.” ");
INSERT INTO frd_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ti ma irua rfamalik munuk roak Ubu Ni vaivatul ra, beti rewal ira rti Yerusalem. Wol raran Yerusalem obin, na rfamalik vali Ubu Ni Ivar Lolin yai naꞌa ahu rivun ovi rnaꞌa Samaria. ");
INSERT INTO frd_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Amar isa, na Ubu Ni sansinir isa ntali lanit ratan nfalak verin Filipus ne, “Bwatar kikyai! Mahu tranan ma muti lingaꞌan i ntali Yerusalem nsuta ma naran Gaza. Lingaꞌan yai nanaꞌa wan lean vu dawan, ba wol tamata rnaꞌa inyai.” ");
INSERT INTO frd_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Ba Filipus nbatar ma nbana roak. Ia nbana ma ntuan tamata isa ntali negara Etiopia. Tamata yai dawan fareta ia ma nkarya verin rira raja vata i naran Kandake. Ia nsiꞌik munuk lahir negara yai ni metan ra. Ia nti Yerusalem ma nfadawang Ubu. ");
INSERT INTO frd_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Tamata yai navul ni kareta ma newal ia nti Etiopia. Naꞌa ni kareta a, na nbas kitab i lalan a nabi Yesaya ntulis a. ");
INSERT INTO frd_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ubu Ni Roh a nfalak verin Filipus ne, “Muti ma mebang kareta yai!” ");
INSERT INTO frd_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ba Filipus ti ma nebang kareta yai ma nrenar tamata yai nbas tali Yesaya ni kitab a. Filipus norat ia ne, “Baba, oa mkaꞌa afa ovi bwas yai ihin a te wahal?” ");
INSERT INTO frd_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ia nfalak ne, “Wean inba ma ukaꞌa, wean i wol tamata ma nfalyawang kitab ini ihin a verin yaꞌa?” Ba nera ma Filipus nrata ma irua rdoku ni kareta. ");
INSERT INTO frd_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ubu Ni vaivatul ovi nbas yai ngoarira wean ini: “Ia wean domba isa i rovun Ia ma ti rfedan Ia. Ia wean domba koꞌu i rngotal vulun a, naꞌuk wol vain. ");
INSERT INTO frd_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ira rfalak sian Ia ma rfamaꞌit Ia, ovu vali wol kena lahir ma rukun Ia. Wol tamata isa rfamalik Ia ubun a nusin ra, Tevek rfedan roak Ia ma wol nanaꞌa lanit ivavan a.” ");
INSERT INTO frd_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Tamata yai norat Filipus ne, “Baba, eka fwalak verin yaꞌa ne, Yesaya kaꞌi nfamalik ia, te tamata liak?” ");
INSERT INTO frd_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ba Filipus mulai ma nair ia, na nala lan vaivatul avyai, ma nfalyawang Ubu Ni Ivar Lolin i nfamalik Yesus verin ia. ");
INSERT INTO frd_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ira rbana nata ti ma raran wan isa i wear nanaꞌa. Tamata yai nfalak verin Filipus ne, “Baba, eka msiꞌik wear ini! Afaka wol kena obin ma wol bwaptis yaꞌa?”  ");
INSERT INTO frd_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filipus nfalak ne, “Wean i morang ovu ralam urun, na veka ubaptis oa.” Tamata yai nfalak ne, “Yaꞌa orang urun ne, Yesus Kristus yai Ubu Yanan a.” ");
INSERT INTO frd_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Nata nfareta tamata i ntaha ni kareta ma naꞌa teri veki, beti irua rsuta ma rti wear yai ralan ma Filipus nbaptis ia. ");
INSERT INTO frd_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ti ma irua rdata tali wear yai, na brian munuk Ubu Ni Roh a nala Filipus tali wan yai. Ba dawan fareta Etiopia yai wol nrea roak ia, naꞌuk newal watan ia ovu ralan lolin urun. ");
INSERT INTO frd_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Brian munuk, na Filipus naꞌa roak kota Asdod. Ia nbana ma ti nfamalik Yesus naꞌa ahu ovi rnaꞌa inyai, nata ti naran kota Kaisarea. ");
INSERT INTO frd_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Naꞌuk Saulus ndava watan lingaꞌan obin mane nwi-nwa ovu nfedan tamata ovi rorang Duilaꞌa Yesus. Ba ia ti nlolak Yahudi rira Mela Falurut Ilaꞌa. ");
INSERT INTO frd_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Saulus nera surat kuasa tali ia ma ntaha verin Yahudi rira dawan ovi rnaꞌa rira rahan falurut ra naꞌa kota Damsyik, boma wean i ntuan vata te brana ovi rorang Duilaꞌa Yesus Ni Lingaꞌan a, na ntaha ira ma novun ira rti Yerusalem. ");
INSERT INTO frd_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Saulus nbana ma ti nfaseri roak Damsyik, na brian munuk lyawan ntali lanit nsuta ma nlilit ia. ");
INSERT INTO frd_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ba nleka lahir nsuta lanun, beti nrenar vai isa nfalak verin ia ne, “Saulus, Saulus! Afakinimi mwi-mwa Yaꞌa i?” ");
INSERT INTO frd_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Saulus norat ne, “Iki Oa ta Duilaꞌa?” Ba vai yai nfalak ne, “Yaꞌa ini Yesus i mwi-mwa a. ");
INSERT INTO frd_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Bwatar kikyai ma muti kota ralan eri, tevek naꞌa ineri, na tamata isa veka nfalak verin oa naꞌa afa ovi musti motu ra.” ");
INSERT INTO frd_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Brana ovi rovu Saulus rdir-teri ma wol vair lahir, tevek rarenar vali vai yai, naꞌuk wol rarea tamata isa vali. ");
INSERT INTO frd_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saulus ndiri ma nvelar matan a, naꞌuk wol nrea afa isa vali. Ba rtaha liman a ma rfabana ia rti Damsyik. ");
INSERT INTO frd_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Amar itelu, na ia wol nsirea ovu wol nafnaꞌan-nafnenu vali. ");
INSERT INTO frd_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Naꞌa Damsyik, na tamata isa naran Ananias. Ia norang Yesus. Amar isa, na wean i namifi naꞌuk wol ntub-lufa ma nrenar ne, Duilaꞌa nera ia ma nfalak ne, “Ananias!” Ananias nvalat ne, “Yaꞌa ini ta Duilaꞌa.” ");
INSERT INTO frd_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Duilaꞌa nfalak verin ia ne, “Mdiri ma bwana lahir muti lingaꞌan i rfanara ia ne, ‘Lingaꞌan i Nmalola’, ma mwelat tamata isa naran Yudas ni rahan. Morat al mdava tamata isa naran Saulus i ntali kota Tarsus. Tamata yai naflurut verin Yaꞌa obin. ");
INSERT INTO frd_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ia wean i namifi naꞌuk wol ntub-lufa ma nsiꞌik roak tamata isa naran Ananias nma ma nfadoku liman naꞌa ia ma nsirea ewal.” ");
INSERT INTO frd_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ba Ananias nfalak ne, “Duilaꞌa, yaꞌa urenar roak tamata rivun rfamalik tamata ini ne, notu afa sian rivun ilaꞌa roak naꞌa Yerusalem verin tamata ovi rorang Oa. ");
INSERT INTO frd_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Yahudi rira dawan mela falurut ra rtorung roak ma rala fareta verin ia ma ntaha munuk tamata ovi rorang Oa.” ");
INSERT INTO frd_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Naꞌuk Duilaꞌa Yesus nfalak verin ia ne, “Muti aꞌuk, tevek Yaꞌa ufili roak ia ma nfabana Ning karya, ma ti nfamalik Yaꞌa verin tamata Israel ra ovu vali tamata ovi wol Yahudi ra, ntafal vali rira raja ra. ");
INSERT INTO frd_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Yaꞌa veka ufalyawang verin ia naꞌa angangal rivun ovi rotu ma musti nfarnuang wawaꞌuk, tevek norang Yaꞌa.” ");
INSERT INTO frd_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ba Ananias nti rahan yai ma nti ralan ma nfadoku liman a naꞌa Saulus, ma nfalak verin ia ne, “Terang i Saulus, Duilaꞌa Yesus i mrea Ia naꞌa lingaꞌan i mahu mwa ini, nsinir yaꞌa ma uma, boma msirea ewal, ovu vali Ubu Ni Roh nsoru lahir ralam a.” ");
INSERT INTO frd_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ananias nfalak munuk wean inyai, na brian munuk afa boku wean ian kiꞌin ra rleka tali matan a ma nsirea lahir. Ba nbatar ma Ananias nbaptis ia. ");
INSERT INTO frd_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Nata nafnaꞌan ma nangrebat ewal roak. Saulus nlolak tamata Damsyik ovi rorang Yesus ma ni amar ifira naꞌa inyai. ");
INSERT INTO frd_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ia nti lahir Yahudi rira rahan falurut ra ma nfamalik Yesus verin tamata ra ne, Ubu Yanan Ia! ");
INSERT INTO frd_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Tamata ovi rarenar ia rtalkaka munuk, ba rfalak ne, “Yaꞌi yo, tamata ini lan a notu sian tamata ovi rorang Yesus naꞌa Yerusalem. Ia nma ini ma ntaha tamata ovi rorang Yesus, ma novun ira ti ma rdiri Yahudi rira dawan mela falurut waharira ralan ra.” ");
INSERT INTO frd_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Naꞌuk Ubu ntafal ngrebat verin Saulus ma nsiair, ba notu ma tamata Yahudi ovi rnaꞌa Damsyik wol rangal nala ia, tevek nfalyawang lahir verin ira ne, Yesus yai Raja i ntevut dida salasilan ra. ");
INSERT INTO frd_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Amar rivun relak roak, na Yahudi rira dawan ovi rnaꞌa Damsyik raꞌan vai isa ma rfedan ia. ");
INSERT INTO frd_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Naꞌuk Saulus nkaꞌa roak ne, mane rfedan ia, tevek ovan-amar, na tamata Yahudi ra rwan lalawatan ia naꞌa kota ni falfolat ilaꞌa ovi naꞌa rira fidu ra, boma rfedan ia. ");
INSERT INTO frd_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ba ovan isa, na Saulus ni kida ra rma ma rala ia ma rfadoku ia naꞌa ahir dawan isa ralan a, beti rtolar ia tali kota ni tembok dawan. ");
INSERT INTO frd_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Saulus ti naran Yerusalem, na ndava mane ti nasdovu ia ovu tamata ovi rorang Yesus, naꞌuk rbobar ia, tevek wol rorang ne, ia ralan urun roak ma norang Yesus. ");
INSERT INTO frd_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Naꞌuk Barnabas ntorung ma nala ia, ma novun ia ti nfavotuk verin rasul ra, ma nfamalik verin ira naꞌa i wean inba ma Saulus nrea Duilaꞌa naꞌa ni banbanan a, ovu Duilaꞌa nangrihi verin ia. Ia nfamalik vali ne, wean inba ma Saulus nabrahi ma nala Yesus naran a ala nsiar naꞌa Damsyik. ");
INSERT INTO frd_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ba Saulus nlolak ira ma irmunuk tia ma ira naꞌa Yerusalem. Ia wol nbobar ma nala Duilaꞌa naran a al nsiair. ");
INSERT INTO frd_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Saulus nangrihi verin Yahudi ovi rala vai Yunani ovu rsisoal ira, ba rdava lingaꞌan mane rfedan ia. ");
INSERT INTO frd_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Nata teran a valin ovi rorang Yesus rarenar afa avyai, ba rovun ia rti kota Kaisarea, beti rlobang ia ma nti kota Tarsus. ");
INSERT INTO frd_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ba naꞌa amar avyai, na tamata ovi rorang Yesus naꞌa propinsi Yudea, propinsi Galilea ovu propinsi Samaria malinan watan. Naꞌut inyai, na Ubu Ni Roh nfangrebat tamata ovi rorang Yesus naꞌa rira inorang ovu nfaloling ralarira ra, ma rira sidovung ra rtafal ma rivun, ovu vali ralang ovu rfadawang Ia. ");
INSERT INTO frd_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Petrus nbana nti wan rivun, ma nalola tamata ovi rorang Yesus. Amar isa, na ti nalola tamata ovi rorang Yesus naꞌa kota Lida. ");
INSERT INTO frd_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Nanaꞌa inyai, na ntuan brana isa naran Eneas. Brana ini varat iwalu roak ntuba watan ni koꞌi a, tevek naklukut. ");
INSERT INTO frd_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Petrus nfalak verin ia ne, “Eneas, Yesus Kristus notu ma lolin ewal roak oa. Bwatar ma mususan wam i mtuba yai.” Naꞌut inyai vali, na Eneas nbatar lahir. ");
INSERT INTO frd_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Tamata rivun ovi rleal Lida ovu Saron rsiꞌik Eneas, na lolin roak ia, ba rivun ira rorang Duilaꞌa. ");
INSERT INTO frd_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Naꞌa kota Yope, na vata isa naran Tabita norang vali Yesus. Naran naꞌa vai Yunani ne, Dorkas. Ia baꞌi notu aꞌuk afa lolin ovu nlobang tamata kasian ra. ");
INSERT INTO frd_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Naꞌut inyai, na nawar ia ma nmata, ba rliru ia beti rfadoku ia naꞌa kamar i naꞌa ratan. ");
INSERT INTO frd_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lida ovu Yope rsifaseri watan ira, ba Yesus Ni tamata ovi rnaꞌa Yope rarenar ne Petrus nanaꞌa Lida, ba rsinir tamata irua ma ti rera ia. Rtuan ia ma rfalak verin ia ne, “Baba, mwa ma tati Yope kikyai.” ");
INSERT INTO frd_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ba Petrus nasusan wan ma irmunuk rti. Raran Yope, na rovun ia rarata kamar i Dorkas ntuba a. Vata varu ovi rnaꞌa inyai rdir-lilit ia ma rvakar, ovu rfaturu verin ia ravit ovu kadaravit liak ovi Dorkas noar verin ira naꞌut i nvaꞌat obin. ");
INSERT INTO frd_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Petrus nsinir ira munuk ma rti murin, beti nsangatur ma naflurut. Naflurut munuk, beti nsiꞌik matmatan yai ma nfalak ne, “Tabita, bwatar kikyai!” Ba Tabita nvelar matan a ma nsiꞌik Petrus, na nbatar ma ndoku lahir. ");
INSERT INTO frd_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ba Petrus ntaha liman a ma nfadiri ia, beti nera varu avyai ovu tamata liak ovi rorang Yesus ma nfaturu verin ira ne, Tabita nvaꞌat ewal roak. ");
INSERT INTO frd_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ivar ini nsoru lahir Yope, ba tamata rivun rorang Duilaꞌa. ");
INSERT INTO frd_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Petrus yaꞌi mnanat ia naꞌa inyai, ma nlolak tamata isa naran Simon i baꞌi nvinit afwatan ulin ra ma nfaear ira. ");
INSERT INTO frd_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Naꞌa kota Kaisarea, na brana isa naran Kornelius. Ia neluk suldadu dawan isa naꞌa Roma rira sidovung suldadu dawan isa naran Italia. ");
INSERT INTO frd_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Tamata yai not-orang afa ovi Ubu ralan nfalak ra, ovu ia ovu ni rahan a teta baꞌi ralang ma dawan Ubu. Ia naflurut lalawatan verin Ubu, ovu vali nala kubang rivun ma nlobang tamata Yahudi ovi kasian ira. ");
INSERT INTO frd_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Amar isa, na kaꞌa bi lera mane sian roak, na Kornelius wean i namifi naꞌuk wol ntub-lufa ma nrea Ubu Ni sansinir isa ntali lanit ratan nma verin ia ma nfalak ne, “Kornelius!” ");
INSERT INTO frd_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kornelius nsiꞌik sansinir yai, na nbobar urun i lahir, ba norat ne, “Afaka ta Duilaꞌa?” Sansinir yai nfalak ne, “Oa motu ma Ubu ralan a lolin, tevek muflurut lalawatan verin Ia ovu mlobang tamata kasian ra. Ba Ia nangnanang afa ovi motu avyai. ");
INSERT INTO frd_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ba fiang ini msinir lahir tamata ifira ma rti kota Yope ma rera tamata isa naran Simon Petrus. ");
INSERT INTO frd_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ia nlolak tamata liak isa naran Simon vali, ni rahan a nebang tahat. Tamata yai baꞌi nvinit afwatan ulin ra ma nfaear ira.” ");
INSERT INTO frd_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ti ma Ubu Ni sansinir i nangrihi nulu Kornelius yai nti, na ia nera ni tamata irua ovi rkarya naꞌa ni rahan a ovu ni suldadu isa i nwanar ia. Ni suldadu ini norang vali Ubu. ");
INSERT INTO frd_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ia nfamalik munuk verin ira naꞌa afa ovi Ubu Ni sansinir nfalak verin ia, beti nsinir ira ma rti Yope. ");
INSERT INTO frd_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ti ma ni ilyan ana, lera ndirlola roak, beti tamata ovi Kornelius nsinir ira yai rbana ma rfaseri Yope, na Petrus nrata vali ma naflurut naꞌa rira rahan ratan. ");
INSERT INTO frd_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ia nfarnuang ne nablafar roak, ba inan ma nafnaꞌan. Ira rafvaꞌak obin, na brian munuk Petrus wol nkaꞌa wan roak ma wean i namifi naꞌuk wol ntub-lufa ma nrea afa isa. ");
INSERT INTO frd_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ia nrea lanit natvadil ma afa isa wean maloli dawan nsuta lanit ivavan ma nakloꞌi naꞌa ni susun ifaꞌat. ");
INSERT INTO frd_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Naꞌa maloli yai ralan a, na afwatan rivun ovi earira ifaꞌat ra, ovi rlaꞌa ra, ovu vali manut nangan ra. ");
INSERT INTO frd_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Nata vai isa nfalak verin ia ne, “Petrus, bwatar ma fwedan afa avyai ma muan!” ");
INSERT INTO frd_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ia nfalak ne, “Wahal ta Duilaꞌa! Yaꞌa wol uan afa avyai, tevek mami inukun ra rfalak ma deka amaꞌan afa ovi ngra te malmoli ra.” ");
INSERT INTO frd_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Vai yai nfalak ewal ne, “Afa ovi Ubu nfalak ne rmerat yai, deka fwalak ne ngra te malmoli.” ");
INSERT INTO frd_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Afa i Petrus nrea wean mifi yai nma nala fatelu, beti maloli yai nrata ewal lanit ratan. ");
INSERT INTO frd_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Ba Petrus nanovak afa i beti nrea yai naꞌa ralan a. Brian munuk, na tamata ovi Kornelius nsinir ira yai rma ma raran Yope. Ira rorat ma al rdava ne, Simon ni rahan naꞌa inba, ba rfaturu rahan verin ira ma ti rdiri lahir falfolat ngoran. ");
INSERT INTO frd_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ira rera tamata ra ma rorat ne, “Beta ne Simon Petrus nanaꞌa teri rahan ini?” ");
INSERT INTO frd_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Naꞌut inyai, na Petrus nanovak naꞌa ralan obin ma al nkaꞌa afa i nrea yai ihin a. Ba Ubu Ni Roh nfalak verin ia ne, “Tamata itelu rdava oa. ");
INSERT INTO frd_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Bwatar ma msuta kikyai ma mimunuk miti. Ira wol Yahudi ira, naꞌuk deka ralam raruan, tevek usinir ira ma rma.” ");
INSERT INTO frd_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ba Petrus nsuta ma nfalak verin tamata avyai ne, “Kida averi, yaꞌa ini tamata i mdyava a. Afakinimi mya ini?” ");
INSERT INTO frd_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ira rfalak ne, “Roma rira suldadu dawan isa naran Kornelius nsinir ami ma amama ini. Ia ni vavaꞌat nmalola ovu nalang ma dawan Ubu, ovu vali Yahudi ra rfalak ne, lolin ia. Ubu Ni sansinir isa tali lanit ratan nma ma nfalak verin ia ma nera oa muti ni rahan a, ma nrenar afa ovi fwalak ra.” ");
INSERT INTO frd_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ba Petrus nfalak ma tamata avyai rnaꞌa rahan yai ovan isa veki. Ni ilyan ana, irmunuk Petrus rban-talik ahu yai. Tamata ovi rorang Yesus, boku rtali Yope rban-orang ira vali. ");
INSERT INTO frd_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Amar isa nelak, beti raran Kaisarea. Kornelius nasdovu roak ni tiniman ra, ovu vali ni kidabela ra ma al rnaban ira. ");
INSERT INTO frd_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Naꞌut i Petrus nti rahan ralan, na Kornelius nti ma nsangatur naꞌa Petrus wahan ralan a, tevek nalang ia. ");
INSERT INTO frd_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Naꞌuk Petrus nlobang ia ma ndiri ma nfalak ne, “Mdiri ta baba! Yaꞌa ini tamata watan yaꞌa wean oa.” ");
INSERT INTO frd_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Irua rdiri rangrihi obin, na Petrus nti rahan ralan ma nsiꞌik tamata rivun rasdovu roak ira. ");
INSERT INTO frd_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ba nfalak verin ira ne, “Terang a valing averi, mia mkyaꞌa roak ne, mami inukun ra rfalak teri lahir ma tamata Yahudi ra deka rasdovu ovu tamata ovi wol Yahudi ra, te ralola ira naꞌa rira rahan ra. Naꞌuk Ubu nfaturu roak verin yaꞌa ne, itmunuk wead isa watan, ba deka ufalak ne, tamata ra ngra ira. ");
INSERT INTO frd_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Wean inyai, bi mera yaꞌa, na uma lahir. Ba fiang ini mane ukaꞌa ne, afakinimi mera yaꞌa ma uma ini?” ");
INSERT INTO frd_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kornelius nfalak ne, “Amar ifaꞌat nti roak veli, kaꞌa bi lera sian roak ma wean amar ini, na uflurut obin naꞌa ning rahan. Brian munuk, na tamata isa nma ma ndiri wahang ralan a. Ni ravit vanan urun. ");
INSERT INTO frd_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Ia nfalak verin yaꞌa ne, ‘Kornelius, Ubu nrenar roak mu falurut a, ovu nsiꞌik roak ne, mlobang tamata ovi kasian ira. ");
INSERT INTO frd_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ba msinir tamata ra ma rti Yope, ma rera Simon Petrus ma nma. Ia nlolak tamata liak isa vali naran Simon, ni rahan a nebang tahat. Tamata yai baꞌi nvinit afwatan ulin ra ma nfaear ira.’ ");
INSERT INTO frd_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ba usinir lahir brana boku ma rera oa ta baba. Ralam a lolin bi mwa ini. Fiang ini amasdovu munuk roak ami naꞌa Ubu wahan ralan a ma amrenar afa ovi nfareta verin oa ma fwalyawang verin ami.” ");
INSERT INTO frd_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Nata Petrus nfalak ne, “Did tinemun, ukaꞌa roak ne, Ubu wol nlobang aꞌuk tamata Yahudi ra, ");
INSERT INTO frd_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","naꞌuk naꞌa lanit ivavan a, Ia inan tamata iki watan i notu afa ovi lolin ra ovu nalang Ia, velik ne ntali bangsa inba watan. ");
INSERT INTO frd_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ba terang a valing averi, mia mkyaꞌa roak Ubu Ni Ivar i nfalak verin tamata Israel ra. Ivar yai wean ini: tamata ralarira ra veka malinan ovu Ubu, nahu Yesus Kristus i tamata ra munuk rira Duilaꞌa verin Ia. ");
INSERT INTO frd_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Mia mkyaꞌa munuk roak afa ovi Yesus notu ra naꞌa propinsi Yudea munuk. Ia notu lan naꞌa propinsi Galilea, naꞌut i Yohanes i nbaptis tamata ra nfalak ma tamata ra rahil ma rtalik tali rira salasilan ra, boma nbaptis ira. ");
INSERT INTO frd_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Bir tinemun mkyaꞌa roak Ivar naꞌa Yesus i ntali ahu Nazaret. Ubu nfili Ia ma nala Ni Roh ma nleal Ia, ovu nala ngrebat verin Ia. Ubu novun Ia, ba ti notu afa lolin rivun naꞌa wan inba watan naꞌa Israel, ovu notu ma tamata ovi nitdawan nleal ira, lolin ewal ira munuk. ");
INSERT INTO frd_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Did tinemun, ami ini amsiꞌik roak afa ovi Yesus notu ra naꞌa Yerusalem ovu naꞌa wan liak ovi tamata Yahudi ra rleal. Ti nata rfakloꞌi Ia naꞌa aa walwalur ma rfedan Ia. ");
INSERT INTO frd_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Naꞌuk ti ma amar itelu nelak, na Ubu nfavaꞌat ewal Ia tali matmatan ma nfaturu Ia verin tamata ra. ");
INSERT INTO frd_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ubu wol nfaturu Yesus verin tamata ra munuk, naꞌuk verin ami tamata ovi nfili roak a ma amfamalik Ia. Nvaꞌat ewal tali matmatan, beti amafnaꞌan ovu amafnenu ovu Ia. ");
INSERT INTO frd_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ia nfareta ami ma amfamalik Ni Ivar Lolin verin tamata ra, ovu vali amfalak verin ira ne, Ubu nfili roak Ia ma nfaleka inukun verin tamata ovi rvaꞌat ra ovu ovi rmata roak a. ");
INSERT INTO frd_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Tali lalan ana, nabi ra munuk rfamalik Yesus. Ira rfamalik ne, Ubu veka naꞌi vatuk tamata iki watan i norang Yesus, ni salasilan ra nahu Yesus Ni ngrebat a.” ");
INSERT INTO frd_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Naꞌut i Petrus nangrihi obin, na Ubu Ni Roh nsuta ma nleal munuk tamata ovi rarenar ni vaivatul ra. ");
INSERT INTO frd_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Tamata Yahudi ovi rorang Yesus ma irmunuk Petrus rtali Yope rma yai rtalkaka, tevek Ubu nala Ni Roh verin tamata ovi wol Yahudi ra vali. ");
INSERT INTO frd_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Ira rkaꞌa roak ne, Ubu Ni Roh nleal vali tamata ovi wol Yahudi ra, tevek rarenar ira rangrihi ovu vai ovi wol rkaꞌa ra ma rfadawang Ia. Ba Petrus nfalak ne, ");
INSERT INTO frd_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Did tinemun, eka msyiꞌik. Ubu Ni Roh a nleal roak tamata ovi wol Yahudi ra, wean i nanaꞌa ita, tamata Yahudi. Ba deka totu teri ma rbaptis ira ovu wear.” ");
INSERT INTO frd_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ba ia nfalak verin tamata ovi rorang Yesus ma rbaptis ira naꞌa Yesus Kristus naran a ovu Ni ngrebat a. Rbaptis roak ira, beti rera verin Petrus ma nlolak ira amar ifira vali. ");
INSERT INTO frd_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Rasul ra ovu tamata liak ovi rorang vali Yesus naꞌa propinsi Yudea rarenar ne, tamata ovi wol Yahudi rorang roak Ubu Ni vaivatul ra. ");
INSERT INTO frd_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ba Petrus nti ma naran Yerusalem, na tamata Yahudi ovi rorang Yesus rfasala ia, ");
INSERT INTO frd_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","ma rfalak ne, “Wol kena lahir ma muti tamata ovi wol Yahudi rira rahan ra ma mimunuk mifnaꞌan!” ");
INSERT INTO frd_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ba Petrus nfamalik ma al nfalyawang afa avyai munuk verin ira. ");
INSERT INTO frd_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Ia nfalak ne, “Amar isa, na uflurut naꞌa kota Yope, na brian munuk wol ukaꞌa wang roak, ma wean i umifi naꞌuk wol utub-lufa ma urea afa boku. Urea afa isa wean maloli dawan ni susun ifaꞌat, ntali lanit ratan nsuta ma nakloꞌi naꞌa ni susun ifaꞌat nebang nelang a. ");
INSERT INTO frd_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Usiꞌik maloli yai ralan a, na urea afwatan ovi earira ifaꞌat ra, afwatan ovi ralar ra, afwatan ovi rlaꞌa ra, ovu vali manut nangan ra. ");
INSERT INTO frd_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Urenar vali vai isa nfalak verin yaꞌa ne, ‘Petrus, mdiri kikyai ma fwedan afa avyai ma muan!’ ");
INSERT INTO frd_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Naꞌuk ufalak ne, ‘Wahal ta Duilaꞌa! Yaꞌa wol uan afa avyai, tevek mami inukun ra rfalak ma deka amaꞌan afa ovi ngra te malmoli ra.’ ");
INSERT INTO frd_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Naꞌuk vai i ntali lanit ratan yai nfalak ewal ne, ‘Afa ovi Ubu nfalak ne rmerat yai, deka fwalak ne ngra te malmoli.’ ");
INSERT INTO frd_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Afa i urea yai nma nala fatelu, beti maloli yai nrata ewal lanit ratan. ");
INSERT INTO frd_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Brian munuk, na tamata itelu rma raran rahan i amnaꞌa teri. Kornelius nsinir tamata avyai tali Kaisarea ma rma. ");
INSERT INTO frd_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ba Ubu Ni Roh nfalak ma orang ira, velik ne wol Yahudi ira, naꞌuk deka ralang raruan. Tamata inean ovi rorang Yesus rovu vali ma amati Kaisarea. Amaran inyai, na amati Kornelius ni rahan. ");
INSERT INTO frd_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Nata ia nfamalik verin ami ne, ia nsiꞌik Ubu Ni sansinir isa ntali lanit ratan nma ma ndiri ni rahan a ma nfalak ne, ‘Msinir tamata ra ma rti Yope, ma rera tamata isa naran Simon Petrus ma nma. ");
INSERT INTO frd_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ia veka nfamalik ivar isa verin mia. Ivar yai nfalyawang ne, wean inba ma Ubu veka nsikat oa ovu mu rahan teta tali bira salasilan ra, ma bira vavaꞌat kakiwal.’ ” ");
INSERT INTO frd_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Petrus ntafal ma nfalak ne, “Bet mane ungrihi, na Ubu Ni Roh nsuta ma nleal lahir ira, wean i betfasa nleal ita naꞌa amar ovi rti roak veli. ");
INSERT INTO frd_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Nata ungnanang nala ewal Duilaꞌa nfalak ne, ‘Yohanes nbaptis tamata ra ovu wear, naꞌuk Ubu veka nbaptis mia ovu Ni Roh.’ ");
INSERT INTO frd_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ubu nala Ni Roh verin ovi wol Yahudi ra, wean basil i nala verin ita naꞌut i torang Duilaꞌa Yesus Kristus, ba yaꞌa wol bisma angal Ubu!” ");
INSERT INTO frd_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ti ma rarenar afa ovi Petrus nfalak ra, na wol rfasala roak ia, ba rfadawang aꞌuk Ubu. Ira rfalak ne, “Ubu nala vali amar verin tamata ovi wol Yahudi ra ma rahil ma rtalik tali rira salasilan ra ma rorang aꞌuk Ubu, boma rira vavaꞌat kakiwal.” ");
INSERT INTO frd_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Tamata ra rfedan roak Stefanus, beti tamata ovi wol rorang Yesus rwi-rwa lalawatan tamata ovi rorang Yesus. Ba rivun ira rafla rti wan liak. Boku rti propinsi Fenisia, nuhu Siprus ovu boku rti kota Antiokhia. Ira rfamalik Ubu Ni Ivar Lolin verin tamata Yahudi ra watan. ");
INSERT INTO frd_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Tamata boku vali rtali nuhu Siprus ovu kota Kirene. Ira rti Antiokhia ma rfamalik Ivar Lolin naꞌa Duilaꞌa Yesus verin tamata ovi wol Yahudi ra. ");
INSERT INTO frd_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ubu nala ngrebat verin ira, ba tamata ovi wol Yahudi ra, rivun ilaꞌa rorang afa ovi rfalak ra ma rorang Duilaꞌa. ");
INSERT INTO frd_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Tamata ovi rorang Yesus naꞌa Yerusalem rarenar afa yai, ba rsinir Barnabas ma nti Antiokhia. ");
INSERT INTO frd_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Barnabas ti naran Antiokhia, na nsiꞌik i Ubu naflahar tamata ovi wol Yahudi ra, ba inan urun i lahir. Ia nfalak verin ira ne, “Myorang lalawatan Duilaꞌa ovu ralabira urun.” ");
INSERT INTO frd_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabas ini tamata lolin ia. Ubu Ni Roh nfangrebat ia ovu norang urun Ubu. Ba wean inyai bi tamata rivun rorang Duilaꞌa. ");
INSERT INTO frd_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Nata Barnabas nban-talik Antiokhia ma nti kota Tarsus ma ndava Saulus. ");
INSERT INTO frd_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ti ma ndav-nala Saulus, na novun ia nti Antiokhia ma rnaꞌa inyai varat isa. Irua rasdovu ira ovu tamata ovi rorang Yesus ma rair ira. Naꞌa inyai, na betfasa rfanara tamata ovi rorang Yesus ne, tamata Kristen. ");
INSERT INTO frd_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Naꞌut inyai, na nabi boku rtali Yerusalem rti vali Antiokhia. ");
INSERT INTO frd_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Tali tamata avyai, na tamata isa naran Agabus. Ubu Ni Roh nleal ia, ba ndiri ma nfalak verin tamata ra ne, Roma rira negara ra munuk veka lafar dawan. Lafar dawan yai nkena ira naꞌut i Kaisar Klaudius nfareta Roma rira negara rivun. ");
INSERT INTO frd_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ba tamata ovi rorang Yesus naꞌa Antiokhia raꞌan vai isa ma rala rira kubang ra verin terarir-valirira ovi rorang Yesus naꞌa Yudea, naꞌuk wol nlia rira ngrebat ra. ");
INSERT INTO frd_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ira rasdovuk kubang avyai ma rala verin Barnabas irua Saulus ma rtaha rti Yerusalem ma rala verin dawan kareda ovi reluk penatua. ");
INSERT INTO frd_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Kaꞌa bi naꞌa amar yai vali, na Raja Herodes nsinir ni suldadu ra ma rotu sian tamata boku tali ovi rorang Yesus. ");
INSERT INTO frd_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ia nsinir ni suldadu ra ma rtaha nahin blawat ra, ma ti rfedan Yohanes warin a naran Yakobus. ");
INSERT INTO frd_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Herodes nkaꞌa roak ne, Yahudi ra inar urun, ba nfareta ni suldadu ra ma rtaha Petrus vali. Notu afa avyai naꞌut amar i Yahudi ra rotu snoba ma raꞌan roti i wol rfadoku ragi naꞌa. ");
INSERT INTO frd_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Ba rtaha roak Petrus ma Herodes nfareta ma ti rfadoku ia naꞌa buꞌi ralan a. Suldadu vutu rahin inean rwanar ia naꞌa inyai, ba rsiduk ira naꞌa sidovung koꞌu ifaꞌat ma tamata fanfaꞌan lokat sidovung. Herodes nanovak ma wean i Yahudi rira snoba roak munuk roak, beti nukun Petrus ma tamata rivun rsiꞌik. ");
INSERT INTO frd_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ba Petrus nanaꞌa roak buꞌi ralan, naꞌuk sidovung tamata ovi rorang Yesus raflurut ovu ralarira urun verin Ubu ma nlobang ia. ");
INSERT INTO frd_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Teran ovan isa, na Herodes mane nukun Petrus. Rdadul Petrus ovu kakeak tmaꞌan irua, ma ntuba suldadu irua fruarira ra. Suldadu liak ra rwanar buꞌi ni falfolat a. ");
INSERT INTO frd_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Brian munuk, na Ubu Ni sansinir isa ntali lanit ratan nsuta ma ndir-ebang Petrus ma wan i ntuba yai lyawan. Sansinir yai nkafir nelan a ma nfalak ne, “Hei, bwatar kikyai!” Nfalak munuk wean inyai, na kakeak tmaꞌan avyai rleka lahir tali Petrus liman a. ");
INSERT INTO frd_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ba sansinir yai nfalak verin Petrus ne, “Meluk mu kadaravit a ovu bwaki mu tatea.” Ba Petrus not-orang lahir afa avyai. Sansinir yai nfalak ewal verin ia ne, “Moru mu ravit a blawat ma morang yaꞌa.” ");
INSERT INTO frd_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Nata ia norang sansinir yai ma rban-talik buꞌi yai, naꞌuk Petrus wol nkaꞌa obin ne, afa ovi sansinir notu ra kena te wahal, tevek nanari ne wean i namifi naꞌuk wol ntub-lufa. ");
INSERT INTO frd_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ba irua rbana lia suldadu boku naꞌa buꞌi yai, beti rbana lia suldadu liak boku vali ma raran falfolat tmaꞌan i mane rahu rti kota. Ti raran ana, falfolat yai kaꞌi natvadil watan, ba rbana ma rti raran murin ma rahu lingaꞌan isa. Brian munuk, na sansinir yai nti talik roak ia. ");
INSERT INTO frd_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Nata Petrus ni fikiran lyawan roak ma nfalak ne, “Ukaꞌa urun roak ne, inlangin a Ubu nsinir Ni sansinir isa ntali lanit ratan nma nlobang yaꞌa ma nfatalik yaꞌa tali Herodes liman ralan, boma deka utuan afa sian ovi Yahudi ra ranovak naꞌa yaꞌa.” ");
INSERT INTO frd_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ba ti ma nkaꞌa roak ne, Ubu nlobang ia, na nti lahir Maria i yanan verin Yohanes ni rahan a. Yohanes ini rfanara vali ia ne, Markus. Naꞌa inyai, na tamata rivun ovi rorang Yesus rasdovu ira ma raflurut. ");
INSERT INTO frd_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Petrus nevan falfolat i naꞌa murin a, ba vata sansinir isa naran Rode i nkarya naꞌa rahan yai nma ma nfatlina ne, iki nevan falfolat a. ");
INSERT INTO frd_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Vata yai nef-nala Petrus vain a, na inan urun i lahir, ba wol nvadil falfolat a. Ia nafla lahir ma ti nfalak verin tamata ovi rnaꞌa rahan ralan yai ne, Petrus ndiri murin. ");
INSERT INTO frd_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Naꞌuk tamata avyai wol rorang, ba rfalak ne, “Beta ne fwoar!” Ba vata yai nfalak lalawatan verin ira ne, “Ufalak urun!” Naꞌuk ira rfalak ne, “Inyai Ubu Ni sansinir i nwanar Petrus!” ");
INSERT INTO frd_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Naꞌuk Petrus nevan lalawatan falfolat a, ba rvadil ma rsiꞌik, na rtalkaka urun i lahir. ");
INSERT INTO frd_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Petrus nala liman a ma al notu faneak ma deka vair, beti nfamalik verin ira naꞌa i wean inba ma Ubu nfatalik ia tali buꞌi a. Nfamalik munuk, na nfalak verin ira ne, “Fyamalik vali afa ini verin Yakobus ovu tamata liak ovi rorang Yesus.” Nata nban-talik ira ma nti wan liak. ");
INSERT INTO frd_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ti ma ni ilyan varverak ana, vangoa-vanga dawan naꞌa buꞌi, tevek suldadu ovi rwanar buꞌi yai wol rkaꞌa ne, Petrus nahu ba nti. ");
INSERT INTO frd_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herodes nrenar roak ne, Petrus wol nleal, ba nsinir ni suldadu ra ti rdava ia, naꞌuk wol rdav-nala ia. Ba ia norat suldadu ovi rwanar Petrus a, beti nfareta ni suldadu liak boku vali ma ti rfedan suldadu ovi rwanar Petrus. Notu munuk wean inyai, beti nban-talik Yudea ma nti kota Kaisarea. Ia yaꞌi mnanat vali ia naꞌa inyai. ");
INSERT INTO frd_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herodes nangrova urun tamata ovi rleal kota Tirus ovu kota Sidon. Tamata avyai rvaꞌat ovu afamtahan i ntali Herodes ni negara, ba rasdovu ira ma raꞌan vai isa, beti rsinir rira tamata boku ma ti rdiri wahan ralan a, ma rera verin ia boma irmunuk rsimaklivur ewal ira. Ira rti lan ma rlolak Blastus ma rotu kida ovu ia. Blastus ini nsiꞌik Herodes ni rahan dawan a. ");
INSERT INTO frd_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Naran roak amar i Herodes nfadoku ma rsituan ira, ba neluk ni kadaravit mela ra ma ndoku kadera i ndoku ma nfareta a, ma nangrihi verin ira. ");
INSERT INTO frd_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Tamata ovi rarenar Herodes rfadawang ia ma rafwak ne, “Vaivatul avyai wol rtali tamata, naꞌuk rtali ubu isa!” ");
INSERT INTO frd_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Brian munuk, na Duilaꞌa Ni sansinir isa ntali lanit ratan nsuta notu ma Herodes nawar ma dawan ia, tevek nfakaratat tenan ma wol nalang Ubu. Ba masrat raꞌan ia, nata ti naran i nmata. ");
INSERT INTO frd_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Nata tamata ovi rarenar ovu rorang Ubu Ni vaivatul ra rtafal ma rivun ira. ");
INSERT INTO frd_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barnabas irua Saulus rala roak kubang i ntali tamata ovi rorang Yesus naꞌa Antiokhia verin kareda i naꞌa Yerusalem. Rewal ira rti Antiokhia, na rovun Yohanes i rfanara vali ia ne, Markus. ");
INSERT INTO frd_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Sidovung tamata ovi rorang Yesus naꞌa Antiokhia ni nabi boku, ovu tamata boku vali rair Surat Ralan verin tamata ra. Nararira ra: Barnabas, Simeon i nangtoan, Lukius i ntali kota Kirene, Saulus ovu Menahem i lan ana irua Raja Herodes Antipas dawan ira naꞌa rahan isa. ");
INSERT INTO frd_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Amar isa, na tamata ovi rorang Yesus raraning Duilaꞌa ovu rtolat, ma Ubu Ni Roh nfalak verin ira ne, “Fyili watan Barnabas ovu Saulus verin Yaꞌa, boma ti rfabana karya i ufadoku roak verin ira.” ");
INSERT INTO frd_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ira rtolat ovu raflurut munuk roak, na rfadoku limarira ra naꞌa ira, beti rsinir ira ma rti. ");
INSERT INTO frd_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Ubu Ni Roh nsinir Barnabas irua Saulus ma rti kota Seleukia. Rtali inyai, na ravul kabal lar ma robal rti nuhu isa naran Siprus. ");
INSERT INTO frd_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Ba ti raran kota Salamis, na rfamalik Ubu Ni vaivatul ra naꞌa Yahudi rira rahan falurut ra. Yohanes i rfanara vali ia ne Markus, norang vali ma nlobang ira. ");
INSERT INTO frd_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","8","Ira rban-lilit lahir nuhu yai ma ti raran kota Pafos. Naꞌa inyai, na rtuan tamata Yahudi isa naran Baryesus, naꞌa vai Yunani naran Elimas. Ia baꞌi ntaha afa te notu ni afnitu ra al nlabir waweang tamata ra, ovu nsiklabir ma nfalak ne nabi ia. Ia notu kida ovu nuhu yai ni gubernur naran Sergius Paulus. Gubernur yai ni kakaꞌa dawan ma nera Barnabas irua Saulus, tevek inan ma nrenar Ubu Ni vaivatul ra. Naꞌuk Elimas i ntaha afa te notu ni afnitu ra, nangal teri ira, boma gubernur yai deka norang Yesus. ");
INSERT INTO frd_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Naꞌuk Ubu Ni Roh nsoru lahir Saulus i rfanara vali ia ne Paulus, ma nsiꞌik nanuang Elimas, ");
INSERT INTO frd_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ma nfalak ne, “Oa nitdawan yanan oa, ba mangal teri lalawatan afa ovi kena ra, ovu mlabir tia ma watan tamata ra. Duilaꞌa Yesus Ni afa ovi notu ra rmalola, naꞌuk inam ma fwakiluk afa avyai. ");
INSERT INTO frd_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Eka msiꞌik kikyai, Duilaꞌa veka nukun oa ma mkibu, ma amar ifira nelak wol mrea lera vanan a!” Paulus nfalak munuk wean inyai, na brian munuk lova nteri matan a ma wol nsirea, ma nbana nteman tia ma watan al ndava tamata ma nfabana ia. ");
INSERT INTO frd_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Gubernur yai nsiꞌik afa yai, ba norang lahir Yesus. Ia ntalkaka, tevek rala ngrebat tali Ubu al rair Duilaꞌa verin tamata ra. ");
INSERT INTO frd_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Paulus ovu ni kida ra rban-talik Pafos ma ravul kabal lar isa ma robal rti kota Perga naꞌa propinsi Pamfilia. Naꞌuk Yohanes Markus nban-talik ira ma newal ia nti Yerusalem. ");
INSERT INTO frd_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ira rban-talik Perga ma rti raran kota Antiokhia i naꞌa propinsi Pisidia. Nata ti naran amar i Yahudi ra ryari ira, na rti ma rdoku rira rahan falurut ralan a. ");
INSERT INTO frd_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Tamata isa nbas tali Ubu Ni inukun ovi Musa nfadoku naꞌa ni kitab ra, ovu vali tali nabi rira kitab ra. Ti ma nbas munuk roak, na dawan ovi rnaꞌa rahan falurut yai rsinir tamata isa ma nfalak verin ira ne, “Tamata Yahudi averi, amera verin bir tinemun ne, wean i bira snurak lolin boku ma myala verin tamata ovi rnaꞌa ini, na fyalak verin ira.” ");
INSERT INTO frd_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Paulus ndiri ma nala liman a ma al notu faneak ma deka vair, beti nfalak verin ira ne, “Terang a valing Israel averi ovu tamata ovi wol Israel mia naꞌuk myorang Ubu, eka mryenar ma lolin afa ovi ufalak ra! ");
INSERT INTO frd_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Lalan a Ubu i Israel ra baꞌi raraning Ia nfili roak ubud-nusid ra, ovu notu ma rivun ilaꞌa ira naꞌut i rleal Mesir. Ubu novun ira ovu Ni ngrebat a ma rdir-talik Mesir. ");
INSERT INTO frd_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Varat vutfaꞌat, na Ia ntahang watan ralan verin ira naꞌa rira afa ovi rotu ra naꞌa wan lean vu dawan. ");
INSERT INTO frd_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ubu novun Israel ra ma rot-visal bangsa ifitu naꞌa Kanaan, beti nala lanun yai verin ira, boma rira lanun yai. ");
INSERT INTO frd_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Varat ratut ifaꞌat vutlima, na rotu munuk afa avyai. Nata Ubu nfili tamata dawan boku ma rfareta ira, ma ti naran naꞌut i nabi Samuel nvaꞌat a, na tamata avyai rfareta Israel ra. ");
INSERT INTO frd_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Israel ra rera verin Ubu ma nala raja isa ma nfareta ira. Ba Ubu nala Saul i yaman a naran Kish verin ira ma nfareta ira varat vutfaꞌat. Kish ini ubun-nusin ra rtali Yahudi rira arun dawan i naran Benyamin. ");
INSERT INTO frd_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Ba ti ma Ubu nfasuka Saul tali ni fareta, na nsikat Daud ma notu raja verin ira. Ubu nfamalik naꞌa Daud ne, ‘Yaꞌa urea roak Isai yanan i naran Daud a. Yaꞌa inak urun ia, tevek ni vavaꞌat nfakena lahir afa ovi ralang nfalak ra.’ ");
INSERT INTO frd_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Tali Daud ubun-nusin ra, na Ubu nala Yesus verin Israel ra ma nsikat ira tali rira salasilan ra, ma rira vavaꞌat kakiwal. Ubu notu wean inyai al nfakena Ni tnorung yai verin Daud. ");
INSERT INTO frd_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Yesus wol nfabana Ni karya obin, na Yohanes nfalak roak verin Israel ra ma rahil ma rtalik tali rira salasilan ra, boma nbaptis ira. ");
INSERT INTO frd_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Sarseri ma Yohanes notu munuk ni karya a, na norat ira ne, ‘Tali bir tinemun, na minovak ne yaꞌa ini iki? Yaꞌa wol weang Raja i ntevut dida salasilan ra! Mingnanang ma lolin afa ini, tevek yaꞌa uma lan ma ufavotuk verin mia ne, Ia veka nma. Wol inovan lahir ma aling ni tatea a, tevek yaꞌa wol verang a ratang Ia.’ ");
INSERT INTO frd_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Eka mryenar ta terang a valing ovi ububir-nusibira verin Abraham, ovu ovi wol Yahudi mia, naꞌuk myorang Ubu! Ia nala roak verin ita ivar i nfamalik ne, wean inba ma nsikat ita tali dida salasilan ra, ma dida vavaꞌat kakiwal. ");
INSERT INTO frd_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Tamata Yahudi ovi rnaꞌa Yerusalem ovu rira dawan ra wol rkaꞌa ne, Yesus yai Tamata i nabi ra rfamalik lan roak. Lokat amar i ryari ira, na rbas vaivatul ra tali nabi ra, naꞌuk wol rfan-aran. Ira rukun Yesus ma nmata, ba rfakena vaivatul avyai. ");
INSERT INTO frd_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Velik ne wol rtuan sala isa vali naꞌa Yesus ma rukun Ia, naꞌuk rera roak verin gubernur Pilatus ma ni suldadu ra rfedan Ia. ");
INSERT INTO frd_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ba rfakena munuk roak afa ovi lan a rfadoku naꞌa Surat Ralan a, beti rfasuka tenan a tali aa walwalur ma rfanuba Ia naꞌa van matmatan isa ralan. ");
INSERT INTO frd_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Naꞌuk Ubu nfavaꞌat ewal Ia tali matmatan. ");
INSERT INTO frd_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Nata Yesus nfavotuk Ia naꞌa amar rivun verin tamata ovi rban-orang Ia tali Galilea, ma irmunuk rti Yerusalem. Fiang ini tamata avyai rfamalik Yesus verin Yahudi ra. ");
INSERT INTO frd_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","Ba amfalak ivar lolin ini verin mia. Ubu nfakena munuk roak Ni tnorung i lalan a nfalak verin ubud-nusid ra, ma nfavaꞌat ewal Yesus. Mazmur pasal irua nfalak wean ini, ‘Yaꞌa Yanak Oa! Amar ini lahir, ufalak verin Oa ne, Yamam Yaꞌa.’ ");
INSERT INTO frd_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Ubu nfavaꞌat ewal roak Ia tali matmatan, ba Ia veka wol nmata roak. Ubu nfavotuk afa yai nahu Ni vaivatul ovi ne: ‘Yaꞌa veka ufakena lahir Ning tnorung ovi rmerat urun verin Oa. Tnorung avyai lalan a ufalak roak verin Daud.’ ");
INSERT INTO frd_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Daud nfamalik vali naꞌa Mazmur liak ma nfalak verin Ubu ne, ‘Oa veka wol mtorung ma Mu Tamata i nmerat urun yai tenan a nakvisal.’ ");
INSERT INTO frd_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Daud notu munuk roak afa ovi Ubu ralan nfalak ma notu naꞌut i nvaꞌat obin, nata ti naran i nmata, ma ti rfadok-ebang ia ovu ubun-nusin ra, ba tenan nakvisal munuk. ");
INSERT INTO frd_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Naꞌuk Yesus i Ubu nfavaꞌat ewal Ia tali matmatan yai, tenan a wol nakvisal. ");
INSERT INTO frd_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Ba terang a valing averi, mia musti mkyaꞌa ne, ami amfamalik ne, Ubu saꞌi naꞌi vatuk dida salasilan ra, tevek Yesus nmata verin ita. Tamata iki watan norang Yesus, na Ubu veka naꞌi vatuk ni salasilan ra vali. Mia myorang Musa ni inukun ra, naꞌuk inukun avyai wol raꞌi vatuk nala bira salasilan ra. ");
INSERT INTO frd_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Ba msyiꞌik wabira ma lolin, boma afa ovi nabi ra rfadoku roak naꞌa rira kitab ra deka rkena mia: ");
INSERT INTO frd_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Eka mryenar ma lolin! Mia tamata ovi fyalak sian Yaꞌa. Mia veka mtyalkaka lahir ma myata! Tevek fiang ini, na Yaꞌa veka otu afa isa, naꞌuk mia wol myorang, velik ne tamata isa nfalyawang roak verin mia.’ ” ");
INSERT INTO frd_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Paulus irua Barnabas rsilyaha tali Yahudi rira rahan falurut, na tamata ra rasweang ira ma rfamalik ewal afa avyai verin ira, naꞌut amar i veka nma ma Yahudi ra ryari ira. ");
INSERT INTO frd_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Ti ma tamata ra rsilyaha munuk roak tali rira rahan falurut a, na tamata Yahudi rivun, ovu vali ovi wol Yahudi ira naꞌuk rorang Yahudi rira agama, rban-orang Paulus ovu Barnabas. Ba rasul irua ini rangrihi al rsurak ira ma rorang lalawatan Ubu i nlobang ita, ovu nala Ni rala lolin verin ita. ");
INSERT INTO frd_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Ba amar i Yahudi ra ryari ira nma ewal, na tamata ovi rnaꞌa kota yai labir mane munuk lahir rasdovu ira ma rarenar Ubu Ni vaivatul ra. ");
INSERT INTO frd_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ti ma Yahudi ra rsiꞌik tamata rivun avyai, na ralarira sian urun Paulus, ba rangrihi ma rworuk-rwak ia ovu wol rtorung afa ovi nfalak ra. ");
INSERT INTO frd_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Naꞌuk Paulus irua Barnabas rabrahi watan ma rfalak verin ira ne, “Ubu nfareta ma amfamalik lan Ni vaivatul ra verin mia, tamata Yahudi ra, naꞌuk mifena ma myorang. Mifena, ba mia kaꞌi fyaturu ne, wol inovan ma bira vavaꞌat kakiwal ovu Ubu. Ba wean inyai bi amban-talik mia ma amati watan tamata ovi wol Yahudi ra. ");
INSERT INTO frd_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Amotu wean inyai, tevek Ubu nfareta ami ma nfalak ne, ‘Yaꞌa ufadoku roak mia ma myeluk lyawan verin tamata ovi wol Yahudi ira, boma mia veka fyamalik verin tamata ra naꞌa lanit ivavan a munuk ne, wean inba ma Yaꞌa veka usikat ira tali rira salasilan ra, ma rira vavaꞌat kakiwal.’ ” ");
INSERT INTO frd_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ba tamata ovi wol Yahudi ira rarenar afa avyai, na inar lolin ma rfadawang Ubu, tevek Ni vaivatul ra naꞌa Yesus. Tamata ovi Ubu nfili roak ira ma rira vavaꞌat kakiwal, rorang Ni vaivatul ra. ");
INSERT INTO frd_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ba Ubu Ni vaivatul ra ti rsoru munuk wan yai. ");
INSERT INTO frd_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Naꞌuk Yahudi ra rfakeri vata mela boku ovu rira dawan boku naꞌa kota yai, ralarira ra. Vata ovi wol Yahudi ira, naꞌuk ralang Ubu. Ira rotu wean inyai ma rwi-rwa Paulus irua Barnabas, ma ralaꞌing ira tali inyai. ");
INSERT INTO frd_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ba irua rasnabar vatuk kyavu tali earira ra ma al rtabu ira, beti rban-talik ira ma rti kota Ikonium. ");
INSERT INTO frd_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Tamata ovi rorang Yesus naꞌa Antiokhia ralarira lolin urun, ovu Ubu Ni Roh nfangrebat ira. ");
INSERT INTO frd_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Paulus irua Barnabas rti raran kota Ikonium, na rti Yahudi rira rahan falurut ralan ma rfamalik Ubu Ni Ivar Lolin. Ira rangrihi ma rala lahir tamata Yahudi ovu ovi wol Yahudi ralarira ra, ba rivun ilaꞌa rorang Yesus. ");
INSERT INTO frd_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Naꞌuk tamata Yahudi ovi wol rorang Yesus rfakeri tamata ovi wol Yahudi ralarira ra ma wol inar lahir tamata ovi rorang Yesus. ");
INSERT INTO frd_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Paulus irua Barnabas mnanat ira naꞌa inyai. Irua rabrahi ma rfamalik Duilaꞌa. Ba Ubu nala ngrebat verin ira ma rotu mujizat ra, ovu rotu faneak ovi tamata ra wol rot-nala ma al rfaturu ne, afa ovi rfalak naꞌa Ubu Ni rala lolin a, kena. ");
INSERT INTO frd_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Tamata ovi rnaꞌa kota yai ralarira ra rsifarsangal ira, ba boku rorang tamata Yahudi ra, na boku vali rorang rasul irua yai. ");
INSERT INTO frd_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Tamata ovi wol Yahudi ra, ovu tamata Yahudi ra, ovu vali rira dawan ra raꞌan vai isa mane rotu sian Paulus irua Barnabas ma rtev-fedan ira. ");
INSERT INTO frd_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Naꞌuk irua rkaꞌa roak, ba rafla rti kota Listra, kota Derbe ovu ahu liak ra naꞌa wan isa naran Likaonia. ");
INSERT INTO frd_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Naꞌa inyai, na rfamalik vali Ubu Ni Ivar Lolin. ");
INSERT INTO frd_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Naꞌa Listra, na brana isa ean ra rmafun ma wol nbana nala, tevek natlukut tali amar i rarali ia. ");
INSERT INTO frd_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Tamata yai nrenar afa ovi Paulus nfalak ra. Paulus nsiꞌik ia ma nkaꞌa ne, ni inorang a dawan ma veka lolin ia. ");
INSERT INTO frd_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Paulus vain a dawan ma nfalak ne, “Mdiri kikyai!” Ba tamata yai naswatil ma ndiri, ma nbana lahir. ");
INSERT INTO frd_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Tamata rivun ovi rarenar Paulus rsiꞌik afa ovi beti notu ra, ba rala vai Likaonia al rafwak ne, “Ubu ra rtali lanit ratan reluk tamata ma rsuta roak!” ");
INSERT INTO frd_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ira rfanara Barnabas ne Zeus, ovu vali rfanara Paulus ne Hermes, tevek ia nangrihi ma dawan. ");
INSERT INTO frd_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Rira ubu Zeus ni mela falurut nkarya naꞌa rira rahan falurut i ndok-ebang kota yai. Mela falurut yai nala karba brana ifira ovu aa ni fafun ra, ma rovun ira rti falfolat ilaꞌa i naꞌa Listra ni fidu, boma rasnuri afwatan avyai ma al raraning Barnabas irua Paulus. ");
INSERT INTO frd_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Irua rarenar afa ovi tamata avyai mane rotu verin ira, na rkamadir lahir rira kadaravit ra ma rafla ti rdiri tamata avyai waharira ralan ra ma rafwak ne, ");
INSERT INTO frd_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Kida averi, afakinimi myotu wean ini? Ami tamata watan ami wean mia! Amnaꞌa ini ma amfamalik Ubu Ni Ivar Lolin verin mia, boma myahil ma deka mryaning ubu ovi wol rot-nala akataka. Myorang aꞌuk Ubu, tevek Ia nvaꞌat ma notu lanit, lanit ivavan a, tahat ovu afa ovi rnaꞌa munuk lahir ralan a. ");
INSERT INTO frd_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Lalan ana, Ubu nsiꞌik watan ma bangsa ra munuk kaꞌi rban-orang afa ovi ralarira ra rfalak ra. ");
INSERT INTO frd_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Naꞌuk Ia notu ma tamata ra rkaꞌa Ia. Ia nfaturu Ni lolin a, ma lokat varat nala daꞌut ovu vali notu ma bira vaꞌi ra ihirira. Ia nala afamtahan rivun verin mia ovu notu ma inabira lolin.” ");
INSERT INTO frd_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Velik ne rasul irua yai rfalak roak wean inyai, naꞌuk susa watan obin ma rangal tamata rivun avyai, ma deka rasnuri rira karba ra ma raraning ira. ");
INSERT INTO frd_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Nata Yahudi boku rtali Antiokhia ovu Ikonium rma Listra, ma rweang tamata rivun naꞌa inyai ma rteva Paulus, beti rving soli-sasan ia ma rti kota murin. Ira rnarin ne, Paulus nmata roak. ");
INSERT INTO frd_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Naꞌuk tamata ovi rorang Yesus rdir-lilit ia, nata nbatar ma newal ia nti kota ralan. Ni ilyan ana, irua Barnabas rti kota Derbe. ");
INSERT INTO frd_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Naꞌa Derbe, na Paulus irua Barnabas rfamalik Ubu Ni Ivar Lolin a, ba tamata rivun rorang Yesus. Irua rotu munuk roak wean inyai, beti rewal ira rti Listra, Ikonium ovu Antiokhia. ");
INSERT INTO frd_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ira rnaꞌa kota avyai, na rala snurak lolin ma al rfangrebat tamata ovi rorang Yesus ralarira ra, boma rorang aꞌuk Yesus. Ira rfalak ne, “Kida averi, ita tatuan lan susa rivun veki, beti ti tnaꞌa Ubu Ni Fareta Ralan.” ");
INSERT INTO frd_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Paulus irua Barnabas rfaturu tamata ra verin lokat sidovung tamata ovi rorang Yesus ma rnaꞌa rira dawan kareda ovi reluk penatua. Nata irua raflurut ovu rtolat, beti rera verin Duilaꞌa ma nwanar ira, tevek rorang lan roak Ia. ");
INSERT INTO frd_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Rotu munuk wean inyai, na rahu propinsi Pisidia ma rti raran propinsi Pamfilia. ");
INSERT INTO frd_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Ira rfamalik munuk Ubu Ni vaivatul ra naꞌa kota Perga, beti rti kota Atalia. ");
INSERT INTO frd_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Tali inyai, na ravul kabal lar ma robal rti ewal Antiokhia. Lan a naꞌa Antiokhia, na tamata ovi rorang Yesus rera verin Ubu ma nala Ni rala lolin verin Paulus irua Barnabas, boma rfabana rira karya i beti rotu munuk a. ");
INSERT INTO frd_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Ti ma raran Antiokhia, na rasweang sidovung tamata ovi rorang Yesus ma rasdovu ira, beti rfamalik munuk Ubu Ni afa ovi notu roak verin ira naꞌa rira karya ra. Ira rfamalik vali ne, wean inba ma Ubu nala Ni lingaꞌan lolin verin ira, boma tamata ovi wol Yahudi ra rorang vali Yesus. ");
INSERT INTO frd_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Paulus irua Barnabas mnanat lahir ira naꞌa kota yai, ma irmunuk tamata ovi rorang Yesus rleal inyai. ");
INSERT INTO frd_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Amar isa, na tamata boku rtali propinsi Yudea rma kota Antiokhia ma rair tamata ovi rorang Yesus, naꞌuk wol Yahudi ira. Ira rfalak ne, “Musa ni inukun ra rfalak ne, wean i wol rsunat mia, na Ubu wol nsikat mia tali bira salasilan ra, ma bira vavaꞌat kakiwal.” ");
INSERT INTO frd_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Paulus irua Barnabas wol inar lahir afa i tamata avyai rfalak a, ba vair ma dawan. Nata raꞌan vai isa ma irua ovu tamata boku ovi rorang Yesus rti Yerusalem, ma rfamalik afa ini verin rasul ra ovu dawan kareda ovi reluk penatua. ");
INSERT INTO frd_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ba tamata ovi rorang Yesus naꞌa Antiokhia rfatuang ira rti kota murin a, beti rbana rti propinsi Fenisia ovu propinsi Samaria ma rfamalik naꞌa tamata ovi wol Yahudi ira naꞌuk rorang Yesus. Tamata ovi rorang Yesus naꞌa inyai rarenar ivar yai, na inar lolin. ");
INSERT INTO frd_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ti raran Yerusalem, na tamata ovi rorang Yesus ovu rasul ra, ntafal vali dawan kareda ovi reluk penatua, rti ma rala ira. Ira rfamalik munuk afa ovi Ubu notu roak verin ira naꞌa rira karya verin tamata ovi wol Yahudi ra. ");
INSERT INTO frd_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Naꞌuk tamata ovi rorang Yesus boku rtali Yahudi rira sidovung isa naran Farisi rdiri ma rfalak ne, “Tamata ovi wol Yahudi ira, naꞌuk rorang roak Yesus, musti rot-orang Musa ni inukun ra ovu rsunat vali ira.” ");
INSERT INTO frd_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Ba rasul ra ovu dawan kareda ovi reluk penatua rasdovu ira ma rfamalik afa ini. ");
INSERT INTO frd_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Rasdovu ira yaꞌi mnanat vali ma rsiforat ira, beti Petrus ndiri ma nfalak ne, “Terang a valing averi, mia mkyaꞌa roak ne, amar rivun nti roak veli, na Ubu nfili yaꞌa tali bir tinemun ma ti ufamalik Ni Ivar Lolin verin tamata ovi wol Yahudi ra, boma rarenar ma rorang vali Yesus. ");
INSERT INTO frd_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Ubu nkaꞌa munuk lahir tamata ralarira ra. Ia nfaturu roak ne, nfili ira ma nala Ni Roh verin ira wean i notu roak verin ita. ");
INSERT INTO frd_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Ubu nsiꞌik ita tamata Yahudi, ovu tamata ovi wol Yahudi, wead isa watan, ba notu vali ma ralarira ra rmerat, tevek rorang roak Yesus. ");
INSERT INTO frd_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ba afaki notu mi mlyabir teman Ubu ma myala varvara aleman verin tamata ovi wol Yahudi ra? Deka mkyiwal tamata ovi rorang Yesus, naꞌuk wol Yahudi ira, ma rorang Musa ni inukun ra! Ita ovu ubud-nusid ra wol tvar-nala vali varvara yai. ");
INSERT INTO frd_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Deka tkiwal ira ma rorang Musa ni inukun ra, tevek ita torang ne, Duilaꞌa Yesus nala Ni rala lolin verin ita ma nsikat ita tali dida salasilan ra, ma dida vavaꞌat kakiwal. Tamata ovi rorang Yesus, naꞌuk wol Yahudi ira, na ira wean vali ita ma rira vavaꞌat kakiwal!” ");
INSERT INTO frd_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Nata tamata rivun ovi rnaꞌa inyai wol vair lahir, ba Barnabas irua Paulus rfamalik lalawatan Ubu Ni ngrebat i nala verin ira, ma rotu mujizat ovu rotu faneak ovi tamata ra wol rot-nala verin tamata ovi wol Yahudi ra. ");
INSERT INTO frd_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Rangrihi munuk roak, beti Yakobus nfalak ne, “Terang a valing averi, eka mryenar yaꞌa! ");
INSERT INTO frd_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simon Petrus nfamalik roak ne, lalan ana Ubu nfaturu Ni rala lolin verin tamata ovi wol Yahudi ra, ma nfili boku tali ira ma reluk Ni tamata ra. ");
INSERT INTO frd_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Afa yai wean lahir i nabi ra rfamalik lan roak. Nabi isa ntulis ne: ");
INSERT INTO frd_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Amar liak, na veka uma ma ufadiri ewal Raja Daud ni rahan i nleka roak. Rahan yai namaꞌar, naꞌuk Yaꞌa veka ufadiri ewal ia naꞌa wan a, ");
INSERT INTO frd_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","boma tamata ra munuk bisma rdava Duilaꞌa. Otu wean ini, boma tamata ovi ufili roak ira, velik ne Yahudi te wol Yahudi ira, veka rorang Yaꞌa. Yaꞌa Duilaꞌa Yaꞌa, ");
INSERT INTO frd_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","ba tali lalan a ufavotuk roak afa ovi otu ra verin tamata ra.’ ” ");
INSERT INTO frd_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Yakobus ntafal ma nfalak ne, “Yaꞌa unovak ne, tamata ovi wol Yahudi ira, naꞌuk inar ma rorang vali Ubu, na ita deka totu susa ira. ");
INSERT INTO frd_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Ni lolin a tasusan surat verin ira ma tsurak ira ma deka raꞌan afamtahan ovi rala roak al raraning walut ra, te raꞌan afwatan ihin tali afwatan ovi rfungal ma rfedan ira, ovu deka renu te raꞌan lara. Deka rsifa tia ma watan ovu tamata ovi wol awarira verin ira. ");
INSERT INTO frd_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Tali lalan ana, tamata ra rfamalik Musa ni inukun ra. Lokat amar i ryari ira, na tamata ra rfamalik inukun avyai naꞌa rira rahan falurut ra naꞌa ahu ra munuk.” ");
INSERT INTO frd_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Rasul ra ovu dawan kareda ovi reluk penatua, irmunuk tamata ovi rorang Yesus naꞌa rira sidovung a raꞌan vai isa ma rfili tamata ifira tali ira, ma irmunuk Paulus ovu Barnabas rti Antiokhia. Ba rfili Silas ovu Yudas i rfanara vali ia ne Barsabas. Tamata irua ini rban-ulu vali naꞌa rira sidovung. ");
INSERT INTO frd_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ira rala surat ma rtaha. Surat yai ihin wean ini: “Ami ini rasul ra, dawan kareda ovi ameluk penatua, ovu terabir-valibira ra amasusan surat ini verin tamata ovi rorang Yesus, naꞌuk wol Yahudi ira, ma rleal Antiokhia, propinsi Siria ovu propinsi Kilikia. Amala salam verin mia! ");
INSERT INTO frd_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Ami amrenar ne, tamata ifira rtali mami sidovung ti rlolak mia, ma rotu ma wahabira rwaꞌuk naꞌa afa ovi rair ra. Ami wol amsinir ira ma rotu afa avyai. ");
INSERT INTO frd_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Amasdovu ami ma amaꞌan vai isa ma amfili brana ifira ma ti rdoku ovu mia. Ira veka irmunuk Barnabas ovu Paulus. Irua ini amlobang urun ira. ");
INSERT INTO frd_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Tamata irua ini wol rbobar ma rmata naꞌa karya ini, tevek dida Duilaꞌa Yesus Kristus. ");
INSERT INTO frd_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Ba amsinir Yudas irua Silas ma ti rfalyawang mami vaivatul ovi rnaꞌa surat ini verin mia. ");
INSERT INTO frd_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Ubu Ni Roh ntorung roak, ovu ami amtorung vali, boma deka amala varvara aleman verin mia, ba amala watan varvara ovi byar-nala, wean ini: ");
INSERT INTO frd_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","deka mian afamtahan ovi rala roak al raraning walut ra, deka mian afwatan ihin tali afwatan ovi fyungal ma fyedan ira, ovu deka myenu te mian lara. Deka msyifa tia ma watan ovu tamata ovi wol awabira verin ira. Wean i fyaroa tenabira tali afa avyai, na kena roak mia. Lawan watan inyai ta bir tinemun, ba ki tsituan ewal ita.” ");
INSERT INTO frd_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Rsituli munuk roak ira, beti irfaꞌat rban-talik ira ma rti Antiokhia. Ira rasdovu munuk tamata ovi rorang Yesus naꞌa inyai ma rala surat yai verin ira. ");
INSERT INTO frd_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Tamata ovi rorang Yesus rbas munuk surat yai, ba ralarira lolin urun, tevek ihin nfaloling ralarira ra. ");
INSERT INTO frd_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yudas irua Silas nabi vali ira. Ira rsurak ma mnanat terad a valid ovi rnaꞌa Antiokhia ma rfaloling ovu rfangrebat ralarira ra. ");
INSERT INTO frd_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Irua rnaꞌa inyai ma yaꞌi mnanat roak, beti tamata ovi rorang Yesus naꞌa inyai rsinir ira ma rewal ira rti Yerusalem, ma rfalak verin tamata ovi rsinir ira ne, fara Ubu naflahar ira.  ");
INSERT INTO frd_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Naꞌuk Silas ralan nfalak ma nanaꞌa watan inyai. ");
INSERT INTO frd_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Paulus irua Barnabas mnanat vali ira naꞌa Antiokhia. Ira ovu tamata rivun vali rair ovu rfamalik Duilaꞌa Ni vaivatul ra. ");
INSERT INTO frd_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Ba amar isa, na Paulus nfalak verin Barnabas ne, “Mwa ma ti tfalokat ewal ahu ovi lan a tfamalik roak Ubu Ni vaivatul ra, ma talola terad a valid ovi rorang roak Yesus, boma tsiꞌik ne, rira vavaꞌat a wean inba.” ");
INSERT INTO frd_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabas inan ma novun Yohanes i rfanara vali ia ne Markus, ");
INSERT INTO frd_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","naꞌuk Paulus nanovak ne, wol lolin ma rovun Markus, tevek ia nban-talik roak ira naꞌa propinsi Pamfilia, velik ne rira karya nbana obin. ");
INSERT INTO frd_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Barnabas irua Paulus rsitaku ulurira naꞌa rira fikiran ra, ma ti nata rban-sialing roak ira, ba Barnabas nala Markus ma irua ravul kabal lar ma robal rti nuhu isa naran Siprus. ");
INSERT INTO frd_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Naꞌuk Paulus nfili Silas ma nkarya ovu ia. Wol rti obin, na tamata ovi rorang Yesus naꞌa kota Antiokhia rera verin Ubu ma nala Ni rala lolin verin ira. ");
INSERT INTO frd_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Irua rti ma rban-lilit propinsi Siria ovu propinsi Kilikia, ma rfangrebat sidovung tamata ovi rorang Yesus naꞌa inyai, boma rira inorang nangrebat. ");
INSERT INTO frd_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Paulus irua Silas rti lan kota Derbe, beti rti kota Listra. Tamata isa i norang Yesus naran Timotius nanaꞌa inyai. Renan Yahudi ia ma norang roak Yesus, naꞌuk yaman a tamata Yunani ia. ");
INSERT INTO frd_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Tamata ovi rorang Yesus naꞌa Listra ovu kota Ikonium rfalak ne, Timotius tamata lolin ia. ");
INSERT INTO frd_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paulus inan ma Timotius novu vali ma irmunuk, ba rsunat ia, tevek Yahudi ovi rnaꞌa wan yai rkaꞌa ne, Timotius yaman ntali Yunani. ");
INSERT INTO frd_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Nata rtali ahu isa rti ahu isa ma rsurak tamata ovi rorang Yesus. Ira rfamalik verin ira naꞌa afa ovi rasul ra ovu dawan kareda ovi reluk penatua naꞌa Yerusalem rfadoku roak a, boma sidovung tamata ovi rorang Yesus rot-orang. ");
INSERT INTO frd_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Ba amar nkati amar, na sidovung tamata ovi rorang Yesus rira inorang ntafal ma nangrebat, ovu vali ntafal ma rivun ira. ");
INSERT INTO frd_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Ubu Ni Roh notu teri ma Paulus irua Silas deka rfamalik Ni Ivar Lolin naꞌa propinsi Asia, ba irua rbana rti propinsi Frigia ovu propinsi Galatia. ");
INSERT INTO frd_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Ti raran propinsi Misia ni elat ratan a, mane rti propinsi Bitinia, naꞌuk Yesus Ni Roh notu teri ma deka rti inyai. ");
INSERT INTO frd_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Ba rban-etal Misia ma rti lahir kota Troas. ");
INSERT INTO frd_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ni ovan ana, Paulus wean i namifi naꞌuk wol ntub-lufa ma nrea ne, brana isa ntali propinsi Makedonia ndiri wahan ralan a, ma nera ovu ralan urun ne, “O baba, eka mwa Makedonia ma mlobang ami.” ");
INSERT INTO frd_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Paulus wean i namifi munuk, na amasusan wamami ma amban-talik lahir wan yai ma amati Makedonia, tevek amkaꞌa ne, Ubu nera ami ma ti amfamalik Ni Ivar Lolin verin tamata ovi rnaꞌa ineri. ");
INSERT INTO frd_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Amavul kabal lar isa naꞌa Troas ma amobal amati lahir nuhu isa naran Samotrake, ma ni ilyan ana, amati kota Neapolis. ");
INSERT INTO frd_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Tali inyai, na amati kota dawan isa naran Filipi naꞌa propinsi Makedonia. Tamata Roma rivun rleal kota yai, ovu amnaꞌa inyai amar ifira vali. ");
INSERT INTO frd_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Naran amar i ami tamata Yahudi amyari ami, na amahu kota ni falfolat ilaꞌa i naꞌa ni fidu ma amati oar isa nelan, tevek amanovak ne, tamata ra rasdovu ira ma raflurut naꞌa inyai. Ba amdoku ma amangrihi ovu vata ovi rasdovu ira naꞌa inyai. ");
INSERT INTO frd_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Tali vata avyai, na isa ntali kota Tiatira naran Lidia. Ia nfedi maloli ungu. Vata yai baꞌi nraning Ubu. Ba naꞌut i nrenar afa ovi Paulus nfalak ra, na Duilaꞌa notu ma ralan natvelar ma ntorung afa avyai. ");
INSERT INTO frd_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Ira rbaptis ia ovu ni rahan teta a. Nata vata yai nera verin ami ne, “Ning kida averi, wean i mkyaꞌa roak ne, yaꞌa orang urun Duilaꞌa Yesus, na mya ma milola ami naꞌa ning rahan veki.” Ia nkiwal nala ami ma amnaꞌa ni rahan. ");
INSERT INTO frd_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Amar isa, na mane amati wan falurut i naꞌa oar nelan yai, na amtuan vata sansinir isa. Vata yai nait sian nleal ia, ma notu ma nanovak nala afa ovi veka rvotuk naꞌa amar ovi veka rma. Vata yai notu ma duan ra rira kubang a dawan, tevek tamata ra rbahir ia ma nfalak afa ovi veka rkena ira. ");
INSERT INTO frd_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Vata yai norang lalawatan Paulus ovu ami ma nafwak ne, “Brana ovi rkarya verin Ubu i Ni dawan nlia munuk afakataka. Ira rfamalik ne, wean inba ma Ia veka nsikat mia tali bira salasilan ra, ma bira vavaꞌat kakiwal!” ");
INSERT INTO frd_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Amar ifira lahir vata yai nafwak wean inyai, ba ti nata Paulus wol ntahang nala roak, ba nfulak ia ma nfalak verin nait sian yai ne, “Yaꞌa ala Yesus Kristus naran ovu Ni ngrebat, ma ufareta oa ma muti talik vata ini!” Naꞌut inyai lahir, na nait sian yai nti talik ia. ");
INSERT INTO frd_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Vata yai duan ra rkaꞌa roak ne, wol rdav-nala roak kubang tali ia. Ba rtaha Paulus irua Silas ma rlia soli-sasan ira rti wan i rfedi-rfaha afa naꞌa, ma rdiri dawan fareta waharira ralan ra. ");
INSERT INTO frd_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Ba vata yai duan ra rtaha roak Paulus ovu Silas verin Roma rira dawan fareta ra ma rfalak ne, “Tamata irua ini Yahudi ira. Rma ma rotu ma vangoa-vanga naꞌa dida kota a! ");
INSERT INTO frd_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Ira rair tamata ra ma rot-orang rira adat ovu inukun ovi wol kena ovu ita, tamata Roma, dida adat ovu inukun ra! Ba deka torang rira adat ra!” ");
INSERT INTO frd_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Tamata rivun rdiri vali ma rangal Paulus irua Silas. Dawan fareta avyai rfareta rira tamata ra ma raling irua rira kadaravit ra, beti rala navnaval ra ma al rvaval ira. ");
INSERT INTO frd_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Rvaval ma dawan roak ira, beti rovun ira ma ti rvatuk ira naꞌa buꞌi ralan. Nata rfareta tamata dawan i nfareta buꞌi ma nsiꞌik ma lolin ira. ");
INSERT INTO frd_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Tamata yai norang afa ovi ni dawan ra rfalak verin ia, ba nvatuk lahir ira naꞌa buꞌi ralan, beti nala kakeak tmaꞌan al ndadul earira ra naꞌa liri dawan ra. ");
INSERT INTO frd_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Kaꞌa bi nafafruan tenan, na Paulus irua Silas raflurut ovu rdedang ma al raraning Ubu. Tamata liak ovi raꞌabuꞌi roak ira naꞌa inyai rarenar vali. ");
INSERT INTO frd_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Brian munuk, na ruru dawan urun i lahir, ma buꞌi yai nawelu ma ti naran ni fanderen a. Falfolat ra munuk ratvadil lahir ovu kakeak tmaꞌan ra munuk rablewar ma rleka tali tamata ovi rnaꞌa buꞌi ralan. ");
INSERT INTO frd_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Dawan i nfareta buꞌi yai nbatar ma nsiꞌik, na falfolat ra ratvadil roak, ba ntavar ni nahin blawat mane nfedan tenan, tevek nanarin ne, tamata ovi rnaꞌa buꞌi ralan rafla munuk roak. ");
INSERT INTO frd_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Naꞌuk Paulus nafwak ma vain dawan ma nfalak ne, “Deka fwedan tenam a! Ami amnaꞌa munuk ini obin!” ");
INSERT INTO frd_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Tamata dawan yai nera ma rala ulu isa, ma nafla ovu ulu yai nti ralan. Nti naran, na tenan a raruru ma nsangatur nulu Paulus irua Silas. ");
INSERT INTO frd_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Nata novun ira rti murin ma norat ne, “Baba averi, yaꞌa musti otu afaka, boma Ubu nsikat yaꞌa tali ning salasilan ra, ma ning vavaꞌat kakiwal?” ");
INSERT INTO frd_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ira rfalak verin ia ne, “Morang Duilaꞌa Yesus Kristus, boma Ia veka nsikat oa tali mu salasilan ra, ma mu vavaꞌat kakiwal, oa ovu vali mu rahan teta!” ");
INSERT INTO frd_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Nata ira rfamalik Ubu Ni vaivatul ra verin ia ovu tamata ovi rnaꞌa ni rahan a munuk. ");
INSERT INTO frd_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Nafafruan tenan yai vali, na dawan i nfareta buꞌi yai novun irua ma nfamerat rira mngala ra. Nata rbaptis lahir ia ovu ni rahan teta munuk. ");
INSERT INTO frd_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Rbaptis munuk ira, beti novun Paulus irua Silas rti ni rahan ma nfaꞌan ira. Ia ovu ni rahan teta inar lolin, tevek rorang roak Ubu. ");
INSERT INTO frd_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Ni ilyan varverak a, na Roma rira dawan fareta ra rsinir rira tamata ra rti ma rfalak verin dawan i nfareta buꞌi yai ne, “Fwatalik kikyai tamata irua yai!” ");
INSERT INTO frd_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Ba dawan i nfareta buꞌi yai nfalak ivar yai verin Paulus. Ia nfalak ne, “Baba averi, dawan fareta ra rfalak roak ma ufatalik mia, ba myewal mia kikyai ovu byana ma lolin.” ");
INSERT INTO frd_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Naꞌuk Paulus nfalak verin dawan fareta rira tamata avyai ne, “Yaꞌi yo, ami tamata Roma ami, naꞌuk wol fyaleka inukun verin ami obin, na rvaval ma dawan roak ami naꞌa tamata rivun waharira ralan ra, nata rvatuk ami ti buꞌi ralan ma rdadul ami. Ira mane rfareta ami ma amban-talik wan ini, naꞌuk rfonak ma tamata ra deka rkaꞌa. Wol kena lahir! Eka msyinir dawan fareta avyai ma kaꞌi rma ma rfatalik ami!” ");
INSERT INTO frd_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Roma rira dawan fareta ra rira tamata ra ti rfamalik afa ini verin ira, ba rarenar ne Paulus irua Silas tamata Roma ira, na rbobar urun, tevek wol rot-orang Roma rira inukun ra. ");
INSERT INTO frd_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Ba rti ma rera verin Paulus irua Silas ma rabun afa sian ovi rotu verin ira. Nata rovun irua tali buꞌi ralan ma rera ovu ralar urun verin ira, ma rban-talik kota yai. ");
INSERT INTO frd_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Paulus irua Silas rban-talik roak buꞌi yai ma rti Lidia ni rahan. Naꞌa inyai, na rtuan tamata ovi rorang Yesus, ba irua rsurak ira, boma rira inorang deka kakoꞌu, beti rban-talik ira. ");
INSERT INTO frd_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Paulus irua Silas rahu lingaꞌan i nti kota Amfipolis ovu kota Apolonia ma rti raran kota Tesalonika. Yahudi rira rahan falurut isa naꞌa inyai. ");
INSERT INTO frd_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Paulus baꞌi nti Yahudi rira rahan falurut yai. Lokat amar i ryari ira, na ia ovu tamata Yahudi ra rfamalik Ubu Ni Surat Ralan, ti naran karedralan itelu. ");
INSERT INTO frd_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Ia nfamalik ne, “Ubu nfadoku roak ma rotu sian ma rfedan Raja i ntevut dida salasilan ra, beti nvaꞌat ewal tali matmatan. Raja i ntevut dida salasilan ra, inyai Yesus i ufamalik verin mia!” ");
INSERT INTO frd_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ba tamata Yahudi boku rorang Yesus ma rovu Paulus irua Silas. Wean inyai vali verin tamata Yunani ovi rorang Ubu, ovu vata mela ra, rivun ira rorang afa ovi Paulus nfalak ra. ");
INSERT INTO frd_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Naꞌuk dawan Yahudi ra ralar sian, ba rera tamata ktufan ifira tali lingaꞌan ra ma rasdovu ira. Tamata ktufan avyai rti ma rotu ma vangoa-vanga dawan naꞌa kota ralan. Ira rti tamata isa naran Yason ni rahan, mane rot-visal rahan yai ma rdava Paulus irua Silas, tevek inar ma rtaha ira ti verin tamata rivun. ");
INSERT INTO frd_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Naꞌuk wol rdav-nala Paulus irua Silas naꞌa inyai, ba rlia soli-sasan Yason ovu tamata ovi rorang Yesus boku vali, ma ti rdiri dawan ovi rfareta kota yai waharira ralan ra. Ira rafwak ne, “Kida averi, tamata ovi rotu sian tamata ra naꞌa wan inba watan, fiang ini rma roak dida ahu a! ");
INSERT INTO frd_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Yason nala roak ira ma rnaꞌa ni rahan. Ira munuk wol rorang inukun ovi Roma rira Kaisar nfadoku ra, tevek rfalak ne, raja isa vali naran Yesus!” ");
INSERT INTO frd_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Ba rira vaivatul avyai rfakeri tamata rivun ralarira ra naꞌa kota yai, ovu rfakeri vali rira dawan fareta ralarira ra ma rangrova urun. ");
INSERT INTO frd_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Nata tamata ovi rfareta kota yai rfalak ma Yason ovu tamata ovi rorang Yesus rfadok-teri rira kubang naꞌa inyai veki, ma wean i rtorung ne, wol rotu roak afa avyai, beti rfatalik ira. ");
INSERT INTO frd_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Lervava roak, na tamata ovi rorang Yesus naꞌa Tesalonika rsinir Paulus irua Silas ma rti kota Berea. Ti raran inyai, na rti lahir Yahudi rira rahan falurut. ");
INSERT INTO frd_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Tamata ovi rnaꞌa Berea yai rira sialang verin tamata liak ra lolin lia tamata ovi rnaꞌa Tesalonika. Ira inar urun ma rarenar Ubu Ni vaivatul ra, ovu vali lokat amar rbas ma lolin Surat Ralan ma al rsiꞌik ne, afa ovi Paulus nfalak ra kena te wahal. ");
INSERT INTO frd_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Ba tamata Yahudi rivun ovi rnaꞌa inyai rorang Yesus. Vata mela Yunani boku ovu brana Yunani rivun vali rorang Yesus. ");
INSERT INTO frd_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Ti ma Yahudi ovi rnaꞌa Tesalonika rarenar ne, Paulus nfamalik Ubu Ni vaivatul ra naꞌa Berea, na rti inyai ma rfakeri tamata ralarira ra, boma vangoa-vanga dawan. ");
INSERT INTO frd_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Ba tamata ovi rorang Yesus ti rovun lahir Paulus ma rti tahat nelan a, naꞌuk Silas irua Timotius rnaꞌa watan Berea. ");
INSERT INTO frd_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Nata rovun Paulus rti kota Atena. Paulus nsurak tamata avyai ma rfalak verin Silas irua Timotius ma yarak ti rtuan ia naꞌa Atena. Ia nfalak munuk wean inyai, beti rewal ira rti Berea. ");
INSERT INTO frd_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Paulus nanaꞌa Atena al nanaban Silas irua Timotius, na ralan lalau urun, tevek nsiꞌik kota yai nngora lahir ovu walut ovi tamata ra raraning. ");
INSERT INTO frd_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Ba nti Yahudi rira rahan falurut, ma ia ovu Yahudi ra ovu Yunani ovi rorang Ubu rfamalik afa ala rsiforat ira naꞌa inyai. Lokat amar Paulus notu wean inyai vali verin tamata ovi ntuan ira naꞌa wan i rfedi-rfaha afa. ");
INSERT INTO frd_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Guru ovi rira kakaꞌa dawan rira sidovung naran Epikuros, ovu tamata ovi rira sidovung naran Stoa rsisoal ira ovu ia. Boku tali ira rfalak ne, “Tamata ini sumarn batbitin ma nangrihi tia ma watan!” Boku vali rfalak ne, “Beta ne nfamalik tamata liak rira ubu ra.” Ira rfalak wean inyai, tevek Paulus nfamalik Ubu Ni Ivar Lolin i nfamalik Yesus, ovu nfamalik vali ne, tamata ra veka rvaꞌat ewal tali matmatan. ");
INSERT INTO frd_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Nata guru avyai rovun ia, ma ti rasdovu ira naꞌa rira sidovung dawan a naran Areopagus. Ira rfalak verin ia ne, “Baba, inamami ma amrenar afa ngorvaꞌan ovi mair yai. ");
INSERT INTO frd_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Tevek amrenar afa ovi fwalak ra, naꞌuk afa avyai rfabriang ami. Inamami ma amkaꞌa vaivatul avyai ihirira ra.” ");
INSERT INTO frd_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Tamata Atena ra ovu tamata dakan ovi rnaꞌa kota yai inar ma rdoku ma rfamalik ovu rarenar lalawatan afa ngorvaꞌan ra. ");
INSERT INTO frd_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Ba Paulus ti ma ndir-ulu naꞌa sidovung dawan Areopagus yai ma nfalak ne, “O tamata Atena averi! Usiꞌik tali afa ovi myotu ra, na myorang urun bira agama, ma mryaning bira ubu ra. ");
INSERT INTO frd_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Tevek uban-lilit bira kota ma usiꞌik wan ovi mryaning bira ubu ra. Urea vali wan i baꞌi misnuri bira korban ra naꞌa. Naꞌa wan yai rtulis vaivatul ovi ne, ‘Verin Ubu i wol amkaꞌa.’ Mia fyadawang Ubu, naꞌuk wol mkyaꞌa Ia. Ba mane ufamalik Ia verin mia. ");
INSERT INTO frd_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Ubu i notu lanit ivavan ovu afa ovi rnaꞌa munuk ralan a, Ia Duilaꞌa verin afa ovi rnaꞌa lanit ratan ovu ovi rnaꞌa lanit ivavan. Ia wol nleal rahan falurut ovi tamata ra rotu, wean rahan ovi fyadoku bira walut ra naꞌa. ");
INSERT INTO frd_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ia wol nera afa tali tamata ra, tevek Ni munuk afakataka! Ubu aꞌuk saꞌi nala dida vavaꞌat ovu nad ra, ntafal vali afakataka munuk verin tamata ra. ");
INSERT INTO frd_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Ubu not-nala tamata ra munuk naꞌa lanit ivavan a tali tamata isa i naran Adam, ma nsiduk ira lokat nuhu ovi rnaꞌa lanit ivavan. Tali lalan, nfadoku roak dida vavaꞌat ovu matmatan a, ovu vali tamata ra veka rnaꞌa inba. ");
INSERT INTO frd_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Ubu notu wean inyai, boma tamata ra rdava Ia, ma fara ne rtuan Ia naꞌa amar ovi rdava Ia. Velik aba, Ubu wol raroa tali ita. ");
INSERT INTO frd_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Tamata ra baꞌi rfalak ne, ‘Ia novun ita ma tnaꞌa lanit ivavan a, ovu tasdai ma tvaꞌat, tevek Ni ngrebat a.’ Inyai wean vali bira tamata boku ovi rasusan surat ra rfalak ne, ‘Ubu yanan verin ita munuk.’ ");
INSERT INTO frd_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Ubu yanan ita, ba deka tanovak ne, Ubu wean walut ovi rotu tali masa te perak te vatu, ma tamata ra rotu tali rira kakaꞌa. ");
INSERT INTO frd_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Lalan ana, wol tkaꞌa Ubu ralan ma totu afa boda-badi rivun. Ubu nablufang roak afa avyai, naꞌuk fiang ini Ia nfareta tamata ra munuk naꞌa wan inba watan ma rahil ma rtalik tali rira salasilan ra. ");
INSERT INTO frd_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Ubu nfadoku roak amar ma veka nfaleka inukun ovu Ni malolan a verin tamata ra munuk naꞌa lanit ivavan a. Ia nfili roak tamata isa ma veka nukun tamata ra. Ia nfavaꞌat ewal roak tamata yai tali matmatan ma nfaturu verin tamata ra munuk ne, Ubu nfili Ia!” ");
INSERT INTO frd_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Ira rarenar Paulus nfalak ne, Ubu nfavaꞌat ewal tamata isa tali matmatan, ba boku rangrihi lablabir ia. Naꞌuk boku rfalak verin ia ne, “Inamami ma fwamalik ewal afa ovi verin ami.” ");
INSERT INTO frd_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Ba Paulus nban-talik rira sidovung yai. ");
INSERT INTO frd_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Tamata boku rtorung Paulus ni vaivatul ra, ma rorang Yesus. Tamata avyai nararira Dionisius i ndoku rira sidovung Areopagus ovu vata isa naran Damaris, ovu tamata liak boku rorang vali. ");
INSERT INTO frd_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Nata Paulus nban-talik kota Atena ma nti kota Korintus. ");
INSERT INTO frd_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Naꞌa inyai, na ntuan tamata Yahudi isa naran Akwila, ntali propinsi Pontus. Ia ovu awan naran Priskila beti rtali Italia rma Korintus, tevek Kaisar Klaudius nfareta ma Yahudi ra munuk rdir-talik kota Roma. Paulus ti nalola ira. ");
INSERT INTO frd_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Nata nleal inyai ma nkarya ovu ira, tevek ira munuk rotu 