﻿USE sofia;
DROP TABLE IF EXISTS sofia.frasbl_vpl;
CREATE TABLE frasbl_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES frasbl_vpl WRITE;
INSERT INTO frasbl_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Au commencement, Dieu créa les cieux et la terre. ");
INSERT INTO frasbl_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","La terre était informe et vide. Les ténèbres étaient à la surface de l'abîme et l'Esprit de Dieu planait au-dessus de la surface des eaux. ");
INSERT INTO frasbl_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Dieu dit : « Que la lumière soit ! » et la lumière fut. ");
INSERT INTO frasbl_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Dieu vit la lumière, et il vit qu'elle était bonne. Dieu sépara la lumière d'avec les ténèbres. ");
INSERT INTO frasbl_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Dieu appela la lumière « jour », et il appela les ténèbres « nuit ». Il y eut un soir et il y eut un matin : ce fut le premier jour. ");
INSERT INTO frasbl_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Dieu dit : « Qu'il y ait une étendue au milieu des eaux, et qu'elle sépare les eaux d'avec les eaux. » ");
INSERT INTO frasbl_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Dieu fit l'étendue, et il sépara les eaux qui étaient au-dessous de l'étendue des eaux qui étaient au-dessus de l'étendue ; et il en fut ainsi. ");
INSERT INTO frasbl_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Dieu appela l'étendue « ciel ». Il y eut un soir et il y eut un matin, un second jour. ");
INSERT INTO frasbl_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Dieu dit : « Que les eaux qui sont sous le ciel se rassemblent en un seul lieu, et que la terre sèche apparaisse » ; et il en fut ainsi. ");
INSERT INTO frasbl_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Dieu appela la terre sèche « terre », et il appela le rassemblement des eaux « mer ». Dieu vit que cela était bon. ");
INSERT INTO frasbl_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Dieu dit : « Que la terre produise de l'herbe, des herbes portant des graines, et des arbres fruitiers portant des fruits selon leur espèce, avec leurs graines, sur la terre ». ");
INSERT INTO frasbl_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","La terre produisit de l'herbe, des herbes portant de la semence selon leur espèce, et des arbres fruitiers portant du fruit selon leur espèce, avec leur semence en elle ; et Dieu vit que cela était bon. ");
INSERT INTO frasbl_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Il y eut un soir, et il y eut un matin : ce fut le troisième jour. ");
INSERT INTO frasbl_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Dieu dit : « Qu'il y ait des luminaires dans l'étendue du ciel pour séparer le jour d'avec la nuit, et qu'ils servent de signes pour marquer les saisons, les jours et les années ; ");
INSERT INTO frasbl_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","et qu'ils servent de luminaires dans l'étendue du ciel pour éclairer la terre ». ");
INSERT INTO frasbl_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Dieu fit les deux grands luminaires : le grand luminaire pour régir le jour, et le petit luminaire pour régir la nuit. Il fit aussi les étoiles. ");
INSERT INTO frasbl_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Dieu les plaça dans l'étendue du ciel pour éclairer la terre, ");
INSERT INTO frasbl_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","pour dominer le jour et la nuit, et pour séparer la lumière des ténèbres. Dieu vit que cela était bon. ");
INSERT INTO frasbl_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Il y eut un soir et il y eut un matin : ce fut le quatrième jour. ");
INSERT INTO frasbl_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Dieu dit : « Que les eaux regorgent d'êtres vivants, et que les oiseaux volent au-dessus de la terre dans l'étendue du ciel. » ");
INSERT INTO frasbl_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Dieu créa les grands animaux marins et tous les êtres vivants qui se meuvent, dont les eaux fourmillent, selon leur espèce, et tout oiseau ailé selon son espèce. Dieu vit que cela était bon. ");
INSERT INTO frasbl_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Dieu les bénit, en disant : « Soyez féconds, multipliez, remplissez les eaux des mers, et que les oiseaux se multiplient sur la terre. » ");
INSERT INTO frasbl_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Il y eut un soir, et il y eut un matin : ce fut le cinquième jour. ");
INSERT INTO frasbl_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Dieu dit : « Que la terre produise des êtres vivants selon leur espèce, du bétail, des reptiles et des animaux de la terre selon leur espèce » ; et il en fut ainsi. ");
INSERT INTO frasbl_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Dieu fit les animaux de la terre selon leur espèce, le bétail selon son espèce, et tout ce qui rampe sur le sol selon son espèce. Dieu vit que cela était bon. ");
INSERT INTO frasbl_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Dieu dit : « Faisons l'homme à notre image, selon notre ressemblance. Qu'ils dominent sur les poissons de la mer, sur les oiseaux du ciel, sur le bétail, sur toute la terre et sur tous les reptiles qui rampent sur la terre. » ");
INSERT INTO frasbl_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Dieu a créé l'homme à son image. Il le créa à l'image de Dieu ; il les créa mâle et femelle. ");
INSERT INTO frasbl_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Dieu les bénit. Dieu leur dit : « Soyez féconds, multipliez, remplissez la terre et soumettez-la. Dominez les poissons de la mer, les oiseaux du ciel et tout être vivant qui se meut sur la terre. » ");
INSERT INTO frasbl_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Dieu dit : « Voici, je vous ai donné toute herbe portant de la semence, qui est à la surface de toute la terre, et tout arbre portant du fruit et portant de la semence. Ce sera votre nourriture. ");
INSERT INTO frasbl_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","A tout animal de la terre, à tout oiseau du ciel, et à tout ce qui rampe sur la terre et qui a de la vie, j'ai donné toute herbe verte pour nourriture. ");
INSERT INTO frasbl_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Dieu vit tout ce qu'il avait fait, et voici, cela était très bon. Il y eut un soir et il y eut un matin, un sixième jour. ");
INSERT INTO frasbl_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Les cieux, la terre et toute leur étendue furent achevés. ");
INSERT INTO frasbl_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Le septième jour, Dieu acheva l'œuvre qu'il avait faite, et il se reposa au septième jour de toute son œuvre. ");
INSERT INTO frasbl_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Dieu bénit le septième jour et le sanctifia, parce qu'il se reposa en ce jour de toute l'œuvre de la création qu'il avait faite. ");
INSERT INTO frasbl_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Voici l'histoire des générations des cieux et de la terre, quand ils furent créés, au jour où Yahvé Dieu fit la terre et les cieux. ");
INSERT INTO frasbl_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Aucune plante des champs n'était encore sur la terre, et aucune herbe des champs n'avait encore poussé, car Yahvé Dieu n'avait pas fait pleuvoir sur la terre. Il n'y avait pas d'homme pour cultiver la terre, ");
INSERT INTO frasbl_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","mais une brume montait de la terre et arrosait toute la surface du sol. ");
INSERT INTO frasbl_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Yahvé Dieu forma l'homme de la poussière de la terre, il souffla dans ses narines une haleine de vie, et l'homme devint un être vivant. ");
INSERT INTO frasbl_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Yahvé Dieu planta un jardin à l'orient, en Éden, et il y mit l'homme qu'il avait formé. ");
INSERT INTO frasbl_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Yahvé Dieu fit pousser du sol tous les arbres agréables à la vue et bons à manger, y compris l'arbre de vie au milieu du jardin et l'arbre de la connaissance du bien et du mal. ");
INSERT INTO frasbl_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Un fleuve sortait d'Eden pour arroser le jardin ; de là, il se divisait et devenait la source de quatre fleuves. ");
INSERT INTO frasbl_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Le nom du premier est Pishon ; il coule dans tout le pays de Havila, où il y a de l'or ; ");
INSERT INTO frasbl_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","et l'or de ce pays est bon. On y trouve aussi du bdellium et de la pierre d'onyx. ");
INSERT INTO frasbl_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Le nom du second fleuve est Gihon. C'est le même fleuve qui coule dans tout le pays de Cusch. ");
INSERT INTO frasbl_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Le nom du troisième fleuve est Hiddékel. C'est celui qui coule devant l'Assyrie. Le quatrième fleuve est l'Euphrate. ");
INSERT INTO frasbl_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Yahvé Dieu prit l'homme et le plaça dans le jardin d'Eden pour le cultiver et le garder. ");
INSERT INTO frasbl_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Yahvé Dieu donna cet ordre à l'homme : « Tu peux manger librement de tous les arbres du jardin ; ");
INSERT INTO frasbl_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","mais tu ne mangeras pas de l'arbre de la connaissance du bien et du mal, car le jour où tu en mangeras, tu mourras. » ");
INSERT INTO frasbl_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Yahvé Dieu dit : « Il n'est pas bon que l'homme soit seul. Je vais lui faire une aide qui lui soit comparable. » ");
INSERT INTO frasbl_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Yahvé Dieu forma de la terre tous les animaux des champs et tous les oiseaux du ciel, et il les amena à l'homme pour voir comment il les appellerait. Le nom que l'homme donna à chaque être vivant devint son nom. ");
INSERT INTO frasbl_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","L'homme donna des noms à tout le bétail, aux oiseaux du ciel et à tous les animaux des champs ; mais il ne fut pas trouvé pour l'homme un auxiliaire comparable à lui. ");
INSERT INTO frasbl_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Yahvé Dieu fit tomber l'homme dans un profond sommeil. Comme l'homme dormait, il prit une de ses côtes et referma la chair à sa place. ");
INSERT INTO frasbl_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Yahvé Dieu fit une femme de la côte qu'il avait prise à l'homme, et il l'amena à l'homme. ");
INSERT INTO frasbl_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","L'homme dit : « Voici l'os de mes os et la chair de ma chair. On l'appellera femme, parce qu'elle est sortie de l'homme ». ");
INSERT INTO frasbl_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","C'est pourquoi l'homme quittera son père et sa mère, et s'attachera à sa femme, et ils seront une seule chair. ");
INSERT INTO frasbl_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","L'homme et sa femme étaient tous deux nus, et ils n'ont pas eu honte. ");
INSERT INTO frasbl_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Or le serpent était plus rusé qu'aucun des animaux des champs que Yahvé Dieu avait faits. Il dit à la femme : « Dieu a-t-il vraiment dit : « Tu ne mangeras d'aucun arbre du jardin » ? » ");
INSERT INTO frasbl_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","La femme dit au serpent : « Nous pouvons manger du fruit des arbres du jardin, ");
INSERT INTO frasbl_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","mais pas du fruit de l'arbre qui est au milieu du jardin. Dieu a dit : Vous n'en mangerez pas. Vous ne le toucherez pas, de peur que vous ne mouriez. » ");
INSERT INTO frasbl_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Le serpent dit à la femme : « Tu ne mourras pas vraiment, ");
INSERT INTO frasbl_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","car Dieu sait que le jour où tu en mangeras, tes yeux s'ouvriront, et tu seras comme Dieu, connaissant le bien et le mal. » ");
INSERT INTO frasbl_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","La femme vit que l'arbre était bon pour la nourriture, qu'il était un plaisir pour les yeux et qu'il devait être désiré pour rendre sage, elle prit de ses fruits et en mangea. Elle en donna ensuite à son mari qui était avec elle, et il en mangea aussi. ");
INSERT INTO frasbl_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Leurs yeux s'ouvrirent, et ils connurent tous deux qu'ils étaient nus. Ils cousirent ensemble des feuilles de figuier, et se firent des couvertures. ");
INSERT INTO frasbl_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Ils entendirent la voix de Yahvé Dieu qui se promenait dans le jardin, à la fraîcheur du jour, et l'homme et sa femme se cachèrent de la présence de Yahvé Dieu parmi les arbres du jardin. ");
INSERT INTO frasbl_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Yahvé Dieu appela l'homme et lui dit : « Où es-tu ? » ");
INSERT INTO frasbl_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","L'homme dit : « J'ai entendu ta voix dans le jardin, et j'ai eu peur, car j'étais nu ; alors je me suis caché. » ");
INSERT INTO frasbl_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Dieu dit : « Qui t'a dit que tu étais nu ? As-tu mangé de l'arbre dont je t'ai interdit de manger ? » ");
INSERT INTO frasbl_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","L'homme dit : « La femme que tu as donnée pour être avec moi, elle m'a donné du fruit de l'arbre, et j'en ai mangé. » ");
INSERT INTO frasbl_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Yahvé Dieu dit à la femme : « Qu'as-tu fait ? » La femme a dit : « Le serpent m'a séduite, et j'ai mangé. » ");
INSERT INTO frasbl_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Yahvé Dieu dit au serpent, « Parce que tu as fait ça, vous êtes maudits par-dessus tout le bétail, et au-dessus de tous les animaux des champs. Tu iras sur ton ventre et tu mangeras de la poussière tous les jours de ta vie. ");
INSERT INTO frasbl_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Je mettrai de l'hostilité entre toi et la femme, et entre ta descendance et sa descendance. Il va vous meurtrir la tête, et tu lui meurtriras le talon. » ");
INSERT INTO frasbl_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Il dit à la femme, « Je multiplierai considérablement les douleurs de l'accouchement. Vous porterez des enfants dans la douleur. Ton désir sera pour ton mari, et il dominera sur vous. » ");
INSERT INTO frasbl_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Il dit à Adam, « Parce que vous avez écouté la voix de votre femme, et ont mangé de l'arbre, sur lequel je vous ai dit : « Vous n'en mangerez pas ». le sol est maudit à cause de vous. Tu en mangeras avec beaucoup de peine tous les jours de ta vie. ");
INSERT INTO frasbl_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Il vous donnera des épines et des chardons ; et vous mangerez l'herbe des champs. ");
INSERT INTO frasbl_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Tu mangeras du pain à la sueur de ton visage jusqu'à ce que tu retournes à la terre, car tu en es sorti. Car vous êtes poussière, et vous retournerez à la poussière. » ");
INSERT INTO frasbl_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","L'homme appela sa femme Eve, car elle serait la mère de tous les vivants. ");
INSERT INTO frasbl_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Yahvé Dieu fit des vêtements de peaux de bêtes pour Adam et sa femme, et les habilla. ");
INSERT INTO frasbl_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Yahvé Dieu dit : « Voici que l'homme est devenu comme l'un de nous, il connaît le bien et le mal. Maintenant, de peur qu'il n'étende sa main, qu'il ne prenne aussi de l'arbre de vie, qu'il ne mange et qu'il ne vive éternellement. ");
INSERT INTO frasbl_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Yahvé Dieu le chassa du jardin d'Eden, pour qu'il cultive le sol dont il avait été pris. ");
INSERT INTO frasbl_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Il chassa l'homme, et il plaça des chérubins à l'est du jardin d'Eden, et une épée flamboyante qui se tournait de tous côtés, pour garder le chemin de l'arbre de vie. ");
INSERT INTO frasbl_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","L'homme connut Eve, sa femme. Elle conçut et donna naissance à Caïn, et dit : « J'ai obtenu un homme avec l'aide de Yahvé. » ");
INSERT INTO frasbl_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Elle donna de nouveau naissance à Abel, frère de Caïn. Abel était gardien de moutons, mais Caïn était cultivateur de la terre. ");
INSERT INTO frasbl_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Au fil du temps, Caïn apporta une offrande à Yahvé avec les fruits du sol. ");
INSERT INTO frasbl_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Abel apporta aussi une partie des premiers-nés de son troupeau et de sa graisse. Yahvé respecta Abel et son offrande, ");
INSERT INTO frasbl_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","mais il ne respecta pas Caïn et son offrande. Caïn fut très irrité, et l'expression de son visage tomba. ");
INSERT INTO frasbl_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Yahvé dit à Caïn : « Pourquoi es-tu en colère ? Pourquoi l'expression de ton visage est-elle tombée ? ");
INSERT INTO frasbl_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Si tu fais bien, ne sera-t-elle pas élevée ? Si tu ne fais pas le bien, le péché est accroupi à la porte. C'est toi qu'il désire, mais c'est toi qui dois le dominer. » ");
INSERT INTO frasbl_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Caïn dit à Abel, son frère : « Allons dans le champ. » Pendant qu'ils étaient dans le champ, Caïn se souleva contre Abel, son frère, et le tua. ");
INSERT INTO frasbl_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Yahvé dit à Caïn : « Où est Abel, ton frère ? » Il a dit : « Je ne sais pas. Suis-je le gardien de mon frère ? » ");
INSERT INTO frasbl_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Yahvé dit : « Qu'as-tu fait ? La voix du sang de ton frère crie vers moi depuis la terre. ");
INSERT INTO frasbl_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Maintenant, tu es maudit à cause de la terre, qui a ouvert sa bouche pour recevoir de ta main le sang de ton frère. ");
INSERT INTO frasbl_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Désormais, quand tu laboureras la terre, elle ne te cédera plus sa force. Tu seras un fugitif et un vagabond sur la terre. » ");
INSERT INTO frasbl_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Caïn dit à Yahvé : « Mon châtiment est plus grand que ce que je peux supporter. ");
INSERT INTO frasbl_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Voici, tu m'as chassé aujourd'hui de la surface de la terre. Je serai caché de ta face, et je serai un fugitif et un vagabond sur la terre. Celui qui me trouvera me tuera. » ");
INSERT INTO frasbl_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Yahvé lui dit : « C'est pourquoi, si quelqu'un tue Caïn, il se vengera sept fois plus. » Yahvé avait prévu un signe pour Caïn, afin que celui qui le trouverait ne le frappe pas. ");
INSERT INTO frasbl_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Caïn quitta la présence de Yahvé et habita dans le pays de Nod, à l'est d'Eden. ");
INSERT INTO frasbl_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Caïn connut sa femme. Elle devint enceinte et donna naissance à Hénoc. Il bâtit une ville, et donna à la ville le nom de son fils, Hénoc. ");
INSERT INTO frasbl_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Irad naquit d'Hénoc. Irad devint le père de Mehujael. Mehujael devint le père de Methushael. Methushael engendra Lamek. ");
INSERT INTO frasbl_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamek prit deux femmes : le nom de la première était Ada, et le nom de la seconde était Zilla. ");
INSERT INTO frasbl_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada donna naissance à Jabal, qui fut le père de ceux qui habitent dans des tentes et qui ont du bétail. ");
INSERT INTO frasbl_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Le nom de son frère était Jubal, qui était le père de tous ceux qui manient la harpe et le chalumeau. ");
INSERT INTO frasbl_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Zilla donna aussi naissance à Tubal Caïn, le forgeur de tous les instruments tranchants en bronze et en fer. La sœur de Tubal Caïn était Naama. ");
INSERT INTO frasbl_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lamek dit à ses femmes, « Adah et Zillah, entendez ma voix. Femmes de Lamech, écoutez mon discours, car j'ai tué un homme pour m'avoir blessé, un jeune homme pour m'avoir meurtri. ");
INSERT INTO frasbl_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Si Caïn sera vengé sept fois, vraiment Lamech soixante-dix-sept fois. » ");
INSERT INTO frasbl_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adam connut de nouveau sa femme. Elle donna naissance à un fils, qu'elle appela Seth, en disant : « Dieu m'a donné un autre enfant à la place d'Abel, car Caïn l'a tué. » ");
INSERT INTO frasbl_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Un fils naquit aussi à Seth, et il le nomma Enosh. En ce temps-là, les hommes commencèrent à invoquer le nom de Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Voici le livre des générations d'Adam. Le jour où Dieu créa l'homme, il le fit à la ressemblance de Dieu. ");
INSERT INTO frasbl_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Il les créa homme et femme, et les bénit. Le jour où ils furent créés, il leur donna le nom d'Adam. ");
INSERT INTO frasbl_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adam vécut cent trente ans ; il engendra un fils à sa ressemblance, selon son image, et il lui donna le nom de Seth. ");
INSERT INTO frasbl_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Les jours d'Adam, après qu'il eut engendré Seth, furent de huit cents ans, et il engendra d'autres fils et d'autres filles. ");
INSERT INTO frasbl_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Tous les jours qu'Adam vécut furent de neuf cent trente ans, puis il mourut. ");
INSERT INTO frasbl_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Seth vécut cent cinq ans, puis devint le père d'Enosh. ");
INSERT INTO frasbl_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Seth vécut, après avoir engendré Enosh, huit cent sept ans, et il engendra d'autres fils et d'autres filles. ");
INSERT INTO frasbl_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Tous les jours de Seth furent de neuf cent douze ans, puis il mourut. ");
INSERT INTO frasbl_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enosh vécut quatre-vingt-dix ans, et il engendra Kenan. ");
INSERT INTO frasbl_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Enosh vécut, après avoir engendré Kénan, huit cent quinze ans, et il engendra d'autres fils et d'autres filles. ");
INSERT INTO frasbl_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Tous les jours d'Énosh furent de neuf cent cinq ans, puis il mourut. ");
INSERT INTO frasbl_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenan vécut soixante-dix ans, puis il engendra Mahalalel. ");
INSERT INTO frasbl_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Kenan vécut, après avoir engendré Mahalalel, huit cent quarante ans ; il engendra d'autres fils et d'autres filles. ");
INSERT INTO frasbl_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Tous les jours de Kenan furent de neuf cent dix ans, puis il mourut. ");
INSERT INTO frasbl_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalalel vécut soixante-cinq ans, puis devint le père de Jared. ");
INSERT INTO frasbl_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Mahalalel vécut, après avoir engendré Jared, huit cent trente ans, et il engendra d'autres fils et d'autres filles. ");
INSERT INTO frasbl_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Tous les jours de Mahalalel furent de huit cent quatre-vingt-quinze ans, puis il mourut. ");
INSERT INTO frasbl_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Jared vécut cent soixante-deux ans, puis devint le père d'Hénoc. ");
INSERT INTO frasbl_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Jared vécut, après avoir engendré Hénoc, huit cents ans, et il engendra d'autres fils et d'autres filles. ");
INSERT INTO frasbl_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Tous les jours de Jared furent de neuf cent soixante-deux ans, puis il mourut. ");
INSERT INTO frasbl_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Hénoc vécut soixante-cinq ans, puis devint le père de Mathusalem. ");
INSERT INTO frasbl_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Après la naissance de Mathusalem, Hénoc marcha avec Dieu pendant trois cents ans, et il engendra d'autres fils et d'autres filles. ");
INSERT INTO frasbl_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Tous les jours d'Hénoc furent de trois cent soixante-cinq ans. ");
INSERT INTO frasbl_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Hénoc marcha avec Dieu, et il ne fut pas trouvé, car Dieu le prit. ");
INSERT INTO frasbl_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Mathusalem vécut cent quatre-vingt-sept ans, puis devint le père de Lamek. ");
INSERT INTO frasbl_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Mathusalem vécut, après avoir engendré Lémec, sept cent quatre-vingt-deux ans, et il engendra d'autres fils et d'autres filles. ");
INSERT INTO frasbl_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Tous les jours de Mathusalem furent de neuf cent soixante-neuf ans, puis il mourut. ");
INSERT INTO frasbl_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lémec vécut cent quatre-vingt-deux ans, puis il engendra un fils. ");
INSERT INTO frasbl_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Il lui donna le nom de Noé, en disant : « Celui-ci nous consolera dans notre travail et dans le labeur de nos mains, causé par le sol que Yahvé a maudit. » ");
INSERT INTO frasbl_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Lamek vécut, après avoir engendré Noé, cinq cent quatre-vingt-quinze ans, et il engendra d'autres fils et filles. ");
INSERT INTO frasbl_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Tous les jours de Lémec furent de sept cent soixante-dix-sept ans, puis il mourut. ");
INSERT INTO frasbl_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Noé avait cinq cents ans, puis Noé est devenu le père de Sem, de Cham et de Japhet. ");
INSERT INTO frasbl_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Lorsque les hommes commencèrent à se multiplier sur la surface de la terre et que des filles leur naquirent, ");
INSERT INTO frasbl_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","les fils de Dieu virent que les filles des hommes étaient belles, et ils prirent pour femmes toutes celles qu'ils voulurent. ");
INSERT INTO frasbl_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Yahvé dit : « Mon Esprit ne luttera pas toujours avec l'homme, car lui aussi est chair ; aussi ses jours seront-ils de cent vingt ans. » ");
INSERT INTO frasbl_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Les Nephilim étaient sur la terre en ces jours-là, et aussi après, lorsque les fils de Dieu s'approchèrent des filles des hommes et eurent des enfants avec elles. Ce sont les hommes puissants d'autrefois, les hommes de renom. ");
INSERT INTO frasbl_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","L'Éternel vit que la méchanceté de l'homme était grande sur la terre, et que toutes les imaginations des pensées du cœur de l'homme étaient continuellement mauvaises. ");
INSERT INTO frasbl_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","L'Éternel se désolait d'avoir créé l'homme sur la terre, et cela lui faisait de la peine dans son cœur. ");
INSERT INTO frasbl_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Yahvé dit : « Je vais détruire l'homme que j'ai créé sur la surface de la terre, l'homme, les animaux, les reptiles et les oiseaux du ciel, car je suis désolé de les avoir créés. » ");
INSERT INTO frasbl_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Mais Noé trouva grâce aux yeux de Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Voici l'histoire des générations de Noé : Noé était un homme juste, irréprochable parmi les gens de son temps. Noé marchait avec Dieu. ");
INSERT INTO frasbl_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Noé est devenu le père de trois fils : Sem, Cham et Japhet. ");
INSERT INTO frasbl_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","La terre était corrompue devant Dieu, et la terre était remplie de violence. ");
INSERT INTO frasbl_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Dieu regarda la terre et vit qu'elle était corrompue, car toute chair avait corrompu sa voie sur la terre. ");
INSERT INTO frasbl_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Dieu dit à Noé : « Je vais faire disparaître toute chair, car la terre est remplie de violence par elle. Voici que je vais les détruire, eux et la terre. ");
INSERT INTO frasbl_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Fais un navire en bois de gopher. Tu feras des chambres dans le navire, et tu le scelleras de poix à l'intérieur et à l'extérieur. ");
INSERT INTO frasbl_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Voici comment tu le feras. La longueur du navire sera de trois cents coudées, sa largeur de cinquante coudées et sa hauteur de trente coudées. ");
INSERT INTO frasbl_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Tu feras un toit dans le navire, et tu l'achèveras jusqu'à une coudée en haut. Tu placeras la porte du navire sur son côté. Tu le feras avec un premier, un deuxième et un troisième étage. ");
INSERT INTO frasbl_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Moi, je ferai venir le déluge d'eau sur cette terre, pour détruire toute chair ayant souffle de vie sous le ciel. Tout ce qui est sur la terre mourra. ");
INSERT INTO frasbl_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Mais j'établirai mon alliance avec vous. Vous monterez dans le navire, toi, tes fils, ta femme et les femmes de tes fils avec toi. ");
INSERT INTO frasbl_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","De tous les êtres vivants de toute chair, tu en feras entrer deux dans le navire, pour les garder en vie avec toi. Ils seront mâle et femelle. ");
INSERT INTO frasbl_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Des oiseaux selon leur espèce, du bétail selon son espèce, de tout reptile du sol selon son espèce, deux de chaque espèce viendront à toi, pour les garder en vie. ");
INSERT INTO frasbl_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Prends avec toi une partie de tout ce qui se mange, et ramasse-le pour toi ; cela te servira de nourriture, à toi et à eux. » ");
INSERT INTO frasbl_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Noé fit ainsi. Il fit tout ce que Dieu lui avait ordonné. ");
INSERT INTO frasbl_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Yahvé dit à Noé : « Entre dans le navire avec toute ta famille, car j'ai vu ta justice devant moi, dans cette génération. ");
INSERT INTO frasbl_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Tu prendras avec toi sept couples de chaque animal pur, le mâle et sa femelle. Des animaux qui ne sont pas purs, tu en prendras deux, le mâle et sa femelle. ");
INSERT INTO frasbl_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Et aussi des oiseaux du ciel, sept et sept, mâle et femelle, pour faire vivre la semence sur la surface de toute la terre. ");
INSERT INTO frasbl_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","En sept jours, je ferai pleuvoir sur la terre pendant quarante jours et quarante nuits. Je détruirai tout être vivant que j'ai créé à la surface de la terre. » ");
INSERT INTO frasbl_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Noé fit tout ce que Yahvé lui avait ordonné. ");
INSERT INTO frasbl_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Noé avait six cents ans lorsque le déluge d'eaux vint sur la terre. ");
INSERT INTO frasbl_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Noé monta dans le bateau avec ses fils, sa femme et les femmes de ses fils, à cause du déluge. ");
INSERT INTO frasbl_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Les animaux purs, les animaux impurs, les oiseaux et tout ce qui rampe sur le sol ");
INSERT INTO frasbl_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","allèrent par paires vers Noé dans le bateau, mâle et femelle, comme Dieu l'avait ordonné à Noé. ");
INSERT INTO frasbl_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Après les sept jours, les eaux du déluge arrivèrent sur la terre. ");
INSERT INTO frasbl_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","La six centième année de la vie de Noé, au deuxième mois, le dix-septième jour du mois, en ce jour, toutes les sources du grand abîme éclatèrent, et les fenêtres du ciel s'ouvrirent. ");
INSERT INTO frasbl_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Il pleuvait sur la terre quarante jours et quarante nuits. ");
INSERT INTO frasbl_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Ce même jour, Noé, Sem, Cham et Japhet, les fils de Noé, ainsi que la femme de Noé et les trois femmes de ses fils avec eux, montèrent dans le navire, ");
INSERT INTO frasbl_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","eux et tous les animaux selon leur espèce, tout le bétail selon son espèce, tous les reptiles qui rampent sur la terre selon leur espèce, et tous les oiseaux selon leur espèce, tous les oiseaux de toute espèce. ");
INSERT INTO frasbl_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Des couples de toute chair ayant en eux une haleine de vie montèrent dans le bateau vers Noé. ");
INSERT INTO frasbl_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Ceux qui entrèrent, entrèrent mâle et femelle de toute chair, comme Dieu l'avait ordonné ; puis Yahvé l'enferma. ");
INSERT INTO frasbl_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Le déluge fut quarante jours sur la terre. Les eaux grossirent et soulevèrent le navire, qui s'éleva au-dessus de la terre. ");
INSERT INTO frasbl_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Les eaux montèrent et s'élevèrent très haut sur la terre, et le navire flotta à la surface des eaux. ");
INSERT INTO frasbl_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Les eaux s'élevèrent très haut sur la terre. Toutes les hautes montagnes qui étaient sous tout le ciel furent couvertes. ");
INSERT INTO frasbl_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Les eaux s'élevèrent de quinze coudées, et les montagnes furent couvertes. ");
INSERT INTO frasbl_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Toute chair qui se mouvait sur la terre mourut, les oiseaux, le bétail, les animaux, tous les reptiles qui rampent sur la terre, et tous les hommes. ");
INSERT INTO frasbl_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Tout ce qui était sur la terre ferme, dans les narines duquel se trouvait le souffle de l'esprit de vie, mourut. ");
INSERT INTO frasbl_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Tout être vivant qui était à la surface de la terre fut détruit, y compris l'homme, le bétail, les reptiles et les oiseaux du ciel. Ils furent détruits de la terre. Il ne resta que Noé et ceux qui étaient avec lui dans le bateau. ");
INSERT INTO frasbl_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Les eaux inondèrent la terre pendant cent cinquante jours. ");
INSERT INTO frasbl_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Dieu se souvint de Noé, de tous les animaux et de tout le bétail qui étaient avec lui dans le navire ; et Dieu fit passer un vent sur la terre. Les eaux s'apaisèrent. ");
INSERT INTO frasbl_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Les sources de l'abîme et les fenêtres du ciel s'arrêtèrent aussi, et la pluie du ciel fut retenue. ");
INSERT INTO frasbl_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Les eaux se retirèrent continuellement de la terre. Au bout de cent cinquante jours, les eaux se retirèrent. ");
INSERT INTO frasbl_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Le navire se reposa au septième mois, le dix-septième jour du mois, sur les montagnes d'Ararat. ");
INSERT INTO frasbl_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Les eaux se retirèrent continuellement jusqu'au dixième mois. Au dixième mois, le premier jour du mois, les sommets des montagnes furent visibles. ");
INSERT INTO frasbl_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Au bout de quarante jours, Noé ouvrit la fenêtre du navire qu'il avait construit, ");
INSERT INTO frasbl_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","et il envoya un corbeau. Il allait et venait, jusqu'à ce que les eaux aient séché de la surface de la terre. ");
INSERT INTO frasbl_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Il envoya lui-même une colombe pour voir si les eaux avaient diminué à la surface du sol, ");
INSERT INTO frasbl_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","mais la colombe ne trouva aucun endroit où poser sa patte, et elle revint vers lui dans le navire, car les eaux étaient à la surface de toute la terre. Il étendit la main, la prit, et la fit venir à lui dans la barque. ");
INSERT INTO frasbl_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Il attendit encore sept jours, et il envoya de nouveau la colombe hors du navire. ");
INSERT INTO frasbl_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","La colombe revint vers lui le soir, et voici qu'elle avait dans sa bouche une feuille d'olivier fraîchement cueillie. Noé sut donc que les eaux s'étaient retirées de la terre. ");
INSERT INTO frasbl_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Il attendit encore sept jours et envoya la colombe ; elle ne revint plus vers lui. ");
INSERT INTO frasbl_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","La six cent unième année, le premier mois, le premier jour du mois, les eaux se tarirent de la terre. Noé enleva l'enveloppe du navire et regarda. Il vit que la surface de la terre était sèche. ");
INSERT INTO frasbl_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Le deuxième mois, le vingt-septième jour du mois, la terre était sèche. ");
INSERT INTO frasbl_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Dieu parla à Noé, et dit : ");
INSERT INTO frasbl_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","« Sors du navire, toi, ta femme, tes fils, et les femmes de tes fils avec toi. ");
INSERT INTO frasbl_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Fais sortir avec toi tous les êtres vivants qui sont avec toi, de toute chair, y compris les oiseaux, le bétail, et tous les reptiles qui rampent sur la terre, afin qu'ils se reproduisent en abondance sur la terre, qu'ils soient féconds et qu'ils se multiplient sur la terre. » ");
INSERT INTO frasbl_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Noé sortit, avec ses fils, sa femme, et les femmes de ses fils avec lui. ");
INSERT INTO frasbl_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Tous les animaux, tous les reptiles et tous les oiseaux, tout ce qui se meut sur la terre, selon leurs familles, sortirent du navire. ");
INSERT INTO frasbl_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Noé bâtit un autel à l'Éternel ; il prit de tous les animaux purs et de tous les oiseaux purs, et il offrit des holocaustes sur l'autel. ");
INSERT INTO frasbl_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Yahvé sentit l'arôme agréable. Yahvé dit en son cœur : « Je ne maudirai plus le sol à cause de l'homme, car l'imagination du cœur de l'homme est mauvaise dès sa jeunesse. Je ne frapperai plus jamais tout être vivant, comme je l'ai fait. ");
INSERT INTO frasbl_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Tant que la terre subsistera, le temps des semences et des récoltes, le froid et la chaleur, l'été et l'hiver, le jour et la nuit ne cesseront pas. » ");
INSERT INTO frasbl_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Dieu bénit Noé et ses fils, et leur dit : Soyez féconds, multipliez, et remplissez la terre. ");
INSERT INTO frasbl_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","La crainte de vous et la peur de vous seront sur tous les animaux de la terre et sur tous les oiseaux du ciel. Tout ce qui se meut sur la terre, et tous les poissons de la mer, sont livrés entre tes mains. ");
INSERT INTO frasbl_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Tout ce qui se déplace et qui vit te servira de nourriture. Comme je t'ai donné l'herbe verte, je t'ai tout donné. ");
INSERT INTO frasbl_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Mais la chair avec sa vie, c'est-à-dire son sang, vous n'en mangerez pas. ");
INSERT INTO frasbl_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Je demanderai compte du sang de votre vie. Je l'exigerai de la part de tout animal. De la main de l'homme, même de la main du frère de l'homme, je demanderai la vie de l'homme. ");
INSERT INTO frasbl_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Si quelqu'un verse le sang de l'homme, son sang sera versé par l'homme, car Dieu a créé l'homme à son image. ");
INSERT INTO frasbl_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Soyez féconds et multipliez. Augmentez en abondance sur la terre, et multipliez en elle. » ");
INSERT INTO frasbl_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Dieu parla à Noé et à ses fils avec lui, et dit : ");
INSERT INTO frasbl_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","« Quant à moi, voici que j'établis mon alliance avec toi, et avec ta descendance après toi, ");
INSERT INTO frasbl_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","et avec tous les êtres vivants qui sont avec toi : les oiseaux, le bétail, et tous les animaux de la terre avec toi, de tous ceux qui sortent du navire, tous les animaux de la terre. ");
INSERT INTO frasbl_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","J'établirai mon alliance avec vous : Toute chair ne sera plus exterminée par les eaux du déluge. Il n'y aura plus jamais de déluge pour détruire la terre. » ");
INSERT INTO frasbl_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Dieu dit : « Voici le signe de l'alliance que j'établis entre moi et vous, et tous les êtres vivants qui sont avec vous, pour des générations perpétuelles : ");
INSERT INTO frasbl_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Je place mon arc-en-ciel dans la nuée, et il sera le signe d'une alliance entre moi et la terre. ");
INSERT INTO frasbl_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Quand je ferai venir une nuée sur la terre, pour qu'on voie l'arc-en-ciel dans la nuée, ");
INSERT INTO frasbl_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","je me souviendrai de mon alliance, qui est entre moi et vous, et tout être vivant de toute chair, et les eaux ne deviendront plus un déluge pour détruire toute chair. ");
INSERT INTO frasbl_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","L'arc-en-ciel sera dans la nuée. Je le regarderai, afin de me souvenir de l'alliance éternelle entre Dieu et tous les êtres vivants de toute chair qui sont sur la terre. » ");
INSERT INTO frasbl_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Dieu dit à Noé : « Voici le gage de l'alliance que j'ai établie entre moi et toute chair qui est sur la terre. » ");
INSERT INTO frasbl_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Les fils de Noé qui sortirent du navire furent Sem, Cham et Japhet. Cham est le père de Canaan. ");
INSERT INTO frasbl_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Ces trois-là étaient les fils de Noé, et c'est à partir d'eux que toute la terre a été peuplée. ");
INSERT INTO frasbl_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noé se mit à cultiver la terre et planta une vigne. ");
INSERT INTO frasbl_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Il but du vin et s'enivra. Il se découvrit dans sa tente. ");
INSERT INTO frasbl_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Cham, le père de Canaan, vit la nudité de son père, et le dit à ses deux frères au dehors. ");
INSERT INTO frasbl_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Sem et Japhet prirent un vêtement, le posèrent sur leurs deux épaules, entrèrent à reculons et couvrirent la nudité de leur père. Ils entrèrent à reculons et couvrirent la nudité de leur père. Ils avaient le visage tourné vers l'arrière, et ils ne virent pas la nudité de leur père. ");
INSERT INTO frasbl_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Noé se réveilla de son vin, et il sut ce que son plus jeune fils lui avait fait. ");
INSERT INTO frasbl_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Il dit, « Canaan est maudite. Il sera le serviteur des serviteurs de ses frères. » ");
INSERT INTO frasbl_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Il a dit, « Béni soit Yahvé, le Dieu de Sem. Que Canaan soit son serviteur. ");
INSERT INTO frasbl_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Que Dieu agrandisse Japhet. Qu'il habite dans les tentes de Sem. Que Canaan soit son serviteur. » ");
INSERT INTO frasbl_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Noé vécut trois cent cinquante ans après le déluge. ");
INSERT INTO frasbl_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Tous les jours de Noé furent de neuf cent cinquante ans, puis il mourut. ");
INSERT INTO frasbl_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Voici l'histoire des générations des fils de Noé, de Sem, de Cham et de Japhet. Des fils leur sont nés après le déluge. ");
INSERT INTO frasbl_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Les fils de Japhet étaient : Gomer, Magog, Madai, Javan, Tubal, Meshech et Tiras. ");
INSERT INTO frasbl_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Les fils de Gomer étaient : Ashkenaz, Riphath et Togarmah. ");
INSERT INTO frasbl_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Les fils de Javan étaient : Élischa, Tarsis, Kittim et Dodanim. ");
INSERT INTO frasbl_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","C'est de là que datent les îles des nations, réparties selon leurs terres, chacun selon sa langue, selon ses familles, selon ses nations. ");
INSERT INTO frasbl_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Les fils de Cham étaient : Cush, Mizraïm, Put et Canaan. ");
INSERT INTO frasbl_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Les fils de Cush étaient : Seba, Havilah, Sabtah, Raamah et Sabteca. Les fils de Raama étaient : Saba et Dedan. ");
INSERT INTO frasbl_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Cush fut le père de Nimrod. Celui-ci commença à être puissant sur la terre. ");
INSERT INTO frasbl_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Il fut un puissant chasseur devant Yahvé. C'est pourquoi on dit : « comme Nimrod, un puissant chasseur devant Yahvé ». ");
INSERT INTO frasbl_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Le commencement de son royaume était Babel, Erech, Accad et Calneh, dans le pays de Shinar. ");
INSERT INTO frasbl_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","De ce pays, il alla en Assyrie, et bâtit Ninive, Rehoboth Ir, Calah, ");
INSERT INTO frasbl_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","et Resen entre Ninive et la grande ville de Calah. ");
INSERT INTO frasbl_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Mizraïm engendra Ludim, Anamim, Lehabim, Naphtuhim, ");
INSERT INTO frasbl_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Pathrusim, Casluhim (dont descendent les Philistins) et Caphtorim. ");
INSERT INTO frasbl_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Canaan engendra Sidon, son premier-né, Heth, ");
INSERT INTO frasbl_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","les Jébusiens, les Amorites, les Girgashites, ");
INSERT INTO frasbl_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","les Hivites, les Arkites, les Sinites, ");
INSERT INTO frasbl_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","les Arvadites, les Zemarites et les Hamathites. Par la suite, les familles des Cananéens se sont dispersées. ");
INSERT INTO frasbl_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","La frontière des Cananéens s'étendait de Sidon, en allant vers Gerar, à Gaza, en allant vers Sodome, Gomorrhe, Adma et Zéboïm, à Lasha. ");
INSERT INTO frasbl_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Voici les fils de Cham, selon leurs familles, selon leurs langues, dans leurs pays et leurs nations. ");
INSERT INTO frasbl_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Des enfants naquirent aussi à Sem (frère aîné de Japhet), père de tous les enfants d'Eber. ");
INSERT INTO frasbl_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Les fils de Sem furent : Élam, Asshur, Arpachshad, Lud et Aram. ");
INSERT INTO frasbl_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Les fils d'Aram étaient : Uz, Hul, Gether et Mash. ");
INSERT INTO frasbl_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arpacshad engendra Shéla. Schéla engendra Eber. ");
INSERT INTO frasbl_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","A Eber naquirent deux fils. Le nom de l'un était Peleg, car en son temps la terre fut divisée. Le nom de son frère était Joktan. ");
INSERT INTO frasbl_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Joktan engendra Almodad, Sheleph, Hazarmaveth, Jerah, ");
INSERT INTO frasbl_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Uzal, Diklah, ");
INSERT INTO frasbl_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Sheba, ");
INSERT INTO frasbl_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ophir, Havilah et Jobab. Tous ceux-là étaient fils de Joktan. ");
INSERT INTO frasbl_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Leur demeure s'étendait depuis Mesha, en allant vers Séphar, la montagne de l'orient. ");
INSERT INTO frasbl_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Ce sont là les fils de Sem, selon leurs familles, selon leurs langues, leurs terres et leurs nations. ");
INSERT INTO frasbl_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Ce sont là les familles des fils de Noé, selon leurs générations, en fonction de leurs nations. Les nations se sont divisées à partir de celles-ci sur la terre après le déluge. ");
INSERT INTO frasbl_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Toute la terre avait une seule langue et un seul langage. ");
INSERT INTO frasbl_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Comme ils voyageaient vers l'est, ils trouvèrent une plaine dans le pays de Shinar, et ils y habitèrent. ");
INSERT INTO frasbl_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Ils se dirent les uns aux autres : « Venez, faisons des briques, et brûlons-les bien. » Ils avaient la brique pour pierre, et le goudron pour mortier. ");
INSERT INTO frasbl_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Ils dirent : « Venez, bâtissons-nous une ville et une tour dont le sommet atteint le ciel, et faisons-nous un nom, de peur que nous ne soyons dispersés sur la surface de toute la terre. » ");
INSERT INTO frasbl_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Yahvé descendit pour voir la ville et la tour que les enfants des hommes avaient bâties. ");
INSERT INTO frasbl_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","L'Éternel dit : « Voici, ils forment un seul peuple, et ils ont tous une seule langue, et voici ce qu'ils commencent à faire. Maintenant, rien ne leur sera refusé de ce qu'ils ont l'intention de faire. ");
INSERT INTO frasbl_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Venez, descendons, et là nous confondrons leur langue, afin qu'ils ne comprennent pas le langage les uns des autres. » ");
INSERT INTO frasbl_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Yahvé les dispersa donc à partir de là sur la surface de toute la terre. Ils cessèrent de construire la ville. ");
INSERT INTO frasbl_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","C'est pourquoi on l'appela Babel, parce que Yahvé y confondit le langage de toute la terre. De là, Yahvé les dispersa sur la surface de toute la terre. ");
INSERT INTO frasbl_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Voici l'histoire des générations de Sem : Sem était âgé de cent ans lorsqu'il engendra Arpachshad, deux ans après le déluge. ");
INSERT INTO frasbl_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Sem vécut cinq cents ans après avoir engendré Arpacshad, et il engendra d'autres fils et d'autres filles. ");
INSERT INTO frasbl_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arpacshad vécut trente-cinq ans, et il engendra Shéla. ");
INSERT INTO frasbl_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Arpacshad vécut quatre cent trois ans après avoir engendré Shéla, et il engendra d'autres fils et d'autres filles. ");
INSERT INTO frasbl_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Shéla vécut trente ans, et il engendra Eber. ");
INSERT INTO frasbl_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Shéla vécut quatre cent trois ans après avoir engendré Eber, et il engendra d'autres fils et d'autres filles. ");
INSERT INTO frasbl_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eber vécut trente-quatre ans, et devint le père de Péleg. ");
INSERT INTO frasbl_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Eber vécut quatre cent trente ans après avoir engendré Peleg, et il engendra d'autres fils et d'autres filles. ");
INSERT INTO frasbl_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Péleg vécut trente ans et devint le père de Reu. ");
INSERT INTO frasbl_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Péleg vécut deux cent neuf ans après avoir engendré Reu, et il engendra d'autres fils et d'autres filles. ");
INSERT INTO frasbl_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reu vécut trente-deux ans, et devint le père de Serug. ");
INSERT INTO frasbl_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Reu vécut deux cent sept ans après avoir engendré Serug, et il engendra d'autres fils et d'autres filles. ");
INSERT INTO frasbl_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Serug vécut trente ans, et devint le père de Nachor. ");
INSERT INTO frasbl_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Serug vécut deux cents ans après avoir engendré Nachor, et il engendra d'autres fils et d'autres filles. ");
INSERT INTO frasbl_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nachor vécut vingt-neuf ans, et devint le père de Térah. ");
INSERT INTO frasbl_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Nachor vécut cent dix-neuf ans après avoir engendré Térah, et il engendra d'autres fils et d'autres filles. ");
INSERT INTO frasbl_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Térah vécut soixante-dix ans et devint le père d'Abram, de Nahor et de Haran. ");
INSERT INTO frasbl_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Voici l'histoire des générations de Térah. Térah est le père d'Abram, de Nahor et de Haran. Haran est le père de Lot. ");
INSERT INTO frasbl_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Haran mourut dans le pays où il était né, à Ur des Chaldéens, alors que son père Térah vivait encore. ");
INSERT INTO frasbl_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abram et Nachor épousèrent des femmes. Le nom de la femme d'Abram était Saraï, et le nom de la femme de Nachor était Milca, fille de Haran, qui était aussi le père d'Isca. ");
INSERT INTO frasbl_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Saraï était stérile. Elle n'avait pas d'enfant. ");
INSERT INTO frasbl_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Térah prit Abram, son fils, Lot, fils de Haran, fils de son fils, et Saraï, sa belle-fille, femme de son fils Abram. Ils partirent d'Ur des Chaldéens, pour aller au pays de Canaan. Ils arrivèrent à Haran et y habitèrent. ");
INSERT INTO frasbl_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Les jours de Térah furent de deux cent cinq ans. Térah mourut à Haran. ");
INSERT INTO frasbl_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Yahvé dit à Abram : « Quitte ton pays, ta famille et la maison de ton père, et va dans le pays que je te montrerai. ");
INSERT INTO frasbl_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Je ferai de toi une grande nation. Je te bénirai et je rendrai ton nom grand. Tu seras une bénédiction. ");
INSERT INTO frasbl_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Je bénirai ceux qui te béniront, et je maudirai celui qui te traitera avec mépris. Toutes les familles de la terre seront bénies par toi. » ");
INSERT INTO frasbl_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Et Abram partit, comme Yahvé le lui avait dit. Lot partit avec lui. Abram était âgé de soixante-quinze ans lorsqu'il partit de Haran. ");
INSERT INTO frasbl_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abram prit Saraï, sa femme, Lot, le fils de son frère, tous les biens qu'ils avaient rassemblés, et le peuple qu'ils avaient acquis à Haran, et ils partirent pour aller au pays de Canaan. Ils entrèrent dans le pays de Canaan. ");
INSERT INTO frasbl_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abram traversa le pays jusqu'au lieu-dit Sichem, au chêne de Moreh. En ce temps-là, les Cananéens étaient dans le pays. ");
INSERT INTO frasbl_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Yahvé apparut à Abram et dit : « Je donnerai ce pays à ta descendance. » Il y bâtit un autel à Yahvé, qui lui était apparu. ");
INSERT INTO frasbl_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Il partit de là pour aller sur la montagne à l'est de Béthel et planta sa tente, ayant Béthel à l'ouest et Aï à l'est. Là, il bâtit un autel à Yahvé et invoqua le nom de Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Abram voyagea, toujours en direction du sud. ");
INSERT INTO frasbl_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Il y eut une famine dans le pays. Abram descendit en Égypte pour y vivre comme un étranger, car la famine sévissait dans le pays. ");
INSERT INTO frasbl_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Lorsqu'il fut sur le point d'entrer en Égypte, il dit à Saraï, sa femme : « Voici, je sais que tu es une femme belle à regarder. ");
INSERT INTO frasbl_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Quand les Égyptiens te verront, ils diront : « C'est sa femme ». Ils me tueront, mais ils te laisseront la vie sauve. ");
INSERT INTO frasbl_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Dis, je t'en prie, que tu es ma sœur, afin que je sois heureux à cause de toi et que mon âme vive grâce à toi. » ");
INSERT INTO frasbl_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Quand Abram fut arrivé en Égypte, les Égyptiens virent que la femme était très belle. ");
INSERT INTO frasbl_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Les princes de Pharaon la virent et la louèrent à Pharaon ; et la femme fut emmenée dans la maison de Pharaon. ");
INSERT INTO frasbl_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Il traita bien Abram à cause d'elle. Il eut des moutons, du bétail, des ânes mâles, des serviteurs mâles, des servantes, des ânesses et des chameaux. ");
INSERT INTO frasbl_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Yahvé affligea Pharaon et sa maison de grandes plaies à cause de Saraï, la femme d'Abram. ");
INSERT INTO frasbl_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Pharaon appela Abram et dit : « Qu'est-ce que tu m'as fait ? Pourquoi ne m'as-tu pas dit qu'elle était ta femme ? ");
INSERT INTO frasbl_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Pourquoi as-tu dit : « C'est ma sœur », pour que je la prenne pour femme ? Maintenant donc, va voir ta femme, prends-la, et va-t'en. » ");
INSERT INTO frasbl_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Pharaon donna des ordres aux hommes à son sujet, et ils l'emmenèrent avec sa femme et tout ce qui lui appartenait. ");
INSERT INTO frasbl_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Abram monta hors d'Égypte - lui, sa femme, tout ce qu'il possédait, et Lot avec lui - dans le Sud. ");
INSERT INTO frasbl_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram était très riche en bétail, en argent et en or. ");
INSERT INTO frasbl_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Il partit du Sud jusqu'à Béthel, à l'endroit où se trouvait sa tente au début, entre Béthel et Aï, ");
INSERT INTO frasbl_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","à l'endroit de l'autel qu'il avait fait là au début. Là, Abram invoqua le nom de Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lot, qui était allé avec Abram, avait aussi des troupeaux et des tentes. ");
INSERT INTO frasbl_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Le pays ne pouvait pas les porter, pour qu'ils vivent ensemble ; car leurs biens étaient si grands qu'ils ne pouvaient pas vivre ensemble. ");
INSERT INTO frasbl_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Il y eut des querelles entre les bergers du bétail d'Abram et les bergers du bétail de Lot. Les Cananéens et les Phéréziens vivaient dans le pays en ce temps-là. ");
INSERT INTO frasbl_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Abram dit à Lot : « Je t'en prie, qu'il n'y ait pas de dispute entre toi et moi, entre tes bergers et mes bergers, car nous sommes parents. ");
INSERT INTO frasbl_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Le pays tout entier n'est-il pas devant toi ? Je te prie de te séparer de moi. Si tu vas à gauche, je vais à droite. Ou si tu vas à droite, j'irai à gauche. » ");
INSERT INTO frasbl_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lot leva les yeux et vit toute la plaine du Jourdain, qui était partout bien arrosée, avant que Yahvé ne détruise Sodome et Gomorrhe, comme le jardin de Yahvé, comme le pays d'Égypte, en allant vers Zoar. ");
INSERT INTO frasbl_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Lot choisit donc pour lui la plaine du Jourdain. Lot voyagea vers l'est, et ils se séparèrent les uns des autres. ");
INSERT INTO frasbl_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram habita le pays de Canaan, et Lot habita les villes de la plaine, et il déplaça sa tente jusqu'à Sodome. ");
INSERT INTO frasbl_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Or, les hommes de Sodome étaient extrêmement méchants et pécheurs contre Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Yahvé dit à Abram, après que Lot se fut séparé de lui : « Maintenant, lève les yeux et regarde du lieu où tu es, vers le nord et vers le sud, vers l'est et vers l'ouest, ");
INSERT INTO frasbl_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","car je donnerai tout le pays que tu vois, à toi et à ta postérité, pour toujours. ");
INSERT INTO frasbl_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Je rendrai ta descendance comme la poussière de la terre, de sorte que si un homme peut compter la poussière de la terre, alors ta descendance pourra aussi être comptée. ");
INSERT INTO frasbl_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Lève-toi, parcours le pays dans sa longueur et dans sa largeur, car je te le donnerai. » ");
INSERT INTO frasbl_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Abram déplaça sa tente et vint s'établir près des chênes de Mamré, qui sont à Hébron, et il y bâtit un autel à Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Du temps d'Amraphel, roi de Schinear, d'Arioch, roi d'Ellasar, de Chedorlaomer, roi d'Élam, et de Tidal, roi de Gojim, ");
INSERT INTO frasbl_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","ils firent la guerre à Béra, roi de Sodome, à Birsha, roi de Gomorrhe, à Shinab, roi d'Adma, à Shemeber, roi de Zéboïm, et au roi de Béla (appelé aussi Zoar). ");
INSERT INTO frasbl_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Tous se rejoignaient dans la vallée de Siddim (appelée aussi la mer Salée). ");
INSERT INTO frasbl_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Ils servirent Chedorlaomer pendant douze ans, et la treizième année, ils se révoltèrent. ");
INSERT INTO frasbl_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","La quatorzième année, Kedorlaomer et les rois qui étaient avec lui vinrent frapper les Rephaïm à Ashteroth Karnaïm, les Zuzim à Ham, les Emim à Shaveh Kiriathaïm, ");
INSERT INTO frasbl_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","et les Horites dans leur montagne de Séir, jusqu'à El Paran, qui est au bord du désert. ");
INSERT INTO frasbl_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Ils revinrent et arrivèrent à En Mischpat (appelée aussi Kadès), et ils battirent tout le pays des Amalécites et des Amorites, qui habitaient à Hatsatson-Tamar. ");
INSERT INTO frasbl_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Le roi de Sodome et le roi de Gomorrhe, le roi d'Adma, le roi de Zéboïm et le roi de Béla (appelé aussi Zoar) sortirent, et ils se rangèrent en bataille contre eux dans la vallée de Siddim ");
INSERT INTO frasbl_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","contre Kedorlaomer, roi d'Élam, Tidal, roi de Goïim, Amraphel, roi de Shinar, et Arioch, roi d'Ellasar ; quatre rois contre les cinq. ");
INSERT INTO frasbl_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Or, la vallée de Siddim était pleine de puits de goudron ; les rois de Sodome et de Gomorrhe s'enfuirent, et quelques-uns y tombèrent. Ceux qui restèrent s'enfuirent sur les collines. ");
INSERT INTO frasbl_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Ils prirent tous les biens de Sodome et de Gomorrhe, ainsi que toute leur nourriture, et s'en allèrent. ");
INSERT INTO frasbl_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Ils prirent Lot, fils du frère d'Abram, qui habitait à Sodome, et ses biens, et s'en allèrent. ");
INSERT INTO frasbl_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Un rescapé vint le dire à Abram, l'Hébreu. En ce temps-là, il habitait près des chênes de Mamré, l'Amoréen, frère d'Eshcol et frère d'Aner. Ils étaient les alliés d'Abram. ");
INSERT INTO frasbl_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Lorsqu'Abram apprit que son parent avait été emmené en captivité, il fit sortir ses trois cent dix-huit hommes entraînés, nés dans sa maison, et les poursuivit jusqu'à Dan. ");
INSERT INTO frasbl_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Il se divisa contre eux pendant la nuit, lui et ses serviteurs, les battit, et les poursuivit jusqu'à Hoba, qui est à gauche de Damas. ");
INSERT INTO frasbl_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Il ramena tous les biens, et il ramena aussi son parent Lot et ses biens, les femmes aussi, et le reste du peuple. ");
INSERT INTO frasbl_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Le roi de Sodome sortit à sa rencontre, après son retour du massacre de Chedorlaomer et des rois qui étaient avec lui, dans la vallée de Shaveh (c'est-à-dire la vallée du roi). ");
INSERT INTO frasbl_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Melchisédek, roi de Salem, fit sortir du pain et du vin. Il était prêtre du Dieu Très-Haut. ");
INSERT INTO frasbl_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Il le bénit et dit : « Béni soit Abram du Dieu Très-Haut, possesseur du ciel et de la terre. ");
INSERT INTO frasbl_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Béni soit le Dieu Très-Haut, qui a livré tes ennemis entre tes mains. » Abram lui a donné un dixième de tout. ");
INSERT INTO frasbl_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Le roi de Sodome dit à Abram : « Donne-moi le peuple, et prends les biens pour toi. » ");
INSERT INTO frasbl_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Abram dit au roi de Sodome : « J'ai levé la main vers Yahvé, Dieu Très-Haut, qui possède le ciel et la terre, ");
INSERT INTO frasbl_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","pour ne prendre ni fil, ni lanière de sandale, ni rien de ce qui t'appartient, de peur que tu ne dises : « J'ai enrichi Abram ». ");
INSERT INTO frasbl_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Je n'accepterai rien de toi, si ce n'est ce que les jeunes gens ont mangé, et la part des hommes qui sont partis avec moi : Aner, Eshcol et Mamré. Qu'ils prennent leur part. » ");
INSERT INTO frasbl_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Après cela, la parole de Yahvé fut adressée à Abram dans une vision, en disant : « N'aie pas peur, Abram. Je suis ton bouclier, ta très grande récompense. » ");
INSERT INTO frasbl_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Abram dit : « Seigneur Yahvé, que me donneras-tu, puisque je vais sans enfants, et que celui qui héritera de mes biens est Eliezer de Damas ? » ");
INSERT INTO frasbl_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Abram répondit : « Voici, tu ne m'as pas donné d'enfants ; et voici, celui qui est né dans ma maison est mon héritier. » ");
INSERT INTO frasbl_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Voici que la parole de Yahvé lui fut adressée, en ces termes : « Cet homme ne sera pas ton héritier, mais celui qui sortira de ton propre corps sera ton héritier. » ");
INSERT INTO frasbl_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Yahvé le fit sortir et dit : « Regarde maintenant vers le ciel, et compte les étoiles, si tu sais les compter. » Il dit à Abram : « Ta descendance sera ainsi. » ");
INSERT INTO frasbl_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Il crut en Yahvé, qui le lui attribua à juste titre. ");
INSERT INTO frasbl_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Il dit à Abram : « Je suis Yahvé, qui t'a fait sortir d'Ur des Chaldéens, pour te donner ce pays en héritage. » ");
INSERT INTO frasbl_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Il dit : « Seigneur Yahvé, comment saurai-je que j'en hériterai ? » ");
INSERT INTO frasbl_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Il lui dit : « Apporte-moi une génisse de trois ans, une chèvre de trois ans, un bélier de trois ans, une tourterelle et un jeune pigeon. » ");
INSERT INTO frasbl_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Il lui apporta tout cela, les divisa par le milieu et posa chaque moitié en face de l'autre, mais il ne divisa pas les oiseaux. ");
INSERT INTO frasbl_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Les oiseaux de proie s'abattirent sur les carcasses, et Abram les chassa. ");
INSERT INTO frasbl_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Comme le soleil se couchait, un profond sommeil tomba sur Abram. Une terreur et de grandes ténèbres s'abattirent sur lui. ");
INSERT INTO frasbl_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Il dit à Abram : « Sache que tes descendants vivront comme des étrangers dans un pays qui n'est pas le leur, et qu'ils les serviront. Ils les affligeront pendant quatre cents ans. ");
INSERT INTO frasbl_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Je jugerai aussi cette nation, qu'ils serviront. Ensuite, ils sortiront avec de grandes richesses ; ");
INSERT INTO frasbl_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","mais toi, tu iras en paix chez tes pères. Vous serez enterrés à un âge avancé. ");
INSERT INTO frasbl_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","A la quatrième génération, ils reviendront ici, car l'iniquité des Amorites n'est pas encore complète. » ");
INSERT INTO frasbl_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Lorsque le soleil se coucha et qu'il fit nuit, voici qu'une fournaise fumante et une torche enflammée passèrent entre ces pièces. ");
INSERT INTO frasbl_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","En ce jour-là, Yahvé fit alliance avec Abram, en disant : « Je donne ce pays à ta postérité, depuis le fleuve d'Égypte jusqu'au grand fleuve, le fleuve Euphrate : ");
INSERT INTO frasbl_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","le pays des Kenites, des Kenizzites, des Kadmonites, ");
INSERT INTO frasbl_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","des Hittites, des Perizzites, des Rephaïms, ");
INSERT INTO frasbl_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","des Amorites, des Cananéens, des Girgashites et des Jébusites. » ");
INSERT INTO frasbl_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Saraï, la femme d'Abram, ne lui donna pas d'enfants. Elle avait une servante, une Égyptienne, qui s'appelait Agar. ");
INSERT INTO frasbl_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Saraï dit à Abram : « Voici, Yahvé m'a empêché d'enfanter. Va donc voir ma servante. Il se peut que j'obtienne d'elle des enfants. » Abram écouta la voix de Saraï. ");
INSERT INTO frasbl_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Saraï, la femme d'Abram, prit Agar l'Égyptienne, sa servante, après qu'Abram eut vécu dix ans au pays de Canaan, et la donna pour femme à son mari Abram. ");
INSERT INTO frasbl_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Il alla vers Agar, et elle devint enceinte. Quand elle vit qu'elle avait conçu, sa maîtresse fut méprisée à ses yeux. ");
INSERT INTO frasbl_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Saraï dit à Abram : « Ce tort est de ta faute. J'ai mis ma servante dans ton sein, et quand elle a vu qu'elle avait conçu, elle m'a méprisée. Que Yahvé juge entre moi et toi. » ");
INSERT INTO frasbl_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Mais Abram dit à Saraï : « Voici ta servante qui est entre tes mains. Fais-lui tout ce qui est bon à tes yeux. » Saraï la traita durement, et elle s'enfuit devant elle. ");
INSERT INTO frasbl_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","L'ange de Yahvé la trouva près d'une fontaine d'eau dans le désert, près de la fontaine sur le chemin de Shur. ");
INSERT INTO frasbl_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Il lui dit : « Agar, servante de Saraï, d'où viens-tu ? Où vas-tu ? » Elle a dit : « Je fuis le visage de ma maîtresse Saraï. » ");
INSERT INTO frasbl_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","L'ange de Yahvé lui dit : « Retourne vers ta maîtresse, et soumets-toi à ses mains. » ");
INSERT INTO frasbl_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","L'ange de Yahvé lui dit : « Je multiplierai beaucoup ta descendance, et elle ne sera pas comptée comme une multitude. » ");
INSERT INTO frasbl_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","L'ange de Yahvé lui dit : « Voici, tu es enceinte, et tu vas enfanter un fils. Tu lui donneras le nom d'Ismaël, car Yahvé a entendu ta souffrance. ");
INSERT INTO frasbl_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Il sera comme un âne sauvage parmi les hommes. Sa main sera contre tout homme, et la main de tout homme contre lui. Il vivra en opposition à tous ses frères. » ");
INSERT INTO frasbl_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Elle appela le nom de Yahvé qui lui avait parlé : « Tu es un Dieu qui voit », car elle disait : « Suis-je restée en vie après l'avoir vu ? » ");
INSERT INTO frasbl_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","C'est pourquoi on appela le puits Beer Lahai Roi. Voici, il est entre Kadès et Bered. ");
INSERT INTO frasbl_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Agar enfanta un fils à Abram. Abram donna à son fils, qu'Agar avait enfanté, le nom d'Ismaël. ");
INSERT INTO frasbl_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abram était âgé de quatre-vingt-six ans quand Agar enfanta Ismaël à Abram. ");
INSERT INTO frasbl_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Alors qu'Abram était âgé de quatre-vingt-dix-neuf ans, Yahvé apparut à Abram et lui dit : « Je suis le Dieu tout-puissant. Marche devant moi et sois irréprochable. ");
INSERT INTO frasbl_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Je conclurai mon alliance entre moi et toi, et je te multiplierai à l'infini. » ");
INSERT INTO frasbl_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Abram tomba sur sa face. Dieu lui parla, en disant : ");
INSERT INTO frasbl_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","« Quant à moi, voici que mon alliance est avec toi. Tu seras le père d'une multitude de nations. ");
INSERT INTO frasbl_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Ton nom ne sera plus Abram, mais ton nom sera Abraham, car je t'ai établi père d'une multitude de nations. ");
INSERT INTO frasbl_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Je te rendrai extrêmement fécond, et je ferai de toi des nations. Des rois sortiront de toi. ");
INSERT INTO frasbl_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","J'établirai mon alliance entre moi et toi, et tes descendants après toi, de génération en génération, comme une alliance éternelle, pour être un Dieu pour toi et pour tes descendants après toi. ");
INSERT INTO frasbl_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Je vous donnerai, à vous et à votre postérité après vous, le pays où vous voyagez, tout le pays de Canaan, comme une possession éternelle. Je serai leur Dieu. » ");
INSERT INTO frasbl_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Dieu dit à Abraham : « Pour toi, tu garderas mon alliance, toi et ta postérité après toi, de génération en génération. ");
INSERT INTO frasbl_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Voici mon alliance, que tu garderas, entre moi et toi, et ta postérité après toi. Tout mâle parmi vous sera circoncis. ");
INSERT INTO frasbl_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Vous serez circoncis dans la chair de votre prépuce. Ce sera un signe de l'alliance entre moi et vous. ");
INSERT INTO frasbl_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Celui qui aura huit jours sera circoncis parmi vous, tout mâle, de génération en génération, qu'il soit né dans la maison ou acheté à prix d'argent à un étranger qui n'est pas de votre race. ");
INSERT INTO frasbl_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Celui qui est né dans ta maison, et celui qui a été acheté avec ton argent, doit être circoncis. Mon alliance sera dans ta chair pour une alliance éternelle. ");
INSERT INTO frasbl_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Le mâle incirconcis qui n'est pas circoncis dans la chair de son prépuce, cette âme sera retranchée de son peuple. Il a rompu mon alliance. » ");
INSERT INTO frasbl_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Dieu dit à Abraham : « Pour ce qui est de Saraï, ta femme, tu ne l'appelleras pas Saraï, mais son nom sera Sara. ");
INSERT INTO frasbl_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Je la bénirai, et en plus je te donnerai un fils par elle. Oui, je la bénirai, et elle sera une mère de nations. Les rois des peuples viendront d'elle. » ");
INSERT INTO frasbl_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Alors Abraham tomba sur sa face et se mit à rire, et il dit en son cœur : « Naîtra-t-il un enfant à celui qui est âgé de cent ans ? Sara, qui a quatre-vingt-dix ans, accouchera-t-elle ? » ");
INSERT INTO frasbl_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Abraham dit à Dieu : « Oh, si Ismaël pouvait vivre devant toi ! » ");
INSERT INTO frasbl_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Dieu dit : « Non, mais Sara, ta femme, t'enfantera un fils. Tu lui donneras le nom d'Isaac. J'établirai mon alliance avec lui comme une alliance éternelle pour sa descendance après lui. ");
INSERT INTO frasbl_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Quant à Ismaël, je t'ai entendu. Voici, je l'ai béni, je le rendrai fécond et je le multiplierai à l'infini. Il sera le père de douze princes, et je ferai de lui une grande nation. ");
INSERT INTO frasbl_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Mais j'établirai mon alliance avec Isaac, que Sarah t'enfantera l'année prochaine à cette époque précise. » ");
INSERT INTO frasbl_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Quand il eut fini de parler avec lui, Dieu s'éloigna d'Abraham. ");
INSERT INTO frasbl_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Abraham prit son fils Ismaël, tous ceux qui étaient nés dans sa maison et tous ceux qu'il avait achetés avec son argent, tous les mâles parmi les hommes de la maison d'Abraham, et il circoncit la chair de leur prépuce le même jour, comme Dieu le lui avait dit. ");
INSERT INTO frasbl_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abraham était âgé de quatre-vingt-dix-neuf ans lorsqu'il fut circoncis dans la chair de son prépuce. ");
INSERT INTO frasbl_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Ismaël, son fils, avait treize ans lorsqu'il fut circoncis dans la chair de son prépuce. ");
INSERT INTO frasbl_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Le même jour, Abraham et Ismaël, son fils, furent circoncis. ");
INSERT INTO frasbl_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Tous les hommes de sa maison, ceux qui étaient nés dans la maison et ceux qui avaient été achetés à prix d'argent à un étranger, furent circoncis avec lui. ");
INSERT INTO frasbl_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Yahvé lui apparut près des chênes de Mamré, comme il était assis à l'entrée de la tente, dans la chaleur du jour. ");
INSERT INTO frasbl_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Il leva les yeux et regarda, et il vit que trois hommes se tenaient près de lui. Il courut à leur rencontre depuis l'entrée de la tente, se prosterna à terre ");
INSERT INTO frasbl_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","etdit : « Seigneur, si j'ai trouvé grâce à tes yeux, ne te sépare pas de ton serviteur. ");
INSERT INTO frasbl_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Allez maintenant chercher un peu d'eau, lavez vos pieds, et reposez-vous sous l'arbre. ");
INSERT INTO frasbl_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Je vais chercher un morceau de pain pour que vous puissiez vous rafraîchir le cœur. Après cela, vous pourrez vous en aller, maintenant que vous êtes venus vers votre serviteur. » Ils ont dit : « Très bien, faites ce que vous avez dit. » ");
INSERT INTO frasbl_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Abraham se précipita dans la tente vers Sara, et dit : « Prépare vite trois seahs de fleur de farine, pétris-la et fais des gâteaux. » ");
INSERT INTO frasbl_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Abraham courut au troupeau, prit un veau tendre et bon, et le donna au serviteur. Celui-ci s'empressa de le panser. ");
INSERT INTO frasbl_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Il prit du beurre, du lait et le veau qu'il avait habillé, et il le mit devant eux. Il se tint près d'eux sous l'arbre, et ils mangèrent. ");
INSERT INTO frasbl_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Ils lui demandèrent : « Où est Sarah, ta femme ? » Il a dit : « Là, dans la tente. » ");
INSERT INTO frasbl_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Il dit : « Je reviendrai certainement chez toi l'année prochaine à peu près à la même époque ; et voici que Sarah, ta femme, aura un fils. » Sara entendit à la porte de la tente, qui était derrière lui. ");
INSERT INTO frasbl_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Or Abraham et Sara étaient vieux, d'un âge avancé. Sara avait dépassé l'âge de procréer. ");
INSERT INTO frasbl_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Sara riait en elle-même, disant : « Quand je serai vieille, aurai-je du plaisir, mon seigneur étant vieux aussi ? » ");
INSERT INTO frasbl_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Yahvé dit à Abraham : « Pourquoi Sarah a-t-elle ri en disant : « Aurai-je vraiment un enfant quand je serai vieille ? ");
INSERT INTO frasbl_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Y a-t-il quelque chose de trop difficile pour Yahvé ? Au temps fixé, je reviendrai vers toi, à la saison qui vient, et Sara aura un fils. » ");
INSERT INTO frasbl_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Alors Sarah le nia, disant : « Je n'ai pas ri », car elle avait peur. Il a dit : « Non, mais vous avez ri. » ");
INSERT INTO frasbl_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Les hommes se levèrent de là et regardèrent vers Sodome. Abraham alla avec eux pour les voir en chemin. ");
INSERT INTO frasbl_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Yahvé dit : « Est-ce que je cacherai à Abraham ce que je fais, ");
INSERT INTO frasbl_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","puisque Abraham deviendra une nation grande et puissante, et que toutes les nations de la terre seront bénies en lui ? ");
INSERT INTO frasbl_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Car je l'ai connu, afin qu'il commande à ses enfants et à sa famille après lui, pour qu'ils gardent la voie de l'Éternel, en pratiquant la justice et l'équité, afin que l'Éternel fasse venir sur Abraham ce qu'il a dit de lui. » ");
INSERT INTO frasbl_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Yahvé dit : « Puisque le cri de Sodome et de Gomorrhe est grand, et que leur péché est très grave, ");
INSERT INTO frasbl_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","je descendrai maintenant, et je verrai si leurs actes sont aussi mauvais que les rapports qui me sont parvenus. Si ce n'est pas le cas, je le saurai. » ");
INSERT INTO frasbl_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Les hommes se détournèrent de là et allèrent vers Sodome, mais Abraham se tenait encore devant Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Abraham s'approcha, et dit : Veux-tu consumer les justes avec les méchants ? ");
INSERT INTO frasbl_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Et s'il y a cinquante justes dans la ville ? Vas-tu consumer et ne pas épargner la place pour les cinquante justes qui s'y trouvent ? ");
INSERT INTO frasbl_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Qu'il soit loin de toi de faire de telles choses, de tuer les justes avec les méchants, afin que les justes soient comme les méchants. Que cela soit loin de vous. Le Juge de toute la terre ne devrait-il pas faire ce qui est juste ? » ");
INSERT INTO frasbl_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Yahvé dit : « Si je trouve à Sodome cinquante justes dans la ville, j'épargnerai tout le lieu à cause d'eux. » ");
INSERT INTO frasbl_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Abraham répondit : « Voici, j'ai pris sur moi de parler au Seigneur, bien que je sois poussière et cendre. ");
INSERT INTO frasbl_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Et s'il manque cinq des cinquante justes ? Détruiras-tu toute la ville par manque de cinq ? » Il a dit : « Je ne la détruirai pas si j'y trouve quarante-cinq personnes. » ");
INSERT INTO frasbl_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Il lui parla encore, et dit : « Et s'il y en a quarante qui se trouvent là ? » Il a dit : « Je ne le ferai pas pour l'amour des quarante. » ");
INSERT INTO frasbl_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Il dit : « Oh, ne laissez pas le Seigneur se mettre en colère, et je parlerai. Et s'il y en a trente trouvés là ? » Il a dit : « Je ne le ferai pas si j'en trouve trente là-bas. » ");
INSERT INTO frasbl_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Il dit : « Voici, j'ai pris sur moi de parler au Seigneur. Et s'il y en a vingt qui se trouvent là ? » Il a dit : « Je ne la détruirai pas à cause des vingt. » ");
INSERT INTO frasbl_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Il dit : « Oh, que le Seigneur ne se mette pas en colère, et je ne parlerai qu'une fois de plus. Et si l'on en trouve dix là-bas ? » Il a dit : « Je ne la détruirai pas à cause des dix. » ");
INSERT INTO frasbl_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Yahvé s'en alla dès qu'il eut fini de s'entretenir avec Abraham, et Abraham retourna à sa place. ");
INSERT INTO frasbl_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Les deux anges arrivèrent à Sodome le soir. Lot était assis à la porte de Sodome. Lot les vit et se leva pour aller à leur rencontre. Il se prosterna, le visage contre terre, ");
INSERT INTO frasbl_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","et dit : « Voici, mes seigneurs, entrez dans la maison de votre serviteur, restez-y toute la nuit, lavez-vous les pieds, et vous pourrez vous lever de bonne heure et poursuivre votre route. » Ils ont dit : « Non, mais on va rester dans la rue toute la nuit. » ");
INSERT INTO frasbl_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Il les pressa beaucoup ; ils vinrent avec lui, et entrèrent dans sa maison. Il leur fit un festin, il fit cuire des pains sans levain, et ils mangèrent. ");
INSERT INTO frasbl_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Mais avant qu'ils ne se couchent, les hommes de la ville, les hommes de Sodome, entourèrent la maison, jeunes et vieux, tous les gens de tous les quartiers. ");
INSERT INTO frasbl_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Ils appelèrent Lot et lui dirent : « Où sont les hommes qui sont entrés chez toi cette nuit ? Fais-les sortir vers nous, afin que nous fassions l'amour avec eux. » ");
INSERT INTO frasbl_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lot sortit vers eux par la porte, et ferma la porte après lui. ");
INSERT INTO frasbl_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Il dit : « Je vous en prie, mes frères, n'agissez pas si méchamment. ");
INSERT INTO frasbl_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Voici, j'ai deux filles vierges. Laissez-moi vous les amener, et vous pourrez leur faire ce que vous voudrez. Mais ne faites rien à ces hommes, car ils sont venus à l'ombre de mon toit. » ");
INSERT INTO frasbl_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Ils dirent : « Reculez ! » Puis ils dirent : « Cet homme est venu vivre comme un étranger, et il se fait juge. Maintenant, nous allons faire pire avec toi qu'avec eux ! » Ils pressèrent fortement l'homme Lot et s'approchèrent pour briser la porte. ");
INSERT INTO frasbl_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Mais les hommes tendirent la main, firent entrer Lot auprès d'eux dans la maison et fermèrent la porte. ");
INSERT INTO frasbl_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Ils frappèrent de cécité les hommes qui étaient à la porte de la maison, petits et grands, de sorte qu'ils se fatiguèrent à trouver la porte. ");
INSERT INTO frasbl_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Les hommes dirent à Lot : « As-tu quelqu'un d'autre ici ? Beaux-fils, tes fils, tes filles, et tous ceux que tu as dans la ville, fais-les sortir de ce lieu ; ");
INSERT INTO frasbl_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","car nous allons détruire ce lieu, car la protestation contre eux a été si grande devant Yahvé que Yahvé nous a envoyés pour le détruire. » ");
INSERT INTO frasbl_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Lot sortit et parla à ses gendres, qui s'étaient engagés à épouser ses filles, et dit : « Levez-vous ! Sortez de ce lieu, car Yahvé va détruire la ville ! » Mais il sembla à ses gendres qu'il plaisantait. ");
INSERT INTO frasbl_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Le matin venu, les anges pressèrent Lot en disant : « Lève-toi ! Prends ta femme et tes deux filles qui sont ici, de peur que tu ne sois consumé par l'iniquité de la ville. » ");
INSERT INTO frasbl_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Mais il s'attarda ; les hommes saisirent sa main, la main de sa femme et les mains de ses deux filles, Yahvé étant miséricordieux envers lui ; ils le firent sortir et le déposèrent hors de la ville. ");
INSERT INTO frasbl_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Lorsqu'ils les eurent fait sortir, il dit : « Sauve-toi pour sauver ta vie ! Ne regardez pas derrière vous, et ne restez pas dans la plaine. Fuyez vers les montagnes, de peur que vous ne soyez consumés ! ». ");
INSERT INTO frasbl_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Lot leur dit : « Oh, non, mon seigneur. ");
INSERT INTO frasbl_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Vois maintenant, ton serviteur a trouvé grâce à tes yeux, et tu as magnifié ta bonté, dont tu as fait preuve à mon égard en me sauvant la vie. Je ne peux pas m'échapper vers la montagne, de peur que le mal ne m'atteigne et que je meure. ");
INSERT INTO frasbl_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Vois maintenant, cette ville est proche pour y fuir, et c'est une petite ville. Oh ! que je m'y échappe (n'est-ce pas une petite ?), et mon âme vivra. » ");
INSERT INTO frasbl_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Il lui dit : « Voici que j'ai exaucé ta demande concernant cette chose aussi, à savoir que je ne renverserai pas la ville dont tu as parlé. ");
INSERT INTO frasbl_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Dépêche-toi de t'y échapper, car je ne peux rien faire tant que tu n'y seras pas arrivé. » C'est pourquoi le nom de la ville fut appelé Zoar. ");
INSERT INTO frasbl_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Le soleil s'était levé sur la terre lorsque Lot arriva à Zoar. ");
INSERT INTO frasbl_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Alors Yahvé fit pleuvoir du ciel sur Sodome et sur Gomorrhe du soufre et du feu, de la part de Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Il détruisit ces villes, toute la plaine, tous les habitants des villes et ce qui poussait sur le sol. ");
INSERT INTO frasbl_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Mais la femme de Lot regardait derrière lui, et elle devint une colonne de sel. ");
INSERT INTO frasbl_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Abraham se leva de bon matin au lieu où il s'était tenu devant Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Il regarda vers Sodome et Gomorrhe, et vers tout le pays de la plaine, et il vit que la fumée du pays montait comme la fumée d'une fournaise. ");
INSERT INTO frasbl_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Lorsque Dieu détruisit les villes de la plaine, il se souvint d'Abraham et fit sortir Lot du milieu de la destruction, lorsqu'il détruisit les villes dans lesquelles Lot habitait. ");
INSERT INTO frasbl_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lot monta de Tsoar et habita dans la montagne, avec ses deux filles, car il avait peur d'habiter à Tsoar. Il habita dans une grotte avec ses deux filles. ");
INSERT INTO frasbl_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","L'aînée dit à la cadette : « Notre père est vieux, et il n'y a pas d'homme sur la terre pour entrer chez nous à la manière de toute la terre. ");
INSERT INTO frasbl_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Venez, faisons boire du vin à notre père, et nous coucherons avec lui, afin de préserver la lignée de notre père. » ");
INSERT INTO frasbl_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Ils firent boire du vin à leur père cette nuit-là ; l'aînée entra et coucha avec son père. Il ne sut ni quand elle se coucha, ni quand elle se leva. ");
INSERT INTO frasbl_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Le lendemain, l'aînée dit au cadet : « Voici, j'ai couché cette nuit avec mon père. Faisons-lui boire du vin encore cette nuit. Tu entres et tu couches avec lui, afin que nous préservions la lignée de notre père. » ");
INSERT INTO frasbl_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Ils firent boire du vin à leur père cette nuit-là aussi. La plus jeune alla se coucher avec lui. Il ne sut ni quand elle se coucha, ni quand elle se leva. ");
INSERT INTO frasbl_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Ainsi, les deux filles de Lot furent enceintes de leur père. ");
INSERT INTO frasbl_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","L'aînée enfanta un fils, qu'elle appela Moab. Il est le père des Moabites, jusqu'à ce jour. ");
INSERT INTO frasbl_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","La cadette enfanta aussi un fils, qu'elle appela Ben Ammi. Il est le père des enfants d'Ammon jusqu'à ce jour. ");
INSERT INTO frasbl_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abraham partit de là pour se rendre dans le pays du Sud, et il habita entre Kadès et Shur. Il habita comme étranger à Guérar. ");
INSERT INTO frasbl_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Abraham dit de Sara, sa femme : « C'est ma sœur. » Abimélec, roi de Guérar, l'envoya chercher et prit Sara. ");
INSERT INTO frasbl_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Mais Dieu apparut à Abimélec en songe pendant la nuit, et lui dit : « Voici, tu es un homme mort, à cause de la femme que tu as prise, car c'est la femme d'un homme. » ");
INSERT INTO frasbl_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Or Abimélec ne s'était pas approché d'elle. Il dit : « Seigneur, vas-tu tuer même une nation juste ? ");
INSERT INTO frasbl_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Ne m'a-t-il pas dit : C'est ma sœur ? Elle-même a dit : « C'est mon frère ». J'ai fait cela dans l'intégrité de mon cœur et l'innocence de mes mains. » ");
INSERT INTO frasbl_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Dieu lui dit en songe : « Oui, je sais que tu as fait cela dans l'intégrité de ton cœur, et je t'ai aussi empêché de pécher contre moi. C'est pourquoi je ne t'ai pas permis de la toucher. ");
INSERT INTO frasbl_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Maintenant, rends la femme de cet homme. Car il est prophète, il priera pour toi, et tu vivras. Si tu ne la rends pas, sache que tu mourras, toi et tous ceux qui sont à toi. » ");
INSERT INTO frasbl_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Abimélec se leva tôt le matin, appela tous ses serviteurs et leur raconta toutes ces choses à l'oreille. Les hommes eurent très peur. ");
INSERT INTO frasbl_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Alors Abimélec appela Abraham et lui dit : « Que nous as-tu fait ? Comment ai-je péché contre toi, pour que tu aies attiré sur moi et sur mon royaume un grand péché ? Tu m'as fait des choses qui ne doivent pas être faites ! ». ");
INSERT INTO frasbl_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Abimélec dit à Abraham : « Qu'as-tu vu, pour que tu aies fait cette chose ? ». ");
INSERT INTO frasbl_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abraham dit : « Parce que j'ai pensé : « La crainte de Dieu n'est pas dans ce lieu. Ils me tueront à cause de ma femme. ");
INSERT INTO frasbl_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","D'ailleurs, elle est bien ma sœur, la fille de mon père, mais pas la fille de ma mère, et elle est devenue ma femme. ");
INSERT INTO frasbl_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Lorsque Dieu m'a fait errer loin de la maison de mon père, je lui ai dit : « Voici la bonté que tu me témoigneras. Partout où nous irons, tu diras de moi : « C'est mon frère ». ");
INSERT INTO frasbl_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Abimélec prit des brebis et des bœufs, des serviteurs et des servantes, et les donna à Abraham, et il lui rendit Sara, sa femme. ");
INSERT INTO frasbl_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Abimélec dit : « Voici, mon pays est devant toi. Habite où il te plaira. » ");
INSERT INTO frasbl_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Il dit à Sara : « Voici, j'ai donné à ton frère mille pièces d'argent. Voici, c'est pour toi une couverture des yeux pour tous ceux qui sont avec toi. Devant tous, tu es justifiée. » ");
INSERT INTO frasbl_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Abraham pria Dieu. Dieu guérit Abimélek, sa femme et ses servantes, et elles eurent des enfants. ");
INSERT INTO frasbl_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Car l'Éternel avait fermé hermétiquement tous les utérus de la maison d'Abimélec, à cause de Sara, la femme d'Abraham. ");
INSERT INTO frasbl_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","L'Éternel visita Sara comme il l'avait dit, et l'Éternel fit à Sara ce qu'il avait dit. ");
INSERT INTO frasbl_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Sara devint enceinte, et elle enfanta un fils à Abraham dans sa vieillesse, au temps fixé dont Dieu lui avait parlé. ");
INSERT INTO frasbl_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Abraham appela Isaac le fils qui lui était né, et que Sara lui avait enfanté. ");
INSERT INTO frasbl_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Abraham circoncit son fils Isaac, à l'âge de huit jours, comme Dieu le lui avait ordonné. ");
INSERT INTO frasbl_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abraham était âgé de cent ans lorsque son fils Isaac lui est né. ");
INSERT INTO frasbl_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sara dit : « Dieu m'a fait rire. Tous ceux qui l'entendent riront avec moi ». ");
INSERT INTO frasbl_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Elle dit : « Qui aurait dit à Abraham que Sara allaiterait des enfants ? Car je lui ai enfanté un fils dans sa vieillesse. » ");
INSERT INTO frasbl_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","L'enfant grandit et fut sevré. Abraham fit un grand festin le jour où Isaac fut sevré. ");
INSERT INTO frasbl_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Sara vit le fils d'Agar l'Égyptienne, qu'elle avait porté à Abraham, se moquer. ");
INSERT INTO frasbl_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Elle dit alors à Abraham : « Chasse cette servante et son fils ! Car le fils de cette servante ne sera pas héritier de mon fils Isaac. » ");
INSERT INTO frasbl_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","La chose fut très pénible aux yeux d'Abraham, à cause de son fils. ");
INSERT INTO frasbl_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Dieu dit à Abraham : « Que la chose ne soit pas pénible à tes yeux à cause de l'enfant et à cause de ta servante. Dans tout ce que Sarah te dira, écoute sa voix. Car ta descendance sera nommée par Isaac. ");
INSERT INTO frasbl_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Je ferai aussi une nation du fils de l'esclave, car il est ton enfant. » ");
INSERT INTO frasbl_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Abraham se leva de bon matin, prit du pain et un récipient d'eau, et les donna à Agar, en les mettant sur son épaule ; il lui donna l'enfant, et la renvoya. Elle partit, et erra dans le désert de Beer Schéba. ");
INSERT INTO frasbl_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","L'eau du récipient fut épuisée, et elle mit l'enfant sous un des arbustes. ");
INSERT INTO frasbl_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Elle alla s'asseoir en face de lui, à bonne distance, à environ un coup d'arc. Car elle disait : « Ne me laisse pas voir la mort de l'enfant. » Elle s'assit en face de lui, éleva la voix et pleura. ");
INSERT INTO frasbl_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Dieu entendit la voix de l'enfant. L'ange de Dieu appela Hagar du ciel et lui dit : « Qu'est-ce qui te trouble, Hagar ? N'aie pas peur. Car Dieu a entendu la voix de l'enfant là où il est. ");
INSERT INTO frasbl_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Lève-toi, soulève l'enfant, et tiens-le avec ta main. Car je ferai de lui une grande nation. » ");
INSERT INTO frasbl_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Dieu lui ouvrit les yeux, et elle vit un puits d'eau. Elle y alla, remplit le récipient d'eau et donna à boire au garçon. ");
INSERT INTO frasbl_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Dieu était avec le garçon, et il grandit. Il vécut dans le désert, et, en grandissant, il devint archer. ");
INSERT INTO frasbl_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Il habita dans le désert de Paran. Sa mère lui trouva une femme du pays d'Égypte. ");
INSERT INTO frasbl_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","En ce temps-là, Abimélec et Phicol, le chef de son armée, parlèrent à Abraham en disant : « Dieu est avec toi dans tout ce que tu fais. ");
INSERT INTO frasbl_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Maintenant, jure-moi ici par Dieu que tu ne me tromperas pas, ni mon fils, ni le fils de mon fils. Mais selon la bonté que j'ai eue pour toi, tu me feras la même chose qu'au pays dans lequel tu as vécu comme étranger. » ");
INSERT INTO frasbl_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abraham répondit : « Je le jurerai. » ");
INSERT INTO frasbl_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Abraham se plaignit à Abimélec à cause d'un puits d'eau que les serviteurs d'Abimélec avaient violemment enlevé. ");
INSERT INTO frasbl_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimélec répondit : « Je ne sais pas qui a fait cela. Tu ne me l'as pas dit, et je n'en ai entendu parler qu'aujourd'hui. » ");
INSERT INTO frasbl_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Abraham prit des moutons et du bétail, et les donna à Abimélec. Ces deux-là firent une alliance. ");
INSERT INTO frasbl_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Abraham mit à part sept agnelles du troupeau. ");
INSERT INTO frasbl_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimélec dit à Abraham : « Que signifient ces sept agnelles que tu as mises à part ? » ");
INSERT INTO frasbl_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Il dit : « Tu prendras ces sept agnelles de ma main, afin que cela me serve de témoignage que j'ai creusé ce puits. » ");
INSERT INTO frasbl_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Il appela ce lieu Beersheba, car ils y firent tous deux un serment. ");
INSERT INTO frasbl_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Ils firent donc alliance à Beersheba. Abimélec se leva avec Phicol, le chef de son armée, et ils retournèrent au pays des Philistins. ");
INSERT INTO frasbl_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Abraham planta un tamaris à Beersheba, et là, il invoqua le nom de Yahvé, le Dieu de l'éternité. ");
INSERT INTO frasbl_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Abraham vécut longtemps comme un étranger dans le pays des Philistins. ");
INSERT INTO frasbl_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Après ces choses, Dieu mit Abraham à l'épreuve, et lui dit : « Abraham ! » Il a dit : « Je suis là. » ");
INSERT INTO frasbl_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Il dit : « Prends maintenant ton fils, ton fils unique, Isaac, que tu aimes, et va au pays de Moriah. Là, tu l'offriras en holocauste sur l'une des montagnes dont je te parlerai. » ");
INSERT INTO frasbl_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Abraham se leva de bon matin, sella son âne, prit avec lui deux de ses jeunes gens, et son fils Isaac. Il fendit le bois pour l'holocauste, se leva, et alla au lieu dont Dieu lui avait parlé. ");
INSERT INTO frasbl_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Le troisième jour, Abraham leva les yeux, et vit le lieu au loin. ");
INSERT INTO frasbl_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Abraham dit à ses jeunes gens : « Reste ici avec l'âne. Le garçon et moi, nous irons là-bas. Nous nous prosternerons, et nous reviendrons vers toi. » ");
INSERT INTO frasbl_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abraham prit le bois de l'holocauste et le posa sur son fils Isaac. Il prit dans sa main le feu et le couteau. Ils partirent tous deux ensemble. ");
INSERT INTO frasbl_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Isaac parla à Abraham, son père, et dit : « Mon père ? » Il a dit : « Me voici, mon fils. » Il a dit : « Voici le feu et le bois, mais où est l'agneau pour l'holocauste ? » ");
INSERT INTO frasbl_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abraham dit : « Dieu fournira lui-même l'agneau pour l'holocauste, mon fils. » Ils partirent donc tous deux ensemble. ");
INSERT INTO frasbl_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Ils arrivèrent au lieu que Dieu lui avait indiqué. Abraham y bâtit l'autel, et disposa le bois en ordre ; il lia son fils Isaac, et le déposa sur l'autel, sur le bois. ");
INSERT INTO frasbl_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Abraham étendit la main et prit le couteau pour tuer son fils. ");
INSERT INTO frasbl_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","L'ange de Yahvé l'appela du ciel et dit : « Abraham, Abraham ! » Il a dit : « Je suis là. » ");
INSERT INTO frasbl_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Il dit : « Ne pose pas la main sur l'enfant et ne lui fais rien. Car je sais maintenant que tu crains Dieu, puisque tu ne m'as pas caché ton fils, ton fils unique. » ");
INSERT INTO frasbl_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Abraham leva les yeux et regarda, et il vit que derrière lui se trouvait un bélier pris dans le fourré par ses cornes. Abraham alla prendre le bélier, et il l'offrit en holocauste à la place de son fils. ");
INSERT INTO frasbl_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Abraham donna à ce lieu le nom de « Yahvé pourvoyeur ». Comme on le dit encore aujourd'hui : « Sur la montagne de Yahvé, il sera pourvu ». ");
INSERT INTO frasbl_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","L'ange de Yahvé appela une seconde fois Abraham du haut du ciel, ");
INSERT INTO frasbl_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","et dit : « Je le jure par moi-même, dit Yahvé, parce que tu as fait cela et que tu n'as pas refusé ton fils, ton unique, ");
INSERT INTO frasbl_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","je te bénirai grandement, et je multiplierai ta postérité comme les étoiles du ciel et comme le sable qui est au bord de la mer. Ta descendance possédera la porte de ses ennemis. ");
INSERT INTO frasbl_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Toutes les nations de la terre seront bénies par ta descendance, parce que tu as obéi à ma voix.'\" ");
INSERT INTO frasbl_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Abraham retourna donc vers ses jeunes gens, et ils se levèrent et partirent ensemble pour Beersheba. Abraham habitait à Beersheba. ");
INSERT INTO frasbl_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Après cela, on dit à Abraham : « Voici Milca, elle aussi a enfanté des enfants à ton frère Nachor : ");
INSERT INTO frasbl_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Uz, son premier-né, Buz, son frère, Kemuel, père d'Aram, ");
INSERT INTO frasbl_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Chesed, Hazo, Pildash, Jidlaph et Bethuel. » ");
INSERT INTO frasbl_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Bethuel devint le père de Rebecca. Ces huit enfants, Milca les porta à Nachor, frère d`Abraham. ");
INSERT INTO frasbl_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Sa concubine, dont le nom était Reuma, enfanta aussi Teba, Gaham, Tahash et Maaca. ");
INSERT INTO frasbl_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sarah a vécu cent vingt-sept ans. Telle fut la durée de la vie de Sara. ");
INSERT INTO frasbl_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Sara mourut à Kiriath Arba (appelée aussi Hébron), dans le pays de Canaan. Abraham vint pour porter le deuil de Sara et pour la pleurer. ");
INSERT INTO frasbl_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Abraham se leva de devant sa mort et parla aux fils de Heth, en disant : ");
INSERT INTO frasbl_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","« Je suis un étranger et une étrangère qui vit avec vous. Donnez-moi la possession d'un lieu de sépulture chez vous, afin que j'enterre mes morts hors de ma vue. » ");
INSERT INTO frasbl_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Les fils de Heth prirent la parole et dirent à Abraham : ");
INSERT INTO frasbl_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","« Écoute-nous, mon seigneur. Tu es un prince de Dieu parmi nous. Enterre tes morts dans le meilleur de nos tombeaux. Aucun de nous ne te refusera son tombeau. Enterre tes morts. » ");
INSERT INTO frasbl_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Abraham se leva, et se prosterna devant le peuple du pays, devant les fils de Heth. ");
INSERT INTO frasbl_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Il leur parla ainsi : « Si vous êtes d'accord pour que j'enterre mes morts hors de ma vue, écoutez-moi, et plaidez pour moi auprès d'Ephron, fils de Zohar, ");
INSERT INTO frasbl_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","afin qu'il me vende la grotte de Macpéla qu'il possède, qui est au bout de son champ. Pour le plein prix, qu'il me la vende au milieu de vous comme une possession pour une sépulture. » ");
INSERT INTO frasbl_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Or Éphron était assis au milieu des fils de Heth. Ephron, le Hittite, répondit à Abraham en présence des fils de Heth, de tous ceux qui entraient à la porte de sa ville, et dit : ");
INSERT INTO frasbl_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","« Non, mon seigneur, écoute-moi. Je te donne le champ, et je te donne la grotte qui s'y trouve. En présence des enfants de mon peuple, je te la donne. Enterre tes morts. » ");
INSERT INTO frasbl_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Abraham se prosterna devant le peuple du pays. ");
INSERT INTO frasbl_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Il s'adressa à Ephron, en présence du peuple du pays, et dit : « Mais si tu le veux, écoute-moi. Je vais donner le prix du champ. Prends-le de ma part, et j'y enterrerai mes morts. » ");
INSERT INTO frasbl_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Ephron prit la parole et dit à Abraham : ");
INSERT INTO frasbl_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","« Mon seigneur, écoute-moi. Qu'est-ce qu'un morceau de terre valant quatre cents sicles d'argent entre moi et toi ? Enterre donc tes morts. » ");
INSERT INTO frasbl_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abraham écouta Ephron. Abraham pesa à Ephron l'argent qu'il avait nommé à l'audition des fils de Heth, quatre cents sicles d'argent, selon l'usage courant des marchands. ");
INSERT INTO frasbl_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Le champ d'Ephron, qui était à Macpéla, en face de Mamré, le champ, la caverne qui s'y trouvait, et tous les arbres qui étaient dans le champ, dans toute son étendue, furent donnés ");
INSERT INTO frasbl_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","à Abraham comme possession en présence des fils de Heth, devant tous ceux qui entraient à la porte de sa ville. ");
INSERT INTO frasbl_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Après cela, Abraham enterra Sara, sa femme, dans la caverne du champ de Macpéla, devant Mamré, c'est-à-dire Hébron, au pays de Canaan. ");
INSERT INTO frasbl_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Le champ et la grotte qui s'y trouve ont été cédés à Abraham par les fils de Heth comme une possession pour une sépulture. ");
INSERT INTO frasbl_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abraham était vieux, d'un âge avancé. Yahvé avait béni Abraham en toutes choses. ");
INSERT INTO frasbl_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Abraham dit à son serviteur, l'aîné de sa maison, qui régnait sur tout ce qu'il possédait : « Mets, je te prie, ta main sous ma cuisse. ");
INSERT INTO frasbl_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Je te ferai jurer par Yahvé, le Dieu du ciel et le Dieu de la terre, que tu ne prendras pas pour mon fils une femme parmi les filles des Cananéens au milieu desquels j'habite. ");
INSERT INTO frasbl_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Mais tu iras dans mon pays et dans ma famille, et tu prendras une femme pour mon fils Isaac. » ");
INSERT INTO frasbl_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Le serviteur lui dit : « Et si la femme ne veut pas me suivre dans ce pays ? Dois-je ramener ton fils dans le pays d'où tu viens ? » ");
INSERT INTO frasbl_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abraham lui dit : « Prends garde de ne plus y amener mon fils. ");
INSERT INTO frasbl_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Yahvé, le Dieu des cieux, qui m'a enlevé de la maison de mon père et du pays où je suis né, qui m'a parlé et qui m'a juré : « Je donnerai ce pays à ta postérité », enverra son ange devant toi, et tu prendras de là une femme pour mon fils. ");
INSERT INTO frasbl_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Si la femme ne veut pas te suivre, alors tu seras dégagé de ce serment envers moi. Seulement, tu n'y amèneras plus mon fils. » ");
INSERT INTO frasbl_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Le serviteur mit sa main sous la cuisse d'Abraham, son maître, et lui jura sur cette affaire. ");
INSERT INTO frasbl_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Le serviteur prit dix chameaux de son maître, et s'en alla, ayant avec lui une foule de biens appartenant à son maître. Il se leva, et se rendit en Mésopotamie, dans la ville de Nachor. ");
INSERT INTO frasbl_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Il fit agenouiller les chameaux hors de la ville, près du puits d'eau, à l'heure du soir, heure à laquelle les femmes sortent pour puiser de l'eau. ");
INSERT INTO frasbl_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Il dit : « Yahvé, le Dieu de mon maître Abraham, donne-moi aujourd'hui du succès et fais preuve de bonté envers mon maître Abraham. ");
INSERT INTO frasbl_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Voici que je me tiens près de la source d'eau. Les filles des hommes de la ville sortent pour puiser de l'eau. ");
INSERT INTO frasbl_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Que la jeune fille à qui je dirai : « Abaisse ta cruche pour que je boive », puis qui dira : « Bois et je donnerai à boire à tes chameaux », soit celle que tu as désignée pour ton serviteur Isaac. Je saurai ainsi que tu as fait preuve de bonté envers mon maître. » ");
INSERT INTO frasbl_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Avant qu'il ait fini de parler, voici que sortait Rébecca, née de Bethuel, fils de Milca, femme de Nachor, frère d'Abraham, avec sa cruche sur l'épaule. ");
INSERT INTO frasbl_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","La jeune femme était très belle à voir, elle était vierge. Aucun homme ne l'avait connue. Elle descendit à la source, remplit sa cruche et remonta. ");
INSERT INTO frasbl_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","La servante courut à sa rencontre et dit : « Je t'en prie, donne-moi à boire, un peu d'eau de ta cruche. » ");
INSERT INTO frasbl_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Elle dit : « Bois, mon seigneur. » Elle se hâta, laissa tomber sa cruche sur sa main et lui donna à boire. ");
INSERT INTO frasbl_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Lorsqu'elle eut fini de lui donner à boire, elle dit : « Je vais aussi puiser pour tes chameaux, jusqu'à ce qu'ils aient fini de boire. » ");
INSERT INTO frasbl_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Elle se dépêcha de vider sa cruche dans l'auge, courut de nouveau au puits pour puiser, et puisa pour tous ses chameaux. ");
INSERT INTO frasbl_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","L'homme la regardait fixement, en gardant le silence, pour savoir si l'Éternel avait fait prospérer son voyage ou non. ");
INSERT INTO frasbl_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Comme les chameaux avaient fini de boire, l'homme prit un anneau d'or du poids d'un demi-sékel et deux bracelets pour ses mains du poids de dix sicles d'or, ");
INSERT INTO frasbl_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","et dit : « De qui es-tu la fille ? Dis-moi, je t'en prie. Y a-t-il de la place dans la maison de ton père pour nous loger ? » ");
INSERT INTO frasbl_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Elle lui répondit : « Je suis la fille de Bethuel, fils de Milca, qu'elle a enfanté à Nachor. » ");
INSERT INTO frasbl_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Elle lui dit encore : « Nous avons de la paille et du fourrage en quantité suffisante, et de quoi nous loger. » ");
INSERT INTO frasbl_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","L'homme baissa la tête et se prosterna devant Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Il dit : « Béni soit Yahvé, le Dieu de mon maître Abraham, qui n'a pas renoncé à sa bonté et à sa fidélité envers mon maître. Quant à moi, Yahvé m'a conduit sur le chemin de la maison des parents de mon maître. » ");
INSERT INTO frasbl_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","La jeune femme courut, et rapporta ces paroles à la maison de sa mère. ");
INSERT INTO frasbl_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Rébecca avait un frère, qui s'appelait Laban. Laban courut vers l'homme, vers la source. ");
INSERT INTO frasbl_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Lorsqu'il vit l'anneau et les bracelets aux mains de sa sœur, et qu'il entendit les paroles de Rebecca, sa sœur, disant : « C'est ce que l'homme m'a dit », il vint vers l'homme. Voici, il se tenait près des chameaux, à la source. ");
INSERT INTO frasbl_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Il dit : « Entre, béni de Yahvé. Pourquoi te tiens-tu dehors ? Car j'ai préparé la maison, et de la place pour les chameaux. » ");
INSERT INTO frasbl_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","L'homme entra dans la maison, et il déchargea les chameaux. Il donna de la paille et de la nourriture pour les chameaux, et de l'eau pour laver ses pieds et ceux des hommes qui étaient avec lui. ");
INSERT INTO frasbl_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","On lui mit à manger devant lui, mais il dit : « Je ne mangerai pas avant d'avoir dit mon message. » Laban a dit : « Parle. » ");
INSERT INTO frasbl_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Il répondit : « Je suis le serviteur d'Abraham. ");
INSERT INTO frasbl_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Yahvé a fait de mon maître une grande bénédiction. Il est devenu grand. Yahvé lui a donné des troupeaux, de l'argent et de l'or, des serviteurs et des servantes, des chameaux et des ânes. ");
INSERT INTO frasbl_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Sara, la femme de mon maître, a enfanté un fils à mon maître quand elle était vieille. Il lui a donné tout ce qu'il possède. ");
INSERT INTO frasbl_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Mon maître m'a fait jurer en disant : « Tu ne prendras pas pour mon fils une femme parmi les filles des Cananéens, dans le pays desquels j'habite, ");
INSERT INTO frasbl_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","mais tu iras dans la maison de mon père et dans ma parenté, et tu prendras une femme pour mon fils ». ");
INSERT INTO frasbl_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","J'ai demandé à mon maître : « Et si la femme ne veut pas me suivre ? » ");
INSERT INTO frasbl_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Il m'a répondu : « L'Éternel, devant qui je marche, enverra son ange avec toi et fera prospérer ton chemin. Tu prendras pour mon fils une femme de ma famille et de la maison de mon père. ");
INSERT INTO frasbl_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Tu seras ainsi libéré de mon serment, quand tu iras chez mes parents. S'ils ne te la donnent pas, tu seras libéré de mon serment. ");
INSERT INTO frasbl_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Je suis venu aujourd'hui à la source et j'ai dit : « Yahvé, Dieu de mon maître Abraham, si maintenant tu fais prospérer le chemin que j'emprunte, ");
INSERT INTO frasbl_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","voici que je me tiens près de cette source d'eau. Que la jeune fille qui vient puiser, à qui je dirai : « Donne-moi un peu d'eau de ta cruche pour boire », ");
INSERT INTO frasbl_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","et qui me dira : « Bois, et je puiserai aussi pour tes chameaux », soit la femme que Yahvé a désignée pour le fils de mon maître. ");
INSERT INTO frasbl_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Avant que j'aie fini de parler en mon cœur, voici que Rebecca sortit, sa cruche sur l'épaule. Elle est descendue à la source et a puisé. Je lui ai dit : « Laisse-moi boire, je te prie ». ");
INSERT INTO frasbl_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Elle s'empressa de laisser tomber sa cruche de son épaule et dit : « Bois, et je donnerai aussi à boire à tes chameaux. Je bus donc, et elle donna aussi à boire aux chameaux. ");
INSERT INTO frasbl_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Je l'ai interrogée, et j'ai dit : « De qui es-tu la fille ? Elle répondit : « Fille de Bethuel, fils de Nachor, que Milca lui a enfantée ». Je mis l'anneau à son nez, et les bracelets à ses mains. ");
INSERT INTO frasbl_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Je me suis incliné, j'ai adoré Yahvé et j'ai béni Yahvé, le Dieu de mon maître Abraham, qui m'a conduit dans la bonne voie pour prendre la fille du frère de mon maître pour son fils. ");
INSERT INTO frasbl_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Maintenant, si tu veux traiter mon maître avec bonté et sincérité, dis-le moi. Sinon, dis-le moi, afin que je me tourne à droite ou à gauche. » ");
INSERT INTO frasbl_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Laban et Béthuel répondirent : « La chose procède de Yahvé. Nous ne pouvons pas te parler en mal ou en bien. ");
INSERT INTO frasbl_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Voici, Rebecca est devant vous. Prends-la, va, et qu'elle soit la femme du fils de ton maître, comme l'a dit Yahvé. » ");
INSERT INTO frasbl_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Lorsque le serviteur d'Abraham entendit leurs paroles, il se prosterna en terre devant Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Le serviteur sortit des bijoux d'argent, des bijoux d'or et des vêtements, et il les donna à Rebecca. Il donna aussi des objets précieux à son frère et à sa mère. ");
INSERT INTO frasbl_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Ils mangèrent et burent, lui et les hommes qui étaient avec lui, et passèrent la nuit. Ils se levèrent le matin, et il dit : « Envoie-moi chez mon maître. » ");
INSERT INTO frasbl_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Son frère et sa mère ont dit : « Que la jeune fille reste avec nous quelques jours, au moins dix. Après cela, elle partira. » ");
INSERT INTO frasbl_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Il leur dit : « Ne me faites pas obstacle, puisque l'Éternel a favorisé mon chemin. Faites-moi partir pour que j'aille vers mon maître. » ");
INSERT INTO frasbl_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Ils dirent : « Nous appellerons la jeune fille, et nous lui demanderons. » ");
INSERT INTO frasbl_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Ils appelèrent Rebecca, et lui dirent : « Veux-tu aller avec cet homme ? » Elle a dit : « Je vais y aller. » ");
INSERT INTO frasbl_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Ils envoyèrent Rebecca, leur sœur, avec sa nourrice, le serviteur d'Abraham et ses hommes. ");
INSERT INTO frasbl_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Ils bénirent Rebecca et lui dirent : « Notre sœur, que tu sois la mère de milliers de dix mille, et que ta descendance possède la porte de ceux qui les haïssent. » ");
INSERT INTO frasbl_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Rebekah se leva avec ses dames. Elles montèrent sur les chameaux, et suivirent l'homme. Le serviteur prit Rebecca, et s'en alla. ");
INSERT INTO frasbl_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Isaac vint du chemin de Beer Lahai Roi, car il habitait dans le pays du Sud. ");
INSERT INTO frasbl_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Le soir, Isaac sortit pour méditer dans les champs. Il leva les yeux et regarda. Et voici, des chameaux arrivaient. ");
INSERT INTO frasbl_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebecca leva les yeux, et quand elle vit Isaac, elle descendit du chameau. ");
INSERT INTO frasbl_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Elle dit au serviteur : « Qui est l'homme qui marche dans le champ à notre rencontre ? » Le serviteur a dit : « C'est mon maître. » Elle prit son voile, et se couvrit. ");
INSERT INTO frasbl_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Le serviteur raconta à Isaac toutes les choses qu'il avait faites. ");
INSERT INTO frasbl_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Isaac la fit entrer dans la tente de Sara, sa mère ; il prit Rebecca, et elle devint sa femme. Il l'aima. Isaac fut donc réconforté après la mort de sa mère. ");
INSERT INTO frasbl_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abraham prit une autre femme, qui s'appelait Ketura. ");
INSERT INTO frasbl_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Elle lui enfanta Zimran, Jokshan, Medan, Midian, Ishbak et Shuah. ");
INSERT INTO frasbl_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Jokshan engendra Saba et Dedan. Les fils de Dedan furent Asshurim, Letushim et Leummim. ");
INSERT INTO frasbl_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Les fils de Madian furent : Épha, Épher, Hanoch, Abida et Eldaa. Tous ceux-là étaient les enfants de Ketura. ");
INSERT INTO frasbl_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abraham donna tout ce qu'il avait à Isaac, ");
INSERT INTO frasbl_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","mais Abraham fit des dons aux fils de ses concubines. Tant qu'il vivait encore, il les envoya loin de son fils Isaac, vers l'orient, dans le pays d'Orient. ");
INSERT INTO frasbl_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Voici les jours des années de la vie d'Abraham, qu'il a vécues : cent soixante-quinze ans. ");
INSERT INTO frasbl_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Abraham rendit l'esprit, et mourut dans un âge avancé, un vieillard rassasié d'années, et il fut recueilli auprès de son peuple. ");
INSERT INTO frasbl_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Isaac et Ismaël, ses fils, l'enterrèrent dans la caverne de Macpéla, dans le champ d'Éphron, fils de Zohar, le Hittite, qui est près de Mamré, ");
INSERT INTO frasbl_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","champ qu'Abraham avait acheté des fils de Heth. Abraham y fut enterré avec Sara, sa femme. ");
INSERT INTO frasbl_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Après la mort d'Abraham, Dieu bénit Isaac, son fils. Isaac habitait près de Beer Lahai Roi. ");
INSERT INTO frasbl_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Or voici l'histoire des générations d'Ismaël, fils d'Abraham, qu'Agar l'Égyptienne, servante de Sara, enfanta à Abraham. ");
INSERT INTO frasbl_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Voici les noms des fils d'Ismaël, selon leurs noms, d'après l'ordre de leur naissance : le premier-né d'Ismaël, Nebaioth, puis Kedar, Adbeel, Mibsam, ");
INSERT INTO frasbl_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mishma, Dumah, Massa, ");
INSERT INTO frasbl_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad, Tema, Jetur, Naphish et Kedemah. ");
INSERT INTO frasbl_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Ce sont là les fils d`Ismaël, et ce sont là leurs noms, selon leurs villages et selon leurs campements : douze princes, selon leurs nations. ");
INSERT INTO frasbl_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Voici les années de la vie d'Ismaël : cent trente-sept ans. Il rendit l'esprit et mourut, et il fut recueilli auprès de son peuple. ");
INSERT INTO frasbl_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Ils habitèrent depuis Havila jusqu'à Shur, qui est en face de l'Égypte, en allant vers l'Assyrie. Il habitait en face de tous ses parents. ");
INSERT INTO frasbl_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Voici l'histoire des générations d'Isaac, fils d'Abraham. Abraham devint le père d'Isaac. ");
INSERT INTO frasbl_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isaac avait quarante ans quand il prit pour femme Rebecca, fille de Bethuel, l'Araméen de Paddan Aram, sœur de Laban l'Araméen. ");
INSERT INTO frasbl_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Isaac implora Yahvé pour sa femme, car elle était stérile. Il implora Yahvé, et Rebecca, sa femme, devint enceinte. ");
INSERT INTO frasbl_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Les enfants luttaient ensemble dans son sein. Elle dit : « Si c'est ainsi, pourquoi est-ce que je vis ? » Elle alla consulter l'Éternel. ");
INSERT INTO frasbl_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","L'Éternel lui répondit, « Deux nations sont dans ton sein. Deux peuples seront séparés de votre corps. L'un des peuples sera plus fort que les autres. L'aîné servira le cadet. » ");
INSERT INTO frasbl_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Lorsque les jours où elle devait accoucher furent accomplis, voici qu'il y avait des jumeaux dans son sein. ");
INSERT INTO frasbl_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Le premier sortit tout rouge, comme un vêtement de poil. On lui donna le nom d'Ésaü. ");
INSERT INTO frasbl_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Après cela, son frère sortit, et sa main saisit le talon d'Ésaü. On l'appela Jacob. Isaac avait soixante ans lorsqu'elle les mit au monde. ");
INSERT INTO frasbl_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Les garçons grandirent. Ésaü était un chasseur habile, un homme des champs. Jacob était un homme tranquille, qui vivait sous la tente. ");
INSERT INTO frasbl_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isaac aimait Ésaü, car il mangeait son gibier. Rébecca aimait Jacob. ");
INSERT INTO frasbl_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Jacob faisait bouillir un ragoût. Ésaü revint des champs, et il était affamé. ");
INSERT INTO frasbl_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Ésaü dit à Jacob : « Donne-moi un peu de ce ragoût rouge, car je suis affamé. » C'est pourquoi on l'appela Edom. ");
INSERT INTO frasbl_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Jacob a dit : « Vends-moi d'abord ton droit d'aînesse. » ");
INSERT INTO frasbl_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Ésaü dit : « Voici, je vais mourir. A quoi me servira le droit d'aînesse ? » ");
INSERT INTO frasbl_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Jacob a dit : « Jure-le-moi d'abord. » Il lui a juré. Il a vendu son droit d'aînesse à Jacob. ");
INSERT INTO frasbl_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Jacob donna à Ésaü du pain et du ragoût de lentilles. Il mangea et but, se leva et s'en alla. Ésaü méprisa donc son droit d'aînesse. ");
INSERT INTO frasbl_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Il y eut une famine dans le pays, qui s'ajouta à la première famine qui eut lieu du temps d'Abraham. Isaac alla chez Abimélec, roi des Philistins, à Guérar. ");
INSERT INTO frasbl_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Yahvé lui apparut et lui dit : « Ne descends pas en Égypte. Habite dans le pays dont je te parlerai. ");
INSERT INTO frasbl_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Habite dans ce pays, et je serai avec toi, et je te bénirai. Car je te donnerai, à toi et à ta postérité, tous ces pays, et j'accomplirai le serment que j'ai fait à Abraham, ton père. ");
INSERT INTO frasbl_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Je multiplierai ta descendance comme les étoiles du ciel, et je donnerai tous ces pays à ta descendance. En ta descendance seront bénies toutes les nations de la terre, ");
INSERT INTO frasbl_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","parce qu'Abraham a obéi à ma voix, et qu'il a gardé mes exigences, mes commandements, mes statuts et mes lois. » ");
INSERT INTO frasbl_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Isaac habitait à Guérar. ");
INSERT INTO frasbl_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Les gens du lieu l'interrogèrent sur sa femme. Il répondit : « C'est ma sœur », car il avait peur de dire : « Ma femme », de peur, pensait-il, que les gens du lieu ne me tuent pour Rebecca, car elle est belle à regarder. » ");
INSERT INTO frasbl_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Comme il était là depuis longtemps, Abimélec, roi des Philistins, regarda par une fenêtre et vit, et voici, Isaac caressait Rebecca, sa femme. ");
INSERT INTO frasbl_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Abimélec appela Isaac et dit : « Voici, elle est bien ta femme. Pourquoi as-tu dit : « C'est ma sœur » ? » Isaac lui dit : « Parce que j'ai dit : « De peur que je ne meure à cause d'elle ». ");
INSERT INTO frasbl_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abimélec dit : « Qu'est-ce que tu nous as fait ? L'un des gens du peuple aurait pu facilement coucher avec ta femme, et tu nous aurais rendus coupables ! ». ");
INSERT INTO frasbl_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Abimélec donna un ordre à tout le peuple, en disant : « Celui qui touchera cet homme ou sa femme sera certainement mis à mort. » ");
INSERT INTO frasbl_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Isaac sema dans ce pays, et il récolta la même année cent fois ce qu'il avait planté. L'Éternel le bénit. ");
INSERT INTO frasbl_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","L'homme devint grand, et il grandit de plus en plus jusqu'à devenir très grand. ");
INSERT INTO frasbl_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Il possédait des troupeaux, des troupeaux de bétail et une grande maison. Les Philistins l'enviaient. ");
INSERT INTO frasbl_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Or, tous les puits que les serviteurs de son père avaient creusés du temps d'Abraham, son père, les Philistins les avaient bouchés et remplis de terre. ");
INSERT INTO frasbl_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Abimélec dit à Isaac : « Va-t'en loin de nous, car tu es beaucoup plus puissant que nous. » ");
INSERT INTO frasbl_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Isaac partit de là, campa dans la vallée de Gerar et y demeura. ");
INSERT INTO frasbl_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Isaac creusa de nouveau les puits d'eau qu'on avait creusés du temps d'Abraham, son père, car les Philistins les avaient arrêtés après la mort d'Abraham. Il leur donna des noms semblables à ceux par lesquels son père les avait appelés. ");
INSERT INTO frasbl_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Les serviteurs d'Isaac creusèrent dans la vallée et y trouvèrent un puits d'eau vive. ");
INSERT INTO frasbl_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Les bergers de Gerar discutèrent avec les bergers d'Isaac, en disant : « L'eau est à nous. » Isaac donna donc au puits le nom d'Esek, parce qu'ils se disputaient avec lui. ");
INSERT INTO frasbl_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Ils creusèrent un autre puits, et ils se disputèrent aussi à son sujet. Il l'appela donc Sitna. ");
INSERT INTO frasbl_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Il quitta ce lieu, et creusa un autre puits. Ils ne se disputèrent pas pour celui-là. Il l'appela donc Rehoboth. Il dit : « Car maintenant Yahvé nous a fait une place, et nous serons féconds dans le pays. » ");
INSERT INTO frasbl_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","De là, il monta à Beer Schéba. ");
INSERT INTO frasbl_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Yahvé lui apparut la même nuit, et dit : « Je suis le Dieu d'Abraham, ton père. Ne crains pas, car je suis avec toi, je te bénirai et je multiplierai ta descendance à cause de mon serviteur Abraham. » ");
INSERT INTO frasbl_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Il y bâtit un autel, invoqua le nom de Yahvé et y dressa sa tente. Les serviteurs d'Isaac y creusèrent un puits. ");
INSERT INTO frasbl_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Alors Abimélec vint à lui de Guérar, avec Ahuzzath, son ami, et Phicol, le chef de son armée. ");
INSERT INTO frasbl_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Isaac leur dit : « Pourquoi êtes-vous venus vers moi, puisque vous me haïssez et que vous m'avez chassé de chez vous ? ». ");
INSERT INTO frasbl_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Ils dirent : « Nous avons vu clairement que Yahvé était avec toi. Nous avons dit : « Qu'il y ait maintenant un serment entre nous, même entre nous et toi, et faisons alliance avec toi, ");
INSERT INTO frasbl_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","que tu ne nous fasses aucun mal, comme nous ne t'avons pas touché, et comme nous ne t'avons fait que du bien, et que nous t'avons renvoyé en paix. Vous êtes maintenant les bénis de Yahvé. » ");
INSERT INTO frasbl_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Il leur fit un festin, et ils mangèrent et burent. ");
INSERT INTO frasbl_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Ils se levèrent un peu plus tard dans la matinée et se jurèrent l'un à l'autre. Isaac les renvoya, et ils s'éloignèrent de lui en paix. ");
INSERT INTO frasbl_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Le même jour, les serviteurs d'Isaac vinrent lui parler du puits qu'ils avaient creusé, et lui dirent : « Nous avons trouvé de l'eau. » ");
INSERT INTO frasbl_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Il l'appela « Shibah ». C'est pourquoi le nom de la ville est encore aujourd'hui « Beersheba ». ");
INSERT INTO frasbl_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Lorsque Ésaü eut quarante ans, il prit pour femme Judith, fille de Beeri, le Hittite, et Basemath, fille d'Élon, le Hittite. ");
INSERT INTO frasbl_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Elles affligèrent l'esprit d'Isaac et de Rebecca. ");
INSERT INTO frasbl_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Lorsqu'Isaac fut vieux, et que ses yeux s'affaiblirent au point de ne plus voir, il appela Ésaü, son fils aîné, et lui dit : « Mon fils ? » Il lui dit : « Me voici. » ");
INSERT INTO frasbl_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Il dit : « Voici, je suis vieux. Je ne connais pas le jour de ma mort. ");
INSERT INTO frasbl_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Maintenant, prends tes armes, ton carquois et ton arc, et sors dans les champs, et va me chercher du gibier. ");
INSERT INTO frasbl_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Fais-moi un mets savoureux, tel que je l'aime, et apporte-le moi, afin que je mange et que mon âme te bénisse avant de mourir. » ");
INSERT INTO frasbl_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Rébecca a entendu quand Isaac a parlé à Ésaü, son fils. Ésaü alla dans les champs pour chasser le gibier et l'apporter. ");
INSERT INTO frasbl_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebecca parla à Jacob, son fils, et dit : Voici, j'ai entendu ton père parler à Ésaü, ton frère, et lui dire : ");
INSERT INTO frasbl_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Apporte-moi du gibier et prépare-moi un mets savoureux, que je mangerai, et je te bénirai devant Yahvé avant ma mort. ");
INSERT INTO frasbl_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Maintenant, mon fils, obéis à ma voix, selon ce que je te commande. ");
INSERT INTO frasbl_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Va maintenant au troupeau et prends-moi deux bons chevreaux. J'en ferai un mets savoureux pour ton père, tel qu'il l'aime. ");
INSERT INTO frasbl_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Tu les apporteras à ton père, pour qu'il les mange, afin qu'il te bénisse avant sa mort. » ");
INSERT INTO frasbl_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Jacob dit à Rebecca, sa mère : « Voici, Ésaü, mon frère, est un homme poilu, et moi, je suis un homme lisse. ");
INSERT INTO frasbl_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Et si mon père me touche ? Je lui apparaîtrai comme un fourbe, et j'attirerais sur moi une malédiction et non une bénédiction. » ");
INSERT INTO frasbl_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Sa mère lui dit : « Que ta malédiction soit sur moi, mon fils. Obéis seulement à ma voix, et va les chercher pour moi. » ");
INSERT INTO frasbl_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Il alla les chercher, et les apporta à sa mère. Sa mère prépara des mets savoureux, tels que les aimait son père. ");
INSERT INTO frasbl_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Rébecca prit les beaux habits d'Ésaü, son fils aîné, qui étaient avec elle dans la maison, et les mit sur Jacob, son fils cadet. ");
INSERT INTO frasbl_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Elle mit les peaux des chevreaux sur ses mains et sur la partie lisse de son cou. ");
INSERT INTO frasbl_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Elle remit entre les mains de son fils Jacob les mets savoureux et le pain qu'elle avait préparés. ");
INSERT INTO frasbl_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Il s'approcha de son père, et dit : « Mon père ? » Il a dit : « Me voici. Qui es-tu, mon fils ? » ");
INSERT INTO frasbl_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Jacob dit à son père : « Je suis Ésaü, ton premier-né. J'ai fait ce que tu m'as demandé de faire. Lève-toi, assieds-toi et mange de mon gibier, afin que ton âme me bénisse. » ");
INSERT INTO frasbl_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Isaac dit à son fils : « Comment se fait-il que tu l'aies trouvé si vite, mon fils ? ». Il a dit : « Parce que Yahvé ton Dieu m'a donné le succès. » ");
INSERT INTO frasbl_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Isaac dit à Jacob : « Approche, je t'en prie, afin que je puisse te sentir, mon fils, si tu es vraiment mon fils Ésaü ou non. » ");
INSERT INTO frasbl_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Jacob s'approcha d'Isaac, son père. Il le toucha et dit : « La voix est celle de Jacob, mais les mains sont celles d'Ésaü. » ");
INSERT INTO frasbl_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Il ne le reconnut pas, car ses mains étaient velues, comme celles de son frère Ésaü. Alors il le bénit. ");
INSERT INTO frasbl_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Il dit : « Es-tu vraiment mon fils Ésaü ? » Il a dit : « Je le suis. » ");
INSERT INTO frasbl_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Il dit : « Approche-le de moi, et je mangerai du gibier de mon fils, afin que mon âme te bénisse. » Il l'a fait venir près de lui, et il a mangé. Il lui apporta du vin, et il but. ");
INSERT INTO frasbl_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Son père Isaac lui dit : « Approche-toi maintenant, et embrasse-moi, mon fils. » ");
INSERT INTO frasbl_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Il s`approcha, et il le baisa. Il sentit l'odeur de son vêtement, et il le bénit, en disant, « Voici l'odeur de mon fils est comme l'odeur d'un champ que Yahvé a béni. ");
INSERT INTO frasbl_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Dieu vous donne de la rosée du ciel, de la graisse de la terre, et du grain en abondance et du vin nouveau. ");
INSERT INTO frasbl_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Laisse les peuples te servir, et les nations se prosternent devant toi. Sois le seigneur de tes frères. Que les fils de ta mère se prosternent devant toi. Maudit soit quiconque vous maudit. Bénis soient tous ceux qui te bénissent. » ");
INSERT INTO frasbl_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Dès qu'Isaac eut fini de bénir Jacob, et que celui-ci eut quitté la présence d'Isaac, son père, Ésaü, son frère, revint de la chasse. ");
INSERT INTO frasbl_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Il prépara lui aussi un mets savoureux, qu'il apporta à son père. Il dit à son père : « Que mon père se lève et mange du gibier de son fils, afin que ton âme me bénisse. » ");
INSERT INTO frasbl_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Isaac, son père, lui dit : « Qui es-tu ? » Il a dit : « Je suis ton fils, ton premier-né, Ésaü. » ");
INSERT INTO frasbl_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Isaac trembla violemment et dit : « Qui donc est celui qui a pris du gibier et me l'a apporté, et j'ai tout mangé avant que tu ne viennes, et je l'ai béni ? Oui, il sera béni. » ");
INSERT INTO frasbl_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Lorsque Ésaü entendit les paroles de son père, il poussa un cri extrêmement grand et amer, et dit à son père : « Bénis-moi, moi aussi, mon père. » ");
INSERT INTO frasbl_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Il dit : « Ton frère est venu avec ruse, et il a enlevé ta bénédiction. » ");
INSERT INTO frasbl_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Il dit : « N'est-ce pas à juste titre qu'il s'appelle Jacob ? Car il m'a supplanté ces deux fois. Il m'a enlevé mon droit d'aînesse. Et maintenant, il m'a enlevé ma bénédiction. » Il dit : « N'as-tu pas réservé une bénédiction pour moi ? » ");
INSERT INTO frasbl_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isaac répondit à Ésaü : « Voici, j'ai fait de lui ton seigneur, et je lui ai donné tous ses frères comme serviteurs. Je l'ai nourri de blé et de vin nouveau. Que vais-je donc faire pour toi, mon fils ? » ");
INSERT INTO frasbl_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Ésaü dit à son père : « N'as-tu qu'une seule bénédiction, mon père ? Bénis-moi, moi aussi, mon père. » Ésaü éleva la voix et pleura. ");
INSERT INTO frasbl_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Isaac, son père, lui répondit, « Voici que ta demeure sera de la graisse de la terre, et de la rosée du ciel d'en haut. ");
INSERT INTO frasbl_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Tu vivras de ton épée, et tu serviras ton frère. Cela arrivera, quand vous vous échapperez, que tu secoueras son joug de ton cou. » ");
INSERT INTO frasbl_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Ésaü haïssait Jacob à cause de la bénédiction dont son père l'avait gratifié. Ésaü disait dans son cœur : « Les jours de deuil pour mon père sont proches. Alors je tuerai mon frère Jacob. » ");
INSERT INTO frasbl_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Les paroles d'Ésaü, son fils aîné, furent rapportées à Rébecca. Elle envoya appeler Jacob, son fils cadet, et lui dit : « Voici que ton frère Ésaü se console à ton sujet en projetant de te tuer. ");
INSERT INTO frasbl_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Maintenant, mon fils, obéis à ma voix. Lève-toi, fuis chez Laban, mon frère, à Haran. ");
INSERT INTO frasbl_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Reste avec lui quelques jours, jusqu'à ce que la fureur de ton frère se calme - ");
INSERT INTO frasbl_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","jusqu'à ce que la colère de ton frère se détourne de toi, et qu'il oublie ce que tu lui as fait. Alors j'enverrai quelqu'un te chercher. Pourquoi serais-je privé de vous deux en un seul jour ? » ");
INSERT INTO frasbl_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Rebecca dit à Isaac : « Je suis fatiguée de ma vie à cause des filles de Heth. Si Jacob prend une femme parmi les filles de Heth, comme celles-ci, parmi les filles du pays, à quoi me servira ma vie ? » ");
INSERT INTO frasbl_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Isaac appela Jacob, le bénit et lui donna cet ordre : « Tu ne prendras pas de femme parmi les filles de Canaan. ");
INSERT INTO frasbl_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Lève-toi, va à Paddan Aram, dans la maison de Bethuel, le père de ta mère. Tu prendras là une femme parmi les filles de Laban, le frère de ta mère. ");
INSERT INTO frasbl_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Que le Dieu tout-puissant te bénisse, qu'il te rende fécond et te multiplie, afin que tu sois une multitude de peuples, ");
INSERT INTO frasbl_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","et qu'il te donne la bénédiction d'Abraham, à toi et à ta postérité avec toi, afin que tu hérites du pays où tu voyages, que Dieu a donné à Abraham. » ");
INSERT INTO frasbl_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Isaac renvoya Jacob. Il se rendit à Paddan Aram chez Laban, fils de Béthuel le Syrien, frère de Rébecca, la mère de Jacob et d'Ésaü. ");
INSERT INTO frasbl_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Ésaü vit qu'Isaac avait béni Jacob et l'avait envoyé à Paddan Aram, pour lui prendre une femme de là-bas, et qu'en le bénissant il lui avait donné cet ordre : « Tu ne prendras pas de femme parmi les filles de Canaan » ; ");
INSERT INTO frasbl_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","et que Jacob avait obéi à son père et à sa mère, et était parti pour Paddan Aram. ");
INSERT INTO frasbl_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Ésaü vit que les filles de Canaan ne plaisaient pas à Isaac, son père. ");
INSERT INTO frasbl_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Alors Ésaü alla vers Ismaël, et prit, en plus des femmes qu'il avait, Mahalath, fille d'Ismaël, fils d'Abraham, sœur de Nebaioth, pour être sa femme. ");
INSERT INTO frasbl_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Jacob partit de Beer Schéba, et se dirigea vers Haran. ");
INSERT INTO frasbl_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Il arriva à un certain endroit, où il passa la nuit, car le soleil était couché. Il prit une des pierres du lieu, la mit sous sa tête, et se coucha dans ce lieu pour dormir. ");
INSERT INTO frasbl_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Il rêva et vit un escalier placé sur la terre, et dont le sommet atteignait le ciel. Et voici, les anges de Dieu y montaient et y descendaient. ");
INSERT INTO frasbl_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Et voici, Yahvé se tenait au-dessus et disait : « Je suis Yahvé, le Dieu d'Abraham, ton père, et le Dieu d'Isaac. Je donnerai le pays sur lequel tu es couché, à toi et à ta postérité. ");
INSERT INTO frasbl_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Ta descendance sera comme la poussière de la terre, et tu te répandras à l'ouest et à l'est, au nord et au sud. En toi et en ta descendance, toutes les familles de la terre seront bénies. ");
INSERT INTO frasbl_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Voici, je suis avec toi, je te garderai partout où tu iras, et je te ramènerai dans ce pays. Car je ne te quitterai pas avant d'avoir accompli ce dont je t'ai parlé. » ");
INSERT INTO frasbl_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Jacob se réveilla de son sommeil, et il dit : « Certainement, Yahvé est dans ce lieu, et je ne le savais pas. » ");
INSERT INTO frasbl_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Il eut peur et dit : « Comme ce lieu est impressionnant ! Ce n'est autre que la maison de Dieu, et c'est la porte du ciel. » ");
INSERT INTO frasbl_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Jacob se leva de bon matin, prit la pierre qu'il avait mise sous sa tête, la dressa pour servir de colonne, et versa de l'huile sur son sommet. ");
INSERT INTO frasbl_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Il appela le nom de ce lieu Béthel, mais le nom de la ville était d'abord Luz. ");
INSERT INTO frasbl_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Jacob fit un vœu, en disant : Si Dieu est avec moi, s'il me garde dans le chemin que je vais suivre, s'il me donne du pain à manger et des vêtements à revêtir, ");
INSERT INTO frasbl_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","si je reviens en paix dans la maison de mon père, et si Yahvé est mon Dieu, ");
INSERT INTO frasbl_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","cette pierre, que j'ai dressée comme colonne, sera la maison de Dieu. De tout ce que tu me donneras, je te donnerai le dixième. » ");
INSERT INTO frasbl_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Jacob partit, et il arriva au pays des fils de l'Orient. ");
INSERT INTO frasbl_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Il regarda et vit un puits dans un champ, et il vit trois troupeaux de moutons couchés près de ce puits. Car c'est de ce puits qu'on abreuvait les troupeaux. La pierre sur l'embouchure du puits était grande. ");
INSERT INTO frasbl_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Là, tous les troupeaux étaient rassemblés. Ils roulèrent la pierre de l'ouverture du puits, abreuvèrent les brebis, et remirent la pierre à sa place sur l'ouverture du puits. ");
INSERT INTO frasbl_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Jacob leur dit : « Mes parents, d'où venez-vous ? » Ils ont dit : « Nous sommes de Haran. » ");
INSERT INTO frasbl_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Il leur dit : « Connaissez-vous Laban, fils de Nachor ? » Ils ont dit : « On le connaît. » ");
INSERT INTO frasbl_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Il leur dit : « Est-ce qu'il se porte bien ? » Ils ont dit : « C'est bien. Regarde, Rachel, sa fille, vient avec les brebis. » ");
INSERT INTO frasbl_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Il dit : « Voici, c'est encore le milieu du jour, ce n'est pas le moment de rassembler le bétail. Abreuve les brebis, et va les nourrir. » ");
INSERT INTO frasbl_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Ils dirent : « Nous ne pouvons pas, jusqu'à ce que tous les troupeaux soient rassemblés, et qu'ils roulent la pierre de la bouche du puits. Alors nous abreuverons les brebis. » ");
INSERT INTO frasbl_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Comme il parlait encore avec eux, Rachel arriva avec les brebis de son père, car elle les gardait. ");
INSERT INTO frasbl_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Lorsque Jacob vit Rachel, fille de Laban, frère de sa mère, et les brebis de Laban, frère de sa mère, il s'approcha, roula la pierre de l'ouverture du puits, et abreuva le troupeau de Laban, frère de sa mère. ");
INSERT INTO frasbl_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Jacob embrassa Rachel, éleva la voix et pleura. ");
INSERT INTO frasbl_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Jacob dit à Rachel qu'il était parent de son père, et qu'il était le fils de Rebecca. Elle courut le dire à son père. ");
INSERT INTO frasbl_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Lorsque Laban apprit la nouvelle de Jacob, le fils de sa sœur, il courut à la rencontre de Jacob, l'embrassa, le baisa et le fit venir dans sa maison. Jacob raconta à Laban toutes ces choses. ");
INSERT INTO frasbl_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Laban lui dit : « Certainement, tu es mon os et ma chair. » Jacob resta un mois avec lui. ");
INSERT INTO frasbl_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Laban dit à Jacob : « Puisque tu es mon parent, dois-tu me servir pour rien ? Dis-moi, quel sera ton salaire ? » ");
INSERT INTO frasbl_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Laban avait deux filles. Le nom de l'aînée était Léa, et le nom de la cadette était Rachel. ");
INSERT INTO frasbl_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Léa avait les yeux faibles, mais Rachel était belle de forme et séduisante. ");
INSERT INTO frasbl_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Jacob aimait Rachel. Il dit : « Je te servirai sept ans pour Rachel, ta plus jeune fille. » ");
INSERT INTO frasbl_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laban dit : « Il vaut mieux que je te la donne, que je la donne à un autre homme. Reste avec moi. » ");
INSERT INTO frasbl_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Jacob a servi sept ans pour Rachel. Elles ne lui ont paru que quelques jours, à cause de l'amour qu'il lui portait. ");
INSERT INTO frasbl_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Jacob dit à Laban : « Donne-moi ma femme, car mes jours sont accomplis, et je pourrai aller vers elle. » ");
INSERT INTO frasbl_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Laban rassembla tous les hommes du lieu, et fit un festin. ");
INSERT INTO frasbl_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Le soir, il prit Léa, sa fille, et l'amena à Jacob. Il entra chez elle. ");
INSERT INTO frasbl_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Laban donna pour servante à Léa, sa fille, Zilpa, sa servante. ");
INSERT INTO frasbl_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Le matin, voici que c'était Léa. Elle dit à Laban : « Qu'est-ce que tu m'as fait ? N'ai-je pas servi avec toi pour Rachel ? Pourquoi donc m'as-tu trompé ? » ");
INSERT INTO frasbl_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laban répondit : « Cela ne se fait pas chez nous, de donner le plus jeune avant le premier-né. ");
INSERT INTO frasbl_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Accomplis la semaine de celui-ci, et nous te donnerons aussi l'autre pour le service que tu feras chez moi pendant sept autres années. » ");
INSERT INTO frasbl_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Jacob fit ainsi, et accomplit sa semaine. Il lui donna pour femme sa fille Rachel. ");
INSERT INTO frasbl_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Laban donna Bilha, sa servante, à sa fille Rachel, pour qu'elle la serve. ");
INSERT INTO frasbl_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Il alla aussi vers Rachel, qu'il aima plus que Léa, et il resta sept ans de plus à son service. ");
INSERT INTO frasbl_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Yahvé vit que Léa était haïe, et il lui ouvrit les entrailles, mais Rachel était stérile. ");
INSERT INTO frasbl_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Léa devint enceinte, et enfanta un fils, qu'elle appela Ruben. Car elle disait : « Parce que Yahvé a regardé mon affliction, maintenant mon mari m'aimera. » ");
INSERT INTO frasbl_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Elle conçut de nouveau et enfanta un fils, et elle dit : « Parce que Yahvé a entendu que je suis haïe, il m'a aussi donné ce fils. » Elle lui donna le nom de Siméon. ");
INSERT INTO frasbl_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Elle conçut de nouveau, et enfanta un fils. Elle dit : « Cette fois, mon mari s'attachera à moi, car je lui ai enfanté trois fils. » C'est pourquoi on lui donna le nom de Lévi. ");
INSERT INTO frasbl_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Elle conçut de nouveau, et enfanta un fils. Elle dit : « Cette fois, je louerai Yahvé. » Elle lui donna donc le nom de Juda. Puis elle cessa d'enfanter. ");
INSERT INTO frasbl_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Lorsque Rachel vit qu'elle ne portait pas d'enfants à Jacob, elle envia sa sœur. Elle dit à Jacob : « Donne-moi des enfants, sinon je vais mourir. » ");
INSERT INTO frasbl_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","La colère de Jacob s'enflamma contre Rachel, et il dit : « Suis-je à la place de Dieu, qui t'a refusé le fruit de tes entrailles ? » ");
INSERT INTO frasbl_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Elle dit : « Voici ma servante Bilha. Va vers elle, afin qu'elle enfante sur mes genoux, et que je puisse aussi avoir des enfants par elle. » ");
INSERT INTO frasbl_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Elle lui donna pour femme Bilha, sa servante, et Jacob entra chez elle. ");
INSERT INTO frasbl_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bilha devint enceinte, et donna un fils à Jacob. ");
INSERT INTO frasbl_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Rachel dit : « Dieu m'a jugée, il a aussi entendu ma voix, et il m'a donné un fils. » Et elle lui donna le nom de Dan. ");
INSERT INTO frasbl_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Bilha, servante de Rachel, devint encore enceinte, et enfanta un second fils à Jacob. ");
INSERT INTO frasbl_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Rachel dit : « J'ai lutté avec ma sœur avec force combats, et j'ai vaincu. » Elle lui donna le nom de Nephthali. ");
INSERT INTO frasbl_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Lorsque Léa vit qu'elle avait fini d'enfanter, elle prit Zilpa, sa servante, et la donna pour femme à Jacob. ");
INSERT INTO frasbl_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Zilpa, servante de Léa, enfanta un fils à Jacob. ");
INSERT INTO frasbl_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Léa dit : « Quelle chance ! » Elle lui donna le nom de Gad. ");
INSERT INTO frasbl_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Zilpa, servante de Léa, enfanta un second fils à Jacob. ");
INSERT INTO frasbl_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Léa dit : « Je suis heureuse, car les filles me diront heureuse. » Elle lui donna le nom d'Asher. ");
INSERT INTO frasbl_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Ruben partit les jours de la moisson du blé, trouva des mandragores dans les champs et les apporta à Léa, sa mère. Rachel dit à Léa : « Donne-moi des mandragores de ton fils. » ");
INSERT INTO frasbl_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Léa lui dit : « Est-ce une petite affaire que tu aies pris mon mari ? Veux-tu aussi enlever les mandragores de mon fils ? » Rachel a dit : « Il couchera donc avec toi cette nuit pour les mandragores de ton fils. » ");
INSERT INTO frasbl_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Jacob revint des champs le soir, et Léa sortit à sa rencontre et dit : « Il faut que tu entres chez moi, car je t'ai sûrement engagé avec les mandragores de mon fils. » Il coucha avec elle cette nuit-là. ");
INSERT INTO frasbl_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Dieu écouta Léa ; elle conçut, et enfanta à Jacob un cinquième fils. ");
INSERT INTO frasbl_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Léa dit : « Dieu m'a donné mon salaire, parce que j'ai donné mon serviteur à mon mari. » Elle lui donna le nom d'Issachar. ");
INSERT INTO frasbl_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Léa conçut de nouveau, et enfanta un sixième fils à Jacob. ");
INSERT INTO frasbl_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Léa dit : « Dieu m'a donné une bonne dot. Maintenant, mon mari vivra avec moi, car je lui ai donné six fils ». Elle lui donna le nom de Zabulon. ");
INSERT INTO frasbl_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Ensuite, elle enfanta une fille, qu'elle appela Dina. ");
INSERT INTO frasbl_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Dieu se souvint de Rachel, il l'écouta, et il lui ouvrit les entrailles. ");
INSERT INTO frasbl_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Elle conçut, enfanta un fils, et dit : « Dieu a ôté mon opprobre. » ");
INSERT INTO frasbl_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Elle lui donna le nom de Joseph, en disant : « Que Yahvé me donne un autre fils ! » ");
INSERT INTO frasbl_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Lorsque Rachel eut enfanté Joseph, Jacob dit à Laban : « Renvoie-moi, afin que j'aille dans mon lieu et dans mon pays. ");
INSERT INTO frasbl_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Donne-moi mes femmes et mes enfants pour lesquels je t'ai servi, et laisse-moi partir ; car tu connais le service que je t'ai rendu. » ");
INSERT INTO frasbl_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Laban lui dit : « Si maintenant j'ai trouvé grâce à tes yeux, reste ici, car je devine que Yahvé m'a béni à cause de toi. » ");
INSERT INTO frasbl_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Il répondit : « Fixe-moi ton salaire, et je le donnerai. » ");
INSERT INTO frasbl_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Jacob lui dit : « Tu sais comment je t'ai servi, et comment ton bétail s'est comporté avec moi. ");
INSERT INTO frasbl_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Car le peu que tu avais avant mon arrivée s'est transformé en une multitude. Yahvé vous a bénis partout où je me suis rendu. Quand donc pourvoirai-je aussi à ma propre maison ? » ");
INSERT INTO frasbl_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Laban dit : « Qu'est-ce que je te donnerai ? » Jacob dit : « Tu ne me donneras rien. Si tu fais cette chose pour moi, je ferai encore paître ton troupeau et je le garderai. ");
INSERT INTO frasbl_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Je passerai aujourd'hui par tout ton troupeau et j'enlèverai tout ce qui est moucheté et tacheté, tout ce qui est noir parmi les moutons, et ce qui est moucheté et tacheté parmi les chèvres. Ce sera mon salaire. ");
INSERT INTO frasbl_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Ainsi, ma justice répondra pour moi dans l'avenir, lorsque vous viendrez au sujet de mon salaire qui est devant vous. Tout ce qui n'est pas moucheté et tacheté parmi les chèvres, et noir parmi les brebis, qui pourrait être avec moi, sera considéré comme volé. » ");
INSERT INTO frasbl_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Laban dit : « Voici, qu'il en soit fait selon ta parole. » ");
INSERT INTO frasbl_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Ce jour-là, il enleva les chèvres mâles rayées et tachetées, toutes les chèvres femelles mouchetées et tachetées, toutes celles qui avaient du blanc, et toutes celles qui étaient noires parmi les moutons, et il les remit entre les mains de ses fils. ");
INSERT INTO frasbl_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Il mit trois jours de voyage entre lui et Jacob, et Jacob fit paître le reste des troupeaux de Laban. ");
INSERT INTO frasbl_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Jacob prit pour lui des tiges de peuplier, d'amandier et de platane frais, il y pela des stries blanches et fit apparaître le blanc qui était dans les tiges. ");
INSERT INTO frasbl_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Il plaça les baguettes qu'il avait épluchées en face des troupeaux, dans les abreuvoirs où les troupeaux venaient boire. Elles devinrent enceintes quand elles vinrent boire. ");
INSERT INTO frasbl_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Les brebis conçurent devant les verges, et les brebis produisirent des animaux rayés, tachetés et mouchetés. ");
INSERT INTO frasbl_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Jacob sépara les agneaux et plaça les faces des troupeaux vers les rayés et tous les noirs du troupeau de Laban. Il mit ses propres troupeaux à part, et ne les mit pas dans le troupeau de Laban. ");
INSERT INTO frasbl_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Chaque fois que le plus fort du troupeau concevait, Jacob plaçait les baguettes devant les yeux du troupeau dans les abreuvoirs, afin qu'il conçoive parmi les baguettes ; ");
INSERT INTO frasbl_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","mais quand le troupeau était faible, il ne les mettait pas dedans. Les plus faibles étaient à Laban, et les plus fortes à Jacob. ");
INSERT INTO frasbl_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Cet homme devint très riche, et il eut de grands troupeaux, des servantes et des serviteurs, des chameaux et des ânes. ");
INSERT INTO frasbl_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Jacob entendit les paroles des fils de Laban, qui disaient : « Jacob a emporté tout ce qui appartenait à notre père. Il a obtenu toutes ces richesses avec ce qui appartenait à notre père. » ");
INSERT INTO frasbl_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Jacob vit l'expression du visage de Laban, et voici, elle n'était pas tournée vers lui comme auparavant. ");
INSERT INTO frasbl_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Yahvé dit à Jacob : « Retourne dans le pays de tes pères et dans ta famille, et je serai avec toi. » ");
INSERT INTO frasbl_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Jacob envoya appeler Rachel et Léa aux champs, vers son troupeau, ");
INSERT INTO frasbl_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","et leur dit : Je vois l'expression du visage de votre père, qui n'est pas envers moi comme auparavant ; mais le Dieu de mon père a été avec moi. ");
INSERT INTO frasbl_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Vous savez que j'ai servi votre père de toute ma force. ");
INSERT INTO frasbl_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Ton père m'a trompé et a changé dix fois mon salaire, mais Dieu n'a pas permis qu'il me fasse du mal. ");
INSERT INTO frasbl_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","S'il a dit : « Les tachetés seront ton salaire », tout le troupeau a porté des tachetés. S'il a dit : « Les rayés seront ton salaire », tout le troupeau a porté des rayés. ");
INSERT INTO frasbl_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","C'est ainsi que Dieu a pris le bétail de ton père et me l'a donné. ");
INSERT INTO frasbl_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Pendant la saison des amours, j'ai levé les yeux et j'ai regardé en songe : voici que les boucs qui sautaient sur le troupeau étaient rayés, tachetés et hérissés. ");
INSERT INTO frasbl_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","L'ange de Dieu me dit en songe : « Jacob », et je répondis : « Me voici ». ");
INSERT INTO frasbl_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Il dit : Lève les yeux, et voici, tous les boucs qui sautent sur le troupeau sont rayés, tachetés et marquetés ; car j'ai vu tout ce que Laban te fait. ");
INSERT INTO frasbl_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Je suis le Dieu de Béthel, où tu as oint une colonne, où tu m'as fait un vœu. Maintenant, lève-toi, sors de ce pays, et retourne dans le pays de ta naissance. » ");
INSERT INTO frasbl_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Rachel et Léa lui répondirent : « Y a-t-il encore pour nous une part ou un héritage dans la maison de notre père ? ");
INSERT INTO frasbl_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Ne sommes-nous pas considérées par lui comme des étrangères ? Car il nous a vendues, et il a aussi épuisé notre argent. ");
INSERT INTO frasbl_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Car toutes les richesses que Dieu a enlevées à notre père sont à nous et à nos enfants. Maintenant donc, tout ce que Dieu vous a dit, faites-le. » ");
INSERT INTO frasbl_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Alors Jacob se leva, fit monter ses fils et ses femmes sur les chameaux, ");
INSERT INTO frasbl_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","et il emmena tout son bétail et tous les biens qu'il avait rassemblés, y compris le bétail qu'il avait acquis à Paddan Aram, pour aller vers Isaac, son père, au pays de Canaan. ");
INSERT INTO frasbl_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Or Laban était allé tondre ses brebis ; et Rachel vola les théraphim qui appartenaient à son père. ");
INSERT INTO frasbl_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Jacob trompa Laban, l'Araméen, en ne lui disant pas qu'il s'enfuyait. ");
INSERT INTO frasbl_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Il s'enfuit donc avec tout ce qu'il avait. Il se leva, passa le fleuve et se dirigea vers la montagne de Galaad. ");
INSERT INTO frasbl_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Le troisième jour, Laban fut informé que Jacob s'était enfui. ");
INSERT INTO frasbl_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Il prit avec lui ses proches, et le poursuivit pendant sept jours de marche. Il l'atteignit dans la montagne de Galaad. ");
INSERT INTO frasbl_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Dieu apparut à Laban, l'Araméen, dans un songe nocturne, et lui dit : « Prends garde de ne pas parler à Jacob, ni en bien ni en mal. » ");
INSERT INTO frasbl_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Laban rattrapa Jacob. Jacob avait dressé sa tente dans la montagne, et Laban et sa famille campaient dans la montagne de Galaad. ");
INSERT INTO frasbl_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Laban dit à Jacob : « Qu'as-tu fait pour me tromper, et pour emmener mes filles comme des captives de l'épée ? ");
INSERT INTO frasbl_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Pourquoi t'es-tu enfui en cachette, et m'as-tu trompé, et ne m'as-tu rien dit, afin que je te renvoie avec de la joie et des chants, avec du tambourin et de la harpe ; ");
INSERT INTO frasbl_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","et ne m'as-tu pas permis d'embrasser mes fils et mes filles ? Maintenant, vous avez fait une folie. ");
INSERT INTO frasbl_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Il est au pouvoir de ma main de te faire du mal, mais le Dieu de ton père m'a parlé cette nuit, en disant : « Prends garde de ne pas parler à Jacob en bien ou en mal ». ");
INSERT INTO frasbl_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Maintenant, tu veux partir, parce que tu as eu un grand désir de la maison de ton père, mais pourquoi as-tu volé mes dieux ? » ");
INSERT INTO frasbl_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Jacob répondit à Laban : « Parce que j'ai eu peur, car j'ai dit : « De peur que tu ne m'enlèves tes filles par la force ». ");
INSERT INTO frasbl_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Toute personne avec laquelle tu trouveras tes dieux ne vivra pas. Devant nos parents, discerne ce qui t'appartient chez moi, et prends-le. » Car Jacob ne savait pas que Rachel les avait volées. ");
INSERT INTO frasbl_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Laban entra dans la tente de Jacob, dans la tente de Léa, et dans la tente des deux servantes ; mais il ne les trouva pas. Il sortit de la tente de Léa, et entra dans la tente de Rachel. ");
INSERT INTO frasbl_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Rachel avait pris les théraphim, les avait mis sur la selle du chameau et s'était assise dessus. Laban tâta toute la tente, mais ne les trouva pas. ");
INSERT INTO frasbl_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Elle dit à son père : « Que mon seigneur ne soit pas fâché que je ne puisse pas me lever devant toi, car j'ai mes règles. » Il chercha, mais ne trouva pas les théraphim. ");
INSERT INTO frasbl_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Jacob se mit en colère et discuta avec Laban. Jacob répondit à Laban : « Quelle est ma faute ? Quel est mon péché, pour que tu me poursuives avec ardeur ? ");
INSERT INTO frasbl_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Maintenant que tu as fouillé dans toutes mes affaires, qu'as-tu trouvé de toutes tes affaires de famille ? Mets-le ici devant ma famille et devant ta famille, afin qu'elles jugent entre nous deux. ");
INSERT INTO frasbl_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","« Voilà vingt ans que je suis avec vous. Tes brebis et tes chèvres n'ont pas mis bas, et je n'ai pas mangé les béliers de tes troupeaux. ");
INSERT INTO frasbl_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Ce qui a été déchiré des animaux, je ne te l'ai pas apporté. J'en ai supporté la perte. C'est de ma main que vous l'avez exigé, qu'il ait été volé de jour ou de nuit. ");
INSERT INTO frasbl_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Telle était ma situation : la sécheresse me consumait le jour, et la gelée la nuit ; le sommeil fuyait de mes yeux. ");
INSERT INTO frasbl_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Voilà vingt ans que je suis dans ta maison. Je t'ai servi quatorze ans pour tes deux filles, et six ans pour ton troupeau, et tu as changé dix fois mon salaire. ");
INSERT INTO frasbl_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Si le Dieu de mon père, le Dieu d'Abraham et d'Isaac, n'avait pas été avec moi, tu m'aurais renvoyé à vide. Dieu a vu mon malheur et le travail de mes mains, et il t'a repris cette nuit. » ");
INSERT INTO frasbl_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Laban répondit à Jacob : « Les filles sont mes filles, les enfants sont mes enfants, les troupeaux sont mes troupeaux, et tout ce que tu vois est à moi ! Que puis-je faire aujourd'hui à ces filles, ou aux enfants qu'elles ont enfantés ? ");
INSERT INTO frasbl_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Maintenant, viens, faisons une alliance, toi et moi. Que cela serve de témoignage entre moi et toi. » ");
INSERT INTO frasbl_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Jacob prit une pierre, et la dressa pour faire un pilier. ");
INSERT INTO frasbl_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Jacob dit à ses proches : « Ramassez des pierres. » Ils prirent des pierres, et firent un tas. Ils mangèrent là, près du tas. ");
INSERT INTO frasbl_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laban l'appela Jegar Sahadutha, mais Jacob l'appela Galeed. ");
INSERT INTO frasbl_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Laban dit : « Ce tas est un témoignage entre moi et toi aujourd'hui. » C'est pourquoi on l'appela Galéed ");
INSERT INTO frasbl_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","et Mitspa, car il dit : « L'Éternel veille entre moi et toi, quand nous sommes absents l'un de l'autre. ");
INSERT INTO frasbl_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Si tu affliges mes filles, ou si tu prends des femmes en plus de mes filles, aucun homme n'est avec nous ; voici, Dieu est témoin entre moi et toi. » ");
INSERT INTO frasbl_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Laban dit à Jacob : « Vois ce monceau et vois le pilier que j'ai mis entre moi et toi. ");
INSERT INTO frasbl_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Que ce monceau soit témoin, et que la colonne soit témoin, que je ne passerai pas ce monceau devant toi, et que tu ne passeras pas ce monceau et cette colonne devant moi, pour faire du mal. ");
INSERT INTO frasbl_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Le Dieu d'Abraham et le Dieu de Nachor, le Dieu de leur père, juge entre nous. » Alors Jacob jura par la crainte de son père, Isaac. ");
INSERT INTO frasbl_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Jacob offrit un sacrifice sur la montagne, et il appela ses proches à manger du pain. Ils mangèrent du pain et passèrent la nuit dans la montagne. ");
INSERT INTO frasbl_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","De bon matin, Laban se leva, embrassa ses fils et ses filles, et les bénit. Laban s'en alla et retourna à sa place. ");
INSERT INTO frasbl_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Jacob poursuivit son chemin, et les anges de Dieu vinrent à sa rencontre. ");
INSERT INTO frasbl_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Quand il les vit, Jacob dit : « C'est l'armée de Dieu. » Il donna à ce lieu le nom de Mahanaïm. ");
INSERT INTO frasbl_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Jacob envoya devant lui des messagers à Ésaü, son frère, au pays de Séir, dans le champ d'Édom. ");
INSERT INTO frasbl_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Il leur donna cet ordre : « Voici ce que vous direz à mon seigneur Ésaü : « Voici ce que dit ton serviteur Jacob. J'ai vécu comme un étranger chez Laban, et j'y suis resté jusqu'à présent. ");
INSERT INTO frasbl_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","J'ai du bétail, des ânes, des troupeaux, des serviteurs et des servantes. J'ai envoyé le dire à mon seigneur, afin que je trouve grâce à tes yeux. » ");
INSERT INTO frasbl_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Les messagers retournèrent auprès de Jacob, en disant : « Nous sommes allés voir ton frère Ésaü. Il vient à ta rencontre, et quatre cents hommes sont avec lui. » ");
INSERT INTO frasbl_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Alors Jacob eut une grande crainte et fut bouleversé. Il divisa en deux groupes les gens qui étaient avec lui, ainsi que les troupeaux, les bœufs et les chameaux. ");
INSERT INTO frasbl_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Il dit : « Si Ésaü vient vers la première troupe et la frappe, la troupe qui reste échappera. » ");
INSERT INTO frasbl_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Jacob dit : « Dieu de mon père Abraham et Dieu de mon père Isaac, Yahvé, qui m'a dit : Retourne dans ton pays et dans ta famille, et je te ferai du bien, ");
INSERT INTO frasbl_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","je ne suis pas digne de la moindre de toutes les bontés et de toute la vérité que tu as montrées à ton serviteur, car c'est avec mon seul bâton que j'ai traversé ce Jourdain, et maintenant je suis devenu deux compagnies. ");
INSERT INTO frasbl_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Délivre-moi de la main de mon frère, de la main d'Ésaü, car je le crains, de peur qu'il ne vienne me frapper, moi et les mères avec les enfants. ");
INSERT INTO frasbl_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Tu as dit : « Je te ferai du bien, et je rendrai ta postérité comme le sable de la mer, qu'on ne peut compter, tant il est nombreux. » ");
INSERT INTO frasbl_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Il resta là cette nuit-là, et prit dans ce qu'il avait avec lui un présent pour Ésaü, son frère : ");
INSERT INTO frasbl_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","deux cents chèvres et vingt boucs, deux cents brebis et vingt béliers, ");
INSERT INTO frasbl_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","trente chameaux de lait et leurs ânes, quarante vaches, dix taureaux, vingt ânesses et dix poulains. ");
INSERT INTO frasbl_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Il les remit entre les mains de ses serviteurs, chaque troupeau séparément, et dit à ses serviteurs : « Passez devant moi, et mettez un espace entre chaque troupeau. » ");
INSERT INTO frasbl_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Il donna cet ordre aux premiers : « Quand Ésaü, mon frère, viendra à ta rencontre et t'interrogera en disant : « De qui es-tu ? Où vas-tu ? A qui sont ces choses devant toi ? ");
INSERT INTO frasbl_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Tu répondras : « Elles sont à ton serviteur, Jacob. C'est un présent envoyé à mon seigneur Ésaü. Voici qu'il est aussi derrière nous ». ");
INSERT INTO frasbl_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Il donna aussi des ordres au second, au troisième et à tous ceux qui suivaient les troupeaux, en disant : « Voici comment vous parlerez à Ésaü, lorsque vous le trouverez. ");
INSERT INTO frasbl_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Vous direz : « Non seulement cela, mais voici que ton serviteur Jacob est derrière nous ». Car, dit-il, « je l'apaiserai avec le présent qui me précède, et après, je verrai son visage. Peut-être m'acceptera-t-il. » ");
INSERT INTO frasbl_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Et le présent passa devant lui, et il resta lui-même cette nuit-là dans le camp. ");
INSERT INTO frasbl_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Il se leva cette nuit-là, prit ses deux femmes, ses deux serviteurs et ses onze fils, et traversa le gué du Jabbok. ");
INSERT INTO frasbl_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Il les prit, leur fit traverser le torrent, et leur fit passer ce qui lui appartenait. ");
INSERT INTO frasbl_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Jacob resta seul, et il lutta là avec un homme jusqu'au point du jour. ");
INSERT INTO frasbl_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Comme il voyait qu'il ne l'emportait pas sur lui, l'homme toucha le creux de sa cuisse, et le creux de la cuisse de Jacob était tendu pendant qu'il luttait. ");
INSERT INTO frasbl_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","L'homme dit : « Laisse-moi partir, car le jour se lève. » Jacob a dit : « Je ne te laisserai pas partir si tu ne me bénis pas. » ");
INSERT INTO frasbl_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Il lui dit : « Quel est ton nom ? » Il a dit, « Jacob ». ");
INSERT INTO frasbl_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Il dit : « Ton nom ne sera plus Jacob, mais Israël ; car tu as combattu avec Dieu et avec les hommes, et tu as vaincu. » ");
INSERT INTO frasbl_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Jacob lui demanda : « Dis-moi ton nom, s'il te plaît. » Il a dit : « Pourquoi demandez-vous mon nom ? » Alors il l'a béni là. ");
INSERT INTO frasbl_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Jacob donna à ce lieu le nom de Peniel, car il dit : « J'ai vu Dieu face à face, et ma vie est sauve. » ");
INSERT INTO frasbl_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Le soleil se leva sur lui lorsqu'il passa à Peniel, et il boitait à cause de sa cuisse. ");
INSERT INTO frasbl_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","C'est pourquoi les enfants d'Israël ne mangent pas le tendon de la hanche, qui se trouve au creux de la cuisse, jusqu'à ce jour, car il a touché le creux de la cuisse de Jacob dans le tendon de la hanche. ");
INSERT INTO frasbl_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Jacob leva les yeux et regarda. Et voici, Ésaü arrivait, et avec lui quatre cents hommes. Il partagea les enfants entre Léa, Rachel et les deux serviteurs. ");
INSERT INTO frasbl_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Il plaça les serviteurs et leurs enfants en avant, Léa et ses enfants après, et Rachel et Joseph en arrière. ");
INSERT INTO frasbl_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Lui-même passa devant eux, et se prosterna sept fois à terre, jusqu'à ce qu'il s'approche de son frère. ");
INSERT INTO frasbl_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Ésaü courut à sa rencontre, l'embrassa, se jeta à son cou, le baisa, et ils pleurèrent. ");
INSERT INTO frasbl_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Il leva les yeux, et vit les femmes et les enfants ; il dit : « Qui sont ceux-ci avec toi ? » Il dit : « Les enfants que Dieu a gracieusement donnés à votre serviteur. » ");
INSERT INTO frasbl_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Alors les serviteurs s'approchèrent avec leurs enfants, et ils se prosternèrent. ");
INSERT INTO frasbl_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Léa et ses enfants s'approchèrent aussi, et se prosternèrent. Après eux, Joseph s'approcha avec Rachel, et ils se prosternèrent. ");
INSERT INTO frasbl_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Ésaü dit : « Que veux-tu dire par toute cette compagnie que j'ai rencontrée ? » Jacob a dit : « Pour trouver grâce aux yeux de mon seigneur. » ");
INSERT INTO frasbl_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Ésaü dit : « J'ai assez, mon frère ; que ce que tu as soit à toi. » ");
INSERT INTO frasbl_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Jacob dit : « Je t'en prie, non, si j'ai maintenant trouvé grâce à tes yeux, alors reçois mon présent de ma main, car j'ai vu ton visage, comme on voit le visage de Dieu, et tu as été satisfait de moi. ");
INSERT INTO frasbl_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Je te prie de prendre le présent que je t'ai apporté, parce que Dieu m'a fait grâce, et parce que j'en ai assez. » Il le pressa, et il le prit. ");
INSERT INTO frasbl_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Ésaü dit : « Prenons notre route, partons, et je te précéderai. » ");
INSERT INTO frasbl_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Jacob lui dit : « Mon seigneur sait que les enfants sont tendres, et que les troupeaux qui sont avec moi ont leurs petits, et que s'ils les surmènent un jour, tous les troupeaux mourront. ");
INSERT INTO frasbl_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Je vous prie de laisser mon seigneur passer devant son serviteur, et je continuerai doucement, au rythme du bétail qui est devant moi et au rythme des enfants, jusqu'à ce que j'arrive auprès de mon seigneur en Séir. » ");
INSERT INTO frasbl_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Ésaü dit : « Laisse-moi maintenant laisser avec toi quelques-uns des gens qui sont avec moi. » Il a dit : « Pourquoi ? Que je trouve grâce aux yeux de mon seigneur. » ");
INSERT INTO frasbl_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Ce jour-là, Ésaü s'en retourna en direction de Séir. ");
INSERT INTO frasbl_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Jacob se rendit à Succoth, se construisit une maison et fit des abris pour son bétail. C'est pourquoi le nom de ce lieu est appelé Succoth. ");
INSERT INTO frasbl_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Jacob arriva en paix à la ville de Sichem, qui est dans le pays de Canaan, lorsqu'il vint de Paddan Aram, et il campa devant la ville. ");
INSERT INTO frasbl_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Il acheta la parcelle de terrain où il avait étendu sa tente, de la main des fils de Hamor, père de Sichem, pour cent pièces d'argent. ");
INSERT INTO frasbl_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Il y dressa un autel, et l'appela El Elohe Israël. ");
INSERT INTO frasbl_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Dina, fille de Léa, qu'elle avait enfantée à Jacob, sortit pour voir les filles du pays. ");
INSERT INTO frasbl_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Sichem, fils de Hamor, le Hivvite, prince du pays, la vit. Il la prit, coucha avec elle, et l'humilia. ");
INSERT INTO frasbl_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Son âme s'attacha à Dina, fille de Jacob ; il aima la jeune fille, et lui parla avec bonté. ");
INSERT INTO frasbl_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Sichem parla à son père, Hamor, et dit : « Prends-moi cette jeune fille pour femme. » ");
INSERT INTO frasbl_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Or Jacob apprit qu'il avait souillé Dina, sa fille ; et ses fils étaient avec son bétail dans les champs. Jacob garda le silence jusqu'à leur arrivée. ");
INSERT INTO frasbl_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Hamor, père de Sichem, sortit vers Jacob pour lui parler. ");
INSERT INTO frasbl_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Les fils de Jacob arrivèrent des champs lorsqu'ils entendirent cela. Ils étaient affligés et très en colère, car il avait commis une folie en Israël en couchant avec la fille de Jacob, ce qui ne devait pas se faire. ");
INSERT INTO frasbl_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Hamor leur parla, et dit : « L'âme de mon fils Sichem a envie de ta fille. Je vous prie de la lui donner pour femme. ");
INSERT INTO frasbl_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Faites des mariages avec nous. Donnez-nous vos filles, et prenez nos filles pour vous. ");
INSERT INTO frasbl_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Vous habiterez avec nous, et le pays sera devant vous. Vous y vivrez, vous y ferez du commerce, et vous y acquerrez des biens. » ");
INSERT INTO frasbl_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Sichem dit à son père et à ses frères : « Laissez-moi trouver grâce à vos yeux, et je donnerai tout ce que vous me direz. ");
INSERT INTO frasbl_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Demande-moi une dot importante, et je te donnerai tout ce que tu me demanderas, mais donne-moi la jeune fille pour femme. » ");
INSERT INTO frasbl_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Les fils de Jacob répondirent à Sichem et à Hamor, son père, avec ruse lorsqu'ils parlaient, parce qu'il avait souillé Dina, leur sœur, ");
INSERT INTO frasbl_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","et ils leur dirent : « Nous ne pouvons pas faire cette chose, donner notre sœur à un incirconcis, car c'est un opprobre pour nous. ");
INSERT INTO frasbl_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Ce n'est qu'à cette condition que nous vous donnerons notre accord. Si vous faites comme nous, c'est-à-dire si tous les mâles d'entre vous sont circoncis, ");
INSERT INTO frasbl_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","nous vous donnerons nos filles, et nous prendrons vos filles, nous habiterons avec vous, et nous formerons un seul peuple. ");
INSERT INTO frasbl_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Mais si vous ne nous écoutez pas et si vous ne vous faites pas circoncire, alors nous prendrons notre sœur, et nous partirons. » ");
INSERT INTO frasbl_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Leurs paroles plurent à Hamor et à Sichem, fils d'Hamor. ");
INSERT INTO frasbl_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Le jeune homme n'avait pas attendu pour faire cette chose, car il avait pris plaisir à la fille de Jacob, et il était honoré au-dessus de toute la maison de son père. ");
INSERT INTO frasbl_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Hamor et Sichem, son fils, arrivèrent à la porte de leur ville et parlèrent avec les gens de leur ville, en disant : ");
INSERT INTO frasbl_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","« Ces hommes sont pacifiques avec nous. Qu'ils vivent donc dans le pays et qu'ils y fassent du commerce. Car voici, le pays est assez vaste pour eux. Prenons leurs filles pour épouses, et donnons-leur nos filles. ");
INSERT INTO frasbl_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Ce n'est qu'à cette condition que les hommes consentiront à vivre avec nous, à devenir un seul peuple, si chaque mâle parmi nous est circoncis, comme eux. ");
INSERT INTO frasbl_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Leur bétail, leurs biens et tous leurs animaux ne seront-ils pas à nous ? Seulement, donnons-leur notre consentement, et ils habiteront avec nous. » ");
INSERT INTO frasbl_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Tous ceux qui sortaient de la porte de sa ville écoutaient Hamor et Sichem, son fils, et tout mâle était circoncis, tous ceux qui sortaient de la porte de sa ville. ");
INSERT INTO frasbl_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Le troisième jour, alors qu'ils étaient endoloris, deux des fils de Jacob, Siméon et Lévi, les frères de Dina, prirent chacun leur épée, s'avancèrent vers la ville qui ne se doutait de rien et tuèrent tous les mâles. ");
INSERT INTO frasbl_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Ils tuèrent Hamor et Sichem, son fils, au fil de l'épée, prirent Dina dans la maison de Sichem et s'en allèrent. ");
INSERT INTO frasbl_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Les fils de Jacob arrivèrent sur les morts et pillèrent la ville, car ils avaient souillé leur sœur. ");
INSERT INTO frasbl_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Ils prirent leurs troupeaux, leurs vaches, leurs ânes, ce qui était dans la ville, ce qui était dans les champs, ");
INSERT INTO frasbl_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","et toutes leurs richesses. Ils emmenèrent en captivité tous leurs petits enfants et leurs femmes, et prirent comme butin tout ce qui était dans la maison. ");
INSERT INTO frasbl_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Jacob dit à Siméon et à Lévi : « Vous m'avez troublé, pour me rendre odieux aux habitants du pays, parmi les Cananéens et les Phéréziens. Je suis peu nombreux. Ils s'assembleront contre moi et me frapperont, et je serai détruit, moi et ma maison. » ");
INSERT INTO frasbl_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Ils dirent : « Doit-il traiter notre sœur comme une prostituée ? » ");
INSERT INTO frasbl_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Dieu dit à Jacob : « Lève-toi, monte à Béthel, et tu y habiteras. Fais-y un autel à Dieu, qui t'est apparu lorsque tu fuyais la face d'Ésaü, ton frère. » ");
INSERT INTO frasbl_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Alors Jacob dit à sa famille et à tous ceux qui étaient avec lui : « Otez les dieux étrangers qui sont au milieu de vous, purifiez-vous et changez de vêtements. ");
INSERT INTO frasbl_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Levons-nous, et montons à Béthel. J'y ferai un autel à Dieu, qui m'a exaucé au jour de ma détresse et qui a été avec moi sur le chemin que j'ai parcouru. » ");
INSERT INTO frasbl_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Ils donnèrent à Jacob tous les dieux étrangers qui étaient dans leurs mains et les anneaux qui étaient à leurs oreilles, et Jacob les cacha sous le chêne qui était près de Sichem. ");
INSERT INTO frasbl_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Ils voyagèrent, et la terreur de Dieu était sur les villes qui les entouraient, et elles ne poursuivirent pas les fils de Jacob. ");
INSERT INTO frasbl_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Jacob arriva à Luz (c'est-à-dire à Béthel), qui est dans le pays de Canaan, lui et tout le peuple qui était avec lui. ");
INSERT INTO frasbl_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Il y bâtit un autel et appela le lieu El Beth El, car c'est là que Dieu se révéla à lui, lorsqu'il fuyait la face de son frère. ");
INSERT INTO frasbl_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Débora, la nourrice de Rebecca, mourut, et elle fut enterrée au-dessous de Béthel, sous le chêne ; et son nom fut appelé Allon Bacuth. ");
INSERT INTO frasbl_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Dieu apparut de nouveau à Jacob, lorsqu'il revint de Paddan Aram, et il le bénit. ");
INSERT INTO frasbl_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Dieu lui dit : « Ton nom est Jacob. Ton nom ne sera plus Jacob, mais ton nom sera Israël. » Il lui donna le nom d`Israël. ");
INSERT INTO frasbl_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Dieu lui dit : « Je suis le Dieu tout-puissant. Sois fécond et multiplie. Une nation et une multitude de nations naîtront de toi, et des rois sortiront de ton corps. ");
INSERT INTO frasbl_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Le pays que j'ai donné à Abraham et à Isaac, je te le donnerai, et je le donnerai à ta postérité après toi. » ");
INSERT INTO frasbl_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Dieu se retira de lui dans le lieu où il lui avait parlé. ");
INSERT INTO frasbl_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Jacob dressa une colonne dans le lieu où il lui avait parlé, une colonne de pierre. Il y versa une libation et y répandit de l'huile. ");
INSERT INTO frasbl_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Jacob appela « Béthel » le nom du lieu où Dieu lui avait parlé. ");
INSERT INTO frasbl_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Ils partirent de Béthel. Il y avait encore de la distance à parcourir jusqu'à Ephrath, et Rachel était en travail. Elle a eu un travail difficile. ");
INSERT INTO frasbl_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Comme elle était en plein travail, la sage-femme lui dit : « N'aie pas peur, car tu vas avoir un autre fils. » ");
INSERT INTO frasbl_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Comme son âme s'en allait (car elle est morte), elle l'appela Benoni, mais son père l'appela Benjamin. ");
INSERT INTO frasbl_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Rachel mourut, et elle fut enterrée sur le chemin d'Éphrata (appelée aussi Bethléhem). ");
INSERT INTO frasbl_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Jacob dressa un pilier sur son tombeau. C'est encore aujourd'hui le pilier du tombeau de Rachel. ");
INSERT INTO frasbl_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Israël partit en voyage et étendit sa tente au-delà de la tour d'Eder. ");
INSERT INTO frasbl_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Pendant qu'Israël habitait dans ce pays, Ruben alla coucher avec Bilha, la concubine de son père, et Israël en entendit parler. Les fils de Jacob étaient au nombre de douze. ");
INSERT INTO frasbl_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Fils de Léa : Ruben (premier-né de Jacob), Siméon, Lévi, Juda, Issacar et Zabulon. ");
INSERT INTO frasbl_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Fils de Rachel : Joseph et Benjamin. ");
INSERT INTO frasbl_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Fils de Bilha (servante de Rachel) : Dan et Nephtali. ");
INSERT INTO frasbl_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Fils de Zilpa (servante de Léa) : Gad et Aser. Ce sont là les fils de Jacob, qui lui sont nés à Paddan Aram. ");
INSERT INTO frasbl_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Jacob vint auprès d'Isaac, son père, à Mamré, à Kiriath Arba (qui est Hébron), où Abraham et Isaac vivaient en étrangers. ");
INSERT INTO frasbl_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Les jours d'Isaac furent de cent quatre-vingts ans. ");
INSERT INTO frasbl_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Isaac rendit l'esprit et mourut, et il fut recueilli auprès de son peuple, âgé et rassasié de jours. Ésaü et Jacob, ses fils, l'ensevelirent. ");
INSERT INTO frasbl_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Voici l'histoire des générations d'Ésaü (c'est-à-dire d'Édom). ");
INSERT INTO frasbl_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Ésaü prit ses femmes parmi les filles de Canaan : Ada, fille d'Élon, le Héthien ; Oholibama, fille d'Ana, fille de Tsibeon, le Hévien ; ");
INSERT INTO frasbl_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","et Basemath, fille d'Ismaël, sœur de Nebaïoth. ");
INSERT INTO frasbl_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada enfanta à Ésaü Éliphaz. Basemath enfanta Reuel. ");
INSERT INTO frasbl_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholibama enfanta Jéusch, Jalam et Koré. Ce sont là les fils d'Ésaü, qui lui naquirent dans le pays de Canaan. ");
INSERT INTO frasbl_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Ésaü prit ses femmes, ses fils, ses filles et tous les membres de sa famille, avec son bétail, tous ses animaux et tous ses biens qu'il avait amassés au pays de Canaan, et il s'en alla dans un pays éloigné de son frère Jacob. ");
INSERT INTO frasbl_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Car leurs biens étaient trop importants pour qu'ils puissent habiter ensemble, et le pays de leurs voyages ne pouvait pas les supporter à cause de leur bétail. ");
INSERT INTO frasbl_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Ésaü habitait la montagne de Séir. Ésaü, c'est Édom. ");
INSERT INTO frasbl_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Voici l'histoire des générations d'Ésaü, père des Édomites, dans la montagne de Séir : ");
INSERT INTO frasbl_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Voici les noms des fils d'Ésaü : Éliphaz, fils d'Ada, femme d'Ésaü, et Réuel, fils de Basemath, femme d'Ésaü. ");
INSERT INTO frasbl_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Les fils d'Éliphaz étaient : Théman, Omar, Zépho, Gatam et Kenaz. ");
INSERT INTO frasbl_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Timna était concubine d'Éliphaz, fils d'Ésaü, et elle enfanta à Éliphaz Amalek. Tels sont les descendants d'Ada, femme d'Ésaü. ");
INSERT INTO frasbl_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Voici les fils de Réuel : Nahath, Zérah, Shammah et Mizzah. Ce sont les descendants de Basemath, femme d'Ésaü. ");
INSERT INTO frasbl_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Voici les fils d'Oholibama, fille d'Ana, fille de Tsibeon, femme d'Ésaü : elle enfanta à Ésaü Jéusch, Jalam et Koré. ");
INSERT INTO frasbl_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Voici les chefs des fils d'Ésaü, les fils d'Éliphaz, premier-né d'Ésaü : le chef Théman, le chef Omar, le chef Zépho, le chef Kenaz, ");
INSERT INTO frasbl_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","le chef Koré, le chef Gatam, le chef Amalek. Ce sont là les chefs qui sont venus d'Éliphaz au pays d'Édom. Ce sont là les fils d'Ada. ");
INSERT INTO frasbl_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Voici les fils de Réuel, fils d'Ésaü : le chef Nahath, le chef Zérach, le chef Schamma, le chef Mizza. Ce sont là les chefs issus de Réuel au pays d'Édom. Ce sont là les fils de Basemath, femme d'Ésaü. ");
INSERT INTO frasbl_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Voici les fils d'Oholibama, femme d'Ésaü : le chef Jeush, le chef Jalam, le chef Koré. Ce sont là les chefs issus d'Oholibama, fille d'Ana, femme d'Ésaü. ");
INSERT INTO frasbl_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Ce sont là les fils d'Ésaü (c'est-à-dire d'Édom), et ce sont là leurs chefs. ");
INSERT INTO frasbl_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Voici les fils de Séir, le Horien, les habitants du pays : Lotan, Shobal, Tsibeon, Ana, ");
INSERT INTO frasbl_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dishon, Ezer et Dishan. Ce sont là les chefs des Horites, fils de Séir, au pays d'Édom. ");
INSERT INTO frasbl_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Les fils de Lotan étaient Hori et Heman. La sœur de Lotan était Timna. ");
INSERT INTO frasbl_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Voici les fils de Shobal : Alvan, Manahath, Ebal, Shepho et Onam. ");
INSERT INTO frasbl_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Voici les fils de Zibeon : Aiah et Anah. C'est Anah qui a trouvé les sources chaudes dans le désert, alors qu'il nourrissait les ânes de Tsibeon, son père. ");
INSERT INTO frasbl_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Voici les fils d'Anah : Dishon et Oholibama, fille d'Anah. ");
INSERT INTO frasbl_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Voici les fils de Dishon : Hemdan, Eshban, Ithran et Cheran. ");
INSERT INTO frasbl_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Voici les fils d'Ezer : Bilhan, Zaavan et Akan. ");
INSERT INTO frasbl_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Voici les fils de Dishan : Uz et Aran. ");
INSERT INTO frasbl_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Voici les chefs des Horites : le chef Lotan, le chef Shobal, le chef Zibeon, le chef Anah, ");
INSERT INTO frasbl_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","le chef Dishon, le chef Ezer et le chef Dishan. Ce sont là les chefs des Horiens, selon leurs chefs dans le pays de Séir. ");
INSERT INTO frasbl_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Voici les rois qui ont régné dans le pays d'Édom, avant qu'aucun roi ne règne sur les enfants d'Israël. ");
INSERT INTO frasbl_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Béla, fils de Béor, régna sur Édom. Le nom de sa ville était Dinhaba. ");
INSERT INTO frasbl_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Béla mourut ; et Jobab, fils de Zérach, de Botsra, régna à sa place. ");
INSERT INTO frasbl_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Jobab mourut ; et Huscham, du pays des Thémanites, régna à sa place. ");
INSERT INTO frasbl_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Husham mourut ; et Hadad, fils de Bedad, qui avait frappé Madian dans le champ de Moab, régna à sa place. Le nom de sa ville était Avith. ");
INSERT INTO frasbl_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadad mourut. Samla, de Masréka, régna à sa place. ");
INSERT INTO frasbl_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samla mourut ; et Saül, de Rehoboth, près du fleuve, régna à sa place. ");
INSERT INTO frasbl_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Shaoul mourut. Baal Hanan, fils d`Acbor, régna à sa place. ");
INSERT INTO frasbl_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Baal Hanan, fils d`Acbor, mourut ; et Hadar régna à sa place. Le nom de sa ville était Pau. Sa femme s'appelait Mehetabel, fille de Matred, fille de Mezahab. ");
INSERT INTO frasbl_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Voici les noms des chefs issus d`Ésaü, selon leurs familles, selon leurs lieux et selon leurs noms : le chef Timna, le chef Alva, le chef Jetheth, ");
INSERT INTO frasbl_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","le chef Oholibama, le chef Éla, le chef Pinon, ");
INSERT INTO frasbl_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","le chef Kenaz, le chef Teman, le chef Mibzar, ");
INSERT INTO frasbl_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","le chef Magdiel et le chef Iram. Ce sont là les chefs d'Édom, selon leurs habitations dans le pays qu'ils possèdent. Voici Ésaü, le père des Édomites. ");
INSERT INTO frasbl_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jacob habitait dans le pays où voyageait son père, dans le pays de Canaan. ");
INSERT INTO frasbl_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Voici l'histoire des générations de Jacob. Joseph, âgé de dix-sept ans, faisait paître le troupeau avec ses frères. Il était en compagnie des fils de Bilha et de Zilpa, femmes de son père. Joseph fit un mauvais rapport sur eux à leur père. ");
INSERT INTO frasbl_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Or Israël aimait Joseph plus que tous ses enfants, car il était le fils de sa vieillesse, et il lui fit une tunique de plusieurs couleurs. ");
INSERT INTO frasbl_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Ses frères virent que leur père l'aimait plus que tous ses frères, et ils le haïrent, et ne purent pas lui parler en paix. ");
INSERT INTO frasbl_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Joseph eut un songe, et il le raconta à ses frères, qui le haïrent d'autant plus. ");
INSERT INTO frasbl_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Il leur dit : « Écoutez, je vous prie, le songe que j'ai eu. ");
INSERT INTO frasbl_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Car voici, nous lions des gerbes dans le champ, et voici que ma gerbe se leva et se tint debout ; et voici que vos gerbes s'approchèrent et se prosternèrent devant ma gerbe. » ");
INSERT INTO frasbl_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Ses frères lui demandèrent : « Vas-tu vraiment régner sur nous ? Est-ce que tu vas dominer sur nous ? » Ils le haïssaient d'autant plus qu'il rêvait et qu'il parlait. ");
INSERT INTO frasbl_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Il eut un autre songe, qu'il raconta à ses frères, et il dit : « Voici, j'ai eu un autre songe ; et voici, le soleil, la lune et onze étoiles se sont prosternés devant moi. » ");
INSERT INTO frasbl_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Il le raconta à son père et à ses frères. Son père le réprimanda et lui dit : « Quel est ce rêve que tu as fait ? Viendrons-nous, moi, ta mère et tes frères, nous prosterner en terre devant toi ? » ");
INSERT INTO frasbl_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Ses frères l'envièrent, mais son père garda cette parole en mémoire. ");
INSERT INTO frasbl_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Ses frères allèrent faire paître le troupeau de leur père à Sichem. ");
INSERT INTO frasbl_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Israël dit à Joseph : « Tes frères ne font-ils pas paître le troupeau à Sichem ? Viens, et je t'enverrai vers eux. » Joseph lui répondit : « Me voici. » ");
INSERT INTO frasbl_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Il lui dit : « Va maintenant, vois si tout va bien pour tes frères et pour le troupeau, et rapporte-moi des nouvelles. » Il l'envoya donc hors de la vallée d'Hébron, et il arriva à Sichem. ");
INSERT INTO frasbl_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Un homme le trouva, et voici qu'il errait dans les champs. L'homme lui demanda : « Que cherches-tu ? » ");
INSERT INTO frasbl_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Il dit : « Je cherche mes frères. Dis-moi, je t'en prie, où ils font paître le troupeau. » ");
INSERT INTO frasbl_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","L'homme dit : « Ils sont partis d'ici, car je les ai entendus dire : « Allons à Dothan ». » Joseph partit à la recherche de ses frères, et il les trouva à Dothan. ");
INSERT INTO frasbl_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Ils le virent de loin, et, avant qu'il ne s'approche d'eux, ils complotèrent contre lui pour le tuer. ");
INSERT INTO frasbl_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Ils se disaient les uns aux autres : « Voici que ce rêveur arrive. ");
INSERT INTO frasbl_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Venez donc maintenant, tuons-le, jetons-le dans une des fosses, et nous dirons : « Une bête malfaisante l'a dévoré ». Nous verrons ce qu'il adviendra de ses rêves. » ");
INSERT INTO frasbl_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Ruben l'entendit, le délivra de leurs mains, et dit : « Ne lui ôtons pas la vie. » ");
INSERT INTO frasbl_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Ruben leur dit : « Ne versez pas de sang. Jetez-le dans cette fosse qui est dans le désert, mais ne portez pas la main sur lui », afin de le délivrer de leurs mains et de le rendre à son père. ");
INSERT INTO frasbl_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Lorsque Joseph arriva auprès de ses frères, ils le dépouillèrent de sa tunique, la tunique multicolore qu'il portait. ");
INSERT INTO frasbl_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Ils le prirent et le jetèrent dans la fosse. La fosse était vide. Il n'y avait pas d'eau dedans. ");
INSERT INTO frasbl_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Ils s'assirent pour manger du pain. Ils levèrent les yeux et regardèrent, et ils virent qu'une caravane d'Ismaélites venait de Galaad, avec leurs chameaux portant des aromates, du baume et de la myrrhe, pour les descendre en Égypte. ");
INSERT INTO frasbl_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Juda dit à ses frères : « Quel avantage y a-t-il à tuer notre frère et à cacher son sang ? ");
INSERT INTO frasbl_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Venez, vendons-le aux Ismaélites, et ne mettons pas la main sur lui, car il est notre frère, notre chair. » Ses frères l'écoutèrent. ");
INSERT INTO frasbl_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Des marchands madianites passèrent par là ; ils tirèrent et soulevèrent Joseph de la fosse, et le vendirent aux Ismaélites pour vingt pièces d'argent. Les marchands amenèrent Joseph en Égypte. ");
INSERT INTO frasbl_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Ruben retourna à la fosse, et vit que Joseph n'y était pas ; il déchira ses vêtements. ");
INSERT INTO frasbl_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Il retourna vers ses frères et dit : « L'enfant n'est plus ; et moi, où irai-je ? » ");
INSERT INTO frasbl_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Ils prirent la tunique de Joseph, tuèrent un bouc, et plongèrent la tunique dans le sang. ");
INSERT INTO frasbl_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Elles prirent la tunique multicolore, l'apportèrent à leur père et dirent : « Nous avons trouvé ceci. Examine-la maintenant, et vois si c'est la tunique de ton fils ou non. » ");
INSERT INTO frasbl_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Il la reconnut et dit : « C'est la tunique de mon fils. Un animal malfaisant l'a dévoré. Joseph est sans doute déchiré en morceaux. » ");
INSERT INTO frasbl_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Jacob déchira ses vêtements, mit un sac sur sa taille et porta le deuil de son fils pendant plusieurs jours. ");
INSERT INTO frasbl_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Tous ses fils et toutes ses filles se levèrent pour le consoler, mais il refusa d'être consolé. Il dit : « Car je descendrai au séjour des morts auprès de mon fils, en pleurant. » Son père pleura sur lui. ");
INSERT INTO frasbl_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Les Madianites le vendirent en Égypte à Potiphar, un officier de Pharaon, le chef des gardes. ");
INSERT INTO frasbl_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","En ce temps-là, Juda descendit de chez ses frères, et se rendit chez un certain Adullamite, dont le nom était Hira. ");
INSERT INTO frasbl_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Là, Juda vit la fille d'un homme de Canaan, nommé Schua. Il la prit, et alla vers elle. ");
INSERT INTO frasbl_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Elle devint enceinte, et enfanta un fils, qu'il appela Er. ");
INSERT INTO frasbl_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Elle conçut encore, et enfanta un fils, qu'elle appela Onan. ");
INSERT INTO frasbl_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Elle enfanta encore un fils, qu'elle appela Schéla. Il était à Chezib lorsqu'elle l'enfanta. ");
INSERT INTO frasbl_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Juda prit une femme pour Er, son premier-né, et elle s'appela Tamar. ");
INSERT INTO frasbl_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Er, le premier-né de Juda, était méchant aux yeux de l'Éternel. Aussi Yahvé le fit-il mourir. ");
INSERT INTO frasbl_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Juda dit à Onan : « Va vers la femme de ton frère, accomplis envers elle le devoir d'un frère de mari, et suscite une descendance pour ton frère. » ");
INSERT INTO frasbl_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Onan savait que la descendance ne serait pas la sienne ; et quand il entra chez la femme de son frère, il répandit sa semence sur le sol, de peur de donner une descendance à son frère. ");
INSERT INTO frasbl_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","La chose qu'il fit fut mauvaise aux yeux de l'Éternel, qui le fit aussi mourir. ");
INSERT INTO frasbl_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Juda dit alors à Tamar, sa belle-fille : « Reste veuve dans la maison de ton père, jusqu'à ce que mon fils Schéla ait grandi, car il disait : « De peur qu'il ne meure, lui aussi, comme ses frères. » Tamar alla vivre dans la maison de son père. ");
INSERT INTO frasbl_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Après plusieurs jours, la fille de Shua, la femme de Juda, mourut. Juda fut consolé, et il monta à Timna pour tondre ses moutons, lui et son ami Hira, l'Adullamite. ");
INSERT INTO frasbl_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","On dit à Tamar : « Voici ton beau-père qui monte à Thimna pour tondre ses brebis. » ");
INSERT INTO frasbl_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Elle ôta les vêtements de son veuvage, se couvrit de son voile, s'enveloppa et s'assit à la porte d'Énaïm, qui est sur le chemin de Timna ; car elle vit que Shélah était devenu grand, et qu'elle ne lui avait pas été donnée pour femme. ");
INSERT INTO frasbl_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Lorsque Juda la vit, il pensa que c'était une prostituée, car elle avait couvert son visage. ");
INSERT INTO frasbl_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Il se tourna vers elle par le chemin et dit : « Viens, je t'en prie, laisse-moi entrer chez toi », car il ne savait pas qu'elle était sa belle-fille. Elle a dit : « Que me donneras-tu pour que tu entres chez moi ? » ");
INSERT INTO frasbl_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Il dit : « Je t'enverrai un chevreau du troupeau. » Elle a dit : « Tu me donneras un gage, jusqu'à ce que tu l'envoies ? » ");
INSERT INTO frasbl_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Il a dit : « Quel gage vais-je te donner ? » Elle a dit : « Ton sceau, ton cordon et le bâton que tu tiens à la main. » Il les lui donna ; il entra chez elle, et elle devint enceinte de lui. ");
INSERT INTO frasbl_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Elle se leva et s'en alla, ôta son voile et revêtit les vêtements de son veuvage. ");
INSERT INTO frasbl_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Juda envoya le chevreau par la main de son ami, l'Adullamite, pour recevoir le gage de la main de la femme, mais il ne la trouva pas. ");
INSERT INTO frasbl_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Alors il interrogea les hommes de son lieu de résidence, en disant : « Où est la prostituée qui était à Enaïm, au bord de la route ? » Ils ont dit : « Il n'y a pas eu de prostituée ici. » ");
INSERT INTO frasbl_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Il retourna auprès de Juda, et dit : « Je ne l'ai pas trouvée, et les gens du lieu ont dit : « Il n'y a pas eu de prostituée ici. » ");
INSERT INTO frasbl_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Juda dit : « Qu'elle la garde, de peur que nous ne soyons déshonorés. Voici que j'ai envoyé ce chevreau, et vous ne l'avez pas trouvée. » ");
INSERT INTO frasbl_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Environ trois mois plus tard, Juda fut informé : « Tamar, ta belle-fille, s'est prostituée. De plus, voici qu'elle est enceinte par prostitution. » Juda dit : « Fais-la sortir, et qu'on la brûle. » ");
INSERT INTO frasbl_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Quand elle fut sortie, elle envoya dire à son beau-père : « Je suis enceinte de l'homme à qui appartiennent ces objets. » Elle dit aussi : « Je te prie de discerner à qui appartiennent ces objets : le sceau, les cordons et le bâton. » ");
INSERT INTO frasbl_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Juda les reconnut et dit : « Elle est plus juste que moi, car je ne l'ai pas donnée à Shéla, mon fils. » Il ne la connut plus. ");
INSERT INTO frasbl_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Au moment où elle accouchait, voici, des jumeaux étaient dans son sein. ");
INSERT INTO frasbl_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Comme elle était en travail, l'un d'eux étendit la main ; la sage-femme prit un fil écarlate et l'attacha à sa main, en disant : « Celui-ci est sorti le premier. » ");
INSERT INTO frasbl_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Comme il retirait sa main, voici que son frère sortit, et elle dit : « Pourquoi t'es-tu fait une brèche ? » C'est pourquoi on lui donna le nom de Pérez. ");
INSERT INTO frasbl_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Ensuite sortit son frère, qui avait un fil cramoisi à la main, et on l'appela Zérach. ");
INSERT INTO frasbl_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Joseph fut descendu en Égypte. Potiphar, officier de Pharaon, chef des gardes, un Égyptien, l'acheta de la main des Ismaélites qui l'avaient fait descendre. ");
INSERT INTO frasbl_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Yahvé était avec Joseph, et il était un homme prospère. Il était dans la maison de son maître, l'Égyptien. ");
INSERT INTO frasbl_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Son maître vit que Yahvé était avec lui, et que Yahvé faisait prospérer entre ses mains tout ce qu'il faisait. ");
INSERT INTO frasbl_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Joseph trouva grâce à ses yeux. Il le servit, et Potiphar l'établit surveillant de sa maison, et il mit entre ses mains tout ce qui lui appartenait. ");
INSERT INTO frasbl_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Dès qu'il l'eut établi surveillant de sa maison et de tout ce qu'il possédait, Yahvé bénit la maison de l'Égyptien à cause de Joseph. La bénédiction de Yahvé fut sur tout ce qu'il avait, dans la maison et dans les champs. ");
INSERT INTO frasbl_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Il laissa tout ce qu'il avait entre les mains de Joseph. Il ne s'occupa de rien, sauf de la nourriture qu'il mangea. Joseph était bien bâti et beau. ");
INSERT INTO frasbl_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Après cela, la femme de son maître jeta les yeux sur Joseph, et elle dit : « Couche avec moi. » ");
INSERT INTO frasbl_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Mais il refusa, et dit à la femme de son maître : « Voici, mon maître ne sait pas ce que j'ai dans la maison, et il a remis entre mes mains tout ce qu'il possède. ");
INSERT INTO frasbl_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Personne n'est plus grand que moi dans cette maison, et il ne m'a rien caché que toi, parce que tu es sa femme. Comment donc pourrais-je commettre cette grande méchanceté et pécher contre Dieu ? » ");
INSERT INTO frasbl_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Comme elle parlait à Joseph jour après jour, il ne l'écoutait pas, ne se couchait pas près d'elle et ne restait pas avec elle. ");
INSERT INTO frasbl_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Vers ce temps-là, il entra dans la maison pour faire son travail, et il n'y avait aucun des hommes de la maison à l'intérieur. ");
INSERT INTO frasbl_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Elle le saisit par son vêtement et lui dit : « Couche avec moi ! » Il laissa son vêtement dans sa main, et sortit en courant. ");
INSERT INTO frasbl_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Lorsqu'elle vit qu'il avait laissé son vêtement dans sa main et qu'il était sorti en courant, ");
INSERT INTO frasbl_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","elle appela les gens de sa maison et leur parla ainsi : « Voici qu'il a fait entrer chez nous un Hébreu pour se moquer de nous. Il est entré chez moi pour coucher avec moi, et j'ai crié d'une voix forte. ");
INSERT INTO frasbl_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Quand il a entendu que j'élevais la voix et que je criais, il a laissé son vêtement près de moi, et il est sorti en courant. » ");
INSERT INTO frasbl_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Elle déposa son vêtement près d'elle, jusqu'à ce que son maître revienne à la maison. ");
INSERT INTO frasbl_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Elle lui parla ainsi, et dit : Le serviteur hébreu que tu nous as amené est entré chez moi pour se moquer de moi ; ");
INSERT INTO frasbl_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","et comme j'élevais la voix et que je criais, il a laissé son vêtement près de moi et s'est enfui. » ");
INSERT INTO frasbl_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Lorsque son maître entendit les paroles de sa femme, qui lui disait : « Voici ce que ton serviteur m'a fait », sa colère s'enflamma. ");
INSERT INTO frasbl_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Le maître de Joseph le prit et le mit dans la prison, le lieu où l'on attachait les prisonniers du roi, et il y resta enfermé. ");
INSERT INTO frasbl_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Mais Yahvé était avec Joseph, il lui témoigna de la bonté et lui accorda sa faveur aux yeux du gardien de la prison. ");
INSERT INTO frasbl_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Le gardien de la prison remit entre les mains de Joseph tous les prisonniers qui se trouvaient dans la prison. Tout ce qu'ils y faisaient, il en était responsable. ");
INSERT INTO frasbl_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Le gardien de la prison ne s'occupait de rien de ce qui était sous sa responsabilité, car l'Éternel était avec lui, et ce qu'il faisait, l'Éternel le faisait prospérer. ");
INSERT INTO frasbl_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Après ces choses, le maître d'hôtel du roi d'Égypte et son boulanger offensèrent leur seigneur, le roi d'Égypte. ");
INSERT INTO frasbl_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Pharaon se mit en colère contre ses deux officiers, le chef des échansons et le chef des panetiers. ");
INSERT INTO frasbl_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Il les plaça en détention dans la maison du chef des gardes, dans la prison, lieu où Joseph était lié. ");
INSERT INTO frasbl_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Le chef des gardes les confia à Joseph, qui prit soin d'eux. Ils restèrent plusieurs jours dans la prison. ");
INSERT INTO frasbl_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Ils eurent tous deux un songe, chacun son songe, en une nuit, chacun selon l'interprétation de son songe, l'échanson et le panetier du roi d'Égypte, qui étaient liés dans la prison. ");
INSERT INTO frasbl_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Le matin, Joseph entra chez eux, les vit, et constata qu'ils étaient tristes. ");
INSERT INTO frasbl_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Il demanda aux officiers de Pharaon qui étaient avec lui en détention dans la maison de son maître : « Pourquoi avez-vous l'air si triste aujourd'hui ? » ");
INSERT INTO frasbl_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Ils lui dirent : « Nous avons fait un rêve, et il n'y a personne qui puisse l'interpréter. » Joseph leur dit : « Les interprétations n'appartiennent-elles pas à Dieu ? S'il vous plaît, dites-le moi. » ");
INSERT INTO frasbl_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Le chef des échansons raconta son rêve à Joseph, et lui dit : « Dans mon rêve, voici qu'une vigne était devant moi, ");
INSERT INTO frasbl_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","et dans la vigne il y avait trois branches. On aurait dit qu'elle bourgeonnait, qu'elle fleurissait, et que ses grappes produisaient des raisins mûrs. ");
INSERT INTO frasbl_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","La coupe de Pharaon était dans ma main ; j'ai pris les raisins, je les ai pressés dans la coupe de Pharaon, et j'ai donné la coupe dans la main de Pharaon. » ");
INSERT INTO frasbl_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Joseph lui dit : « Voici son interprétation : les trois branches sont trois jours. ");
INSERT INTO frasbl_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Dans trois jours encore, Pharaon relèvera ta tête et te rétablira dans ta fonction. Tu remettras la coupe de Pharaon dans sa main, comme tu l'as fait lorsque tu étais son échanson. ");
INSERT INTO frasbl_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Mais souviens-toi de moi quand tout ira bien pour toi. Fais preuve de bonté à mon égard, parle de moi à Pharaon et fais-moi sortir de cette maison. ");
INSERT INTO frasbl_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","En effet, j'ai été enlevé du pays des Hébreux, et ici aussi je n'ai rien fait pour qu'on me mette au cachot. » ");
INSERT INTO frasbl_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Le chef des boulangers, voyant que l'interprétation était bonne, dit à Joseph : « Moi aussi, j'étais dans mon rêve, et voici que trois corbeilles de pain blanc étaient sur ma tête. ");
INSERT INTO frasbl_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Dans la corbeille supérieure, il y avait toutes sortes d'aliments cuits pour Pharaon, et les oiseaux les mangeaient dans la corbeille sur ma tête. » ");
INSERT INTO frasbl_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Joseph répondit : « Voici son interprétation. Les trois paniers représentent trois jours. ");
INSERT INTO frasbl_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Dans trois jours encore, Pharaon lèvera ta tête de dessus toi, il te pendra à un arbre, et les oiseaux mangeront ta chair de dessus toi. » ");
INSERT INTO frasbl_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Le troisième jour, qui était l'anniversaire de Pharaon, il fit un festin pour tous ses serviteurs, et il leva la tête du chef des échansons et la tête du chef des panetiers parmi ses serviteurs. ");
INSERT INTO frasbl_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Il remit le chef des échansons à sa place, et il remit la coupe entre les mains de Pharaon. ");
INSERT INTO frasbl_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Mais il fit pendre le chef des panetiers, comme Joseph le leur avait expliqué. ");
INSERT INTO frasbl_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Mais le chef échanson ne se souvint pas de Joseph, il l'oublia. ");
INSERT INTO frasbl_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Au bout de deux années complètes, Pharaon eut un songe, et voici qu'il se tenait près du fleuve. ");
INSERT INTO frasbl_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Et voici, sept bêtes sortaient du fleuve. Elles étaient sveltes et grasses, et elles se nourrissaient de l'herbe des marais. ");
INSERT INTO frasbl_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Et voici, sept autres bêtes sortaient du fleuve après elles, laides et maigres, et se tenaient près des autres bêtes, sur le bord du fleuve. ");
INSERT INTO frasbl_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Les bêtes laides et maigres dévorèrent les sept bêtes sveltes et grasses. Pharaon se réveilla. ");
INSERT INTO frasbl_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Il dormit et rêva une seconde fois ; et voici que sept épis de blé montèrent sur une seule tige, sains et bons. ");
INSERT INTO frasbl_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Et voici, sept épis maigres, soufflés par le vent d'est, poussèrent après eux. ");
INSERT INTO frasbl_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Les épis minces avalèrent les sept épis sains et pleins. Pharaon se réveilla, et voici, c'était un rêve. ");
INSERT INTO frasbl_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Le matin, son esprit fut troublé, et il fit venir tous les magiciens et les sages d'Égypte. Pharaon leur raconta ses rêves, mais il n'y avait personne pour les interpréter à Pharaon. ");
INSERT INTO frasbl_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Alors le chef des échansons parla à Pharaon, et dit : « Je me souviens aujourd'hui de mes fautes. ");
INSERT INTO frasbl_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Pharaon s'est mis en colère contre ses serviteurs et m'a fait enfermer dans la maison du chef des gardes, avec le chef des boulangers. ");
INSERT INTO frasbl_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Nous fîmes un rêve en une seule nuit, lui et moi. Chacun rêva selon l'interprétation de son rêve. ");
INSERT INTO frasbl_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Il y avait là avec nous un jeune homme, un Hébreu, serviteur du chef des gardes. Nous lui avons raconté, et il nous a interprété nos rêves. Il interpréta à chacun selon son songe. ");
INSERT INTO frasbl_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Et il en fut ainsi, comme il nous l'interpréta. Il m'a rétabli dans mes fonctions, et il l'a pendu. » ");
INSERT INTO frasbl_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Alors Pharaon envoya appeler Joseph, et on le fit sortir en toute hâte du cachot. Il se rasa, changea de vêtements, et entra chez Pharaon. ");
INSERT INTO frasbl_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Pharaon dit à Joseph : « J'ai fait un rêve, et il n'y a personne qui puisse l'interpréter. J'ai entendu dire de toi que, lorsque tu entends un rêve, tu peux l'interpréter. » ");
INSERT INTO frasbl_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Joseph répondit à Pharaon : « Ce n'est pas en moi. Dieu donnera à Pharaon une réponse de paix. » ");
INSERT INTO frasbl_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Pharaon dit à Joseph : « Dans mon rêve, voici, je me tenais sur le bord du fleuve ; ");
INSERT INTO frasbl_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","et voici, sept bêtes grasses et élégantes sont sorties du fleuve. Ils se nourrissaient de l'herbe des marais. ");
INSERT INTO frasbl_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Et voici que sept autres bêtes montaient après eux, pauvres, très laides et maigres, comme je n'en ai jamais vu dans tout le pays d'Égypte pour leur laideur. ");
INSERT INTO frasbl_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Les bêtes maigres et laides mangèrent les sept premières bêtes grasses ; ");
INSERT INTO frasbl_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","et quand elles les eurent mangées, on ne put savoir qu'elles les avaient mangées, mais elles étaient toujours aussi laides, comme au début. Alors je me réveillai. ");
INSERT INTO frasbl_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Je regardai en songe, et voici que sept épis de blé montaient sur une tige, pleins et bons ; ");
INSERT INTO frasbl_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","et voici que sept épis de blé, desséchés, maigres, et soufflés par le vent d'orient, montaient après eux. ");
INSERT INTO frasbl_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Les épis maigres avalèrent les sept bons épis. Je l'ai raconté aux magiciens, mais il n'y avait personne qui pût me l'expliquer. » ");
INSERT INTO frasbl_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Joseph dit à Pharaon : « Le rêve de Pharaon est unique. Ce que Dieu va faire, il l'a annoncé à Pharaon. ");
INSERT INTO frasbl_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Les sept bonnes bêtes sont sept ans, et les sept bonnes épis sont sept ans. Le rêve est unique. ");
INSERT INTO frasbl_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Les sept bêtes maigres et laides qui sont montées après elles, ce sont sept ans, et aussi les sept épis vides, soufflés par le vent d'orient ; ce seront sept années de famine. ");
INSERT INTO frasbl_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","C'est ce que j'ai dit à Pharaon. Dieu a montré à Pharaon ce qu'il allait faire. ");
INSERT INTO frasbl_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Voici, sept années de grande abondance dans tout le pays d'Égypte vont venir. ");
INSERT INTO frasbl_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Sept années de famine surviendront après elles, et toute l'abondance sera oubliée dans le pays d'Égypte. La famine consumera le pays, ");
INSERT INTO frasbl_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","et l'abondance ne sera pas connue dans le pays, à cause de la famine qui suivra, car elle sera très douloureuse. ");
INSERT INTO frasbl_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Le rêve a été doublé pour Pharaon, car la chose est établie par Dieu, et Dieu l'accomplira bientôt. ");
INSERT INTO frasbl_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","« Maintenant, que Pharaon cherche un homme discret et sage, et qu'il l'établisse sur le pays d'Égypte. ");
INSERT INTO frasbl_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Que Pharaon fasse cela, qu'il nomme des surveillants sur le pays, et qu'ils prélèvent le cinquième de la production du pays d'Égypte pendant les sept années d'abondance. ");
INSERT INTO frasbl_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Qu'ils rassemblent toutes les denrées de ces bonnes années à venir, et qu'ils stockent le grain sous la main de Pharaon pour le nourrir dans les villes, et qu'ils le gardent. ");
INSERT INTO frasbl_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Ces vivres serviront à approvisionner le pays contre les sept années de famine qui s'abattront sur le pays d'Égypte, afin que le pays ne périsse pas par la famine. » ");
INSERT INTO frasbl_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","La chose était bonne aux yeux de Pharaon et aux yeux de tous ses serviteurs. ");
INSERT INTO frasbl_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Pharaon dit à ses serviteurs : « Peut-on trouver un tel homme, un homme en qui réside l'Esprit de Dieu ? ». ");
INSERT INTO frasbl_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Pharaon dit à Joseph : « Puisque Dieu t'a montré tout cela, il n'y a personne d'aussi discret et d'aussi sage que toi. ");
INSERT INTO frasbl_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Tu seras à la tête de ma maison. Tout mon peuple sera gouverné selon ta parole. Ce n'est que sur le trône que je serai plus grand que toi. » ");
INSERT INTO frasbl_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Pharaon dit à Joseph : « Voici, je t'ai établi sur tout le pays d'Égypte. » ");
INSERT INTO frasbl_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Pharaon ôta sa bague de sa main et la mit à la main de Joseph ; il le revêtit d'une robe de fin lin, et lui mit un collier d'or au cou. ");
INSERT INTO frasbl_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Il le fit monter dans le second char qu'il avait. Ils criaient devant lui : « Agenouillez-vous ! » Il l'établit sur tout le pays d'Égypte. ");
INSERT INTO frasbl_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Pharaon dit à Joseph : « Je suis Pharaon. Sans toi, personne ne lèvera la main ni le pied dans tout le pays d'Égypte. » ");
INSERT INTO frasbl_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Pharaon donna à Joseph le nom de Zaphenath-Paneah. Il lui donna pour femme Asenath, fille du prêtre Potiphéra d'On. Joseph parcourut le pays d'Égypte. ");
INSERT INTO frasbl_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Joseph était âgé de trente ans lorsqu'il se présenta devant Pharaon, roi d'Égypte. Joseph sortit de la présence de Pharaon, et parcourut tout le pays d'Égypte. ");
INSERT INTO frasbl_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Pendant les sept années d'abondance, la terre produisit en abondance. ");
INSERT INTO frasbl_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Il ramassa toutes les provisions des sept années qui s'étaient écoulées dans le pays d'Égypte, et il les mit en réserve dans les villes. Il stocka dans chaque ville des aliments provenant des champs qui entouraient cette ville. ");
INSERT INTO frasbl_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Joseph accumula du grain comme le sable de la mer, en très grande quantité, jusqu'à ce qu'il cesse de compter, car il était sans nombre. ");
INSERT INTO frasbl_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Il naquit à Joseph, avant l'année de la famine, deux fils qu'Asenath, fille de Potiphéra, prêtre d'On, lui enfanta. ");
INSERT INTO frasbl_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Joseph donna à l'aîné le nom de Manassé, car, dit-il, Dieu m'a fait oublier tout mon labeur et toute la maison de mon père. » ");
INSERT INTO frasbl_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Le nom du second, il l'appela Ephraïm : « Car Dieu m'a rendu fécond dans le pays de mon affliction. » ");
INSERT INTO frasbl_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Les sept années d'abondance qui existaient dans le pays d'Égypte prirent fin. ");
INSERT INTO frasbl_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Les sept années de famine commencèrent à venir, comme l'avait dit Joseph. Il y eut de la famine dans tous les pays, mais dans tout le pays d'Égypte, il y avait du pain. ");
INSERT INTO frasbl_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Lorsque tout le pays d'Égypte fut affamé, le peuple cria au Pharaon pour avoir du pain. Le Pharaon dit à tous les Égyptiens : « Allez voir Joseph. Faites ce qu'il vous dira. » ");
INSERT INTO frasbl_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","La famine sévissait sur toute la surface de la terre. Joseph ouvrit tous les magasins et vendit aux Égyptiens. La famine était grande dans le pays d'Égypte. ");
INSERT INTO frasbl_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Tous les pays venaient en Égypte, chez Joseph, pour acheter du blé, car la famine sévissait sur toute la surface de la terre. ");
INSERT INTO frasbl_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Jacob vit qu'il y avait du blé en Égypte, et il dit à ses fils : « Pourquoi vous regardez-vous les uns les autres ? » ");
INSERT INTO frasbl_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Il répondit : « Voici, j'ai appris qu'il y a du blé en Égypte. Descendez-y et achetez-en pour nous, afin que nous vivions et que nous ne mourions pas. » ");
INSERT INTO frasbl_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Les dix frères de Joseph descendirent pour acheter du blé en Égypte. ");
INSERT INTO frasbl_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Mais Jacob n'envoya pas Benjamin, le frère de Joseph, avec ses frères, car il dit : « De peur qu'il ne lui arrive du mal. » ");
INSERT INTO frasbl_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Les fils d'Israël vinrent acheter parmi ceux qui étaient venus, car la famine sévissait au pays de Canaan. ");
INSERT INTO frasbl_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Joseph était le gouverneur du pays. C'est lui qui vendit à tous les habitants du pays. Les frères de Joseph vinrent, et ils se prosternèrent devant lui, le visage contre terre. ");
INSERT INTO frasbl_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Joseph vit ses frères et les reconnut, mais il se comporta comme un étranger avec eux et leur parla durement. Il leur dit : « D'où venez-vous ? » Ils ont dit : « Du pays de Canaan, pour acheter de la nourriture. » ");
INSERT INTO frasbl_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Joseph reconnut ses frères, mais ils ne le reconnurent pas. ");
INSERT INTO frasbl_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Joseph se souvint des rêves qu'il avait eus à leur sujet, et il leur dit : « Vous êtes des espions ! Vous êtes venus voir la nudité du pays. » ");
INSERT INTO frasbl_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Ils lui dirent : « Non, mon seigneur, mais tes serviteurs sont venus pour acheter de la nourriture. ");
INSERT INTO frasbl_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Nous sommes tous fils d'un seul homme, nous sommes des hommes honnêtes. Tes serviteurs ne sont pas des espions. » ");
INSERT INTO frasbl_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Il leur dit : « Non, mais vous êtes venus pour voir la nudité du pays ! » ");
INSERT INTO frasbl_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ils dirent : « Nous, tes serviteurs, sommes douze frères, fils d'un seul homme au pays de Canaan ; et voici que le plus jeune est aujourd'hui avec notre père, et l'autre n'est plus. » ");
INSERT INTO frasbl_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Joseph leur dit : « C'est comme je vous l'ai dit, en disant : « Vous êtes des espions ». ");
INSERT INTO frasbl_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Par ceci, vous serez mis à l'épreuve. Par la vie de Pharaon, vous ne sortirez pas d'ici, à moins que votre plus jeune frère ne vienne ici. ");
INSERT INTO frasbl_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Envoie l'un d'entre vous, qu'il aille chercher ton frère, et tu seras lié, afin que tes paroles soient mises à l'épreuve et qu'on sache s'il y a de la vérité en toi, ou si, par la vie de Pharaon, tu es un espion. » ");
INSERT INTO frasbl_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Il les mit tous ensemble en détention pendant trois jours. ");
INSERT INTO frasbl_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Le troisième jour, Joseph leur dit : « Faites cela, et vivez, car je crains Dieu. ");
INSERT INTO frasbl_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Si vous êtes des hommes honnêtes, laissez donc l'un de vos frères être lié dans votre prison ; mais vous, partez, portez du blé pour la famine de vos maisons. ");
INSERT INTO frasbl_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Amenez-moi votre plus jeune frère ; ainsi vos paroles seront vérifiées, et vous ne mourrez pas. » Ils firent ainsi. ");
INSERT INTO frasbl_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Ils se dirent les uns aux autres : « Nous sommes certainement coupables à l'égard de notre frère, en ce que nous avons vu la détresse de son âme, lorsqu'il nous suppliait, et que nous n'avons pas voulu l'écouter. C'est pourquoi cette détresse est venue sur nous. » ");
INSERT INTO frasbl_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ruben leur répondit : « Ne vous ai-je pas dit : « Ne péchez pas contre l'enfant », et n'avez-vous pas voulu écouter ? C'est pourquoi aussi, voici, son sang est requis. » ");
INSERT INTO frasbl_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Ils ne savaient pas que Joseph les comprenait, car il y avait un interprète entre eux. ");
INSERT INTO frasbl_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Il se détourna d`eux, et pleura. Puis il revint vers eux, leur parla, prit Siméon du milieu d'eux et le lia sous leurs yeux. ");
INSERT INTO frasbl_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Puis Joseph donna l'ordre de remplir leurs sacs de blé, de remettre l'argent de chacun dans son sac, et de leur donner de la nourriture pour le chemin. C'est ainsi qu'il leur fut fait. ");
INSERT INTO frasbl_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Ils chargèrent leurs ânes de leur grain, et partirent de là. ");
INSERT INTO frasbl_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Comme l'un d'eux ouvrait son sac pour donner à manger à son âne dans le lieu d'hébergement, il vit son argent. Voici, il était dans l'ouverture de son sac. ");
INSERT INTO frasbl_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Il dit à ses frères : « Mon argent a été retrouvé ! Voici qu'il est dans mon sac. » Leur cœur les abandonna, et ils se tournèrent en tremblant les uns vers les autres, en disant : « Qu'est-ce que Dieu nous a fait ? » ");
INSERT INTO frasbl_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Ils se rendirent auprès de Jacob, leur père, au pays de Canaan, et lui racontèrent tout ce qui leur était arrivé, en disant : ");
INSERT INTO frasbl_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","« Cet homme, le seigneur du pays, nous a parlé durement et nous a pris pour des espions du pays. ");
INSERT INTO frasbl_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Nous lui avons répondu : « Nous sommes d'honnêtes hommes. Nous ne sommes point des espions. ");
INSERT INTO frasbl_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Nous sommes douze frères, fils de notre père ; l'un d'eux n'est plus, et le plus jeune est aujourd'hui avec notre père au pays de Canaan. ");
INSERT INTO frasbl_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","L'homme, le seigneur du pays, nous dit : « Voici comment je saurai que vous êtes des hommes honnêtes : laissez-moi l'un de vos frères, prenez du blé pour la famine de vos maisons, et partez. ");
INSERT INTO frasbl_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Amenez-moi votre plus jeune frère. Je saurai alors que vous n'êtes pas des espions, mais que vous êtes des hommes honnêtes. Je vous livrerai donc votre frère, et vous ferez du commerce dans le pays.'\" ");
INSERT INTO frasbl_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Comme ils vidaient leurs sacs, voici que chacun avait dans son sac son paquet d'argent. Lorsqu'ils virent leurs liasses d'argent, eux et leur père eurent peur. ");
INSERT INTO frasbl_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Jacob, leur père, leur dit : « Vous m'avez privé de mes enfants ! Joseph n'est plus, Siméon n'est plus, et vous voulez m'enlever Benjamin. Toutes ces choses sont contre moi. » ");
INSERT INTO frasbl_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Ruben parla à son père et dit : « Tue mes deux fils, si je ne te le ramène pas. Confie-le à mes soins, et je te le ramènerai. » ");
INSERT INTO frasbl_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Il dit : « Mon fils ne descendra pas avec toi, car son frère est mort et il ne reste que lui. S'il lui arrive malheur sur le chemin que vous empruntez, vous ferez descendre mes cheveux blancs avec tristesse au séjour des morts. » ");
INSERT INTO frasbl_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","La famine sévissait dans le pays. ");
INSERT INTO frasbl_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Lorsqu'ils eurent épuisé le blé qu'ils avaient apporté d'Égypte, leur père leur dit : « Retournez-y, achetez-nous encore un peu de nourriture. » ");
INSERT INTO frasbl_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Juda lui parla, et dit : « L'homme nous a solennellement avertis, en disant : 'Vous ne verrez pas ma face, à moins que votre frère ne soit avec vous'. ");
INSERT INTO frasbl_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Si tu envoies notre frère avec nous, nous descendrons et nous t'achèterons des vivres ; ");
INSERT INTO frasbl_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","mais si tu ne l'envoies pas, nous ne descendrons pas, car l'homme nous a dit : 'Tu ne verras pas ma face, à moins que ton frère ne soit avec toi'. » ");
INSERT INTO frasbl_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Israël a dit : « Pourquoi m'as-tu traité si mal, en disant à l'homme que tu avais un autre frère ? » ");
INSERT INTO frasbl_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Ils répondirent : « L'homme nous a interrogés directement sur nous-mêmes et sur nos proches, en disant : « Ton père vit-il encore ? As-tu un autre frère ? Nous avons simplement répondu à ses questions. Pouvions-nous savoir qu'il allait dire : 'Fais descendre ton frère' ? » ");
INSERT INTO frasbl_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Juda dit à Israël, son père : « Envoie le garçon avec moi, et nous nous lèverons et partirons, afin que nous vivions et ne mourions pas, nous, et toi, et aussi nos petits enfants. ");
INSERT INTO frasbl_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Je serai pour lui une garantie. C'est de ma main que vous le réclamerez. Si je ne vous l'amène pas, si je ne le mets pas devant vous, que j'en porte la responsabilité pour toujours ; ");
INSERT INTO frasbl_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","car si nous n'avions pas tardé, nous serions déjà revenus une seconde fois. » ");
INSERT INTO frasbl_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Leur père, Israël, leur dit : « S'il doit en être ainsi, faites ceci : Prenez dans vos sacs des fruits de choix du pays, et descendez un présent pour l'homme, un peu de baume, un peu de miel, des aromates et de la myrrhe, des noix et des amandes ; ");
INSERT INTO frasbl_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","et prenez dans votre main de l'argent en double, et rapportez l'argent qui est revenu dans la bouche de vos sacs. C'était peut-être un oubli. ");
INSERT INTO frasbl_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Prends aussi ton frère, lève-toi, et retourne vers l'homme. ");
INSERT INTO frasbl_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Que le Dieu tout-puissant te fasse grâce devant cet homme, afin qu'il te relâche ton autre frère et Benjamin. Si je suis privé de mes enfants, je suis privé. » ");
INSERT INTO frasbl_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Les hommes prirent ce présent, et ils prirent en main l'argent double, ainsi que Benjamin ; ils se levèrent, descendirent en Égypte, et se présentèrent devant Joseph. ");
INSERT INTO frasbl_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Lorsque Joseph vit Benjamin avec eux, il dit à l'intendant de sa maison : « Fais entrer les hommes dans la maison, égorge une bête et prépare-toi, car les hommes dîneront avec moi à midi. » ");
INSERT INTO frasbl_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","L'homme fit ce que Joseph avait ordonné, et l'homme amena les hommes dans la maison de Joseph. ");
INSERT INTO frasbl_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Les hommes eurent peur, parce qu'ils avaient été amenés à la maison de Joseph ; ils dirent : « C'est à cause de l'argent qui est revenu dans nos sacs la première fois que nous sommes amenés, afin qu'il cherche une occasion contre nous, qu'il nous attaque et qu'il nous saisisse comme esclaves, avec nos ânes. » ");
INSERT INTO frasbl_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Ils s'approchèrent de l'intendant de la maison de Joseph, lui parlèrent à la porte de la maison, ");
INSERT INTO frasbl_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","et dirent : « Oh, mon seigneur, nous sommes en effet descendus la première fois pour acheter de la nourriture. ");
INSERT INTO frasbl_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Lorsque nous sommes arrivés au gîte, nous avons ouvert nos sacs, et voici que l'argent de chacun était dans l'ouverture de son sac, notre argent en plein poids. Nous l'avons rapporté dans notre main. ");
INSERT INTO frasbl_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Nous avons descendu d'autre argent dans notre main pour acheter de la nourriture. Nous ne savons pas qui a mis notre argent dans nos sacs. » ");
INSERT INTO frasbl_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Il dit : « La paix soit avec vous. N'ayez pas peur. Votre Dieu, et le Dieu de votre père, vous a donné un trésor dans vos sacs. J'ai reçu votre argent. » Il fit sortir Siméon vers eux. ");
INSERT INTO frasbl_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","L'homme fit entrer les hommes dans la maison de Joseph, leur donna de l'eau et ils se lavèrent les pieds. Il donna du fourrage à leurs ânes. ");
INSERT INTO frasbl_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Ils préparèrent le cadeau pour la venue de Joseph à midi, car ils avaient entendu dire qu'ils devaient y manger du pain. ");
INSERT INTO frasbl_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Lorsque Joseph rentra chez lui, ils lui apportèrent dans la maison le présent qu'ils avaient en main, et se prosternèrent en terre devant lui. ");
INSERT INTO frasbl_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Il les interrogea sur leur bien-être et dit : « Votre père se porte-t-il bien, le vieillard dont vous avez parlé ? Est-il encore en vie ? » ");
INSERT INTO frasbl_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Ils dirent : « Ton serviteur, notre père, se porte bien. Il est encore en vie. » Ils se prosternèrent humblement. ");
INSERT INTO frasbl_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Il leva les yeux et vit Benjamin, son frère, le fils de sa mère, et il dit : « Est-ce là ton plus jeune frère, dont tu m'as parlé ? » Il répondit : « Que Dieu te fasse miséricorde, mon fils. » ");
INSERT INTO frasbl_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Joseph se hâta, car son cœur se languissait de son frère, et il chercha un endroit pour pleurer. Il entra dans sa chambre, et y pleura. ");
INSERT INTO frasbl_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Il se lava le visage, et sortit. Il se maîtrisa, et dit : « Servez le repas. » ");
INSERT INTO frasbl_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Ils le servirent seuls, eux seuls, et les Égyptiens qui mangèrent avec lui seuls, car les Égyptiens ne mangent pas avec les Hébreux, car c'est une abomination pour les Égyptiens. ");
INSERT INTO frasbl_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Ils s'assirent devant lui, le premier-né selon son droit d'aînesse, et le plus jeune selon sa jeunesse, et les hommes s'étonnaient les uns des autres. ");
INSERT INTO frasbl_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Il leur envoya des parts de devant lui, mais la part de Benjamin était cinq fois plus importante que celle de n'importe lequel des leurs. Ils burent et furent joyeux avec lui. ");
INSERT INTO frasbl_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Il donna cet ordre à l'intendant de sa maison : « Remplissez de nourriture les sacs des hommes, autant qu'ils peuvent en porter, et mettez l'argent de chacun dans l'ouverture de son sac. ");
INSERT INTO frasbl_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Mets ma coupe, la coupe d'argent, dans l'ouverture du sac du plus jeune, avec son argent. » Il fit selon la parole que Joseph avait dite. ");
INSERT INTO frasbl_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Dès que le matin se leva, les hommes partirent, eux et leurs ânes. ");
INSERT INTO frasbl_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Lorsqu'ils sortirent de la ville et qu'ils ne furent pas encore loin, Joseph dit à son intendant : « Monte, suis les hommes. Quand tu les auras rattrapés, demande-leur : Pourquoi avez-vous rendu le mal pour le bien ? ");
INSERT INTO frasbl_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","N'est-ce pas là ce que boit mon seigneur et ce par quoi il devine ? Vous avez fait le mal en agissant ainsi ». ");
INSERT INTO frasbl_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Il les rattrapa et leur adressa ces paroles. ");
INSERT INTO frasbl_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Ils lui dirent : « Pourquoi mon seigneur tient-il de tels propos ? Loin de tes serviteurs l'idée de faire une telle chose ! ");
INSERT INTO frasbl_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Voici, l'argent que nous avons trouvé dans la bouche de nos sacs, nous te l'avons rapporté du pays de Canaan. Comment donc voler de l'argent ou de l'or dans la maison de ton seigneur ? ");
INSERT INTO frasbl_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Chez celui de tes serviteurs chez qui on le trouvera, qu'il meure, et nous aussi nous serons les esclaves de mon seigneur. » ");
INSERT INTO frasbl_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Il dit : « Qu'il en soit maintenant ainsi selon vos paroles. Celui chez qui elle sera trouvée sera mon esclave ; et toi, tu seras irréprochable. » ");
INSERT INTO frasbl_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Ils se hâtèrent alors de descendre leur sac à terre, et chacun ouvrit son sac. ");
INSERT INTO frasbl_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Il chercha, en commençant par le plus âgé et en terminant par le plus jeune. La coupe fut trouvée dans le sac de Benjamin. ");
INSERT INTO frasbl_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Puis ils déchirèrent leurs vêtements, chargèrent chacun leur âne et retournèrent à la ville. ");
INSERT INTO frasbl_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Juda et ses frères arrivèrent à la maison de Joseph, et il était encore là. Ils se jetèrent à terre devant lui. ");
INSERT INTO frasbl_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Joseph leur dit : « Quelle est cette action que vous avez commise ? Ne savez-vous pas qu'un homme tel que moi peut effectivement faire de la divination ? ». ");
INSERT INTO frasbl_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Juda dit : « Que dirons-nous à mon seigneur ? Que dirons-nous ? Comment allons-nous nous disculper ? Dieu a découvert l'iniquité de tes serviteurs. Voici, nous sommes les esclaves de mon seigneur, nous et celui dans la main duquel se trouve la coupe. » ");
INSERT INTO frasbl_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Il répondit : « Loin de moi l'idée de faire cela. L'homme dans la main duquel se trouve la coupe sera mon esclave ; quant à toi, monte en paix vers ton père. » ");
INSERT INTO frasbl_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Alors Juda s'approcha de lui, et dit : « Oh, mon seigneur, permets à ton serviteur de dire une parole aux oreilles de mon seigneur, et ne laisse pas ta colère s'enflammer contre ton serviteur, car tu es comme Pharaon. ");
INSERT INTO frasbl_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Mon seigneur a demandé à ses serviteurs : « Avez-vous un père ou un frère ? » ");
INSERT INTO frasbl_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Nous avons répondu à mon seigneur : « Nous avons un père, un vieillard, et un enfant de sa vieillesse, un petit garçon ; son frère est mort, et il reste seul de sa mère ; et son père l'aime. ");
INSERT INTO frasbl_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Tu as dit à tes serviteurs : « Faites-le descendre vers moi, afin que je pose mes yeux sur lui. ");
INSERT INTO frasbl_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Nous avons dit à mon seigneur : « Le garçon ne peut pas quitter son père, car s'il le quittait, son père mourrait. » ");
INSERT INTO frasbl_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Tu as dit à tes serviteurs : « Si ton plus jeune frère ne descend pas avec vous, vous ne verrez plus ma face. ");
INSERT INTO frasbl_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Lorsque nous sommes montés vers ton serviteur, mon père, nous lui avons rapporté les paroles de mon seigneur. ");
INSERT INTO frasbl_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Notre père nous dit : « Retourne acheter un peu de nourriture. ");
INSERT INTO frasbl_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Nous avons répondu : « Nous ne pouvons pas descendre. Si notre plus jeune frère est avec nous, nous descendrons, car nous ne verrons peut-être pas le visage de cet homme, à moins que notre plus jeune frère ne soit avec nous. ");
INSERT INTO frasbl_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Ton serviteur, mon père, nous a dit : « Vous savez que ma femme m'a enfanté deux fils. ");
INSERT INTO frasbl_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","L'un d'eux est sorti de chez moi, et j'ai dit : « Certainement, il est déchiré en morceaux » ; et je ne l'ai pas revu depuis. ");
INSERT INTO frasbl_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Si tu m'enlèves aussi celui-ci, et qu'il lui arrive malheur, tu feras descendre mes cheveux blancs avec tristesse au séjour des morts'. ");
INSERT INTO frasbl_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Maintenant, quand j'arriverai chez ton serviteur, mon père, et que le garçon ne sera pas avec nous, puisque sa vie est liée à celle du garçon, ");
INSERT INTO frasbl_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","il arrivera, quand il verra que le garçon n'est plus, qu'il mourra. Tes serviteurs feront descendre avec douleur au séjour des morts les cheveux blancs de ton serviteur, notre père. ");
INSERT INTO frasbl_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Car ton serviteur s'est porté garant de l'enfant auprès de mon père, en disant : « Si je ne te l'amène pas, c'est moi qui en porterai la responsabilité auprès de mon père pour toujours ». ");
INSERT INTO frasbl_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Maintenant donc, que ton serviteur reste à la place du garçon, esclave de mon seigneur, et que le garçon monte avec ses frères. ");
INSERT INTO frasbl_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Car comment monterai-je vers mon père, si le garçon n'est pas avec moi ? de peur que je ne voie le malheur qui frappera mon père. » ");
INSERT INTO frasbl_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Alors Joseph ne put se maîtriser devant tous ceux qui se tenaient devant lui, et il s'écria : « Que tout le monde sorte de chez moi ! » Personne d'autre ne se tenait avec lui, tandis que Joseph se faisait connaître à ses frères. ");
INSERT INTO frasbl_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Il pleura à haute voix. Les Égyptiens entendirent, et la maison de Pharaon aussi. ");
INSERT INTO frasbl_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Joseph dit à ses frères : « Je suis Joseph. Mon père vit-il encore ? » Ses frères ne purent lui répondre, car ils étaient terrifiés par sa présence. ");
INSERT INTO frasbl_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Joseph dit à ses frères : « Approchez-vous de moi, je vous en prie. » Ils s'approchèrent. Il dit : « Je suis Joseph, votre frère, que vous avez vendu en Égypte. ");
INSERT INTO frasbl_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Maintenant, ne vous affligez pas et ne vous mettez pas en colère contre vous-mêmes, parce que vous m'avez vendu ici, car Dieu m'a envoyé devant vous pour préserver la vie. ");
INSERT INTO frasbl_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Depuis deux ans, la famine sévit dans le pays, et il y a encore cinq ans, pendant lesquels il n'y aura ni labourage ni récolte. ");
INSERT INTO frasbl_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Dieu m'a envoyé devant vous pour vous conserver un reste sur la terre, et pour vous sauver la vie par une grande délivrance. ");
INSERT INTO frasbl_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Ce n'est donc pas toi qui m'as envoyé ici, mais Dieu, qui m'a fait devenir un père pour Pharaon, le maître de toute sa maison, et le souverain de tout le pays d'Égypte. ");
INSERT INTO frasbl_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Dépêche-toi de monter vers mon père et dis-lui : « Voici ce que dit ton fils Joseph : Dieu m'a fait seigneur de toute l'Égypte. Descends vers moi. N'attends pas. ");
INSERT INTO frasbl_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Tu habiteras dans le pays de Gosen, et tu seras près de moi, toi, tes enfants, les enfants de tes enfants, tes troupeaux, tes bêtes et tout ce que tu as. ");
INSERT INTO frasbl_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Là, je pourvoirai à tes besoins, car il y a encore cinq années de famine, de peur que tu ne tombes dans la misère, toi, ta famille et tout ce que tu as. »'' ");
INSERT INTO frasbl_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Voici, tes yeux voient, ainsi que les yeux de mon frère Benjamin, que c'est ma bouche qui te parle. ");
INSERT INTO frasbl_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Tu raconteras à mon père toute ma gloire en Égypte, et tout ce que tu as vu. Tu te dépêcheras de faire descendre mon père ici. » ");
INSERT INTO frasbl_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Il se jeta au cou de son frère Benjamin et pleura, et Benjamin pleura à son cou. ");
INSERT INTO frasbl_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Il embrassa tous ses frères, et pleura sur eux. Après cela, ses frères s'entretinrent avec lui. ");
INSERT INTO frasbl_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Le bruit en fut entendu dans la maison de Pharaon : « Les frères de Joseph sont arrivés. » Cela plut à Pharaon et à ses serviteurs. ");
INSERT INTO frasbl_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Pharaon dit à Joseph : « Dis à tes frères : Fais ceci : Chargez vos bêtes, et partez, partez pour le pays de Canaan. ");
INSERT INTO frasbl_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Prenez votre père et vos enfants, et venez me voir ; je vous donnerai le bien du pays d'Égypte, et vous mangerez la graisse du pays. ");
INSERT INTO frasbl_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Voici ce qu'il vous est ordonné de faire : Prenez des chariots du pays d'Égypte pour vos petits enfants et pour vos femmes, faites venir votre père, et venez. ");
INSERT INTO frasbl_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Et ne vous préoccupez pas de vos biens, car le bien de tout le pays d'Égypte vous appartient. » ");
INSERT INTO frasbl_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Les fils d'Israël firent ainsi. Joseph leur donna des chariots, selon l'ordre de Pharaon, et leur fournit des provisions pour le chemin. ");
INSERT INTO frasbl_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Il donna à chacun d'eux des vêtements de rechange, mais à Benjamin il donna trois cents pièces d'argent et cinq vêtements de rechange. ");
INSERT INTO frasbl_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Il envoya à son père dix ânes chargés des bonnes choses d'Égypte et dix ânesses chargées de grain et de pain et de provisions pour son père en chemin. ");
INSERT INTO frasbl_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Il envoya donc ses frères, qui partirent. Il leur dit : « Veillez à ne pas vous disputer en chemin. » ");
INSERT INTO frasbl_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Ils montèrent d'Égypte et arrivèrent au pays de Canaan, chez Jacob, leur père. ");
INSERT INTO frasbl_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Ils lui dirent : « Joseph vit encore, et il domine sur tout le pays d'Égypte. « Son cœur s'évanouit, car il ne les croyait pas. ");
INSERT INTO frasbl_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Ils lui rapportèrent toutes les paroles de Joseph, qu'il leur avait dites. Lorsqu'il vit les chariots que Joseph avait envoyés pour le transporter, l'esprit de Jacob, leur père, se ranima. ");
INSERT INTO frasbl_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Israël dit : « C'est assez. Joseph, mon fils, est encore en vie. Je vais aller le voir avant de mourir. » ");
INSERT INTO frasbl_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Israël partit avec tout ce qu'il avait, arriva à Beer Schéba, et offrit des sacrifices au Dieu de son père Isaac. ");
INSERT INTO frasbl_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Dieu parla à Israël dans les visions de la nuit, et dit : « Jacob, Jacob ! » Il a dit : « Je suis là. » ");
INSERT INTO frasbl_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Il dit : « Je suis Dieu, le Dieu de ton père. Ne crains pas de descendre en Égypte, car c'est là que je ferai de toi une grande nation. ");
INSERT INTO frasbl_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Je descendrai avec toi en Égypte. Et je te ferai remonter. La main de Joseph fermera tes yeux. » ");
INSERT INTO frasbl_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Jacob se leva de Beer Schéba, et les fils d'Israël portèrent Jacob, leur père, leurs petits enfants et leurs femmes, dans les chariots que Pharaon avait envoyés pour le transporter. ");
INSERT INTO frasbl_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Ils prirent leur bétail et leurs biens, qu'ils avaient acquis au pays de Canaan, et ils entrèrent en Égypte : Jacob, et toute sa descendance avec lui, ");
INSERT INTO frasbl_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","ses fils, et les fils de ses fils avec lui, ses filles, et les filles de ses fils, et il amena toute sa descendance avec lui en Égypte. ");
INSERT INTO frasbl_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Voici les noms des enfants d'Israël qui vinrent en Égypte, de Jacob et de ses fils : Ruben, premier-né de Jacob. ");
INSERT INTO frasbl_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Fils de Ruben : Hanoch, Pallu, Hezron et Carmi. ");
INSERT INTO frasbl_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Fils de Siméon : Jemuel, Jamin, Ohad, Jachin, Zohar et Shaoul, fils d'une Cananéenne. ");
INSERT INTO frasbl_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Fils de Lévi : Gershon, Kehath et Merari. ");
INSERT INTO frasbl_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Fils de Juda : Er, Onan, Shéla, Pérez et Zérach ; mais Er et Onan moururent au pays de Canaan. Les fils de Pérez furent Hetsron et Hamul. ");
INSERT INTO frasbl_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Fils d'Issacar : Tola, Puvah, Iob et Shimron. ");
INSERT INTO frasbl_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Fils de Zabulon : Sered, Elon et Jahleel. ");
INSERT INTO frasbl_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Ce sont là les fils de Léa, qu'elle enfanta à Jacob à Paddan Aram, avec sa fille Dina. Le total des âmes de ses fils et de ses filles était de trente-trois. ");
INSERT INTO frasbl_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Fils de Gad : Ziphion, Haggi, Shuni, Ezbon, Eri, Arodi et Areli. ");
INSERT INTO frasbl_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Fils d'Asher : Imna, Ishva, Ishvi, Beriah, et Serah, leur sœur. Fils de Beria : Héber et Malkiel. ");
INSERT INTO frasbl_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Voici les fils de Zilpa, que Laban donna à Léa, sa fille, et qu'elle enfanta à Jacob : seize âmes. ");
INSERT INTO frasbl_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Fils de Rachel, femme de Jacob : Joseph et Benjamin. ");
INSERT INTO frasbl_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","A Joseph naquirent, au pays d'Égypte, Manassé et Éphraïm, qu'Asenath, fille de Potiphéra, prêtre d'On, lui enfanta. ");
INSERT INTO frasbl_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Fils de Benjamin : Bela, Becher, Ashbel, Gera, Naaman, Ehi, Rosh, Muppim, Huppim et Ard. ");
INSERT INTO frasbl_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Voici les fils de Rachel, qui naquirent à Jacob : tous avaient quatorze âmes. ");
INSERT INTO frasbl_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Fils de Dan : Huschim. ");
INSERT INTO frasbl_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Fils de Nephtali : Jahzeel, Guni, Jezer et Shillem. ");
INSERT INTO frasbl_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Voici les fils de Bilha, que Laban donna à Rachel, sa fille, et qu'elle enfanta à Jacob : tous ceux-là étaient sept. ");
INSERT INTO frasbl_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Toutes les âmes qui vinrent avec Jacob en Égypte, qui étaient sa descendance directe, en plus des femmes des fils de Jacob, toutes les âmes étaient soixante-six. ");
INSERT INTO frasbl_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Les fils de Joseph, qui lui étaient nés en Égypte, étaient au nombre de deux. Toutes les âmes de la maison de Jacob, qui vinrent en Égypte, étaient au nombre de soixante-dix. ");
INSERT INTO frasbl_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Jacob envoya Juda devant lui à Joseph, pour lui montrer le chemin de Gosen, et ils arrivèrent dans le pays de Gosen. ");
INSERT INTO frasbl_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Joseph prépara son char, et monta à la rencontre d'Israël, son père, en Gosen. Il se présenta à lui, se jeta à son cou, et pleura longtemps sur son cou. ");
INSERT INTO frasbl_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Israël dit à Joseph : « Maintenant, laisse-moi mourir, puisque j'ai vu ton visage et que tu vis encore. » ");
INSERT INTO frasbl_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Joseph dit à ses frères et à la maison de son père : « Je vais monter et parler à Pharaon, et je lui dirai : « Mes frères et la maison de mon père, qui étaient au pays de Canaan, sont venus vers moi. ");
INSERT INTO frasbl_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Ces hommes sont des bergers, car ils ont gardé du bétail, et ils ont amené leurs troupeaux, leurs bêtes, et tout ce qu'ils ont. ");
INSERT INTO frasbl_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Lorsque Pharaon vous convoquera et dira : « Quelle est votre profession ? ");
INSERT INTO frasbl_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","vous répondrez : « Tes serviteurs ont gardé le bétail depuis notre jeunesse jusqu'à ce jour, nous et nos pères, et vous pourrez habiter dans le pays de Gosen, car tout berger est en abomination aux Égyptiens ». ");
INSERT INTO frasbl_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Joseph entra et fit un rapport à Pharaon, en disant : « Mon père et mes frères, avec leurs brebis, leurs bœufs et tout ce qui leur appartient, sont sortis du pays de Canaan ; et voici, ils sont dans le pays de Gosen. » ");
INSERT INTO frasbl_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Il prit cinq hommes parmi ses frères, et les présenta à Pharaon. ");
INSERT INTO frasbl_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Pharaon dit à ses frères : « Quelle est votre profession ? » Ils dirent à Pharaon : « Tes serviteurs sont des bergers, nous et nos pères. » ");
INSERT INTO frasbl_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Ils dirent aussi à Pharaon : « Nous sommes venus vivre comme des étrangers dans le pays, car il n'y a pas de pâturage pour les troupeaux de tes serviteurs. Car la famine sévit dans le pays de Canaan. Laisse donc tes serviteurs habiter dans le pays de Gosen. » ");
INSERT INTO frasbl_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Pharaon parla à Joseph, et dit : Ton père et tes frères sont venus vers toi. ");
INSERT INTO frasbl_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Le pays d'Égypte est devant toi. Fais habiter ton père et tes frères dans le meilleur du pays. Qu'ils habitent dans le pays de Gosen. Si tu connais parmi eux des hommes capables, confie-leur la garde de mon bétail. » ");
INSERT INTO frasbl_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Joseph fit venir Jacob, son père, et le plaça devant Pharaon ; et Jacob bénit Pharaon. ");
INSERT INTO frasbl_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Pharaon dit à Jacob : « Quel âge as-tu ? » ");
INSERT INTO frasbl_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Jacob dit à Pharaon : « Les années de mon pèlerinage sont de cent trente ans. Les jours des années de ma vie ont été peu nombreux et mauvais. Ils n'ont pas atteint les jours des années de la vie de mes pères, aux jours de leur pèlerinage. » ");
INSERT INTO frasbl_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Jacob bénit Pharaon, et sortit de la présence de Pharaon. ");
INSERT INTO frasbl_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Joseph plaça son père et ses frères, et leur donna une possession au pays d'Égypte, dans le meilleur du pays, au pays de Ramsès, comme Pharaon l'avait ordonné. ");
INSERT INTO frasbl_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Joseph fournit du pain à son père, à ses frères et à toute la famille de son père, selon la taille de leurs familles. ");
INSERT INTO frasbl_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Il n'y avait pas de pain dans tout le pays, car la famine était très forte, de sorte que le pays d'Égypte et le pays de Canaan s'éteignirent à cause de la famine. ");
INSERT INTO frasbl_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Joseph rassembla tout l'argent qui se trouvait dans le pays d'Égypte et dans le pays de Canaan, pour le blé qu'on achetait, et il apporta l'argent dans la maison de Pharaon. ");
INSERT INTO frasbl_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Lorsque tout l'argent fut dépensé dans le pays d'Égypte et dans le pays de Canaan, tous les Égyptiens vinrent trouver Joseph et dirent : « Donne-nous du pain, car pourquoi mourrions-nous en ta présence ? Car notre argent manque. » ");
INSERT INTO frasbl_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Joseph dit : « Donne-moi ton bétail, et je te donnerai de la nourriture pour ton bétail, si ton argent a disparu. » ");
INSERT INTO frasbl_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Ils amenèrent leur bétail à Joseph, qui leur donna du pain en échange des chevaux, des troupeaux, des bœufs et des ânes, et il les nourrit de pain en échange de tout leur bétail pour cette année-là. ");
INSERT INTO frasbl_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Lorsque cette année fut terminée, ils vinrent le trouver la deuxième année et lui dirent : « Nous ne cacherons pas à mon seigneur que tout notre argent est dépensé, et que les troupeaux de bétail appartiennent à mon seigneur. Il ne reste plus aux yeux de mon seigneur que nos corps et nos terres. ");
INSERT INTO frasbl_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Pourquoi mourrions-nous sous tes yeux, nous et nos terres ? Achète-nous du pain, nous et nos terres, et nous serons, nous et nos terres, les serviteurs de Pharaon. Donne-nous de la semence, afin que nous vivions et ne mourions pas, et que le pays ne soit pas dévasté. » ");
INSERT INTO frasbl_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Joseph acheta tout le pays d'Égypte pour Pharaon, car chacun des Égyptiens vendit son champ, car la famine les frappait, et le pays devint la propriété de Pharaon. ");
INSERT INTO frasbl_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Quant au peuple, il le déplaça dans les villes, d'un bout à l'autre de la frontière de l'Égypte. ");
INSERT INTO frasbl_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Mais il n'acheta pas les terres des prêtres, car les prêtres avaient une part de Pharaon et mangeaient la part que Pharaon leur donnait. C'est pourquoi ils n'ont pas vendu leurs terres. ");
INSERT INTO frasbl_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Joseph dit alors au peuple : « Voici que je vous ai achetés aujourd'hui, vous et vos terres, pour Pharaon. Voici de la semence pour vous, et vous ensemencerez la terre. ");
INSERT INTO frasbl_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Aux récoltes, vous donnerez un cinquième à Pharaon, et quatre parts vous appartiendront, pour la semence des champs, pour votre nourriture, pour celle de vos familles et pour celle de vos petits enfants. » ");
INSERT INTO frasbl_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Ils dirent : « Tu nous as sauvé la vie ! Que nous trouvions grâce aux yeux de mon seigneur, et nous serons les serviteurs de Pharaon. » ");
INSERT INTO frasbl_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Joseph fit une loi sur le pays d'Égypte, jusqu'à ce jour, pour que Pharaon ait le cinquième. Seule la terre des prêtres ne devint pas la propriété de Pharaon. ");
INSERT INTO frasbl_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Israël habita au pays d'Égypte, dans le pays de Gosen ; ils y acquirent des biens, furent féconds et multiplièrent beaucoup. ");
INSERT INTO frasbl_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Jacob vécut dix-sept ans au pays d'Égypte. Les jours de Jacob, les années de sa vie, furent donc de cent quarante-sept ans. ");
INSERT INTO frasbl_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Le temps où Israël devait mourir approchait. Il appela son fils Joseph et lui dit : « Si j'ai trouvé grâce à tes yeux, mets ta main sous ma cuisse et traite-moi avec bonté et sincérité. Ne m'enterre pas en Égypte, ");
INSERT INTO frasbl_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","mais quand je dormirai avec mes pères, tu me transporteras hors d'Égypte et tu m'enterreras dans leur sépulture. » Joseph a dit : « Je ferai ce que vous avez dit. » ");
INSERT INTO frasbl_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Israël dit : « Jure-le-moi », et il le lui jura. Puis Israël se prosterna sur la tête du lit. ");
INSERT INTO frasbl_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Après ces choses, quelqu'un dit à Joseph : « Voici ton père qui est malade. » Il prit avec lui ses deux fils, Manassé et Éphraïm. ");
INSERT INTO frasbl_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Quelqu'un en informa Jacob, et dit : « Voici ton fils Joseph qui vient vers toi. » Israël se fortifia, et s'assit sur le lit. ");
INSERT INTO frasbl_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Jacob dit à Joseph : « Le Dieu tout-puissant m'est apparu à Luz, au pays de Canaan, et il m'a béni. ");
INSERT INTO frasbl_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Il m'a dit : « Voici, je te rendrai fécond, je te multiplierai, je ferai de toi une multitude de peuples, et je donnerai ce pays à ta postérité après toi, comme possession éternelle. ");
INSERT INTO frasbl_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Or, tes deux fils, qui te sont nés au pays d'Égypte avant que je ne vienne vers toi en Égypte, sont à moi ; Éphraïm et Manassé, comme Ruben et Siméon, seront à moi. ");
INSERT INTO frasbl_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Ta descendance, que tu auras engendrée après eux, sera à toi. Ils seront appelés du nom de leurs frères dans leur héritage. ");
INSERT INTO frasbl_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Quant à moi, quand je suis venu de Paddan, Rachel est morte près de moi au pays de Canaan, en chemin, alors qu'il y avait encore de la distance à parcourir jusqu'à Éphrata, et je l'ai enterrée là, sur le chemin d'Éphrata (appelée aussi Bethléem). » ");
INSERT INTO frasbl_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Israël vit les fils de Joseph, et dit : « Qui sont ceux-ci ? » ");
INSERT INTO frasbl_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Joseph dit à son père : « Ce sont mes fils, que Dieu m'a donnés ici. » Il dit : « Amène-les-moi, je te prie, et je les bénirai. » ");
INSERT INTO frasbl_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Or les yeux d'Israël s'étaient obscurcis à cause de l'âge, de sorte qu'il ne voyait pas bien. Joseph les fit approcher de lui ; il les embrassa et les serra dans ses bras. ");
INSERT INTO frasbl_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Israël dit à Joseph : « Je ne pensais pas voir ton visage, et voici que Dieu m'a permis de voir aussi ta descendance. » ");
INSERT INTO frasbl_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Joseph les fit sortir d'entre ses genoux, et il se prosterna, le visage tourné vers la terre. ");
INSERT INTO frasbl_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Joseph les prit tous deux, Éphraïm dans sa main droite vers la main gauche d`Israël, et Manassé dans sa main gauche vers la main droite d`Israël, et il les fit approcher de lui. ");
INSERT INTO frasbl_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Israël étendit sa main droite et la posa sur la tête d'Ephraïm, qui était le plus jeune, et sa main gauche sur la tête de Manassé, guidant sciemment ses mains, car Manassé était le premier-né. ");
INSERT INTO frasbl_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Il bénit Joseph, et dit, « Le Dieu devant lequel mes pères Abraham et Isaac ont marché, le Dieu qui m'a nourri toute ma vie jusqu'à aujourd'hui, ");
INSERT INTO frasbl_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","l'ange qui m'a racheté de tout mal, bénis les gars, et que mon nom soit nommé sur eux, et le nom de mes pères, Abraham et Isaac. Qu'ils deviennent une multitude sur la terre. » ");
INSERT INTO frasbl_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Lorsque Joseph vit que son père posait sa main droite sur la tête d'Ephraïm, cela lui déplut. Il leva la main de son père, pour la faire passer de la tête d'Ephraïm à celle de Manassé. ");
INSERT INTO frasbl_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Joseph dit à son père : « Pas ainsi, mon père, car c'est le premier-né. Pose ta main droite sur sa tête. » ");
INSERT INTO frasbl_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Son père refusa, et dit : « Je le sais, mon fils, je le sais. Lui aussi deviendra un peuple, et lui aussi sera grand. Mais son jeune frère sera plus grand que lui, et sa descendance deviendra une multitude de nations. » ");
INSERT INTO frasbl_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Il les bénit ce jour-là, en disant : « Israël bénira en vous, en disant : 'Que Dieu vous fasse comme Ephraïm et comme Manassé'\" Il plaça Ephraïm devant Manassé. ");
INSERT INTO frasbl_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Israël dit à Joseph : « Voici, je meurs, mais Dieu sera avec toi, et il te ramènera dans le pays de tes pères. ");
INSERT INTO frasbl_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","De plus, je t'ai donné une part au-dessus de tes frères, que j'ai arrachée de la main de l'Amoréen avec mon épée et avec mon arc. » ");
INSERT INTO frasbl_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Jacob appela ses fils, et dit : « Réunissez-vous, afin que je vous dise ce qui vous arrivera dans les jours à venir. ");
INSERT INTO frasbl_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Assemblez-vous, et écoutez, fils de Jacob. Écoutez Israël, votre père. ");
INSERT INTO frasbl_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","« Ruben, tu es mon premier-né, ma force et le commencement de ma puissance, excellant dans la dignité, et excellant dans le pouvoir. ");
INSERT INTO frasbl_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Bouillant comme de l'eau, tu n'excelleras pas, parce que tu es monté dans le lit de ton père, puis l'a souillé. Il est monté sur mon canapé. ");
INSERT INTO frasbl_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","« Siméon et Lévi sont frères. Leurs épées sont des armes de violence. ");
INSERT INTO frasbl_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Mon âme, n'entre pas dans leur conseil. Ma gloire, ne t'unis pas à leur assemblée ; car dans leur colère, ils ont tué des hommes. Dans leur volonté, ils ont paralysé le bétail. ");
INSERT INTO frasbl_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Maudite soit leur colère, car elle était féroce ; et leur colère, car elle était cruelle. Je les diviserai en Jacob, et les disperser en Israël. ");
INSERT INTO frasbl_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","« Juda, tes frères te loueront. Ta main sera sur le cou de tes ennemis. Les fils de ton père se prosterneront devant toi. ");
INSERT INTO frasbl_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Juda est un lionceau. De la proie, mon fils, tu t'es élevé. Il s'est baissé, il s'est accroupi comme un lion, comme une lionne. Qui va le réveiller ? ");
INSERT INTO frasbl_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Le sceptre ne s'éloignera pas de Juda, ni le bâton du chef d'entre ses pieds, jusqu'à ce que vienne celui à qui elle appartient. L'obéissance des peuples lui reviendra. ");
INSERT INTO frasbl_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Liant son poulain à la vigne, le petit de son âne à la vigne de choix, il a lavé ses vêtements dans le vin, ses robes dans le sang des raisins. ");
INSERT INTO frasbl_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Ses yeux seront rouges de vin, ses dents blanches de lait. ");
INSERT INTO frasbl_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","« Zabulon habitera au havre de la mer. Il sera pour un port de navires. Sa frontière sera sur Sidon. ");
INSERT INTO frasbl_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","« Issachar est un âne fort, couché entre les sacoches. ");
INSERT INTO frasbl_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Il a vu un lieu de repos, et il a constaté qu'il était bon, le pays, qu'il était agréable. Il courbe l'épaule devant le fardeau, et devient un serviteur aux travaux forcés. ");
INSERT INTO frasbl_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","« Dan jugera son peuple, comme l'une des tribus d'Israël. ");
INSERT INTO frasbl_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan sera un serpent sur la piste, un additionneur dans le chemin, qui mord les talons du cheval, de sorte que son cavalier tombe en arrière. ");
INSERT INTO frasbl_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","J'ai attendu ton salut, Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","« Une troupe va presser sur Gad, mais il appuiera sur leur talon. ");
INSERT INTO frasbl_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","« La nourriture d'Asher sera riche. Il produira des mets royaux. ");
INSERT INTO frasbl_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","« Nephtali est une biche en liberté, qui porte de beaux fauves. ");
INSERT INTO frasbl_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","« Joseph est une vigne féconde, une vigne fructueuse près d'une source. Ses branches courent sur le mur. ");
INSERT INTO frasbl_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Les archers l'ont gravement blessé, lui ont tiré dessus, et l'ont persécuté : ");
INSERT INTO frasbl_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Mais son arc est resté fort. Les bras de ses mains ont été rendus forts, par les mains du Puissant de Jacob, (c'est de là que vient le berger, la pierre d'Israël), ");
INSERT INTO frasbl_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","même par le Dieu de ton père, qui t'aidera, par le Tout-Puissant, qui vous bénira, avec les bénédictions du ciel, les bénédictions des profondeurs qui se trouvent en dessous, les bénédictions des seins et de l'utérus. ");
INSERT INTO frasbl_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Les bénédictions de ton père ont prévalu sur les bénédictions de mes ancêtres, au-dessus des limites des anciennes collines. Ils seront sur la tête de Joseph, sur la couronne de la tête de celui qui est séparé de ses frères. ");
INSERT INTO frasbl_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","« Benjamin est un loup vorace. Au matin, il dévorera la proie. Le soir, il partagera le butin. » ");
INSERT INTO frasbl_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Ce sont là les douze tribus d'Israël. Voici ce que leur père leur a dit, et il les a bénies. Il bénit chacun selon sa propre bénédiction. ");
INSERT INTO frasbl_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Il les instruisit et leur dit : « Je vais être recueilli auprès de mon peuple. Enterrez-moi avec mes pères dans la caverne qui est dans le champ d'Éphron le Héthien, ");
INSERT INTO frasbl_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","dans la caverne qui est dans le champ de Macpéla, en face de Mamré, dans le pays de Canaan, qu'Abraham acheta avec le champ d'Éphron le Héthien pour y être enterré. ");
INSERT INTO frasbl_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","C'est là qu'on enterra Abraham et Sarah, sa femme. C'est là qu'on a enterré Isaac et Rebecca, sa femme, et c'est là que j'ai enterré Léa. ");
INSERT INTO frasbl_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Le champ et la caverne qui s'y trouve ont été achetés des fils de Heth. » ");
INSERT INTO frasbl_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Lorsque Jacob eut fini de charger ses fils, il ramassa ses pieds dans le lit, rendit son dernier soupir et fut recueilli auprès de son peuple. ");
INSERT INTO frasbl_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Joseph tomba sur le visage de son père, pleura sur lui et le baisa. ");
INSERT INTO frasbl_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Joseph ordonna à ses serviteurs, les médecins, d'embaumer son père ; et les médecins embaumèrent Israël. ");
INSERT INTO frasbl_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","On lui consacra quarante jours, car c'est le nombre de jours qu'il faut pour embaumer. Les Égyptiens pleurèrent Israël pendant soixante-dix jours. ");
INSERT INTO frasbl_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Lorsque les jours où il pleurait furent écoulés, Joseph s'adressa au bâton de Pharaon, en disant : « Si maintenant j'ai trouvé grâce à tes yeux, parle aux oreilles de Pharaon, en disant : ");
INSERT INTO frasbl_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Mon père m'a fait jurer en disant : « Voici, je meurs. Enterre-moi dans le tombeau que je me suis creusé au pays de Canaan. » Maintenant, laisse-moi monter et enterrer mon père, et je reviendrai. » ");
INSERT INTO frasbl_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Pharaon dit : « Monte, et enterre ton père, comme il te l'a fait jurer. » ");
INSERT INTO frasbl_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Joseph monta pour enterrer son père ; et avec lui montèrent tous les serviteurs de Pharaon, les anciens de sa maison, tous les anciens du pays d'Égypte, ");
INSERT INTO frasbl_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","toute la maison de Joseph, ses frères et la maison de son père. Ils ne laissèrent dans le pays de Gosen que leurs petits enfants, leurs brebis et leurs bœufs. ");
INSERT INTO frasbl_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Des chars et des cavaliers montèrent avec lui. C'était une très grande troupe. ");
INSERT INTO frasbl_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Ils arrivèrent à l'aire d'Atad, qui est de l'autre côté du Jourdain, et là ils se lamentèrent d'une manière très grande et très sévère. Il porta le deuil de son père pendant sept jours. ");
INSERT INTO frasbl_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Lorsque les habitants du pays, les Cananéens, virent le deuil dans l'aire d'Atad, ils dirent : « C'est là un deuil très grave chez les Égyptiens. » C'est pourquoi on l'appela Abel Mizraim, qui est au-delà du Jourdain. ");
INSERT INTO frasbl_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Ses fils lui firent ce qu'il leur avait ordonné, ");
INSERT INTO frasbl_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","car ses fils le transportèrent au pays de Canaan et l'enterrèrent dans la grotte du champ de Macpéla, qu'Abraham avait achetée avec le champ, comme possession pour une sépulture, à Ephron le Hittite, près de Mamré. ");
INSERT INTO frasbl_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Joseph retourna en Égypte, lui et ses frères, et tous ceux qui étaient montés avec lui pour enterrer son père, après qu'il eut enterré son père. ");
INSERT INTO frasbl_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Lorsque les frères de Joseph virent que leur père était mort, ils dirent : « Il se peut que Joseph nous haïsse et qu'il nous rembourse entièrement tout le mal que nous lui avons fait. » ");
INSERT INTO frasbl_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Ils envoyèrent un message à Joseph en disant : « Avant de mourir, ton père a donné cet ordre : ");
INSERT INTO frasbl_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","Tu diras à Joseph : « Maintenant, pardonne la désobéissance de tes frères et leur péché, car ils t'ont fait du mal. » Maintenant, pardonnez la désobéissance des serviteurs du Dieu de votre père. » Joseph pleura quand ils lui parlèrent. ");
INSERT INTO frasbl_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Ses frères allèrent aussi se prosterner devant lui, et ils dirent : « Voici, nous sommes tes serviteurs. » ");
INSERT INTO frasbl_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Joseph leur dit : « N'ayez pas peur, car suis-je à la place de Dieu ? ");
INSERT INTO frasbl_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Quant à vous, vous avez voulu le mal contre moi, mais Dieu l'a voulu en bien, pour sauver beaucoup de gens en vie, comme cela arrive aujourd'hui. ");
INSERT INTO frasbl_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Ne crains donc pas maintenant. Je subviendrai à vos besoins et à ceux de vos enfants. » Il les réconforta et leur parla avec bonté. ");
INSERT INTO frasbl_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Joseph vécut en Égypte, lui et la maison de son père. Joseph vécut cent dix ans. ");
INSERT INTO frasbl_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Joseph vit les enfants d'Éphraïm jusqu'à la troisième génération. Les enfants de Makir, fils de Manassé, naquirent aussi sur les genoux de Joseph. ");
INSERT INTO frasbl_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Joseph dit à ses frères : « Je meurs, mais Dieu vous visitera et vous fera monter de ce pays dans le pays qu'il a juré à Abraham, à Isaac et à Jacob. » ");
INSERT INTO frasbl_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Joseph fit prêter serment aux enfants d'Israël, en disant : « Dieu vous visitera certainement, et vous ferez monter mes ossements d'ici. » ");
INSERT INTO frasbl_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Joseph mourut donc, âgé de cent dix ans, on l'embauma et on le mit dans un cercueil en Égypte. ");
INSERT INTO frasbl_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Voici les noms des fils d'Israël qui vinrent en Égypte (chaque homme et sa famille vinrent avec Jacob) : ");
INSERT INTO frasbl_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ruben, Siméon, Lévi et Juda, ");
INSERT INTO frasbl_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Issacar, Zabulon et Benjamin, ");
INSERT INTO frasbl_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan et Nephtali, Gad et Asher. ");
INSERT INTO frasbl_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Toutes les âmes qui sortirent du corps de Jacob étaient au nombre de soixante-dix, et Joseph était déjà en Égypte. ");
INSERT INTO frasbl_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Joseph mourut, ainsi que tous ses frères et toute cette génération. ");
INSERT INTO frasbl_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Les enfants d'Israël furent féconds, ils augmentèrent en abondance, ils se multiplièrent, ils devinrent extrêmement puissants, et le pays fut rempli d'eux. ");
INSERT INTO frasbl_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Or, il se leva un nouveau roi sur l'Égypte, qui ne connaissait pas Joseph. ");
INSERT INTO frasbl_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Il dit à son peuple : « Voici que le peuple des enfants d'Israël est plus nombreux et plus puissant que nous. ");
INSERT INTO frasbl_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Venez, traitons-les avec sagesse, de peur qu'ils ne se multiplient et que, lorsqu'une guerre éclatera, ils ne se joignent à nos ennemis, ne nous combattent et ne s'échappent du pays. » ");
INSERT INTO frasbl_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Ils établirent donc sur eux des maîtres de corvées pour les accabler de leurs fardeaux. Ils construisirent des villes de stockage pour Pharaon : Pithom et Raamsès. ");
INSERT INTO frasbl_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Mais plus ils les accablaient, plus ils se multipliaient et plus ils s'étendaient. Ils se mirent à redouter les enfants d'Israël. ");
INSERT INTO frasbl_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Les Égyptiens firent servir les enfants d'Israël sans pitié, ");
INSERT INTO frasbl_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","et ils leur rendirent la vie amère par un dur service dans le mortier et dans la brique, et par toutes sortes de services dans les champs, tous leurs services, dans lesquels ils les firent servir sans pitié. ");
INSERT INTO frasbl_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Le roi d'Égypte parla aux sages-femmes hébraïques, dont l'une s'appelait Shiphrah et l'autre Puah, ");
INSERT INTO frasbl_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","et il dit : « Lorsque vous exercerez la fonction de sage-femme auprès des femmes hébraïques et que vous les verrez sur l'escabeau, si c'est un fils, vous le tuerez ; mais si c'est une fille, elle vivra. » ");
INSERT INTO frasbl_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Mais les sages-femmes craignirent Dieu et ne firent pas ce que le roi d'Égypte leur avait ordonné, mais elles sauvèrent les petits garçons vivants. ");
INSERT INTO frasbl_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Le roi d'Égypte fit venir les sages-femmes et leur dit : « Pourquoi avez-vous fait cela et sauvé les garçons en vie ? ». ");
INSERT INTO frasbl_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Les sages-femmes dirent à Pharaon : « Parce que les femmes hébreues ne sont pas comme les Egyptiennes, car elles sont vigoureuses et accouchent avant que la sage-femme ne vienne les voir. » ");
INSERT INTO frasbl_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Dieu traita bien les sages-femmes, et le peuple se multiplia et devint très puissant. ");
INSERT INTO frasbl_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Comme les sages-femmes craignaient Dieu, il leur donna des familles. ");
INSERT INTO frasbl_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Pharaon donna cet ordre à tout son peuple : « Vous jetterez dans le fleuve tout fils qui naîtra, et vous sauverez vivante toute fille. » ");
INSERT INTO frasbl_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Un homme de la maison de Lévi alla prendre pour femme une fille de Lévi. ");
INSERT INTO frasbl_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","La femme conçut et enfanta un fils. Elle vit que c'était un bel enfant, et elle le cacha pendant trois mois. ");
INSERT INTO frasbl_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Quand elle ne put plus le cacher, elle prit pour lui un panier de papyrus, qu'elle enduisit de goudron et de poix. Elle y mit l'enfant, et le déposa dans les roseaux au bord du fleuve. ");
INSERT INTO frasbl_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Sa sœur se tenait à l'écart, pour voir ce qu'on lui ferait. ");
INSERT INTO frasbl_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","La fille de Pharaon descendit pour se baigner au bord du fleuve. Ses servantes se promenaient au bord du fleuve. Elle vit la corbeille parmi les roseaux, et envoya son serviteur la chercher. ");
INSERT INTO frasbl_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Elle l'ouvrit, vit l'enfant, et voici que l'enfant pleurait. Elle eut pitié de lui et dit : « C'est un des enfants des Hébreux. » ");
INSERT INTO frasbl_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Alors sa sœur dit à la fille de Pharaon : « Dois-je aller appeler pour toi une nourrice parmi les femmes hébreues, afin qu'elle allaite l'enfant pour toi ? » ");
INSERT INTO frasbl_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","La fille de Pharaon lui dit : « Va. » La jeune femme alla appeler la mère de l'enfant. ");
INSERT INTO frasbl_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","La fille de Pharaon lui dit : « Emmène cet enfant et allaite-le pour moi, et je te donnerai ton salaire. » La femme prit l'enfant et le soigna. ");
INSERT INTO frasbl_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","L'enfant grandit, elle l'amena à la fille de Pharaon, et il devint son fils. Elle lui donna le nom de Moïse, et dit : « Parce que je l'ai tiré de l'eau. » ");
INSERT INTO frasbl_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","En ces jours-là, lorsque Moïse eut grandi, il alla vers ses frères et vit leurs fardeaux. Il vit un Égyptien qui frappait un Hébreu, l'un de ses frères. ");
INSERT INTO frasbl_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Il regarda de tous côtés, et voyant qu'il n'y avait personne, il tua l'Egyptien et le cacha dans le sable. ");
INSERT INTO frasbl_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Le deuxième jour, il sortit, et voici que deux hommes d'entre les Hébreux se battaient l'un contre l'autre. Il dit à celui qui avait fait le mal : « Pourquoi frappes-tu ton compagnon ? » ");
INSERT INTO frasbl_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Il dit : « Qui t'a fait prince et juge sur nous ? As-tu l'intention de me tuer, comme tu as tué l'Égyptien ? » Moïse eut peur, et il dit : « Cette chose est certainement connue. » ");
INSERT INTO frasbl_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Lorsque Pharaon apprit cette chose, il chercha à faire mourir Moïse. Mais Moïse s'enfuit de la face de Pharaon, et habita dans le pays de Madian, et il s'assit près d'un puits. ");
INSERT INTO frasbl_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Or le prêtre de Madian avait sept filles. Elles venaient puiser de l'eau et remplissaient les auges pour abreuver le troupeau de leur père. ");
INSERT INTO frasbl_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Les bergers vinrent et les chassèrent, mais Moïse se leva, les aida et abreuva le troupeau. ");
INSERT INTO frasbl_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Lorsqu'elles arrivèrent auprès de Réuel, leur père, celui-ci leur dit : « Comment se fait-il que vous soyez rentrées si tôt aujourd'hui ? ». ");
INSERT INTO frasbl_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Ils dirent : « Un Égyptien nous a délivrés de la main des bergers ; de plus, il a puisé de l'eau pour nous et abreuvé le troupeau. » ");
INSERT INTO frasbl_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Il dit à ses filles : « Où est-il ? Pourquoi avez-vous laissé cet homme ? Appelez-le, qu'il mange du pain. » ");
INSERT INTO frasbl_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Moïse se contenta d'habiter avec cet homme. Il donna à Moïse Zippora, sa fille. ");
INSERT INTO frasbl_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Elle enfanta un fils, qu'il appela Gershom, car il disait : « J'ai vécu comme un étranger dans un pays étranger. » ");
INSERT INTO frasbl_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Au cours de ces nombreux jours, le roi d'Égypte mourut, et les enfants d'Israël poussèrent des soupirs à cause de la servitude, et ils crièrent, et leur cri monta vers Dieu à cause de la servitude. ");
INSERT INTO frasbl_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Dieu entendit leurs gémissements, et il se souvint de son alliance avec Abraham, Isaac et Jacob. ");
INSERT INTO frasbl_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Dieu vit les enfants d'Israël, et il comprit. ");
INSERT INTO frasbl_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Moïse gardait le troupeau de Jéthro, son beau-père, prêtre de Madian. Il conduisit le troupeau au fond du désert et arriva à la montagne de Dieu, à Horeb. ");
INSERT INTO frasbl_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","L'ange de Yahvé lui apparut dans une flamme de feu, au milieu d'un buisson. Il regarda, et voici, le buisson brûlait de feu, et le buisson ne se consumait pas. ");
INSERT INTO frasbl_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Moïse dit : « Je vais maintenant aller voir ce grand spectacle, pourquoi le buisson ne se consume pas. » ");
INSERT INTO frasbl_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Lorsque Yahvé vit qu'il venait pour voir, Dieu l'appela du milieu du buisson et dit : « Moïse ! Moïse ! » Il a dit : « Je suis là. » ");
INSERT INTO frasbl_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Il dit : « N'approchez pas. Enlève tes sandales, car le lieu sur lequel tu te tiens est une terre sainte. » ");
INSERT INTO frasbl_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Il dit encore : « Je suis le Dieu de ton père, le Dieu d'Abraham, le Dieu d'Isaac et le Dieu de Jacob. » Moïse a caché son visage parce qu'il avait peur de regarder Dieu. ");
INSERT INTO frasbl_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Yahvé dit : « J'ai vu la détresse de mon peuple qui est en Égypte, j'ai entendu ses cris à cause de ses maîtres, car je connais ses souffrances. ");
INSERT INTO frasbl_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Je suis descendu pour les délivrer de la main des Égyptiens et pour les faire monter de ce pays dans un bon et vaste pays, dans un pays où coulent le lait et le miel, dans le lieu où vivent les Cananéens, les Héthiens, les Amoréens, les Phéréziens, les Héviens et les Jébusiens. ");
INSERT INTO frasbl_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Maintenant, voici, le cri des enfants d'Israël est venu jusqu'à moi. Et j'ai vu l'oppression que leur font subir les Égyptiens. ");
INSERT INTO frasbl_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Viens donc maintenant, et je t'enverrai vers Pharaon, afin que tu fasses sortir d'Égypte mon peuple, les enfants d'Israël. » ");
INSERT INTO frasbl_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Moïse dit à Dieu : « Qui suis-je, pour aller vers Pharaon, et pour faire sortir d'Égypte les enfants d'Israël ? » ");
INSERT INTO frasbl_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Il dit : « Certainement, je serai avec toi. Ceci sera pour toi le signe que je t'ai envoyé : quand tu auras fait sortir le peuple d'Égypte, tu serviras Dieu sur cette montagne. » ");
INSERT INTO frasbl_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Moïse dit à Dieu : « Voici, quand je viendrai vers les enfants d'Israël et que je leur dirai : « Le Dieu de vos pères m'a envoyé vers vous », et qu'ils me demanderont : « Quel est son nom ? », que leur dirai-je ? » ");
INSERT INTO frasbl_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Dieu dit à Moïse : « JE SUIS QUI JE SUIS », et il ajouta : « Tu diras ceci aux enfants d'Israël : « Je Suis, je vous ai envoyé. » ");
INSERT INTO frasbl_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Dieu dit encore à Moïse : « Tu diras aux enfants d'Israël : « Yahvé, le Dieu de vos pères, le Dieu d'Abraham, le Dieu d'Isaac et le Dieu de Jacob, m'a envoyé vers vous. C'est là mon nom pour toujours, et c'est là mon souvenir pour toutes les générations. ");
INSERT INTO frasbl_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Allez rassembler les anciens d'Israël et dites-leur : « Yahvé, le Dieu de vos pères, le Dieu d'Abraham, d'Isaac et de Jacob, m'est apparu et m'a dit : Je vous ai visités et j'ai vu ce qu'on vous a fait en Égypte. ");
INSERT INTO frasbl_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","J'ai dit : Je vous ferai monter de la détresse de l'Égypte au pays des Cananéens, des Héthiens, des Amoréens, des Phéréziens, des Héviens et des Jébusiens, dans un pays où coulent le lait et le miel ». ");
INSERT INTO frasbl_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Ils écouteront ta voix. Tu iras, toi et les anciens d'Israël, vers le roi d'Égypte et tu lui diras : « Yahvé, le Dieu des Hébreux, nous a rencontrés. Laisse-nous maintenant faire trois jours de marche dans le désert, afin que nous puissions sacrifier à Yahvé, notre Dieu. ");
INSERT INTO frasbl_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Je sais que le roi d'Égypte ne vous donnera pas la permission de partir, non, pas par une main puissante. ");
INSERT INTO frasbl_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","J'étendrai ma main et je frapperai l'Égypte par tous les prodiges que je ferai au milieu d'elle, et après cela, il vous laissera partir. ");
INSERT INTO frasbl_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","J'accorderai à ce peuple une faveur aux yeux des Égyptiens, et il arrivera que, lorsque vous partirez, vous ne partirez pas les mains vides. ");
INSERT INTO frasbl_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Mais chaque femme demandera à sa voisine et à celle qui visite sa maison des bijoux d'argent, des bijoux d'or et des vêtements. Vous les mettrez sur vos fils et sur vos filles. Vous pillerez les Égyptiens. » ");
INSERT INTO frasbl_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Moïse répondit : « Mais voici qu'ils ne me croiront pas et n'écouteront pas ma voix, car ils diront : « Yahvé ne t'est pas apparu »\". ");
INSERT INTO frasbl_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Yahvé lui dit : « Qu'est-ce que tu as dans la main ? » Il a dit : « Une baguette. » ");
INSERT INTO frasbl_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Il a dit : « Jette-la par terre. » Il la jeta par terre, et elle devint un serpent ; Moïse s'en enfuit. ");
INSERT INTO frasbl_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Yahvé dit à Moïse : « Étends ta main, et prends-le par la queue. » Il étendit la main et la saisit, et elle devint une verge dans sa main. ");
INSERT INTO frasbl_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","« C'est afin qu'ils croient que Yahvé, le Dieu de leurs pères, le Dieu d'Abraham, le Dieu d'Isaac et le Dieu de Jacob, t'est apparu ». ");
INSERT INTO frasbl_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Yahvé lui dit encore : « Mets maintenant ta main dans ton manteau. » Il mit sa main dans son manteau, et quand il la retira, voici que sa main était lépreuse, blanche comme la neige. ");
INSERT INTO frasbl_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Il dit : « Remets ta main dans ton manteau. » Il remit sa main dans son manteau, et quand il la retira de son manteau, voici qu'elle était redevenue comme son autre chair. ");
INSERT INTO frasbl_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","S'ils ne te croient pas et n'écoutent pas la voix du premier signe, ils croiront la voix du second signe. ");
INSERT INTO frasbl_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","S'ils ne croient pas à ces deux signes et n'écoutent pas ta voix, tu prendras de l'eau du fleuve et tu la répandras sur la terre ferme. L'eau que tu prendras du fleuve deviendra du sang sur la terre ferme. » ");
INSERT INTO frasbl_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Moïse dit à Yahvé : « Seigneur, je ne suis pas éloquent, ni avant, ni depuis que tu parles à ton serviteur ; car je suis lent à parler et j'ai la langue lente. » ");
INSERT INTO frasbl_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Yahvé lui dit : « Qui a fait la bouche de l'homme ? Ou qui rend muet, ou sourd, ou voyant, ou aveugle ? N'est-ce pas moi, Yahvé ? ");
INSERT INTO frasbl_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Va donc maintenant, et je serai avec ta bouche, et je t'enseignerai ce que tu dois dire. » ");
INSERT INTO frasbl_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Moïse dit : « Oh, Seigneur, envoie quelqu'un d'autre. » ");
INSERT INTO frasbl_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","La colère de Yahvé s'enflamma contre Moïse, et il dit : « Et Aaron, ton frère, le Lévite ? Je sais qu'il sait bien parler. Et voici qu'il sort à ta rencontre. Quand il te verra, il se réjouira dans son cœur. ");
INSERT INTO frasbl_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Tu lui parleras, et tu mettras les paroles dans sa bouche. Je serai avec ta bouche et avec sa bouche, et je t'enseignerai ce que tu dois faire. ");
INSERT INTO frasbl_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Il sera ton porte-parole auprès du peuple. Il sera pour toi une bouche, et tu seras pour lui comme Dieu. ");
INSERT INTO frasbl_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Tu prendras dans ta main cette verge, avec laquelle tu feras les signes. » ");
INSERT INTO frasbl_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Moïse s'en alla et retourna chez Jéthro, son beau-père, et lui dit : « Laisse-moi, je t'en prie, retourner auprès de mes frères qui sont en Égypte, et voir s'ils sont encore en vie. » Jéthro a dit à Moïse : « Va en paix. » ");
INSERT INTO frasbl_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Yahvé dit à Moïse en Madian : « Va, retourne en Égypte, car tous les hommes qui en voulaient à ta vie sont morts. » ");
INSERT INTO frasbl_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Moïse prit sa femme et ses fils, les fit monter sur un âne, et il retourna au pays d'Égypte. Moïse prit dans sa main la verge de Dieu. ");
INSERT INTO frasbl_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Yahvé dit à Moïse : « Quand tu retourneras en Égypte, tu feras devant Pharaon tous les prodiges que j'ai mis en ta main, mais j'endurcirai son cœur et il ne laissera pas aller le peuple. ");
INSERT INTO frasbl_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Tu diras à Pharaon : « Yahvé dit : Israël est mon fils, mon premier-né, ");
INSERT INTO frasbl_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","et je t'ai dit : « Laisse aller mon fils, pour qu'il me serve », et tu as refusé de le laisser aller. Voici que je vais tuer ton fils premier-né. » ");
INSERT INTO frasbl_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","En chemin, dans un lieu d'hébergement, Yahvé rencontra Moïse et voulut le tuer. ");
INSERT INTO frasbl_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Alors Zippora prit un silex, coupa le prépuce de son fils et le jeta à ses pieds ; et elle dit : « Certainement, tu es pour moi un époux de sang. » ");
INSERT INTO frasbl_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Il le laissa donc tranquille. Alors elle dit : « Tu es un époux de sang », à cause de la circoncision. ");
INSERT INTO frasbl_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Yahvé dit à Aaron : « Va dans le désert à la rencontre de Moïse. » Il alla à sa rencontre sur la montagne de Dieu, et le baisa. ");
INSERT INTO frasbl_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Moïse rapporta à Aaron toutes les paroles de Yahvé par lesquelles il l'avait envoyé, et tous les signes par lesquels il l'avait instruit. ");
INSERT INTO frasbl_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Moïse et Aaron allèrent rassembler tous les anciens des enfants d'Israël. ");
INSERT INTO frasbl_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Aaron prononça toutes les paroles que Yahvé avait dites à Moïse, et il fit les signes aux yeux du peuple. ");
INSERT INTO frasbl_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Le peuple crut, et quand il apprit que Yahvé avait visité les enfants d'Israël et qu'il avait vu leur détresse, il se prosterna et se prosterna. ");
INSERT INTO frasbl_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Moïse et Aaron vinrent ensuite et dirent à Pharaon : « Voici ce que dit Yahvé, le Dieu d'Israël : « Laisse aller mon peuple, pour qu'il me donne une fête dans le désert. » ");
INSERT INTO frasbl_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Pharaon dit : « Qui est Yahvé, pour que j'écoute sa voix et laisse aller Israël ? Je ne connais pas Yahvé, et je ne laisserai pas partir Israël. » ");
INSERT INTO frasbl_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Ils dirent : « Le Dieu des Hébreux nous a rencontrés. Laissez-nous, je vous prie, aller à trois jours de marche dans le désert, et sacrifier à Yahvé, notre Dieu, de peur qu'il ne tombe sur nous par la peste ou par l'épée. » ");
INSERT INTO frasbl_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Le roi d'Égypte leur dit : « Pourquoi, Moïse et Aaron, détournez-vous le peuple de son travail ? Retournez à vos fardeaux ! » ");
INSERT INTO frasbl_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Pharaon répondit : « Voici que le peuple du pays est maintenant nombreux, et vous le faites reposer de ses fardeaux. » ");
INSERT INTO frasbl_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Le même jour, Pharaon donna cet ordre aux maîtres d'œuvre du peuple et à leurs officiers : ");
INSERT INTO frasbl_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","« Vous ne donnerez plus au peuple de la paille pour faire des briques, comme auparavant. Qu'ils aillent ramasser eux-mêmes de la paille. ");
INSERT INTO frasbl_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Vous leur demanderez le nombre de briques qu'ils fabriquaient auparavant. Tu n'en diminueras rien, car ils sont oisifs. C'est pourquoi ils crient : « Allons sacrifier à notre Dieu ». ");
INSERT INTO frasbl_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Que des travaux plus lourds soient confiés aux hommes, afin qu'ils y travaillent. Qu'ils ne fassent pas attention aux paroles mensongères. » ");
INSERT INTO frasbl_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Les maîtres du peuple sortirent avec leurs officiers, et ils parlèrent au peuple en disant : « Voici ce que dit Pharaon : Je ne vous donnerai pas de paille. ");
INSERT INTO frasbl_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Allez vous-mêmes chercher de la paille où vous pourrez en trouver, car rien de votre travail ne sera diminué. » ");
INSERT INTO frasbl_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Le peuple fut donc dispersé dans tout le pays d'Égypte pour ramasser du chaume en guise de paille. ");
INSERT INTO frasbl_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Les maîtres de corvées disaient avec insistance : « Remplissez chaque jour votre quota de travail, comme quand il y avait de la paille ! » ");
INSERT INTO frasbl_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Les officiers des enfants d'Israël, que les maîtres de corvées de Pharaon avaient établis sur eux, furent battus et on leur demanda : « Pourquoi n'avez-vous pas rempli votre quota hier et aujourd'hui, en fabriquant des briques comme auparavant ? » ");
INSERT INTO frasbl_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Les officiers des enfants d'Israël vinrent et crièrent à Pharaon : « Pourquoi agis-tu ainsi avec tes serviteurs ? ");
INSERT INTO frasbl_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","On ne donne pas de paille à tes serviteurs, et ils nous disent : « Fais des briques », et voilà que tes serviteurs sont battus ; mais la faute en revient à ton peuple. » ");
INSERT INTO frasbl_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Mais Pharaon dit : « Tu es oisif ! Vous êtes oisifs ! C'est pourquoi vous dites : « Allons sacrifier à Yahvé ». ");
INSERT INTO frasbl_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Va donc maintenant, et travaille ; on ne te donnera pas de paille, mais tu livreras le même nombre de briques ! ». ");
INSERT INTO frasbl_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Les officiers des enfants d'Israël virent qu'ils avaient des ennuis quand on leur dit : « Vous ne diminuerez rien de votre quota quotidien de briques ! » ");
INSERT INTO frasbl_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Ils rencontrèrent Moïse et Aaron, qui se tenaient le long du chemin, comme ils sortaient de chez Pharaon. ");
INSERT INTO frasbl_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Ils leur dirent : « Que Yahvé vous regarde et vous juge, car vous avez fait de nous un objet d'horreur aux yeux de Pharaon et aux yeux de ses serviteurs, afin de mettre une épée dans leur main pour nous tuer ! ». ");
INSERT INTO frasbl_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Moïse retourna auprès de Yahvé et dit : « Seigneur, pourquoi as-tu fait venir la détresse sur ce peuple ? Pourquoi m'as-tu envoyé ? ");
INSERT INTO frasbl_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Car depuis que je suis allé parler en ton nom à Pharaon, il a fait venir le malheur sur ce peuple. Tu n'as pas du tout secouru ton peuple ! » ");
INSERT INTO frasbl_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Yahvé dit à Moïse : « Tu verras maintenant ce que je ferai à Pharaon, car c'est à main forte qu'il les laissera aller, et c'est à main forte qu'il les chassera de son pays. » ");
INSERT INTO frasbl_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Dieu parla à Moïse, et lui dit : « Je suis Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","J'ai apparu à Abraham, à Isaac et à Jacob, en tant que Dieu tout-puissant, mais je ne leur ai pas été connu sous mon nom de Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","J'ai aussi établi mon alliance avec eux, pour leur donner le pays de Canaan, le pays de leurs voyages, dans lequel ils vivaient comme des étrangers. ");
INSERT INTO frasbl_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","J'ai entendu les gémissements des enfants d'Israël, que les Égyptiens tiennent en esclavage, et je me suis souvenu de mon alliance. ");
INSERT INTO frasbl_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","C'est pourquoi dis aux enfants d'Israël : « Je suis Yahvé, et je vous ferai sortir de dessous les fardeaux des Égyptiens, je vous délivrerai de leur servitude, je vous rachèterai à bras étendu et par de grands jugements. ");
INSERT INTO frasbl_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Je vous prendrai pour mon peuple. Je serai votre Dieu, et vous saurez que je suis Yahvé, votre Dieu, qui vous fait sortir de dessous les fardeaux des Égyptiens. ");
INSERT INTO frasbl_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Je vous ferai entrer dans le pays que j'ai juré de donner à Abraham, à Isaac et à Jacob, et je vous le donnerai en héritage : je suis Yahvé.'\" ");
INSERT INTO frasbl_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Moïse en parla aux enfants d'Israël, mais ils n'écoutèrent pas Moïse, à cause de l'angoisse de l'esprit et de la cruelle servitude. ");
INSERT INTO frasbl_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Yahvé parla à Moïse et dit : ");
INSERT INTO frasbl_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","« Va, parle à Pharaon, roi d'Égypte, pour qu'il laisse sortir les enfants d'Israël de son pays. » ");
INSERT INTO frasbl_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Moïse parla devant Yahvé, et dit : « Voici, les enfants d'Israël ne m'ont pas écouté. Comment Pharaon m'écoutera-t-il, alors que j'ai des lèvres incirconcises ? » ");
INSERT INTO frasbl_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Yahvé parla à Moïse et à Aaron, et leur donna l'ordre de faire sortir du pays d'Égypte les enfants d'Israël et Pharaon, roi d'Égypte. ");
INSERT INTO frasbl_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Voici les chefs des maisons de leurs pères. Fils de Ruben, premier-né d'Israël : Hanoch, Pallu, Hetsron et Carmi. Ce sont là les familles de Ruben. ");
INSERT INTO frasbl_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Fils de Siméon : Jemuel, Jamin, Ohad, Jachin, Zohar et Saül, fils d'une Cananéenne : ce sont là les familles de Siméon. ");
INSERT INTO frasbl_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Voici les noms des fils de Lévi, selon leurs générations : Guerschon, Kehath et Merari. Les années de la vie de Lévi furent de cent trente-sept ans. ");
INSERT INTO frasbl_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Fils de Guerschon : Libni et Schimeï, selon leurs familles. ");
INSERT INTO frasbl_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Fils de Kehath : Amram, Jitsehar, Hébron et Uzziel. Les années de la vie de Kehath furent de cent trente-trois ans. ");
INSERT INTO frasbl_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Fils de Merari : Mahli et Mushi. Ce sont là les familles des Lévites, selon leurs générations. ");
INSERT INTO frasbl_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amram prit pour femme Jochebed, la sœur de son père, et elle lui enfanta Aaron et Moïse. Les années de la vie d'Amram furent de cent trente-sept ans. ");
INSERT INTO frasbl_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Fils de Jitsehar : Koré, Néphég, et Zicri. ");
INSERT INTO frasbl_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Fils d'Uzziel : Mishaël, Elzaphan et Sithri. ");
INSERT INTO frasbl_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aaron prit pour femme Elischéba, fille d'Amminadab, sœur de Nachshon ; elle lui enfanta Nadab et Abihu, Eléazar et Ithamar. ");
INSERT INTO frasbl_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Fils de Koré : Assir, Elkana et Abiasaph ; ce sont là les familles des Koréens. ");
INSERT INTO frasbl_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Le fils d'Eléazar Aaron prit pour femme une des filles de Putiel, qui lui enfanta Phinées. Ce sont là les chefs des maisons paternelles des Lévites, selon leurs familles. ");
INSERT INTO frasbl_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Ce sont ces Aaron et Moïse à qui Yahvé a dit : « Fais sortir du pays d'Égypte les enfants d'Israël, selon leurs armées. » ");
INSERT INTO frasbl_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Ce sont eux qui ont parlé à Pharaon, roi d'Égypte, pour faire sortir d'Égypte les enfants d'Israël. Ce sont ces Moïse et Aaron. ");
INSERT INTO frasbl_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Le jour où Yahvé parla à Moïse au pays d'Égypte, ");
INSERT INTO frasbl_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","Yahvé dit à Moïse : « Je suis Yahvé. Dis à Pharaon, roi d'Égypte, tout ce que je te dirai. » ");
INSERT INTO frasbl_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Moïse dit devant Yahvé : « Voici, je suis d'une bouche incirconcise, et comment Pharaon m'écouterait-il ? » ");
INSERT INTO frasbl_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Yahvé dit à Moïse : « Voici, je t'ai établi comme Dieu auprès de Pharaon, et Aaron, ton frère, sera ton prophète. ");
INSERT INTO frasbl_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Tu diras tout ce que je t'ordonnerai, et Aaron, ton frère, parlera à Pharaon pour qu'il laisse aller les enfants d'Israël hors de son pays. ");
INSERT INTO frasbl_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","J'endurcirai le cœur de Pharaon, et je multiplierai mes signes et mes prodiges dans le pays d'Égypte. ");
INSERT INTO frasbl_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Mais Pharaon ne t'écoutera pas. Je mettrai ma main sur l'Égypte, et je ferai sortir du pays d'Égypte mes armées, mon peuple, les enfants d'Israël, par de grands jugements. ");
INSERT INTO frasbl_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Les Égyptiens sauront que je suis Yahvé, quand j'étendrai ma main sur l'Égypte et que je ferai sortir du milieu d'eux les enfants d'Israël. » ");
INSERT INTO frasbl_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Moïse et Aaron firent ainsi. Ils firent ce que Yahvé leur avait ordonné. ");
INSERT INTO frasbl_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Moïse était âgé de quatre-vingts ans, et Aaron de quatre-vingt-trois ans, lorsqu'ils parlèrent à Pharaon. ");
INSERT INTO frasbl_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Yahvé parla à Moïse et à Aaron, et dit : ");
INSERT INTO frasbl_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","« Quand Pharaon vous dira : Fais un miracle, tu diras à Aaron : Prends ta verge, jette-la devant Pharaon, et elle deviendra un serpent ». ");
INSERT INTO frasbl_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Moïse et Aaron allèrent trouver Pharaon, et ils firent ce que Yahvé avait ordonné. Aaron jeta sa verge devant Pharaon et devant ses serviteurs, et elle devint un serpent. ");
INSERT INTO frasbl_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Alors Pharaon appela aussi les sages et les magiciens. Eux aussi, les magiciens d'Egypte, firent la même chose avec leurs enchantements. ");
INSERT INTO frasbl_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Ils jetèrent chacun leurs baguettes et elles devinrent des serpents ; mais la baguette d'Aaron engloutit leurs baguettes. ");
INSERT INTO frasbl_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Le cœur de Pharaon s'endurcit et il ne les écouta pas, comme Yahvé l'avait dit. ");
INSERT INTO frasbl_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Yahvé dit à Moïse : « Le cœur de Pharaon est obstiné. Il refuse de laisser partir le peuple. ");
INSERT INTO frasbl_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Va voir Pharaon dès le matin. Voici qu'il sort vers l'eau. Tu te tiendras au bord du fleuve pour aller à sa rencontre. Tu prendras dans ta main le bâton qui s'est transformé en serpent. ");
INSERT INTO frasbl_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Tu lui diras : « Yahvé, le Dieu des Hébreux, m'a envoyé vers toi pour te dire : « Laisse aller mon peuple, afin qu'il me serve dans le désert. Voici, jusqu'à présent, vous n'avez pas écouté. » ");
INSERT INTO frasbl_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Yahvé dit : « A ceci vous saurez que je suis Yahvé. Voici : Je frapperai avec la verge qui est dans ma main sur les eaux qui sont dans le fleuve, et elles seront changées en sang. ");
INSERT INTO frasbl_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Les poissons qui sont dans le fleuve mourront et le fleuve deviendra fétide. Les Égyptiens auront horreur de boire de l'eau du fleuve. »'\" ");
INSERT INTO frasbl_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Yahvé dit à Moïse : « Dis à Aaron : « Prends ta verge et étends ta main sur les eaux de l'Égypte, sur ses rivières, sur ses ruisseaux, sur ses étangs et sur tous ses bassins d'eau, afin qu'elles deviennent du sang. Il y aura du sang dans tout le pays d'Égypte, dans les vases de bois et dans les vases de pierre. » ");
INSERT INTO frasbl_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Moïse et Aaron firent ce que l'Éternel leur avait ordonné ; ils levèrent la verge et frappèrent les eaux du fleuve, sous les yeux de Pharaon et de ses serviteurs, et toutes les eaux du fleuve se changèrent en sang. ");
INSERT INTO frasbl_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Les poissons qui étaient dans le fleuve moururent. Le fleuve devint fétide. Les Égyptiens ne pouvaient pas boire l'eau du fleuve. Le sang était dans tout le pays d'Égypte. ");
INSERT INTO frasbl_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Les magiciens d'Égypte firent la même chose avec leurs enchantements. Le cœur de Pharaon s'endurcit et il ne les écouta pas, comme Yahvé l'avait dit. ");
INSERT INTO frasbl_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Pharaon se retourna et entra dans sa maison, et il ne prit même pas cela à cœur. ");
INSERT INTO frasbl_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Tous les Égyptiens creusèrent autour du fleuve pour trouver de l'eau à boire, car ils ne pouvaient pas boire l'eau du fleuve. ");
INSERT INTO frasbl_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Sept jours s'écoulèrent, après que Yahvé eut frappé le fleuve. ");
INSERT INTO frasbl_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Yahvé dit à Moïse : « Va trouver Pharaon et dis-lui : « Voici ce que dit Yahvé : Laisse aller mon peuple, afin qu'il me serve. ");
INSERT INTO frasbl_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Si tu refuses de le laisser partir, voici que je vais frapper de grenouilles tout ton territoire. ");
INSERT INTO frasbl_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Le fleuve grouillera de grenouilles, qui monteront et entreront dans ta maison, dans ta chambre, sur ton lit, dans la maison de tes serviteurs, sur tes gens, dans tes fours et dans tes pétrins. ");
INSERT INTO frasbl_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Les grenouilles monteront sur toi, sur ton peuple et sur tous tes serviteurs. »'\" ");
INSERT INTO frasbl_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Yahvé dit à Moïse : « Dis à Aaron : « Étends la main de ta verge sur les rivières, sur les ruisseaux et sur les étangs, et fais monter les grenouilles sur le pays d'Égypte. »\" ");
INSERT INTO frasbl_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Aaron étendit sa main sur les eaux d'Égypte ; les grenouilles montèrent et couvrirent le pays d'Égypte. ");
INSERT INTO frasbl_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Les magiciens firent de même avec leurs enchantements et firent monter les grenouilles sur le pays d'Égypte. ");
INSERT INTO frasbl_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Alors Pharaon appela Moïse et Aaron, et dit : « Prie Yahvé qu'il éloigne les grenouilles de moi et de mon peuple ; et je laisserai aller le peuple pour qu'il sacrifie à Yahvé. » ");
INSERT INTO frasbl_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Moïse dit à Pharaon : « Je te fais l'honneur de fixer le moment où je prierai pour toi, pour tes serviteurs et pour ton peuple, afin que les grenouilles soient détruites chez toi et dans tes maisons, et qu'elles ne restent que dans le fleuve. » ");
INSERT INTO frasbl_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Pharaon a dit : « Demain. » Moïse dit : « Qu'il en soit ainsi, afin que vous sachiez qu'il n'y a personne comme Yahvé notre Dieu. ");
INSERT INTO frasbl_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Les grenouilles s'éloigneront de vous, de vos maisons, de vos serviteurs et de votre peuple. Elles ne resteront que dans le fleuve. » ");
INSERT INTO frasbl_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Moïse et Aaron sortirent de chez Pharaon, et Moïse cria à Yahvé au sujet des grenouilles qu'il avait fait venir sur Pharaon. ");
INSERT INTO frasbl_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Yahvé fit selon la parole de Moïse, et les grenouilles moururent dans les maisons, dans les cours et dans les champs. ");
INSERT INTO frasbl_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","On les rassembla en tas, et le pays se mit à puer. ");
INSERT INTO frasbl_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Mais lorsque Pharaon vit qu'il y avait un répit, il endurcit son cœur et ne les écouta pas, comme l'avait dit l'Éternel. ");
INSERT INTO frasbl_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Yahvé dit à Moïse : « Dis à Aaron : « Étends ta verge, et frappe la poussière de la terre, afin qu'elle devienne des poux dans tout le pays d'Égypte. » ");
INSERT INTO frasbl_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Ils firent ainsi. Aaron étendit sa main avec sa verge et frappa la poussière de la terre, et il y eut des poux sur l'homme et sur l'animal ; toute la poussière de la terre devint des poux dans tout le pays d'Égypte. ");
INSERT INTO frasbl_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Les magiciens essayèrent avec leurs enchantements de produire des poux, mais ils ne purent pas. Il y avait des poux sur l'homme et sur l'animal. ");
INSERT INTO frasbl_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Les magiciens dirent à Pharaon : « C'est le doigt de Dieu ». Mais le cœur de Pharaon s'endurcit et il ne les écouta pas, comme l'avait dit Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Yahvé dit à Moïse : « Lève-toi de bon matin, et tiens-toi devant Pharaon ; voici qu'il sort pour aller à l'eau ; dis-lui : « Voici ce que dit Yahvé : laisse aller mon peuple, afin qu'il me serve ». ");
INSERT INTO frasbl_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Sinon, si tu ne laisses pas aller mon peuple, voici que j'enverrai des nuées de mouches sur toi, sur tes serviteurs, sur ton peuple, et dans tes maisons. Les maisons des Égyptiens seront pleines de mouches, et le sol sur lequel elles reposent sera aussi plein de mouches. ");
INSERT INTO frasbl_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","En ce jour-là, je mettrai à part le pays de Gosen, où habite mon peuple, pour qu'il n'y ait pas d'essaims de mouches, afin que vous sachiez que je suis Yahvé sur la terre. ");
INSERT INTO frasbl_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Je mettrai une séparation entre mon peuple et ton peuple. Ce signe arrivera d'ici demain. »'\" ");
INSERT INTO frasbl_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Yahvé fit ainsi. Il y eut des nuées de mouches dans la maison de Pharaon et dans les maisons de ses serviteurs. Dans tout le pays d'Égypte, la terre se corrompit à cause des nuées de mouches. ");
INSERT INTO frasbl_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Pharaon appela Moïse et Aaron, et dit : « Allez, sacrifiez à votre Dieu dans le pays. » ");
INSERT INTO frasbl_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Moïse répondit : « Il n'est pas convenable d'agir ainsi, car nous allons sacrifier l'abomination des Égyptiens à Yahvé notre Dieu. Si nous sacrifions l'abomination des Égyptiens sous leurs yeux, ne nous lapideront-ils pas ? ");
INSERT INTO frasbl_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Nous ferons trois jours de marche dans le désert, et nous sacrifierons à Yahvé notre Dieu, comme il nous l'ordonnera. » ");
INSERT INTO frasbl_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Pharaon dit : « Je te laisserai partir pour que tu sacrifies à Yahvé ton Dieu dans le désert, mais tu n'iras pas très loin. Prie pour moi. » ");
INSERT INTO frasbl_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Moïse dit : « Voici, je m'en vais loin de vous. Demain, je prierai Yahvé pour que les mouches s'éloignent de Pharaon, de ses serviteurs et de son peuple ; seulement, que Pharaon ne trompe plus le peuple en l'empêchant d'aller sacrifier à Yahvé. » ");
INSERT INTO frasbl_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Moïse sortit de chez Pharaon et pria Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Yahvé fit selon la parole de Moïse, et il fit disparaître les mouches de Pharaon, de ses serviteurs et de son peuple. Il n'en resta pas une seule. ");
INSERT INTO frasbl_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Cette fois encore, Pharaon endurcit son cœur et ne laissa pas partir le peuple. ");
INSERT INTO frasbl_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Yahvé dit à Moïse : « Va trouver Pharaon et dis-lui : « Voici ce que dit Yahvé, le Dieu des Hébreux : « Laisse aller mon peuple, afin qu'il me serve. ");
INSERT INTO frasbl_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Car si tu refuses de les laisser aller et si tu les retiens, ");
INSERT INTO frasbl_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","voici que la main de l'Éternel se porte sur ton bétail qui est dans les champs, sur les chevaux, sur les ânes, sur les chameaux, sur les troupeaux et sur les brebis, par une peste très redoutable. ");
INSERT INTO frasbl_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Yahvé fera la distinction entre le bétail d'Israël et le bétail d'Égypte, et rien ne mourra de tout ce qui appartient aux enfants d'Israël. »'\" ");
INSERT INTO frasbl_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Yahvé fixa un temps déterminé, en disant : « Demain, Yahvé fera cette chose dans le pays. » ");
INSERT INTO frasbl_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Yahvé fit cette chose le lendemain ; et tout le bétail de l'Égypte mourut, mais du bétail des enfants d'Israël, pas un seul ne mourut. ");
INSERT INTO frasbl_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Pharaon envoya chercher, et voici, il n'y avait pas un seul animal mort parmi les troupeaux des Israélites. Mais le cœur de Pharaon était obstiné, et il ne laissa pas partir le peuple. ");
INSERT INTO frasbl_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Yahvé dit à Moïse et à Aaron : « Prenez des poignées de cendres de la fournaise, et que Moïse en fasse l'aspersion vers le ciel, sous les yeux de Pharaon. ");
INSERT INTO frasbl_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Elle deviendra une petite poussière sur tout le pays d'Égypte, et il y aura des furoncles et des ampoules qui éclateront sur les hommes et sur les animaux, dans tout le pays d'Égypte. » ");
INSERT INTO frasbl_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Ils prirent de la cendre de la fournaise et se tinrent devant Pharaon ; Moïse la répandit vers le ciel, et elle devint des furoncles et des ampoules qui se déclarèrent sur les hommes et sur les animaux. ");
INSERT INTO frasbl_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Les magiciens ne purent se tenir devant Moïse à cause des furoncles, car les furoncles étaient sur les magiciens et sur tous les Égyptiens. ");
INSERT INTO frasbl_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Yahvé endurcit le cœur de Pharaon, et il ne les écouta pas, comme Yahvé l'avait dit à Moïse. ");
INSERT INTO frasbl_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Yahvé dit à Moïse : « Lève-toi de bon matin, présente-toi devant Pharaon et dis-lui : « Voici ce que dit Yahvé, le Dieu des Hébreux : « Laisse aller mon peuple, afin qu'il me serve. ");
INSERT INTO frasbl_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Car cette fois, je vais envoyer toutes mes plaies contre ton cœur, contre tes fonctionnaires et contre ton peuple, afin que tu saches qu'il n'y a personne comme moi sur toute la terre. ");
INSERT INTO frasbl_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Car maintenant, j'aurais étendu ma main, je vous aurais frappés de peste, toi et ton peuple, et vous auriez été exterminés de la terre ; ");
INSERT INTO frasbl_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","mais c'est pour cela que je t'ai fait subsister : pour te montrer ma puissance, et pour que mon nom soit proclamé par toute la terre, ");
INSERT INTO frasbl_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","parce que tu t'exaltes encore contre mon peuple, que tu ne veux pas le laisser aller. ");
INSERT INTO frasbl_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Voici, demain, à cette heure-ci, je ferai pleuvoir une grêle très violente, telle qu'il n'y en a pas eu en Égypte depuis le jour de sa fondation jusqu'à présent. ");
INSERT INTO frasbl_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Ordonnez maintenant que tout votre bétail et tout ce que vous avez dans les champs soient mis à l'abri. La grêle tombera sur tous les hommes et sur tous les animaux qui se trouveront dans les champs et qui ne seront pas ramenés à l'abri, et ils mourront. »'\" ");
INSERT INTO frasbl_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Ceux qui respectaient la parole de Yahvé parmi les serviteurs de Pharaon faisaient fuir leurs serviteurs et leurs bêtes dans les maisons. ");
INSERT INTO frasbl_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Ceux qui ne respectaient pas la parole de Yahvé laissaient leurs serviteurs et leurs bêtes dans les champs. ");
INSERT INTO frasbl_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Yahvé dit à Moïse : « Étends ta main vers le ciel, afin qu'il y ait de la grêle dans tout le pays d'Égypte, sur les hommes, sur les animaux et sur toutes les herbes des champs, dans tout le pays d'Égypte. » ");
INSERT INTO frasbl_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Moïse étendit sa verge vers les cieux, et Yahvé envoya le tonnerre et la grêle ; les éclairs tombèrent sur la terre. Yahvé fit pleuvoir de la grêle sur le pays d'Égypte. ");
INSERT INTO frasbl_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Il y eut une grêle très forte, et les éclairs se mêlèrent à la grêle, comme il n'y en avait pas eu dans tout le pays d'Égypte depuis qu'il était devenu une nation. ");
INSERT INTO frasbl_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","La grêle frappa dans tout le pays d'Égypte tout ce qui se trouvait dans les champs, tant les hommes que les animaux ; la grêle frappa toutes les herbes des champs et brisa tous les arbres des champs. ");
INSERT INTO frasbl_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Il n'y eut de grêle que dans le pays de Gosen, où se trouvaient les enfants d'Israël. ");
INSERT INTO frasbl_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Pharaon fit appeler Moïse et Aaron, et leur dit : « Cette fois, j'ai péché. Yahvé est juste, et moi et mon peuple sommes méchants. ");
INSERT INTO frasbl_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Priez Yahvé, car il y a eu assez de tonnerres et de grêle. Je vais vous laisser partir, et vous ne resterez pas plus longtemps. » ");
INSERT INTO frasbl_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Moïse lui dit : « Dès que je serai sorti de la ville, j'étendrai mes mains vers Yahvé. Les tonnerres cesseront, et il n'y aura plus de grêle, afin que tu saches que la terre appartient à Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Mais quant à toi et à tes serviteurs, je sais que vous ne craignez pas encore Yahvé Dieu. » ");
INSERT INTO frasbl_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Le lin et l'orge furent frappés, car l'orge avait mûri et le lin était en fleur. ");
INSERT INTO frasbl_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Mais le blé et l'épeautre ne furent pas frappés, car ils n'avaient pas encore poussé. ");
INSERT INTO frasbl_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Moïse sortit de la ville, loin de Pharaon, et étendit ses mains vers Yahvé ; les tonnerres et la grêle cessèrent, et la pluie ne fut pas versée sur la terre. ");
INSERT INTO frasbl_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Lorsque Pharaon vit que la pluie, la grêle et les tonnerres avaient cessé, il pécha encore plus et endurcit son cœur, lui et ses serviteurs. ");
INSERT INTO frasbl_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Le cœur de Pharaon s'endurcit et il ne laissa pas aller les enfants d'Israël, comme Yahvé l'avait dit par Moïse. ");
INSERT INTO frasbl_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Yahvé dit à Moïse : « Va vers Pharaon, car j'ai endurci son cœur et le cœur de ses serviteurs, afin de montrer mes signes au milieu d'eux ; ");
INSERT INTO frasbl_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","et afin que tu racontes à ton fils et au fils de ton fils ce que j'ai fait à l'Égypte et les signes que j'ai accomplis au milieu d'eux, pour que tu saches que je suis Yahvé. » ");
INSERT INTO frasbl_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Moïse et Aaron allèrent trouver Pharaon et lui dirent : « Voici ce que dit Yahvé, le Dieu des Hébreux : « Jusqu'à quand refuseras-tu de t'humilier devant moi ? Laisse partir mon peuple, afin qu'il me serve. ");
INSERT INTO frasbl_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Ou bien, si vous refusez de laisser partir mon peuple, voici que demain je ferai venir des sauterelles dans votre pays, ");
INSERT INTO frasbl_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","et elles couvriront la surface de la terre, de sorte qu'on ne pourra plus voir la terre. Elles mangeront le reste de ce qui s'est échappé, ce qui vous reste de la grêle, et elles mangeront tout arbre qui pousse pour vous dans les champs. ");
INSERT INTO frasbl_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Tes maisons seront remplies, ainsi que celles de tous tes serviteurs et de tous les Égyptiens, comme n'en ont jamais vu ni tes pères ni les pères de tes pères, depuis le jour où ils ont été sur la terre jusqu'à ce jour.'\" Il se retourna, et sortit de chez Pharaon. ");
INSERT INTO frasbl_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Les serviteurs de Pharaon lui dirent : « Jusqu'à quand cet homme sera-t-il un piège pour nous ? Laisse partir ces hommes, afin qu'ils servent Yahvé, leur Dieu. Ne sais-tu pas encore que l'Égypte est détruite ? » ");
INSERT INTO frasbl_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Moïse et Aaron furent ramenés auprès de Pharaon, qui leur dit : « Allez, servez Yahvé votre Dieu ; mais qui sont ceux qui iront ? » ");
INSERT INTO frasbl_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Moïse dit : « Nous irons avec nos jeunes et nos vieux, nous irons avec nos fils et nos filles, avec nos brebis et nos bœufs. Nous irons avec nos fils et nos filles, avec nos brebis et nos bœufs, car nous devons faire une fête à Yahvé. » ");
INSERT INTO frasbl_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Il leur dit : « Que Yahvé soit avec vous si je vous laisse partir avec vos petits enfants ! Voyez, le mal est clairement devant vos yeux. ");
INSERT INTO frasbl_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Mais non ! Allez maintenant, vous qui êtes des hommes, et servez Yahvé, car c'est ce que vous voulez ! ». Et ils furent chassés de la présence de Pharaon. ");
INSERT INTO frasbl_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Yahvé dit à Moïse : « Étends ta main sur le pays d'Égypte pour les sauterelles, afin qu'elles montent sur le pays d'Égypte et mangent toutes les herbes du pays, tout ce que la grêle a laissé. » ");
INSERT INTO frasbl_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Moïse étendit sa verge sur le pays d'Égypte, et Yahvé fit souffler un vent d'est sur le pays tout ce jour-là et toute la nuit ; et au matin, le vent d'est amena les sauterelles. ");
INSERT INTO frasbl_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Les sauterelles montèrent sur tout le pays d'Égypte, et se posèrent dans tout le territoire de l'Égypte. Elles étaient très nuisibles. Avant elles, il n'y avait pas eu de sauterelles comme elles, et il n'y en aura plus jamais. ");
INSERT INTO frasbl_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Car elles couvrirent toute la surface de la terre, au point d'obscurcir le pays, et elles mangèrent toutes les herbes du pays et tous les fruits des arbres que la grêle avait laissés. Il ne resta rien de vert, ni arbre ni herbe des champs, dans tout le pays d'Égypte. ");
INSERT INTO frasbl_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Pharaon appela en hâte Moïse et Aaron, et dit : « J'ai péché contre Yahvé ton Dieu et contre toi. ");
INSERT INTO frasbl_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Maintenant, pardonne-moi encore mon péché, et prie Yahvé ton Dieu, afin qu'il éloigne de moi cette mort. » ");
INSERT INTO frasbl_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Moïse sortit de chez Pharaon et pria l'Éternel. ");
INSERT INTO frasbl_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","L'Éternel envoya un vent d'ouest très fort, qui emporta les sauterelles et les chassa dans la mer Rouge. Il ne resta pas une seule sauterelle dans tout le territoire de l'Égypte. ");
INSERT INTO frasbl_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Mais Yahvé endurcit le cœur de Pharaon, qui ne laissa pas partir les enfants d'Israël. ");
INSERT INTO frasbl_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Yahvé dit à Moïse : « Étends ta main vers le ciel, afin qu'il y ait des ténèbres sur le pays d'Égypte, des ténèbres qu'on puisse sentir. » ");
INSERT INTO frasbl_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Moïse étendit sa main vers le ciel et il y eut une obscurité épaisse dans tout le pays d'Égypte pendant trois jours. ");
INSERT INTO frasbl_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","On ne se voyait pas les uns les autres, et personne ne se leva de sa place pendant trois jours ; mais tous les enfants d'Israël avaient de la lumière dans leurs habitations. ");
INSERT INTO frasbl_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Pharaon appela Moïse et dit : « Va, sers Yahvé. Laisse seulement tes brebis et tes bœufs en arrière. Laisse aussi tes petits enfants aller avec toi. » ");
INSERT INTO frasbl_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Moïse dit : « Tu dois aussi remettre entre nos mains des sacrifices et des holocaustes, afin que nous puissions offrir des sacrifices à Yahvé, notre Dieu. ");
INSERT INTO frasbl_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Notre bétail aussi partira avec nous. Pas un seul sabot ne sera laissé en arrière, car c'est de lui que nous devons prendre pour servir Yahvé notre Dieu ; et nous ne savons pas avec quoi nous devons servir Yahvé, jusqu'à ce que nous y arrivions. » ");
INSERT INTO frasbl_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Mais Yahvé endurcit le cœur de Pharaon, qui ne voulut pas les laisser partir. ");
INSERT INTO frasbl_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Pharaon lui dit : « Éloigne-toi de moi ! Prends garde de ne plus voir mon visage, car le jour où tu verras mon visage, tu mourras ! ». ");
INSERT INTO frasbl_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Moïse dit : « Tu as bien parlé. Je ne verrai plus jamais ton visage. » ");
INSERT INTO frasbl_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Yahvé dit à Moïse : « Je vais encore faire venir une plaie sur Pharaon et sur l'Égypte ; ensuite, il vous laissera partir. Quand il vous laissera partir, il vous chassera tout à fait. ");
INSERT INTO frasbl_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Parle maintenant aux oreilles du peuple, et que chaque homme demande à son voisin, et chaque femme à sa voisine, des bijoux d'argent et des bijoux d'or. » ");
INSERT INTO frasbl_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Yahvé accorda au peuple une faveur aux yeux des Égyptiens. D'ailleurs, l'homme Moïse était très grand au pays d'Égypte, aux yeux des serviteurs de Pharaon et aux yeux du peuple. ");
INSERT INTO frasbl_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Moïse répondit : « Voici ce que dit Yahvé : Vers minuit, je sortirai au milieu de l'Égypte, ");
INSERT INTO frasbl_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","et tous les premiers-nés du pays d'Égypte mourront, depuis le premier-né de Pharaon assis sur son trône jusqu'au premier-né de la servante qui est derrière le moulin, et tous les premiers-nés du bétail. ");
INSERT INTO frasbl_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Il y aura dans tout le pays d'Égypte un grand cri, tel qu'il n'y en a jamais eu et qu'il n'y en aura plus. ");
INSERT INTO frasbl_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Mais contre l'un des enfants d'Israël, un chien n'aboiera même pas et ne bougera pas la langue, ni contre un homme ni contre un animal, afin que vous sachiez que Yahvé fait une distinction entre les Égyptiens et Israël. ");
INSERT INTO frasbl_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Tous tes serviteurs descendront vers moi et se prosterneront devant moi en disant : « Sors, avec tout le peuple qui te suit » ; et après cela, je sortirai.'\" Il sortit de chez Pharaon dans une colère ardente. ");
INSERT INTO frasbl_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Yahvé dit à Moïse : « Pharaon ne vous écoutera pas, afin que mes prodiges se multiplient dans le pays d'Égypte. » ");
INSERT INTO frasbl_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Moïse et Aaron firent tous ces prodiges devant Pharaon, mais Yahvé endurcit le cœur de Pharaon, qui ne laissa pas sortir les enfants d'Israël de son pays. ");
INSERT INTO frasbl_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Yahvé parla à Moïse et à Aaron au pays d'Égypte, et dit : ");
INSERT INTO frasbl_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","« Ce mois-ci sera pour vous le commencement des mois. Il sera pour vous le premier mois de l'année. ");
INSERT INTO frasbl_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Parle à toute l'assemblée d'Israël, et dis : Le dixième jour de ce mois, on prendra chacun un agneau, selon les maisons de ses pères, un agneau par maison ; ");
INSERT INTO frasbl_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","et si la maison est trop petite pour un agneau, lui et son voisin de maison en prendront un selon le nombre des âmes. Tu feras ton compte pour l'agneau en fonction de ce que chacun pourra manger. ");
INSERT INTO frasbl_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Ton agneau sera sans défaut, un mâle d'un an. Tu le prendras parmi les brebis ou parmi les chèvres. ");
INSERT INTO frasbl_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Tu le garderas jusqu'au quatorzième jour du même mois, et toute l'assemblée de la communauté d'Israël l'immolera le soir. ");
INSERT INTO frasbl_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Ils prendront du sang et en mettront sur les deux montants de la porte et sur le linteau, dans les maisons où ils le mangeront. ");
INSERT INTO frasbl_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Cette nuit-là, ils mangeront la viande rôtie au feu, avec des pains sans levain. Ils la mangeront avec des herbes amères. ");
INSERT INTO frasbl_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Vous ne la mangerez pas crue, ni bouillie à l'eau, mais rôtie au feu, avec sa tête, ses pattes et ses entrailles. ");
INSERT INTO frasbl_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Vous n'en laisserez rien jusqu'au matin ; mais ce qui en restera jusqu'au matin, vous le brûlerez au feu. ");
INSERT INTO frasbl_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Voici comment vous le mangerez : votre ceinture à la taille, vos sandales aux pieds et votre bâton à la main, et vous le mangerez en hâte : c'est la Pâque de l'Éternel. ");
INSERT INTO frasbl_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Car cette nuit-là, je traverserai le pays d'Égypte et je frapperai tous les premiers-nés du pays d'Égypte, hommes et animaux. J'exécuterai des jugements contre tous les dieux d'Égypte. Je suis Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Le sang sera pour vous un signe sur les maisons où vous serez. Quand je verrai le sang, je passerai au-dessus de vous, et il n'y aura sur vous aucune plaie qui vous détruise, quand je frapperai le pays d'Égypte. ");
INSERT INTO frasbl_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Ce jour sera pour vous un mémorial. Vous le célébrerez comme une fête en l'honneur de Yahvé. Vous le célébrerez comme une fête de génération en génération, par une ordonnance perpétuelle. ");
INSERT INTO frasbl_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","\"'Pendant sept jours, vous mangerez des pains sans levain ; le premier jour, vous ôterez le levain de vos maisons ; car quiconque mangera du pain levé, du premier au septième jour, sera retranché d'Israël. ");
INSERT INTO frasbl_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Le premier jour, il y aura pour vous une convocation sainte, et le septième jour, une convocation sainte ; on n'y fera aucune espèce de travail, si ce n'est ce que chacun doit manger, et seulement ce qui peut être fait par vous. ");
INSERT INTO frasbl_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Vous observerez la fête des pains sans levain, car c'est en ce jour que j'ai fait sortir vos armées du pays d'Égypte. C'est pourquoi vous observerez ce jour, de génération en génération, comme une ordonnance perpétuelle. ");
INSERT INTO frasbl_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Le premier mois, le quatorzième jour du mois, au soir, vous mangerez des pains sans levain, jusqu'au vingt et unième jour du mois, au soir. ");
INSERT INTO frasbl_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Il ne se trouvera pas de levure dans vos maisons pendant sept jours, car quiconque mangera du pain levé sera retranché de l'assemblée d'Israël, qu'il soit étranger ou né dans le pays. ");
INSERT INTO frasbl_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Vous ne mangerez rien de levé. Dans toutes vos habitations, vous mangerez des pains sans levain.'\" ");
INSERT INTO frasbl_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Moïse appela tous les anciens d'Israël, et leur dit : « Sortez, prenez des agneaux selon vos familles, et immolez la Pâque. ");
INSERT INTO frasbl_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Vous prendrez un bouquet d'hysope, vous le tremperez dans le sang qui sera dans le bassin, et vous frapperez le linteau et les deux montants de la porte avec le sang qui sera dans le bassin. Aucun de vous ne sortira par la porte de sa maison jusqu'au matin. ");
INSERT INTO frasbl_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Car l'Éternel passera pour frapper les Égyptiens ; et quand il verra le sang sur le linteau et sur les deux montants de la porte, l'Éternel passera par-dessus la porte et ne permettra pas au destructeur d'entrer dans vos maisons pour vous frapper. ");
INSERT INTO frasbl_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Tu observeras cette chose comme une ordonnance pour toi et pour tes fils, à perpétuité. ");
INSERT INTO frasbl_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Lorsque vous serez arrivés dans le pays que l'Éternel vous donnera, comme il l'a promis, vous observerez ce service. ");
INSERT INTO frasbl_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Lorsque vos enfants vous demanderont : « Que signifie ce service ? », ");
INSERT INTO frasbl_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","vous répondrez : « C'est le sacrifice de la Pâque de l'Éternel, qui a passé au-dessus des maisons des enfants d'Israël en Égypte, lorsqu'il a frappé les Égyptiens et épargné nos maisons ». Le peuple s'inclina et se prosterna. ");
INSERT INTO frasbl_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Les enfants d'Israël allèrent et firent ainsi ; ils firent ce que Yahvé avait ordonné à Moïse et à Aaron. ");
INSERT INTO frasbl_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","A minuit, Yahvé frappa tous les premiers-nés du pays d'Egypte, depuis le premier-né de Pharaon assis sur son trône jusqu'au premier-né du captif qui était dans le cachot, et tous les premiers-nés du bétail. ");
INSERT INTO frasbl_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Pharaon se leva la nuit, lui, tous ses serviteurs et tous les Égyptiens. Il y eut un grand cri en Égypte, car il n'y avait pas une maison où il n'y eût un mort. ");
INSERT INTO frasbl_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Il appela de nuit Moïse et Aaron, et dit : « Lève-toi, sors du milieu de mon peuple, toi et les enfants d'Israël, et va servir Yahvé, comme tu l'as dit ! ");
INSERT INTO frasbl_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Prenez vos troupeaux et vos bêtes, comme vous l'avez dit, et partez ; et bénissez-moi aussi ! ». ");
INSERT INTO frasbl_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Les Égyptiens étaient pressés par le peuple, pour l'expulser du pays en toute hâte, car ils disaient : « Nous sommes tous des hommes morts. » ");
INSERT INTO frasbl_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Le peuple prit sa pâte avant qu'elle ne soit levée, ses pétrins étant liés dans leurs vêtements sur leurs épaules. ");
INSERT INTO frasbl_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Les enfants d'Israël agirent selon la parole de Moïse ; ils demandèrent aux Égyptiens des bijoux d'argent, des bijoux d'or et des vêtements. ");
INSERT INTO frasbl_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","L'Éternel accorda au peuple la faveur des Égyptiens, qui leur donnèrent ce qu'ils demandaient. Ils pillèrent les Égyptiens. ");
INSERT INTO frasbl_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Les enfants d'Israël firent le voyage de Ramsès à Succoth, environ six cent mille hommes à pied, sans compter les enfants. ");
INSERT INTO frasbl_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Une multitude hétéroclite montait aussi avec eux, avec des troupeaux, des bœufs et même beaucoup de bétail. ");
INSERT INTO frasbl_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Ils cuisaient des gâteaux sans levain avec la pâte qu'ils avaient apportée d'Égypte, car elle n'était pas levée, parce qu'ils avaient été poussés hors d'Égypte, qu'ils ne pouvaient pas attendre et qu'ils n'avaient pas préparé de nourriture pour eux. ");
INSERT INTO frasbl_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Or, le temps que les enfants d'Israël vécurent en Égypte fut de quatre cent trente ans. ");
INSERT INTO frasbl_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Au bout de quatre cent trente ans, jour pour jour, toutes les armées de Yahvé sortirent du pays d'Égypte. ");
INSERT INTO frasbl_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","C'est une nuit à laquelle on rend hommage à l'Éternel pour les avoir fait sortir du pays d'Égypte. C'est la nuit de Yahvé, que tous les enfants d'Israël observeront de génération en génération. ");
INSERT INTO frasbl_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Yahvé dit à Moïse et à Aaron : « Voici l'ordonnance de la Pâque. Aucun étranger n'en mangera, ");
INSERT INTO frasbl_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","mais le serviteur acheté à prix d'argent, quand vous l'aurez circoncis, en mangera. ");
INSERT INTO frasbl_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","L'étranger et le mercenaire n'en mangeront pas. ");
INSERT INTO frasbl_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","La viande doit être mangée dans une seule maison. Tu ne porteras pas de viande en dehors de la maison. Vous ne briserez aucun de ses os. ");
INSERT INTO frasbl_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Toute la congrégation d'Israël l'observera. ");
INSERT INTO frasbl_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Lorsqu'un étranger habitera chez vous en tant qu'étranger et qu'il voudra célébrer la Pâque en l'honneur de l'Éternel, que tous ses mâles soient circoncis, puis qu'il s'approche et la célèbre. Il sera comme celui qui est né dans le pays, mais aucun incirconcis n'en mangera. ");
INSERT INTO frasbl_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Une seule loi s'appliquera à celui qui est né dans le pays, et à l'étranger qui vit au milieu de vous comme un étranger. » ");
INSERT INTO frasbl_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Tous les enfants d'Israël firent ainsi. Ils firent ce que Yahvé avait ordonné à Moïse et à Aaron. ");
INSERT INTO frasbl_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Ce même jour, Yahvé fit sortir les enfants d'Israël du pays d'Égypte par leurs armées. ");
INSERT INTO frasbl_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Yahvé parla à Moïse, et dit : ");
INSERT INTO frasbl_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","« Sanctifie-moi tout premier-né, tout ce qui ouvre le ventre des enfants d'Israël, tant des hommes que des animaux. Il est à moi. » ");
INSERT INTO frasbl_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Moïse dit au peuple : « Souvenez-vous de ce jour où vous êtes sortis d'Égypte, de la maison de servitude, car c'est par la force de sa main que Yahvé vous a fait sortir de ce lieu. On ne mangera pas de pain levé. ");
INSERT INTO frasbl_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Aujourd'hui, vous sortez au mois d'Abib. ");
INSERT INTO frasbl_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Lorsque Yahvé vous fera entrer dans le pays des Cananéens, des Héthiens, des Amoréens, des Héviens et des Jébusiens, qu'il a juré à vos pères de vous donner, un pays où coulent le lait et le miel, vous célébrerez cet office pendant ce mois. ");
INSERT INTO frasbl_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Pendant sept jours, vous mangerez des pains sans levain, et le septième jour, vous ferez une fête en l'honneur de l'Éternel. ");
INSERT INTO frasbl_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","On mangera des pains sans levain pendant les sept jours ; on ne verra pas avec vous de pain levé. On ne verra pas de levure avec vous, dans tout votre territoire. ");
INSERT INTO frasbl_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","En ce jour-là, tu diras à ton fils : « C'est à cause de ce que Yahvé a fait pour moi, quand je suis sorti d'Égypte ». ");
INSERT INTO frasbl_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Ce sera pour toi un signe sur ta main et un souvenir entre tes yeux, afin que la loi de l'Éternel soit dans ta bouche ; car c'est d'une main forte que l'Éternel t'a fait sortir d'Égypte. ");
INSERT INTO frasbl_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Tu observeras donc cette ordonnance en son temps, d'année en année. ");
INSERT INTO frasbl_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","« Lorsque Yahvé vous fera entrer dans le pays des Cananéens, comme il l'a juré à vous et à vos pères, et qu'il vous le donnera, ");
INSERT INTO frasbl_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","vous réserverez à Yahvé tout ce qui ouvre le ventre et tout premier-né d'un animal que vous avez. Les mâles appartiendront à Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Tout premier-né d'un âne, tu le rachèteras avec un agneau ; si tu ne le rachètes pas, tu lui briseras le cou ; et tu rachèteras tous les premiers-nés de l'homme parmi tes fils. ");
INSERT INTO frasbl_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Lorsque ton fils te demandera un jour : « Qu'est-ce que cela ? », tu lui diras : « C'est par la force de sa main que Yahvé nous a fait sortir d'Égypte, de la maison de servitude. ");
INSERT INTO frasbl_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Lorsque Pharaon s'est obstiné à ne pas nous laisser partir, Yahvé a tué tous les premiers-nés du pays d'Égypte, aussi bien les premiers-nés des hommes que ceux du bétail. C'est pourquoi je sacrifie à Yahvé tout ce qui ouvre les entrailles, c'est-à-dire les mâles ; mais je rachète tous les premiers-nés de mes fils'. ");
INSERT INTO frasbl_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Ce sera un signe sur ta main et des symboles entre tes yeux, car c'est par la force de la main que Yahvé nous a fait sortir d'Égypte. » ");
INSERT INTO frasbl_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Lorsque Pharaon eut laissé partir le peuple, Dieu ne le conduisit pas par le chemin du pays des Philistins, qui était pourtant tout proche, car Dieu dit : « De peur que le peuple ne change d'avis en voyant la guerre, et qu'il ne retourne en Égypte » ; ");
INSERT INTO frasbl_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","mais Dieu conduisit le peuple par le chemin du désert, près de la mer Rouge ; et les enfants d'Israël montèrent armés hors du pays d'Égypte. ");
INSERT INTO frasbl_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Moïse prit avec lui les ossements de Joseph, car il avait fait jurer les enfants d'Israël en disant : « Dieu vous visitera et vous emporterez avec vous mes ossements loin d'ici. » ");
INSERT INTO frasbl_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Ils partirent de Succoth et campèrent à Étham, à l'extrémité du désert. ");
INSERT INTO frasbl_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","L'Éternel marchait devant eux, le jour dans une colonne de nuée, pour les conduire sur leur chemin, et la nuit dans une colonne de feu, pour les éclairer, afin qu'ils pussent marcher de jour et de nuit. ");
INSERT INTO frasbl_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","La colonne de nuée, le jour, et la colonne de feu, la nuit, ne s'écartaient pas de devant le peuple. ");
INSERT INTO frasbl_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Yahvé parla à Moïse, et dit : ");
INSERT INTO frasbl_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","Parle aux enfants d'Israël, pour qu'ils fassent demi-tour et campent devant Pihahiroth, entre Migdol et la mer, devant Baal Zephon. Vous camperez en face d'elle, près de la mer. ");
INSERT INTO frasbl_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Pharaon dira des enfants d'Israël : « Ils sont empêtrés dans le pays. Le désert les a enfermés. ");
INSERT INTO frasbl_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","J'endurcirai le cœur de Pharaon, et il les suivra ; je m'assurerai la gloire sur Pharaon et sur toutes ses armées, et les Égyptiens sauront que je suis Yahvé. » C'est ce qu'ils firent. ");
INSERT INTO frasbl_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","On apprit au roi d'Égypte que le peuple s'était enfui ; le cœur de Pharaon et de ses serviteurs fut changé à l'égard du peuple, et ils dirent : « Qu'avons-nous donc fait, pour laisser Israël s'enfuir loin de nous ? » ");
INSERT INTO frasbl_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Il prépara son char et prit avec lui son armée ; ");
INSERT INTO frasbl_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","il prit six cents chars d'élite et tous les chars d'Égypte, avec des chefs sur chacun d'eux. ");
INSERT INTO frasbl_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Yahvé endurcit le cœur de Pharaon, roi d'Égypte, et il poursuivit les enfants d'Israël, car les enfants d'Israël sortaient avec une main levée. ");
INSERT INTO frasbl_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Les Égyptiens les poursuivirent. Tous les chevaux et les chars de Pharaon, ses cavaliers et son armée les rattrapèrent en campant près de la mer, à côté de Pihahiroth, devant Baal Zephon. ");
INSERT INTO frasbl_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Lorsque Pharaon s'approcha, les enfants d'Israël levèrent les yeux, et voici que les Égyptiens marchaient à leur poursuite ; ils eurent très peur. Les enfants d'Israël crièrent à Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Ils dirent à Moïse : « Parce qu'il n'y avait pas de tombeaux en Égypte, nous as-tu emmenés mourir dans le désert ? Pourquoi nous as-tu traités de la sorte, pour nous faire sortir d'Égypte ? ");
INSERT INTO frasbl_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","N'est-ce pas là la parole que nous t'avons adressée en Égypte, en te disant : « Laisse-nous tranquilles, pour que nous servions les Égyptiens » ? Car il aurait mieux valu pour nous servir les Égyptiens que de mourir dans le désert. » ");
INSERT INTO frasbl_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Moïse dit au peuple : « N'ayez pas peur. Restez immobiles et voyez le salut de l'Éternel, qu'il va opérer pour vous aujourd'hui, car vous ne verrez plus jamais les Égyptiens que vous avez vus aujourd'hui. ");
INSERT INTO frasbl_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","L'Éternel combattra pour vous, et vous resterez tranquilles. » ");
INSERT INTO frasbl_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Yahvé dit à Moïse : « Pourquoi cries-tu vers moi ? Parle aux enfants d'Israël, pour qu'ils avancent. ");
INSERT INTO frasbl_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Lève ta verge, étends ta main sur la mer et divise-la. Les enfants d'Israël entreront à sec au milieu de la mer. ");
INSERT INTO frasbl_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Voici, je vais moi-même endurcir le cœur des Égyptiens, et ils entreront après eux. Je me rendrai maître de Pharaon et de toutes ses armées, de ses chars et de ses cavaliers. ");
INSERT INTO frasbl_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Les Égyptiens sauront que je suis Yahvé, quand je me serai acquis la gloire sur Pharaon, sur ses chars et sur ses cavaliers. » ");
INSERT INTO frasbl_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","L'ange de Dieu, qui marchait devant le camp d'Israël, se déplaça et alla derrière eux ; et la colonne de nuée se déplaça de devant eux, et se tint derrière eux. ");
INSERT INTO frasbl_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Elle se plaça entre le camp d'Égypte et le camp d'Israël. Il y avait la nuée et les ténèbres, et pourtant elle donnait de la lumière pendant la nuit. L'un ne s'approchait pas de l'autre de toute la nuit. ");
INSERT INTO frasbl_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Moïse étendit sa main sur la mer, et Yahvé fit reculer la mer par un fort vent d'est toute la nuit ; il mit la mer à sec, et les eaux se partagèrent. ");
INSERT INTO frasbl_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Les enfants d'Israël entrèrent au milieu de la mer à sec, et les eaux formaient pour eux une muraille à droite et à gauche. ");
INSERT INTO frasbl_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Les Égyptiens les poursuivirent et entrèrent après eux au milieu de la mer : tous les chevaux de Pharaon, ses chars et ses cavaliers. ");
INSERT INTO frasbl_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","A la veille du matin, Yahvé regarda l'armée égyptienne à travers la colonne de feu et de nuée, et il confondit l'armée égyptienne. ");
INSERT INTO frasbl_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Il enleva les roues de leurs chars et les fit rouler lourdement, si bien que les Égyptiens dirent : « Fuyons devant Israël, car Yahvé combat pour eux contre les Égyptiens ! ». ");
INSERT INTO frasbl_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Yahvé dit à Moïse : « Étends ta main sur la mer, afin que les eaux reviennent sur les Égyptiens, sur leurs chars et sur leurs cavaliers. » ");
INSERT INTO frasbl_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Moïse étendit sa main sur la mer, et la mer reprit sa force à l'apparition du matin ; les Égyptiens s'enfuirent devant elle. Yahvé renversa les Égyptiens au milieu de la mer. ");
INSERT INTO frasbl_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Les eaux revinrent et couvrirent les chars et les cavaliers, toute l'armée de Pharaon qui entra après eux dans la mer. Il n'en resta pas un seul. ");
INSERT INTO frasbl_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Mais les enfants d'Israël marchaient à sec au milieu de la mer, et les eaux leur servaient de muraille à droite et à gauche. ");
INSERT INTO frasbl_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Ce jour-là, Yahvé sauva Israël de la main des Égyptiens, et Israël vit les Égyptiens morts au bord de la mer. ");
INSERT INTO frasbl_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Israël vit la grande œuvre que Yahvé avait faite aux Égyptiens, et le peuple craignit Yahvé ; et ils crurent en Yahvé et en son serviteur Moïse. ");
INSERT INTO frasbl_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Alors Moïse et les enfants d'Israël chantèrent ce cantique à Yahvé, et dirent, « Je chanterai à Yahvé, car il a triomphé glorieusement. Il a jeté le cheval et son cavalier dans la mer. ");
INSERT INTO frasbl_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Yah est ma force et mon chant. Il est devenu mon salut. C'est mon Dieu, et je le louerai ; le Dieu de mon père, et je l'exalterai. ");
INSERT INTO frasbl_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Yahvé est un homme de guerre. Yahvé est son nom. ");
INSERT INTO frasbl_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Il a jeté dans la mer les chars de Pharaon et son armée. Ses capitaines choisis sont coulés dans la Mer Rouge. ");
INSERT INTO frasbl_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Les profondeurs les recouvrent. Ils sont descendus dans les profondeurs comme une pierre. ");
INSERT INTO frasbl_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Ta droite, Yahvé, est glorieuse en puissance. Ta main droite, Yahvé, met l'ennemi en pièces. ");
INSERT INTO frasbl_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Dans la grandeur de ton excellence, tu renverses ceux qui s'élèvent contre toi. Tu envoies ta colère. Elle les consume comme du chaume. ");
INSERT INTO frasbl_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Par le souffle de tes narines, les eaux se sont amoncelées. Les inondations se sont redressées comme un tas. Les profondeurs étaient figées au cœur de la mer. ");
INSERT INTO frasbl_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","L'ennemi dit : « Je poursuivrai. Je les rattraperai. Je partagerai le butin. Mon désir sera satisfait sur eux. Je tirerai mon épée. Ma main les détruira. ");
INSERT INTO frasbl_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Tu as soufflé avec ton vent. La mer les a recouverts. Ils ont coulé comme du plomb dans les eaux puissantes. ");
INSERT INTO frasbl_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Qui est comme toi, Yahvé, parmi les dieux ? qui est comme toi, glorieux dans la sainteté, redoutant les louanges, faisant des merveilles ? ");
INSERT INTO frasbl_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Tu as étendu ta main droite. La terre les a avalés. ");
INSERT INTO frasbl_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","« Toi, dans ta bonté, tu as conduit le peuple que tu as racheté. Tu les as guidés dans ta force jusqu'à ta demeure sainte. ");
INSERT INTO frasbl_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Les peuples ont entendu. Ils tremblent. Les habitants de Philadelphie ont été frappés par les douleurs. ");
INSERT INTO frasbl_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Alors les chefs d'Edom furent consternés. Le tremblement s'empare des hommes puissants de Moab. Tous les habitants de Canaan ont fondu. ");
INSERT INTO frasbl_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","La terreur et l'effroi s'abattent sur eux. Par la grandeur de ton bras, ils sont immobiles comme une pierre, jusqu'à ce que ton peuple passe, Yahvé, jusqu'au passage des personnes que vous avez achetées. ");
INSERT INTO frasbl_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Tu les feras entrer et tu les planteras dans la montagne de ton héritage, le lieu, Yahvé, que tu t'es fait pour y habiter : le sanctuaire, Seigneur, que tes mains ont établi. ");
INSERT INTO frasbl_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Yahvé régnera pour toujours et à jamais. » ");
INSERT INTO frasbl_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Car les chevaux de Pharaon, avec ses chars et ses cavaliers, entrèrent dans la mer, et Yahvé ramena sur eux les eaux de la mer ; mais les enfants d'Israël marchèrent à sec au milieu de la mer. ");
INSERT INTO frasbl_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Miriam, la prophétesse, sœur d'Aaron, prit un tambourin dans sa main ; et toutes les femmes sortirent après elle avec des tambourins et en dansant. ");
INSERT INTO frasbl_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Miriam leur répondit, « Chantez à Yahvé, car il a triomphé avec gloire. Il a jeté le cheval et son cavalier dans la mer. » ");
INSERT INTO frasbl_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Moïse fit partir Israël de la mer Rouge, et ils entrèrent dans le désert de Schur. Ils marchèrent trois jours dans le désert, et ne trouvèrent point d'eau. ");
INSERT INTO frasbl_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Lorsqu'ils arrivèrent à Mara, ils ne purent boire des eaux de Mara, car elles étaient amères. C'est pourquoi on l'appela Mara. ");
INSERT INTO frasbl_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Le peuple murmura contre Moïse, en disant : « Que boirons-nous ? » ");
INSERT INTO frasbl_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Moïse cria à Yahvé. Yahvé lui montra un arbre, qu'il jeta dans les eaux, et les eaux devinrent douces. Là, il établit pour eux une loi et une ordonnance, et là, il les mit à l'épreuve. ");
INSERT INTO frasbl_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Il dit : « Si vous écoutez attentivement la voix de l'Éternel, votre Dieu, si vous faites ce qui est juste à ses yeux, si vous êtes attentifs à ses commandements et si vous observez toutes ses lois, je ne vous infligerai aucune des maladies que j'ai infligées aux Égyptiens, car je suis l'Éternel qui vous guérit. » ");
INSERT INTO frasbl_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Ils arrivèrent à Elim, où il y avait douze sources d'eau et soixante-dix palmiers. Ils campèrent là, près des eaux. ");
INSERT INTO frasbl_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Ils partirent d'Elim, et toute l'assemblée des enfants d'Israël arriva au désert de Sin, qui est entre Elim et Sinaï, le quinzième jour du second mois après leur sortie du pays d'Égypte. ");
INSERT INTO frasbl_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Toute l'assemblée des enfants d'Israël murmura contre Moïse et Aaron dans le désert ; ");
INSERT INTO frasbl_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","et les enfants d'Israël leur dirent : « Nous aurions voulu mourir par la main de Yahvé dans le pays d'Égypte, quand nous étions assis près des marmites à viande, quand nous mangions du pain à satiété, car vous nous avez fait sortir dans ce désert pour tuer toute cette assemblée par la faim. » ");
INSERT INTO frasbl_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Yahvé dit à Moïse : « Voici, je ferai pleuvoir pour vous du pain du ciel, et le peuple sortira et ramassera chaque jour une portion d'un jour, afin de l'éprouver pour savoir s'il marchera ou non dans ma loi. ");
INSERT INTO frasbl_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Le sixième jour, ils prépareront ce qu'ils auront apporté, et ce sera le double de ce qu'ils auront ramassé chaque jour. » ");
INSERT INTO frasbl_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Moïse et Aaron dirent à tous les enfants d'Israël : « Le soir, vous saurez que Yahvé vous a fait sortir du pays d'Égypte. ");
INSERT INTO frasbl_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Au matin, vous verrez la gloire de l'Éternel, car il a entendu vos murmures contre l'Éternel. Qui sommes-nous, pour que vous murmuriez contre nous ? » ");
INSERT INTO frasbl_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Moïse dit : « Maintenant, Yahvé vous donnera de la viande à manger le soir, et le matin du pain pour vous rassasier, parce que Yahvé entend les murmures que vous murmurez contre lui. Et nous, qui sommes-nous ? Vos murmures ne sont pas contre nous, mais contre Yahvé. » ");
INSERT INTO frasbl_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Moïse dit à Aaron : « Dis à toute l'assemblée des enfants d'Israël : « Approchez-vous de l'Éternel, car il a entendu vos murmures ». ");
INSERT INTO frasbl_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Comme Aaron parlait à toute l'assemblée des enfants d'Israël, ils regardèrent vers le désert, et voici que la gloire de Yahvé apparut dans la nuée. ");
INSERT INTO frasbl_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Yahvé parla à Moïse et dit : ");
INSERT INTO frasbl_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","« J'ai entendu les murmures des enfants d'Israël. Parle-leur en disant : « Le soir, vous mangerez de la viande, et le matin, vous serez rassasiés de pain. Alors vous saurez que je suis Yahvé votre Dieu ». ");
INSERT INTO frasbl_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Le soir, les cailles montèrent et couvrirent le camp ; et le matin, la rosée s'étendit autour du camp. ");
INSERT INTO frasbl_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Lorsque la rosée qui s'était déposée eut disparu, voici qu'il y avait à la surface du désert une petite chose ronde, aussi petite que le givre sur le sol. ");
INSERT INTO frasbl_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Lorsque les enfants d'Israël la virent, ils se dirent les uns aux autres : « Qu'est-ce que c'est ? » Car ils ne savaient pas ce que c'était. Moïse leur dit : « C'est le pain que l'Éternel vous donne à manger. ");
INSERT INTO frasbl_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Voici ce que l'Éternel a ordonné : « Recueillez-en chacun selon ce qu'il mange : un omer par tête, selon le nombre de vos personnes, vous en prendrez chacun pour ceux qui sont dans sa tente. » ");
INSERT INTO frasbl_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Les enfants d'Israël firent ainsi ; les uns en recueillirent davantage, les autres moins. ");
INSERT INTO frasbl_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Quand ils mesurèrent avec un omer, celui qui avait beaucoup ramassé ne manqua de rien, et celui qui avait peu ramassé ne manqua de rien. Chacun ramassait selon ce qu'il mangeait. ");
INSERT INTO frasbl_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Moïse leur dit : « Que personne n'en laisse jusqu'au matin. » ");
INSERT INTO frasbl_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Mais ils n'écoutèrent pas Moïse, et quelques-uns d'entre eux en laissèrent jusqu'au matin, de sorte qu'il y eut des vers et que le produit devint fétide ; Moïse fut irrité contre eux. ");
INSERT INTO frasbl_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Ils le ramassèrent matin par matin, chacun selon sa consommation. Lorsque le soleil se mit à chauffer, elle fondit. ");
INSERT INTO frasbl_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Le sixième jour, ils ramassèrent deux fois plus de pain, deux omers pour chacun. Tous les chefs de l'assemblée vinrent en parler à Moïse. ");
INSERT INTO frasbl_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Celui-ci leur dit : « Voici ce qu'a dit l'Éternel : Demain est un repos solennel, un sabbat consacré à l'Éternel. Faites cuire ce que vous voulez faire cuire, faites bouillir ce que vous voulez faire bouillir, et tout ce qui restera vous sera réservé pour être gardé jusqu'au matin. ");
INSERT INTO frasbl_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Ils le conservèrent jusqu'au matin, comme Moïse l'avait ordonné, et il ne devint pas infecte, et il n'y avait pas de vers dedans. ");
INSERT INTO frasbl_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Moïse dit : « Mangez-en aujourd'hui, car aujourd'hui est un jour de sabbat pour l'Éternel. Aujourd'hui, vous ne la trouverez pas dans les champs. ");
INSERT INTO frasbl_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Pendant six jours, vous le ramasserez, mais le septième jour est le sabbat. Il n'y en aura point. » ");
INSERT INTO frasbl_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Le septième jour, une partie du peuple sortit pour ramasser, mais ils ne trouvèrent rien. ");
INSERT INTO frasbl_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Yahvé dit à Moïse : « Jusques à quand refuserez-vous d'observer mes commandements et mes lois ? ");
INSERT INTO frasbl_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Voici, parce que Yahvé vous a donné le sabbat, il vous donne le sixième jour le pain de deux jours. Que chacun reste à sa place. Que personne ne sorte de sa place le septième jour. » ");
INSERT INTO frasbl_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Le peuple se reposa donc le septième jour. ");
INSERT INTO frasbl_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","La maison d'Israël l'appela « Manne ». Elle était semblable à de la graine de coriandre, de couleur blanche, et son goût était semblable à celui des galettes au miel. ");
INSERT INTO frasbl_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Moïse dit : « Voici ce que Yahvé a ordonné : qu'on en garde un omer plein pour vos descendants, afin qu'ils voient le pain dont je vous ai nourris dans le désert, quand je vous ai fait sortir du pays d'Égypte ». ");
INSERT INTO frasbl_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Moïse dit à Aaron : « Prends un pot, mets-y un omer plein de manne et dépose-le devant l'Éternel, pour qu'il soit conservé par vos générations. » ");
INSERT INTO frasbl_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Comme l'Éternel l'avait ordonné à Moïse, Aaron la déposa devant le Témoignage, pour qu'elle soit conservée. ");
INSERT INTO frasbl_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Les enfants d'Israël mangèrent la manne pendant quarante ans, jusqu'à leur arrivée dans un pays habité. Ils mangèrent la manne jusqu'à ce qu'ils arrivent aux frontières du pays de Canaan. ");
INSERT INTO frasbl_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Or, un omer, c'est le dixième d'un épha. ");
INSERT INTO frasbl_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Toute la congrégation des enfants d'Israël partit du désert de Sin, selon l'ordre de l'Éternel, et campa à Rephidim ; mais il n'y avait pas d'eau à boire pour le peuple. ");
INSERT INTO frasbl_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Le peuple se querella avec Moïse, et dit : « Donne-nous de l'eau à boire. » Moïse leur dit : « Pourquoi vous disputez-vous avec moi ? Pourquoi mettez-vous Yahvé à l'épreuve ? » ");
INSERT INTO frasbl_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Le peuple avait soif d'eau à cet endroit ; alors le peuple murmura contre Moïse et dit : « Pourquoi nous as-tu fait sortir d'Égypte, pour nous faire mourir de soif, nous, nos enfants et notre bétail ? » ");
INSERT INTO frasbl_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Moïse cria à Yahvé en disant : « Que dois-je faire de ce peuple ? Ils sont presque prêts à me lapider. » ");
INSERT INTO frasbl_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Yahvé dit à Moïse : « Avance devant le peuple, prends avec toi les anciens d'Israël, prends dans ta main le bâton avec lequel tu as frappé le Nil, et pars. ");
INSERT INTO frasbl_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Voici, je me tiendrai devant toi, là, sur le rocher de l'Horeb. Tu frapperas le rocher, et il en sortira de l'eau que le peuple pourra boire. » Moïse fit ainsi, sous les yeux des anciens d'Israël. ");
INSERT INTO frasbl_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Il donna à ce lieu le nom de Massa et de Meriba, parce que les enfants d'Israël se disputaient et qu'ils mettaient Yahvé à l'épreuve, en disant : « Yahvé est-il au milieu de nous, ou non ? » ");
INSERT INTO frasbl_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Amalek vint combattre Israël à Rephidim. ");
INSERT INTO frasbl_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Moïse dit à Josué : « Choisis des hommes pour nous, et va combattre Amalek. Demain, je me tiendrai sur le sommet de la colline, la verge de Dieu dans ma main. » ");
INSERT INTO frasbl_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Josué fit ce que Moïse lui avait dit et combattit Amalek. Moïse, Aaron et Hur montèrent au sommet de la colline. ");
INSERT INTO frasbl_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Lorsque Moïse leva la main, Israël l'emporta. Quand il baissa la main, Amalek l'emporta. ");
INSERT INTO frasbl_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Mais les mains de Moïse étaient lourdes ; on prit donc une pierre, on la mit sous lui, et il s'assit dessus. Aaron et Hur soutenaient ses mains, l'un d'un côté, l'autre de l'autre. Ses mains restèrent stables jusqu'au coucher du soleil. ");
INSERT INTO frasbl_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Josué vainquit Amalek et son peuple au fil de l'épée. ");
INSERT INTO frasbl_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Yahvé dit à Moïse : « Ecris ceci dans un livre, comme souvenir, et répète-le aux oreilles de Josué : j'effacerai la mémoire d'Amalek de dessous le ciel. » ");
INSERT INTO frasbl_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Moïse bâtit un autel et l'appela « Yahvé notre bannière ». ");
INSERT INTO frasbl_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Il dit : « L'Éternel l'a juré : l'Éternel fera la guerre à Amalek de génération en génération. » ");
INSERT INTO frasbl_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Jéthro, sacrificateur de Madian, beau-père de Moïse, apprit tout ce que Dieu avait fait pour Moïse et pour Israël, son peuple, comment Yahvé avait fait sortir Israël d'Égypte. ");
INSERT INTO frasbl_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Jéthro, beau-père de Moïse, reçut Zippora, la femme de Moïse, après qu'il l'eut renvoyée, ");
INSERT INTO frasbl_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","et ses deux fils. Le nom de l'un des fils était Gershom, car Moïse avait dit : « J'ai vécu comme un étranger dans un pays étranger ». ");
INSERT INTO frasbl_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Le nom de l'autre était Eliezer, car il disait : « Le Dieu de mon père m'a secouru et m'a délivré de l'épée de Pharaon ». ");
INSERT INTO frasbl_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Jéthro, beau-père de Moïse, vint avec les fils de Moïse et sa femme auprès de Moïse dans le désert où il campait, à la montagne de Dieu. ");
INSERT INTO frasbl_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Il dit à Moïse : « Moi, Jéthro, ton beau-père, je suis venu vers toi avec ta femme, et ses deux fils avec elle. » ");
INSERT INTO frasbl_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Moïse sortit à la rencontre de son beau-père, se prosterna et l'embrassa. Ils s'informèrent mutuellement de leur bien-être, puis ils entrèrent dans la tente. ");
INSERT INTO frasbl_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Moïse raconta à son beau-père tout ce que Yahvé avait fait à Pharaon et aux Égyptiens à cause d'Israël, toutes les épreuves qui les avaient frappés en chemin, et comment Yahvé les avait délivrés. ");
INSERT INTO frasbl_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Jéthro se réjouit de tout le bien que Yahvé avait fait à Israël, en le délivrant de la main des Égyptiens. ");
INSERT INTO frasbl_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Jéthro dit : « Béni soit Yahvé, qui vous a délivrés de la main des Égyptiens et de la main de Pharaon, qui a délivré le peuple de la main des Égyptiens. ");
INSERT INTO frasbl_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Je sais maintenant que Yahvé est plus grand que tous les dieux, à cause de la manière dont ils ont traité le peuple avec arrogance. » ");
INSERT INTO frasbl_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Jéthro, le beau-père de Moïse, prit un holocauste et des sacrifices pour Dieu. Aaron vint avec tous les anciens d'Israël, pour manger le pain avec le beau-père de Moïse devant Dieu. ");
INSERT INTO frasbl_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Le lendemain, Moïse s'assit pour juger le peuple, et le peuple se tint autour de Moïse du matin au soir. ");
INSERT INTO frasbl_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Lorsque le beau-père de Moïse vit tout ce qu'il faisait au peuple, il dit : « Qu'est-ce que c'est que cette chose que tu fais pour le peuple ? Pourquoi t'assieds-tu seul, alors que tout le peuple se tient autour de toi du matin au soir ? ». ");
INSERT INTO frasbl_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Moïse dit à son beau-père : « Parce que le peuple vient à moi pour consulter Dieu. ");
INSERT INTO frasbl_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Quand ils ont une affaire, ils viennent à moi, et je juge entre un homme et son prochain, et je leur fais connaître les statuts de Dieu et ses lois. » ");
INSERT INTO frasbl_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Le beau-père de Moïse lui dit : « La chose que tu fais n'est pas bonne. ");
INSERT INTO frasbl_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Tu vas certainement t'épuiser, toi et ce peuple qui est avec toi, car la chose est trop lourde pour toi. Tu n'es pas capable de l'accomplir tout seul. ");
INSERT INTO frasbl_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Écoute maintenant ma voix. Je te donnerai un conseil, et que Dieu soit avec toi. Tu représentes le peuple devant Dieu, et tu portes les causes devant Dieu. ");
INSERT INTO frasbl_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Tu leur enseigneras les statuts et les lois, tu leur montreras la voie dans laquelle ils doivent marcher et le travail qu'ils doivent faire. ");
INSERT INTO frasbl_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Tu trouveras dans tout le peuple des hommes capables, qui craignent Dieu, des hommes de vérité, qui haïssent les gains injustes, et tu les placeras à leur tête, comme chefs de milliers, chefs de centaines, chefs de cinquantaines et chefs de dizaines. ");
INSERT INTO frasbl_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Qu'ils jugent le peuple en tout temps. Ils t'apporteront toute grande affaire, mais ils jugeront eux-mêmes toute petite affaire. Cela vous facilitera la tâche, et ils partageront le fardeau avec vous. ");
INSERT INTO frasbl_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Si tu fais cela, et que Dieu te l'ordonne, tu pourras supporter, et tous ces gens-là aussi iront en paix à leur place. » ");
INSERT INTO frasbl_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Moïse écouta la voix de son beau-père et fit tout ce qu'il avait dit. ");
INSERT INTO frasbl_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Moïse choisit des hommes capables parmi tout Israël, et il les établit chefs du peuple, chefs de milliers, chefs de centaines, chefs de cinquièmes et chefs de dizaines. ");
INSERT INTO frasbl_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Ils jugeaient le peuple en tout temps. Ils apportaient à Moïse les affaires difficiles, mais ils jugeaient eux-mêmes toutes les petites affaires. ");
INSERT INTO frasbl_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Moïse laissa partir son beau-père, qui s'en alla dans son pays. ");
INSERT INTO frasbl_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Le troisième mois après que les enfants d'Israël furent sortis du pays d'Égypte, ils arrivèrent ce même jour dans le désert de Sinaï. ");
INSERT INTO frasbl_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Ils partirent de Rephidim, et arrivèrent au désert de Sinaï ; ils campèrent dans le désert, et là, Israël campa devant la montagne. ");
INSERT INTO frasbl_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Moïse monta vers Dieu, et Yahvé l'appela de la montagne, en disant : « Voici ce que tu diras à la maison de Jacob et aux enfants d'Israël : ");
INSERT INTO frasbl_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Vous avez vu ce que j'ai fait aux Égyptiens, et comment je vous ai portés sur des ailes d'aigle et amenés vers moi. ");
INSERT INTO frasbl_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Maintenant, si vous écoutez ma voix et si vous gardez mon alliance, vous serez ma propriété entre tous les peuples, car toute la terre est à moi, ");
INSERT INTO frasbl_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","et vous serez pour moi un royaume de prêtres et une nation sainte ». Telles sont les paroles que tu adresseras aux enfants d'Israël. » ");
INSERT INTO frasbl_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Moïse vint appeler les anciens du peuple, et il exposa devant eux toutes ces paroles que l'Éternel lui avait commandées. ");
INSERT INTO frasbl_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Tout le peuple prit la parole et dit : « Nous ferons tout ce que l'Éternel a dit. » Moïse rapporta à Yahvé les paroles du peuple. ");
INSERT INTO frasbl_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Yahvé dit à Moïse : « Voici que je viens à toi dans une épaisse nuée, afin que le peuple entende quand je te parlerai, et qu'il te croie toujours. » Moïse rapporta à Yahvé les paroles du peuple. ");
INSERT INTO frasbl_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Yahvé dit à Moïse : « Va vers le peuple, sanctifie-le aujourd'hui et demain, fais-lui laver ses vêtements, ");
INSERT INTO frasbl_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","et tiens-toi prêt pour le troisième jour, car le troisième jour, Yahvé descendra sur la montagne de Sinaï aux yeux de tout le peuple. ");
INSERT INTO frasbl_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Tu fixeras des limites au peuple tout autour, en disant : « Prenez garde de ne pas monter sur la montagne et de ne pas toucher son bord. Celui qui touchera la montagne sera puni de mort. ");
INSERT INTO frasbl_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Aucune main ne le touchera, mais il sera lapidé ou transpercé de balles, qu'il s'agisse d'un animal ou d'un homme, il ne vivra pas. Lorsque la trompette sonnera longuement, ils monteront sur la montagne. » ");
INSERT INTO frasbl_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Moïse descendit de la montagne vers le peuple et sanctifia le peuple, qui lava ses vêtements. ");
INSERT INTO frasbl_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Il dit au peuple : « Soyez prêts le troisième jour. N'ayez pas de relations sexuelles avec une femme. » ");
INSERT INTO frasbl_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Le troisième jour, comme c'était le matin, il y eut des tonnerres et des éclairs, une épaisse nuée sur la montagne, et le son d'une trompette extrêmement forte ; et tout le peuple qui était dans le camp trembla. ");
INSERT INTO frasbl_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Moïse conduisit le peuple hors du camp à la rencontre de Dieu, et ils se tinrent au bas de la montagne. ");
INSERT INTO frasbl_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Toute la montagne de Sinaï fumait, car Yahvé y était descendu en feu ; sa fumée montait comme la fumée d'une fournaise, et toute la montagne tremblait fortement. ");
INSERT INTO frasbl_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Le son de la trompette devenant de plus en plus fort, Moïse parla, et Dieu lui répondit par une voix. ");
INSERT INTO frasbl_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Yahvé descendit sur le mont Sinaï, au sommet de la montagne. Yahvé appela Moïse au sommet de la montagne, et Moïse y monta. ");
INSERT INTO frasbl_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","L'Éternel dit à Moïse : « Descends, avertis le peuple, de peur qu'il ne s'introduise auprès de l'Éternel pour le regarder, et que beaucoup d'entre eux ne périssent. ");
INSERT INTO frasbl_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Que les prêtres aussi, qui s'approchent de l'Éternel, se sanctifient, de peur que l'Éternel ne fasse irruption sur eux. » ");
INSERT INTO frasbl_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Moïse dit à Yahvé : « Le peuple ne peut pas monter sur le mont Sinaï, car tu nous as prévenus en disant : « Entourez la montagne et sanctifiez-la. » ");
INSERT INTO frasbl_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Yahvé lui dit : « Descends ! Tu feras monter Aaron avec toi, mais ne laisse pas les prêtres et le peuple passer pour monter vers Yahvé, de peur qu'il ne se déchaîne contre eux. » ");
INSERT INTO frasbl_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Moïse descendit donc vers le peuple, et lui dit. ");
INSERT INTO frasbl_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Dieu prononça toutes ces paroles, en disant : ");
INSERT INTO frasbl_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","« Je suis Yahvé, ton Dieu, qui t'ai fait sortir du pays d'Égypte, de la maison de servitude. ");
INSERT INTO frasbl_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","« Tu n'auras pas d'autres dieux devant moi. ");
INSERT INTO frasbl_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","« Tu ne te feras pas d'idole, ni d'image de ce qui est dans les cieux en haut, sur la terre en bas, ou dans les eaux au-dessous de la terre ; ");
INSERT INTO frasbl_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","tu ne te prosterneras pas devant elles et tu ne les serviras pas, car moi, Yahvé ton Dieu, je suis un Dieu jaloux, qui punit l'iniquité des pères sur les enfants, sur la troisième et la quatrième génération de ceux qui me haïssent, ");
INSERT INTO frasbl_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","et qui fait preuve de bonté envers les milliers de ceux qui m'aiment et qui gardent mes commandements. ");
INSERT INTO frasbl_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","« Tu n'abuseras pas du nom de Yahvé ton Dieu, car Yahvé ne laisse pas impuni celui qui abuse de son nom. ");
INSERT INTO frasbl_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","« Souviens-toi du jour du sabbat, pour le sanctifier. ");
INSERT INTO frasbl_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Tu travailleras six jours et tu feras tout ton ouvrage, ");
INSERT INTO frasbl_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","mais le septième jour est un sabbat pour Yahvé, ton Dieu. Tu ne feras aucun ouvrage, ni toi, ni ton fils, ni ta fille, ni ton serviteur, ni ta servante, ni ton bétail, ni l'étranger qui sera dans tes portes. ");
INSERT INTO frasbl_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Car en six jours, Yahvé a fait le ciel et la terre, la mer et tout ce qui s'y trouve, et il s'est reposé le septième jour. ");
INSERT INTO frasbl_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","« Honore ton père et ta mère, afin que tes jours se prolongent dans le pays que Yahvé ton Dieu te donne. ");
INSERT INTO frasbl_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","« Tu ne commettras pas de meurtre. ");
INSERT INTO frasbl_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","« Tu ne commettras pas d'adultère. ");
INSERT INTO frasbl_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","« Tu ne voleras pas. ");
INSERT INTO frasbl_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","« Tu ne porteras pas de faux témoignage contre ton prochain. ");
INSERT INTO frasbl_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","« Tu ne convoiteras pas la maison de ton prochain. Tu ne convoiteras pas la femme de ton prochain, ni son serviteur, ni sa servante, ni son bœuf, ni son âne, ni rien de ce qui appartient à ton prochain. » ");
INSERT INTO frasbl_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Tout le peuple perçut les tonnerres, les éclairs, le son de la trompette et la montagne fumante. Quand le peuple vit cela, il trembla et resta à distance. ");
INSERT INTO frasbl_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Ils dirent à Moïse : « Parle-nous toi-même, et nous écouterons ; mais ne laisse pas Dieu nous parler, de peur que nous ne mourions. » ");
INSERT INTO frasbl_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Moïse dit au peuple : « N'ayez pas peur, car Dieu est venu pour vous mettre à l'épreuve, et pour que sa crainte soit devant vous, afin que vous ne péchiez pas. » ");
INSERT INTO frasbl_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Le peuple resta à distance, et Moïse s'approcha de l'épaisse obscurité où se trouvait Dieu. ");
INSERT INTO frasbl_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Yahvé dit à Moïse : « Voici ce que tu diras aux enfants d'Israël : « Vous avez vu vous-mêmes que je vous ai parlé depuis le ciel. ");
INSERT INTO frasbl_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Vous ne vous ferez certainement pas des dieux d'argent ou des dieux d'or pour être à côté de moi. ");
INSERT INTO frasbl_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Vous me ferez un autel de terre, et vous y sacrifierez vos holocaustes et vos sacrifices de prospérité, vos brebis et vos bœufs. En tout lieu où j'inscrirai mon nom, je viendrai vers vous et je vous bénirai. ");
INSERT INTO frasbl_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Si tu me fais un autel de pierre, tu ne le construiras pas en pierres taillées, car si tu lèves ton outil dessus, tu le souilles. ");
INSERT INTO frasbl_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Tu ne monteras pas par des marches vers mon autel, afin que ta nudité n'y soit pas exposée'. ");
INSERT INTO frasbl_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","« Voici les ordonnances que tu mettras devant eux : ");
INSERT INTO frasbl_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","« Si tu achètes un serviteur hébreu, il servira six ans, et la septième année, il sortira libre, sans rien payer. ");
INSERT INTO frasbl_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","S'il entre seul, il sortira seul. S'il est marié, sa femme sortira avec lui. ");
INSERT INTO frasbl_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Si son maître lui donne une femme et qu'elle lui donne des fils ou des filles, la femme et ses enfants seront à son maître, et il sortira seul. ");
INSERT INTO frasbl_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Mais si le serviteur dit ouvertement : « J'aime mon maître, ma femme et mes enfants. Je ne sortirai pas libre », ");
INSERT INTO frasbl_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","alors son maître le conduira devant Dieu, et l'amènera à la porte ou au montant de la porte ; son maître lui percera l'oreille avec un poinçon, et il le servira pour toujours. ");
INSERT INTO frasbl_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","« Si un homme vend sa fille pour en faire une servante, elle ne sortira pas comme les serviteurs. ");
INSERT INTO frasbl_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Si elle ne plaît pas à son maître, qui l'a épousée pour lui-même, il la laissera racheter. Il n'aura pas le droit de la vendre à un peuple étranger, puisqu'il l'a trompée. ");
INSERT INTO frasbl_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","S'il la marie à son fils, il la traitera comme une fille. ");
INSERT INTO frasbl_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","S'il prend une autre femme pour lui, il ne diminuera pas sa nourriture, ses vêtements et ses droits conjugaux. ");
INSERT INTO frasbl_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","S'il ne fait pas ces trois choses pour elle, elle pourra être libérée sans payer d'argent. ");
INSERT INTO frasbl_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","« Celui qui frappe un homme au point qu'il en meure sera puni de mort, ");
INSERT INTO frasbl_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","mais pas si c'est involontaire et que Dieu le permette ; alors je te désignerai un lieu où il pourra s'enfuir. ");
INSERT INTO frasbl_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Si un homme manigance et s'approche présomptueusement de son prochain pour le tuer, tu le prendras sur mon autel, afin qu'il meure. ");
INSERT INTO frasbl_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","« Quiconque s'en prend à son père ou à sa mère sera puni de mort. ");
INSERT INTO frasbl_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","« Si quelqu'un enlève quelqu'un et le vend, ou si on le trouve dans sa main, il sera puni de mort. ");
INSERT INTO frasbl_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","« Quiconque maudira son père ou sa mère sera puni de mort. ");
INSERT INTO frasbl_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","« Si des hommes se querellent et que l'un d'eux frappe l'autre avec une pierre ou avec son poing, et qu'il ne meure pas, mais qu'il reste alité, ");
INSERT INTO frasbl_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","s'il se relève et se promène avec son bâton, celui qui l'a frappé sera innocenté ; seulement, il paiera pour la perte de son temps et pourvoira à sa guérison jusqu'à ce qu'il soit complètement guéri. ");
INSERT INTO frasbl_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","« Si un homme frappe son serviteur ou sa servante avec une verge, et que celui-ci meurt sous sa main, il sera puni. ");
INSERT INTO frasbl_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Mais si son serviteur se relève après un jour ou deux, il ne sera pas puni, car le serviteur est sa propriété. ");
INSERT INTO frasbl_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","« Si des hommes se battent et blessent une femme enceinte, de sorte qu'elle accouche prématurément, et qu'il n'en résulte aucun dommage, ils seront condamnés à une amende équivalente à celle que le mari de la femme demandera et que les juges autoriseront. ");
INSERT INTO frasbl_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Mais s'il s'ensuit un malheur, il faut rendre la vie pour la vie, ");
INSERT INTO frasbl_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","œil pour œil, dent pour dent, main pour main, pied pour pied, ");
INSERT INTO frasbl_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","brûlure pour brûlure, blessure pour blessure, et meurtrissure pour meurtrissure. ");
INSERT INTO frasbl_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","« Si un homme frappe l'œil de son serviteur ou de sa servante et le détruit, il le laissera aller en liberté à cause de son œil. ");
INSERT INTO frasbl_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","S'il frappe la dent de son serviteur ou de sa servante, il laissera le serviteur libre à cause de sa dent. ");
INSERT INTO frasbl_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","« Si un taureau éventre un homme ou une femme, il sera lapidé, et sa viande ne sera pas mangée ; mais le propriétaire du taureau ne sera pas tenu pour responsable. ");
INSERT INTO frasbl_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Mais si le taureau avait l'habitude d'encorner dans le passé, que cela a été signalé à son propriétaire, que celui-ci ne l'a pas retenu et qu'il a tué un homme ou une femme, le taureau sera lapidé et son propriétaire sera également mis à mort. ");
INSERT INTO frasbl_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Si une rançon lui est imposée, il donnera pour le rachat de sa vie ce qui lui est imposé. ");
INSERT INTO frasbl_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Qu'il ait encorné un fils ou qu'il ait encorné une fille, c'est selon ce jugement qu'il lui sera fait. ");
INSERT INTO frasbl_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Si le taureau a encorné un serviteur ou une servante, on donnera trente sicles d'argent à leur maître, et le bœuf sera lapidé. ");
INSERT INTO frasbl_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","« Si un homme ouvre une fosse, ou si un homme creuse une fosse sans la couvrir, et qu'un taureau ou un âne y tombe, ");
INSERT INTO frasbl_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","le propriétaire de la fosse devra la réparer. Il donnera de l'argent à son propriétaire, et l'animal mort lui appartiendra. ");
INSERT INTO frasbl_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","« Si le taureau d'un homme blesse celui d'un autre, de sorte qu'il meurt, on vendra le taureau vivant et on en partagera le prix ; on partagera aussi l'animal mort. ");
INSERT INTO frasbl_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Ou si l'on sait que le taureau avait l'habitude d'encorner dans le passé, et que son propriétaire ne l'a pas gardé, il paiera taureau pour taureau, et l'animal mort lui appartiendra. ");
INSERT INTO frasbl_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","« Si un homme vole un bœuf ou une brebis, et le tue ou le vend, il paiera cinq bœufs pour un bœuf, et quatre brebis pour une brebis. ");
INSERT INTO frasbl_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Si le voleur est trouvé en train d'entrer par effraction, et qu'il soit frappé de telle sorte qu'il meure, il ne sera pas coupable d'effusion de sang pour lui. ");
INSERT INTO frasbl_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Si le soleil s'est levé sur lui, il est coupable d'effusion de sang. Il devra le restituer. S'il n'a rien, il sera vendu pour son vol. ");
INSERT INTO frasbl_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Si le bien volé est trouvé vivant entre ses mains, qu'il s'agisse d'un bœuf, d'un âne ou d'un mouton, il paiera le double. ");
INSERT INTO frasbl_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","« Si un homme fait paître un champ ou une vigne en laissant son animal en liberté, et que celui-ci paisse dans le champ d'un autre homme, il devra le restituer sur le meilleur de son champ et sur le meilleur de sa vigne. ");
INSERT INTO frasbl_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","« Si un feu éclate et s'accroche à des épines, de sorte que les chocs du grain, le grain sur pied ou le champ soient consumés, celui qui a allumé le feu devra le restituer. ");
INSERT INTO frasbl_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","« Si un homme livre à son prochain de l'argent ou des objets à garder, et qu'on les vole dans la maison de cet homme, si le voleur est trouvé, il paiera le double. ");
INSERT INTO frasbl_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Si le voleur n'est pas trouvé, le maître de la maison s'approchera de Dieu, pour savoir s'il a mis la main sur les biens de son prochain. ");
INSERT INTO frasbl_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Pour toute affaire de dépouillement, qu'il s'agisse d'un bœuf, d'un âne, d'un mouton, d'un vêtement, ou de toute autre chose perdue, au sujet de laquelle quelqu'un dit : « Ceci est à moi », la cause des deux parties sera portée devant Dieu. Celui que Dieu condamne devra payer le double à son prochain. ");
INSERT INTO frasbl_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","« Si un homme livre à son prochain un âne, un bœuf, un mouton, ou tout autre animal à garder, et qu'il meure, soit blessé, soit chassé, sans que personne ne le voie, ");
INSERT INTO frasbl_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","le serment de Yahvé sera entre eux deux : il n'a pas mis la main sur le bien de son prochain ; son propriétaire l'acceptera, et il ne le restituera pas. ");
INSERT INTO frasbl_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Mais s'il lui est volé, celui qui a volé devra le restituer à son propriétaire. ");
INSERT INTO frasbl_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","S'il est déchiré en morceaux, qu'il l'apporte comme preuve. Il ne restituera pas ce qui a été déchiré. ");
INSERT INTO frasbl_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Si un homme emprunte un objet à son prochain, et que cet objet se blesse ou meurt sans que son propriétaire soit avec lui, il devra le restituer. ");
INSERT INTO frasbl_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Si son propriétaire est avec elle, il ne la restituera pas. Si c'est un objet loué, il est venu pour son bail. ");
INSERT INTO frasbl_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Si un homme séduit une vierge qui n'est pas promise au mariage et couche avec elle, il paiera une dot pour qu'elle devienne sa femme. ");
INSERT INTO frasbl_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Si son père refuse catégoriquement de la lui donner, il paiera une somme d'argent correspondant à la dot des vierges. ");
INSERT INTO frasbl_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","« Tu ne permettras pas à une sorcière de vivre. ");
INSERT INTO frasbl_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","« Celui qui aura des rapports sexuels avec un animal sera puni de mort. ");
INSERT INTO frasbl_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","« Celui qui sacrifie à un dieu quelconque, sauf à Yahvé seul, sera anéanti. ");
INSERT INTO frasbl_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","« Tu ne feras pas tort à un étranger et tu ne l'opprimeras pas, car vous étiez des étrangers dans le pays d'Égypte. ");
INSERT INTO frasbl_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","« Vous ne profiterez d'aucune veuve ni d'aucun orphelin. ");
INSERT INTO frasbl_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Si tu en profites, et qu'ils crient vers moi, j'entendrai leur cri ; ");
INSERT INTO frasbl_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","ma colère s'enflammera, et je vous tuerai par l'épée ; vos femmes seront veuves, et vos enfants orphelins. ");
INSERT INTO frasbl_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","« Si tu prêtes de l'argent à un pauvre de mon peuple qui est avec toi, tu ne seras pas pour lui un créancier. Tu ne lui demanderas pas d'intérêt. ");
INSERT INTO frasbl_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Si tu prends en gage le vêtement de ton prochain, tu le lui rendras avant le coucher du soleil, ");
INSERT INTO frasbl_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","car c'est sa seule couverture, c'est son vêtement pour sa peau. Dans quoi dormira-t-il ? S'il crie vers moi, j'entendrai, car je suis miséricordieux. ");
INSERT INTO frasbl_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","« Tu ne blasphémeras pas Dieu et tu ne maudiras pas un chef de ton peuple. ");
INSERT INTO frasbl_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","« Tu ne tarderas pas à offrir de ta récolte et de l'écoulement de tes presses. « Vous me donnerez le premier-né de vos fils. ");
INSERT INTO frasbl_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Tu feras de même avec ton bétail et avec tes brebis. Il restera sept jours avec sa mère, puis le huitième jour, vous me le donnerez. ");
INSERT INTO frasbl_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","« Vous serez pour moi des hommes saints, c'est pourquoi vous ne mangerez pas de viande déchirée par les animaux dans les champs. Vous la jetterez aux chiens. ");
INSERT INTO frasbl_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","« Tu ne répandras pas de fausses nouvelles. Ne joins pas ta main au méchant pour être un témoin malveillant. ");
INSERT INTO frasbl_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","« Tu ne suivras pas une foule pour faire le mal. Tu ne témoigneras pas au tribunal pour te ranger du côté d'une multitude afin de pervertir la justice. ");
INSERT INTO frasbl_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Tu ne favoriseras pas un pauvre dans sa cause. ");
INSERT INTO frasbl_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","« Si tu rencontres le bœuf de ton ennemi ou son âne qui s'égare, tu le ramèneras à lui. ");
INSERT INTO frasbl_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Si tu vois l'âne de celui qui te hait tomber sous son fardeau, ne le laisse pas. Tu l'aideras à le porter. ");
INSERT INTO frasbl_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","« Tu ne refuseras pas la justice à tes pauvres gens dans leurs procès. ");
INSERT INTO frasbl_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","« Éloigne-toi d'une fausse accusation, et ne tue pas l'innocent et le juste, car je ne justifierai pas les méchants. ");
INSERT INTO frasbl_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","« Tu ne prendras pas de pot-de-vin, car le pot-de-vin aveugle les voyants et pervertit les paroles des justes. ");
INSERT INTO frasbl_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","« Tu n'opprimeras pas l'étranger, car tu connais le cœur de l'étranger, puisque vous étiez étrangers au pays d'Égypte. ");
INSERT INTO frasbl_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","« Pendant six ans, tu ensemenceras ta terre et tu en recueilleras le produit, ");
INSERT INTO frasbl_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","mais la septième année, tu la laisseras en repos et en jachère, afin que les pauvres de ton peuple puissent manger ; et ce qu'ils laisseront, les animaux des champs le mangeront. De même, tu traiteras ta vigne et ton oliveraie de la même manière. ");
INSERT INTO frasbl_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","« Six jours tu feras ton travail, et le septième jour tu te reposeras, afin que ton bœuf et ton âne se reposent, et que le fils de ton serviteur et l'étranger se rafraîchissent. ");
INSERT INTO frasbl_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","« Prends garde de faire tout ce que je t'ai dit ; n'invoque pas le nom d'autres dieux et ne les fais pas entendre de ta bouche. ");
INSERT INTO frasbl_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","« Vous célébrerez une fête en mon honneur trois fois par an. ");
INSERT INTO frasbl_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Vous observerez la fête des pains sans levain. Pendant sept jours, vous mangerez des pains sans levain, comme je vous l'ai ordonné, au moment fixé dans le mois d'Abib (car c'est pendant ce mois que vous êtes sortis d'Égypte), et personne ne se présentera devant moi à vide. ");
INSERT INTO frasbl_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Et la fête de la moisson, des prémices de vos travaux, que vous avez semés dans les champs ; et la fête de la récolte, à la fin de l'année, quand vous rassemblez vos travaux des champs. ");
INSERT INTO frasbl_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Trois fois par an, tous vos mâles se présenteront devant le Seigneur Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","« Tu n'offriras pas le sang de mon sacrifice avec du pain levé. La graisse de mon festin ne restera pas toute la nuit jusqu'au matin. ");
INSERT INTO frasbl_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Tu apporteras les premiers fruits de ton sol dans la maison de l'Éternel, ton Dieu. « Tu ne feras pas bouillir un chevreau dans le lait de sa mère. ");
INSERT INTO frasbl_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","« Voici, j'envoie un ange devant toi, pour te garder en chemin et te faire entrer dans le lieu que j'ai préparé. ");
INSERT INTO frasbl_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Prends garde à lui, et écoute sa voix. Ne le provoque pas, car il ne pardonnera pas ta désobéissance, car mon nom est en lui. ");
INSERT INTO frasbl_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Mais si vous écoutez vraiment sa voix, et si vous faites tout ce que je dis, alors je serai l'ennemi de vos ennemis, et l'adversaire de vos adversaires. ");
INSERT INTO frasbl_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Car mon ange marchera devant toi, et te conduira vers l'Amoréen, le Héthien, le Phérézien, le Cananéen, le Hévien et le Jébusien, et je les exterminerai. ");
INSERT INTO frasbl_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Tu ne te prosterneras pas devant leurs dieux, tu ne les serviras pas et tu ne suivras pas leurs pratiques, mais tu les écraseras et tu détruiras leurs piliers. ");
INSERT INTO frasbl_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Tu serviras Yahvé ton Dieu, il bénira ton pain et ton eau, et j'éloignerai la maladie du milieu de toi. ");
INSERT INTO frasbl_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Personne ne fera de fausse couche ni ne sera stérile dans votre pays. J'accomplirai le nombre de vos jours. ");
INSERT INTO frasbl_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","J'enverrai ma terreur devant toi, je confondrai tous les peuples que tu rencontreras, et je ferai en sorte que tous tes ennemis te tournent le dos. ");
INSERT INTO frasbl_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","J'enverrai devant toi le frelon qui chassera devant toi l'Hivvite, le Cananéen et le Héthien. ");
INSERT INTO frasbl_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Je ne les chasserai pas devant toi en une seule année, de peur que le pays ne devienne désert et que les animaux des champs ne se multiplient contre toi. ");
INSERT INTO frasbl_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Je les chasserai peu à peu de devant toi, jusqu'à ce que tu aies augmenté et que tu aies hérité du pays. ");
INSERT INTO frasbl_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Je fixerai tes limites depuis la mer Rouge jusqu'à la mer des Philistins, et depuis le désert jusqu'au fleuve ; car je livrerai entre tes mains les habitants du pays, et tu les chasseras devant toi. ");
INSERT INTO frasbl_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Tu ne feras aucune alliance avec eux, ni avec leurs dieux. ");
INSERT INTO frasbl_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Ils n'habiteront pas dans ton pays, de peur qu'ils ne te fassent pécher contre moi, car si tu sers leurs dieux, ce sera un piège pour toi. » ");
INSERT INTO frasbl_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Il dit à Moïse : « Monte vers Yahvé, toi, Aaron, Nadab et Abihu, et soixante-dix des anciens d'Israël ; et tu te prosterneras à distance. ");
INSERT INTO frasbl_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Moïse seul s'approchera de Yahvé, mais eux ne s'approcheront pas. Le peuple ne montera pas avec lui. » ");
INSERT INTO frasbl_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Moïse vint raconter au peuple toutes les paroles de Yahvé et toutes les ordonnances ; et tout le peuple répondit d'une seule voix : « Nous ferons tout ce que Yahvé a dit. » ");
INSERT INTO frasbl_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Moïse écrivit toutes les paroles de Yahvé, puis il se leva de bon matin et construisit un autel au pied de la montagne, avec douze piliers pour les douze tribus d'Israël. ");
INSERT INTO frasbl_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Il envoya des jeunes gens parmi les enfants d'Israël, qui offrirent des holocaustes et sacrifièrent des animaux en sacrifice de prospérité à Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Moïse prit la moitié du sang et la mit dans des bassins, et il aspergea l'autel avec la moitié du sang. ");
INSERT INTO frasbl_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Il prit le livre de l'alliance et le lut à l'oreille du peuple, qui dit : « Nous ferons tout ce que l'Éternel a dit, et nous obéirons. » ");
INSERT INTO frasbl_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Moïse prit le sang, en fit l'aspersion sur le peuple et dit : « Regardez, c'est le sang de l'alliance que Yahvé a conclue avec vous au sujet de toutes ces paroles. » ");
INSERT INTO frasbl_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Alors montèrent Moïse, Aaron, Nadab, Abihu et soixante-dix des anciens d'Israël. ");
INSERT INTO frasbl_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Ils virent le Dieu d'Israël. Sous ses pieds, il y avait comme un ouvrage pavé de pierre de saphir, comme les cieux pour la clarté. ");
INSERT INTO frasbl_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Il ne mit pas la main sur les nobles des enfants d'Israël. Ils voyaient Dieu, et ils mangeaient et buvaient. ");
INSERT INTO frasbl_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Yahvé dit à Moïse : « Monte vers moi sur la montagne et reste là ; je te donnerai les tables de pierre contenant la loi et les commandements que j'ai écrits, afin que tu les enseignes. » ");
INSERT INTO frasbl_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Moïse se leva avec Josué, son serviteur, et Moïse monta sur la montagne de Dieu. ");
INSERT INTO frasbl_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Il dit aux anciens : « Attendez-nous ici, jusqu'à ce que nous revenions vers vous. Voici qu'Aaron et Hur sont avec vous. Quiconque a un différend peut s'adresser à eux. » ");
INSERT INTO frasbl_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Moïse monta sur la montagne, et la nuée couvrit la montagne. ");
INSERT INTO frasbl_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","La gloire de Yahvé se posa sur la montagne du Sinaï, et la nuée la couvrit pendant six jours. Le septième jour, il appela Moïse du milieu de la nuée. ");
INSERT INTO frasbl_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","L'aspect de la gloire de Yahvé était comme un feu dévorant au sommet de la montagne, aux yeux des enfants d'Israël. ");
INSERT INTO frasbl_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Moïse entra au milieu de la nuée et monta sur la montagne ; et Moïse resta sur la montagne quarante jours et quarante nuits. ");
INSERT INTO frasbl_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Yahvé parla à Moïse, et dit : ");
INSERT INTO frasbl_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","« Parle aux enfants d'Israël, afin qu'ils prennent une offrande pour moi. Vous prélèverez mon offrande sur tous ceux dont le cœur est disposé à le faire. ");
INSERT INTO frasbl_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Voici l'offrande que tu prendras d'eux : de l'or, de l'argent, du bronze, ");
INSERT INTO frasbl_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","de l'azur, de la pourpre, de l'écarlate, du lin fin, du poil de chèvre, ");
INSERT INTO frasbl_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","des peaux de béliers teintes en rouge, des peaux de vaches de mer, du bois d'acacia, ");
INSERT INTO frasbl_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","de l'huile pour le chandelier, des aromates pour l'huile d'onction et pour le parfum odoriférant, ");
INSERT INTO frasbl_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","des pierres d'onyx et des pierres à enchâsser pour l'éphod et pour le pectoral. ");
INSERT INTO frasbl_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Qu'ils me fassent un sanctuaire, et que j'habite au milieu d'eux. ");
INSERT INTO frasbl_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Tu feras le tabernacle et tous ses ustensiles selon le modèle que je te montre. ");
INSERT INTO frasbl_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","« Ils feront une arche en bois d'acacia. Sa longueur sera de deux coudées et demie, sa largeur d'une coudée et demie, et sa hauteur d'une coudée et demie. ");
INSERT INTO frasbl_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Tu la couvriras d'or pur. Tu le recouvriras à l'intérieur et à l'extérieur, et tu feras une moulure en or autour de lui. ");
INSERT INTO frasbl_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Tu fondras pour elle quatre anneaux d'or et tu les placeras à ses quatre pieds. Il y aura deux anneaux d'un côté et deux anneaux de l'autre. ");
INSERT INTO frasbl_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Tu feras des perches de bois d'acacia, et tu les couvriras d'or. ");
INSERT INTO frasbl_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Tu mettras les perches dans les anneaux situés sur les côtés de l'arche, pour porter l'arche. ");
INSERT INTO frasbl_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Les perches resteront dans les anneaux de l'arche. On ne les enlèvera pas. ");
INSERT INTO frasbl_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Tu mettras dans l'arche l'alliance que je te donnerai. ");
INSERT INTO frasbl_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Tu feras un propitiatoire d'or pur. Sa longueur sera de deux coudées et demie, et sa largeur d'une coudée et demie. ");
INSERT INTO frasbl_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Tu feras deux chérubins en or martelé. Tu les feras aux deux extrémités du propitiatoire. ");
INSERT INTO frasbl_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Tu feras un chérubin à l'une des extrémités, et un chérubin à l'autre extrémité. Tu feras les chérubins à ses deux extrémités d'une seule pièce avec le propitiatoire. ");
INSERT INTO frasbl_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Les chérubins déploieront leurs ailes vers le haut et couvriront le propitiatoire de leurs ailes, leurs faces étant tournées l'une vers l'autre. Les faces des chérubins seront tournées vers le propitiatoire. ");
INSERT INTO frasbl_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Tu placeras le propitiatoire au sommet de l'arche, et dans l'arche tu mettras l'alliance que je te donnerai. ");
INSERT INTO frasbl_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","C'est là que je te rencontrerai et que je te dirai, de dessus le propitiatoire, entre les deux chérubins qui sont sur l'arche de l'alliance, tout ce que je te commanderai pour les enfants d'Israël. ");
INSERT INTO frasbl_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","« Tu feras une table en bois d'acacia. Sa longueur sera de deux coudées, sa largeur d'une coudée, et sa hauteur d'une coudée et demie. ");
INSERT INTO frasbl_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Tu la couvriras d'or pur, et tu feras une moulure en or autour d'elle. ");
INSERT INTO frasbl_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Tu feras autour d'elle un rebord de la largeur d'une main. Tu feras une moulure en or sur son pourtour. ");
INSERT INTO frasbl_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Tu feras pour lui quatre anneaux d'or, et tu mettras les anneaux aux quatre coins qui sont à ses quatre pieds. ");
INSERT INTO frasbl_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Les anneaux seront près du rebord, pour servir d'emplacement aux barres qui porteront la table. ");
INSERT INTO frasbl_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Tu feras les barres de bois d'acacia, et tu les couvriras d'or, afin qu'elles servent à porter la table. ");
INSERT INTO frasbl_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Tu feras ses plats, ses cuillères, ses louches et ses coupes pour verser les offrandes. Tu les feras d'or pur. ");
INSERT INTO frasbl_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Tu mettras sur la table, devant moi, en permanence, le pain de la présence. ");
INSERT INTO frasbl_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","« Tu feras un pied de lampe en or pur. Le chandelier sera fait d'un travail de martelage. Sa base, sa tige, ses coupes, ses boutons et ses fleurs seront d'une seule pièce avec lui. ");
INSERT INTO frasbl_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Il y aura six branches qui sortiront de ses côtés : trois branches sortiront d'un côté du candélabre, et trois branches sortiront de l'autre côté du candélabre ; ");
INSERT INTO frasbl_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","trois coupes faites comme des fleurs d'amandier dans une branche, un bouton et une fleur ; et trois coupes faites comme des fleurs d'amandier dans l'autre branche, un bouton et une fleur, ainsi pour les six branches sortant du candélabre ; ");
INSERT INTO frasbl_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","et dans le chandelier quatre coupes faites comme des fleurs d'amandier, ses bourgeons et ses fleurs ; ");
INSERT INTO frasbl_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","et un bourgeon sous deux branches d'une pièce avec elle, et un bourgeon sous deux branches d'une pièce avec elle, et un bourgeon sous deux branches d'une pièce avec elle, pour les six branches sortant du chandelier. ");
INSERT INTO frasbl_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Leurs bourgeons et leurs branches seront d'une seule pièce avec lui, le tout étant un ouvrage battu d'or pur. ");
INSERT INTO frasbl_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Tu feras ses lampes au nombre de sept, et elles allumeront ses lampes pour éclairer l'espace devant lui. ");
INSERT INTO frasbl_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Ses éteignoirs et ses tabatières seront d'or pur. ");
INSERT INTO frasbl_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Il sera fait d'un talent d'or pur, avec tous ces accessoires. ");
INSERT INTO frasbl_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Tu les feras selon le modèle qui t'a été montré sur la montagne. ");
INSERT INTO frasbl_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","« Tu feras le tabernacle avec dix rideaux de fin lin retors, bleu, pourpre et cramoisi, avec des chérubins. Tu les feras avec l'habileté d'un ouvrier. ");
INSERT INTO frasbl_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","La longueur de chaque tapis sera de vingt-huit coudées, et la largeur de chaque tapis sera de quatre coudées ; tous les tapis auront la même mesure. ");
INSERT INTO frasbl_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Cinq rideaux seront accouplés l'un à l'autre, et les cinq autres rideaux seront accouplés l'un à l'autre. ");
INSERT INTO frasbl_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Tu feras des boucles bleues sur le bord de l'un des tapis, à partir du bord de l'assemblage, et tu feras de même sur le bord du tapis le plus extérieur dans le second assemblage. ");
INSERT INTO frasbl_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Tu feras cinquante boucles sur le premier rideau, et tu feras cinquante boucles sur le bord du rideau qui se trouve dans le second assemblage. Les boucles seront opposées l'une à l'autre. ");
INSERT INTO frasbl_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Tu feras cinquante agrafes d'or, et tu attacheras les tapis l'un à l'autre avec les agrafes. Le tabernacle formera une unité. ");
INSERT INTO frasbl_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","« Tu feras des tapis de poils de chèvre pour couvrir le tabernacle. Tu feras onze tapis. ");
INSERT INTO frasbl_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","La longueur de chaque tapis sera de trente coudées, et la largeur de chaque tapis sera de quatre coudées ; les onze tapis auront une seule mesure. ");
INSERT INTO frasbl_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Tu coupleras cinq tapis à part, et six tapis à part, et tu doubleras le sixième tapis sur le devant de la tente. ");
INSERT INTO frasbl_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Tu feras cinquante boucles sur le bord du rideau le plus extérieur de l'assemblage, et cinquante boucles sur le bord du rideau le plus extérieur du second assemblage. ");
INSERT INTO frasbl_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Tu feras cinquante agrafes d'airain, tu mettras les agrafes dans les boucles, et tu assembleras le tabernacle pour qu'il ne fasse qu'un. ");
INSERT INTO frasbl_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Le reste des rideaux de la tente, le demi-rideau qui reste, sera suspendu à l'arrière du tabernacle. ");
INSERT INTO frasbl_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","La coudée d'un côté et la coudée de l'autre côté, de ce qui reste de la longueur des tapis de la tente, seront suspendues sur les côtés du tabernacle, de ce côté-ci et de ce côté-là, pour le couvrir. ");
INSERT INTO frasbl_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Tu feras une couverture pour le tabernacle, en peaux de béliers teintes en rouge, et une couverture en peaux de vaches de mer par-dessus. ");
INSERT INTO frasbl_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","« Tu feras les planches du tabernacle en bois d'acacia, debout. ");
INSERT INTO frasbl_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","La longueur d'une planche sera de dix coudées, et la largeur de chaque planche sera d'une coudée et demie. ");
INSERT INTO frasbl_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Il y aura dans chaque planche deux tenons, joints l'un à l'autre : c'est ainsi que tu feras toutes les planches du tabernacle. ");
INSERT INTO frasbl_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Tu feras vingt planches pour le tabernacle, pour le côté sud, vers le sud. ");
INSERT INTO frasbl_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Tu feras quarante socles d'argent sous les vingt planches : deux socles sous une planche pour ses deux tenons, et deux socles sous une autre planche pour ses deux tenons. ");
INSERT INTO frasbl_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Pour le second côté du tabernacle, au nord, il y aura vingt planches, ");
INSERT INTO frasbl_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","et leurs quarante socles d'argent : deux socles sous une planche, et deux socles sous une autre planche. ");
INSERT INTO frasbl_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Pour l'autre côté du tabernacle, à l'ouest, tu feras six planches. ");
INSERT INTO frasbl_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Tu feras deux planches pour les angles du tabernacle, à l'extrémité. ");
INSERT INTO frasbl_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Elles seront doubles en dessous, et de même, elles seront entières jusqu'au sommet, jusqu'à un seul anneau ; il en sera ainsi pour les deux : ce seront les deux coins. ");
INSERT INTO frasbl_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Il y aura huit planches, et leurs socles d'argent, seize socles, deux socles sous une planche, et deux socles sous une autre planche. ");
INSERT INTO frasbl_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","« Tu feras des barres de bois d'acacia : cinq pour les planches de l'un des côtés de la Demeure, ");
INSERT INTO frasbl_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","cinq pour les planches de l'autre côté de la Demeure, et cinq pour les planches du côté de la Demeure, pour le côté opposé à l'ouest. ");
INSERT INTO frasbl_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","La barre du milieu, au milieu des planches, passera d'un bout à l'autre. ");
INSERT INTO frasbl_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Tu recouvriras d'or les planches et tu feras des anneaux d'or pour y placer les barres. Tu recouvriras d'or les barres. ");
INSERT INTO frasbl_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Tu dresseras le tabernacle selon la manière dont il t'a été montré sur la montagne. ");
INSERT INTO frasbl_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","« Tu feras un voile de couleur bleue, pourpre et cramoisie, et de fin lin retors, avec des chérubins. Il sera l'œuvre d'un habile ouvrier. ");
INSERT INTO frasbl_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Tu le suspendras à quatre colonnes d'acacia, recouvertes d'or ; leurs crochets seront d'or, sur quatre socles d'argent. ");
INSERT INTO frasbl_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Tu accrocheras le voile sous les agrafes, et tu y feras entrer l'arche de l'alliance en dedans du voile. Le voile séparera pour toi le lieu saint du lieu très saint. ");
INSERT INTO frasbl_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Tu placeras le propitiatoire sur l'arche d'alliance dans le lieu très saint. ");
INSERT INTO frasbl_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Tu placeras la table en dehors du voile et le chandelier en face de la table, du côté du tabernacle, vers le sud. Tu mettras la table du côté du nord. ");
INSERT INTO frasbl_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Tu feras pour l'entrée de la tente un rideau bleu, pourpre et cramoisi, et de fin lin retors, ouvrage du brodeur. ");
INSERT INTO frasbl_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Tu feras pour le rideau cinq colonnes d'acacia, et tu les couvriras d'or. Leurs crochets seront d'or. Tu fondras pour eux cinq socles de bronze. ");
INSERT INTO frasbl_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","« Tu feras l'autel en bois d'acacia, d'une longueur de cinq coudées et d'une largeur de cinq coudées. L'autel sera carré. Sa hauteur sera de trois coudées. ");
INSERT INTO frasbl_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Tu feras ses cornes aux quatre coins. Ses cornes seront d'un seul tenant avec lui. Tu le couvriras de bronze. ");
INSERT INTO frasbl_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Tu feras ses pots pour enlever les cendres, ses pelles, ses bassins, ses crochets à viande et ses poêles à feu. Tu feras tous ses récipients en bronze. ");
INSERT INTO frasbl_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Tu feras pour lui une grille en réseau de bronze. Sur le réseau, tu feras quatre anneaux de bronze à ses quatre coins. ");
INSERT INTO frasbl_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Tu le placeras sous le rebord qui entoure l'autel en dessous, de sorte que le filet atteigne la moitié de l'autel. ");
INSERT INTO frasbl_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Tu feras des poteaux pour l'autel, des poteaux en bois d'acacia, et tu les recouvriras de bronze. ");
INSERT INTO frasbl_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Ses poteaux seront placés dans les anneaux, et les poteaux seront sur les deux côtés de l'autel quand on le portera. ");
INSERT INTO frasbl_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Tu le creuseras avec des planches. On le fera comme on te l'a montré sur la montagne. ");
INSERT INTO frasbl_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","« Tu feras le parvis de la Demeure : pour le côté sud, il y aura pour le parvis des tentures de fin lin retors, longues de cent coudées par côté. ");
INSERT INTO frasbl_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Ses piliers seront au nombre de vingt, et leurs socles au nombre de vingt, en bronze. Les crochets des colonnes et leurs filets seront d'argent. ");
INSERT INTO frasbl_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Pour la longueur du côté septentrional, il y aura des tentures de cent coudées de longueur ; ses vingt colonnes et leurs vingt bases seront en bronze ; les crochets des colonnes et leurs tringles seront en argent. ");
INSERT INTO frasbl_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Pour la largeur du parvis du côté de l'occident, il y aura des tentures de cinquante coudées, dix colonnes et dix bases. ");
INSERT INTO frasbl_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","La largeur du parvis du côté de l'orient, à l'est, sera de cinquante coudées. ");
INSERT INTO frasbl_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Les tentures de l'un des côtés de la porte seront de quinze coudées ; leurs piliers seront au nombre de trois, et leurs socles au nombre de trois. ");
INSERT INTO frasbl_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Pour l'autre côté, il y aura des tentures de quinze coudées, avec trois colonnes et trois bases. ");
INSERT INTO frasbl_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Pour la porte du parvis, il y aura un rideau de vingt coudées, en bleu, en pourpre, en cramoisi et en fin lin retors, ouvrage du brodeur, avec quatre colonnes et quatre bases. ");
INSERT INTO frasbl_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Tous les piliers du parvis tout autour seront garnis de filets d'argent, leurs crochets d'argent et leurs bases de bronze. ");
INSERT INTO frasbl_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","La longueur du parvis sera de cent coudées, la largeur de cinquante coudées, et la hauteur de cinq coudées ; les toiles seront de fin lin retors, et leurs bases d'airain. ");
INSERT INTO frasbl_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Tous les instruments du tabernacle, pour tout son service, tous ses piquets et tous les piquets du parvis, seront d'airain. ");
INSERT INTO frasbl_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","« Tu donneras l'ordre aux enfants d'Israël de t'apporter de l'huile d'olive pure, battue pour le feu, pour faire brûler une lampe en permanence. ");
INSERT INTO frasbl_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Dans la tente d'assignation, en dehors du voile qui est devant l'alliance, Aaron et ses fils la tiendront en ordre, du soir au matin, devant l'Éternel ; ce sera une loi perpétuelle, de génération en génération, au nom des enfants d'Israël. ");
INSERT INTO frasbl_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","« Fais venir auprès de toi Aaron, ton frère, et ses fils avec lui, du milieu des enfants d'Israël, afin qu'il soit à mon service dans le sacerdoce : Aaron, avec Nadab, Abihu, Éléazar et Ithamar, fils d'Aaron. ");
INSERT INTO frasbl_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Tu feras à Aaron, ton frère, des vêtements sacrés, pour sa gloire et sa beauté. ");
INSERT INTO frasbl_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Tu parleras à tous ceux qui ont le cœur sage, que j'ai remplis de l'esprit de sagesse, pour qu'ils fassent les vêtements d'Aaron afin de le sanctifier, pour qu'il soit à mon service dans le sacerdoce. ");
INSERT INTO frasbl_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Voici les vêtements qu'ils feront : un pectoral, un éphod, une robe, une tunique ajustée, un turban et une ceinture. Ils feront des vêtements sacrés pour Aaron, ton frère, et pour ses fils, afin qu'ils soient à mon service dans le sacerdoce. ");
INSERT INTO frasbl_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Ils utiliseront l'or, le bleu, le pourpre, l'écarlate et le lin fin. ");
INSERT INTO frasbl_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","« On fera l'éphod d'or, de bleu, de pourpre, d'écarlate et de fin lin retors, ouvrage d'un habile ouvrier. ");
INSERT INTO frasbl_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Il aura deux bretelles attachées à ses deux extrémités, afin qu'on puisse le joindre. ");
INSERT INTO frasbl_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","La ceinture qui l'entourera sera semblable à son ouvrage et de la même pièce, en or, en bleu, en pourpre, en cramoisi et en fin lin retors. ");
INSERT INTO frasbl_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Tu prendras deux pierres d'onyx, et tu graveras sur elles les noms des enfants d'Israël. ");
INSERT INTO frasbl_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Six de leurs noms sur l'une des pierres, et les noms des six autres sur l'autre pierre, dans l'ordre de leur naissance. ");
INSERT INTO frasbl_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Avec le travail d'un graveur sur pierre, comme les gravures d'un sceau, tu graveras les deux pierres, selon les noms des enfants d'Israël. Tu les feras enfermer dans des montures d'or. ");
INSERT INTO frasbl_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Tu mettras les deux pierres sur les bretelles de l'éphod, comme pierres de souvenir pour les enfants d'Israël. Aaron portera leurs noms devant Yahvé sur ses deux épaules, en souvenir. ");
INSERT INTO frasbl_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Tu feras des montures d'or, ");
INSERT INTO frasbl_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","et deux chaînettes d'or pur ; tu les feras comme des cordons tressés. Tu mettras les chaînettes tressées sur les montures. ");
INSERT INTO frasbl_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","« Tu feras un pectoral de jugement, ouvrage d'un habile ouvrier ; tu le feras comme l'ouvrage de l'éphod ; tu le feras d'or, de bleu, de pourpre, d'écarlate, et de fin lin retors. ");
INSERT INTO frasbl_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Il sera carré et plié en deux ; sa longueur sera d'un empan, et sa largeur d'un empan. ");
INSERT INTO frasbl_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Tu y sertiras des pierres, quatre rangées de pierres : une rangée de rubis, de topaze et de béryl pour la première rangée ; ");
INSERT INTO frasbl_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","une deuxième rangée de turquoise, de saphir et d'émeraude ; ");
INSERT INTO frasbl_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","une troisième rangée de jacinthe, d'agate et d'améthyste ; ");
INSERT INTO frasbl_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","une quatrième rangée de chrysolithe, d'onyx et de jaspe. Ils seront entourés d'or dans leurs montures. ");
INSERT INTO frasbl_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Les pierres seront selon les noms des enfants d'Israël, douze, selon leurs noms ; comme les gravures d'un cachet, chacun selon son nom, elles seront pour les douze tribus. ");
INSERT INTO frasbl_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Tu feras sur le pectoral des chaînettes semblables à des cordons, tressées d'or pur. ");
INSERT INTO frasbl_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Tu feras sur le pectoral deux anneaux d'or, et tu mettras les deux anneaux aux deux extrémités du pectoral. ");
INSERT INTO frasbl_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Tu mettras les deux chaînes d'or tressées dans les deux anneaux, aux extrémités du pectoral. ");
INSERT INTO frasbl_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Tu mettras les deux autres extrémités des deux chaînettes tressées sur les deux montures, et tu les mettras sur les bretelles de l'éphod dans sa partie antérieure. ");
INSERT INTO frasbl_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Tu feras deux anneaux d'or, et tu les mettras aux deux extrémités du pectoral, sur son bord, qui est du côté de l'éphod, vers l'intérieur. ");
INSERT INTO frasbl_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Tu feras deux anneaux d'or, et tu les mettras sur les deux bretelles de l'éphod, en dessous, dans sa partie antérieure, près de son attache, au-dessus de la bande habilement tissée de l'éphod. ");
INSERT INTO frasbl_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","On attachera le pectoral par ses anneaux aux anneaux de l'éphod, avec un lacet bleu, pour qu'il soit sur la ceinture de l'éphod et que le pectoral ne se détache pas de l'éphod. ");
INSERT INTO frasbl_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Aaron portera sur son cœur les noms des enfants d'Israël dans le pectoral du jugement, lorsqu'il entrera dans le sanctuaire, en souvenir permanent devant l'Éternel. ");
INSERT INTO frasbl_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Tu mettras dans le pectoral du jugement l'urim et le thummim, et ils seront sur le cœur d'Aaron, lorsqu'il entrera devant l'Éternel. Aaron portera sur son cœur le jugement des enfants d'Israël, devant Yahvé, en permanence. ");
INSERT INTO frasbl_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","« Tu feras la robe de l'éphod toute bleue. ");
INSERT INTO frasbl_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Elle sera percée en son milieu d'un trou pour la tête. Il sera entouré d'une bordure tissée, comme le trou d'une cotte de mailles, afin qu'il ne se déchire pas. ");
INSERT INTO frasbl_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Sur son ourlet, tu feras des grenades bleues, pourpres et écarlates, tout autour de l'ourlet, avec des clochettes d'or entre elles et autour d'elles : ");
INSERT INTO frasbl_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","une clochette d'or et une grenade, une clochette d'or et une grenade, autour du bord de la robe. ");
INSERT INTO frasbl_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Elle sera sur Aaron pour le service ; on en entendra le son quand il entrera dans le sanctuaire devant l'Éternel et quand il en sortira, afin qu'il ne meure pas. ");
INSERT INTO frasbl_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Tu feras une plaque d'or pur, et tu graveras dessus, comme on grave un cachet : « Sainteté à Yahvé ». ");
INSERT INTO frasbl_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Tu la mettras sur un lacet bleu, et elle sera sur la ceinture. Elle sera sur le devant de la ceinture. ");
INSERT INTO frasbl_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Elle sera sur le front d'Aaron ; Aaron portera l'iniquité des choses saintes que les enfants d'Israël sanctifieront dans tous leurs dons sacrés ; elle sera toujours sur son front, afin qu'ils soient agréés devant l'Éternel. ");
INSERT INTO frasbl_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Tu tisseras la tunique avec du lin fin. Tu feras un turban de fin lin. Tu feras une ceinture, ouvrage du brodeur. ");
INSERT INTO frasbl_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","« Tu feras des tuniques pour les fils d'Aaron. Tu leur feras des ceintures. Tu leur feras des bandeaux, pour leur gloire et leur beauté. ");
INSERT INTO frasbl_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Tu les mettras sur Aaron, ton frère, et sur ses fils avec lui ; tu les oindras, tu les consacreras et tu les sanctifieras, afin qu'ils puissent exercer mon ministère dans le cadre du sacerdoce. ");
INSERT INTO frasbl_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Tu leur feras un pantalon de lin pour couvrir leur chair nue. Il ira de la taille jusqu'aux cuisses. ");
INSERT INTO frasbl_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Ils seront sur Aaron et sur ses fils, lorsqu'ils entreront dans la tente de la Rencontre ou lorsqu'ils s'approcheront de l'autel pour faire le service dans le lieu saint, afin qu'ils ne portent pas l'iniquité et ne meurent pas. Ce sera une loi pour lui et pour sa descendance après lui, pour toujours. ");
INSERT INTO frasbl_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","« Voici ce que tu leur feras pour les sanctifier, afin qu'ils soient à mon service dans le sacerdoce : prends un jeune taureau et deux béliers sans défaut, ");
INSERT INTO frasbl_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","des pains sans levain, des gâteaux sans levain mélangés à de l'huile et des galettes sans levain ointes d'huile. Tu les feras avec de la fine farine de froment. ");
INSERT INTO frasbl_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Tu les mettras dans un panier, et tu les apporteras dans le panier, avec le taureau et les deux béliers. ");
INSERT INTO frasbl_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Tu feras venir Aaron et ses fils à l'entrée de la tente de la Rencontre, et tu les laveras avec de l'eau. ");
INSERT INTO frasbl_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Tu prendras les vêtements et tu revêtiras Aaron de la tunique, de la robe de l'éphod, de l'éphod et du pectoral, et tu le revêtiras de la bande de l'éphod habilement tissée. ");
INSERT INTO frasbl_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Tu placeras le turban sur sa tête, et tu mettras la couronne sacrée sur le turban. ");
INSERT INTO frasbl_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Tu prendras ensuite l'huile d'onction, tu la verseras sur sa tête et tu l'oindras. ");
INSERT INTO frasbl_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Tu feras venir ses fils, et tu les revêtiras de tuniques. ");
INSERT INTO frasbl_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Tu les revêtiras de ceintures, Aaron et ses fils, et tu leur attacheras des bandeaux. Ils auront le sacerdoce par un statut perpétuel. Tu consacreras Aaron et ses fils. ");
INSERT INTO frasbl_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","« Tu amèneras le taureau devant la tente de la Rencontre ; Aaron et ses fils poseront leurs mains sur la tête du taureau. ");
INSERT INTO frasbl_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Tu égorgeras le taureau devant Yahvé, à l'entrée de la tente de la Rencontre. ");
INSERT INTO frasbl_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Tu prendras du sang du taureau, tu en mettras sur les cornes de l'autel avec ton doigt, et tu verseras tout le sang au pied de l'autel. ");
INSERT INTO frasbl_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Tu prendras toute la graisse qui recouvre les entrailles, la couverture du foie, les deux rognons et la graisse qui les recouvre, et tu les brûleras sur l'autel. ");
INSERT INTO frasbl_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Mais la viande du taureau, sa peau et ses excréments, tu les brûleras au feu en dehors du camp. C'est un sacrifice pour le péché. ");
INSERT INTO frasbl_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","« Tu prendras aussi un bélier, et Aaron et ses fils poseront leurs mains sur la tête du bélier. ");
INSERT INTO frasbl_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Tu égorgeras le bélier, tu prendras son sang, et tu en feras l'aspersion autour de l'autel. ");
INSERT INTO frasbl_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Tu couperas le bélier en morceaux, tu laveras ses entrailles et ses jambes, et tu les mettras avec ses morceaux et avec sa tête. ");
INSERT INTO frasbl_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Tu brûleras le bélier tout entier sur l'autel : c'est un holocauste à l'Éternel ; c'est une odeur agréable, un sacrifice par le feu à l'Éternel. ");
INSERT INTO frasbl_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","« Tu prendras l'autre bélier, et Aaron et ses fils poseront leurs mains sur la tête du bélier. ");
INSERT INTO frasbl_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Tu égorgeras le bélier, tu prendras de son sang, tu en mettras sur le lobe de l'oreille droite d'Aaron et sur le lobe de l'oreille droite de ses fils, sur le pouce de leur main droite et sur le gros orteil de leur pied droit, et tu aspergeras le sang tout autour de l'autel. ");
INSERT INTO frasbl_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Tu prendras du sang qui est sur l'autel et de l'huile d'onction, et tu en feras l'aspersion sur Aaron, sur ses vêtements, sur ses fils et sur les vêtements de ses fils avec lui ; il sera sanctifié, ainsi que ses vêtements, ses fils et les vêtements de ses fils avec lui. ");
INSERT INTO frasbl_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Tu prendras aussi de la graisse du bélier, la queue, la graisse qui recouvre les entrailles, la couverture du foie, les deux rognons, la graisse qui les recouvre, et la cuisse droite (car c'est un bélier de consécration), ");
INSERT INTO frasbl_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","et un pain, un gâteau de pain huilé et une galette de la corbeille de pains sans levain qui est devant l'Éternel. ");
INSERT INTO frasbl_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Tu mettras tout cela dans les mains d'Aaron et dans les mains de ses fils, et tu les agiteras en offrande par élévation devant l'Éternel. ");
INSERT INTO frasbl_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Tu les prendras de leurs mains et tu les brûleras sur l'autel, sur l'holocauste, comme une odeur agréable devant l'Éternel : c'est une offrande faite par feu à l'Éternel. ");
INSERT INTO frasbl_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","« Tu prendras la poitrine du bélier de consécration d'Aaron et tu l'agiteras en signe d'offrande devant Yahvé. Ce sera ta part. ");
INSERT INTO frasbl_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Tu sanctifieras la poitrine de l'offrande par agitation et la cuisse de l'offrande par agitation, qu'on agitera et qu'on élèvera, du bélier de consécration, de celle qui est pour Aaron et de celle qui est pour ses fils. ");
INSERT INTO frasbl_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Ce sera pour Aaron et ses fils, comme leur part à perpétuité parmi les enfants d'Israël, car c'est une offrande par ondulation. C'est une offrande ondulée des enfants d'Israël, parmi les sacrifices de leurs sacrifices de communion, leur offrande ondulée à Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","« Les vêtements sacrés d'Aaron seront destinés à ses fils après lui, pour qu'ils y soient oints et qu'ils y soient consacrés. ");
INSERT INTO frasbl_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Le fils qui sera prêtre à sa place les revêtira pendant sept jours, lorsqu'il entrera dans la tente de la Rencontre pour faire le service dans le lieu saint. ");
INSERT INTO frasbl_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","« Tu prendras le bélier de consécration et tu feras bouillir sa viande dans un lieu saint. ");
INSERT INTO frasbl_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Aaron et ses fils mangeront la viande du bélier et le pain qui est dans la corbeille, à l'entrée de la tente d'assignation. ");
INSERT INTO frasbl_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Ils mangeront ces choses avec lesquelles on a fait l'expiation, pour les consacrer et les sanctifier ; mais l'étranger n'en mangera pas, car elles sont saintes. ");
INSERT INTO frasbl_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","S'il reste quelque chose de la viande de la consécration ou du pain jusqu'au matin, vous brûlerez au feu ce qui restera. On n'en mangera pas, car c'est une chose sainte. ");
INSERT INTO frasbl_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","« Tu feras ainsi à Aaron et à ses fils, selon tout ce que je t'ai ordonné. Tu les consacreras pendant sept jours. ");
INSERT INTO frasbl_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Chaque jour, tu offriras le taureau du sacrifice pour le péché en expiation. Tu purifieras l'autel lorsque tu en feras l'expiation. Tu l'oindras, pour le sanctifier. ");
INSERT INTO frasbl_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Pendant sept jours, tu feras des expiations sur l'autel et tu le sanctifieras ; l'autel sera très saint. Tout ce qui touchera l'autel sera saint. ");
INSERT INTO frasbl_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","« Voici ce que tu offriras sur l'autel : deux agneaux d'un an, jour par jour, continuellement. ");
INSERT INTO frasbl_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Tu offriras l`un des agneaux le matin, et l`autre agneau le soir ; ");
INSERT INTO frasbl_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","tu offriras avec l`un des agneaux un dixième d`épha de fleur de farine mélangé à un quart de hin d`huile battue, et un quart de hin de vin, comme libation. ");
INSERT INTO frasbl_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Tu offriras l'autre agneau le soir, et tu lui feras selon l'offrande du matin et selon sa libation, un sacrifice consumé par le feu, d'une agréable odeur à l'Éternel. ");
INSERT INTO frasbl_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Ce sera un holocauste perpétuel, de génération en génération, à l'entrée de la tente d'assignation, devant l'Éternel, là où je me réunirai avec vous pour vous parler. ");
INSERT INTO frasbl_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","C'est là que je rencontrerai les enfants d'Israël, et le lieu sera sanctifié par ma gloire. ");
INSERT INTO frasbl_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Je sanctifierai la tente de la Rencontre et l'autel. Je sanctifierai aussi Aaron et ses fils pour qu'ils soient à mon service dans le sacerdoce. ");
INSERT INTO frasbl_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","J'habiterai au milieu des enfants d'Israël et je serai leur Dieu. ");
INSERT INTO frasbl_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Ils sauront que je suis Yahvé leur Dieu, qui les a fait sortir du pays d'Égypte, pour habiter au milieu d'eux : Je suis Yahvé, leur Dieu. ");
INSERT INTO frasbl_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","« Tu feras un autel pour y brûler des parfums. Tu le feras de bois d'acacia. ");
INSERT INTO frasbl_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Sa longueur sera d'une coudée, et sa largeur d'une coudée. Il sera carré, et sa hauteur sera de deux coudées. Ses cornes seront d'un seul tenant avec lui. ");
INSERT INTO frasbl_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Tu le couvriras d'or pur, son sommet, ses côtés tout autour et ses cornes, et tu feras une moulure d'or autour de lui. ");
INSERT INTO frasbl_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Tu lui feras deux anneaux d'or sous la moulure ; tu les feras sur ses deux côtes, sur ses deux côtés, et ils serviront d'emplacements pour des perches qui serviront à le porter. ");
INSERT INTO frasbl_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Tu feras les barres de bois d'acacia, et tu les couvriras d'or. ");
INSERT INTO frasbl_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Tu le placeras devant le voile qui est près de l'arche de l'alliance, devant le propitiatoire qui est au-dessus de l'alliance, là où je me rencontrerai avec toi. ");
INSERT INTO frasbl_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Aaron y fera brûler chaque matin des parfums d'épices douces. Lorsqu'il s'occupera des lampes, il le brûlera. ");
INSERT INTO frasbl_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Le soir, quand Aaron allumera les lampes, il en fera brûler, comme un parfum perpétuel devant Yahvé, de génération en génération. ");
INSERT INTO frasbl_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Vous n'y offrirez pas de parfum étranger, ni d'holocauste, ni d'offrande, et vous n'y verserez pas de libations. ");
INSERT INTO frasbl_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Aaron fera l'expiation sur ses cornes une fois par an ; avec le sang du sacrifice d'expiation pour le péché, une fois par an, il fera l'expiation pour elle, pendant toutes vos générations. Elle est très sainte pour Yahvé. » ");
INSERT INTO frasbl_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","L'Éternel parla à Moïse, et dit : ");
INSERT INTO frasbl_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","« Quand tu recenseras les enfants d'Israël, selon ceux qui sont comptés parmi eux, chacun donnera une rançon pour son âme à l'Éternel quand tu les compteras, afin qu'il n'y ait pas de plaie parmi eux quand tu les compteras. ");
INSERT INTO frasbl_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Ils donneront ceci, tous ceux qui passeront à ceux qui seront comptés : un demi-sicle, selon le sicle du sanctuaire (le sicle est de vingt géras), un demi-sicle pour une offrande à l'Éternel. ");
INSERT INTO frasbl_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Tous ceux qui passent à ceux qui sont comptés, depuis l'âge de vingt ans et au-dessus, donneront l'offrande à l'Éternel. ");
INSERT INTO frasbl_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Le riche ne donnera pas plus, et le pauvre ne donnera pas moins, qu'un demi-sicle, lorsqu'ils présenteront l'offrande à l'Éternel, pour faire l'expiation de vos âmes. ");
INSERT INTO frasbl_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Tu prendras l'argent de l'expiation des enfants d'Israël et tu le consacreras au service de la Tente d'assignation, afin que ce soit un mémorial pour les enfants d'Israël devant l'Éternel, pour faire l'expiation de vos âmes. » ");
INSERT INTO frasbl_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Yahvé parla à Moïse et dit : ");
INSERT INTO frasbl_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","« Tu feras aussi un bassin d'airain, et sa base d'airain, pour te laver. Tu le placeras entre la tente de la Rencontre et l'autel, et tu y mettras de l'eau. ");
INSERT INTO frasbl_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Aaron et ses fils y laveront leurs mains et leurs pieds. ");
INSERT INTO frasbl_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Lorsqu'ils entreront dans la Tente de la Rencontre, ils se laveront avec de l'eau, afin de ne pas mourir ; ou lorsqu'ils s'approcheront de l'autel pour faire le service, pour brûler une offrande consumée par le feu à l'Éternel. ");
INSERT INTO frasbl_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Ils se laveront les mains et les pieds, afin de ne pas mourir. Ce sera pour eux une loi perpétuelle, pour lui et pour ses descendants, de génération en génération. » ");
INSERT INTO frasbl_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Yahvé parla à Moïse, et dit : ");
INSERT INTO frasbl_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","Prends aussi des aromates fins : de la myrrhe liquide, cinq cents sicles ; de la cannelle odorante, la moitié, soit deux cent cinquante sicles ; du roseau odorant, deux cent cinquante sicles ; ");
INSERT INTO frasbl_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","de la casse, cinq cents sicles, selon le sicle du sanctuaire ; et un hin d'huile d'olive. ");
INSERT INTO frasbl_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Tu en feras une huile d'onction sainte, un parfum composé selon l'art du parfumeur : ce sera une huile d'onction sainte. ");
INSERT INTO frasbl_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Tu l'utiliseras pour oindre la tente d'assignation, l'arche de l'alliance, ");
INSERT INTO frasbl_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","la table et tous ses objets, le chandelier et ses accessoires, l'autel des parfums, ");
INSERT INTO frasbl_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","l'autel des holocaustes avec tous ses ustensiles, et le bassin avec son socle. ");
INSERT INTO frasbl_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Tu les sanctifieras, afin qu'ils soient très saints. Tout ce qui les touchera sera saint. ");
INSERT INTO frasbl_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Tu oindras Aaron et ses fils, et tu les sanctifieras, afin qu'ils soient à mon service dans le sacerdoce. ");
INSERT INTO frasbl_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Tu parleras aux enfants d'Israël en disant : « Ceci sera pour moi une huile d'onction sainte, de génération en génération. ");
INSERT INTO frasbl_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","On ne la versera pas sur la chair de l'homme, et on n'en fera pas de semblable, selon sa composition. Elle est sainte. Elle sera sainte pour vous. ");
INSERT INTO frasbl_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Celui qui en composera une semblable, ou qui en mettra sur un étranger, sera retranché de son peuple.'\" ");
INSERT INTO frasbl_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Yahvé dit à Moïse : « Prends pour toi des épices douces, de la gomme arabique, de l'onycha et du galbanum : des épices douces avec de l'encens pur. Il y aura un poids égal de chaque. ");
INSERT INTO frasbl_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Tu en feras de l'encens, un parfum selon l'art du parfumeur, assaisonné de sel, pur et saint. ");
INSERT INTO frasbl_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Tu en battras une petite quantité et tu en mettras devant l'alliance, dans la tente de la Rencontre, où je me réunirai avec toi. Ce sera pour toi une chose très sainte. ");
INSERT INTO frasbl_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Vous ne ferez pas ce parfum, selon sa composition, pour vous-mêmes : il sera pour vous très saint, pour Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Quiconque en fera un semblable, pour en sentir l'odeur, sera retranché de son peuple. » ");
INSERT INTO frasbl_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Yahvé parla à Moïse, et dit : ");
INSERT INTO frasbl_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","Voici, j`ai appelé par son nom Betsaleel, fils d`Uri, fils de Hur, de la tribu de Juda. ");
INSERT INTO frasbl_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Je l'ai rempli de l'Esprit de Dieu, de sagesse, d'intelligence, de connaissance, et d'habileté dans toutes sortes d'ouvrages, ");
INSERT INTO frasbl_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","pour concevoir des ouvrages habiles, pour travailler l'or, l'argent et le bronze, ");
INSERT INTO frasbl_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","pour tailler des pierres à enchâsser, pour sculpter le bois, pour faire toutes sortes d'ouvrages. ");
INSERT INTO frasbl_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Voici, j'ai moi-même établi avec lui Oholiab, fils d'Ahisamac, de la tribu de Dan ; et j'ai mis de la sagesse dans le cœur de tous ceux qui ont le cœur sage, afin qu'ils fassent tout ce que je t'ai ordonné : ");
INSERT INTO frasbl_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","la tente d'assignation, l'arche de l'alliance, le propitiatoire qui est dessus, tous les meubles de la tente, ");
INSERT INTO frasbl_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","la table et ses ustensiles, le chandelier pur et tous ses ustensiles, l'autel des parfums, ");
INSERT INTO frasbl_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","l'autel des holocaustes et tous ses ustensiles, la cuvette et son socle, ");
INSERT INTO frasbl_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","les vêtements finement travaillés - les vêtements sacrés pour le prêtre Aaron, les vêtements de ses fils pour le service du sacerdoce - ");
INSERT INTO frasbl_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","l'huile d'onction et le parfum d'épices douces pour le lieu saint : Ils feront tout ce que je vous ai ordonné. » ");
INSERT INTO frasbl_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Yahvé parla à Moïse, et dit : ");
INSERT INTO frasbl_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","Parle aux enfants d'Israël, et dis-leur : Vous observerez mes sabbats, car c'est un signe entre moi et vous, de génération en génération, pour que vous sachiez que je suis Yahvé, qui vous sanctifie. ");
INSERT INTO frasbl_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Vous observerez donc le sabbat, car il est saint pour vous. Quiconque le profanera sera puni de mort, car quiconque y fera un travail quelconque sera retranché du milieu de son peuple. ");
INSERT INTO frasbl_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","On travaillera six jours, mais le septième jour est un sabbat de repos solennel, consacré à Yahvé. Quiconque fera un ouvrage quelconque le jour du sabbat sera puni de mort. ");
INSERT INTO frasbl_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","C'est pourquoi les enfants d'Israël garderont le sabbat, pour l'observer de génération en génération, comme une alliance perpétuelle. ");
INSERT INTO frasbl_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","C'est un signe entre moi et les enfants d'Israël, pour l'éternité ; car en six jours, Yahvé a fait les cieux et la terre, et le septième jour, il s'est reposé et s'est rafraîchi.'\" ");
INSERT INTO frasbl_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Lorsqu'il eut fini de parler avec lui sur le mont Sinaï, il donna à Moïse les deux tables de l'alliance, des tables de pierre, écrites du doigt de Dieu. ");
INSERT INTO frasbl_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Lorsque le peuple vit que Moïse tardait à descendre de la montagne, il s'assembla auprès d'Aaron et lui dit : « Viens, fais-nous des dieux qui marchent devant nous ; car ce Moïse, l'homme qui nous a fait monter du pays d'Égypte, nous ne savons pas ce qu'il est devenu. » ");
INSERT INTO frasbl_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Aaron leur dit : « Otez les anneaux d'or qui sont aux oreilles de vos femmes, de vos fils et de vos filles, et apportez-les-moi. » ");
INSERT INTO frasbl_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Tout le peuple enleva les anneaux d'or qui étaient à ses oreilles, et les apporta à Aaron. ");
INSERT INTO frasbl_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Il reçut ce qu'on lui tendait, le façonna avec un outil de gravure et en fit un veau moulé. Puis ils dirent : « Voici tes dieux, Israël, qui t'ont fait monter du pays d'Égypte. » ");
INSERT INTO frasbl_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Aaron vit cela, et il bâtit un autel devant elle. Aaron fit une proclamation, et dit : « Demain sera une fête pour Yahvé. » ");
INSERT INTO frasbl_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Le lendemain, ils se levèrent de bonne heure, offrirent des holocaustes et apportèrent des sacrifices de paix ; le peuple s'assit pour manger et boire, et se leva pour jouer. ");
INSERT INTO frasbl_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Yahvé parla à Moïse : « Va, descends, car ton peuple, que tu as fait monter du pays d'Égypte, s'est corrompu ! ");
INSERT INTO frasbl_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Ils se sont détournés rapidement de la voie que je leur avais prescrite. Ils se sont fait un veau façonné, ils se sont prosternés devant lui, ils lui ont offert des sacrifices, et ils ont dit : « Ce sont tes dieux, Israël, qui t'ont fait monter du pays d'Égypte ». ");
INSERT INTO frasbl_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Yahvé dit à Moïse : « J'ai vu ce peuple, et voici, c'est un peuple à la nuque raide. ");
INSERT INTO frasbl_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Maintenant, laisse-moi tranquille, afin que ma colère s'enflamme contre eux et que je les consume ; et je ferai de toi une grande nation. » ");
INSERT INTO frasbl_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Moïse supplia Yahvé son Dieu et dit : « Yahvé, pourquoi ta colère s'enflamme-t-elle contre ton peuple, que tu as fait sortir du pays d'Égypte avec une grande puissance et une main puissante ? ");
INSERT INTO frasbl_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Pourquoi les Égyptiens diraient-ils : « Il les a fait sortir pour le malheur, pour les tuer dans les montagnes et les faire disparaître de la surface de la terre ? Détourne-toi de ton ardente colère, et détourne-toi de ce mal contre ton peuple. ");
INSERT INTO frasbl_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Souviens-toi d'Abraham, d'Isaac et d'Israël, tes serviteurs, à qui tu as juré par toi-même, et tu leur as dit : « Je multiplierai ta descendance comme les étoiles du ciel, et je donnerai à ta descendance tout ce pays dont j'ai parlé, et ils en hériteront pour toujours ». ");
INSERT INTO frasbl_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Et Yahvé se détourna du mal qu'il avait dit qu'il ferait à son peuple. ");
INSERT INTO frasbl_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Moïse se retourna et descendit de la montagne, ayant à la main les deux tables de l'alliance, tables qui étaient écrites sur leurs deux faces. Elles étaient écrites sur une face et sur l'autre. ");
INSERT INTO frasbl_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Les tables étaient l'œuvre de Dieu, et l'écriture était l'écriture de Dieu, gravée sur les tables. ");
INSERT INTO frasbl_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Lorsque Josué entendit le bruit du peuple qui criait, il dit à Moïse : « Il y a un bruit de guerre dans le camp. » ");
INSERT INTO frasbl_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Il dit : « Ce n'est pas la voix de ceux qui crient victoire. Ce n'est pas la voix de ceux qui crient pour être vaincus, mais le bruit de ceux qui chantent que j'entends. » ");
INSERT INTO frasbl_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Dès qu'il s'approcha du camp, il vit le veau et les danses. La colère de Moïse s'enflamma, il jeta les tables de ses mains et les brisa sous la montagne. ");
INSERT INTO frasbl_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Il prit le veau qu'ils avaient fait, le brûla au feu, le réduisit en poudre, le répandit sur l'eau et le fit boire aux enfants d'Israël. ");
INSERT INTO frasbl_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Moïse dit à Aaron : « Qu'est-ce que ce peuple t'a fait, pour que tu lui aies fait subir un grand péché ? ». ");
INSERT INTO frasbl_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Aaron dit : « Ne laisse pas s'enflammer la colère de mon seigneur. Tu connais le peuple, il est déterminé à faire le mal. ");
INSERT INTO frasbl_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Car ils m'ont dit : Fais-nous des dieux qui marchent devant nous. Quant à ce Moïse, l'homme qui nous a fait monter du pays d'Égypte, nous ne savons pas ce qu'il est devenu ». ");
INSERT INTO frasbl_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Je leur ai dit : « Que celui qui a de l'or le prenne ». Ils me le donnèrent ; je le jetai dans le feu et il en sortit ce veau. » ");
INSERT INTO frasbl_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Lorsque Moïse vit que le peuple était hors de contrôle, (car Aaron l'avait laissé perdre le contrôle, provoquant la risée de ses ennemis), ");
INSERT INTO frasbl_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Moïse se tint à la porte du camp et dit : « Que celui qui est du côté de l'Éternel vienne à moi. » Tous les fils de Lévi se rassemblèrent auprès de lui. ");
INSERT INTO frasbl_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Il leur dit : « Yahvé, le Dieu d'Israël, a dit : « Que chacun mette son épée sur sa cuisse, qu'il aille de porte en porte dans tout le camp, et que chacun tue son frère, son compagnon et son prochain ». ");
INSERT INTO frasbl_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Les fils de Lévi firent selon la parole de Moïse. Environ trois mille hommes tombèrent du peuple ce jour-là. ");
INSERT INTO frasbl_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Moïse dit : « Consacrez-vous aujourd'hui à Yahvé, car chacun a été contre son fils et contre son frère, afin qu'il vous accorde aujourd'hui une bénédiction. » ");
INSERT INTO frasbl_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Le lendemain, Moïse dit au peuple : « Vous avez commis un grand péché. Je vais maintenant monter vers Yahvé. Je ferai peut-être l'expiation de votre péché. » ");
INSERT INTO frasbl_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Moïse retourna auprès de Yahvé et dit : « Oh, ce peuple a commis un grand péché et s'est fait des dieux d'or. ");
INSERT INTO frasbl_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Mais maintenant, si tu veux, pardonne leur péché - et sinon, efface-moi de ton livre que tu as écrit. » ");
INSERT INTO frasbl_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Yahvé dit à Moïse : « Celui qui a péché contre moi, je l'efface de mon livre. ");
INSERT INTO frasbl_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Va maintenant, conduis le peuple au lieu dont je t'ai parlé. Voici, mon ange ira devant toi. Néanmoins, au jour où je punirai, je les punirai pour leur péché. » ");
INSERT INTO frasbl_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Yahvé frappa le peuple, à cause de ce qu'il avait fait avec le veau qu'Aaron avait fabriqué. ");
INSERT INTO frasbl_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Yahvé parla à Moïse : « Pars, monte d'ici, toi et le peuple que tu as fait monter du pays d'Égypte, vers le pays dont j'ai juré à Abraham, à Isaac et à Jacob, en disant : Je le donnerai à ta postérité. ");
INSERT INTO frasbl_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","J'enverrai un ange devant toi, et je chasserai les Cananéens, les Amorites, les Hittites, les Perizzites, les Hivvites et les Jébusites. ");
INSERT INTO frasbl_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Allez dans un pays où coulent le lait et le miel ; mais je ne monterai pas au milieu de vous, car vous êtes un peuple à la nuque raide, de peur que je ne vous consume en chemin. » ");
INSERT INTO frasbl_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Lorsque le peuple entendit cette mauvaise nouvelle, il se mit en deuil ; et personne ne mit ses bijoux. ");
INSERT INTO frasbl_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Yahvé avait dit à Moïse : « Dis aux enfants d'Israël : « Vous êtes un peuple au cou raide. Si je montais un seul instant au milieu de vous, je vous consumerais. C'est pourquoi, maintenant, ôtez de vous vos bijoux, afin que je sache ce que je dois faire de vous ». ");
INSERT INTO frasbl_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Les enfants d'Israël se dépouillèrent de leurs bijoux à partir du mont Horeb. ");
INSERT INTO frasbl_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Moïse avait l'habitude de prendre la tente et de la dresser hors du camp, loin du camp, et il l'appelait « Tente de la Rencontre ». Tous ceux qui cherchaient Yahvé se rendaient à la Tente de la Rencontre, qui était à l'extérieur du camp. ");
INSERT INTO frasbl_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Lorsque Moïse sortit de la Tente, tout le peuple se leva et se tint debout, chacun à l'entrée de sa tente, et il regarda Moïse jusqu'à ce qu'il soit entré dans la Tente. ");
INSERT INTO frasbl_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Lorsque Moïse entra dans la Tente, la colonne de nuée descendit, se tint à l'entrée de la Tente, et Yahvé parla à Moïse. ");
INSERT INTO frasbl_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Tout le peuple vit la colonne de nuée se tenir à l'entrée de la tente, et tout le peuple se leva et se prosterna, chacun à la porte de sa tente. ");
INSERT INTO frasbl_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Yahvé parlait à Moïse face à face, comme un homme parle à son ami. Il se retourna dans le camp, mais son serviteur Josué, fils de Nun, un jeune homme, ne sortit pas de la Tente. ");
INSERT INTO frasbl_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Moïse dit à Yahvé : « Voici, tu me dis : « Fais monter ce peuple », et tu ne m'as pas fait savoir qui tu allais envoyer avec moi. Mais tu as dit : « Je te connais par ton nom, et tu as trouvé grâce à mes yeux ». ");
INSERT INTO frasbl_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Maintenant donc, si j'ai trouvé grâce à tes yeux, montre-moi maintenant ton chemin, afin que je te connaisse, et que je trouve grâce à tes yeux ; et considère que cette nation est ton peuple. » ");
INSERT INTO frasbl_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Il a dit : « Ma présence ira avec vous, et je vous donnerai du repos. » ");
INSERT INTO frasbl_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Moïse lui dit : « Si ta présence ne va pas avec moi, ne nous fais pas monter d'ici. ");
INSERT INTO frasbl_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Car comment saura-t-on que j'ai trouvé grâce à tes yeux, moi et ton peuple ? N'est-ce pas que tu vas avec nous, afin que nous soyons séparés, moi et ton peuple, de tous les gens qui sont à la surface de la terre ? ». ");
INSERT INTO frasbl_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Yahvé dit à Moïse : « Je ferai aussi cette chose que tu as dite, car tu as trouvé grâce à mes yeux et je te connais par ton nom. » ");
INSERT INTO frasbl_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Moïse a dit : « Je t'en prie, montre-moi ta gloire. » ");
INSERT INTO frasbl_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Il dit : « Je ferai passer devant toi toute ma bonté, et je proclamerai devant toi le nom de Yahvé. Je ferai grâce à qui je ferai grâce, et je ferai miséricorde à qui je ferai miséricorde. » ");
INSERT INTO frasbl_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Il dit : « Tu ne peux pas voir ma face, car l'homme ne peut pas me voir et vivre. » ");
INSERT INTO frasbl_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Yahvé dit aussi : « Voici, il y a un lieu près de moi, et tu te tiendras sur le rocher. ");
INSERT INTO frasbl_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Il arrivera, pendant que ma gloire passera, que je te mettrai dans une fente du rocher, et que je te couvrirai de ma main jusqu'à ce que j'aie passé ; ");
INSERT INTO frasbl_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","alors je retirerai ma main, et tu verras mon dos ; mais on ne verra pas mon visage. » ");
INSERT INTO frasbl_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Yahvé dit à Moïse : « Cisèle deux tables de pierre comme les premières. J'écrirai sur ces tablettes les paroles qui étaient sur les premières tablettes, que tu as brisées. ");
INSERT INTO frasbl_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Prépare-toi dès le matin, monte sur le mont Sinaï et présente-toi là devant moi, au sommet de la montagne. ");
INSERT INTO frasbl_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Personne ne montera avec toi et on ne te verra nulle part sur la montagne. Ne laisse pas les troupeaux paître devant cette montagne. » ");
INSERT INTO frasbl_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Il cisela deux tables de pierre comme la première. Moïse se leva de bon matin et monta sur la montagne du Sinaï, comme Yahvé le lui avait ordonné, et il prit dans sa main deux tables de pierre. ");
INSERT INTO frasbl_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Yahvé descendit dans la nuée, se tint là avec lui, et proclama le nom de Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Yahvé passa devant lui, et il proclama : « Yahvé ! Yahvé, Dieu de miséricorde et de bonté, lent à la colère, abondant en bonté et en vérité, ");
INSERT INTO frasbl_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","gardant la bonté pour des milliers de personnes, pardonnant l'iniquité, la désobéissance et le péché, et qui ne pardonne nullement les coupables, visitant l'iniquité des pères sur les enfants, et sur les enfants des enfants, sur la troisième et la quatrième génération. » ");
INSERT INTO frasbl_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Moïse se précipita, inclina sa tête vers la terre et se prosterna. ");
INSERT INTO frasbl_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Il dit : « Si maintenant j'ai trouvé grâce à tes yeux, Seigneur, laisse l'Éternel aller au milieu de nous, même si c'est un peuple à la nuque raide ; pardonne notre iniquité et notre péché, et prends-nous pour ton héritage. » ");
INSERT INTO frasbl_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Il dit : « Voici, je fais une alliance : devant tout ton peuple, je ferai des merveilles, telles qu'il n'en a jamais été fait dans toute la terre ni dans aucune nation ; et tout le peuple au milieu duquel tu es verra l'œuvre de Yahvé, car c'est une chose redoutable que je fais avec toi. ");
INSERT INTO frasbl_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Observez ce que je vous ordonne aujourd'hui. Voici, je vais chasser devant toi l'Amoréen, le Cananéen, le Héthien, le Phérézien, le Hévien et le Jébusien. ");
INSERT INTO frasbl_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Prenez garde que vous ne fassiez une alliance avec les habitants du pays où vous allez, de peur que ce ne soit un piège pour vous ; ");
INSERT INTO frasbl_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","mais vous démolirez leurs autels, vous briserez leurs colonnes et vous abattrez leurs mâts d'Astarté ; ");
INSERT INTO frasbl_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","car vous ne vous prosternerez pas devant un autre dieu, car Yahvé, dont le nom est Jalous, est un Dieu jaloux. ");
INSERT INTO frasbl_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","« Ne fais pas d'alliance avec les habitants du pays, de peur qu'ils ne se prostituent à leurs dieux, qu'ils n'offrent des sacrifices à leurs dieux, que l'un d'eux ne t'appelle et que tu ne manges de son sacrifice ; ");
INSERT INTO frasbl_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","et que tu ne prennes de leurs filles pour tes fils, que leurs filles ne se prostituent à leurs dieux et que tes fils ne se prostituent à leurs dieux ». ");
INSERT INTO frasbl_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","« Vous ne vous ferez pas d'idoles en fonte. ");
INSERT INTO frasbl_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","« Vous célébrerez la fête des pains sans levain. Pendant sept jours, vous mangerez des pains sans levain, comme je vous l'ai ordonné, à l'époque fixée au mois d'Abib, car c'est au mois d'Abib que vous êtes sortis d'Égypte. ");
INSERT INTO frasbl_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","« Tout ce qui ouvre le ventre de la mère m'appartient, ainsi que tout votre bétail mâle, le premier-né des vaches et des brebis. ");
INSERT INTO frasbl_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Tu rachèteras le premier-né de l'âne par un agneau. Si tu ne veux pas le racheter, tu lui briseras le cou. Tu rachèteras tous les premiers-nés de tes fils. Personne ne se présentera devant moi à vide. ");
INSERT INTO frasbl_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","« Tu travailleras six jours, mais le septième jour, tu te reposeras : au moment des labours et de la moisson, tu te reposeras. ");
INSERT INTO frasbl_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","« Vous observerez la fête des semaines avec les prémices de la récolte du blé, et la fête de la moisson à la fin de l'année. ");
INSERT INTO frasbl_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Trois fois par an, tous vos mâles se présenteront devant le Seigneur Yahvé, le Dieu d'Israël. ");
INSERT INTO frasbl_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Car je chasserai des nations devant toi et j'élargirai tes frontières ; aucun homme ne voudra de ton pays quand tu monteras te présenter devant Yahvé, ton Dieu, trois fois par an. ");
INSERT INTO frasbl_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","« Tu n'offriras pas le sang de mon sacrifice avec des pains levés. Le sacrifice de la fête de la Pâque ne sera pas laissé au matin. ");
INSERT INTO frasbl_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","« Tu apporteras les premiers fruits de ton sol à la maison de Yahvé ton Dieu. « Tu ne feras pas bouillir un chevreau dans le lait de sa mère. » ");
INSERT INTO frasbl_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Yahvé dit à Moïse : « Écris ces paroles, car c'est en fonction de ces paroles que j'ai conclu une alliance avec toi et avec Israël. » ");
INSERT INTO frasbl_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Il resta là avec Yahvé quarante jours et quarante nuits ; il ne mangea pas de pain et ne but pas d'eau. Il écrivit sur les tables les paroles de l'alliance, les dix commandements. ");
INSERT INTO frasbl_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Lorsque Moïse descendit de la montagne du Sinaï avec les deux tables de l'alliance dans sa main, Moïse ne savait pas que la peau de son visage brillait parce qu'il lui parlait. ");
INSERT INTO frasbl_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Lorsqu'Aaron et tous les enfants d'Israël virent Moïse, voici que la peau de son visage brillait, et ils eurent peur de s'approcher de lui. ");
INSERT INTO frasbl_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Moïse les appela, et Aaron et tous les chefs de l'assemblée revinrent vers lui ; et Moïse leur parla. ");
INSERT INTO frasbl_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Ensuite, tous les enfants d'Israël s'approchèrent, et Moïse leur donna tous les commandements dont Yahvé lui avait parlé sur la montagne de Sinaï. ");
INSERT INTO frasbl_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Lorsque Moïse eut fini de leur parler, il mit un voile sur son visage. ");
INSERT INTO frasbl_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Mais lorsque Moïse entrait devant Yahvé pour lui parler, il ôtait le voile jusqu'à ce qu'il sorte ; puis il sortait et disait aux enfants d'Israël ce qu'on lui avait ordonné. ");
INSERT INTO frasbl_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Les enfants d'Israël virent le visage de Moïse, et la peau de son visage resplendit ; aussi Moïse remit-il le voile sur son visage, jusqu'à ce qu'il entrât pour lui parler. ");
INSERT INTO frasbl_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Moïse convoqua toute l'assemblée des enfants d'Israël, et leur dit : Voici les paroles que l'Éternel a prescrites, afin que vous les mettiez en pratique. ");
INSERT INTO frasbl_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Pendant six jours, on travaillera ; mais le septième jour sera pour vous un jour saint, un sabbat, un repos solennel pour Yahvé : quiconque y fera quelque ouvrage sera puni de mort. ");
INSERT INTO frasbl_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Vous n'allumerez pas de feu dans vos habitations le jour du sabbat ». ");
INSERT INTO frasbl_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Moïse parla à toute l'assemblée des enfants d'Israël, et dit : Voici ce que l'Éternel a ordonné, en disant : ");
INSERT INTO frasbl_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Prenez parmi vous une offrande pour l'Éternel. Que celui qui a le cœur bien disposé l'apporte en offrande à Yahvé : de l'or, de l'argent, de l'airain, ");
INSERT INTO frasbl_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","de l'azur, de la pourpre, de l'écarlate, du fin lin, du poil de chèvre, ");
INSERT INTO frasbl_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","des peaux de béliers teintes en rouge, des peaux de vaches marines, du bois d'acacia, ");
INSERT INTO frasbl_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","de l'huile pour le chandelier, des aromates pour l'huile d'onction et pour le parfum odoriférant, ");
INSERT INTO frasbl_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","des pierres d'onyx et des pierres à enchâsser pour l'éphod et pour le pectoral. ");
INSERT INTO frasbl_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","\"'Que tous les hommes d'entre vous qui ont du cœur viennent, et qu'ils fabriquent tout ce que l'Éternel a ordonné : ");
INSERT INTO frasbl_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","le tabernacle, sa couverture extérieure, son toit, ses agrafes, ses planches, ses barres, ses piliers et ses socles ; ");
INSERT INTO frasbl_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","l'arche et ses barres, le propitiatoire, le voile du paravent ; ");
INSERT INTO frasbl_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","la table avec ses barres et tous ses ustensiles, et les pains de proposition ; ");
INSERT INTO frasbl_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","le chandelier pour le luminaire, avec ses ustensiles, ses lampes, et l'huile pour le luminaire ; ");
INSERT INTO frasbl_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","l'autel des parfums, avec ses barres, l'huile d'onction, le parfum odoriférant, le rideau de la porte, à l'entrée de la tente ; ");
INSERT INTO frasbl_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","l'autel des holocaustes, avec sa grille d'airain, ses barres, et tous ses ustensiles, le bassin et sa base ; ");
INSERT INTO frasbl_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","les toiles du parvis, ses colonnes, leurs socles, et le rideau de la porte du parvis ; ");
INSERT INTO frasbl_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","les épingles du tabernacle, les épingles du parvis, et leurs cordons ; ");
INSERT INTO frasbl_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","les vêtements de travail pour le service du lieu saint, les vêtements sacrés du prêtre Aaron, et les vêtements de ses fils, pour le service du sacerdoce.'\" ");
INSERT INTO frasbl_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Toute la congrégation des enfants d'Israël quitta la présence de Moïse. ");
INSERT INTO frasbl_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Ils vinrent, tous ceux que leur cœur excitait et tous ceux que leur esprit rendait volontaires, et ils apportèrent l'offrande de l'Éternel pour l'ouvrage de la tente d'assignation, pour tout son service, et pour les vêtements sacrés. ");
INSERT INTO frasbl_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Ils vinrent, hommes et femmes, tous ceux qui étaient de bonne volonté, et ils apportèrent des broches, des boucles d'oreilles, des anneaux de sceau, des bracelets, tous les bijoux d'or, tous ceux qui présentaient une offrande d'or à l'Éternel. ");
INSERT INTO frasbl_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Tous ceux qui avaient trouvé du bleu, de la pourpre, de l'écarlate, du fin lin, du poil de chèvre, des peaux de béliers teintes en rouge, et des peaux de vaches marines, les apportèrent. ");
INSERT INTO frasbl_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Tous ceux qui offraient une offrande d'argent et d'airain apportaient l'offrande de Yahvé ; et tous ceux qui trouvaient du bois d'acacia pour un ouvrage quelconque du service l'apportaient. ");
INSERT INTO frasbl_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Toutes les femmes qui avaient du cœur filèrent de leurs mains et apportèrent ce qu'elles avaient filé : du bleu, du pourpre, de l'écarlate et du fin lin. ");
INSERT INTO frasbl_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Toutes les femmes dont le cœur était animé par la sagesse filèrent le poil de chèvre. ");
INSERT INTO frasbl_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Les chefs apportèrent les pierres d'onyx et les pierres à enchâsser pour l'éphod et pour le pectoral ; ");
INSERT INTO frasbl_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","ainsi que les aromates et l'huile pour le luminaire, pour l'huile d'onction et pour le parfum odoriférant. ");
INSERT INTO frasbl_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Les enfants d'Israël apportèrent une offrande volontaire à l'Éternel, chaque homme et chaque femme dont le cœur le permettait, pour tous les travaux que l'Éternel avait ordonné de faire par Moïse. ");
INSERT INTO frasbl_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Moïse dit aux enfants d'Israël : « Voici, l'Éternel a appelé par son nom Bezalel, fils d'Uri, fils de Hur, de la tribu de Juda. ");
INSERT INTO frasbl_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Il l'a rempli de l'Esprit de Dieu, de sagesse, d'intelligence, de connaissance et d'habileté dans toutes sortes d'ouvrages, ");
INSERT INTO frasbl_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","et d'habileté dans la réalisation d'ouvrages, dans le travail de l'or, de l'argent et du bronze, ");
INSERT INTO frasbl_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","dans la taille des pierres à enchâsser, dans la sculpture du bois, dans toutes sortes d'ouvrages. ");
INSERT INTO frasbl_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Il a mis dans son cœur la volonté d'enseigner, lui et Oholiab, fils d'Ahisamach, de la tribu de Dan. ");
INSERT INTO frasbl_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Il les a remplis de sagesse de cœur pour travailler toutes sortes d'ouvrages, du graveur, de l'ouvrier habile, et du brodeur, en bleu, en pourpre, en cramoisi, et en fin lin, et du tisserand, même de ceux qui font n'importe quel travail, et de ceux qui font des ouvrages habiles. ");
INSERT INTO frasbl_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","« Betsalel et Oholiab travailleront avec tout homme au cœur sage, dans lequel Yahvé a mis de la sagesse et de l'intelligence pour savoir comment faire tout le travail pour le service du sanctuaire, selon tout ce que Yahvé a ordonné. » ");
INSERT INTO frasbl_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Moïse appela Betsaleel et Oholiab, et tout homme doué de sagesse, dans le cœur duquel l'Éternel avait mis de la sagesse, tout homme dont le cœur l'incitait à venir à l'ouvrage pour le faire. ");
INSERT INTO frasbl_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Ils reçurent de Moïse toute l'offrande que les enfants d'Israël avaient apportée pour l'œuvre du service du sanctuaire, afin de l'accomplir. Ils continuaient à lui apporter chaque matin des offrandes volontaires. ");
INSERT INTO frasbl_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Tous les sages, qui accomplissaient tous les travaux du sanctuaire, venaient chacun de l'ouvrage qu'il faisait. ");
INSERT INTO frasbl_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","Ils parlèrent à Moïse et dirent : « Le peuple a apporté beaucoup plus qu'il n'en faut pour le service de l'ouvrage que l'Éternel a ordonné de faire. » ");
INSERT INTO frasbl_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Moïse donna un commandement, et on le fit proclamer dans tout le camp : « Que ni homme ni femme ne fasse autre chose pour l'offrande destinée au sanctuaire. » Le peuple s'abstint donc d'apporter. ");
INSERT INTO frasbl_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Car ce qu'ils avaient était suffisant pour faire tout le travail, et même trop. ");
INSERT INTO frasbl_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Tous les hommes sages, parmi ceux qui travaillaient, firent le tabernacle avec dix rideaux de fin lin retors, bleu, pourpre et cramoisi. Ils les firent avec des chérubins, ouvrage d'un habile ouvrier. ");
INSERT INTO frasbl_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","La longueur de chaque rideau était de vingt-huit coudées, et la largeur de chaque rideau était de quatre coudées. Tous les tapis avaient la même mesure. ");
INSERT INTO frasbl_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Il attacha cinq tapis l'un à l'autre, et il attacha les cinq autres tapis l'un à l'autre. ");
INSERT INTO frasbl_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Il fit des boucles bleues sur le bord de l'un des tapis, à partir du bord de l'assemblage. Il fit de même sur le bord du rideau le plus extérieur, dans le second assemblage. ");
INSERT INTO frasbl_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Il fit cinquante boucles dans le premier rideau, et il fit cinquante boucles dans le bord du rideau qui était dans le second assemblage. Les boucles étaient opposées l'une à l'autre. ");
INSERT INTO frasbl_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Il fit cinquante agrafes d'or, et il attacha les tapis l'un à l'autre avec les agrafes ; ainsi le tabernacle formait une unité. ");
INSERT INTO frasbl_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Il fit des tapis de poils de chèvre pour couvrir le tabernacle. Il leur fit onze rideaux. ");
INSERT INTO frasbl_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","La longueur de chaque rideau était de trente coudées, et la largeur de chaque rideau était de quatre coudées. Les onze tapis avaient une seule mesure. ");
INSERT INTO frasbl_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Il joignit cinq rideaux à part, et six rideaux à part. ");
INSERT INTO frasbl_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Il fit cinquante boucles au bord du rideau le plus extérieur dans l'assemblage, et il fit cinquante boucles au bord du rideau le plus extérieur dans le second assemblage. ");
INSERT INTO frasbl_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Il fit cinquante agrafes d'airain pour assembler le tabernacle et en faire une unité. ");
INSERT INTO frasbl_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Il fit pour le tabernacle une couverture de peaux de béliers teintes en rouge, et, par-dessus, une couverture de peaux de vaches de mer. ");
INSERT INTO frasbl_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Il fit les planches du tabernacle en bois d'acacia, debout. ");
INSERT INTO frasbl_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","La longueur d'une planche était de dix coudées, et la largeur de chaque planche était d'une coudée et demie. ");
INSERT INTO frasbl_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Chaque planche avait deux tenons, reliés l'un à l'autre. Il fit toutes les planches du tabernacle de cette manière. ");
INSERT INTO frasbl_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Il fit les planches pour le tabernacle, vingt planches pour le côté sud, vers le sud. ");
INSERT INTO frasbl_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Il fit quarante socles d'argent sous les vingt planches : deux socles sous une planche pour ses deux tenons, et deux socles sous une autre planche pour ses deux tenons. ");
INSERT INTO frasbl_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Pour le second côté du tabernacle, du côté du nord, il fit vingt planches ");
INSERT INTO frasbl_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","et leurs quarante socles d'argent : deux socles sous une planche, et deux socles sous une autre planche. ");
INSERT INTO frasbl_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Pour l'extrémité du tabernacle, à l'ouest, il fit six planches. ");
INSERT INTO frasbl_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Il fit deux planches pour les angles du tabernacle, dans la partie la plus éloignée. ");
INSERT INTO frasbl_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Elles étaient doubles en dessous, et de la même manière elles étaient jusqu'à son sommet à un seul anneau. Il fit cela pour les deux coins. ");
INSERT INTO frasbl_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Il y avait huit planches et leurs socles d'argent, seize socles, et deux socles sous chaque planche. ");
INSERT INTO frasbl_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Il fit des barres de bois d'acacia : cinq pour les planches de l'un des côtés du tabernacle, ");
INSERT INTO frasbl_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","cinq pour les planches de l'autre côté du tabernacle, et cinq pour les planches du tabernacle de l'arrière vers l'ouest. ");
INSERT INTO frasbl_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Il fit passer la barre du milieu au milieu des planches, d'un bout à l'autre. ");
INSERT INTO frasbl_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Il couvrit d'or les planches, et il fit leurs anneaux d'or pour y placer les barres, et il couvrit d'or les barres. ");
INSERT INTO frasbl_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Il fit le voile de lin bleu, pourpre et cramoisi, et de fin lin retors, avec des chérubins. Il en fit l'ouvrage d'un habile ouvrier. ");
INSERT INTO frasbl_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Il lui fit quatre colonnes d'acacia, et les couvrit d'or. Leurs crochets étaient d'or. Il fondit pour eux quatre socles d'argent. ");
INSERT INTO frasbl_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Il fit pour l`entrée de la tente un rideau bleu, pourpre et cramoisi, et un fin lin retors, ouvrage de broderie, ");
INSERT INTO frasbl_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","et ses cinq colonnes avec leurs crochets. Il recouvrit d'or leurs chapiteaux et leurs filets, et leurs cinq socles étaient d'airain. ");
INSERT INTO frasbl_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Betsaleel fit l'arche de bois d'acacia. Sa longueur était de deux coudées et demie, sa largeur d'une coudée et demie, et sa hauteur d'une coudée et demie. ");
INSERT INTO frasbl_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Il la couvrit d'or pur à l'intérieur et à l'extérieur, et fit une moulure d'or tout autour. ");
INSERT INTO frasbl_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Il fondit pour elle quatre anneaux d'or à ses quatre pieds, deux anneaux d'un côté et deux anneaux de l'autre. ");
INSERT INTO frasbl_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Il fit des perches de bois d'acacia et les couvrit d'or. ");
INSERT INTO frasbl_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Il mit les barres dans les anneaux des côtés de l'arche, pour porter l'arche. ");
INSERT INTO frasbl_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Il fit un propitiatoire d'or pur. Sa longueur était de deux coudées et demie, et sa largeur d'une coudée et demie. ");
INSERT INTO frasbl_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Il fit deux chérubins d'or. Il les fit en ouvrage battu, aux deux extrémités du propitiatoire : ");
INSERT INTO frasbl_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","un chérubin à l`une des extrémités, et un chérubin à l`autre extrémité. Il fit les chérubins d'une seule pièce avec le propitiatoire, à ses deux extrémités. ");
INSERT INTO frasbl_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Les chérubins étendaient leurs ailes au-dessus du propitiatoire et le couvraient de leurs ailes, leurs faces étant tournées l'une vers l'autre. Les faces des chérubins étaient tournées vers le propitiatoire. ");
INSERT INTO frasbl_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Il fit la table en bois d'acacia. Sa longueur était de deux coudées, sa largeur d'une coudée, et sa hauteur d'une coudée et demie. ");
INSERT INTO frasbl_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Il la couvrit d'or pur, et fit une moulure d'or autour d'elle. ");
INSERT INTO frasbl_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Il fit autour d'elle une bordure de la largeur d'une main, et il fit une moulure d'or sur sa bordure, tout autour. ");
INSERT INTO frasbl_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Il fondit pour elle quatre anneaux d'or, et il mit les anneaux aux quatre coins qui étaient à ses quatre pieds. ");
INSERT INTO frasbl_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Les anneaux étaient près de la bordure, aux endroits où l'on mettait les barres pour porter la table. ");
INSERT INTO frasbl_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Il fit les barres de bois d'acacia, et les couvrit d'or, pour porter la table. ");
INSERT INTO frasbl_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Il fit d'or pur les ustensiles qui étaient sur la table, les plats, les cuillères, les coupes et les cruches pour verser. ");
INSERT INTO frasbl_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Il fit le chandelier d'or pur. Il fit le chandelier en travail battu. Sa base, sa tige, ses coupes, ses boutons et ses fleurs étaient d'une seule pièce avec lui. ");
INSERT INTO frasbl_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Six branches sortaient de ses côtés ; trois branches du chandelier sortaient de l'un de ses côtés, et trois branches du chandelier sortaient de l'autre côté ; ");
INSERT INTO frasbl_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","trois coupes en forme de fleurs d'amandier dans une branche, un bouton et une fleur, et trois coupes en forme de fleurs d'amandier dans l'autre branche, un bouton et une fleur ; il en était de même pour les six branches qui sortaient du chandelier. ");
INSERT INTO frasbl_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Dans le chandelier, il y avait quatre coupes faites comme des fleurs d'amandier, ses bourgeons et ses fleurs ; ");
INSERT INTO frasbl_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","et un bourgeon sous deux branches d'une pièce avec lui, et un bourgeon sous deux branches d'une pièce avec lui, et un bourgeon sous deux branches d'une pièce avec lui, pour les six branches qui sortent du chandelier. ");
INSERT INTO frasbl_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Leurs bourgeons et leurs branches étaient d'une seule pièce avec elle. Le tout était un ouvrage battu d'or pur. ");
INSERT INTO frasbl_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Il fit ses sept lampes, ses éteignoirs et ses tabatières d'or pur. ");
INSERT INTO frasbl_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Il le fit d'un talent d'or pur, avec tous ses ustensiles. ");
INSERT INTO frasbl_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Il fit l'autel des parfums en bois d'acacia. Il était carré : sa longueur était d'une coudée, et sa largeur d'une coudée. Sa hauteur était de deux coudées. Ses cornes étaient d'un seul tenant avec lui. ");
INSERT INTO frasbl_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Il le couvrit d'or pur : son sommet, ses côtés tout autour et ses cornes. Il fit une moulure d'or autour d'elle. ");
INSERT INTO frasbl_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Il lui fit deux anneaux d'or sous sa couronne de moulures, sur ses deux côtes, sur ses deux côtés, pour servir d'emplacements à des perches destinées à le porter. ");
INSERT INTO frasbl_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Il fit les barres de bois d'acacia, et les couvrit d'or. ");
INSERT INTO frasbl_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Il fit l'huile d'onction sainte et le parfum pur d'épices douces, selon l'art du parfumeur. ");
INSERT INTO frasbl_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Il fit l'autel des holocaustes en bois d'acacia. Il était carré. Sa longueur était de cinq coudées, sa largeur de cinq coudées, et sa hauteur de trois coudées. ");
INSERT INTO frasbl_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Il fit ses cornes aux quatre coins. Ses cornes étaient d'un seul tenant avec lui, et il le couvrit d'airain. ");
INSERT INTO frasbl_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Il fit tous les ustensiles de l'autel : les marmites, les pelles, les bassins, les fourchettes et les brasiers. Il fit tous ses ustensiles en bronze. ");
INSERT INTO frasbl_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Il fit pour l'autel une grille d'un réseau de bronze, sous le rebord qui l'entoure en bas, et qui atteint la moitié de sa hauteur. ");
INSERT INTO frasbl_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Il fondit quatre anneaux aux quatre coins de la grille d'airain, pour servir de support aux poteaux. ");
INSERT INTO frasbl_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Il fit les poteaux de bois d'acacia, et les recouvrit de bronze. ");
INSERT INTO frasbl_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Il plaça les perches dans les anneaux situés sur les côtés de l'autel, pour le porter. Il le rendit creux avec des planches. ");
INSERT INTO frasbl_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Il fit le bassin d'airain et sa base d'airain, avec les miroirs des servantes qui faisaient le service à l'entrée de la tente de la Rencontre. ");
INSERT INTO frasbl_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Il fit le parvis. Du côté du midi, les toiles du parvis étaient de fin lin retors, de cent coudées. ");
INSERT INTO frasbl_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Les colonnes étaient au nombre de vingt, et les bases au nombre de vingt, en bronze ; les crochets des colonnes et leurs tringles étaient en argent. ");
INSERT INTO frasbl_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Pour le côté septentrional, il y avait cent coudées ; leurs vingt colonnes et leurs vingt bases étaient en bronze ; les crochets des colonnes et leurs tringles étaient en argent. ");
INSERT INTO frasbl_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Pour le côté occidental, il y avait des tentures de cinquante coudées, avec dix colonnes et dix bases, les crochets des colonnes et leurs tringles étant en argent. ");
INSERT INTO frasbl_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Pour le côté oriental, vers l'est, il y avait cinquante coudées ; ");
INSERT INTO frasbl_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","pour un côté, les tentures avaient quinze coudées, leurs colonnes trois, et leurs bases trois ; ");
INSERT INTO frasbl_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","et de même pour l'autre côté : d'un côté et de l'autre, à la porte du parvis, il y avait des tentures de quinze coudées, leurs colonnes trois, et leurs bases trois. ");
INSERT INTO frasbl_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Toutes les tentures qui entouraient le parvis étaient de fin lin retors. ");
INSERT INTO frasbl_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Les bases des colonnes étaient en bronze. Les crochets des colonnes et leurs filets étaient d'argent. Leurs chapiteaux étaient recouverts d'argent. Tous les piliers du parvis avaient des bandes d'argent. ");
INSERT INTO frasbl_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Le rideau de la porte du parvis était un ouvrage de broderie, en bleu, pourpre et cramoisi, et en fin lin retors. Sa longueur était de vingt coudées, et sa hauteur dans le sens de la largeur était de cinq coudées, comme les toiles du parvis. ");
INSERT INTO frasbl_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Les colonnes étaient au nombre de quatre, et les socles au nombre de quatre, en bronze ; les crochets étaient en argent, et les garnitures des chapiteaux et les filets étaient en argent. ");
INSERT INTO frasbl_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Tous les pieux du tabernacle et du parvis étaient d'airain. ");
INSERT INTO frasbl_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Voici les quantités de matériaux utilisés pour le tabernacle, le tabernacle du témoignage, telles qu'elles ont été comptées, selon l'ordre de Moïse, pour le service des Lévites, par Ithamar, fils du prêtre Aaron. ");
INSERT INTO frasbl_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Betsaleel, fils d'Uri, fils de Hur, de la tribu de Juda, fit tout ce que Yahvé avait ordonné à Moïse. ");
INSERT INTO frasbl_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Il avait avec lui Oholiab, fils d'Ahisamach, de la tribu de Dan, graveur, habile ouvrier, et brodeur en bleu, en pourpre, en cramoisi et en fin lin. ");
INSERT INTO frasbl_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Tout l'or qui servit à l'exécution de tous les travaux du sanctuaire, l'or des offrandes, fut de vingt-neuf talents et sept cent trente sicles, selon le sicle du sanctuaire. ");
INSERT INTO frasbl_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","L'argent de ceux qui étaient comptés dans l'assemblée était de cent talents et de mille sept cent soixante-quinze sicles, selon le sicle du sanctuaire : ");
INSERT INTO frasbl_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","un beka par tête, c'est-à-dire un demi-sicle, selon le sicle du sanctuaire, pour tous ceux qui passaient à l'appel de l'assemblée, depuis l'âge de vingt ans et au-dessus, soit six cent trois mille cinq cent cinquante hommes. ");
INSERT INTO frasbl_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Les cent talents d'argent étaient destinés à couler les socles du sanctuaire et les socles du voile : cent socles pour les cent talents, un talent par socle. ");
INSERT INTO frasbl_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Avec les mille sept cent soixante-quinze sicles, il fit des crochets pour les piliers, recouvrit leurs chapiteaux et leur fit des filets. ");
INSERT INTO frasbl_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Le bronze de l'offrande était de soixante-dix talents et de deux mille quatre cents sicles. ");
INSERT INTO frasbl_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Il fit avec cela les socles de l'entrée de la tente d'assignation, l'autel d'airain, sa grille d'airain, tous les ustensiles de l'autel, ");
INSERT INTO frasbl_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","les socles du parvis, les socles de la porte du parvis, toutes les broches du tabernacle et toutes les broches du parvis. ");
INSERT INTO frasbl_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Ils firent des vêtements bleus, pourpres et écarlates pour le service dans le lieu saint, et ils firent les vêtements sacrés d'Aaron, comme Yahvé l'avait ordonné à Moïse. ");
INSERT INTO frasbl_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Il fit l'éphod d'or, de bleu, de pourpre, d'écarlate et de fin lin retors. ");
INSERT INTO frasbl_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","On battit l'or en plaques minces et on le tailla en fils, pour l'associer au bleu, à la pourpre, à l'écarlate et au fin lin, ouvrage d'un habile ouvrier. ");
INSERT INTO frasbl_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","On lui fit des courroies d'épaule, jointes ensemble. On l'assemblait par les deux bouts. ");
INSERT INTO frasbl_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","La bande qui l'entourait, et qui servait à l'attacher, était d'une seule pièce, comme son ouvrage, d'or, de bleu, de pourpre, d'écarlate et de fin lin retors, selon ce que l'Éternel avait ordonné à Moïse. ");
INSERT INTO frasbl_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Ils travaillèrent les pierres d'onyx, enfermées dans des montures d'or, gravées avec les gravures d'un sceau, selon les noms des enfants d'Israël. ");
INSERT INTO frasbl_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Il les mit sur les bretelles de l'éphod, comme pierres de souvenir pour les enfants d'Israël, selon ce que l'Éternel avait ordonné à Moïse. ");
INSERT INTO frasbl_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Il fit le pectoral, ouvrage d'un habile ouvrier, comme l'ouvrage de l'éphod : d'or, de bleu, de pourpre, d'écarlate, et de fin lin retors. ");
INSERT INTO frasbl_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Il était carré. On fit le pectoral double. Sa longueur était d'un empan, et sa largeur d'un empan ; il était double. ");
INSERT INTO frasbl_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","On y plaça quatre rangées de pierres. La première rangée était formée de rubis, de topazes et de béryls ; ");
INSERT INTO frasbl_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","la seconde, de turquoises, de saphirs et d'émeraudes ; ");
INSERT INTO frasbl_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","la troisième, de jacinthes, d'agates et d'améthystes ; ");
INSERT INTO frasbl_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","la quatrième, de chrysolites, d'onyx et de jaspes. Ils étaient entourés de montures d'or. ");
INSERT INTO frasbl_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Les pierres étaient d'après les noms des enfants d'Israël, douze, selon leurs noms ; comme les gravures d'un cachet, chacun selon son nom, pour les douze tribus. ");
INSERT INTO frasbl_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","On fit sur le pectoral des chaînettes semblables à des cordons, tressées d'or pur. ");
INSERT INTO frasbl_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Ils firent deux montures d'or et deux anneaux d'or, et ils mirent les deux anneaux aux deux extrémités du pectoral. ");
INSERT INTO frasbl_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","On mit les deux chaînettes d'or tressées dans les deux anneaux, aux deux extrémités du pectoral. ");
INSERT INTO frasbl_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","On mit les deux autres extrémités des deux chaînettes tressées sur les deux montures, et on les plaça sur les bretelles de l'éphod, sur son devant. ");
INSERT INTO frasbl_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Ils firent deux anneaux d'or, et les mirent aux deux extrémités du pectoral, sur son bord, qui était vers le côté de l'éphod, en dedans. ");
INSERT INTO frasbl_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Ils firent deux autres anneaux d'or, et les mirent aux deux bretelles de l'éphod, en dessous, sur le devant, près de son attache, au-dessus de la bande de l'éphod, habilement tissée. ");
INSERT INTO frasbl_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Ils attachèrent le pectoral par ses anneaux aux anneaux de l'éphod avec un lacet bleu, afin qu'il soit sur la ceinture de l'éphod et que le pectoral ne se détache pas de l'éphod, comme l'Éternel l'avait ordonné à Moïse. ");
INSERT INTO frasbl_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Il fit la robe de l'éphod d'un travail tissé, tout en bleu. ");
INSERT INTO frasbl_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","L'ouverture de la robe, au milieu, était comme l'ouverture d'une cotte de mailles, avec un lien autour de l'ouverture, pour qu'elle ne se déchire pas. ");
INSERT INTO frasbl_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","On fit sur les pans de la robe des grenades de couleur bleue, pourpre, écarlate et de lin retors. ");
INSERT INTO frasbl_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","On fit des clochettes d'or pur, et on mit les clochettes entre les grenades, autour des pans de la robe, entre les grenades ; ");
INSERT INTO frasbl_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","une cloche et une grenade, une cloche et une grenade, autour des pans de la robe, pour faire le service, comme Yahvé l'avait ordonné à Moïse. ");
INSERT INTO frasbl_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Ils firent les tuniques de lin fin tissé pour Aaron et ses fils, ");
INSERT INTO frasbl_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","le turban de lin fin, les bandeaux de lin fin, les pantalons de lin fin retors, ");
INSERT INTO frasbl_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","la ceinture de lin fin retors, bleu, pourpre et cramoisi, ouvrage du brodeur, comme Yahvé l'avait ordonné à Moïse. ");
INSERT INTO frasbl_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Ils firent la plaque de la couronne sacrée en or pur, et y inscrivirent une inscription, comme les gravures d'un sceau : « Sainteté à YAHVÉ ». ");
INSERT INTO frasbl_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Ils y attachèrent un lacet de couleur bleue, pour le fixer au turban du dessus, comme Yahvé l'avait ordonné à Moïse. ");
INSERT INTO frasbl_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Ainsi fut achevée toute l'œuvre du tabernacle de la tente de la Rencontre. Les enfants d'Israël firent tout ce que l'Éternel avait ordonné à Moïse ; ils firent ainsi. ");
INSERT INTO frasbl_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Ils apportèrent à Moïse le tabernacle : la tente, avec tous ses meubles, ses agrafes, ses planches, ses barres, ses piliers, ses socles, ");
INSERT INTO frasbl_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","la couverture de peaux de béliers teintes en rouge, la couverture de peaux de vaches de mer, le voile du paravent, ");
INSERT INTO frasbl_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","l'arche de l'alliance avec ses perches, le propitiatoire, ");
INSERT INTO frasbl_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","la table, tous ses ustensiles, le pain de proposition, ");
INSERT INTO frasbl_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","le chandelier pur, ses lampes, les lampes à mettre en ordre, tous ses ustensiles, l'huile pour la lumière, ");
INSERT INTO frasbl_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","l'autel d'or, l'huile d'onction, le parfum odoriférant, le rideau de la porte de la tente, ");
INSERT INTO frasbl_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","l'autel d'airain, sa grille d'airain, ses barres, tous ses ustensiles, le bassin et son socle, ");
INSERT INTO frasbl_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","les tentures du parvis, ses colonnes, ses socles, le rideau de la porte du parvis, ses cordons, ses pieux, tous les instruments pour le service du tabernacle, pour la tente d'assignation, ");
INSERT INTO frasbl_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","les vêtements de cérémonie pour le service dans le sanctuaire, les vêtements sacrés pour le prêtre Aaron et les vêtements de ses fils pour le service dans le sacerdoce. ");
INSERT INTO frasbl_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Les enfants d'Israël firent tout le travail, selon tout ce que l'Éternel avait ordonné à Moïse. ");
INSERT INTO frasbl_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Moïse vit tout l'ouvrage, et voici qu'ils l'avaient fait comme l'avait ordonné l'Éternel. Ils avaient agi ainsi, et Moïse les bénit. ");
INSERT INTO frasbl_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Yahvé parla à Moïse, et dit : ");
INSERT INTO frasbl_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","Le premier jour du premier mois, tu relèveras le tabernacle de la tente de la Rencontre. ");
INSERT INTO frasbl_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Tu y placeras l'arche de l'alliance, et tu protégeras l'arche avec le voile. ");
INSERT INTO frasbl_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Tu feras entrer la table et tu mettras en ordre les objets qui s'y trouvent. Tu feras entrer le chandelier et tu allumeras ses lampes. ");
INSERT INTO frasbl_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Tu placeras l'autel d'or pour les parfums devant l'arche de l'alliance, et tu mettras le rideau de l'entrée du tabernacle. ");
INSERT INTO frasbl_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","« Tu placeras l'autel des holocaustes devant l'entrée de la tente de la Rencontre. ");
INSERT INTO frasbl_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Tu placeras le bassin entre la tente d'assignation et l'autel, et tu y mettras de l'eau. ");
INSERT INTO frasbl_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Tu dresseras le parvis tout autour, et tu accrocheras le rideau de la porte du parvis. ");
INSERT INTO frasbl_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","« Tu prendras l'huile d'onction, tu oindras le tabernacle et tout ce qui s'y trouve, et tu le sanctifieras, ainsi que tout son mobilier, et il sera saint. ");
INSERT INTO frasbl_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Tu oindras l'autel des holocaustes et tous ses ustensiles, tu sanctifieras l'autel, et l'autel sera très saint. ");
INSERT INTO frasbl_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Tu oindras le bassin et sa base, et tu le sanctifieras. ");
INSERT INTO frasbl_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","« Tu feras venir Aaron et ses fils à l'entrée de la tente de la Rencontre, et tu les laveras avec de l'eau. ");
INSERT INTO frasbl_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Tu revêtiras Aaron des vêtements sacrés, tu l'oindras et tu le sanctifieras, afin qu'il soit à mon service dans la fonction de prêtre. ");
INSERT INTO frasbl_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Tu feras venir ses fils, et tu les revêtiras de tuniques. ");
INSERT INTO frasbl_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Tu les oindras, comme tu as oint leur père, afin qu'ils soient à mon service dans le sacerdoce. Leur onction leur servira de sacerdoce pour l'éternité, de génération en génération. » ");
INSERT INTO frasbl_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Moïse fit ainsi. Il fit tout ce que Yahvé lui avait ordonné. ");
INSERT INTO frasbl_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Le premier mois de la seconde année, le premier jour du mois, on éleva le tabernacle. ");
INSERT INTO frasbl_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Moïse éleva le tabernacle, en posa les bases, en dressa les planches, en plaça les barres et en dressa les colonnes. ");
INSERT INTO frasbl_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Il étendit la couverture sur la tente et posa dessus le toit du tabernacle, comme l'Yahvé l'avait ordonné à Moïse. ");
INSERT INTO frasbl_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Il prit l'alliance et la mit dans l'arche, il plaça les poteaux sur l'arche, et il plaça le propitiatoire au-dessus de l'arche. ");
INSERT INTO frasbl_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Il fit entrer l'arche dans la tente, plaça le voile du rideau et protégea l'arche de l'alliance, comme l'Éternel l'avait ordonné à Moïse. ");
INSERT INTO frasbl_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Il plaça la table dans la tente d'assignation, au nord de la tente, en dehors du voile. ");
INSERT INTO frasbl_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Il y déposa le pain en ordre devant l'Éternel, comme l'Éternel l'avait ordonné à Moïse. ");
INSERT INTO frasbl_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Il plaça le chandelier dans la tente d'assignation, en face de la table, du côté sud de la tente. ");
INSERT INTO frasbl_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Il alluma les lampes devant l'Éternel, comme l'Éternel l'avait ordonné à Moïse. ");
INSERT INTO frasbl_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Il plaça l'autel d'or dans la tente d'assignation, devant le voile, ");
INSERT INTO frasbl_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","et il y brûla des parfums d'aromates, comme l'Éternel l'avait ordonné à Moïse. ");
INSERT INTO frasbl_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Il dressa le rideau de l'entrée de la tente d'assignation. ");
INSERT INTO frasbl_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Il plaça l'autel des holocaustes à l'entrée du tabernacle, dans la tente d'assignation, et il y offrit l'holocauste et l'offrande, comme Yahvé l'avait ordonné à Moïse. ");
INSERT INTO frasbl_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Il plaça le bassin entre la tente d'assignation et l'autel, et y mit de l'eau pour se laver. ");
INSERT INTO frasbl_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Moïse, Aaron et ses fils y lavèrent leurs mains et leurs pieds. ");
INSERT INTO frasbl_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Lorsqu'ils entraient dans la tente de la Rencontre et qu'ils s'approchaient de l'autel, ils se lavaient, comme l'avait ordonné l'Éternel à Moïse. ");
INSERT INTO frasbl_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Il releva le parvis autour de la tente et de l'autel, et dressa le rideau de la porte du parvis. Moïse acheva ainsi l'ouvrage. ");
INSERT INTO frasbl_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Alors la nuée couvrit la Tente de la Rencontre, et la gloire de Yahvé remplit la Tente. ");
INSERT INTO frasbl_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Moïse ne pouvait pas entrer dans la Tente de la Rencontre, car la nuée restait dessus, et la gloire de Yahvé remplissait la Tente. ");
INSERT INTO frasbl_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Lorsque la nuée s'élevait au-dessus de la Tente, les enfants d'Israël continuaient à marcher dans tous leurs déplacements. ");
INSERT INTO frasbl_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Mais si la nuée ne s'élevait pas, ils ne voyageaient pas jusqu'au jour où elle s'élevait. ");
INSERT INTO frasbl_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Car la nuée de Yahvé était sur le tabernacle pendant le jour, et il y avait du feu dans la nuée pendant la nuit, aux yeux de toute la maison d'Israël, pendant tous leurs voyages. ");
INSERT INTO frasbl_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Yahvé appela Moïse et lui parla depuis la tente d'assignation, en disant : ");
INSERT INTO frasbl_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","Parle aux enfants d'Israël et dis-leur : « Quand quelqu'un d'entre vous présentera une offrande à Yahvé, il offrira une offrande de bétail, du gros et du menu bétail. ");
INSERT INTO frasbl_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","\"'Si son offrande est un holocauste de bétail, il offrira un mâle sans défaut. Il l'offrira à l'entrée de la Tente d'assignation, afin qu'il soit agréé devant Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Il posera sa main sur la tête de l'holocauste, et celui-ci sera agréé pour lui, afin qu'il fasse l'expiation. ");
INSERT INTO frasbl_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Il égorgera le taureau devant Yahvé. Les fils d'Aaron, les prêtres, présenteront le sang et en feront l'aspersion tout autour de l'autel qui est à l'entrée de la tente de la Rencontre. ");
INSERT INTO frasbl_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Il dépouillera l'holocauste et le coupera en morceaux. ");
INSERT INTO frasbl_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Les fils du sacrificateur Aaron mettront du feu sur l'autel et poseront du bois en ordre sur le feu ; ");
INSERT INTO frasbl_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","et les fils d'Aaron, les sacrificateurs, poseront les morceaux, la tête et la graisse en ordre sur le bois qui est sur le feu, sur l'autel ; ");
INSERT INTO frasbl_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","mais il lavera à l'eau les entrailles et les jambes. Le prêtre brûlera tout cela sur l'autel, comme holocauste, une offrande consumée par le feu, d'une odeur agréable à Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","\"'Si son offrande provient du troupeau, des brebis ou des chèvres, pour un holocauste, il offrira un mâle sans défaut. ");
INSERT INTO frasbl_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Il l'égorgera sur le côté nord de l'autel, devant Yahvé. Les fils d'Aaron, les prêtres, en répandront le sang tout autour de l'autel. ");
INSERT INTO frasbl_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Il le coupera en morceaux, avec sa tête et sa graisse. Le prêtre les disposera en ordre sur le bois qui est sur le feu, sur l'autel, ");
INSERT INTO frasbl_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","mais il lavera à l'eau les entrailles et les pattes. Le prêtre offrira le tout et le brûlera sur l'autel. C'est un holocauste, une offrande consumée par le feu, d'une odeur agréable à Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","\"'Si son offrande à Yahvé est un holocauste d'oiseaux, il offrira son offrande de tourterelles ou de jeunes pigeons. ");
INSERT INTO frasbl_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Le prêtre l'amènera à l'autel, il lui essorera la tête et la brûlera sur l'autel ; son sang se répandra sur le côté de l'autel ; ");
INSERT INTO frasbl_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","il enlèvera son jabot et ses plumes et les jettera à côté de l'autel, à l'orient, à la place des cendres. ");
INSERT INTO frasbl_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Il la déchirera par les ailes, mais il ne la séparera pas. Le prêtre la brûlera sur l'autel, sur le bois qui est sur le feu. C'est un holocauste, un sacrifice consumé par le feu, d'une odeur agréable à Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","\"'Lorsque quelqu'un présentera une offrande de repas à Yahvé, son offrande sera de fine farine. Il versera de l'huile dessus et y mettra de l'encens. ");
INSERT INTO frasbl_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Il l'apportera aux fils d'Aaron, les prêtres. Il prendra sa poignée de fleur de farine et d'huile, avec tout l'encens, et le prêtre en brûlera le souvenir sur l'autel, comme une offrande consumée par le feu, d'une odeur agréable à Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Ce qui restera de l'offrande de farine appartiendra à Aaron et à ses fils. C'est une partie très sainte des offrandes de Yahvé faites par le feu. ");
INSERT INTO frasbl_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","\"'Lorsque tu offriras une offrande de repas cuite au four, ce seront des gâteaux de fine farine sans levain mélangés à de l'huile, ou des galettes sans levain ointes d'huile. ");
INSERT INTO frasbl_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Si ton offrande est une offrande de farine cuite sur une plaque, elle sera faite de farine fine sans levain, mélangée à de l'huile. ");
INSERT INTO frasbl_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Tu la couperas en morceaux, et tu verseras de l'huile dessus. C'est une offrande de repas. ");
INSERT INTO frasbl_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Si ton offrande est une offrande de farine de poêle, elle sera faite de fleur de farine avec de l'huile. ");
INSERT INTO frasbl_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Tu apporteras à l'Éternel l'offrande composée de ces choses. Elle sera présentée au prêtre, qui l'amènera sur l'autel. ");
INSERT INTO frasbl_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Le sacrificateur prélèvera de l'offrande de farine son souvenir, et il la brûlera sur l'autel : c'est une offrande consumée par le feu, d'une agréable odeur à l'Éternel. ");
INSERT INTO frasbl_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Ce qui restera de l'offrande de farine appartiendra à Aaron et à ses fils. C'est une partie très sainte des offrandes de Yahvé faites par le feu. ");
INSERT INTO frasbl_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","\"'Aucune des offrandes de farine que tu offriras à l'Éternel ne sera faite avec du levain ; car tu ne brûleras ni levain, ni miel, en tant qu'offrande consumée par le feu à l'Éternel. ");
INSERT INTO frasbl_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Tu les offriras à l'Éternel comme offrande de prémices, mais elles ne s'élèveront pas en parfum d'agrément sur l'autel. ");
INSERT INTO frasbl_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Tu assaisonneras de sel chaque offrande de ton repas. Tu ne laisseras pas manquer le sel de l'alliance de ton Dieu dans ton offrande de repas. Avec toutes tes offrandes, tu offriras du sel. ");
INSERT INTO frasbl_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","\"'Si tu offres une offrande de prémices à Yahvé, tu offriras pour l'offrande de tes prémices des épis de blé frais, séchés au feu et broyés. ");
INSERT INTO frasbl_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Tu mettras de l'huile dessus et tu y déposeras de l'encens. C'est une offrande de repas. ");
INSERT INTO frasbl_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Le prêtre brûlera en souvenir une partie du grain broyé et une partie de l'huile, ainsi que tout l'encens. C'est une offrande consumée par le feu à Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","\"'Si son offrande est un sacrifice d'actions de grâces, s'il l'offre du troupeau, mâle ou femelle, il l'offrira sans défaut devant Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Il posera sa main sur la tête de son offrande et l'égorgera à l'entrée de la Tente d'assignation. Les fils d'Aaron, les prêtres, répandront le sang tout autour sur l'autel. ");
INSERT INTO frasbl_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Il offrira du sacrifice d'actions de grâces un sacrifice consumé par le feu à Yahvé. Il enlèvera la graisse qui couvre les entrailles, toute la graisse qui est sur les entrailles, ");
INSERT INTO frasbl_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","les deux rognons et la graisse qui est sur eux, qui est près des reins, et la couverture du foie, avec les rognons. ");
INSERT INTO frasbl_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Les fils d'Aaron brûleront cela sur l'autel, sur l'holocauste qui est sur le bois qui est sur le feu : c'est un sacrifice consumé par le feu, d'une odeur agréable à Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","\"'Si son offrande pour le sacrifice d'actions de grâces à Yahvé est issue du troupeau, mâle ou femelle, il l'offrira sans défaut. ");
INSERT INTO frasbl_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","S'il offre un agneau en sacrifice, il l'offrira devant Yahvé ; ");
INSERT INTO frasbl_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","il posera sa main sur la tête de son offrande et l'égorgera devant la tente d'assignation. Les fils d'Aaron en répandront le sang tout autour sur l'autel. ");
INSERT INTO frasbl_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Il prélèvera sur le sacrifice d'actions de grâces un sacrifice consumé par le feu en l'honneur de l'Éternel ; il enlèvera la graisse, toute la graisse de la queue, jusqu'à l'épine dorsale ; il enlèvera la graisse qui recouvre les entrailles, et toute la graisse qui est sur les entrailles, ");
INSERT INTO frasbl_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","ainsi que les deux rognons et la graisse qui les recouvre, qui se trouve près des reins, et la couverture du foie, avec les rognons. ");
INSERT INTO frasbl_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Le prêtre brûlera cela sur l'autel : c'est l'aliment de l'offrande consumée par le feu à Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","\"'Si son offrande est un bouc, il l'offrira devant l'Éternel. ");
INSERT INTO frasbl_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","Il posera sa main sur sa tête et l'égorgera devant la Tente d'assignation ; les fils d'Aaron en répandront le sang tout autour de l'autel. ");
INSERT INTO frasbl_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Il en fera son offrande, un sacrifice consumé par le feu à l'Éternel : il enlèvera la graisse qui couvre les entrailles et toute la graisse qui est sur les entrailles, ");
INSERT INTO frasbl_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","les deux rognons et la graisse qui est sur eux, qui est près des reins, et la couverture du foie, avec les rognons. ");
INSERT INTO frasbl_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Le prêtre les brûlera sur l'autel : c'est l'aliment de l'offrande consumée par le feu, d'une agréable odeur ; toute la graisse appartient à l'Éternel. ");
INSERT INTO frasbl_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","\"'Ce sera une loi perpétuelle de génération en génération dans toutes vos habitations, vous ne mangerez ni graisse ni sang'\". ");
INSERT INTO frasbl_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Yahvé parla à Moïse et dit : ");
INSERT INTO frasbl_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","Parle aux enfants d'Israël et dis-leur : Si quelqu'un commet un péché involontaire en faisant l'une des choses que Yahvé a ordonné de ne pas faire, et qu'il la commette, ");
INSERT INTO frasbl_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","si le prêtre oint a péché au point de rendre le peuple coupable, qu'il offre à Yahvé, en sacrifice pour le péché qu'il a commis, un jeune taureau sans défaut. ");
INSERT INTO frasbl_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Il amènera le taureau à l'entrée de la Tente d'assignation, devant l'Éternel ; il posera sa main sur la tête du taureau et l'égorgera devant l'Éternel. ");
INSERT INTO frasbl_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Le prêtre oint prendra du sang du taureau et l'apportera dans la tente de la Rencontre. ");
INSERT INTO frasbl_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Le prêtre trempera son doigt dans le sang et fera sept fois l'aspersion du sang devant l'Éternel, devant le voile du sanctuaire. ");
INSERT INTO frasbl_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Le prêtre mettra une partie du sang sur les cornes de l'autel des parfums doux, devant l'Éternel, qui est dans la tente de la Rencontre ; il versera le reste du sang du taureau au pied de l'autel des holocaustes, qui est à l'entrée de la tente de la Rencontre. ");
INSERT INTO frasbl_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Il enlèvera toute la graisse du taureau du sacrifice pour le péché : la graisse qui couvre les entrailles et toute la graisse qui est sur les entrailles, ");
INSERT INTO frasbl_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","les deux rognons et la graisse qui est sur eux, qui est près des reins, et la couverture du foie, avec les rognons, il les enlèvera, ");
INSERT INTO frasbl_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","comme on les enlève du taureau du sacrifice d'actions de grâces. Le prêtre les brûlera sur l'autel des holocaustes. ");
INSERT INTO frasbl_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Il portera la peau du taureau, toute sa viande, avec sa tête et ses pattes, ses entrailles et ses excréments ");
INSERT INTO frasbl_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","-tout le reste du taureau- hors du camp, dans un lieu propre où l'on répand les cendres, et il le brûlera au feu sur du bois. On le brûlera à l'endroit où l'on a répandu les cendres. ");
INSERT INTO frasbl_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","\"'Si toute l'assemblée d'Israël a péché, si la chose est cachée aux yeux de l'assemblée, si elle a fait l'une des choses que l'Éternel a ordonné de ne pas faire et si elle s'est rendue coupable, ");
INSERT INTO frasbl_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","si le péché qu'elle a commis est connu, l'assemblée offrira un jeune taureau en sacrifice pour le péché et l'amènera devant la tente d'assignation. ");
INSERT INTO frasbl_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Les anciens de l'assemblée poseront leurs mains sur la tête du taureau devant l'Éternel, et le taureau sera égorgé devant l'Éternel. ");
INSERT INTO frasbl_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Le prêtre oint apportera une partie du sang du taureau dans la tente de la Rencontre. ");
INSERT INTO frasbl_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Le prêtre trempera son doigt dans le sang et en fera sept fois l'aspersion devant l'Éternel, en face du voile. ");
INSERT INTO frasbl_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Il mettra une partie du sang sur les cornes de l'autel qui est devant l'Éternel, dans la tente de la Rencontre, et il versera le reste du sang au pied de l'autel des holocaustes, à l'entrée de la tente de la Rencontre. ");
INSERT INTO frasbl_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Il en prélèvera toute la graisse et la brûlera sur l'autel. ");
INSERT INTO frasbl_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Il fera cela avec le taureau ; comme il a fait avec le taureau du sacrifice pour le péché, il fera de même avec celui-ci ; le prêtre fera l'expiation pour eux, et ils seront pardonnés. ");
INSERT INTO frasbl_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Il portera le taureau hors du camp, et il le brûlera comme il a brûlé le premier taureau. C'est le sacrifice pour le péché de l'assemblée. ");
INSERT INTO frasbl_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","\"'Lorsqu'un chef péchera et fera involontairement l'une de toutes les choses que l'Éternel, son Dieu, a ordonné de ne pas faire, et qu'il en sera coupable, ");
INSERT INTO frasbl_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","si le péché qu'il a commis lui est connu, il apportera en offrande un bouc, un mâle sans défaut. ");
INSERT INTO frasbl_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Il posera sa main sur la tête du bouc, et il l'égorgera dans le lieu où l'on égorge l'holocauste devant l'Éternel. C'est un sacrifice pour le péché. ");
INSERT INTO frasbl_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Le prêtre prendra avec son doigt une partie du sang du sacrifice pour le péché, et il en mettra sur les cornes de l'autel des holocaustes. Il versera le reste du sang au pied de l'autel des holocaustes. ");
INSERT INTO frasbl_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Il brûlera toute sa graisse sur l'autel, comme la graisse du sacrifice d'actions de grâces ; le prêtre fera pour lui l'expiation de son péché, et il lui sera pardonné. ");
INSERT INTO frasbl_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","\"'Si quelqu'un du peuple pèche involontairement en faisant l'une des choses que l'Éternel a ordonné de ne pas faire, et s'il est coupable, ");
INSERT INTO frasbl_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","si le péché qu'il a commis lui est connu, il apportera en offrande une chèvre, une femelle sans défaut, pour le péché qu'il a commis. ");
INSERT INTO frasbl_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Il posera sa main sur la tête du sacrifice pour le péché, et il égorgera le sacrifice pour le péché dans le lieu de l'holocauste. ");
INSERT INTO frasbl_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Le sacrificateur prendra de son sang avec son doigt, et en mettra sur les cornes de l'autel des holocaustes ; il versera le reste du sang au pied de l'autel. ");
INSERT INTO frasbl_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Il enlèvera toute la graisse, comme on enlève la graisse du sacrifice d'actions de grâces, et le prêtre la brûlera sur l'autel comme une odeur agréable à Yahvé ; le prêtre fera l'expiation pour lui, et il lui sera pardonné. ");
INSERT INTO frasbl_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","\"'S'il apporte un agneau en sacrifice pour le péché, il apportera une femelle sans défaut. ");
INSERT INTO frasbl_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Il posera sa main sur la tête du sacrifice pour le péché et l'égorgera en sacrifice pour le péché dans le lieu où l'on égorge l'holocauste. ");
INSERT INTO frasbl_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Le prêtre prendra avec son doigt une partie du sang du sacrifice pour le péché, et il en mettra sur les cornes de l'autel des holocaustes ; il versera tout le reste du sang au pied de l'autel. ");
INSERT INTO frasbl_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Il enlèvera toute la graisse, comme on enlève la graisse de l'agneau pour le sacrifice d'actions de grâces. Le prêtre les brûlera sur l'autel, sur les offrandes de Yahvé faites par le feu. Le prêtre fera pour lui l'expiation du péché qu'il a commis, et il lui sera pardonné. ");
INSERT INTO frasbl_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","\"'Si quelqu'un pèche, en entendant une adjuration publique pour témoigner, lui étant témoin, qu'il a vu ou connu, s'il ne le rapporte pas, il portera sa faute. ");
INSERT INTO frasbl_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","\"'Si quelqu'un touche une chose impure, qu'il s'agisse du cadavre d'un animal impur, du cadavre d'un animal de rente impur ou du cadavre d'un reptile impur, et que cela lui soit caché, et qu'il soit impur, il sera coupable. ");
INSERT INTO frasbl_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","\"'Ou bien, s'il touche l'impureté de l'homme, quelle que soit l'impureté avec laquelle il est souillé, et qu'elle lui soit cachée, quand il en aura connaissance, il sera coupable. ");
INSERT INTO frasbl_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","\"'Si quelqu'un jure témérairement de ses lèvres de faire du mal ou de faire du bien - tout ce qu'un homme peut proférer témérairement par un serment, et que cela lui soit caché - lorsqu'il en aura connaissance, il sera coupable de l'une de ces choses. ");
INSERT INTO frasbl_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","S'il se rend coupable de l'une de ces choses, il confessera le péché qu'il a commis ; ");
INSERT INTO frasbl_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","et il apportera à l'Éternel son sacrifice de culpabilité pour le péché qu'il a commis : une femelle du troupeau, un agneau ou une chèvre, en sacrifice pour le péché ; et le prêtre fera pour lui l'expiation de son péché. ");
INSERT INTO frasbl_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","\"'S'il n'a pas les moyens de se procurer un agneau, il apportera à Yahvé son sacrifice pour le péché qu'il a commis, deux tourterelles ou deux jeunes pigeons, l'un pour le sacrifice pour le péché, l'autre pour l'holocauste. ");
INSERT INTO frasbl_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Il les apportera au sacrificateur, qui offrira d'abord celle qui est pour le sacrifice pour le péché. Il lui arrachera la tête du cou, mais il ne la coupera pas complètement. ");
INSERT INTO frasbl_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Il fera aspersion d'une partie du sang du sacrifice pour le péché sur le côté de l'autel, et le reste du sang sera versé au pied de l'autel. C'est un sacrifice pour le péché. ");
INSERT INTO frasbl_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Il offrira le second en holocauste, selon les règles établies ; le sacrificateur fera pour lui l'expiation du péché qu'il a commis, et il lui sera pardonné. ");
INSERT INTO frasbl_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","\"'Mais s'il n'a pas les moyens de se procurer deux tourterelles ou deux jeunes pigeons, il apportera en offrande pour le péché qu'il a commis, un dixième d'épha de fleur de farine en sacrifice pour le péché. Il n'y mettra pas d'huile et il n'y mettra pas d'encens, car c'est un sacrifice pour le péché. ");
INSERT INTO frasbl_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Il l'apportera au prêtre ; le prêtre en prendra une poignée comme portion commémorative, et il la brûlera sur l'autel, sur les offrandes consumées par le feu de Yahvé. C'est un sacrifice pour le péché. ");
INSERT INTO frasbl_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Le prêtre fera pour lui l'expiation du péché qu'il a commis à l'égard de l'une de ces choses, et il lui sera pardonné ; le reste appartiendra au prêtre, comme l'offrande de repas.'\" ");
INSERT INTO frasbl_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","L'Éternel parla à Moïse et dit : ");
INSERT INTO frasbl_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","« Si quelqu'un commet une faute et pèche involontairement à l'égard des choses saintes de l'Éternel, il apportera à l'Éternel son sacrifice de culpabilité : un bélier sans défaut du troupeau, selon votre estimation en sicles d'argent, selon le sicle du sanctuaire, pour le sacrifice de culpabilité. ");
INSERT INTO frasbl_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Il restituera ce qu'il a fait de mal par rapport à la chose sainte, il y ajoutera un cinquième et le donnera au prêtre ; le prêtre fera pour lui l'expiation avec le bélier du sacrifice de culpabilité, et il lui sera pardonné. ");
INSERT INTO frasbl_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","« Si quelqu'un commet un péché en faisant l'une des choses que l'Éternel a ordonné de ne pas faire, sans le savoir, il est néanmoins coupable, et il portera la peine de son iniquité. ");
INSERT INTO frasbl_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Il apportera au prêtre un bélier sans défaut du troupeau, selon votre estimation, en sacrifice de culpabilité ; le prêtre fera pour lui l'expiation de la faute qu'il a commise sans le savoir, et il lui sera pardonné. ");
INSERT INTO frasbl_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","C'est un sacrifice de culpabilité. Il est certainement coupable devant Yahvé. » ");
INSERT INTO frasbl_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Yahvé parla à Moïse, et dit : ");
INSERT INTO frasbl_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","« Si quelqu'un pèche et commet une infidélité à l'égard de Yahvé, s'il traite faussement son prochain dans une affaire de dépôt, de marchandage ou de vol, s'il a opprimé son prochain, ");
INSERT INTO frasbl_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","s'il a retrouvé ce qui était perdu et a menti à son sujet, et a juré de mentir - dans l'une quelconque de ces choses, un homme pèche par ses actions - ");
INSERT INTO frasbl_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","alors, s'il a péché et s'il est coupable, il restituera ce qu'il a pris par vol, ou ce qu'il a obtenu par oppression, ou le dépôt qui lui a été confié, ou la chose perdue qu'il a trouvée, ");
INSERT INTO frasbl_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","ou toute chose sur laquelle il a juré faussement : il le restituera intégralement, et y ajoutera un cinquième de plus. Il la rendra à celui à qui elle appartient, le jour où il sera déclaré coupable. ");
INSERT INTO frasbl_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Il apportera son sacrifice de culpabilité à l'Éternel : un bélier sans défaut du troupeau, selon votre estimation, en sacrifice de culpabilité, au prêtre. ");
INSERT INTO frasbl_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Le prêtre fera pour lui l'expiation devant Yahvé, et il lui sera pardonné tout ce qu'il aura fait pour se rendre coupable. » ");
INSERT INTO frasbl_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Yahvé parla à Moïse, et dit : ");
INSERT INTO frasbl_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","« Donne cet ordre à Aaron et à ses fils : Voici la loi de l'holocauste : l'holocauste restera sur le foyer de l'autel toute la nuit jusqu'au matin, et le feu de l'autel restera allumé sur lui. ");
INSERT INTO frasbl_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Le prêtre revêtira son vêtement de lin, et il mettra sur son corps son pantalon de lin ; il enlèvera la cendre de l'endroit où le feu a consumé l'holocauste sur l'autel, et il la mettra à côté de l'autel. ");
INSERT INTO frasbl_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Il ôtera ses vêtements, en mettra d'autres, et portera les cendres hors du camp, dans un lieu pur. ");
INSERT INTO frasbl_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Le feu restera allumé sur l'autel, il ne s'éteindra pas, et le prêtre y brûlera du bois chaque matin. Il y déposera l'holocauste en ordre, et il y brûlera la graisse des sacrifices de prospérité. ");
INSERT INTO frasbl_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Le feu brûlera continuellement sur l'autel ; il ne s'éteindra pas. ");
INSERT INTO frasbl_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","\"'Voici la loi de l'offrande de gâteau : les fils d'Aaron l'offriront devant l'Éternel, devant l'autel. ");
INSERT INTO frasbl_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Il prendra là une poignée de la fleur de farine de l'offrande, de son huile et de tout l'encens qui est sur l'offrande, et il la brûlera sur l'autel, en guise d'odeur agréable, comme sa portion commémorative, devant l'Éternel. ");
INSERT INTO frasbl_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Ce qui en restera, Aaron et ses fils le mangeront. On le mangera sans levure, dans un lieu saint. Ils le mangeront dans le parvis de la tente d'assignation. ");
INSERT INTO frasbl_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Il ne sera pas cuit au four avec de la levure. Je le leur ai donné comme part de mes offrandes consumées par le feu. Il est très saint, comme le sacrifice pour le péché et le sacrifice de culpabilité. ");
INSERT INTO frasbl_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Tout mâle parmi les enfants d'Aaron en mangera, c'est la part qui lui reviendra de génération en génération, parmi les offrandes consumées par le feu de l'Éternel. Quiconque les touchera sera saint. »\" ");
INSERT INTO frasbl_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","L'Éternel parla à Moïse, et dit : ");
INSERT INTO frasbl_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","Voici l'offrande qu'Aaron et ses fils présenteront à l'Éternel le jour où il sera oint : un dixième d'épha de fleur de farine, en offrande perpétuelle, une moitié le matin et une moitié le soir. ");
INSERT INTO frasbl_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","On la fera cuire à l'huile dans une poêle. Lorsqu'elle sera trempée, tu l'apporteras. Tu offriras l'offrande de repas en morceaux cuits, comme une odeur agréable à Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Le prêtre oint qui sera à sa place, parmi ses fils, l'offrira. C'est une loi perpétuelle : elle sera entièrement consumée devant l'Éternel. ");
INSERT INTO frasbl_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Toute offrande de repas d'un prêtre sera entièrement brûlée. On ne la mangera pas. » ");
INSERT INTO frasbl_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Yahvé parla à Moïse et dit : ");
INSERT INTO frasbl_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","Parle à Aaron et à ses fils, et dis : « Voici la loi du sacrifice pour le péché : dans le lieu où l'on égorge l'holocauste, on égorgera le sacrifice pour le péché devant Yahvé. Elle est très sainte. ");
INSERT INTO frasbl_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Le prêtre qui l'offrira pour le péché la mangera. Il la mangera dans un lieu saint, dans le parvis de la tente d'assignation. ");
INSERT INTO frasbl_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Tout ce qui touchera sa chair sera saint. Si un vêtement est aspergé de son sang, vous laverez celui sur lequel il a été aspergé dans un lieu saint. ");
INSERT INTO frasbl_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Mais le vase de terre dans lequel on l'aura fait bouillir sera brisé ; et si on l'a fait bouillir dans un vase de bronze, on le récurera et on le rincera à l'eau. ");
INSERT INTO frasbl_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Tout mâle parmi les prêtres en mangera. C'est une chose très sainte. ");
INSERT INTO frasbl_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","On ne mangera pas le sacrifice pour le péché dont on a apporté une partie du sang dans la tente d'assignation pour faire l'expiation dans le lieu saint. Il sera brûlé au feu. ");
INSERT INTO frasbl_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","\"'Voici la loi du sacrifice de culpabilité : Elle est très sainte. ");
INSERT INTO frasbl_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Dans le lieu où l'on égorge l'holocauste, on égorgera le sacrifice de culpabilité ; on en répandra le sang tout autour de l'autel. ");
INSERT INTO frasbl_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Il offrira toute la graisse : la queue, la graisse qui recouvre les entrailles, ");
INSERT INTO frasbl_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","et il enlèvera les deux rognons, la graisse qui les recouvre, qui est près des reins, et la couverture du foie, avec les rognons ; ");
INSERT INTO frasbl_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","et le sacrificateur les brûlera sur l'autel, comme offrande consumée par le feu à l'Éternel : c'est un sacrifice de culpabilité. ");
INSERT INTO frasbl_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Tout mâle parmi les prêtres pourra en manger. On le mangera dans un lieu saint. C'est un lieu très saint. ");
INSERT INTO frasbl_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","\"'Comme le sacrifice pour le péché, le sacrifice pour le délit, il y a une seule loi pour eux. Le prêtre qui fera l'expiation pour eux l'aura. ");
INSERT INTO frasbl_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Le prêtre qui offre l'holocauste de quelqu'un aura pour lui la peau de l'holocauste qu'il a offert. ");
INSERT INTO frasbl_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Toute offrande de farine qui est cuite au four, et tout ce qui est préparé dans la poêle et sur la plaque, appartiendra au prêtre qui l'offre. ");
INSERT INTO frasbl_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Toute offrande de farine, mélangée à de l'huile ou sèche, appartient à tous les fils d'Aaron, les uns comme les autres. ");
INSERT INTO frasbl_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","\"'Voici la loi du sacrifice d'actions de grâces que l'on offrira à l'Éternel : ");
INSERT INTO frasbl_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","S'il l'offre pour une action de grâces, il offrira avec le sacrifice d'action de grâces des gâteaux sans levain pétris d'huile, des galettes sans levain ointes d'huile et des gâteaux pétris d'huile. ");
INSERT INTO frasbl_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Il offrira, avec le sacrifice d'action de grâces, des gâteaux de pain levé. ");
INSERT INTO frasbl_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Il en offrira un sur chaque offrande, comme offrande par élévation à l'Éternel. Elle appartiendra au sacrificateur qui aspergera le sang des sacrifices de prospérité. ");
INSERT INTO frasbl_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Il mangera la chair du sacrifice d'actions de grâces le jour de son offrande. Il n'en laissera rien jusqu'au matin. ");
INSERT INTO frasbl_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","\"'Mais si le sacrifice de son offrande est un vœu, ou une offrande libre, il sera mangé le jour où il offre son sacrifice. Le lendemain, ce qui en restera sera mangé, ");
INSERT INTO frasbl_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","mais ce qui restera de la viande du sacrifice le troisième jour sera brûlé au feu. ");
INSERT INTO frasbl_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Si une partie de la viande du sacrifice d'actions de grâces est mangée le troisième jour, elle ne sera pas agréée et ne sera pas créditée à celui qui l'offre. Ce sera une abomination, et celui qui en mangera portera la peine de son iniquité. ");
INSERT INTO frasbl_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","\"'On ne mangera pas la viande qui aura touché une chose impure. Elle sera brûlée au feu. Quiconque est pur pourra manger de la viande ; ");
INSERT INTO frasbl_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","mais l'âme qui mangera de la viande du sacrifice d'actions de grâces qui appartient à l'Éternel, en ayant sur elle son impureté, cette âme-là sera retranchée de son peuple. ");
INSERT INTO frasbl_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Si quelqu'un touche une chose impure, une souillure humaine, un animal impur ou une abomination impure, et qu'il mange de la viande du sacrifice de paix qui appartient à Yahvé, cette âme sera retranchée de son peuple.'\" ");
INSERT INTO frasbl_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Yahvé parla à Moïse et dit : ");
INSERT INTO frasbl_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","Parle aux enfants d'Israël et dis-leur : « Vous ne mangerez pas de graisse de taureau, de mouton ou de chèvre. ");
INSERT INTO frasbl_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","La graisse de ce qui meurt de lui-même, et la graisse de ce qui est déchiré des animaux, peuvent être utilisées pour un autre service, mais vous n'en mangerez en aucune façon. ");
INSERT INTO frasbl_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Car quiconque mangera la graisse de l'animal que les hommes offrent en sacrifice consumé par le feu à l'Éternel, l'âme qui en mangera sera retranchée de son peuple. ");
INSERT INTO frasbl_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Vous ne mangerez pas de sang, qu'il s'agisse d'oiseaux ou d'animaux, dans aucune de vos habitations. ");
INSERT INTO frasbl_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Toute personne qui mangera du sang sera retranchée de son peuple.'\" ");
INSERT INTO frasbl_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Yahvé parla à Moïse et dit : ");
INSERT INTO frasbl_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","Parle aux enfants d'Israël et dis-leur : « Celui qui offre à Yahvé le sacrifice de son action de grâces apportera son offrande à Yahvé sur le sacrifice de son action de grâces. ");
INSERT INTO frasbl_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Il apportera de ses propres mains les offrandes de Yahvé faites par le feu. Il apportera la graisse avec la poitrine, afin que la poitrine soit agitée en sacrifice d'agitation devant l'Éternel. ");
INSERT INTO frasbl_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Le prêtre brûlera la graisse sur l'autel, mais la poitrine appartiendra à Aaron et à ses fils. ");
INSERT INTO frasbl_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Tu donneras au sacrificateur la cuisse droite, comme offrande par élévation, sur les sacrifices d'actions de grâces que tu offriras. ");
INSERT INTO frasbl_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Celui des fils d'Aaron qui offrira le sang des sacrifices de prospérité et la graisse aura la cuisse droite pour sa part. ");
INSERT INTO frasbl_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Car la poitrine ondulée et la cuisse levée, je les ai prises aux enfants d'Israël sur les sacrifices de leurs actions de grâces, et je les ai données au prêtre Aaron et à ses fils comme leur part pour toujours, de la part des enfants d'Israël.'\" ");
INSERT INTO frasbl_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Voici la part consacrée d'Aaron et de ses fils, sur les offrandes consumées par le feu devant l'Éternel, le jour où il les présenta au service de l'Éternel dans le sacerdoce, ");
INSERT INTO frasbl_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","et que l'Éternel ordonna de leur donner parmi les enfants d'Israël, le jour où il les oignit. C'est leur part pour toujours, de génération en génération. ");
INSERT INTO frasbl_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Telle est la loi de l'holocauste, de l'offrande, du sacrifice pour le péché, du sacrifice de culpabilité, de la consécration et du sacrifice d'actions de grâces ");
INSERT INTO frasbl_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","que l'Éternel prescrivit à Moïse sur la montagne de Sinaï, le jour où il ordonna aux enfants d'Israël de présenter leurs offrandes à l'Éternel, dans le désert de Sinaï. ");
INSERT INTO frasbl_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Yahvé parla à Moïse, et dit : ");
INSERT INTO frasbl_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","« Prends avec lui Aaron et ses fils, les vêtements, l'huile d'onction, le taureau expiatoire, les deux béliers et la corbeille de pains sans levain, ");
INSERT INTO frasbl_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","et rassemble toute l'assemblée à l'entrée de la tente de la Rencontre. » ");
INSERT INTO frasbl_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Moïse fit ce que Yahvé lui avait ordonné ; et l'assemblée se rassembla à l'entrée de la tente de la Rencontre. ");
INSERT INTO frasbl_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Moïse dit à l'assemblée : « Voici ce que l'Éternel a ordonné de faire. » ");
INSERT INTO frasbl_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Moïse fit venir Aaron et ses fils, et les lava avec de l'eau. ");
INSERT INTO frasbl_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Il lui mit la tunique, lui attacha la ceinture, le revêtit de la robe, lui mit l'éphod, et il attacha sur lui la bande de l'éphod, habilement tissée, et la lui fixa avec elle. ");
INSERT INTO frasbl_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Il plaça sur lui le pectoral. Il mit l'urim et le thummim dans le pectoral. ");
INSERT INTO frasbl_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Il mit le turban sur sa tête. Il plaça la plaque d'or, la couronne sacrée, sur le devant du turban, comme l'avait ordonné l'Éternel à Moïse. ");
INSERT INTO frasbl_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Moïse prit l'huile d'onction, oignit le tabernacle et tout ce qui s'y trouvait, et les sanctifia. ");
INSERT INTO frasbl_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Il en fit sept fois l'aspersion sur l'autel, et il oignit l'autel et tous ses ustensiles, ainsi que le bassin et sa base, pour les sanctifier. ");
INSERT INTO frasbl_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Il versa de l'huile d'onction sur la tête d'Aaron et l'oignit, afin de le sanctifier. ");
INSERT INTO frasbl_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Moïse fit venir les fils d'Aaron, les revêtit de tuniques, leur attacha des ceintures et leur mit des bandeaux, comme Yahvé l'avait ordonné à Moïse. ");
INSERT INTO frasbl_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Il amena le taureau du sacrifice pour le péché, et Aaron et ses fils posèrent leurs mains sur la tête du taureau du sacrifice pour le péché. ");
INSERT INTO frasbl_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Il l'égorgea ; Moïse prit le sang et le mit avec son doigt autour des cornes de l'autel ; il purifia l'autel, versa le sang au pied de l'autel et le sanctifia pour en faire l'expiation. ");
INSERT INTO frasbl_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Il prit toute la graisse qui était sur les entrailles, la couverture du foie, les deux rognons et leur graisse, et Moïse les brûla sur l'autel. ");
INSERT INTO frasbl_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Mais le taureau, sa peau, sa viande et ses excréments, il les brûla au feu en dehors du camp, comme Yahvé l'avait ordonné à Moïse. ");
INSERT INTO frasbl_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Il présenta le bélier de l'holocauste. Aaron et ses fils posèrent leurs mains sur la tête du bélier. ");
INSERT INTO frasbl_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Il l'égorgea et Moïse fit aspersion du sang tout autour de l'autel. ");
INSERT INTO frasbl_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Il coupa le bélier en morceaux, et Moïse brûla la tête, les morceaux et la graisse. ");
INSERT INTO frasbl_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Il lava à l'eau les entrailles et les jambes, et Moïse brûla le bélier tout entier sur l'autel. C'était un holocauste pour un parfum agréable. C'était un sacrifice consumé par le feu à Yahvé, comme Yahvé l'avait ordonné à Moïse. ");
INSERT INTO frasbl_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Il présenta l'autre bélier, le bélier de consécration. Aaron et ses fils posèrent leurs mains sur la tête du bélier. ");
INSERT INTO frasbl_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Il l'égorgea ; Moïse prit un peu de son sang et en mit sur le bout de l'oreille droite d'Aaron, sur le pouce de sa main droite et sur le gros orteil de son pied droit. ");
INSERT INTO frasbl_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Il fit venir les fils d'Aaron ; Moïse mit un peu de sang sur le bout de leur oreille droite, sur le pouce de leur main droite et sur le gros orteil de leur pied droit ; Moïse fit asperger le sang tout autour de l'autel. ");
INSERT INTO frasbl_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Il prit la graisse, la queue, toute la graisse qui était sur les entrailles, la couverture du foie, les deux rognons et leur graisse, et la cuisse droite ; ");
INSERT INTO frasbl_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","et dans la corbeille de pains sans levain qui était devant l'Éternel, il prit un gâteau sans levain, un gâteau de pain huilé et une galette, et les plaça sur la graisse et sur la cuisse droite. ");
INSERT INTO frasbl_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Il mit tout cela dans les mains d'Aaron et dans les mains de ses fils, et il les agita comme une offrande par agitation devant l'Éternel. ");
INSERT INTO frasbl_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Moïse les prit de leurs mains et les brûla sur l'autel, sur l'holocauste. Elles constituaient une offrande de consécration pour un parfum agréable. C'était une offrande faite par le feu à Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Moïse prit la poitrine et l'agita comme une offrande par agitation devant Yahvé. C'était la part de Moïse du bélier de consécration, comme Yahvé l'avait ordonné à Moïse. ");
INSERT INTO frasbl_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Moïse prit de l'huile d'onction et du sang qui était sur l'autel ; il en fit l'aspersion sur Aaron, sur ses vêtements, sur ses fils et sur les vêtements de ses fils avec lui, et il sanctifia Aaron, ses vêtements, ses fils et les vêtements de ses fils avec lui. ");
INSERT INTO frasbl_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Moïse dit à Aaron et à ses fils : « Faites bouillir la viande à l'entrée de la tente de la Rencontre, et là, mangez-la, ainsi que le pain qui est dans la corbeille de consécration, comme je l'ai ordonné, en disant : « Aaron et ses fils la mangeront ». ");
INSERT INTO frasbl_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Ce qui restera de la viande et du pain, vous le brûlerez au feu. ");
INSERT INTO frasbl_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Tu ne sortiras pas de l'entrée de la Tente d'assignation pendant sept jours, jusqu'à ce que les jours de ta consécration soient accomplis, car il te consacrera sept jours. ");
INSERT INTO frasbl_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Ce qui a été fait aujourd'hui, Yahvé a ordonné de le faire, afin de faire l'expiation pour vous. ");
INSERT INTO frasbl_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Tu resteras jour et nuit à l'entrée de la Tente de la Rencontre, pendant sept jours, et tu observeras l'ordre de l'Éternel, afin que tu ne meures pas ; car c'est ainsi qu'on me l'ordonne. » ");
INSERT INTO frasbl_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Aaron et ses fils firent tout ce que l'Éternel avait ordonné par Moïse. ");
INSERT INTO frasbl_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Le huitième jour, Moïse appela Aaron, ses fils et les anciens d'Israël. ");
INSERT INTO frasbl_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Il dit à Aaron : « Prends un veau du troupeau pour le sacrifice pour le péché, et un bélier pour l'holocauste, sans défaut, et offre-les devant Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Tu parleras aux enfants d'Israël et tu diras : « Prenez un bouc pour le sacrifice pour le péché, un veau et un agneau d'un an sans défaut pour l'holocauste, ");
INSERT INTO frasbl_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","un taureau et un bélier pour le sacrifice d'actions de grâces, que vous offrirez devant Yahvé, et une offrande de farine mélangée d'huile, car aujourd'hui Yahvé vous apparaît ». ");
INSERT INTO frasbl_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Ils apportèrent devant la tente de la Rencontre ce que Moïse avait ordonné. Toute l'assemblée s'approcha et se tint debout devant l'Éternel. ");
INSERT INTO frasbl_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Moïse dit : « Voici ce que l'Éternel vous a ordonné de faire, et la gloire de l'Éternel vous apparaîtra. » ");
INSERT INTO frasbl_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Moïse dit à Aaron : « Approche-toi de l'autel, offre ton sacrifice pour le péché et ton holocauste, et fais l'expiation pour toi et pour le peuple ; offre l'offrande du peuple et fais l'expiation pour lui, comme Yahvé l'a ordonné. » ");
INSERT INTO frasbl_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Aaron s'approcha de l'autel et tua le veau du sacrifice pour le péché, qui était pour lui. ");
INSERT INTO frasbl_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Les fils d'Aaron lui présentèrent le sang ; il trempa son doigt dans le sang, le mit sur les cornes de l'autel et versa le sang au pied de l'autel. ");
INSERT INTO frasbl_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Mais il brûla sur l'autel la graisse, les rognons et la couverture du foie du sacrifice pour le péché, comme Yahvé l'avait ordonné à Moïse. ");
INSERT INTO frasbl_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Il brûla au feu la viande et la peau en dehors du camp. ");
INSERT INTO frasbl_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Il égorgea l'holocauste ; les fils d'Aaron lui remirent le sang, et il l'aspergea tout autour de l'autel. ");
INSERT INTO frasbl_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Ils lui remirent l'holocauste, morceau par morceau, et la tête. Il les brûla sur l'autel. ");
INSERT INTO frasbl_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Il lava les entrailles et les jambes, et les brûla sur l'autel, avec l'holocauste. ");
INSERT INTO frasbl_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Il présenta l'offrande du peuple ; il prit le bouc du sacrifice pour le péché qui était pour le peuple, il l'égorgea et l'offrit pour le péché, comme le premier. ");
INSERT INTO frasbl_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Il présenta l'holocauste et l'offrit selon l'ordonnance. ");
INSERT INTO frasbl_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Il présenta l'offrande de gâteau, dont il remplit sa main, et il la brûla sur l'autel, en plus de l'holocauste du matin. ");
INSERT INTO frasbl_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Il égorgea aussi le taureau et le bélier, le sacrifice d'actions de grâces, qui était pour le peuple. Les fils d'Aaron lui remirent le sang, qu'il répandit tout autour de l'autel ; ");
INSERT INTO frasbl_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","et la graisse du taureau et du bélier, la queue grasse, ce qui recouvre les entrailles, les rognons et ce qui recouvre le foie ; ");
INSERT INTO frasbl_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","ils mirent la graisse sur les poitrines, et il brûla la graisse sur l'autel. ");
INSERT INTO frasbl_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Aaron agita les poitrines et la cuisse droite en offrande par élévation devant Yahvé, comme Moïse l'avait ordonné. ");
INSERT INTO frasbl_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Aaron leva les mains vers le peuple et le bénit ; puis il descendit de l'offrande pour le péché, de l'holocauste et du sacrifice d'actions de grâces. ");
INSERT INTO frasbl_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Moïse et Aaron entrèrent dans la tente de la Rencontre, en sortirent et bénirent le peuple ; et la gloire de l'Éternel apparut à tout le peuple. ");
INSERT INTO frasbl_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Le feu sortit de devant Yahvé et consuma l'holocauste et la graisse sur l'autel. Quand tout le peuple vit cela, il poussa des cris et tomba sur sa face. ");
INSERT INTO frasbl_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Nadab et Abihu, fils d'Aaron, prirent chacun leur brasier, y mirent du feu, y déposèrent du parfum, et offrirent devant l'Éternel un feu étranger qu'il ne leur avait pas ordonné. ");
INSERT INTO frasbl_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Le feu sortit de devant l'Éternel, les dévora, et ils moururent devant l'Éternel. ");
INSERT INTO frasbl_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Moïse dit alors à Aaron : « C'est ce dont Yahvé a parlé, en disant, Je me montrerai saint pour ceux qui s'approchent de moi, et devant tout le peuple, je serai glorifié. » Aaron se tut. ");
INSERT INTO frasbl_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Moïse appela Mischaël et Elzaphan, fils d'Uzziel, oncle d'Aaron, et leur dit : « Approchez, portez hors du camp vos frères qui sont devant le sanctuaire. » ");
INSERT INTO frasbl_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Ils s'approchèrent donc et les transportèrent dans leurs tuniques hors du camp, comme Moïse l'avait dit. ");
INSERT INTO frasbl_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Moïse dit à Aaron, à Eléazar et à Ithamar, ses fils : « Ne laissez pas tomber les cheveux de vos têtes et ne déchirez pas vos vêtements, afin que vous ne mouriez pas et qu'il ne s'irrite pas contre toute l'assemblée ; mais que vos frères, toute la maison d'Israël, se lamentent sur le feu que Yahvé a allumé. ");
INSERT INTO frasbl_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Tu ne sortiras pas de l'entrée de la tente de la Rencontre, de peur de mourir, car l'huile d'onction de l'Éternel est sur toi. » Ils firent selon la parole de Moïse. ");
INSERT INTO frasbl_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Puis Yahvé dit à Aaron : ");
INSERT INTO frasbl_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","« Toi et tes fils, vous ne boirez ni vin ni boisson forte chaque fois que vous entrerez dans la Tente de la Rencontre, sinon vous mourrez. Ceci sera une loi pour toujours, de génération en génération. ");
INSERT INTO frasbl_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Tu feras la distinction entre ce qui est saint et ce qui est commun, entre ce qui est impur et ce qui est pur. ");
INSERT INTO frasbl_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Tu enseigneras aux enfants d'Israël toutes les lois que l'Éternel leur a dites par Moïse. » ");
INSERT INTO frasbl_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Moïse parla à Aaron, à Éléazar et à Ithamar, ses fils qui étaient restés : Prenez l'offrande qui reste des sacrifices consumés par le feu devant l'Éternel, et mangez-la sans levure à côté de l'autel, car elle est très sainte. ");
INSERT INTO frasbl_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Vous la mangerez dans un lieu saint, car c'est votre part et la part de vos fils des sacrifices consumés par le feu devant l'Éternel ; c'est ce que je vous ordonne. ");
INSERT INTO frasbl_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Vous mangerez la poitrine ondulée et la cuisse levée dans un lieu pur, toi, tes fils et tes filles avec toi, car elles sont données comme votre part et la part de vos fils, dans les sacrifices d'actions de grâces des enfants d'Israël. ");
INSERT INTO frasbl_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Ils apporteront la cuisse levée et la poitrine agitée, avec les offrandes consumées par le feu de la graisse, pour l'agiter en sacrifice par élévation devant l'Éternel. Ce sera votre part, et celle de vos fils avec vous, comme une part pour toujours, comme Yahvé l'a ordonné. » ");
INSERT INTO frasbl_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Moïse s'enquit du bouc du sacrifice pour le péché, et voici qu'il était brûlé. Moïse se mit en colère contre Éléazar et Ithamar, les fils d'Aaron qui restaient, et dit : ");
INSERT INTO frasbl_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","« Pourquoi n'avez-vous pas mangé le sacrifice pour le péché dans le lieu du sanctuaire, puisqu'il est très saint et qu'il vous a été donné de porter l'iniquité de l'assemblée, afin de faire l'expiation pour elle devant Yahvé ? ");
INSERT INTO frasbl_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Voici, son sang n'a pas été apporté dans l'intérieur du sanctuaire. Vous auriez certainement dû le manger dans le sanctuaire, comme je l'ai ordonné. » ");
INSERT INTO frasbl_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Aaron dit à Moïse : « Voici, ils ont offert aujourd'hui leur sacrifice pour le péché et leur holocauste devant l'Éternel, et il m'est arrivé des choses comme celles-là. Si j'avais mangé aujourd'hui le sacrifice pour le péché, cela aurait-il été agréable aux yeux de Yahvé ? ». ");
INSERT INTO frasbl_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Lorsque Moïse entendit cela, cela lui plut. ");
INSERT INTO frasbl_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Yahvé parla à Moïse et à Aaron, et leur dit : ");
INSERT INTO frasbl_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","Parlez aux enfants d'Israël, et dites : Voici les animaux que vous pourrez manger parmi tous les animaux qui sont sur la terre. ");
INSERT INTO frasbl_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Tout ce qui a le sabot fendu, le pied fourchu, et qui rumine parmi les animaux, vous pourrez le manger. ");
INSERT INTO frasbl_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","\"'Cependant, vous ne mangerez pas de ceux qui ruminent, ni de ceux qui ont le sabot fendu : le chameau, parce qu'il rumine mais n'a pas le sabot fendu, est impur pour vous. ");
INSERT INTO frasbl_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","L'hyrax, parce qu'il rumine mais n'a pas le sabot fendu, vous est impur. ");
INSERT INTO frasbl_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Le lièvre, parce qu'il rumine mais n'a pas le sabot fendu, est impur pour vous. ");
INSERT INTO frasbl_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Vous souillez le porc, parce qu'il a le sabot fendu, qu'il a le pied fourchu, mais qu'il ne rumine pas. ");
INSERT INTO frasbl_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Vous ne mangerez pas de leur viande. Vous ne toucherez pas leurs carcasses. Ils sont impurs pour vous. ");
INSERT INTO frasbl_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","\"'Tu pourras manger de tout ce qui est dans les eaux : tout ce qui a des nageoires et des écailles dans les eaux, dans les mers et dans les fleuves, tu pourras en manger. ");
INSERT INTO frasbl_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Tout ce qui n'a pas de nageoires et d'écailles dans les mers et les fleuves, tout ce qui se déplace dans les eaux, et tous les êtres vivants qui sont dans les eaux, sont pour toi une abomination, ");
INSERT INTO frasbl_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","et tu les détesteras. Tu ne mangeras pas de leur viande et tu détesteras leurs carcasses. ");
INSERT INTO frasbl_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Tout ce qui n'a ni nageoires ni écailles dans les eaux est pour vous une abomination. ");
INSERT INTO frasbl_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","\"'Tu détesteras ces oiseaux parmi les oiseaux ; on ne les mangera pas car ils sont en abomination : l'aigle, le vautour, le vautour noir, ");
INSERT INTO frasbl_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","le milan royal, toute espèce de milan noir, ");
INSERT INTO frasbl_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","toute espèce de corbeau, ");
INSERT INTO frasbl_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","le hibou des marais, le petit duc, la mouette, toute espèce de faucon, ");
INSERT INTO frasbl_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","la chouette chevêche, le cormoran, la chouette chevêche, ");
INSERT INTO frasbl_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","la chouette blanche, la chouette du désert, le balbuzard pêcheur, ");
INSERT INTO frasbl_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","la cigogne, toute espèce de héron, la huppe et la chauve-souris. ");
INSERT INTO frasbl_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","\"'Tous les insectes volants qui marchent à quatre pattes sont pour vous une abomination. ");
INSERT INTO frasbl_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Mais vous pouvez manger de tous les reptiles ailés qui marchent à quatre pattes et qui ont de longues pattes articulées pour sauter sur la terre. ");
INSERT INTO frasbl_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Vous pourrez même en manger : toute espèce de sauterelle, toute espèce de katydide, toute espèce de criquet et toute espèce de sauterelle. ");
INSERT INTO frasbl_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Mais tous les reptiles ailés qui ont quatre pieds sont pour vous une abomination. ");
INSERT INTO frasbl_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","\"'Par eux, vous deviendrez impurs : quiconque touchera leur carcasse sera impur jusqu'au soir. ");
INSERT INTO frasbl_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Celui qui portera une partie de leur carcasse lavera ses vêtements et sera impur jusqu'au soir. ");
INSERT INTO frasbl_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","\"'Tout animal qui a un sabot fendu qui n'est pas complètement divisé, ou qui ne rumine pas, est impur pour vous. Tous ceux qui les toucheront seront impurs. ");
INSERT INTO frasbl_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Tout ce qui se déplace sur ses pattes, parmi tous les animaux qui se déplacent à quatre pattes, vous est impur. Quiconque touchera leur carcasse sera impur jusqu'au soir. ");
INSERT INTO frasbl_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Celui qui portera leur cadavre lavera ses vêtements et sera impur jusqu'au soir. Ils sont impurs pour vous. ");
INSERT INTO frasbl_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","\"'Voici ceux qui vous sont impurs parmi les reptiles qui rampent sur la terre : la belette, le rat, toute espèce de grand lézard, ");
INSERT INTO frasbl_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","le gecko, le varan, le lézard des murailles, le scinque et le caméléon. ");
INSERT INTO frasbl_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Voici ceux qui sont impurs pour vous parmi tous les reptiles. Celui qui les touchera quand ils seront morts sera impur jusqu'au soir. ");
INSERT INTO frasbl_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Tout ce sur quoi ils tomberont après leur mort sera impur ; que ce soit un vase de bois, un vêtement, une peau, un sac, quel que soit le vase avec lequel on travaille, il faudra le mettre dans l'eau et il sera impur jusqu'au soir. Ensuite, il sera pur. ");
INSERT INTO frasbl_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Tout vase de terre dans lequel tombera l'un d'eux, et tout ce qu'il contient, sera impur. Vous le briserez. ");
INSERT INTO frasbl_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Tout aliment que l'on pourra manger et qui aura été trempé dans l'eau sera impur. Toute boisson que l'on pourra boire dans un tel récipient sera impure. ");
INSERT INTO frasbl_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Tout ce sur quoi tombera une partie de leur carcasse sera impur ; qu'il s'agisse d'un four ou d'une marmite, on le brisera en morceaux. Ils sont impurs, et vous les rendrez impurs. ");
INSERT INTO frasbl_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Toutefois, une source ou une citerne dans laquelle on recueille de l'eau sera pure, mais ce qui touchera leur cadavre sera impur. ");
INSERT INTO frasbl_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Si une partie de leur carcasse tombe sur une graine destinée à être semée, elle sera pure. ");
INSERT INTO frasbl_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Mais si l'on met de l'eau sur la semence, et qu'une partie de leur carcasse tombe dessus, vous la trouverez impure. ");
INSERT INTO frasbl_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","\"'Si un animal dont vous pouvez manger meurt, celui qui touchera sa carcasse sera impur jusqu'au soir. ");
INSERT INTO frasbl_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Celui qui mangera de sa carcasse lavera ses vêtements et sera impur jusqu'au soir. Celui qui portera son cadavre lavera ses vêtements et sera impur jusqu'au soir. ");
INSERT INTO frasbl_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","\"'Tout reptile qui rampe sur la terre est une abomination. On n'en mangera pas. ");
INSERT INTO frasbl_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Tout ce qui se déplace sur le ventre, tout ce qui se déplace à quatre pattes, tout ce qui a plusieurs pieds, tous les reptiles qui rampent sur la terre, vous ne les mangerez pas, car ils sont en abomination. ");
INSERT INTO frasbl_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Vous ne vous rendrez pas abominables avec les reptiles qui rampent. Vous ne vous rendrez pas impurs avec eux, au point de vous souiller par eux. ");
INSERT INTO frasbl_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Car je suis Yahvé, votre Dieu. Sanctifiez-vous donc et soyez saints, car je suis saint. Vous ne vous souillerez d'aucune espèce de reptile qui se déplace sur la terre. ");
INSERT INTO frasbl_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Car je suis Yahvé, qui vous ai fait monter du pays d'Égypte, pour être votre Dieu. Vous serez donc saints, car je suis saint. ");
INSERT INTO frasbl_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","\"'C'est la loi de l'animal, de l'oiseau, de tout être vivant qui se meut dans les eaux, et de tout être vivant qui rampe sur la terre, ");
INSERT INTO frasbl_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","pour distinguer entre ce qui est impur et ce qui est pur, et entre ce qui peut être mangé et ce qui ne peut pas l'être.'\" ");
INSERT INTO frasbl_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Yahvé parla à Moïse, et dit : ");
INSERT INTO frasbl_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","Parle aux enfants d'Israël, et dis : Si une femme est enceinte et qu'elle porte un enfant mâle, elle sera impure pendant sept jours, comme elle l'est pendant les jours de ses règles. ");
INSERT INTO frasbl_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Le huitième jour, la chair de son prépuce sera circoncise. ");
INSERT INTO frasbl_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Elle restera dans le sang de purification pendant trente-trois jours. Elle ne touchera aucune chose sainte, et n'entrera pas dans le sanctuaire, jusqu'à ce que les jours de sa purification soient accomplis. ");
INSERT INTO frasbl_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Mais si elle porte un enfant de sexe féminin, elle sera impure pendant deux semaines, comme pendant ses règles ; et elle restera dans le sang de purification pendant soixante-six jours. ");
INSERT INTO frasbl_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","\"'Lorsque les jours de sa purification seront accomplis pour un fils ou pour une fille, elle apportera au prêtre, à l'entrée de la tente d'assignation, un agneau d'un an en holocauste, et un jeune pigeon ou une tourterelle en sacrifice pour le péché. ");
INSERT INTO frasbl_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Il l'offrira devant Yahvé et fera pour elle l'expiation ; elle sera alors purifiée de la source de son sang. « Voici la loi pour celle qui enfante, qu'il s'agisse d'un mâle ou d'une femelle. ");
INSERT INTO frasbl_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Si elle n'a pas les moyens de se procurer un agneau, elle prendra deux tourterelles ou deux jeunes pigeons : l'un pour l'holocauste, l'autre pour le sacrifice pour le péché. Le prêtre fera pour elle l'expiation, et elle sera pure.'\" ");
INSERT INTO frasbl_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Yahvé parla à Moïse et à Aaron, et dit : ");
INSERT INTO frasbl_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","« Lorsqu'un homme aura une tuméfaction sur la peau de son corps, ou une croûte, ou une tache brillante, et que cela deviendra dans la peau de son corps la plaie de la lèpre, on l'amènera au prêtre Aaron ou à l'un de ses fils, les prêtres. ");
INSERT INTO frasbl_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Le prêtre examinera la plaie sur la peau du corps. Si le poil de la plaie est devenu blanc, et si l'aspect de la plaie est plus profond que la peau du corps, c'est la plaie de la lèpre ; le prêtre l'examinera donc et le déclarera impur. ");
INSERT INTO frasbl_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Si la tache brillante est blanche sur la peau de son corps, que son aspect n'est pas plus profond que la peau et que son poil n'est pas devenu blanc, le prêtre isolera la personne infectée pendant sept jours. ");
INSERT INTO frasbl_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Le prêtre l'examinera le septième jour. Si, à ses yeux, la plaie est arrêtée et que la plaie ne s'est pas propagée dans la peau, le prêtre l'isolera encore pendant sept jours. ");
INSERT INTO frasbl_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Le prêtre l'examinera de nouveau le septième jour. Voici, si la plaie a disparu et que la plaie ne s'est pas propagée dans la peau, alors le prêtre le déclarera pur. C'est une gale. Il lavera ses vêtements et sera pur. ");
INSERT INTO frasbl_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Mais si la gale s'étend sur la peau après qu'il s'est présenté au prêtre pour sa purification, il se présentera de nouveau au prêtre. ");
INSERT INTO frasbl_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Le prêtre l'examinera ; et voici, si la gale s'est étendue sur la peau, le prêtre le déclarera impur. C'est la lèpre. ");
INSERT INTO frasbl_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","« Lorsqu'un homme aura la plaie de la lèpre, on l'amènera au prêtre ; ");
INSERT INTO frasbl_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","et le prêtre l'examinera. S'il y a une tuméfaction blanche sur la peau, si le poil est devenu blanc et s'il y a de la chair à vif dans la tuméfaction, ");
INSERT INTO frasbl_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","c'est une lèpre chronique sur la peau de son corps, et le prêtre le déclarera impur. Il ne l'isolera pas, car il est déjà impur. ");
INSERT INTO frasbl_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","« Si la lèpre se déclare sur toute la peau, et si la lèpre couvre toute la peau de la personne infectée, depuis sa tête jusqu'à ses pieds, selon ce qui apparaît au prêtre, ");
INSERT INTO frasbl_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","alors le prêtre l'examinera. Voici, si la lèpre a couvert toute sa chair, il le déclarera pur de la plaie. Tout est devenu blanc : il est pur. ");
INSERT INTO frasbl_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Mais si de la chair crue apparaît en lui, il sera impur. ");
INSERT INTO frasbl_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Le prêtre examinera la chair crue et le déclarera impur : la chair crue est impure. C'est la lèpre. ");
INSERT INTO frasbl_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Ou bien, si la chair crue se transforme et devient blanche, il se présentera au sacrificateur. ");
INSERT INTO frasbl_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Le prêtre l'examinera. Si la plaie est devenue blanche, le prêtre le déclarera pur de la plaie. Il est pur. ");
INSERT INTO frasbl_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","« Lorsque le corps a un furoncle sur la peau, qu'il est guéri, ");
INSERT INTO frasbl_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","et qu'à la place du furoncle il y a une tuméfaction blanche, ou une tache brillante, d'un blanc rougeâtre, on le montrera au prêtre. ");
INSERT INTO frasbl_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Le prêtre l'examinera. Si son aspect est plus profond que la peau, et si son poil est devenu blanc, le prêtre le déclarera impur. C'est la plaie de la lèpre. Elle s'est déclarée dans le furoncle. ");
INSERT INTO frasbl_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Mais si le prêtre l'examine, et qu'il n'y ait pas de poils blancs, et que la plaie ne soit pas plus profonde que la peau, mais qu'elle soit pâle, le prêtre l'isolera pendant sept jours. ");
INSERT INTO frasbl_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Si elle se propage dans la peau, le prêtre la déclarera impure. C'est une plaie. ");
INSERT INTO frasbl_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Mais si la tache brillante reste à sa place, et ne s'est pas étendue, c'est la cicatrice de l'ulcère ; et le prêtre le déclarera pur. ");
INSERT INTO frasbl_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","« Ou lorsque le corps a sur la peau une brûlure par le feu, et que la chair crue de la brûlure devient une tache brillante, d'un blanc rougeâtre ou blanc, ");
INSERT INTO frasbl_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","le prêtre l'examinera ; et voici, si le poil de la tache brillante est devenu blanc, et si son aspect est plus profond que la peau, c'est la lèpre. Elle s'est déclarée chez le brûlé, et le prêtre le déclarera impur. C'est la plaie de la lèpre. ");
INSERT INTO frasbl_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Mais si le prêtre l'examine, et que voici, il n'y a pas de poil blanc dans la tache brillante, et qu'elle n'est pas plus profonde que la peau, mais qu'elle s'est effacée, alors le prêtre l'isolera sept jours. ");
INSERT INTO frasbl_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Le prêtre l'examinera le septième jour. Si la tache s'est étendue sur la peau, le prêtre le déclarera impur. C'est la plaie de la lèpre. ");
INSERT INTO frasbl_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Si la tache brillante reste à sa place, ne s'est pas étendue dans la peau, mais s'est estompée, c'est l'enflure de la brûlure, et le prêtre le déclarera pur, car c'est la cicatrice de la brûlure. ");
INSERT INTO frasbl_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","« Lorsqu'un homme ou une femme aura une plaie sur la tête ou sur la barbe, ");
INSERT INTO frasbl_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","le prêtre examinera la plaie ; et voici, si son aspect est plus profond que la peau, et que les poils qui la composent sont jaunes et fins, le prêtre le déclarera impur. C'est une démangeaison. C'est une lèpre de la tête ou de la barbe. ");
INSERT INTO frasbl_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Si le prêtre examine la plaie de démangeaison, et que son aspect n'est pas plus profond que la peau, et qu'il n'y a pas de poil noir, alors le prêtre isolera la personne atteinte de démangeaison pendant sept jours. ");
INSERT INTO frasbl_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Le septième jour, le prêtre examinera la plaie ; et voici, si la démangeaison ne s'est pas étendue, s'il n'y a pas de poil jaune et si l'aspect de la démangeaison n'est pas plus profond que la peau, ");
INSERT INTO frasbl_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","alors il sera rasé, mais il ne rasera pas la démangeaison. Ensuite, le prêtre isolera celui qui a la démangeaison pendant sept jours encore. ");
INSERT INTO frasbl_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Le septième jour, le prêtre examinera la démangeaison ; et voici, si la démangeaison ne s'est pas étendue dans la peau, et si son aspect n'est pas plus profond que la peau, alors le prêtre le déclarera pur. Il lavera ses vêtements et sera pur. ");
INSERT INTO frasbl_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Mais si la démangeaison s'étend sur la peau après sa purification, ");
INSERT INTO frasbl_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","le prêtre l'examinera ; et voici, si la démangeaison s'est étendue sur la peau, le prêtre ne cherchera pas le poil jaune : il est impur. ");
INSERT INTO frasbl_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Mais si, à ses yeux, la démangeaison est arrêtée et qu'un poil noir y a poussé, alors la démangeaison est guérie. Il est pur. Le prêtre le déclarera pur. ");
INSERT INTO frasbl_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","« Lorsqu'un homme ou une femme aura sur la peau de son corps des taches brillantes, d'un blanc éclatant, ");
INSERT INTO frasbl_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","le prêtre les examinera. Si les taches brillantes sur la peau de leur corps sont d'un blanc terne, c'est une éruption cutanée inoffensive. La peau a éclaté. Il est pur. ");
INSERT INTO frasbl_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","« Si les cheveux d'un homme sont tombés de sa tête, il est chauve. Il est pur. ");
INSERT INTO frasbl_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Si ses cheveux sont tombés de la partie antérieure de sa tête, il est chauve du front. Il est pur. ");
INSERT INTO frasbl_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Mais s'il y a une plaie d'un blanc rougeâtre dans la tête chauve ou sur le front chauve, c'est la lèpre qui éclate dans sa tête chauve ou sur son front chauve. ");
INSERT INTO frasbl_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Le prêtre l'examinera. Voici, si l'enflure de la plaie est d'un blanc rougeâtre dans sa tête chauve ou dans son front chauve, comme l'apparence de la lèpre sur la peau du corps, ");
INSERT INTO frasbl_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","c'est un homme lépreux. Il est impur. Le prêtre le déclarera impur. Sa plaie est sur sa tête. ");
INSERT INTO frasbl_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","« Le lépreux qui a la plaie portera des vêtements déchirés, et les cheveux de sa tête seront détachés. Il se couvrira la lèvre supérieure et criera : 'Impur ! Impur ! ");
INSERT INTO frasbl_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Pendant tout le temps que durera la plaie, il sera impur. Il est impur. Il habitera seul. Sa demeure sera en dehors du camp. ");
INSERT INTO frasbl_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Le vêtement dans lequel se trouve la plaie de la lèpre, soit un vêtement de laine ou un vêtement de lin, ");
INSERT INTO frasbl_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","soit un vêtement de chaîne ou de trame, de lin ou de laine, soit un vêtement de cuir ou un objet en cuir, ");
INSERT INTO frasbl_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","si la plaie est verdâtre ou rougeâtre dans le vêtement, dans le cuir, dans la chaîne ou la trame, ou dans un objet en cuir, c'est la plaie de la lèpre ; on la montrera au sacrificateur. ");
INSERT INTO frasbl_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Le prêtre examinera la plaie et l'isolera pendant sept jours. ");
INSERT INTO frasbl_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Le septième jour, il examinera la plaie. Si la plaie s'est étendue dans le vêtement, soit dans la chaîne, soit dans la trame, soit dans la peau, quel que soit l'usage auquel la peau est destinée, la plaie est une moisissure destructrice. Il est impur. ");
INSERT INTO frasbl_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Il brûlera le vêtement, qu'il s'agisse de la chaîne ou de la trame, de laine ou de lin, ou de tout ce qui est en cuir, dans lequel se trouve la plaie, car c'est une moisissure destructrice. Il le brûlera au feu. ");
INSERT INTO frasbl_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","« Si le prêtre l'examine et que la plaie ne s'est pas étendue dans le vêtement, ni dans la chaîne, ni dans la trame, ni dans aucune partie de la peau, ");
INSERT INTO frasbl_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","le prêtre ordonnera qu'on lave l'objet dans lequel se trouve la plaie, et il l'isolera encore sept jours. ");
INSERT INTO frasbl_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Puis le prêtre l'examinera, après que la plaie aura été lavée ; et voici, si la plaie n'a pas changé de couleur, et si la plaie ne s'est pas étendue, elle est impure ; vous la brûlerez au feu. C'est une tache de moisissure, que la plaie soit en dedans ou en dehors. ");
INSERT INTO frasbl_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Si le prêtre regarde, et que la plaie ait pâli après avoir été lavée, il l'arrachera du vêtement, ou de la peau, ou de la chaîne, ou de la trame ; ");
INSERT INTO frasbl_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","et si elle reparaît dans le vêtement, soit dans la chaîne, soit dans la trame, ou dans quoi que ce soit de peau, elle se propage. Vous brûlerez au feu ce qui contient la plaie. ");
INSERT INTO frasbl_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Le vêtement, soit la chaîne, soit la trame, soit tout ce qui est de peau, que vous laverez, si la plaie en est sortie, vous le laverez une seconde fois, et il sera pur. » ");
INSERT INTO frasbl_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Voici la loi concernant la plaie de la moisissure dans un vêtement de laine ou de lin, soit dans la chaîne, soit dans la trame, soit dans tout ce qui est en peau, pour le déclarer pur ou pour le déclarer impur. ");
INSERT INTO frasbl_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Yahvé parla à Moïse, et dit, ");
INSERT INTO frasbl_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","« Voici la loi du lépreux, le jour de sa purification : On l'amènera au sacrificateur, ");
INSERT INTO frasbl_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","et le sacrificateur sortira du camp. Le prêtre l'examinera. Si la plaie de la lèpre est guérie chez le lépreux, ");
INSERT INTO frasbl_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","le sacrificateur ordonnera de prendre pour celui qui doit être purifié deux oiseaux vivants et purs, du bois de cèdre, du cramoisi et de l'hysope. ");
INSERT INTO frasbl_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Le prêtre leur ordonnera de tuer l'un des oiseaux dans un vase de terre, au-dessus de l'eau courante. ");
INSERT INTO frasbl_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Il prendra l'oiseau vivant, le bois de cèdre, le cramoisi et l'hysope, et les trempera avec l'oiseau vivant dans le sang de l'oiseau tué au-dessus de l'eau courante. ");
INSERT INTO frasbl_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Il fera sept fois l'aspersion sur celui qui doit être purifié de la lèpre, et le déclarera pur, puis il laissera l'oiseau vivant aller en plein champ. ");
INSERT INTO frasbl_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","« Celui qui veut se purifier lavera ses vêtements, rasera tous ses cheveux et se baignera dans l'eau, et il sera pur. Après cela, il entrera dans le camp, mais il restera sept jours hors de sa tente. ");
INSERT INTO frasbl_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Le septième jour, il rasera tous les cheveux de sa tête, sa barbe et ses sourcils. Il rasera tous ses cheveux. Il lavera ses vêtements et se lavera le corps dans l'eau. Il sera alors pur. ");
INSERT INTO frasbl_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","« Le huitième jour, il prendra deux agneaux mâles sans défaut, une agnelle d'un an sans défaut, trois dixièmes d'un épha de fleur de farine pour l'offrande de farine, mélangée à de l'huile, et un log d'huile. ");
INSERT INTO frasbl_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Le prêtre qui l'aura purifié présentera l'homme à purifier et ces objets devant Yahvé, à l'entrée de la tente de la Rencontre. ");
INSERT INTO frasbl_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","« Le prêtre prendra l'un des agneaux mâles et l'offrira en sacrifice de culpabilité, avec le log d'huile, et il les agitera en signe d'offrande devant l'Éternel. ");
INSERT INTO frasbl_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Il égorgera l'agneau mâle dans le lieu où l'on égorge le sacrifice pour le péché et l'holocauste, dans le lieu du sanctuaire ; car si le sacrifice pour le péché appartient au prêtre, il en est de même du sacrifice de culpabilité. Elle est très sainte. ");
INSERT INTO frasbl_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Le prêtre prendra du sang du sacrifice de culpabilité, et il en mettra sur le bout de l'oreille droite de celui qui doit être purifié, sur le pouce de sa main droite et sur le gros orteil de son pied droit. ");
INSERT INTO frasbl_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Le prêtre prendra un peu de la bûche d'huile et la versera dans la paume de sa main gauche. ");
INSERT INTO frasbl_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Le prêtre trempera son doigt droit dans l'huile qui est dans sa main gauche, et il fera sept fois l'aspersion de l'huile avec son doigt devant Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Le prêtre mettra une partie du reste de l'huile qui est dans sa main sur le bout de l'oreille droite de celui qui doit être purifié, sur le pouce de sa main droite et sur le gros orteil de son pied droit, sur le sang du sacrifice de culpabilité. ");
INSERT INTO frasbl_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Le reste de l'huile qui est dans la main du prêtre, il en mettra sur la tête de celui qui doit être purifié, et le prêtre fera pour lui l'expiation devant Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","« Le prêtre offrira le sacrifice pour le péché et fera l'expiation pour celui qui doit être purifié à cause de sa souillure. Ensuite, il égorgera l'holocauste ; ");
INSERT INTO frasbl_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","puis le prêtre offrira l'holocauste et l'offrande sur l'autel. Le prêtre fera l'expiation pour lui, et il sera pur. ");
INSERT INTO frasbl_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","« S'il est pauvre et qu'il n'a pas les moyens d'en acheter autant, il prendra un agneau mâle en sacrifice de culpabilité, pour faire l'expiation pour lui, et un dixième d'épha de fleur de farine mélangée à de l'huile, pour l'offrande de farine, et un log d'huile ; ");
INSERT INTO frasbl_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","et deux tourterelles ou deux jeunes pigeons, selon ce qu'il pourra se permettre ; l'un sera un sacrifice pour le péché, et l'autre un holocauste. ");
INSERT INTO frasbl_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","« Le huitième jour, il les apportera au sacrificateur, à l'entrée de la tente d'assignation, devant Yahvé, pour sa purification. ");
INSERT INTO frasbl_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Le sacrificateur prendra l'agneau du sacrifice de culpabilité et le log d'huile, et il les agitera en sacrifice par agitation devant Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Il égorgera l'agneau du sacrifice de culpabilité. Le prêtre prendra un peu du sang du sacrifice de culpabilité et en mettra sur le bout de l'oreille droite de celui qui doit être purifié, sur le pouce de sa main droite et sur le gros orteil de son pied droit. ");
INSERT INTO frasbl_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Le prêtre versera une partie de l'huile dans la paume de sa main gauche ; ");
INSERT INTO frasbl_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","et le prêtre fera avec son doigt droit sept aspersions de l'huile qui est dans sa main gauche, devant Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Puis le prêtre mettra un peu de l'huile qui est dans sa main sur le bout de l'oreille droite de celui qui doit être purifié, sur le pouce de sa main droite et sur le gros orteil de son pied droit, à la place du sang du sacrifice de culpabilité. ");
INSERT INTO frasbl_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Il mettra le reste de l'huile qui est dans la main du prêtre sur la tête de celui qui doit être purifié, afin de faire pour lui l'expiation devant Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Il offrira l'une des tourterelles ou l'un des jeunes pigeons qu'il pourra se procurer, ");
INSERT INTO frasbl_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","de l'espèce qu'il pourra se procurer, l'un pour le sacrifice pour le péché, l'autre pour l'holocauste, avec l'offrande de gâteau. Le prêtre fera l'expiation pour celui qui doit être purifié devant Yahvé. » ");
INSERT INTO frasbl_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Telle est la loi pour celui qui a la plaie de la lèpre et qui n'a pas les moyens de payer le sacrifice pour sa purification. ");
INSERT INTO frasbl_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Yahvé parla à Moïse et à Aaron, et dit : ");
INSERT INTO frasbl_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","Lorsque vous serez entrés dans le pays de Canaan, dont je vous donne la possession, et que j'aurai mis de la moisissure dans une maison du pays dont vous avez la possession, ");
INSERT INTO frasbl_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","le propriétaire de la maison viendra dire au prêtre : « Il me semble qu'il y a une sorte de plaie dans la maison ». ");
INSERT INTO frasbl_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Le prêtre ordonnera que l'on vide la maison, avant que le prêtre n'entre pour examiner la plaie, afin que tout ce qui se trouve dans la maison ne soit pas rendu impur. Ensuite, le prêtre entrera pour examiner la maison. ");
INSERT INTO frasbl_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Il examinera la plaie ; et voici, si la plaie est dans les murs de la maison, avec des stries creuses, verdâtres ou rougeâtres, et qu'elle paraisse plus profonde que le mur, ");
INSERT INTO frasbl_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","le prêtre sortira de la maison, à la porte de la maison, et il fermera la maison pendant sept jours. ");
INSERT INTO frasbl_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Le prêtre reviendra le septième jour et regardera. Si la plaie s'est étendue dans les murs de la maison, ");
INSERT INTO frasbl_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","le prêtre ordonnera qu'on enlève les pierres dans lesquelles se trouve la plaie, et qu'on les jette dans un lieu impur hors de la ville. ");
INSERT INTO frasbl_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Il fera gratter l'intérieur de la maison sur toute sa surface. Ils jetteront le mortier qu'ils auront gratté hors de la ville, dans un lieu impur. ");
INSERT INTO frasbl_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","On prendra d'autres pierres et on les mettra à la place de ces pierres ; on prendra un autre mortier et on crépitera la maison. ");
INSERT INTO frasbl_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","« Si la plaie revient et se déclare dans la maison, après qu'on a enlevé les pierres, qu'on a gratté la maison et qu'on l'a plâtrée, ");
INSERT INTO frasbl_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","le prêtre entrera et regardera ; et voici, si la plaie s'est répandue dans la maison, c'est un mildiou destructeur dans la maison. Elle est impure. ");
INSERT INTO frasbl_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Il démolira la maison, ses pierres et son bois, et tout le mortier de la maison. Il les emportera hors de la ville, dans un lieu impur. ");
INSERT INTO frasbl_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","De plus, celui qui entrera dans la maison pendant qu'elle sera fermée sera impur jusqu'au soir. ");
INSERT INTO frasbl_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Celui qui se couchera dans la maison lavera ses vêtements, et celui qui mangera dans la maison lavera ses vêtements. ");
INSERT INTO frasbl_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","« Si le prêtre entre et l'examine, et que la plaie ne se soit pas répandue dans la maison, après que la maison a été enduite, le prêtre déclarera la maison pure, parce que la plaie est guérie. ");
INSERT INTO frasbl_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Pour purifier la maison, il prendra deux oiseaux, du bois de cèdre, du cramoisi et de l'hysope. ");
INSERT INTO frasbl_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Il tuera l'un des oiseaux dans un vase de terre, au-dessus de l'eau courante. ");
INSERT INTO frasbl_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Il prendra le bois de cèdre, l'hysope, le cramoisi et l'oiseau vivant ; il les trempera dans le sang de l'oiseau tué et dans l'eau courante, et il fera sept aspersions sur la maison. ");
INSERT INTO frasbl_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Il purifiera la maison avec le sang de l'oiseau, avec l'eau courante, avec l'oiseau vivant, avec le bois de cèdre, avec l'hysope et avec le cramoisi ; ");
INSERT INTO frasbl_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","mais il laissera l'oiseau vivant sortir de la ville dans les champs. Il fera ainsi l'expiation de la maison, et elle sera pure. » ");
INSERT INTO frasbl_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Telle est la loi pour toute plaie de lèpre, pour une démangeaison, ");
INSERT INTO frasbl_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","pour la moisissure destructrice d'un vêtement, et pour une maison, ");
INSERT INTO frasbl_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","pour un gonflement, une croûte, et une tache brillante ; ");
INSERT INTO frasbl_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","pour enseigner quand c'est impur, et quand c'est pur. C'est la loi de la lèpre. ");
INSERT INTO frasbl_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Yahvé parla à Moïse et à Aaron, et dit : ");
INSERT INTO frasbl_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","Parle aux enfants d'Israël, et dis-leur : Si un homme a un écoulement de son corps, il est impur à cause de cet écoulement. ");
INSERT INTO frasbl_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Voici quelle sera sa souillure dans son écoulement : que son corps coule avec son écoulement, ou que son corps s'arrête à cause de son écoulement, c'est sa souillure. ");
INSERT INTO frasbl_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","\"'Tout lit sur lequel sera couché l'excréteur sera impur, et tout ce sur quoi il s'assiéra sera impur. ");
INSERT INTO frasbl_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Celui qui touchera son lit lavera ses vêtements, se lavera dans l'eau et sera impur jusqu'au soir. ");
INSERT INTO frasbl_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Celui qui s'assiéra sur une chose sur laquelle s'est assis l'homme qui a eu des pertes lavera ses vêtements, se lavera dans l'eau et sera impur jusqu'au soir. ");
INSERT INTO frasbl_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","\"'Celui qui touchera le corps de celui qui a des pertes lavera ses vêtements, se baignera dans l'eau et sera impur jusqu'au soir. ");
INSERT INTO frasbl_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","\"'Si celui qui a l'écoulement crache sur celui qui est pur, il lavera ses vêtements, se baignera dans l'eau, et sera impur jusqu'au soir. ");
INSERT INTO frasbl_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","\"'La selle sur laquelle monte celui qui a l'infection sera impure. ");
INSERT INTO frasbl_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Celui qui touchera ce qui était sous lui sera impur jusqu'au soir. Celui qui porte ces choses lavera ses vêtements, se baignera dans l'eau et sera impur jusqu'au soir. ");
INSERT INTO frasbl_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","« Si celui qui a l'écoulement touche quelqu'un sans s'être lavé les mains dans l'eau, il lavera ses vêtements, se baignera dans l'eau et sera impur jusqu'au soir. ");
INSERT INTO frasbl_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","\"'Le vase de terre que touche celui qui a la décharge sera brisé ; et tout vase de bois sera rincé à l'eau. ");
INSERT INTO frasbl_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","\"'Quand celui qui a des pertes sera purifié de ses pertes, il comptera sept jours pour sa purification, il lavera ses vêtements, il baignera son corps dans l'eau courante et il sera pur. ");
INSERT INTO frasbl_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","\"'Le huitième jour, il prendra deux tourterelles ou deux jeunes pigeons ; il se présentera devant l'Éternel, à l'entrée de la tente d'assignation, et les donnera au prêtre. ");
INSERT INTO frasbl_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Le prêtre les offrira, l'une en sacrifice pour le péché, et l'autre en holocauste. Le prêtre fera pour lui l'expiation devant Yahvé, pour qu'il se libère. ");
INSERT INTO frasbl_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","\"'Si un homme a une émission de sperme, il lavera toute sa chair dans l'eau et sera impur jusqu'au soir. ");
INSERT INTO frasbl_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Tout vêtement et toute peau sur lesquels il y a du sperme seront lavés avec de l'eau et seront impurs jusqu'au soir. ");
INSERT INTO frasbl_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Si un homme couche avec une femme et qu'il y ait émission de sperme, ils se laveront tous deux dans l'eau et seront impurs jusqu'au soir. ");
INSERT INTO frasbl_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","\"'Si une femme a un écoulement, et que cet écoulement soit du sang dans sa chair, elle restera sept jours dans son impureté. Quiconque la touchera sera impur jusqu'au soir. ");
INSERT INTO frasbl_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","\"'Tout ce sur quoi elle se couchera dans son impureté sera impur. Tout ce sur quoi elle s'assiéra sera impur. ");
INSERT INTO frasbl_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Quiconque touchera son lit lavera ses vêtements, se lavera dans l'eau et sera impur jusqu'au soir. ");
INSERT INTO frasbl_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Si quelqu'un touche un objet sur lequel elle s'est assise, il lavera ses vêtements, se lavera dans l'eau et sera impur jusqu'au soir. ");
INSERT INTO frasbl_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Si elle est sur le lit ou sur ce sur quoi elle s'est assise, lorsqu'il la touchera, il sera impur jusqu'au soir. ");
INSERT INTO frasbl_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","\"'Si un homme couche avec elle, et que son flux mensuel soit sur lui, il sera impur pendant sept jours ; et tout lit sur lequel il couchera sera impur. ");
INSERT INTO frasbl_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","\"'Si une femme a un écoulement de son sang plusieurs jours en dehors du temps de ses règles, ou si elle a un écoulement au-delà du temps de ses règles, tous les jours de l'écoulement de son impureté seront comme les jours de ses règles. Elle est impure. ");
INSERT INTO frasbl_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Tout lit sur lequel elle couchera pendant tous les jours de son écoulement sera pour elle comme le lit de ses règles. Tout ce sur quoi elle s'assiéra sera impur, comme l'impureté de ses règles. ");
INSERT INTO frasbl_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Quiconque touchera ces choses sera impur ; il lavera ses vêtements, se baignera dans l'eau et sera impur jusqu'au soir. ");
INSERT INTO frasbl_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","\"'Mais si elle est purifiée de son flux, elle comptera sept jours, et après cela elle sera pure. ");
INSERT INTO frasbl_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Le huitième jour, elle prendra deux tourterelles ou deux jeunes pigeons, et les apportera au prêtre, à l'entrée de la tente d'assignation. ");
INSERT INTO frasbl_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Le prêtre offrira l'un en sacrifice pour le péché, et l'autre en holocauste ; et le prêtre fera pour elle l'expiation devant Yahvé de la souillure qu'elle a commise. ");
INSERT INTO frasbl_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","\"'Tu sépareras ainsi les enfants d'Israël de leur souillure, afin qu'ils ne meurent pas dans leur souillure lorsqu'ils souilleront mon tabernacle qui est au milieu d'eux'\". ");
INSERT INTO frasbl_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","C'est la loi de celui qui a une décharge et de celui qui a une émission de sperme, de sorte qu'il est impur par cela ; ");
INSERT INTO frasbl_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","et de celle qui a ses règles, et de l'homme ou de la femme qui a une décharge, et de celui qui couche avec elle qui est impur. ");
INSERT INTO frasbl_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Yahvé parla à Moïse après la mort des deux fils d'Aaron, qui s'étaient approchés de Yahvé et étaient morts. ");
INSERT INTO frasbl_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Yahvé dit à Moïse : « Dis à Aaron, ton frère, de ne pas entrer à l'improviste dans le lieu très saint, au-dedans du voile, devant le propitiatoire qui est sur l'arche, de peur qu'il ne meure ; car je vais apparaître dans la nuée sur le propitiatoire. ");
INSERT INTO frasbl_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","« Aaron entrera dans le sanctuaire avec un jeune taureau pour le sacrifice pour le péché et un bélier pour l'holocauste. ");
INSERT INTO frasbl_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Il revêtira la tunique de lin sacré. Il aura sur le corps le pantalon de lin, il mettra la ceinture de lin, et il sera revêtu du turban de lin. Ce sont les vêtements sacrés. Il se lavera le corps dans l'eau et les revêtira. ");
INSERT INTO frasbl_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Il prendra dans l'assemblée des enfants d'Israël deux boucs pour le sacrifice pour le péché et un bélier pour l'holocauste. ");
INSERT INTO frasbl_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","« Aaron offrira le taureau du sacrifice pour le péché, qui sera pour lui, et il fera l'expiation pour lui et pour sa maison. ");
INSERT INTO frasbl_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Il prendra les deux boucs et les placera devant l'Éternel, à l'entrée de la tente d'assignation. ");
INSERT INTO frasbl_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Aaron tirera au sort les deux boucs, l'un pour l'Éternel, l'autre pour le bouc émissaire. ");
INSERT INTO frasbl_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Aaron présentera le bouc sur lequel est tombé le sort pour l'Éternel et l'offrira en sacrifice pour le péché. ");
INSERT INTO frasbl_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Mais le bouc sur lequel est tombé le sort pour le bouc émissaire sera présenté vivant devant l'Éternel, afin de faire l'expiation pour lui, pour l'envoyer comme bouc émissaire dans le désert. ");
INSERT INTO frasbl_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","« Aaron présentera le taureau du sacrifice pour le péché, qui est pour lui ; il fera l'expiation pour lui et pour sa maison, et il égorgera le taureau du sacrifice pour le péché qui est pour lui. ");
INSERT INTO frasbl_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Il prendra sur l'autel, devant l'Éternel, un encensoir rempli de charbons ardents, et deux poignées de parfum odoriférant taillé en petits morceaux, qu'il apportera en dedans du voile. ");
INSERT INTO frasbl_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Il mettra l'encens sur le feu devant l'Éternel, afin que la nuée de l'encens couvre le propitiatoire qui est sur l'alliance, et qu'il ne meure pas. ");
INSERT INTO frasbl_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Il prendra du sang du taureau et en fera l'aspersion avec son doigt sur le propitiatoire, à l'orient ; il fera sept fois l'aspersion du sang avec son doigt devant le propitiatoire. ");
INSERT INTO frasbl_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","« Puis il égorgera le bouc du sacrifice pour le péché qui est pour le peuple, il apportera son sang en dedans du voile, il fera de son sang ce qu'il a fait du sang du taureau, et il en fera l'aspersion sur le propitiatoire et devant le propitiatoire. ");
INSERT INTO frasbl_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Il fera l'expiation pour le lieu saint, à cause de la souillure des enfants d'Israël et à cause de leurs transgressions, de tous leurs péchés ; il fera de même pour la tente d'assignation qui habite avec eux, au milieu de leur souillure. ");
INSERT INTO frasbl_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Personne ne sera dans la Tente d'assignation lorsqu'il entrera pour faire l'expiation dans le Lieu saint, jusqu'à ce qu'il en sorte et qu'il ait fait l'expiation pour lui-même, pour sa famille et pour toute l'assemblée d'Israël. ");
INSERT INTO frasbl_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","« Il ira vers l'autel qui est devant l'Éternel et fera l'expiation pour lui ; il prendra du sang de taureau et du sang de bouc, et il en mettra autour des cornes de l'autel. ");
INSERT INTO frasbl_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Il fera sept fois avec son doigt l'aspersion d'un peu de sang sur l'autel, il le purifiera et le sanctifiera des impuretés des enfants d'Israël. ");
INSERT INTO frasbl_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","« Lorsqu'il aura achevé d'expier pour le Lieu saint, la Tente d'assignation et l'autel, il présentera le bouc vivant. ");
INSERT INTO frasbl_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Aaron posera ses deux mains sur la tête du bouc vivant et confessera sur lui toutes les iniquités des enfants d'Israël, toutes leurs transgressions, tous leurs péchés ; il les mettra sur la tête du bouc et l'enverra dans le désert par la main d'un homme préparé. ");
INSERT INTO frasbl_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Le bouc portera sur lui toutes leurs iniquités jusqu'à un pays solitaire, et il relâchera le bouc dans le désert. ");
INSERT INTO frasbl_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","« Aaron entrera dans la Tente d'assignation ; il ôtera les vêtements de lin dont il s'est revêtu en entrant dans le Lieu saint, et il les laissera là. ");
INSERT INTO frasbl_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Il se lavera ensuite dans l'eau dans un lieu saint, remettra ses vêtements et sortira pour offrir son holocauste et celui du peuple, et il fera l'expiation pour lui-même et pour le peuple. ");
INSERT INTO frasbl_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Il brûlera sur l'autel la graisse du sacrifice pour le péché. ");
INSERT INTO frasbl_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","« Celui qui aura laissé le bouc comme bouc émissaire lavera ses vêtements et lavera sa chair dans l'eau, puis il entrera dans le camp. ");
INSERT INTO frasbl_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Le taureau pour le sacrifice pour le péché et le bouc pour le sacrifice pour le péché, dont le sang a été apporté pour faire l'expiation dans le lieu saint, seront transportés hors du camp ; on brûlera au feu leurs peaux, leur chair et leurs excréments. ");
INSERT INTO frasbl_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Celui qui les brûlera lavera ses vêtements et lavera son corps dans l'eau, puis il rentrera dans le camp. ");
INSERT INTO frasbl_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","« Ce sera pour vous une loi à perpétuité : au septième mois, le dixième jour du mois, vous affligerez vos âmes et vous ne ferez aucun travail, que vous soyez natif ou étranger au milieu de vous ; ");
INSERT INTO frasbl_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","car en ce jour, on fera pour vous l'expiation, pour vous purifier. Vous serez purifiés de tous vos péchés devant Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","C'est un sabbat de repos solennel pour vous, et vous affligerez vos âmes. C'est un statut pour toujours. ");
INSERT INTO frasbl_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Le prêtre, qui a reçu l'onction et qui a été consacré pour être prêtre à la place de son père, fera l'expiation et revêtira les vêtements de lin, les vêtements sacrés. ");
INSERT INTO frasbl_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Puis il fera l'expiation du sanctuaire saint, de la tente d'assignation et de l'autel, et il fera l'expiation des prêtres et de tout le peuple de l'assemblée. ");
INSERT INTO frasbl_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","« Ce sera pour toi une loi perpétuelle : tu feras l'expiation pour les enfants d'Israël une fois par an, à cause de tous leurs péchés. » Cela a été fait comme Yahvé l'avait ordonné à Moïse. ");
INSERT INTO frasbl_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Yahvé parla à Moïse, et dit : ");
INSERT INTO frasbl_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","Parle à Aaron, à ses fils et à tous les enfants d'Israël, et tu leur diras : « Voici ce que Yahvé a ordonné : ");
INSERT INTO frasbl_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Tout homme de la maison d'Israël qui aura tué un taureau, un agneau ou une chèvre dans le camp, ou qui l'aura tué hors du camp, ");
INSERT INTO frasbl_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","et qui ne l'aura pas apporté à l'entrée de la tente d'assignation pour l'offrir en sacrifice à l'Éternel devant la tente de l'Éternel : le sang sera imputé à cet homme. Il a versé le sang. Cet homme sera retranché du milieu de son peuple. ");
INSERT INTO frasbl_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Ceci afin que les enfants d'Israël apportent leurs sacrifices, qu'ils sacrifient en plein champ, afin qu'ils les apportent à l'Éternel, à l'entrée de la tente d'assignation, au sacrificateur, et qu'ils les offrent en sacrifice d'actions de grâces à l'Éternel. ");
INSERT INTO frasbl_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Le prêtre aspergera le sang sur l'autel de l'Éternel, à l'entrée de la Tente d'assignation, et il brûlera la graisse en parfum d'agrément pour l'Éternel. ");
INSERT INTO frasbl_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Ils n'offriront plus leurs sacrifices aux idoles de boucs, après lesquelles ils se prostituent. Ce sera pour eux une loi à perpétuité, de génération en génération ». ");
INSERT INTO frasbl_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","« Tu leur diras : « Tout homme de la maison d'Israël ou des étrangers qui vivent au milieu d'eux, qui offre un holocauste ou un sacrifice, ");
INSERT INTO frasbl_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","et qui ne l'apporte pas à l'entrée de la tente de la Rencontre pour le sacrifier à Yahvé, cet homme sera retranché de son peuple. ");
INSERT INTO frasbl_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","\"'Tout homme de la maison d'Israël, ou des étrangers qui vivent au milieu d'eux, qui mange du sang, quel qu'il soit, je tournerai ma face contre cet homme qui mange du sang, et je le retrancherai du milieu de son peuple. ");
INSERT INTO frasbl_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Car la vie de la chair est dans le sang. Je vous l'ai donné sur l'autel pour faire l'expiation de vos âmes, car c'est le sang qui fait l'expiation à cause de la vie. ");
INSERT INTO frasbl_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","C'est pourquoi j'ai dit aux enfants d'Israël : « Personne parmi vous ne pourra manger du sang, et aucun étranger vivant au milieu de vous ne pourra manger du sang. » ");
INSERT INTO frasbl_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","\"'Tout homme des enfants d'Israël ou des étrangers qui vivent au milieu d'eux, qui prendra à la chasse un animal ou un oiseau comestible, en versera le sang et le couvrira de poussière. ");
INSERT INTO frasbl_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Car pour ce qui est de la vie de toute chair, son sang est avec sa vie. C'est pourquoi j'ai dit aux enfants d'Israël : « Vous ne mangerez pas le sang d'aucune espèce de chair, car la vie de toute chair, c'est son sang. Celui qui en mangera sera retranché. » ");
INSERT INTO frasbl_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","\"'Toute personne qui mangera ce qui meurt d'elle-même ou ce qui est déchiré par les animaux, qu'elle soit native ou étrangère, lavera ses vêtements, se baignera dans l'eau et sera impure jusqu'au soir. Ensuite, il sera pur. ");
INSERT INTO frasbl_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Mais s'il ne les lave pas et ne se lave pas, il portera la peine de son iniquité.'\" ");
INSERT INTO frasbl_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Yahvé dit à Moïse : ");
INSERT INTO frasbl_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","Parle aux enfants d'Israël, et dis-leur : « Je suis Yahvé, votre Dieu. ");
INSERT INTO frasbl_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Vous ne ferez pas comme on fait dans le pays d'Égypte, où vous avez vécu. Vous ne ferez pas comme eux dans le pays de Canaan, où je vous conduis. Tu ne suivras pas leurs lois. ");
INSERT INTO frasbl_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Vous observerez mes ordonnances. Tu observeras mes lois et tu marcheras selon elles. Je suis Yahvé, ton Dieu. ");
INSERT INTO frasbl_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Tu observeras donc mes lois et mes ordonnances ; si un homme les met en pratique, il vivra en elles. Je suis Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","\"'Aucun de vous ne s'approchera d'un proche parent pour découvrir sa nudité : Je suis Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","\"'Tu ne découvriras pas la nudité de ton père, ni la nudité de ta mère : elle est ta mère. Tu ne découvriras pas sa nudité. ");
INSERT INTO frasbl_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","\"'Tu ne découvriras pas la nudité de la femme de ton père. C'est la nudité de ton père. ");
INSERT INTO frasbl_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","\"'Tu ne découvriras pas la nudité de ta sœur, fille de ton père ou fille de ta mère, qu'elle soit née dans le pays ou à l'étranger. ");
INSERT INTO frasbl_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","\"'Tu ne découvriras pas la nudité de la fille de ton fils ou de la fille de ta fille, même leur nudité ; car leur nudité est la tienne. ");
INSERT INTO frasbl_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","\"'Tu ne découvriras pas la nudité de la fille de la femme de ton père, conçue par ton père, puisqu'elle est ta sœur. ");
INSERT INTO frasbl_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","\"'Tu ne découvriras pas la nudité de la sœur de ton père. Elle est la proche parente de ton père. ");
INSERT INTO frasbl_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","\"'Tu ne découvriras pas la nudité de la sœur de ta mère, car elle est la proche parente de ta mère. ");
INSERT INTO frasbl_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","\"'Tu ne découvriras pas la nudité du frère de ton père. Tu ne t'approcheras pas de sa femme. Elle est ta tante. ");
INSERT INTO frasbl_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","\"'Tu ne découvriras pas la nudité de ta belle-fille. Elle est la femme de ton fils. Tu ne découvriras pas sa nudité. ");
INSERT INTO frasbl_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","\"'Tu ne découvriras pas la nudité de la femme de ton frère. C'est la nudité de ton frère. ");
INSERT INTO frasbl_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","\"'Tu ne découvriras pas la nudité d'une femme et de sa fille. Tu ne prendras pas la fille de son fils, ni la fille de sa fille, pour découvrir sa nudité. Elles sont proches parentes. C'est de la méchanceté. ");
INSERT INTO frasbl_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","\"'Tu ne prendras pas une femme en plus de sa sœur, pour être une rivale, pour découvrir sa nudité, tant que sa sœur est encore en vie. ");
INSERT INTO frasbl_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","\"'Tu ne t'approcheras pas d'une femme pour découvrir sa nudité, tant qu'elle est souillée par son impureté. ");
INSERT INTO frasbl_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","\"'Tu ne coucheras pas charnellement avec la femme de ton prochain, et tu ne te souilleras pas avec elle. ");
INSERT INTO frasbl_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","\"'Tu ne donneras aucun de tes enfants en sacrifice à Moloch. Tu ne profaneras pas le nom de ton Dieu. Je suis Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","\"'Tu ne coucheras pas avec un homme comme avec une femme. C'est une chose détestable. ");
INSERT INTO frasbl_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","\"'Tu ne coucheras pas avec un animal pour te souiller avec lui. Aucune femme ne peut se donner à un animal, pour se coucher avec lui : c'est une perversion. ");
INSERT INTO frasbl_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","« Ne vous souillez par aucune de ces choses, car c'est par toutes ces choses que se sont souillées les nations que je chasse devant vous. ");
INSERT INTO frasbl_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Le pays s'est souillé. J'ai donc puni son iniquité, et le pays a vomi ses habitants. ");
INSERT INTO frasbl_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Vous observerez donc mes lois et mes ordonnances, et vous ne commettrez aucune de ces abominations, ni le natif, ni l'étranger qui vit au milieu de vous ");
INSERT INTO frasbl_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","(car les hommes du pays qui était avant vous ont commis toutes ces abominations, et le pays s'est souillé), ");
INSERT INTO frasbl_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","afin que le pays ne vous vomisse pas aussi, quand vous le souillerez, comme il a vomi la nation qui était avant vous. ");
INSERT INTO frasbl_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","\"'Car quiconque commettra l'une de ces abominations, les âmes qui les commettent seront retranchées du milieu de leur peuple. ");
INSERT INTO frasbl_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","C'est pourquoi vous observerez mes prescriptions, afin de ne pratiquer aucune de ces coutumes abominables qui ont été pratiquées avant vous, et de ne pas vous souiller par elles. Je suis Yahvé, ton Dieu. » ");
INSERT INTO frasbl_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Yahvé parla à Moïse et dit : ");
INSERT INTO frasbl_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","Parle à toute l'assemblée des enfants d'Israël, et dis-leur : « Vous serez saints, car moi, Yahvé votre Dieu, je suis saint ». ");
INSERT INTO frasbl_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","\"'Chacun de vous respectera sa mère et son père. Vous observerez mes sabbats. Je suis Yahvé ton Dieu. ");
INSERT INTO frasbl_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","\"'Ne vous tournez pas vers les idoles et ne vous faites pas de dieux en fonte. Je suis Yahvé, votre Dieu. ");
INSERT INTO frasbl_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","\"'Lorsque tu offriras un sacrifice de paix à Yahvé, tu l'offriras pour qu'il soit agréé. ");
INSERT INTO frasbl_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Il sera mangé le jour même où tu l'offriras et le jour suivant. S'il reste quelque chose jusqu'au troisième jour, on le brûlera au feu. ");
INSERT INTO frasbl_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Si l'on en mange le troisième jour, c'est une abomination. Elle ne sera pas acceptée ; ");
INSERT INTO frasbl_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","mais quiconque en mangera portera la peine de sa faute, car il a profané la chose sainte de l'Éternel, et cette personne sera retranchée de son peuple. ");
INSERT INTO frasbl_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","\"'Quand tu feras la moisson de ton pays, tu ne moissonneras pas entièrement les coins de ton champ, et tu ne ramasseras pas les glanes de ta moisson. ");
INSERT INTO frasbl_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Tu ne glaneras pas ta vigne, et tu ne ramasseras pas les raisins tombés de ta vigne. Tu les laisseras aux pauvres et à l'étranger. Je suis Yahvé ton Dieu. ");
INSERT INTO frasbl_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","\"'Tu ne voleras pas. \"'Tu ne mentiras pas. \"'Vous ne vous tromperez pas les uns les autres. ");
INSERT INTO frasbl_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","\"'Tu ne jureras pas faussement par mon nom et tu ne profaneras pas le nom de ton Dieu. Je suis Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","\"'Tu n'opprimeras pas ton prochain et tu ne le dépouilleras pas. \"'Le salaire d'un mercenaire ne doit pas rester chez toi toute la nuit jusqu'au matin. ");
INSERT INTO frasbl_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","\"'Tu ne maudiras pas le sourd et tu ne mettras pas de pierre d'achoppement devant l'aveugle, mais tu craindras ton Dieu. Je suis Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","\"'Tu ne commettras pas d'injustice dans ton jugement. Tu ne seras pas partial envers le pauvre et tu ne feras pas preuve de favoritisme envers le grand, mais tu jugeras ton prochain avec droiture. ");
INSERT INTO frasbl_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","\"'Tu ne seras pas un calomniateur parmi ton peuple. \"'Tu ne mettras pas en danger la vie de ton prochain. Je suis Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","\"'Tu ne haïras pas ton frère dans ton cœur. Tu réprimanderas ton prochain, et tu ne porteras pas de péché à cause de lui. ");
INSERT INTO frasbl_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","\"'Tu ne te vengeras pas et tu ne garderas pas rancune aux enfants de ton peuple, mais tu aimeras ton prochain comme toi-même. Je suis Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","\"'Vous observerez mes lois. \"'Tu ne feras pas de croisement entre différentes espèces d'animaux. \"'Tu ne sèmeras pas ton champ avec deux sortes de semences ; \"'Ne portez pas un vêtement fait de deux sortes d'étoffes. ");
INSERT INTO frasbl_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","\"'Si un homme couche charnellement avec une femme qui est une esclave, promise en mariage à un autre homme, et qui n'a pas été rachetée ou libérée, ils seront punis. Ils ne seront pas mis à mort, parce qu'elle n'était pas libre. ");
INSERT INTO frasbl_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Il apportera son sacrifice de culpabilité à Yahvé, à l'entrée de la tente d'assignation, un bélier en sacrifice de culpabilité. ");
INSERT INTO frasbl_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Le prêtre fera pour lui l'expiation avec le bélier du sacrifice de culpabilité devant Yahvé, pour le péché qu'il a commis ; et le péché qu'il a commis lui sera pardonné. ");
INSERT INTO frasbl_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","\"'Quand tu seras entré dans le pays et que tu auras planté toutes sortes d'arbres pour te nourrir, tu compteras leur fruit comme interdit. Pendant trois ans, il te sera interdit. Vous n'en mangerez pas. ");
INSERT INTO frasbl_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Mais la quatrième année, tous ses fruits seront saints, pour louer l'Éternel. ");
INSERT INTO frasbl_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","La cinquième année, vous mangerez de ses fruits, afin qu'elle vous donne ses produits. Je suis Yahvé, ton Dieu. ");
INSERT INTO frasbl_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","\"'Tu ne mangeras pas de viande dont le sang est encore présent. Tu n'utiliseras pas d'enchantements et tu ne pratiqueras pas la sorcellerie. ");
INSERT INTO frasbl_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","\"'Tu ne couperas pas les cheveux sur les côtés de ta tête et tu ne couperas pas le bord de ta barbe. ");
INSERT INTO frasbl_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","\"'Tu ne feras pas d'incisions dans ta chair pour les morts, et tu ne te tatoueras pas de marques. Je suis Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","\"'Ne profane pas ta fille pour en faire une prostituée, de peur que le pays ne tombe dans la prostitution et que le pays ne se remplisse de méchanceté. ");
INSERT INTO frasbl_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","\"'Tu observeras mes sabbats et tu révéreras mon sanctuaire ; je suis Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","\"'Ne vous tournez pas vers ceux qui sont médiums, ni vers les sorciers. Ne les recherchez pas pour vous souiller avec eux. Je suis Yahvé ton Dieu. ");
INSERT INTO frasbl_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","\"'Tu te lèveras devant la tête grise et tu honoreras le visage des vieillards, et tu craindras ton Dieu. Je suis Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","\"'Si un étranger vit avec vous comme un étranger dans votre pays, vous ne lui ferez pas de mal. ");
INSERT INTO frasbl_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","L'étranger qui vit avec toi comme un étranger sera pour toi comme le natif d'entre vous, et tu l'aimeras comme toi-même, car vous avez vécu comme des étrangers au pays d'Égypte. Je suis Yahvé ton Dieu. ");
INSERT INTO frasbl_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","\"'Tu ne commettras pas d'injustice dans le jugement, dans les mesures de longueur, de poids ou de quantité. ");
INSERT INTO frasbl_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Tu auras des balances justes, des poids justes, un épha juste et un hin juste. Je suis Yahvé ton Dieu, qui t'a fait sortir du pays d'Égypte. ");
INSERT INTO frasbl_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","\"'Vous observerez toutes mes lois et toutes mes ordonnances, et vous les mettrez en pratique. Je suis Yahvé. » ");
INSERT INTO frasbl_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Yahvé parla à Moïse et dit : ");
INSERT INTO frasbl_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","Tu diras aux enfants d'Israël : « Si quelqu'un parmi les enfants d'Israël ou parmi les étrangers qui vivent en Israël donne un de ses descendants à Moloch, il sera puni de mort. Les habitants du pays lapideront cette personne. ");
INSERT INTO frasbl_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Moi aussi, je tournerai ma face contre cet homme, et je le retrancherai du milieu de son peuple, parce qu'il a donné de sa progéniture à Moloch, pour souiller mon sanctuaire et profaner mon saint nom. ");
INSERT INTO frasbl_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Si tous les habitants du pays cachent les yeux de cette personne lorsqu'elle donne de sa progéniture à Moloc, et ne la font pas mourir, ");
INSERT INTO frasbl_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","je tournerai ma face contre cet homme et contre sa famille, et je la retrancherai du milieu de son peuple, ainsi que tous ceux qui se prostituent après lui pour se prostituer à Moloc. ");
INSERT INTO frasbl_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","\"'Celui qui se tourne vers les médiums et les magiciens, pour se prostituer après eux, je tournerai ma face contre lui, et je le retrancherai du milieu de son peuple. ");
INSERT INTO frasbl_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","« Sanctifiez-vous donc et soyez saints, car je suis Yahvé votre Dieu. ");
INSERT INTO frasbl_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Vous observerez mes lois et vous les mettrez en pratique. C'est moi, Yahvé, qui vous sanctifie. ");
INSERT INTO frasbl_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","\"'Car quiconque maudit son père ou sa mère sera puni de mort. Il a maudit son père ou sa mère. Son sang retombera sur lui. ");
INSERT INTO frasbl_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","\"'L'homme qui commet un adultère avec la femme d'un autre homme, même celui qui commet un adultère avec la femme de son prochain, l'adultère et la femme adultère seront punis de mort. ");
INSERT INTO frasbl_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","\"'L'homme qui couche avec la femme de son père a découvert la nudité de son père. Ils seront tous deux mis à mort. Leur sang retombera sur eux. ");
INSERT INTO frasbl_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","\"'Si un homme couche avec sa belle-fille, ils seront tous deux mis à mort. Ils ont commis une perversion. Leur sang retombera sur eux. ");
INSERT INTO frasbl_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","\"'Si un homme couche avec un mâle, comme avec une femme, tous deux ont commis une abomination. Ils seront mis à mort. Leur sang retombera sur eux. ");
INSERT INTO frasbl_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","\"'Si un homme prend une femme et sa mère, c'est une infamie. Ils seront brûlés au feu, lui et elles, afin qu'il n'y ait pas de méchanceté parmi vous. ");
INSERT INTO frasbl_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","\"'Si un homme couche avec un animal, il sera mis à mort, et vous tuerez l'animal. ");
INSERT INTO frasbl_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","\"'Si une femme s'approche d'un animal et couche avec lui, vous tuerez la femme et l'animal. Ils seront mis à mort. Leur sang retombera sur eux. ");
INSERT INTO frasbl_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","\"'Si un homme prend sa sœur, fille de son père ou fille de sa mère, et qu'il voit sa nudité, et qu'elle voit sa nudité, c'est une honte. Ils seront retranchés aux yeux des enfants de leur peuple. Il a découvert la nudité de sa sœur. Il portera son iniquité. ");
INSERT INTO frasbl_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","\"'Si un homme couche avec une femme qui a ses règles et découvre sa nudité, il a mis à nu sa source, et elle a découvert la source de son sang. Tous deux seront retranchés du milieu de leur peuple. ");
INSERT INTO frasbl_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","\"'Tu ne découvriras pas la nudité de la sœur de ta mère, ni celle de la sœur de ton père, car il a mis à nu son proche parent. Ils porteront la peine de leur iniquité. ");
INSERT INTO frasbl_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Si un homme couche avec la femme de son oncle, il a découvert la nudité de son oncle. Ils porteront la peine de leur péché. Ils mourront sans enfant. ");
INSERT INTO frasbl_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","\"'Si un homme prend la femme de son frère, c'est une impureté. Il a découvert la nudité de son frère. Ils seront sans enfants. ");
INSERT INTO frasbl_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","\"'Vous observerez donc toutes mes lois et toutes mes ordonnances, et vous les mettrez en pratique, afin que le pays où je vous fais habiter ne vous vomisse pas. ");
INSERT INTO frasbl_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Tu ne marcheras pas selon les coutumes de la nation que je rejette devant toi ; car ils ont fait toutes ces choses, et c'est pourquoi je les ai en horreur. ");
INSERT INTO frasbl_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Mais je vous ai dit : « Vous hériterez de leur pays, et je vous le donnerai en propriété, un pays où coulent le lait et le miel. » Je suis Yahvé, votre Dieu, qui vous a séparés des peuples. ");
INSERT INTO frasbl_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","\"'Vous ferez donc la distinction entre l'animal pur et l'impur, et entre le volatile impur et le pur. Vous ne vous rendrez pas abominables par un animal, par un oiseau ou par tout ce dont regorge le sol, que j'ai séparé de vous comme impur pour vous. ");
INSERT INTO frasbl_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Vous serez saints pour moi, car moi, Yahvé, je suis saint, et je vous ai séparés des peuples, pour que vous soyez à moi. ");
INSERT INTO frasbl_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","\"'Un homme ou une femme qui est un médium ou un magicien sera mis à mort. Ils seront lapidés. Leur sang retombera sur eux. » ");
INSERT INTO frasbl_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Yahvé dit à Moïse : « Parle aux prêtres, les fils d'Aaron, et dis-leur : « Le prêtre ne se souillera pas pour les morts de son peuple, ");
INSERT INTO frasbl_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","sauf pour ses proches : pour sa mère, pour son père, pour son fils, pour sa fille, pour son frère, ");
INSERT INTO frasbl_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","et pour sa sœur vierge qui est près de lui et qui n'a pas eu de mari ; pour elle, il pourra se souiller. ");
INSERT INTO frasbl_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Il ne se souillera pas, étant le chef de son peuple, pour se profaner. ");
INSERT INTO frasbl_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","\"'Ils ne se raseront pas la tête, ne raseront pas les coins de leur barbe et ne feront aucune incision dans leur chair. ");
INSERT INTO frasbl_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Ils seront saints pour leur Dieu et ne profaneront pas le nom de leur Dieu, car ils offrent les sacrifices de l'Éternel faits par le feu, le pain de leur Dieu. C'est pourquoi ils seront saints. ");
INSERT INTO frasbl_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","\"'Ils n'épouseront pas une femme qui se prostitue ou qui est profane. Le prêtre n'épousera pas une femme divorcée de son mari, car il est saint pour son Dieu. ");
INSERT INTO frasbl_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Vous le sanctifierez donc, car il offre le pain de votre Dieu. Il sera saint pour toi, car moi, Yahvé, qui te sanctifie, je suis saint. ");
INSERT INTO frasbl_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","\"'La fille d'un prêtre, si elle se profane en se prostituant, elle profane son père. Elle sera brûlée au feu. ");
INSERT INTO frasbl_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","\"'Celui qui est le grand prêtre parmi ses frères, sur la tête duquel on verse l'huile d'onction, et qui est consacré pour revêtir les vêtements, ne laissera pas pendre les cheveux de sa tête et ne déchirera pas ses vêtements. ");
INSERT INTO frasbl_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Il n'entrera pas auprès d'un cadavre, et ne se souillera pas pour son père ou pour sa mère. ");
INSERT INTO frasbl_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Il ne sortira pas du sanctuaire et ne profanera pas le sanctuaire de son Dieu, car la couronne de l'huile d'onction de son Dieu est sur lui. Je suis Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","\"'Il prendra sa femme dans sa virginité. ");
INSERT INTO frasbl_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Il n'épousera ni une veuve, ni une divorcée, ni une femme qui s'est souillée, ni une prostituée. Il prendra pour femme une vierge de son peuple. ");
INSERT INTO frasbl_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Il ne profanera pas sa descendance parmi son peuple, car c'est moi, Yahvé, qui le sanctifie. »\" ");
INSERT INTO frasbl_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Yahvé parla à Moïse et dit : ");
INSERT INTO frasbl_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","« Dis à Aaron : Aucun de tes descendants, de génération en génération, qui a un défaut ne pourra s'approcher pour offrir le pain de son Dieu. ");
INSERT INTO frasbl_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Car quel que soit l'homme qui a un défaut, il ne s'approchera pas : un aveugle, ou un boiteux, ou celui qui a le nez aplati, ou toute autre difformité, ");
INSERT INTO frasbl_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","ou un homme qui a un pied blessé, ou une main blessée, ");
INSERT INTO frasbl_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","ou un bossu, ou un nain, ou celui qui a un défaut à l'œil, ou une maladie qui démange, ou des croûtes, ou qui a des testicules endommagés. ");
INSERT INTO frasbl_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Aucun homme de la descendance du prêtre Aaron qui a un défaut ne s'approchera pour offrir les offrandes consumées par le feu de Yahvé. Comme il a une tare, il ne s'approchera pas pour offrir le pain de son Dieu. ");
INSERT INTO frasbl_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Il mangera le pain de son Dieu, celui qui est très saint et celui qui est saint. ");
INSERT INTO frasbl_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Il ne s'approchera pas du voile, ni de l'autel, car il a un défaut, afin de ne pas profaner mes sanctuaires, car je suis l'Éternel qui les sanctifie.'\" ");
INSERT INTO frasbl_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Moïse parla à Aaron, à ses fils et à tous les enfants d'Israël. ");
INSERT INTO frasbl_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Yahvé parla à Moïse, et dit : ");
INSERT INTO frasbl_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","« Dis à Aaron et à ses fils de se séparer des choses saintes des enfants d'Israël, qu'ils me consacrent, et de ne pas profaner mon saint nom. Je suis Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","« Dis-leur : « Si quelqu'un de tous vos descendants, de génération en génération, s'approche des choses saintes que les enfants d'Israël consacrent à Yahvé, en ayant sur lui son impureté, cette personne sera retranchée de devant moi. Je suis Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","\"'Quiconque, parmi les descendants d'Aaron, est lépreux ou a des pertes, ne mangera pas des choses saintes jusqu'à ce qu'il soit pur. Celui qui touchera une chose souillée par un mort, ou un homme qui a une émission séminale, ");
INSERT INTO frasbl_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","ou celui qui touchera un reptile par lequel il peut être souillé, ou un homme de qui il peut être souillé, quelle que soit sa souillure - ");
INSERT INTO frasbl_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","celui qui aura touché l'une de ces choses sera souillé jusqu'au soir, et ne mangera pas des choses saintes, à moins qu'il ne se lave le corps dans l'eau. ");
INSERT INTO frasbl_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Au coucher du soleil, il sera pur ; ensuite, il mangera des choses saintes, car c'est son pain. ");
INSERT INTO frasbl_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Il ne mangera pas de ce qui meurt de lui-même ou qui est déchiré par les animaux, car il s'en souillerait. Je suis Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","\"'Ils suivront donc mon commandement, de peur de porter un péché à cause de lui et de mourir en lui, s'ils le profanent. C'est moi, Yahvé, qui les sanctifie. ");
INSERT INTO frasbl_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","\"'Aucun étranger ne mangera de la chose sainte : un étranger qui habite avec les prêtres, ou un mercenaire, ne mangera pas de la chose sainte. ");
INSERT INTO frasbl_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Mais si un prêtre achète un esclave, acquis par son argent, il en mangera ; et ceux qui sont nés dans sa maison mangeront de son pain. ");
INSERT INTO frasbl_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Si la fille d'un prêtre est mariée à un étranger, elle ne mangera pas de l'offrande par élévation des choses saintes. ");
INSERT INTO frasbl_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Mais si la fille d'un prêtre est veuve ou divorcée, qu'elle n'a pas d'enfant et qu'elle est retournée dans la maison de son père comme dans sa jeunesse, elle pourra manger le pain de son père, mais aucun étranger n'en mangera. ");
INSERT INTO frasbl_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","\"'Si un homme mange involontairement une chose sainte, il y ajoutera le cinquième de sa valeur, et il donnera la chose sainte au prêtre. ");
INSERT INTO frasbl_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Les prêtres ne profaneront pas les choses saintes des enfants d'Israël, qu'ils offrent à l'Éternel, ");
INSERT INTO frasbl_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","et ne leur feront pas porter l'iniquité qui les rend coupables lorsqu'ils mangent leurs choses saintes, car je suis l'Éternel qui les sanctifie.'\" ");
INSERT INTO frasbl_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Yahvé parla à Moïse, et dit : ");
INSERT INTO frasbl_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","Parle à Aaron, à ses fils et à tous les enfants d'Israël, et tu leur diras : « Si quelqu'un de la maison d'Israël ou des étrangers en Israël présente une offrande, qu'il s'agisse d'un de leurs vœux ou d'une de leurs offrandes volontaires, qu'ils offrent à Yahvé en holocauste : ");
INSERT INTO frasbl_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","Afin que tu sois agréé, tu offriras un mâle sans défaut, parmi les taureaux, les moutons ou les chèvres. ");
INSERT INTO frasbl_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Mais tu n'offriras pas ce qui a un défaut, car cela ne sera pas agréé pour toi. ");
INSERT INTO frasbl_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Celui qui offrira à Yahvé un sacrifice d'actions de grâces pour l'accomplissement d'un vœu, ou pour une offrande volontaire du gros ou du menu bétail, sera parfait pour être accepté. Il n'aura aucun défaut. ");
INSERT INTO frasbl_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Tu n'offriras pas à l'Éternel un aveugle, un blessé, un mutilé, une verrue, un suppurant ou un ulcère, et tu n'en feras pas un sacrifice par le feu sur l'autel de l'Éternel. ");
INSERT INTO frasbl_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Soit un taureau ou un agneau qui a une difformité ou un défaut de ses parties, que vous pourrez offrir en offrande volontaire ; mais pour un vœu, il ne sera pas accepté. ");
INSERT INTO frasbl_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Vous n'offrirez pas à Yahvé ce qui a les testicules meurtris, écrasés, cassés ou coupés. Vous ne ferez pas cela dans votre pays. ");
INSERT INTO frasbl_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Vous n'offrirez rien de tout cela comme pain de votre Dieu, de la main d'un étranger, car il y a en eux de la corruption. Il y a en eux un défaut. Ils ne seront pas acceptés pour vous. »\" ");
INSERT INTO frasbl_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Yahvé parla à Moïse et dit : ");
INSERT INTO frasbl_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","« Lorsqu'un taureau, un mouton ou une chèvre naîtra, il restera sept jours avec sa mère. A partir du huitième jour, il sera accepté pour l'offrande d'un sacrifice consumé par le feu à Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Qu'il s'agisse d'une vache ou d'une brebis, vous ne l'égorgerez pas avec son petit en un seul jour. ");
INSERT INTO frasbl_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","« Lorsque tu offriras un sacrifice d'action de grâces à Yahvé, tu le sacrifieras pour être agréé. ");
INSERT INTO frasbl_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Il sera mangé le jour même ; tu n'en laisseras rien jusqu'au matin. Je suis Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","« C'est pourquoi vous garderez mes commandements et vous les mettrez en pratique. Je suis Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Vous ne profanerez pas mon saint nom, mais je serai sanctifié au milieu des enfants d'Israël. Je suis Yahvé, qui vous rend saints, ");
INSERT INTO frasbl_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","qui vous a fait sortir du pays d'Égypte, pour être votre Dieu. Je suis Yahvé. » ");
INSERT INTO frasbl_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Yahvé parla à Moïse et dit : ");
INSERT INTO frasbl_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","Parle aux enfants d'Israël et dis-leur : « Les fêtes de Yahvé, que vous proclamerez comme des convocations saintes, sont mes fêtes. ");
INSERT INTO frasbl_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","\"'On travaillera six jours, mais le septième jour est un sabbat de repos solennel, une sainte convocation ; vous ne ferez aucune espèce de travail. Vous ne ferez aucune espèce de travail. C'est un sabbat pour Yahvé dans toutes vos habitations. ");
INSERT INTO frasbl_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","\"'Voici les fêtes fixes de l'Éternel, les convocations saintes, que vous annoncerez au temps fixé. ");
INSERT INTO frasbl_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Le premier mois, le quatorzième jour du mois, au soir, c'est la Pâque de Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Le quinzième jour du même mois, c'est la fête des pains sans levain pour Yahvé. Pendant sept jours, vous mangerez des pains sans levain. ");
INSERT INTO frasbl_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Le premier jour, vous aurez une sainte convocation. Vous ne ferez aucun travail régulier. ");
INSERT INTO frasbl_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Mais pendant sept jours, tu offriras à l'Éternel un sacrifice consumé par le feu. Le septième jour, c'est une convocation sainte. Tu ne feras aucun travail régulier.'\" ");
INSERT INTO frasbl_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Yahvé parla à Moïse et dit : ");
INSERT INTO frasbl_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","Parle aux enfants d'Israël, et dis-leur : « Quand vous serez entrés dans le pays que je vous donne et que vous en aurez fait la moisson, vous apporterez au prêtre la gerbe des prémices de votre récolte. ");
INSERT INTO frasbl_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Il agitera la gerbe devant Yahvé, qui l'acceptera pour vous. Le lendemain du sabbat, le prêtre l'agitera. ");
INSERT INTO frasbl_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Le jour où tu agiteras la gerbe, tu offriras un agneau mâle sans défaut d'un an en holocauste à Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","L'offrande qui l'accompagnera sera de deux dixièmes d'épha de fleur de farine pétrie à l'huile, un sacrifice consumé par le feu à l'Éternel, d'une agréable odeur ; et la libation qui l'accompagnera sera de vin, la quatrième partie d'un hin. ");
INSERT INTO frasbl_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Tu ne mangeras ni pain, ni grain rôti, ni grain frais, jusqu'à ce jour même, jusqu'à ce que tu aies apporté le sacrifice de ton Dieu. C'est une loi perpétuelle pour vos générations, dans toutes vos habitations. ");
INSERT INTO frasbl_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","\"'Tu compteras à partir du lendemain du sabbat, depuis le jour où tu as apporté la gerbe de l'offrande ondulée : sept sabbats seront accomplis. ");
INSERT INTO frasbl_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Le lendemain du septième sabbat, tu compteras cinquante jours, et tu offriras une nouvelle offrande à l'Éternel. ");
INSERT INTO frasbl_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Vous apporterez de vos habitations deux pains pour l'offrande par agitation, faits de deux dixièmes d'épha de fleur de farine. Ils seront cuits au levain, comme prémices à Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Tu présenteras avec les pains sept agneaux sans défaut d'un an, un jeune taureau et deux béliers. Ils seront un holocauste à l'Éternel, avec l'offrande et la libation, un sacrifice consumé par le feu, d'une agréable odeur à l'Éternel. ");
INSERT INTO frasbl_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Tu offriras un bouc en sacrifice pour le péché et deux agneaux mâles d'un an en sacrifice d'actions de grâces. ");
INSERT INTO frasbl_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Le prêtre les agitera avec le pain des prémices en sacrifice d'agitation devant l'Éternel, avec les deux agneaux. Ils seront consacrés à l'Éternel pour le prêtre. ");
INSERT INTO frasbl_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Le jour même, vous proclamerez qu'il y aura pour vous une convocation sainte. Vous ne ferez aucun travail régulier. C'est une loi pour toujours dans toutes vos habitations, de génération en génération. ");
INSERT INTO frasbl_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","\"'Quand tu moissonneras la récolte de ton pays, tu ne moissonneras pas entièrement dans les coins de ton champ. Tu ne recueilleras pas les glanures de ta récolte. Tu les laisseras aux pauvres et à l'étranger. Je suis Yahvé ton Dieu. » ");
INSERT INTO frasbl_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Yahvé parla à Moïse, et dit : ");
INSERT INTO frasbl_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","Parle aux enfants d'Israël, et dis : « Au septième mois, le premier jour du mois, il y aura pour vous un repos solennel, un mémorial où l'on sonnera des trompettes, une sainte convocation. ");
INSERT INTO frasbl_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Vous ne ferez aucun travail régulier. Vous offrirez à Yahvé un sacrifice consumé par le feu. » ");
INSERT INTO frasbl_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Yahvé parla à Moïse, et dit : ");
INSERT INTO frasbl_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","« Le dixième jour de ce septième mois, ce sera le jour des expiations. Ce sera pour vous une convocation sainte. Vous vous humilierez et vous offrirez à Yahvé un sacrifice consumé par le feu. ");
INSERT INTO frasbl_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Ce jour-là, vous ne ferez aucune espèce de travail, car c'est un jour d'expiation, afin de faire l'expiation pour vous devant l'Éternel, votre Dieu. ");
INSERT INTO frasbl_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","En effet, celui qui ne renoncera pas à lui-même en ce même jour sera retranché de son peuple. ");
INSERT INTO frasbl_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Celui qui fera un travail quelconque ce jour-là, je le ferai disparaître du milieu de son peuple. ");
INSERT INTO frasbl_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Vous ne ferez aucune espèce de travail : c'est une loi perpétuelle, de génération en génération, dans toutes vos habitations. ");
INSERT INTO frasbl_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Ce sera pour vous un sabbat de repos solennel, et vous renoncerez à vous-mêmes. Le neuvième jour du mois, le soir, d'un soir à l'autre, vous observerez votre sabbat. » ");
INSERT INTO frasbl_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Yahvé parla à Moïse et dit : ");
INSERT INTO frasbl_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","Parle aux enfants d'Israël, et dis : Le quinzième jour de ce septième mois, c'est la fête des tentes, pendant sept jours, pour Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Le premier jour, il y aura une convocation sainte. Vous ne ferez aucun travail régulier. ");
INSERT INTO frasbl_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Pendant sept jours, vous offrirez un sacrifice consumé par le feu à l'Éternel. Le huitième jour sera pour vous une convocation sainte. Vous offrirez un sacrifice consumé par le feu à Yahvé. C'est une assemblée solennelle ; vous ne ferez aucun travail régulier. ");
INSERT INTO frasbl_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","\"'Voici les fêtes fixées par Yahvé, que vous proclamerez comme des convocations saintes, pour offrir à Yahvé un sacrifice consumé par le feu, un holocauste, une offrande de repas, un sacrifice et des libations, chacun à son jour - ");
INSERT INTO frasbl_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","en plus des sabbats de Yahvé, et en plus de vos dons, et en plus de tous vos vœux, et en plus de toutes vos offrandes volontaires, que vous donnez à Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","\"'Le quinzième jour du septième mois, lorsque vous aurez récolté les fruits du pays, vous célébrerez la fête de Yahvé pendant sept jours. Le premier jour, il y aura un repos solennel, et le huitième jour, un repos solennel. ");
INSERT INTO frasbl_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Tu prendras le premier jour les fruits des arbres majestueux, les branches des palmiers, les rameaux des arbres touffus et les saules du ruisseau, et tu te réjouiras devant l'Éternel, ton Dieu, pendant sept jours. ");
INSERT INTO frasbl_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Tu le célébreras comme une fête de l'Éternel sept jours par an. C'est une loi pour toujours, de génération en génération. Vous la célébrerez au septième mois. ");
INSERT INTO frasbl_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Vous habiterez dans des abris temporaires pendant sept jours. Tous ceux qui sont nés en Israël habiteront dans des abris temporaires, ");
INSERT INTO frasbl_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","afin que vos générations sachent que j'ai fait habiter les enfants d'Israël dans des abris temporaires lorsque je les ai fait sortir du pays d'Égypte. Je suis Yahvé ton Dieu. » ");
INSERT INTO frasbl_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Moïse déclara aux enfants d'Israël les fêtes fixées par Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","L'Éternel parla à Moïse, et dit : ");
INSERT INTO frasbl_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","Ordonne aux enfants d'Israël de t'apporter de l'huile d'olive pure, battue pour le feu, afin que la lampe brûle continuellement. ");
INSERT INTO frasbl_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","En dehors du voile du Témoignage, dans la Tente d'assignation, Aaron la tiendra en ordre, du soir au matin, devant Yahvé, en permanence. Ce sera une loi perpétuelle pour vos générations. ");
INSERT INTO frasbl_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Il fera fonctionner les lampes sur le chandelier en or pur, devant l'Éternel, en permanence. ");
INSERT INTO frasbl_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","« Tu prendras de la fleur de farine et tu en feras douze gâteaux : un gâteau contiendra deux dixièmes d'épha. ");
INSERT INTO frasbl_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Tu les placeras en deux rangs, six par rang, sur la table d'or pur, devant l'Éternel. ");
INSERT INTO frasbl_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Tu mettras de l'encens pur sur chaque rangée, afin qu'il serve de mémorial au pain, comme une offrande consumée par le feu à l'Éternel. ");
INSERT INTO frasbl_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Chaque jour de sabbat, il la dressera en permanence devant l'Éternel. C'est une alliance éternelle en faveur des enfants d'Israël. ");
INSERT INTO frasbl_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Elle sera pour Aaron et ses fils. Ils la mangeront dans un lieu saint, car elle est pour lui une chose très sainte parmi les offrandes de l'Éternel faites par feu, selon un statut perpétuel. » ");
INSERT INTO frasbl_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Le fils d'une femme israélite, dont le père était égyptien, sortit au milieu des enfants d'Israël ; le fils de la femme israélite et un homme d'Israël se disputèrent dans le camp. ");
INSERT INTO frasbl_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Le fils de la femme israélite blasphéma le Nom et maudit, et on l'amena à Moïse. Sa mère s'appelait Shelomith, fille de Dibri, de la tribu de Dan. ");
INSERT INTO frasbl_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Ils le mirent en détention jusqu'à ce que la volonté de Yahvé leur soit déclarée. ");
INSERT INTO frasbl_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Yahvé parla à Moïse et dit : ");
INSERT INTO frasbl_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","« Fais sortir du camp celui qui a maudit ; que tous ceux qui l'ont entendu posent leurs mains sur sa tête, et que toute l'assemblée le lapide. ");
INSERT INTO frasbl_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Tu parleras aux enfants d'Israël en disant : « Celui qui maudira son Dieu portera la peine de son péché. ");
INSERT INTO frasbl_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Celui qui blasphème le nom de l'Éternel sera puni de mort. Toute l'assemblée le lapidera certainement. L'étranger, comme le natif, sera mis à mort s'il blasphème le Nom. ");
INSERT INTO frasbl_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","\"'Celui qui frappera un homme mortellement sera puni de mort. ");
INSERT INTO frasbl_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Celui qui frappera mortellement un animal lui rendra la pareille, vie pour vie. ");
INSERT INTO frasbl_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Si quelqu'un blesse son prochain, il lui sera fait comme il a fait : ");
INSERT INTO frasbl_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","fracture pour fracture, œil pour œil, dent pour dent. Il lui sera fait comme il a fait du mal à quelqu'un. ");
INSERT INTO frasbl_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Celui qui tuera un animal le réparera, et celui qui tuera un homme sera mis à mort. ");
INSERT INTO frasbl_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Vous aurez une même loi pour l'étranger comme pour l'indigène, car je suis Yahvé votre Dieu.'\" ");
INSERT INTO frasbl_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Moïse parla aux enfants d'Israël. Ils firent sortir du camp celui qui avait maudit, et ils le lapidèrent. Les enfants d'Israël firent ce que Yahvé avait ordonné à Moïse. ");
INSERT INTO frasbl_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Yahvé dit à Moïse sur la montagne du Sinaï : ");
INSERT INTO frasbl_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","Parle aux enfants d'Israël, et dis-leur : Quand vous serez entrés dans le pays que je vous donne, le pays observera un sabbat en l'honneur de Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Vous sèmerez votre champ pendant six ans, vous taillerez votre vigne pendant six ans et vous en recueillerez les fruits. ");
INSERT INTO frasbl_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Mais la septième année, il y aura pour le pays un sabbat de repos solennel, un sabbat pour Yahvé. Tu ne sèmeras pas ton champ et tu ne tailleras pas ta vigne. ");
INSERT INTO frasbl_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Tu ne moissonneras pas ce qui pousse tout seul dans ta moisson, et tu ne vendangeras pas les raisins de ta vigne non taillée. Ce sera une année de repos solennel pour le pays. ");
INSERT INTO frasbl_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Le sabbat du pays vous servira de nourriture, pour vous-même, pour votre serviteur, pour votre servante, pour votre mercenaire, et pour l'étranger qui vit chez vous. ");
INSERT INTO frasbl_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","Tout le produit de ton bétail et des animaux qui sont dans ton pays servira de nourriture. ");
INSERT INTO frasbl_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","\"'Tu compteras sept sabbats d'années, sept fois sept ans, et il y aura pour toi des jours de sept sabbats d'années, soit quarante-neuf ans. ");
INSERT INTO frasbl_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Puis tu sonneras de la trompette à haute voix le dixième jour du septième mois. Le jour des expiations, tu sonneras de la trompette dans tout ton pays. ");
INSERT INTO frasbl_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Tu sanctifieras la cinquantième année et tu proclameras la liberté dans tout le pays pour tous ses habitants. Ce sera pour vous un jubilé ; chacun de vous retournera dans sa propriété, et chacun de vous retournera dans sa famille. ");
INSERT INTO frasbl_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Cette cinquantième année sera pour vous un jubilé. Pendant cette période, vous ne sèmerez pas, vous ne moissonnerez pas ce qui pousse tout seul et vous ne cueillerez pas la vigne non taillée. ");
INSERT INTO frasbl_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Car c'est un jubilé ; elle sera pour vous une chose sainte. Vous mangerez de ce qu'elle produira dans les champs. ");
INSERT INTO frasbl_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","\"'En cette année de jubilé, chacun de vous retournera dans sa propriété. ");
INSERT INTO frasbl_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","\"'Si tu vends quelque chose à ton prochain, ou si tu achètes quelque chose de ton prochain, tu ne te feras pas de tort l'un à l'autre. ");
INSERT INTO frasbl_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Tu achèteras de ton prochain en fonction du nombre d'années après le Jubilé. Il te vendra selon le nombre d'années des récoltes. ");
INSERT INTO frasbl_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Tu en augmenteras le prix selon la longueur des années, et tu en diminueras le prix selon la brièveté des années, car il te vendra le nombre des récoltes. ");
INSERT INTO frasbl_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Vous ne vous ferez pas de tort les uns aux autres, mais vous craindrez votre Dieu, car je suis Yahvé votre Dieu. ");
INSERT INTO frasbl_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","\"'C'est pourquoi vous observerez mes lois, vous garderez mes ordonnances et vous les mettrez en pratique, et vous habiterez le pays en sécurité. ");
INSERT INTO frasbl_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Le pays donnera son fruit, vous mangerez à satiété et vous y habiterez en sécurité. ");
INSERT INTO frasbl_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Si vous disiez : « Que mangerons-nous la septième année ? Voici, nous ne sèmerons pas, et nous ne recueillerons pas nos produits » ; ");
INSERT INTO frasbl_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","mais j'ordonnerai ma bénédiction sur vous la sixième année, et elle donnera du fruit pendant trois ans. ");
INSERT INTO frasbl_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Vous sèmerez la huitième année, et vous mangerez des fruits de l'ancienne réserve jusqu'à la neuvième année. Jusqu'à ce qu'elle produise des fruits, tu mangeras de l'ancienne réserve. ");
INSERT INTO frasbl_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","\"'Le pays ne sera pas vendu à perpétuité, car le pays m'appartient ; vous êtes des étrangers et vous vivez comme des étrangers chez moi. ");
INSERT INTO frasbl_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Dans tout le pays que vous posséderez, vous accorderez un rachat de la terre. ");
INSERT INTO frasbl_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","\"'Si ton frère s'appauvrit et vend une partie de ses biens, son parent le plus proche viendra racheter ce que son frère a vendu. ");
INSERT INTO frasbl_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Si un homme n'a personne pour le racheter, et qu'il devienne prospère et trouve des moyens suffisants pour le racheter, ");
INSERT INTO frasbl_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","qu'il fasse le compte des années écoulées depuis sa vente, et qu'il restitue le surplus à celui à qui il l'a vendu ; et il rentrera dans ses biens. ");
INSERT INTO frasbl_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Mais s'il ne peut le récupérer pour lui-même, ce qu'il a vendu restera entre les mains de celui qui l'a acheté jusqu'à l'année du Jubilé. Au Jubilé, il sera libéré, et il retournera dans sa propriété. ");
INSERT INTO frasbl_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","\"'Si un homme vend une maison d'habitation dans une ville fortifiée, il peut la racheter dans l'année qui suit sa vente. Pendant une année entière, il aura le droit de rachat. ");
INSERT INTO frasbl_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Si elle n'est pas rachetée dans l'espace d'une année entière, la maison qui se trouve dans la ville fortifiée sera garantie à perpétuité à celui qui l'a achetée, de génération en génération. Elle ne sera pas libérée au Jubilé. ");
INSERT INTO frasbl_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Mais les maisons des villages qui ne sont pas entourés de murs seront comptabilisées avec les champs de la campagne : elles pourront être rachetées, et elles seront libérées au Jubilé. ");
INSERT INTO frasbl_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","\"'Néanmoins, dans les villes des Lévites, les Lévites peuvent racheter les maisons des villes de leur possession à tout moment. ");
INSERT INTO frasbl_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Les Lévites peuvent racheter la maison qui a été vendue, ainsi que la ville de sa possession, et elle sera libérée au Jubilé ; car les maisons des villes des Lévites sont leur possession parmi les enfants d'Israël. ");
INSERT INTO frasbl_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Mais le champ des pâturages de leurs villes ne pourra pas être vendu, car c'est leur possession perpétuelle. ");
INSERT INTO frasbl_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","\"'Si ton frère est devenu pauvre, et que sa main ne puisse pas subvenir à ses besoins parmi vous, tu le soutiendras. Il vivra avec toi comme un étranger et un résident temporaire. ");
INSERT INTO frasbl_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Tu ne prendras de lui aucun intérêt ni aucun profit, mais tu craindras ton Dieu, afin que ton frère puisse vivre parmi toi. ");
INSERT INTO frasbl_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Tu ne lui prêteras pas ton argent à intérêt, et tu ne lui donneras pas ta nourriture à profit. ");
INSERT INTO frasbl_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Je suis Yahvé, ton Dieu, qui t'ai fait sortir du pays d'Égypte, pour te donner le pays de Canaan, et pour être ton Dieu. ");
INSERT INTO frasbl_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","\"'Si ton frère est devenu pauvre au milieu de toi et qu'il se vend à toi, tu ne le feras pas servir comme esclave. ");
INSERT INTO frasbl_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Il sera chez toi comme mercenaire et comme résident temporaire ; il servira chez toi jusqu'à l'année du jubilé. ");
INSERT INTO frasbl_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Puis il sortira de chez toi, lui et ses enfants avec lui, et il retournera dans sa famille et dans la propriété de ses pères. ");
INSERT INTO frasbl_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Car ce sont mes serviteurs, que j'ai fait sortir du pays d'Égypte. Ils ne seront pas vendus comme esclaves. ");
INSERT INTO frasbl_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Tu ne domineras pas sur lui avec dureté, mais tu craindras ton Dieu. ");
INSERT INTO frasbl_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","\"'Quant à tes esclaves mâles et femelles, que tu peux avoir des nations qui t'entourent, tu pourras acheter d'elles des esclaves mâles et femelles. ");
INSERT INTO frasbl_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","De plus, tu pourras acheter des enfants des étrangers qui vivent parmi toi, et de leurs familles qui sont avec toi, ceux qu'ils auront conçus dans ton pays ; et ils seront ta propriété. ");
INSERT INTO frasbl_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Tu pourras en faire un héritage pour tes enfants après toi, pour qu'ils en prennent possession. Tu pourras prendre d'eux tes esclaves pour toujours, mais tu ne domineras pas avec dureté sur tes frères, les enfants d'Israël, les uns sur les autres. ");
INSERT INTO frasbl_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","\"'Si un étranger ou un résident temporaire chez toi devient riche, et que ton frère à côté de lui soit devenu pauvre, et qu'il se vende à l'étranger ou à l'étranger qui vit parmi vous, ou à un membre de la famille de l'étranger, ");
INSERT INTO frasbl_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","après avoir été vendu, il pourra être racheté. L'un de ses frères pourra le racheter ; ");
INSERT INTO frasbl_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","ou son oncle, ou le fils de son oncle, pourra le racheter, ou tout proche parent de sa famille pourra le racheter ; ou s'il est devenu riche, il pourra se racheter lui-même. ");
INSERT INTO frasbl_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Il comptera avec celui qui l'a acheté depuis l'année où il s'est vendu à lui jusqu'à l'année du Jubilé. Le prix de sa vente sera fonction du nombre d'années ; il sera avec lui selon le temps d'un mercenaire. ");
INSERT INTO frasbl_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","S'il reste encore beaucoup d'années, il restituera le prix de son rachat sur l'argent pour lequel il a été acheté. ");
INSERT INTO frasbl_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","S'il ne reste que quelques années jusqu'à l'année du jubilé, on fera le compte avec lui ; il rendra le prix de son rachat selon ses années de service. ");
INSERT INTO frasbl_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Il sera avec lui comme un serviteur loué d'année en année. Il ne régnera pas sur lui avec dureté à tes yeux. ");
INSERT INTO frasbl_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","S'il n'est pas racheté par ces moyens, il sera libéré l'année du Jubilé, lui et ses enfants avec lui. ");
INSERT INTO frasbl_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Car pour moi, les enfants d'Israël sont des serviteurs, ce sont mes serviteurs que j'ai fait sortir du pays d'Égypte. Je suis Yahvé votre Dieu. ");
INSERT INTO frasbl_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","\"'Vous ne vous ferez pas d'idoles, vous n'élèverez pas d'image taillée ni de statue, et vous ne placerez pas de pierre figurée dans votre pays pour vous prosterner devant elle, car je suis Yahvé votre Dieu. ");
INSERT INTO frasbl_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","\"'Tu observeras mes sabbats et tu respecteras mon sanctuaire. Je suis Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","\"'Si tu marches dans mes statuts, si tu gardes mes commandements et si tu les mets en pratique, ");
INSERT INTO frasbl_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","je te donnerai tes pluies en leur saison, et la terre donnera ses produits, et les arbres des champs donneront leurs fruits. ");
INSERT INTO frasbl_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Ton battage durera jusqu'à la vendange, et la vendange durera jusqu'à l'époque des semailles. Tu mangeras ton pain à satiété, et tu habiteras ton pays en sécurité. ");
INSERT INTO frasbl_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","\"'Je donnerai la paix dans le pays, et vous vous coucherez, et personne ne vous fera peur. Je ferai disparaître du pays les animaux malfaisants, et l'épée ne passera pas par ton pays. ");
INSERT INTO frasbl_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Vous poursuivrez vos ennemis, et ils tomberont devant vous par l'épée. ");
INSERT INTO frasbl_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Cinq d'entre vous en poursuivront cent, et cent d'entre vous en poursuivront dix mille ; et vos ennemis tomberont devant vous par l'épée. ");
INSERT INTO frasbl_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","\"'Je te respecterai, je te rendrai fécond, je te multiplierai, et j'établirai mon alliance avec toi. ");
INSERT INTO frasbl_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Vous mangerez de vieilles provisions longtemps gardées, et vous éliminerez l'ancien à cause du nouveau. ");
INSERT INTO frasbl_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Je dresserai ma tente au milieu de vous, et mon âme n'aura pas horreur de vous. ");
INSERT INTO frasbl_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Je marcherai au milieu de vous, je serai votre Dieu, et vous serez mon peuple. ");
INSERT INTO frasbl_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Je suis Yahvé, ton Dieu, qui t'ai fait sortir du pays d'Égypte, pour que tu ne sois pas leur esclave. J'ai brisé les barres de votre joug, et je vous ai fait marcher debout. ");
INSERT INTO frasbl_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","« Mais si tu ne m'écoutes pas et ne mets pas en pratique tous ces commandements, ");
INSERT INTO frasbl_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","si tu rejettes mes lois et si ton âme a en horreur mes ordonnances, de sorte que tu ne mettes pas en pratique tous mes commandements et que tu rompes mon alliance, ");
INSERT INTO frasbl_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","voici ce que je te ferai : Je mettrai sur toi la terreur, la consomption et la fièvre, qui dévorent les yeux et font dépérir l'âme. Vous sèmerez en vain votre semence, car vos ennemis la mangeront. ");
INSERT INTO frasbl_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Je tournerai ma face contre toi, et tu seras frappé devant tes ennemis. Ceux qui te haïssent domineront sur toi, et tu fuiras quand personne ne te poursuivra. ");
INSERT INTO frasbl_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","« Si, malgré tout cela, tu ne m'écoutes pas, je te châtierai sept fois plus pour tes péchés. ");
INSERT INTO frasbl_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Je briserai l'orgueil de ta puissance, je rendrai ton ciel semblable à du fer et ton sol à du bronze. ");
INSERT INTO frasbl_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Ta force sera dépensée en vain, car ta terre ne donnera pas ses produits, et les arbres du pays ne donneront pas leurs fruits. ");
INSERT INTO frasbl_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","\"'Si vous marchez contre moi, si vous ne m'écoutez pas, je ferai venir sur vous sept fois plus de fléaux, selon vos péchés. ");
INSERT INTO frasbl_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","J'enverrai parmi vous les bêtes sauvages, qui vous priveront de vos enfants, détruiront votre bétail et vous rendront peu nombreux. Vos routes seront désertées. ");
INSERT INTO frasbl_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","\"'Si par ces choses vous ne voulez pas revenir à moi, mais si vous voulez marcher contre moi, ");
INSERT INTO frasbl_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","alors je marcherai aussi contre vous ; et je vous frapperai, moi, sept fois pour vos péchés. ");
INSERT INTO frasbl_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Je ferai venir sur vous une épée qui exécutera la vengeance de l'alliance. Vous serez rassemblés dans vos villes, et j'enverrai la peste au milieu de vous. Vous serez livrés entre les mains de l'ennemi. ");
INSERT INTO frasbl_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Quand je briserai votre bâton de pain, dix femmes cuiront votre pain dans un seul four, et elles vous livreront votre pain au poids. Tu mangeras, et tu ne seras pas rassasié. ");
INSERT INTO frasbl_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","\"'Si, malgré cela, vous ne m'écoutez pas, mais si vous marchez à l'encontre de moi, ");
INSERT INTO frasbl_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","alors je marcherai à l'encontre de vous dans la colère. Je vous châtierai aussi sept fois pour vos péchés. ");
INSERT INTO frasbl_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Vous mangerez la chair de vos fils, et vous mangerez la chair de vos filles. ");
INSERT INTO frasbl_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Je détruirai vos hauts lieux, j'abattrai vos autels à encens, je jetterai vos cadavres sur les cadavres de vos idoles, et mon âme vous aura en horreur. ");
INSERT INTO frasbl_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Je dévasterai vos villes, et je réduirai vos sanctuaires en ruines. Je ne prendrai pas plaisir à l'odeur agréable de vos offrandes. ");
INSERT INTO frasbl_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Je réduirai le pays en ruines, et vos ennemis qui l'habitent en seront stupéfaits. ");
INSERT INTO frasbl_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Je vous disperserai parmi les nations, et je tirerai l'épée après vous. Votre pays sera dévasté, et vos villes seront ravagées. ");
INSERT INTO frasbl_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Alors le pays jouira de ses sabbats, tant qu'il sera dévasté et que vous serez dans le pays de vos ennemis. Même alors, le pays se reposera et jouira de ses sabbats. ");
INSERT INTO frasbl_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Tant qu'il sera dévasté, il aura le repos, le repos qu'il n'a pas eu pendant vos sabbats, lorsque vous viviez sur lui. ");
INSERT INTO frasbl_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","\"'Quant à ceux d'entre vous qui restent, j'enverrai dans leur cœur une lassitude dans les pays de leurs ennemis. Le bruit d'une feuille morte les mettra en fuite ; ils fuiront comme on fuit devant l'épée. Ils tomberont quand personne ne les poursuivra. ");
INSERT INTO frasbl_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Ils tomberont les uns sur les autres, comme devant l'épée, quand personne ne les poursuivra. Vous n'aurez pas la force de résister à vos ennemis. ");
INSERT INTO frasbl_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Tu périras parmi les nations. Le pays de vos ennemis vous dévorera. ");
INSERT INTO frasbl_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Ceux d'entre vous qui resteront dépériront dans leur iniquité au pays de leurs ennemis, et ils dépériront avec eux dans les iniquités de leurs pères. ");
INSERT INTO frasbl_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","\"'S'ils confessent leur iniquité et l'iniquité de leurs pères, dans la faute qu'ils ont commise envers moi, et aussi que, parce qu'ils ont marché contre moi, ");
INSERT INTO frasbl_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","j'ai aussi marché contre eux, et je les ai amenés dans le pays de leurs ennemis ; Si donc leur cœur incirconcis s'humilie, et s'ils acceptent le châtiment de leur iniquité, ");
INSERT INTO frasbl_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","je me souviendrai de mon alliance avec Jacob, de mon alliance avec Isaac, et de mon alliance avec Abraham, et je me souviendrai du pays. ");
INSERT INTO frasbl_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Le pays leur restera, et il jouira de ses sabbats, tandis qu'il sera dévasté sans eux ; et ils accepteront le châtiment de leur iniquité, parce qu'ils ont rejeté mes ordonnances et que leur âme a eu mes lois en horreur. ");
INSERT INTO frasbl_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Pour autant, lorsqu'ils seront dans le pays de leurs ennemis, je ne les rejetterai pas et je ne les détesterai pas, pour les détruire complètement et rompre mon alliance avec eux, car je suis Yahvé, leur Dieu. ");
INSERT INTO frasbl_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Mais je me souviendrai, à cause d'eux, de l'alliance de leurs ancêtres, que j'ai fait sortir du pays d'Égypte aux yeux des nations, pour être leur Dieu. Je suis Yahvé. » ");
INSERT INTO frasbl_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Tels sont les statuts, les ordonnances et les lois que Yahvé a établis entre lui et les enfants d'Israël sur la montagne de Sinaï, par Moïse. ");
INSERT INTO frasbl_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","L'Éternel parla à Moïse, et dit : ");
INSERT INTO frasbl_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","Parle aux enfants d'Israël, et tu leur diras : « Lorsqu'un homme consacrera une personne à l'Éternel par un vœu, selon l'estimation que tu en feras, ");
INSERT INTO frasbl_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","l'estimation d'un homme de vingt à soixante ans sera de cinquante sicles d'argent, selon le sicle du sanctuaire. ");
INSERT INTO frasbl_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","S'il s'agit d'une femme, ton évaluation sera de trente sicles. ");
INSERT INTO frasbl_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Si la personne est âgée de cinq à vingt ans, ton évaluation sera de vingt sicles pour un homme et de dix sicles pour une femme. ");
INSERT INTO frasbl_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Si la personne est âgée d'un mois à cinq ans, ton évaluation sera de cinq sicles d'argent pour un mâle, et de trois sicles d'argent pour une femelle. ");
INSERT INTO frasbl_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Si la personne est âgée de soixante ans et plus, si c'est un homme, ton évaluation sera de quinze sicles, et pour une femme de dix sicles. ");
INSERT INTO frasbl_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Mais s'il est plus pauvre que ton estimation, on le présentera au prêtre, qui lui attribuera une valeur. Le prêtre lui attribuera une valeur en fonction de sa capacité de paiement. ");
INSERT INTO frasbl_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","\"'S'il s'agit d'un animal dont on fait une offrande à Yahvé, tout ce qu'un homme donne de cet animal à Yahvé devient saint. ");
INSERT INTO frasbl_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Il ne le modifiera pas et ne l'échangera pas, ni un bien contre un mal, ni un mal contre un bien. S'il échange un animal contre un autre, l'animal et ce contre quoi il est échangé seront saints. ");
INSERT INTO frasbl_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","S'il s'agit d'un animal impur, dont on ne fait pas d'offrande à l'Éternel, on le présentera au prêtre, ");
INSERT INTO frasbl_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","et le prêtre jugera s'il est bon ou mauvais. Il en sera ainsi selon l'évaluation du prêtre. ");
INSERT INTO frasbl_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Mais s'il accepte de le racheter, il ajoutera à son évaluation le cinquième de son prix. ");
INSERT INTO frasbl_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","\"'Lorsqu'un homme consacre sa maison à Yahvé, le prêtre l'évaluera pour savoir si elle est bonne ou mauvaise. Elle sera jugée par le prêtre. ");
INSERT INTO frasbl_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Si celui qui l'a consacrée veut racheter sa maison, il y ajoutera le cinquième de l'argent de ton évaluation, et elle lui appartiendra. ");
INSERT INTO frasbl_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","\"'Si un homme consacre à Yahvé une partie du champ qu'il possède, vous l'évaluerez en fonction de sa semence. La semence d'un homer d'orge sera évaluée à cinquante sicles d'argent. ");
INSERT INTO frasbl_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","S'il consacre son champ à partir de l'année jubilaire, il sera maintenu selon votre évaluation. ");
INSERT INTO frasbl_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Mais s'il dédie son champ après le Jubilé, le prêtre lui comptera l'argent en fonction des années qui restent à courir jusqu'à l'année du Jubilé, et une déduction sera faite de votre évaluation. ");
INSERT INTO frasbl_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Si celui qui a consacré le champ veut bien le racheter, il y ajoutera le cinquième de l'argent de votre évaluation, et il lui appartiendra. ");
INSERT INTO frasbl_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","S'il ne rachète pas le champ, ou s'il l'a vendu à un autre homme, il ne sera plus racheté ; ");
INSERT INTO frasbl_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","mais le champ, lorsqu'il sortira au Jubilé, sera consacré à l'Éternel, comme un champ consacré. Il appartiendra aux prêtres. ");
INSERT INTO frasbl_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","\"'S'il consacre à l'Éternel un champ qu'il a acheté et qui n'est pas du domaine de sa propriété, ");
INSERT INTO frasbl_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","le prêtre lui calculera la valeur de ton évaluation jusqu'à l'année du Jubilé, et il donnera ton évaluation ce jour-là, comme une chose sainte à l'Éternel. ");
INSERT INTO frasbl_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","L'année du Jubilé, le champ retournera à celui qui l'a acheté, à celui à qui appartient la possession du pays. ");
INSERT INTO frasbl_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Toutes vos évaluations seront faites selon le sicle du sanctuaire : vingt gérahs pour un sicle. ");
INSERT INTO frasbl_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","\"'Cependant, le premier-né des animaux, qui appartient à Yahvé comme un premier-né, personne ne peut le consacrer, qu'il s'agisse d'un bœuf ou d'un mouton. Il appartient à l'Éternel. ");
INSERT INTO frasbl_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","S'il s'agit d'un animal impur, on le rachètera selon votre évaluation, et on y ajoutera le cinquième de son prix ; ou bien, s'il n'est pas racheté, on le vendra selon votre évaluation. ");
INSERT INTO frasbl_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","\"'Toutefois, aucun objet consacré qu'un homme consacre à Yahvé parmi tout ce qu'il possède, qu'il s'agisse d'hommes ou d'animaux, ou du champ de sa propriété, ne sera vendu ou racheté. Tout ce qui est consacré de façon permanente est très saint pour Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","\"'Aucun être dévoué à la destruction, qui sera dévoué d'entre les hommes, ne sera racheté. Il sera mis à mort. ");
INSERT INTO frasbl_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","\"'Toute la dîme du pays, qu'il s'agisse de la semence du pays ou du fruit des arbres, appartient à Yahvé. Elle est consacrée à Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Si un homme rachète quelque chose de sa dîme, il y ajoutera un cinquième. ");
INSERT INTO frasbl_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Toute la dîme du gros et du menu bétail, de tout ce qui passe sous le bâton, la dîme sera consacrée à l'Éternel. ");
INSERT INTO frasbl_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Il ne cherchera pas à savoir si elle est bonne ou mauvaise, et il ne l'échangera pas. S'il l'échange, elle sera sainte, ainsi que ce contre quoi elle est échangée. Il ne sera pas racheté. »\" ");
INSERT INTO frasbl_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Tels sont les commandements que Yahvé a prescrits à Moïse pour les enfants d'Israël sur le mont Sinaï. ");
INSERT INTO frasbl_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Yahvé parla à Moïse dans le désert de Sinaï, dans la tente de la Rencontre, le premier jour du second mois, la deuxième année après leur sortie du pays d'Égypte, et il dit : ");
INSERT INTO frasbl_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","« Recense toute l'assemblée des enfants d'Israël, selon leurs familles, selon les maisons de leurs pères, d'après le nombre de leurs noms, tous les mâles, un par un, ");
INSERT INTO frasbl_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","depuis l'âge de vingt ans et au-dessus, tous ceux qui sont en état de porter les armes en Israël. Toi et Aaron, vous les compterez selon leurs divisions. ");
INSERT INTO frasbl_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Il y aura avec vous un homme de chaque tribu, chacun à la tête de la maison de ses pères. ");
INSERT INTO frasbl_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Voici les noms des hommes qui se tiendront à vos côtés : De Reuben : Elizur, fils de Shedeur. ");
INSERT INTO frasbl_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","De Siméon : Shelumiel, fils de Zurishaddai. ");
INSERT INTO frasbl_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","De Juda : Nahshon, fils d'Amminadab. ");
INSERT INTO frasbl_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","D'Issachar : Nethanel, fils de Zuar. ");
INSERT INTO frasbl_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","De Zabulon : Eliab, fils de Helon. ");
INSERT INTO frasbl_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Des fils de Joseph : d'Éphraïm : Élischama, fils d'Ammihud ; de Manassé : Gamaliel, fils de Pedahzur. ");
INSERT INTO frasbl_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","De Benjamin : Abidan, fils de Gideoni. ");
INSERT INTO frasbl_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","De Dan : Ahiezer, fils d'Ammishaddai. ");
INSERT INTO frasbl_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","d'Asher : Pagiel, fils d'Ochran. ");
INSERT INTO frasbl_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","De Gad : Eliasaph, fils de Deuel. ");
INSERT INTO frasbl_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Pour Nephtali : Ahira, fils d'Enan. » ");
INSERT INTO frasbl_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Voici les appelés de l'assemblée, les princes des tribus de leurs pères ; ils étaient les chefs des milliers d'Israël. ");
INSERT INTO frasbl_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Moïse et Aaron prirent ces hommes qui sont mentionnés par leur nom. ");
INSERT INTO frasbl_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","Ils convoquèrent toute l'assemblée le premier jour du second mois, et ils déclarèrent leurs ancêtres selon leurs familles, selon les maisons de leurs pères, d'après le nombre des noms, depuis l'âge de vingt ans et au-dessus, un par un. ");
INSERT INTO frasbl_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Comme Yahvé l'avait ordonné à Moïse, celui-ci les compta dans le désert de Sinaï. ");
INSERT INTO frasbl_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Les fils de Ruben, premiers-nés d'Israël, selon leurs générations, selon leurs familles, selon les maisons de leurs pères, d'après le nombre des noms, un par un, tous les mâles depuis l'âge de vingt ans et au-dessus, tous ceux qui étaient en état de porter les armes. ");
INSERT INTO frasbl_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Ceux de la tribu de Ruben dont on fit le dénombrement furent quarante-six mille cinq cents. ");
INSERT INTO frasbl_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","On fit le dénombrement des fils de Siméon, selon leurs générations, selon leurs familles, selon les maisons de leurs pères, en comptant les noms, un par un, tous les mâles depuis l'âge de vingt ans et au-dessus, tous ceux qui étaient en état de porter les armes. ");
INSERT INTO frasbl_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","On fit le dénombrement des fils de la tribu de Siméon : cinquante-neuf mille trois cents. ");
INSERT INTO frasbl_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","On enregistra les fils de Gad, selon leurs générations, selon leurs familles, selon les maisons de leurs pères, en comptant les noms depuis l'âge de vingt ans et au-dessus, tous ceux qui étaient en état de porter les armes. ");
INSERT INTO frasbl_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","On compta quarante-cinq mille six cent cinquante hommes de la tribu de Gad. ");
INSERT INTO frasbl_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Des fils de Juda, selon leurs générations, selon leurs familles, selon les maisons de leurs pères, en comptant les noms depuis l'âge de vingt ans et au-dessus, tous ceux qui étaient propres à faire la guerre : ");
INSERT INTO frasbl_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","ceux de la tribu de Juda dont on fit le dénombrement furent soixante-quatorze mille six cents. ");
INSERT INTO frasbl_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","On enregistra les fils d'Issacar, selon leurs familles, selon les maisons de leurs pères, d'après le nombre des noms, depuis l'âge de vingt ans et au-dessus, tous ceux qui étaient en état de porter les armes. ");
INSERT INTO frasbl_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","On fit le dénombrement des fils de la tribu d'Issacar : cinquante-quatre mille quatre cents. ");
INSERT INTO frasbl_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","On enregistra les fils de Zabulon, selon leurs familles, selon les maisons de leurs pères, d'après le nombre des noms, depuis l'âge de vingt ans et au-dessus, tous ceux qui étaient propres à faire la guerre : ");
INSERT INTO frasbl_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","ceux de la tribu de Zabulon dont on fit le dénombrement furent cinquante-sept mille quatre cents. ");
INSERT INTO frasbl_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Fils de Joseph : des fils d'Éphraïm, selon leurs générations, selon leurs familles, selon les maisons de leurs pères, en comptant les noms depuis l'âge de vingt ans et au-dessus, tous ceux qui étaient propres à faire la guerre : ");
INSERT INTO frasbl_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","ceux de la tribu d'Éphraïm dont on fit le dénombrement furent quarante mille cinq cents. ");
INSERT INTO frasbl_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","On enregistra les fils de Manassé, selon leurs familles, selon les maisons de leurs pères, d'après le nombre des noms, depuis l'âge de vingt ans et au-dessus, tous ceux qui étaient propres à faire la guerre : ");
INSERT INTO frasbl_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","ceux de la tribu de Manassé dont on fit le dénombrement furent trente-deux mille deux cents. ");
INSERT INTO frasbl_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","On enregistra les fils de Benjamin, selon leurs familles, selon les maisons de leurs pères, en comptant les noms depuis l`âge de vingt ans et au-dessus, tous ceux qui étaient propres à faire la guerre : ");
INSERT INTO frasbl_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","ceux de la tribu de Benjamin dont on fit le dénombrement furent trente-cinq mille quatre cents. ");
INSERT INTO frasbl_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","On enregistra les fils de Dan, selon leurs familles, selon les maisons de leurs pères, d'après le nombre des noms, depuis l'âge de vingt ans et au-dessus, tous ceux qui étaient propres à faire la guerre : ");
INSERT INTO frasbl_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","ceux de la tribu de Dan dont on fit le dénombrement furent soixante-deux mille sept cents. ");
INSERT INTO frasbl_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","On enregistra les fils d`Aser, selon leurs familles, selon les maisons de leurs pères, en comptant les noms depuis l`âge de vingt ans et au-dessus, tous ceux qui étaient propres à faire la guerre : ");
INSERT INTO frasbl_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","ceux de la tribu d'Aser dont on fit le dénombrement furent quarante et un mille cinq cents. ");
INSERT INTO frasbl_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","On enregistra les fils de Nephthali, selon leurs familles, selon les maisons de leurs pères, d'après le nombre des noms, depuis l'âge de vingt ans et au-dessus, tous ceux qui étaient propres à faire la guerre : ");
INSERT INTO frasbl_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","ceux de la tribu de Nephthali dont on fit le dénombrement furent cinquante-trois mille quatre cents. ");
INSERT INTO frasbl_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Ce sont là ceux dont Moïse et Aaron firent le compte, et les douze hommes qui furent princes d'Israël, chacun pour sa maison de pères. ");
INSERT INTO frasbl_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Tous ceux des enfants d'Israël qui furent comptés selon leurs maisons de pères, depuis l'âge de vingt ans et au-dessus, tous ceux qui étaient en état de porter les armes en Israël - ");
INSERT INTO frasbl_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","tous ceux qui furent comptés furent six cent trois mille cinq cent cinquante. ");
INSERT INTO frasbl_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Mais les Lévites, selon la tribu de leurs pères, ne furent pas comptés parmi eux. ");
INSERT INTO frasbl_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Car Yahvé avait parlé à Moïse, en disant : ");
INSERT INTO frasbl_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","« Tu ne compteras pas la tribu de Lévi et tu ne la recenseras pas parmi les enfants d'Israël ; ");
INSERT INTO frasbl_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","mais tu établiras les Lévites sur le tabernacle du témoignage, sur tout son mobilier et sur tout ce qui lui appartient. Ils porteront le tabernacle et tous ses ustensiles ; ils en prendront soin et camperont autour de lui. ");
INSERT INTO frasbl_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Lorsque le tabernacle devra être déplacé, les Lévites le descendront ; et lorsque le tabernacle devra être dressé, les Lévites le dresseront. L'étranger qui s'approchera sera mis à mort. ");
INSERT INTO frasbl_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Les enfants d'Israël dresseront leurs tentes, chacun selon son camp, chacun selon sa bannière, selon leurs divisions. ");
INSERT INTO frasbl_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Les Lévites camperont autour de la tente du Témoignage, afin qu'il n'y ait pas de colère sur l'assemblée des enfants d'Israël. Les Lévites seront responsables du Tabernacle du Témoignage. » ");
INSERT INTO frasbl_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Les enfants d'Israël firent ainsi. Ils firent tout ce que Yahvé avait ordonné à Moïse. ");
INSERT INTO frasbl_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Yahvé parla à Moïse et à Aaron, et dit : ");
INSERT INTO frasbl_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","Les enfants d'Israël camperont chacun sous son propre drapeau, avec les bannières de leurs maisons paternelles. Ils camperont autour de la tente de la Rencontre, à distance de celle-ci. ");
INSERT INTO frasbl_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","« Ceux qui campent à l'est, vers le lever du soleil, feront partie de la bannière du camp de Juda, selon leurs divisions. Le prince des fils de Juda sera Nachschon, fils d'Amminadab. ");
INSERT INTO frasbl_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Sa division, et ceux qui furent comptés parmi eux, furent de soixante-quatorze mille six cents. ");
INSERT INTO frasbl_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","« Ceux qui campent à côté de lui seront de la tribu d'Issachar. Le prince des fils d'Issacar sera Nethaneel, fils de Tsuar. ");
INSERT INTO frasbl_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Sa division, et ceux qui en faisaient partie, étaient de cinquante-quatre mille quatre cents. ");
INSERT INTO frasbl_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Tribu de Zabulon : le prince des fils de Zabulon sera Éliab, fils de Hélon. ");
INSERT INTO frasbl_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Sa division, et ceux qui en firent le dénombrement, furent de cinquante-sept mille quatre cents. ");
INSERT INTO frasbl_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","« Tous ceux du camp de Juda qui ont été dénombrés sont cent quatre-vingt-six mille quatre cents, selon leurs divisions. Ils partiront les premiers. ");
INSERT INTO frasbl_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","« Sur le côté sud sera la bannière du camp de Ruben, selon ses divisions. Le prince des fils de Ruben sera Élitsur, fils de Schedéur. ");
INSERT INTO frasbl_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Sa division, et ceux qui en faisaient partie, étaient au nombre de quarante-six mille cinq cents. ");
INSERT INTO frasbl_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","« Ceux qui camperont à côté de lui seront de la tribu de Siméon. Le prince des fils de Siméon sera Schelumiel, fils de Tsurischaddaï. ");
INSERT INTO frasbl_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Sa division, et ceux qui furent comptés parmi eux, furent de cinquante-neuf mille trois cents. ");
INSERT INTO frasbl_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Tribu de Gad. Le prince des fils de Gad sera Éliasaph, fils de Réuel. ");
INSERT INTO frasbl_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Sa division, et ceux qui furent dénombrés parmi eux, furent de quarante-cinq mille six cent cinquante. ");
INSERT INTO frasbl_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","« Tous ceux du camp de Ruben qui ont été comptés sont cent cinquante et un mille quatre cent cinquante, selon leurs armées. Ils partiront en second. ");
INSERT INTO frasbl_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","« Puis la tente de la Rencontre partira, avec le camp des Lévites au milieu des camps. Ils se mettront en route comme ils ont campé, chacun à sa place, selon leurs normes. ");
INSERT INTO frasbl_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","« Sur le côté ouest sera la bannière du camp d'Ephraïm, selon ses divisions. Le prince des fils d'Éphraïm sera Élischama, fils d'Ammihud. ");
INSERT INTO frasbl_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Sa division, et ceux qui furent comptés parmi eux, furent de quarante mille cinq cents. ");
INSERT INTO frasbl_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","« A côté de lui sera la tribu de Manassé. Le prince des fils de Manassé sera Gamaliel, fils de Pedahzur. ");
INSERT INTO frasbl_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Sa division, et ceux qui furent comptés parmi eux, furent de trente-deux mille deux cents. ");
INSERT INTO frasbl_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Tribu de Benjamin. Le prince des fils de Benjamin sera Abidan, fils de Gédéoni. ");
INSERT INTO frasbl_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Son armée, et ceux qu'on en comptait, étaient de trente-cinq mille quatre cents. ");
INSERT INTO frasbl_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","« Tous ceux du camp d'Ephraïm qui ont été dénombrés sont cent huit mille cent, selon leurs divisions. Ils partiront les troisièmes. ");
INSERT INTO frasbl_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","« Sur le côté nord sera la bannière du camp de Dan, selon leurs divisions. Le prince des fils de Dan sera Ahiézer, fils d'Ammischaddaï. ");
INSERT INTO frasbl_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Sa division, et ceux qui furent comptés parmi eux, furent de soixante-deux mille sept cents. ");
INSERT INTO frasbl_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","« Ceux qui camperont à côté de lui seront de la tribu d'Aser. Le prince des fils d'Aser sera Pagiel, fils d'Ochran. ");
INSERT INTO frasbl_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Sa division, et ceux qui furent comptés parmi eux, furent de quarante et un mille cinq cents. ");
INSERT INTO frasbl_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Tribu de Nephthali : le prince des fils de Nephthali sera Ahira, fils d'Énan. ");
INSERT INTO frasbl_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Sa division, et ceux qui furent dénombrés parmi eux, furent de cinquante-trois mille quatre cents. ");
INSERT INTO frasbl_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","« Tous ceux du camp de Dan qui ont été comptés sont cent cinquante-sept mille six cents. Ils se mettront en route les derniers, selon leurs critères. » ");
INSERT INTO frasbl_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Tels sont ceux des enfants d'Israël dont on fit le dénombrement, selon les maisons de leurs pères. Tous ceux qui furent comptés dans les camps, selon leurs armées, furent six cent trois mille cinq cent cinquante. ");
INSERT INTO frasbl_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Mais les Lévites ne furent pas comptés parmi les enfants d'Israël, comme Yahvé l'avait ordonné à Moïse. ");
INSERT INTO frasbl_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Ainsi firent les enfants d'Israël. Selon tout ce que l'Éternel avait ordonné à Moïse, ils campèrent selon leurs normes, et ils partirent, chacun selon sa famille, selon les maisons de ses pères. ");
INSERT INTO frasbl_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Voici l'histoire des générations d'Aaron et de Moïse, au jour où Yahvé parla à Moïse sur la montagne de Sinaï. ");
INSERT INTO frasbl_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Voici les noms des fils d'Aaron : Nadab, premier-né, Abihu, Éléazar et Ithamar. ");
INSERT INTO frasbl_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Voici les noms des fils d'Aaron, les prêtres oints, qu'il consacra pour exercer le sacerdoce. ");
INSERT INTO frasbl_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Nadab et Abihu moururent devant Yahvé lorsqu'ils offrirent du feu étranger devant Yahvé dans le désert du Sinaï, et ils n'eurent pas d'enfants. Eléazar et Ithamar firent le service du sacerdoce en présence d'Aaron, leur père. ");
INSERT INTO frasbl_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Yahvé parla à Moïse, et dit : ");
INSERT INTO frasbl_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","Fais approcher la tribu de Lévi, et place-la devant le prêtre Aaron, pour qu'elle soit à son service. ");
INSERT INTO frasbl_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Ils veilleront sur ses besoins et sur ceux de toute l'assemblée devant la tente d'assignation, pour faire le service du tabernacle. ");
INSERT INTO frasbl_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Ils garderont tout le mobilier de la Tente d'assignation et les obligations des enfants d'Israël, pour assurer le service de la Tente d'assignation. ");
INSERT INTO frasbl_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Tu donneras les Lévites à Aaron et à ses fils. Ils lui seront entièrement remis au nom des enfants d'Israël. ");
INSERT INTO frasbl_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Tu désigneras Aaron et ses fils, et ils conserveront leur sacerdoce, mais l'étranger qui s'approchera sera mis à mort. » ");
INSERT INTO frasbl_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Yahvé parla à Moïse et dit : ");
INSERT INTO frasbl_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","« Voici, j'ai pris les Lévites du milieu des enfants d'Israël à la place de tous les premiers-nés qui ouvrent le ventre des enfants d'Israël ; et les Lévites seront à moi, ");
INSERT INTO frasbl_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","car tous les premiers-nés sont à moi. Le jour où j'ai frappé tous les premiers-nés du pays d'Égypte, j'ai consacré à moi tous les premiers-nés d'Israël, hommes et animaux. Ils seront à moi. Je suis Yahvé. » ");
INSERT INTO frasbl_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Yahvé parla à Moïse dans le désert de Sinaï, et dit : ");
INSERT INTO frasbl_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","« Compte les enfants de Lévi selon les maisons de leurs pères, selon leurs familles. Tu compteras tous les mâles depuis l'âge d'un mois et au-dessus. » ");
INSERT INTO frasbl_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Moïse les compta selon la parole de Yahvé, comme il en avait reçu l'ordre. ");
INSERT INTO frasbl_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Voici les fils de Lévi, selon leurs noms : Guershon, Kehath et Merari. ");
INSERT INTO frasbl_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Voici les noms des fils de Gershon, selon leurs familles : Libni et Shimei. ");
INSERT INTO frasbl_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Fils de Kehath, selon leurs familles : Amram, Izhar, Hebron et Uzziel. ");
INSERT INTO frasbl_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Les fils de Merari, selon leurs familles : Mahli et Mushi. Voici les familles des Lévites, selon les maisons de leurs pères. ");
INSERT INTO frasbl_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","De Guershon, la famille des Libnites et la famille des Shiméites. Ce sont là les familles des Gershonites. ");
INSERT INTO frasbl_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Ceux dont on fit le compte, selon le nombre de tous les mâles depuis l'âge d'un mois et au-dessus, ceux dont on fit le compte furent sept mille cinq cents. ");
INSERT INTO frasbl_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Les familles des Guershonites camperont derrière le tabernacle, à l'ouest. ");
INSERT INTO frasbl_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Eliasaph, fils de Lael, sera le chef de la maison des pères des Guershonites. ");
INSERT INTO frasbl_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Les fonctions des fils de Gershon dans la Tente d'assignation seront le tabernacle, le chapiteau, sa couverture, le rideau de l'entrée de la Tente d'assignation, ");
INSERT INTO frasbl_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","les tentures du parvis, le rideau de l'entrée du parvis qui est près du tabernacle et autour de l'autel, et ses cordons pour tout son service. ");
INSERT INTO frasbl_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","De Kehath, la famille des Amramites, la famille des Jitseharites, la famille des Hébronites et la famille des Uzzielites. Telles sont les familles des Kehathites. ");
INSERT INTO frasbl_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","D'après le nombre de tous les mâles, depuis l'âge d'un mois et au-dessus, il y en avait huit mille six cents qui observaient les prescriptions du sanctuaire. ");
INSERT INTO frasbl_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Les familles des fils de Kehath camperont au sud du tabernacle. ");
INSERT INTO frasbl_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Le chef de la maison des pères des familles des Kehathites sera Elizaphan, fils d'Uzziel. ");
INSERT INTO frasbl_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Il sera chargé de l'arche, de la table, du chandelier, des autels, des ustensiles du sanctuaire avec lesquels on fait le service, du rideau et de tout son service. ");
INSERT INTO frasbl_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Éléazar, fils du prêtre Aaron, sera le chef des chefs des lévites, avec la surveillance de ceux qui veillent aux besoins du sanctuaire. ");
INSERT INTO frasbl_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","De Merari était la famille des Mahlites et la famille des Mushites. Ce sont là les familles de Merari. ");
INSERT INTO frasbl_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Ceux dont on fit le dénombrement, selon le nombre de tous les mâles depuis l'âge d'un mois et au-dessus, furent six mille deux cents. ");
INSERT INTO frasbl_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Le prince de la maison des pères des familles de Merari était Tsuriel, fils d'Abihail. Ils camperont sur le côté nord de la tente. ");
INSERT INTO frasbl_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Les fils de Merari seront chargés des planches du tabernacle, de ses barres, de ses piliers, de ses socles, de tous ses instruments, de tout son service, ");
INSERT INTO frasbl_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","des piliers du parvis qui l'entourent, de leurs socles, de leurs broches et de leurs cordons. ");
INSERT INTO frasbl_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Ceux qui campent devant le tabernacle, à l'est, devant la tente d'assignation, vers le lever du soleil, seront Moïse, avec Aaron et ses fils, gardant les exigences du sanctuaire pour le devoir des enfants d'Israël. L'étranger qui s'approchera sera mis à mort. ");
INSERT INTO frasbl_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Tous les Lévites dont Moïse et Aaron firent le compte sur l'ordre de l'Éternel, selon leurs familles, tous les mâles depuis l'âge d'un mois et au-dessus, furent vingt-deux mille. ");
INSERT INTO frasbl_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","L'Éternel dit à Moïse : « Fais le compte de tous les premiers-nés mâles des enfants d'Israël, depuis l'âge d'un mois et au-dessus, et note le nombre de leurs noms. ");
INSERT INTO frasbl_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Tu prendras les Lévites pour moi - je suis Yahvé - à la place de tous les premiers-nés des enfants d'Israël, et le bétail des Lévites à la place de tous les premiers-nés du bétail des enfants d'Israël. » ");
INSERT INTO frasbl_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Moïse compta, comme l'avait ordonné l'Éternel, tous les premiers-nés des enfants d'Israël. ");
INSERT INTO frasbl_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Tous les premiers-nés mâles, selon le nombre des noms, depuis l'âge d'un mois et au-dessus, de ceux qui furent comptés, furent vingt-deux mille deux cent soixante-treize. ");
INSERT INTO frasbl_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Yahvé parla à Moïse, et dit : ");
INSERT INTO frasbl_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","« Prends les Lévites à la place de tous les premiers-nés des enfants d'Israël, et le bétail des Lévites à la place de leur bétail ; et les Lévites seront à moi. Je suis Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Pour le rachat des deux cent soixante-treize premiers-nés des enfants d'Israël qui dépassent le nombre des Lévites, ");
INSERT INTO frasbl_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","tu prendras cinq sicles pour chacun d'eux ; tu les prendras selon le sicle du sanctuaire (le sicle est de vingt gérachs) ; ");
INSERT INTO frasbl_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","et tu donneras l'argent, avec lequel leur reste est racheté, à Aaron et à ses fils. » ");
INSERT INTO frasbl_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Moïse prit l'argent du rachat de ceux qui dépassaient le nombre des rachetés par les Lévites ; ");
INSERT INTO frasbl_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","il prit l'argent des premiers-nés des enfants d'Israël, mille trois cent soixante-cinq sicles, selon le sicle du sanctuaire ; ");
INSERT INTO frasbl_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","et Moïse donna l'argent du rachat à Aaron et à ses fils, selon la parole de Yahvé, comme Yahvé l'avait ordonné à Moïse. ");
INSERT INTO frasbl_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Yahvé parla à Moïse et à Aaron, et dit : ");
INSERT INTO frasbl_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","« Recensez les fils de Kehath parmi les fils de Lévi, selon leurs familles, selon les maisons de leurs pères, ");
INSERT INTO frasbl_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","depuis l'âge de trente ans et au-dessus jusqu'à l'âge de cinquante ans, tous ceux qui entrent au service pour faire le travail dans la tente de la Rencontre. ");
INSERT INTO frasbl_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Voici le service des fils de Kehath dans la tente d'assignation, en ce qui concerne les choses très saintes. ");
INSERT INTO frasbl_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Lorsque le camp avancera, Aaron entrera avec ses fils ; ils ôteront le voile du rideau, en couvriront l'arche du Témoignage, ");
INSERT INTO frasbl_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","la couvriront d'une peau de phoque, étendront sur elle un tissu bleu et placeront ses barres. ");
INSERT INTO frasbl_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","« Sur la table des pains de proposition, on étendra un drap bleu, et l'on mettra dessus les plats, les cuillères, les coupes et les gobelets pour les verser ; le pain de proposition sera dessus. ");
INSERT INTO frasbl_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","On étendra sur elle un drap écarlate, on la couvrira d'une couverture de peau de phoque, et on y placera ses barres. ");
INSERT INTO frasbl_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","« Ils prendront un linge bleu et couvriront le chandelier du luminaire, ses lampes, ses éteignoirs, ses plats à priser et tous ses vases à huile, avec lesquels ils le servent. ");
INSERT INTO frasbl_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Ils le mettront, ainsi que tous ses ustensiles, dans une enveloppe de peau de phoque, et ils la poseront sur le cadre. ");
INSERT INTO frasbl_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","« Sur l'autel d'or, on étendra un linge bleu, on le couvrira d'une housse de peau de phoque, et l'on mettra ses perches. ");
INSERT INTO frasbl_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","« Ils prendront tous les ustensiles avec lesquels on fait le service dans le sanctuaire, ils les mettront dans un drap bleu, les couvriront d'une enveloppe de peau de phoque, et les mettront sur le cadre. ");
INSERT INTO frasbl_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","« Ils enlèveront les cendres de l'autel, et ils étendront sur lui un tissu de pourpre. ");
INSERT INTO frasbl_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Ils y mettront tous les ustensiles avec lesquels on fait le service, les poêles à feu, les crochets à viande, les pelles et les bassins, tous les ustensiles de l'autel ; ils étendront sur lui une couverture de peau de phoque, et ils mettront ses barres. ");
INSERT INTO frasbl_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","« Quand Aaron et ses fils auront fini de couvrir le sanctuaire et tous les meubles du sanctuaire, pendant que le camp avancera, les fils de Kehath viendront les porter ; mais ils ne toucheront pas le sanctuaire, de peur de mourir. Les fils de Kehath porteront ces objets appartenant à la Tente d'assignation. ");
INSERT INTO frasbl_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","« Le devoir du prêtre Éléazar, fils d'Aaron, sera l'huile pour le feu, le parfum doux, l'offrande perpétuelle et l'huile d'onction, les exigences de tout le tabernacle et de tout ce qui s'y trouve, du sanctuaire et de son mobilier. » ");
INSERT INTO frasbl_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Yahvé parla à Moïse et à Aaron, et dit : ");
INSERT INTO frasbl_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","« N'extermine pas la tribu des familles des Kehathites du milieu des Lévites ; ");
INSERT INTO frasbl_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","mais fais-leur ceci, afin qu'ils vivent et ne meurent pas, lorsqu'ils s'approcheront des choses très saintes : Aaron et ses fils entreront et assigneront chacun à son service et à sa charge ; ");
INSERT INTO frasbl_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","mais ils n'entreront pas pour voir le sanctuaire, même pour un instant, de peur de mourir. » ");
INSERT INTO frasbl_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","L'Éternel parla à Moïse, et dit : ");
INSERT INTO frasbl_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","« Recense aussi les fils de Guershon, selon les maisons de leurs pères, selon leurs familles ; ");
INSERT INTO frasbl_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","tu les compteras depuis l'âge de trente ans et au-dessus jusqu'à l'âge de cinquante ans, tous ceux qui entrent pour faire le service, pour faire l'ouvrage dans la tente de la Rencontre. ");
INSERT INTO frasbl_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","« C'est ici le service des familles des Guershonites, en servant et en portant des fardeaux : ");
INSERT INTO frasbl_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Ils porteront les tapis du tabernacle et de la tente d'assignation, sa couverture, la couverture en peau de phoque qui la recouvre, le rideau de l'entrée de la tente d'assignation, ");
INSERT INTO frasbl_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","les tentures du parvis, le rideau de l'entrée de la porte du parvis qui est près du tabernacle et autour de l'autel, leurs cordages, tous les instruments de leur service, et tout ce qu'on fera avec eux. C'est là qu'ils feront leur service. ");
INSERT INTO frasbl_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Sur l'ordre d'Aaron et de ses fils, il y aura tout le service des fils des Gershonites, dans toute leur charge et dans tout leur service, et vous leur assignerez leur tâche dans toutes leurs responsabilités. ");
INSERT INTO frasbl_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Voici le service des familles des fils des Gershonites dans la Tente d'assignation. Leur service sera sous la responsabilité d'Ithamar, fils du prêtre Aaron. ");
INSERT INTO frasbl_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","« Tu compteras les fils de Merari selon leurs familles, selon les maisons de leurs pères ; ");
INSERT INTO frasbl_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","tu les compteras depuis l'âge de trente ans et au-dessus jusqu'à l'âge de cinquante ans, tous ceux qui entrent dans le service, pour faire le travail de la Tente de la Rencontre. ");
INSERT INTO frasbl_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Voici la charge qui leur incombe, selon tout le service qu'ils font dans la Tente d'assignation : les planches de la tente, ses barres, ses piliers, ses socles, ");
INSERT INTO frasbl_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","les piliers du parvis qui l'entourent, leurs socles, leurs broches, leurs cordes, avec tous leurs instruments et avec tout leur service. Tu leur désigneras par leur nom les instruments du service de leur charge. ");
INSERT INTO frasbl_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Tel est le service des familles des fils de Merari, selon tout leur service dans la Tente d'assignation, sous la direction d'Ithamar, fils du prêtre Aaron. » ");
INSERT INTO frasbl_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Moïse, Aaron et les chefs de l'assemblée firent le compte des fils des Kehathites, selon leurs familles et selon les maisons de leurs pères, ");
INSERT INTO frasbl_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","depuis l'âge de trente ans et au-dessus jusqu'à l'âge de cinquante ans, tous ceux qui entraient en service pour travailler dans la tente de la Rencontre. ");
INSERT INTO frasbl_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Ceux dont on fit le compte, selon leurs familles, furent deux mille sept cent cinquante. ");
INSERT INTO frasbl_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Tels sont ceux qui furent comptés parmi les familles des Kehathites, tous ceux qui faisaient le service dans la Tente de la Rencontre, et dont Moïse et Aaron firent le compte, selon le commandement de l'Éternel par Moïse. ");
INSERT INTO frasbl_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Ceux des fils de Guershon dont on fit le dénombrement, selon leurs familles et leurs maisons de pères, ");
INSERT INTO frasbl_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","depuis l'âge de trente ans et au-dessus jusqu'à l'âge de cinquante ans, tous ceux qui se mirent au service de la Tente d'assignation, ");
INSERT INTO frasbl_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","ceux dont on fit le dénombrement, selon leurs familles et leurs maisons de pères, furent deux mille six cent trente. ");
INSERT INTO frasbl_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Tels sont ceux qui furent comptés parmi les familles des fils de Guershon, tous ceux qui servirent dans la Tente de la Rencontre, et dont Moïse et Aaron firent le compte, selon le commandement de l'Éternel. ");
INSERT INTO frasbl_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Ceux des familles des fils de Merari dont on fit le dénombrement, selon leurs familles, selon les maisons de leurs pères, ");
INSERT INTO frasbl_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","depuis l'âge de trente ans et au-dessus jusqu'à l'âge de cinquante ans, tous ceux qui furent admis à travailler dans la tente d'assignation, ");
INSERT INTO frasbl_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","ceux dont on fit le dénombrement selon leurs familles, furent trois mille deux cents. ");
INSERT INTO frasbl_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Tels sont ceux des familles des fils de Merari dont Moïse et Aaron firent le compte, selon le commandement de l'Éternel par Moïse. ");
INSERT INTO frasbl_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Tous ceux des Lévites dont Moïse, Aaron et les chefs d'Israël firent le dénombrement, selon leurs familles et selon les maisons de leurs pères, ");
INSERT INTO frasbl_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","depuis l'âge de trente ans et au-dessus jusqu'à l'âge de cinquante ans, tous ceux qui entraient pour faire le service et porter les fardeaux dans la tente d'assignation, ");
INSERT INTO frasbl_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","ceux qui furent dénombrés parmi eux, furent huit mille cinq cent quatre-vingts. ");
INSERT INTO frasbl_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Ils furent comptés par Moïse, selon le commandement de l'Éternel, chacun selon son service et selon son fardeau. C'est ainsi qu'ils furent comptés par lui, comme Yahvé l'avait ordonné à Moïse. ");
INSERT INTO frasbl_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Yahvé parla à Moïse, et dit : ");
INSERT INTO frasbl_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","« Ordonne aux enfants d'Israël de faire sortir du camp tout lépreux, toute personne qui a des pertes, et quiconque est souillé par un cadavre. ");
INSERT INTO frasbl_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Tu feras sortir du camp l'homme et la femme, afin qu'ils ne souillent pas leur camp, au milieu duquel j'habite. » ");
INSERT INTO frasbl_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Les enfants d'Israël firent ainsi, et les mirent hors du camp ; les enfants d'Israël firent ce que l'Éternel avait dit à Moïse. ");
INSERT INTO frasbl_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Yahvé parla à Moïse et dit : ");
INSERT INTO frasbl_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","Parle aux enfants d'Israël : « Lorsqu'un homme ou une femme commettra un des péchés que commettent les hommes, au point de porter atteinte à Yahvé, et que cette âme sera coupable, ");
INSERT INTO frasbl_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","il confessera le péché qu'il a commis ; il restituera la totalité de sa faute, y ajoutera un cinquième et la donnera à celui pour qui il s'est rendu coupable. ");
INSERT INTO frasbl_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Mais si l'homme n'a pas de parent à qui restituer la culpabilité, la restitution de la culpabilité qui sera faite à Yahvé appartiendra au prêtre, en plus du bélier d'expiation, par lequel l'expiation sera faite pour lui. ");
INSERT INTO frasbl_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Toute offrande par élévation de toutes les choses saintes des enfants d'Israël, qu'ils présenteront au sacrificateur, lui appartiendra. ");
INSERT INTO frasbl_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Les choses saintes de chacun seront à lui ; tout ce que quelqu'un donnera au prêtre sera à lui.'\" ");
INSERT INTO frasbl_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Yahvé parla à Moïse, et dit : ");
INSERT INTO frasbl_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","« Parle aux enfants d'Israël, et dis-leur : Si la femme d'un homme s'égare et lui est infidèle, ");
INSERT INTO frasbl_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","et qu'un homme couche avec elle charnellement, et que cela soit caché aux yeux de son mari, et que cela reste caché, et qu'elle soit souillée, il n'y a pas de témoin contre elle, et elle n'est pas prise sur le fait ; ");
INSERT INTO frasbl_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","et l'esprit de jalousie vient sur lui, et il est jaloux de sa femme et elle est souillée ; ou si l'esprit de jalousie vient sur lui, et il est jaloux de sa femme et elle n'est pas souillée ; ");
INSERT INTO frasbl_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","alors l'homme amènera sa femme au prêtre, et il apportera pour elle une offrande : un dixième d'un épha de farine d'orge. Il ne versera pas d'huile dessus et n'y mettra pas d'encens, car c'est une offrande de jalousie, une offrande de souvenir, pour rappeler l'iniquité. ");
INSERT INTO frasbl_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Le prêtre la fera approcher et la présentera devant l'Éternel. ");
INSERT INTO frasbl_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Le prêtre prendra de l'eau bénite dans un vase de terre ; il prendra un peu de la poussière qui est sur le sol du tabernacle et la mettra dans l'eau. ");
INSERT INTO frasbl_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Le prêtre placera la femme devant l'Éternel, il détachera les cheveux de la tête de la femme, et il mettra dans ses mains l'offrande de farine commémorative, qui est l'offrande de farine de jalousie. Le prêtre aura dans sa main l'eau amère qui apporte la malédiction. ");
INSERT INTO frasbl_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Le prêtre lui fera prêter serment et dira à la femme : « Si aucun homme n'a couché avec toi, et si tu ne t'es pas égarée dans l'impureté, étant sous l'autorité de ton mari, libère-toi de cette eau amère qui entraîne la malédiction. ");
INSERT INTO frasbl_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Mais si tu t'es égarée, étant sous l'autorité de ton mari, et si tu t'es souillée, et qu'un homme a couché avec toi en dehors de ton mari - » ");
INSERT INTO frasbl_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","alors le prêtre fera jurer la femme avec le serment de malédiction, et le prêtre dira à la femme : « Que Yahvé te maudisse et te fasse jurer parmi ton peuple, lorsque Yahvé permettra que ta cuisse se dérobe et que ton corps se gonfle ; ");
INSERT INTO frasbl_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","et que cette eau qui apporte la malédiction entrera dans tes entrailles, fera gonfler ton corps et tomber ta cuisse ». La femme dira : « Amen, Amen. » ");
INSERT INTO frasbl_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","\"'Le prêtre écrira ces malédictions dans un livre, et il les fera passer dans l'eau d'amertume. ");
INSERT INTO frasbl_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Il fera boire à la femme l'eau amère qui provoque la malédiction ; l'eau qui provoque la malédiction entrera en elle et deviendra amère. ");
INSERT INTO frasbl_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Le prêtre prendra de la main de la femme l'offrande de jalousie ; il agitera l'offrande devant l'Éternel et l'apportera sur l'autel. ");
INSERT INTO frasbl_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Le prêtre prendra une poignée de l'offrande de farine, comme portion commémorative, et il la brûlera sur l'autel ; ensuite, il fera boire l'eau à la femme. ");
INSERT INTO frasbl_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Lorsqu'il lui aura fait boire l'eau, il arrivera, si elle s'est souillée et a commis une infidélité envers son mari, que l'eau qui est à l'origine de la malédiction entrera en elle et deviendra amère, que son corps enflera, que sa cuisse tombera, et que la femme sera maudite parmi son peuple. ");
INSERT INTO frasbl_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Si la femme n'est pas souillée, mais qu'elle est pure, alors elle sera libre et concevra une progéniture. ");
INSERT INTO frasbl_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","\"'Voici la loi de la jalousie, lorsqu'une femme, sous l'autorité de son mari, s'égare et se souille, ");
INSERT INTO frasbl_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","ou lorsque l'esprit de jalousie s'empare d'un homme et qu'il est jaloux de sa femme ; alors il présentera la femme devant Yahvé, et le prêtre exécutera sur elle toute cette loi. ");
INSERT INTO frasbl_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","L'homme sera libéré de son iniquité, et la femme portera son iniquité.'\" ");
INSERT INTO frasbl_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Yahvé parla à Moïse, et dit : ");
INSERT INTO frasbl_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","Parle aux enfants d'Israël, et dis-leur : Quand un homme ou une femme fera un vœu spécial, le vœu de naziréat, pour se séparer de Yahvé, ");
INSERT INTO frasbl_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","il se séparera du vin et des boissons fortes. Il ne boira pas de vinaigre de vin ni de vinaigre de boisson fermentée, il ne boira pas de jus de raisin et ne mangera pas de raisins frais ou secs. ");
INSERT INTO frasbl_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Pendant toute la durée de sa séparation, il ne mangera rien de ce qui provient de la vigne, depuis les pépins jusqu'aux peaux. ");
INSERT INTO frasbl_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","\"'Pendant toute la durée de son vœu de séparation, aucun rasoir ne viendra sur sa tête, jusqu'à l'accomplissement des jours où il se séparera de Yahvé. Il sera saint. Il laissera croître les mèches des cheveux de sa tête. ");
INSERT INTO frasbl_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","\"'Tous les jours où il se séparera de Yahvé, il ne s'approchera pas d'un cadavre. ");
INSERT INTO frasbl_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Il ne se rendra pas impur pour son père, pour sa mère, pour son frère ou pour sa sœur, lorsqu'ils mourront, car sa séparation d'avec Dieu est sur sa tête. ");
INSERT INTO frasbl_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Tous les jours de sa séparation, il est saint pour Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","\"'Si un homme meurt subitement à côté de lui et qu'il souille la tête de sa séparation, il se rasera la tête le jour de sa purification. Le septième jour, il la rasera. ");
INSERT INTO frasbl_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Le huitième jour, il apportera au prêtre, à l'entrée de la tente de la Rencontre, deux tourterelles ou deux jeunes pigeons. ");
INSERT INTO frasbl_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Le prêtre offrira l'une en sacrifice pour le péché et l'autre en holocauste ; il fera l'expiation pour lui, parce qu'il a péché à cause d'un mort, et il sanctifiera sa tête ce même jour. ");
INSERT INTO frasbl_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Il séparera pour Yahvé les jours de sa séparation, et il apportera un agneau mâle d'un an en sacrifice de culpabilité ; mais les jours précédents seront annulés, car sa séparation a été souillée. ");
INSERT INTO frasbl_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","« Voici la loi du naziréen : lorsque les jours de sa séparation seront accomplis, il sera amené à l'entrée de la tente d'assignation, ");
INSERT INTO frasbl_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","et il présentera son offrande à l'Éternel : un agneau mâle d'un an sans défaut pour l'holocauste, une brebis d'un an sans défaut pour le sacrifice pour le péché, un bélier sans défaut pour le sacrifice d'actions de grâces, ");
INSERT INTO frasbl_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","une corbeille de pains sans levain, des gâteaux de fleur de farine pétrie à l'huile, et des galettes sans levain ointes d'huile, avec leur offrande et leur libation. ");
INSERT INTO frasbl_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Le prêtre les présentera devant l'Éternel, et il offrira son sacrifice pour le péché et son holocauste. ");
INSERT INTO frasbl_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Il offrira le bélier en sacrifice d'actions de grâces à l'Éternel, avec la corbeille de pains sans levain. Le prêtre offrira également son offrande de repas et sa libation. ");
INSERT INTO frasbl_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Le naziréen rasera sa tête de séparation à l'entrée de la Tente d'assignation, prendra les cheveux de sa tête de séparation et les mettra sur le feu qui est sous le sacrifice d'actions de grâces. ");
INSERT INTO frasbl_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Le prêtre prendra l'épaule bouillie du bélier, un gâteau sans levain de la corbeille et une galette sans levain, et il les posera sur les mains du naziréen, après qu'il aura rasé sa tête de séparation ; ");
INSERT INTO frasbl_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","et le prêtre les agitera en sacrifice d'agitation devant Yahvé. Elles sont saintes pour le prêtre, avec la poitrine qu'on agite et la cuisse qu'on offre. Après cela, le naziréen pourra boire du vin. ");
INSERT INTO frasbl_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","\"'Voici la loi du naziréen qui fait un vœu et de son offrande à Yahvé pour sa séparation, en plus de ce qu'il peut se permettre. Selon le vœu qu'il prononce, il doit agir de la même manière, selon la loi de sa séparation. »\" ");
INSERT INTO frasbl_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Yahvé parla à Moïse et dit : ");
INSERT INTO frasbl_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","« Parle à Aaron et à ses fils, et dis : « Voici comment vous bénirez les enfants d'Israël. Vous leur direz, ");
INSERT INTO frasbl_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","Yahvé te bénit et te garde. ");
INSERT INTO frasbl_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Yahvé fait briller sa face sur vous, et être gracieux envers vous. ");
INSERT INTO frasbl_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Yahvé lève sa face vers vous, et te donner la paix. ");
INSERT INTO frasbl_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","« Ils mettront mon nom sur les enfants d'Israël, et je les bénirai. » ");
INSERT INTO frasbl_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Le jour où Moïse acheva de dresser le tabernacle, où il l'oignit et le sanctifia avec tous ses ustensiles, et où il oignit et sanctifia l'autel avec tous ses ustensiles, ");
INSERT INTO frasbl_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","les princes d'Israël, chefs des maisons de leurs pères, firent des offrandes. Ce sont les princes des tribus. ");
INSERT INTO frasbl_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Ilsapportèrent leur offrande devant Yahvé : six chariots couverts et douze bœufs, un chariot pour deux des princes, et un bœuf pour chacun d'eux. Ils les présentèrent devant le tabernacle. ");
INSERT INTO frasbl_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","L'Éternel parla à Moïse et dit : ");
INSERT INTO frasbl_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","« Accepte-les de leur part, afin qu'ils soient utilisés pour le service de la tente d'assignation ; tu les donneras aux Lévites, à chacun selon son service. » ");
INSERT INTO frasbl_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Moïse prit les chariots et les bœufs, et les donna aux Lévites. ");
INSERT INTO frasbl_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Il donna deux chariots et quatre bœufs aux fils de Gershon, selon leur service. ");
INSERT INTO frasbl_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Il donna quatre chariots et huit bœufs aux fils de Merari, selon leur service, sous la direction d'Ithamar, fils du prêtre Aaron. ");
INSERT INTO frasbl_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Mais il ne donna rien aux fils de Kehath, car le service du sanctuaire leur appartenait ; ils le portaient sur leurs épaules. ");
INSERT INTO frasbl_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Les princes présentèrent des offrandes pour la dédicace de l'autel, le jour où il fut oint. Les princes présentèrent leurs offrandes devant l'autel. ");
INSERT INTO frasbl_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Yahvé dit à Moïse : « Ils présenteront leur offrande, chaque prince à son jour, pour la dédicace de l'autel. » ");
INSERT INTO frasbl_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Celui qui offrit son offrande le premier jour fut Nachschon, fils d'Amminadab, de la tribu de Juda, ");
INSERT INTO frasbl_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","et son offrande fut : un plateau d'argent, dont le poids était de cent trente shekels, un bol d'argent de soixante-dix sicles, selon le sicle du sanctuaire, tous deux remplis de fine farine mélangée à de l'huile, pour une offrande de farine ; ");
INSERT INTO frasbl_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","une louche d'or de dix sicles, pleine de parfums ; ");
INSERT INTO frasbl_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","un jeune taureau, un bélier, un agneau mâle d'un an, pour l'holocauste ; ");
INSERT INTO frasbl_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","un bouc pour le sacrifice pour le péché ; ");
INSERT INTO frasbl_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","et pour le sacrifice d'actions de grâces, deux têtes de bétail, cinq béliers, cinq boucs, et cinq agneaux mâles d'un an. Telle était l'offrande de Nachshon, fils d'Amminadab. ");
INSERT INTO frasbl_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Le second jour, Nethanel, fils de Zuar, prince d'Issachar, présenta son offrande. ");
INSERT INTO frasbl_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Il présenta son offrande : un plateau d'argent, dont le poids était de cent trente shekels, un bol d'argent de soixante-dix sicles, selon le sicle du sanctuaire, tous deux remplis de fine farine mélangée à de l'huile, pour une offrande de farine ; ");
INSERT INTO frasbl_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","une louche d'or de dix sicles, pleine de parfums ; ");
INSERT INTO frasbl_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","un jeune taureau, un bélier, un agneau mâle d'un an, pour l'holocauste ; ");
INSERT INTO frasbl_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","un bouc pour le sacrifice pour le péché ; ");
INSERT INTO frasbl_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","et pour le sacrifice d'actions de grâces, deux têtes de bétail, cinq béliers, cinq boucs, cinq agneaux d'un an. Telle était l'offrande de Nethanel, fils de Zuar. ");
INSERT INTO frasbl_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Le troisième jour, Éliab, fils de Hélon, prince des fils de Zabulon, ");
INSERT INTO frasbl_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","présenta son offrande : un plateau d'argent, dont le poids était de cent trente shekels, un bol d'argent de soixante-dix sicles, selon le sicle du sanctuaire, tous deux remplis de fine farine mélangée à de l'huile, pour une offrande de farine ; ");
INSERT INTO frasbl_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","une louche d'or de dix sicles, pleine de parfums ; ");
INSERT INTO frasbl_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","un jeune taureau, un bélier, un agneau mâle d'un an, pour l'holocauste ; ");
INSERT INTO frasbl_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","un bouc pour le sacrifice pour le péché ; ");
INSERT INTO frasbl_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","et pour le sacrifice d'actions de grâces, deux têtes de bétail, cinq béliers, cinq boucs, et cinq agneaux mâles d'un an. Telle était l'offrande d'Éliab, fils d'Hélon. ");
INSERT INTO frasbl_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Le quatrième jour, Elizur, fils de Shedeur, prince des fils de Ruben, ");
INSERT INTO frasbl_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","présenta son offrande : un plateau d'argent, dont le poids était de cent trente shekels, un bol d'argent de soixante-dix sicles, selon le sicle du sanctuaire, tous deux remplis de fine farine mélangée à de l'huile, pour une offrande de farine ; ");
INSERT INTO frasbl_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","une louche d'or de dix sicles, pleine d'encens ; ");
INSERT INTO frasbl_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","un jeune taureau, un bélier, un agneau mâle d'un an, pour l'holocauste ; ");
INSERT INTO frasbl_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","un bouc pour le sacrifice pour le péché ; ");
INSERT INTO frasbl_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","et pour le sacrifice d'actions de grâces, deux têtes de bétail, cinq béliers, cinq boucs, et cinq agneaux mâles d'un an. Telle était l'offrande d'Elizur, fils de Shedeur. ");
INSERT INTO frasbl_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Le cinquième jour, Shelumiel, fils de Tsurischaddaï, prince des fils de Siméon, ");
INSERT INTO frasbl_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","présenta son offrande : un plateau d'argent, dont le poids était de cent trente shekels, un bol d'argent de soixante-dix sicles, selon le sicle du sanctuaire, tous deux remplis de fine farine mélangée à de l'huile, pour une offrande de farine ; ");
INSERT INTO frasbl_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","une louche d'or de dix sicles, pleine de parfums ; ");
INSERT INTO frasbl_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","un jeune taureau, un bélier, un agneau mâle d'un an, pour l'holocauste ; ");
INSERT INTO frasbl_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","un bouc pour le sacrifice pour le péché ; ");
INSERT INTO frasbl_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","et pour le sacrifice d'actions de grâces, deux têtes de bétail, cinq béliers, cinq boucs, et cinq agneaux d'un an ; telle fut l'offrande de Shelumiel, fils de Zurishaddai. ");
INSERT INTO frasbl_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Le sixième jour, Eliasaph, fils de Déuel, prince des fils de Gad, ");
INSERT INTO frasbl_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","présenta son offrande : un plateau d'argent, dont le poids était de cent trente shekels, un bol d'argent de soixante-dix sicles, selon le sicle du sanctuaire, tous deux remplis de fine farine mélangée à de l'huile, pour une offrande de farine ; ");
INSERT INTO frasbl_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","une louche d'or de dix sicles, pleine de parfums ; ");
INSERT INTO frasbl_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","un jeune taureau, un bélier, un agneau mâle d'un an, pour l'holocauste ; ");
INSERT INTO frasbl_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","un bouc pour le sacrifice pour le péché ; ");
INSERT INTO frasbl_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","et pour le sacrifice d'actions de grâces, deux têtes de bétail, cinq béliers, cinq boucs, et cinq agneaux mâles d'un an. Telle était l'offrande d'Éliasaph, fils de Deuel. ");
INSERT INTO frasbl_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Le septième jour, Elishama, fils d'Ammihud, prince des fils d'Ephraïm, ");
INSERT INTO frasbl_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","présenta son offrande : un plateau d'argent, dont le poids était de cent trente shekels, un bol d'argent de soixante-dix sicles, selon le sicle du sanctuaire, tous deux remplis de fine farine mélangée à de l'huile, pour une offrande de farine ; ");
INSERT INTO frasbl_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","une louche d'or de dix sicles, pleine d'encens ; ");
INSERT INTO frasbl_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","un jeune taureau, un bélier, un agneau mâle d'un an, pour l'holocauste ; ");
INSERT INTO frasbl_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","un bouc pour le sacrifice pour le péché ; ");
INSERT INTO frasbl_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","et pour le sacrifice d'actions de grâces, deux têtes de bétail, cinq béliers, cinq boucs, et cinq agneaux mâles d'un an. Telle était l'offrande d'Elishama, fils d'Ammihud. ");
INSERT INTO frasbl_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Le huitième jour, Gamaliel, fils de Pedahzur, prince des fils de Manassé, ");
INSERT INTO frasbl_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","présenta son offrande : un plateau d'argent, dont le poids était de cent trente shekels, un bol d'argent de soixante-dix sicles, selon le sicle du sanctuaire, tous deux remplis de fine farine mélangée à de l'huile, pour une offrande de farine ; ");
INSERT INTO frasbl_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","une louche d'or de dix sicles, pleine d'encens ; ");
INSERT INTO frasbl_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","un jeune taureau, un bélier, un agneau mâle d'un an, pour l'holocauste ; ");
INSERT INTO frasbl_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","un bouc pour le sacrifice pour le péché ; ");
INSERT INTO frasbl_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","et pour le sacrifice d'actions de grâces, deux têtes de bétail, cinq béliers, cinq boucs, et cinq agneaux mâles d'un an. Telle était l'offrande de Gamaliel, fils de Pedahzur. ");
INSERT INTO frasbl_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Le neuvième jour, Abidan, fils de Gideoni, prince des fils de Benjamin, ");
INSERT INTO frasbl_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","présenta son offrande : un plateau d'argent, dont le poids était de cent trente shekels, un bol d'argent de soixante-dix sicles, selon le sicle du sanctuaire, tous deux remplis de fine farine mélangée à de l'huile, pour une offrande de farine ; ");
INSERT INTO frasbl_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","une louche d'or de dix sicles, pleine d'encens ; ");
INSERT INTO frasbl_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","un jeune taureau, un bélier, un agneau mâle d'un an, pour l'holocauste ; ");
INSERT INTO frasbl_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","un bouc pour le sacrifice pour le péché ; ");
INSERT INTO frasbl_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","et pour le sacrifice d'actions de grâces, deux têtes de bétail, cinq béliers, cinq boucs, et cinq agneaux mâles d'un an. Telle était l'offrande d'Abidan, fils de Gideoni. ");
INSERT INTO frasbl_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Le dixième jour, Ahiezer, fils d'Ammishaddai, prince des fils de Dan, ");
INSERT INTO frasbl_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","présenta son offrande : un plateau d'argent, dont le poids était de cent trente shekels, un bol d'argent de soixante-dix sicles, selon le sicle du sanctuaire, tous deux remplis de fine farine mélangée à de l'huile, pour une offrande de farine ; ");
INSERT INTO frasbl_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","une louche d'or de dix sicles, pleine d'encens ; ");
INSERT INTO frasbl_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","un jeune taureau, un bélier, un agneau mâle d'un an, pour l'holocauste ; ");
INSERT INTO frasbl_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","un bouc pour le sacrifice pour le péché ; ");
INSERT INTO frasbl_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","et pour le sacrifice d'actions de grâces, deux têtes de bétail, cinq béliers, cinq boucs, et cinq agneaux mâles d'un an. Telle fut l'offrande d'Ahiezer, fils d'Ammishaddai. ");
INSERT INTO frasbl_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Le onzième jour, Pagiel, fils d'Ochran, prince des fils d'Aser, ");
INSERT INTO frasbl_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","présenta son offrande : un plateau d'argent, dont le poids était de cent trente shekels, un bol d'argent de soixante-dix sicles, selon le sicle du sanctuaire, tous deux remplis de fine farine mélangée à de l'huile, pour une offrande de farine ; ");
INSERT INTO frasbl_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","une louche d'or de dix sicles, pleine d'encens ; ");
INSERT INTO frasbl_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","un jeune taureau, un bélier, un agneau mâle d'un an, pour l'holocauste ; ");
INSERT INTO frasbl_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","un bouc pour le sacrifice pour le péché ; ");
INSERT INTO frasbl_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","et pour le sacrifice d'actions de grâces, deux têtes de bétail, cinq béliers, cinq boucs, et cinq agneaux mâles d'un an. Telle était l'offrande de Pagiel, fils d'Ochran. ");
INSERT INTO frasbl_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Le douzième jour, Ahira, fils d'Enan, prince des fils de Nephtali, ");
INSERT INTO frasbl_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","présenta son offrande : un plateau d'argent, dont le poids était de cent trente shekels, un bol d'argent de soixante-dix sicles, selon le sicle du sanctuaire, tous deux remplis de fine farine mélangée à de l'huile, pour une offrande de farine ; ");
INSERT INTO frasbl_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","une louche d'or de dix sicles, pleine d'encens ; ");
INSERT INTO frasbl_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","un jeune taureau, un bélier, un agneau mâle d'un an, pour l'holocauste ; ");
INSERT INTO frasbl_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","un bouc pour le sacrifice pour le péché ; ");
INSERT INTO frasbl_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","et pour le sacrifice d'actions de grâces, deux têtes de bétail, cinq béliers, cinq boucs, et cinq agneaux mâles d'un an. Telle fut l'offrande d'Ahira, fils d'Enan. ");
INSERT INTO frasbl_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Ce fut l'offrande de dédicace de l'autel, le jour où il fut oint, par les princes d'Israël : douze plats d'argent, douze coupes d'argent, douze louches d'or ; ");
INSERT INTO frasbl_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","chaque plat d'argent pesait cent trente sicles, et chaque coupe soixante-dix ; tout l'argent des vases était de deux mille quatre cents sicles, selon le sicle du sanctuaire ; ");
INSERT INTO frasbl_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","les douze louches d'or, pleines de parfum, pesaient chacune dix sicles, selon le sicle du sanctuaire ; tout l'or des louches pesait cent vingt sicles ; ");
INSERT INTO frasbl_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","tout le bétail pour l'holocauste : douze taureaux, douze béliers, douze agneaux mâles d'un an, et leur offrande ; douze boucs pour le sacrifice pour le péché ; ");
INSERT INTO frasbl_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","et tout le bétail pour le sacrifice d'actions de grâces : vingt-quatre taureaux, soixante béliers, soixante boucs, et soixante agneaux d'un an. C'était l'offrande de dédicace de l'autel, après qu'il ait été oint. ");
INSERT INTO frasbl_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Lorsque Moïse entra dans la tente de la Rencontre pour parler à Yahvé, il entendit sa voix qui lui parlait de dessus le propitiatoire qui était sur l'arche du Témoignage, entre les deux chérubins, et il lui parla. ");
INSERT INTO frasbl_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Yahvé parla à Moïse et dit : ");
INSERT INTO frasbl_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","Parle à Aaron, et dis-lui : « Quand tu allumeras les lampes, les sept lampes éclaireront devant le chandelier. » ");
INSERT INTO frasbl_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Aaron fit ainsi. Il en alluma les lampes pour éclairer la zone située devant le chandelier, comme Yahvé l'avait ordonné à Moïse. ");
INSERT INTO frasbl_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Voici le travail du chandelier : c'était un travail d'or battu. Depuis sa base jusqu'à ses fleurs, il était travaillé. Il fit le chandelier d'après le modèle que Yahvé avait montré à Moïse. ");
INSERT INTO frasbl_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Yahvé parla à Moïse et dit : ");
INSERT INTO frasbl_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","« Prends les Lévites parmi les enfants d'Israël et purifie-les. ");
INSERT INTO frasbl_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Voici ce que tu leur feras pour les purifier : tu les aspergeras d'eau de purification, ils se raseront tout le corps avec un rasoir, ils laveront leurs vêtements et se purifieront. ");
INSERT INTO frasbl_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Ils prendront ensuite un jeune taureau et son offrande de farine, de la farine fine mélangée à de l'huile, et un autre jeune taureau que tu prendras pour le sacrifice pour le péché. ");
INSERT INTO frasbl_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Tu présenteras les Lévites devant la Tente d'assignation. Tu rassembleras toute la congrégation des enfants d'Israël. ");
INSERT INTO frasbl_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Tu présenteras les Lévites devant l'Éternel. Les enfants d'Israël imposeront leurs mains sur les Lévites, ");
INSERT INTO frasbl_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","et Aaron offrira les Lévites devant Yahvé en sacrifice par agitation au nom des enfants d'Israël, afin qu'ils soient au service de Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","« Les Lévites poseront leurs mains sur la tête des taureaux, et vous offrirez l'un en sacrifice pour le péché et l'autre en holocauste à Yahvé, afin de faire l'expiation pour les Lévites. ");
INSERT INTO frasbl_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Tu feras passer les Lévites devant Aaron et devant ses fils, et tu les offriras en offrande à l'Éternel. ");
INSERT INTO frasbl_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Tu sépareras ainsi les Lévites du milieu des enfants d'Israël, et les Lévites seront à moi. ");
INSERT INTO frasbl_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","« Après cela, les Lévites entreront pour faire le service de la Tente de la Rencontre. Tu les purifieras et tu les offriras en sacrifice par agitation. ");
INSERT INTO frasbl_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Car ils me sont entièrement donnés d'entre les enfants d'Israël ; à la place de tous ceux qui ouvrent le ventre, des premiers-nés de tous les enfants d'Israël, je les ai pris pour moi. ");
INSERT INTO frasbl_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Car tous les premiers-nés des enfants d'Israël sont à moi, tant les hommes que les animaux. Le jour où j'ai frappé tous les premiers-nés au pays d'Égypte, je les ai sanctifiés pour moi. ");
INSERT INTO frasbl_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","J'ai pris les Lévites à la place de tous les premiers-nés des enfants d'Israël. ");
INSERT INTO frasbl_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","J'ai donné les Lévites en cadeau à Aaron et à ses fils parmi les enfants d'Israël, pour qu'ils fassent le service des enfants d'Israël dans la Tente d'assignation et qu'ils fassent l'expiation pour les enfants d'Israël, afin qu'il n'y ait pas de plaie parmi les enfants d'Israël quand ils s'approchent du sanctuaire. » ");
INSERT INTO frasbl_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Moïse, Aaron et toute l'assemblée des enfants d'Israël firent ainsi aux Lévites. Les enfants d'Israël firent à l'égard des Lévites tout ce que Yahvé avait ordonné à Moïse. ");
INSERT INTO frasbl_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Les Lévites se purifièrent du péché et lavèrent leurs vêtements ; Aaron les offrit en sacrifice par agitation devant Yahvé et Aaron fit pour eux l'expiation pour les purifier. ");
INSERT INTO frasbl_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Après cela, les Lévites entrèrent pour faire leur service dans la Tente de la Rencontre, devant Aaron et devant ses fils ; ils firent à leur égard ce que l'Éternel avait ordonné à Moïse concernant les Lévites. ");
INSERT INTO frasbl_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Yahvé parla à Moïse et dit : ");
INSERT INTO frasbl_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","« Voici ce qui est assigné aux Lévites : à partir de l'âge de vingt-cinq ans, ils iront faire le service dans l'ouvrage de la Tente de la Rencontre ; ");
INSERT INTO frasbl_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","et à partir de l'âge de cinquante ans, ils se retireront de l'ouvrage et ne feront plus de service, ");
INSERT INTO frasbl_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","mais ils assisteront leurs frères dans la Tente de la Rencontre, pour faire le service, et ne feront plus de service. C'est ainsi que tu feras accomplir leurs tâches aux Lévites. » ");
INSERT INTO frasbl_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Yahvé parla à Moïse dans le désert de Sinaï, le premier mois de la deuxième année après leur sortie du pays d'Égypte, et dit : ");
INSERT INTO frasbl_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","« Que les enfants d'Israël célèbrent la Pâque au temps fixé. ");
INSERT INTO frasbl_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Le quatorzième jour de ce mois, au soir, vous la célébrerez au temps fixé. Vous la célébrerez selon toutes ses lois et selon toutes ses ordonnances. » ");
INSERT INTO frasbl_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Moïse dit aux enfants d'Israël qu'ils devaient célébrer la Pâque. ");
INSERT INTO frasbl_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Ils célébrèrent la Pâque au premier mois, le quatorzième jour du mois, au soir, dans le désert du Sinaï. Les enfants d'Israël firent tout ce que Yahvé avait ordonné à Moïse. ");
INSERT INTO frasbl_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Il y avait des hommes qui étaient impurs à cause d'un cadavre d'homme, de sorte qu'ils ne pouvaient pas célébrer la Pâque ce jour-là, et ils se présentèrent devant Moïse et Aaron ce jour-là. ");
INSERT INTO frasbl_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","Ces hommes lui dirent : « Nous sommes impurs à cause du cadavre d'un homme. Pourquoi sommes-nous retenus, afin de ne pas offrir l'offrande de Yahvé au temps fixé parmi les enfants d'Israël ? » ");
INSERT INTO frasbl_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Moïse leur répondit : « Attendez, afin que j'entende ce que l'Éternel commandera à votre sujet. » ");
INSERT INTO frasbl_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Yahvé parla à Moïse, et dit : ");
INSERT INTO frasbl_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","Dis aux enfants d'Israël : « Si l'un d'entre vous ou l'un de vos descendants est impur à cause d'un cadavre, ou s'il est en voyage lointain, il célébrera quand même la Pâque en l'honneur de Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Au deuxième mois, le quatorzième jour, au soir, ils la célébreront ; ils la mangeront avec des pains sans levain et des herbes amères. ");
INSERT INTO frasbl_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Ils n'en laisseront rien jusqu'au matin, et ils n'en briseront pas un os. Ils observeront toutes les règles de la Pâque. ");
INSERT INTO frasbl_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Mais l'homme qui est pur, qui n'est pas en voyage, et qui ne célèbre pas la Pâque, cette personne sera retranchée de son peuple. Parce qu'il n'a pas offert l'offrande de Yahvé au temps fixé, cet homme portera son péché. ");
INSERT INTO frasbl_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","\"'Si un étranger habite parmi vous et désire célébrer la Pâque en l'honneur de Yahvé, il le fera selon le statut de la Pâque et selon son ordonnance. Vous aurez un seul statut, tant pour l'étranger que pour celui qui est né dans le pays. »\" ");
INSERT INTO frasbl_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Le jour où le tabernacle fut élevé, la nuée couvrit le tabernacle, la Tente du Témoignage. Le soir, elle était au-dessus du tabernacle, comme une apparence de feu, jusqu'au matin. ");
INSERT INTO frasbl_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Il en était ainsi continuellement. La nuée le couvrait, et l'aspect du feu pendant la nuit. ");
INSERT INTO frasbl_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Chaque fois que la nuée s'éloignait de la Tente, les enfants d'Israël partaient ; et les enfants d'Israël campaient à l'endroit où la nuée restait. ");
INSERT INTO frasbl_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Sur l'ordre de l'Éternel, les enfants d'Israël partirent, et ils campèrent sur l'ordre de l'Éternel. Tant que la nuée resta sur le tabernacle, ils restèrent campés. ");
INSERT INTO frasbl_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Lorsque la nuée restait plusieurs jours sur le tabernacle, les enfants d'Israël respectaient l'ordre de l'Éternel et ne voyageaient pas. ");
INSERT INTO frasbl_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Parfois, la nuée restait quelques jours sur la tente ; alors, selon le commandement de l'Éternel, ils restaient campés, et selon le commandement de l'Éternel, ils voyageaient. ");
INSERT INTO frasbl_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Parfois la nuée était du soir jusqu'au matin ; et quand la nuée se levait le matin, ils voyageaient ; ou bien, de jour et de nuit, quand la nuée se levait, ils voyageaient. ");
INSERT INTO frasbl_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Que la nuée soit restée sur le tabernacle pendant deux jours, un mois ou un an, les enfants d'Israël restaient campés et ne voyageaient pas ; mais quand elle était levée, ils voyageaient. ");
INSERT INTO frasbl_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Sur l'ordre de Yahvé, ils campaient, et sur l'ordre de Yahvé, ils voyageaient. Ils ont observé l'ordre de Yahvé, sur l'ordre de Yahvé donné par Moïse. ");
INSERT INTO frasbl_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Yahvé parla à Moïse, et dit : ");
INSERT INTO frasbl_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","« Fais deux trompettes d'argent. Tu les feras en travail battu. Tu t'en serviras pour appeler l'assemblée et pour la marche des camps. ");
INSERT INTO frasbl_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Lorsqu'on en soufflera, toute l'assemblée se rassemblera auprès de toi à l'entrée de la tente de la Rencontre. ");
INSERT INTO frasbl_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Si l'on n'en fait retentir qu'une seule, les princes, les chefs des milliers d'Israël, se rassembleront auprès de toi. ");
INSERT INTO frasbl_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Lorsque tu sonneras l'alarme, les camps qui se trouvent à l'est avanceront. ");
INSERT INTO frasbl_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Lorsque tu sonneras une seconde fois, les camps qui se trouvent au sud avanceront. Ils sonneront l'alarme pour leurs déplacements. ");
INSERT INTO frasbl_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Mais quand l'assemblée se réunira, tu sonneras, mais tu ne sonneras pas. ");
INSERT INTO frasbl_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","« Les fils d'Aaron, les prêtres, sonneront des trompettes. Ce sera pour vous une loi à perpétuité, de génération en génération. ");
INSERT INTO frasbl_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Lorsque tu iras à la guerre dans ton pays contre l'adversaire qui t'opprime, tu sonneras des trompettes. Alors on se souviendra de toi devant Yahvé ton Dieu, et tu seras sauvé de tes ennemis. ");
INSERT INTO frasbl_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","« Au jour de ta joie, à tes fêtes et aux débuts de tes mois, tu sonneras des trompettes sur tes holocaustes et sur les sacrifices d'actions de grâces, et ils seront pour toi un mémorial devant ton Dieu. Je suis Yahvé ton Dieu. » ");
INSERT INTO frasbl_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","La deuxième année, au deuxième mois, le vingtième jour du mois, la nuée se retira de dessus le tabernacle de l'alliance. ");
INSERT INTO frasbl_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Les enfants d'Israël partirent du désert du Sinaï, et la nuée resta dans le désert de Paran. ");
INSERT INTO frasbl_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Ils s'avancèrent d'abord selon le commandement de Yahvé par Moïse. ");
INSERT INTO frasbl_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","D'abord, l'étendard du camp des fils de Juda s'avança selon leurs armées. Nachshon, fils d'Amminadab, était à la tête de son armée. ");
INSERT INTO frasbl_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Nethaneel, fils de Zuar, était à la tête de l'armée de la tribu des fils d'Issacar. ");
INSERT INTO frasbl_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Eliab, fils de Hélon, était à la tête de l'armée de la tribu des fils de Zabulon. ");
INSERT INTO frasbl_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Le tabernacle fut démonté ; les fils de Gershon et les fils de Merari, qui portaient le tabernacle, partirent en avant. ");
INSERT INTO frasbl_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","La bannière du camp de Ruben s'avança, selon leurs armées. Elizur, fils de Shedeur, était à la tête de son armée. ");
INSERT INTO frasbl_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Shelumiel, fils de Zurishaddai, commandait l'armée de la tribu des fils de Siméon. ");
INSERT INTO frasbl_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Eliasaph, fils de Deuel, était à la tête de l'armée de la tribu des fils de Gad. ");
INSERT INTO frasbl_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Les Kehathites s'avancèrent, portant le sanctuaire. Les autres ont monté le tabernacle avant leur arrivée. ");
INSERT INTO frasbl_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","L'étendard du camp des fils d'Éphraïm s'avançait selon leurs armées. Élischama, fils d'Ammihud, était à la tête de son armée. ");
INSERT INTO frasbl_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Gamaliel, fils de Pedahzur, était à la tête de l'armée de la tribu des fils de Manassé. ");
INSERT INTO frasbl_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Abidan, fils de Gideoni, était à la tête de l'armée de la tribu des fils de Benjamin. ");
INSERT INTO frasbl_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","L'étendard du camp des fils de Dan, qui était l'arrière-garde de tous les camps, se mit en marche selon leurs armées. Ahiezer, fils d'Ammishaddai, était à la tête de son armée. ");
INSERT INTO frasbl_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Pagiel, fils d'Ochran, commandait l'armée de la tribu des fils d'Aser. ");
INSERT INTO frasbl_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Ahira, fils d'Enan, était à la tête de l'armée de la tribu des fils de Nephtali. ");
INSERT INTO frasbl_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Tels furent les déplacements des enfants d'Israël, selon leurs armées, et ils partirent. ");
INSERT INTO frasbl_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Moïse dit à Hobab, fils de Réuel, le Madianite, beau-père de Moïse : « Nous sommes en route pour le lieu dont Yahvé a dit : « Je te le donnerai ». Viens avec nous, et nous te traiterons bien, car Yahvé a dit du bien d'Israël. » ");
INSERT INTO frasbl_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Il lui dit : « Je n'irai pas, mais je m'en irai dans mon pays et dans ma famille. » ");
INSERT INTO frasbl_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Moïse dit : « Ne nous quitte pas, je t'en prie, car tu sais comment nous devons camper dans le désert, et tu peux être nos yeux. ");
INSERT INTO frasbl_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Il en sera, si tu pars avec nous - oui, il en sera ainsi - que tout le bien que Yahvé nous fera, nous vous en ferons autant. » ");
INSERT INTO frasbl_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Ils partirent de la montagne de Yahvé pour trois jours de marche. L'arche de l'alliance de l'Éternel les précéda de trois jours de marche, pour leur chercher un lieu de repos. ");
INSERT INTO frasbl_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","La nuée de l'Éternel était sur eux pendant le jour, lorsqu'ils quittèrent le camp. ");
INSERT INTO frasbl_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Lorsque l'arche s'avança, Moïse dit : « Lève-toi, Yahvé, et que tes ennemis soient dispersés ! Que ceux qui te haïssent fuient devant toi ! » ");
INSERT INTO frasbl_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Quand elle s'est reposée, il a dit : « Reviens, Yahvé, vers les dix mille des milliers d'Israël. » ");
INSERT INTO frasbl_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Le peuple se plaignait aux oreilles de l'Éternel. Lorsque l'Éternel l'entendit, sa colère s'enflamma ; le feu de l'Éternel brûla au milieu d'eux et consuma une partie des abords du camp. ");
INSERT INTO frasbl_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Le peuple cria à Moïse ; Moïse pria l'Éternel, et le feu s'apaisa. ");
INSERT INTO frasbl_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","On donna à ce lieu le nom de Tabérah, parce que le feu de Yahvé brûlait au milieu d'eux. ");
INSERT INTO frasbl_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","La multitude mélangée qui était au milieu d'eux se livra à des excès de luxure ; et les enfants d'Israël pleurèrent de nouveau, et dirent : Qui nous donnera de la viande à manger ? ");
INSERT INTO frasbl_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Nous nous souvenons du poisson que nous avons mangé pour rien en Égypte, des concombres, des melons, des poireaux, des oignons et de l'ail ; ");
INSERT INTO frasbl_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","mais maintenant nous avons perdu l'appétit. Il n'y a rien du tout, sauf cette manne, à regarder ». ");
INSERT INTO frasbl_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","La manne était semblable à de la graine de coriandre, et elle ressemblait à du bdellium. ");
INSERT INTO frasbl_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Le peuple la parcourait, la ramassait, la broyait dans des moulins, la battait dans des mortiers, la faisait bouillir dans des marmites et en faisait des gâteaux. Son goût était comme celui de l'huile fraîche. ");
INSERT INTO frasbl_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Lorsque la rosée tombait sur le camp pendant la nuit, la manne y tombait. ");
INSERT INTO frasbl_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Moïse entendit le peuple pleurer dans toute sa famille, chacun à l'entrée de sa tente ; la colère de Yahvé s'enflamma, et Moïse fut mécontent. ");
INSERT INTO frasbl_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Moïse dit à Yahvé : « Pourquoi as-tu traité ton serviteur si mal ? Pourquoi n'ai-je pas trouvé grâce à tes yeux, pour que tu fasses peser sur moi le poids de tout ce peuple ? ");
INSERT INTO frasbl_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Ai-je conçu tout ce peuple ? Les ai-je fait sortir pour que tu me dises : Porte-les dans ton sein, comme une nourrice porte un nourrisson, jusqu'au pays que tu as juré à leurs pères ? ");
INSERT INTO frasbl_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Où pourrais-je trouver de la viande pour donner à tous ces gens ? Car ils pleurent devant moi en disant : « Donne-nous de la viande, que nous puissions manger. ");
INSERT INTO frasbl_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Je ne suis pas capable de porter tout ce peuple tout seul, car c'est trop lourd pour moi. ");
INSERT INTO frasbl_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Si tu me traites ainsi, tue-moi tout de suite, si j'ai trouvé grâce à tes yeux, et ne me laisse pas voir ma misère. » ");
INSERT INTO frasbl_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Yahvé dit à Moïse : « Rassemble auprès de moi soixante-dix hommes parmi les anciens d'Israël, que tu connais comme étant les anciens du peuple et ses dirigeants, et amène-les à la tente de la Rencontre, afin qu'ils s'y tiennent avec toi. ");
INSERT INTO frasbl_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Je descendrai et je vous parlerai là. Je prendrai de l'Esprit qui est sur toi et je le mettrai sur eux ; ils porteront avec toi le fardeau du peuple, afin que tu ne le portes pas seul. ");
INSERT INTO frasbl_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","« Dis au peuple : « Sanctifiez-vous en prévision de demain, et vous mangerez de la viande ; car vous avez pleuré aux oreilles de Yahvé, en disant : « Qui nous donnera de la viande à manger ? Car vous avez pleuré aux oreilles de Yahvé, en disant : « Qui nous donnera de la viande à manger, car nous étions bien en Égypte ? ». C'est pourquoi l'Éternel vous donnera de la viande, et vous mangerez. ");
INSERT INTO frasbl_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Vous ne mangerez pas un jour, ni deux jours, ni cinq jours, ni dix jours, ni vingt jours, ");
INSERT INTO frasbl_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","mais un mois entier, jusqu'à ce qu'elle vous vienne aux narines et qu'elle vous soit répugnante ; car vous avez rejeté l'Éternel qui est au milieu de vous, et vous avez pleuré devant lui, en disant : « Pourquoi sommes-nous sortis d'Égypte ? »\". ");
INSERT INTO frasbl_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Moïse dit : « Le peuple au milieu duquel je suis est composé de six cent mille hommes à pied ; et tu as dit : « Je leur donnerai de la viande, pour qu'ils mangent un mois entier ». ");
INSERT INTO frasbl_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Abattra-t-on pour eux des brebis et des bœufs, pour qu'ils en aient assez ? Est-ce qu'on rassemblera pour eux tous les poissons de la mer, pour qu'ils en aient assez ? ». ");
INSERT INTO frasbl_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Yahvé dit à Moïse : « La main de Yahvé est-elle devenue courte ? Tu verras maintenant si ma parole s'accomplira pour toi ou non. » ");
INSERT INTO frasbl_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Moïse sortit, et rapporta au peuple les paroles de Yahvé. Il rassembla soixante-dix hommes parmi les anciens du peuple, et les plaça autour de la Tente. ");
INSERT INTO frasbl_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Yahvé descendit dans la nuée et lui parla ; il prit de l'Esprit qui était sur lui et le mit sur les soixante-dix anciens. Lorsque l'Esprit reposa sur eux, ils prophétisèrent, mais ils ne le firent plus. ");
INSERT INTO frasbl_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Mais deux hommes restèrent dans le camp. Le nom de l'un était Eldad, et le nom de l'autre Médad ; et l'Esprit reposa sur eux. Ils étaient de ceux qui avaient été écrits, mais qui n'étaient pas sortis pour aller à la Tente ; et ils prophétisaient dans le camp. ");
INSERT INTO frasbl_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Un jeune homme courut en informer Moïse, et dit : « Eldad et Médad prophétisent dans le camp ! » ");
INSERT INTO frasbl_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Josué, fils de Nun, serviteur de Moïse, l'un de ses hommes d'élite, répondit : « Mon seigneur Moïse, interdis-leur ! » ");
INSERT INTO frasbl_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Moïse lui dit : « Es-tu jaloux à cause de moi ? Je voudrais que tout le peuple de Yahvé soit prophète, que Yahvé mette son Esprit sur eux ! ». ");
INSERT INTO frasbl_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Moïse entra dans le camp, lui et les anciens d'Israël. ");
INSERT INTO frasbl_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Un vent de Yahvé sortit et fit sortir de la mer des cailles qu'il laissa tomber près du camp, à environ un jour de marche de ce côté et un jour de marche de l'autre côté, autour du camp, et à environ deux coudées au-dessus de la surface de la terre. ");
INSERT INTO frasbl_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Le peuple se leva tout ce jour-là, toute cette nuit-là et tout le lendemain, et il ramassa les cailles. Celui qui en ramassait le moins en ramassait dix, et ils se les répartirent autour du camp. ");
INSERT INTO frasbl_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Comme la viande était encore entre leurs dents, avant qu'ils l'aient mâchée, la colère de l'Éternel s'enflamma contre le peuple, et l'Éternel frappa le peuple d'une très grande plaie. ");
INSERT INTO frasbl_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","On donna à ce lieu le nom de Kibroth Hattaavah, parce qu'on y enterra le peuple qui avait eu de la convoitise. ");
INSERT INTO frasbl_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","De Kibroth Hattaavah, le peuple se rendit à Hatséroth, et il resta à Hatséroth. ");
INSERT INTO frasbl_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Miriam et Aaron parlèrent contre Moïse à cause de la femme de Cuschi qu'il avait épousée, car il avait épousé une femme de Cuschi. ");
INSERT INTO frasbl_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Ils dirent : « Yahvé n'a-t-il parlé qu'à Moïse ? N'a-t-il pas parlé aussi avec nous ? » Et Yahvé les entendit. ");
INSERT INTO frasbl_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Or, l'homme Moïse était très humble, plus que tous les hommes qui étaient à la surface de la terre. ");
INSERT INTO frasbl_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Yahvé parla soudain à Moïse, à Aaron et à Miriam : « Vous trois, sortez de la tente de la Rencontre ! » Ils sortirent tous les trois. ");
INSERT INTO frasbl_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Yahvé descendit dans une colonne de nuée et se tint à l'entrée de la Tente. Il appela Aaron et Miriam, qui s'avancèrent tous deux. ");
INSERT INTO frasbl_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Il dit : « Écoutez maintenant mes paroles. S'il y a un prophète parmi vous, moi, Yahvé, je me ferai connaître à lui dans une vision. Je lui parlerai en songe. ");
INSERT INTO frasbl_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Ce n'est pas le cas de mon serviteur Moïse. Il est fidèle dans toute ma maison. ");
INSERT INTO frasbl_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Avec lui, je parlerai bouche à bouche, en clair et non en énigmes, et il verra la forme de Yahvé. Pourquoi donc n'avez-vous pas craint de parler contre mon serviteur, contre Moïse ? ». ");
INSERT INTO frasbl_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","La colère de Yahvé s'enflamma contre eux, et il s'en alla. ");
INSERT INTO frasbl_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","La nuée se retira de dessus la tente ; et voici, Miriam était lépreuse, blanche comme la neige. Aaron regarda Miriam, et voici qu'elle était lépreuse. ");
INSERT INTO frasbl_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Aaron dit à Moïse : « Oh, mon seigneur, ne nous compte pas ce péché, dans lequel nous avons fait des folies et dans lequel nous avons péché. ");
INSERT INTO frasbl_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Qu'elle ne soit pas, je t'en prie, comme un mort dont la chair est à moitié consumée lorsqu'il sort du ventre de sa mère. » ");
INSERT INTO frasbl_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Moïse cria à Yahvé en disant : « Guéris-la, Dieu, je t'en supplie ! » ");
INSERT INTO frasbl_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Yahvé dit à Moïse : « Si son père lui a craché au visage, ne devrait-elle pas avoir honte pendant sept jours ? Qu'elle soit enfermée hors du camp pendant sept jours, et après cela elle sera ramenée. » ");
INSERT INTO frasbl_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Miriam fut enfermée hors du camp pendant sept jours, et le peuple ne voyagea pas jusqu'à ce que Miriam ait été ramenée. ");
INSERT INTO frasbl_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Ensuite, le peuple partit de Hatséroth et campa dans le désert de Paran. ");
INSERT INTO frasbl_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Yahvé parla à Moïse, et dit : ");
INSERT INTO frasbl_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","« Envoie des hommes, pour qu'ils explorent le pays de Canaan, que je donne aux enfants d'Israël. De chaque tribu de leurs pères, tu enverras un homme, chacun étant un prince parmi eux. » ");
INSERT INTO frasbl_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Moïse les envoya du désert de Paran, selon le commandement de l'Éternel. Tous étaient des hommes qui étaient des chefs des enfants d'Israël. ");
INSERT INTO frasbl_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Voici leurs noms : De la tribu de Ruben, Shammua, fils de Zaccur. ");
INSERT INTO frasbl_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","De la tribu de Siméon : Shaphat, fils de Hori. ");
INSERT INTO frasbl_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Pour la tribu de Juda, Caleb, fils de Jephunné. ");
INSERT INTO frasbl_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Pour la tribu d'Issachar, Igal, fils de Joseph. ");
INSERT INTO frasbl_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Pour la tribu d'Éphraïm, Hoshea, fils de Nun. ");
INSERT INTO frasbl_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","De la tribu de Benjamin, Palti, fils de Raphu. ");
INSERT INTO frasbl_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","De la tribu de Zabulon : Gaddiel, fils de Sodi. ");
INSERT INTO frasbl_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","De la tribu de Joseph, de la tribu de Manassé, Gaddi, fils de Susi. ");
INSERT INTO frasbl_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","De la tribu de Dan : Ammiel, fils de Gemalli. ");
INSERT INTO frasbl_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","De la tribu d'Asher, Sethur, fils de Michel. ");
INSERT INTO frasbl_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Pour la tribu de Nephtali : Nahbi, fils de Vophsi. ");
INSERT INTO frasbl_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","De la tribu de Gad, Geuel, fils de Machi. ");
INSERT INTO frasbl_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Voici les noms des hommes que Moïse envoya pour explorer le pays. Moïse appela Josué Hosée, fils de Nun. ");
INSERT INTO frasbl_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Moïse les envoya pour explorer le pays de Canaan, et leur dit : Passez par le midi, et montez sur la montagne. ");
INSERT INTO frasbl_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Voyez le pays, ce qu'il est, et le peuple qui l'habite, s'il est fort ou faible, s'il est en petit nombre ou en grand nombre ; ");
INSERT INTO frasbl_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","ce qu'est le pays qu'ils habitent, s'il est bon ou mauvais ; et quelles sont les villes qu'ils habitent, soit dans des camps, soit dans des forteresses ; ");
INSERT INTO frasbl_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","et ce qu'est le pays, s'il est fertile ou pauvre, s'il y a du bois ou non. Soyez courageux, et apportez du fruit du pays. » Or le temps était celui des raisins de première maturité. ");
INSERT INTO frasbl_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Ils montèrent et explorèrent le pays, depuis le désert de Tsin jusqu'à Rehob, et jusqu'à l'entrée de Hamath. ");
INSERT INTO frasbl_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Ils montèrent par le midi, et arrivèrent à Hébron. Là se trouvaient Ahiman, Schéschaï et Talmaï, fils d'Anak. (Or Hébron fut bâtie sept ans avant Zoan, en Égypte.) ");
INSERT INTO frasbl_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Ils arrivèrent à la vallée d'Eschcol, et ils y coupèrent une branche portant une grappe de raisin, qu'ils portèrent sur un bâton entre deux. Ils apportèrent aussi des grenades et des figues. ");
INSERT INTO frasbl_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Ce lieu fut appelé la vallée d'Eshcol, à cause de la grappe que les enfants d'Israël y coupèrent. ");
INSERT INTO frasbl_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Ils revinrent après avoir exploré le pays, au bout de quarante jours. ");
INSERT INTO frasbl_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Ils allèrent trouver Moïse, Aaron et toute l'assemblée des enfants d'Israël, dans le désert de Paran, à Kadès, et ils leur rapportèrent des nouvelles, ainsi qu'à toute l'assemblée. Ils leur montrèrent les fruits du pays. ");
INSERT INTO frasbl_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Ils lui en firent part et dirent : « Nous sommes arrivés dans le pays où tu nous as envoyés. Certes, il coule du lait et du miel, et voici son fruit. ");
INSERT INTO frasbl_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Mais les habitants du pays sont forts, et les villes sont fortifiées et très grandes. De plus, nous y avons vu les enfants d'Anak. ");
INSERT INTO frasbl_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Amalek habite dans le pays du Sud. Le Hittite, le Jébusien et l'Amoréen habitent dans la région des collines. Les Cananéens habitent près de la mer et sur les bords du Jourdain. » ");
INSERT INTO frasbl_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Caleb fit taire le peuple devant Moïse, et dit : « Montons tout de suite et possédons-la, car nous sommes bien capables de la vaincre ! » ");
INSERT INTO frasbl_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Mais les hommes qui étaient montés avec lui dirent : « Nous ne pouvons pas monter contre ce peuple, car il est plus fort que nous. » ");
INSERT INTO frasbl_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Ils firent aux enfants d'Israël un mauvais rapport sur le pays qu'ils avaient exploré, en disant : « Le pays que nous avons traversé pour l'explorer est un pays qui dévore ses habitants, et tous ceux que nous y avons vus sont des hommes de grande taille. ");
INSERT INTO frasbl_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Là, nous avons vu les Nephilim, les fils d'Anak, qui viennent des Nephilim. Nous étions à nos propres yeux comme des sauterelles, et nous étions ainsi à leurs yeux. » ");
INSERT INTO frasbl_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Toute l'assemblée éleva la voix et poussa des cris, et le peuple pleura cette nuit-là. ");
INSERT INTO frasbl_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Tous les enfants d'Israël murmurèrent contre Moïse et contre Aaron. Toute l'assemblée leur dit : « Nous aurions voulu mourir au pays d'Égypte, ou mourir dans ce désert ! ");
INSERT INTO frasbl_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Pourquoi Yahvé nous fait-il venir dans ce pays, pour que nous tombions par l'épée ? Nos femmes et nos petits enfants seront capturés ou tués ! Ne vaudrait-il pas mieux pour nous de retourner en Égypte ? » ");
INSERT INTO frasbl_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Ils se dirent les uns aux autres : « Choisissons un chef et retournons en Égypte. » ");
INSERT INTO frasbl_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Et Moïse et Aaron tombèrent sur leur visage devant toute l'assemblée des enfants d'Israël. ");
INSERT INTO frasbl_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Josué, fils de Nun, et Caleb, fils de Jephunné, qui étaient de ceux qui avaient exploré le pays, déchirèrent leurs vêtements. ");
INSERT INTO frasbl_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Ils parlèrent à toute l'assemblée des enfants d'Israël, en disant : « Le pays que nous avons traversé pour l'explorer est un pays extrêmement bon. ");
INSERT INTO frasbl_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Si Yahvé se plaît en nous, il nous fera entrer dans ce pays et nous le donnera : un pays où coulent le lait et le miel. ");
INSERT INTO frasbl_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Seulement, ne vous révoltez pas contre Yahvé, et ne craignez pas les habitants du pays, car ils sont notre pain. Leur défense s'est retirée au-dessus d'eux, et Yahvé est avec nous. Ne les craignez pas. » ");
INSERT INTO frasbl_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Mais toute la congrégation menaçait de les lapider. La gloire de Yahvé apparut dans la Tente de la Rencontre à tous les enfants d'Israël. ");
INSERT INTO frasbl_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Yahvé dit à Moïse : « Jusques à quand ce peuple me méprisera-t-il ? Jusques à quand ne croiront-ils pas en moi, à cause de tous les signes que j'ai accomplis au milieu d'eux ? ");
INSERT INTO frasbl_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Je les frapperai de la peste, je les déshériterai et je ferai de vous une nation plus grande et plus puissante qu'eux. » ");
INSERT INTO frasbl_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Moïse dit à Yahvé : « Les Égyptiens l'entendront, car c'est par ta puissance que tu as fait sortir ce peuple du milieu d'eux. ");
INSERT INTO frasbl_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Ils le diront aux habitants de ce pays. Ils ont appris que toi, Yahvé, tu es au milieu de ce peuple, car on te voit face à face, et ta nuée se tient au-dessus d'eux, et tu marches devant eux, dans une colonne de nuée le jour, et dans une colonne de feu la nuit. ");
INSERT INTO frasbl_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Si tu as tué ce peuple comme un seul homme, les nations qui ont entendu parler de toi diront : ");
INSERT INTO frasbl_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","« Parce que l'Éternel n'a pas pu faire entrer ce peuple dans le pays qu'il lui avait promis, il l'a tué dans le désert ». ");
INSERT INTO frasbl_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Maintenant, que la puissance de l'Éternel soit grande, comme vous l'avez dit, en disant : ");
INSERT INTO frasbl_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","« L'Éternel est lent à la colère et riche en bonté, il pardonne l'iniquité et la désobéissance ; il ne pardonne pas les coupables, il fait retomber l'iniquité des pères sur les enfants, sur la troisième et la quatrième génération. ");
INSERT INTO frasbl_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Pardonne, je te prie, l'iniquité de ce peuple, selon la grandeur de ta bonté, et comme tu as pardonné à ce peuple, depuis l'Égypte jusqu'à maintenant. » ");
INSERT INTO frasbl_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","L'Éternel dit : J'ai pardonné selon ta parole ; ");
INSERT INTO frasbl_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","mais, en vérité, comme je suis vivant et que toute la terre sera remplie de la gloire de l'Éternel, ");
INSERT INTO frasbl_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","parce que tous ces hommes qui ont vu ma gloire et les signes que j'ai opérés en Égypte et dans le désert, m'ont tenté dix fois et n'ont pas écouté ma voix, ");
INSERT INTO frasbl_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","ils ne verront pas le pays que j'ai juré à leurs pères, et aucun de ceux qui m'ont méprisé ne le verra. ");
INSERT INTO frasbl_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Mais mon serviteur Caleb, parce qu'il avait avec lui un autre esprit et qu'il m'a entièrement suivi, lui, je le ferai entrer dans le pays où il est allé. Sa descendance le possédera. ");
INSERT INTO frasbl_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Puisque l'Amalécite et le Cananéen habitent dans la vallée, demain, tournez-vous et allez dans le désert par le chemin de la mer Rouge. » ");
INSERT INTO frasbl_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Yahvé parla à Moïse et à Aaron, et dit : ");
INSERT INTO frasbl_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","« Jusqu'à quand supporterai-je cette méchante assemblée qui se plaint de moi ? J'ai entendu les plaintes des enfants d'Israël, qui se plaignent de moi. ");
INSERT INTO frasbl_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Dis-leur : Je suis vivant, dit l'Éternel, et je vous ferai ce que vous avez dit à mes oreilles. ");
INSERT INTO frasbl_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Vos cadavres tomberont dans ce désert ; et tous ceux d'entre vous qui ont été comptés, selon votre nombre total, depuis l'âge de vingt ans et au-dessus, et qui se sont plaints de moi, ");
INSERT INTO frasbl_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","vous n'entrerez pas dans le pays que j'ai juré de vous faire habiter, excepté Caleb, fils de Jephunné, et Josué, fils de Nun. ");
INSERT INTO frasbl_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Mais je ferai venir vos petits enfants que vous avez dit devoir être capturés ou tués, et ils connaîtront le pays que vous avez rejeté. ");
INSERT INTO frasbl_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Mais quant à vous, vos cadavres tomberont dans ce désert. ");
INSERT INTO frasbl_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Vos enfants seront errants dans le désert pendant quarante ans, et porteront votre prostitution, jusqu'à ce que vos cadavres soient consumés dans le désert. ");
INSERT INTO frasbl_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Après le nombre de jours pendant lesquels vous avez exploré le pays, quarante jours, car chaque jour est une année, vous porterez vos fautes, quarante ans, et vous connaîtrez mon aliénation'. ");
INSERT INTO frasbl_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Moi, Yahvé, j'ai parlé. Je vais faire cela à toute cette méchante assemblée qui s'est réunie contre moi. Dans ce désert, ils seront consumés, et c'est là qu'ils mourront. » ");
INSERT INTO frasbl_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Les hommes que Moïse avait envoyés pour explorer le pays et qui, à leur retour, avaient poussé toute l'assemblée à murmurer contre lui en rapportant un mauvais rapport sur le pays, ");
INSERT INTO frasbl_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","ces hommes qui avaient rapporté un mauvais rapport sur le pays, moururent par la peste devant Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Mais Josué, fils de Nun, et Caleb, fils de Jephunné, restèrent en vie parmi les hommes qui étaient allés explorer le pays. ");
INSERT INTO frasbl_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Moïse rapporta ces paroles à tous les enfants d'Israël, et le peuple se lamenta beaucoup. ");
INSERT INTO frasbl_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Ils se levèrent de bon matin et montèrent au sommet de la montagne, en disant : « Voici, nous sommes ici, et nous monterons au lieu que l'Éternel a promis, car nous avons péché. » ");
INSERT INTO frasbl_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Moïse dit : « Pourquoi désobéissez-vous maintenant au commandement de l'Éternel, puisqu'il ne prospérera pas ? ");
INSERT INTO frasbl_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Ne montez pas, car l'Éternel n'est pas au milieu de vous ; ainsi, vous ne serez pas terrassés devant vos ennemis. ");
INSERT INTO frasbl_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Car là, l'Amalécite et le Cananéen sont devant toi, et tu tomberas par l'épée parce que tu t'es détourné de suivre l'Yahvé ; c'est pourquoi l'Yahvé ne sera pas avec toi. » ");
INSERT INTO frasbl_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Mais ils s'enhardirent à monter au sommet de la montagne. Néanmoins, l'arche de l'alliance de Yahvé et Moïse ne sortirent pas du camp. ");
INSERT INTO frasbl_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Alors les Amalécites descendirent, ainsi que les Cananéens qui habitaient cette montagne, et ils les frappèrent et les battirent jusqu'à Horma. ");
INSERT INTO frasbl_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Yahvé parla à Moïse, et dit : ");
INSERT INTO frasbl_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","Parle aux enfants d'Israël, et dis-leur : Lorsque vous serez entrés dans le pays de vos habitations, que je vous donne, ");
INSERT INTO frasbl_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","et que vous ferez une offrande par le feu à Yahvé - holocauste, sacrifice, accomplissement d'un vœu, ou comme offrande volontaire, ou encore, à l'occasion de vos fêtes, pour offrir à l'Éternel un parfum agréable, qu'il s'agisse d'une offrande de gros ou de menu bétail. ");
INSERT INTO frasbl_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","Celui qui présentera son offrande offrira à l'Éternel une offrande de repas composée d'un dixième d'épha de fleur de farine mélangé à un quart de hin d'huile. ");
INSERT INTO frasbl_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Tu prépareras du vin pour la libation, un quart de hin, avec l'holocauste ou pour le sacrifice, pour chaque agneau. ");
INSERT INTO frasbl_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","\"'Pour un bélier, tu prépareras en offrande deux dixièmes d'épha de fleur de farine mélangée à un tiers de hin d'huile ; ");
INSERT INTO frasbl_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","et pour la libation, tu offriras un tiers de hin de vin, d'une odeur agréable à Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Si tu prépares un taureau pour un holocauste ou un sacrifice, pour l'accomplissement d'un vœu ou pour un sacrifice de prospérité à l'Éternel, ");
INSERT INTO frasbl_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","tu offriras avec le taureau une offrande de trois dixièmes d'épha de fleur de farine mélangée à un demi-hin d'huile ; ");
INSERT INTO frasbl_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","et tu offriras en libation un demi-hin de vin, comme offrande consumée par le feu, d'une agréable odeur à l'Éternel. ");
INSERT INTO frasbl_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Il en sera ainsi pour chaque taureau, pour chaque bélier, pour chacun des agneaux mâles ou des chevreaux. ");
INSERT INTO frasbl_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Selon le nombre que vous préparerez, vous ferez à chacun selon son nombre. ");
INSERT INTO frasbl_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","\"'Tous ceux qui sont nés chez vous feront ces choses de cette manière, en offrant une offrande consumée par le feu, d'une odeur agréable à Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Si un étranger vit comme un étranger chez vous, ou qui que ce soit parmi vous à travers vos générations, et qu'il offre une offrande faite par le feu, d'une odeur agréable à l'Éternel, comme vous le faites, il fera de même. ");
INSERT INTO frasbl_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Pour l'assemblée, il y aura un statut unique pour vous et pour l'étranger qui vit comme un étranger, un statut pour toujours, de génération en génération. Tel que vous êtes, tel sera l'étranger devant l'Éternel. ");
INSERT INTO frasbl_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Une seule loi et une seule ordonnance seront pour vous et pour l'étranger qui vit en étranger avec vous.'\" ");
INSERT INTO frasbl_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","L'Éternel parla à Moïse, et dit : ");
INSERT INTO frasbl_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","Parle aux enfants d'Israël, et dis-leur : Quand vous serez entrés dans le pays où je vous conduirai, ");
INSERT INTO frasbl_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","lorsque vous mangerez du pain du pays, vous offrirez une offrande à l'Éternel. ");
INSERT INTO frasbl_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Du premier morceau de ta pâte, tu offriras un gâteau en guise d'offrande par agitation. Tu l'offriras par élévation, comme l'ondoiement de l'aire de battage. ");
INSERT INTO frasbl_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Tu présenteras à l'Éternel, de génération en génération, une offrande par agitation des premières pièces de ta pâte. ");
INSERT INTO frasbl_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","\"'Si vous commettez une erreur et n'observez pas tous ces commandements que Yahvé a adressés à Moïse- ");
INSERT INTO frasbl_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","tout ce que Yahvé vous a commandé par Moïse, depuis le jour où Yahvé a donné le commandement et à travers vos générations - ");
INSERT INTO frasbl_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","alors il en sera ainsi, si cela s'est fait involontairement, à l'insu de l'assemblée, toute l'assemblée offrira un jeune taureau en holocauste, en odeur agréable à Yahvé, avec son offrande et sa libation, selon l'ordonnance, et un bouc en sacrifice pour le péché. ");
INSERT INTO frasbl_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Le prêtre fera l'expiation pour toute l'assemblée des enfants d'Israël, et il leur sera pardonné ; car c'était une erreur, et ils ont apporté leur offrande, un sacrifice consumé par le feu à l'Éternel, et leur sacrifice pour le péché devant l'Éternel, à cause de leur erreur. ");
INSERT INTO frasbl_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Toute l'assemblée des enfants d'Israël sera pardonnée, ainsi que l'étranger qui vit au milieu d'eux en tant qu'étranger, car pour tout le peuple, c'était une faute involontaire. ");
INSERT INTO frasbl_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","\"'Si quelqu'un pèche involontairement, il offrira en sacrifice pour le péché une chèvre d'un an. ");
INSERT INTO frasbl_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Le prêtre fera l'expiation pour l'âme qui s'est trompée en péchant involontairement devant Yahvé. Il fera pour lui l'expiation, et il lui sera pardonné. ");
INSERT INTO frasbl_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Vous aurez une seule loi pour celui qui fait quelque chose involontairement, pour celui qui est né parmi les enfants d'Israël et pour l'étranger qui vit au milieu d'eux. ");
INSERT INTO frasbl_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","\"'Mais l'âme qui fait quelque chose de hautain, qu'elle soit native ou étrangère, blasphème Yahvé. Cette âme sera retranchée du milieu de son peuple. ");
INSERT INTO frasbl_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Parce qu'il a méprisé la parole de Yahvé, parce qu'il a violé son commandement, cette âme-là sera exterminée. Son iniquité retombera sur lui.'\" ");
INSERT INTO frasbl_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Comme les enfants d'Israël étaient dans le désert, ils trouvèrent un homme qui ramassait des bâtons le jour du sabbat. ");
INSERT INTO frasbl_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Ceux qui l'avaient trouvé ramassant des brindilles l'amenèrent à Moïse et à Aaron, et à toute l'assemblée. ");
INSERT INTO frasbl_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Ils le mirent en détention, parce qu'on n'avait pas déclaré ce qu'on devait lui faire. ");
INSERT INTO frasbl_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Yahvé dit à Moïse : « Cet homme sera mis à mort. Toute l'assemblée le lapidera hors du camp. » ");
INSERT INTO frasbl_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Toute l'assemblée l'amena hors du camp et le lapida à mort, comme Yahvé l'avait ordonné à Moïse. ");
INSERT INTO frasbl_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","L'Éternel parla à Moïse, et dit : ");
INSERT INTO frasbl_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","Parle aux enfants d'Israël, et dis-leur qu'ils se fassent des franges aux bordures de leurs vêtements, pendant toute leur vie, et qu'ils mettent à la frange de chaque bord un cordon bleu. ");
INSERT INTO frasbl_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Ce sera pour vous une frange, afin que vous la voyiez, que vous vous souveniez de tous les commandements de l'Éternel et que vous les mettiez en pratique, et que vous ne suiviez pas votre propre cœur et vos propres yeux, selon lesquels vous aviez l'habitude de vous prostituer, ");
INSERT INTO frasbl_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","afin que vous vous souveniez de tous mes commandements et que vous les mettiez en pratique, et que vous soyez saints pour votre Dieu. ");
INSERT INTO frasbl_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Je suis Yahvé, ton Dieu, qui t'a fait sortir du pays d'Égypte, pour être ton Dieu : Je suis Yahvé, ton Dieu. » ");
INSERT INTO frasbl_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Or Koré, fils de Jitsehar, fils de Kehath, fils de Lévi, avec Dathan et Abiram, fils d'Éliab, et On, fils de Péleth, fils de Ruben, prirent quelques hommes. ");
INSERT INTO frasbl_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","Ils se levèrent devant Moïse, avec une partie des enfants d'Israël, deux cent cinquante chefs de l'assemblée, appelés à l'assemblée, hommes de renom. ");
INSERT INTO frasbl_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Ils s'assemblèrent contre Moïse et Aaron, et leur dirent : « Vous prenez trop sur vous, car toute l'assemblée est sainte, chacun d'eux, et Yahvé est au milieu d'eux ! Pourquoi vous élevez-vous au-dessus de l'assemblée de Yahvé ? » ");
INSERT INTO frasbl_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Lorsque Moïse l'entendit, il tomba sur sa face. ");
INSERT INTO frasbl_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Il dit à Koré et à toute sa troupe : « Demain matin, l'Éternel fera connaître qui est à lui et qui est saint, et il le fera approcher de lui. Il fera approcher de lui celui qu'il choisira. ");
INSERT INTO frasbl_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Fais ceci : que Koré et toute sa troupe prennent des encensoirs, ");
INSERT INTO frasbl_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","y mettent du feu et y déposent de l'encens devant Yahvé demain. L'homme que choisira Yahvé sera saint. Vous êtes allés trop loin, fils de Lévi ! » ");
INSERT INTO frasbl_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Moïse dit à Koré : « Écoutez, fils de Lévi ! ");
INSERT INTO frasbl_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Est-ce peu de chose pour vous que le Dieu d'Israël vous ait séparés de l'assemblée d'Israël, pour vous faire approcher de lui, afin que vous fassiez le service de la tente de l'Éternel et que vous vous teniez devant l'assemblée pour la servir ? ");
INSERT INTO frasbl_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Et qu'il vous ait fait approcher, et tous vos frères, les fils de Lévi, avec vous ? Cherchez-vous aussi le sacerdoce ? ");
INSERT INTO frasbl_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","C'est pourquoi vous vous êtes rassemblés, toi et toute ta troupe, contre Yahvé ! Qu'est-ce qu'Aaron pour que vous vous plaigniez de lui ? » ");
INSERT INTO frasbl_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Moïse envoya appeler Dathan et Abiram, les fils d'Eliab, et ils dirent : « Nous ne monterons pas ! ");
INSERT INTO frasbl_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Est-ce peu de chose que tu nous aies fait monter d'un pays où coulent le lait et le miel, pour nous tuer dans le désert, et que tu te fasses aussi prince sur nous ? ");
INSERT INTO frasbl_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Tu ne nous as pas fait entrer dans un pays où coulent le lait et le miel, et tu ne nous as pas donné en héritage des champs et des vignes. Veux-tu crever les yeux de ces hommes ? Nous ne monterons pas. » ");
INSERT INTO frasbl_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Moïse se mit dans une grande colère et dit à Yahvé : « Ne respecte pas leur offrande. Je ne leur ai pas pris un seul âne, et je n'ai fait de mal à aucun d'entre eux. » ");
INSERT INTO frasbl_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Moïse dit à Koré : « Toi et toute ta troupe, vous irez demain devant l'Éternel, toi, eux et Aaron. ");
INSERT INTO frasbl_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Chacun prendra son encensoir et y mettra du parfum, et chacun apportera devant l'Éternel son encensoir, deux cent cinquante encensoirs ; toi aussi, et Aaron, chacun avec son encensoir. » ");
INSERT INTO frasbl_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Ils prirent chacun leur encensoir, y mirent du feu, y déposèrent du parfum, et se tinrent à l'entrée de la Tente de la Rencontre avec Moïse et Aaron. ");
INSERT INTO frasbl_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Koré rassembla toute la congrégation en face d'eux à l'entrée de la Tente de la Rencontre. La gloire de Yahvé apparut à toute l'assemblée. ");
INSERT INTO frasbl_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Yahvé parla à Moïse et à Aaron, et dit : ");
INSERT INTO frasbl_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","« Retirez-vous du milieu de cette assemblée, afin que je les consume en un instant. » ");
INSERT INTO frasbl_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Ils tombèrent sur leur face, et dirent : « Dieu, le Dieu des esprits de toute chair, si un seul homme pèche, seras-tu irrité contre toute l'assemblée ? » ");
INSERT INTO frasbl_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Yahvé parla à Moïse et dit : ");
INSERT INTO frasbl_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","« Parle à l'assemblée, et dis : « Ne restez pas autour de la tente de Koré, de Dathan et d'Abiram. ");
INSERT INTO frasbl_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Moïse se leva et alla vers Dathan et Abiram, et les anciens d'Israël le suivirent. ");
INSERT INTO frasbl_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Il parla à l'assemblée en disant : « Sortez, je vous prie, des tentes de ces méchants hommes, et ne touchez à rien de ce qui leur appartient, de peur que vous ne soyez consumés par tous leurs péchés ! ». ");
INSERT INTO frasbl_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Et ils s'éloignèrent de la tente de Koré, de Dathan et d'Abiram, de tous côtés. Dathan et Abiram sortirent, et se tinrent à l'entrée de leurs tentes, avec leurs femmes, leurs fils et leurs petits enfants. ");
INSERT INTO frasbl_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Moïse dit : « Vous saurez ainsi que c'est Yahvé qui m'a envoyé faire toutes ces choses, car elles ne viennent pas de ma propre volonté. ");
INSERT INTO frasbl_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Si ces hommes meurent de la mort commune à tous les hommes, ou s'ils éprouvent ce que tous les hommes éprouvent, alors Yahvé ne m'a pas envoyé. ");
INSERT INTO frasbl_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Mais si Yahvé fait du nouveau, si la terre ouvre sa bouche et les engloutit avec tout ce qui leur appartient, et qu'ils descendent vivants dans le séjour des morts, alors vous comprendrez que ces hommes ont méprisé Yahvé. » ");
INSERT INTO frasbl_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Comme il achevait de prononcer toutes ces paroles, le sol qui était sous eux se fendit. ");
INSERT INTO frasbl_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","La terre ouvrit sa bouche et les engloutit avec leurs familles, tous les hommes de Koré et tous leurs biens. ");
INSERT INTO frasbl_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Ils descendirent vivants dans le séjour des morts, avec tout ce qui leur appartenait. La terre se referma sur eux, et ils périrent du milieu de l'assemblée. ");
INSERT INTO frasbl_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Tout Israël qui les entourait s'enfuit à leur cri, car ils disaient : « De peur que la terre ne nous engloutisse ». ");
INSERT INTO frasbl_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Le feu sortit de Yahvé et dévora les deux cent cinquante hommes qui offraient le parfum. ");
INSERT INTO frasbl_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Yahvé parla à Moïse, et dit : ");
INSERT INTO frasbl_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","Parle à Éléazar, fils du sacrificateur Aaron, pour qu'il retire les brasiers de l'ardeur, et qu'il disperse le feu loin du camp, car ils sont saints, ");
INSERT INTO frasbl_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","même les brasiers de ceux qui ont péché contre leur propre vie. Qu'on en fasse des plaques pour couvrir l'autel, car ils les ont offerts devant Yahvé. C'est pourquoi ils sont saints. Ils seront un signe pour les enfants d'Israël. » ");
INSERT INTO frasbl_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Le sacrificateur Éléazar prit les brasiers d'airain que les brûlés avaient offerts, et il les battit pour couvrir l'autel, ");
INSERT INTO frasbl_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","afin que ce soit un souvenir pour les enfants d'Israël, et qu'aucun étranger qui ne soit pas de la race d'Aaron ne s'approche pour offrir des parfums devant l'Éternel, afin qu'il ne soit pas comme Koré et comme sa troupe, comme l'Éternel le lui a dit par Moïse. ");
INSERT INTO frasbl_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Mais le lendemain, toute l'assemblée des enfants d'Israël se plaignit de Moïse et d'Aaron, en disant : « Vous avez tué le peuple de l'Éternel. » ");
INSERT INTO frasbl_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Lorsque l'assemblée s'assembla contre Moïse et contre Aaron, elle regarda vers la tente de la Rencontre. Et voici, la nuée la couvrait, et la gloire de Yahvé apparaissait. ");
INSERT INTO frasbl_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Moïse et Aaron arrivèrent devant la tente de la Rencontre. ");
INSERT INTO frasbl_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Yahvé parla à Moïse et lui dit : ");
INSERT INTO frasbl_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","« Retirez-vous du milieu de cette assemblée, afin que je la consume en un instant. » Ils tombèrent sur leur visage. ");
INSERT INTO frasbl_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Moïse dit à Aaron : « Prends ton encensoir, mets-y le feu de l'autel, pose-y de l'encens, porte-le rapidement à l'assemblée, et fais l'expiation pour eux, car la colère est sortie de Yahvé. La plaie a commencé. » ");
INSERT INTO frasbl_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Aaron fit ce que Moïse avait dit, et courut au milieu de l'assemblée. La peste avait déjà commencé parmi le peuple. Il mit l'encens et fit l'expiation pour le peuple. ");
INSERT INTO frasbl_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Il se plaça entre les morts et les vivants, et la peste fut arrêtée. ");
INSERT INTO frasbl_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Ceux qui moururent de la peste furent quatorze mille sept cents, sans compter ceux qui moururent à cause de l'affaire de Koré. ");
INSERT INTO frasbl_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Aaron retourna vers Moïse à l'entrée de la tente de la Rencontre, et la peste fut arrêtée. ");
INSERT INTO frasbl_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Yahvé parla à Moïse, et dit : ");
INSERT INTO frasbl_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","« Parle aux enfants d'Israël, et prends chez eux des verges, une pour chaque maison paternelle, de tous leurs princes selon leurs maisons paternelles, soit douze verges. Tu écriras le nom de chaque homme sur sa verge. ");
INSERT INTO frasbl_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Tu écriras le nom d'Aaron sur la verge de Lévi. Il y aura une verge pour chaque chef des maisons de leurs pères. ");
INSERT INTO frasbl_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Tu les déposeras dans la tente d'assignation, devant l'alliance, là où je me rencontre avec toi. ");
INSERT INTO frasbl_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Il arrivera que la verge de l'homme que je choisirai bourgeonnera. Je ferai cesser de ma part les murmures des enfants d'Israël, qu'ils murmurent contre toi. » ");
INSERT INTO frasbl_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Moïse parla aux enfants d'Israël ; et tous leurs princes lui donnèrent des verges, pour chaque prince, selon les maisons de leurs pères, soit un total de douze verges. La baguette d'Aaron était parmi leurs baguettes. ");
INSERT INTO frasbl_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Moïse déposa les verges devant Yahvé, dans la tente du Témoignage. ");
INSERT INTO frasbl_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Le lendemain, Moïse entra dans la tente du témoignage ; et voici, la verge d'Aaron pour la maison de Lévi avait poussé, bourgeonné, produit des fleurs et porté des amandes mûres. ");
INSERT INTO frasbl_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Moïse fit sortir toutes les verges de devant Yahvé pour tous les enfants d'Israël. Ils regardèrent, et chacun prit sa verge. ");
INSERT INTO frasbl_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Yahvé dit à Moïse : « Remets la verge d'Aaron devant l'alliance, pour qu'elle serve de gage aux enfants rebelles, afin que tu mettes fin à leurs plaintes contre moi et qu'ils ne meurent pas. » ");
INSERT INTO frasbl_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Moïse fit ainsi. Il fit ce que Yahvé lui avait ordonné. ");
INSERT INTO frasbl_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Les enfants d'Israël dirent à Moïse : « Voici, nous périssons ! Nous sommes perdus ! Nous sommes tous perdus ! ");
INSERT INTO frasbl_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Tousceux qui s'approchent du tabernacle de Yahvé meurent ! Allons-nous tous périr ? » ");
INSERT INTO frasbl_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Yahvé dit à Aaron : « Toi, tes fils et la maison de tes pères avec toi, vous porterez l'iniquité du sanctuaire ; toi et tes fils avec toi, vous porterez l'iniquité de votre sacerdoce. ");
INSERT INTO frasbl_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Fais aussi approcher de toi tes frères, la tribu de Lévi, la tribu de ton père, afin qu'ils soient associés à toi et qu'ils te servent ; mais toi et tes fils avec toi, vous serez devant la tente du témoignage. ");
INSERT INTO frasbl_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Ils observeront tes ordres et les devoirs de toute la tente ; seulement, ils ne s'approcheront pas des ustensiles du sanctuaire ni de l'autel, afin qu'ils ne meurent pas, ni eux ni toi. ");
INSERT INTO frasbl_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Ils s'attacheront à toi et garderont la responsabilité de la Tente de la Rencontre, pour tout le service de la Tente. L'étranger ne s'approchera pas de toi. ");
INSERT INTO frasbl_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Vous accomplirez les fonctions du sanctuaire et de l'autel, afin qu'il n'y ait plus de colère contre les enfants d'Israël. ");
INSERT INTO frasbl_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Voici, j'ai pris moi-même vos frères les Lévites parmi les enfants d'Israël. Ils te sont offerts, ils sont consacrés à l'Éternel, pour faire le service de la Tente de la Rencontre. ");
INSERT INTO frasbl_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Toi et tes fils avec toi, vous exercerez votre sacerdoce pour tout ce qui concerne l'autel et ce qui est en deçà du voile. Tu feras le service. Je vous fais don du service de la prêtrise. L'étranger qui s'approchera sera mis à mort. » ");
INSERT INTO frasbl_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Yahvé parla à Aaron : « Voici, je t'ai donné moi-même l'ordre d'offrir mes offrandes par agitation, toutes les choses saintes des enfants d'Israël. Je te les ai données, à cause de l'onction, ainsi qu'à tes fils, comme une part pour toujours. ");
INSERT INTO frasbl_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Voici ce qui vous appartiendra parmi les choses très saintes du feu : toute offrande qu'ils m'offriront, toute offrande de farine, tout sacrifice pour le péché et tout sacrifice de culpabilité, sera très sainte pour vous et pour vos fils. ");
INSERT INTO frasbl_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Vous en mangerez comme des choses très saintes. Tout mâle en mangera. Ce sera pour vous une chose sainte. ");
INSERT INTO frasbl_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","« Ceci est aussi à toi : l'offrande de leurs dons, toutes les offrandes des enfants d'Israël. Je te les ai données, à toi, à tes fils et à tes filles avec toi, comme une part pour toujours. Tous ceux qui sont purs dans ta maison en mangeront. ");
INSERT INTO frasbl_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","« Je te donne tout le meilleur de l'huile, tout le meilleur de la vendange et du blé, les prémices de ce qu'ils apportent à l'Éternel. ");
INSERT INTO frasbl_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Les prémices de tout ce qui se trouve dans leur pays, qu'ils apporteront à l'Éternel, seront à toi. Tous ceux qui sont propres dans votre maison en mangeront. ");
INSERT INTO frasbl_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","« Tout ce qui est consacré en Israël sera à toi. ");
INSERT INTO frasbl_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Tout ce qui ouvre le ventre, de toute chair qu'on offre à l'Éternel, tant des hommes que des animaux, sera à vous. Toutefois, vous rachèterez les premiers-nés des hommes et vous rachèterez les premiers-nés des animaux impurs. ");
INSERT INTO frasbl_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Tu rachèteras ceux d'entre eux qui sont âgés d'un mois, selon ton estimation, pour cinq sicles d'argent, selon le sicle du sanctuaire, qui pèse vingt gérachs. ");
INSERT INTO frasbl_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","« Mais tu ne rachèteras pas le premier-né d'une vache, ni le premier-né d'une brebis, ni le premier-né d'une chèvre. Ils sont saints. Tu feras l'aspersion de leur sang sur l'autel, et tu brûleras leur graisse en offrande consumée par le feu, comme une odeur agréable à Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Leur viande sera à toi, comme la poitrine offerte par onction et comme la cuisse droite, elle sera à toi. ");
INSERT INTO frasbl_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Toutes les offrandes par ondulation des choses saintes que les enfants d'Israël offrent à l'Éternel, je vous les donne, à vous, à vos fils et à vos filles avec vous, comme une part pour toujours. C'est une alliance de sel pour toujours devant l'Éternel, pour toi et pour ta descendance avec toi. » ");
INSERT INTO frasbl_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Yahvé dit à Aaron : « Tu n'auras pas d'héritage dans leur pays, et tu n'auras pas de part au milieu d'eux. Je suis ta part et ton héritage parmi les enfants d'Israël. ");
INSERT INTO frasbl_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","« Aux fils de Lévi, voici, j'ai donné en héritage toute la dîme en Israël, en contrepartie du service qu'ils font, le service de la tente d'assignation. ");
INSERT INTO frasbl_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Désormais, les enfants d'Israël ne s'approcheront plus de la Tente de la Rencontre, de peur de porter le péché et de mourir. ");
INSERT INTO frasbl_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Mais les Lévites feront le service de la Tente d'assignation, et ils porteront leur faute. Ce sera une loi pour toujours, de génération en génération. Ils n'auront pas d'héritage parmi les enfants d'Israël. ");
INSERT INTO frasbl_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","En revanche, j'ai donné en héritage aux Lévites la dîme des enfants d'Israël, qu'ils offrent en offrande à Yahvé. C'est pourquoi je leur ai dit : « Ils n'auront pas d'héritage parmi les enfants d'Israël. » ");
INSERT INTO frasbl_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Yahvé parla à Moïse et dit : ");
INSERT INTO frasbl_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","Tu parleras aux Lévites et tu leur diras : « Lorsque vous prélèverez sur les enfants d'Israël la dîme que je vous donne en héritage, vous en ferez une offrande pour Yahvé, la dîme de la dîme. ");
INSERT INTO frasbl_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Ton offrande ondulatoire te sera créditée comme le grain de l'aire et comme la plénitude de la cuve. ");
INSERT INTO frasbl_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","C'est ainsi que tu présenteras à l'Éternel une offrande par ondulation de toutes les dîmes que tu recevras des enfants d'Israël, et tu en donneras une au prêtre Aaron. ");
INSERT INTO frasbl_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","De toutes vos offrandes, vous présenterez à Yahvé chaque offrande par ondulation, dans toutes ses parties les meilleures, même la partie sainte.'' ");
INSERT INTO frasbl_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Tu leur diras : « Lorsque vous en aurez récolté le meilleur, il sera porté au crédit des Lévites comme le produit de l'aire de battage et comme le produit du pressoir. ");
INSERT INTO frasbl_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Vous pourrez en manger partout, vous et vos familles, car c'est votre récompense pour votre service dans la Tente de la Rencontre. ");
INSERT INTO frasbl_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Tu ne porteras pas de péché à cause d'elle, lorsque tu en auras tiré le meilleur. Tu ne profaneras pas les choses saintes des enfants d'Israël, afin de ne pas mourir.'\" ");
INSERT INTO frasbl_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Yahvé parla à Moïse et à Aaron, et dit : ");
INSERT INTO frasbl_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","Voici le règlement de la loi que Yahvé a ordonné. Dis aux enfants d'Israël de t'apporter une génisse rouge sans tache, qui n'a pas de défaut et qui n'a jamais été mise sous le joug. ");
INSERT INTO frasbl_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Tu la donneras au prêtre Éléazar ; il l'amènera hors du camp, et on l'égorgera devant lui. ");
INSERT INTO frasbl_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Le prêtre Éléazar prendra de son doigt un peu de son sang, et il en fera sept fois l'aspersion sur le devant de la tente d'assignation. ");
INSERT INTO frasbl_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","On brûlera la génisse sous ses yeux ; on brûlera sa peau, sa viande, son sang et ses excréments. ");
INSERT INTO frasbl_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Le prêtre prendra du bois de cèdre, de l'hysope et du cramoisi, et les jettera au milieu de l'incinération de la génisse. ");
INSERT INTO frasbl_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Le sacrificateur lavera ensuite ses vêtements, et il lavera son corps dans l'eau ; puis il entrera dans le camp, et il sera impur jusqu'au soir. ");
INSERT INTO frasbl_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Celui qui l'aura brûlée lavera ses vêtements dans l'eau, lavera son corps dans l'eau, et sera impur jusqu'au soir. ");
INSERT INTO frasbl_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","« L'homme pur ramassera la cendre de la génisse et la déposera hors du camp, dans un lieu pur ; elle sera conservée pour l'assemblée des enfants d'Israël, pour servir d'eau de purification des impuretés. C'est un sacrifice pour le péché. ");
INSERT INTO frasbl_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Celui qui recueillera les cendres de la génisse lavera ses vêtements et sera impur jusqu'au soir. Ce sera pour les enfants d'Israël et pour l'étranger qui vit au milieu d'eux une loi perpétuelle. ");
INSERT INTO frasbl_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","« Celui qui touchera le corps d'un homme mort sera impur pendant sept jours. ");
INSERT INTO frasbl_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Le troisième jour, il se purifiera avec de l'eau, et le septième jour, il sera pur ; mais s'il ne se purifie pas le troisième jour, le septième jour, il ne sera pas pur. ");
INSERT INTO frasbl_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Quiconque touche un mort, le corps d'un homme qui est mort, et ne se purifie pas, souille le tabernacle de Yahvé ; et cette âme sera retranchée d'Israël ; parce que l'eau de purification n'a pas été aspergée sur elle, elle sera impure. Son impureté est encore sur lui. ");
INSERT INTO frasbl_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Voici la loi qui s'applique lorsqu'un homme meurt dans une tente : tous ceux qui entrent dans la tente et tous ceux qui sont dans la tente seront impurs pendant sept jours. ");
INSERT INTO frasbl_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Tout vase ouvert, sur lequel n'est pas fixée une couverture, est impur. ");
INSERT INTO frasbl_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","« Quiconque, en plein champ, touchera un homme tué par l'épée, ou un cadavre, ou un os d'homme, ou une tombe, sera impur pendant sept jours. ");
INSERT INTO frasbl_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","« Pour les impurs, ils prendront des cendres de la combustion du sacrifice pour le péché, et l'on versera sur eux de l'eau courante dans un vase. ");
INSERT INTO frasbl_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Une personne pure prendra de l'hysope, la trempera dans l'eau, et en fera l'aspersion sur le tabernacle, sur tous les ustensiles, sur les personnes qui s'y trouvaient, et sur celui qui a touché un os, un mort, un cadavre ou un tombeau. ");
INSERT INTO frasbl_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","La personne pure fera l'aspersion sur la personne impure le troisième jour et le septième jour. Le septième jour, il le purifiera. Il lavera ses vêtements et se baignera dans l'eau, et il sera pur le soir. ");
INSERT INTO frasbl_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Mais l'homme qui sera impur et qui ne se purifiera pas, cette âme sera retranchée du milieu de l'assemblée, parce qu'elle a souillé le sanctuaire de l'Éternel. L'eau de purification n'a pas été aspergée sur lui. Il est impur. ");
INSERT INTO frasbl_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Ce sera pour eux une loi perpétuelle. Celui qui aura aspergé l'eau pour l'impureté lavera ses vêtements, et celui qui aura touché l'eau pour l'impureté sera impur jusqu'au soir. ");
INSERT INTO frasbl_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","« Tout ce que touchera la personne impure sera impur, et l'âme qui l'aura touché sera impure jusqu'au soir. » ");
INSERT INTO frasbl_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Les enfants d'Israël, toute l'assemblée, arrivèrent dans le désert de Tsin, au premier mois. Le peuple resta à Kadès. C'est là que Miriam mourut et qu'on l'enterra. ");
INSERT INTO frasbl_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Il n'y avait pas d'eau pour l'assemblée ; et ils s'assemblèrent contre Moïse et contre Aaron. ");
INSERT INTO frasbl_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Le peuple se querella avec Moïse, et parla ainsi : « Nous aurions voulu mourir quand nos frères sont morts devant Yahvé ! ");
INSERT INTO frasbl_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Pourquoi as-tu fait venir l'assemblée de l'Éternel dans ce désert, pour que nous y mourions, nous et nos animaux ? ");
INSERT INTO frasbl_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Pourquoi nous as-tu fait monter hors d'Égypte, pour nous amener dans ce mauvais lieu ? Ce n'est pas un lieu de semence, ni de figues, ni de vignes, ni de grenades ; il n'y a pas non plus d'eau à boire. » ");
INSERT INTO frasbl_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Moïse et Aaron quittèrent la présence de l'assemblée pour se rendre à l'entrée de la tente de la Rencontre, et ils tombèrent sur leur visage. La gloire de Yahvé leur apparut. ");
INSERT INTO frasbl_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Yahvé parla à Moïse et dit : ");
INSERT INTO frasbl_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","« Prends le bâton, rassemble l'assemblée, toi et Aaron, ton frère, et parle au rocher sous leurs yeux, pour qu'il verse son eau. Tu leur apporteras de l'eau du rocher, et tu feras boire l'assemblée et son bétail. » ");
INSERT INTO frasbl_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Moïse prit le bâton de devant l'Éternel, comme il le lui avait ordonné. ");
INSERT INTO frasbl_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Moïse et Aaron rassemblèrent l'assemblée devant le rocher, et il leur dit : « Écoutez, rebelles ! Faisons-nous sortir pour vous de l'eau de ce rocher ? » ");
INSERT INTO frasbl_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Moïse leva la main et frappa deux fois le rocher avec sa baguette, et de l'eau sortit en abondance. L'assemblée et son bétail burent. ");
INSERT INTO frasbl_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Yahvé dit à Moïse et à Aaron : « Parce que vous n'avez pas cru en moi, pour me sanctifier aux yeux des enfants d'Israël, vous ne ferez pas entrer cette assemblée dans le pays que je leur ai donné. » ");
INSERT INTO frasbl_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Ce sont les eaux de Meriba, parce que les enfants d'Israël ont lutté contre l'Éternel, et il a été sanctifié par elles. ");
INSERT INTO frasbl_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Moïse envoya des messagers de Kadès au roi d'Édom, en disant : « Ton frère Israël dit : Tu sais toutes les souffrances qui nous sont arrivées ; ");
INSERT INTO frasbl_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","comment nos pères sont descendus en Égypte, et nous avons vécu longtemps en Égypte. Les Égyptiens nous ont maltraités, nous et nos pères. ");
INSERT INTO frasbl_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Nous avons crié à Yahvé, qui a entendu notre voix, envoyé un ange et nous a fait sortir d'Égypte. Voici, nous sommes à Kadès, ville située à l'extrémité de ta frontière. ");
INSERT INTO frasbl_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","« Je vous en prie, laissez-nous passer dans votre pays. Nous ne passerons ni par les champs ni par les vignes, et nous ne boirons pas l'eau des puits. Nous suivrons la route du roi. Nous ne nous détournerons ni à droite ni à gauche, jusqu'à ce que nous ayons franchi votre frontière. » ");
INSERT INTO frasbl_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Édom lui dit : « Tu ne passeras pas par moi, de peur que je ne sorte l'épée contre toi. » ");
INSERT INTO frasbl_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Les enfants d'Israël lui dirent : « Nous monterons par la grande route ; et si nous buvons ton eau, moi et mon bétail, j'en donnerai le prix. Mais laisse-moi seulement, sans rien faire d'autre, passer sur mes pieds. » ");
INSERT INTO frasbl_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Il dit : « Tu ne passeras pas. » Edom sortit contre lui avec un peuple nombreux et une main forte. ");
INSERT INTO frasbl_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Ainsi, Edom refusa de laisser passer Israël par sa frontière, et Israël se détourna de lui. ");
INSERT INTO frasbl_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Ils partirent de Kadès, et les enfants d'Israël, toute la congrégation, arrivèrent à la montagne de Hor. ");
INSERT INTO frasbl_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Yahvé parla à Moïse et à Aaron sur la montagne de Hor, à la frontière du pays d'Édom, et dit : ");
INSERT INTO frasbl_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","« Aaron sera recueilli auprès de son peuple, car il n'entrera pas dans le pays que j'ai donné aux enfants d'Israël, parce que vous vous êtes rebellés contre ma parole aux eaux de Meriba. ");
INSERT INTO frasbl_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Prends Aaron et Éléazar, son fils, et fais-les monter sur la montagne de Hor. ");
INSERT INTO frasbl_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Dépouille Aaron de ses vêtements, et mets-les sur Éléazar, son fils. Aaron sera recueilli, et c'est là qu'il mourra. » ");
INSERT INTO frasbl_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Moïse fit ce que l'Éternel lui avait ordonné. Ils montèrent sur la montagne de Hor, sous les yeux de toute l'assemblée. ");
INSERT INTO frasbl_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Moïse dépouilla Aaron de ses vêtements et les fit revêtir à son fils Éléazar. Aaron mourut là, au sommet de la montagne, et Moïse et Eléazar descendirent de la montagne. ");
INSERT INTO frasbl_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Lorsque toute l'assemblée vit qu'Aaron était mort, ils pleurèrent Aaron pendant trente jours, toute la maison d'Israël. ");
INSERT INTO frasbl_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Le Cananéen, roi d'Arad, qui habitait dans le Midi, apprit qu'Israël venait par le chemin d'Atharim. Il fit la guerre à Israël et fit prisonniers quelques-uns de ses habitants. ");
INSERT INTO frasbl_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Israël fit un vœu à Yahvé et dit : « Si tu livres ce peuple entre mes mains, je détruirai ses villes par interdit. » ");
INSERT INTO frasbl_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","L'Éternel écouta la voix d'Israël et livra les Cananéens, qui furent dévoués par interdit, eux et leurs villes. Le nom du lieu s'appelait Horma. ");
INSERT INTO frasbl_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Ils partirent de la montagne de Hor, sur le chemin de la mer Rouge, pour contourner le pays d'Édom. L'âme du peuple était très découragée à cause du voyage. ");
INSERT INTO frasbl_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Le peuple parlait contre Dieu et contre Moïse : « Pourquoi nous as-tu fait monter hors d'Égypte pour que nous mourions dans le désert ? Car il n'y a pas de pain, il n'y a pas d'eau, et notre âme a horreur de cette nourriture dégoûtante ! ». ");
INSERT INTO frasbl_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","L'Éternel envoya des serpents venimeux parmi le peuple, et ils mordirent le peuple. Beaucoup de gens d'Israël moururent. ");
INSERT INTO frasbl_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Le peuple vint trouver Moïse et dit : « Nous avons péché, car nous avons parlé contre l'Éternel et contre toi. Prie Yahvé pour qu'il éloigne de nous les serpents. » Moïse pria pour le peuple. ");
INSERT INTO frasbl_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Yahvé dit à Moïse : « Fais un serpent venimeux et place-le sur un poteau. Tous ceux qui seront mordus, quand ils le verront, vivront. » ");
INSERT INTO frasbl_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Moïse fit un serpent d'airain, et le plaça sur le poteau. Si un homme avait été mordu par un serpent, lorsqu'il regardait le serpent d'airain, il vivait. ");
INSERT INTO frasbl_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Les enfants d'Israël partirent, et ils campèrent à Oboth. ");
INSERT INTO frasbl_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Ils partirent d`Oboth, et campèrent à Iyeabarim, dans le désert qui est devant Moab, vers le soleil levant. ");
INSERT INTO frasbl_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","De là, ils partirent, et campèrent dans la vallée de Zered. ");
INSERT INTO frasbl_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","De là, ils partirent et campèrent de l'autre côté de l'Arnon, dans le désert qui sort de la frontière des Amoréens ; car l'Arnon est la frontière de Moab, entre Moab et les Amoréens. ");
INSERT INTO frasbl_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","C'est pourquoi il est dit dans le Livre des Guerres de Yahvé  : « Vaheb à Supha, les vallées de l'Arnon, ");
INSERT INTO frasbl_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","le versant des vallées qui s'inclinent vers la demeure d'Ar, s'appuie sur la frontière de Moab. » ");
INSERT INTO frasbl_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","De là, ils allèrent jusqu'à Beer ; c'est le puits dont Yahvé avait dit à Moïse : « Rassemblez le peuple, et je leur donnerai de l'eau. » ");
INSERT INTO frasbl_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Alors Israël chanta ce cantique : « Ressort, bien ! Chantez pour lui, ");
INSERT INTO frasbl_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","le puits, que les princes ont creusé, que les nobles du peuple ont creusé, avec le sceptre, et avec leurs bâtons. » Ils partirent du désert pour aller à Mattana, ");
INSERT INTO frasbl_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","puis de Mattana à Nahaliel, de Nahaliel à Bamoth, ");
INSERT INTO frasbl_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","puis de Bamoth à la vallée qui est dans le champ de Moab, au sommet du Pisga, qui domine le désert. ");
INSERT INTO frasbl_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Israël envoya des messagers à Sihon, roi des Amoréens, pour lui dire : ");
INSERT INTO frasbl_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","« Laisse-moi passer par ton pays. Nous ne nous détournerons ni des champs ni des vignes. Nous ne boirons pas l'eau des puits. Nous suivrons la route royale, jusqu'à ce que nous ayons dépassé ta frontière. » ");
INSERT INTO frasbl_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Sihon ne permit pas à Israël de franchir sa frontière. Sihon rassembla tout son peuple, sortit contre Israël dans le désert et arriva à Jahaz. Il combattit Israël. ");
INSERT INTO frasbl_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Israël le frappa du tranchant de l'épée et prit possession de son pays, depuis l'Arnon jusqu'au Jabbok, jusqu'aux enfants d'Ammon, car la frontière des enfants d'Ammon était fortifiée. ");
INSERT INTO frasbl_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Israël prit toutes ces villes. Israël habita dans toutes les villes des Amoréens, à Hesbon et dans tous ses villages. ");
INSERT INTO frasbl_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Car Hesbon était la ville de Sihon, roi des Amoréens, qui avait combattu le précédent roi de Moab et lui avait enlevé tout son pays, jusqu'à l'Arnon. ");
INSERT INTO frasbl_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","C'est pourquoi ceux qui parlent en proverbes disent, « Viens à Heshbon. Que la ville de Sihon soit bâtie et établie ; ");
INSERT INTO frasbl_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","car un feu est sorti de Heshbon, une flamme de la ville de Sihon. Elle a dévoré Ar de Moab, Les seigneurs des hauts lieux de l'Arnon. ");
INSERT INTO frasbl_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Malheur à toi, Moab ! Vous êtes défaits, peuple de Chemosh ! Il a donné ses fils comme fugitifs, et ses filles en captivité, à Sihon, roi des Amorites. ");
INSERT INTO frasbl_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Nous leur avons tiré dessus. Heshbon a péri jusqu'à Dibon. Nous avons dévasté jusqu'à Nophah, Qui va jusqu'à Medeba. » ");
INSERT INTO frasbl_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Israël habita ainsi dans le pays des Amoréens. ");
INSERT INTO frasbl_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Moïse envoya espionner Jazer. Ils prirent ses villages, et chassèrent les Amoréens qui s'y trouvaient. ");
INSERT INTO frasbl_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Ils se retournèrent et montèrent par le chemin de Basan. Og, roi de Basan, sortit contre eux, lui et tout son peuple, pour combattre à Édréi. ");
INSERT INTO frasbl_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Yahvé dit à Moïse : « Ne le crains pas, car je l'ai livré entre tes mains, avec tout son peuple et son pays. Tu lui feras ce que tu as fait à Sihon, roi des Amorites, qui habitait à Heshbon. » ");
INSERT INTO frasbl_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Et ils le frappèrent, ainsi que ses fils et tout son peuple, jusqu'à ce qu'il n'y ait plus de survivants ; et ils possédèrent son pays. ");
INSERT INTO frasbl_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Les enfants d'Israël partirent, et ils campèrent dans les plaines de Moab, au-delà du Jourdain, à Jéricho. ");
INSERT INTO frasbl_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Balak, fils de Tsippor, vit tout ce qu'Israël avait fait aux Amoréens. ");
INSERT INTO frasbl_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Moab eut très peur de ce peuple, car il était nombreux. Moab était dans la détresse à cause des enfants d'Israël. ");
INSERT INTO frasbl_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Moab dit aux anciens de Madian : « Maintenant, cette multitude va lécher tout ce qui nous entoure, comme le bœuf lèche l'herbe des champs. » En ce temps-là, Balak, fils de Tsippor, était roi de Moab. ");
INSERT INTO frasbl_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Il envoya des messagers à Balaam, fils de Beor, à Pethor, au bord du fleuve, dans le pays des fils de son peuple, pour l'appeler et lui dire : « Voici un peuple qui est sorti d'Égypte. Voici qu'ils couvrent la surface de la terre, et ils restent en face de moi. ");
INSERT INTO frasbl_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Viens donc maintenant et maudis ce peuple pour moi, car il est trop puissant pour moi. Peut-être l'emporterai-je, que nous les frapperons et que je les chasserai du pays ; car je sais que celui que tu bénis est béni, et que celui que tu maudis est maudit. » ");
INSERT INTO frasbl_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Les anciens de Moab et les anciens de Madian partirent, les récompenses de la divination en main. Ils vinrent auprès de Balaam et lui rapportèrent les paroles de Balak. ");
INSERT INTO frasbl_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Il leur dit : « Restez ici cette nuit, et je vous rapporterai des nouvelles, selon ce que Yahvé me dira. » Les princes de Moab restèrent avec Balaam. ");
INSERT INTO frasbl_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Dieu s'approcha de Balaam, et dit : « Qui sont ces hommes avec toi ? » ");
INSERT INTO frasbl_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Balaam dit à Dieu : « Balak, fils de Zippor, roi de Moab, m'a dit : ");
INSERT INTO frasbl_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","« Voici que le peuple sorti d'Égypte couvre la surface de la terre. Maintenant, viens les maudire pour moi. Peut-être pourrai-je lutter contre eux et les chasser. » ");
INSERT INTO frasbl_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Dieu dit à Balaam : « Tu n'iras pas avec eux. Tu ne maudiras pas ce peuple, car il est béni. » ");
INSERT INTO frasbl_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Balaam se leva le matin et dit aux princes de Balak : « Allez dans votre pays, car l'Éternel refuse de me laisser aller avec vous. » ");
INSERT INTO frasbl_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Les princes de Moab se levèrent et allèrent trouver Balak, en disant : « Balaam refuse de venir avec nous. » ");
INSERT INTO frasbl_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Balak envoya de nouveau des princes, plus nombreux et plus honorables qu'eux. ");
INSERT INTO frasbl_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Ils se rendirent auprès de Balaam et lui dirent : « Balak, fils de Tsippor, dit : « Que rien ne t'empêche de venir me voir, ");
INSERT INTO frasbl_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","car je te promouvrai à un très grand honneur et je ferai tout ce que tu me diras. Viens donc, je te prie, et maudis ce peuple pour moi. » ");
INSERT INTO frasbl_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Balaam répondit aux serviteurs de Balak : « Si Balak veut bien me donner sa maison pleine d'argent et d'or, je ne peux pas aller au-delà de la parole de Yahvé mon Dieu, pour faire moins ou plus. ");
INSERT INTO frasbl_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Maintenant, je vous prie donc de rester ici cette nuit encore, afin que je sache ce que Yahvé me dira encore. » ");
INSERT INTO frasbl_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Dieu vint à Balaam pendant la nuit, et lui dit : « Si les hommes sont venus t'appeler, lève-toi, va avec eux ; mais tu ne feras que la parole que je te dirai. » ");
INSERT INTO frasbl_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Balaam se leva le matin, sella son âne, et partit avec les princes de Moab. ");
INSERT INTO frasbl_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","La colère de Dieu s'enflamma parce qu'il était parti, et l'ange de Yahvé se plaça sur le chemin comme adversaire contre lui. Il était monté sur son âne, et ses deux serviteurs étaient avec lui. ");
INSERT INTO frasbl_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","L'âne vit l'ange de Yahvé qui se tenait sur le chemin, l'épée tirée à la main ; l'âne se détourna du chemin et entra dans les champs. Balaam frappa l'ânesse pour la faire revenir dans le chemin. ");
INSERT INTO frasbl_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Alors l'ange de Yahvé se tint dans un chemin étroit entre les vignes, un mur étant de ce côté-ci et un mur de ce côté-là. ");
INSERT INTO frasbl_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","L'ânesse vit l'ange de Yahvé, elle se jeta contre le mur et écrasa le pied de Balaam contre le mur. Il la frappa de nouveau. ");
INSERT INTO frasbl_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","L'ange de Yahvé alla plus loin et se tint dans un endroit étroit, où il n'y avait pas moyen de se tourner ni à droite ni à gauche. ");
INSERT INTO frasbl_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","L'ânesse vit l'ange de Yahvé et se coucha sous Balaam. La colère de Balaam s'enflamma, et il frappa l'âne avec son bâton. ");
INSERT INTO frasbl_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Yahvé ouvrit la bouche de l'ânesse, et elle dit à Balaam : « Que t'ai-je fait pour que tu me frappes trois fois ? » ");
INSERT INTO frasbl_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Balaam dit à l'âne : « Parce que tu t'es moqué de moi, je voudrais avoir une épée à la main, car maintenant je t'aurais tué. » ");
INSERT INTO frasbl_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","L'âne dit à Balaam : « Ne suis-je pas ton âne, sur lequel tu es monté toute ta vie jusqu'à aujourd'hui ? Ai-je jamais eu l'habitude de te le faire ? » Il a dit : « Non. » ");
INSERT INTO frasbl_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Alors Yahvé ouvrit les yeux de Balaam, et il vit l'ange de Yahvé qui se tenait sur le chemin, son épée tirée à la main ; il baissa la tête et tomba sur sa face. ");
INSERT INTO frasbl_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","L'ange de Yahvé lui dit : « Pourquoi as-tu frappé ton âne ces trois fois ? Voici, je suis sorti comme un adversaire, car ta voie est perverse devant moi. ");
INSERT INTO frasbl_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","L'ânesse m'a vu et s'est détournée devant moi ces trois fois. Si elle ne s'était pas détournée de moi, je t'aurais certainement tué maintenant, et je l'aurais laissée en vie. » ");
INSERT INTO frasbl_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Balaam dit à l'ange de Yahvé : « J'ai péché, car je ne savais pas que tu te tenais sur le chemin contre moi. Maintenant donc, si cela te déplaît, je vais retourner en arrière. » ");
INSERT INTO frasbl_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","L'ange de Yahvé dit à Balaam : « Va avec les hommes ; mais tu ne diras que la parole que je te dirai. » Balaam partit donc avec les princes de Balak. ");
INSERT INTO frasbl_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Lorsque Balak apprit que Balaam était venu, il sortit à sa rencontre dans la ville de Moab, qui est sur la frontière de l'Arnon, qui est à l'extrémité de la frontière. ");
INSERT INTO frasbl_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Balak dit à Balaam : « Ne t'ai-je pas envoyé chercher avec insistance pour te convoquer ? Pourquoi n'es-tu pas venu à moi ? Ne suis-je pas en mesure, en effet, de te promouvoir à l'honneur ? » ");
INSERT INTO frasbl_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Balaam dit à Balak : « Voici, je suis venu chez toi. Ai-je maintenant le pouvoir de dire quoi que ce soit ? Je dirai la parole que Dieu met dans ma bouche. » ");
INSERT INTO frasbl_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Balaam partit avec Balak, et ils arrivèrent à Kirjath Huzoth. ");
INSERT INTO frasbl_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Balak sacrifia du bétail et des brebis, et il envoya chercher Balaam et les chefs qui étaient avec lui. ");
INSERT INTO frasbl_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Le matin, Balak prit Balaam et le fit monter sur les hauts lieux de Baal, et il vit de là une partie du peuple. ");
INSERT INTO frasbl_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Balaam dit à Balak : « Construis ici sept autels pour moi, et prépare ici sept taureaux et sept béliers pour moi. » ");
INSERT INTO frasbl_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balak fit ce que Balaam avait dit ; Balak et Balaam offrirent sur chaque autel un taureau et un bélier. ");
INSERT INTO frasbl_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Balaam dit à Balak : « Reste près de ton holocauste, et je m'en irai. Peut-être Yahvé viendra-t-il à ma rencontre. Je te dirai tout ce qu'il me montrera. » Il alla jusqu'à une hauteur nue. ");
INSERT INTO frasbl_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Dieu rencontra Balaam, qui lui dit : « J'ai préparé les sept autels, et j'ai offert un taureau et un bélier sur chaque autel. » ");
INSERT INTO frasbl_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Yahvé mit une parole dans la bouche de Balaam, et dit : « Retourne chez Balak, et tu parleras ainsi. » ");
INSERT INTO frasbl_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Il revint vers lui, et voici, il se tenait près de son holocauste, lui et tous les princes de Moab. ");
INSERT INTO frasbl_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Il reprit sa parabole, et dit, « Balak m'a amené d'Aram, le roi de Moab, depuis les montagnes de l'Orient. Viens, maudis Jacob pour moi. Venez, défiez Israël. ");
INSERT INTO frasbl_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Comment maudirais-je celui que Dieu n'a pas maudit ? Comment pourrais-je défier celui que Yahvé n'a pas défié ? ");
INSERT INTO frasbl_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Car, du haut des rochers, je le vois. Depuis les collines, je le vois. C'est un peuple qui habite seul, et ne sera pas répertorié parmi les nations. ");
INSERT INTO frasbl_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Qui peut compter la poussière de Jacob, ou compter la quatrième partie d'Israël ? Laissez-moi mourir de la mort des justes ! Que ma dernière fin soit comme la sienne ! » ");
INSERT INTO frasbl_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Balak dit à Balaam : « Que m'as-tu fait ? Je t'ai pris pour maudire mes ennemis, et voici que tu les as bénis tous. » ");
INSERT INTO frasbl_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Il prit la parole et dit : « Ne dois-je pas prendre garde de dire ce que Yahvé met dans ma bouche ? » ");
INSERT INTO frasbl_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Balak lui dit : « Viens avec moi dans un autre lieu, où tu pourras les voir. Tu n'en verras qu'une partie, et tu ne les verras pas tous. Maudis-les de là pour moi. » ");
INSERT INTO frasbl_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Il l'emmena dans le champ de Zophim, au sommet du Pisga, bâtit sept autels, et offrit un taureau et un bélier sur chaque autel. ");
INSERT INTO frasbl_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Il dit à Balak : « Reste ici près de ton holocauste, pendant que je rencontre Dieu là-bas. » ");
INSERT INTO frasbl_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","L'Éternel rencontra Balaam, lui mit une parole dans la bouche et dit : « Retourne chez Balak, et dis ceci. » ");
INSERT INTO frasbl_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Il s'approcha de lui, et voici, il se tenait près de son holocauste, et les princes de Moab avec lui. Balak lui dit : « Qu'a dit Yahvé ? » ");
INSERT INTO frasbl_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Il reprit sa parabole, et dit, « Lève-toi, Balak, et écoute ! Écoute-moi, fils de Zippor. ");
INSERT INTO frasbl_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Dieu n'est pas un homme, pour qu'il mente, ni un fils d'homme, pour qu'il se repente. A-t-il dit, et il ne le fera pas ? Ou bien il a parlé, et il ne le fera pas bien ? ");
INSERT INTO frasbl_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Voici, j'ai reçu l'ordre de bénir. Il a béni, et je ne peux pas l'inverser. ");
INSERT INTO frasbl_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Il n'a pas vu d'iniquité en Jacob. Il n'a pas non plus vu de perversité en Israël. Yahvé son Dieu est avec lui. Le cri d'un roi est parmi eux. ");
INSERT INTO frasbl_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Dieu les fait sortir d'Égypte. Il a pour ainsi dire la force du bœuf sauvage. ");
INSERT INTO frasbl_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Certes, il n'y a pas d'enchantement chez Jacob ; il n'y a pas non plus de divination avec Israël. Il sera dit de Jacob et d'Israël, « Qu'a fait Dieu ? ");
INSERT INTO frasbl_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Voici qu'un peuple se lève comme une lionne. Comme un lion, il se soulève. Il ne se couchera pas avant d'avoir mangé la proie, et boit le sang de ceux qui ont été tués. » ");
INSERT INTO frasbl_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Balak dit à Balaam : « Ne les maudis pas du tout et ne les bénis pas du tout. » ");
INSERT INTO frasbl_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Balaam répondit à Balak : « Ne t'ai-je pas dit : Tout ce que l'Éternel dit, je le ferai ? » ");
INSERT INTO frasbl_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Balak dit à Balaam : « Viens, je vais te conduire dans un autre lieu ; peut-être plaira-t-il à Dieu que, de là, tu les maudisses pour moi. » ");
INSERT INTO frasbl_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Balak emmena Balaam au sommet du Peor, qui regarde le désert. ");
INSERT INTO frasbl_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Balaam dit à Balak : « Construis-moi ici sept autels, et prépare-moi ici sept taureaux et sept béliers. » ");
INSERT INTO frasbl_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balak fit ce que Balaam avait dit, et il offrit un taureau et un bélier sur chaque autel. ");
INSERT INTO frasbl_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Lorsque Balaam vit qu'il plaisait à Yahvé de bénir Israël, il n'alla pas, comme les autres fois, recourir à la divination, mais il tourna son visage vers le désert. ");
INSERT INTO frasbl_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Balaam leva les yeux, et il vit Israël habitant selon ses tribus ; et l'Esprit de Dieu vint sur lui. ");
INSERT INTO frasbl_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","Il reprit sa parabole, et dit, « Balaam, fils de Beor, dit, l'homme dont les yeux sont ouverts dit ; ");
INSERT INTO frasbl_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","dit-il, qui entend les paroles de Dieu, qui voit la vision du Tout-Puissant, en tombant, et en ayant les yeux ouverts : ");
INSERT INTO frasbl_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Que tes tentes sont belles, Jacob ! et tes habitations, Israël ! ");
INSERT INTO frasbl_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Ils s'étendent comme des vallées, comme des jardins au bord de la rivière, comme des aloès que Yahvé a plantés, comme des cèdres au bord de l'eau. ");
INSERT INTO frasbl_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","L'eau coulera de ses seaux. Sa semence sera dans de nombreuses eaux. Son roi sera plus haut qu'Agag. Son royaume sera exalté. ");
INSERT INTO frasbl_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Dieu le fait sortir d'Égypte. Il a pour ainsi dire la force du bœuf sauvage. Il consumera les nations, ses adversaires, brisera leurs os en morceaux, et les transpercer de ses flèches. ");
INSERT INTO frasbl_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Il s'est couché, il s'est couché comme un lion, comme une lionne ; qui le réveillera ? Tous ceux qui vous bénissent sont bénis. Tous ceux qui te maudissent sont maudits. » ");
INSERT INTO frasbl_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","La colère de Balak s'enflamma contre Balaam, et il frappa ses mains l'une contre l'autre. Balak dit à Balaam : « Je t'ai appelé pour que tu maudisses mes ennemis, et voici que tu les as tous bénis ces trois fois. ");
INSERT INTO frasbl_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","C'est pourquoi, fuis à ta place, maintenant ! Je pensais te promouvoir à de grands honneurs, mais voici que Yahvé t'en a empêché. » ");
INSERT INTO frasbl_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Balaam dit à Balak : « N'ai-je pas dit à tes messagers que tu m'as envoyés : ");
INSERT INTO frasbl_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","« Si Balak me donne sa maison pleine d'argent et d'or, je ne peux pas aller au-delà de la parole de Yahvé, pour faire du bien ou du mal de mon propre chef. Je dirai ce que dit l'Éternel » ? ");
INSERT INTO frasbl_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Maintenant, voici que je vais vers mon peuple. Viens, je vais t'informer de ce que ce peuple fera à ton peuple dans la suite des temps. » ");
INSERT INTO frasbl_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Il reprit sa parabole, et dit, « Balaam, fils de Beor, dit, l'homme dont les yeux sont ouverts dit ; ");
INSERT INTO frasbl_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","il dit, qui entend les paroles de Dieu, connaît la connaissance du Très-Haut, et qui voit la vision du Tout-Puissant, en tombant, et en ayant les yeux ouverts : ");
INSERT INTO frasbl_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Je le vois, mais pas maintenant. Je le vois, mais pas près. Une étoile sortira de Jacob. Un sceptre s'élèvera d'Israël, et il frappera les coins de Moab, et écraser tous les fils de Sheth. ");
INSERT INTO frasbl_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Edom sera une possession. Séir, son ennemi, sera aussi une possession, alors qu'Israël le fait vaillamment. ");
INSERT INTO frasbl_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","De Jacob, un seul dominera, et détruira le reste de la ville. » ");
INSERT INTO frasbl_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Il regarda Amalek, et reprit sa parabole, et dit, « Amalek était la première des nations, mais sa finalité sera la destruction. » ");
INSERT INTO frasbl_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Il regarda le Kenite, et reprit sa parabole, et dit, « Ta demeure est forte. Votre nid est fixé dans la roche. ");
INSERT INTO frasbl_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Cependant, Kain sera perdue, jusqu'à ce qu'Asshur vous emmène en captivité. » ");
INSERT INTO frasbl_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Il reprit sa parabole, et dit, « Hélas, qui vivra quand Dieu fera cela ? ");
INSERT INTO frasbl_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Mais des navires viendront de la côte de Kittim. Ils feront souffrir Asshur, et ils feront souffrir Eber. Lui aussi viendra à la destruction. » ");
INSERT INTO frasbl_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Balaam se leva, et s'en alla et retourna à sa place ; et Balak aussi s'en alla. ");
INSERT INTO frasbl_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Israël resta à Shittim, et le peuple commença à se prostituer avec les filles de Moab ; ");
INSERT INTO frasbl_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","car elles appelaient le peuple aux sacrifices de leurs dieux. Le peuple mangeait et se prosternait devant leurs dieux. ");
INSERT INTO frasbl_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Israël s'attacha à Baal Péor, et la colère de Yahvé s'enflamma contre Israël. ");
INSERT INTO frasbl_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","L'Éternel dit à Moïse : « Prends tous les chefs du peuple et suspends-les à l'Éternel devant le soleil, afin que l'ardente colère de l'Éternel se détourne d'Israël. » ");
INSERT INTO frasbl_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Moïse dit aux juges d'Israël : « Que chacun tue ses hommes qui se sont attachés à Baal Peor. » ");
INSERT INTO frasbl_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Voici, un des enfants d'Israël vint et amena à ses frères une femme madianite, sous les yeux de Moïse et de toute l'assemblée des enfants d'Israël, pendant qu'ils pleuraient à l'entrée de la tente d'assignation. ");
INSERT INTO frasbl_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Lorsque Phinées, fils d'Éléazar, fils du sacrificateur Aaron, vit cela, il se leva du milieu de l'assemblée et prit une lance dans sa main. ");
INSERT INTO frasbl_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","Il poursuivit l'homme d'Israël dans le pavillon, et les transperça tous les deux, l'homme d'Israël et la femme par le corps. Et la peste s'arrêta parmi les enfants d'Israël. ");
INSERT INTO frasbl_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Ceux qui moururent de la peste furent vingt-quatre mille. ");
INSERT INTO frasbl_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Yahvé parla à Moïse, et dit : ");
INSERT INTO frasbl_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","« Phinées, fils d'Eléazar, fils du prêtre Aaron, a détourné ma colère des enfants d'Israël, en ce qu'il était jaloux de ma jalousie au milieu d'eux, afin que je ne consume pas les enfants d'Israël dans ma jalousie. ");
INSERT INTO frasbl_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","C'est pourquoi tu diras : « Voici, je lui donne mon alliance de paix. ");
INSERT INTO frasbl_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Ce sera pour lui, et pour sa postérité après lui, l'alliance d'un sacerdoce éternel, parce qu'il a été jaloux de son Dieu et qu'il a fait l'expiation pour les enfants d'Israël.'\" ");
INSERT INTO frasbl_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Or le nom de l'homme d'Israël qui fut tué avec la femme madianite était Zimri, fils de Salu, prince d'une maison paternelle parmi les Siméonites. ");
INSERT INTO frasbl_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Le nom de la femme madianite qui fut tuée était Cozbi, fille de Tsur. Il était chef du peuple d'une maison paternelle en Madian. ");
INSERT INTO frasbl_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Yahvé parla à Moïse, et dit : ");
INSERT INTO frasbl_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","« Poursuis les Madianites, et frappe-les ; ");
INSERT INTO frasbl_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","car ils t'ont poursuivi par leurs ruses, et ils t'ont trompé dans l'affaire de Péor, et dans l'affaire de Cozbi, fille du prince de Madian, leur sœur, qui fut tuée le jour de la peste dans l'affaire de Péor. » ");
INSERT INTO frasbl_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Après la plaie, Yahvé parla à Moïse et au prêtre Éléazar, fils d'Aaron, et dit : ");
INSERT INTO frasbl_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","« Recensez toute l'assemblée des enfants d'Israël, depuis l'âge de vingt ans et au-dessus, selon les maisons de leurs pères, tous ceux qui sont en état de porter les armes en Israël. » ");
INSERT INTO frasbl_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Moïse et le prêtre Éléazar leur parlèrent dans les plaines de Moab, près du Jourdain, à Jéricho, et dirent : ");
INSERT INTO frasbl_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","« Recensez-les, depuis l'âge de vingt ans et au-dessus, comme Yahvé l'a ordonné à Moïse et aux enfants d'Israël. » Ce sont ceux qui sont sortis du pays d'Égypte. ");
INSERT INTO frasbl_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Ruben, premier-né d'Israël. Fils de Ruben : de Hanoch, la famille des Hanochites ; de Pallu, la famille des Palluites ; ");
INSERT INTO frasbl_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","de Hezron, la famille des Hezronites ; de Carmi, la famille des Carmites. ");
INSERT INTO frasbl_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Telles sont les familles des Rubénites. Ceux qui furent comptés parmi eux furent quarante-trois mille sept cent trente. ");
INSERT INTO frasbl_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Fils de Pallu : Éliab. ");
INSERT INTO frasbl_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","Fils d'Éliab : Nemuel, Dathan et Abiram. Ce sont ces Dathan et Abiram, appelés par l'assemblée, qui se révoltèrent contre Moïse et Aaron dans la troupe de Koré, lorsqu'ils se rebellèrent contre Yahvé ; ");
INSERT INTO frasbl_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","et la terre ouvrit sa bouche et les engloutit avec Koré, lorsque cette troupe mourut ; en ce temps-là, le feu dévora deux cent cinquante hommes, et ils devinrent un signe. ");
INSERT INTO frasbl_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Néanmoins, les fils de Koré ne moururent pas. ");
INSERT INTO frasbl_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Fils de Siméon, selon leurs familles : de Nemuel, la famille des Nemuelites ; de Jamin, la famille des Jaminites ; de Jachin, la famille des Jachinites ; ");
INSERT INTO frasbl_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","de Zérach, la famille des Zérachites ; de Saul, la famille des Saulites. ");
INSERT INTO frasbl_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Ce sont là les familles des Siméonites, au nombre de vingt-deux mille deux cents. ");
INSERT INTO frasbl_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Fils de Gad, selon leurs familles : de Zephon, la famille des Zephonites ; de Haggi, la famille des Haggites ; de Shuni, la famille des Shunites ; ");
INSERT INTO frasbl_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","d'Ozni, la famille des Oznites ; d'Eri, la famille des Erites ; ");
INSERT INTO frasbl_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","d'Arod, la famille des Arodites ; d'Areli, la famille des Arelites. ");
INSERT INTO frasbl_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Ce sont là les familles des fils de Gad, d'après leur dénombrement, quarante mille cinq cents. ");
INSERT INTO frasbl_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Fils de Juda : Er et Onan. Er et Onan moururent au pays de Canaan. ");
INSERT INTO frasbl_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Fils de Juda, selon leurs familles : de Schéla, la famille des Schélanites ; de Pérez, la famille des Pérezites ; de Zérach, la famille des Zérachites. ");
INSERT INTO frasbl_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Les fils de Pérez furent : de Hetsron, la famille des Hetsronites ; de Hamul, la famille des Hamulites. ");
INSERT INTO frasbl_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Ce sont là les familles de Juda, d'après leur dénombrement, soixante-seize mille cinq cents. ");
INSERT INTO frasbl_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Fils d'Issacar, selon leurs familles : de Tola, la famille des Tolaïtes ; de Puvah, la famille des Punites ; ");
INSERT INTO frasbl_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","de Jashub, la famille des Jashubites ; de Shimron, la famille des Shimronites. ");
INSERT INTO frasbl_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Ce sont là les familles d'Issacar, d'après leur dénombrement, soixante-quatre mille trois cents. ");
INSERT INTO frasbl_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Fils de Zabulon, selon leurs familles : de Sered, la famille des Seredites ; d'Elon, la famille des Elonites ; de Jahleel, la famille des Jahleelites. ");
INSERT INTO frasbl_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Ce sont là les familles des Zabulonites, d'après leur dénombrement, soixante mille cinq cents. ");
INSERT INTO frasbl_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Fils de Joseph, selon leurs familles : Manassé et Éphraïm. ");
INSERT INTO frasbl_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Fils de Manassé : de Makir, la famille des Makirites ; et Makir engendra Galaad ; de Galaad, la famille des Galaadites. ");
INSERT INTO frasbl_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Voici les fils de Galaad : de Iezer, la famille des Iezerites ; de Helek, la famille des Helekites ; ");
INSERT INTO frasbl_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","et Asriel, la famille des Asrielites ; et Sichem, la famille des Sichemites ; ");
INSERT INTO frasbl_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","et Shemida, la famille des Shemidaites ; et Hépher, la famille des Hépherites. ");
INSERT INTO frasbl_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Zelophehad, fils de Hépher, n'eut pas de fils, mais des filles. Les noms des filles de Zelophehad furent : Mahla, Noa, Hogla, Milca et Tirza. ");
INSERT INTO frasbl_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Ce sont là les familles de Manassé. Ceux qui furent dénombrés parmi eux furent cinquante-deux mille sept cents. ");
INSERT INTO frasbl_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Voici les fils d'Éphraïm, selon leurs familles : de Shuthelah, la famille des Shuthelahites ; de Becher, la famille des Becherites ; de Tahan, la famille des Tahanites. ");
INSERT INTO frasbl_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Ce sont là les fils de Shuthelah : d'Eran, la famille des Eranites. ");
INSERT INTO frasbl_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Ce sont là les familles des fils d'Éphraïm, d'après leur dénombrement : trente-deux mille cinq cents. Ce sont là les fils de Joseph, selon leurs familles. ");
INSERT INTO frasbl_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Fils de Benjamin, selon leurs familles : de Bela, la famille des Bélaïtes ; d'Ashbel, la famille des Ashbelites ; d'Ahiram, la famille des Ahiramites ; ");
INSERT INTO frasbl_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","de Shephupham, la famille des Shuphamites ; de Hupham, la famille des Huphamites. ");
INSERT INTO frasbl_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Les fils de Béla furent Ard et Naaman : la famille des Ardites ; et de Naaman, la famille des Naamites. ");
INSERT INTO frasbl_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Ce sont là les fils de Benjamin, selon leurs familles ; ceux dont on fit le dénombrement furent quarante-cinq mille six cents. ");
INSERT INTO frasbl_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Voici les fils de Dan, selon leurs familles : de Schucham, la famille des Schuchamites. Ce sont là les familles de Dan, selon leurs familles. ");
INSERT INTO frasbl_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Total des familles des Schuchamites, d'après leur dénombrement : soixante-quatre mille quatre cents. ");
INSERT INTO frasbl_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Fils d'Aser, selon leurs familles : d'Imna, la famille des Imnites ; d'Ishvi, la famille des Ishvites ; de Beriah, la famille des Berites. ");
INSERT INTO frasbl_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Des fils de Beria : de Héber, la famille des Héberites ; de Malkiel, la famille des Malkiélites. ");
INSERT INTO frasbl_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Le nom de la fille d'Aser est Serah. ");
INSERT INTO frasbl_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Ce sont là les familles des fils d'Aser, d'après leur dénombrement : cinquante-trois mille quatre cents. ");
INSERT INTO frasbl_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Fils de Nephthali, selon leurs familles : de Jahzeel, la famille des Jahzeelites ; de Guni, la famille des Gunites ; ");
INSERT INTO frasbl_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","de Jezer, la famille des Jezerites ; de Shillem, la famille des Shillemites. ");
INSERT INTO frasbl_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Ce sont là les familles de Nephthali, selon leurs familles ; ceux dont on fit le dénombrement furent quarante-cinq mille quatre cents. ");
INSERT INTO frasbl_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Tels sont ceux des enfants d'Israël dont on fit le dénombrement : six cent un mille sept cent trente. ");
INSERT INTO frasbl_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Yahvé parla à Moïse et dit : ");
INSERT INTO frasbl_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","« A ceux-là, le pays sera partagé en héritage selon le nombre de noms. ");
INSERT INTO frasbl_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Tu donneras au plus grand nombre un héritage plus grand, et au plus petit un héritage plus petit. On donnera à chacun son héritage en fonction de ceux qui ont été comptés par lui. ");
INSERT INTO frasbl_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Néanmoins, le pays sera divisé par le sort. Ils hériteront selon les noms des tribus de leurs pères. ");
INSERT INTO frasbl_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","C'est d'après le sort que leur héritage sera partagé entre le plus grand et le plus petit. » ");
INSERT INTO frasbl_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Voici ceux qui furent comptés parmi les Lévites, selon leurs familles : de Guershon, la famille des Guershonites ; de Kehath, la famille des Kehathites ; de Merari, la famille des Merarites. ");
INSERT INTO frasbl_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Voici les familles de Lévi : la famille des Libnites, la famille des Hébronites, la famille des Mahlites, la famille des Mushites et la famille des Koréites. Kehath devint le père d'Amram. ");
INSERT INTO frasbl_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Le nom de la femme d'Amram était Jochebed, fille de Lévi, qui était née de Lévi en Égypte. Elle enfanta à Amram Aaron et Moïse, et Miriam, leur sœur. ");
INSERT INTO frasbl_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","À Aaron naquirent Nadab et Abihu, Éléazar et Ithamar. ");
INSERT INTO frasbl_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Nadab et Abihu moururent lorsqu'ils offrirent du feu étranger devant Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Ceux qui furent comptés parmi eux furent vingt-trois mille, tous les mâles depuis l'âge d'un mois et au-dessus ; car ils ne furent pas comptés parmi les enfants d'Israël, parce qu'on ne leur avait pas donné d'héritage parmi les enfants d'Israël. ");
INSERT INTO frasbl_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Ce sont ceux dont Moïse et le prêtre Éléazar firent le compte des enfants d'Israël dans les plaines de Moab, près du Jourdain, à Jéricho. ");
INSERT INTO frasbl_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Mais il n'y avait parmi eux aucun de ceux qui furent comptés par Moïse et le prêtre Aaron, qui comptèrent les enfants d'Israël dans le désert du Sinaï. ");
INSERT INTO frasbl_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Car Yahvé avait dit d'eux : « Ils mourront dans le désert. » Il ne resta pas un homme d'entre eux, sauf Caleb, fils de Jephunné, et Josué, fils de Nun. ");
INSERT INTO frasbl_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Et les filles de Zelophehad, fils de Hépher, fils de Galaad, fils de Makir, fils de Manassé, des familles de Manassé, fils de Joseph, s'approchèrent. Voici les noms de ses filles : Mahla, Noé, Hogla, Milca et Tirza. ");
INSERT INTO frasbl_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Elles se présentèrent devant Moïse, devant le sacrificateur Éléazar, devant les princes et toute l'assemblée, à l'entrée de la tente de la Rencontre, et dirent : ");
INSERT INTO frasbl_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","« Notre père est mort dans le désert. Il n'était pas du nombre de ceux qui se sont ligués contre Yahvé, à la suite de Koré, mais il est mort dans son propre péché. Il n'a pas eu de fils. ");
INSERT INTO frasbl_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Pourquoi le nom de notre père serait-il retranché du milieu de sa famille, parce qu'il n'a pas eu de fils ? Donne-nous une possession parmi les frères de notre père ». ");
INSERT INTO frasbl_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Moïse porta leur cause devant Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","L'Éternel parla à Moïse, et dit : ");
INSERT INTO frasbl_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","« Les filles de Tselophehad ont raison. Tu leur donneras une possession en héritage parmi les frères de leur père. Tu leur feras passer l'héritage de leur père. ");
INSERT INTO frasbl_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Tu parleras aux enfants d'Israël en disant : « Si un homme meurt et n'a pas de fils, tu feras passer son héritage à sa fille. ");
INSERT INTO frasbl_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","S'il n'a pas de fille, tu donneras son héritage à ses frères. ");
INSERT INTO frasbl_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","S'il n'a pas de frères, tu donneras son héritage aux frères de son père. ");
INSERT INTO frasbl_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Si son père n'a pas de frères, vous donnerez son héritage à son parent le plus proche de sa famille, et il le possédera. Ceci sera une loi et une ordonnance pour les enfants d'Israël, comme Yahvé l'a ordonné à Moïse.'\" ");
INSERT INTO frasbl_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Yahvé dit à Moïse : « Monte sur cette montagne d'Abarim, et regarde le pays que j'ai donné aux enfants d'Israël. ");
INSERT INTO frasbl_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Quand tu l'auras vu, toi aussi, tu seras recueilli auprès de ton peuple, comme Aaron, ton frère, a été recueilli ; ");
INSERT INTO frasbl_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","car, dans les querelles de l'assemblée, vous vous êtes rebellés contre ma parole, dans le désert de Tsin, pour m'honorer comme saint aux eaux, sous leurs yeux. » (Ce sont les eaux de Meribah de Kadesh dans le désert de Zin). ");
INSERT INTO frasbl_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Moïse parla à l'Éternel, et dit : ");
INSERT INTO frasbl_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","« Que l'Éternel, le Dieu des esprits de toute chair, établisse un homme sur l'assemblée, ");
INSERT INTO frasbl_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","qui sorte devant eux et qui entre devant eux, qui les conduise dehors et qui les fasse entrer, afin que l'assemblée de l'Éternel ne soit pas comme des brebis qui n'ont pas de berger. » ");
INSERT INTO frasbl_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Yahvé dit à Moïse : « Prends Josué, fils de Nun, un homme en qui réside l'Esprit, et pose ta main sur lui. ");
INSERT INTO frasbl_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Tu le placeras devant le sacrificateur Éléazar et devant toute l'assemblée, et tu le recommanderas à leurs yeux. ");
INSERT INTO frasbl_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Tu lui donneras l'autorité, afin que toute l'assemblée des enfants d'Israël lui obéisse. ");
INSERT INTO frasbl_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Il se présentera devant le prêtre Éléazar, qui examinera pour lui le jugement de l'urim devant l'Éternel. A sa parole, ils sortiront, et à sa parole, ils entreront, lui et tous les enfants d'Israël avec lui, toute l'assemblée. » ");
INSERT INTO frasbl_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Moïse fit ce que l'Éternel lui avait ordonné. Il prit Josué et le plaça devant le prêtre Éléazar et devant toute l'assemblée. ");
INSERT INTO frasbl_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Il lui imposa les mains et lui donna des ordres, comme Yahvé l'avait dit par Moïse. ");
INSERT INTO frasbl_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Yahvé parla à Moïse, et dit : ");
INSERT INTO frasbl_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","Donne des ordres aux enfants d'Israël, et dis-leur : Veillez à ce que vous présentiez mon offrande, mon aliment pour mes sacrifices consumés par le feu, comme une odeur agréable pour moi, en son temps. ");
INSERT INTO frasbl_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Tu leur diras : « Voici le sacrifice consumé par le feu que vous offrirez à l'Éternel : des agneaux mâles d'un an sans défaut, deux par jour, pour l'holocauste perpétuel. ");
INSERT INTO frasbl_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Tu offriras l'un des agneaux le matin, et tu offriras l'autre agneau le soir, ");
INSERT INTO frasbl_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","avec un dixième d'épha de fleur de farine pour l'offrande, mélangé à un quart de hin d'huile battue. ");
INSERT INTO frasbl_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","C'est l'holocauste perpétuel qui a été ordonné sur la montagne de Sinaï, comme un parfum agréable, un sacrifice consumé par le feu à l'Éternel. ");
INSERT INTO frasbl_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Sa libation sera de la quatrième partie d'un hin pour chaque agneau. Tu verseras une libation de boisson forte à l'Éternel dans le lieu saint. ");
INSERT INTO frasbl_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Tu offriras l'autre agneau le soir. Tu l'offriras, comme l'offrande du matin et comme sa libation, en sacrifice consumé par le feu, comme une odeur agréable à Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","\"'Le jour du sabbat, tu offriras deux agneaux mâles d'un an, sans défaut, et deux dixièmes d'un épha de fleur de farine, en offrande de farine mélangée à de l'huile, avec sa libation : ");
INSERT INTO frasbl_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","C'est l'holocauste de chaque sabbat, en plus de l'holocauste perpétuel et de sa libation. ");
INSERT INTO frasbl_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","\"'Au commencement de vos mois, vous offrirez un holocauste à Yahvé : deux jeunes taureaux, un bélier, sept agneaux mâles d'un an sans défaut, ");
INSERT INTO frasbl_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","et trois dixièmes d'un épha de fleur de farine pour une offrande de farine mélangée à de l'huile, pour chaque taureau ; deux dixièmes de fleur de farine pour une offrande de farine mélangée à de l'huile, pour le bélier ; ");
INSERT INTO frasbl_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","et un dixième de fleur de farine mélangée à de l'huile pour une offrande de farine, pour chaque agneau, comme holocauste d'odeur agréable, un sacrifice par le feu à l'Éternel. ");
INSERT INTO frasbl_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Leurs libations seront d'un demi-hin de vin pour le taureau, d'un tiers de hin pour le bélier et d'un quart de hin pour l'agneau. C'est l'holocauste de chaque mois, pendant tous les mois de l'année. ");
INSERT INTO frasbl_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","On offrira aussi un bouc en sacrifice pour le péché à Yahvé, en plus de l'holocauste perpétuel et de la libation. ");
INSERT INTO frasbl_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","\"'Le premier mois, le quatorzième jour du mois, c'est la Pâque de Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Le quinzième jour de ce mois, il y aura une fête. On mangera des pains sans levain pendant sept jours. ");
INSERT INTO frasbl_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Le premier jour, il y aura une convocation sainte. Tu ne feras aucun travail régulier, ");
INSERT INTO frasbl_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","mais tu offriras un sacrifice consumé par le feu, un holocauste à l'Éternel : deux jeunes taureaux, un bélier et sept agneaux mâles d'un an. Ils seront sans défaut, ");
INSERT INTO frasbl_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","avec leur offrande de farine, de la fleur de farine mélangée à de l'huile. Tu offriras trois dixièmes pour le taureau, et deux dixièmes pour le bélier. ");
INSERT INTO frasbl_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","Tu offriras un dixième pour chacun des sept agneaux ; ");
INSERT INTO frasbl_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","et un bouc en sacrifice pour le péché, afin de faire l'expiation pour toi. ");
INSERT INTO frasbl_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Tu les offriras en plus de l'holocauste du matin, qui est un holocauste perpétuel. ");
INSERT INTO frasbl_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","C'est ainsi que tu offriras chaque jour, pendant sept jours, l'aliment du sacrifice consumé par le feu, d'une odeur agréable à Yahvé. Elle sera offerte en plus de l'holocauste perpétuel et de sa libation. ");
INSERT INTO frasbl_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Le septième jour, vous aurez une sainte convocation. Vous ne ferez aucun travail régulier. ");
INSERT INTO frasbl_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","\"'Le jour des prémices, lorsque vous offrirez une nouvelle offrande à Yahvé à l'occasion de votre fête des semaines, vous aurez une sainte convocation. Tu ne feras aucun travail régulier, ");
INSERT INTO frasbl_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","mais tu offriras un holocauste d'agréable odeur à Yahvé : deux jeunes taureaux, un bélier, sept agneaux mâles d'un an, ");
INSERT INTO frasbl_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","et leur offrande de farine fine mélangée à de l'huile, trois dixièmes pour chaque taureau, deux dixièmes pour le bélier, ");
INSERT INTO frasbl_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","un dixième pour chacun des sept agneaux, ");
INSERT INTO frasbl_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","et un bouc, afin de faire l'expiation pour toi. ");
INSERT INTO frasbl_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","En plus de l'holocauste perpétuel et de l'offrande, tu les offriras avec leurs libations. Veille à ce qu'ils soient sans défaut. ");
INSERT INTO frasbl_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","\"'Au septième mois, le premier jour du mois, vous aurez une sainte convocation ; vous ne ferez aucun travail régulier. C'est un jour où l'on fait sonner les trompettes pour vous. ");
INSERT INTO frasbl_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Vous offrirez un holocauste d'agréable odeur à Yahvé : un jeune taureau, un bélier, sept agneaux mâles d'un an sans défaut ; ");
INSERT INTO frasbl_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","et leur offrande de farine, de la fleur de farine mélangée à de l'huile : 3 et leur offrande de farine fine mélangée à de l'huile : trois dixièmes pour le taureau, deux dixièmes pour le bélier, ");
INSERT INTO frasbl_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","et un dixième pour chacun des sept agneaux ; ");
INSERT INTO frasbl_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","et un bouc en sacrifice pour le péché, afin de faire l'expiation pour toi ; ");
INSERT INTO frasbl_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","en plus de l'holocauste de la nouvelle lune et de son offrande de farine, de l'holocauste perpétuel et de son offrande de farine, et de leurs libations, selon les règles établies, en sacrifice consumé par le feu devant l'Éternel, d'une agréable odeur. ");
INSERT INTO frasbl_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","\"'Le dixième jour de ce septième mois, vous aurez une convocation sainte. Vous affligerez vos âmes. Vous ne ferez aucun travail, ");
INSERT INTO frasbl_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","mais vous offrirez à Yahvé un holocauste d'agréable odeur : un jeune taureau, un bélier, sept agneaux mâles d'un an, tous sans défaut, ");
INSERT INTO frasbl_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","et leur offrande de farine fine mélangée à de l'huile : trois dixièmes pour le taureau, deux dixièmes pour le bélier, ");
INSERT INTO frasbl_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","un dixième pour chacun des sept agneaux, ");
INSERT INTO frasbl_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","un bouc en sacrifice pour le péché, en plus du sacrifice d'expiation pour le péché, de l'holocauste perpétuel, de l'offrande de farine et des libations. ");
INSERT INTO frasbl_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","\"'Le quinzième jour du septième mois, vous aurez une sainte convocation. Vous ne ferez aucun travail régulier. Vous célébrerez une fête en l'honneur de Yahvé pendant sept jours. ");
INSERT INTO frasbl_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Vous offrirez un holocauste, un sacrifice consumé par le feu, d'une odeur agréable à l'Éternel : treize jeunes taureaux, deux béliers, quatorze agneaux mâles d'un an, tous sans défaut ; ");
INSERT INTO frasbl_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","et leur offrande de farine, de la fleur de farine mélangée à de l'huile : trois dixièmes pour chaque taureau des treize taureaux, deux dixièmes pour chaque bélier des deux béliers, ");
INSERT INTO frasbl_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","et un dixième pour chaque agneau des quatorze agneaux ; ");
INSERT INTO frasbl_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","et un bouc pour le sacrifice pour le péché, en plus de l'holocauste perpétuel, de l'offrande et de la libation. ");
INSERT INTO frasbl_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","\"'Le second jour, tu offriras douze jeunes taureaux, deux béliers et quatorze agneaux mâles d'un an sans défaut, ");
INSERT INTO frasbl_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","avec leurs offrandes et leurs libations pour les taureaux, les béliers et les agneaux, selon leur nombre, d'après l'ordonnance ; ");
INSERT INTO frasbl_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","et un bouc pour le sacrifice pour le péché, en plus de l'holocauste perpétuel, avec ses offrandes et ses libations. ");
INSERT INTO frasbl_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","\"'Le troisième jour, onze taureaux, deux béliers, quatorze agneaux mâles d'un an sans défaut, ");
INSERT INTO frasbl_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","avec leurs offrandes et leurs libations pour les taureaux, les béliers et les agneaux, selon leur nombre, d'après les règles établies ; ");
INSERT INTO frasbl_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","et un bouc pour le sacrifice pour le péché, en plus de l'holocauste perpétuel, de l'offrande et de la libation. ");
INSERT INTO frasbl_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","\"'Le quatrième jour, dix taureaux, deux béliers, quatorze agneaux mâles d'un an sans défaut ; ");
INSERT INTO frasbl_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","leurs offrandes et leurs libations pour les taureaux, pour les béliers et pour les agneaux, selon leur nombre, d'après les règles établies ; ");
INSERT INTO frasbl_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","et un bouc pour le sacrifice pour le péché, en plus de l'holocauste perpétuel, de son offrande et de sa libation. ");
INSERT INTO frasbl_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","\"'Le cinquième jour, neuf taureaux, deux béliers, quatorze agneaux mâles d'un an sans défaut, ");
INSERT INTO frasbl_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","avec leurs offrandes et leurs libations pour les taureaux, les béliers et les agneaux, selon leur nombre, d'après les règles établies, ");
INSERT INTO frasbl_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","et un bouc pour le sacrifice pour le péché, en plus de l'holocauste perpétuel, de l'offrande et de la libation. ");
INSERT INTO frasbl_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","\"'Le sixième jour, huit taureaux, deux béliers, quatorze agneaux mâles d'un an sans défaut, ");
INSERT INTO frasbl_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","avec leurs offrandes et leurs libations pour les taureaux, pour les béliers et pour les agneaux, selon leur nombre, d'après les règles établies, ");
INSERT INTO frasbl_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","et un bouc pour le sacrifice pour le péché, en plus de l'holocauste perpétuel, de son offrande et de ses libations. ");
INSERT INTO frasbl_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","\"'Le septième jour, sept taureaux, deux béliers, quatorze agneaux mâles d'un an sans défaut, ");
INSERT INTO frasbl_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","avec leurs offrandes et leurs libations pour les taureaux, les béliers et les agneaux, selon leur nombre, d'après les règles établies, ");
INSERT INTO frasbl_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","et un bouc pour le sacrifice pour le péché, en plus de l'holocauste perpétuel, de son offrande et de sa libation. ");
INSERT INTO frasbl_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","\"'Le huitième jour, vous aurez une assemblée solennelle. Vous ne ferez aucun travail régulier ; ");
INSERT INTO frasbl_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","mais vous offrirez un holocauste, un sacrifice consumé par le feu, d'une agréable odeur à Yahvé : un taureau, un bélier, sept agneaux mâles d'un an sans défaut ; ");
INSERT INTO frasbl_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","l'offrande et la libation du taureau, du bélier et des agneaux seront déterminées d'après leur nombre, selon les règles établies ; ");
INSERT INTO frasbl_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","et un bouc en sacrifice pour le péché, en plus de l'holocauste perpétuel, de l'offrande et de la libation. ");
INSERT INTO frasbl_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","\"'Tu les offriras à Yahvé lors de tes fêtes, en plus de tes vœux et de tes offrandes volontaires, pour tes holocaustes, tes offrandes de repas, tes libations et tes sacrifices de paix'\". ");
INSERT INTO frasbl_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","Moïse dit aux enfants d'Israël tout ce que l'Éternel lui avait ordonné. ");
INSERT INTO frasbl_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Moïse parla aux chefs des tribus des enfants d'Israël, et dit : « Voici ce que l'Éternel a ordonné. ");
INSERT INTO frasbl_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Lorsqu'un homme fait un vœu à l'Éternel, ou qu'il prête serment de lier son âme par un lien, il ne doit pas manquer à sa parole. Il agira selon tout ce qui sort de sa bouche. ");
INSERT INTO frasbl_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","« De même, lorsqu'une femme fait un vœu à Yahvé et se lie par un engagement, dans la maison de son père, dans sa jeunesse, ");
INSERT INTO frasbl_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","que son père entend son vœu et l'engagement par lequel elle a lié son âme, et que son père ne lui dit rien, tous ses vœux seront valables, et tous les engagements par lesquels elle a lié son âme seront valables. ");
INSERT INTO frasbl_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","Mais si son père l'interdit le jour où il l'entend, aucun de ses vœux, ni aucun des gages par lesquels elle a lié son âme, ne subsistera. Yahvé lui pardonnera, parce que son père lui a interdit. ");
INSERT INTO frasbl_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","Si elle a un mari, alors qu'elle a des vœux sur elle, ou une parole irréfléchie de ses lèvres par laquelle elle a lié son âme, ");
INSERT INTO frasbl_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","et que son mari l'entende, et ne lui dise rien le jour où il l'entend, alors ses vœux subsisteront, et les engagements par lesquels elle a lié son âme subsisteront. ");
INSERT INTO frasbl_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","Mais si son mari l'interdit le jour où il l'entend, il annule le vœu qu'elle a fait et la parole téméraire de ses lèvres, par laquelle elle a lié son âme. Yahvé lui pardonnera. ");
INSERT INTO frasbl_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","« Mais le vœu d'une veuve ou d'une femme divorcée, tout ce par quoi elle a lié son âme, sera retenu contre elle. ");
INSERT INTO frasbl_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","« Si elle a fait un vœu dans la maison de son mari ou si elle a lié son âme par un engagement avec serment, ");
INSERT INTO frasbl_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","et que son mari l'ait entendu, et qu'il se soit tenu tranquille à son égard et ne l'ait pas désavouée, alors tous ses vœux subsisteront, et tout engagement par lequel elle a lié son âme subsistera. ");
INSERT INTO frasbl_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","Mais si son mari les a rendus nuls et non avenus le jour où il les a entendus, alors tout ce qui est sorti de ses lèvres au sujet de ses vœux, ou au sujet du lien de son âme, ne subsistera pas. Son mari les a annulés. L'Éternel lui pardonnera. ");
INSERT INTO frasbl_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Tout vœu, tout serment d'affliction de l'âme, son mari peut l'établir, ou son mari peut l'annuler. ");
INSERT INTO frasbl_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Mais si son mari ne lui dit rien d'un jour à l'autre, il établit tous ses vœux ou tous ses engagements qui sont sur elle. Il les a établis, parce qu'il ne lui a rien dit le jour où il les a entendus. ");
INSERT INTO frasbl_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Mais s'il les annule après les avoir entendus, il portera sa faute. » ");
INSERT INTO frasbl_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Tellessont les lois que l'Éternel a prescrites à Moïse, entre un homme et sa femme, entre un père et sa fille, dans sa jeunesse, dans la maison de son père. ");
INSERT INTO frasbl_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Yahvé parla à Moïse, et dit : ");
INSERT INTO frasbl_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","« Venge les enfants d'Israël sur les Madianites. Ensuite, vous serez rassemblés auprès de votre peuple. » ");
INSERT INTO frasbl_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Moïse parla au peuple, et dit : « Armez des hommes parmi vous pour la guerre, afin qu'ils aillent contre Madian, pour exécuter la vengeance de Yahvé sur Madian. ");
INSERT INTO frasbl_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Vous enverrez mille hommes de chaque tribu, de toutes les tribus d'Israël, à la guerre. » ");
INSERT INTO frasbl_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","On livra donc, parmi les milliers d'Israël, mille hommes de chaque tribu, soit douze mille hommes armés pour la guerre. ");
INSERT INTO frasbl_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Moïse les envoya, mille de chaque tribu, à la guerre, avec Phinées, fils du prêtre Éléazar, à la guerre, les ustensiles du sanctuaire et les trompettes d'alarme dans sa main. ");
INSERT INTO frasbl_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Ils combattirent contre Madian, comme Yahvé l'avait ordonné à Moïse. Ils tuèrent tous les mâles. ");
INSERT INTO frasbl_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Ils tuèrent les rois de Madian avec le reste de leurs morts : Evi, Rékem, Tsur, Hur et Réba, les cinq rois de Madian. Ils tuèrent aussi par l'épée Balaam, fils de Beor. ");
INSERT INTO frasbl_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Les enfants d'Israël emmenèrent captives les femmes de Madian et leurs petits enfants, et ils pillèrent tout leur bétail, tous leurs troupeaux et tous leurs biens. ");
INSERT INTO frasbl_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Ils brûlèrent au feu toutes leurs villes, dans les lieux qu'ils habitaient, et tous leurs campements. ");
INSERT INTO frasbl_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Ils prirent tous les captifs et tout le butin, tant des hommes que des animaux. ");
INSERT INTO frasbl_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","Ils amenèrent les captifs, avec le butin et le pillage, à Moïse, au sacrificateur Éléazar et à l'assemblée des enfants d'Israël, au camp des plaines de Moab, qui sont près du Jourdain, à Jéricho. ");
INSERT INTO frasbl_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Moïse et le sacrificateur Éléazar, avec tous les chefs de l'assemblée, sortirent à leur rencontre hors du camp. ");
INSERT INTO frasbl_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Moïse se mit en colère contre les officiers de l'armée, les chefs de milliers et les chefs de centaines, qui venaient du service de la guerre. ");
INSERT INTO frasbl_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Moïse leur dit : « Avez-vous sauvé toutes les femmes en vie ? ");
INSERT INTO frasbl_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Voici qu'elles ont poussé les enfants d'Israël, par le conseil de Balaam, à commettre une infidélité à l'égard de l'Éternel dans l'affaire de Péor, et c'est ainsi que la plaie a frappé la congrégation de l'Éternel. ");
INSERT INTO frasbl_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Maintenant, tuez tout mâle parmi les petits enfants, et tuez toute femme qui a connu un homme en couchant avec lui. ");
INSERT INTO frasbl_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Mais toutes les filles qui n'ont pas connu d'homme en couchant avec lui, gardez-les vivantes pour vous. ");
INSERT INTO frasbl_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","« Campez hors du camp pendant sept jours. Celui qui a tué quelqu'un et celui qui a touché un mort, purifiez-vous le troisième jour et le septième jour, vous et vos captifs. ");
INSERT INTO frasbl_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Vous purifierez tout vêtement, tout ce qui est fait en peau, tout ce qui est fait en poil de chèvre et tout ce qui est fait en bois. » ");
INSERT INTO frasbl_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Le sacrificateur Éléazar dit aux hommes de guerre qui allaient au combat : « Voici le règlement de la loi que l'Éternel a prescrite à Moïse. ");
INSERT INTO frasbl_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","Cependant, l'or, l'argent, l'airain, le fer, l'étain et le plomb, ");
INSERT INTO frasbl_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","tout ce qui peut résister au feu, vous le ferez passer par le feu, et il sera pur ; néanmoins, il sera purifié avec l'eau pour être impur. Tout ce qui ne résistera pas au feu, vous le ferez passer dans l'eau. ");
INSERT INTO frasbl_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Tu laveras tes vêtements le septième jour, et tu seras pur. Ensuite, tu entreras dans le camp. » ");
INSERT INTO frasbl_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","L'Éternel parla à Moïse, et dit : ");
INSERT INTO frasbl_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","Comptez le butin qui a été fait, tant pour les hommes que pour les animaux, vous, le prêtre Éléazar et les chefs de famille de l'assemblée, ");
INSERT INTO frasbl_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","et partagez le butin en deux parties : entre les hommes de guerre qui sont allés au combat et toute l'assemblée. ");
INSERT INTO frasbl_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Prélève un tribut à l'Éternel sur les hommes de guerre qui sont allés au combat : une âme sur cinq cents, sur les personnes, sur le bétail, sur les ânes et sur les troupeaux. ");
INSERT INTO frasbl_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Prenez-en la moitié et donnez-la au prêtre Éléazar, pour l'offrande de l'Éternel. ");
INSERT INTO frasbl_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Sur la moitié des enfants d'Israël, tu prendras une personne tirée sur cinquante, du bétail, des ânes et des troupeaux, de tout le bétail, et tu la donneras aux Lévites, qui font le service de la tente de Yahvé. » ");
INSERT INTO frasbl_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Moïse et le prêtre Éléazar firent ce que l'Éternel avait ordonné à Moïse. ");
INSERT INTO frasbl_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Or le butin, en sus du butin que les hommes de guerre avaient pris, fut de six cent soixante-quinze mille brebis, ");
INSERT INTO frasbl_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","soixante-douze mille têtes de bétail, ");
INSERT INTO frasbl_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","soixante et un mille ânes, ");
INSERT INTO frasbl_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","et trente-deux mille personnes en tout, des femmes qui n'avaient pas connu d'homme en couchant avec lui. ");
INSERT INTO frasbl_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","La moitié, qui était la part de ceux qui partaient pour la guerre, était en nombre de trois cent trente-sept mille cinq cents moutons ; ");
INSERT INTO frasbl_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","et le tribut de l'Éternel sur les moutons était de six cent soixante-quinze. ");
INSERT INTO frasbl_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","Les bovins étaient au nombre de trente-six mille, et le tribut de l'Éternel était de soixante-douze. ");
INSERT INTO frasbl_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","Les ânes étaient au nombre de trente mille cinq cents ; le tribut de l'Éternel était de soixante et un. ");
INSERT INTO frasbl_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","Les personnes étaient au nombre de seize mille ; le tribut de l'Éternel était de trente-deux personnes. ");
INSERT INTO frasbl_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Moïse remit au sacrificateur Éléazar le tribut, qui était l'ondoiement de l'Éternel, comme l'Éternel l'avait ordonné à Moïse. ");
INSERT INTO frasbl_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Sur la moitié des enfants d'Israël, que Moïse sépara des hommes qui avaient combattu ");
INSERT INTO frasbl_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","(la moitié de l'assemblée était de trois cent trente-sept mille cinq cents moutons, ");
INSERT INTO frasbl_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","trente-six mille têtes de bétail, ");
INSERT INTO frasbl_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","trente mille cinq cents ânes ");
INSERT INTO frasbl_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","et seize mille personnes), ");
INSERT INTO frasbl_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","sur la moitié des enfants d'Israël, Moïse prit un homme et un animal sur cinquante, et les donna aux Lévites, qui faisaient le service du tabernacle de Yahvé, comme Yahvé l'avait ordonné à Moïse. ");
INSERT INTO frasbl_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Les officiers qui commandaient les milliers de l'armée, les chefs de milliers et les chefs de centaines, s'approchèrent de Moïse. ");
INSERT INTO frasbl_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","Ils dirent à Moïse : « Tes serviteurs ont fait le compte des hommes de guerre qui sont sous nos ordres, et il ne manque pas un seul homme parmi nous. ");
INSERT INTO frasbl_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Nous avons apporté l'offrande de l'Éternel, ce que chacun a trouvé : des ornements en or, des bracelets, des bagues, des anneaux, des boucles d'oreilles et des colliers, pour faire l'expiation de nos âmes devant l'Éternel. » ");
INSERT INTO frasbl_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Moïse et le sacrificateur Éléazar prirent leur or, tous les bijoux travaillés. ");
INSERT INTO frasbl_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Tout l'or de l'ondoiement qu'ils offrirent à l'Éternel, des chefs de milliers et des chefs de centaines, fut de seize mille sept cent cinquante sicles. ");
INSERT INTO frasbl_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Les hommes de guerre avaient fait du butin, chacun pour soi. ");
INSERT INTO frasbl_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Moïse et le prêtre Éléazar prirent l'or des chefs de milliers et des chefs de centaines, et l'apportèrent dans la tente d'assignation, comme souvenir pour les enfants d'Israël devant l'Éternel. ");
INSERT INTO frasbl_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Or les fils de Ruben et les fils de Gad avaient un très grand nombre de têtes de bétail. Ils virent le pays de Jaezer et le pays de Galaad. Voici, ce lieu était un lieu pour le bétail. ");
INSERT INTO frasbl_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","Les fils de Gad et les fils de Ruben vinrent parler à Moïse, au sacrificateur Éléazar et aux chefs de l'assemblée, et dirent : ");
INSERT INTO frasbl_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","« Ataroth, Dibon, Jazer, Nimrah, Hesbon, Elealeh, Sebam, Nebo et Beon, ");
INSERT INTO frasbl_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","le pays que Yahvé a frappé devant l'assemblée d'Israël, est un pays d'élevage, et vos serviteurs ont du bétail. » ");
INSERT INTO frasbl_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Ils dirent : « Si nous avons trouvé grâce à tes yeux, que ce pays soit donné en propriété à tes serviteurs. Ne nous fais pas passer le Jourdain. » ");
INSERT INTO frasbl_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Moïse dit aux fils de Gad et aux fils de Ruben : « Vos frères iront-ils à la guerre pendant que vous serez assis ici ? ");
INSERT INTO frasbl_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Pourquoi découragez-vous le cœur des enfants d'Israël d'aller dans le pays que l'Éternel leur a donné ? ");
INSERT INTO frasbl_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Vos pères l'ont fait lorsque je les ai envoyés de Kadès-Barnéa pour voir le pays. ");
INSERT INTO frasbl_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Car lorsqu'ils montèrent à la vallée d'Eshcol et qu'ils virent le pays, ils découragèrent le cœur des enfants d'Israël, pour qu'ils n'aillent pas dans le pays que l'Éternel leur avait donné. ");
INSERT INTO frasbl_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","La colère de Yahvé s'enflamma ce jour-là, et il jura, en disant : ");
INSERT INTO frasbl_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","« Aucun des hommes qui sont montés d'Égypte, depuis l'âge de vingt ans et au-dessus, ne verra le pays que j'ai juré à Abraham, à Isaac et à Jacob, parce qu'ils ne m'ont pas entièrement suivi, ");
INSERT INTO frasbl_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","sauf Caleb, fils de Jephunné, le Kenizien, et Josué, fils de Nun, parce qu'ils ont entièrement suivi Yahvé ». ");
INSERT INTO frasbl_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","La colère de Yahvé s'enflamma contre Israël, et il le fit errer dans le désert pendant quarante ans, jusqu'à ce que toute la génération qui avait fait le mal aux yeux de Yahvé fût consumée. ");
INSERT INTO frasbl_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","« Voici, vous vous êtes levés à la place de vos pères, une multitude d'hommes pécheurs, pour augmenter la colère ardente de l'Éternel contre Israël. ");
INSERT INTO frasbl_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Car si vous vous détournez de lui, il les abandonnera encore une fois dans le désert, et vous détruirez tout ce peuple. » ");
INSERT INTO frasbl_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Ils s'approchèrent de lui et dirent : Nous construirons ici des bergeries pour notre bétail, et des villes pour nos petits enfants ; ");
INSERT INTO frasbl_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","mais nous-mêmes, nous serons armés pour marcher devant les enfants d'Israël, jusqu'à ce que nous les ayons conduits à leur place. Nos petits enfants habiteront dans les villes fortifiées, à cause des habitants du pays. ");
INSERT INTO frasbl_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Nous ne retournerons pas dans nos maisons avant que les enfants d'Israël aient tous reçu leur héritage. ");
INSERT INTO frasbl_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Car nous n'hériterons pas avec eux de l'autre côté du Jourdain et au-delà, puisque notre héritage nous est échu de ce côté-ci du Jourdain, à l'est. » ");
INSERT INTO frasbl_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Moïse leur dit : « Si vous faites cela, si vous vous armez pour aller à la guerre devant l'Éternel, ");
INSERT INTO frasbl_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","et que chacun de vos hommes armés passe le Jourdain devant l'Éternel jusqu'à ce qu'il ait chassé ses ennemis devant lui, ");
INSERT INTO frasbl_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","et que le pays soit soumis à l'Éternel, alors vous reviendrez et vous serez quittes envers l'Éternel et envers Israël. Ce pays sera alors votre propriété devant Yahvé. ");
INSERT INTO frasbl_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","« Mais si tu ne le fais pas, voici, tu as péché contre l'Éternel, et sois sûr que ton péché te découvrira. ");
INSERT INTO frasbl_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Bâtissez des villes pour vos petits enfants et des parcs pour vos brebis, et faites ce qui est sorti de votre bouche. » ");
INSERT INTO frasbl_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Les fils de Gad et les fils de Ruben parlèrent à Moïse et dirent : « Tes serviteurs feront ce que mon seigneur ordonne. ");
INSERT INTO frasbl_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Nos petits enfants, nos femmes, nos troupeaux et tout notre bétail seront là, dans les villes de Galaad ; ");
INSERT INTO frasbl_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","mais tes serviteurs passeront, tout homme armé pour la guerre, devant l'Éternel pour combattre, comme le dit mon seigneur. » ");
INSERT INTO frasbl_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Moïse donna des ordres à leur sujet au prêtre Éléazar, à Josué, fils de Nun, et aux chefs de famille des tribus des enfants d'Israël. ");
INSERT INTO frasbl_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","Moïse leur dit : « Si les fils de Gad et les fils de Ruben passent avec vous le Jourdain, chacun armé pour combattre devant Yahvé, et que le pays soit soumis devant vous, vous leur donnerez le pays de Galaad en propriété ; ");
INSERT INTO frasbl_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","mais s'ils ne passent pas avec vous armés, ils auront des propriétés au milieu de vous dans le pays de Canaan. » ");
INSERT INTO frasbl_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Les fils de Gad et les fils de Ruben répondirent et dirent : « Nous ferons ce que l'Éternel a dit à vos serviteurs. ");
INSERT INTO frasbl_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Nous passerons armés devant Yahvé dans le pays de Canaan, et la possession de notre héritage restera avec nous au-delà du Jourdain. » ");
INSERT INTO frasbl_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Moïse donna aux fils de Gad, aux fils de Ruben et à la demi-tribu de Manassé, fils de Joseph, le royaume de Sihon, roi des Amoréens, et le royaume d'Og, roi de Basan, le pays, avec ses villes et ses limites, et les villes des environs. ");
INSERT INTO frasbl_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Les fils de Gad bâtirent Dibon, Ataroth, Arœr, ");
INSERT INTO frasbl_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Atroth-Shophan, Jazer, Jogbeha, ");
INSERT INTO frasbl_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Beth Nimrah et Beth Haran : villes fortes et replis pour les brebis. ");
INSERT INTO frasbl_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Les fils de Ruben bâtirent Hesbon, Élealé, Kiriathaïm, ");
INSERT INTO frasbl_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","Nébo, Baal Méon, dont les noms ont été changés, et Sibma. Ils donnèrent d`autres noms aux villes qu`ils bâtirent. ");
INSERT INTO frasbl_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Les fils de Makir, fils de Manassé, allèrent à Galaad, s'en emparèrent et dépossédèrent les Amoréens qui s'y trouvaient. ");
INSERT INTO frasbl_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Moïse donna Galaad à Makir, fils de Manassé, qui l'habita. ");
INSERT INTO frasbl_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Jaïr, fils de Manassé, alla prendre ses villages, et il les appela Havvoth Jaïr. ");
INSERT INTO frasbl_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Nobach alla prendre Kenath et ses villages, et il l'appela Nobach, d'après son propre nom. ");
INSERT INTO frasbl_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Voici les voyages des enfants d'Israël, lorsqu'ils sortirent du pays d'Égypte par leurs armées, sous la conduite de Moïse et d'Aaron. ");
INSERT INTO frasbl_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Moïse a écrit les points de départ de leurs voyages sur l'ordre de l'Éternel. Voici leurs itinéraires selon leurs points de départ. ");
INSERT INTO frasbl_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","Ils partirent de Ramsès le premier mois, le quinzième jour du premier mois ; le lendemain de la Pâque, les enfants d'Israël sortirent la main haute aux yeux de tous les Égyptiens, ");
INSERT INTO frasbl_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","pendant que les Égyptiens enterraient tous leurs premiers-nés, que Yahvé avait frappés parmi eux. Yahvé exerça aussi des jugements sur leurs dieux. ");
INSERT INTO frasbl_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Les enfants d'Israël partirent de Ramsès, et ils campèrent à Succoth. ");
INSERT INTO frasbl_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Ils partirent de Succoth, et campèrent à Étham, qui est à l'extrémité du désert. ");
INSERT INTO frasbl_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Ils partirent d'Étham, et se retournèrent vers Pihahiroth, qui est devant Baal Zephon, et ils campèrent devant Migdol. ");
INSERT INTO frasbl_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Ils partirent de devant Hahiroth, et traversèrent le milieu de la mer pour entrer dans le désert. Ils firent trois journées de marche dans le désert d'Étham, et ils campèrent à Mara. ");
INSERT INTO frasbl_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Ils partirent de Mara, et arrivèrent à Elim. A Elim, il y avait douze sources d'eau et soixante-dix palmiers, et ils campèrent là. ");
INSERT INTO frasbl_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Ils partirent d'Élim et campèrent près de la mer Rouge. ");
INSERT INTO frasbl_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","Ils partirent de la mer Rouge, et campèrent dans le désert de Sin. ");
INSERT INTO frasbl_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","Ils partirent du désert de Sin, et campèrent à Dophka. ");
INSERT INTO frasbl_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","Ils partirent de Dophka, et campèrent à Alush. ");
INSERT INTO frasbl_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","Ils partirent d'Alush, et campèrent à Rephidim, où il n'y avait pas d'eau à boire pour le peuple. ");
INSERT INTO frasbl_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","Ils partirent de Rephidim, et campèrent dans le désert de Sinaï. ");
INSERT INTO frasbl_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","Ils partirent du désert de Sinaï, et campèrent à Kibroth Hattaavah. ");
INSERT INTO frasbl_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","Ils partirent de Kibroth Hattaava, et campèrent à Hatséroth. ");
INSERT INTO frasbl_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","Ils partirent de Hatséroth, et campèrent à Rithma. ");
INSERT INTO frasbl_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","Ils partirent de Rithma, et campèrent à Rimmon Pérez. ");
INSERT INTO frasbl_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","Ils partirent de Rimmon Pérez, et campèrent à Libna. ");
INSERT INTO frasbl_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","Ils partirent de Libna, et campèrent à Rissa. ");
INSERT INTO frasbl_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","Ils partirent de Rissa, et campèrent à Kehelatha. ");
INSERT INTO frasbl_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","Ils partirent de Kehelatha, et campèrent à la montagne de Shepher. ");
INSERT INTO frasbl_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","Ils partirent de la montagne de Shepher, et campèrent à Harada. ");
INSERT INTO frasbl_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","Ils partirent de Harada, et campèrent à Makheloth. ");
INSERT INTO frasbl_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","Ils partirent de Makheloth, et campèrent à Tahath. ");
INSERT INTO frasbl_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","Ils partirent de Tahath, et campèrent à Térach. ");
INSERT INTO frasbl_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","Ils partirent de Térach, et campèrent à Mithka. ");
INSERT INTO frasbl_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","Ils partirent de Mithka, et campèrent à Haschmona. ");
INSERT INTO frasbl_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","Ils partirent de Haschmona, et campèrent à Moséroth. ");
INSERT INTO frasbl_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","Ils partirent de Moseroth, et campèrent à Bene Jaakan. ");
INSERT INTO frasbl_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","Ils partirent de Bene Jaakan, et campèrent à Hor Haggidgad. ");
INSERT INTO frasbl_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","Ils partirent de Hor Haggidgad, et campèrent à Jotbatha. ");
INSERT INTO frasbl_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","Ils partirent de Jotbatha, et campèrent à Abrona. ");
INSERT INTO frasbl_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","Ils partirent d`Abrona, et campèrent à Etsjon-Géber. ");
INSERT INTO frasbl_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","Ils partirent d`Etsjon-Géber, et campèrent à Kadès, dans le désert de Tsin. ");
INSERT INTO frasbl_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","Ils partirent de Kadès, et campèrent à la montagne de Hor, à la limite du pays d`Édom. ");
INSERT INTO frasbl_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","Le prêtre Aaron monta sur la montagne de Hor, sur l'ordre de l'Éternel, et il y mourut, la quarantième année après la sortie des enfants d'Israël du pays d'Égypte, le cinquième mois, le premier jour du mois. ");
INSERT INTO frasbl_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Aaron était âgé de cent vingt-trois ans lorsqu'il mourut sur la montagne de Hor. ");
INSERT INTO frasbl_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Le roi cananéen d'Arad, qui habitait au sud du pays de Canaan