﻿USE sofia;
DROP TABLE IF EXISTS sofia.francl_vpl;
CREATE TABLE francl_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES francl_vpl WRITE;
INSERT INTO francl_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Au Commencement Dieu créa le ciel et la terre. ");
INSERT INTO francl_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","La terre était informe et vide ; les ténèbres couvraient l’abîme, et l’Esprit de Dieu se mouvait au-dessus des eaux. ");
INSERT INTO francl_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Dieu dit : « Que la lumière soit ! » et la lumière fut. ");
INSERT INTO francl_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Et Dieu vit que la lumière était bonne ; et Dieu sépara la lumière et les ténèbres. ");
INSERT INTO francl_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Dieu appela la lumière jour, et les ténèbres Nuit. Et il y eut un soir, et il y eut un matin ; ce fut le premier jour. ");
INSERT INTO francl_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Dieu dit : « Qu’il y ait un firmament entre les eaux, et qu’il sépare les eaux d’avec les eaux. » ");
INSERT INTO francl_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Et Dieu fit le firmament, et il sépara les eaux qui sont au-dessous du firmament d’avec les eaux qui sont au-dessus du firmament. Et cela fut ainsi. ");
INSERT INTO francl_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Dieu appela le firmament Ciel. Et il y eut un soir et il y eut un matin ; ce fut le second jour. ");
INSERT INTO francl_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Dieu dit : « Que les eaux qui sont au-dessous du ciel se rassemblent en un seul lieu, et que le sec paraisse. » Et cela fut ainsi. ");
INSERT INTO francl_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Dieu appela le sec Terre, et il appela Mer l’amas des eaux. Et Dieu vit que cela était bon. ");
INSERT INTO francl_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Puis Dieu dit : « Que la terre fasse pousser du gazon, des herbes portant semence, des arbres à fruit produisant, selon leur espèce, du fruit ayant en soi sa semence, sur la terre. » Et cela fut ainsi. ");
INSERT INTO francl_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Et la terre fit sortir du gazon, des herbes portant semence selon leur espèce, et des arbres produisant, selon leur espèce, du fruit ayant en soi sa semence. Et Dieu vit que cela était bon. ");
INSERT INTO francl_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Et il y eut un soir, et il y eut un matin ; ce fut le troisième jour. ");
INSERT INTO francl_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Dieu dit : « Qu’il y ait des luminaires dans le firmament du ciel pour séparer le jour et la nuit ; qu’ils soient des signes, qu’ils marquent les époques, les jours et les années, ");
INSERT INTO francl_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","et qu’ils servent de luminaires dans le firmament du ciel pour éclairer la terre. » Et cela fut ainsi. ");
INSERT INTO francl_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Dieu fit les deux grands luminaires, le plus grand luminaire pour présider au jour, le plus petit luminaire pour présider à la nuit ; il fit aussi les étoiles. ");
INSERT INTO francl_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Dieu les plaça dans le firmament du ciel pour éclairer la terre, ");
INSERT INTO francl_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","pour présider au jour et à la nuit, et pour séparer la lumière et les ténèbres. Et Dieu vit que cela était bon. ");
INSERT INTO francl_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Et il y eut un soir, et il y eut un matin : ce fut le quatrième jour. ");
INSERT INTO francl_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Dieu dit : « Que les eaux foisonnent d’une multitude d’êtres vivants, et que les oiseaux volent sur la terre, sur la face du firmament du ciel. » ");
INSERT INTO francl_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Et Dieu créa les grands animaux aquatiques, et tout être vivant qui se meut, foisonnant dans les eaux, selon leur espèce, et tout volatile ailé selon son espèce. Et Dieu vit que cela était bon. ");
INSERT INTO francl_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Et Dieu les bénit, en disant : « Soyez féconds et multipliez, et remplissez les eaux de la mer, et que les oiseaux multiplient sur la terre. » ");
INSERT INTO francl_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Et il y eut un soir, et il y eut un matin : ce fut le cinquième jour. ");
INSERT INTO francl_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Dieu dit : « Que la terre fasse sortir des êtres animés selon leur espèce, des animaux domestiques, des reptiles et des bêtes de la terre selon leur espèce. » Et cela fut ainsi. ");
INSERT INTO francl_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Dieu fit les bêtes de la terre selon leur espèce, les animaux domestiques selon leur espèce, et tout ce qui rampe sur la terre selon son espèce. Et Dieu vit que cela était bon. ");
INSERT INTO francl_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Puis Dieu dit : « Faisons l’homme à notre image, selon notre ressemblance, et qu’il domine sur les poissons de la mer, sur les oiseaux du ciel, sur les animaux domestiques et sur toute la terre, et sur les reptiles qui rampent sur la terre. » ");
INSERT INTO francl_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Et Dieu créa l’homme à son image ; il le créa à l’image de Dieu : il les créa mâle et femelle. ");
INSERT INTO francl_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Et Dieu les bénit, et il leur dit : « Soyez féconds, multipliez, remplissez la terre et soumettez-la, et dominez sur les poissons de la mer, sur les oiseaux du ciel et sur tout animal qui se meut sur la terre. » ");
INSERT INTO francl_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Et Dieu dit : « Voici que je vous donne toute herbe portant semence à la surface de toute la terre, et tout arbre qui porte un fruit d’arbre ayant semence ; ce sera pour votre nourriture. ");
INSERT INTO francl_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Et à tout animal de la terre, et à tout oiseau du ciel, et à tout ce qui se meut sur la terre, ayant en soi un souffle de vie, je donne toute herbe verte pour nourriture. » Et cela fut ainsi. ");
INSERT INTO francl_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Et Dieu vit tout ce qu’il avait fait, et voici cela était très bon. Et il y eut un soir, et il y eut un matin : ce fut le sixième jour. ");
INSERT INTO francl_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Ainsi furent achevés le ciel et la terre, et toute leur armée. ");
INSERT INTO francl_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Et Dieu eut achevé le septième jour son œuvre qu’il avait faite, et il se reposa le septième jour de toute son œuvre qu’il avait faite. ");
INSERT INTO francl_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Et Dieu bénit le septième jour et le sanctifia, parce qu’en ce jour-là il s’était reposé de toute l’œuvre qu’il avait créée en la faisant. ");
INSERT INTO francl_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Voici l’histoire du ciel et de la terre quand ils furent créés, lorsque Yahweh Dieu eut fait une terre et un ciel. ");
INSERT INTO francl_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Il n’y avait encore sur la terre aucun arbrisseau des champs, et aucune herbe des champs n’avait encore germé ; car Yahweh Dieu n’avait pas fait pleuvoir sur la terre, et il n’y avait pas d’homme pour cultiver le sol. ");
INSERT INTO francl_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Mais une vapeur montait de la terre et arrosait toute la surface du sol. ");
INSERT INTO francl_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Yahweh Dieu forma l’homme de la poussière du sol, et il souffla dans ses narines un souffle de vie, et l’homme devint un être vivant. ");
INSERT INTO francl_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Puis Yahweh Dieu planta un jardin en Eden du côté de l’Orient, et il y mit l’homme qu’il avait formé. ");
INSERT INTO francl_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Et Yahweh Dieu fit pousser du sol toute espèce d’arbres agréables à voir et bons à manger, et l’arbre de la vie au milieu du jardin, et l’arbre de la connaissance du bien et du mal. ");
INSERT INTO francl_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Un fleuve sortait d’Eden pour arroser le jardin, et de là il se partageait en quatre bras. ");
INSERT INTO francl_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Le nom du premier est Phison ; c’est celui qui entoure tout le pays d’Hévilath, où se trouve l’or. ");
INSERT INTO francl_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Et l’or de ce pays est bon ; là aussi se trouvent le bdellium et la pierre d’onyx. ");
INSERT INTO francl_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Le nom du second fleuve est Géhon ; c’est celui qui entoure toute la terre de Cousch. ");
INSERT INTO francl_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Le nom du troisième est le Tigre ; c’est celui qui coule à l’orient d’Assur. Le quatrième fleuve est l’Euphrate. ");
INSERT INTO francl_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Yahweh Dieu prit l’homme et le plaça dans le jardin d’Eden pour le cultiver et pour le garder. ");
INSERT INTO francl_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Et Yahweh Dieu donna à l’homme cet ordre : « Tu peux manger de tous les arbres du jardin ; ");
INSERT INTO francl_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","mais tu ne mangeras pas de l’arbre de la connaissance du bien et du mal, car le jour où tu en mangeras, tu mourras certainement. » ");
INSERT INTO francl_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Yahweh Dieu dit : « Il n’est pas bon que l’homme soit seul ; je lui ferai une aide semblable à lui. » ");
INSERT INTO francl_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Et Yahweh Dieu, qui avait formé du sol tous les animaux des champs et tous les oiseaux du ciel, les fit venir vers l’homme pour voir comment il les appellerait, et pour que tout être vivant portât le nom que lui donnerait l’homme. ");
INSERT INTO francl_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Et l’homme donna des noms à tous les animaux domestiques, aux oiseaux du ciel et à tous les animaux des champs ; mais il ne trouva pas pour l’homme une aide semblable à lui. ");
INSERT INTO francl_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Alors Yahweh Dieu fit tomber un profond sommeil sur l’homme, qui s’endormit, et il prit une de ses côtes et referma la chair à sa place. ");
INSERT INTO francl_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","De la côte qu’il avait prise de l’homme, Yahweh Dieu forma une femme, et il l’amena à l’homme. ");
INSERT INTO francl_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Et l’homme dit : « Celle-ci cette fois est os de mes os et chair de ma chair ! Celle-ci sera appelée femme, parce qu’elle a été prise de l’homme. » ");
INSERT INTO francl_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","C’est pourquoi l’homme quittera son père et sa mère, et s’attachera à sa femme, et ils deviendront une seule chair. ");
INSERT INTO francl_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Ils étaient nus tous deux, l’homme et sa femme, sans en avoir honte. ");
INSERT INTO francl_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Le serpent était le plus rusé de tous les animaux des champs que Yahweh Dieu ait faits. Il dit à la femme : « Est-ce que Dieu aurait dit : « Vous ne mangerez pas de tout arbre du jardin ? » ");
INSERT INTO francl_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","La femme répondit au serpent : « Nous mangeons du fruit des arbres du jardin. ");
INSERT INTO francl_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Mais du fruit de l’arbre qui est au milieu du jardin, Dieu a dit : Vous n’en mangerez pas et vous n’y toucherez point, de peur que vous ne mouriez. » ");
INSERT INTO francl_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Le serpent dit à la femme : « Non, vous ne mourrez point ; ");
INSERT INTO francl_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","mais Dieu sait que, le jour où vous en mangerez, vos yeux s’ouvriront et vous serez comme Dieu, connaissant le bien et le mal. » ");
INSERT INTO francl_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","La femme vit que le fruit de l’arbre était bon à manger, agréable à la vue et désirable pour acquérir l’intelligence ; elle prit de son fruit et en mangea ; elle en donna aussi à son mari qui était avec elle, et il en mangea. ");
INSERT INTO francl_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Leurs yeux à tous deux s’ouvrirent et ils connurent qu’ils étaient nus ; et, ayant cousu des feuilles de figuier, ils s’en firent des ceintures. ");
INSERT INTO francl_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Alors ils entendirent la voix de Yahweh Dieu passant dans le jardin à la brise du jour, et l’homme et sa femme se cachèrent de devant Yahweh Dieu au milieu des arbres du jardin. ");
INSERT INTO francl_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Mais Yahweh Dieu appela l’homme et lui dit : « Où es-tu ? » ");
INSERT INTO francl_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Il répondit : « J’ai entendu ta voix, dans le jardin, et j’ai eu peur, car je suis nu ; et je me suis caché. » ");
INSERT INTO francl_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Et Yahweh Dieu dit : « Qui t’a appris que tu es nu ? Est-ce que tu as mangé de l’arbre dont je t’avais défendu de manger ? » ");
INSERT INTO francl_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","L’homme répondit : « La femme que vous avez mise avec moi m’a donné du fruit de l’arbre, et j’en ai mangé. » ");
INSERT INTO francl_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Yahweh Dieu dit à la femme : « Pourquoi as-tu fait cela ? » La femme répondit : « Le serpent m’a trompée, et j’en ai mangé. » ");
INSERT INTO francl_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Yahweh Dieu dit au serpent : « Parce que tu as fait cela, tu es maudit entre tous les animaux domestiques et toutes les bêtes des champs ; tu marcheras sur ton ventre, et tu mangeras la poussière tous les jours de ta vie. ");
INSERT INTO francl_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Et je mettrai une inimitié entre toi et la femme, entre ta postérité et sa postérité ; celle-ci te meurtrira à la tête, et tu la meurtriras au talon. » ");
INSERT INTO francl_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","A la femme il dit : « je multiplierai tes souffrances, et spécialement celles de ta grossesse ; tu enfanteras des fils dans la douleur ; ton désir se portera vers ton mari, et il dominera sur toi. » ");
INSERT INTO francl_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Il dit à l’homme : « Parce que tu as écouté la voix de ta femme, et que tu as mangé de l’arbre au sujet duquel je t’avais donné cet ordre : Tu n’en mangeras pas, le sol est maudit à cause de toi. C’est par un travail pénible que tu en tireras ta nourriture, tous les jours de ta vie ; ");
INSERT INTO francl_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","il te produira des épines et des chardons, et tu mangeras l’herbe des champs. ");
INSERT INTO francl_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","C’est à la sueur de ton visage que tu mangeras du pain, jusqu’à ce que tu retournes à la terre, parce que c’est d’elle que tu as été pris ; car tu es poussière et tu retourneras en poussière. » ");
INSERT INTO francl_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Adam donna à sa femme le nom d’Eve, parce qu’elle a été la mère de tous les vivants. ");
INSERT INTO francl_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Yahweh Dieu fit à Adam et à sa femme des tuniques de peau et les en revêtit. ");
INSERT INTO francl_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Et Yahweh Dieu dit : « Voici que l’homme est devenu comme l’un de nous, pour la connaissance du bien et du mal. Maintenant, qu’il n’avance pas sa main, qu’il ne prenne pas aussi de l’arbre de vie, pour en manger et vivre éternellement. » ");
INSERT INTO francl_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Et Yahweh Dieu le fit sortir du jardin d’Eden, pour qu’il cultivât la terre d’où il avait été pris. ");
INSERT INTO francl_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Et il chassa l’homme, et il mit à l’orient du jardin d’Eden les Chérubins et la flamme de l’épée tournoyante, pour garder le chemin de l’arbre de vie. ");
INSERT INTO francl_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adam connut Eve, sa femme ; elle conçut et enfanta Caïn, et elle dit : « J’ai acquis un homme avec le secours de Yahweh ! » ");
INSERT INTO francl_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Elle enfanta encore Abel, son frère. Abel fut pasteur de brebis, et Caïn était laboureur. ");
INSERT INTO francl_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Au bout de quelque temps, Caïn offrit des produits de la terre en oblation à Yahweh ; ");
INSERT INTO francl_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Abel, de son côté, offrit des premiers-nés de son troupeau et de leur graisse. Yahweh regarda Abel et son offrande ; ");
INSERT INTO francl_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","mais il ne regarda pas Caïn et son offrande. Caïn en fut très irrité et son visage fut abattu. ");
INSERT INTO francl_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Yahweh dit à Caïn : « Pourquoi es-tu irrité, et pourquoi ton visage est-il abattu ? ");
INSERT INTO francl_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Si tu fais bien, ne seras-tu pas agréé ? Et si tu ne fais pas bien, le péché ne se couche-t-il pas à ta porte ? Son désir se tourne vers toi ; mais toi, tu dois dominer sur lui. » ");
INSERT INTO francl_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Caïn dit à Abel, son frère : « Allons aux champs. » Et, comme ils étaient dans les champs, Caïn s’éleva contre Abel, son frère, et le tua. ");
INSERT INTO francl_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Et Yahweh dit à Caïn : « Où est Abel, ton frère ? » Il répondit : « Je ne sais pas ; suis-je le gardien de mon frère ? » ");
INSERT INTO francl_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Yahweh dit : « Qu’as-tu fait ? La voix du sang de ton frère crie de la terre jusqu’à moi. ");
INSERT INTO francl_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Maintenant tu es maudit de la terre, qui a ouvert sa bouche pour recevoir de ta main le sang de ton frère. ");
INSERT INTO francl_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Quand tu cultiveras la terre, elle ne donnera plus ses fruits ; tu seras errant et fugitif sur la terre. » ");
INSERT INTO francl_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Caïn dit à Yahweh : « Ma peine est trop grande pour que je la puisse supporter. ");
INSERT INTO francl_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Voici que vous me chassez aujourd’hui de cette terre, et je serai caché loin de votre face ; je serai errant et fugitif sur la terre, et quiconque me trouvera me tuera. » ");
INSERT INTO francl_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Yahweh lui dit : « Eh bien, si quelqu’un tue Caïn, Caïn sera vengé sept fois. » Et Yahweh mit un signe sur Caïn, afin que quiconque le rencontrerait ne le tuât pas. ");
INSERT INTO francl_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Puis Caïn s’éloigna de devant Yahweh, et il habita dans le pays de Nod, à l’orient d’Eden. ");
INSERT INTO francl_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Caïn connut sa femme ; elle conçut et enfanta Hénoch. Et il se mit à bâtir une ville qu’il appela Hénoch, du nom de son fils. ");
INSERT INTO francl_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Irad naquit à Hénoch, et il engendra Maviaël ; Maviaël engendra Mathusaël, et Mathusaël engendra Lamech. ");
INSERT INTO francl_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamech prit deux femmes ; le nom de l’une était Ada, et celui de la seconde Sella. ");
INSERT INTO francl_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada enfanta Jabel : il a été le père de ceux qui habitent sous des tentes et au milieu de troupeaux. ");
INSERT INTO francl_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Le nom de son frère était Jubal : il a été le père de tous ceux qui jouent de la harpe et du chalumeau. ");
INSERT INTO francl_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Sella, de son côté, enfanta Tubal-Caïn, qui forgeait toute espèce d’instruments tranchants d’airain et de fer. La sœur de Tubal-Caïn était Noéma. ");
INSERT INTO francl_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lamech dit à ses femmes : Ada et Sella, entendez ma voix, femmes de Lamech, écoutez ma parole : J’ai tué un homme pour ma blessure, et un jeune homme pour ma meurtrissure. ");
INSERT INTO francl_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Caïn sera vengé sept fois, et Lamech soixante-dix-sept fois. ");
INSERT INTO francl_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adam connut encore sa femme ; elle enfanta un fils et l’appela Seth, car, dit-elle, « Dieu m’a donné une postérité à la place d’Abel, que Caïn a tué. » ");
INSERT INTO francl_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Seth eut aussi un fils, qu’il appela Enos. Ce fut alors que l’on commença à invoquer le nom de Yahweh. ");
INSERT INTO francl_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Voici le livre de l’histoire d’Adam. Lorsque Dieu créa Adam, il le fit à la ressemblance de Dieu. ");
INSERT INTO francl_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Il les créa mâle et femelle, et il les bénit, et il leur donna le nom d’Homme, lorsqu’ils furent créés. ");
INSERT INTO francl_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adam vécut cent trente ans, et il engendra un fils à sa ressemblance, selon son image, et il lui donna le nom de Seth. ");
INSERT INTO francl_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Les jours d’Adam, après qu’il eut engendré Seth, furent de huit cents ans, et il engendra des fils et des filles. ");
INSERT INTO francl_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Tout le temps qu’Adam vécut fut de neuf cent trente ans, et il mourut. ");
INSERT INTO francl_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Seth vécut cent cinq ans, et il engendra Enos. ");
INSERT INTO francl_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Après qu’il eut engendré Enos, Seth vécut huit cent sept ans, et il engendra des fils et des filles. ");
INSERT INTO francl_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Tout le temps que Seth vécut fut de neuf cent douze ans, et il mourut. ");
INSERT INTO francl_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enos vécut quatre-vingt-dix ans, et il engendra Caïnan. ");
INSERT INTO francl_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Après qu’il eut engendré Caïnan, Enos vécut huit cent quinze ans, et il engendra des fils et des filles. ");
INSERT INTO francl_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Tout le temps qu’Enos vécut fut de neuf cent cinq ans, et il mourut. ");
INSERT INTO francl_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Caïnan vécut soixante-dix ans, et il engendra Malaléel. ");
INSERT INTO francl_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Après qu’il eut engendré Malaléel, Caïnan vécut huit cent quarante ans, et il engendra des fils et des filles. ");
INSERT INTO francl_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Tout le temps que Caïnan vécut fut de neuf cent dix ans, et il mourut. ");
INSERT INTO francl_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Malaléel vécut soixante-cinq ans, et il engendra Jared. ");
INSERT INTO francl_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Après qu’il eut engendré Jared, Malaléel vécut huit cent trente ans, et il engendra des fils et des filles. ");
INSERT INTO francl_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Tout le temps que Malaléel vécut fut de huit cent quatre-vingt-quinze ans, et il mourut. ");
INSERT INTO francl_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Jared vécut cent soixante-deux ans, et il engendra Hénoch. ");
INSERT INTO francl_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Après qu’il eut engendré Hénoch, Jared vécut huit cents ans, et il engendra des fils et des filles. ");
INSERT INTO francl_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Tout le temps que Jared vécut fut de neuf cent soixante-deux ans, et il mourut. ");
INSERT INTO francl_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Hénoch vécut soixante-cinq ans, et il engendra Mathusalem. ");
INSERT INTO francl_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Après qu’il eut engendré Mathusalem, Hénoch marcha avec Dieu trois cents ans, et il engendra des fils et des filles. ");
INSERT INTO francl_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Tout le temps qu’Hénoch vécut fut de trois cent soixante-cinq ans. ");
INSERT INTO francl_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Hénoch marcha avec Dieu, et on ne le vit plus, car Dieu l’avait pris. ");
INSERT INTO francl_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Mathusalem vécut cent quatre-vingt-sept ans, et il engendra Lamech. ");
INSERT INTO francl_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Après qu’il eut engendré Lamech, Mathusalem vécut sept cent quatre-vingt-deux ans, et il engendra des fils et des filles. ");
INSERT INTO francl_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Tout le temps que Mathusalem vécut fut de neuf cent soixante-neuf ans, et il mourut. ");
INSERT INTO francl_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lamech vécut cent quatre-vingt-deux ans, et il engendra un fils. ");
INSERT INTO francl_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Il lui donna le nom de Noé, en disant : « Celui-ci nous soulagera de nos fatigues et du travail pénible de nos mains, provenant de ce sol qu’a maudit Yahweh. » ");
INSERT INTO francl_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Après qu’il eut engendré Noé, Lamech vécut cinq cent quatre-vingt-quinze ans, et il engendra des fils et des filles. ");
INSERT INTO francl_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Tout le temps que Lamech vécut fut de sept cent soixante-dix-sept ans, et il mourut. ");
INSERT INTO francl_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Noé, âgé de cinq cents ans, engendra Sem, Cham et Japheth. ");
INSERT INTO francl_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Lorsque les hommes eurent commencé à être nombreux sur la surface de la terre, et qu’il leur fut né des filles, ");
INSERT INTO francl_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","les fils de Dieu virent que les filles des hommes étaient belles, et ils en prirent pour femmes parmi toutes celles qui leur plurent. ");
INSERT INTO francl_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Et Yahweh dit : « Mon esprit ne demeurera pas toujours dans l’homme, car l’homme n’est que chair, et ses jours seront de cent vingt ans. » ");
INSERT INTO francl_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Or, les géants étaient sur la terre en ces jours-là, et cela après que les fils de Dieu furent venus vers les filles des hommes, et qu’elles leur eurent donné des enfants : ce sont là les héros renommés dès les temps anciens. ");
INSERT INTO francl_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Yahweh vit que la méchanceté des hommes était grande sur la terre, et que toutes les pensées de leur cœur se portaient chaque jour uniquement vers le mal. ");
INSERT INTO francl_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Et Yahweh se repentit d’avoir fait l’homme sur la terre, et il fut affligé dans son cœur, ");
INSERT INTO francl_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","et il dit : « J’exterminerai de dessus la terre l’homme que j’ai créé, depuis l’homme jusqu’aux animaux domestiques, aux reptiles et aux oiseaux du ciel, car je me repens de les avoir faits. » ");
INSERT INTO francl_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Mais Noé trouva grâce aux yeux de Yahweh. ");
INSERT INTO francl_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Voici l’histoire de Noé. Noé était un homme juste, intègre parmi les hommes de son temps ; Noé marchait avec Dieu. ");
INSERT INTO francl_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Noé engendra trois fils, Sem, Cham et Japheth. ");
INSERT INTO francl_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Or la terre se corrompit devant Dieu et se remplit de violence. ");
INSERT INTO francl_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Dieu regarda la terre, et voici qu’elle était corrompue, car toute chair avait corrompu sa voie sur la terre. ");
INSERT INTO francl_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Alors Dieu dit à Noé : « La fin de toute chair est venue devant moi, car la terre est pleine de violence à cause d’eux ; je vais les détruire, ainsi que la terre. ");
INSERT INTO francl_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Fais-toi une arche de bois résineux ; tu la feras composée de cellules et tu l’enduiras de bitume en dedans et en dehors. ");
INSERT INTO francl_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Voici comment tu la feras : la longueur de l’arche sera de trois cents coudées, sa largeur de cinquante coudées et sa hauteur de trente. ");
INSERT INTO francl_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Tu feras à l’arche une ouverture, à laquelle tu donneras une coudée depuis le toit ; tu établiras une porte sur le côté de l’arche, et tu feras un premier, un second et un troisième étage de cellules. ");
INSERT INTO francl_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Et moi, je vais faire venir le déluge, une inondation de la terre, pour détruire de dessous le ciel toute chair ayant en soi souffle de vie ; tout ce qui est sur la terre périra. ");
INSERT INTO francl_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Mais j’établirai mon alliance avec toi ; et tu entreras dans l’arche, toi et tes fils, ta femme et les femmes de tes fils avec toi. ");
INSERT INTO francl_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","De tout ce qui vit, de toute chair, tu feras entrer dans l’arche deux de chaque espèce, pour les conserver en vie avec toi ; ce sera un mâle et une femelle. ");
INSERT INTO francl_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Des oiseaux des diverses espèces, des animaux domestiques des diverses espèces, et de toutes les espèces d’animaux qui rampent sur le sol, deux de toute espèce viendront vers toi, pour que tu leur conserves la vie. ");
INSERT INTO francl_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Et toi, prends de tous les aliments que l’on mange et fais-en provision près de toi, afin qu’ils te servent de nourriture, ainsi qu’à eux. » ");
INSERT INTO francl_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Noé se mit à l’œuvre ; il fit tout ce que Dieu lui avait ordonné. ");
INSERT INTO francl_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Yahweh dit à Noé : « Entre dans l’arche, toi et toute ta maison, car je t’ai vu juste devant moi au milieu de cette génération. ");
INSERT INTO francl_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","De tous les animaux purs, tu en prendras avec toi sept paires, des mâles et leurs femelles, et de tous les animaux qui ne sont pas purs, tu en prendras deux, un mâle et sa femelle ; ");
INSERT INTO francl_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","sept paires aussi des oiseaux du ciel, des mâles et leurs femelles, pour conserver en vie leur race sur la face de toute la terre. ");
INSERT INTO francl_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Car, encore sept jours et je ferai pleuvoir sur la terre pendant quarante jours et quarante nuits, et j’exterminerai de la face de la terre tous les êtres que j’ai faits. » ");
INSERT INTO francl_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Noé fit tout ce que Yahweh lui avait ordonné. ");
INSERT INTO francl_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Il avait six cents ans quand eut lieu le déluge, une inondation de la terre. ");
INSERT INTO francl_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Noé entra dans l’arche avec ses fils, sa femme et les femmes de ses fils pour échapper aux eaux du déluge. ");
INSERT INTO francl_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Des animaux purs et de ceux qui ne sont pas purs, des oiseaux et de tout ce qui rampe sur le sol, ");
INSERT INTO francl_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","chaque paire, mâle et femelle, vint vers Noé dans l’arche, comme Dieu l’avait ordonné à Noé. ");
INSERT INTO francl_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Et, au bout de sept jours, les eaux du déluge se répandirent sur la terre. ");
INSERT INTO francl_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","L’an six cent de la vie de Noé, au deuxième mois, le dix-septième jour du mois, en ce jour-là, toutes les sources du grand abîme jaillirent et les écluses du ciel s’ouvrirent, ");
INSERT INTO francl_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","et la pluie tomba sur la terre durant quarante jours et quarante nuits. ");
INSERT INTO francl_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Ce même jour, Noé entra dans l’arche, avec Sem, Cham et Japhet, fils de Noé, la femme de Noé et les trois femmes de ses fils avec eux, ");
INSERT INTO francl_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","eux et toutes les bêtes des diverses espèces, tous les animaux domestiques des diverses espèces, tous les reptiles des diverses espèces qui rampent sur la terre, et tous les oiseaux des diverses espèces, tous les petits oiseaux, tout ce qui a des ailes. ");
INSERT INTO francl_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Ils vinrent vers Noé dans l’arche, deux à deux, de toute chair ayant souffle de vie. ");
INSERT INTO francl_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Ils arrivaient mâle et femelle, de toute chair, comme Dieu l’avait ordonné à Noé. Et Yahweh ferma la porte sur lui. ");
INSERT INTO francl_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Le déluge fut quarante jours sur la terre ; les eaux grossirent et soulevèrent l’arche, et elle s’éleva au-dessus de la terre. ");
INSERT INTO francl_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Les eaux crûrent et devinrent extrêmement grosses sur la terre, et l’arche flotta sur les eaux. ");
INSERT INTO francl_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Les eaux, ayant grossi de plus en plus, couvrirent toutes les hautes montagnes qui sont sous le ciel tout entier. ");
INSERT INTO francl_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Les eaux s’élevèrent de quinze coudées au-dessus des montagnes qu’elles recouvraient. ");
INSERT INTO francl_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Toute chair qui se meut sur la terre périt : oiseaux, animaux domestiques, bêtes sauvages, tout ce qui rampe sur la terre, ainsi que tous les hommes. ");
INSERT INTO francl_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","De tout ce qui existe sur la terre sèche, tout ce qui a souffle de vie dans les narines mourut. ");
INSERT INTO francl_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Tout être qui se trouve sur la face du sol fut détruit, depuis l’homme jusqu’à l’animal domestique, jusqu’aux reptiles et jusqu’aux oiseaux du ciel ; ils furent exterminés de la terre, et il ne resta que Noé et ce qui était avec lui dans l’arche. ");
INSERT INTO francl_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Les eaux furent hautes sur la terre pendant cent cinquante jours. ");
INSERT INTO francl_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Dieu se souvint de Noé, de toutes les bêtes et de tous les animaux domestiques qui étaient avec lui dans l’arche, et Dieu fit passer un vent sur la terre, et les eaux baissèrent ; ");
INSERT INTO francl_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","les sources de l’abîme et les écluses du ciel se fermèrent, et la pluie cessa de tomber du ciel. ");
INSERT INTO francl_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Les eaux se retirèrent de dessus la terre, allant et revenant, et elles s’abaissèrent au bout de cent cinquante jours. ");
INSERT INTO francl_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Au septième mois, le dix-septième jour du mois, l’arche s’arrêta sur les montagnes d’Ararat. ");
INSERT INTO francl_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Les eaux allèrent se retirant jusqu’au dixième mois ; et, au dixième mois, le premier jour du mois, apparurent les sommets des montagnes. ");
INSERT INTO francl_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Au bout de quarante jours, Noé ouvrit la fenêtre qu’il avait faite à l’arche, ");
INSERT INTO francl_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","et lâcha le corbeau, qui sortit, allant et revenant, jusqu’à ce que les eaux fussent séchées au-dessus de la terre. ");
INSERT INTO francl_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Il lâcha ensuite la colombe d’auprès de lui, pour voir si les eaux avaient diminué de la surface de la terre. ");
INSERT INTO francl_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Mais la colombe, n’ayant pas trouvé où poser la plante de son pied, revint vers lui dans l’arche ; parce qu’il y avait encore des eaux à la surface de toute la terre. Il étendit la main et, l’ayant prise, il la fit rentrer auprès de lui dans l’arche. ");
INSERT INTO francl_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Il attendit encore sept autres jours, et il lâcha de nouveau la colombe hors de l’arche, ");
INSERT INTO francl_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","et la colombe revint vers lui sur le soir, et voici, une feuille d’olivier toute fraîche était dans son bec ; et Noé reconnut que les eaux ne couvraient plus la terre. ");
INSERT INTO francl_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Il attendit encore sept autres jours, et il lâcha la colombe ; et elle ne revint plus vers lui. ");
INSERT INTO francl_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","L’an six cent un, au premier mois, le premier jour du mois, les eaux avaient séché sur la terre. Noé ôta la couverture de l’arche et regarda, et voici, la surface du sol avait séché. ");
INSERT INTO francl_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Au second mois, le vingt-septième jour du mois, la terre fut sèche. ");
INSERT INTO francl_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Alors Dieu parla à Noé, en disant : ");
INSERT INTO francl_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","« Sors de l’arche, toi et ta femme, tes fils et les femmes de tes fils avec toi. ");
INSERT INTO francl_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Toutes les bêtes de toute chair, qui sont avec toi, oiseaux, animaux domestiques, et tous les reptiles qui rampent sur la terre, fais-les sortir avec toi ; qu’ils se répandent sur la terre, qu’ils soient féconds et multiplient sur la terre. » ");
INSERT INTO francl_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Noé sortit, lui et ses fils, sa femme et les femmes de ses fils. ");
INSERT INTO francl_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Toutes les bêtes, tous les reptiles et tous les oiseaux, tous les êtres qui se meuvent sur la terre, selon leurs espèces, sortirent de l’arche. ");
INSERT INTO francl_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Noé construisit un autel à Yahweh et, ayant pris de tous les animaux purs et de tous les oiseaux purs, il offrit des holocaustes sur l’autel. ");
INSERT INTO francl_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Yahweh sentit une odeur agréable, et Yahweh dit en son cœur : « Je ne maudirai plus désormais la terre à cause de l’homme, parce que les pensées du cœur de l’homme sont mauvaises dès sa jeunesse, et je ne frapperai plus tout être vivant, comme je l’ai fait. ");
INSERT INTO francl_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Désormais, tant que la terre durera, les semailles et la moisson, le froid et le chaud, l’été et l’hiver, le jour et la nuit ne cesseront point. » ");
INSERT INTO francl_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Dieu bénit Noé et ses fils et leur dit : « Soyez féconds, multipliez et remplissez la terre. ");
INSERT INTO francl_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Vous serez craints et redoutés de toute bête de la terre, de tout oiseau du ciel, de tout ce qui se meut sur la terre et de tous les poissons de la mer : ils sont livrés entre vos mains. ");
INSERT INTO francl_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Tout ce qui se meut et qui a vie vous servira de nourriture ; je vous donne tout cela, comme je vous avais donné l’herbe verte. ");
INSERT INTO francl_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Seulement vous ne mangerez pas de chair avec son âme, c’est-à-dire avec son sang. ");
INSERT INTO francl_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Et votre sang à vous, j’en demanderai compte à cause de vos âmes, j’en demanderai compte à toute bête ; de la main de l’homme, de la main de l’homme qui est son frère, je redemanderai l’âme de l’homme. ");
INSERT INTO francl_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Quiconque aura versé le sang de l’homme, par l’homme son sang sera versé, car Dieu a fait l’homme à son image. ");
INSERT INTO francl_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Vous, soyez féconds et multipliez ; répandez-vous sur la terre et vous y multipliez. » ");
INSERT INTO francl_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Dieu dit encore à Noé et à ses fils avec lui : ");
INSERT INTO francl_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","« Et moi, je vais établir mon alliance avec vous et avec votre postérité après vous, ");
INSERT INTO francl_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","avec tous les êtres vivants qui sont avec vous, oiseaux, animaux domestiques et toutes les bêtes de la terre avec vous, depuis tous ceux qui sont sortis de l’arche jusqu’à toute bête de la terre. ");
INSERT INTO francl_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","J’établis mon alliance avec vous : aucune chair ne sera plus détruite par les eaux du déluge, et il n’y aura plus de déluge pour ravager la terre. » ");
INSERT INTO francl_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Et Dieu dit : « Voici le signe de l’alliance que je mets entre moi et vous, et tous les êtres vivants qui sont avec vous, pour toutes les générations à venir. ");
INSERT INTO francl_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","J’ai mis mon arc dans la nue, et il deviendra signe d’alliance entre moi et la terre. ");
INSERT INTO francl_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Quand j’assemblerai des nuées au-dessus de la terre, l’arc apparaîtra dans la nue, ");
INSERT INTO francl_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","et je me souviendrai de mon alliance entre moi et vous et tout être vivant, de toute chair, et les eaux ne deviendront plus un déluge détruisant toute chair. ");
INSERT INTO francl_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","L’arc sera dans la nue et, en le regardant, je me souviendrai de l’alliance éternelle qui existe entre Dieu et tous les êtres vivants, de toute chair, qui sont sur la terre. » ");
INSERT INTO francl_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Et Dieu dit à Noé : « Tel est le signe de l’alliance que j’ai établie entre moi et toute chair qui est sur la terre. » ");
INSERT INTO francl_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Les fils de Noé qui sortirent de l’arche étaient Sem, Cham et Japheth ; et Cham était père de Canaan. ");
INSERT INTO francl_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Ces trois sont les fils de Noé, et c’est par eux que fut peuplée toute la terre. ");
INSERT INTO francl_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noé, qui était cultivateur, commença à planter de la vigne. ");
INSERT INTO francl_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Ayant bu du vin, il s’enivra, et il se découvrit au milieu de sa tente. ");
INSERT INTO francl_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Cham, père de Canaan, vit la nudité de son père, et il alla le rapporter dehors à ses deux frères. ");
INSERT INTO francl_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Alors Sem avec Japheth prit le manteau de Noé et, l’ayant mis sur leurs épaules, ils marchèrent à reculons et couvrirent la nudité de leur père. ");
INSERT INTO francl_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Comme leur visage était tourné en arrière, ils ne virent pas la nudité de leur père. Lorsque Noé se réveilla de son ivresse, il apprit ce que lui avait fait son plus jeune fils, ");
INSERT INTO francl_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","et il dit : Maudit soit Canaan ! Il sera pour ses frères le serviteur des serviteurs ! ");
INSERT INTO francl_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Puis il dit : Béni soit Yahweh, Dieu de Sem, et que Canaan soit son serviteur ! ");
INSERT INTO francl_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Que Dieu donne de l’espace à Japheth, qu’il habite dans les tentes de Sem, et que Canaan soit son serviteur ! ");
INSERT INTO francl_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Noé vécut après le déluge trois cent cinquante ans. ");
INSERT INTO francl_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Tous les jours de Noé furent de neuf cent cinquante ans, et il mourut. ");
INSERT INTO francl_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Voici la postérité des fils de Noé, Sem, Cham et Japheth. Il leur naquit des fils après le déluge. ");
INSERT INTO francl_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Fils de Japheth : Gomer, Magog, Madaï, Javan, Thubal, Mosoch et Tiras. ");
INSERT INTO francl_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Fils de Gomer : Ascénez, Riphath et Thogorma. — ");
INSERT INTO francl_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Fils de Javan : Elisa et Tharsis, Cetthim et Dodanim. ");
INSERT INTO francl_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","C’est d’eux que viennent les peuples dispersés dans les îles des nations, dans leurs divers pays, chacun selon sa langue, selon leurs familles, selon leurs nations. ");
INSERT INTO francl_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Fils de Cham : Chus, Mesraïm, Phuth et Canaan. — ");
INSERT INTO francl_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Fils de Chus : Saba, Hévila, Sabatha, Regma et Sabathaca. Fils de Regma : Saba et Dadan. ");
INSERT INTO francl_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Chus engendra Nemrod : celui-ci fut le premier un homme puissant sur la terre. ");
INSERT INTO francl_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Ce fut un vaillant chasseur devant Yahweh ; c’est pourquoi l’on dit : « Comme Nemrod, vaillant chasseur devant Yahweh. » ");
INSERT INTO francl_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Le commencement de son empire fut Babel, Arach, Achad et Chalanné au pays de Sennaar. ");
INSERT INTO francl_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","De ce pays il alla en Assur, et bâtit Ninive, Rechoboth-Ir, Chalé, ");
INSERT INTO francl_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","et Résen, entre Ninive et Chalé ; c’est la grande ville. — ");
INSERT INTO francl_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Mesraïm engendra les Ludim, les Anamim, les Laabim, les Nephthuim, ");
INSERT INTO francl_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","les Phétrusim, les Chasluim, d’où sont sortis les Philistins, et les Caphtorim. — ");
INSERT INTO francl_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Canaan engendra Sidon, son premier-né, et Heth, ");
INSERT INTO francl_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","ainsi que les Jébuséens, les Amorrhéens, les Gergéséens, ");
INSERT INTO francl_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","les Hévéens, les Aracéens, les Sinéens, ");
INSERT INTO francl_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","les Aradiens, les Samaréens et les Hamathéens. Ensuite les familles des Chananéens se répandirent dans le pays, ");
INSERT INTO francl_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","et le territoire des Chananéens alla depuis Sidon, dans la direction de Guérar, jusqu’à Gaza ; et, dans la direction de Sodome, Gomorrhe, Adama, et Séboïm, jusqu’à Lésa. — ");
INSERT INTO francl_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Tels sont les fils de Cham selon leurs familles, selon leurs langues, dans leurs divers pays, dans leurs nations. ");
INSERT INTO francl_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Des fils naquirent aussi à Sem, qui est le père de tous les fils d’Héber et le frère aîné de Japheth. ");
INSERT INTO francl_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Fils de Sem : Elam, Assur, Arphaxad, Lud et Aram. — ");
INSERT INTO francl_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Fils d’Aram : Us, Hul, Géther et Mes. — ");
INSERT INTO francl_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arphaxad engendra Salé, et Salé engendra Héber. ");
INSERT INTO francl_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Et il naquit à Héber deux fils : le nom de l’un était Phaleg, parce que de son temps la terre était partagée, et le nom de son frère était Jectan. ");
INSERT INTO francl_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Jectan engendra Elmodad, Saleph, Asarmoth, Jaré, ");
INSERT INTO francl_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Aduram, Uzal, Décla, ");
INSERT INTO francl_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Ebal, Abimaël, Saba, ");
INSERT INTO francl_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ophir, Hévila et Jobab. Tous ceux-là sont fils de Jectan. ");
INSERT INTO francl_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Le pays qu’ils habitèrent fut la montagne d’Orient, à partir de Mésa, dans la direction de Séphar. — ");
INSERT INTO francl_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Tels sont les fils de Sem, selon leurs familles, selon leurs langues, dans leurs divers pays, selon leurs nations. ");
INSERT INTO francl_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Telles sont les familles des fils de Noé selon leurs générations, dans leurs nations. C’est d’eux que sont sorties les nations qui se sont répandues sur la terre après le déluge. ");
INSERT INTO francl_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Toute la terre avait une seule langue et les mêmes mots. ");
INSERT INTO francl_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Etant partis de l’Orient, les hommes trouvèrent une plaine dans le pays de Sennaar, et ils s’y établirent. ");
INSERT INTO francl_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Ils se dirent entre eux : « Allons, faisons des briques, et cuisons-les au feu. » Et ils se servirent de briques au lieu de pierres, et de bitume au lieu de ciment. ");
INSERT INTO francl_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Ils dirent encore : « Allons, bâtissons-nous une ville et une tour dont le sommet soit dans le ciel, et faisons-nous un monument, de peur que nous ne soyons dispersés sur la face de toute la terre. » ");
INSERT INTO francl_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Mais Yahweh descendit pour voir la ville et la tour que bâtissaient les fils des hommes. ");
INSERT INTO francl_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Et Yahweh dit : « Voici, ils sont un seul peuple et ils ont pour eux tous une même langue ; et cet ouvrage est le commencement de leurs entreprises ; maintenant rien ne les empêchera d’accomplir leurs projets. ");
INSERT INTO francl_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Allons, descendons, et là même confondons leur langage, de sorte qu’ils n’entendent plus le langage les uns des autres. » ");
INSERT INTO francl_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","C’est ainsi que Yahweh les dispersa de là sur la face de toute la terre, et ils cessèrent de bâtir la ville. ");
INSERT INTO francl_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","C’est pourquoi on lui donna le nom de Babel, car c’est là que Yahweh confondit le langage de toute la terre, et c’est de là que Yahweh les a dispersés sur la face de toute la terre. ");
INSERT INTO francl_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Voici l’histoire de Sem : Sem, âgé de cent ans, engendra Arphaxad, deux ans après le déluge. ");
INSERT INTO francl_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Après qu’il eut engendré Arphaxad, Sem vécut cinq cents ans, et il engendra des fils et des filles. ");
INSERT INTO francl_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arphaxad vécut trente-cinq ans, et il engendra Salé. ");
INSERT INTO francl_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Après qu’il eut engendré Salé, Arphaxad vécut quatre cent trois ans, et il engendra des fils et des filles. ");
INSERT INTO francl_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Salé vécut trente ans, et il engendra Héber. ");
INSERT INTO francl_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Après qu’il eut engendré Héber, Salé vécut quatre cent trois ans, et il engendra des fils et des filles. ");
INSERT INTO francl_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Héber vécut trente-quatre ans, et il engendra Phaleg. ");
INSERT INTO francl_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Après qu’il eut engendré Phaleg, Héber vécut quatre cent trente ans, et il engendra des fils et des filles. ");
INSERT INTO francl_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Phaleg vécut trente ans, et il engendra Réü. ");
INSERT INTO francl_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Après qu’il eut engendré Réü, Phaleg vécut deux cent neuf ans, et il engendra des fils et des filles. ");
INSERT INTO francl_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Réü vécut trente-deux ans, et il engendra Sarug. ");
INSERT INTO francl_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Après qu’il eut engendré Sarug, Réü vécut deux cent sept ans, et il engendra des fils et des filles. ");
INSERT INTO francl_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Sarug vécut trente ans, et il engendra Nachor. ");
INSERT INTO francl_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Après qu’il eut engendré Nachor, Sarug vécut deux cents ans, et il engendra des fils et des filles. ");
INSERT INTO francl_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nachor vécut vingt-neuf ans, et il engendra Tharé. ");
INSERT INTO francl_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Après qu’il eut engendré Tharé, Nachor vécut cent dix-neuf ans, et il engendra des fils et des filles. ");
INSERT INTO francl_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Tharé vécut soixante-dix ans, et il engendra Abram, Nachor et Aran. ");
INSERT INTO francl_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Voici l’histoire de Tharé. Tharé engendra Abram, Nachor et Aran. Aran engendra Lot. ");
INSERT INTO francl_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Et Aran mourut en présence de Tharé, son père, au pays de sa naissance, à Ur en Chaldée. ");
INSERT INTO francl_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abram et Nachor prirent des femmes : le nom de la femme d’Abram était Saraï, et le nom de la femme de Nachor était Melcha, fille d’Aran, père de Melcha et père de Jesca. ");
INSERT INTO francl_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Or Saraï fut stérile : elle n’avait pas d’enfants. ");
INSERT INTO francl_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tharé prit Abram, son fils, et Lot, fils d’Aran, son petit-fils, et Saraï, sa belle-fille, femme d’Abram, son fils, et ils sortirent ensemble d’Ur des Chaldéens, pour aller au pays de Canaan ; mais, arrivés à Haran, ils s’y établirent. ");
INSERT INTO francl_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Les jours de Tharé furent de deux cent cinq ans, et Tharé mourut à Haran. ");
INSERT INTO francl_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Yahweh dit à Abram : « Va-t-en de ton pays, de ta famille et de la maison de ton père, dans le pays que je te montrerai. ");
INSERT INTO francl_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Je ferai de toi une grande nation, je te bénirai et je rendrai grand ton nom. Tu seras une bénédiction : ");
INSERT INTO francl_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Je bénirai ceux qui te béniront, et celui qui te maudira, je le maudirai, et toutes les familles de la terre seront bénies en toi. » ");
INSERT INTO francl_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Abram partit, comme Yahweh le lui avait dit, et Lot s’en alla avec lui. Abram avait soixante-quinze ans quand il sortit de Haran. ");
INSERT INTO francl_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abram prit Saraï, sa femme, et Lot, fils de son frère, ainsi que tous les biens qu’ils possédaient et les serviteurs qu’ils avaient acquis à Haran, et ils partirent pour aller au pays de Canaan. Et ils arrivèrent au pays de Canaan. ");
INSERT INTO francl_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abram traversa le pays jusqu’au lieu nommé Sichem, jusqu’au chêne de Moré. — Les Chananéens étaient alors dans le pays. — ");
INSERT INTO francl_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Yahweh apparut à Abram et lui dit : « je donnerai ce pays à ta postérité. » Et Abram bâtit là un autel à Yahweh qui lui était apparu. ");
INSERT INTO francl_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Il passa de là à la montagne, à l’orient de Béthel, et il dressa sa tente, ayant Béthel au couchant et Haï à l’orient. Là encore il bâtit un autel à Yahweh, et il invoqua le nom de Yahweh. ");
INSERT INTO francl_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Puis Abram s’avança, de campement en campement, vers le Midi. ");
INSERT INTO francl_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Il y eut une famine dans le pays, et Abram descendit en Égypte pour y séjourner ; car la famine était grande dans le pays. ");
INSERT INTO francl_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Comme il était près d’entrer en Égypte, il dit à Saraï, sa femme : « Voici, je sais que tu es une belle femme ; ");
INSERT INTO francl_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","quand les Egyptiens te verront, ils diront : C’est sa femme, et ils me tueront et te laisseront vivre. ");
INSERT INTO francl_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Dis donc que tu es ma sœur, afin que je sois bien traité à cause de toi, et qu’on me laisse la vie par égard pour toi. » ");
INSERT INTO francl_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Lorsque Abram fut arrivé en Égypte, les Egyptiens virent que sa femme était fort belle. ");
INSERT INTO francl_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Les grands de Pharaon, l’ayant vue, la vantèrent à Pharaon, et cette femme fut prise et emmenée dans la maison de Pharaon. ");
INSERT INTO francl_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Il traita bien Abram à cause d’elle, et Abram reçut des brebis, des bœufs, des ânes, des serviteurs et des servantes, des ânesses et des chameaux. ");
INSERT INTO francl_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Mais Yahweh frappa de grandes plaies Pharaon et sa maison, à cause de Saraï, femme d’Abram. ");
INSERT INTO francl_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Pharaon appela alors Abram et lui dit : « Qu’est-ce que tu m’as fait ? Pourquoi ne m’as-tu pas déclaré qu’elle était ta femme ? ");
INSERT INTO francl_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Pourquoi as-tu dit : C’est ma sœur ; de sorte que je l’ai prise pour femme ? Maintenant, voici ta femme ; prends-la et va-t’en ! » ");
INSERT INTO francl_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Et Pharaon, ayant donné des ordres à ses gens au sujet d’Abram, ils le renvoyèrent, lui et sa femme, et tout ce qui lui appartenait. ");
INSERT INTO francl_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Abram remonta d’Égypte vers le Midi, lui, sa femme et tout ce qui lui appartenait, et Lot avec lui. ");
INSERT INTO francl_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Or Abram était fort riche en troupeaux, en argent et en or. ");
INSERT INTO francl_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Puis il alla, de campement en campement, du Midi jusqu’à Béthel, jusqu’au lieu où il avait la première fois dressé sa tente, entre Béthel et Haï, ");
INSERT INTO francl_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","à l’endroit où était l’autel qu’il avait précédemment élevé. Et là Abram invoqua le nom de Yahweh. ");
INSERT INTO francl_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lot, qui voyageait avec Abram, avait aussi des brebis, des bœufs et des tentes, ");
INSERT INTO francl_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","et la contrée ne leur suffisait pas pour habiter ensemble ; car leurs biens étaient trop considérables pour qu’ils pussent demeurer ensemble. ");
INSERT INTO francl_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Il y eut une querelle entre les bergers des troupeaux d’Abram et les bergers des troupeaux de Lot. — Les Chananéens et les Phérézéens étaient alors établis dans le pays. — ");
INSERT INTO francl_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Abram dit à Lot : « Qu’il n’y ait pas, je te prie, de débat entre moi et toi, ni entre mes bergers et tes bergers ; car nous sommes des frères. ");
INSERT INTO francl_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Tout le pays n’est-il pas devant toi ? Sépare-toi donc de moi. Si tu vas à gauche, je prendrai la droite ; et si tu vas à droite, je prendrai la gauche. » ");
INSERT INTO francl_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lot, levant les yeux, vit toute la plaine du Jourdain qui était entièrement arrosée : c’était, avant que Yahweh eût détruit Sodome et Gomorrhe, comme le jardin de Yahweh, comme la terre d’Égypte du côté de Tsoar. ");
INSERT INTO francl_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Lot choisit pour lui toute la plaine du Jourdain, et il s’avança vers l’orient ; c’est ainsi qu’ils se séparèrent l’un de l’autre. ");
INSERT INTO francl_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram habitait dans le pays de Canaan, et Lot habitait dans les villes de la plaine, et il dressa ses tentes jusqu’à Sodome. ");
INSERT INTO francl_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Or les gens de Sodome étaient fort mauvais et grands pécheurs contre Yahweh. ");
INSERT INTO francl_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Yahweh dit à Abram, après que Lot se fut séparé de lui : « Lève les yeux et, du lieu où tu es, regarde vers le septentrion et vers le midi, vers l’orient, et vers le couchant : ");
INSERT INTO francl_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","tout le pays que tu vois, je le donnerai à toi et à ta postérité pour toujours. ");
INSERT INTO francl_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Je rendrai ta postérité nombreuse comme la poussière de la terre ; si l’on peut compter la poussière de la terre, on comptera aussi ta postérité. ");
INSERT INTO francl_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Lève-toi, parcours le pays en long et en large, car, je te le donnerai. » ");
INSERT INTO francl_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Abram leva ses tentes et vint habiter aux chênes de Mambré, qui sont en Hébron ; et il bâtit là un autel à Yahweh. ");
INSERT INTO francl_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Au temps d’Amraphel, roi de Sennaar, d’Arioch, roi d’Ellasar, de Chodorlahomor, roi d’Elam, et de Thadal, roi de Goïm, il arriva ");
INSERT INTO francl_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","qu’ils firent la guerre à Bara, roi de Sodome, à Bersa, roi de Gomorrhe, à Sennaab, roi d’Adama, à Séméber, roi de Séboïm, et au roi de Bala qui est Soar. ");
INSERT INTO francl_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Ces derniers s’assemblèrent tous dans la vallée de Siddim, qui est la mer Salée. ");
INSERT INTO francl_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Car, pendant douze ans, ils avaient été soumis à Chodorlahomor, et la treizième année ils s’étaient révoltés. ");
INSERT INTO francl_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Mais, la quatorzième année, Chodorlahomor se mit en marche avec les rois qui étaient avec lui, et ils battirent les Réphaïm à Astaroth-Carnaïm, les Zusim à Ham, les Emim dans la plaine de Cariathaïm ");
INSERT INTO francl_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","et les Horréens dans leur montagne de Séir, jusqu’à El-Pharan, qui est près du désert. ");
INSERT INTO francl_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Puis, s’en retournant, ils arrivèrent à la fontaine du Jugement, qui est Cadès, et ils battirent tout le pays des Amalécites, ainsi que les Amorrhéens qui habitaient à Asason-Thamar. ");
INSERT INTO francl_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Alors le roi de Sodome s’avança avec le roi de Gomorrhe, le roi d’Adama, le roi de Séboïm et le roi de Bala, qui est Soar, et ils se rangèrent en bataille contre eux dans la vallée de Siddim, ");
INSERT INTO francl_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","contre Chodorlahomor, roi d’Elam, Thadal, roi de Goïm, Amraphel, roi de Sennaar, et Arioch, roi d’Ellasar, quatre rois contre les cinq. ");
INSERT INTO francl_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Il y avait dans la vallée de Siddim de nombreux puits de bitume ; le roi de Sodome et celui de Gomorrhe prirent la fuite, et ils y tombèrent ; le reste s’enfuit dans la montagne. ");
INSERT INTO francl_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Les vainqueurs enlevèrent tous les biens de Sodome et de Gomorrhe et tous leurs vivres, et ils s’en allèrent. ");
INSERT INTO francl_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Ils prirent aussi Lot, fils du frère d’Abram, et ses biens, et ils s’en allèrent ; or, il demeurait à Sodome. ");
INSERT INTO francl_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Un des fugitifs vint l’annoncer à Abram l’Hébreu, qui habitait aux chênes de Mambré, l’Amorrhéen, frère d’Eschol et frère d’Aner ; ils étaient des alliés d’Abram. ");
INSERT INTO francl_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Dès qu’Abram apprit que son frère avait été emmené captif, il mit sur pied ses gens les mieux éprouvés, nés dans sa maison, au nombre de trois cent dix-huit, et il poursuivit les rois jusqu’à Dan. ");
INSERT INTO francl_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Là, ayant partagé sa troupe pour les attaquer de nuit, lui et ses serviteurs, il les battit et les poursuivit jusqu’à Hoba, qui est à gauche de Damas. ");
INSERT INTO francl_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Il ramena tous les biens ; il ramena aussi Lot, son frère, et ses biens, ainsi que les femmes et les gens. ");
INSERT INTO francl_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Comme Abram revenait vainqueur de Chodorlahomor et des rois qui étaient avec lui, le roi de Sodome sortit à sa rencontre, dans la vallée de Savé ; c’est la vallée du Roi. ");
INSERT INTO francl_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Melchisédech, roi de Salem, apporta du pain et du vin ; il était prêtre du Dieu Très-Haut. ");
INSERT INTO francl_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Il bénit Abram et dit : « Béni soit Abram par le Dieu Très-Haut, qui a créé le ciel et la terre ! ");
INSERT INTO francl_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Béni soit le Dieu Très-Haut, qui a livré tes ennemis entre tes mains ! » Et Abram lui donna la dîme de tout. ");
INSERT INTO francl_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Le roi de Sodome dit à Abram : « Donne-moi les personnes et prends pour toi les biens. » ");
INSERT INTO francl_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Abram répondit au roi de Sodome : « J’ai levé la main vers Yahweh, le Dieu Très-Haut, qui a créé le ciel et la terre : ");
INSERT INTO francl_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","D’un fil à une courroie de sandale, je ne prendrai quoi que ce soit qui t’appartienne ! afin que tu ne dises pas : J’ai enrichi Abram. ");
INSERT INTO francl_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Rien pour moi ! Ce qu’ont mangé les jeunes gens et la part des hommes qui sont venus avec moi, Aner, Eschol et Mambré, eux, ils prendront leur part. » ");
INSERT INTO francl_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Après ces événements, la parole de Yahweh fut adressée à Abram en vision : « Ne crains point, Abram ; je suis ton bouclier ; ta récompense sera très grande. » ");
INSERT INTO francl_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Abram répondit : « Seigneur Yahweh, que me donnerez-vous ? Je m’en vais sans enfants, et l’héritier de ma maison, c’est Eliézer de Damas. » ");
INSERT INTO francl_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Et Abram dit : « Voici, vous ne m’avez pas donné de postérité, et un homme attaché à ma maison sera mon héritier. » ");
INSERT INTO francl_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Alors la parole de Yahweh lui fut adressée en ces termes : « Ce n’est pas lui qui sera ton héritier, mais celui qui sortira de tes entrailles sera ton héritier. » ");
INSERT INTO francl_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Et, l’ayant conduit dehors, il dit : « Lève ton regard vers le ciel et compte les étoiles, si tu peux les compter. » Et il lui dit : « Telle sera ta postérité. » ");
INSERT INTO francl_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abram eut foi à Yahweh, et Yahweh le lui imputa à justice. ");
INSERT INTO francl_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Et il lui dit : « Je suis Yahweh, qui t’ai fait sortir d’Ur des Chaldéens, afin de te donner ce pays pour le posséder. » ");
INSERT INTO francl_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Abram répondit : « Seigneur Yahweh, à quoi connaîtrai-je que je le posséderai ? » ");
INSERT INTO francl_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Et Yahweh lui dit : « Prends une génisse de trois ans, une chèvre de trois ans, un bélier de trois ans, une tourterelle et un jeune pigeon. » ");
INSERT INTO francl_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Abram lui amena tous ces animaux et, les ayant partagés par le milieu, il mit chaque moitié vis-à-vis de l’autre ; mais il ne partagea pas les oiseaux. ");
INSERT INTO francl_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Les oiseaux de proie s’abattirent sur les cadavres, et Abram les chassa. ");
INSERT INTO francl_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Comme le soleil se couchait, un profond sommeil tomba sur Abram ; une terreur, une obscurité profonde tombèrent sur lui. ");
INSERT INTO francl_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Yahweh dit à Abram : « Sache bien que tes descendants seront étrangers dans un pays qui ne sera pas à eux ; ils y seront en servitude et on les opprimera pendant quatre cents ans. ");
INSERT INTO francl_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Mais je jugerai la nation à laquelle ils auront été asservis, et ensuite ils sortiront avec de grands biens. ");
INSERT INTO francl_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Toi, tu t’en iras en paix vers tes pères ; tu seras mis en terre dans une heureuse vieillesse. ");
INSERT INTO francl_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","A la quatrième génération ils reviendront ici ; car jusqu’à présent l’iniquité de l’Amorrhéen n’est pas à son comble. » ");
INSERT INTO francl_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Lorsque le soleil fut couché et qu’une profonde obscurité fut venue, voici qu’un four fumant et un brandon de feu passaient entre les animaux partagés. ");
INSERT INTO francl_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","En ce jour-là, Yahweh fit alliance avec Abram, en disant : « Je donne à ta postérité ce pays, depuis le fleuve d’Égypte jusqu’au grand fleuve, au fleuve de l’Euphrate : ");
INSERT INTO francl_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","le pays des Cinéens, des Cénézéens, des Cadmonéens, ");
INSERT INTO francl_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","des Hittites, des Phéréséens, des Rephaïm, ");
INSERT INTO francl_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","des Amorrhéens, des Chananéens, des Gergéséens et des Jébuséens. ");
INSERT INTO francl_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Saraï, femme d’Abram, ne lui avait pas donné d’enfants ; et elle avait une servante égyptienne, nommée Agar. ");
INSERT INTO francl_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Saraï dit à Abram : « Voici que Yahweh m’a rendue stérile ; viens, je te prie, vers ma servante ; peut-être aurai-je d’elle des fils. » Abram écouta la voix de Saraï. ");
INSERT INTO francl_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Saraï, femme d’Abram, prit donc Agar l’Egyptienne, sa servante, après qu’Abram eut habité dix années dans le pays de Canaan, et elle la donna à Abram, son mari, pour être sa femme. ");
INSERT INTO francl_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Il alla vers Agar, et elle conçut ; et quand elle vit qu’elle avait conçu, elle regarda sa maîtresse avec mépris. ");
INSERT INTO francl_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Saraï dit à Abram : « L’outrage qui m’est fait tombe sur toi. J’ai mis ma servante dans ton sein et, quand elle a vu qu’elle avait conçu, elle m’a regardée avec mépris. Que Yahweh juge entre moi et toi ! » ");
INSERT INTO francl_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Abram répondit à Saraï : « Voici, ta servante est sous ta puissance ; agis à son égard comme bon te semblera. » Alors Saraï la maltraita, et Agar s’enfuit de devant elle. ");
INSERT INTO francl_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","L’ange de Yahweh la trouva près d’une source d’eau dans le désert, près de la source qui est sur le chemin de Sur. ");
INSERT INTO francl_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Il dit : « Agar, servante de Saraï, d’où viens-tu et où vas-tu ? » Elle répondit : « Je fuis loin de Saraï, ma maîtresse. » ");
INSERT INTO francl_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","L’ange de Yahweh lui dit : « Retourne vers ta maîtresse et humilie-toi sous sa main. » ");
INSERT INTO francl_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","L’ange de Yahweh ajouta : « Je multiplierai extrêmement ta postérité ; on ne pourra la compter, tant elle sera nombreuse. » ");
INSERT INTO francl_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","L’ange de Yahweh lui dit encore : « Voici que tu es enceinte, et tu enfanteras un fils, et tu lui donneras le nom d’Ismaël, parce que Yahweh a entendu ton affliction. ");
INSERT INTO francl_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Ce sera un âne sauvage que cet homme ; sa main sera contre tous, et la main de tous sera contre lui, et il habitera en face de tous ses frères. » ");
INSERT INTO francl_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Agar donna à Yahweh qui lui avait parlé le nom de Atta-El-Roï car elle avait dit : « Ai-je donc ici même vu le Dieu qui me voyait ? » ");
INSERT INTO francl_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","C’est pourquoi on a appelé ce puits le puits Lachaï-Roï. Il est situé entre Cadès et Barad. ");
INSERT INTO francl_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Agar enfanta un fils à Abram, et Abram donna le nom d’Ismaël au fils qu’Agar avait mis au monde. ");
INSERT INTO francl_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abram était âgé de quatre-vingt-six ans lorsqu’Agar enfanta Ismaël à Abram. ");
INSERT INTO francl_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Lorsque Abram fut arrivé à l’âge de quatre-vingt-dix-neuf ans, Yahweh lui apparut et lui dit : « Je suis le Dieu tout-puissant ; marche devant ma face et sois irréprochable : ");
INSERT INTO francl_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","j’établirai mon alliance entre moi et toi, et je te multiplierai à l’infini. » ");
INSERT INTO francl_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Abram tomba la face contre terre, et Dieu lui parla ainsi : ");
INSERT INTO francl_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","« Moi, voici mon alliance avec toi : tu deviendras père d’une multitude de nations. ");
INSERT INTO francl_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","On ne te nommera plus Abram, mais ton nom sera Abraham, car je te fais père d’une multitude de nations. ");
INSERT INTO francl_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Je te ferai croître extraordinairement, je ferai de toi des nations, et des rois sortiront de toi. ");
INSERT INTO francl_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","J’établis mon alliance, entre moi et toi et tes descendants après toi, d’âge en âge, en une alliance perpétuelle, pour être ton Dieu et le Dieu de tes descendants après toi. ");
INSERT INTO francl_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Je te donnerai, à toi et à tes descendants après toi, le pays où tu séjournes comme étranger, tout le pays de Canaan, en possession perpétuelle, et je serai leur Dieu ». ");
INSERT INTO francl_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Dieu dit à Abraham : « Et toi, tu garderas mon alliance, toi et tes descendants après toi, d’âge en âge. ");
INSERT INTO francl_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Voici l’alliance que vous avez à garder, l’alliance entre moi et vous, et tes descendants après toi : tout mâle parmi vous sera circoncis. ");
INSERT INTO francl_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Vous vous circoncirez dans votre chair, et ce sera le signe de l’alliance entre moi et vous. ");
INSERT INTO francl_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Quand il aura huit jours, tout mâle parmi vous, d’âge en âge, sera circoncis, qu’il soit né dans la maison, ou qu’il ait été acquis à prix d’argent d’un étranger quelconque, qui n’est pas de ta race. ");
INSERT INTO francl_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","On devra circoncire le mâle né dans la maison ou acquis à prix d’argent, et mon alliance sera dans votre chair comme alliance perpétuelle. ");
INSERT INTO francl_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Un mâle incirconcis, qui n’aura pas été circoncis dans sa chair, sera retranché de son peuple : il aura violé mon alliance. » ");
INSERT INTO francl_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Dieu dit à Abraham : « Tu ne donneras plus à Saraï, ta femme, le nom de Saraï, car son nom est Sara. ");
INSERT INTO francl_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Je la bénirai, et je te donnerai aussi d’elle un fils ; je la bénirai, et elle deviendra des nations ; des rois de peuples sortiront d’elle. » ");
INSERT INTO francl_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Abraham tomba la face contre terre, et il rit, disant dans son cœur : « Naîtra-t-il un fils à un homme de cent ans ? Et Sara, une femme de quatre-vingt-dix ans, enfantera-t-elle ? » ");
INSERT INTO francl_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Et Abraham dit à Dieu : « Oh ! qu’Ismaël vive devant votre face ! » ");
INSERT INTO francl_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Dieu dit : « Oui, Sara, ta femme, t’enfantera un fils ; tu le nommeras Isaac, et j’établirai mon alliance avec lui comme une alliance perpétuelle pour ses descendants après lui. ");
INSERT INTO francl_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Quant à Ismaël, je t’ai entendu. Voici, je l’ai béni, je le rendrai fécond et je le multiplierai extrêmement ; il engendrera douze princes, et je ferai de lui une grande nation. ");
INSERT INTO francl_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Mais mon alliance, je l’établirai avec Isaac, que Sara t’enfantera l’année prochaine, à cette époque. » ");
INSERT INTO francl_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Et ayant achevé de parler avec lui, Dieu remonta d’auprès d’Abraham. ");
INSERT INTO francl_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Abraham prit Ismaël, son fils, ainsi que tous les serviteurs nés dans sa maison et tous ceux qu’il avait acquis à prix d’argent, tous les mâles parmi les gens de sa maison, et il les circoncit en ce jour même, comme Dieu le lui avait commandé. ");
INSERT INTO francl_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abraham était âgé de quatre-vingt-dix-neuf ans lorsqu’il fut circoncis ; ");
INSERT INTO francl_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","et Ismaël, son fils, avait treize ans lorsqu’il fut circoncis. ");
INSERT INTO francl_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Ce même jour, Abraham fut circoncis, ainsi qu’Ismaël, son fils ; ");
INSERT INTO francl_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","et tous les hommes de sa maison, ceux qui étaient nés chez lui et ceux qui avaient été acquis des étrangers à prix d’argent, furent circoncis avec lui. ");
INSERT INTO francl_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Yahweh lui apparut aux chênes de Mambré, comme il était assis à l’entrée de la tente pendant la chaleur du jour. ");
INSERT INTO francl_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Il leva les yeux et il regarda, et voici que trois hommes se tenaient debout devant lui. Dès qu’il les vit, il courut de l’entrée de la tente au-devant d’eux et, s’étant prosterné en terre, ");
INSERT INTO francl_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","il dit : « Seigneur, si j’ai trouvé grâce à tes yeux, ne passe pas, je te prie, loin de ton serviteur. ");
INSERT INTO francl_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Permettez qu’on apporte un peu d’eau pour vous laver les pieds. Reposez-vous sous cet arbre ; ");
INSERT INTO francl_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","je vais prendre un morceau de pain, vous fortifierez votre cœur et vous continuerez votre chemin ; car c’est pour cela que vous avez passé devant votre serviteur. » Ils répondirent : « Fais comme tu l’as dit. » ");
INSERT INTO francl_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Abraham s’empressa de revenir dans la tente vers Sara, et il dit : « Vite, trois mesures de farine ; pétris et fais des gâteaux. » ");
INSERT INTO francl_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Puis Abraham courut au troupeau et, ayant pris un veau tendre et bon, il le donna au serviteur qui se hâta de l’apprêter. ");
INSERT INTO francl_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Il prit aussi du beurre et du lait, avec le veau qu’on avait apprêté, et il les mit devant eux ; lui se tenait debout près d’eux sous l’arbre. Et ils mangèrent. ");
INSERT INTO francl_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Alors ils lui dirent : « Où est Sara, ta femme ? » Il répondit : « Elle est là, dans la tente. » ");
INSERT INTO francl_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Et il dit : « Je reviendrai chez toi à cette époque même, et voici, Sara, ta femme, aura un fils. » Sara entendait ces paroles à l’entrée de la tente, derrière lui. ");
INSERT INTO francl_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","— Or Abraham et Sara étaient vieux, avancés en jours ; Sara était hors d’âge. — ");
INSERT INTO francl_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Sara rit en elle-même, en se disant : « Vieille comme je suis, connaîtrais-je encore le plaisir ? Et mon seigneur aussi est vieux. » ");
INSERT INTO francl_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Yahweh dit à Abraham : « Pourquoi Sara a-t-elle ri en disant : Est-ce que vraiment j’aurais un enfant, vieille comme je suis ? ");
INSERT INTO francl_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Y a-t-il rien qui soit étonnant de la part de Yahweh ? Au temps fixé, je reviendrai vers toi, à cette même saison, et Sara aura un fils. » ");
INSERT INTO francl_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sara nia, en disant : « Je n’ai pas ri    » ; car elle eut peur. Mais il lui dit : « Non, tu as ri. » ");
INSERT INTO francl_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Ces hommes se levèrent pour partir et se tournèrent du côté de Sodome ; Abraham allait avec eux pour les accompagner. ");
INSERT INTO francl_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Alors Yahweh dit : « Cacherai-je à Abraham ce que je vais faire ? ");
INSERT INTO francl_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Car Abraham doit devenir une nation grande et forte, et toutes les nations de la terre seront bénies en lui. ");
INSERT INTO francl_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Je l’ai choisi, en effet, afin qu’il ordonne à ses fils et à sa maison après lui de garder la voie de Yahweh, en pratiquant l’équité et la justice, et qu’ainsi Yahweh accomplisse en faveur d’Abraham les promesses qu’il lui a faites. » ");
INSERT INTO francl_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Et Yahweh dit : « Le cri qui s’élève de Sodome et de Gomorrhe est bien fort, et leur péché bien énorme. ");
INSERT INTO francl_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Je veux descendre et voir si, selon le cri qui est venu jusqu’à moi, leur crime est arrivé au comble ; et s’il n’en est pas ainsi, je le saurai. » ");
INSERT INTO francl_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Les hommes partirent et s’en allèrent vers Sodome ; et Abraham se tenait encore devant Yahweh. ");
INSERT INTO francl_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Abraham s’approcha et dit : « Est-ce que vous feriez périr aussi le juste avec le coupable ? ");
INSERT INTO francl_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Peut-être y a-t-il cinquante justes dans la ville : les feriez-vous périr aussi, et ne pardonnerez-vous pas à cette ville à cause des cinquante justes qui s’y trouveraient ? ");
INSERT INTO francl_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Loin de vous d’agir de la sorte, de faire mourir le juste avec le coupable ! Ainsi il en serait du juste comme du coupable ! Loin de vous ! Celui qui juge toute la terre ne rendrait-il pas justice ? » ");
INSERT INTO francl_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Yahweh dit : « Si je trouve à Sodome cinquante justes dans la ville, je pardonnerai à toute la ville à cause d’eux. » ");
INSERT INTO francl_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Abraham reprit et dit : « Voilà que j’ai osé parler au Seigneur, moi qui suis poussière et cendre. ");
INSERT INTO francl_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Peut-être que des cinquante justes il en manquera cinq ; pour cinq hommes détruirez-vous toute la ville ? » Il dit : « Je ne la détruirai pas, si j’en trouve quarante-cinq. » ");
INSERT INTO francl_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Abraham continua encore à lui parler et dit : « Peut-être s’y trouvera-t-il quarante justes. » Et il dit : « Je ne le ferai pas, à cause de ces quarante. » ");
INSERT INTO francl_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Abraham dit : « Que le Seigneur veuille ne pas s’irriter, si je parle ! Peut-être s’en trouvera-t-il trente. » Et il dit : « Je ne le ferai pas, si j’en trouve trente. » ");
INSERT INTO francl_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Abraham dit : « Voilà que j’ai osé parler au Seigneur. Peut-être s’en trouvera-t-il vingt. » Et il dit : « A cause de ces vingt, je ne la détruirai pas. » ");
INSERT INTO francl_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Abraham dit : « Que le Seigneur veuille ne pas s’irriter, et je ne parlerai plus que cette fois : Peut-être s’en trouvera-t-il dix. » Et il dit : « A cause de ces dix, je ne la détruirai point. » ");
INSERT INTO francl_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Yahweh s’en alla, lorsqu’il eut achevé de parler à Abraham, et Abraham retourna chez lui. ");
INSERT INTO francl_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Les deux anges arrivèrent à Sodome le soir, et Lot était assis à la porte de Sodome. En les voyant, Lot se leva pour aller au-devant d’eux et il se prosterna le visage contre terre, ");
INSERT INTO francl_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","et il dit : « Voici, mes seigneurs, entrez, je vous prie, chez votre serviteur pour y passer la nuit ; lavez vos pieds ; vous vous lèverez de bon matin et vous poursuivrez votre route. » Ils répondirent : « Non, nous passerons la nuit sur la place. » ");
INSERT INTO francl_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Mais Lot leur fit tant d’instances qu’ils vinrent chez lui et entrèrent dans sa maison. Il leur prépara un festin et fit cuire des pains sans levain ; et ils mangèrent. ");
INSERT INTO francl_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Ils n’étaient pas encore couchés que les hommes de la ville, les hommes de Sodome, entourèrent la maison, depuis les enfants jusqu’aux vieillards, le peuple entier, de tous les bouts de la ville. ");
INSERT INTO francl_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Ils appelèrent Lot et lui dirent : « Où sont les hommes qui sont entrés chez toi cette nuit ? Fais-les sortir vers nous, pour que nous les connaissions. » ");
INSERT INTO francl_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lot s’avança vers eux à l’entrée de la maison et, ayant fermé la porte derrière lui, ");
INSERT INTO francl_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","il dit : « Non, mes frères, je vous en prie, ne faites pas le mal ! ");
INSERT INTO francl_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Voici, j’ai deux filles qui n’ont pas connu d’homme ; laissez-moi vous les amener, et vous leur ferez ce qu’il vous plaira. Mais ne faites rien à ces hommes, car c’est pour cela qu’ils sont venus s’abriter sous mon toit. » ");
INSERT INTO francl_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Ils répondirent : « Ote-toi de là ! » Et ils ajoutèrent : « Cet individu est venu comme étranger, et il fait le juge ! Eh bien, nous te ferons plus de mal qu’à eux. » Et, repoussant Lot avec violence, ils s’avancèrent pour briser la porte. ");
INSERT INTO francl_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Les deux hommes étendirent la main et, ayant retiré Lot vers eux dans la maison, ils fermèrent la porte. ");
INSERT INTO francl_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Et ils frappèrent d’aveuglement les gens qui étaient à l’entrée de la maison, depuis le plus petit jusqu’au plus grand, et ceux-ci se fatiguèrent inutilement à chercher la porte. ");
INSERT INTO francl_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Les deux hommes dirent à Lot : « Qui as-tu encore ici ? Gendres, fils et filles, et qui que ce soit que tu aies dans la ville, fais-les sortir de ce lieu. ");
INSERT INTO francl_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Car nous allons détruire ce lieu, parce qu’un grand cri s’est élevé de ses habitants devant Yahweh, et que Yahweh nous a envoyés pour le détruire. » ");
INSERT INTO francl_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Lot sortit et parla à ses gendres, qui avaient pris ses filles : « Levez-vous, leur dit-il, sortez de ce lieu, car Yahweh va détruire la ville. » Mais, aux yeux de ses gendres, il parut plaisanter. ");
INSERT INTO francl_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Dès l’aube du jour, les anges pressèrent Lot, en disant : « Lève-toi, prends ta femme et tes deux filles qui sont ici, afin que tu ne périsses pas dans le châtiment de la ville. » ");
INSERT INTO francl_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Comme il tardait, ces hommes le prirent par la main, lui, sa femme et ses deux filles, car Yahweh voulait l’épargner ; ils l’emmenèrent et le mirent hors de la ville. ");
INSERT INTO francl_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Lorsqu’ils les eurent fait sortir, l’un des anges dit : « Sauve-toi, sur ta vie. Ne regarde pas derrière toi, et ne t’arrête nulle part dans la Plaine ; sauve-toi à la montagne, de peur que tu ne périsses. » ");
INSERT INTO francl_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Lot leur dit : « Non, Seigneur. ");
INSERT INTO francl_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Voici votre serviteur a trouvé grâce à vos yeux, et vous avez fait un grand acte de bonté à mon égard en me conservant la vie ; mais je ne puis me sauver à la montagne, sans risquer d’être atteint par la destruction et de périr. ");
INSERT INTO francl_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Voyez, cette ville est assez proche pour m’y réfugier, et elle est peu de chose ; permettez que je m’y sauve, — n’est-elle pas petite ? — et que je vive. » ");
INSERT INTO francl_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Il lui dit : « Voici, je t’accorde encore cette grâce, de ne pas détruire la ville dont tu parles. ");
INSERT INTO francl_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Hâte-toi de t’y sauver, car je ne puis rien faire que tu n’y sois arrivé. » C’est pour cela qu’on a donné à cette ville le nom de Soar. ");
INSERT INTO francl_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Le soleil se leva sur la terre, et Lot arriva à Soar. ");
INSERT INTO francl_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Alors Yahweh fit pleuvoir sur Sodome et sur Gomorrhe du soufre et du feu d’auprès de Yahweh, du ciel. ");
INSERT INTO francl_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Il détruisit ces villes et toute la Plaine, et tous les habitants des villes et les plantes de la terre. ");
INSERT INTO francl_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","La femme de Lot regarda en arrière et devint une colonne de sel. ");
INSERT INTO francl_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Abraham se leva de bon matin et se rendit au lieu où il s’était tenu devant Yahweh. ");
INSERT INTO francl_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Il regarda du côté de Sodome et de Gomorrhe, et sur toute l’étendue de la Plaine, et il vit monter de la terre une fumée, comme la fumée d’une fournaise. ");
INSERT INTO francl_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Lorsque Dieu détruisit les villes de la Plaine, il se souvint d’Abraham, et il fit échapper Lot au bouleversement, lorsqu’il bouleversa les villes où Lot habitait. ");
INSERT INTO francl_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lot monta de Soar et s’établit à la montagne, ayant avec lui ses deux filles, car il craignait de rester à Soar ; et il habitait dans une caverne avec ses deux filles. ");
INSERT INTO francl_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","L’aînée dit à la plus jeune : « Notre père est vieux, et il n’y a pas d’homme dans le pays pour venir vers nous, selon l’usage de tous les pays. ");
INSERT INTO francl_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Viens, faisons boire du vin à notre père et couchons avec lui, afin que nous conservions de notre père une postérité. » ");
INSERT INTO francl_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Elles firent donc boire du vin à leur père cette nuit-là, et l’aînée alla coucher avec son père, et il ne s’aperçut ni du coucher de sa fille ni de son lever. ");
INSERT INTO francl_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Le lendemain, l’aînée dit à la plus jeune : « Voici, j’ai couché la nuit dernière avec mon père ; faisons-lui boire du vin encore cette nuit, et va coucher avec lui afin que nous conservions de notre père une postérité ». ");
INSERT INTO francl_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Cette nuit-là encore elles firent boire du vin à leur père, et la cadette alla se coucher auprès de lui, et il ne s’aperçut ni de son coucher ni de son lever. ");
INSERT INTO francl_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Les deux filles de Lot devinrent enceintes de leur père. ");
INSERT INTO francl_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","L’aînée mit au monde un fils, qu’elle nomma Moab : c’est le père des Moabites, qui existent jusqu’à ce jour. ");
INSERT INTO francl_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","La cadette eut aussi un fils, qu’elle nomma Ben-Ammi : c’est le père des fils d’Ammon, qui existent jusqu’à ce jour. ");
INSERT INTO francl_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abraham partit de là pour la contrée du Midi ; il s’établit entre Cadès et Sur, et fit un séjour à Guérar. ");
INSERT INTO francl_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Abraham disait de Sara, sa femme : « C’est ma sœur. » Abimélek, roi de Guérar, envoya prendre Sara. ");
INSERT INTO francl_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Mais Dieu vint à Abimélek en songe pendant la nuit, et lui dit : « Voici, tu vas mourir à cause de la femme que tu as prise : car elle a un mari. » ");
INSERT INTO francl_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Or Abimélek ne s’était pas approché d’elle ; il répondit : « Seigneur, ferez-vous mourir des gens même innocents ? ");
INSERT INTO francl_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Ne m’a-t-il pas dit : C’est ma sœur ? Et elle-même m’a dit aussi : C’est mon frère. C’est avec un cœur intègre et des mains pures que j’ai fait cela. » ");
INSERT INTO francl_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Dieu lui dit en songe : « Moi aussi, je sais que c’est avec un cœur intègre que tu as agi ; aussi t’ai-je retenu de pécher contre moi. C’est pourquoi je n’ai pas permis que tu la touches. ");
INSERT INTO francl_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Maintenant, rends la femme de cet homme, car il est prophète ; il priera pour toi, et tu vivras. Si tu ne la rends pas, sache que tu mourras certainement, toi et tous ceux qui t’appartiennent. » ");
INSERT INTO francl_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Abimélek se leva de bon matin, appela tous ses serviteurs et leur rapporta toutes ces choses ; et ces gens furent saisis d’une grande frayeur. ");
INSERT INTO francl_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Puis Abimélek appela Abraham et lui dit : « Qu’est-ce que tu nous as fait ? En quoi ai-je manqué à ton égard, que tu aies fait venir sur moi et sur mon royaume un si grand péché ? Tu as fait avec moi des choses qui ne se font pas. » ");
INSERT INTO francl_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Abimélek dit encore à Abraham : « A quoi as-tu pensé en agissant de la sorte ? » ");
INSERT INTO francl_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abraham répondit : « Je me disais : Il n’y a sans doute aucune crainte de Dieu dans ce pays, et l’on me tuera à cause de ma femme. ");
INSERT INTO francl_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Et d’ailleurs elle est vraiment ma sœur ; elle est fille de mon père, quoiqu’elle ne soit pas fille de ma mère, et elle est devenue ma femme. ");
INSERT INTO francl_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Lorsque Dieu me fit errer loin de la maison de mon père, je dis à Sara : Voici la grâce que tu me feras : dans tous les lieux où nous arriverons, dis de moi : C’est mon frère. » ");
INSERT INTO francl_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Alors Abimélek prit des brebis et des bœufs, des serviteurs et des servantes, et les donna à Abraham ; et il lui rendit Sara, sa femme. ");
INSERT INTO francl_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Abimélek dit : « Voici, mon pays est devant toi ; habite où il te plaira. » ");
INSERT INTO francl_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Et il dit à Sara : « Je donne à ton frère mille pièces d’argent ; cela te sera un voile sur les yeux pour tous ceux qui sont avec toi et pour tous ; te voilà justifiée. » ");
INSERT INTO francl_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Abraham intercéda auprès de Dieu, et Dieu guérit Abimélek, sa femme et ses servantes, et ils eurent des enfants. ");
INSERT INTO francl_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Car Yahweh avait rendu tout sein stérile dans la maison d’Abimélek, à cause de Sara, femme d’Abraham. ");
INSERT INTO francl_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Yahweh visita Sara, comme il l’avait dit ; Yahweh accomplit pour Sara ce qu’il avait promis. ");
INSERT INTO francl_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Sara conçut et enfanta à Abraham un fils dans sa vieillesse, au terme que Dieu lui avait marqué. ");
INSERT INTO francl_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Abraham donna au fils qui lui était né, que Sara lui avait enfanté, le nom d’Isaac. ");
INSERT INTO francl_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Et Abraham circoncit Isaac, son fils, à l’âge de huit jours, comme Dieu le lui avait ordonné. ");
INSERT INTO francl_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abraham avait cent ans à la naissance d’Isaac, son fils. ");
INSERT INTO francl_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Et Sara dit : « Dieu m’a donné de quoi rire ; quiconque l’apprendra rira à mon sujet. » ");
INSERT INTO francl_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Elle ajouta : « Qui eût dit à Abraham : Sara allaitera des enfants ? Car j’ai donné un fils à sa vieillesse. » ");
INSERT INTO francl_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","L’enfant grandit, et on le sevra. Abraham fit un grand festin le jour où Isaac fut sevré. ");
INSERT INTO francl_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Sara vit le fils d’Agar, l’Egyptienne, qu’elle avait enfanté à Abraham, qui riait, ");
INSERT INTO francl_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","et elle dit à Abraham : « Chasse cette servante et son fils ; car le fils de cette servante ne doit pas hériter avec mon fils, avec Isaac. » ");
INSERT INTO francl_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Cette parole déplut beaucoup aux yeux d’Abraham, à cause de son fils Ismaël. ");
INSERT INTO francl_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Mais Dieu dit à Abraham : « Que cela ne déplaise pas à tes yeux, à cause de l’enfant et de ta servante ; quoi que Sara te demande, consens-y, car c’est d’Isaac que naîtra la postérité qui portera ton nom. ");
INSERT INTO francl_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Néanmoins du fils de la servante je ferai aussi une nation, parce qu’il est né de toi. » ");
INSERT INTO francl_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Abraham s’étant levé de bon matin, prit du pain et une outre d’eau, les donna à Agar et les mit sur son épaule ; il lui remit aussi l’enfant, et il la renvoya. Elle s’en alla, errant dans le désert de Bersabée. ");
INSERT INTO francl_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Quand l’eau qui était dans l’outre fut épuisée, elle jeta l’enfant sous l’un des arbrisseaux, ");
INSERT INTO francl_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","et elle s’en alla s’asseoir vis-à-vis, à une portée d’arc ; car elle disait : « Je ne veux pas voir mourir l’enfant. » Elle s’assit donc vis-à-vis, éleva la voix et pleura. ");
INSERT INTO francl_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Dieu entendit la voix de l’enfant, et l’ange de Dieu appela du ciel Agar, en disant : « Qu’as-tu Agar ? Ne crains point, car Dieu a entendu la voix de l’enfant, dans le lieu où il est. ");
INSERT INTO francl_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Lève-toi, relève l’enfant, prends-le par la main, car je ferai de lui une grande nation. » ");
INSERT INTO francl_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Et Dieu lui ouvrit les yeux, et elle vit un puits d’eau ; elle alla remplir l’outre d’eau et donna à boire à l’enfant. ");
INSERT INTO francl_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Dieu fut avec l’enfant, et il grandit ; il habita dans le désert et devint un tireur d’arc. ");
INSERT INTO francl_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Il habitait dans le désert de Pharan, et sa mère prit pour lui une femme du pays d’Égypte. ");
INSERT INTO francl_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","En ce temps-là, Abimélek, accompagné de Phicol, chef de son armée, parla ainsi à Abraham : « Dieu est avec toi dans tout ce que tu fais. ");
INSERT INTO francl_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Jure-moi donc ici, par le nom de Dieu, que tu ne tromperas ni moi, ni mes enfants, ni mes petits-enfants, mais que tu auras pour moi et pour ce pays où tu séjournes la même bienveillance dont j’ai usé envers toi. » ");
INSERT INTO francl_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abraham dit : « Je le jurerai. » ");
INSERT INTO francl_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Mais Abraham fit des reproches à Abimélek au sujet d’un puits d’eau dont les serviteurs d’Abimélek s’étaient emparés de force. ");
INSERT INTO francl_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimélek répondit : « J’ignore qui a fait cela ; toi-même tu ne m’en as pas informé, et je n’en ai entendu parler qu’aujourd’hui. » ");
INSERT INTO francl_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Et Abraham prit des brebis et des bœufs, et les donna à Abimélek, et ils firent alliance tous deux. ");
INSERT INTO francl_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Abraham mit à part sept jeunes brebis du troupeau, ");
INSERT INTO francl_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","et Abimélek dit à Abraham : « Qu’est-ce que ces sept jeunes brebis, que tu as mises à part ? » ");
INSERT INTO francl_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Il répondit : « Tu accepteras de ma main ces sept jeunes brebis, afin que ce soit pour moi un témoignage que j’ai creusé ce puits. » ");
INSERT INTO francl_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","C’est pourquoi on a appelé ce lieu Bersabée, parce que c’est là qu’ils ont tous deux prêté serment. ");
INSERT INTO francl_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","C’est ainsi qu’ils firent alliance à Bersabée. Après quoi Abimélek se leva, avec Phicol, chef de son armée, et ils retournèrent au pays des Philistins. ");
INSERT INTO francl_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Abraham planta un tamaris à Bersabée, et il invoqua là le nom de Yahweh, Dieu éternel ; ");
INSERT INTO francl_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","et Abraham séjourna longtemps dans le pays des Philistins. ");
INSERT INTO francl_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Après cela, Dieu mit Abraham à l’épreuve et lui dit : « Abraham ! » Il répondit : « Me voici. » ");
INSERT INTO francl_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Et Dieu dit : « Prends ton fils, ton unique, celui que tu aimes, Isaac, et va-t’en au pays de Moria, et là offre-le en holocauste sur l’une des montagnes que je t’indiquerai. » ");
INSERT INTO francl_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Abraham se leva de bon matin et, ayant sellé son âne, il prit avec lui deux de ses serviteurs et son fils Isaac ; il fendit le bois de l’holocauste et partit pour aller au lieu que Dieu lui avait dit. ");
INSERT INTO francl_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Le troisième jour, Abraham, levant les yeux, aperçut le lieu de loin ; ");
INSERT INTO francl_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","et Abraham dit à ses serviteurs : « Restez ici avec l’âne ; moi et l’enfant, nous voulons aller jusque-là et adorer, puis nous reviendrons vers vous. » ");
INSERT INTO francl_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Et Abraham prit le bois de l’holocauste, et le mit sur Isaac, son fils, lui-même portait dans sa main le feu et le couteau, et ils s’en allèrent tous deux ensemble. ");
INSERT INTO francl_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Isaac parla à Abraham, son père, et dit : « Mon père ! » Il répondit : « Me voici, mon fils. » Et Isaac dit : « Voici le feu et le bois ; mais où est l’agneau pour l’holocauste ? » ");
INSERT INTO francl_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abraham répondit : « Dieu verra à trouver l’agneau pour l’holocauste, mon fils. » Et ils allaient tous deux ensemble. ");
INSERT INTO francl_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Lorsqu’ils furent arrivés au lieu que Dieu lui avait désigné, Abraham y éleva l’autel et arrangea le bois ; puis il lia Isaac, son fils, et le mit sur l’autel, au-dessus du bois. ");
INSERT INTO francl_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Et Abraham étendit la main et prit le couteau pour égorger son fils. ");
INSERT INTO francl_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Alors l’ange de Yahweh lui cria du ciel et dit : « Abraham ! Abraham ! » Il répondit : « Me voici. » ");
INSERT INTO francl_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Et l’ange dit : « Ne porte pas la main sur l’enfant et ne lui fais rien ; car je sais maintenant que tu crains Dieu et que tu ne m’as pas refusé ton fils, ton unique. » ");
INSERT INTO francl_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Abraham, ayant levé les yeux, vit derrière lui un bélier pris dans un buisson par les cornes ; et Abraham alla prendre le bélier et l’offrit en holocauste à la place de son fils. ");
INSERT INTO francl_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Et Abraham nomma ce lieu : «  Yahweh-Yiréh », d’où l’on dit aujourd’hui : « Sur la montagne de Yahweh, il sera vu. » ");
INSERT INTO francl_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","L’ange de Yahweh appela du ciel Abraham une seconde fois, en disant : ");
INSERT INTO francl_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","« Je l’ai juré par moi-même, dit Yahweh : parce que tu as fait cela, et que tu ne m’as pas refusé ton fils, ton unique, ");
INSERT INTO francl_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","je te bénirai ; je multiplierai ta postérité comme les étoiles du ciel et comme le sable qui est au bord de la mer, et ta postérité possédera la porte de ses ennemis. ");
INSERT INTO francl_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","En ta postérité seront bénies toutes les nations de la terre, parce que tu as obéi à ma voix. » ");
INSERT INTO francl_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Abraham retourna vers ses serviteurs et, s’étant levés, ils s’en allèrent ensemble à Bersabée. Et Abraham habita à Bersabée. ");
INSERT INTO francl_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Après ces événements, on apporta à Abraham cette nouvelle : « Voici, Melcha a aussi enfanté des fils à Nachor, ton frère : ");
INSERT INTO francl_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Hus, son premier-né, Buz, son frère, Camuel, père d’Aram, ");
INSERT INTO francl_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Cased, Azau, Pheldas, Jedlaph et Bathuel. » ");
INSERT INTO francl_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Bathuel fut père de Rébecca. Ce sont là les huit fils que Melcha enfanta à Nachor, frère d’Abraham. ");
INSERT INTO francl_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Sa concubine, nommée Roma, eut aussi des enfants : Tabée, Gaham, Taas et Maacha. ");
INSERT INTO francl_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sara vécut cent vingt-sept ans : telles sont les années de sa vie. ");
INSERT INTO francl_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Sara mourut à Qiriath-Arbé, qui est Hébron, dans le pays de Canaan ; et Abraham vint pour faire le deuil de Sara et pour la pleurer. ");
INSERT INTO francl_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Puis Abraham se leva de devant son mort, et parla ainsi aux fils de Heth : ");
INSERT INTO francl_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","« Je suis un étranger et un hôte parmi vous ; accordez-moi de posséder un sépulcre, afin que je puisse ôter de devant moi mon mort et l’enterrer. » ");
INSERT INTO francl_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Les fils de Heth répondirent à Abraham en lui disant : ");
INSERT INTO francl_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","« Ecoute-nous, mon seigneur ; tu es un prince de Dieu au milieu de nous ; enterre ton mort dans le plus beau de nos sépulcres ; aucun de nous ne te refusera son sépulcre pour y déposer ton mort. » ");
INSERT INTO francl_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Alors Abraham se leva et, se prosternant devant le peuple du pays, devant les fils de Heth, ");
INSERT INTO francl_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","il leur parla en ces termes : « Si vous voulez que j’ôte mon mort de devant moi pour l’enterrer, écoutez-moi et priez pour moi Ephron, fils de Séor, ");
INSERT INTO francl_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","de me céder la caverne de Macpéla, qui lui appartient et qui est au bout de son champ, de me la céder en votre présence pour l’argent qu’elle vaut, comme un lieu de sépulture qui soit à moi. » ");
INSERT INTO francl_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Or Ephron était assis au milieu des fils de Heth. Ephron le Hittite répondit à Abraham en présence des fils de Heth, de tous ceux qui entraient par la porte de sa ville ; il lui dit : ");
INSERT INTO francl_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","« Non, mon seigneur, écoute-moi : je te donne le champ et je te donne la caverne qui s’y trouve ; je te la donne aux yeux des fils de mon peuple ; enterre ton mort. » ");
INSERT INTO francl_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Abraham se prosterna devant le peuple du pays, ");
INSERT INTO francl_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","et il parla ainsi à Ephron en présence du peuple du pays : « Qu’il te plaise seulement de m’écouter : je donne le prix du champ ; reçois-le de moi, et j’enterrerai là mon mort. » ");
INSERT INTO francl_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Ephron répondit à Abraham en lui disant : ");
INSERT INTO francl_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","« Mon seigneur, écoute-moi : une terre de quatre cents sicles d’argent, entre moi et toi, qu’est-ce que cela ? Enterre ton mort. » ");
INSERT INTO francl_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abraham écouta Ephron, et Abraham pesa à Ephron l’argent qu’il avait dit en présence des fils de Heth, savoir quatre cents sicles d’argent ayant cours chez le marchand. ");
INSERT INTO francl_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Ainsi le champ d’Ephron, qui est à Macpéla, vis-à-vis de Mambré, le champ et la caverne qui s’y trouve, ainsi que tous les arbres qui sont dans le champ et dans ses confins tout autour, ");
INSERT INTO francl_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","devinrent la propriété d’Abraham, aux yeux des fils de Heth, de tous ceux qui entraient par la porte de la ville. ");
INSERT INTO francl_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Après cela, Abraham enterra Sara, sa femme, dans la caverne de Macpéla, vis-à-vis de Mambré, qui est Hébron, dans le pays de Canaan. ");
INSERT INTO francl_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Le champ, avec la caverne qui s’y trouve, demeura à Abraham en toute propriété comme lieu de sépulture, provenant des fils de Heth. ");
INSERT INTO francl_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abraham était vieux, avancé en âge, et Yahweh avait béni Abraham en toutes choses. ");
INSERT INTO francl_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Et Abraham dit à son serviteur, le plus ancien de sa maison, qui administrait tous ses biens : « Mets donc ta main sous ma cuisse, ");
INSERT INTO francl_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","et je te ferai jurer par Yahweh, Dieu du ciel et Dieu de la terre, que tu ne prendras pas pour mon fils une femme parmi les filles des Chananéens, au milieu desquels j’habite ; ");
INSERT INTO francl_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","mais ce sera dans mon pays et dans ma patrie que tu iras prendre une femme pour mon fils, pour Isaac. » ");
INSERT INTO francl_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Le serviteur lui répondit : « Peut-être la femme ne voudra-t-elle pas me suivre dans ce pays ; devrai-je ramener ton fils dans le pays d’où tu es sorti ? » ");
INSERT INTO francl_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abraham lui dit : « Garde-toi d’y ramener mon fils ! ");
INSERT INTO francl_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Yahweh, le Dieu du ciel, qui m’a pris de la maison de mon père et du pays de ma naissance, qui m’a parlé et qui m’a fait serment en disant : Je donnerai ce pays à ta postérité, lui-même enverra son ange devant toi, et tu prendras de là une femme pour mon fils. ");
INSERT INTO francl_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Si la femme ne veut pas te suivre, tu seras dégagé de ce serment que je te demande ; mais tu ne ramèneras pas là mon fils. » ");
INSERT INTO francl_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Alors le serviteur mit sa main sous la cuisse d’Abraham, son maître, et lui prêta serment à ce sujet. ");
INSERT INTO francl_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Le serviteur prit dix des chameaux de son maître, et il se mit en route ; or il avait à sa disposition tous les biens de son maître. S’étant levé, il alla en Mésopotamie, à la ville de Nachor. ");
INSERT INTO francl_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Il fit ployer les genoux aux chameaux hors de la ville, près d’un puits, vers le soir, à l’heure où les femmes sortent pour puiser de l’eau. ");
INSERT INTO francl_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Et il dit : « Yahweh, Dieu d’Abraham, mon maître, veuillez me faire rencontrer aujourd’hui ce que je désire, et usez de bonté envers mon maître Abraham. ");
INSERT INTO francl_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Voici que je me tiens près de la source d’eau, et les filles des habitants de la ville vont sortir pour puiser de l’eau. ");
INSERT INTO francl_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Que la jeune fille à laquelle je dirai : Penche ta cruche, je te prie, pour que je boive, — et qui répondra : Bois, et je donnerai aussi à boire à tes chameaux, — soit celle que vous avez destinée à votre serviteur Isaac ! Et par là je connaîtrai que vous avez usé de bonté envers mon maître. » ");
INSERT INTO francl_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Il n’avait pas encore fini de parler, et voici que sortit, sa cruche sur l’épaule, Rebecca, fille de Bathuel, fils de Melcha, femme de Nachor, frère d’Abraham. ");
INSERT INTO francl_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","La jeune fille était fort belle de figure ; elle était vierge, et nul homme ne l’avait connue. Elle descendit à la source, remplit sa cruche et remonta. ");
INSERT INTO francl_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Le serviteur courut au-devant d’elle et dit : « Permets que je boive un peu d’eau de ta cruche. » ");
INSERT INTO francl_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Elle répondit : « Bois, mon seigneur « ; et, s’empressant d’abaisser sa cruche sur sa main, elle lui donna à boire. ");
INSERT INTO francl_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Quand elle eut achevé de lui donner à boire, elle dit : « Je puiserai aussi de l’eau pour les chameaux, jusqu’à ce qu’ils aient bu assez. » ");
INSERT INTO francl_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Et elle se hâta de vider sa cruche dans l’abreuvoir, et courut encore au puits pour puiser, et elle puisa pour tous les chameaux. ");
INSERT INTO francl_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","L’homme la considérait en silence, pour savoir si Yahweh avait fait réussir son voyage, ou non. ");
INSERT INTO francl_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Quand les chameaux eurent fini de boire, l’homme prit un anneau d’or du poids d’un demi-sicle, et deux bracelets du poids de dix sicles d’or, ");
INSERT INTO francl_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","et il dit : « De qui es-tu fille ? Dis-le-moi donc. Y a-t-il dans la maison de ton père une place où nous puissions passer la nuit ? » ");
INSERT INTO francl_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Elle répondit : « Je suis fille de Bathuel, le fils de Melcha, qu’elle enfanta à Nachor. » ");
INSERT INTO francl_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Elle ajouta : « Il y a chez nous de la paille et du fourrage en abondance, et aussi de la place pour y passer la nuit. » ");
INSERT INTO francl_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Alors cet homme s’inclina et se prosterna devant Yahweh, ");
INSERT INTO francl_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","et il dit : « Béni soit Yahweh, le Dieu d’Abraham, mon maître, qui n’a pas manqué à sa bonté et à sa fidélité envers mon maître. Moi-même, Yahweh m’a conduit par le chemin chez les frères de mon maître. » ");
INSERT INTO francl_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","La jeune fille courut raconter chez sa mère ce qui s’était passé. ");
INSERT INTO francl_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Rebecca avait un frère, nommé Laban. Laban courut dehors vers cet homme, près de la source. ");
INSERT INTO francl_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Il avait vu l’anneau et les bracelets aux mains de sa sœur, et il avait entendu les paroles de Rebecca, sa sœur, disant : « L’homme m’a parlé ainsi. » Il vint donc à cet homme, qui se tenait auprès des chameaux, à la source, ");
INSERT INTO francl_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","et il dit : « Viens, béni de Yahweh ; pourquoi restes-tu dehors ? J’ai préparé la maison et une place pour les chameaux. » ");
INSERT INTO francl_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Et l’homme entra à la maison. Laban débâta les chameaux, et il donna de la paille et du fourrage aux chameaux, et de l’eau pour laver les pieds de l’homme et les pieds des gens qui étaient avec lui. ");
INSERT INTO francl_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Puis il lui servit à manger ; mais l’homme dit : « Je ne mangerai pas que je n’aie dit ce que j’ai à dire. » — « Parle, » dit Laban. ");
INSERT INTO francl_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Il dit : « Je suis serviteur d’Abraham. ");
INSERT INTO francl_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Yahweh a comblé de bénédictions mon maître, et il est devenu puissant. Il lui a donné des brebis et des bœufs, des serviteurs et des servantes, des chameaux et des ânes. ");
INSERT INTO francl_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Sara, femme de mon maître, a enfanté dans sa vieillesse un fils à mon maître, et il lui a donné tous ses biens. ");
INSERT INTO francl_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Mon maître m’a fait jurer, en disant : Tu ne prendras pas pour mon fils une femme parmi les filles des Chananéens, dans le pays desquels j’habite. ");
INSERT INTO francl_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Mais tu iras dans la maison de mon père et dans ma parenté, et tu prendras là une femme pour mon fils. ");
INSERT INTO francl_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","— Je dis à mon maître : Peut-être la femme ne voudra-t-elle pas me suivre. ");
INSERT INTO francl_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Et il m’a répondu : Yahweh, devant qui je marche, enverra son ange avec toi et fera réussir ton voyage, et tu prendras pour mon fils une femme de ma parenté et de la maison de mon père. ");
INSERT INTO francl_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Tu seras dégagé du serment que tu me fais, une fois que tu te seras rendu dans ma parenté ; si on ne te l’accorde pas, tu seras dégagé du serment que je te demande. — ");
INSERT INTO francl_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","En arrivant aujourd’hui à la source, j’ai dit : Yahweh, Dieu de mon maître Abraham, si vous daignez faire réussir le voyage que je fais, ");
INSERT INTO francl_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","voici que je me tiens près de la source d’eau ; que la jeune fille qui sortira pour puiser et à qui je dirai : Laisse-moi boire, je te prie, un peu d’eau de ta cruche, ");
INSERT INTO francl_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","et qui me répondra : Bois toi-même, et je puiserai aussi pour tes chameaux, — qu’elle soit la femme que Yahweh a destinée au fils de mon maître. ");
INSERT INTO francl_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Je n’avais pas encore fini de parler en mon cœur, voici que Rebecca sortait, sa cruche sur l’épaule ; elle est descendue à la source et a puisé ; et je lui ai dit : Donne-moi à boire, je te prie. — ");
INSERT INTO francl_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Abaissant aussitôt sa cruche de dessus son épaule, elle me dit : Bois, et je donnerai aussi à boire à tes chameaux. J’ai donc bu, et elle a aussi donné à boire aux chameaux. ");
INSERT INTO francl_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Et je l’ai interrogée, en disant : De qui es-tu fille ? Elle a répondu : Je suis fille de Bathuel, le fils de Nachor, que Melcha lui a enfanté. Alors j’ai mis l’anneau à ses narines et les bracelets à ses mains. ");
INSERT INTO francl_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Puis je me suis incliné et prosterné devant Yahweh, et j’ai béni Yahweh, le Dieu de mon maître Abraham, qui m’a conduit dans le vrai chemin pour prendre la fille du frère de mon maître pour son fils. ");
INSERT INTO francl_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Maintenant, si vous voulez user de bonté et de fidélité envers mon maître, déclarez-le-moi ; sinon, déclarez-le-moi encore, et je me tournerai à droite ou à gauche. » ");
INSERT INTO francl_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Laban et Bathuel répondirent, en disant : « La chose vient de Yahweh, nous ne pouvons te dire ni mal ni bien. ");
INSERT INTO francl_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Voici Rebecca devant toi ; prends-la et t’en va ; qu’elle soit la femme du fils de ton maître, comme Yahweh l’a dit. » ");
INSERT INTO francl_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Lorsque le serviteur d’Abraham eut entendu ces paroles, il se prosterna à terre devant Yahweh. ");
INSERT INTO francl_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Et le serviteur tira des objets d’argent, des objets d’or et des vêtements, qu’il donna à Rebecca ; il fit aussi de riches présents à son frère et à sa mère. ");
INSERT INTO francl_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Ensuite ils mangèrent et burent, lui et les gens qui étaient avec lui, et ils passèrent là la nuit. Le matin, quand ils furent levés, le serviteur dit : « Laissez-moi retourner vers mon maître. » ");
INSERT INTO francl_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Le frère et la mère de Rebecca dirent : « Que la jeune fille demeure avec nous quelques jours encore, une dizaine ; après quoi elle partira. » ");
INSERT INTO francl_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Il leur répondit : « Ne me retardez pas, puisque Yahweh a fait réussir mon voyage ; laissez-moi partir, pour que je retourne vers mon maître. » ");
INSERT INTO francl_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Ils dirent : « Appelons la jeune fille, et demandons-lui ce qu’elle désire. » ");
INSERT INTO francl_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Ils appelèrent donc Rebecca et lui dirent : « Veux-tu partir avec cet homme ? » Elle répondit : « Je partirai. » ");
INSERT INTO francl_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Alors ils congédièrent Rebecca, leur sœur, et sa nourrice, avec le serviteur d’Abraham et ses gens. ");
INSERT INTO francl_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Ils bénirent Rebecca et lui dirent : « O notre sœur, puisses-tu devenir des milliers de myriades ! Puisse ta postérité posséder la porte de ses ennemis ! » ");
INSERT INTO francl_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Alors Rebecca et ses servantes, s’étant levées, montèrent sur les chameaux, et suivirent cet homme. Et le serviteur emmena Rebecca et se mit en route. ");
INSERT INTO francl_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Cependant Isaac était revenu du puits de Lahaï-Roï, et il habitait dans le pays du Midi. ");
INSERT INTO francl_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Un soir qu’ Isaac était sorti dans les champs pour méditer, levant les yeux, il vit des chameaux qui arrivaient. ");
INSERT INTO francl_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebecca leva aussi les yeux et, ayant aperçu Isaac, elle sauta à bas de son chameau. ");
INSERT INTO francl_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Elle dit au serviteur : « Qui est cet homme qui vient dans les champs à notre rencontre ? » Le serviteur répondit : « C’est mon maître. » Et elle prit son voile et se couvrit. ");
INSERT INTO francl_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Le serviteur raconta à Isaac toutes les choses qu’il avait faites. ");
INSERT INTO francl_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Et Isaac conduisit Rebecca dans la tente de Sara, sa mère. Il prit Rebecca, qui devint sa femme, et il l’aima ; et Isaac se consola de la mort de sa mère. ");
INSERT INTO francl_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abraham prit encore une femme, nommée Qetoura. ");
INSERT INTO francl_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Et elle lui enfanta Zamran, Jecsan, Madan, Madian, Jesboc et Sué. — ");
INSERT INTO francl_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Jecsan engendra Saba et Dadan ; les fils de Dadan furent les Assurim, les Latusim et les Laomim. — ");
INSERT INTO francl_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Les fils de Madian furent Epha, Opher, Hénoch, Abida et Eldaa. — Ce sont là tous les fils de Qetoura. ");
INSERT INTO francl_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abraham donna tous ses biens à Isaac : ");
INSERT INTO francl_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Quant aux fils de ses concubines, il leur donna des présents, et il les envoya de son vivant loin de son fils Isaac, à l’orient, au pays d’Orient. ");
INSERT INTO francl_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Voici les jours des années de la vie d’Abraham : il vécut cent soixante-quinze ans. ");
INSERT INTO francl_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Abraham expira et mourut dans une heureuse vieillesse, âgé et rassasié de jours, et il fut réuni à son peuple. ");
INSERT INTO francl_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Isaac et Ismaël, ses fils, l’enterrèrent dans la caverne de Macpéla, dans le champ d’Ephron, fils de Séor le Hittite, qui est vis-à-vis de Mambré : ");
INSERT INTO francl_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","c’est le champ qu’Abraham avait acheté des fils de Heth. Là fut enterré Abraham, avec Sara, sa femme. ");
INSERT INTO francl_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Après la mort d’Abraham, Dieu bénit Isaac son fils ; et Isaac habitait près du puits de Lachaï-Roï. ");
INSERT INTO francl_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Voici l’histoire d’Ismaël, fils d’Abraham, qu’avait enfanté à Abraham Agar l’Egyptienne, servante de Sara. ");
INSERT INTO francl_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Voici les noms des fils d’Ismaël, selon les noms de leurs postérités : premier-né d’Ismaël, Nebaïoth ; puis Cédar, Adbéel, Mabsam, ");
INSERT INTO francl_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Masma, Duma, Massa, ");
INSERT INTO francl_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad, Théma, Jéthur, Naphis et Cedma. ");
INSERT INTO francl_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Ce sont là les fils d’Ismaël, ce sont là leurs noms, selon leurs villages et leurs campements : ce furent les douze chefs de leurs tribus. ");
INSERT INTO francl_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Voici les années de la vie d’Ismaël : cent trente-sept ans ; puis il expira et mourut et il fut réuni à son peuple. ");
INSERT INTO francl_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Ses fils habitèrent depuis Hévila jusqu’à Sur qui est en face de l’Égypte, dans la direction de l’Assyrie. Il s’étendit en face de tous ses frères. ");
INSERT INTO francl_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Voici l’histoire d’Isaac, fils d’Abraham. Abraham engendra Isaac. ");
INSERT INTO francl_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isaac était âgé de quarante ans quand il prit pour femme Rebecca, fille de Bathuel l’Araméen, de Paddan-Aram, et sœur de Laban, l’Araméen. ");
INSERT INTO francl_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Isaac implora Yahweh au sujet de sa femme, car elle était stérile ; Yahweh l’exauça et Rebecca, sa femme, conçut. ");
INSERT INTO francl_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Les enfants se heurtaient dans son sein, et elle dit : « S’il en est ainsi, pourquoi suis-je enceinte ? » Elle alla consulter Yahweh ; ");
INSERT INTO francl_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","et Yahweh lui dit : « Deux nations sont dans ton sein ; deux peuples, au sortir de tes entrailles, se sépareront ; un peuple l’emportera sur l’autre, et l’aîné servira le cadet. » ");
INSERT INTO francl_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Le temps où elle devait enfanter arriva, et voici, il y avait deux jumeaux dans son sein. ");
INSERT INTO francl_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Celui qui sortit le premier était roux, tout entier comme un manteau de poil, et ils l’appelèrent Esaü ; ensuite sortit son frère, tenant dans sa main le talon d’Esaü, et on le nomma Jacob. ");
INSERT INTO francl_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Isaac était âgé de soixante ans quand ils naquirent. ");
INSERT INTO francl_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Ces enfants grandirent. Esaü devint un habile chasseur, un homme des champs ; mais Jacob était un homme paisible, demeurant sous la tente. ");
INSERT INTO francl_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isaac prit en affection Esaü, parce qu’il aimait la venaison, et l’affection de Rebecca était pour Jacob. ");
INSERT INTO francl_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Comme Jacob faisait un potage, Esaü arriva des champs, accablé de fatigue. ");
INSERT INTO francl_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Esaü dit à Jacob : « Laisse-moi donc manger de ce roux, de ce roux-là, car je suis fatigué. » — C’est pour cela qu’on a donné à Esaü le nom d’Edom. — ");
INSERT INTO francl_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Jacob dit : « Vends-moi d’abord ton droit d’aînesse. » ");
INSERT INTO francl_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esaü répondit : « Voici je m’en vais mourir ; que me servira mon droit d’aînesse ? » ");
INSERT INTO francl_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Et Jacob dit : « Jure-le-moi d’abord. » Il jura et vendit son droit d’aînesse à Jacob. ");
INSERT INTO francl_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Alors Jacob donna à Esaü du pain et du potage de lentilles ; celui-ci mangea et but ; puis il se leva et s’en alla. C’est ainsi qu’Esaü méprisa le droit d’aînesse. ");
INSERT INTO francl_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Il y eut une famine dans le pays, outre la première famine qui avait eu lieu du temps d’Abraham ; et Isaac alla à Guérar, vers Abimélek, roi des Philistins. ");
INSERT INTO francl_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Yahweh lui apparut et dit : « Ne descends pas en Égypte, mais demeure dans le pays que je te dirai. ");
INSERT INTO francl_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Séjourne dans ce pays-ci ; je serai avec toi et je te bénirai, car je donnerai toutes ces contrées à toi et à ta postérité, et je tiendrai le serment que j’ai fait à Abraham, ton père. ");
INSERT INTO francl_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Je multiplierai ta postérité comme les étoiles du ciel, et je donnerai à ta postérité toutes ces contrées, et en ta postérité seront bénies toutes les nations de la terre, ");
INSERT INTO francl_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","parce qu’Abraham a obéi à ma voix et a gardé mon ordre, mes commandements, mes statuts et mes lois. » ");
INSERT INTO francl_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Isaac demeura donc à Guérar. ");
INSERT INTO francl_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Les gens du lieu le questionnaient sur sa femme, il disait : « C’est ma sœur « ; car il craignait de dire : « Ma femme », de peur, pensait-il, que les gens du lieu ne me tuent à cause de Rebecca », car elle était belle de figure. ");
INSERT INTO francl_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Comme son séjour à Guérar se prolongeait, il arriva qu’Abimélek, roi des Philistins, regardant par la fenêtre, aperçut Isaac qui faisait des caresses à Rebecca, sa femme. ");
INSERT INTO francl_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Abimélek appela Isaac et dit : « Elle ne peut être que ta femme ; comment as-tu dit : C’est ma sœur ? » Isaac lui répondit : « C’est que je me disais : Je crains de mourir à cause d’elle. » ");
INSERT INTO francl_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Et Abimélek dit : « Qu’est-ce que tu nous as fait ? Car peu s’en est fallu qu’un homme du peuple couche avec ta femme, et tu aurais fait venir sur nous un péché. » ");
INSERT INTO francl_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Alors Abimélek donna cet ordre à tout le peuple : « Celui qui touchera cet homme ou sa femme sera mis à mort. » ");
INSERT INTO francl_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Isaac fit des semailles dans ce pays, et il recueillit cette année-là le centuple. Yahweh le bénit ; ");
INSERT INTO francl_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","et cet homme devint riche, et il alla s’enrichissant de plus en plus, jusqu’à devenir très riche. ");
INSERT INTO francl_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Il avait des troupeaux de menu bétail et des troupeaux de gros bétail et beaucoup de serviteurs, et les Philistins lui portèrent envie. ");
INSERT INTO francl_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Tous les puits qu’avaient creusés les serviteurs de son père, du temps de son père Abraham, les Philistins les bouchèrent, en les remplissant de terre. ");
INSERT INTO francl_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Et Abimélek dit à Isaac : « Va-t’en de chez nous, car tu es devenu beaucoup plus puissant que nous. » ");
INSERT INTO francl_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Isaac s’en alla et, ayant établi son campement dans la vallée de Guérar, il y demeura. ");
INSERT INTO francl_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Isaac creusa de nouveau les puits d’eau qu’on avait creusés du temps d’Abraham, son père, et que les Philistins avaient bouchés après la mort d’Abraham, et il leur donna les mêmes noms que son père leur avait donnés. ");
INSERT INTO francl_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Les serviteurs d’Isaac creusèrent encore dans la vallée et y trouvèrent un puits d’eau vive. ");
INSERT INTO francl_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Et les bergers de Guérar se querellèrent avec les bergers d’Isaac, en disant : « L’eau est à nous. » Et il nomma le puits Eseq, parce qu’ils avaient eu un débat avec lui. ");
INSERT INTO francl_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Ses serviteurs creusèrent un autre puits, au sujet duquel il y eut encore une querelle, et il le nomma Sitna. ");
INSERT INTO francl_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Étant parti de là, il creusa un autre puits, pour lequel il n’y eut plus de querelle, et il le nomma Rechoboth : « Car maintenant, dit-il, Yahweh nous a mis au large, et nous prospérerons dans le pays. » ");
INSERT INTO francl_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","De là, il remonta à Bersabée. ");
INSERT INTO francl_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Yahweh lui apparut cette nuit-là et dit : « Je suis le Dieu d’Abraham, ton père ; ne crains point, car je suis avec toi ; je te bénirai et je multiplierai ta postérité, à cause d’Abraham, mon serviteur. » ");
INSERT INTO francl_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Il éleva là un autel et invoqua le nom de Yahweh, puis il y dressa sa tente ; et les serviteurs d’Isaac y creusèrent un puits. ");
INSERT INTO francl_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Abimélek vint vers lui, de Guérar, avec Ochozath, son ami, et Phicol, chef de son armée. ");
INSERT INTO francl_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Isaac leur dit : « Pourquoi êtes-vous venus vers moi, vous qui me haïssez et qui m’avez renvoyé de chez vous ? » ");
INSERT INTO francl_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Ils répondirent : « Nous avons vu clairement que Yahweh est avec toi, et nous avons dit : Qu’il y ait un serment entre nous, entre nous et toi, et que nous fassions une alliance avec toi. ");
INSERT INTO francl_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Jure de ne pas nous faire de mal, de même que nous ne t’avons pas touché, et que nous ne t’avons fait que du bien, et t’avons laissé partir en paix. Tu es maintenant le béni de Yahweh. » ");
INSERT INTO francl_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Isaac leur fit un festin, et ils mangèrent et burent. ");
INSERT INTO francl_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Et, s’étant levés de bon matin, ils se prêtèrent serment l’un à l’autre ; puis Isaac les congédia et ils s’en allèrent de chez lui en paix. ");
INSERT INTO francl_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Ce même jour, les serviteurs d’Isaac vinrent lui apporter des nouvelles du puits qu’ils creusaient ; ils lui dirent : « Nous avons trouvé de l’eau. » ");
INSERT INTO francl_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Et il appela le puits Schibéa. C’est pour cela que la ville se nomme Bersabée jusqu’à ce jour. ");
INSERT INTO francl_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esaü, âgé de quarante ans, prit pour femmes Judith, fille de Bééri, le Hittite, et Basemath, fille d’Elon, le Hittite. ");
INSERT INTO francl_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Elles furent un sujet d’amertume pour Isaac et Rebecca. ");
INSERT INTO francl_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Isaac était devenu vieux, et ses yeux s’étaient obscurcis au point de ne plus voir. Il appela Esaü, son fils aîné, et lui dit : « Mon fils ! » Celui-ci lui–répondit : « Me voici. » ");
INSERT INTO francl_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Isaac dit : « Voici donc, je suis vieux ; je ne connais pas le jour de ma mort. ");
INSERT INTO francl_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Maintenant donc, prends tes armes, ton carquois et ton arc, va dans la campagne et tue-moi du gibier. ");
INSERT INTO francl_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Fais-m’en un bon plat, selon mon goût, et apporte-le-moi, que je le mange, afin que mon âme te bénisse avant que je meure. » ");
INSERT INTO francl_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","— Rebecca entendait pendant qu’Isaac parlait à Esaü, son fils. — Et Esaü s’en alla dans la campagne pour tuer du gibier et l’apporter. ");
INSERT INTO francl_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Alors Rebecca parla ainsi à Jacob, son fils : « Voici, j’ai entendu ton père qui parlait ainsi à ton frère Esaü : ");
INSERT INTO francl_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Apporte-moi du gibier et fais-m’en un bon plat, afin que je le mange et que je te bénisse devant Yahweh avant de mourir. ");
INSERT INTO francl_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Maintenant, mon fils, écoute ma voix dans ce que je vais te commander. ");
INSERT INTO francl_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Va au troupeau et prends-moi deux beaux chevreaux ; j’en ferai pour ton père un bon plat, selon son goût, ");
INSERT INTO francl_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","et tu le porteras à ton père, et il en mangera, afin qu’il te bénisse avant de mourir. » ");
INSERT INTO francl_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Jacob répondit à Rebecca, sa mère : « Voici, Esaü, mon frère, est velu, et moi j’ai la peau lisse. ");
INSERT INTO francl_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Peut-être que mon père me touchera, et je passerai à ses yeux pour m’être joué de lui, et j’attirerai sur moi une malédiction au lieu d’une bénédiction. » ");
INSERT INTO francl_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Sa mère lui dit : « Je prends sur moi ta malédiction, mon fils. Ecoute seulement ma voix et va me prendre les chevreaux. » ");
INSERT INTO francl_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Jacob alla les prendre et les apporta à sa mère, qui en fit un bon plat, selon le goût de son père. ");
INSERT INTO francl_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Et Rebecca prit les habits d’Esaü, son fils aîné, les plus beaux, qu’elle avait dans la maison, et elle en revêtit Jacob, son fils cadet. ");
INSERT INTO francl_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Puis elle lui couvrit les mains de la peau des chevreaux, ainsi que la partie lisse du cou. ");
INSERT INTO francl_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Et elle mit dans la main de Jacob, son fils, le bon plat et le pain qu’elle avait préparés. ");
INSERT INTO francl_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Il vint vers son père et dit : « Mon père ! » — « Me voici, dit Isaac ; qui es-tu, mon fils ? » ");
INSERT INTO francl_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Jacob répondit à son père : « Je suis Esaü, ton premier-né ; j’ai fait ce que tu m’as dit. Lève-toi, je te prie, assieds-toi et mange de ma chasse, afin que ton âme me bénisse. » ");
INSERT INTO francl_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Isaac dit à son fils : « Comment as-tu trouvé si vite, mon fils ? » Jacob, répondit : « C’est que Yahweh, ton Dieu, l’a fait venir devant moi. » ");
INSERT INTO francl_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Et Isaac dit à Jacob : « Approche donc, que je te touche, mon fils, pour savoir si tu es bien mon fils Esaü, ou non. » ");
INSERT INTO francl_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Jacob s’étant approché d’Isaac, son père, celui-ci le toucha et dit : « La voix est la voix de Jacob, mais les mains sont les mains d’Esaü. » ");
INSERT INTO francl_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Il ne le reconnut pas, parce que ses mains étaient velues, comme les mains d’Esaü, son frère, et il le bénit. ");
INSERT INTO francl_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Il dit : « C’est bien toi qui es mon fils Esaü ? » — « C’est moi », répondit Jacob. ");
INSERT INTO francl_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Et Isaac dit : « Sers-moi, que je mange du gibier de mon fils et que mon âme te bénisse. » Jacob le servit, et il mangea ; il lui présenta aussi du vin, et il but. ");
INSERT INTO francl_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Alors Isaac, son père, lui dit : « Approche-toi donc et baise-moi, mon fils. » ");
INSERT INTO francl_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Jacob s’approcha et le baisa ; et Isaac sentit l’odeur de ses vêtements, et il le bénit en disant : « Voici, l’odeur de mon fils est comme l’odeur d’un champ qu’a béni Yahweh. » ");
INSERT INTO francl_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Que Dieu te donne de la rosée du ciel et de la graisse de la terre, et abondance de froment et de vin ! ");
INSERT INTO francl_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Que des peuples te servent, et que des nations se prosternent devant toi ! Sois le maître de tes frères, et que les fils de ta mère se prosternent devant toi ! Maudit soit qui te maudira, et béni soit qui te bénira ! ");
INSERT INTO francl_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Isaac avait achevé de bénir Jacob, et Jacob venait de quitter Isaac, son père, lorsqu’Esaü, son frère, revint de la chasse. ");
INSERT INTO francl_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Il prépara, lui aussi, un bon plat, et l’apporta à son père ; et il dit à son père : « Que mon père se lève et mange de la chasse de son fils, afin que ton âme me bénisse. » ");
INSERT INTO francl_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Isaac, son père, lui dit : « Qui es-tu ? » Il répondit : « Je suis ton fils, ton premier-né, Esaü. » ");
INSERT INTO francl_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Isaac fut saisi d’une terreur extrême, et il dit : « Qui est donc celui qui a chassé du gibier et m’en a apporté ? J’ai mangé de tout avant que tu vinsses, et je l’ai béni ; et il sera béni en effet. » ");
INSERT INTO francl_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Lorsqu’Esaü eut entendu les paroles de son père, il jeta un grand cri, une plainte très amère, et il dit à son père : « Bénis-moi, moi aussi, mon père. » ");
INSERT INTO francl_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Isaac dit : « Ton frère est venu avec ruse, et il a pris ta bénédiction. » ");
INSERT INTO francl_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esaü dit : « Est-ce parce qu’on l’appelle Jacob qu’il m’a supplanté deux fois ? Il a pris mon droit d’aînesse, et voilà maintenant qu’il a pris ma bénédiction ! » Il ajouta : « N’as-tu pas réservé pour moi une bénédiction ? » ");
INSERT INTO francl_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isaac répondit et dit à Esaü : « Voici, je l’ai établi ton maître et je lui ai donné tous ses frères pour serviteurs, et je l’ai pourvu de froment et de vin ; et pour toi donc, que puis-je faire, mon fils ? ");
INSERT INTO francl_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esaü dit à son père : « N’as-tu que cette seule bénédiction, mon père ? Bénis-moi, moi aussi, mon père ! » Et Esaü éleva la voix et pleura. ");
INSERT INTO francl_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Isaac, son père, lui répondit : « Privée de la graisse de la terre sera ta demeure, privée de la rosée qui descend du ciel. ");
INSERT INTO francl_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Tu vivras de ton épée, et tu seras asservi à ton frère ; mais il arrivera que, en secouant son joug, tu le briseras de dessus ton cou. » ");
INSERT INTO francl_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Esaü conçut de la haine contre Jacob à cause de la bénédiction que son père lui avait donnée, et Esaü dit en son cœur : « Les jours où je ferai le deuil de mon père approchent ; alors je tuerai Jacob, mon frère. » ");
INSERT INTO francl_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","On rapporta à Rebecca les paroles d’Esaü, son fils aîné. Elle fit appeler Jacob, son fils cadet, et lui dit : « Voici qu’Esaü, ton frère, veut se venger de toi en te tuant. ");
INSERT INTO francl_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Maintenant donc, mon fils, écoute ma voix : lève-toi, fuis vers Laban, mon frère, à Haran ; ");
INSERT INTO francl_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","et tu resteras quelque temps auprès de lui, jusqu’à ce que la fureur de ton frère soit apaisée, ");
INSERT INTO francl_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","jusqu’à ce que la colère de ton frère se soit détournée de toi, et qu’il ait oublié ce que tu lui as fait ; alors je t’enverrai chercher de là. Pourquoi serais-je privée de vous deux en un même jour ? » ");
INSERT INTO francl_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Rebecca dit à Isaac : « Je suis dégoûtée de la vie, à cause des filles de Heth. Si Jacob prend une femme, comme celles-là, parmi les filles de Heth, parmi les filles de ce pays, à quoi me sert la vie ? » ");
INSERT INTO francl_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Isaac appela Jacob et le bénit, et il lui donna cet ordre : « Tu ne prendras pas pour femme une des filles de Canaan. ");
INSERT INTO francl_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Lève-toi, va en Paddan-Aram, chez Bathuel, père de ta mère, et prends-y une femme parmi les filles de Laban, frère de ta mère. ");
INSERT INTO francl_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Que Dieu le tout-puissant te bénisse, qu’il te fasse croître et multiplier, afin que tu deviennes une multitude de peuples ! ");
INSERT INTO francl_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Qu’il te donne la bénédiction d’Abraham, à toi et à ta postérité avec toi, afin que tu possèdes le pays où tu séjournes, et que Dieu a donné à Abraham ! » ");
INSERT INTO francl_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Et Isaac congédia Jacob, qui s’en alla en Paddan-Aram, vers Laban, fils de Bathuel l’Araméen, frère de Rebecca, la mère de Jacob et d’Esaü. ");
INSERT INTO francl_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esaü vit qu’Isaac avait béni Jacob et qu’il l’avait envoyé en Paddan-Aram pour y prendre une femme, et qu’en le bénissant, il lui avait donné cet ordre : « Tu ne prendras pas pour femme une des filles de Canaan », ");
INSERT INTO francl_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","et que Jacob, obéissant à son père et à sa mère, était parti pour Paddan-Aram. ");
INSERT INTO francl_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Esaü vit donc que les filles de Canaan déplaisaient à Isaac, son père, ");
INSERT INTO francl_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","et Esaü s’en alla vers Ismaël, et il prit pour femme, outre les femmes qu’il avait déjà, Mahéleth, fille d’Ismaël, fils d’Abraham, et sœur de Nabaïoth. ");
INSERT INTO francl_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Jacob partit de Bersabée et s’en alla à Haran. ");
INSERT INTO francl_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Il arriva dans un lieu ; et il y passa la nuit, parce que le soleil était couché. Ayant pris une des pierres qui étaient là, il en fit son chevet, et il se coucha dans ce lieu. ");
INSERT INTO francl_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Il eut un songe : et voici, une échelle était posée sur la terre et son sommet touchait au ciel ; et voici, sur elle des anges de Dieu montaient et descendaient, ");
INSERT INTO francl_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","et au haut se tenait Yahweh. Il dit : « Je suis Yahweh, le Dieu d’Abraham, ton père, et le Dieu d’Isaac. Cette terre sur laquelle tu es couché, je te la donnerai, à toi et à ta postérité. ");
INSERT INTO francl_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Ta postérité sera comme la poussière de la terre ; tu t’étendras à l’occident et à l’orient, au septentrion et au midi, et toutes les familles de la terre seront bénies en toi et en ta postérité. ");
INSERT INTO francl_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Voici, je suis avec toi, et je te garderai partout où tu iras et je te ramènerai dans ce pays. Car je ne t’abandonnerai pas que je n’aie fait ce que je t’ai dit. » ");
INSERT INTO francl_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Jacob s’éveilla de son sommeil et il dit : « Certainement Yahweh est en ce lieu, et moi je ne le savais pas ! » ");
INSERT INTO francl_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Saisi de crainte, il ajouta : « Que ce lieu est redoutable ! C’est bien ici la maison de Dieu, c’est ici la porte du ciel. » ");
INSERT INTO francl_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","S’étant levé de bon matin, Jacob prit la pierre dont il avait fait son chevet, la dressa pour monument et versa de l’huile sur son sommet. ");
INSERT INTO francl_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Il nomma ce lieu Béthel ; mais primitivement la ville s’appelait Luz. ");
INSERT INTO francl_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Et Jacob fit un vœu en disant : « Si Dieu est avec moi et me garde dans ce voyage que je fais ; s’il me donne du pain à manger et des habits pour me vêtir, ");
INSERT INTO francl_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","et si je retourne heureusement à la maison de mon père, Yahweh sera mon Dieu ; ");
INSERT INTO francl_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","cette pierre que j’ai dressée pour monument sera une maison de Dieu, et je vous paierai la dîme de tout ce que vous me donnerez. » ");
INSERT INTO francl_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Jacob reprit sa marche et s’en alla au pays des fils de l’Orient. ");
INSERT INTO francl_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Il regarda, et voici, il y avait un puits dans la campagne, et voici, il y avait à côté trois troupeaux de brebis qui étaient couchés, car c’était à ce puits qu’on abreuvait les troupeaux, et la pierre qui était sur l’ouverture du puits était grande. ");
INSERT INTO francl_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Là se réunissaient tous les troupeaux ; on roulait la pierre de dessus l’ouverture du puits, on faisait boire les troupeaux, et l’on remettait la pierre à sa place sur l’ouverture du puits. ");
INSERT INTO francl_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Jacob dit aux bergers : « Mes frères, d’où êtes-vous ? » ils répondirent : « Nous sommes de Haran. » ");
INSERT INTO francl_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Il leur dit : « Connaissez-vous Laban, fils de Nachor ? » Ils répondirent : « Nous le connaissons. » ");
INSERT INTO francl_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Il leur dit : « Est-il en bonne santé ? » Ils répondirent : « Il est en bonne santé, et voici Rachel, sa fille, qui vient avec les brebis. » ");
INSERT INTO francl_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Il dit : « Voici, il est encore grand jour, et ce n’est pas le moment de rassembler les troupeaux ; abreuvez les brebis et retournez les faire paître. » ");
INSERT INTO francl_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Ils répondirent : « Nous ne le pouvons pas jusqu’à ce que tous les troupeaux soient rassemblés et qu’on roule la pierre de dessus l’ouverture du puits ; alors nous abreuverons les brebis. » ");
INSERT INTO francl_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Il s’entretenait encore avec eux, lorsque Rachel arriva avec les brebis de son père ; car elle était bergère. ");
INSERT INTO francl_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Dès que Jacob vit Rachel, fille de Laban, frère de sa mère, et les brebis de Laban, frère de sa mère, il s’approcha, roula la pierre de dessus l’ouverture du puits, et abreuva les brebis de Laban, frère de sa mère. ");
INSERT INTO francl_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Et Jacob baisa Rachel, et il éleva la voix et pleura. ");
INSERT INTO francl_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Jacob apprit à Rachel qu’il était frère de son père, qu’il était fils de Rebecca ; et elle courut l’annoncer à son père. ");
INSERT INTO francl_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Quand Laban eut entendu parler de Jacob, fils de sa sœur, il courut au-devant de lui, et l’ayant pris dans ses bras, il lui donna des baisers et l’amena dans sa maison. Jacob raconta à Laban toutes ces choses, ");
INSERT INTO francl_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","et Laban lui dit : « Oui, tu es mes os et ma chair. » Et Jacob demeura avec lui un mois entier. ");
INSERT INTO francl_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Alors Laban dit à Jacob : « Est-ce que, parce que tu es mon frère, tu me serviras pour rien ? Dis-moi quel sera ton salaire. » ");
INSERT INTO francl_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Or Laban avait deux filles ; l’aînée se nommait Lia, et la cadette Rachel. ");
INSERT INTO francl_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lia avait les yeux malades ; mais Rachel était belle de taille et belle de visage. ");
INSERT INTO francl_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Comme Jacob aimait Rachel, il dit : « Je te servirai sept ans pour Rachel, ta fille cadette. » ");
INSERT INTO francl_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Et Laban dit : « Mieux vaut te la donner que la donner à un autre ; reste avec moi. » ");
INSERT INTO francl_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Et Jacob servit pour Rachel sept années, et elles furent à ses yeux comme quelques jours, parce qu’il l’aimait. ");
INSERT INTO francl_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Jacob dit à Laban : « Donne-moi ma femme, car mon temps est accompli, et j’irai vers elle. » ");
INSERT INTO francl_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Laban réunit tous les gens du lieu et fit un festin ; ");
INSERT INTO francl_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","et le soir, prenant Lia, sa fille, il l’amena à Jacob, qui alla vers elle. ");
INSERT INTO francl_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Et Laban donna sa servante Zelpha pour servante à Lia, sa fille. ");
INSERT INTO francl_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Le matin venu, voilà que c’était Lia. Et Jacob dit à Laban : « Que m’as-tu fait ? N’est-ce pas pour Rachel que j’ai servi chez toi ? Pourquoi m’as-tu trompé ? » ");
INSERT INTO francl_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laban répondit : « Ce n’est pas l’usage dans notre pays de donner la cadette avant l’aînée. ");
INSERT INTO francl_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Achève la semaine de celle-ci, et nous te donnerons aussi l’autre pour le service que tu feras encore chez moi pendant sept autres années. » ");
INSERT INTO francl_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Jacob fit ainsi, et il acheva la semaine de Lia ; puis Laban lui donna pour femme Rachel, sa fille. ");
INSERT INTO francl_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Et Laban donna sa servante Bala pour servante à Rachel, sa fille. ");
INSERT INTO francl_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Jacob alla aussi vers Rachel et il l’aima aussi plus que Lia ; il servit encore chez Laban sept autres années. ");
INSERT INTO francl_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Yahweh vit que Lia était haïe, et il la rendit féconde, tandis que Rachel était stérile. ");
INSERT INTO francl_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lia conçut et enfanta un fils, et elle le nomma Ruben, car elle dit : «  Yahweh a regardé mon affliction ; maintenant mon mari m’aimera. » ");
INSERT INTO francl_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Elle conçut encore et enfanta un fils, et elle dit : «  Yahweh a entendu que j’étais haïe, et il m’a encore donné celui-là ». Et elle le nomma Siméon. ");
INSERT INTO francl_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Elle conçut encore et enfanta un fils, et elle dit : « Cette fois mon mari s’attachera à moi car je lui ai enfanté trois fils. » C’est pourquoi on le nomma Lévi. ");
INSERT INTO francl_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Elle conçut encore et enfanta un fils, et elle dit : « Cette fois je louerai Yahweh. » C’est pourquoi elle le nomma Juda. Et elle cessa d’avoir des enfants. ");
INSERT INTO francl_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Rachel voyant qu’elle n’enfantait pas d’enfant à Jacob, fut jalouse de sa sœur, et elle dit à Jacob : « Donne-moi des enfants, ou je meurs ! » ");
INSERT INTO francl_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","La colère de Jacob s’enflamma contre Rachel, et il dit : « Suis-je à la place de Dieu, qui t’a refusé la fécondité ? » ");
INSERT INTO francl_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Elle dit : « Voici ma servante Bala ; va vers elle ; qu’elle enfante sur mes genoux, et par elle j’aurai, moi aussi, une famille. » ");
INSERT INTO francl_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Et elle lui donna Bala, sa servante, pour femme, et Jacob alla vers elle. ");
INSERT INTO francl_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bala conçut et enfanta un fils à Jacob. ");
INSERT INTO francl_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Et Rachel dit : « Dieu m’a rendu justice, et même il a entendu ma voix et m’a donné un fils. » C’est pourquoi elle le nomma Dan. ");
INSERT INTO francl_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Bala, servante de Rachel, conçut encore et enfanta un second fils à Jacob. ");
INSERT INTO francl_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Et Rachel dit : « J’ai lutté auprès de Dieu à l’encontre de ma sœur, et je l’ai emporté. » Et elle le nomma Nephthali. ");
INSERT INTO francl_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Lorsque Lia vit qu’elle avait cessé d’avoir des enfants, elle prit Zelpha, sa servante, et la donna pour femme à Jacob. ");
INSERT INTO francl_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Zelpha, servante de Lia, enfanta un fils à Jacob ; ");
INSERT INTO francl_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","et Lia dit : « Quelle bonne fortune ! » et elle le nomma Gad. ");
INSERT INTO francl_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Zelpha, servante de Lia, enfanta un second fils à Jacob ; ");
INSERT INTO francl_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","et Lia dit : « Pour mon bonheur ! car les filles me diront bienheureuse. » Et elle le nomma Aser. ");
INSERT INTO francl_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Ruben sortit au temps de la moisson des blés et, ayant trouvé des mandragores dans les champs, il les apporta à Lia, sa mère. Alors Rachel dit à Lia : « Donne-moi, je te prie, des mandragores de ton fils. » ");
INSERT INTO francl_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Elle lui répondit : « Est-ce peu que tu aies pris mon mari, pour que tu prennes encore les mandragores de mon fils ? » Et Rachel dit : « Eh bien, qu’il couche avec toi cette nuit pour les mandragores de ton fils. » ");
INSERT INTO francl_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Le soir, comme Jacob revenait des champs, Lia sortit à sa rencontre et lui dit : « C’est vers moi que tu viendras, car je t’ai loué pour les mandragores de mon fils. » Et il coucha avec elle cette nuit-là. ");
INSERT INTO francl_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Dieu exauça Lia ; elle conçut et enfanta à Jacob un cinquième fils ; ");
INSERT INTO francl_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","et Lia dit : « Dieu m’a donné mon salaire, parce que j’ai donné ma servante à mon mari. » Et elle le nomma Issachar. ");
INSERT INTO francl_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Lia conçut encore et enfanta un sixième fils à Jacob ; ");
INSERT INTO francl_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","et elle dit : « Dieu m’a fait un beau don ; cette fois mon mari habitera avec moi, puisque je lui ai enfanté six fils. » Et elle le nomma Zabulon. ");
INSERT INTO francl_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Elle enfanta ensuite une fille, qu’elle appela Dina. ");
INSERT INTO francl_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Dieu se souvint de Rachel ; il l’exauça et la rendit féconde. ");
INSERT INTO francl_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Elle conçut et enfanta un fils, et elle dit : « Dieu a ôté mon opprobre. » ");
INSERT INTO francl_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Et elle le nomma Joseph, en disant : « Que Yahweh m’ajoute encore un autre fils ! » ");
INSERT INTO francl_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Lorsque Rachel eut enfanté Joseph, Jacob dit à Laban : « Laisse-moi partir, et que je retourne chez moi, dans mon pays. ");
INSERT INTO francl_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Donne-moi mes femmes, ainsi que mes enfants, pour lesquels je t’ai servi, et je m’en irai, car tu sais quel service j’ai fait pour toi. » ");
INSERT INTO francl_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Laban lui dit : « Si j’ai trouvé grâce à tes yeux... J’ai observé que Yahweh m’a béni à cause de toi ; ");
INSERT INTO francl_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","fixe-moi ton salaire, et je te le donnerai. » ");
INSERT INTO francl_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Jacob lui dit : « Tu sais toi-même comment je t’ai servi et ce qu’est devenu ton bétail avec moi. ");
INSERT INTO francl_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Car c’était peu de chose que ton bien avant moi ; mais il s’est extrêmement accru, et Yahweh t’a béni sur mes pas. Maintenant quand travaillerai-je aussi pour ma maison ? » ");
INSERT INTO francl_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Laban dit : « Que te donnerai-je ? » Et Jacob dit : « Tu ne me donneras rien. Si tu m’accordes ce que je vais dire, je recommencerai à paître ton troupeau et à le garder. ");
INSERT INTO francl_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Je passerai aujourd’hui à travers tout ton troupeau, en mettant à part parmi les agneaux toute bête tachetée et marquetée et toute bête noire, et parmi les chèvres tout ce qui est marqueté et tacheté : ce sera mon salaire. ");
INSERT INTO francl_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Ma droiture témoignera pour moi demain, quand tu viendras reconnaître mon salaire. Tout ce qui ne sera pas tacheté et marqueté parmi les chèvres, et noir parmi les agneaux sera chez moi un vol. ");
INSERT INTO francl_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Laban dit : « Eh bien, qu’il en soit selon ta parole. » ");
INSERT INTO francl_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Et le jour même, il mit à part les boucs rayés et marquetés, toutes les chèvres tachetées et marquetées, toutes celles qui avaient du blanc, et tout ce qui était noir parmi les agneaux ; et il les mit entre les mains de ses fils. ");
INSERT INTO francl_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Puis il mit l’espace de trois journées de chemin entre lui et Jacob. Et Jacob faisait paître le reste du troupeau de Laban. ");
INSERT INTO francl_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Jacob prit des baguettes vertes de peuplier, d’amandier et de platane ; il y pela des bandes blanches, mettant à nu le blanc qui était sur les baguettes. ");
INSERT INTO francl_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Puis il plaça les baguettes qu’il avait pelées en regard des brebis dans les rigoles, dans les abreuvoirs où les brebis venaient boire ; et elles entraient en chaleur quand elles venaient boire. ");
INSERT INTO francl_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Et les brebis, entrant en chaleur devant les baguettes, faisaient des petits rayés, tachetés et marquetés. ");
INSERT INTO francl_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Jacob mettait à part les agneaux, et il tournait la face du troupeau vers ce qui était rayé et tout ce qui était noir dans le troupeau de Laban. Il se fit ainsi des troupeaux à lui, qu’il ne joignit pas au troupeau de Laban. ");
INSERT INTO francl_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","En outre, c’était quand les brebis vigoureuses entraient en chaleur que Jacob mettait sous les yeux des brebis les baguettes dans les abreuvoirs, afin qu’elles entrassent en chaleur près des baguettes. ");
INSERT INTO francl_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Quand les brebis étaient chétives, il ne les mettait point, en sorte que les agneaux chétifs étaient pour Laban, et les vigoureux pour Jacob. ");
INSERT INTO francl_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Cet homme devint ainsi extrêmement riche ; il eut de nombreux troupeaux, des servantes et des serviteurs, des chameaux et des ânes ");
INSERT INTO francl_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Jacob entendit les propos des fils de Laban, qui disaient : « Jacob a pris tout ce qui était à notre père, et c’est avec le bien de notre père qu’il s’est fait toute cette richesse. » ");
INSERT INTO francl_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Jacob remarqua aussi le visage de Laban, et voici, il n’était plus à son égard comme auparavant. ");
INSERT INTO francl_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Et Yahweh dit à Jacob : « Retourne au pays de tes pères et au lieu de ta naissance, et je serai avec toi. » ");
INSERT INTO francl_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Alors Jacob fit dire à Rachel et à Lia de venir le trouver aux champs, où il faisait paître son troupeau. ");
INSERT INTO francl_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Il leur dit : « Je vois que le visage de votre père n’est plus le même envers moi qu’auparavant ; or le Dieu de mon père a été avec moi. ");
INSERT INTO francl_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Vous savez vous-mêmes que j’ai servi votre père de tout mon pouvoir ; ");
INSERT INTO francl_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","et votre père s’est joué de moi, changeant dix fois mon salaire ; mais Dieu ne lui a pas permis de me causer du préjudice. ");
INSERT INTO francl_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Quand il disait : Les bêtes tachetées seront ton salaire, toutes les brebis faisaient des agneaux tachetés. Et s’il disait : Les bêtes rayées seront ton salaire, toutes les brebis faisaient des agneaux rayés. ");
INSERT INTO francl_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Dieu a donc pris le bétail de votre père et me l’a donné. ");
INSERT INTO francl_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Au temps où les brebis entrent en chaleur, je levai les yeux et je vis en songe que les béliers qui couvraient les brebis étaient rayés, tachetés et marquetés. ");
INSERT INTO francl_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Et un ange de Dieu me dit en songe : Jacob ! Je répondis : Me voici. ");
INSERT INTO francl_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Et il dit : Lève les yeux et regarde : tous les béliers qui couvrent les brebis sont rayés, tachetés et marquetés ; car j’ai vu tout ce que t’a fait Laban. ");
INSERT INTO francl_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Je suis le Dieu de Béthel, où tu as oint un monument, où tu m’as fait un vœu. Maintenant lève-toi, sors de ce pays et retourne au pays de ta naissance. » ");
INSERT INTO francl_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Rachel et Lia répondirent en disant :  « Est-ce que nous avons encore une part et un héritage dans la maison de notre père ? ");
INSERT INTO francl_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Ne sommes-nous pas regardées par lui comme des étrangères, puisqu’il nous a vendues et qu’il mange notre argent ? ");
INSERT INTO francl_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","D’ailleurs tout le bien que Dieu a enlevé à notre père, nous l’avons, nous et nos enfants. Fais donc maintenant ce que Dieu t’a ordonné. » ");
INSERT INTO francl_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Jacob se leva et fit monter ses enfants et ses femmes sur les chameaux. ");
INSERT INTO francl_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Il emmena tout son troupeau et tout le bien qu’il avait acquis, le troupeau qu’il possédait, qu’il avait acquis à Paddan-Aram ; et il s’en alla vers Isaac, son père, au pays de Canaan. ");
INSERT INTO francl_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Comme Laban était allé tondre ses brebis, Rachel déroba les théraphim de son père. ");
INSERT INTO francl_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Et Jacob trompa Laban, l’Araméen, en ne l’informant pas de sa fuite. ");
INSERT INTO francl_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Il s’enfuit, lui et tout ce qui lui appartenait et, s’étant levé, il traversa le fleuve et se dirigea vers la montagne de Galaad. ");
INSERT INTO francl_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Le troisième jour, on annonça à Laban que Jacob s’était enfui. ");
INSERT INTO francl_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Il prit avec lui ses frères et le poursuivit pendant sept journées de chemin ; il l’atteignit à la montagne de Galaad. ");
INSERT INTO francl_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Et Dieu vint en songe, de nuit, vers Laban l’Araméen, et il lui dit : « Garde-toi de rien dire à Jacob, ni en bien ni en mal. » ");
INSERT INTO francl_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Laban atteignit donc Jacob. — Jacob avait dressé sa tente sur la montagne, et Laban avait aussi dressé la sienne, avec ses frères, sur la montagne de Galaad. ");
INSERT INTO francl_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Laban dit à Jacob : « Qu’as-tu fait ? tu as abusé mon esprit et tu as emmené mes filles comme des captives prises par l’épée ? ");
INSERT INTO francl_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Pourquoi as-tu pris secrètement la fuite et m’as-tu trompé, au lieu de m’avertir, moi qui t’aurais laissé aller dans l’allégresse des chants, au son du tambourin et de la harpe ? ");
INSERT INTO francl_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Tu ne m’as pas laissé embrasser mes fils et mes filles ! Vraiment tu as agi en insensé. ");
INSERT INTO francl_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Ma main est assez forte pour vous faire du mal ; mais le Dieu de votre père m’a parlé cette nuit en disant : Garde-toi de rien dire à Jacob, ni en bien ni en mal. ");
INSERT INTO francl_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Et maintenant, tu es parti parce que tu languissais après la maison de ton père ; mais, pourquoi as-tu dérobé mes dieux ? » ");
INSERT INTO francl_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Jacob répondit et dit à Laban : « C’est que j’avais de la crainte, en me disant que peut-être tu m’enlèverais tes filles. ");
INSERT INTO francl_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Quant à celui chez qui tu trouveras tes dieux, il ne vivra pas ! En présence de nos frères, reconnais ce qui t’appartient chez moi et prends-le. » — Or Jacob ignorait que Rachel les eût dérobés. — ");
INSERT INTO francl_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Laban entra dans la tente de Jacob, dans la tente de Lia et dans la tente des deux servantes, et il ne trouva rien. Puis il sortit de la tente de Lia et entra dans la tente de Rachel. ");
INSERT INTO francl_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Rachel avait pris les théraphim, les avait mis dans la selle du chameau et s’était assise dessus. Laban fouilla toute la tente, sans rien trouver. ");
INSERT INTO francl_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Et Rachel dit à son père : « Que mon seigneur ne s’irrite pas de ce que je ne puis me lever devant toi, car j’ai ce qui est ordinaire aux femmes. » Il chercha, mais ne trouva pas les théraphim. ");
INSERT INTO francl_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Jacob se mit en colère et adressa des reproches à Laban ; et Jacob prit la parole et dit à Laban : « Quel est mon crime, quelle est ma faute, que tu t’acharnes après moi ? ");
INSERT INTO francl_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Quand tu as fouillé tous mes effets, qu’as-tu trouvé des effets de ta maison ? Produis-le ici devant mes frères et tes frères, et qu’ils soient juges entre nous deux. ");
INSERT INTO francl_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Voilà vingt ans que j’ai passés chez toi ; tes brebis et tes chèvres n’ont pas avorté, et je n’ai pas mangé les béliers de ton troupeau. ");
INSERT INTO francl_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Ce qui était déchiré par les bêtes sauvages, je ne te l’ai pas rapporté ; c’est moi qui en ai supporté la perte. Tu me réclamais ce qui avait été dérobé de jour et ce qui avait été dérobé de nuit. ");
INSERT INTO francl_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","J’étais dévoré le jour par la chaleur, et la nuit par le froid, et mon sommeil fuyait de mes yeux. ");
INSERT INTO francl_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Voilà vingt ans que je suis dans ta maison ; je t’ai servi quatorze ans pour tes deux filles et six ans pour ton bétail, et tu as changé mon salaire dix fois. ");
INSERT INTO francl_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Si le Dieu de mon père, le Dieu d’Abraham et la Terreur d’Isaac n’eût pas été pour moi, tu m’aurais maintenant laissé partir à vide. Dieu a vu ma souffrance et le travail de mes mains, et cette nuit il a jugé entre nous. » ");
INSERT INTO francl_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Laban répondit et dit à Jacob : « Ces filles sont mes filles, ces enfants mes enfants, ces troupeaux mes troupeaux, et tout ce que tu vois est à moi. Que ferais-je aujourd’hui à mes filles, à elles et aux fils qu’elles ont enfantés ? ");
INSERT INTO francl_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Maintenant donc, viens, faisons alliance, moi et toi, et qu’il y ait un témoin entre moi et toi. ");
INSERT INTO francl_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Jacob prit une pierre et la dressa pour monument. ");
INSERT INTO francl_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Et Jacob dit à ses frères : « Amassez des pierres. » Ils prirent des pierres et en firent un monceau, et ils mangèrent là sur le monceau. ");
INSERT INTO francl_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laban l’appela Yegar-Sahadutha, et Jacob l’appela Galaad. ");
INSERT INTO francl_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Et Laban dit : « Ce monceau est témoin entre moi et toi aujourd’hui. » C’est pourquoi on lui donna le nom de Galaad, ");
INSERT INTO francl_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","et aussi celui de Mitspa, parce que Laban dit : « Que Yahweh nous surveille, moi et toi, quand nous serons séparés l’un de l’autre. ");
INSERT INTO francl_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Si tu maltraites mes filles et si tu prends d’autres femmes à côté de mes filles, ce n’est pas un homme qui sera avec nous ; mais, prends-y garde, c’est Dieu qui sera témoin entre moi et toi. » ");
INSERT INTO francl_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Laban dit encore à Jacob : « Voici ce monceau et voici le monument que j’ai dressé entre moi et toi. ");
INSERT INTO francl_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Ce monceau est témoin et ce monument est témoin que je n’avancerai pas vers toi au delà de ce monceau, et que tu n’avanceras pas vers moi au delà de ce monceau et de ce monument, pour faire du mal. ");
INSERT INTO francl_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Que le Dieu d’Abraham, le Dieu de Nachor et le Dieu de leurs pères soient juges entre nous ! » Et Jacob jura par la Terreur d’Isaac. ");
INSERT INTO francl_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Et Jacob offrit un sacrifice sur la montagne, et il invita ses frères au repas. Ils mangèrent donc et passèrent la nuit sur la montagne. ");
INSERT INTO francl_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Laban se leva de bon matin ; il baisa ses fils et ses filles et les bénit ; puis il partit, pour retourner dans sa maison. ");
INSERT INTO francl_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Jacob poursuivit son chemin, et des anges de Dieu le rencontrèrent. ");
INSERT INTO francl_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","En les voyant, il dit : « C’est le camp de Dieu ! » et il donna à ce lieu le nom de Mahanaïm. ");
INSERT INTO francl_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Jacob envoya devant lui des messagers vers Esaü, son frère, au pays de Seïr, dans la campagne d’Edom. ");
INSERT INTO francl_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Il leur donna cet ordre : « Voici ce que vous direz à mon seigneur, à Esaü : Ainsi parle ton serviteur Jacob : J’ai séjourné chez Laban et j’y suis resté jusqu’à présent, ");
INSERT INTO francl_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","J’ai des bœufs et des ânes, des brebis, des serviteurs et des servantes, et j’en fais informer mon seigneur, pour trouver grâce à tes yeux. » ");
INSERT INTO francl_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Les messagers revinrent auprès de Jacob en disant : « Nous sommes allés vers ton frère Esaü, et il marche à ta rencontre avec quatre cents hommes. » ");
INSERT INTO francl_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Jacob eut une grande frayeur et fut dans l’angoisse. Il partagea en deux camps les gens qui étaient avec lui, les brebis les bœufs et les chameaux, ");
INSERT INTO francl_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","et il dit : « Si Esaü rencontre l’un des camps et le frappe, le camp qui restera pourra être sauvé. » ");
INSERT INTO francl_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Jacob dit : « Dieu de mon père Abraham, Dieu de mon père Isaac, Yahweh, qui m’avez dit : Retourne en ton pays et au lieu de ta naissance, et je te ferai du bien : ");
INSERT INTO francl_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","je suis trop petit pour toutes les grâces et pour toute la fidélité dont vous avez usé envers votre serviteur ; car j’ai passé ce Jourdain avec mon bâton, et maintenant je suis devenu deux camps. ");
INSERT INTO francl_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Délivrez-moi, je vous prie, de la main de mon frère, de la main d’Esaü ; car je crains qu’il ne vienne me frapper, la mère avec les enfants. ");
INSERT INTO francl_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Et vous, vous avez dit : Je te ferai du bien et je rendrai ta postérité pareille au sable de la mer, si nombreux qu’on ne peut le compter. » ");
INSERT INTO francl_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Jacob passa là cette nuit. Et il prit de ce qu’il avait sous la main, pour faire un présent à Esaü, son frère : ");
INSERT INTO francl_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","deux cents chèvres et vingt boucs, deux cents brebis et vingt béliers, ");
INSERT INTO francl_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","trente chamelles qui allaitaient, avec leurs petits, quarante vaches et dix taureaux, vingt ânesses et dix ânons. ");
INSERT INTO francl_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Il les remit à ses serviteurs, chaque troupeau à part, et il leur dit : « Passez devant moi, et laissez un intervalle entre chaque troupeau. » ");
INSERT INTO francl_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Et il donna ordre au premier : « Quand Esaü, mon frère, te rencontrera et te demandera : A qui es-tu, où vas-tu, à qui appartient ce troupeau qui va devant toi ? ");
INSERT INTO francl_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","tu répondras : A ton serviteur Jacob ; c’est un présent qu’il envoie à mon seigneur, à Esaü ; et voici que lui-même vient derrière nous. » ");
INSERT INTO francl_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Il donna le même ordre au second, au troisième et à tous ceux qui suivaient les troupeaux, en disant : « Vous parlerez ainsi à Esaü quand vous le rencontrerez ; ");
INSERT INTO francl_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","vous direz : Voici, ton serviteur Jacob vient aussi derrière nous. » Car il se disait : « Je l’apaiserai par ce présent qui va devant moi, et ensuite je verrai sa face ; peut-être me fera-t-il bon accueil. » ");
INSERT INTO francl_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Le présent passa devant lui, et il resta cette nuit-là dans le camp. ");
INSERT INTO francl_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Il se leva dans la même nuit et, ayant pris ses deux femmes, ses deux servantes et ses onze enfants, il passa le gué du Jaboc. ");
INSERT INTO francl_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Il les prit et leur fit passer le torrent ; il fit aussi passer ce qui lui appartenait. ");
INSERT INTO francl_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Jacob resta seul ; et un homme lutta avec lui jusqu’au lever de l’aurore. ");
INSERT INTO francl_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Voyant qu’il ne pouvait le vaincre, il le toucha à l’articulation de la hanche, et l’articulation de la hanche de Jacob se démit pendant qu’il luttait avec lui. ");
INSERT INTO francl_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Et il dit à Jacob : « Laisse-moi aller, car l’aurore se lève. » Jacob répondit : « Je ne te laisserai pas aller que tu ne m’aies béni. » ");
INSERT INTO francl_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Il lui dit : « Quel est ton nom ? » Il répondit : « Jacob. » ");
INSERT INTO francl_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Et il dit : « Ton nom ne sera plus Jacob, mais Israël, car tu as combattu avec Dieu et avec des hommes, et tu l’as emporté. » ");
INSERT INTO francl_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Jacob l’interrogea, en disant : « Fais-moi, je te prie, connaître ton nom. » Il dit : « Pourquoi demandes-tu quel est mon nom ? » Et il le bénit là. ");
INSERT INTO francl_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Jacob nomma ce lieu Phanuel ; « car, dit-il, j’ai vu Dieu face à face, et ma vie a été sauve. » ");
INSERT INTO francl_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Et le soleil se leva quand il eut passé Phanuel, mais il boitait de la hanche. ");
INSERT INTO francl_vpl VALUES ("GN32_33","002_32_33","GEN","32","33","33","C’est pourquoi les enfants d’Israël ne mangent pas jusqu’à ce jour le grand nerf qui est à l’articulation de la hanche, parce que Dieu a touché l’articulation de la hanche de Jacob au grand nerf. ");
INSERT INTO francl_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Jacob leva les yeux et regarda, et voici, Esaü venait, ayant avec lui quatre cents hommes. Ayant distribué les enfants par groupes auprès de Lia, auprès de Rachel et auprès des deux servantes, ");
INSERT INTO francl_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","il plaça en tête les servantes avec leurs enfants, puis Lia avec ses enfants, et enfin Rachel avec Joseph. ");
INSERT INTO francl_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Lui-même passa devant eux, et il se courba vers la terre sept fois, jusqu’à ce qu’il fût proche de son frère Esaü. ");
INSERT INTO francl_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Esaü courut à sa rencontre, l’embrassa, se jeta à son cou et le baisa ; et ils pleurèrent. ");
INSERT INTO francl_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Puis, levant les yeux, Esaü vit les femmes et les enfants, et il dit : « Qui sont ceux que tu as là ? » Jacob répondit : « Ce sont les enfants que Dieu a accordés à ton serviteur. » ");
INSERT INTO francl_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Les servantes s’approchèrent, elles et leurs enfants, et se prosternèrent. ");
INSERT INTO francl_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Lia et ses enfants s’approchèrent aussi, et ils se prosternèrent ; ensuite s’approchèrent Joseph et Rachel, et ils se prosternèrent. ");
INSERT INTO francl_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Et Esaü dit : « Que veux-tu faire avec tout ce camp que j’ai rencontré ? » Et Jacob dit : « C’est pour trouver grâce aux yeux de mon seigneur. » ");
INSERT INTO francl_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Esaü dit : « Je suis dans l’abondance, mon frère ; garde ce qui est à toi. » ");
INSERT INTO francl_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Et Jacob dit : « Non, je te prie, si j’ai trouvé grâce à tes yeux, accepte mon présent de ma main ; car c’est pour cela que j’ai vu ta face comme on voit la face de Dieu, et tu m’as accueilli favorablement. ");
INSERT INTO francl_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Accepte donc mon offrande qui t’a été amenée, car Dieu m’a accordé sa faveur et je ne manque de rien. » Il le pressa si bien qu’Esaü accepta. ");
INSERT INTO francl_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Esaü dit : « Partons, mettons-nous en route ; je marcherai devant toi. » ");
INSERT INTO francl_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Jacob répondit : « Mon seigneur sait que les enfants sont délicats, et que je suis chargé de brebis et de vaches qui allaitent ; si on les pressait un seul jour, tout le troupeau périrait. ");
INSERT INTO francl_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Que mon seigneur prenne les devants sur son serviteur, et moi, je suivrai doucement, au pas du troupeau qui marche devant moi, et au pas des enfants, jusqu’à ce que j’arrive chez mon seigneur, à Séir. » ");
INSERT INTO francl_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Esaü dit : « Permets du moins que je laisse auprès de toi une partie des gens qui sont avec moi. » Jacob répondit : « Pourquoi cela ? Que je trouve grâce aux yeux de mon seigneur. » ");
INSERT INTO francl_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Et Esaü reprit ce jour-là le chemin de Séir. ");
INSERT INTO francl_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Jacob partit pour Socoth et il se construisit une maison. Il fit aussi des cabanes pour ses troupeaux ; c’est pourquoi on a appelé ce lieu Socoth. ");
INSERT INTO francl_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","A son retour de Paddan-Aram, Jacob arriva heureusement à la ville de Sichem, au pays de Canaan, et il campa devant la ville. ");
INSERT INTO francl_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Il acheta des fils de Hémor, père de Sichem, pour cent késitas, la pièce de terre où il avait dressé sa tente ; ");
INSERT INTO francl_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","il éleva là un autel, et l’appela El-Elohé-Israël. ");
INSERT INTO francl_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Dina, la fille que Lia avait enfantée à Jacob, sortit pour voir les filles du pays. ");
INSERT INTO francl_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Sichem, fils de Hémor, le Hévéen, prince du pays, l’ayant aperçue, l’enleva, coucha avec elle et lui fit violence. ");
INSERT INTO francl_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Son âme s’attacha à Dina, fille de Jacob ; il aima la jeune fille et parla au cœur de la jeune fille. ");
INSERT INTO francl_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Et Sichem dit à Hémor, son père : « Prends-moi cette jeune fille pour femme. » ");
INSERT INTO francl_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Or Jacob apprit qu’il avait outragé Dina, sa fille ; mais, comme ses fils étaient aux champs avec son troupeau, Jacob garda le silence jusqu’à leur retour. ");
INSERT INTO francl_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Hémor, père de Sichem, sortit vers Jacob, pour lui parler. ");
INSERT INTO francl_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Or les fils de Jacob étaient revenus des champs quand ils apprirent la chose ; ces hommes furent outrés et entrèrent en une grande colère, parce que Sichem avait commis une infamie contre Israël, en couchant avec la fille de Jacob, ce qui ne devait pas se faire. ");
INSERT INTO francl_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Hémor leur parla ainsi : « L’âme de Sichem, mon fils, s’est attachée à votre fille ; donnez-la-lui pour femme, je vous prie. ");
INSERT INTO francl_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Alliez-vous avec nous ; vous nous donnerez vos filles, et vous prendrez pour vous les nôtres. ");
INSERT INTO francl_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Vous habiterez chez nous, et le pays sera à votre disposition, pour vous y établir, y trafiquer et y acquérir des propriétés. » ");
INSERT INTO francl_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Sichem dit au père et aux frères de Dina : « Que je trouve grâce à vos yeux, et je donnerai ce que vous me direz. ");
INSERT INTO francl_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Exigez de moi un fort prix d’achat et de grands présents, et ce que vous me direz, je le donnerai ; mais donnez-moi la jeune fille pour femme. » ");
INSERT INTO francl_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Les fils de Jacob, répondirent et parlèrent avec ruse à Sichem et à Hémor, son père, parce que Sichem avait déshonoré Dina, leur sœur ; ");
INSERT INTO francl_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","ils leur dirent : « C’est une chose que nous ne pouvons pas faire que de donner notre sœur à un homme non circoncis, car ce serait un opprobre pour nous. ");
INSERT INTO francl_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Nous ne consentirons à votre désir qu’à la condition que vous deveniez comme nous, et que tout mâle parmi vous soit circoncis. ");
INSERT INTO francl_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Ainsi nous vous donnerons nos filles, et nous prendrons pour nous les vôtres ; nous habiterons avec vous et nous formerons un seul peuple. ");
INSERT INTO francl_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Mais si vous ne voulez pas nous écouter et vous circoncire, nous reprendrons notre fille et nous nous en irons. » ");
INSERT INTO francl_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Leurs paroles plurent à Hémor et à Sichem, fils de Hémor ; ");
INSERT INTO francl_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","et le jeune homme ne tarda pas à faire la chose, car il était épris de la fille de Jacob, et il était l’homme le plus considéré de la maison de son père. ");
INSERT INTO francl_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Hémor et Sichem, son fils, se rendirent donc à la porte de la ville, et ils parlèrent aux hommes de leur ville, en disant : ");
INSERT INTO francl_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","« Ces gens-là sont des hommes pacifiques au milieu de nous ; qu’ils s’établissent dans le pays et qu’ils y trafiquent ; voici que le pays, à droite et à gauche, est assez vaste pour eux. Nous prendrons leurs filles pour femmes, et nous leur donnerons nos filles. ");
INSERT INTO francl_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Mais ces hommes ne consentiront à habiter avec nous, pour devenir un même peuple, qu’à une condition, c’est que tout mâle parmi nous soit circoncis, comme ils sont eux-mêmes circoncis. ");
INSERT INTO francl_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Leurs troupeaux et leurs biens et toutes leurs bêtes de somme ne seront-ils pas à nous ? Seulement, accédons à leur désir et qu’ils s’établissent chez nous. » ");
INSERT INTO francl_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Tous ceux qui sortaient par la porte de la ville écoutèrent Hémor et Sichem, son fils, et tout mâle fut circoncis, tout homme sortant par la porte de la ville. ");
INSERT INTO francl_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Le troisième jour, lorsqu’ils étaient souffrants, deux fils de Jacob, Siméon et Lévi, frères de Dina, prirent chacun leur épée, marchèrent sans crainte sur la ville et tuèrent tous les mâles. ");
INSERT INTO francl_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Ils passèrent aussi au fil de l’épée Hémor et Sichem, son fils ; et, ayant enlevé Dina de la maison de Sichem, ils sortirent. ");
INSERT INTO francl_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Les fils de Jacob se jetèrent sur les morts et pillèrent la ville, parce qu’on avait déshonoré leur sœur. ");
INSERT INTO francl_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Ils prirent leurs brebis, leurs bœufs et leurs ânes, ce qui était dans la ville et ce qui était dans les champs. ");
INSERT INTO francl_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Ils emmenèrent comme butin tous leurs biens, leurs enfants et leurs femmes, et tout ce qui se trouvait dans les maisons. ");
INSERT INTO francl_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Alors Jacob dit à Siméon et à Lévi : « Vous m’avez troublé, en me rendant odieux aux habitants du pays, aux Chananéens et aux Phérézéens. Je n’ai avec moi que peu de gens ; ils s’assembleront contre moi et me tueront, et je serai détruit, moi et ma maison. » ");
INSERT INTO francl_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Ils répondirent : « Traitera-t-on notre sœur comme une prostituée ? » ");
INSERT INTO francl_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Dieu dit à Jacob : « Lève-toi, monte à Béthel et demeures-y, et dresse là un autel au Dieu qui t’est apparu quand tu fuyais devant Esaü, ton frère. » ");
INSERT INTO francl_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Jacob dit à sa famille et à tous ceux qui étaient avec lui : « Otez les dieux étrangers qui sont au milieu de vous ; purifiez-vous et changez de vêtements. ");
INSERT INTO francl_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Nous nous lèverons et nous monterons à Béthel, et là je dresserai un autel au Dieu qui m’a exaucé au jour de mon angoisse, et qui a été avec moi, dans le voyage que j’ai fait. » ");
INSERT INTO francl_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Et ils donnèrent à Jacob tous les dieux étrangers qui étaient entre leurs mains et les boucles qu’ils avaient aux oreilles, et Jacob les enfouit sous le térébinthe qui est à Sichem. ");
INSERT INTO francl_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Ils partirent, et la terreur de Dieu se répandit sur les villes d’alentour, et on ne poursuivit pas les fils de Jacob. ");
INSERT INTO francl_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Jacob, avec tous les gens qui étaient avec lui, arriva à Luz, au pays de Canaan : c’est Béthel. ");
INSERT INTO francl_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Il y bâtit un autel, et il appela ce lieu El-Béthel, car c’est là que Dieu lui était apparu lorsqu’il fuyait devant son frère. ");
INSERT INTO francl_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Alors mourut Débora, nourrice de Rebecca, et elle fut enterrée au-dessous de Béthel, au pied du chêne auquel on donna le nom de Chêne des pleurs. ");
INSERT INTO francl_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Dieu apparut encore à Jacob, après son retour de Paddan-Aram, et il le bénit. ");
INSERT INTO francl_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Dieu lui dit : « Ton nom est Jacob ; tu ne seras plus appelé Jacob, mais Israël sera ton nom. » Et il le nomma Israël. ");
INSERT INTO francl_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Dieu lui dit : « Je suis le Dieu tout-puissant. Sois fécond et multiplie ; il naîtra de toi une nation et une assemblée de nations, et de tes reins sortiront des rois. ");
INSERT INTO francl_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Le pays que j’ai donné à Abraham et à Isaac, je te le donnerai, et je donnerai ce pays à ta postérité après toi. » ");
INSERT INTO francl_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Et Dieu remonta d’auprès de lui, dans le lieu où il lui avait parlé. ");
INSERT INTO francl_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Et dans le lieu où il lui avait parlé, Jacob dressa un monument de pierre, sur lequel il fit une libation et versa de l’huile. ");
INSERT INTO francl_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Il donna le nom de Béthel au lieu où Dieu lui avait parlé. ");
INSERT INTO francl_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Ils partirent de Béthel. Il y avait encore une certaine distance avant d’arriver à Ephrata, lorsque Rachel enfanta, et son accouchement fut pénible. ");
INSERT INTO francl_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Pendant les douleurs de l’enfantement, la sage-femme lui dit : « Ne crains point, car c’est encore un fils que tu vas avoir. » ");
INSERT INTO francl_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Comme son âme s’en allait, — car elle était mourante, — elle le nomma Bénoni ; mais son père l’appela Benjamin. ");
INSERT INTO francl_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Rachel mourut, et elle fut enterrée au chemin d’Ephrata, qui est Bethléem. ");
INSERT INTO francl_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Jacob éleva un monument sur sa tombe ; c’est le monument de la Tombe de Rachel, qui subsiste encore aujourd’hui. ");
INSERT INTO francl_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Israël partit, et il dressa sa tente au delà de Migdal-Eder. ");
INSERT INTO francl_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Pendant qu’Israël demeurait dans cette contrée, Ruben vint et coucha avec Bala, concubine de son père ; et Israël l’apprit. Les fils de Jacob étaient au nombre de douze. ");
INSERT INTO francl_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Fils de Lia : Ruben, premier-né de Jacob, Siméon, Lévi, Juda, Issachar et Zabulon. ");
INSERT INTO francl_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Fils de Rachel : Joseph et Benjamin. ");
INSERT INTO francl_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Fils de Bala, servante de Rachel : Dan et Nephthali. ");
INSERT INTO francl_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Fils de Zelpha, servante de Lia : Gad et Aser. Ce sont là les fils de Jacob, qui lui naquirent à Paddan-Aram. ");
INSERT INTO francl_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Jacob arriva auprès d’Isaac, son père, à Mambré, à Qiryath-Arbé, qui est Hébron, où avaient séjourné Abraham et Isaac. ");
INSERT INTO francl_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Les jours d’Isaac furent de cent quatre-vingts ans. ");
INSERT INTO francl_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Isaac expira et mourut, et il fut réuni à son peuple, vieux et rassasié de jours. Esaü et Jacob, ses fils, l’enterrèrent. ");
INSERT INTO francl_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Voici l’histoire d’Esaü, qui est Edom. ");
INSERT INTO francl_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esaü prit ses femmes parmi les filles de Canaan : Ada, fille d’Elon, le Hittite ; Oolibama, fille d’Ana, fille de Sébéon, le Hévéen ; ");
INSERT INTO francl_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","et Basemath, fille d’Ismaël, sœur de Nabaïoth. ");
INSERT INTO francl_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada enfanta à Esaü Eliphaz, Basemath enfanta Rahuel, ");
INSERT INTO francl_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","et Oolibama enfanta Jéhus, Ihélon et Coré. Ce sont là les fils d’Esaü, qui lui naquirent au pays de Canaan. ");
INSERT INTO francl_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Esaü prit ses femmes, ses fils et ses filles, et toutes les personnes de sa maison, ses troupeaux, tout son bétail et tous les biens qu’il avait acquis dans le pays de Canaan, et il s’en alla dans un autre pays, loin de Jacob, son frère. ");
INSERT INTO francl_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Car leurs biens étaient trop considérables pour qu’ils demeurassent ensemble, et le pays où ils séjournaient ne pouvait leur suffire à cause de leurs troupeaux. ");
INSERT INTO francl_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Esaü s’établit dans la montagne de Séir ; Esaü est Edom. ");
INSERT INTO francl_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Voici la postérité d’Esaü, père d’Edom, dans la montagne de Séir. ");
INSERT INTO francl_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Voici les noms des fils d’Esaü : Eliphaz, fils d’Ada, femme d’Esaü ; Rahuel, fils de Basemath, femme d’Esaü. — ");
INSERT INTO francl_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Les fils d’Eliphaz furent : Théman, Omar, Sépho, Gatham et Cénez. ");
INSERT INTO francl_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Thamna fut concubine d’Eliphaz, fils d’Esaü, et elle enfanta Amalech à Eliphaz. Ce sont là les fils d’Ada, femme d’Esaü. — ");
INSERT INTO francl_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Voici les fils de Rahuel : Nahath, Zara, Samma et Méza. Ce sont là les fils de Basemath, femme d’Esaü. — ");
INSERT INTO francl_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Voici les fils d’Oolibama, fille d’Ana, fille de Sébéon, femme d’Esaü : elle enfanta à Esaü Jéhus, Ihélon et Coré. ");
INSERT INTO francl_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Voici les chefs des tribus issues des fils d’Esaü. Fils d’Eliphaz, premier-né d’Esaü : le chef Théman, le chef Omar, le chef Sépho, le chef Cénez, ");
INSERT INTO francl_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","le chef Coré, le chef Gatham, le chef Amalech. Ce sont là les chefs issus d’Eliphaz, au pays d’Edom ; ce sont là les fils d’Ada. — ");
INSERT INTO francl_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Fils de Rahuel, fils d’Esaü : le chef Nahath, le chef Zara, le chef Samma et le chef Méza. Ce sont là les chefs issus de Rahuel, au pays d’Edom ; ce sont là les fils de Basemath, femme d’Esaü. — ");
INSERT INTO francl_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Fils d’Oolibama, femme d’Esaü : le chef Jéhus, le chef Ihélon et le chef Coré. Ce sont là les chefs issus d’Oolibama, fille d’Ana et femme d’Esaü. — ");
INSERT INTO francl_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Ce sont là les fils d’Esaü, et ce sont là leurs chefs ; c’est Edom. ");
INSERT INTO francl_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Voici les fils de Séir, le Horréen, qui habitaient le pays : Lotan, Sobal, Sébéon, Ana, ");
INSERT INTO francl_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dison, Eser et Disan. Ce sont là les chefs des Horréens, fils de Séir, au pays d’Edom. — ");
INSERT INTO francl_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Les fils de Lotan furent Hori et Héman, et Thamma était sœur de Lotan. — ");
INSERT INTO francl_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Voici les fils de Sobal : Alvan, Manahat, Ebal, Sépho et Onam. — ");
INSERT INTO francl_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Voici les fils de Sébéon : Aja et Ana. C’est cet Ana qui trouva les sources chaudes dans le désert, en faisant paître les ânes de Sébéon, son père. — ");
INSERT INTO francl_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Voici les enfants d’Ana : Dison et Oolibama, fille d’Ana. — ");
INSERT INTO francl_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Voici les fils de Dison : Hamdan, Eséban, Jéthram et Charan. — ");
INSERT INTO francl_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Voici les fils d’Eser : Balan, Zavan et Acan. — ");
INSERT INTO francl_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Voici les fils de Disan : Hus et Aram. ");
INSERT INTO francl_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Voici les chefs des Horréens : le chef Lotan, le chef Sobal, le chef Sébéon, le chef Ana, ");
INSERT INTO francl_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","le chef Dison, le chef Eser, le chef Disan. Ce sont là les chefs des Horréens, chacun de leurs chefs au pays de Séir. ");
INSERT INTO francl_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Voici les rois qui ont régné dans le pays d’Edom, avant qu’un roi régnât sur les enfants d’Israël : ");
INSERT INTO francl_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Béla, fils de Béor, régna en Edom, et le nom de sa ville était Denaba. — ");
INSERT INTO francl_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Béla mourut, et à sa place régna Jobab, fils de Zara, de Bosra. — ");
INSERT INTO francl_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Jobab mourut, et à sa place régna Husam, du pays des Thémanites. — ");
INSERT INTO francl_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Husam mourut, et à sa place régna Adad, fils de Badad, qui défit Madian dans les champs de Moab ; le nom de sa ville était Avith. — ");
INSERT INTO francl_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadad mourut, et à sa place régna Semla, de Masréca. — ");
INSERT INTO francl_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Semla mourut, et à sa place régna Saül, de Rohoboth sur le fleuve. — ");
INSERT INTO francl_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Saül mourut, et à sa place régna Balanan, fils d’Achor. — ");
INSERT INTO francl_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Balanan, fils d’Achor, mourut, et à sa place régna Hadar ; le nom de sa ville était Phaü, et le nom de sa femme Méétabel, fille de Matred, fille de Mézaab. ");
INSERT INTO francl_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Voici les noms des chefs issus d’Esaü, selon leurs tribus, leurs territoires et d’après leurs noms : le chef Thamma, le chef Alva, le chef Jétheth, ");
INSERT INTO francl_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","le chef Oolibama, le chef Ela, le chef Phinon, ");
INSERT INTO francl_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","le chef Cénez, le chef Théman, le chef Mabsar, ");
INSERT INTO francl_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","le chef Magdiel, le chef Hiram. Ce sont là les chefs d’Edom, selon leurs demeures dans le pays qu’ils occupent. C’est là Esaü, père d’Edom. ");
INSERT INTO francl_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jacob s’établit dans le pays où son père avait séjourné dans le pays de Canaan. ");
INSERT INTO francl_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Voici l’histoire de Jacob. Joseph, âgé de dix-sept ans, faisait paître les brebis avec ses frères ; comme il était encore jeune, il se trouvait avec les fils de Bala et avec les fils de Zelpha, femmes de son père ; et Joseph rapporta à leur père de mauvais bruits qui couraient sur leur compte. ");
INSERT INTO francl_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Or Israël aimait Joseph plus que tous ses autres fils, parce que c’était un fils de sa vieillesse ; et il lui fit une robe longue. ");
INSERT INTO francl_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Ses frères, voyant que leur père l’aimait plus qu’eux tous, le prirent en haine, et ils ne pouvaient plus lui parler amicalement. ");
INSERT INTO francl_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Joseph eut un songe, et il le raconta à ses frères, qui le haïrent encore davantage. ");
INSERT INTO francl_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Il leur dit : « Ecoutez, je vous prie, le songe que j’ai eu : ");
INSERT INTO francl_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Nous étions à lier des gerbes au milieu des champs ; et voici, ma gerbe s’est levée et s’est tenue debout, et vos gerbes l’ont entourée et se sont prosternées devant elle. » ");
INSERT INTO francl_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Ses frères lui dirent : « Est-ce que tu régneras sur nous ? est-ce que tu nous domineras ? » Et ils le haïrent encore davantage pour ses songes et pour ses paroles. ");
INSERT INTO francl_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Il eut encore un autre songe, qu’il raconta à ses frères. Il dit : « J’ai eu encore un songe : le soleil, la lune et onze étoiles se prosternaient devant moi. » ");
INSERT INTO francl_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Il le raconta à son père et à ses frères, et son père le réprimanda, en disant : « Que signifie ce songe que tu as eu ? Faudra-t-il que nous venions, moi, ta mère et tes frères, nous prosterner à terre devant toi ? » ");
INSERT INTO francl_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Et ses frères furent jaloux de lui, mais son père conservait la chose dans son cœur. ");
INSERT INTO francl_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Les frères de Joseph allèrent paître les troupeaux de leur père à Sichem. ");
INSERT INTO francl_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Et Israël dit à Joseph : « Tes frères ne paissent-ils pas le troupeau à Sichem ? Viens, que je t’envoie vers eux. » Il répondit : « Me voici. » ");
INSERT INTO francl_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Et Israël lui dit : « Va donc, et vois si tes frères vont bien et si le troupeau est en bon état, et tu m’en apporteras des nouvelles. » Et il l’envoya de la vallée d’Hébron, et Joseph alla à Sichem. ");
INSERT INTO francl_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Un homme, l’ayant rencontré errant dans la campagne, le questionna, en disant : « Que cherches-tu ? » ");
INSERT INTO francl_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Il répondit : « Je cherche mes frères ; indique-moi, je te prie, où ils font paître leur troupeau. » ");
INSERT INTO francl_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Et l’homme dit : « Ils sont partis d’ici ; car je les ai entendus dire : Allons à Dothaïn. » Joseph alla après ses frères, et il les trouva à Dothaïn. ");
INSERT INTO francl_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Ils l’aperçurent de loin et, avant qu’il fût près d’eux, ils complotèrent de le faire mourir. ");
INSERT INTO francl_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Ils se dirent l’un à l’autre : « Voici l’homme aux songes ; c’est bien lui qui arrive. ");
INSERT INTO francl_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Venez donc, tuons-le et jetons-le dans une des citernes, et nous dirons qu’une bête féroce l’a dévoré ; nous verrons ce qui en sera de ses songes ! » ");
INSERT INTO francl_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Ruben entendit et il le délivra de leurs mains. Il dit : « Ne le frappons pas à mort. » ");
INSERT INTO francl_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Ruben leur dit : « Ne versez pas le sang ; jetez-le dans cette citerne qui est dans le désert, et ne portez pas la main sur lui. » — Son dessein était de le délivrer de leurs mains, pour le faire retourner vers son père. — ");
INSERT INTO francl_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Lorsque Joseph arriva auprès de ses frères, ils le dépouillèrent de sa robe, de la robe longue qu’il portait ; ");
INSERT INTO francl_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","et, l’ayant pris, ils le jetèrent dans la citerne. Cette citerne était vide : il n’y avait pas d’eau. ");
INSERT INTO francl_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Puis ils s’assirent pour manger. Levant les yeux, ils virent, et voici qu’une caravane d’Ismaélites venait de Galaad ; leurs chameaux étaient chargés d’astragale, de baume et de ladanum, qu’ils transportaient en Égypte. ");
INSERT INTO francl_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Alors Juda dit à ses frères : « Que gagnerons-nous à tuer notre frère et à cacher son sang ? ");
INSERT INTO francl_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Allons le vendre aux Ismaélites et ne portons pas la main sur lui ; car il est notre frère, notre chair. » Ses frères l’écoutèrent ");
INSERT INTO francl_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","et, quand les marchands madianites passèrent, ils tirèrent Joseph et le firent remonter de la citerne ; et ils le vendirent pour vingt pièces d’argent aux Ismaélites, qui l’emmenèrent en Égypte. ");
INSERT INTO francl_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Ruben revint à la citerne, et voici que Joseph n’était plus dans la citerne. ");
INSERT INTO francl_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Il déchira ses vêtements et, étant retourné vers ses frères, il dit : « L’enfant n’y est plus, et moi, où irai-je ? » ");
INSERT INTO francl_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Ils prirent alors la robe de Joseph et, ayant tué un bouc, ils plongèrent la robe dans le sang. ");
INSERT INTO francl_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Et ils envoyèrent à leur père la longue robe, en lui faisant dire : « Voilà ce que nous avons trouvé ; reconnais si c’est la robe de ton fils, ou non. » ");
INSERT INTO francl_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Jacob la reconnut et dit : « C’est la robe de mon fils ! Une bête féroce l’a dévoré ! Joseph a été mis en pièces ! » ");
INSERT INTO francl_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Et il déchira ses vêtements, mit un sac sur ses reins et fit le deuil de son fils pendant longtemps. ");
INSERT INTO francl_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Tous ses fils et toutes ses filles vinrent pour le consoler ; mais il refusa d’être consolé ; il disait : « Je descendrai dans le deuil vers mon fils au séjour des morts. » Et son père le pleura. ");
INSERT INTO francl_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Les Madianites le vendirent en Égypte à Putiphar, officier de Pharaon, chef des gardes. ");
INSERT INTO francl_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","En ce temps-là Juda, s’éloignant de ses frères, descendit et arriva jusqu’auprès d’un homme d’Odollam, nommé Hira. ");
INSERT INTO francl_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Là, Juda vit la fille d’un Chananéen, nommé Sué, et il la prit pour femme et alla vers elle. ");
INSERT INTO francl_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Elle conçut et enfanta un fils, et il le nomma Her. ");
INSERT INTO francl_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Elle conçut encore et enfanta un fils, et elle le nomma Onan. ");
INSERT INTO francl_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Elle conçut de nouveau et enfanta un fils, et elle le nomma Séla ; Juda était à Achzib quand elle le mit au monde. ");
INSERT INTO francl_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Juda prit pour Her, son premier-né, une femme nommée Thamar. ");
INSERT INTO francl_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Her, premier-né de Juda, fut méchant aux yeux de Yahweh et Yahweh le fit mourir. ");
INSERT INTO francl_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Alors Juda dit à Onan : « Va vers la femme de ton frère, remplis ton devoir de beau-frère et suscite une postérité à ton frère. » ");
INSERT INTO francl_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Mais Onan savait que cette postérité ne serait pas à lui et, lorsqu’il allait vers la femme de son frère, il se souillait à terre afin de ne pas donner de postérité à son frère. ");
INSERT INTO francl_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Son action déplut au Seigneur, qui le fit aussi mourir. ");
INSERT INTO francl_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Et Juda dit à Thamar, sa belle-fille : « Demeure comme veuve dans la maison de ton père jusqu’à ce que Séla, mon fils, soit devenu grand. » Car il se disait : « Il ne faut pas que lui aussi meure comme ses frères. » Thamar s’en alla et demeura dans la maison de son père. ");
INSERT INTO francl_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Après beaucoup de jours, la fille de Sué, femme de Juda, mourut. Lorsque Juda eut fini son deuil, il monta vers ceux qui tondaient ses brebis à Thamna, lui et son ami Hira, l’Odollamite. ");
INSERT INTO francl_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","On en informa Thamar, en disant : « Voici ton beau-père qui monte à Thamna pour tondre ses brebis. » ");
INSERT INTO francl_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Alors elle ôta ses vêtements de veuve, se couvrit d’un voile, et, ainsi enveloppée, elle s’assit à l’entrée d’Enaïm, sur le chemin de Thamna, car elle voyait que Séla était devenu grand et qu’elle ne lui était pas donnée pour femme. ");
INSERT INTO francl_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Juda, l’ayant vue, la prit pour une femme de mauvaise vie ; car elle avait couvert son visage. ");
INSERT INTO francl_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Il se dirigea de son côté, vers le chemin, et dit : « Laisse-moi aller vers toi. » Car il ignorait que ce fût sa belle-fille. Elle dit : « Que me donneras-tu pour venir vers moi ? » ");
INSERT INTO francl_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Il répondit : « Je t’enverrai un chevreau du troupeau. » Elle dit : « A condition que tu me donnes un gage jusqu’à ce que tu l’envoies. » ");
INSERT INTO francl_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Il dit : Quel gage dois-je te donner ? » Elle dit : « Ton anneau, ton cordon et ton bâton que tu tiens à la main. » Il les lui donna et alla vers elle, et elle devint enceinte de lui. ");
INSERT INTO francl_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Puis, s’étant levée, elle s’en alla ; et elle ôta son voile et revêtit ses vêtements de veuve. ");
INSERT INTO francl_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Juda envoya le chevreau par son ami, l’Odollamite, pour retirer le gage des mains de cette femme ; mais il ne la trouva point. ");
INSERT INTO francl_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Il interrogea les gens du lieu, en disant : « Où est cette prostituée qui se tenait à Enaïm au bord du chemin ? » Ils répondirent : « Il n’y a pas eu ici de prostituée. » ");
INSERT INTO francl_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Il revint donc vers Juda et dit : « Je ne l’ai pas trouvée ; et même les gens du lieu ont dit : il n’y a pas eu ici de prostituée. » ");
INSERT INTO francl_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Juda dit : « Qu’elle garde son gage ; il ne faut pas qu’on se moque de nous. Voici, j’ai envoyé le chevreau promis, et tu ne l’as pas trouvée. » ");
INSERT INTO francl_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Environ trois mois après, on vint dire à Juda : « Thamar, ta belle-fille, s’est prostituée, et même la voilà enceinte à la suite de ses prostitutions. » Juda dit : « Faites-la sortir et qu’elle soit brûlée. » ");
INSERT INTO francl_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Comme on l’emmenait dehors, elle envoya dire à son beau-père : « C’est de l’homme à qui ces objets appartiennent que je suis enceinte. Regarde bien, ajouta-t-elle, à qui sont cet anneau, ce cordon et ce bâton. » ");
INSERT INTO francl_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Juda les reconnut et dit : « Elle est plus juste que moi, puisque je ne l’ai pas donnée à Séla, mon fils. » Et il ne la connut plus. ");
INSERT INTO francl_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Quand elle fut au moment d’enfanter, voici, il y avait deux jumeaux dans son sein. ");
INSERT INTO francl_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Pendant l’accouchement, l’un d’eux étendit la main ; la sage-femme la prit et y attacha un fil écarlate, en disant : « C’est celui-ci qui est sorti le premier. » ");
INSERT INTO francl_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Mais il retira sa main, et voici que son frère sortit. « Quelle brèche tu as faite ! dit la sage-femme ; la brèche soit sur toi ! » Et on le nomma Pharès. ");
INSERT INTO francl_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Ensuite sortit son frère, qui avait à la main le fil écarlate ; et on le nomma Zara. ");
INSERT INTO francl_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Joseph fut emmené en Égypte, et Putiphar, officier de Pharaon, chef des gardes, Egyptien, l’acheta des Ismaélites qui l’y avaient amené. ");
INSERT INTO francl_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Yahweh fut avec Joseph, qui faisait prospérer toutes choses ; il habitait dans la maison de son maître, l’Egyptien. ");
INSERT INTO francl_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Son maître vit que Yahweh était avec lui et que Yahweh faisait réussir entre ses mains tout ce qu’il faisait. ");
INSERT INTO francl_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Joseph trouva donc grâce à ses yeux et il fut employé à son service ; son maître l’établit sur sa maison et remit en ses mains tout ce qu’il avait. ");
INSERT INTO francl_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Dès qu’il l’eut établi sur sa maison et sur tout ce qu’il avait, Yahweh bénit la maison de l’Egyptien à cause de Joseph, et la bénédiction de Yahweh fut sur tout ce qu’il avait, soit à la maison, soit aux champs. ");
INSERT INTO francl_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Et il abandonna tout ce qu’il avait aux mains de Joseph, ne s’informant plus de rien avec lui, si ce n’est des aliments qu’il prenait. Or Joseph était beau de corps et beau de figure. ");
INSERT INTO francl_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Il arriva, après ces choses, que la femme de son maître jeta les yeux sur Joseph et lui dit : « Couche avec moi. » ");
INSERT INTO francl_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Il refusa et dit à la femme de son maître : « Voici, mon maître ne s’informe avec moi de rien dans la maison et il a remis tout ce qu’il a entre mes mains. ");
INSERT INTO francl_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Il n’est pas plus grand que moi dans cette maison, et il ne m’a rien interdit que toi, parce que tu es sa femme. Comment ferais-je un si grand mal et pécherais-je contre Dieu ? » ");
INSERT INTO francl_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Quoiqu’elle en parlât tous les jours à Joseph, il ne consentit pas à coucher auprès d’elle ni à être avec elle. ");
INSERT INTO francl_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Un jour qu’il était entré dans la maison pour faire son service, sans qu’il y eût là aucun des gens de la maison, ");
INSERT INTO francl_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","elle le saisit par son vêtement, en disant : « Couche avec moi. » Mais il lui laissa son vêtement dans la main, et il s’enfuit au dehors. ");
INSERT INTO francl_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Quand elle vit qu’il lui avait laissé son vêtement dans la main et qu’il s’était enfui dehors, ");
INSERT INTO francl_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","elle appela les gens de sa maison et leur parla en disant : « Voyez, il nous a amené un Hébreu pour folâtrer avec nous. Cet homme est venu vers moi pour coucher avec moi, et j’ai appelé à grands cris. ");
INSERT INTO francl_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Et quand il a entendu que j’élevais la voix et que je criais, il a laissé son vêtement à côté de moi et s’est enfui au dehors. » ");
INSERT INTO francl_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Puis elle posa près d’elle le vêtement de Joseph jusqu’à ce que son maître rentrât à la maison. ");
INSERT INTO francl_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Et elle lui parla selon ces paroles-là, en disant : « Le serviteur hébreu que tu nous as amené est venu vers moi pour folâtrer avec moi. ");
INSERT INTO francl_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Et comme j’ai élevé la voix et jeté des cris, il a laissé son vêtement à côté de moi et s’est enfui dehors. » ");
INSERT INTO francl_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Quand le maître de Joseph eut entendu les paroles de sa femme, qui lui parlait en ces termes : « Voilà ce que m’a fait ton serviteur », sa colère s’enflamma. ");
INSERT INTO francl_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Il prit Joseph et le mit dans la prison ; c’était le lieu où étaient détenus les prisonniers du roi. Et il fut là en prison. ");
INSERT INTO francl_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Yahweh fut avec Joseph ; il étendit sur lui sa bonté, et le mit en faveur aux yeux du chef de la prison. ");
INSERT INTO francl_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Et le chef de la prison plaça sous sa surveillance tous les prisonniers qui étaient dans la prison, et tout ce qui s’y faisait se faisait par lui. ");
INSERT INTO francl_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Le chef de la prison ne regardait à rien de tout ce que Joseph avait en mains, parce que Yahweh était avec lui ; et Yahweh faisait réussir tout ce qu’il faisait, ");
INSERT INTO francl_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Après ces choses, il arriva que l’échanson et le panetier du roi d’Égypte offensèrent leur maître, le roi d’Égypte. ");
INSERT INTO francl_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Pharaon fut irrité contre ses deux officiers, contre le chef des échansons et le chef des panetiers ; ");
INSERT INTO francl_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","et il les fit enfermer chez le chef des gardes, dans la prison, dans le lieu où Joseph était enfermé. ");
INSERT INTO francl_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Le chef des gardes établit Joseph auprès d’eux, et il les servait ; et ils furent un certain temps en prison. ");
INSERT INTO francl_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","L’échanson et le panetier du roi d’Égypte, qui étaient enfermés dans la prison, eurent tous deux un songe dans la même nuit, chacun le sien, ayant une signification différente. ");
INSERT INTO francl_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Joseph, étant venu le matin vers eux, les regarda ; et voici, ils étaient tristes. ");
INSERT INTO francl_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Il interrogea donc les officiers de Pharaon qui étaient avec lui en prison, dans la maison de son maître, et leur dit : « Pourquoi avez-vous le visage triste aujourd’hui ? » ");
INSERT INTO francl_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Ils lui dirent : « Nous avons eu un songe, et il n’y a personne ici pour l’expliquer. » Et Joseph leur dit : « N’est-ce pas à Dieu qu’appartiennent les interprétations ? Racontez-moi, je vous prie, votre songe. » ");
INSERT INTO francl_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Le chef des échansons raconta son songe à Joseph, en disant : « Dans mon songe, voici, il y avait un cep devant moi, ");
INSERT INTO francl_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","et ce cep avait trois branches ; il poussa des bourgeons, la fleur sortit et ses grappes donnèrent des raisins mûrs. ");
INSERT INTO francl_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","La coupe de Pharaon était dans ma main ; je pris des raisins, j’en pressai le jus dans la coupe de Pharaon et je mis la coupe dans la main de Pharaon. » ");
INSERT INTO francl_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Joseph lui dit : « En voici l’interprétation : les trois branches sont trois jours. ");
INSERT INTO francl_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Encore trois jours, et Pharaon relèvera ta tête et te rétablira dans ta charge, et tu mettras la coupe de Pharaon dans sa main, selon ton premier office, lorsque tu étais son échanson. ");
INSERT INTO francl_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Si tu te souviens de moi quand le bonheur te sera rendu, et si tu daignes user de bonté à mon égard, rappelle-moi au souvenir de Pharaon, et fais-moi sortir de cette maison. ");
INSERT INTO francl_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Car c’est par un rapt que j’ai été enlevé du pays des Hébreux, et ici même je n’ai rien fait pour qu’on m’ait mis dans cette prison. » ");
INSERT INTO francl_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Le chef des panetiers, voyant que Joseph avait donné une interprétation favorable, lui dit : « Moi aussi, dans mon songe, voici que j’avais sur la tête trois corbeilles de pain blanc. ");
INSERT INTO francl_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Dans la corbeille de dessus se trouvaient toutes sortes de pâtisseries pour Pharaon, et les oiseaux les mangeaient dans la corbeille qui était sur ma tête. » ");
INSERT INTO francl_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Joseph répondit : « En voici l’interprétation : les trois corbeilles sont trois jours. ");
INSERT INTO francl_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Encore trois jours, et Pharaon enlèvera ta tête de dessus toi et te pendra à un bois, et les oiseaux dévoreront ta chair de dessus toi. » ");
INSERT INTO francl_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Le troisième jour, qui était le jour de la naissance de Pharaon, il donna un festin à tous ses serviteurs ; et il éleva la tête du chef des échansons et la tête du chef des panetiers : ");
INSERT INTO francl_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","il rétablit le chef des échansons dans son office d’échanson, et celui-ci mit la coupe dans la main de Pharaon ; ");
INSERT INTO francl_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","et il fit pendre le chef des panetiers, selon l’interprétation que Joseph leur avait donnée. ");
INSERT INTO francl_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Mais le chef des échansons ne parla pas de Joseph, et l’oublia. ");
INSERT INTO francl_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Deux ans s’étant écoulés, Pharaon eut un songe. Voici, il se tenait près du fleuve, ");
INSERT INTO francl_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","et voici que du fleuve montaient sept vaches belles à voir et grasses de chair, et elles se mirent à paître dans la verdure. ");
INSERT INTO francl_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Et voici qu’après elles montaient du fleuve sept autres vaches, laides à voir et maigres de chair, et elles vinrent se mettre à côté des vaches qui étaient sur le bord du fleuve. ");
INSERT INTO francl_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Et les vaches laides à voir et maigres de chair dévorèrent les sept vaches belles à voir et grasses. Alors Pharaon s’éveilla. ");
INSERT INTO francl_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Il se rendormit, et il eut un second songe. Et voici, sept épis s’élevaient d’une même tige, gras et beaux. ");
INSERT INTO francl_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Et sept épis maigres et brûlés par le vent d’orient poussaient après ceux-là. ");
INSERT INTO francl_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Et les épis maigres engloutirent les sept épis gras et pleins. Alors Pharaon s’éveilla. Et voilà, c’était un songe. ");
INSERT INTO francl_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Le matin, Pharaon eut l’esprit agité, et il fit appeler tous les scribes et tous les sages d’Égypte. Il leur raconta ses songes, mais personne ne put les expliquer à Pharaon. ");
INSERT INTO francl_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Alors le chef des échansons, prenant la parole, dit à Pharaon : « Je vais rappeler aujourd’hui mes fautes. ");
INSERT INTO francl_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Pharaon était irrité contre ses serviteurs, et il m’avait mis en prison dans la maison du chef des gardes, moi et le chef des panetiers. ");
INSERT INTO francl_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Nous eûmes un songe dans la même nuit, moi et lui, nous révâmes chacun selon la signification de son songe. ");
INSERT INTO francl_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Il y avait là avec nous un jeune Hébreu, serviteur du chef des gardes. Nous lui racontâmes nos songes, et il nous en donna l’interprétation ; à chacun il interpréta son songe, ");
INSERT INTO francl_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","et les choses se passèrent comme il avait interprété : moi, Pharaon me rétablit dans mon poste, et lui, on le pendit. » ");
INSERT INTO francl_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Pharaon envoya appeler Joseph, et on le fit sortir en hâte de la prison. Il se rasa, mit d’autres vêtements et se rendit vers Pharaon. ");
INSERT INTO francl_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Et Pharaon dit à Joseph : « J’ai eu un songe que personne ne peut interpréter ; et j’ai entendu dire de toi que, quand tu entends un songe, tu l’interprètes. » ");
INSERT INTO francl_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Joseph répondit à Pharaon en disant : « Ce n’est pas moi, c’est Dieu qui donnera une réponse favorable à Pharaon. » ");
INSERT INTO francl_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Pharaon dit alors à Joseph : « Dans mon songe, voici, je me tenais sur le bord du fleuve, ");
INSERT INTO francl_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","et voici que du fleuve montaient sept vaches grasses de chair et de belle apparence, et elles se mirent à paître dans la verdure. ");
INSERT INTO francl_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Et voici qu’après elles montaient sept autres vaches, maigres, fort laides d’aspect et décharnées ; je n’en ai pas vu de pareilles en laideur dans tout le pays d’Égypte. ");
INSERT INTO francl_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Les vaches maigres et laides dévorèrent les sept premières vaches, celles qui étaient grasses ; ");
INSERT INTO francl_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","celles-ci entrèrent dans leur ventre, sans qu’il parût qu’elles y fussent entrées ; leur aspect était aussi laid qu’auparavant. Et je m’éveillai. ");
INSERT INTO francl_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Je vis encore en songe, et voici sept épis qui s’élevaient sur une même tige, pleins et beaux ; ");
INSERT INTO francl_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","et voici, sept épis chétifs, maigres et brûlés par le vent d’orient, qui poussaient après ceux-là. ");
INSERT INTO francl_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Et les épis maigres engloutirent les sept beaux épis. J’ai raconté cela aux scribes, et aucun d’eux ne me l’explique. » ");
INSERT INTO francl_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Joseph dit à Pharaon : « Le songe de Pharaon est un ; Dieu a fait connaître à Pharaon ce qu’il va faire. ");
INSERT INTO francl_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Les sept belles vaches sont sept années, et les sept beaux épis sont sept années, c’est un seul songe. ");
INSERT INTO francl_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Les sept vaches chétives et laides qui montaient après elles sont sept années, et les sept épis vides, brûlés par le vent d’orient, seront sept années de famine. ");
INSERT INTO francl_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Telle est la parole que j’ai dite à Pharaon : Dieu a fait voir à Pharaon ce qu’il va faire. ");
INSERT INTO francl_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Voici, sept années de grande abondance vont venir dans tout le pays d’Égypte. ");
INSERT INTO francl_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Sept années de famine viendront ensuite, et l’on oubliera toute cette abondance dans le pays d’Égypte, et la famine consumera le pays. ");
INSERT INTO francl_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","On ne s’apercevra plus de l’abondance à cause de cette famine qui suivra dans le pays ; tant elle sera grande. ");
INSERT INTO francl_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Et si le songe a été répété à Pharaon deux fois, c’est que la chose est décidée de la part de Dieu, et que Dieu se hâtera de l’exécuter. ");
INSERT INTO francl_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Maintenant, que Pharaon trouve un homme intelligent et sage, et qu’il l’établisse sur le pays d’Égypte. ");
INSERT INTO francl_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Que Pharaon établisse en outre des intendants sur le pays, pour lever un cinquième des récoltes du pays d’Égypte pendant les sept années d’abondance. ");
INSERT INTO francl_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Qu’ils rassemblent tout le produit de ces bonnes années qui viennent ; qu’ils fassent des amas de blé à la disposition de Pharaon, comme provisions dans les villes, et qu’ils les conservent. ");
INSERT INTO francl_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Ces provisions seront pour le pays une réserve pour les sept années de famine qui arriveront au pays d’Égypte, et le pays ne sera pas consumé par la famine. » ");
INSERT INTO francl_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Ces paroles plurent à Pharaon et à tous ses serviteurs. ");
INSERT INTO francl_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Et Pharaon dit à ses serviteurs : « Pourrions-nous trouver un homme pareil à celui-ci, ayant en lui l’esprit de Dieu ? » ");
INSERT INTO francl_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Et Pharaon dit à Joseph : « Puisque Dieu t’a fait connaître toutes ces choses, il n’y a personne qui soit aussi intelligent et sage que toi. ");
INSERT INTO francl_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","C’est toi qui gouverneras ma maison, et tout mon peuple obéira à ta bouche ; par le trône seulement je serai plus grand que toi. » ");
INSERT INTO francl_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Et Pharaon dit à Joseph : « Voici que je t’établis sur tout le pays d’Égypte. » ");
INSERT INTO francl_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Et Pharaon ôta son anneau de sa main et le mit à la main de Joseph, et il le fit revêtir d’habits de fin lin et lui mit au cou un collier d’or. ");
INSERT INTO francl_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Il le fit monter sur le second de ses chars, et on criait devant lui : « A genoux ! » C’est ainsi qu’il fut établi sur tout le pays d’Égypte. ");
INSERT INTO francl_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Et Pharaon dit à Joseph : « Je suis Pharaon, et sans toi nul ne lèvera la main ni le pied dans tout le pays d’Égypte. » ");
INSERT INTO francl_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Pharaon nomma Joseph Tsaphnath-Panéach, et il lui donna pour femme Aseneth, fille de Putiphar, prêtre d’On. Et Joseph partit pour visiter le pays d’Égypte. ");
INSERT INTO francl_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Joseph était âgé de trente ans lorsqu’il se présenta devant Pharaon, roi d’Égypte ; et il quitta Pharaon pour parcourir tout le pays d’Égypte. ");
INSERT INTO francl_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","La terre rapporta à pleines mains pendant les sept années d’abondance. ");
INSERT INTO francl_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Joseph rassembla tous les produits des sept bonnes années qu’il y eut au pays d’Égypte, et il fit des approvisionnements dans les villes, déposant dans l’intérieur de chaque ville les productions des champs d’alentour. ");
INSERT INTO francl_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Joseph amassa du blé comme le sable de la mer, en si grande quantité, qu’on cessa de compter, parce qu’il était sans nombre. ");
INSERT INTO francl_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Avant qu’arrivât l’année de famine, il naquit à Joseph deux fils, que lui enfanta Aseneth, fille de Putiphar, prêtre d’On. ");
INSERT INTO francl_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Joseph donna au premier-né le nom de Manassé, « car, dit-il, Dieu m’a fait oublier toute ma peine et toute la maison de mon père. » ");
INSERT INTO francl_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Il donna au second le nom d’Ephraïm, « car, dit-il, Dieu m’a fait fructifier dans le pays de mon affliction. » ");
INSERT INTO francl_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Les sept années d’abondance qu’il y eut en Égypte étant achevées, ");
INSERT INTO francl_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","les sept années de famine commencèrent à venir, comme Joseph l’avait annoncé. Il y eut famine dans tous les pays, tandis qu’il y avait du pain dans tout le pays d’Égypte. ");
INSERT INTO francl_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Puis tout le pays d’Égypte fut aussi affamé, et le peuple cria à Pharaon pour avoir du pain. Et Pharaon dit à tous les Egyptiens : « Allez vers Joseph, faites ce qu’il vous dira. » ");
INSERT INTO francl_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","La famine étant sur toute la face du pays, Joseph ouvrit tous les greniers qu’on y avait établis et vendit du blé aux Egyptiens ; et la famine s’accrut dans le pays d’Égypte. ");
INSERT INTO francl_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","De toute la terre on venait en Égypte pour acheter du blé auprès de Joseph ; car la famine s’était aggravée sur toute la terre. ");
INSERT INTO francl_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Jacob, voyant qu’il y avait du blé en Égypte, dit à ses fils : « Pourquoi vous regardez-vous les uns les autres ? ");
INSERT INTO francl_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Il dit : Voici, j’ai appris, qu’il y a du blé en Égypte ; descendez-y pour nous en acheter là, afin que nous vivions et que nous ne mourions point. » ");
INSERT INTO francl_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Les frères de Joseph descendirent au nombre de dix pour acheter du blé en Égypte. ");
INSERT INTO francl_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Mais pour Benjamin, frère de Joseph, Jacob ne l’envoya pas avec ses frères, car il s’était dit : « Il est à craindre qu’il ne lui arrive malheur. » ");
INSERT INTO francl_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Les fils d’Israël vinrent donc pour acheter du blé, avec d’autres qui venaient aussi, car la famine était au pays de Canaan. ");
INSERT INTO francl_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Joseph était le chef du pays, et c’est lui qui vendait le blé à tous les gens du pays. Les frères de Joseph, étant arrivés, se prosternèrent devant lui, la face contre terre. ");
INSERT INTO francl_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","En voyant ses frères, Joseph les reconnut, mais il feignit d’être un étranger pour eux, et leur parla avec rudesse, en disant : « D’où venez-vous ? » Ils répondirent : « Du pays de Canaan, pour acheter des vivres. » ");
INSERT INTO francl_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Joseph reconnut donc ses frères, mais eux ne le reconnurent pas. ");
INSERT INTO francl_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Joseph se souvint alors des songes qu’il avait eus à leur sujet, et il leur dit : « Vous êtes des espions ; c’est pour reconnaître les points faibles du pays que vous êtes venus. » ");
INSERT INTO francl_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Ils lui répondirent : « Non, mon seigneur ; tes serviteurs sont venus pour acheter des vivres. ");
INSERT INTO francl_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Tous nous sommes fils d’un même homme ; nous sommes d’honnêtes gens ; tes serviteurs ne sont pas des espions. » ");
INSERT INTO francl_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Il leur dit : « Point du tout ; vous êtes venus reconnaître les endroits faibles du pays. » ");
INSERT INTO francl_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ils répondirent : « Nous, tes serviteurs, nous sommes douze frères, fils d’un même homme, au pays de Canaan. Et voici, le plus jeune est maintenant avec notre père, et il y en a un qui n’est plus. » ");
INSERT INTO francl_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Joseph leur dit : « Il en est comme je viens de vous le dire vous êtes des espions. ");
INSERT INTO francl_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","En ceci vous serez éprouvés : par la vie de Pharaon ! vous ne sortirez pas d’ici que votre jeune frère ne soit venu. ");
INSERT INTO francl_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Envoyez l’un de vous chercher votre frère, et vous, restez prisonniers. Vos paroles seront ainsi mises à l’épreuve, et l’on verra si la vérité est avec vous ; sinon, par la vie de Pharaon ! vous êtes des espions. » ");
INSERT INTO francl_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Et il les fit mettre ensemble en prison pendant trois jours. ");
INSERT INTO francl_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Le troisième jour, Joseph leur dit : « Faites ceci et vous vivrez : je crains Dieu ! ");
INSERT INTO francl_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Si vous êtes d’honnêtes gens, que l’un de vous, votre frère, reste lié dans votre prison ; et vous, allez, emportez du blé pour calmer la faim de vos familles. ");
INSERT INTO francl_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Et amenez-moi votre plus jeune frère ; et vos paroles seront reconnues vraies, et vous ne mourrez point. » Et ils firent ainsi. ");
INSERT INTO francl_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Alors ils se dirent l’un à l’autre : « Vraiment nous sommes punis à cause de notre frère ; car nous avons vu l’angoisse de son âme, quand il nous demandait grâce, et nous ne l’avons pas écouté ! Voilà pourquoi cette détresse est venue vers nous. » ");
INSERT INTO francl_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ruben, prenant la parole, leur dit : « Ne vous disais-je pas : Ne commettez pas de péché contre l’enfant ? Et vous n’avez pas écouté ; et voici, son sang est redemandé. » ");
INSERT INTO francl_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Ils ne savaient pas que Joseph comprenait, car ils lui parlaient par l’interprète. ");
INSERT INTO francl_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Et il s’éloigna d’eux et il pleura. Etant ensuite revenu vers eux, il leur parla ; et il prit parmi eux Siméon et le fit lier sous leurs yeux. ");
INSERT INTO francl_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Puis Joseph commanda qu’on remplît de blé leurs vaisseaux, qu’on remit l’argent de chacun dans son sac et qu’on leur donnât des provisions pour la route. Et il leur fut fait ainsi. ");
INSERT INTO francl_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Ayant chargé le blé sur leurs ânes, ils partirent. ");
INSERT INTO francl_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","A l’endroit où ils passèrent la nuit, l’un d’eux ouvrit son sac pour donner du fourrage à son âne, et il vit son argent, qui était à l’entrée du sac. ");
INSERT INTO francl_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Il dit à ses frères : « On a remis mon argent ; le voici dans mon sac ! » Et le cœur leur manqua, et ils se dirent en tremblant l’un à l’autre : « Qu’est-ce que Dieu nous a fait ? » ");
INSERT INTO francl_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Ils revinrent auprès de Jacob, leur père, au pays de Canaan, et ils lui racontèrent tout ce qui leur était arrivé, en disant : ");
INSERT INTO francl_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","« L’homme qui est le maître du pays nous a parlé durement et nous a pris pour des gens espionnant le pays. ");
INSERT INTO francl_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Nous lui avons dit : Nous sommes d’honnêtes gens, nous ne sommes pas des espions. ");
INSERT INTO francl_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Nous sommes douze frères, fils d’un même père ; l’un n’est plus, et le plus jeune est maintenant avec notre père, au pays de Canaan. ");
INSERT INTO francl_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Et l’homme qui est le maître du pays nous a dit : En ceci je saurai que vous êtes d’honnêtes gens : laissez auprès de moi l’un de vous, votre frère ; prenez de quoi calmer la faim de vos familles et partez ; ");
INSERT INTO francl_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","et amenez-moi votre plus jeune frère. Je saurai ainsi que vous n’êtes pas des espions, mais que vous êtes d’honnêtes gens. Je vous rendrai alors votre frère et vous pourrez trafiquer dans le pays. » ");
INSERT INTO francl_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Comme ils vidaient leurs sacs, le paquet d’argent de chacun était dans son sac. Ils virent, eux et leur père, leurs paquets d’argent, et ils furent effrayés. ");
INSERT INTO francl_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Jacob, leur père, leur dit : « Vous me faites sans enfants ! Joseph n’est plus, Siméon n’est plus, et vous allez prendre Benjamin ! C’est sur moi que tout cela retombe. » ");
INSERT INTO francl_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Ruben dit à son père : « Tu feras mourir mes deux fils, si je ne te ramène pas Benjamin ; remets-le entre mes mains, et moi, je te le ramènerai. » ");
INSERT INTO francl_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Il dit : « Mon fils ne descendra pas avec vous, car son frère est mort, et lui reste seul. S’il lui arrivait malheur dans le voyage que vous allez faire, vous feriez descendre mes cheveux blancs avec douleur dans le séjour des morts. » ");
INSERT INTO francl_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","La famine s’appesantissait sur le pays. ");
INSERT INTO francl_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Quand ils eurent fini de manger le blé qu’ils avaient apporté d’Égypte, leur père leur dit : « Retournez nous acheter un peu de vivres. » ");
INSERT INTO francl_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Juda lui répondit : « Cet homme nous a fait cette déclaration formelle : Vous ne verrez pas ma face que votre frère ne soit avec vous. ");
INSERT INTO francl_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Si donc tu laisses venir notre frère avec nous, nous descendrons et nous t’achèterons des vivres. ");
INSERT INTO francl_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Mais si tu ne le laisses pas venir, nous ne descendrons point ; car cet homme nous a dit : Vous ne verrez pas ma face que votre frère ne soit avec vous. » ");
INSERT INTO francl_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Et Israël dit : « Pourquoi m’avez-vous causé cette peine, de dire à cet homme que vous aviez encore un frère ? » ");
INSERT INTO francl_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Ils dirent : « Cet homme nous a adressé beaucoup de questions sur nous et sur notre famille, en disant : Votre père vit-il encore ? Avez-vous un autre frère ? Et nous avons répondu selon ces questions. Pouvions-nous savoir qu’il dirait : Faites descendre votre frère ? » ");
INSERT INTO francl_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Et Juda dit à Israël, son père : « Laisse partir l’enfant avec moi, afin que nous nous levions et nous mettions en route, et nous vivrons et ne mourrons point, nous, toi et nos petits enfants. ");
INSERT INTO francl_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","C’est moi qui réponds de lui, tu le redemanderas de ma main. Si je ne le ramène pas auprès de toi, si je ne le mets pas devant toi, je serai coupable envers toi à tout jamais. ");
INSERT INTO francl_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Car si nous n’avions pas tant tardé, nous serions maintenant deux fois de retour. » ");
INSERT INTO francl_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Israël, leur père, leur dit : « Eh bien, puisqu’il le faut, faites ceci : Prenez dans vos vaisseaux des meilleures productions du pays et portez à cet homme un présent : un peu de baume et un peu de miel, de l’astragale, du ladanum, des pistaches et des amandes. ");
INSERT INTO francl_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Prenez dans vos mains de l’argent en double, et reportez celui qui a été mis à l’entrée de vos sacs, peut-être par erreur. ");
INSERT INTO francl_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Prenez votre frère, levez-vous et retournez vers cet homme. ");
INSERT INTO francl_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Que le Dieu tout-puissant vous fasse trouver grâce devant cet homme, afin qu’il laisse revenir avec vous votre autre frère, ainsi que Benjamin ! Pour moi, si je dois être privé de mes enfants, que j’en sois privé ! » ");
INSERT INTO francl_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Les hommes prirent ce présent, et ils prirent dans leurs mains de l’argent au double, ainsi que Benjamin ; et, s’étant levés, ils descendirent en Égypte et se présentèrent devant Joseph. ");
INSERT INTO francl_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Dès que Joseph vit Benjamin avec eux, il dit à son intendant : « Fais entrer ces gens dans la maison, tue des victimes et apprête un repas, car ces gens mangeront avec moi à midi. » ");
INSERT INTO francl_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Cet homme fit ce que Joseph avait ordonné, et il conduisit ces gens dans la maison de Joseph. ");
INSERT INTO francl_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Pendant qu’on les conduisait à la maison de Joseph, les hommes eurent peur, et ils dirent : « C’est à cause de l’argent rapporté l’autre fois dans nos sacs qu’on nous emmène ; c’est pour nous assaillir, tomber sur nous, nous prendre comme esclaves avec nos ânes. » ");
INSERT INTO francl_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","S’étant approchés de l’intendant de la maison de Joseph, ils lui adressèrent la parole, à l’entrée de la maison, ");
INSERT INTO francl_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","en disant : « Pardon, mon seigneur. Nous sommes déjà descendus une fois pour acheter des vivres. ");
INSERT INTO francl_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Au retour, quand nous arrivâmes à l’endroit où nous devions passer la nuit, nous avons ouvert nos sacs, et voici, l’argent de chacun était à l’entrée de son sac, notre argent selon son poids : nous le rapportons avec nous ; ");
INSERT INTO francl_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","et en même temps nous avons apporté d’autre argent pour acheter des vivres. Nous ne savons pas qui a mis notre argent dans nos sacs. » ");
INSERT INTO francl_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Il leur dit : « Que la paix soit avec vous ! Ne craignez rien. C’est votre Dieu, le Dieu de votre père, qui vous a donné un trésor dans vos sacs. Votre argent m’a été remis. » Et il leur amena Siméon. ");
INSERT INTO francl_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Cet homme, les ayant fait entrer dans la maison de Joseph, leur donna de l’eau et ils se lavèrent les pieds ; il donna aussi du fourrage à leurs ânes. ");
INSERT INTO francl_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Ils préparèrent leur présent, en attendant que Joseph vint à midi ; car on leur avait annoncé qu’ils mangeraient chez lui. ");
INSERT INTO francl_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Quand Joseph fut arrivé chez lui, ils lui apportèrent dans la maison le présent qu’ils avaient dans la main, et se prosternèrent par terre devant lui. ");
INSERT INTO francl_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Il leur demanda comment ils se portaient, puis il dit : « Votre vieux père, dont vous avez parlé, est-il en bonne santé ? vit-il encore ? » ");
INSERT INTO francl_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Ils répondirent : « Ton serviteur, notre père, est en bonne santé ; il vit encore « ; et ils s’inclinèrent et se prosternèrent. ");
INSERT INTO francl_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Joseph leva les yeux, et il vit Benjamin, son frère, fils de sa mère ; il dit : « Est-ce là votre jeune frère dont vous m’avez parlé ? » Et il dit : « Que Dieu te soit favorable, mon fils ! » ");
INSERT INTO francl_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Alors, en toute hâte, car ses entrailles étaient émues pour son frère, Joseph chercha un endroit pour pleurer ; il entra dans sa chambre et il y pleura. ");
INSERT INTO francl_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Après s’être lavé le visage, il sortit et, faisant des efforts pour se contenir, il dit : « Servez à manger. » ");
INSERT INTO francl_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","On le servit à part, et ses frères à part, à part aussi les Egyptiens qui mangeaient avec lui, car les Egyptiens ne peuvent prendre leurs repas avec les Hébreux : c’est une abomination pour les Egyptiens. ");
INSERT INTO francl_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Les frères de Joseph s’assirent devant lui, le premier-né selon son droit d’aînesse, et le plus jeune selon son âge ; et ils se regardaient les uns les autres avec étonnement. ");
INSERT INTO francl_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Il leur fit porter des portions de devant lui, et la portion de Benjamin était cinq fois plus forte que les portions d’eux tous. Ils burent joyeusement avec lui. ");
INSERT INTO francl_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Joseph donna cet ordre à l’intendant de sa maison : « Remplis de vivres les sacs de ces gens, autant qu’ils en pourront porter, et mets l’argent de chacun à l’entrée de son sac. ");
INSERT INTO francl_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Tu mettras aussi ma coupe, la coupe d’argent, à l’entrée du sac du plus jeune, avec l’argent de son blé. » L’intendant fit ce que Joseph lui avait ordonné. ");
INSERT INTO francl_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Le matin, dès qu’il fit jour, on renvoya les hommes avec leurs ânes. ");
INSERT INTO francl_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Ils étaient sortis de la ville, sans en être encore bien éloignés, lorsque Joseph dit à son intendant : « Lève-toi, poursuis ces gens ; et, quand tu les auras atteints, tu leur diras : Pourquoi avez-vous rendu le mal pour le bien ? ");
INSERT INTO francl_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","N’est-ce pas la coupe dans laquelle boit mon seigneur, et dont il se sert pour deviner ? C’est une action mauvaise que vous avez faite. » ");
INSERT INTO francl_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","L’intendant, les ayant rejoints, leur dit ces mêmes paroles. ");
INSERT INTO francl_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Ils lui répondirent : « Pourquoi mon seigneur parle-t-il ainsi ? Dieu préserve tes serviteurs d’avoir commis une telle action ! ");
INSERT INTO francl_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Voici, nous t’avons rapporté du pays de Canaan l’argent que nous avons trouvé à l’entrée de nos sacs ; comment aurions-nous dérobé dans la maison de ton seigneur de l’argent ou de l’or ? ");
INSERT INTO francl_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Que celui de tes serviteurs sur qui sera trouvée la coupe meure, et que nous soyons aussi nous-mêmes les esclaves de mon seigneur. » ");
INSERT INTO francl_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Il leur dit : « Eh bien, qu’il en soit selon vos paroles ! Celui chez qui se trouvera la coupe sera mon esclave ; et vous, vous serez quittes. » ");
INSERT INTO francl_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Chacun descendit aussitôt son sac à terre et chacun ouvrit son sac. ");
INSERT INTO francl_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","L’intendant les fouilla, commençant par le plus âgé et finissant par le plus jeune ; et la coupe se trouva dans le sac de Benjamin. ");
INSERT INTO francl_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Ils déchirèrent leurs vêtements et, chacun ayant rechargé son âne, ils retournèrent à la ville. ");
INSERT INTO francl_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Juda avec ses frères arriva à la maison de Joseph, qui s’y trouvait encore, et ils se prosternèrent devant lui jusqu’à terre. ");
INSERT INTO francl_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Joseph leur dit : « Quelle action avez-vous faite ? Ne saviez-vous pas qu’un homme tel que moi saurait bien deviner ? » ");
INSERT INTO francl_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Juda répondit :  « Que pouvons-nous dire à mon seigneur ? Comment parler ? comment nous justifier ? Dieu a trouvé l’iniquité de tes serviteurs. Nous voici esclaves de mon seigneur, nous et celui chez qui s’est trouvée la coupe. » ");
INSERT INTO francl_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Et Joseph dit : « Dieu me garde de faire cela ! l’homme chez qui la coupe a été trouvée sera mon esclave ; et vous, remontez en paix vers votre père. » ");
INSERT INTO francl_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Alors Juda, s’approchant de Joseph, lui dit : « De grâce, mon seigneur, que ton serviteur puisse dire une parole aux oreilles de mon seigneur, et que ta colère ne s’enflamme pas contre ton serviteur ! car tu es l’égal de Pharaon. ");
INSERT INTO francl_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Mon seigneur a interrogé ses serviteurs, en disant : Avez-vous un père ou un frère. ");
INSERT INTO francl_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Et nous avons répondu à mon seigneur : Nous avons un vieux père et un jeune frère, enfant de sa vieillesse ; cet enfant avait un frère qui est mort, et il reste seul de la même mère, et son père l’aime. ");
INSERT INTO francl_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Tu as dit à tes serviteurs : Faites-le descendre vers moi, et que je pose mes yeux sur lui. ");
INSERT INTO francl_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Nous avons répondu à mon seigneur : L’enfant ne peut pas quitter son père ; s’il le quitte, son père mourra. ");
INSERT INTO francl_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Tu as dit à tes serviteurs : Si votre jeune frère ne descend pas avec vous, vous ne reverrez plus ma face. ");
INSERT INTO francl_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Lorsque nous sommes remontés vers ton serviteur, mon père, nous lui avons rapporté les paroles de mon seigneur. ");
INSERT INTO francl_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Et quand notre père a dit : Retournez, achetez-nous un peu de vivres, ");
INSERT INTO francl_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","nous avons répondu : Nous ne pouvons pas descendre ; mais, si notre plus jeune frère est avec nous, nous descendrons, car nous ne pouvons voir la face de cet homme à moins que notre jeune frère ne soit avec nous. ");
INSERT INTO francl_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Ton serviteur, notre père, nous a dit : Vous savez que ma femme m’a enfanté deux fils. ");
INSERT INTO francl_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","L’un s’en est allé d’avec moi, et j’ai dit : Il faut qu’il ait été dévoré, car je ne l’ai pas revu jusqu’à présent. ");
INSERT INTO francl_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Si vous me prenez encore celui-ci et qu’il lui arrive malheur, vous ferez descendre mes cheveux blancs avec douleur au séjour des morts. — ");
INSERT INTO francl_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Maintenant, quand je retournerai auprès de ton serviteur, mon père, sans avoir avec nous l’enfant, à l’âme duquel est attachée son âme, ");
INSERT INTO francl_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","dès qu’il verra que l’enfant n’y est pas, il mourra, et tes serviteurs auront fait descendre avec douleur au séjour des morts les cheveux blancs de ton serviteur, notre père. ");
INSERT INTO francl_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Car ton serviteur a répondu de l’enfant en le prenant à mon père ; il a dit : Si je ne le ramène pas auprès de toi, je serai coupable envers mon père à tout jamais. ");
INSERT INTO francl_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Permets donc, je te prie, que moi, ton serviteur, je reste à la place de l’enfant comme esclave de mon seigneur, et que l’enfant remonte avec ses frères. ");
INSERT INTO francl_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Comment pourrais-je remonter vers mon père, si l’enfant n’est pas avec moi ? Non, que je ne voie pas l’affliction qui accablerait mon père ! » ");
INSERT INTO francl_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Alors Joseph ne put se contenir devant tous ceux qui étaient présents ; il s’écria : « Faites sortir tout le monde. » Et il ne resta personne avec lui quand il se fit connaître à ses frères. ");
INSERT INTO francl_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Il éleva la voix en pleurant ; les Egyptiens l’entendirent, et la maison de Pharaon l’entendit. ");
INSERT INTO francl_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Joseph dit à ses frères : « Je suis Joseph ! Mon père vit-il encore ? » Mais ses frères ne purent lui répondre, tant ils étaient bouleversés devant lui. ");
INSERT INTO francl_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Et Joseph dit à ses frères : « Approchez-vous de moi « ; et ils s’approchèrent. Il dit : « Je suis Joseph, votre frère, que vous avez vendu pour être mené en Égypte. ");
INSERT INTO francl_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Maintenant ne vous affligez pas et ne soyez pas fâchés contre vous-mêmes de ce que vous m’avez vendu pour être conduit ici ; c’est pour vous sauver la vie que Dieu m’a envoyé devant vous. ");
INSERT INTO francl_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Car voilà deux ans que la famine est dans ce pays, et pendant cinq années encore il n’y aura ni labour ni moisson. ");
INSERT INTO francl_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Dieu m’a envoyé devant vous pour vous assurer un reste dans le pays et vous faire subsister pour une grande délivrance. ");
INSERT INTO francl_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Et maintenant, ce n’est pas vous qui m’avez envoyé ici, mais c’est Dieu ; il m’a établi père de Pharaon, seigneur sur toute sa maison et gouverneur de tout le pays d’Égypte. ");
INSERT INTO francl_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Hâtez-vous de monter vers mon père, et vous lui direz : Ainsi a parlé ton fils Joseph : Dieu m’a établi seigneur sur toute l’Égypte ; descends vers moi sans tarder. ");
INSERT INTO francl_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Tu habiteras dans le pays de Gessen, et tu seras près de moi, toi et tes fils, et les fils de tes fils, tes brebis et tes bœufs, et tout ce qui est à toi. ");
INSERT INTO francl_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Là, je te nourrirai, — car il y aura encore cinq années de famine, — afin que tu ne souffres pas, toi, ta maison et tout ce qui est à toi. ");
INSERT INTO francl_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Voici, vos yeux voient, ainsi que les yeux de mon frère Benjamin, que c’est ma bouche qui vous parle. ");
INSERT INTO francl_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Racontez à mon père toute ma gloire en Égypte et tout ce que vous avez vu, et faites au plus tôt descendre ici mon père. » ");
INSERT INTO francl_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Alors il se jeta au cou de Benjamin, son frère, et pleura ; et Benjamin pleura sur son cou. ");
INSERT INTO francl_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Il baisa aussi tous ses frères, et pleura en les tenant embrassés ; puis ses frères s’entretinrent avec lui. ");
INSERT INTO francl_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Le bruit se répandit dans la maison de Pharaon que les frères de Joseph étaient venus : ce qui fut agréable à Pharaon et à ses serviteurs. ");
INSERT INTO francl_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Et Pharaon dit à Joseph : « Dis à tes frères : Faites ceci : chargez vos bêtes et partez pour le pays de Canaan ");
INSERT INTO francl_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","et, ayant pris votre père et vos familles, revenez auprès de moi. Je vous donnerai ce qu’il y a de meilleur au pays d’Égypte, et vous mangerez la graisse du pays. ");
INSERT INTO francl_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Tu es autorisé à leur dire : Faites ceci : prenez dans le pays d’Égypte des chariots pour vos enfants et pour vos femmes ; amenez votre père et venez. ");
INSERT INTO francl_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Que vos yeux ne s’arrêtent pas avec regret sur les objets que vous devrez laisser, car ce qu’il y a de meilleur dans tout le pays d’Égypte est à votre disposition. » ");
INSERT INTO francl_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Les fils d’Israël firent ainsi ; Joseph leur donna des chariots, selon l’ordre de Pharaon, ainsi que des provisions pour la route. ");
INSERT INTO francl_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Il leur donna à tous des vêtements de rechange, et il donna à Benjamin trois cents pièces d’argent et cinq vêtements de rechange. ");
INSERT INTO francl_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Il envoya également à son père dix ânes chargés des meilleurs produits de l’Égypte, et dix ânesses chargées de blé, de pain et de vivres, pour son père pendant le voyage. ");
INSERT INTO francl_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Puis il congédia ses frères, qui partirent ; et il leur dit : « Ne vous querellez pas en chemin. » ");
INSERT INTO francl_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Ayant monté de l’Égypte, ils arrivèrent dans le pays de Canaan, auprès de Jacob, leur père. ");
INSERT INTO francl_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Ils lui dirent : « Joseph vit encore, c’est même lui qui gouverne tout le pays d’Égypte. » Mais son cœur resta froid, parce qu’il ne les croyait pas. ");
INSERT INTO francl_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Ils lui rapportèrent alors toutes les paroles que Joseph avait dites. Lorsqu’il eut vu les chariots que Joseph avait envoyés pour le transporter, l’esprit de Jacob, leur père, se ranima, ");
INSERT INTO francl_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","et Israël dit : « C’est assez ! Joseph, mon fils, vit encore ! j’irai et je le verrai avant de mourir. » ");
INSERT INTO francl_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Israël partit avec tout ce qui lui appartenait. Arrivé à Bersabée, il offrit des sacrifices au Dieu de son père Isaac. ");
INSERT INTO francl_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Et Dieu parla à Israël dans une vision de nuit, et il dit : « Jacob ! Jacob ! » Israël répondit : « Me voici. » ");
INSERT INTO francl_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Et Dieu dit : « Je suis le Dieu fort, le Dieu de ton père. Ne crains pas de descendre en Égypte, car là je te ferai devenir une grande nation. ");
INSERT INTO francl_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Moi-même je descendrai avec toi en Égypte, et moi-même aussi je t’en ferai sûrement remonter ; et Joseph posera sa main sur tes yeux. » ");
INSERT INTO francl_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Jacob, se levant, quitta Bersabée ; et les fils d’Israël mirent Jacob, leur père, ainsi que leurs femmes et leurs enfants, sur les chariots que Pharaon avait envoyés pour le transporter. ");
INSERT INTO francl_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Ils prirent aussi leurs troupeaux et leurs biens qu’ils avaient acquis dans le pays de Canaan. Et Jacob se rendit en Égypte avec toute sa famille. ");
INSERT INTO francl_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Il emmena avec lui en Égypte ses fils et les fils de ses fils, ses filles et les filles de ses fils, et toute sa famille. ");
INSERT INTO francl_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Voici les noms des fils d’Israël qui vinrent en Égypte : Jacob et ses fils. — Premier-né de Jacob, Ruben. — ");
INSERT INTO francl_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Fils de Ruben : Hénoch, Phallu, Hesron et Charmi. — ");
INSERT INTO francl_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Fils de Siméon : Jamuel, Jamin, Ahod, Jachin et Sohar, et Saul, fils de la Chananéenne. — ");
INSERT INTO francl_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Fils de Lévi : Gerson, Caat et Mérari. — ");
INSERT INTO francl_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Fils de Juda : Her, Onan, Séla, Pharès et Zara ; mais Her et Onan étaient morts au pays de Canaan. Les fils de Pharès furent Hesron et Hamul. — ");
INSERT INTO francl_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Fils d’Issachar : Thola, Phua, Job et Semron. — ");
INSERT INTO francl_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Fils de Zabulon : Sared, Elon et Jahélel — ");
INSERT INTO francl_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Ce sont là les fils que Lia enfanta à Jacob à Paddan-Aram, avec sa fille Dina. Ses fils et ses filles étaient en tout trente-trois personnes. ");
INSERT INTO francl_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Fils de Gad : Séphion, Haggi, Suni, Esebon, Heri, Arodi et Aréli. — ");
INSERT INTO francl_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Fils d’Aser : Jamné, Jésua, Jessui et Béria, et Sara, leur sœur. Les fils de Béria furent Héber et Melchiel. — ");
INSERT INTO francl_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Ce sont là les fils de Zelpha, que Laban avait donnée à Lia, sa fille ; et elle les enfanta à Jacob : en tout seize personnes. ");
INSERT INTO francl_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Fils de Rachel, femme de Jacob : Joseph et Benjamin. ");
INSERT INTO francl_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Il naquit à Joseph, au pays d’Égypte, des fils que lui enfanta Aseneth, fille de Putiphar, prêtre d’On, savoir Manassé et Ephraïm. — ");
INSERT INTO francl_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Fils de Benjamin : Béla, Bochor, Asbel, Géra, Naaman, Echi, Ros, Mophim, Ophim et Ared. — ");
INSERT INTO francl_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Ce sont là les fils de Rachel, qui naquirent à Jacob : en tout quatorze personnes. ");
INSERT INTO francl_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Fils de Dan : Husim. — ");
INSERT INTO francl_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Fils de Nephtali : Jasiel, Guni, Jéser et Salem. — ");
INSERT INTO francl_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Ce sont là les fils de Bala, que Laban avait donnée à Rachel, sa fille ; et elle les enfanta à Jacob : en tout sept personnes. ");
INSERT INTO francl_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Toutes les personnes qui vinrent avec Jacob en Égypte, issues de lui, sans compter les femmes des fils de Jacob, étaient au nombre de soixante-six en tout. ");
INSERT INTO francl_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Les fils de Joseph qui lui étaient nés en Égypte étaient deux. — Le total des personnes de la famille de Jacob qui vinrent en Égypte était de soixante-dix. ");
INSERT INTO francl_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Jacob avait envoyé Juda devant lui vers Joseph pour préparer son arrivée en Gessen. Lorsque Jacob et les siens furent entrés en Gessen, ");
INSERT INTO francl_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Joseph fit atteler son char et y monta, pour aller en Gessen, à la rencontre d’Israël, son père. Il se montra à lui et, s’étant jeté à son cou, il pleura longtemps sur son cou. ");
INSERT INTO francl_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Israël dit à Joseph : « Je puis mourir maintenant, puisque j’ai vu ton visage et que tu vis encore ! » ");
INSERT INTO francl_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Joseph dit à ses frères et à la famille de son père : « Je vais avertir Pharaon et je lui dirai : Mes frères et la famille de mon père, qui étaient au pays de Canaan, sont venus vers moi. ");
INSERT INTO francl_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Ces hommes font paître des brebis, car ce sont des propriétaires de troupeaux ; ils ont amené leurs brebis et leurs bœufs, et tout ce qui leur appartient. ");
INSERT INTO francl_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Et quand Pharaon vous appellera et dira : Quelle est votre occupation ? ");
INSERT INTO francl_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","vous répondrez : Nous, tes serviteurs, sommes des propriétaires de troupeaux depuis notre jeunesse jusqu’à présent comme l’étaient nos pères. De cette manière vous habiterez dans le pays de Gessen, car tous les bergers sont en abomination aux Egyptiens. » ");
INSERT INTO francl_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Joseph alla porter la nouvelle à Pharaon, en disant : « Mon père et mes frères sont venus du pays de Canaan avec leurs brebis et leurs bœufs, et tout ce qui leur appartient, et les voici dans le pays de Gessen. » ");
INSERT INTO francl_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Ayant pris cinq de ses frères, il les présenta à Pharaon ; ");
INSERT INTO francl_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","et Pharaon leur dit : « Quelle est votre occupation ? » Ils répondirent à Pharaon : « Nous, tes serviteurs, sommes bergers, comme l’étaient nos pères. » ");
INSERT INTO francl_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Ils dirent encore à Pharaon : « Nous sommes venus pour séjourner dans le pays, car il n’y a plus de pâture pour les brebis de tes serviteurs, la famine s’étant appesantie sur le pays de Canaan. Permets donc à tes serviteurs d’habiter dans le pays de Gessen. » ");
INSERT INTO francl_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Pharaon dit à Joseph : « Ton père et tes frères sont venus auprès de toi. Le pays d’Égypte est devant toi : établis ton père et tes frères dans la meilleure partie du pays. ");
INSERT INTO francl_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Qu’ils demeurent dans le pays de Gessen ; et, si tu trouves parmi eux des hommes capables, mets-les à la tête des troupeaux qui m’appartiennent. » ");
INSERT INTO francl_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Joseph fit venir Jacob, son père, et le présenta à Pharaon. Jacob bénit Pharaon ; ");
INSERT INTO francl_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","et Pharaon dit à Jacob : « Quel est le nombre de jours des années de ta vie ? » ");
INSERT INTO francl_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Jacob répondit à Pharaon : « Les jours des années de mon pèlerinage sont de cent trente ans. Courts et mauvais ont été les jours des années de ma vie, et ils n’ont pas atteint les jours des années de la vie de mes pères durant leur pèlerinage. » ");
INSERT INTO francl_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Jacob bénit encore Pharaon et se retira de devant Pharaon. ");
INSERT INTO francl_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Joseph établit son père et ses frères, et leur assigna une propriété dans le pays d’Égypte, dans la meilleure partie du pays, dans la contrée de Ramsès, ainsi que Pharaon l’avait ordonné ; ");
INSERT INTO francl_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","et Joseph fournit de pain son père et ses frères, et toute la famille de son père, selon le nombre des enfants. ");
INSERT INTO francl_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Il n’y avait plus de pain dans tout le pays, car la famine était très grande ; le pays d’Égypte et le pays de Canaan étaient épuisés à cause de la famine. ");
INSERT INTO francl_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Joseph recueillit tout l’argent qui se trouvait dans le pays d’Égypte et dans le pays de Canaan, contre le blé qu’on achetait, et il fit entrer cet argent dans la maison de Pharaon. ");
INSERT INTO francl_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Quand il n’y eut plus d’argent dans le pays d’Égypte et dans le pays de Canaan, tous les Egyptiens vinrent à Joseph, en disant : « Donne-nous du pain ! Pourquoi mourrions-nous en ta présence ? Car nous sommes à bout d’argent. » ");
INSERT INTO francl_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Joseph dit : « Amenez vos troupeaux, et je vous donnerai du pain en échange de vos troupeaux, puisque vous êtes à bout d’argent. » ");
INSERT INTO francl_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Ils amenèrent leurs troupeaux à Joseph, et Joseph leur donna du pain en échange des chevaux, des troupeaux de brebis et de bœufs, et des ânes. Il leur fournit ainsi du pain cette année-là, en échange de tous leurs troupeaux. ");
INSERT INTO francl_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Lorsque cette année fut écoulée, ils vinrent à Joseph l’année suivante, et lui dirent : « Nous ne cacherons pas à mon seigneur que l’argent est épuisé et que les troupeaux de bétail ont été donnés à mon seigneur ; il ne reste devant mon seigneur que nos corps et nos terres. ");
INSERT INTO francl_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Pourquoi péririons-nous sous tes yeux, nous et nos terres ? Achète-nous, ainsi que nos terres, pour du pain, et nous serons, nous et nos terres, serfs de Pharaon ; et donne-nous de quoi semer, afin que nous vivions et que nous ne mourions pas, et que nos terres ne soient pas désolées. » ");
INSERT INTO francl_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Joseph acquit ainsi toutes les terres de l’Égypte à Pharaon ; car les Egyptiens vendirent chacun leur champ, parce que la famine les pressait, et le pays devint la propriété de Pharaon. ");
INSERT INTO francl_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Il fit passer le peuple dans les villes, d’une extrémité à l’autre du territoire de l’Égypte. ");
INSERT INTO francl_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Il n’y eut que les terres des prêtres qu’il n’acquit pas ; car les prêtres recevaient de Pharaon une portion déterminée, et ils vécurent de leur revenu que Pharaon leur assignait : c’est pourquoi ils ne vendirent pas leurs terres. ");
INSERT INTO francl_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Joseph dit au peuple : « Je vous ai acquis aujourd’hui avec vos terres pour Pharaon. Voici pour vous de la semence, ensemencez la terre. ");
INSERT INTO francl_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","A la récolte, vous donnerez le cinquième à Pharaon, et vous aurez les quatre autres parties pour ensemencer vos champs et pour vous nourrir, vous et ceux qui sont dans vos maisons, et pour nourrir vos enfants. » ");
INSERT INTO francl_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Ils dirent : « Nous te devons la vie ! Que nous trouvions grâce auprès de mon seigneur, et nous serons esclaves de Pharaon. » ");
INSERT INTO francl_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Joseph fit de cela une loi, qui subsiste jusqu’à ce jour, et en vertu de laquelle le cinquième du produit des terres d’Égypte appartient à Pharaon ; seules les terres des prêtres ne sont pas à lui. ");
INSERT INTO francl_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Israël habita au pays d’Égypte, dans la contrée de Gessen ; ils y acquirent des possessions, ils furent féconds et multiplièrent beaucoup. ");
INSERT INTO francl_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Jacob vécut dix-sept ans dans le pays d’Égypte ; et les jours de Jacob, les années de sa vie furent de cent quarante-sept ans. ");
INSERT INTO francl_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Quand les jours d’Israël approchèrent de leur fin, il appela son fils Joseph et lui dit : « Si j’ai trouvé grâce à tes yeux, mets, je te prie, ta main sous ma cuisse, et use envers moi de bonté et de fidélité : ne m’enterre pas en Égypte. ");
INSERT INTO francl_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Quand je serai couché avec mes pères, tu me transporteras hors de l’Égypte, et tu m’enterreras dans leurs sépulcres. » Joseph répondit : « Je ferai selon ta parole. » ");
INSERT INTO francl_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Et Jacob dit : « Jure-le-moi. » Joseph le lui jura ; et Israël se prosterna sur le chevet du lit. ");
INSERT INTO francl_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Après ces choses, on vint dire à Joseph : « Voici que ton père est malade. » Il prit avec lui ses deux fils, Manassé et Ephraïm. ");
INSERT INTO francl_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","On avertit Jacob, en disant : « Voici ton fils Joseph qui vient vers toi. » Israël rassembla ses forces et s’assit sur son lit. ");
INSERT INTO francl_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Jacob dit à Joseph : « Le Dieu tout-puissant m’est apparu à Luz, dans le pays de Canaan, et il m’a béni, ");
INSERT INTO francl_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","en disant : Je te rendrai fécond, je te multiplierai, et je te ferai devenir une assemblée de peuples ; je donnerai ce pays à ta postérité après toi, pour qu’elle le possède à jamais. ");
INSERT INTO francl_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Et maintenant, les deux fils qui te sont nés dans le pays d’Égypte, avant mon arrivée vers toi en Égypte, seront miens ; Ephraïm et Manassé seront miens, comme Ruben et Siméon. ");
INSERT INTO francl_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Mais les enfants que tu as engendrés après eux seront tiens ; ils seront appelés du nom de leurs frères quant à leur part d’héritage. ");
INSERT INTO francl_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Et moi, quand je revenais de Paddan, Rachel mourut en route auprès de moi, dans le pays de Canaan, à une certaine distance d’Ephrata ; et c’est là que je l’ai enterrée sur le chemin d’Ephrata, qui est Bethléem. » ");
INSERT INTO francl_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Alors Israël vit les fils de Joseph, et dit : « Qui sont ceux-ci ? » ");
INSERT INTO francl_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Joseph répondit à son père : « Ce sont mes fils, que Dieu m’a donnés ici. « Et Israël dit : « Fais-les approcher de moi, je te prie, afin que je les bénisse. » ");
INSERT INTO francl_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Car les yeux d’Israël étaient obscurcis par l’âge, et il ne pouvait plus bien voir. Joseph les fit approcher de lui, et Israël les baisa, en les tenant embrassés. ");
INSERT INTO francl_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Et Israël dit à Joseph : « Je ne pensais plus revoir ton visage, et voici que Dieu me fait voir aussi ta postérité ! » ");
INSERT INTO francl_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Joseph les retira d’entre les genoux de son père et, s’étant prosterné en terre devant lui, ");
INSERT INTO francl_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Joseph les prit tous les deux, Ephraïm à sa droite, à la gauche d’Israël, et Manassé à sa gauche, à la droite d’Israël, et il les fit approcher. ");
INSERT INTO francl_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Israël étendit sa main droite et la posa sur la tête d’Ephraïm, qui était le plus jeune, et il posa sa main gauche sur la tête de Manassé ; c’est à dessein qu’il posa ainsi ses mains, car Manassé était l’aîné. ");
INSERT INTO francl_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Il bénit Joseph, en disant : « Que le Dieu en présence duquel ont marché mes pères Abraham et Isaac, que le Dieu qui m’a nourri depuis que j’existe jusqu’à ce jour, ");
INSERT INTO francl_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","que l’ange qui m’a délivré de tout mal, bénisse ces enfants ! Qu’ils soient appelés de mon nom et du nom de mes pères, Abraham et Isaac, et qu’ils multiplient en abondance au milieu du pays ! » ");
INSERT INTO francl_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Joseph, voyant que son père posait sa main droite sur la tête d’Ephraïm, en eut du déplaisir ; il prit la main de son père pour l’écarter de dessus la tête d’Ephraïm et la porter sur celle de Manassé ; ");
INSERT INTO francl_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","et Joseph dit à son père : « Pas ainsi, mon père, car celui-ci est le premier-né : mets ta main droite sur sa tête. » ");
INSERT INTO francl_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Mais son père refusa, en disant : « Je le sais, mon fils, je le sais ; lui aussi deviendra un peuple, lui aussi sera grand ; mais son frère cadet sera plus grand que lui, et sa postérité deviendra une multitude de nations. » ");
INSERT INTO francl_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Il les bénit donc ce jour-là et dit : « Par toi Israël bénira, en disant : Que Dieu te rende tel qu’Ephraïm et Manassé ! » Et il mit Ephraïm avant Manassé. ");
INSERT INTO francl_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Israël dit à Joseph : « Voici que je vais mourir. Mais Dieu sera avec vous, et il vous ramènera dans le pays de vos pères. ");
INSERT INTO francl_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Je te donne, de plus qu’à tes frères, une portion que j’ai prise de la main des Amorrhéens avec mon épée et mon arc. » ");
INSERT INTO francl_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Jacob appela ses fils et leur dit : « Rassemblez-vous, et je vous annoncerai ce qui vous arrivera à la fin des jours. ");
INSERT INTO francl_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Rassemblez-vous et écoutez, fils de Jacob ; écoutez Israël, votre père. ");
INSERT INTO francl_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","RUBEN, toi, mon premier-né, ma force, et le premier fruit de ma vigueur, supérieur en dignité et supérieur en puissance, ");
INSERT INTO francl_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","tu as bouillonné comme l’eau ; tu n’auras pas la prééminence ! Car tu es monté sur la couche de ton père, et tu as souillé ma couche en y montant ! ");
INSERT INTO francl_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","SIMÉON et LÉVI sont frères ; leurs glaives sont des instruments de violence. ");
INSERT INTO francl_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Que mon âme n’entre pas dans leur conseil ! Que mon âme ne s’unisse pas à leur assemblée ! Car, dans leur colère, ils ont égorgé des hommes, et, dans leur emportement, ils ont coupé les jarrets des taureaux. ");
INSERT INTO francl_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Maudite soit leur colère, car elle a été violente, et leur fureur, car elle a été cruelle ! Je les diviserai en Jacob, et je les disperserai en Israël. ");
INSERT INTO francl_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Toi, JUDA, tes frères te loueront ; ta main sera sur le cou de tes ennemis ; les fils de ton père se prosterneront devant toi. ");
INSERT INTO francl_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Juda est un jeune lion. Tu es remonté du carnage, mon fils ! Il a ployé les genoux, il s’est couché comme un lion, comme une lionne : qui le fera lever ? ");
INSERT INTO francl_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Le sceptre ne s’éloignera pas de Juda, ni le bâton de commandement d’entre ses pieds, jusqu’à ce que vienne Schiloh ; c’est à lui que les peuples obéiront. ");
INSERT INTO francl_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Il attache à la vigne son ânon, au cep le petit de son ânesse ; il lave son vêtement dans le vin, son manteau dans le sang de la grappe. ");
INSERT INTO francl_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Il a les yeux rouges de vin, et les dents blanches de lait. ");
INSERT INTO francl_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","ZABULON habite le bord de la mer, il est sur le rivage où abordent les navires ; son flanc est du côté de Sidon. ");
INSERT INTO francl_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","ISSACHAR est un âne robuste, qui se couche dans ses parcs. ");
INSERT INTO francl_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Il voit que le repos est bon, et que le pays est agréable ; et il courbe son épaule sous le fardeau ; il est devenu un homme asservi au tribut. ");
INSERT INTO francl_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","DAN juge son peuple, comme l’une des tribus d’Israël. ");
INSERT INTO francl_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan est un serpent sur le chemin, une vipère sur le sentier, qui mord les talons du cheval, pour que le cavalier tombe à la renverse. ");
INSERT INTO francl_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","J’espère en ton secours, ô Yahweh ! ");
INSERT INTO francl_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","GAD, des bandes armées le pressent, et lui, à son tour, les presse sur les talons. ");
INSERT INTO francl_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","D’ASER vient le pain savoureux, il fournit les mets délicats des rois. ");
INSERT INTO francl_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","NEPHTALI est une biche en liberté, il prononce des paroles gracieuses. ");
INSERT INTO francl_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","JOSEPH est le rejeton d’un arbre fertile, le rejeton d’un arbre fertile sur les bords d’une source ; ses branches s’élancent au-dessus de la muraille. ");
INSERT INTO francl_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Des archers le provoquent, ils lui lancent des flèches et l’attaquent. ");
INSERT INTO francl_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Mais son arc reste ferme, ses bras et ses mains sont rendus agiles, par les mains du Puissant de Jacob, par celui qui est le Pasteur et le Rocher d’Israël. ");
INSERT INTO francl_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Que du Dieu de ton père — il t’aidera ! — et du Tout-Puissant — il te bénira ! te viennent les bénédictions du ciel en haut, les bénédictions de l’abîme en bas, les bénédictions des mamelles et du sein maternel ! ");
INSERT INTO francl_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Les bénédictions de ton père surpassent les bénédictions des montagnes antiques, la beauté des collines éternelles : qu’elles soient sur la tête de Joseph, sur le front du prince de ses frères ! ");
INSERT INTO francl_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","BENJAMIN est un loup qui déchire ; le matin il dévore la proie, le soir il partage le butin. ");
INSERT INTO francl_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Ce sont là tous ceux qui formèrent les douze tribus d’Israël ; c’est ainsi que leur parla leur père et qu’il les bénit. Il les bénit chacun selon sa bénédiction. ");
INSERT INTO francl_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Puis il leur donna cet ordre : « Je vais être réuni à mon peuple ; enterrez-moi avec mes pères dans la caverne qui est dans le champ d’Ephron, le Hittite, ");
INSERT INTO francl_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","dans la caverne du champ de Macpéla, en face de Mambré, au pays de Canaan : c’est la caverne qu’Abraham a acquise d’Ephron, le Hittite, avec le champ, pour avoir un sépulcre qui lui appartienne. ");
INSERT INTO francl_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","C’est là qu’on a enterré Abraham et Sara, sa femme, c’est là qu’on a enterré Isaac et Rebecca, sa femme, et c’est là que j’ai enterré Lia. » ");
INSERT INTO francl_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Le champ et la caverne qui s’y trouve ont été acquis des fils de Heth. ");
INSERT INTO francl_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Lorsque Jacob eut achevé de donner ses ordres à ses fils, ayant retiré ses pieds dans le lit, il expira et fut réuni à ses pères. ");
INSERT INTO francl_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Joseph se jeta sur le visage de son père, pleura sur lui et le baisa. ");
INSERT INTO francl_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Puis il ordonna aux médecins à son service d’embaumer son père, et les médecins embaumèrent Israël. ");
INSERT INTO francl_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Ils y employèrent quarante jours, car c’est le temps que l’on emploie à embaumer ; et les Egyptiens le pleurèrent soixante-dix jours. ");
INSERT INTO francl_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Quand les jours de son deuil furent passés, Joseph s’adressa aux gens de la maison de Pharaon, et leur dit : « Si j’ai trouvé grâce à vos yeux, rapportez ceci, je vous prie, aux oreilles de Pharaon : ");
INSERT INTO francl_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Mon père m’a fait jurer, en disant : Voici que je vais mourir ; tu m’enterreras dans le sépulcre que je me suis creusé au pays de Canaan. Je voudrais donc y monter pour enterrer mon père ; et je reviendrai. » ");
INSERT INTO francl_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Pharaon répondit : « Monte et enterre ton père, comme il te l’a fait jurer. » ");
INSERT INTO francl_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Joseph monta pour enterrer son père. Avec lui montèrent tous les serviteurs de Pharaon, les anciens de sa maison, et tous les anciens du pays d’Égypte, ");
INSERT INTO francl_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","toute la maison de Joseph, ses frères et la maison de son père : ils ne laissèrent dans le pays de Gessen que leurs petits enfants, leurs brebis et leurs bœufs. ");
INSERT INTO francl_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Il montait encore avec Joseph des chars et des cavaliers, en sorte que le cortège était très nombreux. ");
INSERT INTO francl_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Arrivés à l’aire d’Atad, qui est au delà du Jourdain, ils firent entendre de grandes et profondes lamentations, et Joseph célébra en l’honneur de son père un deuil de sept jours. ");
INSERT INTO francl_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Les habitants du pays, les Chananéens, ayant vu ce deuil dans l’aire d’Atad, dirent : « Voilà un grand deuil parmi les Egyptiens ! » C’est pourquoi l’on a donné le nom d’Abel-Mitsraïm à ce lieu, qui est au delà du Jourdain. ");
INSERT INTO francl_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Les fils de Jacob firent donc envers lui comme il leur avait commandé. ");
INSERT INTO francl_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Ses fils le transportèrent au pays de Canaan et l’enterrèrent dans la caverne du champ de Macpéla, qu’Abraham avait acquise d’Ephron le Hittite, avec le champ, pour avoir un sépulcre qui lui appartint, vis-à-vis de Mambré. ");
INSERT INTO francl_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Après avoir enterré son père, Joseph retourna en Égypte avec ses frères et tous ceux qui étaient montés avec lui pour enterrer son père. ");
INSERT INTO francl_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Quand les frères de Joseph virent que leur père était mort, ils dirent : « Si Joseph nous prenait en haine, et nous rendait tout le mal que nous lui avons fait ! » ");
INSERT INTO francl_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Et ils firent dire à Joseph : « Ton père a donné cet ordre avant de mourir : ");
INSERT INTO francl_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","Vous parlerez ainsi à Joseph : Oh ! pardonne le crime de tes frères et leur péché, car ils t’ont fait du mal ! Maintenant donc, je te prie, pardonne le crime des serviteurs du Dieu de ton père. » Joseph pleura, en entendant ces paroles. ");
INSERT INTO francl_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Ses frères vinrent eux-mêmes se prosterner devant lui, en disant : « Nous sommes tes serviteurs. » ");
INSERT INTO francl_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Joseph leur dit : « Soyez sans crainte ; car suis-je à la place de Dieu ? ");
INSERT INTO francl_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Vous aviez dans la pensée de me faire du mal ; mais Dieu avait dans la sienne d’en faire sortir du bien, afin d’accomplir ce qui arrive aujourd’hui, afin de conserver la vie à un peuple nombreux. ");
INSERT INTO francl_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Soyez donc sans crainte ; je vous entretiendrai, vous et vos enfants. » C’est ainsi qu’il les consola, en parlant à leurs cœurs. ");
INSERT INTO francl_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Joseph demeura en Égypte, lui et la maison de son père. Il vécut cent dix ans. ");
INSERT INTO francl_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Joseph vit les fils d’Ephraïm jusqu’à la troisième génération ; des fils de Machir, fils de Manassé, naquirent aussi sur les genoux de Joseph. ");
INSERT INTO francl_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Joseph dit à ses frères : « Pour moi, je vais mourir ; mais Dieu vous visitera certainement et vous fera remonter de ce pays dans le pays qu’il a juré de donner à Abraham, à Isaac et à Jacob. » ");
INSERT INTO francl_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Joseph fit jurer les fils d’Israël, en disant : « Certainement Dieu vous visitera, et vous ferez remonter mes os d’ici. » ");
INSERT INTO francl_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Joseph mourut, âgé de cent dix ans. On l’embauma et on le mit dans un cercueil en Égypte. ");
INSERT INTO francl_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Voici les noms des enfants d’Israël venus en Égypte ; — ils y vinrent avec Jacob, chacun avec sa famille — : ");
INSERT INTO francl_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ruben, Siméon, Lévi, Juda, ");
INSERT INTO francl_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Issachar, Zabulon, Benjamin, ");
INSERT INTO francl_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan, Nephtali, Gad et Aser. ");
INSERT INTO francl_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Toutes les personnes issues de Jacob étaient au nombre de soixante-dix, et Joseph était déjà en Égypte. ");
INSERT INTO francl_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Joseph mourut, ainsi que tous ses frères et toute cette génération. ");
INSERT INTO francl_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Les enfants d’Israël furent féconds et multiplièrent ; ils devinrent nombreux et très puissants, et le pays en fut rempli. ");
INSERT INTO francl_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Il s’éleva sur l’Égypte un nouveau roi qui ne connaissait pas Joseph. ");
INSERT INTO francl_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Il dit à son peuple : « Voici que les enfants d’Israël forment un peuple plus nombreux et plus puissant que nous. ");
INSERT INTO francl_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Allons ! Prenons des précautions contre lui, de peur qu’il ne s’accroisse, et que, une guerre survenant, il ne se joigne à nos ennemis pour nous combattre, et ne sorte ensuite du pays. » ");
INSERT INTO francl_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Les Égyptiens établirent donc sur Israël des chefs de corvée, afin de l’accabler par des travaux pénibles. C’est ainsi qu’il bâtit des villes pour servir de magasins à Pharaon, savoir Pithom et Ramsès. ");
INSERT INTO francl_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Mais plus on l’accablait, plus il multipliait et s’accroissait, et l’on prit en aversion les enfants d’Israël. ");
INSERT INTO francl_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Les Égyptiens firent travailler les enfants d’Israël par force ; ");
INSERT INTO francl_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","ils leur rendaient la vie amère par de rudes travaux, mortier, briques et toute sorte de travaux des champs, tout le travail qu’ils leur imposaient avec dureté. ");
INSERT INTO francl_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Le roi d’Égypte parla aussi aux sages-femmes des Hébreux, dont l’une se nommait Séphora, et l’autre Phua. ");
INSERT INTO francl_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","Il leur dit : « Quand vous accoucherez les femmes des Hébreux, et que vous les verrez sur le double siège, si c’est un fils, faites-le mourir ; si c’est une fille, elle peut vivre. » ");
INSERT INTO francl_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Mais les sages-femmes craignirent Dieu, et ne firent pas comme leur avait dit le roi d’Égypte ; elles laissèrent vivre les garçons. ");
INSERT INTO francl_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Le roi d’Égypte fit appeler les sages-femmes et leur dit : « Pourquoi avez-vous agi ainsi, et avez-vous laissé vivre les garçons ? » ");
INSERT INTO francl_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Les sages-femmes répondirent à Pharaon : « C’est que les femmes des Hébreux ne ressemblent pas aux Égyptiennes : elles sont vigoureuses, et elles accouchent avant l’arrivée de la sage-femme. » ");
INSERT INTO francl_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Et Dieu fit du bien aux sages-femmes, et le peuple devint nombreux et extrêmement fort. ");
INSERT INTO francl_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Parce que les sages-femmes avaient craint Dieu, Dieu fit prospérer leur maison. ");
INSERT INTO francl_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Alors Pharaon donna cet ordre à tout son peuple : « Vous jetterez dans le fleuve tout fils qui naîtra et vous laisserez vivre toutes les filles. » ");
INSERT INTO francl_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Un homme de la maison de Lévi était allé prendre pour femme une fille de Lévi. ");
INSERT INTO francl_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Cette femme devint enceinte et enfanta un fils. Voyant qu’il était beau, elle le cacha pendant trois mois. ");
INSERT INTO francl_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Comme elle ne pouvait plus le tenir caché, elle prit une caisse de jonc et, l’ayant enduite de bitume et de poix, elle y mit l’enfant et le déposa parmi les roseaux, sur le bord du fleuve. ");
INSERT INTO francl_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","La sœur de l’enfant se tenait à quelque distance pour savoir ce qui lui arriverait. ");
INSERT INTO francl_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","La fille de Pharaon descendit au fleuve pour se baigner, et ses compagnes se promenaient le long du fleuve. Ayant aperçu la caisse au milieu des roseaux, elle envoya sa servante pour la prendre. ");
INSERT INTO francl_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Elle l’ouvrit et vit l’enfant : c’était un petit garçon qui pleurait ; elle en eut pitié, et elle dit : « C’est un enfant des Hébreux. » ");
INSERT INTO francl_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Alors la sœur de l’enfant dit à la fille de Pharaon : « Veux-tu que j’aille te chercher une nourrice parmi les femmes des Hébreux pour allaiter cet enfant ? » ");
INSERT INTO francl_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","— « Va » lui dit la fille de Pharaon ; et la jeune fille alla chercher la mère de l’enfant. ");
INSERT INTO francl_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","La fille de Pharaon lui dit : « Emporte cet enfant et allaite-le-moi ; je te donnerai ton salaire. » La femme prit l’enfant et l’allaita. ");
INSERT INTO francl_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Quand il eut grandi, elle l’amena à la fille de Pharaon, et il fut pour elle comme un fils. Elle lui donna le nom de Moïse, « car, dit-elle, je l’ai tiré des eaux. » ");
INSERT INTO francl_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","En ce temps-là, Moïse, devenu grand, sortit vers ses frères, et il fut témoin de leurs pénibles travaux ; il vit un Égyptien qui frappait un Hébreu d’entre ses frères. ");
INSERT INTO francl_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Ayant tourné les yeux de côté et d’autre, et voyant qu’il n’y avait là personne, il tua l’Egyptien et le cacha dans le sable. ");
INSERT INTO francl_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Il sortit encore le jour suivant, et voici, deux Hébreux se querellaient. Il dit au coupable : « Pourquoi frappes-tu ton camarade ? » ");
INSERT INTO francl_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Et cet homme répondit : « Qui t’a établi chef et juge sur nous ? Est-ce que tu veux me tuer, comme tu as tué l’Egyptien ? » Moïse fut effrayé, et il dit : « Certainement la chose est connue. » ");
INSERT INTO francl_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Pharaon, ayant appris ce qui s’était passé, cherchait à faire mourir Moïse ; mais Moïse s’enfuit de devant Pharaon ; il se retira dans le pays de Madian, et il s’assit près du puits. ");
INSERT INTO francl_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Le prêtre de Madian avait sept filles. Elles vinrent puiser de l’eau, et elles remplirent les auges pour abreuver le troupeau de leur père. ");
INSERT INTO francl_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Les bergers, étant arrivés, les chassèrent ; alors Moïse se leva, prit leur défense et fit boire leur troupeau. ");
INSERT INTO francl_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Quand elles furent de retour auprès de Raguel, leur père, il dit : « Pourquoi revenez-vous sitôt aujourd’hui ? » ");
INSERT INTO francl_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Elles répondirent : « Un Égyptien nous a délivrées de la main des bergers, et même il a puisé pour nous de l’eau et il a fait boire le troupeau. » ");
INSERT INTO francl_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Il dit à ses filles : « Où est-il ? Pourquoi avez-vous laissé cet homme ? Rappelez-le, pour qu’il prenne quelque nourriture. » ");
INSERT INTO francl_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Moïse consentit à demeurer chez cet homme, qui lui donna pour femme Séphora, sa fille. ");
INSERT INTO francl_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Elle enfanta un fils, qu’il appela Gersam, « car, dit-il, je suis un étranger sur une terre étrangère. » ");
INSERT INTO francl_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Durant ces longs jours, le roi d’Égypte mourut. Les enfants d’Israël, gémissant encore sous la servitude, poussèrent des cris, et ces cris, arrachés par la servitude, montèrent jusqu’à Dieu. ");
INSERT INTO francl_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Dieu entendit leurs gémissements, et se souvint de son alliance avec Abraham, Isaac et Jacob. ");
INSERT INTO francl_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Dieu regarda les enfants d’Israël et il les reconnut. ");
INSERT INTO francl_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Moïse faisait paître le troupeau de Jéthro, son beau-père, prêtre de Madian. Il mena le troupeau au delà du désert, et arriva à la montagne de Dieu, à Horeb. ");
INSERT INTO francl_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","L’ange de Yahweh lui apparut en flamme de feu, du milieu du buisson. Et Moïse vit, et voici, le buisson était tout en feu, et le buisson ne se consumait pas. ");
INSERT INTO francl_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Moïse dit : « Je veux faire un détour pour considérer cette grande vision, et voir pourquoi le buisson ne se consume point. » ");
INSERT INTO francl_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Yahweh vit qu’il se détournait pour regarder ; et Dieu l’appela du milieu du buisson, et dit : « Moïse ! Moïse ! » Il répondit : « Me voici. » ");
INSERT INTO francl_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Dieu dit : « N’approche pas d’ici, ôte tes sandales de tes pieds, car le lieu sur lequel tu te tiens est une terre sainte. » ");
INSERT INTO francl_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Il ajouta : « Je suis le Dieu de ton père, le Dieu d’Abraham, le Dieu d’Isaac et le Dieu de Jacob. » Moïse se cacha le visage, car il craignait de regarder Dieu. ");
INSERT INTO francl_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Yahweh dit : « J’ai vu la souffrance de mon peuple qui est en Égypte, et j’ai entendu le cri que lui font pousser ses exacteurs, car je connais ses douleurs. ");
INSERT INTO francl_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Je suis descendu pour le délivrer de la main des Égyptiens et pour le faire monter de ce pays dans une terre fertile et spacieuse, dans une terre où coulent le lait et le miel, au lieu qu’habitent les Chananéens, les Hittites, les Amorrhéens, les Phérézéens, les Hévéens et les Jébuséens. ");
INSERT INTO francl_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Et maintenant voici, le cri des enfants d’Israël est venu jusqu’à moi, et j’ai vu l’oppression que font peser sur eux les Égyptiens. ");
INSERT INTO francl_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Et maintenant, va, je t’envoie auprès de Pharaon, pour faire sortir mon peuple, les enfants d’Israël. » ");
INSERT INTO francl_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Moïse dit à Dieu : « Qui suis-je, pour aller vers Pharaon et pour faire sortir d’Égypte les enfants d’Israël ? » ");
INSERT INTO francl_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Dieu dit : « Je serai avec toi ; et ceci sera pour toi le signe que c’est moi qui t’ai envoyé : Quand tu auras fait sortir le peuple d’Égypte, vous servirez Dieu sur cette montagne. » ");
INSERT INTO francl_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Moïse dit à Dieu : « Voici, j’irai vers les enfants d’Israël, et je leur dirai : Le Dieu de vos pères m’envoie vers vous. S’ils me demandent quel est son nom, que leur répondrai-je ? » ");
INSERT INTO francl_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Et Dieu dit à Moïse : « Je suis celui qui suis. » Et il ajouta : « C’est ainsi, que tu répondras aux enfants d’Israël : Celui qui est m’envoie vers vous. » ");
INSERT INTO francl_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Dieu dit encore à Moïse : « Tu parleras ainsi aux enfants d’Israël : Yahweh, le Dieu de vos pères, le Dieu d’Abraham, le Dieu d’Isaac et le Dieu de Jacob, m’envoie vers vous. C’est là mon nom pour l’éternité ; c’est là mon souvenir de génération en génération. ");
INSERT INTO francl_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Va, rassemble les anciens d’Israël et dis-leur : Yahweh, le Dieu de vos pères, m’est apparu, le Dieu d’Abraham, d’Isaac et de Jacob, en disant : Je vous ai visités, j’ai vu ce qu’on vous fait en Égypte, ");
INSERT INTO francl_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","et j’ai dit : Je vous ferai monter de l’Égypte, où l’on vous opprime, dans le pays des Chananéens, des Hittites, des Amorrhéens, des Phérézéens, des Hévéens et des Jébuséens, dans un pays où coulent le lait et le miel. ");
INSERT INTO francl_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Ils écouteront ta voix, et tu iras, toi et les anciens d’Israël, vers le roi d’Égypte, et vous lui direz : Yahweh, le Dieu des Hébreux, s’est présenté à nous. Et maintenant, laisse-nous aller à trois journées de marche dans le désert, pour offrir des sacrifices à Yahweh notre Dieu. ");
INSERT INTO francl_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Je sais que le roi d’Égypte ne vous permettra pas d’aller, si ce n’est forcé par une main puissante. ");
INSERT INTO francl_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","J’étendrai ma main et je frapperai l’Égypte par toutes sortes de prodiges que je ferai au milieu d’elle ; après quoi, il vous laissera aller. ");
INSERT INTO francl_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Je ferai même que ce peuple trouve grâce aux yeux des Égyptiens et, quand vous partirez, vous ne partirez pas les mains vides. ");
INSERT INTO francl_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Mais chaque femme demandera à sa voisine et à celle qui demeure dans sa maison des objets d’argent, des objets d’or et des vêtements que vous mettrez sur vos fils et vos filles. Et vous dépouillerez l’Égypte. » ");
INSERT INTO francl_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Moïse répondit, en disant : « Ils ne me croiront pas et ils n’écouteront pas ma voix ; mais ils diront : Yahweh ne t’est pas apparu. » ");
INSERT INTO francl_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Yahweh lui dit : « Qu’y a-t-il dans ta main ? » Il répondit : « Un bâton. » ");
INSERT INTO francl_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Et Yahweh dit : « Jette-le à terre. » Il le jeta à terre, et ce bâton devint un serpent, et Moïse s’enfuyait devant lui. ");
INSERT INTO francl_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Yahweh dit à Moïse : « Etends ta main, et saisis-le par la queue, — et il étendit la main et le saisit, et le serpent redevint un bâton dans sa main, — ");
INSERT INTO francl_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","afin qu’ils croient que Yahweh, le Dieu de leurs pères, t’est apparu, le Dieu d’Abraham, le Dieu d’Isaac et le Dieu de Jacob. » ");
INSERT INTO francl_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Yahweh lui dit encore : « Mets ta main dans ton sein. » Il mit sa main dans son sein, puis il l’en retira et voici qu’elle était couverte de lèpre, blanche comme la neige. ");
INSERT INTO francl_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Yahweh dit : « Remets ta main dans ton sein, — et il remit sa main dans son sein, puis il la retira de son sein, et voici qu’elle était redevenue semblable à sa chair. — ");
INSERT INTO francl_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","S’ils ne te croient pas, et s’ils n’écoutent pas la voix du premier signe, ils croiront à la voix du second. ");
INSERT INTO francl_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Et s’ils ne croient pas même à ces deux signes, et n’écoutent pas ta voix, tu prendras de l’eau du fleuve, et tu la répandras sur le sol, et l’eau que tu auras prise du fleuve deviendra du sang sur le sol. » ");
INSERT INTO francl_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Moïse dit à Yahweh : « Ah ! Seigneur, je ne suis pas un homme à la parole facile, et cela dès hier et dès avant-hier, et même encore depuis que vous parlez à votre serviteur ; j’ai la bouche et la langue embarrassées. » ");
INSERT INTO francl_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Yahweh lui dit : « Qui a donné la bouche à l’homme, et qui rend muet ou sourd, voyant ou aveugle ? N’est-ce pas moi, Yahweh ? ");
INSERT INTO francl_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Va donc, je serai avec ta bouche et je t’enseignerai ce que tu devras dire. » ");
INSERT INTO francl_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Moïse dit : « Ah ! Seigneur, envoyez votre message par qui vous voudrez l’envoyer. » ");
INSERT INTO francl_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Alors la colère de Yahweh s’enflamma contre Moïse, et il dit : « N’y a-t-il pas Aaron, ton frère, le Lévite ? Je sais qu’il parlera facilement, lui. Et même, voici qu’il vient à ta rencontre et, en te voyant, il se réjouira dans son cœur. ");
INSERT INTO francl_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Tu lui parleras et tu mettras les paroles dans sa bouche, et moi je serai avec ta bouche et avec sa bouche, et je vous enseignerai ce que vous aurez à faire. ");
INSERT INTO francl_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","C’est lui qui parlera pour toi au peuple ; il te servira de bouche, et tu lui seras un Dieu. ");
INSERT INTO francl_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Quant à ce bâton, prends-le dans ta main ; c’est avec quoi tu feras les signes. » ");
INSERT INTO francl_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Moïse s’en alla. De retour auprès de Jéthro, son beau-père, il lui dit : « Laisse-moi partir, je te prie, et retourner auprès de mes frères qui sont en Égypte, pour voir s’ils sont encore vivants. » Jéthro dit à Moïse : « Va en paix. » ");
INSERT INTO francl_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Yahweh dit à Moïse, en Madian : « Va, retourne en Égypte, car tous ceux qui en voulaient à ta vie sont morts. » ");
INSERT INTO francl_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Moïse prit donc sa femme et ses fils, et, les ayant fait monter sur des ânes, il retourna au pays d’Égypte ; Moïse prit dans sa main le bâton de Dieu. ");
INSERT INTO francl_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Yahweh dit à Moïse : « En partant pour retourner en Égypte, considère tous les prodiges que j’ai mis dans ta main : tu les feras devant Pharaon. Et moi, j’endurcirai son cœur, et il ne laissera pas aller le peuple. ");
INSERT INTO francl_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Tu diras à Pharaon : Ainsi parle Yahweh : « Israël est mon fils, mon premier-né. ");
INSERT INTO francl_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Je te dis : Laisse aller mon fils, pour qu’il me serve ; si tu refuses de le laisser aller, je ferai périr ton fils, ton premier-né. » ");
INSERT INTO francl_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Sur la route, dans un lieu où Moïse passa la nuit, Yahweh vint à sa rencontre et voulut le faire mourir. ");
INSERT INTO francl_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Séphora prit une pierre tranchante, coupa le prépuce de son fils, et en toucha les pieds de Moïse, en disant : « Tu es pour moi un époux de sang ! » ");
INSERT INTO francl_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Et Yahweh le laissa. C’est alors qu’elle dit : « Epoux de sang », à cause de la circoncision. ");
INSERT INTO francl_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Yahweh dit à Aaron : « Va au-devant de Moïse dans le désert. » Aaron partit et, ayant rencontré Moïse à la montagne de Dieu, il le baisa. ");
INSERT INTO francl_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Moïse fit connaître à Aaron toutes les paroles avec lesquelles Yahweh l’avait envoyé, et tous les signes qu’il lui avait ordonné de faire. ");
INSERT INTO francl_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Moïse et Aaron poursuivirent leur chemin, et ils assemblèrent tous les anciens des enfants d’Israël. ");
INSERT INTO francl_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Aaron rapporta toutes les paroles que Yahweh avait dites à Moïse, et il fit les signes sous les yeux du peuple. ");
INSERT INTO francl_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Et le peuple crut ; ils apprirent que Yahweh avait visité les enfants d’Israël et qu’il avait vu leur souffrance ; et, s’étant inclinés, ils adorèrent. ");
INSERT INTO francl_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Ensuite Moïse et Aaron se rendirent auprès de Pharaon et lui dirent : « Ainsi parle Yahweh, le Dieu d’Israël : Laisse aller mon peuple, pour qu’il célèbre une fête en mon honneur dans le désert. » ");
INSERT INTO francl_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Pharaon répondit : « Qui est Yahweh pour que j’obéisse à sa voix, en laissant aller Israël ? Je ne connais pas Yahweh, et je ne laisserai pas aller Israël. » ");
INSERT INTO francl_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Ils dirent : « Le Dieu des Hébreux s’est présenté à nous. Permets-nous de faire trois journées de marche au désert, pour offrir des sacrifices à Yahweh, afin qu’il ne nous frappe pas de la peste ou de l’épée. » ");
INSERT INTO francl_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Mais le roi d’Égypte leur dit : « Pourquoi, Moïse et Aaron, détournez-vous le peuple de son ouvrage ? Allez à vos corvées ! » ");
INSERT INTO francl_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Pharaon dit : « Voici que le peuple du pays est maintenant nombreux, et vous lui feriez interrompre ses corvées ! » ");
INSERT INTO francl_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Ce jour-là même, Pharaon donna cet ordre aux exacteurs du peuple et aux scribes : ");
INSERT INTO francl_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","« Vous ne donnerez plus, comme on l’a fait jusqu’ici, de paille au peuple pour faire des briques ; qu’ils aillent eux-mêmes ramasser de la paille. ");
INSERT INTO francl_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Néanmoins vous lui imposerez la quantité de briques qu’ils faisaient auparavant, sans en rien retrancher, car ce sont des paresseux ; voilà pourquoi ils crient, en disant : Nous voudrions aller faire des sacrifices à notre Dieu. ");
INSERT INTO francl_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Qu’on charge de travail ces gens-là ; qu’ils soient à la besogne et qu’ils ne prêtent plus l’oreille à des paroles de mensonge. » ");
INSERT INTO francl_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Les exacteurs du peuple et les scribes vinrent donc dire au peuple : « Ainsi parle Pharaon : Je ne vous donne plus de paille ; ");
INSERT INTO francl_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","allez vous-mêmes prendre de la paille où vous en trouverez, car on ne retranchera rien de votre tâche. » ");
INSERT INTO francl_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Le peuple se répandit dans tout le pays d’Égypte pour ramasser du chaume pour en faire de la paille hachée. ");
INSERT INTO francl_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Les exacteurs les pressaient, en disant : « Achevez vos travaux, ce qui est fixé pour chaque jour, comme lorsqu’on avait de la paille. » ");
INSERT INTO francl_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","On battit les scribes des enfants d’Israël, que les exacteurs de Pharaon avaient établis sur eux ; on disait : « Pourquoi n’avez-vous pas achevé hier et aujourd’hui votre tâche de briques, comme précédemment ? » ");
INSERT INTO francl_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Les scribes des enfants d’Israël allèrent se plaindre à Pharaon, en disant : « Pourquoi en agis-tu ainsi envers tes serviteurs ? ");
INSERT INTO francl_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","On ne fournit pas de paille à tes serviteurs, et l’on nous dit : Faites des briques ! Et voici, tes serviteurs sont battus, et ton peuple se trouve en faute. » ");
INSERT INTO francl_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Pharaon répondit : « Vous êtes des paresseux, des paresseux ! Voilà pourquoi vous dites : Nous voudrions aller offrir des sacrifices à Yahweh. ");
INSERT INTO francl_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Et maintenant, allez travailler ; on ne vous donnera pas de paille, et vous livrerez la même quantité de briques. » ");
INSERT INTO francl_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Les scribes des enfants d’Israël virent leur cruelle situation, puisqu’on leur disait : « Vous ne retrancherez rien de vos briques ; chaque jour la tâche du jour ! » ");
INSERT INTO francl_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Ayant trouvé Moïse et Aaron, qui se tenaient là pour les attendre à leur sortie de chez Pharaon, ");
INSERT INTO francl_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","ils leur dirent : « Que Yahweh vous voie, et qu’il juge, vous qui avez changé en aversion notre faveur aux yeux de Pharaon et de ses serviteurs, et qui avez mis dans leurs mains une épée pour nous tuer. » ");
INSERT INTO francl_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Alors Moïse retourna vers Yahweh, et dit : « Seigneur, pourquoi avez-vous fait du mal à ce peuple ? pourquoi donc m’avez-vous envoyé ? ");
INSERT INTO francl_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Depuis que je suis allé vers Pharaon pour parler en votre nom, il maltraite ce peuple, et vous n’avez en aucune manière délivré votre peuple. » ");
INSERT INTO francl_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Yahweh dit à Moïse : « Tu verras bientôt ce que je ferai à Pharaon : contraint par une main puissante, il les laissera aller ; contraint par une main puissante, il les chassera de son pays. » ");
INSERT INTO francl_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Dieu parla à Moïse, en disant : « Je suis Yahweh. ");
INSERT INTO francl_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Je suis apparu à Abraham, à Isaac et à Jacob comme Dieu tout-puissant, mais sous mon nom de Yahweh, je ne me suis pas fait connaître à eux. ");
INSERT INTO francl_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","J’ai aussi établi mon alliance avec eux pour leur donner le pays de Canaan, le pays de leurs pèlerinages, où ils ont séjourné en étrangers. ");
INSERT INTO francl_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","J’ai entendu le gémissement des enfants d’Israël que les Égyptiens tiennent dans la servitude, et je me suis souvenu de mon alliance. ");
INSERT INTO francl_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","C’est pourquoi dis aux enfants d’Israël : Je suis Yahweh ; je vous affranchirai des corvées des Égyptiens, je vous délivrerai de leur servitude, et je vous sauverai avec un bras étendu et par de grands jugements. ");
INSERT INTO francl_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Je vous prendrai pour mon peuple, je serai votre Dieu, et vous saurez que je suis Yahweh, votre Dieu, qui vous affranchis des corvées des Égyptiens. ");
INSERT INTO francl_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Je vous ferai entrer dans le pays que j’ai juré de donner à Abraham, à Isaac et à Jacob ; je vous le donnerai en possession : je suis Yahweh. » ");
INSERT INTO francl_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Ainsi parla Moïse aux enfants d’Israël ; mais ils n’écoutèrent pas Moïse, à cause de leur angoisse et de leur dure servitude. ");
INSERT INTO francl_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","« Va parler à Pharaon, roi d’Égypte, pour qu’il laisse aller les enfants d’Israël hors de son pays. » ");
INSERT INTO francl_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Moïse répondit en présence de Yahweh : « Voici, les enfants d’Israël ne m’ont pas écouté ; comment Pharaon m’écoutera-t-il, moi qui ai la parole difficile ? » ");
INSERT INTO francl_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Yahweh parla à Moïse et à Aaron, et leur donna des ordres au sujet des enfants d’Israël et au sujet de Pharaon, roi d’Égypte, pour faire sortir les enfants d’Israël du pays d’Égypte. ");
INSERT INTO francl_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Voici les chefs de leurs maisons : Fils de Ruben, premier-né d’Israël : Hénoch, Phallu, Hesron et Charmi ; ce sont là les familles de Ruben. ");
INSERT INTO francl_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Fils de Siméon : Jamuel, Jamin, Ahod, Jachin, Soar, et Saul, fils de la Chananéenne ; ce sont là les familles de Siméon. ");
INSERT INTO francl_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Voici les noms des fils de Lévi avec leurs postérités : Gerson, Caath et Mérari. Les années de la vie de Lévi furent de cent trente-sept ans. — ");
INSERT INTO francl_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Fils de Gerson : Lobni et Séméi, selon leurs familles. — ");
INSERT INTO francl_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Fils de Caath : Amram, Isaar, Hébron et Oziel. Les années de la vie de Caath furent de cent trente-trois ans. — ");
INSERT INTO francl_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Fils de Mérari : Moholi et Musi. — Ce sont là les familles de Lévi avec leurs postérités. ");
INSERT INTO francl_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amram prit pour femme Jochabed, sa tante, qui lui enfanta Aaron et Moïse. Les années de la vie d’Amram furent de cent trente-sept ans. — ");
INSERT INTO francl_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Fils d’Isaar : Coré, Nepheg et Zéchri. ");
INSERT INTO francl_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Fils d’Oziel : Misaël, Elisaphan et Séthri. ");
INSERT INTO francl_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aaron prit pour femme Elisabeth, fille d’Aminadab, sœur de Naasson ; et elle lui enfanta Nadab, Abiu, Eléazar et Ithamar. ");
INSERT INTO francl_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Fils de Coré : Aser, Elcana et Abiasaph ; ce sont là les familles des Corites. ");
INSERT INTO francl_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Eléazar, fils d’Aaron, prit pour femme une des filles de Phuthiel, qui lui enfanta Phinées. Tels sont les chefs des maisons des Lévites, selon leurs familles. ");
INSERT INTO francl_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Ce sont là l’Aaron et le Moïse auxquels Yahweh dit : « Faites sortir du pays d’Égypte les enfants d’Israël selon leurs armées. » ");
INSERT INTO francl_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Ce sont eux qui parlèrent à Pharaon, roi d’Égypte, pour faire sortir d’Égypte les enfants d’Israël ; c’est ce Moïse et cet Aaron. ");
INSERT INTO francl_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Lorsque Yahweh parla à Moïse dans le pays d’Égypte, ");
INSERT INTO francl_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","Yahweh dit à Moïse : « Je suis Yahweh. Dis à Pharaon, roi d’Égypte, tout ce que je te dis. » ");
INSERT INTO francl_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Et Moïse répondit en présence de Yahweh : « Voici, j’ai la parole difficile ; comment Pharaon m’écoutera-t-il ? » ");
INSERT INTO francl_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Yahweh dit à Moïse : « Vois, j’ai fait de toi un dieu pour Pharaon, et Aaron, ton frère, sera ton prophète. ");
INSERT INTO francl_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Toi, tu diras tout ce que je te commanderai, et Aaron, ton frère, parlera à Pharaon, pour qu’il laisse partir de son pays les enfants d’Israël. ");
INSERT INTO francl_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Et moi, j’endurcirai le cœur de Pharaon, et je multiplierai mes signes et mes prodiges dans le pays d’Égypte. ");
INSERT INTO francl_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Pharaon ne vous écoutera pas et je mettrai ma main sur l’Égypte, et je ferai sortir du pays d’Égypte mes armées, mon peuple, les enfants d’Israël, par de grands jugements. ");
INSERT INTO francl_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Les Égyptiens connaîtront que je suis Yahweh, lorsque j’étendrai ma main sur l’Égypte et que je ferai sortir du milieu d’eux les enfants d’Israël. » ");
INSERT INTO francl_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Moïse et Aaron firent ce que Yahweh leur avait ordonné ; ainsi firent-ils. ");
INSERT INTO francl_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Moïse était âgé de quatre-vingts ans, et Aaron de quatre-vingt-trois ans, lorsqu’ils parlèrent à Pharaon. ");
INSERT INTO francl_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Yahweh dit à Moïse et à Aaron : ");
INSERT INTO francl_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","« Lorsque Pharaon vous parlera, en disant : Faites un miracle, tu diras à Aaron : Prends ton bâton et jette-le devant Pharaon ; il deviendra un serpent. » ");
INSERT INTO francl_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Moïse et Aaron allèrent auprès de Pharaon, et ils firent ce que Yahweh avait ordonné. Aaron jeta son bâton devant Pharaon et devant ses serviteurs, et il devint un serpent. ");
INSERT INTO francl_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Pharaon aussi appela ses sages et ses enchanteurs ; et les magiciens d’Égypte, eux aussi, firent la même chose par leurs enchantements : ");
INSERT INTO francl_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","ils jetèrent chacun leur bâton, et ces bâtons devinrent des serpents. Mais le bâton d’Aaron engloutit leurs bâtons. ");
INSERT INTO francl_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Et le cœur de Pharaon s’endurcit, et il n’écouta pas Moïse et Aaron, selon que Yahweh l’avait dit. ");
INSERT INTO francl_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Yahweh dit à Moïse : « Le cœur de Pharaon est endurci ; il refuse de laisser aller le peuple. ");
INSERT INTO francl_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Va vers Pharaon dès le matin ; voici qu’il sortira pour aller au bord de l’eau, et tu te tiendras pour l’attendre sur la rive du fleuve. Tu prendras en main le bâton qui a été changé en serpent, ");
INSERT INTO francl_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","et tu lui diras : Yahweh, Dieu des Hébreux, m’a envoyé vers toi pour te dire : Laisse aller mon peuple, afin qu’il me serve dans le désert. Et voici, jusqu’à présent tu n’as pas écouté. ");
INSERT INTO francl_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Ainsi dit Yahweh : A ceci tu connaîtras que je suis Yahweh : je vais frapper les eaux du fleuve avec le bâton qui est dans ma main, et elles seront changées en sang. ");
INSERT INTO francl_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Les poissons qui sont dans le fleuve mourront, le fleuve deviendra infect, et les Égyptiens répugneront à boire de l’eau du fleuve. » ");
INSERT INTO francl_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Yahweh dit à Moïse : « Dis à Aaron : Prends ton bâton et étends ta main sur les eaux de l’Égypte, sur ses rivières, sur ses canaux, sur ses étangs et sur tous ses réservoirs d’eau. Elles deviendront du sang, et il y aura du sang dans tout le pays d’Égypte, dans les vases de bois comme dans les vases de pierre. » ");
INSERT INTO francl_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Moïse et Aaron firent ce que Yahweh avait ordonné. Aaron, levant le bâton, frappa les eaux qui étaient dans le fleuve, sous les yeux de Pharaon et sous les yeux de ses serviteurs, et toutes les eaux du fleuve furent changées en sang. ");
INSERT INTO francl_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Les poissons qui étaient dans le fleuve moururent, le fleuve devint infect, les Égyptiens ne pouvaient plus boire de l’eau du fleuve, et il y eut du sang dans tout le pays d’Égypte. ");
INSERT INTO francl_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Mais les magiciens d’Égypte firent la même chose par leurs enchantements, et le cœur de Pharaon s’endurcit, et il n’écouta pas Moïse et Aaron, selon que Yahweh l’avait dit. ");
INSERT INTO francl_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Pharaon s’en retourna et, étant entré dans sa maison, il n’appliqua pas son cœur à ces choses. ");
INSERT INTO francl_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Tous les Égyptiens creusèrent aux environs du fleuve pour trouver de l’eau potable, car ils ne pouvaient boire de l’eau du fleuve. ");
INSERT INTO francl_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Il s’écoula sept jours, après que Yahweh eut frappé le fleuve. ");
INSERT INTO francl_vpl VALUES ("EX7_26","003_7_26","EXO","7","26","26","Yahweh dit à Moïse : « Va vers Pharaon, et tu lui diras : Ainsi dit Yahweh : Laisse aller mon peuple, afin qu’il me serve. ");
INSERT INTO francl_vpl VALUES ("EX7_27","003_7_27","EXO","7","27","27","Si tu refuses de le laisser aller, voici que je vais frapper du fléau des grenouilles toute l’étendue de ton pays. ");
INSERT INTO francl_vpl VALUES ("EX7_28","003_7_28","EXO","7","28","28","Le fleuve fourmillera de grenouilles ; elles monteront et entreront dans ta maison, dans ta chambre à coucher et sur ton lit, dans la maison de tes serviteurs, et au milieu de ton peuple, dans tes fours et dans tes pétrins ; ");
INSERT INTO francl_vpl VALUES ("EX7_29","003_7_29","EXO","7","29","29","sur toi, sur ton peuple et sur tous tes serviteurs les grenouilles monteront. » ");
INSERT INTO francl_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Yahweh dit à Moïse : « Dis à Aaron : étends ta main avec ton bâton sur les rivières, sur les canaux et sur les étangs, et fais monter les grenouilles sur le pays d’Égypte. » ");
INSERT INTO francl_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Aaron étendit sa main sur les eaux de l’Égypte, et les grenouilles montèrent et couvrirent le pays d’Égypte. ");
INSERT INTO francl_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Mais les magiciens firent la même chose par leurs enchantements ; ils firent monter les grenouilles sur le pays d’Égypte. ");
INSERT INTO francl_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Pharaon appela Moïse et Aaron, et leur dit : « Priez Yahweh afin qu’il éloigne les grenouilles de moi et de mon peuple, et je laisserai aller le peuple, pour qu’il offre des sacrifices à Yahweh. » ");
INSERT INTO francl_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Moïse dit à Pharaon : « Donne-moi tes ordres ! Pour quand dois-je faire des prières en ta faveur, en faveur de tes serviteurs et de ton peuple, afin que Yahweh éloigne les grenouilles de toi et de tes maisons, de manière à ce qu’il n’en reste plus que dans le fleuve ? » ");
INSERT INTO francl_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Il répondit : « Pour demain ». Et Moïse dit : « Il en sera ainsi, afin que tu saches que nul n’est pareil à Yahweh, notre Dieu. ");
INSERT INTO francl_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Les grenouilles se retireront de toi et de tes maisons, de tes serviteurs et de ton peuple ; il n’en restera que dans le fleuve. » ");
INSERT INTO francl_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Moïse et Aaron sortirent de chez Pharaon, et Moïse cria vers Yahweh au sujet des grenouilles dont il avait affligé Pharaon. ");
INSERT INTO francl_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Yahweh fit selon la parole de Moïse, et les grenouilles moururent dans les maisons, dans les cours et dans les champs. ");
INSERT INTO francl_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","On les entassa en monceaux, et le pays en fut infecté. ");
INSERT INTO francl_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Mais Pharaon, voyant qu’on respirait, endurcit son cœur, et il n’écouta pas Moïse et Aaron, selon que Yahweh l’avait dit. ");
INSERT INTO francl_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Yahweh dit à Moïse : « Dis à Aaron : Etends ton bâton et frappe la poussière de la terre, et elle se changera en moustiques dans tout le pays d’Égypte. » ");
INSERT INTO francl_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Ils firent ainsi ; Aaron étendit sa main avec son bâton et frappa la poussière de la terre, et les moustiques furent sur les hommes et sur les animaux. Toute la poussière de la terre fut changée en moustiques, dans tout le pays d’Égypte. ");
INSERT INTO francl_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Les magiciens firent de même avec leurs enchantements, afin de produire des moustiques ; mais ils ne le purent pas. Les moustiques étaient sur les hommes et sur les animaux. ");
INSERT INTO francl_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Et les magiciens dirent à Pharaon : « C’est le doigt d’un dieu ! » Et le cœur de Pharaon s’endurcit, et il ne les écouta pas, selon que Yahweh l’avait dit. ");
INSERT INTO francl_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Yahweh dit à Moïse : « Lève-toi de bon matin et présente-toi devant Pharaon, au moment où il sort pour aller au bord de l’eau. Tu lui diras : Ainsi parle Yahweh : Laisse aller mon peuple afin qu’il me serve. ");
INSERT INTO francl_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Si tu ne laisses pas aller mon peuple, je vais envoyer des scarabées contre toi, contre tes serviteurs, contre ton peuple et contre tes maisons ; les maisons des Égyptiens seront remplies de scarabées, ainsi que la terre qu’ils habitent. ");
INSERT INTO francl_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Mais je distinguerai, ce jour-là, le pays de Gessen, où mon peuple habite, et là il n’y aura pas de scarabées, afin que tu saches que moi, Yahweh, je suis au milieu de cette terre. ");
INSERT INTO francl_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","J’établirai ainsi une différence entre mon peuple et ton peuple ; c’est demain que ce signe aura lieu. » ");
INSERT INTO francl_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Yahweh fit ainsi ; il vint une multitude de scarabées dans la maison de Pharaon et de ses serviteurs, et tout le pays d’Égypte fut ravagé par les scarabées. ");
INSERT INTO francl_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Pharaon appela Moïse et Aaron, et leur dit : « Allez, offrez des sacrifices à votre Dieu dans ce pays. » ");
INSERT INTO francl_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Moïse répondit : « Il ne convient pas de faire ainsi, car c’est une abomination pour les Égyptiens que les sacrifices que nous offrons à Yahweh, notre Dieu ; et si nous offrons, sous les yeux des Égyptiens, des sacrifices qui sont pour eux des abominations, ne nous lapideront-ils pas ? ");
INSERT INTO francl_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Nous irons à trois journées de marche dans le désert pour offrir des sacrifices à Yahweh, notre Dieu, selon qu’il nous le dira. » ");
INSERT INTO francl_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Pharaon dit : « Pour moi, je vous laisserai aller, pour offrir des sacrifices à Yahweh, votre Dieu, dans le désert ; seulement ne vous éloignez pas trop dans votre marche. Faites des prières pour moi. » ");
INSERT INTO francl_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Moïse répondit : Voici, je vais sortir de chez toi, et je prierai Yahweh, et demain les scarabées se retireront de Pharaon, de ses serviteurs et de son peuple. Mais que Pharaon ne trompe plus, en ne permettant pas au peuple d’aller offrir des sacrifices à Yahweh ! » ");
INSERT INTO francl_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Moïse sortit de chez Pharaon et pria Yahweh. ");
INSERT INTO francl_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Et Yahweh fit selon la parole de Moïse, et les scarabées s’éloignèrent de Pharaon, de ses serviteurs et de son peuple ; il n’en resta pas un seul. ");
INSERT INTO francl_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Mais Pharaon endurcit son cœur cette fois encore, et il ne laissa pas aller le peuple. ");
INSERT INTO francl_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Yahweh dit à Moïse : « Va vers Pharaon et dis-lui : Ainsi parle Yahweh, le Dieu des Hébreux : Laisse aller mon peuple, afin qu’il me serve. ");
INSERT INTO francl_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Si tu refuses de le laisser aller, et si tu le retiens encore, ");
INSERT INTO francl_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","voici que la main de Yahweh sera sur tes troupeaux qui sont dans les champs, sur les chevaux, sur les ânes, sur les chameaux, sur les bœufs et sur les brebis : ce sera une peste très meurtrière. ");
INSERT INTO francl_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Yahweh fera une distinction entre les troupeaux d’Israël et les troupeaux des Égyptiens, et il ne périra rien de tout ce qui appartient aux enfants d’Israël. » ");
INSERT INTO francl_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Yahweh fixa le moment, en disant : « Demain Yahweh fera cela dans le pays. » ");
INSERT INTO francl_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Et Yahweh fit ainsi dès le lendemain. Tout le bétail des Égyptiens périt, et il ne mourut pas une bête des troupeaux des enfants d’Israël. ");
INSERT INTO francl_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Pharaon prit des informations, et voici, pas une bête des troupeaux d’Israël n’avait péri. Mais le cœur de Pharaon s’endurcit, et il ne laissa pas aller le peuple. ");
INSERT INTO francl_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Yahweh dit à Moïse et à Aaron : « Prenez plein vos mains de cendre de fournaise, et que Moïse la jette vers le ciel sous les yeux de Pharaon ; ");
INSERT INTO francl_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","qu’elle devienne une fine poussière sur tout le pays d’Égypte, et qu’elle forme, dans tout le pays d’Égypte, sur les hommes et sur les animaux, des tumeurs bourgeonnant en pustules. » ");
INSERT INTO francl_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Ils prirent de la cendre de fournaise et se présentèrent devant Pharaon ; Moïse la jeta vers le ciel, et elle produisit sur les hommes et sur les animaux des tumeurs bourgeonnant en pustules. ");
INSERT INTO francl_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Les magiciens ne purent se tenir devant Moïse à cause des tumeurs, car les tumeurs étaient sur les magiciens, comme sur tous les Égyptiens. ");
INSERT INTO francl_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Et Yahweh endurcit le cœur de Pharaon, et Pharaon n’écouta pas Moïse et Aaron, selon que Yahweh l’avait dit à Moïse. ");
INSERT INTO francl_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Yahweh dit à Moïse : « Lève-toi de bon matin et présente-toi devant Pharaon ; tu lui diras : Ainsi parle Yahweh, Dieu des Hébreux : Laisse aller mon peuple, afin qu’il me serve. ");
INSERT INTO francl_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Car, cette fois, je vais envoyer tous mes fléaux contre ton cœur, ainsi que sur tes serviteurs et sur ton peuple, afin que tu saches que nul n’est semblable à moi par toute la terre. ");
INSERT INTO francl_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Si j’avais étendu ma main et que je t’eusse frappé de la peste, toi et ton peuple, tu aurais été effacé de la terre. ");
INSERT INTO francl_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Mais à cette fin je t’ai laissé subsister, afin que tu voies ma puissance, et qu’on célèbre mon nom par toute la terre. ");
INSERT INTO francl_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Tu te mets encore comme une barrière devant mon peuple pour ne pas le laisser aller ! ");
INSERT INTO francl_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Voici que, demain, à cette heure, je ferai pleuvoir une grêle si forte, qu’il n’y en a pas eu de semblable en Égypte depuis le jour où elle a été fondée jusqu’à présent. ");
INSERT INTO francl_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Et maintenant fais mettre en sûreté ton bétail et tout ce que tu as dans les champs ; car tous les hommes et tous les animaux qui se trouveront dans les champs et qui ne seront pas ramenés dans les maisons seront frappés de la grêle et périront. » ");
INSERT INTO francl_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Ceux des serviteurs de Pharaon qui craignirent la parole de Yahweh firent retirer dans les maisons leurs serviteurs et leurs troupeaux. ");
INSERT INTO francl_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Mais ceux qui n’appliquèrent pas leur cœur à la parole de Yahweh laissèrent leurs serviteurs et leurs troupeaux dans les champs. ");
INSERT INTO francl_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Yahweh dit à Moïse : « Etends ta main vers le ciel, afin qu’il tombe de la grêle dans tout le pays d’Égypte sur les hommes, sur les animaux et sur toutes les herbes des champs. » ");
INSERT INTO francl_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Moïse étendit son bâton vers le ciel, et Yahweh envoya le tonnerre et la grêle, et le feu se précipitait sur la terre. Yahweh fit pleuvoir de la grêle sur le pays d’Égypte. ");
INSERT INTO francl_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Il tomba de la grêle et du feu mêlé à la grêle ; elle était si forte qu’il n’y en avait pas eu de semblable dans tout le pays d’Égypte, depuis qu’il forme une nation. ");
INSERT INTO francl_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","La grêle frappa, dans tout le pays d’Égypte, tout ce qui était dans les champs, depuis les hommes jusqu’aux animaux ; la grêle frappa aussi toutes les herbes des champs et brisa tous les arbres des champs. ");
INSERT INTO francl_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Il n’y eut que dans le pays de Gessen, où étaient les enfants d’Israël, qu’il ne tomba pas de grêle. ");
INSERT INTO francl_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Pharaon fit appeler Moïse et Aaron, et leur dit : « Cette fois, j’ai péché ; c’est Yahweh qui est juste, et moi et mon peuple qui sommes coupables. ");
INSERT INTO francl_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Priez Yahweh, pour qu’il n’y ait plus de tonnerres et de grêle, et je vous laisserai aller et l’on ne vous retiendra plus. » ");
INSERT INTO francl_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Moïse lui dit : « En sortant de la ville, je lèverai mes mains vers Yahweh, et les tonnerres cesseront, et il n’y aura plus de grêle, afin que tu saches que la terre est à Yahweh. ");
INSERT INTO francl_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Mais je sais que toi et tes serviteurs, vous ne craindrez pas encore Yahweh Dieu. » ");
INSERT INTO francl_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Le lin et l’orge avaient été frappés, car l’orge était en épis et le lin en fleurs ; ");
INSERT INTO francl_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","mais le froment et l’épeautre n’avaient pas été frappés, parce qu’ils sont tardifs. ");
INSERT INTO francl_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Moïse quitta Pharaon et sortit de la ville ; il leva ses mains vers Yahweh, et les tonnerres et la grêle cessèrent, et la pluie ne tomba plus sur la terre. ");
INSERT INTO francl_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Pharaon, voyant que la pluie, la grêle et les tonnerres avaient cessé, continua de pécher, ");
INSERT INTO francl_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","et il appesantit son cœur, lui et ses serviteurs. Le cœur de Pharaon s’endurcit, et il ne laissa pas aller les enfants d’Israël, selon que Yahweh l’avait dit par l’intermédiaire de Moïse. ");
INSERT INTO francl_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Yahweh dit à Moïse : « Va vers Pharaon, car j’ai appesanti son cœur et le cœur de ses serviteurs, afin d’opérer mes signes au milieu d’eux ");
INSERT INTO francl_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","et afin que tu racontes aux oreilles de ton fils et du fils de ton fils quelles grandes choses j’ai faites en Égypte et quels signes j’ai opérés au milieu d’eux ; et vous saurez que je suis Yahweh. » ");
INSERT INTO francl_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Moïse et Aaron allèrent vers Pharaon et lui dirent : « Ainsi parle Yahweh, le Dieu des Hébreux : Jusques à quand refuseras-tu de t’humilier devant moi ? Laisse aller mon peuple, afin qu’il me serve. ");
INSERT INTO francl_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Si tu refuses de laisser aller mon peuple, voici que je ferai venir demain des sauterelles dans toute l’étendue de ton pays. ");
INSERT INTO francl_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Elles couvriront la face de la terre, et l’on ne pourra plus voir la terre ; elles dévoreront le reste qui a échappé, ce que vous a laissé la grêle, et elles dévoreront tous les arbres qui croissent dans vos champs ; ");
INSERT INTO francl_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","elles rempliront tes maisons, les maisons de tous tes serviteurs et celles de tous les Égyptiens. Tes pères et les pères de tes pères n’ont jamais vu pareille calamité depuis qu’ils existent sur la terre jusqu’à ce jour. » Moïse se retira et sortit de chez Pharaon. ");
INSERT INTO francl_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Les serviteurs de Pharaon lui dirent : « Jusques à quand cet homme sera-t-il pour nous un piège ? Laisse aller ces gens, et qu’ils servent Yahweh leur Dieu. Ne vois-tu pas encore que l’Égypte va à sa ruine ? » ");
INSERT INTO francl_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","On fit revenir Moïse et Aaron auprès de Pharaon, et il leur dit : « Allez, servez Yahweh, votre Dieu. Qui sont ceux qui doivent y aller ? » ");
INSERT INTO francl_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Moïse répondit : « Nous irons avec nos enfants et nos vieillards, avec nos fils et nos filles, avec nos brebis et nos bœufs ; car c’est pour nous une fête en l’honneur de Yahweh. » ");
INSERT INTO francl_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Pharaon leur dit : « Que Yahweh soit avec vous, comme je vais vous laisser aller, vous et vos enfants ! Prenez garde, car vous avez de mauvais desseins ! ");
INSERT INTO francl_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Non, non ; allez, vous les hommes, et servez Yahweh, puisque c’est là ce que vous demandez. » Et on les chassa de devant Pharaon. ");
INSERT INTO francl_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Yahweh dit à Moïse : « Etends ta main sur le pays d’Égypte pour les sauterelles ; qu’elles montent sur le pays d’Égypte ; qu’elles dévorent toute l’herbe de la terre, tout ce que la grêle a laissé. » ");
INSERT INTO francl_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Moïse étendit son bâton sur le pays d’Égypte, et Yahweh fit souffler sur le pays un vent d’orient tout ce jour-là et toute la nuit. Le matin venu, le vent d’orient avait apporté les sauterelles. ");
INSERT INTO francl_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Les sauterelles montèrent sur tout le pays d’Égypte et se posèrent sur tout le territoire de l’Égypte, en si grande quantité, que jamais il n’y avait eu et qu’il n’y aura jamais rien de semblable. ");
INSERT INTO francl_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Elles couvrirent la face de toute la terre, et la terre en fut assombrie ; elles dévorèrent toute l’herbe de la terre et tous les fruits des arbres, ce que la grêle avait laissé, et il ne resta aucune verdure aux arbres ni à l’herbe des champs, dans tout le pays d’Égypte. ");
INSERT INTO francl_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Pharaon appela aussitôt Moïse et Aaron, et dit : « J’ai péché contre Yahweh, votre Dieu, et contre vous. ");
INSERT INTO francl_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Mais pardonne mon péché encore cette fois seulement ; et priez Yahweh, votre Dieu, afin qu’il éloigne de moi au moins ce fléau mortel. » ");
INSERT INTO francl_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Moïse sortit de chez Pharaon et pria Yahweh. ");
INSERT INTO francl_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Et Yahweh fit souffler un vent d’occident très fort, qui emporta les sauterelles et les poussa dans la mer Rouge ; il ne resta pas une seule sauterelle dans toute l’étendue de l’Égypte. — ");
INSERT INTO francl_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Yahweh endurcit le cœur de Pharaon, et Pharaon ne laissa pas aller les enfants d’Israël. ");
INSERT INTO francl_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Yahweh dit à Moïse : « Etends ta main vers le ciel, et qu’il y ait des ténèbres sur le pays d’Égypte, qu’on palpe les ténèbres. » ");
INSERT INTO francl_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Moïse étendit sa main vers le ciel, et il y eut d’épaisses ténèbres dans tout le pays d’Égypte, pendant trois jours. ");
INSERT INTO francl_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Ils ne se voyaient pas les uns les autres, et nul ne se leva de la place où il était, pendant trois jours ; mais tous les enfants d’Israël avaient de la lumière dans les lieux qu’ils habitaient. ");
INSERT INTO francl_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Pharaon appela Moïse, et dit : « Allez, servez Yahweh. Vos brebis et vos bœufs seuls resteront, et vos petits enfants mêmes pourront aller avec vous. » ");
INSERT INTO francl_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Moïse répondit : « Tu dois mettre entre nos mains de quoi faire des sacrifices et des holocaustes à Yahweh, notre Dieu. ");
INSERT INTO francl_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Nos troupeaux viendront aussi avec nous ; il n’en restera pas un ongle ; car c’est d’eux que nous prendrons de quoi servir Yahweh, notre Dieu ; et nous ne savons pas nous-mêmes, jusqu’à ce que nous soyons arrivés là, avec quoi nous devons servir Yahweh. » ");
INSERT INTO francl_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Yahweh endurcit le cœur de Pharaon, et Pharaon ne voulut pas les laisser aller. ");
INSERT INTO francl_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Pharaon dit à Moïse : « Sors de chez moi ! Garde-toi de paraître encore en ma présence, car le jour où tu paraîtras en ma présence, tu mourras. » ");
INSERT INTO francl_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Et Moïse répondit : « Tu l’as dit : je ne paraîtrai plus devant toi. » ");
INSERT INTO francl_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Yahweh dit à Moïse : « Je ferai venir encore une seule plaie sur Pharaon et sur l’Égypte et, après cela, il vous laissera partir d’ici ; et lorsqu’il vous laissera aller tout à fait, il vous chassera même d’ici. ");
INSERT INTO francl_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Parle donc au peuple pour que chaque homme demande à son voisin et chaque femme à sa voisine des objets d’argent et des objets d’or. » ");
INSERT INTO francl_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Et Yahweh fit trouver faveur au peuple aux yeux des Égyptiens ; Moïse lui-même était très considéré dans le pays d’Égypte aux yeux des serviteurs de Pharaon et aux yeux du peuple. ");
INSERT INTO francl_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Moïse dit : « Ainsi parle Yahweh : Au milieu de la nuit je passerai au travers de l’Égypte ; ");
INSERT INTO francl_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","et tout premier-né dans le pays d’Égypte mourra, depuis le premier-né de Pharaon assis sur son trône, jusqu’au premier-né de la servante qui est derrière la meule, et tout premier-né du bétail. ");
INSERT INTO francl_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Il y aura dans tout le pays d’Égypte une grande clameur, telle qu’il n’y en a pas eu et qu’il n’y en aura plus de semblable. ");
INSERT INTO francl_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Mais parmi tous les enfants d’Israël, personne, depuis les hommes jusqu’aux animaux, pas même un chien, ne remuera sa langue, afin que vous sachiez quelle différence Yahweh fait entre l’Égypte et Israël. ");
INSERT INTO francl_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Alors tous tes serviteurs qui sont ici descendront vers moi et se prosterneront devant moi, en disant : Sors, toi et tout le peuple qui est à ta suite ! Après quoi, je sortirai. » Et Moïse sortit de chez Pharaon en grande colère. ");
INSERT INTO francl_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Yahweh dit à Moïse : « Pharaon ne vous écoutera point, afin que mes prodiges se multiplient dans le pays d’Égypte. » ");
INSERT INTO francl_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Moïse et Aaron opérèrent tous ces prodiges devant Pharaon, et Yahweh endurcit le cœur de Pharaon, et il ne laissa pas aller les enfants d’Israël hors de son pays. ");
INSERT INTO francl_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Yahweh dit à Moïse et à Aaron dans le pays d’Égypte : ");
INSERT INTO francl_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","« Que ce mois-ci soit pour vous le commencement des mois ; il sera pour vous le premier des mois de l’année. ");
INSERT INTO francl_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Parlez à toute l’assemblée d’Israël, et dites : Le dixième jour de ce mois, que chacun prenne un agneau par famille, un agneau par maison. ");
INSERT INTO francl_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Si la maison est trop peu nombreuse pour un agneau, on le prendra en commun avec le voisin le plus proche, selon le nombre des personnes ; vous compterez pour cet agneau d’après ce que chacun peut manger. ");
INSERT INTO francl_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Ce sera un agneau sans défaut, mâle, âgé d’un an ; vous prendrez, soit un agneau, soit un chevreau. ");
INSERT INTO francl_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Vous le garderez jusqu’au quatorzième jour de ce mois, et toute l’assemblée d’Israël l’immolera entre les deux soirs. ");
INSERT INTO francl_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","On prendra de son sang, et on en mettra sur les deux montants et sur le linteau de la porte, dans les maisons où on le mangera. ");
INSERT INTO francl_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","On en mangera la chair cette nuit-là ; on la mangera rôtie au feu, avec des pains sans levain et des herbes amères. ");
INSERT INTO francl_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Vous n’en mangerez rien cru ou bouilli dans l’eau, mais tout sera rôti au feu, tête, jambes et entrailles. ");
INSERT INTO francl_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Vous n’en laisserez rien jusqu’au matin, et, s’il en reste quelque chose, vous le brûlerez au feu. ");
INSERT INTO francl_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Vous le mangerez ainsi : les reins ceints, les sandales aux pieds, et le bâton à la main, et vous le mangerez à la hâte. C’est la Pâque de Yahweh. ");
INSERT INTO francl_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Je passerai cette nuit-là, par le pays d’Égypte, et je frapperai de mort tous les premiers-nés du pays d’Égypte, depuis les hommes jusqu’aux animaux, et j’exécuterai des jugements sur tous les dieux de l’Égypte. Je suis Yahweh. ");
INSERT INTO francl_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Le sang sera un signe en votre faveur sur les maisons où vous êtes : je verrai le sang et je passerai par-dessus vous, et il n’y aura pas pour vous de plaie meurtrière quand je frapperai le pays d’Égypte. ");
INSERT INTO francl_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Vous conserverez le souvenir de ce jour, et vous le célébrerez par une fête en l’honneur de Yahweh ; vous le célébrerez de génération en génération comme une institution perpétuelle. ");
INSERT INTO francl_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Pendant sept jours, vous mangerez des pains sans levain ; dès le premier jour il n’y aura plus de levain dans vos maisons ; car quiconque mangera du pain levé, du premier jour au septième, sera retranché d’Israël. ");
INSERT INTO francl_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Le premier jour, vous aurez une sainte assemblée, et le septième jour, vous aurez une sainte assemblée. On ne fera aucun travail pendant ces jours-là ; vous pourrez seulement préparer la nourriture de chacun. ");
INSERT INTO francl_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Vous observerez les azymes, car c’est en ce jour même que j’ai fait sortir vos armées du pays d’Égypte. Vous observerez ce jour de génération en génération comme une institution perpétuelle. ");
INSERT INTO francl_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Le premier mois, le quatorzième jour du mois, au soir, vous mangerez des pains sans levain jusqu’au soir du vingt et unième jour. ");
INSERT INTO francl_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Sept jours durant, il ne doit pas se trouver de levain dans vos maisons, car quiconque mangera du pain levé sera retranché de l’assemblée d’Israël, que ce soit un étranger ou un indigène. ");
INSERT INTO francl_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Vous ne mangerez pas de pain levé ; dans toutes vos demeures vous mangerez des pains sans levain. » ");
INSERT INTO francl_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Moïse convoqua tous les anciens d’Israël, et leur dit : « Choisissez et prenez un agneau pour vos familles, et immolez la Pâque. ");
INSERT INTO francl_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Puis, prenant un bouquet d’hysope, vous le tremperez dans le sang qui sera dans le bassin, et vous toucherez avec le sang qui sera dans le bassin le linteau et les deux montants de la porte. Nul d’entre vous ne sortira de l’entrée de sa maison jusqu’au matin. ");
INSERT INTO francl_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Yahweh passera pour frapper l’Égypte et, en voyant le sang sur le linteau et sur les deux montants, Yahweh passera vos portes, et il ne permettra pas au Destructeur d’entrer dans vos maisons pour frapper. ");
INSERT INTO francl_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Vous observerez cet ordre comme une institution pour vous et pour vos enfants à perpétuité. ");
INSERT INTO francl_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Lorsque vous serez entrés dans le pays que Yahweh vous donnera, selon sa promesse, vous observerez ce rite sacré. ");
INSERT INTO francl_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Et quand vos enfants vous diront : Quelle signification a pour vous ce rite sacré ? ");
INSERT INTO francl_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","vous répondrez : C’est un sacrifice de Pâque en l’honneur de Yahweh, qui a passé par-dessus les maisons des enfants d’Israël en Égypte, lorsqu’il frappa l’Égypte et sauva nos maisons. » Le peuple s’inclina et se prosterna. ");
INSERT INTO francl_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Et les enfants d’Israël s’en allèrent et firent ce que Yahweh avait ordonné à Moïse et à Aaron ; ainsi firent-ils. ");
INSERT INTO francl_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Au milieu de la nuit, Yahweh frappa tous les premiers-nés dans le pays d’Égypte, depuis le premier-né de Pharaon assis sur son trône, jusqu’au premier-né du captif dans sa prison, et à tous les premiers-nés des animaux. ");
INSERT INTO francl_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Pharaon se leva pendant la nuit, lui et tous ses serviteurs, et tous les Égyptiens, et il y eut une grande clameur en Égypte, car il n’y avait pas de maison où il n’y eût un mort. ");
INSERT INTO francl_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Dans la nuit même, Pharaon appela Moïse et Aaron, et leur dit : « Levez-vous, sortez du milieu de mon peuple, vous et les enfants d’Israël, et allez servir Yahweh, comme vous l’avez dit. ");
INSERT INTO francl_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Prenez vos brebis et vos bœufs, comme vous l’avez dit ; allez, et bénissez-moi. » ");
INSERT INTO francl_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Les Égyptiens pressaient vivement le peuple, ayant hâte de le renvoyer du pays, car ils disaient : « Nous sommes tous morts ! » ");
INSERT INTO francl_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Le peuple emporta sa pâte avant qu’elle fût levée ; ayant serré dans leurs manteaux les corbeilles, ils les mirent sur leurs épaules. ");
INSERT INTO francl_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Les enfants d’Israël firent selon la parole de Moïse ; ils demandèrent aux Égyptiens des objets d’argent, des objets d’or et des vêtements. ");
INSERT INTO francl_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Et Yahweh avait fait trouver au peuple faveur aux yeux des Égyptiens, qui accueillirent leur demande. Et ils dépouillèrent les Égyptiens. ");
INSERT INTO francl_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Les enfants d’Israël partirent de Ramsès pour Socoth, au nombre d’environ six cent mille fantassins, sans les enfants. ");
INSERT INTO francl_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","En outre, une grande multitude de gens de toute sorte monta avec eux ; ils avaient aussi des troupeaux considérables de brebis et de bœufs. ");
INSERT INTO francl_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Ils cuisirent en galettes non levées la pâte qu’ils avaient emportée d’Égypte ; car elle n’était pas levée, parce qu’ils avaient été chassés d’Égypte sans pouvoir tarder, ni prendre de provisions avec eux. ");
INSERT INTO francl_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Le séjour des enfants d’Israël en Égypte fut de quatre cents trente ans. ");
INSERT INTO francl_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Et au bout de quatre cent trente ans, ce jour-là même, toutes les armées de Yahweh sortirent du pays d’Égypte. ");
INSERT INTO francl_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Ce fut une nuit de veille pour Yahweh quand il fit sortir Israël du pays d’Égypte ; cette même nuit sera une veille en l’honneur de Yahweh, pour tous les enfants d’Israël selon leurs générations. ");
INSERT INTO francl_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Yahweh dit à Moïse et à Aaron : « Voici une ordonnance au sujet de la Pâque : Aucun étranger n’en mangera. ");
INSERT INTO francl_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Tu circonciras tout esclave acquis à prix d’argent, et il en mangera ; ");
INSERT INTO francl_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","mais le domicilié et le mercenaire n’en mangeront point. ");
INSERT INTO francl_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","On ne la mangera que dans la maison ; vous n’emporterez pas de chair hors de la maison, et vous ne briserez aucun os. ");
INSERT INTO francl_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Toute l’assemblée d’Israël fera la Pâque. ");
INSERT INTO francl_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Si un étranger séjournant chez toi veut faire la Pâque de Yahweh, tout mâle de sa maison devra être circoncis, et alors il s’approchera pour la faire, et il sera comme l’indigène du pays mais aucun incirconcis n’en mangera. ");
INSERT INTO francl_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Une même loi sera pour l’indigène et pour l’étranger séjournant au milieu de vous. » ");
INSERT INTO francl_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Tous les enfants d’Israël firent ce que Yahweh avait ordonné à Moïse et à Aaron ; ainsi firent-ils. ");
INSERT INTO francl_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Et ce même jour, Yahweh fit sortir du pays d’Égypte les enfants d’Israël selon leurs armées. ");
INSERT INTO francl_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","« Consacre-moi tout premier-né, tout premier-né parmi les enfants d’Israël, aussi bien des hommes que des animaux ; il m’appartient. » ");
INSERT INTO francl_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Moïse dit au peuple : « Souvenez-vous du jour où vous êtes sortis d’Égypte, de la maison de servitude ; car c’est par la puissance de sa main que Yahweh vous en a fait sortir. On ne mangera pas de pain levé. ");
INSERT INTO francl_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Vous sortez aujourd’hui, dans le mois des épis. ");
INSERT INTO francl_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Quand Yahweh t’aura fait entrer dans le pays des Chananéens, des Hittites, des Amorrhéens, des Hévéens et des Jébuséens, qu’il a juré à tes pères de te donner, pays où coulent le lait et le miel, tu observeras ce rite dans ce même mois. ");
INSERT INTO francl_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Pendant sept jours, tu mangeras des pains sans levain, et le septième jour, il y aura une fête en l’honneur de Yahweh. ");
INSERT INTO francl_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","On mangera des pains sans levain pendant les sept jours ; on ne verra pas chez toi de pain levé, on ne verra pas chez toi de levain, dans toute l’étendue de ton pays. ");
INSERT INTO francl_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Tu diras alors à ton fils : C’est en mémoire de ce que Yahweh a fait pour moi, lorsque je suis sorti d’Égypte. ");
INSERT INTO francl_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Ce sera pour toi comme un signe sur ta main et comme un souvenir entre tes yeux, afin que la loi de Yahweh soit dans ta bouche ; car c’est par sa main puissante que Yahweh t’a fait sortir d’Égypte. ");
INSERT INTO francl_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Tu observeras cette ordonnance au temps fixé, d’année en année. ");
INSERT INTO francl_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Quand Yahweh t’aura fait entrer dans le pays des Chananéens, comme il l’a juré à toi et à tes pères, et qu’il te l’aura donné, ");
INSERT INTO francl_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","tu consacreras à Yahweh tout premier-né, même tout premier-né des animaux qui seront à toi : les mâles appartiennent à Yahweh. ");
INSERT INTO francl_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Tu rachèteras avec un agneau tout premier-né de l’âne, et, si tu ne le rachètes pas, tu lui briseras la nuque. Tu rachèteras aussi tout premier-né de l’homme parmi tes fils. ");
INSERT INTO francl_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Et lorsque ton fils t’interrogera un jour, en disant : Que signifie cela ? tu lui répondras : Par sa main puissante Yahweh nous a fait sortir d’Égypte, de la maison de servitude. ");
INSERT INTO francl_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Comme Pharaon s’obstinait à ne pas nous laisser aller, Yahweh fit mourir tous les premiers-nés dans le pays d’Égypte, depuis les premiers-nés des hommes jusqu’aux premiers-nés des animaux. Voilà pourquoi j’offre en sacrifice à Yahweh tout mâle premier-né des animaux, et je rachète tout premier-né de mes fils. ");
INSERT INTO francl_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Ce sera comme un signe sur ta main et comme des fronteaux entre tes yeux ; car c’est par la puissance de sa main que Yahweh nous a fait sortir d’Égypte. » ");
INSERT INTO francl_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Lorsque Pharaon laissa aller le peuple, Dieu ne le conduisit pas par le chemin du pays des Philistins, quoique le plus court ; car Dieu dit : « Le peuple pourrait se repentir en voyant la guerre, et retourner en Égypte. » ");
INSERT INTO francl_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Mais Dieu fit faire au peuple un détour par le chemin du désert, vers la mer Rouge. Les enfants d’Israël montèrent en bon ordre hors du pays d’Égypte. ");
INSERT INTO francl_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Moïse prit avec lui les os de Joseph ; car Joseph avait fait jurer les enfants d’Israël, en disant : « Dieu vous visitera, et vous emporterez avec vous mes os loin d’ici. » ");
INSERT INTO francl_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Etant sortis de Socoth, ils campèrent à Etham, à l’extrémité du désert. ");
INSERT INTO francl_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Yahweh allait devant eux, le jour dans une colonne de nuée, pour les guider dans leur chemin, et la nuit dans une colonne de feu, pour les éclairer, afin qu’ils pussent marcher le jour et la nuit. ");
INSERT INTO francl_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","La colonne de nuée ne se retira pas de devant le peuple pendant le jour, ni la colonne de feu pendant la nuit. ");
INSERT INTO francl_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","« Parle aux enfants d’Israël ; qu’ils changent de direction et qu’ils viennent camper devant Phihahiroth, entre Magdalum et la mer, vis-à-vis de Beelséphon ; vous camperez en face de ce lieu, près de la mer. ");
INSERT INTO francl_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Pharaon dira des enfants d’Israël : Ils sont égarés dans le pays ; le désert les tient enfermés. ");
INSERT INTO francl_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Et j’endurcirai le cœur de Pharaon, et il les poursuivra ; je ferai éclater ma gloire dans Pharaon et dans toute son armée, et les Égyptiens sauront que je suis Yahweh. » Et les enfants d’Israël firent ainsi. ");
INSERT INTO francl_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","On annonça au roi d’Égypte que le peuple avait pris la fuite. Alors le cœur de Pharaon et celui de ses serviteurs furent changés à l’égard du peuple ; ils dirent : « Qu’avons-nous fait de laisser aller Israël et de nous priver de ses services ? » ");
INSERT INTO francl_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Et Pharaon fit atteler son char, et il prit son peuple avec lui. ");
INSERT INTO francl_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Il prit six cents chars d’élite, et tous les chars de l’Égypte, et sur tous il y avait des chefs. ");
INSERT INTO francl_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Yahweh endurcit le cœur de Pharaon, roi d’Égypte, et Pharaon poursuivit les enfants d’Israël ; et les enfants d’Israël étaient sortis par une main élevée. ");
INSERT INTO francl_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Les Égyptiens les poursuivirent donc et les atteignirent comme ils étaient campés près de la mer ; tous les chevaux des chars de Pharaon, ses cavaliers et son armée les atteignirent près de Phihahiroth, vis-à-vis de Beelsephon. ");
INSERT INTO francl_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Pharaon approchait. Les enfants d’Israël levèrent les yeux, et voici, les Égyptiens étaient en marche derrière eux ; et les enfants d’Israël, saisis d’une grande frayeur, poussèrent des cris vers Yahweh. ");
INSERT INTO francl_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Ils dirent à Moïse : « N’y avait-il donc pas des sépulcres en Égypte, que tu nous aies menés mourir au désert ? Que nous as-tu fait, en nous faisant sortir d’Égypte ? ");
INSERT INTO francl_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","N’est-ce pas là ce que nous te disions en Égypte : Laisse-nous servir les Égyptiens, car il vaut mieux pour nous servir les Égyptiens que de mourir au désert ? » ");
INSERT INTO francl_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Moïse répondit au peuple : « N’ayez pas de crainte, restez en place, et regardez le salut que Yahweh va vous accorder en ce jour ; car les Égyptiens que vous voyez aujourd’hui, vous ne les reverrez jamais. ");
INSERT INTO francl_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Yahweh combattra pour vous, et vous, tenez-vous tranquilles. » ");
INSERT INTO francl_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Yahweh dit à Moïse : « Pourquoi cries-tu vers moi ? Dis aux enfants d’Israël de se mettre en marche. ");
INSERT INTO francl_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Toi, lève ton bâton, étends ta main sur la mer, et divise-la ; et les enfants d’Israël entreront au milieu de la mer à sec. ");
INSERT INTO francl_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Et moi, je vais endurcir le cœur des Égyptiens pour qu’ils y entrent après eux, et je ferai éclater ma gloire dans Pharaon et dans toute son armée, ses chars et ses cavaliers. ");
INSERT INTO francl_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Et les Égyptiens sauront que je suis Yahweh, quand j’aurai fait éclaté ma gloire sur Pharaon, ses chars et ses cavaliers. » ");
INSERT INTO francl_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","L’ange de Dieu, qui marchait devant le camp d’Israël, partit et alla derrière eux ; et la colonne de nuée qui les précédait, partit et se tint derrière eux. ");
INSERT INTO francl_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Elle vint se mettre entre le camp des Égyptiens et le camp d’Israël, et cette nuée était ténébreuse d’un côté, et de l’autre elle éclairait la nuit ; et les deux camps n’approchèrent pas l’un de l’autre pendant toute la nuit. ");
INSERT INTO francl_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Moïse ayant étendu sa main sur la mer, Yahweh refoula la mer par un vent impétueux d’orient qui souffla toute la nuit ; il mit la mer à sec, et les eaux se divisèrent. ");
INSERT INTO francl_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Les enfants d’Israël entrèrent au milieu de la mer à sec, et les eaux formaient pour eux une muraille à leur droite et à leur gauche. ");
INSERT INTO francl_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Les Égyptiens les poursuivirent, et tous les chevaux de Pharaon, ses chars et ses cavaliers, entrèrent à leur suite au milieu de la mer. ");
INSERT INTO francl_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","A la veille du matin, Yahweh, dans la colonne de feu et de fumée, regarda le camp des Égyptiens, et jeta l’épouvante dans le camp des Égyptiens. ");
INSERT INTO francl_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Il fit tomber les roues hors de leurs chars, qui n’avançaient plus qu’à grand’peine. Les Égyptiens dirent alors : « Fuyons devant Israël, car Yahweh combat pour lui contre l’Égypte. » ");
INSERT INTO francl_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Yahweh dit à Moïse : « Etends ta main sur la mer, et les eaux reviendront sur les Égyptiens, sur leurs chars et sur leurs cavaliers. » ");
INSERT INTO francl_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Moïse étendit sa main sur la mer, et, au point du jour, la mer reprit sa place habituelle ; les Égyptiens en fuyant la rencontrèrent, et Yahweh culbuta les Égyptiens au milieu de la mer. ");
INSERT INTO francl_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Les eaux, en revenant, couvrirent les chars, les cavaliers et toute l’armée de Pharaon qui étaient entrés dans la mer à la suite des enfants d’Israël, et il n’en échappa pas un seul. ");
INSERT INTO francl_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Mais les enfants d’Israël avaient marché à sec au milieu de la mer, les eaux ayant formé pour eux une muraille à droite et à gauche. ");
INSERT INTO francl_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","En ce jour-là, Yahweh délivra Israël de la main des Égyptiens, et Israël vit sur le rivage de la mer les Égyptiens qui étaient morts. ");
INSERT INTO francl_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Israël vit la main puissante que Yahweh avait montrée à l’égard des Égyptiens ; et le peuple craignit Yahweh, et il crut à Yahweh et à Moïse, son serviteur. ");
INSERT INTO francl_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Alors Moïse et les enfants d’Israël chantèrent ce cantique à Yahweh ; ils dirent : Je chanterai à Yahweh, car il a fait éclater sa gloire : il a précipité dans la mer cheval et cavalier. ");
INSERT INTO francl_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Yahweh est ma force et l’objet de mes chants ; c’est lui qui m’a sauvé ; c’est lui qui est mon Dieu : je le célébrerai ; le Dieu de mon père : je l’exalterai. ");
INSERT INTO francl_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Yahweh est un vaillant guerrier ; Yahweh est son nom. ");
INSERT INTO francl_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Il a jeté dans la mer les chars de Pharaon et son armée ; l’élite de ses capitaines a été engloutie dans la mer Rouge. ");
INSERT INTO francl_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Les flots les couvrent ; ils sont descendus au fond des eaux comme une pierre. ");
INSERT INTO francl_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Ta droite, ô Yahweh, s’est signalée par sa force, ta droite, ô Yahweh, a écrasé l’ennemi. ");
INSERT INTO francl_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Dans la plénitude de ta majesté, tu renverses tes adversaires ; tu déchaînes ta colère, elle les consume comme du chaume. ");
INSERT INTO francl_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Au souffle de tes narines, les eaux se sont amoncelées. Les flots se sont dressés comme un monceau ; les vagues se sont durcies au sein de la mer. ");
INSERT INTO francl_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","L’ennemi disait : « Je poursuivrai, j’atteindrai, je partagerai les dépouilles, ma vengeance sera assouvie, je tirerai l’épée, ma main les détruira. » ");
INSERT INTO francl_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Tu as soufflé de ton haleine, la mer les a couverts, ils se sont enfoncés, comme du plomb, dans les vastes eaux. ");
INSERT INTO francl_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Qui est comme toi parmi les dieux, ô Yahweh ? Qui est comme toi, auguste en sainteté, redoutable à la louange même, opérant des prodiges ? ");
INSERT INTO francl_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Tu as étendu ta droite, la terre les a engloutis. ");
INSERT INTO francl_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Par ta grâce tu conduis ce peuple que tu as délivré ; par ta puissance tu le diriges vers ta demeure sainte. ");
INSERT INTO francl_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Les peuples l’ont appris, ils tremblent ; la terreur s’empare des Philistins ; ");
INSERT INTO francl_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Déjà les princes d’Edom sont dans l’épouvante ; l’angoisse s’empare des forts de Moab ; tous les habitants de Canaan ont perdu courage, ");
INSERT INTO francl_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","la terreur et la détresse tomberont sur eux ; par la grandeur de ton bras, ils deviendront immobiles comme une pierre, jusqu’à ce que ton peuple ait passé, ô Yahweh, jusqu’à ce qu’il ait passé, le peuple que tu as acquis. ");
INSERT INTO francl_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Tu les amèneras et les établiras sur la montagne de ton héritage, au lieu dont tu as fait ta demeure, ô Yahweh, au sanctuaire, Seigneur, que tes mains ont préparé. ");
INSERT INTO francl_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Yahweh régnera à jamais et toujours ! ");
INSERT INTO francl_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Car les chevaux de Pharaon, ses chars et ses cavaliers sont entrés dans la mer, et Yahweh a ramené sur eux les eaux de la mer ; mais les enfants d’Israël ont marché à sec au milieu de la mer. ");
INSERT INTO francl_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Marie, la prophétesse, sœur d’Aaron, prit à la main un tambourin, et toutes les femmes vinrent à sa suite avec des tambourins et en dansant. ");
INSERT INTO francl_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Marie répondait aux enfants d’Israël : Chantez Yahweh, car il a fait éclater sa gloire : il a précipité dans la mer cheval et cavalier. ");
INSERT INTO francl_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Moïse fit partir Israël de la mer Rouge. Ils s’avancèrent vers le désert de Sur, et marchèrent trois jours dans ce désert sans trouver d’eau. ");
INSERT INTO francl_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Ils arrivèrent à Mara, mais ils ne purent boire l’eau de Mara, parce qu’elle était amère. C’est pourquoi ce lieu fut appelé Mara. ");
INSERT INTO francl_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Le peuple murmura contre Moïse, en disant : « Que boirons-nous ? » ");
INSERT INTO francl_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Moïse cria à Yahweh, et Yahweh lui indiqua un bois ; il le jeta dans l’eau, et l’eau devint douce. Là Yahweh donna au peuple un statut et un droit, et là il le mit à l’épreuve. ");
INSERT INTO francl_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Il dit : « Si tu écoutes la voix de Yahweh, ton Dieu, si tu fais ce qui est droit à ses yeux, si tu prêtes l’oreille à ses commandements, et si tu observes toutes ses lois, je ne mettrai sur toi aucune des maladies que j’ai mises sur les Égyptiens ; car je suis Yahweh qui te guérit. » ");
INSERT INTO francl_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Ils arrivèrent à Élim, où il y avait douze sources d’eau et soixante-dix palmiers ; et ils campèrent là, près de l’eau. ");
INSERT INTO francl_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Ils partirent d’Élim, et toute l’assemblée des enfants d’Israël arriva au désert de Sin, qui est entre Élim et le Sinaï, le quinzième jour du second mois après leur sortie du pays d’Égypte. ");
INSERT INTO francl_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Toute l’assemblée des enfants d’Israël murmura dans le désert contre Moïse et Aaron. ");
INSERT INTO francl_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Les enfants d’Israël leur dirent : « Que ne sommes-nous morts par la main de Yahweh dans le pays d’Égypte, quand nous étions assis devant les pots de viande, que nous mangions du pain à satiété ? Car vous nous avez amenés dans ce désert pour faire mourir de faim toute cette multitude. » ");
INSERT INTO francl_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Yahweh dit à Moïse : « Voici, je vais faire pleuvoir pour vous du pain du haut du ciel. Le peuple sortira et en ramassera jour par jour la provision nécessaire, afin que je le mette à l’épreuve, pour voir s’il marchera, ou non, dans ma loi. ");
INSERT INTO francl_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Le sixième jour, ils prépareront ce qu’ils auront rapporté, et il y en aura le double de ce qu’ils en ramassent chaque jour. » ");
INSERT INTO francl_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Moïse et Aaron dirent à tous les enfants d’Israël : « Ce soir, vous reconnaîtrez que c’est Yahweh qui vous a fait sortir du pays d’Égypte ; ");
INSERT INTO francl_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","et, au matin, vous verrez la gloire de Yahweh, car il a entendu vos murmures qui sont contre Yahweh ; nous, que sommes-nous, pour que vous murmuriez contre nous ? » ");
INSERT INTO francl_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Moïse dit : « Ce sera quand Yahweh vous donnera ce soir de la viande à manger et, au matin, du pain à satiété ; car Yahweh a entendu les murmures que vous avez proférés contre lui. Nous, que sommes-nous ? Ce n’est pas contre nous que sont vos murmures, c’est contre Yahweh. » ");
INSERT INTO francl_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Moïse dit à Aaron : « Dis à toute l’assemblée des enfants d’Israël : Approchez-vous devant Yahweh, car il a entendu vos murmures. » ");
INSERT INTO francl_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Pendant qu’Aaron parlait à toute l’assemblée des enfants d’Israël, ils se tournèrent du côté du désert, et voici que la gloire de Yahweh apparut dans la nuée. ");
INSERT INTO francl_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Yahweh parla à Moïse en ces termes : ");
INSERT INTO francl_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","« J’ai entendu les murmures des enfants d’Israël. Dis-leur : Entre les deux soirs vous mangerez de la viande, et au matin vous vous rassasierez de pain, et vous saurez que je suis Yahweh, votre Dieu. » ");
INSERT INTO francl_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Le soir, on vit monter des cailles, qui couvrirent le camp, et le matin il y avait une couche de rosée autour du camp. ");
INSERT INTO francl_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Quand cette rosée fut dissipée, voici qu’il y avait à la surface du désert quelque chose de menu, de granuleux, de menu comme le givre sur le sol. ");
INSERT INTO francl_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Les enfants d’Israël le virent, et ils se dirent les uns aux autres : « Qu’est-ce que cela ? » car ils ne savaient pas ce que c’était. Moïse leur dit : « C’est le pain que Yahweh vous donne pour nourriture. ");
INSERT INTO francl_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Voici ce que Yahweh a ordonné : Que chacun de vous en ramasse ce qu’il faut pour sa nourriture, un omer par tête, suivant le nombre des personnes ; chacun en prendra pour ceux qui sont dans sa tente. » ");
INSERT INTO francl_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Les enfants d’Israël firent ainsi, et ils recueillirent les uns plus, les autres moins. ");
INSERT INTO francl_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","On mesurait ensuite avec l’omer, et celui qui en avait ramassé beaucoup n’avait rien de trop, et celui qui en avait ramassé peu n’en manquait pas : chacun en recueillait selon sa consommation. ");
INSERT INTO francl_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Moïse leur dit : « Que personne n’en laisse jusqu’au lendemain matin ». ");
INSERT INTO francl_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Ils n’écoutèrent pas Moïse, et des gens en gardèrent jusqu’au matin ; mais il s’y mit des vers et tout devint infect. Moïse fut irrité contre eux. ");
INSERT INTO francl_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Tous les matins, ils ramassaient de la manne, chacun selon sa consommation, et quand le soleil faisait sentir ses ardeurs, le reste se liquéfiait. ");
INSERT INTO francl_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Le sixième jour, ils ramassèrent une quantité double de nourriture, deux omers pour chacun. Tous les principaux du peuple vinrent en informer Moïse, ");
INSERT INTO francl_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","qui leur dit : « C’est ce que Yahweh a ordonné. Demain est un jour de repos, un sabbat consacré à Yahweh : faites cuire au four ce que vous avez à faire cuire, faites bouillir ce que vous avez à faire bouillir, et tout ce qui restera, mettez-le en réserve pour le lendemain matin. » ");
INSERT INTO francl_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Ils mirent donc l’excédant en réserve jusqu’au matin, comme Moïse l’avait ordonné, et il ne devint pas infect, et les vers ne s’y mirent point. ");
INSERT INTO francl_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Moïse dit : « Mangez-le aujourd’hui, car c’est le jour du sabbat en l’honneur de Yahweh ; aujourd’hui vous n’en trouveriez pas dans la campagne. ");
INSERT INTO francl_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Vous en recueillerez pendant six jours ; mais le septième jour, qui est le sabbat, il n’y en aura point. » ");
INSERT INTO francl_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Le septième jour, quelques-uns du peuple sortirent pour en ramasser, mais ils n’en trouvèrent pas. ");
INSERT INTO francl_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Alors Yahweh dit à Moïse : « Jusques à quand refuserez-vous d’observer mes commandements, et mes lois ? ");
INSERT INTO francl_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Voyez : c’est parce que Yahweh vous a donné le sabbat qu’il vous donne, le sixième jour, du pain pour deux jours. Que chacun reste à sa place, et que nul ne sorte le septième jour du lieu où il est. » ");
INSERT INTO francl_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Et le peuple se reposa le septième jour. ");
INSERT INTO francl_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","La maison d’Israël donna à cette nourriture le nom de manne. Elle ressemblait à de la graine de coriandre ; elle était blanche et avait le goût d’un gâteau de miel. ");
INSERT INTO francl_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Moïse dit : « Voici ce que Yahweh a ordonné : Emplis-en un omer, pour la conserver pour vos descendants, afin qu’ils voient le pain dont je vous ai nourris dans le désert, lorsque je vous ai fait sortir du pays d’Égypte. » ");
INSERT INTO francl_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Et Moïse dit à Aaron : « Prends un vase, mets-y de la manne plein un omer, et dépose-le devant Yahweh, afin qu’il soit conservé pour vos descendants. » ");
INSERT INTO francl_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Comme Yahweh l’avait ordonné à Moïse, Aaron le déposa devant le Témoignage, afin qu’il fût conservé. ");
INSERT INTO francl_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Les enfants d’Israël ont mangé la manne pendant quarante ans, jusqu’à leur arrivée dans un pays habité ; ils ont mangé la manne jusqu’à leur arrivée aux frontières du pays de Canaan. ");
INSERT INTO francl_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","l’omer est la dixième partie de l’épha. ");
INSERT INTO francl_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Toute l’assemblée des enfants d’Israël partit du désert de Sin, selon les marches que Yahweh lui ordonnait, et ils campèrent à Raphidim, où le peuple ne trouva pas d’eau à boire. ");
INSERT INTO francl_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Alors le peuple chercha querelle à Moïse, en disant : « Donnez-nous de l’eau à boire. » Moïse leur répondit : « Pourquoi me cherchez-vous querelle ? Pourquoi tentez-vous Yahweh ? » ");
INSERT INTO francl_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Et le peuple était là, pressé par la soif, et il murmurait contre Moïse ; il disait : « Pourquoi nous as-tu fait monter hors d’Égypte, pour nous faire mourir de soif avec mes enfants et mes troupeaux ? » ");
INSERT INTO francl_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Moïse cria vers Yahweh, en disant : « Que ferai-je pour ce peuple ? Encore un peu, et ils me lapideront ! » ");
INSERT INTO francl_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Yahweh dit à Moïse : « Passe devant le peuple et prends avec toi des anciens d’Israël ; prends aussi dans ta main ton bâton, avec lequel tu as frappé le fleuve, et va. ");
INSERT INTO francl_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Voici, je me tiendrai devant toi sur le rocher qui est en Horeb ; tu frapperas le rocher, et il en sortira de l’eau, et le peuple boira. » Moïse fit ainsi en présence des anciens d’Israël. ");
INSERT INTO francl_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Et il donna à ce lieu le nom de Massah et Méribah, parce que les enfants d’Israël avaient contesté, et parce qu’ils avaient tenté Yahweh en disant : « Yahweh est-il au milieu de nous, ou non ? » ");
INSERT INTO francl_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Amalec vint attaquer Israël à Raphidim. ");
INSERT INTO francl_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Et Moïse dit à Josué : « Choisis-nous des hommes, et va combattre Amalec ; demain je me tiendrai sur le sommet de la colline, le bâton de Dieu dans ma main. » ");
INSERT INTO francl_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Josué fit selon que lui avait dit Moïse, il combattit Amalec. Et Moïse, Aaron et Hur montèrent au sommet de la colline. ");
INSERT INTO francl_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Lorsque Moïse tenait sa main levée, Israël était le plus fort, et lorsqu’il laissait tomber sa main, Amalec était le plus fort. ");
INSERT INTO francl_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Comme les mains de Moïse étaient fatiguées, ils prirent une pierre, qu’ils placèrent sous lui, et il s’assit dessus ; et Aaron et Hur soutenaient ses mains, l’un d’un côté, l’autre de l’autre ; ainsi ses mains restèrent fermes jusqu’au coucher du soleil. ");
INSERT INTO francl_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Et Josué défit Amalec et son peuple à la pointe de l’épée. ");
INSERT INTO francl_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Yahweh dit à Moïse : « Écris cela en souvenir dans le livre, et déclare à Josué que j’effacerai la mémoire d’Amalec de dessous le ciel. » ");
INSERT INTO francl_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Moïse construisit un autel, et le nomma Yahweh-Nessi ");
INSERT INTO francl_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","et il dit : « Puisqu’on a levé la main contre le trône de Yahweh, Yahweh est en guerre contre Amalec d’âge en âge. » Note : ");
INSERT INTO francl_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Jéthro, prêtre de Madian, beau-père de Moïse, apprit tout ce que Dieu avait fait en faveur de Moïse et d’Israël, son peuple : que Yahweh avait fait sortir Israël d’Égypte. ");
INSERT INTO francl_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Jéthro, beau-père de Moïse, prit Séphora, femme de Moïse, qui avait été renvoyée, ");
INSERT INTO francl_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","et les deux fils de Séphora, dont l’un se nommait Gersam, parce que Moïse avait dit : « Je suis un étranger sur une terre étrangère », ");
INSERT INTO francl_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","et l’autre s’appelait Eliézer, parce qu’il avait dit : « Le Dieu de mon père m’a secouru, et il m’a délivré de l’épée de Pharaon. » ");
INSERT INTO francl_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Jéthro, beau-père de Moïse, avec les fils et la femme de Moïse, vint donc vers lui au désert où il campait, à la montagne de Dieu. ");
INSERT INTO francl_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Il fit dire à Moïse : « Moi, ton beau-père, Jéthro, je viens vers toi, ainsi que ta femme et ses deux fils avec elle. » ");
INSERT INTO francl_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Moïse sortit au-devant de son beau-père et, s’étant prosterné, il le baisa ; puis ils s’informèrent réciproquement de leur santé, et ils entrèrent dans la tente de Moïse. ");
INSERT INTO francl_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Moïse raconta à son beau-père tout ce que Yahweh avait fait à Pharaon et à l’Égypte à cause d’Israël, toutes les souffrances qui leur étaient survenues en chemin, et comment Yahweh les en avait délivrés. ");
INSERT INTO francl_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Jéthro se réjouit de tout le bien que Yahweh avait fait à Israël, et de ce qu’il l’avait délivré de la main des Égyptiens. Et Jéthro dit : ");
INSERT INTO francl_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","« Béni soit Yahweh qui vous a délivrés de la main des Égyptiens et de la main de Pharaon, et qui a délivré le peuple de la main des Égyptiens ! ");
INSERT INTO francl_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Je sais maintenant que Yahweh est plus grand que tous les dieux, car il s’est montré grand alors que les Égyptiens opprimaient Israël. » ");
INSERT INTO francl_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Jéthro, beau-père de Moïse, offrit à Dieu un holocauste et des sacrifices. Aaron et tous les anciens d’Israël vinrent prendre part au repas, avec le beau-père de Moïse, en présence de Dieu. ");
INSERT INTO francl_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Le lendemain, Moïse s’assit pour juger le peuple, et le peuple se tint devant lui depuis le matin jusqu’au soir. ");
INSERT INTO francl_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Le beau-père de Moïse, voyant tout ce qu’il faisait pour le peuple, dit : « Que fais-tu là pour ces gens ? Pourquoi sièges-tu seul, et tout le peuple se tient-il devant toi depuis le matin jusqu’au soir ? » ");
INSERT INTO francl_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Moïse répondit à son beau-père : « C’est que le peuple vient à moi pour consulter Dieu. ");
INSERT INTO francl_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Quand ils ont quelque affaire, ils viennent à moi ; je prononce entre eux, en faisant connaître les ordres de Dieu et ses lois. » ");
INSERT INTO francl_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Le beau-père de Moïse lui dit : « Ce que tu fais n’est pas bien. ");
INSERT INTO francl_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Tu succomberas certainement, toi et le peuple qui est avec toi ; car la tâche est au-dessus de tes forces, et tu ne saurais y suffire seul. ");
INSERT INTO francl_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Maintenant, écoute ma voix ; je vais te donner un conseil, et que Dieu soit avec toi ! Toi, sois le représentant du peuple auprès de Dieu, et porte les affaires devant Dieu. ");
INSERT INTO francl_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Apprends-leur les ordonnances et les lois, et fais-leur connaître la voie qu’ils doivent suivre et ce qu’ils doivent faire. ");
INSERT INTO francl_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Maintenant choisis parmi tout le peuple des hommes capables et craignant Dieu, des hommes intègres, ennemis de la cupidité, et établis-les sur eux comme chefs de milliers, chefs de centaines, chefs de cinquantaines et chefs de dizaines. ");
INSERT INTO francl_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Ils jugeront le peuple en tout temps, porteront devant toi toutes les causes importantes, et décideront eux-mêmes dans toutes les petites causes. Allège ainsi ta charge, et qu’ils la portent avec toi. ");
INSERT INTO francl_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Si tu fais cela, et que Dieu te donne des ordres, tu pourras y tenir et tout ce peuple aussi viendra en paix en son lieu. » ");
INSERT INTO francl_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Moïse écouta la voix de son beau-père et fit tout ce qu’il avait dit. ");
INSERT INTO francl_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Moïse choisit dans tout Israël des hommes capables, et il les préposa au peuple comme chefs de milliers, chefs de centaines, chefs de cinquantaines et chefs de dizaines. ");
INSERT INTO francl_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Ils jugeaient le peuple en tout temps ; ils portaient devant Moïse toutes les affaires graves, et décidaient eux-mêmes toutes les petites causes. ");
INSERT INTO francl_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Moïse prit congé de son beau-père, et Jéthro s’en retourna dans son pays. ");
INSERT INTO francl_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Ce fut au troisième mois après que les enfants d’Israël furent sortis d’Égypte, en ce jour, qu’ils arrivèrent au désert de Sinaï. ");
INSERT INTO francl_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Ils étaient partis de Raphidim ; arrivés au désert de Sinaï, ils campèrent dans le désert ; Israël campa là, vis-à-vis de la montagne. ");
INSERT INTO francl_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Moïse monta vers Dieu, et Yahweh l’appela du haut de la montagne en disant : « Tu parleras ainsi à la maison de Jacob et tu diras aux enfants d’Israël : ");
INSERT INTO francl_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Vous avez vu ce que j’ai fait à l’Égypte, et comment je vous ai portés sur des ailes d’aigle et amenés vers moi. ");
INSERT INTO francl_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Maintenant, si vous écoutez ma voix et si vous gardez mon alliance, vous serez mon peuple particulier parmi tous les peuples, car toute la terre est à moi ; ");
INSERT INTO francl_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","mais vous, vous serez pour moi un royaume de prêtres et une nation sainte. Telles sont les paroles que tu diras aux enfants d’Israël. » ");
INSERT INTO francl_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Moïse vint appeler les anciens du peuple, et il mit devant eux toutes ces paroles, selon que Yahweh le lui avait ordonné. ");
INSERT INTO francl_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Le peuple tout entier répondit : « Nous ferons tout ce qu’a dit Yahweh. » Moïse alla porter à Yahweh les paroles du peuple, ");
INSERT INTO francl_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","et Yahweh dit à Moïse : « Voici, je vais venir à toi dans une nuée épaisse, afin que le peuple entende quand je parlerai avec toi, et qu’en toi aussi il ait foi à jamais. » Et Moïse rapporta à Yahweh les paroles du peuple. ");
INSERT INTO francl_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Et Yahweh dit à Moïse : « Va vers le peuple, et sanctifie-les aujourd’hui et demain, et qu’ils lavent leurs vêtements. ");
INSERT INTO francl_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Qu’ils soient prêts pour le troisième jour ; car le troisième jour Yahweh descendra, aux yeux de tout le peuple, sur la montagne de Sinaï. ");
INSERT INTO francl_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Tu fixeras au peuple une limite à l’entour, en disant : Gardez-vous de monter sur la montagne ou d’en toucher le bord ; quiconque touchera la montagne sera mis à mort. ");
INSERT INTO francl_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","On ne mettra pas la main sur lui, mais on le lapidera ou on le percera de flèches ; bête ou homme, il ne doit pas vivre. Quand la trompette sonnera, ils monteront sur la montagne. » ");
INSERT INTO francl_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Moïse descendit de la montagne vers le peuple ; il sanctifia le peuple, et ils lavèrent leurs vêtements. ");
INSERT INTO francl_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Puis il dit au peuple : « Soyez prêts dans trois jours ; ne vous approchez d’aucune femme. » ");
INSERT INTO francl_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Le troisième jour au matin, il y eut des tonnerres, des éclairs, une nuée épaisse sur la montagne, et un son de trompe très fort, et tout le peuple qui était dans le camp trembla. ");
INSERT INTO francl_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Moïse fit sortir le peuple du camp, à la rencontre de Dieu, et ils se tinrent au pied de la montagne. ");
INSERT INTO francl_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","La montagne de Sinaï était toute fumante, parce que Yahweh y était descendu au milieu du feu, et la fumée s’élevait comme la fumée d’une fournaise, et toute la montagne tremblait fortement. ");
INSERT INTO francl_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Le son de la trompe devenait de plus en plus fort. Moïse parla, et Dieu lui répondit par une voix. ");
INSERT INTO francl_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Yahweh descendit sur la montagne de Sinaï, sur le sommet de la montagne, et Yahweh appela Moïse sur le sommet de la montagne, et Moïse monta. ");
INSERT INTO francl_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Yahweh dit à Moïse : « Descends, et défends expressément au peuple de rompre les barrières vers Yahweh pour regarder, de peur qu’un grand nombre d’entre eux ne périssent. ");
INSERT INTO francl_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Que même les prêtres, qui s’approchent de Yahweh, se sanctifient, de peur que Yahweh ne les frappe de mort. » ");
INSERT INTO francl_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Moïse dit à Yahweh : « Le peuple ne pourra pas monter sur la montagne de Sinaï, puisque vous nous en avez fait la défense expresse, en disant : Pose des limites autour de la montagne, et sanctifie-la. » ");
INSERT INTO francl_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Yahweh lui dit : « Va, descends, tu remonteras ensuite avec Aaron ; mais que les prêtres et le peuple ne rompent pas la barrière pour monter vers Yahweh, de peur qu’il ne les frappe de mort. » ");
INSERT INTO francl_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Moïse descendit vers le peuple et lui dit ces choses. ");
INSERT INTO francl_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Et Dieu prononça toutes ces paroles, en disant : ");
INSERT INTO francl_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","Je suis Yahweh, ton dieu, qui t’ai fait sortir du pays d’Égypte, de la maison de servitude. ");
INSERT INTO francl_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Tu n’auras pas d’autres dieux devant ma face. ");
INSERT INTO francl_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Tu ne te feras pas d’image taillée, ni aucune figure de ce qui est en haut dans le ciel, ou de ce qui est en bas sur la terre, ou de ce qui est dans les eaux au-dessous de la terre. ");
INSERT INTO francl_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Tu ne te prosterneras pas devant elles et tu ne les serviras point. Car moi Yahweh, ton Dieu, je suis un Dieu jaloux, qui punis l’iniquité des pères sur les enfants, sur la troisième et sur la quatrième génération pour ceux qui me haïssent, ");
INSERT INTO francl_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","et faisant miséricorde jusqu’à mille générations, pour ceux m’aiment et qui gardent mes commandements. ");
INSERT INTO francl_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Tu ne prendras pas le nom de Yahweh, ton Dieu, en vain, car Yahweh ne laissera pas impuni celui qui prendra son nom en vain. ");
INSERT INTO francl_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Souviens-toi du jour du sabbat pour le sanctifier. ");
INSERT INTO francl_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Pendant six jours tu travailleras, et tu feras tout ton ouvrage. ");
INSERT INTO francl_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Mais le septième jour est un sabbat consacré à Yahweh, ton Dieu : tu ne feras aucun ouvrage, ni toi, ni ton fils, ni ta fille, ni ton serviteur, ni ta servante, ni ton bétail, ni l’étranger qui est dans tes portes. ");
INSERT INTO francl_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Car pendant six jours Yahweh a fait le ciel, la terre, la mer et tout ce qu’ils contiennent, et il s’est reposé le septième jour : c’est pourquoi Yahweh a béni le jour du sabbat et l’a sanctifié. ");
INSERT INTO francl_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Honore ton père et ta mère, afin que tes jours soient prolongés dans le pays que Yahweh, ton Dieu, te donne. ");
INSERT INTO francl_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Tu ne tueras point. ");
INSERT INTO francl_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Tu ne commettras pas d’adultère. ");
INSERT INTO francl_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Tu ne déroberas point. ");
INSERT INTO francl_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Tu ne porteras pas de faux témoignages contre ton prochain. ");
INSERT INTO francl_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Tu ne convoiteras pas la maison de ton prochain ; tu ne convoiteras pas la femme de ton prochain, ni son serviteur, ni sa servante, ni son bœuf, ni son âne, ni rien de ce qui appartient à ton prochain. ");
INSERT INTO francl_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Tout le peuple entendait les tonnerres et le son de la trompette ; il voyait les flammes et la montagne fumante ; à ce spectacle, il tremblait et se tenait à distance. ");
INSERT INTO francl_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Ils dirent à Moïse : « Parles-nous, toi, et nous écouterons ; mais que Dieu ne nous parle point, de peur que nous ne mourrions. » ");
INSERT INTO francl_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Moïse répondit au peuple : « Ne vous effrayez pas, car c’est pour vous mettre à l’épreuve que Dieu est venu, et pour que sa crainte vous soit présente, afin que vous ne péchiez pas. » ");
INSERT INTO francl_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Et le peuple resta à distance ; mais Moïse s’approcha de la nuée où était Dieu. ");
INSERT INTO francl_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Et Yahweh dit à Moïse : « Tu parleras ainsi aux enfants d’Israël : vous avez vu que je vous ai parlé du ciel. ");
INSERT INTO francl_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Vous ne ferez pas à côté de moi de dieux d’argent et vous ne ferez pas de dieux d’or. ");
INSERT INTO francl_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Tu m’élèveras un autel de terre, sur lequel tu offriras tes holocaustes et tes sacrifices pacifiques, tes brebis et tes bœufs. Dans tous les lieux où j’aurai fait souvenir de mon nom, je viendrai vers toi, et je te bénirai. ");
INSERT INTO francl_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Si tu m’élèves un autel de pierre, tu ne le construiras pas en pierres taillées, car, en levant ton ciseau sur la pierre, tu la rendrais profane. ");
INSERT INTO francl_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Tu ne monteras pas par des degrés à mon autel, afin que ta nudité n’y soit pas découverte. ");
INSERT INTO francl_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Voici les lois que tu leur donneras : ");
INSERT INTO francl_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Quand tu achèteras un serviteur hébreu, il servira six années ; la septième, il sortira libre, sans rien payer. ");
INSERT INTO francl_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","S’il est entré seul, il sortira seul ; s’il avait une femme, sa femme sortira avec lui. ");
INSERT INTO francl_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Mais si c’est son maître qui lui a donné une femme, et qu’elle lui ait enfanté des fils et des filles, la femme et ses enfants appartiendront à son maître, et il sortira seul. ");
INSERT INTO francl_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Si le serviteur dit : « J’aime mon maître, ma femme et mes enfants ; je ne veux pas sortir libre », ");
INSERT INTO francl_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","alors son maître le conduira devant Dieu ; puis, l’ayant fait approcher de la porte ou du poteau, son maître lui percera l’oreille avec un poinçon, et le serviteur sera pour toujours à son service. ");
INSERT INTO francl_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Lorsqu’un homme aura vendu sa fille pour être servante, elle ne sortira pas comme sortent les serviteurs. ");
INSERT INTO francl_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Si elle déplaît à son maître, qui se l’était destinée, il permettra qu’on la rachète ; mais il ne pourra pas la vendre à des étrangers, après lui avoir été infidèle. ");
INSERT INTO francl_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","S’il la destine à son fils, il la traitera selon le droit des filles. ");
INSERT INTO francl_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Et s’il prend une autre femme, il ne retranchera rien à la première pour la nourriture, le vêtement et le couvert. ");
INSERT INTO francl_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Et s’il ne fait pas pour elle ces trois choses, elle pourra sortir sans rien payer, sans donner d’argent. ");
INSERT INTO francl_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Celui qui frappe un homme à mort doit être mis à mort. ");
INSERT INTO francl_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Mais s’il ne lui a pas tendu d’embûches et que Dieu l’ait présenté à sa main, je te fixerai un lieu où il pourra se réfugier. ");
INSERT INTO francl_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Mais si un homme agit méchamment contre son prochain pour le tuer par ruse, tu l’arracheras même de mon autel pour le faire mourir. ");
INSERT INTO francl_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Celui qui frappe son père ou sa mère doit être mis à mort. ");
INSERT INTO francl_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Celui qui dérobe un homme, soit qu’il le vende, soit qu’on le retrouve entre ses mains, doit être mis à mort. ");
INSERT INTO francl_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Celui qui maudira son père ou sa mère sera puni de mort. ");
INSERT INTO francl_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Lorsque des hommes se querellent, et que l’un en frappe un autre avec une pierre ou avec le poing, sans causer sa mort, mais en l’obligeant à tenir le lit, ");
INSERT INTO francl_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","celui qui l’aura frappé sera quitte, si l’autre en relève et qu’il puisse se promener, dehors avec son bâton ; seulement, il le dédommagera de son chômage et il le fera soigner. ");
INSERT INTO francl_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Quand un homme frappe du bâton son serviteur ou sa servante, et que ceux-ci meurent sous sa main, ils seront vengés. ");
INSERT INTO francl_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Mais si le serviteur survit un jour ou deux, il ne sera pas vengé ; car il est la propriété de son maître. ");
INSERT INTO francl_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Lorsque des hommes se battent, et qu’ils heurtent une femme enceinte, s’ils la font accoucher, sans autre accident, le coupable sera passible d’une amende que lui imposera le mari de la femme, et qu’il paiera selon la décision des juges. ");
INSERT INTO francl_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Mais s’il y a un accident, tu donneras vie pour vie, ");
INSERT INTO francl_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","œil pour œil, dent pour dent, main pour main, pied pour pied, ");
INSERT INTO francl_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","brûlure pour brûlure, blessure pour blessure, meurtrissure pour meurtrissure. ");
INSERT INTO francl_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Si un homme donne un coup dans l’œil de son serviteur ou de sa servante, et qu’il lui fasse perdre l’œil, il le mettra en liberté en compensation de son œil. ");
INSERT INTO francl_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Et s’il fait tomber une dent à son serviteur ou à sa servante, il le mettra en liberté en compensation de sa dent. ");
INSERT INTO francl_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Si un bœuf frappe de sa corne un homme ou une femme, et que la mort s’en suive, le bœuf sera lapidé, on n’en mangera pas la chair, mais le maître du bœuf sera quitte. ");
INSERT INTO francl_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Mais si le bœuf frappait de la corne depuis longtemps, et que son maître, en ayant été averti, ne l’ait pas surveillé, le bœuf sera lapidé, s’il tue un homme ou une femme, et son maître aussi sera mis à mort. ");
INSERT INTO francl_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Si on impose au maître un prix pour le rachat de sa vie, il paiera tout ce qui lui aura été imposé. ");
INSERT INTO francl_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Si le bœuf frappe un fils ou une fille, on appliquera encore cette loi ; ");
INSERT INTO francl_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","mais si le bœuf frappe un serviteur ou une servante, on paiera trente sicles d’argent au maître de l’esclave, et le bœuf sera lapidé. ");
INSERT INTO francl_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Si un homme ouvre une citerne, ou bien si un homme creuse une citerne et ne la couvre pas, et qu’il y tombe un bœuf ou un âne, ");
INSERT INTO francl_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","le possesseur de la citerne indemnisera : il rendra au maître la valeur de la bête en argent, et la bête tuée sera pour lui. ");
INSERT INTO francl_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Si le bœuf d’un homme frappe de la corne le bœuf d’un autre homme, et que la mort s’en suive, ils vendront le bœuf vivant et s’en partageront le prix ; ils se partageront aussi le bœuf tué. ");
INSERT INTO francl_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Mais s’il est reconnu que le bœuf frappait de la corne depuis longtemps, et que son maître ne l’ait pas surveillé, celui-ci indemnisera en donnant bœuf pour bœuf, et le bœuf tué sera pour lui. ");
INSERT INTO francl_vpl VALUES ("EX21_37","003_21_37","EXO","21","37","37","Si un homme dérobe un bœuf ou un agneau et qu’il l’égorge ou le vende, il restituera cinq bœufs pour le bœuf, et quatre agneaux pour l’agneau. ");
INSERT INTO francl_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Si le voleur est surpris la nuit faisant effraction, et qu’il soit frappé et meure, on n’est pas responsable du sang pour lui ; ");
INSERT INTO francl_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","mais si le soleil est levé, on sera responsable du sang pour lui. – Le voleur fera restitution : s’il n’a rien, on le vendra pour ce qu’il a volé. ");
INSERT INTO francl_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Si ce qu’il a volé, bœuf, âne ou brebis, se trouve encore vivant entre ses mains, il restituera le double. ");
INSERT INTO francl_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Si un homme fait du dégât dans un champ ou dans une vigne, en laissant son bétail brouter le champ d’autrui, il donnera en dédommagement le meilleur de son champ et le meilleur de sa vigne. ");
INSERT INTO francl_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Si un feu éclate et que, après avoir atteint les épines, il consume des gerbes, ou du blé sur pied, ou un champ, celui qui aura allumé l’incendie donnera un dédommagement. ");
INSERT INTO francl_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Si un homme donne en garde à un autre de l’argent ou des objets, et qu’on les vole de la maison de ce dernier, le voleur, si on le trouve, restituera le double. ");
INSERT INTO francl_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Si le voleur n’est pas trouvé, le maître de la maison se présentera devant Dieu, pour déclarer s’il n’a pas mis la main sur le bien de son prochain. ");
INSERT INTO francl_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Quel que soit le corps du délit, bœuf, âne, brebis, vêtement ou tout objet perdu, au sujet duquel on dira : « C’est bien cela ! » la cause des deux parties ira jusqu’à Dieu, et celui que Dieu aura condamné restituera le double à son prochain. ");
INSERT INTO francl_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Si un homme donne en garde à un autre un bœuf, une brebis, une tête de bétail quelconque, et que l’animal meure, se casse un membre, ou soit enlevé, sans qu’il y ait de témoin, ");
INSERT INTO francl_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","le serment de Yahweh interviendra entre les deux parties, pour qu’on sache si le dépositaire n’a pas mis la main sur le bien de son prochain ; et le propriétaire de la bête acceptera ce serment, et l’autre n’aura pas à indemniser. ");
INSERT INTO francl_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","Mais si la bête a été dérobée chez lui, il aura à indemniser le propriétaire. ");
INSERT INTO francl_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Si elle a été déchirée par une bête féroce, il en produira les restes en témoignage, et il n’aura pas à indemniser pour la bête déchirée. ");
INSERT INTO francl_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Si un homme emprunte à un autre une bête, et qu’elle se casse un membre ou meure, son propriétaire n’étant pas présent, il y aura lieu à indemnité. ");
INSERT INTO francl_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Si le propriétaire est présent, on n’indemnisera pas. Si la bête était louée, le prix de location sera une compensation. ");
INSERT INTO francl_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Si un homme séduit une vierge qui n’est pas fiancée, et couche avec elle, il paiera sa dot et la prendra pour femme. ");
INSERT INTO francl_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Si le père refuse de la lui accorder, le séducteur paiera l’argent qu’on donne pour la dot des vierges. ");
INSERT INTO francl_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Tu ne laisseras pas vivre la magicienne. ");
INSERT INTO francl_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Quiconque a commerce avec une bête sera mis à mort. ");
INSERT INTO francl_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Celui qui offre des sacrifices aux dieux, et non à Yahweh seul, sera voué à l’anathème. ");
INSERT INTO francl_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Tu ne maltraiteras pas l’étranger et tu ne l’opprimeras point, car vous avez été des étrangers dans le pays d’Égypte. ");
INSERT INTO francl_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Vous n’affligerez pas la veuve ni l’orphelin. ");
INSERT INTO francl_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Si tu les affliges, ils crieront vers moi, et j’entendrai leur cri ; ");
INSERT INTO francl_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","ma colère s’enflammera, et je vous détruirai par l’épée, et vos femmes seront des veuves et vos enfants des orphelins. ");
INSERT INTO francl_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Si tu prêtes de l’argent à quelqu’un de mon peuple, au pauvre qui est avec toi, tu ne seras pas à son égard comme un créancier, tu n’exigeras pas de lui d’intérêt. ");
INSERT INTO francl_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Si tu prends en gage le manteau de ton prochain, tu le lui rendras avant le coucher du soleil ; ");
INSERT INTO francl_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","car c’est sa seule couverture, c’est le vêtement dont il s’enveloppe le corps : sur quoi coucherait-il ? S’il crie vers moi, je l’entendrai car je suis compatissant. ");
INSERT INTO francl_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Tu ne blasphémeras pas contre Dieu, et tu ne maudiras pas un prince de ton peuple. ");
INSERT INTO francl_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Tu ne différeras pas de m’offrir les prémices de ta moisson et de ton pressoir. Tu me donneras le premier-né de tes fils. ");
INSERT INTO francl_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Tu feras de même du premier-né de ta vache et de ta brebis : il restera sept jours avec sa mère et le huitième jour tu me le donneras. ");
INSERT INTO francl_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Vous serez pour moi des hommes saints ; vous ne mangerez pas la chair déchirée qui se trouvera dans les champs : vous la jetterez aux chiens. ");
INSERT INTO francl_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Tu ne sèmeras pas de faux bruit ; tu ne donneras pas la main à un méchant en lui servant de témoin à charge. ");
INSERT INTO francl_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Tu ne suivras pas la multitude pour faire le mal, et tu ne déposeras pas dans un procès en te mettant du côté du grand nombre pour faire fléchir la justice. ");
INSERT INTO francl_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Tu ne favoriseras pas non plus un faible dans son procès. ");
INSERT INTO francl_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Si tu rencontres le bœuf de ton ennemi ou son âne égaré, tu ne manqueras pas de le lui ramener. ");
INSERT INTO francl_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Si tu vois l’âne de celui qui te hait succombant sous sa charge, tu te garderas de l’abandonner ; joins tes efforts aux siens pour le décharger. ");
INSERT INTO francl_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Tu ne feras pas fléchir le droit du pauvre dans son procès. ");
INSERT INTO francl_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Tu t’éloigneras d’une cause mensongère, et tu ne feras pas mourir l’innocent et le juste ; car je n’absoudrai pas un coupable. ");
INSERT INTO francl_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Tu n’accepteras pas de présents ; car les présents aveuglent les clairvoyants et ruinent les causes justes. ");
INSERT INTO francl_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Tu n’opprimeras pas l’étranger ; vous savez ce que ressent l’étranger, car vous avez été étrangers dans le pays d’Égypte. ");
INSERT INTO francl_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Pendant six années tu ensemenceras ta terre et tu en récolteras les produits. ");
INSERT INTO francl_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Mais, la septième, tu les laisseras et les abandonneras ; et les indigents de ton peuple les mangeront, et les bêtes des champs mangeront ce qui restera. Tu feras de même pour tes vignes et les oliviers. ");
INSERT INTO francl_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Pendant six jours tu feras ton ouvrage ; mais le septième jour tu te reposeras, afin que ton bœuf et ton âne aient du repos, et que le fils de ta servante et l’étranger respirent. ");
INSERT INTO francl_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Vous prendrez garde à tout ce que je vous ai dit ; vous ne prononcerez pas le nom de dieux étrangers, et on n’en entendra pas sortir de votre bouche. ");
INSERT INTO francl_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Trois fois chaque année tu célébreras une fête en mon honneur. ");
INSERT INTO francl_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Tu observeras la fête des Azymes : pendant sept jours tu mangeras des pains sans levain, comme je t’en ai donné l’ordre, au temps fixé, au mois d’abib, car c’est dans ce mois que tu es sorti d’Égypte ; et l’on ne se présentera pas les mains vides devant ma face. ");
INSERT INTO francl_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Tu observeras la fête de la Moisson, des prémices de ton travail, de ce que tu auras semé dans les champs ; et la fête de la Récolte, à la fin de l’année, quand tu recueilleras des champs le fruit de ton travail. ");
INSERT INTO francl_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Trois fois l’année, tous tes mâles se présenteront devant le seigneur Yahweh. ");
INSERT INTO francl_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Tu n’offriras pas avec du pain levé le sang de ma victime, et la graisse de ma fête ne sera pas gardée pendant la nuit jusqu’au matin. ");
INSERT INTO francl_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Tu apporteras les prémices des premiers fruits de ton sol à la maison de Yahweh, ton Dieu. Tu ne feras pas cuire un chevreau dans le lait de sa mère. ");
INSERT INTO francl_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Voici que j’envoie un ange devant toi, pour te garder dans le chemin et pour te faire arriver au lieu que j’ai préparé. ");
INSERT INTO francl_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Sois sur tes gardes en sa présence et écoute sa voix ; ne lui résiste pas, car il ne pardonnerait pas votre transgression, parce que mon nom est en lui. ");
INSERT INTO francl_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Mais si tu écoutes sa voix, et si tu fais tout ce que je dirai, je serai l’ennemi de tes ennemis et l’adversaire de tes adversaires. ");
INSERT INTO francl_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Car mon ange marchera devant toi et te conduira vers les Amorrhéens, les Hittites, les Phérézéens, les Chananéens, les Hévéens et les Jébuséens, et je les exterminerai. ");
INSERT INTO francl_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Tu n’adoreras pas leurs dieux et tu ne les serviras pas ; tu ne les imiteras pas dans leurs pratiques, mais tu renverseras et briseras leurs stèles. ");
INSERT INTO francl_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Vous servirez Yahweh, votre Dieu, et il bénira ton pain et ton eau, et j’éloignerai la maladie du milieu de toi. ");
INSERT INTO francl_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Il n’y aura dans ton pays ni femme qui perde son fruit, ni femme stérile ; je remplirai le nombre de tes jours. ");
INSERT INTO francl_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","J’enverrai ma terreur devant toi, je jetterai dans la confusion tous les peuples chez lesquels tu arriveras, et je ferai tourner le dos devant toi à tous tes ennemis. ");
INSERT INTO francl_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","J’enverrai devant toi les frelons, qui chasseront loin de ta face les Hévéens, les Chananéens et les Hittites. ");
INSERT INTO francl_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Je ne les chasserai pas de ta face en une seule année, de peur que le pays ne devienne un désert, et que les bêtes sauvages ne se multiplient contre toi. ");
INSERT INTO francl_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Je les chasserai peu à peu de devant toi, jusqu’à ce que tu augmentes en nombre et que tu puisses occuper le pays. ");
INSERT INTO francl_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","J’établirai tes limites depuis la mer Rouge jusqu’à la mer des Philistins, et depuis le désert jusqu’au fleuve ; car je livrerai entre vos mains les habitants du pays, et tu les chasseras de devant toi. ");
INSERT INTO francl_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Tu ne feras pas alliance avec eux, ni avec leurs dieux. ");
INSERT INTO francl_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Ils n’habiteront pas dans ton pays, de peur qu’ils ne te fassent pécher contre moi ; tu servirais leurs dieux, et ce serait un piège pour toi. » ");
INSERT INTO francl_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Dieu dit à Moïse : « Monte vers Yahweh, toi et Aaron, Nadab et Abiu, et soixante-dix des anciens d’Israël, et prosternez-vous de loin. ");
INSERT INTO francl_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Moïse s’approchera seul de Yahweh ; les autres ne s’approcheront pas, et le peuple ne montera pas avec lui. » ");
INSERT INTO francl_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Moïse vint rapporter au peuple toutes les paroles de Yahweh et toutes les lois ; et le peuple entier répondit d’une seule voix : « Toutes les paroles qu’a dites Yahweh, nous les accomplirons. » ");
INSERT INTO francl_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Moïse écrivit toutes les paroles de Yahweh. Puis, s’étant levé de bon matin, il bâtit un autel au pied de la montagne, et dressa douze stèles pour les douze tribus d’Israël. ");
INSERT INTO francl_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Il envoya des jeunes gens, enfants d’Israël, et ils offrirent à Yahweh des holocaustes et immolèrent des taureaux en sacrifices d’actions de grâces. ");
INSERT INTO francl_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Moïse prit la moitié du sang, qu’il mit dans des bassins, et il répandit l’autre moitié sur l’autel. ");
INSERT INTO francl_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Ayant pris le livre de l’alliance, il le lut en présence du peuple, qui répondit : « Tout ce qu’a dit Yahweh, nous le ferons et nous y obéirons. » ");
INSERT INTO francl_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Moïse prit le sang et en aspergea le peuple, en disant : « Voici le sang de l’alliance que Yahweh a conclue avec vous sur toutes ces paroles. » ");
INSERT INTO francl_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Moïse monta avec Aaron, Nadab et Abiu et soixante-dix des anciens d’Israël ; ");
INSERT INTO francl_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","et ils virent le Dieu d’Israël : sous ses pieds était comme un ouvrage de brillants saphirs, pur comme le ciel même. ");
INSERT INTO francl_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Et il n’étendit pas sa main sur les élus des enfants d’Israël : ils virent Dieu, et ils mangèrent et burent. ");
INSERT INTO francl_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Yahweh dit à Moïse : « Monte vers moi sur la montagne, et restes-y ; je te donnerai les tables de pierre, la loi et les préceptes que j’ai écrits pour leur instruction. » ");
INSERT INTO francl_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Moïse se leva, avec Josué, son serviteur, et Moïse monta vers la montagne de Dieu. ");
INSERT INTO francl_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Il dit aux anciens : Attendez-nous ici, jusqu’à ce que nous revenions auprès de vous. Voici Aaron et Hur seront avec vous ; si quelqu’un a un différend, qu’il s’adresse à eux. » ");
INSERT INTO francl_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Moïse monta vers la montagne, et la nuée couvrit la montagne ; ");
INSERT INTO francl_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","la gloire de Yahweh reposa sur la montagne de Sinaï, et la nuée la couvrit pendant six jours. Le septième jour, Yahweh appela Moïse du milieu de la nuée. ");
INSERT INTO francl_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","L’aspect de la gloire de Yahweh était, aux yeux des enfants d’Israël, comme un feu dévorant sur le sommet de la montagne. ");
INSERT INTO francl_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Moïse entra au milieu de la nuée, et monta à la montagne ; et Moïse demeura sur la montagne quarante jours et quarante nuits. ");
INSERT INTO francl_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","« Dis aux enfants d’Israël de prélever pour moi une offrande ; de tout homme qui la donnera de bon cœur vous recevrez pour moi l’offrande. ");
INSERT INTO francl_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Voici l’offrande que vous recevrez d’eux : de l’or, de l’argent et de l’airain ; ");
INSERT INTO francl_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","de la pourpre violette, de la pourpre écarlate, du cramoisi, du fin lin et du poil de chèvre ; ");
INSERT INTO francl_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","des peaux de béliers teintes en rouge, des peaux de veaux marins et du bois d’acacia ; ");
INSERT INTO francl_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","de l’huile pour le chandelier, des aromates pour l’huile d’onction et pour le parfum d’encensement ; ");
INSERT INTO francl_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","des pierres d’onyx et d’autres pierres à enchâsser pour l’éphod et le pectoral. ");
INSERT INTO francl_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Ils me feront un sanctuaire, et j’habiterai au milieu d’eux. ");
INSERT INTO francl_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Vous vous conformerez à tout ce que je vais vous montrer, au modèle du tabernacle, et au modèle de tous ses ustensiles. » ");
INSERT INTO francl_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","« Ils feront une arche de bois d’acacia ; sa longueur sera de deux coudées et demie, sa largeur d’une coudée et demie, et sa hauteur d’une coudée et demie. ");
INSERT INTO francl_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Tu la revêtiras d’or pur, en dedans et en dehors, et tu y feras une guirlande d’or tout autour. ");
INSERT INTO francl_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Tu fondras pour elle quatre anneaux d’or, que tu mettras à ses quatre pieds, deux anneaux d’un côté et deux anneaux de l’autre. ");
INSERT INTO francl_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Tu feras des barres de bois d’acacia, et tu les revêtiras d’or. ");
INSERT INTO francl_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Tu passeras les barres dans les anneaux sur les côtés de l’arche, pour qu’elles servent à porter l’arche. ");
INSERT INTO francl_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Les barres resteront dans les anneaux de l’arche, et n’en seront pas retirées. ");
INSERT INTO francl_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Tu mettras dans l’arche le témoignage que je te donnerai. ");
INSERT INTO francl_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Tu feras un propitiatoire d’or pur ; sa longueur sera de deux coudées et demie, et sa largeur d’une coudée et demie. ");
INSERT INTO francl_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Tu feras deux chérubins d’or ; tu les feras d’or battu, aux deux extrémités du propitiatoire. ");
INSERT INTO francl_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Fais un chérubin à l’une des extrémités et un chérubin à l’autre extrémité ; vous ferez les chérubins sortant du propitiatoire à ses deux extrémités. ");
INSERT INTO francl_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Les chérubins auront leurs ailes déployées vers le haut, couvrant de leurs ailes le propitiatoire, et se faisant face l’un à l’autre ; les faces des chérubins seront tournées vers le propitiatoire. ");
INSERT INTO francl_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Tu mettras le propitiatoire au-dessus de l’arche, et tu mettras dans l’arche le témoignage que je te donnerai. ");
INSERT INTO francl_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Là je me rencontrerai avec toi et je te communiquerai, de dessus le propitiatoire, du milieu des deux chérubins qui sont sur l’arche du témoignage, tous les ordres que je te donnerai pour les enfants d’Israël. ");
INSERT INTO francl_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Tu feras une table de bois d’acacia ; sa longueur sera de deux coudées, sa largeur d’une coudée, et sa hauteur d’une coudée et demie. ");
INSERT INTO francl_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Tu la revêtiras d’or pur, et tu y mettras une guirlande d’or tout autour. ");
INSERT INTO francl_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Tu lui feras à l’entour un châssis d’une palme, et tu feras une guirlande d’or au châssis, tout autour. ");
INSERT INTO francl_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Tu feras pour la table quatre anneaux d’or ; et tu mettras les anneaux aux quatre coins, qui seront à ses quatre pieds. ");
INSERT INTO francl_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Les anneaux seront près du châssis, pour recevoir les barres qui doivent porter la table. ");
INSERT INTO francl_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Tu feras les barres de bois d’acacia, et tu les revêtiras d’or ; elles serviront à porter la table. ");
INSERT INTO francl_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Tu feras ses plats, ses cassolettes, ses coupes et ses tasses servant aux libations ; tu les feras d’or pur. ");
INSERT INTO francl_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Tu placeras sur la table les pains de proposition, perpétuellement devant ma face. ");
INSERT INTO francl_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Tu feras un chandelier d’or pur ; le chandelier, avec son pied et sa tige, sera fait d’or battu ; ses calices, ses boutons et ses fleurs seront d’une même pièce. ");
INSERT INTO francl_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Six branches sortiront de ses côtés ; trois branches du chandelier de l’un de ses côtés, et trois branches du chandelier du second de ses côtés. ");
INSERT INTO francl_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Il y aura sur la première branche trois calices en fleurs d’amandier, bouton et fleur, et sur la seconde branche trois calices en fleurs d’amandier, bouton et fleur ; il en sera de même pour les six branches partant du chandelier. ");
INSERT INTO francl_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","A la tige du chandelier, il y aura quatre calices en fleurs d’amandier, leurs boutons et leurs fleurs. ");
INSERT INTO francl_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Il y aura un bouton sous les deux premières branches partant de la tige du chandelier, un bouton sous les deux branches suivantes partant de la tige du chandelier, et un bouton sous les deux dernières branches partant de la tige du chandelier, selon les six branches sortant de la tige du chandelier. ");
INSERT INTO francl_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Ces boutons et ces branches seront d’une même pièce avec le chandelier ; le tout sera une masse d’or battu, d’or pur. ");
INSERT INTO francl_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Tu feras ses lampes, au nombre de sept, et on placera ses lampes sur les branches, de manière à éclairer en face. ");
INSERT INTO francl_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Ses mouchettes et ses vases à cendre seront en or pur. ");
INSERT INTO francl_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","On emploiera un talent d’or pur pour faire le chandelier avec tous ses ustensiles. ");
INSERT INTO francl_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Regarde, et fais selon le modèle qui t’est montré sur la montagne. » ");
INSERT INTO francl_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","« Tu feras la Demeure de dix tentures ; tu les feras de lin retors, de pourpre violette, de pourpre écarlate et de cramoisi, avec des chérubins, ouvrage d’habile tisseur. ");
INSERT INTO francl_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","La longueur d’une tenture sera de vingt-huit coudées, et la largeur d’une tenture sera de quatre coudées ; la dimension sera la même pour toutes les tentures. ");
INSERT INTO francl_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Cinq de ces tentures seront jointes ensemble ; les cinq autres seront aussi jointes ensemble. ");
INSERT INTO francl_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Tu mettras des lacets de pourpre violette au bord de la tenture terminant le premier assemblage ; et tu feras de même au bord de la tenture terminant le second assemblage. ");
INSERT INTO francl_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Tu feras cinquante lacets à la première tenture, et tu feras cinquante lacets au bord de la tenture terminant le second assemblage, et ces lacets se correspondront les uns aux autres. ");
INSERT INTO francl_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Tu feras cinquante agrafes d’or, avec lesquelles tu joindras les tentures l’une à l’autre, en sorte que la Demeure forme un seul tout. ");
INSERT INTO francl_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Tu feras aussi des tentures de poil de chèvre pour former une tente sur la Demeure ; tu feras onze de ces tentures. ");
INSERT INTO francl_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","La longueur d’une tenture sera de trente coudées, et la largeur d’une tenture sera de quatre coudées ; la dimension sera la même pour les onze tentures. ");
INSERT INTO francl_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Tu joindras à part cinq de ces tentures, et les six autres à part, et tu replieras la sixième tenture sur le devant de la tente. ");
INSERT INTO francl_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Tu mettras cinquante lacets au bord de la tenture terminant le premier assemblage, et cinquante autres au bord de la tenture du second assemblage. ");
INSERT INTO francl_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Tu feras cinquante agrafes d’airain, tu introduiras les agrafes dans les lacets, et tu assembleras ainsi la tente, qui formera un seul tout. ");
INSERT INTO francl_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Quant à la partie qui sera de surplus dans les tentures de la tente, savoir la moitié de la tenture en plus, elle retombera sur le derrière de la Demeure, ");
INSERT INTO francl_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","et les coudées en excédent l’une d’un côté, l’autre de l’autre, sur la longueur des tentures de la tente, retomberont sur les côtés de la Demeure, l’une d’un côté, l’autre de l’autre, pour la couvrir. ");
INSERT INTO francl_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Tu feras pour la tente une couverture en peaux de béliers teintes en rouge, et une couverture en peaux de veaux marins, par-dessus. ");
INSERT INTO francl_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Tu feras aussi les planches pour la Demeure, des planches de bois d’acacia, posées debout. ");
INSERT INTO francl_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","La longueur d’une planche sera de dix coudées, et la largeur d’une planche sera d’une coudée et demie. ");
INSERT INTO francl_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Il y aura à chaque planche deux tenons, joints l’un à l’autre ; tu feras de même pour toutes les planches de la Demeure. ");
INSERT INTO francl_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Tu feras les planches pour la Demeure : vingt planches pour la face du midi, à droite. ");
INSERT INTO francl_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Tu mettras sous les vingt planches quarante socles d’argent, deux socles sous chaque planche pour ses deux tenons. ");
INSERT INTO francl_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Pour le second côté de la Demeure, le côté du nord, tu feras vingt planches, ");
INSERT INTO francl_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","ainsi que leurs quarante socles d’argent, deux socles sous chaque planche. ");
INSERT INTO francl_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Tu feras six planches pour le fond de la Demeure, du côté de l’occident. ");
INSERT INTO francl_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Tu feras deux planches pour les angles de la Demeure, dans le fond ; ");
INSERT INTO francl_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","elles seront doubles depuis le bas, formant ensemble un seul tout jusqu’à leur sommet, jusqu’au premier anneau. Ainsi en sera-t-il pour toutes les deux ; elles seront placées aux deux angles. ");
INSERT INTO francl_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Il y aura ainsi huit planches, avec leurs socles d’argent, seize socles, deux socles sous chaque planche. ");
INSERT INTO francl_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Tu feras des traverses de bois d’acacia, cinq pour les planches de l’un des côtés de la Demeure, ");
INSERT INTO francl_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","cinq traverses pour les planches du second côté de la Demeure, et cinq traverses pour les planches du côté de la Demeure qui en forme le fond, vers l’occident. ");
INSERT INTO francl_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","La traverse du milieu s’étendra, le long des planches, d’une extrémité à l’autre. ");
INSERT INTO francl_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Tu revêtiras d’or les planches, et tu feras d’or leurs anneaux qui doivent recevoir les traverses, et tu revêtiras d’or les traverses. ");
INSERT INTO francl_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Tu dresseras la Demeure d’après le modèle qui t’a été montré sur la montagne. ");
INSERT INTO francl_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Tu feras un voile de pourpre violette, de pourpre écarlate, de cramoisi et de lin retors ; on y représentera des chérubins : ouvrage d’un habile tisseur. ");
INSERT INTO francl_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Tu le suspendras à quatre colonnes de bois d’acacia, revêtues d’or, avec des crochets d’or et posées sur quatre socles d’argent. ");
INSERT INTO francl_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Tu mettras le voile sous les agrafes, et c’est là, derrière le voile, que tu feras entrer l’arche du témoignage ; le voile fera pour vous une séparation entre le Lieu saint et le Lieu très saint. ");
INSERT INTO francl_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Tu placeras le propitiatoire sur l’arche du témoignage dans le Lieu très saint. ");
INSERT INTO francl_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Tu placeras la table en dehors du voile, et le chandelier en face de la table, du côté méridional de la Demeure ; et tu placeras la table du côté septentrional. ");
INSERT INTO francl_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Tu feras pour l’entrée de la tente un rideau en pourpre violette, pourpre écarlate, cramoisi et lin retors, ouvrage d’un dessin varié. ");
INSERT INTO francl_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Tu feras pour ce rideau cinq colonnes d’acacia, et tu les revêtiras d’or ; elles auront des crochets d’or, et tu fondras pour elles cinq socles d’airain. » ");
INSERT INTO francl_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","« Tu feras l’autel en bois d’acacia ; sa longueur sera de cinq coudées, et sa largeur de cinq coudées. L’autel sera carré, et sa hauteur sera de trois coudées. ");
INSERT INTO francl_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","A ses quatre coins, tu feras des cornes qui sortiront de l’autel, et tu le revêtiras d’airain. ");
INSERT INTO francl_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Tu feras pour l’autel des vases pour recueillir les cendres, des pelles, des bassins, des fourchettes et des brasiers ; tu feras d’airain tous ces ustensiles. ");
INSERT INTO francl_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Tu feras à l’autel une grille d’airain en forme de treillis, et tu mettras quatre anneaux d’airain aux quatre bouts du treillis. ");
INSERT INTO francl_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Tu la placeras sous la corniche de l’autel, par en bas, et le treillis sera jusqu’à la moitié de la hauteur de l’autel. ");
INSERT INTO francl_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Tu feras pour l’autel des barres, des barres de bois d’acacia, que tu revêtiras d’airain. ");
INSERT INTO francl_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","On passera ces barres dans les anneaux, et elles seront aux deux côtés de l’autel, quand on le transportera. ");
INSERT INTO francl_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Tu le feras creux, en planches ; on le fera comme il t’a été montré sur la montagne. » ");
INSERT INTO francl_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","« Tu feras le parvis de la Demeure. Du côté du midi, à droite, il y aura, pour former le parvis des rideaux de lin retors, sur une longueur de cent coudées pour un côté, ");
INSERT INTO francl_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","avec vingt colonnes et leurs vingt socles d’airain ; les crochets des colonnes et leurs tringles seront d’argent. ");
INSERT INTO francl_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","De même, du côté du nord, il y aura des rideaux sur une longueur de cent coudées, avec vingt colonnes et leurs vingt socles d’airain ; les crochets des colonnes et leurs tringles seront d’argent. ");
INSERT INTO francl_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Du côté de l’occident, il y aura, pour la largeur du parvis, cinquante coudées de rideaux, avec dix colonnes et leurs dix socles. ");
INSERT INTO francl_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Du côté de l’orient, sur le devant, le parvis aura une largeur de cinquante coudées ; ");
INSERT INTO francl_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","et il y aura quinze coudées de rideaux pour un côté de la porte, avec trois colonnes et leurs trois socles, ");
INSERT INTO francl_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","et quinze coudées de rideaux pour le deuxième côté, avec trois colonnes et leurs trois socles. ");
INSERT INTO francl_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Pour la porte du parvis, il y aura une tenture de vingt coudées, en pourpre violette, pourpre écarlate, cramoisi, et lin retors, avec dessin varié, ainsi que quatre colonnes avec leurs quatre socles. ");
INSERT INTO francl_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Toutes les colonnes formant l’enceinte du parvis seront reliées par des tringles d’argent ; elles auront des crochets d’argent et leurs socles seront d’airain. ");
INSERT INTO francl_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","La longueur du parvis sera de cent coudées, sa largeur de cinquante coudées de chaque côté, et sa hauteur de cinq coudées ; les rideaux seront de lin retors, et les socles d’airain. ");
INSERT INTO francl_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Tous les ustensiles destinés au service de la Demeure, tous ses pieux et tous les pieux du parvis seront d’airain. » ");
INSERT INTO francl_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","« Tu ordonneras aux enfants d’Israël de t’apporter pour le luminaire de l’huile d’olives concassées, pour entretenir les lampes continuellement. ");
INSERT INTO francl_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Dans la tente de réunion, en dehors du voile qui est devant le témoignage, Aaron et ses fils la prépareront pour brûler du soir au matin en présence de Yahweh. C’est une loi perpétuelle, de génération en génération pour les enfants d’Israël. » ");
INSERT INTO francl_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","« Fais venir auprès de toi Aaron ton frère, et ses fils avec lui, du milieu des enfants d’Israël, pour qu’il soit prêtre à mon service : Aaron, Nadab, Abiu, Eléazar et Ithamar, fils d’Aaron. ");
INSERT INTO francl_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Tu feras à Aaron, ton frère, des vêtements sacrés, pour marquer sa dignité et pour lui servir de parure. ");
INSERT INTO francl_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Tu t’adresseras à tous les hommes habiles que j’ai remplis d’un esprit de sagesse, et ils feront les vêtements d’Aaron, afin qu’il soit consacré pour qu’il exerce mon sacerdoce. ");
INSERT INTO francl_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Voici les vêtements qu’ils feront : un pectoral, un éphod, une robe, une tunique brodée, un turban et une ceinture. Tels sont les vêtements sacrés qu’ils feront à Aaron, ton frère, et à ses fils, afin qu’ils soient prêtres à mon service. ");
INSERT INTO francl_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Ils emploieront de l’or, de la pourpre violette, de la pourpre écarlate, du cramoisi et du fin lin. ");
INSERT INTO francl_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","Ils feront l’éphod d’or, de pourpre violette, de pourpre écarlate, de cramoisi et de lin retors, mêlés dans un habile tissu. ");
INSERT INTO francl_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Il aura deux épaulettes qui réuniront ses deux extrémités, et ainsi il sera joint. ");
INSERT INTO francl_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","La ceinture pour l’attacher en passant dessus sera du même travail et fera corps avec lui : elle sera d’or, de pourpre violette, de pourpre écarlate, de cramoisi et de lin retors. ");
INSERT INTO francl_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Tu prendras deux pierres d’onyx, et tu y graveras les noms des fils d’Israël : ");
INSERT INTO francl_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","six de leurs noms sur une pierre, et les six autres noms sur la seconde pierre, selon l’ordre de leurs naissances. ");
INSERT INTO francl_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Comme on taille les pierres précieuses et qu’on y grave des cachets, ainsi tu graveras sur les deux pierres les noms des enfants d’Israël, et tu les enchâsseras dans des chatons d’or. ");
INSERT INTO francl_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Tu placeras les deux pierres sur les épaulettes de l’éphod comme pierres de souvenir pour les enfants d’Israël, et Aaron portera leurs noms sur ses deux épaules devant Yahweh en souvenir. ");
INSERT INTO francl_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Tu feras des chatons d’or, ");
INSERT INTO francl_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","et deux chaînettes d’or pur, tressées en forme de cordons, et tu fixeras aux chatons les chaînettes en forme de cordons. ");
INSERT INTO francl_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Tu feras un pectoral du jugement, artistement travaillé ; tu le feras du même travail que l’éphod ; tu le feras d’or, de pourpre violette, de pourpre écarlate, de cramoisi et de lin retors. ");
INSERT INTO francl_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Il sera carré et double ; sa longueur sera d’un empan et sa largeur d’un empan. ");
INSERT INTO francl_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Tu y adapteras une garniture de pierreries, quatre rangées de pierreries. Première rangée : une sardoine, une topaze, une émeraude ; ");
INSERT INTO francl_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","deuxième rangée : une escarboucle, un saphir, un diamant ; ");
INSERT INTO francl_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","troisième rangée : une opale, une agate, une améthyste ; ");
INSERT INTO francl_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","quatrième rangée : une chrysolithe, un onyx, un jaspe. Ces pierres seront enchâssées dans des rosettes d’or. ");
INSERT INTO francl_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Les pierres seront selon les noms des fils d’Israël, douze selon leurs noms ; elles seront gravées comme des cachets, chacune avec son nom, pour les douze tribus. ");
INSERT INTO francl_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Tu feras pour le pectoral des chaînettes d’or pur, tressées en forme de cordons. ");
INSERT INTO francl_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Tu feras sur le pectoral deux anneaux d’or et tu mettras les deux anneaux aux deux extrémités du pectoral. ");
INSERT INTO francl_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Tu passeras les deux cordons d’or dans les deux anneaux, aux extrémités du pectoral ; ");
INSERT INTO francl_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","et tu attacheras les deux bouts des deux cordons aux deux chatons, et tu les mettras sur les épaulettes de l’éphod, par devant. ");
INSERT INTO francl_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Tu feras encore deux anneaux d’or, que tu mettras aux deux extrémités inférieures du pectoral, sur le bord intérieur appliqué contre l’éphod. ");
INSERT INTO francl_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Et tu feras deux autres anneaux d’or, que tu mettras au bas des deux épaulettes de l’éphod, sur le devant, près de son attache, au-dessus de la ceinture de l’éphod. ");
INSERT INTO francl_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","On attachera le pectoral par ses anneaux aux anneaux de l’éphod avec un ruban de pourpre violette, afin que le pectoral soit au-dessus de la ceinture de l’éphod ; et le pectoral ne pourra pas se séparer de l’éphod. ");
INSERT INTO francl_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","C’est ainsi qu’Aaron lorsqu’il entrera dans le sanctuaire, portera sur son cœur les noms des fils d’Israël gravés sur le pectoral du jugement, en souvenir perpétuel devant Yahweh. ");
INSERT INTO francl_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Tu joindras au pectoral du jugement l’Urim et le Thummin, et ils seront sur le cœur d’Aaron lorsqu’il se présentera devant Yahweh ; et ainsi Aaron portera constamment sur son cœur, devant Yahweh, le jugement des enfants d’Israël. ");
INSERT INTO francl_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Tu feras la robe de l’éphod tout entière en pourpre violette. ");
INSERT INTO francl_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Il y aura au milieu une ouverture pour la tête, et cette ouverture aura tout autour un rebord tissé, comme à l’ouverture d’une cotte d’armes, afin que la robe ne se déchire pas. ");
INSERT INTO francl_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Tu mettras au bord inférieur des grenades de pourpre violette, de pourpre écarlate et de cramoisi, sur le bord inférieur tout autour, ");
INSERT INTO francl_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","et des clochettes d’or au milieu d’elles tout autour : une clochette d’or et une grenade, une clochette d’or et une grenade sur le bord inférieur de la robe, tour autour. ");
INSERT INTO francl_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Aaron s’en revêtira pour remplir son ministère, et l’on entendra le son des clochettes quand il entrera dans le sanctuaire devant Yahweh, et quand il en sortira, et il ne mourra point. ");
INSERT INTO francl_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Tu feras une lame d’or pur, et tu y graveras, comme on grave sur un cachet : Sainteté à Yahweh. ");
INSERT INTO francl_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Tu l’attacheras avec un ruban de pourpre violette pour qu’elle soit sur la tiare ; elle sera sur le devant de la tiare. ");
INSERT INTO francl_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Elle sera sur le front d’Aaron, et Aaron portera les fautes commises dans les choses saintes que consacreront les enfants d’Israël, en toute espèce de saintes offrandes ; elle sera constamment sur son front devant Yahweh, pour qu’ils trouvent faveur devant Yahweh. ");
INSERT INTO francl_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Tu feras la tunique en lin ; tu feras une tiare de lin, et tu feras une ceinture de diverses couleurs. ");
INSERT INTO francl_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Pour les fils d’Aaron, tu feras des tuniques, tu leur feras des ceintures et tu leur feras des mitres, pour marquer leur dignité et pour leur servir de parure. ");
INSERT INTO francl_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Tu revêtiras de ces ornements, Aaron, ton frère, et ses fils avec lui. Tu les oindras, tu les installeras et tu les consacreras, afin qu’ils soient prêtres à mon service. ");
INSERT INTO francl_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Fais-leur des caleçons de lin, pour couvrir leur nudité ; ils iront depuis les reins jusqu’aux cuisses. ");
INSERT INTO francl_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Aaron et ses fils les porteront quand ils entreront dans la tente de réunion, ou quand ils s’approcheront de l’autel pour faire le service dans le sanctuaire ; ainsi ils n’encourront pas de faute et ne mourront point. C’est une loi perpétuelle pour Aaron et pour ses descendants après lui. ");
INSERT INTO francl_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Voici ce que tu feras pour les consacrer à mon service comme prêtres : Prends un jeune taureau et deux béliers sans défaut ; ");
INSERT INTO francl_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","des pains sans levain, des gâteaux sans levain pétris à l’huile, et des galettes sans levain arrosées d’huile : tu feras le tout de fleur de farine de froment. ");
INSERT INTO francl_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Tu les mettras dans une seule corbeille, et tu les présenteras dans la corbeille en même temps que tu présenteras le jeune taureau et les deux béliers. ");
INSERT INTO francl_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Tu feras avancer Aaron et ses fils à l’entrée de la tente de réunion, et tu les laveras avec de l’eau. ");
INSERT INTO francl_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Puis, ayant pris les vêtements, tu revêtiras Aaron de la tunique, de la robe de l’éphod, de l’éphod et du pectoral, et tu lui mettras la ceinture de l’éphod. ");
INSERT INTO francl_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Tu poseras la tiare sur sa tête, et tu mettras sur la tiare le diadème de sainteté. ");
INSERT INTO francl_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Tu prendras l’huile d’onction, tu en répandras sur sa tête et tu l’oindras. ");
INSERT INTO francl_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Tu feras approcher ses fils, et tu les revêtiras des tuniques. ");
INSERT INTO francl_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Tu mettras une ceinture à Aaron et à ses fils et tu attacheras des mitres aux fils d’Aaron. Le sacerdoce leur appartiendra par une loi perpétuelle, et tu installeras Aaron et ses fils. ");
INSERT INTO francl_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Tu amèneras le taureau devant la tente de réunion, et Aaron et ses fils poseront leurs mains sur la tête du taureau. ");
INSERT INTO francl_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Tu égorgeras le taureau devant Yahweh, à l’entrée de la tente de réunion ; ");
INSERT INTO francl_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","tu prendras du sang du taureau, tu en mettras avec ton doigt sur les cornes de l’autel, et tu répandras tout le sang au pied de l’autel. ");
INSERT INTO francl_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Tu prendras toute la graisse qui couvre les entrailles, le réseau du foie et les deux rognons avec la graisse qui les entoure, et tu feras fumer tout cela sur l’autel. ");
INSERT INTO francl_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Mais tu consumeras par le feu hors du camp la chair du taureau, sa peau et ses excréments : c’est un sacrifice pour le péché. ");
INSERT INTO francl_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Tu prendras l’un des béliers, et Aaron et ses fils poseront leurs mains sur la tête du bélier. ");
INSERT INTO francl_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Tu égorgeras le bélier, tu en prendras le sang et tu le répandras sur l’autel tout autour. ");
INSERT INTO francl_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Tu couperas le bélier par morceaux et, ayant lavé les entrailles et les jambes, tu les mettras sur les morceaux et sur sa tête, ");
INSERT INTO francl_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","et tu feras fumer tout le bélier sur l’autel. C’est un holocauste à Yahweh, d’agréable odeur, un sacrifice par le feu pour Yahweh. ");
INSERT INTO francl_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Tu prendras le second bélier, et Aaron et ses fils poseront leurs mains sur la tête du bélier. ");
INSERT INTO francl_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Tu égorgeras le bélier et, ayant pris de son sang, tu en mettras sur le lobe de l’oreille droite d’Aaron et sur le lobe de l’oreille droite de ses fils, sur le pouce de leur main droite et sur le gros orteil de leur pied droit, et tu répandras le sang sur l’autel tout autour. ");
INSERT INTO francl_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Tu prendras du sang qui sera sur l’autel et de l’huile d’onction, et tu en aspergeras Aaron et ses vêtements, ses fils et leurs vêtements avec lui. Et ainsi il sera consacré, lui et ses vêlements, ainsi que ses fils et les vêtements de ses fils avec lui. ");
INSERT INTO francl_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Tu prendras la graisse du bélier, la queue, la graisse qui enveloppe les entrailles, le réseau du foie, les deux rognons et la graisse qui les entoure, et l’épaule droite, car c’est un bélier d’installation. ");
INSERT INTO francl_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Tu prendras aussi, dans la corbeille des pains sans levain placée devant Yahweh, un gâteau de pain, un gâteau à l’huile et une galette. ");
INSERT INTO francl_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Tu poseras toutes ces choses sur les paumes des mains d’Aaron et sur les paumes des mains de ses fils, et tu les balanceras comme offrande balancée devant Yahweh. ");
INSERT INTO francl_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Tu les ôteras ensuite de leurs mains et tu les feras brûler sur l’autel par-dessus l’holocauste, en agréable odeur devant Yahweh : c’est un sacrifice par le feu pour Yahweh. ");
INSERT INTO francl_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Tu prendras la poitrine du bélier qui aura servi à l’installation d’Aaron, et tu la balanceras comme offrande balancée devant Yahweh : ce sera ta portion. ");
INSERT INTO francl_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Du bélier d’installation, de ce qui revient à Aaron et de ce qui revient à ses fils, tu consacreras ce qui aura été balancé et ce qui aura été élevé, savoir la poitrine balancée et l’épaule élevée : ");
INSERT INTO francl_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","ce sera pour Aaron et ses fils une redevance perpétuelle de la part des enfants d’Israël, car c’est une offrande élevée ; et les enfants d’Israël auront à prélever une offrande sur leurs sacrifices d’actions de grâces, leur offrande prélevée pour Yahweh. ");
INSERT INTO francl_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Les vêtements sacrés d’Aaron seront après lui pour ses fils, qui en seront revêtus lorsqu’on les oindra et qu’on les installera. ");
INSERT INTO francl_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Sept jours durant, celui de ses fils qui sera prêtre à sa place les portera, celui qui entrera dans la tente de réunion pour faire le service dans le sanctuaire. ");
INSERT INTO francl_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Tu prendras le bélier d’installation, et tu en feras cuire la chair dans un lieu saint. ");
INSERT INTO francl_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Aaron et ses fils mangeront, à l’entrée de la tente de réunion, la chair du bélier et le pain qui sera dans la corbeille. ");
INSERT INTO francl_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Ils mangeront ainsi ce qui aura servi à faire l’expiation pour les installer et les consacrer ; nul étranger n’en mangera, car ce sont des choses saintes. ");
INSERT INTO francl_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","S’il reste jusqu’au lendemain de la chair de l’installation et du pain, tu brûleras ce reste, et on ne le mangera pas, car c’est une chose sainte. ");
INSERT INTO francl_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Tu feras ainsi à l’égard d’Aaron et de ses fils, selon tous les ordres que je t’ai donnés. Tu les installeras pendant sept jours. ");
INSERT INTO francl_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Tu offriras chaque jour un jeune taureau en sacrifice pour le péché, pour l’expiation ; tu ôteras de l’autel le péché par cette expiation, et tu l’oindras pour le consacrer. ");
INSERT INTO francl_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Pendant sept jours, tu feras l’expiation pour l’autel et tu le consacreras ; et l’autel sera très saint, et tout ce qui touchera l’autel sera sacré. ");
INSERT INTO francl_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Voici ce que tu offriras sur l’autel : deux agneaux d’un an, chaque jour, à perpétuité. ");
INSERT INTO francl_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Tu offriras l’un de ces agneaux le matin, et tu offriras l’autre agneau entre les deux soirs. ");
INSERT INTO francl_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Avec le premier agneau, tu offriras un dixième d’épha de fleur de farine pétrie avec un quart de hin d’huile d’olive concassée, et une libation d’un quart de hin de vin. ");
INSERT INTO francl_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Tu offriras le second agneau entre les deux soirs, tu l’accompagneras d’une offrande et d’une libation semblables à celles du matin. C’est un sacrifice d’agréable odeur, un sacrifice par le feu pour Yahweh : ");
INSERT INTO francl_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","holocauste perpétuel qui doit être offert par vous d’âge en âge, à l’entrée de la tente de réunion, devant Yahweh, là où je me rencontrerai avec vous, pour t’y parler. ");
INSERT INTO francl_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Je me rencontrerai là avec les enfants d’Israël, et ce lieu sera consacré par ma gloire. ");
INSERT INTO francl_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Je consacrerai la tente de réunion et l’autel, et je consacrerai Aaron et ses fils, pour qu’ils soient prêtres à mon service. ");
INSERT INTO francl_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","J’habiterai au milieu des enfants d’Israël, et je serai leur Dieu. ");
INSERT INTO francl_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Ils connaîtront que moi, Yahweh, je suis leur Dieu, qui les ai fait sortir du pays d’Égypte, pour habiter au milieu d’eux, moi Yahweh, leur Dieu. ");
INSERT INTO francl_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Tu feras un autel pour faire fumer l’encens, tu le feras de bois d’acacia ; ");
INSERT INTO francl_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","sa longueur sera d’une coudée, et sa largeur d’une coudée ; il sera carré, et sa hauteur sera de deux coudées ; ses cornes feront corps avec lui. ");
INSERT INTO francl_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Tu le revêtiras d’or pur, le dessus, les côtés tout autour et les cornes, et tu y feras une guirlande d’or tout autour. ");
INSERT INTO francl_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Tu feras pour lui deux anneaux d’or, au-dessous de la guirlande, sur ses deux arêtes : tu les feras aux deux côtés, pour recevoir les barres qui serviront à le porter. ");
INSERT INTO francl_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Tu feras les barres de bois d’acacia, et tu les revêtiras d’or. ");
INSERT INTO francl_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Tu placeras l’autel en face du voile qui est devant l’arche du témoignage, en face du propitiatoire qui est sur le témoignage, là où je me rencontrerai avec toi. ");
INSERT INTO francl_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Aaron y fera fumer l’encens ; il le fera fumer chaque matin, lorsqu’il préparera les lampes, ");
INSERT INTO francl_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","et il le fera fumer entre les deux soirs, lorsqu’Aaron mettra les lampes sur le chandelier. Encens perpétuel devant Yahweh, parmi vos descendants. ");
INSERT INTO francl_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Vous n’offrirez sur l’autel ni parfum profane, ni holocauste, ni offrande, et vous n’y répandrez pas de libation. ");
INSERT INTO francl_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Aaron fera l’expiation sur les cornes de l’autel une fois chaque année ; avec le sang de la victime expiatoire, il y fera l’expiation une fois l’an parmi vos descendants. Cet autel sera très saint à Yahweh. » ");
INSERT INTO francl_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","« Quand tu compteras les enfants d’Israël pour en faire le recensement, ils donneront chacun à Yahweh une rançon pour leur âme, lorsqu’on les recensera, afin qu’ils ne soient frappés d’aucun fléau lors de leur recensement. ");
INSERT INTO francl_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Voici ce que donneront tous ceux qui seront compris dans le dénombrement : un demi-sicle, selon le sicle du sanctuaire, qui est de vingt guéras ; un demi-sicle sera le don levé pour Yahweh. ");
INSERT INTO francl_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Tout homme compris dans le dénombrement, depuis l’âge de vingt ans et au-dessus, acquittera la contribution de Yahweh. ");
INSERT INTO francl_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Le riche ne paiera pas plus, et le pauvre ne paiera pas moins d’un demi-sicle, pour acquitter la contribution de Yahweh, comme rançon de vos âmes. ");
INSERT INTO francl_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Tu recevras des enfants d’Israël l’argent de la rançon, et tu l’appliqueras au service de la tente de réunion ; il sera pour les enfants d’Israël un titre devant Yahweh pour la rançon de leurs âmes. » ");
INSERT INTO francl_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Yahweh parla à Moïse en disant : ");
INSERT INTO francl_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","« Tu feras une cuve d’airain, avec sa base d’airain, pour les ablutions ; tu la placeras entre la tente de réunion et l’autel, et tu y mettras de l’eau, ");
INSERT INTO francl_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","et Aaron et ses fils en prendront pour se laver les mains et les pieds. ");
INSERT INTO francl_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Ils se laveront avec cette eau, afin qu’ils ne meurent point, et lorsqu’ils entreront dans la tente de réunion, et lorsqu’ils s’approcheront de l’autel pour faire le service, pour faire fumer un sacrifice à Yahweh. ");
INSERT INTO francl_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Ils se laveront les pieds et les mains, et ils ne mourront pas. Ce sera une loi perpétuelle pour eux, pour Aaron et sa postérité d’âge en âge. » ");
INSERT INTO francl_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","« Prends, parmi les meilleurs aromates, cinq cents sicles de myrrhe vierge, la moitié, soit deux cent cinquante sicles, de cinname aromatique, deux cent cinquante sicles de canne odorante, ");
INSERT INTO francl_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","cinq cents sicles de casse, selon le sicle du sanctuaire, et un hin d’huile d’olive. ");
INSERT INTO francl_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Tu en feras une huile pour l’onction sainte, un parfum composé selon l’art du parfumeur : ce sera l’huile pour l’onction sainte. ");
INSERT INTO francl_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Tu en oindras la tente de réunion et l’arche du témoignage, ");
INSERT INTO francl_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","la table et tous ses ustensiles, le chandelier et ses ustensiles, l’autel des parfums, ");
INSERT INTO francl_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","l’autel des holocaustes et tous ses ustensiles, et la cuve avec sa base. ");
INSERT INTO francl_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Tu les consacreras, et ils seront très saints ; tout ce qui les touchera sera saint. ");
INSERT INTO francl_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Tu oindras Aaron et ses fils, et tu les consacreras, pour qu’ils me servent comme prêtres. ");
INSERT INTO francl_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Tu parleras aux enfants d’Israël, en disant : Ce sera l’huile d’onction sainte, pour moi d’âge en âge. ");
INSERT INTO francl_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","On n’en répandra pas sur le corps d’un homme, et vous n’en ferez pas une semblable, de même composition ; c’est une chose sacrée, et vous la regarderez comme chose sacrée. ");
INSERT INTO francl_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Quiconque en composera de semblable, ou en mettra sur un étranger, sera retranché de son peuple. » ");
INSERT INTO francl_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Yahweh dit à Moïse : « Prends des aromates : résine, ongle odorant, galbanum ; des aromates et de l’encens pur ; ils seront en parties égales. ");
INSERT INTO francl_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Tu en feras un parfum pour l’encensement, composé selon l’art du parfumeur ; il sera salé, pur et saint. ");
INSERT INTO francl_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Tu le réduiras en poudre, et tu en mettras devant le témoignage, dans la tente de réunion, où je me rencontrerai avec toi. Ce sera pour vous une chose très sainte. ");
INSERT INTO francl_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Le parfum que tu feras, vous n’en ferez pas pour vous de même composition ; tu le regarderas comme une chose sacrée pour Yahweh. ");
INSERT INTO francl_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Quiconque en fera de semblable, pour en respirer l’odeur, sera retranché de son peuple, » ");
INSERT INTO francl_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Yahweh parla à Moïse en disant : ");
INSERT INTO francl_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","« Sache que j’ai appelé par son nom Béséléel, fils d’Uri, fils de Hur, de la tribu de Juda. ");
INSERT INTO francl_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Je l’ai rempli de l’esprit de Dieu, de sagesse, d’intelligence et de savoir pour toutes sortes d’ouvrages : ");
INSERT INTO francl_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","pour faire des inventions, pour travailler l’or, l’argent et l’airain, ");
INSERT INTO francl_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","pour graver les pierres à enchâsser, pour tailler le bois et exécuter toutes sortes d’ouvrages. ");
INSERT INTO francl_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Et voici, je lui ai adjoint Ooliab, fils d’Achisamech, de la tribu de Dan, et j’ai mis la sagesse dans le cœur de tout homme habile, pour qu’ils exécutent tout ce que je t’ai ordonné : ");
INSERT INTO francl_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","la tente de réunion, l’arche du témoignage, le propitiatoire, qui est dessus, et tous les meubles de la tente ; ");
INSERT INTO francl_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","la table et ses ustensiles, le chandelier d’or pur et tous ses ustensiles, l’autel des parfums, ");
INSERT INTO francl_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","l’autel des holocaustes et tous ses ustensiles, la cuve avec sa base ; ");
INSERT INTO francl_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","les vêtements de cérémonie, les vêtements sacrés pour le prêtre Aaron, les vêtements de ses fils pour les fonctions du sacerdoce ; ");
INSERT INTO francl_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","l’huile d’onction et le parfum à brûler pour le sanctuaire. Ils exécuteront tous les ordres que je t’ai donnés. » ");
INSERT INTO francl_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","« Parle aux enfants d’Israël et dis-leur : Ne manquez pas d’observer mes sabbats ; car c’est entre moi et vous un signe pour toutes vos générations, pour que vous sachiez que c’est moi, Yahweh, qui vous sanctifie. ");
INSERT INTO francl_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Vous observerez le sabbat, car c’est pour vous une chose sainte. Celui qui le profanera sera puni de mort ; celui qui fera quelque ouvrage ce jour-là sera retranché du milieu de son peuple. ");
INSERT INTO francl_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","On travaillera six jours ; mais le septième jour sera un jour de repos complet, consacré à Yahweh. Quiconque fera un travail le jour du sabbat sera puni de mort. ");
INSERT INTO francl_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Les enfants d’Israël observeront le sabbat et le célébreront, eux et leurs descendants, comme une alliance perpétuelle. ");
INSERT INTO francl_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Ce sera, entre moi et les enfants d’Israël, un signe à perpétuité ; car en six jours Yahweh a fait le ciel et la terre, et le septième jour il a cessé son œuvre et il s’est reposé. » ");
INSERT INTO francl_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Lorsque Yahweh eut achevé de parler à Moïse sur la montagne de Sinaï, il lui donna les deux tables du témoignage, tables de pierre, écrites du doigt de Dieu. ");
INSERT INTO francl_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Le peuple, voyant que Moïse tardait à descendre de la montagne, s’assembla autour d’Aaron et lui dit : « Allons, fais-nous un dieu qui marche devant nous. Car pour ce Moïse, l’homme qui nous a fait monter du pays d’Égypte, nous ne savons ce qu’il en est devenu. » ");
INSERT INTO francl_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Aaron leur dit : « Otez les anneaux d’or qui sont aux oreilles de vos femmes, de vos fils et de vos filles, et apportez-les-moi. » ");
INSERT INTO francl_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Tout le monde ôta les anneaux d’or qu’ils avaient aux oreilles, et ils les apportèrent à Aaron. ");
INSERT INTO francl_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Il les reçut de leurs mains, façonna l’or au burin, et en fit un veau en fonte. Et ils dirent : « Israël, voici ton Dieu, qui t’a fait monter du pays d’Égypte. » ");
INSERT INTO francl_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Ayant vu cela, Aaron construisit un autel devant l’image, et il s’écria : « Demain il y aura fête en l’honneur de Yahweh. » ");
INSERT INTO francl_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Le lendemain, s’étant levés de bon matin, ils offrirent des holocaustes et présentèrent des sacrifices pacifiques ; et le peuple s’assit pour manger et pour boire, puis ils se levèrent pour se divertir. ");
INSERT INTO francl_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Yahweh dit à Moïse  : « Va, descends ; car ton peuple que tu as fait monter du pays d’Égypte, s’est conduit très mal. ");
INSERT INTO francl_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Ils se sont bien vite détournés de la voie que je leur avais prescrite ; ils se sont fait un veau en fonte, ils se sont prosternés devant lui, et ils lui ont offert des sacrifices, et ils ont dit : Israël, voici ton Dieu, qui t’a fait monter du pays d’Égypte. » ");
INSERT INTO francl_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Yahweh dit à Moïse : « Je vois que ce peuple est un peuple au cou raide. ");
INSERT INTO francl_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Maintenant laisse-moi : que ma colère s’embrase contre eux et que je les consume ! Mais je ferai de toi une grande nation. » ");
INSERT INTO francl_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Moïse implora Yahweh, son Dieu, et dit : « Pourquoi, Yahweh, votre colère s’embraserait-elle contre votre peuple, que vous avez fait sortir du pays d’Égypte par une grande puissance et par une main forte ? ");
INSERT INTO francl_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Pourquoi les Égyptiens diraient-ils : C’est pour leur malheur qu’il les a fait sortir, c’est pour les faire périr dans les montagnes et pour les anéantir de dessus la terre ? Revenez de l’ardeur de votre colère, et repentez-vous du mal que vous voulez faire à votre peuple. ");
INSERT INTO francl_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Souvenez-vous d’Abraham, d’Isaac et d’Israël, vos serviteurs, auxquels vous avez dit, en jurant par vous-même : Je multiplierai votre postérité comme les étoiles du ciel, et tout ce pays dont j’ai parlé, je le donnerai à vos descendants, et ils le posséderont à jamais. » ");
INSERT INTO francl_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Et Yahweh se repentit du mal qu’il avait parlé de faire à son peuple. ");
INSERT INTO francl_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Moïse revint et descendit de la montagne, ayant dans sa main les deux tables du témoignage, tables écrites sur leurs deux côtés ; elles étaient écrites sur l’une et l’autre face. ");
INSERT INTO francl_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Les tables étaient l’ouvrage de Dieu, et l’écriture était l’écriture de Dieu, gravée sur les tables. ");
INSERT INTO francl_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Josué entendit le bruit que faisait le peuple en poussant des cris, et il dit à Moïse : Il y a un cri de bataille dans le camp ! » ");
INSERT INTO francl_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Moïse répondit : « Ce n’est ni un bruit de cris de victoire, ni un bruit de cris de défaite ; j’entends la voix de gens qui chantent. » ");
INSERT INTO francl_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Lorsqu’il fut près du camp, il vit le veau et les danses. Et la colère de Moïse s’enflamma ; il jeta de ses mains les tables et les brisa au pied de la Montagne. ");
INSERT INTO francl_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Et, prenant le veau qu’ils avaient fait, il le brûla au feu, le broya jusqu’à le réduire en poudre, répandit cette poudre sur l’eau, et en fit boire aux enfants d’Israël. ");
INSERT INTO francl_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Moïse dit à Aaron : « Que t’a fait ce peuple pour que tu aies amené sur lui un si grand péché ? » ");
INSERT INTO francl_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Aaron répondit : « Que la colère de mon seigneur ne s’enflamme pas ! Tu sais toi-même que ce peuple est porté au mal. ");
INSERT INTO francl_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Ils m’ont dit : Fais-nous un dieu qui marche devant nous ; car pour ce Moïse, cet homme qui nous a fait monter du pays d’Égypte, nous ne savons ce qu’il en est devenu. ");
INSERT INTO francl_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Je leur ai dit : Que ceux qui ont de l’or s’en dépouillent ! Ils m’en ont donné, je l’ai jeté au feu, et il en est sorti ce veau. » ");
INSERT INTO francl_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Moïse vit que le peuple n’avait plus de frein, parce qu’Aaron lui avait ôté tout frein, l’exposant à devenir une risée parmi ses ennemis. ");
INSERT INTO francl_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Et Moïse se plaça à la porte du camp, et il dit : « A moi ceux qui sont pour Yahweh ! » Et tous les enfants de Lévi se rassemblèrent auprès de lui. ");
INSERT INTO francl_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Il leur dit : « Ainsi parle Yahweh, le Dieu d’Israël : Que chacun de vous mette son épée à son côté ; passez et repassez dans le camp d’une porte à l’autre, et que chacun tue son frère, chacun son ami, chacun son parent ! » ");
INSERT INTO francl_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Les enfants de Lévi firent ce qu’ordonnait Moïse, et il périt ce jour-là environ trois mille hommes du peuple. ");
INSERT INTO francl_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Moïse dit : « Consacrez-vous aujourd’hui à Yahweh, puisque chacun de vous a été contre son fils et son père, afin qu’il vous donne aujourd’hui une bénédiction. » ");
INSERT INTO francl_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Le lendemain, Moïse dit au peuple : « Vous avez commis un grand péché. Et maintenant je vais monter vers Yahweh : peut-être obtiendrai-je le pardon de votre péché. » ");
INSERT INTO francl_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Moïse retourna vers Yahweh et dit : « Ah ! ce peuple a commis un grand péché ! Ils se sont fait un dieu d’or. ");
INSERT INTO francl_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Pardonnez maintenant leur péché ; sinon effacez-moi de votre livre que vous avez écrit. » ");
INSERT INTO francl_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Yahweh dit à Moïse : « C’est celui qui a péché contre moi que j’effacerai de mon livre. ");
INSERT INTO francl_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Va maintenant, conduis le peuple où je t’ai dit. Voici, mon ange marchera devant toi, mais, au jour de ma visite, je les punirai de leur péché. » ");
INSERT INTO francl_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","C’est ainsi que Yahweh frappa le peuple, parce qu’ils avaient fait le veau qu’Aaron avait fait. ");
INSERT INTO francl_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Yahweh dit à Moïse : « Va, pars d’ici, toi et le peuple que tu as fait monter du pays d’Égypte ; monte au pays que j’ai promis avec serment à Abraham, à Isaac et à Jacob, en disant : Je le donnerai à ta postérité. ");
INSERT INTO francl_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","J’enverrai devant toi un ange, et je chasserai le Chananéen, l’Amorrhéen, le Hittite, le Phérézéen, le Hévéen et le Jébuséen. ");
INSERT INTO francl_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Monte vers un pays où coulent le lait et le miel ; mais je ne monterai pas au milieu de toi, car tu es un peuple au cou raide, pour ne pas t’anéantir en chemin. » ");
INSERT INTO francl_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","En entendant ces dures paroles, le peuple prit le deuil, et personne ne mit ses ornements. ");
INSERT INTO francl_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Alors Yahweh dit à Moïse : « Dis aux enfants d’Israël : Vous êtes un peuple au cou raide ; si je montais un seul instant au milieu de toi, je t’anéantirais. Et maintenant, enlève tes ornements de dessus toi, et je saurai ce que j’ai à te faire. » ");
INSERT INTO francl_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Les enfants d’Israël se dépouillèrent de leurs ornements, dès le mont Horeb. ");
INSERT INTO francl_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Moïse prit la tente et se la dressa hors du camp, à quelque distance ; il l’appela tente de réunion ; et quiconque cherchait Yahweh, se rendait à la tente de réunion, qui était hors du camp. ");
INSERT INTO francl_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Et lorsque Moïse se rendait à la tente, tout le peuple se levait, chacun se tenant à l’entrée de la tente, et on suivait des yeux Moïse, jusqu’à ce qu’il entrât dans la tente. ");
INSERT INTO francl_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Dès que Moïse était entré dans la tente, la colonne de nuée descendait et se tenait à l’entrée de la tente, et Yahweh parlait avec Moïse. ");
INSERT INTO francl_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Tout le peuple voyait la colonne de nuée qui se tenait à l’entrée de la tente ; et tout le peuple se levait, et chacun se prosternait à l’entrée de sa tente. ");
INSERT INTO francl_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Et Yahweh parlait à Moïse face à face, comme un homme parle à son ami. Moïse retournait ensuite au camp ; mais son serviteur Josué, fils de Nun, jeune homme, ne s’éloignait pas du milieu de la tente. ");
INSERT INTO francl_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Moïse dit à Yahweh : « Vous me dites : Fais monter ce peuple ; et vous ne me faites pas connaître celui que vous enverrez avec moi. Cependant vous avez dit : Je te connais par ton nom, et tu as trouvé grâce à mes yeux. ");
INSERT INTO francl_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Et maintenant, si j’ai bien trouvé grâce à vos yeux, fais-moi donc connaître tes voies, et que je te connaisse, afin que je trouve grâce à tes yeux. Considère que cette nation est ton peuple. » ");
INSERT INTO francl_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Yahweh répondit : « Ma face ira avec toi, et je te donnerai un repos. » ");
INSERT INTO francl_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Moïse dit : « Si votre face ne vient pas, ne nous faites pas partir d’ici. ");
INSERT INTO francl_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","A quoi connaîtra-t-on que j’ai trouvé grâce à vos yeux, moi et votre peuple, sinon à ce que vous marcherez avec nous ? C’est ce qui nous distinguera, moi et votre peuple, de tous les peuples qui sont sur la face de la terre. » ");
INSERT INTO francl_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Yahweh dit à Moïse : « Je ferai encore ce que tu demandes, car tu as trouvé grâce à mes yeux et je te connais par ton nom. » ");
INSERT INTO francl_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Moïse dit : « Faites-moi voir ta gloire. » ");
INSERT INTO francl_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Yahweh répondit : « Je ferai passer devant toi toute ma bonté, et je prononcerai devant toi le nom de Yahweh : car je fais grâce à qui je fais grâce, et miséricorde à qui je fais miséricorde. » ");
INSERT INTO francl_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Yahweh dit : « Tu ne pourras voir ma face, car l’homme ne peut me voir et vivre. » ");
INSERT INTO francl_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Yahweh dit : « Voici une place près de moi ; tu te tiendras sur le rocher. ");
INSERT INTO francl_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Quand ma gloire passera, je te mettrai dans le creux du rocher, et je te couvrirai de ma main jusqu’à ce que j’aie passé. ");
INSERT INTO francl_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Alors je retirerai ma main et tu me verras par derrière ; mais ma face ne saurait être vue. » ");
INSERT INTO francl_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Yahweh dit à Moïse : « Taille deux tables de pierre comme les premières, et j’y écrirai les paroles qui étaient sur les premières tables que tu as brisées : ");
INSERT INTO francl_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Sois prêt pour demain, et tu monteras dès le matin sur la montagne de Sinaï ; tu te tiendras là devant moi, au sommet de la montagne. ");
INSERT INTO francl_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Que personne ne monte avec toi, et que personne ne se montre nulle part sur la montagne, et même que ni brebis ni bœufs ne paissent du côté de cette montagne. » ");
INSERT INTO francl_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Moïse tailla donc deux tables de pierre comme les premières ; et, s’étant levé de bonne heure, il monta sur la montagne de Sinaï, selon que Yahweh le lui avait ordonné ; et il prit dans sa main les deux tables de pierre. ");
INSERT INTO francl_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Yahweh descendit dans la nuée, se tint là avec lui et prononça le nom de Yahweh. ");
INSERT INTO francl_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Et Yahweh passa devant lui et s’écria : « Yahweh ! Yahweh ! Dieu miséricordieux et compatissant, lent à la colère, riche en bonté et en fidélité, ");
INSERT INTO francl_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","qui conserve sa grâce jusqu’à mille générations, qui pardonne l’iniquité, la révolte et le péché ; mais il ne les laisse pas impunis, visitant l’iniquité des pères sur les enfants et sur les enfants des enfants jusqu’à la troisième et à la quatrième génération ! » ");
INSERT INTO francl_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Aussitôt Moïse s’inclina vers la terre et se prosterna, ");
INSERT INTO francl_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","en disant : « Si j’ai trouvé grâce à vos yeux, Seigneur, daigne le Seigneur marcher au milieu de nous, car c’est un peuple au cou raide ; pardonnez nos iniquités et nos péchés, et prenez-nous pour votre héritage. » ");
INSERT INTO francl_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Yahweh dit : « Voici que je fais une alliance : en présence de tout ton peuple, je ferai des prodiges qui n’ont eu lieu dans aucun pays et chez aucune nation ; et tout le peuple qui t’environne verra l’œuvre de Yahweh, car terribles sont les choses que j’accomplirai avec toi. ");
INSERT INTO francl_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Prends garde à ce que je t’ordonne aujourd’hui. Voici, je chasserai devant toi l’Amorrhéen, le Cananéen, le Hittite, le Phérézéen, le Hévéen, et le Jébuséen. ");
INSERT INTO francl_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Garde-toi de contracter alliance avec les habitants du pays contre lequel tu marches, de peur qu’ils ne soient un piège au milieu de toi. ");
INSERT INTO francl_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Mais vous renverserez leurs autels, vous briserez leurs stèles et vous abattrez leurs Aschérim. ");
INSERT INTO francl_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Tu n’adoreras aucun autre dieu ; car Yahweh se nomme le jaloux, il est un Dieu jaloux. ");
INSERT INTO francl_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Ne contracte donc pas alliance avec les habitants du pays, de peur que, lorsqu’ils se prostituent à leurs dieux et leur offrent des sacrifices, ils ne t’invitent et que tu ne manges de leurs victimes ; ");
INSERT INTO francl_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","de peur que tu ne prennes de leurs filles pour tes fils, et que leurs filles, se prostituant à leurs dieux, n’entraînent tes fils à se prostituer aussi à leurs dieux. ");
INSERT INTO francl_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Tu ne feras pas de dieux de métal fondu. ");
INSERT INTO francl_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Tu observeras la fête des Azymes : pendant sept jours tu mangeras des pains sans levain, comme je te l’ai prescrit, au temps fixé du mois d’abib, car c’est dans le mois d’abib que tu es sorti d’Égypte. ");
INSERT INTO francl_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Tout premier-né m’appartient ; de même, tout premier-né mâle de tes troupeaux, soit bœuf, soit brebis. ");
INSERT INTO francl_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Tu rachèteras avec un agneau le premier-né de l’âne ; et, si tu ne le rachètes pas, tu lui briseras la nuque. Tu rachèteras tout premier-né de tes fils ; et l’on ne se présentera pas les mains vides devant ma face. ");
INSERT INTO francl_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Tu travailleras six jours, mais tu te reposeras le septième jour, même au temps du labourage et de la moisson. ");
INSERT INTO francl_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Tu célébreras la fête des Semaines, des premiers produits de la moisson du froment, et la fête de la récolte à la fin de l’année. ");
INSERT INTO francl_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Trois fois par an, tous les mâles se présenteront devant le Seigneur, Yahweh, Dieu Israël. ");
INSERT INTO francl_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Car je chasserai les nations devant toi et j’étendrai tes frontières ; et personne ne convoitera ton pays pendant que tu monteras pour te présenter devant Yahweh, ton Dieu, trois fois par an. ");
INSERT INTO francl_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Tu n’offriras pas avec du pain levé le sang de ma victime, et le sacrifice de la fête de Pâque ne sera pas gardé pendant la nuit jusqu’au matin. ");
INSERT INTO francl_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Tu apporteras les prémices des premiers fruits de ton sol à la maison de Yahweh, ton Dieu. Tu ne feras pas cuire un chevreau dans le lait de sa mère. » ");
INSERT INTO francl_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Yahweh dit à Moïse : « Ecris, toi, ces paroles ; car c’est d’après ces paroles que je fais alliance avec toi et avec Israël. » ");
INSERT INTO francl_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Moïse fut là avec Yahweh quarante jours et quarante nuits, sans manger de pain et sans boire d’eau. Et Yahweh écrivit sur les tables les paroles de l’alliance, les dix paroles. ");
INSERT INTO francl_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Moïse descendit de la montagne de Sinaï ; Moïse avait dans sa main les deux tables du témoignage, en descendant de la montagne ; et Moïse ne savait pas que la peau de son visage était devenue rayonnante pendant qu’il parlait avec Yahweh. ");
INSERT INTO francl_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Aaron et tous les enfants d’Israël virent Moïse, et voici, la peau de son visage rayonnait ; et ils craignirent de s’approcher de lui. ");
INSERT INTO francl_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Moïse les appela, et Aaron et tous les princes de l’assemblée vinrent auprès de lui, et il leur parla. ");
INSERT INTO francl_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Ensuite tous les enfants d’Israël s’approchèrent, et il leur donna tous les ordres qu’il avait reçus de Yahweh sur la montagne de Sinaï. ");
INSERT INTO francl_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Lorsque Moïse eut achevé de leur parler, il mit un voile sur son visage. ");
INSERT INTO francl_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Quand Moïse entrait devant Yahweh pour parler avec lui, il ôtait le voile, jusqu’à ce qu’il sortit ; puis il sortait et disait aux enfants d’Israël ce qui lui avait été ordonné. ");
INSERT INTO francl_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Les enfants d’Israël voyaient le visage de Moïse, ils voyaient que la peau du visage de Moïse était rayonnante ; et Moïse remettait le voile sur son visage, jusqu’à ce qu’il entrât pour parler avec Yahweh. ");
INSERT INTO francl_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Moïse ayant convoqué toute l’assemblée d’Israël, leur dit : « Voici les choses que Yahweh a ordonné de faire : ");
INSERT INTO francl_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Tu travailleras six jours, mais le septième sera pour vous un jour consacré ; un jour de repos complet en l’honneur de Yahweh. Quiconque fera un travail ce jour-là sera puni de mort. ");
INSERT INTO francl_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Vous n’allumerez de feu dans aucune de vos demeures le jour du sabbat. » ");
INSERT INTO francl_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Moïse parla à toute l’assemblée des enfants d’Israël, en disant : « Voici ce que Yahweh a ordonné : ");
INSERT INTO francl_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Prélevez sur vos biens une offrande pour Yahweh. Tout homme au cœur bien disposé apportera en offrande à Yahweh de l’or, de l’argent et de l’airain, ");
INSERT INTO francl_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","de la pourpre violette, de la pourpre écarlate, du cramoisi, du fin lin et du poil de chèvre, ");
INSERT INTO francl_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","des peaux de béliers teintes en rouge et des peaux de veaux marins, et du bois d’acacia, ");
INSERT INTO francl_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","de l’huile pour le chandelier, des aromates pour l’huile d’onction et pour le parfum d’encensement, ");
INSERT INTO francl_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","des pierres d’onyx et d’autres pierres à enchâsser pour l’éphod et pour le pectoral. ");
INSERT INTO francl_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Que tous ceux d’entre vous qui ont de l’habileté viennent et exécutent tout ce que Yahweh a ordonné : ");
INSERT INTO francl_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","la Demeure, sa tente et sa couverture, ses anneaux, ses ais, ses traverses, ses colonnes et ses socles ; ");
INSERT INTO francl_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","l’arche et ses barres ; le propitiatoire et le voile de séparation ; ");
INSERT INTO francl_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","la table avec ses barres et tous ses ustensiles, et les pains de proposition ; ");
INSERT INTO francl_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","le chandelier avec ses ustensiles, ses lampes et l’huile pour le chandelier ; ");
INSERT INTO francl_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","l’autel des parfums et ses barres ; l’huile d’onction et le parfum pour l’encensement : la tenture de la porte pour l’entrée de la Demeure ; ");
INSERT INTO francl_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","l’autel des holocaustes, sa grille d’airain, ses barres et tous ses ustensiles ; la cuve avec sa base ; ");
INSERT INTO francl_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","les rideaux du parvis, ses colonnes, ses socles et la tenture de la porte du parvis ; ");
INSERT INTO francl_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","les pieux de la Demeure, les pieux du parvis avec leurs cordages ; ");
INSERT INTO francl_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","les vêtements de cérémonie pour le service dans le sanctuaire, les vêtements sacrés pour le grand prêtre Aaron, et les vêtements de ses fils pour les fonctions du sacerdoce. » ");
INSERT INTO francl_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Toute l’assemblée des enfants d’Israël étant sortie de devant Moïse, ");
INSERT INTO francl_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","tous ceux que leur cœur y portait et tous ceux dont l’esprit était bien disposé vinrent et apportèrent une offrande à Yahweh pour la construction de la tente de réunion, pour tout son service et pour les vêtements sacrés. ");
INSERT INTO francl_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Les hommes vinrent aussi bien que les femmes ; tous ceux dont le cœur était bien disposé apportèrent des boucles, des anneaux, des bagues, des bracelets, toutes sortes d’objets d’or ; chacun présenta l’offrande d’or qu’il avait destinée à Yahweh. ");
INSERT INTO francl_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Tous ceux qui avaient chez eux de la pourpre violette, de la pourpre écarlate et du cramoisi, du fin lin et du poil de chèvre, des peaux de béliers teintes en rouge et des peaux de veaux marins, les apportèrent. ");
INSERT INTO francl_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Tous ceux qui avaient prélevé une offrande d’argent et d’airain, apportèrent l’offrande à Yahweh. Tous ceux qui avaient chez eux du bois d’acacia pour tous les ouvrages destinés au culte, l’apportèrent. ");
INSERT INTO francl_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Toutes les femmes qui avaient de l’habileté, filèrent de leurs mains, et elles apportèrent leur ouvrage : de la pourpre violette, de la pourpre écarlate, du cramoisi et du fin lin. ");
INSERT INTO francl_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Toutes les femmes que leur cœur y portait, et qui avaient de l’habileté, filèrent du poil de chèvre. ");
INSERT INTO francl_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Les principaux du peuple apportèrent des pierres d’onyx et d’autres pierres à enchâsser pour l’éphod et le pectoral ; ");
INSERT INTO francl_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","des aromates et de l’huile pour le chandelier, pour l’huile d’onction et pour le parfum odoriférant. ");
INSERT INTO francl_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Tous les enfants d’Israël, hommes et femmes, qui étaient disposés de cœur à contribuer à tout ouvrage que Yahweh avait commandé de faire par l’organe de Moïse, apportèrent à Yahweh des offrandes volontaires. ");
INSERT INTO francl_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Moïse dit aux enfants d’Israël : « Sachez que Yahweh a choisi Béseléel, fils d’Uri, fils de Hur, de la tribu de Juda. ");
INSERT INTO francl_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Il l’a rempli de l’esprit de Dieu, de sagesse, d’intelligence et de savoir pour toutes sortes d’ouvrages, ");
INSERT INTO francl_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","pour faire des inventions, pour travailler l’or, l’argent et l’airain, ");
INSERT INTO francl_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","pour graver les pierres à enchâsser, pour tailler le bois et exécuter toutes sortes d’ouvrages d’art. ");
INSERT INTO francl_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Il a mis aussi dans son cœur le don d’enseignement, de même qu’en Ooliab, fils d’Achisamech, de la tribu de Dan. ");
INSERT INTO francl_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Il les a remplis d’intelligence pour exécuter tous les ouvrages de sculpture et d’art, pour tisser d’un dessin varié la pourpre violette, la pourpre écarlate, le cramoisi et le fin lin, pour exécuter toute espèce de travaux et pour faire des inventions. ");
INSERT INTO francl_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Béseléel, Ooliab et tous les hommes intelligents en qui Yahweh a mis de l’intelligence et de l’habileté pour savoir faire tous les ouvrages destinés au service du sanctuaire, les exécuteront selon tout ce que Yahweh a commandé. » ");
INSERT INTO francl_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Moïse appela Béseléel, Ooliab et tous les hommes intelligents dans le cœur desquels Yahweh avait mis de l’intelligence, tous ceux que leur cœur poussait à s’appliquer à cette œuvre pour l’exécuter. ");
INSERT INTO francl_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Ils prirent de devant Moïse toute l’offrande qu’avaient apportée les enfants d’Israël pour exécuter les ouvrages destinés au service du sanctuaire ; et chaque matin le peuple continuait à apporter à Moïse des offrandes volontaires. ");
INSERT INTO francl_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Alors tous les hommes habiles qui exécutaient tous les ouvrages du sanctuaire, quittant chacun l’ouvrage qu’ils faisaient, ");
INSERT INTO francl_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","vinrent dire à Moïse : « Le peuple apporte beaucoup plus qu’il ne faut pour l’exécution des ouvrages que Yahweh a ordonné de faire. » ");
INSERT INTO francl_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Moïse donna un ordre et on fit cette proclamation dans le camp : « Que personne, homme ou femme, ne s’occupe plus de l’offrande pour le sanctuaire ». Et on empêcha le peuple d’en apporter davantage. ");
INSERT INTO francl_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Les objets préparés suffisaient, et au delà, pour tous les ouvrages à exécuter. ");
INSERT INTO francl_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Tous les hommes habiles parmi ceux qui travaillaient à l’œuvre firent la Demeure de dix tentures ; ils les firent de lin retors, de pourpre violette, de pourpre écarlate et de cramoisi, avec des chérubins, ouvrage d’habile tisseur. ");
INSERT INTO francl_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","La longueur d’une tenture était de vingt-huit coudées, et la largeur d’une tenture était de quatre coudées ; la dimension était la même pour toutes les tentures. ");
INSERT INTO francl_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Cinq de ces tentures furent jointes ensemble ; les cinq autres furent aussi jointes ensemble. ");
INSERT INTO francl_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","On mit des lacets de pourpre violette au bord de la tenture terminant le premier assemblage ; on fit de même au bord de la tenture terminant le second assemblage. ");
INSERT INTO francl_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","On fit cinquante lacets à la première tenture, et on fit cinquante lacets au bord de la tenture terminant le second assemblage, et ces lacets se correspondaient les uns aux autres. ");
INSERT INTO francl_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","On fit cinquante agrafes d’or, avec lesquelles on joignit les tentures l’une à l’autre, en sorte que la Demeure forma un seul tout. ");
INSERT INTO francl_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","On fit des tentures de poil de chèvre pour former une tente sur la Demeure ; on fit onze de ces tentures. ");
INSERT INTO francl_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","La longueur d’une tenture était de trente coudées, et la largeur d’une tenture de quatre coudées ; La dimension était la même pour les onze tentures. ");
INSERT INTO francl_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","On joignit à part cinq de ces tentures et les six autres à part. ");
INSERT INTO francl_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","On mit cinquante lacets au bord de la tenture terminant un assemblage, et on mit cinquante lacets au bord de la tenture du second assemblage. ");
INSERT INTO francl_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","On fit cinquante agrafes d’airain pour assembler la tente, afin qu’elle format un seul tout. ");
INSERT INTO francl_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","On fit pour la tente une couverture en peaux de béliers teintes en rouge, et une couverture en peaux de veaux marins, par dessus. ");
INSERT INTO francl_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","On fit aussi les planches pour la Demeure, des planches de bois d’acacia, posées debout. ");
INSERT INTO francl_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","La longueur d’une planche était de dix coudées, et la largeur d’une planche était d’une coudée et demie. ");
INSERT INTO francl_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Il y avait à chaque planche deux tenons, joints l’un à l’autre : on fit de même pour toutes les planches de la Demeure. ");
INSERT INTO francl_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","On fit les planches pour la Demeure : vingt planches pour la face du midi, à droite. ");
INSERT INTO francl_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","On mit sous les vingt planches quarante socles d’argent, deux socles sous chaque planche pour ses deux tenons. ");
INSERT INTO francl_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Pour le second côté de la Demeure, le côté du nord, on fit vingt planches, ");
INSERT INTO francl_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","ainsi que leurs quarante socles d’argent, deux socles sous chaque planche. ");
INSERT INTO francl_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","On fit six planches pour le fond de la Demeure, du côté de l’occident. ");
INSERT INTO francl_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","On fit deux planches pour les angles de la Demeure, dans le fond ; ");
INSERT INTO francl_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","elles étaient doubles depuis le bas, formant ensemble un seul tout jusqu’à leur sommet, jusqu’au premier anneau : ainsi fit-on pour toutes les deux, aux deux angles. ");
INSERT INTO francl_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Il y avait ainsi huit planches, avec leurs socles d’argent, seize socles, deux socles sous chaque planche. ");
INSERT INTO francl_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","On fit des traverses de bois d’acacia, cinq pour les planches de l’un des côtés de la Demeure, ");
INSERT INTO francl_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","cinq traverses pour les planches du second côté de la Demeure, et cinq traverses pour les planches du côté de la Demeure qui en forme le fond, vers l’occident. ");
INSERT INTO francl_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","La traverse du milieu s’étendait, le long des planches, d’une extrémité à l’autre. ");
INSERT INTO francl_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","On revêtit d’or les planches, et l’on fit d’or leurs anneaux qui recevaient les traverses, et l’on revêtit d’or les traverses. ");
INSERT INTO francl_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","On fit le voile de pourpre violette, de pourpre écarlate, de cramoisi, et de lin retors ; on y représenta des chérubins figurés : ouvrage d’un habile tisseur. ");
INSERT INTO francl_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","On fit pour lui quatre colonnes d’acacia, revêtues d’or, avec des crochets d’or ; et l’on fondit pour elles quatre socles d’argent. ");
INSERT INTO francl_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","On fit pour l’entrée de la tente un rideau en pourpre violette, pourpre écarlate, cramoisi et lin retors, ouvrage d’un dessin varié. ");
INSERT INTO francl_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","On fit pour ce rideau cinq colonnes et leurs crochets et l’on revêtit d’or leurs chapiteaux et leurs tringles ; leurs cinq socles étaient d’airain. ");
INSERT INTO francl_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Béseléel fit l’arche de bois d’acacia ; sa longueur était de deux coudées et demie, sa largeur d’une coudée et demie, et sa hauteur d’une coudée et demie. ");
INSERT INTO francl_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Il la revêtit d’or pur, en dedans et en dehors, et il y fit une guirlande d’or tout autour. ");
INSERT INTO francl_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Il fondit pour elle quatre anneaux d’or, qu’il mit à ses quatre pieds, deux anneaux d’un côté et deux anneaux de l’autre. ");
INSERT INTO francl_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Il fit des barres de bois d’acacia et les revêtit d’or. ");
INSERT INTO francl_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Il passa les barres dans les anneaux sur les côtés de l’arche, pour la porter. ");
INSERT INTO francl_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Il fit un propitiatoire d’or pur ; sa longueur était de deux coudées et demie, sa largeur d’une coudée et demie. ");
INSERT INTO francl_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Il fit deux chérubins d’or ; il les fit d’or battu, aux deux extrémités du propitiatoire, ");
INSERT INTO francl_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","un chérubin à l’une des extrémités et un chérubin à l’autre extrémité ; il fit les chérubins sortant du propitiatoire à ses deux extrémités. ");
INSERT INTO francl_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Les chérubins avaient leurs ailes déployées vers le haut, couvrant de leurs ailes le propitiatoire, et se faisant face l’un à l’autre ; les faces des chérubins étaient tournées vers le propitiatoire. ");
INSERT INTO francl_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Il fit la table de bois d’acacia ; sa longueur était de deux coudées, sa largeur d’une coudée, et sa hauteur d’une coudée et demie. ");
INSERT INTO francl_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Il la revêtit d’or pur, et y mit une guirlande d’or tout autour. ");
INSERT INTO francl_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Il lui fit à l’entour un châssis d’une palme, et il fit une guirlande d’or au châssis tout autour. ");
INSERT INTO francl_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Il fondit pour la table quatre anneaux d’or, et il mit les anneaux aux quatre coins, qui sont à ses quatre pieds. ");
INSERT INTO francl_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Les anneaux étaient près du châssis pour recevoir les barres qui doivent porter la table. ");
INSERT INTO francl_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Il fit les barres de bois d’acacia et les revêtit d’or ; elles servaient à porter la table. ");
INSERT INTO francl_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Il fit les ustensiles qu’on devait mettre sur la table, ses plats, ses cassolettes, ses coupes et ses tasses pour servir aux libations ; il les fit d’or pur. ");
INSERT INTO francl_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Il fit le chandelier d’or pur ; il fit d’or battu le chandelier, avec son pied et sa tige ; ses calices, ses boutons et ses fleurs étaient d’une même pièce. ");
INSERT INTO francl_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Six branches sortaient de ses côtés ; trois branches du chandelier de l’un de ses côtés, et trois branches du chandelier du second de ses côtés. ");
INSERT INTO francl_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Il y avait sur la première branche trois calices en fleurs d’amandier, bouton et fleur, et sur la seconde branche trois calices en fleurs d’amandiers, bouton et fleur ; il en était de même pour les six branches partant du chandelier. ");
INSERT INTO francl_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","A la tige du chandelier, il y avait quatre calices, en fleurs d’amandier, avec leurs boutons et leurs fleurs. ");
INSERT INTO francl_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Il y avait un bouton sous les deux premières branches partant de la tige du chandelier, un bouton sous les deux branches suivantes partant de la tige du chandelier, et un bouton sous les deux dernières branches partant de la tige du chandelier, selon les six branches sortant du chandelier. ");
INSERT INTO francl_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Ces boutons et ces branches étaient d’une même pièce avec le chandelier ; le tout était une masse d’or battu, d’or pur. ");
INSERT INTO francl_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Il fit ses lampes au nombre de sept, ses mouchettes et ses vases à cendre, en or pur. ");
INSERT INTO francl_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","On employa un talent d’or pur pour faire le chandelier avec tous ses ustensiles. ");
INSERT INTO francl_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Il fit l’autel des parfums de bois d’acacia ; sa longueur était d’une coudée, et sa largeur d’une coudée ; il était carré, et sa hauteur était de deux coudées ; ses cornes faisaient corps avec lui. ");
INSERT INTO francl_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Il le revêtit d’or pur, le dessus, les côtés tout autour et les cornes, et il y fit une guirlande d’or tout autour. ");
INSERT INTO francl_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Il fit pour lui deux anneaux d’or, au-dessous de sa guirlande, sur ses deux arêtes ; il les fit aux deux côtés, pour recevoir les barres qui servaient à le porter. ");
INSERT INTO francl_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Il fit les barres de bois d’acacia et les revêtit d’or. ");
INSERT INTO francl_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Il fit l’huile pour l’onction sainte, et le parfum pour l’encensement, composé selon l’art du parfumeur. ");
INSERT INTO francl_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Il fit l’autel des holocaustes en bois d’acacia ; sa longueur était de cinq coudées, et sa largeur de cinq coudées ; il était carré, et sa hauteur était de trois coudées. ");
INSERT INTO francl_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","A ses quatre coins, il fit des cornes qui sortaient de l’autel, et il le revêtit d’airain. ");
INSERT INTO francl_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Il fit tous les ustensiles de l’autel, les vases à cendre, les pelles, les bassins, les fourchettes et les brasiers ; il fit d’airain tous ces ustensiles. ");
INSERT INTO francl_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Il fit à l’autel une grille d’airain en forme de treillis ; il la plaça sous la corniche de l’autel, par en bas, jusqu’à moitié de la hauteur. ");
INSERT INTO francl_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Il fondit quatre anneaux, qu’il mit aux quatre coins de la grille d’airain, pour recevoir les barres. ");
INSERT INTO francl_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Il fit les barres de bois d’acacia et les revêtit d’airain. ");
INSERT INTO francl_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Il passa les barres dans les anneaux, aux côtés de l’autel, pour qu’elles servent à le transporter. Il le fit creux, en planches. ");
INSERT INTO francl_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Il fit la cuve d’airain et sa base d’airain, avec les miroirs des femmes qui s’assemblaient à l’entrée de la tente de réunion. ");
INSERT INTO francl_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Il fit le parvis. Du côté du midi, à droite, les rideaux du parvis, en lin retors, avaient une longueur de cent coudées, ");
INSERT INTO francl_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","avec vingt colonnes et leurs vingt socles d’airain ; les crochets des colonnes et leurs tringles étaient d’argent. ");
INSERT INTO francl_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Du côté du nord, les rideaux avaient cent coudées avec vingt colonnes et leurs vingt socles d’airain ; les crochets des colonnes et leurs tringles étaient d’argent. ");
INSERT INTO francl_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Du côté de l’occident, les rideaux avaient cinquante coudées, avec dix colonnes et leurs dix socles. ");
INSERT INTO francl_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Du côté de l’orient, sur le devant, il y avait cinquante coudées : ");
INSERT INTO francl_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","et il y avait quinze coudées de rideaux pour un côté de la porte, avec trois colonnes et leurs trois socles, ");
INSERT INTO francl_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","et pour le deuxième côté — d’un côté de la porte du parvis comme de l’autre, — quinze coudées de rideaux avec trois colonnes et leurs trois socles. ");
INSERT INTO francl_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Tous les rideaux formant l’enceinte du parvis étaient de lin retors. ");
INSERT INTO francl_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Les socles pour les colonnes étaient d’airain, les crochets des colonnes et leurs tringles étaient d’argent, et leurs chapiteaux étaient revêtus d’argent. Toutes les colonnes du parvis étaient reliées par des tringles d’argent. ");
INSERT INTO francl_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Le rideau de la porte du parvis était un ouvrage de dessin varié, en pourpre violette, pourpre écarlate, cramoisi, et lin retors ; sa longueur était de vingt coudées, et sa hauteur de cinq coudées, comme la largeur des rideaux du parvis ; ");
INSERT INTO francl_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","ses quatre colonnes et leurs quatre socles étaient d’airain, les crochets et leurs tringles d’argent, et leurs chapiteaux revêtus d’argent. ");
INSERT INTO francl_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Tous les pieux pour la Demeure et pour l’enceinte du parvis étaient d’airain. ");
INSERT INTO francl_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Voici le compte des choses qui ont été employées pour la Demeure, la Demeure du témoignage, compte dressé par le soin des Lévites sur l’ordre de Moïse et sous la direction d’Ithamar, fils du grand prêtre Aaron. ");
INSERT INTO francl_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Béseléel, fils d’Uri, fils de Hur, de la tribu de Juda, fit tout ce que Yahweh avait ordonné à Moïse ; ");
INSERT INTO francl_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","il eut pour aide Ooliab, fils Achisamech, de la tribu de Dan, habile à sculpter, à inventer, à tisser en dessin varié la pourpre violette, la pourpre écarlate, le cramoisi, et le fin lin. ");
INSERT INTO francl_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Total de l’or employé à l’ouvrage, pour tout l’ouvrage du sanctuaire, or qui était le produit des offrandes : vingt-neuf talents et sept cent trente sicles, selon le sicle du sanctuaire. ");
INSERT INTO francl_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","L’argent de ceux de l’assemblée qui furent recensés s’élevait à cent talents et mille sept cent soixante-quinze sicles, selon le sicle du sanctuaire. ");
INSERT INTO francl_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","C’était un béka par tête, la moitié d’un sicle, selon le sicle du sanctuaire, pour chaque homme compris dans le recensement, depuis l’âge de vingt ans et au-dessus, soit pour six cent trois mille cinq cent cinquante hommes. ");
INSERT INTO francl_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Les cent talents d’argent servirent à fondre les socles du sanctuaire et les socles du voile, cent socles pour les cent talents, un talent par socle. ");
INSERT INTO francl_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Et avec les mille sept cent soixante-quinze sicles, on fit les crochets pour les colonnes, on revêtit les chapiteaux et on les joignit par des tringles. ");
INSERT INTO francl_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","L’airain des offrandes montait à soixante-dix talents et deux mille quatre cent sicles. ");
INSERT INTO francl_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","On en fit les socles de l’entrée de la tente de réunion, l’autel d’airain avec sa grille d’airain et tous les ustensiles de l’autel, ");
INSERT INTO francl_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","les socles de l’enceinte du parvis et les socles de la porte du parvis, et tous les pieux de la Demeure et tous les pieux de l’enceinte du parvis. ");
INSERT INTO francl_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Avec la pourpre violette, la pourpre écarlate et le cramoisi, on fit les vêtements de cérémonie peur le service dans le sanctuaire, et on fit les vêtements sacrés pour Aaron, comme Yahweh l’avait ordonné à Moïse. ");
INSERT INTO francl_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","On fit l’éphod d’or, de pourpre violette, de pourpre écarlate, de cramoisi et de lin retors. ");
INSERT INTO francl_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","On étendit l’or en lames et on les coupa en fils, que l’on entrelaça dans la pourpre violette, la pourpre écarlate, le cramoisi et le fin lin ; ouvrage de dessin varié. ");
INSERT INTO francl_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","On fit des épaulettes pour le joindre, et ainsi il était joint à ses deux extrémités. ");
INSERT INTO francl_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","La ceinture pour attacher l’éphod en passant dessus faisait corps avec lui et était du même travail ; elle était d’or, de pourpre violette, de pourpre écarlate, de cramoisi et de lin retors, comme Yahweh l’avait ordonné à Moïse. ");
INSERT INTO francl_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","On fit les pierres d’onyx enchâssées dans des chatons d’or, sur lesquelles on grava les noms des fils d’Israël, comme on grave les cachets. ");
INSERT INTO francl_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","On les plaça sur les épaulettes de l’éphod comme pierres de souvenir pour les enfants d’Israël, comme Yahweh l’avait ordonné à Moïse. ");
INSERT INTO francl_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","On fit le pectoral, artistement travaillé, du même travail que l’éphod, d’or, de pourpre violette, de pourpre écarlate, de cramoisi et de lin retors. ");
INSERT INTO francl_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Il était carré ; on fit le pectoral double ; sa longueur était d’un empan et sa largeur d’un empan ; il était double. ");
INSERT INTO francl_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","On le garnit de quatre rangées de pierres : une rangée de sardoine, de topaze, d’émeraude : première rangée ; ");
INSERT INTO francl_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","deuxième rangée : une escarboucle, un saphir, un diamant ; ");
INSERT INTO francl_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","troisième rangée : une opale, une agate, une améthyste ; ");
INSERT INTO francl_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","quatrième rangée : une chrysolithe, un onyx, un jaspe. Ces pierres étaient entourées de rosettes d’or dans leurs garnitures. ");
INSERT INTO francl_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Les pierres étaient selon les noms des fils d’Israël, douze selon leurs noms ; elles étaient gravées comme des cachets, chacune avec son nom, pour les douze tribus. — ");
INSERT INTO francl_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","On fit pour le pectoral des chaînettes d’or pur, tressées en forme de cordons. ");
INSERT INTO francl_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","On fit deux chatons d’or et deux anneaux d’or, et on mit les deux anneaux aux deux extrémités du pectoral. ");
INSERT INTO francl_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","On passa les deux cordons d’or dans les deux anneaux, aux extrémités du pectoral, ");
INSERT INTO francl_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","et l’on attacha les deux bouts des deux cordons aux deux chatons, et on les plaça sur les épaulettes de l’éphod, par devant. ");
INSERT INTO francl_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","On fit encore deux anneaux d’or, que l’on mit aux deux extrémités inférieures du pectoral, sur le bord intérieur appliqué contre l’éphod. ");
INSERT INTO francl_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","On fit deux autres anneaux d’or, que l’un mit au bas des deux épaulettes de l’éphod sur le devant, près de l’attache, au-dessus de la ceinture de l’éphod. ");
INSERT INTO francl_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","On attacha le pectoral par ses anneaux aux anneaux de l’éphod avec un ruban de pourpre violette, afin que le pectoral fût au-dessus de la ceinture de l’éphod ; et le pectoral ne pouvait se séparer de l’éphod, comme Yahweh l’a ordonné à Moïse. ");
INSERT INTO francl_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","On fit la robe de l’éphod, œuvre du tisseur, tout entière en pourpre violette. ");
INSERT INTO francl_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Il y avait, au milieu de la robe de l’éphod, une ouverture semblable à celle d’une cotte d’arme, et cette ouverture avait un rebord tissé tout autour, afin que la robe ne se déchirât pas. ");
INSERT INTO francl_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","On mit au bord inférieur de la robe des grenades de pourpre violette, de pourpre écarlate, de cramoisi, de lin retors ; ");
INSERT INTO francl_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","on fit des clochettes d’or pur, et l’on mit ces clochettes au milieu des grenades, sur le bord inférieur de la robe tout autour, au milieu des grenades : ");
INSERT INTO francl_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","une clochette et une grenade, une clochette et une grenade, sur le bord de la robe tout autour, pour le service, comme Yahweh l’avait ordonné à Moïse. ");
INSERT INTO francl_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","On fit les tuniques de lin, œuvre du tisseur, pour Aaron et pour ses fils ; ");
INSERT INTO francl_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","la tiare de lin, et les mitres de lin servant de parure ; les caleçons blancs de lin retors ; ");
INSERT INTO francl_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","la ceinture de lin retors, en pourpre violette, en pourpre écarlate et en cramoisi, damassée, comme Yahweh l’avait ordonné à Moïse. ");
INSERT INTO francl_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","On fit d’or pur la lame, diadème sacré, et l’on y grava, comme on grave sur un cachet : Sainteté à Yahweh. ");
INSERT INTO francl_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","On l’attacha avec un ruban de pourpre violette pour la placer sur la tiare, en haut, comme Yahweh l’avait ordonné à Moïse. ");
INSERT INTO francl_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Ainsi fut achevé tout l’ouvrage de la Demeure, de la tente de réunion ; et les enfants d’Israël exécutèrent tout selon ce que Yahweh avait ordonné à Moïse ; ils firent ainsi. ");
INSERT INTO francl_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","On présenta la Demeure à Moïse, la tente et tous ses ustensiles, ses agrafes, ses planches, ses traverses, ses colonnes et ses socles ; ");
INSERT INTO francl_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","la couverture de peaux de béliers teintes en rouge, la couverture de peaux de veaux marins et le voile de séparation ; ");
INSERT INTO francl_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","l’arche du témoignage avec ses barres et le propitiatoire ; ");
INSERT INTO francl_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","la table avec tous ses ustensiles et les pains de proposition ; ");
INSERT INTO francl_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","le chandelier d’or pur, ses lampes, les lampes à y ranger, tous ses ustensiles et l’huile pour le luminaire ; ");
INSERT INTO francl_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","l’autel d’or, l’huile d’onction et le parfum pour l’encens, ainsi que le rideau pour l’entrée de la tente ; ");
INSERT INTO francl_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","l’autel d’airain, sa grille d’airain, ses barres et tous ses ustensiles ; la cuve avec sa base ; les rideaux du parvis, ses colonnes, ses socles, ");
INSERT INTO francl_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","la tenture de la porte du parvis, ses cordages et ses pieux, et tous les ustensiles pour le service de la Demeure, pour la tente de réunion ; ");
INSERT INTO francl_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","les vêtements de cérémonie pour le service du sanctuaire, les vêtements sacrés pour le grand prêtre Aaron, et les vêtements de ses fils pour les fonctions du sacerdoce. ");
INSERT INTO francl_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Les enfants d’Israël avaient fait tout cet ouvrage conformément à tout ce que Yahweh avait ordonné à Moïse. ");
INSERT INTO francl_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Moïse examina tout l’ouvrage, et voici, ils l’avaient exécuté ; ils l’avaient fait comme Yahweh l’avait ordonné. Et Moïse les bénit. ");
INSERT INTO francl_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","« Le premier jour du premier mois, tu dresseras la Demeure, la tente de réunion. ");
INSERT INTO francl_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Tu y placeras l’arche du témoignage, et tu couvriras l’arche avec le voile. ");
INSERT INTO francl_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Tu apporteras la table et tu y disposeras ce qui doit la garnir. Tu apporteras le chandelier et tu poseras dessus ses lampes. ");
INSERT INTO francl_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Tu placeras l’autel d’or pour le parfum devant l’arche du témoignage, et tu mettras le voile à l’entrée de la Demeure. ");
INSERT INTO francl_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Tu placeras l’autel des holocaustes devant l’entrée de la Demeure, de la tente de réunion. ");
INSERT INTO francl_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Tu placeras la cuve entre la tente de réunion et l’autel, et tu y mettras de l’eau. ");
INSERT INTO francl_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Tu dresseras le parvis à l’entour, et tu mettras la tenture à la porte du parvis. ");
INSERT INTO francl_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","« Tu prendras l’huile d’onction, tu en oindras la Demeure et tout ce qu’elle renferme ; tu la consacreras avec tous ses ustensiles, et elle sera sainte. ");
INSERT INTO francl_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Tu oindras l’autel des holocaustes et tous ses ustensiles ; tu consacreras l’autel, et l’autel sera très saint. ");
INSERT INTO francl_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Tu oindras la cuve avec sa base, et tu la consacreras. ");
INSERT INTO francl_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","« Tu feras avancer Aaron et ses fils près de l’entrée de la tente de réunion, et tu les laveras avec de l’eau. ");
INSERT INTO francl_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Puis tu revêtiras Aaron des vêtements sacrés, tu l’oindras et tu le consacreras, et il sera prêtre à mon service. ");
INSERT INTO francl_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Tu feras approcher ses fils et, les ayant revêtus des tuniques, ");
INSERT INTO francl_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","tu les oindras comme tu auras oint leur père, et ils seront prêtres à mon service. Cette onction leur conférera le sacerdoce à perpétuité parmi leurs descendants. » ");
INSERT INTO francl_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Moïse fit tout ce que Yahweh lui avait ordonné ; il fit ainsi. ");
INSERT INTO francl_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Le premier jour du premier mois de la seconde année, la Demeure fut dressée. ");
INSERT INTO francl_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Moïse dressa la Demeure ; il en posa les socles, il en plaça les planches et les traverses, en dressa les colonnes. ");
INSERT INTO francl_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Il étendit la tente sur la Demeure, et mit par-dessus la couverture de la tente, comme Yahweh l’avait ordonné à Moïse. ");
INSERT INTO francl_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Il prit le témoignage et le plaça dans l’arche ; il mit les barres à l’arche et posa le propitiatoire au-dessus de l’arche. ");
INSERT INTO francl_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Il porta l’arche dans la Demeure ; et, ayant mis le voile de séparation, il en couvrit l’arche du témoignage, comme Yahweh l’avait ordonné à Moïse. ");
INSERT INTO francl_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Il plaça la table dans la tente de réunion, au côté septentrional de la Demeure, en dehors du voile, ");
INSERT INTO francl_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","et il y disposa les pains devant Yahweh, comme Yahweh l’avait ordonné à Moïse. ");
INSERT INTO francl_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Il plaça le chandelier dans la tente de réunion, vis-à-vis de la table, au côté méridional de la Demeure, ");
INSERT INTO francl_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","et il y posa les lampes devant Yahweh, comme Yahweh l’avait ordonné à Moïse. ");
INSERT INTO francl_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Il plaça l’autel d’or dans la tente de réunion, devant le voile, ");
INSERT INTO francl_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","et il y fit brûler l’encens, comme Yahweh l’avait ordonné à Moïse. ");
INSERT INTO francl_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Il plaça le rideau à l’entrée de la Demeure. ");
INSERT INTO francl_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Il plaça l’autel des holocaustes à l’entrée de la Demeure, de la tente de réunion, et il y offrit l’holocauste et l’oblation, comme Yahweh l’avait ordonné à Moïse. ");
INSERT INTO francl_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Il plaça la cuve entre la tente de réunion et l’autel, et il y mit de l’eau pour les ablutions ; ");
INSERT INTO francl_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Moïse, Aaron et ses fils s’y lavèrent les mains et les pieds. ");
INSERT INTO francl_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Lorsqu’ils entraient dans la tente de réunion et qu’ils s’approchaient de l’autel, ils se lavaient, comme Yahweh l’avait ordonné à Moïse. ");
INSERT INTO francl_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Il dressa le parvis autour de la Demeure et de l’autel, et il mit la tenture à la porte du parvis. Ce fut ainsi que Moïse acheva cette œuvre. ");
INSERT INTO francl_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Alors la nuée couvrit la tente de réunion, et la gloire de Yahweh remplit la Demeure. ");
INSERT INTO francl_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Et Moïse ne pouvait plus entrer dans la tente de réunion, parce que la nuée restait dessus, et que la gloire de Yahweh remplissait la Demeure. ");
INSERT INTO francl_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Tant que durèrent leurs marches, les enfants d’Israël partaient lorsque la nuée s’élevait de dessus la Demeure ; ");
INSERT INTO francl_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","et si la nuée ne s’élevait pas, ils ne partaient pas, jusqu’au jour où elle s’élevait. ");
INSERT INTO francl_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Car la nuée de Yahweh reposait pendant le jour sur la Demeure, et, pendant la nuit, il y avait du feu dans la nuée, aux yeux de toute la maison d’Israël, tant que durèrent leurs marches. ");
INSERT INTO francl_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","YAHWEH appela Moïse, et lui parla de la tente de réunion, en disant : ");
INSERT INTO francl_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","« Parle aux enfants d’Israël et dis-leur : Lorsque quelqu’un d’entre vous fera à Yahweh une offrande, ce sera du bétail que vous offrirez, du gros ou du menu bétail. ");
INSERT INTO francl_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Si son offrande est un holocauste de gros bétail, il offrira un mâle sans défaut ; il l’offrira à l’entrée de la tente de réunion, pour être agréé devant Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Il posera sa main sur la tête de l’holocauste, et il sera accepté en sa faveur pour faire expiation pour lui. ");
INSERT INTO francl_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Il égorgera le jeune taureau devant Yahweh, et les prêtres, fils d’Aaron, offriront le sang et le répandront tout autour sur l’autel qui est à l’entrée de la tente de réunion. ");
INSERT INTO francl_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","On dépouillera l’holocauste et on le découpera en ses morceaux. ");
INSERT INTO francl_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Les fils du prêtre Aaron mettront du feu sur l’autel et disposeront du bois sur le feu ; ");
INSERT INTO francl_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","puis les prêtres, fils d’Aaron, arrangeront les morceaux, avec la tête et la fressure, sur le bois placé sur le feu de l’autel. ");
INSERT INTO francl_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","On lavera avec de l’eau les entrailles et les jambes, et le prêtre fera fumer le tout sur l’autel. C’est un holocauste, un sacrifice par le feu, d’une agréable odeur à Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Si son offrande est de menu bétail, un holocauste d’agneaux ou de chèvres, il offrira un mâle sans défaut. ");
INSERT INTO francl_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Il l’égorgera au côté septentrional de l’autel, devant Yahweh ; et les prêtres, fils d’Aaron, en répandront le sang tout autour sur l’autel. ");
INSERT INTO francl_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","On le découpera en ses morceaux, avec sa tête et sa fressure ; puis le prêtre les arrangera sur le bois placé sur le feu de l’autel. ");
INSERT INTO francl_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Il lavera dans l’eau les entrailles et les jambes, et le prêtre offrira le tout et le fera fumer sur l’autel. C’est un holocauste, un sacrifice par le feu, d’une agréable odeur à Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Si son offrande à Yahweh est un holocauste d’oiseaux, il offrira des tourterelles ou de jeunes pigeons. ");
INSERT INTO francl_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Le prêtre apportera l’oiseau à l’autel ; il lui brisera la tête avec l’ongle et la fera fumer sur l’autel, et son sang sera exprimé contre la paroi de l’autel. ");
INSERT INTO francl_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Il ôtera le jabot avec ses impuretés et le jettera près de l’autel, vers l’Orient, au lieu où l’on met les cendres. ");
INSERT INTO francl_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Puis il fendra l’oiseau aux ailes, sans les séparer, et le prêtre le fera fumer sur l’autel, sur le bois placé sur le feu. C’est un holocauste, un sacrifice par le feu, d’une agréable odeur à Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Lorsque quelqu’un présentera comme offrande à Yahweh une oblation, son offrande sera de fleur de farine ; il versera de l’huile dessus et y ajoutera de l’encens. ");
INSERT INTO francl_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Il l’apportera aux prêtres, fils d’Aaron ; et le prêtre prendra une poignée de la fleur de farine arrosée d’huile, avec tout l’encens, et il fera fumer cela sur l’autel en souvenir. C’est un sacrifice fait par le feu, d’une agréable odeur à Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Ce qui restera de l’oblation sera pour Aaron et ses fils ; c’est une chose très sainte entre les sacrifices faits par le feu à Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Quand tu offriras une oblation de ce qui est cuit au four, ce sera des gâteaux de fleur de farine, sans levain, pétris à l’huile, et des galettes sans levain arrosées d’huile. ");
INSERT INTO francl_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Si tu offres en oblation un gâteau cuit à la poêle, il sera de fleur de farine pétrie à l’huile, sans levain. ");
INSERT INTO francl_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Tu le rompras en morceaux et tu verseras de l’huile dessus : c’est une oblation. ");
INSERT INTO francl_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Si tu offres en oblation un gâteau cuit dans la casserole, il sera fait de fleur de farine avec de l’huile. ");
INSERT INTO francl_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Tu apporteras à Yahweh l’oblation ainsi préparée, et elle sera présentée au prêtre, qui l’apportera à l’autel. ");
INSERT INTO francl_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Le prêtre en prélèvera ce qui doit être offert en souvenir, et le fera fumer sur l’autel : c’est un sacrifice fait par le feu, d’une agréable odeur à Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Ce qui restera de l’oblation sera pour Aaron et pour ses fils ; c’est une chose très sainte entre les sacrifices faits par le feu à Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Toute oblation que vous présenterez à Yahweh doit être préparée sans levain, car vous ne ferez fumer rien qui contienne du levain ou du miel en sacrifice fait par le feu à Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Vous pourrez les présenter à Yahweh en offrandes de prémices ; mais il n’en sera pas placé sur l’autel comme offrandes d’agréable odeur. ");
INSERT INTO francl_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Tout ce que tu présenteras en oblation sera salé ; tu ne laisseras pas le sel de l’alliance de ton Dieu manquer à ton oblation ; sur toutes tes offrandes tu offriras du sel. ");
INSERT INTO francl_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Si tu fais à Yahweh une oblation de prémices, tu présenteras des épis rôtis au feu, du grain nouveau broyé, comme oblation de tes prémices. ");
INSERT INTO francl_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Tu verseras de l’huile dessus, et tu y ajouteras de l’encens ; c’est une oblation. ");
INSERT INTO francl_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Le prêtre fera fumer en souvenir une partie du grain broyé et de l’huile, avec tout l’encens. C’est un sacrifice fait par le feu à Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Lorsqu’un homme offrira un sacrifice pacifique, s’il offre du gros bétail, mâle ou femelle, il l’offrira sans défaut devant Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Il posera sa main sur la tête de la victime et il l’égorgera à l’entrée de la tente de réunion, et les prêtres, fils d’Aaron, répandront le sang sur les parois de l’autel tout autour. ");
INSERT INTO francl_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","De ce sacrifice pacifique, il offrira en sacrifice par le feu à Yahweh : la graisse qui enveloppe les entrailles et toute la graisse qui est attachée aux entrailles ; ");
INSERT INTO francl_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","les deux rognons avec la graisse qui les recouvre et qui tient à la région lombaire ; la taie du foie qu’il détachera près des rognons. ");
INSERT INTO francl_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Les fils d’Aaron feront fumer cela sur l’autel, par-dessus l’holocauste placé sur le bois qui est sur le feu. C’est un sacrifice fait par le feu, d’une agréable odeur à Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","S’il offre du menu bétail, mâle ou femelle, en sacrifice pacifique à Yahweh, il l’offrira sans défaut. ");
INSERT INTO francl_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","S’il offre en sacrifice un agneau, il le présentera devant Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Il posera sa main sur la tête de la victime et il l’égorgera devant la tente de réunion, et les fils d’Aaron en répandront le sang sur les parois de l’autel tout autour. ");
INSERT INTO francl_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","De ce sacrifice pacifique, il offrira en sacrifice par le feu à Yahweh : sa graisse, la queue entière, coupée près de l’échine ; la graisse qui enveloppe les entrailles et toute la graisse qui est attachée aux entrailles ; ");
INSERT INTO francl_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","les deux rognons, avec la graisse qui les recouvre et qui tient à la région lombaire ; la taie du foie qu’il détachera près des rognons. ");
INSERT INTO francl_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Le prêtre fera fumer cela sur l’autel : c’est l’aliment d’un sacrifice fait par le feu à Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Si son offrande est une chèvre, il la présentera devant Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","Il posera sa main sur la tête de la victime, et il l’égorgera devant la tente de réunion, et les fils d’Aaron en répandront le sang sur les parois de l’autel tout autour. ");
INSERT INTO francl_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","De la victime, il offrira en sacrifice par le feu à Yahweh : la graisse qui enveloppe les entrailles et toute la graisse qui est attachée aux entrailles ; ");
INSERT INTO francl_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","les deux rognons, avec la graisse qui les recouvre et qui tient à la région lombaire ; la taie du foie qu’il détachera près des rognons. ");
INSERT INTO francl_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Le prêtre fera fumer cela sur l’autel : c’est l’aliment d’un sacrifice fait par le feu d’une agréable odeur. Toute graisse appartient à Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","C’est ici une loi perpétuelle pour vos descendants, en quelque lieu que vous habitiez : vous ne mangerez ni graisse, ni sang. » ");
INSERT INTO francl_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","« Parle aux enfants d’Israël et dis-leur : Lorsqu’un homme aura péché par erreur contre l’un des commandements de Yahweh relatifs aux choses qui ne doivent pas se faire, et qu’il aura fait l’une de ces choses ; ");
INSERT INTO francl_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Si c’est le prêtre ayant reçu l’onction qui a péché, rendant par là le peuple coupable, il offrira à Yahweh pour le péché qu’il a commis un jeune taureau sans défaut, en sacrifice d’expiation. ");
INSERT INTO francl_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Il amènera le taureau à l’entrée de la tente de réunion, devant Yahweh, et il posera sa main sur la tête du taureau, et il l’égorgera devant Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Le prêtre ayant reçu l’onction prendra du sang du taureau et l’apportera dans la tente de réunion ; ");
INSERT INTO francl_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","il trempera son doigt dans le sang, il en fera sept fois l’aspersion devant Yahweh, en face du voile du sanctuaire. ");
INSERT INTO francl_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Le prêtre mettra du sang sur les cornes de l’autel des parfums odoriférants, qui est devant Yahweh dans la tente de réunion, et il répandra tout le reste du sang du taureau au pied de l’autel des holocaustes, qui est à l’entrée de la tente de réunion. ");
INSERT INTO francl_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Il enlèvera ensuite toute la graisse du taureau immolé pour le péché, la graisse qui enveloppe les entrailles et toute la graisse qui est attachée aux entrailles ; ");
INSERT INTO francl_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","les deux rognons, avec la graisse qui les recouvre et qui tient à la région lombaire ; la taie du foie qu’il détachera près des rognons. ");
INSERT INTO francl_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Il enlèvera ces parties comme on les enlève du taureau dans le sacrifice pacifique, et il les fera fumer sur l’autel des holocaustes. ");
INSERT INTO francl_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Mais la peau du taureau, toute sa chair, avec sa tête, ses jambes, ses entrailles et ses excréments, ");
INSERT INTO francl_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","le taureau entier, il l’emportera hors du camp, dans un lieu pur, où l’on jette les cendres, et il le brûlera au feu sur du bois ; c’est sur le tas de cendres qu’il sera brûlé. ");
INSERT INTO francl_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Si toute l’assemblée d’Israël a péché par erreur, sans que la chose ait apparu à ses yeux, et qu’ils aient fait quelqu’une de toutes les choses que Yahweh a défendues de faire, se rendant ainsi coupables, ");
INSERT INTO francl_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","quand le péché commis par eux sera reconnu, l’assemblée offrira un jeune taureau en sacrifice d’expiation, et on l’amènera devant la tente de réunion. ");
INSERT INTO francl_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Les anciens de l’assemblée d’Israël poseront leurs mains sur la tête du taureau devant Yahweh, et on égorgera le taureau devant Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Le prêtre ayant reçu l’onction apportera du sang du taureau dans la tente de réunion ; ");
INSERT INTO francl_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","il trempera son doigt dans le sang, il en fera sept fois l’aspersion devant Yahweh, en face du voile. ");
INSERT INTO francl_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Il mettra du sang sur les cornes de l’autel qui est devant Yahweh dans la tente de réunion, et il répandra tout le reste du sang au pied de l’autel des holocaustes, qui est à l’entrée de la tente de réunion. ");
INSERT INTO francl_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Il enlèvera ensuite toute la graisse du taureau, et il la fera fumer sur l’autel. ");
INSERT INTO francl_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Il fera de ce taureau comme du taureau immolé pour le péché du prêtre ayant reçu l’onction ; il fera de même. C’est ainsi que le prêtre fera pour eux l’expiation, et il leur sera pardonné. ");
INSERT INTO francl_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Il emportera le taureau hors du camp et le brûlera comme le premier taureau. Tel est le sacrifice pour le péché de l’assemblée d’Israël. ");
INSERT INTO francl_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Si c’est un chef qui a péché, en faisant par erreur une de toutes les choses que Yahweh, son Dieu, a défendu de faire, se rendant ainsi coupable, ");
INSERT INTO francl_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","quand le péché commis par lui sera venu à sa connaissance, il amènera pour son offrande un bouc mâle sans défaut. ");
INSERT INTO francl_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Il posera sa main sur la tête du bouc, et il l’égorgera dans le lieu où l’on égorge les holocaustes devant Yahweh ; c’est un sacrifice pour le péché. ");
INSERT INTO francl_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Le prêtre prendra avec son doigt du sang de la victime pour le péché, il en mettra sur les cornes de l’autel des holocaustes, et il répandra le reste du sang au pied de cet autel. ");
INSERT INTO francl_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Puis il en brûlera toute la graisse sur l’autel, comme on brûle la graisse des sacrifices pacifiques. C’est ainsi que le prêtre fera pour lui l’expiation de son péché, et il lui sera pardonné. ");
INSERT INTO francl_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Si quelqu’un du peuple du pays a péché par erreur, en faisant une des choses que Yahweh a défendu de faire, se rendant ainsi coupable, ");
INSERT INTO francl_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","quand le péché commis par lui sera venu à sa connaissance, il amènera pour son offrande une chèvre velue, une femelle sans défaut, pour le péché qu’il a commis. ");
INSERT INTO francl_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Il posera sa main sur la tête de la victime pour le péché et il l’égorgera dans le lieu où l’on offre les holocaustes. ");
INSERT INTO francl_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Le prêtre prendra avec son doigt du sang de la victime, il en mettra sur les cornes de l’autel des holocaustes, et il répandra tout le reste du sang au pied de l’autel. ");
INSERT INTO francl_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Il enlèvera toute la graisse, comme on enlève la graisse de dessus le sacrifice pacifique, et le prêtre la fera fumer sur l’autel en agréable odeur à Yahweh. C’est ainsi que le prêtre fera l’expiation pour cet homme, et il lui sera pardonné. ");
INSERT INTO francl_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Si c’est un agneau qu’il amène en sacrifice pour le péché, il amènera une femelle sans défaut. ");
INSERT INTO francl_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Il posera sa main sur la tête de la victime pour le péché et l’égorgera en sacrifice d’expiation dans le lieu où l’on immole l’holocauste. ");
INSERT INTO francl_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Le prêtre prendra avec son doigt du sang de la victime, il en mettra sur les cornes de l’autel des holocaustes, et il répandra tout le reste du sang au pied de l’autel. ");
INSERT INTO francl_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Il enlèvera toute la graisse, comme on enlève la graisse de l’agneau dans le sacrifice pacifique, et le prêtre la fera fumer sur l’autel, sur les sacrifices faits par le feu à Yahweh. C’est ainsi que le prêtre fera l’expiation pour cet homme, pour le péché qu’il a commis, et il lui sera pardonné. ");
INSERT INTO francl_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Si quelqu’un pèche en ce que, après avoir entendu l’adjuration du juge, en sa qualité de témoin, il ne déclare pas ce qu’il a vu, ou ce qu’il sait, il portera son iniquité. ");
INSERT INTO francl_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Si quelqu’un, sans s’en apercevoir, touche une chose impure, soit le cadavre d’une bête sauvage impure, soit le cadavre d’un animal domestique impur, soit le cadavre d’un reptile impur, et qu’il se trouve ainsi lui-même impur, il aura contracté une faute ; ");
INSERT INTO francl_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","de même si, sans y prendre garde, il touche une impureté humaine quelconque par laquelle on puisse être souillé, et qu’il s’en aperçoive plus tard, il aura contracté une faute. ");
INSERT INTO francl_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Si quelqu’un, parlant à la légère, jure de faire du mal ou du bien, quoi que ce soit qu’il affirme ainsi par un serment inconsidéré, et que, ne l’ayant pas remarqué d’abord, il s’en aperçoive plus tard, il aura en l’une de ces choses contracté une faute. ");
INSERT INTO francl_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Celui donc qui se sera rendu coupable dans l’une de ces trois choses, confessera ce en quoi il a péché. ");
INSERT INTO francl_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Il amènera à Yahweh, comme expiation, pour le péché qu’il a commis, une femelle de menu bétail, brebis ou chèvre, en sacrifice pour le péché, et le prêtre fera pour lui l’expiation de son péché. ");
INSERT INTO francl_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","S’il n’a pas le moyen de se procurer une brebis ou une chèvre, il offrira à Yahweh, comme expiation pour son péché, deux tourterelles ou deux jeunes pigeons, l’un comme sacrifice pour le péché, l’autre comme holocauste. ");
INSERT INTO francl_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Il les apportera au prêtre, qui sacrifiera en premier lieu la victime pour le péché. Le prêtre lui brisera la tête près de la nuque, sans la détacher ; ");
INSERT INTO francl_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","il fera l’aspersion du sang de la victime pour le péché contre la paroi de l’autel et le reste du sang sera exprimé au pied de l’autel ; c’est un sacrifice pour le péché. ");
INSERT INTO francl_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Il fera de l’autre oiseau un holocauste, d’après les rites de ce sacrifice. C’est ainsi que le prêtre fera pour cet homme l’expiation du péché qu’il a commis, et il lui sera pardonné. ");
INSERT INTO francl_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","S’il n’a pas de quoi se procurer deux tourterelles ou deux jeunes pigeons, il apportera en offrande pour son péché un dixième d’épha de fleur de farine comme sacrifice pour le péché ; il ne mettra pas d’huile dessus, et il n’y ajoutera pas d’encens, car c’est un sacrifice pour le péché. ");
INSERT INTO francl_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Il l’apportera au prêtre, et le prêtre en prendra une poignée en souvenir et la fera fumer sur l’autel, sur les sacrifices faits par le feu à Yahweh ; c’est un sacrifice pour le péché. ");
INSERT INTO francl_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","C’est ainsi que le prêtre fera l’expiation pour cet homme, pour le péché qu’il a commis à l’égard de l’une de ces trois choses, et il lui sera pardonné. Ce qui restera appartiendra au prêtre, comme dans l’oblation. » ");
INSERT INTO francl_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","« Si quelqu’un commet une infidélité et pèche par erreur en retenant quelque chose des saintes offrandes de Yahweh il amènera à Yahweh en sacrifice de réparation, un bélier sans défaut, pris du troupeau, estimé par toi en sicles d’argent, selon le sicle du sanctuaire ; ce sera un sacrifice de réparation. ");
INSERT INTO francl_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Et ce dont il a fait tort au sanctuaire, il le restituera, avec un cinquième en plus, et il le donnera au prêtre. Et le prêtre fera pour lui l’expiation avec le bélier offert en sacrifice de réparation, et il lui sera pardonné. ");
INSERT INTO francl_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Si quelqu’un pèche en faisant sans le savoir une de toutes les choses que Yahweh a défendu de faire, il sera coupable et portera son iniquité. ");
INSERT INTO francl_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Il amènera au prêtre, en sacrifice de réparation, un bélier sans défaut, pris du troupeau d’après ton estimation. Et le prêtre fera pour lui l’expiation pour le péché qu’il a commis par erreur, et qu’il n’a pas connu, et il lui sera pardonné. ");
INSERT INTO francl_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","C’est un sacrifice de réparation ; cet homme était certainement coupable devant Yahweh. » ");
INSERT INTO francl_vpl VALUES ("LV5_20","004_5_20","LEV","5","20","20","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("LV5_21","004_5_21","LEV","5","21","21","« Si quelqu’un pèche et commet une infidélité envers Yahweh, en mentant à son prochain au sujet d’un dépôt, d’un gage mis entre ses mains, d’une chose volée, ou en faisant violence à son prochain ; ");
INSERT INTO francl_vpl VALUES ("LV5_22","004_5_22","LEV","5","22","22","en mentant à propos d’un objet perdu qu’il a trouvé, en faisant un faux serment au sujet de l’une des choses dans lesquelles l’homme peut pécher : ");
INSERT INTO francl_vpl VALUES ("LV5_23","004_5_23","LEV","5","23","23","quand il aura péché ainsi et se sera rendu coupable, il restituera la chose volée ou ravie par violence, le dépôt qui lui avait été confié, l’objet perdu qu’il a trouvé, ");
INSERT INTO francl_vpl VALUES ("LV5_24","004_5_24","LEV","5","24","24","ou tout objet au sujet duquel il a fait un faux serment. Il le restituera en son entier, avec un cinquième de la valeur en sus, et le remettra à son propriétaire, le jour même où il offrira son sacrifice de réparation. ");
INSERT INTO francl_vpl VALUES ("LV5_25","004_5_25","LEV","5","25","25","Il amènera au prêtre pour être offert à Yahweh en sacrifice de réparation un bélier sans défaut, pris du troupeau d’après ton estimation, ");
INSERT INTO francl_vpl VALUES ("LV5_26","004_5_26","LEV","5","26","26","Et le prêtre fera pour lui l’expiation devant Yahweh, et il lui sera pardonné, de quelque faute qu’il se soit rendu coupable. » ");
INSERT INTO francl_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","« Donne cet ordre à Aaron et à ses fils, et dis-leur : Voici la loi de l’holocauste. L’holocauste brûlera sur le foyer de l’autel toute la nuit jusqu’au matin, et le feu de l’autel y sera tenu allumé. ");
INSERT INTO francl_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","Chaque matin, le prêtre, ayant revêtu sa tunique de lin et mis des caleçons de lin sur sa chair, enlèvera la cendre laissée par le feu qui aura consumé l’holocauste sur l’autel, et la déposera à côté de l’autel ; ");
INSERT INTO francl_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","puis il quittera ses vêtements et en mettra d’autres pour porter la cendre hors du camp, en un lieu pur. ");
INSERT INTO francl_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","Le feu sur l’autel y sera entretenu sans qu’il s’éteigne ; le prêtre y allumera du bois chaque matin, arrangera dessus l’holocauste, et y fera fumer la graisse des sacrifices pacifiques. ");
INSERT INTO francl_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Un feu perpétuel doit brûler sur l’autel sans s’éteindre. ");
INSERT INTO francl_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Voici la loi de l’oblation : les fils d’Aaron la présenteront devant Yahweh, devant l’autel. ");
INSERT INTO francl_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Le prêtre en prélèvera une poignée de fleur de farine avec son huile, et tout l’encens qui est sur l’oblation, et il fera fumer cela sur l’autel, en agréable odeur, comme souvenir à Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","Ce qui restera de l’oblation, Aaron et ses fils le mangeront ; ils le mangeront sans levain, en lieu saint, dans le parvis de la tente de réunion. ");
INSERT INTO francl_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","On ne le cuira pas avec du levain. C’est la part que je leur ai assignée de mes offrandes consumées par le feu. C’est une chose très sainte, comme le sacrifice pour le péché et comme le sacrifice de réparation. ");
INSERT INTO francl_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Tout mâle des enfants d’Aaron en mangera. C’est une loi perpétuelle pour vos descendants sur les offrandes faites par le feu à Yahweh. Quiconque y touchera sera saint. » ");
INSERT INTO francl_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","« Voici l’offrande qu’Aaron et ses fils feront à Yahweh le jour où il recevra l’onction : un dixième d’épha de fleur de farine, comme oblation perpétuelle, moitié le matin et moitié le soir. ");
INSERT INTO francl_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Elle sera préparée dans la poêle avec de l’huile ; tu l’apporteras quand elle sera frite, et tu l’offriras en morceaux, comme offrande divisée, d’agréable odeur à Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Le prêtre ayant reçu l’onction, qui lui succédera d’entre ses fils, fera aussi cette oblation : c’est une loi perpétuelle devant Yahweh ; elle montera tout entière en fumée. ");
INSERT INTO francl_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Toute offrande de prêtre sera consumée tout entière ; on ne la mangera pas. » ");
INSERT INTO francl_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","« Parle à Aaron et à ses fils, et dis-leur : Voici la loi du sacrifice pour le péché : c’est dans le lieu où l’on égorge l’holocauste que sera égorgée la victime pour le péché devant Yahweh : c’est une chose très sainte. ");
INSERT INTO francl_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Le prêtre qui offrira la victime pour le péché la mangera ; elle sera mangée en lieu saint, dans le parvis de la tente de réunion. ");
INSERT INTO francl_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","Quiconque en touchera la chair sera saint. S’il en rejaillit du sang sur un vêtement, la place où le sang aura rejailli, tu la laveras en lieu saint. ");
INSERT INTO francl_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Le vase de terre dans lequel elle aura cuit sera brisé ; si elle a cuit dans un vase d’airain, il sera nettoyé et rincé dans l’eau. ");
INSERT INTO francl_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Tout mâle parmi les prêtres en mangera : c’est une chose très sainte. ");
INSERT INTO francl_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Mais on ne mangera aucune victime pour le péché dont on doit porter le sang dans la tente de réunion pour faire l’expiation dans le sanctuaire : elle sera brûlée au feu. ");
INSERT INTO francl_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Voici la loi du sacrifice de réparation ; c’est une chose très sainte. ");
INSERT INTO francl_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","C’est dans le lieu où l’on égorge l’holocauste que sera égorgée la victime de réparation. On en répandra le sang sur l’autel tout autour. ");
INSERT INTO francl_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","On en offrira toute la graisse, la queue, la graisse qui enveloppe les entrailles, ");
INSERT INTO francl_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","les deux rognons avec la graisse qui les recouvre et qui tient à la région lombaire, et la taie du foie, qu’on détachera près des rognons. ");
INSERT INTO francl_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Le prêtre les fera fumer sur l’autel en sacrifice par le feu à Yahweh. C’est un sacrifice de réparation. ");
INSERT INTO francl_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Tout mâle parmi les prêtres en mangera la chair ; il la mangera en lieu saint : c’est une chose très sainte. ");
INSERT INTO francl_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Il en est du sacrifice de réparation comme du sacrifice pour le péché ; la loi est la même pour les deux : la victime appartiendra au prêtre qui fera l’expiation. ");
INSERT INTO francl_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Le prêtre qui offrira l’holocauste de quelqu’un aura pour lui la peau de l’holocauste qu’il a offert. ");
INSERT INTO francl_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Toute oblation cuite au four, et celle qui est préparée dans la casserole ou à la poêle appartiendra au prêtre qui l’aura offerte. ");
INSERT INTO francl_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Toute oblation pétrie à l’huile ou sèche sera pour tous les fils d’Aaron, qui en auront une part égale. ");
INSERT INTO francl_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Voici la loi du sacrifice pacifique qu’on offrira à Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Si on l’offre par reconnaissance, on offrira, avec la victime de reconnaissance, des gâteaux sans levain pétris à l’huile, des galettes sans levain arrosées d’huile, de la farine frite en gâteaux pétris à l’huile. ");
INSERT INTO francl_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","On ajoutera des gâteaux levés à l’offrande qu’on présentera avec la victime de reconnaissance de son sacrifice pacifique. ");
INSERT INTO francl_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","On présentera une pièce de chacune de ces offrandes prélevées pour Yahweh ; elle sera pour le prêtre qui aura fait l’aspersion du sang de la victime pacifique. ");
INSERT INTO francl_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","La chair de la victime de reconnaissance du sacrifice pacifique sera mangée le jour où on l’aura offerte ; on n’en laissera rien jusqu’au matin. ");
INSERT INTO francl_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Si la victime est offerte par suite d’un vœu ou comme offrande volontaire, la victime sera mangée le jour où on l’aura offerte, et ce qui en restera sera mangé le lendemain. ");
INSERT INTO francl_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Ce qui resterait encore de la chair de la victime le troisième jour sera consumé par le feu. ");
INSERT INTO francl_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Si un homme mange de la chair de son sacrifice pacifique le troisième jour, ce sacrifice ne sera pas agréé ; il n’en sera pas tenu compte à celui qui l’a offert ; ce sera une abomination, et quiconque en aura mangé portera son iniquité. ");
INSERT INTO francl_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","La chair qui a touché quelque chose d’impur ne se mangera pas ; elle sera consumée par le feu. Quant à la chair du sacrifice pacifique, tout homme pur pourra en manger. ");
INSERT INTO francl_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Mais celui qui, se trouvant en état d’impureté, aura mangé de la chair de la victime pacifique appartenant à Yahweh, celui-là sera retranché de son peuple. ");
INSERT INTO francl_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Et celui qui touchera quelque chose d’impur, souillure d’homme ou animal impur, ou toute autre abomination impure, et qui mangera de la chair de la victime pacifique appartenant à Yahweh, celui-là sera retranché de son peuple. » ");
INSERT INTO francl_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","« Parle aux enfants d’Israël et dis-leur : Vous ne mangerez pas de graisse de bœuf, de brebis, ni de chèvre. ");
INSERT INTO francl_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","La graisse d’un animal mort ou déchiré par une bête féroce pourra servir à un usage quelconque, mais vous n’en mangerez en aucune manière. ");
INSERT INTO francl_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Car quiconque mangera de la graisse des animaux que l’on offre à Yahweh en sacrifices faits par le feu, sera retranché de son peuple. ");
INSERT INTO francl_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Vous ne mangerez pas de sang ni d’oiseau, ni de quadrupède, dans tous les lieux que vous habiterez. ");
INSERT INTO francl_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Celui qui mangera d’un sang quelconque, celui-là sera retranché de son peuple. » ");
INSERT INTO francl_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","« Parle aux enfants d’Israël et dis-leur : Celui qui offrira à Yahweh sa victime pacifique apportera à Yahweh son offrande prélevée sur son sacrifice pacifique. ");
INSERT INTO francl_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Il apportera dans ses mains ce qui doit être offert par le feu à Yahweh : il apportera la graisse avec la poitrine, la poitrine pour la balancer devant Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Le prêtre fera fumer la graisse sur l’autel, et la poitrine sera pour Aaron et pour ses fils. ");
INSERT INTO francl_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Vous donnerez aussi au prêtre la cuisse droite comme offrande prélevée de vos victimes pacifiques. ");
INSERT INTO francl_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Celui des fils d’Aaron qui offrira le sang et la graisse des victimes pacifiques aura la cuisse droite pour sa part. ");
INSERT INTO francl_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Car j’ai pris sur les sacrifices pacifiques des enfants d’Israël la poitrine à balancer et l’épaule prélevée, et je les donne au prêtre Aaron et à ses fils comme une redevance perpétuelle imposée aux enfants d’Israël. ");
INSERT INTO francl_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","C’est là le droit de l’onction d’Aaron et le droit de l’onction de ses fils sur les sacrifices faits par le feu à Yahweh, à partir du jour où on les présentera pour être prêtres au service de Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","C’est ce que Yahweh a ordonné aux enfants d’Israël de leur donner depuis le jour de leur onction ; ce sera une redevance perpétuelle parmi leurs descendants. » ");
INSERT INTO francl_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Telle est la loi de l’holocauste, de l’oblation, du sacrifice pour le péché, du sacrifice de réparation, de l’installation et du sacrifice pacifique. ");
INSERT INTO francl_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Yahweh la prescrivit à Moïse sur la montagne de Sinaï, le jour où il ordonna aux enfants d’Israël de présenter leurs offrandes à Yahweh dans le désert de Sinaï. ");
INSERT INTO francl_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","« Prends Aaron et ses fils avec lui, les vêtements, l’huile d’onction, le taureau pour le sacrifice pour le péché, les deux béliers et la corbeille de pains sans levain, ");
INSERT INTO francl_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","et convoque toute l’assemblée à l’entrée de la tente de réunion. » ");
INSERT INTO francl_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Moïse fit ce que Yahweh lui avait ordonné ; et l’assemblée s’étant réunie à l’entrée de la tente de réunion, ");
INSERT INTO francl_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Moïse dit à l’assemblée : « Voici ce que Yahweh a ordonné de faire. » ");
INSERT INTO francl_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Moïse fit approcher Aaron et ses fils, et il les lava avec de l’eau. ");
INSERT INTO francl_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Il mit à Aaron la tunique, le ceignit de la ceinture, le revêtit de la robe, et il plaça sur lui l’éphod, ");
INSERT INTO francl_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","qu’il serra avec la ceinture de l’éphod et il le lui attacha. Il lui mit le pectoral et il joignit au pectoral l’Urim et le Thummim ; ");
INSERT INTO francl_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","et, ayant posé la tiare sur sa tête, il plaça sur le devant de la tiare la lame d’or, diadème sacré, comme Yahweh l’avait ordonné à Moïse. ");
INSERT INTO francl_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Et Moïse prit l’huile d’onction, il oignit la Demeure et toutes les choses qui étaient dedans, et il les consacra. ");
INSERT INTO francl_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Il en aspergea sept fois l’autel, et il oignit l’autel avec tous ses ustensiles, ainsi que le bassin avec sa base, pour les consacrer. ");
INSERT INTO francl_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Il versa de l’huile d’onction sur la tête d’Aaron, et l’oignit pour le consacrer. ");
INSERT INTO francl_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Moïse fit aussi approcher les fils d’Aaron ; il les revêtit de tuniques, les ceignit de ceintures et leur attacha des mitres, comme Yahweh l’avait ordonné à Moïse. ");
INSERT INTO francl_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Il fit approcher le taureau du sacrifice pour le péché, et Aaron et ses fils posèrent leurs mains sur la tête du taureau du sacrifice pour le péché. ");
INSERT INTO francl_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Moïse l’égorgea, prit du sang, en mit avec son doigt sur les cornes de l’autel tout autour, et purifia l’autel ; il répandit le reste du sang au pied de l’autel, et le consacra en faisant sur lui l’expiation. ");
INSERT INTO francl_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Il prit ensuite toute la graisse qui enveloppe les entrailles, la taie du foie et les deux rognons avec leur graisse, et il les fit fumer sur l’autel. ");
INSERT INTO francl_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Mais le taureau, sa peau, sa chair et ses excréments, il les brûla hors du camp, comme Yahweh l’avait ordonné à Moïse. ");
INSERT INTO francl_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Il fit approcher le bélier de l’holocauste, et Aaron et ses fils posèrent leurs mains sur la tête du bélier. ");
INSERT INTO francl_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","On l’égorgea et Moïse répandit le sang sur l’autel tout autour. ");
INSERT INTO francl_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Puis on coupa le bélier en morceaux, et Moïse fit fumer la tête, les morceaux et la graisse. ");
INSERT INTO francl_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","On lava dans l’eau les entrailles et les jambes, et Moïse fit fumer tout le bélier sur l’autel : c’était un holocauste d’agréable odeur, un sacrifice fait par le feu à Yahweh, comme Yahweh l’avait ordonné à Moïse. ");
INSERT INTO francl_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Il fit approcher l’autre bélier, le bélier d’installation. Aaron et ses fils ayant posé leurs mains sur la tête du bélier, ");
INSERT INTO francl_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Moïse égorgea le bélier, prit de son sang, et en mit sur le lobe de l’oreille droite d’Aaron, sur le pouce de sa main droite et sur le gros orteil de son pied droit. ");
INSERT INTO francl_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Il fit approcher les fils d’Aaron, mit du sang sur le lobe de leur oreille droite, sur le pouce de leur main droite et sur le gros orteil de leur pied droit ; puis il répandit le reste du sang sur l’autel tout autour. ");
INSERT INTO francl_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Il prit ensuite la graisse, la queue, toute la graisse qui couvre les entrailles, la taie du foie, les deux rognons avec leur graisse, et la cuisse droite ; ");
INSERT INTO francl_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","il prit aussi, de la corbeille de pains sans levain placée devant Yahweh, un gâteau sans levain, un gâteau de pain pétri à l’huile et une galette, et il les posa sur les graisses et sur la cuisse droite ; ");
INSERT INTO francl_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","et ayant mis toutes ces choses sur les mains d’Aaron et sur les mains de ses fils, il les balança en offrande devant Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Puis Moïse les ôta de dessus leurs mains, et les fit fumer sur l’autel, par-dessus l’holocauste ; car c’était un sacrifice d’installation, d’agréable odeur, sacrifice fait par le feu à Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Moïse prit la poitrine du bélier d’installation et la balança en offrande devant Yahweh : ce fut la portion de Moïse, comme Yahweh l’avait ordonné à Moïse. ");
INSERT INTO francl_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Moïse prit de l’huile d’onction et du sang qui était sur l’autel ; il en fit l’aspersion sur Aaron et sur ses vêtements, sur les fils d’Aaron et sur leurs vêtements, et il consacra ainsi Aaron et ses vêtements, ses fils et leurs vêtements avec lui. ");
INSERT INTO francl_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Moïse dit à Aaron et à ses fils : « Faites cuire la chair à l’entrée de la tente de réunion ; c’est là que vous la mangerez, avec le pain qui est dans la corbeille d’installation, comme je l’ai ordonné en disant : Aaron et ses fils la mangeront. ");
INSERT INTO francl_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Et ce qui restera de la chair et du pain, vous le brûlerez dans le feu. ");
INSERT INTO francl_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Pendant sept jours vous ne sortirez pas de l’entrée de la tente de réunion, jusqu’à ce que soient accomplis les jours de votre installation ; car votre installation durera sept jours. ");
INSERT INTO francl_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Ce qui s’est fait aujourd’hui, Yahweh a ordonné de le faire durant sept jours afin de faire l’expiation pour vous. ");
INSERT INTO francl_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Vous resterez sept jours, jour et nuit, à l’entrée de la tente de réunion, et vous observerez les ordres de Yahweh, afin que vous ne mouriez pas ; car c’est là ce qui m’a été ordonné. » ");
INSERT INTO francl_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Aaron et ses fils firent toutes les choses que Yahweh avait commandées par Moïse. ");
INSERT INTO francl_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Le huitième jour, Moïse appela Aaron et ses fils, et les anciens d’Israël. ");
INSERT INTO francl_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Il dit à Aaron : « Prends un jeune veau pour le sacrifice pour le péché et un bélier pour l’holocauste, tous deux sans défaut, et offre-les devant Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Tu parleras aux enfants d’Israël, en disant : Prenez un bouc pour le sacrifice pour le péché ; un veau et un agneau âgés d’un an et sans défaut pour l’holocauste ; ");
INSERT INTO francl_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","un bœuf et un bélier pour le sacrifice pacifique, afin de les immoler devant Yahweh ; et une oblation pétrie à l’huile. Car aujourd’hui Yahweh vous apparaîtra. » ");
INSERT INTO francl_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Ils amenèrent devant la tente de réunion ce que Moïse avait commandé, et toute l’assemblée s’approcha et se tint devant Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Alors Moïse dit : « Faites ce que Yahweh vous ordonne, et la gloire de Yahweh vous apparaîtra. » ");
INSERT INTO francl_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Moïse dit à Aaron : « Approche-toi de l’autel ; offre ton sacrifice pour le péché et ton holocauste, et fais l’expiation pour toi et pour le peuple ; présente aussi l’offrande du peuple et fais l’expiation pour lui, comme Yahweh l’a ordonné. » ");
INSERT INTO francl_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Aaron s’approcha de l’autel et égorgea le veau du sacrifice pour le péché offert pour lui. ");
INSERT INTO francl_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Les fils d’Aaron lui ayant présenté le sang, il y trempa son doigt, en mit sur les cornes de l’autel et répandit le sang au pied de l’autel. ");
INSERT INTO francl_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Il fit fumer sur l’autel la graisse, les rognons et la taie du foie de la victime pour le péché, comme Yahweh l’avait ordonné à Moïse ; ");
INSERT INTO francl_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","mais la chair et la peau, il les brûla par le feu hors du camp. ");
INSERT INTO francl_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Il égorgea l’holocauste, et les fils d’Aaron lui ayant présenté le sang, il le répandit sur l’autel, tout autour. ");
INSERT INTO francl_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Ils lui présentèrent l’holocauste coupé en morceaux, avec la tête, et il les fit fumer sur l’autel. ");
INSERT INTO francl_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Il lava les entrailles et les jambes, et les fit fumer sur l’autel par-dessus l’holocauste. ");
INSERT INTO francl_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Il présenta ensuite l’offrande du peuple. Il prit le bouc du sacrifice pour le péché offert pour le peuple, et l’ayant égorgé, il l’offrit en expiation, comme il avait fait pour la première victime. ");
INSERT INTO francl_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","il offrit de même l’holocauste et le sacrifia suivant le rite. ");
INSERT INTO francl_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Il présenta l’oblation, en prit une poignée et la consuma sur l’autel, en sus de l’holocauste du matin. ");
INSERT INTO francl_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Enfin il égorgea le taureau et le bélier en sacrifice pacifique pour le peuple. Les fils d’Aaron lui présentèrent le sang, qu’il répandit sur l’autel tout autour ; ");
INSERT INTO francl_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","ainsi que les parties grasses du taureau et du bélier, la queue, la graisse qui enveloppe les entrailles, les rognons et la taie du foie ; ");
INSERT INTO francl_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","et ils placèrent les graisses sur les poitrines, et il fit fumer les graisses sur l’autel. ");
INSERT INTO francl_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Puis Aaron balança devant Yahweh les poitrines et la cuisse droite en offrande balancée, comme Moïse l’avait ordonné. ");
INSERT INTO francl_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Alors Aaron, élevant ses mains vers le peuple, le bénit ; et il descendit, après avoir offert le sacrifice pour le péché, l’holocauste et le sacrifice pacifique. ");
INSERT INTO francl_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Moïse et Aaron entrèrent dans la tente de réunion ; lorsqu’ils en sortirent, ils bénirent le peuple. Et la gloire de Yahweh apparut à tout le peuple, ");
INSERT INTO francl_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","et le feu, sortant de devant Yahweh, dévora sur l’autel l’holocauste et les graisses. Et tout le peuple le vit ; et ils poussèrent des cris de joie, et ils tombèrent sur leur face. ");
INSERT INTO francl_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Les fils d’Aaron, Nadab et Abiu, prirent chacun leur encensoir, y mirent du feu et, ayant posé du parfum dessus, ils apportèrent devant Yahweh un feu étranger, ce qu’il ne leur avait pas commandé. ");
INSERT INTO francl_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Alors un feu sortit de devant Yahweh et les dévora : ils moururent devant Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Et Moïse dit à Aaron : « C’est ce que Yahweh a déclaré, lorsqu’il a dit : Je serai sanctifié en ceux qui m’approchent, et je serai glorifié en présence de tout le peuple. » Aaron se tut. ");
INSERT INTO francl_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Et Moïse appela Misaël et Elisaphon, fils d’Oziel, oncle d’Aaron, et il leur dit : « Approchez-vous, emportez vos frères loin du sanctuaire, hors du camp. » ");
INSERT INTO francl_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Ils s’approchèrent et les emportèrent revêtus de leurs tuniques hors du camp, comme Moïse l’avait ordonné. ");
INSERT INTO francl_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Moïse dit à Aaron, à Eléazar et à Ithamar : « Vous ne laisserez pas flotter en désordre les cheveux de votre tête et vous ne déchirerez pas vos vêtements, de peur que vous ne mouriez, et que Yahweh ne s’irrite contre toute l’assemblée. Que vos frères, toute la maison d’Israël, pleurent sur l’embrasement que Yahweh a allumé. ");
INSERT INTO francl_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Pour vous, vous ne sortirez pas de l’entrée de la tente de réunion, de peur que vous ne mouriez ; car l’huile de l’onction de Yahweh est sur vous. » Ils firent ce que Moïse avait dit. ");
INSERT INTO francl_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Yahweh parla à Aaron, en disant : ");
INSERT INTO francl_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","« Tu ne boiras ni vin, ni boisson enivrante, toi et tes fils avec toi, lorsque vous entrerez dans la tente de réunion, afin que vous ne mouriez pas : c’est une loi perpétuelle parmi vos descendants, ");
INSERT INTO francl_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","et afin que vous sachiez discerner ce qui est saint de ce qui est profane, ce qui est pur de ce qui est impur, ");
INSERT INTO francl_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","et afin que vous puissiez enseigner aux enfants d’Israël toutes les lois que Yahweh leur a données par Moïse. ");
INSERT INTO francl_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Moïse dit à Aaron, à Eléazar et à Ithamar, les deux fils qui restaient à Aaron : « Prenez l’oblation qui reste des sacrifices faits par le feu à Yahweh, et mangez-la sans levain près de l’autel, car c’est une chose très sainte. ");
INSERT INTO francl_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Vous la mangerez dans un lieu saint : c’est ton droit et le droit de tes fils sur les offrandes faites par le feu à Yahweh ; c’est là ce qui m’a été ordonné. ");
INSERT INTO francl_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Vous mangerez aussi en lieu pur, toi, tes fils et tes filles avec toi, la poitrine qui aura été balancée et la cuisse qui aura été prélevée ; car ces morceaux vous sont donnés comme ton droit et le droit de tes fils sur les sacrifices pacifiques des enfants d’Israël. ");
INSERT INTO francl_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Ils apporteront, outre les graisses destinées à être consumées par le feu, la cuisse que l’on prélève et la poitrine que l’on balance, pour qu’elles soient balancées devant Yahweh ; elles seront pour toi et pour tes fils avec toi par une loi perpétuelle, comme Yahweh l’a ordonné. » ");
INSERT INTO francl_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Moïse s’enquit du bouc immolé pour le péché, et voici, il avait été brûlé. Alors, il s’irrita contre Eléazar et Ithamar, les fils qui restaient à Aaron, et il leur dit : ");
INSERT INTO francl_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","« Pourquoi n’avez-vous pas mangé la victime pour le péché dans le lieu saint ? Car c’est une chose très sainte, et Yahweh vous l’a donnée, afin que vous portiez l’iniquité de l’assemblée, afin que vous fassiez pour elle l’expiation devant Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Voici, le sang de la victime n’a pas été porté dans l’intérieur du sanctuaire ; vous deviez la manger dans un lieu saint, comme je l’ai commandé. » ");
INSERT INTO francl_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Aaron dit à Moïse : « Voici, ils ont offert aujourd’hui leur sacrifice pour le péché et leur holocauste devant Yahweh ; mais, après ce qui m’est arrivé, si j’avais mangé aujourd’hui la victime pour le péché, cela eût-il été agréable aux yeux de Yahweh ? » ");
INSERT INTO francl_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Moïse, ayant entendu ces paroles, il les eut pour agréables. ");
INSERT INTO francl_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Yahweh parla à Moïse et à Aaron, en leur disant : ");
INSERT INTO francl_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","« Parlez aux enfants d’Israël, et dites : Voici les animaux que vous mangerez parmi toutes les bêtes qui sont sur la terre : ");
INSERT INTO francl_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Tout animal qui a la corne divisée et le pied fourchu, et qui rumine, vous le mangerez. ");
INSERT INTO francl_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Mais vous ne mangerez pas de ceux qui ruminent seulement, ou qui ont seulement la corne divisée. Tel est le chameau, qui rumine, mais dont la corne n’est pas divisée : il sera impur pour vous. ");
INSERT INTO francl_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Telle la gerboise, qui rumine, mais qui n’a pas la corné divisée : elle sera impure pour vous. ");
INSERT INTO francl_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Tel le lièvre, qui rumine, mais qui n’a pas la corne divisée : il sera impur pour vous. ");
INSERT INTO francl_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Tel le porc, qui a la corne divisée et le pied fourchu, mais qui ne rumine pas : il sera impur pour vous. ");
INSERT INTO francl_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Vous ne mangerez pas de leur chair, et vous ne toucherez pas à leurs corps morts : ils seront impurs pour vous. ");
INSERT INTO francl_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Voici les animaux que vous mangerez parmi tous ceux qui sont dans les eaux : Tout ce qui a nageoires et écailles, dans les eaux, soit dans la mer, soit dans les rivières, vous le mangerez. ");
INSERT INTO francl_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Mais vous aurez en abomination tout ce qui n’a pas nageoires et écailles, dans les mers et dans les rivières, parmi tous les animaux qui se meuvent dans les eaux et parmi tous les êtres vivants qui s’y trouvent. ");
INSERT INTO francl_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Ils seront pour vous une abomination ; vous ne mangerez pas de leur chair, et vous tiendrez pour abominables leurs cadavres. ");
INSERT INTO francl_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Tout ce qui, dans les eaux, n’a pas de nageoires et d’écailles, vous l’aurez en abomination. ");
INSERT INTO francl_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Voici, parmi les oiseaux, ceux que vous aurez en abomination ; on ne les mangera pas, c’est chose abominable : l’aigle, l’orfraie et le vautour : ");
INSERT INTO francl_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","le milan et toute espèce de faucons ; ");
INSERT INTO francl_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","toute espèce de corbeaux ; ");
INSERT INTO francl_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","l’autruche, le chat-huant, la mouette et toute espèce d’éperviers ; ");
INSERT INTO francl_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","le hibou, le cormoran et la chouette ; ");
INSERT INTO francl_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","le cygne, le pélican et le gypaète ; ");
INSERT INTO francl_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","la cigogne, toute espèce de hérons ; la huppe et la chauve-souris. ");
INSERT INTO francl_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Tout insecte ailé qui marche sur quatre pattes, vous l’aurez en abomination. ");
INSERT INTO francl_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Mais, parmi tous les insectes ailés qui marchent sur quatre pattes, vous mangerez ceux qui ont des jambes au-dessus de leurs pattes, pour sauter sur la terre. ");
INSERT INTO francl_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Voici ceux d’entre eux que vous mangerez : toute espèce de sauterelles, toute espèce de solam, toute espèce de hargol, toute espèce de hagab. ");
INSERT INTO francl_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Toute autre bête ailée ayant quatre pattes, vous l’aurez en abomination. ");
INSERT INTO francl_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","Ceux-ci aussi vous rendront impurs : quiconque touchera leur corps mort sera impur jusqu’au soir, ");
INSERT INTO francl_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","et quiconque emportera quelque partie de leur corps mort lavera ses vêtements et sera impur jusqu’au soir. ");
INSERT INTO francl_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Tout animal qui a la corne divisée, mais qui n’a pas le pied fourchu et qui ne rumine pas, sera impur pour vous ; quiconque le touchera se rendra impur. ");
INSERT INTO francl_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Et parmi les animaux à quatre pieds, tout ce qui marche sur la plante des pieds vous sera impur : quiconque touchera leur corps mort sera impur jusqu’au soir ; ");
INSERT INTO francl_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","et quiconque portera leur corps mort lavera ses vêtements et sera impur jusqu’au soir. Ces animaux seront impurs pour vous. ");
INSERT INTO francl_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","Voici, parmi les petites bêtes qui rampent sur la terre, celles qui seront impures pour vous : la belette, la souris et toute espèce de lézards ; ");
INSERT INTO francl_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","la musaraigne, le caméléon, la salamandre, le lézard vert et la taupe. ");
INSERT INTO francl_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Tels sont ceux qui seront impurs pour vous parmi les reptiles : quiconque les touchera morts sera impur jusqu’au soir. ");
INSERT INTO francl_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Tout objet sur lequel il en tombera de morts sera souillé : ustensile de bois, vêtement, peau, sac, tout objet dont on fait usage ; on le mettra dans l’eau, et il restera souillé jusqu’au soir ; après quoi, il sera pur. ");
INSERT INTO francl_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","S’il en tombe quelque chose dans le milieu de tout vase de terre, tout ce qui sera dans le milieu du vase sera souillé, et vous briserez le vase. ");
INSERT INTO francl_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Tout aliment servant à la nourriture et préparé avec de l’eau, sera souillé ; toute boisson dont on fait usage, quel que soit le vase qui la contienne, sera souillée. ");
INSERT INTO francl_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Tout objet sur lequel tombera quelque chose de leur corps mort sera souillé ; le four et le vase avec son couvercle seront détruits ; ils seront souillés et vous les tiendrez pour souillés. ");
INSERT INTO francl_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Mais les sources et les citernes, où se forment les amas d’eau, resteront pures ; toutefois celui qui touchera le corps mort sera impur. ");
INSERT INTO francl_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","S’il tombe quelque chose de leur corps mort sur une semence qui doit être semée, la semence restera pure ; ");
INSERT INTO francl_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","mais si l’on a mis de l’eau sur la semence, et qu’il y tombe quelque chose de leur corps mort, vous la tiendrez pour souillée. ");
INSERT INTO francl_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","S’il meurt un des animaux qui vous servent de nourriture, celui qui touchera son cadavre sera impur jusqu’au soir. ");
INSERT INTO francl_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Celui qui mangera de son corps mort lavera ses vêtements et sera impur jusqu’au soir ; celui qui portera son corps mort, lavera ses vêtements et sera impur jusqu’au soir. ");
INSERT INTO francl_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Vous aurez en abomination tout reptile qui rampe sur la terre : on n’en mangera point. ");
INSERT INTO francl_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Vous ne mangerez d’aucun animal qui rampe sur la terre, soit de ceux qui se traînent sur le ventre, soit de ceux qui marchent sur quatre pieds ou sur un grand nombre de pieds ; car vous les aurez en abomination. ");
INSERT INTO francl_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Ne vous rendez pas abominables par tous ces reptiles qui rampent ; ne vous rendez pas impurs par eux ; vous seriez souillés par eux. ");
INSERT INTO francl_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Car je suis Yahweh, votre Dieu ; vous vous sanctifierez et vous serez saints, car je suis saint ; et vous ne vous souillerez pas par tous ces reptiles, qui rampent sur la terre. ");
INSERT INTO francl_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Car je suis Yahweh, qui vous ai fait monter du pays d’Égypte, pour être votre Dieu. Vous serez saints, car je suis saint. » ");
INSERT INTO francl_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Telle est la loi touchant les quadrupèdes, les oiseaux, tous les êtres vivants qui se meuvent dans les eaux, et tous les êtres qui rampent sur la terre, ");
INSERT INTO francl_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","afin que vous distinguiez entre ce qui est impur et ce qui est pur, entre l’animal qui se mange et celui qui ne se mange pas. ");
INSERT INTO francl_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","« Parle aux enfants d’Israël, et dis-leur : Quand une femme enfantera et mettra au monde un garçon, elle sera impure pendant sept jours ; elle sera impure comme aux jours de son indisposition menstruelle. ");
INSERT INTO francl_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Le huitième jour, l’enfant sera circoncis ; ");
INSERT INTO francl_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","mais elle restera encore trente-trois jours dans le sang de sa purification ; elle ne touchera aucune chose sainte et elle n’ira pas au sanctuaire, jusqu’à ce que les jours de sa purification soient accomplis. ");
INSERT INTO francl_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Si elle met au monde une fille, elle sera impure pendant deux semaines, comme à son indisposition menstruelle, et elle restera soixante-six jours dans le sang de sa purification. ");
INSERT INTO francl_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Lorsque les jours de sa purification seront accomplis, pour un fils ou une fille, elle présentera au prêtre, à l’entrée de la tente de réunion, un agneau d’un an en holocauste, et un jeune pigeon ou une tourterelle en sacrifice pour le péché. ");
INSERT INTO francl_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Le prêtre les offrira devant Yahweh, et fera pour elle l’expiation, et elle sera pure du flux de son sang. Telle est la loi pour la femme qui met au monde soit un fils soit une fille. ");
INSERT INTO francl_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Si elle n’a pas de quoi se procurer un agneau, qu’elle prenne deux tourterelles ou deux jeunes pigeons, l’un pour l’holocauste, l’autre pour le sacrifice pour le péché ; et le prêtre fera pour elle l’expiation, et elle sera pure. » ");
INSERT INTO francl_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Yahweh parla à Moïse et à Aaron en disant : ");
INSERT INTO francl_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","« Quand un homme aura sur la peau de sa chair une tumeur, une dartre ou une tache blanche, et qu’il viendra ainsi sur la peau de sa chair une plaie de lèpre, on l’amènera à Aaron, le prêtre, ou à l’un de ses fils qui sont prêtres. ");
INSERT INTO francl_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Le prêtre examinera la plaie qui est sur la peau de la chair : si le poil de la plaie est devenu blanc et que la plaie paraisse plus profonde que la peau de la chair, c’est une plaie de lèpre : le prêtre, ayant examiné cet homme, le déclarera impur. ");
INSERT INTO francl_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","S’il y a sur la peau de sa chair une tache blanche qui ne paraisse pas plus profonde que la peau, et que le poil ne soit pas devenu blanc, le prêtre séquestrera pendant sept jours celui qui a la plaie. ");
INSERT INTO francl_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Le septième jour le prêtre l’examinera : si la plaie lui paraît n’avoir pas fait de progrès, ne s’étant pas étendue sur la peau, le prêtre le séquestrera une seconde fois pendant sept jours. ");
INSERT INTO francl_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Le prêtre l’examinera une seconde fois le septième jour : si la plaie est devenue terne et ne s’est pas étendue sur la peau, le prêtre déclarera cet homme pur : c’est une dartre ; il lavera ses vêtements, et il sera pur. ");
INSERT INTO francl_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Mais si la dartre s’est étendue sur la peau, après qu’il s’est montré au prêtre pour être déclaré pur, il se montrera une seconde fois au prêtre. ");
INSERT INTO francl_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Le prêtre l’examinera et, si la dartre s’est étendue sur la peau, le prêtre le déclarera impur : c’est la lèpre. ");
INSERT INTO francl_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Lorsqu’il y aura sur un homme une plaie de lèpre, on l’amènera au prêtre. ");
INSERT INTO francl_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Le prêtre l’examinera. Et voici, il y a sur la peau une tumeur blanche, et cette tumeur a fait blanchir le poil, et il y a trace de chair vive dans la tumeur ; ");
INSERT INTO francl_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","c’est une lèpre invétérée dans la peau de sa chair : le prêtre le déclarera impur ; il ne l’enfermera pas, car cet homme est impur. ");
INSERT INTO francl_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Mais si la lèpre s’est épanouie sur la peau et couvre toute la peau de celui qui a la plaie, depuis la tête jusqu’aux pieds, selon tout ce que voient les yeux du prêtre, ");
INSERT INTO francl_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","le prêtre l’examinera, et si la lèpre couvre tout le corps, il déclarera pur celui qui a la plaie : il est devenu tout entier blanc ; il est pur. ");
INSERT INTO francl_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Mais le jour où l’on apercevra en lui de la chair vive, il sera impur ; ");
INSERT INTO francl_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","quand le prêtre aura vu la chair vive, il le déclarera impur ; la chair vive est impure, c’est la lèpre. ");
INSERT INTO francl_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Si la chair vive change et devient blanche, il ira vers le prêtre. ");
INSERT INTO francl_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Le prêtre l’examinera, et si la plaie est devenue blanche, le prêtre déclarera pur celui qui a la plaie : il est pur. ");
INSERT INTO francl_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Lorsqu’un homme aura eu sur son corps, sur sa peau, un ulcère, et que, cet ulcère étant guéri, ");
INSERT INTO francl_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","il y aura, à la place de l’ulcère, une tumeur blanche ou une tache d’un blanc rougeâtre, cet homme se montrera au prêtre. ");
INSERT INTO francl_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Le prêtre l’examinera. Si la tache paraît plus enfoncée que la peau, et que le poil y soit devenu blanc, le prêtre le déclarera impur : c’est une plaie de lèpre qui a fait éruption dans l’ulcère. ");
INSERT INTO francl_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Mais si le prêtre voit qu’il n’y a pas de poil blanc dans la tache, que celle-ci n’est pas plus enfoncée que la peau et qu’elle est devenue pâle, il séquestrera cet homme pendant sept jours. ");
INSERT INTO francl_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Si, durant ce temps, la tache s’est étendue sur la peau, le prêtre le déclarera impur : c’est une plaie de lèpre. ");
INSERT INTO francl_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Si au contraire la tache est restée à sa place, sans s’étendre, c’est la cicatrice de l’ulcère : le prêtre le déclarera pur. ");
INSERT INTO francl_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Lorsqu’un homme aura eu sur le corps, sur la peau, une brûlure faite par le feu, s’il se forme sur la trace de la brûlure une tache blanche ou d’un blanc rougeâtre, ");
INSERT INTO francl_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","le prêtre l’examinera. Si le poil est devenu blanc dans la tache et qu’elle paraisse plus profonde que la peau, c’est la lèpre, elle a fait éruption dans la brûlure ; le prêtre déclarera cet homme impur ; c’est une plaie de lèpre. ");
INSERT INTO francl_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Mais si le prêtre voit qu’il n’y a pas de poil blanc dans la tache, qu’elle n’est pas plus enfoncée que la peau et qu’elle est devenue pâle, il séquestrera cet homme pendant sept jours. ");
INSERT INTO francl_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Le prêtre l’examinera le septième jour. Si la tache s’est étendue sur la peau, le prêtre le déclarera impur : c’est une plaie de lèpre. ");
INSERT INTO francl_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Mais si la tache est restée à la même place, sans s’étendre sur la peau, et qu’elle soit devenue pâle, c’est la tumeur de la brûlure ; le prêtre le déclarera pur, car c’est la cicatrice de la brûlure. ");
INSERT INTO francl_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Lorsqu’un homme ou une femme aura une plaie à la tête ou au menton, le prêtre examinera la plaie. ");
INSERT INTO francl_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","Si elle paraît plus profonde que la peau, et qu’il y ait du poil jaunâtre et grêle, le prêtre déclarera cet homme impur : c’est le nétheq, c’est la lèpre de la tête ou du menton. ");
INSERT INTO francl_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Si le prêtre voit que la plaie du nétheq ne paraît pas plus profonde que la peau, sans pourtant qu’il y ait poil noir, le prêtre séquestrera pendant sept jours celui qui a la plaie du nétheq. ");
INSERT INTO francl_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Le septième jour, le prêtre examinera la plaie. Si le nétheq ne s’est pas étendu, qu’il ne s’y trouve aucun poil jaunâtre et que le nétheq ne paraisse pas plus profond que la peau, ");
INSERT INTO francl_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","celui qui a le nétheq se rasera, mais il ne rasera pas l’endroit de la plaie, et le prêtre le séquestrera une deuxième fois pendant sept jours. ");
INSERT INTO francl_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Le septième jour, le prêtre examinera le nétheq : si le nétheq ne s’est pas étendu sur la peau et qu’il ne paraisse pas plus profond que la peau, le prêtre déclarera cet homme pur : il lavera ses vêtements, et il sera pur. ");
INSERT INTO francl_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Si, cependant, après qu’il a été déclaré pur, le nétheq s’étend sur la peau, ");
INSERT INTO francl_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","le prêtre l’examinera ; et si le nétheq s’est étendu sur la peau, le prêtre n’aura pas à rechercher s’il y a du poil jaunâtre : l’homme est impur. ");
INSERT INTO francl_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Mais si le nétheq lui paraît n’avoir pas fait de progrès, et qu’il y ait poussé des poils noirs, le nétheq est guéri : l’homme est pur, et le prêtre le déclarera pur. ");
INSERT INTO francl_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Lorsqu’un homme ou une femme aura sur la peau de sa chair des taches blanches, ");
INSERT INTO francl_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","le prêtre l’examinera. S’il y a sur la peau de sa chair des taches d’un blanc pâle, c’est un exanthème qui a poussé sur la peau : il est pur. ");
INSERT INTO francl_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","Lorsqu’un homme a perdu ses cheveux sur la tête, il est chauve, mais il est pur. ");
INSERT INTO francl_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Si ses cheveux sont tombés du côté de la face, il a le front chauve, mais il est pur. ");
INSERT INTO francl_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Mais si, dans la partie chauve de devant ou de derrière, il se trouve une plaie d’un blanc rougeâtre, c’est la lèpre qui a fait éruption dans la partie chauve de derrière ou de devant. ");
INSERT INTO francl_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Le prêtre l’examinera. Si la plaie est une tumeur d’un blanc rougeâtre dans la partie chauve de derrière ou de devant, ayant l’aspect d’une lèpre de la peau de la chair, ");
INSERT INTO francl_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","c’est un homme lépreux, il est impur : le prêtre le déclarera impur : c’est à la tête qu’est sa plaie de lèpre. ");
INSERT INTO francl_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Le lépreux, atteint de la plaie, portera ses vêtements déchirés et laissera flotter ses cheveux, il se couvrira la barbe et criera : Impur ! impur ! ");
INSERT INTO francl_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Aussi longtemps que durera sa plaie, il sera impur. Il est impur ; il habitera seul ; sa demeure sera hors du camp. ");
INSERT INTO francl_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Lorsque, sur un vêtement, il y aura une plaie de lèpre, sur un vêtement de lin ou sur un vêtement de laine, ");
INSERT INTO francl_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","au fil de lin ou de laine destiné à la chaîne ou à la trame, à une peau ou à quelque ouvrage fait de peau, ");
INSERT INTO francl_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","si la plaie est verdâtre ou rougeâtre sur le vêtement, sur la peau, sur le fil destiné à la chaîne ou à la trame, sur tout objet fait de peau, c’est une plaie de lèpre ; on la montrera au prêtre. ");
INSERT INTO francl_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Le prêtre, après avoir considéré la plaie, enfermera pendant sept jours l’objet qui a la plaie. ");
INSERT INTO francl_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Le septième jour, il examinera la plaie : si la plaie s’est étendue sur le vêtement, sur le fil destiné à la chaîne ou à la trame, sur la peau ou sur un ouvrage quelconque qui est fait de peau, c’est une plaie de lèpre maligne ; l’objet est impur. ");
INSERT INTO francl_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Il brûlera le vêtement, le fil de lin ou de laine destiné à la chaîne ou à la trame, l’objet quelconque de peau sur lequel se trouve la plaie, car c’est une lèpre maligne : l’objet sera brûlé au feu. ");
INSERT INTO francl_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Mais si le prêtre voit que la plaie ne s’est pas étendue sur le vêtement, sur le fil destiné à la chaîne ou à la trame, sur tout objet fait de peau, ");
INSERT INTO francl_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","il fera laver l’objet qui a la plaie, et il l’enfermera une seconde fois pendant sept jours. ");
INSERT INTO francl_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Le prêtre examinera la plaie, sept jours après qu’elle aura été lavée. Si elle n’a pas changé d’aspect et ne s’est pas étendue, l’objet est impur : tu le consumeras par le feu ; la lèpre en a rongé l’endroit ou l’envers. ");
INSERT INTO francl_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Mais si le prêtre voit que la plaie, sept jours après avoir été lavée, est devenue pâle, il l’arrachera du vêtement, de la peau, ou du fil destiné à la chaîne ou à la trame. ");
INSERT INTO francl_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Si elle reparaît ensuite sur le vêtement, sur le fil destiné à la chaîne ou à la trame, ou sur tout objet fait de peau, c’est une éruption de lèpre ; tu consumeras par le feu l’objet atteint par la plaie. ");
INSERT INTO francl_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Mais le vêtement, le fil pour la chaîne ou la trame, tout objet fait de peau que tu auras lavé et d’où la plaie aura disparu, sera lavé une seconde fois et il sera pur. ");
INSERT INTO francl_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Telle est la loi sur la plaie de la lèpre qui attaque les vêtements de laine ou de lin, le fil pour la chaîne ou pour la trame, tout objet fait de peau, pour déclarer ces choses pures ou impures. » ");
INSERT INTO francl_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","« Voici quelle sera la loi concernant le lépreux, pour le jour de sa purification. On l’amènera au prêtre, ");
INSERT INTO francl_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","et le prêtre, étant sorti du camp, l’examinera. Si le lépreux est guéri de la plaie de lèpre, ");
INSERT INTO francl_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","le prêtre ordonnera que l’on prenne pour celui qui doit être purifié deux oiseaux vivants et purs, du bois de cèdre, du cramoisi et de l’hysope. ");
INSERT INTO francl_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Le prêtre fera égorger l’un des oiseaux au-dessus d’un vase de terre, sur de l’eau vive. ");
INSERT INTO francl_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Puis, ayant pris l’oiseau vivant, le bois de cèdre, le cramoisi et l’hysope, il les trempera, ainsi que l’oiseau vivant, dans le sang de l’oiseau égorgé sur l’eau vive. ");
INSERT INTO francl_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Il en aspergera sept fois celui qui doit être purifié de la lèpre, il le déclarera pur et lâchera dans les champs l’oiseau vivant. ");
INSERT INTO francl_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Celui qui se purifie lavera ses vêtements, rasera tout son poil et se baignera dans l’eau ; et il sera pur. Ensuite il pourra entrer dans le camp, mais il restera sept jours hors de sa tente. ");
INSERT INTO francl_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Le septième jour, il rasera tout son poil, ses cheveux, sa barbe, ses sourcils, il rasera tout son poil ; il lavera ses vêtements et baignera son corps dans l’eau, et il sera pur. ");
INSERT INTO francl_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Le huitième jour, il prendra deux agneaux sans défaut et une brebis d’un an sans défaut, trois dixièmes d’épha de fleur de farine pétrie à l’huile, en oblation, et un log d’huile. ");
INSERT INTO francl_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Le prêtre qui fait la purification présentera l’homme qui se purifie et toutes ces choses devant Yahweh, à l’entrée de la tente de réunion. ");
INSERT INTO francl_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Le prêtre prendra l’un des agneaux, et l’offrira en sacrifice de réparation, ainsi que le log d’huile ; il les balancera en offrande balancée devant Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Il immolera l’agneau dans le lieu où l’on immole les victimes pour le péché et l’holocauste, savoir, dans le lieu saint ; car dans le sacrifice de réparation, comme dans le sacrifice pour le péché, la victime appartient au prêtre : c’est une chose très sainte. ");
INSERT INTO francl_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Le prêtre, ayant pris du sang du sacrifice de réparation, en mettra sur le lobe de l’oreille droite de celui qui se purifie, sur le pouce de sa main droite et sur le gros orteil de son pied droit. ");
INSERT INTO francl_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Le prêtre prendra le log d’huile, et il en versera dans le creux de sa main gauche. ");
INSERT INTO francl_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Le prêtre trempera le doigt de sa main droite dans l’huile qui est dans le creux de sa main gauche, et fera avec le doigt sept fois l’aspersion de l’huile devant Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Puis, de l’huile qui lui reste dans la main, le prêtre en mettra sur le lobe de l’oreille droite de celui qui se purifie, sur le pouce de sa main droite et sur le gros orteil de son pied droit, par-dessus le sang de la victime de réparation. ");
INSERT INTO francl_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Ce qui lui reste d’huile dans la main, le prêtre le mettra sur la tête de celui qui se purifie ; et le prêtre fera pour lui l’expiation devant Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Ensuite le prêtre offrira le sacrifice pour le péché, et il fera l’expiation pour celui qui se purifie de sa souillure. Enfin, ayant égorgé l’holocauste, ");
INSERT INTO francl_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","le prêtre offrira sur l’autel l’holocauste avec l’oblation ; et il fera l’expiation pour cet homme, et il sera pur. ");
INSERT INTO francl_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","S’il est pauvre et que ses moyens soient limités, il prendra un seul agneau qui sera offert en sacrifice de réparation, en offrande balancée, pour faire l’expiation pour lui. Il prendra un seul dixième d’épha de fleur de farine pétrie à l’huile pour l’oblation, et un log d’huile ; ");
INSERT INTO francl_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","ainsi que deux tourterelles ou deux jeunes pigeons, selon ses moyens, l’un pour le sacrifice pour le péché, l’autre pour l’holocauste. ");
INSERT INTO francl_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Le huitième jour, il les apportera au prêtre pour sa purification, à l’entrée de la tente de réunion, devant Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Le prêtre prendra l’agneau pour le sacrifice de réparation, et le log d’huile, et les balancera devant Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Et, après avoir immolé l’agneau du sacrifice de réparation, le prêtre prendra du sang du sacrifice de réparation et en mettra sur le lobe de l’oreille droite de celui qui se purifie, sur le pouce de sa main droite et sur le gros orteil de son pied droit. ");
INSERT INTO francl_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Le prêtre versera ensuite de l’huile dans le creux de sa main gauche. ");
INSERT INTO francl_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","Le prêtre fera avec le doigt de sa main droite l’aspersion de l’huile qui est dans sa main gauche, sept fois devant Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Le prêtre mettra de l’huile qui est dans sa main sur le lobe de l’oreille droite de celui qui se purifie, sur le pouce de sa main droite et sur le gros orteil de son pied droit, à la place où il a mis du sang de la victime de réparation. ");
INSERT INTO francl_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Ce qui lui restera d’huile dans la main, le prêtre le mettra sur la tête de celui qui se purifie, afin de faire pour lui l’expiation devant Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Puis il offrira l’une des tourterelles ou l’un des jeunes pigeons qu’il aura pu se procurer, ");
INSERT INTO francl_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","l’un en sacrifice pour le péché, l’autre en holocauste, avec oblation ; le prêtre fera ainsi, pour celui qui se purifie, l’expiation devant Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Telle est la loi pour la purification de celui qui a une plaie de lèpre et dont les moyens sont limités. » ");
INSERT INTO francl_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Yahweh parla à Moïse et à Aaron, en disant : ");
INSERT INTO francl_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","« Lorsque vous serez entrés dans le pays de Canaan, dont je vous donne la possession, si je mets la plaie de lèpre sur une maison du pays que vous posséderez, ");
INSERT INTO francl_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","le propriétaire de la maison ira le déclarer au prêtre, et dira : J’aperçois comme une plaie de lèpre à ma maison. ");
INSERT INTO francl_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Le prêtre, avant d’y entrer pour examiner la plaie, fera vider la maison, afin que tout ce qui s’y trouve ne devienne pas impur ; après quoi, le prêtre entrera pour examiner la maison. ");
INSERT INTO francl_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Le prêtre examinera la plaie. Si la plaie qui est aux murs de la maison présente des cavités verdâtres ou rougeâtres, paraissant enfoncées dans le mur, ");
INSERT INTO francl_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","le prêtre sortira de la maison jusqu’à la porte de la maison, et il fera fermer la maison pour sept jours. ");
INSERT INTO francl_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Le prêtre y retournera le septième jour. S’il voit que la plaie s’est étendue sur les murs de la maison, ");
INSERT INTO francl_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","il ordonnera qu’on enlève les pierres atteintes de la plaie, et qu’on les jette hors de la ville, dans un lieu impur. ");
INSERT INTO francl_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Il fera racler toute la maison à l’intérieur, et l’on versera hors de la ville, dans un lieu impur, la poussière qu’on aura raclée. ");
INSERT INTO francl_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","On prendra d’autres pierres que l’on mettra à la place des premières, et on prendra d’autre mortier pour recrépir la maison. ");
INSERT INTO francl_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Si la plaie fait de nouveau éruption dans la maison, après qu’on aura enlevé les pierres, raclé et recrépi la maison, ");
INSERT INTO francl_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","le prêtre y retournera et l’examinera. Si la plaie s’est étendue dans la maison, c’est une lèpre maligne dans la maison : elle est impure. ");
INSERT INTO francl_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","On démolira la maison, les pierres, le bois et tout le mortier de la maison, et l’on transportera ces choses hors de la ville, dans un lieu impur. ");
INSERT INTO francl_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Celui qui sera entré dans la maison pendant tout le temps qu’elle a été déclarée close, sera impur jusqu’au soir. ");
INSERT INTO francl_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Celui qui aura couché dans la maison lavera ses vêtements. Celui qui aura mangé dans la maison lavera aussi ses vêtements. ");
INSERT INTO francl_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Mais si le prêtre, étant retourné dans la maison, voit que la plaie ne s’est pas étendue après que la maison a été recrépie, il déclarera la maison pure, car la plaie est guérie. ");
INSERT INTO francl_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Il prendra, pour purifier la maison, deux oiseaux, du bois de cèdre, du cramoisi et de l’hysope ; ");
INSERT INTO francl_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","puis il immolera l’un des oiseaux sur un vase de terre, sur de l’eau vive. ");
INSERT INTO francl_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Et ayant pris le bois de cèdre, l’hysope, le cramoisi et l’oiseau vivant, il les trempera dans le sang de l’oiseau immolé et dans l’eau vive, et il en aspergera sept fois la maison. ");
INSERT INTO francl_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Il purifiera la maison avec le sang de l’oiseau, avec l’eau vive, avec l’oiseau vivant, avec le bois de cèdre, l’hysope et le cramoisi. ");
INSERT INTO francl_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Et il lâchera l’oiseau vivant hors de la ville, dans les champs. C’est ainsi qu’il fera l’expiation pour la maison, et elle sera pure. ");
INSERT INTO francl_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Telle est la loi pour toute plaie de lèpre et pour le nétheq, ");
INSERT INTO francl_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","pour la lèpre des vêtements et des maisons, ");
INSERT INTO francl_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","pour les tumeurs, les dartres et les taches ; ");
INSERT INTO francl_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","elle fait connaître quand une chose est impure et quand une chose est pure. Telle est la loi concernant la lèpre. » ");
INSERT INTO francl_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Yahweh parla à Moïse et à Aaron, en disant : ");
INSERT INTO francl_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","« Parlez aux enfants d’Israël, et dites-leur : Tout homme qui a une gonorrhée est impur par là. ");
INSERT INTO francl_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Et telle est la souillure provenant de son flux : soit que sa chair laisse couler son flux ou que sa chair retienne son flux, il y a souillure. ");
INSERT INTO francl_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Tout lit sur lequel couchera celui qui a un flux sera impur ; tout objet sur lequel il s’assiéra, sera impur. ");
INSERT INTO francl_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Celui qui touchera son lit lavera ses vêtements, se baignera dans l’eau et sera impur jusqu’au soir. ");
INSERT INTO francl_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Celui qui s’assiéra sur l’objet où se sera assis l’homme qui a un flux, lavera ses vêtements, se baignera dans l’eau et sera impur jusqu’au soir. ");
INSERT INTO francl_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Celui qui touchera la chair de celui qui a un flux lavera ses vêtements, se baignera dans l’eau et sera impur jusqu’au soir. ");
INSERT INTO francl_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Si celui qui a un flux crache sur un homme pur, cet homme lavera ses vêtements, se baignera dans l’eau et sera impur jusqu’au soir. ");
INSERT INTO francl_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Toute selle sur laquelle sera monté celui qui a un flux sera impure. ");
INSERT INTO francl_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Celui qui touchera une chose qui a été sous lui sera impur jusqu’au soir, et celui qui la portera lavera ses vêtements, se baignera dans l’eau et sera impur jusqu’au soir. ");
INSERT INTO francl_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Celui qu’aura touché celui qui a un flux et qui n’aura pas lavé ses mains dans l’eau, lavera ses vêtements, se baignera dans l’eau et sera impur jusqu’au soir. ");
INSERT INTO francl_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Tout vase de terre qu’aura touché celui qui a un flux sera brisé, et tout vase de bois sera lavé dans l’eau. ");
INSERT INTO francl_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Lorsque celui qui a un flux sera purifié de son flux, il comptera sept jours pour sa purification ; il lavera alors ses vêtements, baignera son corps dans de l’eau vive, et il sera pur. ");
INSERT INTO francl_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Le huitième jour, ayant pris deux tourterelles ou deux jeunes pigeons, il viendra devant Yahweh, à l’entrée de la tente de réunion, et il les donnera au prêtre. ");
INSERT INTO francl_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Le prêtre les offrira, l’un en sacrifice pour le péché, l’autre en holocauste, et le prêtre fera pour lui l’expiation devant Yahweh, à cause de son flux. ");
INSERT INTO francl_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","L’homme qui aura un épanchement séminal baignera tout son corps dans l’eau, et sera impur jusqu’au soir. ");
INSERT INTO francl_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Tout vêtement et toute peau qui seront atteints par l’épanchement séminal seront lavés dans l’eau et seront impurs jusqu’au soir. ");
INSERT INTO francl_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Si une femme a couché avec un homme et a eu commerce avec lui, elle se baignera dans l’eau ainsi que lui, et ils seront impurs jusqu’au soir. ");
INSERT INTO francl_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Quand une femme aura un flux, un flux de sang dans sa chair, elle sera sept jours dans son impureté. Quiconque la touchera sera impur jusqu’au soir. ");
INSERT INTO francl_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Tout meuble sur lequel elle se couchera pendant son impureté sera impur, et tout objet sur lequel elle s’assiéra sera impur. ");
INSERT INTO francl_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Quiconque touchera son lit lavera ses vêtements, se baignera dans l’eau et sera impur jusqu’au soir. ");
INSERT INTO francl_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Quiconque touchera un objet sur lequel elle se sera assise, lavera ses vêtements, se baignera dans l’eau et sera impur jusqu’au soir. ");
INSERT INTO francl_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","S’il y a une chose sur le lit ou sur le siège sur lequel elle s’est assise, celui qui la touchera sera impur jusqu’au soir. ");
INSERT INTO francl_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Si un homme couche avec elle et que l’impureté de cette femme vienne sur lui, il sera impur pendant sept jours, et tout lit sur lequel il couchera sera impur. ");
INSERT INTO francl_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Quand une femme aura un flux de sang pendant plusieurs jours en dehors du temps accoutumé, ou si son flux se prolonge au-delà du temps de son impureté, elle sera impure tout le temps de ce flux, comme au temps de son impureté menstruelle. ");
INSERT INTO francl_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Tout lit sur lequel elle couchera tout le temps de ce flux, sera pour elle comme le lit de son impureté menstruelle, et tout objet sur lequel elle s’assiéra, sera impur comme au temps de son impureté menstruelle. ");
INSERT INTO francl_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Quiconque les touchera sera impur ; il lavera ses vêtements, se baignera dans l’eau et sera impur jusqu’au soir. ");
INSERT INTO francl_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Lorsqu’elle sera purifiée de son flux, elle comptera sept jours, après lesquels elle sera pure. ");
INSERT INTO francl_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Le huitième jour, elle prendra deux tourterelles ou deux jeunes pigeons, et les apportera au prêtre, à l’entrée de la tente de réunion. ");
INSERT INTO francl_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Le prêtre les offrira, l’un en sacrifice pour le péché, l’autre en holocauste, et le prêtre fera pour elle l’expiation devant Yahweh, à cause du flux qui la rendait impure. ");
INSERT INTO francl_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Vous apprendrez aux enfants d’Israël à se purifier de leurs impuretés, de peur qu’ils ne meurent à cause de leur impureté, en souillant ma Demeure qui est au milieu d’eux. ");
INSERT INTO francl_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Telle est la loi concernant l’homme qui a une gonorrhée ou qui est souillé par un épanchement séminal, ");
INSERT INTO francl_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","et concernant la femme qui a son flux menstruel, et toute personne ayant un flux, soit homme, soit femme, et pour l’homme qui couche avec une femme impure. » ");
INSERT INTO francl_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Yahweh parla à Moïse, après la mort des deux fils d’Aaron, qui furent frappés lorsqu’ils s’approchèrent de la face de Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Yahweh dit à Moïse : « Parle à ton frère Aaron, afin qu’il n’entre pas en tout temps dans le sanctuaire, au-dedans du voile, devant le propitiatoire qui est sur l’arche, de peur qu’il ne meure ; car j’apparais dans la nuée sur le propitiatoire. ");
INSERT INTO francl_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Voici le rite suivant lequel Aaron entrera dans le sanctuaire. Il prendra un jeune taureau pour le sacrifice pour le péché et un bélier pour l’holocauste. ");
INSERT INTO francl_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Il se revêtira de la sainte tunique de lin et mettra sur sa chair des caleçons de lin ; il se ceindra d’une ceinture de lin et se couvrira la tête d’une tiare de lin : ce sont les vêtements sacrés qu’il revêtira, après avoir baigné son corps dans l’eau. ");
INSERT INTO francl_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Il recevra de l’assemblée des enfants d’Israël deux boucs pour le sacrifice pour le péché, et un bélier pour l’holocauste. ");
INSERT INTO francl_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Aaron offrira son taureau pour le péché, et il fera l’expiation pour lui et pour sa maison. ");
INSERT INTO francl_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Puis il prendra les deux boucs et, les placera devant Yahweh, à l’entrée de la tente de réunion. ");
INSERT INTO francl_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Aaron jettera le sort sur les deux boucs, un sort pour Yahweh et un sort pour Azazel. ");
INSERT INTO francl_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Aaron fera approcher le bouc sur lequel sera tombé le sort pour Yahweh et l’offrira en sacrifice pour le péché. ");
INSERT INTO francl_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Et le bouc sur lequel sera tombé le sort pour Azazel, il le placera vivant devant Yahweh, afin de faire l’expiation sur lui et de le lâcher dans le désert pour Azazel. ");
INSERT INTO francl_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Aaron offrira donc le taureau du sacrifice pour le péché qui est pour lui, et il fera l’expiation pour lui et pour sa maison. Après avoir égorgé son taureau pour le péché, ");
INSERT INTO francl_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","il prendra un encensoir plein de charbons ardents de dessus l’autel, de devant Yahweh, et deux poignées de parfum odoriférant en poudre ; et ayant porté ces choses au-delà du voile, ");
INSERT INTO francl_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","il mettra le parfum sur le feu devant Yahweh, afin que la nuée du parfum couvre le propitiatoire qui est sur le témoignage, et qu’il ne meure pas. ");
INSERT INTO francl_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Il prendra du sang du taureau, et en fera aspersion avec son doigt sur la face orientale du propitiatoire, et il fera avec son doigt sept fois aspersion du sang devant le propitiatoire. ");
INSERT INTO francl_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Il égorgera le bouc du sacrifice pour le péché qui est pour le peuple, et il en portera le sang au delà du voile et, faisant de ce sang comme il a fait du sang du taureau, il en fera l’aspersion une fois sur le propitiatoire et sept fois devant le propitiatoire. ");
INSERT INTO francl_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","C’est ainsi qu’il fera l’expiation pour le sanctuaire à cause des souillures des enfants d’Israël et de toutes leurs transgressions, selon qu’ils ont péché. Il fera de même pour la tente de réunion, qui demeure avec eux au milieu de leurs souillures. ");
INSERT INTO francl_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Qu’il n’y ait personne dans la tente de réunion lorsqu’il entrera pour faire l’expiation dans le sanctuaire, jusqu’à ce qu’il en sorte. Il fera l’expiation pour lui, pour sa maison et pour toute l’assemblée d’Israël. ");
INSERT INTO francl_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Il ira en sortant vers l’autel qui est devant Yahweh, et fera l’expiation pour l’autel : ayant pris du sang du taureau et du sang du bouc, il en mettra sur les cornes de l’autel tout autour. ");
INSERT INTO francl_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Il fera sur l’autel, avec son doigt, sept fois aspersion du sang ; il le purifiera et le sanctifiera des souillures des enfants d’Israël. ");
INSERT INTO francl_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Lorsqu’il aura achevé de faire l’expiation pour le sanctuaire, pour la tente de réunion et pour l’autel, il présentera le bouc vivant. ");
INSERT INTO francl_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Ayant posé ses deux mains sur la tête du bouc vivant, Aaron confessera sur lui toutes les iniquités des enfants d’Israël et toutes leurs transgressions, selon qu’ils ont péché ; il les mettra sur la tête du bouc et il l’enverra ensuite au désert par un homme tout prêt. ");
INSERT INTO francl_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Le bouc emportera sur lui toutes leurs iniquités dans une terre inhabitée, et l’homme lâchera le bouc dans le désert. ");
INSERT INTO francl_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Alors Aaron entrera dans la tente de réunion ; il quittera les vêtements de lin qu’il avait revêtus pour entrer dans le sanctuaire et, les ayant déposés là, ");
INSERT INTO francl_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","il baignera son corps dans l’eau en un lieu saint et reprendra ses vêtements. ");
INSERT INTO francl_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Il sortira ensuite, offrira son holocauste et celui du peuple, fera l’expiation pour lui et pour le peuple, et fera fumer sur l’autel la graisse du sacrifice pour le péché. ");
INSERT INTO francl_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Celui qui aura lâché le bouc pour Azazel lavera ses vêtements et baignera son corps dans l’eau ; après quoi, il rentrera dans le camp. ");
INSERT INTO francl_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","On emportera hors du camp le taureau pour le péché et le bouc pour le péché, dont le sang aura été porté dans le sanctuaire pour faire l’expiation, et l’on consumera par le feu leur peau, leur chair et leurs excréments. ");
INSERT INTO francl_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Celui qui les aura brûlés lavera ses vêtements et baignera son corps dans l’eau ; après quoi, il rentrera dans le camp. ");
INSERT INTO francl_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Ceci sera pour vous une loi perpétuelle : au septième mois, le dixième jour du mois, vous affligerez vos âmes et ne ferez aucun ouvrage, ni l’indigène, ni l’étranger qui séjourne au milieu de vous. ");
INSERT INTO francl_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Car en ce jour on fera l’expiation pour vous, afin de vous purifier ; vous serez purs de tous vos péchés devant Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Ce sera pour vous un sabbat, un jour de repos, et vous affligerez vos âmes. C’est une loi perpétuelle. ");
INSERT INTO francl_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","L’expiation sera faite, dans l’avenir, par le grand prêtre qui aura reçu l’onction et qui aura été installé pour remplir les fonctions sacerdotales à la place de son père. Il revêtira des vêtements de lin, des vêtements sacrés. ");
INSERT INTO francl_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Il fera l’expiation pour le sanctuaire de sainteté, il fera l’expiation pour la tente de réunion et pour l’autel des holocaustes ; il fera l’expiation pour les prêtres et pour tout le peuple de l’assemblée. ");
INSERT INTO francl_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Ce sera pour vous une loi perpétuelle : l’expiation se fera une fois chaque année pour les enfants d’Israël, à cause de leurs péchés. » On fit ce que Yahweh avait ordonné à Moïse. ");
INSERT INTO francl_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","« Parle à Aaron et à ses fils, et à tous les enfants d’Israël, et tu leur diras : Voici ce que Yahweh a ordonné. ");
INSERT INTO francl_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Tout homme de la maison d’Israël qui, dans le camp ou hors du camp, égorge un bœuf, une brebis ou une chèvre, ");
INSERT INTO francl_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","sans l’amener à l’entrée de la tente de réunion pour le présenter en offrande à Yahweh devant la Demeure de Yahweh, le sang sera imputé à cet homme ; il a répandu le sang, cet homme sera retranché du milieu de son peuple. ");
INSERT INTO francl_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","C’est afin que les enfants d’Israël, au lieu d’immoler leurs victimes dans la campagne, les amènent au prêtre devant Yahweh, à l’entrée de la tente de réunion, et qu’ils les offrent à Yahweh en sacrifice pacifique. ");
INSERT INTO francl_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Le prêtre répandra le sang sur l’autel de Yahweh, à l’entrée de la tente de réunion, et il fera fumer la graisse en odeur agréable à Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Ils n’offriront plus leurs sacrifices aux satyres, avec lesquels ils se prostituent. Ce sera pour eux une loi perpétuelle de génération en génération. ");
INSERT INTO francl_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Tu leur diras encore : Tout homme de la maison d’Israël ou d’entre les étrangers séjournant au milieu d’eux qui offrira un holocauste ou un autre sacrifice, ");
INSERT INTO francl_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","et n’amènera pas la victime à l’entrée de la tente de réunion pour l’offrir en sacrifice à Yahweh, cet homme sera retranché du milieu de son peuple. ");
INSERT INTO francl_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Tout homme de la maison d’Israël ou d’entre les étrangers séjournant au milieu d’eux qui mangera le sang d’un animal quelconque, je tournerai ma face contre celui qui mange le sang, et je le retrancherai du milieu de son peuple ; ");
INSERT INTO francl_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","car l’âme de la chair est dans le sang, et je vous l’ai donné en vue de l’autel pour qu’il servit d’expiation pour vos âmes ; car c’est par l’âme que le sang fait expiation. ");
INSERT INTO francl_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","C’est pourquoi j’ai dit aux enfants d’Israël : Personne d’entre vous ne mangera du sang, et l’étranger qui séjourne au milieu de vous ne mangera pas du sang. ");
INSERT INTO francl_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Tout homme d’entre les enfants d’Israël ou d’entre les étrangers séjournant au milieu d’eux qui prend à la chasse un animal ou un oiseau qui se mange, il en versera le sang et le couvrira de terre ; ");
INSERT INTO francl_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","car l’âme de toute chair, c’est son sang il en est son âme. C’est pourquoi j’ai dit aux enfants d’Israël : Vous ne mangerez le sang d’aucune chair ; car l’âme de toute chair, c’est son sang : quiconque en mangera sera retranché. ");
INSERT INTO francl_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Toute personne, née dans le pays ou étrangère, qui mangera d’une bête morte ou déchirée, lavera ses vêtements, se baignera dans l’eau, et sera impure jusqu’au soir ; puis elle sera pure. ");
INSERT INTO francl_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Si elle ne lave pas ses vêtements et son corps, elle portera son iniquité. » ");
INSERT INTO francl_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","« Parle aux enfants d’Israël, et dis-leur : Je suis Yahweh, votre Dieu. ");
INSERT INTO francl_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Vous ne ferez pas ce qui se fait dans le pays d’Égypte où vous avez habité, et vous ne ferez pas ce qui se fait dans le pays de Canaan où je vous conduis : vous ne suivrez pas leurs lois. ");
INSERT INTO francl_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Vous pratiquerez mes ordonnances et vous observerez mes lois : vous les suivrez. Je suis Yahweh votre Dieu. ");
INSERT INTO francl_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Vous observerez mes Lois et mes ordonnances ; l’homme qui les mettra en pratique vivra par elles. Je suis Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Aucun de vous ne s’approchera d’une femme qui est sa proche parente, pour découvrir sa nudité : je suis Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Tu ne découvriras pas la nudité de ton père et la nudité de ta mère. C’est ta mère, tu ne découvriras pas sa nudité. ");
INSERT INTO francl_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Tu ne découvriras pas la nudité de la femme de ton père : c’est la nudité de ton père. ");
INSERT INTO francl_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Tu ne découvriras pas la nudité de ta sœur, fille de ton père ou fille de ta mère, née dans la maison ou née hors de la maison ; tu ne découvriras pas leur nudité. ");
INSERT INTO francl_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Tu ne découvriras pas la nudité de la fille de ton fils ou de la fille de ta fille : car c’est ta nudité. ");
INSERT INTO francl_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Tu ne découvriras pas la nudité de la fille de la femme de ton père, née de ton père : c’est ta sœur. ");
INSERT INTO francl_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Tu ne découvriras pas la nudité de la sœur de ton père : c’est la chair de ton père. ");
INSERT INTO francl_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Tu ne découvriras pas la nudité de la sœur de ta mère : c’est la chair de ta mère. ");
INSERT INTO francl_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Tu ne découvriras pas la nudité du frère de ton père, en t’approchant de sa femme : c’est ta tante. ");
INSERT INTO francl_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Tu ne découvriras pas la nudité de ta belle-fille : c’est la femme de ton fils, tu ne découvriras pas sa nudité. ");
INSERT INTO francl_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Tu ne découvriras pas la nudité de la femme de ton frère : c’est la nudité de ton frère. ");
INSERT INTO francl_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Tu ne découvriras pas la nudité d’une femme et de sa fille : tu ne prendras pas la fille de son fils ni la fille de sa fille, pour découvrir leur nudité : elles sont proches parentes, c’est un crime. ");
INSERT INTO francl_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Tu ne prendras pas la sœur de ta femme, pour en faire une rivale, en découvrant sa nudité avec celle de ta femme, de son vivant. ");
INSERT INTO francl_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Tu ne t’approcheras pas d’une femme pendant son impureté menstruelle, pour découvrir sa nudité. ");
INSERT INTO francl_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Tu n’auras pas commerce avec la femme de ton prochain, pour te souiller avec elle. ");
INSERT INTO francl_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Tu ne donneras aucun de tes enfants pour le faire passer par le feu en l’honneur de Moloch, et tu ne profaneras pas le nom de ton Dieu. Je suis Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Tu ne coucheras pas avec un homme comme on fait avec une femme : c’est une abomination. ");
INSERT INTO francl_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Tu ne coucheras pas avec une bête, pour te souiller avec elle. La femme ne se tiendra pas devant une bête pour se prostituer à elle : c’est une honte. ");
INSERT INTO francl_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Ne vous souillez par aucune de ces choses, car c’est par elles que se sont souillées les nations que je vais chasser devant vous. ");
INSERT INTO francl_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Le pays a été souillé ; je punirai ses iniquités, et le pays vomira ses habitants. ");
INSERT INTO francl_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Mais vous, vous observerez mes lois et mes ordonnances, et vous ne commettrez aucune de ces abominations, ni l’indigène, ni l’étranger qui séjourne au milieu de vous. ");
INSERT INTO francl_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Car toutes ces abominations, les hommes du pays, qui y ont été avant vous, les ont commises, et le pays en a été souillé. ");
INSERT INTO francl_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Et le pays ne vous vomira pas pour l’avoir souillé, comme il a vomi les nations qui y étaient avant vous. ");
INSERT INTO francl_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Car tous ceux qui commettront quelqu’une de ces abominations seront retranchés du milieu de leur peuple. ");
INSERT INTO francl_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Vous observerez mes commandements, afin de ne pratiquer aucun des usages abominables qui se pratiquaient avant vous, et vous ne vous souillerez pas par eux. Je suis Yahweh, votre Dieu. » ");
INSERT INTO francl_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","« Parle à toute l’assemblée d’Israël, et dis-leur : Soyez saints, car je suis saint, moi Yahweh, votre Dieu. ");
INSERT INTO francl_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Que chacun de vous craigne sa mère et son père, et observe mes sabbats. Je suis Yahweh, votre Dieu. ");
INSERT INTO francl_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Ne vous tournez pas vers les idoles, et ne vous faites pas de dieux de fonte. Je suis Yahweh, votre Dieu. ");
INSERT INTO francl_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","Quand vous offrirez à Yahweh un sacrifice pacifique, vous l’offrirez de manière à vous concilier sa faveur. ");
INSERT INTO francl_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","La victime sera mangée le jour où vous l’immolerez, ou le lendemain ; ce qui restera jusqu’au troisième jour sera consumé par le feu. ");
INSERT INTO francl_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Si quelqu’un en mange le troisième jour, c’est une abomination : le sacrifice ne sera pas agréé. ");
INSERT INTO francl_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Celui qui en mangera portera son iniquité, car il profane ce qui est consacré à Yahweh : cet homme sera retranché de son peuple. ");
INSERT INTO francl_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Quand vous ferez la moisson de votre pays, tu ne moissonneras pas jusqu’à la limite extrême de ton champ, et tu ne ramasseras pas ce qu’il y a à glaner de ta moisson. ");
INSERT INTO francl_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Tu ne cueilleras pas non plus les grappes restées dans ta vigne, et tu ne ramasseras pas les fruits tombés dans ton verger ; tu laisseras cela au pauvre et à l’étranger. Je suis Yahweh, votre Dieu. ");
INSERT INTO francl_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Vous ne déroberez point, et vous n’userez ni de tromperie ni de mensonge les uns envers les autres. ");
INSERT INTO francl_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Vous ne jurerez pas par mon nom, en mentant, car tu profanerais le nom de ton Dieu. Je suis Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Tu n’opprimeras pas ton prochain, et tu ne le dépouilleras pas. Le salaire du mercenaire ne restera pas chez toi jusqu’au lendemain. ");
INSERT INTO francl_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Tu ne proféreras pas de malédiction contre un sourd, et tu ne mettras pas devant un aveugle quelque chose qui puisse le faire tomber ; car tu auras la crainte de ton Dieu. Je suis Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Vous ne commettrez pas d’injustice dans le jugement : tu n’auras pas de faveur pour le pauvre, et tu n’auras pas de complaisance pour le puissant ; mais tu jugeras ton prochain selon la justice. ");
INSERT INTO francl_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Tu n’iras pas semant la diffamation parmi ton peuple. Tu ne te tiendras pas comme témoin contre le sang de ton prochain. Je suis Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Tu ne haïras pas ton frère dans ton cœur, mais tu reprendras ton prochain, afin de ne pas te charger d’un péché à cause de lui. ");
INSERT INTO francl_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Tu ne te vengeras point, et tu ne garderas pas de rancune contre les enfants de ton peuple. Tu aimeras ton prochain comme toi-même. Je suis Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Vous observerez mes lois. Tu n’accoupleras pas des bestiaux de deux espèces différentes ; tu n’ensemenceras pas ton champ de deux espèces de semences ; et tu ne porteras pas un vêtement tissu de deux espèces de fils. ");
INSERT INTO francl_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Si un homme couche et a commerce avec une femme qui soit une esclave fiancée à un autre homme et qui n’a pas été rachetée ou affranchie, ils seront châtiés tous deux, mais non punis de mort, parce que l’esclave n’était pas affranchie. ");
INSERT INTO francl_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Pour sa faute, l’homme amènera à Yahweh, à l’entrée de la tente de réunion, un bélier en sacrifice de réparation. ");
INSERT INTO francl_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Le prêtre fera pour lui l’expiation devant Yahweh avec le bélier du sacrifice de réparation, pour le péché qu’il a commis, et le péché qu’il a commis lui sera pardonné. ");
INSERT INTO francl_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Quand vous serez entrés dans le pays et que vous aurez planté toutes sortes d’arbres fruitiers, vous en regarderez les fruits comme incirconcis : pendant trois ans, ils seront incirconcis pour vous : on n’en mangera point. ");
INSERT INTO francl_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","La quatrième année, tous leurs fruits seront consacrés en louange à Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","La cinquième année, vous en mangerez les fruits, et ainsi l’arbre vous continuera son rapport. Je suis Yahweh, votre Dieu. ");
INSERT INTO francl_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Vous ne mangerez rien avec du sang. Vous ne pratiquerez ni la divination ni la magie. ");
INSERT INTO francl_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Vous ne tondrez pas en rond les coins de votre chevelure, et tu ne raseras pas les coins de ta barbe. ");
INSERT INTO francl_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Vous ne ferez pas d’incisions dans votre chair pour un mort, et vous n’imprimerez pas de figures sur vous. Je suis Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Ne profane pas ta fille en la prostituant, de peur que le pays ne se livre à la prostitution et ne se remplisse de crimes. ");
INSERT INTO francl_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Vous observerez mes sabbats et vous révérerez mon sanctuaire. Je suis Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Ne vous adressez pas à ceux qui évoquent les esprits, ni aux devins ; ne les consultez point, pour ne pas être souillés par eux. Je suis Yahweh, votre Dieu. ");
INSERT INTO francl_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Tu te lèveras devant une tête blanchie, et tu honoreras la personne du vieillard. Tu craindras ton Dieu. Je suis Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Si un étranger vient séjourner avec vous dans votre pays, vous ne l’opprimerez point. ");
INSERT INTO francl_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Vous traiterez l’étranger en séjour parmi vous comme un indigène du milieu de vous ; tu l’aimeras comme toi-même, car vous avez été étrangers dans le pays d’Égypte. Je suis Yahweh, votre Dieu. ");
INSERT INTO francl_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Vous ne commettrez pas d’injustice, soit dans les jugements, soit dans les mesures de longueur, soit dans les poids, soit dans les mesures de capacité. ");
INSERT INTO francl_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Vous aurez des balances justes, des poids justes, un épha juste et un hin juste. Je suis Yahweh, votre Dieu, qui vous ai fait sortir du pays d’Égypte. ");
INSERT INTO francl_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Vous observerez toutes mes lois et toutes mes ordonnances, et vous les mettrez en pratique. Je suis Yahweh. » ");
INSERT INTO francl_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","« Tu diras aux enfants d’Israël : Quiconque d’entre les enfants d’Israël ou d’entre les étrangers qui séjournent en Israël donne à Moloch l’un de ses enfants, sera puni de mort : le peuple du pays le lapidera. ");
INSERT INTO francl_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Et moi, je tournerai ma face contre cet homme, et je le retrancherai du milieu de son peuple, parce qu’il aura livré un de ses enfants à Moloch, pour souiller mon sanctuaire et profaner mon saint nom. ");
INSERT INTO francl_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Si le peuple du pays ferme les yeux sur cet homme quand il donnera de ses enfants à Moloch, et ne le fait pas mourir, ");
INSERT INTO francl_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","moi, je tournerai ma face contre cet homme et contre sa famille, et je le retrancherai du milieu de son peuple, avec tous ceux qui se prostituent comme lui en se prostituant à Moloch. ");
INSERT INTO francl_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Si quelqu’un s’adresse à ceux qui évoquent les esprits et aux devins, pour se prostituer après eux, je tournerai ma face contre cet homme et je le retrancherai du milieu de son peuple. ");
INSERT INTO francl_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Vous vous sanctifierez et vous serez saints, car je suis Yahweh, votre Dieu. ");
INSERT INTO francl_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Vous observerez mes lois et vous les mettrez en pratique. Je suis Yahweh, qui vous sanctifie. ");
INSERT INTO francl_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Quiconque maudit son père ou sa mère sera puni de mort ; il a maudit son père ou sa mère : son sang est sur lui. ");
INSERT INTO francl_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Si un homme commet adultère avec une femme mariée, et s’il commet adultère avec la femme de son prochain, ils seront tous deux punis de mort, l’homme et la femme adultères. ");
INSERT INTO francl_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Si un homme couche avec la femme de son père, et découvre ainsi la nudité de son père, ils seront tous deux punis de mort : leur sang est sur eux. ");
INSERT INTO francl_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Si un homme couche avec sa belle-fille, ils seront tous deux punis de mort ; ils ont fait une chose honteuse : leur sang est sur eux. ");
INSERT INTO francl_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Si un homme couche avec un homme comme on fait avec une femme, ils ont fait tous deux une chose abominable, ils seront punis de mort : leur sang est sur eux. ");
INSERT INTO francl_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Si un homme prend pour femmes la fille et la mère, c’est un crime ; on les livrera au feu, lui et elles, afin que ce crime n’existe pas parmi vous. ");
INSERT INTO francl_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","L’homme qui aura commerce avec une bête sera puni de mort, et vous tuerez la bête. ");
INSERT INTO francl_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Si une femme s’approche d’une bête pour se prostituer à elle, tu tueras la femme et la bête ; elles seront mises à mort : leur sang est sur elles. ");
INSERT INTO francl_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Si un homme prend sa sœur, fille de son père ou fille de sa mère, s’il voit sa nudité et qu’elle voie la sienne, c’est une infamie ; ils seront retranchés sous les yeux des enfants de leur peuple. Il a découvert la nudité de sa sœur, il portera son iniquité. ");
INSERT INTO francl_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Si un homme couche avec une femme qui a son indisposition menstruelle, et découvre sa nudité, il a découvert son flux, et elle a découvert le flux de son sang ; ils seront retranchés tous deux du milieu de leur peuple. ");
INSERT INTO francl_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Tu ne découvriras pas la nudité de la sœur de ta mère, ni de la sœur de ton père, car c’est découvrir sa propre chair : ils porteront leur iniquité. ");
INSERT INTO francl_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Si un homme couche avec sa tante, il découvre la nudité de son oncle ; ils porteront leur péché : ils mourront sans enfants. ");
INSERT INTO francl_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Si un homme prend la femme de son frère, c’est une impureté ; il a découvert la nudité de son frère : ils seront sans enfants. ");
INSERT INTO francl_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Vous observerez toutes mes lois et toutes mes ordonnances et vous les mettrez en pratique, afin que le pays où je vous mène pour y habiter ne vous vomisse pas. ");
INSERT INTO francl_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Vous ne suivrez pas les usages des nations que je vais chasser de devant vous ; car elles ont fait toutes ces choses, et je les ai en dégoût. ");
INSERT INTO francl_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Je vous ai dit : C’est vous qui posséderez leur terre ; je vous la donnerai pour la posséder ; c’est un pays où coulent le lait et le miel. Je suis Yahweh, votre Dieu, qui vous ai séparés des autres peuples. ");
INSERT INTO francl_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Vous distinguerez entre les animaux purs et impurs, entre les oiseaux purs et impurs, et vous ne vous rendrez pas abominables par des animaux, par des oiseaux et par tout ce qui se meut sur la terre, que je vous ai appris à distinguer comme impurs. ");
INSERT INTO francl_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Vous serez saints pour moi, car je suis saint, moi Yahweh, et je vous ai séparés des autres peuples, afin que vous soyez à moi. ");
INSERT INTO francl_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Tout homme ou femme qui évoque les esprits ou s’adonne à la divination sera mis à mort ; on les lapidera : leur sang est sur eux. » ");
INSERT INTO francl_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Yahweh dit à Moïse : Parle aux prêtres, fils d’Aaron, et dis-leur : Nul ne se rendra impur au milieu de son peuple pour un mort, ");
INSERT INTO francl_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","excepté pour son parent du même rang, pour sa mère, pour son père, pour son fils, pour sa fille, pour son frère, ");
INSERT INTO francl_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","et pour sa sœur vierge, qui vit auprès de lui, n’étant pas encore mariée ; pour elle il se rendra impur. ");
INSERT INTO francl_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Chef de maison parmi son peuple, il ne se souillera pas et ne profanera pas sa dignité. ");
INSERT INTO francl_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Les prêtres ne se raseront pas la tête, ils n’enlèveront pas les côtés de leur barbe, et ils ne feront pas d’incisions dans leur chair. ");
INSERT INTO francl_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Ils seront saints pour leur Dieu, et ils ne profaneront pas le nom de leur Dieu, car ils offrent à Yahweh des sacrifices consumés par le feu, le pain de leur Dieu : ils seront saints. ");
INSERT INTO francl_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Ils ne prendront pas une femme prostituée ou déshonorée ; ils ne prendront pas une femme répudiée par son mari, car le prêtre est saint pour son Dieu. ");
INSERT INTO francl_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Tu le tiendras pour saint, car il offre le pain de ton Dieu ; il sera saint pour toi, car je suis saint, moi Yahweh, qui vous sanctifie. ");
INSERT INTO francl_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Si la fille d’un prêtre se déshonore en se prostituant, elle déshonore son père : elle sera brûlée au feu. ");
INSERT INTO francl_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","Le grand prêtre qui est au-dessus de ses frères, sur la tête duquel a été répandue l’huile d’onction, et qui a été installé pour revêtir les vêtements sacrés, ne découvrira pas sa tête et ne déchirera pas ses vêtements. ");
INSERT INTO francl_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Il n’approchera d’aucun mort ; il ne se rendra impur ni pour son père, ni pour sa mère. ");
INSERT INTO francl_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Il ne sortira pas du sanctuaire, et ne profanera pas le sanctuaire de son Dieu, car l’huile d’onction de son Dieu est un diadème sur lui. Je suis Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Il prendra pour femme une vierge. ");
INSERT INTO francl_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Il ne prendra ni une veuve, ni une femme répudiée, ni une femme déshonorée ou prostituée ; mais il prendra pour femme une vierge du milieu de son peuple. ");
INSERT INTO francl_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Il ne déshonorera pas sa postérité au milieu de son peuple ; car je suis Yahweh, qui le sanctifie. » ");
INSERT INTO francl_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","« Parle à Aaron, et dis-lui : Nul homme de ta race, dans toutes les générations, qui aura une difformité corporelle, n’approchera pour offrir le pain de ton Dieu. ");
INSERT INTO francl_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Car nul homme qui a une difformité corporelle n’approchera : un homme aveugle ou boiteux, ou qui aura une mutilation ou une excroissance ; ");
INSERT INTO francl_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","ou un homme qui aura une fracture au pied ou à la main ; ");
INSERT INTO francl_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","qui sera bossu ou nain, ou qui aura une tache à l’œil, la gale, une dartre ou les testicules écrasés. ");
INSERT INTO francl_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Nul homme de la race du prêtre Aaron qui aura une difformité corporelle, ne s’approchera pour offrir à Yahweh les sacrifices faits par le feu ; il a une difformité corporelle : qu’il ne s’approche pas pour offrir le pain de son Dieu. ");
INSERT INTO francl_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Il pourra manger le pain de son Dieu, des choses très saintes et des choses saintes. ");
INSERT INTO francl_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Mais il n’ira pas vers le voile et ne s’approchera pas de l’autel, car il a une difformité corporelle ; il ne profanera pas mes sanctuaires, car je suis Yahweh qui les sanctifie. » ");
INSERT INTO francl_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Ainsi parla Moïse à Aaron et à ses fils, et à tous les enfants d’Israël. ");
INSERT INTO francl_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","« Parle à Aaron et à ses fils, afin qu’ils s’abstiennent des choses saintes que me consacrent les enfants d’Israël, et qu’ils ne profanent pas mon saint nom. Je suis Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Dis-leur : Tout homme de votre race qui, dans toutes vos générations, ayant sur lui quelque impureté, s’approchera des choses saintes que les enfants d’Israël consacrent à Yahweh, sera retranché de devant moi. Je suis Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Tout homme de la race d’Aaron qui aura la lèpre ou une gonorrhée, ne mangera pas des choses saintes, jusqu’à ce qu’il soit pur. Il en sera de même de celui qui aura touché une personne souillée par le contact d’un cadavre, de celui qui aura eu un épanchement séminal, ");
INSERT INTO francl_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","de celui qui aura touché soit un animal rampant qui l’ait rendu impur, soit un homme impur qui lui ait communiqué sa souillure quelle qu’elle soit. ");
INSERT INTO francl_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Celui qui touchera ces choses sera impur jusqu’au soir et il ne mangera pas des choses saintes ; mais il baignera son corps dans l’eau ");
INSERT INTO francl_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","et, après le coucher du soleil, il sera pur ; il pourra manger alors des choses saintes, car c’est sa nourriture. ");
INSERT INTO francl_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Il ne mangera pas d’une bête morte ou déchirée, de manière à être souillé par elle ; je suis Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Ils observeront mes commandements, de peur qu’ils ne se chargent d’un péché à ce sujet, et qu’ils ne meurent pour avoir profané les choses saintes. Je suis Yahweh, qui les sanctifie. ");
INSERT INTO francl_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Aucun étranger ne mangera des choses saintes ; celui qui demeure chez un prêtre et le mercenaire ne mangeront pas des choses saintes. ");
INSERT INTO francl_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Mais un esclave acquis par le prêtre à prix d’argent pourra en manger ; il en est de même de celui qui est né dans sa maison : ils mangeront de sa nourriture. ");
INSERT INTO francl_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","La fille d’un prêtre, mariée à un étranger, ne mangera pas de ce qui a été prélevé sur les choses saintes. ");
INSERT INTO francl_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Mais si la fille d’un prêtre, devenue veuve ou répudiée, sans avoir d’enfants, retourne dans la maison de son père, comme elle y était dans sa jeunesse, elle pourra manger de la nourriture de son père ; mais aucun étranger n’en mangera. ");
INSERT INTO francl_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Si un homme mange par erreur d’une chose sainte, il restituera au prêtre la valeur de la chose sainte, en y ajoutant un cinquième. ");
INSERT INTO francl_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Les prêtres ne profaneront pas les choses saintes des enfants d’Israël, ce qu’ils ont prélevé pour Yahweh, ");
INSERT INTO francl_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","et ne leur feront pas porter le poids de la faute qu’ils commettraient en mangeant leurs choses saintes ; car je suis Yahweh, qui les sanctifie. » ");
INSERT INTO francl_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","« Parle à Aaron et à ses fils, ainsi qu’à tous les enfants d’Israël ; et dis-leur : Qui que ce soit de la maison d’Israël ou des étrangers en Israël qui présente son offrande, soit pour l’accomplissement d’un vœu, soit comme don volontaire, s’il l’offre à Yahweh en holocauste, ");
INSERT INTO francl_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","pour que vous soyez agréés, que la victime soit un mâle sans défaut, d’entre les bœufs, les brebis ou les chèvres. ");
INSERT INTO francl_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Vous n’en offrirez aucune qui ait un défaut, car elle ne serait pas agréée. ");
INSERT INTO francl_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Quand un homme offre à Yahweh du gros ou du menu bétail en sacrifice pacifique, soit pour s’acquitter d’un vœu, soit comme offrande volontaire, la victime, pour être agréée, devra être parfaite ; il n’y aura en elle aucun défaut. ");
INSERT INTO francl_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Un animal aveugle, estropié ou mutilé, ayant un ulcère, la gale ou une dartre, vous ne l’offrirez pas à Yahweh ; vous n’en ferez pas sur l’autel un sacrifice par le feu à Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Tu pourras immoler comme offrande volontaire un bœuf ou une brebis ayant un membre trop long ou trop court ; mais, pour l’accomplissement d’un vœu, cette victime ne serait pas agréée. ");
INSERT INTO francl_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Vous n’offrirez pas à Yahweh un animal qui ait les testicules froissés, écrasés, arrachés ou coupés ; vous ne ferez pas cela dans votre pays. ");
INSERT INTO francl_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Même de la main d’un étranger, vous n’accepterez aucune de ces victimes pour l’offrir comme aliment de votre Dieu ; car elles sont corrompues, il y a en elles un défaut : elles ne seraient pas agréées pour vous. » ");
INSERT INTO francl_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Yahweh dit à Moïse : ");
INSERT INTO francl_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","« Un bœuf, un agneau ou une chèvre, quand il naîtra, restera sept jours sous sa mère ; à partir du huitième jour et les jours suivants, il sera agréé pour être offert en sacrifice fait par le feu à Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Bœuf ou agneau, vous n’immolerez pas l’animal et son petit le même jour. ");
INSERT INTO francl_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Quand vous offrirez à Yahweh un sacrifice d’actions de grâces, vous l’offrirez de manière qu’il soit agréé ; ");
INSERT INTO francl_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","pour cela, la victime sera mangée le même jour ; vous n’en laisserez rien jusqu’au matin. Je suis Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Vous observerez mes commandements et les mettrez en pratique : je suis Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Vous ne profanerez pas mon saint nom, et je serai sanctifié au milieu des enfants d’Israël. Je suis Yahweh, qui vous sanctifie, ");
INSERT INTO francl_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","celui qui vous a fait sortir du pays d’Égypte, pour être votre Dieu. Je suis Yahweh. » ");
INSERT INTO francl_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","« Parle aux enfants d’Israël, et dis-leur : Voici les solennités de Yahweh que vous publierez pour être de saintes assemblées ; ce sont mes solennités. ");
INSERT INTO francl_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","On travaillera durant six jours ; mais le septième jour est un sabbat, un repos complet : il y aura une sainte assemblée. Vous ne ferez aucun ouvrage. C’est un repos consacré à Yahweh, dans tous les lieux que vous habiterez. ");
INSERT INTO francl_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Voici les fêtes de Yahweh, les saintes assemblées que vous publierez en leur temps. ");
INSERT INTO francl_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Au premier mois, le quatorzième jour du mois, entre les deux soirs, c’est la Pâque de Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Et le quinzième jour de ce mois, c’est la fête des pains sans levain en l’honneur de Yahweh : pendant sept jours, vous mangerez des pains sans levain. ");
INSERT INTO francl_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Le premier jour vous aurez une sainte assemblée : vous ne ferez aucune œuvre servile. ");
INSERT INTO francl_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Vous offrirez à Yahweh, pendant sept jours, des sacrifices faits par le feu. Le septième jour, il y aura une sainte assemblée : vous ne ferez aucune œuvre servile. » ");
INSERT INTO francl_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","« Parle aux enfants d’Israël, et dis-leur : Quand vous serez entrés dans le pays que je vous donne, et que vous y ferez la moisson, vous apporterez au prêtre une gerbe, prémices de votre moisson. ");
INSERT INTO francl_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Il balancera cette gerbe devant Yahweh, pour qu’il vous soit favorable ; le prêtre la balancera le lendemain du sabbat. ");
INSERT INTO francl_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Le jour où vous balancerez la gerbe, vous sacrifierez en holocauste à Yahweh un agneau d’un an, sans défaut ; ");
INSERT INTO francl_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","l’oblation qui l’accompagnera sera de deux dixièmes de fleur de farine pétrie à l’huile, comme offrande faite par le feu, d’une agréable odeur à Yahweh ; la libation sera de vin, le quart d’un hin. ");
INSERT INTO francl_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Vous ne mangerez ni pain, ni épis grillés, ni épis frais, jusqu’à ce jour même, jusqu’à ce que vous apportiez l’offrande de votre Dieu. C’est une loi perpétuelle pour vos descendants, dans tous les lieux que vous habiterez. ");
INSERT INTO francl_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","A partir du lendemain du sabbat, du jour où vous aurez apporté la gerbe pour être balancée, vous compterez sept semaines entières. ");
INSERT INTO francl_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Vous compterez cinquante jours jusqu’au lendemain du septième sabbat, et vous offrirez à Yahweh une oblation nouvelle. ");
INSERT INTO francl_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Vous apporterez de vos demeures deux pains pour offrande balancée ; ils seront faits avec deux dixièmes d’épha de fleur de farine, et cuits avec du levain : ce sont les prémices de Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Avec ces pains, vous offrirez en holocauste à Yahweh sept agneaux d’un an, sans défaut, un jeune taureau et deux béliers, en y joignant l’oblation et la libation ordinaires : ce sera un sacrifice fait par le feu, d’une agréable odeur à Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Vous immolerez aussi un bouc en sacrifice pour le péché, et deux agneaux d’un an en sacrifice pacifique. ");
INSERT INTO francl_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Le prêtre balancera les victimes avec les pains des prémices en offrande balancée devant Yahweh, avec les deux agneaux ; ils seront consacrés à Yahweh et appartiendront au prêtre. ");
INSERT INTO francl_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Ce jour-là même, vous publierez la fête, et vous aurez une sainte assemblée : vous ne ferez aucune œuvre servile. C’est une loi perpétuelle pour vos descendants, dans tous les lieux où vous habiterez. ");
INSERT INTO francl_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Quand vous ferez la moisson dans votre pays, tu ne moissonneras pas jusqu’à la limite extrême de ton champ, et tu ne ramasseras pas de ta moisson ce qui reste à glaner ; tu laisseras cela pour le pauvre et pour l’étranger. Je suis Yahweh, votre Dieu. » ");
INSERT INTO francl_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","« Parle aux enfants d’Israël et dis-leur : Au septième mois, le premier jour du mois, vous aurez un repos solennel, un rappel à son de cor, une sainte assemblée. ");
INSERT INTO francl_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Vous ne ferez aucune œuvre servile, et vous offrirez à Yahweh des sacrifices faits par le feu. » ");
INSERT INTO francl_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","« Le dixième jour de ce septième mois est le jour des Expiations : vous aurez une sainte assemblée, vous affligerez vos âmes, et vous offrirez à Yahweh des sacrifices faits par le feu. ");
INSERT INTO francl_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Vous ne ferez ce jour-là aucun travail, car c’est un jour d’expiation, où doit être faite l’expiation pour vous devant Yahweh, votre Dieu. ");
INSERT INTO francl_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Toute personne qui ne s’affligera pas ce jour-là sera retranchée de son peuple ; ");
INSERT INTO francl_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","et toute personne qui fera ce jour-là un ouvrage quelconque, je la ferai périr du milieu de son peuple. ");
INSERT INTO francl_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Vous ne ferez aucun travail. C’est une loi perpétuelle pour vos descendants, dans tous les lieux où vous demeurerez. ");
INSERT INTO francl_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Ce sera pour vous un sabbat, un repos absolu, et vous affligerez vos âmes ; le neuvième jour du mois, au soir, du soir jusqu’au soir suivant, vous observerez votre sabbat. » ");
INSERT INTO francl_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","« Parle aux enfants d’Israël, et dis-leur : Au quinzième jour de ce septième mois, c’est la fête des Tabernacles, pendant sept jours, en l’honneur de Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Le premier jour, il y aura une sainte assemblée ; vous ne ferez aucune œuvre servile. ");
INSERT INTO francl_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Pendant sept jours, vous offrirez à Yahweh des sacrifices faits par le feu. Le huitième jour, vous aurez une sainte assemblée, et vous offrirez à Yahweh des sacrifices faits par le feu ; c’est une fête de clôture : vous ne ferez aucune œuvre servile. ");
INSERT INTO francl_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Telles sont les fêtes de Yahweh que vous publierez pour y tenir de saintes assemblées, pour offrir à Yahweh des sacrifices faits par le feu, des holocaustes, des oblations, des victimes et des libations, chacun d’eux à son jour : ");
INSERT INTO francl_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","indépendamment des sabbats de Yahweh, indépendamment de vos dons, indépendamment de tous vos vœux et indépendamment de toutes vos offrandes volontaires que vous présenterez à Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Le quinzième jour du septième mois, quand vous aurez récolté les produits du pays, vous célébrerez la fête de Yahweh pendant sept jours ; le premier jour sera un repos solennel, et le huitième jour un repos solennel. ");
INSERT INTO francl_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Vous prendrez, le premier jour, du fruit de beaux arbres, des branches de palmiers, des rameaux d’arbres touffus et des saules de rivière ; et vous vous réjouirez devant Yahweh, votre Dieu, pendant sept jours. ");
INSERT INTO francl_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Vous célébrerez cette fête en l’honneur de Yahweh sept jours chaque année. C’est une loi perpétuelle pour vos descendants ; vous la célébrerez le septième mois. ");
INSERT INTO francl_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Vous demeurerez pendant sept jours sous des huttes de feuillage : tous les indigènes en Israël demeureront dans des huttes ; ");
INSERT INTO francl_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","afin que vos descendants sachent que j’ai fait habiter sous des huttes les enfants d’Israël, lorsque je les ai fait sortir du pays d’Égypte. Je suis Yahweh, votre Dieu. » ");
INSERT INTO francl_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Moïse fit ainsi connaître aux enfants d’Israël les fêtes de Yahweh. » ");
INSERT INTO francl_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","« Ordonne aux enfants d’Israël de t’apporter pour le chandelier de l’huile pure d’olives concassées, pour entretenir les lampes continuellement. ");
INSERT INTO francl_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","En dehors du voile qui est devant le témoignage, dans la tente de réunion, Aaron la préparera pour brûler continuellement du soir au matin en présence de Yahweh. C’est une loi perpétuelle pour vos descendants. ");
INSERT INTO francl_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Il arrangera les lampes sur le chandelier d’or pur, pour qu’elles brûlent constamment devant Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","« Tu prendras de la fleur de farine, et tu en cuiras douze gâteaux ; chaque gâteau sera de deux dixièmes d’épha. ");
INSERT INTO francl_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Tu les placeras en deux piles, six par pile, sur la table d’or pur devant Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Tu mettras de l’encens pur sur chaque pile, et il servira, pour le pain, de mémorial offert par le feu à Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Chaque jour de sabbat, on disposera ces pains devant Yahweh constamment, de la part des enfants d’Israël : c’est une alliance perpétuelle. ");
INSERT INTO francl_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Ils appartiendront à Aaron et à ses fils, qui les mangeront en lieu saint ; car c’est pour eux une chose très sainte parmi les offrandes faites par le feu à Yahweh. C’est une loi perpétuelle. » ");
INSERT INTO francl_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Le fils d’une femme israélite, mais qui était fils d’un Egyptien, vint au milieu des enfants d’Israël, et il y eut une querelle dans le camp entre le fils de la femme israélite et un homme d’Israël. ");
INSERT INTO francl_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Le fils de la femme israélite blasphéma le Nom sacré et le maudit, et sa mère s’appelait Salumith, fille de Dabri, de la tribu de Dan. ");
INSERT INTO francl_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","On le mit sous garde, pour que Moïse leur déclarât de la part de Yahweh, ce qu’il y avait à faire. ");
INSERT INTO francl_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","« Fais sortir du camp le blasphémateur ; que tous ceux qui l’ont entendu posent leurs mains sur sa tête, et que toute l’assemblée le lapide. ");
INSERT INTO francl_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Tu parleras aux enfants d’Israël, en disant : Tout homme qui maudit son Dieu portera son péché ; ");
INSERT INTO francl_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","et celui qui blasphémera le nom de Yahweh sera puni de mort : toute l’assemblée le lapidera. Etranger ou indigène, s’il blasphème le Nom sacré, il mourra. ");
INSERT INTO francl_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Celui qui frappe un homme mortellement sera mis à mort. ");
INSERT INTO francl_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Celui qui frappe mortellement une tête de bétail en donnera une autre : vie pour vie. ");
INSERT INTO francl_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Si quelqu’un fait une blessure à son prochain, on lui fera comme il a fait : ");
INSERT INTO francl_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","fracture pour fracture, œil pour œil, dent pour dent ; on lui fera la même blessure qu’il a faite à son prochain. ");
INSERT INTO francl_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Celui qui aura tué une pièce de bétail en rendra une autre ; mais celui qui aura tué un homme sera mis à mort. ");
INSERT INTO francl_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","La même loi régnera parmi vous, pour l’étranger comme pour l’indigène ; car je suis Yahweh, votre Dieu. » ");
INSERT INTO francl_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Moïse ayant ainsi parlé aux enfants d’Israël, ils firent sortir du camp le blasphémateur, et le lapidèrent. Les enfants d’Israël firent selon que Yahweh avait ordonné à Moïse. ");
INSERT INTO francl_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Yahweh parla à Moïse sur la montagne de Sinaï, en disant : ");
INSERT INTO francl_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","« Parle aux enfants d’Israël, et dis-leur : Quand vous serez entrés dans le pays que je vous donne, la terre se reposera : ce sera un sabbat en l’honneur de Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Pendant six ans tu ensemenceras ton champ, pendant six ans tu tailleras ta vigne, et tu en recueilleras le produit. ");
INSERT INTO francl_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Mais la septième année sera un sabbat, un solennel repos pour la terre, un sabbat en l’honneur de Yahweh : tu n’ensemenceras pas ton champ et tu ne tailleras pas ta vigne. ");
INSERT INTO francl_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Tu ne moissonneras pas ce qui poussera de soi-même, des grains tombés de ta dernière moisson, et tu ne recueilleras pas les raisins de ta vigne non taillée : ce sera une année de repos pour la terre. ");
INSERT INTO francl_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Ce que produira la terre pendant son sabbat vous servira de nourriture, à toi, à ton serviteur et à ta servante, à ton mercenaire et à l’étranger qui demeurent avec toi ; ");
INSERT INTO francl_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","à ton bétail aussi et aux animaux qui sont dans ton pays, tout son produit servira de nourriture. ");
INSERT INTO francl_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Tu compteras sept sabbats d’années, sept fois sept ans ; la durée de ces sept sabbats d’années te fera une période de quarante-neuf ans. ");
INSERT INTO francl_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Le dixième jour du septième mois, tu feras retentir le son éclatant de la trompette ; le jour des Expiations, vous ferez passer la trompette dans tout votre pays. ");
INSERT INTO francl_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Et vous sanctifierez la cinquantième année, et vous publierez la liberté dans le pays pour tous ses habitants. Ce sera pour vous un jubilé, et chacun de vous retournera dans sa propriété et chacun de vous retournera dans sa famille. ");
INSERT INTO francl_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","La cinquantième année sera pour vous un jubilé ; vous ne sèmerez point, vous ne moissonnerez pas ce que la terre produira d’elle-même, et vous ne vendangerez pas la vigne non taillée. ");
INSERT INTO francl_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Car c’est un jubilé ; il sera sacré pour vous. Vous mangerez le produit tiré de vos champs. ");
INSERT INTO francl_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","Dans cette année de jubilé, chacun de vous retournera dans sa propriété. ");
INSERT INTO francl_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Si vous faites une vente à votre prochain, ou si vous achetez de votre prochain, qu’aucun de vous ne porte préjudice à son frère. ");
INSERT INTO francl_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Tu achèteras à ton prochain d’après le nombre des années écoulées depuis le dernier jubilé, et il te vendra d’après le nombre des années de récolte. ");
INSERT INTO francl_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Plus il restera d’années, plus tu élèveras le prix, et moins il y aura d’années, plus tu abaisseras le prix ; car c’est le nombre des récoltes qu’il te vend. ");
INSERT INTO francl_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Qu’aucun de vous ne porte préjudice à son frère ; crains ton Dieu, car je suis Yahweh, votre Dieu. ");
INSERT INTO francl_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Vous mettrez mes lois en pratique, vous observerez mes ordonnances et les mettrez en pratique, et vous habiterez en sécurité dans le pays. ");
INSERT INTO francl_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","La terre donnera ses fruits, vous mangerez à satiété et vous y habiterez en sécurité. ");
INSERT INTO francl_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Si vous dites : Que mangerons-nous la septième année, puisque nous ne sèmerons pas et ne recueillerons pas nos produits ? ");
INSERT INTO francl_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Je vous enverrai ma bénédiction la sixième année, et elle produira des fruits pour trois ans. ");
INSERT INTO francl_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Vous sèmerez la huitième année, et vous mangerez de l’ancienne récolte ; jusqu’à la neuvième année, jusqu’à ce que vienne sa récolte, vous mangerez l’ancienne. ");
INSERT INTO francl_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Les terres ne se vendront pas à perpétuité, car le pays est à moi, et vous êtes chez moi comme des étrangers et des gens en séjour. ");
INSERT INTO francl_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Dans tout le pays que vous posséderez, vous accorderez un droit de rachat pour les terres. ");
INSERT INTO francl_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Si ton frère est devenu pauvre et vend une portion de sa propriété, son représentant, son parent le plus proche viendra et rachètera ce qu’a vendu son frère. ");
INSERT INTO francl_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Si un homme n’a personne qui le représente, et que lui-même se procure de quoi faire le rachat, ");
INSERT INTO francl_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","il comptera les années écoulées depuis la vente, rendra le surplus à l’acquéreur, et retournera dans sa propriété. ");
INSERT INTO francl_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","S’il ne trouve pas de quoi lui faire cette restitution, le bien vendu restera entre les mains de l’acquéreur jusqu’à l’année du jubilé ; au jubilé, il sera libéré, et le vendeur rentrera dans sa propriété. ");
INSERT INTO francl_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Si un homme vend une maison d’habitation dans une ville entourée de murs, il aura le droit de rachat jusqu’au terme de l’année de la vente ; son droit de rachat durera une année pleine. ");
INSERT INTO francl_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Que si la maison qui est située dans une ville murée n’est pas rachetée avant l’expiration d’une année complète, elle appartiendra à perpétuité à l’acquéreur et à ses descendants ; elle ne sortira pas de leur possession au jubilé. ");
INSERT INTO francl_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Mais les maisons des villages non entourés de murs seront considérées comme allant avec le fonds de terre ; on pourra les racheter, et elles seront libérées au jubilé. ");
INSERT INTO francl_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Quant aux villes des Lévites et aux maisons des villes qu’ils posséderont, les Lévites auront un droit perpétuel de rachat. ");
INSERT INTO francl_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Si quelqu’un achète des Lévites une maison, la maison vendue dans la ville qui leur a été donnée sera libérée au jubilé, car les maisons des villes des Lévites sont leur propriété au milieu des enfants d’Israël. ");
INSERT INTO francl_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Les champs de la banlieue des villes des Lévites ne seront pas vendus, car c’est leur possession à perpétuité. ");
INSERT INTO francl_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Si ton frère devient pauvre et que sa main s’affaiblisse près de toi, tu le soutiendras, fût-il étranger ou hôte, afin qu’il vive auprès de toi. ");
INSERT INTO francl_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Ne tire de lui ni intérêt ni profit, mais crains ton Dieu et que ton frère vive avec toi. ");
INSERT INTO francl_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Tu ne lui prêteras pas ton argent à intérêt, et tu ne lui donneras pas de tes vivres pour en tirer profit. ");
INSERT INTO francl_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Je suis Yahweh, ton Dieu, qui vous ai fait sortir du pays d’Égypte, pour vous donner le pays de Canaan, pour être votre Dieu. ");
INSERT INTO francl_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Si ton frère devient pauvre près de toi et qu’il se vende à toi, tu n’exigeras pas de lui le travail d’un esclave. ");
INSERT INTO francl_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Il sera chez toi comme un mercenaire, comme un hôte ; il te servira jusqu’à l’année du jubilé. ");
INSERT INTO francl_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Il sortira alors de chez toi, lui et ses enfants avec lui, et il retournera dans sa famille, et rentrera dans la propriété de ses pères. ");
INSERT INTO francl_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Car ils sont mes serviteurs, que j’ai fait sortir du pays d’Égypte : ils ne seront pas vendus comme on vend des esclaves. ");
INSERT INTO francl_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Tu ne domineras pas sur lui avec dureté, mais tu craindras ton Dieu. ");
INSERT INTO francl_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Tes esclaves et tes servantes qui t’appartiendront, tu les prendras des nations qui t’entourent ; c’est d’elles que vous achèterez serviteurs et servantes. ");
INSERT INTO francl_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Vous pourrez aussi en acheter parmi les enfants des étrangers qui séjournent chez vous, et parmi leurs familles qui vivent avec vous, qu’ils auront engendrés dans votre pays ; et ils seront votre propriété. ");
INSERT INTO francl_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Vous les laisserez en héritage à vos enfants après vous, pour les posséder comme une propriété ; ils seront perpétuellement vos esclaves. Mais à l’égard de vos frères, les enfants d’Israël, nul d’entre vous ne dominera sur son frère avec dureté. ");
INSERT INTO francl_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Si un étranger ou un hôte s’est enrichi près de toi, et que ton frère, devenu pauvre près de lui, se soit vendu à l’étranger, à l’hôte qui est près de toi ou au rejeton d’une famille étrangère, ");
INSERT INTO francl_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","il y aura pour lui, après qu’il se sera vendu, le droit de rachat ; un de ses frères pourra le racheter ; ");
INSERT INTO francl_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","ou son oncle, ou le fils de son oncle pourra le racheter ; ou l’un de ses proches parents pourra le racheter ; ou bien, s’il acquiert des richesses, il se rachètera lui-même. ");
INSERT INTO francl_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Il comptera, avec celui qui l’a acheté, depuis l’année où il s’est vendu à lui jusqu’à l’année du jubilé, et le prix de vente se comptera d’après le nombre des années, en évaluant les journées de son travail comme celles d’un mercenaire. ");
INSERT INTO francl_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","S’il y a encore beaucoup d’années, il paiera son rachat à raison du nombre de ces années, en tenant compte du prix auquel il avait été acheté ; ");
INSERT INTO francl_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","s’il reste peu d’années jusqu’à celle du jubilé, il en fera le compte, et il paiera son rachat à raison de ces années. ");
INSERT INTO francl_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Il sera chez lui comme un mercenaire de l’année, et son maître ne le traitera pas avec dureté sous tes yeux. ");
INSERT INTO francl_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","S’il n’est racheté d’aucune de ces manières, il sortira libre l’année du jubilé, lui et ses enfants avec lui. ");
INSERT INTO francl_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Car c’est de moi que les enfants d’Israël sont serviteurs ; ils sont mes serviteurs, que j’ai fait sortir du pays d’Égypte. Je suis Yahweh, votre Dieu. » ");
INSERT INTO francl_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","« Vous ne ferez pas d’idoles, vous ne vous dresserez ni image taillée ni stèle sacrée, et vous ne placerez dans votre pays aucune pierre ornée de figures, pour vous prosterner près d’elle ; car je suis Yahweh, votre Dieu. ");
INSERT INTO francl_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Vous observerez mes sabbats, et vous révérerez mon sanctuaire. Je suis Yahweh. » ");
INSERT INTO francl_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","« Si vous suivez mes lois, si vous gardez mes commandements et les mettez en pratique, ");
INSERT INTO francl_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","j’enverrai vos pluies en leur saison ; la terre donnera ses produits, et les arbres des champs donneront leurs fruits. ");
INSERT INTO francl_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Le battage du blé se prolongera chez vous jusqu’à la vendange, et la vendange atteindra les semailles ; vous mangerez votre pain à satiété, et vous habiterez en sécurité dans votre pays. ");
INSERT INTO francl_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Je mettrai la paix dans le pays ; vous dormirez sans que personne vous effraie. Je ferai disparaître du pays les bêtes féroces, et l’épée ne passera pas à travers votre pays. ");
INSERT INTO francl_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Vous poursuivrez vos ennemis, et ils tomberont devant vous par l’épée. ");
INSERT INTO francl_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Cinq d’entre vous en poursuivront cent, et cent d’entre vous en poursuivront dix mille, et vos ennemis tomberont devant vous par l’épée. ");
INSERT INTO francl_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Je me tournerai vers vous, je vous rendrai féconds et je vous multiplierai, et j’établirai mon alliance avec vous. ");
INSERT INTO francl_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Vous mangerez des récoltes anciennes, très anciennes, et vous rejetterez l’ancienne pour faire place à la nouvelle. ");
INSERT INTO francl_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","J’établirai ma demeure au milieu de vous, et mon âme ne vous prendra pas en dégoût. ");
INSERT INTO francl_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Je marcherai au milieu de vous, je serai votre Dieu, et vous serez mon peuple. ");
INSERT INTO francl_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Je suis Yahweh, votre Dieu, qui vous ai fait sortir du pays d’Égypte, pour que vous n’y fussiez plus esclaves ; j’ai brisé les barres de votre joug et je vous ai fait marcher tête levée. ");
INSERT INTO francl_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Mais si vous ne n’écoutez pas et ne mettez pas en pratique tous ces commandements, ");
INSERT INTO francl_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","si vous méprisez mes lois, et si votre âme a en dégoût mes ordonnances, pour ne pas pratiquer tous mes commandements et pour violer mon alliance, ");
INSERT INTO francl_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","voici à mon tour ce que je vous ferai : J’enverrai sur vous la terreur, la consomption et la fièvre, qui font languir les yeux et défaillir l’âme. Vous sèmerez en vain votre semence ; vos ennemis la mangeront. ");
INSERT INTO francl_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Je tournerai ma face contre vous, et vous serez battus par vos ennemis ; ceux qui vous haïssent domineront sur vous, et vous fuirez sans que personne vous poursuive. ");
INSERT INTO francl_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Si, après cela, vous ne m’écoutez pas, je vous châtierai sept fois plus pour vos péchés. ");
INSERT INTO francl_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Je briserai l’orgueil de votre force ; je rendrai votre ciel comme de fer, et votre terre comme d’airain. ");
INSERT INTO francl_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Votre force se dépensera inutilement : votre terre ne donnera pas ses produits, et les arbres de la terre ne donneront pas leurs fruits. ");
INSERT INTO francl_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Si vous marchez encore contre moi et ne voulez pas m’écouter, je vous frapperai sept fois plus selon vos péchés. ");
INSERT INTO francl_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Je lâcherai contre vous les animaux sauvages, qui vous raviront vos enfants, déchireront votre bétail et vous réduiront à un petit nombre ; et vos chemins deviendront déserts. ");
INSERT INTO francl_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Si avec ces châtiments vous ne vous laissez pas corriger par moi et si vous marchez toujours contre moi, ");
INSERT INTO francl_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","à mon tour je marcherai contre vous, et je vous frapperai, moi aussi, sept fois plus pour vos péchés. ");
INSERT INTO francl_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Je ferai venir contre vous l’épée vengeresse de mon alliance ; vous vous rassemblerez dans vos villes, et j’enverrai la peste au milieu de vous, et vous serez livrés aux mains de l’ennemi, ");
INSERT INTO francl_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","lorsque je vous retirerai le pain, votre soutien, que dix femmes cuiront votre pain dans un seul four et rendront votre pain au poids, et que vous mangerez sans être rassasiés. ");
INSERT INTO francl_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Si, après cela, vous ne m’écoutez pas et marchez encore contre moi, ");
INSERT INTO francl_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","je marcherai contre vous avec fureur et je vous châtierai, moi aussi, sept fois plus pour vos péchés. ");
INSERT INTO francl_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Vous mangerez la chair de vos fils, et vous mangerez la chair de vos filles. ");
INSERT INTO francl_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Je détruirai vos hauts lieux, j’abattrai vos stèles consacrées au soleil, je placerai vos cadavres sur les cadavres de vos infâmes idoles, et mon âme vous rejettera avec horreur. ");
INSERT INTO francl_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Je réduirai vos villes en déserts, je ravagerai vos sanctuaires, et je ne respirerai plus l’odeur agréable de vos parfums. ");
INSERT INTO francl_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Je dévasterai le pays, et vos ennemis qui l’habiteront en seront stupéfaits. ");
INSERT INTO francl_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Et vous, je vous disperserai parmi les nations et je tirerai l’épée derrière vous ; votre pays sera dévasté, et vos villes seront désertes. ");
INSERT INTO francl_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Alors la terre jouira de ses sabbats, tout le temps que durera sa solitude et que vous serez dans le pays de vos ennemis. Alors la terre se reposera et jouira de ses sabbats. ");
INSERT INTO francl_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Tout le temps qu’elle sera dévastée, elle aura le repos qu’elle n’avait pas eu dans vos sabbats, lorsque vous l’habitiez. ");
INSERT INTO francl_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Ceux d’entre vous qui survivront, je leur mettrai au cœur l’épouvante, dans les pays de leurs ennemis : le bruit d’une feuille agitée les mettra en fuite ; ils fuiront comme on fait devant l’épée, et ils tomberont sans qu’on les poursuive. ");
INSERT INTO francl_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Ils trébucheront les uns contre les autres comme devant l’épée, sans qu’on les poursuive ; vous ne tiendrez pas en présence de vos ennemis. ");
INSERT INTO francl_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Vous périrez parmi les nations, et le pays de vos ennemis vous dévorera. ");
INSERT INTO francl_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Ceux d’entre vous qui survivront, se consumeront à cause de leurs iniquités, dans le pays de leurs ennemis ; ils seront aussi consumés à cause des iniquités de leurs pères, lesquelles sont encore avec eux. ");
INSERT INTO francl_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","Ils confesseront leur iniquité et l’iniquité de leurs pères, dans les transgressions qu’ils ont commises contre moi, reconnaissant que c’est parce qu’ils ont marché contre moi ");
INSERT INTO francl_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","que moi aussi j’ai marché contre eux et les ai fait venir dans le pays de leurs ennemis. Si alors leur cœur incirconcis s’humilie, et qu’ils acceptent le châtiment de leurs fautes, je me souviendrai de mon alliance avec Jacob, ");
INSERT INTO francl_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","je me souviendrai aussi de mon alliance avec Isaac et aussi de mon alliance avec Abraham, et je me souviendrai du pays. ");
INSERT INTO francl_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Et le pays sera abandonné par eux et il jouira de ses sabbats, pendant qu’il sera dévasté loin d’eux, et ils accepteront le châtiment de leurs fautes, parce qu’ils ont méprisé mes ordonnances et que leur âme a eu mes lois en dégoût. ");
INSERT INTO francl_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Mais même ainsi, lorsqu’ils seront dans le pays de leurs ennemis, je ne les rejetterai pas et je ne les aurai pas en dégoût jusqu’à les exterminer et à rompre mon alliance avec eux ; car je suis Yahweh, leur Dieu. ");
INSERT INTO francl_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Je me souviendrai en leur faveur de l’alliance conclue avec leurs ancêtres, que j’ai fait sortir du pays d’Égypte, aux yeux des nations, pour être leur Dieu. Je suis Yahweh. » ");
INSERT INTO francl_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Tels sont les statuts, les ordonnances et les lois que Yahweh établit entre lui et les enfants d’Israël, sur la montagne de Sinaï, par le ministère de Moïse. ");
INSERT INTO francl_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","« Parle aux enfants d’Israël, et dis-leur : Si quelqu’un fait un vœu, les personnes seront à Yahweh selon ton estimation. ");
INSERT INTO francl_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Si l’objet de ton estimation est un homme de vingt à soixante ans, ton estimation sera de cinquante sicles d’argent, selon le sicle du sanctuaire ; ");
INSERT INTO francl_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","si c’est une femme, ton estimation sera de trente sicles. ");
INSERT INTO francl_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","De cinq ans à vingt ans, ton estimation sera de vingt sicles pour un garçon, et de dix sicles pour une fille. ");
INSERT INTO francl_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","D’un mois à cinq ans, ton estimation sera de cinq sicles d’argent pour un garçon, et pour une fille ton estimation sera de trois sicles d’argent. ");
INSERT INTO francl_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","De soixante ans et au-dessus, ton estimation sera de quinze sicles pour un homme, et de dix sicles pour une femme. ");
INSERT INTO francl_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Si celui qui a fait le vœu est trop pauvre pour payer la valeur de ton estimation, on le présentera au prêtre, qui fera son estimation ; le prêtre fera l’estimation d’après les ressources de celui qui a fait le vœu. ");
INSERT INTO francl_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Si l’on voue un des animaux dont on fait offrande à Yahweh, tout ce qu’on en donne ainsi à Yahweh sera chose sainte. ");
INSERT INTO francl_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","On ne le changera point, on ne mettra pas un mauvais à la place d’un bon, ni un bon à la place d’un mauvais ; si l’on remplace un animal par un autre, ils seront l’un et l’autre chose sainte. ");
INSERT INTO francl_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Si c’est quelque animal impur dont on ne peut faire offrande à Yahweh, on présentera l’animal au prêtre, ");
INSERT INTO francl_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","et le prêtre en fera l’estimation selon qu’il sera bon ou mauvais, et l’on s’en rapportera à l’estimation de prêtre. ");
INSERT INTO francl_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Si on veut le racheter, on ajoutera un cinquième à ton estimation. ");
INSERT INTO francl_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Si quelqu’un sanctifie sa maison en la consacrant à Yahweh, le prêtre en fera l’estimation selon qu’elle est bonne ou mauvaise, et l’on s’en tiendra à l’estimation du prêtre. ");
INSERT INTO francl_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Si celui qui a sanctifié sa maison veut la racheter, il ajoutera un cinquième au prix de ton estimation, et elle sera à lui. ");
INSERT INTO francl_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Si quelqu’un consacre à Yahweh une partie du champ qui est sa propriété, ton estimation se fera d’après la quantité de grain nécessaire pour l’ensemencer, à raison de cinquante sicles d’argent pour un chomer de semence d’orge. ");
INSERT INTO francl_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Si c’est dès l’année du jubilé qu’il consacre son champ, on s’en tiendra à ton estimation ; ");
INSERT INTO francl_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","mais si c’est après le jubilé qu’il consacre son champ, le prêtre en évaluera le prix à raison du nombre d’années qui restent jusqu’au jubilé, et il sera fait une réduction sur ton estimation. ");
INSERT INTO francl_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Si celui qui a consacré son champ veut le racheter, il ajoutera un cinquième au prix de ton estimation, et le champ lui restera. ");
INSERT INTO francl_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","S’il ne rachète pas le champ, ou qu’il le vende à un autre homme, ce champ ne pourra plus être racheté ; ");
INSERT INTO francl_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","et quand il sera libéré au jubilé, le champ sera consacré à Yahweh, comme un champ qui a été voué : il deviendra la propriété du prêtre. ");
INSERT INTO francl_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Si quelqu’un consacre à Yahweh un champ acheté par lui et ne faisant pas partie de son patrimoine, ");
INSERT INTO francl_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","le prêtre en évaluera le prix d’après ton estimation jusqu’à l’année du jubilé, et cet homme paiera le jour même le prix fixé, comme chose consacrée à Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","L’année du jubilé, le champ retournera à celui de qui on l’avait acheté et du patrimoine duquel il faisait partie. ");
INSERT INTO francl_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Toutes tes estimations seront faites au sicle du sanctuaire : le sicle est de vingt guéras. ");
INSERT INTO francl_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Nul, toutefois, ne pourra consacrer le premier-né de son bétail, lequel, comme premier-né, appartient déjà à Yahweh : bœuf ou brebis, il appartient à Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","S’il s’agit d’un animal impur, on le rachètera au prix de ton estimation, en y ajoutant un cinquième ; s’il n’est pas racheté, il sera vendu d’après ton estimation. ");
INSERT INTO francl_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Rien de ce qu’un homme aura voué par anathème à Yahweh, dans tout ce qui lui appartient, que ce soit un homme, un animal ou un champ de son patrimoine, ne pourra ni se vendre, ni se racheter ; tout ce qui est voué par anathème est chose très sainte, appartenant à Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Aucune personne vouée par anathème ne pourra être rachetée : elle sera mise à mort. ");
INSERT INTO francl_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Toute dîme de la terre, prélevée soit sur les semences de la terre, soit sur les fruits des arbres, appartient à Yahweh : c’est une chose consacrée à Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Si quelqu’un veut racheter quelque chose de sa dîme, il y ajoutera un cinquième. ");
INSERT INTO francl_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Quant aux dîmes de gros et de menu bétail, de tout ce qui passe sous la houlette, le dixième animal sera consacré à Yahweh. ");
INSERT INTO francl_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","On ne fera pas un choix entre ce qui est bon ou mauvais, et l’on ne fera pas d’échange ; et si l’on fait un échange, l’animal remplacé et celui qui le remplace seront tous deux chose sainte et ne pourront être rachetés. » ");
INSERT INTO francl_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Tels sont les commandements que Yahweh donna à Moïse pour les enfants d’Israël, sur la montagne de Sinaï. ");
INSERT INTO francl_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Yahweh parla à Moïse au désert de Sinaï, dans la tente de réunion, le premier jour du second mois, la deuxième année après leur sortie du pays d’Égypte, en disant : ");
INSERT INTO francl_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","« Faites le compte de toute l’assemblée des enfants d’Israël, selon leurs familles, selon leurs maisons patriarcales, en comptant par tête le nom de tous les mâles ");
INSERT INTO francl_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","depuis l’âge de vingt ans et au-dessus, tous les hommes aptes à porter les armes en Israël ; vous en ferez le dénombrement selon leurs troupes, toi et Aaron. ");
INSERT INTO francl_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Il y aura avec vous un homme de chaque tribu, chef de sa maison patriarcale. ");
INSERT INTO francl_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Voici les noms de ceux qui se tiendront avec vous : Pour Ruben : Elisur, fils de Sédéur ; ");
INSERT INTO francl_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","pour Siméon : Salamiel, fils de Surisaddaï ; ");
INSERT INTO francl_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","pour Juda : Nahasson, fils d’Aminadab ; ");
INSERT INTO francl_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","pour Issachar : Nathanaël, fils de Suar ; ");
INSERT INTO francl_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","pour Zabulon : Eliab, fils de Hélon ; ");
INSERT INTO francl_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","pour les fils de Joseph, pour Ephraïm : Elisama, fils d’Ammiud ; pour Manassé : Gamaliel, fils de Phadassur ; ");
INSERT INTO francl_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","pour Benjamin : Abidan, fils de Gédéon ; ");
INSERT INTO francl_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","pour Dan : Ahiéser, fils d’Ammisaddaï ; ");
INSERT INTO francl_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","pour Aser : Phégiel, fils d’Ochran ; ");
INSERT INTO francl_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","pour Gad : Eliasaph, fils de Duel ; ");
INSERT INTO francl_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","pour Nephtali : Ahira, fils d’Enan. » ");
INSERT INTO francl_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Tels sont ceux qui furent appelés de l’assemblée ; ils étaient princes des tribus de leurs pères, chefs des milliers d’Israël. ");
INSERT INTO francl_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Moïse et Aaron, ayant pris ces hommes qui avaient été désignés par leurs noms, ");
INSERT INTO francl_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","convoquèrent toute l’assemblée pour le premier jour du deuxième mois. Et ils furent enregistrés selon leurs familles, selon leurs maisons patriarcales, en comptant par tête les noms, depuis l’âge de vingt et au-dessus. ");
INSERT INTO francl_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Comme Yahweh l’avait ordonné à Moïse, celui-ci en fit le dénombrement dans le désert de Sinaï. ");
INSERT INTO francl_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Fils de Ruben, premier-né d’Israël, leurs descendants selon leurs familles, selon leurs maisons patriarcales, en comptant les noms par tête, tous les mâles depuis l’âge de vingt ans et au-dessus, tous les hommes en état de porter des armes : ");
INSERT INTO francl_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","les recensés de la tribu de Ruben furent quarante-six mille cinq cents. ");
INSERT INTO francl_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Fils de Siméon, leurs descendants selon leurs familles, selon leurs maisons patriarcales, leurs recensés en comptant les noms par tête, tous les mâles depuis l’âge de vingt ans et au-dessus, tous les hommes en état de porter les armes : ");
INSERT INTO francl_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","les recensés de la tribu de Siméon furent cinquante-neuf mille trois cents. ");
INSERT INTO francl_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Fils de Gad, leurs descendants selon leurs familles, selon leurs maisons patriarcales, en comptant les noms depuis l’âge de vingt ans et au-dessus, tous les hommes en état de porter les armes : ");
INSERT INTO francl_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","les recensés de la tribu de Gad furent quarante-cinq mille six cent cinquante. ");
INSERT INTO francl_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Fils de Juda, leurs descendants selon leurs familles, selon leurs maisons patriarcales, en comptant les noms depuis l’âge de vingt ans et au-dessus, tous les hommes en état de porter les armes : ");
INSERT INTO francl_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","les recensés de la tribu de Juda furent soixante-quatorze mille six cents. ");
INSERT INTO francl_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Fils d’Issachar, leurs descendants selon leurs familles, selon leurs maisons patriarcales, en comptant les noms depuis l’âge de vingt ans et au-dessus, tous les hommes en état de porter les armes : ");
INSERT INTO francl_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","les recensés de la tribu d’Issachar furent cinquante-quatre mille quatre cents. ");
INSERT INTO francl_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Fils de Zabulon, leurs descendants selon leurs familles, selon leurs maisons patriarcales, en comptant les noms depuis l’âge de vingt ans et au-dessus, tous les hommes en état de porter les armes : ");
INSERT INTO francl_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","les recensés de la tribu de Zabulon furent cinquante-sept mille quatre cents. ");
INSERT INTO francl_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Fils de Joseph, — fils d’Ephraïm, leurs descendants selon leurs familles, selon leurs maisons patriarcales, en comptant les noms depuis l’âge de vingt ans et au-dessus, tous les hommes en état de porter les armes : ");
INSERT INTO francl_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","les recensés de la tribu d’Ephraïm furent quarante mille cinq cents. ");
INSERT INTO francl_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","— Fils de Manassé, leurs descendants selon leurs familles, selon leurs maisons patriarcales, en comptant les noms depuis l’âge de vingt ans et au-dessus, tous les hommes en état de porter les armes : ");
INSERT INTO francl_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","les recensés de la tribu de Manassé furent trente-deux mille deux cents. ");
INSERT INTO francl_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Fils de Benjamin, leurs descendants selon leurs familles, selon leurs maisons patriarcales, en comptant les noms depuis l’âge de vingt ans et au-dessus, tous les hommes en état de porter les armes : ");
INSERT INTO francl_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","les recensés de la tribu de Benjamin furent trente-cinq mille quatre cents. ");
INSERT INTO francl_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Fils de Dan, leurs descendants selon leurs familles, selon leurs maisons patriarcales, en comptant les noms depuis vingt ans et au-dessus, tous les hommes en état de porter les armes : ");
INSERT INTO francl_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","les recensés de la tribu de Dan furent soixante-deux mille sept cents. ");
INSERT INTO francl_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Fils d’Aser, leurs descendants selon leurs familles, selon leurs maisons patriarcales, en comptant les noms depuis vingt ans et au-dessus, tous les hommes en état de porter les armes : ");
INSERT INTO francl_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","les recensés de la tribu d’Aser furent quarante et un mille cinq cents. ");
INSERT INTO francl_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Fils de Nephtali, leurs descendants selon leurs familles, selon leurs maisons patriarcales, en comptant les noms depuis l’âge de vingt ans et au-dessus, tous les hommes en état de porter les armes : ");
INSERT INTO francl_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","les recensés de la tribu de Nephtali furent cinquante-trois mille quatre cents. ");
INSERT INTO francl_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Tels sont ceux qui furent recensés, que recensèrent Moïse et Aaron, avec les princes d’Israël, au nombre de douze : un homme pour chacune de leurs maisons patriarcales. ");
INSERT INTO francl_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Tous les enfants d’Israël dont on fit le recensement, selon leurs maisons patriarcales, depuis l’âge de vingt ans et au-dessus, tous les hommes d’Israël en état de porter les armes, ");
INSERT INTO francl_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","tous les recensés furent six cent trois mille cinq cent cinquante. ");
INSERT INTO francl_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Les Lévites, selon leur tribu patriarcale, ne furent pas recensés avec eux. ");
INSERT INTO francl_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","« Tu ne feras pas le recensement de la tribu de Lévi, et tu n’en réuniras pas le compte avec celui des enfants d’Israël. ");
INSERT INTO francl_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Remets à leur soin la demeure du témoignage, tous ses ustensiles et tout ce qui lui appartient. Ils porteront la Demeure et tous ses ustensiles, ils en feront le service, et ils camperont autour de la Demeure. ");
INSERT INTO francl_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Quand la Demeure partira, les Lévites la démonteront ; quand la Demeure campera, les Lévites la dresseront ; et l’étranger qui s’en approchera sera puni de mort. ");
INSERT INTO francl_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Les enfants d’Israël camperont chacun dans son camp, chacun près de sa bannière, selon leurs troupes. ");
INSERT INTO francl_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Mais les Lévites camperont autour de la Demeure du témoignage, afin que ma colère n’éclate pas sur l’assemblée des enfants d’Israël ; et les Lévites auront la garde de la Demeure du témoignage. » ");
INSERT INTO francl_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Les enfants d’Israël agirent selon tout ce que Yahweh avait ordonné à Moïse ; ils firent ainsi. ");
INSERT INTO francl_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","« Les enfants d’Israël camperont chacun près de sa bannière, sous les enseignes de leurs maisons patriarcales ; ils camperont vis-à-vis de la tente de réunion, tout autour. ");
INSERT INTO francl_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","A l’avant, vers l’orient, campera la bannière du camp de Juda, avec ses troupes ; le prince des fils de Juda est Nahasson, fils d’Aminadab, ");
INSERT INTO francl_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","et son corps d’armée, d’après les hommes recensés, est de soixante-quatorze mille six cents hommes. ");
INSERT INTO francl_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","A ses côtés campera la tribu d’Issachar ; le prince des fils d’Issachar est Nathanaël, fils de Suar, ");
INSERT INTO francl_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","et son corps d’armée, d’après les hommes recensés, est de cinquante-quatre mille quatre cents hommes. ");
INSERT INTO francl_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Puis la tribu de Zabulon ; le prince des fils de Zabulon est Eliab, fils de Hélon, ");
INSERT INTO francl_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","et son corps d’armée, d’après les hommes recensés, est de cinquante-sept mille quatre cents hommes. ");
INSERT INTO francl_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Total pour le camp de Juda, d’après les hommes recensés : cent quatre-vingt-six mille quatre cents hommes, selon leurs troupes. Ils se mettront en marche les premiers. ");
INSERT INTO francl_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Au midi, la bannière du camp de Ruben, avec ses troupes ; le prince des fils de Ruben est Elisur, fils de Sédéur, ");
INSERT INTO francl_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","et son corps d’armée, d’après les hommes recensés, est de quarante-six mille cinq cents hommes. ");
INSERT INTO francl_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","A ses côtés campera la tribu de Siméon ; le prince des fils de Siméon est Salamiel, fils de Surisaddaï, ");
INSERT INTO francl_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","et son corps d’armée, d’après les hommes recensés, est de cinquante-neuf mille trois cents hommes. ");
INSERT INTO francl_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Puis la tribu de Gad ; le chef des fils de Gad est Eliasaph, fils de Duel, ");
INSERT INTO francl_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","et son corps d’armée, d’après les hommes recensés, est de quarante-cinq mille six cent cinquante hommes. ");
INSERT INTO francl_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Total pour le camp de Ruben, d’après les hommes recensés : cent cinquante et un mille quatre cent cinquante hommes, selon leurs troupes. Ils se mettront en marche les seconds. ");
INSERT INTO francl_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Ensuite s’avancera la tente de réunion, le camp des Lévites au milieu des autres camps. Ils suivront dans la marche l’ordre de leur campement, chacun à son rang, selon sa bannière. ");
INSERT INTO francl_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","A l’occident, la bannière d’Ephraïm, avec ses troupes ; le prince des fils d’Ephraïm est Elisama, fils d’Ammiud, ");
INSERT INTO francl_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","et son corps d’armée, d’après les hommes recensés, est de quarante mille cinq cents hommes. ");
INSERT INTO francl_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","A ses côtés campera la tribu de Manassé ; le prince des fils de Manassé est Gamaliel, fils de Phadassur, ");
INSERT INTO francl_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","et son corps d’armée, d’après les hommes recensés, est de trente-deux mille deux cents hommes. ");
INSERT INTO francl_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Puis la tribu de Benjamin ; le prince des fils de Benjamin est Abidan, fils de Gédéon, ");
INSERT INTO francl_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","et son corps d’armée, d’après les hommes recensés, est de trente-cinq mille quatre cents hommes. ");
INSERT INTO francl_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Total pour le camp d’Ephraïm, d’après les hommes recensés : cent huit mille et cent hommes, selon leurs troupes. Ils se mettront en marche les troisièmes. ");
INSERT INTO francl_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Au nord, la bannière du camp de Dan, avec ses troupes ; le prince des fils de Dan est Ahiéser, fils d’Ammisaddaï, ");
INSERT INTO francl_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","et son corps d’armée, d’après les hommes recensés, est de soixante-deux mille sept cents hommes. ");
INSERT INTO francl_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","A ses côtés campera la tribu d’Aser ; le prince des fils d’Aser est Phégiel, fils d’Ochran, ");
INSERT INTO francl_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","et son corps d’armée, d’après les hommes recensés, est de quarante-et-un mille cinq cents hommes. ");
INSERT INTO francl_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Puis la tribu de Nephtali ; le prince des fils de Nephtali est Ahira, fils d’Enan, ");
INSERT INTO francl_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","et son corps d’armée, d’après les hommes recensés, est de cinquante-trois mille quatre cents hommes. ");
INSERT INTO francl_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Total pour le camp de Dan, d’après les hommes recensés : cent cinquante-sept mille six cents hommes. Ils se mettront en marche les derniers, selon leurs bannières. » ");
INSERT INTO francl_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Tels furent les enfants d’Israël inscrits au recensement selon leurs maisons patriarcales. Total pour tous les hommes recensés, répartis en divers camps, selon leurs troupes d’armée : six cent trois mille cinq cent cinquante hommes. ");
INSERT INTO francl_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Les Lévites ne furent pas compris dans le recensement avec les enfants d’Israël, suivant que Yahweh l’avait ordonné à Moïse. ");
INSERT INTO francl_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Et les enfants d’Israël agirent selon tout ce que Yahweh avait ordonné à Moïse. C’est ainsi qu’ils campaient, selon leurs bannières, et ainsi qu’ils se mettaient en marche, chacun selon sa famille, selon sa maison patriarcale. ");
INSERT INTO francl_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Voici la postérité d’Aaron et de Moïse, au temps où Yahweh parla à Moïse sur la montagne de Sinaï ");
INSERT INTO francl_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Voici les noms des fils d’Aaron : Nadab, le premier-né, Abiu, Eléazar et Ithamar. ");
INSERT INTO francl_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Tels sont les noms des fils d’Aaron, des prêtres ayant reçu l’onction, installés pour exercer le sacerdoce. ");
INSERT INTO francl_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Nadab et Abiu moururent devant Yahweh, lorsqu’ils apportèrent devant Yahweh du feu étranger, dans le désert de Sinaï ; ils n’avaient pas de fils. Eléazar et Ithamar exercèrent le sacerdoce en présence d’Aaron, leur père. ");
INSERT INTO francl_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","« Fais approcher la tribu de Lévi, et tu la placeras devant Aaron le prêtre, pour qu’elle soit à son service. ");
INSERT INTO francl_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Ils auront la charge de tout ce qui est commis à sa charge et à la charge de toute l’assemblée, devant la tente de réunion, faisant ainsi le service de la Demeure. ");
INSERT INTO francl_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Ils seront chargés de tous les ustensiles de la tente de réunion, et de ce qui est commis à la charge des enfants d’Israël : ils feront ainsi le service de la Demeure. ");
INSERT INTO francl_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Tu donneras les Lévites à Aaron et à ses fils ; ils lui seront entièrement donnés, d’entre les enfants d’Israël. ");
INSERT INTO francl_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Tu établiras Aaron et ses fils pour accomplir les fonctions de leur sacerdoce ; l’étranger qui approchera du sanctuaire sera puni de mort. » ");
INSERT INTO francl_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","« Voici, j’ai pris les Lévites du milieu des enfants d’Israël, à la place de tout premier-né qui ouvre le sein de sa mère parmi les enfants d’Israël, et les Lévites sont à moi. ");
INSERT INTO francl_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Car tout premier-né est à moi ; le jour où j’ai frappé tous les premiers nés dans le pays d’Égypte, je me suis consacré tout premier-né en Israël, tant des hommes que des animaux : ils sont à moi. Je suis Yahweh. » ");
INSERT INTO francl_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Yahweh parla à Moïse dans le désert de Sinaï, en disant : ");
INSERT INTO francl_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","« Fais le recensement des enfants de Lévi selon leurs maisons patriarcales, selon leurs familles. Tu feras le recensement de tous les mâles, depuis l’âge d’un mois et au-dessus. » ");
INSERT INTO francl_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Moïse fit leur recensement sur l’ordre de Yahweh, selon qu’il lui avait été commandé. ");
INSERT INTO francl_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Voici les fils de Lévi, d’après leurs noms : Gerson, Caath et Mérari. — ");
INSERT INTO francl_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Voici les noms des fils de Gerson, selon leurs familles : Lebni et Séméi. ");
INSERT INTO francl_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Fils de Caath, selon leurs familles : Amram, Jésaar, Hébron et Oziel. ");
INSERT INTO francl_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Fils de Mérari, selon leurs familles : Moholi et Musi. — Ce sont là les familles de Lévi selon leurs maisons patriarcales. ");
INSERT INTO francl_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","De Gerson viennent la famille de Lebni et la famille de Séméi ; ce sont les familles de Gersonites. ");
INSERT INTO francl_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Leurs recensés, en comptant tous les mâles depuis l’âge d’un mois et au-dessus, leurs recensés furent sept mille cinq cents. ");
INSERT INTO francl_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Les familles des Gersonites campaient derrière la Demeure, à l’occident. ");
INSERT INTO francl_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Le prince de la maison patriarcale des Gersonites était Eliasaph, fils de Laël. ");
INSERT INTO francl_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","En ce qui concerne la tente de réunion, les fils de Gerson avaient la charge de la Demeure et de la tente, de sa couverture, du rideau qui est à l’entrée de la tente de réunion, ");
INSERT INTO francl_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","des tentures du parvis et du rideau de l’entrée du parvis, tout autour de la Demeure et de l’autel, et de ses cordages pour tout son service. ");
INSERT INTO francl_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","De Caath viennent la famille des Amramites, la famille des Jésaarites, la famille des Hébronites et la famille des Oziélites ; ce sont là les familles des Caathites. ");
INSERT INTO francl_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","En comptant tous les mâles depuis l’âge d’un mois et au-dessus, on en trouva huit mille six cents, chargés de la garde du sanctuaire. ");
INSERT INTO francl_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Les familles des fils de Caath campaient au côté méridional de la Demeure. ");
INSERT INTO francl_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Le prince de la maison patriarcale des familles des Caathites était Elisaphan, fils d’Oziel. ");
INSERT INTO francl_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","On confia à leur garde l’arche, la table de proposition, le chandelier, les autels, les ustensiles du sanctuaire avec lesquels on fait le service, le voile et tout ce qui se rapporte à son service. ");
INSERT INTO francl_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Le prince des princes des Lévites était Eléazar, fils du prêtre Aaron ; il avait la surveillance de ceux qui étaient chargés de la garde du sanctuaire. ");
INSERT INTO francl_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","De Mérari viennent la famille des Moholites et la famille des Musites : ce sont là les familles des Mérarites. ");
INSERT INTO francl_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Leurs recensés, en comptant tous les mâles depuis l’âge d’un mois et au-dessus, furent six mille deux cents. ");
INSERT INTO francl_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Le prince de la maison patriarcale des familles de Mérari était Suriel, fils d’Abihaiel. Ils campaient au côté septentrional de la Demeure. ");
INSERT INTO francl_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Les fils de Mérari eurent le soin et la garde des ais de la Demeure, de ses traverses, de ses colonnes et de leurs socles, de tous ses ustensiles et de tout son service, ");
INSERT INTO francl_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","des colonnes du parvis tout autour, de leurs socles, de leurs pieux et de leurs cordages. ");
INSERT INTO francl_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","En face de la Demeure, à l’orient, devant la tente de réunion, au levant, campaient Moïse, Aaron et ses fils ; ils avaient la garde du sanctuaire, pour ce qui était remis à la garde des enfants d’Israël ; l’étranger qui s’en approcherait devait être puni de mort. ");
INSERT INTO francl_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Total des Lévites recensés dont Moïse fit le recensement sur l’ordre de Yahweh selon leurs familles, de tous les mâles depuis l’âge d’un mois et au-dessus : vingt-deux mille. ");
INSERT INTO francl_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Yahweh dit à Moïse : « Fais le recensement de tous les premiers-nés mâles parmi les enfants d’Israël, depuis l’âge d’un mois et au-dessus, et fais le compte de leurs noms. ");
INSERT INTO francl_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Tu prendras les Lévites pour moi, — je suis Yahweh, — à la place de tous les premiers-nés des enfants d’Israël, et le bétail des Lévites à la place de tous les premiers-nés du bétail des enfants d’Israël. » ");
INSERT INTO francl_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Moïse fit le recensement de tous les premiers-nés parmi les enfants d’Israël, selon l’ordre que Yahweh lui avait donné. ");
INSERT INTO francl_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Tous les premiers-nés mâles, comptés par leurs noms, depuis l’âge d’un mois et au-dessus, dont on fit le recensement, furent vingt-deux mille deux cent soixante-treize. ");
INSERT INTO francl_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","« Prends les Lévites à la place de tous les premiers-nés des enfants d’Israël, et le bétail des Lévites à la place de leur bétail ; et les Lévites seront à moi. Je suis Yahweh. ");
INSERT INTO francl_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Pour le rachat des deux cent soixante-treize d’entre les premiers-nés des enfants d’Israël qui dépassent le nombre des Lévites, ");
INSERT INTO francl_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","tu prendras cinq sicles par tête ; tu les prendras selon le sicle du sanctuaire, qui est de vingt guéras. ");
INSERT INTO francl_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Tu donneras l’argent à Aaron et à ses fils pour le rachat de ceux qui dépassent le nombre des Lévites. » ");
INSERT INTO francl_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Moïse prit l’argent pour le rachat de ceux qui dépassaient le nombre des premiers-nés rachetés par les Lévites ; ");
INSERT INTO francl_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","il prit l’argent des premiers-nés des enfants d’Israël, mille trois cent soixante-cinq sicles, selon le sicle du sanctuaire. ");
INSERT INTO francl_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Et Moïse donna l’argent du rachat à Aaron et à ses fils, sur l’ordre de Yahweh, selon que Yahweh l’avait ordonné à Moïse. ");
INSERT INTO francl_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Yahweh parla à Moïse et à Aaron, en disant : ");
INSERT INTO francl_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","« Compte les fils de Caath parmi les enfants de Lévi, selon leurs familles, selon leurs maisons patriarcales, ");
INSERT INTO francl_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","depuis l’âge de trente ans et au-dessus jusqu’à l’âge de cinquante ans, tous ceux qui ont à faire le service, à remplir quelque fonction dans la tente de réunion. ");
INSERT INTO francl_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Voici quel sera le service des fils de Caath dans la tente de réunion : il portera sur les objets très saints. ");
INSERT INTO francl_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Quand on lèvera le camp, Aaron et ses fils viendront descendre le voile et ils en couvriront l’arche du témoignage ; ");
INSERT INTO francl_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","ils mettront dessus une couverture de peau de veau marin, et ils étendront par-dessus un drap tout entier de pourpre violette ; puis ils placeront les barres de l’arche. ");
INSERT INTO francl_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Ils étendront un drap de pourpre violette sur la table des pains de proposition, et ils mettront dessus les plats, les calices, les patères et les coupes pour les libations ; le pain perpétuel sera sur elle ; ");
INSERT INTO francl_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","ils étendront par-dessus un drap de cramoisi, qu’ils envelopperont d’une couverture de peau de veau de marin, et ils placeront les barres de la table. ");
INSERT INTO francl_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Ils prendront un drap de pourpre violette et ils en couvriront le chandelier, ainsi que ses lampes, ses mouchettes, ses vases à cendre et tous ses vases à huile, nécessaires pour son service ; ");
INSERT INTO francl_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","puis, l’ayant mis, avec tous ses ustensiles, dans une couverture de peau de veau de marin, ils le placeront sur le brancard. ");
INSERT INTO francl_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Ils étendront un drap de pourpre violette sur l’autel d’or, et, après l’avoir enveloppé d’une couverture de peau de veau de marin, ils y mettront les barres. ");
INSERT INTO francl_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Ils prendront tous les ustensiles en usage pour le service dans le sanctuaire, et les ayant mis dans un drap de pourpre violette, ils les envelopperont d’une couverture de peau de veau de marin, et les placeront sur le brancard. ");
INSERT INTO francl_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Ils ôteront les cendres de l’autel et ils étendront par-dessus un drap de pourpre écarlate ; ");
INSERT INTO francl_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","ils mettront dessus tous les ustensiles nécessaires à son service, les brasiers, les fourchettes, les pelles, les bassins, tous les ustensiles de l’autel et, ayant étendu sur le tout une couverture de peau de veau de marin, ils y mettront les barres. ");
INSERT INTO francl_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Quand Aaron et ses fils auront achevé de couvrir le sanctuaire et tous les ustensiles du sanctuaire, et qu’on lèvera le camp, les fils de Caath viendront les emporter, mais ils ne toucheront pas les choses saintes, de peur qu’ils ne meurent. — Voilà ce qu’auront à porter les fils de Caath dans la tente de réunion. ");
INSERT INTO francl_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Eléazar, fils d’Aaron, le prêtre, aura sous sa surveillance l’huile du chandelier, le parfum odoriférant, l’oblation perpétuelle et l’huile d’onction ; il aura la surveillance de toute la Demeure et de tout ce qu’elle contient, du sanctuaire et de tous ses ustensiles. » ");
INSERT INTO francl_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Yahweh parla à Moïse et à Aaron, en disant : ");
INSERT INTO francl_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","« Prenez garde de faire retrancher la tribu des familles des Caathites du milieu des Lévites. ");
INSERT INTO francl_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Agissez ainsi à leur égard, afin qu’ils vivent et ne meurent point, quand ils s’approcheront des objets très saints. Aaron et ses fils viendront, et ils assigneront à chacun d’eux son service et ce qu’il a à porter ; ");
INSERT INTO francl_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","et les Lévites n’entreront pas pour voir un seul instant les choses saintes, de peur qu’ils ne meurent. » ");
INSERT INTO francl_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","« Compte aussi les fils de Gerson d’après leurs maisons patriarcales, d’après leurs familles ; ");
INSERT INTO francl_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","tu feras leur recensement, depuis l’âge de trente ans et au-dessus jusqu’à l’âge de cinquante ans, de tous ceux qui ont à faire le service, à remplir quelque fonction dans la tente de réunion. ");
INSERT INTO francl_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Voici le service des familles des Gersonites, ce qu’ils auront à faire et à porter. ");
INSERT INTO francl_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Ils porteront les tentures de la Demeure et la tente de réunion, sa couverture et la couverture de peau de veau de marin qui se met par-dessus, le rideau qui est à l’entrée de la tente de réunion, ");
INSERT INTO francl_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","les tentures du parvis et le rideau de l’entrée de la porte du parvis, tout autour de la Demeure et de l’autel, leurs cordages et tous les ustensiles à leur usage ; et ils feront tout le service qui s’y rapporte. ");
INSERT INTO francl_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Tout le service des fils des Gersonites sera sous les ordres d’Aaron et de ses fils, pour tout ce qu’ils auront à porter et pour tout ce qu’ils auront à faire ; vous remettrez à leur garde toutes les choses qu’ils ont à porter. ");
INSERT INTO francl_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Tel est le service des familles des fils des Gersonites à l’égard de la tente de réunion ; ils exerceront leur charge sous la direction d’Ithamar, fils d’Aaron, le prêtre. ");
INSERT INTO francl_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Tu feras le recensement des fils de Mérari selon leurs familles, selon leurs maisons patriarcales ; ");
INSERT INTO francl_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","tu les recenseras, depuis l’âge de trente ans et au-dessus jusqu’à l’âge de cinquante ans, tous ceux qui ont à faire le service, à remplir quelque fonction dans la tente de réunion ; ");
INSERT INTO francl_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Voici ce qui sera remis à leur charge, ce qu’ils auront à porter selon tout leur service dans la tente de réunion : les ais de la Demeure, ses traverses, ses colonnes, ses socles ; ");
INSERT INTO francl_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","les colonnes du parvis qui l’entoure, leurs socles, leurs pieux, leurs cordages, tous leurs ustensiles et tout ce qui se rapporte à leur service. Vous ferez l’inventaire par leurs noms des objets qui leur ont été confiés pour les porter ; ");
INSERT INTO francl_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Tel est le service des familles des fils de Mérari, tout leur service à l’égard de la tente de réunion, sous la direction d’Ithamar, fils d’Aaron, le prêtre ». ");
INSERT INTO francl_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Moïse, Aaron et les princes de l’assemblée firent le recensement des fils des Caathites selon leurs familles et selon leurs maisons patriarcales, ");
INSERT INTO francl_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","depuis l’âge de trente et au-dessus jusqu’à l’âge de cinquante ans, tous ceux qui avaient à faire le service, à remplir quelque fonction dans la tente de réunion. ");
INSERT INTO francl_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Les recensés, selon leurs familles, furent deux mille sept cent cinquante. ");
INSERT INTO francl_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Ce furent là les recensés des familles des Caathites, tous ceux qui remplissaient un service dans la tente de réunion. Moïse et Aaron en firent le recensement selon l’ordre de Yahweh par l’organe de Moïse. ");
INSERT INTO francl_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Les recensés des fils de Gerson selon leurs familles et selon leurs maisons patriarcales, ");
INSERT INTO francl_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","depuis l’âge de trente ans et au-dessus jusqu’à l’âge de cinquante ans, tous ceux qui avaient à faire le service, à remplir quelque fonction dans la tente de réunion, ");
INSERT INTO francl_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","les recensés selon leurs familles, selon leurs maisons patriarcales, furent deux mille six cent trente. ");
INSERT INTO francl_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Ce furent là les recensés des familles des fils de Gerson, tous ceux qui remplissaient un service dans la tente de réunion. Moïse et Aaron en firent le recensement sur l’ordre de Yahweh. ");
INSERT INTO francl_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Les recensés des fils de Mérari selon leurs familles, selon leurs maisons patriarcales, ");
INSERT INTO francl_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","depuis l’âge de trente ans et au-dessus jusqu’à l’âge de cinquante ans, tous ceux qui avaient à faire le service, à remplir quelque fonction dans la tente de réunion, ");
INSERT INTO francl_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","les recensés, selon leurs familles, furent trois mille deux cents. ");
INSERT INTO francl_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Ce furent là les recensés des familles des fils de Mérari. Moïse et Aaron en firent le recensement sur l’ordre de Yahweh par l’organe de Moïse. ");
INSERT INTO francl_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Tous les recensés des Lévites, dont Moïse, Aaron et les princes d’Israël firent le recensement, selon leurs familles et selon leurs maisons patriarcales, ");
INSERT INTO francl_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","depuis l’âge de trente ans et au-dessus jusqu’à l’âge de cinquante ans, tous ceux qui avaient à remplir quelque fonction, dans le service et le transport, à l’égard de la tente de réunion, ");
INSERT INTO francl_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","tous les recensés furent huit mille cinq cent quatre-vingts. ");
INSERT INTO francl_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","On en fit le recensement selon l’ordre de Yahweh par l’organe de Moïse, en assignant à chacun le service qu’il devait faire et ce qu’il devait porter ; c’est ainsi qu’ils furent recensés, comme Yahweh l’avait ordonné à Moïse. ");
INSERT INTO francl_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","« Ordonne aux enfants d’Israël de faire sortir du camp quiconque à la lèpre et quiconque a une gonorrhée, et quiconque est souillé par un cadavre. ");
INSERT INTO francl_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Hommes ou femmes, vous les ferez sortir du camp, afin qu’ils ne souillent pas leur camp, au milieu duquel j’habite. » ");
INSERT INTO francl_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Les enfants d’Israël firent ainsi, et ils les firent sortir hors du camp ; comme Yahweh l’avait ordonné à Moïse, ainsi firent les enfants d’Israël. ");
INSERT INTO francl_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","« Dis aux enfants d’Israël : Si quelqu’un, homme ou femme, commet quelqu’un de tous les péchés qui cause un préjudice au prochain, en se rendant infidèle envers Yahweh, et qu’il se soit rendu coupable, ");
INSERT INTO francl_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","il confessera son péché et il restituera en son entier l’objet mal acquis, en y ajoutant un cinquième ; il le remettra à celui envers qui il s’est rendu coupable. ");
INSERT INTO francl_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Si celui-ci n’a pas de représentant à qui puisse être rendu l’objet du délit, cet objet revient à Yahweh, au prêtre, outre le bélier expiatoire avec lequel on fera l’expiation pour le coupable ». ");
INSERT INTO francl_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","« Toute offrande prélevée sur les choses saintes que les enfants d’Israël présentent au prêtre, appartiendra à celui-ci ; ");
INSERT INTO francl_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","les choses que tout homme aura consacré seront à lui ; ce que chacun donne au prêtre lui appartiendra ». ");
INSERT INTO francl_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","« Parle aux enfants d’Israël, et dis-leur : Si une femme mariée se détourne et devient infidèle à son mari, ");
INSERT INTO francl_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","un autre homme ayant eu commerce avec elle, et que la chose soit cachée aux yeux de son mari, cette femme s’étant souillée en secret, sans qu’il y ait eu de témoin contre elle, et sans qu’elle ait été prise sur le fait : ");
INSERT INTO francl_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","— si le mari est saisi d’un esprit de jalousie et qu’il soit jaloux de sa femme qui s’est souillée, ou bien s’il est saisi d’un esprit de jalousie et qu’il soit jaloux de sa femme qui ne s’est pas souillée : ");
INSERT INTO francl_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","cet homme amènera sa femme au prêtre et il apportera une offrande à cause d’elle, un dixième d’épha de farine d’orge ; il n’y versera pas d’huile et n’y mettra pas d’encens, car c’est une oblation de jalousie, une oblation de souvenir, qui rappelle une prévarication. ");
INSERT INTO francl_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Le prêtre la fera approcher de l’autel et se tenir debout devant Yahweh. ");
INSERT INTO francl_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Le prêtre prendra de l’eau sainte dans un vase de terre et, ayant pris de la poussière sur le sol de la Demeure, il la mettra dans l’eau. ");
INSERT INTO francl_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Le prêtre fera tenir la femme debout devant Yahweh, il dénouera la chevelure de la tête de la femme et lui posera sur les mains l’oblation de souvenir ; c’est une oblation de jalousie. Le prêtre aura dans la main les eaux amères qui apportent la malédiction. ");
INSERT INTO francl_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Le prêtre adjurera la femme et lui dira : Si aucun homme n’a couché avec toi, et si tu ne t’es pas détournée pour te souiller, étant sous la puissance de ton mari, sois préservée de l’effet de ces eaux amères qui apportent la malédiction. ");
INSERT INTO francl_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Mais si, étant sous la puissance de ton mari, tu t’es détournée et t’es souillée, et si un autre homme que ton mari a couché avec toi : ");
INSERT INTO francl_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","— le prêtre adjurera la femme par le serment d’imprécation, et lui dira : — Que Yahweh fasse de toi une malédiction et une exécration au milieu de ton peuple, en faisant maigrir tes flancs et enfler ton ventre, ");
INSERT INTO francl_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","et que ces eaux qui apportent la malédiction entrent dans tes entrailles pour te faire enfler le ventre et maigrir les flancs ! Et la femme dira : Amen ! Amen ! ");
INSERT INTO francl_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Le prêtre écrira ces imprécations sur un rouleau, et il les effacera ensuite dans les eaux amères. ");
INSERT INTO francl_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Puis il fera boire à la femme les eaux amères qui apportent la malédiction, et les eaux qui apportent la malédiction entreront en elle pour lui être amères. ");
INSERT INTO francl_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Le prêtre, ayant pris des mains de la femme l’oblation de jalousie, la balancera devant Yahweh, et l’approchera de l’autel ; ");
INSERT INTO francl_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","il prendra une poignée de cette oblation comme mémorial, et il la fera fumer sur l’autel ; et après cela, il fera boire les eaux à la femme. ");
INSERT INTO francl_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Quand il lui fera boire les eaux, il arrivera, si elle s’est souillée et a été infidèle à son mari, que les eaux qui apportent la malédiction entreront en elle pour lui être amères : son ventre s’enflera, ses flancs maigriront, et cette femme sera une malédiction au milieu de son peuple. ");
INSERT INTO francl_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Mais si la femme ne s’est pas souillée et qu’elle soit pure, elle sera préservée, et elle aura des enfants. ");
INSERT INTO francl_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Telle est la loi sur la jalousie, quand une femme, étant sous la puissance de son mari, se détourne et se souille, ");
INSERT INTO francl_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","ou quand l’esprit de jalousie s’empare d’un mari et qu’il devient jaloux de sa femme : il fera tenir sa femme debout devant Yahweh, et le prêtre lui appliquera cette loi dans son entier. ");
INSERT INTO francl_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Le mari sera exempt de faute ; mais la femme portera son iniquité ». ");
INSERT INTO francl_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","« Parle aux enfants d’Israël, et dis-leur : Lorsqu’un homme ou une femme se sépare par un vœu, un vœu de nazaréen, pour se séparer en l’honneur de Yahweh, ");
INSERT INTO francl_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","il s’abstiendra de vin et boisson enivrante ; il ne boira ni vinaigre fait avec du vin, ni vinaigre fait avec une boisson enivrante ; il ne boira d’aucun jus de raisin ; il ne mangera ni raisins frais, ni raisins secs. ");
INSERT INTO francl_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Pendant tout le temps de son nazaréat, il ne mangera d’aucun produit de la vigne, depuis les pépins jusqu’à la peau du raisin. ");
INSERT INTO francl_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Pendant tout le temps du vœu de son nazaréat, le rasoir ne passera pas sur sa tête ; jusqu’à l’accomplissement des jours pour la durée desquels il se sépare en l’honneur de Yahweh, il sera saint, laissant croître librement ses cheveux. ");
INSERT INTO francl_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Tout le temps pendant lequel il se sépare en l’honneur de Yahweh, il ne s’approchera d’aucun corps mort ; ");
INSERT INTO francl_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","il ne se souillera ni pour son père, ni pour sa mère, ni pour son frère ou sa sœur, à leur mort, car il porte sur sa tête la consécration à son Dieu. ");
INSERT INTO francl_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Tout le temps de son nazaréat, il est consacré à Yahweh. ");
INSERT INTO francl_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Si quelqu’un meurt subitement près de lui, et que sa tête consacrée soit ainsi souillée, il se rasera la tête le jour de sa purification ; il la rasera le septième jour. ");
INSERT INTO francl_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Et le huitième jour, il apportera au prêtre deux tourterelles ou deux jeunes pigeons, à l’entrée de la tente de réunion. ");
INSERT INTO francl_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Le prêtre offrira l’un en sacrifice pour le péché, et l’autre en holocauste, et il fera pour lui l’expiation pour son péché à l’occasion du mort. Ce jour-là, le nazaréen consacrera sa tête. ");
INSERT INTO francl_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Il consacrera de nouveau à Yahweh les jours de son nazaréat, et il offrira un agneau d’un an en sacrifice de réparation ; les jours précédents sont nuls, parce que son nazaréat a été souillé. ");
INSERT INTO francl_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Voici la loi du nazaréen. Le jour où il aura accompli le temps de son nazaréat, on le fera venir à l’entrée de la tente de réunion. ");
INSERT INTO francl_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Il présentera son offrande à Yahweh : un agneau d’un an, sans défaut, pour l’holocauste ; une brebis d’un an, sans défaut, pour le sacrifice pour le péché ; un bélier sans défaut pour le sacrifice pacifique ; ");
INSERT INTO francl_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","ainsi qu’une corbeille de pains sans levain, de gâteaux de fleur de farine pétris à l’huile, et de galettes sans levain arrosées d’huile, avec l’oblation et les libations ordinaires. ");
INSERT INTO francl_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Le prêtre les présentera devant Yahweh, et il offrira son sacrifice pour le péché et son holocauste. ");
INSERT INTO francl_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Puis il offrira le bélier en sacrifice pacifique à Yahweh, avec la corbeille de pains sans levain ; le prêtre fera son oblation et sa libation. ");
INSERT INTO francl_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Le nazaréen rasera, à l’entrée de la tente de réunion, sa tête consacrée ; et prenant les cheveux de sa tête consacrée, il les mettra sur le feu qui est sous la victime du sacrifice pacifique. ");
INSERT INTO francl_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Le prêtre prendra l’épaule du bélier quand elle sera cuite, un gâteau sans levain de la corbeille et une galette sans levain ; et, les ayant posés sur les mains du nazaréen, après que celui-ci aura rasé sa tête consacrée, ");
INSERT INTO francl_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","le prêtre les balancera devant Yahweh : c’est une chose sainte qui appartient au prêtre, outre la poitrine balancée et la cuisse prélevée. Après cela le nazaréen pourra boire du vin. ");
INSERT INTO francl_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Telle est la loi du nazaréen qui a fait un vœu, telle est son offrande à Yahweh pour son nazaréat, outre ce que ses moyens lui permettront de faire. Selon le vœu qu’il aura fait, ainsi il agira d’après la loi de son nazaréat. » ");
INSERT INTO francl_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","« Parle à Aaron et à ses fils en disant : Vous bénirez ainsi les enfants d’Israël, vous leur direz : ");
INSERT INTO francl_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","Que Yahweh te bénisse et te garde ! ");
INSERT INTO francl_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Que Yahweh fasse luire sa face sur toi, et qu’il t’accorde sa grâce ! ");
INSERT INTO francl_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Que Yahweh lève sa face vers toi, et qu’il te donne la paix ! — ");
INSERT INTO francl_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","C’est ainsi qu’ils mettront mon nom sur les enfants d’Israël, et je les bénirai. » III– DERNIERS ÉVÉNEMENTS DU SÉJOUR AU SINAÏ ");
INSERT INTO francl_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Le jour où Moïse acheva de dresser la Demeure, de l’oindre et de la sanctifier avec tous ses ustensiles, ainsi que l’autel avec tous ses ustensiles ; lorsqu’il les eut oints et sanctifiés, ");
INSERT INTO francl_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","les princes d’Israël, chefs de leurs maisons patriarcales, présentèrent leurs offrandes : c’étaient les princes des tribus, ceux qui avaient présidé au dénombrement. ");
INSERT INTO francl_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Ils amenèrent leur offrande devant Yahweh : six chars couverts et douze bœufs, soit un char pour deux princes et un bœuf pour chaque prince, et ils les présentèrent devant la Demeure. ");
INSERT INTO francl_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","« Reçois d’eux ces choses, et qu’elles soient employées pour le service de la tente de réunion ; tu les donneras aux Lévites, à chacun selon les besoins de son service. » ");
INSERT INTO francl_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Moïse, ayant pris les chars et les bœufs, les remit aux Lévites. ");
INSERT INTO francl_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Il donna deux chars et quatre bœufs aux fils de Gerson, selon les besoins de leur service ; ");
INSERT INTO francl_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","il donna quatre chars et huit bœufs aux fils de Mérari, selon les besoins de leur service, sous la surveillance d’Ithamar, fils d’Aaron, le prêtre. ");
INSERT INTO francl_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Mais il n’en donna pas aux fils de Caath, parce que, ayant le service des objets sacrés, ils devaient les porter sur leurs épaules. ");
INSERT INTO francl_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Les princes présentèrent leur offrande pour la dédicace de l’autel, le jour où on l’oignit ; les princes présentèrent leur offrande devant l’autel. ");
INSERT INTO francl_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Et Yahweh dit à Moïse : « Que chaque jour un prince vienne présenter son offrande pour la dédicace de l’autel. » ");
INSERT INTO francl_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Celui qui présenta son offrande le premier jour fut Nahasson, fils d’Aminadab, de la tribu de Juda. ");
INSERT INTO francl_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Il offrit : un plat d’argent du poids de cent trente sicles, une coupe d’argent de soixante-dix sicles, selon le sicle du sanctuaire, l’un et l’autre pleins de fleur de farine pétrie à l’huile, pour l’oblation ; ");
INSERT INTO francl_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","un godet d’or de dix sicles, plein de parfum ; ");
INSERT INTO francl_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","un jeune taureau, un bélier et un agneau d’un an pour l’holocauste ; ");
INSERT INTO francl_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","un bouc pour le sacrifice pour le péché, ");
INSERT INTO francl_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","et, pour le sacrifice pacifique, deux bœufs, cinq béliers, cinq boucs et cinq agneaux d’un an. Telle fut l’offrande de Nahasson, fils d’Aminadab. ");
INSERT INTO francl_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Le second jour, Nathanaël, fils de Suar, prince de la tribu d’Issachar, présenta son offrande. ");
INSERT INTO francl_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Il offrit : un plat d’argent du poids de cent trente sicles, une coupe d’argent de soixante-dix sicles, selon le sicle du sanctuaire, l’un et l’autre pleins de fleur de farine pétrie à l’huile, pour l’oblation ; ");
INSERT INTO francl_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","un godet d’or de dix sicles, plein de parfum ; ");
INSERT INTO francl_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","un jeune taureau, un bélier et un agneau d’un an pour l’holocauste ; ");
INSERT INTO francl_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","un bouc pour le sacrifice pour le péché, ");
INSERT INTO francl_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","et, pour le sacrifice pacifique, deux bœufs, cinq béliers, cinq boucs et cinq agneaux d’un an. Telle fut l’offrande de Nathanaël, fils de Suar. ");
INSERT INTO francl_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Le troisième jour vint le prince des fils de Zabulon, Eliab, fils de Hélon ; ");
INSERT INTO francl_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","il offrit : un plat d’argent du poids de cent trente sicles, et une coupe d’argent de soixante-dix sicles, selon le sicle du sanctuaire, l’un et l’autre pleins de fleur de farine pétrie à l’huile, pour l’oblation ; ");
INSERT INTO francl_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","un godet d’or de dix sicles, plein de parfum ; ");
INSERT INTO francl_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","un jeune taureau, un bélier et un agneau d’un an pour l’holocauste ; ");
INSERT INTO francl_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","un bouc pour le sacrifice pour le péché, ");
INSERT INTO francl_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","et, pour le sacrifice pacifique, deux bœufs, cinq béliers, cinq boucs et cinq agneaux d’un an. Telle fut l’offrande d’Eliab, fils de Hélon. ");
INSERT INTO francl_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Le quatrième jour vint le prince des fils de Ruben, Elisur, fils de Sédéur ; ");
INSERT INTO francl_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","il offrit : un plat d’argent du poids de cent trente sicles, et une coupe d’argent de soixante-dix sicles, selon le sicle du sanctuaire, l’un et l’autre pleins de fleur de farine pétrie à l’huile, pour l’oblation ; ");
INSERT INTO francl_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","un godet d’or de dix sicles, plein de parfum ; ");
INSERT INTO francl_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","un jeune taureau, un bélier et un agneau d’un an pour l’holocauste ; ");
INSERT INTO francl_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","un bouc pour le sacrifice pour le péché, ");
INSERT INTO francl_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","et, pour le sacrifice pacifique, deux bœufs, cinq béliers, cinq boucs et cinq agneaux d’un an. Telle fut l’offrande d’Elisur, fils de Sédéur. ");
INSERT INTO francl_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Le cinquième jour vint le prince des fils de Siméon, Salamiel, fils de Surisaddaï ; ");
INSERT INTO francl_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","il offrit : un plat d’argent du poids de cent trente sicles, et une coupe d’argent de soixante-dix sicles, selon le sicle du sanctuaire, l’un et l’autre pleins de fleur de farine pétrie à l’huile, pour l’oblation ; ");
INSERT INTO francl_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","un godet d’or de dix sicles, plein de parfum ; ");
INSERT INTO francl_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","un jeune taureau, un bélier et un agneau d’un an pour l’holocauste ; ");
INSERT INTO francl_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","un bouc pour le sacrifice pour le péché, ");
INSERT INTO francl_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","et, pour le sacrifice pacifique, deux bœufs, cinq béliers, cinq boucs et cinq agneaux d’un an. Telle fut l’offrande de Salamiel, fils de Surisaddaï. ");
INSERT INTO francl_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Le sixième jour vint le prince des fils de Gad, Eliasaph, fils de Duel ; ");
INSERT INTO francl_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","il offrit : un plat d’argent du poids de cent trente sicles, et une coupe d’argent de soixante-dix sicles, selon le sicle du sanctuaire, l’un et l’autre pleins de fleur de farine pétrie à l’huile, pour l’oblation ; ");
INSERT INTO francl_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","un godet d’or de dix sicles, plein de parfum ; ");
INSERT INTO francl_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","un jeune taureau, un bélier et un agneau d’un an pour l’holocauste ; ");
INSERT INTO francl_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","un bouc pour le sacrifice pour le péché, ");
INSERT INTO francl_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","et, pour le sacrifice pacifique, deux bœufs, cinq béliers, cinq boucs et cinq agneaux d’un an. Telle fut l’offrande d’Eliasaph, fils de Duel. ");
INSERT INTO francl_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Le septième jour vint le prince des fils d’Ephraïm, Elisama, fils d’Ammiud ; ");
INSERT INTO francl_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","il offrit : un plat d’argent du poids de cent trente sicles, et une coupe d’argent de soixante-dix sicles, selon le sicle du sanctuaire, l’un et l’autre pleins de fleur de farine pétrie à l’huile, pour l’oblation ; ");
INSERT INTO francl_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","un godet d’or de dix sicles, plein de parfum ; ");
INSERT INTO francl_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","un jeune taureau, un bélier et un agneau d’un an pour l’holocauste ; ");
INSERT INTO francl_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","un bouc pour le sacrifice pour le péché, ");
INSERT INTO francl_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","et, pour le sacrifice pacifique, deux bœufs, cinq béliers, cinq boucs et cinq agneaux d’un an. Telle fut l’offrande d’Elisama, fils d’Ammiud. ");
INSERT INTO francl_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Le huitième jour vint le prince des fils de Manassé, Gamaliel, fils de Phadassur ; ");
INSERT INTO francl_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","il offrit : un plat d’argent du poids de cent trente sicles, et une coupe d’argent de soixante-dix sicles, selon le sicle du sanctuaire, l’un et l’autre pleins de fleur de farine pétrie à l’huile, pour l’oblation ; ");
INSERT INTO francl_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","un godet d’or de dix sicles, plein de parfum ; ");
INSERT INTO francl_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","un jeune taureau, un bélier et un agneau d’un an pour l’holocauste ; ");
INSERT INTO francl_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","un bouc pour le sacrifice pour le péché, ");
INSERT INTO francl_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","et, pour le sacrifice pacifique, deux bœufs, cinq béliers, cinq boucs et cinq agneaux d’un an. Telle fut l’offrande de Gamaliel, fils de Phadassur. ");
INSERT INTO francl_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Le neuvième jour vint le prince des fils de Benjamin, Abidan, fils de Gédéon ; ");
INSERT INTO francl_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","il offrit : un plat d’argent du poids de cent trente sicles, et une coupe d’argent de soixante-dix sicles, selon le sicle du sanctuaire, l’un et l’autre pleins de fleur de farine pétrie à l’huile, pour l’oblation ; ");
INSERT INTO francl_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","un godet d’or de dix sicles, plein de parfum ; ");
INSERT INTO francl_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","un jeune taureau, un bélier et un agneau d’un an pour l’holocauste ; ");
INSERT INTO francl_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","un bouc pour le sacrifice pour le péché, ");
INSERT INTO francl_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","et, pour le sacrifice pacifique, deux bœufs, cinq béliers, cinq boucs et cinq agneaux d’un an. Telle fut l’offrande d’Abidan, fils de Gédéon. ");
INSERT INTO francl_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Le dixième jour vint le prince des fils de Dan, Ahiéser, fils d’Ammisaddaï ; ");
INSERT INTO francl_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","il offrit : un plat d’argent du poids de cent trente sicles, et une coupe d’argent de soixante-dix sicles, selon le sicle du sanctuaire, l’un et l’autre pleins de fleur de farine pétrie à l’huile, pour l’oblation ; ");
INSERT INTO francl_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","un godet d’or de dix sicles, plein de parfum ; ");
INSERT INTO francl_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","un jeune taureau, un bélier et un agneau d’un an pour l’holocauste ; ");
INSERT INTO francl_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","un bouc pour le sacrifice pour le péché, ");
INSERT INTO francl_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","et, pour le sacrifice pacifique, deux bœufs, cinq béliers, cinq boucs et cinq agneaux d’un an. Telle fut l’offrande d’Ahiéser, fils d’Ammisaddaï. ");
INSERT INTO francl_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Le onzième jour vint le prince des fils d’Aser, Phégiel, fils d’Ochran ; ");
INSERT INTO francl_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","il offrit : un plat d’argent du poids de cent trente sicles, et une coupe d’argent de soixante-dix sicles, selon le sicle du sanctuaire, l’un et l’autre pleins de fleur de farine pétrie à l’huile, pour l’oblation ; ");
INSERT INTO francl_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","un godet d’or de dix sicles, plein de parfum ; ");
INSERT INTO francl_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","un jeune taureau, un bélier et un agneau d’un an pour l’holocauste ; ");
INSERT INTO francl_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","un bouc pour le sacrifice pour le péché, ");
INSERT INTO francl_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","et, pour le sacrifice pacifique, deux bœufs, cinq béliers, cinq boucs et cinq agneaux d’un an. Telle fut l’offrande de Phégiel, fils d’Ochran. ");
INSERT INTO francl_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Le douzième jour vint le prince des fils de Nephtali, Ahira, fils d’Enan ; ");
INSERT INTO francl_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","il offrit : un plat d’argent du poids de cent trente sicles, et une coupe d’argent de soixante-dix sicles, selon le sicle du sanctuaire, l’un et l’autre pleins de fleur de farine pétrie à l’huile, pour l’oblation ; ");
INSERT INTO francl_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","un godet d’or de dix sicles, plein de parfum ; ");
INSERT INTO francl_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","un jeune taureau, un bélier et un agneau d’un an pour l’holocauste ; ");
INSERT INTO francl_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","un bouc pour le sacrifice pour le péché, ");
INSERT INTO francl_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","et, pour le sacrifice pacifique, deux bœufs, cinq béliers, cinq boucs et cinq agneaux d’un an. Telle fut l’offrande d’Ahira, fils d’Enan. ");
INSERT INTO francl_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Tels furent les dons des princes d’Israël pour la dédicace de l’autel, le jour où on l’oignit : douze plats d’argent, douze coupes d’argents et douze godets d’or ; ");
INSERT INTO francl_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","chaque plat d’argent pesait cent trente sicles, et chaque coupe soixante-dix ; total de l’argent de ces ustensiles : deux mille quatre cent sicles, selon le sicle du sanctuaire ; — ");
INSERT INTO francl_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","les douze godets d’or pleins de parfum, chacun de dix sicles, selon le sicle du sanctuaire ; total de l’or des godets : cent vingt sicles. — ");
INSERT INTO francl_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Total des animaux pour l’holocauste : douze jeunes taureaux, douze béliers et douze agneaux d’un an, avec leurs oblations. Douze boucs pour le sacrifice pour le péché. — ");
INSERT INTO francl_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Total des animaux pour le sacrifice pacifique : vingt-quatre bœufs, soixante béliers, soixante boucs et soixante agneaux d’un an. Tels furent les dons offerts pour la dédicace de l’autel, après qu’on l’eut oint. ");
INSERT INTO francl_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Lorsque Moïse entrait dans la tente de réunion pour parler avec Yahweh, il entendait la voix qui lui parlait de dessus le propitiatoire placé sur l’arche du témoignage, entre les deux chérubins. Et il lui parlait. ");
INSERT INTO francl_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","« Parle à Aaron et tu lui diras : Lorsque tu placeras les lampes sur le chandelier, c’est sur le devant du chandelier que les sept lampes donneront leur lumière. » ");
INSERT INTO francl_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Aaron fit ainsi ; il plaça les lampes sur le devant du chandelier, comme Yahweh l’avait ordonné à Moïse. ");
INSERT INTO francl_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Le chandelier était fait d’or battu ; jusqu’à son pied, jusqu’à ses fleurs, il était d’or battu ; Moïse l’avait fait selon le modèle que Yahweh lui avait montré. ");
INSERT INTO francl_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","« Prends les Lévites du milieu des enfants d’Israël et purifie-les. ");
INSERT INTO francl_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Voici comment tu les purifieras : Fais sur eux une aspersion d’eau expiatoire ; qu’ils passent le rasoir sur tout leur corps, qu’ils lavent leurs vêtements, et qu’ils se purifient ainsi. ");
INSERT INTO francl_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Ils prendront ensuite un jeune taureau pour l’holocauste, avec son oblation de fleur de farine pétrie à l’huile ; et tu prendras un second jeune taureau pour le sacrifice pour le péché. ");
INSERT INTO francl_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Tu feras approcher les Lévites devant la tente de réunion, et tu convoqueras toute l’assemblée des enfants d’Israël. ");
INSERT INTO francl_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Tu feras approcher les Lévites devant Yahweh, et les enfants d’Israël poseront leurs mains sur les Lévites. ");
INSERT INTO francl_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Aaron offrira les Lévites en offrande balancée devant Yahweh, de la part des enfants d’Israël, afin qu’ils soient pour faire le service de Yahweh. ");
INSERT INTO francl_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Les Lévites poseront leurs mains sur la tête des taureaux, et tu offriras l’un en sacrifice pour le péché, l’autre en holocauste à Yahweh, afin de faire l’expiation pour les Lévites. ");
INSERT INTO francl_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Tu feras tenir les Lévites debout devant Aaron et devant ses fils, et tu les offriras en offrande balancée à Yahweh. ");
INSERT INTO francl_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Tu sépareras les Lévites du milieu des enfants d’Israël, et les Lévites seront à moi ; ");
INSERT INTO francl_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","après quoi les Lévites viendront faire le service dans la tente de réunion. C’est ainsi que tu les purifieras et que tu les offriras en offrande balancée. ");
INSERT INTO francl_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Car ils me sont entièrement donnés du milieu des enfants d’Israël ; je les ai pris pour moi à la place de tout premier-né, ouvrant le sein de sa mère, de tout premier-né des enfants d’Israël. ");
INSERT INTO francl_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Car tout premier-né des enfants d’Israël est à moi, tant des hommes que des animaux ; le jour où j’ai frappé tous les premiers-nés dans le pays d’Égypte, je me les suis consacrés. ");
INSERT INTO francl_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Et j’ai pris les Lévites à la place de tous les premiers-nés des enfants d’Israël ; ");
INSERT INTO francl_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","et j’ai donné entièrement les Lévites à Aaron et à ses fils, du milieu des enfants d’Israël, pour faire le service des enfants d’Israël dans la tente de réunion, pour qu’ils fassent l’expiation pour les enfants d’Israël, afin que les enfants d’Israël ne soient frappés d’aucune plaie, quand ils s’approcheront du sanctuaire. » ");
INSERT INTO francl_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Moïse, Aaron et toute l’assemblée des enfants d’Israël firent à l’égard des Lévites tout ce que Yahweh avait ordonné à Moïse touchant les Lévites ; ainsi firent à leur égard les enfants d’Israël. ");
INSERT INTO francl_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Les Lévites se purifièrent et lavèrent leurs vêtements ; Aaron les offrit en offrande balancée devant Yahweh, et il fit l’expiation pour eux, afin de les purifier. ");
INSERT INTO francl_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Après quoi, les Lévites vinrent faire leur service dans la tente de réunion, en présence d’Aaron et de ses fils. Selon ce que Yahweh avait ordonné à Moïse touchant les Lévites, ainsi fit-on à leur égard. ");
INSERT INTO francl_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","« Voici ce qui concerne les Lévites. A partir de vingt-cinq ans et au-dessus, le Lévite entrera au service de la tente de réunion pour y exercer une fonction. ");
INSERT INTO francl_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","A partir de cinquante ans, il sortira de fonction et ne servira plus ; ");
INSERT INTO francl_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","il aidera ses frères, dans la tente de réunion, à garder ce qui doit être observé ; mais il ne fera plus de service. Tu agiras ainsi à l’égard des Lévites au sujet de leurs fonctions. » ");
INSERT INTO francl_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Yahweh parla à Moïse, dans le désert de Sinaï, le premier mois de la deuxième année après leur sortie du pays d’Égypte. Il dit : ");
INSERT INTO francl_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","« Que les enfants d’Israël fassent la Pâque au temps fixé. ");
INSERT INTO francl_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Vous la ferez au temps fixé, le quatorzième jour de ce mois, entre les deux soirs : c’est le temps fixé ; vous la ferez selon toutes les lois et toutes les ordonnances qui la concernent. » ");
INSERT INTO francl_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Moïse parla donc aux enfants d’Israël, afin qu’ils fissent la Pâque. ");
INSERT INTO francl_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Et ils firent la Pâque le quatorzième jour du premier mois, entre les deux soirs, dans le désert de Sinaï. Selon tout ce que Yahweh avait ordonné à Moïse, ainsi firent les enfants d’Israël. ");
INSERT INTO francl_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Il y eut des hommes qui se trouvaient impurs à cause d’un cadavre et qui ne purent faire la Pâque ce jour-là. S’étant présentés le jour même devant Moïse et Aaron, ");
INSERT INTO francl_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","ils dirent à Moïse : « Nous sommes impurs à cause d’un cadavre ; pourquoi serions-nous privés de présenter l’offrande de Yahweh, au temps fixé, au milieu des enfants d’Israël ? » ");
INSERT INTO francl_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Moïse leur répondit : « Attendez que j’apprenne ce que Yahweh vous ordonnera. » ");
INSERT INTO francl_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","« Parle aux enfants d’Israël et dis-leur : Si quelqu’un, parmi vous ou parmi vos descendants, se trouve impur à cause d’un cadavre ou est en voyage au loin, il fera la Pâque en l’honneur de Yahweh. ");
INSERT INTO francl_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","C’est au second mois qu’ils la feront, le quatorzième jour, entre les deux soirs ; ils la mangeront avec des pains sans levain et des herbes amères. ");
INSERT INTO francl_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Ils n’en laisseront rien jusqu’au matin, et ils n’en briseront pas les os. Ils la célébreront selon toutes les prescriptions relatives à la Pâque. ");
INSERT INTO francl_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Si quelqu’un, étant pur et n’étant pas en voyage, omet de faire la Pâque, il sera retranché de son peuple ; parce qu’il n’a pas présenté l’offrande de Yahweh au temps fixé, il portera son péché. ");
INSERT INTO francl_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Si un étranger séjournant chez vous fait la Pâque de Yahweh, il observera les lois et ordonnances concernant la Pâque. Il y aura une même loi pour vous, pour l’étranger comme pour l’indigène. » ");
INSERT INTO francl_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Le jour où la Demeure fut dressée, la nuée couvrit la Demeure : qui est la tente du témoignage ; depuis le soir jusqu’au matin, il y eut sur la Demeure comme l’apparence d’un feu. ");
INSERT INTO francl_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Il en fut ainsi continuellement : la nuée couvrait la Demeure, et la nuit elle avait l’apparence d’un feu. ");
INSERT INTO francl_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Quand la nuée s’élevait de dessus la tente, les enfants d’Israël levaient le camp, et, à l’endroit où la nuée s’arrêtait, ils dressaient le camp. ");
INSERT INTO francl_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Au commandement de Yahweh, les enfants d’Israël levaient le camp, et au commandement de Yahweh ils le dressaient ; ils restaient campés tant que la nuée se reposait sur la Demeure. ");
INSERT INTO francl_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Quand la nuée restait longtemps sur la Demeure, les enfants d’Israël observaient le commandement de Yahweh et ne levaient pas le camp. ");
INSERT INTO francl_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Il en était de même quand la nuée ne s’arrêtait que peu de jours sur la Demeure : au commandement de Yahweh ils dressaient le camp, et au commandement de Yahweh ils le levaient. ");
INSERT INTO francl_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Si la nuée se reposait seulement du soir au matin, et s’élevait le matin, ils levaient le camp ; ou, si la nuée s’élevait après un jour et une nuit, ils levaient le camp. ");
INSERT INTO francl_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Si la nuée s’arrêtait sur la Demeure plusieurs jours, un mois ou une année, les enfants d’Israël restaient campés, et ne levaient pas le camp ; mais, dès qu’elle s’élevait, ils levaient le camp. ");
INSERT INTO francl_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Au commandement de Yahweh ils dressaient le camp, et au commandement de Yahweh ils levaient le camp ; ils observaient le commandement de Yahweh, conformément à l’ordre de Yahweh transmis par Moïse. ");
INSERT INTO francl_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","« Fais-toi deux trompettes d’argent ; tu les feras d’argent battu. Elles te serviront pour la convocation de l’assemblée et pour la levée des camps. ");
INSERT INTO francl_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Quand on en sonnera, toute l’assemblée se réunira auprès de toi, à l’entrée de la tente de réunion. ");
INSERT INTO francl_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Si l’on ne sonne que d’une trompette, les princes seulement, les chefs des milliers d’Israël, se réuniront auprès de toi. ");
INSERT INTO francl_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Quand vous sonnerez avec éclat, ceux qui campent à l’orient se mettront en marche ; ");
INSERT INTO francl_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","quand vous sonnerez avec éclat pour la seconde fois, ceux qui campent au midi se mettront en marche ; on sonnera avec éclat pour leur départ. ");
INSERT INTO francl_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Vous sonnerez aussi pour convoquer l’assemblée, mais non avec éclat. ");
INSERT INTO francl_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Les fils d’Aaron, les prêtres, sonneront des trompettes : ce sera une loi perpétuelle pour vous et pour vos descendants. ");
INSERT INTO francl_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Quand vous irez à la guerre dans votre pays contre l’ennemi qui vous attaquera, vous sonnerez des trompettes avec éclat, et vous serez rappelés au souvenir de Yahweh, votre Dieu, et vous serez délivrés de vos ennemis. ");
INSERT INTO francl_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Dans vos jours de joie, dans vos fêtes et à vos nouvelles lunes, vous sonnerez des trompettes, en offrant vos holocaustes et vos sacrifices pacifiques, et elles seront pour vous un mémorial devant votre Dieu. Je suis Yahweh, votre Dieu. » ");
INSERT INTO francl_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","La seconde année, au vingtième jour du deuxième mois, la nuée s’éleva de dessus la Demeure du témoignage ; ");
INSERT INTO francl_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","et les enfants d’Israël, reprenant leurs marches, partirent du désert de Sinaï, et la nuée s’arrêta dans le désert de Pharan. ");
INSERT INTO francl_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Ils se mirent en marche pour la première fois, suivant le commandement de Yahweh par l’organe de Moïse. ");
INSERT INTO francl_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","La bannière du camp des fils de Juda partit la première, selon leurs troupes, et la troupe de Juda était commandée par Nahasson, fils d’Aminadab ; ");
INSERT INTO francl_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","la troupe de la tribu des fils d’Issachar était commandée par Nathanaël, fils de Suar ; ");
INSERT INTO francl_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","et la troupe de la tribu des fils de Zabulon était commandée par Eliab, fils de Hélon. ");
INSERT INTO francl_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","La Demeure fut démontée, et les fils de Gerson et les fils de Mérari partirent, portant la Demeure. ");
INSERT INTO francl_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","La bannière du camp de Ruben partit, selon leurs troupes, et la troupe de Ruben était commandée par Elisur, fils de Sédéur ; ");
INSERT INTO francl_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","la troupe de la tribu des fils de Siméon était commandée par Salamiel, fils de Surisaddaï ; ");
INSERT INTO francl_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","et la troupe de la tribu des fils de Gad était commandée par Eliasaph, fils de Duel. ");
INSERT INTO francl_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Les Caathites partirent portant les objets sacrés, et les autres dressaient la Demeure, en attendant leur arrivée. ");
INSERT INTO francl_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","La bannière du camp des fils d’Ephraïm partit, selon leurs troupes et la troupe d’Ephraïm était commandée par Elisama, fils d’Ammiud ; ");
INSERT INTO francl_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","la troupe de la tribu des fils de Manassé était commandée par Gamaliel, fils de Phadassur, ");
INSERT INTO francl_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","et la troupe de la tribu de Benjamin était commandée par Abidan, fils de Gédéon. ");
INSERT INTO francl_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","La bannière du camp des fils de Dan partit, selon leurs troupes : elle formait l’arrière-garde de tous les camps. La troupe de Dan était commandée par Ahiéser, fils d’Ammisaddaï ; ");
INSERT INTO francl_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","la troupe de la tribu des fils d’Aser était commandée par Phégiel, fils d’Ochran, ");
INSERT INTO francl_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","et la troupe des fils de Nephthali était commandée par Ahira, fils d’Enan. ");
INSERT INTO francl_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Tel était l’ordre de marche des enfants d’Israël selon leurs troupes ; et ils partirent. ");
INSERT INTO francl_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Moïse dit à Hobab, fils de Raguel, le Madianite, beau-père de Moïse : « Nous partons pour le lieu dont Yahweh a dit : Je vous le donnerai. Viens avec nous, et nous te ferons du bien, car Yahweh a promis de faire du bien à Israël. » ");
INSERT INTO francl_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Hobab lui répondit : « Je n’irai point, mais je m’en irai dans mon pays et ma famille. » ");
INSERT INTO francl_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Et Moïse dit : « Ne nous quitte pas, je te prie ; puisque tu connais les lieux où nous aurons à camper dans le désert, tu nous serviras d’œil. ");
INSERT INTO francl_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Si tu viens avec nous, nous te ferons partager le bien que Yahweh nous fera. » ");
INSERT INTO francl_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Etant partis de la montagne de Yahweh, ils firent trois journées de marche, et pendant ces trois journées de marche, l’arche de l’alliance de Yahweh s’avança devant eux pour leur chercher un lieu de repos. ");
INSERT INTO francl_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","La nuée de Yahweh était au-dessus d’eux pendant le jour, lorsqu’ils partaient du camp. ");
INSERT INTO francl_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Quand l’arche partait, Moïse disait : « Lève-toi, Yahweh, et que tes ennemis soient dispersés ! Que ceux qui te haïssent fuient devant ta face ! » ");
INSERT INTO francl_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Et quand elle s’arrêtait, il disait : « Reviens, Yahweh, vers les myriades des milliers d’Israël ! » ");
INSERT INTO francl_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Le peuple se mit à murmurer du mal aux oreilles de Yahweh. Yahweh l’entendit, et sa colère s’enflamma, et le feu de Yahweh s’alluma contre eux et il dévorait à l’extrémité du camp. ");
INSERT INTO francl_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Le peuple cria vers Moïse, et Moïse pria Yahweh, et le feu s’éteignit. ");
INSERT INTO francl_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","On donna à ce lieu le nom de Thabéera, parce que le feu de Yahweh s’était allumé contre eux. ");
INSERT INTO francl_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Le ramas de gens qui se trouvaient au milieu d’Israël s’enflamma de convoitise, et même les enfants d’Israël recommencèrent à pleurer et dirent : « Qui nous donnera de la viande à manger ? ");
INSERT INTO francl_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Il nous souvient des poissons que nous mangions pour rien en Égypte, des concombres, des melons, des poireaux, des oignons et de l’ail. ");
INSERT INTO francl_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Maintenant notre âme est desséchée ; plus rien ! Nos yeux ne voient que de la manne. » ");
INSERT INTO francl_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","La manne était semblable à la graine de coriandre, et avait l’aspect du bdellium. ");
INSERT INTO francl_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Le peuple se répandait pour la ramasser ; il la broyait avec des meules ou la pilait dans un mortier ; il la cuisait au pot, et en faisait des gâteaux. Elle avait le goût d’un gâteau à l’huile. ");
INSERT INTO francl_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Quand la rosée descendait pendant la nuit sur le camp, la manne y descendait aussi. ");
INSERT INTO francl_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Moïse entendit le peuple qui pleurait dans chaque famille, chacun à l’entrée de sa tente. La colère de Yahweh s’enflamma grandement. Moïse fut attristé, ");
INSERT INTO francl_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","et il dit à Yahweh : « Pourquoi avez-vous fait ce mal à votre serviteur, et pourquoi n’ai-je pas trouvé grâce à vos yeux, que vous ayez mis sur moi la charge de tout ce peuple ? ");
INSERT INTO francl_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Est-ce moi qui ai conçu tout ce peuple ? est-ce moi qui l’ai enfanté, pour que vous me disiez : Porte-le sur ton sein, comme le nourricier porte un enfant qu’on allaite, jusqu’au pays que vous avez juré à ses pères de lui donner ? ");
INSERT INTO francl_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Où prendrai-je de la viande pour en donner à tout ce peuple ? Car ils pleurent autour de moi, en disant : Donne-nous de la viande à manger. ");
INSERT INTO francl_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Je ne puis pas, à moi seul, porter tout ce peuple ; il est trop pesant pour moi. ");
INSERT INTO francl_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Pour me traiter ainsi, tuez-moi plutôt, je vous prie, si j’ai trouvé grâce à vos yeux, et que je ne voie pas mon malheur ! » ");
INSERT INTO francl_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Yahweh dit à Moïse : « Assemble-moi soixante-dix hommes des anciens d’Israël, que tu connais pour être anciens du peuple et préposés sur lui ; amène-les à la tente de réunion et qu’ils se tiennent là avec toi. ");
INSERT INTO francl_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Je descendrai et je te parlerai là ; je prendrai de l’esprit qui est sur toi et je le mettrai sur eux, afin qu’ils portent avec toi la charge du peuple, et tu ne la porteras plus toi seul. ");
INSERT INTO francl_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Tu diras au peuple : Sanctifiez-vous pour demain, et vous aurez de la viande à manger, puisque vous avez pleuré aux oreilles de Yahweh, en disant : Qui nous fera manger de la viande ? car nous étions bien en Égypte ! Et Yahweh vous donnera de la viande, et vous en mangerez ; ");
INSERT INTO francl_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","ce n’est pas un jour que vous en mangerez, ni deux jours, ni cinq jours, ni dix jours, ni vingt jours, ");
INSERT INTO francl_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","mais un mois entier, jusqu’à ce qu’elle vous sorte par les narines et qu’elle vous soit en dégoût, parce que vous avez rejeté Yahweh qui est au milieu de vous, et que vous avez pleuré devant lui, en disant : Pourquoi donc sommes-nous sortis d’Égypte ? » ");
INSERT INTO francl_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Moïse dit : « Le peuple au milieu duquel je suis est de six cent mille hommes de pied, et vous dites : Je leur donnerai de la viande, et ils en mangeront un mois entier ! ");
INSERT INTO francl_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Egorgera-t-on pour eux les brebis et les bœufs, pour qu’ils en aient assez ? Ou leur ramassera-t-on tous les poissons de la mer, pour qu’ils en aient assez ? » ");
INSERT INTO francl_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Yahweh répondit à Moïse : « La main de Yahweh est-elle trop courte ? Tu verras maintenant si ce que j’ai dit t’arrivera ou non. » ");
INSERT INTO francl_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Moïse sortit et rapporta au peuple les paroles de Yahweh, et il assembla soixante-dix hommes des anciens du peuple et les plaça autour de la tente. ");
INSERT INTO francl_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Yahweh descendit dans la nuée et parla à Moïse ; il prit de l’esprit qui était sur lui et le mit sur les soixante-dix anciens ; et, dès que l’esprit reposa sur eux, ils prophétisèrent ; mais ils ne continuèrent pas. ");
INSERT INTO francl_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Deux hommes, l’un nommé Eldad, et l’autre Médad, étaient restés dans le camp, et l’esprit reposa aussi sur eux ; ils étaient parmi les inscrits, mais ils ne s’étaient pas rendus à la tente ; et ils prophétisèrent dans le camp. ");
INSERT INTO francl_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Un jeune garçon courut l’annoncer à Moïse, en disant : « Eldad et Médad prophétisent dans le camp. » ");
INSERT INTO francl_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Aussitôt Josué, fils de Nun, serviteur de Moïse depuis sa jeunesse, prenant la parole dit : « Moïse, mon seigneur, empêche-les. » ");
INSERT INTO francl_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Moïse lui répondit : « Es-tu donc jaloux pour moi ? Plût à Dieu que tout le peuple de Yahweh fût prophète, et que Yahweh mit son esprit sur eux ! » ");
INSERT INTO francl_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Et Moïse se retira dans le camp, lui et les anciens d’Israël. ");
INSERT INTO francl_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Un vent souffla de par l’ordre de Yahweh, qui, de la mer, amena des cailles et les abattit sur le camp, sur l’étendue d’environ une journée de chemin d’un côté, d’environ une journée de chemin de l’autre côté, autour du camp ; et il y en avait près de deux coudées de haut sur la surface de la terre. ");
INSERT INTO francl_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Pendant tout ce jour, toute la nuit et toute la journée du lendemain, le peuple se leva et ramassa les cailles ; celui qui en avait ramassé le moins en avait dix gomors ; et ils les étendirent pour eux, tout autour du camp. ");
INSERT INTO francl_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Mais la chair était encore entre leurs dents, avant d’être consommée, que la colère de Yahweh s’enflamma contre le peuple, et Yahweh frappa le peuple d’une très grande plaie. ");
INSERT INTO francl_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","On donna à ce lieu le nom de Qibroth-Hattaava, parce qu’on y enterra le peuple qui s’était enflammé de convoitise. ");
INSERT INTO francl_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","De Qibroth-Hattaava le peuple partit pour Haséroth, et il s’arrêta à Haséroth. ");
INSERT INTO francl_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Marie, avec Aaron, parla contre Moïse au sujet de la femme couschite qu’il avait prise ; car il avait pris une femme couschite. ");
INSERT INTO francl_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Ils dirent : « Est-ce seulement par Moïse que Yahweh a parlé ? N’a-t-il pas parlé aussi par nous ? » Et Yahweh l’entendit. ");
INSERT INTO francl_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Mais Moïse était un homme fort doux, plus qu’aucun homme qui fût sur la face de la terre. ");
INSERT INTO francl_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Soudain Yahweh dit à Moïse, à Aaron et à Marie : « Sortez, vous trois, vers la tente de réunion. » Et ils sortirent tous les trois ; ");
INSERT INTO francl_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","et Yahweh descendit dans la colonne de nuée et se tint à l’entrée de la tente. Il appela Aaron et Marie, qui s’avancèrent tous deux ; ");
INSERT INTO francl_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","et il dit : « Ecoutez bien mes paroles : si vous avez quelque prophète de Yahweh, c’est en vision que je me révèle à lui, c’est en songe que je lui parle. ");
INSERT INTO francl_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Tel n’est pas mon serviteur Moïse ; il est reconnu fidèle dans toute ma maison. ");
INSERT INTO francl_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Je lui parle bouche à bouche, en me faisant voir, et non par énigmes, et il contemple la figure de Yahweh. Pourquoi donc n’avez-vous pas craint de parler contre mon serviteur, contre Moïse ? » ");
INSERT INTO francl_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Et la colère de Yahweh s’enflamma contre eux ; et il s’en alla ; ");
INSERT INTO francl_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","la nuée se retira de dessus la tente. Et voici, Marie devint lépreuse, blanche comme la neige. Aaron se tourna vers Marie, et voici, elle était lépreuse. ");
INSERT INTO francl_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Et Aaron dit à Moïse : « De grâce, mon seigneur, ne mets pas sur nous ce péché que nous avons follement commis, et dont nous sommes coupables. ");
INSERT INTO francl_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Ah ! Qu’elle ne soit pas comme l’enfant mort-né qui, en sortant du sein de sa mère, a la chair à demi-consumée ! » ");
INSERT INTO francl_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Moïse cria à Yahweh, en disant : « O Dieu, je vous prie, guérissez-là ! » ");
INSERT INTO francl_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Yahweh dit à Moïse : « Si son père lui avait craché au visage, ne serait-elle pas pendant sept jours couverte de honte ? Qu’elle soit séquestrée sept jours hors du camp ; après quoi, elle y sera reçue. » ");
INSERT INTO francl_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Marie fut donc séquestrée sept jours hors du camp, et le peuple ne partit point, jusqu’à ce que Marie eût été reçue. ");
INSERT INTO francl_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Après cela, le peuple partit de Haséroth, et ils campèrent dans le désert de Pharan. ");
INSERT INTO francl_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","« Envoie des hommes pour explorer le pays de Canaan, que je donne aux enfants d’Israël. Vous enverrez un homme par chacune des tribus patriarcales ; que tous soient des princes parmi eux. » ");
INSERT INTO francl_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Moïse les envoya du désert de Pharan, selon l’ordre de Yahweh ; tous ces hommes étaient des chefs des enfants d’Israël. ");
INSERT INTO francl_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Voici leurs noms : pour la tribu de Ruben, Sammua, fils de Zéchur ; ");
INSERT INTO francl_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","pour la tribu de Siméon, Saphat, fils de Huri ; ");
INSERT INTO francl_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","pour la tribu de Juda, Caleb, fils de Jéphoné ; ");
INSERT INTO francl_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","pour la tribu d’Issachar, Igal, fils de Joseph ; ");
INSERT INTO francl_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","pour la tribu d’Ephraïm, Osée, fils de Nun ; ");
INSERT INTO francl_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","pour la tribu de Benjamin, Phalti, fils de Raphu ; ");
INSERT INTO francl_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","pour la tribu de Zabulon, Geddiel, fils de Sodi ; ");
INSERT INTO francl_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","pour la tribu de Joseph, la tribu de Manassé, Gaddi, fils de Susi ; ");
INSERT INTO francl_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","pour la tribu de Dan, Ammiel, fils de Gemalli ; ");
INSERT INTO francl_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","pour la tribu d’Aser, Sthur, fils de Michaël ; ");
INSERT INTO francl_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","pour la tribu de Nephthali, Nahabi, fils de Vapsi ; ");
INSERT INTO francl_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","pour la tribu de Gad, Guel, fils de Machi. — ");
INSERT INTO francl_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Tels sont les noms des hommes que Moïse envoya pour explorer le pays. Moïse donna à Osée, fils de Nun, le nom de Josué. ");
INSERT INTO francl_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Moïse les envoya pour explorer le pays de Canaan ; il leur dit : « Montez là par le Négeb ; et vous monterez sur la montagne. ");
INSERT INTO francl_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Vous examinerez le pays, ce qu’il est, et le peuple qui l’habite, s’il est fort ou faible, peu nombreux ou considérable ; ");
INSERT INTO francl_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","ce qu’est le pays où il habite, s’il est bon ou mauvais ; ce que sont les villes où il habite, si elles sont ouvertes ou fortifiées ; ");
INSERT INTO francl_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","ce qu’est le sol, s’il est gras ou maigre, s’il y a des arbres ou non. Ayez bon courage, et prenez des fruits du pays. » C’était le temps des premiers raisins. ");
INSERT INTO francl_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Ils montèrent et explorèrent le pays, depuis le désert de Sin jusqu’à Rohob, sur le chemin d’Emath. ");
INSERT INTO francl_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Ils montèrent dans le Négeb et allèrent jusqu’à Hébron, où étaient Achiman, Sisaï et Tholmaï, enfants d’Enac. Hébron avait été bâtie sept ans avant Tanis d’Égypte. ");
INSERT INTO francl_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Arrivés à la vallée d’Escol, ils coupèrent une branche de vigne avec sa grappe de raisin, et ils la portèrent à deux au moyen d’une perche ; ils prirent aussi des grenades et des figues. ");
INSERT INTO francl_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","On donna à ce lieu le nom de vallée d’Escol, à cause de la grappe que les enfants d’Israël y coupèrent. ");
INSERT INTO francl_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Au bout de quarante jours, ils revinrent d’explorer le pays. ");
INSERT INTO francl_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Ils allèrent et se rendirent auprès de Moïse et d’Aaron, et de toute l’assemblée des enfants d’Israël, à Cadès, dans le désert de Pharan. Ils leur firent un rapport, ainsi qu’à toute l’assemblée, et leur montrèrent les fruits du pays. ");
INSERT INTO francl_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Voici le récit qu’ils firent à Moïse : « Nous sommes allés dans le pays où tu nous as envoyés. C’est vraiment un pays où coulent le lait et le miel, et en voici les fruits. ");
INSERT INTO francl_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Mais le peuple qui habite le pays est puissant, et les villes sont fortifiées et très grandes ; nous y avons même vu des enfants d’Enac. ");
INSERT INTO francl_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Amalec habite la contrée du Négeb ; le Hittite, le Jébuséen et l’Amorrhéen habitent dans la montagne, et le Chananéen habite au bord de la mer et le long du Jourdain. » ");
INSERT INTO francl_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Caleb fit taire le peuple au sujet de Moïse : « Montons, dit-il, emparons-nous du pays, car nous pouvons nous en rendre maîtres. » ");
INSERT INTO francl_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Mais les hommes qui y étaient montés avec lui, dirent : « Nous ne sommes pas capables de monter contre ce peuple : il est plus fort que nous. » ");
INSERT INTO francl_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Et ils décrièrent devant les enfants d’Israël le pays qu’ils avaient exploré, en disant : « Le pays que nous avons parcouru pour l’explorer, est un pays qui dévore ses habitants ; tout le peuple que nous y avons vu est formé de gens de haute taille ; ");
INSERT INTO francl_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","et nous y avons vu les géants, fils d’Enac, de la race des géants : nous étions à nos yeux et aux leurs comme des sauterelles. » ");
INSERT INTO francl_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Toute l’assemblée éleva la voix et poussa des cris, et le peuple pleura pendant cette nuit-là. ");
INSERT INTO francl_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Tous les enfants d’Israël murmurèrent contre Moïse et Aaron, et toute l’assemblée leur dit : « Que ne sommes-nous morts dans le pays d’Égypte, ou que ne sommes-nous morts dans ce désert ? ");
INSERT INTO francl_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Pourquoi Yahweh nous fait-il aller dans ce pays, pour que nous tombions par l’épée ? Nos femmes et nos enfants deviendront une proie. Ne vaut-il pas mieux pour nous retourner en Égypte ? » ");
INSERT INTO francl_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Et ils se dirent les uns aux autres : « Nommons un chef, et retournons en Égypte. » ");
INSERT INTO francl_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Moïse et Aaron tombèrent sur leur visage en présence de toute l’assemblée réunie des enfants d’Israël. ");
INSERT INTO francl_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Josué, fils de Nun, et Caleb, fils de Jéphoné, deux de ceux qui avaient exploré le pays, déchirèrent leurs vêtements ");
INSERT INTO francl_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","et ils parlèrent ainsi à toute l’assemblée des enfants d’Israël : « Le pays que nous avons parcouru pour l’explorer est un excellent pays. ");
INSERT INTO francl_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Si Yahweh nous est favorable, il nous fera entrer dans ce pays et nous le donnera ; c’est un pays où coulent le lait et le miel. ");
INSERT INTO francl_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Seulement ne vous mettez pas en rébellion contre Yahweh, et ne craignez pas les hommes de ce pays, car ils seront pour nous une pâture ; leur abri s’est retiré d’eux, et Yahweh est avec nous, ne les craignez point. » ");
INSERT INTO francl_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Toute l’assemblée parlait de les lapider, lorsque la gloire de Yahweh apparut sur la tente de réunion, devant tous les enfants d’Israël. ");
INSERT INTO francl_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Et Yahweh dit à Moïse : « Jusques à quand ce peuple me méprisera-t-il ? Jusques à quand ne croira-t-il pas en moi, malgré tous les prodiges que j’ai faits au milieu de lui ? ");
INSERT INTO francl_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Je le frapperai par la peste et je le détruirai, et je ferai de toi une nation plus grande et plus puissante que lui. » ");
INSERT INTO francl_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Moïse dit à Yahweh : « Les Egyptiens ont appris que, par votre puissance, vous avez fait monter ce peuple du milieu d’eux, et ils l’ont dit aux habitants de ce pays. ");
INSERT INTO francl_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Tous ont appris que vous, Yahweh, vous êtes au milieu de ce peuple ; que vous vous montrez face à face, vous, Yahweh ; que votre nuée se tient sur eux, et que vous marchez devant eux le jour dans une colonne de nuée, et la nuit dans une colonne de feu. ");
INSERT INTO francl_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Si vous faites mourir ce peuple comme un seul homme, les nations qui ont entendu parler de vous diront : ");
INSERT INTO francl_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","Yahweh n’avait pas le pouvoir de faire entrer ce peuple dans le pays qu’il avait juré de leur donner ; c’est pourquoi il les a fait périr dans le désert. ");
INSERT INTO francl_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Maintenant que la puissance du Seigneur se montre grande, comme vous l’avez déclaré, en disant : ");
INSERT INTO francl_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","Yahweh est lent à la colère et riche en bonté, il pardonne l’iniquité et le péché ; mais il ne tient pas le coupable pour innocent, et il punit l’iniquité des pères sur les enfants, sur ceux de la troisième et de la quatrième génération. ");
INSERT INTO francl_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Pardonnez l’iniquité de ce peuple selon la grandeur de votre miséricorde, comme vous avez pardonné à ce peuple depuis l’Égypte jusqu’ici. » ");
INSERT INTO francl_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Et Yahweh dit : « Je pardonne, selon ta demande ; ");
INSERT INTO francl_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","mais, — je suis vivant ! et la gloire de Yahweh remplira toute la terre ! — ");
INSERT INTO francl_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","tous les hommes qui ont vu ma gloire et les prodiges que j’ai faits en Égypte et dans le désert, qui m’ont tenté déjà dix fois et qui n’ont pas écouté ma voix, ");
INSERT INTO francl_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","tous ceux-là ne verront pas le pays que j’ai promis avec serment à leurs pères. Aucun de ceux qui m’ont méprisé ne le verra. ");
INSERT INTO francl_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Mais mon serviteur Caleb, qui a été animé d’un autre esprit et s’est fidèlement attaché à moi, je le ferai entrer dans le pays où il est allé, et ses descendants le posséderont. ");
INSERT INTO francl_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","L’Amalécite et le Chananéen habitent dans la vallée : demain retournez-vous, et partez pour le désert, sur le chemin de la mer Rouge. » ");
INSERT INTO francl_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Yahweh parla à Moïse et à Aaron, en disant : ");
INSERT INTO francl_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","« Jusques à quand supporterai-je cette méchante assemblée qui murmure contre moi ? J’ai entendu les murmures que les enfants d’Israël profèrent contre moi. ");
INSERT INTO francl_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Dis-leur : Je suis vivant ! dit Yahweh : je vous ferai selon que vous avez parlé à mes oreilles. ");
INSERT INTO francl_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Vos cadavres tomberont dans ce désert. Vous tous, dont on a fait le recensement, en vous comptant depuis l’âge de vingt ans et au-dessus, et qui avez murmuré contre moi, ");
INSERT INTO francl_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","vous n’entrerez pas dans le pays où j’ai juré de vous établir, à l’exception de Caleb, fils de Jéphoné, et de Josué, fils de Nun. ");
INSERT INTO francl_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Et vos petits enfants, dont vous avez dit : Ils deviendront une proie ! je les y ferai entrer, et ils connaîtront le pays que vous avez dédaigné. ");
INSERT INTO francl_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Vos cadavres, à vous, tomberont dans le désert ; ");
INSERT INTO francl_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","et vos fils mèneront leurs troupeaux dans le désert pendant quarante ans, et ils porteront la peine de vos infidélités, jusqu’à ce que vos cadavres soient consumés dans le désert. ");
INSERT INTO francl_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Selon les quarante jours que vous avez mis à explorer le pays, — autant de jours, autant d’années — vous porterez vos iniquités quarante années, et vous saurez ce que c’est que mon éloignement. ");
INSERT INTO francl_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Moi, Yahweh, j’ai parlé ! Voilà ce que je ferai à cette méchante assemblée qui s’est ameutée contre moi : ils seront consumés dans ce désert, ils y mourront. » ");
INSERT INTO francl_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Les hommes que Moïse avait envoyés pour explorer le pays et qui, à leur retour, avaient fait murmurer contre lui toute l’assemblée, en décrivant le pays, ");
INSERT INTO francl_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","ces hommes, qui avaient décrié le pays, moururent frappés d’une plaie devant Yahweh. ");
INSERT INTO francl_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Josué, fils de Nun, et Caleb, fils de Jéphoné, restèrent seuls vivants parmi ces hommes qui étaient allés explorer le pays. ");
INSERT INTO francl_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Moïse rapporta ces paroles à tous les enfants d’Israël, et le peuple fut en grande désolation. ");
INSERT INTO francl_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","S’étant levés de bon matin, ils montèrent vers le sommet de la montagne, en disant : « Nous voici ! Nous monterons au lieu dont Yahweh a parlé, car nous avons péché. » ");
INSERT INTO francl_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Moïse dit : « Pourquoi transgressez-vous l’ordre de Yahweh ? Cela ne vous réussira point. ");
INSERT INTO francl_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Ne montez pas, car Yahweh n’est pas au milieu de vous ! Ne vous faites pas battre par vos ennemis. ");
INSERT INTO francl_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Car l’Amalécite et le Chananéen sont là devant vous, et vous tomberiez par l’épée ; parce qui vous vous êtes détournés de Yahweh, Yahweh ne sera pas avec vous. » ");
INSERT INTO francl_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Ils s’obstinèrent à monter vers le sommet de la montagne ; mais l’arche d’alliance de Yahweh et Moïse ne bougèrent pas du milieu du camp. ");
INSERT INTO francl_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Alors l’Amalécite et le Chananéen qui habitaient cette montagne descendirent, les battirent et les taillèrent en pièces jusqu’à Horma. ");
INSERT INTO francl_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","« Parle aux enfants d’Israël et dis-leur : Quand vous serez entrés dans le pays où vous demeurerez et que je vous donne, ");
INSERT INTO francl_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","et quand vous offrirez à Yahweh un sacrifice fait par le feu, soit un holocauste, soit un sacrifice, pour l’accomplissement d’un vœu ou comme offrande volontaire, ou bien dans vos fêtes, afin de produire avec vos bœufs ou vos brebis une agréable odeur à Yahweh, ");
INSERT INTO francl_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","celui qui fera son offrande à Yahweh offrira en oblation un dixième de fleur de farine pétrie avec un quart de hin d’huile ; ");
INSERT INTO francl_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","tu feras une libation d’un quart de hin de vin, avec l’holocauste ou le sacrifice pacifique, pour chaque agneau. ");
INSERT INTO francl_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Pour un bélier, tu feras une oblation de deux dixièmes de fleur de farine pétrie avec un tiers de hin d’huile, ");
INSERT INTO francl_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","et pour la libation tu offriras un tiers de hin de vin, en offrande d’agréable odeur à Yahweh. ");
INSERT INTO francl_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Si tu offres un taureau, soit comme holocauste, soit comme sacrifice, pour l’acquittement d’un vœu ou comme sacrifice pacifique à Yahweh, ");
INSERT INTO francl_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","on offrira, avec le taureau, comme oblation, trois dixièmes de fleur de farine pétrie avec un demi-hin d’huile, ");
INSERT INTO francl_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","et tu offriras un demi-hin de vin pour la libation : c’est un sacrifice fait par le feu, d’une agréable odeur à Yahweh. ");
INSERT INTO francl_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","On fera ainsi pour chaque bœuf, pour chaque bélier, pour chaque agneau ou chevreau. ");
INSERT INTO francl_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Suivant le nombre de victimes que vous offrirez, vous ferez ainsi pour chacune, selon leur nombre. ");
INSERT INTO francl_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Tout indigène fera ces choses de cette manière, lorsqu’il offrira un sacrifice par le feu, d’une agréable odeur à Yahweh. ");
INSERT INTO francl_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Si un étranger séjournant chez vous, un homme quelconque vivant parmi vous, de génération en génération, offre un sacrifice par le feu, d’une agréable odeur à Yahweh, il fera comme vous ferez. ");
INSERT INTO francl_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Il y aura une seule loi pour l’assemblée, pour vous comme pour l’étranger de séjour au milieu de vous ; ce sera une loi perpétuelle pour vos descendants : il en sera de l’étranger comme de vous devant Yahweh. ");
INSERT INTO francl_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Il y aura une seule loi et une seule règle pour vous et pour l’étranger qui séjourne parmi vous. » ");
INSERT INTO francl_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","« Parle aux enfants d’Israël et dis-leur : Quand vous serez arrivés dans le pays où je vous fais entrer, ");
INSERT INTO francl_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","et que vous mangerez du pain de ce pays, vous prélèverez une offrande pour Yahweh. ");
INSERT INTO francl_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Comme prémices de votre pâte, vous prélèverez en offrande un gâteau ; vous le prélèverez comme l’offrande qu’on prélève de l’aire. ");
INSERT INTO francl_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Comme prémices de votre pâte, vous prélèverez une offrande pour Yahweh, vous et vos descendants. » ");
INSERT INTO francl_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","« Si vous péchez par erreur en n’observant pas tous ces commandements que Yahweh a fait connaître à Moïse, ");
INSERT INTO francl_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","tout ce que Yahweh vous a ordonné par Moïse, depuis le jour où Yahweh a donné des commandements, et à la suite pour vos générations, ");
INSERT INTO francl_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","si, dis-je, on a péché par erreur, sans que l’assemblée s’en soit aperçue, — toute l’assemblée offrira un jeune taureau en holocauste d’une agréable odeur à Yahweh, avec son oblation et sa libation, selon le rite prescrit, ainsi qu’un bouc en sacrifice pour le péché. ");
INSERT INTO francl_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Le prêtre fera l’expiation pour toute l’assemblée des enfants d’Israël, et il leur sera pardonné, car c’est un péché commis par erreur, et ils ont présenté leur offrande, un sacrifice fait par le feu à Yahweh, et leur sacrifice pour le péché devant Yahweh, à cause du péché qu’ils ont commis par erreur. ");
INSERT INTO francl_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Il sera pardonné à toute l’assemblée des enfants d’Israël et à l’étranger qui séjourne au milieu d’eux, car c’est par erreur que tout le peuple a péché. ");
INSERT INTO francl_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Si c’est une seule personne qui a péché par erreur, elle offrira une chèvre d’un an en sacrifice pour le péché. ");
INSERT INTO francl_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Le prêtre fera l’expiation devant Yahweh pour la personne qui a erré en commettant un péché par erreur ; l’expiation pour elle étant faite, il lui sera pardonné. ");
INSERT INTO francl_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Pour l’indigène d’entre les enfants d’Israël et pour l’étranger qui séjourne au milieu d’eux, vous aurez une même loi, si quelqu’un agit mal par erreur. ");
INSERT INTO francl_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Mais si quelqu’un, indigène ou étranger, agit la main levée, il outrage Yahweh ; cet homme sera retranché du milieu de son peuple. ");
INSERT INTO francl_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Car il a méprisé la parole de Yahweh et violé son commandement : cet homme sera retranché, son iniquité sera sur lui. » ");
INSERT INTO francl_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Pendant que les enfants d’Israël étaient dans le désert, ils trouvèrent un homme qui ramassait du bois le jour du sabbat. ");
INSERT INTO francl_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Ceux qui l’avaient trouvé ramassant du bois l’amenèrent à Moïse, à Aaron et à toute l’assemblée. ");
INSERT INTO francl_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","On le mit sous garde, car ce qu’on devait lui faire n’avait pas été déterminé. ");
INSERT INTO francl_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Yahweh dit à Moïse : « Cet homme sera mis à mort ! Toute l’assemblée le lapidera hors du camp. » ");
INSERT INTO francl_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Toute l’assemblée l’ayant fait sortir du camp, le lapida et il mourut, comme Yahweh l’avait ordonné à Moïse. ");
INSERT INTO francl_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Yahweh dit à Moïse : ");
INSERT INTO francl_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","« Parle aux enfants d’Israël et dis-leur de se faire, de génération en génération, des glands aux coins de leurs manteaux ; et qu’ils mettent au gland de chaque coin un cordon de pourpre violette. ");
INSERT INTO francl_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Ce sera pour vous un gland et, en le voyant, vous vous souviendrez de tous les commandements de Yahweh pour les mettre en pratique, et vous n’irez pas après les désirs de votre cœur et de vos yeux, qui vous entraînent dans l’infidélité. ");
INSERT INTO francl_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Vous vous souviendrez ainsi de tous mes commandements et les mettrez en pratique, et vous serez saints à votre Dieu. ");
INSERT INTO francl_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Je suis Yahweh, votre Dieu, qui vous ai fait sortir du pays d’Égypte, pour être votre Dieu. Je suis Yahweh, votre Dieu. » ");
INSERT INTO francl_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Coré, fils d’Isaar, fils de Caath, fils de Lévi, se fit des partisans, avec Dathan et Abiron, fils d’Eliab, et Hon, fils de Phéleth, ceux-ci, fils de Ruben, ");
INSERT INTO francl_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","et ils se soulevèrent en présence de Moïse, ayant avec eux deux cent cinquante hommes des enfants d’Israël, princes de l’assemblée, appelés aux conseils et gens de renom. ");
INSERT INTO francl_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Ils s’attroupèrent contre Moïse et Aaron, et leur dirent : « C’en est assez ! car toute l’assemblée, tous sont saints, et Yahweh est au milieu d’eux. Pourquoi vous élevez-vous au-dessus de l’assemblée de Yahweh ? » ");
INSERT INTO francl_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Quand Moïse entendit cela, il tomba sur son visage. ");
INSERT INTO francl_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Il parla à Coré et à toute sa troupe en disant : « Demain, Yahweh fera connaître celui qui est à lui et qui est saint, et il le fera approcher de lui ; celui qu’il aura choisi, il le fera approcher de lui. ");
INSERT INTO francl_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Faites ceci : Prenez des encensoirs, Coré et toute sa troupe. ");
INSERT INTO francl_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","Demain, mettez-y du feu, et jetez dessus du parfum devant Yahweh ; celui que Yahweh choisira, c’est lui qui est saint. C’en est assez, enfants de Lévi. » ");
INSERT INTO francl_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Moïse dit à Coré : « Ecoutez donc, enfants de Lévi. ");
INSERT INTO francl_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Est-ce trop peu pour vous que le Dieu d’Israël vous ait séparés de l’assemblée d’Israël en vous faisant approcher de lui, pour faire le service de la Demeure de Yahweh, et pour vous tenir devant l’assemblée pour faire son service ? ");
INSERT INTO francl_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Il t’a fait approcher de lui, toi et tous tes frères, les enfants de Lévi, avec toi, et vous ambitionnez encore le sacerdoce ! ");
INSERT INTO francl_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","C’est pour cela que toi et toute ta troupe, vous vous assemblez contre Yahweh ! Et Aaron, qui est-il, pour que vous murmuriez contre lui ? » ");
INSERT INTO francl_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Moïse fit appeler Dathan et Abiron, fils d’Eliab ; et ils dirent : « Nous ne monterons pas. ");
INSERT INTO francl_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","N’est-ce pas assez de nous avoir fait sortir d’un pays où coulent le lait et le miel pour nous faire mourir au désert, que tu t’ériges en maître sur nous ? ");
INSERT INTO francl_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Ah ! Ce n’est pas dans un pays où coulent le lait et le miel que tu nous as conduits ; ce ne sont pas des champs et des vignes que tu nous as donnés en possession ! Penses-tu crever les yeux de ces gens ? Nous ne monterons pas ! » ");
INSERT INTO francl_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Moïse, très irrité, dit à Yahweh : « N’ayez pas égard à leur oblation. Je ne leur ai pas même pris un âne, et je n’ai fait de mal à aucun d’eux. » ");
INSERT INTO francl_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Moïse dit à Coré : « Toi et toute ta troupe, trouvez-vous demain devant Yahweh, toi et eux, avec Aaron. ");
INSERT INTO francl_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Prenez chacun votre encensoir, mettez-y du parfum et présentez chacun votre encensoir devant Yahweh : deux cent cinquante encensoirs ; toi aussi et Aaron, vous prendrez chacun votre encensoir. » ");
INSERT INTO francl_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Ils prirent chacun leur encensoir, y mirent du feu et y jetèrent du parfum, et ils se tinrent à l’entrée de la tente de réunion, avec Moïse et Aaron. ");
INSERT INTO francl_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Coré avait convoqué toute l’assemblée contre Moïse et Aaron, à l’entrée de la tente de réunion. Alors la gloire de Yahweh apparut à toute l’assemblée. ");
INSERT INTO francl_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Et Yahweh parla à Moïse et à Aaron, en disant : ");
INSERT INTO francl_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","« Séparez-vous du milieu de cette assemblée, et je les consumerai en un instant. » ");
INSERT INTO francl_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Et ils tombèrent sur leur visage, et dirent : « O Dieu, Dieu des esprits de toute chair, un seul homme a péché, et tu t’irriterais contre toute l’assemblée ! » ");
INSERT INTO francl_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","« Parle à l’assemblée et dis : Ecartez-vous tout à l’entour de la demeure de Coré, de Dathan et d’Abiron. » ");
INSERT INTO francl_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Moïse se leva et alla vers Dathan et Abiron, et des anciens d’Israël allèrent après lui. ");
INSERT INTO francl_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Il parla à l’assemblée, en disant : « Eloignez-vous des tentes de ces méchants hommes, et ne touchez à rien de ce qui leur appartient, de peur que vous ne périssiez, enveloppés dans tous leurs péchés. » ");
INSERT INTO francl_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Ils s’écartèrent tout à l’entour de la demeure de Coré, de Dathan et d’Abiron. Alors Dathan et Abiron étant sortis se tinrent à l’entrée de leurs tentes, avec leurs femmes, leurs fils et leurs petits enfants. ");
INSERT INTO francl_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Moïse dit : « Vous connaîtrez à ceci que Yahweh m’a envoyé pour faire toutes ces œuvres, et que je n’agis pas de moi-même : ");
INSERT INTO francl_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Si ces gens meurent comme meurent tous les hommes, et si leur sort est celui de tous les hommes, ce n’est pas Yahweh qui m’a envoyé ; ");
INSERT INTO francl_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","mais si Yahweh fait une chose inouïe, si la terre ouvre sa bouche et les engloutit, eux et tout ce qui leur appartient, et qu’ils descendent vivants dans le séjour des morts, vous saurez que ces gens ont méprisé Yahweh. » ");
INSERT INTO francl_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Comme il achevait de prononcer toutes ces paroles, le sol qui était sous eux se fendit. ");
INSERT INTO francl_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","La terre ouvrit sa bouche et les engloutit, eux et leurs familles, avec tous les gens de Coré et tous leurs biens. ");
INSERT INTO francl_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Ils descendirent vivants dans le séjour des morts, eux et tout ce qui leur appartenait ; et la terre les recouvrit, et ils disparurent du milieu de l’assemblée. ");
INSERT INTO francl_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Tout Israël, qui était autour d’eux, s’enfuit à leur cri ; car ils disaient : « Fuyons, de peur que la terre ne nous engloutisse ! » ");
INSERT INTO francl_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Un feu sortit d’auprès de Yahweh et consuma les deux cent cinquante hommes qui offraient le parfum. ");
INSERT INTO francl_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","« Dis à Eléazar, fils d’Aaron, le prêtre, de retirer les encensoirs du milieu de l’embrasement et d’en répandre au loin le feu, car ils sont sanctifiés. ");
INSERT INTO francl_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Des encensoirs de ces gens qui ont péché contre leur propre vie, qu’on fasse des lames étendues, pour en recouvrir l’autel des holocaustes ; car on les a présentés devant Yahweh, et ils sont devenus saints ; ils serviront de signe aux enfants d’Israël. » ");
INSERT INTO francl_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Le prêtre Eléazar prit les encensoirs d’airain qu’avaient présentés les hommes consumés par le feu, et il en fit des lames pour couvrir l’autel. ");
INSERT INTO francl_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","C’est un mémorial pour les enfants d’Israël, afin qu’aucun étranger, qui n’est pas de la race d’Aaron, ne s’approche pour offrir du parfum devant Yahweh, et ne soit comme Coré et comme sa troupe, selon ce que Yahweh lui avait déclaré par Moïse. ");
INSERT INTO francl_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Le lendemain, toute l’assemblée des enfants d’Israël murmura contre Moïse et Aaron, en disant : « Vous avez fait mourir le peuple de Yahweh. » ");
INSERT INTO francl_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Comme l’assemblée s’attroupait contre Moïse et Aaron, ceux-ci se tournèrent vers la tente de réunion, et voici que la nuée la couvrit, et que la gloire de Yahweh apparut. ");
INSERT INTO francl_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Moïse et Aaron s’avancèrent devant la tente de réunion, ");
INSERT INTO francl_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","et Yahweh parla à Moïse en disant : ");
INSERT INTO francl_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","« Eloignez-vous du milieu de cette assemblée, et je les consumerai en un instant. » Ils tombèrent sur leur visage, ");
INSERT INTO francl_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","et Moïse dit à Aaron : « Prends l’encensoir, et mets-y du feu de dessus l’autel, jettes-y du parfum, va promptement vers l’assemblée, et fais pour eux l’expiation ; car la colère est sortie de devant Yahweh ; la plaie commence. » ");
INSERT INTO francl_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Aaron prit l’encensoir, comme Moïse avait dit, et courut au milieu de l’assemblée ; et voici que la plaie commençait parmi le peuple. Ayant mis le parfum, il fit l’expiation pour le peuple. ");
INSERT INTO francl_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Il se plaça entre les morts et les vivants, et la plaie fut arrêtée. ");
INSERT INTO francl_vpl VALUES ("NU17_14","005_17_14","NUM","17","14","14","Quatorze mille sept cents personnes moururent par cette plaie, outre ceux qui étaient morts à cause de Coré. ");
INSERT INTO francl_vpl VALUES ("NU17_15","005_17_15","NUM","17","15","15","Aaron retourna auprès de Moïse, à l’entrée de la tente de réunion, et la plaie était arrêtée. ");
INSERT INTO francl_vpl VALUES ("NU17_16","005_17_16","NUM","17","16","16","Yahweh parla à Moïse en disant : ");
INSERT INTO francl_vpl VALUES ("NU17_17","005_17_17","NUM","17","17","17","« Parle aux enfants d’Israël et prends d’eux une verge, une verge par chaque maison patriarcale, soit douze verges de la part de tous leurs princes pour leurs douze maisons patriarcales. Tu écriras le nom de chacun sur sa verge ; ");
INSERT INTO francl_vpl VALUES ("NU17_18","005_17_18","NUM","17","18","18","tu écriras le nom d’Aaron sur la verge de Lévi, car il y aura une verge par chef de leurs maisons patriarcales. ");
INSERT INTO francl_vpl VALUES ("NU17_19","005_17_19","NUM","17","19","19","Tu les déposeras dans la tente de réunion, devant le témoignage, où je me rencontre avec vous. ");
INSERT INTO francl_vpl VALUES ("NU17_20","005_17_20","NUM","17","20","20","L’homme que je choisirai sera celui dont la verge fleurira, et je ferai cesser de devant moi les murmures que profèrent contre vous les enfants d’Israël. » ");
INSERT INTO francl_vpl VALUES ("NU17_21","005_17_21","NUM","17","21","21","Moïse parla aux enfants d’Israël, et tous leurs princes lui donnèrent une verge, chaque prince une verge, selon leurs maisons patriarcales, soit douze verges, et la verge d’Aaron était au milieu de leurs verges. ");
INSERT INTO francl_vpl VALUES ("NU17_22","005_17_22","NUM","17","22","22","Moïse déposa les verges devant Yahweh, dans la tente du témoignage. ");
INSERT INTO francl_vpl VALUES ("NU17_23","005_17_23","NUM","17","23","23","Le lendemain, Moïse retourna dans la tente du témoignage, et voici que la verge d’Aaron avait fleuri, pour la tribu de Lévi : il y avait poussé des boutons, éclos des fleurs et mûri des amandes. ");
INSERT INTO francl_vpl VALUES ("NU17_24","005_17_24","NUM","17","24","24","Moïse emporta toutes les verges de devant Yahweh, vers tous les enfants d’Israël, et ils les virent, et chacun reprit sa verge. ");
INSERT INTO francl_vpl VALUES ("NU17_25","005_17_25","NUM","17","25","25","Yahweh dit à Moïse : « Replace la verge d’Aaron devant le témoignage, pour être conservée comme un signe pour les enfants de rébellion, afin que tu fasses cesser de devant moi leurs murmures, et qu’ils ne meurent point. » ");
INSERT INTO francl_vpl VALUES ("NU17_26","005_17_26","NUM","17","26","26","Moïse fit ainsi ; il fit selon l’ordre que Yahweh lui avait donné. ");
INSERT INTO francl_vpl VALUES ("NU17_27","005_17_27","NUM","17","27","27","les enfants d’Israël dirent à Moïse : « Voici que nous périssons, nous sommes perdus, tous perdus ! ");
INSERT INTO francl_vpl VALUES ("NU17_28","005_17_28","NUM","17","28","28","Quiconque s’approche de la Demeure de Yahweh meurt. Nous faudra-t-il donc tous périr ? » ");
INSERT INTO francl_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Yahweh dit à Aaron : « Toi et tes fils, et la maison de ton père avec toi, vous porterez l’iniquité du sanctuaire ; toi et tes fils avec toi, vous porterez l’iniquité de votre sacerdoce. ");
INSERT INTO francl_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Fais aussi approcher avec toi du sanctuaire tes autres frères, la tribu de Lévi, la tribu de ton père, afin qu’ils te soient adjoints et qu’ils te servent, lorsque toi, et tes fils avec toi, vous serez devant la tente du témoignage. ");
INSERT INTO francl_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Ils rempliront ton service et le service de toute la tente ; mais ils ne s’approcheront ni des ustensiles du sanctuaire, ni de l’autel, de peur que vous ne mouriez, eux et vous. ");
INSERT INTO francl_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Ils te seront adjoints, et ils rempliront le service de la tente de réunion, pour tout le travail de la tente. Aucun étranger n’approchera de vous. ");
INSERT INTO francl_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Vous remplirez le service du sanctuaire et le service de l’autel, afin qu’il n’y ait plus de colère contre les enfants d’Israël. ");
INSERT INTO francl_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Voici, j’ai pris vos frères les lévites du milieu des enfants d’Israël ; donnés à Yahweh, ils vous sont remis en don pour faire le travail de la tente de réunion. ");
INSERT INTO francl_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Toi et tes fils avec toi, vous remplirez votre sacerdoce pour tout ce qui concerne l’autel et pour ce qui est en dedans du voile : vous ferez ce travail. Comme une fonction en pur don, je vous confère votre sacerdoce. L’étranger qui approchera sera mis à mort. » ");
INSERT INTO francl_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Yahweh dit à Aaron : « Voici, je te donne le service de ce qui est prélevé pour moi, de toutes les choses consacrées des enfants d’Israël ; je te les donne, à raison de l’onction que tu as reçue, à toi et à tes fils, par une loi perpétuelle. ");
INSERT INTO francl_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Voici ce qui te reviendra des choses très saintes, sauf ce que le feu doit consumer : toutes leurs offrandes, savoir toutes leurs oblations, tous leurs sacrifices pour le péché et tous leurs sacrifices de réparation qu’ils me rendront : tout cela, comme choses très saintes, sera pour toi et pour tes fils. ");
INSERT INTO francl_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Tu les mangeras dans un lieu très saint ; tout mâle en mangera ; elles seront saintes pour toi. ");
INSERT INTO francl_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Ceci encore t’appartient : ce qui est prélevé sur leurs dons, sur toute offrande balancée des enfants d’Israël ; je te le donne à toi, à tes fils et à tes filles avec toi, par une loi perpétuelle ; quiconque est pur dans ta maison en mangera. ");
INSERT INTO francl_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Tout le meilleur de l’huile, tout le meilleur du vin nouveau et du blé, leurs prémices qu’ils offrent à Yahweh, je te les donne. ");
INSERT INTO francl_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Les premiers produits de leur terre qu’ils apporteront à Yahweh seront pour toi. Quiconque est pur dans ta maison en mangera. ");
INSERT INTO francl_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Tout ce qui sera dévoué par anathème en Israël sera pour toi. ");
INSERT INTO francl_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Tout premier-né de toute chair, des hommes comme des animaux, qu’ils offrent à Yahweh, sera pour toi. Seulement tu feras racheter le premier-né de l’homme, et tu feras racheter le premier-né d’un animal impur. ");
INSERT INTO francl_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Quant à son rachat, tu le feras racheter dès l’âge d’un mois, selon ton estimation, contre cinq sicles d’argent, selon le sicle du sanctuaire, qui est de vingt guéras. ");
INSERT INTO francl_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Mais tu ne feras pas racheter le premier-né du bœuf, ni le premier-né de la brebis, ni le premier-né de la chèvre : ils sont saints. Tu répandras leur sang sur l’autel et tu feras fumer leur graisse : c’est un sacrifice fait par le feu, d’une agréable odeur à Yahweh. ");
INSERT INTO francl_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Leur chair sera pour toi, comme la poitrine qu’on balance et comme la cuisse droite. ");
INSERT INTO francl_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Tout ce qui est prélevé sur les choses saintes, ce que les enfants d’Israël prélèvent pour Yahweh, je te le donne à toi, à tes fils et à tes filles avec toi, par une loi perpétuelle ; c’est une alliance de sel, perpétuelle, devant Yahweh, pour toi et pour ta postérité avec toi. » ");
INSERT INTO francl_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Yahweh dit à Aaron : « Tu n’auras pas d’héritage dans leur pays, et il n’y aura pas de part pour toi au milieu d’eux ; c’est moi qui suis ta part et ton héritage au milieu des enfants d’Israël. ");
INSERT INTO francl_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Voici que je donne comme héritage aux fils de Lévi toute dîme en Israël, pour le travail qu’ils font, le travail de la tente de réunion. ");
INSERT INTO francl_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Les enfants d’Israël n’approcheront plus de la tente de réunion, de peur qu’ils ne portent leur péché et qu’ils meurent. ");
INSERT INTO francl_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Les Lévites feront le travail de la tente de réunion, et ils porteront leur iniquité. En vertu d’une loi perpétuelle parmi vos descendants, ils n’auront pas d’héritage au milieu des enfants d’Israël. ");
INSERT INTO francl_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Car je donne aux Lévites comme héritage les dîmes que les enfants d’Israël prélèveront pour Yahweh ; c’est pourquoi je leur dis : Ils n’auront pas d’héritage au milieu des enfants d’Israël. » ");
INSERT INTO francl_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","« Tu parleras aux Lévites et tu leur diras : “Lorsque vous recevrez des enfants d’Israël la dîme que je vous donne de leurs biens pour votre héritage, vous en prélèverez une offrande pour Yahweh, une dîme de la dîme ; ");
INSERT INTO francl_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","et ce prélèvement que vous ferez vous sera compté comme le blé qu’on prélève de l’aire, et comme le vin nouveau qu’on prélève de la cuve. ");
INSERT INTO francl_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","C’est ainsi que vous prélèverez, vous aussi, une offrande pour Yahweh, sur toutes les dîmes que vous recevrez des enfants d’Israël, et cette offrande que vous en aurez prélevée pour Yahweh, vous la donnerez au prêtre Aaron. ");
INSERT INTO francl_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Sur tous les dons que vous recevrez, vous prélèverez toute l’offrande de Yahweh ; sur tout le meilleur, la sainte portion qui en est tirée. ");
INSERT INTO francl_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Tu leur diras : Quand vous en aurez prélevé le meilleur, la dîme sera comptée aux lévites comme le produit de l’aire et comme le produit du pressoir. ");
INSERT INTO francl_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Vous la mangerez en tout lieu, vous et votre famille ; car c’est votre salaire pour le travail que vous faites dans la tente de réunion. ");
INSERT INTO francl_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Vous ne porterez pour cela aucun péché, quand vous en aurez prélevé le meilleur, vous ne profanerez pas les saintes offrandes des enfants d’Israël, et vous ne mourrez point.” » ");
INSERT INTO francl_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Yahweh parla à Moïse et à Aaron, en disant : ");
INSERT INTO francl_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","« Voici l’ordonnance de la loi que Yahweh a prescrite, en disant : Dis aux enfants d’Israël de t’amener une vache rousse, sans tache, sans défaut corporel, et qui n’ait pas porté le joug. ");
INSERT INTO francl_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Vous la remettrez au prêtre Eléazar, qui la fera sortir du camp, et on l’égorgera devant lui. ");
INSERT INTO francl_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Le prêtre Eléazar prendra du sang de la vache avec le doigt, et il fera sept fois l’aspersion de ce sang du côté de l’entrée de la tente de réunion. ");
INSERT INTO francl_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","On brûlera la vache sous ses yeux ; on brûlera sa peau, sa chair et son sang, ainsi que ses excréments. ");
INSERT INTO francl_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Le prêtre prendra du bois de cèdre, de l’hysope et du cramoisi, et il les jettera au milieu du feu qui consume la vache. ");
INSERT INTO francl_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Le prêtre lavera ses vêtements et baignera son corps dans l’eau ; puis il rentrera dans le camp et sera impur jusqu’au soir. ");
INSERT INTO francl_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Celui qui aura brûlé la vache lavera ses vêtements dans l’eau, et baignera son corps dans l’eau, et il sera impur jusqu’au soir. ");
INSERT INTO francl_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Un homme pur recueillera la cendre de la vache et la déposera hors du camp, dans un lieu pur ; on la conservera pour l’assemblée des enfants d’Israël, en vue de l’eau qui ôte la souillure : c’est un sacrifice pour le péché. ");
INSERT INTO francl_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Celui qui aura recueilli la cendre de la vache lavera ses vêtements, et sera impur jusqu’au soir. — Ce sera une loi perpétuelle pour les enfants d’Israël et pour l’étranger qui séjourne au milieu d’eux. ");
INSERT INTO francl_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","Celui qui touchera un mort, un corps humain quelconque, sera impur pendant sept jours. ");
INSERT INTO francl_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Il se purifiera avec cette eau le troisième jour et le septième jour, et il sera pur ; mais s’il ne se purifie pas le troisième jour et le septième jour, il ne sera pas pur. ");
INSERT INTO francl_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Celui qui touchera un mort, le corps d’un homme qui est mort, et qui ne se purifiera pas, souillera la Demeure de Yahweh ; cet homme sera retranché d’Israël. Parce que l’eau qui ôte la souillure n’a pas été répandue sur lui, il est impur, et sa souillure est encore sur lui. ");
INSERT INTO francl_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Voici la loi. Lorsqu’un homme meurt dans une tente, quiconque entre dans la tente et tout ce qui se trouve dans la tente sera impur pendant sept jours. ");
INSERT INTO francl_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Tout vase découvert, sur lequel il n’y a pas de couvercle attaché, est impur. ");
INSERT INTO francl_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Quiconque touche dans les champs un homme tué par l’épée, ou un mort, ou des ossements humains, ou un sépulcre, sera impur pendant sept jours. ");
INSERT INTO francl_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","On prendra, pour celui qui est impur, de la cendre de la victime, consumée en sacrifice expiatoire, et l’on mettra dessus de l’eau vive dans un vase. ");
INSERT INTO francl_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Un homme pur prendra de l’hysope et, l’ayant trempée dans l’eau, il en fera l’aspersion sur la tente, sur tous les ustensiles et sur les personnes qui étaient là, sur celui qui a touché des ossements, ou un homme tué, ou un mort, ou un sépulcre. ");
INSERT INTO francl_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","L’homme pur fera l’aspersion sur celui qui est impur, le troisième jour et le septième jour, et il lui ôtera son péché le septième jour. L’homme impur lavera ses vêtements et se baignera dans l’eau, et le soir il sera pur. ");
INSERT INTO francl_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","L’homme qui sera devenu impur et qui ne se purifiera pas, sera retranché du milieu de l’assemblée, car il souille le sanctuaire de Yahweh ; parce que l’eau qui ôte la souillure n’a pas été répandue sur lui, il est impur. ");
INSERT INTO francl_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Ce sera pour eux une loi perpétuelle. Celui qui aura fait l’aspersion de l’eau qui ôte la souillure lavera ses vêtements, et celui qui touchera l’eau qui ôte la souillure, sera impur jusqu’au soir. ");
INSERT INTO francl_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Tout ce que touchera celui qui est impur sera souillé, et la personne qui le touchera sera impure jusqu’au soir. » ");
INSERT INTO francl_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Les enfants d’Israël, toute l’assemblée, arrivèrent au désert de Sin, dans le premier mois, et le peuple séjourna à Cadès. C’est là que mourut Marie et qu’elle fut enterrée. ");
INSERT INTO francl_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Comme il n’y avait pas d’eau pour l’assemblée, ils s’attroupèrent contre Moïse et Aaron. ");
INSERT INTO francl_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Le peuple disputa avec Moïse, et ils dirent : « Que n’avons-nous péri quand nos frères périrent devant Yahweh ? ");
INSERT INTO francl_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Pourquoi avez-vous fait venir l’assemblée de Yahweh dans ce désert, pour que nous y mourions, nous et notre bétail ? ");
INSERT INTO francl_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Pourquoi nous avez-vous fait monter d’Égypte, pour nous amener dans ce méchant lieu ? Ce n’est pas un lieu où l’on puisse semer, et il n’y a ni figuier, ni vigne, ni grenadier, ni même d’eau à boire ? » ");
INSERT INTO francl_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Moïse et Aaron, s’éloignant de l’assemblée, vinrent à l’entrée de la tente de réunion. Ils tombèrent sur leur visage, et la gloire de Yahweh leur apparut. ");
INSERT INTO francl_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","« Prends le bâton et convoque l’assemblée, toi et ton frère Aaron ; vous parlerez au rocher en leur présence, afin qu’il donne ses eaux ; et tu feras sortir pour eux de l’eau du rocher, et tu donneras à boire à l’assemblée et à son bétail. » ");
INSERT INTO francl_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Moïse prit le bâton qui était devant Yahweh, comme Yahweh le lui avait ordonné. ");
INSERT INTO francl_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Puis Moïse et Aaron convoquèrent l’assemblée en face du rocher, et Moïse leur dit : « Ecoutez-donc, rebelles ! Vous ferons-nous sortir de l’eau de ce rocher ? » ");
INSERT INTO francl_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Moïse leva la main et frappa deux fois le rocher de son bâton ; et il sortit de l’eau en abondance. L’assemblée but, ainsi que le bétail. ");
INSERT INTO francl_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Alors Yahweh dit à Moïse et à Aaron : « Parce que vous n’avez pas cru en moi, pour me sanctifier aux yeux des enfants d’Israël, vous ne ferez pas entrer cette assemblée dans le pays que je lui donne. » ");
INSERT INTO francl_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Ce sont là les eaux de Mériba, où les enfants d’Israël contestèrent avec Yahweh, et il se sanctifia en eux. ");
INSERT INTO francl_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","De Cadès, Moïse envoya des messages au roi d’Edom, pour lui dire : « Ainsi parle ton frère Israël : Tu sais toutes les souffrances que nous avons endurées. ");
INSERT INTO francl_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Nos pères descendirent en Égypte, et nous y demeurâmes longtemps ; mais les Egyptiens nous maltraitèrent, nous et nos pères. ");
INSERT INTO francl_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Nous avons crié à Yahweh, et il a entendu notre voix ; il a envoyé un ange et nous a fait sortir d’Égypte. Et voici que nous sommes à Cadès, ville située à la limite de ton territoire. ");
INSERT INTO francl_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Laisse-nous, de grâce, traverser ton pays ; nous ne traverserons ni les champs, ni les vignes, et nous ne boirons pas l’eau des puits ; mais nous suivrons la route royale, sans nous détourner à droite ou à gauche, jusqu’à ce que nous ayons traversé ton territoire. » ");
INSERT INTO francl_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Edom lui dit : « Tu ne passeras pas chez moi, sinon je sortirai à ta rencontre avec l’épée. » ");
INSERT INTO francl_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Les enfants d’Israël lui dirent : « Nous monterons par la grande route, et, si nous buvons de ton eau, moi et mes troupeaux, j’en paierai le prix. Ce n’est pas une affaire ; je ne ferai que passer avec mes pieds. » ");
INSERT INTO francl_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Il répondit : « Tu ne passeras pas ! » Et Edom sortit à sa rencontre avec un peuple nombreux et à main forte. ");
INSERT INTO francl_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","C’est ainsi qu’Edom refusa de donner passage à Israël sur son territoire ; et Israël se détourna de lui. ");
INSERT INTO francl_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Les enfants d’Israël, toute l’assemblée, partirent de Cadès et arrivèrent à la montagne de Hor. ");
INSERT INTO francl_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Yahweh dit à Moïse et à Aaron, à la montagne de Hor, sur la frontière du pays d’Edom : ");
INSERT INTO francl_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","« Aaron va être recueilli auprès de son peuple ; car il n’entrera pas dans le pays que je donne aux enfants d’Israël, parce que vous avez été rebelles à mon ordre, aux eaux de Mériba. ");
INSERT INTO francl_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Prends Aaron et son fils Eléazar, et fais-les monter sur la montagne de Hor. ");
INSERT INTO francl_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Tu dépouilleras Aaron de ses vêtements et tu en feras revêtir Eléazar, son fils. C’est là qu’Aaron sera recueilli et mourra. » ");
INSERT INTO francl_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Moïse fit ce qui Yahweh avait ordonné ; ils montèrent sur la montagne de Hor, aux yeux de toute l’assemblée ; ");
INSERT INTO francl_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","puis Moïse, ayant dépouillé Aaron de ses vêtements, les fit revêtir à Eléazar, son fils ; et Aaron mourut là, au sommet de la montagne, et Moïse et Eléazar descendirent de la montagne. ");
INSERT INTO francl_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Toute l’assemblée vit qu’Aaron avait expiré, et toute la maison d’Israël pleura Aaron pendant trente jours. ");
INSERT INTO francl_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Le Chananéen, roi d’Arad, qui habitait le Négeb, apprit qu’Israël venait par le chemin d’Atharim. Il livra bataille à Israël et lui fit des prisonniers. ");
INSERT INTO francl_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Alors Israël fit un vœu à Yahweh, en disant : « Si vous livrez ce peuple entre mes mains, je dévouerai ses villes à l’anathème. » ");
INSERT INTO francl_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Yahweh entendit la voix d’Israël et livra les Chananéens ; on les dévoua à l’anathème, eux et leurs villes, et on nomma ce lieu Horma. ");
INSERT INTO francl_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Ils partirent de la montagne de Hor par le chemin de la mer Rouge, pour tourner le pays d’Edom. Le peuple perdit patience dans ce chemin, ");
INSERT INTO francl_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","et il parla contre Dieu et contre Moïse : « Pourquoi nous avez-vous fait monter d’Égypte, pour que nous mourions dans le désert ? Il n’y a pas de pain, il n’y a pas d’eau, et notre âme a pris en dégoût cette misérable nourriture. » ");
INSERT INTO francl_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Alors Yahweh envoya contre le peuple les serpents brûlants ; ils mordirent le peuple, et il mourut beaucoup de gens en Israël. ");
INSERT INTO francl_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Le peuple vint à Moïse et dit : « Nous avons péché, car nous avons parlé contre Yahweh et contre toi. Prie Yahweh, afin qu’il éloigne de nous ces serpents. » Moïse pria pour le peuple. ");
INSERT INTO francl_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Et Yahweh dit à Moïse : « Fais-toi un serpent brûlant et place-le sur un poteau ; quiconque aura été mordu et le regardera, conservera la vie. » ");
INSERT INTO francl_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Moïse fit un serpent d’airain et le plaça sur un poteau, et, si quelqu’un était mordu par un serpent, il regardait le serpent d’airain, et il vivait. ");
INSERT INTO francl_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Les enfants d’Israël partirent, et ils campèrent à Oboth. ");
INSERT INTO francl_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Ils partirent d’Oboth, et ils campèrent à Jeabarim, dans le désert qui est vis-à-vis de Moab, vers le soleil levant. ");
INSERT INTO francl_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Ils partirent de là, et campèrent dans la vallée de Zared. ");
INSERT INTO francl_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Ils partirent de là, et campèrent au-delà de l’Arnon, qui coule dans le désert, en sortant du territoire des Amorrhéens ; car l’Arnon est la frontière de Moab, entre Moab et les Amorrhéens. ");
INSERT INTO francl_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","C’est pourquoi il est dit dans le livre des Guerres de Yahweh : «  Yahweh a pris Vaheb, dans sa course impétueuse, et les torrents de l’Arnon, ");
INSERT INTO francl_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","et la pente des torrents qui s’étend vers le site d’Ar et s’appuie à la frontière de Moab. » ");
INSERT INTO francl_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","De là ils allèrent à Beer. C’est le puits à propos duquel Yahweh dit à Moïse : « Rassemble le peuple, et je leur donnerai de l’eau. » ");
INSERT INTO francl_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Alors Israël chanta ce cantique : Monte, puits ! Acclamez-le ! ");
INSERT INTO francl_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Le puits, que des princes ont creusé, que les grands du peuple ont ouvert, avec le sceptre, avec leurs bâtons ! Du désert ils allèrent à Matthana ; ");
INSERT INTO francl_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","de Matthana à Nahaliel ; de Nahaliel, à Bamoth ; ");
INSERT INTO francl_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","de Bamoth, à la vallée qui est dans les champs de Moab, au sommet du Phasga, qui domine le désert. ");
INSERT INTO francl_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Israël envoya des messagers à Séhon, roi des Amorrhéens, pour lui dire : ");
INSERT INTO francl_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","« Laisse-moi passer par ton pays ; nous ne nous écarterons ni dans les champs, ni dans les vignes, et nous ne boirons pas l’eau des puits ; nous suivrons la route royale, jusqu’à ce que nous ayons franchi ton territoire. » ");
INSERT INTO francl_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Séhon ne permit pas à Israël de passer sur son territoire ; il rassembla tout son peuple et, étant sorti à la rencontre d’Israël dans le désert, il vint à Jasa et livra bataille à Israël. ");
INSERT INTO francl_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Israël le frappa du tranchant de l’épée, et se rendit maître de son pays depuis l’Arnon jusqu’au Jaboc, jusqu’aux enfants d’Ammon ; car la frontière des enfants d’Ammon était forte. ");
INSERT INTO francl_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Israël prit toutes ces villes et Israël s’établit dans toutes les villes des Amorrhéens, à Hésebon et dans toutes les villes de son ressort. ");
INSERT INTO francl_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Car Hésebon était la ville de Séhon, roi des Amorrhéens, qui avait fait la guerre au précédent roi de Moab et lui avait enlevé tout son pays jusqu’à l’Arnon. ");
INSERT INTO francl_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","C’est pourquoi les poètes disent : Venez à Hésebon ! Que la ville de Séhon soit rebâtie et fortifiée ! ");
INSERT INTO francl_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Car il est sorti un feu de Hésebon, une flamme de la ville de Séhon ; elle a dévoré Ar-Moab. Les maîtres des hauteurs de l’Arnon. ");
INSERT INTO francl_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Malheur à toi, Moab ! Tu es perdu, peuple de Chamos ! Il a livré ses fils fugitifs et ses filles captives à Séhon, roi des Amorrhéens. ");
INSERT INTO francl_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Et nous avons lancé sur eux nos traits ; Hésebon est détruite jusqu’à Dibon ; nous avons dévasté jusqu’à Nophé, avec le feu jusqu’à Médaba. ");
INSERT INTO francl_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Israël s’établit dans le pays des Amorrhéens. ");
INSERT INTO francl_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Moïse envoya reconnaître Jaser ; et ils prirent les villes de son ressort, et expulsèrent les Amorrhéens qui y étaient. ");
INSERT INTO francl_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Puis, changeant de direction, ils montèrent par le chemin de Basan. Og, roi de Basan, sortit à leur rencontre, avec tout son peuple, pour les combattre à Edraï. ");
INSERT INTO francl_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Yahweh dit à Moïse : « Ne le crains point, car je le livre entre tes mains, lui, tout son peuple et son pays ; tu le traiteras comme tu as traité Séhon, roi des Amorrhéens, qui habitait à Hésebon. » ");
INSERT INTO francl_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Et ils le battirent, lui et ses fils, et tout son peuple, jusqu’à ne pas lui laisser de survivant, et ils s’emparèrent de son pays. ");
INSERT INTO francl_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Les enfants d’Israël, étant partis, campèrent dans les plaines de Moab, au-delà du Jourdain, vis-à-vis de Jéricho. ");
INSERT INTO francl_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Balac, fils de Séphor, vit tout ce qu’Israël avait fait aux Amorrhéens ; ");
INSERT INTO francl_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","et Moab fut très effrayé en face du peuple, car celui-ci était nombreux ; il fut saisi d’épouvante en face des enfants d’Israël. ");
INSERT INTO francl_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Moab dit aux anciens de Madian : « Cette multitude va dévorer tout ce qui nous entoure, comme le bœuf dévore la verdure des champs. » — Balac, fils de Séphor était alors roi de Moab. — ");
INSERT INTO francl_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Il envoya des messagers à Balaam, fils de Béor, à Péthor, qui est sur le Fleuve, dans le pays des fils de son peuple, pour l’appeler et lui dire : « Voici, un peuple est sorti d’Égypte ; il couvre la face de la terre, et il habite vis-à-vis de moi. ");
INSERT INTO francl_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Viens donc, je te prie, maudis-moi ce peuple, car il est plus puissant que moi ; peut-être ainsi pourrai-je le battre et le jeter hors du pays ; car je sais que celui que tu bénis est béni, et que celui que tu maudis est maudit. » ");
INSERT INTO francl_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Les anciens de Moab et les anciens de Madian se mirent en route, emportant avec eux le salaire du devin. Arrivés auprès de Balaam, ils lui rapportèrent les paroles de Balac. ");
INSERT INTO francl_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Balaam leur dit : « Passez ici la nuit, et je vous donnerai réponse, selon ce que Yahweh me dira. » Et les princes de Moab restèrent chez Balaam. ");
INSERT INTO francl_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Dieu vint à Balaam et lui dit : « Qui sont ces hommes que tu as chez toi ? » ");
INSERT INTO francl_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Balaam répondit à Dieu : « Balac, fils de Séphor, roi de Moab, les a envoyés pour me dire : ");
INSERT INTO francl_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","Voici, le peuple qui est sorti d’Égypte couvre la face de la terre ; viens donc, maudis-le-moi ; peut-être ainsi pourrai-je le combattre et le chasser. » ");
INSERT INTO francl_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Dieu dit à Balaam : « Tu n’iras pas avec eux ; tu ne maudiras pas ce peuple, car il est béni. » ");
INSERT INTO francl_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Le matin, Balaam, s’étant levé, dit aux princes de Balac : « Allez dans votre pays, car Yahweh refuse de me laisser aller avec vous. » ");
INSERT INTO francl_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Alors les princes de Moab se levèrent et retournèrent vers Balac, et ils dirent : « Balaam a refusé de venir avec nous. » ");
INSERT INTO francl_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Balac envoya de nouveau des princes en plus grand nombre et de plus haut rang que les premiers. ");
INSERT INTO francl_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Arrivés auprès de Balaam, ils lui dirent : « Ainsi parle Balac, fils de Séphor : « Que rien, je te prie, ne t’empêche de venir vers moi ; ");
INSERT INTO francl_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","car je te rendrai les plus grands honneurs, et je ferai tout ce que tu me diras. Mais viens, je te prie ; maudis-moi ce peuple. » ");
INSERT INTO francl_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Balaam répondit et dit aux serviteurs de Balac : « Quand Balac me donnerait plein sa maison d’argent et d’or, je ne pourrai transgresser l’ordre de Yahweh mon Dieu, en faisant une chose, petite ou grande. ");
INSERT INTO francl_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Maintenant, je vous prie, restez ici, vous aussi, cette nuit, que je sache ce que Yahweh me dira encore. » ");
INSERT INTO francl_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Dieu vint à Balaam dans la nuit, et lui dit : « Si ces hommes sont venus pour t’appeler, lève-toi et va avec eux ; mais tu feras ce que je te dirai. » ");
INSERT INTO francl_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Balaam se leva le matin et, ayant sellé son ânesse, il partit avec les princes de Moab. ");
INSERT INTO francl_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","La colère de Dieu s’alluma parce qu’il allait, et l’ange de Yahweh se plaça sur le chemin, pour lui faire obstacle. — Balaam était monté sur son ânesse, et il avait avec lui ses deux serviteurs. — ");
INSERT INTO francl_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","L’ânesse vit l’ange de Yahweh qui se tenait sur le chemin, son épée nue à la main ; elle se détourna du chemin et alla dans les champs ; et Balaam frappa l’ânesse pour la ramener dans le chemin. ");
INSERT INTO francl_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Alors l’ange de Yahweh se tint dans un chemin creux entre les vignes, où il y avait une clôture de chaque côté. ");
INSERT INTO francl_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Voyant l’ange de Yahweh, l’ânesse se serra contre le mur, et pressa contre le mur le pied de Balaam, et celui-ci la frappa de nouveau. ");
INSERT INTO francl_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","L’ange de Yahweh passa plus loin et se tint dans un lieu étroit où il n’y avait pas d’espace pour se détourner à droite ou à gauche. ");
INSERT INTO francl_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","L’ânesse, en voyant l’ange de Yahweh, se coucha sous Balaam, et la colère de Balaam s’enflamma, et il frappa l’ânesse de son bâton. ");
INSERT INTO francl_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Yahweh ouvrit la bouche de l’ânesse, et elle dit à Balaam : « Que t’ai-je fait, que tu m’aies frappée ces trois fois ? » ");
INSERT INTO francl_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Balaam répondit à l’ânesse : « C’est parce que tu t’es jouée de moi ; si j’avais une épée dans la main, je te tuerais à l’instant. » ");
INSERT INTO francl_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","L’ânesse dit à Balaam : « Ne suis-je pas ton ânesse, que tu as toujours montée jusqu’à présent ? Ai-je l’habitude d’agir ainsi envers toi ? » Et il répondit : « Non. » ");
INSERT INTO francl_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Yahweh ouvrit les yeux de Balaam, et Balaam vit l’ange de Yahweh qui se tenait sur le chemin, son épée nue dans la main ; et il s’inclina et se prosterna sur son visage. ");
INSERT INTO francl_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","L’ange de Yahweh lui dit : « Pourquoi as-tu frappé ton ânesse ces trois fois ? Voici, je suis sorti pour te faire obstacle, car, à mes yeux, le chemin que tu suis te mène à la ruine. ");
INSERT INTO francl_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","L’ânesse m’a vu ; et elle s’est détournée devant moi ces trois fois ; si elle ne s’était pas détournée devant moi, je t’aurais tué, toi, et je lui aurais laissé la vie. » ");
INSERT INTO francl_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Balaam dit à l’ange de Yahweh : « J’ai péché, car je ne savais pas que tu te tenais devant moi sur le chemin ; et maintenant, si cela te déplaît, je m’en retournerai. » ");
INSERT INTO francl_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","L’ange de Yahweh dit à Balaam : « Va avec ces hommes ; mais tu ne diras pas autre chose que ce que je te dirai. » Et Balaam alla avec les princes de Balac. ");
INSERT INTO francl_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Balac, ayant appris que Balaam arrivait, sortit à sa rencontre jusqu’à la ville de Moab, qui est sur la frontière de l’Arnon, à l’extrême frontière. ");
INSERT INTO francl_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Balac dit à Balaam : « N’avais-je pas envoyé déjà vers toi pour t’appeler ? Pourquoi n’es-tu pas venu vers moi ? Ne puis-je pas en vérité te traiter avec honneur ? » ");
INSERT INTO francl_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Balaam dit à Balac : « Voici, je suis venu vers toi ; mais maintenant pourrai-je dire quoi que ce soit ? Les paroles que Dieu mettra dans ma bouche, je les dirai. » ");
INSERT INTO francl_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Balaam se mit en route avec Balac, et ils arrivèrent à Qiriath-Chutsoth. ");
INSERT INTO francl_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Balac immola en sacrifice des bœufs et des brebis, et il en envoya des portions à Balaam et aux princes qui étaient avec lui. ");
INSERT INTO francl_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Le matin, Balac prit avec lui Balaam et le fit monter à Bamoth-Baal, d’où Balaam put apercevoir les derniers rangs du peuple. ");
INSERT INTO francl_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Balaam dit à Balac : « Bâtis-moi ici sept autels, et prépare-moi ici sept taureaux et sept béliers. » ");
INSERT INTO francl_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balac fit ce que Balaam avait dit, et Balac avec Balaam offrit un taureau et un bélier sur chaque autel. ");
INSERT INTO francl_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Balaam dit à Balac : « Tiens-toi près de ton holocauste, et je m’éloignerai ; peut-être que Yahweh viendra à ma rencontre et quoi qu’il me fasse voir, je te le dirai. » Et il s’en alla sur une hauteur dénudée. ");
INSERT INTO francl_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Dieu vint à la rencontre de Balaam, qui lui dit : « J’ai dressé les sept autels, et j’ai offert sur chaque autel un taureau et un bélier. » ");
INSERT INTO francl_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Yahweh mit une parole dans la bouche de Balaam et dit : « Retourne auprès de Balac, et parle-lui ainsi. » ");
INSERT INTO francl_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Il retourna vers lui, et voici, Balac se tenait près de son holocauste, lui et tous les princes de Moab. ");
INSERT INTO francl_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Et Balaam prononça son discours en disant : D’Aram, Balac m’a fait venir, le roi de Moab m’a fait venir des montagnes de l’Orient : « Viens, maudis-moi Jacob ! Viens, courrouce-toi contre Israël ! » ");
INSERT INTO francl_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Comment maudirai-je quand Dieu ne maudit pas ? Comment me courroucerai-je, quand Yahweh n’est pas courroucé ? ");
INSERT INTO francl_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Car du sommet des rochers je le vois, du haut des collines je le considère : c’est un peuple qui a sa demeure à part, et qui ne sera pas mis au nombre des nations. ");
INSERT INTO francl_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Qui peut compter la poussière de Jacob, et dénombrer le quart d’Israël ? Que je meure de la mort des justes, et que ma fin soit semblable à la leur ! ");
INSERT INTO francl_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Balac dit à Balaam : « Que m’as-tu fait ? Je t’ai pris pour maudire mes ennemis, et voilà, tu ne fais que bénir ! » ");
INSERT INTO francl_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Il répondit et dit : « Ne dois-je pas avoir soin de dire ce que Yahweh met dans ma bouche ? » ");
INSERT INTO francl_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Balac lui dit : « Viens avec moi à une autre place, d’où tu le verras ; tu en verras seulement l’extrémité, sans le voir tout entier ; et de là, maudis-le-moi. » ");
INSERT INTO francl_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Il le mena au champ des Sentinelles, sur le sommet de Phasga ; et, ayant bâti sept autels, il offrit un taureau et un bélier sur chaque autel. ");
INSERT INTO francl_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Et Balaam dit à Balac : « Tiens-toi ici près de ton holocauste, et moi j’irai là à la rencontre de Dieu. » ");
INSERT INTO francl_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Yahweh vint à la rencontre de Balaam, et il mit une parole dans sa bouche et dit : « Retourne vers Balac, et tu parleras ainsi. » ");
INSERT INTO francl_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Il retourna vers lui, et voici, Balac se tenait près de son holocauste, et les princes de Moab avec lui. Balac lui dit : « Qu’a dit Yahweh ? » ");
INSERT INTO francl_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Et Balaam prononça son discours, en disant : Lève-toi, Balac, et écoute : prête-moi l’oreille, fils de Séphor : ");
INSERT INTO francl_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Dieu n’est pas un homme pour mentir, ni un fils d’homme pour se repentir. Est-ce lui qui dit et ne fais pas, qui parle et n’exécute pas ? ");
INSERT INTO francl_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Voici, j’ai reçu ordre de bénir ; il a béni : je ne révoquerai point. ");
INSERT INTO francl_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Il n’aperçoit pas d’iniquité en Jacob, il ne voit pas d’injustice en Israël. Yahweh, son Dieu, est avec lui, chez lui retentit l’acclamation d’un roi. ");
INSERT INTO francl_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Dieu les fait sortir d’Égypte, sa vigueur est comme celle du buffle. ");
INSERT INTO francl_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Parce qu’il n’y a pas de magie en Jacob, ni de divination en Israël, en son temps il sera dit à Jacob et à Israël ce que Dieu veut accomplir. ");
INSERT INTO francl_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Voici un peuple qui se lève comme une lionne, et qui se dresse comme un lion ; il ne se couche pas qu’il n’ait dévoré sa proie, et qu’il n’ait bu le sang des blessés. ");
INSERT INTO francl_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Balac dit à Balaam : « Ne le maudis pas et ne le bénis pas. » ");
INSERT INTO francl_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Balaam répondit et dit à Balac : « Ne t’ai-je pas parlé ainsi : Je ferai tout ce que dira Yahweh ? » ");
INSERT INTO francl_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Balac dit à Balaam : « Viens donc, je te mènerai à une autre place ; peut-être plaira-t-il au regard de Dieu que de là tu me le maudisses. » ");
INSERT INTO francl_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Balac mena Balaam sur le sommet du Phogor, qui domine le désert. ");
INSERT INTO francl_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Et Balaam dit à Balac : « Bâtis-moi ici sept autels, et prépare-moi ici sept taureaux et sept béliers. » ");
INSERT INTO francl_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balac fit ce que Balaam avait dit, et il offrit un taureau et un bélier sur chaque autel. ");
INSERT INTO francl_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Balaam vit que Yahweh avait pour agréable de bénir Israël, et il n’alla pas, comme les autres fois, à la rencontre des signes magiques ; mais il tourna son visage du côté du désert. ");
INSERT INTO francl_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Ayant levé les yeux, il vit Israël campé par tribus ; et l’Esprit de Dieu fut sur lui, ");
INSERT INTO francl_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","et il prononça son discours, en disant : Oracle de Balaam fils de Béor, oracle de l’homme dont l’œil est fermé ; ");
INSERT INTO francl_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","oracle de celui qui entend les paroles de Dieu, qui contemple la vision du Tout-Puissant, qui tombe, et dont les yeux s’ouvrent. ");
INSERT INTO francl_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Qu’elles sont belles tes tentes, ô Jacob, tes demeures, ô Israël ! ");
INSERT INTO francl_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Elles s’étendent comme des vallées, comme des jardins au bord d’un fleuve, comme des aloès que Yahweh a plantés, comme des cèdres sur le bord des eaux. ");
INSERT INTO francl_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","L’eau déborde de ses deux seaux, sa race croît sur des eaux abondantes, son roi s’élève au-dessus d’Agag, et son royaume est exalté ! ");
INSERT INTO francl_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Dieu le fait sortir d’Égypte : il lui donne la vigueur du buffle. Il dévore les nations qui lui font la guerre. Il brise leurs os et les foudroie de ses flèches. ");
INSERT INTO francl_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Il ploie les genoux, il se couche comme un lion, comme une lionne ; qui le fera lever ? Béni soit qui te bénira et maudit soit qui te maudira ! ");
INSERT INTO francl_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","La colère de Balac s’enflamma contre Balaam, et il frappa des mains ; et Balac dit à Balaam : « Je t’ai appelé pour maudire mes ennemis, et voici, tu n’as fait que les bénir ces trois fois ! ");
INSERT INTO francl_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Et maintenant fuis, va-t’en chez toi ! J’avais dit que je te comblerais d’honneur ; et voici, Yahweh t’écarte de l’honneur. » ");
INSERT INTO francl_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Balaam répondit à Balac : « N’ai-je pas dit à tes messagers que tu m’as envoyés : ");
INSERT INTO francl_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","Quand Balac me donnerait plein sa maison d’argent et d’or, je ne pourrai transgresser l’ordre de Yahweh, en faisant de moi-même une chose bonne ou mauvaise ; mais ce que Yahweh me dira, je le dirai ? ");
INSERT INTO francl_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Et maintenant, voici, je m’en vais vers mon peuple ; viens donc, que je t’annonce ce que ce peuple fera à ton peuple dans la suite des jours. » ");
INSERT INTO francl_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Et Balaam prononça son discours et dit : Oracle de Balaam, fils de Béor, oracle de l’homme dont l’œil est fermé ; ");
INSERT INTO francl_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","oracle de celui qui entend les paroles de Dieu, qui connaît la science du Très-Haut, qui contemple la vision du Tout-puissant, qui tombe, et dont les yeux s’ouvrent. ");
INSERT INTO francl_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Je le vois, mais non comme présent ; je le contemple, mais non de près. Un astre sort de Jacob, un sceptre s’élève d’Israël. Il brise les deux flancs de Moab, il extermine tous les fils du tumulte. ");
INSERT INTO francl_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Edom est sa possession ; Séïr, son ennemi, est sa possession, et Israël déploie sa vaillance. ");
INSERT INTO francl_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","De Jacob sort un dominateur, il fait périr dans les villes ce qui reste d’Edom. ");
INSERT INTO francl_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Balaam vit Amalec, et il prononça son discours et dit : Amalec est la première des nations et sa fin sera la ruine. ");
INSERT INTO francl_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Balaam vit le Cinéen, et il prononça son discours et dit : Ta demeure est solide, et ton nid posé sur le roc. ");
INSERT INTO francl_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Toutefois le Cinéen ira se consumant ; jusqu’à quand ? Assur l’emmènera en captivité. ");
INSERT INTO francl_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Balaam prononça son discours et dit : Hélas ! qui subsistera quand Dieu fera cela ? ");
INSERT INTO francl_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Des navires viennent de Citthim ; ils oppriment Assur, ils oppriment Héber, et lui aussi est voué à la ruine. ");
INSERT INTO francl_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Balaam s’étant levé, se mit en route et s’en retourna chez lui ; Balac s’en alla aussi de son côté. ");
INSERT INTO francl_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Pendant qu’Israël demeurait à Settim, le peuple commença à se livrer à la débauche avec les filles de Moab. ");
INSERT INTO francl_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Elles invitèrent le peuple au sacrifice de leurs dieux. Et le peuple mangea et se prosterna devant leurs dieux. ");
INSERT INTO francl_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Israël s’attacha à Béelphégor, et la colère de Yahweh s’enflamma contre Israël. ");
INSERT INTO francl_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Yahweh dit à Moïse : « Assemble tous les chefs du peuple, et pends les coupables devant Yahweh, à la face du soleil, afin que le feu de la colère de Yahweh se détourne d’Israël. » ");
INSERT INTO francl_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Et Moïse dit aux juges d’Israël : « Que chacun de vous mette à mort ceux de ses gens qui se sont attachés à Béelphégor. » ");
INSERT INTO francl_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Et voici qu’un homme des enfants d’Israël vint et amena vers ses frères une Madianite, sous les yeux de Moïse et sous les yeux de toute l’assemblée des enfants d’Israël, qui pleuraient à l’entrée de la tente de réunion. ");
INSERT INTO francl_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","A cette vue, Phinées, fils d’Eléazar, fils d’Aaron, le prêtre, se leva du milieu de l’assemblée ; il prit une lance dans sa main, ");
INSERT INTO francl_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","suivit l’homme d’Israël dans l’arrière-tente, et les perça tous deux, l’homme d’Israël et la femme, par le ventre. Alors la plaie s’arrêta parmi les enfants d’Israël. ");
INSERT INTO francl_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Il y en eut vingt-quatre mille qui moururent de la plaie. ");
INSERT INTO francl_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","« Phinées, fils d’Eléazar, fils d’Aaron, le prêtre, a détourné ma fureur de dessus les enfants d’Israël, parce qu’il a été animé de ma jalousie au milieu d’eux ; et je n’ai point, dans ma jalousie, consumé les enfants d’Israël. ");
INSERT INTO francl_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","C’est pourquoi dis : Je lui accorde mon alliance de paix : ");
INSERT INTO francl_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","ce sera, pour lui et pour sa postérité après lui, l’alliance d’un sacerdoce perpétuel, parce qu’il a été jaloux pour son Dieu, et qu’il a fait l’expiation pour les enfants d’Israël. » ");
INSERT INTO francl_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","L’homme d’Israël qui fut tué avec la Madianite s’appelait Zamri, fils de Salu ; il était prince d’une maison patriarcale des Siméonites. ");
INSERT INTO francl_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","La femme Madianite qui fut tuée s’appelait Cozbi, fille de Sur, chef de tribu, de maison patriarcale en Madian. ");
INSERT INTO francl_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","« Traitez les Madianites en ennemis, et tuez-les ; ");
INSERT INTO francl_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","car ils ont agi en ennemis à votre égard, en vous séduisant par leurs ruses, au moyen de Phogor, au moyen de Cozbi, fille d’un chef de Madian, leur sœur, qui fut tuée le jour de la plaie survenue à l’occasion de Phogor. » ");
INSERT INTO francl_vpl VALUES ("NU25_19","005_25_19","NUM","25","19","19","A la suite de cette plaie, ");
INSERT INTO francl_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Yahweh parla à Moïse et à Eléazar, fils d’Aaron, le prêtre, en disant : ");
INSERT INTO francl_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","« Faites le compte de toute l’assemblée des enfants d’Israël depuis l’âge de vingt ans et au-dessus, selon leurs maisons patriarcales, de tous les hommes d’Israël en état de porter les armes. » ");
INSERT INTO francl_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Moïse et le prêtre Eléazar leur parlèrent donc dans les plaines de Moab, près du Jourdain, vis-à-vis de Jéricho, en disant : ");
INSERT INTO francl_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","« Vous ferez le recensement du peuple depuis l’âge de vingt ans et au-dessus, comme Yahweh l’a ordonné à Moïse et aux enfants d’Israël, à leur sortie du pays d’Égypte. » ");
INSERT INTO francl_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Ruben, premier-né d’Israël. Fils de Ruben : de Hénoch, la famille des Hénochites ; de Phallu, la famille des Phalluites ; ");
INSERT INTO francl_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","de Hesron, la famille des Hesronites ; de Charmi, la famille des Charmites. ");
INSERT INTO francl_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Telles sont les familles des Rubénites ; leurs recensés furent quarante-trois mille sept cent trente. — ");
INSERT INTO francl_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Fils de Phallu, Eliab. — ");
INSERT INTO francl_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","Fils d’Eliab : Namuel, Dathan et Abiron. C’est ce Dathan et cet Abiron, membres du conseil, qui se soulevèrent contre Moïse et Aaron, dans la troupe de Coré, lorsqu’elle se souleva contre Yahweh. ");
INSERT INTO francl_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","La terre, ouvrant sa bouche, les engloutit avec Coré, quand la troupe périt, et que le feu consuma les deux cent cinquante hommes : ils servirent d’exemple. ");
INSERT INTO francl_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Mais les fils de Coré ne moururent pas. ");
INSERT INTO francl_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Fils de Siméon, selon leurs familles : de Namuel, la famille des Namuélites ; de Jamin, la famille des Jaminites ; de Jachin, la famille des Jachinites ; ");
INSERT INTO francl_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","de Zaré la famille des Zaréites ; de Saül, la famille des Saülites. ");
INSERT INTO francl_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Telles sont les familles des Siméonites : vingt-deux mille deux cents. ");
INSERT INTO francl_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Fils de Gad, selon leurs familles : de Séphon, la famille des Séphonites ; d’Aggi, la famille des Aggites ; de Sunit, la famille des Sunites ; ");
INSERT INTO francl_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","d’Ozni, la famille des Oznites ; de Her, la famille des Hérites ; ");
INSERT INTO francl_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","d’Arod, la famille des Arodites ; d’Ariel, la famille des Ariélites. ");
INSERT INTO francl_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Telles sont les familles des fils de Gad, selon leurs recensés : quarante mille cinq cents. ");
INSERT INTO francl_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Fils de Juda : Her et Onan ; mais Her et Onan moururent au pays de Canaan. ");
INSERT INTO francl_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Voici les fils de Juda selon leurs familles : de Séla, la famille des Sélaïtes ; de Pharès, la famille des Pharésites ; de Zaré, la famille des Zaréites. — ");
INSERT INTO francl_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Les fils de Pharès furent : de Hesron, la famille des Hesronites ; de Hamul, la famille des Hamulites. — ");
INSERT INTO francl_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Telles sont les familles de Juda, selon leurs recensés : soixante-seize mille cinq cents. ");
INSERT INTO francl_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Fils d’Issachar selon leurs familles : de Thola, la famille des Tholaïtes ; de Phua, la famille des Phuaïtes ; ");
INSERT INTO francl_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","de Jasub, la famille des Jasubites ; de Semran, la famille des Semranites. ");
INSERT INTO francl_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Telles sont les familles d’Issachar, selon leurs recensés : soixante-quatre mille trois cents. ");
INSERT INTO francl_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Fils de Zabulon selon leurs familles : de Sared, la famille des Sarédites ; d’Elon, la famille des Elonites ; de Jalel, la famille des Jalélites. ");
INSERT INTO francl_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Telles sont les familles issues de Zabulon, selon leurs recensés : soixante mille cinq cents. ");
INSERT INTO francl_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Fils de Joseph selon leurs familles : Manassé et Ephraïm. ");
INSERT INTO francl_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Fils de Manassé : de Machir, la famille des Machirites. — Machir engendra Galaad ; de Galaad, la famille des Galaadites. — ");
INSERT INTO francl_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Voici les fils de Galaad : Jézer, d’où la famille des Jézérites ; de Hélec, la famille des Hélicites ; ");
INSERT INTO francl_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","Asriel, d’où la famille des Asriélites ; Séchem, d’où la famille des Séchémites ; ");
INSERT INTO francl_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","Sémida, d’où la famille de Sémidaïtes ; Hépher, d’où la famille des Héphrites. ");
INSERT INTO francl_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Salphaad, fils d’Hépher, n’eut pas de fils, mais il eut des filles. Voici les noms des filles de Salphaad : Maala, Noa, Hégla, Melcha et Thersa. — ");
INSERT INTO francl_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Telles sont les familles de Manassé ; leurs recensés furent cinquante-deux mille sept cents. ");
INSERT INTO francl_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Voici les fils d’Ephraïm selon leurs familles : de Suthala, la famille des Suthalaïtes ; de Bécher, la famille des Béchrites ; de Théhen, la famille des Théhénites. — ");
INSERT INTO francl_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Voici les fils de Suthala : d’Héran, la famille des Héranites. — ");
INSERT INTO francl_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Telles sont les familles des fils d’Ephraïm, selon leurs recensés : trente-deux mille cinq cents. Ce sont là les fils de Joseph, selon leurs familles. ");
INSERT INTO francl_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Fils de Benjamin, selon leurs familles : de Béla, la famille des Bélaïtes ; d’Asbel, la famille des Asbélites ; d’Ahiram, la famille des Ahiramites ; ");
INSERT INTO francl_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","de Supham, la famille des Suphamites ; de Hupham, la famille des Huphamites. — ");
INSERT INTO francl_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Les fils de Béla furent Héred et Noéman ; de Héred, la famille des Hérédites ; de Noéman, la famille des Noémanites. — ");
INSERT INTO francl_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Tels sont les fils de Benjamin, selon leurs familles, et leurs recensés furent quarante-cinq mille six cents. ");
INSERT INTO francl_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Voici les fils de Dan, selon leurs familles : de Suham descend la famille des Suhamites. Telles sont les familles de Dan, selon leurs familles. ");
INSERT INTO francl_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Total des familles des Suhamites, selon leurs recensés : soixante-quatre mille quatre cents. ");
INSERT INTO francl_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Fils d’Aser, selon leurs familles : de Jemna, la famille des Jemnites ; de Jessui, la famille des Jessuites ; de Brié, la famille des Briéïtes. — ");
INSERT INTO francl_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Des fils de Brié : de Héber, la famille des Hébrites ; de Melchiel, la famille des Melchiélites. — ");
INSERT INTO francl_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Le nom de la fille d’Aser était Sara. — ");
INSERT INTO francl_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Telles sont les familles des fils d’Aser, d’après leurs recensés : cinquante-trois mille quatre cents. ");
INSERT INTO francl_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Fils de Nephthali, selon leurs familles : de Jésiel, la famille des Jésiélites ; de Guni, la famille des Gunites ; ");
INSERT INTO francl_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","de Jéser, la famille des Jésérites ; de Sellem, la famille des Sélémites. ");
INSERT INTO francl_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Telles sont les familles de Nephthali, selon leurs familles, et leurs recensés furent quarante-cinq mille quatre cents. ");
INSERT INTO francl_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Tels sont les enfants d’Israël qui furent recensés : six cent un mille sept cent trente. ");
INSERT INTO francl_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","« A ceux-ci le pays sera partagé, pour être leur héritage, selon le nombre des noms. ");
INSERT INTO francl_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Aux plus nombreux tu donneras un héritage plus grand, et aux moins nombreux tu donneras un héritage plus petit ; on donnera à chacun son héritage selon ses recensés. ");
INSERT INTO francl_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Seulement le partage du pays aura lieu par le sort. Ils le recevront en partage selon les noms des tribus patriarcales. ");
INSERT INTO francl_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","C’est par le sort que l’héritage sera réparti aux plus nombreux comme à ceux qui le sont moins. » ");
INSERT INTO francl_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Voici, selon leurs familles, les Lévites qui furent recensés : de Gerson, la famille des Gersonites ; de Caath, la famille des Caathites ; de Mérari, la famille des Mérarites. — ");
INSERT INTO francl_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Voici les familles de Lévi ; la famille des Lobnites, la famille des Hébronites, la famille des Moholites, la famille des Musites et la famille des Coréïtes. — Caath engendra Amram, ");
INSERT INTO francl_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","et le nom de la femme d’Amram était Jochabed, fille de Lévi, que sa mère enfanta à Lévi en Égypte ; elle enfanta à Amram Aaron, Moïse et Marie, leur sœur. ");
INSERT INTO francl_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Il naquit à Aaron : Nadab et Abiu, Eléazar et Ithamar. ");
INSERT INTO francl_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Nadab et Abiu moururent lorsqu’ils apportèrent du feu étranger devant Yahweh. — ");
INSERT INTO francl_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Leurs recensés, tous les mâles depuis l’âge d’un mois et au-dessus, furent vingt-trois mille. Car ils ne furent pas compris dans le recensement des enfants d’Israël, parce qu’ils ne leur fut pas assigné d’héritage au milieu des enfants d’Israël. ");
INSERT INTO francl_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Tels sont les hommes recensés par Moïse et Eléazar, le prêtre, qui firent le recensement des enfants d’Israël dans les plaines de Moab, près du Jourdain, vis-à-vis de Jéricho. ");
INSERT INTO francl_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Parmi eux, il n’y avait aucun des enfants d’Israël dont Moïse et Aaron le prêtre avaient fait le recensement dans le désert de Sinaï ; ");
INSERT INTO francl_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","car Yahweh avait dit d’eux : « Ils mourront dans le désert » ; et il n’en resta pas un, excepté Caleb, fils de Jéphoné, et Josué, fils de Nun. ");
INSERT INTO francl_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Alors s’approchèrent les filles de Salphaad, fils de Hépher, fils de Galaad, fils de Machir, fils de Manassé, des familles de Manassé, le fils de Joseph ; leurs noms étaient Maala, Noa, Hégla, Melcha et Thersa. ");
INSERT INTO francl_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Elles se présentèrent devant Moïse, devant le prêtre Eléazar, et devant les princes de toute l’assemblée, à l’entrée de la tente de réunion, et elles dirent : ");
INSERT INTO francl_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","« Notre père est mort dans le désert ; il n’était pas au milieu de la troupe de ceux qui se liguèrent contre Yahweh, de la troupe de Coré, mais il est mort pour son péché, et il n’avait pas de fils. ");
INSERT INTO francl_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Pourquoi le nom de notre père serait-il retranché du milieu de sa famille, parce qu’il n’a pas eu de fils ? Donne-nous une propriété parmi les frères de notre père. » ");
INSERT INTO francl_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Moïse porta leur cause devant Yahweh ; ");
INSERT INTO francl_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","et Yahweh dit à Moïse : ");
INSERT INTO francl_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","« Les filles de Salphaad ont dit une chose juste. Tu leur donneras en héritage une propriété parmi les frères de leur père, et tu leur feras passer l’héritage de leur père. ");
INSERT INTO francl_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Tu parleras aux enfants d’Israël, en disant : Si un homme meurt sans avoir de fils, vous ferez passer son héritage à sa fille ; ");
INSERT INTO francl_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","et s’il n’a pas de fille, vous donnerez son héritage à ses frères. ");
INSERT INTO francl_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","S’il n’a pas de frères, vous donnerez son héritage aux frères de son père ; ");
INSERT INTO francl_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","et s’il n’y a pas de frères de son père, vous donnerez son héritage au parent le plus proche dans sa famille, et c’est lui qui le possédera. Ce sera pour les enfants d’Israël une règle de droit, comme Yahweh l’a ordonné à Moïse. » ");
INSERT INTO francl_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Yahweh dit à Moïse : « Monte sur cette montagne d’Abarim, et vois le pays que je donne aux enfants d’Israël. ");
INSERT INTO francl_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Tu le verras, et toi aussi tu seras recueilli auprès de ton peuple, comme Aaron, ton frère, a été recueilli, ");
INSERT INTO francl_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","parce que dans le désert de Sin, lors de la contestation de l’assemblée, vous avez été tous deux rebelles à l’ordre que j’avais donné de me sanctifier devant eux à l’occasion des eaux. Ce sont les eaux de Mériba, à Cadès, dans le désert de Sin. » ");
INSERT INTO francl_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Moïse parla à Yahweh, en disant : ");
INSERT INTO francl_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","« Que Yahweh, le Dieu des esprits de toute chair, établisse sur l’assemblée un homme ");
INSERT INTO francl_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","qui sorte devant eux et qui entre devant eux, qui les fasse sortir et qui les fasse entrer, afin que l’assemblée de Yahweh ne soit pas comme des brebis qui n’ont pas de berger. » ");
INSERT INTO francl_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Yahweh dit à Moïse : « Prends Josué, fils de Nun, homme en qui réside l’Esprit, et tu poseras ta main sur lui. ");
INSERT INTO francl_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Tu le placeras devant Eléazar, le prêtre, et devant toute l’assemblée, et tu l’installeras sous leurs yeux. ");
INSERT INTO francl_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Tu mettras sur lui une part de ton autorité, afin que toute l’assemblée des enfants d’Israël lui obéisse. ");
INSERT INTO francl_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Il se présentera devant le prêtre Eléazar, qui consultera pour lui le jugement de l’Urim devant Yahweh ; c’est sur son ordre que sortiront, sur son ordre qu’entreront, lui, Josué, tous les enfants d’Israël avec lui et toute l’assemblée. » ");
INSERT INTO francl_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Moïse fit ce que Yahweh lui avait ordonné. Il prit Josué, et il le plaça devant Eléazar, le prêtre, et devant toute l’assemblée. ");
INSERT INTO francl_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Et ayant posé ses mains sur lui, il l’installa, comme Yahweh l’avait dit par Moïse. ");
INSERT INTO francl_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","« Donne cet ordre aux enfants d’Israël et dis-leur : Vous aurez soin de me présenter, au temps fixé, mon offrande, mon aliment pour les sacrifices faits par le feu, qui sont pour moi d’agréable odeur. ");
INSERT INTO francl_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Tu leur diras : Voici le sacrifice par le feu que vous offrirez à Yahweh : chaque jour, deux agneaux d’un an, sans défaut, comme holocauste perpétuel. ");
INSERT INTO francl_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Tu offriras l’un des agneaux le matin, et le deuxième agneau entre les deux soirs, ");
INSERT INTO francl_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","et, pour l’oblation, un dixième d’épha de fleur de farine, pétrie avec un quart de hin d’huile d’olives concassées. ");
INSERT INTO francl_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","C’est l’holocauste perpétuel qui a été offert à la montagne de Sinaï, d’agréable odeur, un sacrifice par le feu à Yahweh. ");
INSERT INTO francl_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Sa libation sera d’un quart de hin pour chaque agneau ; c’est dans le lieu saint que tu feras la libation de vin pur à Yahweh. ");
INSERT INTO francl_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Tu offriras le second agneau entre les deux soirs ; tu feras comme pour l’oblation du matin et sa libation : c’est un sacrifice par le feu, d’une agréable odeur à Yahweh. ");
INSERT INTO francl_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","Le jour du sabbat, vous offrirez deux agneaux d’un an, sans défaut, et, comme oblation, deux dixièmes de fleur de farine pétrie à l’huile, et sa libation. ");
INSERT INTO francl_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","C’est l’holocauste du sabbat, pour chaque sabbat, outre l’holocauste perpétuel et sa libation. ");
INSERT INTO francl_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","Au commencement de vos mois, vous offrirez comme holocauste à Yahweh deux jeunes taureaux, un bélier et sept agneaux d’un an sans défaut, ");
INSERT INTO francl_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","et, comme oblation pour chaque taureau, trois dixièmes de fleur de farine pétrie à l’huile ; comme oblation pour le bélier, deux dixièmes de fleur de farine pétrie à l’huile ; ");
INSERT INTO francl_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","comme oblation pour chaque agneau, un dixième de fleur de farine pétrie à l’huile. C’est un holocauste d’agréable odeur, un sacrifice par le feu de Yahweh. ");
INSERT INTO francl_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Leurs libations seront d’un demi-hin de vin pour un taureau, d’un tiers de hin pour un bélier et d’un quart de hin pour un agneau. Tel est l’holocauste du commencement du mois, pour chaque mois, pour les mois de l’année. ");
INSERT INTO francl_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","On offrira aussi à Yahweh un bouc en sacrifice pour le péché, outre l’holocauste perpétuel et sa libation. ");
INSERT INTO francl_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","Au premier mois, le quatorzième jour du mois, ce sera la Pâque de Yahweh. ");
INSERT INTO francl_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Le quinzième jour de ce mois sera jour de fête. On mangera pendant sept jours des pains sans levain. ");
INSERT INTO francl_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Le premier jour, il y aura une sainte assemblée : vous ne ferez aucune œuvre servile. ");
INSERT INTO francl_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Vous offrirez en sacrifice par le feu un holocauste à Yahweh : deux jeunes taureaux, un bélier et sept agneaux d’un an, sans défaut, ");
INSERT INTO francl_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","et, comme leur oblation, de la fleur de farine pétrie à l’huile : trois dixièmes pour un taureau, deux dixièmes pour un bélier, ");
INSERT INTO francl_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","et un dixième pour chacun des sept agneaux. ");
INSERT INTO francl_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Vous offrirez aussi un bouc en sacrifice pour le péché, pour faire l’expiation pour vous. ");
INSERT INTO francl_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Vous ferez cela sans préjudice de l’holocauste du matin, qui est l’holocauste perpétuel. ");
INSERT INTO francl_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Vous ferez cela chaque jour, pendant sept jours ; c’est l’aliment d’un sacrifice par le feu, d’agréable odeur à Yahweh ; ainsi sera-t-il fait sans préjudice de l’holocauste perpétuel et de sa libation. ");
INSERT INTO francl_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Le septième jour, vous aurez une sainte assemblée : vous ne ferez aucune œuvre servile. ");
INSERT INTO francl_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","Au jour des prémices, quand vous présenterez à Yahweh une oblation de la moisson nouvelle, à votre fête des Semaines, vous aurez une sainte assemblée : vous ne ferez aucune œuvre servile. ");
INSERT INTO francl_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Vous offrirez comme holocauste d’agréable odeur à Yahweh deux jeunes taureaux, un bélier et sept agneaux d’un an, ");
INSERT INTO francl_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","et, comme leur oblation, de la fleur de farine pétrie à l’huile : trois dixièmes pour chaque taureau, deux dixièmes pour le bélier, ");
INSERT INTO francl_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","et un dixième pour chacun des sept agneaux. ");
INSERT INTO francl_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Vous offrirez aussi un bouc, pour faire l’expiation pour vous. Vous ferez cela sans préjudice de l’holocauste perpétuel et de son oblation. ");
INSERT INTO francl_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Vous aurez des victimes sans défaut ; et vous y joindrez leurs libations. ");
INSERT INTO francl_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","Au septième mois, le premier jour du mois, vous aurez une sainte assemblée : vous ne ferez aucune œuvre servile. Ce sera pour vous le jour du son éclatant des trompettes. ");
INSERT INTO francl_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Vous offrirez comme holocauste d’agréable odeur à Yahweh un jeune taureau, un bélier et sept agneaux d’un an, sans défaut, ");
INSERT INTO francl_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","et, comme leur oblation, de la fleur de farine pétrie à l’huile : trois dixièmes pour le taureau, deux dixièmes pour le bélier ");
INSERT INTO francl_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","et un dixième pour chacun des sept agneaux. ");
INSERT INTO francl_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Vous offrirez aussi un bouc en sacrifice pour le péché, pour faire l’expiation pour vous. ");
INSERT INTO francl_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Vous ferez cela sans préjudice de l’holocauste du mois et de son oblation, de l’holocauste perpétuel et de son oblation, et de leurs libations d’après les règles prescrites. Ce sont des sacrifices par le feu, d’agréable odeur à Yahweh. ");
INSERT INTO francl_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","Le dixième jour de ce septième mois, vous aurez une sainte assemblée et vous affligerez vos âmes : vous ne ferez aucune œuvre. ");
INSERT INTO francl_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Vous offrirez en holocauste d’agréable odeur à Yahweh un jeune taureau, un bélier et sept agneaux d’un an, sans défaut, ");
INSERT INTO francl_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","et, comme leur oblation, de la fleur de farine pétrie à l’huile : trois dixièmes pour le taureau, deux dixièmes pour le bélier ");
INSERT INTO francl_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","et un dixième pour chacun des sept agneaux. ");
INSERT INTO francl_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Vous offrirez aussi un bouc en sacrifice pour le péché, sans préjudice du sacrifice expiatoire, de l’holocauste perpétuel, de son oblation, et de leurs libations. ");
INSERT INTO francl_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","Le quinzième jour, du septième mois, vous aurez une sainte assemblée : vous ne ferez aucune œuvre servile. Et vous célébrerez une fête en l’honneur de Yahweh pendant sept jours. ");
INSERT INTO francl_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Vous offrirez un holocauste, sacrifice par le feu, d’agréable odeur à Yahweh : treize jeunes taureaux, deux béliers et quatorze agneaux d’un an, sans défaut, ");
INSERT INTO francl_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","et, comme leur oblation, de la fleur de farine pétrie à l’huile : trois dixièmes pour chacun des treize taureaux, deux dixièmes pour chacun des deux béliers, ");
INSERT INTO francl_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","et un dixième pour chacun des quatorze agneaux. ");
INSERT INTO francl_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Vous offrirez aussi un bouc en sacrifice pour le péché, sans préjudice de l’holocauste perpétuel avec son oblation et sa libation. ");
INSERT INTO francl_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","Le second jour, vous offrirez douze jeunes taureaux, deux béliers et quatorze agneaux d’un an, sans défaut, ");
INSERT INTO francl_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","avec leur oblation et leurs libations, pour les taureaux, les béliers et les agneaux, selon leur nombre, d’après la règle. ");
INSERT INTO francl_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","Vous offrirez aussi un bouc en sacrifice pour le péché, sans préjudice de l’holocauste perpétuel, de son oblation et de leurs libations. ");
INSERT INTO francl_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","Le troisième jour, vous offrirez onze taureaux, deux béliers et quatorze agneaux d’un an, sans défaut, ");
INSERT INTO francl_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","avec leur oblation et leurs libations, pour les taureaux, les béliers et les agneaux, selon leur nombre, d’après la règle. ");
INSERT INTO francl_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","Vous offrirez aussi un bouc en sacrifice pour le péché, sans préjudice de l’holocauste perpétuel, de son oblation et de sa libation. ");
INSERT INTO francl_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","Le quatrième jour, vous offrirez dix taureaux, deux béliers et quatorze agneaux d’un an, sans défaut, ");
INSERT INTO francl_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","avec leur oblation et leurs libations, pour les taureaux, les béliers et les agneaux, selon leur nombre d’après la règle. ");
INSERT INTO francl_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","Vous offrirez aussi un bouc en sacrifice pour le péché, sans préjudice de l’holocauste perpétuel, de son oblation et de sa libation. ");
INSERT INTO francl_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","Le cinquième jour, vous offrirez neuf taureaux, deux béliers et quatorze agneaux d’un an, sans défaut, ");
INSERT INTO francl_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","avec leur oblation et leurs libations, pour les taureaux, les béliers et les agneaux, selon leur nombre, d’après la règle. ");
INSERT INTO francl_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","Vous offrirez aussi un bouc en sacrifice pour le péché, sans préjudice de l’holocauste perpétuel, de son oblation et de sa libation. ");
INSERT INTO francl_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","Le sixième jour, vous offrirez huit taureaux, deux béliers et quatorze agneaux d’un an, sans défaut, ");
INSERT INTO francl_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","avec leur oblation et leurs libations, pour les taureaux, les béliers et les agneaux, selon leur nombre, d’après la règle. ");
INSERT INTO francl_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","Vous offrirez aussi un bouc en sacrifice pour le péché, sans préjudice de l’holocauste perpétuel, de son oblation et de sa libation. ");
INSERT INTO francl_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","Le septième jour, vous offrirez sept taureaux, deux béliers et quatorze agneaux d’un an, sans défaut, ");
INSERT INTO francl_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","avec leur oblation et leurs libations, pour les taureaux, les béliers et les agneaux, selon leur nombre, d’après la règle. ");
INSERT INTO francl_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","Vous offrirez aussi un bouc en sacrifice pour le péché, sans préjudice de l’holocauste perpétuel, de son oblation et de sa libation. ");
INSERT INTO francl_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","Le huitième jour, vous aurez une assemblée solennelle : vous ne ferez aucune œuvre servile. ");
INSERT INTO francl_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Vous offrirez un holocauste, un sacrifice par le feu d’agréable odeur à Yahweh : un taureau, un bélier et sept agneaux d’un an, sans défaut, ");
INSERT INTO francl_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","avec leur oblation et leurs libations, pour le taureau, le bélier et les agneaux, selon leur nombre, d’après la règle. ");
INSERT INTO francl_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Vous offrirez aussi un bouc en sacrifice pour le péché, sans préjudice de l’holocauste perpétuel, de son oblation et de sa libation. ");
INSERT INTO francl_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","Tels sont les sacrifices que vous offrirez à Yahweh dans vos fêtes, sans préjudice de vos vœux et de vos offrandes volontaires : vos holocaustes, vos oblations, vos libations et vos sacrifices pacifiques. » ");
INSERT INTO francl_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Moïse parla aux enfants d’Israël selon tout ce que Yahweh lui avait ordonné : ");
INSERT INTO francl_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Moïse parla aux chefs des tribus des enfants d’Israël, en disant : « Voici ce que Yahweh ordonne : ");
INSERT INTO francl_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","Si un homme fait un vœu à Yahweh ou s’il fait un serment pour s’imposer à soi-même un engagement, il ne violera pas sa parole ; tout ce qui est sorti de sa bouche, il le fera. ");
INSERT INTO francl_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","Si une femme, encore jeune fille dans la maison de son père, fait un vœu à Yahweh et se lie par un engagement, ");
INSERT INTO francl_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","et que son père apprenne son vœu et l’engagement qu’elle s’est imposé à elle-même, et que son père garde le silence envers elle, tous ses vœux qu’elle aura faits et tout engagement qu’elle s’est imposé à elle-même seront valables ; ");
INSERT INTO francl_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","mais si, le jour où il en a connaissance, son père la désavoue, tous ses vœux et tous les engagements qu’elle s’est imposé à elle-même seront sans valeur ; et Yahweh lui pardonnera, parce que son père l’a désavouée. ");
INSERT INTO francl_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","Si elle se marie, et que pèsent sur elle ses vœux ou une parole imprudemment sortie de ses lèvres par laquelle elle s’est imposé à elle-même un engagement, ");
INSERT INTO francl_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","et si son mari, l’apprenant, garde le silence envers elle le jour où il l’apprendra, ses vœux seront valables, ainsi que ses engagements qu’elle s’est imposé à elle-même ; ");
INSERT INTO francl_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","mais si, le jour où il l’apprend, son mari la désavoue, il rend nul son vœu qui pèse sur elle et la parole imprudemment sortie de ses lèvres par laquelle elle s’est imposé à elle-même un engagement ; et Yahweh lui pardonnera. ");
INSERT INTO francl_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","Le vœu d’une femme veuve ou répudiée, tout engagement qu’elle s’est imposé à elle-même, seront valables pour elle. ");
INSERT INTO francl_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","Si c’est dans la maison de son mari qu’une femme a fait un vœu ou s’est imposé à elle-même un engagement par un serment, ");
INSERT INTO francl_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","et que son mari, l’apprenant, garde le silence envers elle et ne la désavoue pas, tous ses vœux seront valables, ainsi que tous les engagements qu’elle s’est imposé à elle-même ; ");
INSERT INTO francl_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","mais si, le jour où il l’apprend, son mari les annule, tout ce qui est sorti de ses lèvres, vœux ou engagements, sera sans valeur : son mari les a annulés ; et Yahweh lui pardonnera. ");
INSERT INTO francl_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Tout vœu et tout serment par lequel elle s’engage à affliger son âme, son mari peut les ratifier et son mari peut les annuler. ");
INSERT INTO francl_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Si son mari garde d’un jour à l’autre le silence envers elle, il ratifie ainsi tous ses vœux ou tous ses engagements qui pèsent sur elle ; il les ratifie, parce qu’il a gardé le silence envers elle le jour où il l’a appris. ");
INSERT INTO francl_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","S’il les annule après le jour où il l’a appris, il portera l’iniquité de sa femme. » ");
INSERT INTO francl_vpl VALUES ("NU30_17","005_30_17","NUM","30","17","17","Telles sont les lois que Yahweh prescrivit à Moïse, entre un mari et sa femme, entre un père et sa fille, lorsqu’elle est jeune encore et dans la maison de son père. ");
INSERT INTO francl_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","« Venge les enfants d’Israël sur les Madianites ; tu seras ensuite recueilli auprès de ton peuple. » ");
INSERT INTO francl_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Moïse parla au peuple, en disant : « Armez pour la guerre des hommes d’entre vous, et qu’ils marchent contre Madian, pour exécuter la vengeance de Yahweh sur Madian. ");
INSERT INTO francl_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Vous enverrez à la guerre mille hommes par tribu, de toutes les tribus d’Israël. » ");
INSERT INTO francl_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","On leva donc d’entre les milliers d’Israël mille hommes par tribu, soit douze mille hommes armés pour la guerre. ");
INSERT INTO francl_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Moïse les envoya au combat, mille hommes par tribu, eux et Phinées, le fils d’Eléazar, le prêtre, qui avait avec lui les instruments sacrés et les trompettes retentissantes. ");
INSERT INTO francl_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Ils s’avancèrent contre Madian, selon l’ordre que Yahweh avait donné à Moïse, et ils tuèrent tous les mâles. ");
INSERT INTO francl_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Outre ceux qui étaient tombés dans la bataille, ils tuèrent les rois de Madian : Evi, Récem, Sur, Hur et Rebé, cinq rois de Madian ; ils tuèrent aussi par l’épée Balaam, fils de Béor. ");
INSERT INTO francl_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Les enfants d’Israël firent prisonnières les femmes des Madianites avec leurs petits enfants, et ils pillèrent toutes leurs bêtes de somme, tous leurs troupeaux et tous leurs biens. ");
INSERT INTO francl_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Ils livrèrent aux flammes toutes les villes du pays qu’ils habitaient et tous leurs campements. ");
INSERT INTO francl_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Ayant pris tout le butin et toutes les dépouilles, gens et bestiaux, ");
INSERT INTO francl_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","ils amenèrent les prisonniers, les dépouilles et le butin à Moïse, à Eléazar, le prêtre, et à l’assemblée des enfants d’Israël, au camp, dans les plaines de Moab, près du Jourdain, vis-à-vis de Jéricho. ");
INSERT INTO francl_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Moïse, Eléazar, le prêtre, et tous les princes de l’assemblée sortirent au-devant d’eux, hors du camp. ");
INSERT INTO francl_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Et Moïse s’irrita contre les commandants de l’armée, les chefs de milliers et les chefs de centaines, qui revenaient du combat. ");
INSERT INTO francl_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Il leur dit : « Avez-vous donc laissé la vie à toutes les femmes ? ");
INSERT INTO francl_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Voici, ce sont elles qui, sur la parole de Balaam, ont entraîné les enfants d’Israël à l’infidélité envers Yahweh, dans l’affaire de Phogor ; et alors la plaie fut dans l’assemblée de Yahweh. ");
INSERT INTO francl_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Maintenant, tuez tout mâle parmi les petits enfants, et tuez toute femme qui a connu la couche d’un homme ; ");
INSERT INTO francl_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","mais toutes les filles qui n’ont pas connu la couche d’un homme, laissez-les vivre pour vous. ");
INSERT INTO francl_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","Et vous, campez hors du camp pendant sept jours ; quiconque a tué quelqu’un et quiconque a touché un mort se purifiera le troisième jour et le septième jour, lui et vos prisonniers. ");
INSERT INTO francl_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Vous purifierez aussi tout vêtement, tout objet de peau, tout ouvrage de poil de chèvre et tout ustensile de bois. » ");
INSERT INTO francl_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Eléazar, le prêtre, dit aux hommes de guerre qui étaient allés au combat : « Voici ce qui est commandé par la loi que Yahweh a prescrite à Moïse : ");
INSERT INTO francl_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","l’or, l’argent, l’airain, le fer, l’étain et le plomb, ");
INSERT INTO francl_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","tout objet qui va au feu, vous le ferez passer par le feu, et il sera pur ; toutefois il sera purifié encore par l’eau de purification. Tout ce qui ne va pas au feu, vous le ferez passer par l’eau. ");
INSERT INTO francl_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Vous laverez vos vêtements, le septième jour, et vous serez purs ; vous pourrez ensuite entrer dans le camp. » ");
INSERT INTO francl_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Yahweh parla à Moïse, en disant : ");
INSERT INTO francl_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","« Fais, toi et Eléazar, le prêtre, et les chefs de maisons de l’assemblée, le compte de ce qui a été pris des dépouilles en hommes et en bestiaux, ");
INSERT INTO francl_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","et partage les dépouilles entre les combattants qui sont allés à la guerre et toute l’assemblée. ");
INSERT INTO francl_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Tu prélèveras sur la part des soldats qui sont allés à la guerre un tribut pour Yahweh, savoir un sur cinq cents, gens, bœufs, ânes et brebis. ");
INSERT INTO francl_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Vous le prendrez sur leur moitié et tu le donneras à Eléazar, le prêtre, comme prélèvement de Yahweh. ");
INSERT INTO francl_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Sur la moitié qui revient aux enfants d’Israël, tu mettras à part un sur cinquante, gens, bœufs, ânes, brebis et tout bétail, et tu le donneras aux Lévites, qui ont la garde de la Demeure de Yahweh. » ");
INSERT INTO francl_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Moïse et Eléazar, le prêtre, firent comme Yahweh l’avait ordonné à Moïse. ");
INSERT INTO francl_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Les dépouilles, le reste du butin qu’avaient fait les combattants étaient de six cent soixante-quinze mille brebis, ");
INSERT INTO francl_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","soixante-douze mille bœufs, ");
INSERT INTO francl_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","soixante et un mille ânes, ");
INSERT INTO francl_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","et trente-deux mille d’entre les femmes qui n’avaient pas connu la couche d’un homme. ");
INSERT INTO francl_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","La moitié, part de ceux qui étaient allés à la guerre, fut de trois cent trente-sept mille cinq cents brebis, ");
INSERT INTO francl_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","six cent soixante-quinze brebis pour le tribut de Yahweh ; ");
INSERT INTO francl_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","trente-six mille bœufs, dont soixante-douze pour le tribut de Yahweh ; ");
INSERT INTO francl_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","trente mille cinq cents ânes, dont soixante-et-un pour le tribut de Yahweh ; ");
INSERT INTO francl_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","et seize mille personnes, trente-deux personnes pour le tribut de Yahweh. ");
INSERT INTO francl_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Moïse donna à Eléazar, le prêtre, le tribut prélevé pour Yahweh, ainsi que Yahweh l’avait ordonné à Moïse. ");
INSERT INTO francl_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Quant à la moitié revenant aux enfants d’Israël, que Moïse avait séparée de celle des combattants, ");
INSERT INTO francl_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","cette moitié formant la part de l’assemblée fut de trois cent trente-sept mille cinq cents brebis, ");
INSERT INTO francl_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","trente-six mille bœufs, ");
INSERT INTO francl_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","trente mille cinq cents ânes ");
INSERT INTO francl_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","et seize mille personnes. ");
INSERT INTO francl_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Sur cette moitié qui revenait aux enfants d’Israël, Moïse prit un sur cinquante et le donna aux Lévites, qui ont la garde de la Demeure de Yahweh, ainsi que Yahweh l’avait ordonné à Moïse. ");
INSERT INTO francl_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Les commandants des milliers de l’armée, les chefs de milliers et les chefs de centaines, s’approchèrent de Moïse ");
INSERT INTO francl_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","et lui dirent : « Tes serviteurs ont compté les combattants qui étaient sous nos ordres, et il ne manque pas un homme d’entre nous. ");
INSERT INTO francl_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","C’est pourquoi nous apportons comme offrande à Yahweh les objets d’or que chacun de nous a trouvés, bracelets, chaînettes, anneaux, pendants d’oreilles et colliers, pour faire l’expiation pour nous devant Yahweh. » ");
INSERT INTO francl_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Moïse et Eléazar, le prêtre, reçurent d’eux cet or, tous ces objets bien travaillés. ");
INSERT INTO francl_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Tout l’or prélevé qu’ils présentèrent à Yahweh de la part des chefs de milliers et des chefs de centaines, fut de seize mille sept cent cinquante sicles. ");
INSERT INTO francl_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Les hommes de la troupe eurent chacun leur butin pour eux. ");
INSERT INTO francl_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Moïse et Eléazar, le prêtre, ayant pris l’or des chefs de milliers et des chefs de centaines, l’apportèrent dans la tente de réunion, comme mémorial pour les enfants d’Israël devant Yahweh. ");
INSERT INTO francl_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Les fils de Ruben et les fils de Gad avaient des troupeaux en nombre considérable. Voyant que le pays de Jazer et le pays de Galaad étaient un lieu propre pour les troupeaux, ");
INSERT INTO francl_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","les fils de Gad et les fils de Ruben vinrent auprès de Moïse, d’Eléazar, le prêtre, et des princes de l’assemblée, et ils leur dirent : ");
INSERT INTO francl_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","« Ataroth, Dibon, Jazer, Nemra, Hésebon, Eléalé, Saban, Nébo et Béon, ");
INSERT INTO francl_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","ce pays que Yahweh a frappé devant l’assemblée d’Israël, est un lieu propre pour les troupeaux, et tes serviteurs ont des troupeaux ». ");
INSERT INTO francl_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Ils ajoutèrent : « Si nous avons trouvé grâce à tes yeux, que ce pays soit donné en possession à tes serviteurs, et ne nous fais pas passer le Jourdain. » ");
INSERT INTO francl_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Moïse répondit aux fils de Gad et aux fils de Ruben : « Vos frères iront-ils à la guerre, et vous, resterez-vous ici ? ");
INSERT INTO francl_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Pourquoi découragez-vous les enfants d’Israël de passer dans le pays que Yahweh leur donne ? ");
INSERT INTO francl_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","C’est ainsi qu’ont fait vos pères, quand je les envoyai de Cadès-Barné explorer le pays. ");
INSERT INTO francl_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Ils montèrent jusqu’à la vallée d’Escol et virent le pays, et ils découragèrent les enfants d’Israël d’entrer dans le pays que Yahweh leur donnait. ");
INSERT INTO francl_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Et la colère de Yahweh s’enflamma ce jour-là, et il jura en disant : ");
INSERT INTO francl_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","Ces hommes qui sont montés de l’Égypte, depuis l’âge de vingt ans et au-dessus, ne verront pas le pays que j’ai promis par serment à Abraham, à Isaac et à Jacob, car ils ne m’ont pas fidèlement suivi, ");
INSERT INTO francl_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","excepté Caleb, fils de Jéphoné, le Cénézéen, et Josué, fils de Nun, qui ont suivi fidèlement Yahweh. ");
INSERT INTO francl_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Et la colère de Yahweh s’enflamma contre Israël, et il les fit errer dans le désert pendant quarante années, jusqu’à ce que fût anéantie toute la génération qui avait fait le mal aux yeux de Yahweh. ");
INSERT INTO francl_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","Et voici que vous prenez la place de vos pères, comme des rejetons de pécheurs, pour accroître encore l’ardeur de la colère de Yahweh contre Israël. ");
INSERT INTO francl_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Car si vous refusez de le suivre, il continuera de laisser Israël au désert, et vous causerez la ruine de tout ce peuple. » ");
INSERT INTO francl_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Ils s’approchèrent de Moïse, et ils dirent : « Nous construirons ici des parcs pour nos troupeaux et des villes pour nos petits enfants ; ");
INSERT INTO francl_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","mais nous nous armerons sans tarder pour marcher devant les enfants d’Israël, jusqu’à ce que nous les ayons introduits dans le lieu qu’ils doivent occuper, et nos enfants demeureront dans les villes fortes, à cause des habitants du pays. ");
INSERT INTO francl_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Nous ne reviendrons pas dans nos maisons, avant que les enfants d’Israël aient pris possession chacun de son héritage ; ");
INSERT INTO francl_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","car nous ne posséderons rien avec eux de l’autre côté du Jourdain, ni plus loin, puisque notre héritage nous est venu de ce côté du Jourdain, à l’orient. » ");
INSERT INTO francl_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Moïse leur dit : « Si vous tenez cette conduite, si vous vous armez pour combattre devant Yahweh ; ");
INSERT INTO francl_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","si tous les hommes armés d’entre vous passent le Jourdain devant Yahweh, jusqu’à ce qu’il ait chassé ses ennemis de devant sa face, ");
INSERT INTO francl_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","et que vous ne reveniez qu’après que le pays aura été soumis devant Yahweh, vous serez sans reproche devant Yahweh et devant Israël, et cette contrée-ci sera votre propriété devant Yahweh. ");
INSERT INTO francl_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","Mais si vous n’agissez pas ainsi, voici, vous péchez contre Yahweh ; et sachez que votre péché vous atteindra. ");
INSERT INTO francl_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Construisez donc des villes pour vos enfants et des parcs pour vos troupeaux, et exécutez la parole qui est sortie de votre bouche. » ");
INSERT INTO francl_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Les fils de Gad et les fils de Ruben parlèrent à Moïse en disant : « Tes serviteurs feront ce que mon seigneur ordonne. ");
INSERT INTO francl_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Nos enfants, nos femmes, nos troupeaux et tout notre bétail resteront ici, dans les villes de Galaad ; ");
INSERT INTO francl_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","et tes serviteurs, tout homme armé pour combattre, passeront devant Yahweh pour combattre, comme le dit mon seigneur. » ");
INSERT INTO francl_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Alors Moïse donna des ordres à leur sujet à Eléazar, le prêtre, à Josué, fils de Nun, et aux chefs de famille des tribus des enfants d’Israël ; ");
INSERT INTO francl_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","il leur dit : « Si les fils de Gad et les fils de Ruben passent avec vous le Jourdain, tous les hommes armés pour combattre devant Yahweh, et que le pays sois soumis devant vous, vous leur donnerez en possession la conquête de Galaad. ");
INSERT INTO francl_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Mais s’ils ne passent pas en armes avec vous, ils seront établis au milieu de vous dans le pays de Canaan. » ");
INSERT INTO francl_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Les fils de Gad et les fils de Ruben répondirent en disant : « Ce que Yahweh a dit à tes serviteurs, nous le ferons. ");
INSERT INTO francl_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Nous passerons en armes devant Yahweh au pays de Canaan, et la possession de notre héritage nous demeurera de ce côté-ci du Jourdain. » ");
INSERT INTO francl_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Moïse donna aux fils de Gad et aux fils de Ruben, et à la moitié de la tribu de Manassé, fils de Joseph, le royaume de Séhon, roi des Amorrhéens, et le royaume d’Og, roi de Basan, le pays avec ses villes et leurs territoires, les villes du pays d’alentour. ");
INSERT INTO francl_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Les fils de Gad bâtirent Dibon, Ataroth, Aroër, ");
INSERT INTO francl_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Ataroth-Sophan, Jazer, Jegbaa, ");
INSERT INTO francl_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Bethnemra et Betharan, villes fortes, et ils firent des parcs pour le troupeau. ");
INSERT INTO francl_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Les fils de Ruben bâtirent Hésebon, Eléalé, Cariathaïm, ");
INSERT INTO francl_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","Nabo et Baalméon, dont les noms furent changés, et Sabama, et ils donnèrent des noms aux villes qu’ils bâtirent. ");
INSERT INTO francl_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Les fils de Machir, fils de Manassé, allèrent contre Galaad et, s’en étant emparés, ils chassèrent les Amorrhéens qui y étaient. ");
INSERT INTO francl_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40